
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  258 ( 1991),  selected  258 , name 2h0a_A
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 2h0a_A.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T    65_A      Y      71          5.041
LGA    V    66_A      S      72          3.005
LGA    S    67_A      I      73          1.887
LGA    V    68_A      A      74          1.423
LGA    L    69_A      L      75          0.955
LGA    L    70_A      I      76          0.902
LGA    P    71_A      I      77          1.215
LGA    F    72_A      P      78          1.661
LGA    V    73_A      S      79          2.099
LGA    A    74_A      L      80          1.325
LGA    T    75_A      F      81          1.608
LGA    E    76_A      E      82          3.315
LGA    F    77_A      K      83          2.017
LGA    -       -      A      84           -
LGA    Y    78_A      C      85          1.208
LGA    R    79_A      A      86          0.557
LGA    R    80_A      H      87          0.933
LGA    L    81_A      F      88          1.781
LGA    V    82_A      L      89          1.142
LGA    E    83_A      P      90          2.570
LGA    G    84_A      S      91          3.421
LGA    I    85_A      F      92          1.146
LGA    E    86_A      Q      93          1.796
LGA    G    87_A      Q      94          3.191
LGA    V    88_A      A      95          1.745
LGA    L    89_A      L      96          1.187
LGA    L    90_A      N      97          2.095
LGA    E    91_A      K      98          2.292
LGA    Q    92_A      A      99          1.727
LGA    R    93_A      G     100          2.332
LGA    Y    94_A      Y     101          1.923
LGA    D    95_A      Q     102          1.917
LGA    L    96_A      L     103          1.726
LGA    A    97_A      L     104          1.942
LGA    L    98_A      L     105          2.103
LGA    F    99_A      G     106          0.735
LGA    P   100_A      Y     107          0.808
LGA    I   101_A      S     108          1.566
LGA    -       -      D     109           -
LGA    -       -      Y     110           -
LGA    L   102_A      S     111          2.947
LGA    S   103_A      I     112          3.157
LGA    L   104_A      E     113          3.320
LGA    -       -      Q     114           -
LGA    -       -      E     115           -
LGA    -       -      E     116           -
LGA    A   105_A      K     117          3.026
LGA    R   106_A      L     118           #
LGA    -       -      L     119           -
LGA    L   107_A      S     120          2.700
LGA    K   108_A      T     121          2.907
LGA    -       -      F     122           -
LGA    -       -      L     123           -
LGA    -       -      E     124           -
LGA    Y   118_A      S     125          1.601
LGA    L   119_A      R     126          2.463
LGA    T   120_A      P     127          4.958
LGA    D   121_A      A     128          2.016
LGA    G   122_A      G     129          1.852
LGA    L   123_A      V     130          0.901
LGA    I   124_A      V     131          1.057
LGA    L   125_A      L     132          0.523
LGA    A   126_A      F     133          1.354
LGA    S   127_A      G     134          2.591
LGA    Y   128_A      S     135          4.177
LGA    D   129_A      E     136          3.484
LGA    L   130_A      H     137          2.773
LGA    T   131_A      S     138          1.568
LGA    -       -      Q     139           -
LGA    -       -      R     140           -
LGA    -       -      T     141           -
LGA    R   138_A      H     142          2.999
LGA    L   139_A      Q     143          4.334
LGA    P   140_A      L     144          1.227
LGA    T   141_A      L     145          3.727
LGA    -       -      E     146           -
LGA    -       -      A     147           -
LGA    -       -      S     148           -
LGA    E   142_A      N     149          3.604
LGA    R   143_A      T     150          2.597
LGA    P   144_A      P     151          1.610
LGA    V   145_A      V     152          1.203
LGA    V   146_A      L     153          1.123
LGA    L   147_A      E     154          1.183
LGA    V   148_A      I     155          1.222
LGA    D   149_A      A     156          2.573
LGA    A   150_A      E     157          4.123
LGA    Q   151_A      L     158          2.597
LGA    N   152_A      S     159          1.801
LGA    -       -      S     160           -
LGA    -       -      K     161           -
LGA    P   153_A      A     162          2.032
LGA    R   154_A      S     163          1.894
LGA    Y   155_A      Y     164          0.511
LGA    D   156_A      L     165          0.603
LGA    S   157_A      N     166          0.644
LGA    V   158_A      I     167          0.522
LGA    Y   159_A      G     168          1.383
LGA    L   160_A      V     169          0.965
LGA    D   161_A      D     170          1.552
LGA    N   162_A      H     171          1.379
LGA    R   163_A      F     172          1.420
LGA    L   164_A      E     173          0.886
LGA    G   165_A      V     174          1.497
LGA    G   166_A      G     175          1.321
LGA    R   167_A      K     176          1.264
LGA    L   168_A      A     177          0.596
LGA    A   169_A      C     178          1.343
LGA    G   170_A      T     179          1.601
LGA    A   171_A      R     180          0.633
LGA    Y   172_A      H     181          0.540
LGA    L   173_A      L     182          1.002
LGA    A   174_A      I     183          0.831
LGA    R   175_A      E     184          3.177
LGA    -       -      Q     185           -
LGA    F   176_A      G     186          2.693
LGA    P   177_A      F     187          3.770
LGA    G   178_A      K     188           #
LGA    P   179_A      N     189          2.332
LGA    I   180_A      V     190          1.101
LGA    F   181_A      G     191          0.635
LGA    A   182_A      F     192          0.782
LGA    I   183_A      I     193          1.215
LGA    A   184_A      G     194          3.065
LGA    V   185_A      A     195          2.018
LGA    E   186_A      R     196          3.859
LGA    E   187_A      G     197          4.422
LGA    E   188_A      N     198          4.530
LGA    P   189_A      -       -           -
LGA    D   190_A      -       -           -
LGA    R   191_A      H     199           #
LGA    R   195_A      S     200          2.607
LGA    T   196_A      -       -           -
LGA    V   197_A      T     201          1.782
LGA    F   198_A      L     202          1.811
LGA    A   199_A      Q     203          1.719
LGA    E   200_A      R     204          1.674
LGA    R   201_A      Q     205          1.615
LGA    M   202_A      L     206          1.879
LGA    A   203_A      H     207          1.894
LGA    G   204_A      G     208          2.280
LGA    F   205_A      W     209          1.682
LGA    Q   206_A      Q     210          1.951
LGA    E   207_A      S     211          1.977
LGA    A   208_A      A     212          1.996
LGA    L   209_A      M     213          2.307
LGA    K   210_A      I     214          2.766
LGA    E   211_A      E     215          2.836
LGA    A   212_A      N     216          3.263
LGA    G   213_A      -       -           -
LGA    R   214_A      Y     217          4.701
LGA    P   215_A      L     218          1.592
LGA    F   216_A      T     219          3.241
LGA    S   217_A      P     220          2.447
LGA    P   218_A      D     221          1.491
LGA    D   219_A      H     222          3.748
LGA    R   220_A      F     223          4.862
LGA    L   221_A      L     224          4.634
LGA    Y   222_A      T     225          5.154
LGA    I   223_A      T     226          4.733
LGA    T   224_A      H     227           #
LGA    R   225_A      E     228          3.230
LGA    H   226_A      A     229          3.059
LGA    S   227_A      P     230          2.162
LGA    -       -      S     231           -
LGA    Q   228_A      S     232          1.546
LGA    E   229_A      Q     233          1.440
LGA    G   230_A      L     234          1.170
LGA    G   231_A      G     235          1.105
LGA    R   232_A      A     236          1.215
LGA    L   233_A      E     237          1.125
LGA    A   234_A      G     238          0.487
LGA    L   235_A      L     239          0.619
LGA    R   236_A      A     240          0.882
LGA    H   237_A      K     241          1.064
LGA    F   238_A      L     242          1.926
LGA    L   239_A      L     243          2.139
LGA    E   240_A      L     244          2.162
LGA    K   241_A      R     245          3.829
LGA    -       -      D     246           -
LGA    A   242_A      S     247          0.984
LGA    S   243_A      S     248          5.509
LGA    P   244_A      -       -           -
LGA    P   245_A      L     249           #
LGA    L   246_A      N     250          1.435
LGA    N   247_A      A     251          0.263
LGA    V   248_A      L     252          0.230
LGA    F   249_A      V     253          0.257
LGA    A   250_A      C     254          0.664
LGA    G   251_A      S     255          1.505
LGA    A   252_A      H     256          1.600
LGA    D   253_A      E     257          1.566
LGA    Q   254_A      E     258          2.132
LGA    V   255_A      I     259          1.304
LGA    A   256_A      A     260          1.204
LGA    L   257_A      I     261          1.641
LGA    G   258_A      G     262          1.247
LGA    V   259_A      A     263          0.912
LGA    L   260_A      L     264          1.640
LGA    E   261_A      F     265          2.236
LGA    E   262_A      E     266          1.900
LGA    A   263_A      C     267          1.972
LGA    V   264_A      H     268          2.361
LGA    R   265_A      R     269          2.942
LGA    L   266_A      R     270          3.315
LGA    G   267_A      V     271          2.409
LGA    L   268_A      L     272          5.230
LGA    T   269_A      -       -           -
LGA    P   270_A      -       -           -
LGA    G   271_A      -       -           -
LGA    R   272_A      K     273          1.876
LGA    D   273_A      V     274          4.650
LGA    -       -      P     275           -
LGA    -       -      T     276           -
LGA    -       -      D     277           -
LGA    V   274_A      I     278          2.246
LGA    R   275_A      A     279          1.765
LGA    V   276_A      I     280          1.451
LGA    L   277_A      I     281          0.737
LGA    G   278_A      C     282          0.880
LGA    F   279_A      L     283          1.103
LGA    D   280_A      E     284          1.680
LGA    G   281_A      G     285          2.869
LGA    H   282_A      S     286          2.661
LGA    P   283_A      S     287          3.619
LGA    F   284_A      M     288          2.101
LGA    A   285_A      G     289          2.549
LGA    E   286_A      E     290          1.912
LGA    E   287_A      H     291          2.081
LGA    A   288_A      A     292          2.446
LGA    -       -      Y     293           -
LGA    -       -      P     294           -
LGA    G   289_A      S     295          2.184
LGA    L   290_A      L     296          2.392
LGA    S   291_A      T     297          1.527
LGA    T   292_A      S     298          1.158
LGA    I   293_A      A     299          1.876
LGA    A   294_A      E     300          1.812
LGA    Q   295_A      F     301          2.468
LGA    P   296_A      D     302          2.605
LGA    V   297_A      Y     303          2.171
LGA    E   298_A      E     304          2.299
LGA    A   299_A      R     305          2.107
LGA    M   300_A      M     306          2.210
LGA    G   301_A      G     307          2.633
LGA    A   302_A      T     308          2.068
LGA    R   303_A      K     309          1.529
LGA    A   304_A      A     310          1.356
LGA    A   305_A      A     311          1.100
LGA    Q   306_A      E     312          0.800
LGA    L   307_A      K     313          0.891
LGA    L   308_A      L     314          0.799
LGA    L   309_A      L     315          0.472
LGA    E   310_A      H     316          0.876
LGA    R   311_A      A     317          1.264
LGA    M   312_A      I     318          2.102
LGA    R   313_A      K     319          1.872
LGA    G   314_A      -       -           -
LGA    Y   315_A      E     321          1.735
LGA    Q   316_A      P     322           #
LGA    G   317_A      E     323           #
LGA    P   318_A      -       -           -
LGA    P   319_A      -       -           -
LGA    R   320_A      E     324          5.001
LGA    E   321_A      P     326          4.297
LGA    V   322_A      T     327          1.945
LGA    R   323_A      S     328          2.807
LGA    F   324_A      M     329          1.771
LGA    E   325_A      G     330          1.799
LGA    P   326_A      F     331          2.518
LGA    V   327_A      K     332          2.613
LGA    L   328_A      L     333          1.369
LGA    V   329_A      K     334          1.220
LGA    E   330_A      R     335          1.251
LGA    R   331_A      R     336          1.793
LGA    A   332_A      A     337          2.240
LGA    S   333_A      S     338          2.613
LGA    T   334_A      T     339          2.497
LGA    G   335_A      -       -           -
LGA    T   336_A      A     340          1.792
LGA    P   337_A      I     341          3.898
LGA    P   338_A      N     342           #
LGA    A   339_A      -       -           -
LGA    A   340_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  258  270    5.0    236    2.32    19.49     59.088     9.759

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.141975 * X  +  -0.032916 * Y  +   0.989323 * Z  + -10.458957
  Y_new =  -0.276604 * X  +  -0.958314 * Y  +  -0.071579 * Z  + 120.219032
  Z_new =   0.950438 * X  +  -0.283813 * Y  +   0.126951 * Z  +  -0.347865 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.150185    1.991408  [ DEG:   -65.9007    114.0993 ]
  Theta =  -1.254643   -1.886949  [ DEG:   -71.8858   -108.1142 ]
  Phi   =  -2.045009    1.096584  [ DEG:  -117.1704     62.8296 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2h0a_A                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2h0a_A.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  258  270   5.0  236   2.32   19.49  59.088
REMARK  ---------------------------------------------------------- 
MOLECULE 2h0a_A
HEADER    TRANSCRIPTION                           14-MAY-06   2H0A              
TITLE     CRYSTAL STRUCTURE OF PROBABLE TRANSCRIPTION REGULATOR FROM            
TITLE    2 THERMUS THERMOPHILUS                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR;                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TT1016;                                                    
COMPND   5 SYNONYM: TTHA0807;                                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    TRANSCRIPTION, REGULATOR, REPRESSOR, STRUCTURAL GENOMICS,             
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.S.KUMAREVEL,A.SHINKAI,S.YOKOYAMA,RIKEN STRUCTURAL                   
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   15-MAY-07 2H0A    0                                                
JRNL        AUTH   T.S.KUMAREVEL,A.SHINKAI,S.YOKOYAMA                           
JRNL        TITL   CRYSTAL STRUCTURE OF PROBABLE TRANSCRIPTION                  
JRNL        TITL 2 REGULATOR FROM THERMUS THERMOPHILUS                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  2H0A A   65   340  UNP    Q5SK45   Q5SK45_THET8    65    340             
SEQRES   1 A  276  THR VAL SER VAL LEU LEU PRO PHE VAL ALA THR GLU PHE          
SEQRES   2 A  276  TYR ARG ARG LEU VAL GLU GLY ILE GLU GLY VAL LEU LEU          
SEQRES   3 A  276  GLU GLN ARG TYR ASP LEU ALA LEU PHE PRO ILE LEU SER          
SEQRES   4 A  276  LEU ALA ARG LEU LYS ARG TYR LEU GLU ASN THR THR LEU          
SEQRES   5 A  276  ALA TYR LEU THR ASP GLY LEU ILE LEU ALA SER TYR ASP          
SEQRES   6 A  276  LEU THR GLU ARG PHE GLU GLU GLY ARG LEU PRO THR GLU          
SEQRES   7 A  276  ARG PRO VAL VAL LEU VAL ASP ALA GLN ASN PRO ARG TYR          
SEQRES   8 A  276  ASP SER VAL TYR LEU ASP ASN ARG LEU GLY GLY ARG LEU          
SEQRES   9 A  276  ALA GLY ALA TYR LEU ALA ARG PHE PRO GLY PRO ILE PHE          
SEQRES  10 A  276  ALA ILE ALA VAL GLU GLU GLU PRO ASP ARG ALA PHE ARG          
SEQRES  11 A  276  ARG THR VAL PHE ALA GLU ARG MET ALA GLY PHE GLN GLU          
SEQRES  12 A  276  ALA LEU LYS GLU ALA GLY ARG PRO PHE SER PRO ASP ARG          
SEQRES  13 A  276  LEU TYR ILE THR ARG HIS SER GLN GLU GLY GLY ARG LEU          
SEQRES  14 A  276  ALA LEU ARG HIS PHE LEU GLU LYS ALA SER PRO PRO LEU          
SEQRES  15 A  276  ASN VAL PHE ALA GLY ALA ASP GLN VAL ALA LEU GLY VAL          
SEQRES  16 A  276  LEU GLU GLU ALA VAL ARG LEU GLY LEU THR PRO GLY ARG          
SEQRES  17 A  276  ASP VAL ARG VAL LEU GLY PHE ASP GLY HIS PRO PHE ALA          
SEQRES  18 A  276  GLU GLU ALA GLY LEU SER THR ILE ALA GLN PRO VAL GLU          
SEQRES  19 A  276  ALA MET GLY ALA ARG ALA ALA GLN LEU LEU LEU GLU ARG          
SEQRES  20 A  276  MET ARG GLY TYR GLN GLY PRO PRO ARG GLU VAL ARG PHE          
SEQRES  21 A  276  GLU PRO VAL LEU VAL GLU ARG ALA SER THR GLY THR PRO          
SEQRES  22 A  276  PRO ALA ALA                                                  
FORMUL   2  HOH   *185(H2 O)                                                    
CRYST1   74.450   74.450  138.680  90.00  90.00  90.00 P 41 21 2     8          
ATOM      1  N   THR A  65      50.293  85.368   9.254  1.00 74.80           N  
ATOM      2  CA  THR A  65      51.702  85.179   9.694  1.00 74.52           C  
ATOM      3  C   THR A  65      51.850  84.052  10.727  1.00 74.94           C  
ATOM      4  O   THR A  65      52.356  82.973  10.414  1.00 74.47           O  
ATOM      5  CB  THR A  65      52.286  86.521  10.258  1.00 74.12           C  
ATOM      6  OG1 THR A  65      53.454  86.252  11.043  1.00 74.61           O  
ATOM      7  CG2 THR A  65      51.261  87.260  11.101  1.00 71.27           C  
ATOM      8  N   VAL A  66      51.387  84.292  11.947  1.00 75.26           N  
ATOM      9  CA  VAL A  66      51.496  83.301  13.013  1.00 74.50           C  
ATOM     10  C   VAL A  66      50.139  82.914  13.604  1.00 74.47           C  
ATOM     11  O   VAL A  66      49.233  83.745  13.731  1.00 74.18           O  
ATOM     12  CB  VAL A  66      52.398  83.829  14.159  1.00 74.57           C  
ATOM     13  CG1 VAL A  66      52.551  82.771  15.234  1.00 74.31           C  
ATOM     14  CG2 VAL A  66      53.756  84.237  13.611  1.00 73.57           C  
ATOM     15  N   SER A  67      50.010  81.643  13.967  1.00 73.89           N  
ATOM     16  CA  SER A  67      48.784  81.117  14.562  1.00 73.24           C  
ATOM     17  C   SER A  67      49.100  80.604  15.972  1.00 71.98           C  
ATOM     18  O   SER A  67      50.134  79.964  16.189  1.00 70.34           O  
ATOM     19  CB  SER A  67      48.232  79.977  13.696  1.00 73.28           C  
ATOM     20  OG  SER A  67      47.022  79.464  14.223  1.00 73.31           O  
ATOM     21  N   VAL A  68      48.215  80.880  16.927  1.00 70.72           N  
ATOM     22  CA  VAL A  68      48.441  80.445  18.302  1.00 70.69           C  
ATOM     23  C   VAL A  68      47.385  79.464  18.826  1.00 70.53           C  
ATOM     24  O   VAL A  68      46.185  79.725  18.744  1.00 69.91           O  
ATOM     25  CB  VAL A  68      48.527  81.669  19.262  1.00 71.46           C  
ATOM     26  CG1 VAL A  68      49.523  82.682  18.721  0.00 71.42           C  
ATOM     27  CG2 VAL A  68      47.166  82.318  19.435  1.00 72.16           C  
ATOM     28  N   LEU A  69      47.845  78.332  19.355  1.00 71.18           N  
ATOM     29  CA  LEU A  69      46.951  77.315  19.903  1.00 71.76           C  
ATOM     30  C   LEU A  69      47.152  77.183  21.405  1.00 71.29           C  
ATOM     31  O   LEU A  69      48.275  77.252  21.905  1.00 70.67           O  
ATOM     32  CB  LEU A  69      47.158  75.959  19.210  1.00 71.72           C  
ATOM     33  CG  LEU A  69      48.512  75.235  19.235  1.00 72.84           C  
ATOM     34  CD1 LEU A  69      49.614  76.204  18.857  1.00 73.80           C  
ATOM     35  CD2 LEU A  69      48.764  74.652  20.605  0.00 72.88           C  
ATOM     36  N   LEU A  70      46.048  76.984  22.115  1.00 71.47           N  
ATOM     37  CA  LEU A  70      46.060  76.889  23.570  1.00 70.99           C  
ATOM     38  C   LEU A  70      45.794  75.493  24.143  1.00 72.59           C  
ATOM     39  O   LEU A  70      44.652  75.032  24.139  1.00 73.59           O  
ATOM     40  CB  LEU A  70      45.016  77.857  24.109  1.00 68.41           C  
ATOM     41  CG  LEU A  70      44.818  79.125  23.274  1.00 65.89           C  
ATOM     42  CD1 LEU A  70      43.831  80.019  23.985  1.00 65.65           C  
ATOM     43  CD2 LEU A  70      46.131  79.856  23.079  1.00 65.59           C  
ATOM     44  N   PRO A  71      46.842  74.800  24.638  1.00 73.12           N  
ATOM     45  CA  PRO A  71      46.706  73.453  25.216  1.00 73.64           C  
ATOM     46  C   PRO A  71      46.866  73.513  26.739  1.00 74.38           C  
ATOM     47  O   PRO A  71      46.560  74.525  27.355  1.00 73.59           O  
ATOM     48  CB  PRO A  71      47.853  72.672  24.557  1.00 72.99           C  
ATOM     49  CG  PRO A  71      48.554  73.683  23.614  1.00 72.21           C  
ATOM     50  CD  PRO A  71      48.235  75.018  24.227  0.00 72.94           C  
ATOM     51  N   PHE A  72      47.327  72.427  27.353  1.00 76.70           N  
ATOM     52  CA  PHE A  72      47.549  72.431  28.796  1.00 79.12           C  
ATOM     53  C   PHE A  72      48.461  71.359  29.429  1.00 78.67           C  
ATOM     54  O   PHE A  72      49.653  71.590  29.628  0.00 78.54           O  
ATOM     55  CB  PHE A  72      46.208  72.476  29.558  1.00 81.18           C  
ATOM     56  CG  PHE A  72      46.351  72.201  31.029  1.00 85.18           C  
ATOM     57  CD1 PHE A  72      47.441  72.714  31.743  1.00 85.92           C  
ATOM     58  CD2 PHE A  72      45.454  71.362  31.688  1.00 87.42           C  
ATOM     59  CE1 PHE A  72      47.637  72.383  33.085  1.00 87.93           C  
ATOM     60  CE2 PHE A  72      45.646  71.028  33.037  1.00 88.80           C  
ATOM     61  CZ  PHE A  72      46.745  71.541  33.732  1.00 88.44           C  
ATOM     62  N   VAL A  73      47.889  70.202  29.754  1.00 77.64           N  
ATOM     63  CA  VAL A  73      48.579  69.086  30.420  1.00 74.65           C  
ATOM     64  C   VAL A  73      49.905  68.587  29.849  1.00 72.25           C  
ATOM     65  O   VAL A  73      50.759  68.115  30.598  1.00 72.75           O  
ATOM     66  CB  VAL A  73      47.632  67.864  30.513  1.00 75.38           C  
ATOM     67  CG1 VAL A  73      48.167  66.842  31.506  1.00 75.50           C  
ATOM     68  CG2 VAL A  73      46.249  68.324  30.917  1.00 76.07           C  
ATOM     69  N   ALA A  74      50.088  68.686  28.538  1.00 69.67           N  
ATOM     70  CA  ALA A  74      51.311  68.200  27.902  1.00 66.42           C  
ATOM     71  C   ALA A  74      51.283  66.671  27.946  1.00 64.13           C  
ATOM     72  O   ALA A  74      52.125  66.032  28.573  1.00 61.59           O  
ATOM     73  CB  ALA A  74      52.547  68.732  28.619  1.00 67.11           C  
ATOM     74  N   THR A  75      50.285  66.105  27.275  1.00 62.01           N  
ATOM     75  CA  THR A  75      50.093  64.663  27.186  1.00 58.99           C  
ATOM     76  C   THR A  75      50.336  64.263  25.737  1.00 55.62           C  
ATOM     77  O   THR A  75      50.492  65.128  24.878  1.00 55.65           O  
ATOM     78  CB  THR A  75      48.662  64.282  27.570  1.00 60.39           C  
ATOM     79  OG1 THR A  75      47.742  65.117  26.857  1.00 61.31           O  
ATOM     80  CG2 THR A  75      48.449  64.463  29.060  1.00 61.25           C  
ATOM     81  N   GLU A  76      50.374  62.966  25.456  1.00 50.94           N  
ATOM     82  CA  GLU A  76      50.609  62.510  24.091  1.00 48.25           C  
ATOM     83  C   GLU A  76      49.480  62.961  23.159  1.00 46.82           C  
ATOM     84  O   GLU A  76      49.676  63.108  21.955  1.00 45.17           O  
ATOM     85  CB  GLU A  76      50.738  60.985  24.060  1.00 48.72           C  
ATOM     86  CG  GLU A  76      50.816  60.394  22.662  1.00 51.53           C  
ATOM     87  CD  GLU A  76      52.125  60.698  21.956  1.00 54.08           C  
ATOM     88  OE1 GLU A  76      52.710  61.770  22.216  1.00 55.84           O  
ATOM     89  OE2 GLU A  76      52.563  59.868  21.128  1.00 54.67           O  
ATOM     90  N   PHE A  77      48.303  63.191  23.734  1.00 45.84           N  
ATOM     91  CA  PHE A  77      47.136  63.612  22.972  1.00 44.99           C  
ATOM     92  C   PHE A  77      47.352  64.986  22.370  1.00 46.03           C  
ATOM     93  O   PHE A  77      46.852  65.291  21.283  1.00 47.01           O  
ATOM     94  CB  PHE A  77      45.903  63.637  23.876  1.00 43.35           C  
ATOM     95  CG  PHE A  77      44.647  64.118  23.191  1.00 41.72           C  
ATOM     96  CD1 PHE A  77      43.958  63.297  22.307  1.00 38.92           C  
ATOM     97  CD2 PHE A  77      44.146  65.395  23.442  1.00 40.13           C  
ATOM     98  CE1 PHE A  77      42.786  63.741  21.690  1.00 37.34           C  
ATOM     99  CE2 PHE A  77      42.974  65.839  22.827  1.00 38.67           C  
ATOM    100  CZ  PHE A  77      42.298  65.010  21.951  1.00 35.86           C  
ATOM    101  N   TYR A  78      48.094  65.825  23.077  1.00 46.69           N  
ATOM    102  CA  TYR A  78      48.352  67.159  22.581  1.00 47.69           C  
ATOM    103  C   TYR A  78      49.551  67.158  21.661  1.00 47.55           C  
ATOM    104  O   TYR A  78      49.651  67.998  20.772  1.00 48.84           O  
ATOM    105  CB  TYR A  78      48.523  68.122  23.753  1.00 50.84           C  
ATOM    106  CG  TYR A  78      47.246  68.215  24.544  1.00 56.88           C  
ATOM    107  CD1 TYR A  78      46.142  68.903  24.035  1.00 58.99           C  
ATOM    108  CD2 TYR A  78      47.083  67.488  25.721  1.00 60.10           C  
ATOM    109  CE1 TYR A  78      44.905  68.849  24.668  1.00 62.29           C  
ATOM    110  CE2 TYR A  78      45.851  67.425  26.365  1.00 63.85           C  
ATOM    111  CZ  TYR A  78      44.763  68.104  25.830  1.00 64.89           C  
ATOM    112  OH  TYR A  78      43.532  67.995  26.440  1.00 67.08           O  
ATOM    113  N   ARG A  79      50.457  66.206  21.842  1.00 46.60           N  
ATOM    114  CA  ARG A  79      51.607  66.166  20.957  1.00 46.09           C  
ATOM    115  C   ARG A  79      51.071  65.836  19.574  1.00 45.95           C  
ATOM    116  O   ARG A  79      51.383  66.520  18.600  1.00 46.54           O  
ATOM    117  CB  ARG A  79      52.621  65.098  21.378  1.00 45.47           C  
ATOM    118  CG  ARG A  79      53.879  65.118  20.515  1.00 45.69           C  
ATOM    119  CD  ARG A  79      54.742  63.871  20.664  1.00 45.98           C  
ATOM    120  NE  ARG A  79      54.125  62.686  20.074  1.00 48.24           N  
ATOM    121  CZ  ARG A  79      53.840  62.550  18.782  1.00 49.58           C  
ATOM    122  NH1 ARG A  79      54.115  63.525  17.926  1.00 50.12           N  
ATOM    123  NH2 ARG A  79      53.269  61.440  18.345  1.00 51.27           N  
ATOM    124  N   ARG A  80      50.248  64.791  19.500  1.00 45.12           N  
ATOM    125  CA  ARG A  80      49.659  64.352  18.234  1.00 43.93           C  
ATOM    126  C   ARG A  80      48.754  65.409  17.624  1.00 43.00           C  
ATOM    127  O   ARG A  80      48.690  65.544  16.406  1.00 43.18           O  
ATOM    128  CB  ARG A  80      48.845  63.076  18.433  1.00 41.98           C  
ATOM    129  CG  ARG A  80      49.624  61.912  19.009  1.00 42.81           C  
ATOM    130  CD  ARG A  80      48.669  60.795  19.387  1.00 43.14           C  
ATOM    131  NE  ARG A  80      47.942  60.300  18.223  1.00 44.24           N  
ATOM    132  CZ  ARG A  80      46.873  59.513  18.281  1.00 42.40           C  
ATOM    133  NH1 ARG A  80      46.396  59.121  19.454  1.00 40.33           N  
ATOM    134  NH2 ARG A  80      46.281  59.126  17.161  1.00 40.09           N  
ATOM    135  N   LEU A  81      48.058  66.148  18.480  1.00 42.71           N  
ATOM    136  CA  LEU A  81      47.135  67.188  18.044  1.00 41.96           C  
ATOM    137  C   LEU A  81      47.881  68.293  17.318  1.00 41.71           C  
ATOM    138  O   LEU A  81      47.461  68.744  16.256  1.00 41.41           O  
ATOM    139  CB  LEU A  81      46.399  67.770  19.250  1.00 42.13           C  
ATOM    140  CG  LEU A  81      45.031  68.393  18.971  1.00 44.10           C  
ATOM    141  CD1 LEU A  81      44.069  67.300  18.518  1.00 45.02           C  
ATOM    142  CD2 LEU A  81      44.497  69.067  20.219  1.00 43.98           C  
ATOM    143  N   VAL A  82      49.002  68.714  17.894  1.00 42.08           N  
ATOM    144  CA  VAL A  82      49.826  69.775  17.327  1.00 41.02           C  
ATOM    145  C   VAL A  82      50.604  69.306  16.108  1.00 42.31           C  
ATOM    146  O   VAL A  82      50.862  70.084  15.193  1.00 42.29           O  
ATOM    147  CB  VAL A  82      50.814  70.309  18.367  1.00 40.72           C  
ATOM    148  CG1 VAL A  82      51.796  71.252  17.702  1.00 41.30           C  
ATOM    149  CG2 VAL A  82      50.065  71.020  19.482  1.00 37.31           C  
ATOM    150  N   GLU A  83      51.000  68.040  16.096  1.00 43.79           N  
ATOM    151  CA  GLU A  83      51.713  67.520  14.942  1.00 46.12           C  
ATOM    152  C   GLU A  83      50.740  67.652  13.784  1.00 47.82           C  
ATOM    153  O   GLU A  83      51.131  67.980  12.662  1.00 48.67           O  
ATOM    154  CB  GLU A  83      52.078  66.050  15.138  1.00 47.38           C  
ATOM    155  CG  GLU A  83      52.864  65.451  13.974  1.00 51.05           C  
ATOM    156  CD  GLU A  83      53.273  64.003  14.222  1.00 54.48           C  
ATOM    157  OE1 GLU A  83      53.973  63.748  15.227  1.00 56.57           O  
ATOM    158  OE2 GLU A  83      52.900  63.120  13.413  1.00 55.43           O  
ATOM    159  N   GLY A  84      49.462  67.406  14.078  1.00 48.19           N  
ATOM    160  CA  GLY A  84      48.426  67.501  13.069  1.00 48.53           C  
ATOM    161  C   GLY A  84      48.249  68.919  12.565  1.00 49.99           C  
ATOM    162  O   GLY A  84      48.024  69.131  11.379  1.00 50.63           O  
ATOM    163  N   ILE A  85      48.351  69.890  13.467  1.00 51.09           N  
ATOM    164  CA  ILE A  85      48.204  71.301  13.118  1.00 51.73           C  
ATOM    165  C   ILE A  85      49.437  71.813  12.386  1.00 54.15           C  
ATOM    166  O   ILE A  85      49.323  72.484  11.360  1.00 54.27           O  
ATOM    167  CB  ILE A  85      48.002  72.168  14.376  1.00 49.81           C  
ATOM    168  CG1 ILE A  85      46.678  71.810  15.053  1.00 48.36           C  
ATOM    169  CG2 ILE A  85      48.043  73.629  14.000  1.00 49.09           C  
ATOM    170  CD1 ILE A  85      46.450  72.500  16.375  1.00 46.54           C  
ATOM    171  N   GLU A  86      50.617  71.502  12.920  1.00 56.53           N  
ATOM    172  CA  GLU A  86      51.867  71.935  12.301  1.00 58.93           C  
ATOM    173  C   GLU A  86      51.935  71.421  10.877  1.00 58.00           C  
ATOM    174  O   GLU A  86      52.208  72.170   9.944  1.00 57.06           O  
ATOM    175  CB  GLU A  86      53.070  71.402  13.078  1.00 62.23           C  
ATOM    176  CG  GLU A  86      53.164  71.917  14.506  1.00 68.59           C  
ATOM    177  CD  GLU A  86      54.497  71.578  15.160  1.00 71.94           C  
ATOM    178  OE1 GLU A  86      54.883  70.387  15.157  1.00 73.98           O  
ATOM    179  OE2 GLU A  86      55.159  72.503  15.682  1.00 72.53           O  
ATOM    180  N   GLY A  87      51.695  70.126  10.722  1.00 58.12           N  
ATOM    181  CA  GLY A  87      51.723  69.534   9.402  1.00 58.36           C  
ATOM    182  C   GLY A  87      50.964  70.393   8.418  1.00 58.28           C  
ATOM    183  O   GLY A  87      51.432  70.635   7.304  1.00 58.38           O  
ATOM    184  N   VAL A  88      49.793  70.867   8.831  1.00 58.09           N  
ATOM    185  CA  VAL A  88      48.975  71.699   7.965  1.00 58.45           C  
ATOM    186  C   VAL A  88      49.478  73.132   7.870  1.00 60.67           C  
ATOM    187  O   VAL A  88      49.964  73.546   6.822  1.00 61.07           O  
ATOM    188  CB  VAL A  88      47.500  71.697   8.432  1.00 55.67           C  
ATOM    189  CG1 VAL A  88      46.679  72.690   7.628  1.00 53.42           C  
ATOM    190  CG2 VAL A  88      46.923  70.312   8.267  1.00 54.46           C  
ATOM    191  N   LEU A  89      49.399  73.874   8.969  1.00 62.60           N  
ATOM    192  CA  LEU A  89      49.809  75.273   8.983  1.00 65.45           C  
ATOM    193  C   LEU A  89      51.160  75.614   8.359  1.00 67.86           C  
ATOM    194  O   LEU A  89      51.271  76.620   7.660  1.00 67.63           O  
ATOM    195  CB  LEU A  89      49.750  75.811  10.409  1.00 65.47           C  
ATOM    196  CG  LEU A  89      48.334  75.963  10.957  1.00 66.13           C  
ATOM    197  CD1 LEU A  89      48.409  76.524  12.367  1.00 67.57           C  
ATOM    198  CD2 LEU A  89      47.516  76.883  10.054  1.00 66.01           C  
ATOM    199  N   LEU A  90      52.176  74.787   8.599  1.00 70.84           N  
ATOM    200  CA  LEU A  90      53.500  75.053   8.046  1.00 73.09           C  
ATOM    201  C   LEU A  90      53.573  74.833   6.541  1.00 73.52           C  
ATOM    202  O   LEU A  90      54.526  75.246   5.894  1.00 74.29           O  
ATOM    203  CB  LEU A  90      54.568  74.202   8.737  1.00 74.15           C  
ATOM    204  CG  LEU A  90      54.701  74.329  10.263  1.00 76.93           C  
ATOM    205  CD1 LEU A  90      55.875  73.471  10.715  1.00 77.40           C  
ATOM    206  CD2 LEU A  90      54.908  75.780  10.692  1.00 76.09           C  
ATOM    207  N   GLU A  91      52.573  74.172   5.979  1.00 73.94           N  
ATOM    208  CA  GLU A  91      52.536  73.949   4.539  1.00 74.30           C  
ATOM    209  C   GLU A  91      52.074  75.242   3.866  1.00 74.00           C  
ATOM    210  O   GLU A  91      52.416  75.518   2.720  1.00 74.11           O  
ATOM    211  CB  GLU A  91      51.558  72.816   4.208  1.00 76.13           C  
ATOM    212  CG  GLU A  91      51.280  72.649   2.720  1.00 77.74           C  
ATOM    213  CD  GLU A  91      52.207  71.655   2.058  1.00 78.99           C  
ATOM    214  OE1 GLU A  91      52.088  70.450   2.367  1.00 79.96           O  
ATOM    215  OE2 GLU A  91      53.050  72.073   1.235  1.00 80.15           O  
ATOM    216  N   GLN A  92      51.295  76.027   4.603  1.00 73.41           N  
ATOM    217  CA  GLN A  92      50.755  77.292   4.118  1.00 72.90           C  
ATOM    218  C   GLN A  92      51.580  78.470   4.605  1.00 74.07           C  
ATOM    219  O   GLN A  92      51.126  79.614   4.577  1.00 73.30           O  
ATOM    220  CB  GLN A  92      49.306  77.458   4.582  1.00 70.77           C  
ATOM    221  CG  GLN A  92      48.381  76.394   4.036  1.00 68.00           C  
ATOM    222  CD  GLN A  92      48.474  76.282   2.531  1.00 66.02           C  
ATOM    223  OE1 GLN A  92      48.439  77.286   1.821  1.00 65.60           O  
ATOM    224  NE2 GLN A  92      48.582  75.061   2.032  1.00 63.35           N  
ATOM    225  N   ARG A  93      52.792  78.169   5.063  1.00 76.12           N  
ATOM    226  CA  ARG A  93      53.728  79.175   5.560  1.00 77.37           C  
ATOM    227  C   ARG A  93      53.296  79.957   6.801  1.00 76.15           C  
ATOM    228  O   ARG A  93      53.634  81.131   6.939  1.00 76.25           O  
ATOM    229  CB  ARG A  93      54.078  80.165   4.445  1.00 80.41           C  
ATOM    230  CG  ARG A  93      54.709  79.532   3.226  1.00 84.24           C  
ATOM    231  CD  ARG A  93      55.059  80.580   2.189  1.00 89.18           C  
ATOM    232  NE  ARG A  93      55.685  79.981   1.013  1.00 95.22           N  
ATOM    233  CZ  ARG A  93      56.203  80.674   0.001  1.00 97.66           C  
ATOM    234  NH1 ARG A  93      56.171  82.003   0.017  1.00 99.33           N  
ATOM    235  NH2 ARG A  93      56.758  80.038  -1.025  1.00 97.99           N  
ATOM    236  N   TYR A  94      52.545  79.325   7.697  1.00 74.56           N  
ATOM    237  CA  TYR A  94      52.135  80.002   8.923  1.00 73.45           C  
ATOM    238  C   TYR A  94      52.987  79.487  10.075  1.00 73.71           C  
ATOM    239  O   TYR A  94      53.424  78.334  10.063  1.00 72.68           O  
ATOM    240  CB  TYR A  94      50.657  79.747   9.244  1.00 72.05           C  
ATOM    241  CG  TYR A  94      49.688  80.691   8.570  1.00 70.24           C  
ATOM    242  CD1 TYR A  94      49.406  80.580   7.208  1.00 71.23           C  
ATOM    243  CD2 TYR A  94      49.046  81.691   9.295  1.00 69.69           C  
ATOM    244  CE1 TYR A  94      48.503  81.443   6.584  1.00 70.73           C  
ATOM    245  CE2 TYR A  94      48.145  82.562   8.682  1.00 70.06           C  
ATOM    246  CZ  TYR A  94      47.877  82.431   7.329  1.00 70.36           C  
ATOM    247  OH  TYR A  94      46.983  83.280   6.725  1.00 69.68           O  
ATOM    248  N   ASP A  95      53.233  80.345  11.059  1.00 74.71           N  
ATOM    249  CA  ASP A  95      54.023  79.960  12.223  1.00 75.18           C  
ATOM    250  C   ASP A  95      53.089  79.593  13.365  1.00 74.16           C  
ATOM    251  O   ASP A  95      52.014  80.173  13.505  1.00 74.48           O  
ATOM    252  CB  ASP A  95      54.949  81.104  12.655  1.00 77.08           C  
ATOM    253  CG  ASP A  95      56.259  81.118  11.884  1.00 78.87           C  
ATOM    254  OD1 ASP A  95      56.226  81.338  10.656  0.00 78.58           O  
ATOM    255  OD2 ASP A  95      57.321  80.902  12.510  1.00 79.78           O  
ATOM    256  N   LEU A  96      53.503  78.633  14.182  1.00 72.97           N  
ATOM    257  CA  LEU A  96      52.678  78.191  15.297  1.00 72.70           C  
ATOM    258  C   LEU A  96      53.200  78.651  16.657  1.00 72.45           C  
ATOM    259  O   LEU A  96      54.357  78.417  17.002  1.00 72.71           O  
ATOM    260  CB  LEU A  96      52.577  76.667  15.281  1.00 72.66           C  
ATOM    261  CG  LEU A  96      51.477  76.056  16.144  1.00 72.30           C  
ATOM    262  CD1 LEU A  96      50.126  76.565  15.666  1.00 71.58           C  
ATOM    263  CD2 LEU A  96      51.546  74.538  16.062  1.00 72.26           C  
ATOM    264  N   ALA A  97      52.334  79.303  17.427  1.00 71.22           N  
ATOM    265  CA  ALA A  97      52.699  79.785  18.755  1.00 69.87           C  
ATOM    266  C   ALA A  97      51.971  78.973  19.823  1.00 69.27           C  
ATOM    267  O   ALA A  97      50.772  79.136  20.045  1.00 67.90           O  
ATOM    268  CB  ALA A  97      52.360  81.260  18.889  1.00 70.13           C  
ATOM    269  N   LEU A  98      52.718  78.102  20.486  1.00 69.62           N  
ATOM    270  CA  LEU A  98      52.177  77.229  21.520  1.00 69.80           C  
ATOM    271  C   LEU A  98      51.990  77.972  22.846  1.00 69.18           C  
ATOM    272  O   LEU A  98      52.943  78.505  23.401  1.00 68.99           O  
ATOM    273  CB  LEU A  98      53.133  76.052  21.716  1.00 70.68           C  
ATOM    274  CG  LEU A  98      52.574  74.652  21.955  1.00 71.54           C  
ATOM    275  CD1 LEU A  98      53.737  73.678  22.108  1.00 71.88           C  
ATOM    276  CD2 LEU A  98      51.690  74.642  23.188  1.00 72.08           C  
ATOM    277  N   PHE A  99      50.767  78.002  23.358  1.00 69.26           N  
ATOM    278  CA  PHE A  99      50.509  78.681  24.620  1.00 69.70           C  
ATOM    279  C   PHE A  99      49.913  77.778  25.696  1.00 69.22           C  
ATOM    280  O   PHE A  99      48.707  77.804  25.921  1.00 68.30           O  
ATOM    281  CB  PHE A  99      49.571  79.881  24.413  1.00 71.08           C  
ATOM    282  CG  PHE A  99      50.202  81.034  23.678  1.00 74.56           C  
ATOM    283  CD1 PHE A  99      51.528  81.395  23.912  1.00 75.57           C  
ATOM    284  CD2 PHE A  99      49.456  81.784  22.770  1.00 74.86           C  
ATOM    285  CE1 PHE A  99      52.099  82.486  23.249  1.00 75.33           C  
ATOM    286  CE2 PHE A  99      50.019  82.874  22.106  1.00 74.70           C  
ATOM    287  CZ  PHE A  99      51.342  83.224  22.347  0.00 75.12           C  
ATOM    288  N   PRO A 100      50.749  76.961  26.370  1.00 69.13           N  
ATOM    289  CA  PRO A 100      50.213  76.086  27.419  1.00 69.43           C  
ATOM    290  C   PRO A 100      49.386  76.950  28.361  1.00 71.07           C  
ATOM    291  O   PRO A 100      49.755  78.090  28.651  1.00 71.29           O  
ATOM    292  CB  PRO A 100      51.467  75.529  28.072  1.00 68.38           C  
ATOM    293  CG  PRO A 100      52.416  75.422  26.907  1.00 68.36           C  
ATOM    294  CD  PRO A 100      52.198  76.743  26.193  1.00 68.34           C  
ATOM    295  N   ILE A 101      48.273  76.418  28.848  1.00 73.18           N  
ATOM    296  CA  ILE A 101      47.412  77.219  29.695  1.00 75.64           C  
ATOM    297  C   ILE A 101      46.938  76.679  31.033  1.00 78.94           C  
ATOM    298  O   ILE A 101      46.718  75.485  31.224  1.00 78.96           O  
ATOM    299  CB  ILE A 101      46.158  77.688  28.891  1.00 73.79           C  
ATOM    300  CG1 ILE A 101      46.566  78.768  27.891  1.00 73.19           C  
ATOM    301  CG2 ILE A 101      45.080  78.244  29.822  1.00 73.26           C  
ATOM    302  CD1 ILE A 101      45.412  79.351  27.117  1.00 71.82           C  
ATOM    303  N   LEU A 102      46.801  77.634  31.946  1.00 82.04           N  
ATOM    304  CA  LEU A 102      46.306  77.469  33.302  1.00 84.17           C  
ATOM    305  C   LEU A 102      45.440  78.724  33.309  1.00 86.79           C  
ATOM    306  O   LEU A 102      45.940  79.815  33.039  1.00 87.36           O  
ATOM    307  CB  LEU A 102      47.425  77.619  34.332  1.00 83.22           C  
ATOM    308  CG  LEU A 102      48.795  77.017  34.009  1.00 83.06           C  
ATOM    309  CD1 LEU A 102      49.467  77.802  32.883  1.00 82.69           C  
ATOM    310  CD2 LEU A 102      49.661  77.070  35.249  1.00 83.12           C  
ATOM    311  N   SER A 103      44.151  78.583  33.590  1.00 89.47           N  
ATOM    312  CA  SER A 103      43.242  79.735  33.570  1.00 91.39           C  
ATOM    313  C   SER A 103      43.836  81.047  34.081  1.00 93.83           C  
ATOM    314  O   SER A 103      44.419  81.101  35.165  1.00 94.95           O  
ATOM    315  CB  SER A 103      41.972  79.429  34.366  1.00 90.08           C  
ATOM    316  OG  SER A 103      40.980  80.417  34.148  1.00 88.16           O  
ATOM    317  N   LEU A 104      43.674  82.092  33.275  1.00 95.36           N  
ATOM    318  CA  LEU A 104      44.146  83.440  33.576  1.00 96.95           C  
ATOM    319  C   LEU A 104      43.268  84.412  32.779  1.00 98.83           C  
ATOM    320  O   LEU A 104      42.083  84.160  32.579  1.00100.24           O  
ATOM    321  CB  LEU A 104      45.616  83.605  33.169  1.00 95.71           C  
ATOM    322  CG  LEU A 104      46.142  83.140  31.803  1.00 95.28           C  
ATOM    323  CD1 LEU A 104      45.105  83.309  30.695  1.00 94.19           C  
ATOM    324  CD2 LEU A 104      47.402  83.939  31.490  1.00 95.12           C  
ATOM    325  N   ALA A 105      43.846  85.515  32.321  1.00 99.94           N  
ATOM    326  CA  ALA A 105      43.101  86.487  31.532  1.00100.11           C  
ATOM    327  C   ALA A 105      44.062  87.422  30.819  1.00100.32           C  
ATOM    328  O   ALA A 105      44.895  88.076  31.448  1.00100.27           O  
ATOM    329  CB  ALA A 105      42.150  87.270  32.420  1.00100.12           C  
ATOM    330  N   ARG A 106      43.937  87.478  29.499  1.00100.18           N  
ATOM    331  CA  ARG A 106      44.814  88.318  28.702  1.00100.20           C  
ATOM    332  C   ARG A 106      44.163  88.708  27.379  1.00100.13           C  
ATOM    333  O   ARG A 106      43.647  87.855  26.648  1.00100.25           O  
ATOM    334  CB  ARG A 106      46.121  87.578  28.414  1.00 99.50           C  
ATOM    335  CG  ARG A 106      45.905  86.316  27.599  1.00 98.46           C  
ATOM    336  CD  ARG A 106      47.138  85.914  26.822  1.00 97.92           C  
ATOM    337  NE  ARG A 106      46.767  85.139  25.641  1.00 98.27           N  
ATOM    338  CZ  ARG A 106      47.620  84.728  24.708  1.00 98.70           C  
ATOM    339  NH1 ARG A 106      48.911  85.013  24.814  1.00 99.12           N  
ATOM    340  NH2 ARG A 106      47.179  84.045  23.657  1.00 97.81           N  
ATOM    341  N   LEU A 107      44.199  90.001  27.072  1.00100.21           N  
ATOM    342  CA  LEU A 107      43.627  90.501  25.828  1.00100.28           C  
ATOM    343  C   LEU A 107      44.726  91.062  24.932  1.00100.33           C  
ATOM    344  O   LEU A 107      44.468  91.912  24.080  1.00100.27           O  
ATOM    345  CB  LEU A 107      42.581  91.583  26.118  1.00100.18           C  
ATOM    346  CG  LEU A 107      41.227  91.127  26.680  1.00 99.88           C  
ATOM    347  CD1 LEU A 107      41.411  90.446  28.035  1.00 99.24           C  
ATOM    348  CD2 LEU A 107      40.304  92.334  26.809  1.00 99.38           C  
ATOM    349  N   LYS A 108      45.950  90.579  25.130  1.00100.24           N  
ATOM    350  CA  LYS A 108      47.075  91.034  24.330  1.00100.03           C  
ATOM    351  C   LYS A 108      47.134  92.539  24.133  1.00 99.24           C  
ATOM    352  O   LYS A 108      47.486  93.021  23.056  1.00 98.00           O  
ATOM    353  N   TYR A 118      46.692  90.836  20.034  1.00 93.28           N  
ATOM    354  CA  TYR A 118      48.113  90.517  20.008  1.00 93.01           C  
ATOM    355  C   TYR A 118      48.628  90.409  18.572  1.00 92.65           C  
ATOM    356  O   TYR A 118      47.952  90.824  17.627  1.00 92.62           O  
ATOM    357  CB  TYR A 118      48.366  89.214  20.761  1.00 92.58           C  
ATOM    358  N   LEU A 119      49.825  89.847  18.414  1.00 91.83           N  
ATOM    359  CA  LEU A 119      50.439  89.691  17.096  1.00 90.37           C  
ATOM    360  C   LEU A 119      50.233  88.297  16.497  1.00 89.06           C  
ATOM    361  O   LEU A 119      51.176  87.670  16.006  1.00 89.11           O  
ATOM    362  CB  LEU A 119      51.931  90.010  17.180  1.00 90.54           C  
ATOM    363  N   THR A 120      48.992  87.819  16.540  1.00 86.77           N  
ATOM    364  CA  THR A 120      48.648  86.514  15.988  1.00 83.27           C  
ATOM    365  C   THR A 120      47.452  86.681  15.043  1.00 81.71           C  
ATOM    366  O   THR A 120      46.628  87.584  15.218  1.00 80.92           O  
ATOM    367  CB  THR A 120      48.304  85.501  17.112  1.00 82.39           C  
ATOM    368  OG1 THR A 120      48.085  84.208  16.541  1.00 82.78           O  
ATOM    369  CG2 THR A 120      47.059  85.931  17.863  1.00 81.92           C  
ATOM    370  N   ASP A 121      47.365  85.811  14.042  1.00 79.28           N  
ATOM    371  CA  ASP A 121      46.290  85.878  13.055  1.00 76.80           C  
ATOM    372  C   ASP A 121      45.062  85.048  13.419  1.00 74.57           C  
ATOM    373  O   ASP A 121      43.930  85.443  13.127  1.00 74.63           O  
ATOM    374  CB  ASP A 121      46.823  85.434  11.692  1.00 77.29           C  
ATOM    375  CG  ASP A 121      47.900  86.357  11.167  1.00 77.32           C  
ATOM    376  OD1 ASP A 121      48.719  86.837  11.974  1.00 78.32           O  
ATOM    377  OD2 ASP A 121      47.934  86.593   9.945  1.00 77.46           O  
ATOM    378  N   GLY A 122      45.287  83.900  14.050  1.00 71.62           N  
ATOM    379  CA  GLY A 122      44.178  83.041  14.428  1.00 67.57           C  
ATOM    380  C   GLY A 122      44.478  82.185  15.641  1.00 65.11           C  
ATOM    381  O   GLY A 122      45.637  81.911  15.946  1.00 63.71           O  
ATOM    382  N   LEU A 123      43.423  81.751  16.322  1.00 63.66           N  
ATOM    383  CA  LEU A 123      43.564  80.932  17.523  1.00 62.43           C  
ATOM    384  C   LEU A 123      42.868  79.563  17.459  1.00 61.42           C  
ATOM    385  O   LEU A 123      41.710  79.449  17.041  1.00 60.18           O  
ATOM    386  CB  LEU A 123      43.039  81.704  18.741  1.00 61.08           C  
ATOM    387  CG  LEU A 123      43.748  82.986  19.188  1.00 59.92           C  
ATOM    388  CD1 LEU A 123      43.657  84.046  18.103  0.00 60.45           C  
ATOM    389  CD2 LEU A 123      43.113  83.489  20.472  0.00 60.44           C  
ATOM    390  N   ILE A 124      43.589  78.531  17.888  1.00 60.26           N  
ATOM    391  CA  ILE A 124      43.067  77.167  17.925  1.00 59.16           C  
ATOM    392  C   ILE A 124      42.992  76.746  19.391  1.00 58.92           C  
ATOM    393  O   ILE A 124      44.019  76.568  20.040  1.00 58.87           O  
ATOM    394  CB  ILE A 124      44.000  76.192  17.162  1.00 58.38           C  
ATOM    395  CG1 ILE A 124      44.042  76.570  15.676  1.00 57.43           C  
ATOM    396  CG2 ILE A 124      43.532  74.749  17.363  1.00 57.19           C  
ATOM    397  CD1 ILE A 124      44.975  75.725  14.845  1.00 54.90           C  
ATOM    398  N   LEU A 125      41.779  76.598  19.914  1.00 58.87           N  
ATOM    399  CA  LEU A 125      41.596  76.217  21.312  1.00 59.54           C  
ATOM    400  C   LEU A 125      41.404  74.715  21.455  1.00 59.73           C  
ATOM    401  O   LEU A 125      40.526  74.138  20.823  1.00 60.56           O  
ATOM    402  CB  LEU A 125      40.388  76.939  21.898  1.00 59.82           C  
ATOM    403  CG  LEU A 125      40.549  77.471  23.325  1.00 60.76           C  
ATOM    404  CD1 LEU A 125      39.191  77.935  23.837  1.00 60.92           C  
ATOM    405  CD2 LEU A 125      41.125  76.394  24.243  1.00 60.91           C  
ATOM    406  N   ALA A 126      42.209  74.087  22.308  1.00 60.31           N  
ATOM    407  CA  ALA A 126      42.135  72.641  22.499  1.00 60.11           C  
ATOM    408  C   ALA A 126      41.489  72.136  23.797  1.00 60.61           C  
ATOM    409  O   ALA A 126      41.706  72.680  24.880  1.00 59.90           O  
ATOM    410  CB  ALA A 126      43.531  72.041  22.351  1.00 57.96           C  
ATOM    411  N   SER A 127      40.691  71.080  23.643  1.00 62.79           N  
ATOM    412  CA  SER A 127      39.996  70.380  24.725  1.00 63.32           C  
ATOM    413  C   SER A 127      39.142  71.164  25.703  1.00 65.62           C  
ATOM    414  O   SER A 127      38.190  70.620  26.244  1.00 64.30           O  
ATOM    415  CB  SER A 127      40.999  69.547  25.517  1.00 61.44           C  
ATOM    416  OG  SER A 127      41.681  68.647  24.665  1.00 57.84           O  
ATOM    417  N   TYR A 128      39.461  72.429  25.946  1.00 69.99           N  
ATOM    418  CA  TYR A 128      38.672  73.214  26.896  1.00 74.53           C  
ATOM    419  C   TYR A 128      37.931  74.371  26.258  1.00 77.06           C  
ATOM    420  O   TYR A 128      38.506  75.164  25.515  1.00 77.56           O  
ATOM    421  CB  TYR A 128      39.567  73.675  28.040  1.00 76.06           C  
ATOM    422  CG  TYR A 128      40.167  72.489  28.751  1.00 78.40           C  
ATOM    423  CD1 TYR A 128      41.294  71.839  28.245  1.00 78.75           C  
ATOM    424  CD2 TYR A 128      39.554  71.957  29.882  1.00 79.34           C  
ATOM    425  CE1 TYR A 128      41.793  70.678  28.850  1.00 79.14           C  
ATOM    426  CE2 TYR A 128      40.036  70.804  30.492  1.00 79.12           C  
ATOM    427  CZ  TYR A 128      41.155  70.166  29.975  1.00 79.21           C  
ATOM    428  OH  TYR A 128      41.620  69.013  30.573  1.00 78.07           O  
ATOM    429  N   ASP A 129      36.645  74.468  26.576  1.00 80.53           N  
ATOM    430  CA  ASP A 129      35.782  75.463  25.962  1.00 84.89           C  
ATOM    431  C   ASP A 129      35.762  76.947  26.326  1.00 87.92           C  
ATOM    432  O   ASP A 129      36.670  77.698  25.980  1.00 89.21           O  
ATOM    433  CB  ASP A 129      34.336  74.942  25.963  1.00 83.57           C  
ATOM    434  CG  ASP A 129      33.373  75.899  25.281  1.00 82.87           C  
ATOM    435  OD1 ASP A 129      33.803  76.613  24.349  1.00 80.67           O  
ATOM    436  OD2 ASP A 129      32.191  75.935  25.676  1.00 83.27           O  
ATOM    437  N   LEU A 130      34.697  77.366  27.000  1.00 91.34           N  
ATOM    438  CA  LEU A 130      34.481  78.770  27.329  1.00 94.42           C  
ATOM    439  C   LEU A 130      35.082  79.354  28.598  1.00 96.49           C  
ATOM    440  O   LEU A 130      35.862  78.719  29.303  1.00 97.52           O  
ATOM    441  CB  LEU A 130      32.968  79.066  27.291  1.00 94.03           C  
ATOM    442  CG  LEU A 130      32.023  78.246  28.187  1.00 93.61           C  
ATOM    443  CD1 LEU A 130      31.888  78.937  29.541  1.00 92.82           C  
ATOM    444  CD2 LEU A 130      30.644  78.110  27.534  1.00 93.42           C  
ATOM    445  N   THR A 131      34.708  80.604  28.851  1.00 97.90           N  
ATOM    446  CA  THR A 131      35.153  81.381  30.008  1.00 98.65           C  
ATOM    447  C   THR A 131      35.488  80.541  31.241  1.00 98.10           C  
ATOM    448  O   THR A 131      34.599  80.001  31.899  1.00 97.47           O  
ATOM    449  CB  THR A 131      34.077  82.428  30.389  1.00 99.41           C  
ATOM    450  OG1 THR A 131      32.814  81.772  30.574  1.00100.21           O  
ATOM    451  CG2 THR A 131      33.938  83.473  29.284  1.00 98.90           C  
ATOM    452  N   ARG A 138      32.780  82.825  23.601  1.00 95.98           N  
ATOM    453  CA  ARG A 138      32.561  84.246  23.824  1.00 95.29           C  
ATOM    454  C   ARG A 138      33.894  84.904  24.188  1.00 95.72           C  
ATOM    455  O   ARG A 138      33.978  85.658  25.155  1.00 95.79           O  
ATOM    456  CB  ARG A 138      31.533  84.439  24.950  1.00 94.65           C  
ATOM    457  CG  ARG A 138      30.946  85.846  25.050  1.00 94.41           C  
ATOM    458  CD  ARG A 138      29.915  85.960  26.173  1.00 92.96           C  
ATOM    459  NE  ARG A 138      30.496  85.687  27.488  1.00 93.35           N  
ATOM    460  CZ  ARG A 138      31.404  86.456  28.088  1.00 92.62           C  
ATOM    461  NH1 ARG A 138      31.844  87.561  27.497  1.00 91.92           N  
ATOM    462  NH2 ARG A 138      31.881  86.115  29.279  1.00 91.32           N  
ATOM    463  N   LEU A 139      34.937  84.606  23.414  1.00 96.21           N  
ATOM    464  CA  LEU A 139      36.265  85.175  23.659  1.00 96.71           C  
ATOM    465  C   LEU A 139      36.312  86.646  23.258  1.00 97.67           C  
ATOM    466  O   LEU A 139      35.468  87.114  22.491  1.00 98.80           O  
ATOM    467  CB  LEU A 139      37.342  84.381  22.907  1.00 95.96           C  
ATOM    468  CG  LEU A 139      37.645  82.982  23.466  1.00 96.04           C  
ATOM    469  CD1 LEU A 139      38.727  82.300  22.651  1.00 95.45           C  
ATOM    470  CD2 LEU A 139      38.088  83.107  24.911  1.00 95.93           C  
ATOM    471  N   PRO A 140      37.297  87.395  23.780  1.00 97.91           N  
ATOM    472  CA  PRO A 140      37.471  88.825  23.499  1.00 98.00           C  
ATOM    473  C   PRO A 140      38.157  89.242  22.192  1.00 98.04           C  
ATOM    474  O   PRO A 140      37.881  90.321  21.665  1.00 98.58           O  
ATOM    475  CB  PRO A 140      38.241  89.309  24.723  1.00 97.60           C  
ATOM    476  CG  PRO A 140      39.127  88.145  25.021  1.00 96.74           C  
ATOM    477  CD  PRO A 140      38.189  86.965  24.874  1.00 97.46           C  
ATOM    478  N   THR A 141      39.047  88.405  21.670  1.00 97.56           N  
ATOM    479  CA  THR A 141      39.780  88.744  20.452  1.00 96.50           C  
ATOM    480  C   THR A 141      38.962  88.874  19.163  1.00 94.71           C  
ATOM    481  O   THR A 141      37.907  88.264  19.003  1.00 93.56           O  
ATOM    482  CB  THR A 141      40.930  87.735  20.223  1.00 97.15           C  
ATOM    483  OG1 THR A 141      41.771  87.710  21.385  1.00 98.44           O  
ATOM    484  CG2 THR A 141      41.773  88.137  19.026  1.00 97.56           C  
ATOM    485  N   GLU A 142      39.469  89.706  18.257  1.00 93.88           N  
ATOM    486  CA  GLU A 142      38.846  89.937  16.959  1.00 92.94           C  
ATOM    487  C   GLU A 142      39.323  88.847  16.002  1.00 90.22           C  
ATOM    488  O   GLU A 142      38.757  88.647  14.927  1.00 90.05           O  
ATOM    489  CB  GLU A 142      39.244  91.315  16.412  1.00 95.18           C  
ATOM    490  CG  GLU A 142      38.187  92.412  16.573  1.00 97.69           C  
ATOM    491  CD  GLU A 142      37.064  92.319  15.543  1.00 99.32           C  
ATOM    492  OE1 GLU A 142      36.266  91.358  15.603  1.00100.31           O  
ATOM    493  OE2 GLU A 142      36.983  93.209  14.669  1.00 99.71           O  
ATOM    494  N   ARG A 143      40.379  88.149  16.405  1.00 87.06           N  
ATOM    495  CA  ARG A 143      40.938  87.069  15.605  1.00 84.16           C  
ATOM    496  C   ARG A 143      39.958  85.901  15.523  1.00 80.71           C  
ATOM    497  O   ARG A 143      39.150  85.683  16.432  1.00 80.50           O  
ATOM    498  CB  ARG A 143      42.245  86.558  16.219  1.00 85.37           C  
ATOM    499  CG  ARG A 143      43.402  87.549  16.255  1.00 87.71           C  
ATOM    500  CD  ARG A 143      43.683  88.144  14.889  1.00 89.32           C  
ATOM    501  NE  ARG A 143      42.967  89.403  14.698  1.00 91.48           N  
ATOM    502  CZ  ARG A 143      43.246  90.526  15.354  1.00 92.16           C  
ATOM    503  NH1 ARG A 143      44.229  90.554  16.245  1.00 93.19           N  
ATOM    504  NH2 ARG A 143      42.544  91.625  15.117  0.00 92.27           N  
ATOM    505  N   PRO A 144      40.008  85.139  14.421  1.00 76.56           N  
ATOM    506  CA  PRO A 144      39.112  83.991  14.262  1.00 72.76           C  
ATOM    507  C   PRO A 144      39.548  82.865  15.208  1.00 69.32           C  
ATOM    508  O   PRO A 144      40.746  82.625  15.393  1.00 68.42           O  
ATOM    509  CB  PRO A 144      39.288  83.623  12.793  1.00 73.50           C  
ATOM    510  CG  PRO A 144      40.714  84.016  12.520  1.00 74.11           C  
ATOM    511  CD  PRO A 144      40.808  85.357  13.202  1.00 74.59           C  
ATOM    512  N   VAL A 145      38.579  82.181  15.807  1.00 65.36           N  
ATOM    513  CA  VAL A 145      38.888  81.100  16.732  1.00 61.35           C  
ATOM    514  C   VAL A 145      38.203  79.792  16.340  1.00 59.78           C  
ATOM    515  O   VAL A 145      36.998  79.752  16.087  1.00 59.48           O  
ATOM    516  CB  VAL A 145      38.468  81.473  18.173  1.00 59.64           C  
ATOM    517  CG1 VAL A 145      38.895  80.382  19.137  1.00 58.87           C  
ATOM    518  CG2 VAL A 145      39.089  82.802  18.567  0.00 60.06           C  
ATOM    519  N   VAL A 146      38.986  78.720  16.287  1.00 57.76           N  
ATOM    520  CA  VAL A 146      38.460  77.409  15.940  1.00 56.81           C  
ATOM    521  C   VAL A 146      38.782  76.423  17.062  1.00 56.66           C  
ATOM    522  O   VAL A 146      39.946  76.232  17.418  1.00 57.01           O  
ATOM    523  CB  VAL A 146      39.065  76.905  14.608  1.00 56.20           C  
ATOM    524  CG1 VAL A 146      40.578  76.926  14.683  1.00 57.17           C  
ATOM    525  CG2 VAL A 146      38.567  75.502  14.303  1.00 55.01           C  
ATOM    526  N   LEU A 147      37.738  75.814  17.622  1.00 55.64           N  
ATOM    527  CA  LEU A 147      37.878  74.844  18.707  1.00 54.51           C  
ATOM    528  C   LEU A 147      38.137  73.441  18.183  1.00 53.44           C  
ATOM    529  O   LEU A 147      37.586  73.046  17.160  1.00 54.24           O  
ATOM    530  CB  LEU A 147      36.606  74.797  19.551  1.00 55.08           C  
ATOM    531  CG  LEU A 147      36.234  75.975  20.442  1.00 57.12           C  
ATOM    532  CD1 LEU A 147      34.875  75.713  21.061  1.00 57.79           C  
ATOM    533  CD2 LEU A 147      37.277  76.150  21.528  1.00 59.28           C  
ATOM    534  N   VAL A 148      38.973  72.690  18.889  1.00 51.22           N  
ATOM    535  CA  VAL A 148      39.264  71.322  18.505  1.00 50.74           C  
ATOM    536  C   VAL A 148      39.150  70.462  19.752  1.00 52.28           C  
ATOM    537  O   VAL A 148      39.651  70.832  20.813  1.00 51.48           O  
ATOM    538  CB  VAL A 148      40.677  71.171  17.888  1.00 49.33           C  
ATOM    539  CG1 VAL A 148      41.740  71.598  18.881  1.00 48.93           C  
ATOM    540  CG2 VAL A 148      40.895  69.723  17.452  1.00 46.80           C  
ATOM    541  N   ASP A 149      38.483  69.318  19.613  1.00 54.04           N  
ATOM    542  CA  ASP A 149      38.255  68.402  20.722  1.00 55.38           C  
ATOM    543  C   ASP A 149      37.260  69.052  21.668  1.00 56.24           C  
ATOM    544  O   ASP A 149      37.171  68.697  22.841  1.00 54.99           O  
ATOM    545  CB  ASP A 149      39.554  68.114  21.469  1.00 57.20           C  
ATOM    546  CG  ASP A 149      39.375  67.077  22.555  1.00 58.93           C  
ATOM    547  OD1 ASP A 149      39.128  65.903  22.216  1.00 59.59           O  
ATOM    548  OD2 ASP A 149      39.465  67.436  23.747  1.00 60.50           O  
ATOM    549  N   ALA A 150      36.521  70.023  21.141  1.00 58.56           N  
ATOM    550  CA  ALA A 150      35.512  70.755  21.904  1.00 59.68           C  
ATOM    551  C   ALA A 150      34.400  71.192  20.961  1.00 60.30           C  
ATOM    552  O   ALA A 150      34.567  71.156  19.745  1.00 60.63           O  
ATOM    553  CB  ALA A 150      36.143  71.974  22.571  1.00 59.40           C  
ATOM    554  N   GLN A 151      33.265  71.595  21.523  1.00 61.95           N  
ATOM    555  CA  GLN A 151      32.129  72.044  20.726  1.00 63.25           C  
ATOM    556  C   GLN A 151      31.593  73.357  21.254  1.00 63.94           C  
ATOM    557  O   GLN A 151      31.585  73.596  22.459  1.00 64.69           O  
ATOM    558  CB  GLN A 151      30.993  71.030  20.755  1.00 62.99           C  
ATOM    559  CG  GLN A 151      31.305  69.703  20.132  1.00 65.35           C  
ATOM    560  CD  GLN A 151      30.080  68.825  20.073  1.00 68.18           C  
ATOM    561  OE1 GLN A 151      29.088  69.176  19.437  1.00 69.59           O  
ATOM    562  NE2 GLN A 151      30.134  67.676  20.744  1.00 69.59           N  
ATOM    563  N   ASN A 152      31.127  74.202  20.348  1.00 65.04           N  
ATOM    564  CA  ASN A 152      30.581  75.488  20.731  1.00 65.37           C  
ATOM    565  C   ASN A 152      29.719  76.018  19.591  1.00 65.39           C  
ATOM    566  O   ASN A 152      30.113  75.976  18.424  1.00 65.46           O  
ATOM    567  CB  ASN A 152      31.717  76.468  21.034  1.00 66.48           C  
ATOM    568  CG  ASN A 152      31.233  77.727  21.710  1.00 67.32           C  
ATOM    569  OD1 ASN A 152      30.654  77.673  22.787  1.00 68.68           O  
ATOM    570  ND2 ASN A 152      31.469  78.869  21.081  1.00 68.38           N  
ATOM    571  N   PRO A 153      28.520  76.510  19.918  1.00 64.84           N  
ATOM    572  CA  PRO A 153      27.587  77.054  18.931  1.00 64.52           C  
ATOM    573  C   PRO A 153      28.119  78.301  18.230  1.00 64.86           C  
ATOM    574  O   PRO A 153      27.653  78.654  17.145  1.00 65.72           O  
ATOM    575  CB  PRO A 153      26.349  77.365  19.763  1.00 64.80           C  
ATOM    576  CG  PRO A 153      26.422  76.359  20.871  1.00 65.20           C  
ATOM    577  CD  PRO A 153      27.878  76.401  21.238  1.00 65.14           C  
ATOM    578  N   ARG A 154      29.102  78.955  18.845  1.00 64.00           N  
ATOM    579  CA  ARG A 154      29.661  80.186  18.295  1.00 62.62           C  
ATOM    580  C   ARG A 154      31.018  80.087  17.621  1.00 60.57           C  
ATOM    581  O   ARG A 154      31.531  81.088  17.124  1.00 60.76           O  
ATOM    582  CB  ARG A 154      29.746  81.255  19.387  1.00 65.04           C  
ATOM    583  CG  ARG A 154      28.448  81.500  20.134  1.00 66.32           C  
ATOM    584  CD  ARG A 154      28.421  80.738  21.440  0.00 66.23           C  
ATOM    585  NE  ARG A 154      29.503  81.167  22.321  0.00 66.46           N  
ATOM    586  CZ  ARG A 154      29.685  80.710  23.554  0.00 66.53           C  
ATOM    587  NH1 ARG A 154      28.856  79.807  24.052  1.00 66.30           N  
ATOM    588  NH2 ARG A 154      30.695  81.156  24.288  0.00 66.65           N  
ATOM    589  N   TYR A 155      31.608  78.903  17.599  1.00 59.12           N  
ATOM    590  CA  TYR A 155      32.916  78.748  16.973  1.00 59.03           C  
ATOM    591  C   TYR A 155      33.001  77.469  16.152  1.00 56.72           C  
ATOM    592  O   TYR A 155      32.324  76.487  16.459  1.00 56.19           O  
ATOM    593  CB  TYR A 155      34.011  78.731  18.046  1.00 62.11           C  
ATOM    594  CG  TYR A 155      34.194  80.045  18.784  1.00 66.14           C  
ATOM    595  CD1 TYR A 155      34.906  81.096  18.210  1.00 67.27           C  
ATOM    596  CD2 TYR A 155      33.664  80.230  20.062  1.00 66.73           C  
ATOM    597  CE1 TYR A 155      35.090  82.294  18.891  1.00 69.75           C  
ATOM    598  CE2 TYR A 155      33.838  81.424  20.752  1.00 68.43           C  
ATOM    599  CZ  TYR A 155      34.556  82.455  20.164  1.00 70.36           C  
ATOM    600  OH  TYR A 155      34.753  83.639  20.849  1.00 71.03           O  
ATOM    601  N   ASP A 156      33.818  77.488  15.100  1.00 54.11           N  
ATOM    602  CA  ASP A 156      34.010  76.294  14.287  1.00 51.08           C  
ATOM    603  C   ASP A 156      34.598  75.271  15.254  1.00 51.73           C  
ATOM    604  O   ASP A 156      35.551  75.568  15.982  1.00 51.25           O  
ATOM    605  CB  ASP A 156      34.996  76.545  13.147  1.00 47.54           C  
ATOM    606  CG  ASP A 156      34.442  77.472  12.085  1.00 46.58           C  
ATOM    607  OD1 ASP A 156      33.203  77.560  11.956  1.00 44.88           O  
ATOM    608  OD2 ASP A 156      35.247  78.101  11.365  1.00 44.42           O  
ATOM    609  N   SER A 157      34.039  74.069  15.263  1.00 51.61           N  
ATOM    610  CA  SER A 157      34.508  73.056  16.182  1.00 50.12           C  
ATOM    611  C   SER A 157      34.704  71.686  15.569  1.00 49.90           C  
ATOM    612  O   SER A 157      33.829  71.170  14.873  1.00 52.08           O  
ATOM    613  CB  SER A 157      33.519  72.923  17.337  1.00 50.03           C  
ATOM    614  OG  SER A 157      33.124  74.191  17.828  1.00 51.54           O  
ATOM    615  N   VAL A 158      35.862  71.096  15.829  1.00 47.73           N  
ATOM    616  CA  VAL A 158      36.131  69.749  15.369  1.00 45.46           C  
ATOM    617  C   VAL A 158      36.082  68.956  16.680  1.00 44.63           C  
ATOM    618  O   VAL A 158      36.497  69.451  17.729  1.00 44.39           O  
ATOM    619  CB  VAL A 158      37.512  69.647  14.653  1.00 44.58           C  
ATOM    620  CG1 VAL A 158      38.123  71.015  14.536  1.00 43.71           C  
ATOM    621  CG2 VAL A 158      38.436  68.671  15.369  1.00 45.26           C  
ATOM    622  N   TYR A 159      35.530  67.753  16.641  1.00 43.03           N  
ATOM    623  CA  TYR A 159      35.422  66.946  17.851  1.00 40.78           C  
ATOM    624  C   TYR A 159      35.187  65.491  17.498  1.00 39.52           C  
ATOM    625  O   TYR A 159      34.872  65.169  16.359  1.00 38.23           O  
ATOM    626  CB  TYR A 159      34.266  67.437  18.722  1.00 39.48           C  
ATOM    627  CG  TYR A 159      32.933  67.357  18.022  1.00 39.06           C  
ATOM    628  CD1 TYR A 159      32.563  68.321  17.078  1.00 40.12           C  
ATOM    629  CD2 TYR A 159      32.065  66.292  18.257  1.00 36.82           C  
ATOM    630  CE1 TYR A 159      31.363  68.221  16.384  1.00 39.56           C  
ATOM    631  CE2 TYR A 159      30.863  66.181  17.562  1.00 36.91           C  
ATOM    632  CZ  TYR A 159      30.517  67.149  16.625  1.00 39.10           C  
ATOM    633  OH  TYR A 159      29.346  67.035  15.910  1.00 38.47           O  
ATOM    634  N   LEU A 160      35.334  64.623  18.495  1.00 40.10           N  
ATOM    635  CA  LEU A 160      35.149  63.193  18.312  1.00 41.54           C  
ATOM    636  C   LEU A 160      33.865  62.699  18.957  1.00 43.39           C  
ATOM    637  O   LEU A 160      33.418  63.249  19.957  1.00 44.79           O  
ATOM    638  CB  LEU A 160      36.315  62.431  18.938  1.00 40.08           C  
ATOM    639  CG  LEU A 160      36.336  60.945  18.582  1.00 39.29           C  
ATOM    640  CD1 LEU A 160      37.279  60.757  17.416  1.00 40.26           C  
ATOM    641  CD2 LEU A 160      36.781  60.111  19.757  1.00 37.07           C  
ATOM    642  N   ASP A 161      33.278  61.657  18.381  1.00 45.29           N  
ATOM    643  CA  ASP A 161      32.068  61.064  18.943  1.00 46.94           C  
ATOM    644  C   ASP A 161      32.541  60.068  20.008  1.00 47.54           C  
ATOM    645  O   ASP A 161      32.667  58.871  19.740  1.00 47.16           O  
ATOM    646  CB  ASP A 161      31.278  60.317  17.866  1.00 47.83           C  
ATOM    647  CG  ASP A 161      29.907  59.866  18.351  1.00 48.72           C  
ATOM    648  OD1 ASP A 161      29.796  59.352  19.483  1.00 48.88           O  
ATOM    649  OD2 ASP A 161      28.934  60.018  17.589  1.00 50.12           O  
ATOM    650  N   ASN A 162      32.815  60.570  21.208  1.00 48.44           N  
ATOM    651  CA  ASN A 162      33.284  59.728  22.303  1.00 49.33           C  
ATOM    652  C   ASN A 162      32.272  58.726  22.830  1.00 48.60           C  
ATOM    653  O   ASN A 162      32.664  57.697  23.369  1.00 47.11           O  
ATOM    654  CB  ASN A 162      33.784  60.600  23.455  1.00 51.47           C  
ATOM    655  CG  ASN A 162      35.232  61.016  23.279  1.00 52.93           C  
ATOM    656  OD1 ASN A 162      36.152  60.222  23.499  1.00 53.03           O  
ATOM    657  ND2 ASN A 162      35.443  62.261  22.865  1.00 53.08           N  
ATOM    658  N   ARG A 163      30.980  59.023  22.692  1.00 49.45           N  
ATOM    659  CA  ARG A 163      29.942  58.105  23.167  1.00 49.23           C  
ATOM    660  C   ARG A 163      30.063  56.853  22.315  1.00 48.24           C  
ATOM    661  O   ARG A 163      30.001  55.730  22.816  1.00 47.89           O  
ATOM    662  CB  ARG A 163      28.551  58.712  23.009  1.00 51.65           C  
ATOM    663  CG  ARG A 163      27.525  58.099  23.942  1.00 54.79           C  
ATOM    664  CD  ARG A 163      26.114  58.377  23.481  1.00 60.70           C  
ATOM    665  NE  ARG A 163      25.129  58.068  24.516  1.00 65.61           N  
ATOM    666  CZ  ARG A 163      24.934  58.803  25.609  1.00 67.75           C  
ATOM    667  NH1 ARG A 163      25.655  59.903  25.822  1.00 66.84           N  
ATOM    668  NH2 ARG A 163      24.012  58.437  26.490  1.00 68.35           N  
ATOM    669  N   LEU A 164      30.211  57.060  21.014  1.00 46.72           N  
ATOM    670  CA  LEU A 164      30.423  55.960  20.098  1.00 46.29           C  
ATOM    671  C   LEU A 164      31.877  55.645  20.439  1.00 47.39           C  
ATOM    672  O   LEU A 164      32.673  56.558  20.693  1.00 49.09           O  
ATOM    673  CB  LEU A 164      30.312  56.449  18.656  1.00 46.05           C  
ATOM    674  CG  LEU A 164      30.705  55.458  17.563  1.00 45.50           C  
ATOM    675  CD1 LEU A 164      29.633  54.393  17.433  1.00 47.50           C  
ATOM    676  CD2 LEU A 164      30.879  56.191  16.255  1.00 45.66           C  
ATOM    677  N   GLY A 165      32.252  54.379  20.451  1.00 46.05           N  
ATOM    678  CA  GLY A 165      33.628  54.085  20.818  1.00 45.84           C  
ATOM    679  C   GLY A 165      33.538  53.591  22.239  1.00 44.00           C  
ATOM    680  O   GLY A 165      34.187  52.620  22.617  1.00 42.84           O  
ATOM    681  N   GLY A 166      32.735  54.289  23.037  1.00 43.25           N  
ATOM    682  CA  GLY A 166      32.500  53.841  24.390  1.00 42.40           C  
ATOM    683  C   GLY A 166      31.666  52.605  24.109  1.00 41.85           C  
ATOM    684  O   GLY A 166      31.789  51.571  24.765  1.00 40.89           O  
ATOM    685  N   ARG A 167      30.827  52.723  23.080  1.00 42.27           N  
ATOM    686  CA  ARG A 167      29.960  51.636  22.647  1.00 41.31           C  
ATOM    687  C   ARG A 167      30.778  50.603  21.898  1.00 39.29           C  
ATOM    688  O   ARG A 167      30.566  49.406  22.060  1.00 38.51           O  
ATOM    689  CB  ARG A 167      28.838  52.158  21.746  1.00 43.08           C  
ATOM    690  CG  ARG A 167      27.861  53.076  22.446  1.00 46.15           C  
ATOM    691  CD  ARG A 167      26.536  53.119  21.715  1.00 49.31           C  
ATOM    692  NE  ARG A 167      26.655  53.711  20.388  1.00 54.22           N  
ATOM    693  CZ  ARG A 167      26.617  55.018  20.140  1.00 57.69           C  
ATOM    694  NH1 ARG A 167      26.459  55.883  21.135  1.00 59.15           N  
ATOM    695  NH2 ARG A 167      26.728  55.459  18.894  1.00 58.35           N  
ATOM    696  N   LEU A 168      31.712  51.063  21.075  1.00 37.36           N  
ATOM    697  CA  LEU A 168      32.553  50.130  20.342  1.00 37.13           C  
ATOM    698  C   LEU A 168      33.294  49.270  21.367  1.00 36.83           C  
ATOM    699  O   LEU A 168      33.491  48.071  21.166  1.00 38.17           O  
ATOM    700  CB  LEU A 168      33.540  50.887  19.450  1.00 36.90           C  
ATOM    701  CG  LEU A 168      32.948  51.725  18.306  1.00 36.44           C  
ATOM    702  CD1 LEU A 168      34.045  52.531  17.619  1.00 35.28           C  
ATOM    703  CD2 LEU A 168      32.256  50.816  17.317  1.00 34.11           C  
ATOM    704  N   ALA A 169      33.672  49.888  22.482  1.00 35.50           N  
ATOM    705  CA  ALA A 169      34.374  49.198  23.557  1.00 33.92           C  
ATOM    706  C   ALA A 169      33.467  48.212  24.294  1.00 33.21           C  
ATOM    707  O   ALA A 169      33.841  47.059  24.524  1.00 30.88           O  
ATOM    708  CB  ALA A 169      34.935  50.213  24.545  1.00 33.68           C  
ATOM    709  N   GLY A 170      32.282  48.675  24.676  1.00 33.26           N  
ATOM    710  CA  GLY A 170      31.350  47.817  25.388  1.00 34.46           C  
ATOM    711  C   GLY A 170      30.929  46.594  24.587  1.00 35.30           C  
ATOM    712  O   GLY A 170      31.045  45.457  25.062  1.00 35.94           O  
ATOM    713  N   ALA A 171      30.438  46.831  23.372  1.00 33.81           N  
ATOM    714  CA  ALA A 171      29.997  45.762  22.487  1.00 33.27           C  
ATOM    715  C   ALA A 171      31.130  44.804  22.175  1.00 34.48           C  
ATOM    716  O   ALA A 171      30.899  43.634  21.898  1.00 35.84           O  
ATOM    717  CB  ALA A 171      29.451  46.345  21.197  1.00 30.82           C  
ATOM    718  N   TYR A 172      32.359  45.302  22.222  1.00 35.85           N  
ATOM    719  CA  TYR A 172      33.510  44.470  21.922  1.00 36.85           C  
ATOM    720  C   TYR A 172      33.889  43.562  23.082  1.00 37.66           C  
ATOM    721  O   TYR A 172      34.042  42.351  22.905  1.00 37.90           O  
ATOM    722  CB  TYR A 172      34.714  45.335  21.540  1.00 37.21           C  
ATOM    723  CG  TYR A 172      35.950  44.519  21.238  1.00 39.48           C  
ATOM    724  CD1 TYR A 172      35.979  43.651  20.146  1.00 40.76           C  
ATOM    725  CD2 TYR A 172      37.094  44.609  22.040  1.00 39.41           C  
ATOM    726  CE1 TYR A 172      37.111  42.894  19.852  1.00 42.98           C  
ATOM    727  CE2 TYR A 172      38.239  43.859  21.759  1.00 40.50           C  
ATOM    728  CZ  TYR A 172      38.238  43.000  20.659  1.00 43.44           C  
ATOM    729  OH  TYR A 172      39.345  42.245  20.355  1.00 43.14           O  
ATOM    730  N   LEU A 173      34.055  44.158  24.262  1.00 38.70           N  
ATOM    731  CA  LEU A 173      34.426  43.422  25.465  1.00 38.65           C  
ATOM    732  C   LEU A 173      33.327  42.449  25.851  1.00 39.62           C  
ATOM    733  O   LEU A 173      33.582  41.411  26.460  1.00 40.47           O  
ATOM    734  CB  LEU A 173      34.678  44.400  26.606  1.00 39.57           C  
ATOM    735  CG  LEU A 173      36.119  44.581  27.083  1.00 39.61           C  
ATOM    736  CD1 LEU A 173      37.078  44.492  25.923  1.00 38.62           C  
ATOM    737  CD2 LEU A 173      36.235  45.918  27.796  1.00 39.06           C  
ATOM    738  N   ALA A 174      32.101  42.799  25.481  1.00 39.34           N  
ATOM    739  CA  ALA A 174      30.940  41.972  25.755  1.00 39.28           C  
ATOM    740  C   ALA A 174      31.026  40.622  25.048  1.00 40.79           C  
ATOM    741  O   ALA A 174      30.142  39.788  25.188  1.00 43.40           O  
ATOM    742  CB  ALA A 174      29.693  42.700  25.312  1.00 36.20           C  
ATOM    743  N   ARG A 175      32.090  40.395  24.296  1.00 41.37           N  
ATOM    744  CA  ARG A 175      32.222  39.146  23.565  1.00 41.99           C  
ATOM    745  C   ARG A 175      33.232  38.210  24.209  1.00 42.95           C  
ATOM    746  O   ARG A 175      33.612  37.201  23.615  1.00 43.05           O  
ATOM    747  CB  ARG A 175      32.643  39.444  22.128  1.00 43.68           C  
ATOM    748  CG  ARG A 175      31.816  40.531  21.447  1.00 46.92           C  
ATOM    749  CD  ARG A 175      32.395  40.887  20.094  1.00 50.18           C  
ATOM    750  NE  ARG A 175      32.439  39.711  19.234  1.00 55.52           N  
ATOM    751  CZ  ARG A 175      33.232  39.580  18.177  1.00 57.15           C  
ATOM    752  NH1 ARG A 175      34.058  40.560  17.839  1.00 56.89           N  
ATOM    753  NH2 ARG A 175      33.202  38.458  17.468  1.00 59.07           N  
ATOM    754  N   PHE A 176      33.654  38.540  25.427  1.00 44.05           N  
ATOM    755  CA  PHE A 176      34.645  37.734  26.140  1.00 42.99           C  
ATOM    756  C   PHE A 176      34.199  37.196  27.496  1.00 42.68           C  
ATOM    757  O   PHE A 176      33.332  37.759  28.156  1.00 41.15           O  
ATOM    758  CB  PHE A 176      35.930  38.542  26.361  1.00 43.18           C  
ATOM    759  CG  PHE A 176      36.552  39.055  25.103  1.00 42.68           C  
ATOM    760  CD1 PHE A 176      35.977  40.115  24.406  1.00 43.50           C  
ATOM    761  CD2 PHE A 176      37.717  38.480  24.613  1.00 40.99           C  
ATOM    762  CE1 PHE A 176      36.556  40.596  23.236  1.00 43.99           C  
ATOM    763  CE2 PHE A 176      38.307  38.947  23.451  1.00 42.52           C  
ATOM    764  CZ  PHE A 176      37.725  40.012  22.756  1.00 43.40           C  
ATOM    765  N   PRO A 177      34.803  36.081  27.923  1.00 43.76           N  
ATOM    766  CA  PRO A 177      34.509  35.430  29.204  1.00 44.13           C  
ATOM    767  C   PRO A 177      35.062  36.256  30.380  1.00 44.89           C  
ATOM    768  O   PRO A 177      35.978  37.065  30.204  1.00 45.24           O  
ATOM    769  CB  PRO A 177      35.221  34.084  29.075  1.00 43.56           C  
ATOM    770  CG  PRO A 177      35.233  33.841  27.600  1.00 42.28           C  
ATOM    771  CD  PRO A 177      35.579  35.184  27.049  1.00 42.90           C  
ATOM    772  N   GLY A 178      34.508  36.050  31.573  1.00 44.06           N  
ATOM    773  CA  GLY A 178      34.976  36.777  32.737  1.00 42.96           C  
ATOM    774  C   GLY A 178      34.358  38.157  32.861  1.00 42.96           C  
ATOM    775  O   GLY A 178      34.043  38.779  31.845  1.00 43.64           O  
ATOM    776  N   PRO A 179      34.182  38.670  34.095  1.00 41.46           N  
ATOM    777  CA  PRO A 179      33.597  39.984  34.391  1.00 39.89           C  
ATOM    778  C   PRO A 179      34.317  41.156  33.734  1.00 38.43           C  
ATOM    779  O   PRO A 179      35.538  41.178  33.621  1.00 38.69           O  
ATOM    780  CB  PRO A 179      33.662  40.051  35.909  1.00 39.86           C  
ATOM    781  CG  PRO A 179      34.897  39.264  36.205  1.00 41.64           C  
ATOM    782  CD  PRO A 179      34.725  38.067  35.323  1.00 40.43           C  
ATOM    783  N   ILE A 180      33.541  42.139  33.314  1.00 37.29           N  
ATOM    784  CA  ILE A 180      34.071  43.315  32.655  1.00 36.55           C  
ATOM    785  C   ILE A 180      34.189  44.496  33.624  1.00 36.63           C  
ATOM    786  O   ILE A 180      33.212  44.879  34.283  1.00 36.02           O  
ATOM    787  CB  ILE A 180      33.164  43.704  31.485  1.00 35.24           C  
ATOM    788  CG1 ILE A 180      33.072  42.531  30.504  1.00 34.08           C  
ATOM    789  CG2 ILE A 180      33.686  44.966  30.826  1.00 35.32           C  
ATOM    790  CD1 ILE A 180      31.959  42.651  29.483  1.00 32.57           C  
ATOM    791  N   PHE A 181      35.393  45.056  33.714  1.00 35.05           N  
ATOM    792  CA  PHE A 181      35.659  46.192  34.588  1.00 34.32           C  
ATOM    793  C   PHE A 181      36.020  47.386  33.727  1.00 35.31           C  
ATOM    794  O   PHE A 181      36.397  47.238  32.565  1.00 35.82           O  
ATOM    795  CB  PHE A 181      36.831  45.912  35.535  1.00 31.88           C  
ATOM    796  CG  PHE A 181      36.611  44.760  36.467  1.00 29.17           C  
ATOM    797  CD1 PHE A 181      36.885  43.462  36.065  1.00 28.15           C  
ATOM    798  CD2 PHE A 181      36.132  44.977  37.756  1.00 29.37           C  
ATOM    799  CE1 PHE A 181      36.694  42.397  36.923  1.00 29.76           C  
ATOM    800  CE2 PHE A 181      35.937  43.917  38.626  1.00 30.60           C  
ATOM    801  CZ  PHE A 181      36.219  42.619  38.207  1.00 30.91           C  
ATOM    802  N   ALA A 182      35.919  48.571  34.312  1.00 35.90           N  
ATOM    803  CA  ALA A 182      36.236  49.794  33.605  1.00 36.84           C  
ATOM    804  C   ALA A 182      37.001  50.759  34.505  1.00 37.48           C  
ATOM    805  O   ALA A 182      36.828  50.767  35.732  1.00 35.94           O  
ATOM    806  CB  ALA A 182      34.958  50.448  33.102  1.00 36.09           C  
ATOM    807  N   ILE A 183      37.858  51.562  33.882  1.00 39.23           N  
ATOM    808  CA  ILE A 183      38.644  52.547  34.603  1.00 41.22           C  
ATOM    809  C   ILE A 183      38.210  53.923  34.107  1.00 43.27           C  
ATOM    810  O   ILE A 183      38.200  54.186  32.902  1.00 43.59           O  
ATOM    811  CB  ILE A 183      40.170  52.357  34.363  1.00 40.02           C  
ATOM    812  CG1 ILE A 183      40.578  50.922  34.699  1.00 40.72           C  
ATOM    813  CG2 ILE A 183      40.964  53.320  35.240  1.00 39.55           C  
ATOM    814  CD1 ILE A 183      42.041  50.638  34.525  1.00 41.38           C  
ATOM    815  N   ALA A 184      37.831  54.785  35.045  1.00 45.15           N  
ATOM    816  CA  ALA A 184      37.389  56.132  34.723  1.00 47.06           C  
ATOM    817  C   ALA A 184      38.418  57.148  35.201  1.00 49.52           C  
ATOM    818  O   ALA A 184      38.800  57.162  36.373  1.00 48.16           O  
ATOM    819  CB  ALA A 184      36.041  56.399  35.373  1.00 45.96           C  
ATOM    820  N   VAL A 185      38.871  57.993  34.284  1.00 54.14           N  
ATOM    821  CA  VAL A 185      39.859  59.011  34.616  1.00 59.60           C  
ATOM    822  C   VAL A 185      39.196  60.227  35.257  1.00 64.64           C  
ATOM    823  O   VAL A 185      38.244  60.793  34.714  1.00 65.08           O  
ATOM    824  CB  VAL A 185      40.636  59.449  33.367  1.00 58.68           C  
ATOM    825  CG1 VAL A 185      41.672  60.493  33.739  1.00 58.36           C  
ATOM    826  CG2 VAL A 185      41.296  58.237  32.725  1.00 57.99           C  
ATOM    827  N   GLU A 186      39.716  60.617  36.418  1.00 70.09           N  
ATOM    828  CA  GLU A 186      39.185  61.739  37.180  1.00 74.78           C  
ATOM    829  C   GLU A 186      40.233  62.827  37.412  1.00 77.87           C  
ATOM    830  O   GLU A 186      40.956  62.805  38.409  1.00 78.66           O  
ATOM    831  CB  GLU A 186      38.667  61.226  38.531  1.00 76.08           C  
ATOM    832  CG  GLU A 186      37.983  62.265  39.413  1.00 78.94           C  
ATOM    833  CD  GLU A 186      36.612  62.661  38.900  1.00 80.35           C  
ATOM    834  OE1 GLU A 186      35.757  61.765  38.728  1.00 81.24           O  
ATOM    835  OE2 GLU A 186      36.389  63.870  38.676  1.00 81.71           O  
ATOM    836  N   GLU A 187      40.317  63.776  36.485  1.00 81.57           N  
ATOM    837  CA  GLU A 187      41.261  64.882  36.616  1.00 85.27           C  
ATOM    838  C   GLU A 187      40.508  66.155  36.984  1.00 87.38           C  
ATOM    839  O   GLU A 187      39.555  66.542  36.301  1.00 87.39           O  
ATOM    840  CB  GLU A 187      42.027  65.101  35.311  1.00 85.99           C  
ATOM    841  CG  GLU A 187      43.088  64.054  35.028  1.00 87.43           C  
ATOM    842  CD  GLU A 187      44.057  63.880  36.182  1.00 88.38           C  
ATOM    843  OE1 GLU A 187      44.306  64.867  36.908  1.00 88.87           O  
ATOM    844  OE2 GLU A 187      44.579  62.758  36.354  1.00 88.31           O  
ATOM    845  N   GLU A 188      40.945  66.796  38.067  1.00 90.14           N  
ATOM    846  CA  GLU A 188      40.327  68.024  38.566  1.00 92.73           C  
ATOM    847  C   GLU A 188      39.820  68.962  37.464  1.00 94.15           C  
ATOM    848  O   GLU A 188      38.716  69.496  37.567  1.00 94.32           O  
ATOM    849  CB  GLU A 188      41.310  68.756  39.491  1.00 93.01           C  
ATOM    850  CG  GLU A 188      40.815  70.090  40.022  1.00 93.98           C  
ATOM    851  CD  GLU A 188      41.075  71.229  39.060  1.00 94.64           C  
ATOM    852  OE1 GLU A 188      42.259  71.489  38.751  1.00 94.43           O  
ATOM    853  OE2 GLU A 188      40.095  71.864  38.614  1.00 94.68           O  
ATOM    854  N   PRO A 189      40.621  69.182  36.403  1.00 95.24           N  
ATOM    855  CA  PRO A 189      40.198  70.062  35.308  1.00 96.06           C  
ATOM    856  C   PRO A 189      39.126  69.423  34.422  1.00 97.22           C  
ATOM    857  O   PRO A 189      39.439  68.758  33.437  1.00 97.89           O  
ATOM    858  CB  PRO A 189      41.496  70.307  34.539  1.00 95.38           C  
ATOM    859  CG  PRO A 189      42.548  70.157  35.587  1.00 95.26           C  
ATOM    860  CD  PRO A 189      42.071  68.937  36.327  1.00 95.24           C  
ATOM    861  N   ASP A 190      37.865  69.628  34.779  1.00 98.64           N  
ATOM    862  CA  ASP A 190      36.752  69.077  34.014  1.00 99.74           C  
ATOM    863  C   ASP A 190      35.836  70.211  33.556  1.00100.30           C  
ATOM    864  O   ASP A 190      34.739  69.978  33.037  1.00100.27           O  
ATOM    865  CB  ASP A 190      35.961  68.080  34.869  1.00100.02           C  
ATOM    866  CG  ASP A 190      35.439  68.695  36.156  1.00100.32           C  
ATOM    867  OD1 ASP A 190      36.255  68.988  37.057  1.00100.02           O  
ATOM    868  OD2 ASP A 190      34.209  68.890  36.264  1.00100.32           O  
ATOM    869  N   ARG A 191      36.302  71.442  33.753  1.00100.31           N  
ATOM    870  CA  ARG A 191      35.549  72.631  33.376  1.00 99.95           C  
ATOM    871  C   ARG A 191      36.417  73.548  32.521  1.00100.20           C  
ATOM    872  O   ARG A 191      37.513  73.941  32.927  1.00100.18           O  
ATOM    873  CB  ARG A 191      35.082  73.366  34.628  1.00 98.95           C  
ATOM    874  N   ARG A 195      34.092  69.631  30.671  1.00 74.79           N  
ATOM    875  CA  ARG A 195      34.754  68.543  29.955  1.00 75.05           C  
ATOM    876  C   ARG A 195      34.140  67.205  30.370  1.00 74.85           C  
ATOM    877  O   ARG A 195      34.148  66.838  31.548  1.00 75.42           O  
ATOM    878  CB  ARG A 195      36.257  68.563  30.249  1.00 74.21           C  
ATOM    879  CG  ARG A 195      37.072  67.571  29.441  1.00 74.33           C  
ATOM    880  CD  ARG A 195      38.557  67.856  29.589  1.00 74.80           C  
ATOM    881  NE  ARG A 195      39.395  66.778  29.072  1.00 74.66           N  
ATOM    882  CZ  ARG A 195      39.414  66.380  27.806  1.00 73.88           C  
ATOM    883  NH1 ARG A 195      38.635  66.968  26.908  1.00 72.81           N  
ATOM    884  NH2 ARG A 195      40.214  65.389  27.442  1.00 74.38           N  
ATOM    885  N   THR A 196      33.605  66.479  29.391  1.00 72.97           N  
ATOM    886  CA  THR A 196      32.958  65.204  29.664  1.00 69.90           C  
ATOM    887  C   THR A 196      33.305  64.064  28.695  1.00 67.82           C  
ATOM    888  O   THR A 196      32.528  63.121  28.541  1.00 66.60           O  
ATOM    889  CB  THR A 196      31.427  65.392  29.695  1.00 70.35           C  
ATOM    890  OG1 THR A 196      31.014  66.134  28.539  1.00 70.06           O  
ATOM    891  CG2 THR A 196      31.008  66.147  30.949  0.00 70.24           C  
ATOM    892  N   VAL A 197      34.467  64.149  28.052  1.00 65.48           N  
ATOM    893  CA  VAL A 197      34.906  63.108  27.125  1.00 62.54           C  
ATOM    894  C   VAL A 197      34.802  61.738  27.793  1.00 61.57           C  
ATOM    895  O   VAL A 197      34.414  60.757  27.163  1.00 62.29           O  
ATOM    896  CB  VAL A 197      36.372  63.329  26.677  1.00 62.08           C  
ATOM    897  CG1 VAL A 197      36.891  62.096  25.954  0.00 62.55           C  
ATOM    898  CG2 VAL A 197      36.459  64.535  25.760  1.00 62.46           C  
ATOM    899  N   PHE A 198      35.153  61.680  29.073  1.00 60.24           N  
ATOM    900  CA  PHE A 198      35.104  60.442  29.837  1.00 58.28           C  
ATOM    901  C   PHE A 198      33.675  60.103  30.225  1.00 57.19           C  
ATOM    902  O   PHE A 198      33.307  58.929  30.304  1.00 57.66           O  
ATOM    903  CB  PHE A 198      35.967  60.567  31.092  1.00 59.44           C  
ATOM    904  CG  PHE A 198      37.442  60.594  30.810  1.00 60.04           C  
ATOM    905  CD1 PHE A 198      38.111  59.427  30.443  1.00 59.34           C  
ATOM    906  CD2 PHE A 198      38.161  61.784  30.897  1.00 59.68           C  
ATOM    907  CE1 PHE A 198      39.471  59.448  30.168  1.00 59.22           C  
ATOM    908  CE2 PHE A 198      39.522  61.814  30.624  1.00 58.96           C  
ATOM    909  CZ  PHE A 198      40.179  60.644  30.257  1.00 59.57           C  
ATOM    910  N   ALA A 199      32.875  61.136  30.469  1.00 55.78           N  
ATOM    911  CA  ALA A 199      31.477  60.950  30.830  1.00 54.21           C  
ATOM    912  C   ALA A 199      30.761  60.316  29.645  1.00 53.97           C  
ATOM    913  O   ALA A 199      29.922  59.433  29.812  1.00 54.52           O  
ATOM    914  CB  ALA A 199      30.843  62.290  31.176  0.00 54.70           C  
ATOM    915  N   GLU A 200      31.106  60.770  28.444  1.00 53.40           N  
ATOM    916  CA  GLU A 200      30.516  60.254  27.214  1.00 51.56           C  
ATOM    917  C   GLU A 200      30.966  58.821  26.952  1.00 49.16           C  
ATOM    918  O   GLU A 200      30.139  57.950  26.679  1.00 48.70           O  
ATOM    919  CB  GLU A 200      30.897  61.154  26.032  1.00 53.93           C  
ATOM    920  CG  GLU A 200      30.226  62.520  26.062  1.00 60.51           C  
ATOM    921  CD  GLU A 200      28.744  62.459  25.701  1.00 65.74           C  
ATOM    922  OE1 GLU A 200      28.077  61.460  26.046  1.00 68.90           O  
ATOM    923  OE2 GLU A 200      28.237  63.419  25.080  1.00 68.04           O  
ATOM    924  N   ARG A 201      32.269  58.572  27.036  1.00 46.00           N  
ATOM    925  CA  ARG A 201      32.786  57.224  26.815  1.00 45.22           C  
ATOM    926  C   ARG A 201      32.093  56.223  27.726  1.00 44.24           C  
ATOM    927  O   ARG A 201      31.712  55.133  27.296  1.00 43.81           O  
ATOM    928  CB  ARG A 201      34.287  57.158  27.102  1.00 44.99           C  
ATOM    929  CG  ARG A 201      35.129  58.040  26.234  1.00 43.55           C  
ATOM    930  CD  ARG A 201      36.580  58.024  26.659  1.00 41.68           C  
ATOM    931  NE  ARG A 201      37.325  58.950  25.821  1.00 41.52           N  
ATOM    932  CZ  ARG A 201      38.620  59.201  25.925  1.00 40.17           C  
ATOM    933  NH1 ARG A 201      39.359  58.599  26.845  0.00 41.00           N  
ATOM    934  NH2 ARG A 201      39.166  60.069  25.091  1.00 41.94           N  
ATOM    935  N   MET A 202      31.938  56.599  28.992  1.00 43.55           N  
ATOM    936  CA  MET A 202      31.315  55.721  29.977  1.00 42.87           C  
ATOM    937  C   MET A 202      29.828  55.484  29.723  1.00 40.32           C  
ATOM    938  O   MET A 202      29.321  54.398  29.994  1.00 39.26           O  
ATOM    939  CB  MET A 202      31.535  56.266  31.398  1.00 42.37           C  
ATOM    940  CG  MET A 202      31.225  55.254  32.513  1.00 44.37           C  
ATOM    941  SD  MET A 202      32.163  53.687  32.439  1.00 42.68           S  
ATOM    942  CE  MET A 202      33.732  54.212  33.017  1.00 42.66           C  
ATOM    943  N   ALA A 203      29.137  56.487  29.190  1.00 39.70           N  
ATOM    944  CA  ALA A 203      27.708  56.359  28.910  1.00 39.15           C  
ATOM    945  C   ALA A 203      27.447  55.379  27.775  1.00 38.89           C  
ATOM    946  O   ALA A 203      26.521  54.570  27.848  1.00 39.81           O  
ATOM    947  CB  ALA A 203      27.121  57.706  28.569  1.00 38.09           C  
ATOM    948  N   GLY A 204      28.269  55.452  26.729  1.00 38.67           N  
ATOM    949  CA  GLY A 204      28.112  54.551  25.600  1.00 37.84           C  
ATOM    950  C   GLY A 204      28.538  53.153  25.993  1.00 37.93           C  
ATOM    951  O   GLY A 204      27.998  52.155  25.513  1.00 35.49           O  
ATOM    952  N   PHE A 205      29.523  53.089  26.880  1.00 39.42           N  
ATOM    953  CA  PHE A 205      30.028  51.818  27.363  1.00 40.59           C  
ATOM    954  C   PHE A 205      28.892  51.079  28.040  1.00 42.11           C  
ATOM    955  O   PHE A 205      28.658  49.905  27.774  1.00 41.85           O  
ATOM    956  CB  PHE A 205      31.160  52.041  28.365  1.00 38.45           C  
ATOM    957  CG  PHE A 205      31.847  50.771  28.795  1.00 36.87           C  
ATOM    958  CD1 PHE A 205      32.555  49.998  27.878  1.00 35.83           C  
ATOM    959  CD2 PHE A 205      31.801  50.354  30.121  1.00 35.36           C  
ATOM    960  CE1 PHE A 205      33.212  48.825  28.279  1.00 35.69           C  
ATOM    961  CE2 PHE A 205      32.457  49.183  30.528  1.00 36.66           C  
ATOM    962  CZ  PHE A 205      33.163  48.420  29.606  1.00 34.01           C  
ATOM    963  N   GLN A 206      28.180  51.779  28.911  1.00 45.60           N  
ATOM    964  CA  GLN A 206      27.072  51.177  29.628  1.00 51.65           C  
ATOM    965  C   GLN A 206      25.911  50.800  28.713  1.00 53.38           C  
ATOM    966  O   GLN A 206      25.276  49.765  28.902  1.00 53.63           O  
ATOM    967  CB  GLN A 206      26.578  52.124  30.719  1.00 55.00           C  
ATOM    968  CG  GLN A 206      27.663  52.568  31.673  1.00 59.87           C  
ATOM    969  CD  GLN A 206      27.096  53.225  32.904  1.00 63.15           C  
ATOM    970  OE1 GLN A 206      26.461  52.564  33.727  1.00 64.84           O  
ATOM    971  NE2 GLN A 206      27.310  54.536  33.039  1.00 64.27           N  
ATOM    972  N   GLU A 207      25.632  51.642  27.725  1.00 55.07           N  
ATOM    973  CA  GLU A 207      24.545  51.370  26.802  1.00 57.21           C  
ATOM    974  C   GLU A 207      24.828  50.118  25.983  1.00 55.72           C  
ATOM    975  O   GLU A 207      23.956  49.272  25.825  1.00 56.29           O  
ATOM    976  CB  GLU A 207      24.330  52.570  25.876  1.00 63.46           C  
ATOM    977  CG  GLU A 207      23.880  53.841  26.597  1.00 73.72           C  
ATOM    978  CD  GLU A 207      22.393  53.843  26.951  1.00 80.76           C  
ATOM    979  OE1 GLU A 207      21.927  52.900  27.636  1.00 84.20           O  
ATOM    980  OE2 GLU A 207      21.687  54.796  26.543  1.00 83.13           O  
ATOM    981  N   ALA A 208      26.046  49.992  25.469  1.00 53.37           N  
ATOM    982  CA  ALA A 208      26.401  48.829  24.673  1.00 52.25           C  
ATOM    983  C   ALA A 208      26.368  47.557  25.507  1.00 52.16           C  
ATOM    984  O   ALA A 208      25.870  46.526  25.056  1.00 52.12           O  
ATOM    985  CB  ALA A 208      27.782  49.015  24.051  1.00 52.51           C  
ATOM    986  N   LEU A 209      26.911  47.630  26.721  1.00 51.81           N  
ATOM    987  CA  LEU A 209      26.934  46.482  27.625  1.00 51.64           C  
ATOM    988  C   LEU A 209      25.522  46.018  27.935  1.00 51.89           C  
ATOM    989  O   LEU A 209      25.240  44.829  27.957  1.00 50.40           O  
ATOM    990  CB  LEU A 209      27.635  46.842  28.939  1.00 51.06           C  
ATOM    991  CG  LEU A 209      29.160  46.904  28.915  1.00 51.13           C  
ATOM    992  CD1 LEU A 209      29.664  47.257  30.304  1.00 47.77           C  
ATOM    993  CD2 LEU A 209      29.725  45.557  28.448  1.00 49.58           C  
ATOM    994  N   LYS A 210      24.643  46.978  28.181  1.00 54.03           N  
ATOM    995  CA  LYS A 210      23.254  46.687  28.486  1.00 56.58           C  
ATOM    996  C   LYS A 210      22.623  45.953  27.316  1.00 56.89           C  
ATOM    997  O   LYS A 210      22.045  44.880  27.477  1.00 57.39           O  
ATOM    998  CB  LYS A 210      22.499  47.991  28.742  1.00 59.05           C  
ATOM    999  CG  LYS A 210      21.059  47.810  29.159  1.00 62.74           C  
ATOM   1000  CD  LYS A 210      20.413  49.146  29.476  1.00 66.17           C  
ATOM   1001  CE  LYS A 210      19.002  48.950  30.025  1.00 69.19           C  
ATOM   1002  NZ  LYS A 210      18.339  50.245  30.367  1.00 72.86           N  
ATOM   1003  N   GLU A 211      22.761  46.541  26.133  1.00 57.46           N  
ATOM   1004  CA  GLU A 211      22.197  45.987  24.913  1.00 58.39           C  
ATOM   1005  C   GLU A 211      22.755  44.622  24.549  1.00 56.74           C  
ATOM   1006  O   GLU A 211      22.204  43.936  23.690  1.00 57.94           O  
ATOM   1007  CB  GLU A 211      22.414  46.974  23.760  1.00 61.69           C  
ATOM   1008  CG  GLU A 211      21.886  48.366  24.090  1.00 68.71           C  
ATOM   1009  CD  GLU A 211      22.033  49.362  22.954  1.00 72.53           C  
ATOM   1010  OE1 GLU A 211      23.155  49.503  22.416  1.00 73.50           O  
ATOM   1011  OE2 GLU A 211      21.020  50.012  22.611  1.00 74.92           O  
ATOM   1012  N   ALA A 212      23.832  44.215  25.208  1.00 53.82           N  
ATOM   1013  CA  ALA A 212      24.440  42.923  24.920  1.00 50.91           C  
ATOM   1014  C   ALA A 212      24.119  41.870  25.979  1.00 50.13           C  
ATOM   1015  O   ALA A 212      24.619  40.744  25.914  1.00 49.72           O  
ATOM   1016  CB  ALA A 212      25.941  43.083  24.778  1.00 49.09           C  
ATOM   1017  N   GLY A 213      23.289  42.240  26.952  1.00 48.99           N  
ATOM   1018  CA  GLY A 213      22.912  41.315  28.009  1.00 48.33           C  
ATOM   1019  C   GLY A 213      23.850  41.250  29.206  1.00 47.68           C  
ATOM   1020  O   GLY A 213      23.585  40.528  30.174  1.00 48.19           O  
ATOM   1021  N   ARG A 214      24.946  42.004  29.149  1.00 46.01           N  
ATOM   1022  CA  ARG A 214      25.925  42.017  30.228  1.00 42.95           C  
ATOM   1023  C   ARG A 214      26.065  43.413  30.822  1.00 42.08           C  
ATOM   1024  O   ARG A 214      27.147  43.998  30.790  1.00 41.94           O  
ATOM   1025  CB  ARG A 214      27.277  41.550  29.702  1.00 41.31           C  
ATOM   1026  CG  ARG A 214      27.193  40.297  28.843  1.00 40.13           C  
ATOM   1027  CD  ARG A 214      28.565  39.871  28.333  1.00 37.47           C  
ATOM   1028  NE  ARG A 214      29.492  39.583  29.428  1.00 36.86           N  
ATOM   1029  CZ  ARG A 214      30.729  39.137  29.254  1.00 37.40           C  
ATOM   1030  NH1 ARG A 214      31.193  38.931  28.029  1.00 37.02           N  
ATOM   1031  NH2 ARG A 214      31.498  38.876  30.300  1.00 37.38           N  
ATOM   1032  N   PRO A 215      24.972  43.958  31.380  1.00 40.65           N  
ATOM   1033  CA  PRO A 215      24.982  45.294  31.980  1.00 40.71           C  
ATOM   1034  C   PRO A 215      26.098  45.520  32.998  1.00 42.52           C  
ATOM   1035  O   PRO A 215      26.458  44.621  33.763  1.00 41.69           O  
ATOM   1036  CB  PRO A 215      23.588  45.414  32.590  1.00 37.45           C  
ATOM   1037  CG  PRO A 215      23.226  44.005  32.887  1.00 39.05           C  
ATOM   1038  CD  PRO A 215      23.699  43.275  31.657  1.00 38.45           C  
ATOM   1039  N   PHE A 216      26.635  46.739  32.986  1.00 44.77           N  
ATOM   1040  CA  PHE A 216      27.722  47.151  33.867  1.00 46.84           C  
ATOM   1041  C   PHE A 216      27.201  47.558  35.248  1.00 48.35           C  
ATOM   1042  O   PHE A 216      26.009  47.794  35.435  1.00 49.78           O  
ATOM   1043  CB  PHE A 216      28.475  48.332  33.232  1.00 45.95           C  
ATOM   1044  CG  PHE A 216      29.829  48.598  33.834  1.00 44.35           C  
ATOM   1045  CD1 PHE A 216      30.887  47.716  33.622  1.00 44.23           C  
ATOM   1046  CD2 PHE A 216      30.049  49.730  34.608  1.00 42.35           C  
ATOM   1047  CE1 PHE A 216      32.146  47.960  34.173  1.00 42.82           C  
ATOM   1048  CE2 PHE A 216      31.305  49.984  35.163  1.00 41.86           C  
ATOM   1049  CZ  PHE A 216      32.354  49.099  34.944  1.00 42.17           C  
ATOM   1050  N   SER A 217      28.111  47.642  36.210  1.00 48.25           N  
ATOM   1051  CA  SER A 217      27.758  48.026  37.562  1.00 48.10           C  
ATOM   1052  C   SER A 217      28.887  48.854  38.153  1.00 47.79           C  
ATOM   1053  O   SER A 217      30.052  48.627  37.854  1.00 46.82           O  
ATOM   1054  CB  SER A 217      27.520  46.784  38.420  1.00 48.84           C  
ATOM   1055  OG  SER A 217      27.226  47.150  39.757  1.00 50.96           O  
ATOM   1056  N   PRO A 218      28.555  49.833  39.000  1.00 48.14           N  
ATOM   1057  CA  PRO A 218      29.587  50.674  39.612  1.00 47.81           C  
ATOM   1058  C   PRO A 218      30.541  49.907  40.526  1.00 47.49           C  
ATOM   1059  O   PRO A 218      31.587  50.427  40.914  1.00 46.93           O  
ATOM   1060  CB  PRO A 218      28.771  51.728  40.355  1.00 47.52           C  
ATOM   1061  CG  PRO A 218      27.526  51.001  40.705  1.00 47.79           C  
ATOM   1062  CD  PRO A 218      27.215  50.253  39.440  1.00 47.98           C  
ATOM   1063  N   ASP A 219      30.187  48.671  40.868  1.00 47.58           N  
ATOM   1064  CA  ASP A 219      31.054  47.875  41.729  1.00 48.45           C  
ATOM   1065  C   ASP A 219      32.174  47.230  40.912  1.00 46.53           C  
ATOM   1066  O   ASP A 219      33.014  46.517  41.453  1.00 47.13           O  
ATOM   1067  CB  ASP A 219      30.257  46.796  42.462  1.00 52.23           C  
ATOM   1068  CG  ASP A 219      29.866  45.645  41.559  1.00 57.45           C  
ATOM   1069  OD1 ASP A 219      29.113  45.883  40.589  1.00 59.98           O  
ATOM   1070  OD2 ASP A 219      30.314  44.502  41.818  1.00 60.12           O  
ATOM   1071  N   ARG A 220      32.172  47.476  39.606  1.00 43.80           N  
ATOM   1072  CA  ARG A 220      33.206  46.945  38.720  1.00 41.50           C  
ATOM   1073  C   ARG A 220      33.914  48.110  38.047  1.00 40.44           C  
ATOM   1074  O   ARG A 220      34.635  47.945  37.070  1.00 39.92           O  
ATOM   1075  CB  ARG A 220      32.602  46.000  37.673  1.00 40.03           C  
ATOM   1076  CG  ARG A 220      32.390  44.599  38.209  1.00 39.23           C  
ATOM   1077  CD  ARG A 220      31.729  43.689  37.206  1.00 38.44           C  
ATOM   1078  NE  ARG A 220      30.349  44.083  36.971  1.00 38.45           N  
ATOM   1079  CZ  ARG A 220      29.823  44.246  35.762  1.00 40.40           C  
ATOM   1080  NH1 ARG A 220      30.568  44.038  34.679  1.00 39.88           N  
ATOM   1081  NH2 ARG A 220      28.563  44.641  35.640  1.00 38.68           N  
ATOM   1082  N   LEU A 221      33.693  49.292  38.607  1.00 39.87           N  
ATOM   1083  CA  LEU A 221      34.294  50.525  38.121  1.00 40.73           C  
ATOM   1084  C   LEU A 221      35.404  50.977  39.059  1.00 42.12           C  
ATOM   1085  O   LEU A 221      35.372  50.697  40.257  1.00 43.65           O  
ATOM   1086  CB  LEU A 221      33.246  51.631  38.061  1.00 39.64           C  
ATOM   1087  CG  LEU A 221      33.760  53.012  37.672  1.00 36.51           C  
ATOM   1088  CD1 LEU A 221      34.095  53.030  36.190  1.00 37.10           C  
ATOM   1089  CD2 LEU A 221      32.714  54.044  37.981  1.00 34.68           C  
ATOM   1090  N   TYR A 222      36.390  51.674  38.507  1.00 42.25           N  
ATOM   1091  CA  TYR A 222      37.477  52.190  39.319  1.00 40.73           C  
ATOM   1092  C   TYR A 222      37.790  53.580  38.825  1.00 41.02           C  
ATOM   1093  O   TYR A 222      37.942  53.803  37.628  1.00 40.96           O  
ATOM   1094  CB  TYR A 222      38.728  51.327  39.206  1.00 40.35           C  
ATOM   1095  CG  TYR A 222      39.765  51.649  40.264  1.00 40.59           C  
ATOM   1096  CD1 TYR A 222      39.643  51.161  41.560  1.00 38.91           C  
ATOM   1097  CD2 TYR A 222      40.871  52.441  39.965  1.00 41.32           C  
ATOM   1098  CE1 TYR A 222      40.590  51.443  42.523  1.00 38.11           C  
ATOM   1099  CE2 TYR A 222      41.825  52.731  40.927  1.00 40.69           C  
ATOM   1100  CZ  TYR A 222      41.679  52.228  42.204  1.00 40.02           C  
ATOM   1101  OH  TYR A 222      42.634  52.509  43.162  1.00 40.91           O  
ATOM   1102  N   ILE A 223      37.877  54.518  39.757  1.00 41.63           N  
ATOM   1103  CA  ILE A 223      38.176  55.894  39.413  1.00 41.80           C  
ATOM   1104  C   ILE A 223      39.601  56.214  39.857  1.00 41.65           C  
ATOM   1105  O   ILE A 223      40.007  55.872  40.972  1.00 42.14           O  
ATOM   1106  CB  ILE A 223      37.179  56.852  40.104  1.00 42.02           C  
ATOM   1107  CG1 ILE A 223      35.743  56.390  39.819  1.00 41.06           C  
ATOM   1108  CG2 ILE A 223      37.385  58.274  39.598  1.00 40.67           C  
ATOM   1109  CD1 ILE A 223      34.681  57.137  40.592  1.00 37.96           C  
ATOM   1110  N   THR A 224      40.360  56.865  38.982  1.00 41.48           N  
ATOM   1111  CA  THR A 224      41.737  57.220  39.298  1.00 40.76           C  
ATOM   1112  C   THR A 224      42.274  58.319  38.376  1.00 39.83           C  
ATOM   1113  O   THR A 224      41.515  58.943  37.644  1.00 37.93           O  
ATOM   1114  CB  THR A 224      42.652  55.959  39.239  1.00 40.88           C  
ATOM   1115  OG1 THR A 224      43.985  56.317  39.613  1.00 41.40           O  
ATOM   1116  CG2 THR A 224      42.656  55.345  37.848  1.00 39.93           C  
ATOM   1117  N   ARG A 225      43.581  58.559  38.424  1.00 40.39           N  
ATOM   1118  CA  ARG A 225      44.201  59.596  37.602  1.00 40.90           C  
ATOM   1119  C   ARG A 225      44.699  59.018  36.285  1.00 39.95           C  
ATOM   1120  O   ARG A 225      44.821  57.803  36.132  1.00 37.22           O  
ATOM   1121  CB  ARG A 225      45.379  60.237  38.336  1.00 43.95           C  
ATOM   1122  CG  ARG A 225      45.164  60.515  39.822  1.00 49.20           C  
ATOM   1123  CD  ARG A 225      44.371  61.775  40.085  1.00 53.60           C  
ATOM   1124  NE  ARG A 225      44.907  62.929  39.369  1.00 61.26           N  
ATOM   1125  CZ  ARG A 225      46.176  63.334  39.409  1.00 64.13           C  
ATOM   1126  NH1 ARG A 225      47.067  62.675  40.138  1.00 65.81           N  
ATOM   1127  NH2 ARG A 225      46.556  64.405  38.716  1.00 63.96           N  
ATOM   1128  N   HIS A 226      44.992  59.909  35.341  1.00 39.49           N  
ATOM   1129  CA  HIS A 226      45.472  59.516  34.024  1.00 39.61           C  
ATOM   1130  C   HIS A 226      46.960  59.181  34.073  1.00 39.98           C  
ATOM   1131  O   HIS A 226      47.804  59.975  33.683  1.00 40.84           O  
ATOM   1132  CB  HIS A 226      45.183  60.644  33.023  1.00 37.68           C  
ATOM   1133  CG  HIS A 226      45.661  60.366  31.628  1.00 39.99           C  
ATOM   1134  ND1 HIS A 226      46.818  60.909  31.115  1.00 40.31           N  
ATOM   1135  CD2 HIS A 226      45.129  59.607  30.639  1.00 40.89           C  
ATOM   1136  CE1 HIS A 226      46.982  60.498  29.868  1.00 40.01           C  
ATOM   1137  NE2 HIS A 226      45.972  59.709  29.556  1.00 40.81           N  
ATOM   1138  N   SER A 227      47.271  57.983  34.560  1.00 41.07           N  
ATOM   1139  CA  SER A 227      48.654  57.520  34.671  1.00 40.61           C  
ATOM   1140  C   SER A 227      48.717  56.005  34.635  1.00 40.19           C  
ATOM   1141  O   SER A 227      47.698  55.316  34.734  1.00 39.85           O  
ATOM   1142  CB  SER A 227      49.285  57.988  35.987  1.00 41.74           C  
ATOM   1143  OG  SER A 227      48.702  57.331  37.104  1.00 42.10           O  
ATOM   1144  N   GLN A 228      49.934  55.492  34.506  1.00 39.37           N  
ATOM   1145  CA  GLN A 228      50.143  54.062  34.473  1.00 38.39           C  
ATOM   1146  C   GLN A 228      49.966  53.519  35.879  1.00 37.73           C  
ATOM   1147  O   GLN A 228      49.537  52.381  36.071  1.00 36.48           O  
ATOM   1148  CB  GLN A 228      51.544  53.746  33.979  1.00 39.20           C  
ATOM   1149  CG  GLN A 228      51.927  54.449  32.703  1.00 41.24           C  
ATOM   1150  CD  GLN A 228      53.112  53.791  32.032  1.00 43.29           C  
ATOM   1151  OE1 GLN A 228      53.754  54.385  31.170  1.00 43.78           O  
ATOM   1152  NE2 GLN A 228      53.402  52.545  32.418  1.00 43.58           N  
ATOM   1153  N   GLU A 229      50.303  54.343  36.866  1.00 37.96           N  
ATOM   1154  CA  GLU A 229      50.172  53.945  38.258  1.00 38.21           C  
ATOM   1155  C   GLU A 229      48.700  53.721  38.586  1.00 38.86           C  
ATOM   1156  O   GLU A 229      48.364  52.790  39.317  1.00 39.81           O  
ATOM   1157  CB  GLU A 229      50.762  55.012  39.185  1.00 39.75           C  
ATOM   1158  CG  GLU A 229      52.270  55.180  39.070  1.00 42.46           C  
ATOM   1159  CD  GLU A 229      52.691  55.922  37.815  1.00 45.22           C  
ATOM   1160  OE1 GLU A 229      52.186  57.046  37.590  1.00 46.56           O  
ATOM   1161  OE2 GLU A 229      53.534  55.389  37.062  1.00 45.94           O  
ATOM   1162  N   GLY A 230      47.830  54.580  38.052  1.00 36.69           N  
ATOM   1163  CA  GLY A 230      46.406  54.428  38.285  1.00 33.93           C  
ATOM   1164  C   GLY A 230      45.917  53.097  37.731  1.00 34.26           C  
ATOM   1165  O   GLY A 230      45.135  52.391  38.370  1.00 31.53           O  
ATOM   1166  N   GLY A 231      46.385  52.752  36.534  1.00 34.96           N  
ATOM   1167  CA  GLY A 231      45.998  51.494  35.919  1.00 36.28           C  
ATOM   1168  C   GLY A 231      46.461  50.302  36.735  1.00 37.44           C  
ATOM   1169  O   GLY A 231      45.754  49.305  36.859  1.00 37.62           O  
ATOM   1170  N   ARG A 232      47.663  50.398  37.292  1.00 38.21           N  
ATOM   1171  CA  ARG A 232      48.195  49.317  38.110  1.00 37.18           C  
ATOM   1172  C   ARG A 232      47.369  49.208  39.388  1.00 34.77           C  
ATOM   1173  O   ARG A 232      46.997  48.109  39.795  1.00 35.16           O  
ATOM   1174  CB  ARG A 232      49.668  49.569  38.448  1.00 39.23           C  
ATOM   1175  CG  ARG A 232      50.601  49.537  37.242  1.00 44.73           C  
ATOM   1176  CD  ARG A 232      52.025  49.893  37.642  1.00 47.94           C  
ATOM   1177  NE  ARG A 232      52.493  49.010  38.700  1.00 53.29           N  
ATOM   1178  CZ  ARG A 232      53.433  49.324  39.583  1.00 55.13           C  
ATOM   1179  NH1 ARG A 232      54.020  50.511  39.533  1.00 56.29           N  
ATOM   1180  NH2 ARG A 232      53.770  48.453  40.532  1.00 56.69           N  
ATOM   1181  N   LEU A 233      47.083  50.344  40.018  1.00 31.16           N  
ATOM   1182  CA  LEU A 233      46.287  50.342  41.236  1.00 29.86           C  
ATOM   1183  C   LEU A 233      44.933  49.677  40.936  1.00 31.87           C  
ATOM   1184  O   LEU A 233      44.423  48.886  41.738  1.00 30.79           O  
ATOM   1185  CB  LEU A 233      46.049  51.772  41.717  1.00 28.24           C  
ATOM   1186  CG  LEU A 233      46.653  52.406  42.983  1.00 26.86           C  
ATOM   1187  CD1 LEU A 233      47.529  51.445  43.748  1.00 23.01           C  
ATOM   1188  CD2 LEU A 233      47.435  53.653  42.563  1.00 27.06           C  
ATOM   1189  N   ALA A 234      44.366  49.991  39.772  1.00 32.21           N  
ATOM   1190  CA  ALA A 234      43.070  49.451  39.360  1.00 32.07           C  
ATOM   1191  C   ALA A 234      43.039  47.940  39.127  1.00 32.66           C  
ATOM   1192  O   ALA A 234      42.173  47.252  39.648  1.00 32.27           O  
ATOM   1193  CB  ALA A 234      42.577  50.182  38.116  1.00 31.75           C  
ATOM   1194  N   LEU A 235      43.968  47.415  38.342  1.00 34.44           N  
ATOM   1195  CA  LEU A 235      43.989  45.977  38.104  1.00 38.03           C  
ATOM   1196  C   LEU A 235      44.088  45.253  39.452  1.00 40.61           C  
ATOM   1197  O   LEU A 235      43.463  44.215  39.670  1.00 39.99           O  
ATOM   1198  CB  LEU A 235      45.178  45.595  37.222  1.00 37.69           C  
ATOM   1199  CG  LEU A 235      45.359  44.091  36.983  1.00 38.67           C  
ATOM   1200  CD1 LEU A 235      44.138  43.544  36.259  1.00 36.66           C  
ATOM   1201  CD2 LEU A 235      46.623  43.832  36.179  1.00 38.14           C  
ATOM   1202  N   ARG A 236      44.883  45.815  40.353  1.00 44.09           N  
ATOM   1203  CA  ARG A 236      45.069  45.247  41.678  1.00 47.57           C  
ATOM   1204  C   ARG A 236      43.720  45.237  42.399  1.00 46.30           C  
ATOM   1205  O   ARG A 236      43.398  44.301  43.140  1.00 43.99           O  
ATOM   1206  CB  ARG A 236      46.085  46.090  42.453  1.00 52.25           C  
ATOM   1207  CG  ARG A 236      47.323  45.345  42.896  1.00 61.62           C  
ATOM   1208  CD  ARG A 236      47.013  44.395  44.045  1.00 71.78           C  
ATOM   1209  NE  ARG A 236      48.233  43.837  44.634  1.00 80.32           N  
ATOM   1210  CZ  ARG A 236      48.253  42.992  45.663  1.00 83.70           C  
ATOM   1211  NH1 ARG A 236      47.116  42.596  46.230  1.00 85.94           N  
ATOM   1212  NH2 ARG A 236      49.413  42.546  46.129  1.00 84.20           N  
ATOM   1213  N   HIS A 237      42.937  46.290  42.167  1.00 45.00           N  
ATOM   1214  CA  HIS A 237      41.617  46.434  42.766  1.00 44.53           C  
ATOM   1215  C   HIS A 237      40.659  45.383  42.209  1.00 43.75           C  
ATOM   1216  O   HIS A 237      39.959  44.700  42.962  1.00 43.95           O  
ATOM   1217  CB  HIS A 237      41.058  47.826  42.475  1.00 45.69           C  
ATOM   1218  CG  HIS A 237      39.685  48.041  43.018  1.00 47.89           C  
ATOM   1219  ND1 HIS A 237      39.431  48.181  44.365  1.00 50.23           N  
ATOM   1220  CD2 HIS A 237      38.481  48.096  42.401  1.00 49.83           C  
ATOM   1221  CE1 HIS A 237      38.131  48.312  44.554  1.00 50.36           C  
ATOM   1222  NE2 HIS A 237      37.532  48.264  43.379  1.00 51.34           N  
ATOM   1223  N   PHE A 238      40.633  45.258  40.885  1.00 40.23           N  
ATOM   1224  CA  PHE A 238      39.771  44.294  40.227  1.00 37.84           C  
ATOM   1225  C   PHE A 238      40.118  42.849  40.597  1.00 38.89           C  
ATOM   1226  O   PHE A 238      39.237  41.996  40.705  1.00 38.89           O  
ATOM   1227  CB  PHE A 238      39.874  44.435  38.713  1.00 36.16           C  
ATOM   1228  CG  PHE A 238      39.633  45.829  38.201  1.00 36.47           C  
ATOM   1229  CD1 PHE A 238      38.610  46.617  38.717  1.00 35.41           C  
ATOM   1230  CD2 PHE A 238      40.369  46.315  37.119  1.00 35.63           C  
ATOM   1231  CE1 PHE A 238      38.316  47.860  38.157  1.00 34.24           C  
ATOM   1232  CE2 PHE A 238      40.083  47.553  36.555  1.00 34.02           C  
ATOM   1233  CZ  PHE A 238      39.054  48.325  37.071  1.00 34.07           C  
ATOM   1234  N   LEU A 239      41.403  42.571  40.786  1.00 39.37           N  
ATOM   1235  CA  LEU A 239      41.839  41.223  41.111  1.00 40.19           C  
ATOM   1236  C   LEU A 239      41.338  40.698  42.442  1.00 41.42           C  
ATOM   1237  O   LEU A 239      41.317  39.487  42.651  1.00 41.97           O  
ATOM   1238  CB  LEU A 239      43.360  41.125  41.055  1.00 40.60           C  
ATOM   1239  CG  LEU A 239      43.919  41.202  39.629  1.00 43.90           C  
ATOM   1240  CD1 LEU A 239      45.431  41.302  39.675  1.00 43.12           C  
ATOM   1241  CD2 LEU A 239      43.474  39.982  38.823  1.00 43.14           C  
ATOM   1242  N   GLU A 240      40.940  41.582  43.354  1.00 42.41           N  
ATOM   1243  CA  GLU A 240      40.427  41.094  44.625  1.00 43.91           C  
ATOM   1244  C   GLU A 240      38.918  40.868  44.523  1.00 43.64           C  
ATOM   1245  O   GLU A 240      38.288  40.316  45.429  1.00 42.35           O  
ATOM   1246  CB  GLU A 240      40.798  42.036  45.785  1.00 44.72           C  
ATOM   1247  CG  GLU A 240      40.849  43.514  45.470  1.00 48.82           C  
ATOM   1248  CD  GLU A 240      41.449  44.343  46.617  1.00 51.48           C  
ATOM   1249  OE1 GLU A 240      42.585  44.039  47.051  1.00 48.57           O  
ATOM   1250  OE2 GLU A 240      40.785  45.305  47.078  1.00 53.11           O  
ATOM   1251  N   LYS A 241      38.360  41.268  43.385  1.00 43.33           N  
ATOM   1252  CA  LYS A 241      36.936  41.100  43.105  1.00 42.91           C  
ATOM   1253  C   LYS A 241      36.707  39.918  42.152  1.00 42.33           C  
ATOM   1254  O   LYS A 241      35.611  39.361  42.092  1.00 41.55           O  
ATOM   1255  CB  LYS A 241      36.354  42.371  42.469  1.00 42.88           C  
ATOM   1256  CG  LYS A 241      36.115  43.525  43.426  1.00 45.01           C  
ATOM   1257  CD  LYS A 241      35.479  44.709  42.693  1.00 47.84           C  
ATOM   1258  CE  LYS A 241      35.308  45.949  43.586  1.00 49.86           C  
ATOM   1259  NZ  LYS A 241      34.193  45.855  44.578  1.00 51.93           N  
ATOM   1260  N   ALA A 242      37.745  39.542  41.410  1.00 41.34           N  
ATOM   1261  CA  ALA A 242      37.627  38.448  40.459  1.00 40.72           C  
ATOM   1262  C   ALA A 242      38.966  37.852  40.049  1.00 41.02           C  
ATOM   1263  O   ALA A 242      40.002  38.510  40.076  1.00 40.68           O  
ATOM   1264  CB  ALA A 242      36.879  38.928  39.217  1.00 39.45           C  
ATOM   1265  N   SER A 243      38.930  36.589  39.662  1.00 42.19           N  
ATOM   1266  CA  SER A 243      40.131  35.903  39.232  1.00 42.69           C  
ATOM   1267  C   SER A 243      40.139  35.900  37.713  1.00 43.67           C  
ATOM   1268  O   SER A 243      39.112  36.146  37.076  1.00 42.92           O  
ATOM   1269  CB  SER A 243      40.137  34.459  39.743  1.00 41.93           C  
ATOM   1270  OG  SER A 243      39.219  33.655  39.024  1.00 40.15           O  
ATOM   1271  N   PRO A 244      41.307  35.646  37.112  1.00 44.21           N  
ATOM   1272  CA  PRO A 244      41.381  35.620  35.654  1.00 44.39           C  
ATOM   1273  C   PRO A 244      40.478  34.494  35.168  1.00 45.44           C  
ATOM   1274  O   PRO A 244      40.262  33.514  35.884  1.00 47.19           O  
ATOM   1275  CB  PRO A 244      42.856  35.331  35.396  1.00 44.46           C  
ATOM   1276  CG  PRO A 244      43.531  35.961  36.575  1.00 44.93           C  
ATOM   1277  CD  PRO A 244      42.646  35.520  37.709  1.00 43.32           C  
ATOM   1278  N   PRO A 245      39.919  34.624  33.958  1.00 44.72           N  
ATOM   1279  CA  PRO A 245      40.098  35.759  33.055  1.00 43.87           C  
ATOM   1280  C   PRO A 245      39.158  36.904  33.400  1.00 43.88           C  
ATOM   1281  O   PRO A 245      38.064  36.691  33.929  1.00 43.78           O  
ATOM   1282  CB  PRO A 245      39.761  35.165  31.702  1.00 43.06           C  
ATOM   1283  CG  PRO A 245      38.614  34.279  32.050  1.00 44.22           C  
ATOM   1284  CD  PRO A 245      39.098  33.581  33.318  1.00 43.56           C  
ATOM   1285  N   LEU A 246      39.598  38.119  33.105  1.00 43.30           N  
ATOM   1286  CA  LEU A 246      38.776  39.285  33.336  1.00 43.57           C  
ATOM   1287  C   LEU A 246      39.116  40.348  32.297  1.00 42.52           C  
ATOM   1288  O   LEU A 246      40.232  40.406  31.770  1.00 39.21           O  
ATOM   1289  CB  LEU A 246      38.949  39.829  34.760  1.00 45.28           C  
ATOM   1290  CG  LEU A 246      40.288  40.401  35.206  1.00 46.01           C  
ATOM   1291  CD1 LEU A 246      40.102  41.169  36.492  1.00 47.58           C  
ATOM   1292  CD2 LEU A 246      41.274  39.272  35.394  1.00 49.97           C  
ATOM   1293  N   ASN A 247      38.128  41.179  32.000  1.00 41.95           N  
ATOM   1294  CA  ASN A 247      38.271  42.215  31.004  1.00 41.21           C  
ATOM   1295  C   ASN A 247      38.306  43.581  31.631  1.00 39.62           C  
ATOM   1296  O   ASN A 247      37.556  43.864  32.563  1.00 39.17           O  
ATOM   1297  CB  ASN A 247      37.114  42.113  30.026  1.00 43.16           C  
ATOM   1298  CG  ASN A 247      36.956  40.715  29.489  1.00 43.53           C  
ATOM   1299  OD1 ASN A 247      37.818  40.223  28.762  1.00 44.18           O  
ATOM   1300  ND2 ASN A 247      35.864  40.055  29.861  1.00 43.38           N  
ATOM   1301  N   VAL A 248      39.185  44.424  31.097  1.00 38.02           N  
ATOM   1302  CA  VAL A 248      39.359  45.778  31.588  1.00 36.96           C  
ATOM   1303  C   VAL A 248      39.300  46.824  30.476  1.00 36.81           C  
ATOM   1304  O   VAL A 248      39.950  46.688  29.440  1.00 36.34           O  
ATOM   1305  CB  VAL A 248      40.724  45.938  32.312  1.00 36.46           C  
ATOM   1306  CG1 VAL A 248      40.893  47.381  32.794  1.00 35.25           C  
ATOM   1307  CG2 VAL A 248      40.829  44.959  33.477  1.00 35.41           C  
ATOM   1308  N   PHE A 249      38.498  47.859  30.698  1.00 35.97           N  
ATOM   1309  CA  PHE A 249      38.402  48.962  29.761  1.00 35.68           C  
ATOM   1310  C   PHE A 249      39.148  50.091  30.464  1.00 36.04           C  
ATOM   1311  O   PHE A 249      38.594  50.764  31.329  1.00 35.40           O  
ATOM   1312  CB  PHE A 249      36.944  49.369  29.513  1.00 35.56           C  
ATOM   1313  CG  PHE A 249      36.798  50.558  28.597  1.00 34.71           C  
ATOM   1314  CD1 PHE A 249      37.721  50.785  27.572  1.00 36.14           C  
ATOM   1315  CD2 PHE A 249      35.741  51.438  28.742  1.00 34.74           C  
ATOM   1316  CE1 PHE A 249      37.597  51.870  26.707  1.00 34.41           C  
ATOM   1317  CE2 PHE A 249      35.599  52.534  27.881  1.00 36.72           C  
ATOM   1318  CZ  PHE A 249      36.533  52.748  26.862  1.00 36.83           C  
ATOM   1319  N   ALA A 250      40.414  50.278  30.095  1.00 36.29           N  
ATOM   1320  CA  ALA A 250      41.262  51.303  30.699  1.00 35.80           C  
ATOM   1321  C   ALA A 250      40.692  52.697  30.588  1.00 35.77           C  
ATOM   1322  O   ALA A 250      40.756  53.466  31.542  1.00 37.73           O  
ATOM   1323  CB  ALA A 250      42.643  51.273  30.085  1.00 36.44           C  
ATOM   1324  N   GLY A 251      40.137  53.032  29.431  1.00 35.46           N  
ATOM   1325  CA  GLY A 251      39.580  54.362  29.265  1.00 35.58           C  
ATOM   1326  C   GLY A 251      40.575  55.324  28.654  1.00 34.87           C  
ATOM   1327  O   GLY A 251      40.184  56.332  28.079  1.00 36.37           O  
ATOM   1328  N   ALA A 252      41.861  55.015  28.801  1.00 35.44           N  
ATOM   1329  CA  ALA A 252      42.955  55.816  28.248  1.00 34.70           C  
ATOM   1330  C   ALA A 252      44.151  54.883  28.051  1.00 35.58           C  
ATOM   1331  O   ALA A 252      44.384  53.978  28.860  1.00 35.24           O  
ATOM   1332  CB  ALA A 252      43.320  56.941  29.190  1.00 33.02           C  
ATOM   1333  N   ASP A 253      44.910  55.087  26.980  1.00 35.36           N  
ATOM   1334  CA  ASP A 253      46.045  54.215  26.724  1.00 36.55           C  
ATOM   1335  C   ASP A 253      47.110  54.253  27.819  1.00 37.54           C  
ATOM   1336  O   ASP A 253      47.692  53.225  28.161  1.00 37.51           O  
ATOM   1337  CB  ASP A 253      46.666  54.537  25.365  1.00 37.84           C  
ATOM   1338  CG  ASP A 253      45.754  54.165  24.205  1.00 40.02           C  
ATOM   1339  OD1 ASP A 253      44.875  53.293  24.391  1.00 39.01           O  
ATOM   1340  OD2 ASP A 253      45.924  54.732  23.104  1.00 39.51           O  
ATOM   1341  N   GLN A 254      47.357  55.433  28.376  1.00 39.02           N  
ATOM   1342  CA  GLN A 254      48.357  55.588  29.431  1.00 39.82           C  
ATOM   1343  C   GLN A 254      48.043  54.663  30.622  1.00 38.88           C  
ATOM   1344  O   GLN A 254      48.914  53.972  31.149  1.00 37.63           O  
ATOM   1345  CB  GLN A 254      48.391  57.058  29.873  1.00 41.04           C  
ATOM   1346  CG  GLN A 254      49.624  57.465  30.656  1.00 44.93           C  
ATOM   1347  CD  GLN A 254      50.910  57.081  29.960  1.00 47.15           C  
ATOM   1348  OE1 GLN A 254      51.650  56.222  30.432  1.00 49.24           O  
ATOM   1349  NE2 GLN A 254      51.184  57.713  28.830  1.00 49.85           N  
ATOM   1350  N   VAL A 255      46.778  54.658  31.026  1.00 38.27           N  
ATOM   1351  CA  VAL A 255      46.301  53.834  32.132  1.00 36.76           C  
ATOM   1352  C   VAL A 255      46.380  52.357  31.733  1.00 36.59           C  
ATOM   1353  O   VAL A 255      46.768  51.503  32.536  1.00 36.94           O  
ATOM   1354  CB  VAL A 255      44.843  54.226  32.474  1.00 36.57           C  
ATOM   1355  CG1 VAL A 255      44.338  53.442  33.667  1.00 35.44           C  
ATOM   1356  CG2 VAL A 255      44.771  55.732  32.738  1.00 34.41           C  
ATOM   1357  N   ALA A 256      46.023  52.078  30.478  1.00 34.76           N  
ATOM   1358  CA  ALA A 256      46.059  50.728  29.923  1.00 34.57           C  
ATOM   1359  C   ALA A 256      47.475  50.144  29.957  1.00 35.58           C  
ATOM   1360  O   ALA A 256      47.655  48.929  30.061  1.00 35.88           O  
ATOM   1361  CB  ALA A 256      45.543  50.745  28.493  1.00 33.01           C  
ATOM   1362  N   LEU A 257      48.479  51.007  29.851  1.00 36.23           N  
ATOM   1363  CA  LEU A 257      49.853  50.551  29.904  1.00 36.04           C  
ATOM   1364  C   LEU A 257      50.129  50.019  31.301  1.00 36.22           C  
ATOM   1365  O   LEU A 257      50.862  49.043  31.471  1.00 36.66           O  
ATOM   1366  CB  LEU A 257      50.824  51.693  29.578  1.00 37.78           C  
ATOM   1367  CG  LEU A 257      51.090  51.999  28.098  1.00 38.11           C  
ATOM   1368  CD1 LEU A 257      52.271  52.950  27.971  1.00 36.80           C  
ATOM   1369  CD2 LEU A 257      51.382  50.704  27.351  0.00 37.54           C  
ATOM   1370  N   GLY A 258      49.539  50.662  32.301  1.00 35.52           N  
ATOM   1371  CA  GLY A 258      49.734  50.217  33.668  1.00 37.37           C  
ATOM   1372  C   GLY A 258      49.077  48.876  33.941  1.00 37.12           C  
ATOM   1373  O   GLY A 258      49.667  48.001  34.575  0.00 37.66           O  
ATOM   1374  N   VAL A 259      47.845  48.719  33.459  1.00 39.27           N  
ATOM   1375  CA  VAL A 259      47.097  47.478  33.649  1.00 40.60           C  
ATOM   1376  C   VAL A 259      47.894  46.369  33.000  1.00 41.39           C  
ATOM   1377  O   VAL A 259      48.009  45.260  33.532  1.00 41.22           O  
ATOM   1378  CB  VAL A 259      45.712  47.518  32.971  1.00 39.62           C  
ATOM   1379  CG1 VAL A 259      44.954  46.248  33.292  1.00 37.64           C  
ATOM   1380  CG2 VAL A 259      44.933  48.740  33.426  1.00 39.00           C  
ATOM   1381  N   LEU A 260      48.441  46.697  31.838  1.00 41.54           N  
ATOM   1382  CA  LEU A 260      49.252  45.776  31.064  1.00 43.62           C  
ATOM   1383  C   LEU A 260      50.523  45.421  31.837  1.00 44.85           C  
ATOM   1384  O   LEU A 260      50.861  44.255  31.992  1.00 44.38           O  
ATOM   1385  CB  LEU A 260      49.615  46.438  29.741  1.00 43.70           C  
ATOM   1386  CG  LEU A 260      49.471  45.592  28.487  1.00 44.50           C  
ATOM   1387  CD1 LEU A 260      48.111  44.929  28.462  1.00 43.89           C  
ATOM   1388  CD2 LEU A 260      49.651  46.481  27.270  1.00 45.58           C  
ATOM   1389  N   GLU A 261      51.211  46.449  32.325  1.00 47.84           N  
ATOM   1390  CA  GLU A 261      52.450  46.303  33.088  1.00 49.54           C  
ATOM   1391  C   GLU A 261      52.276  45.497  34.367  1.00 48.57           C  
ATOM   1392  O   GLU A 261      53.043  44.568  34.628  1.00 48.57           O  
ATOM   1393  CB  GLU A 261      53.001  47.687  33.450  1.00 53.72           C  
ATOM   1394  CG  GLU A 261      54.289  47.653  34.255  1.00 58.99           C  
ATOM   1395  CD  GLU A 261      54.520  48.929  35.040  1.00 62.09           C  
ATOM   1396  OE1 GLU A 261      54.679  50.002  34.417  1.00 64.32           O  
ATOM   1397  OE2 GLU A 261      54.535  48.854  36.287  1.00 64.11           O  
ATOM   1398  N   GLU A 262      51.280  45.866  35.172  1.00 47.70           N  
ATOM   1399  CA  GLU A 262      51.014  45.171  36.428  1.00 46.64           C  
ATOM   1400  C   GLU A 262      50.554  43.739  36.185  1.00 44.22           C  
ATOM   1401  O   GLU A 262      50.792  42.854  37.002  1.00 43.59           O  
ATOM   1402  CB  GLU A 262      49.947  45.905  37.243  1.00 49.62           C  
ATOM   1403  CG  GLU A 262      49.746  45.340  38.653  1.00 52.25           C  
ATOM   1404  CD  GLU A 262      50.920  45.630  39.593  1.00 54.80           C  
ATOM   1405  OE1 GLU A 262      52.014  45.992  39.108  1.00 54.91           O  
ATOM   1406  OE2 GLU A 262      50.746  45.484  40.822  1.00 57.45           O  
ATOM   1407  N   ALA A 263      49.876  43.508  35.075  1.00 42.49           N  
ATOM   1408  CA  ALA A 263      49.438  42.160  34.787  1.00 42.64           C  
ATOM   1409  C   ALA A 263      50.692  41.316  34.613  1.00 43.47           C  
ATOM   1410  O   ALA A 263      50.873  40.319  35.308  1.00 44.05           O  
ATOM   1411  CB  ALA A 263      48.594  42.131  33.519  1.00 42.30           C  
ATOM   1412  N   VAL A 264      51.561  41.735  33.691  1.00 44.53           N  
ATOM   1413  CA  VAL A 264      52.806  41.029  33.395  1.00 45.78           C  
ATOM   1414  C   VAL A 264      53.638  40.774  34.647  1.00 48.53           C  
ATOM   1415  O   VAL A 264      54.206  39.693  34.823  1.00 48.38           O  
ATOM   1416  CB  VAL A 264      53.656  41.820  32.393  1.00 43.89           C  
ATOM   1417  CG1 VAL A 264      54.975  41.109  32.151  1.00 41.16           C  
ATOM   1418  CG2 VAL A 264      52.894  41.983  31.099  1.00 41.31           C  
ATOM   1419  N   ARG A 265      53.707  41.778  35.510  1.00 50.08           N  
ATOM   1420  CA  ARG A 265      54.439  41.667  36.759  1.00 52.29           C  
ATOM   1421  C   ARG A 265      53.868  40.478  37.539  1.00 54.04           C  
ATOM   1422  O   ARG A 265      54.296  40.191  38.658  1.00 54.27           O  
ATOM   1423  CB  ARG A 265      54.253  42.940  37.577  1.00 52.51           C  
ATOM   1424  CG  ARG A 265      55.479  43.394  38.319  1.00 53.21           C  
ATOM   1425  CD  ARG A 265      55.082  44.313  39.437  1.00 53.88           C  
ATOM   1426  NE  ARG A 265      54.528  43.536  40.536  1.00 56.69           N  
ATOM   1427  CZ  ARG A 265      53.831  44.053  41.537  1.00 57.33           C  
ATOM   1428  NH1 ARG A 265      53.600  45.359  41.573  1.00 59.32           N  
ATOM   1429  NH2 ARG A 265      53.375  43.266  42.500  1.00 57.90           N  
ATOM   1430  N   LEU A 266      52.883  39.805  36.947  1.00 55.09           N  
ATOM   1431  CA  LEU A 266      52.236  38.649  37.558  1.00 56.39           C  
ATOM   1432  C   LEU A 266      51.964  37.543  36.525  1.00 59.02           C  
ATOM   1433  O   LEU A 266      52.718  36.578  36.429  1.00 58.31           O  
ATOM   1434  CB  LEU A 266      50.917  39.069  38.209  1.00 54.55           C  
ATOM   1435  CG  LEU A 266      50.881  39.955  39.458  1.00 53.10           C  
ATOM   1436  CD1 LEU A 266      51.646  41.220  39.230  1.00 55.36           C  
ATOM   1437  CD2 LEU A 266      49.446  40.298  39.795  1.00 51.77           C  
ATOM   1438  N   GLY A 267      50.895  37.685  35.743  1.00 62.02           N  
ATOM   1439  CA  GLY A 267      50.575  36.654  34.768  1.00 64.03           C  
ATOM   1440  C   GLY A 267      50.119  37.119  33.397  1.00 66.51           C  
ATOM   1441  O   GLY A 267      49.822  38.288  33.200  1.00 65.71           O  
ATOM   1442  N   LEU A 268      50.054  36.170  32.462  1.00 70.48           N  
ATOM   1443  CA  LEU A 268      49.673  36.395  31.063  1.00 72.74           C  
ATOM   1444  C   LEU A 268      48.821  37.619  30.822  1.00 74.46           C  
ATOM   1445  O   LEU A 268      48.009  37.992  31.654  1.00 76.70           O  
ATOM   1446  CB  LEU A 268      48.947  35.175  30.510  1.00 72.56           C  
ATOM   1447  CG  LEU A 268      49.728  34.321  29.518  1.00 72.86           C  
ATOM   1448  CD1 LEU A 268      50.090  35.160  28.303  1.00 71.78           C  
ATOM   1449  CD2 LEU A 268      50.960  33.762  30.200  0.00 72.56           C  
ATOM   1450  N   THR A 269      48.989  38.220  29.654  1.00 75.01           N  
ATOM   1451  CA  THR A 269      48.277  39.431  29.305  1.00 75.67           C  
ATOM   1452  C   THR A 269      47.185  39.299  28.256  1.00 75.65           C  
ATOM   1453  O   THR A 269      46.188  40.020  28.293  1.00 76.57           O  
ATOM   1454  CB  THR A 269      49.277  40.470  28.819  1.00 75.73           C  
ATOM   1455  OG1 THR A 269      50.230  40.721  29.857  1.00 76.80           O  
ATOM   1456  CG2 THR A 269      48.572  41.758  28.435  1.00 75.92           C  
ATOM   1457  N   PRO A 270      47.361  38.393  27.297  1.00 75.17           N  
ATOM   1458  CA  PRO A 270      46.350  38.220  26.255  1.00 74.87           C  
ATOM   1459  C   PRO A 270      45.050  37.540  26.677  1.00 73.12           C  
ATOM   1460  O   PRO A 270      43.961  38.061  26.419  1.00 72.68           O  
ATOM   1461  CB  PRO A 270      47.098  37.424  25.184  1.00 77.80           C  
ATOM   1462  CG  PRO A 270      48.084  36.621  25.990  1.00 78.02           C  
ATOM   1463  CD  PRO A 270      48.590  37.658  26.964  1.00 76.77           C  
ATOM   1464  N   GLY A 271      45.153  36.379  27.311  1.00 72.23           N  
ATOM   1465  CA  GLY A 271      43.943  35.691  27.702  1.00 71.80           C  
ATOM   1466  C   GLY A 271      43.854  35.255  29.154  1.00 72.70           C  
ATOM   1467  O   GLY A 271      42.780  35.327  29.763  1.00 70.44           O  
ATOM   1468  N   ARG A 272      44.965  34.804  29.722  1.00 75.45           N  
ATOM   1469  CA  ARG A 272      44.950  34.330  31.097  1.00 77.66           C  
ATOM   1470  C   ARG A 272      44.398  35.386  32.018  1.00 77.80           C  
ATOM   1471  O   ARG A 272      43.213  35.389  32.334  1.00 80.18           O  
ATOM   1472  CB  ARG A 272      46.357  33.944  31.543  1.00 77.36           C  
ATOM   1473  CG  ARG A 272      46.402  32.843  32.574  1.00 79.15           C  
ATOM   1474  CD  ARG A 272      47.765  32.156  32.546  1.00 81.54           C  
ATOM   1475  NE  ARG A 272      48.309  32.012  31.191  1.00 82.09           N  
ATOM   1476  CZ  ARG A 272      47.660  31.479  30.158  1.00 81.91           C  
ATOM   1477  NH1 ARG A 272      46.420  31.027  30.296  1.00 81.54           N  
ATOM   1478  NH2 ARG A 272      48.260  31.392  28.977  1.00 81.32           N  
ATOM   1479  N   ASP A 273      45.265  36.275  32.475  1.00 77.04           N  
ATOM   1480  CA  ASP A 273      44.839  37.329  33.392  1.00 75.97           C  
ATOM   1481  C   ASP A 273      43.749  38.197  32.787  1.00 71.37           C  
ATOM   1482  O   ASP A 273      42.592  37.796  32.698  1.00 69.49           O  
ATOM   1483  CB  ASP A 273      46.027  38.228  33.788  1.00 81.84           C  
ATOM   1484  CG  ASP A 273      45.593  39.516  34.528  1.00 85.25           C  
ATOM   1485  OD1 ASP A 273      45.074  39.436  35.660  1.00 87.60           O  
ATOM   1486  OD2 ASP A 273      45.769  40.616  33.958  1.00 86.77           O  
ATOM   1487  N   VAL A 274      44.132  39.398  32.377  1.00 66.96           N  
ATOM   1488  CA  VAL A 274      43.185  40.337  31.833  1.00 63.42           C  
ATOM   1489  C   VAL A 274      43.395  40.644  30.375  1.00 59.95           C  
ATOM   1490  O   VAL A 274      44.460  40.440  29.806  1.00 58.90           O  
ATOM   1491  CB  VAL A 274      43.229  41.685  32.587  1.00 63.95           C  
ATOM   1492  CG1 VAL A 274      43.088  41.441  34.052  0.00 63.72           C  
ATOM   1493  CG2 VAL A 274      44.500  42.450  32.266  0.00 63.72           C  
ATOM   1494  N   ARG A 275      42.328  41.124  29.767  1.00 56.35           N  
ATOM   1495  CA  ARG A 275      42.353  41.533  28.384  1.00 53.13           C  
ATOM   1496  C   ARG A 275      42.252  43.024  28.596  1.00 50.88           C  
ATOM   1497  O   ARG A 275      41.424  43.479  29.376  1.00 51.43           O  
ATOM   1498  CB  ARG A 275      41.133  40.979  27.654  1.00 53.03           C  
ATOM   1499  CG  ARG A 275      41.107  39.471  27.598  1.00 53.80           C  
ATOM   1500  CD  ARG A 275      39.963  38.997  26.752  1.00 59.64           C  
ATOM   1501  NE  ARG A 275      40.341  37.861  25.915  1.00 65.13           N  
ATOM   1502  CZ  ARG A 275      40.091  36.586  26.203  1.00 67.02           C  
ATOM   1503  NH1 ARG A 275      39.453  36.256  27.318  1.00 66.98           N  
ATOM   1504  NH2 ARG A 275      40.476  35.638  25.362  1.00 68.40           N  
ATOM   1505  N   VAL A 276      43.115  43.787  27.944  1.00 49.11           N  
ATOM   1506  CA  VAL A 276      43.107  45.223  28.135  1.00 45.23           C  
ATOM   1507  C   VAL A 276      42.720  45.970  26.877  1.00 43.66           C  
ATOM   1508  O   VAL A 276      43.232  45.710  25.788  1.00 44.13           O  
ATOM   1509  CB  VAL A 276      44.486  45.727  28.639  1.00 44.41           C  
ATOM   1510  CG1 VAL A 276      44.389  47.191  28.988  1.00 44.57           C  
ATOM   1511  CG2 VAL A 276      44.921  44.943  29.869  1.00 41.93           C  
ATOM   1512  N   LEU A 277      41.792  46.900  27.051  1.00 41.19           N  
ATOM   1513  CA  LEU A 277      41.305  47.721  25.963  1.00 38.55           C  
ATOM   1514  C   LEU A 277      41.461  49.174  26.364  1.00 37.82           C  
ATOM   1515  O   LEU A 277      40.791  49.638  27.285  1.00 37.53           O  
ATOM   1516  CB  LEU A 277      39.833  47.421  25.695  1.00 37.95           C  
ATOM   1517  CG  LEU A 277      39.175  48.219  24.570  1.00 37.02           C  
ATOM   1518  CD1 LEU A 277      39.903  47.973  23.257  1.00 38.40           C  
ATOM   1519  CD2 LEU A 277      37.719  47.805  24.446  1.00 37.31           C  
ATOM   1520  N   GLY A 278      42.355  49.881  25.681  1.00 37.31           N  
ATOM   1521  CA  GLY A 278      42.581  51.286  25.972  1.00 36.36           C  
ATOM   1522  C   GLY A 278      41.723  52.198  25.107  1.00 36.40           C  
ATOM   1523  O   GLY A 278      40.847  51.743  24.381  1.00 34.71           O  
ATOM   1524  N   PHE A 279      41.978  53.498  25.199  1.00 38.11           N  
ATOM   1525  CA  PHE A 279      41.257  54.511  24.437  1.00 38.97           C  
ATOM   1526  C   PHE A 279      42.382  55.450  24.008  1.00 39.58           C  
ATOM   1527  O   PHE A 279      43.372  55.567  24.704  1.00 39.91           O  
ATOM   1528  CB  PHE A 279      40.133  55.099  25.284  1.00 38.73           C  
ATOM   1529  CG  PHE A 279      39.064  55.762  24.487  1.00 39.46           C  
ATOM   1530  CD1 PHE A 279      39.306  56.966  23.834  1.00 39.68           C  
ATOM   1531  CD2 PHE A 279      37.808  55.169  24.371  1.00 40.82           C  
ATOM   1532  CE1 PHE A 279      38.305  57.574  23.073  1.00 40.09           C  
ATOM   1533  CE2 PHE A 279      36.800  55.768  23.611  1.00 40.30           C  
ATOM   1534  CZ  PHE A 279      37.050  56.973  22.961  1.00 38.59           C  
ATOM   1535  N   ASP A 280      42.211  56.097  22.859  1.00 40.87           N  
ATOM   1536  CA  ASP A 280      43.180  57.031  22.273  1.00 42.13           C  
ATOM   1537  C   ASP A 280      44.140  56.601  21.166  1.00 41.58           C  
ATOM   1538  O   ASP A 280      44.840  57.422  20.596  1.00 40.95           O  
ATOM   1539  CB  ASP A 280      44.291  57.422  23.257  1.00 44.13           C  
ATOM   1540  CG  ASP A 280      43.890  58.553  24.201  1.00 47.29           C  
ATOM   1541  OD1 ASP A 280      42.911  59.291  23.937  1.00 49.57           O  
ATOM   1542  OD2 ASP A 280      44.586  58.724  25.222  1.00 48.95           O  
ATOM   1543  N   GLY A 281      44.179  55.310  20.865  1.00 41.37           N  
ATOM   1544  CA  GLY A 281      45.045  54.852  19.797  1.00 42.05           C  
ATOM   1545  C   GLY A 281      46.432  55.461  19.632  1.00 43.85           C  
ATOM   1546  O   GLY A 281      46.900  55.674  18.508  1.00 45.28           O  
ATOM   1547  N   HIS A 282      47.063  55.823  20.743  1.00 43.50           N  
ATOM   1548  CA  HIS A 282      48.390  56.423  20.699  1.00 42.94           C  
ATOM   1549  C   HIS A 282      49.432  55.569  20.002  1.00 45.21           C  
ATOM   1550  O   HIS A 282      49.333  54.345  19.983  1.00 46.09           O  
ATOM   1551  CB  HIS A 282      48.897  56.737  22.107  1.00 40.35           C  
ATOM   1552  CG  HIS A 282      48.207  57.891  22.750  1.00 38.98           C  
ATOM   1553  ND1 HIS A 282      47.810  59.005  22.045  1.00 40.48           N  
ATOM   1554  CD2 HIS A 282      47.859  58.115  24.037  1.00 40.30           C  
ATOM   1555  CE1 HIS A 282      47.243  59.867  22.869  1.00 40.01           C  
ATOM   1556  NE2 HIS A 282      47.261  59.351  24.084  1.00 40.95           N  
ATOM   1557  N   PRO A 283      50.453  56.210  19.418  1.00 46.79           N  
ATOM   1558  CA  PRO A 283      51.515  55.482  18.722  1.00 46.65           C  
ATOM   1559  C   PRO A 283      52.155  54.395  19.592  1.00 46.73           C  
ATOM   1560  O   PRO A 283      52.405  53.288  19.130  1.00 45.78           O  
ATOM   1561  CB  PRO A 283      52.503  56.588  18.363  1.00 46.07           C  
ATOM   1562  CG  PRO A 283      51.603  57.752  18.111  1.00 45.73           C  
ATOM   1563  CD  PRO A 283      50.621  57.666  19.253  1.00 47.18           C  
ATOM   1564  N   PHE A 284      52.408  54.706  20.854  1.00 47.02           N  
ATOM   1565  CA  PHE A 284      53.037  53.729  21.721  1.00 48.31           C  
ATOM   1566  C   PHE A 284      52.194  52.480  21.935  1.00 49.86           C  
ATOM   1567  O   PHE A 284      52.665  51.490  22.490  1.00 49.98           O  
ATOM   1568  CB  PHE A 284      53.403  54.373  23.066  1.00 47.80           C  
ATOM   1569  CG  PHE A 284      52.227  54.700  23.950  1.00 47.28           C  
ATOM   1570  CD1 PHE A 284      51.481  53.692  24.557  1.00 47.83           C  
ATOM   1571  CD2 PHE A 284      51.905  56.024  24.232  1.00 48.30           C  
ATOM   1572  CE1 PHE A 284      50.440  54.000  25.431  1.00 46.42           C  
ATOM   1573  CE2 PHE A 284      50.864  56.341  25.107  1.00 46.30           C  
ATOM   1574  CZ  PHE A 284      50.134  55.326  25.705  1.00 46.71           C  
ATOM   1575  N   ALA A 285      50.953  52.517  21.472  1.00 51.91           N  
ATOM   1576  CA  ALA A 285      50.040  51.393  21.644  1.00 53.92           C  
ATOM   1577  C   ALA A 285      50.339  50.184  20.769  1.00 56.05           C  
ATOM   1578  O   ALA A 285      50.005  49.058  21.133  1.00 55.99           O  
ATOM   1579  CB  ALA A 285      48.610  51.851  21.407  1.00 52.66           C  
ATOM   1580  N   GLU A 286      50.966  50.410  19.620  1.00 59.11           N  
ATOM   1581  CA  GLU A 286      51.274  49.317  18.706  1.00 61.70           C  
ATOM   1582  C   GLU A 286      52.376  48.405  19.228  1.00 62.41           C  
ATOM   1583  O   GLU A 286      52.223  47.180  19.228  1.00 62.57           O  
ATOM   1584  CB  GLU A 286      51.651  49.871  17.332  1.00 63.90           C  
ATOM   1585  CG  GLU A 286      51.864  48.809  16.271  1.00 67.55           C  
ATOM   1586  CD  GLU A 286      51.894  49.393  14.873  1.00 70.88           C  
ATOM   1587  OE1 GLU A 286      52.625  50.384  14.656  1.00 73.04           O  
ATOM   1588  OE2 GLU A 286      51.188  48.860  13.989  1.00 72.45           O  
ATOM   1589  N   GLU A 287      53.482  48.992  19.682  1.00 62.51           N  
ATOM   1590  CA  GLU A 287      54.586  48.196  20.209  1.00 62.93           C  
ATOM   1591  C   GLU A 287      54.201  47.463  21.483  1.00 60.51           C  
ATOM   1592  O   GLU A 287      54.715  46.379  21.758  1.00 61.23           O  
ATOM   1593  CB  GLU A 287      55.810  49.074  20.475  1.00 67.15           C  
ATOM   1594  CG  GLU A 287      55.516  50.367  21.208  1.00 73.46           C  
ATOM   1595  CD  GLU A 287      55.986  51.586  20.425  1.00 78.35           C  
ATOM   1596  OE1 GLU A 287      55.513  51.775  19.279  1.00 80.24           O  
ATOM   1597  OE2 GLU A 287      56.827  52.352  20.950  1.00 79.51           O  
ATOM   1598  N   ALA A 288      53.296  48.055  22.255  1.00 56.96           N  
ATOM   1599  CA  ALA A 288      52.845  47.456  23.504  1.00 53.23           C  
ATOM   1600  C   ALA A 288      51.870  46.311  23.264  1.00 50.91           C  
ATOM   1601  O   ALA A 288      51.601  45.525  24.166  1.00 51.09           O  
ATOM   1602  CB  ALA A 288      52.194  48.516  24.385  1.00 52.68           C  
ATOM   1603  N   GLY A 289      51.343  46.220  22.047  1.00 48.91           N  
ATOM   1604  CA  GLY A 289      50.395  45.170  21.724  1.00 46.66           C  
ATOM   1605  C   GLY A 289      49.043  45.439  22.362  1.00 45.56           C  
ATOM   1606  O   GLY A 289      48.247  44.528  22.578  1.00 44.43           O  
ATOM   1607  N   LEU A 290      48.787  46.708  22.655  1.00 44.05           N  
ATOM   1608  CA  LEU A 290      47.542  47.130  23.276  1.00 42.52           C  
ATOM   1609  C   LEU A 290      46.392  47.343  22.292  1.00 40.91           C  
ATOM   1610  O   LEU A 290      46.526  48.078  21.316  1.00 42.18           O  
ATOM   1611  CB  LEU A 290      47.782  48.426  24.059  1.00 43.39           C  
ATOM   1612  CG  LEU A 290      46.574  49.156  24.660  1.00 45.24           C  
ATOM   1613  CD1 LEU A 290      45.790  48.221  25.560  1.00 45.75           C  
ATOM   1614  CD2 LEU A 290      47.049  50.365  25.448  1.00 47.36           C  
ATOM   1615  N   SER A 291      45.261  46.694  22.541  1.00 37.71           N  
ATOM   1616  CA  SER A 291      44.100  46.890  21.688  1.00 35.86           C  
ATOM   1617  C   SER A 291      43.545  48.202  22.203  1.00 33.98           C  
ATOM   1618  O   SER A 291      43.687  48.507  23.383  1.00 33.77           O  
ATOM   1619  CB  SER A 291      43.055  45.785  21.887  1.00 36.01           C  
ATOM   1620  OG  SER A 291      43.596  44.500  21.637  1.00 39.29           O  
ATOM   1621  N   THR A 292      42.908  48.984  21.347  1.00 33.59           N  
ATOM   1622  CA  THR A 292      42.373  50.248  21.818  1.00 33.89           C  
ATOM   1623  C   THR A 292      41.318  50.819  20.887  1.00 32.98           C  
ATOM   1624  O   THR A 292      41.126  50.331  19.782  1.00 34.17           O  
ATOM   1625  CB  THR A 292      43.529  51.284  22.007  1.00 34.46           C  
ATOM   1626  OG1 THR A 292      43.001  52.534  22.463  1.00 37.06           O  
ATOM   1627  CG2 THR A 292      44.279  51.508  20.702  1.00 32.03           C  
ATOM   1628  N   ILE A 293      40.611  51.829  21.372  1.00 32.85           N  
ATOM   1629  CA  ILE A 293      39.609  52.540  20.588  1.00 33.74           C  
ATOM   1630  C   ILE A 293      40.428  53.741  20.109  1.00 34.98           C  
ATOM   1631  O   ILE A 293      40.654  54.695  20.861  1.00 33.58           O  
ATOM   1632  CB  ILE A 293      38.433  53.052  21.472  1.00 33.15           C  
ATOM   1633  CG1 ILE A 293      37.748  51.879  22.168  1.00 28.53           C  
ATOM   1634  CG2 ILE A 293      37.435  53.828  20.620  1.00 31.44           C  
ATOM   1635  CD1 ILE A 293      37.133  50.906  21.206  1.00 29.64           C  
ATOM   1636  N   ALA A 294      40.877  53.684  18.861  1.00 36.56           N  
ATOM   1637  CA  ALA A 294      41.719  54.740  18.302  1.00 38.12           C  
ATOM   1638  C   ALA A 294      41.050  56.033  17.845  1.00 37.32           C  
ATOM   1639  O   ALA A 294      40.051  56.011  17.130  1.00 38.00           O  
ATOM   1640  CB  ALA A 294      42.562  54.166  17.153  1.00 38.69           C  
ATOM   1641  N   GLN A 295      41.634  57.150  18.270  1.00 36.94           N  
ATOM   1642  CA  GLN A 295      41.181  58.485  17.904  1.00 36.79           C  
ATOM   1643  C   GLN A 295      42.120  59.026  16.824  1.00 36.61           C  
ATOM   1644  O   GLN A 295      43.325  58.821  16.897  1.00 35.85           O  
ATOM   1645  CB  GLN A 295      41.271  59.445  19.079  1.00 38.81           C  
ATOM   1646  CG  GLN A 295      40.381  59.177  20.256  1.00 42.22           C  
ATOM   1647  CD  GLN A 295      40.394  60.357  21.217  1.00 44.52           C  
ATOM   1648  OE1 GLN A 295      39.861  61.426  20.907  1.00 45.19           O  
ATOM   1649  NE2 GLN A 295      41.021  60.178  22.375  1.00 44.52           N  
ATOM   1650  N   PRO A 296      41.573  59.714  15.803  1.00 37.21           N  
ATOM   1651  CA  PRO A 296      42.380  60.290  14.713  1.00 36.01           C  
ATOM   1652  C   PRO A 296      42.791  61.697  15.123  1.00 35.71           C  
ATOM   1653  O   PRO A 296      42.411  62.679  14.484  1.00 35.36           O  
ATOM   1654  CB  PRO A 296      41.404  60.297  13.546  1.00 36.33           C  
ATOM   1655  CG  PRO A 296      40.082  60.609  14.247  1.00 35.58           C  
ATOM   1656  CD  PRO A 296      40.131  59.741  15.472  1.00 35.76           C  
ATOM   1657  N   VAL A 297      43.566  61.778  16.198  1.00 37.50           N  
ATOM   1658  CA  VAL A 297      44.005  63.048  16.779  1.00 38.58           C  
ATOM   1659  C   VAL A 297      44.757  64.006  15.856  1.00 39.44           C  
ATOM   1660  O   VAL A 297      44.511  65.208  15.880  1.00 39.79           O  
ATOM   1661  CB  VAL A 297      44.837  62.790  18.055  1.00 38.26           C  
ATOM   1662  CG1 VAL A 297      45.082  64.084  18.792  1.00 38.55           C  
ATOM   1663  CG2 VAL A 297      44.105  61.811  18.956  1.00 36.52           C  
ATOM   1664  N   GLU A 298      45.667  63.490  15.044  1.00 40.25           N  
ATOM   1665  CA  GLU A 298      46.398  64.349  14.123  1.00 40.86           C  
ATOM   1666  C   GLU A 298      45.421  64.937  13.113  1.00 39.09           C  
ATOM   1667  O   GLU A 298      45.399  66.151  12.892  1.00 39.36           O  
ATOM   1668  CB  GLU A 298      47.493  63.559  13.398  1.00 43.36           C  
ATOM   1669  CG  GLU A 298      48.503  62.917  14.331  1.00 48.47           C  
ATOM   1670  CD  GLU A 298      48.036  61.578  14.876  1.00 52.62           C  
ATOM   1671  OE1 GLU A 298      46.834  61.445  15.192  1.00 55.33           O  
ATOM   1672  OE2 GLU A 298      48.875  60.658  15.002  1.00 54.60           O  
ATOM   1673  N   ALA A 299      44.603  64.071  12.517  1.00 37.43           N  
ATOM   1674  CA  ALA A 299      43.605  64.500  11.530  1.00 36.58           C  
ATOM   1675  C   ALA A 299      42.665  65.537  12.145  1.00 35.37           C  
ATOM   1676  O   ALA A 299      42.191  66.449  11.458  1.00 34.49           O  
ATOM   1677  CB  ALA A 299      42.809  63.290  11.028  1.00 34.56           C  
ATOM   1678  N   MET A 300      42.395  65.386  13.444  1.00 33.94           N  
ATOM   1679  CA  MET A 300      41.529  66.320  14.158  1.00 32.59           C  
ATOM   1680  C   MET A 300      42.221  67.681  14.243  1.00 32.72           C  
ATOM   1681  O   MET A 300      41.578  68.715  14.097  1.00 31.33           O  
ATOM   1682  CB  MET A 300      41.215  65.791  15.566  1.00 31.70           C  
ATOM   1683  CG  MET A 300      40.282  64.575  15.595  1.00 29.33           C  
ATOM   1684  SD  MET A 300      39.985  63.907  17.255  1.00 23.58           S  
ATOM   1685  CE  MET A 300      39.178  65.296  17.963  1.00 24.07           C  
ATOM   1686  N   GLY A 301      43.534  67.667  14.473  1.00 32.95           N  
ATOM   1687  CA  GLY A 301      44.301  68.902  14.546  1.00 31.94           C  
ATOM   1688  C   GLY A 301      44.416  69.508  13.157  1.00 32.95           C  
ATOM   1689  O   GLY A 301      44.196  70.709  12.967  1.00 31.91           O  
ATOM   1690  N   ALA A 302      44.761  68.669  12.183  1.00 32.32           N  
ATOM   1691  CA  ALA A 302      44.864  69.101  10.787  1.00 33.21           C  
ATOM   1692  C   ALA A 302      43.555  69.728  10.306  1.00 32.61           C  
ATOM   1693  O   ALA A 302      43.566  70.750   9.630  1.00 33.22           O  
ATOM   1694  CB  ALA A 302      45.229  67.918   9.891  1.00 33.69           C  
ATOM   1695  N   ARG A 303      42.426  69.115  10.649  1.00 32.80           N  
ATOM   1696  CA  ARG A 303      41.134  69.663  10.245  1.00 34.23           C  
ATOM   1697  C   ARG A 303      40.916  70.999  10.939  1.00 35.45           C  
ATOM   1698  O   ARG A 303      40.421  71.951  10.335  1.00 35.29           O  
ATOM   1699  CB  ARG A 303      39.995  68.701  10.601  1.00 34.22           C  
ATOM   1700  CG  ARG A 303      38.597  69.254  10.315  1.00 36.84           C  
ATOM   1701  CD  ARG A 303      38.458  69.742   8.861  1.00 38.22           C  
ATOM   1702  NE  ARG A 303      38.794  68.690   7.901  1.00 39.00           N  
ATOM   1703  CZ  ARG A 303      38.860  68.865   6.588  1.00 39.69           C  
ATOM   1704  NH1 ARG A 303      38.611  70.061   6.065  1.00 41.09           N  
ATOM   1705  NH2 ARG A 303      39.192  67.852   5.803  1.00 37.17           N  
ATOM   1706  N   ALA A 304      41.287  71.059  12.215  1.00 37.50           N  
ATOM   1707  CA  ALA A 304      41.161  72.283  12.997  1.00 38.80           C  
ATOM   1708  C   ALA A 304      41.972  73.399  12.336  1.00 40.01           C  
ATOM   1709  O   ALA A 304      41.543  74.548  12.276  1.00 38.57           O  
ATOM   1710  CB  ALA A 304      41.669  72.044  14.396  1.00 38.53           C  
ATOM   1711  N   ALA A 305      43.154  73.049  11.841  1.00 40.83           N  
ATOM   1712  CA  ALA A 305      44.007  74.020  11.181  1.00 43.14           C  
ATOM   1713  C   ALA A 305      43.370  74.531   9.880  1.00 44.51           C  
ATOM   1714  O   ALA A 305      43.291  75.741   9.656  1.00 45.02           O  
ATOM   1715  CB  ALA A 305      45.378  73.400  10.892  1.00 42.25           C  
ATOM   1716  N   GLN A 306      42.910  73.610   9.032  1.00 45.03           N  
ATOM   1717  CA  GLN A 306      42.294  73.975   7.757  1.00 43.24           C  
ATOM   1718  C   GLN A 306      41.133  74.942   7.910  1.00 41.25           C  
ATOM   1719  O   GLN A 306      41.049  75.928   7.187  1.00 40.31           O  
ATOM   1720  CB  GLN A 306      41.814  72.727   7.013  1.00 44.40           C  
ATOM   1721  CG  GLN A 306      41.108  73.031   5.686  1.00 47.13           C  
ATOM   1722  CD  GLN A 306      42.026  73.622   4.610  1.00 47.77           C  
ATOM   1723  OE1 GLN A 306      41.554  74.288   3.683  1.00 47.33           O  
ATOM   1724  NE2 GLN A 306      43.329  73.366   4.720  1.00 47.98           N  
ATOM   1725  N   LEU A 307      40.234  74.654   8.844  1.00 41.14           N  
ATOM   1726  CA  LEU A 307      39.084  75.519   9.085  1.00 42.00           C  
ATOM   1727  C   LEU A 307      39.579  76.904   9.431  1.00 42.01           C  
ATOM   1728  O   LEU A 307      39.064  77.897   8.924  1.00 42.12           O  
ATOM   1729  CB  LEU A 307      38.230  74.993  10.245  1.00 42.04           C  
ATOM   1730  CG  LEU A 307      37.431  73.701  10.051  1.00 41.88           C  
ATOM   1731  CD1 LEU A 307      36.942  73.204  11.390  1.00 43.14           C  
ATOM   1732  CD2 LEU A 307      36.264  73.949   9.118  1.00 41.47           C  
ATOM   1733  N   LEU A 308      40.589  76.958  10.296  1.00 43.00           N  
ATOM   1734  CA  LEU A 308      41.173  78.222  10.730  1.00 43.41           C  
ATOM   1735  C   LEU A 308      41.660  79.029   9.535  1.00 43.94           C  
ATOM   1736  O   LEU A 308      41.372  80.221   9.431  1.00 42.83           O  
ATOM   1737  CB  LEU A 308      42.339  77.964  11.683  1.00 43.34           C  
ATOM   1738  CG  LEU A 308      42.942  79.206  12.337  1.00 42.30           C  
ATOM   1739  CD1 LEU A 308      41.913  79.864  13.232  1.00 40.34           C  
ATOM   1740  CD2 LEU A 308      44.164  78.812  13.133  1.00 44.46           C  
ATOM   1741  N   LEU A 309      42.402  78.367   8.650  1.00 45.54           N  
ATOM   1742  CA  LEU A 309      42.937  78.984   7.439  1.00 46.84           C  
ATOM   1743  C   LEU A 309      41.817  79.566   6.612  1.00 47.96           C  
ATOM   1744  O   LEU A 309      41.867  80.727   6.199  1.00 47.90           O  
ATOM   1745  CB  LEU A 309      43.659  77.955   6.579  1.00 48.99           C  
ATOM   1746  CG  LEU A 309      45.123  77.635   6.862  1.00 52.85           C  
ATOM   1747  CD1 LEU A 309      45.589  76.586   5.863  1.00 54.40           C  
ATOM   1748  CD2 LEU A 309      45.969  78.904   6.739  1.00 53.72           C  
ATOM   1749  N   GLU A 310      40.809  78.739   6.355  1.00 48.33           N  
ATOM   1750  CA  GLU A 310      39.666  79.167   5.567  1.00 48.71           C  
ATOM   1751  C   GLU A 310      39.135  80.457   6.159  1.00 48.58           C  
ATOM   1752  O   GLU A 310      38.853  81.413   5.445  1.00 50.22           O  
ATOM   1753  CB  GLU A 310      38.587  78.083   5.575  1.00 48.10           C  
ATOM   1754  CG  GLU A 310      38.855  76.949   4.596  1.00 48.68           C  
ATOM   1755  CD  GLU A 310      38.156  75.653   4.975  1.00 49.83           C  
ATOM   1756  OE1 GLU A 310      37.158  75.695   5.722  1.00 49.72           O  
ATOM   1757  OE2 GLU A 310      38.607  74.584   4.516  1.00 49.93           O  
ATOM   1758  N   ARG A 311      39.030  80.485   7.479  1.00 48.08           N  
ATOM   1759  CA  ARG A 311      38.529  81.657   8.165  1.00 47.15           C  
ATOM   1760  C   ARG A 311      39.538  82.813   8.110  1.00 47.72           C  
ATOM   1761  O   ARG A 311      39.160  83.965   7.888  1.00 46.55           O  
ATOM   1762  CB  ARG A 311      38.204  81.299   9.614  1.00 45.52           C  
ATOM   1763  CG  ARG A 311      36.838  81.775  10.055  1.00 44.73           C  
ATOM   1764  CD  ARG A 311      35.763  80.703   9.934  1.00 42.56           C  
ATOM   1765  NE  ARG A 311      34.457  81.307   9.677  1.00 40.02           N  
ATOM   1766  CZ  ARG A 311      33.290  80.779  10.028  1.00 39.43           C  
ATOM   1767  NH1 ARG A 311      33.229  79.624  10.667  1.00 38.56           N  
ATOM   1768  NH2 ARG A 311      32.170  81.415   9.737  1.00 37.90           N  
ATOM   1769  N   MET A 312      40.817  82.506   8.309  1.00 48.51           N  
ATOM   1770  CA  MET A 312      41.840  83.546   8.271  1.00 49.44           C  
ATOM   1771  C   MET A 312      41.959  84.110   6.866  1.00 51.83           C  
ATOM   1772  O   MET A 312      42.414  85.237   6.676  1.00 53.62           O  
ATOM   1773  CB  MET A 312      43.204  83.006   8.733  1.00 45.65           C  
ATOM   1774  CG  MET A 312      43.285  82.673  10.227  1.00 42.23           C  
ATOM   1775  SD  MET A 312      44.968  82.414  10.856  1.00 38.92           S  
ATOM   1776  CE  MET A 312      45.566  81.102   9.800  1.00 36.40           C  
ATOM   1777  N   ARG A 313      41.535  83.323   5.881  1.00 53.74           N  
ATOM   1778  CA  ARG A 313      41.598  83.739   4.483  1.00 53.49           C  
ATOM   1779  C   ARG A 313      40.300  84.353   3.979  1.00 54.17           C  
ATOM   1780  O   ARG A 313      40.013  84.319   2.785  1.00 54.49           O  
ATOM   1781  CB  ARG A 313      42.002  82.557   3.599  1.00 52.12           C  
ATOM   1782  CG  ARG A 313      43.483  82.228   3.695  1.00 52.75           C  
ATOM   1783  CD  ARG A 313      43.804  80.857   3.137  1.00 51.13           C  
ATOM   1784  NE  ARG A 313      45.226  80.711   2.853  1.00 49.47           N  
ATOM   1785  CZ  ARG A 313      45.790  79.577   2.457  1.00 49.45           C  
ATOM   1786  NH1 ARG A 313      45.050  78.488   2.307  1.00 50.45           N  
ATOM   1787  NH2 ARG A 313      47.088  79.534   2.192  1.00 48.75           N  
ATOM   1788  N   GLY A 314      39.512  84.903   4.899  1.00 54.45           N  
ATOM   1789  CA  GLY A 314      38.281  85.566   4.512  1.00 54.44           C  
ATOM   1790  C   GLY A 314      36.965  84.820   4.488  1.00 55.02           C  
ATOM   1791  O   GLY A 314      35.940  85.430   4.188  1.00 55.75           O  
ATOM   1792  N   TYR A 315      36.956  83.528   4.802  1.00 55.02           N  
ATOM   1793  CA  TYR A 315      35.696  82.783   4.781  1.00 55.49           C  
ATOM   1794  C   TYR A 315      34.671  83.291   5.793  1.00 56.41           C  
ATOM   1795  O   TYR A 315      34.963  83.439   6.981  1.00 57.33           O  
ATOM   1796  CB  TYR A 315      35.920  81.286   5.024  1.00 54.13           C  
ATOM   1797  CG  TYR A 315      34.606  80.551   5.141  1.00 52.91           C  
ATOM   1798  CD1 TYR A 315      33.783  80.383   4.029  1.00 51.23           C  
ATOM   1799  CD2 TYR A 315      34.123  80.146   6.383  1.00 52.77           C  
ATOM   1800  CE1 TYR A 315      32.511  79.843   4.153  1.00 50.53           C  
ATOM   1801  CE2 TYR A 315      32.849  79.606   6.518  1.00 51.07           C  
ATOM   1802  CZ  TYR A 315      32.046  79.462   5.398  1.00 50.60           C  
ATOM   1803  OH  TYR A 315      30.767  78.974   5.532  1.00 50.58           O  
ATOM   1804  N   GLN A 316      33.461  83.545   5.315  1.00 57.47           N  
ATOM   1805  CA  GLN A 316      32.394  84.030   6.175  1.00 59.23           C  
ATOM   1806  C   GLN A 316      31.212  83.076   6.129  1.00 58.82           C  
ATOM   1807  O   GLN A 316      30.880  82.524   5.079  1.00 60.30           O  
ATOM   1808  CB  GLN A 316      31.950  85.423   5.737  1.00 61.64           C  
ATOM   1809  CG  GLN A 316      33.056  86.459   5.768  1.00 67.38           C  
ATOM   1810  CD  GLN A 316      32.607  87.813   5.245  1.00 70.84           C  
ATOM   1811  OE1 GLN A 316      33.388  88.766   5.213  1.00 72.57           O  
ATOM   1812  NE2 GLN A 316      31.346  87.904   4.832  1.00 71.64           N  
ATOM   1813  N   GLY A 317      30.577  82.889   7.277  1.00 56.98           N  
ATOM   1814  CA  GLY A 317      29.440  81.997   7.366  1.00 53.83           C  
ATOM   1815  C   GLY A 317      29.248  81.658   8.825  1.00 53.29           C  
ATOM   1816  O   GLY A 317      30.086  82.016   9.651  1.00 51.65           O  
ATOM   1817  N   PRO A 318      28.149  80.986   9.189  1.00 52.68           N  
ATOM   1818  CA  PRO A 318      27.966  80.655  10.605  1.00 52.49           C  
ATOM   1819  C   PRO A 318      28.940  79.586  11.115  1.00 51.51           C  
ATOM   1820  O   PRO A 318      29.589  78.888  10.335  1.00 50.70           O  
ATOM   1821  CB  PRO A 318      26.502  80.212  10.668  1.00 52.31           C  
ATOM   1822  CG  PRO A 318      26.270  79.630   9.322  1.00 52.24           C  
ATOM   1823  CD  PRO A 318      26.966  80.607   8.400  1.00 51.87           C  
ATOM   1824  N   PRO A 319      29.065  79.465  12.442  1.00 50.95           N  
ATOM   1825  CA  PRO A 319      29.953  78.491  13.082  1.00 49.99           C  
ATOM   1826  C   PRO A 319      29.790  77.091  12.496  1.00 49.10           C  
ATOM   1827  O   PRO A 319      28.708  76.506  12.543  1.00 48.71           O  
ATOM   1828  CB  PRO A 319      29.520  78.551  14.543  1.00 50.28           C  
ATOM   1829  CG  PRO A 319      29.154  79.985  14.701  1.00 51.45           C  
ATOM   1830  CD  PRO A 319      28.355  80.270  13.451  1.00 50.18           C  
ATOM   1831  N   ARG A 320      30.870  76.553  11.946  1.00 48.31           N  
ATOM   1832  CA  ARG A 320      30.824  75.221  11.365  1.00 46.82           C  
ATOM   1833  C   ARG A 320      31.111  74.151  12.407  1.00 46.23           C  
ATOM   1834  O   ARG A 320      31.412  74.452  13.561  1.00 46.29           O  
ATOM   1835  CB  ARG A 320      31.817  75.113  10.215  1.00 46.56           C  
ATOM   1836  CG  ARG A 320      31.488  76.027   9.064  1.00 45.73           C  
ATOM   1837  CD  ARG A 320      32.647  76.090   8.107  1.00 46.77           C  
ATOM   1838  NE  ARG A 320      33.840  76.625   8.751  1.00 45.22           N  
ATOM   1839  CZ  ARG A 320      35.023  76.728   8.155  1.00 47.16           C  
ATOM   1840  NH1 ARG A 320      35.171  76.330   6.900  1.00 46.42           N  
ATOM   1841  NH2 ARG A 320      36.061  77.230   8.812  1.00 49.08           N  
ATOM   1842  N   GLU A 321      31.029  72.897  11.985  1.00 45.21           N  
ATOM   1843  CA  GLU A 321      31.234  71.784  12.890  1.00 43.38           C  
ATOM   1844  C   GLU A 321      31.696  70.537  12.130  1.00 42.58           C  
ATOM   1845  O   GLU A 321      31.210  70.255  11.035  1.00 42.27           O  
ATOM   1846  CB  GLU A 321      29.914  71.537  13.618  1.00 43.29           C  
ATOM   1847  CG  GLU A 321      29.850  70.310  14.476  1.00 49.57           C  
ATOM   1848  CD  GLU A 321      28.478  70.118  15.103  1.00 52.15           C  
ATOM   1849  OE1 GLU A 321      28.124  70.885  16.027  1.00 52.59           O  
ATOM   1850  OE2 GLU A 321      27.750  69.202  14.662  1.00 54.48           O  
ATOM   1851  N   VAL A 322      32.657  69.814  12.703  1.00 41.74           N  
ATOM   1852  CA  VAL A 322      33.182  68.588  12.093  1.00 41.95           C  
ATOM   1853  C   VAL A 322      33.384  67.507  13.155  1.00 41.90           C  
ATOM   1854  O   VAL A 322      34.124  67.692  14.121  1.00 42.49           O  
ATOM   1855  CB  VAL A 322      34.521  68.840  11.350  1.00 41.29           C  
ATOM   1856  CG1 VAL A 322      35.135  67.518  10.916  1.00 38.90           C  
ATOM   1857  CG2 VAL A 322      34.275  69.699  10.121  1.00 40.84           C  
ATOM   1858  N   ARG A 323      32.716  66.378  12.952  1.00 40.88           N  
ATOM   1859  CA  ARG A 323      32.753  65.256  13.877  1.00 40.65           C  
ATOM   1860  C   ARG A 323      33.529  64.047  13.357  1.00 41.31           C  
ATOM   1861  O   ARG A 323      33.285  63.552  12.251  1.00 42.89           O  
ATOM   1862  CB  ARG A 323      31.311  64.864  14.222  1.00 40.28           C  
ATOM   1863  CG  ARG A 323      31.095  63.467  14.758  1.00 38.85           C  
ATOM   1864  CD  ARG A 323      29.595  63.210  14.919  1.00 39.90           C  
ATOM   1865  NE  ARG A 323      29.294  61.818  15.239  1.00 40.51           N  
ATOM   1866  CZ  ARG A 323      29.361  60.811  14.372  1.00 41.90           C  
ATOM   1867  NH1 ARG A 323      29.709  61.032  13.107  1.00 41.37           N  
ATOM   1868  NH2 ARG A 323      29.113  59.574  14.783  1.00 40.94           N  
ATOM   1869  N   PHE A 324      34.472  63.577  14.166  1.00 40.69           N  
ATOM   1870  CA  PHE A 324      35.280  62.423  13.810  1.00 41.48           C  
ATOM   1871  C   PHE A 324      34.760  61.189  14.539  1.00 41.94           C  
ATOM   1872  O   PHE A 324      34.020  61.310  15.511  1.00 43.31           O  
ATOM   1873  CB  PHE A 324      36.750  62.676  14.173  1.00 40.82           C  
ATOM   1874  CG  PHE A 324      37.465  63.592  13.215  1.00 39.95           C  
ATOM   1875  CD1 PHE A 324      37.132  64.941  13.134  1.00 38.35           C  
ATOM   1876  CD2 PHE A 324      38.470  63.100  12.383  1.00 39.99           C  
ATOM   1877  CE1 PHE A 324      37.792  65.789  12.242  1.00 37.52           C  
ATOM   1878  CE2 PHE A 324      39.138  63.943  11.484  1.00 38.91           C  
ATOM   1879  CZ  PHE A 324      38.800  65.285  11.415  1.00 36.91           C  
ATOM   1880  N   GLU A 325      35.129  60.003  14.063  1.00 42.50           N  
ATOM   1881  CA  GLU A 325      34.690  58.764  14.701  1.00 43.81           C  
ATOM   1882  C   GLU A 325      35.879  57.901  15.077  1.00 41.69           C  
ATOM   1883  O   GLU A 325      36.829  57.772  14.315  1.00 40.50           O  
ATOM   1884  CB  GLU A 325      33.773  57.939  13.782  1.00 46.85           C  
ATOM   1885  CG  GLU A 325      32.493  58.628  13.328  1.00 52.83           C  
ATOM   1886  CD  GLU A 325      31.540  57.679  12.597  1.00 56.92           C  
ATOM   1887  OE1 GLU A 325      32.016  56.853  11.782  1.00 57.76           O  
ATOM   1888  OE2 GLU A 325      30.311  57.767  12.827  1.00 58.16           O  
ATOM   1889  N   PRO A 326      35.839  57.298  16.269  1.00 41.09           N  
ATOM   1890  CA  PRO A 326      36.918  56.435  16.743  1.00 41.16           C  
ATOM   1891  C   PRO A 326      36.721  55.040  16.157  1.00 41.49           C  
ATOM   1892  O   PRO A 326      35.628  54.701  15.709  1.00 43.19           O  
ATOM   1893  CB  PRO A 326      36.732  56.471  18.249  1.00 41.02           C  
ATOM   1894  CG  PRO A 326      35.242  56.509  18.373  1.00 41.28           C  
ATOM   1895  CD  PRO A 326      34.840  57.520  17.328  1.00 41.65           C  
ATOM   1896  N   VAL A 327      37.769  54.231  16.153  1.00 40.66           N  
ATOM   1897  CA  VAL A 327      37.652  52.896  15.594  1.00 41.49           C  
ATOM   1898  C   VAL A 327      38.416  51.890  16.437  1.00 40.85           C  
ATOM   1899  O   VAL A 327      39.490  52.189  16.956  1.00 40.80           O  
ATOM   1900  CB  VAL A 327      38.191  52.862  14.135  1.00 42.72           C  
ATOM   1901  CG1 VAL A 327      39.677  53.187  14.124  1.00 43.31           C  
ATOM   1902  CG2 VAL A 327      37.937  51.503  13.504  1.00 42.56           C  
ATOM   1903  N   LEU A 328      37.859  50.695  16.568  1.00 40.18           N  
ATOM   1904  CA  LEU A 328      38.498  49.647  17.346  1.00 39.74           C  
ATOM   1905  C   LEU A 328      39.669  49.071  16.575  1.00 38.99           C  
ATOM   1906  O   LEU A 328      39.562  48.787  15.382  1.00 40.32           O  
ATOM   1907  CB  LEU A 328      37.505  48.519  17.633  1.00 41.19           C  
ATOM   1908  CG  LEU A 328      37.756  47.497  18.756  1.00 41.71           C  
ATOM   1909  CD1 LEU A 328      37.067  46.191  18.382  1.00 40.34           C  
ATOM   1910  CD2 LEU A 328      39.225  47.243  18.968  1.00 41.35           C  
ATOM   1911  N   VAL A 329      40.793  48.904  17.254  1.00 36.98           N  
ATOM   1912  CA  VAL A 329      41.962  48.305  16.632  1.00 36.58           C  
ATOM   1913  C   VAL A 329      42.356  47.168  17.568  1.00 37.39           C  
ATOM   1914  O   VAL A 329      42.780  47.415  18.691  1.00 39.16           O  
ATOM   1915  CB  VAL A 329      43.126  49.317  16.496  1.00 35.17           C  
ATOM   1916  CG1 VAL A 329      44.296  48.676  15.739  1.00 30.91           C  
ATOM   1917  CG2 VAL A 329      42.639  50.575  15.780  1.00 32.37           C  
ATOM   1918  N   GLU A 330      42.187  45.929  17.112  1.00 37.54           N  
ATOM   1919  CA  GLU A 330      42.500  44.753  17.919  1.00 39.88           C  
ATOM   1920  C   GLU A 330      43.969  44.349  17.918  1.00 40.68           C  
ATOM   1921  O   GLU A 330      44.590  44.225  16.865  1.00 42.87           O  
ATOM   1922  CB  GLU A 330      41.683  43.555  17.446  1.00 42.73           C  
ATOM   1923  CG  GLU A 330      40.184  43.721  17.561  1.00 49.89           C  
ATOM   1924  CD  GLU A 330      39.443  42.528  16.991  1.00 54.10           C  
ATOM   1925  OE1 GLU A 330      39.824  41.383  17.331  1.00 55.70           O  
ATOM   1926  OE2 GLU A 330      38.481  42.731  16.215  1.00 55.42           O  
ATOM   1927  N   ARG A 331      44.516  44.127  19.107  1.00 39.32           N  
ATOM   1928  CA  ARG A 331      45.894  43.715  19.243  1.00 36.97           C  
ATOM   1929  C   ARG A 331      45.972  42.583  20.266  1.00 37.96           C  
ATOM   1930  O   ARG A 331      44.943  42.041  20.658  1.00 38.99           O  
ATOM   1931  CB  ARG A 331      46.757  44.911  19.635  1.00 35.92           C  
ATOM   1932  CG  ARG A 331      46.751  46.006  18.565  1.00 34.25           C  
ATOM   1933  CD  ARG A 331      47.960  46.920  18.698  1.00 35.68           C  
ATOM   1934  NE  ARG A 331      48.115  47.851  17.576  1.00 36.23           N  
ATOM   1935  CZ  ARG A 331      47.676  49.107  17.574  1.00 36.37           C  
ATOM   1936  NH1 ARG A 331      47.043  49.590  18.636  1.00 38.68           N  
ATOM   1937  NH2 ARG A 331      47.890  49.890  16.524  1.00 35.18           N  
ATOM   1938  N   ALA A 332      47.179  42.224  20.696  1.00 38.62           N  
ATOM   1939  CA  ALA A 332      47.365  41.114  21.634  1.00 38.91           C  
ATOM   1940  C   ALA A 332      46.787  41.253  23.052  1.00 40.29           C  
ATOM   1941  O   ALA A 332      46.324  40.272  23.631  1.00 39.40           O  
ATOM   1942  CB  ALA A 332      48.845  40.772  21.717  1.00 37.85           C  
ATOM   1943  N   SER A 333      46.819  42.451  23.622  1.00 42.33           N  
ATOM   1944  CA  SER A 333      46.305  42.630  24.973  1.00 44.78           C  
ATOM   1945  C   SER A 333      44.858  42.187  25.035  1.00 46.70           C  
ATOM   1946  O   SER A 333      44.258  42.152  26.099  1.00 47.98           O  
ATOM   1947  CB  SER A 333      46.404  44.095  25.414  1.00 44.13           C  
ATOM   1948  OG  SER A 333      45.453  44.901  24.738  1.00 42.24           O  
ATOM   1949  N   THR A 334      44.296  41.838  23.893  1.00 48.41           N  
ATOM   1950  CA  THR A 334      42.912  41.426  23.881  1.00 51.71           C  
ATOM   1951  C   THR A 334      42.665  40.081  23.165  1.00 55.42           C  
ATOM   1952  O   THR A 334      41.986  39.207  23.703  1.00 54.93           O  
ATOM   1953  CB  THR A 334      42.064  42.576  23.286  1.00 49.71           C  
ATOM   1954  OG1 THR A 334      40.921  42.797  24.117  1.00 49.52           O  
ATOM   1955  CG2 THR A 334      41.629  42.273  21.872  1.00 46.61           C  
ATOM   1956  N   GLY A 335      43.229  39.911  21.972  1.00 59.04           N  
ATOM   1957  CA  GLY A 335      43.051  38.670  21.242  1.00 63.57           C  
ATOM   1958  C   GLY A 335      41.723  38.517  20.517  1.00 67.51           C  
ATOM   1959  O   GLY A 335      41.097  39.502  20.112  1.00 67.74           O  
ATOM   1960  N   THR A 336      41.295  37.265  20.349  1.00 70.61           N  
ATOM   1961  CA  THR A 336      40.037  36.937  19.674  1.00 74.02           C  
ATOM   1962  C   THR A 336      38.961  36.537  20.673  1.00 76.64           C  
ATOM   1963  O   THR A 336      39.206  35.710  21.553  1.00 77.63           O  
ATOM   1964  CB  THR A 336      40.234  35.785  18.695  1.00 73.61           C  
ATOM   1965  OG1 THR A 336      41.221  36.155  17.724  1.00 73.21           O  
ATOM   1966  CG2 THR A 336      38.931  35.459  17.992  1.00 74.52           C  
ATOM   1967  N   PRO A 337      37.748  37.114  20.535  1.00 79.13           N  
ATOM   1968  CA  PRO A 337      36.581  36.878  21.391  1.00 82.03           C  
ATOM   1969  C   PRO A 337      36.498  35.530  22.136  1.00 85.48           C  
ATOM   1970  O   PRO A 337      36.541  35.496  23.365  1.00 86.05           O  
ATOM   1971  CB  PRO A 337      35.391  37.119  20.451  1.00 81.01           C  
ATOM   1972  CG  PRO A 337      35.982  37.914  19.256  1.00 79.51           C  
ATOM   1973  CD  PRO A 337      37.439  38.148  19.537  1.00 78.14           C  
ATOM   1974  N   PRO A 338      36.359  34.403  21.416  1.00 88.06           N  
ATOM   1975  CA  PRO A 338      36.253  34.180  19.975  1.00 90.23           C  
ATOM   1976  C   PRO A 338      34.838  33.712  19.653  1.00 92.43           C  
ATOM   1977  O   PRO A 338      33.859  34.344  20.029  1.00 92.52           O  
ATOM   1978  CB  PRO A 338      37.271  33.073  19.756  1.00 89.90           C  
ATOM   1979  CG  PRO A 338      36.880  32.167  20.907  1.00 89.16           C  
ATOM   1980  CD  PRO A 338      36.734  33.138  22.079  1.00 88.97           C  
ATOM   1981  N   ALA A 339      34.746  32.556  19.014  1.00 94.88           N  
ATOM   1982  CA  ALA A 339      33.452  31.998  18.649  1.00 96.74           C  
ATOM   1983  C   ALA A 339      33.032  30.911  19.648  1.00 98.16           C  
ATOM   1984  O   ALA A 339      33.876  30.187  20.192  1.00 98.58           O  
ATOM   1985  CB  ALA A 339      33.501  31.438  17.216  0.00 96.56           C  
ATOM   1986  N   ALA A 340      31.722  30.824  19.898  1.00 99.38           N  
ATOM   1987  CA  ALA A 340      31.140  29.851  20.833  1.00 99.87           C  
ATOM   1988  C   ALA A 340      31.291  28.414  20.348  1.00100.20           C  
ATOM   1989  O   ALA A 340      31.881  28.206  19.269  1.00100.28           O  
ATOM   1990  CB  ALA A 340      29.655  30.167  21.065  1.00 99.55           C  
ATOM   1991  OXT ALA A 340      30.828  27.496  21.055  1.00100.34           O  
TER    1992      ALA A 340                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
