
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  272 ( 2078),  selected  272 , name 3c3k_B
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 3c3k_B.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     7_B      -       -           -
LGA    T     8_B      -       -           -
LGA    G     9_B      Y      71          5.093
LGA    M    10_B      S      72          3.729
LGA    L    11_B      I      73          2.570
LGA    L    12_B      A      74          2.236
LGA    V    13_B      L      75          2.206
LGA    M    14_B      I      76          1.960
LGA    V    15_B      I      77          1.943
LGA    S    16_B      P      78          2.664
LGA    N    17_B      S      79          1.611
LGA    I    18_B      L      80          0.501
LGA    A    19_B      F      81          1.336
LGA    N    20_B      E      82          1.922
LGA    P    21_B      K      83          2.751
LGA    F    22_B      A      84          2.975
LGA    C    23_B      C      85          1.730
LGA    A    24_B      A      86          0.702
LGA    A    25_B      H      87          0.496
LGA    V    26_B      F      88          1.143
LGA    V    27_B      L      89          1.137
LGA    K    28_B      P      90          2.182
LGA    G    29_B      S      91          2.290
LGA    I    30_B      F      92          0.972
LGA    E    31_B      Q      93          1.280
LGA    K    32_B      Q      94          2.019
LGA    T    33_B      A      95          1.094
LGA    A    34_B      L      96          0.992
LGA    E    35_B      N      97          1.231
LGA    K    36_B      K      98          0.870
LGA    N    37_B      A      99          0.937
LGA    G    38_B      G     100          0.746
LGA    Y    39_B      Y     101          1.727
LGA    R    40_B      Q     102          2.808
LGA    I    41_B      L     103          2.361
LGA    L    42_B      L     104          3.174
LGA    L    43_B      L     105          3.078
LGA    C    44_B      G     106          2.168
LGA    N    45_B      Y     107          2.519
LGA    T    46_B      S     108          1.720
LGA    E    47_B      D     109          3.842
LGA    S    48_B      Y     110          2.913
LGA    D    49_B      S     111          0.703
LGA    L    50_B      I     112          1.573
LGA    A    51_B      E     113          2.011
LGA    R    52_B      Q     114          1.668
LGA    S    53_B      E     115          0.496
LGA    R    54_B      E     116          0.681
LGA    S    55_B      K     117          1.907
LGA    C    56_B      L     118          1.777
LGA    L    57_B      L     119          0.250
LGA    T    58_B      S     120          2.155
LGA    -       -      T     121           -
LGA    L    59_B      F     122          0.770
LGA    L    60_B      L     123          1.631
LGA    S    61_B      E     124          2.233
LGA    G    62_B      -       -           -
LGA    K    63_B      S     125          2.070
LGA    M    64_B      R     126          4.180
LGA    V    65_B      P     127           #
LGA    D    66_B      A     128          2.702
LGA    G    67_B      G     129          2.249
LGA    V    68_B      V     130          1.947
LGA    I    69_B      V     131          1.809
LGA    T    70_B      L     132          1.643
LGA    M    71_B      F     133          2.013
LGA    D    72_B      G     134          2.907
LGA    A    73_B      -       -           -
LGA    L    74_B      S     135          1.796
LGA    S    75_B      E     136          2.087
LGA    E    76_B      H     137          2.054
LGA    L    77_B      -       -           -
LGA    P    78_B      S     138           #
LGA    E    79_B      Q     139          3.782
LGA    -       -      R     140           -
LGA    L    80_B      T     141          2.522
LGA    Q    81_B      H     142          1.454
LGA    N    82_B      Q     143          0.869
LGA    I    83_B      L     144          1.868
LGA    I    84_B      L     145          0.843
LGA    G    85_B      E     146          1.063
LGA    -       -      A     147           -
LGA    -       -      S     148           -
LGA    A    86_B      N     149          2.318
LGA    F    87_B      T     150          1.811
LGA    P    88_B      P     151          1.955
LGA    W    89_B      V     152          1.062
LGA    V    90_B      L     153          0.621
LGA    Q    91_B      E     154          1.255
LGA    C    92_B      I     155          1.361
LGA    A    93_B      -       -           -
LGA    E    94_B      A     156          2.141
LGA    Y    95_B      E     157          1.042
LGA    D    96_B      L     158          1.597
LGA    P    97_B      -       -           -
LGA    L    98_B      S     159           #
LGA    S    99_B      S     160          4.153
LGA    -       -      K     161           -
LGA    -       -      A     162           -
LGA    T   100_B      S     163          3.288
LGA    V   101_B      Y     164          1.796
LGA    S   102_B      L     165          1.786
LGA    S   103_B      N     166          1.532
LGA    V   104_B      I     167          1.440
LGA    S   105_B      G     168          1.932
LGA    I   106_B      V     169          2.162
LGA    D   107_B      D     170          2.321
LGA    D   108_B      H     171          1.800
LGA    V   109_B      F     172          1.920
LGA    A   110_B      E     173          1.880
LGA    A   111_B      V     174          2.039
LGA    S   112_B      G     175          1.591
LGA    E   113_B      K     176          1.148
LGA    Y   114_B      A     177          1.176
LGA    V   115_B      C     178          0.993
LGA    V   116_B      T     179          1.232
LGA    D   117_B      R     180          0.944
LGA    Q   118_B      H     181          0.863
LGA    L   119_B      L     182          0.350
LGA    V   120_B      I     183          0.487
LGA    K   121_B      E     184          1.148
LGA    S   122_B      Q     185          1.098
LGA    G   123_B      G     186          0.819
LGA    K   124_B      F     187          0.821
LGA    K   125_B      K     188          1.398
LGA    R   126_B      N     189          1.074
LGA    I   127_B      V     190          0.668
LGA    A   128_B      G     191          1.076
LGA    L   129_B      F     192          1.177
LGA    I   130_B      I     193          1.182
LGA    N   131_B      G     194          1.828
LGA    H   132_B      A     195          1.340
LGA    D   133_B      R     196          2.118
LGA    L   134_B      G     197          3.109
LGA    A   135_B      N     198          3.861
LGA    Y   136_B      H     199          3.318
LGA    Q   137_B      S     200          3.039
LGA    Y   138_B      T     201          2.397
LGA    A   139_B      L     202          1.680
LGA    Q   140_B      Q     203          1.671
LGA    H   141_B      R     204          1.386
LGA    R   142_B      Q     205          0.949
LGA    E   143_B      L     206          1.052
LGA    S   144_B      H     207          1.032
LGA    G   145_B      G     208          1.232
LGA    Y   146_B      W     209          0.700
LGA    L   147_B      Q     210          0.715
LGA    N   148_B      S     211          1.474
LGA    R   149_B      A     212          1.386
LGA    L   150_B      M     213          0.332
LGA    K   151_B      I     214          0.557
LGA    F   152_B      E     215          0.383
LGA    H   153_B      N     216          0.447
LGA    G   154_B      Y     217          0.571
LGA    L   155_B      L     218          0.876
LGA    D   156_B      T     219          2.658
LGA    Y   157_B      P     220          4.701
LGA    S   158_B      D     221          2.730
LGA    R   159_B      H     222          1.438
LGA    I   160_B      F     223          1.277
LGA    S   161_B      L     224          0.706
LGA    Y   162_B      T     225          1.329
LGA    A   163_B      T     226          3.834
LGA    -       -      H     227           -
LGA    E   164_B      E     228          1.979
LGA    N   165_B      A     229          1.429
LGA    L   166_B      P     230          2.201
LGA    D   167_B      S     231          2.439
LGA    Y   168_B      S     232          2.183
LGA    M   169_B      Q     233          2.277
LGA    A   170_B      L     234          2.584
LGA    G   171_B      G     235          2.593
LGA    K   172_B      A     236          2.413
LGA    L   173_B      E     237          2.721
LGA    A   174_B      G     238          2.269
LGA    T   175_B      L     239          2.349
LGA    F   176_B      A     240          2.242
LGA    S   177_B      K     241          2.146
LGA    L   178_B      L     242          1.620
LGA    L   179_B      L     243          2.085
LGA    K   180_B      L     244          2.047
LGA    S   181_B      R     245          1.657
LGA    A   182_B      D     246          3.007
LGA    V   183_B      S     247          3.468
LGA    K   184_B      S     248          4.446
LGA    P   185_B      L     249          2.067
LGA    D   186_B      N     250          0.711
LGA    A   187_B      A     251          0.796
LGA    I   188_B      L     252          0.724
LGA    F   189_B      V     253          0.616
LGA    A   190_B      C     254          1.100
LGA    I   191_B      S     255          1.413
LGA    S   192_B      H     256          1.644
LGA    D   193_B      E     257          1.595
LGA    V   194_B      E     258          2.227
LGA    L   195_B      I     259          1.710
LGA    A   196_B      A     260          1.269
LGA    A   197_B      I     261          1.448
LGA    G   198_B      G     262          1.562
LGA    A   199_B      A     263          1.581
LGA    I   200_B      L     264          1.196
LGA    Q   201_B      F     265          1.752
LGA    A   202_B      E     266          1.878
LGA    L   203_B      C     267          1.933
LGA    T   204_B      H     268          1.592
LGA    E   205_B      R     269          1.536
LGA    S   206_B      R     270          1.906
LGA    G   207_B      V     271          1.482
LGA    L   208_B      L     272          1.064
LGA    S   209_B      K     273          1.033
LGA    I   210_B      V     274          0.914
LGA    P   211_B      P     275          0.880
LGA    Q   212_B      T     276          0.992
LGA    D   213_B      D     277          0.739
LGA    V   214_B      I     278          0.812
LGA    A   215_B      A     279          0.957
LGA    V   216_B      I     280          1.031
LGA    V   217_B      I     281          0.833
LGA    G   218_B      C     282          0.854
LGA    F   219_B      L     283          2.070
LGA    D   220_B      E     284          2.467
LGA    G   221_B      G     285          3.111
LGA    V   222_B      S     286          2.018
LGA    D   223_B      S     287          2.698
LGA    I   224_B      M     288          1.622
LGA    S   225_B      G     289          1.770
LGA    Q   226_B      E     290          2.154
LGA    I   227_B      H     291          3.150
LGA    T   228_B      A     292          1.911
LGA    V   229_B      Y     293          1.730
LGA    P   230_B      P     294          1.755
LGA    A   231_B      S     295          1.555
LGA    L   232_B      L     296          1.905
LGA    T   233_B      T     297          1.147
LGA    T   234_B      S     298          0.952
LGA    V   235_B      A     299          0.945
LGA    Q   236_B      E     300          0.984
LGA    Q   237_B      F     301          0.994
LGA    P   238_B      D     302          1.651
LGA    S   239_B      Y     303          1.126
LGA    E   240_B      E     304          0.898
LGA    Q   241_B      R     305          1.122
LGA    I   242_B      M     306          1.216
LGA    G   243_B      G     307          1.569
LGA    M   244_B      T     308          1.185
LGA    K   245_B      K     309          1.055
LGA    A   246_B      A     310          1.087
LGA    V   247_B      A     311          1.110
LGA    S   248_B      E     312          1.228
LGA    L   249_B      K     313          1.493
LGA    L   250_B      L     314          1.499
LGA    L   251_B      L     315          1.328
LGA    E   252_B      H     316          2.292
LGA    Q   253_B      A     317          2.393
LGA    I   254_B      I     318          2.175
LGA    H   255_B      K     319          2.197
LGA    S   256_B      -       -           -
LGA    D   257_B      -       -           -
LGA    V   258_B      E     321          1.534
LGA    L   259_B      P     322          5.498
LGA    A   260_B      E     323          3.791
LGA    K   261_B      -       -           -
LGA    T   262_B      -       -           -
LGA    V   263_B      E     324          4.938
LGA    H   264_B      P     326          4.450
LGA    H   265_B      T     327          1.396
LGA    L   266_B      S     328          1.773
LGA    L   267_B      M     329          0.665
LGA    P   268_B      G     330          2.526
LGA    W   269_B      F     331          1.020
LGA    K   270_B      K     332          0.932
LGA    F   271_B      L     333          0.761
LGA    V   272_B      K     334          0.848
LGA    R   273_B      R     335          0.704
LGA    R   274_B      R     336          1.127
LGA    Q   275_B      A     337          1.146
LGA    S   276_B      S     338          1.547
LGA    S   277_B      T     339          1.445
LGA    E   278_B      A     340          1.629
LGA    -       -      I     341           -
LGA    -       -      N     342           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  272  270    5.0    258    1.97    18.60     81.958    12.474

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.301285 * X  +  -0.644501 * Y  +  -0.702742 * Z  + 138.355240
  Y_new =  -0.023452 * X  +   0.741772 * Y  +  -0.670242 * Z  +  90.147354
  Z_new =   0.953246 * X  +  -0.185453 * Y  +  -0.238600 * Z  +  24.814243 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.480875    0.660717  [ DEG:  -142.1437     37.8563 ]
  Theta =  -1.263800   -1.877793  [ DEG:   -72.4104   -107.5896 ]
  Phi   =  -3.063908    0.077685  [ DEG:  -175.5490      4.4510 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3c3k_B                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3c3k_B.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  272  270   5.0  258   1.97   18.60  81.958
REMARK  ---------------------------------------------------------- 
MOLECULE 3c3k_B
HEADER    ISOMERASE                               28-JAN-08   3C3K              
TITLE     CRYSTAL STRUCTURE OF AN UNCHARACTERIZED PROTEIN FROM                  
TITLE    2 ACTINOBACILLUS SUCCINOGENES                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ALANINE RACEMASE;                                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 54-327;                                           
COMPND   5 EC: 5.1.1.1;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ACTINOBACILLUS SUCCINOGENES 130Z;               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 130Z;                                                        
SOURCE   5 GENE: ASUC_0357;                                                     
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)CODON+RIL;                        
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: BC-PSGX3(BC)                              
KEYWDS    STRUCTURAL GENOMICS, CRYSTAL STRUCTURE, PROTEIN STRUCTURE             
KEYWDS   2 INITIATIVE, NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM,         
KEYWDS   3 NYSGXRC, DNA-BINDING, ISOMERASE, TRANSCRIPTION,                      
KEYWDS   4 TRANSCRIPTION REGULATION, PSI-2                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.N.MALASHKEVICH,R.TORO,A.J.MEYER,J.M.SAUDER,S.K.BURLEY,              
AUTHOR   2 S.C.ALMO,NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM             
AUTHOR   3 (NYSGXRC)                                                            
REVDAT   1   05-FEB-08 3C3K    0                                                
JRNL        AUTH   V.N.MALASHKEVICH,R.TORO,A.J.MEYER,J.M.SAUDER,                
JRNL        AUTH 2 S.K.BURLEY,S.C.ALMO                                          
JRNL        TITL   CRYSTAL STRUCTURE OF AN UNCHARACTERIZED PROTEIN              
JRNL        TITL 2 FROM ACTINOBACILLUS SUCCINOGENES.                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.99 ANGSTROMS.                                          
DBREF  3C3K A    4   277  UNP    A6VL88   A6VL88_ACTSC    54    327             
DBREF  3C3K B    4   277  UNP    A6VL88   A6VL88_ACTSC    54    327             
SEQRES   1 A  285  MET SER LEU ARG THR ALA LYS THR GLY MET LEU LEU VAL          
SEQRES   2 A  285  MET VAL SER ASN ILE ALA ASN PRO PHE CYS ALA ALA VAL          
SEQRES   3 A  285  VAL LYS GLY ILE GLU LYS THR ALA GLU LYS ASN GLY TYR          
SEQRES   4 A  285  ARG ILE LEU LEU CYS ASN THR GLU SER ASP LEU ALA ARG          
SEQRES   5 A  285  SER ARG SER CYS LEU THR LEU LEU SER GLY LYS MET VAL          
SEQRES   6 A  285  ASP GLY VAL ILE THR MET ASP ALA LEU SER GLU LEU PRO          
SEQRES   7 A  285  GLU LEU GLN ASN ILE ILE GLY ALA PHE PRO TRP VAL GLN          
SEQRES   8 A  285  CYS ALA GLU TYR ASP PRO LEU SER THR VAL SER SER VAL          
SEQRES   9 A  285  SER ILE ASP ASP VAL ALA ALA SER GLU TYR VAL VAL ASP          
SEQRES  10 A  285  GLN LEU VAL LYS SER GLY LYS LYS ARG ILE ALA LEU ILE          
SEQRES  11 A  285  ASN HIS ASP LEU ALA TYR GLN TYR ALA GLN HIS ARG GLU          
SEQRES  12 A  285  SER GLY TYR LEU ASN ARG LEU LYS PHE HIS GLY LEU ASP          
SEQRES  13 A  285  TYR SER ARG ILE SER TYR ALA GLU ASN LEU ASP TYR MET          
SEQRES  14 A  285  ALA GLY LYS LEU ALA THR PHE SER LEU LEU LYS SER ALA          
SEQRES  15 A  285  VAL LYS PRO ASP ALA ILE PHE ALA ILE SER ASP VAL LEU          
SEQRES  16 A  285  ALA ALA GLY ALA ILE GLN ALA LEU THR GLU SER GLY LEU          
SEQRES  17 A  285  SER ILE PRO GLN ASP VAL ALA VAL VAL GLY PHE ASP GLY          
SEQRES  18 A  285  VAL ASP ILE SER GLN ILE THR VAL PRO ALA LEU THR THR          
SEQRES  19 A  285  VAL GLN GLN PRO SER GLU GLN ILE GLY MET LYS ALA VAL          
SEQRES  20 A  285  SER LEU LEU LEU GLU GLN ILE HIS SER ASP VAL LEU ALA          
SEQRES  21 A  285  LYS THR VAL HIS HIS LEU LEU PRO TRP LYS PHE VAL ARG          
SEQRES  22 A  285  ARG GLN SER SER GLU GLY HIS HIS HIS HIS HIS HIS              
SEQRES   1 B  285  MET SER LEU ARG THR ALA LYS THR GLY MET LEU LEU VAL          
SEQRES   2 B  285  MET VAL SER ASN ILE ALA ASN PRO PHE CYS ALA ALA VAL          
SEQRES   3 B  285  VAL LYS GLY ILE GLU LYS THR ALA GLU LYS ASN GLY TYR          
SEQRES   4 B  285  ARG ILE LEU LEU CYS ASN THR GLU SER ASP LEU ALA ARG          
SEQRES   5 B  285  SER ARG SER CYS LEU THR LEU LEU SER GLY LYS MET VAL          
SEQRES   6 B  285  ASP GLY VAL ILE THR MET ASP ALA LEU SER GLU LEU PRO          
SEQRES   7 B  285  GLU LEU GLN ASN ILE ILE GLY ALA PHE PRO TRP VAL GLN          
SEQRES   8 B  285  CYS ALA GLU TYR ASP PRO LEU SER THR VAL SER SER VAL          
SEQRES   9 B  285  SER ILE ASP ASP VAL ALA ALA SER GLU TYR VAL VAL ASP          
SEQRES  10 B  285  GLN LEU VAL LYS SER GLY LYS LYS ARG ILE ALA LEU ILE          
SEQRES  11 B  285  ASN HIS ASP LEU ALA TYR GLN TYR ALA GLN HIS ARG GLU          
SEQRES  12 B  285  SER GLY TYR LEU ASN ARG LEU LYS PHE HIS GLY LEU ASP          
SEQRES  13 B  285  TYR SER ARG ILE SER TYR ALA GLU ASN LEU ASP TYR MET          
SEQRES  14 B  285  ALA GLY LYS LEU ALA THR PHE SER LEU LEU LYS SER ALA          
SEQRES  15 B  285  VAL LYS PRO ASP ALA ILE PHE ALA ILE SER ASP VAL LEU          
SEQRES  16 B  285  ALA ALA GLY ALA ILE GLN ALA LEU THR GLU SER GLY LEU          
SEQRES  17 B  285  SER ILE PRO GLN ASP VAL ALA VAL VAL GLY PHE ASP GLY          
SEQRES  18 B  285  VAL ASP ILE SER GLN ILE THR VAL PRO ALA LEU THR THR          
SEQRES  19 B  285  VAL GLN GLN PRO SER GLU GLN ILE GLY MET LYS ALA VAL          
SEQRES  20 B  285  SER LEU LEU LEU GLU GLN ILE HIS SER ASP VAL LEU ALA          
SEQRES  21 B  285  LYS THR VAL HIS HIS LEU LEU PRO TRP LYS PHE VAL ARG          
SEQRES  22 B  285  ARG GLN SER SER GLU GLY HIS HIS HIS HIS HIS HIS              
HET     CL  B 301       1                                                       
HET    GOL  A 302       6                                                       
HET    GOL  B 303       6                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM     GOL GLYCEROL                                                         
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  GOL    2(C3 H8 O3)                                                  
FORMUL   6  HOH   *253(H2 O)                                                    
CRYST1   34.888   67.602  204.802  90.00  90.00  90.00 P 21 21 21    8          
ATOM   2044  N   LYS B   7      55.415  89.280   8.636  1.00 44.83           N  
ATOM   2045  CA  LYS B   7      54.692  88.700   7.462  1.00 45.33           C  
ATOM   2046  C   LYS B   7      54.197  87.282   7.817  1.00 44.16           C  
ATOM   2047  O   LYS B   7      53.067  86.917   7.516  1.00 44.84           O  
ATOM   2048  CB  LYS B   7      55.598  88.672   6.218  1.00 45.00           C  
ATOM   2049  CG  LYS B   7      54.838  88.731   4.884  1.00 46.79           C  
ATOM   2050  CD  LYS B   7      55.758  88.417   3.707  1.00 46.93           C  
ATOM   2051  CE  LYS B   7      56.867  89.469   3.537  1.00 50.41           C  
ATOM   2052  NZ  LYS B   7      56.337  90.887   3.486  1.00 49.98           N  
ATOM   2053  N   THR B   8      55.060  86.490   8.446  1.00 42.59           N  
ATOM   2054  CA  THR B   8      54.683  85.182   8.998  1.00 40.01           C  
ATOM   2055  C   THR B   8      53.939  85.385  10.316  1.00 37.04           C  
ATOM   2056  O   THR B   8      54.428  86.065  11.238  1.00 37.62           O  
ATOM   2057  CB  THR B   8      55.924  84.227   9.177  1.00 40.87           C  
ATOM   2058  OG1 THR B   8      55.872  83.570  10.456  1.00 42.18           O  
ATOM   2059  CG2 THR B   8      57.245  84.988   9.055  1.00 41.97           C  
ATOM   2060  N   GLY B   9      52.739  84.828  10.401  1.00 33.39           N  
ATOM   2061  CA  GLY B   9      51.964  84.957  11.625  1.00 27.37           C  
ATOM   2062  C   GLY B   9      52.279  83.869  12.623  1.00 24.13           C  
ATOM   2063  O   GLY B   9      53.095  83.019  12.366  1.00 21.38           O  
ATOM   2064  N   MET B  10      51.597  83.905  13.761  1.00 21.39           N  
ATOM   2065  CA  MET B  10      51.624  82.799  14.690  1.00 19.60           C  
ATOM   2066  C   MET B  10      50.183  82.458  15.082  1.00 17.59           C  
ATOM   2067  O   MET B  10      49.269  83.327  15.145  1.00 14.64           O  
ATOM   2068  CB  MET B  10      52.477  83.099  15.958  1.00 19.45           C  
ATOM   2069  CG  MET B  10      54.029  83.159  15.725  1.00 22.91           C  
ATOM   2070  SD  MET B  10      55.100  83.232  17.216  1.00 21.65           S  
ATOM   2071  CE  MET B  10      54.884  84.910  17.731  1.00 19.17           C  
ATOM   2072  N   LEU B  11      50.002  81.178  15.369  1.00 15.76           N  
ATOM   2073  CA  LEU B  11      48.778  80.666  15.970  1.00 14.14           C  
ATOM   2074  C   LEU B  11      49.067  80.116  17.374  1.00 14.54           C  
ATOM   2075  O   LEU B  11      50.147  79.526  17.603  1.00 15.61           O  
ATOM   2076  CB  LEU B  11      48.232  79.574  15.088  1.00 13.23           C  
ATOM   2077  CG  LEU B  11      48.178  79.820  13.578  1.00 15.88           C  
ATOM   2078  CD1 LEU B  11      47.669  78.572  12.951  1.00 15.56           C  
ATOM   2079  CD2 LEU B  11      47.226  81.020  13.282  1.00 18.78           C  
ATOM   2080  N   LEU B  12      48.145  80.354  18.290  1.00 13.49           N  
ATOM   2081  CA  LEU B  12      48.169  79.792  19.642  1.00 13.66           C  
ATOM   2082  C   LEU B  12      47.456  78.425  19.719  1.00 13.90           C  
ATOM   2083  O   LEU B  12      46.260  78.305  19.381  1.00 13.21           O  
ATOM   2084  CB  LEU B  12      47.528  80.776  20.649  1.00 13.86           C  
ATOM   2085  CG  LEU B  12      47.364  80.310  22.107  1.00 13.67           C  
ATOM   2086  CD1 LEU B  12      48.734  79.996  22.766  1.00 14.62           C  
ATOM   2087  CD2 LEU B  12      46.711  81.363  22.894  1.00 16.46           C  
ATOM   2088  N   VAL B  13      48.175  77.390  20.178  1.00 14.07           N  
ATOM   2089  CA  VAL B  13      47.506  76.146  20.569  1.00 13.78           C  
ATOM   2090  C   VAL B  13      47.459  76.003  22.084  1.00 14.27           C  
ATOM   2091  O   VAL B  13      48.490  76.049  22.735  1.00 14.92           O  
ATOM   2092  CB  VAL B  13      48.193  74.934  19.932  1.00 15.03           C  
ATOM   2093  CG1 VAL B  13      47.378  73.658  20.131  1.00 14.17           C  
ATOM   2094  CG2 VAL B  13      48.446  75.196  18.419  1.00 10.89           C  
ATOM   2095  N   MET B  14      46.259  75.819  22.634  1.00 13.39           N  
ATOM   2096  CA  MET B  14      46.053  75.572  24.057  1.00 12.29           C  
ATOM   2097  C   MET B  14      45.905  74.077  24.217  1.00 13.15           C  
ATOM   2098  O   MET B  14      44.862  73.510  23.883  1.00 13.27           O  
ATOM   2099  CB  MET B  14      44.794  76.317  24.537  1.00 12.00           C  
ATOM   2100  CG  MET B  14      45.016  77.844  24.838  1.00 12.76           C  
ATOM   2101  SD  MET B  14      43.527  78.904  25.213  1.00 11.88           S  
ATOM   2102  CE  MET B  14      42.374  78.009  24.456  1.00 19.12           C  
ATOM   2103  N   VAL B  15      46.945  73.441  24.743  1.00 13.62           N  
ATOM   2104  CA  VAL B  15      47.076  71.992  24.812  1.00 14.91           C  
ATOM   2105  C   VAL B  15      46.537  71.465  26.145  1.00 16.13           C  
ATOM   2106  O   VAL B  15      46.794  72.058  27.214  1.00 13.59           O  
ATOM   2107  CB  VAL B  15      48.567  71.661  24.694  1.00 16.24           C  
ATOM   2108  CG1 VAL B  15      48.846  70.191  24.863  1.00 16.80           C  
ATOM   2109  CG2 VAL B  15      49.025  72.087  23.298  1.00 18.44           C  
ATOM   2110  N   SER B  16      45.777  70.373  26.093  1.00 15.05           N  
ATOM   2111  CA  SER B  16      45.249  69.822  27.334  1.00 16.23           C  
ATOM   2112  C   SER B  16      46.320  69.141  28.200  1.00 15.71           C  
ATOM   2113  O   SER B  16      46.280  69.225  29.403  1.00 16.17           O  
ATOM   2114  CB  SER B  16      44.094  68.865  27.021  1.00 15.28           C  
ATOM   2115  OG  SER B  16      44.565  67.919  26.107  1.00 15.78           O  
ATOM   2116  N   ASN B  17      47.289  68.475  27.608  1.00 16.26           N  
ATOM   2117  CA  ASN B  17      48.422  67.941  28.413  1.00 16.99           C  
ATOM   2118  C   ASN B  17      49.577  67.610  27.496  1.00 16.69           C  
ATOM   2119  O   ASN B  17      49.534  66.704  26.676  1.00 17.46           O  
ATOM   2120  CB  ASN B  17      47.982  66.676  29.223  1.00 15.64           C  
ATOM   2121  CG  ASN B  17      49.079  66.118  30.116  1.00 21.68           C  
ATOM   2122  OD1 ASN B  17      50.257  66.404  29.937  1.00 18.83           O  
ATOM   2123  ND2 ASN B  17      48.681  65.275  31.084  1.00 25.24           N  
ATOM   2124  N   ILE B  18      50.626  68.356  27.647  1.00 16.73           N  
ATOM   2125  CA  ILE B  18      51.742  68.266  26.762  1.00 16.90           C  
ATOM   2126  C   ILE B  18      52.458  66.891  26.893  1.00 16.69           C  
ATOM   2127  O   ILE B  18      53.145  66.457  25.955  1.00 16.45           O  
ATOM   2128  CB  ILE B  18      52.660  69.503  26.993  1.00 18.01           C  
ATOM   2129  CG1 ILE B  18      53.237  69.950  25.654  1.00 23.90           C  
ATOM   2130  CG2 ILE B  18      53.618  69.327  28.245  1.00 17.02           C  
ATOM   2131  CD1 ILE B  18      54.312  70.976  25.791  1.00 30.28           C  
ATOM   2132  N   ALA B  19      52.270  66.207  28.015  1.00 15.04           N  
ATOM   2133  CA  ALA B  19      52.771  64.850  28.189  1.00 14.96           C  
ATOM   2134  C   ALA B  19      51.902  63.740  27.627  1.00 14.33           C  
ATOM   2135  O   ALA B  19      52.360  62.602  27.547  1.00 14.90           O  
ATOM   2136  CB  ALA B  19      53.154  64.514  29.630  1.00 14.36           C  
ATOM   2137  N   ASN B  20      50.697  64.076  27.184  1.00 13.90           N  
ATOM   2138  CA  ASN B  20      49.807  63.115  26.526  1.00 14.04           C  
ATOM   2139  C   ASN B  20      50.225  62.927  25.071  1.00 12.22           C  
ATOM   2140  O   ASN B  20      50.205  63.856  24.305  1.00 12.94           O  
ATOM   2141  CB  ASN B  20      48.393  63.636  26.609  1.00 12.65           C  
ATOM   2142  CG  ASN B  20      47.379  62.656  26.081  1.00 16.11           C  
ATOM   2143  OD1 ASN B  20      47.723  61.561  25.648  1.00 12.52           O  
ATOM   2144  ND2 ASN B  20      46.096  63.046  26.140  1.00 12.50           N  
ATOM   2145  N   PRO B  21      50.673  61.720  24.684  1.00 13.28           N  
ATOM   2146  CA  PRO B  21      51.127  61.551  23.297  1.00 13.16           C  
ATOM   2147  C   PRO B  21      50.026  61.880  22.248  1.00 12.64           C  
ATOM   2148  O   PRO B  21      50.336  62.067  21.079  1.00 13.23           O  
ATOM   2149  CB  PRO B  21      51.509  60.057  23.244  1.00 14.05           C  
ATOM   2150  CG  PRO B  21      50.741  59.466  24.520  1.00 14.82           C  
ATOM   2151  CD  PRO B  21      50.805  60.495  25.482  1.00 12.97           C  
ATOM   2152  N   PHE B  22      48.752  61.870  22.632  1.00 12.94           N  
ATOM   2153  CA  PHE B  22      47.684  62.268  21.700  1.00 13.60           C  
ATOM   2154  C   PHE B  22      47.847  63.757  21.379  1.00 14.22           C  
ATOM   2155  O   PHE B  22      47.735  64.197  20.224  1.00 13.24           O  
ATOM   2156  CB  PHE B  22      46.301  62.043  22.359  1.00 15.59           C  
ATOM   2157  CG  PHE B  22      45.123  62.666  21.589  1.00 14.04           C  
ATOM   2158  CD1 PHE B  22      44.573  62.000  20.506  1.00 16.10           C  
ATOM   2159  CD2 PHE B  22      44.603  63.887  21.957  1.00 13.47           C  
ATOM   2160  CE1 PHE B  22      43.497  62.534  19.818  1.00 17.02           C  
ATOM   2161  CE2 PHE B  22      43.536  64.434  21.275  1.00 15.00           C  
ATOM   2162  CZ  PHE B  22      42.983  63.754  20.207  1.00 15.03           C  
ATOM   2163  N   CYS B  23      48.122  64.561  22.410  1.00 14.16           N  
ATOM   2164  CA  CYS B  23      48.377  65.981  22.118  1.00 14.56           C  
ATOM   2165  C   CYS B  23      49.499  66.164  21.149  1.00 14.46           C  
ATOM   2166  O   CYS B  23      49.373  66.974  20.280  1.00 17.37           O  
ATOM   2167  CB  CYS B  23      48.659  66.765  23.358  1.00 16.42           C  
ATOM   2168  SG  CYS B  23      47.199  66.721  24.436  1.00 17.34           S  
ATOM   2169  N   ALA B  24      50.621  65.452  21.320  1.00 14.66           N  
ATOM   2170  CA  ALA B  24      51.771  65.624  20.473  1.00 13.44           C  
ATOM   2171  C   ALA B  24      51.420  65.300  19.047  1.00 11.95           C  
ATOM   2172  O   ALA B  24      51.927  65.927  18.124  1.00 13.03           O  
ATOM   2173  CB  ALA B  24      52.983  64.738  20.975  1.00 14.61           C  
ATOM   2174  N   ALA B  25      50.598  64.287  18.845  1.00 10.00           N  
ATOM   2175  CA  ALA B  25      50.149  63.890  17.524  1.00 10.70           C  
ATOM   2176  C   ALA B  25      49.232  64.934  16.937  1.00 11.99           C  
ATOM   2177  O   ALA B  25      49.330  65.227  15.765  1.00 11.97           O  
ATOM   2178  CB  ALA B  25      49.412  62.510  17.533  1.00 11.93           C  
ATOM   2179  N   VAL B  26      48.326  65.504  17.733  1.00 12.15           N  
ATOM   2180  CA  VAL B  26      47.485  66.585  17.177  1.00 12.56           C  
ATOM   2181  C   VAL B  26      48.353  67.829  16.846  1.00 14.44           C  
ATOM   2182  O   VAL B  26      48.262  68.421  15.754  1.00 15.46           O  
ATOM   2183  CB  VAL B  26      46.352  66.979  18.131  1.00 11.31           C  
ATOM   2184  CG1 VAL B  26      45.569  68.146  17.493  1.00 10.94           C  
ATOM   2185  CG2 VAL B  26      45.404  65.759  18.371  1.00 13.25           C  
ATOM   2186  N   VAL B  27      49.253  68.206  17.762  1.00 14.55           N  
ATOM   2187  CA  VAL B  27      50.185  69.278  17.441  1.00 12.75           C  
ATOM   2188  C   VAL B  27      50.970  69.086  16.158  1.00 14.16           C  
ATOM   2189  O   VAL B  27      51.159  70.034  15.387  1.00 12.00           O  
ATOM   2190  CB  VAL B  27      51.075  69.582  18.587  1.00 13.95           C  
ATOM   2191  CG1 VAL B  27      52.102  70.612  18.204  1.00 13.27           C  
ATOM   2192  CG2 VAL B  27      50.216  70.092  19.727  1.00 13.21           C  
ATOM   2193  N   LYS B  28      51.455  67.876  15.928  1.00 15.30           N  
ATOM   2194  CA  LYS B  28      52.142  67.600  14.723  1.00 18.02           C  
ATOM   2195  C   LYS B  28      51.336  67.979  13.459  1.00 17.43           C  
ATOM   2196  O   LYS B  28      51.885  68.545  12.504  1.00 17.88           O  
ATOM   2197  CB  LYS B  28      52.551  66.110  14.659  1.00 19.16           C  
ATOM   2198  CG  LYS B  28      53.542  65.846  13.509  1.00 20.54           C  
ATOM   2199  CD  LYS B  28      53.995  64.355  13.427  1.00 23.64           C  
ATOM   2200  CE  LYS B  28      54.835  64.054  12.131  1.00 28.62           C  
ATOM   2201  NZ  LYS B  28      55.746  65.213  11.858  1.00 30.98           N  
ATOM   2202  N   GLY B  29      50.052  67.626  13.430  1.00 16.04           N  
ATOM   2203  CA  GLY B  29      49.205  67.915  12.283  1.00 15.20           C  
ATOM   2204  C   GLY B  29      48.924  69.409  12.219  1.00 14.15           C  
ATOM   2205  O   GLY B  29      48.904  70.010  11.143  1.00 14.48           O  
ATOM   2206  N   ILE B  30      48.732  70.028  13.379  1.00 13.66           N  
ATOM   2207  CA  ILE B  30      48.567  71.464  13.397  1.00 13.02           C  
ATOM   2208  C   ILE B  30      49.759  72.113  12.663  1.00 14.67           C  
ATOM   2209  O   ILE B  30      49.541  72.916  11.724  1.00 13.05           O  
ATOM   2210  CB  ILE B  30      48.377  72.013  14.838  1.00 13.48           C  
ATOM   2211  CG1 ILE B  30      46.968  71.670  15.300  1.00  9.59           C  
ATOM   2212  CG2 ILE B  30      48.579  73.482  14.899  1.00 11.56           C  
ATOM   2213  CD1 ILE B  30      46.723  71.840  16.826  1.00 14.27           C  
ATOM   2214  N   GLU B  31      50.996  71.758  13.065  1.00 14.57           N  
ATOM   2215  CA  GLU B  31      52.210  72.372  12.540  1.00 14.80           C  
ATOM   2216  C   GLU B  31      52.328  72.140  11.048  1.00 15.42           C  
ATOM   2217  O   GLU B  31      52.735  73.017  10.312  1.00 15.62           O  
ATOM   2218  CB  GLU B  31      53.441  71.748  13.174  1.00 15.26           C  
ATOM   2219  CG  GLU B  31      53.638  72.027  14.629  1.00 15.08           C  
ATOM   2220  CD  GLU B  31      54.731  71.134  15.263  1.00 19.32           C  
ATOM   2221  OE1 GLU B  31      54.962  69.964  14.813  1.00 22.87           O  
ATOM   2222  OE2 GLU B  31      55.360  71.644  16.203  1.00 21.79           O  
ATOM   2223  N   LYS B  32      51.953  70.960  10.594  1.00 16.10           N  
ATOM   2224  CA  LYS B  32      52.111  70.654   9.173  1.00 17.63           C  
ATOM   2225  C   LYS B  32      51.268  71.590   8.360  1.00 16.47           C  
ATOM   2226  O   LYS B  32      51.766  72.161   7.440  1.00 16.25           O  
ATOM   2227  CB  LYS B  32      51.706  69.236   8.859  1.00 17.32           C  
ATOM   2228  CG  LYS B  32      52.867  68.249   9.024  1.00 24.12           C  
ATOM   2229  CD  LYS B  32      52.296  66.860   8.932  1.00 30.45           C  
ATOM   2230  CE  LYS B  32      51.573  66.749   7.570  1.00 33.61           C  
ATOM   2231  NZ  LYS B  32      51.298  65.321   7.226  1.00 39.26           N  
ATOM   2232  N   THR B  33      49.993  71.734   8.708  1.00 16.94           N  
ATOM   2233  CA  THR B  33      49.119  72.633   7.940  1.00 16.28           C  
ATOM   2234  C   THR B  33      49.445  74.079   8.130  1.00 15.55           C  
ATOM   2235  O   THR B  33      49.454  74.807   7.153  1.00 14.59           O  
ATOM   2236  CB  THR B  33      47.643  72.287   8.064  1.00 16.76           C  
ATOM   2237  OG1 THR B  33      47.497  70.933   7.593  1.00 18.83           O  
ATOM   2238  CG2 THR B  33      46.774  73.199   7.188  1.00 17.16           C  
ATOM   2239  N   ALA B  34      49.729  74.499   9.368  1.00 15.21           N  
ATOM   2240  CA  ALA B  34      50.022  75.912   9.648  1.00 14.95           C  
ATOM   2241  C   ALA B  34      51.254  76.368   8.879  1.00 15.32           C  
ATOM   2242  O   ALA B  34      51.212  77.429   8.262  1.00 15.75           O  
ATOM   2243  CB  ALA B  34      50.154  76.177  11.184  1.00 13.53           C  
ATOM   2244  N   GLU B  35      52.318  75.547   8.808  1.00 15.17           N  
ATOM   2245  CA  GLU B  35      53.569  76.037   8.281  1.00 16.81           C  
ATOM   2246  C   GLU B  35      53.589  76.071   6.741  1.00 17.43           C  
ATOM   2247  O   GLU B  35      54.487  76.692   6.165  1.00 18.52           O  
ATOM   2248  CB  GLU B  35      54.758  75.243   8.812  1.00 17.54           C  
ATOM   2249  CG  GLU B  35      54.839  75.258  10.340  1.00 19.45           C  
ATOM   2250  CD  GLU B  35      56.197  74.849  10.928  1.00 18.67           C  
ATOM   2251  OE1 GLU B  35      56.724  73.788  10.562  1.00 20.74           O  
ATOM   2252  OE2 GLU B  35      56.704  75.558  11.814  1.00 20.01           O  
ATOM   2253  N   LYS B  36      52.601  75.445   6.096  1.00 17.38           N  
ATOM   2254  CA  LYS B  36      52.367  75.580   4.634  1.00 18.71           C  
ATOM   2255  C   LYS B  36      51.584  76.822   4.279  1.00 19.00           C  
ATOM   2256  O   LYS B  36      51.453  77.177   3.085  1.00 19.82           O  
ATOM   2257  CB  LYS B  36      51.523  74.425   4.094  1.00 18.35           C  
ATOM   2258  CG  LYS B  36      52.279  73.107   4.027  1.00 20.69           C  
ATOM   2259  CD  LYS B  36      53.452  73.091   2.974  1.00 16.88           C  
ATOM   2260  CE  LYS B  36      54.104  71.705   2.913  1.00 19.94           C  
ATOM   2261  NZ  LYS B  36      55.331  71.882   2.061  1.00 30.69           N  
ATOM   2262  N   ASN B  37      51.021  77.441   5.304  1.00 17.93           N  
ATOM   2263  CA  ASN B  37      50.179  78.598   5.150  1.00 17.92           C  
ATOM   2264  C   ASN B  37      50.734  79.845   5.763  1.00 18.13           C  
ATOM   2265  O   ASN B  37      49.971  80.788   5.970  1.00 18.91           O  
ATOM   2266  CB  ASN B  37      48.816  78.284   5.708  1.00 17.74           C  
ATOM   2267  CG  ASN B  37      48.036  77.392   4.782  1.00 18.79           C  
ATOM   2268  OD1 ASN B  37      47.472  77.867   3.808  1.00 24.74           O  
ATOM   2269  ND2 ASN B  37      47.999  76.103   5.062  1.00 20.12           N  
ATOM   2270  N   GLY B  38      52.032  79.842   6.093  1.00 16.63           N  
ATOM   2271  CA  GLY B  38      52.708  81.052   6.536  1.00 18.39           C  
ATOM   2272  C   GLY B  38      52.540  81.287   8.028  1.00 18.79           C  
ATOM   2273  O   GLY B  38      52.623  82.427   8.524  1.00 20.71           O  
ATOM   2274  N   TYR B  39      52.306  80.229   8.770  1.00 18.10           N  
ATOM   2275  CA  TYR B  39      52.188  80.389  10.225  1.00 16.93           C  
ATOM   2276  C   TYR B  39      53.156  79.502  10.938  1.00 17.31           C  
ATOM   2277  O   TYR B  39      53.425  78.413  10.471  1.00 16.18           O  
ATOM   2278  CB  TYR B  39      50.770  80.049  10.667  1.00 16.84           C  
ATOM   2279  CG  TYR B  39      49.780  81.104  10.274  1.00 16.33           C  
ATOM   2280  CD1 TYR B  39      49.538  82.204  11.106  1.00 18.12           C  
ATOM   2281  CD2 TYR B  39      49.048  80.997   9.104  1.00 19.63           C  
ATOM   2282  CE1 TYR B  39      48.663  83.199  10.746  1.00 15.98           C  
ATOM   2283  CE2 TYR B  39      48.162  82.005   8.735  1.00 19.96           C  
ATOM   2284  CZ  TYR B  39      47.966  83.085   9.592  1.00 19.76           C  
ATOM   2285  OH  TYR B  39      47.079  84.073   9.269  1.00 21.37           O  
ATOM   2286  N   ARG B  40      53.657  79.987  12.075  1.00 17.61           N  
ATOM   2287  CA  ARG B  40      54.307  79.170  13.082  1.00 18.02           C  
ATOM   2288  C   ARG B  40      53.430  79.082  14.349  1.00 17.53           C  
ATOM   2289  O   ARG B  40      52.448  79.816  14.505  1.00 18.38           O  
ATOM   2290  CB  ARG B  40      55.681  79.773  13.460  1.00 19.12           C  
ATOM   2291  CG  ARG B  40      56.550  80.152  12.273  1.00 20.54           C  
ATOM   2292  CD  ARG B  40      57.003  78.878  11.602  1.00 24.38           C  
ATOM   2293  NE  ARG B  40      57.917  79.136  10.506  1.00 21.96           N  
ATOM   2294  CZ  ARG B  40      58.634  78.212   9.880  1.00 21.89           C  
ATOM   2295  NH1 ARG B  40      58.531  76.920  10.187  1.00 22.12           N  
ATOM   2296  NH2 ARG B  40      59.405  78.594   8.882  1.00 20.99           N  
ATOM   2297  N   ILE B  41      53.801  78.196  15.255  1.00 15.63           N  
ATOM   2298  CA  ILE B  41      52.884  77.755  16.284  1.00 15.75           C  
ATOM   2299  C   ILE B  41      53.428  78.079  17.670  1.00 14.66           C  
ATOM   2300  O   ILE B  41      54.575  77.780  17.969  1.00 14.82           O  
ATOM   2301  CB  ILE B  41      52.688  76.206  16.129  1.00 16.43           C  
ATOM   2302  CG1 ILE B  41      52.024  75.850  14.760  1.00 18.23           C  
ATOM   2303  CG2 ILE B  41      51.923  75.619  17.263  1.00 15.22           C  
ATOM   2304  CD1 ILE B  41      50.639  76.446  14.609  1.00 15.77           C  
ATOM   2305  N   LEU B  42      52.617  78.695  18.525  1.00 15.24           N  
ATOM   2306  CA  LEU B  42      53.009  78.817  19.925  1.00 13.95           C  
ATOM   2307  C   LEU B  42      52.103  77.915  20.737  1.00 14.23           C  
ATOM   2308  O   LEU B  42      50.866  77.869  20.484  1.00 14.90           O  
ATOM   2309  CB  LEU B  42      52.886  80.233  20.414  1.00 13.92           C  
ATOM   2310  CG  LEU B  42      53.945  81.278  20.118  1.00 17.91           C  
ATOM   2311  CD1 LEU B  42      53.425  82.580  20.696  1.00 21.02           C  
ATOM   2312  CD2 LEU B  42      55.307  80.909  20.692  1.00 17.31           C  
ATOM   2313  N   LEU B  43      52.664  77.189  21.696  1.00 12.38           N  
ATOM   2314  CA  LEU B  43      51.865  76.300  22.549  1.00 14.65           C  
ATOM   2315  C   LEU B  43      51.675  76.849  23.952  1.00 14.52           C  
ATOM   2316  O   LEU B  43      52.518  77.546  24.473  1.00 15.25           O  
ATOM   2317  CB  LEU B  43      52.550  74.925  22.706  1.00 15.34           C  
ATOM   2318  CG  LEU B  43      52.894  74.180  21.443  1.00 16.11           C  
ATOM   2319  CD1 LEU B  43      53.655  72.956  21.898  1.00 13.81           C  
ATOM   2320  CD2 LEU B  43      51.611  73.784  20.640  1.00 15.20           C  
ATOM   2321  N   CYS B  44      50.592  76.480  24.596  1.00 16.18           N  
ATOM   2322  CA  CYS B  44      50.470  76.735  26.031  1.00 14.33           C  
ATOM   2323  C   CYS B  44      49.909  75.472  26.625  1.00 14.76           C  
ATOM   2324  O   CYS B  44      48.920  74.918  26.100  1.00 11.63           O  
ATOM   2325  CB  CYS B  44      49.521  77.865  26.318  1.00 14.63           C  
ATOM   2326  SG  CYS B  44      49.467  78.186  28.131  1.00 20.39           S  
ATOM   2327  N   ASN B  45      50.564  74.982  27.667  1.00 14.27           N  
ATOM   2328  CA  ASN B  45      50.137  73.762  28.317  1.00 15.14           C  
ATOM   2329  C   ASN B  45      49.151  74.172  29.366  1.00 14.94           C  
ATOM   2330  O   ASN B  45      49.487  74.308  30.555  1.00 14.56           O  
ATOM   2331  CB  ASN B  45      51.320  73.006  28.964  1.00 14.85           C  
ATOM   2332  CG  ASN B  45      50.895  71.675  29.490  1.00 17.00           C  
ATOM   2333  OD1 ASN B  45      50.186  70.929  28.783  1.00 15.88           O  
ATOM   2334  ND2 ASN B  45      51.260  71.375  30.757  1.00 14.51           N  
ATOM   2335  N   THR B  46      47.915  74.372  28.920  1.00 16.68           N  
ATOM   2336  CA  THR B  46      46.883  75.045  29.760  1.00 17.02           C  
ATOM   2337  C   THR B  46      46.274  74.045  30.722  1.00 16.38           C  
ATOM   2338  O   THR B  46      45.919  74.368  31.865  1.00 15.15           O  
ATOM   2339  CB  THR B  46      45.772  75.743  28.868  1.00 17.15           C  
ATOM   2340  OG1 THR B  46      45.392  74.869  27.804  1.00 17.38           O  
ATOM   2341  CG2 THR B  46      46.296  76.983  28.226  1.00 16.83           C  
ATOM   2342  N   GLU B  47      46.121  72.809  30.257  1.00 17.47           N  
ATOM   2343  CA  GLU B  47      45.486  71.749  31.090  1.00 17.15           C  
ATOM   2344  C   GLU B  47      44.162  72.141  31.711  1.00 16.08           C  
ATOM   2345  O   GLU B  47      43.902  71.847  32.925  1.00 15.64           O  
ATOM   2346  CB  GLU B  47      46.420  71.338  32.218  1.00 17.86           C  
ATOM   2347  CG  GLU B  47      47.793  70.966  31.728  1.00 23.34           C  
ATOM   2348  CD  GLU B  47      48.660  70.357  32.825  1.00 25.47           C  
ATOM   2349  OE1 GLU B  47      49.462  71.050  33.476  1.00 30.68           O  
ATOM   2350  OE2 GLU B  47      48.544  69.151  33.027  1.00 30.28           O  
ATOM   2351  N   SER B  48      43.350  72.855  30.929  1.00 14.10           N  
ATOM   2352  CA  SER B  48      42.071  73.339  31.374  1.00 14.90           C  
ATOM   2353  C   SER B  48      42.094  74.050  32.709  1.00 15.04           C  
ATOM   2354  O   SER B  48      41.175  73.931  33.535  1.00 15.05           O  
ATOM   2355  CB  SER B  48      41.060  72.197  31.372  1.00 13.48           C  
ATOM   2356  OG  SER B  48      41.078  71.581  30.084  1.00 18.85           O  
ATOM   2357  N   ASP B  49      43.178  74.773  32.921  1.00 15.76           N  
ATOM   2358  CA  ASP B  49      43.396  75.640  34.062  1.00 16.38           C  
ATOM   2359  C   ASP B  49      43.098  77.032  33.578  1.00 17.27           C  
ATOM   2360  O   ASP B  49      43.778  77.555  32.665  1.00 15.49           O  
ATOM   2361  CB  ASP B  49      44.868  75.543  34.466  1.00 16.90           C  
ATOM   2362  CG  ASP B  49      45.218  76.424  35.623  1.00 20.53           C  
ATOM   2363  OD1 ASP B  49      44.596  77.503  35.772  1.00 26.48           O  
ATOM   2364  OD2 ASP B  49      46.127  76.036  36.390  1.00 19.91           O  
ATOM   2365  N   LEU B  50      42.066  77.619  34.167  1.00 17.86           N  
ATOM   2366  CA  LEU B  50      41.490  78.851  33.634  1.00 17.77           C  
ATOM   2367  C   LEU B  50      42.446  80.007  33.732  1.00 17.58           C  
ATOM   2368  O   LEU B  50      42.474  80.864  32.826  1.00 16.15           O  
ATOM   2369  CB  LEU B  50      40.212  79.184  34.363  1.00 18.40           C  
ATOM   2370  CG  LEU B  50      39.393  80.334  33.821  1.00 19.66           C  
ATOM   2371  CD1 LEU B  50      38.944  80.043  32.420  1.00 19.43           C  
ATOM   2372  CD2 LEU B  50      38.154  80.466  34.764  1.00 22.22           C  
ATOM   2373  N   ALA B  51      43.264  79.991  34.788  1.00 17.13           N  
ATOM   2374  CA  ALA B  51      44.208  81.073  34.991  1.00 18.16           C  
ATOM   2375  C   ALA B  51      45.267  81.005  33.907  1.00 18.71           C  
ATOM   2376  O   ALA B  51      45.645  82.030  33.352  1.00 17.77           O  
ATOM   2377  CB  ALA B  51      44.828  81.017  36.366  1.00 17.48           C  
ATOM   2378  N   ARG B  52      45.766  79.802  33.620  1.00 18.48           N  
ATOM   2379  CA  ARG B  52      46.701  79.648  32.493  1.00 18.27           C  
ATOM   2380  C   ARG B  52      46.095  80.107  31.168  1.00 17.40           C  
ATOM   2381  O   ARG B  52      46.728  80.783  30.398  1.00 18.01           O  
ATOM   2382  CB  ARG B  52      47.126  78.192  32.347  1.00 17.56           C  
ATOM   2383  CG  ARG B  52      48.198  77.807  33.253  1.00 20.23           C  
ATOM   2384  CD  ARG B  52      48.722  76.424  32.886  1.00 21.69           C  
ATOM   2385  NE  ARG B  52      49.519  75.881  33.967  1.00 19.91           N  
ATOM   2386  CZ  ARG B  52      49.794  74.588  34.160  1.00 20.55           C  
ATOM   2387  NH1 ARG B  52      49.330  73.652  33.325  1.00 18.65           N  
ATOM   2388  NH2 ARG B  52      50.544  74.235  35.205  1.00 16.58           N  
ATOM   2389  N   SER B  53      44.850  79.724  30.901  1.00 17.68           N  
ATOM   2390  CA  SER B  53      44.197  80.073  29.651  1.00 15.98           C  
ATOM   2391  C   SER B  53      44.065  81.566  29.489  1.00 18.00           C  
ATOM   2392  O   SER B  53      44.406  82.111  28.440  1.00 14.33           O  
ATOM   2393  CB  SER B  53      42.808  79.512  29.620  1.00 15.92           C  
ATOM   2394  OG  SER B  53      42.881  78.128  29.829  1.00 13.07           O  
ATOM   2395  N   ARG B  54      43.551  82.217  30.524  1.00 17.25           N  
ATOM   2396  CA  ARG B  54      43.372  83.655  30.474  1.00 20.40           C  
ATOM   2397  C   ARG B  54      44.680  84.349  30.172  1.00 20.06           C  
ATOM   2398  O   ARG B  54      44.752  85.344  29.410  1.00 20.43           O  
ATOM   2399  CB  ARG B  54      42.810  84.147  31.805  1.00 20.63           C  
ATOM   2400  CG  ARG B  54      41.333  83.922  31.889  1.00 26.67           C  
ATOM   2401  CD  ARG B  54      40.690  84.490  33.176  1.00 35.02           C  
ATOM   2402  NE  ARG B  54      39.250  84.317  32.999  1.00 41.65           N  
ATOM   2403  CZ  ARG B  54      38.362  84.033  33.954  1.00 45.28           C  
ATOM   2404  NH1 ARG B  54      38.739  83.893  35.227  1.00 45.52           N  
ATOM   2405  NH2 ARG B  54      37.081  83.885  33.607  1.00 47.08           N  
ATOM   2406  N   SER B  55      45.737  83.820  30.768  1.00 18.87           N  
ATOM   2407  CA  SER B  55      47.032  84.452  30.632  1.00 19.16           C  
ATOM   2408  C   SER B  55      47.578  84.319  29.211  1.00 19.52           C  
ATOM   2409  O   SER B  55      48.044  85.276  28.612  1.00 18.23           O  
ATOM   2410  CB  SER B  55      47.965  83.924  31.743  1.00 19.62           C  
ATOM   2411  OG  SER B  55      49.285  83.871  31.310  1.00 25.62           O  
ATOM   2412  N   CYS B  56      47.488  83.138  28.626  1.00 19.25           N  
ATOM   2413  CA  CYS B  56      48.138  82.976  27.334  1.00 18.17           C  
ATOM   2414  C   CYS B  56      47.297  83.712  26.317  1.00 18.51           C  
ATOM   2415  O   CYS B  56      47.791  84.071  25.264  1.00 19.29           O  
ATOM   2416  CB  CYS B  56      48.392  81.505  26.974  1.00 16.71           C  
ATOM   2417  SG  CYS B  56      46.900  80.604  26.670  1.00 20.30           S  
ATOM   2418  N   LEU B  57      46.029  83.970  26.640  1.00 19.58           N  
ATOM   2419  CA  LEU B  57      45.147  84.682  25.689  1.00 19.50           C  
ATOM   2420  C   LEU B  57      45.428  86.182  25.555  1.00 20.21           C  
ATOM   2421  O   LEU B  57      44.934  86.808  24.626  1.00 19.52           O  
ATOM   2422  CB  LEU B  57      43.631  84.352  25.891  1.00 19.58           C  
ATOM   2423  CG  LEU B  57      43.137  82.956  25.466  1.00 19.65           C  
ATOM   2424  CD1 LEU B  57      41.731  82.735  25.964  1.00 19.67           C  
ATOM   2425  CD2 LEU B  57      43.213  82.667  23.956  1.00 20.64           C  
ATOM   2426  N   THR B  58      46.274  86.748  26.425  1.00 20.33           N  
ATOM   2427  CA  THR B  58      46.772  88.094  26.199  1.00 20.66           C  
ATOM   2428  C   THR B  58      47.570  88.208  24.866  1.00 21.71           C  
ATOM   2429  O   THR B  58      47.705  89.303  24.331  1.00 19.97           O  
ATOM   2430  CB  THR B  58      47.639  88.631  27.331  1.00 19.50           C  
ATOM   2431  OG1 THR B  58      48.757  87.788  27.478  1.00 23.75           O  
ATOM   2432  CG2 THR B  58      46.914  88.598  28.670  1.00 22.24           C  
ATOM   2433  N   LEU B  59      48.062  87.099  24.318  1.00 22.15           N  
ATOM   2434  CA  LEU B  59      48.704  87.149  23.019  1.00 23.80           C  
ATOM   2435  C   LEU B  59      47.769  87.588  21.900  1.00 25.17           C  
ATOM   2436  O   LEU B  59      48.218  88.192  20.907  1.00 24.77           O  
ATOM   2437  CB  LEU B  59      49.315  85.789  22.666  1.00 24.22           C  
ATOM   2438  CG  LEU B  59      50.401  85.282  23.630  1.00 24.06           C  
ATOM   2439  CD1 LEU B  59      50.623  83.826  23.416  1.00 23.92           C  
ATOM   2440  CD2 LEU B  59      51.652  86.068  23.393  1.00 25.51           C  
ATOM   2441  N   LEU B  60      46.479  87.252  22.034  1.00 25.96           N  
ATOM   2442  CA  LEU B  60      45.484  87.584  21.034  1.00 27.36           C  
ATOM   2443  C   LEU B  60      45.238  89.062  21.100  1.00 28.69           C  
ATOM   2444  O   LEU B  60      45.414  89.764  20.102  1.00 28.24           O  
ATOM   2445  CB  LEU B  60      44.160  86.838  21.265  1.00 27.82           C  
ATOM   2446  CG  LEU B  60      43.677  85.688  20.391  1.00 26.83           C  
ATOM   2447  CD1 LEU B  60      42.219  85.476  20.683  1.00 25.22           C  
ATOM   2448  CD2 LEU B  60      43.885  85.918  18.871  1.00 24.09           C  
ATOM   2449  N   SER B  61      44.853  89.538  22.285  1.00 30.59           N  
ATOM   2450  CA  SER B  61      44.731  90.985  22.545  1.00 32.18           C  
ATOM   2451  C   SER B  61      46.004  91.735  22.157  1.00 31.71           C  
ATOM   2452  O   SER B  61      45.942  92.749  21.469  1.00 32.51           O  
ATOM   2453  CB  SER B  61      44.453  91.240  24.031  1.00 33.60           C  
ATOM   2454  OG  SER B  61      45.625  91.029  24.812  1.00 37.14           O  
ATOM   2455  N   GLY B  62      47.157  91.236  22.587  1.00 29.92           N  
ATOM   2456  CA  GLY B  62      48.414  91.855  22.225  1.00 29.60           C  
ATOM   2457  C   GLY B  62      48.790  91.693  20.757  1.00 29.54           C  
ATOM   2458  O   GLY B  62      49.868  92.102  20.358  1.00 31.44           O  
ATOM   2459  N   LYS B  63      47.944  91.083  19.943  1.00 29.14           N  
ATOM   2460  CA  LYS B  63      48.249  90.922  18.489  1.00 28.60           C  
ATOM   2461  C   LYS B  63      49.513  90.112  18.143  1.00 27.62           C  
ATOM   2462  O   LYS B  63      50.112  90.335  17.095  1.00 28.48           O  
ATOM   2463  CB  LYS B  63      48.370  92.297  17.780  1.00 29.37           C  
ATOM   2464  CG  LYS B  63      47.215  93.304  17.985  1.00 29.32           C  
ATOM   2465  CD  LYS B  63      47.842  94.715  18.151  1.00 36.64           C  
ATOM   2466  CE  LYS B  63      47.566  95.684  16.982  1.00 36.06           C  
ATOM   2467  NZ  LYS B  63      46.198  96.248  17.090  1.00 30.77           N  
ATOM   2468  N   MET B  64      49.925  89.194  19.001  1.00 25.07           N  
ATOM   2469  CA  MET B  64      51.045  88.292  18.668  1.00 24.15           C  
ATOM   2470  C   MET B  64      50.560  87.008  17.959  1.00 23.35           C  
ATOM   2471  O   MET B  64      51.302  86.338  17.284  1.00 23.59           O  
ATOM   2472  CB  MET B  64      51.812  87.927  19.935  1.00 23.94           C  
ATOM   2473  CG  MET B  64      52.494  89.105  20.657  1.00 26.08           C  
ATOM   2474  SD  MET B  64      53.959  89.818  19.765  1.00 29.19           S  
ATOM   2475  CE  MET B  64      54.745  88.328  19.202  1.00 26.64           C  
ATOM   2476  N   VAL B  65      49.302  86.641  18.108  1.00 21.84           N  
ATOM   2477  CA  VAL B  65      48.814  85.498  17.360  1.00 20.27           C  
ATOM   2478  C   VAL B  65      47.519  85.901  16.700  1.00 20.68           C  
ATOM   2479  O   VAL B  65      46.795  86.798  17.233  1.00 19.80           O  
ATOM   2480  CB  VAL B  65      48.537  84.263  18.274  1.00 19.64           C  
ATOM   2481  CG1 VAL B  65      49.802  83.822  19.037  1.00 19.51           C  
ATOM   2482  CG2 VAL B  65      47.410  84.571  19.251  1.00 20.83           C  
ATOM   2483  N   ASP B  66      47.253  85.239  15.558  1.00 19.69           N  
ATOM   2484  CA  ASP B  66      46.106  85.465  14.717  1.00 19.36           C  
ATOM   2485  C   ASP B  66      44.877  84.577  15.001  1.00 18.97           C  
ATOM   2486  O   ASP B  66      43.826  84.763  14.370  1.00 17.24           O  
ATOM   2487  CB  ASP B  66      46.533  85.254  13.264  1.00 20.61           C  
ATOM   2488  CG  ASP B  66      47.386  86.403  12.708  1.00 24.78           C  
ATOM   2489  OD1 ASP B  66      47.845  87.277  13.487  1.00 26.71           O  
ATOM   2490  OD2 ASP B  66      47.599  86.419  11.463  1.00 30.66           O  
ATOM   2491  N   GLY B  67      44.960  83.666  15.963  1.00 17.21           N  
ATOM   2492  CA  GLY B  67      43.843  82.728  16.182  1.00 16.10           C  
ATOM   2493  C   GLY B  67      44.248  81.669  17.196  1.00 15.38           C  
ATOM   2494  O   GLY B  67      45.433  81.519  17.491  1.00 14.73           O  
ATOM   2495  N   VAL B  68      43.264  80.991  17.785  1.00 14.73           N  
ATOM   2496  CA  VAL B  68      43.513  79.984  18.814  1.00 13.79           C  
ATOM   2497  C   VAL B  68      42.831  78.615  18.491  1.00 13.53           C  
ATOM   2498  O   VAL B  68      41.691  78.566  18.063  1.00 11.57           O  
ATOM   2499  CB  VAL B  68      43.183  80.579  20.241  1.00 14.54           C  
ATOM   2500  CG1 VAL B  68      41.898  81.261  20.230  1.00 16.44           C  
ATOM   2501  CG2 VAL B  68      43.197  79.504  21.374  1.00 13.59           C  
ATOM   2502  N   ILE B  69      43.600  77.516  18.617  1.00 13.31           N  
ATOM   2503  CA  ILE B  69      43.045  76.142  18.633  1.00 12.41           C  
ATOM   2504  C   ILE B  69      43.184  75.650  20.028  1.00 12.48           C  
ATOM   2505  O   ILE B  69      44.241  75.801  20.619  1.00 12.96           O  
ATOM   2506  CB  ILE B  69      43.801  75.230  17.669  1.00 13.10           C  
ATOM   2507  CG1 ILE B  69      43.643  75.799  16.269  1.00 11.89           C  
ATOM   2508  CG2 ILE B  69      43.236  73.755  17.722  1.00 13.38           C  
ATOM   2509  CD1 ILE B  69      44.596  75.131  15.225  1.00 10.00           C  
ATOM   2510  N   THR B  70      42.082  75.228  20.616  1.00 13.47           N  
ATOM   2511  CA  THR B  70      42.056  74.740  21.989  1.00 13.50           C  
ATOM   2512  C   THR B  70      41.712  73.227  22.048  1.00 14.50           C  
ATOM   2513  O   THR B  70      40.879  72.747  21.293  1.00 13.91           O  
ATOM   2514  CB  THR B  70      41.099  75.576  22.907  1.00 14.72           C  
ATOM   2515  OG1 THR B  70      41.305  75.135  24.272  1.00 16.51           O  
ATOM   2516  CG2 THR B  70      39.600  75.465  22.485  1.00 13.09           C  
ATOM   2517  N   MET B  71      42.415  72.495  22.919  1.00 13.04           N  
ATOM   2518  CA  MET B  71      42.132  71.139  23.177  1.00 13.42           C  
ATOM   2519  C   MET B  71      41.610  71.062  24.662  1.00 15.05           C  
ATOM   2520  O   MET B  71      41.395  69.976  25.178  1.00 13.52           O  
ATOM   2521  CB  MET B  71      43.384  70.259  22.994  1.00 13.92           C  
ATOM   2522  CG  MET B  71      44.245  70.466  21.650  1.00 13.92           C  
ATOM   2523  SD  MET B  71      45.744  69.346  21.700  1.00 10.93           S  
ATOM   2524  CE  MET B  71      44.861  67.908  21.468  1.00 11.53           C  
ATOM   2525  N   ASP B  72      41.300  72.210  25.285  1.00 14.16           N  
ATOM   2526  CA  ASP B  72      40.759  72.161  26.670  1.00 14.92           C  
ATOM   2527  C   ASP B  72      39.335  71.670  26.830  1.00 14.17           C  
ATOM   2528  O   ASP B  72      38.567  71.561  25.837  1.00 14.80           O  
ATOM   2529  CB  ASP B  72      40.847  73.547  27.289  1.00 16.52           C  
ATOM   2530  CG  ASP B  72      42.254  73.896  27.766  1.00 17.86           C  
ATOM   2531  OD1 ASP B  72      43.096  73.012  27.780  1.00 19.48           O  
ATOM   2532  OD2 ASP B  72      42.451  75.045  28.250  1.00 21.17           O  
ATOM   2533  N   ALA B  73      38.954  71.403  28.090  1.00 12.96           N  
ATOM   2534  CA  ALA B  73      37.596  70.969  28.401  1.00 14.02           C  
ATOM   2535  C   ALA B  73      36.578  71.936  27.794  1.00 14.31           C  
ATOM   2536  O   ALA B  73      36.757  73.189  27.826  1.00 14.69           O  
ATOM   2537  CB  ALA B  73      37.380  70.851  29.951  1.00 13.90           C  
ATOM   2538  N   LEU B  74      35.527  71.341  27.225  1.00 15.46           N  
ATOM   2539  CA  LEU B  74      34.432  72.048  26.542  1.00 16.48           C  
ATOM   2540  C   LEU B  74      33.842  73.118  27.396  1.00 16.11           C  
ATOM   2541  O   LEU B  74      33.509  74.165  26.898  1.00 15.83           O  
ATOM   2542  CB  LEU B  74      33.310  71.034  26.204  1.00 19.44           C  
ATOM   2543  CG  LEU B  74      32.138  71.488  25.356  1.00 21.00           C  
ATOM   2544  CD1 LEU B  74      32.659  71.760  23.981  1.00 21.30           C  
ATOM   2545  CD2 LEU B  74      31.119  70.377  25.358  1.00 25.71           C  
ATOM   2546  N   SER B  75      33.764  72.893  28.717  1.00 15.07           N  
ATOM   2547  CA  SER B  75      33.136  73.856  29.599  1.00 16.53           C  
ATOM   2548  C   SER B  75      33.928  75.181  29.844  1.00 18.37           C  
ATOM   2549  O   SER B  75      33.432  76.165  30.498  1.00 18.34           O  
ATOM   2550  CB  SER B  75      32.954  73.186  30.939  1.00 16.31           C  
ATOM   2551  OG  SER B  75      34.204  72.915  31.509  1.00 17.48           O  
ATOM   2552  N   GLU B  76      35.145  75.205  29.314  1.00 18.35           N  
ATOM   2553  CA  GLU B  76      35.981  76.394  29.374  1.00 17.69           C  
ATOM   2554  C   GLU B  76      35.550  77.381  28.297  1.00 18.13           C  
ATOM   2555  O   GLU B  76      35.849  78.545  28.418  1.00 17.73           O  
ATOM   2556  CB  GLU B  76      37.449  76.015  29.149  1.00 18.25           C  
ATOM   2557  CG  GLU B  76      38.438  77.095  29.650  1.00 19.15           C  
ATOM   2558  CD  GLU B  76      39.894  76.701  29.523  1.00 19.73           C  
ATOM   2559  OE1 GLU B  76      40.330  76.331  28.380  1.00 18.02           O  
ATOM   2560  OE2 GLU B  76      40.598  76.836  30.557  1.00 20.79           O  
ATOM   2561  N   LEU B  77      34.935  76.907  27.212  1.00 18.02           N  
ATOM   2562  CA  LEU B  77      34.591  77.778  26.103  1.00 19.18           C  
ATOM   2563  C   LEU B  77      33.772  78.994  26.547  1.00 19.31           C  
ATOM   2564  O   LEU B  77      34.174  80.106  26.266  1.00 20.31           O  
ATOM   2565  CB  LEU B  77      33.911  77.000  24.979  1.00 19.28           C  
ATOM   2566  CG  LEU B  77      34.671  76.582  23.715  1.00 20.18           C  
ATOM   2567  CD1 LEU B  77      36.074  76.357  23.924  1.00 19.06           C  
ATOM   2568  CD2 LEU B  77      33.984  75.396  23.008  1.00 18.98           C  
ATOM   2569  N   PRO B  78      32.642  78.782  27.277  1.00 20.69           N  
ATOM   2570  CA  PRO B  78      31.842  79.958  27.702  1.00 20.35           C  
ATOM   2571  C   PRO B  78      32.600  80.910  28.636  1.00 20.95           C  
ATOM   2572  O   PRO B  78      32.354  82.107  28.601  1.00 19.92           O  
ATOM   2573  CB  PRO B  78      30.580  79.333  28.349  1.00 19.58           C  
ATOM   2574  CG  PRO B  78      31.001  77.995  28.755  1.00 20.18           C  
ATOM   2575  CD  PRO B  78      32.000  77.519  27.711  1.00 19.87           C  
ATOM   2576  N   GLU B  79      33.598  80.405  29.357  1.00 22.42           N  
ATOM   2577  CA  GLU B  79      34.401  81.220  30.258  1.00 24.39           C  
ATOM   2578  C   GLU B  79      35.412  82.118  29.506  1.00 23.80           C  
ATOM   2579  O   GLU B  79      35.963  83.054  30.069  1.00 23.41           O  
ATOM   2580  CB  GLU B  79      35.136  80.293  31.210  1.00 24.39           C  
ATOM   2581  CG  GLU B  79      34.208  79.463  32.100  1.00 28.03           C  
ATOM   2582  CD  GLU B  79      34.941  78.566  33.117  1.00 30.13           C  
ATOM   2583  OE1 GLU B  79      34.509  78.526  34.302  1.00 39.60           O  
ATOM   2584  OE2 GLU B  79      35.937  77.887  32.748  1.00 36.51           O  
ATOM   2585  N   LEU B  80      35.648  81.818  28.237  1.00 21.89           N  
ATOM   2586  CA  LEU B  80      36.618  82.545  27.459  1.00 20.90           C  
ATOM   2587  C   LEU B  80      36.048  83.327  26.289  1.00 21.30           C  
ATOM   2588  O   LEU B  80      36.805  84.010  25.595  1.00 21.41           O  
ATOM   2589  CB  LEU B  80      37.707  81.599  26.929  1.00 20.09           C  
ATOM   2590  CG  LEU B  80      38.559  80.785  27.894  1.00 18.36           C  
ATOM   2591  CD1 LEU B  80      39.479  79.791  27.067  1.00 18.08           C  
ATOM   2592  CD2 LEU B  80      39.370  81.663  28.879  1.00 15.98           C  
ATOM   2593  N   GLN B  81      34.736  83.228  26.087  1.00 23.54           N  
ATOM   2594  CA  GLN B  81      34.076  83.749  24.899  1.00 26.01           C  
ATOM   2595  C   GLN B  81      34.254  85.278  24.874  1.00 25.53           C  
ATOM   2596  O   GLN B  81      34.452  85.878  23.811  1.00 25.18           O  
ATOM   2597  CB  GLN B  81      32.624  83.253  24.796  1.00 25.02           C  
ATOM   2598  CG  GLN B  81      31.515  84.130  25.365  1.00 29.76           C  
ATOM   2599  CD  GLN B  81      30.318  83.302  25.906  1.00 31.72           C  
ATOM   2600  OE1 GLN B  81      29.850  83.524  27.046  1.00 36.60           O  
ATOM   2601  NE2 GLN B  81      29.852  82.317  25.100  1.00 34.61           N  
ATOM   2602  N   ASN B  82      34.310  85.877  26.056  1.00 24.68           N  
ATOM   2603  CA  ASN B  82      34.464  87.303  26.104  1.00 25.33           C  
ATOM   2604  C   ASN B  82      35.848  87.769  25.711  1.00 23.99           C  
ATOM   2605  O   ASN B  82      36.004  88.878  25.223  1.00 24.25           O  
ATOM   2606  CB  ASN B  82      34.095  87.826  27.467  1.00 26.57           C  
ATOM   2607  CG  ASN B  82      32.602  87.935  27.633  1.00 31.20           C  
ATOM   2608  OD1 ASN B  82      31.866  88.334  26.704  1.00 36.83           O  
ATOM   2609  ND2 ASN B  82      32.128  87.541  28.791  1.00 35.12           N  
ATOM   2610  N   ILE B  83      36.853  86.930  25.921  1.00 22.45           N  
ATOM   2611  CA  ILE B  83      38.202  87.305  25.513  1.00 21.48           C  
ATOM   2612  C   ILE B  83      38.348  87.081  24.012  1.00 20.25           C  
ATOM   2613  O   ILE B  83      38.932  87.898  23.321  1.00 20.02           O  
ATOM   2614  CB  ILE B  83      39.322  86.521  26.292  1.00 21.10           C  
ATOM   2615  CG1 ILE B  83      39.353  86.927  27.784  1.00 24.07           C  
ATOM   2616  CG2 ILE B  83      40.683  86.752  25.649  1.00 21.61           C  
ATOM   2617  CD1 ILE B  83      40.058  85.914  28.640  1.00 25.54           C  
ATOM   2618  N   ILE B  84      37.847  85.963  23.516  1.00 19.87           N  
ATOM   2619  CA  ILE B  84      38.090  85.582  22.121  1.00 20.08           C  
ATOM   2620  C   ILE B  84      37.153  86.261  21.110  1.00 19.65           C  
ATOM   2621  O   ILE B  84      37.568  86.550  20.001  1.00 20.91           O  
ATOM   2622  CB  ILE B  84      38.044  84.036  21.984  1.00 20.45           C  
ATOM   2623  CG1 ILE B  84      39.016  83.424  23.029  1.00 20.20           C  
ATOM   2624  CG2 ILE B  84      38.380  83.605  20.533  1.00 21.17           C  
ATOM   2625  CD1 ILE B  84      39.214  81.914  23.021  1.00 20.40           C  
ATOM   2626  N   GLY B  85      35.889  86.502  21.472  1.00 19.09           N  
ATOM   2627  CA  GLY B  85      34.988  87.259  20.594  1.00 17.73           C  
ATOM   2628  C   GLY B  85      34.948  86.614  19.224  1.00 18.37           C  
ATOM   2629  O   GLY B  85      34.768  85.401  19.090  1.00 17.60           O  
ATOM   2630  N   ALA B  86      35.174  87.429  18.202  1.00 18.22           N  
ATOM   2631  CA  ALA B  86      35.167  87.005  16.821  1.00 17.10           C  
ATOM   2632  C   ALA B  86      36.534  86.499  16.336  1.00 17.43           C  
ATOM   2633  O   ALA B  86      36.667  86.120  15.151  1.00 16.69           O  
ATOM   2634  CB  ALA B  86      34.760  88.169  15.974  1.00 17.28           C  
ATOM   2635  N   PHE B  87      37.565  86.516  17.195  1.00 16.42           N  
ATOM   2636  CA  PHE B  87      38.871  86.009  16.757  1.00 15.79           C  
ATOM   2637  C   PHE B  87      38.750  84.575  16.247  1.00 15.22           C  
ATOM   2638  O   PHE B  87      37.916  83.811  16.746  1.00 16.65           O  
ATOM   2639  CB  PHE B  87      39.944  86.136  17.854  1.00 17.43           C  
ATOM   2640  CG  PHE B  87      40.432  87.561  18.107  1.00 17.78           C  
ATOM   2641  CD1 PHE B  87      41.376  88.148  17.256  1.00 21.03           C  
ATOM   2642  CD2 PHE B  87      39.980  88.297  19.223  1.00 17.13           C  
ATOM   2643  CE1 PHE B  87      41.873  89.452  17.490  1.00 21.62           C  
ATOM   2644  CE2 PHE B  87      40.471  89.578  19.496  1.00 20.80           C  
ATOM   2645  CZ  PHE B  87      41.417  90.174  18.619  1.00 21.74           C  
ATOM   2646  N   PRO B  88      39.546  84.196  15.214  1.00 14.51           N  
ATOM   2647  CA  PRO B  88      39.507  82.786  14.783  1.00 13.89           C  
ATOM   2648  C   PRO B  88      39.715  81.802  15.959  1.00 13.72           C  
ATOM   2649  O   PRO B  88      40.629  81.997  16.756  1.00 13.61           O  
ATOM   2650  CB  PRO B  88      40.666  82.675  13.827  1.00 13.11           C  
ATOM   2651  CG  PRO B  88      40.778  84.086  13.240  1.00 14.78           C  
ATOM   2652  CD  PRO B  88      40.547  84.976  14.454  1.00 12.59           C  
ATOM   2653  N   TRP B  89      38.836  80.794  16.074  1.00 12.10           N  
ATOM   2654  CA  TRP B  89      38.788  79.904  17.250  1.00 12.51           C  
ATOM   2655  C   TRP B  89      38.271  78.555  16.781  1.00 11.91           C  
ATOM   2656  O   TRP B  89      37.270  78.475  16.047  1.00 13.04           O  
ATOM   2657  CB  TRP B  89      37.827  80.534  18.278  1.00 12.50           C  
ATOM   2658  CG  TRP B  89      37.758  79.983  19.652  1.00 11.85           C  
ATOM   2659  CD1 TRP B  89      38.576  79.079  20.230  1.00 15.22           C  
ATOM   2660  CD2 TRP B  89      36.848  80.423  20.683  1.00 13.32           C  
ATOM   2661  NE1 TRP B  89      38.227  78.891  21.547  1.00 16.23           N  
ATOM   2662  CE2 TRP B  89      37.154  79.699  21.844  1.00 14.40           C  
ATOM   2663  CE3 TRP B  89      35.788  81.343  20.711  1.00 13.41           C  
ATOM   2664  CZ2 TRP B  89      36.441  79.870  23.063  1.00 16.85           C  
ATOM   2665  CZ3 TRP B  89      35.050  81.519  21.943  1.00 15.40           C  
ATOM   2666  CH2 TRP B  89      35.404  80.801  23.097  1.00 13.60           C  
ATOM   2667  N   VAL B  90      38.943  77.481  17.205  1.00 12.88           N  
ATOM   2668  CA  VAL B  90      38.554  76.122  16.843  1.00 12.02           C  
ATOM   2669  C   VAL B  90      38.792  75.256  18.037  1.00 12.36           C  
ATOM   2670  O   VAL B  90      39.801  75.408  18.689  1.00 13.42           O  
ATOM   2671  CB  VAL B  90      39.379  75.535  15.687  1.00 12.09           C  
ATOM   2672  CG1 VAL B  90      39.021  74.099  15.452  1.00 13.21           C  
ATOM   2673  CG2 VAL B  90      39.155  76.297  14.364  1.00 12.15           C  
ATOM   2674  N   GLN B  91      37.878  74.326  18.296  1.00 11.50           N  
ATOM   2675  CA  GLN B  91      38.022  73.396  19.386  1.00 12.67           C  
ATOM   2676  C   GLN B  91      38.349  72.021  18.843  1.00 12.83           C  
ATOM   2677  O   GLN B  91      37.734  71.561  17.872  1.00 15.03           O  
ATOM   2678  CB  GLN B  91      36.767  73.373  20.264  1.00 12.06           C  
ATOM   2679  CG  GLN B  91      36.648  72.032  21.106  1.00 13.73           C  
ATOM   2680  CD  GLN B  91      37.189  72.278  22.512  1.00 18.89           C  
ATOM   2681  OE1 GLN B  91      36.881  73.305  23.106  1.00 13.85           O  
ATOM   2682  NE2 GLN B  91      37.992  71.355  23.036  1.00 20.10           N  
ATOM   2683  N   CYS B  92      39.349  71.379  19.416  1.00 14.90           N  
ATOM   2684  CA  CYS B  92      39.716  69.991  19.063  1.00 17.54           C  
ATOM   2685  C   CYS B  92      39.299  69.005  20.122  1.00 17.22           C  
ATOM   2686  O   CYS B  92      39.465  69.255  21.316  1.00 17.91           O  
ATOM   2687  CB  CYS B  92      41.231  69.828  18.972  1.00 18.79           C  
ATOM   2688  SG  CYS B  92      42.031  70.572  17.587  1.00 26.31           S  
ATOM   2689  N   ALA B  93      38.826  67.838  19.680  1.00 18.51           N  
ATOM   2690  CA  ALA B  93      38.659  66.681  20.542  1.00 17.45           C  
ATOM   2691  C   ALA B  93      37.552  66.790  21.546  1.00 18.31           C  
ATOM   2692  O   ALA B  93      37.389  65.899  22.311  1.00 19.26           O  
ATOM   2693  CB  ALA B  93      39.965  66.315  21.263  1.00 17.80           C  
ATOM   2694  N   GLU B  94      36.793  67.862  21.537  1.00 19.61           N  
ATOM   2695  CA  GLU B  94      35.525  67.924  22.266  1.00 20.94           C  
ATOM   2696  C   GLU B  94      34.408  68.176  21.235  1.00 21.41           C  
ATOM   2697  O   GLU B  94      34.591  68.905  20.269  1.00 22.48           O  
ATOM   2698  CB  GLU B  94      35.539  69.023  23.325  1.00 20.08           C  
ATOM   2699  CG  GLU B  94      36.470  68.786  24.507  1.00 20.85           C  
ATOM   2700  CD  GLU B  94      35.809  67.991  25.605  1.00 23.76           C  
ATOM   2701  OE1 GLU B  94      35.293  66.893  25.300  1.00 25.57           O  
ATOM   2702  OE2 GLU B  94      35.797  68.471  26.762  1.00 23.56           O  
ATOM   2703  N   TYR B  95      33.272  67.542  21.428  1.00 21.87           N  
ATOM   2704  CA  TYR B  95      32.169  67.635  20.468  1.00 21.67           C  
ATOM   2705  C   TYR B  95      30.874  68.063  21.124  1.00 21.94           C  
ATOM   2706  O   TYR B  95      30.329  67.303  21.930  1.00 22.26           O  
ATOM   2707  CB  TYR B  95      31.946  66.274  19.824  1.00 20.67           C  
ATOM   2708  CG  TYR B  95      30.841  66.197  18.821  1.00 19.66           C  
ATOM   2709  CD1 TYR B  95      30.840  67.019  17.714  1.00 23.22           C  
ATOM   2710  CD2 TYR B  95      29.860  65.241  18.925  1.00 19.67           C  
ATOM   2711  CE1 TYR B  95      29.861  66.955  16.759  1.00 20.56           C  
ATOM   2712  CE2 TYR B  95      28.880  65.132  17.982  1.00 22.67           C  
ATOM   2713  CZ  TYR B  95      28.907  66.003  16.882  1.00 22.04           C  
ATOM   2714  OH  TYR B  95      27.970  65.933  15.920  1.00 21.66           O  
ATOM   2715  N   ASP B  96      30.393  69.266  20.766  1.00 21.62           N  
ATOM   2716  CA  ASP B  96      29.059  69.710  21.104  1.00 22.59           C  
ATOM   2717  C   ASP B  96      28.489  70.416  19.889  1.00 22.39           C  
ATOM   2718  O   ASP B  96      28.960  71.497  19.521  1.00 21.70           O  
ATOM   2719  CB  ASP B  96      29.070  70.714  22.239  1.00 23.34           C  
ATOM   2720  CG  ASP B  96      27.661  71.129  22.634  1.00 26.79           C  
ATOM   2721  OD1 ASP B  96      26.673  70.617  22.021  1.00 27.73           O  
ATOM   2722  OD2 ASP B  96      27.553  71.931  23.583  1.00 26.00           O  
ATOM   2723  N   PRO B  97      27.531  69.774  19.199  1.00 22.18           N  
ATOM   2724  CA  PRO B  97      27.020  70.439  17.972  1.00 22.53           C  
ATOM   2725  C   PRO B  97      26.178  71.716  18.201  1.00 22.45           C  
ATOM   2726  O   PRO B  97      25.878  72.459  17.243  1.00 21.49           O  
ATOM   2727  CB  PRO B  97      26.229  69.330  17.235  1.00 23.38           C  
ATOM   2728  CG  PRO B  97      26.261  68.078  18.143  1.00 21.72           C  
ATOM   2729  CD  PRO B  97      27.015  68.409  19.411  1.00 22.68           C  
ATOM   2730  N   LEU B  98      25.820  71.988  19.456  1.00 21.96           N  
ATOM   2731  CA  LEU B  98      25.106  73.197  19.784  1.00 21.27           C  
ATOM   2732  C   LEU B  98      26.122  74.298  20.107  1.00 21.34           C  
ATOM   2733  O   LEU B  98      25.789  75.494  20.174  1.00 20.60           O  
ATOM   2734  CB  LEU B  98      24.132  72.948  20.956  1.00 22.08           C  
ATOM   2735  CG  LEU B  98      22.945  72.062  20.538  1.00 20.67           C  
ATOM   2736  CD1 LEU B  98      22.006  71.966  21.698  1.00 24.97           C  
ATOM   2737  CD2 LEU B  98      22.190  72.556  19.239  1.00 24.49           C  
ATOM   2738  N   SER B  99      27.386  73.952  20.238  1.00 19.80           N  
ATOM   2739  CA  SER B  99      28.357  75.035  20.491  1.00 20.50           C  
ATOM   2740  C   SER B  99      28.556  75.878  19.220  1.00 19.53           C  
ATOM   2741  O   SER B  99      28.439  75.349  18.119  1.00 20.26           O  
ATOM   2742  CB  SER B  99      29.668  74.436  20.995  1.00 20.72           C  
ATOM   2743  OG  SER B  99      30.739  75.309  20.754  1.00 23.87           O  
ATOM   2744  N   THR B 100      28.790  77.183  19.346  1.00 18.18           N  
ATOM   2745  CA  THR B 100      29.082  77.997  18.178  1.00 18.30           C  
ATOM   2746  C   THR B 100      30.559  77.998  17.721  1.00 18.44           C  
ATOM   2747  O   THR B 100      30.886  78.575  16.711  1.00 19.51           O  
ATOM   2748  CB  THR B 100      28.643  79.432  18.367  1.00 18.69           C  
ATOM   2749  OG1 THR B 100      29.243  79.969  19.563  1.00 18.92           O  
ATOM   2750  CG2 THR B 100      27.114  79.475  18.469  1.00 19.30           C  
ATOM   2751  N   VAL B 101      31.433  77.345  18.468  1.00 17.66           N  
ATOM   2752  CA  VAL B 101      32.841  77.283  18.126  1.00 16.05           C  
ATOM   2753  C   VAL B 101      33.066  76.051  17.291  1.00 16.67           C  
ATOM   2754  O   VAL B 101      32.688  74.961  17.700  1.00 15.34           O  
ATOM   2755  CB  VAL B 101      33.667  77.215  19.389  1.00 16.04           C  
ATOM   2756  CG1 VAL B 101      35.204  77.077  19.055  1.00 11.81           C  
ATOM   2757  CG2 VAL B 101      33.347  78.465  20.270  1.00 13.08           C  
ATOM   2758  N   SER B 102      33.641  76.230  16.101  1.00 14.39           N  
ATOM   2759  CA  SER B 102      33.818  75.106  15.236  1.00 13.94           C  
ATOM   2760  C   SER B 102      34.797  74.130  15.853  1.00 14.81           C  
ATOM   2761  O   SER B 102      35.710  74.534  16.565  1.00 14.28           O  
ATOM   2762  CB  SER B 102      34.318  75.534  13.848  1.00 12.44           C  
ATOM   2763  OG  SER B 102      33.371  76.401  13.247  1.00 12.39           O  
ATOM   2764  N   SER B 103      34.620  72.835  15.529  1.00 14.46           N  
ATOM   2765  CA  SER B 103      35.339  71.765  16.204  1.00 14.48           C  
ATOM   2766  C   SER B 103      35.683  70.687  15.207  1.00 13.53           C  
ATOM   2767  O   SER B 103      35.072  70.566  14.145  1.00 14.14           O  
ATOM   2768  CB  SER B 103      34.498  71.143  17.326  1.00 13.77           C  
ATOM   2769  OG  SER B 103      33.349  70.598  16.714  1.00 19.87           O  
ATOM   2770  N   VAL B 104      36.618  69.848  15.611  1.00 14.59           N  
ATOM   2771  CA  VAL B 104      36.983  68.649  14.888  1.00 16.19           C  
ATOM   2772  C   VAL B 104      37.376  67.596  15.956  1.00 16.48           C  
ATOM   2773  O   VAL B 104      38.125  67.886  16.875  1.00 16.84           O  
ATOM   2774  CB  VAL B 104      38.100  68.915  13.823  1.00 15.87           C  
ATOM   2775  CG1 VAL B 104      39.306  69.587  14.419  1.00 18.81           C  
ATOM   2776  CG2 VAL B 104      38.574  67.584  13.176  1.00 15.68           C  
ATOM   2777  N   SER B 105      36.769  66.423  15.867  1.00 16.56           N  
ATOM   2778  CA  SER B 105      36.926  65.334  16.850  1.00 16.77           C  
ATOM   2779  C   SER B 105      36.360  64.046  16.275  1.00 16.84           C  
ATOM   2780  O   SER B 105      35.911  64.014  15.127  1.00 17.71           O  
ATOM   2781  CB  SER B 105      36.212  65.626  18.167  1.00 15.62           C  
ATOM   2782  OG  SER B 105      34.868  65.855  17.945  1.00 16.47           O  
ATOM   2783  N   ILE B 106      36.427  62.971  17.057  1.00 16.45           N  
ATOM   2784  CA  ILE B 106      35.713  61.762  16.738  1.00 16.11           C  
ATOM   2785  C   ILE B 106      34.409  61.739  17.547  1.00 16.73           C  
ATOM   2786  O   ILE B 106      34.178  62.618  18.397  1.00 14.32           O  
ATOM   2787  CB  ILE B 106      36.556  60.492  17.116  1.00 17.08           C  
ATOM   2788  CG1 ILE B 106      36.711  60.391  18.654  1.00 16.55           C  
ATOM   2789  CG2 ILE B 106      37.888  60.499  16.337  1.00 14.33           C  
ATOM   2790  CD1 ILE B 106      37.066  59.029  19.203  1.00 17.62           C  
ATOM   2791  N   ASP B 107      33.584  60.704  17.304  1.00 15.68           N  
ATOM   2792  CA  ASP B 107      32.385  60.462  18.111  1.00 16.85           C  
ATOM   2793  C   ASP B 107      32.737  59.500  19.269  1.00 16.09           C  
ATOM   2794  O   ASP B 107      32.765  58.302  19.095  1.00 16.15           O  
ATOM   2795  CB  ASP B 107      31.301  59.821  17.227  1.00 16.04           C  
ATOM   2796  CG  ASP B 107      30.000  59.589  17.960  1.00 17.44           C  
ATOM   2797  OD1 ASP B 107      29.920  59.555  19.202  1.00 20.92           O  
ATOM   2798  OD2 ASP B 107      29.008  59.401  17.274  1.00 18.62           O  
ATOM   2799  N   ASP B 108      32.946  60.040  20.458  1.00 16.76           N  
ATOM   2800  CA  ASP B 108      33.362  59.270  21.610  1.00 16.03           C  
ATOM   2801  C   ASP B 108      32.317  58.295  22.091  1.00 16.18           C  
ATOM   2802  O   ASP B 108      32.645  57.212  22.616  1.00 15.03           O  
ATOM   2803  CB  ASP B 108      33.795  60.198  22.720  1.00 16.63           C  
ATOM   2804  CG  ASP B 108      35.185  60.787  22.451  1.00 16.15           C  
ATOM   2805  OD1 ASP B 108      36.084  59.965  22.345  1.00 15.62           O  
ATOM   2806  OD2 ASP B 108      35.363  62.001  22.260  1.00 15.75           O  
ATOM   2807  N   VAL B 109      31.058  58.679  21.983  1.00 16.44           N  
ATOM   2808  CA  VAL B 109      29.978  57.767  22.434  1.00 16.09           C  
ATOM   2809  C   VAL B 109      29.895  56.577  21.547  1.00 15.69           C  
ATOM   2810  O   VAL B 109      29.861  55.494  22.062  1.00 17.05           O  
ATOM   2811  CB  VAL B 109      28.611  58.453  22.500  1.00 16.76           C  
ATOM   2812  CG1 VAL B 109      27.494  57.432  22.961  1.00 16.94           C  
ATOM   2813  CG2 VAL B 109      28.699  59.496  23.501  1.00 14.06           C  
ATOM   2814  N   ALA B 110      29.952  56.752  20.216  1.00 14.73           N  
ATOM   2815  CA  ALA B 110      29.872  55.587  19.330  1.00 14.48           C  
ATOM   2816  C   ALA B 110      31.084  54.659  19.502  1.00 14.75           C  
ATOM   2817  O   ALA B 110      30.911  53.435  19.528  1.00 16.25           O  
ATOM   2818  CB  ALA B 110      29.726  55.974  17.826  1.00 12.99           C  
ATOM   2819  N   ALA B 111      32.296  55.218  19.586  1.00 13.42           N  
ATOM   2820  CA  ALA B 111      33.496  54.399  19.808  1.00 12.89           C  
ATOM   2821  C   ALA B 111      33.427  53.619  21.110  1.00 14.41           C  
ATOM   2822  O   ALA B 111      33.795  52.470  21.093  1.00 14.44           O  
ATOM   2823  CB  ALA B 111      34.746  55.248  19.793  1.00 12.80           C  
ATOM   2824  N   SER B 112      33.046  54.244  22.247  1.00 12.57           N  
ATOM   2825  CA  SER B 112      33.043  53.487  23.475  1.00 14.68           C  
ATOM   2826  C   SER B 112      31.968  52.434  23.572  1.00 15.07           C  
ATOM   2827  O   SER B 112      32.223  51.392  24.131  1.00 15.89           O  
ATOM   2828  CB  SER B 112      33.093  54.365  24.724  1.00 14.41           C  
ATOM   2829  OG  SER B 112      32.314  55.464  24.452  1.00 23.45           O  
ATOM   2830  N   GLU B 113      30.787  52.662  22.982  1.00 16.40           N  
ATOM   2831  CA  GLU B 113      29.768  51.617  22.985  1.00 17.35           C  
ATOM   2832  C   GLU B 113      30.224  50.455  22.136  1.00 17.02           C  
ATOM   2833  O   GLU B 113      29.937  49.340  22.473  1.00 17.90           O  
ATOM   2834  CB  GLU B 113      28.381  52.135  22.496  1.00 17.30           C  
ATOM   2835  CG  GLU B 113      27.827  53.251  23.330  1.00 19.01           C  
ATOM   2836  CD  GLU B 113      26.473  53.728  22.833  1.00 21.61           C  
ATOM   2837  OE1 GLU B 113      26.274  53.841  21.608  1.00 28.26           O  
ATOM   2838  OE2 GLU B 113      25.631  54.032  23.682  1.00 27.29           O  
ATOM   2839  N   TYR B 114      30.864  50.739  21.002  1.00 17.20           N  
ATOM   2840  CA  TYR B 114      31.452  49.733  20.101  1.00 16.84           C  
ATOM   2841  C   TYR B 114      32.497  48.894  20.798  1.00 16.05           C  
ATOM   2842  O   TYR B 114      32.550  47.727  20.583  1.00 17.01           O  
ATOM   2843  CB  TYR B 114      32.173  50.387  18.914  1.00 17.97           C  
ATOM   2844  CG  TYR B 114      32.522  49.392  17.823  1.00 19.02           C  
ATOM   2845  CD1 TYR B 114      33.742  48.734  17.809  1.00 19.68           C  
ATOM   2846  CD2 TYR B 114      31.610  49.116  16.800  1.00 23.52           C  
ATOM   2847  CE1 TYR B 114      34.067  47.811  16.780  1.00 20.76           C  
ATOM   2848  CE2 TYR B 114      31.906  48.200  15.764  1.00 23.34           C  
ATOM   2849  CZ  TYR B 114      33.126  47.535  15.781  1.00 22.86           C  
ATOM   2850  OH  TYR B 114      33.394  46.665  14.751  1.00 21.20           O  
ATOM   2851  N   VAL B 115      33.357  49.520  21.583  1.00 14.53           N  
ATOM   2852  CA  VAL B 115      34.309  48.809  22.495  1.00 13.13           C  
ATOM   2853  C   VAL B 115      33.619  47.801  23.387  1.00 13.69           C  
ATOM   2854  O   VAL B 115      33.967  46.629  23.384  1.00 13.49           O  
ATOM   2855  CB  VAL B 115      35.159  49.782  23.288  1.00 13.46           C  
ATOM   2856  CG1 VAL B 115      35.935  49.011  24.409  1.00  8.93           C  
ATOM   2857  CG2 VAL B 115      36.125  50.558  22.293  1.00 10.82           C  
ATOM   2858  N   VAL B 116      32.612  48.247  24.124  1.00 13.86           N  
ATOM   2859  CA  VAL B 116      31.821  47.343  24.955  1.00 16.10           C  
ATOM   2860  C   VAL B 116      31.125  46.252  24.137  1.00 16.85           C  
ATOM   2861  O   VAL B 116      31.166  45.082  24.515  1.00 16.55           O  
ATOM   2862  CB  VAL B 116      30.797  48.094  25.782  1.00 15.12           C  
ATOM   2863  CG1 VAL B 116      29.921  47.115  26.567  1.00 17.00           C  
ATOM   2864  CG2 VAL B 116      31.512  49.041  26.723  1.00 15.95           C  
ATOM   2865  N   ASP B 117      30.530  46.599  23.011  1.00 16.93           N  
ATOM   2866  CA  ASP B 117      29.895  45.540  22.237  1.00 17.18           C  
ATOM   2867  C   ASP B 117      30.900  44.466  21.832  1.00 17.60           C  
ATOM   2868  O   ASP B 117      30.541  43.307  21.841  1.00 16.61           O  
ATOM   2869  CB  ASP B 117      29.210  46.053  20.973  1.00 17.44           C  
ATOM   2870  CG  ASP B 117      28.025  46.900  21.260  1.00 19.99           C  
ATOM   2871  OD1 ASP B 117      27.523  46.932  22.407  1.00 22.04           O  
ATOM   2872  OD2 ASP B 117      27.589  47.547  20.306  1.00 18.52           O  
ATOM   2873  N   GLN B 118      32.138  44.849  21.460  1.00 17.52           N  
ATOM   2874  CA  GLN B 118      33.130  43.869  21.017  1.00 17.27           C  
ATOM   2875  C   GLN B 118      33.593  42.991  22.157  1.00 17.51           C  
ATOM   2876  O   GLN B 118      33.678  41.787  22.012  1.00 17.13           O  
ATOM   2877  CB  GLN B 118      34.353  44.530  20.394  1.00 18.16           C  
ATOM   2878  CG  GLN B 118      34.070  45.353  19.162  1.00 18.42           C  
ATOM   2879  CD  GLN B 118      33.038  44.745  18.299  1.00 21.45           C  
ATOM   2880  OE1 GLN B 118      33.256  43.684  17.715  1.00 26.29           O  
ATOM   2881  NE2 GLN B 118      31.905  45.433  18.156  1.00 19.56           N  
ATOM   2882  N   LEU B 119      33.906  43.593  23.300  1.00 16.55           N  
ATOM   2883  CA  LEU B 119      34.175  42.803  24.494  1.00 15.40           C  
ATOM   2884  C   LEU B 119      33.049  41.807  24.835  1.00 14.83           C  
ATOM   2885  O   LEU B 119      33.331  40.675  25.143  1.00 15.29           O  
ATOM   2886  CB  LEU B 119      34.568  43.680  25.695  1.00 14.70           C  
ATOM   2887  CG  LEU B 119      35.864  44.460  25.523  1.00 14.50           C  
ATOM   2888  CD1 LEU B 119      35.936  45.635  26.508  1.00 16.87           C  
ATOM   2889  CD2 LEU B 119      37.100  43.550  25.658  1.00 16.93           C  
ATOM   2890  N   VAL B 120      31.798  42.216  24.775  1.00 15.76           N  
ATOM   2891  CA  VAL B 120      30.671  41.306  25.092  1.00 17.01           C  
ATOM   2892  C   VAL B 120      30.532  40.199  24.061  1.00 18.74           C  
ATOM   2893  O   VAL B 120      30.268  39.057  24.435  1.00 18.84           O  
ATOM   2894  CB  VAL B 120      29.355  42.106  25.213  1.00 18.55           C  
ATOM   2895  CG1 VAL B 120      28.056  41.198  25.098  1.00 16.85           C  
ATOM   2896  CG2 VAL B 120      29.357  42.917  26.502  1.00 13.79           C  
ATOM   2897  N   LYS B 121      30.778  40.505  22.778  1.00 18.35           N  
ATOM   2898  CA  LYS B 121      30.768  39.507  21.736  1.00 21.08           C  
ATOM   2899  C   LYS B 121      31.814  38.443  21.985  1.00 21.50           C  
ATOM   2900  O   LYS B 121      31.633  37.277  21.654  1.00 21.02           O  
ATOM   2901  CB  LYS B 121      31.046  40.146  20.350  1.00 21.41           C  
ATOM   2902  CG  LYS B 121      29.795  40.438  19.520  1.00 23.05           C  
ATOM   2903  CD  LYS B 121      30.141  41.040  18.152  1.00 26.01           C  
ATOM   2904  CE  LYS B 121      30.783  39.985  17.244  1.00 34.99           C  
ATOM   2905  NZ  LYS B 121      30.162  39.940  15.858  1.00 39.69           N  
ATOM   2906  N   SER B 122      32.956  38.849  22.521  1.00 21.67           N  
ATOM   2907  CA  SER B 122      34.033  37.909  22.710  1.00 21.15           C  
ATOM   2908  C   SER B 122      33.802  37.141  23.999  1.00 21.77           C  
ATOM   2909  O   SER B 122      34.630  36.339  24.358  1.00 21.61           O  
ATOM   2910  CB  SER B 122      35.384  38.615  22.706  1.00 20.82           C  
ATOM   2911  OG  SER B 122      35.629  39.189  23.974  1.00 24.57           O  
ATOM   2912  N   GLY B 123      32.666  37.375  24.684  1.00 21.22           N  
ATOM   2913  CA  GLY B 123      32.301  36.543  25.833  1.00 19.66           C  
ATOM   2914  C   GLY B 123      32.583  37.162  27.202  1.00 19.65           C  
ATOM   2915  O   GLY B 123      32.332  36.526  28.212  1.00 19.93           O  
ATOM   2916  N   LYS B 124      33.104  38.402  27.233  1.00 18.71           N  
ATOM   2917  CA  LYS B 124      33.439  39.102  28.471  1.00 17.01           C  
ATOM   2918  C   LYS B 124      32.176  39.648  29.168  1.00 17.52           C  
ATOM   2919  O   LYS B 124      31.275  40.080  28.507  1.00 18.24           O  
ATOM   2920  CB  LYS B 124      34.451  40.233  28.185  1.00 16.38           C  
ATOM   2921  CG  LYS B 124      35.783  39.734  27.623  1.00 15.92           C  
ATOM   2922  CD  LYS B 124      36.449  38.788  28.651  1.00 12.73           C  
ATOM   2923  CE  LYS B 124      37.815  38.277  28.196  1.00 14.22           C  
ATOM   2924  NZ  LYS B 124      38.639  37.885  29.432  1.00 18.00           N  
ATOM   2925  N   LYS B 125      32.111  39.617  30.493  1.00 17.26           N  
ATOM   2926  CA  LYS B 125      30.881  39.878  31.190  1.00 17.65           C  
ATOM   2927  C   LYS B 125      31.105  40.824  32.381  1.00 18.52           C  
ATOM   2928  O   LYS B 125      30.156  41.389  32.951  1.00 18.54           O  
ATOM   2929  CB  LYS B 125      30.276  38.552  31.689  1.00 18.53           C  
ATOM   2930  CG  LYS B 125      29.369  37.913  30.640  1.00 20.61           C  
ATOM   2931  CD  LYS B 125      28.709  36.664  31.167  1.00 27.38           C  
ATOM   2932  CE  LYS B 125      27.940  35.962  30.073  1.00 32.54           C  
ATOM   2933  NZ  LYS B 125      28.715  35.881  28.780  1.00 39.97           N  
ATOM   2934  N   ARG B 126      32.362  41.044  32.732  1.00 17.75           N  
ATOM   2935  CA  ARG B 126      32.661  41.963  33.827  1.00 18.08           C  
ATOM   2936  C   ARG B 126      33.697  42.965  33.356  1.00 18.00           C  
ATOM   2937  O   ARG B 126      34.918  42.779  33.581  1.00 19.32           O  
ATOM   2938  CB  ARG B 126      33.157  41.195  35.052  1.00 17.27           C  
ATOM   2939  CG  ARG B 126      32.060  40.349  35.697  1.00 19.21           C  
ATOM   2940  CD  ARG B 126      32.518  39.295  36.787  1.00 20.04           C  
ATOM   2941  NE  ARG B 126      33.828  38.665  36.607  1.00 26.21           N  
ATOM   2942  CZ  ARG B 126      34.095  37.559  35.896  1.00 29.22           C  
ATOM   2943  NH1 ARG B 126      33.141  36.907  35.240  1.00 27.77           N  
ATOM   2944  NH2 ARG B 126      35.353  37.088  35.835  1.00 28.66           N  
ATOM   2945  N   ILE B 127      33.218  44.007  32.683  1.00 16.46           N  
ATOM   2946  CA  ILE B 127      34.083  44.933  32.012  1.00 16.68           C  
ATOM   2947  C   ILE B 127      34.184  46.137  32.944  1.00 16.58           C  
ATOM   2948  O   ILE B 127      33.146  46.691  33.355  1.00 18.74           O  
ATOM   2949  CB  ILE B 127      33.504  45.351  30.626  1.00 15.73           C  
ATOM   2950  CG1 ILE B 127      33.350  44.136  29.711  1.00 17.05           C  
ATOM   2951  CG2 ILE B 127      34.415  46.448  29.955  1.00 18.55           C  
ATOM   2952  CD1 ILE B 127      32.344  44.288  28.630  1.00 19.33           C  
ATOM   2953  N   ALA B 128      35.407  46.535  33.269  1.00 15.22           N  
ATOM   2954  CA  ALA B 128      35.713  47.711  34.113  1.00 13.96           C  
ATOM   2955  C   ALA B 128      36.223  48.832  33.213  1.00 14.76           C  
ATOM   2956  O   ALA B 128      36.646  48.583  32.050  1.00 14.71           O  
ATOM   2957  CB  ALA B 128      36.808  47.347  35.223  1.00 14.71           C  
ATOM   2958  N   LEU B 129      36.141  50.061  33.729  1.00 12.34           N  
ATOM   2959  CA  LEU B 129      36.617  51.262  33.061  1.00 12.79           C  
ATOM   2960  C   LEU B 129      37.673  51.959  33.932  1.00 13.47           C  
ATOM   2961  O   LEU B 129      37.501  52.114  35.155  1.00 13.10           O  
ATOM   2962  CB  LEU B 129      35.438  52.220  32.756  1.00 12.06           C  
ATOM   2963  CG  LEU B 129      35.733  53.553  32.044  1.00 11.67           C  
ATOM   2964  CD1 LEU B 129      35.925  53.258  30.502  1.00 11.13           C  
ATOM   2965  CD2 LEU B 129      34.588  54.555  32.206  1.00 13.66           C  
ATOM   2966  N   ILE B 130      38.803  52.302  33.328  1.00 12.53           N  
ATOM   2967  CA  ILE B 130      39.736  53.201  33.997  1.00 12.72           C  
ATOM   2968  C   ILE B 130      39.498  54.560  33.307  1.00 13.58           C  
ATOM   2969  O   ILE B 130      39.759  54.712  32.078  1.00 12.67           O  
ATOM   2970  CB  ILE B 130      41.240  52.762  33.852  1.00 12.00           C  
ATOM   2971  CG1 ILE B 130      41.453  51.406  34.491  1.00  9.29           C  
ATOM   2972  CG2 ILE B 130      42.185  53.813  34.559  1.00 13.24           C  
ATOM   2973  CD1 ILE B 130      42.856  50.862  34.382  1.00 14.40           C  
ATOM   2974  N   ASN B 131      38.930  55.503  34.048  1.00 13.80           N  
ATOM   2975  CA  ASN B 131      38.690  56.830  33.477  1.00 15.53           C  
ATOM   2976  C   ASN B 131      39.723  57.825  34.064  1.00 17.28           C  
ATOM   2977  O   ASN B 131      40.498  57.462  34.961  1.00 17.38           O  
ATOM   2978  CB  ASN B 131      37.224  57.244  33.718  1.00 13.85           C  
ATOM   2979  CG  ASN B 131      36.729  58.266  32.731  1.00 14.90           C  
ATOM   2980  OD1 ASN B 131      37.522  58.926  32.057  1.00 17.77           O  
ATOM   2981  ND2 ASN B 131      35.406  58.484  32.697  1.00 13.75           N  
ATOM   2982  N   HIS B 132      39.780  59.060  33.594  1.00 18.34           N  
ATOM   2983  CA  HIS B 132      40.843  59.920  34.132  1.00 20.78           C  
ATOM   2984  C   HIS B 132      40.295  61.214  34.712  1.00 23.11           C  
ATOM   2985  O   HIS B 132      40.062  61.293  35.968  1.00 27.66           O  
ATOM   2986  CB  HIS B 132      42.047  60.067  33.154  1.00 20.67           C  
ATOM   2987  CG  HIS B 132      43.006  61.176  33.488  1.00 21.16           C  
ATOM   2988  ND1 HIS B 132      43.570  61.340  34.739  1.00 18.48           N  
ATOM   2989  CD2 HIS B 132      43.520  62.177  32.716  1.00 24.00           C  
ATOM   2990  CE1 HIS B 132      44.379  62.396  34.730  1.00 19.39           C  
ATOM   2991  NE2 HIS B 132      44.360  62.929  33.524  1.00 19.89           N  
ATOM   2992  N   ASP B 133      40.041  62.205  33.875  1.00 23.17           N  
ATOM   2993  CA  ASP B 133      39.646  63.574  34.346  1.00 21.27           C  
ATOM   2994  C   ASP B 133      38.317  63.954  33.707  1.00 20.77           C  
ATOM   2995  O   ASP B 133      38.256  64.306  32.524  1.00 18.66           O  
ATOM   2996  CB  ASP B 133      40.745  64.544  33.890  1.00 22.57           C  
ATOM   2997  CG  ASP B 133      40.492  66.030  34.252  1.00 26.20           C  
ATOM   2998  OD1 ASP B 133      39.523  66.450  34.953  1.00 19.79           O  
ATOM   2999  OD2 ASP B 133      41.359  66.797  33.785  1.00 31.63           O  
ATOM   3000  N   LEU B 134      37.251  63.843  34.493  1.00 19.55           N  
ATOM   3001  CA  LEU B 134      35.889  64.114  34.029  1.00 18.59           C  
ATOM   3002  C   LEU B 134      35.539  65.562  33.665  1.00 17.41           C  
ATOM   3003  O   LEU B 134      34.420  65.790  33.269  1.00 17.73           O  
ATOM   3004  CB  LEU B 134      34.862  63.600  35.065  1.00 19.45           C  
ATOM   3005  CG  LEU B 134      34.544  62.078  35.138  1.00 20.19           C  
ATOM   3006  CD1 LEU B 134      33.479  61.879  36.237  1.00 20.11           C  
ATOM   3007  CD2 LEU B 134      34.031  61.480  33.839  1.00 13.91           C  
ATOM   3008  N   ALA B 135      36.432  66.548  33.855  1.00 15.16           N  
ATOM   3009  CA  ALA B 135      36.155  67.899  33.365  1.00 14.64           C  
ATOM   3010  C   ALA B 135      36.034  67.843  31.817  1.00 14.21           C  
ATOM   3011  O   ALA B 135      35.318  68.644  31.227  1.00 14.19           O  
ATOM   3012  CB  ALA B 135      37.318  68.895  33.787  1.00 13.30           C  
ATOM   3013  N   TYR B 136      36.679  66.859  31.166  1.00 13.62           N  
ATOM   3014  CA  TYR B 136      36.592  66.739  29.694  1.00 14.84           C  
ATOM   3015  C   TYR B 136      35.356  65.999  29.229  1.00 16.55           C  
ATOM   3016  O   TYR B 136      35.020  64.898  29.746  1.00 16.21           O  
ATOM   3017  CB  TYR B 136      37.832  66.105  29.131  1.00 15.15           C  
ATOM   3018  CG  TYR B 136      39.077  66.944  29.365  1.00 16.16           C  
ATOM   3019  CD1 TYR B 136      39.769  66.901  30.582  1.00 16.62           C  
ATOM   3020  CD2 TYR B 136      39.571  67.789  28.350  1.00 16.92           C  
ATOM   3021  CE1 TYR B 136      40.907  67.720  30.788  1.00 19.53           C  
ATOM   3022  CE2 TYR B 136      40.712  68.560  28.538  1.00 13.94           C  
ATOM   3023  CZ  TYR B 136      41.381  68.528  29.731  1.00 17.65           C  
ATOM   3024  OH  TYR B 136      42.518  69.328  29.904  1.00 15.08           O  
ATOM   3025  N   GLN B 137      34.659  66.586  28.249  1.00 16.74           N  
ATOM   3026  CA  GLN B 137      33.397  65.975  27.825  1.00 17.63           C  
ATOM   3027  C   GLN B 137      33.728  64.625  27.200  1.00 16.77           C  
ATOM   3028  O   GLN B 137      32.978  63.653  27.336  1.00 16.32           O  
ATOM   3029  CB  GLN B 137      32.576  66.869  26.876  1.00 16.29           C  
ATOM   3030  CG  GLN B 137      31.152  66.365  26.682  1.00 19.89           C  
ATOM   3031  CD  GLN B 137      30.331  67.109  25.630  1.00 21.80           C  
ATOM   3032  OE1 GLN B 137      29.327  67.715  25.981  1.00 29.89           O  
ATOM   3033  NE2 GLN B 137      30.728  67.041  24.344  1.00 22.20           N  
ATOM   3034  N   TYR B 138      34.872  64.507  26.553  1.00 16.41           N  
ATOM   3035  CA  TYR B 138      35.106  63.191  26.022  1.00 16.73           C  
ATOM   3036  C   TYR B 138      35.223  62.152  27.160  1.00 15.92           C  
ATOM   3037  O   TYR B 138      34.842  61.020  26.984  1.00 15.76           O  
ATOM   3038  CB  TYR B 138      36.293  63.121  25.089  1.00 16.18           C  
ATOM   3039  CG  TYR B 138      37.604  63.637  25.632  1.00 17.49           C  
ATOM   3040  CD1 TYR B 138      38.423  62.858  26.478  1.00 19.02           C  
ATOM   3041  CD2 TYR B 138      38.102  64.881  25.195  1.00 14.28           C  
ATOM   3042  CE1 TYR B 138      39.679  63.386  26.939  1.00 16.81           C  
ATOM   3043  CE2 TYR B 138      39.311  65.381  25.635  1.00 11.95           C  
ATOM   3044  CZ  TYR B 138      40.099  64.625  26.470  1.00 15.58           C  
ATOM   3045  OH  TYR B 138      41.328  65.195  26.810  1.00 18.94           O  
ATOM   3046  N   ALA B 139      35.751  62.531  28.316  1.00 16.30           N  
ATOM   3047  CA  ALA B 139      35.861  61.516  29.368  1.00 17.70           C  
ATOM   3048  C   ALA B 139      34.478  61.181  29.913  1.00 17.23           C  
ATOM   3049  O   ALA B 139      34.205  60.021  30.311  1.00 18.69           O  
ATOM   3050  CB  ALA B 139      36.835  61.928  30.482  1.00 17.32           C  
ATOM   3051  N   GLN B 140      33.596  62.170  29.916  1.00 17.03           N  
ATOM   3052  CA  GLN B 140      32.197  61.957  30.353  1.00 16.64           C  
ATOM   3053  C   GLN B 140      31.452  61.018  29.361  1.00 15.99           C  
ATOM   3054  O   GLN B 140      30.744  60.090  29.764  1.00 16.08           O  
ATOM   3055  CB  GLN B 140      31.497  63.294  30.421  1.00 17.27           C  
ATOM   3056  CG  GLN B 140      32.010  64.264  31.585  1.00 18.49           C  
ATOM   3057  CD  GLN B 140      31.422  65.638  31.395  1.00 17.82           C  
ATOM   3058  OE1 GLN B 140      30.291  65.740  31.027  1.00 19.11           O  
ATOM   3059  NE2 GLN B 140      32.205  66.675  31.569  1.00 20.50           N  
ATOM   3060  N   HIS B 141      31.652  61.247  28.074  1.00 15.40           N  
ATOM   3061  CA  HIS B 141      30.963  60.494  27.031  1.00 15.58           C  
ATOM   3062  C   HIS B 141      31.447  59.047  27.021  1.00 15.21           C  
ATOM   3063  O   HIS B 141      30.663  58.108  26.738  1.00 16.92           O  
ATOM   3064  CB  HIS B 141      31.312  61.072  25.651  1.00 15.96           C  
ATOM   3065  CG  HIS B 141      30.522  62.286  25.289  1.00 16.65           C  
ATOM   3066  ND1 HIS B 141      29.419  62.704  26.009  1.00 22.86           N  
ATOM   3067  CD2 HIS B 141      30.678  63.179  24.293  1.00 17.02           C  
ATOM   3068  CE1 HIS B 141      28.918  63.790  25.456  1.00 17.62           C  
ATOM   3069  NE2 HIS B 141      29.649  64.086  24.396  1.00 21.39           N  
ATOM   3070  N   ARG B 142      32.748  58.849  27.258  1.00 14.28           N  
ATOM   3071  CA  ARG B 142      33.275  57.479  27.250  1.00 13.54           C  
ATOM   3072  C   ARG B 142      32.707  56.763  28.447  1.00 13.86           C  
ATOM   3073  O   ARG B 142      32.336  55.627  28.341  1.00 15.17           O  
ATOM   3074  CB  ARG B 142      34.824  57.425  27.220  1.00 13.28           C  
ATOM   3075  CG  ARG B 142      35.469  57.855  25.800  1.00 12.33           C  
ATOM   3076  CD  ARG B 142      37.022  58.111  25.913  1.00 14.18           C  
ATOM   3077  NE  ARG B 142      37.412  58.957  24.790  1.00 18.20           N  
ATOM   3078  CZ  ARG B 142      38.573  59.555  24.624  1.00 13.40           C  
ATOM   3079  NH1 ARG B 142      39.585  59.320  25.466  1.00 13.56           N  
ATOM   3080  NH2 ARG B 142      38.732  60.335  23.554  1.00 17.23           N  
ATOM   3081  N   GLU B 143      32.610  57.441  29.588  1.00 13.26           N  
ATOM   3082  CA  GLU B 143      31.991  56.837  30.776  1.00 13.26           C  
ATOM   3083  C   GLU B 143      30.500  56.491  30.582  1.00 14.29           C  
ATOM   3084  O   GLU B 143      30.104  55.426  30.991  1.00 13.69           O  
ATOM   3085  CB  GLU B 143      32.241  57.708  32.027  1.00 12.01           C  
ATOM   3086  CG  GLU B 143      31.682  57.137  33.317  1.00 15.12           C  
ATOM   3087  CD  GLU B 143      32.112  57.856  34.602  1.00 16.84           C  
ATOM   3088  OE1 GLU B 143      33.310  58.068  34.851  1.00 18.67           O  
ATOM   3089  OE2 GLU B 143      31.235  58.169  35.435  1.00 22.41           O  
ATOM   3090  N   SER B 144      29.700  57.368  29.924  1.00 15.43           N  
ATOM   3091  CA  SER B 144      28.247  57.151  29.758  1.00 16.99           C  
ATOM   3092  C   SER B 144      28.095  56.035  28.806  1.00 15.87           C  
ATOM   3093  O   SER B 144      27.287  55.177  29.017  1.00 17.73           O  
ATOM   3094  CB  SER B 144      27.509  58.294  28.994  1.00 17.19           C  
ATOM   3095  OG  SER B 144      27.713  59.547  29.509  1.00 22.70           O  
ATOM   3096  N   GLY B 145      28.806  56.136  27.682  1.00 17.15           N  
ATOM   3097  CA  GLY B 145      28.774  55.139  26.635  1.00 16.78           C  
ATOM   3098  C   GLY B 145      29.026  53.768  27.280  1.00 18.26           C  
ATOM   3099  O   GLY B 145      28.254  52.846  27.048  1.00 19.92           O  
ATOM   3100  N   TYR B 146      30.075  53.645  28.118  1.00 16.62           N  
ATOM   3101  CA  TYR B 146      30.406  52.389  28.827  1.00 14.43           C  
ATOM   3102  C   TYR B 146      29.227  51.946  29.739  1.00 15.32           C  
ATOM   3103  O   TYR B 146      28.798  50.826  29.686  1.00 14.53           O  
ATOM   3104  CB  TYR B 146      31.666  52.596  29.704  1.00 12.72           C  
ATOM   3105  CG  TYR B 146      31.878  51.658  30.879  1.00 12.91           C  
ATOM   3106  CD1 TYR B 146      31.589  52.078  32.198  1.00 10.13           C  
ATOM   3107  CD2 TYR B 146      32.455  50.396  30.706  1.00 14.74           C  
ATOM   3108  CE1 TYR B 146      31.776  51.249  33.293  1.00  9.03           C  
ATOM   3109  CE2 TYR B 146      32.692  49.561  31.819  1.00 10.94           C  
ATOM   3110  CZ  TYR B 146      32.301  49.999  33.113  1.00 11.91           C  
ATOM   3111  OH  TYR B 146      32.497  49.198  34.222  1.00 15.00           O  
ATOM   3112  N   LEU B 147      28.721  52.831  30.588  1.00 18.01           N  
ATOM   3113  CA  LEU B 147      27.712  52.426  31.593  1.00 18.36           C  
ATOM   3114  C   LEU B 147      26.380  52.044  30.922  1.00 19.69           C  
ATOM   3115  O   LEU B 147      25.764  51.020  31.246  1.00 19.73           O  
ATOM   3116  CB  LEU B 147      27.431  53.598  32.484  1.00 18.70           C  
ATOM   3117  CG  LEU B 147      28.465  53.884  33.559  1.00 18.85           C  
ATOM   3118  CD1 LEU B 147      28.044  55.182  34.275  1.00 20.43           C  
ATOM   3119  CD2 LEU B 147      28.452  52.714  34.464  1.00 14.64           C  
ATOM   3120  N   ASN B 148      25.963  52.851  29.950  1.00 19.93           N  
ATOM   3121  CA  ASN B 148      24.735  52.569  29.192  1.00 20.42           C  
ATOM   3122  C   ASN B 148      24.808  51.293  28.398  1.00 20.41           C  
ATOM   3123  O   ASN B 148      23.793  50.581  28.256  1.00 20.86           O  
ATOM   3124  CB  ASN B 148      24.349  53.716  28.241  1.00 20.77           C  
ATOM   3125  CG  ASN B 148      24.105  55.012  28.971  1.00 24.54           C  
ATOM   3126  OD1 ASN B 148      23.787  55.016  30.156  1.00 26.26           O  
ATOM   3127  ND2 ASN B 148      24.274  56.128  28.267  1.00 26.61           N  
ATOM   3128  N   ARG B 149      25.964  50.988  27.839  1.00 18.19           N  
ATOM   3129  CA  ARG B 149      26.044  49.798  26.988  1.00 17.03           C  
ATOM   3130  C   ARG B 149      26.100  48.533  27.820  1.00 16.93           C  
ATOM   3131  O   ARG B 149      25.606  47.477  27.437  1.00 17.15           O  
ATOM   3132  CB  ARG B 149      27.245  49.941  26.052  1.00 17.86           C  
ATOM   3133  CG  ARG B 149      27.108  49.223  24.765  1.00 17.74           C  
ATOM   3134  CD  ARG B 149      26.003  49.839  23.906  1.00 19.52           C  
ATOM   3135  NE  ARG B 149      25.794  49.047  22.708  1.00 19.35           N  
ATOM   3136  CZ  ARG B 149      24.720  49.164  21.955  1.00 22.67           C  
ATOM   3137  NH1 ARG B 149      23.810  50.054  22.293  1.00 22.15           N  
ATOM   3138  NH2 ARG B 149      24.553  48.392  20.892  1.00 22.61           N  
ATOM   3139  N   LEU B 150      26.650  48.617  29.019  1.00 17.75           N  
ATOM   3140  CA  LEU B 150      26.582  47.459  29.933  1.00 17.34           C  
ATOM   3141  C   LEU B 150      25.147  47.127  30.277  1.00 16.97           C  
ATOM   3142  O   LEU B 150      24.805  45.960  30.338  1.00 15.49           O  
ATOM   3143  CB  LEU B 150      27.387  47.640  31.234  1.00 16.85           C  
ATOM   3144  CG  LEU B 150      28.917  47.835  31.131  1.00 20.47           C  
ATOM   3145  CD1 LEU B 150      29.550  47.964  32.542  1.00 17.38           C  
ATOM   3146  CD2 LEU B 150      29.564  46.707  30.347  1.00 21.82           C  
ATOM   3147  N   LYS B 151      24.350  48.158  30.578  1.00 16.96           N  
ATOM   3148  CA  LYS B 151      22.942  48.005  30.981  1.00 16.82           C  
ATOM   3149  C   LYS B 151      22.188  47.524  29.755  1.00 15.99           C  
ATOM   3150  O   LYS B 151      21.240  46.751  29.854  1.00 16.98           O  
ATOM   3151  CB  LYS B 151      22.310  49.343  31.389  1.00 16.76           C  
ATOM   3152  CG  LYS B 151      22.809  50.102  32.655  1.00 25.12           C  
ATOM   3153  CD  LYS B 151      23.056  49.150  33.802  1.00 33.31           C  
ATOM   3154  CE  LYS B 151      24.583  48.871  33.995  1.00 37.34           C  
ATOM   3155  NZ  LYS B 151      24.970  47.785  35.000  1.00 36.12           N  
ATOM   3156  N   PHE B 152      22.572  48.029  28.591  1.00 15.21           N  
ATOM   3157  CA  PHE B 152      21.963  47.546  27.369  1.00 15.29           C  
ATOM   3158  C   PHE B 152      22.134  46.041  27.175  1.00 15.60           C  
ATOM   3159  O   PHE B 152      21.292  45.367  26.597  1.00 13.75           O  
ATOM   3160  CB  PHE B 152      22.570  48.267  26.184  1.00 15.50           C  
ATOM   3161  CG  PHE B 152      22.155  47.726  24.880  1.00 13.75           C  
ATOM   3162  CD1 PHE B 152      20.916  48.084  24.323  1.00 15.50           C  
ATOM   3163  CD2 PHE B 152      23.013  46.974  24.155  1.00 15.17           C  
ATOM   3164  CE1 PHE B 152      20.548  47.617  23.061  1.00 17.04           C  
ATOM   3165  CE2 PHE B 152      22.656  46.501  22.903  1.00 11.97           C  
ATOM   3166  CZ  PHE B 152      21.430  46.811  22.359  1.00 17.85           C  
ATOM   3167  N   HIS B 153      23.266  45.526  27.615  1.00 16.85           N  
ATOM   3168  CA  HIS B 153      23.528  44.075  27.511  1.00 17.25           C  
ATOM   3169  C   HIS B 153      23.096  43.329  28.767  1.00 17.10           C  
ATOM   3170  O   HIS B 153      23.376  42.166  28.937  1.00 17.20           O  
ATOM   3171  CB  HIS B 153      25.019  43.832  27.223  1.00 15.94           C  
ATOM   3172  CG  HIS B 153      25.414  44.179  25.819  1.00 15.37           C  
ATOM   3173  ND1 HIS B 153      24.880  43.543  24.716  1.00 14.06           N  
ATOM   3174  CD2 HIS B 153      26.266  45.122  25.341  1.00 14.09           C  
ATOM   3175  CE1 HIS B 153      25.421  44.056  23.621  1.00 16.36           C  
ATOM   3176  NE2 HIS B 153      26.251  45.027  23.969  1.00 15.44           N  
ATOM   3177  N   GLY B 154      22.441  44.034  29.672  1.00 17.52           N  
ATOM   3178  CA  GLY B 154      21.957  43.404  30.889  1.00 16.27           C  
ATOM   3179  C   GLY B 154      23.046  42.832  31.777  1.00 16.53           C  
ATOM   3180  O   GLY B 154      22.810  41.866  32.432  1.00 15.71           O  
ATOM   3181  N   LEU B 155      24.254  43.404  31.739  1.00 17.71           N  
ATOM   3182  CA  LEU B 155      25.357  42.950  32.557  1.00 19.10           C  
ATOM   3183  C   LEU B 155      25.174  43.479  33.981  1.00 20.00           C  
ATOM   3184  O   LEU B 155      24.822  44.614  34.190  1.00 20.54           O  
ATOM   3185  CB  LEU B 155      26.711  43.354  31.940  1.00 19.12           C  
ATOM   3186  CG  LEU B 155      26.908  42.913  30.453  1.00 21.06           C  
ATOM   3187  CD1 LEU B 155      28.164  43.374  29.788  1.00 20.59           C  
ATOM   3188  CD2 LEU B 155      26.866  41.392  30.301  1.00 20.29           C  
ATOM   3189  N   ASP B 156      25.457  42.658  34.975  1.00 20.68           N  
ATOM   3190  CA  ASP B 156      25.316  43.108  36.353  1.00 22.10           C  
ATOM   3191  C   ASP B 156      26.554  43.907  36.873  1.00 22.66           C  
ATOM   3192  O   ASP B 156      26.436  44.831  37.711  1.00 23.63           O  
ATOM   3193  CB  ASP B 156      25.082  41.887  37.208  1.00 24.37           C  
ATOM   3194  CG  ASP B 156      24.534  42.251  38.611  1.00 31.13           C  
ATOM   3195  OD1 ASP B 156      24.201  43.449  38.885  1.00 33.37           O  
ATOM   3196  OD2 ASP B 156      24.453  41.328  39.430  1.00 36.42           O  
ATOM   3197  N   TYR B 157      27.726  43.597  36.343  1.00 20.67           N  
ATOM   3198  CA  TYR B 157      28.974  44.214  36.808  1.00 20.12           C  
ATOM   3199  C   TYR B 157      29.232  45.542  36.127  1.00 20.06           C  
ATOM   3200  O   TYR B 157      29.211  45.665  34.859  1.00 18.43           O  
ATOM   3201  CB  TYR B 157      30.160  43.271  36.534  1.00 19.32           C  
ATOM   3202  CG  TYR B 157      31.554  43.765  36.904  1.00 18.25           C  
ATOM   3203  CD1 TYR B 157      32.198  43.304  38.044  1.00 17.63           C  
ATOM   3204  CD2 TYR B 157      32.255  44.632  36.066  1.00 18.75           C  
ATOM   3205  CE1 TYR B 157      33.486  43.733  38.369  1.00 18.79           C  
ATOM   3206  CE2 TYR B 157      33.505  45.087  36.383  1.00 17.43           C  
ATOM   3207  CZ  TYR B 157      34.129  44.628  37.535  1.00 17.56           C  
ATOM   3208  OH  TYR B 157      35.393  45.040  37.823  1.00 17.74           O  
ATOM   3209  N   SER B 158      29.553  46.496  36.988  1.00 19.75           N  
ATOM   3210  CA  SER B 158      29.949  47.807  36.601  1.00 20.04           C  
ATOM   3211  C   SER B 158      31.060  48.210  37.514  1.00 20.53           C  
ATOM   3212  O   SER B 158      30.952  48.010  38.767  1.00 18.88           O  
ATOM   3213  CB  SER B 158      28.813  48.778  36.912  1.00 19.68           C  
ATOM   3214  OG  SER B 158      28.718  49.652  35.869  1.00 25.41           O  
ATOM   3215  N   ARG B 159      32.131  48.757  36.918  1.00 19.25           N  
ATOM   3216  CA  ARG B 159      33.063  49.491  37.706  1.00 19.30           C  
ATOM   3217  C   ARG B 159      34.060  50.415  37.125  1.00 19.22           C  
ATOM   3218  O   ARG B 159      34.683  50.128  36.102  1.00 18.31           O  
ATOM   3219  CB  ARG B 159      33.357  48.917  39.063  1.00 22.80           C  
ATOM   3220  CG  ARG B 159      34.550  48.098  39.403  1.00 22.52           C  
ATOM   3221  CD  ARG B 159      34.376  47.929  40.968  1.00 26.19           C  
ATOM   3222  NE  ARG B 159      34.141  46.520  41.358  1.00 30.12           N  
ATOM   3223  CZ  ARG B 159      32.943  45.914  41.425  1.00 35.08           C  
ATOM   3224  NH1 ARG B 159      32.876  44.627  41.765  1.00 35.29           N  
ATOM   3225  NH2 ARG B 159      31.815  46.563  41.129  1.00 34.21           N  
ATOM   3226  N   ILE B 160      34.256  51.516  37.827  1.00 17.26           N  
ATOM   3227  CA  ILE B 160      35.066  52.589  37.288  1.00 16.54           C  
ATOM   3228  C   ILE B 160      36.117  52.962  38.294  1.00 17.58           C  
ATOM   3229  O   ILE B 160      35.814  53.151  39.509  1.00 16.67           O  
ATOM   3230  CB  ILE B 160      34.189  53.815  37.012  1.00 16.33           C  
ATOM   3231  CG1 ILE B 160      33.093  53.430  36.050  1.00 15.41           C  
ATOM   3232  CG2 ILE B 160      35.032  55.006  36.483  1.00 12.92           C  
ATOM   3233  CD1 ILE B 160      31.902  54.411  35.960  1.00 16.95           C  
ATOM   3234  N   SER B 161      37.347  53.085  37.816  1.00 15.14           N  
ATOM   3235  CA  SER B 161      38.373  53.520  38.715  1.00 16.81           C  
ATOM   3236  C   SER B 161      39.041  54.728  38.058  1.00 16.94           C  
ATOM   3237  O   SER B 161      39.207  54.735  36.845  1.00 17.97           O  
ATOM   3238  CB  SER B 161      39.349  52.351  38.866  1.00 16.88           C  
ATOM   3239  OG  SER B 161      40.505  52.745  39.543  1.00 19.93           O  
ATOM   3240  N   TYR B 162      39.398  55.756  38.820  1.00 16.73           N  
ATOM   3241  CA  TYR B 162      39.816  57.005  38.192  1.00 18.41           C  
ATOM   3242  C   TYR B 162      41.292  57.170  38.342  1.00 19.14           C  
ATOM   3243  O   TYR B 162      41.849  57.094  39.455  1.00 18.27           O  
ATOM   3244  CB  TYR B 162      39.061  58.245  38.734  1.00 19.15           C  
ATOM   3245  CG  TYR B 162      37.589  58.229  38.388  1.00 19.80           C  
ATOM   3246  CD1 TYR B 162      37.153  58.754  37.188  1.00 17.13           C  
ATOM   3247  CD2 TYR B 162      36.628  57.676  39.261  1.00 20.80           C  
ATOM   3248  CE1 TYR B 162      35.834  58.729  36.834  1.00 19.99           C  
ATOM   3249  CE2 TYR B 162      35.245  57.669  38.915  1.00 18.30           C  
ATOM   3250  CZ  TYR B 162      34.877  58.201  37.680  1.00 21.00           C  
ATOM   3251  OH  TYR B 162      33.573  58.205  37.201  1.00 20.82           O  
ATOM   3252  N   ALA B 163      41.969  57.341  37.213  1.00 17.73           N  
ATOM   3253  CA  ALA B 163      43.401  57.556  37.326  1.00 18.63           C  
ATOM   3254  C   ALA B 163      43.641  59.001  37.701  1.00 18.29           C  
ATOM   3255  O   ALA B 163      43.078  59.871  37.099  1.00 19.97           O  
ATOM   3256  CB  ALA B 163      44.112  57.193  36.000  1.00 16.99           C  
ATOM   3257  N   GLU B 164      44.512  59.296  38.653  1.00 19.98           N  
ATOM   3258  CA  GLU B 164      44.727  60.728  38.961  1.00 21.18           C  
ATOM   3259  C   GLU B 164      45.562  61.436  37.909  1.00 20.39           C  
ATOM   3260  O   GLU B 164      45.254  62.561  37.477  1.00 20.71           O  
ATOM   3261  CB  GLU B 164      45.345  60.959  40.336  1.00 21.80           C  
ATOM   3262  CG  GLU B 164      45.819  62.403  40.458  1.00 28.05           C  
ATOM   3263  CD  GLU B 164      45.848  62.931  41.881  1.00 36.83           C  
ATOM   3264  OE1 GLU B 164      46.535  62.324  42.737  1.00 42.04           O  
ATOM   3265  OE2 GLU B 164      45.213  63.980  42.133  1.00 38.81           O  
ATOM   3266  N   ASN B 165      46.620  60.784  37.478  1.00 18.05           N  
ATOM   3267  CA  ASN B 165      47.464  61.364  36.429  1.00 17.29           C  
ATOM   3268  C   ASN B 165      47.367  60.585  35.150  1.00 16.94           C  
ATOM   3269  O   ASN B 165      46.883  59.486  35.173  1.00 15.20           O  
ATOM   3270  CB  ASN B 165      48.885  61.348  36.918  1.00 18.00           C  
ATOM   3271  CG  ASN B 165      49.045  62.188  38.150  1.00 19.69           C  
ATOM   3272  OD1 ASN B 165      48.730  63.357  38.143  1.00 25.59           O  
ATOM   3273  ND2 ASN B 165      49.472  61.586  39.224  1.00 25.92           N  
ATOM   3274  N   LEU B 166      47.835  61.153  34.032  1.00 17.13           N  
ATOM   3275  CA  LEU B 166      47.873  60.408  32.827  1.00 16.64           C  
ATOM   3276  C   LEU B 166      49.267  59.780  32.684  1.00 17.65           C  
ATOM   3277  O   LEU B 166      50.121  60.291  31.973  1.00 18.67           O  
ATOM   3278  CB  LEU B 166      47.484  61.284  31.586  1.00 17.50           C  
ATOM   3279  CG  LEU B 166      47.261  60.365  30.376  1.00 16.61           C  
ATOM   3280  CD1 LEU B 166      45.915  59.740  30.436  1.00 18.62           C  
ATOM   3281  CD2 LEU B 166      47.506  61.073  29.037  1.00 22.51           C  
ATOM   3282  N   ASP B 167      49.498  58.653  33.340  1.00 17.74           N  
ATOM   3283  CA  ASP B 167      50.765  57.947  33.192  1.00 17.05           C  
ATOM   3284  C   ASP B 167      50.577  56.500  33.534  1.00 16.75           C  
ATOM   3285  O   ASP B 167      49.544  56.139  34.076  1.00 15.39           O  
ATOM   3286  CB  ASP B 167      51.916  58.598  34.006  1.00 17.98           C  
ATOM   3287  CG  ASP B 167      51.670  58.645  35.503  1.00 19.77           C  
ATOM   3288  OD1 ASP B 167      50.945  57.820  36.053  1.00 19.98           O  
ATOM   3289  OD2 ASP B 167      52.273  59.519  36.150  1.00 22.65           O  
ATOM   3290  N   TYR B 168      51.576  55.668  33.226  1.00 16.90           N  
ATOM   3291  CA  TYR B 168      51.406  54.221  33.316  1.00 17.74           C  
ATOM   3292  C   TYR B 168      51.202  53.814  34.795  1.00 16.88           C  
ATOM   3293  O   TYR B 168      50.417  52.953  35.070  1.00 16.72           O  
ATOM   3294  CB  TYR B 168      52.578  53.483  32.649  1.00 18.94           C  
ATOM   3295  CG  TYR B 168      53.697  53.196  33.603  1.00 22.80           C  
ATOM   3296  CD1 TYR B 168      53.761  51.976  34.307  1.00 24.62           C  
ATOM   3297  CD2 TYR B 168      54.676  54.146  33.843  1.00 25.80           C  
ATOM   3298  CE1 TYR B 168      54.768  51.726  35.217  1.00 27.78           C  
ATOM   3299  CE2 TYR B 168      55.716  53.894  34.741  1.00 28.01           C  
ATOM   3300  CZ  TYR B 168      55.754  52.695  35.415  1.00 27.74           C  
ATOM   3301  OH  TYR B 168      56.791  52.475  36.283  1.00 29.02           O  
ATOM   3302  N   MET B 169      51.867  54.481  35.716  1.00 16.53           N  
ATOM   3303  CA  MET B 169      51.711  54.189  37.129  1.00 18.22           C  
ATOM   3304  C   MET B 169      50.280  54.403  37.558  1.00 17.76           C  
ATOM   3305  O   MET B 169      49.749  53.605  38.354  1.00 20.55           O  
ATOM   3306  CB  MET B 169      52.668  55.049  38.010  1.00 18.20           C  
ATOM   3307  CG  MET B 169      52.573  54.700  39.524  1.00 22.25           C  
ATOM   3308  SD  MET B 169      52.887  52.950  39.895  1.00 20.99           S  
ATOM   3309  CE  MET B 169      54.278  52.475  38.757  1.00 10.10           C  
ATOM   3310  N   ALA B 170      49.643  55.487  37.059  1.00 16.63           N  
ATOM   3311  CA  ALA B 170      48.256  55.715  37.383  1.00 14.98           C  
ATOM   3312  C   ALA B 170      47.395  54.583  36.872  1.00 13.76           C  
ATOM   3313  O   ALA B 170      46.450  54.193  37.520  1.00 12.95           O  
ATOM   3314  CB  ALA B 170      47.791  56.996  36.823  1.00 15.80           C  
ATOM   3315  N   GLY B 171      47.712  54.059  35.696  1.00 13.22           N  
ATOM   3316  CA  GLY B 171      46.969  52.933  35.134  1.00 13.38           C  
ATOM   3317  C   GLY B 171      47.074  51.666  36.009  1.00 13.55           C  
ATOM   3318  O   GLY B 171      46.129  50.874  36.150  1.00 13.56           O  
ATOM   3319  N   LYS B 172      48.273  51.467  36.528  1.00 12.54           N  
ATOM   3320  CA  LYS B 172      48.675  50.298  37.240  1.00 14.95           C  
ATOM   3321  C   LYS B 172      47.938  50.353  38.583  1.00 14.24           C  
ATOM   3322  O   LYS B 172      47.320  49.366  38.991  1.00 16.03           O  
ATOM   3323  CB  LYS B 172      50.217  50.391  37.432  1.00 14.16           C  
ATOM   3324  CG  LYS B 172      50.872  49.162  37.849  1.00 20.43           C  
ATOM   3325  CD  LYS B 172      52.411  49.194  37.715  1.00 17.48           C  
ATOM   3326  CE  LYS B 172      52.921  47.968  38.468  1.00 27.23           C  
ATOM   3327  NZ  LYS B 172      54.377  47.850  38.301  1.00 23.34           N  
ATOM   3328  N   LEU B 173      47.961  51.519  39.224  1.00 14.88           N  
ATOM   3329  CA  LEU B 173      47.208  51.766  40.462  1.00 14.57           C  
ATOM   3330  C   LEU B 173      45.655  51.626  40.337  1.00 16.87           C  
ATOM   3331  O   LEU B 173      44.989  50.984  41.192  1.00 16.81           O  
ATOM   3332  CB  LEU B 173      47.541  53.157  40.945  1.00 15.15           C  
ATOM   3333  CG  LEU B 173      49.014  53.327  41.253  1.00 16.05           C  
ATOM   3334  CD1 LEU B 173      49.326  54.814  41.617  1.00 18.75           C  
ATOM   3335  CD2 LEU B 173      49.364  52.421  42.418  1.00 20.82           C  
ATOM   3336  N   ALA B 174      45.073  52.248  39.311  1.00 15.33           N  
ATOM   3337  CA  ALA B 174      43.706  51.994  38.947  1.00 15.00           C  
ATOM   3338  C   ALA B 174      43.437  50.458  38.835  1.00 14.65           C  
ATOM   3339  O   ALA B 174      42.452  49.948  39.322  1.00 15.62           O  
ATOM   3340  CB  ALA B 174      43.374  52.690  37.599  1.00 13.98           C  
ATOM   3341  N   THR B 175      44.311  49.725  38.175  1.00 14.27           N  
ATOM   3342  CA  THR B 175      44.115  48.323  38.008  1.00 12.95           C  
ATOM   3343  C   THR B 175      44.181  47.545  39.326  1.00 13.50           C  
ATOM   3344  O   THR B 175      43.341  46.699  39.580  1.00 13.39           O  
ATOM   3345  CB  THR B 175      45.081  47.767  36.956  1.00 13.70           C  
ATOM   3346  OG1 THR B 175      44.857  48.486  35.719  1.00 14.11           O  
ATOM   3347  CG2 THR B 175      44.895  46.287  36.804  1.00 13.41           C  
ATOM   3348  N   PHE B 176      45.170  47.815  40.146  1.00 13.57           N  
ATOM   3349  CA  PHE B 176      45.246  47.145  41.439  1.00 15.45           C  
ATOM   3350  C   PHE B 176      43.951  47.399  42.216  1.00 14.61           C  
ATOM   3351  O   PHE B 176      43.360  46.485  42.738  1.00 16.77           O  
ATOM   3352  CB  PHE B 176      46.513  47.559  42.216  1.00 13.66           C  
ATOM   3353  CG  PHE B 176      47.788  46.912  41.669  1.00 18.05           C  
ATOM   3354  CD1 PHE B 176      47.887  45.553  41.532  1.00 17.42           C  
ATOM   3355  CD2 PHE B 176      48.871  47.691  41.237  1.00 14.96           C  
ATOM   3356  CE1 PHE B 176      49.030  44.988  41.017  1.00 16.56           C  
ATOM   3357  CE2 PHE B 176      50.022  47.110  40.757  1.00 14.71           C  
ATOM   3358  CZ  PHE B 176      50.106  45.805  40.633  1.00 17.35           C  
ATOM   3359  N   SER B 177      43.439  48.601  42.164  1.00 16.18           N  
ATOM   3360  CA  SER B 177      42.196  48.938  42.856  1.00 17.23           C  
ATOM   3361  C   SER B 177      41.016  48.098  42.364  1.00 18.20           C  
ATOM   3362  O   SER B 177      40.192  47.691  43.182  1.00 19.24           O  
ATOM   3363  CB  SER B 177      41.911  50.416  42.646  1.00 18.60           C  
ATOM   3364  OG  SER B 177      40.695  50.792  43.296  1.00 19.02           O  
ATOM   3365  N   LEU B 178      40.944  47.790  41.053  1.00 16.70           N  
ATOM   3366  CA  LEU B 178      39.823  46.985  40.482  1.00 16.69           C  
ATOM   3367  C   LEU B 178      39.959  45.507  40.774  1.00 17.70           C  
ATOM   3368  O   LEU B 178      38.967  44.771  40.850  1.00 16.36           O  
ATOM   3369  CB  LEU B 178      39.732  47.144  38.954  1.00 15.13           C  
ATOM   3370  CG  LEU B 178      39.439  48.541  38.368  1.00 16.80           C  
ATOM   3371  CD1 LEU B 178      39.829  48.537  36.907  1.00 16.20           C  
ATOM   3372  CD2 LEU B 178      37.988  48.940  38.536  1.00 17.72           C  
ATOM   3373  N   LEU B 179      41.199  45.068  40.940  1.00 18.28           N  
ATOM   3374  CA  LEU B 179      41.465  43.695  41.281  1.00 19.74           C  
ATOM   3375  C   LEU B 179      41.158  43.455  42.742  1.00 21.74           C  
ATOM   3376  O   LEU B 179      40.935  42.318  43.118  1.00 20.70           O  
ATOM   3377  CB  LEU B 179      42.910  43.323  41.000  1.00 18.81           C  
ATOM   3378  CG  LEU B 179      43.215  43.374  39.482  1.00 19.00           C  
ATOM   3379  CD1 LEU B 179      44.689  43.092  39.182  1.00 15.32           C  
ATOM   3380  CD2 LEU B 179      42.337  42.379  38.761  1.00 16.26           C  
ATOM   3381  N   LYS B 180      41.166  44.512  43.560  1.00 23.60           N  
ATOM   3382  CA  LYS B 180      40.926  44.339  45.002  1.00 26.35           C  
ATOM   3383  C   LYS B 180      39.440  44.396  45.260  1.00 27.21           C  
ATOM   3384  O   LYS B 180      38.908  45.429  45.676  1.00 28.38           O  
ATOM   3385  CB  LYS B 180      41.619  45.442  45.807  1.00 26.52           C  
ATOM   3386  CG  LYS B 180      42.909  45.022  46.462  1.00 28.65           C  
ATOM   3387  CD  LYS B 180      43.371  46.152  47.444  1.00 28.67           C  
ATOM   3388  CE  LYS B 180      44.464  45.623  48.466  1.00 31.11           C  
ATOM   3389  NZ  LYS B 180      44.905  46.645  49.481  1.00 22.22           N  
ATOM   3390  N   SER B 181      38.739  43.318  44.966  1.00 27.96           N  
ATOM   3391  CA  SER B 181      37.286  43.350  45.113  1.00 28.44           C  
ATOM   3392  C   SER B 181      36.771  41.972  45.055  1.00 28.08           C  
ATOM   3393  O   SER B 181      37.464  41.097  44.540  1.00 26.98           O  
ATOM   3394  CB  SER B 181      36.611  44.174  44.027  1.00 28.76           C  
ATOM   3395  OG  SER B 181      35.316  43.684  43.823  1.00 33.08           O  
ATOM   3396  N   ALA B 182      35.557  41.800  45.596  1.00 28.38           N  
ATOM   3397  CA  ALA B 182      34.857  40.499  45.664  1.00 27.66           C  
ATOM   3398  C   ALA B 182      34.851  39.852  44.293  1.00 26.61           C  
ATOM   3399  O   ALA B 182      35.277  38.697  44.133  1.00 26.95           O  
ATOM   3400  CB  ALA B 182      33.424  40.696  46.152  1.00 27.66           C  
ATOM   3401  N   VAL B 183      34.358  40.606  43.327  1.00 25.09           N  
ATOM   3402  CA  VAL B 183      34.309  40.191  41.922  1.00 23.96           C  
ATOM   3403  C   VAL B 183      35.360  40.973  41.160  1.00 22.00           C  
ATOM   3404  O   VAL B 183      35.361  42.201  41.199  1.00 21.19           O  
ATOM   3405  CB  VAL B 183      32.904  40.428  41.307  1.00 24.32           C  
ATOM   3406  CG1 VAL B 183      32.863  39.953  39.840  1.00 25.30           C  
ATOM   3407  CG2 VAL B 183      31.860  39.672  42.083  1.00 25.84           C  
ATOM   3408  N   LYS B 184      36.263  40.258  40.500  1.00 21.75           N  
ATOM   3409  CA  LYS B 184      37.281  40.857  39.636  1.00 23.22           C  
ATOM   3410  C   LYS B 184      36.825  41.048  38.163  1.00 21.10           C  
ATOM   3411  O   LYS B 184      35.951  40.310  37.676  1.00 20.95           O  
ATOM   3412  CB  LYS B 184      38.538  40.003  39.690  1.00 23.30           C  
ATOM   3413  CG  LYS B 184      38.628  39.303  40.992  1.00 29.68           C  
ATOM   3414  CD  LYS B 184      39.715  39.822  41.855  1.00 36.51           C  
ATOM   3415  CE  LYS B 184      40.758  38.726  41.923  1.00 40.03           C  
ATOM   3416  NZ  LYS B 184      41.864  39.134  42.807  1.00 41.74           N  
ATOM   3417  N   PRO B 185      37.430  42.010  37.448  1.00 19.71           N  
ATOM   3418  CA  PRO B 185      36.966  42.115  36.098  1.00 18.72           C  
ATOM   3419  C   PRO B 185      37.525  40.997  35.238  1.00 18.11           C  
ATOM   3420  O   PRO B 185      38.544  40.359  35.598  1.00 15.49           O  
ATOM   3421  CB  PRO B 185      37.516  43.475  35.638  1.00 19.24           C  
ATOM   3422  CG  PRO B 185      38.764  43.630  36.356  1.00 21.02           C  
ATOM   3423  CD  PRO B 185      38.481  43.004  37.749  1.00 19.24           C  
ATOM   3424  N   ASP B 186      36.825  40.697  34.149  1.00 17.40           N  
ATOM   3425  CA  ASP B 186      37.424  39.899  33.117  1.00 16.37           C  
ATOM   3426  C   ASP B 186      37.827  40.793  31.934  1.00 15.83           C  
ATOM   3427  O   ASP B 186      38.245  40.282  30.889  1.00 15.78           O  
ATOM   3428  CB  ASP B 186      36.488  38.729  32.670  1.00 17.26           C  
ATOM   3429  CG  ASP B 186      35.117  39.202  32.154  1.00 19.33           C  
ATOM   3430  OD1 ASP B 186      34.948  40.425  31.950  1.00 21.42           O  
ATOM   3431  OD2 ASP B 186      34.182  38.356  31.984  1.00 21.07           O  
ATOM   3432  N   ALA B 187      37.680  42.114  32.059  1.00 14.64           N  
ATOM   3433  CA  ALA B 187      38.113  43.017  30.993  1.00 13.72           C  
ATOM   3434  C   ALA B 187      38.200  44.430  31.456  1.00 14.80           C  
ATOM   3435  O   ALA B 187      37.427  44.846  32.368  1.00 15.81           O  
ATOM   3436  CB  ALA B 187      37.220  42.924  29.773  1.00 14.18           C  
ATOM   3437  N   ILE B 188      39.213  45.129  30.935  1.00 13.38           N  
ATOM   3438  CA  ILE B 188      39.521  46.491  31.363  1.00 14.23           C  
ATOM   3439  C   ILE B 188      39.621  47.355  30.127  1.00 14.70           C  
ATOM   3440  O   ILE B 188      40.417  47.078  29.195  1.00 13.71           O  
ATOM   3441  CB  ILE B 188      40.814  46.607  32.245  1.00 15.41           C  
ATOM   3442  CG1 ILE B 188      40.609  45.957  33.635  1.00 15.72           C  
ATOM   3443  CG2 ILE B 188      41.082  48.055  32.546  1.00 15.94           C  
ATOM   3444  CD1 ILE B 188      41.860  45.867  34.483  1.00 13.02           C  
ATOM   3445  N   PHE B 189      38.766  48.376  30.106  1.00 13.77           N  
ATOM   3446  CA  PHE B 189      38.732  49.345  29.050  1.00 14.42           C  
ATOM   3447  C   PHE B 189      39.272  50.668  29.637  1.00 15.38           C  
ATOM   3448  O   PHE B 189      38.660  51.206  30.551  1.00 14.68           O  
ATOM   3449  CB  PHE B 189      37.270  49.534  28.617  1.00 14.18           C  
ATOM   3450  CG  PHE B 189      37.049  50.626  27.584  1.00 14.64           C  
ATOM   3451  CD1 PHE B 189      38.067  50.973  26.670  1.00 12.90           C  
ATOM   3452  CD2 PHE B 189      35.783  51.242  27.465  1.00 11.51           C  
ATOM   3453  CE1 PHE B 189      37.850  51.954  25.746  1.00 11.48           C  
ATOM   3454  CE2 PHE B 189      35.550  52.233  26.515  1.00 16.59           C  
ATOM   3455  CZ  PHE B 189      36.579  52.581  25.643  1.00 13.15           C  
ATOM   3456  N   ALA B 190      40.439  51.126  29.142  1.00 15.74           N  
ATOM   3457  CA  ALA B 190      40.982  52.427  29.550  1.00 15.60           C  
ATOM   3458  C   ALA B 190      40.828  53.488  28.491  1.00 16.12           C  
ATOM   3459  O   ALA B 190      40.942  53.220  27.275  1.00 17.87           O  
ATOM   3460  CB  ALA B 190      42.422  52.306  30.007  1.00 15.75           C  
ATOM   3461  N   ILE B 191      40.602  54.693  28.987  1.00 15.80           N  
ATOM   3462  CA  ILE B 191      40.339  55.945  28.261  1.00 15.54           C  
ATOM   3463  C   ILE B 191      41.600  56.545  27.571  1.00 14.70           C  
ATOM   3464  O   ILE B 191      41.514  57.555  26.853  1.00 13.84           O  
ATOM   3465  CB  ILE B 191      39.709  56.883  29.312  1.00 17.17           C  
ATOM   3466  CG1 ILE B 191      38.202  56.945  29.174  1.00 17.60           C  
ATOM   3467  CG2 ILE B 191      40.479  58.141  29.668  1.00 14.45           C  
ATOM   3468  CD1 ILE B 191      37.644  55.675  28.845  1.00 22.05           C  
ATOM   3469  N   SER B 192      42.736  55.884  27.761  1.00 12.85           N  
ATOM   3470  CA  SER B 192      43.959  56.241  27.029  1.00 13.11           C  
ATOM   3471  C   SER B 192      44.859  55.004  26.955  1.00 13.16           C  
ATOM   3472  O   SER B 192      44.951  54.262  27.925  1.00 12.44           O  
ATOM   3473  CB  SER B 192      44.719  57.332  27.758  1.00 12.81           C  
ATOM   3474  OG  SER B 192      46.059  57.419  27.246  1.00 15.41           O  
ATOM   3475  N   ASP B 193      45.580  54.824  25.838  1.00 13.62           N  
ATOM   3476  CA  ASP B 193      46.596  53.794  25.758  1.00 12.74           C  
ATOM   3477  C   ASP B 193      47.646  53.894  26.880  1.00 12.61           C  
ATOM   3478  O   ASP B 193      48.188  52.916  27.250  1.00 12.10           O  
ATOM   3479  CB  ASP B 193      47.333  53.884  24.410  1.00 14.76           C  
ATOM   3480  CG  ASP B 193      46.435  53.588  23.242  1.00 15.17           C  
ATOM   3481  OD1 ASP B 193      45.414  52.893  23.440  1.00 15.89           O  
ATOM   3482  OD2 ASP B 193      46.782  53.952  22.114  1.00 20.51           O  
ATOM   3483  N   VAL B 194      47.942  55.080  27.386  1.00 12.32           N  
ATOM   3484  CA  VAL B 194      48.963  55.253  28.459  1.00 13.26           C  
ATOM   3485  C   VAL B 194      48.482  54.504  29.741  1.00 13.65           C  
ATOM   3486  O   VAL B 194      49.239  53.799  30.405  1.00 12.72           O  
ATOM   3487  CB  VAL B 194      49.191  56.739  28.754  1.00 14.53           C  
ATOM   3488  CG1 VAL B 194      50.151  56.932  29.919  1.00 15.03           C  
ATOM   3489  CG2 VAL B 194      49.764  57.464  27.525  1.00 15.44           C  
ATOM   3490  N   LEU B 195      47.216  54.675  30.066  1.00 13.13           N  
ATOM   3491  CA  LEU B 195      46.649  54.029  31.261  1.00 13.86           C  
ATOM   3492  C   LEU B 195      46.551  52.531  31.032  1.00 13.95           C  
ATOM   3493  O   LEU B 195      46.737  51.760  31.962  1.00 14.19           O  
ATOM   3494  CB  LEU B 195      45.269  54.632  31.530  1.00 12.64           C  
ATOM   3495  CG  LEU B 195      45.382  56.109  31.908  1.00 10.91           C  
ATOM   3496  CD1 LEU B 195      43.922  56.630  32.051  1.00 13.72           C  
ATOM   3497  CD2 LEU B 195      46.216  56.329  33.211  1.00 10.84           C  
ATOM   3498  N   ALA B 196      46.289  52.116  29.793  1.00 14.49           N  
ATOM   3499  CA  ALA B 196      46.100  50.675  29.472  1.00 14.65           C  
ATOM   3500  C   ALA B 196      47.440  49.944  29.558  1.00 15.46           C  
ATOM   3501  O   ALA B 196      47.512  48.782  29.974  1.00 16.32           O  
ATOM   3502  CB  ALA B 196      45.443  50.474  28.088  1.00 12.99           C  
ATOM   3503  N   ALA B 197      48.525  50.637  29.195  1.00 16.43           N  
ATOM   3504  CA  ALA B 197      49.858  50.035  29.289  1.00 16.37           C  
ATOM   3505  C   ALA B 197      50.166  49.696  30.748  1.00 15.72           C  
ATOM   3506  O   ALA B 197      50.807  48.686  31.033  1.00 14.85           O  
ATOM   3507  CB  ALA B 197      50.904  50.966  28.715  1.00 15.87           C  
ATOM   3508  N   GLY B 198      49.692  50.541  31.661  1.00 16.65           N  
ATOM   3509  CA  GLY B 198      49.853  50.323  33.110  1.00 14.65           C  
ATOM   3510  C   GLY B 198      48.924  49.221  33.574  1.00 14.95           C  
ATOM   3511  O   GLY B 198      49.262  48.408  34.454  1.00 12.86           O  
ATOM   3512  N   ALA B 199      47.747  49.148  32.956  1.00 13.92           N  
ATOM   3513  CA  ALA B 199      46.871  48.040  33.306  1.00 14.35           C  
ATOM   3514  C   ALA B 199      47.517  46.682  32.944  1.00 14.47           C  
ATOM   3515  O   ALA B 199      47.535  45.772  33.763  1.00 14.90           O  
ATOM   3516  CB  ALA B 199      45.498  48.232  32.708  1.00 12.56           C  
ATOM   3517  N   ILE B 200      48.086  46.577  31.746  1.00 15.47           N  
ATOM   3518  CA  ILE B 200      48.791  45.394  31.278  1.00 16.38           C  
ATOM   3519  C   ILE B 200      49.956  45.043  32.229  1.00 16.94           C  
ATOM   3520  O   ILE B 200      50.118  43.888  32.659  1.00 17.38           O  
ATOM   3521  CB  ILE B 200      49.348  45.626  29.838  1.00 17.39           C  
ATOM   3522  CG1 ILE B 200      48.188  45.704  28.835  1.00 15.82           C  
ATOM   3523  CG2 ILE B 200      50.379  44.536  29.484  1.00 18.07           C  
ATOM   3524  CD1 ILE B 200      48.577  45.746  27.291  1.00 18.76           C  
ATOM   3525  N   GLN B 201      50.731  46.039  32.620  1.00 15.04           N  
ATOM   3526  CA  GLN B 201      51.750  45.798  33.642  1.00 16.71           C  
ATOM   3527  C   GLN B 201      51.232  45.256  34.983  1.00 16.03           C  
ATOM   3528  O   GLN B 201      51.764  44.278  35.517  1.00 16.51           O  
ATOM   3529  CB  GLN B 201      52.556  47.047  33.905  1.00 17.47           C  
ATOM   3530  CG  GLN B 201      53.728  46.687  34.805  1.00 22.36           C  
ATOM   3531  CD  GLN B 201      54.821  47.700  34.857  1.00 23.50           C  
ATOM   3532  OE1 GLN B 201      55.121  48.250  35.924  1.00 21.88           O  
ATOM   3533  NE2 GLN B 201      55.504  47.880  33.730  1.00 25.67           N  
ATOM   3534  N   ALA B 202      50.206  45.860  35.563  1.00 16.19           N  
ATOM   3535  CA  ALA B 202      49.664  45.327  36.838  1.00 15.61           C  
ATOM   3536  C   ALA B 202      49.064  43.933  36.675  1.00 16.04           C  
ATOM   3537  O   ALA B 202      49.175  43.040  37.548  1.00 17.45           O  
ATOM   3538  CB  ALA B 202      48.577  46.261  37.348  1.00 16.53           C  
ATOM   3539  N   LEU B 203      48.405  43.724  35.573  1.00 15.36           N  
ATOM   3540  CA  LEU B 203      47.773  42.434  35.296  1.00 15.52           C  
ATOM   3541  C   LEU B 203      48.835  41.290  35.253  1.00 16.18           C  
ATOM   3542  O   LEU B 203      48.688  40.228  35.893  1.00 15.54           O  
ATOM   3543  CB  LEU B 203      47.002  42.526  33.977  1.00 14.40           C  
ATOM   3544  CG  LEU B 203      45.612  43.217  34.087  1.00 13.73           C  
ATOM   3545  CD1 LEU B 203      45.013  43.274  32.743  1.00 12.34           C  
ATOM   3546  CD2 LEU B 203      44.638  42.471  35.035  1.00 10.45           C  
ATOM   3547  N   THR B 204      49.900  41.534  34.490  1.00 18.27           N  
ATOM   3548  CA  THR B 204      51.056  40.640  34.369  1.00 19.50           C  
ATOM   3549  C   THR B 204      51.762  40.381  35.692  1.00 20.15           C  
ATOM   3550  O   THR B 204      52.149  39.229  35.999  1.00 19.28           O  
ATOM   3551  CB  THR B 204      52.063  41.211  33.386  1.00 20.09           C  
ATOM   3552  OG1 THR B 204      51.391  41.427  32.144  1.00 21.54           O  
ATOM   3553  CG2 THR B 204      53.212  40.276  33.192  1.00 21.63           C  
ATOM   3554  N   GLU B 205      51.950  41.428  36.476  1.00 21.95           N  
ATOM   3555  CA  GLU B 205      52.613  41.268  37.767  1.00 24.00           C  
ATOM   3556  C   GLU B 205      51.698  40.557  38.748  1.00 24.41           C  
ATOM   3557  O   GLU B 205      52.135  40.039  39.757  1.00 25.07           O  
ATOM   3558  CB  GLU B 205      53.023  42.615  38.319  1.00 24.54           C  
ATOM   3559  CG  GLU B 205      54.170  43.236  37.562  1.00 28.28           C  
ATOM   3560  CD  GLU B 205      54.472  44.637  38.049  1.00 30.05           C  
ATOM   3561  OE1 GLU B 205      53.731  45.143  38.918  1.00 34.07           O  
ATOM   3562  OE2 GLU B 205      55.455  45.225  37.572  1.00 31.63           O  
ATOM   3563  N   SER B 206      50.413  40.541  38.456  1.00 25.42           N  
ATOM   3564  CA  SER B 206      49.442  39.904  39.329  1.00 25.35           C  
ATOM   3565  C   SER B 206      49.263  38.451  38.868  1.00 25.83           C  
ATOM   3566  O   SER B 206      48.544  37.699  39.480  1.00 26.67           O  
ATOM   3567  CB  SER B 206      48.112  40.662  39.280  1.00 25.27           C  
ATOM   3568  OG  SER B 206      48.144  41.864  40.060  1.00 25.94           O  
ATOM   3569  N   GLY B 207      49.885  38.081  37.738  1.00 25.73           N  
ATOM   3570  CA  GLY B 207      49.802  36.705  37.200  1.00 23.42           C  
ATOM   3571  C   GLY B 207      48.502  36.396  36.465  1.00 22.95           C  
ATOM   3572  O   GLY B 207      48.052  35.246  36.381  1.00 22.47           O  
ATOM   3573  N   LEU B 208      47.887  37.420  35.916  1.00 21.39           N  
ATOM   3574  CA  LEU B 208      46.714  37.216  35.172  1.00 21.91           C  
ATOM   3575  C   LEU B 208      47.098  37.191  33.694  1.00 22.54           C  
ATOM   3576  O   LEU B 208      48.003  37.881  33.262  1.00 24.86           O  
ATOM   3577  CB  LEU B 208      45.710  38.274  35.544  1.00 21.65           C  
ATOM   3578  CG  LEU B 208      45.247  38.185  37.018  1.00 22.06           C  
ATOM   3579  CD1 LEU B 208      44.782  39.564  37.605  1.00 19.57           C  
ATOM   3580  CD2 LEU B 208      44.122  37.166  37.093  1.00 19.98           C  
ATOM   3581  N   SER B 209      46.444  36.324  32.953  1.00 22.31           N  
ATOM   3582  CA  SER B 209      46.723  36.116  31.552  1.00 22.12           C  
ATOM   3583  C   SER B 209      45.890  37.100  30.781  1.00 20.06           C  
ATOM   3584  O   SER B 209      44.744  37.323  31.113  1.00 20.53           O  
ATOM   3585  CB  SER B 209      46.270  34.708  31.169  1.00 20.95           C  
ATOM   3586  OG  SER B 209      47.360  33.842  31.320  1.00 27.68           O  
ATOM   3587  N   ILE B 210      46.442  37.629  29.711  1.00 19.81           N  
ATOM   3588  CA  ILE B 210      45.748  38.604  28.896  1.00 18.28           C  
ATOM   3589  C   ILE B 210      45.755  38.069  27.481  1.00 18.39           C  
ATOM   3590  O   ILE B 210      46.824  37.832  26.931  1.00 18.20           O  
ATOM   3591  CB  ILE B 210      46.497  39.956  28.924  1.00 17.82           C  
ATOM   3592  CG1 ILE B 210      46.723  40.470  30.374  1.00 17.34           C  
ATOM   3593  CG2 ILE B 210      45.777  41.031  28.022  1.00 17.32           C  
ATOM   3594  CD1 ILE B 210      47.786  41.595  30.477  1.00 17.52           C  
ATOM   3595  N   PRO B 211      44.581  37.922  26.846  1.00 19.16           N  
ATOM   3596  CA  PRO B 211      43.211  38.249  27.304  1.00 19.04           C  
ATOM   3597  C   PRO B 211      42.512  37.193  28.101  1.00 20.58           C  
ATOM   3598  O   PRO B 211      41.376  37.405  28.521  1.00 19.68           O  
ATOM   3599  CB  PRO B 211      42.457  38.425  25.981  1.00 20.00           C  
ATOM   3600  CG  PRO B 211      43.150  37.392  25.065  1.00 18.92           C  
ATOM   3601  CD  PRO B 211      44.597  37.419  25.441  1.00 17.56           C  
ATOM   3602  N   GLN B 212      43.124  36.019  28.251  1.00 21.55           N  
ATOM   3603  CA  GLN B 212      42.367  34.835  28.706  1.00 21.73           C  
ATOM   3604  C   GLN B 212      41.679  35.074  30.039  1.00 21.85           C  
ATOM   3605  O   GLN B 212      40.514  34.779  30.187  1.00 22.68           O  
ATOM   3606  CB  GLN B 212      43.284  33.595  28.760  1.00 22.68           C  
ATOM   3607  CG  GLN B 212      43.787  33.173  27.357  1.00 27.16           C  
ATOM   3608  CD  GLN B 212      44.965  34.019  26.753  1.00 32.30           C  
ATOM   3609  OE1 GLN B 212      45.652  34.800  27.425  1.00 29.95           O  
ATOM   3610  NE2 GLN B 212      45.207  33.803  25.448  1.00 38.88           N  
ATOM   3611  N   ASP B 213      42.401  35.628  31.007  1.00 21.78           N  
ATOM   3612  CA  ASP B 213      41.792  35.993  32.286  1.00 20.02           C  
ATOM   3613  C   ASP B 213      41.130  37.386  32.234  1.00 20.10           C  
ATOM   3614  O   ASP B 213      40.018  37.558  32.742  1.00 19.76           O  
ATOM   3615  CB  ASP B 213      42.848  36.004  33.368  1.00 18.67           C  
ATOM   3616  CG  ASP B 213      43.369  34.609  33.672  1.00 21.96           C  
ATOM   3617  OD1 ASP B 213      42.562  33.655  33.667  1.00 22.41           O  
ATOM   3618  OD2 ASP B 213      44.591  34.440  33.830  1.00 23.45           O  
ATOM   3619  N   VAL B 214      41.875  38.376  31.722  1.00 18.52           N  
ATOM   3620  CA  VAL B 214      41.435  39.768  31.676  1.00 18.01           C  
ATOM   3621  C   VAL B 214      41.932  40.394  30.341  1.00 15.93           C  
ATOM   3622  O   VAL B 214      43.129  40.455  30.045  1.00 16.84           O  
ATOM   3623  CB  VAL B 214      41.956  40.579  32.829  1.00 16.52           C  
ATOM   3624  CG1 VAL B 214      41.432  42.044  32.774  1.00 17.88           C  
ATOM   3625  CG2 VAL B 214      41.593  39.944  34.244  1.00 19.96           C  
ATOM   3626  N   ALA B 215      40.977  40.829  29.540  1.00 14.67           N  
ATOM   3627  CA  ALA B 215      41.203  41.500  28.277  1.00 12.05           C  
ATOM   3628  C   ALA B 215      41.493  42.972  28.621  1.00 12.16           C  
ATOM   3629  O   ALA B 215      40.981  43.469  29.624  1.00 12.66           O  
ATOM   3630  CB  ALA B 215      39.957  41.422  27.490  1.00 12.00           C  
ATOM   3631  N   VAL B 216      42.278  43.675  27.802  1.00 11.51           N  
ATOM   3632  CA  VAL B 216      42.539  45.125  27.950  1.00 11.12           C  
ATOM   3633  C   VAL B 216      42.285  45.830  26.626  1.00 11.54           C  
ATOM   3634  O   VAL B 216      42.715  45.344  25.579  1.00 12.54           O  
ATOM   3635  CB  VAL B 216      43.995  45.426  28.440  1.00 12.51           C  
ATOM   3636  CG1 VAL B 216      44.200  46.944  28.687  1.00 10.15           C  
ATOM   3637  CG2 VAL B 216      44.353  44.633  29.718  1.00 12.47           C  
ATOM   3638  N   VAL B 217      41.594  46.969  26.668  1.00 12.01           N  
ATOM   3639  CA  VAL B 217      41.392  47.841  25.521  1.00 11.83           C  
ATOM   3640  C   VAL B 217      41.775  49.258  25.950  1.00 12.47           C  
ATOM   3641  O   VAL B 217      41.476  49.702  27.079  1.00 13.71           O  
ATOM   3642  CB  VAL B 217      39.921  47.784  24.972  1.00 12.08           C  
ATOM   3643  CG1 VAL B 217      39.670  48.848  23.841  1.00 13.10           C  
ATOM   3644  CG2 VAL B 217      39.601  46.372  24.511  1.00 10.19           C  
ATOM   3645  N   GLY B 218      42.510  49.937  25.082  1.00 12.48           N  
ATOM   3646  CA  GLY B 218      42.864  51.348  25.331  1.00 13.35           C  
ATOM   3647  C   GLY B 218      42.133  52.379  24.469  1.00 13.68           C  
ATOM   3648  O   GLY B 218      41.011  52.162  24.015  1.00 14.56           O  
ATOM   3649  N   PHE B 219      42.737  53.551  24.289  1.00 15.00           N  
ATOM   3650  CA  PHE B 219      42.104  54.615  23.502  1.00 15.24           C  
ATOM   3651  C   PHE B 219      43.155  55.554  22.917  1.00 14.74           C  
ATOM   3652  O   PHE B 219      44.074  55.959  23.612  1.00 15.93           O  
ATOM   3653  CB  PHE B 219      41.078  55.364  24.343  1.00 15.25           C  
ATOM   3654  CG  PHE B 219      39.853  55.816  23.583  1.00 15.04           C  
ATOM   3655  CD1 PHE B 219      39.932  56.879  22.693  1.00 12.95           C  
ATOM   3656  CD2 PHE B 219      38.631  55.201  23.775  1.00 13.75           C  
ATOM   3657  CE1 PHE B 219      38.803  57.315  21.976  1.00 13.18           C  
ATOM   3658  CE2 PHE B 219      37.460  55.626  23.052  1.00 16.03           C  
ATOM   3659  CZ  PHE B 219      37.577  56.715  22.140  1.00 15.57           C  
ATOM   3660  N   ASP B 220      43.061  55.795  21.618  1.00 15.28           N  
ATOM   3661  CA  ASP B 220      43.829  56.830  20.887  1.00 15.13           C  
ATOM   3662  C   ASP B 220      44.704  56.294  19.775  1.00 14.29           C  
ATOM   3663  O   ASP B 220      44.869  56.932  18.763  1.00 12.82           O  
ATOM   3664  CB  ASP B 220      44.681  57.724  21.789  1.00 14.75           C  
ATOM   3665  CG  ASP B 220      43.854  58.736  22.587  1.00 13.86           C  
ATOM   3666  OD1 ASP B 220      42.652  58.889  22.384  1.00 16.46           O  
ATOM   3667  OD2 ASP B 220      44.439  59.398  23.420  1.00 12.79           O  
ATOM   3668  N   GLY B 221      45.335  55.153  20.008  1.00 14.89           N  
ATOM   3669  CA  GLY B 221      46.149  54.517  18.964  1.00 13.80           C  
ATOM   3670  C   GLY B 221      47.496  55.204  18.880  1.00 15.98           C  
ATOM   3671  O   GLY B 221      47.942  55.496  17.805  1.00 16.18           O  
ATOM   3672  N   VAL B 222      48.116  55.526  20.032  1.00 15.54           N  
ATOM   3673  CA  VAL B 222      49.464  56.140  20.084  1.00 12.86           C  
ATOM   3674  C   VAL B 222      50.537  55.031  20.100  1.00 13.21           C  
ATOM   3675  O   VAL B 222      50.179  53.856  20.167  1.00 11.90           O  
ATOM   3676  CB  VAL B 222      49.605  57.171  21.221  1.00 12.00           C  
ATOM   3677  CG1 VAL B 222      48.756  58.401  20.920  1.00 10.36           C  
ATOM   3678  CG2 VAL B 222      49.169  56.546  22.636  1.00 11.05           C  
ATOM   3679  N   ASP B 223      51.808  55.374  19.893  1.00 12.65           N  
ATOM   3680  CA  ASP B 223      52.864  54.335  19.753  1.00 14.50           C  
ATOM   3681  C   ASP B 223      52.960  53.354  20.923  1.00 14.14           C  
ATOM   3682  O   ASP B 223      53.252  52.183  20.700  1.00 14.30           O  
ATOM   3683  CB  ASP B 223      54.259  54.929  19.592  1.00 14.33           C  
ATOM   3684  CG  ASP B 223      54.462  55.531  18.245  1.00 18.08           C  
ATOM   3685  OD1 ASP B 223      53.487  55.570  17.444  1.00 18.26           O  
ATOM   3686  OD2 ASP B 223      55.588  55.998  18.005  1.00 19.88           O  
ATOM   3687  N   ILE B 224      52.677  53.791  22.148  1.00 13.97           N  
ATOM   3688  CA  ILE B 224      52.779  52.855  23.287  1.00 12.85           C  
ATOM   3689  C   ILE B 224      51.918  51.628  23.059  1.00 14.32           C  
ATOM   3690  O   ILE B 224      52.241  50.528  23.498  1.00 13.14           O  
ATOM   3691  CB  ILE B 224      52.507  53.504  24.703  1.00 12.71           C  
ATOM   3692  CG1 ILE B 224      53.062  52.624  25.847  1.00 13.84           C  
ATOM   3693  CG2 ILE B 224      51.016  53.682  24.983  1.00 10.34           C  
ATOM   3694  CD1 ILE B 224      54.587  52.393  25.777  1.00 16.52           C  
ATOM   3695  N   SER B 225      50.817  51.809  22.349  1.00 15.23           N  
ATOM   3696  CA  SER B 225      49.926  50.690  22.103  1.00 15.84           C  
ATOM   3697  C   SER B 225      50.582  49.620  21.198  1.00 17.52           C  
ATOM   3698  O   SER B 225      50.099  48.468  21.128  1.00 18.51           O  
ATOM   3699  CB  SER B 225      48.606  51.191  21.545  1.00 15.42           C  
ATOM   3700  OG  SER B 225      48.719  51.504  20.164  1.00 10.79           O  
ATOM   3701  N   GLN B 226      51.683  49.966  20.529  1.00 17.84           N  
ATOM   3702  CA  GLN B 226      52.395  48.988  19.713  1.00 20.02           C  
ATOM   3703  C   GLN B 226      53.687  48.445  20.376  1.00 20.01           C  
ATOM   3704  O   GLN B 226      54.445  47.659  19.780  1.00 19.10           O  
ATOM   3705  CB  GLN B 226      52.741  49.607  18.388  1.00 21.85           C  
ATOM   3706  CG  GLN B 226      51.492  50.036  17.649  1.00 24.92           C  
ATOM   3707  CD  GLN B 226      51.852  50.842  16.461  1.00 30.43           C  
ATOM   3708  OE1 GLN B 226      52.703  51.737  16.529  1.00 33.17           O  
ATOM   3709  NE2 GLN B 226      51.235  50.539  15.351  1.00 30.02           N  
ATOM   3710  N   ILE B 227      53.900  48.887  21.608  1.00 19.13           N  
ATOM   3711  CA  ILE B 227      55.052  48.541  22.365  1.00 19.82           C  
ATOM   3712  C   ILE B 227      54.766  47.540  23.491  1.00 20.18           C  
ATOM   3713  O   ILE B 227      55.688  46.847  23.958  1.00 19.56           O  
ATOM   3714  CB  ILE B 227      55.740  49.799  22.905  1.00 18.43           C  
ATOM   3715  CG1 ILE B 227      56.383  50.541  21.755  1.00 18.28           C  
ATOM   3716  CG2 ILE B 227      56.931  49.405  23.768  1.00 22.03           C  
ATOM   3717  CD1 ILE B 227      56.566  52.012  22.004  1.00 19.25           C  
ATOM   3718  N   THR B 228      53.506  47.485  23.943  1.00 20.38           N  
ATOM   3719  CA  THR B 228      53.193  46.709  25.131  1.00 18.97           C  
ATOM   3720  C   THR B 228      53.172  45.256  24.722  1.00 19.35           C  
ATOM   3721  O   THR B 228      53.031  44.922  23.511  1.00 17.33           O  
ATOM   3722  CB  THR B 228      51.830  47.120  25.719  1.00 19.86           C  
ATOM   3723  OG1 THR B 228      50.837  47.099  24.676  1.00 17.44           O  
ATOM   3724  CG2 THR B 228      51.934  48.500  26.272  1.00 16.49           C  
ATOM   3725  N   VAL B 229      53.294  44.371  25.717  1.00 17.79           N  
ATOM   3726  CA  VAL B 229      53.197  42.961  25.424  1.00 17.73           C  
ATOM   3727  C   VAL B 229      52.117  42.387  26.308  1.00 18.22           C  
ATOM   3728  O   VAL B 229      52.242  42.433  27.500  1.00 18.59           O  
ATOM   3729  CB  VAL B 229      54.572  42.213  25.607  1.00 18.75           C  
ATOM   3730  CG1 VAL B 229      54.367  40.690  25.423  1.00 16.91           C  
ATOM   3731  CG2 VAL B 229      55.588  42.766  24.588  1.00 14.98           C  
ATOM   3732  N   PRO B 230      51.022  41.879  25.723  1.00 17.27           N  
ATOM   3733  CA  PRO B 230      50.611  41.805  24.359  1.00 15.83           C  
ATOM   3734  C   PRO B 230      50.384  43.235  23.787  1.00 15.95           C  
ATOM   3735  O   PRO B 230      50.125  44.208  24.519  1.00 14.37           O  
ATOM   3736  CB  PRO B 230      49.242  41.112  24.438  1.00 16.18           C  
ATOM   3737  CG  PRO B 230      48.794  41.348  25.861  1.00 16.97           C  
ATOM   3738  CD  PRO B 230      50.010  41.331  26.662  1.00 16.81           C  
ATOM   3739  N   ALA B 231      50.465  43.338  22.476  1.00 16.15           N  
ATOM   3740  CA  ALA B 231      50.107  44.606  21.811  1.00 16.08           C  
ATOM   3741  C   ALA B 231      48.667  44.934  22.160  1.00 15.48           C  
ATOM   3742  O   ALA B 231      47.871  44.036  22.330  1.00 14.06           O  
ATOM   3743  CB  ALA B 231      50.257  44.499  20.341  1.00 16.29           C  
ATOM   3744  N   LEU B 232      48.361  46.241  22.166  1.00 14.71           N  
ATOM   3745  CA  LEU B 232      47.169  46.779  22.778  1.00 15.12           C  
ATOM   3746  C   LEU B 232      46.062  47.083  21.786  1.00 16.18           C  
ATOM   3747  O   LEU B 232      46.257  47.899  20.897  1.00 15.38           O  
ATOM   3748  CB  LEU B 232      47.564  48.049  23.612  1.00 14.46           C  
ATOM   3749  CG  LEU B 232      46.347  48.712  24.183  1.00 15.01           C  
ATOM   3750  CD1 LEU B 232      45.792  47.762  25.285  1.00 13.81           C  
ATOM   3751  CD2 LEU B 232      46.777  50.112  24.689  1.00 17.49           C  
ATOM   3752  N   THR B 233      44.938  46.347  21.884  1.00 14.65           N  
ATOM   3753  CA  THR B 233      43.715  46.750  21.250  1.00 14.79           C  
ATOM   3754  C   THR B 233      43.317  48.143  21.697  1.00 14.29           C  
ATOM   3755  O   THR B 233      43.400  48.518  22.873  1.00 15.60           O  
ATOM   3756  CB  THR B 233      42.602  45.781  21.536  1.00 14.65           C  
ATOM   3757  OG1 THR B 233      42.985  44.504  21.050  1.00 12.63           O  
ATOM   3758  CG2 THR B 233      41.240  46.211  20.867  1.00 12.69           C  
ATOM   3759  N   THR B 234      42.874  48.931  20.755  1.00 14.77           N  
ATOM   3760  CA  THR B 234      42.623  50.319  21.056  1.00 14.64           C  
ATOM   3761  C   THR B 234      41.629  50.908  20.089  1.00 15.83           C  
ATOM   3762  O   THR B 234      41.287  50.301  19.046  1.00 15.65           O  
ATOM   3763  CB  THR B 234      43.955  51.105  21.049  1.00 14.91           C  
ATOM   3764  OG1 THR B 234      43.733  52.441  21.522  1.00 14.05           O  
ATOM   3765  CG2 THR B 234      44.623  51.114  19.627  1.00 12.61           C  
ATOM   3766  N   VAL B 235      41.133  52.086  20.458  1.00 15.48           N  
ATOM   3767  CA  VAL B 235      40.403  52.923  19.521  1.00 14.18           C  
ATOM   3768  C   VAL B 235      41.360  53.926  18.869  1.00 14.60           C  
ATOM   3769  O   VAL B 235      41.794  54.871  19.517  1.00 16.28           O  
ATOM   3770  CB  VAL B 235      39.202  53.654  20.191  1.00 14.50           C  
ATOM   3771  CG1 VAL B 235      38.460  54.452  19.193  1.00  9.68           C  
ATOM   3772  CG2 VAL B 235      38.286  52.668  20.849  1.00 12.42           C  
ATOM   3773  N   GLN B 236      41.674  53.696  17.594  1.00 14.31           N  
ATOM   3774  CA  GLN B 236      42.586  54.561  16.826  1.00 14.67           C  
ATOM   3775  C   GLN B 236      41.896  55.824  16.373  1.00 13.94           C  
ATOM   3776  O   GLN B 236      40.837  55.748  15.711  1.00 14.19           O  
ATOM   3777  CB  GLN B 236      43.052  53.820  15.583  1.00 15.63           C  
ATOM   3778  CG  GLN B 236      43.959  54.627  14.685  1.00 18.92           C  
ATOM   3779  CD  GLN B 236      45.315  54.664  15.262  1.00 25.61           C  
ATOM   3780  OE1 GLN B 236      45.911  53.609  15.481  1.00 31.60           O  
ATOM   3781  NE2 GLN B 236      45.827  55.872  15.558  1.00 26.38           N  
ATOM   3782  N   GLN B 237      42.391  56.980  16.839  1.00 14.07           N  
ATOM   3783  CA  GLN B 237      41.937  58.305  16.323  1.00 14.75           C  
ATOM   3784  C   GLN B 237      42.831  58.777  15.164  1.00 14.76           C  
ATOM   3785  O   GLN B 237      44.037  58.500  15.162  1.00 12.32           O  
ATOM   3786  CB  GLN B 237      42.035  59.364  17.389  1.00 14.64           C  
ATOM   3787  CG  GLN B 237      41.123  59.081  18.584  1.00 14.13           C  
ATOM   3788  CD  GLN B 237      40.748  60.347  19.276  1.00 17.91           C  
ATOM   3789  OE1 GLN B 237      40.363  61.319  18.615  1.00 14.33           O  
ATOM   3790  NE2 GLN B 237      40.823  60.358  20.634  1.00 17.56           N  
ATOM   3791  N   PRO B 238      42.256  59.503  14.218  1.00 14.40           N  
ATOM   3792  CA  PRO B 238      43.135  60.056  13.195  1.00 14.51           C  
ATOM   3793  C   PRO B 238      43.802  61.354  13.703  1.00 15.36           C  
ATOM   3794  O   PRO B 238      43.451  62.470  13.238  1.00 16.52           O  
ATOM   3795  CB  PRO B 238      42.163  60.339  12.025  1.00 13.52           C  
ATOM   3796  CG  PRO B 238      40.868  60.629  12.680  1.00 14.49           C  
ATOM   3797  CD  PRO B 238      40.820  59.792  13.953  1.00 13.23           C  
ATOM   3798  N   SER B 239      44.766  61.212  14.608  1.00 14.13           N  
ATOM   3799  CA  SER B 239      45.201  62.345  15.434  1.00 14.25           C  
ATOM   3800  C   SER B 239      45.822  63.488  14.643  1.00 14.67           C  
ATOM   3801  O   SER B 239      45.458  64.648  14.841  1.00 15.89           O  
ATOM   3802  CB  SER B 239      46.096  61.869  16.559  1.00 14.63           C  
ATOM   3803  OG  SER B 239      45.325  61.037  17.436  1.00 17.75           O  
ATOM   3804  N   GLU B 240      46.772  63.167  13.774  1.00 14.68           N  
ATOM   3805  CA  GLU B 240      47.303  64.151  12.853  1.00 17.54           C  
ATOM   3806  C   GLU B 240      46.264  64.860  11.978  1.00 17.23           C  
ATOM   3807  O   GLU B 240      46.336  66.078  11.830  1.00 17.56           O  
ATOM   3808  CB  GLU B 240      48.391  63.541  11.993  1.00 16.12           C  
ATOM   3809  CG  GLU B 240      49.339  64.550  11.436  1.00 23.40           C  
ATOM   3810  CD  GLU B 240      50.592  63.892  10.831  1.00 30.19           C  
ATOM   3811  OE1 GLU B 240      51.315  63.174  11.552  1.00 30.91           O  
ATOM   3812  OE2 GLU B 240      50.829  64.056   9.619  1.00 37.22           O  
ATOM   3813  N   GLN B 241      45.347  64.111  11.361  1.00 17.45           N  
ATOM   3814  CA  GLN B 241      44.205  64.683  10.595  1.00 17.37           C  
ATOM   3815  C   GLN B 241      43.312  65.609  11.424  1.00 15.68           C  
ATOM   3816  O   GLN B 241      42.892  66.633  10.929  1.00 15.55           O  
ATOM   3817  CB  GLN B 241      43.345  63.582   9.919  1.00 18.14           C  
ATOM   3818  CG  GLN B 241      44.138  62.726   8.848  1.00 21.40           C  
ATOM   3819  CD  GLN B 241      43.256  61.871   7.898  1.00 24.66           C  
ATOM   3820  OE1 GLN B 241      43.541  61.751   6.692  1.00 31.28           O  
ATOM   3821  NE2 GLN B 241      42.185  61.269   8.442  1.00 30.90           N  
ATOM   3822  N   ILE B 242      43.035  65.270  12.679  1.00 14.09           N  
ATOM   3823  CA  ILE B 242      42.411  66.213  13.606  1.00 13.45           C  
ATOM   3824  C   ILE B 242      43.113  67.565  13.692  1.00 13.69           C  
ATOM   3825  O   ILE B 242      42.456  68.582  13.547  1.00 13.68           O  
ATOM   3826  CB  ILE B 242      42.194  65.564  14.999  1.00 13.98           C  
ATOM   3827  CG1 ILE B 242      41.209  64.407  14.880  1.00  8.57           C  
ATOM   3828  CG2 ILE B 242      41.691  66.610  16.090  1.00 15.62           C  
ATOM   3829  CD1 ILE B 242      41.154  63.623  16.127  1.00 15.87           C  
ATOM   3830  N   GLY B 243      44.425  67.595  13.924  1.00 13.27           N  
ATOM   3831  CA  GLY B 243      45.178  68.877  13.922  1.00 11.07           C  
ATOM   3832  C   GLY B 243      45.211  69.570  12.552  1.00 12.94           C  
ATOM   3833  O   GLY B 243      45.056  70.786  12.459  1.00 12.10           O  
ATOM   3834  N   MET B 244      45.413  68.823  11.476  1.00 12.46           N  
ATOM   3835  CA  MET B 244      45.489  69.489  10.160  1.00 14.49           C  
ATOM   3836  C   MET B 244      44.129  70.151   9.865  1.00 14.99           C  
ATOM   3837  O   MET B 244      44.070  71.290   9.370  1.00 13.51           O  
ATOM   3838  CB  MET B 244      45.840  68.468   9.087  1.00 13.73           C  
ATOM   3839  CG  MET B 244      47.204  67.811   9.218  1.00 18.02           C  
ATOM   3840  SD  MET B 244      47.575  66.496   7.975  1.00 15.84           S  
ATOM   3841  CE  MET B 244      46.281  65.487   8.293  1.00 21.28           C  
ATOM   3842  N   LYS B 245      43.047  69.466  10.246  1.00 14.87           N  
ATOM   3843  CA  LYS B 245      41.691  69.948   9.952  1.00 14.74           C  
ATOM   3844  C   LYS B 245      41.391  71.132  10.832  1.00 15.65           C  
ATOM   3845  O   LYS B 245      40.768  72.100  10.374  1.00 17.77           O  
ATOM   3846  CB  LYS B 245      40.641  68.788  10.065  1.00 14.52           C  
ATOM   3847  CG  LYS B 245      39.137  69.185   9.716  1.00 16.94           C  
ATOM   3848  CD  LYS B 245      39.055  69.821   8.318  1.00 23.01           C  
ATOM   3849  CE  LYS B 245      37.939  69.280   7.475  1.00 32.15           C  
ATOM   3850  NZ  LYS B 245      38.106  69.694   6.022  1.00 32.50           N  
ATOM   3851  N   ALA B 246      41.853  71.099  12.096  1.00 16.08           N  
ATOM   3852  CA  ALA B 246      41.632  72.223  12.996  1.00 15.60           C  
ATOM   3853  C   ALA B 246      42.232  73.482  12.374  1.00 15.21           C  
ATOM   3854  O   ALA B 246      41.560  74.482  12.231  1.00 15.72           O  
ATOM   3855  CB  ALA B 246      42.137  71.932  14.447  1.00 13.51           C  
ATOM   3856  N   VAL B 247      43.451  73.400  11.875  1.00 16.33           N  
ATOM   3857  CA  VAL B 247      44.060  74.532  11.163  1.00 15.30           C  
ATOM   3858  C   VAL B 247      43.296  74.988   9.967  1.00 16.94           C  
ATOM   3859  O   VAL B 247      43.117  76.220   9.796  1.00 15.41           O  
ATOM   3860  CB  VAL B 247      45.536  74.256  10.788  1.00 16.30           C  
ATOM   3861  CG1 VAL B 247      46.121  75.416   9.933  1.00 16.76           C  
ATOM   3862  CG2 VAL B 247      46.305  74.044  12.054  1.00 13.75           C  
ATOM   3863  N   SER B 248      42.854  74.031   9.146  1.00 16.81           N  
ATOM   3864  CA  SER B 248      41.997  74.314   8.019  1.00 19.20           C  
ATOM   3865  C   SER B 248      40.751  75.108   8.364  1.00 18.56           C  
ATOM   3866  O   SER B 248      40.381  76.020   7.604  1.00 16.44           O  
ATOM   3867  CB  SER B 248      41.582  73.043   7.289  1.00 20.36           C  
ATOM   3868  OG  SER B 248      42.648  72.756   6.401  1.00 25.29           O  
ATOM   3869  N   LEU B 249      40.140  74.758   9.496  1.00 16.63           N  
ATOM   3870  CA  LEU B 249      38.971  75.474   9.975  1.00 17.53           C  
ATOM   3871  C   LEU B 249      39.347  76.864  10.475  1.00 17.46           C  
ATOM   3872  O   LEU B 249      38.547  77.852  10.310  1.00 17.45           O  
ATOM   3873  CB  LEU B 249      38.218  74.657  11.043  1.00 16.63           C  
ATOM   3874  CG  LEU B 249      37.622  73.278  10.676  1.00 17.20           C  
ATOM   3875  CD1 LEU B 249      36.927  72.603  11.910  1.00 16.94           C  
ATOM   3876  CD2 LEU B 249      36.644  73.467   9.565  1.00 19.72           C  
ATOM   3877  N   LEU B 250      40.521  76.968  11.086  1.00 16.66           N  
ATOM   3878  CA  LEU B 250      41.008  78.247  11.598  1.00 17.46           C  
ATOM   3879  C   LEU B 250      41.314  79.162  10.433  1.00 17.93           C  
ATOM   3880  O   LEU B 250      41.116  80.361  10.520  1.00 18.89           O  
ATOM   3881  CB  LEU B 250      42.291  78.097  12.454  1.00 16.85           C  
ATOM   3882  CG  LEU B 250      42.558  79.281  13.383  1.00 17.16           C  
ATOM   3883  CD1 LEU B 250      41.592  79.180  14.546  1.00 16.49           C  
ATOM   3884  CD2 LEU B 250      43.997  79.248  13.916  1.00 19.06           C  
ATOM   3885  N   LEU B 251      41.851  78.604   9.357  1.00 18.73           N  
ATOM   3886  CA  LEU B 251      42.121  79.399   8.145  1.00 20.84           C  
ATOM   3887  C   LEU B 251      40.864  79.910   7.422  1.00 22.07           C  
ATOM   3888  O   LEU B 251      40.870  81.004   6.856  1.00 23.92           O  
ATOM   3889  CB  LEU B 251      43.072  78.651   7.183  1.00 21.28           C  
ATOM   3890  CG  LEU B 251      44.513  78.363   7.650  1.00 20.22           C  
ATOM   3891  CD1 LEU B 251      45.208  77.310   6.710  1.00 22.40           C  
ATOM   3892  CD2 LEU B 251      45.400  79.629   7.876  1.00 14.46           C  
ATOM   3893  N   GLU B 252      39.772  79.167   7.421  1.00 22.92           N  
ATOM   3894  CA  GLU B 252      38.559  79.721   6.845  1.00 24.25           C  
ATOM   3895  C   GLU B 252      38.120  80.960   7.590  1.00 24.21           C  
ATOM   3896  O   GLU B 252      37.610  81.899   6.955  1.00 25.32           O  
ATOM   3897  CB  GLU B 252      37.392  78.774   6.969  1.00 24.60           C  
ATOM   3898  CG  GLU B 252      37.764  77.394   6.819  1.00 31.68           C  
ATOM   3899  CD  GLU B 252      37.141  76.782   5.630  1.00 38.37           C  
ATOM   3900  OE1 GLU B 252      36.531  75.706   5.850  1.00 41.81           O  
ATOM   3901  OE2 GLU B 252      37.256  77.383   4.520  1.00 40.81           O  
ATOM   3902  N   GLN B 253      38.245  80.941   8.923  1.00 22.53           N  
ATOM   3903  CA  GLN B 253      37.941  82.082   9.718  1.00 20.62           C  
ATOM   3904  C   GLN B 253      38.875  83.222   9.376  1.00 21.95           C  
ATOM   3905  O   GLN B 253      38.412  84.344   9.173  1.00 22.22           O  
ATOM   3906  CB  GLN B 253      37.956  81.754  11.208  1.00 18.75           C  
ATOM   3907  CG  GLN B 253      36.828  80.855  11.576  1.00 16.08           C  
ATOM   3908  CD  GLN B 253      36.882  80.345  13.002  1.00 18.15           C  
ATOM   3909  OE1 GLN B 253      36.683  81.088  13.947  1.00 16.11           O  
ATOM   3910  NE2 GLN B 253      37.128  79.046  13.156  1.00 16.17           N  
ATOM   3911  N   ILE B 254      40.174  82.969   9.334  1.00 21.44           N  
ATOM   3912  CA  ILE B 254      41.147  84.047   9.078  1.00 22.96           C  
ATOM   3913  C   ILE B 254      40.935  84.622   7.670  1.00 24.09           C  
ATOM   3914  O   ILE B 254      40.975  85.845   7.473  1.00 24.61           O  
ATOM   3915  CB  ILE B 254      42.612  83.552   9.211  1.00 22.26           C  
ATOM   3916  CG1 ILE B 254      43.031  83.408  10.671  1.00 18.67           C  
ATOM   3917  CG2 ILE B 254      43.618  84.472   8.428  1.00 23.64           C  
ATOM   3918  CD1 ILE B 254      44.088  82.346  10.899  1.00 14.07           C  
ATOM   3919  N   HIS B 255      40.631  83.761   6.712  1.00 25.60           N  
ATOM   3920  CA  HIS B 255      40.502  84.187   5.314  1.00 28.63           C  
ATOM   3921  C   HIS B 255      39.392  85.226   5.115  1.00 29.48           C  
ATOM   3922  O   HIS B 255      38.257  85.027   5.536  1.00 29.15           O  
ATOM   3923  CB  HIS B 255      40.268  82.987   4.401  1.00 29.09           C  
ATOM   3924  CG  HIS B 255      41.499  82.177   4.170  1.00 31.46           C  
ATOM   3925  ND1 HIS B 255      41.530  81.093   3.318  1.00 35.46           N  
ATOM   3926  CD2 HIS B 255      42.745  82.290   4.679  1.00 33.61           C  
ATOM   3927  CE1 HIS B 255      42.744  80.568   3.325  1.00 37.97           C  
ATOM   3928  NE2 HIS B 255      43.499  81.277   4.142  1.00 35.84           N  
ATOM   3929  N   SER B 256      39.782  86.309   4.442  1.00 31.31           N  
ATOM   3930  CA  SER B 256      38.972  87.464   4.095  1.00 32.89           C  
ATOM   3931  C   SER B 256      37.800  87.205   3.164  1.00 33.74           C  
ATOM   3932  O   SER B 256      36.754  87.844   3.309  1.00 33.80           O  
ATOM   3933  CB  SER B 256      39.872  88.478   3.425  1.00 32.90           C  
ATOM   3934  OG  SER B 256      40.579  89.154   4.429  1.00 36.75           O  
ATOM   3935  N   ASP B 257      37.968  86.277   2.216  1.00 34.27           N  
ATOM   3936  CA  ASP B 257      36.946  86.054   1.190  1.00 34.72           C  
ATOM   3937  C   ASP B 257      35.921  85.008   1.558  1.00 34.46           C  
ATOM   3938  O   ASP B 257      35.047  84.670   0.752  1.00 35.56           O  
ATOM   3939  CB  ASP B 257      37.582  85.728  -0.173  1.00 35.19           C  
ATOM   3940  CG  ASP B 257      38.369  84.412  -0.161  1.00 38.10           C  
ATOM   3941  OD1 ASP B 257      38.695  83.911  -1.256  1.00 41.38           O  
ATOM   3942  OD2 ASP B 257      38.679  83.877   0.926  1.00 39.04           O  
ATOM   3943  N   VAL B 258      35.990  84.474   2.764  1.00 33.34           N  
ATOM   3944  CA  VAL B 258      34.871  83.631   3.225  1.00 32.78           C  
ATOM   3945  C   VAL B 258      34.344  84.146   4.549  1.00 31.30           C  
ATOM   3946  O   VAL B 258      35.123  84.470   5.430  1.00 32.04           O  
ATOM   3947  CB  VAL B 258      35.242  82.101   3.333  1.00 32.88           C  
ATOM   3948  CG1 VAL B 258      36.659  81.901   3.765  1.00 33.36           C  
ATOM   3949  CG2 VAL B 258      34.301  81.343   4.269  1.00 33.73           C  
ATOM   3950  N   LEU B 259      33.028  84.214   4.686  1.00 29.70           N  
ATOM   3951  CA  LEU B 259      32.444  84.359   6.018  1.00 28.77           C  
ATOM   3952  C   LEU B 259      32.188  82.943   6.532  1.00 27.95           C  
ATOM   3953  O   LEU B 259      31.235  82.271   6.140  1.00 29.25           O  
ATOM   3954  CB  LEU B 259      31.181  85.244   6.033  1.00 28.03           C  
ATOM   3955  CG  LEU B 259      31.270  86.729   5.594  1.00 27.80           C  
ATOM   3956  CD1 LEU B 259      29.872  87.283   5.401  1.00 24.68           C  
ATOM   3957  CD2 LEU B 259      32.158  87.702   6.511  1.00 25.38           C  
ATOM   3958  N   ALA B 260      33.089  82.484   7.394  1.00 26.06           N  
ATOM   3959  CA  ALA B 260      33.054  81.123   7.908  1.00 23.75           C  
ATOM   3960  C   ALA B 260      31.809  80.907   8.753  1.00 22.18           C  
ATOM   3961  O   ALA B 260      31.448  81.792   9.508  1.00 21.59           O  
ATOM   3962  CB  ALA B 260      34.283  80.916   8.771  1.00 22.12           C  
ATOM   3963  N   LYS B 261      31.223  79.703   8.705  1.00 20.90           N  
ATOM   3964  CA  LYS B 261      30.074  79.358   9.560  1.00 19.65           C  
ATOM   3965  C   LYS B 261      30.539  78.284  10.496  1.00 18.01           C  
ATOM   3966  O   LYS B 261      31.599  77.698  10.267  1.00 15.27           O  
ATOM   3967  CB  LYS B 261      28.894  78.776   8.756  1.00 20.09           C  
ATOM   3968  CG  LYS B 261      28.492  79.544   7.497  1.00 24.07           C  
ATOM   3969  CD  LYS B 261      28.176  80.999   7.794  1.00 25.64           C  
ATOM   3970  CE  LYS B 261      27.977  81.805   6.498  1.00 28.49           C  
ATOM   3971  NZ  LYS B 261      27.625  83.240   6.734  1.00 25.93           N  
ATOM   3972  N   THR B 262      29.753  78.017  11.528  1.00 15.61           N  
ATOM   3973  CA  THR B 262      30.043  76.961  12.470  1.00 15.61           C  
ATOM   3974  C   THR B 262      29.939  75.621  11.809  1.00 15.11           C  
ATOM   3975  O   THR B 262      28.931  75.331  11.145  1.00 15.46           O  
ATOM   3976  CB  THR B 262      28.986  76.926  13.545  1.00 14.47           C  
ATOM   3977  OG1 THR B 262      28.964  78.193  14.133  1.00 17.24           O  
ATOM   3978  CG2 THR B 262      29.304  75.877  14.573  1.00 14.66           C  
ATOM   3979  N   VAL B 263      30.955  74.780  12.033  1.00 16.09           N  
ATOM   3980  CA  VAL B 263      30.935  73.405  11.559  1.00 14.96           C  
ATOM   3981  C   VAL B 263      31.519  72.505  12.613  1.00 15.42           C  
ATOM   3982  O   VAL B 263      32.485  72.893  13.278  1.00 14.44           O  
ATOM   3983  CB  VAL B 263      31.795  73.236  10.263  1.00 16.09           C  
ATOM   3984  CG1 VAL B 263      31.081  73.833   9.071  1.00 13.05           C  
ATOM   3985  CG2 VAL B 263      33.177  73.899  10.405  1.00 14.64           C  
ATOM   3986  N   HIS B 264      30.988  71.285  12.739  1.00 13.17           N  
ATOM   3987  CA  HIS B 264      31.487  70.382  13.753  1.00 14.11           C  
ATOM   3988  C   HIS B 264      31.860  69.147  13.016  1.00 15.17           C  
ATOM   3989  O   HIS B 264      30.984  68.330  12.701  1.00 15.62           O  
ATOM   3990  CB  HIS B 264      30.418  70.117  14.823  1.00 14.70           C  
ATOM   3991  CG  HIS B 264      30.068  71.329  15.645  1.00 15.86           C  
ATOM   3992  ND1 HIS B 264      30.940  71.870  16.576  1.00 18.08           N  
ATOM   3993  CD2 HIS B 264      28.945  72.097  15.691  1.00 13.73           C  
ATOM   3994  CE1 HIS B 264      30.388  72.945  17.127  1.00 11.10           C  
ATOM   3995  NE2 HIS B 264      29.172  73.090  16.620  1.00 14.48           N  
ATOM   3996  N   HIS B 265      33.127  69.047  12.588  1.00 15.86           N  
ATOM   3997  CA  HIS B 265      33.556  67.859  11.842  1.00 16.05           C  
ATOM   3998  C   HIS B 265      33.779  66.644  12.755  1.00 16.90           C  
ATOM   3999  O   HIS B 265      34.394  66.759  13.829  1.00 16.66           O  
ATOM   4000  CB  HIS B 265      34.862  68.107  11.098  1.00 16.01           C  
ATOM   4001  CG  HIS B 265      34.742  69.046   9.956  1.00 16.52           C  
ATOM   4002  ND1 HIS B 265      34.778  68.616   8.647  1.00 18.99           N  
ATOM   4003  CD2 HIS B 265      34.579  70.394   9.907  1.00 20.08           C  
ATOM   4004  CE1 HIS B 265      34.646  69.656   7.834  1.00 19.11           C  
ATOM   4005  NE2 HIS B 265      34.533  70.751   8.567  1.00 21.37           N  
ATOM   4006  N   LEU B 266      33.266  65.495  12.325  1.00 16.10           N  
ATOM   4007  CA  LEU B 266      33.496  64.238  12.996  1.00 17.57           C  
ATOM   4008  C   LEU B 266      34.327  63.442  12.053  1.00 17.65           C  
ATOM   4009  O   LEU B 266      33.900  63.197  10.953  1.00 19.82           O  
ATOM   4010  CB  LEU B 266      32.202  63.493  13.248  1.00 16.96           C  
ATOM   4011  CG  LEU B 266      31.457  63.926  14.531  1.00 19.17           C  
ATOM   4012  CD1 LEU B 266      30.217  63.068  14.595  1.00 19.60           C  
ATOM   4013  CD2 LEU B 266      32.227  63.780  15.768  1.00 13.63           C  
ATOM   4014  N   LEU B 267      35.517  63.056  12.473  1.00 18.50           N  
ATOM   4015  CA  LEU B 267      36.410  62.189  11.696  1.00 18.29           C  
ATOM   4016  C   LEU B 267      36.291  60.718  12.184  1.00 18.96           C  
ATOM   4017  O   LEU B 267      35.948  60.474  13.368  1.00 18.87           O  
ATOM   4018  CB  LEU B 267      37.877  62.695  11.757  1.00 16.47           C  
ATOM   4019  CG  LEU B 267      38.172  64.119  11.259  1.00 17.60           C  
ATOM   4020  CD1 LEU B 267      39.651  64.298  11.159  1.00 17.48           C  
ATOM   4021  CD2 LEU B 267      37.554  64.478   9.861  1.00 20.91           C  
ATOM   4022  N   PRO B 268      36.475  59.731  11.259  1.00 19.19           N  
ATOM   4023  CA  PRO B 268      36.237  58.313  11.648  1.00 18.96           C  
ATOM   4024  C   PRO B 268      37.289  57.795  12.603  1.00 19.35           C  
ATOM   4025  O   PRO B 268      38.448  58.038  12.383  1.00 19.66           O  
ATOM   4026  CB  PRO B 268      36.331  57.498  10.318  1.00 20.33           C  
ATOM   4027  CG  PRO B 268      36.646  58.492   9.194  1.00 18.90           C  
ATOM   4028  CD  PRO B 268      36.876  59.896   9.837  1.00 19.66           C  
ATOM   4029  N   TRP B 269      36.861  57.090  13.655  1.00 19.18           N  
ATOM   4030  CA  TRP B 269      37.740  56.288  14.507  1.00 19.07           C  
ATOM   4031  C   TRP B 269      37.759  54.862  14.001  1.00 19.65           C  
ATOM   4032  O   TRP B 269      36.822  54.443  13.339  1.00 20.34           O  
ATOM   4033  CB  TRP B 269      37.224  56.307  15.944  1.00 18.54           C  
ATOM   4034  CG  TRP B 269      35.791  55.900  16.035  1.00 19.38           C  
ATOM   4035  CD1 TRP B 269      34.702  56.725  16.006  1.00 22.75           C  
ATOM   4036  CD2 TRP B 269      35.283  54.560  16.149  1.00 18.78           C  
ATOM   4037  NE1 TRP B 269      33.547  55.986  16.080  1.00 24.25           N  
ATOM   4038  CE2 TRP B 269      33.882  54.653  16.191  1.00 21.82           C  
ATOM   4039  CE3 TRP B 269      35.890  53.289  16.227  1.00 16.57           C  
ATOM   4040  CZ2 TRP B 269      33.057  53.525  16.290  1.00 21.86           C  
ATOM   4041  CZ3 TRP B 269      35.072  52.144  16.319  1.00 18.66           C  
ATOM   4042  CH2 TRP B 269      33.666  52.273  16.325  1.00 19.05           C  
ATOM   4043  N   LYS B 270      38.771  54.094  14.362  1.00 20.03           N  
ATOM   4044  CA  LYS B 270      38.815  52.696  13.982  1.00 22.16           C  
ATOM   4045  C   LYS B 270      39.111  51.853  15.212  1.00 20.89           C  
ATOM   4046  O   LYS B 270      39.977  52.192  16.020  1.00 21.59           O  
ATOM   4047  CB  LYS B 270      39.864  52.460  12.849  1.00 21.27           C  
ATOM   4048  CG  LYS B 270      39.738  51.072  12.217  1.00 26.00           C  
ATOM   4049  CD  LYS B 270      40.837  50.678  11.153  1.00 26.32           C  
ATOM   4050  CE  LYS B 270      40.297  49.570  10.128  1.00 29.40           C  
ATOM   4051  NZ  LYS B 270      40.673  49.928   8.635  1.00 31.46           N  
ATOM   4052  N   PHE B 271      38.415  50.728  15.344  1.00 21.49           N  
ATOM   4053  CA  PHE B 271      38.717  49.793  16.426  1.00 20.25           C  
ATOM   4054  C   PHE B 271      39.761  48.914  15.891  1.00 19.14           C  
ATOM   4055  O   PHE B 271      39.531  48.257  14.916  1.00 20.65           O  
ATOM   4056  CB  PHE B 271      37.529  48.946  16.720  1.00 19.05           C  
ATOM   4057  CG  PHE B 271      37.714  48.009  17.833  1.00 19.60           C  
ATOM   4058  CD1 PHE B 271      37.619  48.458  19.157  1.00 22.21           C  
ATOM   4059  CD2 PHE B 271      37.897  46.649  17.593  1.00 22.03           C  
ATOM   4060  CE1 PHE B 271      37.695  47.581  20.182  1.00 18.92           C  
ATOM   4061  CE2 PHE B 271      37.980  45.744  18.636  1.00 18.69           C  
ATOM   4062  CZ  PHE B 271      37.894  46.206  19.928  1.00 18.73           C  
ATOM   4063  N   VAL B 272      40.927  48.964  16.487  1.00 18.20           N  
ATOM   4064  CA  VAL B 272      42.088  48.199  15.989  1.00 17.72           C  
ATOM   4065  C   VAL B 272      42.366  47.041  16.964  1.00 17.76           C  
ATOM   4066  O   VAL B 272      42.725  47.251  18.107  1.00 18.07           O  
ATOM   4067  CB  VAL B 272      43.316  49.117  15.826  1.00 17.51           C  
ATOM   4068  CG1 VAL B 272      44.518  48.321  15.611  1.00 18.35           C  
ATOM   4069  CG2 VAL B 272      43.075  50.138  14.680  1.00 12.60           C  
ATOM   4070  N   ARG B 273      42.135  45.825  16.487  1.00 18.80           N  
ATOM   4071  CA  ARG B 273      42.223  44.601  17.293  1.00 20.04           C  
ATOM   4072  C   ARG B 273      43.631  44.099  17.402  1.00 19.34           C  
ATOM   4073  O   ARG B 273      44.269  43.783  16.375  1.00 17.91           O  
ATOM   4074  CB  ARG B 273      41.412  43.487  16.672  1.00 20.89           C  
ATOM   4075  CG  ARG B 273      40.065  43.946  16.210  1.00 25.46           C  
ATOM   4076  CD  ARG B 273      39.460  43.046  15.103  1.00 34.74           C  
ATOM   4077  NE  ARG B 273      38.072  43.438  14.919  1.00 37.08           N  
ATOM   4078  CZ  ARG B 273      37.123  43.169  15.811  1.00 39.68           C  
ATOM   4079  NH1 ARG B 273      35.887  43.590  15.593  1.00 40.31           N  
ATOM   4080  NH2 ARG B 273      37.413  42.485  16.921  1.00 38.10           N  
ATOM   4081  N   ARG B 274      44.121  44.007  18.646  1.00 17.44           N  
ATOM   4082  CA  ARG B 274      45.395  43.363  18.839  1.00 18.72           C  
ATOM   4083  C   ARG B 274      45.303  42.175  19.797  1.00 19.16           C  
ATOM   4084  O   ARG B 274      44.210  41.704  20.091  1.00 20.12           O  
ATOM   4085  CB  ARG B 274      46.446  44.376  19.258  1.00 18.15           C  
ATOM   4086  CG  ARG B 274      46.479  45.551  18.271  1.00 17.90           C  
ATOM   4087  CD  ARG B 274      47.740  46.372  18.419  1.00 21.28           C  
ATOM   4088  NE  ARG B 274      47.860  47.367  17.351  1.00 20.34           N  
ATOM   4089  CZ  ARG B 274      47.724  48.671  17.528  1.00 23.12           C  
ATOM   4090  NH1 ARG B 274      47.456  49.174  18.743  1.00 15.86           N  
ATOM   4091  NH2 ARG B 274      47.897  49.483  16.487  1.00 21.85           N  
ATOM   4092  N   GLN B 275      46.434  41.723  20.304  1.00 18.84           N  
ATOM   4093  CA  GLN B 275      46.483  40.527  21.122  1.00 21.61           C  
ATOM   4094  C   GLN B 275      45.885  40.726  22.517  1.00 19.71           C  
ATOM   4095  O   GLN B 275      45.461  39.776  23.129  1.00 19.00           O  
ATOM   4096  CB  GLN B 275      47.922  40.031  21.188  1.00 21.51           C  
ATOM   4097  CG  GLN B 275      48.152  38.800  22.107  1.00 27.11           C  
ATOM   4098  CD  GLN B 275      49.465  38.077  21.778  1.00 29.24           C  
ATOM   4099  OE1 GLN B 275      50.536  38.734  21.642  1.00 36.32           O  
ATOM   4100  NE2 GLN B 275      49.385  36.734  21.571  1.00 34.52           N  
ATOM   4101  N   SER B 276      45.772  41.960  22.965  1.00 19.39           N  
ATOM   4102  CA  SER B 276      45.320  42.249  24.345  1.00 19.59           C  
ATOM   4103  C   SER B 276      43.836  42.009  24.540  1.00 20.64           C  
ATOM   4104  O   SER B 276      43.367  41.978  25.654  1.00 19.03           O  
ATOM   4105  CB  SER B 276      45.654  43.691  24.710  1.00 19.33           C  
ATOM   4106  OG  SER B 276      44.734  44.551  24.078  1.00 14.41           O  
ATOM   4107  N   SER B 277      43.095  41.855  23.439  1.00 22.73           N  
ATOM   4108  CA  SER B 277      41.699  41.531  23.547  1.00 25.87           C  
ATOM   4109  C   SER B 277      41.294  40.294  22.746  1.00 28.74           C  
ATOM   4110  O   SER B 277      40.402  39.554  23.171  1.00 28.96           O  
ATOM   4111  CB  SER B 277      40.838  42.739  23.145  1.00 24.51           C  
ATOM   4112  OG  SER B 277      40.938  43.011  21.763  1.00 25.49           O  
ATOM   4113  N   GLU B 278      41.956  40.068  21.611  1.00 31.61           N  
ATOM   4114  CA  GLU B 278      41.453  39.137  20.586  1.00 35.71           C  
ATOM   4115  C   GLU B 278      41.262  37.712  21.130  1.00 36.89           C  
ATOM   4116  O   GLU B 278      42.246  37.044  21.482  1.00 38.13           O  
ATOM   4117  CB  GLU B 278      42.369  39.146  19.340  1.00 36.18           C  
ATOM   4118  CG  GLU B 278      42.345  37.854  18.475  1.00 43.72           C  
ATOM   4119  CD  GLU B 278      43.228  36.680  19.040  1.00 51.03           C  
ATOM   4120  OE1 GLU B 278      44.312  36.944  19.648  1.00 52.51           O  
ATOM   4121  OE2 GLU B 278      42.825  35.491  18.866  1.00 52.49           O  
TER    4122      GLU B 278                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
