
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 ( 1680),  selected  100 , name 2a7o_A
# Molecule2: number of CA atoms   66 (  553),  selected   66 , name T0443_31_96.pdb
# PARAMETERS: 2a7o_A.T0443_31_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T    10_A      L      31           -
LGA    S    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    E    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    A    15_A      N      32          5.265
LGA    K    16_A      V      33          3.412
LGA    K    17_A      -       -           -
LGA    S    18_A      Y      34          1.240
LGA    K    19_A      I      35          0.948
LGA    E    20_A      R      36          1.231
LGA    V    21_A      L      37          0.923
LGA    F    22_A      I      38          0.827
LGA    R    23_A      R      39          1.002
LGA    K    24_A      N      40          1.076
LGA    E    25_A      N      41          0.949
LGA    M    26_A      I      42          1.181
LGA    S    27_A      H      43          1.518
LGA    Q    28_A      S      44          1.069
LGA    F    29_A      F      45          1.086
LGA    I    30_A      I      46          2.001
LGA    V    31_A      D      47          2.404
LGA    Q    32_A      R      48          2.228
LGA    C    33_A      C      49          3.046
LGA    L    34_A      Y      50          3.588
LGA    N    35_A      T      51          2.622
LGA    P    36_A      E      52          2.271
LGA    Y    37_A      T      53          1.336
LGA    R    38_A      R      54          2.394
LGA    K    39_A      Q      55          2.773
LGA    P    40_A      Y      56          4.101
LGA    D    41_A      -       -           -
LGA    C    42_A      -       -           -
LGA    K    43_A      -       -           -
LGA    V    44_A      -       -           -
LGA    G    45_A      -       -           -
LGA    R    46_A      -       -           -
LGA    I    47_A      -       -           -
LGA    T    48_A      F      57          3.249
LGA    T    49_A      D      58          1.843
LGA    T    50_A      S      59          1.693
LGA    E    51_A      K      60          0.559
LGA    D    52_A      E      61          0.833
LGA    F    53_A      W      62          0.305
LGA    K    54_A      S      63          1.016
LGA    H    55_A      R      64          1.305
LGA    L    56_A      L      65          1.181
LGA    A    57_A      K      66          1.756
LGA    R    58_A      E      67          2.113
LGA    K    59_A      G      68          2.019
LGA    L    60_A      F      69          1.552
LGA    T    61_A      V      70          2.425
LGA    H    62_A      R      71          2.764
LGA    G    63_A      D      72          2.175
LGA    -       -      A      73           -
LGA    V    64_A      R      74          3.885
LGA    M    65_A      A      75          3.990
LGA    N    66_A      Q      76          4.097
LGA    K    67_A      -       -           -
LGA    E    68_A      T      77          3.553
LGA    L    69_A      -       -           -
LGA    K    70_A      -       -           -
LGA    Y    71_A      -       -           -
LGA    C    72_A      -       -           -
LGA    K    73_A      -       -           -
LGA    N    74_A      -       -           -
LGA    P    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    D    77_A      P      78          5.815
LGA    L    78_A      -       -           -
LGA    E    79_A      -       -           -
LGA    C    80_A      -       -           -
LGA    N    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    N    83_A      -       -           -
LGA    V    84_A      Y      79          2.537
LGA    K    85_A      F      80          2.867
LGA    H    86_A      Q      81          2.556
LGA    K    87_A      E      82          1.940
LGA    T    88_A      I      83          1.414
LGA    K    89_A      P      84          0.834
LGA    E    90_A      G      85          0.864
LGA    Y    91_A      E      86          1.211
LGA    I    92_A      F      87          1.561
LGA    K    93_A      L      88          1.708
LGA    K    94_A      Q      89          2.243
LGA    Y    95_A      Y      90          2.580
LGA    M    96_A      C      91          2.266
LGA    Q    97_A      Q      92          2.873
LGA    K    98_A      S      93          3.942
LGA    -       -      L      94           -
LGA    F    99_A      P      95          2.499
LGA    G   100_A      L      96          4.113
LGA    A   101_A      -       -           -
LGA    V   102_A      -       -           -
LGA    Y   103_A      -       -           -
LGA    K   104_A      -       -           -
LGA    P   105_A      -       -           -
LGA    K   106_A      -       -           -
LGA    E   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    T   109_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100   66    5.0     63    2.46    12.70     67.952     2.457

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.494395 * X  +   0.105024 * Y  +   0.862869 * Z  +   6.501680
  Y_new =   0.851128 * X  +   0.260064 * Y  +   0.456014 * Z  +  12.029593
  Z_new =  -0.176509 * X  +   0.959863 * Y  +  -0.217963 * Z  +   6.026420 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.794087   -1.347506  [ DEG:   102.7936    -77.2064 ]
  Theta =   0.177438    2.964154  [ DEG:    10.1665    169.8335 ]
  Phi   =   2.097031   -1.044561  [ DEG:   120.1510    -59.8489 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2a7o_A                                        
REMARK     2: T0443_31_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2a7o_A.T0443_31_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100   66   5.0   63   2.46   12.70  67.952
REMARK  ---------------------------------------------------------- 
MOLECULE 2a7o_A
HEADER    TRANSCRIPTION                           05-JUL-05   2A7O              
TITLE     SOLUTION STRUCTURE OF THE HSET2/HYPB SRI DOMAIN                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HUNTINGTIN INTERACTING PROTEIN B;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SET2 RPB1-INTERACTING (SRI) DOMAIN, HSET2/HYBP             
COMPND   5 SRI DOMAIN, RESIDUES 1954-2061;                                      
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 OTHER_DETAILS: ISOFORM 1                                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: HSET2/HYPB;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)STAR;                             
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-15B                                   
KEYWDS    SRI DOMAIN, SRI, HSRI, SET2, HSET2, PHOSPHOCTD ASSOCIATING            
KEYWDS   2 PROTEIN, SET2 RPB1-INTERACTING DOMAIN, PCID, PCAP                    
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    M.LI,H.P.PHATNANI,Z.GUAN,H.SAGE,A.GREENLEAF,P.ZHOU                    
REVDAT   2   27-DEC-05 2A7O    1       JRNL                                     
REVDAT   1   01-NOV-05 2A7O    0                                                
JRNL        AUTH   M.LI,H.P.PHATNANI,Z.GUAN,H.SAGE,A.GREENLEAF,P.ZHOU           
JRNL        TITL   SOLUTION STRUCTURE OF THE SET2 RPB1 INTERACTING              
JRNL        TITL 2 DOMAIN OF HUMAN SET2 AND ITS INTERACTION WITH THE            
JRNL        TITL 3 HYPERPHOSPHORYLATED C-TERMINAL DOMAIN OF RPB1                
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 102 17636 2005              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2A7O A    5   112  UNP    Q9BYW2   Q9BYW2_HUMAN  1954   2061             
SEQRES   1 A  112  GLY SER HIS MET THR ALA GLU ALA ASP THR SER SER GLU          
SEQRES   2 A  112  LEU ALA LYS LYS SER LYS GLU VAL PHE ARG LYS GLU MET          
SEQRES   3 A  112  SER GLN PHE ILE VAL GLN CYS LEU ASN PRO TYR ARG LYS          
SEQRES   4 A  112  PRO ASP CYS LYS VAL GLY ARG ILE THR THR THR GLU ASP          
SEQRES   5 A  112  PHE LYS HIS LEU ALA ARG LYS LEU THR HIS GLY VAL MET          
SEQRES   6 A  112  ASN LYS GLU LEU LYS TYR CYS LYS ASN PRO GLU ASP LEU          
SEQRES   7 A  112  GLU CYS ASN GLU ASN VAL LYS HIS LYS THR LYS GLU TYR          
SEQRES   8 A  112  ILE LYS LYS TYR MET GLN LYS PHE GLY ALA VAL TYR LYS          
SEQRES   9 A  112  PRO LYS GLU ASP THR GLU LEU GLU                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   THR A  10       8.788   4.943 -16.199  1.00  0.00           N  
ATOM      2  CA  THR A  10       9.033   6.399 -16.075  1.00  0.00           C  
ATOM      3  C   THR A  10       9.351   6.847 -14.628  1.00  0.00           C  
ATOM      4  O   THR A  10       9.382   8.036 -14.331  1.00  0.00           O  
ATOM      5  CB  THR A  10       7.839   7.246 -16.661  1.00  0.00           C  
ATOM      6  OG1 THR A  10       6.558   6.858 -16.081  1.00  0.00           O  
ATOM      7  CG2 THR A  10       7.767   7.098 -18.167  1.00  0.00           C  
ATOM      8  H   THR A  10       9.273   4.469 -16.909  1.00  0.00           H  
ATOM      9  HA  THR A  10       9.910   6.608 -16.674  1.00  0.00           H  
ATOM     10  HB  THR A  10       8.019   8.284 -16.421  1.00  0.00           H  
ATOM     11  HG1 THR A  10       6.719   6.127 -15.464  1.00  0.00           H  
ATOM     12 HG21 THR A  10       8.697   7.436 -18.601  1.00  0.00           H  
ATOM     13 HG22 THR A  10       6.950   7.693 -18.549  1.00  0.00           H  
ATOM     14 HG23 THR A  10       7.607   6.060 -18.419  1.00  0.00           H  
ATOM     15  N   SER A  11       9.708   5.911 -13.777  1.00  0.00           N  
ATOM     16  CA  SER A  11       9.748   6.153 -12.368  1.00  0.00           C  
ATOM     17  C   SER A  11      11.015   6.695 -11.870  1.00  0.00           C  
ATOM     18  O   SER A  11      11.105   7.013 -10.705  1.00  0.00           O  
ATOM     19  CB  SER A  11       9.410   4.925 -11.634  1.00  0.00           C  
ATOM     20  OG  SER A  11       8.114   4.448 -11.994  1.00  0.00           O  
ATOM     21  H   SER A  11       9.992   5.022 -14.106  1.00  0.00           H  
ATOM     22  HA  SER A  11       9.023   6.896 -12.093  1.00  0.00           H  
ATOM     23  HB2 SER A  11      10.185   4.237 -11.938  1.00  0.00           H  
ATOM     24  HB3 SER A  11       9.474   5.143 -10.580  1.00  0.00           H  
ATOM     25  HG  SER A  11       7.880   4.787 -12.871  1.00  0.00           H  
ATOM     26  N   SER A  12      11.974   6.812 -12.685  1.00  0.00           N  
ATOM     27  CA  SER A  12      13.154   7.401 -12.230  1.00  0.00           C  
ATOM     28  C   SER A  12      12.909   8.906 -12.072  1.00  0.00           C  
ATOM     29  O   SER A  12      13.167   9.491 -11.007  1.00  0.00           O  
ATOM     30  CB  SER A  12      14.268   7.051 -13.179  1.00  0.00           C  
ATOM     31  OG  SER A  12      13.940   7.425 -14.521  1.00  0.00           O  
ATOM     32  H   SER A  12      11.908   6.495 -13.611  1.00  0.00           H  
ATOM     33  HA  SER A  12      13.367   6.988 -11.255  1.00  0.00           H  
ATOM     34  HB2 SER A  12      15.191   7.501 -12.850  1.00  0.00           H  
ATOM     35  HB3 SER A  12      14.314   5.972 -13.121  1.00  0.00           H  
ATOM     36  HG  SER A  12      13.722   6.616 -15.004  1.00  0.00           H  
ATOM     37  N   GLU A  13      12.350   9.510 -13.107  1.00  0.00           N  
ATOM     38  CA  GLU A  13      12.011  10.919 -13.114  1.00  0.00           C  
ATOM     39  C   GLU A  13      10.684  11.211 -12.417  1.00  0.00           C  
ATOM     40  O   GLU A  13      10.530  12.254 -11.786  1.00  0.00           O  
ATOM     41  CB  GLU A  13      12.019  11.453 -14.515  1.00  0.00           C  
ATOM     42  CG  GLU A  13      11.103  10.715 -15.461  1.00  0.00           C  
ATOM     43  CD  GLU A  13      11.140  11.341 -16.818  1.00  0.00           C  
ATOM     44  OE1 GLU A  13      10.487  12.387 -17.019  1.00  0.00           O  
ATOM     45  OE2 GLU A  13      11.839  10.826 -17.703  1.00  0.00           O  
ATOM     46  H   GLU A  13      12.147   9.077 -13.962  1.00  0.00           H  
ATOM     47  HA  GLU A  13      12.794  11.406 -12.554  1.00  0.00           H  
ATOM     48  HB2 GLU A  13      11.719  12.489 -14.497  1.00  0.00           H  
ATOM     49  HB3 GLU A  13      13.024  11.393 -14.906  1.00  0.00           H  
ATOM     50  HG2 GLU A  13      11.404   9.675 -15.502  1.00  0.00           H  
ATOM     51  HG3 GLU A  13      10.096  10.744 -15.072  1.00  0.00           H  
ATOM     52  N   LEU A  14       9.726  10.275 -12.533  1.00  0.00           N  
ATOM     53  CA  LEU A  14       8.401  10.400 -11.890  1.00  0.00           C  
ATOM     54  C   LEU A  14       8.636  10.579 -10.419  1.00  0.00           C  
ATOM     55  O   LEU A  14       8.024  11.392  -9.762  1.00  0.00           O  
ATOM     56  CB  LEU A  14       7.604   9.091 -12.118  1.00  0.00           C  
ATOM     57  CG  LEU A  14       6.074   9.064 -11.862  1.00  0.00           C  
ATOM     58  CD1 LEU A  14       5.496   7.758 -12.380  1.00  0.00           C  
ATOM     59  CD2 LEU A  14       5.735   9.197 -10.382  1.00  0.00           C  
ATOM     60  H   LEU A  14       9.892   9.485 -13.094  1.00  0.00           H  
ATOM     61  HA  LEU A  14       7.860  11.237 -12.306  1.00  0.00           H  
ATOM     62  HB2 LEU A  14       7.794   8.744 -13.121  1.00  0.00           H  
ATOM     63  HB3 LEU A  14       8.049   8.379 -11.441  1.00  0.00           H  
ATOM     64  HG  LEU A  14       5.610   9.874 -12.403  1.00  0.00           H  
ATOM     65 HD11 LEU A  14       5.691   7.672 -13.439  1.00  0.00           H  
ATOM     66 HD12 LEU A  14       4.429   7.741 -12.211  1.00  0.00           H  
ATOM     67 HD13 LEU A  14       5.956   6.931 -11.860  1.00  0.00           H  
ATOM     68 HD21 LEU A  14       6.159  10.116 -10.004  1.00  0.00           H  
ATOM     69 HD22 LEU A  14       6.138   8.356  -9.838  1.00  0.00           H  
ATOM     70 HD23 LEU A  14       4.662   9.225 -10.263  1.00  0.00           H  
ATOM     71  N   ALA A  15       9.611   9.865  -9.953  1.00  0.00           N  
ATOM     72  CA  ALA A  15       9.928   9.844  -8.584  1.00  0.00           C  
ATOM     73  C   ALA A  15      10.750  11.025  -8.176  1.00  0.00           C  
ATOM     74  O   ALA A  15      10.729  11.395  -7.028  1.00  0.00           O  
ATOM     75  CB  ALA A  15      10.594   8.606  -8.220  1.00  0.00           C  
ATOM     76  H   ALA A  15      10.118   9.414 -10.656  1.00  0.00           H  
ATOM     77  HA  ALA A  15       8.982   9.873  -8.069  1.00  0.00           H  
ATOM     78  HB1 ALA A  15      11.510   8.506  -8.779  1.00  0.00           H  
ATOM     79  HB2 ALA A  15       9.927   7.774  -8.410  1.00  0.00           H  
ATOM     80  HB3 ALA A  15      10.821   8.656  -7.165  1.00  0.00           H  
ATOM     81  N   LYS A  16      11.459  11.638  -9.113  1.00  0.00           N  
ATOM     82  CA  LYS A  16      12.193  12.861  -8.807  1.00  0.00           C  
ATOM     83  C   LYS A  16      11.205  13.876  -8.314  1.00  0.00           C  
ATOM     84  O   LYS A  16      11.396  14.524  -7.291  1.00  0.00           O  
ATOM     85  CB  LYS A  16      12.952  13.393 -10.033  1.00  0.00           C  
ATOM     86  CG  LYS A  16      14.128  12.538 -10.481  1.00  0.00           C  
ATOM     87  CD  LYS A  16      15.221  12.488  -9.423  1.00  0.00           C  
ATOM     88  CE  LYS A  16      16.400  11.638  -9.875  1.00  0.00           C  
ATOM     89  NZ  LYS A  16      17.065  12.187 -11.079  1.00  0.00           N  
ATOM     90  H   LYS A  16      11.478  11.276 -10.023  1.00  0.00           H  
ATOM     91  HA  LYS A  16      12.886  12.617  -8.019  1.00  0.00           H  
ATOM     92  HB2 LYS A  16      12.259  13.459 -10.859  1.00  0.00           H  
ATOM     93  HB3 LYS A  16      13.317  14.384  -9.812  1.00  0.00           H  
ATOM     94  HG2 LYS A  16      13.776  11.532 -10.661  1.00  0.00           H  
ATOM     95  HG3 LYS A  16      14.537  12.948 -11.393  1.00  0.00           H  
ATOM     96  HD2 LYS A  16      15.571  13.492  -9.234  1.00  0.00           H  
ATOM     97  HD3 LYS A  16      14.819  12.073  -8.511  1.00  0.00           H  
ATOM     98  HE2 LYS A  16      17.120  11.591  -9.071  1.00  0.00           H  
ATOM     99  HE3 LYS A  16      16.045  10.642 -10.091  1.00  0.00           H  
ATOM    100  HZ1 LYS A  16      17.385  13.160 -10.895  1.00  0.00           H  
ATOM    101  HZ2 LYS A  16      16.447  12.177 -11.914  1.00  0.00           H  
ATOM    102  HZ3 LYS A  16      17.913  11.622 -11.287  1.00  0.00           H  
ATOM    103  N   LYS A  17      10.109  13.922  -8.996  1.00  0.00           N  
ATOM    104  CA  LYS A  17       9.057  14.803  -8.651  1.00  0.00           C  
ATOM    105  C   LYS A  17       8.213  14.223  -7.516  1.00  0.00           C  
ATOM    106  O   LYS A  17       7.775  14.951  -6.648  1.00  0.00           O  
ATOM    107  CB  LYS A  17       8.226  15.121  -9.890  1.00  0.00           C  
ATOM    108  CG  LYS A  17       9.088  15.593 -11.070  1.00  0.00           C  
ATOM    109  CD  LYS A  17       9.954  16.802 -10.705  1.00  0.00           C  
ATOM    110  CE  LYS A  17       9.114  18.048 -10.437  1.00  0.00           C  
ATOM    111  NZ  LYS A  17       9.936  19.180  -9.975  1.00  0.00           N  
ATOM    112  H   LYS A  17      10.018  13.331  -9.776  1.00  0.00           H  
ATOM    113  HA  LYS A  17       9.499  15.719  -8.288  1.00  0.00           H  
ATOM    114  HB2 LYS A  17       7.695  14.227 -10.184  1.00  0.00           H  
ATOM    115  HB3 LYS A  17       7.513  15.897  -9.653  1.00  0.00           H  
ATOM    116  HG2 LYS A  17       9.739  14.781 -11.359  1.00  0.00           H  
ATOM    117  HG3 LYS A  17       8.452  15.848 -11.904  1.00  0.00           H  
ATOM    118  HD2 LYS A  17      10.535  16.545  -9.829  1.00  0.00           H  
ATOM    119  HD3 LYS A  17      10.637  16.996 -11.518  1.00  0.00           H  
ATOM    120  HE2 LYS A  17       8.609  18.337 -11.346  1.00  0.00           H  
ATOM    121  HE3 LYS A  17       8.379  17.819  -9.679  1.00  0.00           H  
ATOM    122  HZ1 LYS A  17      10.768  19.327 -10.582  1.00  0.00           H  
ATOM    123  HZ2 LYS A  17      10.273  19.012  -9.000  1.00  0.00           H  
ATOM    124  HZ3 LYS A  17       9.390  20.064  -9.958  1.00  0.00           H  
ATOM    125  N   SER A  18       8.056  12.906  -7.484  1.00  0.00           N  
ATOM    126  CA  SER A  18       7.196  12.290  -6.493  1.00  0.00           C  
ATOM    127  C   SER A  18       7.820  12.373  -5.094  1.00  0.00           C  
ATOM    128  O   SER A  18       7.112  12.533  -4.146  1.00  0.00           O  
ATOM    129  CB  SER A  18       6.833  10.836  -6.871  1.00  0.00           C  
ATOM    130  OG  SER A  18       5.719  10.335  -6.129  1.00  0.00           O  
ATOM    131  H   SER A  18       8.493  12.327  -8.149  1.00  0.00           H  
ATOM    132  HA  SER A  18       6.301  12.895  -6.491  1.00  0.00           H  
ATOM    133  HB2 SER A  18       6.601  10.779  -7.923  1.00  0.00           H  
ATOM    134  HB3 SER A  18       7.685  10.210  -6.658  1.00  0.00           H  
ATOM    135  HG  SER A  18       6.005   9.925  -5.299  1.00  0.00           H  
ATOM    136  N   LYS A  19       9.155  12.303  -4.979  1.00  0.00           N  
ATOM    137  CA  LYS A  19       9.792  12.353  -3.663  1.00  0.00           C  
ATOM    138  C   LYS A  19       9.669  13.723  -3.085  1.00  0.00           C  
ATOM    139  O   LYS A  19       9.349  13.856  -1.930  1.00  0.00           O  
ATOM    140  CB  LYS A  19      11.285  11.924  -3.657  1.00  0.00           C  
ATOM    141  CG  LYS A  19      11.592  10.587  -4.339  1.00  0.00           C  
ATOM    142  CD  LYS A  19      12.904   9.958  -3.868  1.00  0.00           C  
ATOM    143  CE  LYS A  19      14.105  10.857  -4.073  1.00  0.00           C  
ATOM    144  NZ  LYS A  19      14.336  11.188  -5.494  1.00  0.00           N  
ATOM    145  H   LYS A  19       9.705  12.211  -5.784  1.00  0.00           H  
ATOM    146  HA  LYS A  19       9.239  11.707  -2.996  1.00  0.00           H  
ATOM    147  HB2 LYS A  19      11.859  12.691  -4.152  1.00  0.00           H  
ATOM    148  HB3 LYS A  19      11.612  11.861  -2.630  1.00  0.00           H  
ATOM    149  HG2 LYS A  19      10.792   9.889  -4.158  1.00  0.00           H  
ATOM    150  HG3 LYS A  19      11.660  10.761  -5.402  1.00  0.00           H  
ATOM    151  HD2 LYS A  19      12.822   9.732  -2.816  1.00  0.00           H  
ATOM    152  HD3 LYS A  19      13.057   9.037  -4.412  1.00  0.00           H  
ATOM    153  HE2 LYS A  19      13.930  11.761  -3.508  1.00  0.00           H  
ATOM    154  HE3 LYS A  19      14.965  10.344  -3.668  1.00  0.00           H  
ATOM    155  HZ1 LYS A  19      15.196  11.769  -5.567  1.00  0.00           H  
ATOM    156  HZ2 LYS A  19      13.557  11.748  -5.895  1.00  0.00           H  
ATOM    157  HZ3 LYS A  19      14.488  10.342  -6.080  1.00  0.00           H  
ATOM    158  N   GLU A  20       9.886  14.743  -3.900  1.00  0.00           N  
ATOM    159  CA  GLU A  20       9.780  16.106  -3.425  1.00  0.00           C  
ATOM    160  C   GLU A  20       8.338  16.463  -3.076  1.00  0.00           C  
ATOM    161  O   GLU A  20       8.080  17.072  -2.016  1.00  0.00           O  
ATOM    162  CB  GLU A  20      10.442  17.113  -4.384  1.00  0.00           C  
ATOM    163  CG  GLU A  20      10.024  16.995  -5.832  1.00  0.00           C  
ATOM    164  CD  GLU A  20      10.771  17.941  -6.735  1.00  0.00           C  
ATOM    165  OE1 GLU A  20      11.999  17.771  -6.921  1.00  0.00           O  
ATOM    166  OE2 GLU A  20      10.135  18.851  -7.321  1.00  0.00           O  
ATOM    167  H   GLU A  20      10.107  14.574  -4.839  1.00  0.00           H  
ATOM    168  HA  GLU A  20      10.315  16.125  -2.485  1.00  0.00           H  
ATOM    169  HB2 GLU A  20      10.206  18.114  -4.053  1.00  0.00           H  
ATOM    170  HB3 GLU A  20      11.511  16.973  -4.329  1.00  0.00           H  
ATOM    171  HG2 GLU A  20      10.216  15.985  -6.164  1.00  0.00           H  
ATOM    172  HG3 GLU A  20       8.967  17.201  -5.906  1.00  0.00           H  
ATOM    173  N   VAL A  21       7.396  16.030  -3.914  1.00  0.00           N  
ATOM    174  CA  VAL A  21       5.993  16.246  -3.638  1.00  0.00           C  
ATOM    175  C   VAL A  21       5.613  15.481  -2.387  1.00  0.00           C  
ATOM    176  O   VAL A  21       5.090  16.066  -1.465  1.00  0.00           O  
ATOM    177  CB  VAL A  21       5.063  15.866  -4.832  1.00  0.00           C  
ATOM    178  CG1 VAL A  21       3.593  16.008  -4.453  1.00  0.00           C  
ATOM    179  CG2 VAL A  21       5.356  16.747  -6.033  1.00  0.00           C  
ATOM    180  H   VAL A  21       7.638  15.565  -4.744  1.00  0.00           H  
ATOM    181  HA  VAL A  21       5.832  17.278  -3.364  1.00  0.00           H  
ATOM    182  HB  VAL A  21       5.262  14.840  -5.105  1.00  0.00           H  
ATOM    183 HG11 VAL A  21       3.365  15.354  -3.624  1.00  0.00           H  
ATOM    184 HG12 VAL A  21       2.974  15.754  -5.299  1.00  0.00           H  
ATOM    185 HG13 VAL A  21       3.402  17.031  -4.165  1.00  0.00           H  
ATOM    186 HG21 VAL A  21       4.701  16.478  -6.849  1.00  0.00           H  
ATOM    187 HG22 VAL A  21       6.385  16.613  -6.337  1.00  0.00           H  
ATOM    188 HG23 VAL A  21       5.191  17.777  -5.764  1.00  0.00           H  
ATOM    189  N   PHE A  22       6.005  14.215  -2.320  1.00  0.00           N  
ATOM    190  CA  PHE A  22       5.710  13.349  -1.184  1.00  0.00           C  
ATOM    191  C   PHE A  22       6.247  13.929   0.079  1.00  0.00           C  
ATOM    192  O   PHE A  22       5.508  14.111   1.045  1.00  0.00           O  
ATOM    193  CB  PHE A  22       6.307  11.935  -1.411  1.00  0.00           C  
ATOM    194  CG  PHE A  22       6.574  11.143  -0.154  1.00  0.00           C  
ATOM    195  CD1 PHE A  22       5.569  10.850   0.737  1.00  0.00           C  
ATOM    196  CD2 PHE A  22       7.848  10.714   0.132  1.00  0.00           C  
ATOM    197  CE1 PHE A  22       5.832  10.147   1.895  1.00  0.00           C  
ATOM    198  CE2 PHE A  22       8.113  10.014   1.275  1.00  0.00           C  
ATOM    199  CZ  PHE A  22       7.115   9.726   2.158  1.00  0.00           C  
ATOM    200  H   PHE A  22       6.554  13.825  -3.038  1.00  0.00           H  
ATOM    201  HA  PHE A  22       4.642  13.234  -1.069  1.00  0.00           H  
ATOM    202  HB2 PHE A  22       5.622  11.364  -2.018  1.00  0.00           H  
ATOM    203  HB3 PHE A  22       7.235  12.057  -1.950  1.00  0.00           H  
ATOM    204  HD1 PHE A  22       4.567  11.188   0.507  1.00  0.00           H  
ATOM    205  HD2 PHE A  22       8.653  10.927  -0.554  1.00  0.00           H  
ATOM    206  HE1 PHE A  22       5.036   9.933   2.589  1.00  0.00           H  
ATOM    207  HE2 PHE A  22       9.118   9.683   1.480  1.00  0.00           H  
ATOM    208  HZ  PHE A  22       7.366   9.171   3.051  1.00  0.00           H  
ATOM    209  N   ARG A  23       7.524  14.239   0.065  1.00  0.00           N  
ATOM    210  CA  ARG A  23       8.161  14.770   1.242  1.00  0.00           C  
ATOM    211  C   ARG A  23       7.519  16.100   1.658  1.00  0.00           C  
ATOM    212  O   ARG A  23       7.452  16.405   2.815  1.00  0.00           O  
ATOM    213  CB  ARG A  23       9.697  14.854   1.077  1.00  0.00           C  
ATOM    214  CG  ARG A  23      10.231  15.972   0.190  1.00  0.00           C  
ATOM    215  CD  ARG A  23      10.506  17.234   1.005  1.00  0.00           C  
ATOM    216  NE  ARG A  23      11.136  18.297   0.223  1.00  0.00           N  
ATOM    217  CZ  ARG A  23      10.936  19.606   0.419  1.00  0.00           C  
ATOM    218  NH1 ARG A  23       9.940  20.025   1.218  1.00  0.00           N  
ATOM    219  NH2 ARG A  23      11.702  20.494  -0.207  1.00  0.00           N  
ATOM    220  H   ARG A  23       7.996  14.049  -0.785  1.00  0.00           H  
ATOM    221  HA  ARG A  23       7.936  14.066   2.032  1.00  0.00           H  
ATOM    222  HB2 ARG A  23      10.143  14.972   2.052  1.00  0.00           H  
ATOM    223  HB3 ARG A  23      10.029  13.911   0.665  1.00  0.00           H  
ATOM    224  HG2 ARG A  23      11.094  15.635  -0.361  1.00  0.00           H  
ATOM    225  HG3 ARG A  23       9.450  16.198  -0.521  1.00  0.00           H  
ATOM    226  HD2 ARG A  23       9.570  17.603   1.396  1.00  0.00           H  
ATOM    227  HD3 ARG A  23      11.155  16.975   1.829  1.00  0.00           H  
ATOM    228  HE  ARG A  23      11.796  17.977  -0.436  1.00  0.00           H  
ATOM    229 HH11 ARG A  23       9.324  19.394   1.689  1.00  0.00           H  
ATOM    230 HH12 ARG A  23       9.750  20.999   1.361  1.00  0.00           H  
ATOM    231 HH21 ARG A  23      12.440  20.215  -0.830  1.00  0.00           H  
ATOM    232 HH22 ARG A  23      11.588  21.483  -0.091  1.00  0.00           H  
ATOM    233  N   LYS A  24       7.007  16.849   0.696  1.00  0.00           N  
ATOM    234  CA  LYS A  24       6.340  18.102   0.978  1.00  0.00           C  
ATOM    235  C   LYS A  24       4.981  17.851   1.634  1.00  0.00           C  
ATOM    236  O   LYS A  24       4.670  18.436   2.678  1.00  0.00           O  
ATOM    237  CB  LYS A  24       6.142  18.875  -0.308  1.00  0.00           C  
ATOM    238  CG  LYS A  24       5.530  20.247  -0.123  1.00  0.00           C  
ATOM    239  CD  LYS A  24       5.359  20.952  -1.447  1.00  0.00           C  
ATOM    240  CE  LYS A  24       4.428  20.183  -2.374  1.00  0.00           C  
ATOM    241  NZ  LYS A  24       4.151  20.906  -3.629  1.00  0.00           N  
ATOM    242  H   LYS A  24       7.072  16.551  -0.242  1.00  0.00           H  
ATOM    243  HA  LYS A  24       6.963  18.695   1.631  1.00  0.00           H  
ATOM    244  HB2 LYS A  24       7.099  18.984  -0.795  1.00  0.00           H  
ATOM    245  HB3 LYS A  24       5.493  18.294  -0.947  1.00  0.00           H  
ATOM    246  HG2 LYS A  24       4.566  20.141   0.349  1.00  0.00           H  
ATOM    247  HG3 LYS A  24       6.179  20.835   0.510  1.00  0.00           H  
ATOM    248  HD2 LYS A  24       4.966  21.941  -1.270  1.00  0.00           H  
ATOM    249  HD3 LYS A  24       6.336  21.020  -1.901  1.00  0.00           H  
ATOM    250  HE2 LYS A  24       4.886  19.238  -2.628  1.00  0.00           H  
ATOM    251  HE3 LYS A  24       3.498  20.003  -1.856  1.00  0.00           H  
ATOM    252  HZ1 LYS A  24       3.672  21.807  -3.437  1.00  0.00           H  
ATOM    253  HZ2 LYS A  24       3.503  20.329  -4.202  1.00  0.00           H  
ATOM    254  HZ3 LYS A  24       5.017  21.079  -4.182  1.00  0.00           H  
ATOM    255  N   GLU A  25       4.194  16.936   1.041  1.00  0.00           N  
ATOM    256  CA  GLU A  25       2.844  16.610   1.520  1.00  0.00           C  
ATOM    257  C   GLU A  25       2.957  16.118   2.909  1.00  0.00           C  
ATOM    258  O   GLU A  25       2.230  16.532   3.816  1.00  0.00           O  
ATOM    259  CB  GLU A  25       2.311  15.435   0.786  1.00  0.00           C  
ATOM    260  CG  GLU A  25       2.372  15.473  -0.682  1.00  0.00           C  
ATOM    261  CD  GLU A  25       1.225  16.180  -1.318  1.00  0.00           C  
ATOM    262  OE1 GLU A  25       0.112  15.602  -1.371  1.00  0.00           O  
ATOM    263  OE2 GLU A  25       1.384  17.339  -1.757  1.00  0.00           O  
ATOM    264  H   GLU A  25       4.521  16.431   0.260  1.00  0.00           H  
ATOM    265  HA  GLU A  25       2.184  17.452   1.409  1.00  0.00           H  
ATOM    266  HB2 GLU A  25       2.872  14.572   1.111  1.00  0.00           H  
ATOM    267  HB3 GLU A  25       1.283  15.296   1.084  1.00  0.00           H  
ATOM    268  HG2 GLU A  25       3.287  15.991  -0.941  1.00  0.00           H  
ATOM    269  HG3 GLU A  25       2.464  14.432  -0.936  1.00  0.00           H  
ATOM    270  N   MET A  26       3.859  15.184   3.040  1.00  0.00           N  
ATOM    271  CA  MET A  26       4.114  14.518   4.279  1.00  0.00           C  
ATOM    272  C   MET A  26       4.704  15.442   5.331  1.00  0.00           C  
ATOM    273  O   MET A  26       4.351  15.346   6.461  1.00  0.00           O  
ATOM    274  CB  MET A  26       4.977  13.299   4.044  1.00  0.00           C  
ATOM    275  CG  MET A  26       5.241  12.482   5.297  1.00  0.00           C  
ATOM    276  SD  MET A  26       3.771  12.280   6.351  1.00  0.00           S  
ATOM    277  CE  MET A  26       2.757  11.054   5.545  1.00  0.00           C  
ATOM    278  H   MET A  26       4.353  14.920   2.222  1.00  0.00           H  
ATOM    279  HA  MET A  26       3.163  14.159   4.644  1.00  0.00           H  
ATOM    280  HB2 MET A  26       4.500  12.709   3.279  1.00  0.00           H  
ATOM    281  HB3 MET A  26       5.912  13.685   3.668  1.00  0.00           H  
ATOM    282  HG2 MET A  26       5.586  11.500   5.004  1.00  0.00           H  
ATOM    283  HG3 MET A  26       6.013  12.971   5.872  1.00  0.00           H  
ATOM    284  HE1 MET A  26       3.308  10.128   5.482  1.00  0.00           H  
ATOM    285  HE2 MET A  26       2.418  11.378   4.573  1.00  0.00           H  
ATOM    286  HE3 MET A  26       1.915  10.895   6.213  1.00  0.00           H  
ATOM    287  N   SER A  27       5.575  16.359   4.945  1.00  0.00           N  
ATOM    288  CA  SER A  27       6.059  17.329   5.885  1.00  0.00           C  
ATOM    289  C   SER A  27       4.900  18.155   6.385  1.00  0.00           C  
ATOM    290  O   SER A  27       4.823  18.450   7.548  1.00  0.00           O  
ATOM    291  CB  SER A  27       7.196  18.214   5.339  1.00  0.00           C  
ATOM    292  OG  SER A  27       8.411  17.472   5.192  1.00  0.00           O  
ATOM    293  H   SER A  27       5.838  16.308   4.008  1.00  0.00           H  
ATOM    294  HA  SER A  27       6.427  16.751   6.719  1.00  0.00           H  
ATOM    295  HB2 SER A  27       6.912  18.605   4.373  1.00  0.00           H  
ATOM    296  HB3 SER A  27       7.370  19.031   6.023  1.00  0.00           H  
ATOM    297  HG  SER A  27       8.199  16.600   5.566  1.00  0.00           H  
ATOM    298  N   GLN A  28       3.949  18.439   5.513  1.00  0.00           N  
ATOM    299  CA  GLN A  28       2.771  19.209   5.906  1.00  0.00           C  
ATOM    300  C   GLN A  28       1.854  18.386   6.806  1.00  0.00           C  
ATOM    301  O   GLN A  28       1.309  18.899   7.796  1.00  0.00           O  
ATOM    302  CB  GLN A  28       2.026  19.711   4.680  1.00  0.00           C  
ATOM    303  CG  GLN A  28       2.800  20.739   3.890  1.00  0.00           C  
ATOM    304  CD  GLN A  28       2.946  22.039   4.644  1.00  0.00           C  
ATOM    305  OE1 GLN A  28       3.899  22.244   5.399  1.00  0.00           O  
ATOM    306  NE2 GLN A  28       2.015  22.924   4.450  1.00  0.00           N  
ATOM    307  H   GLN A  28       4.014  18.152   4.569  1.00  0.00           H  
ATOM    308  HA  GLN A  28       3.116  20.053   6.485  1.00  0.00           H  
ATOM    309  HB2 GLN A  28       1.817  18.870   4.034  1.00  0.00           H  
ATOM    310  HB3 GLN A  28       1.093  20.153   4.995  1.00  0.00           H  
ATOM    311  HG2 GLN A  28       3.785  20.343   3.696  1.00  0.00           H  
ATOM    312  HG3 GLN A  28       2.296  20.918   2.953  1.00  0.00           H  
ATOM    313 HE21 GLN A  28       1.280  22.710   3.836  1.00  0.00           H  
ATOM    314 HE22 GLN A  28       2.066  23.785   4.918  1.00  0.00           H  
ATOM    315  N   PHE A  29       1.674  17.138   6.445  1.00  0.00           N  
ATOM    316  CA  PHE A  29       0.894  16.188   7.218  1.00  0.00           C  
ATOM    317  C   PHE A  29       1.519  15.981   8.602  1.00  0.00           C  
ATOM    318  O   PHE A  29       0.830  16.032   9.618  1.00  0.00           O  
ATOM    319  CB  PHE A  29       0.800  14.867   6.451  1.00  0.00           C  
ATOM    320  CG  PHE A  29       0.055  13.775   7.159  1.00  0.00           C  
ATOM    321  CD1 PHE A  29      -1.319  13.697   7.094  1.00  0.00           C  
ATOM    322  CD2 PHE A  29       0.744  12.813   7.870  1.00  0.00           C  
ATOM    323  CE1 PHE A  29      -1.989  12.677   7.730  1.00  0.00           C  
ATOM    324  CE2 PHE A  29       0.084  11.802   8.506  1.00  0.00           C  
ATOM    325  CZ  PHE A  29      -1.277  11.731   8.438  1.00  0.00           C  
ATOM    326  H   PHE A  29       2.045  16.859   5.577  1.00  0.00           H  
ATOM    327  HA  PHE A  29      -0.096  16.604   7.329  1.00  0.00           H  
ATOM    328  HB2 PHE A  29       0.307  15.037   5.506  1.00  0.00           H  
ATOM    329  HB3 PHE A  29       1.803  14.515   6.262  1.00  0.00           H  
ATOM    330  HD1 PHE A  29      -1.870  14.444   6.540  1.00  0.00           H  
ATOM    331  HD2 PHE A  29       1.821  12.863   7.928  1.00  0.00           H  
ATOM    332  HE1 PHE A  29      -3.064  12.616   7.672  1.00  0.00           H  
ATOM    333  HE2 PHE A  29       0.626  11.053   9.061  1.00  0.00           H  
ATOM    334  HZ  PHE A  29      -1.769  10.911   8.939  1.00  0.00           H  
ATOM    335  N   ILE A  30       2.813  15.758   8.624  1.00  0.00           N  
ATOM    336  CA  ILE A  30       3.565  15.595   9.849  1.00  0.00           C  
ATOM    337  C   ILE A  30       3.502  16.860  10.663  1.00  0.00           C  
ATOM    338  O   ILE A  30       3.277  16.800  11.858  1.00  0.00           O  
ATOM    339  CB  ILE A  30       5.036  15.175   9.595  1.00  0.00           C  
ATOM    340  CG1 ILE A  30       5.068  13.757   9.029  1.00  0.00           C  
ATOM    341  CG2 ILE A  30       5.846  15.261  10.883  1.00  0.00           C  
ATOM    342  CD1 ILE A  30       6.419  13.300   8.533  1.00  0.00           C  
ATOM    343  H   ILE A  30       3.276  15.670   7.764  1.00  0.00           H  
ATOM    344  HA  ILE A  30       3.069  14.818  10.409  1.00  0.00           H  
ATOM    345  HB  ILE A  30       5.467  15.850   8.871  1.00  0.00           H  
ATOM    346 HG12 ILE A  30       4.753  13.062   9.793  1.00  0.00           H  
ATOM    347 HG13 ILE A  30       4.375  13.693   8.203  1.00  0.00           H  
ATOM    348 HG21 ILE A  30       6.872  14.986  10.695  1.00  0.00           H  
ATOM    349 HG22 ILE A  30       5.412  14.594  11.613  1.00  0.00           H  
ATOM    350 HG23 ILE A  30       5.794  16.270  11.267  1.00  0.00           H  
ATOM    351 HD11 ILE A  30       7.162  13.317   9.315  1.00  0.00           H  
ATOM    352 HD12 ILE A  30       6.768  13.939   7.729  1.00  0.00           H  
ATOM    353 HD13 ILE A  30       6.371  12.299   8.132  1.00  0.00           H  
ATOM    354  N   VAL A  31       3.682  18.007  10.013  1.00  0.00           N  
ATOM    355  CA  VAL A  31       3.496  19.301  10.688  1.00  0.00           C  
ATOM    356  C   VAL A  31       2.139  19.338  11.404  1.00  0.00           C  
ATOM    357  O   VAL A  31       2.060  19.642  12.588  1.00  0.00           O  
ATOM    358  CB  VAL A  31       3.637  20.501   9.681  1.00  0.00           C  
ATOM    359  CG1 VAL A  31       3.008  21.790  10.211  1.00  0.00           C  
ATOM    360  CG2 VAL A  31       5.111  20.757   9.396  1.00  0.00           C  
ATOM    361  H   VAL A  31       3.992  18.000   9.071  1.00  0.00           H  
ATOM    362  HA  VAL A  31       4.276  19.370  11.432  1.00  0.00           H  
ATOM    363  HB  VAL A  31       3.159  20.213   8.758  1.00  0.00           H  
ATOM    364 HG11 VAL A  31       3.050  22.548   9.442  1.00  0.00           H  
ATOM    365 HG12 VAL A  31       3.571  22.139  11.061  1.00  0.00           H  
ATOM    366 HG13 VAL A  31       1.981  21.612  10.495  1.00  0.00           H  
ATOM    367 HG21 VAL A  31       5.605  21.049  10.312  1.00  0.00           H  
ATOM    368 HG22 VAL A  31       5.222  21.536   8.656  1.00  0.00           H  
ATOM    369 HG23 VAL A  31       5.565  19.843   9.038  1.00  0.00           H  
ATOM    370  N   GLN A  32       1.103  18.951  10.694  1.00  0.00           N  
ATOM    371  CA  GLN A  32      -0.260  18.911  11.209  1.00  0.00           C  
ATOM    372  C   GLN A  32      -0.348  17.977  12.425  1.00  0.00           C  
ATOM    373  O   GLN A  32      -0.983  18.290  13.434  1.00  0.00           O  
ATOM    374  CB  GLN A  32      -1.156  18.383  10.102  1.00  0.00           C  
ATOM    375  CG  GLN A  32      -2.631  18.431  10.376  1.00  0.00           C  
ATOM    376  CD  GLN A  32      -3.417  17.788   9.256  1.00  0.00           C  
ATOM    377  OE1 GLN A  32      -3.791  18.447   8.279  1.00  0.00           O  
ATOM    378  NE2 GLN A  32      -3.668  16.508   9.377  1.00  0.00           N  
ATOM    379  H   GLN A  32       1.216  18.703   9.750  1.00  0.00           H  
ATOM    380  HA  GLN A  32      -0.520  19.941  11.407  1.00  0.00           H  
ATOM    381  HB2 GLN A  32      -0.960  18.945   9.205  1.00  0.00           H  
ATOM    382  HB3 GLN A  32      -0.882  17.354   9.914  1.00  0.00           H  
ATOM    383  HG2 GLN A  32      -2.823  17.911  11.302  1.00  0.00           H  
ATOM    384  HG3 GLN A  32      -2.922  19.467  10.462  1.00  0.00           H  
ATOM    385 HE21 GLN A  32      -3.344  16.030  10.171  1.00  0.00           H  
ATOM    386 HE22 GLN A  32      -4.177  16.052   8.676  1.00  0.00           H  
ATOM    387  N   CYS A  33       0.289  16.839  12.295  1.00  0.00           N  
ATOM    388  CA  CYS A  33       0.348  15.831  13.328  1.00  0.00           C  
ATOM    389  C   CYS A  33       1.118  16.302  14.553  1.00  0.00           C  
ATOM    390  O   CYS A  33       0.748  15.977  15.667  1.00  0.00           O  
ATOM    391  CB  CYS A  33       0.985  14.573  12.763  1.00  0.00           C  
ATOM    392  SG  CYS A  33       0.031  13.803  11.441  1.00  0.00           S  
ATOM    393  H   CYS A  33       0.728  16.650  11.436  1.00  0.00           H  
ATOM    394  HA  CYS A  33      -0.659  15.583  13.627  1.00  0.00           H  
ATOM    395  HB2 CYS A  33       1.926  14.878  12.328  1.00  0.00           H  
ATOM    396  HB3 CYS A  33       1.148  13.850  13.547  1.00  0.00           H  
ATOM    397  HG  CYS A  33       0.177  14.595  10.384  1.00  0.00           H  
ATOM    398  N   LEU A  34       2.178  17.053  14.328  1.00  0.00           N  
ATOM    399  CA  LEU A  34       3.024  17.585  15.397  1.00  0.00           C  
ATOM    400  C   LEU A  34       2.425  18.811  16.067  1.00  0.00           C  
ATOM    401  O   LEU A  34       2.802  19.145  17.185  1.00  0.00           O  
ATOM    402  CB  LEU A  34       4.415  17.923  14.893  1.00  0.00           C  
ATOM    403  CG  LEU A  34       5.254  16.785  14.356  1.00  0.00           C  
ATOM    404  CD1 LEU A  34       6.600  17.311  13.923  1.00  0.00           C  
ATOM    405  CD2 LEU A  34       5.430  15.701  15.395  1.00  0.00           C  
ATOM    406  H   LEU A  34       2.420  17.203  13.388  1.00  0.00           H  
ATOM    407  HA  LEU A  34       3.119  16.809  16.140  1.00  0.00           H  
ATOM    408  HB2 LEU A  34       4.307  18.653  14.105  1.00  0.00           H  
ATOM    409  HB3 LEU A  34       4.957  18.389  15.702  1.00  0.00           H  
ATOM    410  HG  LEU A  34       4.744  16.360  13.505  1.00  0.00           H  
ATOM    411 HD11 LEU A  34       7.111  17.737  14.773  1.00  0.00           H  
ATOM    412 HD12 LEU A  34       6.454  18.079  13.176  1.00  0.00           H  
ATOM    413 HD13 LEU A  34       7.190  16.509  13.507  1.00  0.00           H  
ATOM    414 HD21 LEU A  34       4.468  15.282  15.652  1.00  0.00           H  
ATOM    415 HD22 LEU A  34       5.884  16.122  16.280  1.00  0.00           H  
ATOM    416 HD23 LEU A  34       6.067  14.924  14.998  1.00  0.00           H  
ATOM    417  N   ASN A  35       1.545  19.523  15.361  1.00  0.00           N  
ATOM    418  CA  ASN A  35       0.810  20.670  15.937  1.00  0.00           C  
ATOM    419  C   ASN A  35       0.339  20.538  17.396  1.00  0.00           C  
ATOM    420  O   ASN A  35       0.578  21.441  18.181  1.00  0.00           O  
ATOM    421  CB  ASN A  35      -0.308  21.141  15.048  1.00  0.00           C  
ATOM    422  CG  ASN A  35       0.220  22.274  14.305  1.00  0.00           C  
ATOM    423  OD1 ASN A  35       0.008  23.435  14.659  1.00  0.00           O  
ATOM    424  ND2 ASN A  35       1.014  21.972  13.370  1.00  0.00           N  
ATOM    425  H   ASN A  35       1.457  19.335  14.396  1.00  0.00           H  
ATOM    426  HA  ASN A  35       1.567  21.448  15.873  1.00  0.00           H  
ATOM    427  HB2 ASN A  35      -0.585  20.359  14.356  1.00  0.00           H  
ATOM    428  HB3 ASN A  35      -1.157  21.466  15.632  1.00  0.00           H  
ATOM    429 HD21 ASN A  35       1.206  21.029  13.165  1.00  0.00           H  
ATOM    430 HD22 ASN A  35       1.505  22.687  12.944  1.00  0.00           H  
ATOM    431  N   PRO A  36      -0.321  19.426  17.808  1.00  0.00           N  
ATOM    432  CA  PRO A  36      -0.744  19.252  19.207  1.00  0.00           C  
ATOM    433  C   PRO A  36       0.437  19.043  20.176  1.00  0.00           C  
ATOM    434  O   PRO A  36       0.303  19.248  21.391  1.00  0.00           O  
ATOM    435  CB  PRO A  36      -1.633  18.005  19.165  1.00  0.00           C  
ATOM    436  CG  PRO A  36      -1.182  17.258  17.962  1.00  0.00           C  
ATOM    437  CD  PRO A  36      -0.762  18.292  16.968  1.00  0.00           C  
ATOM    438  HA  PRO A  36      -1.311  20.103  19.547  1.00  0.00           H  
ATOM    439  HB2 PRO A  36      -1.494  17.425  20.066  1.00  0.00           H  
ATOM    440  HB3 PRO A  36      -2.669  18.285  19.070  1.00  0.00           H  
ATOM    441  HG2 PRO A  36      -0.338  16.627  18.202  1.00  0.00           H  
ATOM    442  HG3 PRO A  36      -1.989  16.665  17.559  1.00  0.00           H  
ATOM    443  HD2 PRO A  36       0.064  17.915  16.382  1.00  0.00           H  
ATOM    444  HD3 PRO A  36      -1.569  18.576  16.310  1.00  0.00           H  
ATOM    445  N   TYR A  37       1.586  18.689  19.637  1.00  0.00           N  
ATOM    446  CA  TYR A  37       2.753  18.391  20.444  1.00  0.00           C  
ATOM    447  C   TYR A  37       3.497  19.651  20.815  1.00  0.00           C  
ATOM    448  O   TYR A  37       4.154  19.709  21.828  1.00  0.00           O  
ATOM    449  CB  TYR A  37       3.698  17.412  19.731  1.00  0.00           C  
ATOM    450  CG  TYR A  37       3.114  16.035  19.500  1.00  0.00           C  
ATOM    451  CD1 TYR A  37       2.282  15.793  18.434  1.00  0.00           C  
ATOM    452  CD2 TYR A  37       3.404  14.983  20.351  1.00  0.00           C  
ATOM    453  CE1 TYR A  37       1.740  14.554  18.212  1.00  0.00           C  
ATOM    454  CE2 TYR A  37       2.879  13.731  20.148  1.00  0.00           C  
ATOM    455  CZ  TYR A  37       2.036  13.516  19.073  1.00  0.00           C  
ATOM    456  OH  TYR A  37       1.481  12.266  18.866  1.00  0.00           O  
ATOM    457  H   TYR A  37       1.666  18.635  18.659  1.00  0.00           H  
ATOM    458  HA  TYR A  37       2.403  17.927  21.353  1.00  0.00           H  
ATOM    459  HB2 TYR A  37       3.964  17.819  18.769  1.00  0.00           H  
ATOM    460  HB3 TYR A  37       4.593  17.298  20.326  1.00  0.00           H  
ATOM    461  HD1 TYR A  37       2.047  16.607  17.766  1.00  0.00           H  
ATOM    462  HD2 TYR A  37       4.075  15.136  21.182  1.00  0.00           H  
ATOM    463  HE1 TYR A  37       1.104  14.434  17.345  1.00  0.00           H  
ATOM    464  HE2 TYR A  37       3.144  12.950  20.848  1.00  0.00           H  
ATOM    465  HH  TYR A  37       1.162  11.940  19.715  1.00  0.00           H  
ATOM    466  N   ARG A  38       3.366  20.677  20.008  1.00  0.00           N  
ATOM    467  CA  ARG A  38       4.095  21.932  20.268  1.00  0.00           C  
ATOM    468  C   ARG A  38       3.330  22.832  21.227  1.00  0.00           C  
ATOM    469  O   ARG A  38       3.781  23.923  21.588  1.00  0.00           O  
ATOM    470  CB  ARG A  38       4.375  22.674  18.974  1.00  0.00           C  
ATOM    471  CG  ARG A  38       3.128  23.112  18.250  1.00  0.00           C  
ATOM    472  CD  ARG A  38       3.477  23.920  17.034  1.00  0.00           C  
ATOM    473  NE  ARG A  38       2.296  24.427  16.325  1.00  0.00           N  
ATOM    474  CZ  ARG A  38       2.122  25.709  15.972  1.00  0.00           C  
ATOM    475  NH1 ARG A  38       2.935  26.653  16.437  1.00  0.00           N  
ATOM    476  NH2 ARG A  38       1.110  26.043  15.193  1.00  0.00           N  
ATOM    477  H   ARG A  38       2.795  20.576  19.215  1.00  0.00           H  
ATOM    478  HA  ARG A  38       5.033  21.673  20.734  1.00  0.00           H  
ATOM    479  HB2 ARG A  38       4.962  23.552  19.195  1.00  0.00           H  
ATOM    480  HB3 ARG A  38       4.940  22.028  18.316  1.00  0.00           H  
ATOM    481  HG2 ARG A  38       2.582  22.226  17.958  1.00  0.00           H  
ATOM    482  HG3 ARG A  38       2.520  23.690  18.931  1.00  0.00           H  
ATOM    483  HD2 ARG A  38       4.110  24.745  17.325  1.00  0.00           H  
ATOM    484  HD3 ARG A  38       4.022  23.262  16.372  1.00  0.00           H  
ATOM    485  HE  ARG A  38       1.636  23.756  16.042  1.00  0.00           H  
ATOM    486 HH11 ARG A  38       3.692  26.458  17.065  1.00  0.00           H  
ATOM    487 HH12 ARG A  38       2.839  27.615  16.166  1.00  0.00           H  
ATOM    488 HH21 ARG A  38       0.452  25.365  14.849  1.00  0.00           H  
ATOM    489 HH22 ARG A  38       0.970  26.996  14.908  1.00  0.00           H  
ATOM    490  N   LYS A  39       2.184  22.368  21.624  1.00  0.00           N  
ATOM    491  CA  LYS A  39       1.336  23.089  22.543  1.00  0.00           C  
ATOM    492  C   LYS A  39       1.909  22.955  23.955  1.00  0.00           C  
ATOM    493  O   LYS A  39       2.368  21.880  24.332  1.00  0.00           O  
ATOM    494  CB  LYS A  39      -0.087  22.525  22.498  1.00  0.00           C  
ATOM    495  CG  LYS A  39      -0.702  22.507  21.112  1.00  0.00           C  
ATOM    496  CD  LYS A  39      -0.757  23.891  20.496  1.00  0.00           C  
ATOM    497  CE  LYS A  39      -1.306  23.827  19.086  1.00  0.00           C  
ATOM    498  NZ  LYS A  39      -1.368  25.158  18.446  1.00  0.00           N  
ATOM    499  H   LYS A  39       1.928  21.478  21.310  1.00  0.00           H  
ATOM    500  HA  LYS A  39       1.324  24.130  22.258  1.00  0.00           H  
ATOM    501  HB2 LYS A  39      -0.073  21.514  22.876  1.00  0.00           H  
ATOM    502  HB3 LYS A  39      -0.717  23.128  23.135  1.00  0.00           H  
ATOM    503  HG2 LYS A  39      -0.107  21.865  20.478  1.00  0.00           H  
ATOM    504  HG3 LYS A  39      -1.704  22.110  21.184  1.00  0.00           H  
ATOM    505  HD2 LYS A  39      -1.390  24.523  21.100  1.00  0.00           H  
ATOM    506  HD3 LYS A  39       0.244  24.293  20.466  1.00  0.00           H  
ATOM    507  HE2 LYS A  39      -0.651  23.187  18.512  1.00  0.00           H  
ATOM    508  HE3 LYS A  39      -2.294  23.393  19.117  1.00  0.00           H  
ATOM    509  HZ1 LYS A  39      -0.435  25.597  18.325  1.00  0.00           H  
ATOM    510  HZ2 LYS A  39      -1.927  25.810  19.028  1.00  0.00           H  
ATOM    511  HZ3 LYS A  39      -1.836  25.113  17.518  1.00  0.00           H  
ATOM    512  N   PRO A  40       1.861  24.024  24.765  1.00  0.00           N  
ATOM    513  CA  PRO A  40       2.446  24.041  26.123  1.00  0.00           C  
ATOM    514  C   PRO A  40       1.807  23.032  27.091  1.00  0.00           C  
ATOM    515  O   PRO A  40       2.354  22.745  28.154  1.00  0.00           O  
ATOM    516  CB  PRO A  40       2.193  25.470  26.613  1.00  0.00           C  
ATOM    517  CG  PRO A  40       1.070  25.967  25.776  1.00  0.00           C  
ATOM    518  CD  PRO A  40       1.240  25.320  24.432  1.00  0.00           C  
ATOM    519  HA  PRO A  40       3.510  23.863  26.084  1.00  0.00           H  
ATOM    520  HB2 PRO A  40       1.934  25.454  27.660  1.00  0.00           H  
ATOM    521  HB3 PRO A  40       3.084  26.061  26.465  1.00  0.00           H  
ATOM    522  HG2 PRO A  40       0.128  25.677  26.218  1.00  0.00           H  
ATOM    523  HG3 PRO A  40       1.128  27.041  25.686  1.00  0.00           H  
ATOM    524  HD2 PRO A  40       0.285  25.176  23.951  1.00  0.00           H  
ATOM    525  HD3 PRO A  40       1.900  25.904  23.808  1.00  0.00           H  
ATOM    526  N   ASP A  41       0.678  22.485  26.716  1.00  0.00           N  
ATOM    527  CA  ASP A  41      -0.021  21.527  27.568  1.00  0.00           C  
ATOM    528  C   ASP A  41       0.085  20.103  26.986  1.00  0.00           C  
ATOM    529  O   ASP A  41      -0.611  19.175  27.404  1.00  0.00           O  
ATOM    530  CB  ASP A  41      -1.479  21.980  27.764  1.00  0.00           C  
ATOM    531  CG  ASP A  41      -2.319  21.078  28.646  1.00  0.00           C  
ATOM    532  OD1 ASP A  41      -1.936  20.812  29.808  1.00  0.00           O  
ATOM    533  OD2 ASP A  41      -3.393  20.622  28.183  1.00  0.00           O  
ATOM    534  H   ASP A  41       0.293  22.708  25.841  1.00  0.00           H  
ATOM    535  HA  ASP A  41       0.482  21.531  28.525  1.00  0.00           H  
ATOM    536  HB2 ASP A  41      -1.483  22.965  28.210  1.00  0.00           H  
ATOM    537  HB3 ASP A  41      -1.951  22.040  26.793  1.00  0.00           H  
ATOM    538  N   CYS A  42       0.965  19.931  26.014  1.00  0.00           N  
ATOM    539  CA  CYS A  42       1.202  18.611  25.479  1.00  0.00           C  
ATOM    540  C   CYS A  42       1.861  17.752  26.548  1.00  0.00           C  
ATOM    541  O   CYS A  42       2.880  18.146  27.141  1.00  0.00           O  
ATOM    542  CB  CYS A  42       2.058  18.642  24.233  1.00  0.00           C  
ATOM    543  SG  CYS A  42       2.210  17.042  23.417  1.00  0.00           S  
ATOM    544  H   CYS A  42       1.394  20.749  25.684  1.00  0.00           H  
ATOM    545  HA  CYS A  42       0.239  18.178  25.249  1.00  0.00           H  
ATOM    546  HB2 CYS A  42       1.645  19.336  23.521  1.00  0.00           H  
ATOM    547  HB3 CYS A  42       3.039  18.977  24.527  1.00  0.00           H  
ATOM    548  HG  CYS A  42       3.471  16.626  23.439  1.00  0.00           H  
ATOM    549  N   LYS A  43       1.257  16.621  26.818  1.00  0.00           N  
ATOM    550  CA  LYS A  43       1.728  15.735  27.836  1.00  0.00           C  
ATOM    551  C   LYS A  43       2.904  14.900  27.344  1.00  0.00           C  
ATOM    552  O   LYS A  43       3.850  14.648  28.094  1.00  0.00           O  
ATOM    553  CB  LYS A  43       0.595  14.818  28.285  1.00  0.00           C  
ATOM    554  CG  LYS A  43       1.005  13.827  29.347  1.00  0.00           C  
ATOM    555  CD  LYS A  43      -0.109  12.875  29.674  1.00  0.00           C  
ATOM    556  CE  LYS A  43       0.349  11.826  30.671  1.00  0.00           C  
ATOM    557  NZ  LYS A  43       1.488  11.018  30.163  1.00  0.00           N  
ATOM    558  H   LYS A  43       0.450  16.374  26.316  1.00  0.00           H  
ATOM    559  HA  LYS A  43       2.038  16.324  28.685  1.00  0.00           H  
ATOM    560  HB2 LYS A  43      -0.211  15.421  28.676  1.00  0.00           H  
ATOM    561  HB3 LYS A  43       0.234  14.267  27.429  1.00  0.00           H  
ATOM    562  HG2 LYS A  43       1.852  13.262  28.983  1.00  0.00           H  
ATOM    563  HG3 LYS A  43       1.287  14.367  30.238  1.00  0.00           H  
ATOM    564  HD2 LYS A  43      -0.924  13.446  30.093  1.00  0.00           H  
ATOM    565  HD3 LYS A  43      -0.433  12.395  28.763  1.00  0.00           H  
ATOM    566  HE2 LYS A  43       0.659  12.329  31.574  1.00  0.00           H  
ATOM    567  HE3 LYS A  43      -0.482  11.173  30.892  1.00  0.00           H  
ATOM    568  HZ1 LYS A  43       1.223  10.515  29.293  1.00  0.00           H  
ATOM    569  HZ2 LYS A  43       1.768  10.297  30.857  1.00  0.00           H  
ATOM    570  HZ3 LYS A  43       2.324  11.600  29.960  1.00  0.00           H  
ATOM    571  N   VAL A  44       2.866  14.503  26.098  1.00  0.00           N  
ATOM    572  CA  VAL A  44       3.872  13.607  25.591  1.00  0.00           C  
ATOM    573  C   VAL A  44       4.505  14.142  24.327  1.00  0.00           C  
ATOM    574  O   VAL A  44       3.818  14.482  23.377  1.00  0.00           O  
ATOM    575  CB  VAL A  44       3.321  12.160  25.376  1.00  0.00           C  
ATOM    576  CG1 VAL A  44       2.149  12.118  24.399  1.00  0.00           C  
ATOM    577  CG2 VAL A  44       4.429  11.210  24.951  1.00  0.00           C  
ATOM    578  H   VAL A  44       2.187  14.851  25.481  1.00  0.00           H  
ATOM    579  HA  VAL A  44       4.645  13.560  26.344  1.00  0.00           H  
ATOM    580  HB  VAL A  44       2.933  11.817  26.323  1.00  0.00           H  
ATOM    581 HG11 VAL A  44       1.341  12.725  24.780  1.00  0.00           H  
ATOM    582 HG12 VAL A  44       1.812  11.099  24.284  1.00  0.00           H  
ATOM    583 HG13 VAL A  44       2.468  12.503  23.441  1.00  0.00           H  
ATOM    584 HG21 VAL A  44       4.019  10.220  24.812  1.00  0.00           H  
ATOM    585 HG22 VAL A  44       5.194  11.179  25.713  1.00  0.00           H  
ATOM    586 HG23 VAL A  44       4.860  11.555  24.023  1.00  0.00           H  
ATOM    587  N   GLY A  45       5.808  14.259  24.356  1.00  0.00           N  
ATOM    588  CA  GLY A  45       6.540  14.730  23.220  1.00  0.00           C  
ATOM    589  C   GLY A  45       6.254  16.191  22.947  1.00  0.00           C  
ATOM    590  O   GLY A  45       6.044  16.582  21.819  1.00  0.00           O  
ATOM    591  H   GLY A  45       6.271  14.038  25.197  1.00  0.00           H  
ATOM    592  HA2 GLY A  45       7.596  14.610  23.425  1.00  0.00           H  
ATOM    593  HA3 GLY A  45       6.279  14.136  22.352  1.00  0.00           H  
ATOM    594  N   ARG A  46       6.218  17.001  23.981  1.00  0.00           N  
ATOM    595  CA  ARG A  46       5.952  18.397  23.818  1.00  0.00           C  
ATOM    596  C   ARG A  46       7.136  19.070  23.161  1.00  0.00           C  
ATOM    597  O   ARG A  46       8.270  19.021  23.672  1.00  0.00           O  
ATOM    598  CB  ARG A  46       5.661  19.036  25.162  1.00  0.00           C  
ATOM    599  CG  ARG A  46       5.194  20.471  25.087  1.00  0.00           C  
ATOM    600  CD  ARG A  46       4.755  20.952  26.452  1.00  0.00           C  
ATOM    601  NE  ARG A  46       5.845  20.935  27.420  1.00  0.00           N  
ATOM    602  CZ  ARG A  46       5.816  20.324  28.619  1.00  0.00           C  
ATOM    603  NH1 ARG A  46       4.801  19.512  28.941  1.00  0.00           N  
ATOM    604  NH2 ARG A  46       6.831  20.493  29.462  1.00  0.00           N  
ATOM    605  H   ARG A  46       6.378  16.771  24.923  1.00  0.00           H  
ATOM    606  HA  ARG A  46       5.085  18.503  23.183  1.00  0.00           H  
ATOM    607  HB2 ARG A  46       4.921  18.465  25.702  1.00  0.00           H  
ATOM    608  HB3 ARG A  46       6.585  19.026  25.722  1.00  0.00           H  
ATOM    609  HG2 ARG A  46       6.014  21.082  24.739  1.00  0.00           H  
ATOM    610  HG3 ARG A  46       4.369  20.553  24.397  1.00  0.00           H  
ATOM    611  HD2 ARG A  46       4.385  21.962  26.361  1.00  0.00           H  
ATOM    612  HD3 ARG A  46       3.958  20.311  26.804  1.00  0.00           H  
ATOM    613  HE  ARG A  46       6.628  21.464  27.146  1.00  0.00           H  
ATOM    614 HH11 ARG A  46       4.028  19.324  28.326  1.00  0.00           H  
ATOM    615 HH12 ARG A  46       4.733  19.013  29.811  1.00  0.00           H  
ATOM    616 HH21 ARG A  46       7.615  21.069  29.213  1.00  0.00           H  
ATOM    617 HH22 ARG A  46       6.880  20.077  30.376  1.00  0.00           H  
ATOM    618  N   ILE A  47       6.883  19.654  22.036  1.00  0.00           N  
ATOM    619  CA  ILE A  47       7.894  20.316  21.286  1.00  0.00           C  
ATOM    620  C   ILE A  47       8.252  21.640  21.926  1.00  0.00           C  
ATOM    621  O   ILE A  47       7.388  22.486  22.208  1.00  0.00           O  
ATOM    622  CB  ILE A  47       7.509  20.470  19.795  1.00  0.00           C  
ATOM    623  CG1 ILE A  47       7.189  19.076  19.218  1.00  0.00           C  
ATOM    624  CG2 ILE A  47       8.637  21.138  19.032  1.00  0.00           C  
ATOM    625  CD1 ILE A  47       6.683  19.068  17.800  1.00  0.00           C  
ATOM    626  H   ILE A  47       5.952  19.625  21.721  1.00  0.00           H  
ATOM    627  HA  ILE A  47       8.774  19.694  21.346  1.00  0.00           H  
ATOM    628  HB  ILE A  47       6.660  21.117  19.657  1.00  0.00           H  
ATOM    629 HG12 ILE A  47       8.070  18.455  19.252  1.00  0.00           H  
ATOM    630 HG13 ILE A  47       6.429  18.631  19.841  1.00  0.00           H  
ATOM    631 HG21 ILE A  47       9.566  20.610  19.170  1.00  0.00           H  
ATOM    632 HG22 ILE A  47       8.754  22.157  19.373  1.00  0.00           H  
ATOM    633 HG23 ILE A  47       8.388  21.138  17.984  1.00  0.00           H  
ATOM    634 HD11 ILE A  47       7.399  19.555  17.156  1.00  0.00           H  
ATOM    635 HD12 ILE A  47       5.734  19.580  17.760  1.00  0.00           H  
ATOM    636 HD13 ILE A  47       6.547  18.046  17.479  1.00  0.00           H  
ATOM    637  N   THR A  48       9.508  21.763  22.193  1.00  0.00           N  
ATOM    638  CA  THR A  48      10.102  22.887  22.830  1.00  0.00           C  
ATOM    639  C   THR A  48      10.013  24.162  21.998  1.00  0.00           C  
ATOM    640  O   THR A  48       9.426  25.160  22.428  1.00  0.00           O  
ATOM    641  CB  THR A  48      11.561  22.540  23.096  1.00  0.00           C  
ATOM    642  OG1 THR A  48      12.135  22.049  21.873  1.00  0.00           O  
ATOM    643  CG2 THR A  48      11.635  21.442  24.101  1.00  0.00           C  
ATOM    644  H   THR A  48      10.121  21.031  21.973  1.00  0.00           H  
ATOM    645  HA  THR A  48       9.633  23.038  23.792  1.00  0.00           H  
ATOM    646  HB  THR A  48      12.103  23.402  23.455  1.00  0.00           H  
ATOM    647  HG1 THR A  48      13.084  21.935  22.012  1.00  0.00           H  
ATOM    648 HG21 THR A  48      11.155  21.749  25.016  1.00  0.00           H  
ATOM    649 HG22 THR A  48      12.670  21.179  24.262  1.00  0.00           H  
ATOM    650 HG23 THR A  48      11.096  20.619  23.658  1.00  0.00           H  
ATOM    651  N   THR A  49      10.545  24.119  20.813  1.00  0.00           N  
ATOM    652  CA  THR A  49      10.643  25.312  20.020  1.00  0.00           C  
ATOM    653  C   THR A  49      10.214  25.027  18.594  1.00  0.00           C  
ATOM    654  O   THR A  49      10.235  23.883  18.156  1.00  0.00           O  
ATOM    655  CB  THR A  49      12.107  25.836  20.023  1.00  0.00           C  
ATOM    656  OG1 THR A  49      12.679  25.653  21.335  1.00  0.00           O  
ATOM    657  CG2 THR A  49      12.146  27.327  19.708  1.00  0.00           C  
ATOM    658  H   THR A  49      10.839  23.227  20.509  1.00  0.00           H  
ATOM    659  HA  THR A  49      10.008  26.070  20.453  1.00  0.00           H  
ATOM    660  HB  THR A  49      12.659  25.302  19.261  1.00  0.00           H  
ATOM    661  HG1 THR A  49      13.148  24.811  21.325  1.00  0.00           H  
ATOM    662 HG21 THR A  49      11.571  27.866  20.446  1.00  0.00           H  
ATOM    663 HG22 THR A  49      11.725  27.498  18.729  1.00  0.00           H  
ATOM    664 HG23 THR A  49      13.170  27.670  19.726  1.00  0.00           H  
ATOM    665  N   THR A  50       9.832  26.060  17.896  1.00  0.00           N  
ATOM    666  CA  THR A  50       9.446  26.007  16.515  1.00  0.00           C  
ATOM    667  C   THR A  50      10.530  25.379  15.649  1.00  0.00           C  
ATOM    668  O   THR A  50      10.237  24.568  14.781  1.00  0.00           O  
ATOM    669  CB  THR A  50       9.114  27.440  16.030  1.00  0.00           C  
ATOM    670  OG1 THR A  50       8.633  27.455  14.676  1.00  0.00           O  
ATOM    671  CG2 THR A  50      10.286  28.391  16.185  1.00  0.00           C  
ATOM    672  H   THR A  50       9.755  26.924  18.354  1.00  0.00           H  
ATOM    673  HA  THR A  50       8.540  25.425  16.418  1.00  0.00           H  
ATOM    674  HB  THR A  50       8.344  27.735  16.718  1.00  0.00           H  
ATOM    675  HG1 THR A  50       7.848  26.889  14.661  1.00  0.00           H  
ATOM    676 HG21 THR A  50      10.010  29.383  15.861  1.00  0.00           H  
ATOM    677 HG22 THR A  50      11.108  28.018  15.594  1.00  0.00           H  
ATOM    678 HG23 THR A  50      10.574  28.403  17.225  1.00  0.00           H  
ATOM    679  N   GLU A  51      11.777  25.730  15.917  1.00  0.00           N  
ATOM    680  CA  GLU A  51      12.901  25.169  15.186  1.00  0.00           C  
ATOM    681  C   GLU A  51      12.984  23.662  15.393  1.00  0.00           C  
ATOM    682  O   GLU A  51      13.299  22.910  14.457  1.00  0.00           O  
ATOM    683  CB  GLU A  51      14.204  25.887  15.535  1.00  0.00           C  
ATOM    684  CG  GLU A  51      14.551  25.902  17.017  1.00  0.00           C  
ATOM    685  CD  GLU A  51      15.783  26.715  17.294  1.00  0.00           C  
ATOM    686  OE1 GLU A  51      15.679  27.954  17.364  1.00  0.00           O  
ATOM    687  OE2 GLU A  51      16.890  26.139  17.421  1.00  0.00           O  
ATOM    688  H   GLU A  51      11.921  26.442  16.579  1.00  0.00           H  
ATOM    689  HA  GLU A  51      12.696  25.294  14.134  1.00  0.00           H  
ATOM    690  HB2 GLU A  51      15.014  25.405  15.010  1.00  0.00           H  
ATOM    691  HB3 GLU A  51      14.134  26.910  15.195  1.00  0.00           H  
ATOM    692  HG2 GLU A  51      13.726  26.332  17.564  1.00  0.00           H  
ATOM    693  HG3 GLU A  51      14.719  24.890  17.352  1.00  0.00           H  
ATOM    694  N   ASP A  52      12.605  23.221  16.583  1.00  0.00           N  
ATOM    695  CA  ASP A  52      12.577  21.805  16.921  1.00  0.00           C  
ATOM    696  C   ASP A  52      11.423  21.149  16.259  1.00  0.00           C  
ATOM    697  O   ASP A  52      11.547  20.050  15.737  1.00  0.00           O  
ATOM    698  CB  ASP A  52      12.479  21.604  18.441  1.00  0.00           C  
ATOM    699  CG  ASP A  52      13.814  21.637  19.129  1.00  0.00           C  
ATOM    700  OD1 ASP A  52      14.340  22.731  19.365  1.00  0.00           O  
ATOM    701  OD2 ASP A  52      14.370  20.553  19.438  1.00  0.00           O  
ATOM    702  H   ASP A  52      12.293  23.788  17.322  1.00  0.00           H  
ATOM    703  HA  ASP A  52      13.459  21.291  16.572  1.00  0.00           H  
ATOM    704  HB2 ASP A  52      11.879  22.405  18.848  1.00  0.00           H  
ATOM    705  HB3 ASP A  52      11.990  20.668  18.658  1.00  0.00           H  
ATOM    706  N   PHE A  53      10.311  21.851  16.239  1.00  0.00           N  
ATOM    707  CA  PHE A  53       9.099  21.404  15.589  1.00  0.00           C  
ATOM    708  C   PHE A  53       9.381  21.125  14.098  1.00  0.00           C  
ATOM    709  O   PHE A  53       9.107  20.040  13.586  1.00  0.00           O  
ATOM    710  CB  PHE A  53       8.002  22.476  15.753  1.00  0.00           C  
ATOM    711  CG  PHE A  53       6.759  22.235  14.959  1.00  0.00           C  
ATOM    712  CD1 PHE A  53       6.651  22.714  13.668  1.00  0.00           C  
ATOM    713  CD2 PHE A  53       5.714  21.535  15.492  1.00  0.00           C  
ATOM    714  CE1 PHE A  53       5.526  22.490  12.933  1.00  0.00           C  
ATOM    715  CE2 PHE A  53       4.579  21.308  14.763  1.00  0.00           C  
ATOM    716  CZ  PHE A  53       4.481  21.782  13.484  1.00  0.00           C  
ATOM    717  H   PHE A  53      10.288  22.741  16.654  1.00  0.00           H  
ATOM    718  HA  PHE A  53       8.798  20.478  16.045  1.00  0.00           H  
ATOM    719  HB2 PHE A  53       7.714  22.561  16.790  1.00  0.00           H  
ATOM    720  HB3 PHE A  53       8.418  23.422  15.439  1.00  0.00           H  
ATOM    721  HD1 PHE A  53       7.474  23.270  13.243  1.00  0.00           H  
ATOM    722  HD2 PHE A  53       5.794  21.163  16.502  1.00  0.00           H  
ATOM    723  HE1 PHE A  53       5.485  22.870  11.923  1.00  0.00           H  
ATOM    724  HE2 PHE A  53       3.765  20.748  15.199  1.00  0.00           H  
ATOM    725  HZ  PHE A  53       3.578  21.595  12.924  1.00  0.00           H  
ATOM    726  N   LYS A  54       9.953  22.109  13.451  1.00  0.00           N  
ATOM    727  CA  LYS A  54      10.288  22.052  12.049  1.00  0.00           C  
ATOM    728  C   LYS A  54      11.317  20.982  11.763  1.00  0.00           C  
ATOM    729  O   LYS A  54      11.179  20.218  10.798  1.00  0.00           O  
ATOM    730  CB  LYS A  54      10.799  23.420  11.613  1.00  0.00           C  
ATOM    731  CG  LYS A  54       9.710  24.476  11.665  1.00  0.00           C  
ATOM    732  CD  LYS A  54      10.227  25.844  11.306  1.00  0.00           C  
ATOM    733  CE  LYS A  54       9.106  26.868  11.318  1.00  0.00           C  
ATOM    734  NZ  LYS A  54       8.045  26.540  10.345  1.00  0.00           N  
ATOM    735  H   LYS A  54      10.160  22.902  13.997  1.00  0.00           H  
ATOM    736  HA  LYS A  54       9.422  21.839  11.436  1.00  0.00           H  
ATOM    737  HB2 LYS A  54      11.604  23.720  12.268  1.00  0.00           H  
ATOM    738  HB3 LYS A  54      11.167  23.355  10.601  1.00  0.00           H  
ATOM    739  HG2 LYS A  54       8.930  24.209  10.968  1.00  0.00           H  
ATOM    740  HG3 LYS A  54       9.305  24.503  12.665  1.00  0.00           H  
ATOM    741  HD2 LYS A  54      10.972  26.126  12.036  1.00  0.00           H  
ATOM    742  HD3 LYS A  54      10.664  25.802  10.320  1.00  0.00           H  
ATOM    743  HE2 LYS A  54       8.671  26.904  12.308  1.00  0.00           H  
ATOM    744  HE3 LYS A  54       9.515  27.835  11.073  1.00  0.00           H  
ATOM    745  HZ1 LYS A  54       7.274  27.236  10.375  1.00  0.00           H  
ATOM    746  HZ2 LYS A  54       7.597  25.622  10.550  1.00  0.00           H  
ATOM    747  HZ3 LYS A  54       8.388  26.496   9.365  1.00  0.00           H  
ATOM    748  N   HIS A  55      12.303  20.870  12.646  1.00  0.00           N  
ATOM    749  CA  HIS A  55      13.373  19.888  12.500  1.00  0.00           C  
ATOM    750  C   HIS A  55      12.799  18.507  12.594  1.00  0.00           C  
ATOM    751  O   HIS A  55      13.137  17.631  11.795  1.00  0.00           O  
ATOM    752  CB  HIS A  55      14.427  20.079  13.593  1.00  0.00           C  
ATOM    753  CG  HIS A  55      15.586  19.110  13.550  1.00  0.00           C  
ATOM    754  ND1 HIS A  55      16.694  19.300  12.763  1.00  0.00           N  
ATOM    755  CD2 HIS A  55      15.803  17.941  14.224  1.00  0.00           C  
ATOM    756  CE1 HIS A  55      17.544  18.316  12.936  1.00  0.00           C  
ATOM    757  NE2 HIS A  55      17.031  17.471  13.820  1.00  0.00           N  
ATOM    758  H   HIS A  55      12.314  21.418  13.462  1.00  0.00           H  
ATOM    759  HA  HIS A  55      13.832  19.960  11.525  1.00  0.00           H  
ATOM    760  HB2 HIS A  55      14.802  21.088  13.551  1.00  0.00           H  
ATOM    761  HB3 HIS A  55      13.932  19.954  14.545  1.00  0.00           H  
ATOM    762  HD1 HIS A  55      16.832  20.064  12.157  1.00  0.00           H  
ATOM    763  HD2 HIS A  55      15.148  17.464  14.944  1.00  0.00           H  
ATOM    764  HE1 HIS A  55      18.502  18.220  12.449  1.00  0.00           H  
ATOM    765  N   LEU A  56      11.946  18.314  13.558  1.00  0.00           N  
ATOM    766  CA  LEU A  56      11.338  17.046  13.755  1.00  0.00           C  
ATOM    767  C   LEU A  56      10.436  16.705  12.589  1.00  0.00           C  
ATOM    768  O   LEU A  56      10.521  15.596  12.076  1.00  0.00           O  
ATOM    769  CB  LEU A  56      10.548  16.959  15.064  1.00  0.00           C  
ATOM    770  CG  LEU A  56      10.750  15.714  15.934  1.00  0.00           C  
ATOM    771  CD1 LEU A  56       9.509  15.397  16.748  1.00  0.00           C  
ATOM    772  CD2 LEU A  56      11.313  14.512  15.186  1.00  0.00           C  
ATOM    773  H   LEU A  56      11.726  19.049  14.173  1.00  0.00           H  
ATOM    774  HA  LEU A  56      12.068  16.255  13.750  1.00  0.00           H  
ATOM    775  HB2 LEU A  56      10.832  17.783  15.702  1.00  0.00           H  
ATOM    776  HB3 LEU A  56       9.499  17.037  14.854  1.00  0.00           H  
ATOM    777  HG  LEU A  56      11.471  16.010  16.685  1.00  0.00           H  
ATOM    778 HD11 LEU A  56       8.685  15.161  16.095  1.00  0.00           H  
ATOM    779 HD12 LEU A  56       9.251  16.270  17.330  1.00  0.00           H  
ATOM    780 HD13 LEU A  56       9.695  14.577  17.423  1.00  0.00           H  
ATOM    781 HD21 LEU A  56      10.618  14.191  14.428  1.00  0.00           H  
ATOM    782 HD22 LEU A  56      11.522  13.720  15.885  1.00  0.00           H  
ATOM    783 HD23 LEU A  56      12.265  14.738  14.735  1.00  0.00           H  
ATOM    784  N   ALA A  57       9.608  17.664  12.128  1.00  0.00           N  
ATOM    785  CA  ALA A  57       8.730  17.416  10.978  1.00  0.00           C  
ATOM    786  C   ALA A  57       9.555  16.932   9.783  1.00  0.00           C  
ATOM    787  O   ALA A  57       9.194  15.942   9.105  1.00  0.00           O  
ATOM    788  CB  ALA A  57       7.909  18.640  10.622  1.00  0.00           C  
ATOM    789  H   ALA A  57       9.556  18.550  12.561  1.00  0.00           H  
ATOM    790  HA  ALA A  57       8.086  16.601  11.256  1.00  0.00           H  
ATOM    791  HB1 ALA A  57       7.338  18.963  11.479  1.00  0.00           H  
ATOM    792  HB2 ALA A  57       7.237  18.399   9.811  1.00  0.00           H  
ATOM    793  HB3 ALA A  57       8.570  19.436  10.310  1.00  0.00           H  
ATOM    794  N   ARG A  58      10.700  17.560   9.607  1.00  0.00           N  
ATOM    795  CA  ARG A  58      11.629  17.221   8.520  1.00  0.00           C  
ATOM    796  C   ARG A  58      12.142  15.809   8.676  1.00  0.00           C  
ATOM    797  O   ARG A  58      12.070  14.970   7.755  1.00  0.00           O  
ATOM    798  CB  ARG A  58      12.834  18.170   8.517  1.00  0.00           C  
ATOM    799  CG  ARG A  58      12.530  19.579   8.094  1.00  0.00           C  
ATOM    800  CD  ARG A  58      11.947  19.565   6.726  1.00  0.00           C  
ATOM    801  NE  ARG A  58      11.816  20.902   6.149  1.00  0.00           N  
ATOM    802  CZ  ARG A  58      10.928  21.254   5.215  1.00  0.00           C  
ATOM    803  NH1 ARG A  58       9.994  20.391   4.819  1.00  0.00           N  
ATOM    804  NH2 ARG A  58      10.976  22.479   4.687  1.00  0.00           N  
ATOM    805  H   ARG A  58      10.901  18.259  10.276  1.00  0.00           H  
ATOM    806  HA  ARG A  58      11.115  17.306   7.576  1.00  0.00           H  
ATOM    807  HB2 ARG A  58      13.242  18.206   9.519  1.00  0.00           H  
ATOM    808  HB3 ARG A  58      13.586  17.766   7.856  1.00  0.00           H  
ATOM    809  HG2 ARG A  58      11.817  20.011   8.781  1.00  0.00           H  
ATOM    810  HG3 ARG A  58      13.438  20.166   8.089  1.00  0.00           H  
ATOM    811  HD2 ARG A  58      12.585  18.932   6.130  1.00  0.00           H  
ATOM    812  HD3 ARG A  58      10.976  19.106   6.828  1.00  0.00           H  
ATOM    813  HE  ARG A  58      12.476  21.557   6.474  1.00  0.00           H  
ATOM    814 HH11 ARG A  58       9.919  19.464   5.195  1.00  0.00           H  
ATOM    815 HH12 ARG A  58       9.307  20.639   4.131  1.00  0.00           H  
ATOM    816 HH21 ARG A  58      11.671  23.141   4.976  1.00  0.00           H  
ATOM    817 HH22 ARG A  58      10.333  22.802   3.987  1.00  0.00           H  
ATOM    818  N   LYS A  59      12.633  15.569   9.840  1.00  0.00           N  
ATOM    819  CA  LYS A  59      13.253  14.332  10.231  1.00  0.00           C  
ATOM    820  C   LYS A  59      12.286  13.146  10.115  1.00  0.00           C  
ATOM    821  O   LYS A  59      12.655  12.079   9.625  1.00  0.00           O  
ATOM    822  CB  LYS A  59      13.758  14.503  11.658  1.00  0.00           C  
ATOM    823  CG  LYS A  59      14.451  13.324  12.284  1.00  0.00           C  
ATOM    824  CD  LYS A  59      14.928  13.721  13.663  1.00  0.00           C  
ATOM    825  CE  LYS A  59      15.605  12.597  14.389  1.00  0.00           C  
ATOM    826  NZ  LYS A  59      14.700  11.453  14.647  1.00  0.00           N  
ATOM    827  H   LYS A  59      12.570  16.303  10.492  1.00  0.00           H  
ATOM    828  HA  LYS A  59      14.106  14.190   9.585  1.00  0.00           H  
ATOM    829  HB2 LYS A  59      14.453  15.330  11.673  1.00  0.00           H  
ATOM    830  HB3 LYS A  59      12.912  14.766  12.275  1.00  0.00           H  
ATOM    831  HG2 LYS A  59      13.754  12.502  12.362  1.00  0.00           H  
ATOM    832  HG3 LYS A  59      15.300  13.036  11.683  1.00  0.00           H  
ATOM    833  HD2 LYS A  59      15.629  14.537  13.568  1.00  0.00           H  
ATOM    834  HD3 LYS A  59      14.081  14.051  14.243  1.00  0.00           H  
ATOM    835  HE2 LYS A  59      16.435  12.252  13.789  1.00  0.00           H  
ATOM    836  HE3 LYS A  59      15.979  12.967  15.332  1.00  0.00           H  
ATOM    837  HZ1 LYS A  59      13.776  11.715  15.048  1.00  0.00           H  
ATOM    838  HZ2 LYS A  59      15.184  10.932  15.417  1.00  0.00           H  
ATOM    839  HZ3 LYS A  59      14.622  10.784  13.847  1.00  0.00           H  
ATOM    840  N   LEU A  60      11.064  13.338  10.566  1.00  0.00           N  
ATOM    841  CA  LEU A  60      10.036  12.299  10.509  1.00  0.00           C  
ATOM    842  C   LEU A  60       9.651  12.007   9.096  1.00  0.00           C  
ATOM    843  O   LEU A  60       9.493  10.841   8.725  1.00  0.00           O  
ATOM    844  CB  LEU A  60       8.851  12.731  11.336  1.00  0.00           C  
ATOM    845  CG  LEU A  60       9.229  12.944  12.771  1.00  0.00           C  
ATOM    846  CD1 LEU A  60       8.226  13.799  13.507  1.00  0.00           C  
ATOM    847  CD2 LEU A  60       9.417  11.625  13.449  1.00  0.00           C  
ATOM    848  H   LEU A  60      10.833  14.172  11.037  1.00  0.00           H  
ATOM    849  HA  LEU A  60      10.527  11.475  11.002  1.00  0.00           H  
ATOM    850  HB2 LEU A  60       8.481  13.659  10.929  1.00  0.00           H  
ATOM    851  HB3 LEU A  60       8.071  11.977  11.307  1.00  0.00           H  
ATOM    852  HG  LEU A  60      10.192  13.431  12.737  1.00  0.00           H  
ATOM    853 HD11 LEU A  60       7.232  13.402  13.395  1.00  0.00           H  
ATOM    854 HD12 LEU A  60       8.261  14.803  13.113  1.00  0.00           H  
ATOM    855 HD13 LEU A  60       8.484  13.815  14.555  1.00  0.00           H  
ATOM    856 HD21 LEU A  60      10.207  11.084  12.949  1.00  0.00           H  
ATOM    857 HD22 LEU A  60       8.495  11.064  13.393  1.00  0.00           H  
ATOM    858 HD23 LEU A  60       9.688  11.787  14.482  1.00  0.00           H  
ATOM    859  N   THR A  61       9.533  13.076   8.296  1.00  0.00           N  
ATOM    860  CA  THR A  61       9.241  12.931   6.881  1.00  0.00           C  
ATOM    861  C   THR A  61      10.304  12.063   6.264  1.00  0.00           C  
ATOM    862  O   THR A  61      10.027  11.133   5.523  1.00  0.00           O  
ATOM    863  CB  THR A  61       9.262  14.299   6.154  1.00  0.00           C  
ATOM    864  OG1 THR A  61       8.305  15.203   6.725  1.00  0.00           O  
ATOM    865  CG2 THR A  61       8.960  14.129   4.679  1.00  0.00           C  
ATOM    866  H   THR A  61       9.624  13.952   8.736  1.00  0.00           H  
ATOM    867  HA  THR A  61       8.266  12.484   6.754  1.00  0.00           H  
ATOM    868  HB  THR A  61      10.252  14.718   6.261  1.00  0.00           H  
ATOM    869  HG1 THR A  61       8.486  15.318   7.670  1.00  0.00           H  
ATOM    870 HG21 THR A  61       9.711  13.500   4.227  1.00  0.00           H  
ATOM    871 HG22 THR A  61       8.951  15.095   4.198  1.00  0.00           H  
ATOM    872 HG23 THR A  61       7.991  13.664   4.568  1.00  0.00           H  
ATOM    873  N   HIS A  62      11.511  12.330   6.676  1.00  0.00           N  
ATOM    874  CA  HIS A  62      12.671  11.674   6.138  1.00  0.00           C  
ATOM    875  C   HIS A  62      12.725  10.188   6.562  1.00  0.00           C  
ATOM    876  O   HIS A  62      13.150   9.337   5.776  1.00  0.00           O  
ATOM    877  CB  HIS A  62      13.937  12.466   6.529  1.00  0.00           C  
ATOM    878  CG  HIS A  62      15.276  11.921   6.089  1.00  0.00           C  
ATOM    879  ND1 HIS A  62      15.972  12.427   5.018  1.00  0.00           N  
ATOM    880  CD2 HIS A  62      16.086  10.987   6.647  1.00  0.00           C  
ATOM    881  CE1 HIS A  62      17.145  11.847   4.933  1.00  0.00           C  
ATOM    882  NE2 HIS A  62      17.247  10.963   5.912  1.00  0.00           N  
ATOM    883  H   HIS A  62      11.611  13.003   7.392  1.00  0.00           H  
ATOM    884  HA  HIS A  62      12.540  11.688   5.069  1.00  0.00           H  
ATOM    885  HB2 HIS A  62      13.854  13.462   6.121  1.00  0.00           H  
ATOM    886  HB3 HIS A  62      13.947  12.544   7.607  1.00  0.00           H  
ATOM    887  HD1 HIS A  62      15.648  13.093   4.372  1.00  0.00           H  
ATOM    888  HD2 HIS A  62      15.860  10.372   7.506  1.00  0.00           H  
ATOM    889  HE1 HIS A  62      17.898  12.061   4.190  1.00  0.00           H  
ATOM    890  N   GLY A  63      12.273   9.878   7.762  1.00  0.00           N  
ATOM    891  CA  GLY A  63      12.298   8.500   8.224  1.00  0.00           C  
ATOM    892  C   GLY A  63      11.194   7.659   7.620  1.00  0.00           C  
ATOM    893  O   GLY A  63      11.425   6.505   7.267  1.00  0.00           O  
ATOM    894  H   GLY A  63      11.932  10.557   8.384  1.00  0.00           H  
ATOM    895  HA2 GLY A  63      13.242   8.076   7.914  1.00  0.00           H  
ATOM    896  HA3 GLY A  63      12.249   8.440   9.298  1.00  0.00           H  
ATOM    897  N   VAL A  64       9.999   8.246   7.458  1.00  0.00           N  
ATOM    898  CA  VAL A  64       8.872   7.533   6.814  1.00  0.00           C  
ATOM    899  C   VAL A  64       9.273   7.222   5.390  1.00  0.00           C  
ATOM    900  O   VAL A  64       9.164   6.088   4.933  1.00  0.00           O  
ATOM    901  CB  VAL A  64       7.548   8.378   6.809  1.00  0.00           C  
ATOM    902  CG1 VAL A  64       6.425   7.676   6.019  1.00  0.00           C  
ATOM    903  CG2 VAL A  64       7.083   8.647   8.229  1.00  0.00           C  
ATOM    904  H   VAL A  64       9.882   9.185   7.730  1.00  0.00           H  
ATOM    905  HA  VAL A  64       8.706   6.582   7.299  1.00  0.00           H  
ATOM    906  HB  VAL A  64       7.753   9.324   6.331  1.00  0.00           H  
ATOM    907 HG11 VAL A  64       5.528   8.279   5.993  1.00  0.00           H  
ATOM    908 HG12 VAL A  64       6.168   6.738   6.487  1.00  0.00           H  
ATOM    909 HG13 VAL A  64       6.732   7.478   5.002  1.00  0.00           H  
ATOM    910 HG21 VAL A  64       6.909   7.708   8.733  1.00  0.00           H  
ATOM    911 HG22 VAL A  64       6.160   9.210   8.199  1.00  0.00           H  
ATOM    912 HG23 VAL A  64       7.836   9.210   8.760  1.00  0.00           H  
ATOM    913  N   MET A  65       9.891   8.216   4.803  1.00  0.00           N  
ATOM    914  CA  MET A  65      10.351   8.202   3.429  1.00  0.00           C  
ATOM    915  C   MET A  65      11.364   7.095   3.221  1.00  0.00           C  
ATOM    916  O   MET A  65      11.224   6.275   2.331  1.00  0.00           O  
ATOM    917  CB  MET A  65      10.956   9.553   3.102  1.00  0.00           C  
ATOM    918  CG  MET A  65      11.664   9.656   1.798  1.00  0.00           C  
ATOM    919  SD  MET A  65      12.358  11.294   1.601  1.00  0.00           S  
ATOM    920  CE  MET A  65      13.317  11.019   0.162  1.00  0.00           C  
ATOM    921  H   MET A  65      10.047   8.940   5.444  1.00  0.00           H  
ATOM    922  HA  MET A  65       9.489   8.027   2.808  1.00  0.00           H  
ATOM    923  HB2 MET A  65      10.192  10.314   3.122  1.00  0.00           H  
ATOM    924  HB3 MET A  65      11.684   9.801   3.861  1.00  0.00           H  
ATOM    925  HG2 MET A  65      12.460   8.924   1.796  1.00  0.00           H  
ATOM    926  HG3 MET A  65      10.993   9.453   0.978  1.00  0.00           H  
ATOM    927  HE1 MET A  65      14.004  10.230   0.433  1.00  0.00           H  
ATOM    928  HE2 MET A  65      13.850  11.926  -0.075  1.00  0.00           H  
ATOM    929  HE3 MET A  65      12.677  10.702  -0.645  1.00  0.00           H  
ATOM    930  N   ASN A  66      12.356   7.059   4.078  1.00  0.00           N  
ATOM    931  CA  ASN A  66      13.410   6.078   3.997  1.00  0.00           C  
ATOM    932  C   ASN A  66      12.902   4.674   4.229  1.00  0.00           C  
ATOM    933  O   ASN A  66      13.243   3.756   3.473  1.00  0.00           O  
ATOM    934  CB  ASN A  66      14.559   6.430   4.939  1.00  0.00           C  
ATOM    935  CG  ASN A  66      15.601   7.304   4.290  1.00  0.00           C  
ATOM    936  OD1 ASN A  66      16.560   6.823   3.692  1.00  0.00           O  
ATOM    937  ND2 ASN A  66      15.425   8.583   4.392  1.00  0.00           N  
ATOM    938  H   ASN A  66      12.384   7.709   4.812  1.00  0.00           H  
ATOM    939  HA  ASN A  66      13.784   6.066   2.985  1.00  0.00           H  
ATOM    940  HB2 ASN A  66      14.124   7.032   5.725  1.00  0.00           H  
ATOM    941  HB3 ASN A  66      15.003   5.562   5.390  1.00  0.00           H  
ATOM    942 HD21 ASN A  66      14.630   8.891   4.882  1.00  0.00           H  
ATOM    943 HD22 ASN A  66      16.066   9.192   3.971  1.00  0.00           H  
ATOM    944  N   LYS A  67      12.044   4.508   5.212  1.00  0.00           N  
ATOM    945  CA  LYS A  67      11.523   3.198   5.530  1.00  0.00           C  
ATOM    946  C   LYS A  67      10.642   2.646   4.426  1.00  0.00           C  
ATOM    947  O   LYS A  67      10.732   1.449   4.084  1.00  0.00           O  
ATOM    948  CB  LYS A  67      10.845   3.167   6.901  1.00  0.00           C  
ATOM    949  CG  LYS A  67      11.835   3.383   8.035  1.00  0.00           C  
ATOM    950  CD  LYS A  67      11.187   3.332   9.405  1.00  0.00           C  
ATOM    951  CE  LYS A  67      12.250   3.448  10.483  1.00  0.00           C  
ATOM    952  NZ  LYS A  67      11.707   3.336  11.851  1.00  0.00           N  
ATOM    953  H   LYS A  67      11.745   5.291   5.727  1.00  0.00           H  
ATOM    954  HA  LYS A  67      12.390   2.554   5.567  1.00  0.00           H  
ATOM    955  HB2 LYS A  67      10.097   3.945   6.938  1.00  0.00           H  
ATOM    956  HB3 LYS A  67      10.371   2.207   7.041  1.00  0.00           H  
ATOM    957  HG2 LYS A  67      12.589   2.612   7.985  1.00  0.00           H  
ATOM    958  HG3 LYS A  67      12.304   4.346   7.901  1.00  0.00           H  
ATOM    959  HD2 LYS A  67      10.492   4.155   9.498  1.00  0.00           H  
ATOM    960  HD3 LYS A  67      10.660   2.398   9.523  1.00  0.00           H  
ATOM    961  HE2 LYS A  67      12.976   2.663  10.340  1.00  0.00           H  
ATOM    962  HE3 LYS A  67      12.739   4.404  10.374  1.00  0.00           H  
ATOM    963  HZ1 LYS A  67      12.475   3.403  12.549  1.00  0.00           H  
ATOM    964  HZ2 LYS A  67      11.223   2.431  12.014  1.00  0.00           H  
ATOM    965  HZ3 LYS A  67      11.027   4.088  12.077  1.00  0.00           H  
ATOM    966  N   GLU A  68       9.837   3.486   3.810  1.00  0.00           N  
ATOM    967  CA  GLU A  68       9.041   3.001   2.750  1.00  0.00           C  
ATOM    968  C   GLU A  68       9.847   2.830   1.501  1.00  0.00           C  
ATOM    969  O   GLU A  68       9.650   1.894   0.794  1.00  0.00           O  
ATOM    970  CB  GLU A  68       7.785   3.781   2.565  1.00  0.00           C  
ATOM    971  CG  GLU A  68       7.935   5.250   2.284  1.00  0.00           C  
ATOM    972  CD  GLU A  68       6.592   5.883   2.264  1.00  0.00           C  
ATOM    973  OE1 GLU A  68       5.967   5.945   3.356  1.00  0.00           O  
ATOM    974  OE2 GLU A  68       6.115   6.260   1.170  1.00  0.00           O  
ATOM    975  H   GLU A  68       9.752   4.440   4.043  1.00  0.00           H  
ATOM    976  HA  GLU A  68       8.781   1.993   3.037  1.00  0.00           H  
ATOM    977  HB2 GLU A  68       7.211   3.332   1.771  1.00  0.00           H  
ATOM    978  HB3 GLU A  68       7.270   3.684   3.510  1.00  0.00           H  
ATOM    979  HG2 GLU A  68       8.519   5.694   3.077  1.00  0.00           H  
ATOM    980  HG3 GLU A  68       8.426   5.423   1.338  1.00  0.00           H  
ATOM    981  N   LEU A  69      10.799   3.708   1.249  1.00  0.00           N  
ATOM    982  CA  LEU A  69      11.724   3.495   0.139  1.00  0.00           C  
ATOM    983  C   LEU A  69      12.464   2.173   0.277  1.00  0.00           C  
ATOM    984  O   LEU A  69      12.824   1.566  -0.728  1.00  0.00           O  
ATOM    985  CB  LEU A  69      12.713   4.648  -0.019  1.00  0.00           C  
ATOM    986  CG  LEU A  69      12.163   5.928  -0.634  1.00  0.00           C  
ATOM    987  CD1 LEU A  69      13.181   7.050  -0.533  1.00  0.00           C  
ATOM    988  CD2 LEU A  69      11.791   5.685  -2.090  1.00  0.00           C  
ATOM    989  H   LEU A  69      10.863   4.566   1.728  1.00  0.00           H  
ATOM    990  HA  LEU A  69      11.118   3.424  -0.755  1.00  0.00           H  
ATOM    991  HB2 LEU A  69      13.111   4.885   0.956  1.00  0.00           H  
ATOM    992  HB3 LEU A  69      13.525   4.300  -0.642  1.00  0.00           H  
ATOM    993  HG  LEU A  69      11.271   6.228  -0.104  1.00  0.00           H  
ATOM    994 HD11 LEU A  69      13.400   7.233   0.509  1.00  0.00           H  
ATOM    995 HD12 LEU A  69      12.766   7.944  -0.970  1.00  0.00           H  
ATOM    996 HD13 LEU A  69      14.087   6.775  -1.052  1.00  0.00           H  
ATOM    997 HD21 LEU A  69      12.651   5.305  -2.622  1.00  0.00           H  
ATOM    998 HD22 LEU A  69      11.493   6.622  -2.532  1.00  0.00           H  
ATOM    999 HD23 LEU A  69      10.979   4.979  -2.153  1.00  0.00           H  
ATOM   1000  N   LYS A  70      12.671   1.710   1.503  1.00  0.00           N  
ATOM   1001  CA  LYS A  70      13.297   0.410   1.717  1.00  0.00           C  
ATOM   1002  C   LYS A  70      12.334  -0.716   1.382  1.00  0.00           C  
ATOM   1003  O   LYS A  70      12.666  -1.630   0.644  1.00  0.00           O  
ATOM   1004  CB  LYS A  70      13.749   0.248   3.168  1.00  0.00           C  
ATOM   1005  CG  LYS A  70      14.844   1.178   3.581  1.00  0.00           C  
ATOM   1006  CD  LYS A  70      15.281   0.946   5.032  1.00  0.00           C  
ATOM   1007  CE  LYS A  70      15.906  -0.436   5.241  1.00  0.00           C  
ATOM   1008  NZ  LYS A  70      17.148  -0.614   4.459  1.00  0.00           N  
ATOM   1009  H   LYS A  70      12.428   2.202   2.324  1.00  0.00           H  
ATOM   1010  HA  LYS A  70      14.161   0.336   1.077  1.00  0.00           H  
ATOM   1011  HB2 LYS A  70      12.904   0.458   3.805  1.00  0.00           H  
ATOM   1012  HB3 LYS A  70      14.074  -0.770   3.317  1.00  0.00           H  
ATOM   1013  HG2 LYS A  70      15.655   1.009   2.892  1.00  0.00           H  
ATOM   1014  HG3 LYS A  70      14.477   2.187   3.463  1.00  0.00           H  
ATOM   1015  HD2 LYS A  70      16.007   1.698   5.304  1.00  0.00           H  
ATOM   1016  HD3 LYS A  70      14.414   1.038   5.671  1.00  0.00           H  
ATOM   1017  HE2 LYS A  70      16.135  -0.556   6.289  1.00  0.00           H  
ATOM   1018  HE3 LYS A  70      15.194  -1.194   4.952  1.00  0.00           H  
ATOM   1019  HZ1 LYS A  70      16.973  -0.504   3.440  1.00  0.00           H  
ATOM   1020  HZ2 LYS A  70      17.529  -1.572   4.596  1.00  0.00           H  
ATOM   1021  HZ3 LYS A  70      17.879   0.062   4.746  1.00  0.00           H  
ATOM   1022  N   TYR A  71      11.142  -0.613   1.921  1.00  0.00           N  
ATOM   1023  CA  TYR A  71      10.101  -1.667   1.792  1.00  0.00           C  
ATOM   1024  C   TYR A  71       9.216  -1.522   0.550  1.00  0.00           C  
ATOM   1025  O   TYR A  71       8.249  -2.265   0.370  1.00  0.00           O  
ATOM   1026  CB  TYR A  71       9.227  -1.713   3.062  1.00  0.00           C  
ATOM   1027  CG  TYR A  71       9.955  -2.212   4.307  1.00  0.00           C  
ATOM   1028  CD1 TYR A  71      11.115  -1.606   4.735  1.00  0.00           C  
ATOM   1029  CD2 TYR A  71       9.475  -3.285   5.043  1.00  0.00           C  
ATOM   1030  CE1 TYR A  71      11.788  -2.030   5.846  1.00  0.00           C  
ATOM   1031  CE2 TYR A  71      10.140  -3.727   6.176  1.00  0.00           C  
ATOM   1032  CZ  TYR A  71      11.302  -3.090   6.572  1.00  0.00           C  
ATOM   1033  OH  TYR A  71      11.971  -3.503   7.708  1.00  0.00           O  
ATOM   1034  H   TYR A  71      10.973   0.194   2.461  1.00  0.00           H  
ATOM   1035  HA  TYR A  71      10.589  -2.629   1.711  1.00  0.00           H  
ATOM   1036  HB2 TYR A  71       8.864  -0.718   3.274  1.00  0.00           H  
ATOM   1037  HB3 TYR A  71       8.387  -2.367   2.882  1.00  0.00           H  
ATOM   1038  HD1 TYR A  71      11.482  -0.779   4.144  1.00  0.00           H  
ATOM   1039  HD2 TYR A  71       8.566  -3.773   4.721  1.00  0.00           H  
ATOM   1040  HE1 TYR A  71      12.695  -1.521   6.139  1.00  0.00           H  
ATOM   1041  HE2 TYR A  71       9.755  -4.564   6.740  1.00  0.00           H  
ATOM   1042  HH  TYR A  71      12.104  -2.701   8.232  1.00  0.00           H  
ATOM   1043  N   CYS A  72       9.543  -0.596  -0.292  1.00  0.00           N  
ATOM   1044  CA  CYS A  72       8.801  -0.361  -1.524  1.00  0.00           C  
ATOM   1045  C   CYS A  72       9.741  -0.428  -2.686  1.00  0.00           C  
ATOM   1046  O   CYS A  72       9.456  -1.102  -3.690  1.00  0.00           O  
ATOM   1047  CB  CYS A  72       8.059   0.985  -1.498  1.00  0.00           C  
ATOM   1048  SG  CYS A  72       6.676   1.056  -0.337  1.00  0.00           S  
ATOM   1049  H   CYS A  72      10.323  -0.045  -0.072  1.00  0.00           H  
ATOM   1050  HA  CYS A  72       8.082  -1.162  -1.622  1.00  0.00           H  
ATOM   1051  HB2 CYS A  72       8.774   1.724  -1.164  1.00  0.00           H  
ATOM   1052  HB3 CYS A  72       7.719   1.271  -2.480  1.00  0.00           H  
ATOM   1053  HG  CYS A  72       6.409   2.333  -0.097  1.00  0.00           H  
ATOM   1054  N   LYS A  73      10.875   0.284  -2.556  1.00  0.00           N  
ATOM   1055  CA  LYS A  73      11.993   0.282  -3.525  1.00  0.00           C  
ATOM   1056  C   LYS A  73      11.667   1.012  -4.834  1.00  0.00           C  
ATOM   1057  O   LYS A  73      12.548   1.588  -5.469  1.00  0.00           O  
ATOM   1058  CB  LYS A  73      12.482  -1.148  -3.767  1.00  0.00           C  
ATOM   1059  CG  LYS A  73      12.973  -1.817  -2.488  1.00  0.00           C  
ATOM   1060  CD  LYS A  73      13.222  -3.290  -2.692  1.00  0.00           C  
ATOM   1061  CE  LYS A  73      13.720  -3.951  -1.418  1.00  0.00           C  
ATOM   1062  NZ  LYS A  73      15.026  -3.409  -0.980  1.00  0.00           N  
ATOM   1063  H   LYS A  73      10.992   0.853  -1.764  1.00  0.00           H  
ATOM   1064  HA  LYS A  73      12.792   0.833  -3.052  1.00  0.00           H  
ATOM   1065  HB2 LYS A  73      11.672  -1.726  -4.188  1.00  0.00           H  
ATOM   1066  HB3 LYS A  73      13.297  -1.124  -4.474  1.00  0.00           H  
ATOM   1067  HG2 LYS A  73      13.893  -1.350  -2.171  1.00  0.00           H  
ATOM   1068  HG3 LYS A  73      12.239  -1.690  -1.703  1.00  0.00           H  
ATOM   1069  HD2 LYS A  73      12.275  -3.736  -2.963  1.00  0.00           H  
ATOM   1070  HD3 LYS A  73      13.944  -3.426  -3.482  1.00  0.00           H  
ATOM   1071  HE2 LYS A  73      12.997  -3.782  -0.635  1.00  0.00           H  
ATOM   1072  HE3 LYS A  73      13.819  -5.012  -1.587  1.00  0.00           H  
ATOM   1073  HZ1 LYS A  73      14.995  -2.384  -0.816  1.00  0.00           H  
ATOM   1074  HZ2 LYS A  73      15.775  -3.633  -1.666  1.00  0.00           H  
ATOM   1075  HZ3 LYS A  73      15.302  -3.874  -0.092  1.00  0.00           H  
ATOM   1076  N   ASN A  74      10.424   0.992  -5.224  1.00  0.00           N  
ATOM   1077  CA  ASN A  74       9.977   1.676  -6.404  1.00  0.00           C  
ATOM   1078  C   ASN A  74       9.136   2.870  -6.004  1.00  0.00           C  
ATOM   1079  O   ASN A  74       8.017   2.729  -5.521  1.00  0.00           O  
ATOM   1080  CB  ASN A  74       9.234   0.721  -7.337  1.00  0.00           C  
ATOM   1081  CG  ASN A  74      10.172  -0.323  -7.921  1.00  0.00           C  
ATOM   1082  OD1 ASN A  74      11.350  -0.044  -8.185  1.00  0.00           O  
ATOM   1083  ND2 ASN A  74       9.704  -1.529  -8.060  1.00  0.00           N  
ATOM   1084  H   ASN A  74       9.777   0.477  -4.693  1.00  0.00           H  
ATOM   1085  HA  ASN A  74      10.866   2.036  -6.901  1.00  0.00           H  
ATOM   1086  HB2 ASN A  74       8.453   0.219  -6.784  1.00  0.00           H  
ATOM   1087  HB3 ASN A  74       8.799   1.284  -8.150  1.00  0.00           H  
ATOM   1088 HD21 ASN A  74       8.779  -1.714  -7.784  1.00  0.00           H  
ATOM   1089 HD22 ASN A  74      10.298  -2.217  -8.425  1.00  0.00           H  
ATOM   1090  N   PRO A  75       9.688   4.076  -6.166  1.00  0.00           N  
ATOM   1091  CA  PRO A  75       9.055   5.327  -5.716  1.00  0.00           C  
ATOM   1092  C   PRO A  75       7.854   5.811  -6.490  1.00  0.00           C  
ATOM   1093  O   PRO A  75       7.351   6.906  -6.259  1.00  0.00           O  
ATOM   1094  CB  PRO A  75      10.115   6.341  -5.815  1.00  0.00           C  
ATOM   1095  CG  PRO A  75      11.168   5.782  -6.752  1.00  0.00           C  
ATOM   1096  CD  PRO A  75      11.018   4.309  -6.765  1.00  0.00           C  
ATOM   1097  HA  PRO A  75       8.768   5.261  -4.678  1.00  0.00           H  
ATOM   1098  HB2 PRO A  75       9.579   7.189  -6.219  1.00  0.00           H  
ATOM   1099  HB3 PRO A  75      10.404   6.519  -4.795  1.00  0.00           H  
ATOM   1100  HG2 PRO A  75      11.010   6.149  -7.762  1.00  0.00           H  
ATOM   1101  HG3 PRO A  75      12.161   6.060  -6.430  1.00  0.00           H  
ATOM   1102  HD2 PRO A  75      11.050   3.940  -7.781  1.00  0.00           H  
ATOM   1103  HD3 PRO A  75      11.792   3.850  -6.169  1.00  0.00           H  
ATOM   1104  N   GLU A  76       7.401   5.008  -7.372  1.00  0.00           N  
ATOM   1105  CA  GLU A  76       6.154   5.218  -8.073  1.00  0.00           C  
ATOM   1106  C   GLU A  76       5.012   5.094  -7.045  1.00  0.00           C  
ATOM   1107  O   GLU A  76       3.911   5.598  -7.222  1.00  0.00           O  
ATOM   1108  CB  GLU A  76       6.063   4.178  -9.224  1.00  0.00           C  
ATOM   1109  CG  GLU A  76       4.966   4.383 -10.289  1.00  0.00           C  
ATOM   1110  CD  GLU A  76       3.604   3.850  -9.914  1.00  0.00           C  
ATOM   1111  OE1 GLU A  76       3.400   2.608  -9.986  1.00  0.00           O  
ATOM   1112  OE2 GLU A  76       2.708   4.638  -9.562  1.00  0.00           O  
ATOM   1113  H   GLU A  76       7.979   4.256  -7.576  1.00  0.00           H  
ATOM   1114  HA  GLU A  76       6.173   6.213  -8.475  1.00  0.00           H  
ATOM   1115  HB2 GLU A  76       7.011   4.170  -9.740  1.00  0.00           H  
ATOM   1116  HB3 GLU A  76       5.920   3.206  -8.777  1.00  0.00           H  
ATOM   1117  HG2 GLU A  76       4.864   5.444 -10.467  1.00  0.00           H  
ATOM   1118  HG3 GLU A  76       5.286   3.910 -11.206  1.00  0.00           H  
ATOM   1119  N   ASP A  77       5.367   4.520  -5.918  1.00  0.00           N  
ATOM   1120  CA  ASP A  77       4.444   4.298  -4.811  1.00  0.00           C  
ATOM   1121  C   ASP A  77       4.839   5.115  -3.625  1.00  0.00           C  
ATOM   1122  O   ASP A  77       4.253   5.003  -2.544  1.00  0.00           O  
ATOM   1123  CB  ASP A  77       4.356   2.835  -4.409  1.00  0.00           C  
ATOM   1124  CG  ASP A  77       3.493   2.027  -5.331  1.00  0.00           C  
ATOM   1125  OD1 ASP A  77       2.297   2.379  -5.493  1.00  0.00           O  
ATOM   1126  OD2 ASP A  77       3.955   0.995  -5.863  1.00  0.00           O  
ATOM   1127  H   ASP A  77       6.326   4.303  -5.843  1.00  0.00           H  
ATOM   1128  HA  ASP A  77       3.468   4.631  -5.131  1.00  0.00           H  
ATOM   1129  HB2 ASP A  77       5.357   2.431  -4.423  1.00  0.00           H  
ATOM   1130  HB3 ASP A  77       3.962   2.772  -3.405  1.00  0.00           H  
ATOM   1131  N   LEU A  78       5.829   5.944  -3.814  1.00  0.00           N  
ATOM   1132  CA  LEU A  78       6.274   6.799  -2.797  1.00  0.00           C  
ATOM   1133  C   LEU A  78       5.430   8.043  -2.898  1.00  0.00           C  
ATOM   1134  O   LEU A  78       5.658   8.924  -3.743  1.00  0.00           O  
ATOM   1135  CB  LEU A  78       7.714   7.120  -3.031  1.00  0.00           C  
ATOM   1136  CG  LEU A  78       8.360   7.972  -2.009  1.00  0.00           C  
ATOM   1137  CD1 LEU A  78       8.702   7.209  -0.755  1.00  0.00           C  
ATOM   1138  CD2 LEU A  78       9.530   8.690  -2.559  1.00  0.00           C  
ATOM   1139  H   LEU A  78       6.264   6.051  -4.681  1.00  0.00           H  
ATOM   1140  HA  LEU A  78       6.146   6.324  -1.836  1.00  0.00           H  
ATOM   1141  HB2 LEU A  78       8.255   6.189  -3.092  1.00  0.00           H  
ATOM   1142  HB3 LEU A  78       7.752   7.628  -3.982  1.00  0.00           H  
ATOM   1143  HG  LEU A  78       7.593   8.698  -1.817  1.00  0.00           H  
ATOM   1144 HD11 LEU A  78       9.216   7.877  -0.081  1.00  0.00           H  
ATOM   1145 HD12 LEU A  78       9.358   6.388  -1.012  1.00  0.00           H  
ATOM   1146 HD13 LEU A  78       7.802   6.839  -0.288  1.00  0.00           H  
ATOM   1147 HD21 LEU A  78      10.045   9.220  -1.771  1.00  0.00           H  
ATOM   1148 HD22 LEU A  78       9.145   9.404  -3.273  1.00  0.00           H  
ATOM   1149 HD23 LEU A  78      10.196   8.001  -3.055  1.00  0.00           H  
ATOM   1150  N   GLU A  79       4.440   8.057  -2.103  1.00  0.00           N  
ATOM   1151  CA  GLU A  79       3.444   9.037  -2.091  1.00  0.00           C  
ATOM   1152  C   GLU A  79       3.001   9.210  -0.681  1.00  0.00           C  
ATOM   1153  O   GLU A  79       2.999   8.262   0.077  1.00  0.00           O  
ATOM   1154  CB  GLU A  79       2.285   8.475  -2.884  1.00  0.00           C  
ATOM   1155  CG  GLU A  79       1.020   9.269  -2.838  1.00  0.00           C  
ATOM   1156  CD  GLU A  79       1.154  10.651  -3.424  1.00  0.00           C  
ATOM   1157  OE1 GLU A  79       1.682  11.549  -2.728  1.00  0.00           O  
ATOM   1158  OE2 GLU A  79       0.724  10.871  -4.571  1.00  0.00           O  
ATOM   1159  H   GLU A  79       4.326   7.330  -1.460  1.00  0.00           H  
ATOM   1160  HA  GLU A  79       3.737   9.982  -2.517  1.00  0.00           H  
ATOM   1161  HB2 GLU A  79       2.565   8.319  -3.915  1.00  0.00           H  
ATOM   1162  HB3 GLU A  79       2.073   7.524  -2.419  1.00  0.00           H  
ATOM   1163  HG2 GLU A  79       0.297   8.653  -3.341  1.00  0.00           H  
ATOM   1164  HG3 GLU A  79       0.726   9.343  -1.801  1.00  0.00           H  
ATOM   1165  N   CYS A  80       2.572  10.386  -0.354  1.00  0.00           N  
ATOM   1166  CA  CYS A  80       2.009  10.646   0.924  1.00  0.00           C  
ATOM   1167  C   CYS A  80       0.560  10.275   0.825  1.00  0.00           C  
ATOM   1168  O   CYS A  80      -0.327  11.116   0.716  1.00  0.00           O  
ATOM   1169  CB  CYS A  80       2.212  12.111   1.346  1.00  0.00           C  
ATOM   1170  SG  CYS A  80       1.308  12.641   2.825  1.00  0.00           S  
ATOM   1171  H   CYS A  80       2.563  11.069  -1.059  1.00  0.00           H  
ATOM   1172  HA  CYS A  80       2.485   9.983   1.633  1.00  0.00           H  
ATOM   1173  HB2 CYS A  80       3.259  12.207   1.591  1.00  0.00           H  
ATOM   1174  HB3 CYS A  80       1.991  12.796   0.540  1.00  0.00           H  
ATOM   1175  HG  CYS A  80       0.280  13.349   2.379  1.00  0.00           H  
ATOM   1176  N   ASN A  81       0.332   8.996   0.735  1.00  0.00           N  
ATOM   1177  CA  ASN A  81      -0.994   8.508   0.546  1.00  0.00           C  
ATOM   1178  C   ASN A  81      -1.533   8.114   1.860  1.00  0.00           C  
ATOM   1179  O   ASN A  81      -0.853   8.189   2.853  1.00  0.00           O  
ATOM   1180  CB  ASN A  81      -1.059   7.326  -0.415  1.00  0.00           C  
ATOM   1181  CG  ASN A  81      -0.437   6.068   0.183  1.00  0.00           C  
ATOM   1182  OD1 ASN A  81      -1.028   5.397   0.903  1.00  0.00           O  
ATOM   1183  ND2 ASN A  81       0.727   5.769  -0.118  1.00  0.00           N  
ATOM   1184  H   ASN A  81       1.092   8.373   0.804  1.00  0.00           H  
ATOM   1185  HA  ASN A  81      -1.524   9.359   0.162  1.00  0.00           H  
ATOM   1186  HB2 ASN A  81      -2.094   7.117  -0.632  1.00  0.00           H  
ATOM   1187  HB3 ASN A  81      -0.538   7.570  -1.329  1.00  0.00           H  
ATOM   1188 HD21 ASN A  81       1.217   6.345  -0.712  1.00  0.00           H  
ATOM   1189 HD22 ASN A  81       1.088   4.939   0.248  1.00  0.00           H  
ATOM   1190  N   GLU A  82      -2.721   7.679   1.816  1.00  0.00           N  
ATOM   1191  CA  GLU A  82      -3.497   7.210   2.916  1.00  0.00           C  
ATOM   1192  C   GLU A  82      -2.714   6.201   3.798  1.00  0.00           C  
ATOM   1193  O   GLU A  82      -2.555   6.404   4.996  1.00  0.00           O  
ATOM   1194  CB  GLU A  82      -4.657   6.547   2.291  1.00  0.00           C  
ATOM   1195  CG  GLU A  82      -5.729   6.156   3.228  1.00  0.00           C  
ATOM   1196  CD  GLU A  82      -6.829   5.422   2.529  1.00  0.00           C  
ATOM   1197  OE1 GLU A  82      -6.716   4.193   2.347  1.00  0.00           O  
ATOM   1198  OE2 GLU A  82      -7.815   6.057   2.100  1.00  0.00           O  
ATOM   1199  H   GLU A  82      -3.169   7.705   0.945  1.00  0.00           H  
ATOM   1200  HA  GLU A  82      -3.828   8.094   3.429  1.00  0.00           H  
ATOM   1201  HB2 GLU A  82      -5.036   7.203   1.522  1.00  0.00           H  
ATOM   1202  HB3 GLU A  82      -4.236   5.672   1.812  1.00  0.00           H  
ATOM   1203  HG2 GLU A  82      -5.285   5.554   4.007  1.00  0.00           H  
ATOM   1204  HG3 GLU A  82      -6.102   7.088   3.626  1.00  0.00           H  
ATOM   1205  N   ASN A  83      -2.218   5.159   3.154  1.00  0.00           N  
ATOM   1206  CA  ASN A  83      -1.397   4.099   3.748  1.00  0.00           C  
ATOM   1207  C   ASN A  83      -0.213   4.743   4.413  1.00  0.00           C  
ATOM   1208  O   ASN A  83       0.080   4.490   5.598  1.00  0.00           O  
ATOM   1209  CB  ASN A  83      -0.852   3.168   2.626  1.00  0.00           C  
ATOM   1210  CG  ASN A  83      -0.193   1.886   3.131  1.00  0.00           C  
ATOM   1211  OD1 ASN A  83       0.307   1.807   4.258  1.00  0.00           O  
ATOM   1212  ND2 ASN A  83      -0.168   0.876   2.296  1.00  0.00           N  
ATOM   1213  H   ASN A  83      -2.387   5.093   2.189  1.00  0.00           H  
ATOM   1214  HA  ASN A  83      -1.972   3.518   4.450  1.00  0.00           H  
ATOM   1215  HB2 ASN A  83      -1.681   2.900   1.987  1.00  0.00           H  
ATOM   1216  HB3 ASN A  83      -0.152   3.736   2.013  1.00  0.00           H  
ATOM   1217 HD21 ASN A  83      -0.566   1.008   1.408  1.00  0.00           H  
ATOM   1218 HD22 ASN A  83       0.233   0.031   2.584  1.00  0.00           H  
ATOM   1219  N   VAL A  84       0.461   5.613   3.660  1.00  0.00           N  
ATOM   1220  CA  VAL A  84       1.630   6.285   4.181  1.00  0.00           C  
ATOM   1221  C   VAL A  84       1.289   7.174   5.374  1.00  0.00           C  
ATOM   1222  O   VAL A  84       1.968   7.124   6.393  1.00  0.00           O  
ATOM   1223  CB  VAL A  84       2.369   7.045   3.080  1.00  0.00           C  
ATOM   1224  CG1 VAL A  84       3.449   7.942   3.635  1.00  0.00           C  
ATOM   1225  CG2 VAL A  84       2.981   6.049   2.145  1.00  0.00           C  
ATOM   1226  H   VAL A  84       0.170   5.814   2.736  1.00  0.00           H  
ATOM   1227  HA  VAL A  84       2.263   5.483   4.532  1.00  0.00           H  
ATOM   1228  HB  VAL A  84       1.663   7.633   2.512  1.00  0.00           H  
ATOM   1229 HG11 VAL A  84       2.991   8.696   4.255  1.00  0.00           H  
ATOM   1230 HG12 VAL A  84       3.963   8.404   2.807  1.00  0.00           H  
ATOM   1231 HG13 VAL A  84       4.147   7.359   4.218  1.00  0.00           H  
ATOM   1232 HG21 VAL A  84       3.687   5.446   2.695  1.00  0.00           H  
ATOM   1233 HG22 VAL A  84       3.493   6.593   1.365  1.00  0.00           H  
ATOM   1234 HG23 VAL A  84       2.207   5.425   1.725  1.00  0.00           H  
ATOM   1235  N   LYS A  85       0.221   7.935   5.252  1.00  0.00           N  
ATOM   1236  CA  LYS A  85      -0.270   8.809   6.320  1.00  0.00           C  
ATOM   1237  C   LYS A  85      -0.526   8.024   7.550  1.00  0.00           C  
ATOM   1238  O   LYS A  85      -0.009   8.349   8.593  1.00  0.00           O  
ATOM   1239  CB  LYS A  85      -1.541   9.513   5.904  1.00  0.00           C  
ATOM   1240  CG  LYS A  85      -1.332  10.480   4.798  1.00  0.00           C  
ATOM   1241  CD  LYS A  85      -2.623  11.042   4.301  1.00  0.00           C  
ATOM   1242  CE  LYS A  85      -2.385  11.732   3.005  1.00  0.00           C  
ATOM   1243  NZ  LYS A  85      -3.589  12.384   2.468  1.00  0.00           N  
ATOM   1244  H   LYS A  85      -0.247   7.899   4.384  1.00  0.00           H  
ATOM   1245  HA  LYS A  85       0.481   9.549   6.537  1.00  0.00           H  
ATOM   1246  HB2 LYS A  85      -2.257   8.772   5.577  1.00  0.00           H  
ATOM   1247  HB3 LYS A  85      -1.948  10.045   6.752  1.00  0.00           H  
ATOM   1248  HG2 LYS A  85      -0.745  11.295   5.198  1.00  0.00           H  
ATOM   1249  HG3 LYS A  85      -0.803   9.998   3.989  1.00  0.00           H  
ATOM   1250  HD2 LYS A  85      -3.325  10.233   4.158  1.00  0.00           H  
ATOM   1251  HD3 LYS A  85      -3.012  11.752   5.018  1.00  0.00           H  
ATOM   1252  HE2 LYS A  85      -1.582  12.440   3.138  1.00  0.00           H  
ATOM   1253  HE3 LYS A  85      -2.064  10.940   2.342  1.00  0.00           H  
ATOM   1254  HZ1 LYS A  85      -3.945  13.107   3.129  1.00  0.00           H  
ATOM   1255  HZ2 LYS A  85      -4.345  11.695   2.284  1.00  0.00           H  
ATOM   1256  HZ3 LYS A  85      -3.363  12.856   1.569  1.00  0.00           H  
ATOM   1257  N   HIS A  86      -1.256   6.949   7.377  1.00  0.00           N  
ATOM   1258  CA  HIS A  86      -1.630   6.014   8.441  1.00  0.00           C  
ATOM   1259  C   HIS A  86      -0.367   5.611   9.222  1.00  0.00           C  
ATOM   1260  O   HIS A  86      -0.244   5.798  10.453  1.00  0.00           O  
ATOM   1261  CB  HIS A  86      -2.257   4.786   7.751  1.00  0.00           C  
ATOM   1262  CG  HIS A  86      -2.776   3.698   8.631  1.00  0.00           C  
ATOM   1263  ND1 HIS A  86      -4.112   3.460   8.789  1.00  0.00           N  
ATOM   1264  CD2 HIS A  86      -2.140   2.721   9.306  1.00  0.00           C  
ATOM   1265  CE1 HIS A  86      -4.290   2.395   9.505  1.00  0.00           C  
ATOM   1266  NE2 HIS A  86      -3.105   1.910   9.838  1.00  0.00           N  
ATOM   1267  H   HIS A  86      -1.543   6.790   6.446  1.00  0.00           H  
ATOM   1268  HA  HIS A  86      -2.374   6.494   9.057  1.00  0.00           H  
ATOM   1269  HB2 HIS A  86      -3.087   5.120   7.146  1.00  0.00           H  
ATOM   1270  HB3 HIS A  86      -1.516   4.356   7.093  1.00  0.00           H  
ATOM   1271  HD1 HIS A  86      -4.835   4.008   8.415  1.00  0.00           H  
ATOM   1272  HD2 HIS A  86      -1.072   2.624   9.434  1.00  0.00           H  
ATOM   1273  HE1 HIS A  86      -5.249   1.985   9.780  1.00  0.00           H  
ATOM   1274  N   LYS A  87       0.584   5.153   8.466  1.00  0.00           N  
ATOM   1275  CA  LYS A  87       1.857   4.669   8.961  1.00  0.00           C  
ATOM   1276  C   LYS A  87       2.621   5.790   9.655  1.00  0.00           C  
ATOM   1277  O   LYS A  87       3.223   5.588  10.702  1.00  0.00           O  
ATOM   1278  CB  LYS A  87       2.621   4.050   7.787  1.00  0.00           C  
ATOM   1279  CG  LYS A  87       4.021   3.564   8.054  1.00  0.00           C  
ATOM   1280  CD  LYS A  87       4.521   2.704   6.882  1.00  0.00           C  
ATOM   1281  CE  LYS A  87       4.630   3.467   5.537  1.00  0.00           C  
ATOM   1282  NZ  LYS A  87       5.763   4.419   5.504  1.00  0.00           N  
ATOM   1283  H   LYS A  87       0.418   5.092   7.499  1.00  0.00           H  
ATOM   1284  HA  LYS A  87       1.745   3.961   9.763  1.00  0.00           H  
ATOM   1285  HB2 LYS A  87       2.061   3.210   7.408  1.00  0.00           H  
ATOM   1286  HB3 LYS A  87       2.668   4.797   7.009  1.00  0.00           H  
ATOM   1287  HG2 LYS A  87       4.659   4.427   8.177  1.00  0.00           H  
ATOM   1288  HG3 LYS A  87       4.014   2.975   8.958  1.00  0.00           H  
ATOM   1289  HD2 LYS A  87       5.494   2.314   7.138  1.00  0.00           H  
ATOM   1290  HD3 LYS A  87       3.826   1.884   6.770  1.00  0.00           H  
ATOM   1291  HE2 LYS A  87       4.767   2.747   4.744  1.00  0.00           H  
ATOM   1292  HE3 LYS A  87       3.709   4.003   5.364  1.00  0.00           H  
ATOM   1293  HZ1 LYS A  87       5.732   5.086   6.299  1.00  0.00           H  
ATOM   1294  HZ2 LYS A  87       5.775   4.982   4.617  1.00  0.00           H  
ATOM   1295  HZ3 LYS A  87       6.662   3.901   5.559  1.00  0.00           H  
ATOM   1296  N   THR A  88       2.467   6.946   9.137  1.00  0.00           N  
ATOM   1297  CA  THR A  88       3.155   8.075   9.561  1.00  0.00           C  
ATOM   1298  C   THR A  88       2.647   8.577  10.863  1.00  0.00           C  
ATOM   1299  O   THR A  88       3.378   8.594  11.801  1.00  0.00           O  
ATOM   1300  CB  THR A  88       3.049   9.139   8.516  1.00  0.00           C  
ATOM   1301  OG1 THR A  88       3.818   8.755   7.383  1.00  0.00           O  
ATOM   1302  CG2 THR A  88       3.469  10.470   9.053  1.00  0.00           C  
ATOM   1303  H   THR A  88       1.815   6.995   8.413  1.00  0.00           H  
ATOM   1304  HA  THR A  88       4.204   7.853   9.682  1.00  0.00           H  
ATOM   1305  HB  THR A  88       2.010   9.175   8.220  1.00  0.00           H  
ATOM   1306  HG1 THR A  88       3.283   8.140   6.868  1.00  0.00           H  
ATOM   1307 HG21 THR A  88       3.381  11.218   8.281  1.00  0.00           H  
ATOM   1308 HG22 THR A  88       4.475  10.398   9.439  1.00  0.00           H  
ATOM   1309 HG23 THR A  88       2.766  10.672   9.849  1.00  0.00           H  
ATOM   1310  N   LYS A  89       1.393   8.936  10.928  1.00  0.00           N  
ATOM   1311  CA  LYS A  89       0.854   9.487  12.134  1.00  0.00           C  
ATOM   1312  C   LYS A  89       0.918   8.491  13.298  1.00  0.00           C  
ATOM   1313  O   LYS A  89       1.147   8.878  14.458  1.00  0.00           O  
ATOM   1314  CB  LYS A  89      -0.545  10.100  11.898  1.00  0.00           C  
ATOM   1315  CG  LYS A  89      -1.418   9.319  10.941  1.00  0.00           C  
ATOM   1316  CD  LYS A  89      -1.869   8.043  11.496  1.00  0.00           C  
ATOM   1317  CE  LYS A  89      -3.070   8.203  12.395  1.00  0.00           C  
ATOM   1318  NZ  LYS A  89      -4.278   8.598  11.638  1.00  0.00           N  
ATOM   1319  H   LYS A  89       0.834   8.826  10.125  1.00  0.00           H  
ATOM   1320  HA  LYS A  89       1.541  10.313  12.274  1.00  0.00           H  
ATOM   1321  HB2 LYS A  89      -1.062  10.171  12.844  1.00  0.00           H  
ATOM   1322  HB3 LYS A  89      -0.415  11.095  11.499  1.00  0.00           H  
ATOM   1323  HG2 LYS A  89      -2.300   9.879  10.707  1.00  0.00           H  
ATOM   1324  HG3 LYS A  89      -0.850   9.118  10.042  1.00  0.00           H  
ATOM   1325  HD2 LYS A  89      -2.007   7.364  10.669  1.00  0.00           H  
ATOM   1326  HD3 LYS A  89      -1.018   7.710  12.064  1.00  0.00           H  
ATOM   1327  HE2 LYS A  89      -3.257   7.280  12.920  1.00  0.00           H  
ATOM   1328  HE3 LYS A  89      -2.840   8.985  13.103  1.00  0.00           H  
ATOM   1329  HZ1 LYS A  89      -5.089   8.684  12.284  1.00  0.00           H  
ATOM   1330  HZ2 LYS A  89      -4.516   7.885  10.918  1.00  0.00           H  
ATOM   1331  HZ3 LYS A  89      -4.148   9.509  11.156  1.00  0.00           H  
ATOM   1332  N   GLU A  90       0.771   7.191  12.974  1.00  0.00           N  
ATOM   1333  CA  GLU A  90       0.930   6.155  13.994  1.00  0.00           C  
ATOM   1334  C   GLU A  90       2.389   6.053  14.439  1.00  0.00           C  
ATOM   1335  O   GLU A  90       2.690   5.938  15.670  1.00  0.00           O  
ATOM   1336  CB  GLU A  90       0.393   4.806  13.539  1.00  0.00           C  
ATOM   1337  CG  GLU A  90      -1.120   4.788  13.407  1.00  0.00           C  
ATOM   1338  CD  GLU A  90      -1.696   3.409  13.240  1.00  0.00           C  
ATOM   1339  OE1 GLU A  90      -1.237   2.470  13.921  1.00  0.00           O  
ATOM   1340  OE2 GLU A  90      -2.686   3.260  12.506  1.00  0.00           O  
ATOM   1341  H   GLU A  90       0.540   6.960  12.039  1.00  0.00           H  
ATOM   1342  HA  GLU A  90       0.366   6.491  14.850  1.00  0.00           H  
ATOM   1343  HB2 GLU A  90       0.835   4.593  12.577  1.00  0.00           H  
ATOM   1344  HB3 GLU A  90       0.697   4.047  14.243  1.00  0.00           H  
ATOM   1345  HG2 GLU A  90      -1.563   5.231  14.285  1.00  0.00           H  
ATOM   1346  HG3 GLU A  90      -1.389   5.376  12.542  1.00  0.00           H  
ATOM   1347  N   TYR A  91       3.292   6.226  13.474  1.00  0.00           N  
ATOM   1348  CA  TYR A  91       4.708   6.197  13.751  1.00  0.00           C  
ATOM   1349  C   TYR A  91       5.053   7.384  14.608  1.00  0.00           C  
ATOM   1350  O   TYR A  91       5.721   7.242  15.587  1.00  0.00           O  
ATOM   1351  CB  TYR A  91       5.530   6.213  12.445  1.00  0.00           C  
ATOM   1352  CG  TYR A  91       6.923   6.770  12.582  1.00  0.00           C  
ATOM   1353  CD1 TYR A  91       7.885   6.129  13.338  1.00  0.00           C  
ATOM   1354  CD2 TYR A  91       7.261   7.955  11.951  1.00  0.00           C  
ATOM   1355  CE1 TYR A  91       9.145   6.656  13.466  1.00  0.00           C  
ATOM   1356  CE2 TYR A  91       8.515   8.485  12.070  1.00  0.00           C  
ATOM   1357  CZ  TYR A  91       9.456   7.832  12.831  1.00  0.00           C  
ATOM   1358  OH  TYR A  91      10.718   8.359  12.958  1.00  0.00           O  
ATOM   1359  H   TYR A  91       3.028   6.534  12.576  1.00  0.00           H  
ATOM   1360  HA  TYR A  91       4.907   5.279  14.286  1.00  0.00           H  
ATOM   1361  HB2 TYR A  91       5.625   5.205  12.070  1.00  0.00           H  
ATOM   1362  HB3 TYR A  91       5.003   6.805  11.713  1.00  0.00           H  
ATOM   1363  HD1 TYR A  91       7.627   5.207  13.837  1.00  0.00           H  
ATOM   1364  HD2 TYR A  91       6.517   8.464  11.357  1.00  0.00           H  
ATOM   1365  HE1 TYR A  91       9.888   6.144  14.061  1.00  0.00           H  
ATOM   1366  HE2 TYR A  91       8.747   9.412  11.569  1.00  0.00           H  
ATOM   1367  HH  TYR A  91      10.639   9.291  13.183  1.00  0.00           H  
ATOM   1368  N   ILE A  92       4.563   8.550  14.206  1.00  0.00           N  
ATOM   1369  CA  ILE A  92       4.750   9.809  14.928  1.00  0.00           C  
ATOM   1370  C   ILE A  92       4.399   9.676  16.369  1.00  0.00           C  
ATOM   1371  O   ILE A  92       5.231   9.982  17.220  1.00  0.00           O  
ATOM   1372  CB  ILE A  92       3.881  10.933  14.329  1.00  0.00           C  
ATOM   1373  CG1 ILE A  92       4.281  11.232  12.888  1.00  0.00           C  
ATOM   1374  CG2 ILE A  92       3.927  12.193  15.205  1.00  0.00           C  
ATOM   1375  CD1 ILE A  92       5.424  12.147  12.737  1.00  0.00           C  
ATOM   1376  H   ILE A  92       4.092   8.585  13.339  1.00  0.00           H  
ATOM   1377  HA  ILE A  92       5.785  10.094  14.895  1.00  0.00           H  
ATOM   1378  HB  ILE A  92       2.859  10.579  14.342  1.00  0.00           H  
ATOM   1379 HG12 ILE A  92       4.648  10.298  12.490  1.00  0.00           H  
ATOM   1380 HG13 ILE A  92       3.445  11.588  12.308  1.00  0.00           H  
ATOM   1381 HG21 ILE A  92       3.284  12.963  14.804  1.00  0.00           H  
ATOM   1382 HG22 ILE A  92       4.949  12.537  15.249  1.00  0.00           H  
ATOM   1383 HG23 ILE A  92       3.614  11.915  16.201  1.00  0.00           H  
ATOM   1384 HD11 ILE A  92       5.640  12.295  11.690  1.00  0.00           H  
ATOM   1385 HD12 ILE A  92       6.271  11.700  13.237  1.00  0.00           H  
ATOM   1386 HD13 ILE A  92       5.151  13.088  13.198  1.00  0.00           H  
ATOM   1387  N   LYS A  93       3.183   9.244  16.647  1.00  0.00           N  
ATOM   1388  CA  LYS A  93       2.764   9.098  18.013  1.00  0.00           C  
ATOM   1389  C   LYS A  93       3.715   8.214  18.755  1.00  0.00           C  
ATOM   1390  O   LYS A  93       4.351   8.655  19.733  1.00  0.00           O  
ATOM   1391  CB  LYS A  93       1.332   8.585  18.126  1.00  0.00           C  
ATOM   1392  CG  LYS A  93       0.311   9.574  17.618  1.00  0.00           C  
ATOM   1393  CD  LYS A  93      -1.102   9.128  17.915  1.00  0.00           C  
ATOM   1394  CE  LYS A  93      -2.092  10.227  17.578  1.00  0.00           C  
ATOM   1395  NZ  LYS A  93      -1.806  11.477  18.333  1.00  0.00           N  
ATOM   1396  H   LYS A  93       2.568   9.032  15.908  1.00  0.00           H  
ATOM   1397  HA  LYS A  93       2.816  10.076  18.468  1.00  0.00           H  
ATOM   1398  HB2 LYS A  93       1.240   7.675  17.553  1.00  0.00           H  
ATOM   1399  HB3 LYS A  93       1.117   8.375  19.163  1.00  0.00           H  
ATOM   1400  HG2 LYS A  93       0.484  10.531  18.089  1.00  0.00           H  
ATOM   1401  HG3 LYS A  93       0.432   9.676  16.549  1.00  0.00           H  
ATOM   1402  HD2 LYS A  93      -1.328   8.254  17.324  1.00  0.00           H  
ATOM   1403  HD3 LYS A  93      -1.184   8.890  18.965  1.00  0.00           H  
ATOM   1404  HE2 LYS A  93      -2.030  10.436  16.521  1.00  0.00           H  
ATOM   1405  HE3 LYS A  93      -3.088   9.888  17.821  1.00  0.00           H  
ATOM   1406  HZ1 LYS A  93      -1.796  11.319  19.360  1.00  0.00           H  
ATOM   1407  HZ2 LYS A  93      -2.527  12.200  18.133  1.00  0.00           H  
ATOM   1408  HZ3 LYS A  93      -0.893  11.900  18.066  1.00  0.00           H  
ATOM   1409  N   LYS A  94       3.971   7.051  18.192  1.00  0.00           N  
ATOM   1410  CA  LYS A  94       4.775   6.072  18.882  1.00  0.00           C  
ATOM   1411  C   LYS A  94       6.179   6.616  19.071  1.00  0.00           C  
ATOM   1412  O   LYS A  94       6.808   6.390  20.102  1.00  0.00           O  
ATOM   1413  CB  LYS A  94       4.783   4.729  18.132  1.00  0.00           C  
ATOM   1414  CG  LYS A  94       5.572   3.596  18.794  1.00  0.00           C  
ATOM   1415  CD  LYS A  94       4.991   3.209  20.149  1.00  0.00           C  
ATOM   1416  CE  LYS A  94       5.701   1.995  20.739  1.00  0.00           C  
ATOM   1417  NZ  LYS A  94       7.140   2.233  20.995  1.00  0.00           N  
ATOM   1418  H   LYS A  94       3.686   6.887  17.262  1.00  0.00           H  
ATOM   1419  HA  LYS A  94       4.314   5.963  19.852  1.00  0.00           H  
ATOM   1420  HB2 LYS A  94       3.763   4.392  18.017  1.00  0.00           H  
ATOM   1421  HB3 LYS A  94       5.200   4.896  17.148  1.00  0.00           H  
ATOM   1422  HG2 LYS A  94       5.552   2.731  18.148  1.00  0.00           H  
ATOM   1423  HG3 LYS A  94       6.594   3.917  18.927  1.00  0.00           H  
ATOM   1424  HD2 LYS A  94       5.103   4.043  20.827  1.00  0.00           H  
ATOM   1425  HD3 LYS A  94       3.942   2.982  20.026  1.00  0.00           H  
ATOM   1426  HE2 LYS A  94       5.229   1.730  21.674  1.00  0.00           H  
ATOM   1427  HE3 LYS A  94       5.603   1.174  20.045  1.00  0.00           H  
ATOM   1428  HZ1 LYS A  94       7.653   2.508  20.133  1.00  0.00           H  
ATOM   1429  HZ2 LYS A  94       7.579   1.362  21.351  1.00  0.00           H  
ATOM   1430  HZ3 LYS A  94       7.270   2.974  21.711  1.00  0.00           H  
ATOM   1431  N   TYR A  95       6.625   7.369  18.102  1.00  0.00           N  
ATOM   1432  CA  TYR A  95       7.893   7.976  18.139  1.00  0.00           C  
ATOM   1433  C   TYR A  95       7.991   8.987  19.265  1.00  0.00           C  
ATOM   1434  O   TYR A  95       8.863   8.912  20.078  1.00  0.00           O  
ATOM   1435  CB  TYR A  95       8.145   8.623  16.808  1.00  0.00           C  
ATOM   1436  CG  TYR A  95       9.363   9.472  16.767  1.00  0.00           C  
ATOM   1437  CD1 TYR A  95      10.627   8.911  16.756  1.00  0.00           C  
ATOM   1438  CD2 TYR A  95       9.256  10.840  16.769  1.00  0.00           C  
ATOM   1439  CE1 TYR A  95      11.738   9.702  16.735  1.00  0.00           C  
ATOM   1440  CE2 TYR A  95      10.362  11.623  16.743  1.00  0.00           C  
ATOM   1441  CZ  TYR A  95      11.599  11.053  16.721  1.00  0.00           C  
ATOM   1442  OH  TYR A  95      12.713  11.839  16.678  1.00  0.00           O  
ATOM   1443  H   TYR A  95       6.087   7.475  17.275  1.00  0.00           H  
ATOM   1444  HA  TYR A  95       8.657   7.229  18.293  1.00  0.00           H  
ATOM   1445  HB2 TYR A  95       8.241   7.845  16.064  1.00  0.00           H  
ATOM   1446  HB3 TYR A  95       7.259   9.212  16.606  1.00  0.00           H  
ATOM   1447  HD1 TYR A  95      10.739   7.838  16.772  1.00  0.00           H  
ATOM   1448  HD2 TYR A  95       8.275  11.290  16.772  1.00  0.00           H  
ATOM   1449  HE1 TYR A  95      12.736   9.289  16.734  1.00  0.00           H  
ATOM   1450  HE2 TYR A  95      10.256  12.695  16.769  1.00  0.00           H  
ATOM   1451  HH  TYR A  95      13.370  11.314  17.175  1.00  0.00           H  
ATOM   1452  N   MET A  96       7.069   9.906  19.325  1.00  0.00           N  
ATOM   1453  CA  MET A  96       7.120  10.940  20.310  1.00  0.00           C  
ATOM   1454  C   MET A  96       6.964  10.406  21.721  1.00  0.00           C  
ATOM   1455  O   MET A  96       7.370  11.060  22.686  1.00  0.00           O  
ATOM   1456  CB  MET A  96       6.122  12.022  20.009  1.00  0.00           C  
ATOM   1457  CG  MET A  96       6.277  12.564  18.591  1.00  0.00           C  
ATOM   1458  SD  MET A  96       5.903  14.284  18.410  1.00  0.00           S  
ATOM   1459  CE  MET A  96       7.086  14.950  19.538  1.00  0.00           C  
ATOM   1460  H   MET A  96       6.379   9.887  18.625  1.00  0.00           H  
ATOM   1461  HA  MET A  96       8.106  11.372  20.236  1.00  0.00           H  
ATOM   1462  HB2 MET A  96       5.143  11.587  20.142  1.00  0.00           H  
ATOM   1463  HB3 MET A  96       6.270  12.815  20.721  1.00  0.00           H  
ATOM   1464  HG2 MET A  96       7.291  12.419  18.261  1.00  0.00           H  
ATOM   1465  HG3 MET A  96       5.593  12.013  17.964  1.00  0.00           H  
ATOM   1466  HE1 MET A  96       7.070  16.029  19.511  1.00  0.00           H  
ATOM   1467  HE2 MET A  96       8.074  14.568  19.325  1.00  0.00           H  
ATOM   1468  HE3 MET A  96       6.754  14.616  20.512  1.00  0.00           H  
ATOM   1469  N   GLN A  97       6.429   9.186  21.836  1.00  0.00           N  
ATOM   1470  CA  GLN A  97       6.275   8.565  23.151  1.00  0.00           C  
ATOM   1471  C   GLN A  97       7.634   8.273  23.799  1.00  0.00           C  
ATOM   1472  O   GLN A  97       7.716   8.079  25.022  1.00  0.00           O  
ATOM   1473  CB  GLN A  97       5.431   7.285  23.113  1.00  0.00           C  
ATOM   1474  CG  GLN A  97       4.091   7.412  22.402  1.00  0.00           C  
ATOM   1475  CD  GLN A  97       3.311   8.661  22.764  1.00  0.00           C  
ATOM   1476  OE1 GLN A  97       2.537   8.687  23.714  1.00  0.00           O  
ATOM   1477  NE2 GLN A  97       3.489   9.694  21.968  1.00  0.00           N  
ATOM   1478  H   GLN A  97       6.112   8.804  20.980  1.00  0.00           H  
ATOM   1479  HA  GLN A  97       5.777   9.293  23.771  1.00  0.00           H  
ATOM   1480  HB2 GLN A  97       5.999   6.519  22.607  1.00  0.00           H  
ATOM   1481  HB3 GLN A  97       5.247   6.963  24.128  1.00  0.00           H  
ATOM   1482  HG2 GLN A  97       4.288   7.453  21.340  1.00  0.00           H  
ATOM   1483  HG3 GLN A  97       3.494   6.541  22.610  1.00  0.00           H  
ATOM   1484 HE21 GLN A  97       4.101   9.560  21.206  1.00  0.00           H  
ATOM   1485 HE22 GLN A  97       3.046  10.547  22.119  1.00  0.00           H  
ATOM   1486  N   LYS A  98       8.693   8.252  22.991  1.00  0.00           N  
ATOM   1487  CA  LYS A  98      10.021   7.953  23.502  1.00  0.00           C  
ATOM   1488  C   LYS A  98      10.662   9.171  24.153  1.00  0.00           C  
ATOM   1489  O   LYS A  98      11.579   9.041  24.955  1.00  0.00           O  
ATOM   1490  CB  LYS A  98      10.911   7.376  22.375  1.00  0.00           C  
ATOM   1491  CG  LYS A  98      11.361   8.355  21.301  1.00  0.00           C  
ATOM   1492  CD  LYS A  98      12.612   9.187  21.661  1.00  0.00           C  
ATOM   1493  CE  LYS A  98      13.914   8.386  21.874  1.00  0.00           C  
ATOM   1494  NZ  LYS A  98      13.917   7.447  23.033  1.00  0.00           N  
ATOM   1495  H   LYS A  98       8.559   8.405  22.025  1.00  0.00           H  
ATOM   1496  HA  LYS A  98       9.902   7.176  24.241  1.00  0.00           H  
ATOM   1497  HB2 LYS A  98      11.792   6.947  22.821  1.00  0.00           H  
ATOM   1498  HB3 LYS A  98      10.351   6.586  21.895  1.00  0.00           H  
ATOM   1499  HG2 LYS A  98      11.398   7.902  20.326  1.00  0.00           H  
ATOM   1500  HG3 LYS A  98      10.536   9.050  21.234  1.00  0.00           H  
ATOM   1501  HD2 LYS A  98      12.781   9.872  20.843  1.00  0.00           H  
ATOM   1502  HD3 LYS A  98      12.391   9.759  22.550  1.00  0.00           H  
ATOM   1503  HE2 LYS A  98      14.167   7.840  20.978  1.00  0.00           H  
ATOM   1504  HE3 LYS A  98      14.672   9.128  22.059  1.00  0.00           H  
ATOM   1505  HZ1 LYS A  98      13.598   7.883  23.924  1.00  0.00           H  
ATOM   1506  HZ2 LYS A  98      14.906   7.178  23.209  1.00  0.00           H  
ATOM   1507  HZ3 LYS A  98      13.405   6.558  22.869  1.00  0.00           H  
ATOM   1508  N   PHE A  99      10.190  10.360  23.787  1.00  0.00           N  
ATOM   1509  CA  PHE A  99      10.760  11.590  24.322  1.00  0.00           C  
ATOM   1510  C   PHE A  99      10.314  11.846  25.745  1.00  0.00           C  
ATOM   1511  O   PHE A  99      11.055  12.425  26.539  1.00  0.00           O  
ATOM   1512  CB  PHE A  99      10.447  12.809  23.447  1.00  0.00           C  
ATOM   1513  CG  PHE A  99      11.117  12.810  22.102  1.00  0.00           C  
ATOM   1514  CD1 PHE A  99      12.499  12.796  22.013  1.00  0.00           C  
ATOM   1515  CD2 PHE A  99      10.374  12.858  20.931  1.00  0.00           C  
ATOM   1516  CE1 PHE A  99      13.131  12.810  20.786  1.00  0.00           C  
ATOM   1517  CE2 PHE A  99      11.006  12.881  19.698  1.00  0.00           C  
ATOM   1518  CZ  PHE A  99      12.389  12.852  19.639  1.00  0.00           C  
ATOM   1519  H   PHE A  99       9.451  10.388  23.144  1.00  0.00           H  
ATOM   1520  HA  PHE A  99      11.832  11.450  24.338  1.00  0.00           H  
ATOM   1521  HB2 PHE A  99       9.380  12.866  23.286  1.00  0.00           H  
ATOM   1522  HB3 PHE A  99      10.773  13.690  23.982  1.00  0.00           H  
ATOM   1523  HD1 PHE A  99      13.091  12.764  22.917  1.00  0.00           H  
ATOM   1524  HD2 PHE A  99       9.294  12.883  20.988  1.00  0.00           H  
ATOM   1525  HE1 PHE A  99      14.212  12.830  20.725  1.00  0.00           H  
ATOM   1526  HE2 PHE A  99      10.454  12.955  18.767  1.00  0.00           H  
ATOM   1527  HZ  PHE A  99      12.889  12.845  18.682  1.00  0.00           H  
ATOM   1528  N   GLY A 100       9.114  11.441  26.055  1.00  0.00           N  
ATOM   1529  CA  GLY A 100       8.602  11.626  27.358  1.00  0.00           C  
ATOM   1530  C   GLY A 100       7.680  12.777  27.373  1.00  0.00           C  
ATOM   1531  O   GLY A 100       6.802  12.882  26.528  1.00  0.00           O  
ATOM   1532  H   GLY A 100       8.524  11.044  25.387  1.00  0.00           H  
ATOM   1533  HA2 GLY A 100       8.081  10.744  27.692  1.00  0.00           H  
ATOM   1534  HA3 GLY A 100       9.423  11.835  28.026  1.00  0.00           H  
ATOM   1535  N   ALA A 101       7.908  13.653  28.271  1.00  0.00           N  
ATOM   1536  CA  ALA A 101       7.126  14.846  28.413  1.00  0.00           C  
ATOM   1537  C   ALA A 101       7.492  15.823  27.315  1.00  0.00           C  
ATOM   1538  O   ALA A 101       6.632  16.310  26.596  1.00  0.00           O  
ATOM   1539  CB  ALA A 101       7.377  15.459  29.773  1.00  0.00           C  
ATOM   1540  H   ALA A 101       8.663  13.493  28.872  1.00  0.00           H  
ATOM   1541  HA  ALA A 101       6.073  14.620  28.323  1.00  0.00           H  
ATOM   1542  HB1 ALA A 101       7.062  14.763  30.535  1.00  0.00           H  
ATOM   1543  HB2 ALA A 101       6.841  16.391  29.862  1.00  0.00           H  
ATOM   1544  HB3 ALA A 101       8.435  15.645  29.878  1.00  0.00           H  
ATOM   1545  N   VAL A 102       8.773  16.072  27.160  1.00  0.00           N  
ATOM   1546  CA  VAL A 102       9.254  16.997  26.180  1.00  0.00           C  
ATOM   1547  C   VAL A 102      10.091  16.329  25.124  1.00  0.00           C  
ATOM   1548  O   VAL A 102      10.781  15.328  25.385  1.00  0.00           O  
ATOM   1549  CB  VAL A 102      10.041  18.158  26.779  1.00  0.00           C  
ATOM   1550  CG1 VAL A 102       9.138  19.298  27.157  1.00  0.00           C  
ATOM   1551  CG2 VAL A 102      10.859  17.709  27.983  1.00  0.00           C  
ATOM   1552  H   VAL A 102       9.443  15.615  27.706  1.00  0.00           H  
ATOM   1553  HA  VAL A 102       8.379  17.391  25.685  1.00  0.00           H  
ATOM   1554  HB  VAL A 102      10.732  18.442  26.007  1.00  0.00           H  
ATOM   1555 HG11 VAL A 102       8.381  18.958  27.847  1.00  0.00           H  
ATOM   1556 HG12 VAL A 102       8.689  19.697  26.259  1.00  0.00           H  
ATOM   1557 HG13 VAL A 102       9.735  20.069  27.623  1.00  0.00           H  
ATOM   1558 HG21 VAL A 102      11.555  16.939  27.683  1.00  0.00           H  
ATOM   1559 HG22 VAL A 102      10.196  17.318  28.741  1.00  0.00           H  
ATOM   1560 HG23 VAL A 102      11.402  18.552  28.383  1.00  0.00           H  
ATOM   1561  N   TYR A 103      10.053  16.916  23.958  1.00  0.00           N  
ATOM   1562  CA  TYR A 103      10.761  16.471  22.810  1.00  0.00           C  
ATOM   1563  C   TYR A 103      12.220  16.854  22.932  1.00  0.00           C  
ATOM   1564  O   TYR A 103      12.584  18.035  22.914  1.00  0.00           O  
ATOM   1565  CB  TYR A 103      10.085  17.031  21.535  1.00  0.00           C  
ATOM   1566  CG  TYR A 103      10.933  17.056  20.281  1.00  0.00           C  
ATOM   1567  CD1 TYR A 103      11.747  16.014  19.943  1.00  0.00           C  
ATOM   1568  CD2 TYR A 103      10.911  18.148  19.453  1.00  0.00           C  
ATOM   1569  CE1 TYR A 103      12.537  16.052  18.827  1.00  0.00           C  
ATOM   1570  CE2 TYR A 103      11.685  18.197  18.321  1.00  0.00           C  
ATOM   1571  CZ  TYR A 103      12.502  17.154  18.015  1.00  0.00           C  
ATOM   1572  OH  TYR A 103      13.313  17.224  16.895  1.00  0.00           O  
ATOM   1573  H   TYR A 103       9.536  17.746  23.865  1.00  0.00           H  
ATOM   1574  HA  TYR A 103      10.677  15.395  22.808  1.00  0.00           H  
ATOM   1575  HB2 TYR A 103       9.208  16.438  21.315  1.00  0.00           H  
ATOM   1576  HB3 TYR A 103       9.771  18.040  21.749  1.00  0.00           H  
ATOM   1577  HD1 TYR A 103      11.777  15.148  20.586  1.00  0.00           H  
ATOM   1578  HD2 TYR A 103      10.261  18.967  19.711  1.00  0.00           H  
ATOM   1579  HE1 TYR A 103      13.148  15.187  18.607  1.00  0.00           H  
ATOM   1580  HE2 TYR A 103      11.638  19.045  17.656  1.00  0.00           H  
ATOM   1581  HH  TYR A 103      13.693  18.109  16.874  1.00  0.00           H  
ATOM   1582  N   LYS A 104      13.027  15.849  23.084  1.00  0.00           N  
ATOM   1583  CA  LYS A 104      14.434  15.995  23.223  1.00  0.00           C  
ATOM   1584  C   LYS A 104      15.190  15.184  22.144  1.00  0.00           C  
ATOM   1585  O   LYS A 104      15.515  14.015  22.332  1.00  0.00           O  
ATOM   1586  CB  LYS A 104      14.831  15.611  24.634  1.00  0.00           C  
ATOM   1587  CG  LYS A 104      14.316  14.259  25.098  1.00  0.00           C  
ATOM   1588  CD  LYS A 104      14.696  14.023  26.531  1.00  0.00           C  
ATOM   1589  CE  LYS A 104      13.910  14.920  27.473  1.00  0.00           C  
ATOM   1590  NZ  LYS A 104      12.501  14.530  27.539  1.00  0.00           N  
ATOM   1591  H   LYS A 104      12.673  14.936  23.114  1.00  0.00           H  
ATOM   1592  HA  LYS A 104      14.651  17.043  23.088  1.00  0.00           H  
ATOM   1593  HB2 LYS A 104      15.906  15.584  24.689  1.00  0.00           H  
ATOM   1594  HB3 LYS A 104      14.444  16.374  25.293  1.00  0.00           H  
ATOM   1595  HG2 LYS A 104      13.238  14.248  25.010  1.00  0.00           H  
ATOM   1596  HG3 LYS A 104      14.739  13.485  24.475  1.00  0.00           H  
ATOM   1597  HD2 LYS A 104      14.519  12.987  26.781  1.00  0.00           H  
ATOM   1598  HD3 LYS A 104      15.747  14.255  26.620  1.00  0.00           H  
ATOM   1599  HE2 LYS A 104      14.330  14.870  28.465  1.00  0.00           H  
ATOM   1600  HE3 LYS A 104      13.954  15.941  27.121  1.00  0.00           H  
ATOM   1601  HZ1 LYS A 104      12.003  14.638  26.631  1.00  0.00           H  
ATOM   1602  HZ2 LYS A 104      12.012  15.068  28.281  1.00  0.00           H  
ATOM   1603  HZ3 LYS A 104      12.425  13.531  27.823  1.00  0.00           H  
ATOM   1604  N   PRO A 105      15.422  15.803  20.978  1.00  0.00           N  
ATOM   1605  CA  PRO A 105      16.041  15.143  19.805  1.00  0.00           C  
ATOM   1606  C   PRO A 105      17.480  14.696  20.058  1.00  0.00           C  
ATOM   1607  O   PRO A 105      17.962  13.750  19.460  1.00  0.00           O  
ATOM   1608  CB  PRO A 105      15.999  16.212  18.727  1.00  0.00           C  
ATOM   1609  CG  PRO A 105      15.864  17.485  19.460  1.00  0.00           C  
ATOM   1610  CD  PRO A 105      15.107  17.202  20.709  1.00  0.00           C  
ATOM   1611  HA  PRO A 105      15.458  14.291  19.491  1.00  0.00           H  
ATOM   1612  HB2 PRO A 105      16.916  16.183  18.156  1.00  0.00           H  
ATOM   1613  HB3 PRO A 105      15.156  16.043  18.073  1.00  0.00           H  
ATOM   1614  HG2 PRO A 105      16.849  17.815  19.734  1.00  0.00           H  
ATOM   1615  HG3 PRO A 105      15.331  18.199  18.853  1.00  0.00           H  
ATOM   1616  HD2 PRO A 105      15.485  17.832  21.498  1.00  0.00           H  
ATOM   1617  HD3 PRO A 105      14.038  17.343  20.605  1.00  0.00           H  
ATOM   1618  N   LYS A 106      18.173  15.399  20.923  1.00  0.00           N  
ATOM   1619  CA  LYS A 106      19.522  14.993  21.337  1.00  0.00           C  
ATOM   1620  C   LYS A 106      19.519  13.708  22.165  1.00  0.00           C  
ATOM   1621  O   LYS A 106      20.578  13.202  22.563  1.00  0.00           O  
ATOM   1622  CB  LYS A 106      20.259  16.109  22.091  1.00  0.00           C  
ATOM   1623  CG  LYS A 106      20.789  17.259  21.227  1.00  0.00           C  
ATOM   1624  CD  LYS A 106      19.711  18.135  20.612  1.00  0.00           C  
ATOM   1625  CE  LYS A 106      20.354  19.234  19.785  1.00  0.00           C  
ATOM   1626  NZ  LYS A 106      19.382  20.200  19.261  1.00  0.00           N  
ATOM   1627  H   LYS A 106      17.831  16.280  21.170  1.00  0.00           H  
ATOM   1628  HA  LYS A 106      20.082  14.774  20.439  1.00  0.00           H  
ATOM   1629  HB2 LYS A 106      19.596  16.528  22.833  1.00  0.00           H  
ATOM   1630  HB3 LYS A 106      21.097  15.662  22.604  1.00  0.00           H  
ATOM   1631  HG2 LYS A 106      21.406  17.894  21.843  1.00  0.00           H  
ATOM   1632  HG3 LYS A 106      21.396  16.843  20.437  1.00  0.00           H  
ATOM   1633  HD2 LYS A 106      19.082  17.530  19.975  1.00  0.00           H  
ATOM   1634  HD3 LYS A 106      19.119  18.583  21.397  1.00  0.00           H  
ATOM   1635  HE2 LYS A 106      21.054  19.764  20.412  1.00  0.00           H  
ATOM   1636  HE3 LYS A 106      20.884  18.782  18.961  1.00  0.00           H  
ATOM   1637  HZ1 LYS A 106      18.686  19.752  18.633  1.00  0.00           H  
ATOM   1638  HZ2 LYS A 106      19.870  20.971  18.765  1.00  0.00           H  
ATOM   1639  HZ3 LYS A 106      18.869  20.644  20.050  1.00  0.00           H  
ATOM   1640  N   GLU A 107      18.340  13.208  22.439  1.00  0.00           N  
ATOM   1641  CA  GLU A 107      18.153  11.966  23.134  1.00  0.00           C  
ATOM   1642  C   GLU A 107      17.204  11.079  22.330  1.00  0.00           C  
ATOM   1643  O   GLU A 107      16.598  10.135  22.846  1.00  0.00           O  
ATOM   1644  CB  GLU A 107      17.637  12.237  24.538  1.00  0.00           C  
ATOM   1645  CG  GLU A 107      18.653  12.975  25.396  1.00  0.00           C  
ATOM   1646  CD  GLU A 107      18.163  13.290  26.769  1.00  0.00           C  
ATOM   1647  OE1 GLU A 107      18.003  12.367  27.579  1.00  0.00           O  
ATOM   1648  OE2 GLU A 107      17.952  14.475  27.078  1.00  0.00           O  
ATOM   1649  H   GLU A 107      17.537  13.704  22.166  1.00  0.00           H  
ATOM   1650  HA  GLU A 107      19.116  11.480  23.191  1.00  0.00           H  
ATOM   1651  HB2 GLU A 107      16.745  12.841  24.465  1.00  0.00           H  
ATOM   1652  HB3 GLU A 107      17.394  11.299  25.013  1.00  0.00           H  
ATOM   1653  HG2 GLU A 107      19.539  12.365  25.483  1.00  0.00           H  
ATOM   1654  HG3 GLU A 107      18.913  13.897  24.897  1.00  0.00           H  
ATOM   1655  N   ASP A 108      17.125  11.374  21.041  1.00  0.00           N  
ATOM   1656  CA  ASP A 108      16.318  10.648  20.105  1.00  0.00           C  
ATOM   1657  C   ASP A 108      17.056   9.359  19.674  1.00  0.00           C  
ATOM   1658  O   ASP A 108      18.225   9.159  20.015  1.00  0.00           O  
ATOM   1659  CB  ASP A 108      16.037  11.552  18.888  1.00  0.00           C  
ATOM   1660  CG  ASP A 108      15.452  10.841  17.751  1.00  0.00           C  
ATOM   1661  OD1 ASP A 108      14.387  10.282  17.894  1.00  0.00           O  
ATOM   1662  OD2 ASP A 108      16.083  10.757  16.720  1.00  0.00           O  
ATOM   1663  H   ASP A 108      17.668  12.097  20.666  1.00  0.00           H  
ATOM   1664  HA  ASP A 108      15.370  10.434  20.581  1.00  0.00           H  
ATOM   1665  HB2 ASP A 108      15.287  12.277  19.163  1.00  0.00           H  
ATOM   1666  HB3 ASP A 108      16.940  12.049  18.570  1.00  0.00           H  
ATOM   1667  N   THR A 109      16.381   8.507  18.948  1.00  0.00           N  
ATOM   1668  CA  THR A 109      16.918   7.273  18.443  1.00  0.00           C  
ATOM   1669  C   THR A 109      17.913   7.538  17.269  1.00  0.00           C  
ATOM   1670  O   THR A 109      18.653   6.641  16.852  1.00  0.00           O  
ATOM   1671  CB  THR A 109      15.748   6.361  17.988  1.00  0.00           C  
ATOM   1672  OG1 THR A 109      16.229   5.094  17.496  1.00  0.00           O  
ATOM   1673  CG2 THR A 109      14.907   7.063  16.927  1.00  0.00           C  
ATOM   1674  H   THR A 109      15.461   8.763  18.709  1.00  0.00           H  
ATOM   1675  HA  THR A 109      17.445   6.782  19.246  1.00  0.00           H  
ATOM   1676  HB  THR A 109      15.126   6.170  18.849  1.00  0.00           H  
ATOM   1677  HG1 THR A 109      17.175   5.186  17.307  1.00  0.00           H  
ATOM   1678 HG21 THR A 109      14.558   8.000  17.341  1.00  0.00           H  
ATOM   1679 HG22 THR A 109      14.065   6.448  16.645  1.00  0.00           H  
ATOM   1680 HG23 THR A 109      15.526   7.269  16.068  1.00  0.00           H  
TER    1681      THR A 109                                                      
END
MOLECULE T0443_31_96.pdb
ATOM      1  N   LEU    31      17.573  12.561  -4.844  1.00 44.52           N  
ATOM      2  CA  LEU    31      16.276  12.957  -4.211  1.00 43.54           C  
ATOM      3  C   LEU    31      15.334  13.605  -5.268  1.00 43.20           C  
ATOM      4  O   LEU    31      15.322  14.825  -5.467  1.00 43.85           O  
ATOM      5  CB  LEU    31      16.564  13.888  -3.031  1.00 44.76           C  
ATOM      6  CG  LEU    31      15.563  13.836  -1.877  1.00 45.52           C  
ATOM      7  CD1 LEU    31      16.076  14.602  -0.669  1.00 45.49           C  
ATOM      8  CD2 LEU    31      14.212  14.362  -2.329  1.00 46.09           C  
ATOM      9  N   ASN    32      14.528  12.772  -5.920  1.00 41.03           N  
ATOM     10  CA  ASN    32      13.645  13.222  -7.005  1.00 40.05           C  
ATOM     11  C   ASN    32      12.429  14.110  -6.613  1.00 38.84           C  
ATOM     12  O   ASN    32      12.146  14.344  -5.433  1.00 38.46           O  
ATOM     13  CB  ASN    32      13.254  12.027  -7.901  1.00 39.14           C  
ATOM     14  CG  ASN    32      12.441  10.973  -7.181  1.00 38.38           C  
ATOM     15  OD1 ASN    32      11.411  11.270  -6.598  1.00 37.94           O  
ATOM     16  ND2 ASN    32      12.869   9.722  -7.280  1.00 37.45           N  
ATOM     17  N   VAL    33      11.736  14.625  -7.619  1.00 37.57           N  
ATOM     18  CA  VAL    33      10.610  15.536  -7.400  1.00 37.88           C  
ATOM     19  C   VAL    33       9.437  14.879  -6.622  1.00 38.17           C  
ATOM     20  O   VAL    33       8.710  15.567  -5.895  1.00 37.81           O  
ATOM     21  CB  VAL    33      10.146  16.171  -8.752  1.00 37.94           C  
ATOM     22  CG1 VAL    33       9.582  15.124  -9.669  1.00 38.16           C  
ATOM     23  CG2 VAL    33       9.120  17.263  -8.531  1.00 38.67           C  
ATOM     24  N   TYR    34       9.279  13.557  -6.782  1.00 37.61           N  
ATOM     25  CA  TYR    34       8.266  12.775  -6.094  1.00 36.92           C  
ATOM     26  C   TYR    34       8.579  12.641  -4.591  1.00 36.39           C  
ATOM     27  O   TYR    34       7.687  12.801  -3.752  1.00 34.21           O  
ATOM     28  CB  TYR    34       8.075  11.388  -6.771  1.00 38.00           C  
ATOM     29  CG  TYR    34       7.128  10.484  -6.007  1.00 38.31           C  
ATOM     30  CD1 TYR    34       5.763  10.731  -6.001  1.00 38.37           C  
ATOM     31  CD2 TYR    34       7.603   9.409  -5.247  1.00 38.86           C  
ATOM     32  CE1 TYR    34       4.897   9.949  -5.275  1.00 38.25           C  
ATOM     33  CE2 TYR    34       6.723   8.608  -4.515  1.00 38.40           C  
ATOM     34  CZ  TYR    34       5.373   8.890  -4.541  1.00 38.20           C  
ATOM     35  OH  TYR    34       4.470   8.131  -3.816  1.00 38.57           O  
ATOM     36  N   ILE    35       9.843  12.364  -4.260  1.00 36.54           N  
ATOM     37  CA  ILE    35      10.288  12.240  -2.863  1.00 36.34           C  
ATOM     38  C   ILE    35      10.135  13.583  -2.136  1.00 36.17           C  
ATOM     39  O   ILE    35       9.784  13.613  -0.947  1.00 33.51           O  
ATOM     40  CB  ILE    35      11.752  11.733  -2.758  1.00 36.54           C  
ATOM     41  CG1 ILE    35      11.904  10.342  -3.389  1.00 37.22           C  
ATOM     42  CG2 ILE    35      12.213  11.660  -1.319  1.00 36.22           C  
ATOM     43  CD1 ILE    35      11.129   9.223  -2.697  1.00 37.21           C  
ATOM     44  N   ARG    36      10.384  14.682  -2.853  1.00 36.24           N  
ATOM     45  CA  ARG    36      10.229  16.021  -2.282  1.00 38.06           C  
ATOM     46  C   ARG    36       8.748  16.345  -2.052  1.00 37.48           C  
ATOM     47  O   ARG    36       8.398  16.972  -1.052  1.00 37.67           O  
ATOM     48  CB  ARG    36      10.871  17.107  -3.160  1.00 39.21           C  
ATOM     49  CG  ARG    36      12.394  17.179  -3.103  1.00 40.33           C  
ATOM     50  CD  ARG    36      12.932  18.438  -3.830  1.00 40.62           C  
ATOM     51  NE  ARG    36      14.375  18.634  -3.621  1.00 41.51           N  
ATOM     52  N   LEU    37       7.889  15.935  -2.986  1.00 36.32           N  
ATOM     53  CA  LEU    37       6.453  16.135  -2.845  1.00 35.88           C  
ATOM     54  C   LEU    37       5.916  15.380  -1.619  1.00 35.36           C  
ATOM     55  O   LEU    37       5.257  15.979  -0.779  1.00 34.58           O  
ATOM     56  CB  LEU    37       5.706  15.722  -4.133  1.00 35.78           C  
ATOM     57  CG  LEU    37       4.184  15.878  -4.172  1.00 35.65           C  
ATOM     58  CD1 LEU    37       3.787  17.308  -3.838  1.00 35.55           C  
ATOM     59  CD2 LEU    37       3.612  15.476  -5.538  1.00 35.55           C  
ATOM     60  N   ILE    38       6.220  14.087  -1.496  1.00 35.62           N  
ATOM     61  CA  ILE    38       5.716  13.300  -0.358  1.00 36.20           C  
ATOM     62  C   ILE    38       6.279  13.740   0.980  1.00 35.39           C  
ATOM     63  O   ILE    38       5.596  13.602   1.985  1.00 32.16           O  
ATOM     64  CB  ILE    38       5.862  11.741  -0.511  1.00 36.97           C  
ATOM     65  CG1 ILE    38       7.303  11.292  -0.676  1.00 37.64           C  
ATOM     66  CG2 ILE    38       5.047  11.239  -1.654  1.00 37.31           C  
ATOM     67  CD1 ILE    38       7.441   9.799  -1.046  1.00 37.85           C  
ATOM     68  N   ARG    39       7.516  14.251   1.004  1.00 35.25           N  
ATOM     69  CA  ARG    39       8.075  14.794   2.240  1.00 35.73           C  
ATOM     70  C   ARG    39       7.334  16.062   2.652  1.00 35.39           C  
ATOM     71  O   ARG    39       7.077  16.255   3.830  1.00 35.59           O  
ATOM     72  CB  ARG    39       9.586  15.035   2.153  1.00 36.43           C  
ATOM     73  CG  ARG    39      10.399  13.758   2.251  1.00 36.58           C  
ATOM     74  CD  ARG    39      11.892  14.023   2.215  1.00 37.77           C  
ATOM     75  NE  ARG    39      12.614  12.754   2.225  1.00 38.50           N  
ATOM     76  CZ  ARG    39      13.918  12.612   2.442  1.00 39.28           C  
ATOM     77  NH1 ARG    39      14.675  13.665   2.717  1.00 39.99           N  
ATOM     78  NH2 ARG    39      14.456  11.393   2.422  1.00 39.30           N  
ATOM     79  N   ASN    40       6.974  16.919   1.701  1.00 36.47           N  
ATOM     80  CA  ASN    40       6.147  18.102   2.036  1.00 37.87           C  
ATOM     81  C   ASN    40       4.726  17.728   2.520  1.00 36.33           C  
ATOM     82  O   ASN    40       4.179  18.387   3.394  1.00 36.31           O  
ATOM     83  CB  ASN    40       6.085  19.098   0.869  1.00 39.93           C  
ATOM     84  CG  ASN    40       7.362  19.912   0.735  1.00 41.61           C  
ATOM     85  OD1 ASN    40       8.083  20.134   1.718  1.00 43.85           O  
ATOM     86  ND2 ASN    40       7.649  20.366  -0.476  1.00 43.10           N  
ATOM     87  N   ASN    41       4.158  16.664   1.961  1.00 34.58           N  
ATOM     88  CA  ASN    41       2.842  16.183   2.368  1.00 34.12           C  
ATOM     89  C   ASN    41       2.913  15.549   3.749  1.00 33.10           C  
ATOM     90  O   ASN    41       1.945  15.575   4.474  1.00 32.27           O  
ATOM     91  CB  ASN    41       2.268  15.183   1.366  1.00 33.77           C  
ATOM     92  CG  ASN    41       1.945  15.805   0.030  1.00 33.71           C  
ATOM     93  OD1 ASN    41       2.195  17.001  -0.204  1.00 33.95           O  
ATOM     94  ND2 ASN    41       1.369  14.997  -0.866  1.00 32.28           N  
ATOM     95  N   ILE    42       4.072  14.993   4.101  1.00 33.48           N  
ATOM     96  CA  ILE    42       4.303  14.426   5.441  1.00 34.18           C  
ATOM     97  C   ILE    42       4.342  15.558   6.499  1.00 34.18           C  
ATOM     98  O   ILE    42       3.648  15.515   7.514  1.00 35.39           O  
ATOM     99  CB  ILE    42       5.594  13.538   5.461  1.00 33.79           C  
ATOM    100  CG1 ILE    42       5.329  12.238   4.687  1.00 34.00           C  
ATOM    101  CG2 ILE    42       6.026  13.205   6.893  1.00 33.13           C  
ATOM    102  CD1 ILE    42       6.466  11.222   4.689  1.00 34.19           C  
ATOM    103  N   HIS    43       5.149  16.568   6.237  1.00 35.51           N  
ATOM    104  CA  HIS    43       5.255  17.746   7.103  1.00 36.15           C  
ATOM    105  C   HIS    43       3.855  18.338   7.336  1.00 35.62           C  
ATOM    106  O   HIS    43       3.429  18.481   8.471  1.00 35.79           O  
ATOM    107  CB  HIS    43       6.215  18.782   6.479  1.00 37.26           C  
ATOM    108  CG  HIS    43       7.670  18.420   6.591  1.00 38.69           C  
ATOM    109  ND1 HIS    43       8.613  19.272   7.130  1.00 40.26           N  
ATOM    110  CD2 HIS    43       8.341  17.288   6.266  1.00 39.87           C  
ATOM    111  CE1 HIS    43       9.802  18.692   7.106  1.00 39.55           C  
ATOM    112  NE2 HIS    43       9.663  17.483   6.595  1.00 38.90           N  
ATOM    113  N   SER    44       3.126  18.615   6.257  1.00 34.74           N  
ATOM    114  CA  SER    44       1.788  19.203   6.325  1.00 34.39           C  
ATOM    115  C   SER    44       0.743  18.397   7.093  1.00 33.88           C  
ATOM    116  O   SER    44      -0.125  18.968   7.767  1.00 33.16           O  
ATOM    117  CB  SER    44       1.270  19.419   4.904  1.00 35.00           C  
ATOM    118  OG  SER    44       2.093  20.322   4.212  1.00 35.16           O  
ATOM    119  N   PHE    45       0.811  17.070   6.958  1.00 32.94           N  
ATOM    120  CA  PHE    45      -0.109  16.147   7.632  1.00 31.66           C  
ATOM    121  C   PHE    45       0.177  16.082   9.140  1.00 31.61           C  
ATOM    122  O   PHE    45      -0.750  16.119   9.963  1.00 30.31           O  
ATOM    123  CB  PHE    45       0.002  14.770   6.952  1.00 31.68           C  
ATOM    124  CG  PHE    45      -1.033  13.783   7.354  1.00 31.49           C  
ATOM    125  CD1 PHE    45      -2.238  14.163   7.952  1.00 32.31           C  
ATOM    126  CD2 PHE    45      -0.843  12.442   7.054  1.00 32.43           C  
ATOM    127  CE1 PHE    45      -3.200  13.211   8.299  1.00 32.72           C  
ATOM    128  CE2 PHE    45      -1.813  11.488   7.375  1.00 31.99           C  
ATOM    129  CZ  PHE    45      -2.991  11.877   8.005  1.00 32.00           C  
ATOM    130  N   ILE    46       1.458  15.962   9.493  1.00 30.96           N  
ATOM    131  CA  ILE    46       1.905  16.018  10.883  1.00 30.52           C  
ATOM    132  C   ILE    46       1.479  17.353  11.545  1.00 31.33           C  
ATOM    133  O   ILE    46       0.934  17.352  12.654  1.00 30.46           O  
ATOM    134  CB  ILE    46       3.453  15.778  10.976  1.00 30.24           C  
ATOM    135  CG1 ILE    46       3.761  14.284  10.784  1.00 29.75           C  
ATOM    136  CG2 ILE    46       4.049  16.323  12.284  1.00 28.54           C  
ATOM    137  CD1 ILE    46       5.233  14.026  10.605  1.00 30.42           C  
ATOM    138  N   ASP    47       1.700  18.483  10.874  1.00 32.29           N  
ATOM    139  CA  ASP    47       1.259  19.775  11.432  1.00 33.40           C  
ATOM    140  C   ASP    47      -0.249  19.769  11.718  1.00 34.76           C  
ATOM    141  O   ASP    47      -0.711  20.336  12.700  1.00 35.50           O  
ATOM    142  CB  ASP    47       1.567  20.954  10.495  1.00 33.10           C  
ATOM    143  CG  ASP    47       3.051  21.253  10.364  1.00 33.77           C  
ATOM    144  OD1 ASP    47       3.838  20.610  11.062  1.00 32.98           O  
ATOM    145  OD2 ASP    47       3.431  22.151   9.555  1.00 33.38           O  
ATOM    146  N   ARG    48      -1.011  19.137  10.842  1.00 36.67           N  
ATOM    147  CA  ARG    48      -2.471  19.075  10.991  1.00 38.26           C  
ATOM    148  C   ARG    48      -2.949  18.137  12.107  1.00 36.84           C  
ATOM    149  O   ARG    48      -3.879  18.476  12.833  1.00 36.39           O  
ATOM    150  CB  ARG    48      -3.131  18.760   9.638  1.00 38.90           C  
ATOM    151  CG  ARG    48      -3.001  19.956   8.648  1.00 40.27           C  
ATOM    152  CD  ARG    48      -3.502  19.648   7.238  1.00 41.33           C  
ATOM    153  NE  ARG    48      -3.830  20.897   6.526  1.00 42.67           N  
ATOM    154  CZ  ARG    48      -3.237  21.394   5.429  1.00 43.11           C  
ATOM    155  NH1 ARG    48      -2.255  20.752   4.765  1.00 43.47           N  
ATOM    156  NH2 ARG    48      -3.677  22.555   4.947  1.00 42.85           N  
ATOM    157  N   CYS    49      -2.312  16.978  12.247  1.00 35.74           N  
ATOM    158  CA  CYS    49      -2.692  16.011  13.265  0.50 35.05           C  
ATOM    160  C   CYS    49      -2.218  16.408  14.677  1.00 34.67           C  
ATOM    161  O   CYS    49      -2.892  16.146  15.648  1.00 34.22           O  
ATOM    162  CB  CYS    49      -2.126  14.645  12.891  0.50 34.91           C  
ATOM    164  SG  CYS    49      -2.601  13.326  14.001  0.50 35.32           S  
ATOM    166  N   TYR    50      -1.063  17.058  14.775  1.00 35.09           N  
ATOM    167  CA  TYR    50      -0.494  17.396  16.080  1.00 33.36           C  
ATOM    168  C   TYR    50      -0.430  18.881  16.384  1.00 33.94           C  
ATOM    169  O   TYR    50       0.615  19.402  16.813  1.00 32.29           O  
ATOM    170  CB  TYR    50       0.873  16.729  16.193  1.00 30.87           C  
ATOM    171  CG  TYR    50       0.785  15.191  16.130  1.00 30.70           C  
ATOM    172  CD1 TYR    50       0.368  14.444  17.224  1.00 29.65           C  
ATOM    173  CD2 TYR    50       1.122  14.505  14.979  1.00 29.84           C  
ATOM    174  CE1 TYR    50       0.300  13.036  17.160  1.00 30.64           C  
ATOM    175  CE2 TYR    50       1.067  13.125  14.914  1.00 30.22           C  
ATOM    176  CZ  TYR    50       0.657  12.387  16.003  1.00 30.31           C  
ATOM    177  OH  TYR    50       0.616  11.003  15.910  1.00 30.32           O  
ATOM    178  N   THR    51      -1.587  19.532  16.227  1.00 34.38           N  
ATOM    179  CA  THR    51      -1.742  20.985  16.448  1.00 35.46           C  
ATOM    180  C   THR    51      -1.497  21.472  17.885  1.00 35.45           C  
ATOM    181  O   THR    51      -0.948  22.564  18.068  1.00 35.69           O  
ATOM    182  CB  THR    51      -3.129  21.474  15.967  1.00 36.40           C  
ATOM    183  OG1 THR    51      -4.121  20.496  16.344  1.00 36.73           O  
ATOM    184  CG2 THR    51      -3.136  21.638  14.446  1.00 36.23           C  
ATOM    185  N   GLU    52      -1.910  20.685  18.886  1.00 35.22           N  
ATOM    186  CA  GLU    52      -1.650  21.027  20.297  1.00 35.46           C  
ATOM    187  C   GLU    52      -0.168  20.764  20.634  1.00 33.96           C  
ATOM    188  O   GLU    52       0.519  21.638  21.119  1.00 33.70           O  
ATOM    189  CB  GLU    52      -2.557  20.253  21.259  1.00 36.10           C  
ATOM    190  CG  GLU    52      -4.049  20.464  21.051  1.00 37.71           C  
ATOM    191  CD  GLU    52      -4.491  21.909  21.293  1.00 39.84           C  
ATOM    192  OE1 GLU    52      -3.813  22.624  22.080  1.00 39.57           O  
ATOM    193  OE2 GLU    52      -5.533  22.317  20.703  1.00 41.37           O  
ATOM    194  N   THR    53       0.314  19.561  20.359  1.00 33.44           N  
ATOM    195  CA  THR    53       1.717  19.215  20.623  1.00 33.65           C  
ATOM    196  C   THR    53       2.652  20.270  20.032  1.00 35.50           C  
ATOM    197  O   THR    53       3.551  20.752  20.716  1.00 36.21           O  
ATOM    198  CB  THR    53       2.055  17.799  20.061  1.00 32.37           C  
ATOM    199  OG1 THR    53       1.103  16.860  20.555  1.00 28.94           O  
ATOM    200  CG2 THR    53       3.457  17.348  20.430  1.00 31.86           C  
ATOM    201  N   ARG    54       2.399  20.661  18.779  1.00 37.65           N  
ATOM    202  CA  ARG    54       3.207  21.652  18.062  1.00 38.57           C  
ATOM    203  C   ARG    54       3.445  22.944  18.847  1.00 39.99           C  
ATOM    204  O   ARG    54       4.480  23.581  18.707  1.00 38.14           O  
ATOM    205  N   GLN    55       2.475  23.311  19.677  1.00 41.69           N  
ATOM    206  CA  GLN    55       2.568  24.516  20.510  1.00 42.42           C  
ATOM    207  C   GLN    55       3.557  24.436  21.671  1.00 41.81           C  
ATOM    208  O   GLN    55       3.893  25.458  22.249  1.00 42.84           O  
ATOM    209  CB  GLN    55       1.183  24.930  21.012  1.00 42.92           C  
ATOM    210  CG  GLN    55       0.360  25.547  19.897  1.00 43.71           C  
ATOM    211  CD  GLN    55      -1.083  25.734  20.269  1.00 43.68           C  
ATOM    212  OE1 GLN    55      -1.779  24.780  20.626  1.00 44.23           O  
ATOM    213  NE2 GLN    55      -1.560  26.971  20.157  1.00 44.84           N  
ATOM    214  N   TYR    56       4.044  23.246  22.001  1.00 40.40           N  
ATOM    215  CA  TYR    56       5.030  23.112  23.077  1.00 39.48           C  
ATOM    216  C   TYR    56       6.439  23.213  22.534  1.00 38.45           C  
ATOM    217  O   TYR    56       7.402  23.108  23.278  1.00 37.75           O  
ATOM    218  CB  TYR    56       4.824  21.797  23.847  1.00 39.65           C  
ATOM    219  CG  TYR    56       3.604  21.840  24.727  1.00 39.51           C  
ATOM    220  CD1 TYR    56       2.355  21.497  24.231  1.00 39.63           C  
ATOM    221  CD2 TYR    56       3.696  22.253  26.052  1.00 39.81           C  
ATOM    222  CE1 TYR    56       1.227  21.541  25.030  1.00 40.29           C  
ATOM    223  CE2 TYR    56       2.564  22.307  26.874  1.00 39.69           C  
ATOM    224  CZ  TYR    56       1.339  21.957  26.356  1.00 39.71           C  
ATOM    225  OH  TYR    56       0.225  22.012  27.144  1.00 40.05           O  
ATOM    226  N   PHE    57       6.555  23.413  21.225  1.00 38.66           N  
ATOM    227  CA  PHE    57       7.840  23.551  20.595  1.00 38.68           C  
ATOM    228  C   PHE    57       7.989  24.877  19.837  1.00 39.20           C  
ATOM    229  O   PHE    57       7.023  25.580  19.531  1.00 38.81           O  
ATOM    230  CB  PHE    57       8.104  22.384  19.641  1.00 38.40           C  
ATOM    231  CG  PHE    57       8.050  21.042  20.301  1.00 38.59           C  
ATOM    232  CD1 PHE    57       9.195  20.487  20.870  1.00 38.43           C  
ATOM    233  CD2 PHE    57       6.868  20.320  20.343  1.00 38.43           C  
ATOM    234  CE1 PHE    57       9.148  19.242  21.488  1.00 38.66           C  
ATOM    235  CE2 PHE    57       6.822  19.067  20.963  1.00 38.81           C  
ATOM    236  CZ  PHE    57       7.960  18.530  21.526  1.00 38.33           C  
ATOM    237  N   ASP    58       9.249  25.178  19.569  1.00 39.49           N  
ATOM    238  CA  ASP    58       9.687  26.319  18.807  1.00 40.80           C  
ATOM    239  C   ASP    58       9.550  25.947  17.313  1.00 40.39           C  
ATOM    240  O   ASP    58       9.426  24.771  16.978  1.00 40.16           O  
ATOM    241  CB  ASP    58      11.164  26.534  19.150  1.00 41.80           C  
ATOM    242  CG  ASP    58      11.700  27.811  18.641  1.00 43.01           C  
ATOM    243  OD1 ASP    58      11.321  28.852  19.212  1.00 44.51           O  
ATOM    244  OD2 ASP    58      12.537  27.773  17.706  1.00 44.59           O  
ATOM    245  N   SER    59       9.598  26.939  16.423  1.00 40.58           N  
ATOM    246  CA  SER    59       9.544  26.696  14.972  1.00 40.21           C  
ATOM    247  C   SER    59      10.682  25.764  14.572  1.00 39.44           C  
ATOM    248  O   SER    59      10.452  24.739  13.919  1.00 38.38           O  
ATOM    249  CB  SER    59       9.709  28.003  14.200  1.00 40.59           C  
ATOM    250  OG  SER    59       9.024  29.054  14.842  1.00 41.19           O  
ATOM    251  N   LYS    60      11.898  26.117  15.007  1.00 39.20           N  
ATOM    252  CA  LYS    60      13.120  25.345  14.703  1.00 38.68           C  
ATOM    253  C   LYS    60      13.118  23.946  15.315  1.00 37.27           C  
ATOM    254  O   LYS    60      13.531  22.993  14.667  1.00 36.60           O  
ATOM    255  CB  LYS    60      14.383  26.099  15.151  1.00 39.13           C  
ATOM    256  CG  LYS    60      14.720  27.325  14.305  1.00 40.06           C  
ATOM    257  N   GLU    61      12.669  23.840  16.560  1.00 36.56           N  
ATOM    258  CA  GLU    61      12.586  22.563  17.268  1.00 37.10           C  
ATOM    259  C   GLU    61      11.598  21.610  16.586  1.00 36.59           C  
ATOM    260  O   GLU    61      11.863  20.415  16.428  1.00 36.60           O  
ATOM    261  CB  GLU    61      12.118  22.786  18.718  1.00 37.52           C  
ATOM    262  CG  GLU    61      13.033  23.614  19.614  1.00 38.05           C  
ATOM    263  CD  GLU    61      12.376  24.015  20.948  1.00 38.16           C  
ATOM    264  OE1 GLU    61      11.137  23.965  21.074  1.00 38.70           O  
ATOM    265  OE2 GLU    61      13.100  24.403  21.875  1.00 39.54           O  
ATOM    266  N   TRP    62      10.433  22.147  16.229  1.00 36.46           N  
ATOM    267  CA  TRP    62       9.401  21.386  15.547  1.00 36.63           C  
ATOM    268  C   TRP    62       9.892  20.915  14.161  1.00 36.33           C  
ATOM    269  O   TRP    62       9.733  19.743  13.817  1.00 35.34           O  
ATOM    270  CB  TRP    62       8.111  22.213  15.453  1.00 37.24           C  
ATOM    271  CG  TRP    62       6.932  21.469  14.891  1.00 37.24           C  
ATOM    272  CD1 TRP    62       6.334  21.691  13.702  1.00 37.51           C  
ATOM    273  CD2 TRP    62       6.219  20.376  15.506  1.00 37.80           C  
ATOM    274  NE1 TRP    62       5.285  20.818  13.525  1.00 37.79           N  
ATOM    275  CE2 TRP    62       5.194  19.995  14.614  1.00 37.74           C  
ATOM    276  CE3 TRP    62       6.352  19.683  16.720  1.00 37.51           C  
ATOM    277  CZ2 TRP    62       4.303  18.950  14.888  1.00 37.23           C  
ATOM    278  CZ3 TRP    62       5.479  18.647  16.992  1.00 37.58           C  
ATOM    279  CH2 TRP    62       4.459  18.288  16.076  1.00 37.52           C  
ATOM    280  N   SER    63      10.493  21.804  13.376  1.00 36.51           N  
ATOM    281  CA  SER    63      11.074  21.408  12.076  1.00 37.30           C  
ATOM    282  C   SER    63      12.163  20.307  12.223  1.00 37.53           C  
ATOM    283  O   SER    63      12.237  19.371  11.411  1.00 37.00           O  
ATOM    284  CB  SER    63      11.694  22.614  11.373  1.00 38.30           C  
ATOM    285  OG  SER    63      10.782  23.692  11.249  1.00 38.42           O  
ATOM    286  N   ARG    64      13.007  20.424  13.251  1.00 37.53           N  
ATOM    287  CA  ARG    64      14.038  19.412  13.517  1.00 37.52           C  
ATOM    288  C   ARG    64      13.444  18.039  13.756  1.00 37.48           C  
ATOM    289  O   ARG    64      13.940  17.056  13.228  1.00 37.42           O  
ATOM    290  CB  ARG    64      14.865  19.779  14.736  1.00 38.25           C  
ATOM    291  CG  ARG    64      15.668  21.020  14.585  1.00 38.50           C  
ATOM    292  CD  ARG    64      16.597  21.216  15.768  1.00 38.90           C  
ATOM    293  NE  ARG    64      17.124  22.568  15.726  1.00 39.25           N  
ATOM    294  CZ  ARG    64      16.975  23.495  16.661  1.00 39.76           C  
ATOM    295  NH1 ARG    64      16.388  23.227  17.826  1.00 40.58           N  
ATOM    296  NH2 ARG    64      17.496  24.698  16.449  1.00 40.34           N  
ATOM    297  N   LEU    65      12.396  17.969  14.584  1.00 38.01           N  
ATOM    298  CA  LEU    65      11.692  16.704  14.829  1.00 37.24           C  
ATOM    299  C   LEU    65      11.258  16.049  13.538  1.00 36.38           C  
ATOM    300  O   LEU    65      11.483  14.868  13.335  1.00 35.33           O  
ATOM    301  CB  LEU    65      10.460  16.895  15.732  1.00 37.31           C  
ATOM    302  CG  LEU    65      10.599  16.691  17.233  1.00 37.54           C  
ATOM    303  CD1 LEU    65       9.326  17.170  17.945  1.00 37.07           C  
ATOM    304  CD2 LEU    65      10.877  15.205  17.515  1.00 37.77           C  
ATOM    305  N   LYS    66      10.624  16.843  12.680  1.00 37.70           N  
ATOM    306  CA  LYS    66      10.108  16.406  11.382  1.00 37.64           C  
ATOM    307  C   LYS    66      11.188  16.018  10.374  1.00 38.01           C  
ATOM    308  O   LYS    66      10.989  15.080   9.570  1.00 37.34           O  
ATOM    309  CB  LYS    66       9.358  17.543  10.731  1.00 38.09           C  
ATOM    310  CG  LYS    66       7.972  17.860  11.209  1.00 39.27           C  
ATOM    311  CD  LYS    66       7.732  19.208  10.593  1.00 39.88           C  
ATOM    312  CE  LYS    66       6.376  19.665  10.584  1.00 40.20           C  
ATOM    313  NZ  LYS    66       6.469  21.084  10.090  1.00 40.11           N  
ATOM    314  N   GLU    67      12.273  16.793  10.341  1.00 37.69           N  
ATOM    315  CA  GLU    67      13.385  16.486   9.438  1.00 38.36           C  
ATOM    316  C   GLU    67      13.988  15.146   9.831  1.00 37.23           C  
ATOM    317  O   GLU    67      14.392  14.383   8.975  1.00 38.39           O  
ATOM    318  CB  GLU    67      14.461  17.582   9.439  1.00 40.22           C  
ATOM    319  CG  GLU    67      14.046  18.891   8.735  1.00 42.62           C  
ATOM    320  CD  GLU    67      13.709  18.696   7.245  1.00 44.55           C  
ATOM    321  OE1 GLU    67      14.081  17.641   6.674  1.00 45.14           O  
ATOM    322  OE2 GLU    67      13.063  19.598   6.648  1.00 45.94           O  
ATOM    323  N   GLY    68      14.034  14.860  11.128  1.00 36.08           N  
ATOM    324  CA  GLY    68      14.533  13.589  11.606  1.00 34.73           C  
ATOM    325  C   GLY    68      13.596  12.474  11.209  1.00 34.19           C  
ATOM    326  O   GLY    68      14.033  11.445  10.724  1.00 35.37           O  
ATOM    327  N   PHE    69      12.293  12.660  11.404  1.00 34.14           N  
ATOM    328  CA  PHE    69      11.337  11.622  11.016  1.00 32.94           C  
ATOM    329  C   PHE    69      11.440  11.264   9.516  1.00 33.21           C  
ATOM    330  O   PHE    69      11.539  10.090   9.139  1.00 33.26           O  
ATOM    331  CB  PHE    69       9.895  12.022  11.386  1.00 31.51           C  
ATOM    332  CG  PHE    69       8.870  11.040  10.920  1.00 30.14           C  
ATOM    333  CD1 PHE    69       8.871   9.741  11.402  1.00 30.28           C  
ATOM    334  CD2 PHE    69       7.921  11.398   9.993  1.00 31.00           C  
ATOM    335  CE1 PHE    69       7.939   8.802  10.963  1.00 29.64           C  
ATOM    336  CE2 PHE    69       6.975  10.480   9.560  1.00 30.27           C  
ATOM    337  CZ  PHE    69       6.984   9.174  10.049  1.00 30.55           C  
ATOM    338  N   VAL    70      11.447  12.287   8.678  1.00 34.13           N  
ATOM    339  CA  VAL    70      11.508  12.140   7.223  1.00 35.69           C  
ATOM    340  C   VAL    70      12.739  11.371   6.690  1.00 37.01           C  
ATOM    341  O   VAL    70      12.674  10.692   5.633  1.00 36.42           O  
ATOM    342  CB  VAL    70      11.400  13.534   6.590  1.00 36.04           C  
ATOM    343  CG1 VAL    70      12.194  13.615   5.360  1.00 37.99           C  
ATOM    344  CG2 VAL    70       9.930  13.898   6.375  1.00 36.51           C  
ATOM    345  N   ARG    71      13.834  11.481   7.445  1.00 38.47           N  
ATOM    346  CA  ARG    71      15.089  10.810   7.164  1.00 39.55           C  
ATOM    347  C   ARG    71      15.125   9.421   7.825  1.00 40.19           C  
ATOM    348  O   ARG    71      16.049   8.645   7.584  1.00 41.19           O  
ATOM    349  CB  ARG    71      16.255  11.677   7.654  1.00 39.14           C  
ATOM    350  CG  ARG    71      16.354  13.038   6.934  1.00 39.56           C  
ATOM    351  CD  ARG    71      17.481  13.925   7.506  1.00 39.89           C  
ATOM    352  N   ASP    72      14.121   9.108   8.644  1.00 39.78           N  
ATOM    353  CA  ASP    72      14.038   7.814   9.335  1.00 39.54           C  
ATOM    354  C   ASP    72      13.268   6.793   8.485  1.00 39.00           C  
ATOM    355  O   ASP    72      12.421   7.170   7.701  1.00 38.39           O  
ATOM    356  CB  ASP    72      13.311   7.978  10.674  1.00 39.70           C  
ATOM    357  CG  ASP    72      13.405   6.751  11.544  1.00 39.57           C  
ATOM    358  OD1 ASP    72      14.490   6.519  12.112  1.00 41.05           O  
ATOM    359  OD2 ASP    72      12.394   6.044  11.691  1.00 38.99           O  
ATOM    360  N   ALA    73      13.565   5.506   8.700  1.00 39.88           N  
ATOM    361  CA  ALA    73      12.956   4.358   8.012  1.00 39.58           C  
ATOM    362  C   ALA    73      11.435   4.259   8.161  1.00 40.30           C  
ATOM    363  O   ALA    73      10.778   3.676   7.299  1.00 40.44           O  
ATOM    364  CB  ALA    73      13.602   3.052   8.497  1.00 38.45           C  
ATOM    365  N   ARG    74      10.887   4.785   9.258  1.00 41.15           N  
ATOM    366  CA  ARG    74       9.435   4.766   9.482  1.00 42.13           C  
ATOM    367  C   ARG    74       8.662   5.661   8.471  1.00 42.62           C  
ATOM    368  O   ARG    74       7.507   5.372   8.134  1.00 43.50           O  
ATOM    369  CB  ARG    74       9.093   5.167  10.927  1.00 42.17           C  
ATOM    370  CG  ARG    74       9.608   4.220  12.028  1.00 42.15           C  
ATOM    371  CD  ARG    74       9.162   4.710  13.414  1.00 42.78           C  
ATOM    372  NE  ARG    74       9.772   3.984  14.530  1.00 42.91           N  
ATOM    373  CZ  ARG    74      10.943   4.291  15.103  1.00 44.13           C  
ATOM    374  NH1 ARG    74      11.666   5.334  14.687  1.00 44.51           N  
ATOM    375  NH2 ARG    74      11.405   3.554  16.116  1.00 43.91           N  
ATOM    376  N   ALA    75       9.310   6.718   7.980  1.00 41.86           N  
ATOM    377  CA  ALA    75       8.706   7.632   7.020  1.00 41.40           C  
ATOM    378  C   ALA    75       8.813   7.115   5.574  1.00 41.62           C  
ATOM    379  O   ALA    75       8.490   7.834   4.645  1.00 41.03           O  
ATOM    380  CB  ALA    75       9.360   9.012   7.138  1.00 40.41           C  
ATOM    381  N   GLN    76       9.271   5.876   5.385  1.00 42.77           N  
ATOM    382  CA  GLN    76       9.394   5.270   4.046  1.00 43.01           C  
ATOM    383  C   GLN    76       8.172   4.430   3.693  1.00 41.84           C  
ATOM    384  O   GLN    76       8.153   3.750   2.677  1.00 41.81           O  
ATOM    385  CB  GLN    76      10.652   4.409   3.945  1.00 44.92           C  
ATOM    386  CG  GLN    76      11.922   5.115   4.407  1.00 46.84           C  
ATOM    387  CD  GLN    76      12.140   6.436   3.696  1.00 48.40           C  
ATOM    388  OE1 GLN    76      12.086   6.495   2.461  1.00 49.56           O  
ATOM    389  NE2 GLN    76      12.381   7.515   4.474  1.00 49.14           N  
ATOM    390  N   THR    77       7.147   4.478   4.533  1.00 40.41           N  
ATOM    391  CA  THR    77       5.914   3.745   4.263  1.00 39.71           C  
ATOM    392  C   THR    77       5.239   4.216   2.958  1.00 38.93           C  
ATOM    393  O   THR    77       5.185   5.422   2.674  1.00 39.12           O  
ATOM    394  CB  THR    77       4.882   3.875   5.431  1.00 39.07           C  
ATOM    395  OG1 THR    77       3.739   3.054   5.155  1.00 39.10           O  
ATOM    396  CG2 THR    77       4.428   5.356   5.650  1.00 38.80           C  
ATOM    397  N   PRO    78       4.757   3.259   2.143  1.00 38.60           N  
ATOM    398  CA  PRO    78       3.988   3.592   0.943  1.00 38.17           C  
ATOM    399  C   PRO    78       2.529   3.983   1.249  1.00 37.52           C  
ATOM    400  O   PRO    78       1.790   4.348   0.333  1.00 38.19           O  
ATOM    401  CB  PRO    78       4.035   2.299   0.143  1.00 38.03           C  
ATOM    402  CG  PRO    78       4.108   1.239   1.173  1.00 38.06           C  
ATOM    403  CD  PRO    78       4.953   1.802   2.274  1.00 38.18           C  
ATOM    404  N   TYR    79       2.117   3.909   2.512  1.00 37.30           N  
ATOM    405  CA  TYR    79       0.752   4.277   2.903  1.00 37.06           C  
ATOM    406  C   TYR    79       0.729   5.606   3.677  1.00 36.81           C  
ATOM    407  O   TYR    79       1.125   5.674   4.855  1.00 36.57           O  
ATOM    408  CB  TYR    79       0.107   3.170   3.732  1.00 37.18           C  
ATOM    409  CG  TYR    79       0.142   1.806   3.102  1.00 37.01           C  
ATOM    410  CD1 TYR    79      -0.799   1.433   2.159  1.00 37.18           C  
ATOM    411  CD2 TYR    79       1.108   0.873   3.473  1.00 37.97           C  
ATOM    412  CE1 TYR    79      -0.780   0.177   1.580  1.00 37.29           C  
ATOM    413  CE2 TYR    79       1.152  -0.395   2.884  1.00 37.76           C  
ATOM    414  CZ  TYR    79       0.196  -0.734   1.936  1.00 37.33           C  
ATOM    415  OH  TYR    79       0.210  -1.985   1.357  1.00 37.49           O  
ATOM    416  N   PHE    80       0.259   6.658   3.013  1.00 36.23           N  
ATOM    417  CA  PHE    80       0.154   7.999   3.603  1.00 37.21           C  
ATOM    418  C   PHE    80      -0.652   8.032   4.925  1.00 37.56           C  
ATOM    419  O   PHE    80      -0.373   8.865   5.779  1.00 37.45           O  
ATOM    420  CB  PHE    80      -0.451   8.953   2.561  1.00 35.97           C  
ATOM    421  CG  PHE    80      -0.577  10.387   3.018  1.00 35.89           C  
ATOM    422  CD1 PHE    80       0.526  11.231   3.016  1.00 35.13           C  
ATOM    423  CD2 PHE    80      -1.816  10.909   3.378  1.00 35.63           C  
ATOM    424  CE1 PHE    80       0.413  12.549   3.420  1.00 35.29           C  
ATOM    425  CE2 PHE    80      -1.941  12.238   3.780  1.00 35.65           C  
ATOM    426  CZ  PHE    80      -0.830  13.053   3.811  1.00 35.28           C  
ATOM    427  N   GLN    81      -1.641   7.136   5.068  1.00 39.01           N  
ATOM    428  CA  GLN    81      -2.531   7.009   6.266  1.00 39.99           C  
ATOM    429  C   GLN    81      -1.786   6.615   7.537  1.00 38.96           C  
ATOM    430  O   GLN    81      -2.204   6.938   8.667  1.00 37.94           O  
ATOM    431  CB  GLN    81      -3.658   5.969   6.004  1.00 41.53           C  
ATOM    432  CG  GLN    81      -3.152   4.521   5.724  1.00 43.63           C  
ATOM    433  CD  GLN    81      -4.045   3.686   4.773  1.00 44.28           C  
ATOM    434  OE1 GLN    81      -5.212   4.017   4.516  1.00 47.08           O  
ATOM    435  NE2 GLN    81      -3.480   2.592   4.251  1.00 45.82           N  
ATOM    436  N   GLU    82      -0.680   5.915   7.329  1.00 38.65           N  
ATOM    437  CA  GLU    82       0.175   5.459   8.401  1.00 38.49           C  
ATOM    438  C   GLU    82       1.183   6.493   8.904  1.00 37.28           C  
ATOM    439  O   GLU    82       1.880   6.211   9.861  1.00 37.02           O  
ATOM    440  CB  GLU    82       0.955   4.227   7.947  1.00 39.32           C  
ATOM    441  CG  GLU    82       0.111   3.044   7.580  1.00 40.06           C  
ATOM    442  CD  GLU    82       0.953   1.809   7.314  1.00 40.94           C  
ATOM    443  OE1 GLU    82       2.185   1.935   7.108  1.00 41.22           O  
ATOM    444  OE2 GLU    82       0.378   0.703   7.283  1.00 43.20           O  
ATOM    445  N   ILE    83       1.259   7.670   8.283  1.00 35.69           N  
ATOM    446  CA  ILE    83       2.240   8.696   8.679  1.00 34.80           C  
ATOM    447  C   ILE    83       2.067   9.259  10.105  1.00 34.57           C  
ATOM    448  O   ILE    83       3.036   9.266  10.849  1.00 36.43           O  
ATOM    449  CB  ILE    83       2.391   9.820   7.602  1.00 34.27           C  
ATOM    450  CG1 ILE    83       3.203   9.303   6.400  1.00 34.23           C  
ATOM    451  CG2 ILE    83       3.082  11.078   8.160  1.00 34.12           C  
ATOM    452  CD1 ILE    83       4.670   8.861   6.701  1.00 32.92           C  
ATOM    453  N   PRO    84       0.872   9.759  10.490  1.00 34.29           N  
ATOM    454  CA  PRO    84       0.691  10.257  11.858  1.00 34.05           C  
ATOM    455  C   PRO    84       1.080   9.271  12.960  1.00 32.73           C  
ATOM    456  O   PRO    84       1.689   9.668  13.927  1.00 32.82           O  
ATOM    457  CB  PRO    84      -0.802  10.568  11.910  1.00 34.36           C  
ATOM    458  CG  PRO    84      -1.102  10.935  10.545  1.00 34.73           C  
ATOM    459  CD  PRO    84      -0.364   9.955   9.716  1.00 34.31           C  
ATOM    460  N   GLY    85       0.731   8.000  12.794  1.00 31.91           N  
ATOM    461  CA  GLY    85       1.096   6.963  13.738  1.00 31.63           C  
ATOM    462  C   GLY    85       2.567   6.599  13.760  1.00 31.41           C  
ATOM    463  O   GLY    85       3.090   6.201  14.810  1.00 33.41           O  
ATOM    464  N   GLU    86       3.229   6.663  12.607  1.00 29.25           N  
ATOM    465  CA  GLU    86       4.634   6.386  12.557  1.00 29.44           C  
ATOM    466  C   GLU    86       5.421   7.534  13.169  1.00 28.21           C  
ATOM    467  O   GLU    86       6.460   7.279  13.754  1.00 28.92           O  
ATOM    468  CB  GLU    86       5.115   6.080  11.127  1.00 30.78           C  
ATOM    469  CG  GLU    86       4.656   4.727  10.559  1.00 32.94           C  
ATOM    470  CD  GLU    86       5.365   3.520  11.181  1.00 34.78           C  
ATOM    471  OE1 GLU    86       6.231   3.694  12.045  1.00 37.21           O  
ATOM    472  OE2 GLU    86       5.060   2.375  10.804  1.00 36.77           O  
ATOM    473  N   PHE    87       4.964   8.783  13.001  1.00 26.80           N  
ATOM    474  CA  PHE    87       5.616   9.924  13.634  1.00 28.21           C  
ATOM    475  C   PHE    87       5.514   9.804  15.163  1.00 29.41           C  
ATOM    476  O   PHE    87       6.454  10.162  15.871  1.00 31.23           O  
ATOM    477  CB  PHE    87       5.013  11.261  13.143  1.00 28.09           C  
ATOM    478  CG  PHE    87       5.670  12.514  13.751  1.00 27.89           C  
ATOM    479  CD1 PHE    87       7.031  12.754  13.595  1.00 27.99           C  
ATOM    480  CD2 PHE    87       4.911  13.470  14.400  1.00 28.57           C  
ATOM    481  CE1 PHE    87       7.618  13.916  14.106  1.00 28.10           C  
ATOM    482  CE2 PHE    87       5.483  14.639  14.922  1.00 28.19           C  
ATOM    483  CZ  PHE    87       6.842  14.860  14.779  1.00 28.07           C  
ATOM    484  N   LEU    88       4.378   9.324  15.677  1.00 30.36           N  
ATOM    485  CA  LEU    88       4.220   9.109  17.121  1.00 30.46           C  
ATOM    486  C   LEU    88       5.224   8.069  17.637  1.00 31.42           C  
ATOM    487  O   LEU    88       5.833   8.271  18.698  1.00 29.42           O  
ATOM    488  CB  LEU    88       2.784   8.666  17.467  1.00 31.13           C  
ATOM    489  CG  LEU    88       2.412   8.532  18.953  1.00 31.21           C  
ATOM    490  CD1 LEU    88       2.684   9.812  19.710  1.00 31.01           C  
ATOM    491  CD2 LEU    88       0.929   8.096  19.140  1.00 31.40           C  
ATOM    492  N   GLN    89       5.393   6.967  16.901  1.00 31.85           N  
ATOM    493  CA  GLN    89       6.357   5.947  17.298  1.00 34.37           C  
ATOM    494  C   GLN    89       7.800   6.468  17.155  1.00 34.03           C  
ATOM    495  O   GLN    89       8.666   6.108  17.933  1.00 33.46           O  
ATOM    496  CB  GLN    89       6.174   4.666  16.492  1.00 35.02           C  
ATOM    497  CG  GLN    89       4.813   4.027  16.684  1.00 36.73           C  
ATOM    498  CD  GLN    89       4.686   2.702  15.951  1.00 37.09           C  
ATOM    499  OE1 GLN    89       5.443   1.746  16.201  1.00 39.15           O  
ATOM    500  NE2 GLN    89       3.731   2.636  15.038  1.00 37.94           N  
ATOM    501  N   TYR    90       8.059   7.302  16.157  1.00 34.20           N  
ATOM    502  CA  TYR    90       9.378   7.913  16.030  1.00 34.41           C  
ATOM    503  C   TYR    90       9.673   8.721  17.304  1.00 34.93           C  
ATOM    504  O   TYR    90      10.740   8.585  17.911  1.00 35.59           O  
ATOM    505  CB  TYR    90       9.465   8.805  14.774  1.00 33.05           C  
ATOM    506  CG  TYR    90      10.776   9.585  14.662  1.00 32.56           C  
ATOM    507  CD1 TYR    90      11.970   8.946  14.331  1.00 32.25           C  
ATOM    508  CD2 TYR    90      10.807  10.960  14.887  1.00 32.58           C  
ATOM    509  CE1 TYR    90      13.177   9.660  14.260  1.00 32.10           C  
ATOM    510  CE2 TYR    90      11.998  11.683  14.821  1.00 32.58           C  
ATOM    511  CZ  TYR    90      13.168  11.035  14.491  1.00 32.09           C  
ATOM    512  OH  TYR    90      14.313  11.769  14.418  1.00 31.83           O  
ATOM    513  N   CYS    91       8.713   9.563  17.692  1.00 35.16           N  
ATOM    514  CA  CYS    91       8.809  10.402  18.899  1.00 33.78           C  
ATOM    515  C   CYS    91       8.950   9.627  20.216  1.00 34.05           C  
ATOM    516  O   CYS    91       9.608  10.096  21.122  1.00 33.30           O  
ATOM    517  CB  CYS    91       7.607  11.318  18.983  1.00 32.68           C  
ATOM    518  SG  CYS    91       7.605  12.534  17.689  1.00 31.54           S  
ATOM    519  N   GLN    92       8.315   8.458  20.311  1.00 34.20           N  
ATOM    520  CA  GLN    92       8.417   7.606  21.493  1.00 35.03           C  
ATOM    521  C   GLN    92       9.767   6.916  21.576  1.00 34.16           C  
ATOM    522  O   GLN    92      10.193   6.491  22.638  1.00 34.81           O  
ATOM    523  CB  GLN    92       7.304   6.565  21.485  1.00 35.59           C  
ATOM    524  CG  GLN    92       5.914   7.175  21.698  1.00 36.42           C  
ATOM    525  CD  GLN    92       4.751   6.237  21.334  1.00 37.22           C  
ATOM    526  OE1 GLN    92       4.947   5.125  20.847  1.00 36.76           O  
ATOM    527  NE2 GLN    92       3.523   6.717  21.568  1.00 39.66           N  
ATOM    528  N   SER    93      10.454   6.798  20.451  1.00 34.03           N  
ATOM    529  CA  SER    93      11.752   6.163  20.446  1.00 32.81           C  
ATOM    530  C   SER    93      12.870   7.156  20.707  1.00 31.91           C  
ATOM    531  O   SER    93      13.942   6.741  21.110  1.00 30.81           O  
ATOM    532  CB  SER    93      11.999   5.469  19.113  1.00 34.11           C  
ATOM    533  OG  SER    93      12.114   6.403  18.055  1.00 34.71           O  
ATOM    534  N   LEU    94      12.631   8.456  20.479  1.00 31.83           N  
ATOM    535  CA  LEU    94      13.685   9.486  20.653  1.00 31.51           C  
ATOM    536  C   LEU    94      14.342   9.464  22.029  1.00 31.46           C  
ATOM    537  O   LEU    94      15.574   9.451  22.101  1.00 31.87           O  
ATOM    538  CB  LEU    94      13.193  10.902  20.304  1.00 30.79           C  
ATOM    539  CG  LEU    94      13.038  11.228  18.819  1.00 30.95           C  
ATOM    540  CD1 LEU    94      12.328  12.594  18.633  1.00 30.72           C  
ATOM    541  CD2 LEU    94      14.373  11.164  18.090  1.00 30.03           C  
ATOM    542  N   PRO    95      13.545   9.543  23.121  1.00 31.16           N  
ATOM    543  CA  PRO    95      12.104   9.764  23.270  1.00 31.24           C  
ATOM    544  C   PRO    95      11.760  11.193  23.647  1.00 31.96           C  
ATOM    545  O   PRO    95      12.596  11.871  24.235  1.00 33.19           O  
ATOM    546  CB  PRO    95      11.759   8.882  24.457  1.00 30.56           C  
ATOM    547  CG  PRO    95      12.999   8.957  25.346  1.00 30.77           C  
ATOM    548  CD  PRO    95      14.174   9.262  24.431  1.00 31.16           C  
ATOM    549  N   LEU    96      10.552  11.668  23.331  1.00 31.46           N  
ATOM    550  CA  LEU    96      10.156  13.006  23.809  1.00 31.65           C  
ATOM    551  C   LEU    96       9.721  12.819  25.276  1.00 32.28           C  
ATOM    552  O   LEU    96       9.670  11.693  25.757  1.00 32.15           O  
ATOM    553  CB  LEU    96       9.045  13.647  22.957  1.00 29.95           C  
ATOM    554  CG  LEU    96       9.370  13.934  21.476  1.00 29.64           C  
ATOM    555  CD1 LEU    96       8.198  14.615  20.747  1.00 27.64           C  
ATOM    556  CD2 LEU    96      10.677  14.795  21.361  1.00 28.59           C  
END
