
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   80 (  656),  selected   80 , name 2ffg_A
# Molecule2: number of CA atoms   58 (  474),  selected   58 , name T0443_97_116_136_173.pdb
# PARAMETERS: 2ffg_A.T0443_97_116_136_173.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      S      97          2.635
LGA    Q     3_A      D      98          3.164
LGA    L     4_A      G      99          2.908
LGA    X     5_A      I     100          1.515
LGA    G     6_A      L     101          1.345
LGA    I     7_A      A     102          2.007
LGA    I     8_A      L     103          1.554
LGA    T     9_A      M     104          0.426
LGA    R    10_A      D     105          0.658
LGA    L    11_A      F     106          0.531
LGA    Q    12_A      E     107          1.250
LGA    S    13_A      Y     108          1.470
LGA    L    14_A      T     109          1.078
LGA    Q    15_A      Q     110          1.402
LGA    E    16_A      L     111          1.822
LGA    T    17_A      L     112          1.865
LGA    A    18_A      A     113          2.055
LGA    E    19_A      E     114          2.604
LGA    A    20_A      V     115          2.860
LGA    A    21_A      A     116          2.702
LGA    N    22_A      P     136          5.009
LGA    E    23_A      A     137          1.768
LGA    P    24_A      A     138          1.241
LGA    X    25_A      F     139          1.081
LGA    Q    26_A      I     140          1.488
LGA    R    27_A      R     141          1.319
LGA    Y    28_A      Q     142          1.147
LGA    F    29_A      Y     143          1.894
LGA    E    30_A      R     144          4.386
LGA    V    31_A      Y     145           -
LGA    N    32_A      D     146           -
LGA    G    33_A      V     147           -
LGA    E    34_A      T     148           -
LGA    K    35_A      H     149           -
LGA    -       -      D     150           -
LGA    -       -      L     151           -
LGA    -       -      Q     152           -
LGA    -       -      E     153           -
LGA    -       -      A     154           -
LGA    I    36_A      E     155          2.817
LGA    C    37_A      T     156          2.803
LGA    S    38_A      A     157          1.600
LGA    V    39_A      L     158          1.187
LGA    K    40_A      L     159          1.134
LGA    Y    41_A      I     160          1.054
LGA    F    42_A      W     161          2.087
LGA    E    43_A      R     162          1.617
LGA    K    44_A      N     163          1.676
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      D     166           -
LGA    N    45_A      D     167          2.145
LGA    Q    46_A      V     168          2.315
LGA    T    47_A      M     169          2.030
LGA    F    48_A      Y     170          1.255
LGA    E    49_A      Q     171          0.713
LGA    L    50_A      T     172          1.849
LGA    T    51_A      L     173          2.829
LGA    V    52_A      -       -           -
LGA    F    53_A      -       -           -
LGA    Q    54_A      -       -           -
LGA    K    55_A      -       -           -
LGA    G    56_A      -       -           -
LGA    E    57_A      -       -           -
LGA    K    58_A      -       -           -
LGA    P    59_A      -       -           -
LGA    N    60_A      -       -           -
LGA    T    61_A      -       -           -
LGA    Y    62_A      -       -           -
LGA    P    63_A      -       -           -
LGA    F    64_A      -       -           -
LGA    D    65_A      -       -           -
LGA    N    66_A      -       -           -
LGA    I    67_A      -       -           -
LGA    D    68_A      -       -           -
LGA    X    69_A      -       -           -
LGA    V    70_A      -       -           -
LGA    S    71_A      -       -           -
LGA    I    72_A      -       -           -
LGA    E    73_A      -       -           -
LGA    I    74_A      -       -           -
LGA    F    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    L    78_A      -       -           -
LGA    Q    79_A      -       -           -
LGA    L    80_A      -       -           -
LGA    E    81_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   80   58    5.0     45    2.08    13.33     67.450     2.060

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.606907 * X  +   0.153730 * Y  +  -0.779763 * Z  +  25.801098
  Y_new =  -0.476395 * X  +  -0.855691 * Y  +   0.202089 * Z  +  73.542007
  Z_new =  -0.636170 * X  +   0.494125 * Y  +   0.592562 * Z  +   4.189790 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.695060   -2.446532  [ DEG:    39.8240   -140.1760 ]
  Theta =   0.689523    2.452069  [ DEG:    39.5068    140.4932 ]
  Phi   =  -2.476093    0.665500  [ DEG:  -141.8697     38.1303 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ffg_A                                        
REMARK     2: T0443_97_116_136_173.pdb                      
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ffg_A.T0443_97_116_136_173.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   80   58   5.0   45   2.08   13.33  67.450
REMARK  ---------------------------------------------------------- 
MOLECULE 2ffg_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-DEC-05   2FFG              
TITLE     NOVEL X-RAY STRUCTURE OF THE YKUJ PROTEIN FROM BACILLUS               
TITLE    2 SUBTILIS. NORTHEAST STRUCTURAL GENOMICS TARGET SR360.                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: YKUJ;                                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YKUJ;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) + MAGIC;                         
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    X-RAY SR360 NESG YKUJ, STRUCTURAL GENOMICS, PSI, PROTEIN              
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,M.ABASHIDZE,F.FOROUHAR,S.M.VOROBIEV,C.K.HO,                 
AUTHOR   2 H.JANJUA,K.CUNNINGHAM,K.CONOVER,L.C.MA,R.XIAO,T.B.ACTON,             
AUTHOR   3 G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   2   25-APR-06 2FFG    1       AUTHOR                                   
REVDAT   1   27-DEC-05 2FFG    0                                                
JRNL        AUTH   A.P.KUZIN,M.ABASHIDZE,F.FOROUHAR,S.M.VOROBIEV,               
JRNL        AUTH 2 C.K.HO,H.JANJUA,K.CUNNINGHAM,K.CONOVER,L.C.MA,               
JRNL        AUTH 3 R.XIAO,T.B.ACTON,G.T.MONTELIONE,L.TONG,J.F.HUNT,             
JRNL        AUTH 4 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)              
JRNL        TITL   NOVEL X-RAY STRUCTURE OF THE YKUJ PROTEIN FROM               
JRNL        TITL 2 BACILLUS SUBTILIS. NORTHEAST STRUCTURAL GENOMICS             
JRNL        TITL 3 TARGET SR360.                                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.31 ANGSTROMS.                                          
DBREF  2FFG A    1    79  UNP    O34588   O34588_BACSU     1     79             
DBREF  2FFG B    1    79  UNP    O34588   O34588_BACSU     1     79             
SEQRES   1 A   87  MSE SER GLN LEU MSE GLY ILE ILE THR ARG LEU GLN SER          
SEQRES   2 A   87  LEU GLN GLU THR ALA GLU ALA ALA ASN GLU PRO MSE GLN          
SEQRES   3 A   87  ARG TYR PHE GLU VAL ASN GLY GLU LYS ILE CYS SER VAL          
SEQRES   4 A   87  LYS TYR PHE GLU LYS ASN GLN THR PHE GLU LEU THR VAL          
SEQRES   5 A   87  PHE GLN LYS GLY GLU LYS PRO ASN THR TYR PRO PHE ASP          
SEQRES   6 A   87  ASN ILE ASP MSE VAL SER ILE GLU ILE PHE GLU LEU LEU          
SEQRES   7 A   87  GLN LEU GLU HIS HIS HIS HIS HIS HIS                          
SEQRES   1 B   87  MSE SER GLN LEU MSE GLY ILE ILE THR ARG LEU GLN SER          
SEQRES   2 B   87  LEU GLN GLU THR ALA GLU ALA ALA ASN GLU PRO MSE GLN          
SEQRES   3 B   87  ARG TYR PHE GLU VAL ASN GLY GLU LYS ILE CYS SER VAL          
SEQRES   4 B   87  LYS TYR PHE GLU LYS ASN GLN THR PHE GLU LEU THR VAL          
SEQRES   5 B   87  PHE GLN LYS GLY GLU LYS PRO ASN THR TYR PRO PHE ASP          
SEQRES   6 B   87  ASN ILE ASP MSE VAL SER ILE GLU ILE PHE GLU LEU LEU          
SEQRES   7 B   87  GLN LEU GLU HIS HIS HIS HIS HIS HIS                          
HET    MSE  A   5       8                                                       
HET    MSE  A  25       8                                                       
HET    MSE  A  69       8                                                       
HET    MSE  B   5       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  B  69       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *67(H2 O)                                                     
CRYST1   85.915   85.915   51.377  90.00  90.00  90.00 P 41 21 2    16          
ATOM      1  N   SER A   2       9.039  16.087  25.975  1.00 47.52           N  
ATOM      2  CA  SER A   2       8.500  16.354  27.343  1.00 45.32           C  
ATOM      3  C   SER A   2       7.228  15.548  27.569  1.00 44.31           C  
ATOM      4  O   SER A   2       6.611  15.059  26.620  1.00 43.33           O  
ATOM      5  CB  SER A   2       8.190  17.839  27.512  1.00 37.14           C  
ATOM      6  OG  SER A   2       7.120  18.224  26.667  1.00 36.26           O  
ATOM      7  N   GLN A   3       6.837  15.422  28.832  1.00 35.89           N  
ATOM      8  CA  GLN A   3       5.650  14.668  29.191  1.00 33.70           C  
ATOM      9  C   GLN A   3       4.405  15.201  28.494  1.00 32.14           C  
ATOM     10  O   GLN A   3       3.588  14.429  27.984  1.00 32.05           O  
ATOM     11  CB  GLN A   3       5.457  14.699  30.707  1.00 40.51           C  
ATOM     12  CG  GLN A   3       4.404  13.718  31.207  1.00 44.39           C  
ATOM     13  CD  GLN A   3       4.402  13.581  32.712  1.00 46.33           C  
ATOM     14  OE1 GLN A   3       3.647  12.789  33.275  1.00 45.63           O  
ATOM     15  NE2 GLN A   3       5.254  14.356  33.376  1.00 49.56           N  
ATOM     16  N   LEU A   4       4.269  16.522  28.463  1.00 26.60           N  
ATOM     17  CA  LEU A   4       3.118  17.156  27.829  1.00 25.92           C  
ATOM     18  C   LEU A   4       3.041  16.776  26.340  1.00 25.02           C  
ATOM     19  O   LEU A   4       1.978  16.401  25.843  1.00 21.17           O  
ATOM     20  CB  LEU A   4       3.210  18.672  28.014  1.00 32.69           C  
ATOM     21  CG  LEU A   4       1.942  19.533  28.053  1.00 34.96           C  
ATOM     22  CD1 LEU A   4       0.850  18.886  28.916  1.00 36.24           C  
ATOM     23  CD2 LEU A   4       2.312  20.908  28.614  1.00 35.81           C  
HETATM   24  N   MSE A   5       4.176  16.864  25.649  1.00 28.32           N  
HETATM   25  CA  MSE A   5       4.267  16.507  24.233  1.00 30.00           C  
HETATM   26  C   MSE A   5       3.713  15.089  24.053  1.00 28.19           C  
HETATM   27  O   MSE A   5       2.871  14.839  23.187  1.00 25.19           O  
HETATM   28  CB  MSE A   5       5.741  16.566  23.774  1.00 83.23           C  
HETATM   29  CG  MSE A   5       6.024  16.068  22.338  1.00 93.38           C  
HETATM   30 SE   MSE A   5       7.931  16.140  21.760  1.00106.23          SE  
HETATM   31  CE  MSE A   5       8.534  14.413  22.434  1.00102.11           C  
ATOM     32  N   GLY A   6       4.177  14.180  24.906  1.00 30.74           N  
ATOM     33  CA  GLY A   6       3.752  12.794  24.841  1.00 30.13           C  
ATOM     34  C   GLY A   6       2.274  12.546  25.059  1.00 27.83           C  
ATOM     35  O   GLY A   6       1.727  11.590  24.511  1.00 28.36           O  
ATOM     36  N   ILE A   7       1.629  13.390  25.857  1.00 25.51           N  
ATOM     37  CA  ILE A   7       0.196  13.249  26.135  1.00 23.32           C  
ATOM     38  C   ILE A   7      -0.647  13.716  24.952  1.00 22.80           C  
ATOM     39  O   ILE A   7      -1.692  13.145  24.647  1.00 22.74           O  
ATOM     40  CB  ILE A   7      -0.228  14.095  27.356  1.00 19.55           C  
ATOM     41  CG1 ILE A   7       0.454  13.575  28.621  1.00 17.48           C  
ATOM     42  CG2 ILE A   7      -1.756  14.107  27.479  1.00 18.97           C  
ATOM     43  CD1 ILE A   7       0.246  12.115  29.016  1.00 39.50           C  
ATOM     44  N   ILE A   8      -0.192  14.782  24.313  1.00 20.16           N  
ATOM     45  CA  ILE A   8      -0.893  15.345  23.177  1.00 22.50           C  
ATOM     46  C   ILE A   8      -0.813  14.396  21.994  1.00 22.78           C  
ATOM     47  O   ILE A   8      -1.792  14.190  21.288  1.00 23.63           O  
ATOM     48  CB  ILE A   8      -0.279  16.705  22.793  1.00 23.89           C  
ATOM     49  CG1 ILE A   8      -0.431  17.683  23.967  1.00 23.12           C  
ATOM     50  CG2 ILE A   8      -0.937  17.231  21.522  1.00 24.22           C  
ATOM     51  CD1 ILE A   8       0.401  18.958  23.852  1.00 39.50           C  
ATOM     52  N   THR A   9       0.361  13.818  21.783  1.00 27.81           N  
ATOM     53  CA  THR A   9       0.540  12.886  20.686  1.00 31.20           C  
ATOM     54  C   THR A   9      -0.456  11.744  20.852  1.00 30.10           C  
ATOM     55  O   THR A   9      -1.220  11.423  19.936  1.00 31.04           O  
ATOM     56  CB  THR A   9       1.967  12.308  20.664  1.00 37.28           C  
ATOM     57  OG1 THR A   9       2.915  13.378  20.595  1.00 40.20           O  
ATOM     58  CG2 THR A   9       2.153  11.417  19.442  1.00 40.78           C  
ATOM     59  N   ARG A  10      -0.461  11.154  22.040  1.00 23.95           N  
ATOM     60  CA  ARG A  10      -1.352  10.046  22.329  1.00 22.96           C  
ATOM     61  C   ARG A  10      -2.828  10.389  22.116  1.00 21.39           C  
ATOM     62  O   ARG A  10      -3.618   9.543  21.689  1.00 19.62           O  
ATOM     63  CB  ARG A  10      -1.114   9.562  23.759  1.00 26.82           C  
ATOM     64  CG  ARG A  10       0.227   8.861  23.956  1.00 27.23           C  
ATOM     65  CD  ARG A  10       0.496   8.599  25.437  1.00 29.58           C  
ATOM     66  NE  ARG A  10       1.662   7.745  25.660  1.00 32.12           N  
ATOM     67  CZ  ARG A  10       2.924   8.117  25.474  1.00 31.81           C  
ATOM     68  NH1 ARG A  10       3.212   9.340  25.060  1.00 34.91           N  
ATOM     69  NH2 ARG A  10       3.905   7.256  25.702  1.00 34.61           N  
ATOM     70  N   LEU A  11      -3.204  11.628  22.416  1.00 21.01           N  
ATOM     71  CA  LEU A  11      -4.585  12.040  22.245  1.00 22.93           C  
ATOM     72  C   LEU A  11      -4.904  12.279  20.779  1.00 23.49           C  
ATOM     73  O   LEU A  11      -6.045  12.141  20.361  1.00 24.96           O  
ATOM     74  CB  LEU A  11      -4.882  13.302  23.063  1.00 26.55           C  
ATOM     75  CG  LEU A  11      -4.798  13.144  24.587  1.00 27.19           C  
ATOM     76  CD1 LEU A  11      -5.184  14.449  25.266  1.00 27.41           C  
ATOM     77  CD2 LEU A  11      -5.716  12.031  25.042  1.00 24.96           C  
ATOM     78  N   GLN A  12      -3.891  12.628  19.996  1.00 34.23           N  
ATOM     79  CA  GLN A  12      -4.096  12.868  18.576  1.00 37.53           C  
ATOM     80  C   GLN A  12      -4.317  11.547  17.870  1.00 38.54           C  
ATOM     81  O   GLN A  12      -5.204  11.432  17.019  1.00 39.82           O  
ATOM     82  CB  GLN A  12      -2.897  13.592  17.974  1.00 33.82           C  
ATOM     83  CG  GLN A  12      -2.717  15.000  18.497  1.00 33.19           C  
ATOM     84  CD  GLN A  12      -1.458  15.644  17.965  1.00 34.67           C  
ATOM     85  OE1 GLN A  12      -0.390  15.022  17.935  1.00 35.50           O  
ATOM     86  NE2 GLN A  12      -1.568  16.897  17.551  1.00 34.80           N  
ATOM     87  N   SER A  13      -3.515  10.546  18.227  1.00 35.38           N  
ATOM     88  CA  SER A  13      -3.662   9.231  17.620  1.00 37.08           C  
ATOM     89  C   SER A  13      -4.928   8.569  18.148  1.00 36.43           C  
ATOM     90  O   SER A  13      -5.508   7.714  17.483  1.00 37.77           O  
ATOM     91  CB  SER A  13      -2.434   8.353  17.902  1.00 47.09           C  
ATOM     92  OG  SER A  13      -2.197   8.213  19.288  1.00 50.10           O  
ATOM     93  N   LEU A  14      -5.361   8.985  19.335  1.00 32.17           N  
ATOM     94  CA  LEU A  14      -6.570   8.444  19.949  1.00 33.85           C  
ATOM     95  C   LEU A  14      -7.794   8.874  19.139  1.00 35.21           C  
ATOM     96  O   LEU A  14      -8.684   8.066  18.880  1.00 35.20           O  
ATOM     97  CB  LEU A  14      -6.681   8.927  21.407  1.00 37.09           C  
ATOM     98  CG  LEU A  14      -7.671   8.332  22.432  1.00 36.72           C  
ATOM     99  CD1 LEU A  14      -8.989   9.062  22.405  1.00 36.93           C  
ATOM    100  CD2 LEU A  14      -7.864   6.846  22.181  1.00 37.19           C  
ATOM    101  N   GLN A  15      -7.846  10.138  18.731  1.00 39.91           N  
ATOM    102  CA  GLN A  15      -8.985  10.606  17.945  1.00 43.40           C  
ATOM    103  C   GLN A  15      -8.868  10.078  16.521  1.00 43.82           C  
ATOM    104  O   GLN A  15      -9.853   9.667  15.912  1.00 42.83           O  
ATOM    105  CB  GLN A  15      -9.053  12.137  17.930  1.00 48.13           C  
ATOM    106  CG  GLN A  15      -7.720  12.823  17.736  1.00 50.10           C  
ATOM    107  CD  GLN A  15      -7.868  14.284  17.358  1.00 52.63           C  
ATOM    108  OE1 GLN A  15      -8.681  15.012  17.934  1.00 50.81           O  
ATOM    109  NE2 GLN A  15      -7.066  14.728  16.386  1.00 53.72           N  
ATOM    110  N   GLU A  16      -7.650  10.093  16.005  1.00 43.05           N  
ATOM    111  CA  GLU A  16      -7.378   9.609  14.667  1.00 44.78           C  
ATOM    112  C   GLU A  16      -7.907   8.184  14.533  1.00 44.28           C  
ATOM    113  O   GLU A  16      -8.544   7.827  13.540  1.00 45.16           O  
ATOM    114  CB  GLU A  16      -5.869   9.656  14.426  1.00 72.15           C  
ATOM    115  CG  GLU A  16      -5.386   9.025  13.142  1.00 78.08           C  
ATOM    116  CD  GLU A  16      -3.867   9.075  13.020  1.00 81.53           C  
ATOM    117  OE1 GLU A  16      -3.176   8.648  13.976  1.00 81.32           O  
ATOM    118  OE2 GLU A  16      -3.367   9.539  11.969  1.00 82.51           O  
ATOM    119  N   THR A  17      -7.656   7.372  15.550  1.00 43.18           N  
ATOM    120  CA  THR A  17      -8.102   5.988  15.533  1.00 42.26           C  
ATOM    121  C   THR A  17      -9.611   5.869  15.711  1.00 41.50           C  
ATOM    122  O   THR A  17     -10.233   4.939  15.202  1.00 42.66           O  
ATOM    123  CB  THR A  17      -7.388   5.184  16.630  1.00 47.25           C  
ATOM    124  OG1 THR A  17      -5.973   5.241  16.407  1.00 46.53           O  
ATOM    125  CG2 THR A  17      -7.838   3.739  16.615  1.00 47.84           C  
ATOM    126  N   ALA A  18     -10.203   6.824  16.419  1.00 36.12           N  
ATOM    127  CA  ALA A  18     -11.638   6.808  16.648  1.00 34.88           C  
ATOM    128  C   ALA A  18     -12.443   7.198  15.408  1.00 35.71           C  
ATOM    129  O   ALA A  18     -13.532   6.670  15.175  1.00 35.16           O  
ATOM    130  CB  ALA A  18     -11.981   7.735  17.792  1.00 29.27           C  
ATOM    131  N   GLU A  19     -11.917   8.127  14.616  1.00 35.10           N  
ATOM    132  CA  GLU A  19     -12.616   8.567  13.418  1.00 37.85           C  
ATOM    133  C   GLU A  19     -12.664   7.446  12.382  1.00 38.60           C  
ATOM    134  O   GLU A  19     -13.694   7.215  11.747  1.00 38.36           O  
ATOM    135  CB  GLU A  19     -11.931   9.810  12.837  1.00 45.04           C  
ATOM    136  CG  GLU A  19     -11.974  11.029  13.767  1.00 45.47           C  
ATOM    137  CD  GLU A  19     -13.321  11.740  13.781  1.00 45.19           C  
ATOM    138  OE1 GLU A  19     -14.344  11.114  13.450  1.00 48.01           O  
ATOM    139  OE2 GLU A  19     -13.360  12.935  14.140  1.00 46.53           O  
ATOM    140  N   ALA A  20     -11.549   6.744  12.238  1.00 50.74           N  
ATOM    141  CA  ALA A  20     -11.441   5.637  11.293  1.00 53.10           C  
ATOM    142  C   ALA A  20     -12.312   4.443  11.691  1.00 54.11           C  
ATOM    143  O   ALA A  20     -13.006   3.861  10.856  1.00 55.78           O  
ATOM    144  CB  ALA A  20      -9.984   5.200  11.174  1.00 35.26           C  
ATOM    145  N   ALA A  21     -12.269   4.074  12.963  1.00 53.98           N  
ATOM    146  CA  ALA A  21     -13.057   2.953  13.453  1.00 54.82           C  
ATOM    147  C   ALA A  21     -14.523   3.358  13.524  1.00 54.58           C  
ATOM    148  O   ALA A  21     -15.406   2.522  13.727  1.00 55.42           O  
ATOM    149  CB  ALA A  21     -12.563   2.538  14.837  1.00 57.95           C  
ATOM    150  N   ASN A  22     -14.769   4.650  13.343  1.00 40.96           N  
ATOM    151  CA  ASN A  22     -16.111   5.199  13.407  1.00 40.64           C  
ATOM    152  C   ASN A  22     -16.832   4.787  14.679  1.00 39.85           C  
ATOM    153  O   ASN A  22     -18.009   4.428  14.651  1.00 39.14           O  
ATOM    154  CB  ASN A  22     -16.926   4.785  12.181  1.00 56.66           C  
ATOM    155  CG  ASN A  22     -17.061   5.913  11.168  1.00 57.66           C  
ATOM    156  OD1 ASN A  22     -17.702   6.929  11.436  1.00 57.70           O  
ATOM    157  ND2 ASN A  22     -16.444   5.743  10.007  1.00 59.72           N  
ATOM    158  N   GLU A  23     -16.115   4.847  15.797  1.00 41.95           N  
ATOM    159  CA  GLU A  23     -16.680   4.508  17.098  1.00 41.64           C  
ATOM    160  C   GLU A  23     -15.815   5.060  18.227  1.00 39.93           C  
ATOM    161  O   GLU A  23     -14.596   5.172  18.090  1.00 39.15           O  
ATOM    162  CB  GLU A  23     -16.824   2.989  17.254  1.00 61.45           C  
ATOM    163  CG  GLU A  23     -15.550   2.254  17.614  1.00 65.06           C  
ATOM    164  CD  GLU A  23     -15.810   0.808  18.005  1.00 67.49           C  
ATOM    165  OE1 GLU A  23     -16.144  -0.004  17.119  1.00 69.04           O  
ATOM    166  OE2 GLU A  23     -15.688   0.488  19.205  1.00 69.95           O  
ATOM    167  N   PRO A  24     -16.442   5.417  19.357  1.00 37.85           N  
ATOM    168  CA  PRO A  24     -15.728   5.959  20.515  1.00 36.98           C  
ATOM    169  C   PRO A  24     -14.538   5.087  20.874  1.00 36.37           C  
ATOM    170  O   PRO A  24     -14.591   3.865  20.739  1.00 37.26           O  
ATOM    171  CB  PRO A  24     -16.783   5.939  21.610  1.00 39.95           C  
ATOM    172  CG  PRO A  24     -18.048   6.149  20.861  1.00 42.41           C  
ATOM    173  CD  PRO A  24     -17.875   5.254  19.657  1.00 41.21           C  
HETATM  174  N   MSE A  25     -13.460   5.719  21.318  1.00 32.81           N  
HETATM  175  CA  MSE A  25     -12.267   4.990  21.705  1.00 33.24           C  
HETATM  176  C   MSE A  25     -11.720   5.623  22.980  1.00 31.22           C  
HETATM  177  O   MSE A  25     -11.933   6.807  23.226  1.00 28.14           O  
HETATM  178  CB  MSE A  25     -11.225   5.045  20.590  1.00 59.16           C  
HETATM  179  CG  MSE A  25     -10.483   3.732  20.393  1.00 66.12           C  
HETATM  180 SE   MSE A  25     -11.590   2.354  19.573  1.00 75.09          SE  
HETATM  181  CE  MSE A  25     -10.795   2.404  17.811  1.00 72.12           C  
ATOM    182  N   GLN A  26     -11.013   4.838  23.785  1.00 37.05           N  
ATOM    183  CA  GLN A  26     -10.485   5.347  25.040  1.00 34.76           C  
ATOM    184  C   GLN A  26      -9.134   4.751  25.415  1.00 32.17           C  
ATOM    185  O   GLN A  26      -8.745   3.710  24.903  1.00 31.92           O  
ATOM    186  CB  GLN A  26     -11.484   5.041  26.149  1.00 40.07           C  
ATOM    187  CG  GLN A  26     -11.850   3.575  26.191  1.00 45.81           C  
ATOM    188  CD  GLN A  26     -12.688   3.211  27.389  1.00 50.80           C  
ATOM    189  OE1 GLN A  26     -12.265   3.394  28.530  1.00 53.39           O  
ATOM    190  NE2 GLN A  26     -13.886   2.683  27.141  1.00 51.86           N  
ATOM    191  N   ARG A  27      -8.424   5.432  26.312  1.00 27.47           N  
ATOM    192  CA  ARG A  27      -7.143   4.950  26.813  1.00 25.36           C  
ATOM    193  C   ARG A  27      -6.900   5.473  28.231  1.00 24.50           C  
ATOM    194  O   ARG A  27      -7.563   6.409  28.692  1.00 21.42           O  
ATOM    195  CB  ARG A  27      -5.987   5.341  25.884  1.00 26.47           C  
ATOM    196  CG  ARG A  27      -5.578   6.798  25.900  1.00 26.62           C  
ATOM    197  CD  ARG A  27      -4.644   7.085  24.742  1.00 28.54           C  
ATOM    198  NE  ARG A  27      -3.320   6.471  24.888  1.00 30.15           N  
ATOM    199  CZ  ARG A  27      -2.454   6.295  23.883  1.00 28.47           C  
ATOM    200  NH1 ARG A  27      -2.765   6.680  22.645  1.00 23.45           N  
ATOM    201  NH2 ARG A  27      -1.267   5.743  24.117  1.00 28.79           N  
ATOM    202  N   TYR A  28      -5.958   4.842  28.921  1.00 25.06           N  
ATOM    203  CA  TYR A  28      -5.627   5.205  30.287  1.00 24.85           C  
ATOM    204  C   TYR A  28      -4.305   5.932  30.344  1.00 24.86           C  
ATOM    205  O   TYR A  28      -3.482   5.846  29.441  1.00 21.72           O  
ATOM    206  CB  TYR A  28      -5.488   3.958  31.162  1.00 25.62           C  
ATOM    207  CG  TYR A  28      -6.760   3.199  31.380  1.00 29.87           C  
ATOM    208  CD1 TYR A  28      -7.673   3.600  32.350  1.00 28.80           C  
ATOM    209  CD2 TYR A  28      -7.068   2.081  30.605  1.00 31.63           C  
ATOM    210  CE1 TYR A  28      -8.870   2.908  32.550  1.00 30.10           C  
ATOM    211  CE2 TYR A  28      -8.271   1.374  30.795  1.00 31.45           C  
ATOM    212  CZ  TYR A  28      -9.163   1.798  31.770  1.00 32.26           C  
ATOM    213  OH  TYR A  28     -10.345   1.118  31.968  1.00 32.65           O  
ATOM    214  N   PHE A  29      -4.120   6.663  31.428  1.00 25.20           N  
ATOM    215  CA  PHE A  29      -2.876   7.351  31.679  1.00 25.54           C  
ATOM    216  C   PHE A  29      -2.598   6.920  33.091  1.00 27.37           C  
ATOM    217  O   PHE A  29      -3.387   7.188  33.996  1.00 30.03           O  
ATOM    218  CB  PHE A  29      -3.031   8.867  31.605  1.00 26.06           C  
ATOM    219  CG  PHE A  29      -3.169   9.378  30.212  1.00 26.76           C  
ATOM    220  CD1 PHE A  29      -4.399   9.343  29.564  1.00 27.36           C  
ATOM    221  CD2 PHE A  29      -2.057   9.839  29.520  1.00 26.02           C  
ATOM    222  CE1 PHE A  29      -4.517   9.758  28.241  1.00 29.38           C  
ATOM    223  CE2 PHE A  29      -2.159  10.255  28.197  1.00 26.01           C  
ATOM    224  CZ  PHE A  29      -3.389  10.215  27.555  1.00 27.94           C  
ATOM    225  N   GLU A  30      -1.503   6.206  33.277  1.00 29.67           N  
ATOM    226  CA  GLU A  30      -1.150   5.751  34.597  1.00 33.49           C  
ATOM    227  C   GLU A  30       0.212   6.261  35.012  1.00 34.18           C  
ATOM    228  O   GLU A  30       1.039   6.629  34.179  1.00 35.23           O  
ATOM    229  CB  GLU A  30      -1.201   4.225  34.661  1.00 39.89           C  
ATOM    230  CG  GLU A  30      -0.503   3.509  33.537  1.00 42.81           C  
ATOM    231  CD  GLU A  30      -0.627   1.992  33.652  1.00 45.98           C  
ATOM    232  OE1 GLU A  30      -1.761   1.464  33.599  1.00 43.19           O  
ATOM    233  OE2 GLU A  30       0.421   1.324  33.796  1.00 49.76           O  
ATOM    234  N   VAL A  31       0.412   6.309  36.320  1.00 30.73           N  
ATOM    235  CA  VAL A  31       1.660   6.751  36.911  1.00 33.26           C  
ATOM    236  C   VAL A  31       2.065   5.631  37.857  1.00 35.58           C  
ATOM    237  O   VAL A  31       1.330   5.301  38.784  1.00 35.95           O  
ATOM    238  CB  VAL A  31       1.472   8.062  37.720  1.00 34.75           C  
ATOM    239  CG1 VAL A  31       2.725   8.373  38.521  1.00 35.82           C  
ATOM    240  CG2 VAL A  31       1.171   9.206  36.787  1.00 32.22           C  
ATOM    241  N   ASN A  32       3.217   5.020  37.601  1.00 55.28           N  
ATOM    242  CA  ASN A  32       3.712   3.943  38.457  1.00 57.88           C  
ATOM    243  C   ASN A  32       2.781   2.724  38.465  1.00 55.65           C  
ATOM    244  O   ASN A  32       2.472   2.169  39.522  1.00 57.19           O  
ATOM    245  CB  ASN A  32       3.903   4.477  39.887  1.00 80.44           C  
ATOM    246  CG  ASN A  32       4.748   3.563  40.743  1.00 84.46           C  
ATOM    247  OD1 ASN A  32       5.807   3.097  40.314  1.00 87.35           O  
ATOM    248  ND2 ASN A  32       4.296   3.309  41.968  1.00 86.18           N  
ATOM    249  N   GLY A  33       2.336   2.317  37.279  1.00 39.02           N  
ATOM    250  CA  GLY A  33       1.460   1.166  37.154  1.00 35.09           C  
ATOM    251  C   GLY A  33       0.017   1.352  37.593  1.00 32.62           C  
ATOM    252  O   GLY A  33      -0.812   0.461  37.415  1.00 32.31           O  
ATOM    253  N   GLU A  34      -0.296   2.509  38.160  1.00 32.10           N  
ATOM    254  CA  GLU A  34      -1.652   2.774  38.629  1.00 30.02           C  
ATOM    255  C   GLU A  34      -2.449   3.713  37.714  1.00 27.50           C  
ATOM    256  O   GLU A  34      -1.980   4.787  37.343  1.00 26.18           O  
ATOM    257  CB  GLU A  34      -1.594   3.362  40.040  1.00 32.58           C  
ATOM    258  CG  GLU A  34      -2.938   3.719  40.633  1.00 32.61           C  
ATOM    259  CD  GLU A  34      -2.801   4.468  41.945  1.00 33.93           C  
ATOM    260  OE1 GLU A  34      -1.944   5.377  42.015  1.00 35.53           O  
ATOM    261  OE2 GLU A  34      -3.550   4.155  42.897  1.00 34.01           O  
ATOM    262  N   LYS A  35      -3.662   3.302  37.367  1.00 26.42           N  
ATOM    263  CA  LYS A  35      -4.526   4.107  36.514  1.00 25.95           C  
ATOM    264  C   LYS A  35      -4.960   5.378  37.238  1.00 24.22           C  
ATOM    265  O   LYS A  35      -5.641   5.315  38.253  1.00 22.24           O  
ATOM    266  CB  LYS A  35      -5.769   3.311  36.103  1.00 29.54           C  
ATOM    267  CG  LYS A  35      -5.498   2.131  35.182  1.00 31.43           C  
ATOM    268  CD  LYS A  35      -6.720   1.232  35.100  1.00 32.91           C  
ATOM    269  CE  LYS A  35      -6.566   0.150  34.038  1.00 35.84           C  
ATOM    270  NZ  LYS A  35      -5.403  -0.743  34.295  1.00 37.65           N  
ATOM    271  N   ILE A  36      -4.562   6.529  36.704  1.00 24.17           N  
ATOM    272  CA  ILE A  36      -4.928   7.806  37.288  1.00 22.84           C  
ATOM    273  C   ILE A  36      -6.192   8.314  36.612  1.00 22.59           C  
ATOM    274  O   ILE A  36      -7.093   8.823  37.277  1.00 24.05           O  
ATOM    275  CB  ILE A  36      -3.821   8.855  37.106  1.00 22.50           C  
ATOM    276  CG1 ILE A  36      -2.538   8.370  37.774  1.00 23.62           C  
ATOM    277  CG2 ILE A  36      -4.260  10.182  37.701  1.00 21.83           C  
ATOM    278  CD1 ILE A  36      -2.575   8.106  39.307  1.00 39.50           C  
ATOM    279  N   CYS A  37      -6.245   8.169  35.290  1.00 19.86           N  
ATOM    280  CA  CYS A  37      -7.398   8.604  34.510  1.00 19.95           C  
ATOM    281  C   CYS A  37      -7.479   7.951  33.118  1.00 21.31           C  
ATOM    282  O   CYS A  37      -6.525   7.350  32.629  1.00 20.32           O  
ATOM    283  CB  CYS A  37      -7.375  10.134  34.353  1.00 20.53           C  
ATOM    284  SG  CYS A  37      -5.997  10.778  33.353  1.00 21.26           S  
ATOM    285  N   SER A  38      -8.645   8.051  32.494  1.00 25.33           N  
ATOM    286  CA  SER A  38      -8.829   7.523  31.156  1.00 26.31           C  
ATOM    287  C   SER A  38      -9.539   8.597  30.335  1.00 27.63           C  
ATOM    288  O   SER A  38     -10.298   9.411  30.870  1.00 26.76           O  
ATOM    289  CB  SER A  38      -9.660   6.249  31.183  1.00 28.06           C  
ATOM    290  OG  SER A  38     -10.969   6.510  31.640  1.00 35.60           O  
ATOM    291  N   VAL A  39      -9.268   8.623  29.039  1.00 24.68           N  
ATOM    292  CA  VAL A  39      -9.908   9.599  28.182  1.00 25.76           C  
ATOM    293  C   VAL A  39     -10.604   8.883  27.035  1.00 25.04           C  
ATOM    294  O   VAL A  39     -10.061   7.958  26.444  1.00 23.87           O  
ATOM    295  CB  VAL A  39      -8.880  10.629  27.625  1.00 34.34           C  
ATOM    296  CG1 VAL A  39      -7.763   9.906  26.896  1.00 36.37           C  
ATOM    297  CG2 VAL A  39      -9.573  11.613  26.683  1.00 34.14           C  
ATOM    298  N   LYS A  40     -11.823   9.308  26.747  1.00 24.37           N  
ATOM    299  CA  LYS A  40     -12.597   8.721  25.669  1.00 25.27           C  
ATOM    300  C   LYS A  40     -12.909   9.815  24.650  1.00 26.35           C  
ATOM    301  O   LYS A  40     -13.307  10.931  25.012  1.00 25.40           O  
ATOM    302  CB  LYS A  40     -13.884   8.124  26.228  1.00 36.57           C  
ATOM    303  CG  LYS A  40     -14.666   7.275  25.255  1.00 41.00           C  
ATOM    304  CD  LYS A  40     -15.767   6.514  25.987  1.00 44.57           C  
ATOM    305  CE  LYS A  40     -16.489   5.547  25.063  1.00 47.11           C  
ATOM    306  NZ  LYS A  40     -17.524   4.758  25.784  1.00 49.19           N  
ATOM    307  N   TYR A  41     -12.694   9.510  23.379  1.00 27.87           N  
ATOM    308  CA  TYR A  41     -12.964  10.473  22.326  1.00 30.54           C  
ATOM    309  C   TYR A  41     -14.256  10.149  21.603  1.00 33.19           C  
ATOM    310  O   TYR A  41     -14.401   9.055  21.055  1.00 33.16           O  
ATOM    311  CB  TYR A  41     -11.824  10.504  21.306  1.00 32.22           C  
ATOM    312  CG  TYR A  41     -12.073  11.493  20.194  1.00 31.97           C  
ATOM    313  CD1 TYR A  41     -12.015  12.863  20.438  1.00 31.90           C  
ATOM    314  CD2 TYR A  41     -12.392  11.068  18.906  1.00 32.56           C  
ATOM    315  CE1 TYR A  41     -12.262  13.794  19.432  1.00 32.58           C  
ATOM    316  CE2 TYR A  41     -12.645  11.993  17.880  1.00 34.48           C  
ATOM    317  CZ  TYR A  41     -12.577  13.356  18.155  1.00 34.92           C  
ATOM    318  OH  TYR A  41     -12.808  14.280  17.160  1.00 33.76           O  
ATOM    319  N   PHE A  42     -15.193  11.094  21.607  1.00 28.28           N  
ATOM    320  CA  PHE A  42     -16.463  10.905  20.914  1.00 32.31           C  
ATOM    321  C   PHE A  42     -16.458  11.744  19.646  1.00 34.34           C  
ATOM    322  O   PHE A  42     -16.403  12.966  19.718  1.00 34.31           O  
ATOM    323  CB  PHE A  42     -17.638  11.339  21.792  1.00 42.21           C  
ATOM    324  CG  PHE A  42     -17.789  10.538  23.048  1.00 44.17           C  
ATOM    325  CD1 PHE A  42     -16.986  10.790  24.155  1.00 44.68           C  
ATOM    326  CD2 PHE A  42     -18.725   9.517  23.123  1.00 44.85           C  
ATOM    327  CE1 PHE A  42     -17.117  10.031  25.317  1.00 46.53           C  
ATOM    328  CE2 PHE A  42     -18.863   8.753  24.281  1.00 45.69           C  
ATOM    329  CZ  PHE A  42     -18.059   9.010  25.377  1.00 46.85           C  
ATOM    330  N   GLU A  43     -16.503  11.096  18.484  1.00 78.80           N  
ATOM    331  CA  GLU A  43     -16.517  11.836  17.222  1.00 83.43           C  
ATOM    332  C   GLU A  43     -17.932  12.301  16.921  1.00 85.33           C  
ATOM    333  O   GLU A  43     -18.289  12.550  15.770  1.00 86.63           O  
ATOM    334  CB  GLU A  43     -16.000  10.975  16.075  1.00 88.26           C  
ATOM    335  CG  GLU A  43     -16.924   9.854  15.674  1.00 91.26           C  
ATOM    336  CD  GLU A  43     -16.163   8.581  15.400  1.00 92.04           C  
ATOM    337  OE1 GLU A  43     -15.543   8.050  16.345  1.00 92.07           O  
ATOM    338  OE2 GLU A  43     -16.181   8.120  14.243  1.00 92.69           O  
ATOM    339  N   LYS A  44     -18.727  12.401  17.983  1.00 82.76           N  
ATOM    340  CA  LYS A  44     -20.107  12.866  17.921  1.00 82.08           C  
ATOM    341  C   LYS A  44     -19.968  14.367  18.128  1.00 81.44           C  
ATOM    342  O   LYS A  44     -20.855  15.057  18.636  1.00 81.25           O  
ATOM    343  CB  LYS A  44     -20.921  12.230  19.047  1.00 63.07           C  
ATOM    344  CG  LYS A  44     -20.939  10.706  19.001  1.00 63.71           C  
ATOM    345  CD  LYS A  44     -19.614  10.109  19.452  1.00 63.60           C  
ATOM    346  CE  LYS A  44     -19.548   8.609  19.217  1.00 62.70           C  
ATOM    347  NZ  LYS A  44     -19.375   8.296  17.776  1.00 63.81           N  
ATOM    348  N   ASN A  45     -18.799  14.825  17.712  1.00 58.92           N  
ATOM    349  CA  ASN A  45     -18.332  16.198  17.768  1.00 59.10           C  
ATOM    350  C   ASN A  45     -16.845  15.888  17.694  1.00 57.74           C  
ATOM    351  O   ASN A  45     -16.446  14.917  17.049  1.00 57.49           O  
ATOM    352  CB  ASN A  45     -18.659  16.858  19.111  1.00 67.64           C  
ATOM    353  CG  ASN A  45     -18.491  18.381  19.077  1.00 69.97           C  
ATOM    354  OD1 ASN A  45     -19.457  19.126  18.870  1.00 68.79           O  
ATOM    355  ND2 ASN A  45     -17.258  18.845  19.270  1.00 69.23           N  
ATOM    356  N   GLN A  46     -16.029  16.682  18.366  1.00 63.16           N  
ATOM    357  CA  GLN A  46     -14.594  16.444  18.368  1.00 60.66           C  
ATOM    358  C   GLN A  46     -14.192  16.589  19.828  1.00 57.87           C  
ATOM    359  O   GLN A  46     -13.174  17.205  20.143  1.00 59.46           O  
ATOM    360  CB  GLN A  46     -13.893  17.501  17.509  1.00 61.65           C  
ATOM    361  CG  GLN A  46     -14.561  17.745  16.152  1.00 63.38           C  
ATOM    362  CD  GLN A  46     -14.207  16.691  15.117  1.00 65.08           C  
ATOM    363  OE1 GLN A  46     -13.094  16.678  14.593  1.00 66.87           O  
ATOM    364  NE2 GLN A  46     -15.149  15.800  14.822  1.00 63.05           N  
ATOM    365  N   THR A  47     -14.995  15.997  20.711  1.00 41.39           N  
ATOM    366  CA  THR A  47     -14.773  16.099  22.149  1.00 36.92           C  
ATOM    367  C   THR A  47     -14.162  14.919  22.892  1.00 33.87           C  
ATOM    368  O   THR A  47     -14.279  13.758  22.501  1.00 32.49           O  
ATOM    369  CB  THR A  47     -16.083  16.444  22.878  1.00 39.03           C  
ATOM    370  OG1 THR A  47     -16.981  15.328  22.800  1.00 36.86           O  
ATOM    371  CG2 THR A  47     -16.737  17.675  22.250  1.00 38.96           C  
ATOM    372  N   PHE A  48     -13.520  15.247  24.000  1.00 37.11           N  
ATOM    373  CA  PHE A  48     -12.893  14.257  24.846  1.00 35.48           C  
ATOM    374  C   PHE A  48     -13.630  14.223  26.168  1.00 34.19           C  
ATOM    375  O   PHE A  48     -14.092  15.254  26.662  1.00 34.14           O  
ATOM    376  CB  PHE A  48     -11.437  14.620  25.109  1.00 27.48           C  
ATOM    377  CG  PHE A  48     -10.588  14.658  23.875  1.00 29.26           C  
ATOM    378  CD1 PHE A  48     -10.675  15.722  22.985  1.00 28.87           C  
ATOM    379  CD2 PHE A  48      -9.708  13.623  23.593  1.00 28.91           C  
ATOM    380  CE1 PHE A  48      -9.896  15.752  21.832  1.00 29.12           C  
ATOM    381  CE2 PHE A  48      -8.926  13.644  22.443  1.00 26.42           C  
ATOM    382  CZ  PHE A  48      -9.019  14.703  21.564  1.00 26.65           C  
ATOM    383  N   GLU A  49     -13.767  13.030  26.726  1.00 27.24           N  
ATOM    384  CA  GLU A  49     -14.403  12.877  28.020  1.00 26.24           C  
ATOM    385  C   GLU A  49     -13.342  12.309  28.959  1.00 24.69           C  
ATOM    386  O   GLU A  49     -12.848  11.200  28.763  1.00 23.92           O  
ATOM    387  CB  GLU A  49     -15.589  11.926  27.940  1.00 37.35           C  
ATOM    388  CG  GLU A  49     -16.311  11.780  29.266  1.00 41.61           C  
ATOM    389  CD  GLU A  49     -17.381  10.713  29.229  1.00 43.84           C  
ATOM    390  OE1 GLU A  49     -17.038   9.531  29.000  1.00 48.77           O  
ATOM    391  OE2 GLU A  49     -18.562  11.055  29.430  1.00 44.34           O  
ATOM    392  N   LEU A  50     -12.971  13.091  29.959  1.00 27.28           N  
ATOM    393  CA  LEU A  50     -11.971  12.656  30.914  1.00 25.67           C  
ATOM    394  C   LEU A  50     -12.617  12.091  32.180  1.00 23.61           C  
ATOM    395  O   LEU A  50     -13.472  12.723  32.795  1.00 21.80           O  
ATOM    396  CB  LEU A  50     -11.064  13.824  31.276  1.00 26.98           C  
ATOM    397  CG  LEU A  50      -9.928  13.534  32.258  1.00 28.88           C  
ATOM    398  CD1 LEU A  50      -8.792  12.805  31.557  1.00 26.84           C  
ATOM    399  CD2 LEU A  50      -9.427  14.843  32.835  1.00 29.96           C  
ATOM    400  N   THR A  51     -12.201  10.887  32.546  1.00 23.94           N  
ATOM    401  CA  THR A  51     -12.692  10.212  33.736  1.00 21.52           C  
ATOM    402  C   THR A  51     -11.543  10.148  34.743  1.00 21.68           C  
ATOM    403  O   THR A  51     -10.469   9.623  34.442  1.00 19.67           O  
ATOM    404  CB  THR A  51     -13.185   8.800  33.379  1.00 20.90           C  
ATOM    405  OG1 THR A  51     -14.297   8.912  32.481  1.00 20.45           O  
ATOM    406  CG2 THR A  51     -13.624   8.050  34.617  1.00 18.09           C  
ATOM    407  N   VAL A  52     -11.776  10.710  35.929  1.00 21.36           N  
ATOM    408  CA  VAL A  52     -10.775  10.765  36.992  1.00 21.84           C  
ATOM    409  C   VAL A  52     -11.121   9.775  38.101  1.00 22.83           C  
ATOM    410  O   VAL A  52     -12.158   9.896  38.759  1.00 22.12           O  
ATOM    411  CB  VAL A  52     -10.711  12.181  37.610  1.00 23.13           C  
ATOM    412  CG1 VAL A  52      -9.545  12.273  38.591  1.00 20.82           C  
ATOM    413  CG2 VAL A  52     -10.604  13.226  36.508  1.00 23.67           C  
ATOM    414  N   PHE A  53     -10.242   8.812  38.333  1.00 22.85           N  
ATOM    415  CA  PHE A  53     -10.513   7.799  39.346  1.00 24.39           C  
ATOM    416  C   PHE A  53     -10.234   8.233  40.783  1.00 24.98           C  
ATOM    417  O   PHE A  53      -9.381   9.085  41.050  1.00 23.57           O  
ATOM    418  CB  PHE A  53      -9.725   6.520  39.018  1.00 20.12           C  
ATOM    419  CG  PHE A  53     -10.010   5.976  37.639  1.00 21.40           C  
ATOM    420  CD1 PHE A  53     -11.277   5.492  37.317  1.00 18.76           C  
ATOM    421  CD2 PHE A  53      -9.030   6.003  36.645  1.00 20.19           C  
ATOM    422  CE1 PHE A  53     -11.566   5.047  36.023  1.00 22.26           C  
ATOM    423  CE2 PHE A  53      -9.307   5.561  35.347  1.00 20.71           C  
ATOM    424  CZ  PHE A  53     -10.576   5.083  35.034  1.00 21.77           C  
ATOM    425  N   GLN A  54     -10.995   7.655  41.698  1.00 29.29           N  
ATOM    426  CA  GLN A  54     -10.833   7.906  43.122  1.00 33.73           C  
ATOM    427  C   GLN A  54     -11.212   6.600  43.821  1.00 32.48           C  
ATOM    428  O   GLN A  54     -12.306   6.081  43.610  1.00 33.58           O  
ATOM    429  CB  GLN A  54     -11.742   9.047  43.600  1.00 42.36           C  
ATOM    430  CG  GLN A  54     -11.620   9.319  45.098  1.00 46.39           C  
ATOM    431  CD  GLN A  54     -12.523  10.444  45.597  1.00 51.42           C  
ATOM    432  OE1 GLN A  54     -13.740  10.429  45.381  1.00 51.53           O  
ATOM    433  NE2 GLN A  54     -11.930  11.417  46.288  1.00 52.87           N  
ATOM    434  N   LYS A  55     -10.304   6.069  44.632  1.00 23.46           N  
ATOM    435  CA  LYS A  55     -10.551   4.820  45.345  1.00 24.74           C  
ATOM    436  C   LYS A  55     -11.858   4.751  46.146  1.00 24.90           C  
ATOM    437  O   LYS A  55     -12.218   5.680  46.877  1.00 27.26           O  
ATOM    438  CB  LYS A  55      -9.385   4.519  46.279  1.00 29.14           C  
ATOM    439  CG  LYS A  55      -8.095   4.129  45.592  1.00 29.98           C  
ATOM    440  CD  LYS A  55      -7.076   3.678  46.628  1.00 33.69           C  
ATOM    441  CE  LYS A  55      -5.791   3.208  45.995  1.00 34.86           C  
ATOM    442  NZ  LYS A  55      -4.812   2.792  47.034  1.00 37.98           N  
ATOM    443  N   GLY A  56     -12.561   3.634  45.998  1.00 27.61           N  
ATOM    444  CA  GLY A  56     -13.813   3.427  46.706  1.00 28.47           C  
ATOM    445  C   GLY A  56     -14.910   4.389  46.300  1.00 29.47           C  
ATOM    446  O   GLY A  56     -16.002   4.389  46.878  1.00 29.93           O  
ATOM    447  N   GLU A  57     -14.631   5.197  45.285  1.00 28.95           N  
ATOM    448  CA  GLU A  57     -15.591   6.183  44.823  1.00 30.81           C  
ATOM    449  C   GLU A  57     -15.928   6.044  43.340  1.00 30.50           C  
ATOM    450  O   GLU A  57     -15.119   5.570  42.548  1.00 32.64           O  
ATOM    451  CB  GLU A  57     -15.029   7.583  45.085  1.00 34.19           C  
ATOM    452  CG  GLU A  57     -16.017   8.541  45.700  1.00 39.13           C  
ATOM    453  CD  GLU A  57     -16.459   8.112  47.088  1.00 39.77           C  
ATOM    454  OE1 GLU A  57     -15.722   8.374  48.067  1.00 39.91           O  
ATOM    455  OE2 GLU A  57     -17.546   7.504  47.190  1.00 39.43           O  
ATOM    456  N   LYS A  58     -17.134   6.449  42.977  1.00 24.16           N  
ATOM    457  CA  LYS A  58     -17.566   6.432  41.585  1.00 24.65           C  
ATOM    458  C   LYS A  58     -16.708   7.514  40.904  1.00 21.47           C  
ATOM    459  O   LYS A  58     -16.547   8.611  41.434  1.00 18.71           O  
ATOM    460  CB  LYS A  58     -19.055   6.795  41.531  1.00 49.92           C  
ATOM    461  CG  LYS A  58     -19.686   6.870  40.163  1.00 55.70           C  
ATOM    462  CD  LYS A  58     -21.178   7.163  40.327  1.00 60.91           C  
ATOM    463  CE  LYS A  58     -21.924   7.142  39.002  1.00 63.25           C  
ATOM    464  NZ  LYS A  58     -21.449   8.210  38.084  1.00 64.08           N  
ATOM    465  N   PRO A  59     -16.142   7.222  39.725  1.00 27.42           N  
ATOM    466  CA  PRO A  59     -15.317   8.257  39.086  1.00 28.89           C  
ATOM    467  C   PRO A  59     -16.078   9.450  38.509  1.00 27.24           C  
ATOM    468  O   PRO A  59     -17.240   9.338  38.123  1.00 27.60           O  
ATOM    469  CB  PRO A  59     -14.558   7.475  38.010  1.00 22.06           C  
ATOM    470  CG  PRO A  59     -15.553   6.432  37.604  1.00 22.48           C  
ATOM    471  CD  PRO A  59     -16.133   5.975  38.940  1.00 20.81           C  
ATOM    472  N   ASN A  60     -15.411  10.594  38.456  1.00 23.05           N  
ATOM    473  CA  ASN A  60     -16.022  11.795  37.898  1.00 23.26           C  
ATOM    474  C   ASN A  60     -15.558  12.026  36.470  1.00 22.42           C  
ATOM    475  O   ASN A  60     -14.404  11.767  36.136  1.00 22.38           O  
ATOM    476  CB  ASN A  60     -15.705  13.004  38.774  1.00 25.98           C  
ATOM    477  CG  ASN A  60     -16.654  13.121  39.954  1.00 25.64           C  
ATOM    478  OD1 ASN A  60     -17.163  12.123  40.450  1.00 26.45           O  
ATOM    479  ND2 ASN A  60     -16.894  14.347  40.408  1.00 31.50           N  
ATOM    480  N   THR A  61     -16.472  12.489  35.623  1.00 26.58           N  
ATOM    481  CA  THR A  61     -16.151  12.747  34.225  1.00 25.75           C  
ATOM    482  C   THR A  61     -16.268  14.222  33.894  1.00 24.56           C  
ATOM    483  O   THR A  61     -17.111  14.921  34.437  1.00 26.72           O  
ATOM    484  CB  THR A  61     -17.079  11.995  33.292  1.00 26.67           C  
ATOM    485  OG1 THR A  61     -18.404  12.513  33.434  1.00 31.38           O  
ATOM    486  CG2 THR A  61     -17.071  10.521  33.613  1.00 26.24           C  
ATOM    487  N   TYR A  62     -15.412  14.679  32.992  1.00 22.47           N  
ATOM    488  CA  TYR A  62     -15.387  16.073  32.574  1.00 21.00           C  
ATOM    489  C   TYR A  62     -15.255  16.165  31.060  1.00 20.89           C  
ATOM    490  O   TYR A  62     -14.337  15.586  30.471  1.00 21.91           O  
ATOM    491  CB  TYR A  62     -14.205  16.798  33.219  1.00 17.41           C  
ATOM    492  CG  TYR A  62     -14.149  16.631  34.712  1.00 19.18           C  
ATOM    493  CD1 TYR A  62     -13.571  15.496  35.290  1.00 18.13           C  
ATOM    494  CD2 TYR A  62     -14.720  17.581  35.557  1.00 19.66           C  
ATOM    495  CE1 TYR A  62     -13.564  15.314  36.677  1.00 18.77           C  
ATOM    496  CE2 TYR A  62     -14.727  17.412  36.944  1.00 18.22           C  
ATOM    497  CZ  TYR A  62     -14.145  16.279  37.499  1.00 21.19           C  
ATOM    498  OH  TYR A  62     -14.140  16.119  38.870  1.00 24.29           O  
ATOM    499  N   PRO A  63     -16.183  16.881  30.405  1.00 21.50           N  
ATOM    500  CA  PRO A  63     -16.095  17.002  28.947  1.00 21.30           C  
ATOM    501  C   PRO A  63     -15.121  18.107  28.517  1.00 20.83           C  
ATOM    502  O   PRO A  63     -14.942  19.094  29.216  1.00 22.51           O  
ATOM    503  CB  PRO A  63     -17.535  17.289  28.546  1.00 21.05           C  
ATOM    504  CG  PRO A  63     -18.033  18.122  29.690  1.00 20.37           C  
ATOM    505  CD  PRO A  63     -17.460  17.423  30.908  1.00 19.83           C  
ATOM    506  N   PHE A  64     -14.465  17.899  27.382  1.00 21.24           N  
ATOM    507  CA  PHE A  64     -13.516  18.852  26.810  1.00 21.59           C  
ATOM    508  C   PHE A  64     -13.681  18.759  25.297  1.00 23.89           C  
ATOM    509  O   PHE A  64     -13.809  17.666  24.747  1.00 23.78           O  
ATOM    510  CB  PHE A  64     -12.063  18.498  27.154  1.00 21.29           C  
ATOM    511  CG  PHE A  64     -11.707  18.686  28.600  1.00 24.74           C  
ATOM    512  CD1 PHE A  64     -11.973  17.694  29.536  1.00 23.73           C  
ATOM    513  CD2 PHE A  64     -11.103  19.866  29.031  1.00 24.38           C  
ATOM    514  CE1 PHE A  64     -11.644  17.872  30.881  1.00 24.76           C  
ATOM    515  CE2 PHE A  64     -10.773  20.054  30.370  1.00 24.71           C  
ATOM    516  CZ  PHE A  64     -11.045  19.051  31.296  1.00 25.94           C  
ATOM    517  N   ASP A  65     -13.681  19.901  24.624  1.00 28.94           N  
ATOM    518  CA  ASP A  65     -13.822  19.911  23.175  1.00 32.85           C  
ATOM    519  C   ASP A  65     -12.505  20.326  22.551  1.00 33.72           C  
ATOM    520  O   ASP A  65     -12.387  20.411  21.333  1.00 37.74           O  
ATOM    521  CB  ASP A  65     -14.929  20.876  22.739  1.00 47.15           C  
ATOM    522  CG  ASP A  65     -14.691  22.292  23.221  1.00 52.32           C  
ATOM    523  OD1 ASP A  65     -14.731  22.519  24.449  1.00 55.88           O  
ATOM    524  OD2 ASP A  65     -14.455  23.181  22.375  1.00 56.42           O  
ATOM    525  N   ASN A  66     -11.505  20.562  23.391  1.00 29.10           N  
ATOM    526  CA  ASN A  66     -10.204  20.966  22.901  1.00 28.80           C  
ATOM    527  C   ASN A  66      -9.076  20.081  23.434  1.00 29.26           C  
ATOM    528  O   ASN A  66      -8.853  19.987  24.638  1.00 28.69           O  
ATOM    529  CB  ASN A  66      -9.943  22.422  23.275  1.00 38.12           C  
ATOM    530  CG  ASN A  66      -8.612  22.913  22.767  1.00 39.52           C  
ATOM    531  OD1 ASN A  66      -7.573  22.350  23.099  1.00 40.79           O  
ATOM    532  ND2 ASN A  66      -8.634  23.962  21.952  1.00 42.10           N  
ATOM    533  N   ILE A  67      -8.359  19.452  22.511  1.00 29.54           N  
ATOM    534  CA  ILE A  67      -7.259  18.561  22.834  1.00 29.10           C  
ATOM    535  C   ILE A  67      -6.163  19.174  23.724  1.00 29.68           C  
ATOM    536  O   ILE A  67      -5.603  18.493  24.586  1.00 28.36           O  
ATOM    537  CB  ILE A  67      -6.624  18.028  21.540  1.00 33.68           C  
ATOM    538  CG1 ILE A  67      -5.660  16.891  21.865  1.00 33.24           C  
ATOM    539  CG2 ILE A  67      -5.902  19.160  20.807  1.00 32.23           C  
ATOM    540  CD1 ILE A  67      -4.253  17.226  22.427  1.00 39.50           C  
ATOM    541  N   ASP A  68      -5.856  20.449  23.526  1.00 33.53           N  
ATOM    542  CA  ASP A  68      -4.820  21.083  24.333  1.00 35.56           C  
ATOM    543  C   ASP A  68      -5.269  21.242  25.772  1.00 35.10           C  
ATOM    544  O   ASP A  68      -4.473  21.093  26.699  1.00 34.52           O  
ATOM    545  CB  ASP A  68      -4.428  22.463  23.766  1.00 37.14           C  
ATOM    546  CG  ASP A  68      -3.588  22.362  22.503  1.00 38.43           C  
ATOM    547  OD1 ASP A  68      -2.883  21.348  22.338  1.00 37.48           O  
ATOM    548  OD2 ASP A  68      -3.618  23.302  21.681  1.00 41.00           O  
HETATM  549  N   MSE A  69      -6.550  21.536  25.956  1.00 31.72           N  
HETATM  550  CA  MSE A  69      -7.097  21.720  27.284  1.00 31.48           C  
HETATM  551  C   MSE A  69      -7.288  20.435  28.081  1.00 28.39           C  
HETATM  552  O   MSE A  69      -7.165  20.442  29.303  1.00 27.84           O  
HETATM  553  CB  MSE A  69      -8.399  22.489  27.177  1.00 53.52           C  
HETATM  554  CG  MSE A  69      -8.155  23.900  26.695  1.00 62.42           C  
HETATM  555 SE   MSE A  69      -9.755  24.883  26.407  1.00 76.94          SE  
HETATM  556  CE  MSE A  69     -10.300  25.073  28.259  1.00 69.49           C  
ATOM    557  N   VAL A  70      -7.595  19.334  27.407  1.00 23.20           N  
ATOM    558  CA  VAL A  70      -7.760  18.080  28.112  1.00 20.57           C  
ATOM    559  C   VAL A  70      -6.359  17.567  28.455  1.00 20.27           C  
ATOM    560  O   VAL A  70      -6.136  16.998  29.514  1.00 22.36           O  
ATOM    561  CB  VAL A  70      -8.536  17.053  27.257  1.00 26.10           C  
ATOM    562  CG1 VAL A  70      -7.782  16.757  25.964  1.00 24.27           C  
ATOM    563  CG2 VAL A  70      -8.774  15.784  28.067  1.00 24.59           C  
ATOM    564  N   SER A  71      -5.405  17.812  27.561  1.00 20.83           N  
ATOM    565  CA  SER A  71      -4.026  17.405  27.775  1.00 19.43           C  
ATOM    566  C   SER A  71      -3.438  18.067  29.017  1.00 20.39           C  
ATOM    567  O   SER A  71      -2.718  17.442  29.792  1.00 20.24           O  
ATOM    568  CB  SER A  71      -3.173  17.772  26.565  1.00 17.23           C  
ATOM    569  OG  SER A  71      -3.513  16.995  25.422  1.00 22.21           O  
ATOM    570  N   ILE A  72      -3.748  19.346  29.191  1.00 26.62           N  
ATOM    571  CA  ILE A  72      -3.259  20.123  30.319  1.00 26.23           C  
ATOM    572  C   ILE A  72      -3.797  19.561  31.626  1.00 26.32           C  
ATOM    573  O   ILE A  72      -3.066  19.392  32.606  1.00 27.32           O  
ATOM    574  CB  ILE A  72      -3.689  21.594  30.160  1.00 21.38           C  
ATOM    575  CG1 ILE A  72      -2.902  22.213  29.007  1.00 21.42           C  
ATOM    576  CG2 ILE A  72      -3.495  22.361  31.458  1.00 15.50           C  
ATOM    577  CD1 ILE A  72      -3.442  23.549  28.502  1.00 39.50           C  
ATOM    578  N   GLU A  73      -5.089  19.280  31.622  1.00 23.40           N  
ATOM    579  CA  GLU A  73      -5.769  18.734  32.781  1.00 21.79           C  
ATOM    580  C   GLU A  73      -5.137  17.393  33.141  1.00 20.91           C  
ATOM    581  O   GLU A  73      -4.862  17.115  34.314  1.00 21.65           O  
ATOM    582  CB  GLU A  73      -7.251  18.555  32.443  1.00 22.79           C  
ATOM    583  CG  GLU A  73      -8.128  18.073  33.583  1.00 24.89           C  
ATOM    584  CD  GLU A  73      -8.411  19.155  34.603  1.00 24.74           C  
ATOM    585  OE1 GLU A  73      -8.518  20.337  34.210  1.00 21.07           O  
ATOM    586  OE2 GLU A  73      -8.548  18.812  35.797  1.00 29.38           O  
ATOM    587  N   ILE A  74      -4.904  16.558  32.133  1.00 21.20           N  
ATOM    588  CA  ILE A  74      -4.299  15.258  32.384  1.00 20.86           C  
ATOM    589  C   ILE A  74      -2.916  15.448  32.995  1.00 20.28           C  
ATOM    590  O   ILE A  74      -2.568  14.809  33.988  1.00 22.97           O  
ATOM    591  CB  ILE A  74      -4.169  14.426  31.102  1.00 20.84           C  
ATOM    592  CG1 ILE A  74      -5.558  14.112  30.538  1.00 23.60           C  
ATOM    593  CG2 ILE A  74      -3.457  13.114  31.413  1.00 20.26           C  
ATOM    594  CD1 ILE A  74      -6.765  14.998  30.888  1.00 39.50           C  
ATOM    595  N   PHE A  75      -2.136  16.342  32.401  1.00 19.34           N  
ATOM    596  CA  PHE A  75      -0.791  16.626  32.879  1.00 20.62           C  
ATOM    597  C   PHE A  75      -0.784  17.018  34.358  1.00 23.24           C  
ATOM    598  O   PHE A  75      -0.103  16.400  35.176  1.00 24.22           O  
ATOM    599  CB  PHE A  75      -0.168  17.751  32.044  1.00 17.42           C  
ATOM    600  CG  PHE A  75       1.206  18.156  32.500  1.00 17.71           C  
ATOM    601  CD1 PHE A  75       2.326  17.412  32.132  1.00 16.86           C  
ATOM    602  CD2 PHE A  75       1.378  19.255  33.337  1.00 17.10           C  
ATOM    603  CE1 PHE A  75       3.602  17.756  32.593  1.00 16.99           C  
ATOM    604  CE2 PHE A  75       2.648  19.607  33.805  1.00 20.29           C  
ATOM    605  CZ  PHE A  75       3.761  18.851  33.428  1.00 18.45           C  
ATOM    606  N   GLU A  76      -1.555  18.044  34.703  1.00 27.51           N  
ATOM    607  CA  GLU A  76      -1.601  18.502  36.083  1.00 29.41           C  
ATOM    608  C   GLU A  76      -2.063  17.392  37.027  1.00 29.30           C  
ATOM    609  O   GLU A  76      -1.625  17.301  38.172  1.00 29.26           O  
ATOM    610  CB  GLU A  76      -2.512  19.733  36.191  1.00 22.90           C  
ATOM    611  CG  GLU A  76      -2.077  20.877  35.274  1.00 23.74           C  
ATOM    612  CD  GLU A  76      -2.810  22.188  35.541  1.00 25.95           C  
ATOM    613  OE1 GLU A  76      -3.964  22.152  36.008  1.00 27.90           O  
ATOM    614  OE2 GLU A  76      -2.239  23.267  35.267  1.00 28.54           O  
ATOM    615  N   LEU A  77      -2.939  16.543  36.523  1.00 23.59           N  
ATOM    616  CA  LEU A  77      -3.478  15.436  37.299  1.00 26.81           C  
ATOM    617  C   LEU A  77      -2.386  14.396  37.566  1.00 27.15           C  
ATOM    618  O   LEU A  77      -2.284  13.841  38.659  1.00 27.62           O  
ATOM    619  CB  LEU A  77      -4.632  14.814  36.517  1.00 31.35           C  
ATOM    620  CG  LEU A  77      -5.904  14.363  37.216  1.00 32.27           C  
ATOM    621  CD1 LEU A  77      -6.375  15.402  38.251  1.00 30.81           C  
ATOM    622  CD2 LEU A  77      -6.953  14.144  36.133  1.00 30.40           C  
ATOM    623  N   LEU A  78      -1.564  14.142  36.559  1.00 33.65           N  
ATOM    624  CA  LEU A  78      -0.485  13.182  36.704  1.00 35.49           C  
ATOM    625  C   LEU A  78       0.635  13.786  37.532  1.00 37.85           C  
ATOM    626  O   LEU A  78       1.383  13.062  38.177  1.00 38.13           O  
ATOM    627  CB  LEU A  78       0.056  12.782  35.334  1.00 28.40           C  
ATOM    628  CG  LEU A  78      -0.950  12.093  34.409  1.00 28.66           C  
ATOM    629  CD1 LEU A  78      -0.356  11.960  33.032  1.00 27.72           C  
ATOM    630  CD2 LEU A  78      -1.323  10.734  34.963  1.00 28.34           C  
ATOM    631  N   GLN A  79       0.748  15.115  37.515  1.00 34.70           N  
ATOM    632  CA  GLN A  79       1.799  15.786  38.268  1.00 38.01           C  
ATOM    633  C   GLN A  79       1.568  15.619  39.745  1.00 41.84           C  
ATOM    634  O   GLN A  79       2.512  15.361  40.494  1.00 42.46           O  
ATOM    635  CB  GLN A  79       1.877  17.279  37.933  1.00 37.79           C  
ATOM    636  CG  GLN A  79       2.290  17.574  36.513  1.00 36.63           C  
ATOM    637  CD  GLN A  79       3.534  16.817  36.094  1.00 36.29           C  
ATOM    638  OE1 GLN A  79       4.622  17.042  36.626  1.00 35.36           O  
ATOM    639  NE2 GLN A  79       3.378  15.908  35.132  1.00 34.54           N  
ATOM    640  N   LEU A  80       0.318  15.768  40.174  1.00 47.14           N  
ATOM    641  CA  LEU A  80       0.026  15.594  41.583  1.00 51.60           C  
ATOM    642  C   LEU A  80       0.239  14.121  41.915  1.00 53.59           C  
ATOM    643  O   LEU A  80       0.247  13.725  43.081  1.00 54.34           O  
ATOM    644  CB  LEU A  80      -1.400  16.062  41.915  1.00 71.43           C  
ATOM    645  CG  LEU A  80      -2.656  15.551  41.207  1.00 73.77           C  
ATOM    646  CD1 LEU A  80      -2.971  14.112  41.618  1.00 74.76           C  
ATOM    647  CD2 LEU A  80      -3.814  16.467  41.582  1.00 73.35           C  
ATOM    648  N   GLU A  81       0.436  13.325  40.866  1.00 70.08           N  
ATOM    649  CA  GLU A  81       0.697  11.895  40.991  1.00 71.97           C  
ATOM    650  C   GLU A  81      -0.509  11.088  41.471  1.00 73.22           C  
ATOM    651  O   GLU A  81      -0.839  10.089  40.799  1.00 73.23           O  
ATOM    652  CB  GLU A  81       1.907  11.695  41.912  1.00 88.44           C  
ATOM    653  CG  GLU A  81       3.134  12.450  41.396  1.00 89.93           C  
ATOM    654  CD  GLU A  81       4.205  12.681  42.447  1.00 90.93           C  
ATOM    655  OE1 GLU A  81       3.883  13.226  43.526  1.00 90.93           O  
ATOM    656  OE2 GLU A  81       5.378  12.332  42.186  1.00 90.93           O  
TER     657      GLU A  81                                                      
END
MOLECULE T0443_97_116_136_173.pdb
ATOM    557  N   SER    97       9.444  13.904  25.999  1.00 32.65           N  
ATOM    558  CA  SER    97       9.019  13.771  27.400  1.00 32.55           C  
ATOM    559  C   SER    97       7.759  12.923  27.498  1.00 32.70           C  
ATOM    560  O   SER    97       7.026  12.769  26.517  1.00 33.71           O  
ATOM    561  CB  SER    97       8.716  15.139  27.997  1.00 32.59           C  
ATOM    562  OG  SER    97       7.547  15.663  27.400  1.00 31.84           O  
ATOM    563  N   ASP    98       7.467  12.409  28.690  1.00 33.19           N  
ATOM    564  CA  ASP    98       6.275  11.582  28.879  1.00 33.23           C  
ATOM    565  C   ASP    98       4.966  12.366  28.697  1.00 32.35           C  
ATOM    566  O   ASP    98       3.961  11.797  28.233  1.00 31.66           O  
ATOM    567  CB  ASP    98       6.314  10.868  30.227  1.00 34.81           C  
ATOM    568  CG  ASP    98       7.346   9.752  30.271  1.00 35.79           C  
ATOM    569  OD1 ASP    98       7.927   9.397  29.218  1.00 36.03           O  
ATOM    570  OD2 ASP    98       7.566   9.216  31.376  1.00 38.06           O  
ATOM    571  N   GLY    99       4.990  13.651  29.055  1.00 30.82           N  
ATOM    572  CA  GLY    99       3.842  14.548  28.894  1.00 30.89           C  
ATOM    573  C   GLY    99       3.507  14.851  27.439  1.00 31.23           C  
ATOM    574  O   GLY    99       2.338  14.867  27.051  1.00 32.26           O  
ATOM    575  N   ILE   100       4.532  15.128  26.633  1.00 31.16           N  
ATOM    576  CA  ILE   100       4.345  15.348  25.206  1.00 29.39           C  
ATOM    577  C   ILE   100       3.859  14.036  24.541  1.00 29.36           C  
ATOM    578  O   ILE   100       2.931  14.074  23.743  1.00 30.42           O  
ATOM    579  CB  ILE   100       5.637  15.902  24.562  1.00 30.48           C  
ATOM    580  CG1 ILE   100       5.934  17.321  25.075  1.00 31.37           C  
ATOM    581  CG2 ILE   100       5.542  15.941  23.038  1.00 30.03           C  
ATOM    582  CD1 ILE   100       4.947  18.391  24.593  1.00 31.63           C  
ATOM    583  N   LEU   101       4.433  12.889  24.915  1.00 27.54           N  
ATOM    584  CA  LEU   101       4.056  11.584  24.340  1.00 27.41           C  
ATOM    585  C   LEU   101       2.603  11.212  24.618  1.00 27.36           C  
ATOM    586  O   LEU   101       1.952  10.611  23.761  1.00 26.82           O  
ATOM    587  CB  LEU   101       4.997  10.452  24.813  1.00 27.14           C  
ATOM    588  CG  LEU   101       6.374  10.483  24.155  1.00 27.77           C  
ATOM    589  CD1 LEU   101       7.364   9.480  24.749  1.00 28.09           C  
ATOM    590  CD2 LEU   101       6.204  10.283  22.646  1.00 27.85           C  
ATOM    591  N   ALA   102       2.113  11.536  25.809  1.00 26.46           N  
ATOM    592  CA  ALA   102       0.725  11.313  26.148  1.00 27.20           C  
ATOM    593  C   ALA   102      -0.163  12.246  25.304  1.00 27.49           C  
ATOM    594  O   ALA   102      -1.179  11.829  24.744  1.00 28.34           O  
ATOM    595  CB  ALA   102       0.495  11.534  27.664  1.00 26.33           C  
ATOM    596  N   LEU   103       0.242  13.502  25.194  1.00 28.56           N  
ATOM    597  CA  LEU   103      -0.483  14.476  24.398  1.00 28.57           C  
ATOM    598  C   LEU   103      -0.498  14.094  22.928  1.00 30.29           C  
ATOM    599  O   LEU   103      -1.466  14.368  22.211  1.00 31.20           O  
ATOM    600  CB  LEU   103       0.150  15.852  24.550  1.00 27.97           C  
ATOM    601  CG  LEU   103      -0.540  16.927  23.734  1.00 27.93           C  
ATOM    602  CD1 LEU   103      -2.056  16.931  24.028  1.00 28.16           C  
ATOM    603  CD2 LEU   103       0.114  18.260  24.005  1.00 27.38           C  
ATOM    604  N   MET   104       0.578  13.477  22.459  1.00 30.91           N  
ATOM    605  CA  MET   104       0.587  13.021  21.088  1.00 31.03           C  
ATOM    606  C   MET   104      -0.356  11.843  20.907  1.00 31.30           C  
ATOM    607  O   MET   104      -1.078  11.768  19.908  1.00 31.91           O  
ATOM    608  CB  MET   104       2.011  12.700  20.593  1.00 29.78           C  
ATOM    609  CG  MET   104       2.852  13.953  20.409  1.00 29.50           C  
ATOM    610  SD  MET   104       4.547  13.560  19.600  0.75 28.40          SE  
ATOM    611  CE  MET   104       4.041  13.148  17.802  1.00 27.34           C  
ATOM    612  N   ASP   105      -0.376  10.926  21.857  1.00 31.23           N  
ATOM    613  CA  ASP   105      -1.286   9.791  21.726  1.00 32.67           C  
ATOM    614  C   ASP   105      -2.788  10.253  21.729  1.00 32.95           C  
ATOM    615  O   ASP   105      -3.590   9.801  20.916  1.00 32.42           O  
ATOM    616  CB  ASP   105      -0.974   8.721  22.766  1.00 32.38           C  
ATOM    617  CG  ASP   105      -1.939   7.573  22.686  1.00 33.91           C  
ATOM    618  OD1 ASP   105      -3.040   7.652  23.253  1.00 33.56           O  
ATOM    619  OD2 ASP   105      -1.555   6.530  22.122  1.00 35.97           O  
ATOM    620  N   PHE   106      -3.129  11.160  22.630  1.00 33.56           N  
ATOM    621  CA  PHE   106      -4.457  11.802  22.702  1.00 35.01           C  
ATOM    622  C   PHE   106      -4.878  12.370  21.332  1.00 36.24           C  
ATOM    623  O   PHE   106      -5.978  12.083  20.818  1.00 36.06           O  
ATOM    624  CB  PHE   106      -4.385  12.903  23.770  1.00 35.80           C  
ATOM    625  CG  PHE   106      -5.655  13.703  23.965  1.00 36.05           C  
ATOM    626  CD1 PHE   106      -6.880  13.073  24.216  1.00 35.54           C  
ATOM    627  CD2 PHE   106      -5.600  15.108  23.982  1.00 36.94           C  
ATOM    628  CE1 PHE   106      -8.029  13.817  24.425  1.00 36.07           C  
ATOM    629  CE2 PHE   106      -6.743  15.860  24.198  1.00 36.31           C  
ATOM    630  CZ  PHE   106      -7.966  15.215  24.432  1.00 36.38           C  
ATOM    631  N   GLU   107      -3.976  13.149  20.733  1.00 37.10           N  
ATOM    632  CA  GLU   107      -4.199  13.781  19.423  1.00 35.80           C  
ATOM    633  C   GLU   107      -4.382  12.751  18.330  1.00 35.02           C  
ATOM    634  O   GLU   107      -5.280  12.864  17.512  1.00 33.91           O  
ATOM    635  CB  GLU   107      -3.049  14.734  19.088  1.00 36.77           C  
ATOM    636  CG  GLU   107      -3.160  16.067  19.838  1.00 35.57           C  
ATOM    637  CD  GLU   107      -2.247  17.140  19.300  1.00 36.65           C  
ATOM    638  OE1 GLU   107      -1.006  16.977  19.321  1.00 37.42           O  
ATOM    639  OE2 GLU   107      -2.761  18.199  18.885  1.00 37.20           O  
ATOM    640  N   TYR   108      -3.534  11.735  18.321  1.00 34.20           N  
ATOM    641  CA  TYR   108      -3.688  10.676  17.353  1.00 35.65           C  
ATOM    642  C   TYR   108      -5.048   9.963  17.523  1.00 34.35           C  
ATOM    643  O   TYR   108      -5.718   9.617  16.551  1.00 34.92           O  
ATOM    644  CB  TYR   108      -2.523   9.682  17.454  1.00 35.28           C  
ATOM    645  CG  TYR   108      -2.558   8.616  16.409  1.00 35.58           C  
ATOM    646  CD1 TYR   108      -2.544   8.953  15.053  1.00 35.63           C  
ATOM    647  CD2 TYR   108      -2.590   7.270  16.761  1.00 34.32           C  
ATOM    648  CE1 TYR   108      -2.584   7.978  14.075  1.00 35.54           C  
ATOM    649  CE2 TYR   108      -2.619   6.298  15.802  1.00 35.87           C  
ATOM    650  CZ  TYR   108      -2.616   6.649  14.449  1.00 35.77           C  
ATOM    651  OH  TYR   108      -2.658   5.681  13.471  1.00 35.26           O  
ATOM    652  N   THR   109      -5.448   9.746  18.769  1.00 35.03           N  
ATOM    653  CA  THR   109      -6.698   9.064  19.076  1.00 33.68           C  
ATOM    654  C   THR   109      -7.861   9.886  18.507  1.00 31.85           C  
ATOM    655  O   THR   109      -8.816   9.315  18.010  1.00 32.82           O  
ATOM    656  CB  THR   109      -6.808   8.731  20.607  1.00 35.01           C  
ATOM    657  OG1 THR   109      -5.735   7.858  20.969  1.00 34.59           O  
ATOM    658  CG2 THR   109      -8.135   8.031  20.970  1.00 33.15           C  
ATOM    659  N   GLN   110      -7.801  11.217  18.549  1.00 30.28           N  
ATOM    660  CA  GLN   110      -8.859  12.002  17.968  1.00 30.39           C  
ATOM    661  C   GLN   110      -8.990  11.707  16.478  1.00 31.29           C  
ATOM    662  O   GLN   110     -10.103  11.494  15.963  1.00 30.97           O  
ATOM    663  CB  GLN   110      -8.678  13.509  18.239  1.00 31.63           C  
ATOM    664  CG  GLN   110      -8.869  13.893  19.712  1.00 31.90           C  
ATOM    665  CD  GLN   110      -8.517  15.343  19.995  1.00 33.22           C  
ATOM    666  OE1 GLN   110      -7.835  15.657  20.974  1.00 34.63           O  
ATOM    667  NE2 GLN   110      -8.977  16.233  19.134  1.00 35.22           N  
ATOM    668  N   LEU   111      -7.858  11.648  15.775  1.00 30.57           N  
ATOM    669  CA  LEU   111      -7.878  11.335  14.362  1.00 30.61           C  
ATOM    670  C   LEU   111      -8.434   9.911  14.164  1.00 31.02           C  
ATOM    671  O   LEU   111      -9.228   9.651  13.260  1.00 30.94           O  
ATOM    672  CB  LEU   111      -6.471  11.490  13.758  1.00 30.95           C  
ATOM    673  CG  LEU   111      -6.293  11.231  12.256  1.00 31.08           C  
ATOM    674  CD1 LEU   111      -7.111  12.147  11.455  1.00 30.25           C  
ATOM    675  CD2 LEU   111      -4.806  11.369  11.903  1.00 31.37           C  
ATOM    676  N   LEU   112      -8.077   8.985  15.037  1.00 31.17           N  
ATOM    677  CA  LEU   112      -8.657   7.657  14.911  1.00 31.52           C  
ATOM    678  C   LEU   112     -10.191   7.645  15.018  1.00 34.16           C  
ATOM    679  O   LEU   112     -10.858   6.803  14.374  1.00 33.67           O  
ATOM    680  CB  LEU   112      -8.070   6.724  15.939  1.00 30.68           C  
ATOM    681  CG  LEU   112      -6.630   6.333  15.739  1.00 28.89           C  
ATOM    682  CD1 LEU   112      -6.242   5.410  16.888  1.00 28.54           C  
ATOM    683  CD2 LEU   112      -6.406   5.663  14.382  1.00 28.98           C  
ATOM    684  N   ALA   113     -10.747   8.598  15.784  1.00 34.42           N  
ATOM    685  CA  ALA   113     -12.190   8.674  15.988  1.00 34.82           C  
ATOM    686  C   ALA   113     -12.821   9.386  14.806  1.00 36.77           C  
ATOM    687  O   ALA   113     -13.933   9.038  14.385  1.00 34.40           O  
ATOM    688  CB  ALA   113     -12.513   9.386  17.282  1.00 33.82           C  
ATOM    689  N   GLU   114     -12.105  10.396  14.285  1.00 38.02           N  
ATOM    690  CA  GLU   114     -12.525  11.148  13.083  1.00 38.27           C  
ATOM    691  C   GLU   114     -12.688  10.230  11.866  1.00 37.71           C  
ATOM    692  O   GLU   114     -13.631  10.376  11.072  1.00 35.85           O  
ATOM    693  CB  GLU   114     -11.479  12.231  12.748  1.00 38.46           C  
ATOM    694  CG  GLU   114     -11.625  12.955  11.411  1.00 38.44           C  
ATOM    695  CD  GLU   114     -12.912  13.774  11.263  1.00 39.18           C  
ATOM    696  OE1 GLU   114     -13.863  13.564  12.052  1.00 39.13           O  
ATOM    697  OE2 GLU   114     -12.969  14.629  10.339  1.00 38.38           O  
ATOM    698  N   VAL   115     -11.786   9.260  11.783  1.00 36.86           N  
ATOM    699  CA  VAL   115     -11.649   8.407  10.616  1.00 37.42           C  
ATOM    700  C   VAL   115     -12.283   7.031  10.766  1.00 37.20           C  
ATOM    701  O   VAL   115     -12.437   6.316   9.783  1.00 36.94           O  
ATOM    702  CB  VAL   115     -10.088   8.346  10.255  1.00 37.61           C  
ATOM    703  CG1 VAL   115      -9.631   7.000   9.754  1.00 37.26           C  
ATOM    704  CG2 VAL   115      -9.717   9.491   9.349  1.00 35.81           C  
ATOM    705  N   ALA   116     -12.693   6.662  11.972  1.00 37.42           N  
ATOM    706  CA  ALA   116     -13.258   5.331  12.187  1.00 37.49           C  
ATOM    707  C   ALA   116     -14.540   5.101  11.376  1.00 37.88           C  
ATOM    708  O   ALA   116     -15.338   6.015  11.165  1.00 37.84           O  
ATOM    709  CB  ALA   116     -13.500   5.083  13.680  1.00 38.00           C  
ATOM    861  N   PRO   136     -17.181   1.647  17.036  1.00 30.78           N  
ATOM    862  CA  PRO   136     -15.796   1.420  16.680  1.00 30.75           C  
ATOM    863  C   PRO   136     -15.003   2.724  16.706  1.00 31.52           C  
ATOM    864  O   PRO   136     -13.776   2.688  16.676  1.00 33.29           O  
ATOM    865  CB  PRO   136     -15.860   0.839  15.259  1.00 31.65           C  
ATOM    866  CG  PRO   136     -17.265   0.651  14.924  1.00 30.94           C  
ATOM    867  CD  PRO   136     -18.124   1.292  15.964  1.00 30.49           C  
ATOM    868  N   ALA   137     -15.693   3.870  16.781  1.00 32.33           N  
ATOM    869  CA  ALA   137     -15.056   5.159  16.842  1.00 33.46           C  
ATOM    870  C   ALA   137     -14.846   5.650  18.274  1.00 34.89           C  
ATOM    871  O   ALA   137     -14.559   6.845  18.467  1.00 34.59           O  
ATOM    872  CB  ALA   137     -15.902   6.193  16.070  1.00 32.66           C  
ATOM    873  N   ALA   138     -15.024   4.752  19.248  1.00 34.13           N  
ATOM    874  CA  ALA   138     -14.902   5.049  20.685  1.00 35.16           C  
ATOM    875  C   ALA   138     -13.668   4.388  21.264  1.00 35.13           C  
ATOM    876  O   ALA   138     -13.452   3.192  21.086  1.00 34.97           O  
ATOM    877  CB  ALA   138     -16.161   4.574  21.462  1.00 35.04           C  
ATOM    878  N   PHE   139     -12.870   5.180  21.959  1.00 35.95           N  
ATOM    879  CA  PHE   139     -11.614   4.734  22.528  1.00 36.87           C  
ATOM    880  C   PHE   139     -11.471   5.138  23.993  1.00 36.57           C  
ATOM    881  O   PHE   139     -11.821   6.270  24.388  1.00 36.96           O  
ATOM    882  CB  PHE   139     -10.447   5.322  21.731  1.00 37.58           C  
ATOM    883  CG  PHE   139     -10.437   4.917  20.257  1.00 38.18           C  
ATOM    884  CD1 PHE   139     -11.110   5.675  19.304  1.00 37.01           C  
ATOM    885  CD2 PHE   139      -9.756   3.790  19.838  1.00 37.84           C  
ATOM    886  CE1 PHE   139     -11.115   5.313  17.985  1.00 36.83           C  
ATOM    887  CE2 PHE   139      -9.764   3.431  18.501  1.00 37.78           C  
ATOM    888  CZ  PHE   139     -10.441   4.210  17.578  1.00 37.29           C  
ATOM    889  N   ILE   140     -10.952   4.201  24.778  1.00 35.26           N  
ATOM    890  CA  ILE   140     -10.656   4.414  26.186  1.00 36.28           C  
ATOM    891  C   ILE   140      -9.157   4.673  26.333  1.00 36.01           C  
ATOM    892  O   ILE   140      -8.360   3.790  25.981  1.00 35.21           O  
ATOM    893  CB  ILE   140     -10.980   3.153  27.042  1.00 36.47           C  
ATOM    894  CG1 ILE   140     -12.471   2.827  26.992  1.00 36.86           C  
ATOM    895  CG2 ILE   140     -10.505   3.359  28.507  1.00 36.54           C  
ATOM    896  CD1 ILE   140     -12.823   1.467  27.609  1.00 37.66           C  
ATOM    897  N   ARG   141      -8.788   5.832  26.895  1.00 35.41           N  
ATOM    898  CA  ARG   141      -7.369   6.211  27.124  1.00 34.78           C  
ATOM    899  C   ARG   141      -7.021   6.495  28.588  1.00 34.90           C  
ATOM    900  O   ARG   141      -7.810   7.115  29.289  1.00 34.61           O  
ATOM    901  CB  ARG   141      -7.002   7.454  26.281  1.00 34.37           C  
ATOM    902  CG  ARG   141      -6.906   7.196  24.783  1.00 34.55           C  
ATOM    903  CD  ARG   141      -5.886   6.100  24.513  1.00 34.71           C  
ATOM    904  NE  ARG   141      -5.766   5.735  23.120  1.00 35.21           N  
ATOM    905  CZ  ARG   141      -6.274   4.642  22.544  1.00 35.59           C  
ATOM    906  NH1 ARG   141      -6.948   3.726  23.222  1.00 36.12           N  
ATOM    907  NH2 ARG   141      -6.061   4.446  21.255  1.00 35.22           N  
ATOM    908  N   GLN   142      -5.829   6.055  29.026  1.00 35.09           N  
ATOM    909  CA  GLN   142      -5.313   6.302  30.408  1.00 34.44           C  
ATOM    910  C   GLN   142      -3.952   6.997  30.332  1.00 33.94           C  
ATOM    911  O   GLN   142      -2.990   6.428  29.822  1.00 33.71           O  
ATOM    912  CB  GLN   142      -5.165   4.993  31.211  1.00 34.70           C  
ATOM    913  CG  GLN   142      -6.405   4.095  31.212  1.00 34.93           C  
ATOM    914  CD  GLN   142      -6.277   2.878  32.097  1.00 35.35           C  
ATOM    915  OE1 GLN   142      -5.995   1.783  31.618  1.00 37.10           O  
ATOM    916  NE2 GLN   142      -6.483   3.062  33.407  1.00 35.35           N  
ATOM    917  N   TYR   143      -3.881   8.225  30.827  1.00 34.02           N  
ATOM    918  CA  TYR   143      -2.631   9.020  30.818  1.00 34.50           C  
ATOM    919  C   TYR   143      -2.240   9.431  32.225  1.00 34.11           C  
ATOM    920  O   TYR   143      -3.114   9.610  33.080  1.00 31.71           O  
ATOM    921  CB  TYR   143      -2.790  10.270  29.944  1.00 34.05           C  
ATOM    922  CG  TYR   143      -3.195   9.923  28.526  1.00 34.61           C  
ATOM    923  CD1 TYR   143      -2.358   9.148  27.710  1.00 34.14           C  
ATOM    924  CD2 TYR   143      -4.393  10.372  27.990  1.00 34.69           C  
ATOM    925  CE1 TYR   143      -2.723   8.821  26.415  1.00 34.01           C  
ATOM    926  CE2 TYR   143      -4.752  10.053  26.693  1.00 34.66           C  
ATOM    927  CZ  TYR   143      -3.917   9.279  25.920  1.00 33.99           C  
ATOM    928  OH  TYR   143      -4.288   8.971  24.642  1.00 34.35           O  
ATOM    929  N   ARG   144      -0.930   9.536  32.463  1.00 33.80           N  
ATOM    930  CA  ARG   144      -0.404   9.988  33.742  1.00 35.60           C  
ATOM    931  C   ARG   144      -0.280  11.510  33.721  1.00 34.05           C  
ATOM    932  O   ARG   144       0.192  12.107  34.681  1.00 33.51           O  
ATOM    933  CB  ARG   144       0.960   9.359  34.046  1.00 36.36           C  
ATOM    934  CG  ARG   144       0.991   7.822  33.954  1.00 38.03           C  
ATOM    935  CD  ARG   144       2.367   7.245  34.238  1.00 39.35           C  
ATOM    936  NE  ARG   144       3.382   8.268  34.007  1.00 41.24           N  
ATOM    937  CZ  ARG   144       4.601   8.071  33.506  1.00 42.86           C  
ATOM    938  NH1 ARG   144       5.012   6.867  33.093  1.00 43.50           N  
ATOM    939  NH2 ARG   144       5.405   9.127  33.377  1.00 42.35           N  
ATOM    940  N   TYR   145      -0.745  12.128  32.635  1.00 34.23           N  
ATOM    941  CA  TYR   145      -0.684  13.578  32.457  1.00 32.95           C  
ATOM    942  C   TYR   145      -2.013  14.174  32.013  1.00 33.09           C  
ATOM    943  O   TYR   145      -2.810  13.522  31.365  1.00 32.37           O  
ATOM    944  CB  TYR   145       0.391  13.878  31.438  1.00 33.59           C  
ATOM    945  CG  TYR   145       1.744  13.420  31.917  1.00 33.35           C  
ATOM    946  CD1 TYR   145       2.172  12.122  31.711  1.00 33.26           C  
ATOM    947  CD2 TYR   145       2.574  14.285  32.608  1.00 33.75           C  
ATOM    948  CE1 TYR   145       3.389  11.697  32.170  1.00 33.34           C  
ATOM    949  CE2 TYR   145       3.791  13.876  33.057  1.00 33.71           C  
ATOM    950  CZ  TYR   145       4.194  12.583  32.837  1.00 33.55           C  
ATOM    951  OH  TYR   145       5.411  12.193  33.306  1.00 34.34           O  
ATOM    952  N   ASP   146      -2.262  15.439  32.332  1.00 34.92           N  
ATOM    953  CA  ASP   146      -3.539  16.038  31.934  1.00 35.59           C  
ATOM    954  C   ASP   146      -3.410  16.548  30.509  1.00 36.12           C  
ATOM    955  O   ASP   146      -3.083  17.710  30.275  1.00 36.73           O  
ATOM    956  CB  ASP   146      -4.019  17.144  32.888  1.00 35.23           C  
ATOM    957  CG  ASP   146      -5.482  17.501  32.657  1.00 35.45           C  
ATOM    958  OD1 ASP   146      -6.054  17.045  31.633  1.00 35.51           O  
ATOM    959  OD2 ASP   146      -6.072  18.196  33.509  1.00 34.99           O  
ATOM    960  N   VAL   147      -3.683  15.652  29.569  1.00 36.09           N  
ATOM    961  CA  VAL   147      -3.580  15.934  28.139  1.00 36.00           C  
ATOM    962  C   VAL   147      -4.681  16.859  27.646  1.00 37.54           C  
ATOM    963  O   VAL   147      -4.578  17.393  26.557  1.00 38.09           O  
ATOM    964  CB  VAL   147      -3.653  14.622  27.297  1.00 35.38           C  
ATOM    965  CG1 VAL   147      -2.531  13.675  27.681  1.00 34.28           C  
ATOM    966  CG2 VAL   147      -5.046  13.949  27.459  1.00 35.03           C  
ATOM    967  N   THR   148      -5.742  17.046  28.430  1.00 40.08           N  
ATOM    968  CA  THR   148      -6.843  17.939  28.035  1.00 40.62           C  
ATOM    969  C   THR   148      -6.586  19.399  28.419  1.00 41.55           C  
ATOM    970  O   THR   148      -7.293  20.309  27.964  1.00 40.82           O  
ATOM    971  CB  THR   148      -8.162  17.553  28.734  1.00 41.38           C  
ATOM    972  OG1 THR   148      -8.043  17.840  30.131  1.00 41.87           O  
ATOM    973  CG2 THR   148      -8.513  16.076  28.536  1.00 40.38           C  
ATOM    974  N   HIS   149      -5.595  19.618  29.276  1.00 42.58           N  
ATOM    975  CA  HIS   149      -5.297  20.956  29.770  1.00 43.38           C  
ATOM    976  C   HIS   149      -3.855  21.343  29.493  1.00 44.04           C  
ATOM    977  O   HIS   149      -3.579  21.904  28.430  1.00 43.03           O  
ATOM    978  CB  HIS   149      -5.634  21.082  31.267  1.00 44.14           C  
ATOM    979  CG  HIS   149      -5.333  22.430  31.836  1.00 44.34           C  
ATOM    980  ND1 HIS   149      -4.211  22.681  32.599  1.00 45.27           N  
ATOM    981  CD2 HIS   149      -5.980  23.614  31.721  1.00 44.87           C  
ATOM    982  CE1 HIS   149      -4.182  23.959  32.938  1.00 44.79           C  
ATOM    983  NE2 HIS   149      -5.249  24.547  32.422  1.00 44.80           N  
ATOM    984  N   ASP   150      -2.930  21.021  30.401  1.00 44.79           N  
ATOM    985  CA  ASP   150      -1.545  21.482  30.234  1.00 45.74           C  
ATOM    986  C   ASP   150      -0.462  20.502  30.737  1.00 45.36           C  
ATOM    987  O   ASP   150       0.588  20.917  31.227  1.00 44.69           O  
ATOM    988  CB  ASP   150      -1.397  22.858  30.890  1.00 46.83           C  
ATOM    989  CG  ASP   150      -0.334  23.714  30.233  1.00 48.68           C  
ATOM    990  OD1 ASP   150       0.428  23.212  29.361  1.00 50.39           O  
ATOM    991  OD2 ASP   150      -0.277  24.916  30.573  1.00 49.33           O  
ATOM    992  N   LEU   151      -0.739  19.209  30.572  1.00 44.73           N  
ATOM    993  CA  LEU   151       0.187  18.114  30.895  1.00 44.03           C  
ATOM    994  C   LEU   151       0.579  18.010  32.352  1.00 43.81           C  
ATOM    995  O   LEU   151       1.716  17.673  32.662  1.00 43.47           O  
ATOM    996  CB  LEU   151       1.441  18.183  30.011  1.00 43.12           C  
ATOM    997  CG  LEU   151       1.178  18.324  28.509  1.00 42.79           C  
ATOM    998  CD1 LEU   151       2.482  18.181  27.706  1.00 41.99           C  
ATOM    999  CD2 LEU   151       0.145  17.316  28.042  1.00 42.24           C  
ATOM   1000  N   GLN   152      -0.378  18.295  33.234  1.00 44.58           N  
ATOM   1001  CA  GLN   152      -0.191  18.162  34.682  1.00 44.48           C  
ATOM   1002  C   GLN   152       0.076  16.686  34.995  1.00 43.53           C  
ATOM   1003  O   GLN   152      -0.577  15.837  34.422  1.00 42.55           O  
ATOM   1004  CB  GLN   152      -1.480  18.582  35.445  1.00 44.70           C  
ATOM   1005  CG  GLN   152      -1.749  20.098  35.662  1.00 45.24           C  
ATOM   1006  CD  GLN   152      -2.106  20.916  34.406  1.00 45.34           C  
ATOM   1007  OE1 GLN   152      -2.549  20.376  33.391  1.00 43.86           O  
ATOM   1008  NE2 GLN   152      -1.931  22.247  34.501  1.00 45.02           N  
ATOM   1009  N   GLU   153       1.051  16.373  35.851  1.00 43.57           N  
ATOM   1010  CA  GLU   153       1.211  14.992  36.314  1.00 43.21           C  
ATOM   1011  C   GLU   153      -0.005  14.717  37.178  1.00 42.36           C  
ATOM   1012  O   GLU   153      -0.084  15.217  38.289  1.00 42.69           O  
ATOM   1013  CB  GLU   153       2.466  14.763  37.150  1.00 43.26           C  
ATOM   1014  CG  GLU   153       3.628  14.244  36.395  1.00 44.27           C  
ATOM   1015  CD  GLU   153       4.799  13.889  37.298  1.00 45.15           C  
ATOM   1016  OE1 GLU   153       5.089  14.665  38.243  1.00 46.26           O  
ATOM   1017  OE2 GLU   153       5.453  12.849  37.043  1.00 46.21           O  
ATOM   1018  N   ALA   154      -0.938  13.936  36.642  1.00 41.00           N  
ATOM   1019  CA  ALA   154      -2.180  13.601  37.311  1.00 40.63           C  
ATOM   1020  C   ALA   154      -2.851  12.510  36.492  1.00 39.98           C  
ATOM   1021  O   ALA   154      -3.087  12.710  35.296  1.00 40.14           O  
ATOM   1022  CB  ALA   154      -3.083  14.827  37.394  1.00 40.73           C  
ATOM   1023  N   GLU   155      -3.118  11.358  37.113  1.00 39.02           N  
ATOM   1024  CA  GLU   155      -3.806  10.248  36.442  1.00 38.44           C  
ATOM   1025  C   GLU   155      -5.091  10.729  35.778  1.00 38.05           C  
ATOM   1026  O   GLU   155      -6.012  11.181  36.454  1.00 36.52           O  
ATOM   1027  CB  GLU   155      -4.125   9.092  37.413  1.00 38.51           C  
ATOM   1028  CG  GLU   155      -2.928   8.203  37.826  1.00 39.18           C  
ATOM   1029  CD  GLU   155      -2.304   7.406  36.667  1.00 39.11           C  
ATOM   1030  OE1 GLU   155      -2.806   7.502  35.528  1.00 39.80           O  
ATOM   1031  OE2 GLU   155      -1.309   6.676  36.900  1.00 39.33           O  
ATOM   1032  N   THR   156      -5.150  10.605  34.450  1.00 38.58           N  
ATOM   1033  CA  THR   156      -6.315  11.049  33.668  1.00 39.32           C  
ATOM   1034  C   THR   156      -6.908   9.901  32.842  1.00 38.56           C  
ATOM   1035  O   THR   156      -6.191   9.175  32.177  1.00 38.94           O  
ATOM   1036  CB  THR   156      -5.961  12.238  32.748  1.00 39.69           C  
ATOM   1037  OG1 THR   156      -5.110  13.151  33.460  1.00 39.65           O  
ATOM   1038  CG2 THR   156      -7.238  12.951  32.288  1.00 38.88           C  
ATOM   1039  N   ALA   157      -8.228   9.758  32.907  1.00 38.33           N  
ATOM   1040  CA  ALA   157      -8.964   8.679  32.254  1.00 38.48           C  
ATOM   1041  C   ALA   157     -10.000   9.322  31.326  1.00 38.25           C  
ATOM   1042  O   ALA   157     -10.901  10.005  31.789  1.00 38.07           O  
ATOM   1043  CB  ALA   157      -9.649   7.780  33.328  1.00 37.18           C  
ATOM   1044  N   LEU   158      -9.871   9.098  30.019  1.00 38.80           N  
ATOM   1045  CA  LEU   158     -10.745   9.736  29.012  1.00 38.15           C  
ATOM   1046  C   LEU   158     -11.397   8.749  28.057  1.00 38.07           C  
ATOM   1047  O   LEU   158     -10.844   7.676  27.783  1.00 37.00           O  
ATOM   1048  CB  LEU   158      -9.907  10.718  28.177  1.00 37.77           C  
ATOM   1049  CG  LEU   158      -9.233  11.893  28.915  1.00 38.21           C  
ATOM   1050  CD1 LEU   158      -8.066  12.510  28.104  1.00 36.98           C  
ATOM   1051  CD2 LEU   158     -10.248  12.946  29.326  1.00 36.74           C  
ATOM   1052  N   LEU   159     -12.573   9.125  27.553  1.00 38.32           N  
ATOM   1053  CA  LEU   159     -13.288   8.364  26.494  1.00 37.73           C  
ATOM   1054  C   LEU   159     -13.305   9.288  25.310  1.00 37.07           C  
ATOM   1055  O   LEU   159     -13.845  10.410  25.428  1.00 37.83           O  
ATOM   1056  CB  LEU   159     -14.742   8.037  26.854  1.00 37.83           C  
ATOM   1057  CG  LEU   159     -15.545   7.301  25.775  1.00 38.57           C  
ATOM   1058  CD1 LEU   159     -14.891   5.919  25.489  1.00 38.98           C  
ATOM   1059  CD2 LEU   159     -17.048   7.119  26.134  1.00 37.71           C  
ATOM   1060  N   ILE   160     -12.697   8.869  24.198  1.00 35.82           N  
ATOM   1061  CA  ILE   160     -12.689   9.678  22.962  1.00 35.81           C  
ATOM   1062  C   ILE   160     -13.626   8.993  21.964  1.00 35.30           C  
ATOM   1063  O   ILE   160     -13.571   7.751  21.790  1.00 32.61           O  
ATOM   1064  CB  ILE   160     -11.259   9.822  22.346  1.00 35.67           C  
ATOM   1065  CG1 ILE   160     -10.329  10.615  23.269  1.00 36.38           C  
ATOM   1066  CG2 ILE   160     -11.341  10.519  21.005  1.00 36.24           C  
ATOM   1067  CD1 ILE   160      -9.693   9.814  24.356  1.00 35.92           C  
ATOM   1068  N   TRP   161     -14.533   9.753  21.358  1.00 34.16           N  
ATOM   1069  CA  TRP   161     -15.456   9.155  20.384  1.00 35.62           C  
ATOM   1070  C   TRP   161     -15.980  10.135  19.343  1.00 36.26           C  
ATOM   1071  O   TRP   161     -15.693  11.326  19.429  1.00 35.77           O  
ATOM   1072  CB  TRP   161     -16.644   8.522  21.109  1.00 37.38           C  
ATOM   1073  CG  TRP   161     -17.718   9.455  21.577  1.00 37.18           C  
ATOM   1074  CD1 TRP   161     -18.903   9.685  20.966  1.00 37.71           C  
ATOM   1075  CD2 TRP   161     -17.728  10.237  22.773  1.00 37.19           C  
ATOM   1076  NE1 TRP   161     -19.642  10.576  21.678  1.00 37.89           N  
ATOM   1077  CE2 TRP   161     -18.945  10.934  22.798  1.00 38.42           C  
ATOM   1078  CE3 TRP   161     -16.816  10.435  23.808  1.00 37.18           C  
ATOM   1079  CZ2 TRP   161     -19.276  11.835  23.813  1.00 38.40           C  
ATOM   1080  CZ3 TRP   161     -17.142  11.285  24.818  1.00 37.74           C  
ATOM   1081  CH2 TRP   161     -18.369  11.986  24.824  1.00 38.15           C  
ATOM   1082  N   ARG   162     -16.759   9.632  18.381  1.00 36.30           N  
ATOM   1083  CA  ARG   162     -17.405  10.495  17.383  1.00 36.65           C  
ATOM   1084  C   ARG   162     -18.910  10.371  17.580  1.00 36.51           C  
ATOM   1085  O   ARG   162     -19.440   9.263  17.606  1.00 35.78           O  
ATOM   1086  CB  ARG   162     -17.036  10.123  15.944  1.00 36.17           C  
ATOM   1087  CG  ARG   162     -17.505  11.169  14.969  1.00 36.54           C  
ATOM   1088  CD  ARG   162     -16.821  11.107  13.626  1.00 36.00           C  
ATOM   1089  NE  ARG   162     -17.436  10.134  12.715  1.00 35.70           N  
ATOM   1090  CZ  ARG   162     -17.007   8.899  12.463  1.00 35.72           C  
ATOM   1091  NH1 ARG   162     -15.925   8.408  13.036  1.00 36.11           N  
ATOM   1092  NH2 ARG   162     -17.668   8.156  11.588  1.00 35.62           N  
ATOM   1093  N   ASN   163     -19.597  11.505  17.694  1.00 37.07           N  
ATOM   1094  CA  ASN   163     -21.015  11.459  18.004  1.00 38.11           C  
ATOM   1095  C   ASN   163     -21.908  11.453  16.780  1.00 39.76           C  
ATOM   1096  O   ASN   163     -21.410  11.428  15.668  1.00 40.47           O  
ATOM   1097  CB  ASN   163     -21.359  12.566  18.979  1.00 37.72           C  
ATOM   1098  CG  ASN   163     -21.269  13.932  18.358  1.00 37.22           C  
ATOM   1099  OD1 ASN   163     -21.160  14.070  17.146  1.00 38.13           O  
ATOM   1100  ND2 ASN   163     -21.356  14.949  19.185  1.00 37.50           N  
ATOM   1101  N   ALA   164     -23.226  11.443  16.989  1.00 41.32           N  
ATOM   1102  CA  ALA   164     -24.203  11.411  15.897  1.00 41.49           C  
ATOM   1103  C   ALA   164     -24.046  12.531  14.871  1.00 42.17           C  
ATOM   1104  O   ALA   164     -24.417  12.345  13.715  1.00 41.92           O  
ATOM   1105  CB  ALA   164     -25.641  11.401  16.471  1.00 42.29           C  
ATOM   1106  N   GLU   165     -23.515  13.682  15.289  1.00 42.49           N  
ATOM   1107  CA  GLU   165     -23.253  14.805  14.375  1.00 43.04           C  
ATOM   1108  C   GLU   165     -21.858  14.735  13.715  1.00 42.42           C  
ATOM   1109  O   GLU   165     -21.395  15.723  13.153  1.00 40.99           O  
ATOM   1110  CB  GLU   165     -23.353  16.131  15.123  1.00 43.93           C  
ATOM   1111  CG  GLU   165     -24.748  16.511  15.540  1.00 45.40           C  
ATOM   1112  CD  GLU   165     -24.763  17.805  16.346  1.00 46.25           C  
ATOM   1113  OE1 GLU   165     -24.250  17.781  17.504  1.00 47.45           O  
ATOM   1114  OE2 GLU   165     -25.300  18.828  15.826  1.00 47.05           O  
ATOM   1115  N   ASP   166     -21.201  13.579  13.808  1.00 40.89           N  
ATOM   1116  CA  ASP   166     -19.862  13.355  13.259  1.00 41.15           C  
ATOM   1117  C   ASP   166     -18.775  14.319  13.804  1.00 40.03           C  
ATOM   1118  O   ASP   166     -17.812  14.628  13.100  1.00 38.42           O  
ATOM   1119  CB  ASP   166     -19.876  13.307  11.704  1.00 41.47           C  
ATOM   1120  CG  ASP   166     -20.427  11.982  11.143  1.00 41.09           C  
ATOM   1121  OD1 ASP   166     -20.142  10.911  11.701  1.00 40.80           O  
ATOM   1122  OD2 ASP   166     -21.117  12.003  10.101  1.00 41.82           O  
ATOM   1123  N   ASP   167     -18.934  14.767  15.057  1.00 40.27           N  
ATOM   1124  CA  ASP   167     -17.931  15.619  15.742  1.00 40.57           C  
ATOM   1125  C   ASP   167     -17.164  14.774  16.756  1.00 39.01           C  
ATOM   1126  O   ASP   167     -17.783  13.962  17.449  1.00 39.31           O  
ATOM   1127  CB  ASP   167     -18.599  16.781  16.492  1.00 41.60           C  
ATOM   1128  CG  ASP   167     -19.185  17.828  15.566  1.00 42.34           C  
ATOM   1129  OD1 ASP   167     -18.468  18.360  14.701  1.00 43.82           O  
ATOM   1130  OD2 ASP   167     -20.363  18.165  15.743  1.00 44.30           O  
ATOM   1131  N   VAL   168     -15.838  14.958  16.829  1.00 36.76           N  
ATOM   1132  CA  VAL   168     -15.006  14.240  17.789  1.00 35.36           C  
ATOM   1133  C   VAL   168     -15.226  14.869  19.171  1.00 35.50           C  
ATOM   1134  O   VAL   168     -15.207  16.106  19.342  1.00 32.60           O  
ATOM   1135  CB  VAL   168     -13.510  14.245  17.431  1.00 35.37           C  
ATOM   1136  CG1 VAL   168     -12.719  13.431  18.436  1.00 35.65           C  
ATOM   1137  CG2 VAL   168     -13.292  13.682  16.052  1.00 35.05           C  
ATOM   1138  N   MET   169     -15.476  14.008  20.146  1.00 33.94           N  
ATOM   1139  CA  MET   169     -15.734  14.428  21.512  1.00 33.79           C  
ATOM   1140  C   MET   169     -14.858  13.600  22.453  1.00 34.81           C  
ATOM   1141  O   MET   169     -14.458  12.471  22.130  1.00 30.90           O  
ATOM   1142  CB  MET   169     -17.201  14.148  21.890  1.00 34.13           C  
ATOM   1143  CG  MET   169     -18.291  14.595  20.964  1.00 33.48           C  
ATOM   1144  SD  MET   169     -18.437  16.527  20.858  0.75 37.47          SE  
ATOM   1145  CE  MET   169     -19.112  16.847  22.681  1.00 31.68           C  
ATOM   1146  N   TYR   170     -14.569  14.167  23.618  1.00 35.79           N  
ATOM   1147  CA  TYR   170     -13.835  13.455  24.636  1.00 36.09           C  
ATOM   1148  C   TYR   170     -14.502  13.833  25.959  1.00 37.22           C  
ATOM   1149  O   TYR   170     -15.080  14.917  26.071  1.00 34.89           O  
ATOM   1150  CB  TYR   170     -12.317  13.783  24.601  1.00 36.65           C  
ATOM   1151  CG  TYR   170     -11.885  15.201  24.997  1.00 37.32           C  
ATOM   1152  CD1 TYR   170     -11.850  15.587  26.339  1.00 38.17           C  
ATOM   1153  CD2 TYR   170     -11.444  16.128  24.041  1.00 36.93           C  
ATOM   1154  CE1 TYR   170     -11.448  16.895  26.731  1.00 36.83           C  
ATOM   1155  CE2 TYR   170     -11.027  17.440  24.427  1.00 37.45           C  
ATOM   1156  CZ  TYR   170     -11.037  17.798  25.777  1.00 37.46           C  
ATOM   1157  OH  TYR   170     -10.647  19.065  26.197  1.00 37.82           O  
ATOM   1158  N   GLN   171     -14.427  12.950  26.952  1.00 36.97           N  
ATOM   1159  CA  GLN   171     -14.931  13.264  28.302  1.00 38.53           C  
ATOM   1160  C   GLN   171     -14.247  12.413  29.334  1.00 36.99           C  
ATOM   1161  O   GLN   171     -13.814  11.296  29.038  1.00 37.34           O  
ATOM   1162  CB  GLN   171     -16.450  13.039  28.429  1.00 39.94           C  
ATOM   1163  CG  GLN   171     -16.874  11.573  28.480  1.00 41.08           C  
ATOM   1164  CD  GLN   171     -18.399  11.383  28.609  1.00 42.57           C  
ATOM   1165  OE1 GLN   171     -19.202  12.314  28.348  1.00 45.34           O  
ATOM   1166  NE2 GLN   171     -18.801  10.179  29.008  1.00 44.67           N  
ATOM   1167  N   THR   172     -14.187  12.906  30.567  1.00 35.94           N  
ATOM   1168  CA  THR   172     -13.585  12.134  31.649  0.50 35.77           C  
ATOM   1170  C   THR   172     -14.403  10.853  31.826  1.00 35.48           C  
ATOM   1171  O   THR   172     -15.610  10.851  31.681  1.00 34.08           O  
ATOM   1172  CB  THR   172     -13.508  12.937  32.961  0.50 35.97           C  
ATOM   1174  OG1 THR   172     -14.832  13.263  33.407  0.50 36.62           O  
ATOM   1176  CG2 THR   172     -12.703  14.212  32.757  0.50 35.21           C  
ATOM   1178  N   LEU   173     -13.723   9.749  32.094  1.00 37.16           N  
ATOM   1179  CA  LEU   173     -14.361   8.480  32.248  1.00 38.77           C  
ATOM   1180  C   LEU   173     -14.133   8.031  33.687  1.00 41.89           C  
ATOM   1181  O   LEU   173     -12.973   7.958  34.150  1.00 42.80           O  
ATOM   1182  CB  LEU   173     -13.715   7.490  31.288  1.00 38.76           C  
ATOM   1183  CG  LEU   173     -14.480   6.251  30.833  1.00 38.66           C  
ATOM   1184  CD1 LEU   173     -15.783   6.646  30.191  1.00 36.48           C  
ATOM   1185  CD2 LEU   173     -13.607   5.482  29.866  1.00 37.79           C  
END
