
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  846),  selected  103 , name 2pmu_B
# Molecule2: number of CA atoms  134 ( 1070),  selected  134 , name T0443_97_230.pdb
# PARAMETERS: 2pmu_B.T0443_97_230.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K   144_B      S      97           -
LGA    E   145_B      D      98           -
LGA    P   146_B      G      99           -
LGA    R   147_B      I     100           -
LGA    N   148_B      L     101           -
LGA    V   149_B      A     102           -
LGA    R   150_B      L     103           -
LGA    L   151_B      M     104           -
LGA    T   152_B      D     105           -
LGA    -       -      F     106           -
LGA    -       -      E     107           -
LGA    -       -      Y     108           -
LGA    -       -      T     109           -
LGA    -       -      Q     110           -
LGA    -       -      L     111           -
LGA    -       -      L     112           -
LGA    -       -      A     113           -
LGA    -       -      E     114           -
LGA    -       -      V     115           -
LGA    -       -      A     116           -
LGA    -       -      Q     117           -
LGA    -       -      I     118           -
LGA    -       -      P     119           -
LGA    -       -      D     120           -
LGA    -       -      I     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      I     124           -
LGA    -       -      H     125           -
LGA    -       -      Y     126           -
LGA    -       -      S     127           -
LGA    -       -      N     128           -
LGA    -       -      D     129           -
LGA    -       -      S     130           -
LGA    -       -      K     131           -
LGA    -       -      Y     132           -
LGA    -       -      T     133           -
LGA    -       -      P     134           -
LGA    F   153_B      S     135           #
LGA    A   154_B      P     136          1.579
LGA    D   155_B      A     137          1.490
LGA    I   156_B      A     138          1.304
LGA    E   157_B      F     139          1.008
LGA    L   158_B      I     140          0.897
LGA    D   159_B      R     141          2.335
LGA    E   160_B      Q     142          5.268
LGA    -       -      Y     143           -
LGA    -       -      R     144           -
LGA    -       -      Y     145           -
LGA    -       -      D     146           -
LGA    -       -      V     147           -
LGA    -       -      T     148           -
LGA    -       -      H     149           -
LGA    -       -      D     150           -
LGA    -       -      L     151           -
LGA    -       -      Q     152           -
LGA    -       -      E     153           -
LGA    -       -      A     154           -
LGA    E   161_B      E     155           #
LGA    T   162_B      T     156          3.924
LGA    H   163_B      A     157          2.532
LGA    E   164_B      L     158          1.228
LGA    V   165_B      L     159          1.221
LGA    W   166_B      I     160          1.139
LGA    K   167_B      W     161          1.045
LGA    A   168_B      R     162          3.287
LGA    G   169_B      N     163           -
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      D     166           -
LGA    -       -      D     167           -
LGA    Q   170_B      V     168          2.631
LGA    P   171_B      M     169          3.613
LGA    V   172_B      Y     170          2.463
LGA    -       -      Q     171           -
LGA    S   173_B      T     172          3.460
LGA    L   174_B      L     173          3.442
LGA    S   175_B      D     174          3.679
LGA    P   176_B      G     175          3.346
LGA    T   177_B      F     176          2.961
LGA    E   178_B      D     177          2.929
LGA    F   179_B      M     178          2.870
LGA    T   180_B      M     179          2.708
LGA    L   181_B      L     180          2.479
LGA    L   182_B      L     181          2.078
LGA    R   183_B      E     182          2.223
LGA    Y   184_B      I     183          2.397
LGA    F   185_B      M     184          1.546
LGA    V   186_B      G     185          1.536
LGA    I   187_B      S     186          1.993
LGA    N   188_B      S     187          1.517
LGA    A   189_B      A     188          2.940
LGA    G   190_B      -       -           -
LGA    T   191_B      L     189          4.608
LGA    V   192_B      S     190          4.311
LGA    L   193_B      F     191           #
LGA    -       -      D     192           -
LGA    S   194_B      T     193          1.506
LGA    K   195_B      L     194          3.850
LGA    -       -      A     195           -
LGA    P   196_B      Q     196          0.290
LGA    K   197_B      T     197          2.075
LGA    I   198_B      -       -           -
LGA    L   199_B      L     198          2.193
LGA    D   200_B      V     199          5.124
LGA    H   201_B      -       -           -
LGA    V   202_B      -       -           -
LGA    W   203_B      -       -           -
LGA    R   204_B      -       -           -
LGA    Y   205_B      E     200          4.783
LGA    D   206_B      F     201          4.723
LGA    F   207_B      M     202          3.504
LGA    G   208_B      P     203          3.724
LGA    G   209_B      K     204          5.315
LGA    -       -      A     205           -
LGA    D   210_B      D     206          2.706
LGA    -       -      N     207           -
LGA    -       -      W     208           -
LGA    V   211_B      K     209          3.024
LGA    N   212_B      N     210          2.602
LGA    V   213_B      I     211          3.313
LGA    V   214_B      L     212          2.796
LGA    E   215_B      L     213          1.318
LGA    S   216_B      G     214          2.137
LGA    Y   217_B      K     215          2.184
LGA    V   218_B      W     216          0.795
LGA    S   219_B      S     217          1.858
LGA    Y   220_B      G     218          3.054
LGA    L   221_B      W     219          2.626
LGA    R   222_B      I     220          2.602
LGA    R   223_B      E     221          3.463
LGA    K   224_B      Q     222          3.548
LGA    I   225_B      -       -           -
LGA    D   226_B      R     223          0.965
LGA    T   227_B      I     224           #
LGA    G   228_B      -       -           -
LGA    E   229_B      -       -           -
LGA    K   230_B      -       -           -
LGA    R   231_B      I     225           #
LGA    L   232_B      I     226          1.136
LGA    L   233_B      P     227          4.022
LGA    H   234_B      -       -           -
LGA    T   235_B      -       -           -
LGA    L   236_B      -       -           -
LGA    R   237_B      -       -           -
LGA    G   238_B      -       -           -
LGA    V   239_B      -       -           -
LGA    G   240_B      -       -           -
LGA    Y   241_B      -       -           -
LGA    V   242_B      -       -           -
LGA    L   243_B      -       -           -
LGA    R   244_B      S     228          2.207
LGA    E   245_B      -       -           -
LGA    P   246_B      L     229          4.213
LGA    -       -      S     230           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103  134    5.0     67    2.91    13.43     31.409     2.229

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.727906 * X  +   0.456269 * Y  +  -0.511830 * Z  + -16.078989
  Y_new =  -0.548004 * X  +   0.835772 * Y  +  -0.034306 * Z  +  32.032093
  Z_new =   0.412121 * X  +   0.305457 * Y  +   0.858401 * Z  +  26.239061 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.341872   -2.799721  [ DEG:    19.5878   -160.4122 ]
  Theta =  -0.424780   -2.716812  [ DEG:   -24.3381   -155.6619 ]
  Phi   =  -0.645323    2.496270  [ DEG:   -36.9743    143.0257 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pmu_B                                        
REMARK     2: T0443_97_230.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pmu_B.T0443_97_230.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103  134   5.0   67   2.91   13.43  31.409
REMARK  ---------------------------------------------------------- 
MOLECULE 2pmu_B
HEADER    TRANSCRIPTION REGULATION                23-APR-07   2PMU              
TITLE     CRYSTAL STRUCTURE OF THE DNA-BINDING DOMAIN OF PHOP                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RESPONSE REGULATOR PHOP;                                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: DNA-BINDING DOMAIN, RESIDUES 144-247;                      
COMPND   5 SYNONYM: POSSIBLE TWO COMPONENT SYSTEM RESPONSE                      
COMPND   6 TRANSCRIPTIONAL POSITIVE REGULATOR PHOP;                             
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: H37RV;                                                       
SOURCE   5 GENE: PHOP;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28                                     
KEYWDS    WINGED HELIX-TUN-HELX, TRANSCRIPTION REGULATION                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.WANG                                                                
REVDAT   1   26-FEB-08 2PMU    0                                                
JRNL        AUTH   S.WANG,J.ENGOHANG-NDONG,I.SMITH                              
JRNL        TITL   STRUCTURE OF THE DNA-BINDING DOMAIN OF THE                   
JRNL        TITL 2 RESPONSE REGULATOR PHOP FROM MYCOBACTERIUM                   
JRNL        TITL 3 TUBERCULOSIS                                                 
JRNL        REF    BIOCHEMISTRY                  V.  46 14751 2007              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 1.78 ANGSTROMS.                                          
DBREF  2PMU A  144   247  UNP    P71814   P71814_MYCTU   144    247             
DBREF  2PMU B  144   247  UNP    P71814   P71814_MYCTU   144    247             
DBREF  2PMU C  144   247  UNP    P71814   P71814_MYCTU   144    247             
DBREF  2PMU D  144   247  UNP    P71814   P71814_MYCTU   144    247             
DBREF  2PMU E  144   247  UNP    P71814   P71814_MYCTU   144    247             
DBREF  2PMU F  144   247  UNP    P71814   P71814_MYCTU   144    247             
SEQRES   1 A  110  GLY THR HIS MET LYS GLU PRO ARG ASN VAL ARG LEU THR          
SEQRES   2 A  110  PHE ALA ASP ILE GLU LEU ASP GLU GLU THR HIS GLU VAL          
SEQRES   3 A  110  TRP LYS ALA GLY GLN PRO VAL SER LEU SER PRO THR GLU          
SEQRES   4 A  110  PHE THR LEU LEU ARG TYR PHE VAL ILE ASN ALA GLY THR          
SEQRES   5 A  110  VAL LEU SER LYS PRO LYS ILE LEU ASP HIS VAL TRP ARG          
SEQRES   6 A  110  TYR ASP PHE GLY GLY ASP VAL ASN VAL VAL GLU SER TYR          
SEQRES   7 A  110  VAL SER TYR LEU ARG ARG LYS ILE ASP THR GLY GLU LYS          
SEQRES   8 A  110  ARG LEU LEU HIS THR LEU ARG GLY VAL GLY TYR VAL LEU          
SEQRES   9 A  110  ARG GLU PRO ARG LYS LEU                                      
SEQRES   1 B  110  GLY THR HIS MET LYS GLU PRO ARG ASN VAL ARG LEU THR          
SEQRES   2 B  110  PHE ALA ASP ILE GLU LEU ASP GLU GLU THR HIS GLU VAL          
SEQRES   3 B  110  TRP LYS ALA GLY GLN PRO VAL SER LEU SER PRO THR GLU          
SEQRES   4 B  110  PHE THR LEU LEU ARG TYR PHE VAL ILE ASN ALA GLY THR          
SEQRES   5 B  110  VAL LEU SER LYS PRO LYS ILE LEU ASP HIS VAL TRP ARG          
SEQRES   6 B  110  TYR ASP PHE GLY GLY ASP VAL ASN VAL VAL GLU SER TYR          
SEQRES   7 B  110  VAL SER TYR LEU ARG ARG LYS ILE ASP THR GLY GLU LYS          
SEQRES   8 B  110  ARG LEU LEU HIS THR LEU ARG GLY VAL GLY TYR VAL LEU          
SEQRES   9 B  110  ARG GLU PRO ARG LYS LEU                                      
SEQRES   1 C  110  GLY THR HIS MET LYS GLU PRO ARG ASN VAL ARG LEU THR          
SEQRES   2 C  110  PHE ALA ASP ILE GLU LEU ASP GLU GLU THR HIS GLU VAL          
SEQRES   3 C  110  TRP LYS ALA GLY GLN PRO VAL SER LEU SER PRO THR GLU          
SEQRES   4 C  110  PHE THR LEU LEU ARG TYR PHE VAL ILE ASN ALA GLY THR          
SEQRES   5 C  110  VAL LEU SER LYS PRO LYS ILE LEU ASP HIS VAL TRP ARG          
SEQRES   6 C  110  TYR ASP PHE GLY GLY ASP VAL ASN VAL VAL GLU SER TYR          
SEQRES   7 C  110  VAL SER TYR LEU ARG ARG LYS ILE ASP THR GLY GLU LYS          
SEQRES   8 C  110  ARG LEU LEU HIS THR LEU ARG GLY VAL GLY TYR VAL LEU          
SEQRES   9 C  110  ARG GLU PRO ARG LYS LEU                                      
SEQRES   1 D  110  GLY THR HIS MET LYS GLU PRO ARG ASN VAL ARG LEU THR          
SEQRES   2 D  110  PHE ALA ASP ILE GLU LEU ASP GLU GLU THR HIS GLU VAL          
SEQRES   3 D  110  TRP LYS ALA GLY GLN PRO VAL SER LEU SER PRO THR GLU          
SEQRES   4 D  110  PHE THR LEU LEU ARG TYR PHE VAL ILE ASN ALA GLY THR          
SEQRES   5 D  110  VAL LEU SER LYS PRO LYS ILE LEU ASP HIS VAL TRP ARG          
SEQRES   6 D  110  TYR ASP PHE GLY GLY ASP VAL ASN VAL VAL GLU SER TYR          
SEQRES   7 D  110  VAL SER TYR LEU ARG ARG LYS ILE ASP THR GLY GLU LYS          
SEQRES   8 D  110  ARG LEU LEU HIS THR LEU ARG GLY VAL GLY TYR VAL LEU          
SEQRES   9 D  110  ARG GLU PRO ARG LYS LEU                                      
SEQRES   1 E  110  GLY THR HIS MET LYS GLU PRO ARG ASN VAL ARG LEU THR          
SEQRES   2 E  110  PHE ALA ASP ILE GLU LEU ASP GLU GLU THR HIS GLU VAL          
SEQRES   3 E  110  TRP LYS ALA GLY GLN PRO VAL SER LEU SER PRO THR GLU          
SEQRES   4 E  110  PHE THR LEU LEU ARG TYR PHE VAL ILE ASN ALA GLY THR          
SEQRES   5 E  110  VAL LEU SER LYS PRO LYS ILE LEU ASP HIS VAL TRP ARG          
SEQRES   6 E  110  TYR ASP PHE GLY GLY ASP VAL ASN VAL VAL GLU SER TYR          
SEQRES   7 E  110  VAL SER TYR LEU ARG ARG LYS ILE ASP THR GLY GLU LYS          
SEQRES   8 E  110  ARG LEU LEU HIS THR LEU ARG GLY VAL GLY TYR VAL LEU          
SEQRES   9 E  110  ARG GLU PRO ARG LYS LEU                                      
SEQRES   1 F  110  GLY THR HIS MET LYS GLU PRO ARG ASN VAL ARG LEU THR          
SEQRES   2 F  110  PHE ALA ASP ILE GLU LEU ASP GLU GLU THR HIS GLU VAL          
SEQRES   3 F  110  TRP LYS ALA GLY GLN PRO VAL SER LEU SER PRO THR GLU          
SEQRES   4 F  110  PHE THR LEU LEU ARG TYR PHE VAL ILE ASN ALA GLY THR          
SEQRES   5 F  110  VAL LEU SER LYS PRO LYS ILE LEU ASP HIS VAL TRP ARG          
SEQRES   6 F  110  TYR ASP PHE GLY GLY ASP VAL ASN VAL VAL GLU SER TYR          
SEQRES   7 F  110  VAL SER TYR LEU ARG ARG LYS ILE ASP THR GLY GLU LYS          
SEQRES   8 F  110  ARG LEU LEU HIS THR LEU ARG GLY VAL GLY TYR VAL LEU          
SEQRES   9 F  110  ARG GLU PRO ARG LYS LEU                                      
HET    PO4  A1004       5                                                       
HET      K  A2002       1                                                       
HET     CL  B3003       1                                                       
HET    PO4  D1001       9                                                       
HET    PO4  D1002       5                                                       
HET      K  D2001       1                                                       
HET     CL  D3004       1                                                       
HET    PO4  E1003       5                                                       
HET      K  E2003       1                                                       
HET     CL  E3001       1                                                       
HET     CL  E3002       1                                                       
HET    UNX  A6002       1                                                       
HET    GLY  B4001       5                                                       
HET    GLY  B4002       5                                                       
HET    GLY  B4003       5                                                       
HET    UNX  B5002       1                                                       
HET    UNX  D6001       1                                                       
HET    UNX  E5001       1                                                       
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM       K POTASSIUM ION                                                    
HETNAM      CL CHLORIDE ION                                                     
HETNAM     UNX UNKNOWN ATOM OR ION                                              
HETNAM     GLY GLYCINE                                                          
FORMUL   7  PO4    4(O4 P 3-)                                                   
FORMUL   8    K    3(K 1+)                                                      
FORMUL   9   CL    4(CL 1-)                                                     
FORMUL  18  UNX    4(X)                                                         
FORMUL  19  GLY    3(C2 H5 N O2)                                                
FORMUL  23  HOH   *489(H2 O)                                                    
CRYST1  103.884  101.129   86.930  90.00 126.72  90.00 C 1 2 1      24          
ATOM    807  N   LYS B 144       9.011  -1.083  32.639  1.00 51.52           N  
ATOM    808  CA  LYS B 144       8.356  -0.021  33.462  1.00 52.43           C  
ATOM    809  C   LYS B 144       7.267   0.777  32.687  1.00 51.46           C  
ATOM    810  O   LYS B 144       6.362   1.349  33.298  1.00 51.81           O  
ATOM    811  CB  LYS B 144       9.442   0.897  34.047  1.00 52.47           C  
ATOM    812  CG  LYS B 144       9.010   1.825  35.190  1.00 52.25           C  
ATOM    813  CD  LYS B 144       9.898   3.074  35.246  1.00 53.17           C  
ATOM    814  CE  LYS B 144       9.682   3.979  34.016  1.00 54.37           C  
ATOM    815  NZ  LYS B 144      10.805   4.932  33.772  1.00 52.10           N  
ATOM    816  N   GLU B 145       7.353   0.796  31.352  1.00 52.38           N  
ATOM    817  CA  GLU B 145       6.342   1.433  30.468  1.00 52.71           C  
ATOM    818  C   GLU B 145       6.051   0.742  29.096  1.00 49.77           C  
ATOM    819  O   GLU B 145       5.319   1.314  28.270  1.00 50.13           O  
ATOM    820  CB  GLU B 145       6.645   2.930  30.241  1.00 55.11           C  
ATOM    821  CG  GLU B 145       8.117   3.286  29.931  1.00 57.12           C  
ATOM    822  CD  GLU B 145       8.679   2.692  28.620  1.00 57.43           C  
ATOM    823  OE1 GLU B 145       7.916   2.420  27.667  1.00 55.35           O  
ATOM    824  OE2 GLU B 145       9.914   2.519  28.549  1.00 56.81           O  
ATOM    825  N   PRO B 146       6.618  -0.467  28.845  1.00 45.62           N  
ATOM    826  CA  PRO B 146       6.235  -1.232  27.645  1.00 41.92           C  
ATOM    827  C   PRO B 146       4.808  -1.764  27.816  1.00 39.64           C  
ATOM    828  O   PRO B 146       4.608  -2.879  28.307  1.00 37.49           O  
ATOM    829  CB  PRO B 146       7.245  -2.381  27.616  1.00 44.66           C  
ATOM    830  CG  PRO B 146       7.708  -2.538  29.012  1.00 44.63           C  
ATOM    831  CD  PRO B 146       7.616  -1.191  29.658  1.00 45.26           C  
ATOM    832  N   ARG B 147       3.826  -0.944  27.456  1.00 36.39           N  
ATOM    833  CA  ARG B 147       2.429  -1.195  27.862  1.00 36.79           C  
ATOM    834  C   ARG B 147       1.370  -0.818  26.816  1.00 39.39           C  
ATOM    835  O   ARG B 147       1.508   0.193  26.126  1.00 37.50           O  
ATOM    836  CB  ARG B 147       2.196  -0.410  29.160  1.00 41.41           C  
ATOM    837  CG  ARG B 147       0.854  -0.547  29.824  1.00 45.81           C  
ATOM    838  CD  ARG B 147       0.410   0.827  30.270  1.00 49.77           C  
ATOM    839  NE  ARG B 147       0.776   1.162  31.645  1.00 51.59           N  
ATOM    840  CZ  ARG B 147       0.850   2.406  32.108  1.00 53.31           C  
ATOM    841  NH1 ARG B 147       0.602   3.429  31.300  1.00 56.86           N  
ATOM    842  NH2 ARG B 147       1.161   2.638  33.370  1.00 55.53           N  
ATOM    843  N   ASN B 148       0.295  -1.613  26.719  1.00 28.18           N  
ATOM    844  CA  ASN B 148      -0.884  -1.212  25.973  1.00 27.73           C  
ATOM    845  C   ASN B 148      -2.124  -1.421  26.847  1.00 31.55           C  
ATOM    846  O   ASN B 148      -2.405  -2.551  27.234  1.00 32.02           O  
ATOM    847  CB  ASN B 148      -1.072  -2.003  24.673  1.00 34.67           C  
ATOM    848  CG  ASN B 148      -2.147  -1.384  23.796  1.00 39.82           C  
ATOM    849  OD1 ASN B 148      -3.301  -1.279  24.198  1.00 38.95           O  
ATOM    850  ND2 ASN B 148      -1.759  -0.924  22.591  1.00 48.03           N  
ATOM    851  N   VAL B 149      -2.819  -0.346  27.183  1.00 30.27           N  
ATOM    852  CA  VAL B 149      -3.986  -0.477  28.023  1.00 34.82           C  
ATOM    853  C   VAL B 149      -5.201   0.125  27.383  1.00 32.62           C  
ATOM    854  O   VAL B 149      -6.044   0.636  28.079  1.00 35.20           O  
ATOM    855  CB  VAL B 149      -3.765   0.100  29.435  1.00 38.39           C  
ATOM    856  CG1 VAL B 149      -2.784  -0.772  30.170  1.00 40.29           C  
ATOM    857  CG2 VAL B 149      -3.254   1.518  29.371  1.00 40.57           C  
ATOM    858  N   ARG B 150      -5.305  -0.014  26.057  1.00 29.99           N  
ATOM    859  CA  ARG B 150      -6.407   0.562  25.326  1.00 33.43           C  
ATOM    860  C   ARG B 150      -7.357  -0.518  24.873  1.00 35.57           C  
ATOM    861  O   ARG B 150      -6.904  -1.631  24.541  1.00 38.45           O  
ATOM    862  CB  ARG B 150      -5.844   1.255  24.091  1.00 40.20           C  
ATOM    863  CG  ARG B 150      -5.026   2.528  24.461  1.00 50.00           C  
ATOM    864  CD  ARG B 150      -4.635   3.394  23.251  1.00 55.35           C  
ATOM    865  NE  ARG B 150      -3.825   2.711  22.250  1.00 63.65           N  
ATOM    866  CZ  ARG B 150      -2.491   2.652  22.257  1.00 67.19           C  
ATOM    867  NH1 ARG B 150      -1.848   2.007  21.289  1.00 67.63           N  
ATOM    868  NH2 ARG B 150      -1.793   3.225  23.230  1.00 69.83           N  
ATOM    869  N   LEU B 151      -8.639  -0.199  24.825  1.00 33.37           N  
ATOM    870  CA  LEU B 151      -9.602  -1.141  24.251  1.00 34.80           C  
ATOM    871  C   LEU B 151     -10.259  -0.407  23.099  1.00 36.04           C  
ATOM    872  O   LEU B 151     -10.403   0.807  23.101  1.00 35.42           O  
ATOM    873  CB  LEU B 151     -10.704  -1.471  25.280  1.00 35.45           C  
ATOM    874  CG  LEU B 151     -10.201  -1.898  26.648  1.00 37.61           C  
ATOM    875  CD1 LEU B 151     -11.421  -2.152  27.579  1.00 40.28           C  
ATOM    876  CD2 LEU B 151      -9.296  -3.155  26.548  1.00 38.65           C  
ATOM    877  N   THR B 152     -10.713  -1.154  22.117  1.00 36.59           N  
ATOM    878  CA  THR B 152     -11.314  -0.541  20.934  1.00 41.00           C  
ATOM    879  C   THR B 152     -12.557  -1.314  20.550  1.00 43.45           C  
ATOM    880  O   THR B 152     -12.595  -2.535  20.698  1.00 39.33           O  
ATOM    881  CB  THR B 152     -10.329  -0.586  19.735  1.00 48.76           C  
ATOM    882  OG1 THR B 152      -9.219   0.277  20.017  1.00 51.67           O  
ATOM    883  CG2 THR B 152     -11.015  -0.087  18.432  1.00 52.43           C  
ATOM    884  N   PHE B 153     -13.580  -0.611  20.071  1.00 41.47           N  
ATOM    885  CA  PHE B 153     -14.632  -1.278  19.312  1.00 39.78           C  
ATOM    886  C   PHE B 153     -14.985  -0.292  18.205  1.00 34.81           C  
ATOM    887  O   PHE B 153     -15.380   0.829  18.537  1.00 36.92           O  
ATOM    888  CB  PHE B 153     -15.859  -1.513  20.200  1.00 39.88           C  
ATOM    889  CG  PHE B 153     -17.015  -2.045  19.438  1.00 38.71           C  
ATOM    890  CD1 PHE B 153     -16.985  -3.344  18.945  1.00 41.49           C  
ATOM    891  CD2 PHE B 153     -18.087  -1.228  19.106  1.00 38.45           C  
ATOM    892  CE1 PHE B 153     -18.037  -3.851  18.150  1.00 42.05           C  
ATOM    893  CE2 PHE B 153     -19.130  -1.739  18.312  1.00 38.31           C  
ATOM    894  CZ  PHE B 153     -19.098  -3.037  17.843  1.00 37.90           C  
ATOM    895  N   ALA B 154     -14.902  -0.706  16.952  1.00 34.73           N  
ATOM    896  CA  ALA B 154     -15.311   0.180  15.830  1.00 34.97           C  
ATOM    897  C   ALA B 154     -14.548   1.476  15.975  1.00 36.04           C  
ATOM    898  O   ALA B 154     -13.315   1.443  16.018  1.00 34.83           O  
ATOM    899  CB  ALA B 154     -16.821   0.417  15.880  1.00 36.71           C  
ATOM    900  N   ASP B 155     -15.237   2.626  16.090  1.00 33.11           N  
ATOM    901  CA  ASP B 155     -14.514   3.903  16.251  1.00 33.27           C  
ATOM    902  C   ASP B 155     -14.589   4.437  17.658  1.00 34.27           C  
ATOM    903  O   ASP B 155     -14.515   5.652  17.868  1.00 35.05           O  
ATOM    904  CB  ASP B 155     -14.964   4.992  15.251  1.00 35.10           C  
ATOM    905  CG  ASP B 155     -16.426   5.336  15.397  1.00 38.35           C  
ATOM    906  OD1 ASP B 155     -17.080   4.694  16.255  1.00 35.61           O  
ATOM    907  OD2 ASP B 155     -16.899   6.243  14.670  1.00 36.54           O  
ATOM    908  N   ILE B 156     -14.731   3.539  18.633  1.00 34.82           N  
ATOM    909  CA  ILE B 156     -14.684   3.935  20.043  1.00 38.06           C  
ATOM    910  C   ILE B 156     -13.340   3.476  20.593  1.00 39.39           C  
ATOM    911  O   ILE B 156     -12.944   2.325  20.330  1.00 39.58           O  
ATOM    912  CB  ILE B 156     -15.835   3.238  20.830  1.00 38.32           C  
ATOM    913  CG1 ILE B 156     -17.207   3.727  20.317  1.00 41.12           C  
ATOM    914  CG2 ILE B 156     -15.689   3.468  22.343  1.00 39.07           C  
ATOM    915  CD1 ILE B 156     -18.348   2.866  20.754  1.00 42.16           C  
ATOM    916  N   GLU B 157     -12.656   4.343  21.364  1.00 34.88           N  
ATOM    917  CA  GLU B 157     -11.340   4.012  21.880  1.00 34.80           C  
ATOM    918  C   GLU B 157     -11.417   4.349  23.380  1.00 33.78           C  
ATOM    919  O   GLU B 157     -11.925   5.393  23.777  1.00 36.39           O  
ATOM    920  CB  GLU B 157     -10.267   4.931  21.253  1.00 38.73           C  
ATOM    921  CG  GLU B 157     -10.199   4.823  19.753  1.00 37.66           C  
ATOM    922  CD  GLU B 157      -9.226   5.833  19.164  1.00 41.50           C  
ATOM    923  OE1 GLU B 157      -8.036   5.856  19.608  1.00 37.99           O  
ATOM    924  OE2 GLU B 157      -9.677   6.549  18.248  1.00 37.47           O  
ATOM    925  N   LEU B 158     -10.942   3.461  24.223  1.00 32.17           N  
ATOM    926  CA  LEU B 158     -10.931   3.734  25.669  1.00 33.68           C  
ATOM    927  C   LEU B 158      -9.509   3.511  26.172  1.00 36.82           C  
ATOM    928  O   LEU B 158      -8.841   2.624  25.673  1.00 37.93           O  
ATOM    929  CB  LEU B 158     -11.819   2.695  26.412  1.00 39.87           C  
ATOM    930  CG  LEU B 158     -13.333   2.570  26.237  1.00 47.72           C  
ATOM    931  CD1 LEU B 158     -13.719   1.921  24.911  1.00 45.56           C  
ATOM    932  CD2 LEU B 158     -13.854   1.708  27.395  1.00 44.75           C  
ATOM    933  N   ASP B 159      -9.064   4.281  27.171  1.00 33.59           N  
ATOM    934  CA  ASP B 159      -7.764   4.021  27.832  1.00 33.41           C  
ATOM    935  C   ASP B 159      -8.104   3.614  29.245  1.00 31.73           C  
ATOM    936  O   ASP B 159      -8.692   4.406  29.974  1.00 34.08           O  
ATOM    937  CB  ASP B 159      -6.965   5.352  27.863  1.00 37.87           C  
ATOM    938  CG  ASP B 159      -5.572   5.193  28.414  1.00 42.68           C  
ATOM    939  OD1 ASP B 159      -5.403   4.647  29.526  1.00 40.30           O  
ATOM    940  OD2 ASP B 159      -4.608   5.626  27.738  1.00 43.40           O  
ATOM    941  N   GLU B 160      -7.772   2.375  29.637  1.00 32.23           N  
ATOM    942  CA  GLU B 160      -8.127   1.884  30.969  1.00 33.90           C  
ATOM    943  C   GLU B 160      -7.407   2.567  32.124  1.00 32.26           C  
ATOM    944  O   GLU B 160      -7.844   2.483  33.275  1.00 35.36           O  
ATOM    945  CB  GLU B 160      -7.812   0.387  31.021  1.00 34.23           C  
ATOM    946  CG  GLU B 160      -8.782  -0.357  30.084  1.00 38.52           C  
ATOM    947  CD  GLU B 160      -9.878  -0.958  30.897  1.00 50.54           C  
ATOM    948  OE1 GLU B 160      -9.933  -2.180  30.971  1.00 48.10           O  
ATOM    949  OE2 GLU B 160     -10.665  -0.191  31.502  1.00 55.47           O  
ATOM    950  N   GLU B 161      -6.263   3.165  31.820  1.00 31.33           N  
ATOM    951  CA  GLU B 161      -5.465   3.832  32.847  1.00 34.01           C  
ATOM    952  C   GLU B 161      -6.010   5.216  33.150  1.00 35.53           C  
ATOM    953  O   GLU B 161      -6.171   5.564  34.340  1.00 38.07           O  
ATOM    954  CB  GLU B 161      -4.017   3.978  32.413  1.00 32.46           C  
ATOM    955  CG  GLU B 161      -3.132   4.519  33.524  1.00 37.00           C  
ATOM    956  CD  GLU B 161      -1.793   4.938  33.023  1.00 41.19           C  
ATOM    957  OE1 GLU B 161      -1.580   4.968  31.785  1.00 46.76           O  
ATOM    958  OE2 GLU B 161      -0.945   5.262  33.886  1.00 45.29           O  
ATOM    959  N   THR B 162      -6.222   5.989  32.095  1.00 33.92           N  
ATOM    960  CA  THR B 162      -6.661   7.409  32.245  1.00 37.46           C  
ATOM    961  C   THR B 162      -8.159   7.606  32.237  1.00 39.37           C  
ATOM    962  O   THR B 162      -8.659   8.701  32.588  1.00 37.99           O  
ATOM    963  CB  THR B 162      -6.049   8.293  31.170  1.00 34.15           C  
ATOM    964  OG1 THR B 162      -6.617   7.980  29.879  1.00 35.92           O  
ATOM    965  CG2 THR B 162      -4.517   8.120  31.138  1.00 38.25           C  
ATOM    966  N   HIS B 163      -8.880   6.568  31.802  1.00 34.47           N  
ATOM    967  CA  HIS B 163     -10.312   6.656  31.548  1.00 34.99           C  
ATOM    968  C   HIS B 163     -10.710   7.672  30.458  1.00 37.02           C  
ATOM    969  O   HIS B 163     -11.886   8.039  30.333  1.00 38.48           O  
ATOM    970  CB  HIS B 163     -11.069   6.961  32.841  1.00 40.31           C  
ATOM    971  CG  HIS B 163     -11.181   5.783  33.749  1.00 46.03           C  
ATOM    972  ND1 HIS B 163     -12.227   5.624  34.635  1.00 53.53           N  
ATOM    973  CD2 HIS B 163     -10.397   4.687  33.882  1.00 49.36           C  
ATOM    974  CE1 HIS B 163     -12.059   4.492  35.299  1.00 52.58           C  
ATOM    975  NE2 HIS B 163     -10.954   3.909  34.866  1.00 52.81           N  
ATOM    976  N   GLU B 164      -9.737   8.096  29.649  1.00 35.34           N  
ATOM    977  CA  GLU B 164     -10.078   8.854  28.479  1.00 35.58           C  
ATOM    978  C   GLU B 164     -10.851   7.973  27.513  1.00 37.21           C  
ATOM    979  O   GLU B 164     -10.611   6.760  27.461  1.00 38.04           O  
ATOM    980  CB  GLU B 164      -8.835   9.358  27.784  1.00 36.66           C  
ATOM    981  CG  GLU B 164      -8.178  10.525  28.521  1.00 39.28           C  
ATOM    982  CD  GLU B 164      -6.742  10.714  28.064  1.00 43.11           C  
ATOM    983  OE1 GLU B 164      -5.863   9.858  28.368  1.00 41.69           O  
ATOM    984  OE2 GLU B 164      -6.488  11.722  27.394  1.00 43.81           O  
ATOM    985  N   VAL B 165     -11.717   8.604  26.749  1.00 36.15           N  
ATOM    986  CA  VAL B 165     -12.476   7.901  25.708  1.00 35.12           C  
ATOM    987  C   VAL B 165     -12.557   8.810  24.508  1.00 38.20           C  
ATOM    988  O   VAL B 165     -12.637  10.065  24.665  1.00 35.62           O  
ATOM    989  CB  VAL B 165     -13.925   7.602  26.243  1.00 37.23           C  
ATOM    990  CG1 VAL B 165     -14.821   7.044  25.096  1.00 37.78           C  
ATOM    991  CG2 VAL B 165     -13.868   6.660  27.516  1.00 37.48           C  
ATOM    992  N   TRP B 166     -12.572   8.192  23.335  1.00 35.62           N  
ATOM    993  CA  TRP B 166     -12.763   8.956  22.084  1.00 35.38           C  
ATOM    994  C   TRP B 166     -13.829   8.247  21.279  1.00 35.53           C  
ATOM    995  O   TRP B 166     -13.878   7.020  21.284  1.00 37.02           O  
ATOM    996  CB  TRP B 166     -11.477   8.973  21.280  1.00 38.03           C  
ATOM    997  CG  TRP B 166     -10.355   9.747  21.943  1.00 33.46           C  
ATOM    998  CD1 TRP B 166     -10.025  11.074  21.715  1.00 36.26           C  
ATOM    999  CD2 TRP B 166      -9.443   9.270  22.934  1.00 36.69           C  
ATOM   1000  NE1 TRP B 166      -8.949  11.431  22.522  1.00 38.97           N  
ATOM   1001  CE2 TRP B 166      -8.579  10.343  23.266  1.00 39.84           C  
ATOM   1002  CE3 TRP B 166      -9.228   8.025  23.527  1.00 38.25           C  
ATOM   1003  CZ2 TRP B 166      -7.528  10.193  24.162  1.00 39.86           C  
ATOM   1004  CZ3 TRP B 166      -8.197   7.891  24.433  1.00 40.13           C  
ATOM   1005  CH2 TRP B 166      -7.368   8.953  24.736  1.00 41.53           C  
ATOM   1006  N   LYS B 167     -14.657   9.012  20.580  1.00 33.54           N  
ATOM   1007  CA  LYS B 167     -15.599   8.429  19.646  1.00 33.83           C  
ATOM   1008  C   LYS B 167     -15.368   9.158  18.356  1.00 35.25           C  
ATOM   1009  O   LYS B 167     -15.447  10.412  18.301  1.00 34.74           O  
ATOM   1010  CB  LYS B 167     -17.043   8.709  20.138  1.00 35.75           C  
ATOM   1011  CG  LYS B 167     -18.150   8.562  19.093  1.00 35.13           C  
ATOM   1012  CD  LYS B 167     -18.344   7.112  18.649  1.00 34.34           C  
ATOM   1013  CE  LYS B 167     -19.525   7.005  17.657  1.00 35.29           C  
ATOM   1014  NZ  LYS B 167     -19.581   5.698  16.919  1.00 37.81           N  
ATOM   1015  N   ALA B 168     -15.145   8.395  17.288  1.00 33.13           N  
ATOM   1016  CA  ALA B 168     -14.826   8.988  16.011  1.00 31.59           C  
ATOM   1017  C   ALA B 168     -13.724  10.066  16.102  1.00 32.90           C  
ATOM   1018  O   ALA B 168     -13.809  11.101  15.431  1.00 31.79           O  
ATOM   1019  CB  ALA B 168     -16.141   9.545  15.271  1.00 35.35           C  
ATOM   1020  N   GLY B 169     -12.719   9.786  16.942  1.00 31.38           N  
ATOM   1021  CA  GLY B 169     -11.525  10.615  17.041  1.00 35.26           C  
ATOM   1022  C   GLY B 169     -11.702  11.754  18.049  1.00 39.98           C  
ATOM   1023  O   GLY B 169     -10.749  12.489  18.331  1.00 38.61           O  
ATOM   1024  N   GLN B 170     -12.932  11.950  18.543  1.00 32.63           N  
ATOM   1025  CA  GLN B 170     -13.237  13.139  19.396  1.00 34.11           C  
ATOM   1026  C   GLN B 170     -13.336  12.724  20.860  1.00 34.69           C  
ATOM   1027  O   GLN B 170     -13.940  11.691  21.190  1.00 36.16           O  
ATOM   1028  CB  GLN B 170     -14.536  13.783  18.948  1.00 32.65           C  
ATOM   1029  CG  GLN B 170     -14.532  14.214  17.504  1.00 38.66           C  
ATOM   1030  CD  GLN B 170     -13.657  15.452  17.234  1.00 48.53           C  
ATOM   1031  OE1 GLN B 170     -12.670  15.721  17.937  1.00 50.70           O  
ATOM   1032  NE2 GLN B 170     -14.000  16.179  16.192  1.00 47.68           N  
ATOM   1033  N   PRO B 171     -12.778  13.541  21.761  1.00 36.61           N  
ATOM   1034  CA  PRO B 171     -12.795  13.119  23.154  1.00 37.34           C  
ATOM   1035  C   PRO B 171     -14.217  13.151  23.746  1.00 38.00           C  
ATOM   1036  O   PRO B 171     -15.060  14.044  23.423  1.00 35.47           O  
ATOM   1037  CB  PRO B 171     -11.864  14.144  23.860  1.00 40.52           C  
ATOM   1038  CG  PRO B 171     -11.843  15.312  23.007  1.00 39.97           C  
ATOM   1039  CD  PRO B 171     -12.091  14.833  21.565  1.00 37.96           C  
ATOM   1040  N   VAL B 172     -14.449  12.180  24.607  1.00 36.45           N  
ATOM   1041  CA  VAL B 172     -15.698  12.007  25.341  1.00 37.92           C  
ATOM   1042  C   VAL B 172     -15.361  11.899  26.826  1.00 38.40           C  
ATOM   1043  O   VAL B 172     -14.463  11.125  27.199  1.00 39.58           O  
ATOM   1044  CB  VAL B 172     -16.422  10.701  24.895  1.00 40.94           C  
ATOM   1045  CG1 VAL B 172     -17.675  10.445  25.757  1.00 42.08           C  
ATOM   1046  CG2 VAL B 172     -16.806  10.774  23.425  1.00 39.82           C  
ATOM   1047  N   SER B 173     -16.033  12.723  27.642  1.00 37.76           N  
ATOM   1048  CA  SER B 173     -15.847  12.681  29.089  0.50 39.65           C  
ATOM   1050  C   SER B 173     -16.891  11.798  29.737  1.00 37.78           C  
ATOM   1051  O   SER B 173     -18.075  12.108  29.680  1.00 39.29           O  
ATOM   1052  CB  SER B 173     -15.916  14.085  29.671  0.50 39.40           C  
ATOM   1054  OG  SER B 173     -14.809  14.836  29.236  0.50 40.58           O  
ATOM   1056  N   LEU B 174     -16.432  10.699  30.358  1.00 38.60           N  
ATOM   1057  CA  LEU B 174     -17.335   9.746  31.064  1.00 36.24           C  
ATOM   1058  C   LEU B 174     -17.110   9.736  32.531  1.00 38.64           C  
ATOM   1059  O   LEU B 174     -15.947   9.814  32.953  1.00 38.62           O  
ATOM   1060  CB  LEU B 174     -17.113   8.320  30.550  1.00 37.53           C  
ATOM   1061  CG  LEU B 174     -17.432   8.089  29.063  1.00 36.75           C  
ATOM   1062  CD1 LEU B 174     -17.465   6.602  28.810  1.00 37.40           C  
ATOM   1063  CD2 LEU B 174     -18.775   8.662  28.648  1.00 37.66           C  
ATOM   1064  N   SER B 175     -18.174   9.540  33.336  1.00 34.24           N  
ATOM   1065  CA  SER B 175     -17.974   9.351  34.793  1.00 33.18           C  
ATOM   1066  C   SER B 175     -17.483   7.909  34.970  1.00 35.08           C  
ATOM   1067  O   SER B 175     -17.528   7.127  34.007  1.00 37.45           O  
ATOM   1068  CB  SER B 175     -19.283   9.512  35.555  1.00 37.31           C  
ATOM   1069  OG  SER B 175     -20.173   8.436  35.248  1.00 31.48           O  
ATOM   1070  N   PRO B 176     -16.954   7.560  36.158  1.00 36.79           N  
ATOM   1071  CA  PRO B 176     -16.457   6.177  36.327  1.00 36.24           C  
ATOM   1072  C   PRO B 176     -17.492   5.082  36.042  1.00 38.10           C  
ATOM   1073  O   PRO B 176     -17.165   4.060  35.418  1.00 35.91           O  
ATOM   1074  CB  PRO B 176     -16.006   6.140  37.790  1.00 37.95           C  
ATOM   1075  CG  PRO B 176     -15.633   7.568  38.103  1.00 40.50           C  
ATOM   1076  CD  PRO B 176     -16.675   8.395  37.339  1.00 35.77           C  
ATOM   1077  N   THR B 177     -18.742   5.319  36.460  1.00 36.33           N  
ATOM   1078  CA  THR B 177     -19.821   4.386  36.185  1.00 34.96           C  
ATOM   1079  C   THR B 177     -20.092   4.254  34.659  1.00 35.85           C  
ATOM   1080  O   THR B 177     -20.211   3.145  34.142  1.00 35.55           O  
ATOM   1081  CB  THR B 177     -21.090   4.733  36.965  1.00 34.31           C  
ATOM   1082  OG1 THR B 177     -20.856   4.604  38.386  1.00 32.79           O  
ATOM   1083  CG2 THR B 177     -22.186   3.724  36.604  1.00 35.39           C  
ATOM   1084  N   GLU B 178     -20.187   5.388  33.964  1.00 36.45           N  
ATOM   1085  CA  GLU B 178     -20.337   5.384  32.494  1.00 33.50           C  
ATOM   1086  C   GLU B 178     -19.164   4.674  31.874  1.00 36.75           C  
ATOM   1087  O   GLU B 178     -19.341   3.922  30.947  1.00 35.87           O  
ATOM   1088  CB  GLU B 178     -20.413   6.802  31.985  1.00 35.83           C  
ATOM   1089  CG  GLU B 178     -21.719   7.500  32.385  1.00 34.33           C  
ATOM   1090  CD  GLU B 178     -21.745   8.969  31.958  1.00 34.29           C  
ATOM   1091  OE1 GLU B 178     -20.657   9.591  31.810  1.00 37.99           O  
ATOM   1092  OE2 GLU B 178     -22.868   9.515  31.811  1.00 38.56           O  
ATOM   1093  N   PHE B 179     -17.960   4.921  32.381  1.00 36.89           N  
ATOM   1094  CA  PHE B 179     -16.770   4.235  31.786  1.00 37.73           C  
ATOM   1095  C   PHE B 179     -16.878   2.725  31.964  1.00 37.91           C  
ATOM   1096  O   PHE B 179     -16.671   1.961  31.012  1.00 36.25           O  
ATOM   1097  CB  PHE B 179     -15.483   4.799  32.371  1.00 39.93           C  
ATOM   1098  CG  PHE B 179     -14.247   4.244  31.727  1.00 36.03           C  
ATOM   1099  CD1 PHE B 179     -13.728   3.013  32.157  1.00 38.96           C  
ATOM   1100  CD2 PHE B 179     -13.665   4.921  30.647  1.00 38.69           C  
ATOM   1101  CE1 PHE B 179     -12.596   2.446  31.559  1.00 37.18           C  
ATOM   1102  CE2 PHE B 179     -12.517   4.372  30.024  1.00 40.34           C  
ATOM   1103  CZ  PHE B 179     -12.018   3.157  30.437  1.00 36.27           C  
ATOM   1104  N   THR B 180     -17.231   2.291  33.178  1.00 34.51           N  
ATOM   1105  CA  THR B 180     -17.321   0.864  33.520  1.00 35.11           C  
ATOM   1106  C   THR B 180     -18.382   0.224  32.641  1.00 36.89           C  
ATOM   1107  O   THR B 180     -18.213  -0.904  32.148  1.00 36.12           O  
ATOM   1108  CB  THR B 180     -17.633   0.685  35.016  1.00 39.64           C  
ATOM   1109  OG1 THR B 180     -16.521   1.194  35.780  1.00 35.29           O  
ATOM   1110  CG2 THR B 180     -17.863  -0.746  35.351  1.00 36.31           C  
ATOM   1111  N   LEU B 181     -19.466   0.966  32.439  1.00 35.66           N  
ATOM   1112  CA  LEU B 181     -20.570   0.452  31.610  1.00 35.51           C  
ATOM   1113  C   LEU B 181     -20.131   0.312  30.166  1.00 35.26           C  
ATOM   1114  O   LEU B 181     -20.383  -0.714  29.509  1.00 34.43           O  
ATOM   1115  CB  LEU B 181     -21.723   1.455  31.710  1.00 38.88           C  
ATOM   1116  CG  LEU B 181     -23.006   1.131  30.972  1.00 41.74           C  
ATOM   1117  CD1 LEU B 181     -23.555  -0.199  31.485  1.00 43.93           C  
ATOM   1118  CD2 LEU B 181     -23.984   2.297  31.219  1.00 42.85           C  
ATOM   1119  N   LEU B 182     -19.475   1.336  29.646  1.00 33.74           N  
ATOM   1120  CA  LEU B 182     -18.968   1.234  28.267  1.00 34.53           C  
ATOM   1121  C   LEU B 182     -17.991   0.074  28.106  1.00 33.47           C  
ATOM   1122  O   LEU B 182     -18.073  -0.709  27.129  1.00 35.24           O  
ATOM   1123  CB  LEU B 182     -18.318   2.554  27.854  1.00 38.46           C  
ATOM   1124  CG  LEU B 182     -17.807   2.544  26.400  1.00 39.78           C  
ATOM   1125  CD1 LEU B 182     -18.914   2.159  25.348  1.00 37.97           C  
ATOM   1126  CD2 LEU B 182     -17.112   3.847  26.048  1.00 40.29           C  
ATOM   1127  N   ARG B 183     -17.053  -0.044  29.048  1.00 36.97           N  
ATOM   1128  CA  ARG B 183     -16.092  -1.151  29.037  1.00 36.48           C  
ATOM   1129  C   ARG B 183     -16.800  -2.489  28.993  1.00 36.21           C  
ATOM   1130  O   ARG B 183     -16.471  -3.373  28.198  1.00 36.29           O  
ATOM   1131  CB  ARG B 183     -15.210  -1.036  30.291  1.00 35.88           C  
ATOM   1132  CG  ARG B 183     -14.267  -2.182  30.463  1.00 38.64           C  
ATOM   1133  CD  ARG B 183     -13.427  -1.911  31.747  1.00 38.22           C  
ATOM   1134  NE  ARG B 183     -12.543  -3.041  31.983  1.00 41.43           N  
ATOM   1135  CZ  ARG B 183     -12.921  -4.217  32.482  1.00 43.34           C  
ATOM   1136  NH1 ARG B 183     -14.187  -4.453  32.814  1.00 46.22           N  
ATOM   1137  NH2 ARG B 183     -12.026  -5.177  32.662  1.00 49.09           N  
ATOM   1138  N   TYR B 184     -17.826  -2.645  29.834  1.00 36.66           N  
ATOM   1139  CA  TYR B 184     -18.584  -3.876  29.885  1.00 34.85           C  
ATOM   1140  C   TYR B 184     -19.252  -4.170  28.534  1.00 35.41           C  
ATOM   1141  O   TYR B 184     -19.237  -5.297  28.075  1.00 36.14           O  
ATOM   1142  CB  TYR B 184     -19.632  -3.810  31.031  1.00 36.89           C  
ATOM   1143  CG  TYR B 184     -20.332  -5.112  31.244  1.00 35.83           C  
ATOM   1144  CD1 TYR B 184     -19.624  -6.240  31.616  1.00 41.11           C  
ATOM   1145  CD2 TYR B 184     -21.705  -5.222  31.048  1.00 37.36           C  
ATOM   1146  CE1 TYR B 184     -20.262  -7.458  31.802  1.00 40.75           C  
ATOM   1147  CE2 TYR B 184     -22.352  -6.411  31.235  1.00 39.16           C  
ATOM   1148  CZ  TYR B 184     -21.617  -7.534  31.603  1.00 40.58           C  
ATOM   1149  OH  TYR B 184     -22.261  -8.723  31.789  1.00 40.59           O  
ATOM   1150  N   PHE B 185     -19.849  -3.152  27.890  1.00 34.91           N  
ATOM   1151  CA  PHE B 185     -20.421  -3.385  26.532  1.00 31.22           C  
ATOM   1152  C   PHE B 185     -19.344  -3.734  25.522  1.00 30.87           C  
ATOM   1153  O   PHE B 185     -19.581  -4.564  24.631  1.00 35.02           O  
ATOM   1154  CB  PHE B 185     -21.184  -2.119  26.041  1.00 33.50           C  
ATOM   1155  CG  PHE B 185     -22.563  -1.958  26.640  1.00 29.87           C  
ATOM   1156  CD1 PHE B 185     -23.563  -2.848  26.336  1.00 31.80           C  
ATOM   1157  CD2 PHE B 185     -22.871  -0.852  27.410  1.00 32.98           C  
ATOM   1158  CE1 PHE B 185     -24.847  -2.701  26.859  1.00 37.99           C  
ATOM   1159  CE2 PHE B 185     -24.174  -0.669  27.943  1.00 32.22           C  
ATOM   1160  CZ  PHE B 185     -25.153  -1.585  27.664  1.00 34.20           C  
ATOM   1161  N   VAL B 186     -18.196  -3.064  25.611  1.00 35.95           N  
ATOM   1162  CA  VAL B 186     -17.137  -3.253  24.618  1.00 37.15           C  
ATOM   1163  C   VAL B 186     -16.575  -4.676  24.737  1.00 39.60           C  
ATOM   1164  O   VAL B 186     -16.489  -5.445  23.742  1.00 39.68           O  
ATOM   1165  CB  VAL B 186     -16.026  -2.139  24.738  1.00 38.00           C  
ATOM   1166  CG1 VAL B 186     -14.742  -2.562  23.948  1.00 40.17           C  
ATOM   1167  CG2 VAL B 186     -16.515  -0.781  24.217  1.00 38.18           C  
ATOM   1168  N   ILE B 187     -16.222  -5.057  25.960  1.00 39.46           N  
ATOM   1169  CA  ILE B 187     -15.697  -6.400  26.216  1.00 40.70           C  
ATOM   1170  C   ILE B 187     -16.708  -7.437  25.784  1.00 40.43           C  
ATOM   1171  O   ILE B 187     -16.335  -8.509  25.306  1.00 45.61           O  
ATOM   1172  CB  ILE B 187     -15.313  -6.574  27.725  1.00 39.48           C  
ATOM   1173  CG1 ILE B 187     -14.087  -5.692  28.036  1.00 41.24           C  
ATOM   1174  CG2 ILE B 187     -15.158  -8.037  28.075  1.00 46.80           C  
ATOM   1175  CD1 ILE B 187     -13.796  -5.565  29.544  1.00 48.03           C  
ATOM   1176  N   ASN B 188     -17.996  -7.098  25.875  1.00 38.67           N  
ATOM   1177  CA  ASN B 188     -19.067  -8.015  25.478  1.00 36.69           C  
ATOM   1178  C   ASN B 188     -19.838  -7.648  24.192  1.00 37.18           C  
ATOM   1179  O   ASN B 188     -21.023  -7.945  24.049  1.00 38.18           O  
ATOM   1180  CB  ASN B 188     -20.013  -8.222  26.656  1.00 37.70           C  
ATOM   1181  CG  ASN B 188     -19.300  -8.847  27.848  1.00 41.96           C  
ATOM   1182  OD1 ASN B 188     -18.988 -10.044  27.831  1.00 45.18           O  
ATOM   1183  ND2 ASN B 188     -19.019  -8.050  28.865  1.00 39.40           N  
ATOM   1184  N   ALA B 189     -19.148  -7.014  23.251  1.00 39.01           N  
ATOM   1185  CA  ALA B 189     -19.768  -6.516  22.015  1.00 39.56           C  
ATOM   1186  C   ALA B 189     -20.441  -7.635  21.232  1.00 39.71           C  
ATOM   1187  O   ALA B 189     -19.913  -8.746  21.140  1.00 40.76           O  
ATOM   1188  CB  ALA B 189     -18.723  -5.820  21.159  1.00 41.84           C  
ATOM   1189  N   GLY B 190     -21.633  -7.354  20.712  1.00 37.32           N  
ATOM   1190  CA  GLY B 190     -22.420  -8.312  19.946  1.00 36.59           C  
ATOM   1191  C   GLY B 190     -23.284  -9.217  20.814  1.00 41.81           C  
ATOM   1192  O   GLY B 190     -24.141  -9.930  20.301  1.00 42.07           O  
ATOM   1193  N   THR B 191     -23.042  -9.215  22.126  1.00 42.06           N  
ATOM   1194  CA  THR B 191     -23.865  -9.983  23.068  1.00 42.35           C  
ATOM   1195  C   THR B 191     -25.024  -9.139  23.589  1.00 41.24           C  
ATOM   1196  O   THR B 191     -24.835  -7.981  23.978  1.00 40.67           O  
ATOM   1197  CB  THR B 191     -23.037 -10.473  24.272  1.00 43.73           C  
ATOM   1198  OG1 THR B 191     -21.925 -11.249  23.811  1.00 41.35           O  
ATOM   1199  CG2 THR B 191     -23.902 -11.317  25.217  1.00 46.69           C  
ATOM   1200  N   VAL B 192     -26.219  -9.719  23.619  1.00 42.70           N  
ATOM   1201  CA  VAL B 192     -27.357  -9.016  24.219  1.00 41.81           C  
ATOM   1202  C   VAL B 192     -27.351  -9.171  25.753  1.00 42.74           C  
ATOM   1203  O   VAL B 192     -27.377 -10.286  26.284  1.00 40.79           O  
ATOM   1204  CB  VAL B 192     -28.686  -9.434  23.583  1.00 42.96           C  
ATOM   1205  CG1 VAL B 192     -29.852  -8.801  24.306  1.00 41.73           C  
ATOM   1206  CG2 VAL B 192     -28.716  -9.029  22.113  1.00 43.06           C  
ATOM   1207  N   LEU B 193     -27.306  -8.034  26.454  1.00 40.83           N  
ATOM   1208  CA  LEU B 193     -27.131  -8.009  27.904  1.00 37.67           C  
ATOM   1209  C   LEU B 193     -28.377  -7.458  28.586  1.00 35.89           C  
ATOM   1210  O   LEU B 193     -28.761  -6.304  28.362  1.00 36.08           O  
ATOM   1211  CB  LEU B 193     -25.901  -7.162  28.289  1.00 40.19           C  
ATOM   1212  CG  LEU B 193     -24.546  -7.494  27.640  1.00 41.33           C  
ATOM   1213  CD1 LEU B 193     -23.580  -6.315  27.793  1.00 41.24           C  
ATOM   1214  CD2 LEU B 193     -23.944  -8.774  28.176  1.00 40.58           C  
ATOM   1215  N   SER B 194     -29.011  -8.297  29.414  1.00 35.96           N  
ATOM   1216  CA  SER B 194     -30.184  -7.900  30.184  1.00 35.95           C  
ATOM   1217  C   SER B 194     -29.795  -6.852  31.220  1.00 33.16           C  
ATOM   1218  O   SER B 194     -28.615  -6.661  31.521  1.00 37.95           O  
ATOM   1219  CB  SER B 194     -30.779  -9.107  30.908  1.00 37.65           C  
ATOM   1220  OG  SER B 194     -29.952  -9.446  32.006  1.00 44.56           O  
ATOM   1221  N   LYS B 195     -30.781  -6.159  31.752  1.00 36.03           N  
ATOM   1222  CA  LYS B 195     -30.511  -5.221  32.823  1.00 35.74           C  
ATOM   1223  C   LYS B 195     -29.936  -5.878  34.106  1.00 35.60           C  
ATOM   1224  O   LYS B 195     -29.003  -5.347  34.670  1.00 36.37           O  
ATOM   1225  CB  LYS B 195     -31.718  -4.322  33.063  1.00 36.55           C  
ATOM   1226  CG  LYS B 195     -31.976  -3.390  31.888  1.00 35.67           C  
ATOM   1227  CD  LYS B 195     -33.023  -2.323  32.188  1.00 41.95           C  
ATOM   1228  CE  LYS B 195     -34.318  -2.645  31.465  1.00 40.53           C  
ATOM   1229  NZ  LYS B 195     -35.338  -1.578  31.664  1.00 44.40           N  
ATOM   1230  N   PRO B 196     -30.483  -7.033  34.561  1.00 40.81           N  
ATOM   1231  CA  PRO B 196     -29.810  -7.798  35.638  1.00 41.64           C  
ATOM   1232  C   PRO B 196     -28.261  -8.025  35.543  1.00 45.56           C  
ATOM   1233  O   PRO B 196     -27.551  -7.746  36.531  1.00 44.97           O  
ATOM   1234  CB  PRO B 196     -30.590  -9.107  35.657  1.00 43.79           C  
ATOM   1235  CG  PRO B 196     -31.983  -8.681  35.291  1.00 41.58           C  
ATOM   1236  CD  PRO B 196     -31.770  -7.652  34.200  1.00 40.43           C  
ATOM   1237  N   LYS B 197     -27.737  -8.484  34.395  1.00 46.75           N  
ATOM   1238  CA  LYS B 197     -26.288  -8.739  34.247  1.00 41.26           C  
ATOM   1239  C   LYS B 197     -25.467  -7.471  34.377  1.00 47.13           C  
ATOM   1240  O   LYS B 197     -24.397  -7.442  34.992  1.00 48.36           O  
ATOM   1241  CB  LYS B 197     -25.937  -9.331  32.874  1.00 48.21           C  
ATOM   1242  CG  LYS B 197     -26.826 -10.412  32.299  1.00 50.54           C  
ATOM   1243  CD  LYS B 197     -26.136 -11.000  31.041  1.00 50.41           C  
ATOM   1244  CE  LYS B 197     -27.130 -11.567  30.028  1.00 51.41           C  
ATOM   1245  NZ  LYS B 197     -26.422 -11.943  28.758  1.00 54.89           N  
ATOM   1246  N   ILE B 198     -25.956  -6.419  33.742  1.00 40.59           N  
ATOM   1247  CA  ILE B 198     -25.262  -5.171  33.743  1.00 42.12           C  
ATOM   1248  C   ILE B 198     -25.144  -4.653  35.175  1.00 44.49           C  
ATOM   1249  O   ILE B 198     -24.064  -4.216  35.615  1.00 43.75           O  
ATOM   1250  CB  ILE B 198     -26.010  -4.158  32.870  1.00 36.47           C  
ATOM   1251  CG1 ILE B 198     -26.010  -4.621  31.409  1.00 38.15           C  
ATOM   1252  CG2 ILE B 198     -25.369  -2.781  32.977  1.00 40.96           C  
ATOM   1253  CD1 ILE B 198     -26.869  -3.731  30.515  1.00 36.67           C  
ATOM   1254  N   LEU B 199     -26.264  -4.689  35.888  1.00 43.76           N  
ATOM   1255  CA  LEU B 199     -26.318  -4.241  37.264  1.00 41.42           C  
ATOM   1256  C   LEU B 199     -25.254  -4.986  38.052  1.00 43.86           C  
ATOM   1257  O   LEU B 199     -24.390  -4.354  38.687  1.00 40.55           O  
ATOM   1258  CB  LEU B 199     -27.703  -4.531  37.875  1.00 43.00           C  
ATOM   1259  CG  LEU B 199     -27.945  -3.917  39.250  1.00 39.80           C  
ATOM   1260  CD1 LEU B 199     -27.643  -2.404  39.251  1.00 41.43           C  
ATOM   1261  CD2 LEU B 199     -29.371  -4.174  39.689  1.00 42.42           C  
ATOM   1262  N   ASP B 200     -25.339  -6.324  38.005  1.00 42.27           N  
ATOM   1263  CA  ASP B 200     -24.378  -7.229  38.624  1.00 41.74           C  
ATOM   1264  C   ASP B 200     -22.906  -6.866  38.322  1.00 42.56           C  
ATOM   1265  O   ASP B 200     -22.040  -7.019  39.195  1.00 46.68           O  
ATOM   1266  CB  ASP B 200     -24.638  -8.678  38.172  1.00 44.13           C  
ATOM   1267  CG  ASP B 200     -25.877  -9.284  38.809  1.00 46.99           C  
ATOM   1268  OD1 ASP B 200     -26.500  -8.635  39.685  1.00 49.18           O  
ATOM   1269  OD2 ASP B 200     -26.225 -10.437  38.443  1.00 45.78           O  
ATOM   1270  N   HIS B 201     -22.622  -6.417  37.102  1.00 39.23           N  
ATOM   1271  CA  HIS B 201     -21.241  -6.221  36.699  1.00 35.20           C  
ATOM   1272  C   HIS B 201     -20.678  -4.848  36.806  1.00 41.68           C  
ATOM   1273  O   HIS B 201     -19.456  -4.680  37.034  1.00 43.00           O  
ATOM   1274  CB  HIS B 201     -21.013  -6.773  35.299  1.00 40.71           C  
ATOM   1275  CG  HIS B 201     -20.992  -8.265  35.256  1.00 35.72           C  
ATOM   1276  ND1 HIS B 201     -22.141  -9.020  35.124  1.00 34.24           N  
ATOM   1277  CD2 HIS B 201     -19.964  -9.139  35.299  1.00 40.95           C  
ATOM   1278  CE1 HIS B 201     -21.819 -10.303  35.105  1.00 39.14           C  
ATOM   1279  NE2 HIS B 201     -20.503 -10.403  35.208  1.00 39.77           N  
ATOM   1280  N   VAL B 202     -21.534  -3.851  36.665  1.00 32.22           N  
ATOM   1281  CA  VAL B 202     -21.058  -2.468  36.567  1.00 34.19           C  
ATOM   1282  C   VAL B 202     -20.916  -1.777  37.950  1.00 40.44           C  
ATOM   1283  O   VAL B 202     -20.130  -0.819  38.117  1.00 43.62           O  
ATOM   1284  CB  VAL B 202     -21.933  -1.704  35.564  1.00 37.76           C  
ATOM   1285  CG1 VAL B 202     -21.663  -0.177  35.566  1.00 41.74           C  
ATOM   1286  CG2 VAL B 202     -21.669  -2.239  34.199  1.00 35.80           C  
ATOM   1287  N   TRP B 203     -21.632  -2.301  38.942  1.00 40.75           N  
ATOM   1288  CA  TRP B 203     -21.562  -1.797  40.317  1.00 42.48           C  
ATOM   1289  C   TRP B 203     -21.312  -2.969  41.232  1.00 48.91           C  
ATOM   1290  O   TRP B 203     -21.581  -4.115  40.866  1.00 43.51           O  
ATOM   1291  CB  TRP B 203     -22.909  -1.209  40.703  1.00 49.26           C  
ATOM   1292  CG  TRP B 203     -23.313   0.037  39.966  1.00 45.53           C  
ATOM   1293  CD1 TRP B 203     -23.191   1.341  40.412  1.00 51.03           C  
ATOM   1294  CD2 TRP B 203     -23.955   0.114  38.685  1.00 47.33           C  
ATOM   1295  NE1 TRP B 203     -23.680   2.220  39.459  1.00 48.37           N  
ATOM   1296  CE2 TRP B 203     -24.159   1.496  38.397  1.00 47.13           C  
ATOM   1297  CE3 TRP B 203     -24.347  -0.843  37.729  1.00 43.59           C  
ATOM   1298  CZ2 TRP B 203     -24.758   1.930  37.213  1.00 44.37           C  
ATOM   1299  CZ3 TRP B 203     -24.920  -0.399  36.545  1.00 39.87           C  
ATOM   1300  CH2 TRP B 203     -25.129   0.972  36.303  1.00 43.58           C  
ATOM   1301  N   ARG B 204     -20.838  -2.690  42.446  1.00 51.52           N  
ATOM   1302  CA  ARG B 204     -20.703  -3.721  43.473  1.00 49.61           C  
ATOM   1303  C   ARG B 204     -22.090  -4.205  43.877  1.00 49.36           C  
ATOM   1304  O   ARG B 204     -23.055  -3.442  43.846  1.00 48.47           O  
ATOM   1305  CB  ARG B 204     -20.019  -3.158  44.716  1.00 52.69           C  
ATOM   1306  CG  ARG B 204     -18.768  -2.329  44.474  1.00 55.62           C  
ATOM   1307  CD  ARG B 204     -18.330  -1.624  45.750  1.00 59.47           C  
ATOM   1308  NE  ARG B 204     -19.419  -0.854  46.350  1.00 63.28           N  
ATOM   1309  CZ  ARG B 204     -20.080  -1.207  47.452  1.00 64.81           C  
ATOM   1310  NH1 ARG B 204     -19.763  -2.319  48.111  1.00 63.70           N  
ATOM   1311  NH2 ARG B 204     -21.058  -0.432  47.902  1.00 66.75           N  
ATOM   1312  N   TYR B 205     -22.199  -5.461  44.291  1.00 48.60           N  
ATOM   1313  CA  TYR B 205     -23.493  -5.957  44.728  1.00 48.02           C  
ATOM   1314  C   TYR B 205     -24.101  -5.064  45.819  1.00 51.64           C  
ATOM   1315  O   TYR B 205     -25.327  -4.924  45.903  1.00 53.03           O  
ATOM   1316  CB  TYR B 205     -23.399  -7.405  45.219  1.00 47.71           C  
ATOM   1317  CG  TYR B 205     -24.717  -7.926  45.757  1.00 45.92           C  
ATOM   1318  CD1 TYR B 205     -25.717  -8.368  44.892  1.00 46.54           C  
ATOM   1319  CD2 TYR B 205     -24.973  -7.940  47.127  1.00 47.58           C  
ATOM   1320  CE1 TYR B 205     -26.939  -8.840  45.383  1.00 47.21           C  
ATOM   1321  CE2 TYR B 205     -26.190  -8.402  47.628  1.00 47.23           C  
ATOM   1322  CZ  TYR B 205     -27.165  -8.848  46.751  1.00 46.98           C  
ATOM   1323  OH  TYR B 205     -28.365  -9.295  47.242  1.00 47.13           O  
ATOM   1324  N   ASP B 206     -23.239  -4.471  46.648  1.00 53.72           N  
ATOM   1325  CA  ASP B 206     -23.671  -3.669  47.814  1.00 54.30           C  
ATOM   1326  C   ASP B 206     -24.132  -2.240  47.410  1.00 54.77           C  
ATOM   1327  O   ASP B 206     -24.517  -1.429  48.260  1.00 51.66           O  
ATOM   1328  CB  ASP B 206     -22.556  -3.693  48.884  1.00 54.80           C  
ATOM   1329  CG  ASP B 206     -22.691  -2.598  49.943  1.00 57.45           C  
ATOM   1330  OD1 ASP B 206     -23.686  -2.581  50.702  1.00 57.55           O  
ATOM   1331  OD2 ASP B 206     -21.765  -1.761  50.034  1.00 60.33           O  
ATOM   1332  N   PHE B 207     -24.129  -1.959  46.105  1.00 56.77           N  
ATOM   1333  CA  PHE B 207     -24.729  -0.726  45.545  1.00 60.22           C  
ATOM   1334  C   PHE B 207     -26.277  -0.709  45.648  1.00 61.11           C  
ATOM   1335  O   PHE B 207     -26.874  -1.523  46.362  1.00 60.02           O  
ATOM   1336  CB  PHE B 207     -24.258  -0.536  44.095  1.00 62.25           C  
ATOM   1337  CG  PHE B 207     -24.773   0.715  43.430  1.00 65.69           C  
ATOM   1338  CD1 PHE B 207     -24.410   1.987  43.899  1.00 66.37           C  
ATOM   1339  CD2 PHE B 207     -25.617   0.627  42.313  1.00 66.69           C  
ATOM   1340  CE1 PHE B 207     -24.895   3.154  43.275  1.00 65.58           C  
ATOM   1341  CE2 PHE B 207     -26.099   1.795  41.680  1.00 66.57           C  
ATOM   1342  CZ  PHE B 207     -25.736   3.058  42.168  1.00 63.99           C  
ATOM   1343  N   GLY B 208     -26.916   0.235  44.955  1.00 61.80           N  
ATOM   1344  CA  GLY B 208     -28.379   0.249  44.800  1.00 60.22           C  
ATOM   1345  C   GLY B 208     -28.843  -0.587  43.616  1.00 56.92           C  
ATOM   1346  O   GLY B 208     -28.661  -0.200  42.433  1.00 53.40           O  
ATOM   1347  N   GLY B 209     -29.468  -1.717  43.957  1.00 55.06           N  
ATOM   1348  CA  GLY B 209     -29.788  -2.795  43.017  1.00 50.86           C  
ATOM   1349  C   GLY B 209     -31.136  -2.702  42.331  1.00 47.69           C  
ATOM   1350  O   GLY B 209     -32.051  -3.487  42.605  1.00 48.48           O  
ATOM   1351  N   ASP B 210     -31.217  -1.759  41.400  1.00 45.97           N  
ATOM   1352  CA  ASP B 210     -32.437  -1.400  40.716  1.00 45.99           C  
ATOM   1353  C   ASP B 210     -32.110  -1.343  39.233  1.00 43.03           C  
ATOM   1354  O   ASP B 210     -31.167  -0.671  38.849  1.00 40.19           O  
ATOM   1355  CB  ASP B 210     -32.844  -0.007  41.207  1.00 50.00           C  
ATOM   1356  CG  ASP B 210     -34.214   0.420  40.738  1.00 54.01           C  
ATOM   1357  OD1 ASP B 210     -34.901  -0.354  40.033  1.00 55.99           O  
ATOM   1358  OD2 ASP B 210     -34.609   1.550  41.103  1.00 54.81           O  
ATOM   1359  N   VAL B 211     -32.876  -2.044  38.401  1.00 40.42           N  
ATOM   1360  CA  VAL B 211     -32.699  -1.958  36.940  1.00 38.15           C  
ATOM   1361  C   VAL B 211     -33.046  -0.549  36.398  1.00 36.89           C  
ATOM   1362  O   VAL B 211     -32.671  -0.196  35.278  1.00 35.43           O  
ATOM   1363  CB  VAL B 211     -33.514  -3.041  36.188  1.00 40.25           C  
ATOM   1364  CG1 VAL B 211     -33.061  -4.461  36.591  1.00 39.53           C  
ATOM   1365  CG2 VAL B 211     -35.009  -2.860  36.423  1.00 35.99           C  
ATOM   1366  N   ASN B 212     -33.757   0.255  37.188  1.00 37.47           N  
ATOM   1367  CA  ASN B 212     -33.972   1.657  36.801  1.00 37.40           C  
ATOM   1368  C   ASN B 212     -32.682   2.513  36.755  1.00 37.40           C  
ATOM   1369  O   ASN B 212     -32.535   3.371  35.878  1.00 33.27           O  
ATOM   1370  CB  ASN B 212     -35.073   2.291  37.638  1.00 41.19           C  
ATOM   1371  CG  ASN B 212     -36.446   1.687  37.341  1.00 43.04           C  
ATOM   1372  OD1 ASN B 212     -37.039   1.022  38.183  1.00 44.69           O  
ATOM   1373  ND2 ASN B 212     -36.937   1.899  36.129  1.00 44.89           N  
ATOM   1374  N   VAL B 213     -31.738   2.268  37.666  1.00 35.31           N  
ATOM   1375  CA  VAL B 213     -30.417   2.946  37.572  1.00 36.10           C  
ATOM   1376  C   VAL B 213     -29.653   2.530  36.315  1.00 32.80           C  
ATOM   1377  O   VAL B 213     -28.941   3.316  35.676  1.00 31.42           O  
ATOM   1378  CB  VAL B 213     -29.517   2.698  38.819  1.00 40.95           C  
ATOM   1379  CG1 VAL B 213     -28.887   1.279  38.776  1.00 40.55           C  
ATOM   1380  CG2 VAL B 213     -28.402   3.763  38.912  1.00 38.29           C  
ATOM   1381  N   VAL B 214     -29.777   1.262  35.948  1.00 31.90           N  
ATOM   1382  CA  VAL B 214     -29.118   0.820  34.755  1.00 29.05           C  
ATOM   1383  C   VAL B 214     -29.634   1.571  33.536  1.00 29.65           C  
ATOM   1384  O   VAL B 214     -28.859   2.082  32.736  1.00 31.84           O  
ATOM   1385  CB  VAL B 214     -29.292  -0.701  34.543  1.00 31.81           C  
ATOM   1386  CG1 VAL B 214     -28.692  -1.099  33.225  1.00 29.49           C  
ATOM   1387  CG2 VAL B 214     -28.623  -1.449  35.681  1.00 29.96           C  
ATOM   1388  N   GLU B 215     -30.952   1.609  33.405  1.00 31.83           N  
ATOM   1389  CA  GLU B 215     -31.620   2.342  32.349  1.00 34.49           C  
ATOM   1390  C   GLU B 215     -31.164   3.803  32.287  1.00 32.60           C  
ATOM   1391  O   GLU B 215     -30.845   4.317  31.202  1.00 32.00           O  
ATOM   1392  CB  GLU B 215     -33.114   2.260  32.613  1.00 36.55           C  
ATOM   1393  CG  GLU B 215     -34.007   2.666  31.495  1.00 40.42           C  
ATOM   1394  CD  GLU B 215     -35.454   2.521  31.898  1.00 44.92           C  
ATOM   1395  OE1 GLU B 215     -36.175   3.543  31.826  1.00 45.30           O  
ATOM   1396  OE2 GLU B 215     -35.858   1.404  32.323  1.00 44.97           O  
ATOM   1397  N   SER B 216     -31.141   4.467  33.449  1.00 26.66           N  
ATOM   1398  CA  SER B 216     -30.603   5.835  33.505  1.00 29.68           C  
ATOM   1399  C   SER B 216     -29.191   5.909  32.963  1.00 31.70           C  
ATOM   1400  O   SER B 216     -28.866   6.760  32.118  1.00 33.42           O  
ATOM   1401  CB  SER B 216     -30.651   6.373  34.945  1.00 27.97           C  
ATOM   1402  OG  SER B 216     -31.980   6.616  35.334  1.00 32.35           O  
ATOM   1403  N   TYR B 217     -28.307   5.032  33.433  1.00 30.33           N  
ATOM   1404  CA  TYR B 217     -26.923   5.154  33.019  1.00 28.54           C  
ATOM   1405  C   TYR B 217     -26.718   4.808  31.559  1.00 32.16           C  
ATOM   1406  O   TYR B 217     -25.861   5.370  30.901  1.00 35.28           O  
ATOM   1407  CB  TYR B 217     -25.995   4.323  33.908  1.00 31.81           C  
ATOM   1408  CG  TYR B 217     -25.511   5.147  35.093  1.00 33.48           C  
ATOM   1409  CD1 TYR B 217     -24.421   6.020  34.934  1.00 36.96           C  
ATOM   1410  CD2 TYR B 217     -26.097   5.040  36.334  1.00 31.98           C  
ATOM   1411  CE1 TYR B 217     -23.964   6.800  36.014  1.00 35.67           C  
ATOM   1412  CE2 TYR B 217     -25.616   5.811  37.450  1.00 33.95           C  
ATOM   1413  CZ  TYR B 217     -24.522   6.677  37.234  1.00 34.42           C  
ATOM   1414  OH  TYR B 217     -24.020   7.410  38.295  1.00 39.01           O  
ATOM   1415  N   VAL B 218     -27.553   3.912  31.035  1.00 30.35           N  
ATOM   1416  CA  VAL B 218     -27.404   3.562  29.629  1.00 32.48           C  
ATOM   1417  C   VAL B 218     -27.808   4.795  28.808  1.00 33.57           C  
ATOM   1418  O   VAL B 218     -27.120   5.126  27.829  1.00 33.93           O  
ATOM   1419  CB  VAL B 218     -28.161   2.262  29.271  1.00 36.62           C  
ATOM   1420  CG1 VAL B 218     -28.224   2.081  27.767  1.00 40.09           C  
ATOM   1421  CG2 VAL B 218     -27.431   1.085  29.913  1.00 37.03           C  
ATOM   1422  N   SER B 219     -28.881   5.470  29.230  1.00 33.34           N  
ATOM   1423  CA  SER B 219     -29.306   6.772  28.672  1.00 31.97           C  
ATOM   1424  C   SER B 219     -28.145   7.800  28.697  1.00 32.84           C  
ATOM   1425  O   SER B 219     -27.824   8.394  27.682  1.00 33.77           O  
ATOM   1426  CB  SER B 219     -30.506   7.322  29.418  1.00 35.20           C  
ATOM   1427  OG  SER B 219     -31.573   6.386  29.340  1.00 40.48           O  
ATOM   1428  N   TYR B 220     -27.538   8.022  29.863  1.00 31.42           N  
ATOM   1429  CA  TYR B 220     -26.419   8.999  29.950  1.00 33.49           C  
ATOM   1430  C   TYR B 220     -25.276   8.660  29.002  1.00 34.35           C  
ATOM   1431  O   TYR B 220     -24.709   9.518  28.306  1.00 39.86           O  
ATOM   1432  CB  TYR B 220     -25.853   9.026  31.377  1.00 32.41           C  
ATOM   1433  CG  TYR B 220     -26.848   9.358  32.480  1.00 31.29           C  
ATOM   1434  CD1 TYR B 220     -27.973  10.168  32.257  1.00 27.41           C  
ATOM   1435  CD2 TYR B 220     -26.637   8.884  33.773  1.00 32.90           C  
ATOM   1436  CE1 TYR B 220     -28.870  10.455  33.289  1.00 33.20           C  
ATOM   1437  CE2 TYR B 220     -27.513   9.178  34.796  1.00 29.60           C  
ATOM   1438  CZ  TYR B 220     -28.629   9.954  34.566  1.00 31.64           C  
ATOM   1439  OH  TYR B 220     -29.500  10.259  35.584  1.00 35.16           O  
ATOM   1440  N   LEU B 221     -24.912   7.398  28.996  1.00 30.43           N  
ATOM   1441  CA  LEU B 221     -23.851   6.921  28.109  1.00 35.62           C  
ATOM   1442  C   LEU B 221     -24.174   7.128  26.633  1.00 36.35           C  
ATOM   1443  O   LEU B 221     -23.335   7.584  25.865  1.00 36.91           O  
ATOM   1444  CB  LEU B 221     -23.598   5.449  28.389  1.00 33.40           C  
ATOM   1445  CG  LEU B 221     -22.458   4.801  27.595  1.00 35.57           C  
ATOM   1446  CD1 LEU B 221     -21.127   5.556  27.794  1.00 36.59           C  
ATOM   1447  CD2 LEU B 221     -22.408   3.359  28.037  1.00 36.88           C  
ATOM   1448  N   ARG B 222     -25.384   6.765  26.227  1.00 37.04           N  
ATOM   1449  CA  ARG B 222     -25.759   6.871  24.820  1.00 36.07           C  
ATOM   1450  C   ARG B 222     -25.671   8.318  24.343  1.00 37.69           C  
ATOM   1451  O   ARG B 222     -25.259   8.599  23.205  1.00 40.04           O  
ATOM   1452  CB  ARG B 222     -27.194   6.414  24.643  1.00 38.90           C  
ATOM   1453  CG  ARG B 222     -27.384   4.950  24.483  1.00 42.28           C  
ATOM   1454  CD  ARG B 222     -28.862   4.644  24.419  1.00 42.07           C  
ATOM   1455  NE  ARG B 222     -29.114   3.411  23.691  1.00 39.93           N  
ATOM   1456  CZ  ARG B 222     -30.207   2.680  23.814  1.00 40.25           C  
ATOM   1457  NH1 ARG B 222     -31.189   3.058  24.630  1.00 41.23           N  
ATOM   1458  NH2 ARG B 222     -30.328   1.576  23.099  1.00 45.60           N  
ATOM   1459  N   ARG B 223     -26.072   9.234  25.214  1.00 33.77           N  
ATOM   1460  CA  ARG B 223     -26.123  10.661  24.865  1.00 38.12           C  
ATOM   1461  C   ARG B 223     -24.705  11.168  24.568  1.00 39.10           C  
ATOM   1462  O   ARG B 223     -24.507  12.042  23.714  1.00 43.58           O  
ATOM   1463  CB  ARG B 223     -26.735  11.470  26.000  1.00 33.31           C  
ATOM   1464  CG  ARG B 223     -28.247  11.314  26.159  1.00 47.22           C  
ATOM   1465  CD  ARG B 223     -28.700  12.087  27.409  1.00 51.94           C  
ATOM   1466  NE  ARG B 223     -30.056  11.760  27.761  1.00 59.04           N  
ATOM   1467  CZ  ARG B 223     -30.610  11.660  28.968  1.00 61.81           C  
ATOM   1468  NH1 ARG B 223     -29.954  11.817  30.113  1.00 62.81           N  
ATOM   1469  NH2 ARG B 223     -31.892  11.361  28.997  1.00 63.69           N  
ATOM   1470  N   LYS B 224     -23.740  10.580  25.246  1.00 37.63           N  
ATOM   1471  CA  LYS B 224     -22.365  10.993  25.152  1.00 39.44           C  
ATOM   1472  C   LYS B 224     -21.580  10.278  24.082  1.00 40.69           C  
ATOM   1473  O   LYS B 224     -20.719  10.887  23.473  1.00 41.31           O  
ATOM   1474  CB  LYS B 224     -21.684  10.758  26.471  1.00 41.51           C  
ATOM   1475  CG  LYS B 224     -22.072  11.815  27.491  1.00 45.97           C  
ATOM   1476  CD  LYS B 224     -21.204  11.604  28.675  1.00 41.91           C  
ATOM   1477  CE  LYS B 224     -21.301  12.754  29.685  1.00 42.38           C  
ATOM   1478  NZ  LYS B 224     -20.589  12.178  30.878  1.00 39.73           N  
ATOM   1479  N   ILE B 225     -21.880   8.995  23.848  1.00 39.20           N  
ATOM   1480  CA  ILE B 225     -21.010   8.171  23.005  1.00 41.83           C  
ATOM   1481  C   ILE B 225     -21.679   7.753  21.688  1.00 42.86           C  
ATOM   1482  O   ILE B 225     -21.004   7.303  20.770  1.00 39.21           O  
ATOM   1483  CB  ILE B 225     -20.510   6.901  23.747  1.00 44.83           C  
ATOM   1484  CG1 ILE B 225     -19.239   6.337  23.077  1.00 49.17           C  
ATOM   1485  CG2 ILE B 225     -21.584   5.771  23.776  1.00 46.32           C  
ATOM   1486  CD1 ILE B 225     -17.966   6.763  23.709  1.00 49.92           C  
ATOM   1487  N   ASP B 226     -22.998   7.863  21.620  1.00 38.24           N  
ATOM   1488  CA  ASP B 226     -23.771   7.204  20.523  1.00 43.95           C  
ATOM   1489  C   ASP B 226     -24.774   8.127  19.882  1.00 47.51           C  
ATOM   1490  O   ASP B 226     -25.979   7.835  19.813  1.00 50.69           O  
ATOM   1491  CB  ASP B 226     -24.470   5.944  21.053  1.00 42.60           C  
ATOM   1492  CG  ASP B 226     -24.705   4.914  19.972  1.00 41.59           C  
ATOM   1493  OD1 ASP B 226     -23.847   4.775  19.074  1.00 41.66           O  
ATOM   1494  OD2 ASP B 226     -25.760   4.239  20.027  1.00 41.25           O  
ATOM   1495  N   THR B 227     -24.247   9.238  19.379  1.00 50.27           N  
ATOM   1496  CA  THR B 227     -25.026  10.382  18.953  1.00 54.24           C  
ATOM   1497  C   THR B 227     -25.167  10.394  17.439  1.00 53.68           C  
ATOM   1498  O   THR B 227     -26.206  10.799  16.896  1.00 55.22           O  
ATOM   1499  CB  THR B 227     -24.352  11.687  19.476  1.00 55.56           C  
ATOM   1500  OG1 THR B 227     -24.812  11.946  20.808  1.00 59.72           O  
ATOM   1501  CG2 THR B 227     -24.675  12.891  18.602  1.00 61.52           C  
ATOM   1502  N   GLY B 228     -24.115   9.938  16.768  1.00 55.85           N  
ATOM   1503  CA  GLY B 228     -24.078   9.889  15.303  1.00 57.15           C  
ATOM   1504  C   GLY B 228     -25.115   9.044  14.564  1.00 53.86           C  
ATOM   1505  O   GLY B 228     -26.052   8.496  15.158  1.00 53.19           O  
ATOM   1506  N   GLU B 229     -24.922   8.947  13.250  1.00 52.34           N  
ATOM   1507  CA  GLU B 229     -25.914   8.408  12.322  1.00 49.81           C  
ATOM   1508  C   GLU B 229     -26.111   6.897  12.468  1.00 47.02           C  
ATOM   1509  O   GLU B 229     -27.252   6.418  12.492  1.00 41.09           O  
ATOM   1510  CB  GLU B 229     -25.538   8.788  10.877  1.00 53.58           C  
ATOM   1511  CG  GLU B 229     -24.061   8.547  10.511  1.00 57.09           C  
ATOM   1512  CD  GLU B 229     -23.393   9.748   9.839  1.00 59.06           C  
ATOM   1513  OE1 GLU B 229     -22.953   9.607   8.684  1.00 59.02           O  
ATOM   1514  OE2 GLU B 229     -23.295  10.830  10.469  1.00 61.37           O  
ATOM   1515  N   LYS B 230     -25.001   6.158  12.573  1.00 44.63           N  
ATOM   1516  CA  LYS B 230     -25.051   4.724  12.798  1.00 40.19           C  
ATOM   1517  C   LYS B 230     -24.968   4.576  14.289  1.00 37.22           C  
ATOM   1518  O   LYS B 230     -23.970   4.970  14.876  1.00 37.26           O  
ATOM   1519  CB  LYS B 230     -23.841   4.015  12.181  1.00 44.84           C  
ATOM   1520  CG  LYS B 230     -23.362   4.565  10.860  1.00 51.32           C  
ATOM   1521  CD  LYS B 230     -24.091   3.925   9.696  1.00 55.46           C  
ATOM   1522  CE  LYS B 230     -23.314   2.731   9.115  1.00 60.48           C  
ATOM   1523  NZ  LYS B 230     -23.199   1.563  10.049  1.00 59.16           N  
ATOM   1524  N   ARG B 231     -26.014   4.039  14.905  1.00 32.10           N  
ATOM   1525  CA  ARG B 231     -25.969   3.801  16.340  1.00 35.72           C  
ATOM   1526  C   ARG B 231     -25.303   2.485  16.587  1.00 31.64           C  
ATOM   1527  O   ARG B 231     -25.559   1.501  15.855  1.00 36.30           O  
ATOM   1528  CB  ARG B 231     -27.366   3.749  16.928  1.00 41.03           C  
ATOM   1529  CG  ARG B 231     -28.185   4.978  16.631  1.00 46.69           C  
ATOM   1530  CD  ARG B 231     -29.362   5.044  17.577  1.00 51.00           C  
ATOM   1531  NE  ARG B 231     -28.883   5.227  18.932  1.00 52.25           N  
ATOM   1532  CZ  ARG B 231     -28.975   4.309  19.883  1.00 54.40           C  
ATOM   1533  NH1 ARG B 231     -28.463   4.565  21.083  1.00 49.62           N  
ATOM   1534  NH2 ARG B 231     -29.588   3.149  19.634  1.00 53.03           N  
ATOM   1535  N   LEU B 232     -24.497   2.463  17.633  1.00 36.03           N  
ATOM   1536  CA  LEU B 232     -23.862   1.226  18.050  1.00 38.33           C  
ATOM   1537  C   LEU B 232     -24.527   0.578  19.260  1.00 38.69           C  
ATOM   1538  O   LEU B 232     -24.424  -0.636  19.451  1.00 38.94           O  
ATOM   1539  CB  LEU B 232     -22.379   1.463  18.292  1.00 36.02           C  
ATOM   1540  CG  LEU B 232     -21.543   2.006  17.115  1.00 35.23           C  
ATOM   1541  CD1 LEU B 232     -20.055   2.151  17.583  1.00 40.65           C  
ATOM   1542  CD2 LEU B 232     -21.674   1.137  15.890  1.00 40.81           C  
ATOM   1543  N   LEU B 233     -25.202   1.383  20.080  1.00 36.97           N  
ATOM   1544  CA  LEU B 233     -25.790   0.873  21.300  1.00 37.62           C  
ATOM   1545  C   LEU B 233     -27.282   0.731  21.119  1.00 42.54           C  
ATOM   1546  O   LEU B 233     -27.984   1.726  21.037  1.00 46.31           O  
ATOM   1547  CB  LEU B 233     -25.480   1.812  22.464  1.00 39.45           C  
ATOM   1548  CG  LEU B 233     -24.744   1.224  23.663  1.00 47.05           C  
ATOM   1549  CD1 LEU B 233     -24.754   2.296  24.765  1.00 49.00           C  
ATOM   1550  CD2 LEU B 233     -25.375  -0.089  24.168  1.00 48.82           C  
ATOM   1551  N   HIS B 234     -27.758  -0.508  21.047  1.00 41.39           N  
ATOM   1552  CA  HIS B 234     -29.164  -0.787  20.730  1.00 41.14           C  
ATOM   1553  C   HIS B 234     -29.949  -1.397  21.894  1.00 41.55           C  
ATOM   1554  O   HIS B 234     -29.388  -2.074  22.749  1.00 41.33           O  
ATOM   1555  CB  HIS B 234     -29.236  -1.725  19.515  1.00 41.26           C  
ATOM   1556  CG  HIS B 234     -28.472  -1.234  18.327  1.00 42.17           C  
ATOM   1557  ND1 HIS B 234     -29.063  -0.514  17.311  1.00 44.88           N  
ATOM   1558  CD2 HIS B 234     -27.168  -1.358  17.991  1.00 43.13           C  
ATOM   1559  CE1 HIS B 234     -28.155  -0.217  16.397  1.00 44.85           C  
ATOM   1560  NE2 HIS B 234     -26.999  -0.721  16.783  1.00 45.56           N  
ATOM   1561  N   THR B 235     -31.257  -1.148  21.911  1.00 46.08           N  
ATOM   1562  CA  THR B 235     -32.172  -1.769  22.875  1.00 48.07           C  
ATOM   1563  C   THR B 235     -32.950  -2.918  22.234  1.00 48.16           C  
ATOM   1564  O   THR B 235     -33.541  -2.760  21.174  1.00 46.15           O  
ATOM   1565  CB  THR B 235     -33.153  -0.735  23.478  1.00 49.48           C  
ATOM   1566  OG1 THR B 235     -32.410   0.358  24.025  1.00 50.19           O  
ATOM   1567  CG2 THR B 235     -34.005  -1.360  24.585  1.00 50.10           C  
ATOM   1568  N   LEU B 236     -32.904  -4.076  22.885  1.00 50.66           N  
ATOM   1569  CA  LEU B 236     -33.695  -5.239  22.515  1.00 54.14           C  
ATOM   1570  C   LEU B 236     -34.839  -5.355  23.510  1.00 54.28           C  
ATOM   1571  O   LEU B 236     -34.721  -6.025  24.541  1.00 51.51           O  
ATOM   1572  CB  LEU B 236     -32.835  -6.513  22.537  1.00 56.50           C  
ATOM   1573  CG  LEU B 236     -32.180  -7.094  21.276  1.00 57.20           C  
ATOM   1574  CD1 LEU B 236     -33.231  -7.673  20.329  1.00 58.43           C  
ATOM   1575  CD2 LEU B 236     -31.290  -6.082  20.567  1.00 57.43           C  
ATOM   1576  N   ARG B 237     -35.949  -4.694  23.187  1.00 56.07           N  
ATOM   1577  CA  ARG B 237     -37.066  -4.539  24.116  1.00 56.05           C  
ATOM   1578  C   ARG B 237     -37.430  -5.857  24.797  1.00 54.07           C  
ATOM   1579  O   ARG B 237     -37.640  -6.881  24.135  1.00 54.16           O  
ATOM   1580  CB  ARG B 237     -38.272  -3.931  23.401  1.00 57.59           C  
ATOM   1581  CG  ARG B 237     -38.873  -2.736  24.130  1.00 59.03           C  
ATOM   1582  CD  ARG B 237     -39.809  -1.950  23.219  1.00 58.96           C  
ATOM   1583  NE  ARG B 237     -41.104  -2.608  23.043  1.00 58.12           N  
ATOM   1584  CZ  ARG B 237     -42.230  -2.214  23.629  1.00 57.97           C  
ATOM   1585  NH1 ARG B 237     -43.360  -2.876  23.411  1.00 57.06           N  
ATOM   1586  NH2 ARG B 237     -42.231  -1.155  24.428  1.00 57.46           N  
ATOM   1587  N   GLY B 238     -37.461  -5.825  26.128  1.00 51.39           N  
ATOM   1588  CA  GLY B 238     -37.781  -7.002  26.931  1.00 48.81           C  
ATOM   1589  C   GLY B 238     -36.658  -8.014  27.074  1.00 46.12           C  
ATOM   1590  O   GLY B 238     -36.853  -9.082  27.666  1.00 45.53           O  
ATOM   1591  N   VAL B 239     -35.484  -7.690  26.529  1.00 43.39           N  
ATOM   1592  CA  VAL B 239     -34.330  -8.580  26.595  1.00 42.17           C  
ATOM   1593  C   VAL B 239     -33.122  -7.823  27.118  1.00 42.18           C  
ATOM   1594  O   VAL B 239     -32.386  -8.339  27.951  1.00 44.34           O  
ATOM   1595  CB  VAL B 239     -33.978  -9.184  25.223  1.00 43.81           C  
ATOM   1596  CG1 VAL B 239     -32.887 -10.240  25.367  1.00 47.32           C  
ATOM   1597  CG2 VAL B 239     -35.223  -9.817  24.567  1.00 43.89           C  
ATOM   1598  N   GLY B 240     -32.907  -6.613  26.619  1.00 39.70           N  
ATOM   1599  CA  GLY B 240     -31.795  -5.796  27.118  1.00 39.02           C  
ATOM   1600  C   GLY B 240     -31.152  -4.861  26.118  1.00 39.11           C  
ATOM   1601  O   GLY B 240     -31.839  -4.196  25.353  1.00 41.24           O  
ATOM   1602  N   TYR B 241     -29.826  -4.784  26.157  1.00 37.87           N  
ATOM   1603  CA  TYR B 241     -29.085  -3.869  25.298  1.00 39.57           C  
ATOM   1604  C   TYR B 241     -27.947  -4.600  24.597  1.00 39.77           C  
ATOM   1605  O   TYR B 241     -27.410  -5.575  25.118  1.00 44.04           O  
ATOM   1606  CB  TYR B 241     -28.466  -2.747  26.114  1.00 37.17           C  
ATOM   1607  CG  TYR B 241     -29.440  -1.929  26.927  1.00 35.56           C  
ATOM   1608  CD1 TYR B 241     -29.603  -2.160  28.286  1.00 35.79           C  
ATOM   1609  CD2 TYR B 241     -30.195  -0.926  26.334  1.00 36.58           C  
ATOM   1610  CE1 TYR B 241     -30.510  -1.412  29.036  1.00 36.62           C  
ATOM   1611  CE2 TYR B 241     -31.085  -0.158  27.063  1.00 36.98           C  
ATOM   1612  CZ  TYR B 241     -31.245  -0.396  28.418  1.00 40.75           C  
ATOM   1613  OH  TYR B 241     -32.156   0.366  29.143  1.00 40.85           O  
ATOM   1614  N   VAL B 242     -27.545  -4.103  23.439  1.00 38.23           N  
ATOM   1615  CA  VAL B 242     -26.354  -4.661  22.803  1.00 39.79           C  
ATOM   1616  C   VAL B 242     -25.527  -3.606  22.075  1.00 39.48           C  
ATOM   1617  O   VAL B 242     -26.085  -2.683  21.462  1.00 41.54           O  
ATOM   1618  CB  VAL B 242     -26.749  -5.814  21.847  1.00 40.16           C  
ATOM   1619  CG1 VAL B 242     -27.698  -5.301  20.794  1.00 40.74           C  
ATOM   1620  CG2 VAL B 242     -25.497  -6.484  21.234  1.00 40.14           C  
ATOM   1621  N   LEU B 243     -24.197  -3.734  22.177  1.00 36.02           N  
ATOM   1622  CA  LEU B 243     -23.276  -2.929  21.389  1.00 33.06           C  
ATOM   1623  C   LEU B 243     -22.912  -3.691  20.150  1.00 37.09           C  
ATOM   1624  O   LEU B 243     -22.291  -4.776  20.218  1.00 37.85           O  
ATOM   1625  CB  LEU B 243     -21.984  -2.645  22.171  1.00 33.63           C  
ATOM   1626  CG  LEU B 243     -20.995  -1.660  21.536  1.00 41.02           C  
ATOM   1627  CD1 LEU B 243     -21.520  -0.234  21.529  1.00 37.15           C  
ATOM   1628  CD2 LEU B 243     -19.681  -1.716  22.323  1.00 39.35           C  
ATOM   1629  N   ARG B 244     -23.339  -3.184  19.005  1.00 36.58           N  
ATOM   1630  CA  ARG B 244     -22.987  -3.834  17.747  1.00 40.68           C  
ATOM   1631  C   ARG B 244     -23.162  -2.868  16.610  1.00 44.28           C  
ATOM   1632  O   ARG B 244     -23.806  -1.839  16.776  1.00 48.85           O  
ATOM   1633  CB  ARG B 244     -23.867  -5.064  17.493  1.00 39.90           C  
ATOM   1634  CG  ARG B 244     -25.341  -4.789  17.483  1.00 39.88           C  
ATOM   1635  CD  ARG B 244     -26.077  -6.075  17.166  1.00 42.68           C  
ATOM   1636  NE  ARG B 244     -27.526  -5.976  17.339  1.00 46.27           N  
ATOM   1637  CZ  ARG B 244     -28.324  -7.029  17.521  1.00 46.20           C  
ATOM   1638  NH1 ARG B 244     -29.628  -6.857  17.676  1.00 45.89           N  
ATOM   1639  NH2 ARG B 244     -27.811  -8.253  17.583  1.00 44.62           N  
ATOM   1640  N   GLU B 245     -22.592  -3.210  15.460  1.00 49.34           N  
ATOM   1641  CA  GLU B 245     -22.900  -2.515  14.224  1.00 53.27           C  
ATOM   1642  C   GLU B 245     -24.366  -2.768  13.826  1.00 57.16           C  
ATOM   1643  O   GLU B 245     -24.923  -3.824  14.146  1.00 54.90           O  
ATOM   1644  CB  GLU B 245     -21.974  -2.984  13.113  1.00 55.76           C  
ATOM   1645  CG  GLU B 245     -20.558  -2.454  13.200  1.00 58.99           C  
ATOM   1646  CD  GLU B 245     -20.466  -0.929  13.142  1.00 60.84           C  
ATOM   1647  OE1 GLU B 245     -19.530  -0.379  13.766  1.00 63.90           O  
ATOM   1648  OE2 GLU B 245     -21.316  -0.278  12.488  1.00 61.27           O  
ATOM   1649  N   PRO B 246     -25.012  -1.779  13.171  1.00 59.87           N  
ATOM   1650  CA  PRO B 246     -26.358  -2.014  12.639  1.00 60.01           C  
ATOM   1651  C   PRO B 246     -26.319  -2.611  11.237  1.00 59.86           C  
ATOM   1652  O   PRO B 246     -25.574  -3.560  10.990  1.00 61.07           O  
ATOM   1653  CB  PRO B 246     -26.981  -0.614  12.608  1.00 61.10           C  
ATOM   1654  CG  PRO B 246     -25.832   0.365  12.717  1.00 60.62           C  
ATOM   1655  CD  PRO B 246     -24.553  -0.396  12.932  1.00 61.08           C  
TER    1656      PRO B 246                                                      
END
MOLECULE T0443_97_230.pdb
ATOM    557  N   SER    97       9.444  13.904  25.999  1.00 32.65           N  
ATOM    558  CA  SER    97       9.019  13.771  27.400  1.00 32.55           C  
ATOM    559  C   SER    97       7.759  12.923  27.498  1.00 32.70           C  
ATOM    560  O   SER    97       7.026  12.769  26.517  1.00 33.71           O  
ATOM    561  CB  SER    97       8.716  15.139  27.997  1.00 32.59           C  
ATOM    562  OG  SER    97       7.547  15.663  27.400  1.00 31.84           O  
ATOM    563  N   ASP    98       7.467  12.409  28.690  1.00 33.19           N  
ATOM    564  CA  ASP    98       6.275  11.582  28.879  1.00 33.23           C  
ATOM    565  C   ASP    98       4.966  12.366  28.697  1.00 32.35           C  
ATOM    566  O   ASP    98       3.961  11.797  28.233  1.00 31.66           O  
ATOM    567  CB  ASP    98       6.314  10.868  30.227  1.00 34.81           C  
ATOM    568  CG  ASP    98       7.346   9.752  30.271  1.00 35.79           C  
ATOM    569  OD1 ASP    98       7.927   9.397  29.218  1.00 36.03           O  
ATOM    570  OD2 ASP    98       7.566   9.216  31.376  1.00 38.06           O  
ATOM    571  N   GLY    99       4.990  13.651  29.055  1.00 30.82           N  
ATOM    572  CA  GLY    99       3.842  14.548  28.894  1.00 30.89           C  
ATOM    573  C   GLY    99       3.507  14.851  27.439  1.00 31.23           C  
ATOM    574  O   GLY    99       2.338  14.867  27.051  1.00 32.26           O  
ATOM    575  N   ILE   100       4.532  15.128  26.633  1.00 31.16           N  
ATOM    576  CA  ILE   100       4.345  15.348  25.206  1.00 29.39           C  
ATOM    577  C   ILE   100       3.859  14.036  24.541  1.00 29.36           C  
ATOM    578  O   ILE   100       2.931  14.074  23.743  1.00 30.42           O  
ATOM    579  CB  ILE   100       5.637  15.902  24.562  1.00 30.48           C  
ATOM    580  CG1 ILE   100       5.934  17.321  25.075  1.00 31.37           C  
ATOM    581  CG2 ILE   100       5.542  15.941  23.038  1.00 30.03           C  
ATOM    582  CD1 ILE   100       4.947  18.391  24.593  1.00 31.63           C  
ATOM    583  N   LEU   101       4.433  12.889  24.915  1.00 27.54           N  
ATOM    584  CA  LEU   101       4.056  11.584  24.340  1.00 27.41           C  
ATOM    585  C   LEU   101       2.603  11.212  24.618  1.00 27.36           C  
ATOM    586  O   LEU   101       1.952  10.611  23.761  1.00 26.82           O  
ATOM    587  CB  LEU   101       4.997  10.452  24.813  1.00 27.14           C  
ATOM    588  CG  LEU   101       6.374  10.483  24.155  1.00 27.77           C  
ATOM    589  CD1 LEU   101       7.364   9.480  24.749  1.00 28.09           C  
ATOM    590  CD2 LEU   101       6.204  10.283  22.646  1.00 27.85           C  
ATOM    591  N   ALA   102       2.113  11.536  25.809  1.00 26.46           N  
ATOM    592  CA  ALA   102       0.725  11.313  26.148  1.00 27.20           C  
ATOM    593  C   ALA   102      -0.163  12.246  25.304  1.00 27.49           C  
ATOM    594  O   ALA   102      -1.179  11.829  24.744  1.00 28.34           O  
ATOM    595  CB  ALA   102       0.495  11.534  27.664  1.00 26.33           C  
ATOM    596  N   LEU   103       0.242  13.502  25.194  1.00 28.56           N  
ATOM    597  CA  LEU   103      -0.483  14.476  24.398  1.00 28.57           C  
ATOM    598  C   LEU   103      -0.498  14.094  22.928  1.00 30.29           C  
ATOM    599  O   LEU   103      -1.466  14.368  22.211  1.00 31.20           O  
ATOM    600  CB  LEU   103       0.150  15.852  24.550  1.00 27.97           C  
ATOM    601  CG  LEU   103      -0.540  16.927  23.734  1.00 27.93           C  
ATOM    602  CD1 LEU   103      -2.056  16.931  24.028  1.00 28.16           C  
ATOM    603  CD2 LEU   103       0.114  18.260  24.005  1.00 27.38           C  
ATOM    604  N   MET   104       0.578  13.477  22.459  1.00 30.91           N  
ATOM    605  CA  MET   104       0.587  13.021  21.088  1.00 31.03           C  
ATOM    606  C   MET   104      -0.356  11.843  20.907  1.00 31.30           C  
ATOM    607  O   MET   104      -1.078  11.768  19.908  1.00 31.91           O  
ATOM    608  CB  MET   104       2.011  12.700  20.593  1.00 29.78           C  
ATOM    609  CG  MET   104       2.852  13.953  20.409  1.00 29.50           C  
ATOM    610  SD  MET   104       4.547  13.560  19.600  0.75 28.40          SE  
ATOM    611  CE  MET   104       4.041  13.148  17.802  1.00 27.34           C  
ATOM    612  N   ASP   105      -0.376  10.926  21.857  1.00 31.23           N  
ATOM    613  CA  ASP   105      -1.286   9.791  21.726  1.00 32.67           C  
ATOM    614  C   ASP   105      -2.788  10.253  21.729  1.00 32.95           C  
ATOM    615  O   ASP   105      -3.590   9.801  20.916  1.00 32.42           O  
ATOM    616  CB  ASP   105      -0.974   8.721  22.766  1.00 32.38           C  
ATOM    617  CG  ASP   105      -1.939   7.573  22.686  1.00 33.91           C  
ATOM    618  OD1 ASP   105      -3.040   7.652  23.253  1.00 33.56           O  
ATOM    619  OD2 ASP   105      -1.555   6.530  22.122  1.00 35.97           O  
ATOM    620  N   PHE   106      -3.129  11.160  22.630  1.00 33.56           N  
ATOM    621  CA  PHE   106      -4.457  11.802  22.702  1.00 35.01           C  
ATOM    622  C   PHE   106      -4.878  12.370  21.332  1.00 36.24           C  
ATOM    623  O   PHE   106      -5.978  12.083  20.818  1.00 36.06           O  
ATOM    624  CB  PHE   106      -4.385  12.903  23.770  1.00 35.80           C  
ATOM    625  CG  PHE   106      -5.655  13.703  23.965  1.00 36.05           C  
ATOM    626  CD1 PHE   106      -6.880  13.073  24.216  1.00 35.54           C  
ATOM    627  CD2 PHE   106      -5.600  15.108  23.982  1.00 36.94           C  
ATOM    628  CE1 PHE   106      -8.029  13.817  24.425  1.00 36.07           C  
ATOM    629  CE2 PHE   106      -6.743  15.860  24.198  1.00 36.31           C  
ATOM    630  CZ  PHE   106      -7.966  15.215  24.432  1.00 36.38           C  
ATOM    631  N   GLU   107      -3.976  13.149  20.733  1.00 37.10           N  
ATOM    632  CA  GLU   107      -4.199  13.781  19.423  1.00 35.80           C  
ATOM    633  C   GLU   107      -4.382  12.751  18.330  1.00 35.02           C  
ATOM    634  O   GLU   107      -5.280  12.864  17.512  1.00 33.91           O  
ATOM    635  CB  GLU   107      -3.049  14.734  19.088  1.00 36.77           C  
ATOM    636  CG  GLU   107      -3.160  16.067  19.838  1.00 35.57           C  
ATOM    637  CD  GLU   107      -2.247  17.140  19.300  1.00 36.65           C  
ATOM    638  OE1 GLU   107      -1.006  16.977  19.321  1.00 37.42           O  
ATOM    639  OE2 GLU   107      -2.761  18.199  18.885  1.00 37.20           O  
ATOM    640  N   TYR   108      -3.534  11.735  18.321  1.00 34.20           N  
ATOM    641  CA  TYR   108      -3.688  10.676  17.353  1.00 35.65           C  
ATOM    642  C   TYR   108      -5.048   9.963  17.523  1.00 34.35           C  
ATOM    643  O   TYR   108      -5.718   9.617  16.551  1.00 34.92           O  
ATOM    644  CB  TYR   108      -2.523   9.682  17.454  1.00 35.28           C  
ATOM    645  CG  TYR   108      -2.558   8.616  16.409  1.00 35.58           C  
ATOM    646  CD1 TYR   108      -2.544   8.953  15.053  1.00 35.63           C  
ATOM    647  CD2 TYR   108      -2.590   7.270  16.761  1.00 34.32           C  
ATOM    648  CE1 TYR   108      -2.584   7.978  14.075  1.00 35.54           C  
ATOM    649  CE2 TYR   108      -2.619   6.298  15.802  1.00 35.87           C  
ATOM    650  CZ  TYR   108      -2.616   6.649  14.449  1.00 35.77           C  
ATOM    651  OH  TYR   108      -2.658   5.681  13.471  1.00 35.26           O  
ATOM    652  N   THR   109      -5.448   9.746  18.769  1.00 35.03           N  
ATOM    653  CA  THR   109      -6.698   9.064  19.076  1.00 33.68           C  
ATOM    654  C   THR   109      -7.861   9.886  18.507  1.00 31.85           C  
ATOM    655  O   THR   109      -8.816   9.315  18.010  1.00 32.82           O  
ATOM    656  CB  THR   109      -6.808   8.731  20.607  1.00 35.01           C  
ATOM    657  OG1 THR   109      -5.735   7.858  20.969  1.00 34.59           O  
ATOM    658  CG2 THR   109      -8.135   8.031  20.970  1.00 33.15           C  
ATOM    659  N   GLN   110      -7.801  11.217  18.549  1.00 30.28           N  
ATOM    660  CA  GLN   110      -8.859  12.002  17.968  1.00 30.39           C  
ATOM    661  C   GLN   110      -8.990  11.707  16.478  1.00 31.29           C  
ATOM    662  O   GLN   110     -10.103  11.494  15.963  1.00 30.97           O  
ATOM    663  CB  GLN   110      -8.678  13.509  18.239  1.00 31.63           C  
ATOM    664  CG  GLN   110      -8.869  13.893  19.712  1.00 31.90           C  
ATOM    665  CD  GLN   110      -8.517  15.343  19.995  1.00 33.22           C  
ATOM    666  OE1 GLN   110      -7.835  15.657  20.974  1.00 34.63           O  
ATOM    667  NE2 GLN   110      -8.977  16.233  19.134  1.00 35.22           N  
ATOM    668  N   LEU   111      -7.858  11.648  15.775  1.00 30.57           N  
ATOM    669  CA  LEU   111      -7.878  11.335  14.362  1.00 30.61           C  
ATOM    670  C   LEU   111      -8.434   9.911  14.164  1.00 31.02           C  
ATOM    671  O   LEU   111      -9.228   9.651  13.260  1.00 30.94           O  
ATOM    672  CB  LEU   111      -6.471  11.490  13.758  1.00 30.95           C  
ATOM    673  CG  LEU   111      -6.293  11.231  12.256  1.00 31.08           C  
ATOM    674  CD1 LEU   111      -7.111  12.147  11.455  1.00 30.25           C  
ATOM    675  CD2 LEU   111      -4.806  11.369  11.903  1.00 31.37           C  
ATOM    676  N   LEU   112      -8.077   8.985  15.037  1.00 31.17           N  
ATOM    677  CA  LEU   112      -8.657   7.657  14.911  1.00 31.52           C  
ATOM    678  C   LEU   112     -10.191   7.645  15.018  1.00 34.16           C  
ATOM    679  O   LEU   112     -10.858   6.803  14.374  1.00 33.67           O  
ATOM    680  CB  LEU   112      -8.070   6.724  15.939  1.00 30.68           C  
ATOM    681  CG  LEU   112      -6.630   6.333  15.739  1.00 28.89           C  
ATOM    682  CD1 LEU   112      -6.242   5.410  16.888  1.00 28.54           C  
ATOM    683  CD2 LEU   112      -6.406   5.663  14.382  1.00 28.98           C  
ATOM    684  N   ALA   113     -10.747   8.598  15.784  1.00 34.42           N  
ATOM    685  CA  ALA   113     -12.190   8.674  15.988  1.00 34.82           C  
ATOM    686  C   ALA   113     -12.821   9.386  14.806  1.00 36.77           C  
ATOM    687  O   ALA   113     -13.933   9.038  14.385  1.00 34.40           O  
ATOM    688  CB  ALA   113     -12.513   9.386  17.282  1.00 33.82           C  
ATOM    689  N   GLU   114     -12.105  10.396  14.285  1.00 38.02           N  
ATOM    690  CA  GLU   114     -12.525  11.148  13.083  1.00 38.27           C  
ATOM    691  C   GLU   114     -12.688  10.230  11.866  1.00 37.71           C  
ATOM    692  O   GLU   114     -13.631  10.376  11.072  1.00 35.85           O  
ATOM    693  CB  GLU   114     -11.479  12.231  12.748  1.00 38.46           C  
ATOM    694  CG  GLU   114     -11.625  12.955  11.411  1.00 38.44           C  
ATOM    695  CD  GLU   114     -12.912  13.774  11.263  1.00 39.18           C  
ATOM    696  OE1 GLU   114     -13.863  13.564  12.052  1.00 39.13           O  
ATOM    697  OE2 GLU   114     -12.969  14.629  10.339  1.00 38.38           O  
ATOM    698  N   VAL   115     -11.786   9.260  11.783  1.00 36.86           N  
ATOM    699  CA  VAL   115     -11.649   8.407  10.616  1.00 37.42           C  
ATOM    700  C   VAL   115     -12.283   7.031  10.766  1.00 37.20           C  
ATOM    701  O   VAL   115     -12.437   6.316   9.783  1.00 36.94           O  
ATOM    702  CB  VAL   115     -10.088   8.346  10.255  1.00 37.61           C  
ATOM    703  CG1 VAL   115      -9.631   7.000   9.754  1.00 37.26           C  
ATOM    704  CG2 VAL   115      -9.717   9.491   9.349  1.00 35.81           C  
ATOM    705  N   ALA   116     -12.693   6.662  11.972  1.00 37.42           N  
ATOM    706  CA  ALA   116     -13.258   5.331  12.187  1.00 37.49           C  
ATOM    707  C   ALA   116     -14.540   5.101  11.376  1.00 37.88           C  
ATOM    708  O   ALA   116     -15.338   6.015  11.165  1.00 37.84           O  
ATOM    709  CB  ALA   116     -13.500   5.083  13.680  1.00 38.00           C  
ATOM    710  N   GLN   117     -14.690   3.876  10.881  1.00 39.14           N  
ATOM    711  CA  GLN   117     -15.857   3.473  10.117  1.00 39.51           C  
ATOM    712  C   GLN   117     -16.844   2.904  11.096  1.00 39.20           C  
ATOM    713  O   GLN   117     -16.541   1.915  11.775  1.00 39.62           O  
ATOM    714  CB  GLN   117     -15.520   2.391   9.087  1.00 40.02           C  
ATOM    715  CG  GLN   117     -16.761   1.831   8.351  1.00 40.38           C  
ATOM    716  N   ILE   118     -18.023   3.517  11.148  1.00 38.74           N  
ATOM    717  CA  ILE   118     -19.100   3.113  12.047  1.00 37.74           C  
ATOM    718  C   ILE   118     -20.190   2.493  11.173  1.00 37.96           C  
ATOM    719  O   ILE   118     -20.690   3.184  10.284  1.00 37.83           O  
ATOM    720  CB  ILE   118     -19.650   4.354  12.786  1.00 36.97           C  
ATOM    721  CG1 ILE   118     -18.576   4.967  13.676  1.00 36.79           C  
ATOM    722  CG2 ILE   118     -20.836   3.996  13.663  1.00 37.44           C  
ATOM    723  CD1 ILE   118     -18.946   6.361  14.158  1.00 36.94           C  
ATOM    724  N   PRO   119     -20.504   1.180  11.345  1.00 37.96           N  
ATOM    725  CA  PRO   119     -21.559   0.572  10.535  1.00 37.61           C  
ATOM    726  C   PRO   119     -22.869   1.352  10.481  1.00 37.30           C  
ATOM    727  O   PRO   119     -23.244   2.008  11.459  1.00 37.04           O  
ATOM    728  CB  PRO   119     -21.800  -0.801  11.196  1.00 38.22           C  
ATOM    729  CG  PRO   119     -20.857  -0.881  12.383  1.00 38.45           C  
ATOM    730  CD  PRO   119     -19.820   0.169  12.178  1.00 38.93           C  
ATOM    731  N   ASP   120     -23.525   1.290   9.321  1.00 36.76           N  
ATOM    732  CA  ASP   120     -24.832   1.907   9.121  1.00 36.79           C  
ATOM    733  C   ASP   120     -25.816   1.213  10.070  1.00 36.53           C  
ATOM    734  O   ASP   120     -25.821  -0.020  10.190  1.00 36.76           O  
ATOM    735  CB  ASP   120     -25.290   1.781   7.665  1.00 35.70           C  
ATOM    736  N   ILE   121     -26.612   2.007  10.777  1.00 36.81           N  
ATOM    737  CA  ILE   121     -27.601   1.463  11.728  1.00 36.43           C  
ATOM    738  C   ILE   121     -29.007   1.772  11.216  1.00 36.10           C  
ATOM    739  O   ILE   121     -29.369   2.955  11.079  1.00 36.53           O  
ATOM    740  CB  ILE   121     -27.441   2.053  13.157  1.00 36.35           C  
ATOM    741  CG1 ILE   121     -26.346   1.342  13.987  1.00 36.03           C  
ATOM    742  CG2 ILE   121     -28.747   1.798  13.971  1.00 36.54           C  
ATOM    743  CD1 ILE   121     -25.097   1.027  13.356  1.00 35.96           C  
ATOM    744  N   PRO   122     -29.788   0.728  10.870  1.00 35.15           N  
ATOM    745  CA  PRO   122     -31.171   1.018  10.479  1.00 34.84           C  
ATOM    746  C   PRO   122     -31.915   1.759  11.588  1.00 34.29           C  
ATOM    747  O   PRO   122     -31.737   1.480  12.791  1.00 32.53           O  
ATOM    748  CB  PRO   122     -31.781  -0.367  10.236  1.00 35.03           C  
ATOM    749  CG  PRO   122     -30.621  -1.233   9.907  1.00 35.38           C  
ATOM    750  CD  PRO   122     -29.488  -0.711  10.766  1.00 35.15           C  
ATOM    751  N   ASP   123     -32.722   2.719  11.165  1.00 34.56           N  
ATOM    752  CA  ASP   123     -33.461   3.540  12.081  1.00 34.50           C  
ATOM    753  C   ASP   123     -34.829   2.908  12.365  1.00 33.08           C  
ATOM    754  O   ASP   123     -35.856   3.309  11.826  1.00 32.07           O  
ATOM    755  CB  ASP   123     -33.559   4.950  11.511  1.00 35.67           C  
ATOM    756  CG  ASP   123     -33.888   5.972  12.555  1.00 36.62           C  
ATOM    757  OD1 ASP   123     -33.929   5.622  13.755  1.00 37.75           O  
ATOM    758  OD2 ASP   123     -34.108   7.133  12.166  1.00 38.52           O  
ATOM    759  N   ILE   124     -34.798   1.901  13.241  1.00 32.79           N  
ATOM    760  CA  ILE   124     -35.975   1.159  13.684  1.00 31.54           C  
ATOM    761  C   ILE   124     -36.037   1.214  15.210  1.00 31.99           C  
ATOM    762  O   ILE   124     -35.290   1.969  15.851  1.00 31.86           O  
ATOM    763  CB  ILE   124     -35.939  -0.318  13.192  1.00 30.72           C  
ATOM    764  CG1 ILE   124     -34.792  -1.106  13.840  1.00 30.34           C  
ATOM    765  CG2 ILE   124     -35.842  -0.352  11.657  1.00 30.34           C  
ATOM    766  CD1 ILE   124     -34.778  -2.601  13.479  1.00 30.60           C  
ATOM    767  N   HIS   125     -36.940   0.427  15.795  1.00 31.68           N  
ATOM    768  CA  HIS   125     -37.063   0.371  17.238  1.00 30.63           C  
ATOM    769  C   HIS   125     -36.133  -0.690  17.806  1.00 31.38           C  
ATOM    770  O   HIS   125     -36.158  -1.848  17.378  1.00 31.11           O  
ATOM    771  CB  HIS   125     -38.491   0.061  17.652  1.00 30.09           C  
ATOM    772  CG  HIS   125     -38.703   0.103  19.128  1.00 29.67           C  
ATOM    773  ND1 HIS   125     -39.161   1.227  19.774  1.00 29.17           N  
ATOM    774  CD2 HIS   125     -38.504  -0.835  20.088  1.00 29.71           C  
ATOM    775  CE1 HIS   125     -39.249   0.976  21.071  1.00 30.24           C  
ATOM    776  NE2 HIS   125     -38.846  -0.265  21.288  1.00 29.36           N  
ATOM    777  N   TYR   126     -35.284  -0.281  18.752  1.00 32.16           N  
ATOM    778  CA  TYR   126     -34.413  -1.222  19.455  1.00 32.02           C  
ATOM    779  C   TYR   126     -34.825  -1.190  20.918  1.00 30.88           C  
ATOM    780  O   TYR   126     -34.697  -0.178  21.569  1.00 30.80           O  
ATOM    781  CB  TYR   126     -32.932  -0.859  19.288  1.00 31.79           C  
ATOM    782  CG  TYR   126     -32.460  -0.901  17.833  1.00 31.58           C  
ATOM    783  CD1 TYR   126     -32.175  -2.120  17.209  1.00 31.68           C  
ATOM    784  CD2 TYR   126     -32.302   0.271  17.090  1.00 31.54           C  
ATOM    785  CE1 TYR   126     -31.745  -2.176  15.868  1.00 31.67           C  
ATOM    786  CE2 TYR   126     -31.876   0.230  15.763  1.00 31.47           C  
ATOM    787  CZ  TYR   126     -31.592  -1.006  15.157  1.00 31.98           C  
ATOM    788  OH  TYR   126     -31.172  -1.075  13.832  1.00 32.02           O  
ATOM    789  N   SER   127     -35.346  -2.299  21.429  1.00 30.50           N  
ATOM    790  CA  SER   127     -35.776  -2.363  22.835  1.00 28.63           C  
ATOM    791  C   SER   127     -34.573  -2.540  23.798  1.00 28.44           C  
ATOM    792  O   SER   127     -33.393  -2.582  23.369  1.00 27.83           O  
ATOM    793  CB  SER   127     -36.712  -3.532  23.010  1.00 27.86           C  
ATOM    794  OG  SER   127     -35.992  -4.736  22.923  1.00 26.15           O  
ATOM    795  N   ASN   128     -34.881  -2.633  25.088  1.00 27.65           N  
ATOM    796  CA  ASN   128     -33.875  -2.896  26.115  1.00 27.69           C  
ATOM    797  C   ASN   128     -33.578  -4.373  26.171  1.00 27.51           C  
ATOM    798  O   ASN   128     -32.877  -4.812  27.051  1.00 26.32           O  
ATOM    799  CB  ASN   128     -34.288  -2.387  27.484  1.00 27.86           C  
ATOM    800  CG  ASN   128     -34.374  -0.865  27.550  1.00 29.20           C  
ATOM    801  OD1 ASN   128     -33.713  -0.173  26.812  1.00 30.68           O  
ATOM    802  ND2 ASN   128     -35.174  -0.362  28.454  1.00 30.11           N  
ATOM    803  N   ASP   129     -34.124  -5.130  25.235  1.00 29.56           N  
ATOM    804  CA  ASP   129     -33.754  -6.527  25.072  1.00 32.20           C  
ATOM    805  C   ASP   129     -32.702  -6.608  23.947  1.00 32.50           C  
ATOM    806  O   ASP   129     -32.026  -7.621  23.812  1.00 31.46           O  
ATOM    807  CB  ASP   129     -34.944  -7.367  24.692  1.00 32.76           C  
ATOM    808  CG  ASP   129     -34.645  -8.857  24.803  1.00 33.97           C  
ATOM    809  OD1 ASP   129     -34.244  -9.281  25.911  1.00 35.60           O  
ATOM    810  OD2 ASP   129     -34.794  -9.594  23.799  1.00 33.96           O  
ATOM    811  N   SER   130     -32.564  -5.529  23.158  1.00 33.49           N  
ATOM    812  CA  SER   130     -31.562  -5.471  22.058  1.00 34.51           C  
ATOM    813  C   SER   130     -30.140  -5.183  22.523  1.00 33.88           C  
ATOM    814  O   SER   130     -29.894  -4.208  23.252  1.00 34.32           O  
ATOM    815  CB  SER   130     -31.914  -4.418  20.997  1.00 35.21           C  
ATOM    816  OG  SER   130     -32.926  -4.883  20.134  1.00 37.41           O  
ATOM    817  N   LYS   131     -29.203  -5.992  22.028  1.00 32.98           N  
ATOM    818  CA  LYS   131     -27.788  -5.831  22.372  1.00 33.25           C  
ATOM    819  C   LYS   131     -27.079  -4.623  21.752  1.00 34.21           C  
ATOM    820  O   LYS   131     -27.345  -4.219  20.600  1.00 35.24           O  
ATOM    821  CB  LYS   131     -26.998  -7.079  21.997  1.00 32.43           C  
ATOM    822  CG  LYS   131     -27.365  -8.340  22.731  1.00 30.56           C  
ATOM    823  CD  LYS   131     -26.298  -9.360  22.420  1.00 30.14           C  
ATOM    824  CE  LYS   131     -26.583 -10.694  23.034  1.00 29.35           C  
ATOM    825  NZ  LYS   131     -25.600 -11.650  22.472  1.00 28.55           N  
ATOM    826  N   TYR   132     -26.167  -4.059  22.541  1.00 34.56           N  
ATOM    827  CA  TYR   132     -25.337  -2.923  22.138  1.00 34.57           C  
ATOM    828  C   TYR   132     -23.860  -3.303  22.258  1.00 34.03           C  
ATOM    829  O   TYR   132     -23.496  -4.298  22.895  1.00 34.91           O  
ATOM    830  CB  TYR   132     -25.671  -1.656  22.924  1.00 34.95           C  
ATOM    831  CG  TYR   132     -26.909  -0.970  22.392  1.00 35.34           C  
ATOM    832  CD1 TYR   132     -28.161  -1.550  22.548  1.00 34.93           C  
ATOM    833  CD2 TYR   132     -26.833   0.271  21.743  1.00 34.71           C  
ATOM    834  CE1 TYR   132     -29.296  -0.961  22.038  1.00 34.57           C  
ATOM    835  CE2 TYR   132     -27.960   0.871  21.238  1.00 35.07           C  
ATOM    836  CZ  TYR   132     -29.195   0.240  21.397  1.00 35.45           C  
ATOM    837  OH  TYR   132     -30.333   0.810  20.913  1.00 35.94           O  
ATOM    838  N   THR   133     -23.056  -2.574  21.513  1.00 33.01           N  
ATOM    839  CA  THR   133     -21.608  -2.737  21.451  1.00 33.04           C  
ATOM    840  C   THR   133     -21.076  -1.286  21.444  1.00 32.43           C  
ATOM    841  O   THR   133     -21.792  -0.373  21.008  1.00 31.13           O  
ATOM    842  CB  THR   133     -21.239  -3.499  20.159  1.00 33.45           C  
ATOM    843  OG1 THR   133     -19.837  -3.816  20.132  1.00 34.34           O  
ATOM    844  CG2 THR   133     -21.665  -2.709  18.889  1.00 32.15           C  
ATOM    845  N   PRO   134     -19.856  -1.044  21.947  1.00 33.28           N  
ATOM    846  CA  PRO   134     -19.356   0.372  21.853  1.00 32.73           C  
ATOM    847  C   PRO   134     -19.064   0.749  20.393  1.00 31.84           C  
ATOM    848  O   PRO   134     -18.792  -0.114  19.609  1.00 31.68           O  
ATOM    849  CB  PRO   134     -18.052   0.372  22.660  1.00 33.47           C  
ATOM    850  CG  PRO   134     -17.881  -1.021  23.202  1.00 34.04           C  
ATOM    851  CD  PRO   134     -18.877  -1.956  22.542  1.00 33.56           C  
ATOM    852  N   SER   135     -19.118   2.029  20.027  1.00 33.13           N  
ATOM    853  CA  SER   135     -18.845   2.424  18.654  0.50 31.70           C  
ATOM    855  C   SER   135     -17.407   2.086  18.288  1.00 32.82           C  
ATOM    856  O   SER   135     -16.504   2.197  19.131  1.00 34.51           O  
ATOM    857  CB  SER   135     -19.048   3.926  18.440  0.50 30.68           C  
ATOM    859  OG  SER   135     -18.698   4.292  17.117  0.50 27.27           O  
ATOM    861  N   PRO   136     -17.181   1.647  17.036  1.00 30.78           N  
ATOM    862  CA  PRO   136     -15.796   1.420  16.680  1.00 30.75           C  
ATOM    863  C   PRO   136     -15.003   2.724  16.706  1.00 31.52           C  
ATOM    864  O   PRO   136     -13.776   2.688  16.676  1.00 33.29           O  
ATOM    865  CB  PRO   136     -15.860   0.839  15.259  1.00 31.65           C  
ATOM    866  CG  PRO   136     -17.265   0.651  14.924  1.00 30.94           C  
ATOM    867  CD  PRO   136     -18.124   1.292  15.964  1.00 30.49           C  
ATOM    868  N   ALA   137     -15.693   3.870  16.781  1.00 32.33           N  
ATOM    869  CA  ALA   137     -15.056   5.159  16.842  1.00 33.46           C  
ATOM    870  C   ALA   137     -14.846   5.650  18.274  1.00 34.89           C  
ATOM    871  O   ALA   137     -14.559   6.845  18.467  1.00 34.59           O  
ATOM    872  CB  ALA   137     -15.902   6.193  16.070  1.00 32.66           C  
ATOM    873  N   ALA   138     -15.024   4.752  19.248  1.00 34.13           N  
ATOM    874  CA  ALA   138     -14.902   5.049  20.685  1.00 35.16           C  
ATOM    875  C   ALA   138     -13.668   4.388  21.264  1.00 35.13           C  
ATOM    876  O   ALA   138     -13.452   3.192  21.086  1.00 34.97           O  
ATOM    877  CB  ALA   138     -16.161   4.574  21.462  1.00 35.04           C  
ATOM    878  N   PHE   139     -12.870   5.180  21.959  1.00 35.95           N  
ATOM    879  CA  PHE   139     -11.614   4.734  22.528  1.00 36.87           C  
ATOM    880  C   PHE   139     -11.471   5.138  23.993  1.00 36.57           C  
ATOM    881  O   PHE   139     -11.821   6.270  24.388  1.00 36.96           O  
ATOM    882  CB  PHE   139     -10.447   5.322  21.731  1.00 37.58           C  
ATOM    883  CG  PHE   139     -10.437   4.917  20.257  1.00 38.18           C  
ATOM    884  CD1 PHE   139     -11.110   5.675  19.304  1.00 37.01           C  
ATOM    885  CD2 PHE   139      -9.756   3.790  19.838  1.00 37.84           C  
ATOM    886  CE1 PHE   139     -11.115   5.313  17.985  1.00 36.83           C  
ATOM    887  CE2 PHE   139      -9.764   3.431  18.501  1.00 37.78           C  
ATOM    888  CZ  PHE   139     -10.441   4.210  17.578  1.00 37.29           C  
ATOM    889  N   ILE   140     -10.952   4.201  24.778  1.00 35.26           N  
ATOM    890  CA  ILE   140     -10.656   4.414  26.186  1.00 36.28           C  
ATOM    891  C   ILE   140      -9.157   4.673  26.333  1.00 36.01           C  
ATOM    892  O   ILE   140      -8.360   3.790  25.981  1.00 35.21           O  
ATOM    893  CB  ILE   140     -10.980   3.153  27.042  1.00 36.47           C  
ATOM    894  CG1 ILE   140     -12.471   2.827  26.992  1.00 36.86           C  
ATOM    895  CG2 ILE   140     -10.505   3.359  28.507  1.00 36.54           C  
ATOM    896  CD1 ILE   140     -12.823   1.467  27.609  1.00 37.66           C  
ATOM    897  N   ARG   141      -8.788   5.832  26.895  1.00 35.41           N  
ATOM    898  CA  ARG   141      -7.369   6.211  27.124  1.00 34.78           C  
ATOM    899  C   ARG   141      -7.021   6.495  28.588  1.00 34.90           C  
ATOM    900  O   ARG   141      -7.810   7.115  29.289  1.00 34.61           O  
ATOM    901  CB  ARG   141      -7.002   7.454  26.281  1.00 34.37           C  
ATOM    902  CG  ARG   141      -6.906   7.196  24.783  1.00 34.55           C  
ATOM    903  CD  ARG   141      -5.886   6.100  24.513  1.00 34.71           C  
ATOM    904  NE  ARG   141      -5.766   5.735  23.120  1.00 35.21           N  
ATOM    905  CZ  ARG   141      -6.274   4.642  22.544  1.00 35.59           C  
ATOM    906  NH1 ARG   141      -6.948   3.726  23.222  1.00 36.12           N  
ATOM    907  NH2 ARG   141      -6.061   4.446  21.255  1.00 35.22           N  
ATOM    908  N   GLN   142      -5.829   6.055  29.026  1.00 35.09           N  
ATOM    909  CA  GLN   142      -5.313   6.302  30.408  1.00 34.44           C  
ATOM    910  C   GLN   142      -3.952   6.997  30.332  1.00 33.94           C  
ATOM    911  O   GLN   142      -2.990   6.428  29.822  1.00 33.71           O  
ATOM    912  CB  GLN   142      -5.165   4.993  31.211  1.00 34.70           C  
ATOM    913  CG  GLN   142      -6.405   4.095  31.212  1.00 34.93           C  
ATOM    914  CD  GLN   142      -6.277   2.878  32.097  1.00 35.35           C  
ATOM    915  OE1 GLN   142      -5.995   1.783  31.618  1.00 37.10           O  
ATOM    916  NE2 GLN   142      -6.483   3.062  33.407  1.00 35.35           N  
ATOM    917  N   TYR   143      -3.881   8.225  30.827  1.00 34.02           N  
ATOM    918  CA  TYR   143      -2.631   9.020  30.818  1.00 34.50           C  
ATOM    919  C   TYR   143      -2.240   9.431  32.225  1.00 34.11           C  
ATOM    920  O   TYR   143      -3.114   9.610  33.080  1.00 31.71           O  
ATOM    921  CB  TYR   143      -2.790  10.270  29.944  1.00 34.05           C  
ATOM    922  CG  TYR   143      -3.195   9.923  28.526  1.00 34.61           C  
ATOM    923  CD1 TYR   143      -2.358   9.148  27.710  1.00 34.14           C  
ATOM    924  CD2 TYR   143      -4.393  10.372  27.990  1.00 34.69           C  
ATOM    925  CE1 TYR   143      -2.723   8.821  26.415  1.00 34.01           C  
ATOM    926  CE2 TYR   143      -4.752  10.053  26.693  1.00 34.66           C  
ATOM    927  CZ  TYR   143      -3.917   9.279  25.920  1.00 33.99           C  
ATOM    928  OH  TYR   143      -4.288   8.971  24.642  1.00 34.35           O  
ATOM    929  N   ARG   144      -0.930   9.536  32.463  1.00 33.80           N  
ATOM    930  CA  ARG   144      -0.404   9.988  33.742  1.00 35.60           C  
ATOM    931  C   ARG   144      -0.280  11.510  33.721  1.00 34.05           C  
ATOM    932  O   ARG   144       0.192  12.107  34.681  1.00 33.51           O  
ATOM    933  CB  ARG   144       0.960   9.359  34.046  1.00 36.36           C  
ATOM    934  CG  ARG   144       0.991   7.822  33.954  1.00 38.03           C  
ATOM    935  CD  ARG   144       2.367   7.245  34.238  1.00 39.35           C  
ATOM    936  NE  ARG   144       3.382   8.268  34.007  1.00 41.24           N  
ATOM    937  CZ  ARG   144       4.601   8.071  33.506  1.00 42.86           C  
ATOM    938  NH1 ARG   144       5.012   6.867  33.093  1.00 43.50           N  
ATOM    939  NH2 ARG   144       5.405   9.127  33.377  1.00 42.35           N  
ATOM    940  N   TYR   145      -0.745  12.128  32.635  1.00 34.23           N  
ATOM    941  CA  TYR   145      -0.684  13.578  32.457  1.00 32.95           C  
ATOM    942  C   TYR   145      -2.013  14.174  32.013  1.00 33.09           C  
ATOM    943  O   TYR   145      -2.810  13.522  31.365  1.00 32.37           O  
ATOM    944  CB  TYR   145       0.391  13.878  31.438  1.00 33.59           C  
ATOM    945  CG  TYR   145       1.744  13.420  31.917  1.00 33.35           C  
ATOM    946  CD1 TYR   145       2.172  12.122  31.711  1.00 33.26           C  
ATOM    947  CD2 TYR   145       2.574  14.285  32.608  1.00 33.75           C  
ATOM    948  CE1 TYR   145       3.389  11.697  32.170  1.00 33.34           C  
ATOM    949  CE2 TYR   145       3.791  13.876  33.057  1.00 33.71           C  
ATOM    950  CZ  TYR   145       4.194  12.583  32.837  1.00 33.55           C  
ATOM    951  OH  TYR   145       5.411  12.193  33.306  1.00 34.34           O  
ATOM    952  N   ASP   146      -2.262  15.439  32.332  1.00 34.92           N  
ATOM    953  CA  ASP   146      -3.539  16.038  31.934  1.00 35.59           C  
ATOM    954  C   ASP   146      -3.410  16.548  30.509  1.00 36.12           C  
ATOM    955  O   ASP   146      -3.083  17.710  30.275  1.00 36.73           O  
ATOM    956  CB  ASP   146      -4.019  17.144  32.888  1.00 35.23           C  
ATOM    957  CG  ASP   146      -5.482  17.501  32.657  1.00 35.45           C  
ATOM    958  OD1 ASP   146      -6.054  17.045  31.633  1.00 35.51           O  
ATOM    959  OD2 ASP   146      -6.072  18.196  33.509  1.00 34.99           O  
ATOM    960  N   VAL   147      -3.683  15.652  29.569  1.00 36.09           N  
ATOM    961  CA  VAL   147      -3.580  15.934  28.139  1.00 36.00           C  
ATOM    962  C   VAL   147      -4.681  16.859  27.646  1.00 37.54           C  
ATOM    963  O   VAL   147      -4.578  17.393  26.557  1.00 38.09           O  
ATOM    964  CB  VAL   147      -3.653  14.622  27.297  1.00 35.38           C  
ATOM    965  CG1 VAL   147      -2.531  13.675  27.681  1.00 34.28           C  
ATOM    966  CG2 VAL   147      -5.046  13.949  27.459  1.00 35.03           C  
ATOM    967  N   THR   148      -5.742  17.046  28.430  1.00 40.08           N  
ATOM    968  CA  THR   148      -6.843  17.939  28.035  1.00 40.62           C  
ATOM    969  C   THR   148      -6.586  19.399  28.419  1.00 41.55           C  
ATOM    970  O   THR   148      -7.293  20.309  27.964  1.00 40.82           O  
ATOM    971  CB  THR   148      -8.162  17.553  28.734  1.00 41.38           C  
ATOM    972  OG1 THR   148      -8.043  17.840  30.131  1.00 41.87           O  
ATOM    973  CG2 THR   148      -8.513  16.076  28.536  1.00 40.38           C  
ATOM    974  N   HIS   149      -5.595  19.618  29.276  1.00 42.58           N  
ATOM    975  CA  HIS   149      -5.297  20.956  29.770  1.00 43.38           C  
ATOM    976  C   HIS   149      -3.855  21.343  29.493  1.00 44.04           C  
ATOM    977  O   HIS   149      -3.579  21.904  28.430  1.00 43.03           O  
ATOM    978  CB  HIS   149      -5.634  21.082  31.267  1.00 44.14           C  
ATOM    979  CG  HIS   149      -5.333  22.430  31.836  1.00 44.34           C  
ATOM    980  ND1 HIS   149      -4.211  22.681  32.599  1.00 45.27           N  
ATOM    981  CD2 HIS   149      -5.980  23.614  31.721  1.00 44.87           C  
ATOM    982  CE1 HIS   149      -4.182  23.959  32.938  1.00 44.79           C  
ATOM    983  NE2 HIS   149      -5.249  24.547  32.422  1.00 44.80           N  
ATOM    984  N   ASP   150      -2.930  21.021  30.401  1.00 44.79           N  
ATOM    985  CA  ASP   150      -1.545  21.482  30.234  1.00 45.74           C  
ATOM    986  C   ASP   150      -0.462  20.502  30.737  1.00 45.36           C  
ATOM    987  O   ASP   150       0.588  20.917  31.227  1.00 44.69           O  
ATOM    988  CB  ASP   150      -1.397  22.858  30.890  1.00 46.83           C  
ATOM    989  CG  ASP   150      -0.334  23.714  30.233  1.00 48.68           C  
ATOM    990  OD1 ASP   150       0.428  23.212  29.361  1.00 50.39           O  
ATOM    991  OD2 ASP   150      -0.277  24.916  30.573  1.00 49.33           O  
ATOM    992  N   LEU   151      -0.739  19.209  30.572  1.00 44.73           N  
ATOM    993  CA  LEU   151       0.187  18.114  30.895  1.00 44.03           C  
ATOM    994  C   LEU   151       0.579  18.010  32.352  1.00 43.81           C  
ATOM    995  O   LEU   151       1.716  17.673  32.662  1.00 43.47           O  
ATOM    996  CB  LEU   151       1.441  18.183  30.011  1.00 43.12           C  
ATOM    997  CG  LEU   151       1.178  18.324  28.509  1.00 42.79           C  
ATOM    998  CD1 LEU   151       2.482  18.181  27.706  1.00 41.99           C  
ATOM    999  CD2 LEU   151       0.145  17.316  28.042  1.00 42.24           C  
ATOM   1000  N   GLN   152      -0.378  18.295  33.234  1.00 44.58           N  
ATOM   1001  CA  GLN   152      -0.191  18.162  34.682  1.00 44.48           C  
ATOM   1002  C   GLN   152       0.076  16.686  34.995  1.00 43.53           C  
ATOM   1003  O   GLN   152      -0.577  15.837  34.422  1.00 42.55           O  
ATOM   1004  CB  GLN   152      -1.480  18.582  35.445  1.00 44.70           C  
ATOM   1005  CG  GLN   152      -1.749  20.098  35.662  1.00 45.24           C  
ATOM   1006  CD  GLN   152      -2.106  20.916  34.406  1.00 45.34           C  
ATOM   1007  OE1 GLN   152      -2.549  20.376  33.391  1.00 43.86           O  
ATOM   1008  NE2 GLN   152      -1.931  22.247  34.501  1.00 45.02           N  
ATOM   1009  N   GLU   153       1.051  16.373  35.851  1.00 43.57           N  
ATOM   1010  CA  GLU   153       1.211  14.992  36.314  1.00 43.21           C  
ATOM   1011  C   GLU   153      -0.005  14.717  37.178  1.00 42.36           C  
ATOM   1012  O   GLU   153      -0.084  15.217  38.289  1.00 42.69           O  
ATOM   1013  CB  GLU   153       2.466  14.763  37.150  1.00 43.26           C  
ATOM   1014  CG  GLU   153       3.628  14.244  36.395  1.00 44.27           C  
ATOM   1015  CD  GLU   153       4.799  13.889  37.298  1.00 45.15           C  
ATOM   1016  OE1 GLU   153       5.089  14.665  38.243  1.00 46.26           O  
ATOM   1017  OE2 GLU   153       5.453  12.849  37.043  1.00 46.21           O  
ATOM   1018  N   ALA   154      -0.938  13.936  36.642  1.00 41.00           N  
ATOM   1019  CA  ALA   154      -2.180  13.601  37.311  1.00 40.63           C  
ATOM   1020  C   ALA   154      -2.851  12.510  36.492  1.00 39.98           C  
ATOM   1021  O   ALA   154      -3.087  12.710  35.296  1.00 40.14           O  
ATOM   1022  CB  ALA   154      -3.083  14.827  37.394  1.00 40.73           C  
ATOM   1023  N   GLU   155      -3.118  11.358  37.113  1.00 39.02           N  
ATOM   1024  CA  GLU   155      -3.806  10.248  36.442  1.00 38.44           C  
ATOM   1025  C   GLU   155      -5.091  10.729  35.778  1.00 38.05           C  
ATOM   1026  O   GLU   155      -6.012  11.181  36.454  1.00 36.52           O  
ATOM   1027  CB  GLU   155      -4.125   9.092  37.413  1.00 38.51           C  
ATOM   1028  CG  GLU   155      -2.928   8.203  37.826  1.00 39.18           C  
ATOM   1029  CD  GLU   155      -2.304   7.406  36.667  1.00 39.11           C  
ATOM   1030  OE1 GLU   155      -2.806   7.502  35.528  1.00 39.80           O  
ATOM   1031  OE2 GLU   155      -1.309   6.676  36.900  1.00 39.33           O  
ATOM   1032  N   THR   156      -5.150  10.605  34.450  1.00 38.58           N  
ATOM   1033  CA  THR   156      -6.315  11.049  33.668  1.00 39.32           C  
ATOM   1034  C   THR   156      -6.908   9.901  32.842  1.00 38.56           C  
ATOM   1035  O   THR   156      -6.191   9.175  32.177  1.00 38.94           O  
ATOM   1036  CB  THR   156      -5.961  12.238  32.748  1.00 39.69           C  
ATOM   1037  OG1 THR   156      -5.110  13.151  33.460  1.00 39.65           O  
ATOM   1038  CG2 THR   156      -7.238  12.951  32.288  1.00 38.88           C  
ATOM   1039  N   ALA   157      -8.228   9.758  32.907  1.00 38.33           N  
ATOM   1040  CA  ALA   157      -8.964   8.679  32.254  1.00 38.48           C  
ATOM   1041  C   ALA   157     -10.000   9.322  31.326  1.00 38.25           C  
ATOM   1042  O   ALA   157     -10.901  10.005  31.789  1.00 38.07           O  
ATOM   1043  CB  ALA   157      -9.649   7.780  33.328  1.00 37.18           C  
ATOM   1044  N   LEU   158      -9.871   9.098  30.019  1.00 38.80           N  
ATOM   1045  CA  LEU   158     -10.745   9.736  29.012  1.00 38.15           C  
ATOM   1046  C   LEU   158     -11.397   8.749  28.057  1.00 38.07           C  
ATOM   1047  O   LEU   158     -10.844   7.676  27.783  1.00 37.00           O  
ATOM   1048  CB  LEU   158      -9.907  10.718  28.177  1.00 37.77           C  
ATOM   1049  CG  LEU   158      -9.233  11.893  28.915  1.00 38.21           C  
ATOM   1050  CD1 LEU   158      -8.066  12.510  28.104  1.00 36.98           C  
ATOM   1051  CD2 LEU   158     -10.248  12.946  29.326  1.00 36.74           C  
ATOM   1052  N   LEU   159     -12.573   9.125  27.553  1.00 38.32           N  
ATOM   1053  CA  LEU   159     -13.288   8.364  26.494  1.00 37.73           C  
ATOM   1054  C   LEU   159     -13.305   9.288  25.310  1.00 37.07           C  
ATOM   1055  O   LEU   159     -13.845  10.410  25.428  1.00 37.83           O  
ATOM   1056  CB  LEU   159     -14.742   8.037  26.854  1.00 37.83           C  
ATOM   1057  CG  LEU   159     -15.545   7.301  25.775  1.00 38.57           C  
ATOM   1058  CD1 LEU   159     -14.891   5.919  25.489  1.00 38.98           C  
ATOM   1059  CD2 LEU   159     -17.048   7.119  26.134  1.00 37.71           C  
ATOM   1060  N   ILE   160     -12.697   8.869  24.198  1.00 35.82           N  
ATOM   1061  CA  ILE   160     -12.689   9.678  22.962  1.00 35.81           C  
ATOM   1062  C   ILE   160     -13.626   8.993  21.964  1.00 35.30           C  
ATOM   1063  O   ILE   160     -13.571   7.751  21.790  1.00 32.61           O  
ATOM   1064  CB  ILE   160     -11.259   9.822  22.346  1.00 35.67           C  
ATOM   1065  CG1 ILE   160     -10.329  10.615  23.269  1.00 36.38           C  
ATOM   1066  CG2 ILE   160     -11.341  10.519  21.005  1.00 36.24           C  
ATOM   1067  CD1 ILE   160      -9.693   9.814  24.356  1.00 35.92           C  
ATOM   1068  N   TRP   161     -14.533   9.753  21.358  1.00 34.16           N  
ATOM   1069  CA  TRP   161     -15.456   9.155  20.384  1.00 35.62           C  
ATOM   1070  C   TRP   161     -15.980  10.135  19.343  1.00 36.26           C  
ATOM   1071  O   TRP   161     -15.693  11.326  19.429  1.00 35.77           O  
ATOM   1072  CB  TRP   161     -16.644   8.522  21.109  1.00 37.38           C  
ATOM   1073  CG  TRP   161     -17.718   9.455  21.577  1.00 37.18           C  
ATOM   1074  CD1 TRP   161     -18.903   9.685  20.966  1.00 37.71           C  
ATOM   1075  CD2 TRP   161     -17.728  10.237  22.773  1.00 37.19           C  
ATOM   1076  NE1 TRP   161     -19.642  10.576  21.678  1.00 37.89           N  
ATOM   1077  CE2 TRP   161     -18.945  10.934  22.798  1.00 38.42           C  
ATOM   1078  CE3 TRP   161     -16.816  10.435  23.808  1.00 37.18           C  
ATOM   1079  CZ2 TRP   161     -19.276  11.835  23.813  1.00 38.40           C  
ATOM   1080  CZ3 TRP   161     -17.142  11.285  24.818  1.00 37.74           C  
ATOM   1081  CH2 TRP   161     -18.369  11.986  24.824  1.00 38.15           C  
ATOM   1082  N   ARG   162     -16.759   9.632  18.381  1.00 36.30           N  
ATOM   1083  CA  ARG   162     -17.405  10.495  17.383  1.00 36.65           C  
ATOM   1084  C   ARG   162     -18.910  10.371  17.580  1.00 36.51           C  
ATOM   1085  O   ARG   162     -19.440   9.263  17.606  1.00 35.78           O  
ATOM   1086  CB  ARG   162     -17.036  10.123  15.944  1.00 36.17           C  
ATOM   1087  CG  ARG   162     -17.505  11.169  14.969  1.00 36.54           C  
ATOM   1088  CD  ARG   162     -16.821  11.107  13.626  1.00 36.00           C  
ATOM   1089  NE  ARG   162     -17.436  10.134  12.715  1.00 35.70           N  
ATOM   1090  CZ  ARG   162     -17.007   8.899  12.463  1.00 35.72           C  
ATOM   1091  NH1 ARG   162     -15.925   8.408  13.036  1.00 36.11           N  
ATOM   1092  NH2 ARG   162     -17.668   8.156  11.588  1.00 35.62           N  
ATOM   1093  N   ASN   163     -19.597  11.505  17.694  1.00 37.07           N  
ATOM   1094  CA  ASN   163     -21.015  11.459  18.004  1.00 38.11           C  
ATOM   1095  C   ASN   163     -21.908  11.453  16.780  1.00 39.76           C  
ATOM   1096  O   ASN   163     -21.410  11.428  15.668  1.00 40.47           O  
ATOM   1097  CB  ASN   163     -21.359  12.566  18.979  1.00 37.72           C  
ATOM   1098  CG  ASN   163     -21.269  13.932  18.358  1.00 37.22           C  
ATOM   1099  OD1 ASN   163     -21.160  14.070  17.146  1.00 38.13           O  
ATOM   1100  ND2 ASN   163     -21.356  14.949  19.185  1.00 37.50           N  
ATOM   1101  N   ALA   164     -23.226  11.443  16.989  1.00 41.32           N  
ATOM   1102  CA  ALA   164     -24.203  11.411  15.897  1.00 41.49           C  
ATOM   1103  C   ALA   164     -24.046  12.531  14.871  1.00 42.17           C  
ATOM   1104  O   ALA   164     -24.417  12.345  13.715  1.00 41.92           O  
ATOM   1105  CB  ALA   164     -25.641  11.401  16.471  1.00 42.29           C  
ATOM   1106  N   GLU   165     -23.515  13.682  15.289  1.00 42.49           N  
ATOM   1107  CA  GLU   165     -23.253  14.805  14.375  1.00 43.04           C  
ATOM   1108  C   GLU   165     -21.858  14.735  13.715  1.00 42.42           C  
ATOM   1109  O   GLU   165     -21.395  15.723  13.153  1.00 40.99           O  
ATOM   1110  CB  GLU   165     -23.353  16.131  15.123  1.00 43.93           C  
ATOM   1111  CG  GLU   165     -24.748  16.511  15.540  1.00 45.40           C  
ATOM   1112  CD  GLU   165     -24.763  17.805  16.346  1.00 46.25           C  
ATOM   1113  OE1 GLU   165     -24.250  17.781  17.504  1.00 47.45           O  
ATOM   1114  OE2 GLU   165     -25.300  18.828  15.826  1.00 47.05           O  
ATOM   1115  N   ASP   166     -21.201  13.579  13.808  1.00 40.89           N  
ATOM   1116  CA  ASP   166     -19.862  13.355  13.259  1.00 41.15           C  
ATOM   1117  C   ASP   166     -18.775  14.319  13.804  1.00 40.03           C  
ATOM   1118  O   ASP   166     -17.812  14.628  13.100  1.00 38.42           O  
ATOM   1119  CB  ASP   166     -19.876  13.307  11.704  1.00 41.47           C  
ATOM   1120  CG  ASP   166     -20.427  11.982  11.143  1.00 41.09           C  
ATOM   1121  OD1 ASP   166     -20.142  10.911  11.701  1.00 40.80           O  
ATOM   1122  OD2 ASP   166     -21.117  12.003  10.101  1.00 41.82           O  
ATOM   1123  N   ASP   167     -18.934  14.767  15.057  1.00 40.27           N  
ATOM   1124  CA  ASP   167     -17.931  15.619  15.742  1.00 40.57           C  
ATOM   1125  C   ASP   167     -17.164  14.774  16.756  1.00 39.01           C  
ATOM   1126  O   ASP   167     -17.783  13.962  17.449  1.00 39.31           O  
ATOM   1127  CB  ASP   167     -18.599  16.781  16.492  1.00 41.60           C  
ATOM   1128  CG  ASP   167     -19.185  17.828  15.566  1.00 42.34           C  
ATOM   1129  OD1 ASP   167     -18.468  18.360  14.701  1.00 43.82           O  
ATOM   1130  OD2 ASP   167     -20.363  18.165  15.743  1.00 44.30           O  
ATOM   1131  N   VAL   168     -15.838  14.958  16.829  1.00 36.76           N  
ATOM   1132  CA  VAL   168     -15.006  14.240  17.789  1.00 35.36           C  
ATOM   1133  C   VAL   168     -15.226  14.869  19.171  1.00 35.50           C  
ATOM   1134  O   VAL   168     -15.207  16.106  19.342  1.00 32.60           O  
ATOM   1135  CB  VAL   168     -13.510  14.245  17.431  1.00 35.37           C  
ATOM   1136  CG1 VAL   168     -12.719  13.431  18.436  1.00 35.65           C  
ATOM   1137  CG2 VAL   168     -13.292  13.682  16.052  1.00 35.05           C  
ATOM   1138  N   MET   169     -15.476  14.008  20.146  1.00 33.94           N  
ATOM   1139  CA  MET   169     -15.734  14.428  21.512  1.00 33.79           C  
ATOM   1140  C   MET   169     -14.858  13.600  22.453  1.00 34.81           C  
ATOM   1141  O   MET   169     -14.458  12.471  22.130  1.00 30.90           O  
ATOM   1142  CB  MET   169     -17.201  14.148  21.890  1.00 34.13           C  
ATOM   1143  CG  MET   169     -18.291  14.595  20.964  1.00 33.48           C  
ATOM   1144  SD  MET   169     -18.437  16.527  20.858  0.75 37.47          SE  
ATOM   1145  CE  MET   169     -19.112  16.847  22.681  1.00 31.68           C  
ATOM   1146  N   TYR   170     -14.569  14.167  23.618  1.00 35.79           N  
ATOM   1147  CA  TYR   170     -13.835  13.455  24.636  1.00 36.09           C  
ATOM   1148  C   TYR   170     -14.502  13.833  25.959  1.00 37.22           C  
ATOM   1149  O   TYR   170     -15.080  14.917  26.071  1.00 34.89           O  
ATOM   1150  CB  TYR   170     -12.317  13.783  24.601  1.00 36.65           C  
ATOM   1151  CG  TYR   170     -11.885  15.201  24.997  1.00 37.32           C  
ATOM   1152  CD1 TYR   170     -11.850  15.587  26.339  1.00 38.17           C  
ATOM   1153  CD2 TYR   170     -11.444  16.128  24.041  1.00 36.93           C  
ATOM   1154  CE1 TYR   170     -11.448  16.895  26.731  1.00 36.83           C  
ATOM   1155  CE2 TYR   170     -11.027  17.440  24.427  1.00 37.45           C  
ATOM   1156  CZ  TYR   170     -11.037  17.798  25.777  1.00 37.46           C  
ATOM   1157  OH  TYR   170     -10.647  19.065  26.197  1.00 37.82           O  
ATOM   1158  N   GLN   171     -14.427  12.950  26.952  1.00 36.97           N  
ATOM   1159  CA  GLN   171     -14.931  13.264  28.302  1.00 38.53           C  
ATOM   1160  C   GLN   171     -14.247  12.413  29.334  1.00 36.99           C  
ATOM   1161  O   GLN   171     -13.814  11.296  29.038  1.00 37.34           O  
ATOM   1162  CB  GLN   171     -16.450  13.039  28.429  1.00 39.94           C  
ATOM   1163  CG  GLN   171     -16.874  11.573  28.480  1.00 41.08           C  
ATOM   1164  CD  GLN   171     -18.399  11.383  28.609  1.00 42.57           C  
ATOM   1165  OE1 GLN   171     -19.202  12.314  28.348  1.00 45.34           O  
ATOM   1166  NE2 GLN   171     -18.801  10.179  29.008  1.00 44.67           N  
ATOM   1167  N   THR   172     -14.187  12.906  30.567  1.00 35.94           N  
ATOM   1168  CA  THR   172     -13.585  12.134  31.649  0.50 35.77           C  
ATOM   1170  C   THR   172     -14.403  10.853  31.826  1.00 35.48           C  
ATOM   1171  O   THR   172     -15.610  10.851  31.681  1.00 34.08           O  
ATOM   1172  CB  THR   172     -13.508  12.937  32.961  0.50 35.97           C  
ATOM   1174  OG1 THR   172     -14.832  13.263  33.407  0.50 36.62           O  
ATOM   1176  CG2 THR   172     -12.703  14.212  32.757  0.50 35.21           C  
ATOM   1178  N   LEU   173     -13.723   9.749  32.094  1.00 37.16           N  
ATOM   1179  CA  LEU   173     -14.361   8.480  32.248  1.00 38.77           C  
ATOM   1180  C   LEU   173     -14.133   8.031  33.687  1.00 41.89           C  
ATOM   1181  O   LEU   173     -12.973   7.958  34.150  1.00 42.80           O  
ATOM   1182  CB  LEU   173     -13.715   7.490  31.288  1.00 38.76           C  
ATOM   1183  CG  LEU   173     -14.480   6.251  30.833  1.00 38.66           C  
ATOM   1184  CD1 LEU   173     -15.783   6.646  30.191  1.00 36.48           C  
ATOM   1185  CD2 LEU   173     -13.607   5.482  29.866  1.00 37.79           C  
ATOM   1186  N   ASP   174     -15.226   7.774  34.412  1.00 43.53           N  
ATOM   1187  CA  ASP   174     -15.114   7.254  35.771  1.00 44.88           C  
ATOM   1188  C   ASP   174     -14.975   5.716  35.690  1.00 44.13           C  
ATOM   1189  O   ASP   174     -15.195   5.120  34.639  1.00 42.26           O  
ATOM   1190  CB  ASP   174     -16.253   7.760  36.706  1.00 45.97           C  
ATOM   1191  CG  ASP   174     -17.658   7.312  36.286  1.00 46.82           C  
ATOM   1192  OD1 ASP   174     -17.829   6.394  35.462  1.00 48.80           O  
ATOM   1193  OD2 ASP   174     -18.629   7.886  36.815  1.00 47.87           O  
ATOM   1194  N   GLY   175     -14.578   5.100  36.798  1.00 45.15           N  
ATOM   1195  CA  GLY   175     -14.337   3.644  36.858  1.00 46.19           C  
ATOM   1196  C   GLY   175     -15.469   2.691  36.490  1.00 46.07           C  
ATOM   1197  O   GLY   175     -15.213   1.631  35.921  1.00 44.48           O  
ATOM   1198  N   PHE   176     -16.705   3.029  36.858  1.00 47.77           N  
ATOM   1199  CA  PHE   176     -17.872   2.181  36.511  1.00 48.38           C  
ATOM   1200  C   PHE   176     -18.038   2.124  34.998  1.00 46.08           C  
ATOM   1201  O   PHE   176     -18.206   1.055  34.422  1.00 44.30           O  
ATOM   1202  CB  PHE   176     -19.184   2.741  37.104  1.00 50.64           C  
ATOM   1203  CG  PHE   176     -20.358   1.787  36.991  1.00 50.93           C  
ATOM   1204  CD1 PHE   176     -21.063   1.663  35.793  1.00 51.81           C  
ATOM   1205  CD2 PHE   176     -20.744   1.003  38.074  1.00 51.75           C  
ATOM   1206  CE1 PHE   176     -22.127   0.782  35.684  1.00 52.34           C  
ATOM   1207  CE2 PHE   176     -21.813   0.120  37.978  1.00 51.91           C  
ATOM   1208  CZ  PHE   176     -22.501   0.006  36.786  1.00 52.07           C  
ATOM   1209  N   ASP   177     -18.030   3.316  34.402  1.00 43.78           N  
ATOM   1210  CA  ASP   177     -18.138   3.506  32.961  1.00 42.31           C  
ATOM   1211  C   ASP   177     -17.038   2.803  32.187  1.00 40.47           C  
ATOM   1212  O   ASP   177     -17.315   2.124  31.183  1.00 38.92           O  
ATOM   1213  CB  ASP   177     -18.098   5.006  32.652  1.00 42.66           C  
ATOM   1214  CG  ASP   177     -19.338   5.708  33.107  1.00 43.24           C  
ATOM   1215  OD1 ASP   177     -20.192   5.039  33.727  1.00 43.85           O  
ATOM   1216  OD2 ASP   177     -19.479   6.910  32.810  1.00 42.81           O  
ATOM   1217  N   MET   178     -15.798   2.949  32.656  1.00 39.39           N  
ATOM   1218  CA  MET   178     -14.663   2.298  32.000  1.00 40.64           C  
ATOM   1219  C   MET   178     -14.869   0.766  31.995  1.00 40.74           C  
ATOM   1220  O   MET   178     -14.648   0.085  30.975  1.00 41.40           O  
ATOM   1221  CB  MET   178     -13.345   2.681  32.690  1.00 40.52           C  
ATOM   1222  CG  MET   178     -12.078   2.251  31.974  1.00 41.29           C  
ATOM   1223  SD  MET   178     -10.453   2.665  33.068  0.75 42.72          SE  
ATOM   1224  CE  MET   178     -10.429   4.544  32.789  1.00 41.52           C  
ATOM   1225  N   MET   179     -15.315   0.256  33.124  1.00 41.35           N  
ATOM   1226  CA  MET   179     -15.556  -1.178  33.300  1.00 43.56           C  
ATOM   1227  C   MET   179     -16.640  -1.689  32.352  1.00 41.60           C  
ATOM   1228  O   MET   179     -16.456  -2.675  31.679  1.00 41.85           O  
ATOM   1229  CB  MET   179     -15.942  -1.460  34.764  1.00 44.08           C  
ATOM   1230  CG  MET   179     -16.440  -2.879  35.053  1.00 45.36           C  
ATOM   1231  SD  MET   179     -16.813  -3.096  36.947  0.75 47.94          SE  
ATOM   1232  CE  MET   179     -14.922  -3.086  37.444  1.00 47.55           C  
ATOM   1233  N   LEU   180     -17.770  -1.002  32.329  1.00 41.88           N  
ATOM   1234  CA  LEU   180     -18.876  -1.351  31.456  1.00 41.24           C  
ATOM   1235  C   LEU   180     -18.467  -1.298  29.978  1.00 41.06           C  
ATOM   1236  O   LEU   180     -18.760  -2.229  29.222  1.00 41.65           O  
ATOM   1237  CB  LEU   180     -20.062  -0.411  31.683  1.00 42.02           C  
ATOM   1238  CG  LEU   180     -21.271  -0.875  30.862  1.00 42.92           C  
ATOM   1239  CD1 LEU   180     -21.695  -2.288  31.332  1.00 42.64           C  
ATOM   1240  CD2 LEU   180     -22.429   0.094  30.902  1.00 41.63           C  
ATOM   1241  N   LEU   181     -17.805  -0.223  29.543  1.00 39.70           N  
ATOM   1242  CA  LEU   181     -17.411  -0.135  28.130  1.00 38.32           C  
ATOM   1243  C   LEU   181     -16.451  -1.246  27.773  1.00 38.31           C  
ATOM   1244  O   LEU   181     -16.532  -1.782  26.686  1.00 36.05           O  
ATOM   1245  CB  LEU   181     -16.762   1.183  27.782  1.00 38.28           C  
ATOM   1246  CG  LEU   181     -17.665   2.399  27.911  1.00 36.54           C  
ATOM   1247  CD1 LEU   181     -16.873   3.622  27.735  1.00 37.18           C  
ATOM   1248  CD2 LEU   181     -18.810   2.275  26.897  1.00 36.99           C  
ATOM   1249  N   GLU   182     -15.512  -1.535  28.669  1.00 38.51           N  
ATOM   1250  CA  GLU   182     -14.522  -2.609  28.446  1.00 40.12           C  
ATOM   1251  C   GLU   182     -15.173  -3.999  28.354  1.00 38.77           C  
ATOM   1252  O   GLU   182     -14.787  -4.833  27.514  1.00 41.22           O  
ATOM   1253  CB  GLU   182     -13.507  -2.634  29.591  1.00 41.80           C  
ATOM   1254  CG  GLU   182     -12.290  -3.511  29.311  1.00 42.74           C  
ATOM   1255  CD  GLU   182     -11.361  -2.891  28.303  1.00 43.71           C  
ATOM   1256  OE1 GLU   182     -11.405  -1.639  28.138  1.00 44.55           O  
ATOM   1257  OE2 GLU   182     -10.564  -3.644  27.703  1.00 44.05           O  
ATOM   1258  N   ILE   183     -16.106  -4.252  29.273  1.00 37.91           N  
ATOM   1259  CA  ILE   183     -16.902  -5.493  29.336  1.00 37.16           C  
ATOM   1260  C   ILE   183     -17.745  -5.546  28.049  1.00 36.31           C  
ATOM   1261  O   ILE   183     -17.742  -6.521  27.329  1.00 35.36           O  
ATOM   1262  CB  ILE   183     -17.828  -5.442  30.587  1.00 37.12           C  
ATOM   1263  CG1 ILE   183     -17.063  -5.750  31.869  1.00 36.95           C  
ATOM   1264  CG2 ILE   183     -19.031  -6.343  30.458  1.00 38.23           C  
ATOM   1265  CD1 ILE   183     -17.942  -5.655  33.137  1.00 37.12           C  
ATOM   1266  N   MET   184     -18.440  -4.454  27.744  1.00 35.71           N  
ATOM   1267  CA  MET   184     -19.238  -4.380  26.526  1.00 34.96           C  
ATOM   1268  C   MET   184     -18.418  -4.586  25.249  1.00 35.85           C  
ATOM   1269  O   MET   184     -18.939  -5.122  24.265  1.00 36.27           O  
ATOM   1270  CB  MET   184     -20.033  -3.085  26.446  1.00 33.23           C  
ATOM   1271  CG  MET   184     -21.222  -3.019  27.395  1.00 31.28           C  
ATOM   1272  SD  MET   184     -22.000  -1.323  27.109  0.75 33.38          SE  
ATOM   1273  CE  MET   184     -22.939  -1.763  25.378  1.00 31.32           C  
ATOM   1274  N   GLY   185     -17.148  -4.197  25.274  1.00 34.94           N  
ATOM   1275  CA  GLY   185     -16.274  -4.433  24.146  1.00 35.89           C  
ATOM   1276  C   GLY   185     -15.982  -5.923  24.017  1.00 37.67           C  
ATOM   1277  O   GLY   185     -15.725  -6.435  22.910  1.00 38.56           O  
ATOM   1278  N   SER   186     -16.026  -6.632  25.144  1.00 38.48           N  
ATOM   1279  CA  SER   186     -15.778  -8.080  25.147  1.00 39.76           C  
ATOM   1280  C   SER   186     -16.968  -8.860  24.587  1.00 40.37           C  
ATOM   1281  O   SER   186     -16.806  -9.865  23.877  1.00 40.00           O  
ATOM   1282  CB  SER   186     -15.495  -8.592  26.570  1.00 39.79           C  
ATOM   1283  OG  SER   186     -14.333  -8.012  27.134  1.00 39.83           O  
ATOM   1284  N   SER   187     -18.167  -8.445  24.965  1.00 40.53           N  
ATOM   1285  CA  SER   187     -19.350  -9.129  24.488  1.00 41.39           C  
ATOM   1286  C   SER   187     -20.579  -8.234  24.546  1.00 40.22           C  
ATOM   1287  O   SER   187     -20.978  -7.820  25.624  1.00 40.70           O  
ATOM   1288  CB  SER   187     -19.578 -10.406  25.298  1.00 42.49           C  
ATOM   1289  OG  SER   187     -19.582 -10.126  26.684  1.00 44.00           O  
ATOM   1290  N   ALA   188     -21.157  -7.973  23.372  1.00 38.68           N  
ATOM   1291  CA  ALA   188     -22.369  -7.193  23.207  1.00 38.36           C  
ATOM   1292  C   ALA   188     -23.358  -7.535  24.313  1.00 37.68           C  
ATOM   1293  O   ALA   188     -23.562  -8.701  24.646  1.00 39.44           O  
ATOM   1294  CB  ALA   188     -22.978  -7.454  21.840  1.00 36.97           C  
ATOM   1295  N   LEU   189     -23.989  -6.506  24.834  1.00 37.15           N  
ATOM   1296  CA  LEU   189     -24.850  -6.570  26.003  1.00 38.47           C  
ATOM   1297  C   LEU   189     -26.162  -5.759  25.830  1.00 37.16           C  
ATOM   1298  O   LEU   189     -26.156  -4.703  25.248  1.00 37.13           O  
ATOM   1299  CB  LEU   189     -24.006  -5.922  27.127  1.00 38.77           C  
ATOM   1300  CG  LEU   189     -24.536  -5.584  28.514  1.00 40.39           C  
ATOM   1301  CD1 LEU   189     -24.419  -6.807  29.417  1.00 41.44           C  
ATOM   1302  CD2 LEU   189     -23.760  -4.419  29.132  1.00 40.31           C  
ATOM   1303  N   SER   190     -27.282  -6.254  26.331  1.00 37.95           N  
ATOM   1304  CA  SER   190     -28.518  -5.453  26.348  1.00 37.69           C  
ATOM   1305  C   SER   190     -28.605  -4.730  27.687  1.00 36.73           C  
ATOM   1306  O   SER   190     -27.894  -5.081  28.625  1.00 33.55           O  
ATOM   1307  CB  SER   190     -29.771  -6.342  26.171  1.00 37.26           C  
ATOM   1308  OG  SER   190     -30.007  -7.182  27.293  1.00 35.50           O  
ATOM   1309  N   PHE   191     -29.451  -3.695  27.775  1.00 38.21           N  
ATOM   1310  CA  PHE   191     -29.691  -3.038  29.055  1.00 36.68           C  
ATOM   1311  C   PHE   191     -30.306  -4.054  30.014  1.00 36.63           C  
ATOM   1312  O   PHE   191     -29.943  -4.074  31.177  1.00 36.15           O  
ATOM   1313  CB  PHE   191     -30.633  -1.846  28.929  1.00 37.61           C  
ATOM   1314  CG  PHE   191     -30.909  -1.152  30.230  1.00 37.73           C  
ATOM   1315  CD1 PHE   191     -29.970  -0.294  30.788  1.00 38.70           C  
ATOM   1316  CD2 PHE   191     -32.107  -1.347  30.903  1.00 38.74           C  
ATOM   1317  CE1 PHE   191     -30.217   0.351  31.989  1.00 37.92           C  
ATOM   1318  CE2 PHE   191     -32.360  -0.703  32.102  1.00 37.90           C  
ATOM   1319  CZ  PHE   191     -31.407   0.148  32.643  1.00 38.10           C  
ATOM   1320  N   ASP   192     -31.220  -4.911  29.537  1.00 36.19           N  
ATOM   1321  CA  ASP   192     -31.854  -5.864  30.429  1.00 35.73           C  
ATOM   1322  C   ASP   192     -30.837  -6.798  31.035  1.00 34.04           C  
ATOM   1323  O   ASP   192     -30.936  -7.099  32.218  1.00 31.85           O  
ATOM   1324  CB  ASP   192     -32.991  -6.668  29.769  1.00 36.97           C  
ATOM   1325  CG  ASP   192     -34.241  -5.818  29.511  1.00 37.83           C  
ATOM   1326  OD1 ASP   192     -34.239  -4.589  29.827  1.00 36.14           O  
ATOM   1327  OD2 ASP   192     -35.215  -6.396  28.968  1.00 37.83           O  
ATOM   1328  N   THR   193     -29.882  -7.251  30.228  1.00 33.57           N  
ATOM   1329  CA  THR   193     -28.784  -8.108  30.701  1.00 33.05           C  
ATOM   1330  C   THR   193     -27.885  -7.293  31.674  1.00 33.22           C  
ATOM   1331  O   THR   193     -27.553  -7.752  32.763  1.00 32.46           O  
ATOM   1332  CB  THR   193     -27.951  -8.657  29.516  1.00 33.39           C  
ATOM   1333  OG1 THR   193     -28.748  -9.558  28.714  1.00 32.30           O  
ATOM   1334  CG2 THR   193     -26.703  -9.397  29.999  1.00 32.95           C  
ATOM   1335  N   LEU   194     -27.530  -6.061  31.321  1.00 33.14           N  
ATOM   1336  CA  LEU   194     -26.707  -5.264  32.232  1.00 32.74           C  
ATOM   1337  C   LEU   194     -27.412  -5.148  33.579  1.00 34.32           C  
ATOM   1338  O   LEU   194     -26.905  -5.610  34.606  1.00 34.58           O  
ATOM   1339  CB  LEU   194     -26.451  -3.866  31.655  1.00 33.10           C  
ATOM   1340  CG  LEU   194     -25.699  -2.841  32.508  1.00 32.84           C  
ATOM   1341  CD1 LEU   194     -24.341  -3.367  32.928  1.00 32.94           C  
ATOM   1342  CD2 LEU   194     -25.598  -1.508  31.737  1.00 32.98           C  
ATOM   1343  N   ALA   195     -28.597  -4.546  33.576  1.00 35.92           N  
ATOM   1344  CA  ALA   195     -29.320  -4.299  34.825  1.00 37.64           C  
ATOM   1345  C   ALA   195     -29.554  -5.561  35.667  1.00 37.88           C  
ATOM   1346  O   ALA   195     -29.464  -5.514  36.880  1.00 40.48           O  
ATOM   1347  CB  ALA   195     -30.639  -3.534  34.551  1.00 36.84           C  
ATOM   1348  N   GLN   196     -29.800  -6.697  35.042  1.00 39.20           N  
ATOM   1349  CA  GLN   196     -30.019  -7.934  35.786  1.00 39.69           C  
ATOM   1350  C   GLN   196     -28.737  -8.493  36.437  1.00 40.33           C  
ATOM   1351  O   GLN   196     -28.802  -9.184  37.470  1.00 41.04           O  
ATOM   1352  CB  GLN   196     -30.624  -9.008  34.858  1.00 40.42           C  
ATOM   1353  CG  GLN   196     -30.778 -10.420  35.472  1.00 40.58           C  
ATOM   1354  CD  GLN   196     -31.645 -10.452  36.735  1.00 41.73           C  
ATOM   1355  OE1 GLN   196     -32.548  -9.633  36.907  1.00 43.88           O  
ATOM   1356  NE2 GLN   196     -31.391 -11.423  37.606  1.00 41.67           N  
ATOM   1357  N   THR   197     -27.588  -8.255  35.810  1.00 38.92           N  
ATOM   1358  CA  THR   197     -26.328  -8.785  36.321  1.00 37.94           C  
ATOM   1359  C   THR   197     -25.937  -8.023  37.571  1.00 36.70           C  
ATOM   1360  O   THR   197     -25.409  -8.630  38.485  1.00 35.53           O  
ATOM   1361  CB  THR   197     -25.192  -8.642  35.280  1.00 39.04           C  
ATOM   1362  OG1 THR   197     -25.568  -9.302  34.071  1.00 39.48           O  
ATOM   1363  CG2 THR   197     -23.883  -9.235  35.804  1.00 39.19           C  
ATOM   1364  N   LEU   198     -26.194  -6.700  37.581  1.00 33.17           N  
ATOM   1365  CA  LEU   198     -25.887  -5.832  38.711  1.00 33.38           C  
ATOM   1366  C   LEU   198     -26.846  -5.943  39.894  1.00 34.22           C  
ATOM   1367  O   LEU   198     -26.519  -5.510  41.000  1.00 33.03           O  
ATOM   1368  CB  LEU   198     -25.853  -4.354  38.276  1.00 32.60           C  
ATOM   1369  CG  LEU   198     -24.821  -3.832  37.292  1.00 32.72           C  
ATOM   1370  CD1 LEU   198     -25.148  -2.360  36.810  1.00 29.29           C  
ATOM   1371  CD2 LEU   198     -23.429  -3.896  37.907  1.00 33.12           C  
ATOM   1372  N   VAL   199     -28.022  -6.522  39.683  1.00 36.58           N  
ATOM   1373  CA  VAL   199     -29.008  -6.681  40.750  1.00 37.54           C  
ATOM   1374  C   VAL   199     -28.443  -7.249  42.050  1.00 39.42           C  
ATOM   1375  O   VAL   199     -28.828  -6.816  43.151  1.00 39.34           O  
ATOM   1376  CB  VAL   199     -30.224  -7.544  40.276  1.00 36.98           C  
ATOM   1377  CG1 VAL   199     -30.957  -8.122  41.434  1.00 35.71           C  
ATOM   1378  CG2 VAL   199     -31.155  -6.689  39.401  1.00 36.23           C  
ATOM   1379  N   GLU   200     -27.521  -8.200  41.945  1.00 41.22           N  
ATOM   1380  CA  GLU   200     -26.982  -8.823  43.150  1.00 42.00           C  
ATOM   1381  C   GLU   200     -25.916  -7.994  43.879  1.00 41.83           C  
ATOM   1382  O   GLU   200     -25.615  -8.261  45.037  1.00 42.68           O  
ATOM   1383  CB  GLU   200     -26.468 -10.245  42.873  1.00 42.76           C  
ATOM   1384  CG  GLU   200     -25.208 -10.396  42.009  1.00 42.85           C  
ATOM   1385  CD  GLU   200     -24.499 -11.743  42.272  1.00 43.32           C  
ATOM   1386  OE1 GLU   200     -24.374 -12.129  43.462  1.00 44.06           O  
ATOM   1387  OE2 GLU   200     -24.040 -12.401  41.308  1.00 43.24           O  
ATOM   1388  N   PHE   201     -25.351  -6.989  43.227  1.00 41.69           N  
ATOM   1389  CA  PHE   201     -24.333  -6.163  43.858  1.00 41.84           C  
ATOM   1390  C   PHE   201     -24.857  -4.766  44.149  1.00 41.15           C  
ATOM   1391  O   PHE   201     -24.074  -3.818  44.199  1.00 41.58           O  
ATOM   1392  CB  PHE   201     -23.119  -6.041  42.935  1.00 42.85           C  
ATOM   1393  CG  PHE   201     -22.711  -7.325  42.327  1.00 43.28           C  
ATOM   1394  CD1 PHE   201     -22.106  -8.313  43.106  1.00 43.38           C  
ATOM   1395  CD2 PHE   201     -22.944  -7.568  40.980  1.00 43.18           C  
ATOM   1396  CE1 PHE   201     -21.736  -9.526  42.544  1.00 43.77           C  
ATOM   1397  CE2 PHE   201     -22.571  -8.775  40.405  1.00 43.77           C  
ATOM   1398  CZ  PHE   201     -21.972  -9.757  41.185  1.00 43.34           C  
ATOM   1399  N   MET   202     -26.167  -4.644  44.337  1.00 39.31           N  
ATOM   1400  CA  MET   202     -26.809  -3.367  44.555  1.00 38.45           C  
ATOM   1401  C   MET   202     -27.879  -3.471  45.655  1.00 38.54           C  
ATOM   1402  O   MET   202     -28.298  -4.575  46.011  1.00 39.36           O  
ATOM   1403  CB  MET   202     -27.421  -2.925  43.232  1.00 38.67           C  
ATOM   1404  CG  MET   202     -26.387  -2.622  42.128  1.00 37.28           C  
ATOM   1405  SD  MET   202     -25.423  -0.969  42.396  0.75 37.93          SE  
ATOM   1406  CE  MET   202     -26.624   0.243  41.755  1.00 39.90           C  
ATOM   1407  N   PRO   203     -28.287  -2.338  46.245  1.00 37.65           N  
ATOM   1408  CA  PRO   203     -29.354  -2.368  47.264  1.00 38.20           C  
ATOM   1409  C   PRO   203     -30.669  -2.907  46.713  1.00 38.81           C  
ATOM   1410  O   PRO   203     -30.902  -2.803  45.508  1.00 39.63           O  
ATOM   1411  CB  PRO   203     -29.523  -0.895  47.649  1.00 37.58           C  
ATOM   1412  CG  PRO   203     -28.263  -0.263  47.275  1.00 37.55           C  
ATOM   1413  CD  PRO   203     -27.751  -0.990  46.059  1.00 37.28           C  
ATOM   1414  N   LYS   204     -31.508  -3.468  47.587  1.00 39.31           N  
ATOM   1415  CA  LYS   204     -32.810  -4.047  47.207  1.00 39.35           C  
ATOM   1416  C   LYS   204     -33.734  -3.053  46.477  1.00 39.72           C  
ATOM   1417  O   LYS   204     -34.442  -3.452  45.558  1.00 40.18           O  
ATOM   1418  CB  LYS   204     -33.521  -4.681  48.426  1.00 39.78           C  
ATOM   1419  N   ALA   205     -33.708  -1.778  46.879  1.00 38.98           N  
ATOM   1420  CA  ALA   205     -34.517  -0.728  46.255  1.00 38.75           C  
ATOM   1421  C   ALA   205     -33.930  -0.470  44.874  1.00 38.44           C  
ATOM   1422  O   ALA   205     -32.742  -0.128  44.749  1.00 37.86           O  
ATOM   1423  CB  ALA   205     -34.488   0.555  47.087  1.00 38.54           C  
ATOM   1424  N   ASP   206     -34.768  -0.614  43.846  1.00 37.50           N  
ATOM   1425  CA  ASP   206     -34.311  -0.545  42.470  1.00 35.82           C  
ATOM   1426  C   ASP   206     -34.325   0.809  41.811  1.00 32.28           C  
ATOM   1427  O   ASP   206     -34.361   0.864  40.607  1.00 31.31           O  
ATOM   1428  CB  ASP   206     -35.078  -1.551  41.596  1.00 38.60           C  
ATOM   1429  CG  ASP   206     -36.537  -1.153  41.345  1.00 40.47           C  
ATOM   1430  OD1 ASP   206     -36.912   0.028  41.591  1.00 39.42           O  
ATOM   1431  OD2 ASP   206     -37.295  -2.043  40.861  1.00 42.49           O  
ATOM   1432  N   ASN   207     -34.223   1.891  42.572  1.00 31.67           N  
ATOM   1433  CA  ASN   207     -34.119   3.245  41.978  1.00 30.34           C  
ATOM   1434  C   ASN   207     -32.881   3.443  41.059  1.00 32.22           C  
ATOM   1435  O   ASN   207     -32.851   4.328  40.140  1.00 32.13           O  
ATOM   1436  CB  ASN   207     -34.022   4.313  43.076  1.00 29.95           C  
ATOM   1437  CG  ASN   207     -35.200   4.302  44.057  1.00 28.77           C  
ATOM   1438  OD1 ASN   207     -35.559   3.275  44.609  1.00 29.54           O  
ATOM   1439  ND2 ASN   207     -35.755   5.465  44.307  1.00 27.36           N  
ATOM   1440  N   TRP   208     -31.817   2.694  41.364  1.00 32.69           N  
ATOM   1441  CA  TRP   208     -30.556   2.768  40.603  1.00 31.91           C  
ATOM   1442  C   TRP   208     -30.776   2.359  39.170  1.00 32.17           C  
ATOM   1443  O   TRP   208     -30.167   2.961  38.311  1.00 31.13           O  
ATOM   1444  CB  TRP   208     -29.448   1.923  41.247  1.00 32.15           C  
ATOM   1445  CG  TRP   208     -29.846   0.532  41.554  1.00 32.23           C  
ATOM   1446  CD1 TRP   208     -30.470   0.092  42.688  1.00 32.29           C  
ATOM   1447  CD2 TRP   208     -29.671  -0.626  40.718  1.00 32.46           C  
ATOM   1448  NE1 TRP   208     -30.690  -1.258  42.612  1.00 32.16           N  
ATOM   1449  CE2 TRP   208     -30.200  -1.727  41.418  1.00 32.61           C  
ATOM   1450  CE3 TRP   208     -29.107  -0.836  39.450  1.00 32.63           C  
ATOM   1451  CZ2 TRP   208     -30.182  -3.037  40.884  1.00 32.23           C  
ATOM   1452  CZ3 TRP   208     -29.099  -2.105  38.924  1.00 31.68           C  
ATOM   1453  CH2 TRP   208     -29.614  -3.200  39.643  1.00 31.68           C  
ATOM   1454  N   LYS   209     -31.621   1.339  38.918  1.00 33.06           N  
ATOM   1455  CA  LYS   209     -32.004   0.923  37.544  1.00 33.39           C  
ATOM   1456  C   LYS   209     -32.502   2.114  36.713  1.00 34.33           C  
ATOM   1457  O   LYS   209     -32.221   2.198  35.520  1.00 37.07           O  
ATOM   1458  CB  LYS   209     -33.085  -0.168  37.508  1.00 34.04           C  
ATOM   1459  CG  LYS   209     -32.646  -1.527  38.040  1.00 35.43           C  
ATOM   1460  CD  LYS   209     -33.611  -2.691  37.657  1.00 35.19           C  
ATOM   1461  CE  LYS   209     -33.276  -3.967  38.447  1.00 36.00           C  
ATOM   1462  NZ  LYS   209     -33.853  -5.242  37.838  1.00 36.60           N  
ATOM   1463  N   ASN   210     -33.244   3.027  37.304  1.00 34.51           N  
ATOM   1464  CA  ASN   210     -33.677   4.231  36.551  1.00 36.49           C  
ATOM   1465  C   ASN   210     -32.501   5.192  36.240  1.00 35.37           C  
ATOM   1466  O   ASN   210     -32.445   5.812  35.160  1.00 36.42           O  
ATOM   1467  CB  ASN   210     -34.839   4.942  37.274  1.00 37.19           C  
ATOM   1468  CG  ASN   210     -36.022   3.995  37.529  1.00 38.90           C  
ATOM   1469  OD1 ASN   210     -36.385   3.209  36.654  1.00 40.42           O  
ATOM   1470  ND2 ASN   210     -36.583   4.026  38.745  1.00 38.09           N  
ATOM   1471  N   ILE   211     -31.552   5.321  37.164  1.00 34.75           N  
ATOM   1472  CA  ILE   211     -30.402   6.196  36.933  1.00 34.72           C  
ATOM   1473  C   ILE   211     -29.506   5.618  35.844  1.00 33.48           C  
ATOM   1474  O   ILE   211     -28.947   6.352  35.002  1.00 29.16           O  
ATOM   1475  CB  ILE   211     -29.609   6.469  38.249  1.00 36.00           C  
ATOM   1476  CG1 ILE   211     -30.486   7.263  39.223  1.00 35.99           C  
ATOM   1477  CG2 ILE   211     -28.321   7.298  37.985  1.00 34.49           C  
ATOM   1478  CD1 ILE   211     -29.809   7.654  40.520  1.00 35.96           C  
ATOM   1479  N   LEU   212     -29.411   4.290  35.858  1.00 32.77           N  
ATOM   1480  CA  LEU   212     -28.597   3.560  34.949  1.00 33.23           C  
ATOM   1481  C   LEU   212     -29.152   3.659  33.546  1.00 34.91           C  
ATOM   1482  O   LEU   212     -28.404   3.863  32.587  1.00 34.20           O  
ATOM   1483  CB  LEU   212     -28.563   2.076  35.381  1.00 33.12           C  
ATOM   1484  CG  LEU   212     -27.602   1.182  34.612  1.00 33.09           C  
ATOM   1485  CD1 LEU   212     -26.133   1.627  34.822  1.00 31.85           C  
ATOM   1486  CD2 LEU   212     -27.801  -0.229  35.052  1.00 32.08           C  
ATOM   1487  N   LEU   213     -30.463   3.460  33.419  1.00 36.65           N  
ATOM   1488  CA  LEU   213     -31.106   3.532  32.112  1.00 37.15           C  
ATOM   1489  C   LEU   213     -30.851   4.917  31.550  1.00 36.30           C  
ATOM   1490  O   LEU   213     -30.586   5.053  30.373  1.00 36.77           O  
ATOM   1491  CB  LEU   213     -32.620   3.252  32.192  1.00 37.58           C  
ATOM   1492  CG  LEU   213     -33.371   3.435  30.867  1.00 36.80           C  
ATOM   1493  CD1 LEU   213     -32.675   2.648  29.761  1.00 36.19           C  
ATOM   1494  CD2 LEU   213     -34.842   3.031  31.016  1.00 36.87           C  
ATOM   1495  N   GLY   214     -30.914   5.934  32.394  1.00 36.15           N  
ATOM   1496  CA  GLY   214     -30.612   7.314  31.963  1.00 36.31           C  
ATOM   1497  C   GLY   214     -29.201   7.391  31.377  1.00 36.76           C  
ATOM   1498  O   GLY   214     -29.002   7.906  30.282  1.00 34.16           O  
ATOM   1499  N   LYS   215     -28.225   6.833  32.095  1.00 38.08           N  
ATOM   1500  CA  LYS   215     -26.839   6.832  31.623  1.00 39.02           C  
ATOM   1501  C   LYS   215     -26.714   6.102  30.291  1.00 38.67           C  
ATOM   1502  O   LYS   215     -26.045   6.582  29.393  1.00 40.02           O  
ATOM   1503  CB  LYS   215     -25.895   6.169  32.645  1.00 38.95           C  
ATOM   1504  CG  LYS   215     -24.460   6.012  32.121  1.00 40.11           C  
ATOM   1505  CD  LYS   215     -23.490   5.230  33.046  1.00 41.64           C  
ATOM   1506  CE  LYS   215     -23.872   3.752  33.214  1.00 42.33           C  
ATOM   1507  NZ  LYS   215     -24.217   3.083  31.907  1.00 42.80           N  
ATOM   1508  N   TRP   216     -27.320   4.911  30.213  1.00 38.44           N  
ATOM   1509  CA  TRP   216     -27.328   4.055  29.010  1.00 37.73           C  
ATOM   1510  C   TRP   216     -27.931   4.760  27.802  1.00 36.69           C  
ATOM   1511  O   TRP   216     -27.353   4.712  26.709  1.00 37.44           O  
ATOM   1512  CB  TRP   216     -28.109   2.800  29.321  1.00 37.33           C  
ATOM   1513  CG  TRP   216     -28.319   1.837  28.235  1.00 37.88           C  
ATOM   1514  CD1 TRP   216     -29.384   1.799  27.373  1.00 37.86           C  
ATOM   1515  CD2 TRP   216     -27.541   0.663  27.956  1.00 37.86           C  
ATOM   1516  NE1 TRP   216     -29.269   0.727  26.545  1.00 37.80           N  
ATOM   1517  CE2 TRP   216     -28.155   0.008  26.880  1.00 37.05           C  
ATOM   1518  CE3 TRP   216     -26.355   0.134  28.475  1.00 37.81           C  
ATOM   1519  CZ2 TRP   216     -27.627  -1.142  26.312  1.00 37.75           C  
ATOM   1520  CZ3 TRP   216     -25.836  -1.013  27.910  1.00 37.54           C  
ATOM   1521  CH2 TRP   216     -26.476  -1.650  26.857  1.00 37.69           C  
ATOM   1522  N   SER   217     -29.079   5.405  28.011  1.00 34.69           N  
ATOM   1523  CA  SER   217     -29.758   6.195  26.964  1.00 34.80           C  
ATOM   1524  C   SER   217     -28.914   7.353  26.456  1.00 34.06           C  
ATOM   1525  O   SER   217     -28.999   7.724  25.289  1.00 34.05           O  
ATOM   1526  CB  SER   217     -31.099   6.759  27.465  1.00 34.33           C  
ATOM   1527  OG  SER   217     -32.049   5.728  27.666  1.00 34.19           O  
ATOM   1528  N   GLY   218     -28.151   7.959  27.359  1.00 34.17           N  
ATOM   1529  CA  GLY   218     -27.270   9.076  27.018  1.00 33.98           C  
ATOM   1530  C   GLY   218     -26.109   8.619  26.147  1.00 33.23           C  
ATOM   1531  O   GLY   218     -25.666   9.331  25.281  1.00 32.30           O  
ATOM   1532  N   TRP   219     -25.619   7.404  26.391  1.00 33.89           N  
ATOM   1533  CA  TRP   219     -24.562   6.807  25.584  1.00 32.51           C  
ATOM   1534  C   TRP   219     -25.056   6.479  24.156  1.00 31.46           C  
ATOM   1535  O   TRP   219     -24.291   6.485  23.200  1.00 29.93           O  
ATOM   1536  CB  TRP   219     -24.075   5.544  26.315  1.00 34.90           C  
ATOM   1537  CG  TRP   219     -23.044   5.761  27.391  1.00 35.00           C  
ATOM   1538  CD1 TRP   219     -22.690   6.928  27.981  1.00 36.21           C  
ATOM   1539  CD2 TRP   219     -22.297   4.739  28.054  1.00 36.69           C  
ATOM   1540  NE1 TRP   219     -21.727   6.712  28.932  1.00 36.02           N  
ATOM   1541  CE2 TRP   219     -21.464   5.373  29.002  1.00 36.36           C  
ATOM   1542  CE3 TRP   219     -22.238   3.354  27.922  1.00 35.77           C  
ATOM   1543  CZ2 TRP   219     -20.568   4.665  29.819  1.00 36.18           C  
ATOM   1544  CZ3 TRP   219     -21.332   2.630  28.736  1.00 36.36           C  
ATOM   1545  CH2 TRP   219     -20.526   3.286  29.680  1.00 36.68           C  
ATOM   1546  N   ILE   220     -26.332   6.140  24.019  1.00 31.33           N  
ATOM   1547  CA  ILE   220     -26.941   5.905  22.713  1.00 31.05           C  
ATOM   1548  C   ILE   220     -27.082   7.237  21.940  1.00 33.15           C  
ATOM   1549  O   ILE   220     -26.722   7.330  20.755  1.00 32.49           O  
ATOM   1550  CB  ILE   220     -28.304   5.253  22.875  1.00 29.75           C  
ATOM   1551  CG1 ILE   220     -28.157   3.828  23.465  1.00 29.30           C  
ATOM   1552  CG2 ILE   220     -29.014   5.142  21.512  1.00 30.31           C  
ATOM   1553  CD1 ILE   220     -29.494   3.274  23.922  1.00 28.25           C  
ATOM   1554  N   GLU   221     -27.604   8.262  22.608  1.00 35.10           N  
ATOM   1555  CA  GLU   221     -27.741   9.611  21.989  1.00 35.33           C  
ATOM   1556  C   GLU   221     -26.379  10.186  21.502  1.00 36.09           C  
ATOM   1557  O   GLU   221     -26.283  10.752  20.409  1.00 37.21           O  
ATOM   1558  CB  GLU   221     -28.410  10.577  22.987  1.00 36.75           C  
ATOM   1559  CG  GLU   221     -28.923  11.952  22.398  1.00 38.27           C  
ATOM   1560  CD  GLU   221     -27.892  13.097  22.374  1.00 41.37           C  
ATOM   1561  OE1 GLU   221     -26.798  12.930  22.990  1.00 42.19           O  
ATOM   1562  OE2 GLU   221     -28.193  14.192  21.752  1.00 42.76           O  
ATOM   1563  N   GLN   222     -25.344  10.047  22.328  1.00 36.89           N  
ATOM   1564  CA  GLN   222     -23.983  10.545  22.027  1.00 36.28           C  
ATOM   1565  C   GLN   222     -23.212   9.642  21.077  1.00 34.50           C  
ATOM   1566  O   GLN   222     -22.091   9.950  20.718  1.00 31.88           O  
ATOM   1567  CB  GLN   222     -23.159  10.657  23.322  1.00 37.58           C  
ATOM   1568  CG  GLN   222     -23.716  11.611  24.368  1.00 39.28           C  
ATOM   1569  CD  GLN   222     -23.446  13.088  24.074  1.00 41.32           C  
ATOM   1570  OE1 GLN   222     -22.294  13.500  23.894  1.00 43.78           O  
ATOM   1571  NE2 GLN   222     -24.511  13.897  24.041  1.00 40.72           N  
ATOM   1572  N   ARG   223     -23.787   8.494  20.735  1.00 34.13           N  
ATOM   1573  CA  ARG   223     -23.179   7.523  19.831  1.00 33.61           C  
ATOM   1574  C   ARG   223     -21.917   6.873  20.400  1.00 34.35           C  
ATOM   1575  O   ARG   223     -20.949   6.632  19.654  1.00 35.88           O  
ATOM   1576  CB  ARG   223     -22.898   8.168  18.485  1.00 34.96           C  
ATOM   1577  CG  ARG   223     -22.824   7.244  17.284  1.00 35.66           C  
ATOM   1578  CD  ARG   223     -22.314   8.071  16.136  1.00 36.64           C  
ATOM   1579  NE  ARG   223     -22.460   7.421  14.851  1.00 36.77           N  
ATOM   1580  CZ  ARG   223     -22.173   8.005  13.695  1.00 37.14           C  
ATOM   1581  NH1 ARG   223     -21.712   9.244  13.648  1.00 37.54           N  
ATOM   1582  NH2 ARG   223     -22.356   7.338  12.565  1.00 38.08           N  
ATOM   1583  N   ILE   224     -21.926   6.592  21.712  1.00 32.16           N  
ATOM   1584  CA  ILE   224     -20.824   5.884  22.403  1.00 30.24           C  
ATOM   1585  C   ILE   224     -21.037   4.388  22.261  1.00 29.99           C  
ATOM   1586  O   ILE   224     -20.081   3.600  22.134  1.00 26.56           O  
ATOM   1587  CB  ILE   224     -20.757   6.269  23.908  1.00 29.79           C  
ATOM   1588  CG1 ILE   224     -20.396   7.761  24.076  1.00 29.73           C  
ATOM   1589  CG2 ILE   224     -19.763   5.447  24.614  1.00 30.17           C  
ATOM   1590  CD1 ILE   224     -20.563   8.314  25.494  1.00 29.42           C  
ATOM   1591  N   ILE   225     -22.312   3.986  22.300  1.00 30.18           N  
ATOM   1592  CA  ILE   225     -22.678   2.590  22.089  1.00 28.73           C  
ATOM   1593  C   ILE   225     -23.656   2.595  20.934  1.00 30.68           C  
ATOM   1594  O   ILE   225     -24.386   3.580  20.726  1.00 30.26           O  
ATOM   1595  CB  ILE   225     -23.200   1.918  23.379  1.00 28.42           C  
ATOM   1596  CG1 ILE   225     -24.620   2.348  23.737  1.00 26.99           C  
ATOM   1597  CG2 ILE   225     -22.217   2.217  24.514  1.00 29.60           C  
ATOM   1598  CD1 ILE   225     -25.110   1.976  25.113  1.00 26.01           C  
ATOM   1599  N   ILE   226     -23.642   1.506  20.155  1.00 30.62           N  
ATOM   1600  CA  ILE   226     -24.499   1.394  18.976  1.00 30.56           C  
ATOM   1601  C   ILE   226     -25.110   0.009  18.972  1.00 29.99           C  
ATOM   1602  O   ILE   226     -24.574  -0.883  19.606  1.00 28.78           O  
ATOM   1603  CB  ILE   226     -23.740   1.708  17.596  1.00 30.62           C  
ATOM   1604  CG1 ILE   226     -22.567   0.765  17.340  1.00 30.74           C  
ATOM   1605  CG2 ILE   226     -23.274   3.214  17.504  1.00 30.74           C  
ATOM   1606  CD1 ILE   226     -21.914   0.946  15.918  1.00 30.80           C  
ATOM   1607  N   PRO   227     -26.270  -0.161  18.317  1.00 30.20           N  
ATOM   1608  CA  PRO   227     -26.836  -1.526  18.246  1.00 30.62           C  
ATOM   1609  C   PRO   227     -25.852  -2.518  17.629  1.00 33.79           C  
ATOM   1610  O   PRO   227     -25.105  -2.175  16.706  1.00 32.59           O  
ATOM   1611  CB  PRO   227     -28.079  -1.360  17.373  1.00 29.34           C  
ATOM   1612  CG  PRO   227     -28.421   0.098  17.460  1.00 29.26           C  
ATOM   1613  CD  PRO   227     -27.145   0.845  17.691  1.00 29.25           C  
ATOM   1614  N   SER   228     -25.827  -3.722  18.183  1.00 37.62           N  
ATOM   1615  CA  SER   228     -24.979  -4.781  17.679  1.00 40.86           C  
ATOM   1616  C   SER   228     -25.762  -5.611  16.664  1.00 43.11           C  
ATOM   1617  O   SER   228     -26.490  -6.533  17.032  1.00 44.20           O  
ATOM   1618  CB  SER   228     -24.474  -5.666  18.812  1.00 40.76           C  
ATOM   1619  OG  SER   228     -23.551  -6.594  18.271  1.00 41.97           O  
ATOM   1620  N   LEU   229     -25.572  -5.292  15.386  1.00 45.83           N  
ATOM   1621  CA  LEU   229     -26.333  -5.890  14.290  1.00 47.76           C  
ATOM   1622  C   LEU   229     -25.604  -7.011  13.560  1.00 49.40           C  
ATOM   1623  O   LEU   229     -24.593  -6.779  12.910  1.00 49.60           O  
ATOM   1624  CB  LEU   229     -26.711  -4.786  13.289  1.00 47.66           C  
ATOM   1625  CG  LEU   229     -27.607  -3.690  13.883  1.00 47.20           C  
ATOM   1626  CD1 LEU   229     -27.754  -2.509  12.947  1.00 46.75           C  
ATOM   1627  CD2 LEU   229     -28.965  -4.279  14.249  1.00 47.53           C  
ATOM   1628  N   SER   230     -26.155  -8.220  13.659  1.00 51.73           N  
ATOM   1629  CA  SER   230     -25.586  -9.409  13.031  1.00 52.88           C  
ATOM   1630  C   SER   230     -26.236  -9.706  11.680  1.00 53.74           C  
ATOM   1631  O   SER   230     -25.565  -9.657  10.646  1.00 54.94           O  
ATOM   1632  CB  SER   230     -25.730 -10.610  13.970  1.00 52.98           C  
ATOM   1633  OG  SER   230     -25.042 -10.362  15.191  1.00 53.17           O  
END
