
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  311 ( 2511),  selected  311 , name 2rcc_C
# Molecule2: number of CA atoms  272 ( 2246),  selected  272 , name T0444.pdb
# PARAMETERS: 2rcc_C.T0444.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q     3_C      -       -           -
LGA    L     4_C      N      34           #
LGA    Q     5_C      E      35           -
LGA    K     6_C      -       -           -
LGA    R     7_C      -       -           -
LGA    K     8_C      -       -           -
LGA    I     9_C      -       -           -
LGA    Y    10_C      -       -           -
LGA    D    11_C      -       -           -
LGA    T    12_C      -       -           -
LGA    T    13_C      -       -           -
LGA    A    14_C      -       -           -
LGA    S    15_C      -       -           -
LGA    N    16_C      -       -           -
LGA    A    17_C      -       -           -
LGA    S    18_C      -       -           -
LGA    T    19_C      -       -           -
LGA    G    20_C      E      36          4.624
LGA    I    21_C      P      37          3.835
LGA    L    22_C      L      38          4.344
LGA    N    23_C      L      39          4.097
LGA    G    24_C      R      40          1.299
LGA    K    25_C      K      41          3.115
LGA    S    26_C      -       -           -
LGA    S    27_C      -       -           -
LGA    N    28_C      -       -           -
LGA    V    29_C      -       -           -
LGA    L    30_C      V      47          4.670
LGA    N    31_C      I      48          1.564
LGA    W    32_C      F      49          4.160
LGA    D    33_C      P      50          2.918
LGA    D    34_C      -       -           -
LGA    V    35_C      I      51          2.947
LGA    R    36_C      Q      52          2.886
LGA    F    37_C      Y      53          1.529
LGA    S    38_C      P      54          1.615
LGA    W    39_C      D      55          0.519
LGA    A    40_C      I      56          2.063
LGA    Y    41_C      W      57          2.065
LGA    P    42_C      K      58          1.500
LGA    L    43_C      M      59          1.082
LGA    Y    44_C      Y      60          1.386
LGA    K    45_C      K      61          1.429
LGA    N    46_C      Q      62          0.974
LGA    X    47_C      A      63          0.744
LGA    L    48_C      Q      64          0.694
LGA    A    49_C      A      65          0.904
LGA    N    50_C      S      66          0.552
LGA    F    51_C      F      67          1.096
LGA    W    52_C      W      68          1.481
LGA    T    53_C      T      69          1.434
LGA    P    54_C      A      70          1.650
LGA    F    55_C      E      71          0.860
LGA    E    56_C      E      72          1.784
LGA    I    57_C      V      73          1.550
LGA    N    58_C      D      74          1.837
LGA    X    59_C      L      75          1.268
LGA    S    60_C      S      76          2.242
LGA    H    61_C      K      77          1.986
LGA    D    62_C      D      78          1.336
LGA    A    63_C      L      79          2.130
LGA    K    64_C      P      80          2.793
LGA    Q    65_C      H      81          2.278
LGA    F    66_C      W      82          1.632
LGA    P    67_C      N      83          3.055
LGA    T    68_C      K      84          2.601
LGA    L    69_C      L      85          0.880
LGA    T    70_C      K      86          1.369
LGA    E    71_C      A      87          1.749
LGA    T    72_C      D      88          1.889
LGA    E    73_C      E      89          0.944
LGA    Q    74_C      K      90          0.814
LGA    E    75_C      Y      91          1.243
LGA    A    76_C      F      92          1.185
LGA    F    77_C      I      93          0.860
LGA    K    78_C      S      94          1.654
LGA    K    79_C      H      95          1.679
LGA    I    80_C      I      96          0.974
LGA    I    81_C      L      97          1.332
LGA    G    82_C      A      98          1.991
LGA    L    83_C      F      99          1.936
LGA    L    84_C      F     100          1.675
LGA    A    85_C      A     101          1.959
LGA    F    86_C      A     102          2.910
LGA    L    87_C      S     103          2.854
LGA    D    88_C      -       -           -
LGA    S    89_C      -       -           -
LGA    V    90_C      -       -           -
LGA    Q    91_C      -       -           -
LGA    T    92_C      -       -           -
LGA    D    93_C      N     110          1.957
LGA    Y    94_C      L     111          1.174
LGA    S    95_C      V     112          0.679
LGA    X    96_C      E     113          1.650
LGA    R    97_C      R     114          1.799
LGA    A    98_C      F     115          1.149
LGA    A    99_C      S     116          1.303
LGA    E   100_C      Q     117          1.168
LGA    Y   101_C      E     118          1.422
LGA    L   102_C      V     119          0.916
LGA    T   103_C      Q     120          1.707
LGA    D   104_C      V     121          1.243
LGA    S   105_C      P     122          1.584
LGA    S   106_C      E     123          1.492
LGA    L   107_C      A     124          0.983
LGA    A   108_C      R     125          1.503
LGA    A   109_C      C     126          1.663
LGA    L   110_C      F     127          1.055
LGA    X   111_C      Y     128          0.852
LGA    S   112_C      G     129          1.019
LGA    V   113_C      F     130          0.886
LGA    L   114_C      Q     131          1.021
LGA    S   115_C      I     132          1.277
LGA    F   116_C      L     133          0.943
LGA    Q   117_C      I     134          1.048
LGA    E   118_C      E     135          0.848
LGA    V   119_C      N     136          0.932
LGA    V   120_C      V     137          0.721
LGA    H   121_C      H     138          0.766
LGA    N   122_C      S     139          1.458
LGA    Q   123_C      E     140          1.412
LGA    S   124_C      M     141          0.987
LGA    Y   125_C      Y     142          0.668
LGA    S   126_C      S     143          0.536
LGA    Y   127_C      L     144          1.049
LGA    V   128_C      L     145          0.753
LGA    L   129_C      I     146          0.646
LGA    S   130_C      D     147          1.095
LGA    S   131_C      T     148          1.099
LGA    L   132_C      Y     149          1.046
LGA    V   133_C      I     150          0.362
LGA    P   134_C      R     151          2.822
LGA    -       -      D     152           -
LGA    K   135_C      P     153          2.212
LGA    A   136_C      K     154          2.137
LGA    T   137_C      K     155          2.856
LGA    Q   138_C      R     156          2.905
LGA    D   139_C      E     157          3.306
LGA    E   140_C      F     158          3.728
LGA    I   141_C      L     159          3.774
LGA    F   142_C      F     160          3.542
LGA    E   143_C      N     161          3.123
LGA    Y   144_C      A     162          3.858
LGA    W   145_C      I     163          4.043
LGA    K   146_C      E     164          2.152
LGA    H   147_C      T     165          1.111
LGA    D   148_C      M     166          1.593
LGA    D   149_C      P     167          3.113
LGA    V   150_C      Y     168          4.292
LGA    L   151_C      V     169          3.638
LGA    K   152_C      K     170          2.228
LGA    E   153_C      K     171          2.139
LGA    R   154_C      K     172          3.349
LGA    N   155_C      A     173          3.699
LGA    E   156_C      D     174          2.769
LGA    F   157_C      W     175          1.865
LGA    I   158_C      A     176          3.091
LGA    I   159_C      L     177          4.254
LGA    D   160_C      R     178          3.493
LGA    G   161_C      W     179          2.743
LGA    Y   162_C      I     180          3.188
LGA    E   163_C      A     181          2.350
LGA    K   164_C      D     182          2.708
LGA    F   165_C      -       -           -
LGA    V   166_C      -       -           -
LGA    D   167_C      -       -           -
LGA    N   168_C      R     183          3.262
LGA    P   169_C      K     184           -
LGA    T   170_C      -       -           -
LGA    P   171_C      -       -           -
LGA    K   172_C      S     185          5.330
LGA    T   173_C      T     186          2.015
LGA    F   174_C      F     187          2.043
LGA    L   175_C      G     188          1.691
LGA    E   176_C      E     189          1.320
LGA    S   177_C      R     190          1.703
LGA    I   178_C      V     191          1.740
LGA    V   179_C      V     192          1.586
LGA    Y   180_C      A     193          1.710
LGA    D   181_C      F     194          1.620
LGA    V   182_C      A     195          1.340
LGA    I   183_C      A     196          1.446
LGA    L   184_C      V     197          1.376
LGA    E   185_C      E     198          0.873
LGA    G   186_C      G     199          0.314
LGA    L   187_C      V     200          1.255
LGA    N   188_C      F     201          1.504
LGA    F   189_C      F     202          2.715
LGA    Y   190_C      S     203          2.090
LGA    S   191_C      G     204          1.485
LGA    G   192_C      S     205          1.297
LGA    F   193_C      F     206          0.725
LGA    A   194_C      A     207          1.179
LGA    F   195_C      A     208          1.211
LGA    F   196_C      I     209          0.970
LGA    Y   197_C      F     210          1.101
LGA    N   198_C      W     211          1.076
LGA    L   199_C      L     212          1.082
LGA    A   200_C      K     213          1.387
LGA    R   201_C      K     214          1.158
LGA    N   202_C      R     215          0.630
LGA    Q   203_C      G     216          1.283
LGA    K   204_C      L     217          0.999
LGA    X   205_C      M     218          1.004
LGA    V   206_C      P     219          1.700
LGA    S   207_C      G     220          1.418
LGA    T   208_C      L     221          0.586
LGA    S   209_C      T     222          0.432
LGA    T   210_C      F     223          0.339
LGA    X   211_C      S     224          0.286
LGA    I   212_C      N     225          0.636
LGA    N   213_C      E     226          0.202
LGA    Y   214_C      L     227          0.410
LGA    I   215_C      I     228          0.547
LGA    N   216_C      S     229          1.328
LGA    R   217_C      R     230          1.433
LGA    D   218_C      D     231          1.057
LGA    E   219_C      E     232          1.220
LGA    Q   220_C      G     233          1.418
LGA    L   221_C      L     234          0.967
LGA    H   222_C      H     235          0.495
LGA    V   223_C      C     236          0.965
LGA    Y   224_C      D     237          1.172
LGA    L   225_C      F     238          0.724
LGA    F   226_C      A     239          0.319
LGA    T   227_C      C     240          0.549
LGA    N   228_C      L     241          0.810
LGA    I   229_C      M     242          0.794
LGA    F   230_C      F     243          1.295
LGA    K   231_C      Q     244          1.753
LGA    E   232_C      Y     245          0.971
LGA    L   233_C      L     246          1.420
LGA    L   234_C      V     247          3.709
LGA    V   235_C      -       -           -
LGA    E   236_C      -       -           -
LGA    F   237_C      N     248          2.717
LGA    P   238_C      -       -           -
LGA    E   239_C      -       -           -
LGA    L   240_C      -       -           -
LGA    N   241_C      K     249          4.108
LGA    T   242_C      P     250          5.581
LGA    E   243_C      -       -           -
LGA    E   244_C      -       -           -
LGA    T   245_C      S     251          1.749
LGA    K   246_C      E     252          0.796
LGA    T   247_C      E     253          0.565
LGA    F   248_C      R     254          1.049
LGA    V   249_C      V     255          1.025
LGA    K   250_C      R     256          0.963
LGA    T   251_C      E     257          1.858
LGA    T   252_C      I     258          1.852
LGA    L   253_C      I     259          1.379
LGA    X   254_C      V     260          1.282
LGA    K   255_C      D     261          1.490
LGA    A   256_C      A     262          1.014
LGA    A   257_C      V     263          0.861
LGA    D   258_C      K     264          1.466
LGA    L   259_C      I     265          1.291
LGA    E   260_C      E     266          0.989
LGA    K   261_C      Q     267          0.979
LGA    D   262_C      E     268          0.752
LGA    W   263_C      F     269          0.406
LGA    F   264_C      L     270          0.573
LGA    R   265_C      T     271          1.209
LGA    Y   266_C      E     272          2.916
LGA    -       -      A     273           -
LGA    I   267_C      L     274          0.766
LGA    I   268_C      P     275          2.036
LGA    G   269_C      V     276          4.251
LGA    D   270_C      G     277          2.711
LGA    K   271_C      L     278          3.278
LGA    I   272_C      I     279          2.502
LGA    P   273_C      G     280          2.224
LGA    G   274_C      -       -           -
LGA    I   275_C      M     281          2.069
LGA    N   276_C      N     282          0.772
LGA    P   277_C      C     283          0.920
LGA    E   278_C      I     284          1.380
LGA    D   279_C      L     285          1.019
LGA    X   280_C      M     286          0.759
LGA    E   281_C      K     287          0.965
LGA    T   282_C      Q     288          0.814
LGA    Y   283_C      Y     289          0.474
LGA    I   284_C      I     290          0.549
LGA    S   285_C      E     291          0.528
LGA    F   286_C      F     292          0.289
LGA    I   287_C      V     293          0.330
LGA    A   288_C      A     294          0.436
LGA    N   289_C      D     295          0.242
LGA    K   290_C      R     296          0.484
LGA    R   291_C      L     297          0.720
LGA    A   292_C      L     298          0.587
LGA    V   293_C      V     299          0.761
LGA    Q   294_C      E     300          0.912
LGA    L   295_C      L     301          1.127
LGA    G   296_C      G     302          1.233
LGA    X   297_C      F     303          2.050
LGA    E   298_C      S     304          2.766
LGA    K   299_C      K     305          2.109
LGA    P   300_C      V     306          2.305
LGA    Y   301_C      F     307          1.123
LGA    P   302_C      Q     308          3.097
LGA    E   303_C      -       -           -
LGA    I   304_C      A     309          1.893
LGA    K   305_C      -       -           -
LGA    H   306_C      E     310          2.251
LGA    N   307_C      N     311          1.234
LGA    P   308_C      P     312          1.085
LGA    X   309_C      F     313          0.750
LGA    K   310_C      D     314          2.364
LGA    W   311_C      F     315          1.413
LGA    I   312_C      M     316          1.959
LGA    R   313_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  311  272    5.0    267    1.95    20.97     86.134    13.044

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.537666 * X  +  -0.841633 * Y  +   0.050691 * Z  +  69.620300
  Y_new =   0.206056 * X  +   0.189458 * Y  +   0.960024 * Z  +  25.704575
  Z_new =  -0.817592 * X  +  -0.505727 * Y  +   0.275289 * Z  + -189.240967 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.072307    2.069286  [ DEG:   -61.4387    118.5613 ]
  Theta =   0.957216    2.184376  [ DEG:    54.8444    125.1555 ]
  Phi   =   0.365977   -2.775616  [ DEG:    20.9689   -159.0311 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rcc_C                                        
REMARK     2: T0444.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rcc_C.T0444.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  311  272   5.0  267   1.95   20.97  86.134
REMARK  ---------------------------------------------------------- 
MOLECULE 2rcc_C
HEADER    OXIDOREDUCTASE                          19-SEP-07   2RCC              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE CLASS I RIBONUCLEOTIDE                  
TITLE    2 REDUCTASE (NP_241368.1) FROM BACILLUS HALODURANS AT 1.90 A           
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIBONUCLEOSIDE-DIPHOSPHATE REDUCTASE SUBUNIT               
COMPND   3 BETA;                                                                
COMPND   4 CHAIN: A, B, C;                                                      
COMPND   5 SYNONYM: RIBONUCLEOTIDE REDUCTASE SMALL SUBUNIT;                     
COMPND   6 EC: 1.17.4.1;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS C-125;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C-125, DSM 18197, FERM 7344, JCM 9153;                       
SOURCE   5 ATCC: BAA-125;                                                       
SOURCE   6 GENE: NP_241368.1, NRDB, BH0502;                                     
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_241368.1, PUTATIVE CLASS I RIBONUCLEOTIDE REDUCTASE,               
KEYWDS   2 RIBONUCLEOTIDE REDUCTASE, SMALL CHAIN, STRUCTURAL GENOMICS,          
KEYWDS   3 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   4 STRUCTURE INITIATIVE, PSI-2, DNA REPLICATION, IRON, METAL-           
KEYWDS   5 BINDING, OXIDOREDUCTASE                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   02-OCT-07 2RCC    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE CLASS I                        
JRNL        TITL 2 RIBONUCLEOTIDE REDUCTASE (NP_241368.1) FROM                  
JRNL        TITL 3 BACILLUS HALODURANS AT 1.90 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2RCC A    1   345  UNP    Q9KFH7   RIR2_BACHD       1    345             
DBREF  2RCC B    1   345  UNP    Q9KFH7   RIR2_BACHD       1    345             
DBREF  2RCC C    1   345  UNP    Q9KFH7   RIR2_BACHD       1    345             
SEQRES   1 A  346  GLY MSE GLU GLN LEU GLN LYS ARG LYS ILE TYR ASP THR          
SEQRES   2 A  346  THR ALA SER ASN ALA SER THR GLY ILE LEU ASN GLY LYS          
SEQRES   3 A  346  SER SER ASN VAL LEU ASN TRP ASP ASP VAL ARG PHE SER          
SEQRES   4 A  346  TRP ALA TYR PRO LEU TYR LYS ASN MSE LEU ALA ASN PHE          
SEQRES   5 A  346  TRP THR PRO PHE GLU ILE ASN MSE SER HIS ASP ALA LYS          
SEQRES   6 A  346  GLN PHE PRO THR LEU THR GLU THR GLU GLN GLU ALA PHE          
SEQRES   7 A  346  LYS LYS ILE ILE GLY LEU LEU ALA PHE LEU ASP SER VAL          
SEQRES   8 A  346  GLN THR ASP TYR SER MSE ARG ALA ALA GLU TYR LEU THR          
SEQRES   9 A  346  ASP SER SER LEU ALA ALA LEU MSE SER VAL LEU SER PHE          
SEQRES  10 A  346  GLN GLU VAL VAL HIS ASN GLN SER TYR SER TYR VAL LEU          
SEQRES  11 A  346  SER SER LEU VAL PRO LYS ALA THR GLN ASP GLU ILE PHE          
SEQRES  12 A  346  GLU TYR TRP LYS HIS ASP ASP VAL LEU LYS GLU ARG ASN          
SEQRES  13 A  346  GLU PHE ILE ILE ASP GLY TYR GLU LYS PHE VAL ASP ASN          
SEQRES  14 A  346  PRO THR PRO LYS THR PHE LEU GLU SER ILE VAL TYR ASP          
SEQRES  15 A  346  VAL ILE LEU GLU GLY LEU ASN PHE TYR SER GLY PHE ALA          
SEQRES  16 A  346  PHE PHE TYR ASN LEU ALA ARG ASN GLN LYS MSE VAL SER          
SEQRES  17 A  346  THR SER THR MSE ILE ASN TYR ILE ASN ARG ASP GLU GLN          
SEQRES  18 A  346  LEU HIS VAL TYR LEU PHE THR ASN ILE PHE LYS GLU LEU          
SEQRES  19 A  346  LEU VAL GLU PHE PRO GLU LEU ASN THR GLU GLU THR LYS          
SEQRES  20 A  346  THR PHE VAL LYS THR THR LEU MSE LYS ALA ALA ASP LEU          
SEQRES  21 A  346  GLU LYS ASP TRP PHE ARG TYR ILE ILE GLY ASP LYS ILE          
SEQRES  22 A  346  PRO GLY ILE ASN PRO GLU ASP MSE GLU THR TYR ILE SER          
SEQRES  23 A  346  PHE ILE ALA ASN LYS ARG ALA VAL GLN LEU GLY MSE GLU          
SEQRES  24 A  346  LYS PRO TYR PRO GLU ILE LYS HIS ASN PRO MSE LYS TRP          
SEQRES  25 A  346  ILE ARG ALA TYR GLU ASP VAL ASN SER GLY LYS SER ASP          
SEQRES  26 A  346  PHE PHE GLU GLN LYS SER ARG GLN TYR ALA LYS VAL SER          
SEQRES  27 A  346  ALA ASP ASN GLY PHE ASP GLU LEU                              
SEQRES   1 B  346  GLY MSE GLU GLN LEU GLN LYS ARG LYS ILE TYR ASP THR          
SEQRES   2 B  346  THR ALA SER ASN ALA SER THR GLY ILE LEU ASN GLY LYS          
SEQRES   3 B  346  SER SER ASN VAL LEU ASN TRP ASP ASP VAL ARG PHE SER          
SEQRES   4 B  346  TRP ALA TYR PRO LEU TYR LYS ASN MSE LEU ALA ASN PHE          
SEQRES   5 B  346  TRP THR PRO PHE GLU ILE ASN MSE SER HIS ASP ALA LYS          
SEQRES   6 B  346  GLN PHE PRO THR LEU THR GLU THR GLU GLN GLU ALA PHE          
SEQRES   7 B  346  LYS LYS ILE ILE GLY LEU LEU ALA PHE LEU ASP SER VAL          
SEQRES   8 B  346  GLN THR ASP TYR SER MSE ARG ALA ALA GLU TYR LEU THR          
SEQRES   9 B  346  ASP SER SER LEU ALA ALA LEU MSE SER VAL LEU SER PHE          
SEQRES  10 B  346  GLN GLU VAL VAL HIS ASN GLN SER TYR SER TYR VAL LEU          
SEQRES  11 B  346  SER SER LEU VAL PRO LYS ALA THR GLN ASP GLU ILE PHE          
SEQRES  12 B  346  GLU TYR TRP LYS HIS ASP ASP VAL LEU LYS GLU ARG ASN          
SEQRES  13 B  346  GLU PHE ILE ILE ASP GLY TYR GLU LYS PHE VAL ASP ASN          
SEQRES  14 B  346  PRO THR PRO LYS THR PHE LEU GLU SER ILE VAL TYR ASP          
SEQRES  15 B  346  VAL ILE LEU GLU GLY LEU ASN PHE TYR SER GLY PHE ALA          
SEQRES  16 B  346  PHE PHE TYR ASN LEU ALA ARG ASN GLN LYS MSE VAL SER          
SEQRES  17 B  346  THR SER THR MSE ILE ASN TYR ILE ASN ARG ASP GLU GLN          
SEQRES  18 B  346  LEU HIS VAL TYR LEU PHE THR ASN ILE PHE LYS GLU LEU          
SEQRES  19 B  346  LEU VAL GLU PHE PRO GLU LEU ASN THR GLU GLU THR LYS          
SEQRES  20 B  346  THR PHE VAL LYS THR THR LEU MSE LYS ALA ALA ASP LEU          
SEQRES  21 B  346  GLU LYS ASP TRP PHE ARG TYR ILE ILE GLY ASP LYS ILE          
SEQRES  22 B  346  PRO GLY ILE ASN PRO GLU ASP MSE GLU THR TYR ILE SER          
SEQRES  23 B  346  PHE ILE ALA ASN LYS ARG ALA VAL GLN LEU GLY MSE GLU          
SEQRES  24 B  346  LYS PRO TYR PRO GLU ILE LYS HIS ASN PRO MSE LYS TRP          
SEQRES  25 B  346  ILE ARG ALA TYR GLU ASP VAL ASN SER GLY LYS SER ASP          
SEQRES  26 B  346  PHE PHE GLU GLN LYS SER ARG GLN TYR ALA LYS VAL SER          
SEQRES  27 B  346  ALA ASP ASN GLY PHE ASP GLU LEU                              
SEQRES   1 C  346  GLY MSE GLU GLN LEU GLN LYS ARG LYS ILE TYR ASP THR          
SEQRES   2 C  346  THR ALA SER ASN ALA SER THR GLY ILE LEU ASN GLY LYS          
SEQRES   3 C  346  SER SER ASN VAL LEU ASN TRP ASP ASP VAL ARG PHE SER          
SEQRES   4 C  346  TRP ALA TYR PRO LEU TYR LYS ASN MSE LEU ALA ASN PHE          
SEQRES   5 C  346  TRP THR PRO PHE GLU ILE ASN MSE SER HIS ASP ALA LYS          
SEQRES   6 C  346  GLN PHE PRO THR LEU THR GLU THR GLU GLN GLU ALA PHE          
SEQRES   7 C  346  LYS LYS ILE ILE GLY LEU LEU ALA PHE LEU ASP SER VAL          
SEQRES   8 C  346  GLN THR ASP TYR SER MSE ARG ALA ALA GLU TYR LEU THR          
SEQRES   9 C  346  ASP SER SER LEU ALA ALA LEU MSE SER VAL LEU SER PHE          
SEQRES  10 C  346  GLN GLU VAL VAL HIS ASN GLN SER TYR SER TYR VAL LEU          
SEQRES  11 C  346  SER SER LEU VAL PRO LYS ALA THR GLN ASP GLU ILE PHE          
SEQRES  12 C  346  GLU TYR TRP LYS HIS ASP ASP VAL LEU LYS GLU ARG ASN          
SEQRES  13 C  346  GLU PHE ILE ILE ASP GLY TYR GLU LYS PHE VAL ASP ASN          
SEQRES  14 C  346  PRO THR PRO LYS THR PHE LEU GLU SER ILE VAL TYR ASP          
SEQRES  15 C  346  VAL ILE LEU GLU GLY LEU ASN PHE TYR SER GLY PHE ALA          
SEQRES  16 C  346  PHE PHE TYR ASN LEU ALA ARG ASN GLN LYS MSE VAL SER          
SEQRES  17 C  346  THR SER THR MSE ILE ASN TYR ILE ASN ARG ASP GLU GLN          
SEQRES  18 C  346  LEU HIS VAL TYR LEU PHE THR ASN ILE PHE LYS GLU LEU          
SEQRES  19 C  346  LEU VAL GLU PHE PRO GLU LEU ASN THR GLU GLU THR LYS          
SEQRES  20 C  346  THR PHE VAL LYS THR THR LEU MSE LYS ALA ALA ASP LEU          
SEQRES  21 C  346  GLU LYS ASP TRP PHE ARG TYR ILE ILE GLY ASP LYS ILE          
SEQRES  22 C  346  PRO GLY ILE ASN PRO GLU ASP MSE GLU THR TYR ILE SER          
SEQRES  23 C  346  PHE ILE ALA ASN LYS ARG ALA VAL GLN LEU GLY MSE GLU          
SEQRES  24 C  346  LYS PRO TYR PRO GLU ILE LYS HIS ASN PRO MSE LYS TRP          
SEQRES  25 C  346  ILE ARG ALA TYR GLU ASP VAL ASN SER GLY LYS SER ASP          
SEQRES  26 C  346  PHE PHE GLU GLN LYS SER ARG GLN TYR ALA LYS VAL SER          
SEQRES  27 C  346  ALA ASP ASN GLY PHE ASP GLU LEU                              
HET    MSE  A   1       8                                                       
HET    MSE  A  47       8                                                       
HET    MSE  A  59       8                                                       
HET    MSE  A  96       8                                                       
HET    MSE  A 111       8                                                       
HET    MSE  A 205       8                                                       
HET    MSE  A 211       8                                                       
HET    MSE  A 254       8                                                       
HET    MSE  A 280       8                                                       
HET    MSE  A 297      13                                                       
HET    MSE  A 309       8                                                       
HET    MSE  B  47       8                                                       
HET    MSE  B  59       8                                                       
HET    MSE  B  96       8                                                       
HET    MSE  B 111       8                                                       
HET    MSE  B 205       8                                                       
HET    MSE  B 211      13                                                       
HET    MSE  B 254       8                                                       
HET    MSE  B 280      13                                                       
HET    MSE  B 297       8                                                       
HET    MSE  B 309       8                                                       
HET    MSE  C  47       8                                                       
HET    MSE  C  59       8                                                       
HET    MSE  C  96       8                                                       
HET    MSE  C 111       8                                                       
HET    MSE  C 205       8                                                       
HET    MSE  C 211       8                                                       
HET    MSE  C 254       8                                                       
HET    MSE  C 280       8                                                       
HET    MSE  C 297       8                                                       
HET    MSE  C 309       8                                                       
HET     ZN  B 400       1                                                       
HET     ZN  B 401       1                                                       
HET     ZN  C 400       1                                                       
HET     ZN  C 401       1                                                       
HET    EDO  B 402       4                                                       
HET    PGE  B 403      10                                                       
HET    PG4  A 346      13                                                       
HET    GOL  B 404       6                                                       
HET    GOL  C 402       6                                                       
HET    GOL  B 405       6                                                       
HET    PEG  A 347       7                                                       
HET    PEG  B 406       6                                                       
HET    PEG  B 407       4                                                       
HET    PEG  C 403       5                                                       
HET    PEG  C 404       5                                                       
HET    PEG  C 405       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      ZN ZINC ION                                                         
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     PGE TRIETHYLENE GLYCOL                                               
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
HETNAM     GOL GLYCEROL                                                         
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    31(C5 H11 N O2 SE)                                           
FORMUL   4   ZN    4(ZN 2+)                                                     
FORMUL   8  EDO    C2 H6 O2                                                     
FORMUL   9  PGE    C6 H14 O4                                                    
FORMUL  10  PG4    C8 H18 O5                                                    
FORMUL  11  GOL    3(C3 H8 O3)                                                  
FORMUL  14  PEG    6(C4 H10 O3)                                                 
FORMUL  20  HOH   *340(H2 O)                                                    
CRYST1  175.260   72.780  111.770  90.00 124.90  90.00 C 1 2 1      12          
ATOM   4921  N   GLN C   3      10.354  -4.267 -27.758  1.00 37.58           N  
ATOM   4922  CA  GLN C   3      10.292  -5.758 -27.576  1.00 38.53           C  
ATOM   4923  C   GLN C   3      11.641  -6.354 -27.945  1.00 35.61           C  
ATOM   4924  O   GLN C   3      12.171  -6.058 -29.022  1.00 36.10           O  
ATOM   4925  CB  GLN C   3       9.174  -6.396 -28.437  1.00 39.67           C  
ATOM   4926  CG  GLN C   3       7.717  -6.226 -27.901  1.00 42.99           C  
ATOM   4927  CD  GLN C   3       7.389  -7.091 -26.670  1.00 45.30           C  
ATOM   4928  OE1 GLN C   3       7.966  -8.156 -26.472  1.00 44.74           O  
ATOM   4929  NE2 GLN C   3       6.434  -6.637 -25.860  1.00 42.90           N  
ATOM   4930  N   LEU C   4      12.188  -7.190 -27.064  1.00 33.47           N  
ATOM   4931  CA  LEU C   4      13.506  -7.807 -27.297  1.00 32.26           C  
ATOM   4932  C   LEU C   4      13.441  -9.089 -28.098  1.00 31.62           C  
ATOM   4933  O   LEU C   4      12.472  -9.835 -27.990  1.00 33.13           O  
ATOM   4934  CB  LEU C   4      14.229  -8.139 -25.999  1.00 28.18           C  
ATOM   4935  CG  LEU C   4      14.623  -7.008 -25.068  1.00 30.20           C  
ATOM   4936  CD1 LEU C   4      15.311  -7.628 -23.806  1.00 16.23           C  
ATOM   4937  CD2 LEU C   4      15.446  -5.883 -25.745  1.00 28.80           C  
ATOM   4938  N   GLN C   5      14.492  -9.318 -28.894  1.00 30.01           N  
ATOM   4939  CA  GLN C   5      14.689 -10.544 -29.659  1.00 28.61           C  
ATOM   4940  C   GLN C   5      15.665 -11.375 -28.818  1.00 29.57           C  
ATOM   4941  O   GLN C   5      16.647 -10.819 -28.269  1.00 26.45           O  
ATOM   4942  CB  GLN C   5      15.294 -10.240 -31.030  1.00 29.45           C  
ATOM   4943  N   LYS C   6      15.391 -12.680 -28.690  1.00 29.10           N  
ATOM   4944  CA  LYS C   6      16.294 -13.595 -27.978  1.00 29.89           C  
ATOM   4945  C   LYS C   6      17.660 -13.631 -28.675  1.00 27.89           C  
ATOM   4946  O   LYS C   6      17.760 -13.430 -29.904  1.00 24.72           O  
ATOM   4947  CB  LYS C   6      15.718 -15.032 -27.875  1.00 29.50           C  
ATOM   4948  CG  LYS C   6      14.585 -15.159 -26.859  1.00 33.66           C  
ATOM   4949  CD  LYS C   6      14.040 -16.580 -26.673  1.00 31.61           C  
ATOM   4950  N   ARG C   7      18.711 -13.829 -27.883  1.00 26.50           N  
ATOM   4951  CA  ARG C   7      20.023 -14.021 -28.444  1.00 29.06           C  
ATOM   4952  C   ARG C   7      19.966 -15.224 -29.419  1.00 27.97           C  
ATOM   4953  O   ARG C   7      19.402 -16.261 -29.082  1.00 24.99           O  
ATOM   4954  CB  ARG C   7      21.031 -14.314 -27.332  1.00 27.35           C  
ATOM   4955  CG  ARG C   7      22.468 -14.575 -27.876  1.00 31.35           C  
ATOM   4956  CD  ARG C   7      23.445 -15.061 -26.847  1.00 35.85           C  
ATOM   4957  NE  ARG C   7      22.832 -16.112 -26.031  1.00 39.27           N  
ATOM   4958  CZ  ARG C   7      22.516 -16.024 -24.744  1.00 39.68           C  
ATOM   4959  NH1 ARG C   7      22.816 -14.957 -24.022  1.00 33.28           N  
ATOM   4960  NH2 ARG C   7      21.943 -17.074 -24.159  1.00 37.79           N  
ATOM   4961  N   LYS C   8      20.519 -15.072 -30.628  1.00 28.60           N  
ATOM   4962  CA  LYS C   8      20.592 -16.178 -31.579  1.00 27.98           C  
ATOM   4963  C   LYS C   8      21.814 -17.020 -31.164  1.00 28.22           C  
ATOM   4964  O   LYS C   8      22.873 -16.464 -30.843  1.00 23.84           O  
ATOM   4965  CB  LYS C   8      20.712 -15.686 -33.022  1.00 29.98           C  
ATOM   4966  CG  LYS C   8      19.455 -14.972 -33.535  1.00 28.89           C  
ATOM   4967  N   ILE C   9      21.658 -18.352 -31.161  1.00 28.16           N  
ATOM   4968  CA  ILE C   9      22.746 -19.302 -30.797  1.00 28.23           C  
ATOM   4969  C   ILE C   9      23.915 -19.323 -31.814  1.00 27.47           C  
ATOM   4970  O   ILE C   9      25.001 -19.846 -31.515  1.00 24.76           O  
ATOM   4971  CB  ILE C   9      22.205 -20.788 -30.698  1.00 31.07           C  
ATOM   4972  CG1 ILE C   9      22.963 -21.619 -29.642  1.00 31.75           C  
ATOM   4973  CG2 ILE C   9      22.171 -21.471 -32.103  1.00 21.52           C  
ATOM   4974  CD1 ILE C   9      22.295 -21.641 -28.252  1.00 42.17           C  
ATOM   4975  N   TYR C  10      23.692 -18.753 -33.005  1.00 27.44           N  
ATOM   4976  CA  TYR C  10      24.662 -18.780 -34.090  1.00 29.55           C  
ATOM   4977  C   TYR C  10      24.317 -17.688 -35.066  1.00 29.19           C  
ATOM   4978  O   TYR C  10      23.162 -17.599 -35.457  1.00 24.09           O  
ATOM   4979  CB  TYR C  10      24.511 -20.148 -34.777  1.00 30.49           C  
ATOM   4980  CG  TYR C  10      25.298 -20.415 -36.051  1.00 32.92           C  
ATOM   4981  CD1 TYR C  10      26.674 -20.584 -36.014  1.00 32.99           C  
ATOM   4982  CD2 TYR C  10      24.647 -20.600 -37.277  1.00 30.05           C  
ATOM   4983  CE1 TYR C  10      27.395 -20.890 -37.180  1.00 39.40           C  
ATOM   4984  CE2 TYR C  10      25.366 -20.898 -38.448  1.00 34.97           C  
ATOM   4985  CZ  TYR C  10      26.744 -21.042 -38.383  1.00 34.42           C  
ATOM   4986  OH  TYR C  10      27.503 -21.333 -39.498  1.00 33.61           O  
ATOM   4987  N   ASP C  11      25.285 -16.851 -35.438  1.00 29.85           N  
ATOM   4988  CA  ASP C  11      25.021 -15.829 -36.466  1.00 30.10           C  
ATOM   4989  C   ASP C  11      26.248 -15.494 -37.312  1.00 28.44           C  
ATOM   4990  O   ASP C  11      27.077 -14.680 -36.935  1.00 27.05           O  
ATOM   4991  CB  ASP C  11      24.402 -14.552 -35.863  1.00 31.46           C  
ATOM   4992  CG  ASP C  11      23.888 -13.574 -36.947  1.00 32.70           C  
ATOM   4993  OD1 ASP C  11      23.923 -13.866 -38.173  1.00 40.75           O  
ATOM   4994  OD2 ASP C  11      23.418 -12.500 -36.567  1.00 29.53           O  
ATOM   4995  N   THR C  12      26.293 -16.071 -38.507  1.00 30.29           N  
ATOM   4996  CA  THR C  12      27.375 -15.833 -39.454  1.00 33.14           C  
ATOM   4997  C   THR C  12      27.472 -14.377 -39.965  1.00 33.94           C  
ATOM   4998  O   THR C  12      28.544 -13.978 -40.429  1.00 35.19           O  
ATOM   4999  CB  THR C  12      27.245 -16.765 -40.692  1.00 35.31           C  
ATOM   5000  OG1 THR C  12      25.970 -16.545 -41.309  1.00 40.32           O  
ATOM   5001  CG2 THR C  12      27.388 -18.249 -40.296  1.00 32.54           C  
ATOM   5002  N   THR C  13      26.368 -13.611 -39.884  1.00 33.16           N  
ATOM   5003  CA  THR C  13      26.319 -12.186 -40.313  1.00 32.28           C  
ATOM   5004  C   THR C  13      26.909 -11.199 -39.261  1.00 32.96           C  
ATOM   5005  O   THR C  13      27.145 -10.023 -39.578  1.00 32.55           O  
ATOM   5006  CB  THR C  13      24.853 -11.702 -40.628  1.00 31.67           C  
ATOM   5007  OG1 THR C  13      24.140 -11.462 -39.408  1.00 28.80           O  
ATOM   5008  CG2 THR C  13      24.089 -12.699 -41.494  1.00 27.98           C  
ATOM   5009  N   ALA C  14      27.122 -11.672 -38.028  1.00 30.81           N  
ATOM   5010  CA  ALA C  14      27.625 -10.843 -36.935  1.00 31.56           C  
ATOM   5011  C   ALA C  14      29.110 -11.129 -36.655  1.00 32.78           C  
ATOM   5012  O   ALA C  14      29.684 -12.140 -37.107  1.00 34.54           O  
ATOM   5013  CB  ALA C  14      26.771 -11.047 -35.669  1.00 26.20           C  
ATOM   5014  N   SER C  15      29.715 -10.186 -35.939  1.00 33.17           N  
ATOM   5015  CA  SER C  15      31.098 -10.255 -35.509  1.00 33.13           C  
ATOM   5016  C   SER C  15      31.082 -10.830 -34.086  1.00 31.13           C  
ATOM   5017  O   SER C  15      30.052 -10.775 -33.399  1.00 28.94           O  
ATOM   5018  CB  SER C  15      31.728  -8.850 -35.532  1.00 34.85           C  
ATOM   5019  OG  SER C  15      31.191  -8.005 -34.511  1.00 40.15           O  
ATOM   5020  N   ASN C  16      32.227 -11.348 -33.651  1.00 27.99           N  
ATOM   5021  CA  ASN C  16      32.362 -11.939 -32.307  1.00 28.98           C  
ATOM   5022  C   ASN C  16      32.138 -10.935 -31.159  1.00 29.77           C  
ATOM   5023  O   ASN C  16      31.538 -11.298 -30.128  1.00 30.40           O  
ATOM   5024  CB  ASN C  16      33.733 -12.620 -32.146  1.00 26.63           C  
ATOM   5025  CG  ASN C  16      33.983 -13.694 -33.199  1.00 29.80           C  
ATOM   5026  OD1 ASN C  16      33.035 -14.201 -33.837  1.00 27.86           O  
ATOM   5027  ND2 ASN C  16      35.258 -14.042 -33.402  1.00 26.22           N  
ATOM   5028  N   ALA C  17      32.650  -9.708 -31.331  1.00 30.28           N  
ATOM   5029  CA  ALA C  17      32.449  -8.631 -30.346  1.00 29.80           C  
ATOM   5030  C   ALA C  17      31.028  -8.066 -30.591  1.00 29.98           C  
ATOM   5031  O   ALA C  17      30.669  -7.766 -31.755  1.00 26.26           O  
ATOM   5032  CB  ALA C  17      33.541  -7.521 -30.473  1.00 29.39           C  
ATOM   5033  N   SER C  18      30.246  -7.924 -29.512  1.00 27.07           N  
ATOM   5034  CA  SER C  18      28.857  -7.462 -29.599  1.00 26.33           C  
ATOM   5035  C   SER C  18      28.700  -5.996 -30.034  1.00 26.44           C  
ATOM   5036  O   SER C  18      29.538  -5.162 -29.687  1.00 28.64           O  
ATOM   5037  CB  SER C  18      28.171  -7.592 -28.239  1.00 23.77           C  
ATOM   5038  OG  SER C  18      26.816  -7.155 -28.282  1.00 23.57           O  
ATOM   5039  N   THR C  19      27.617  -5.704 -30.769  1.00 24.41           N  
ATOM   5040  CA  THR C  19      27.267  -4.318 -31.137  1.00 25.78           C  
ATOM   5041  C   THR C  19      26.296  -3.703 -30.091  1.00 25.49           C  
ATOM   5042  O   THR C  19      26.057  -2.510 -30.110  1.00 26.72           O  
ATOM   5043  CB  THR C  19      26.638  -4.232 -32.546  1.00 27.27           C  
ATOM   5044  OG1 THR C  19      25.321  -4.800 -32.522  1.00 26.99           O  
ATOM   5045  CG2 THR C  19      27.531  -4.950 -33.596  1.00 24.80           C  
ATOM   5046  N   GLY C  20      25.735  -4.503 -29.180  1.00 24.20           N  
ATOM   5047  CA  GLY C  20      24.832  -3.974 -28.144  1.00 24.94           C  
ATOM   5048  C   GLY C  20      24.419  -5.095 -27.196  1.00 23.36           C  
ATOM   5049  O   GLY C  20      24.383  -6.243 -27.607  1.00 25.72           O  
ATOM   5050  N   ILE C  21      24.182  -4.770 -25.925  1.00 23.62           N  
ATOM   5051  CA  ILE C  21      23.737  -5.723 -24.872  1.00 25.43           C  
ATOM   5052  C   ILE C  21      22.375  -6.366 -25.167  1.00 23.99           C  
ATOM   5053  O   ILE C  21      22.134  -7.503 -24.774  1.00 23.38           O  
ATOM   5054  CB  ILE C  21      23.605  -5.007 -23.459  1.00 22.35           C  
ATOM   5055  CG1 ILE C  21      24.956  -4.636 -22.882  1.00 30.96           C  
ATOM   5056  CG2 ILE C  21      23.036  -5.898 -22.370  1.00 22.68           C  
ATOM   5057  CD1 ILE C  21      24.816  -4.041 -21.470  1.00 29.44           C  
ATOM   5058  N   LEU C  22      21.476  -5.621 -25.810  1.00 24.70           N  
ATOM   5059  CA  LEU C  22      20.126  -6.111 -26.132  1.00 24.73           C  
ATOM   5060  C   LEU C  22      19.773  -5.632 -27.513  1.00 26.44           C  
ATOM   5061  O   LEU C  22      20.065  -4.467 -27.861  1.00 25.59           O  
ATOM   5062  CB  LEU C  22      19.091  -5.591 -25.151  1.00 23.04           C  
ATOM   5063  CG  LEU C  22      19.266  -5.892 -23.672  1.00 17.09           C  
ATOM   5064  CD1 LEU C  22      18.180  -5.125 -22.924  1.00 19.80           C  
ATOM   5065  CD2 LEU C  22      19.283  -7.363 -23.319  1.00 15.77           C  
ATOM   5066  N   ASN C  23      19.131  -6.516 -28.290  1.00 26.50           N  
ATOM   5067  CA  ASN C  23      18.799  -6.231 -29.697  1.00 25.21           C  
ATOM   5068  C   ASN C  23      20.050  -5.840 -30.509  1.00 24.35           C  
ATOM   5069  O   ASN C  23      19.961  -5.085 -31.478  1.00 21.55           O  
ATOM   5070  CB  ASN C  23      17.653  -5.189 -29.818  1.00 25.87           C  
ATOM   5071  CG  ASN C  23      16.300  -5.739 -29.375  1.00 29.26           C  
ATOM   5072  OD1 ASN C  23      16.061  -6.949 -29.422  1.00 31.94           O  
ATOM   5073  ND2 ASN C  23      15.407  -4.851 -28.960  1.00 23.15           N  
ATOM   5074  N   GLY C  24      21.209  -6.384 -30.117  1.00 23.69           N  
ATOM   5075  CA  GLY C  24      22.469  -6.109 -30.789  1.00 25.39           C  
ATOM   5076  C   GLY C  24      22.768  -7.272 -31.708  1.00 27.65           C  
ATOM   5077  O   GLY C  24      21.951  -8.195 -31.828  1.00 27.27           O  
ATOM   5078  N   LYS C  25      23.944  -7.223 -32.343  1.00 28.19           N  
ATOM   5079  CA  LYS C  25      24.417  -8.278 -33.252  1.00 27.37           C  
ATOM   5080  C   LYS C  25      25.654  -8.925 -32.604  1.00 26.86           C  
ATOM   5081  O   LYS C  25      26.539  -8.204 -32.136  1.00 25.16           O  
ATOM   5082  CB  LYS C  25      24.730  -7.722 -34.645  1.00 28.46           C  
ATOM   5083  CG  LYS C  25      23.514  -7.228 -35.449  1.00 32.82           C  
ATOM   5084  CD  LYS C  25      22.601  -8.355 -35.911  1.00 39.05           C  
ATOM   5085  N   SER C  26      25.668 -10.261 -32.530  1.00 23.61           N  
ATOM   5086  CA  SER C  26      26.739 -11.062 -31.938  1.00 25.22           C  
ATOM   5087  C   SER C  26      26.737 -12.416 -32.658  1.00 25.55           C  
ATOM   5088  O   SER C  26      25.670 -13.002 -32.887  1.00 23.88           O  
ATOM   5089  CB  SER C  26      26.504 -11.263 -30.431  1.00 26.13           C  
ATOM   5090  OG  SER C  26      27.449 -12.169 -29.851  1.00 20.79           O  
ATOM   5091  N   SER C  27      27.923 -12.890 -33.031  1.00 24.23           N  
ATOM   5092  CA  SER C  27      28.053 -14.176 -33.719  1.00 24.23           C  
ATOM   5093  C   SER C  27      27.741 -15.367 -32.804  1.00 22.77           C  
ATOM   5094  O   SER C  27      27.350 -16.417 -33.279  1.00 21.13           O  
ATOM   5095  CB  SER C  27      29.478 -14.355 -34.226  1.00 21.51           C  
ATOM   5096  OG  SER C  27      30.367 -14.608 -33.137  1.00 26.74           O  
ATOM   5097  N   ASN C  28      27.970 -15.160 -31.501  1.00 23.60           N  
ATOM   5098  CA  ASN C  28      27.827 -16.128 -30.401  1.00 25.69           C  
ATOM   5099  C   ASN C  28      29.080 -17.010 -30.191  1.00 26.00           C  
ATOM   5100  O   ASN C  28      29.068 -17.902 -29.341  1.00 25.73           O  
ATOM   5101  CB  ASN C  28      26.526 -16.964 -30.439  1.00 26.40           C  
ATOM   5102  CG  ASN C  28      26.079 -17.409 -29.036  1.00 30.63           C  
ATOM   5103  OD1 ASN C  28      26.156 -16.626 -28.076  1.00 29.45           O  
ATOM   5104  ND2 ASN C  28      25.605 -18.657 -28.917  1.00 22.21           N  
ATOM   5105  N   VAL C  29      30.142 -16.748 -30.963  1.00 25.82           N  
ATOM   5106  CA  VAL C  29      31.437 -17.404 -30.790  1.00 25.95           C  
ATOM   5107  C   VAL C  29      32.231 -16.392 -29.932  1.00 24.19           C  
ATOM   5108  O   VAL C  29      32.379 -15.235 -30.317  1.00 23.96           O  
ATOM   5109  CB  VAL C  29      32.094 -17.723 -32.148  1.00 26.70           C  
ATOM   5110  CG1 VAL C  29      33.503 -18.333 -31.955  1.00 26.31           C  
ATOM   5111  CG2 VAL C  29      31.175 -18.679 -32.943  1.00 25.17           C  
ATOM   5112  N   LEU C  30      32.687 -16.830 -28.756  1.00 22.90           N  
ATOM   5113  CA  LEU C  30      33.382 -15.960 -27.798  1.00 23.14           C  
ATOM   5114  C   LEU C  30      34.904 -16.066 -27.800  1.00 23.33           C  
ATOM   5115  O   LEU C  30      35.475 -17.129 -27.433  1.00 23.49           O  
ATOM   5116  CB  LEU C  30      32.851 -16.242 -26.384  1.00 23.21           C  
ATOM   5117  CG  LEU C  30      33.439 -15.553 -25.159  1.00 20.44           C  
ATOM   5118  CD1 LEU C  30      33.594 -14.059 -25.306  1.00 14.88           C  
ATOM   5119  CD2 LEU C  30      32.537 -15.909 -23.986  1.00 26.27           C  
ATOM   5120  N   ASN C  31      35.548 -14.987 -28.259  1.00 23.85           N  
ATOM   5121  CA  ASN C  31      37.004 -14.820 -28.225  1.00 23.70           C  
ATOM   5122  C   ASN C  31      37.197 -13.886 -27.059  1.00 25.81           C  
ATOM   5123  O   ASN C  31      36.828 -12.704 -27.183  1.00 22.35           O  
ATOM   5124  CB  ASN C  31      37.530 -14.168 -29.514  1.00 25.20           C  
ATOM   5125  CG  ASN C  31      39.070 -13.871 -29.487  1.00 24.68           C  
ATOM   5126  OD1 ASN C  31      39.780 -14.184 -28.516  1.00 20.03           O  
ATOM   5127  ND2 ASN C  31      39.569 -13.255 -30.570  1.00 19.64           N  
ATOM   5128  N   TRP C  32      37.765 -14.374 -25.947  1.00 26.84           N  
ATOM   5129  CA  TRP C  32      37.910 -13.511 -24.747  1.00 26.97           C  
ATOM   5130  C   TRP C  32      38.811 -12.283 -24.886  1.00 26.31           C  
ATOM   5131  O   TRP C  32      38.651 -11.327 -24.125  1.00 24.37           O  
ATOM   5132  CB  TRP C  32      38.310 -14.308 -23.505  1.00 28.36           C  
ATOM   5133  CG  TRP C  32      37.169 -14.925 -22.830  1.00 23.89           C  
ATOM   5134  CD1 TRP C  32      36.804 -16.222 -22.909  1.00 28.06           C  
ATOM   5135  CD2 TRP C  32      36.215 -14.286 -21.968  1.00 21.86           C  
ATOM   5136  NE1 TRP C  32      35.697 -16.455 -22.145  1.00 25.38           N  
ATOM   5137  CE2 TRP C  32      35.309 -15.278 -21.556  1.00 24.80           C  
ATOM   5138  CE3 TRP C  32      36.031 -12.971 -21.502  1.00 21.39           C  
ATOM   5139  CZ2 TRP C  32      34.245 -15.007 -20.721  1.00 28.93           C  
ATOM   5140  CZ3 TRP C  32      34.961 -12.713 -20.664  1.00 24.43           C  
ATOM   5141  CH2 TRP C  32      34.095 -13.717 -20.280  1.00 24.24           C  
ATOM   5142  N   ASP C  33      39.722 -12.314 -25.860  1.00 28.98           N  
ATOM   5143  CA  ASP C  33      40.571 -11.145 -26.183  1.00 31.61           C  
ATOM   5144  C   ASP C  33      39.936 -10.160 -27.210  1.00 30.90           C  
ATOM   5145  O   ASP C  33      40.586  -9.167 -27.568  1.00 31.17           O  
ATOM   5146  CB  ASP C  33      41.962 -11.631 -26.634  1.00 32.55           C  
ATOM   5147  CG  ASP C  33      42.666 -12.462 -25.537  1.00 42.44           C  
ATOM   5148  OD1 ASP C  33      42.735 -11.990 -24.360  1.00 31.33           O  
ATOM   5149  OD2 ASP C  33      43.120 -13.590 -25.847  1.00 39.48           O  
ATOM   5150  N   ASP C  34      38.683 -10.418 -27.641  1.00 29.25           N  
ATOM   5151  CA  ASP C  34      37.928  -9.579 -28.590  1.00 28.40           C  
ATOM   5152  C   ASP C  34      36.488  -9.400 -28.092  1.00 25.53           C  
ATOM   5153  O   ASP C  34      35.560 -10.010 -28.632  1.00 23.10           O  
ATOM   5154  CB  ASP C  34      37.935 -10.219 -30.002  1.00 29.11           C  
ATOM   5155  CG  ASP C  34      37.196  -9.368 -31.059  1.00 30.47           C  
ATOM   5156  OD1 ASP C  34      37.165  -8.129 -30.915  1.00 28.06           O  
ATOM   5157  OD2 ASP C  34      36.655  -9.951 -32.035  1.00 33.60           O  
ATOM   5158  N   VAL C  35      36.321  -8.564 -27.058  1.00 25.76           N  
ATOM   5159  CA  VAL C  35      35.021  -8.335 -26.416  1.00 25.04           C  
ATOM   5160  C   VAL C  35      34.752  -6.839 -26.265  1.00 24.11           C  
ATOM   5161  O   VAL C  35      35.657  -6.012 -26.189  1.00 25.21           O  
ATOM   5162  CB  VAL C  35      34.874  -9.049 -25.026  1.00 25.29           C  
ATOM   5163  CG1 VAL C  35      35.158 -10.582 -25.137  1.00 22.19           C  
ATOM   5164  CG2 VAL C  35      35.745  -8.403 -23.954  1.00 20.37           C  
ATOM   5165  N   ARG C  36      33.473  -6.523 -26.218  1.00 24.16           N  
ATOM   5166  CA  ARG C  36      32.982  -5.153 -26.150  1.00 20.25           C  
ATOM   5167  C   ARG C  36      33.381  -4.394 -24.906  1.00 17.97           C  
ATOM   5168  O   ARG C  36      33.681  -3.218 -25.005  1.00 17.53           O  
ATOM   5169  CB  ARG C  36      31.461  -5.186 -26.293  1.00 18.36           C  
ATOM   5170  CG  ARG C  36      30.762  -3.856 -26.305  1.00 18.83           C  
ATOM   5171  CD  ARG C  36      29.277  -4.032 -26.536  1.00 26.50           C  
ATOM   5172  NE  ARG C  36      28.843  -2.885 -27.303  1.00 34.93           N  
ATOM   5173  CZ  ARG C  36      28.047  -1.896 -26.929  1.00 42.82           C  
ATOM   5174  NH1 ARG C  36      27.409  -1.874 -25.755  1.00 52.40           N  
ATOM   5175  NH2 ARG C  36      27.834  -0.914 -27.808  1.00 35.43           N  
ATOM   5176  N   PHE C  37      33.368  -5.050 -23.750  1.00 19.79           N  
ATOM   5177  CA  PHE C  37      33.645  -4.393 -22.458  1.00 20.04           C  
ATOM   5178  C   PHE C  37      34.993  -4.807 -21.888  1.00 17.59           C  
ATOM   5179  O   PHE C  37      35.230  -5.987 -21.658  1.00 21.72           O  
ATOM   5180  CB  PHE C  37      32.530  -4.684 -21.436  1.00 18.19           C  
ATOM   5181  CG  PHE C  37      31.207  -4.198 -21.878  1.00 14.75           C  
ATOM   5182  CD1 PHE C  37      30.947  -2.831 -21.908  1.00 16.81           C  
ATOM   5183  CD2 PHE C  37      30.238  -5.083 -22.338  1.00 19.85           C  
ATOM   5184  CE1 PHE C  37      29.722  -2.336 -22.368  1.00 23.58           C  
ATOM   5185  CE2 PHE C  37      29.013  -4.604 -22.788  1.00 19.24           C  
ATOM   5186  CZ  PHE C  37      28.754  -3.234 -22.806  1.00 24.17           C  
ATOM   5187  N   SER C  38      35.856  -3.828 -21.625  1.00 17.26           N  
ATOM   5188  CA  SER C  38      37.220  -4.108 -21.146  1.00 19.24           C  
ATOM   5189  C   SER C  38      37.285  -4.643 -19.699  1.00 19.22           C  
ATOM   5190  O   SER C  38      38.337  -5.119 -19.273  1.00 18.31           O  
ATOM   5191  CB  SER C  38      38.119  -2.871 -21.279  1.00 19.20           C  
ATOM   5192  OG  SER C  38      37.709  -1.837 -20.392  1.00 15.66           O  
ATOM   5193  N   TRP C  39      36.192  -4.496 -18.948  1.00 22.08           N  
ATOM   5194  CA  TRP C  39      36.090  -5.009 -17.568  1.00 16.44           C  
ATOM   5195  C   TRP C  39      35.655  -6.474 -17.524  1.00 19.01           C  
ATOM   5196  O   TRP C  39      35.780  -7.093 -16.453  1.00 18.51           O  
ATOM   5197  CB  TRP C  39      35.161  -4.124 -16.711  1.00 18.13           C  
ATOM   5198  CG  TRP C  39      33.812  -3.839 -17.300  1.00 14.01           C  
ATOM   5199  CD1 TRP C  39      33.461  -2.737 -18.007  1.00 15.47           C  
ATOM   5200  CD2 TRP C  39      32.660  -4.694 -17.285  1.00 15.80           C  
ATOM   5201  NE1 TRP C  39      32.160  -2.827 -18.414  1.00 16.98           N  
ATOM   5202  CE2 TRP C  39      31.632  -4.010 -17.971  1.00 19.17           C  
ATOM   5203  CE3 TRP C  39      32.376  -5.945 -16.713  1.00 19.74           C  
ATOM   5204  CZ2 TRP C  39      30.344  -4.549 -18.139  1.00 20.54           C  
ATOM   5205  CZ3 TRP C  39      31.102  -6.479 -16.891  1.00 14.75           C  
ATOM   5206  CH2 TRP C  39      30.100  -5.775 -17.592  1.00 18.70           C  
ATOM   5207  N   ALA C  40      35.208  -7.050 -18.664  1.00 16.31           N  
ATOM   5208  CA  ALA C  40      34.621  -8.398 -18.678  1.00 17.03           C  
ATOM   5209  C   ALA C  40      35.623  -9.490 -18.409  1.00 15.91           C  
ATOM   5210  O   ALA C  40      35.387 -10.366 -17.583  1.00 15.89           O  
ATOM   5211  CB  ALA C  40      33.863  -8.676 -19.957  1.00 17.79           C  
ATOM   5212  N   TYR C  41      36.743  -9.461 -19.101  1.00 18.17           N  
ATOM   5213  CA  TYR C  41      37.748 -10.494 -18.901  1.00 19.20           C  
ATOM   5214  C   TYR C  41      38.453 -10.410 -17.536  1.00 16.04           C  
ATOM   5215  O   TYR C  41      38.620 -11.440 -16.858  1.00 15.48           O  
ATOM   5216  CB  TYR C  41      38.729 -10.476 -20.066  1.00 21.64           C  
ATOM   5217  CG  TYR C  41      39.609 -11.676 -20.192  1.00 25.07           C  
ATOM   5218  CD1 TYR C  41      39.121 -12.962 -20.011  1.00 29.93           C  
ATOM   5219  CD2 TYR C  41      40.920 -11.529 -20.608  1.00 34.62           C  
ATOM   5220  CE1 TYR C  41      39.935 -14.065 -20.176  1.00 24.90           C  
ATOM   5221  CE2 TYR C  41      41.734 -12.630 -20.798  1.00 44.54           C  
ATOM   5222  CZ  TYR C  41      41.235 -13.894 -20.589  1.00 37.01           C  
ATOM   5223  OH  TYR C  41      42.045 -14.985 -20.791  1.00 40.40           O  
ATOM   5224  N   PRO C  42      38.863  -9.202 -17.106  1.00 17.31           N  
ATOM   5225  CA  PRO C  42      39.337  -9.146 -15.705  1.00 16.23           C  
ATOM   5226  C   PRO C  42      38.328  -9.655 -14.633  1.00 17.19           C  
ATOM   5227  O   PRO C  42      38.744 -10.263 -13.623  1.00 13.62           O  
ATOM   5228  CB  PRO C  42      39.626  -7.647 -15.486  1.00 16.05           C  
ATOM   5229  CG  PRO C  42      39.801  -7.088 -16.839  1.00 20.28           C  
ATOM   5230  CD  PRO C  42      39.063  -7.918 -17.805  1.00 17.29           C  
ATOM   5231  N   LEU C  43      37.037  -9.354 -14.805  1.00 19.72           N  
ATOM   5232  CA  LEU C  43      36.000  -9.823 -13.894  1.00 17.49           C  
ATOM   5233  C   LEU C  43      35.916 -11.344 -13.911  1.00 18.01           C  
ATOM   5234  O   LEU C  43      35.795 -11.958 -12.877  1.00 16.26           O  
ATOM   5235  CB  LEU C  43      34.643  -9.250 -14.261  1.00 21.24           C  
ATOM   5236  CG  LEU C  43      33.455  -9.726 -13.420  1.00 17.59           C  
ATOM   5237  CD1 LEU C  43      33.735  -9.536 -11.891  1.00 20.74           C  
ATOM   5238  CD2 LEU C  43      32.207  -8.989 -13.838  1.00 18.88           C  
ATOM   5239  N   TYR C  44      35.928 -11.921 -15.112  1.00 19.39           N  
ATOM   5240  CA  TYR C  44      35.949 -13.378 -15.298  1.00 15.74           C  
ATOM   5241  C   TYR C  44      37.126 -14.011 -14.528  1.00 16.63           C  
ATOM   5242  O   TYR C  44      36.921 -14.968 -13.760  1.00 17.33           O  
ATOM   5243  CB  TYR C  44      36.022 -13.725 -16.785  1.00 14.52           C  
ATOM   5244  CG  TYR C  44      36.386 -15.159 -17.001  1.00 10.30           C  
ATOM   5245  CD1 TYR C  44      35.420 -16.149 -16.973  1.00 11.49           C  
ATOM   5246  CD2 TYR C  44      37.694 -15.534 -17.276  1.00 16.11           C  
ATOM   5247  CE1 TYR C  44      35.761 -17.515 -17.158  1.00 15.36           C  
ATOM   5248  CE2 TYR C  44      38.022 -16.861 -17.476  1.00 20.98           C  
ATOM   5249  CZ  TYR C  44      37.043 -17.850 -17.418  1.00 14.42           C  
ATOM   5250  OH  TYR C  44      37.361 -19.204 -17.654  1.00 19.07           O  
ATOM   5251  N   LYS C  45      38.331 -13.484 -14.744  1.00 16.21           N  
ATOM   5252  CA  LYS C  45      39.553 -13.965 -14.076  1.00 16.78           C  
ATOM   5253  C   LYS C  45      39.445 -13.897 -12.573  1.00 16.30           C  
ATOM   5254  O   LYS C  45      39.877 -14.834 -11.886  1.00 16.44           O  
ATOM   5255  CB  LYS C  45      40.798 -13.200 -14.532  1.00 17.06           C  
ATOM   5256  CG  LYS C  45      41.201 -13.473 -15.981  1.00 16.23           C  
ATOM   5257  CD  LYS C  45      42.350 -12.581 -16.466  1.00 21.16           C  
ATOM   5258  N   ASN C  46      38.898 -12.783 -12.062  1.00 16.03           N  
ATOM   5259  CA  ASN C  46      38.651 -12.637 -10.633  1.00 16.47           C  
ATOM   5260  C   ASN C  46      37.711 -13.696 -10.079  1.00 17.29           C  
ATOM   5261  O   ASN C  46      37.958 -14.259  -9.022  1.00 17.68           O  
ATOM   5262  CB  ASN C  46      37.982 -11.297 -10.325  1.00 19.67           C  
ATOM   5263  CG  ASN C  46      38.889 -10.329  -9.774  1.00 34.43           C  
ATOM   5264  OD1 ASN C  46      39.965 -10.076 -10.320  1.00 46.35           O  
ATOM   5265  ND2 ASN C  46      38.472  -9.729  -8.645  1.00 40.71           N  
HETATM 5266  N   MSE C  47      36.599 -13.907 -10.781  1.00 15.72           N  
HETATM 5267  CA  MSE C  47      35.614 -14.927 -10.384  1.00 15.59           C  
HETATM 5268  C   MSE C  47      36.220 -16.314 -10.334  1.00 17.52           C  
HETATM 5269  O   MSE C  47      36.022 -17.045  -9.349  1.00 17.61           O  
HETATM 5270  CB  MSE C  47      34.404 -14.883 -11.311  1.00 11.44           C  
HETATM 5271  CG  MSE C  47      33.572 -13.613 -11.143  1.00 18.70           C  
HETATM 5272 SE   MSE C  47      32.201 -13.513 -12.534  0.75 19.11          SE  
HETATM 5273  CE  MSE C  47      30.927 -14.278 -11.586  1.00  9.30           C  
ATOM   5274  N   LEU C  48      37.000 -16.662 -11.360  1.00 17.85           N  
ATOM   5275  CA  LEU C  48      37.638 -17.966 -11.412  1.00 18.79           C  
ATOM   5276  C   LEU C  48      38.699 -18.126 -10.308  1.00 19.14           C  
ATOM   5277  O   LEU C  48      38.852 -19.208  -9.739  1.00 22.45           O  
ATOM   5278  CB  LEU C  48      38.209 -18.186 -12.815  1.00 18.39           C  
ATOM   5279  CG  LEU C  48      38.655 -19.533 -13.324  1.00 25.98           C  
ATOM   5280  CD1 LEU C  48      37.527 -20.561 -13.278  1.00 21.25           C  
ATOM   5281  CD2 LEU C  48      39.215 -19.334 -14.761  1.00 20.69           C  
ATOM   5282  N   ALA C  49      39.382 -17.046  -9.966  1.00 20.00           N  
ATOM   5283  CA  ALA C  49      40.398 -17.086  -8.929  1.00 16.85           C  
ATOM   5284  C   ALA C  49      39.781 -17.255  -7.551  1.00 18.71           C  
ATOM   5285  O   ALA C  49      40.456 -17.682  -6.646  1.00 18.02           O  
ATOM   5286  CB  ALA C  49      41.266 -15.878  -8.980  1.00 15.91           C  
ATOM   5287  N   ASN C  50      38.511 -16.932  -7.404  1.00 17.92           N  
ATOM   5288  CA  ASN C  50      37.842 -17.015  -6.121  1.00 20.15           C  
ATOM   5289  C   ASN C  50      37.194 -18.369  -5.867  1.00 19.33           C  
ATOM   5290  O   ASN C  50      36.506 -18.508  -4.881  1.00 22.26           O  
ATOM   5291  CB  ASN C  50      36.774 -15.909  -6.038  1.00 18.44           C  
ATOM   5292  CG  ASN C  50      37.343 -14.528  -5.806  1.00 20.72           C  
ATOM   5293  OD1 ASN C  50      38.511 -14.347  -5.451  1.00 21.85           O  
ATOM   5294  ND2 ASN C  50      36.486 -13.546  -5.931  1.00 16.59           N  
ATOM   5295  N   PHE C  51      37.427 -19.367  -6.716  1.00 21.96           N  
ATOM   5296  CA  PHE C  51      36.827 -20.688  -6.545  1.00 20.35           C  
ATOM   5297  C   PHE C  51      37.005 -21.221  -5.120  1.00 20.30           C  
ATOM   5298  O   PHE C  51      38.058 -21.123  -4.555  1.00 20.99           O  
ATOM   5299  CB  PHE C  51      37.466 -21.705  -7.489  1.00 20.41           C  
ATOM   5300  CG  PHE C  51      36.882 -23.087  -7.346  1.00 22.93           C  
ATOM   5301  CD1 PHE C  51      35.669 -23.394  -7.938  1.00 24.44           C  
ATOM   5302  CD2 PHE C  51      37.535 -24.067  -6.573  1.00 22.83           C  
ATOM   5303  CE1 PHE C  51      35.099 -24.665  -7.754  1.00 25.60           C  
ATOM   5304  CE2 PHE C  51      36.981 -25.321  -6.385  1.00 24.37           C  
ATOM   5305  CZ  PHE C  51      35.778 -25.624  -7.005  1.00 18.47           C  
ATOM   5306  N   TRP C  52      35.955 -21.802  -4.573  1.00 21.14           N  
ATOM   5307  CA  TRP C  52      35.951 -22.425  -3.251  1.00 18.19           C  
ATOM   5308  C   TRP C  52      34.855 -23.499  -3.357  1.00 16.49           C  
ATOM   5309  O   TRP C  52      33.939 -23.404  -4.196  1.00 14.90           O  
ATOM   5310  CB  TRP C  52      35.667 -21.423  -2.126  1.00 20.11           C  
ATOM   5311  CG  TRP C  52      34.335 -20.785  -2.237  1.00 22.75           C  
ATOM   5312  CD1 TRP C  52      34.020 -19.699  -2.963  1.00 19.52           C  
ATOM   5313  CD2 TRP C  52      33.129 -21.199  -1.588  1.00 18.45           C  
ATOM   5314  NE1 TRP C  52      32.717 -19.410  -2.826  1.00 17.11           N  
ATOM   5315  CE2 TRP C  52      32.127 -20.314  -1.994  1.00 16.92           C  
ATOM   5316  CE3 TRP C  52      32.802 -22.243  -0.697  1.00 22.17           C  
ATOM   5317  CZ2 TRP C  52      30.826 -20.416  -1.555  1.00 16.47           C  
ATOM   5318  CZ3 TRP C  52      31.507 -22.367  -0.277  1.00 19.36           C  
ATOM   5319  CH2 TRP C  52      30.527 -21.459  -0.699  1.00 21.19           C  
ATOM   5320  N   THR C  53      35.024 -24.522  -2.540  1.00 21.15           N  
ATOM   5321  CA  THR C  53      34.108 -25.631  -2.372  1.00 22.02           C  
ATOM   5322  C   THR C  53      33.717 -25.721  -0.873  1.00 22.31           C  
ATOM   5323  O   THR C  53      34.607 -25.610  -0.004  1.00 20.55           O  
ATOM   5324  CB  THR C  53      34.723 -26.972  -2.882  1.00 23.56           C  
ATOM   5325  OG1 THR C  53      33.994 -28.037  -2.310  1.00 21.90           O  
ATOM   5326  CG2 THR C  53      36.245 -27.163  -2.524  1.00 21.45           C  
ATOM   5327  N   PRO C  54      32.412 -25.913  -0.549  1.00 19.43           N  
ATOM   5328  CA  PRO C  54      32.053 -26.123   0.867  1.00 19.03           C  
ATOM   5329  C   PRO C  54      32.689 -27.373   1.513  1.00 15.22           C  
ATOM   5330  O   PRO C  54      32.941 -27.389   2.730  1.00 16.91           O  
ATOM   5331  CB  PRO C  54      30.524 -26.230   0.854  1.00 17.81           C  
ATOM   5332  CG  PRO C  54      30.190 -26.626  -0.526  1.00 20.66           C  
ATOM   5333  CD  PRO C  54      31.206 -25.955  -1.402  1.00 21.98           C  
ATOM   5334  N   PHE C  55      33.057 -28.355   0.702  1.00 15.25           N  
ATOM   5335  CA  PHE C  55      33.647 -29.572   1.171  1.00 20.53           C  
ATOM   5336  C   PHE C  55      35.059 -29.406   1.735  1.00 22.16           C  
ATOM   5337  O   PHE C  55      35.563 -30.341   2.304  1.00 24.37           O  
ATOM   5338  CB  PHE C  55      33.665 -30.606   0.038  1.00 14.44           C  
ATOM   5339  CG  PHE C  55      32.290 -30.995  -0.425  1.00 19.39           C  
ATOM   5340  CD1 PHE C  55      31.508 -31.824   0.345  1.00 21.06           C  
ATOM   5341  CD2 PHE C  55      31.763 -30.492  -1.615  1.00 21.12           C  
ATOM   5342  CE1 PHE C  55      30.224 -32.172  -0.056  1.00 23.98           C  
ATOM   5343  CE2 PHE C  55      30.483 -30.844  -2.034  1.00 19.26           C  
ATOM   5344  CZ  PHE C  55      29.708 -31.675  -1.229  1.00 21.03           C  
ATOM   5345  N   GLU C  56      35.695 -28.251   1.543  1.00 22.85           N  
ATOM   5346  CA  GLU C  56      36.976 -27.978   2.172  1.00 24.31           C  
ATOM   5347  C   GLU C  56      36.799 -27.259   3.504  1.00 22.86           C  
ATOM   5348  O   GLU C  56      37.782 -26.961   4.157  1.00 23.03           O  
ATOM   5349  CB  GLU C  56      37.893 -27.224   1.218  1.00 24.95           C  
ATOM   5350  CG  GLU C  56      38.420 -28.195   0.114  1.00 31.00           C  
ATOM   5351  CD  GLU C  56      39.323 -27.531  -0.923  1.00 33.96           C  
ATOM   5352  OE1 GLU C  56      39.566 -26.295  -0.811  1.00 38.40           O  
ATOM   5353  OE2 GLU C  56      39.763 -28.257  -1.859  1.00 49.89           O  
ATOM   5354  N   ILE C  57      35.562 -27.019   3.915  1.00 19.84           N  
ATOM   5355  CA  ILE C  57      35.289 -26.409   5.225  1.00 23.10           C  
ATOM   5356  C   ILE C  57      34.824 -27.531   6.160  1.00 23.65           C  
ATOM   5357  O   ILE C  57      33.824 -28.214   5.897  1.00 22.89           O  
ATOM   5358  CB  ILE C  57      34.266 -25.316   5.109  1.00 24.44           C  
ATOM   5359  CG1 ILE C  57      34.810 -24.206   4.196  1.00 29.56           C  
ATOM   5360  CG2 ILE C  57      33.964 -24.728   6.513  1.00 17.47           C  
ATOM   5361  CD1 ILE C  57      33.765 -23.271   3.651  1.00 26.32           C  
ATOM   5362  N   ASN C  58      35.570 -27.729   7.246  1.00 24.35           N  
ATOM   5363  CA  ASN C  58      35.268 -28.775   8.217  1.00 21.55           C  
ATOM   5364  C   ASN C  58      34.267 -28.219   9.225  1.00 18.07           C  
ATOM   5365  O   ASN C  58      34.553 -27.255   9.894  1.00 19.33           O  
ATOM   5366  CB  ASN C  58      36.564 -29.261   8.882  1.00 24.69           C  
ATOM   5367  CG  ASN C  58      36.345 -30.451   9.803  1.00 24.74           C  
ATOM   5368  OD1 ASN C  58      35.491 -30.413  10.668  1.00 30.12           O  
ATOM   5369  ND2 ASN C  58      37.139 -31.496   9.635  1.00 26.11           N  
HETATM 5370  N   MSE C  59      33.098 -28.852   9.329  1.00 17.61           N  
HETATM 5371  CA  MSE C  59      31.991 -28.389  10.206  1.00 18.49           C  
HETATM 5372  C   MSE C  59      31.900 -29.048  11.607  1.00 19.03           C  
HETATM 5373  O   MSE C  59      30.955 -28.774  12.373  1.00 19.36           O  
HETATM 5374  CB  MSE C  59      30.672 -28.566   9.417  1.00 17.20           C  
HETATM 5375  CG  MSE C  59      30.552 -27.615   8.137  1.00  9.88           C  
HETATM 5376 SE   MSE C  59      30.383 -25.842   8.651  0.75 18.02          SE  
HETATM 5377  CE  MSE C  59      28.763 -26.092   9.610  1.00 12.91           C  
ATOM   5378  N   SER C  60      32.914 -29.851  11.962  1.00 20.15           N  
ATOM   5379  CA  SER C  60      32.987 -30.576  13.226  1.00 19.67           C  
ATOM   5380  C   SER C  60      32.810 -29.745  14.454  1.00 15.61           C  
ATOM   5381  O   SER C  60      31.950 -30.066  15.281  1.00 16.33           O  
ATOM   5382  CB  SER C  60      34.323 -31.290  13.359  1.00 22.05           C  
ATOM   5383  OG  SER C  60      34.419 -32.262  12.349  1.00 29.15           O  
ATOM   5384  N   HIS C  61      33.604 -28.693  14.592  1.00 17.99           N  
ATOM   5385  CA  HIS C  61      33.539 -27.833  15.784  0.50 19.82           C  
ATOM   5387  C   HIS C  61      32.265 -26.978  15.821  1.00 19.35           C  
ATOM   5388  O   HIS C  61      31.732 -26.673  16.911  1.00 17.77           O  
ATOM   5389  CB  HIS C  61      34.798 -26.952  15.913  0.50 21.12           C  
ATOM   5391  CG  HIS C  61      36.075 -27.734  16.019  0.50 27.12           C  
ATOM   5393  ND1 HIS C  61      36.295 -28.674  17.004  0.50 31.21           N  
ATOM   5395  CD2 HIS C  61      37.211 -27.692  15.281  0.50 31.60           C  
ATOM   5397  CE1 HIS C  61      37.498 -29.197  16.851  0.50 32.19           C  
ATOM   5399  NE2 HIS C  61      38.075 -28.618  15.812  0.50 30.09           N  
ATOM   5401  N   ASP C  62      31.816 -26.544  14.644  1.00 19.11           N  
ATOM   5402  CA  ASP C  62      30.563 -25.796  14.525  1.00 18.93           C  
ATOM   5403  C   ASP C  62      29.396 -26.667  14.995  1.00 18.34           C  
ATOM   5404  O   ASP C  62      28.540 -26.203  15.740  1.00 16.75           O  
ATOM   5405  CB  ASP C  62      30.307 -25.327  13.073  1.00 16.57           C  
ATOM   5406  CG  ASP C  62      30.886 -23.954  12.772  1.00 21.11           C  
ATOM   5407  OD1 ASP C  62      31.961 -23.596  13.305  1.00 28.99           O  
ATOM   5408  OD2 ASP C  62      30.230 -23.190  12.008  1.00 14.11           O  
ATOM   5409  N   ALA C  63      29.394 -27.925  14.575  1.00 16.85           N  
ATOM   5410  CA  ALA C  63      28.366 -28.927  14.955  1.00 17.56           C  
ATOM   5411  C   ALA C  63      28.278 -29.204  16.449  1.00 17.70           C  
ATOM   5412  O   ALA C  63      27.182 -29.374  16.995  1.00 18.38           O  
ATOM   5413  CB  ALA C  63      28.599 -30.214  14.184  1.00 12.70           C  
ATOM   5414  N   LYS C  64      29.428 -29.280  17.100  1.00 20.90           N  
ATOM   5415  CA  LYS C  64      29.466 -29.464  18.554  1.00 23.34           C  
ATOM   5416  C   LYS C  64      28.948 -28.217  19.264  1.00 25.53           C  
ATOM   5417  O   LYS C  64      28.207 -28.290  20.253  1.00 21.26           O  
ATOM   5418  CB  LYS C  64      30.891 -29.807  19.027  1.00 22.89           C  
ATOM   5419  CG  LYS C  64      31.363 -31.164  18.554  1.00 29.01           C  
ATOM   5420  N   GLN C  65      29.287 -27.068  18.698  1.00 26.09           N  
ATOM   5421  CA  GLN C  65      28.938 -25.810  19.270  1.00 22.95           C  
ATOM   5422  C   GLN C  65      27.477 -25.436  19.049  1.00 21.90           C  
ATOM   5423  O   GLN C  65      26.903 -24.826  19.936  1.00 22.33           O  
ATOM   5424  CB  GLN C  65      29.895 -24.757  18.709  1.00 23.35           C  
ATOM   5425  CG  GLN C  65      29.880 -23.468  19.456  1.00 23.57           C  
ATOM   5426  CD  GLN C  65      30.916 -22.488  18.953  1.00 24.81           C  
ATOM   5427  OE1 GLN C  65      31.269 -22.467  17.772  1.00 27.02           O  
ATOM   5428  NE2 GLN C  65      31.403 -21.652  19.857  1.00 23.32           N  
ATOM   5429  N   PHE C  66      26.859 -25.844  17.934  1.00 20.80           N  
ATOM   5430  CA  PHE C  66      25.471 -25.429  17.623  1.00 22.78           C  
ATOM   5431  C   PHE C  66      24.422 -25.622  18.747  1.00 26.64           C  
ATOM   5432  O   PHE C  66      23.725 -24.661  19.084  1.00 23.87           O  
ATOM   5433  CB  PHE C  66      24.978 -25.993  16.293  1.00 23.63           C  
ATOM   5434  CG  PHE C  66      23.677 -25.398  15.844  1.00 21.28           C  
ATOM   5435  CD1 PHE C  66      23.630 -24.083  15.418  1.00 32.55           C  
ATOM   5436  CD2 PHE C  66      22.500 -26.130  15.867  1.00 25.85           C  
ATOM   5437  CE1 PHE C  66      22.447 -23.502  15.023  1.00 31.14           C  
ATOM   5438  CE2 PHE C  66      21.305 -25.556  15.446  1.00 30.20           C  
ATOM   5439  CZ  PHE C  66      21.283 -24.232  15.028  1.00 30.27           C  
ATOM   5440  N   PRO C  67      24.328 -26.833  19.349  1.00 27.07           N  
ATOM   5441  CA  PRO C  67      23.386 -27.001  20.452  1.00 27.98           C  
ATOM   5442  C   PRO C  67      23.633 -26.144  21.699  1.00 28.79           C  
ATOM   5443  O   PRO C  67      22.716 -26.010  22.500  1.00 31.24           O  
ATOM   5444  CB  PRO C  67      23.497 -28.502  20.801  1.00 27.56           C  
ATOM   5445  CG  PRO C  67      24.031 -29.131  19.606  1.00 27.26           C  
ATOM   5446  CD  PRO C  67      24.959 -28.120  18.992  1.00 30.86           C  
ATOM   5447  N   THR C  68      24.833 -25.589  21.863  1.00 28.26           N  
ATOM   5448  CA  THR C  68      25.135 -24.696  22.991  1.00 27.70           C  
ATOM   5449  C   THR C  68      24.723 -23.232  22.740  1.00 26.25           C  
ATOM   5450  O   THR C  68      24.786 -22.429  23.655  1.00 28.66           O  
ATOM   5451  CB  THR C  68      26.626 -24.664  23.322  1.00 26.64           C  
ATOM   5452  OG1 THR C  68      27.331 -23.972  22.279  1.00 33.83           O  
ATOM   5453  CG2 THR C  68      27.183 -26.056  23.501  1.00 27.61           C  
ATOM   5454  N   LEU C  69      24.316 -22.861  21.527  1.00 28.03           N  
ATOM   5455  CA  LEU C  69      23.860 -21.500  21.270  1.00 28.71           C  
ATOM   5456  C   LEU C  69      22.470 -21.375  21.968  1.00 30.25           C  
ATOM   5457  O   LEU C  69      21.855 -22.378  22.362  1.00 30.34           O  
ATOM   5458  CB  LEU C  69      23.782 -21.211  19.766  1.00 29.71           C  
ATOM   5459  CG  LEU C  69      25.004 -21.486  18.842  1.00 27.05           C  
ATOM   5460  CD1 LEU C  69      24.711 -21.021  17.437  1.00 21.82           C  
ATOM   5461  CD2 LEU C  69      26.297 -20.857  19.296  1.00 16.81           C  
ATOM   5462  N   THR C  70      21.970 -20.166  22.134  1.00 30.60           N  
ATOM   5463  CA  THR C  70      20.666 -19.973  22.793  1.00 31.46           C  
ATOM   5464  C   THR C  70      19.571 -20.386  21.809  1.00 33.89           C  
ATOM   5465  O   THR C  70      19.864 -20.572  20.641  1.00 35.46           O  
ATOM   5466  CB  THR C  70      20.454 -18.531  23.173  1.00 30.80           C  
ATOM   5467  OG1 THR C  70      20.289 -17.751  21.983  1.00 29.55           O  
ATOM   5468  CG2 THR C  70      21.632 -18.007  23.989  1.00 25.27           C  
ATOM   5469  N   GLU C  71      18.323 -20.516  22.248  1.00 35.11           N  
ATOM   5470  CA  GLU C  71      17.251 -20.957  21.332  1.00 35.02           C  
ATOM   5471  C   GLU C  71      17.017 -19.962  20.207  1.00 35.89           C  
ATOM   5472  O   GLU C  71      16.878 -20.384  19.057  1.00 35.25           O  
ATOM   5473  CB  GLU C  71      15.937 -21.249  22.079  1.00 35.95           C  
ATOM   5474  CG  GLU C  71      16.002 -22.467  22.975  1.00 33.79           C  
ATOM   5475  N   THR C  72      17.001 -18.659  20.518  1.00 35.25           N  
ATOM   5476  CA  THR C  72      16.842 -17.623  19.475  1.00 36.24           C  
ATOM   5477  C   THR C  72      18.020 -17.674  18.517  1.00 34.05           C  
ATOM   5478  O   THR C  72      17.833 -17.498  17.304  1.00 36.66           O  
ATOM   5479  CB  THR C  72      16.693 -16.159  20.035  1.00 35.50           C  
ATOM   5480  OG1 THR C  72      15.524 -16.074  20.856  1.00 39.21           O  
ATOM   5481  CG2 THR C  72      16.575 -15.119  18.877  1.00 34.01           C  
ATOM   5482  N   GLU C  73      19.223 -17.913  19.054  1.00 32.04           N  
ATOM   5483  CA  GLU C  73      20.417 -18.060  18.203  1.00 31.09           C  
ATOM   5484  C   GLU C  73      20.251 -19.261  17.266  1.00 27.06           C  
ATOM   5485  O   GLU C  73      20.461 -19.137  16.071  1.00 27.67           O  
ATOM   5486  CB  GLU C  73      21.704 -18.194  19.029  1.00 30.91           C  
ATOM   5487  CG  GLU C  73      22.214 -16.860  19.589  1.00 35.84           C  
ATOM   5488  CD  GLU C  73      23.415 -17.011  20.507  1.00 33.09           C  
ATOM   5489  OE1 GLU C  73      23.666 -18.117  20.998  1.00 29.62           O  
ATOM   5490  OE2 GLU C  73      24.118 -16.008  20.740  1.00 44.30           O  
ATOM   5491  N   GLN C  74      19.816 -20.394  17.808  1.00 28.38           N  
ATOM   5492  CA  GLN C  74      19.582 -21.597  16.994  1.00 26.97           C  
ATOM   5493  C   GLN C  74      18.440 -21.433  15.977  1.00 28.55           C  
ATOM   5494  O   GLN C  74      18.619 -21.784  14.802  1.00 29.84           O  
ATOM   5495  CB  GLN C  74      19.350 -22.788  17.893  1.00 29.16           C  
ATOM   5496  CG  GLN C  74      20.555 -23.175  18.785  1.00 20.98           C  
ATOM   5497  CD  GLN C  74      20.295 -24.473  19.566  1.00 30.05           C  
ATOM   5498  OE1 GLN C  74      19.672 -25.394  19.045  1.00 38.74           O  
ATOM   5499  NE2 GLN C  74      20.795 -24.555  20.791  1.00 29.33           N  
ATOM   5500  N   GLU C  75      17.316 -20.829  16.377  1.00 29.98           N  
ATOM   5501  CA  GLU C  75      16.164 -20.608  15.468  1.00 29.92           C  
ATOM   5502  C   GLU C  75      16.389 -19.596  14.386  1.00 30.54           C  
ATOM   5503  O   GLU C  75      15.929 -19.804  13.239  1.00 35.25           O  
ATOM   5504  CB  GLU C  75      14.893 -20.209  16.242  1.00 33.62           C  
ATOM   5505  CG  GLU C  75      14.370 -21.273  17.216  1.00 39.12           C  
ATOM   5506  CD  GLU C  75      14.027 -22.612  16.556  1.00 47.90           C  
ATOM   5507  OE1 GLU C  75      13.251 -22.616  15.571  1.00 55.45           O  
ATOM   5508  OE2 GLU C  75      14.527 -23.656  17.042  1.00 47.98           O  
ATOM   5509  N   ALA C  76      17.062 -18.500  14.728  1.00 28.43           N  
ATOM   5510  CA  ALA C  76      17.421 -17.488  13.752  1.00 28.80           C  
ATOM   5511  C   ALA C  76      18.351 -18.104  12.736  1.00 26.98           C  
ATOM   5512  O   ALA C  76      18.171 -17.862  11.562  1.00 30.62           O  
ATOM   5513  CB  ALA C  76      18.079 -16.234  14.411  1.00 28.79           C  
ATOM   5514  N   PHE C  77      19.312 -18.910  13.198  1.00 24.17           N  
ATOM   5515  CA  PHE C  77      20.307 -19.572  12.325  1.00 25.41           C  
ATOM   5516  C   PHE C  77      19.589 -20.393  11.263  1.00 26.18           C  
ATOM   5517  O   PHE C  77      19.862 -20.230  10.072  1.00 33.49           O  
ATOM   5518  CB  PHE C  77      21.240 -20.463  13.178  1.00 26.46           C  
ATOM   5519  CG  PHE C  77      22.501 -20.936  12.484  1.00 21.41           C  
ATOM   5520  CD1 PHE C  77      22.466 -21.956  11.550  1.00 25.97           C  
ATOM   5521  CD2 PHE C  77      23.729 -20.449  12.874  1.00 27.30           C  
ATOM   5522  CE1 PHE C  77      23.612 -22.405  10.957  1.00 23.50           C  
ATOM   5523  CE2 PHE C  77      24.877 -20.876  12.263  1.00 19.24           C  
ATOM   5524  CZ  PHE C  77      24.819 -21.881  11.320  1.00 19.85           C  
ATOM   5525  N   LYS C  78      18.656 -21.228  11.719  1.00 30.38           N  
ATOM   5526  CA  LYS C  78      17.804 -22.094  10.875  1.00 31.88           C  
ATOM   5527  C   LYS C  78      16.939 -21.359   9.821  1.00 32.62           C  
ATOM   5528  O   LYS C  78      16.928 -21.741   8.641  1.00 33.93           O  
ATOM   5529  CB  LYS C  78      16.963 -22.990  11.781  1.00 33.41           C  
ATOM   5530  CG  LYS C  78      17.836 -24.019  12.554  1.00 34.93           C  
ATOM   5531  CD  LYS C  78      17.080 -25.133  13.306  1.00 34.35           C  
ATOM   5532  CE  LYS C  78      16.652 -24.797  14.727  1.00 42.45           C  
ATOM   5533  NZ  LYS C  78      16.330 -26.043  15.535  1.00 32.73           N  
ATOM   5534  N   LYS C  79      16.267 -20.292  10.233  1.00 29.67           N  
ATOM   5535  CA  LYS C  79      15.407 -19.519   9.359  1.00 28.56           C  
ATOM   5536  C   LYS C  79      16.178 -18.730   8.332  1.00 33.32           C  
ATOM   5537  O   LYS C  79      15.736 -18.588   7.164  1.00 33.18           O  
ATOM   5538  CB  LYS C  79      14.560 -18.548  10.210  1.00 32.96           C  
ATOM   5539  CG  LYS C  79      13.554 -19.238  11.116  1.00 29.76           C  
ATOM   5540  N   ILE C  80      17.332 -18.193   8.749  1.00 31.28           N  
ATOM   5541  CA  ILE C  80      18.169 -17.459   7.848  1.00 29.66           C  
ATOM   5542  C   ILE C  80      18.670 -18.421   6.762  1.00 30.82           C  
ATOM   5543  O   ILE C  80      18.670 -18.048   5.595  1.00 34.95           O  
ATOM   5544  CB  ILE C  80      19.349 -16.742   8.552  1.00 26.07           C  
ATOM   5545  CG1 ILE C  80      18.833 -15.621   9.456  1.00 32.39           C  
ATOM   5546  CG2 ILE C  80      20.230 -16.118   7.516  1.00 24.43           C  
ATOM   5547  CD1 ILE C  80      19.912 -14.979  10.321  1.00 27.42           C  
ATOM   5548  N   ILE C  81      19.080 -19.629   7.110  1.00 27.96           N  
ATOM   5549  CA  ILE C  81      19.549 -20.554   6.030  1.00 31.66           C  
ATOM   5550  C   ILE C  81      18.392 -20.862   5.011  1.00 35.26           C  
ATOM   5551  O   ILE C  81      18.601 -20.800   3.775  1.00 36.33           O  
ATOM   5552  CB  ILE C  81      20.126 -21.857   6.577  1.00 30.07           C  
ATOM   5553  CG1 ILE C  81      21.419 -21.610   7.409  1.00 29.11           C  
ATOM   5554  CG2 ILE C  81      20.368 -22.833   5.424  1.00 26.17           C  
ATOM   5555  CD1 ILE C  81      22.647 -20.968   6.693  1.00 24.71           C  
ATOM   5556  N   GLY C  82      17.188 -21.139   5.553  1.00 36.45           N  
ATOM   5557  CA  GLY C  82      15.960 -21.325   4.771  1.00 32.83           C  
ATOM   5558  C   GLY C  82      15.822 -20.224   3.712  1.00 31.21           C  
ATOM   5559  O   GLY C  82      15.784 -20.529   2.525  1.00 27.82           O  
ATOM   5560  N   LEU C  83      15.816 -18.959   4.141  1.00 32.08           N  
ATOM   5561  CA  LEU C  83      15.712 -17.791   3.234  1.00 31.68           C  
ATOM   5562  C   LEU C  83      16.802 -17.785   2.155  1.00 31.95           C  
ATOM   5563  O   LEU C  83      16.512 -17.561   0.970  1.00 32.18           O  
ATOM   5564  CB  LEU C  83      15.813 -16.441   3.998  1.00 31.58           C  
ATOM   5565  CG  LEU C  83      15.902 -15.081   3.222  1.00 32.93           C  
ATOM   5566  CD1 LEU C  83      14.619 -14.794   2.423  1.00 33.85           C  
ATOM   5567  CD2 LEU C  83      16.229 -13.858   4.107  1.00 27.58           C  
ATOM   5568  N   LEU C  84      18.049 -17.995   2.568  1.00 33.10           N  
ATOM   5569  CA  LEU C  84      19.182 -17.968   1.606  1.00 34.04           C  
ATOM   5570  C   LEU C  84      19.187 -19.106   0.555  1.00 35.21           C  
ATOM   5571  O   LEU C  84      19.567 -18.856  -0.621  1.00 31.10           O  
ATOM   5572  CB  LEU C  84      20.495 -17.922   2.363  1.00 37.27           C  
ATOM   5573  CG  LEU C  84      20.699 -16.763   3.313  1.00 34.82           C  
ATOM   5574  CD1 LEU C  84      22.070 -16.925   3.945  1.00 35.34           C  
ATOM   5575  CD2 LEU C  84      20.546 -15.420   2.617  1.00 35.82           C  
ATOM   5576  N   ALA C  85      18.811 -20.326   0.988  1.00 31.66           N  
ATOM   5577  CA  ALA C  85      18.608 -21.474   0.114  1.00 32.58           C  
ATOM   5578  C   ALA C  85      17.521 -21.143  -0.965  1.00 34.34           C  
ATOM   5579  O   ALA C  85      17.680 -21.481  -2.146  1.00 30.44           O  
ATOM   5580  CB  ALA C  85      18.218 -22.748   0.957  1.00 34.89           C  
ATOM   5581  N   PHE C  86      16.429 -20.486  -0.553  1.00 34.16           N  
ATOM   5582  CA  PHE C  86      15.363 -20.080  -1.465  1.00 32.40           C  
ATOM   5583  C   PHE C  86      15.896 -19.059  -2.482  1.00 32.87           C  
ATOM   5584  O   PHE C  86      15.806 -19.266  -3.704  1.00 35.02           O  
ATOM   5585  CB  PHE C  86      14.190 -19.450  -0.706  1.00 34.04           C  
ATOM   5586  CG  PHE C  86      13.124 -18.912  -1.620  1.00 40.13           C  
ATOM   5587  CD1 PHE C  86      12.108 -19.757  -2.079  1.00 35.94           C  
ATOM   5588  CD2 PHE C  86      13.177 -17.582  -2.093  1.00 38.87           C  
ATOM   5589  CE1 PHE C  86      11.146 -19.296  -2.953  1.00 36.75           C  
ATOM   5590  CE2 PHE C  86      12.206 -17.107  -3.005  1.00 39.61           C  
ATOM   5591  CZ  PHE C  86      11.185 -17.960  -3.418  1.00 35.53           C  
ATOM   5592  N   LEU C  87      16.440 -17.955  -1.966  1.00 29.34           N  
ATOM   5593  CA  LEU C  87      16.972 -16.892  -2.826  1.00 29.69           C  
ATOM   5594  C   LEU C  87      18.015 -17.399  -3.866  1.00 29.49           C  
ATOM   5595  O   LEU C  87      17.849 -17.113  -5.064  1.00 30.74           O  
ATOM   5596  CB  LEU C  87      17.523 -15.738  -1.976  1.00 29.10           C  
ATOM   5597  CG  LEU C  87      16.540 -14.909  -1.112  1.00 31.80           C  
ATOM   5598  CD1 LEU C  87      17.301 -13.893  -0.126  1.00 21.94           C  
ATOM   5599  CD2 LEU C  87      15.401 -14.185  -1.942  1.00 30.31           C  
ATOM   5600  N   ASP C  88      19.029 -18.167  -3.441  1.00 27.22           N  
ATOM   5601  CA  ASP C  88      20.056 -18.679  -4.399  1.00 29.02           C  
ATOM   5602  C   ASP C  88      19.545 -19.778  -5.332  1.00 25.84           C  
ATOM   5603  O   ASP C  88      20.111 -19.957  -6.427  1.00 24.51           O  
ATOM   5604  CB  ASP C  88      21.372 -19.096  -3.721  1.00 28.81           C  
ATOM   5605  CG  ASP C  88      22.349 -17.917  -3.528  1.00 37.49           C  
ATOM   5606  OD1 ASP C  88      22.279 -16.856  -4.211  1.00 35.83           O  
ATOM   5607  OD2 ASP C  88      23.200 -18.038  -2.639  1.00 55.44           O  
ATOM   5608  N   SER C  89      18.548 -20.548  -4.889  1.00 24.82           N  
ATOM   5609  CA  SER C  89      17.875 -21.497  -5.789  1.00 26.17           C  
ATOM   5610  C   SER C  89      17.222 -20.701  -6.948  1.00 24.79           C  
ATOM   5611  O   SER C  89      17.461 -20.991  -8.130  1.00 24.57           O  
ATOM   5612  CB  SER C  89      16.774 -22.310  -5.075  1.00 25.82           C  
ATOM   5613  OG  SER C  89      17.280 -23.169  -4.078  1.00 25.13           O  
ATOM   5614  N   VAL C  90      16.432 -19.682  -6.596  1.00 25.85           N  
ATOM   5615  CA  VAL C  90      15.754 -18.813  -7.596  1.00 26.06           C  
ATOM   5616  C   VAL C  90      16.777 -18.013  -8.461  1.00 27.63           C  
ATOM   5617  O   VAL C  90      16.577 -17.848  -9.685  1.00 27.29           O  
ATOM   5618  CB  VAL C  90      14.694 -17.870  -6.901  1.00 27.86           C  
ATOM   5619  CG1 VAL C  90      14.270 -16.651  -7.787  1.00 30.16           C  
ATOM   5620  CG2 VAL C  90      13.469 -18.702  -6.418  1.00 24.03           C  
ATOM   5621  N   GLN C  91      17.865 -17.556  -7.821  1.00 27.28           N  
ATOM   5622  CA  GLN C  91      18.912 -16.750  -8.486  1.00 26.08           C  
ATOM   5623  C   GLN C  91      19.731 -17.582  -9.501  1.00 25.46           C  
ATOM   5624  O   GLN C  91      20.176 -17.037 -10.552  1.00 28.03           O  
ATOM   5625  CB  GLN C  91      19.810 -16.091  -7.439  1.00 27.73           C  
ATOM   5626  CG  GLN C  91      20.910 -15.151  -7.978  1.00 30.65           C  
ATOM   5627  CD  GLN C  91      20.408 -13.931  -8.728  1.00 34.04           C  
ATOM   5628  OE1 GLN C  91      19.244 -13.556  -8.660  1.00 21.23           O  
ATOM   5629  NE2 GLN C  91      21.313 -13.304  -9.451  1.00 28.18           N  
ATOM   5630  N   THR C  92      19.959 -18.869  -9.188  1.00 22.18           N  
ATOM   5631  CA  THR C  92      20.634 -19.806 -10.112  1.00 22.43           C  
ATOM   5632  C   THR C  92      19.861 -19.865 -11.438  1.00 24.60           C  
ATOM   5633  O   THR C  92      20.439 -19.886 -12.529  1.00 23.98           O  
ATOM   5634  CB  THR C  92      20.657 -21.287  -9.575  1.00 23.35           C  
ATOM   5635  OG1 THR C  92      21.386 -21.392  -8.340  1.00 23.95           O  
ATOM   5636  CG2 THR C  92      21.278 -22.212 -10.584  1.00 17.92           C  
ATOM   5637  N   ASP C  93      18.533 -19.902 -11.304  1.00 24.36           N  
ATOM   5638  CA  ASP C  93      17.629 -20.014 -12.441  1.00 23.51           C  
ATOM   5639  C   ASP C  93      17.522 -18.658 -13.168  1.00 23.12           C  
ATOM   5640  O   ASP C  93      17.727 -18.602 -14.386  1.00 24.16           O  
ATOM   5641  CB  ASP C  93      16.260 -20.520 -11.939  1.00 24.36           C  
ATOM   5642  CG  ASP C  93      15.369 -21.025 -13.054  1.00 30.46           C  
ATOM   5643  OD1 ASP C  93      15.802 -20.994 -14.244  1.00 26.47           O  
ATOM   5644  OD2 ASP C  93      14.228 -21.434 -12.731  1.00 23.83           O  
ATOM   5645  N   TYR C  94      17.210 -17.588 -12.442  1.00 18.55           N  
ATOM   5646  CA  TYR C  94      17.175 -16.243 -13.050  1.00 21.56           C  
ATOM   5647  C   TYR C  94      18.427 -15.882 -13.886  1.00 21.13           C  
ATOM   5648  O   TYR C  94      18.307 -15.393 -15.039  1.00 18.78           O  
ATOM   5649  CB  TYR C  94      17.030 -15.150 -11.979  1.00 23.92           C  
ATOM   5650  CG  TYR C  94      17.242 -13.736 -12.534  1.00 20.84           C  
ATOM   5651  CD1 TYR C  94      16.331 -13.178 -13.424  1.00 27.71           C  
ATOM   5652  CD2 TYR C  94      18.340 -12.954 -12.141  1.00 27.08           C  
ATOM   5653  CE1 TYR C  94      16.505 -11.816 -13.923  1.00 25.85           C  
ATOM   5654  CE2 TYR C  94      18.518 -11.619 -12.620  1.00 36.06           C  
ATOM   5655  CZ  TYR C  94      17.602 -11.059 -13.521  1.00 33.68           C  
ATOM   5656  OH  TYR C  94      17.791  -9.751 -13.996  1.00 29.09           O  
ATOM   5657  N   SER C  95      19.604 -16.145 -13.285  1.00 19.07           N  
ATOM   5658  CA  SER C  95      20.913 -15.852 -13.906  1.00 16.43           C  
ATOM   5659  C   SER C  95      21.235 -16.773 -15.098  1.00  4.20           C  
ATOM   5660  O   SER C  95      21.842 -16.385 -15.992  1.00 20.81           O  
ATOM   5661  CB  SER C  95      22.008 -15.843 -12.854  1.00 16.78           C  
ATOM   5662  OG  SER C  95      22.133 -17.141 -12.281  1.00 23.29           O  
HETATM 5663  N   MSE C  96      20.749 -17.938 -15.113  1.00 11.46           N  
HETATM 5664  CA  MSE C  96      20.854 -18.793 -16.247  1.00 20.66           C  
HETATM 5665  C   MSE C  96      19.900 -18.208 -17.289  1.00 23.01           C  
HETATM 5666  O   MSE C  96      20.287 -18.108 -18.472  1.00 25.90           O  
HETATM 5667  CB  MSE C  96      20.462 -20.201 -15.813  1.00 19.76           C  
HETATM 5668  CG  MSE C  96      20.404 -21.209 -16.904  1.00 12.94           C  
HETATM 5669 SE   MSE C  96      20.445 -22.984 -16.102  0.75 29.03          SE  
HETATM 5670  CE  MSE C  96      19.257 -22.752 -14.498  1.00 22.21           C  
ATOM   5671  N   ARG C  97      18.688 -17.785 -16.852  1.00 24.87           N  
ATOM   5672  CA  ARG C  97      17.696 -17.134 -17.759  0.50 24.58           C  
ATOM   5674  C   ARG C  97      18.247 -15.863 -18.355  1.00 26.88           C  
ATOM   5675  O   ARG C  97      18.184 -15.680 -19.565  1.00 28.20           O  
ATOM   5676  CB  ARG C  97      16.377 -16.778 -17.061  0.50 25.45           C  
ATOM   5678  CG  ARG C  97      15.145 -17.573 -17.428  0.50 28.27           C  
ATOM   5680  CD  ARG C  97      14.791 -18.877 -16.652  0.50 22.11           C  
ATOM   5682  NE  ARG C  97      13.383 -19.128 -16.983  0.50 29.30           N  
ATOM   5684  CZ  ARG C  97      12.531 -20.000 -16.446  0.50 12.77           C  
ATOM   5686  NH1 ARG C  97      12.848 -20.800 -15.444  0.50 14.69           N  
ATOM   5688  NH2 ARG C  97      11.301 -20.006 -16.928  0.50 19.42           N  
ATOM   5690  N   ALA C  98      18.737 -14.970 -17.465  1.00 32.50           N  
ATOM   5691  CA  ALA C  98      19.379 -13.687 -17.827  1.00 32.81           C  
ATOM   5692  C   ALA C  98      20.526 -14.207 -18.627  1.00 32.51           C  
ATOM   5693  O   ALA C  98      21.241 -15.067 -18.184  1.00 32.92           O  
ATOM   5694  CB  ALA C  98      19.857 -12.872 -16.567  1.00 32.85           C  
ATOM   5695  N   ALA C  99      20.723 -13.709 -19.815  1.00 36.07           N  
ATOM   5696  CA  ALA C  99      21.623 -14.443 -20.725  1.00 40.86           C  
ATOM   5697  C   ALA C  99      20.748 -15.398 -21.529  1.00 38.84           C  
ATOM   5698  O   ALA C  99      20.935 -16.654 -21.475  1.00 32.33           O  
ATOM   5699  CB  ALA C  99      22.799 -15.248 -20.012  1.00 41.08           C  
ATOM   5700  N   GLU C 100      19.704 -14.785 -22.102  1.00 31.64           N  
ATOM   5701  CA  GLU C 100      18.917 -15.365 -23.201  1.00 31.00           C  
ATOM   5702  C   GLU C 100      18.542 -14.174 -24.083  1.00 27.61           C  
ATOM   5703  O   GLU C 100      18.536 -14.326 -25.308  1.00 24.71           O  
ATOM   5704  CB  GLU C 100      17.680 -16.266 -22.876  1.00 31.72           C  
ATOM   5705  CG  GLU C 100      16.998 -16.705 -24.250  1.00 32.43           C  
ATOM   5706  CD  GLU C 100      16.135 -17.989 -24.275  1.00 35.59           C  
ATOM   5707  OE1 GLU C 100      15.269 -18.209 -23.406  1.00 42.91           O  
ATOM   5708  OE2 GLU C 100      16.282 -18.743 -25.263  1.00 32.45           O  
ATOM   5709  N   TYR C 101      18.167 -13.035 -23.463  1.00 21.68           N  
ATOM   5710  CA  TYR C 101      18.004 -11.772 -24.207  1.00 20.71           C  
ATOM   5711  C   TYR C 101      19.323 -11.014 -24.278  1.00 14.17           C  
ATOM   5712  O   TYR C 101      19.364 -10.030 -25.002  1.00 17.09           O  
ATOM   5713  CB  TYR C 101      16.833 -10.901 -23.673  1.00 21.25           C  
ATOM   5714  CG  TYR C 101      15.563 -11.593 -24.004  1.00 25.77           C  
ATOM   5715  CD1 TYR C 101      14.949 -11.439 -25.254  1.00 32.23           C  
ATOM   5716  CD2 TYR C 101      15.032 -12.526 -23.131  1.00 27.57           C  
ATOM   5717  CE1 TYR C 101      13.782 -12.157 -25.582  1.00 27.44           C  
ATOM   5718  CE2 TYR C 101      13.899 -13.259 -23.450  1.00 23.10           C  
ATOM   5719  CZ  TYR C 101      13.269 -13.064 -24.661  1.00 30.53           C  
ATOM   5720  OH  TYR C 101      12.133 -13.803 -24.927  1.00 30.58           O  
ATOM   5721  N   LEU C 102      20.355 -11.440 -23.527  1.00 13.08           N  
ATOM   5722  CA  LEU C 102      21.680 -10.769 -23.576  1.00 14.60           C  
ATOM   5723  C   LEU C 102      22.328 -11.083 -24.888  1.00 11.02           C  
ATOM   5724  O   LEU C 102      22.726 -12.217 -25.093  1.00  8.61           O  
ATOM   5725  CB  LEU C 102      22.654 -11.183 -22.455  1.00  9.39           C  
ATOM   5726  CG  LEU C 102      22.490 -10.586 -21.049  1.00 17.65           C  
ATOM   5727  CD1 LEU C 102      23.444 -11.249 -20.055  1.00 17.07           C  
ATOM   5728  CD2 LEU C 102      22.703  -9.053 -21.075  1.00 18.42           C  
ATOM   5729  N   THR C 103      22.490 -10.074 -25.740  1.00 12.73           N  
ATOM   5730  CA  THR C 103      23.114 -10.255 -27.064  1.00 13.40           C  
ATOM   5731  C   THR C 103      24.627  -9.901 -27.082  1.00 12.51           C  
ATOM   5732  O   THR C 103      25.131  -9.274 -28.042  1.00 13.45           O  
ATOM   5733  CB  THR C 103      22.356  -9.415 -28.119  1.00 16.50           C  
ATOM   5734  OG1 THR C 103      22.297  -8.050 -27.674  1.00 20.87           O  
ATOM   5735  CG2 THR C 103      20.920  -9.939 -28.343  1.00 20.88           C  
ATOM   5736  N   ASP C 104      25.325 -10.276 -26.015  1.00 12.76           N  
ATOM   5737  CA  ASP C 104      26.771 -10.124 -25.871  1.00 13.43           C  
ATOM   5738  C   ASP C 104      27.288 -11.439 -25.276  1.00 13.18           C  
ATOM   5739  O   ASP C 104      26.935 -11.770 -24.155  1.00 13.35           O  
ATOM   5740  CB  ASP C 104      27.130  -8.938 -24.961  1.00 14.93           C  
ATOM   5741  CG  ASP C 104      28.662  -8.768 -24.771  1.00 17.56           C  
ATOM   5742  OD1 ASP C 104      29.367  -9.746 -24.469  1.00 13.52           O  
ATOM   5743  OD2 ASP C 104      29.182  -7.656 -24.936  1.00 27.55           O  
ATOM   5744  N   SER C 105      28.159 -12.117 -26.009  1.00 10.61           N  
ATOM   5745  CA  SER C 105      28.761 -13.413 -25.630  1.00 13.70           C  
ATOM   5746  C   SER C 105      29.529 -13.398 -24.330  1.00 13.05           C  
ATOM   5747  O   SER C 105      29.480 -14.371 -23.554  1.00 13.68           O  
ATOM   5748  CB  SER C 105      29.737 -13.872 -26.717  1.00  4.84           C  
ATOM   5749  OG  SER C 105      29.072 -13.900 -27.919  1.00 32.90           O  
ATOM   5750  N   SER C 106      30.272 -12.328 -24.111  1.00 16.23           N  
ATOM   5751  CA  SER C 106      31.022 -12.202 -22.859  1.00 19.25           C  
ATOM   5752  C   SER C 106      30.103 -12.007 -21.645  1.00 16.91           C  
ATOM   5753  O   SER C 106      30.370 -12.546 -20.578  1.00 19.52           O  
ATOM   5754  CB  SER C 106      32.028 -11.061 -22.953  1.00 19.99           C  
ATOM   5755  OG  SER C 106      31.375  -9.830 -22.819  1.00 19.02           O  
ATOM   5756  N   LEU C 107      29.042 -11.221 -21.767  1.00 19.09           N  
ATOM   5757  CA  LEU C 107      28.116 -11.067 -20.651  1.00 13.67           C  
ATOM   5758  C   LEU C 107      27.306 -12.354 -20.376  1.00 14.24           C  
ATOM   5759  O   LEU C 107      26.991 -12.678 -19.197  1.00 13.00           O  
ATOM   5760  CB  LEU C 107      27.176  -9.847 -20.816  1.00 17.71           C  
ATOM   5761  CG  LEU C 107      27.823  -8.457 -20.925  1.00 11.68           C  
ATOM   5762  CD1 LEU C 107      26.786  -7.361 -21.041  1.00 12.18           C  
ATOM   5763  CD2 LEU C 107      28.782  -8.139 -19.798  1.00 23.47           C  
ATOM   5764  N   ALA C 108      26.907 -13.031 -21.445  1.00 10.34           N  
ATOM   5765  CA  ALA C 108      26.227 -14.306 -21.363  1.00 12.64           C  
ATOM   5766  C   ALA C 108      27.118 -15.323 -20.600  1.00 16.22           C  
ATOM   5767  O   ALA C 108      26.591 -16.085 -19.759  1.00 15.12           O  
ATOM   5768  CB  ALA C 108      25.943 -14.826 -22.777  1.00  8.41           C  
ATOM   5769  N   ALA C 109      28.419 -15.390 -20.980  1.00 16.77           N  
ATOM   5770  CA  ALA C 109      29.423 -16.251 -20.307  1.00 13.69           C  
ATOM   5771  C   ALA C 109      29.592 -15.878 -18.816  1.00 17.28           C  
ATOM   5772  O   ALA C 109      29.587 -16.764 -17.953  1.00 17.03           O  
ATOM   5773  CB  ALA C 109      30.791 -16.262 -21.096  1.00 15.11           C  
ATOM   5774  N   LEU C 110      29.683 -14.581 -18.512  1.00 15.19           N  
ATOM   5775  CA  LEU C 110      29.774 -14.107 -17.131  1.00 15.95           C  
ATOM   5776  C   LEU C 110      28.521 -14.472 -16.331  1.00 17.75           C  
ATOM   5777  O   LEU C 110      28.641 -14.763 -15.134  1.00 19.04           O  
ATOM   5778  CB  LEU C 110      30.039 -12.592 -17.059  1.00 12.07           C  
ATOM   5779  CG  LEU C 110      31.418 -12.029 -17.340  1.00 18.86           C  
ATOM   5780  CD1 LEU C 110      31.409 -10.508 -17.418  1.00 20.74           C  
ATOM   5781  CD2 LEU C 110      32.450 -12.527 -16.315  1.00 14.11           C  
HETATM 5782  N   MSE C 111      27.338 -14.492 -16.966  1.00 18.82           N  
HETATM 5783  CA  MSE C 111      26.103 -14.917 -16.281  1.00 19.57           C  
HETATM 5784  C   MSE C 111      26.112 -16.400 -16.023  1.00 16.67           C  
HETATM 5785  O   MSE C 111      25.467 -16.829 -15.092  1.00 15.53           O  
HETATM 5786  CB  MSE C 111      24.785 -14.674 -17.060  1.00 21.13           C  
HETATM 5787  CG  MSE C 111      24.176 -13.339 -16.985  1.00 10.92           C  
HETATM 5788 SE   MSE C 111      23.860 -12.750 -15.252  0.75 13.37          SE  
HETATM 5789  CE  MSE C 111      23.789 -10.976 -15.846  1.00 24.27           C  
ATOM   5790  N   SER C 112      26.710 -17.174 -16.924  1.00 16.79           N  
ATOM   5791  CA  SER C 112      26.821 -18.609 -16.750  0.50 13.83           C  
ATOM   5793  C   SER C 112      27.723 -18.902 -15.541  1.00 13.14           C  
ATOM   5794  O   SER C 112      27.466 -19.848 -14.793  1.00 13.95           O  
ATOM   5795  CB  SER C 112      27.375 -19.283 -18.010  0.50 14.11           C  
ATOM   5797  OG  SER C 112      27.552 -20.652 -17.762  0.50  7.87           O  
ATOM   5799  N   VAL C 113      28.754 -18.076 -15.352  1.00 13.65           N  
ATOM   5800  CA  VAL C 113      29.672 -18.205 -14.217  1.00 13.36           C  
ATOM   5801  C   VAL C 113      28.968 -17.830 -12.929  1.00 14.88           C  
ATOM   5802  O   VAL C 113      29.093 -18.546 -11.923  1.00 10.85           O  
ATOM   5803  CB  VAL C 113      30.946 -17.355 -14.388  1.00 14.37           C  
ATOM   5804  CG1 VAL C 113      31.868 -17.492 -13.175  1.00  9.09           C  
ATOM   5805  CG2 VAL C 113      31.668 -17.791 -15.607  1.00 14.87           C  
ATOM   5806  N   LEU C 114      28.160 -16.783 -12.988  1.00 14.78           N  
ATOM   5807  CA  LEU C 114      27.386 -16.333 -11.844  1.00 15.47           C  
ATOM   5808  C   LEU C 114      26.351 -17.418 -11.461  1.00 14.30           C  
ATOM   5809  O   LEU C 114      26.258 -17.747 -10.306  1.00 19.15           O  
ATOM   5810  CB  LEU C 114      26.765 -14.945 -12.164  1.00 15.15           C  
ATOM   5811  CG  LEU C 114      26.001 -14.177 -11.127  1.00 19.93           C  
ATOM   5812  CD1 LEU C 114      25.934 -12.674 -11.472  1.00 20.73           C  
ATOM   5813  CD2 LEU C 114      24.592 -14.737 -10.902  1.00 26.35           C  
ATOM   5814  N   SER C 115      25.627 -17.994 -12.423  1.00 12.36           N  
ATOM   5815  CA  SER C 115      24.657 -19.041 -12.144  1.00  9.90           C  
ATOM   5816  C   SER C 115      25.269 -20.292 -11.458  1.00 12.02           C  
ATOM   5817  O   SER C 115      24.661 -20.829 -10.546  1.00 15.58           O  
ATOM   5818  CB  SER C 115      23.915 -19.421 -13.425  1.00 11.96           C  
ATOM   5819  OG  SER C 115      22.962 -20.404 -13.176  1.00 13.91           O  
ATOM   5820  N   PHE C 116      26.440 -20.726 -11.927  1.00  9.38           N  
ATOM   5821  CA  PHE C 116      27.205 -21.835 -11.320  1.00  8.55           C  
ATOM   5822  C   PHE C 116      27.528 -21.506  -9.866  1.00 12.72           C  
ATOM   5823  O   PHE C 116      27.344 -22.321  -8.952  1.00 11.62           O  
ATOM   5824  CB  PHE C 116      28.516 -21.989 -12.045  1.00  8.82           C  
ATOM   5825  CG  PHE C 116      29.511 -22.796 -11.283  1.00 11.55           C  
ATOM   5826  CD1 PHE C 116      29.326 -24.167 -11.113  1.00  9.76           C  
ATOM   5827  CD2 PHE C 116      30.629 -22.209 -10.736  1.00  9.34           C  
ATOM   5828  CE1 PHE C 116      30.232 -24.923 -10.353  1.00 10.43           C  
ATOM   5829  CE2 PHE C 116      31.542 -22.975  -9.973  1.00  9.01           C  
ATOM   5830  CZ  PHE C 116      31.343 -24.326  -9.817  1.00 13.24           C  
ATOM   5831  N   GLN C 117      28.074 -20.317  -9.677  1.00  8.91           N  
ATOM   5832  CA  GLN C 117      28.337 -19.824  -8.275  1.00  9.90           C  
ATOM   5833  C   GLN C 117      27.128 -19.942  -7.411  1.00 11.30           C  
ATOM   5834  O   GLN C 117      27.251 -20.363  -6.261  1.00 17.23           O  
ATOM   5835  CB  GLN C 117      28.947 -18.444  -8.256  1.00  8.42           C  
ATOM   5836  CG  GLN C 117      30.276 -18.372  -8.936  1.00  9.31           C  
ATOM   5837  CD  GLN C 117      31.033 -17.078  -8.719  1.00 13.07           C  
ATOM   5838  OE1 GLN C 117      30.438 -16.027  -8.447  1.00 18.83           O  
ATOM   5839  NE2 GLN C 117      32.351 -17.178  -8.734  1.00  9.01           N  
ATOM   5840  N   GLU C 118      25.963 -19.510  -7.901  1.00 11.35           N  
ATOM   5841  CA  GLU C 118      24.714 -19.679  -7.177  1.00  8.45           C  
ATOM   5842  C   GLU C 118      24.338 -21.112  -6.817  1.00  9.76           C  
ATOM   5843  O   GLU C 118      23.728 -21.381  -5.762  1.00  9.23           O  
ATOM   5844  CB  GLU C 118      23.542 -19.074  -7.919  1.00 13.13           C  
ATOM   5845  CG  GLU C 118      23.641 -17.613  -8.353  1.00 21.76           C  
ATOM   5846  CD  GLU C 118      24.105 -16.597  -7.350  1.00 29.71           C  
ATOM   5847  OE1 GLU C 118      24.536 -16.919  -6.238  1.00 34.93           O  
ATOM   5848  OE2 GLU C 118      24.033 -15.403  -7.708  1.00 39.11           O  
ATOM   5849  N   VAL C 119      24.633 -22.030  -7.723  1.00  8.94           N  
ATOM   5850  CA  VAL C 119      24.478 -23.452  -7.454  1.00  9.14           C  
ATOM   5851  C   VAL C 119      25.335 -23.906  -6.298  1.00 11.08           C  
ATOM   5852  O   VAL C 119      24.842 -24.619  -5.407  1.00 13.55           O  
ATOM   5853  CB  VAL C 119      24.854 -24.306  -8.693  1.00  4.78           C  
ATOM   5854  CG1 VAL C 119      24.803 -25.778  -8.382  1.00  5.43           C  
ATOM   5855  CG2 VAL C 119      23.929 -24.002  -9.835  1.00 16.23           C  
ATOM   5856  N   VAL C 120      26.597 -23.473  -6.274  1.00  9.68           N  
ATOM   5857  CA  VAL C 120      27.509 -23.840  -5.195  1.00  7.59           C  
ATOM   5858  C   VAL C 120      27.027 -23.190  -3.903  1.00  6.98           C  
ATOM   5859  O   VAL C 120      27.033 -23.839  -2.888  1.00  6.15           O  
ATOM   5860  CB  VAL C 120      28.978 -23.494  -5.504  1.00 10.47           C  
ATOM   5861  CG1 VAL C 120      29.919 -23.906  -4.341  1.00  8.24           C  
ATOM   5862  CG2 VAL C 120      29.434 -24.209  -6.806  1.00  2.00           C  
ATOM   5863  N   HIS C 121      26.564 -21.953  -3.963  1.00  9.52           N  
ATOM   5864  CA  HIS C 121      26.034 -21.298  -2.761  1.00 10.21           C  
ATOM   5865  C   HIS C 121      24.841 -22.053  -2.178  1.00 12.98           C  
ATOM   5866  O   HIS C 121      24.744 -22.254  -0.959  1.00 12.62           O  
ATOM   5867  CB  HIS C 121      25.644 -19.830  -2.988  1.00 12.28           C  
ATOM   5868  CG  HIS C 121      26.779 -18.949  -3.429  1.00  9.16           C  
ATOM   5869  ND1 HIS C 121      26.588 -17.675  -3.918  1.00 11.17           N  
ATOM   5870  CD2 HIS C 121      28.106 -19.189  -3.524  1.00 14.05           C  
ATOM   5871  CE1 HIS C 121      27.748 -17.151  -4.253  1.00  8.92           C  
ATOM   5872  NE2 HIS C 121      28.694 -18.054  -4.031  1.00 13.83           N  
ATOM   5873  N   ASN C 122      23.885 -22.401  -3.033  1.00  9.65           N  
ATOM   5874  CA  ASN C 122      22.694 -23.109  -2.598  1.00  9.97           C  
ATOM   5875  C   ASN C 122      23.059 -24.474  -1.986  1.00  8.06           C  
ATOM   5876  O   ASN C 122      22.532 -24.869  -0.953  1.00 14.25           O  
ATOM   5877  CB  ASN C 122      21.748 -23.331  -3.755  1.00 11.54           C  
ATOM   5878  CG  ASN C 122      20.510 -24.057  -3.319  1.00 17.95           C  
ATOM   5879  OD1 ASN C 122      19.729 -23.525  -2.492  1.00 18.96           O  
ATOM   5880  ND2 ASN C 122      20.358 -25.278  -3.770  1.00 20.95           N  
ATOM   5881  N   GLN C 123      23.973 -25.190  -2.623  1.00 12.11           N  
ATOM   5882  CA  GLN C 123      24.461 -26.459  -2.076  1.00 12.45           C  
ATOM   5883  C   GLN C 123      25.179 -26.319  -0.752  1.00 11.02           C  
ATOM   5884  O   GLN C 123      25.088 -27.222   0.085  1.00 10.14           O  
ATOM   5885  CB  GLN C 123      25.299 -27.187  -3.101  1.00 13.46           C  
ATOM   5886  CG  GLN C 123      25.829 -28.576  -2.657  1.00 15.68           C  
ATOM   5887  CD  GLN C 123      27.243 -28.549  -2.067  1.00 12.70           C  
ATOM   5888  OE1 GLN C 123      28.137 -27.861  -2.594  1.00  9.35           O  
ATOM   5889  NE2 GLN C 123      27.453 -29.293  -0.997  1.00 10.40           N  
ATOM   5890  N   SER C 124      25.866 -25.195  -0.552  0.50 10.90           N  
ATOM   5892  CA  SER C 124      26.570 -24.931   0.670  0.50 10.59           C  
ATOM   5894  C   SER C 124      25.595 -24.771   1.847  0.50 11.62           C  
ATOM   5896  O   SER C 124      25.921 -25.169   2.968  0.50  9.91           O  
ATOM   5898  CB  SER C 124      27.468 -23.700   0.505  0.50 11.74           C  
ATOM   5900  OG  SER C 124      28.432 -23.936  -0.507  0.50  9.17           O  
ATOM   5902  N   TYR C 125      24.414 -24.208   1.592  1.00 11.37           N  
ATOM   5903  CA  TYR C 125      23.356 -24.090   2.631  1.00 14.40           C  
ATOM   5904  C   TYR C 125      22.849 -25.480   3.043  1.00 14.83           C  
ATOM   5905  O   TYR C 125      22.664 -25.690   4.220  1.00 19.71           O  
ATOM   5906  CB  TYR C 125      22.176 -23.196   2.222  1.00 14.44           C  
ATOM   5907  CG  TYR C 125      22.589 -21.812   1.843  1.00 20.46           C  
ATOM   5908  CD1 TYR C 125      23.389 -21.077   2.696  1.00 18.64           C  
ATOM   5909  CD2 TYR C 125      22.157 -21.214   0.641  1.00 16.45           C  
ATOM   5910  CE1 TYR C 125      23.810 -19.822   2.376  1.00 28.26           C  
ATOM   5911  CE2 TYR C 125      22.587 -19.915   0.310  1.00 14.95           C  
ATOM   5912  CZ  TYR C 125      23.420 -19.245   1.189  1.00 28.78           C  
ATOM   5913  OH  TYR C 125      23.858 -17.966   0.978  1.00 30.01           O  
ATOM   5914  N   SER C 126      22.702 -26.408   2.112  1.00 16.39           N  
ATOM   5915  CA  SER C 126      22.360 -27.802   2.445  1.00 18.39           C  
ATOM   5916  C   SER C 126      23.475 -28.491   3.207  1.00 17.04           C  
ATOM   5917  O   SER C 126      23.214 -29.340   4.083  1.00 11.47           O  
ATOM   5918  CB  SER C 126      22.138 -28.650   1.210  1.00 19.12           C  
ATOM   5919  OG  SER C 126      20.946 -28.292   0.569  1.00 37.04           O  
ATOM   5920  N   TYR C 127      24.716 -28.206   2.805  1.00 15.48           N  
ATOM   5921  CA  TYR C 127      25.912 -28.758   3.477  1.00 15.04           C  
ATOM   5922  C   TYR C 127      25.956 -28.330   4.950  1.00 13.81           C  
ATOM   5923  O   TYR C 127      26.163 -29.160   5.830  1.00 12.55           O  
ATOM   5924  CB  TYR C 127      27.185 -28.362   2.689  1.00 15.79           C  
ATOM   5925  CG  TYR C 127      28.513 -28.771   3.265  1.00 12.18           C  
ATOM   5926  CD1 TYR C 127      29.177 -27.950   4.166  1.00 11.81           C  
ATOM   5927  CD2 TYR C 127      29.061 -29.992   2.958  1.00  8.56           C  
ATOM   5928  CE1 TYR C 127      30.377 -28.330   4.729  1.00 15.15           C  
ATOM   5929  CE2 TYR C 127      30.280 -30.396   3.508  1.00 10.79           C  
ATOM   5930  CZ  TYR C 127      30.915 -29.550   4.421  1.00  8.14           C  
ATOM   5931  OH  TYR C 127      32.101 -29.917   4.995  1.00 11.67           O  
ATOM   5932  N   VAL C 128      25.750 -27.048   5.215  1.00 11.46           N  
ATOM   5933  CA  VAL C 128      25.711 -26.525   6.547  1.00 11.73           C  
ATOM   5934  C   VAL C 128      24.586 -27.190   7.339  1.00 11.99           C  
ATOM   5935  O   VAL C 128      24.820 -27.687   8.423  1.00 13.18           O  
ATOM   5936  CB  VAL C 128      25.531 -24.987   6.570  1.00 14.47           C  
ATOM   5937  CG1 VAL C 128      25.284 -24.517   8.000  1.00 13.30           C  
ATOM   5938  CG2 VAL C 128      26.780 -24.305   6.045  1.00 17.93           C  
ATOM   5939  N   LEU C 129      23.371 -27.177   6.802  1.00 12.81           N  
ATOM   5940  CA  LEU C 129      22.215 -27.856   7.453  1.00 14.84           C  
ATOM   5941  C   LEU C 129      22.445 -29.335   7.733  1.00 14.34           C  
ATOM   5942  O   LEU C 129      22.167 -29.776   8.835  1.00 17.45           O  
ATOM   5943  CB  LEU C 129      20.919 -27.718   6.621  1.00 14.80           C  
ATOM   5944  CG  LEU C 129      20.256 -26.353   6.520  1.00 19.39           C  
ATOM   5945  CD1 LEU C 129      18.954 -26.528   5.729  1.00 14.95           C  
ATOM   5946  CD2 LEU C 129      19.995 -25.793   7.943  1.00 25.35           C  
ATOM   5947  N   SER C 130      22.977 -30.075   6.752  1.00 14.44           N  
ATOM   5948  CA  SER C 130      23.258 -31.506   6.903  0.50 13.67           C  
ATOM   5950  C   SER C 130      24.348 -31.793   7.941  1.00 15.03           C  
ATOM   5951  O   SER C 130      24.496 -32.928   8.373  1.00 13.50           O  
ATOM   5952  CB  SER C 130      23.631 -32.159   5.557  0.50 14.26           C  
ATOM   5954  OG  SER C 130      24.922 -31.781   5.084  0.50 13.00           O  
ATOM   5956  N   SER C 131      25.126 -30.773   8.314  1.00 12.26           N  
ATOM   5957  CA  SER C 131      26.176 -30.907   9.317  1.00 10.20           C  
ATOM   5958  C   SER C 131      25.665 -30.597  10.702  1.00  9.35           C  
ATOM   5959  O   SER C 131      26.186 -31.121  11.666  1.00  8.14           O  
ATOM   5960  CB  SER C 131      27.361 -29.945   8.994  1.00 13.48           C  
ATOM   5961  OG  SER C 131      27.903 -30.166   7.692  1.00 14.54           O  
ATOM   5962  N   LEU C 132      24.606 -29.787  10.805  1.00  7.49           N  
ATOM   5963  CA  LEU C 132      24.161 -29.252  12.095  1.00  5.68           C  
ATOM   5964  C   LEU C 132      22.805 -29.649  12.620  1.00  6.47           C  
ATOM   5965  O   LEU C 132      22.607 -29.583  13.824  1.00  9.88           O  
ATOM   5966  CB  LEU C 132      24.170 -27.707  11.981  1.00  5.19           C  
ATOM   5967  CG  LEU C 132      25.481 -26.981  11.643  1.00  6.61           C  
ATOM   5968  CD1 LEU C 132      25.239 -25.470  11.574  1.00 16.62           C  
ATOM   5969  CD2 LEU C 132      26.544 -27.298  12.653  1.00 13.05           C  
ATOM   5970  N   VAL C 133      21.855 -30.009  11.747  1.00  6.52           N  
ATOM   5971  CA  VAL C 133      20.493 -30.281  12.199  1.00  7.47           C  
ATOM   5972  C   VAL C 133      20.008 -31.612  11.643  1.00  9.13           C  
ATOM   5973  O   VAL C 133      20.444 -31.997  10.536  1.00  7.67           O  
ATOM   5974  CB  VAL C 133      19.531 -29.101  11.813  1.00  8.56           C  
ATOM   5975  CG1 VAL C 133      20.155 -27.737  12.217  1.00 10.90           C  
ATOM   5976  CG2 VAL C 133      19.276 -29.047  10.391  1.00  6.17           C  
ATOM   5977  N   PRO C 134      19.145 -32.340  12.399  1.00  8.31           N  
ATOM   5978  CA  PRO C 134      18.643 -33.630  11.885  1.00  8.12           C  
ATOM   5979  C   PRO C 134      17.851 -33.509  10.620  1.00 12.26           C  
ATOM   5980  O   PRO C 134      17.303 -32.429  10.343  1.00 10.51           O  
ATOM   5981  CB  PRO C 134      17.787 -34.186  13.029  1.00  9.63           C  
ATOM   5982  CG  PRO C 134      18.189 -33.403  14.215  1.00  6.11           C  
ATOM   5983  CD  PRO C 134      18.645 -32.078  13.768  1.00  8.02           C  
ATOM   5984  N   LYS C 135      17.820 -34.602   9.847  1.00 15.30           N  
ATOM   5985  CA  LYS C 135      17.135 -34.632   8.547  1.00 16.59           C  
ATOM   5986  C   LYS C 135      15.714 -34.118   8.658  1.00 17.45           C  
ATOM   5987  O   LYS C 135      15.280 -33.355   7.785  1.00 19.63           O  
ATOM   5988  CB  LYS C 135      17.164 -36.028   7.901  1.00 15.86           C  
ATOM   5989  CG  LYS C 135      16.459 -36.101   6.548  1.00 18.20           C  
ATOM   5990  CD  LYS C 135      16.679 -37.413   5.864  1.00 19.88           C  
ATOM   5991  N   ALA C 136      15.002 -34.516   9.707  1.00 17.90           N  
ATOM   5992  CA  ALA C 136      13.649 -34.025   9.938  1.00 19.14           C  
ATOM   5993  C   ALA C 136      13.655 -32.495   9.902  1.00 23.06           C  
ATOM   5994  O   ALA C 136      12.840 -31.886   9.194  1.00 26.72           O  
ATOM   5995  CB  ALA C 136      13.126 -34.522  11.219  1.00 16.58           C  
ATOM   5996  N   THR C 137      14.618 -31.877  10.593  1.00 23.01           N  
ATOM   5997  CA  THR C 137      14.748 -30.415  10.617  1.00 18.95           C  
ATOM   5998  C   THR C 137      15.205 -29.863   9.246  1.00 20.30           C  
ATOM   5999  O   THR C 137      14.584 -28.941   8.721  1.00 17.29           O  
ATOM   6000  CB  THR C 137      15.701 -29.999  11.778  1.00 22.61           C  
ATOM   6001  OG1 THR C 137      15.254 -30.595  13.020  1.00 15.95           O  
ATOM   6002  CG2 THR C 137      15.802 -28.477  11.912  1.00 19.63           C  
ATOM   6003  N   GLN C 138      16.262 -30.426   8.651  1.00 19.24           N  
ATOM   6004  CA  GLN C 138      16.719 -29.977   7.337  1.00 21.65           C  
ATOM   6005  C   GLN C 138      15.536 -29.974   6.338  1.00 24.06           C  
ATOM   6006  O   GLN C 138      15.370 -28.999   5.565  1.00 27.03           O  
ATOM   6007  CB  GLN C 138      17.904 -30.800   6.805  1.00 18.44           C  
ATOM   6008  CG  GLN C 138      18.269 -30.371   5.382  1.00 18.71           C  
ATOM   6009  CD  GLN C 138      19.552 -30.981   4.822  1.00 26.97           C  
ATOM   6010  OE1 GLN C 138      20.374 -31.549   5.556  1.00 28.78           O  
ATOM   6011  NE2 GLN C 138      19.727 -30.858   3.504  1.00 18.46           N  
ATOM   6012  N   ASP C 139      14.720 -31.039   6.381  1.00 25.24           N  
ATOM   6013  CA  ASP C 139      13.491 -31.145   5.574  1.00 24.74           C  
ATOM   6014  C   ASP C 139      12.550 -29.988   5.889  1.00 27.71           C  
ATOM   6015  O   ASP C 139      12.077 -29.337   4.941  1.00 27.60           O  
ATOM   6016  CB  ASP C 139      12.736 -32.468   5.805  1.00 24.94           C  
ATOM   6017  CG  ASP C 139      13.423 -33.670   5.175  1.00 25.84           C  
ATOM   6018  OD1 ASP C 139      14.459 -33.503   4.493  1.00 28.98           O  
ATOM   6019  OD2 ASP C 139      12.915 -34.794   5.372  1.00 37.99           O  
ATOM   6020  N   GLU C 140      12.305 -29.721   7.183  1.00 27.94           N  
ATOM   6021  CA  GLU C 140      11.416 -28.605   7.571  1.00 30.27           C  
ATOM   6022  C   GLU C 140      11.879 -27.232   7.110  1.00 26.76           C  
ATOM   6023  O   GLU C 140      11.070 -26.435   6.602  1.00 21.00           O  
ATOM   6024  CB  GLU C 140      11.224 -28.517   9.067  1.00 30.60           C  
ATOM   6025  CG  GLU C 140      10.333 -29.570   9.616  1.00 32.58           C  
ATOM   6026  CD  GLU C 140      10.222 -29.464  11.127  1.00 36.87           C  
ATOM   6027  OE1 GLU C 140      10.219 -28.311  11.634  1.00 49.78           O  
ATOM   6028  OE2 GLU C 140      10.135 -30.526  11.801  1.00 52.83           O  
ATOM   6029  N   ILE C 141      13.173 -26.965   7.304  1.00 27.86           N  
ATOM   6030  CA  ILE C 141      13.807 -25.695   6.873  1.00 29.01           C  
ATOM   6031  C   ILE C 141      13.565 -25.484   5.353  1.00 29.53           C  
ATOM   6032  O   ILE C 141      13.155 -24.391   4.913  1.00 27.86           O  
ATOM   6033  CB  ILE C 141      15.341 -25.612   7.250  1.00 30.21           C  
ATOM   6034  CG1 ILE C 141      15.545 -25.664   8.785  1.00 29.12           C  
ATOM   6035  CG2 ILE C 141      16.010 -24.305   6.665  1.00 28.38           C  
ATOM   6036  CD1 ILE C 141      16.974 -25.941   9.232  1.00 24.18           C  
ATOM   6037  N   PHE C 142      13.765 -26.533   4.569  1.00 30.24           N  
ATOM   6038  CA  PHE C 142      13.449 -26.454   3.140  1.00 34.08           C  
ATOM   6039  C   PHE C 142      11.909 -26.353   2.779  1.00 34.71           C  
ATOM   6040  O   PHE C 142      11.595 -26.204   1.603  1.00 36.48           O  
ATOM   6041  CB  PHE C 142      14.187 -27.555   2.347  1.00 33.11           C  
ATOM   6042  CG  PHE C 142      15.608 -27.192   1.975  1.00 30.40           C  
ATOM   6043  CD1 PHE C 142      15.850 -26.328   0.885  1.00 30.22           C  
ATOM   6044  CD2 PHE C 142      16.700 -27.744   2.665  1.00 28.43           C  
ATOM   6045  CE1 PHE C 142      17.162 -25.986   0.505  1.00 33.32           C  
ATOM   6046  CE2 PHE C 142      18.021 -27.426   2.303  1.00 35.26           C  
ATOM   6047  CZ  PHE C 142      18.258 -26.537   1.213  1.00 37.50           C  
ATOM   6048  N   GLU C 143      10.984 -26.471   3.749  1.00 35.50           N  
ATOM   6049  CA  GLU C 143       9.533 -26.159   3.551  1.00 36.40           C  
ATOM   6050  C   GLU C 143       9.086 -24.788   4.148  1.00 35.30           C  
ATOM   6051  O   GLU C 143       7.956 -24.366   3.932  1.00 34.92           O  
ATOM   6052  CB  GLU C 143       8.635 -27.258   4.130  1.00 38.50           C  
ATOM   6053  CG  GLU C 143       8.818 -28.639   3.519  1.00 43.27           C  
ATOM   6054  CD  GLU C 143       8.604 -28.664   2.016  1.00 52.20           C  
ATOM   6055  OE1 GLU C 143       7.600 -28.095   1.530  1.00 59.83           O  
ATOM   6056  OE2 GLU C 143       9.447 -29.261   1.318  1.00 60.41           O  
ATOM   6057  N   TYR C 144       9.980 -24.098   4.857  1.00 37.50           N  
ATOM   6058  CA  TYR C 144       9.735 -22.774   5.502  1.00 36.50           C  
ATOM   6059  C   TYR C 144       9.096 -21.707   4.580  1.00 34.40           C  
ATOM   6060  O   TYR C 144       8.073 -21.090   4.930  1.00 31.76           O  
ATOM   6061  CB  TYR C 144      11.078 -22.275   6.097  1.00 39.78           C  
ATOM   6062  CG  TYR C 144      11.071 -20.996   6.865  1.00 41.32           C  
ATOM   6063  CD1 TYR C 144       9.953 -20.580   7.604  1.00 57.46           C  
ATOM   6064  CD2 TYR C 144      12.231 -20.248   6.961  1.00 47.26           C  
ATOM   6065  CE1 TYR C 144       9.981 -19.396   8.326  1.00 58.43           C  
ATOM   6066  CE2 TYR C 144      12.272 -19.081   7.674  1.00 47.46           C  
ATOM   6067  CZ  TYR C 144      11.147 -18.646   8.358  1.00 55.08           C  
ATOM   6068  OH  TYR C 144      11.166 -17.482   9.100  1.00 55.62           O  
ATOM   6069  N   TRP C 145       9.712 -21.548   3.400  1.00 32.99           N  
ATOM   6070  CA  TRP C 145       9.266 -20.634   2.313  1.00 31.65           C  
ATOM   6071  C   TRP C 145       7.794 -20.861   1.856  1.00 29.41           C  
ATOM   6072  O   TRP C 145       7.112 -19.920   1.430  1.00 27.82           O  
ATOM   6073  CB  TRP C 145      10.222 -20.759   1.104  1.00 32.02           C  
ATOM   6074  CG  TRP C 145      10.100 -22.061   0.377  1.00 33.63           C  
ATOM   6075  CD1 TRP C 145      10.713 -23.246   0.674  1.00 33.94           C  
ATOM   6076  CD2 TRP C 145       9.259 -22.319  -0.752  1.00 38.08           C  
ATOM   6077  NE1 TRP C 145      10.315 -24.211  -0.212  1.00 37.15           N  
ATOM   6078  CE2 TRP C 145       9.425 -23.672  -1.096  1.00 40.59           C  
ATOM   6079  CE3 TRP C 145       8.382 -21.528  -1.512  1.00 39.80           C  
ATOM   6080  CZ2 TRP C 145       8.747 -24.260  -2.157  1.00 39.63           C  
ATOM   6081  CZ3 TRP C 145       7.714 -22.109  -2.579  1.00 38.23           C  
ATOM   6082  CH2 TRP C 145       7.905 -23.458  -2.892  1.00 39.20           C  
ATOM   6083  N   LYS C 146       7.339 -22.108   1.956  1.00 26.69           N  
ATOM   6084  CA  LYS C 146       6.001 -22.526   1.576  1.00 26.73           C  
ATOM   6085  C   LYS C 146       4.920 -22.212   2.629  1.00 24.40           C  
ATOM   6086  O   LYS C 146       3.765 -22.066   2.262  1.00 24.86           O  
ATOM   6087  CB  LYS C 146       6.034 -24.045   1.286  1.00 26.43           C  
ATOM   6088  CG  LYS C 146       4.831 -24.650   0.585  1.00 29.11           C  
ATOM   6089  CD  LYS C 146       5.063 -26.137   0.294  1.00 27.80           C  
ATOM   6090  N   HIS C 147       5.270 -22.090   3.904  1.00 21.87           N  
ATOM   6091  CA  HIS C 147       4.246 -21.929   4.950  1.00 23.97           C  
ATOM   6092  C   HIS C 147       4.230 -20.634   5.758  1.00 23.41           C  
ATOM   6093  O   HIS C 147       3.181 -20.242   6.267  1.00 23.23           O  
ATOM   6094  CB  HIS C 147       4.343 -23.124   5.898  1.00 24.63           C  
ATOM   6095  CG  HIS C 147       4.046 -24.424   5.227  1.00 31.50           C  
ATOM   6096  ND1 HIS C 147       5.032 -25.224   4.687  1.00 33.56           N  
ATOM   6097  CD2 HIS C 147       2.868 -25.034   4.952  1.00 30.85           C  
ATOM   6098  CE1 HIS C 147       4.474 -26.286   4.132  1.00 29.37           C  
ATOM   6099  NE2 HIS C 147       3.163 -26.195   4.280  1.00 35.25           N  
ATOM   6100  N   ASP C 148       5.373 -19.983   5.895  1.00 23.03           N  
ATOM   6101  CA  ASP C 148       5.460 -18.751   6.666  1.00 22.22           C  
ATOM   6102  C   ASP C 148       4.990 -17.582   5.810  1.00 22.89           C  
ATOM   6103  O   ASP C 148       5.602 -17.308   4.779  1.00 21.51           O  
ATOM   6104  CB  ASP C 148       6.898 -18.540   7.133  1.00 22.87           C  
ATOM   6105  CG  ASP C 148       7.041 -17.356   8.072  1.00 23.93           C  
ATOM   6106  OD1 ASP C 148       7.146 -16.194   7.619  1.00 20.69           O  
ATOM   6107  OD2 ASP C 148       7.102 -17.619   9.275  1.00 22.11           O  
ATOM   6108  N   ASP C 149       3.937 -16.885   6.247  1.00 21.14           N  
ATOM   6109  CA  ASP C 149       3.404 -15.748   5.487  1.00 21.55           C  
ATOM   6110  C   ASP C 149       4.359 -14.525   5.386  1.00 22.02           C  
ATOM   6111  O   ASP C 149       4.292 -13.788   4.404  1.00 21.81           O  
ATOM   6112  CB  ASP C 149       2.013 -15.342   6.004  1.00 21.52           C  
ATOM   6113  CG  ASP C 149       0.951 -16.420   5.759  1.00 23.97           C  
ATOM   6114  N   VAL C 150       5.249 -14.327   6.365  1.00 21.20           N  
ATOM   6115  CA  VAL C 150       6.227 -13.228   6.299  1.00 20.23           C  
ATOM   6116  C   VAL C 150       7.275 -13.532   5.223  1.00 22.95           C  
ATOM   6117  O   VAL C 150       7.531 -12.696   4.350  1.00 18.42           O  
ATOM   6118  CB  VAL C 150       6.935 -12.964   7.655  1.00 21.42           C  
ATOM   6119  CG1 VAL C 150       8.069 -11.859   7.503  1.00 21.33           C  
ATOM   6120  CG2 VAL C 150       5.893 -12.632   8.764  1.00 15.69           C  
ATOM   6121  N   LEU C 151       7.868 -14.728   5.299  1.00 24.02           N  
ATOM   6122  CA  LEU C 151       8.863 -15.189   4.316  1.00 27.19           C  
ATOM   6123  C   LEU C 151       8.235 -15.220   2.918  1.00 26.25           C  
ATOM   6124  O   LEU C 151       8.871 -14.845   1.937  1.00 27.40           O  
ATOM   6125  CB  LEU C 151       9.421 -16.583   4.692  1.00 27.35           C  
ATOM   6126  CG  LEU C 151      10.599 -17.160   3.878  1.00 26.91           C  
ATOM   6127  CD1 LEU C 151      11.821 -16.231   3.894  1.00 39.88           C  
ATOM   6128  CD2 LEU C 151      11.017 -18.521   4.356  1.00 26.63           C  
ATOM   6129  N   LYS C 152       6.972 -15.633   2.854  1.00 25.45           N  
ATOM   6130  CA  LYS C 152       6.224 -15.700   1.610  1.00 26.99           C  
ATOM   6131  C   LYS C 152       6.130 -14.333   0.963  1.00 26.15           C  
ATOM   6132  O   LYS C 152       6.534 -14.199  -0.171  1.00 28.38           O  
ATOM   6133  CB  LYS C 152       4.824 -16.276   1.857  1.00 27.03           C  
ATOM   6134  CG  LYS C 152       4.000 -16.590   0.627  1.00 31.11           C  
ATOM   6135  CD  LYS C 152       2.609 -17.137   0.988  1.00 29.81           C  
ATOM   6136  CE  LYS C 152       2.613 -18.526   1.629  1.00 30.50           C  
ATOM   6137  NZ  LYS C 152       1.262 -18.840   2.195  1.00 35.75           N  
ATOM   6138  N   GLU C 153       5.629 -13.336   1.692  1.00 25.75           N  
ATOM   6139  CA  GLU C 153       5.463 -11.961   1.174  1.00 25.94           C  
ATOM   6140  C   GLU C 153       6.735 -11.318   0.602  1.00 25.32           C  
ATOM   6141  O   GLU C 153       6.700 -10.675  -0.466  1.00 23.16           O  
ATOM   6142  CB  GLU C 153       4.925 -11.041   2.277  1.00 24.75           C  
ATOM   6143  CG  GLU C 153       4.848  -9.543   1.881  1.00 25.75           C  
ATOM   6144  CD  GLU C 153       4.285  -8.660   2.973  1.00 29.26           C  
ATOM   6145  OE1 GLU C 153       3.994  -9.190   4.064  1.00 38.51           O  
ATOM   6146  OE2 GLU C 153       4.152  -7.425   2.742  1.00 33.09           O  
ATOM   6147  N   ARG C 154       7.833 -11.436   1.341  1.00 25.29           N  
ATOM   6148  CA  ARG C 154       9.116 -10.885   0.863  1.00 24.11           C  
ATOM   6149  C   ARG C 154       9.673 -11.696  -0.319  1.00 25.51           C  
ATOM   6150  O   ARG C 154      10.227 -11.118  -1.265  1.00 25.48           O  
ATOM   6151  CB  ARG C 154      10.115 -10.746   2.011  1.00 25.56           C  
ATOM   6152  CG  ARG C 154      10.587 -12.056   2.709  1.00 29.42           C  
ATOM   6153  CD  ARG C 154      11.812 -11.787   3.543  1.00 30.59           C  
ATOM   6154  NE  ARG C 154      12.965 -11.428   2.699  1.00 30.80           N  
ATOM   6155  CZ  ARG C 154      14.114 -10.892   3.116  1.00 25.22           C  
ATOM   6156  NH1 ARG C 154      14.329 -10.638   4.395  1.00 27.05           N  
ATOM   6157  NH2 ARG C 154      15.054 -10.607   2.222  1.00 36.88           N  
ATOM   6158  N   ASN C 155       9.512 -13.026  -0.284  1.00 25.85           N  
ATOM   6159  CA  ASN C 155       9.915 -13.876  -1.432  1.00 26.26           C  
ATOM   6160  C   ASN C 155       9.098 -13.500  -2.657  1.00 26.20           C  
ATOM   6161  O   ASN C 155       9.678 -13.352  -3.716  1.00 25.01           O  
ATOM   6162  CB  ASN C 155       9.767 -15.389  -1.166  1.00 25.32           C  
ATOM   6163  CG  ASN C 155      10.862 -15.942  -0.259  1.00 29.73           C  
ATOM   6164  OD1 ASN C 155      11.863 -15.257   0.057  1.00 26.29           O  
ATOM   6165  ND2 ASN C 155      10.691 -17.202   0.148  1.00 24.66           N  
ATOM   6166  N   GLU C 156       7.791 -13.281  -2.486  1.00 23.72           N  
ATOM   6167  CA  GLU C 156       6.927 -12.935  -3.627  1.00 27.39           C  
ATOM   6168  C   GLU C 156       7.163 -11.550  -4.235  1.00 29.67           C  
ATOM   6169  O   GLU C 156       6.909 -11.363  -5.422  1.00 30.97           O  
ATOM   6170  CB  GLU C 156       5.474 -13.210  -3.296  1.00 28.99           C  
ATOM   6171  CG  GLU C 156       5.280 -14.765  -3.181  1.00 29.30           C  
ATOM   6172  CD  GLU C 156       3.961 -15.208  -2.625  1.00 30.03           C  
ATOM   6173  OE1 GLU C 156       3.205 -14.336  -2.140  1.00 33.81           O  
ATOM   6174  OE2 GLU C 156       3.702 -16.449  -2.654  1.00 28.00           O  
ATOM   6175  N   PHE C 157       7.639 -10.597  -3.425  1.00 30.08           N  
ATOM   6176  CA  PHE C 157       8.090  -9.277  -3.907  1.00 27.87           C  
ATOM   6177  C   PHE C 157       9.160  -9.529  -4.986  1.00 27.14           C  
ATOM   6178  O   PHE C 157       9.002  -9.096  -6.117  1.00 24.06           O  
ATOM   6179  CB  PHE C 157       8.611  -8.448  -2.708  1.00 26.60           C  
ATOM   6180  CG  PHE C 157       9.344  -7.184  -3.072  1.00 24.66           C  
ATOM   6181  CD1 PHE C 157       8.651  -6.030  -3.386  1.00 22.32           C  
ATOM   6182  CD2 PHE C 157      10.737  -7.139  -3.055  1.00 26.80           C  
ATOM   6183  CE1 PHE C 157       9.334  -4.879  -3.705  1.00 21.08           C  
ATOM   6184  CE2 PHE C 157      11.418  -5.992  -3.370  1.00 21.40           C  
ATOM   6185  CZ  PHE C 157      10.710  -4.861  -3.683  1.00 16.93           C  
ATOM   6186  N   ILE C 158      10.208 -10.279  -4.619  1.00 28.94           N  
ATOM   6187  CA  ILE C 158      11.307 -10.652  -5.535  1.00 30.12           C  
ATOM   6188  C   ILE C 158      10.847 -11.456  -6.735  1.00 31.10           C  
ATOM   6189  O   ILE C 158      11.278 -11.175  -7.855  1.00 30.37           O  
ATOM   6190  CB  ILE C 158      12.427 -11.471  -4.838  1.00 29.92           C  
ATOM   6191  CG1 ILE C 158      13.199 -10.587  -3.858  1.00 35.32           C  
ATOM   6192  CG2 ILE C 158      13.409 -12.098  -5.896  1.00 29.13           C  
ATOM   6193  CD1 ILE C 158      14.065  -9.470  -4.494  1.00 31.39           C  
ATOM   6194  N   ILE C 159       9.994 -12.452  -6.484  1.00 31.74           N  
ATOM   6195  CA  ILE C 159       9.436 -13.314  -7.543  1.00 33.56           C  
ATOM   6196  C   ILE C 159       8.600 -12.534  -8.570  1.00 33.59           C  
ATOM   6197  O   ILE C 159       8.734 -12.793  -9.770  1.00 35.14           O  
ATOM   6198  CB  ILE C 159       8.617 -14.568  -6.959  1.00 33.29           C  
ATOM   6199  CG1 ILE C 159       9.573 -15.606  -6.320  1.00 34.60           C  
ATOM   6200  CG2 ILE C 159       7.735 -15.205  -8.017  1.00 29.90           C  
ATOM   6201  CD1 ILE C 159      10.686 -16.191  -7.252  1.00 32.42           C  
ATOM   6202  N   ASP C 160       7.775 -11.592  -8.129  1.00 31.10           N  
ATOM   6203  CA  ASP C 160       6.989 -10.781  -9.068  1.00 31.63           C  
ATOM   6204  C   ASP C 160       7.905 -10.029 -10.052  1.00 34.44           C  
ATOM   6205  O   ASP C 160       7.624 -10.011 -11.256  1.00 34.50           O  
ATOM   6206  CB  ASP C 160       6.105  -9.799  -8.302  1.00 33.11           C  
ATOM   6207  CG  ASP C 160       5.337  -8.840  -9.206  1.00 35.51           C  
ATOM   6208  OD1 ASP C 160       5.955  -7.956  -9.854  1.00 50.95           O  
ATOM   6209  OD2 ASP C 160       4.091  -8.934  -9.219  1.00 50.58           O  
ATOM   6210  N   GLY C 161       8.998  -9.448  -9.548  1.00 34.47           N  
ATOM   6211  CA  GLY C 161       9.912  -8.675 -10.392  1.00 35.18           C  
ATOM   6212  C   GLY C 161      10.594  -9.527 -11.443  1.00 35.71           C  
ATOM   6213  O   GLY C 161      10.592  -9.191 -12.621  1.00 39.49           O  
ATOM   6214  N   TYR C 162      11.199 -10.626 -10.994  1.00 34.76           N  
ATOM   6215  CA  TYR C 162      11.837 -11.598 -11.868  1.00 32.30           C  
ATOM   6216  C   TYR C 162      10.903 -12.242 -12.886  1.00 33.49           C  
ATOM   6217  O   TYR C 162      11.331 -12.531 -14.006  1.00 33.66           O  
ATOM   6218  CB  TYR C 162      12.463 -12.703 -11.011  1.00 33.94           C  
ATOM   6219  CG  TYR C 162      13.848 -12.428 -10.454  1.00 35.13           C  
ATOM   6220  CD1 TYR C 162      14.392 -11.122 -10.392  1.00 26.10           C  
ATOM   6221  CD2 TYR C 162      14.601 -13.492  -9.930  1.00 37.60           C  
ATOM   6222  CE1 TYR C 162      15.668 -10.911  -9.886  1.00 19.23           C  
ATOM   6223  CE2 TYR C 162      15.870 -13.276  -9.389  1.00 39.79           C  
ATOM   6224  CZ  TYR C 162      16.386 -11.974  -9.357  1.00 32.56           C  
ATOM   6225  OH  TYR C 162      17.633 -11.761  -8.841  1.00 35.57           O  
ATOM   6226  N   GLU C 163       9.665 -12.531 -12.488  1.00 34.39           N  
ATOM   6227  CA  GLU C 163       8.670 -13.115 -13.414  1.00 35.68           C  
ATOM   6228  C   GLU C 163       8.194 -12.124 -14.484  1.00 34.64           C  
ATOM   6229  O   GLU C 163       7.880 -12.562 -15.585  1.00 34.26           O  
ATOM   6230  CB  GLU C 163       7.474 -13.726 -12.672  1.00 35.96           C  
ATOM   6231  CG  GLU C 163       7.797 -15.061 -12.007  1.00 37.85           C  
ATOM   6232  CD  GLU C 163       6.611 -15.660 -11.259  1.00 40.17           C  
ATOM   6233  OE1 GLU C 163       5.852 -14.888 -10.616  1.00 47.38           O  
ATOM   6234  OE2 GLU C 163       6.461 -16.907 -11.296  1.00 44.07           O  
ATOM   6235  N   LYS C 164       8.116 -10.823 -14.189  1.00 34.49           N  
ATOM   6236  CA  LYS C 164       7.762  -9.839 -15.241  1.00 36.76           C  
ATOM   6237  C   LYS C 164       8.800  -9.881 -16.398  1.00 36.57           C  
ATOM   6238  O   LYS C 164       8.442  -9.826 -17.581  1.00 34.64           O  
ATOM   6239  CB  LYS C 164       7.610  -8.424 -14.672  1.00 36.77           C  
ATOM   6240  CG  LYS C 164       6.427  -8.277 -13.735  1.00 39.93           C  
ATOM   6241  N   PHE C 165      10.073 -10.048 -16.043  1.00 36.19           N  
ATOM   6242  CA  PHE C 165      11.158 -10.182 -17.019  1.00 36.84           C  
ATOM   6243  C   PHE C 165      11.101 -11.532 -17.738  1.00 37.65           C  
ATOM   6244  O   PHE C 165      11.240 -11.573 -18.953  1.00 36.90           O  
ATOM   6245  CB  PHE C 165      12.517 -10.070 -16.329  1.00 36.78           C  
ATOM   6246  N   VAL C 166      10.913 -12.627 -16.986  1.00 38.01           N  
ATOM   6247  CA  VAL C 166      10.848 -13.998 -17.567  1.00 37.17           C  
ATOM   6248  C   VAL C 166       9.614 -14.187 -18.463  1.00 36.44           C  
ATOM   6249  O   VAL C 166       9.745 -14.696 -19.581  1.00 37.02           O  
ATOM   6250  CB  VAL C 166      10.873 -15.141 -16.481  1.00 36.90           C  
ATOM   6251  CG1 VAL C 166      10.783 -16.537 -17.139  1.00 35.73           C  
ATOM   6252  CG2 VAL C 166      12.119 -15.035 -15.564  1.00 41.90           C  
ATOM   6253  N   ASP C 167       8.441 -13.775 -17.972  1.00 36.01           N  
ATOM   6254  CA  ASP C 167       7.179 -13.905 -18.736  1.00 35.95           C  
ATOM   6255  C   ASP C 167       7.010 -12.828 -19.828  1.00 36.18           C  
ATOM   6256  O   ASP C 167       6.372 -13.093 -20.839  1.00 36.51           O  
ATOM   6257  CB  ASP C 167       5.968 -13.922 -17.802  1.00 36.31           C  
ATOM   6258  CG  ASP C 167       5.923 -15.168 -16.869  1.00 42.86           C  
ATOM   6259  OD1 ASP C 167       6.619 -16.187 -17.117  1.00 50.89           O  
ATOM   6260  OD2 ASP C 167       5.141 -15.133 -15.888  1.00 44.89           O  
ATOM   6261  N   ASN C 168       7.545 -11.624 -19.624  1.00 35.77           N  
ATOM   6262  CA  ASN C 168       7.537 -10.574 -20.664  1.00 36.28           C  
ATOM   6263  C   ASN C 168       8.929  -9.879 -20.695  1.00 35.91           C  
ATOM   6264  O   ASN C 168       9.142  -8.894 -20.002  1.00 34.40           O  
ATOM   6265  CB  ASN C 168       6.388  -9.558 -20.503  1.00 35.36           C  
ATOM   6266  CG  ASN C 168       6.390  -8.475 -21.605  1.00 33.77           C  
ATOM   6267  OD1 ASN C 168       6.984  -8.639 -22.673  1.00 37.21           O  
ATOM   6268  ND2 ASN C 168       5.734  -7.366 -21.336  1.00 27.49           N  
ATOM   6269  N   PRO C 169       9.881 -10.426 -21.481  1.00 37.20           N  
ATOM   6270  CA  PRO C 169      11.229  -9.858 -21.654  1.00 39.54           C  
ATOM   6271  C   PRO C 169      11.373  -8.759 -22.741  1.00 39.92           C  
ATOM   6272  O   PRO C 169      11.216  -9.048 -23.925  1.00 39.49           O  
ATOM   6273  CB  PRO C 169      12.048 -11.078 -22.039  1.00 40.24           C  
ATOM   6274  CG  PRO C 169      11.031 -11.991 -22.693  1.00 37.33           C  
ATOM   6275  CD  PRO C 169       9.736 -11.727 -22.172  1.00 37.88           C  
ATOM   6276  N   THR C 170      11.680  -7.528 -22.297  1.00 41.07           N  
ATOM   6277  CA  THR C 170      11.888  -6.316 -23.131  1.00 39.39           C  
ATOM   6278  C   THR C 170      13.029  -5.427 -22.472  1.00 40.53           C  
ATOM   6279  O   THR C 170      13.508  -5.810 -21.409  1.00 41.21           O  
ATOM   6280  CB  THR C 170      10.637  -5.584 -23.234  1.00 38.75           C  
ATOM   6281  OG1 THR C 170      10.274  -5.172 -21.912  1.00 44.80           O  
ATOM   6282  CG2 THR C 170       9.574  -6.480 -23.825  1.00 36.08           C  
ATOM   6283  N   PRO C 171      13.502  -4.302 -23.103  1.00 38.14           N  
ATOM   6284  CA  PRO C 171      14.571  -3.521 -22.413  1.00 36.76           C  
ATOM   6285  C   PRO C 171      14.170  -2.834 -21.109  1.00 35.95           C  
ATOM   6286  O   PRO C 171      15.034  -2.611 -20.255  1.00 32.13           O  
ATOM   6287  CB  PRO C 171      14.954  -2.426 -23.419  1.00 35.60           C  
ATOM   6288  CG  PRO C 171      14.329  -2.770 -24.682  1.00 37.63           C  
ATOM   6289  CD  PRO C 171      13.204  -3.728 -24.432  1.00 39.28           C  
ATOM   6290  N   LYS C 172      12.892  -2.472 -20.987  1.00 32.48           N  
ATOM   6291  CA  LYS C 172      12.385  -1.822 -19.792  1.00 31.88           C  
ATOM   6292  C   LYS C 172      12.262  -2.883 -18.699  1.00 31.69           C  
ATOM   6293  O   LYS C 172      12.775  -2.668 -17.609  1.00 32.39           O  
ATOM   6294  CB  LYS C 172      11.054  -1.122 -20.073  1.00 32.64           C  
ATOM   6295  CG  LYS C 172      10.580  -0.119 -19.002  1.00 32.80           C  
ATOM   6296  CD  LYS C 172       9.234   0.504 -19.384  1.00 31.45           C  
ATOM   6297  CE  LYS C 172       8.793   1.575 -18.393  1.00 31.92           C  
ATOM   6298  NZ  LYS C 172       9.682   2.791 -18.359  1.00 35.28           N  
ATOM   6299  N   THR C 173      11.660  -4.037 -19.003  1.00 31.33           N  
ATOM   6300  CA  THR C 173      11.463  -5.085 -17.997  1.00 31.83           C  
ATOM   6301  C   THR C 173      12.754  -5.754 -17.603  1.00 31.13           C  
ATOM   6302  O   THR C 173      12.827  -6.295 -16.502  1.00 31.30           O  
ATOM   6303  CB  THR C 173      10.460  -6.236 -18.401  1.00 33.83           C  
ATOM   6304  OG1 THR C 173      11.106  -7.206 -19.251  1.00 35.59           O  
ATOM   6305  CG2 THR C 173       9.191  -5.691 -19.018  1.00 29.59           C  
ATOM   6306  N   PHE C 174      13.741  -5.752 -18.511  1.00 29.47           N  
ATOM   6307  CA  PHE C 174      15.074  -6.323 -18.263  1.00 27.86           C  
ATOM   6308  C   PHE C 174      15.781  -5.415 -17.270  1.00 25.02           C  
ATOM   6309  O   PHE C 174      16.275  -5.863 -16.220  1.00 25.94           O  
ATOM   6310  CB  PHE C 174      15.841  -6.414 -19.589  1.00 28.54           C  
ATOM   6311  CG  PHE C 174      17.146  -7.111 -19.499  1.00 26.54           C  
ATOM   6312  CD1 PHE C 174      18.285  -6.431 -19.190  1.00 28.70           C  
ATOM   6313  CD2 PHE C 174      17.253  -8.447 -19.811  1.00 41.12           C  
ATOM   6314  CE1 PHE C 174      19.485  -7.070 -19.092  1.00 29.04           C  
ATOM   6315  CE2 PHE C 174      18.472  -9.074 -19.743  1.00 42.70           C  
ATOM   6316  CZ  PHE C 174      19.589  -8.369 -19.373  1.00 23.76           C  
ATOM   6317  N   LEU C 175      15.797  -4.128 -17.587  1.00 23.52           N  
ATOM   6318  CA  LEU C 175      16.364  -3.137 -16.701  1.00 22.41           C  
ATOM   6319  C   LEU C 175      15.714  -3.199 -15.305  1.00 22.50           C  
ATOM   6320  O   LEU C 175      16.401  -3.067 -14.300  1.00 19.23           O  
ATOM   6321  CB  LEU C 175      16.142  -1.733 -17.258  1.00 23.33           C  
ATOM   6322  CG  LEU C 175      16.823  -0.606 -16.495  1.00 20.13           C  
ATOM   6323  CD1 LEU C 175      18.309  -0.627 -16.835  1.00 26.04           C  
ATOM   6324  CD2 LEU C 175      16.218   0.722 -16.851  1.00 23.42           C  
ATOM   6325  N   GLU C 176      14.398  -3.355 -15.274  1.00 20.42           N  
ATOM   6326  CA  GLU C 176      13.642  -3.478 -14.036  1.00 18.28           C  
ATOM   6327  C   GLU C 176      14.046  -4.724 -13.245  1.00 17.87           C  
ATOM   6328  O   GLU C 176      14.247  -4.623 -12.033  1.00 17.08           O  
ATOM   6329  CB  GLU C 176      12.135  -3.452 -14.303  1.00 17.99           C  
ATOM   6330  CG  GLU C 176      11.633  -2.045 -14.661  1.00 12.34           C  
ATOM   6331  CD  GLU C 176      10.204  -2.000 -15.076  1.00 20.74           C  
ATOM   6332  OE1 GLU C 176       9.524  -3.032 -14.988  1.00 19.44           O  
ATOM   6333  OE2 GLU C 176       9.746  -0.905 -15.490  1.00 23.35           O  
ATOM   6334  N   SER C 177      14.231  -5.864 -13.921  1.00 16.08           N  
ATOM   6335  CA  SER C 177      14.627  -7.101 -13.212  1.00 22.13           C  
ATOM   6336  C   SER C 177      16.065  -7.031 -12.658  1.00 21.22           C  
ATOM   6337  O   SER C 177      16.344  -7.641 -11.634  1.00 24.07           O  
ATOM   6338  CB  SER C 177      14.449  -8.340 -14.063  1.00 22.35           C  
ATOM   6339  OG  SER C 177      15.446  -8.387 -15.015  1.00 25.68           O  
ATOM   6340  N   ILE C 178      16.937  -6.266 -13.306  1.00 23.98           N  
ATOM   6341  CA  ILE C 178      18.298  -5.999 -12.795  1.00 23.77           C  
ATOM   6342  C   ILE C 178      18.214  -5.277 -11.469  1.00 23.40           C  
ATOM   6343  O   ILE C 178      18.964  -5.557 -10.539  1.00 25.50           O  
ATOM   6344  CB  ILE C 178      19.135  -5.225 -13.838  1.00 24.75           C  
ATOM   6345  CG1 ILE C 178      19.509  -6.185 -14.971  1.00 28.01           C  
ATOM   6346  CG2 ILE C 178      20.416  -4.619 -13.204  1.00 28.83           C  
ATOM   6347  CD1 ILE C 178      20.175  -5.530 -16.088  1.00 23.03           C  
ATOM   6348  N   VAL C 179      17.275  -4.358 -11.344  1.00 24.41           N  
ATOM   6349  CA  VAL C 179      17.097  -3.722 -10.055  1.00 18.67           C  
ATOM   6350  C   VAL C 179      16.751  -4.768  -8.985  1.00 20.28           C  
ATOM   6351  O   VAL C 179      17.353  -4.774  -7.929  1.00 22.35           O  
ATOM   6352  CB  VAL C 179      16.059  -2.584 -10.077  1.00 22.45           C  
ATOM   6353  CG1 VAL C 179      15.912  -2.028  -8.704  1.00 19.33           C  
ATOM   6354  CG2 VAL C 179      16.495  -1.515 -11.051  1.00 16.28           C  
ATOM   6355  N   TYR C 180      15.812  -5.672  -9.269  1.00 19.83           N  
ATOM   6356  CA  TYR C 180      15.453  -6.734  -8.311  1.00 18.96           C  
ATOM   6357  C   TYR C 180      16.656  -7.631  -8.000  1.00 21.05           C  
ATOM   6358  O   TYR C 180      16.858  -8.051  -6.857  1.00 19.49           O  
ATOM   6359  CB  TYR C 180      14.271  -7.566  -8.807  1.00 23.25           C  
ATOM   6360  CG  TYR C 180      12.970  -6.864  -8.588  1.00 18.24           C  
ATOM   6361  CD1 TYR C 180      12.467  -5.980  -9.531  1.00 22.60           C  
ATOM   6362  CD2 TYR C 180      12.254  -7.059  -7.414  1.00 24.69           C  
ATOM   6363  CE1 TYR C 180      11.261  -5.307  -9.311  1.00 17.43           C  
ATOM   6364  CE2 TYR C 180      11.052  -6.427  -7.198  1.00 20.53           C  
ATOM   6365  CZ  TYR C 180      10.560  -5.546  -8.151  1.00 22.07           C  
ATOM   6366  OH  TYR C 180       9.362  -4.915  -7.929  1.00 23.05           O  
ATOM   6367  N   ASP C 181      17.441  -7.929  -9.022  1.00 22.09           N  
ATOM   6368  CA  ASP C 181      18.629  -8.718  -8.803  1.00 23.91           C  
ATOM   6369  C   ASP C 181      19.612  -8.129  -7.839  1.00 25.54           C  
ATOM   6370  O   ASP C 181      20.110  -8.843  -6.954  1.00 24.01           O  
ATOM   6371  CB  ASP C 181      19.354  -8.971 -10.073  1.00 21.37           C  
ATOM   6372  CG  ASP C 181      20.579  -9.807  -9.817  1.00 41.19           C  
ATOM   6373  OD1 ASP C 181      21.546  -9.257  -9.220  1.00 48.13           O  
ATOM   6374  OD2 ASP C 181      20.562 -11.010 -10.160  1.00 44.06           O  
ATOM   6375  N   VAL C 182      19.912  -6.842  -8.034  1.00 22.99           N  
ATOM   6376  CA  VAL C 182      20.776  -6.096  -7.153  1.00 22.35           C  
ATOM   6377  C   VAL C 182      20.215  -6.106  -5.719  1.00 22.42           C  
ATOM   6378  O   VAL C 182      20.994  -6.111  -4.758  1.00 25.48           O  
ATOM   6379  CB  VAL C 182      21.039  -4.643  -7.728  1.00 23.52           C  
ATOM   6380  CG1 VAL C 182      21.703  -3.776  -6.760  1.00 16.73           C  
ATOM   6381  CG2 VAL C 182      21.934  -4.747  -8.979  1.00 14.79           C  
ATOM   6382  N   ILE C 183      18.890  -6.091  -5.550  1.00 21.88           N  
ATOM   6383  CA  ILE C 183      18.283  -6.208  -4.204  1.00 18.17           C  
ATOM   6384  C   ILE C 183      18.519  -7.606  -3.601  1.00 22.04           C  
ATOM   6385  O   ILE C 183      18.849  -7.739  -2.432  1.00 22.09           O  
ATOM   6386  CB  ILE C 183      16.735  -5.914  -4.222  1.00 24.82           C  
ATOM   6387  CG1 ILE C 183      16.471  -4.437  -4.415  1.00 17.02           C  
ATOM   6388  CG2 ILE C 183      16.046  -6.403  -2.912  1.00 13.59           C  
ATOM   6389  CD1 ILE C 183      15.043  -4.113  -4.975  1.00 15.75           C  
ATOM   6390  N   LEU C 184      18.381  -8.647  -4.421  1.00 23.30           N  
ATOM   6391  CA  LEU C 184      18.536  -9.994  -3.960  1.00 26.05           C  
ATOM   6392  C   LEU C 184      19.989 -10.294  -3.553  1.00 26.58           C  
ATOM   6393  O   LEU C 184      20.242 -10.768  -2.452  1.00 28.95           O  
ATOM   6394  CB  LEU C 184      18.060 -10.964  -5.049  1.00 24.00           C  
ATOM   6395  CG  LEU C 184      18.099 -12.461  -4.729  1.00 35.69           C  
ATOM   6396  CD1 LEU C 184      17.899 -12.725  -3.254  1.00 44.86           C  
ATOM   6397  CD2 LEU C 184      17.073 -13.222  -5.571  1.00 31.39           C  
ATOM   6398  N   GLU C 185      20.935  -9.941  -4.417  1.00 20.64           N  
ATOM   6399  CA  GLU C 185      22.334 -10.165  -4.138  1.00 17.73           C  
ATOM   6400  C   GLU C 185      22.989  -9.134  -3.309  1.00 17.01           C  
ATOM   6401  O   GLU C 185      23.902  -9.462  -2.571  1.00 21.44           O  
ATOM   6402  CB  GLU C 185      23.080 -10.224  -5.454  1.00 18.90           C  
ATOM   6403  CG  GLU C 185      22.444 -11.150  -6.342  1.00 20.38           C  
ATOM   6404  CD  GLU C 185      23.367 -11.582  -7.403  1.00 29.55           C  
ATOM   6405  OE1 GLU C 185      23.622 -10.820  -8.363  1.00 42.77           O  
ATOM   6406  OE2 GLU C 185      23.811 -12.703  -7.279  1.00 29.70           O  
ATOM   6407  N   GLY C 186      22.509  -7.904  -3.365  1.00 16.79           N  
ATOM   6408  CA  GLY C 186      23.127  -6.800  -2.679  1.00 11.33           C  
ATOM   6409  C   GLY C 186      22.506  -6.288  -1.413  1.00 16.34           C  
ATOM   6410  O   GLY C 186      23.174  -5.531  -0.727  1.00 18.34           O  
ATOM   6411  N   LEU C 187      21.285  -6.702  -1.087  1.00 16.41           N  
ATOM   6412  CA  LEU C 187      20.622  -6.232   0.143  1.00 20.01           C  
ATOM   6413  C   LEU C 187      20.096  -7.408   0.990  1.00 20.85           C  
ATOM   6414  O   LEU C 187      20.295  -7.437   2.178  1.00 22.58           O  
ATOM   6415  CB  LEU C 187      19.522  -5.251  -0.229  1.00 14.01           C  
ATOM   6416  CG  LEU C 187      18.667  -4.617   0.871  1.00 17.11           C  
ATOM   6417  CD1 LEU C 187      19.577  -3.825   1.727  1.00 22.35           C  
ATOM   6418  CD2 LEU C 187      17.664  -3.702   0.240  1.00 27.74           C  
ATOM   6419  N   ASN C 188      19.451  -8.376   0.389  1.00 22.30           N  
ATOM   6420  CA  ASN C 188      18.952  -9.527   1.141  1.00 22.19           C  
ATOM   6421  C   ASN C 188      20.144 -10.333   1.696  1.00 22.23           C  
ATOM   6422  O   ASN C 188      20.245 -10.522   2.913  1.00 31.43           O  
ATOM   6423  CB  ASN C 188      18.014 -10.315   0.261  1.00 21.54           C  
ATOM   6424  CG  ASN C 188      16.858  -9.486  -0.237  1.00 18.17           C  
ATOM   6425  OD1 ASN C 188      16.502  -8.420   0.349  1.00 28.63           O  
ATOM   6426  ND2 ASN C 188      16.198  -9.979  -1.241  1.00 19.13           N  
ATOM   6427  N   PHE C 189      21.084 -10.713   0.825  1.00 31.97           N  
ATOM   6428  CA  PHE C 189      22.321 -11.471   1.232  1.00 32.89           C  
ATOM   6429  C   PHE C 189      23.322 -10.721   2.112  1.00 34.67           C  
ATOM   6430  O   PHE C 189      24.021 -11.387   2.928  1.00 29.59           O  
ATOM   6431  CB  PHE C 189      23.059 -12.072   0.050  1.00 34.86           C  
ATOM   6432  CG  PHE C 189      22.476 -13.368  -0.407  1.00 38.85           C  
ATOM   6433  CD1 PHE C 189      21.309 -13.369  -1.120  1.00 41.32           C  
ATOM   6434  CD2 PHE C 189      23.073 -14.594  -0.107  1.00 36.47           C  
ATOM   6435  CE1 PHE C 189      20.733 -14.532  -1.552  1.00 37.58           C  
ATOM   6436  CE2 PHE C 189      22.470 -15.785  -0.552  1.00 36.01           C  
ATOM   6437  CZ  PHE C 189      21.311 -15.744  -1.260  1.00 36.42           C  
ATOM   6438  N   TYR C 190      23.387  -9.384   1.949  1.00 33.37           N  
ATOM   6439  CA  TYR C 190      24.265  -8.562   2.795  1.00 31.62           C  
ATOM   6440  C   TYR C 190      23.756  -8.380   4.216  1.00 35.29           C  
ATOM   6441  O   TYR C 190      24.568  -8.358   5.191  1.00 34.17           O  
ATOM   6442  CB  TYR C 190      24.624  -7.246   2.134  1.00 29.44           C  
ATOM   6443  CG  TYR C 190      25.794  -7.430   1.181  1.00 25.03           C  
ATOM   6444  CD1 TYR C 190      25.623  -8.048  -0.057  1.00 23.89           C  
ATOM   6445  CD2 TYR C 190      27.110  -7.013   1.565  1.00 33.97           C  
ATOM   6446  CE1 TYR C 190      26.730  -8.220  -0.946  1.00 32.09           C  
ATOM   6447  CE2 TYR C 190      28.216  -7.169   0.702  1.00 39.65           C  
ATOM   6448  CZ  TYR C 190      28.028  -7.770  -0.555  1.00 33.62           C  
ATOM   6449  OH  TYR C 190      29.110  -7.906  -1.381  1.00 29.81           O  
ATOM   6450  N   SER C 191      22.438  -8.239   4.351  1.00 32.76           N  
ATOM   6451  CA  SER C 191      21.866  -8.181   5.669  1.00 35.25           C  
ATOM   6452  C   SER C 191      22.124  -9.470   6.351  1.00 31.33           C  
ATOM   6453  O   SER C 191      22.611  -9.454   7.463  1.00 34.84           O  
ATOM   6454  CB  SER C 191      20.373  -7.943   5.636  1.00 36.99           C  
ATOM   6455  OG  SER C 191      19.870  -8.133   6.953  1.00 46.39           O  
ATOM   6456  N   GLY C 192      21.762 -10.575   5.678  1.00 35.72           N  
ATOM   6457  CA  GLY C 192      21.983 -11.964   6.127  1.00 33.25           C  
ATOM   6458  C   GLY C 192      23.317 -12.267   6.791  1.00 29.99           C  
ATOM   6459  O   GLY C 192      23.368 -12.860   7.862  1.00 26.20           O  
ATOM   6460  N   PHE C 193      24.381 -11.844   6.104  1.00 29.83           N  
ATOM   6461  CA  PHE C 193      25.735 -12.034   6.572  1.00 30.02           C  
ATOM   6462  C   PHE C 193      25.925 -11.521   8.030  1.00 27.48           C  
ATOM   6463  O   PHE C 193      26.544 -12.228   8.828  1.00 23.55           O  
ATOM   6464  CB  PHE C 193      26.814 -11.376   5.651  1.00 31.52           C  
ATOM   6465  CG  PHE C 193      26.791 -11.798   4.157  1.00 37.15           C  
ATOM   6466  CD1 PHE C 193      26.480 -13.101   3.745  1.00 39.53           C  
ATOM   6467  CD2 PHE C 193      27.183 -10.878   3.170  1.00 36.90           C  
ATOM   6468  CE1 PHE C 193      26.498 -13.455   2.368  1.00 28.68           C  
ATOM   6469  CE2 PHE C 193      27.197 -11.227   1.801  1.00 35.91           C  
ATOM   6470  CZ  PHE C 193      26.853 -12.514   1.409  1.00 28.91           C  
ATOM   6471  N   ALA C 194      25.352 -10.347   8.359  1.00 24.56           N  
ATOM   6472  CA  ALA C 194      25.523  -9.672   9.665  1.00 24.58           C  
ATOM   6473  C   ALA C 194      25.328 -10.578  10.868  1.00 22.38           C  
ATOM   6474  O   ALA C 194      26.142 -10.580  11.767  1.00 22.03           O  
ATOM   6475  CB  ALA C 194      24.619  -8.461   9.777  1.00 20.56           C  
ATOM   6476  N   PHE C 195      24.270 -11.374  10.854  1.00 23.50           N  
ATOM   6477  CA  PHE C 195      24.005 -12.321  11.940  1.00 22.23           C  
ATOM   6478  C   PHE C 195      25.157 -13.343  12.130  1.00 19.32           C  
ATOM   6479  O   PHE C 195      25.575 -13.596  13.266  1.00 18.58           O  
ATOM   6480  CB  PHE C 195      22.666 -13.046  11.697  1.00 23.86           C  
ATOM   6481  CG  PHE C 195      22.485 -14.279  12.527  1.00 20.26           C  
ATOM   6482  CD1 PHE C 195      21.998 -14.214  13.782  1.00 15.01           C  
ATOM   6483  CD2 PHE C 195      22.813 -15.514  12.016  1.00 16.89           C  
ATOM   6484  CE1 PHE C 195      21.850 -15.368  14.553  1.00 23.38           C  
ATOM   6485  CE2 PHE C 195      22.680 -16.635  12.743  1.00 16.05           C  
ATOM   6486  CZ  PHE C 195      22.195 -16.602  14.003  1.00 10.44           C  
ATOM   6487  N   PHE C 196      25.645 -13.919  11.023  1.00 18.97           N  
ATOM   6488  CA  PHE C 196      26.711 -14.904  11.079  1.00 19.93           C  
ATOM   6489  C   PHE C 196      28.031 -14.291  11.512  1.00 19.32           C  
ATOM   6490  O   PHE C 196      28.810 -14.942  12.206  1.00 17.15           O  
ATOM   6491  CB  PHE C 196      26.878 -15.639   9.741  1.00 20.18           C  
ATOM   6492  CG  PHE C 196      25.649 -16.458   9.371  1.00 20.02           C  
ATOM   6493  CD1 PHE C 196      25.359 -17.634  10.028  1.00 26.19           C  
ATOM   6494  CD2 PHE C 196      24.745 -15.996   8.425  1.00 23.36           C  
ATOM   6495  CE1 PHE C 196      24.200 -18.347   9.731  1.00 22.08           C  
ATOM   6496  CE2 PHE C 196      23.603 -16.707   8.134  1.00 18.65           C  
ATOM   6497  CZ  PHE C 196      23.346 -17.880   8.765  1.00 24.66           C  
ATOM   6498  N   TYR C 197      28.304 -13.082  11.038  1.00 18.01           N  
ATOM   6499  CA  TYR C 197      29.499 -12.369  11.466  1.00 19.04           C  
ATOM   6500  C   TYR C 197      29.468 -11.990  12.917  1.00 16.74           C  
ATOM   6501  O   TYR C 197      30.506 -12.004  13.564  1.00 19.32           O  
ATOM   6502  CB  TYR C 197      29.793 -11.125  10.613  1.00 19.52           C  
ATOM   6503  CG  TYR C 197      30.055 -11.431   9.159  1.00 16.59           C  
ATOM   6504  CD1 TYR C 197      30.731 -12.604   8.765  1.00 21.64           C  
ATOM   6505  CD2 TYR C 197      29.708 -10.522   8.176  1.00 26.74           C  
ATOM   6506  CE1 TYR C 197      30.945 -12.887   7.450  1.00 25.01           C  
ATOM   6507  CE2 TYR C 197      29.976 -10.787   6.826  1.00 26.39           C  
ATOM   6508  CZ  TYR C 197      30.571 -11.966   6.468  1.00 32.27           C  
ATOM   6509  OH  TYR C 197      30.838 -12.224   5.130  1.00 25.68           O  
ATOM   6510  N   ASN C 198      28.303 -11.626  13.423  1.00 19.30           N  
ATOM   6511  CA  ASN C 198      28.158 -11.337  14.815  1.00 14.25           C  
ATOM   6512  C   ASN C 198      28.470 -12.547  15.706  1.00 13.74           C  
ATOM   6513  O   ASN C 198      29.067 -12.404  16.790  1.00 16.06           O  
ATOM   6514  CB  ASN C 198      26.751 -10.828  15.106  1.00 18.40           C  
ATOM   6515  CG  ASN C 198      26.579 -10.424  16.537  1.00 19.40           C  
ATOM   6516  OD1 ASN C 198      27.294  -9.560  17.036  1.00 25.50           O  
ATOM   6517  ND2 ASN C 198      25.615 -11.031  17.217  1.00 25.24           N  
ATOM   6518  N   LEU C 199      28.038 -13.730  15.284  1.00 16.57           N  
ATOM   6519  CA  LEU C 199      28.351 -14.940  16.023  1.00 15.67           C  
ATOM   6520  C   LEU C 199      29.870 -15.140  15.989  1.00 18.90           C  
ATOM   6521  O   LEU C 199      30.476 -15.352  17.036  1.00 17.38           O  
ATOM   6522  CB  LEU C 199      27.665 -16.176  15.398  1.00 17.42           C  
ATOM   6523  CG  LEU C 199      26.179 -16.480  15.559  1.00 12.03           C  
ATOM   6524  CD1 LEU C 199      25.760 -17.729  14.672  1.00 17.07           C  
ATOM   6525  CD2 LEU C 199      25.868 -16.645  17.093  1.00 17.30           C  
ATOM   6526  N   ALA C 200      30.474 -15.050  14.790  1.00 19.39           N  
ATOM   6527  CA  ALA C 200      31.915 -15.268  14.644  1.00 20.76           C  
ATOM   6528  C   ALA C 200      32.786 -14.308  15.461  1.00 21.39           C  
ATOM   6529  O   ALA C 200      33.800 -14.725  16.025  1.00 20.13           O  
ATOM   6530  CB  ALA C 200      32.320 -15.242  13.202  1.00 19.27           C  
ATOM   6531  N   ARG C 201      32.390 -13.049  15.563  1.00 22.14           N  
ATOM   6532  CA  ARG C 201      33.142 -12.101  16.388  1.00 24.39           C  
ATOM   6533  C   ARG C 201      33.022 -12.487  17.895  1.00 24.97           C  
ATOM   6534  O   ARG C 201      33.755 -11.964  18.724  1.00 21.09           O  
ATOM   6535  CB  ARG C 201      32.700 -10.645  16.123  1.00 23.43           C  
ATOM   6536  CG  ARG C 201      31.523 -10.249  16.976  1.00 27.01           C  
ATOM   6537  CD  ARG C 201      30.679  -9.140  16.469  1.00 27.46           C  
ATOM   6538  NE  ARG C 201      31.187  -7.852  16.829  1.00 32.08           N  
ATOM   6539  CZ  ARG C 201      30.446  -6.756  17.020  1.00 33.73           C  
ATOM   6540  NH1 ARG C 201      29.107  -6.754  16.921  1.00 25.76           N  
ATOM   6541  NH2 ARG C 201      31.062  -5.632  17.348  1.00 34.73           N  
ATOM   6542  N   ASN C 202      32.036 -13.329  18.239  1.00 23.28           N  
ATOM   6543  CA  ASN C 202      31.880 -13.874  19.587  1.00 23.83           C  
ATOM   6544  C   ASN C 202      32.405 -15.304  19.695  1.00 22.75           C  
ATOM   6545  O   ASN C 202      32.048 -16.019  20.624  1.00 24.98           O  
ATOM   6546  CB  ASN C 202      30.412 -13.753  20.015  1.00 22.85           C  
ATOM   6547  CG  ASN C 202      30.031 -12.323  20.248  1.00 23.69           C  
ATOM   6548  OD1 ASN C 202      30.269 -11.794  21.319  1.00 33.71           O  
ATOM   6549  ND2 ASN C 202      29.488 -11.672  19.246  1.00 18.16           N  
ATOM   6550  N   GLN C 203      33.278 -15.696  18.770  1.00 21.71           N  
ATOM   6551  CA  GLN C 203      33.867 -17.032  18.701  1.00 22.32           C  
ATOM   6552  C   GLN C 203      32.830 -18.192  18.593  1.00 21.59           C  
ATOM   6553  O   GLN C 203      33.025 -19.288  19.149  1.00 19.28           O  
ATOM   6554  CB  GLN C 203      34.861 -17.195  19.848  1.00 23.62           C  
ATOM   6555  CG  GLN C 203      35.877 -16.043  19.912  1.00 25.48           C  
ATOM   6556  N   LYS C 204      31.737 -17.937  17.867  1.00 18.73           N  
ATOM   6557  CA  LYS C 204      30.684 -18.925  17.637  1.00 18.61           C  
ATOM   6558  C   LYS C 204      30.495 -19.126  16.157  1.00 17.35           C  
ATOM   6559  O   LYS C 204      30.507 -18.151  15.423  1.00 17.47           O  
ATOM   6560  CB  LYS C 204      29.375 -18.462  18.243  1.00 20.64           C  
ATOM   6561  CG  LYS C 204      29.400 -18.233  19.774  1.00 18.82           C  
ATOM   6562  CD  LYS C 204      28.089 -17.563  20.176  1.00 18.61           C  
ATOM   6563  CE  LYS C 204      28.034 -17.133  21.637  1.00 27.72           C  
ATOM   6564  NZ  LYS C 204      26.594 -16.997  22.010  1.00 31.90           N  
HETATM 6565  N   MSE C 205      30.391 -20.395  15.727  1.00 17.35           N  
HETATM 6566  CA  MSE C 205      30.086 -20.772  14.349  1.00 16.37           C  
HETATM 6567  C   MSE C 205      31.007 -20.117  13.336  1.00 16.71           C  
HETATM 6568  O   MSE C 205      30.601 -19.613  12.265  1.00 14.15           O  
HETATM 6569  CB  MSE C 205      28.612 -20.475  14.033  1.00 17.27           C  
HETATM 6570  CG  MSE C 205      27.613 -21.038  15.027  1.00 12.98           C  
HETATM 6571 SE   MSE C 205      27.823 -22.938  15.538  0.75 12.86          SE  
HETATM 6572  CE  MSE C 205      27.273 -23.580  13.882  1.00  7.46           C  
ATOM   6573  N   VAL C 206      32.281 -20.199  13.672  1.00 16.09           N  
ATOM   6574  CA  VAL C 206      33.326 -19.601  12.881  1.00 16.49           C  
ATOM   6575  C   VAL C 206      33.471 -20.264  11.543  1.00 14.05           C  
ATOM   6576  O   VAL C 206      33.779 -19.565  10.578  1.00 19.28           O  
ATOM   6577  CB  VAL C 206      34.671 -19.552  13.680  1.00 17.16           C  
ATOM   6578  CG1 VAL C 206      35.793 -18.992  12.829  1.00 20.13           C  
ATOM   6579  CG2 VAL C 206      34.465 -18.725  14.955  1.00 15.72           C  
ATOM   6580  N   SER C 207      33.236 -21.571  11.426  1.00 14.31           N  
ATOM   6581  CA  SER C 207      33.367 -22.197  10.097  1.00 15.46           C  
ATOM   6582  C   SER C 207      32.201 -21.808   9.162  1.00 17.13           C  
ATOM   6583  O   SER C 207      32.390 -21.608   7.942  1.00 18.90           O  
ATOM   6584  CB  SER C 207      33.495 -23.697  10.198  1.00 17.33           C  
ATOM   6585  OG  SER C 207      34.557 -24.047  11.060  1.00 26.32           O  
ATOM   6586  N   THR C 208      31.001 -21.692   9.724  1.00 17.49           N  
ATOM   6587  CA  THR C 208      29.848 -21.216   8.960  1.00 18.47           C  
ATOM   6588  C   THR C 208      30.125 -19.783   8.487  1.00 17.90           C  
ATOM   6589  O   THR C 208      29.756 -19.417   7.380  1.00 19.05           O  
ATOM   6590  CB  THR C 208      28.573 -21.193   9.820  1.00 19.60           C  
ATOM   6591  OG1 THR C 208      28.316 -22.503  10.330  1.00 13.59           O  
ATOM   6592  CG2 THR C 208      27.327 -20.732   9.004  1.00 17.13           C  
ATOM   6593  N   SER C 209      30.744 -18.978   9.341  1.00 20.01           N  
ATOM   6594  CA  SER C 209      31.100 -17.592   9.040  1.00 20.14           C  
ATOM   6595  C   SER C 209      32.105 -17.502   7.872  1.00 20.96           C  
ATOM   6596  O   SER C 209      32.043 -16.563   7.078  1.00 19.88           O  
ATOM   6597  CB  SER C 209      31.682 -16.925  10.285  1.00 23.01           C  
ATOM   6598  OG  SER C 209      31.893 -15.552  10.062  1.00 30.69           O  
ATOM   6599  N   THR C 210      33.038 -18.451   7.823  1.00 17.63           N  
ATOM   6600  CA  THR C 210      34.063 -18.524   6.764  1.00 21.31           C  
ATOM   6601  C   THR C 210      33.379 -18.776   5.452  1.00 21.92           C  
ATOM   6602  O   THR C 210      33.690 -18.138   4.440  1.00 22.52           O  
ATOM   6603  CB  THR C 210      35.034 -19.658   7.030  1.00 22.75           C  
ATOM   6604  OG1 THR C 210      35.713 -19.360   8.242  1.00 27.44           O  
ATOM   6605  CG2 THR C 210      36.029 -19.829   5.892  1.00 24.38           C  
HETATM 6606  N   MSE C 211      32.401 -19.675   5.477  1.00 18.70           N  
HETATM 6607  CA  MSE C 211      31.646 -19.975   4.269  1.00 22.97           C  
HETATM 6608  C   MSE C 211      30.805 -18.792   3.829  1.00 18.40           C  
HETATM 6609  O   MSE C 211      30.758 -18.471   2.652  1.00 20.95           O  
HETATM 6610  CB  MSE C 211      30.754 -21.175   4.470  1.00 20.34           C  
HETATM 6611  CG  MSE C 211      30.460 -21.866   3.169  1.00 24.88           C  
HETATM 6612 SE   MSE C 211      29.481 -23.341   3.654  0.75 30.62          SE  
HETATM 6613  CE  MSE C 211      30.810 -24.565   4.225  1.00 11.34           C  
ATOM   6614  N   ILE C 212      30.083 -18.194   4.757  1.00 19.63           N  
ATOM   6615  CA  ILE C 212      29.327 -16.965   4.496  1.00 22.08           C  
ATOM   6616  C   ILE C 212      30.227 -15.850   3.909  1.00 27.01           C  
ATOM   6617  O   ILE C 212      29.779 -15.089   3.036  1.00 32.07           O  
ATOM   6618  CB  ILE C 212      28.581 -16.496   5.791  1.00 22.37           C  
ATOM   6619  CG1 ILE C 212      27.385 -17.428   6.089  1.00 19.40           C  
ATOM   6620  CG2 ILE C 212      28.166 -15.029   5.720  1.00 25.82           C  
ATOM   6621  CD1 ILE C 212      26.325 -17.501   5.005  1.00 13.10           C  
ATOM   6622  N   ASN C 213      31.488 -15.799   4.343  1.00 25.45           N  
ATOM   6623  CA  ASN C 213      32.466 -14.840   3.816  1.00 26.29           C  
ATOM   6624  C   ASN C 213      32.852 -15.185   2.358  1.00 23.57           C  
ATOM   6625  O   ASN C 213      33.026 -14.293   1.517  1.00 22.36           O  
ATOM   6626  CB  ASN C 213      33.702 -14.794   4.716  1.00 27.99           C  
ATOM   6627  CG  ASN C 213      34.455 -13.489   4.606  1.00 42.38           C  
ATOM   6628  OD1 ASN C 213      35.641 -13.487   4.274  1.00 51.90           O  
ATOM   6629  ND2 ASN C 213      33.770 -12.361   4.877  1.00 35.94           N  
ATOM   6630  N   TYR C 214      32.998 -16.460   2.056  1.00 21.77           N  
ATOM   6631  CA  TYR C 214      33.227 -16.865   0.674  1.00 21.33           C  
ATOM   6632  C   TYR C 214      32.054 -16.481  -0.232  1.00 19.96           C  
ATOM   6633  O   TYR C 214      32.272 -15.987  -1.343  1.00 20.29           O  
ATOM   6634  CB  TYR C 214      33.523 -18.339   0.544  1.00 23.92           C  
ATOM   6635  CG  TYR C 214      34.898 -18.739   0.967  1.00 27.34           C  
ATOM   6636  CD1 TYR C 214      36.003 -18.306   0.257  1.00 39.55           C  
ATOM   6637  CD2 TYR C 214      35.102 -19.600   2.003  1.00 26.32           C  
ATOM   6638  CE1 TYR C 214      37.289 -18.673   0.631  1.00 41.47           C  
ATOM   6639  CE2 TYR C 214      36.371 -19.981   2.387  1.00 31.44           C  
ATOM   6640  CZ  TYR C 214      37.454 -19.521   1.710  1.00 38.48           C  
ATOM   6641  OH  TYR C 214      38.707 -19.917   2.097  1.00 36.73           O  
ATOM   6642  N   ILE C 215      30.835 -16.750   0.216  1.00 17.19           N  
ATOM   6643  CA  ILE C 215      29.608 -16.387  -0.515  1.00 18.81           C  
ATOM   6644  C   ILE C 215      29.579 -14.857  -0.743  1.00 20.11           C  
ATOM   6645  O   ILE C 215      29.305 -14.388  -1.857  1.00 19.56           O  
ATOM   6646  CB  ILE C 215      28.355 -16.902   0.232  1.00 15.79           C  
ATOM   6647  CG1 ILE C 215      28.270 -18.427   0.167  1.00  9.52           C  
ATOM   6648  CG2 ILE C 215      27.069 -16.347  -0.350  1.00 12.26           C  
ATOM   6649  CD1 ILE C 215      27.277 -19.069   1.101  1.00 12.85           C  
ATOM   6650  N   ASN C 216      29.866 -14.092   0.322  1.00 24.15           N  
ATOM   6651  CA  ASN C 216      29.996 -12.622   0.288  1.00 23.13           C  
ATOM   6652  C   ASN C 216      30.998 -12.117  -0.733  1.00 20.61           C  
ATOM   6653  O   ASN C 216      30.735 -11.128  -1.397  1.00 21.61           O  
ATOM   6654  CB  ASN C 216      30.389 -12.176   1.729  1.00 25.92           C  
ATOM   6655  CG  ASN C 216      30.520 -10.642   1.958  1.00 29.20           C  
ATOM   6656  OD1 ASN C 216      30.605 -10.236   3.135  1.00 29.70           O  
ATOM   6657  ND2 ASN C 216      30.517  -9.809   0.910  1.00 24.98           N  
ATOM   6658  N   ARG C 217      32.154 -12.755  -0.837  1.00 21.82           N  
ATOM   6659  CA  ARG C 217      33.164 -12.333  -1.793  1.00 23.15           C  
ATOM   6660  C   ARG C 217      32.576 -12.452  -3.214  1.00 25.30           C  
ATOM   6661  O   ARG C 217      32.733 -11.518  -4.033  1.00 23.52           O  
ATOM   6662  CB  ARG C 217      34.465 -13.141  -1.595  1.00 26.33           C  
ATOM   6663  CG  ARG C 217      35.638 -12.721  -2.487  1.00 25.10           C  
ATOM   6664  CD  ARG C 217      36.956 -13.470  -2.159  1.00 25.76           C  
ATOM   6665  NE  ARG C 217      36.825 -14.920  -2.357  1.00 28.61           N  
ATOM   6666  CZ  ARG C 217      37.802 -15.818  -2.227  1.00 38.25           C  
ATOM   6667  NH1 ARG C 217      39.063 -15.459  -1.971  1.00 41.29           N  
ATOM   6668  NH2 ARG C 217      37.529 -17.107  -2.426  1.00 39.78           N  
ATOM   6669  N   ASP C 218      31.900 -13.588  -3.486  1.00 21.51           N  
ATOM   6670  CA  ASP C 218      31.248 -13.843  -4.768  1.00 18.69           C  
ATOM   6671  C   ASP C 218      30.152 -12.857  -5.054  1.00 19.56           C  
ATOM   6672  O   ASP C 218      30.025 -12.321  -6.169  1.00 18.07           O  
ATOM   6673  CB  ASP C 218      30.613 -15.257  -4.832  1.00 18.91           C  
ATOM   6674  CG  ASP C 218      31.601 -16.364  -4.811  1.00 20.25           C  
ATOM   6675  OD1 ASP C 218      32.777 -16.115  -5.118  1.00 17.01           O  
ATOM   6676  OD2 ASP C 218      31.174 -17.523  -4.507  1.00 16.56           O  
ATOM   6677  N   GLU C 219      29.387 -12.557  -4.018  1.00 19.27           N  
ATOM   6678  CA  GLU C 219      28.275 -11.676  -4.122  1.00 19.02           C  
ATOM   6679  C   GLU C 219      28.634 -10.224  -4.526  1.00 14.90           C  
ATOM   6680  O   GLU C 219      27.879  -9.610  -5.262  1.00 18.59           O  
ATOM   6681  CB  GLU C 219      27.618 -11.595  -2.757  1.00 26.41           C  
ATOM   6682  CG  GLU C 219      26.216 -11.255  -2.791  1.00 33.82           C  
ATOM   6683  CD  GLU C 219      25.396 -12.428  -3.231  1.00 42.94           C  
ATOM   6684  OE1 GLU C 219      25.432 -12.703  -4.439  1.00 40.29           O  
ATOM   6685  OE2 GLU C 219      24.707 -13.032  -2.378  1.00 43.12           O  
ATOM   6686  N   GLN C 220      29.747  -9.719  -3.996  1.00 16.18           N  
ATOM   6687  CA  GLN C 220      30.301  -8.402  -4.313  1.00 19.45           C  
ATOM   6688  C   GLN C 220      30.471  -8.269  -5.825  1.00 16.58           C  
ATOM   6689  O   GLN C 220      30.118  -7.270  -6.429  1.00 16.08           O  
ATOM   6690  CB  GLN C 220      31.705  -8.207  -3.712  1.00 21.29           C  
ATOM   6691  CG  GLN C 220      31.893  -7.931  -2.223  1.00 38.59           C  
ATOM   6692  CD  GLN C 220      33.351  -7.530  -1.873  1.00 34.97           C  
ATOM   6693  OE1 GLN C 220      33.964  -6.677  -2.561  1.00 47.63           O  
ATOM   6694  NE2 GLN C 220      33.898  -8.136  -0.792  1.00 50.35           N  
ATOM   6695  N   LEU C 221      30.997  -9.328  -6.428  1.00 15.15           N  
ATOM   6696  CA  LEU C 221      31.236  -9.344  -7.862  1.00 14.62           C  
ATOM   6697  C   LEU C 221      29.950  -9.482  -8.691  1.00 13.59           C  
ATOM   6698  O   LEU C 221      29.842  -8.899  -9.759  1.00 10.23           O  
ATOM   6699  CB  LEU C 221      32.310 -10.374  -8.199  1.00 14.25           C  
ATOM   6700  CG  LEU C 221      33.753 -10.103  -7.693  1.00 22.79           C  
ATOM   6701  CD1 LEU C 221      34.607 -11.194  -8.236  1.00 12.48           C  
ATOM   6702  CD2 LEU C 221      34.362  -8.798  -8.144  1.00 19.03           C  
ATOM   6703  N   HIS C 222      28.955 -10.198  -8.180  1.00 14.38           N  
ATOM   6704  CA  HIS C 222      27.665 -10.307  -8.849  1.00 14.23           C  
ATOM   6705  C   HIS C 222      27.012  -8.948  -8.973  1.00 12.03           C  
ATOM   6706  O   HIS C 222      26.493  -8.591 -10.012  1.00 14.18           O  
ATOM   6707  CB  HIS C 222      26.744 -11.249  -8.035  1.00 15.89           C  
ATOM   6708  CG  HIS C 222      27.220 -12.672  -8.007  1.00 20.13           C  
ATOM   6709  ND1 HIS C 222      26.484 -13.697  -7.463  1.00 22.02           N  
ATOM   6710  CD2 HIS C 222      28.332 -13.247  -8.527  1.00 17.10           C  
ATOM   6711  CE1 HIS C 222      27.132 -14.843  -7.629  1.00 13.59           C  
ATOM   6712  NE2 HIS C 222      28.264 -14.592  -8.263  1.00 18.47           N  
ATOM   6713  N   VAL C 223      27.025  -8.212  -7.874  1.00 14.18           N  
ATOM   6714  CA  VAL C 223      26.475  -6.874  -7.825  1.00 14.44           C  
ATOM   6715  C   VAL C 223      27.227  -5.940  -8.825  1.00 13.64           C  
ATOM   6716  O   VAL C 223      26.615  -5.137  -9.546  1.00 11.54           O  
ATOM   6717  CB  VAL C 223      26.535  -6.338  -6.393  1.00 16.74           C  
ATOM   6718  CG1 VAL C 223      26.095  -4.914  -6.339  1.00 10.75           C  
ATOM   6719  CG2 VAL C 223      25.657  -7.146  -5.442  1.00 22.61           C  
ATOM   6720  N   TYR C 224      28.548  -6.120  -8.915  1.00 13.80           N  
ATOM   6721  CA  TYR C 224      29.392  -5.334  -9.808  1.00 13.75           C  
ATOM   6722  C   TYR C 224      28.967  -5.592 -11.234  1.00 12.47           C  
ATOM   6723  O   TYR C 224      28.791  -4.648 -12.001  1.00 13.60           O  
ATOM   6724  CB  TYR C 224      30.883  -5.682  -9.563  1.00 15.74           C  
ATOM   6725  CG  TYR C 224      31.853  -5.107 -10.544  1.00 15.24           C  
ATOM   6726  CD1 TYR C 224      32.255  -3.785 -10.471  1.00 13.60           C  
ATOM   6727  CD2 TYR C 224      32.367  -5.898 -11.558  1.00 17.29           C  
ATOM   6728  CE1 TYR C 224      33.155  -3.267 -11.389  1.00 22.58           C  
ATOM   6729  CE2 TYR C 224      33.246  -5.402 -12.461  1.00 23.05           C  
ATOM   6730  CZ  TYR C 224      33.641  -4.102 -12.381  1.00 17.81           C  
ATOM   6731  OH  TYR C 224      34.546  -3.655 -13.308  1.00 24.09           O  
ATOM   6732  N   LEU C 225      28.743  -6.859 -11.587  1.00 12.75           N  
ATOM   6733  CA  LEU C 225      28.300  -7.192 -12.935  1.00 11.31           C  
ATOM   6734  C   LEU C 225      26.944  -6.575 -13.254  1.00 12.59           C  
ATOM   6735  O   LEU C 225      26.789  -5.926 -14.273  1.00 12.94           O  
ATOM   6736  CB  LEU C 225      28.179  -8.686 -13.087  1.00 11.55           C  
ATOM   6737  CG  LEU C 225      27.697  -9.271 -14.449  1.00 13.21           C  
ATOM   6738  CD1 LEU C 225      28.509  -8.763 -15.655  1.00 11.71           C  
ATOM   6739  CD2 LEU C 225      27.763 -10.767 -14.315  1.00  9.54           C  
ATOM   6740  N   PHE C 226      25.970  -6.790 -12.380  1.00 17.50           N  
ATOM   6741  CA  PHE C 226      24.587  -6.313 -12.627  1.00 15.58           C  
ATOM   6742  C   PHE C 226      24.487  -4.811 -12.673  1.00 15.54           C  
ATOM   6743  O   PHE C 226      23.789  -4.269 -13.519  1.00 13.60           O  
ATOM   6744  CB  PHE C 226      23.599  -6.916 -11.607  1.00 18.04           C  
ATOM   6745  CG  PHE C 226      23.181  -8.343 -11.927  1.00 15.54           C  
ATOM   6746  CD1 PHE C 226      22.383  -8.595 -13.008  1.00 21.33           C  
ATOM   6747  CD2 PHE C 226      23.604  -9.408 -11.187  1.00 31.07           C  
ATOM   6748  CE1 PHE C 226      21.951  -9.863 -13.304  1.00 24.24           C  
ATOM   6749  CE2 PHE C 226      23.211 -10.694 -11.513  1.00 12.44           C  
ATOM   6750  CZ  PHE C 226      22.376 -10.909 -12.582  1.00 25.77           C  
ATOM   6751  N   THR C 227      25.190  -4.122 -11.771  1.00 13.03           N  
ATOM   6752  CA  THR C 227      25.210  -2.664 -11.802  1.00 13.10           C  
ATOM   6753  C   THR C 227      25.907  -2.124 -13.043  1.00 11.34           C  
ATOM   6754  O   THR C 227      25.463  -1.118 -13.600  1.00 13.98           O  
ATOM   6755  CB  THR C 227      25.724  -2.050 -10.475  1.00 16.40           C  
ATOM   6756  OG1 THR C 227      27.046  -2.490 -10.192  1.00 13.28           O  
ATOM   6757  CG2 THR C 227      24.826  -2.426  -9.304  1.00 11.34           C  
ATOM   6758  N   ASN C 228      26.973  -2.786 -13.511  1.00 12.88           N  
ATOM   6759  CA  ASN C 228      27.610  -2.385 -14.744  1.00 13.41           C  
ATOM   6760  C   ASN C 228      26.634  -2.529 -15.942  1.00 14.49           C  
ATOM   6761  O   ASN C 228      26.566  -1.656 -16.808  1.00 14.62           O  
ATOM   6762  CB  ASN C 228      28.898  -3.190 -15.019  1.00 16.68           C  
ATOM   6763  CG  ASN C 228      30.093  -2.743 -14.199  1.00 17.60           C  
ATOM   6764  OD1 ASN C 228      30.050  -1.795 -13.416  1.00 19.54           O  
ATOM   6765  ND2 ASN C 228      31.183  -3.455 -14.379  1.00 22.00           N  
ATOM   6766  N   ILE C 229      25.901  -3.637 -15.983  1.00 13.33           N  
ATOM   6767  CA  ILE C 229      24.893  -3.886 -17.042  1.00 12.82           C  
ATOM   6768  C   ILE C 229      23.811  -2.800 -17.013  1.00 14.04           C  
ATOM   6769  O   ILE C 229      23.523  -2.196 -18.038  1.00 16.64           O  
ATOM   6770  CB  ILE C 229      24.320  -5.297 -16.945  1.00 13.68           C  
ATOM   6771  CG1 ILE C 229      25.396  -6.307 -17.354  1.00 13.95           C  
ATOM   6772  CG2 ILE C 229      23.103  -5.436 -17.874  1.00 13.28           C  
ATOM   6773  CD1 ILE C 229      25.051  -7.725 -17.048  1.00 13.51           C  
ATOM   6774  N   PHE C 230      23.299  -2.499 -15.823  1.00 14.29           N  
ATOM   6775  CA  PHE C 230      22.293  -1.426 -15.637  1.00 15.18           C  
ATOM   6776  C   PHE C 230      22.748  -0.119 -16.263  1.00 17.52           C  
ATOM   6777  O   PHE C 230      22.020   0.465 -17.082  1.00 16.09           O  
ATOM   6778  CB  PHE C 230      22.003  -1.243 -14.161  1.00 14.77           C  
ATOM   6779  CG  PHE C 230      20.905  -0.262 -13.850  1.00 10.11           C  
ATOM   6780  CD1 PHE C 230      21.193   1.072 -13.691  1.00 16.65           C  
ATOM   6781  CD2 PHE C 230      19.599  -0.698 -13.672  1.00 17.53           C  
ATOM   6782  CE1 PHE C 230      20.195   1.971 -13.408  1.00 13.89           C  
ATOM   6783  CE2 PHE C 230      18.594   0.209 -13.356  1.00 23.98           C  
ATOM   6784  CZ  PHE C 230      18.900   1.524 -13.230  1.00 18.24           C  
ATOM   6785  N   LYS C 231      23.972   0.309 -15.939  1.00 20.89           N  
ATOM   6786  CA  LYS C 231      24.534   1.585 -16.464  1.00 19.91           C  
ATOM   6787  C   LYS C 231      24.765   1.590 -17.959  1.00 22.85           C  
ATOM   6788  O   LYS C 231      24.550   2.607 -18.607  1.00 25.32           O  
ATOM   6789  CB  LYS C 231      25.802   1.993 -15.681  1.00 22.74           C  
ATOM   6790  CG  LYS C 231      25.440   2.507 -14.247  1.00 22.16           C  
ATOM   6791  CD  LYS C 231      26.635   2.853 -13.291  1.00 24.36           C  
ATOM   6792  CE  LYS C 231      27.407   1.644 -12.843  1.00 31.44           C  
ATOM   6793  NZ  LYS C 231      28.298   1.836 -11.625  1.00 32.56           N  
ATOM   6794  N   GLU C 232      25.164   0.446 -18.501  1.00 22.09           N  
ATOM   6795  CA  GLU C 232      25.351   0.273 -19.935  1.00 24.21           C  
ATOM   6796  C   GLU C 232      24.020   0.276 -20.706  1.00 24.31           C  
ATOM   6797  O   GLU C 232      23.952   0.799 -21.823  1.00 24.22           O  
ATOM   6798  CB  GLU C 232      26.167  -0.979 -20.208  1.00 25.53           C  
ATOM   6799  CG  GLU C 232      27.663  -0.851 -19.754  1.00 38.03           C  
ATOM   6800  CD  GLU C 232      28.449   0.289 -20.443  1.00 43.43           C  
ATOM   6801  OE1 GLU C 232      28.082   0.687 -21.570  1.00 39.19           O  
ATOM   6802  OE2 GLU C 232      29.436   0.773 -19.848  1.00 51.80           O  
ATOM   6803  N   LEU C 233      22.972  -0.268 -20.091  1.00 24.67           N  
ATOM   6804  CA  LEU C 233      21.629  -0.239 -20.664  1.00 22.88           C  
ATOM   6805  C   LEU C 233      21.093   1.176 -20.752  1.00 25.08           C  
ATOM   6806  O   LEU C 233      20.421   1.476 -21.726  1.00 26.53           O  
ATOM   6807  CB  LEU C 233      20.652  -1.168 -19.908  1.00 20.71           C  
ATOM   6808  CG  LEU C 233      20.952  -2.633 -20.180  1.00 21.78           C  
ATOM   6809  CD1 LEU C 233      20.266  -3.577 -19.251  1.00 30.76           C  
ATOM   6810  CD2 LEU C 233      20.612  -2.965 -21.665  1.00 10.28           C  
ATOM   6811  N   LEU C 234      21.370   2.035 -19.763  1.00 25.52           N  
ATOM   6812  CA  LEU C 234      20.945   3.437 -19.850  1.00 26.90           C  
ATOM   6813  C   LEU C 234      21.700   4.169 -20.970  1.00 28.08           C  
ATOM   6814  O   LEU C 234      21.118   5.060 -21.592  1.00 29.40           O  
ATOM   6815  CB  LEU C 234      21.043   4.196 -18.507  1.00 24.20           C  
ATOM   6816  CG  LEU C 234      20.180   3.674 -17.353  1.00 28.92           C  
ATOM   6817  CD1 LEU C 234      20.375   4.539 -16.109  1.00 24.82           C  
ATOM   6818  CD2 LEU C 234      18.706   3.606 -17.711  1.00 24.49           C  
ATOM   6819  N   VAL C 235      22.966   3.810 -21.224  1.00 28.79           N  
ATOM   6820  CA  VAL C 235      23.706   4.387 -22.357  1.00 26.89           C  
ATOM   6821  C   VAL C 235      23.073   3.915 -23.661  1.00 27.40           C  
ATOM   6822  O   VAL C 235      22.843   4.734 -24.565  1.00 27.72           O  
ATOM   6823  CB  VAL C 235      25.210   4.005 -22.394  1.00 27.79           C  
ATOM   6824  CG1 VAL C 235      25.857   4.487 -23.690  1.00 28.55           C  
ATOM   6825  CG2 VAL C 235      25.945   4.586 -21.247  1.00 21.21           C  
ATOM   6826  N   GLU C 236      22.809   2.609 -23.768  1.00 25.20           N  
ATOM   6827  CA  GLU C 236      22.208   2.047 -24.977  1.00 24.92           C  
ATOM   6828  C   GLU C 236      20.780   2.449 -25.301  1.00 24.13           C  
ATOM   6829  O   GLU C 236      20.439   2.539 -26.474  1.00 23.64           O  
ATOM   6830  CB  GLU C 236      22.217   0.525 -24.946  1.00 23.97           C  
ATOM   6831  CG  GLU C 236      23.536  -0.014 -25.206  1.00 29.71           C  
ATOM   6832  CD  GLU C 236      23.555  -1.513 -25.372  1.00 34.68           C  
ATOM   6833  OE1 GLU C 236      22.621  -2.129 -25.951  1.00 33.75           O  
ATOM   6834  OE2 GLU C 236      24.576  -2.075 -24.953  1.00 38.07           O  
ATOM   6835  N   PHE C 237      19.960   2.607 -24.267  1.00 24.26           N  
ATOM   6836  CA  PHE C 237      18.549   2.964 -24.369  1.00 22.70           C  
ATOM   6837  C   PHE C 237      18.326   4.235 -23.573  1.00 22.07           C  
ATOM   6838  O   PHE C 237      17.733   4.175 -22.509  1.00 20.16           O  
ATOM   6839  CB  PHE C 237      17.690   1.811 -23.827  1.00 22.37           C  
ATOM   6840  CG  PHE C 237      17.911   0.517 -24.560  1.00 20.38           C  
ATOM   6841  CD1 PHE C 237      17.279   0.286 -25.777  1.00 18.25           C  
ATOM   6842  CD2 PHE C 237      18.780  -0.440 -24.072  1.00 15.69           C  
ATOM   6843  CE1 PHE C 237      17.500  -0.897 -26.473  1.00 22.53           C  
ATOM   6844  CE2 PHE C 237      19.001  -1.626 -24.770  1.00 21.33           C  
ATOM   6845  CZ  PHE C 237      18.367  -1.849 -25.960  1.00 22.35           C  
ATOM   6846  N   PRO C 238      18.776   5.405 -24.100  1.00 23.80           N  
ATOM   6847  CA  PRO C 238      18.606   6.692 -23.364  1.00 23.72           C  
ATOM   6848  C   PRO C 238      17.156   7.069 -23.033  1.00 23.55           C  
ATOM   6849  O   PRO C 238      16.932   7.839 -22.100  1.00 25.21           O  
ATOM   6850  CB  PRO C 238      19.278   7.723 -24.272  1.00 24.74           C  
ATOM   6851  CG  PRO C 238      19.364   7.060 -25.619  1.00 26.99           C  
ATOM   6852  CD  PRO C 238      19.467   5.604 -25.389  1.00 24.44           C  
ATOM   6853  N   GLU C 239      16.204   6.499 -23.772  1.00 24.07           N  
ATOM   6854  CA  GLU C 239      14.772   6.592 -23.481  1.00 26.17           C  
ATOM   6855  C   GLU C 239      14.487   6.192 -22.036  1.00 25.13           C  
ATOM   6856  O   GLU C 239      13.599   6.752 -21.406  1.00 26.29           O  
ATOM   6857  CB  GLU C 239      13.909   5.652 -24.351  1.00 27.18           C  
ATOM   6858  CG  GLU C 239      14.288   5.452 -25.819  1.00 36.12           C  
ATOM   6859  CD  GLU C 239      15.187   4.240 -26.068  1.00 37.35           C  
ATOM   6860  OE1 GLU C 239      14.789   3.110 -25.707  1.00 46.18           O  
ATOM   6861  OE2 GLU C 239      16.261   4.417 -26.679  1.00 41.26           O  
ATOM   6862  N   LEU C 240      15.219   5.196 -21.539  1.00 24.12           N  
ATOM   6863  CA  LEU C 240      15.091   4.710 -20.165  1.00 24.63           C  
ATOM   6864  C   LEU C 240      15.798   5.584 -19.104  1.00 23.31           C  
ATOM   6865  O   LEU C 240      15.492   5.438 -17.926  1.00 25.42           O  
ATOM   6866  CB  LEU C 240      15.592   3.264 -20.063  1.00 24.57           C  
ATOM   6867  CG  LEU C 240      14.976   2.225 -21.016  1.00 26.91           C  
ATOM   6868  CD1 LEU C 240      15.649   0.895 -20.822  1.00 30.23           C  
ATOM   6869  CD2 LEU C 240      13.464   2.100 -20.838  1.00 32.41           C  
ATOM   6870  N   ASN C 241      16.735   6.447 -19.496  1.00 21.00           N  
ATOM   6871  CA  ASN C 241      17.422   7.345 -18.573  1.00 21.30           C  
ATOM   6872  C   ASN C 241      16.522   8.555 -18.228  1.00 20.80           C  
ATOM   6873  O   ASN C 241      16.741   9.696 -18.666  1.00 23.82           O  
ATOM   6874  CB  ASN C 241      18.803   7.780 -19.113  1.00 21.02           C  
ATOM   6875  CG  ASN C 241      19.566   8.674 -18.123  1.00 22.24           C  
ATOM   6876  OD1 ASN C 241      19.535   8.446 -16.913  1.00 27.78           O  
ATOM   6877  ND2 ASN C 241      20.192   9.731 -18.631  1.00 16.21           N  
ATOM   6878  N   THR C 242      15.535   8.300 -17.374  1.00 18.32           N  
ATOM   6879  CA  THR C 242      14.520   9.292 -17.039  1.00 18.34           C  
ATOM   6880  C   THR C 242      14.367   9.474 -15.539  1.00 15.74           C  
ATOM   6881  O   THR C 242      14.907   8.695 -14.749  1.00 17.91           O  
ATOM   6882  CB  THR C 242      13.154   8.845 -17.599  1.00 19.35           C  
ATOM   6883  OG1 THR C 242      12.882   7.497 -17.182  1.00 24.90           O  
ATOM   6884  CG2 THR C 242      13.130   8.925 -19.123  1.00 15.86           C  
ATOM   6885  N   GLU C 243      13.641  10.516 -15.159  1.00 17.33           N  
ATOM   6886  CA  GLU C 243      13.285  10.715 -13.757  1.00 21.02           C  
ATOM   6887  C   GLU C 243      12.432   9.552 -13.265  1.00 20.23           C  
ATOM   6888  O   GLU C 243      12.547   9.148 -12.104  1.00 18.73           O  
ATOM   6889  CB  GLU C 243      12.543  12.029 -13.545  1.00 23.19           C  
ATOM   6890  CG  GLU C 243      13.465  13.243 -13.495  1.00 36.95           C  
ATOM   6891  CD  GLU C 243      14.296  13.295 -12.207  1.00 50.71           C  
ATOM   6892  OE1 GLU C 243      13.680  13.469 -11.129  1.00 60.27           O  
ATOM   6893  OE2 GLU C 243      15.549  13.166 -12.281  1.00 52.56           O  
ATOM   6894  N   GLU C 244      11.583   9.032 -14.155  1.00 19.89           N  
ATOM   6895  CA  GLU C 244      10.719   7.892 -13.867  1.00 20.92           C  
ATOM   6896  C   GLU C 244      11.554   6.680 -13.437  1.00 19.44           C  
ATOM   6897  O   GLU C 244      11.213   6.020 -12.470  1.00 21.06           O  
ATOM   6898  CB  GLU C 244       9.864   7.582 -15.102  1.00 20.94           C  
ATOM   6899  CG  GLU C 244       8.946   6.380 -15.004  1.00 27.68           C  
ATOM   6900  CD  GLU C 244       8.364   6.017 -16.344  1.00 26.89           C  
ATOM   6901  OE1 GLU C 244       7.770   6.906 -16.981  1.00 44.11           O  
ATOM   6902  OE2 GLU C 244       8.504   4.848 -16.768  1.00 47.71           O  
ATOM   6903  N   THR C 245      12.619   6.387 -14.175  1.00 19.46           N  
ATOM   6904  CA  THR C 245      13.560   5.327 -13.811  1.00 20.41           C  
ATOM   6905  C   THR C 245      14.198   5.580 -12.433  1.00 20.55           C  
ATOM   6906  O   THR C 245      14.306   4.648 -11.613  1.00 20.65           O  
ATOM   6907  CB  THR C 245      14.656   5.186 -14.879  1.00 19.87           C  
ATOM   6908  OG1 THR C 245      14.034   4.784 -16.086  1.00 22.37           O  
ATOM   6909  CG2 THR C 245      15.710   4.130 -14.489  1.00 20.54           C  
ATOM   6910  N   LYS C 246      14.613   6.821 -12.172  1.00 21.14           N  
ATOM   6911  CA  LYS C 246      15.175   7.155 -10.858  1.00 22.48           C  
ATOM   6912  C   LYS C 246      14.171   6.877  -9.770  1.00 19.08           C  
ATOM   6913  O   LYS C 246      14.542   6.313  -8.760  1.00 18.23           O  
ATOM   6914  CB  LYS C 246      15.638   8.611 -10.740  1.00 21.65           C  
ATOM   6915  CG  LYS C 246      16.913   8.929 -11.462  1.00 28.56           C  
ATOM   6916  CD  LYS C 246      17.499  10.298 -11.060  1.00 29.37           C  
ATOM   6917  CE  LYS C 246      18.894  10.485 -11.704  1.00 39.35           C  
ATOM   6918  NZ  LYS C 246      18.837  10.367 -13.205  1.00 34.74           N  
ATOM   6919  N   THR C 247      12.924   7.312  -9.961  1.00 19.56           N  
ATOM   6920  CA  THR C 247      11.859   7.078  -8.989  1.00 20.30           C  
ATOM   6921  C   THR C 247      11.593   5.590  -8.764  1.00 22.58           C  
ATOM   6922  O   THR C 247      11.417   5.157  -7.629  1.00 23.96           O  
ATOM   6923  CB  THR C 247      10.554   7.800  -9.386  1.00 23.12           C  
ATOM   6924  OG1 THR C 247      10.804   9.206  -9.415  1.00 21.62           O  
ATOM   6925  CG2 THR C 247       9.443   7.516  -8.386  1.00 16.90           C  
ATOM   6926  N   PHE C 248      11.602   4.810  -9.843  1.00 20.24           N  
ATOM   6927  CA  PHE C 248      11.399   3.383  -9.741  1.00 20.38           C  
ATOM   6928  C   PHE C 248      12.456   2.718  -8.847  1.00 20.96           C  
ATOM   6929  O   PHE C 248      12.123   1.917  -7.964  1.00 20.49           O  
ATOM   6930  CB  PHE C 248      11.409   2.753 -11.125  1.00 19.83           C  
ATOM   6931  CG  PHE C 248      11.341   1.269 -11.095  1.00 22.38           C  
ATOM   6932  CD1 PHE C 248      10.127   0.628 -10.930  1.00 19.52           C  
ATOM   6933  CD2 PHE C 248      12.500   0.495 -11.225  1.00 24.49           C  
ATOM   6934  CE1 PHE C 248      10.068  -0.768 -10.908  1.00 24.16           C  
ATOM   6935  CE2 PHE C 248      12.445  -0.892 -11.149  1.00 17.82           C  
ATOM   6936  CZ  PHE C 248      11.226  -1.520 -11.009  1.00 19.89           C  
ATOM   6937  N   VAL C 249      13.725   3.053  -9.093  1.00 20.94           N  
ATOM   6938  CA  VAL C 249      14.854   2.475  -8.330  1.00 21.37           C  
ATOM   6939  C   VAL C 249      14.743   2.851  -6.862  1.00 21.34           C  
ATOM   6940  O   VAL C 249      14.895   2.009  -5.972  1.00 22.20           O  
ATOM   6941  CB  VAL C 249      16.232   2.922  -8.907  1.00 22.70           C  
ATOM   6942  CG1 VAL C 249      17.383   2.452  -8.012  1.00 21.20           C  
ATOM   6943  CG2 VAL C 249      16.422   2.432 -10.381  1.00 16.31           C  
ATOM   6944  N   LYS C 250      14.440   4.121  -6.617  1.00 19.00           N  
ATOM   6945  CA  LYS C 250      14.316   4.616  -5.256  1.00 20.86           C  
ATOM   6946  C   LYS C 250      13.166   3.921  -4.503  1.00 21.28           C  
ATOM   6947  O   LYS C 250      13.335   3.457  -3.395  1.00 22.17           O  
ATOM   6948  CB  LYS C 250      14.067   6.129  -5.309  1.00 20.11           C  
ATOM   6949  CG  LYS C 250      14.672   6.909  -4.205  1.00 27.41           C  
ATOM   6950  CD  LYS C 250      14.191   8.392  -4.191  1.00 23.52           C  
ATOM   6951  CE  LYS C 250      14.520   9.189  -5.478  1.00 41.74           C  
ATOM   6952  NZ  LYS C 250      13.996  10.597  -5.440  1.00 40.32           N  
ATOM   6953  N   THR C 251      12.001   3.833  -5.129  1.00 22.34           N  
ATOM   6954  CA  THR C 251      10.811   3.220  -4.525  0.50 22.20           C  
ATOM   6956  C   THR C 251      10.961   1.708  -4.312  1.00 19.73           C  
ATOM   6957  O   THR C 251      10.532   1.170  -3.296  1.00 18.84           O  
ATOM   6958  CB  THR C 251       9.564   3.517  -5.409  0.50 23.13           C  
ATOM   6960  OG1 THR C 251       9.425   4.930  -5.525  0.50 17.59           O  
ATOM   6962  CG2 THR C 251       8.284   2.922  -4.828  0.50 23.81           C  
ATOM   6964  N   THR C 252      11.589   1.028  -5.266  1.00 16.32           N  
ATOM   6965  CA  THR C 252      11.778  -0.384  -5.194  1.00 16.35           C  
ATOM   6966  C   THR C 252      12.772  -0.721  -4.094  1.00 18.97           C  
ATOM   6967  O   THR C 252      12.586  -1.701  -3.368  1.00 21.78           O  
ATOM   6968  CB  THR C 252      12.227  -0.951  -6.564  1.00 16.65           C  
ATOM   6969  OG1 THR C 252      11.214  -0.644  -7.523  1.00 23.38           O  
ATOM   6970  CG2 THR C 252      12.407  -2.444  -6.527  1.00 21.34           C  
ATOM   6971  N   LEU C 253      13.842   0.063  -3.991  1.00 17.69           N  
ATOM   6972  CA  LEU C 253      14.827  -0.139  -2.921  1.00 17.86           C  
ATOM   6973  C   LEU C 253      14.216   0.126  -1.557  1.00 20.35           C  
ATOM   6974  O   LEU C 253      14.534  -0.580  -0.604  1.00 22.40           O  
ATOM   6975  CB  LEU C 253      16.020   0.761  -3.112  1.00 15.30           C  
ATOM   6976  CG  LEU C 253      17.054   0.361  -4.161  1.00 20.38           C  
ATOM   6977  CD1 LEU C 253      18.049   1.537  -4.328  1.00 23.72           C  
ATOM   6978  CD2 LEU C 253      17.762  -0.899  -3.704  1.00 19.91           C  
HETATM 6979  N   MSE C 254      13.362   1.138  -1.458  1.00 22.01           N  
HETATM 6980  CA  MSE C 254      12.705   1.419  -0.193  1.00 21.97           C  
HETATM 6981  C   MSE C 254      11.779   0.280   0.232  1.00 22.52           C  
HETATM 6982  O   MSE C 254      11.765  -0.094   1.402  1.00 26.04           O  
HETATM 6983  CB  MSE C 254      11.912   2.726  -0.259  1.00 21.92           C  
HETATM 6984  CG  MSE C 254      12.751   3.950  -0.429  1.00 26.03           C  
HETATM 6985 SE   MSE C 254      11.714   5.547  -0.845  0.75 27.45          SE  
HETATM 6986  CE  MSE C 254      11.402   6.091   0.989  1.00 31.15           C  
ATOM   6987  N   LYS C 255      10.982  -0.253  -0.686  1.00 20.01           N  
ATOM   6988  CA  LYS C 255      10.088  -1.367  -0.349  1.00 21.04           C  
ATOM   6989  C   LYS C 255      10.928  -2.620   0.029  1.00 22.69           C  
ATOM   6990  O   LYS C 255      10.567  -3.355   0.926  1.00 21.06           O  
ATOM   6991  CB  LYS C 255       9.097  -1.638  -1.499  1.00 24.26           C  
ATOM   6992  CG  LYS C 255       7.893  -2.491  -1.117  1.00 31.95           C  
ATOM   6993  N   ALA C 256      12.024  -2.845  -0.680  1.00 20.79           N  
ATOM   6994  CA  ALA C 256      12.980  -3.941  -0.381  1.00 23.57           C  
ATOM   6995  C   ALA C 256      13.595  -3.777   1.040  1.00 25.82           C  
ATOM   6996  O   ALA C 256      13.676  -4.726   1.830  1.00 26.36           O  
ATOM   6997  CB  ALA C 256      14.038  -3.953  -1.398  1.00 25.05           C  
ATOM   6998  N   ALA C 257      13.983  -2.546   1.364  1.00 25.14           N  
ATOM   6999  CA  ALA C 257      14.555  -2.214   2.663  1.00 22.74           C  
ATOM   7000  C   ALA C 257      13.514  -2.410   3.793  1.00 23.72           C  
ATOM   7001  O   ALA C 257      13.823  -2.974   4.825  1.00 24.91           O  
ATOM   7002  CB  ALA C 257      15.082  -0.788   2.641  1.00 20.47           C  
ATOM   7003  N   ASP C 258      12.286  -1.959   3.579  1.00 22.87           N  
ATOM   7004  CA  ASP C 258      11.203  -2.136   4.527  1.00 20.86           C  
ATOM   7005  C   ASP C 258      10.947  -3.616   4.803  1.00 21.89           C  
ATOM   7006  O   ASP C 258      10.745  -3.999   5.937  1.00 22.66           O  
ATOM   7007  CB  ASP C 258       9.896  -1.533   4.002  1.00 20.06           C  
ATOM   7008  CG  ASP C 258       9.870  -0.003   4.017  1.00 29.96           C  
ATOM   7009  OD1 ASP C 258      10.657   0.659   4.734  1.00 32.39           O  
ATOM   7010  OD2 ASP C 258       8.990   0.539   3.321  1.00 36.22           O  
ATOM   7011  N   LEU C 259      10.945  -4.432   3.764  1.00 20.93           N  
ATOM   7012  CA  LEU C 259      10.725  -5.870   3.933  1.00 18.60           C  
ATOM   7013  C   LEU C 259      11.874  -6.553   4.714  1.00 19.62           C  
ATOM   7014  O   LEU C 259      11.622  -7.449   5.530  1.00 20.62           O  
ATOM   7015  CB  LEU C 259      10.477  -6.518   2.564  1.00 17.65           C  
ATOM   7016  CG  LEU C 259       9.116  -6.273   1.907  1.00 14.96           C  
ATOM   7017  CD1 LEU C 259       9.099  -6.679   0.429  1.00 23.95           C  
ATOM   7018  CD2 LEU C 259       7.978  -6.989   2.725  1.00 18.52           C  
ATOM   7019  N   GLU C 260      13.116  -6.143   4.443  1.00 18.46           N  
ATOM   7020  CA  GLU C 260      14.295  -6.690   5.111  1.00 20.00           C  
ATOM   7021  C   GLU C 260      14.245  -6.306   6.598  1.00 18.24           C  
ATOM   7022  O   GLU C 260      14.542  -7.139   7.466  1.00 19.07           O  
ATOM   7023  CB  GLU C 260      15.598  -6.194   4.477  1.00 19.81           C  
ATOM   7024  CG  GLU C 260      16.894  -6.781   5.097  1.00 22.68           C  
ATOM   7025  CD  GLU C 260      17.021  -8.274   4.836  1.00 29.55           C  
ATOM   7026  OE1 GLU C 260      16.570  -8.658   3.799  1.00 21.76           O  
ATOM   7027  OE2 GLU C 260      17.477  -9.080   5.649  1.00 41.29           O  
ATOM   7028  N   LYS C 261      13.887  -5.063   6.899  1.00 21.50           N  
ATOM   7029  CA  LYS C 261      13.757  -4.629   8.275  1.00 22.09           C  
ATOM   7030  C   LYS C 261      12.636  -5.402   9.029  1.00 27.14           C  
ATOM   7031  O   LYS C 261      12.832  -5.734  10.204  1.00 28.80           O  
ATOM   7032  CB  LYS C 261      13.532  -3.127   8.342  1.00 22.76           C  
ATOM   7033  CG  LYS C 261      14.712  -2.263   7.826  1.00 18.73           C  
ATOM   7034  CD  LYS C 261      14.292  -0.832   7.580  1.00 26.44           C  
ATOM   7035  CE  LYS C 261      15.427   0.008   7.038  1.00 25.50           C  
ATOM   7036  NZ  LYS C 261      14.969   1.375   6.544  1.00 20.51           N  
ATOM   7037  N   ASP C 262      11.475  -5.620   8.386  1.00 26.58           N  
ATOM   7038  CA  ASP C 262      10.349  -6.408   8.951  0.50 23.70           C  
ATOM   7040  C   ASP C 262      10.825  -7.800   9.274  1.00 23.36           C  
ATOM   7041  O   ASP C 262      10.525  -8.343  10.315  1.00 22.43           O  
ATOM   7042  CB  ASP C 262       9.198  -6.641   7.944  0.50 25.22           C  
ATOM   7044  CG  ASP C 262       8.270  -5.453   7.755  0.50 24.49           C  
ATOM   7046  OD1 ASP C 262       8.288  -4.507   8.549  0.50 25.95           O  
ATOM   7048  OD2 ASP C 262       7.459  -5.502   6.803  0.50 29.94           O  
ATOM   7050  N   TRP C 263      11.530  -8.400   8.316  1.00 19.82           N  
ATOM   7051  CA  TRP C 263      12.067  -9.747   8.482  1.00 21.67           C  
ATOM   7052  C   TRP C 263      13.030  -9.873   9.629  1.00 22.72           C  
ATOM   7053  O   TRP C 263      12.924 -10.796  10.441  1.00 28.52           O  
ATOM   7054  CB  TRP C 263      12.767 -10.171   7.221  1.00 23.79           C  
ATOM   7055  CG  TRP C 263      13.568 -11.451   7.332  1.00 24.68           C  
ATOM   7056  CD1 TRP C 263      14.953 -11.593   7.424  1.00 26.51           C  
ATOM   7057  CD2 TRP C 263      13.036 -12.751   7.308  1.00 25.65           C  
ATOM   7058  NE1 TRP C 263      15.284 -12.933   7.470  1.00 29.07           N  
ATOM   7059  CE2 TRP C 263      14.128 -13.659   7.398  1.00 24.73           C  
ATOM   7060  CE3 TRP C 263      11.736 -13.253   7.251  1.00 32.82           C  
ATOM   7061  CZ2 TRP C 263      13.953 -15.023   7.427  1.00 31.46           C  
ATOM   7062  CZ3 TRP C 263      11.563 -14.623   7.275  1.00 36.25           C  
ATOM   7063  CH2 TRP C 263      12.677 -15.494   7.354  1.00 34.36           C  
ATOM   7064  N   PHE C 264      13.962  -8.940   9.705  1.00 23.05           N  
ATOM   7065  CA  PHE C 264      14.907  -8.910  10.804  1.00 22.40           C  
ATOM   7066  C   PHE C 264      14.220  -8.810  12.173  1.00 20.03           C  
ATOM   7067  O   PHE C 264      14.605  -9.527  13.123  1.00 15.64           O  
ATOM   7068  CB  PHE C 264      15.933  -7.778  10.635  1.00 22.32           C  
ATOM   7069  CG  PHE C 264      16.858  -7.695  11.768  1.00 25.36           C  
ATOM   7070  CD1 PHE C 264      17.950  -8.530  11.850  1.00 32.31           C  
ATOM   7071  CD2 PHE C 264      16.589  -6.872  12.808  1.00 24.40           C  
ATOM   7072  CE1 PHE C 264      18.782  -8.466  12.968  1.00 28.11           C  
ATOM   7073  CE2 PHE C 264      17.400  -6.833  13.913  1.00 31.14           C  
ATOM   7074  CZ  PHE C 264      18.486  -7.605  13.983  1.00 26.79           C  
ATOM   7075  N   ARG C 265      13.247  -7.908  12.313  1.00 23.57           N  
ATOM   7076  CA  ARG C 265      12.504  -7.819  13.536  1.00 25.51           C  
ATOM   7077  C   ARG C 265      11.695  -9.083  13.866  1.00 25.08           C  
ATOM   7078  O   ARG C 265      11.497  -9.412  15.031  1.00 22.77           O  
ATOM   7079  CB  ARG C 265      11.563  -6.617  13.528  1.00 29.84           C  
ATOM   7080  CG  ARG C 265      12.280  -5.270  13.564  1.00 28.27           C  
ATOM   7081  CD  ARG C 265      11.322  -4.145  13.792  1.00 31.15           C  
ATOM   7082  NE  ARG C 265      10.309  -4.047  12.747  1.00 31.08           N  
ATOM   7083  CZ  ARG C 265      10.377  -3.320  11.624  1.00 36.06           C  
ATOM   7084  NH1 ARG C 265      11.414  -2.565  11.319  1.00 39.83           N  
ATOM   7085  NH2 ARG C 265       9.355  -3.341  10.787  1.00 42.83           N  
ATOM   7086  N   TYR C 266      11.185  -9.743  12.842  1.00 22.60           N  
ATOM   7087  CA  TYR C 266      10.460 -10.996  12.989  1.00 23.30           C  
ATOM   7088  C   TYR C 266      11.322 -12.154  13.505  1.00 22.74           C  
ATOM   7089  O   TYR C 266      10.860 -12.904  14.372  1.00 22.12           O  
ATOM   7090  CB  TYR C 266       9.868 -11.365  11.619  1.00 25.14           C  
ATOM   7091  CG  TYR C 266       9.016 -12.611  11.500  1.00 28.42           C  
ATOM   7092  CD1 TYR C 266       7.842 -12.750  12.234  1.00 32.02           C  
ATOM   7093  CD2 TYR C 266       9.320 -13.585  10.539  1.00 29.86           C  
ATOM   7094  CE1 TYR C 266       7.027 -13.861  12.065  1.00 31.85           C  
ATOM   7095  CE2 TYR C 266       8.520 -14.703  10.359  1.00 31.28           C  
ATOM   7096  CZ  TYR C 266       7.375 -14.838  11.119  1.00 32.00           C  
ATOM   7097  OH  TYR C 266       6.578 -15.940  10.945  1.00 28.73           O  
ATOM   7098  N   ILE C 267      12.533 -12.337  12.965  1.00 20.92           N  
ATOM   7099  CA  ILE C 267      13.371 -13.487  13.376  1.00 22.59           C  
ATOM   7100  C   ILE C 267      14.373 -13.212  14.508  1.00 24.48           C  
ATOM   7101  O   ILE C 267      14.794 -14.164  15.177  1.00 25.52           O  
ATOM   7102  CB  ILE C 267      14.110 -14.160  12.181  1.00 21.52           C  
ATOM   7103  CG1 ILE C 267      15.116 -13.225  11.508  1.00 24.08           C  
ATOM   7104  CG2 ILE C 267      13.094 -14.604  11.159  1.00 22.64           C  
ATOM   7105  CD1 ILE C 267      16.161 -13.956  10.680  1.00 22.92           C  
ATOM   7106  N   ILE C 268      14.764 -11.950  14.694  1.00 23.07           N  
ATOM   7107  CA  ILE C 268      15.807 -11.585  15.664  1.00 22.41           C  
ATOM   7108  C   ILE C 268      15.358 -10.498  16.610  1.00 22.45           C  
ATOM   7109  O   ILE C 268      15.444 -10.695  17.806  1.00 20.62           O  
ATOM   7110  CB  ILE C 268      17.109 -11.169  14.973  1.00 25.04           C  
ATOM   7111  CG1 ILE C 268      17.734 -12.379  14.266  1.00 16.79           C  
ATOM   7112  CG2 ILE C 268      18.098 -10.638  15.994  1.00 20.45           C  
ATOM   7113  CD1 ILE C 268      18.662 -12.048  13.121  1.00 20.92           C  
ATOM   7114  N   GLY C 269      14.939  -9.348  16.088  1.00 22.34           N  
ATOM   7115  CA  GLY C 269      14.453  -8.254  16.953  1.00 23.99           C  
ATOM   7116  C   GLY C 269      15.573  -7.827  17.886  1.00 23.94           C  
ATOM   7117  O   GLY C 269      16.718  -7.669  17.459  1.00 23.29           O  
ATOM   7118  N   ASP C 270      15.250  -7.701  19.167  1.00 25.92           N  
ATOM   7119  CA  ASP C 270      16.207  -7.300  20.198  1.00 28.00           C  
ATOM   7120  C   ASP C 270      16.735  -8.491  21.026  1.00 28.73           C  
ATOM   7121  O   ASP C 270      17.272  -8.283  22.110  1.00 28.60           O  
ATOM   7122  CB  ASP C 270      15.550  -6.259  21.125  1.00 29.46           C  
ATOM   7123  CG  ASP C 270      14.353  -6.821  21.908  1.00 38.03           C  
ATOM   7124  OD1 ASP C 270      13.740  -7.822  21.449  1.00 49.78           O  
ATOM   7125  OD2 ASP C 270      14.008  -6.246  22.967  1.00 49.79           O  
ATOM   7126  N   LYS C 271      16.618  -9.720  20.513  1.00 27.72           N  
ATOM   7127  CA  LYS C 271      17.014 -10.923  21.285  1.00 27.93           C  
ATOM   7128  C   LYS C 271      18.474 -11.394  21.222  1.00 26.33           C  
ATOM   7129  O   LYS C 271      18.838 -12.281  21.978  1.00 28.70           O  
ATOM   7130  CB  LYS C 271      16.086 -12.076  20.920  1.00 28.76           C  
ATOM   7131  CG  LYS C 271      14.647 -11.836  21.317  1.00 29.66           C  
ATOM   7132  CD  LYS C 271      13.805 -13.096  21.095  1.00 32.14           C  
ATOM   7133  N   ILE C 272      19.314 -10.778  20.401  1.00 26.93           N  
ATOM   7134  CA  ILE C 272      20.705 -11.231  20.224  1.00 27.77           C  
ATOM   7135  C   ILE C 272      21.713 -10.095  20.497  1.00 29.27           C  
ATOM   7136  O   ILE C 272      21.797  -9.123  19.728  1.00 22.79           O  
ATOM   7137  CB  ILE C 272      20.917 -11.822  18.821  1.00 28.23           C  
ATOM   7138  CG1 ILE C 272      19.978 -13.000  18.588  1.00 26.51           C  
ATOM   7139  CG2 ILE C 272      22.382 -12.341  18.621  1.00 26.61           C  
ATOM   7140  CD1 ILE C 272      20.289 -13.716  17.304  1.00 26.10           C  
ATOM   7141  N   PRO C 273      22.446 -10.189  21.628  1.00 31.82           N  
ATOM   7142  CA  PRO C 273      23.503  -9.225  21.911  1.00 32.55           C  
ATOM   7143  C   PRO C 273      24.492  -9.110  20.753  1.00 33.76           C  
ATOM   7144  O   PRO C 273      24.907 -10.138  20.177  1.00 34.21           O  
ATOM   7145  CB  PRO C 273      24.190  -9.833  23.122  1.00 34.51           C  
ATOM   7146  CG  PRO C 273      23.078 -10.525  23.839  1.00 34.75           C  
ATOM   7147  CD  PRO C 273      22.316 -11.164  22.729  1.00 32.62           C  
ATOM   7148  N   GLY C 274      24.816  -7.872  20.395  1.00 33.66           N  
ATOM   7149  CA  GLY C 274      25.726  -7.581  19.303  1.00 33.04           C  
ATOM   7150  C   GLY C 274      25.091  -7.083  18.025  1.00 34.16           C  
ATOM   7151  O   GLY C 274      25.813  -6.563  17.150  1.00 33.87           O  
ATOM   7152  N   ILE C 275      23.771  -7.255  17.874  1.00 34.40           N  
ATOM   7153  CA  ILE C 275      23.070  -6.784  16.670  1.00 34.15           C  
ATOM   7154  C   ILE C 275      21.721  -6.172  17.023  1.00 36.29           C  
ATOM   7155  O   ILE C 275      20.681  -6.738  16.704  1.00 43.49           O  
ATOM   7156  CB  ILE C 275      22.953  -7.904  15.535  1.00 34.75           C  
ATOM   7157  CG1 ILE C 275      22.549  -9.265  16.129  1.00 30.64           C  
ATOM   7158  CG2 ILE C 275      24.279  -8.000  14.697  1.00 30.64           C  
ATOM   7159  CD1 ILE C 275      22.263 -10.355  15.082  1.00 28.97           C  
ATOM   7160  N   ASN C 276      21.747  -5.001  17.657  1.00 34.15           N  
ATOM   7161  CA  ASN C 276      20.506  -4.307  18.039  1.00 34.33           C  
ATOM   7162  C   ASN C 276      19.712  -3.850  16.815  1.00 31.30           C  
ATOM   7163  O   ASN C 276      20.293  -3.519  15.772  1.00 36.37           O  
ATOM   7164  CB  ASN C 276      20.743  -3.114  18.964  1.00 35.63           C  
ATOM   7165  CG  ASN C 276      21.335  -1.938  18.245  1.00 39.37           C  
ATOM   7166  OD1 ASN C 276      20.639  -0.961  17.939  1.00 37.09           O  
ATOM   7167  ND2 ASN C 276      22.605  -2.059  17.888  1.00 37.86           N  
ATOM   7168  N   PRO C 277      18.381  -3.854  16.919  1.00 26.62           N  
ATOM   7169  CA  PRO C 277      17.620  -3.545  15.719  1.00 25.76           C  
ATOM   7170  C   PRO C 277      17.764  -2.113  15.174  1.00 24.23           C  
ATOM   7171  O   PRO C 277      17.633  -1.922  13.982  1.00 23.53           O  
ATOM   7172  CB  PRO C 277      16.173  -3.900  16.121  1.00 27.35           C  
ATOM   7173  CG  PRO C 277      16.163  -3.817  17.603  1.00 30.72           C  
ATOM   7174  CD  PRO C 277      17.516  -4.149  18.075  1.00 26.51           C  
ATOM   7175  N   GLU C 278      18.051  -1.136  16.016  1.00 20.48           N  
ATOM   7176  CA  GLU C 278      18.208   0.251  15.553  1.00 22.51           C  
ATOM   7177  C   GLU C 278      19.381   0.393  14.572  1.00 25.68           C  
ATOM   7178  O   GLU C 278      19.240   0.951  13.461  1.00 27.38           O  
ATOM   7179  CB  GLU C 278      18.360   1.204  16.746  1.00 16.30           C  
ATOM   7180  N   ASP C 279      20.511  -0.203  14.946  1.00 24.29           N  
ATOM   7181  CA  ASP C 279      21.680  -0.188  14.103  1.00 20.96           C  
ATOM   7182  C   ASP C 279      21.526  -1.046  12.875  1.00 21.15           C  
ATOM   7183  O   ASP C 279      22.061  -0.667  11.853  1.00 20.39           O  
ATOM   7184  CB  ASP C 279      22.911  -0.631  14.854  1.00 21.96           C  
ATOM   7185  CG  ASP C 279      23.313   0.344  15.921  1.00 24.19           C  
ATOM   7186  OD1 ASP C 279      23.017   1.564  15.815  1.00 26.89           O  
ATOM   7187  OD2 ASP C 279      23.952  -0.137  16.865  1.00 34.30           O  
HETATM 7188  N   MSE C 280      20.805  -2.166  12.981  1.00 15.85           N  
HETATM 7189  CA  MSE C 280      20.573  -3.042  11.844  1.00 21.95           C  
HETATM 7190  C   MSE C 280      19.683  -2.354  10.829  1.00 21.05           C  
HETATM 7191  O   MSE C 280      19.914  -2.474   9.633  1.00 23.70           O  
HETATM 7192  CB  MSE C 280      19.954  -4.354  12.316  1.00 22.70           C  
HETATM 7193  CG  MSE C 280      19.821  -5.347  11.217  1.00 25.78           C  
HETATM 7194 SE   MSE C 280      21.557  -5.986  10.660  0.75 25.39          SE  
HETATM 7195  CE  MSE C 280      21.821  -7.209  12.146  1.00 39.00           C  
ATOM   7196  N   GLU C 281      18.661  -1.648  11.292  1.00 20.72           N  
ATOM   7197  CA  GLU C 281      17.785  -0.855  10.414  1.00 22.87           C  
ATOM   7198  C   GLU C 281      18.570   0.218   9.686  1.00 22.43           C  
ATOM   7199  O   GLU C 281      18.393   0.393   8.487  1.00 20.15           O  
ATOM   7200  CB  GLU C 281      16.618  -0.205  11.211  1.00 19.91           C  
ATOM   7201  CG  GLU C 281      15.564  -1.261  11.487  1.00 28.23           C  
ATOM   7202  CD  GLU C 281      14.395  -0.804  12.293  1.00 32.22           C  
ATOM   7203  OE1 GLU C 281      14.199   0.419  12.435  1.00 46.44           O  
ATOM   7204  OE2 GLU C 281      13.692  -1.701  12.807  1.00 41.10           O  
ATOM   7205  N   THR C 282      19.430   0.932  10.412  1.00 17.68           N  
ATOM   7206  CA  THR C 282      20.324   1.916   9.799  1.00 17.32           C  
ATOM   7207  C   THR C 282      21.255   1.280   8.786  1.00 18.80           C  
ATOM   7208  O   THR C 282      21.488   1.854   7.706  1.00 20.70           O  
ATOM   7209  CB  THR C 282      21.165   2.607  10.854  1.00 20.56           C  
ATOM   7210  OG1 THR C 282      20.296   3.283  11.738  1.00 19.49           O  
ATOM   7211  CG2 THR C 282      22.121   3.619  10.233  1.00 21.83           C  
ATOM   7212  N   TYR C 283      21.760   0.089   9.135  1.00 16.87           N  
ATOM   7213  CA  TYR C 283      22.645  -0.661   8.275  1.00 18.42           C  
ATOM   7214  C   TYR C 283      21.947  -1.051   6.971  1.00 19.47           C  
ATOM   7215  O   TYR C 283      22.557  -0.950   5.890  1.00 21.61           O  
ATOM   7216  CB  TYR C 283      23.170  -1.884   8.995  1.00 21.54           C  
ATOM   7217  CG  TYR C 283      24.120  -2.716   8.160  1.00 19.29           C  
ATOM   7218  CD1 TYR C 283      25.341  -2.179   7.730  1.00 20.79           C  
ATOM   7219  CD2 TYR C 283      23.833  -4.047   7.826  1.00 26.38           C  
ATOM   7220  CE1 TYR C 283      26.248  -2.949   6.991  1.00 24.12           C  
ATOM   7221  CE2 TYR C 283      24.733  -4.805   7.078  1.00 28.98           C  
ATOM   7222  CZ  TYR C 283      25.931  -4.232   6.667  1.00 27.41           C  
ATOM   7223  OH  TYR C 283      26.822  -4.959   5.928  1.00 33.86           O  
ATOM   7224  N   ILE C 284      20.687  -1.477   7.048  1.00 17.35           N  
ATOM   7225  CA  ILE C 284      19.914  -1.861   5.824  1.00 19.11           C  
ATOM   7226  C   ILE C 284      19.706  -0.627   4.925  1.00 19.03           C  
ATOM   7227  O   ILE C 284      19.842  -0.689   3.699  1.00 17.96           O  
ATOM   7228  CB  ILE C 284      18.579  -2.574   6.228  1.00 21.07           C  
ATOM   7229  CG1 ILE C 284      18.892  -3.923   6.851  1.00 20.53           C  
ATOM   7230  CG2 ILE C 284      17.589  -2.676   5.048  1.00 15.23           C  
ATOM   7231  CD1 ILE C 284      17.732  -4.611   7.657  1.00 15.07           C  
ATOM   7232  N   SER C 285      19.364   0.513   5.530  1.00 16.71           N  
ATOM   7233  CA  SER C 285      19.238   1.748   4.766  1.00 17.04           C  
ATOM   7234  C   SER C 285      20.546   2.143   4.099  1.00 18.86           C  
ATOM   7235  O   SER C 285      20.575   2.488   2.898  1.00 20.07           O  
ATOM   7236  CB  SER C 285      18.762   2.896   5.694  1.00 19.74           C  
ATOM   7237  OG  SER C 285      17.471   2.586   6.162  1.00 22.21           O  
ATOM   7238  N   PHE C 286      21.625   2.068   4.873  1.00 17.58           N  
ATOM   7239  CA  PHE C 286      22.953   2.330   4.356  1.00 20.23           C  
ATOM   7240  C   PHE C 286      23.253   1.448   3.116  1.00 17.74           C  
ATOM   7241  O   PHE C 286      23.793   1.945   2.110  1.00 20.31           O  
ATOM   7242  CB  PHE C 286      24.028   2.118   5.438  1.00 15.95           C  
ATOM   7243  CG  PHE C 286      25.419   2.292   4.924  1.00 22.99           C  
ATOM   7244  CD1 PHE C 286      25.969   3.558   4.802  1.00 26.08           C  
ATOM   7245  CD2 PHE C 286      26.165   1.188   4.518  1.00 21.57           C  
ATOM   7246  CE1 PHE C 286      27.256   3.710   4.299  1.00 29.56           C  
ATOM   7247  CE2 PHE C 286      27.448   1.343   4.009  1.00 25.57           C  
ATOM   7248  CZ  PHE C 286      27.987   2.585   3.904  1.00 29.90           C  
ATOM   7249  N   ILE C 287      22.957   0.155   3.205  1.00 21.42           N  
ATOM   7250  CA  ILE C 287      23.193  -0.781   2.073  1.00 22.03           C  
ATOM   7251  C   ILE C 287      22.315  -0.438   0.846  1.00 20.84           C  
ATOM   7252  O   ILE C 287      22.808  -0.463  -0.278  1.00 20.80           O  
ATOM   7253  CB  ILE C 287      23.016  -2.296   2.451  1.00 21.21           C  
ATOM   7254  CG1 ILE C 287      24.035  -2.759   3.498  1.00 27.09           C  
ATOM   7255  CG2 ILE C 287      23.140  -3.154   1.224  1.00 24.92           C  
ATOM   7256  CD1 ILE C 287      25.491  -2.669   3.046  1.00 34.33           C  
ATOM   7257  N   ALA C 288      21.056  -0.061   1.060  1.00 23.50           N  
ATOM   7258  CA  ALA C 288      20.173   0.379  -0.026  1.00 21.13           C  
ATOM   7259  C   ALA C 288      20.755   1.624  -0.734  1.00 20.29           C  
ATOM   7260  O   ALA C 288      20.727   1.715  -1.958  1.00 22.44           O  
ATOM   7261  CB  ALA C 288      18.784   0.660   0.480  1.00 19.21           C  
ATOM   7262  N   ASN C 289      21.258   2.577   0.044  1.00 22.19           N  
ATOM   7263  CA  ASN C 289      21.951   3.768  -0.503  1.00 21.58           C  
ATOM   7264  C   ASN C 289      23.142   3.388  -1.366  1.00 19.87           C  
ATOM   7265  O   ASN C 289      23.294   3.889  -2.475  1.00 19.47           O  
ATOM   7266  CB  ASN C 289      22.425   4.685   0.638  1.00 20.61           C  
ATOM   7267  CG  ASN C 289      21.311   5.443   1.275  1.00 15.98           C  
ATOM   7268  OD1 ASN C 289      20.192   5.499   0.747  1.00 18.78           O  
ATOM   7269  ND2 ASN C 289      21.594   6.064   2.420  1.00 19.93           N  
ATOM   7270  N   LYS C 290      23.967   2.486  -0.850  1.00 21.98           N  
ATOM   7271  CA  LYS C 290      25.158   2.003  -1.555  1.00 21.22           C  
ATOM   7272  C   LYS C 290      24.800   1.351  -2.892  1.00 21.82           C  
ATOM   7273  O   LYS C 290      25.447   1.617  -3.895  1.00 22.19           O  
ATOM   7274  CB  LYS C 290      25.976   1.058  -0.657  1.00 18.95           C  
ATOM   7275  CG  LYS C 290      27.268   0.616  -1.252  1.00 29.77           C  
ATOM   7276  CD  LYS C 290      28.121  -0.140  -0.248  1.00 32.53           C  
ATOM   7277  CE  LYS C 290      29.301  -0.818  -0.912  1.00 30.56           C  
ATOM   7278  NZ  LYS C 290      30.099  -1.468   0.160  1.00 50.72           N  
ATOM   7279  N   ARG C 291      23.755   0.520  -2.924  1.00 20.56           N  
ATOM   7280  CA  ARG C 291      23.320  -0.105  -4.190  1.00 18.28           C  
ATOM   7281  C   ARG C 291      22.770   0.930  -5.155  1.00 17.83           C  
ATOM   7282  O   ARG C 291      23.006   0.860  -6.337  1.00 14.91           O  
ATOM   7283  CB  ARG C 291      22.307  -1.205  -3.934  1.00 17.40           C  
ATOM   7284  CG  ARG C 291      22.761  -2.238  -2.961  1.00 19.70           C  
ATOM   7285  CD  ARG C 291      24.159  -2.825  -3.304  1.00 20.07           C  
ATOM   7286  NE  ARG C 291      24.643  -3.713  -2.245  1.00 23.53           N  
ATOM   7287  CZ  ARG C 291      25.913  -4.068  -2.049  1.00 26.74           C  
ATOM   7288  NH1 ARG C 291      26.904  -3.573  -2.772  1.00 24.93           N  
ATOM   7289  NH2 ARG C 291      26.213  -4.867  -1.039  1.00 28.82           N  
ATOM   7290  N   ALA C 292      22.075   1.935  -4.651  1.00 14.95           N  
ATOM   7291  CA  ALA C 292      21.589   3.020  -5.498  1.00 17.37           C  
ATOM   7292  C   ALA C 292      22.746   3.803  -6.113  1.00 18.38           C  
ATOM   7293  O   ALA C 292      22.659   4.153  -7.274  1.00 20.02           O  
ATOM   7294  CB  ALA C 292      20.740   3.929  -4.737  1.00 15.57           C  
ATOM   7295  N   VAL C 293      23.841   4.018  -5.358  1.00 18.70           N  
ATOM   7296  CA  VAL C 293      25.016   4.739  -5.881  1.00 16.93           C  
ATOM   7297  C   VAL C 293      25.684   3.877  -6.950  1.00 18.48           C  
ATOM   7298  O   VAL C 293      26.067   4.350  -8.005  1.00 15.04           O  
ATOM   7299  CB  VAL C 293      25.999   5.107  -4.742  1.00 19.36           C  
ATOM   7300  CG1 VAL C 293      27.327   5.607  -5.312  1.00 19.80           C  
ATOM   7301  CG2 VAL C 293      25.363   6.146  -3.821  1.00 14.36           C  
ATOM   7302  N   GLN C 294      25.791   2.585  -6.681  1.00 16.43           N  
ATOM   7303  CA  GLN C 294      26.379   1.667  -7.643  1.00 13.75           C  
ATOM   7304  C   GLN C 294      25.639   1.554  -8.967  1.00 15.70           C  
ATOM   7305  O   GLN C 294      26.266   1.300 -10.001  1.00 19.58           O  
ATOM   7306  CB  GLN C 294      26.553   0.327  -6.999  1.00 15.14           C  
ATOM   7307  CG  GLN C 294      27.666   0.313  -6.006  1.00 18.36           C  
ATOM   7308  CD  GLN C 294      27.805  -1.088  -5.476  1.00 33.35           C  
ATOM   7309  OE1 GLN C 294      26.977  -1.536  -4.717  1.00 21.63           O  
ATOM   7310  NE2 GLN C 294      28.786  -1.811  -5.966  1.00 43.15           N  
ATOM   7311  N   LEU C 295      24.323   1.769  -8.928  1.00 17.24           N  
ATOM   7312  CA  LEU C 295      23.445   1.808 -10.090  1.00 19.37           C  
ATOM   7313  C   LEU C 295      23.482   3.179 -10.787  1.00 20.38           C  
ATOM   7314  O   LEU C 295      22.877   3.331 -11.841  1.00 23.14           O  
ATOM   7315  CB  LEU C 295      21.975   1.502  -9.679  1.00 17.77           C  
ATOM   7316  CG  LEU C 295      21.574   0.102  -9.181  1.00 12.68           C  
ATOM   7317  CD1 LEU C 295      20.204  -0.001  -8.579  1.00 20.47           C  
ATOM   7318  CD2 LEU C 295      21.730  -0.866 -10.396  1.00 14.69           C  
ATOM   7319  N   GLY C 296      24.207   4.149 -10.226  1.00 19.65           N  
ATOM   7320  CA  GLY C 296      24.253   5.499 -10.747  1.00 21.69           C  
ATOM   7321  C   GLY C 296      22.967   6.264 -10.542  1.00 20.19           C  
ATOM   7322  O   GLY C 296      22.687   7.234 -11.264  1.00 21.80           O  
HETATM 7323  N   MSE C 297      22.221   5.875  -9.510  1.00 22.55           N  
HETATM 7324  CA  MSE C 297      20.885   6.427  -9.231  1.00 21.47           C  
HETATM 7325  C   MSE C 297      20.872   7.226  -7.937  1.00 24.81           C  
HETATM 7326  O   MSE C 297      21.918   7.384  -7.295  1.00 27.57           O  
HETATM 7327  CB  MSE C 297      19.902   5.268  -9.180  1.00 21.43           C  
HETATM 7328  CG  MSE C 297      19.742   4.483 -10.477  1.00 21.74           C  
HETATM 7329 SE   MSE C 297      18.642   5.481 -11.729  0.75 18.71          SE  
HETATM 7330  CE  MSE C 297      19.926   6.502 -12.694  1.00 21.07           C  
ATOM   7331  N   GLU C 298      19.710   7.748  -7.542  1.00 24.02           N  
ATOM   7332  CA  GLU C 298      19.683   8.580  -6.323  1.00 26.31           C  
ATOM   7333  C   GLU C 298      19.319   7.724  -5.120  1.00 24.30           C  
ATOM   7334  O   GLU C 298      18.498   6.820  -5.210  1.00 22.86           O  
ATOM   7335  CB  GLU C 298      18.738   9.783  -6.424  1.00 25.30           C  
ATOM   7336  CG  GLU C 298      19.320  11.174  -5.803  1.00 29.34           C  
ATOM   7337  CD  GLU C 298      20.196  11.137  -4.459  1.00 52.77           C  
ATOM   7338  OE1 GLU C 298      21.275  10.448  -4.381  1.00 39.41           O  
ATOM   7339  OE2 GLU C 298      19.839  11.870  -3.484  1.00 55.49           O  
ATOM   7340  N   LYS C 299      19.966   8.010  -4.001  1.00 25.62           N  
ATOM   7341  CA  LYS C 299      19.771   7.301  -2.743  1.00 24.68           C  
ATOM   7342  C   LYS C 299      18.374   7.418  -2.173  1.00 26.73           C  
ATOM   7343  O   LYS C 299      17.822   8.523  -2.108  1.00 26.32           O  
ATOM   7344  CB  LYS C 299      20.702   7.863  -1.687  1.00 23.45           C  
ATOM   7345  CG  LYS C 299      22.175   7.629  -1.906  1.00 24.73           C  
ATOM   7346  CD  LYS C 299      22.941   8.334  -0.823  1.00 25.39           C  
ATOM   7347  CE  LYS C 299      24.413   8.373  -1.107  1.00 28.40           C  
ATOM   7348  NZ  LYS C 299      25.201   8.866   0.062  1.00 30.21           N  
ATOM   7349  N   PRO C 300      17.790   6.290  -1.728  1.00 24.58           N  
ATOM   7350  CA  PRO C 300      16.488   6.410  -1.086  1.00 23.91           C  
ATOM   7351  C   PRO C 300      16.506   7.054   0.315  1.00 24.07           C  
ATOM   7352  O   PRO C 300      15.524   7.670   0.720  1.00 23.42           O  
ATOM   7353  CB  PRO C 300      16.026   4.941  -1.018  1.00 22.77           C  
ATOM   7354  CG  PRO C 300      17.241   4.183  -0.913  1.00 26.97           C  
ATOM   7355  CD  PRO C 300      18.185   4.877  -1.854  1.00 28.27           C  
ATOM   7356  N   TYR C 301      17.626   6.934   1.029  1.00 25.54           N  
ATOM   7357  CA  TYR C 301      17.760   7.406   2.421  1.00 24.64           C  
ATOM   7358  C   TYR C 301      18.942   8.363   2.558  1.00 23.18           C  
ATOM   7359  O   TYR C 301      19.854   8.111   3.342  1.00 19.37           O  
ATOM   7360  CB  TYR C 301      17.943   6.183   3.345  1.00 24.91           C  
ATOM   7361  CG  TYR C 301      16.798   5.195   3.207  1.00 22.23           C  
ATOM   7362  CD1 TYR C 301      15.508   5.538   3.617  1.00 23.85           C  
ATOM   7363  CD2 TYR C 301      16.992   3.947   2.660  1.00 22.27           C  
ATOM   7364  CE1 TYR C 301      14.455   4.650   3.479  1.00 27.08           C  
ATOM   7365  CE2 TYR C 301      15.931   3.039   2.522  1.00 27.18           C  
ATOM   7366  CZ  TYR C 301      14.671   3.409   2.935  1.00 27.31           C  
ATOM   7367  OH  TYR C 301      13.633   2.499   2.796  1.00 27.11           O  
ATOM   7368  N   PRO C 302      18.878   9.518   1.870  1.00 24.05           N  
ATOM   7369  CA  PRO C 302      20.011  10.460   1.848  1.00 23.61           C  
ATOM   7370  C   PRO C 302      20.539  10.902   3.211  1.00 21.68           C  
ATOM   7371  O   PRO C 302      21.711  11.256   3.331  1.00 21.17           O  
ATOM   7372  CB  PRO C 302      19.444  11.674   1.088  1.00 24.85           C  
ATOM   7373  CG  PRO C 302      17.979  11.544   1.121  1.00 24.78           C  
ATOM   7374  CD  PRO C 302      17.723  10.059   1.125  1.00 22.78           C  
ATOM   7375  N   GLU C 303      19.674  10.896   4.219  1.00 23.13           N  
ATOM   7376  CA  GLU C 303      20.034  11.286   5.577  1.00 23.47           C  
ATOM   7377  C   GLU C 303      21.008  10.307   6.243  1.00 22.88           C  
ATOM   7378  O   GLU C 303      21.660  10.680   7.212  1.00 16.77           O  
ATOM   7379  CB  GLU C 303      18.769  11.457   6.449  1.00 26.04           C  
ATOM   7380  CG  GLU C 303      17.958  10.146   6.820  1.00 29.51           C  
ATOM   7381  CD  GLU C 303      17.075   9.516   5.703  1.00 28.00           C  
ATOM   7382  OE1 GLU C 303      17.009  10.005   4.555  1.00 25.22           O  
ATOM   7383  OE2 GLU C 303      16.418   8.502   6.008  1.00 35.50           O  
ATOM   7384  N   ILE C 304      21.058   9.068   5.737  1.00 22.37           N  
ATOM   7385  CA  ILE C 304      21.957   7.997   6.218  1.00 25.23           C  
ATOM   7386  C   ILE C 304      23.236   8.013   5.387  1.00 25.08           C  
ATOM   7387  O   ILE C 304      23.287   7.489   4.274  1.00 24.06           O  
ATOM   7388  CB  ILE C 304      21.323   6.588   6.155  1.00 23.68           C  
ATOM   7389  CG1 ILE C 304      19.992   6.535   6.906  1.00 22.86           C  
ATOM   7390  CG2 ILE C 304      22.258   5.562   6.781  1.00 21.96           C  
ATOM   7391  CD1 ILE C 304      20.153   6.702   8.345  1.00 17.86           C  
ATOM   7392  N   LYS C 305      24.268   8.615   5.962  1.00 24.15           N  
ATOM   7393  CA  LYS C 305      25.540   8.799   5.295  1.00 28.07           C  
ATOM   7394  C   LYS C 305      26.611   7.829   5.773  1.00 29.21           C  
ATOM   7395  O   LYS C 305      27.575   7.590   5.043  1.00 29.07           O  
ATOM   7396  CB  LYS C 305      25.991  10.253   5.464  1.00 30.03           C  
ATOM   7397  CG  LYS C 305      24.883  11.249   5.065  1.00 30.30           C  
ATOM   7398  CD  LYS C 305      25.410  12.617   4.666  1.00 32.74           C  
ATOM   7399  CE  LYS C 305      24.282  13.563   4.197  1.00 37.69           C  
ATOM   7400  NZ  LYS C 305      23.406  14.046   5.316  1.00 41.88           N  
ATOM   7401  N   HIS C 306      26.411   7.208   6.934  1.00 27.30           N  
ATOM   7402  CA  HIS C 306      27.437   6.373   7.543  1.00 28.49           C  
ATOM   7403  C   HIS C 306      27.003   4.974   7.914  1.00 29.27           C  
ATOM   7404  O   HIS C 306      25.871   4.756   8.375  1.00 28.91           O  
ATOM   7405  CB  HIS C 306      27.937   7.082   8.796  1.00 28.44           C  
ATOM   7406  CG  HIS C 306      28.432   8.469   8.519  1.00 30.81           C  
ATOM   7407  ND1 HIS C 306      29.580   8.715   7.797  1.00 30.94           N  
ATOM   7408  CD2 HIS C 306      27.909   9.682   8.819  1.00 31.56           C  
ATOM   7409  CE1 HIS C 306      29.763  10.021   7.700  1.00 35.86           C  
ATOM   7410  NE2 HIS C 306      28.770  10.631   8.324  1.00 32.74           N  
ATOM   7411  N   ASN C 307      27.938   4.043   7.727  1.00 30.45           N  
ATOM   7412  CA  ASN C 307      27.755   2.638   8.057  1.00 30.43           C  
ATOM   7413  C   ASN C 307      27.826   2.515   9.555  1.00 28.48           C  
ATOM   7414  O   ASN C 307      28.881   2.750  10.126  1.00 27.41           O  
ATOM   7415  CB  ASN C 307      28.872   1.814   7.466  1.00 28.58           C  
ATOM   7416  CG  ASN C 307      28.687   0.331   7.678  1.00 37.00           C  
ATOM   7417  OD1 ASN C 307      27.916  -0.130   8.526  1.00 34.69           O  
ATOM   7418  ND2 ASN C 307      29.404  -0.434   6.881  1.00 33.62           N  
ATOM   7419  N   PRO C 308      26.723   2.100  10.190  1.00 29.64           N  
ATOM   7420  CA  PRO C 308      26.717   1.965  11.636  1.00 32.99           C  
ATOM   7421  C   PRO C 308      27.311   0.626  12.128  1.00 33.89           C  
ATOM   7422  O   PRO C 308      27.427   0.429  13.334  1.00 36.65           O  
ATOM   7423  CB  PRO C 308      25.226   2.025  11.950  1.00 33.07           C  
ATOM   7424  CG  PRO C 308      24.647   1.235  10.818  1.00 32.13           C  
ATOM   7425  CD  PRO C 308      25.436   1.652   9.610  1.00 28.28           C  
HETATM 7426  N   MSE C 309      27.627  -0.292  11.216  1.00 34.90           N  
HETATM 7427  CA  MSE C 309      28.226  -1.585  11.559  1.00 36.25           C  
HETATM 7428  C   MSE C 309      29.508  -1.806  10.761  1.00 34.70           C  
HETATM 7429  O   MSE C 309      29.646  -2.804  10.027  1.00 33.48           O  
HETATM 7430  CB  MSE C 309      27.211  -2.711  11.348  1.00 35.46           C  
HETATM 7431  CG  MSE C 309      26.048  -2.676  12.365  1.00 36.07           C  
HETATM 7432 SE   MSE C 309      24.604  -3.862  11.778  0.75 40.07          SE  
HETATM 7433  CE  MSE C 309      25.658  -5.360  11.240  1.00 34.44           C  
ATOM   7434  N   LYS C 310      30.436  -0.858  10.946  1.00 35.89           N  
ATOM   7435  CA  LYS C 310      31.774  -0.881  10.339  1.00 37.96           C  
ATOM   7436  C   LYS C 310      32.599  -2.096  10.794  1.00 39.70           C  
ATOM   7437  O   LYS C 310      33.477  -2.561  10.044  1.00 40.52           O  
ATOM   7438  CB  LYS C 310      32.554   0.423  10.615  1.00 37.84           C  
ATOM   7439  CG  LYS C 310      32.140   1.588   9.745  1.00 38.03           C  
ATOM   7440  CD  LYS C 310      32.855   2.886  10.113  1.00 37.19           C  
ATOM   7441  N   TRP C 311      32.324  -2.605  12.006  1.00 40.76           N  
ATOM   7442  CA  TRP C 311      32.953  -3.847  12.503  1.00 40.56           C  
ATOM   7443  C   TRP C 311      32.847  -5.016  11.495  1.00 42.56           C  
ATOM   7444  O   TRP C 311      33.726  -5.887  11.489  1.00 42.47           O  
ATOM   7445  CB  TRP C 311      32.396  -4.269  13.869  1.00 39.15           C  
ATOM   7446  CG  TRP C 311      30.922  -4.655  13.920  1.00 35.59           C  
ATOM   7447  CD1 TRP C 311      29.896  -3.866  14.334  1.00 37.06           C  
ATOM   7448  CD2 TRP C 311      30.339  -5.934  13.607  1.00 40.03           C  
ATOM   7449  NE1 TRP C 311      28.709  -4.552  14.281  1.00 35.20           N  
ATOM   7450  CE2 TRP C 311      28.947  -5.822  13.829  1.00 39.73           C  
ATOM   7451  CE3 TRP C 311      30.853  -7.154  13.133  1.00 36.67           C  
ATOM   7452  CZ2 TRP C 311      28.062  -6.887  13.603  1.00 38.42           C  
ATOM   7453  CZ3 TRP C 311      29.977  -8.201  12.905  1.00 31.37           C  
ATOM   7454  CH2 TRP C 311      28.600  -8.062  13.139  1.00 37.45           C  
ATOM   7455  N   ILE C 312      31.784  -5.035  10.666  1.00 42.23           N  
ATOM   7456  CA  ILE C 312      31.635  -6.034   9.589  1.00 44.01           C  
ATOM   7457  C   ILE C 312      32.802  -6.002   8.568  1.00 46.67           C  
ATOM   7458  O   ILE C 312      33.154  -7.054   8.031  1.00 47.50           O  
ATOM   7459  CB  ILE C 312      30.255  -5.924   8.846  1.00 43.23           C  
ATOM   7460  CG1 ILE C 312      29.097  -6.254   9.788  1.00 41.29           C  
ATOM   7461  CG2 ILE C 312      30.200  -6.878   7.631  1.00 41.49           C  
ATOM   7462  CD1 ILE C 312      27.750  -6.264   9.103  1.00 38.46           C  
ATOM   7463  N   ARG C 313      33.430  -4.832   8.349  1.00 50.35           N  
ATOM   7464  CA  ARG C 313      34.568  -4.685   7.384  1.00 51.10           C  
ATOM   7465  C   ARG C 313      35.824  -5.515   7.697  1.00 53.23           C  
ATOM   7466  O   ARG C 313      35.976  -6.077   8.789  1.00 55.40           O  
ATOM   7467  CB  ARG C 313      34.982  -3.205   7.251  1.00 52.98           C  
TER    7468      ARG C 313                                                      
END
MOLECULE T0444.pdb
ATOM      1  N   ASN    34      17.414  -4.109 -29.873  1.00 62.50           N  
ATOM      2  CA  ASN    34      18.777  -3.956 -30.482  1.00 62.48           C  
ATOM      4  CB  ASN    34      18.890  -4.780 -31.780  1.00 62.57           C  
ATOM      7  CG  ASN    34      18.298  -4.075 -32.981  1.00 62.98           C  
ATOM      8  OD1 ASN    34      17.166  -3.585 -32.934  1.00 63.63           O  
ATOM      9  ND2 ASN    34      19.064  -4.020 -34.074  1.00 63.54           N  
ATOM     12  C   ASN    34      19.228  -2.489 -30.702  1.00 62.30           C  
ATOM     13  O   ASN    34      20.214  -2.232 -31.395  1.00 62.27           O  
ATOM     17  N   GLU    35      18.509  -1.541 -30.102  1.00 62.03           N  
ATOM     18  CA  GLU    35      19.052  -0.210 -29.838  1.00 61.84           C  
ATOM     20  CB  GLU    35      17.942   0.755 -29.379  1.00 61.76           C  
ATOM     23  CG  GLU    35      18.380   2.231 -29.228  1.00 61.90           C  
ATOM     26  CD  GLU    35      17.292   3.145 -28.668  1.00 61.87           C  
ATOM     27  OE1 GLU    35      16.701   2.811 -27.622  1.00 62.10           O  
ATOM     28  OE2 GLU    35      17.041   4.214 -29.264  1.00 61.80           O  
ATOM     29  C   GLU    35      20.129  -0.309 -28.750  1.00 61.78           C  
ATOM     30  O   GLU    35      20.903   0.627 -28.558  1.00 61.85           O  
ATOM     32  N   GLU    36      20.169  -1.439 -28.038  1.00 61.63           N  
ATOM     33  CA  GLU    36      21.056  -1.619 -26.888  1.00 61.47           C  
ATOM     35  CB  GLU    36      20.290  -2.295 -25.746  1.00 61.38           C  
ATOM     38  CG  GLU    36      19.398  -1.365 -24.945  1.00 60.97           C  
ATOM     41  CD  GLU    36      20.171  -0.463 -23.996  1.00 60.77           C  
ATOM     42  OE1 GLU    36      21.422  -0.565 -23.924  1.00 60.53           O  
ATOM     43  OE2 GLU    36      19.521   0.363 -23.318  1.00 60.54           O  
ATOM     44  C   GLU    36      22.270  -2.474 -27.249  1.00 61.48           C  
ATOM     45  O   GLU    36      22.102  -3.561 -27.800  1.00 61.84           O  
ATOM     47  N   PRO    37      23.496  -1.992 -26.943  1.00 61.19           N  
ATOM     48  CA  PRO    37      24.700  -2.800 -27.159  1.00 60.98           C  
ATOM     50  CB  PRO    37      25.821  -1.922 -26.592  1.00 60.78           C  
ATOM     53  CG  PRO    37      25.313  -0.569 -26.683  1.00 60.81           C  
ATOM     56  CD  PRO    37      23.841  -0.658 -26.429  1.00 61.18           C  
ATOM     59  C   PRO    37      24.694  -4.169 -26.469  1.00 60.67           C  
ATOM     60  O   PRO    37      25.197  -5.133 -27.040  1.00 60.51           O  
ATOM     61  N   LEU    38      24.134  -4.260 -25.267  1.00 60.59           N  
ATOM     62  CA  LEU    38      24.126  -5.534 -24.539  1.00 60.70           C  
ATOM     64  CB  LEU    38      23.789  -5.334 -23.053  1.00 60.59           C  
ATOM     67  CG  LEU    38      24.872  -4.725 -22.148  1.00 60.46           C  
ATOM     69  CD1 LEU    38      24.294  -4.252 -20.801  1.00 59.45           C  
ATOM     73  CD2 LEU    38      26.006  -5.718 -21.935  1.00 59.80           C  
ATOM     77  C   LEU    38      23.148  -6.527 -25.157  1.00 60.79           C  
ATOM     78  O   LEU    38      23.345  -7.738 -25.032  1.00 60.87           O  
ATOM     80  N   LEU    39      22.116  -6.020 -25.841  1.00 60.91           N  
ATOM     81  CA  LEU    39      20.985  -6.856 -26.289  1.00 60.99           C  
ATOM     83  CB  LEU    39      19.652  -6.166 -25.962  1.00 60.58           C  
ATOM     86  CG  LEU    39      19.340  -5.998 -24.474  1.00 60.10           C  
ATOM     88  CD1 LEU    39      18.405  -4.830 -24.230  1.00 58.90           C  
ATOM     92  CD2 LEU    39      18.771  -7.271 -23.900  1.00 59.94           C  
ATOM     96  C   LEU    39      20.989  -7.254 -27.764  1.00 60.96           C  
ATOM     97  O   LEU    39      20.204  -8.103 -28.160  1.00 60.80           O  
ATOM     99  N   ARG    40      21.856  -6.671 -28.578  1.00 61.51           N  
ATOM    100  CA  ARG    40      21.743  -6.875 -30.031  1.00 62.31           C  
ATOM    102  CB  ARG    40      22.231  -5.644 -30.795  1.00 62.38           C  
ATOM    105  CG  ARG    40      23.712  -5.372 -30.716  1.00 62.54           C  
ATOM    108  CD  ARG    40      24.009  -3.988 -31.256  1.00 63.08           C  
ATOM    111  NE  ARG    40      25.361  -3.562 -30.915  1.00 63.72           N  
ATOM    113  CZ  ARG    40      25.800  -2.304 -30.947  1.00 64.15           C  
ATOM    114  NH1 ARG    40      27.057  -2.060 -30.607  1.00 63.89           N  
ATOM    117  NH2 ARG    40      25.002  -1.292 -31.311  1.00 64.36           N  
ATOM    120  C   ARG    40      22.413  -8.147 -30.587  1.00 62.57           C  
ATOM    121  O   ARG    40      23.569  -8.444 -30.288  1.00 62.47           O  
ATOM    123  N   LYS    41      21.665  -8.863 -31.425  1.00 63.03           N  
ATOM    124  CA  LYS    41      22.141 -10.070 -32.108  1.00 63.36           C  
ATOM    126  CB  LYS    41      20.948 -10.850 -32.690  1.00 63.65           C  
ATOM    129  CG  LYS    41      19.909 -11.302 -31.642  1.00 64.35           C  
ATOM    132  CD  LYS    41      18.501 -11.519 -32.250  1.00 64.11           C  
ATOM    135  CE  LYS    41      17.442 -11.714 -31.139  1.00 64.70           C  
ATOM    138  NZ  LYS    41      16.044 -11.860 -31.664  1.00 65.05           N  
ATOM    142  C   LYS    41      23.117  -9.721 -33.238  1.00 63.23           C  
ATOM    143  O   LYS    41      24.318  -9.986 -33.145  1.00 62.96           O  
ATOM    145  N   VAL    47      34.367 -16.174 -32.166  1.00 67.40           N  
ATOM    146  CA  VAL    47      35.750 -15.811 -31.820  1.00 67.82           C  
ATOM    148  CB  VAL    47      36.629 -15.474 -33.133  1.00 67.99           C  
ATOM    150  CG1 VAL    47      36.239 -14.128 -33.783  1.00 67.91           C  
ATOM    154  CG2 VAL    47      38.158 -15.557 -32.866  1.00 67.27           C  
ATOM    158  C   VAL    47      35.758 -14.713 -30.713  1.00 67.90           C  
ATOM    159  O   VAL    47      35.959 -13.524 -30.980  1.00 67.39           O  
ATOM    161  N   ILE    48      35.513 -15.155 -29.468  1.00 68.27           N  
ATOM    162  CA  ILE    48      35.527 -14.308 -28.258  1.00 68.42           C  
ATOM    164  CB  ILE    48      35.639 -15.157 -26.961  1.00 68.45           C  
ATOM    166  CG1 ILE    48      34.299 -15.809 -26.613  1.00 69.04           C  
ATOM    169  CD1 ILE    48      34.327 -16.673 -25.334  1.00 68.20           C  
ATOM    173  CG2 ILE    48      36.099 -14.313 -25.785  1.00 68.09           C  
ATOM    177  C   ILE    48      36.686 -13.314 -28.254  1.00 68.90           C  
ATOM    178  O   ILE    48      36.519 -12.151 -27.864  1.00 69.76           O  
ATOM    180  N   PHE    49      37.865 -13.768 -28.669  1.00 68.87           N  
ATOM    181  CA  PHE    49      39.025 -12.886 -28.706  1.00 68.78           C  
ATOM    183  CB  PHE    49      40.334 -13.683 -28.551  1.00 69.25           C  
ATOM    186  CG  PHE    49      40.732 -13.882 -27.123  1.00 69.14           C  
ATOM    187  CD1 PHE    49      40.176 -14.897 -26.375  1.00 69.53           C  
ATOM    189  CE1 PHE    49      40.508 -15.059 -25.042  1.00 69.95           C  
ATOM    191  CZ  PHE    49      41.398 -14.188 -24.432  1.00 70.34           C  
ATOM    193  CE2 PHE    49      41.957 -13.165 -25.168  1.00 70.29           C  
ATOM    195  CD2 PHE    49      41.616 -13.012 -26.509  1.00 70.24           C  
ATOM    197  C   PHE    49      38.997 -12.059 -29.996  1.00 68.56           C  
ATOM    198  O   PHE    49      38.252 -12.395 -30.923  1.00 68.97           O  
ATOM    200  N   PRO    50      39.695 -10.902 -30.013  1.00 67.71           N  
ATOM    201  CA  PRO    50      40.018 -10.076 -28.841  1.00 66.48           C  
ATOM    203  CB  PRO    50      40.793  -8.894 -29.446  1.00 66.89           C  
ATOM    206  CG  PRO    50      41.367  -9.426 -30.720  1.00 67.15           C  
ATOM    209  CD  PRO    50      40.314 -10.367 -31.242  1.00 67.66           C  
ATOM    212  C   PRO    50      38.760  -9.581 -28.094  1.00 65.82           C  
ATOM    213  O   PRO    50      37.651  -9.522 -28.660  1.00 65.61           O  
ATOM    214  N   ILE    51      38.961  -9.244 -26.824  1.00 64.55           N  
ATOM    215  CA  ILE    51      37.883  -8.842 -25.932  1.00 63.73           C  
ATOM    217  CB  ILE    51      38.298  -8.934 -24.421  1.00 63.36           C  
ATOM    219  CG1 ILE    51      38.818 -10.329 -24.083  1.00 62.71           C  
ATOM    222  CD1 ILE    51      37.882 -11.447 -24.466  1.00 61.98           C  
ATOM    226  CG2 ILE    51      37.134  -8.600 -23.510  1.00 63.67           C  
ATOM    230  C   ILE    51      37.524  -7.409 -26.284  1.00 62.84           C  
ATOM    231  O   ILE    51      38.399  -6.549 -26.420  1.00 62.26           O  
ATOM    233  N   GLN    52      36.230  -7.177 -26.444  1.00 62.09           N  
ATOM    234  CA  GLN    52      35.712  -5.861 -26.763  1.00 61.64           C  
ATOM    236  CB  GLN    52      34.362  -5.974 -27.467  1.00 61.64           C  
ATOM    239  CG  GLN    52      34.288  -6.991 -28.580  1.00 62.28           C  
ATOM    242  CD  GLN    52      34.674  -6.418 -29.912  1.00 62.96           C  
ATOM    243  OE1 GLN    52      35.777  -5.887 -30.080  1.00 63.96           O  
ATOM    244  NE2 GLN    52      33.773  -6.532 -30.884  1.00 62.52           N  
ATOM    247  C   GLN    52      35.526  -5.061 -25.475  1.00 60.95           C  
ATOM    248  O   GLN    52      35.759  -3.848 -25.446  1.00 60.88           O  
ATOM    250  N   TYR    53      35.092  -5.765 -24.431  1.00 60.10           N  
ATOM    251  CA  TYR    53      34.758  -5.188 -23.143  1.00 59.71           C  
ATOM    253  CB  TYR    53      33.310  -5.516 -22.788  1.00 59.52           C  
ATOM    256  CG  TYR    53      32.331  -5.004 -23.802  1.00 59.78           C  
ATOM    257  CD1 TYR    53      31.706  -3.772 -23.635  1.00 60.00           C  
ATOM    259  CE1 TYR    53      30.808  -3.295 -24.580  1.00 59.90           C  
ATOM    261  CZ  TYR    53      30.532  -4.055 -25.704  1.00 59.83           C  
ATOM    262  OH  TYR    53      29.643  -3.588 -26.633  1.00 60.08           O  
ATOM    264  CE2 TYR    53      31.138  -5.276 -25.894  1.00 59.57           C  
ATOM    266  CD2 TYR    53      32.035  -5.744 -24.944  1.00 59.93           C  
ATOM    268  C   TYR    53      35.685  -5.728 -22.061  1.00 59.03           C  
ATOM    269  O   TYR    53      35.300  -6.615 -21.310  1.00 58.68           O  
ATOM    271  N   PRO    54      36.911  -5.186 -21.976  1.00 58.73           N  
ATOM    272  CA  PRO    54      37.855  -5.579 -20.941  1.00 58.85           C  
ATOM    274  CB  PRO    54      38.958  -4.514 -21.056  1.00 58.70           C  
ATOM    277  CG  PRO    54      38.434  -3.472 -21.972  1.00 58.18           C  
ATOM    280  CD  PRO    54      37.503  -4.171 -22.862  1.00 58.54           C  
ATOM    283  C   PRO    54      37.297  -5.602 -19.512  1.00 58.91           C  
ATOM    284  O   PRO    54      37.678  -6.464 -18.721  1.00 59.20           O  
ATOM    285  N   ASP    55      36.410  -4.674 -19.172  1.00 58.86           N  
ATOM    286  CA  ASP    55      35.960  -4.554 -17.781  1.00 58.91           C  
ATOM    288  CB  ASP    55      35.567  -3.111 -17.451  1.00 59.56           C  
ATOM    291  CG  ASP    55      34.508  -2.559 -18.378  1.00 62.61           C  
ATOM    292  OD1 ASP    55      34.472  -2.970 -19.579  1.00 65.82           O  
ATOM    293  OD2 ASP    55      33.718  -1.697 -17.900  1.00 66.48           O  
ATOM    294  C   ASP    55      34.857  -5.543 -17.394  1.00 58.36           C  
ATOM    295  O   ASP    55      34.796  -5.966 -16.242  1.00 58.09           O  
ATOM    297  N   ILE    56      34.011  -5.918 -18.353  1.00 57.79           N  
ATOM    298  CA  ILE    56      33.118  -7.069 -18.197  1.00 57.42           C  
ATOM    300  CB  ILE    56      32.157  -7.255 -19.410  1.00 57.35           C  
ATOM    302  CG1 ILE    56      31.052  -6.200 -19.434  1.00 57.67           C  
ATOM    305  CD1 ILE    56      31.482  -4.825 -19.916  1.00 58.90           C  
ATOM    309  CG2 ILE    56      31.468  -8.606 -19.354  1.00 57.68           C  
ATOM    313  C   ILE    56      33.980  -8.329 -18.061  1.00 57.12           C  
ATOM    314  O   ILE    56      33.707  -9.216 -17.241  1.00 57.57           O  
ATOM    316  N   TRP    57      35.030  -8.399 -18.869  1.00 56.20           N  
ATOM    317  CA  TRP    57      35.901  -9.570 -18.910  1.00 56.07           C  
ATOM    319  CB  TRP    57      36.811  -9.470 -20.130  1.00 55.14           C  
ATOM    322  CG  TRP    57      37.616 -10.673 -20.427  1.00 54.99           C  
ATOM    323  CD1 TRP    57      38.976 -10.759 -20.456  1.00 53.99           C  
ATOM    325  NE1 TRP    57      39.365 -12.029 -20.796  1.00 53.79           N  
ATOM    327  CE2 TRP    57      38.246 -12.795 -20.994  1.00 54.38           C  
ATOM    328  CD2 TRP    57      37.125 -11.971 -20.774  1.00 54.28           C  
ATOM    329  CE3 TRP    57      35.848 -12.519 -20.918  1.00 53.66           C  
ATOM    331  CZ3 TRP    57      35.730 -13.840 -21.275  1.00 53.60           C  
ATOM    333  CH2 TRP    57      36.856 -14.632 -21.489  1.00 54.07           C  
ATOM    335  CZ2 TRP    57      38.125 -14.134 -21.354  1.00 54.00           C  
ATOM    337  C   TRP    57      36.736  -9.690 -17.640  1.00 55.94           C  
ATOM    338  O   TRP    57      36.975 -10.779 -17.140  1.00 56.33           O  
ATOM    340  N   LYS    58      37.177  -8.561 -17.116  1.00 56.05           N  
ATOM    341  CA  LYS    58      37.971  -8.559 -15.903  1.00 55.97           C  
ATOM    343  CB  LYS    58      38.409  -7.129 -15.568  1.00 56.15           C  
ATOM    346  CG  LYS    58      39.512  -7.033 -14.528  1.00 56.62           C  
ATOM    349  CD  LYS    58      39.610  -5.613 -13.956  1.00 57.11           C  
ATOM    352  CE  LYS    58      40.623  -5.512 -12.811  1.00 57.90           C  
ATOM    355  NZ  LYS    58      40.965  -4.079 -12.537  1.00 58.72           N  
ATOM    359  C   LYS    58      37.183  -9.181 -14.746  1.00 55.49           C  
ATOM    360  O   LYS    58      37.759  -9.844 -13.899  1.00 55.46           O  
ATOM    362  N   MET    59      35.864  -8.983 -14.734  1.00 55.27           N  
ATOM    363  CA  MET    59      34.994  -9.497 -13.667  1.00 55.11           C  
ATOM    365  CB  MET    59      33.655  -8.758 -13.650  1.00 55.08           C  
ATOM    368  CG  MET    59      33.778  -7.297 -13.369  1.00 55.52           C  
ATOM    371  SD  MET    59      32.540  -6.672 -12.241  1.00 56.56           S  
ATOM    372  CE  MET    59      33.166  -5.007 -11.980  1.00 56.35           C  
ATOM    376  C   MET    59      34.727 -10.987 -13.800  1.00 54.46           C  
ATOM    377  O   MET    59      34.532 -11.665 -12.806  1.00 53.97           O  
ATOM    379  N   TYR    60      34.669 -11.477 -15.032  1.00 54.12           N  
ATOM    380  CA  TYR    60      34.645 -12.907 -15.282  1.00 54.16           C  
ATOM    382  CB  TYR    60      34.526 -13.168 -16.780  1.00 53.97           C  
ATOM    385  CG  TYR    60      34.667 -14.622 -17.149  1.00 54.21           C  
ATOM    386  CD1 TYR    60      33.927 -15.601 -16.488  1.00 53.75           C  
ATOM    388  CE1 TYR    60      34.058 -16.936 -16.826  1.00 54.13           C  
ATOM    390  CZ  TYR    60      34.923 -17.310 -17.835  1.00 53.09           C  
ATOM    391  OH  TYR    60      35.049 -18.633 -18.141  1.00 53.60           O  
ATOM    393  CE2 TYR    60      35.670 -16.369 -18.504  1.00 53.25           C  
ATOM    395  CD2 TYR    60      35.541 -15.027 -18.159  1.00 54.00           C  
ATOM    397  C   TYR    60      35.924 -13.558 -14.744  1.00 54.22           C  
ATOM    398  O   TYR    60      35.888 -14.571 -14.020  1.00 54.16           O  
ATOM    400  N   LYS    61      37.057 -12.959 -15.100  1.00 54.00           N  
ATOM    401  CA  LYS    61      38.348 -13.420 -14.616  1.00 53.83           C  
ATOM    403  CB  LYS    61      39.473 -12.629 -15.273  1.00 52.78           C  
ATOM    406  CG  LYS    61      39.627 -12.953 -16.736  1.00 51.31           C  
ATOM    409  CD  LYS    61      40.222 -14.342 -16.922  1.00 50.39           C  
ATOM    412  CE  LYS    61      39.887 -14.936 -18.270  1.00 50.09           C  
ATOM    415  NZ  LYS    61      40.017 -16.413 -18.268  1.00 49.63           N  
ATOM    419  C   LYS    61      38.458 -13.392 -13.089  1.00 54.16           C  
ATOM    420  O   LYS    61      39.118 -14.238 -12.494  1.00 54.56           O  
ATOM    422  N   GLN    62      37.798 -12.444 -12.452  1.00 54.54           N  
ATOM    423  CA  GLN    62      37.782 -12.398 -11.002  1.00 55.27           C  
ATOM    425  CB  GLN    62      37.246 -11.054 -10.569  1.00 55.47           C  
ATOM    428  CG  GLN    62      37.625 -10.625  -9.173  1.00 57.28           C  
ATOM    431  CD  GLN    62      37.217  -9.175  -8.928  1.00 58.50           C  
ATOM    432  OE1 GLN    62      37.508  -8.279  -9.757  1.00 62.46           O  
ATOM    433  NE2 GLN    62      36.527  -8.930  -7.807  1.00 61.58           N  
ATOM    436  C   GLN    62      36.926 -13.539 -10.419  1.00 55.12           C  
ATOM    437  O   GLN    62      37.280 -14.137  -9.400  1.00 55.04           O  
ATOM    439  N   ALA    63      35.807 -13.842 -11.079  1.00 55.27           N  
ATOM    440  CA  ALA    63      34.944 -14.973 -10.704  1.00 55.09           C  
ATOM    442  CB  ALA    63      33.767 -15.084 -11.658  1.00 54.67           C  
ATOM    446  C   ALA    63      35.731 -16.283 -10.693  1.00 55.07           C  
ATOM    447  O   ALA    63      35.754 -16.988  -9.678  1.00 55.03           O  
ATOM    449  N   GLN    64      36.373 -16.594 -11.822  1.00 54.83           N  
ATOM    450  CA  GLN    64      37.217 -17.782 -11.933  1.00 54.88           C  
ATOM    452  CB  GLN    64      37.914 -17.823 -13.295  1.00 55.20           C  
ATOM    455  CG  GLN    64      37.054 -18.219 -14.482  1.00 55.33           C  
ATOM    458  CD  GLN    64      37.897 -18.425 -15.746  1.00 54.34           C  
ATOM    459  OE1 GLN    64      38.807 -17.660 -16.017  1.00 53.12           O  
ATOM    460  NE2 GLN    64      37.574 -19.447 -16.521  1.00 53.56           N  
ATOM    463  C   GLN    64      38.294 -17.838 -10.838  1.00 54.74           C  
ATOM    464  O   GLN    64      38.489 -18.861 -10.199  1.00 54.19           O  
ATOM    466  N   ALA    65      38.986 -16.725 -10.636  1.00 54.86           N  
ATOM    467  CA  ALA    65      40.022 -16.632  -9.615  1.00 55.20           C  
ATOM    469  CB  ALA    65      40.520 -15.192  -9.485  1.00 54.81           C  
ATOM    473  C   ALA    65      39.526 -17.136  -8.263  1.00 55.37           C  
ATOM    474  O   ALA    65      40.282 -17.754  -7.511  1.00 56.04           O  
ATOM    476  N   SER    66      38.260 -16.878  -7.963  1.00 55.39           N  
ATOM    477  CA  SER    66      37.708 -17.146  -6.641  1.00 55.63           C  
ATOM    479  CB  SER    66      36.910 -15.924  -6.201  1.00 55.52           C  
ATOM    482  OG  SER    66      35.980 -15.595  -7.212  1.00 56.22           O  
ATOM    484  C   SER    66      36.814 -18.398  -6.611  1.00 55.74           C  
ATOM    485  O   SER    66      35.890 -18.496  -5.816  1.00 55.91           O  
ATOM    487  N   PHE    67      37.095 -19.354  -7.474  1.00 55.60           N  
ATOM    488  CA  PHE    67      36.331 -20.582  -7.516  1.00 55.75           C  
ATOM    490  CB  PHE    67      36.816 -21.384  -8.714  1.00 56.72           C  
ATOM    493  CG  PHE    67      36.360 -22.804  -8.726  1.00 57.15           C  
ATOM    494  CD1 PHE    67      35.074 -23.125  -9.119  1.00 57.72           C  
ATOM    496  CE1 PHE    67      34.662 -24.450  -9.150  1.00 58.44           C  
ATOM    498  CZ  PHE    67      35.549 -25.460  -8.794  1.00 58.13           C  
ATOM    500  CE2 PHE    67      36.832 -25.141  -8.401  1.00 57.59           C  
ATOM    502  CD2 PHE    67      37.232 -23.825  -8.369  1.00 57.45           C  
ATOM    504  C   PHE    67      36.529 -21.417  -6.262  1.00 55.49           C  
ATOM    505  O   PHE    67      37.657 -21.591  -5.833  1.00 55.93           O  
ATOM    507  N   TRP    68      35.447 -21.955  -5.700  1.00 55.06           N  
ATOM    508  CA  TRP    68      35.524 -22.908  -4.585  1.00 54.74           C  
ATOM    510  CB  TRP    68      35.460 -22.182  -3.248  1.00 54.46           C  
ATOM    513  CG  TRP    68      34.259 -21.316  -3.043  1.00 54.13           C  
ATOM    514  CD1 TRP    68      33.993 -20.144  -3.658  1.00 54.22           C  
ATOM    516  NE1 TRP    68      32.808 -19.621  -3.206  1.00 54.17           N  
ATOM    518  CE2 TRP    68      32.291 -20.457  -2.260  1.00 53.75           C  
ATOM    519  CD2 TRP    68      33.186 -21.536  -2.122  1.00 53.62           C  
ATOM    520  CE3 TRP    68      32.886 -22.548  -1.209  1.00 53.42           C  
ATOM    522  CZ3 TRP    68      31.724 -22.449  -0.474  1.00 54.37           C  
ATOM    524  CH2 TRP    68      30.851 -21.355  -0.626  1.00 54.24           C  
ATOM    526  CZ2 TRP    68      31.118 -20.357  -1.520  1.00 54.29           C  
ATOM    528  C   TRP    68      34.441 -23.983  -4.650  1.00 54.74           C  
ATOM    529  O   TRP    68      33.599 -23.973  -5.538  1.00 54.91           O  
ATOM    531  N   THR    69      34.500 -24.932  -3.722  1.00 54.97           N  
ATOM    532  CA  THR    69      33.529 -26.018  -3.626  1.00 54.94           C  
ATOM    534  CB  THR    69      34.128 -27.355  -4.111  1.00 54.95           C  
ATOM    536  OG1 THR    69      35.140 -27.818  -3.192  1.00 52.92           O  
ATOM    538  CG2 THR    69      34.695 -27.204  -5.520  1.00 53.39           C  
ATOM    542  C   THR    69      33.138 -26.180  -2.172  1.00 55.48           C  
ATOM    543  O   THR    69      33.939 -25.922  -1.295  1.00 55.52           O  
ATOM    545  N   ALA    70      31.920 -26.628  -1.906  1.00 56.33           N  
ATOM    546  CA  ALA    70      31.450 -26.766  -0.527  1.00 56.93           C  
ATOM    548  CB  ALA    70      29.998 -27.252  -0.489  1.00 56.68           C  
ATOM    552  C   ALA    70      32.371 -27.665   0.320  1.00 57.67           C  
ATOM    553  O   ALA    70      32.560 -27.393   1.508  1.00 58.40           O  
ATOM    555  N   GLU    71      32.964 -28.693  -0.294  1.00 58.23           N  
ATOM    556  CA  GLU    71      33.962 -29.557   0.371  1.00 58.80           C  
ATOM    558  CB  GLU    71      34.474 -30.638  -0.584  1.00 59.26           C  
ATOM    561  CG  GLU    71      33.456 -31.719  -0.941  1.00 60.49           C  
ATOM    564  CD  GLU    71      32.848 -31.529  -2.324  1.00 62.15           C  
ATOM    565  OE1 GLU    71      32.360 -30.410  -2.649  1.00 61.82           O  
ATOM    566  OE2 GLU    71      32.871 -32.524  -3.082  1.00 63.58           O  
ATOM    567  C   GLU    71      35.187 -28.834   0.936  1.00 59.04           C  
ATOM    568  O   GLU    71      35.692 -29.216   1.972  1.00 59.30           O  
ATOM    570  N   GLU    72      35.681 -27.824   0.233  1.00 59.70           N  
ATOM    571  CA  GLU    72      36.767 -26.962   0.720  1.00 60.20           C  
ATOM    573  CB  GLU    72      36.876 -25.701  -0.138  1.00 60.63           C  
ATOM    576  CG  GLU    72      37.858 -25.643  -1.302  1.00 61.74           C  
ATOM    579  CD  GLU    72      38.024 -24.179  -1.752  1.00 62.95           C  
ATOM    580  OE1 GLU    72      37.461 -23.300  -1.039  1.00 66.80           O  
ATOM    581  OE2 GLU    72      38.695 -23.886  -2.782  1.00 67.13           O  
ATOM    582  C   GLU    72      36.559 -26.425   2.133  1.00 60.11           C  
ATOM    583  O   GLU    72      37.526 -26.062   2.783  1.00 60.21           O  
ATOM    585  N   VAL    73      35.312 -26.276   2.582  1.00 60.01           N  
ATOM    586  CA  VAL    73      35.056 -25.657   3.890  1.00 59.79           C  
ATOM    588  CB  VAL    73      33.771 -24.809   3.875  1.00 59.82           C  
ATOM    590  CG1 VAL    73      33.375 -24.397   5.305  1.00 58.39           C  
ATOM    594  CG2 VAL    73      33.965 -23.586   2.961  1.00 59.05           C  
ATOM    598  C   VAL    73      34.975 -26.689   5.006  1.00 59.83           C  
ATOM    599  O   VAL    73      34.180 -27.618   4.932  1.00 60.22           O  
ATOM    601  N   ASP    74      35.780 -26.487   6.049  1.00 59.90           N  
ATOM    602  CA  ASP    74      35.933 -27.431   7.155  1.00 59.73           C  
ATOM    604  CB  ASP    74      37.342 -27.291   7.755  1.00 59.85           C  
ATOM    607  CG  ASP    74      37.521 -28.051   9.078  1.00 60.55           C  
ATOM    608  OD1 ASP    74      36.740 -28.987   9.389  1.00 60.99           O  
ATOM    609  OD2 ASP    74      38.466 -27.696   9.818  1.00 62.36           O  
ATOM    610  C   ASP    74      34.899 -27.175   8.224  1.00 59.55           C  
ATOM    611  O   ASP    74      34.923 -26.130   8.856  1.00 59.56           O  
ATOM    613  N   LEU    75      34.016 -28.145   8.438  1.00 59.60           N  
ATOM    614  CA  LEU    75      32.958 -28.048   9.459  1.00 59.78           C  
ATOM    616  CB  LEU    75      31.607 -28.482   8.864  1.00 59.19           C  
ATOM    619  CG  LEU    75      31.152 -27.741   7.607  1.00 57.60           C  
ATOM    621  CD1 LEU    75      29.817 -28.264   7.085  1.00 54.79           C  
ATOM    625  CD2 LEU    75      31.075 -26.262   7.904  1.00 56.43           C  
ATOM    629  C   LEU    75      33.250 -28.894  10.711  1.00 60.26           C  
ATOM    630  O   LEU    75      32.406 -29.000  11.605  1.00 60.50           O  
ATOM    632  N   SER    76      34.443 -29.482  10.790  1.00 60.73           N  
ATOM    633  CA  SER    76      34.755 -30.450  11.854  1.00 60.77           C  
ATOM    635  CB  SER    76      36.099 -31.117  11.575  1.00 60.67           C  
ATOM    638  OG  SER    76      37.126 -30.145  11.530  1.00 60.41           O  
ATOM    640  C   SER    76      34.781 -29.854  13.262  1.00 61.00           C  
ATOM    641  O   SER    76      34.590 -30.570  14.233  1.00 61.29           O  
ATOM    643  N   LYS    77      35.016 -28.552  13.375  1.00 61.29           N  
ATOM    644  CA  LYS    77      35.188 -27.920  14.680  1.00 61.48           C  
ATOM    646  CB  LYS    77      36.430 -27.023  14.648  1.00 61.66           C  
ATOM    649  CG  LYS    77      37.724 -27.800  14.404  1.00 62.38           C  
ATOM    652  CD  LYS    77      38.949 -26.890  14.367  1.00 62.29           C  
ATOM    655  CE  LYS    77      40.216 -27.653  14.759  1.00 62.69           C  
ATOM    658  NZ  LYS    77      41.459 -26.882  14.449  1.00 62.97           N  
ATOM    662  C   LYS    77      33.972 -27.107  15.110  1.00 61.43           C  
ATOM    663  O   LYS    77      34.108 -26.166  15.887  1.00 61.66           O  
ATOM    665  N   ASP    78      32.786 -27.491  14.640  1.00 61.37           N  
ATOM    666  CA  ASP    78      31.596 -26.620  14.720  1.00 61.26           C  
ATOM    668  CB  ASP    78      30.949 -26.481  13.332  1.00 61.32           C  
ATOM    671  CG  ASP    78      31.537 -25.327  12.520  1.00 62.09           C  
ATOM    672  OD1 ASP    78      32.777 -25.139  12.534  1.00 63.10           O  
ATOM    673  OD2 ASP    78      30.755 -24.594  11.875  1.00 62.73           O  
ATOM    674  C   ASP    78      30.540 -27.034  15.754  1.00 60.97           C  
ATOM    675  O   ASP    78      29.955 -26.177  16.413  1.00 60.74           O  
ATOM    677  N   LEU    79      30.303 -28.334  15.895  1.00 60.77           N  
ATOM    678  CA  LEU    79      29.325 -28.838  16.855  1.00 60.66           C  
ATOM    680  CB  LEU    79      29.178 -30.362  16.739  1.00 60.73           C  
ATOM    683  CG  LEU    79      28.325 -30.785  15.530  1.00 61.47           C  
ATOM    685  CD1 LEU    79      28.575 -32.226  15.104  1.00 61.65           C  
ATOM    689  CD2 LEU    79      26.845 -30.566  15.817  1.00 62.11           C  
ATOM    693  C   LEU    79      29.599 -28.410  18.302  1.00 60.35           C  
ATOM    694  O   LEU    79      28.662 -28.088  19.026  1.00 60.29           O  
ATOM    696  N   PRO    80      30.874 -28.390  18.729  1.00 60.27           N  
ATOM    697  CA  PRO    80      31.151 -27.823  20.059  1.00 60.24           C  
ATOM    699  CB  PRO    80      32.682 -27.882  20.159  1.00 60.04           C  
ATOM    702  CG  PRO    80      33.075 -28.976  19.242  1.00 60.05           C  
ATOM    705  CD  PRO    80      32.104 -28.892  18.090  1.00 60.40           C  
ATOM    708  C   PRO    80      30.644 -26.386  20.242  1.00 60.19           C  
ATOM    709  O   PRO    80      30.010 -26.096  21.255  1.00 60.24           O  
ATOM    710  N   HIS    81      30.915 -25.513  19.267  1.00 60.16           N  
ATOM    711  CA  HIS    81      30.460 -24.115  19.297  1.00 59.94           C  
ATOM    713  CB  HIS    81      31.047 -23.328  18.129  1.00 60.30           C  
ATOM    716  CG  HIS    81      32.531 -23.175  18.192  1.00 61.21           C  
ATOM    717  ND1 HIS    81      33.396 -24.175  17.808  1.00 62.17           N  
ATOM    719  CE1 HIS    81      34.640 -23.767  17.984  1.00 62.00           C  
ATOM    721  NE2 HIS    81      34.611 -22.537  18.463  1.00 61.75           N  
ATOM    723  CD2 HIS    81      33.304 -22.142  18.601  1.00 61.89           C  
ATOM    725  C   HIS    81      28.948 -24.030  19.206  1.00 59.71           C  
ATOM    726  O   HIS    81      28.317 -23.261  19.931  1.00 59.89           O  
ATOM    728  N   TRP    82      28.380 -24.808  18.290  1.00 59.34           N  
ATOM    729  CA  TRP    82      26.937 -24.955  18.163  1.00 59.11           C  
ATOM    731  CB  TRP    82      26.627 -26.042  17.139  1.00 58.79           C  
ATOM    734  CG  TRP    82      25.207 -26.389  17.061  1.00 58.60           C  
ATOM    735  CD1 TRP    82      24.611 -27.476  17.602  1.00 58.44           C  
ATOM    737  NE1 TRP    82      23.267 -27.458  17.340  1.00 58.44           N  
ATOM    739  CE2 TRP    82      22.972 -26.343  16.608  1.00 57.72           C  
ATOM    740  CD2 TRP    82      24.176 -25.638  16.419  1.00 57.76           C  
ATOM    741  CE3 TRP    82      24.154 -24.439  15.703  1.00 57.82           C  
ATOM    743  CZ3 TRP    82      22.954 -23.995  15.198  1.00 58.63           C  
ATOM    745  CH2 TRP    82      21.764 -24.729  15.400  1.00 58.73           C  
ATOM    747  CZ2 TRP    82      21.760 -25.902  16.104  1.00 57.78           C  
ATOM    749  C   TRP    82      26.273 -25.279  19.511  1.00 59.17           C  
ATOM    750  O   TRP    82      25.349 -24.579  19.938  1.00 59.62           O  
ATOM    752  N   ASN    83      26.765 -26.305  20.198  1.00 58.83           N  
ATOM    753  CA  ASN    83      26.229 -26.672  21.520  1.00 58.61           C  
ATOM    755  CB  ASN    83      26.873 -27.965  22.004  1.00 58.48           C  
ATOM    758  CG  ASN    83      26.658 -29.113  21.042  1.00 58.98           C  
ATOM    759  OD1 ASN    83      25.577 -29.255  20.466  1.00 61.14           O  
ATOM    760  ND2 ASN    83      27.688 -29.935  20.852  1.00 58.05           N  
ATOM    763  C   ASN    83      26.375 -25.599  22.611  1.00 58.52           C  
ATOM    764  O   ASN    83      25.677 -25.642  23.630  1.00 58.69           O  
ATOM    766  N   LYS    84      27.281 -24.646  22.409  1.00 58.38           N  
ATOM    767  CA  LYS    84      27.428 -23.518  23.337  1.00 58.02           C  
ATOM    769  CB  LYS    84      28.824 -22.873  23.235  1.00 58.43           C  
ATOM    772  CG  LYS    84      29.919 -23.558  24.071  1.00 59.72           C  
ATOM    775  CD  LYS    84      29.571 -23.689  25.574  1.00 61.21           C  
ATOM    778  CE  LYS    84      29.109 -22.359  26.216  1.00 62.06           C  
ATOM    781  NZ  LYS    84      28.889 -22.467  27.702  1.00 61.75           N  
ATOM    785  C   LYS    84      26.360 -22.454  23.129  1.00 57.49           C  
ATOM    786  O   LYS    84      26.123 -21.649  24.029  1.00 57.54           O  
ATOM    788  N   LEU    85      25.722 -22.444  21.959  1.00 56.67           N  
ATOM    789  CA  LEU    85      24.635 -21.491  21.686  1.00 56.13           C  
ATOM    791  CB  LEU    85      24.262 -21.524  20.198  1.00 56.06           C  
ATOM    794  CG  LEU    85      25.349 -21.264  19.166  1.00 55.99           C  
ATOM    796  CD1 LEU    85      24.754 -21.172  17.757  1.00 56.93           C  
ATOM    800  CD2 LEU    85      26.066 -20.004  19.508  1.00 56.07           C  
ATOM    804  C   LEU    85      23.376 -21.767  22.546  1.00 55.41           C  
ATOM    805  O   LEU    85      23.129 -22.901  22.960  1.00 55.10           O  
ATOM    807  N   LYS    86      22.578 -20.730  22.795  1.00 54.85           N  
ATOM    808  CA  LYS    86      21.336 -20.870  23.581  1.00 54.68           C  
ATOM    810  CB  LYS    86      21.162 -19.657  24.492  1.00 54.72           C  
ATOM    813  CG  LYS    86      22.288 -19.546  25.509  1.00 55.02           C  
ATOM    816  CD  LYS    86      22.188 -18.289  26.372  1.00 55.61           C  
ATOM    819  CE  LYS    86      23.471 -18.046  27.198  1.00 56.25           C  
ATOM    822  NZ  LYS    86      24.246 -19.299  27.482  1.00 56.74           N  
ATOM    826  C   LYS    86      20.083 -21.094  22.719  1.00 53.82           C  
ATOM    827  O   LYS    86      20.081 -20.787  21.535  1.00 54.00           O  
ATOM    829  N   ALA    87      19.033 -21.645  23.325  1.00 53.15           N  
ATOM    830  CA  ALA    87      17.791 -22.007  22.623  1.00 52.88           C  
ATOM    832  CB  ALA    87      16.658 -22.262  23.623  1.00 51.92           C  
ATOM    836  C   ALA    87      17.373 -20.964  21.587  1.00 52.53           C  
ATOM    837  O   ALA    87      17.083 -21.311  20.438  1.00 52.23           O  
ATOM    839  N   ASP    88      17.378 -19.690  21.989  1.00 52.79           N  
ATOM    840  CA  ASP    88      16.978 -18.573  21.103  1.00 52.82           C  
ATOM    842  CB  ASP    88      16.710 -17.265  21.895  1.00 52.73           C  
ATOM    845  CG  ASP    88      17.951 -16.712  22.618  1.00 53.11           C  
ATOM    846  OD1 ASP    88      18.922 -17.458  22.847  1.00 53.68           O  
ATOM    847  OD2 ASP    88      17.945 -15.516  22.982  1.00 52.90           O  
ATOM    848  C   ASP    88      17.935 -18.329  19.922  1.00 52.67           C  
ATOM    849  O   ASP    88      17.491 -17.986  18.838  1.00 52.64           O  
ATOM    851  N   GLU    89      19.232 -18.524  20.133  1.00 52.67           N  
ATOM    852  CA  GLU    89      20.230 -18.329  19.088  1.00 52.74           C  
ATOM    854  CB  GLU    89      21.613 -18.161  19.700  1.00 52.84           C  
ATOM    857  CG  GLU    89      21.725 -16.909  20.568  1.00 53.60           C  
ATOM    860  CD  GLU    89      23.030 -16.826  21.369  1.00 54.19           C  
ATOM    861  OE1 GLU    89      23.517 -17.867  21.879  1.00 56.08           O  
ATOM    862  OE2 GLU    89      23.547 -15.697  21.514  1.00 55.98           O  
ATOM    863  C   GLU    89      20.242 -19.485  18.107  1.00 52.51           C  
ATOM    864  O   GLU    89      20.492 -19.290  16.910  1.00 52.81           O  
ATOM    866  N   LYS    90      19.973 -20.688  18.603  1.00 52.08           N  
ATOM    867  CA  LYS    90      19.845 -21.849  17.722  1.00 51.93           C  
ATOM    869  CB  LYS    90      19.797 -23.148  18.516  1.00 52.05           C  
ATOM    872  CG  LYS    90      21.152 -23.678  18.916  1.00 52.49           C  
ATOM    875  CD  LYS    90      20.989 -25.046  19.565  1.00 52.52           C  
ATOM    878  CE  LYS    90      22.301 -25.563  20.127  1.00 53.25           C  
ATOM    881  NZ  LYS    90      22.116 -26.866  20.805  1.00 53.70           N  
ATOM    885  C   LYS    90      18.617 -21.756  16.835  1.00 51.26           C  
ATOM    886  O   LYS    90      18.678 -22.115  15.669  1.00 51.31           O  
ATOM    888  N   TYR    91      17.503 -21.299  17.393  1.00 50.93           N  
ATOM    889  CA  TYR    91      16.278 -21.082  16.611  1.00 50.83           C  
ATOM    891  CB  TYR    91      15.157 -20.542  17.511  1.00 50.29           C  
ATOM    894  CG  TYR    91      13.801 -20.389  16.833  1.00 50.56           C  
ATOM    895  CD1 TYR    91      12.854 -21.403  16.899  1.00 49.99           C  
ATOM    897  CE1 TYR    91      11.627 -21.269  16.293  1.00 49.89           C  
ATOM    899  CZ  TYR    91      11.315 -20.098  15.620  1.00 50.02           C  
ATOM    900  OH  TYR    91      10.079 -19.982  15.012  1.00 49.78           O  
ATOM    902  CE2 TYR    91      12.224 -19.071  15.552  1.00 49.04           C  
ATOM    904  CD2 TYR    91      13.456 -19.216  16.156  1.00 49.88           C  
ATOM    906  C   TYR    91      16.583 -20.096  15.474  1.00 50.54           C  
ATOM    907  O   TYR    91      16.317 -20.369  14.311  1.00 50.01           O  
ATOM    909  N   PHE    92      17.184 -18.967  15.821  1.00 50.67           N  
ATOM    910  CA  PHE    92      17.545 -17.964  14.830  1.00 51.15           C  
ATOM    912  CB  PHE    92      18.191 -16.745  15.499  1.00 51.06           C  
ATOM    915  CG  PHE    92      18.501 -15.638  14.544  1.00 50.38           C  
ATOM    916  CD1 PHE    92      17.567 -14.678  14.263  1.00 50.90           C  
ATOM    918  CE1 PHE    92      17.843 -13.665  13.365  1.00 51.56           C  
ATOM    920  CZ  PHE    92      19.077 -13.613  12.743  1.00 51.38           C  
ATOM    922  CE2 PHE    92      20.013 -14.572  13.016  1.00 50.68           C  
ATOM    924  CD2 PHE    92      19.721 -15.580  13.907  1.00 50.30           C  
ATOM    926  C   PHE    92      18.482 -18.488  13.722  1.00 51.52           C  
ATOM    927  O   PHE    92      18.243 -18.230  12.525  1.00 51.86           O  
ATOM    929  N   ILE    93      19.552 -19.179  14.113  1.00 51.37           N  
ATOM    930  CA  ILE    93      20.559 -19.589  13.147  1.00 51.55           C  
ATOM    932  CB  ILE    93      21.846 -20.078  13.834  1.00 51.58           C  
ATOM    934  CG1 ILE    93      22.655 -18.873  14.301  1.00 51.62           C  
ATOM    937  CD1 ILE    93      23.610 -19.214  15.416  1.00 52.52           C  
ATOM    941  CG2 ILE    93      22.725 -20.894  12.892  1.00 51.00           C  
ATOM    945  C   ILE    93      19.968 -20.653  12.261  1.00 51.70           C  
ATOM    946  O   ILE    93      20.033 -20.580  11.039  1.00 51.68           O  
ATOM    948  N   SER    94      19.354 -21.641  12.875  1.00 52.27           N  
ATOM    949  CA  SER    94      18.739 -22.698  12.099  1.00 52.49           C  
ATOM    951  CB  SER    94      18.125 -23.756  13.020  1.00 52.29           C  
ATOM    954  OG  SER    94      17.054 -23.193  13.735  1.00 52.51           O  
ATOM    956  C   SER    94      17.703 -22.108  11.133  1.00 52.65           C  
ATOM    957  O   SER    94      17.608 -22.570  10.016  1.00 53.29           O  
ATOM    959  N   HIS    95      16.952 -21.080  11.533  1.00 52.71           N  
ATOM    960  CA  HIS    95      15.981 -20.479  10.611  1.00 52.67           C  
ATOM    962  CB  HIS    95      14.941 -19.637  11.326  1.00 52.49           C  
ATOM    965  CG  HIS    95      13.826 -20.444  11.913  1.00 52.23           C  
ATOM    966  ND1 HIS    95      14.051 -21.530  12.730  1.00 52.10           N  
ATOM    968  CE1 HIS    95      12.895 -22.035  13.116  1.00 51.10           C  
ATOM    970  NE2 HIS    95      11.928 -21.325  12.568  1.00 50.47           N  
ATOM    972  CD2 HIS    95      12.483 -20.322  11.813  1.00 50.91           C  
ATOM    974  C   HIS    95      16.583 -19.673   9.482  1.00 52.89           C  
ATOM    975  O   HIS    95      16.113 -19.811   8.359  1.00 53.24           O  
ATOM    977  N   ILE    96      17.584 -18.827   9.737  1.00 53.22           N  
ATOM    978  CA  ILE    96      18.154 -18.047   8.625  1.00 53.69           C  
ATOM    980  CB  ILE    96      19.059 -16.834   9.039  1.00 53.92           C  
ATOM    982  CG1 ILE    96      20.345 -17.288   9.694  1.00 55.59           C  
ATOM    985  CD1 ILE    96      21.454 -17.548   8.658  1.00 57.60           C  
ATOM    989  CG2 ILE    96      18.319 -15.841   9.915  1.00 54.51           C  
ATOM    993  C   ILE    96      18.859 -18.966   7.610  1.00 53.82           C  
ATOM    994  O   ILE    96      18.835 -18.697   6.410  1.00 54.28           O  
ATOM    996  N   LEU    97      19.439 -20.065   8.080  1.00 53.80           N  
ATOM    997  CA  LEU    97      19.954 -21.096   7.178  1.00 53.81           C  
ATOM    999  CB  LEU    97      20.608 -22.239   7.970  1.00 53.47           C  
ATOM   1002  CG  LEU    97      22.030 -21.993   8.478  1.00 53.53           C  
ATOM   1004  CD1 LEU    97      22.618 -23.291   9.051  1.00 50.87           C  
ATOM   1008  CD2 LEU    97      22.950 -21.383   7.384  1.00 52.01           C  
ATOM   1012  C   LEU    97      18.846 -21.661   6.282  1.00 53.72           C  
ATOM   1013  O   LEU    97      18.998 -21.767   5.074  1.00 52.86           O  
ATOM   1015  N   ALA    98      17.735 -22.033   6.895  1.00 54.33           N  
ATOM   1016  CA  ALA    98      16.612 -22.592   6.162  1.00 54.91           C  
ATOM   1018  CB  ALA    98      15.486 -22.960   7.115  1.00 54.56           C  
ATOM   1022  C   ALA    98      16.124 -21.610   5.095  1.00 55.41           C  
ATOM   1023  O   ALA    98      15.738 -22.031   4.010  1.00 55.09           O  
ATOM   1025  N   PHE    99      16.158 -20.309   5.393  1.00 56.09           N  
ATOM   1026  CA  PHE    99      15.703 -19.310   4.433  1.00 56.55           C  
ATOM   1028  CB  PHE    99      15.447 -17.953   5.095  1.00 56.76           C  
ATOM   1031  CG  PHE    99      14.132 -17.862   5.807  1.00 56.69           C  
ATOM   1032  CD1 PHE    99      14.076 -17.751   7.195  1.00 57.40           C  
ATOM   1034  CE1 PHE    99      12.826 -17.663   7.870  1.00 57.54           C  
ATOM   1036  CZ  PHE    99      11.642 -17.693   7.153  1.00 56.30           C  
ATOM   1038  CE2 PHE    99      11.690 -17.805   5.764  1.00 57.07           C  
ATOM   1040  CD2 PHE    99      12.939 -17.888   5.098  1.00 57.15           C  
ATOM   1042  C   PHE    99      16.715 -19.165   3.301  1.00 57.09           C  
ATOM   1043  O   PHE    99      16.318 -19.018   2.134  1.00 57.27           O  
ATOM   1045  N   PHE   100      18.007 -19.187   3.640  1.00 57.39           N  
ATOM   1046  CA  PHE   100      19.067 -19.296   2.621  1.00 57.91           C  
ATOM   1048  CB  PHE   100      20.453 -19.451   3.259  1.00 57.73           C  
ATOM   1051  CG  PHE   100      21.085 -18.159   3.716  1.00 57.64           C  
ATOM   1052  CD1 PHE   100      21.317 -17.124   2.819  1.00 57.66           C  
ATOM   1054  CE1 PHE   100      21.925 -15.954   3.233  1.00 57.51           C  
ATOM   1056  CZ  PHE   100      22.325 -15.807   4.563  1.00 58.25           C  
ATOM   1058  CE2 PHE   100      22.132 -16.839   5.467  1.00 57.49           C  
ATOM   1060  CD2 PHE   100      21.522 -18.011   5.039  1.00 57.82           C  
ATOM   1062  C   PHE   100      18.819 -20.495   1.670  1.00 58.31           C  
ATOM   1063  O   PHE   100      18.915 -20.366   0.460  1.00 58.08           O  
ATOM   1065  N   ALA   101      18.486 -21.648   2.234  1.00 59.12           N  
ATOM   1066  CA  ALA   101      18.215 -22.849   1.453  1.00 59.90           C  
ATOM   1068  CB  ALA   101      18.151 -24.079   2.366  1.00 59.32           C  
ATOM   1072  C   ALA   101      16.932 -22.725   0.626  1.00 60.56           C  
ATOM   1073  O   ALA   101      16.911 -23.111  -0.531  1.00 60.51           O  
ATOM   1075  N   ALA   102      15.866 -22.188   1.210  1.00 61.94           N  
ATOM   1076  CA  ALA   102      14.575 -22.074   0.503  1.00 62.92           C  
ATOM   1078  CB  ALA   102      13.516 -21.466   1.411  1.00 62.66           C  
ATOM   1082  C   ALA   102      14.683 -21.256  -0.791  1.00 63.98           C  
ATOM   1083  O   ALA   102      14.108 -21.626  -1.817  1.00 64.29           O  
ATOM   1085  N   SER   103      15.435 -20.159  -0.719  1.00 65.26           N  
ATOM   1086  CA  SER   103      15.599 -19.178  -1.807  1.00 65.83           C  
ATOM   1088  CB  SER   103      17.065 -18.733  -1.874  1.00 66.20           C  
ATOM   1091  OG  SER   103      17.203 -17.642  -2.768  1.00 67.74           O  
ATOM   1093  C   SER   103      15.104 -19.616  -3.206  1.00 66.89           C  
ATOM   1094  O   SER   103      15.824 -20.269  -3.982  1.00 67.97           O  
ATOM   1096  N   ASN   110      15.835 -18.295 -10.296  1.00 74.54           N  
ATOM   1097  CA  ASN   110      16.476 -18.701 -11.559  1.00 74.29           C  
ATOM   1099  CB  ASN   110      15.872 -20.043 -12.028  1.00 74.44           C  
ATOM   1102  CG  ASN   110      14.729 -19.875 -13.004  1.00 74.56           C  
ATOM   1103  OD1 ASN   110      14.758 -20.447 -14.100  1.00 75.51           O  
ATOM   1104  ND2 ASN   110      13.720 -19.090 -12.622  1.00 73.68           N  
ATOM   1107  C   ASN   110      16.451 -17.591 -12.667  1.00 74.13           C  
ATOM   1108  O   ASN   110      16.281 -17.856 -13.873  1.00 73.89           O  
ATOM   1110  N   LEU   111      16.661 -16.351 -12.229  1.00 73.63           N  
ATOM   1111  CA  LEU   111      16.665 -15.187 -13.111  1.00 73.11           C  
ATOM   1113  CB  LEU   111      16.553 -13.922 -12.262  1.00 73.19           C  
ATOM   1116  CG  LEU   111      16.211 -12.669 -13.059  1.00 73.79           C  
ATOM   1118  CD1 LEU   111      14.720 -12.700 -13.436  1.00 73.86           C  
ATOM   1122  CD2 LEU   111      16.591 -11.410 -12.282  1.00 73.41           C  
ATOM   1126  C   LEU   111      17.940 -15.095 -13.963  1.00 72.68           C  
ATOM   1127  O   LEU   111      17.948 -14.464 -15.017  1.00 72.62           O  
ATOM   1129  N   VAL   112      19.019 -15.712 -13.486  1.00 72.00           N  
ATOM   1130  CA  VAL   112      20.312 -15.678 -14.170  1.00 71.19           C  
ATOM   1132  CB  VAL   112      21.423 -16.318 -13.305  1.00 70.99           C  
ATOM   1134  CG1 VAL   112      22.782 -15.937 -13.841  1.00 70.72           C  
ATOM   1138  CG2 VAL   112      21.294 -15.886 -11.860  1.00 71.23           C  
ATOM   1142  C   VAL   112      20.281 -16.386 -15.532  1.00 70.57           C  
ATOM   1143  O   VAL   112      20.904 -15.911 -16.486  1.00 70.64           O  
ATOM   1145  N   GLU   113      19.578 -17.517 -15.626  1.00 69.75           N  
ATOM   1146  CA  GLU   113      19.453 -18.225 -16.907  1.00 69.45           C  
ATOM   1148  CB  GLU   113      18.687 -19.561 -16.766  1.00 69.91           C  
ATOM   1151  CG  GLU   113      19.461 -20.739 -16.081  1.00 71.26           C  
ATOM   1154  CD  GLU   113      19.251 -20.845 -14.543  1.00 73.00           C  
ATOM   1155  OE1 GLU   113      18.277 -20.247 -14.030  1.00 75.80           O  
ATOM   1156  OE2 GLU   113      20.042 -21.537 -13.847  1.00 70.77           O  
ATOM   1157  C   GLU   113      18.765 -17.325 -17.945  1.00 68.63           C  
ATOM   1158  O   GLU   113      19.072 -17.396 -19.133  1.00 68.27           O  
ATOM   1160  N   ARG   114      17.851 -16.472 -17.476  1.00 67.85           N  
ATOM   1161  CA  ARG   114      17.134 -15.524 -18.332  1.00 67.21           C  
ATOM   1163  CB  ARG   114      15.948 -14.910 -17.588  1.00 67.44           C  
ATOM   1166  CG  ARG   114      15.261 -13.778 -18.344  1.00 67.79           C  
ATOM   1169  CD  ARG   114      13.972 -13.365 -17.669  1.00 67.97           C  
ATOM   1172  NE  ARG   114      13.368 -12.206 -18.323  1.00 68.60           N  
ATOM   1174  CZ  ARG   114      12.217 -11.642 -17.959  1.00 69.09           C  
ATOM   1175  NH1 ARG   114      11.516 -12.128 -16.931  1.00 69.34           N  
ATOM   1178  NH2 ARG   114      11.764 -10.585 -18.629  1.00 68.82           N  
ATOM   1181  C   ARG   114      18.022 -14.409 -18.862  1.00 66.28           C  
ATOM   1182  O   ARG   114      17.919 -14.042 -20.023  1.00 66.25           O  
ATOM   1184  N   PHE   115      18.874 -13.854 -18.013  1.00 65.39           N  
ATOM   1185  CA  PHE   115      19.833 -12.842 -18.461  1.00 64.67           C  
ATOM   1187  CB  PHE   115      20.539 -12.206 -17.274  1.00 64.64           C  
ATOM   1190  CG  PHE   115      19.828 -11.016 -16.743  1.00 64.49           C  
ATOM   1191  CD1 PHE   115      18.763 -11.166 -15.872  1.00 64.92           C  
ATOM   1193  CE1 PHE   115      18.096 -10.060 -15.381  1.00 65.41           C  
ATOM   1195  CZ  PHE   115      18.496  -8.780 -15.781  1.00 65.36           C  
ATOM   1197  CE2 PHE   115      19.558  -8.629 -16.658  1.00 64.60           C  
ATOM   1199  CD2 PHE   115      20.206  -9.741 -17.139  1.00 64.43           C  
ATOM   1201  C   PHE   115      20.866 -13.390 -19.428  1.00 63.90           C  
ATOM   1202  O   PHE   115      21.199 -12.743 -20.412  1.00 63.70           O  
ATOM   1204  N   SER   116      21.372 -14.583 -19.141  1.00 63.20           N  
ATOM   1205  CA  SER   116      22.376 -15.208 -19.986  1.00 62.66           C  
ATOM   1207  CB  SER   116      22.828 -16.539 -19.372  1.00 62.52           C  
ATOM   1210  OG  SER   116      23.767 -17.192 -20.217  1.00 62.21           O  
ATOM   1212  C   SER   116      21.872 -15.420 -21.418  1.00 62.08           C  
ATOM   1213  O   SER   116      22.660 -15.398 -22.361  1.00 61.92           O  
ATOM   1215  N   GLN   117      20.570 -15.651 -21.568  1.00 61.44           N  
ATOM   1216  CA  GLN   117      19.955 -15.797 -22.886  1.00 61.29           C  
ATOM   1218  CB  GLN   117      18.566 -16.412 -22.767  1.00 61.37           C  
ATOM   1221  CG  GLN   117      18.521 -17.896 -22.472  1.00 62.17           C  
ATOM   1224  CD  GLN   117      17.077 -18.408 -22.403  1.00 62.79           C  
ATOM   1225  OE1 GLN   117      16.661 -18.982 -21.387  1.00 64.78           O  
ATOM   1226  NE2 GLN   117      16.299 -18.182 -23.481  1.00 62.67           N  
ATOM   1229  C   GLN   117      19.793 -14.445 -23.551  1.00 60.44           C  
ATOM   1230  O   GLN   117      20.063 -14.275 -24.732  1.00 60.33           O  
ATOM   1232  N   GLU   118      19.332 -13.490 -22.762  1.00 59.88           N  
ATOM   1233  CA  GLU   118      18.972 -12.169 -23.244  1.00 59.53           C  
ATOM   1235  CB  GLU   118      18.201 -11.432 -22.145  1.00 59.57           C  
ATOM   1238  CG  GLU   118      17.116 -10.521 -22.660  1.00 60.34           C  
ATOM   1241  CD  GLU   118      16.075 -10.186 -21.602  1.00 60.59           C  
ATOM   1242  OE1 GLU   118      15.843 -10.992 -20.669  1.00 61.19           O  
ATOM   1243  OE2 GLU   118      15.475  -9.103 -21.727  1.00 62.74           O  
ATOM   1244  C   GLU   118      20.195 -11.352 -23.653  1.00 58.75           C  
ATOM   1245  O   GLU   118      20.223 -10.773 -24.749  1.00 58.71           O  
ATOM   1247  N   VAL   119      21.191 -11.295 -22.770  1.00 57.82           N  
ATOM   1248  CA  VAL   119      22.415 -10.573 -23.066  1.00 57.48           C  
ATOM   1250  CB  VAL   119      23.289 -10.319 -21.815  1.00 57.14           C  
ATOM   1252  CG1 VAL   119      24.516  -9.528 -22.193  1.00 56.57           C  
ATOM   1256  CG2 VAL   119      22.519  -9.558 -20.752  1.00 56.45           C  
ATOM   1260  C   VAL   119      23.195 -11.340 -24.142  1.00 57.31           C  
ATOM   1261  O   VAL   119      23.317 -12.570 -24.083  1.00 56.88           O  
ATOM   1263  N   GLN   120      23.703 -10.595 -25.128  1.00 57.08           N  
ATOM   1264  CA  GLN   120      24.345 -11.170 -26.315  1.00 56.85           C  
ATOM   1266  CB  GLN   120      23.769 -10.510 -27.555  1.00 56.64           C  
ATOM   1269  CG  GLN   120      22.270 -10.614 -27.624  1.00 56.47           C  
ATOM   1272  CD  GLN   120      21.803 -12.020 -27.923  1.00 55.50           C  
ATOM   1273  OE1 GLN   120      22.016 -12.528 -29.025  1.00 55.90           O  
ATOM   1274  NE2 GLN   120      21.145 -12.652 -26.955  1.00 54.08           N  
ATOM   1277  C   GLN   120      25.867 -11.037 -26.346  1.00 56.70           C  
ATOM   1278  O   GLN   120      26.513 -11.639 -27.198  1.00 56.52           O  
ATOM   1280  N   VAL   121      26.428 -10.238 -25.438  1.00 56.67           N  
ATOM   1281  CA  VAL   121      27.882 -10.086 -25.316  1.00 56.53           C  
ATOM   1283  CB  VAL   121      28.240  -8.845 -24.468  1.00 56.56           C  
ATOM   1285  CG1 VAL   121      29.732  -8.835 -24.099  1.00 55.71           C  
ATOM   1289  CG2 VAL   121      27.837  -7.572 -25.217  1.00 56.17           C  
ATOM   1293  C   VAL   121      28.521 -11.345 -24.692  1.00 56.64           C  
ATOM   1294  O   VAL   121      28.146 -11.757 -23.576  1.00 56.74           O  
ATOM   1296  N   PRO   122      29.483 -11.965 -25.411  1.00 56.28           N  
ATOM   1297  CA  PRO   122      30.140 -13.162 -24.892  1.00 56.16           C  
ATOM   1299  CB  PRO   122      31.228 -13.430 -25.934  1.00 56.17           C  
ATOM   1302  CG  PRO   122      30.740 -12.802 -27.167  1.00 55.88           C  
ATOM   1305  CD  PRO   122      30.006 -11.593 -26.738  1.00 55.95           C  
ATOM   1308  C   PRO   122      30.767 -12.968 -23.505  1.00 56.03           C  
ATOM   1309  O   PRO   122      30.727 -13.880 -22.680  1.00 55.42           O  
ATOM   1310  N   GLU   123      31.337 -11.789 -23.263  1.00 56.12           N  
ATOM   1311  CA  GLU   123      32.044 -11.522 -22.012  1.00 56.32           C  
ATOM   1313  CB  GLU   123      32.686 -10.134 -22.027  1.00 56.36           C  
ATOM   1316  CG  GLU   123      33.923  -9.977 -22.968  1.00 56.89           C  
ATOM   1319  CD  GLU   123      33.583  -9.642 -24.426  1.00 56.38           C  
ATOM   1320  OE1 GLU   123      32.614 -10.230 -24.960  1.00 56.93           O  
ATOM   1321  OE2 GLU   123      34.300  -8.812 -25.039  1.00 54.05           O  
ATOM   1322  C   GLU   123      31.084 -11.658 -20.838  1.00 56.63           C  
ATOM   1323  O   GLU   123      31.404 -12.303 -19.834  1.00 57.02           O  
ATOM   1325  N   ALA   124      29.892 -11.084 -20.992  1.00 56.76           N  
ATOM   1326  CA  ALA   124      28.830 -11.167 -19.983  1.00 56.54           C  
ATOM   1328  CB  ALA   124      27.670 -10.228 -20.362  1.00 56.57           C  
ATOM   1332  C   ALA   124      28.311 -12.587 -19.807  1.00 56.25           C  
ATOM   1333  O   ALA   124      28.099 -13.048 -18.690  1.00 55.44           O  
ATOM   1335  N   ARG   125      28.095 -13.275 -20.919  1.00 56.59           N  
ATOM   1336  CA  ARG   125      27.603 -14.647 -20.865  1.00 57.02           C  
ATOM   1338  CB  ARG   125      27.388 -15.212 -22.263  1.00 57.15           C  
ATOM   1341  CG  ARG   125      26.067 -14.849 -22.888  1.00 57.45           C  
ATOM   1344  CD  ARG   125      26.011 -15.338 -24.325  1.00 58.12           C  
ATOM   1347  NE  ARG   125      24.705 -15.066 -24.922  1.00 59.18           N  
ATOM   1349  CZ  ARG   125      23.745 -15.968 -25.116  1.00 60.48           C  
ATOM   1350  NH1 ARG   125      23.927 -17.243 -24.794  1.00 61.55           N  
ATOM   1353  NH2 ARG   125      22.588 -15.592 -25.659  1.00 60.53           N  
ATOM   1356  C   ARG   125      28.541 -15.559 -20.093  1.00 57.15           C  
ATOM   1357  O   ARG   125      28.080 -16.490 -19.436  1.00 57.57           O  
ATOM   1359  N   CYS   126      29.848 -15.309 -20.174  1.00 57.18           N  
ATOM   1360  CA  CYS   126      30.816 -16.093 -19.412  1.00 57.27           C  
ATOM   1362  CB  CYS   126      32.234 -15.740 -19.806  1.00 57.29           C  
ATOM   1365  SG  CYS   126      32.730 -16.538 -21.360  1.00 59.71           S  
ATOM   1367  C   CYS   126      30.633 -15.870 -17.928  1.00 57.42           C  
ATOM   1368  O   CYS   126      30.716 -16.811 -17.128  1.00 57.48           O  
ATOM   1370  N   PHE   127      30.367 -14.620 -17.563  1.00 57.30           N  
ATOM   1371  CA  PHE   127      30.181 -14.269 -16.172  1.00 57.18           C  
ATOM   1373  CB  PHE   127      30.172 -12.751 -15.991  1.00 56.99           C  
ATOM   1376  CG  PHE   127      30.068 -12.304 -14.561  1.00 56.89           C  
ATOM   1377  CD1 PHE   127      28.838 -12.299 -13.906  1.00 56.30           C  
ATOM   1379  CE1 PHE   127      28.737 -11.886 -12.587  1.00 56.59           C  
ATOM   1381  CZ  PHE   127      29.867 -11.454 -11.909  1.00 56.93           C  
ATOM   1383  CE2 PHE   127      31.095 -11.447 -12.557  1.00 57.01           C  
ATOM   1385  CD2 PHE   127      31.187 -11.866 -13.880  1.00 56.34           C  
ATOM   1387  C   PHE   127      28.909 -14.908 -15.632  1.00 57.19           C  
ATOM   1388  O   PHE   127      28.917 -15.414 -14.513  1.00 57.62           O  
ATOM   1390  N   TYR   128      27.834 -14.919 -16.415  1.00 57.38           N  
ATOM   1391  CA  TYR   128      26.576 -15.548 -15.957  1.00 57.62           C  
ATOM   1393  CB  TYR   128      25.376 -15.163 -16.843  1.00 57.92           C  
ATOM   1396  CG  TYR   128      24.984 -13.729 -16.645  1.00 58.30           C  
ATOM   1397  CD1 TYR   128      24.905 -13.188 -15.361  1.00 58.59           C  
ATOM   1399  CE1 TYR   128      24.572 -11.863 -15.161  1.00 58.85           C  
ATOM   1401  CZ  TYR   128      24.303 -11.049 -16.243  1.00 58.99           C  
ATOM   1402  OH  TYR   128      23.973  -9.729 -16.005  1.00 59.40           O  
ATOM   1404  CE2 TYR   128      24.377 -11.553 -17.540  1.00 59.01           C  
ATOM   1406  CD2 TYR   128      24.726 -12.894 -17.730  1.00 58.98           C  
ATOM   1408  C   TYR   128      26.675 -17.059 -15.838  1.00 57.56           C  
ATOM   1409  O   TYR   128      26.070 -17.637 -14.942  1.00 57.33           O  
ATOM   1411  N   GLY   129      27.442 -17.682 -16.733  1.00 57.43           N  
ATOM   1412  CA  GLY   129      27.706 -19.105 -16.661  1.00 57.49           C  
ATOM   1415  C   GLY   129      28.457 -19.455 -15.397  1.00 57.51           C  
ATOM   1416  O   GLY   129      28.220 -20.489 -14.788  1.00 57.68           O  
ATOM   1418  N   PHE   130      29.373 -18.595 -14.985  1.00 57.63           N  
ATOM   1419  CA  PHE   130      30.063 -18.839 -13.736  1.00 57.75           C  
ATOM   1421  CB  PHE   130      31.324 -17.980 -13.605  1.00 58.31           C  
ATOM   1424  CG  PHE   130      32.340 -18.597 -12.709  1.00 58.41           C  
ATOM   1425  CD1 PHE   130      33.279 -19.476 -13.218  1.00 59.65           C  
ATOM   1427  CE1 PHE   130      34.195 -20.092 -12.373  1.00 59.64           C  
ATOM   1429  CZ  PHE   130      34.158 -19.832 -11.018  1.00 58.89           C  
ATOM   1431  CE2 PHE   130      33.210 -18.970 -10.504  1.00 58.65           C  
ATOM   1433  CD2 PHE   130      32.304 -18.370 -11.346  1.00 58.79           C  
ATOM   1435  C   PHE   130      29.132 -18.615 -12.546  1.00 57.59           C  
ATOM   1436  O   PHE   130      29.222 -19.312 -11.540  1.00 57.39           O  
ATOM   1438  N   GLN   131      28.241 -17.639 -12.677  1.00 57.64           N  
ATOM   1439  CA  GLN   131      27.285 -17.327 -11.634  1.00 57.49           C  
ATOM   1441  CB  GLN   131      26.534 -16.028 -11.942  1.00 57.64           C  
ATOM   1444  CG  GLN   131      25.607 -15.550 -10.814  1.00 58.18           C  
ATOM   1447  CD  GLN   131      25.066 -14.120 -11.009  1.00 58.77           C  
ATOM   1448  OE1 GLN   131      25.465 -13.396 -11.928  1.00 60.30           O  
ATOM   1449  NE2 GLN   131      24.155 -13.713 -10.126  1.00 60.00           N  
ATOM   1452  C   GLN   131      26.337 -18.490 -11.439  1.00 56.94           C  
ATOM   1453  O   GLN   131      26.108 -18.883 -10.322  1.00 56.85           O  
ATOM   1455  N   ILE   132      25.820 -19.076 -12.512  1.00 56.80           N  
ATOM   1456  CA  ILE   132      24.958 -20.260 -12.376  1.00 56.84           C  
ATOM   1458  CB  ILE   132      24.643 -20.970 -13.727  1.00 56.59           C  
ATOM   1460  CG1 ILE   132      24.110 -20.021 -14.809  1.00 57.13           C  
ATOM   1463  CD1 ILE   132      23.022 -19.109 -14.372  1.00 57.36           C  
ATOM   1467  CG2 ILE   132      23.635 -22.052 -13.526  1.00 56.50           C  
ATOM   1471  C   ILE   132      25.658 -21.292 -11.470  1.00 56.89           C  
ATOM   1472  O   ILE   132      25.078 -21.787 -10.492  1.00 56.63           O  
ATOM   1474  N   LEU   133      26.912 -21.594 -11.805  1.00 56.76           N  
ATOM   1475  CA  LEU   133      27.662 -22.636 -11.121  1.00 56.73           C  
ATOM   1477  CB  LEU   133      29.025 -22.857 -11.783  1.00 56.86           C  
ATOM   1480  CG  LEU   133      30.010 -23.648 -10.911  1.00 57.28           C  
ATOM   1482  CD1 LEU   133      29.424 -25.023 -10.517  1.00 58.86           C  
ATOM   1486  CD2 LEU   133      31.326 -23.803 -11.626  1.00 57.42           C  
ATOM   1490  C   LEU   133      27.875 -22.334  -9.654  1.00 56.51           C  
ATOM   1491  O   LEU   133      27.607 -23.179  -8.797  1.00 56.49           O  
ATOM   1493  N   ILE   134      28.379 -21.135  -9.372  1.00 56.43           N  
ATOM   1494  CA  ILE   134      28.721 -20.761  -8.005  1.00 56.18           C  
ATOM   1496  CB  ILE   134      29.551 -19.434  -7.946  1.00 55.76           C  
ATOM   1498  CG1 ILE   134      30.561 -19.475  -6.805  1.00 55.77           C  
ATOM   1501  CD1 ILE   134      31.688 -20.484  -7.001  1.00 54.85           C  
ATOM   1505  CG2 ILE   134      28.683 -18.248  -7.745  1.00 55.82           C  
ATOM   1509  C   ILE   134      27.464 -20.738  -7.120  1.00 56.08           C  
ATOM   1510  O   ILE   134      27.537 -21.090  -5.946  1.00 56.31           O  
ATOM   1512  N   GLU   135      26.311 -20.390  -7.694  1.00 56.08           N  
ATOM   1513  CA  GLU   135      25.034 -20.432  -6.953  1.00 56.10           C  
ATOM   1515  CB  GLU   135      23.840 -19.978  -7.791  1.00 56.99           C  
ATOM   1518  CG  GLU   135      23.979 -18.672  -8.538  1.00 60.16           C  
ATOM   1521  CD  GLU   135      23.641 -17.489  -7.714  1.00 64.32           C  
ATOM   1522  OE1 GLU   135      23.115 -16.496  -8.312  1.00 67.28           O  
ATOM   1523  OE2 GLU   135      23.915 -17.563  -6.484  1.00 66.52           O  
ATOM   1524  C   GLU   135      24.714 -21.845  -6.515  1.00 55.33           C  
ATOM   1525  O   GLU   135      24.143 -22.047  -5.450  1.00 55.14           O  
ATOM   1527  N   ASN   136      25.044 -22.815  -7.355  1.00 54.67           N  
ATOM   1528  CA  ASN   136      24.822 -24.198  -7.012  1.00 54.60           C  
ATOM   1530  CB  ASN   136      24.928 -25.097  -8.234  1.00 54.91           C  
ATOM   1533  CG  ASN   136      23.846 -24.821  -9.251  1.00 56.03           C  
ATOM   1534  OD1 ASN   136      22.877 -24.130  -8.955  1.00 59.35           O  
ATOM   1535  ND2 ASN   136      24.008 -25.347 -10.462  1.00 57.34           N  
ATOM   1538  C   ASN   136      25.792 -24.643  -5.939  1.00 54.36           C  
ATOM   1539  O   ASN   136      25.465 -25.525  -5.144  1.00 54.50           O  
ATOM   1541  N   VAL   137      26.974 -24.026  -5.886  1.00 53.94           N  
ATOM   1542  CA  VAL   137      27.888 -24.287  -4.776  1.00 53.33           C  
ATOM   1544  CB  VAL   137      29.325 -23.813  -5.076  1.00 52.75           C  
ATOM   1546  CG1 VAL   137      30.160 -23.797  -3.808  1.00 52.55           C  
ATOM   1550  CG2 VAL   137      29.959 -24.717  -6.091  1.00 50.92           C  
ATOM   1554  C   VAL   137      27.314 -23.692  -3.476  1.00 53.20           C  
ATOM   1555  O   VAL   137      27.426 -24.295  -2.410  1.00 53.38           O  
ATOM   1557  N   HIS   138      26.665 -22.538  -3.561  1.00 53.21           N  
ATOM   1558  CA  HIS   138      26.008 -21.962  -2.380  1.00 53.48           C  
ATOM   1560  CB  HIS   138      25.298 -20.669  -2.746  1.00 53.55           C  
ATOM   1563  CG  HIS   138      26.210 -19.564  -3.170  1.00 54.02           C  
ATOM   1564  ND1 HIS   138      27.580 -19.658  -3.101  1.00 55.38           N  
ATOM   1566  CE1 HIS   138      28.118 -18.523  -3.508  1.00 55.64           C  
ATOM   1568  NE2 HIS   138      27.146 -17.688  -3.827  1.00 54.90           N  
ATOM   1570  CD2 HIS   138      25.941 -18.312  -3.614  1.00 55.26           C  
ATOM   1572  C   HIS   138      24.980 -22.919  -1.736  1.00 53.66           C  
ATOM   1573  O   HIS   138      24.947 -23.098  -0.511  1.00 53.41           O  
ATOM   1575  N   SER   139      24.136 -23.522  -2.576  1.00 53.56           N  
ATOM   1576  CA  SER   139      23.087 -24.425  -2.110  1.00 53.33           C  
ATOM   1578  CB  SER   139      22.245 -24.891  -3.279  1.00 53.23           C  
ATOM   1581  OG  SER   139      21.517 -23.806  -3.784  1.00 53.72           O  
ATOM   1583  C   SER   139      23.643 -25.647  -1.433  1.00 53.36           C  
ATOM   1584  O   SER   139      23.081 -26.144  -0.456  1.00 53.46           O  
ATOM   1586  N   GLU   140      24.733 -26.163  -1.982  1.00 53.33           N  
ATOM   1587  CA  GLU   140      25.345 -27.344  -1.421  1.00 53.24           C  
ATOM   1589  CB  GLU   140      26.506 -27.779  -2.303  1.00 53.42           C  
ATOM   1592  CG  GLU   140      26.968 -29.211  -2.104  1.00 53.79           C  
ATOM   1595  CD  GLU   140      28.159 -29.527  -2.983  1.00 54.87           C  
ATOM   1596  OE1 GLU   140      28.235 -28.913  -4.093  1.00 57.79           O  
ATOM   1597  OE2 GLU   140      29.013 -30.366  -2.567  1.00 56.61           O  
ATOM   1598  C   GLU   140      25.791 -27.022   0.001  1.00 52.76           C  
ATOM   1599  O   GLU   140      25.518 -27.774   0.924  1.00 52.76           O  
ATOM   1601  N   MET   141      26.425 -25.860   0.157  1.00 52.55           N  
ATOM   1602  CA  MET   141      27.004 -25.410   1.416  1.00 52.26           C  
ATOM   1604  CB  MET   141      27.731 -24.084   1.188  1.00 52.20           C  
ATOM   1607  CG  MET   141      28.687 -23.654   2.284  1.00 52.06           C  
ATOM   1610  SD  MET   141      30.063 -24.793   2.471  1.00 51.96           S  
ATOM   1611  CE  MET   141      29.628 -25.616   4.000  1.00 49.62           C  
ATOM   1615  C   MET   141      25.936 -25.244   2.483  1.00 52.26           C  
ATOM   1616  O   MET   141      26.113 -25.687   3.618  1.00 52.73           O  
ATOM   1618  N   TYR   142      24.823 -24.613   2.125  1.00 52.14           N  
ATOM   1619  CA  TYR   142      23.715 -24.459   3.057  1.00 51.75           C  
ATOM   1621  CB  TYR   142      22.632 -23.533   2.481  1.00 52.15           C  
ATOM   1624  CG  TYR   142      23.092 -22.090   2.423  1.00 52.90           C  
ATOM   1625  CD1 TYR   142      23.557 -21.448   3.563  1.00 53.48           C  
ATOM   1627  CE1 TYR   142      24.006 -20.151   3.516  1.00 52.66           C  
ATOM   1629  CZ  TYR   142      23.990 -19.470   2.329  1.00 52.16           C  
ATOM   1630  OH  TYR   142      24.446 -18.176   2.309  1.00 53.74           O  
ATOM   1632  CE2 TYR   142      23.537 -20.068   1.183  1.00 52.47           C  
ATOM   1634  CD2 TYR   142      23.093 -21.375   1.229  1.00 53.79           C  
ATOM   1636  C   TYR   142      23.148 -25.800   3.453  1.00 51.10           C  
ATOM   1637  O   TYR   142      22.838 -26.012   4.611  1.00 50.35           O  
ATOM   1639  N   SER   143      23.054 -26.726   2.507  1.00 51.25           N  
ATOM   1640  CA  SER   143      22.594 -28.084   2.836  1.00 51.73           C  
ATOM   1642  CB  SER   143      22.411 -28.922   1.572  1.00 51.63           C  
ATOM   1645  OG  SER   143      21.540 -28.264   0.663  1.00 52.66           O  
ATOM   1647  C   SER   143      23.560 -28.776   3.808  1.00 51.64           C  
ATOM   1648  O   SER   143      23.130 -29.419   4.759  1.00 51.85           O  
ATOM   1650  N   LEU   144      24.855 -28.618   3.569  1.00 51.48           N  
ATOM   1651  CA  LEU   144      25.881 -29.160   4.445  1.00 51.85           C  
ATOM   1653  CB  LEU   144      27.283 -28.881   3.862  1.00 52.09           C  
ATOM   1656  CG  LEU   144      28.182 -30.027   3.361  1.00 51.28           C  
ATOM   1658  CD1 LEU   144      27.400 -31.215   2.921  1.00 50.22           C  
ATOM   1662  CD2 LEU   144      29.062 -29.526   2.225  1.00 51.10           C  
ATOM   1666  C   LEU   144      25.798 -28.606   5.863  1.00 52.24           C  
ATOM   1667  O   LEU   144      25.924 -29.349   6.847  1.00 51.93           O  
ATOM   1669  N   LEU   145      25.618 -27.294   5.966  1.00 52.86           N  
ATOM   1670  CA  LEU   145      25.553 -26.637   7.274  1.00 53.18           C  
ATOM   1672  CB  LEU   145      25.512 -25.112   7.121  1.00 52.85           C  
ATOM   1675  CG  LEU   145      26.784 -24.471   6.550  1.00 52.20           C  
ATOM   1677  CD1 LEU   145      26.495 -23.143   5.842  1.00 51.60           C  
ATOM   1681  CD2 LEU   145      27.823 -24.281   7.645  1.00 51.90           C  
ATOM   1685  C   LEU   145      24.340 -27.144   8.044  1.00 53.69           C  
ATOM   1686  O   LEU   145      24.450 -27.487   9.216  1.00 53.77           O  
ATOM   1688  N   ILE   146      23.190 -27.215   7.376  1.00 54.38           N  
ATOM   1689  CA  ILE   146      21.975 -27.685   8.028  1.00 54.90           C  
ATOM   1691  CB  ILE   146      20.738 -27.609   7.113  1.00 54.83           C  
ATOM   1693  CG1 ILE   146      20.383 -26.154   6.809  1.00 55.01           C  
ATOM   1696  CD1 ILE   146      19.340 -25.997   5.698  1.00 55.18           C  
ATOM   1700  CG2 ILE   146      19.540 -28.290   7.767  1.00 54.35           C  
ATOM   1704  C   ILE   146      22.189 -29.116   8.491  1.00 55.34           C  
ATOM   1705  O   ILE   146      21.939 -29.418   9.637  1.00 55.49           O  
ATOM   1707  N   ASP   147      22.690 -29.978   7.610  1.00 56.25           N  
ATOM   1708  CA  ASP   147      22.898 -31.397   7.931  1.00 57.06           C  
ATOM   1710  CB  ASP   147      23.375 -32.176   6.698  1.00 57.69           C  
ATOM   1713  CG  ASP   147      22.219 -32.747   5.880  1.00 60.01           C  
ATOM   1714  OD1 ASP   147      22.278 -33.953   5.540  1.00 63.17           O  
ATOM   1715  OD2 ASP   147      21.247 -32.005   5.585  1.00 62.22           O  
ATOM   1716  C   ASP   147      23.885 -31.620   9.065  1.00 57.39           C  
ATOM   1717  O   ASP   147      23.872 -32.659   9.699  1.00 57.45           O  
ATOM   1719  N   THR   148      24.742 -30.639   9.304  1.00 57.97           N  
ATOM   1720  CA  THR   148      25.769 -30.720  10.321  1.00 58.19           C  
ATOM   1722  CB  THR   148      26.994 -29.856   9.922  1.00 58.22           C  
ATOM   1724  OG1 THR   148      27.688 -30.502   8.841  1.00 57.46           O  
ATOM   1726  CG2 THR   148      27.947 -29.632  11.096  1.00 57.69           C  
ATOM   1730  C   THR   148      25.223 -30.284  11.656  1.00 58.72           C  
ATOM   1731  O   THR   148      25.571 -30.885  12.668  1.00 59.30           O  
ATOM   1733  N   TYR   149      24.371 -29.253  11.666  1.00 59.40           N  
ATOM   1734  CA  TYR   149      23.772 -28.738  12.920  1.00 59.85           C  
ATOM   1736  CB  TYR   149      23.655 -27.212  12.917  1.00 59.91           C  
ATOM   1739  CG  TYR   149      24.866 -26.451  12.438  1.00 59.26           C  
ATOM   1740  CD1 TYR   149      26.142 -26.806  12.832  1.00 59.74           C  
ATOM   1742  CE1 TYR   149      27.253 -26.100  12.390  1.00 60.15           C  
ATOM   1744  CZ  TYR   149      27.094 -25.016  11.562  1.00 59.77           C  
ATOM   1745  OH  TYR   149      28.185 -24.303  11.118  1.00 58.82           O  
ATOM   1747  CE2 TYR   149      25.828 -24.642  11.176  1.00 60.33           C  
ATOM   1749  CD2 TYR   149      24.724 -25.353  11.622  1.00 58.76           C  
ATOM   1751  C   TYR   149      22.382 -29.288  13.250  1.00 60.53           C  
ATOM   1752  O   TYR   149      21.981 -29.247  14.404  1.00 61.05           O  
ATOM   1754  N   ILE   150      21.627 -29.745  12.250  1.00 61.10           N  
ATOM   1755  CA  ILE   150      20.354 -30.430  12.498  1.00 61.45           C  
ATOM   1757  CB  ILE   150      19.165 -29.794  11.761  1.00 61.41           C  
ATOM   1759  CG1 ILE   150      19.278 -28.272  11.729  1.00 61.67           C  
ATOM   1762  CD1 ILE   150      19.479 -27.655  13.060  1.00 62.90           C  
ATOM   1766  CG2 ILE   150      17.877 -30.186  12.434  1.00 61.11           C  
ATOM   1770  C   ILE   150      20.509 -31.897  12.091  1.00 61.83           C  
ATOM   1771  O   ILE   150      20.287 -32.291  10.953  1.00 61.18           O  
ATOM   1773  N   ARG   151      20.863 -32.703  13.077  1.00 62.86           N  
ATOM   1774  CA  ARG   151      21.247 -34.091  12.871  1.00 63.59           C  
ATOM   1776  CB  ARG   151      22.068 -34.634  14.067  1.00 64.05           C  
ATOM   1779  CG  ARG   151      22.977 -33.609  14.849  1.00 66.19           C  
ATOM   1782  CD  ARG   151      22.209 -32.603  15.793  1.00 68.07           C  
ATOM   1785  NE  ARG   151      20.840 -33.042  16.154  1.00 69.41           N  
ATOM   1787  CZ  ARG   151      19.864 -32.250  16.621  1.00 69.09           C  
ATOM   1788  NH1 ARG   151      18.669 -32.768  16.887  1.00 68.37           N  
ATOM   1791  NH2 ARG   151      20.069 -30.949  16.833  1.00 70.81           N  
ATOM   1794  C   ARG   151      20.004 -34.958  12.617  1.00 63.81           C  
ATOM   1795  O   ARG   151      20.035 -35.834  11.761  1.00 64.17           O  
ATOM   1797  N   ASP   152      18.912 -34.698  13.332  1.00 64.14           N  
ATOM   1798  CA  ASP   152      17.690 -35.505  13.196  1.00 64.33           C  
ATOM   1800  CB  ASP   152      16.832 -35.395  14.460  1.00 64.50           C  
ATOM   1803  CG  ASP   152      15.476 -36.069  14.303  1.00 64.78           C  
ATOM   1804  OD1 ASP   152      15.391 -37.139  13.648  1.00 66.19           O  
ATOM   1805  OD2 ASP   152      14.489 -35.528  14.838  1.00 66.44           O  
ATOM   1806  C   ASP   152      16.833 -35.146  11.962  1.00 64.49           C  
ATOM   1807  O   ASP   152      16.347 -34.025  11.845  1.00 64.63           O  
ATOM   1809  N   PRO   153      16.616 -36.113  11.054  1.00 64.78           N  
ATOM   1810  CA  PRO   153      15.842 -35.893   9.824  1.00 64.86           C  
ATOM   1812  CB  PRO   153      15.804 -37.282   9.194  1.00 64.83           C  
ATOM   1815  CG  PRO   153      17.017 -37.938   9.695  1.00 64.85           C  
ATOM   1818  CD  PRO   153      17.137 -37.493  11.105  1.00 64.73           C  
ATOM   1821  C   PRO   153      14.416 -35.348   9.955  1.00 64.92           C  
ATOM   1822  O   PRO   153      13.966 -34.628   9.066  1.00 65.03           O  
ATOM   1823  N   LYS   154      13.702 -35.690  11.016  1.00 65.08           N  
ATOM   1824  CA  LYS   154      12.343 -35.167  11.186  1.00 65.49           C  
ATOM   1826  CB  LYS   154      11.499 -36.081  12.091  1.00 65.53           C  
ATOM   1829  CG  LYS   154      10.878 -37.254  11.320  1.00 65.72           C  
ATOM   1832  CD  LYS   154      10.381 -38.386  12.223  1.00 65.82           C  
ATOM   1835  CE  LYS   154       9.159 -39.103  11.619  1.00 66.35           C  
ATOM   1838  NZ  LYS   154       7.941 -38.207  11.495  1.00 66.23           N  
ATOM   1842  C   LYS   154      12.343 -33.705  11.669  1.00 65.63           C  
ATOM   1843  O   LYS   154      11.401 -32.966  11.390  1.00 65.44           O  
ATOM   1845  N   LYS   155      13.402 -33.286  12.361  1.00 65.81           N  
ATOM   1846  CA  LYS   155      13.555 -31.878  12.760  1.00 66.03           C  
ATOM   1848  CB  LYS   155      14.714 -31.700  13.741  1.00 65.92           C  
ATOM   1851  CG  LYS   155      14.316 -31.886  15.198  1.00 66.21           C  
ATOM   1854  CD  LYS   155      15.520 -31.745  16.119  1.00 66.49           C  
ATOM   1857  CE  LYS   155      15.217 -30.877  17.329  1.00 66.67           C  
ATOM   1860  NZ  LYS   155      16.426 -30.698  18.185  1.00 66.98           N  
ATOM   1864  C   LYS   155      13.761 -30.983  11.542  1.00 66.20           C  
ATOM   1865  O   LYS   155      13.154 -29.903  11.440  1.00 65.96           O  
ATOM   1867  N   ARG   156      14.625 -31.436  10.631  1.00 66.29           N  
ATOM   1868  CA  ARG   156      14.772 -30.803   9.328  1.00 66.50           C  
ATOM   1870  CB  ARG   156      15.735 -31.590   8.450  1.00 66.57           C  
ATOM   1873  CG  ARG   156      17.188 -31.547   8.862  1.00 67.08           C  
ATOM   1876  CD  ARG   156      18.083 -31.932   7.681  1.00 67.46           C  
ATOM   1879  NE  ARG   156      19.301 -32.593   8.140  1.00 68.86           N  
ATOM   1881  CZ  ARG   156      19.443 -33.905   8.337  1.00 68.87           C  
ATOM   1882  NH1 ARG   156      18.448 -34.748   8.098  1.00 69.11           N  
ATOM   1885  NH2 ARG   156      20.603 -34.380   8.774  1.00 68.89           N  
ATOM   1888  C   ARG   156      13.426 -30.741   8.619  1.00 66.45           C  
ATOM   1889  O   ARG   156      13.074 -29.734   8.025  1.00 66.41           O  
ATOM   1891  N   GLU   157      12.674 -31.829   8.681  1.00 66.62           N  
ATOM   1892  CA  GLU   157      11.387 -31.881   8.016  1.00 66.88           C  
ATOM   1894  CB  GLU   157      10.783 -33.283   8.119  1.00 66.87           C  
ATOM   1897  CG  GLU   157       9.798 -33.630   7.023  1.00 66.64           C  
ATOM   1900  CD  GLU   157       9.030 -34.923   7.320  1.00 67.24           C  
ATOM   1901  OE1 GLU   157       9.539 -35.784   8.081  1.00 66.91           O  
ATOM   1902  OE2 GLU   157       7.905 -35.077   6.788  1.00 68.14           O  
ATOM   1903  C   GLU   157      10.446 -30.808   8.582  1.00 66.97           C  
ATOM   1904  O   GLU   157       9.898 -30.033   7.812  1.00 67.13           O  
ATOM   1906  N   PHE   158      10.277 -30.741   9.910  1.00 67.29           N  
ATOM   1907  CA  PHE   158       9.439 -29.684  10.541  1.00 67.42           C  
ATOM   1909  CB  PHE   158       9.462 -29.722  12.091  1.00 67.50           C  
ATOM   1912  CG  PHE   158       8.848 -30.967  12.721  1.00 67.74           C  
ATOM   1913  CD1 PHE   158       9.615 -31.801  13.538  1.00 68.28           C  
ATOM   1915  CE1 PHE   158       9.056 -32.948  14.140  1.00 67.97           C  
ATOM   1917  CZ  PHE   158       7.717 -33.256  13.941  1.00 67.59           C  
ATOM   1919  CE2 PHE   158       6.941 -32.431  13.148  1.00 67.77           C  
ATOM   1921  CD2 PHE   158       7.505 -31.284  12.544  1.00 68.36           C  
ATOM   1923  C   PHE   158       9.937 -28.301  10.092  1.00 67.57           C  
ATOM   1924  O   PHE   158       9.155 -27.458   9.651  1.00 67.63           O  
ATOM   1926  N   LEU   159      11.248 -28.084  10.191  1.00 67.59           N  
ATOM   1927  CA  LEU   159      11.834 -26.774   9.903  1.00 67.77           C  
ATOM   1929  CB  LEU   159      13.356 -26.812  10.075  1.00 67.42           C  
ATOM   1932  CG  LEU   159      14.093 -25.477  10.051  1.00 66.81           C  
ATOM   1934  CD1 LEU   159      13.521 -24.544  11.084  1.00 65.22           C  
ATOM   1938  CD2 LEU   159      15.575 -25.683  10.275  1.00 66.36           C  
ATOM   1942  C   LEU   159      11.472 -26.262   8.506  1.00 68.34           C  
ATOM   1943  O   LEU   159      10.990 -25.141   8.364  1.00 68.70           O  
ATOM   1945  N   PHE   160      11.680 -27.088   7.485  1.00 68.89           N  
ATOM   1946  CA  PHE   160      11.511 -26.644   6.099  1.00 69.16           C  
ATOM   1948  CB  PHE   160      12.095 -27.668   5.125  1.00 69.47           C  
ATOM   1951  CG  PHE   160      13.590 -27.838   5.239  1.00 69.66           C  
ATOM   1952  CD1 PHE   160      14.154 -29.108   5.309  1.00 70.47           C  
ATOM   1954  CE1 PHE   160      15.527 -29.272   5.410  1.00 70.31           C  
ATOM   1956  CZ  PHE   160      16.351 -28.154   5.439  1.00 70.44           C  
ATOM   1958  CE2 PHE   160      15.799 -26.885   5.364  1.00 69.85           C  
ATOM   1960  CD2 PHE   160      14.433 -26.732   5.266  1.00 69.63           C  
ATOM   1962  C   PHE   160      10.059 -26.360   5.739  1.00 69.58           C  
ATOM   1963  O   PHE   160       9.767 -25.365   5.079  1.00 69.90           O  
ATOM   1965  N   ASN   161       9.156 -27.239   6.166  1.00 69.80           N  
ATOM   1966  CA  ASN   161       7.726 -27.042   5.941  1.00 69.76           C  
ATOM   1968  CB  ASN   161       6.916 -28.280   6.391  1.00 69.87           C  
ATOM   1971  CG  ASN   161       7.018 -29.439   5.395  1.00 69.67           C  
ATOM   1972  OD1 ASN   161       7.995 -29.537   4.643  1.00 69.20           O  
ATOM   1973  ND2 ASN   161       6.006 -30.310   5.377  1.00 67.60           N  
ATOM   1976  C   ASN   161       7.208 -25.763   6.615  1.00 69.98           C  
ATOM   1977  O   ASN   161       6.293 -25.119   6.088  1.00 70.48           O  
ATOM   1979  N   ALA   162       7.781 -25.391   7.761  1.00 69.58           N  
ATOM   1980  CA  ALA   162       7.485 -24.087   8.348  1.00 69.52           C  
ATOM   1982  CB  ALA   162       8.252 -23.879   9.664  1.00 69.53           C  
ATOM   1986  C   ALA   162       7.854 -22.993   7.340  1.00 69.47           C  
ATOM   1987  O   ALA   162       6.977 -22.276   6.848  1.00 69.54           O  
ATOM   1989  N   ILE   163       9.142 -22.924   7.004  1.00 68.93           N  
ATOM   1990  CA  ILE   163       9.707 -21.882   6.133  1.00 68.97           C  
ATOM   1992  CB  ILE   163      11.226 -22.135   5.873  1.00 68.75           C  
ATOM   1994  CG1 ILE   163      12.062 -21.528   7.000  1.00 68.83           C  
ATOM   1997  CD1 ILE   163      11.732 -22.050   8.374  1.00 68.29           C  
ATOM   2001  CG2 ILE   163      11.681 -21.538   4.558  1.00 68.37           C  
ATOM   2005  C   ILE   163       8.973 -21.655   4.794  1.00 68.89           C  
ATOM   2006  O   ILE   163       8.895 -20.526   4.323  1.00 68.79           O  
ATOM   2008  N   GLU   164       8.437 -22.703   4.183  1.00 68.94           N  
ATOM   2009  CA  GLU   164       7.650 -22.527   2.959  1.00 69.36           C  
ATOM   2011  CB  GLU   164       7.172 -23.874   2.408  1.00 69.58           C  
ATOM   2014  CG  GLU   164       8.278 -24.743   1.846  1.00 70.87           C  
ATOM   2017  CD  GLU   164       7.849 -26.200   1.675  1.00 71.63           C  
ATOM   2018  OE1 GLU   164       6.662 -26.444   1.314  1.00 73.73           O  
ATOM   2019  OE2 GLU   164       8.707 -27.097   1.905  1.00 74.77           O  
ATOM   2020  C   GLU   164       6.430 -21.627   3.193  1.00 68.95           C  
ATOM   2021  O   GLU   164       6.047 -20.851   2.310  1.00 68.86           O  
ATOM   2023  N   THR   165       5.817 -21.758   4.371  1.00 68.30           N  
ATOM   2024  CA  THR   165       4.683 -20.927   4.756  1.00 68.14           C  
ATOM   2026  CB  THR   165       4.256 -21.215   6.218  1.00 68.25           C  
ATOM   2028  OG1 THR   165       3.769 -22.558   6.314  1.00 68.79           O  
ATOM   2030  CG2 THR   165       3.183 -20.207   6.720  1.00 68.08           C  
ATOM   2034  C   THR   165       5.014 -19.446   4.675  1.00 67.23           C  
ATOM   2035  O   THR   165       4.301 -18.674   4.039  1.00 67.65           O  
ATOM   2037  N   MET   166       6.139 -19.085   5.280  1.00 66.07           N  
ATOM   2038  CA  MET   166       6.361 -17.744   5.823  1.00 64.96           C  
ATOM   2040  CB  MET   166       7.703 -17.707   6.574  1.00 65.15           C  
ATOM   2043  CG  MET   166       7.849 -18.765   7.668  1.00 65.03           C  
ATOM   2046  SD  MET   166       6.512 -18.657   8.871  1.00 66.95           S  
ATOM   2047  CE  MET   166       6.206 -20.377   9.313  1.00 65.91           C  
ATOM   2051  C   MET   166       6.328 -16.608   4.794  1.00 64.48           C  
ATOM   2052  O   MET   166       6.694 -16.821   3.629  1.00 64.32           O  
ATOM   2054  N   PRO   167       5.897 -15.402   5.235  1.00 63.53           N  
ATOM   2055  CA  PRO   167       5.875 -14.120   4.521  1.00 63.18           C  
ATOM   2057  CB  PRO   167       5.736 -13.111   5.655  1.00 63.06           C  
ATOM   2060  CG  PRO   167       4.912 -13.805   6.647  1.00 63.27           C  
ATOM   2063  CD  PRO   167       5.321 -15.250   6.586  1.00 63.64           C  
ATOM   2066  C   PRO   167       7.100 -13.759   3.674  1.00 62.81           C  
ATOM   2067  O   PRO   167       6.951 -13.396   2.514  1.00 63.19           O  
ATOM   2068  N   TYR   168       8.292 -13.843   4.249  1.00 62.39           N  
ATOM   2069  CA  TYR   168       9.524 -13.462   3.562  1.00 62.11           C  
ATOM   2071  CB  TYR   168      10.731 -13.860   4.414  1.00 62.00           C  
ATOM   2074  CG  TYR   168      12.086 -13.288   4.012  1.00 61.86           C  
ATOM   2075  CD1 TYR   168      12.248 -11.943   3.690  1.00 60.79           C  
ATOM   2077  CE1 TYR   168      13.503 -11.432   3.354  1.00 61.64           C  
ATOM   2079  CZ  TYR   168      14.618 -12.271   3.362  1.00 61.92           C  
ATOM   2080  OH  TYR   168      15.875 -11.805   3.042  1.00 61.35           O  
ATOM   2082  CE2 TYR   168      14.476 -13.601   3.698  1.00 61.83           C  
ATOM   2084  CD2 TYR   168      13.221 -14.101   4.019  1.00 61.85           C  
ATOM   2086  C   TYR   168       9.630 -14.127   2.201  1.00 62.04           C  
ATOM   2087  O   TYR   168      10.062 -13.501   1.241  1.00 62.24           O  
ATOM   2089  N   VAL   169       9.247 -15.396   2.109  1.00 61.85           N  
ATOM   2090  CA  VAL   169       9.292 -16.086   0.816  1.00 61.53           C  
ATOM   2092  CB  VAL   169       9.207 -17.622   0.980  1.00 61.53           C  
ATOM   2094  CG1 VAL   169       9.474 -18.304  -0.345  1.00 61.26           C  
ATOM   2098  CG2 VAL   169      10.224 -18.090   2.005  1.00 60.94           C  
ATOM   2102  C   VAL   169       8.197 -15.545  -0.133  1.00 61.26           C  
ATOM   2103  O   VAL   169       8.489 -15.182  -1.266  1.00 61.34           O  
ATOM   2105  N   LYS   170       6.958 -15.460   0.347  1.00 61.04           N  
ATOM   2106  CA  LYS   170       5.835 -14.936  -0.447  1.00 60.81           C  
ATOM   2108  CB  LYS   170       4.532 -15.003   0.357  1.00 60.69           C  
ATOM   2111  CG  LYS   170       3.327 -14.409  -0.363  1.00 61.38           C  
ATOM   2114  CD  LYS   170       2.006 -14.780   0.322  1.00 61.65           C  
ATOM   2117  CE  LYS   170       0.791 -14.118  -0.358  1.00 61.90           C  
ATOM   2120  NZ  LYS   170      -0.548 -14.633   0.165  1.00 62.18           N  
ATOM   2124  C   LYS   170       6.083 -13.498  -0.911  1.00 60.42           C  
ATOM   2125  O   LYS   170       5.858 -13.174  -2.076  1.00 60.06           O  
ATOM   2127  N   LYS   171       6.557 -12.654   0.006  1.00 60.06           N  
ATOM   2128  CA  LYS   171       6.848 -11.245  -0.290  1.00 59.90           C  
ATOM   2130  CB  LYS   171       7.252 -10.498   0.978  1.00 59.98           C  
ATOM   2133  CG  LYS   171       6.124 -10.351   1.969  1.00 60.40           C  
ATOM   2136  CD  LYS   171       6.028  -8.938   2.516  1.00 61.41           C  
ATOM   2139  CE  LYS   171       5.068  -8.883   3.703  1.00 61.77           C  
ATOM   2142  NZ  LYS   171       5.635  -9.634   4.878  1.00 62.75           N  
ATOM   2146  C   LYS   171       7.930 -11.039  -1.348  1.00 59.51           C  
ATOM   2147  O   LYS   171       7.788 -10.189  -2.233  1.00 59.17           O  
ATOM   2149  N   LYS   172       9.014 -11.798  -1.228  1.00 59.17           N  
ATOM   2150  CA  LYS   172      10.079 -11.782  -2.216  1.00 59.12           C  
ATOM   2152  CB  LYS   172      11.280 -12.587  -1.735  1.00 59.00           C  
ATOM   2155  CG  LYS   172      12.117 -11.864  -0.700  1.00 59.77           C  
ATOM   2158  CD  LYS   172      13.490 -12.512  -0.503  1.00 59.78           C  
ATOM   2161  CE  LYS   172      13.412 -13.742   0.377  1.00 60.38           C  
ATOM   2164  NZ  LYS   172      14.752 -14.362   0.551  1.00 60.65           N  
ATOM   2168  C   LYS   172       9.574 -12.343  -3.536  1.00 58.99           C  
ATOM   2169  O   LYS   172       9.927 -11.846  -4.601  1.00 58.98           O  
ATOM   2171  N   ALA   173       8.744 -13.379  -3.466  1.00 58.77           N  
ATOM   2172  CA  ALA   173       8.106 -13.906  -4.659  1.00 58.57           C  
ATOM   2174  CB  ALA   173       7.241 -15.104  -4.312  1.00 58.24           C  
ATOM   2178  C   ALA   173       7.282 -12.803  -5.345  1.00 58.50           C  
ATOM   2179  O   ALA   173       7.524 -12.482  -6.509  1.00 58.37           O  
ATOM   2181  N   ASP   174       6.340 -12.207  -4.611  1.00 58.48           N  
ATOM   2182  CA  ASP   174       5.464 -11.150  -5.157  1.00 58.49           C  
ATOM   2184  CB  ASP   174       4.534 -10.587  -4.074  1.00 58.62           C  
ATOM   2187  CG  ASP   174       3.522 -11.603  -3.568  1.00 59.18           C  
ATOM   2188  OD1 ASP   174       3.220 -12.589  -4.288  1.00 59.27           O  
ATOM   2189  OD2 ASP   174       3.023 -11.396  -2.438  1.00 59.79           O  
ATOM   2190  C   ASP   174       6.238  -9.985  -5.767  1.00 58.32           C  
ATOM   2191  O   ASP   174       5.820  -9.422  -6.764  1.00 58.47           O  
ATOM   2193  N   TRP   175       7.354  -9.623  -5.147  1.00 58.10           N  
ATOM   2194  CA  TRP   175       8.213  -8.531  -5.612  1.00 58.35           C  
ATOM   2196  CB  TRP   175       9.305  -8.320  -4.579  1.00 57.51           C  
ATOM   2199  CG  TRP   175      10.267  -7.235  -4.827  1.00 57.20           C  
ATOM   2200  CD1 TRP   175      10.164  -5.950  -4.418  1.00 56.56           C  
ATOM   2202  NE1 TRP   175      11.282  -5.242  -4.781  1.00 56.26           N  
ATOM   2204  CE2 TRP   175      12.146  -6.080  -5.424  1.00 56.02           C  
ATOM   2205  CD2 TRP   175      11.541  -7.353  -5.464  1.00 57.09           C  
ATOM   2206  CE3 TRP   175      12.230  -8.412  -6.070  1.00 56.62           C  
ATOM   2208  CZ3 TRP   175      13.485  -8.165  -6.602  1.00 56.78           C  
ATOM   2210  CH2 TRP   175      14.057  -6.881  -6.546  1.00 56.76           C  
ATOM   2212  CZ2 TRP   175      13.401  -5.830  -5.964  1.00 56.44           C  
ATOM   2214  C   TRP   175       8.830  -8.839  -6.977  1.00 58.63           C  
ATOM   2215  O   TRP   175       8.731  -8.036  -7.902  1.00 58.38           O  
ATOM   2217  N   ALA   176       9.460 -10.007  -7.090  1.00 59.39           N  
ATOM   2218  CA  ALA   176      10.054 -10.458  -8.354  1.00 59.91           C  
ATOM   2220  CB  ALA   176      10.784 -11.766  -8.170  1.00 59.47           C  
ATOM   2224  C   ALA   176       9.010 -10.591  -9.470  1.00 60.53           C  
ATOM   2225  O   ALA   176       9.282 -10.247 -10.622  1.00 60.76           O  
ATOM   2227  N   LEU   177       7.815 -11.072  -9.140  1.00 61.05           N  
ATOM   2228  CA  LEU   177       6.795 -11.266 -10.174  1.00 61.52           C  
ATOM   2230  CB  LEU   177       5.747 -12.321  -9.746  1.00 61.51           C  
ATOM   2233  CG  LEU   177       4.280 -12.056  -9.386  1.00 61.71           C  
ATOM   2235  CD1 LEU   177       3.804 -13.255  -8.565  1.00 61.58           C  
ATOM   2239  CD2 LEU   177       3.989 -10.755  -8.634  1.00 62.01           C  
ATOM   2243  C   LEU   177       6.197  -9.906 -10.562  1.00 61.92           C  
ATOM   2244  O   LEU   177       5.628  -9.748 -11.646  1.00 62.08           O  
ATOM   2246  N   ARG   178       6.381  -8.928  -9.677  1.00 62.32           N  
ATOM   2247  CA  ARG   178       5.939  -7.553  -9.892  1.00 62.49           C  
ATOM   2249  CB  ARG   178       5.690  -6.885  -8.528  1.00 62.57           C  
ATOM   2252  CG  ARG   178       5.988  -5.401  -8.407  1.00 62.83           C  
ATOM   2255  CD  ARG   178       4.938  -4.550  -9.060  1.00 64.41           C  
ATOM   2258  NE  ARG   178       4.564  -3.424  -8.208  1.00 65.33           N  
ATOM   2260  CZ  ARG   178       3.875  -2.354  -8.614  1.00 65.81           C  
ATOM   2261  NH1 ARG   178       3.470  -2.222  -9.879  1.00 65.25           N  
ATOM   2264  NH2 ARG   178       3.592  -1.399  -7.739  1.00 66.16           N  
ATOM   2267  C   ARG   178       6.936  -6.752 -10.731  1.00 62.76           C  
ATOM   2268  O   ARG   178       6.530  -5.991 -11.608  1.00 62.93           O  
ATOM   2270  N   TRP   179       8.231  -6.923 -10.464  1.00 62.99           N  
ATOM   2271  CA  TRP   179       9.269  -6.104 -11.097  1.00 63.14           C  
ATOM   2273  CB  TRP   179      10.221  -5.536 -10.038  1.00 63.26           C  
ATOM   2276  CG  TRP   179       9.592  -4.633  -9.000  1.00 63.20           C  
ATOM   2277  CD1 TRP   179       9.494  -4.874  -7.662  1.00 63.16           C  
ATOM   2279  NE1 TRP   179       8.888  -3.817  -7.026  1.00 62.96           N  
ATOM   2281  CE2 TRP   179       8.577  -2.865  -7.957  1.00 63.47           C  
ATOM   2282  CD2 TRP   179       9.012  -3.342  -9.213  1.00 63.38           C  
ATOM   2283  CE3 TRP   179       8.813  -2.543 -10.341  1.00 63.18           C  
ATOM   2285  CZ3 TRP   179       8.188  -1.310 -10.180  1.00 63.03           C  
ATOM   2287  CH2 TRP   179       7.767  -0.866  -8.920  1.00 62.83           C  
ATOM   2289  CZ2 TRP   179       7.947  -1.626  -7.801  1.00 63.34           C  
ATOM   2291  C   TRP   179      10.106  -6.829 -12.162  1.00 63.36           C  
ATOM   2292  O   TRP   179      10.817  -6.165 -12.921  1.00 63.63           O  
ATOM   2294  N   ILE   180      10.055  -8.165 -12.211  1.00 63.46           N  
ATOM   2295  CA  ILE   180      10.761  -8.938 -13.258  1.00 63.46           C  
ATOM   2297  CB  ILE   180      11.599 -10.106 -12.693  1.00 63.43           C  
ATOM   2299  CG1 ILE   180      12.360  -9.692 -11.436  1.00 64.12           C  
ATOM   2302  CD1 ILE   180      13.249  -8.530 -11.630  1.00 65.35           C  
ATOM   2306  CG2 ILE   180      12.554 -10.621 -13.749  1.00 63.18           C  
ATOM   2310  C   ILE   180       9.802  -9.554 -14.269  1.00 63.41           C  
ATOM   2311  O   ILE   180       9.875  -9.274 -15.464  1.00 63.23           O  
ATOM   2313  N   ALA   181       8.906 -10.400 -13.775  1.00 63.61           N  
ATOM   2314  CA  ALA   181       8.054 -11.205 -14.637  1.00 63.86           C  
ATOM   2316  CB  ALA   181       7.483 -12.378 -13.853  1.00 63.50           C  
ATOM   2320  C   ALA   181       6.925 -10.400 -15.288  1.00 64.00           C  
ATOM   2321  O   ALA   181       6.353 -10.845 -16.264  1.00 63.95           O  
ATOM   2323  N   ASP   182       6.615  -9.217 -14.763  1.00 64.40           N  
ATOM   2324  CA  ASP   182       5.429  -8.464 -15.188  1.00 64.62           C  
ATOM   2326  CB  ASP   182       5.421  -7.071 -14.539  1.00 64.61           C  
ATOM   2329  CG  ASP   182       4.188  -6.257 -14.915  1.00 64.84           C  
ATOM   2330  OD1 ASP   182       3.052  -6.771 -14.767  1.00 65.36           O  
ATOM   2331  OD2 ASP   182       4.358  -5.104 -15.366  1.00 65.32           O  
ATOM   2332  C   ASP   182       5.258  -8.342 -16.720  1.00 64.96           C  
ATOM   2333  O   ASP   182       4.123  -8.342 -17.236  1.00 64.95           O  
ATOM   2335  N   ARG   183       6.373  -8.221 -17.440  1.00 64.99           N  
ATOM   2336  CA  ARG   183       6.356  -8.084 -18.918  1.00 65.05           C  
ATOM   2338  CB  ARG   183       5.820  -9.358 -19.619  1.00 65.64           C  
ATOM   2341  CG  ARG   183       6.942 -10.397 -19.976  1.00 66.78           C  
ATOM   2344  CD  ARG   183       8.123 -10.351 -18.981  1.00 69.04           C  
ATOM   2347  NE  ARG   183       8.907 -11.582 -18.896  1.00 69.95           N  
ATOM   2349  CZ  ARG   183       8.529 -12.707 -18.273  1.00 72.05           C  
ATOM   2350  NH1 ARG   183       7.331 -12.821 -17.696  1.00 72.19           N  
ATOM   2353  NH2 ARG   183       9.360 -13.752 -18.250  1.00 72.32           N  
ATOM   2356  C   ARG   183       5.703  -6.792 -19.436  1.00 64.18           C  
ATOM   2357  O   ARG   183       5.642  -6.568 -20.637  1.00 64.12           O  
ATOM   2359  N   LYS   184       5.227  -5.959 -18.517  1.00 63.29           N  
ATOM   2360  CA  LYS   184       5.375  -4.518 -18.653  1.00 62.52           C  
ATOM   2362  CB  LYS   184       4.256  -3.759 -17.919  1.00 62.62           C  
ATOM   2365  CG  LYS   184       3.358  -2.885 -18.806  1.00 63.47           C  
ATOM   2368  CD  LYS   184       1.986  -3.523 -19.112  1.00 64.59           C  
ATOM   2371  CE  LYS   184       2.078  -4.633 -20.162  1.00 64.94           C  
ATOM   2374  NZ  LYS   184       2.091  -4.087 -21.547  1.00 64.60           N  
ATOM   2378  C   LYS   184       6.770  -4.110 -18.108  1.00 62.03           C  
ATOM   2379  O   LYS   184       7.178  -2.961 -18.231  1.00 61.89           O  
ATOM   2381  N   SER   185       7.505  -5.037 -17.498  1.00 61.35           N  
ATOM   2382  CA  SER   185       8.850  -4.714 -17.044  1.00 61.03           C  
ATOM   2384  CB  SER   185       9.434  -5.803 -16.132  1.00 60.97           C  
ATOM   2387  OG  SER   185       9.795  -6.961 -16.860  1.00 60.85           O  
ATOM   2389  C   SER   185       9.751  -4.477 -18.255  1.00 60.66           C  
ATOM   2390  O   SER   185       9.461  -4.955 -19.352  1.00 60.73           O  
ATOM   2392  N   THR   186      10.819  -3.710 -18.041  1.00 60.16           N  
ATOM   2393  CA  THR   186      11.822  -3.414 -19.065  1.00 59.55           C  
ATOM   2395  CB  THR   186      11.928  -1.885 -19.363  1.00 59.44           C  
ATOM   2397  OG1 THR   186      12.632  -1.217 -18.306  1.00 58.73           O  
ATOM   2399  CG2 THR   186      10.548  -1.259 -19.535  1.00 58.20           C  
ATOM   2403  C   THR   186      13.172  -3.938 -18.593  1.00 59.28           C  
ATOM   2404  O   THR   186      13.331  -4.312 -17.433  1.00 59.38           O  
ATOM   2406  N   PHE   187      14.142  -3.967 -19.496  1.00 59.05           N  
ATOM   2407  CA  PHE   187      15.453  -4.549 -19.204  1.00 58.62           C  
ATOM   2409  CB  PHE   187      16.282  -4.624 -20.488  1.00 58.79           C  
ATOM   2412  CG  PHE   187      17.628  -5.247 -20.302  1.00 59.27           C  
ATOM   2413  CD1 PHE   187      17.742  -6.599 -19.997  1.00 59.27           C  
ATOM   2415  CE1 PHE   187      18.979  -7.175 -19.816  1.00 59.05           C  
ATOM   2417  CZ  PHE   187      20.126  -6.406 -19.938  1.00 59.48           C  
ATOM   2419  CE2 PHE   187      20.033  -5.058 -20.246  1.00 59.65           C  
ATOM   2421  CD2 PHE   187      18.788  -4.484 -20.428  1.00 60.01           C  
ATOM   2423  C   PHE   187      16.191  -3.766 -18.113  1.00 58.12           C  
ATOM   2424  O   PHE   187      16.736  -4.351 -17.185  1.00 57.71           O  
ATOM   2426  N   GLY   188      16.187  -2.443 -18.225  1.00 57.93           N  
ATOM   2427  CA  GLY   188      16.761  -1.573 -17.205  1.00 57.93           C  
ATOM   2430  C   GLY   188      16.174  -1.824 -15.829  1.00 57.84           C  
ATOM   2431  O   GLY   188      16.899  -1.823 -14.832  1.00 57.85           O  
ATOM   2433  N   GLU   189      14.860  -2.049 -15.775  1.00 57.90           N  
ATOM   2434  CA  GLU   189      14.166  -2.366 -14.517  1.00 57.83           C  
ATOM   2436  CB  GLU   189      12.643  -2.359 -14.707  1.00 57.87           C  
ATOM   2439  CG  GLU   189      12.016  -0.960 -14.901  1.00 58.02           C  
ATOM   2442  CD  GLU   189      10.597  -1.013 -15.472  1.00 57.91           C  
ATOM   2443  OE1 GLU   189      10.172  -2.109 -15.874  1.00 58.26           O  
ATOM   2444  OE2 GLU   189       9.905   0.033 -15.527  1.00 58.16           O  
ATOM   2445  C   GLU   189      14.621  -3.715 -13.953  1.00 57.77           C  
ATOM   2446  O   GLU   189      14.890  -3.826 -12.751  1.00 57.79           O  
ATOM   2448  N   ARG   190      14.719  -4.729 -14.815  1.00 57.61           N  
ATOM   2449  CA  ARG   190      15.237  -6.032 -14.389  1.00 57.59           C  
ATOM   2451  CB  ARG   190      15.081  -7.083 -15.483  1.00 57.48           C  
ATOM   2454  CG  ARG   190      13.858  -7.972 -15.328  1.00 57.15           C  
ATOM   2457  CD  ARG   190      12.917  -7.809 -16.474  1.00 56.54           C  
ATOM   2460  NE  ARG   190      13.598  -8.099 -17.729  1.00 56.46           N  
ATOM   2462  CZ  ARG   190      13.223  -7.644 -18.924  1.00 56.39           C  
ATOM   2463  NH1 ARG   190      12.146  -6.876 -19.074  1.00 56.59           N  
ATOM   2466  NH2 ARG   190      13.936  -7.966 -19.984  1.00 55.96           N  
ATOM   2469  C   ARG   190      16.701  -6.003 -13.914  1.00 57.65           C  
ATOM   2470  O   ARG   190      17.056  -6.695 -12.958  1.00 57.91           O  
ATOM   2472  N   VAL   191      17.546  -5.220 -14.573  1.00 57.52           N  
ATOM   2473  CA  VAL   191      18.916  -5.048 -14.115  1.00 57.50           C  
ATOM   2475  CB  VAL   191      19.733  -4.133 -15.061  1.00 57.57           C  
ATOM   2477  CG1 VAL   191      21.056  -3.730 -14.417  1.00 57.58           C  
ATOM   2481  CG2 VAL   191      19.983  -4.825 -16.412  1.00 57.58           C  
ATOM   2485  C   VAL   191      18.924  -4.475 -12.698  1.00 57.54           C  
ATOM   2486  O   VAL   191      19.691  -4.915 -11.866  1.00 57.97           O  
ATOM   2488  N   VAL   192      18.070  -3.499 -12.414  1.00 57.72           N  
ATOM   2489  CA  VAL   192      18.011  -2.917 -11.071  1.00 57.93           C  
ATOM   2491  CB  VAL   192      17.179  -1.597 -11.034  1.00 57.86           C  
ATOM   2493  CG1 VAL   192      17.006  -1.102  -9.598  1.00 56.91           C  
ATOM   2497  CG2 VAL   192      17.838  -0.523 -11.889  1.00 57.14           C  
ATOM   2501  C   VAL   192      17.444  -3.927 -10.060  1.00 58.23           C  
ATOM   2502  O   VAL   192      17.914  -4.012  -8.918  1.00 58.00           O  
ATOM   2504  N   ALA   193      16.438  -4.689 -10.478  1.00 58.68           N  
ATOM   2505  CA  ALA   193      15.900  -5.753  -9.638  1.00 59.05           C  
ATOM   2507  CB  ALA   193      14.713  -6.389 -10.289  1.00 58.78           C  
ATOM   2511  C   ALA   193      16.982  -6.793  -9.366  1.00 59.65           C  
ATOM   2512  O   ALA   193      17.185  -7.218  -8.220  1.00 59.90           O  
ATOM   2514  N   PHE   194      17.688  -7.184 -10.423  1.00 60.41           N  
ATOM   2515  CA  PHE   194      18.773  -8.146 -10.312  1.00 60.32           C  
ATOM   2517  CB  PHE   194      19.449  -8.327 -11.676  1.00 62.03           C  
ATOM   2520  CG  PHE   194      20.341  -9.543 -11.770  1.00 62.18           C  
ATOM   2521  CD1 PHE   194      19.793 -10.810 -11.930  1.00 64.82           C  
ATOM   2523  CE1 PHE   194      20.607 -11.940 -12.027  1.00 64.89           C  
ATOM   2525  CZ  PHE   194      21.995 -11.805 -11.972  1.00 65.46           C  
ATOM   2527  CE2 PHE   194      22.560 -10.537 -11.821  1.00 65.26           C  
ATOM   2529  CD2 PHE   194      21.726  -9.417 -11.725  1.00 64.75           C  
ATOM   2531  C   PHE   194      19.782  -7.686  -9.262  1.00 60.10           C  
ATOM   2532  O   PHE   194      20.149  -8.451  -8.374  1.00 59.94           O  
ATOM   2534  N   ALA   195      20.209  -6.431  -9.357  1.00 59.48           N  
ATOM   2535  CA  ALA   195      21.171  -5.865  -8.413  1.00 59.52           C  
ATOM   2537  CB  ALA   195      21.530  -4.450  -8.823  1.00 59.23           C  
ATOM   2541  C   ALA   195      20.660  -5.885  -6.969  1.00 59.40           C  
ATOM   2542  O   ALA   195      21.439  -6.068  -6.034  1.00 58.80           O  
ATOM   2544  N   ALA   196      19.350  -5.689  -6.803  1.00 59.57           N  
ATOM   2545  CA  ALA   196      18.706  -5.689  -5.485  1.00 59.62           C  
ATOM   2547  CB  ALA   196      17.295  -5.110  -5.602  1.00 59.52           C  
ATOM   2551  C   ALA   196      18.668  -7.096  -4.839  1.00 59.78           C  
ATOM   2552  O   ALA   196      18.964  -7.254  -3.649  1.00 59.64           O  
ATOM   2554  N   VAL   197      18.282  -8.099  -5.632  1.00 59.84           N  
ATOM   2555  CA  VAL   197      18.336  -9.512  -5.233  1.00 59.68           C  
ATOM   2557  CB  VAL   197      17.974 -10.439  -6.424  1.00 59.51           C  
ATOM   2559  CG1 VAL   197      18.394 -11.848  -6.170  1.00 58.27           C  
ATOM   2563  CG2 VAL   197      16.485 -10.365  -6.717  1.00 59.33           C  
ATOM   2567  C   VAL   197      19.711  -9.911  -4.697  1.00 59.88           C  
ATOM   2568  O   VAL   197      19.803 -10.710  -3.778  1.00 60.45           O  
ATOM   2570  N   GLU   198      20.775  -9.354  -5.262  1.00 60.03           N  
ATOM   2571  CA  GLU   198      22.129  -9.708  -4.853  1.00 60.09           C  
ATOM   2573  CB  GLU   198      23.112  -9.555  -6.018  1.00 60.66           C  
ATOM   2576  CG  GLU   198      22.756 -10.382  -7.240  1.00 62.54           C  
ATOM   2579  CD  GLU   198      22.678 -11.861  -6.923  1.00 65.15           C  
ATOM   2580  OE1 GLU   198      21.576 -12.337  -6.582  1.00 67.13           O  
ATOM   2581  OE2 GLU   198      23.724 -12.544  -6.981  1.00 68.11           O  
ATOM   2582  C   GLU   198      22.623  -8.876  -3.696  1.00 59.98           C  
ATOM   2583  O   GLU   198      23.311  -9.405  -2.839  1.00 60.79           O  
ATOM   2585  N   GLY   199      22.283  -7.588  -3.671  1.00 59.46           N  
ATOM   2586  CA  GLY   199      22.857  -6.643  -2.713  1.00 59.08           C  
ATOM   2589  C   GLY   199      21.956  -6.105  -1.610  1.00 58.82           C  
ATOM   2590  O   GLY   199      22.439  -5.527  -0.651  1.00 59.08           O  
ATOM   2592  N   VAL   200      20.648  -6.264  -1.731  1.00 58.78           N  
ATOM   2593  CA  VAL   200      19.744  -5.844  -0.665  1.00 58.68           C  
ATOM   2595  CB  VAL   200      18.611  -4.936  -1.188  1.00 58.83           C  
ATOM   2597  CG1 VAL   200      17.520  -4.753  -0.123  1.00 58.63           C  
ATOM   2601  CG2 VAL   200      19.185  -3.591  -1.604  1.00 58.73           C  
ATOM   2605  C   VAL   200      19.159  -7.048   0.059  1.00 58.60           C  
ATOM   2606  O   VAL   200      19.196  -7.097   1.288  1.00 58.82           O  
ATOM   2608  N   PHE   201      18.626  -8.017  -0.684  1.00 58.23           N  
ATOM   2609  CA  PHE   201      18.084  -9.203  -0.044  1.00 58.24           C  
ATOM   2611  CB  PHE   201      17.271 -10.057  -1.007  1.00 58.11           C  
ATOM   2614  CG  PHE   201      15.941  -9.464  -1.373  1.00 58.03           C  
ATOM   2615  CD1 PHE   201      15.405  -9.681  -2.622  1.00 57.87           C  
ATOM   2617  CE1 PHE   201      14.186  -9.149  -2.968  1.00 58.13           C  
ATOM   2619  CZ  PHE   201      13.484  -8.375  -2.067  1.00 58.20           C  
ATOM   2621  CE2 PHE   201      14.000  -8.146  -0.820  1.00 58.28           C  
ATOM   2623  CD2 PHE   201      15.223  -8.689  -0.474  1.00 58.61           C  
ATOM   2625  C   PHE   201      19.208 -10.014   0.565  1.00 58.38           C  
ATOM   2626  O   PHE   201      20.300 -10.062   0.015  1.00 58.89           O  
ATOM   2628  N   PHE   202      18.934 -10.617   1.720  1.00 58.13           N  
ATOM   2629  CA  PHE   202      19.936 -11.324   2.522  1.00 57.97           C  
ATOM   2631  CB  PHE   202      20.447 -12.572   1.785  1.00 58.46           C  
ATOM   2634  CG  PHE   202      19.429 -13.668   1.700  1.00 59.25           C  
ATOM   2635  CD1 PHE   202      18.958 -14.282   2.856  1.00 60.15           C  
ATOM   2637  CE1 PHE   202      18.000 -15.288   2.797  1.00 59.57           C  
ATOM   2639  CZ  PHE   202      17.511 -15.699   1.576  1.00 59.83           C  
ATOM   2641  CE2 PHE   202      17.977 -15.099   0.410  1.00 60.07           C  
ATOM   2643  CD2 PHE   202      18.930 -14.086   0.479  1.00 60.28           C  
ATOM   2645  C   PHE   202      21.115 -10.475   3.028  1.00 57.48           C  
ATOM   2646  O   PHE   202      21.955 -10.976   3.756  1.00 57.12           O  
ATOM   2648  N   SER   203      21.173  -9.195   2.687  1.00 57.07           N  
ATOM   2649  CA  SER   203      22.231  -8.351   3.229  1.00 57.08           C  
ATOM   2651  CB  SER   203      22.129  -6.915   2.706  1.00 56.93           C  
ATOM   2654  OG  SER   203      20.936  -6.323   3.147  1.00 57.05           O  
ATOM   2656  C   SER   203      22.221  -8.358   4.759  1.00 56.76           C  
ATOM   2657  O   SER   203      23.275  -8.425   5.373  1.00 56.99           O  
ATOM   2659  N   GLY   204      21.044  -8.299   5.372  1.00 56.50           N  
ATOM   2660  CA  GLY   204      20.951  -8.329   6.829  1.00 56.45           C  
ATOM   2663  C   GLY   204      21.357  -9.640   7.501  1.00 56.42           C  
ATOM   2664  O   GLY   204      21.777  -9.645   8.657  1.00 56.59           O  
ATOM   2666  N   SER   205      21.238 -10.754   6.790  1.00 56.16           N  
ATOM   2667  CA  SER   205      21.568 -12.057   7.352  1.00 56.07           C  
ATOM   2669  CB  SER   205      20.792 -13.155   6.621  1.00 56.14           C  
ATOM   2672  OG  SER   205      19.431 -12.757   6.428  1.00 57.73           O  
ATOM   2674  C   SER   205      23.070 -12.309   7.293  1.00 55.79           C  
ATOM   2675  O   SER   205      23.652 -12.876   8.217  1.00 55.41           O  
ATOM   2677  N   PHE   206      23.707 -11.880   6.211  1.00 56.01           N  
ATOM   2678  CA  PHE   206      25.166 -11.912   6.139  1.00 56.11           C  
ATOM   2680  CB  PHE   206      25.681 -11.350   4.819  1.00 56.40           C  
ATOM   2683  CG  PHE   206      25.283 -12.155   3.613  1.00 56.19           C  
ATOM   2684  CD1 PHE   206      25.430 -13.528   3.595  1.00 56.35           C  
ATOM   2686  CE1 PHE   206      25.060 -14.277   2.473  1.00 57.78           C  
ATOM   2688  CZ  PHE   206      24.548 -13.641   1.345  1.00 57.62           C  
ATOM   2690  CE2 PHE   206      24.404 -12.260   1.348  1.00 56.84           C  
ATOM   2692  CD2 PHE   206      24.780 -11.526   2.481  1.00 57.01           C  
ATOM   2694  C   PHE   206      25.735 -11.119   7.293  1.00 56.04           C  
ATOM   2695  O   PHE   206      26.648 -11.564   7.965  1.00 56.33           O  
ATOM   2697  N   ALA   207      25.145  -9.962   7.544  1.00 56.19           N  
ATOM   2698  CA  ALA   207      25.546  -9.100   8.634  1.00 56.33           C  
ATOM   2700  CB  ALA   207      24.750  -7.821   8.579  1.00 56.15           C  
ATOM   2704  C   ALA   207      25.372  -9.790   9.988  1.00 56.63           C  
ATOM   2705  O   ALA   207      26.278  -9.740  10.828  1.00 56.48           O  
ATOM   2707  N   ALA   208      24.218 -10.437  10.189  1.00 57.03           N  
ATOM   2708  CA  ALA   208      23.945 -11.234  11.409  1.00 57.21           C  
ATOM   2710  CB  ALA   208      22.539 -11.832  11.360  1.00 56.93           C  
ATOM   2714  C   ALA   208      24.981 -12.347  11.626  1.00 57.49           C  
ATOM   2715  O   ALA   208      25.447 -12.568  12.747  1.00 57.20           O  
ATOM   2717  N   ILE   209      25.347 -13.044  10.553  1.00 58.06           N  
ATOM   2718  CA  ILE   209      26.348 -14.107  10.662  1.00 58.61           C  
ATOM   2720  CB  ILE   209      26.337 -15.034   9.440  1.00 58.32           C  
ATOM   2722  CG1 ILE   209      24.998 -15.779   9.384  1.00 58.52           C  
ATOM   2725  CD1 ILE   209      24.907 -16.814   8.282  1.00 58.70           C  
ATOM   2729  CG2 ILE   209      27.460 -16.034   9.532  1.00 57.90           C  
ATOM   2733  C   ILE   209      27.741 -13.528  10.932  1.00 59.05           C  
ATOM   2734  O   ILE   209      28.559 -14.154  11.615  1.00 58.73           O  
ATOM   2736  N   PHE   210      27.992 -12.328  10.415  1.00 59.83           N  
ATOM   2737  CA  PHE   210      29.231 -11.617  10.707  1.00 60.52           C  
ATOM   2739  CB  PHE   210      29.390 -10.399   9.802  1.00 60.68           C  
ATOM   2742  CG  PHE   210      30.089 -10.684   8.506  1.00 60.62           C  
ATOM   2743  CD1 PHE   210      31.440 -11.006   8.488  1.00 62.30           C  
ATOM   2745  CE1 PHE   210      32.103 -11.257   7.275  1.00 61.92           C  
ATOM   2747  CZ  PHE   210      31.402 -11.166   6.079  1.00 61.35           C  
ATOM   2749  CE2 PHE   210      30.062 -10.835   6.088  1.00 60.95           C  
ATOM   2751  CD2 PHE   210      29.416 -10.590   7.295  1.00 61.35           C  
ATOM   2753  C   PHE   210      29.281 -11.187  12.169  1.00 61.23           C  
ATOM   2754  O   PHE   210      30.346 -11.203  12.769  1.00 61.14           O  
ATOM   2756  N   TRP   211      28.133 -10.806  12.737  1.00 62.26           N  
ATOM   2757  CA  TRP   211      28.032 -10.481  14.174  1.00 62.79           C  
ATOM   2759  CB  TRP   211      26.609 -10.033  14.531  1.00 62.86           C  
ATOM   2762  CG  TRP   211      26.331  -9.878  16.000  1.00 62.88           C  
ATOM   2763  CD1 TRP   211      25.821 -10.822  16.851  1.00 63.44           C  
ATOM   2765  NE1 TRP   211      25.694 -10.308  18.121  1.00 62.89           N  
ATOM   2767  CE2 TRP   211      26.119  -9.009  18.108  1.00 63.11           C  
ATOM   2768  CD2 TRP   211      26.527  -8.704  16.786  1.00 63.55           C  
ATOM   2769  CE3 TRP   211      26.998  -7.417  16.502  1.00 63.56           C  
ATOM   2771  CZ3 TRP   211      27.054  -6.490  17.526  1.00 63.48           C  
ATOM   2773  CH2 TRP   211      26.651  -6.827  18.835  1.00 63.55           C  
ATOM   2775  CZ2 TRP   211      26.182  -8.079  19.140  1.00 63.37           C  
ATOM   2777  C   TRP   211      28.461 -11.655  15.065  1.00 63.48           C  
ATOM   2778  O   TRP   211      29.065 -11.453  16.109  1.00 63.55           O  
ATOM   2780  N   LEU   212      28.156 -12.878  14.648  1.00 64.38           N  
ATOM   2781  CA  LEU   212      28.546 -14.069  15.411  1.00 64.98           C  
ATOM   2783  CB  LEU   212      27.815 -15.315  14.886  1.00 65.26           C  
ATOM   2786  CG  LEU   212      26.286 -15.263  14.773  1.00 65.82           C  
ATOM   2788  CD1 LEU   212      25.751 -16.562  14.150  1.00 66.02           C  
ATOM   2792  CD2 LEU   212      25.634 -14.981  16.137  1.00 65.73           C  
ATOM   2796  C   LEU   212      30.060 -14.301  15.335  1.00 65.58           C  
ATOM   2797  O   LEU   212      30.674 -14.805  16.296  1.00 65.45           O  
ATOM   2799  N   LYS   213      30.652 -13.953  14.185  1.00 66.10           N  
ATOM   2800  CA  LYS   213      32.103 -14.055  13.999  1.00 66.50           C  
ATOM   2802  CB  LYS   213      32.516 -13.675  12.580  1.00 66.47           C  
ATOM   2805  CG  LYS   213      34.021 -13.592  12.339  1.00 66.16           C  
ATOM   2808  CD  LYS   213      34.299 -13.564  10.833  1.00 66.56           C  
ATOM   2811  CE  LYS   213      35.374 -12.558  10.417  1.00 66.38           C  
ATOM   2814  NZ  LYS   213      36.618 -13.222   9.995  1.00 66.52           N  
ATOM   2818  C   LYS   213      32.789 -13.157  15.004  1.00 66.92           C  
ATOM   2819  O   LYS   213      33.770 -13.551  15.616  1.00 66.87           O  
ATOM   2821  N   LYS   214      32.235 -11.962  15.194  1.00 67.67           N  
ATOM   2822  CA  LYS   214      32.696 -11.042  16.239  1.00 67.87           C  
ATOM   2824  CB  LYS   214      31.751  -9.831  16.363  1.00 67.94           C  
ATOM   2827  CG  LYS   214      32.303  -8.710  17.248  1.00 68.33           C  
ATOM   2830  CD  LYS   214      31.997  -7.301  16.712  1.00 68.54           C  
ATOM   2833  CE  LYS   214      32.747  -6.228  17.516  1.00 68.65           C  
ATOM   2836  NZ  LYS   214      32.726  -4.901  16.835  1.00 68.92           N  
ATOM   2840  C   LYS   214      32.848 -11.742  17.592  1.00 68.04           C  
ATOM   2841  O   LYS   214      33.728 -11.384  18.380  1.00 68.06           O  
ATOM   2843  N   ARG   215      32.009 -12.748  17.843  1.00 68.21           N  
ATOM   2844  CA  ARG   215      32.027 -13.490  19.110  1.00 68.37           C  
ATOM   2846  CB  ARG   215      30.597 -13.652  19.621  1.00 68.23           C  
ATOM   2849  CG  ARG   215      29.840 -12.328  19.762  1.00 68.68           C  
ATOM   2852  CD  ARG   215      28.338 -12.531  19.782  1.00 69.48           C  
ATOM   2855  NE  ARG   215      27.992 -13.778  20.470  1.00 71.34           N  
ATOM   2857  CZ  ARG   215      26.774 -14.319  20.523  1.00 71.79           C  
ATOM   2858  NH1 ARG   215      25.714 -13.725  19.962  1.00 71.77           N  
ATOM   2861  NH2 ARG   215      26.623 -15.470  21.169  1.00 72.12           N  
ATOM   2864  C   ARG   215      32.726 -14.867  19.015  1.00 68.33           C  
ATOM   2865  O   ARG   215      32.481 -15.746  19.849  1.00 68.48           O  
ATOM   2867  N   GLY   216      33.590 -15.040  18.008  1.00 67.99           N  
ATOM   2868  CA  GLY   216      34.423 -16.246  17.853  1.00 67.51           C  
ATOM   2871  C   GLY   216      33.682 -17.568  17.704  1.00 67.34           C  
ATOM   2872  O   GLY   216      34.246 -18.624  18.009  1.00 67.52           O  
ATOM   2874  N   LEU   217      32.438 -17.518  17.213  1.00 66.95           N  
ATOM   2875  CA  LEU   217      31.541 -18.690  17.182  1.00 66.44           C  
ATOM   2877  CB  LEU   217      30.162 -18.300  17.724  1.00 66.59           C  
ATOM   2880  CG  LEU   217      30.056 -18.224  19.254  1.00 66.74           C  
ATOM   2882  CD1 LEU   217      28.760 -17.536  19.681  1.00 65.81           C  
ATOM   2886  CD2 LEU   217      30.171 -19.629  19.888  1.00 67.23           C  
ATOM   2890  C   LEU   217      31.383 -19.293  15.787  1.00 65.88           C  
ATOM   2891  O   LEU   217      31.347 -18.566  14.808  1.00 66.19           O  
ATOM   2893  N   MET   218      31.312 -20.622  15.709  1.00 65.19           N  
ATOM   2894  CA  MET   218      30.908 -21.333  14.486  1.00 64.61           C  
ATOM   2896  CB  MET   218      29.454 -20.970  14.165  1.00 64.90           C  
ATOM   2899  CG  MET   218      28.506 -21.052  15.363  1.00 64.94           C  
ATOM   2902  SD  MET   218      27.581 -22.580  15.435  1.00 64.44           S  
ATOM   2903  CE  MET   218      28.566 -23.670  14.409  1.00 64.19           C  
ATOM   2907  C   MET   218      31.785 -21.008  13.267  1.00 63.96           C  
ATOM   2908  O   MET   218      31.311 -20.396  12.315  1.00 63.73           O  
ATOM   2910  N   PRO   219      33.065 -21.420  13.287  1.00 63.26           N  
ATOM   2911  CA  PRO   219      34.002 -21.016  12.226  1.00 62.59           C  
ATOM   2913  CB  PRO   219      35.328 -21.657  12.647  1.00 62.49           C  
ATOM   2916  CG  PRO   219      34.969 -22.708  13.632  1.00 62.79           C  
ATOM   2919  CD  PRO   219      33.716 -22.265  14.305  1.00 63.22           C  
ATOM   2922  C   PRO   219      33.625 -21.459  10.825  1.00 61.97           C  
ATOM   2923  O   PRO   219      33.947 -20.762   9.876  1.00 62.39           O  
ATOM   2924  N   GLY   220      32.957 -22.602  10.690  1.00 61.27           N  
ATOM   2925  CA  GLY   220      32.558 -23.112   9.376  1.00 60.84           C  
ATOM   2928  C   GLY   220      31.404 -22.325   8.763  1.00 60.44           C  
ATOM   2929  O   GLY   220      31.403 -22.026   7.562  1.00 60.34           O  
ATOM   2931  N   LEU   221      30.412 -22.008   9.591  1.00 59.81           N  
ATOM   2932  CA  LEU   221      29.326 -21.116   9.207  1.00 59.39           C  
ATOM   2934  CB  LEU   221      28.338 -20.975  10.359  1.00 59.36           C  
ATOM   2937  CG  LEU   221      27.194 -19.990  10.160  1.00 59.71           C  
ATOM   2939  CD1 LEU   221      26.238 -20.541   9.109  1.00 60.60           C  
ATOM   2943  CD2 LEU   221      26.478 -19.695  11.472  1.00 58.87           C  
ATOM   2947  C   LEU   221      29.866 -19.738   8.819  1.00 59.12           C  
ATOM   2948  O   LEU   221      29.538 -19.215   7.760  1.00 59.37           O  
ATOM   2950  N   THR   222      30.697 -19.148   9.668  1.00 58.76           N  
ATOM   2951  CA  THR   222      31.171 -17.794   9.415  1.00 58.54           C  
ATOM   2953  CB  THR   222      31.839 -17.163  10.640  1.00 58.43           C  
ATOM   2955  OG1 THR   222      32.987 -17.931  10.993  1.00 58.09           O  
ATOM   2957  CG2 THR   222      30.864 -17.087  11.804  1.00 58.33           C  
ATOM   2961  C   THR   222      32.152 -17.727   8.245  1.00 58.40           C  
ATOM   2962  O   THR   222      32.170 -16.722   7.521  1.00 58.04           O  
ATOM   2964  N   PHE   223      32.964 -18.774   8.057  1.00 58.24           N  
ATOM   2965  CA  PHE   223      33.924 -18.780   6.938  1.00 57.85           C  
ATOM   2967  CB  PHE   223      35.008 -19.858   7.076  1.00 57.76           C  
ATOM   2970  CG  PHE   223      35.962 -19.880   5.901  1.00 58.55           C  
ATOM   2971  CD1 PHE   223      36.650 -18.730   5.530  1.00 58.57           C  
ATOM   2973  CE1 PHE   223      37.504 -18.739   4.438  1.00 58.15           C  
ATOM   2975  CZ  PHE   223      37.665 -19.893   3.695  1.00 57.93           C  
ATOM   2977  CE2 PHE   223      36.985 -21.027   4.036  1.00 57.91           C  
ATOM   2979  CD2 PHE   223      36.130 -21.025   5.129  1.00 59.06           C  
ATOM   2981  C   PHE   223      33.201 -18.918   5.596  1.00 57.46           C  
ATOM   2982  O   PHE   223      33.516 -18.225   4.634  1.00 57.19           O  
ATOM   2984  N   SER   224      32.218 -19.807   5.551  1.00 57.20           N  
ATOM   2985  CA  SER   224      31.380 -19.953   4.373  1.00 56.94           C  
ATOM   2987  CB  SER   224      30.529 -21.219   4.494  1.00 56.94           C  
ATOM   2990  OG  SER   224      29.482 -21.033   5.421  1.00 57.53           O  
ATOM   2992  C   SER   224      30.507 -18.696   4.136  1.00 56.43           C  
ATOM   2993  O   SER   224      30.249 -18.330   2.993  1.00 56.03           O  
ATOM   2995  N   ASN   225      30.072 -18.033   5.209  1.00 56.13           N  
ATOM   2996  CA  ASN   225      29.379 -16.745   5.091  1.00 55.90           C  
ATOM   2998  CB  ASN   225      29.013 -16.215   6.473  1.00 55.54           C  
ATOM   3001  CG  ASN   225      28.231 -14.907   6.419  1.00 55.99           C  
ATOM   3002  OD1 ASN   225      27.093 -14.895   5.996  1.00 55.34           O  
ATOM   3003  ND2 ASN   225      28.842 -13.802   6.875  1.00 56.45           N  
ATOM   3006  C   ASN   225      30.242 -15.720   4.342  1.00 55.91           C  
ATOM   3007  O   ASN   225      29.739 -14.976   3.496  1.00 55.86           O  
ATOM   3009  N   GLU   226      31.544 -15.699   4.640  1.00 55.76           N  
ATOM   3010  CA  GLU   226      32.464 -14.754   3.999  1.00 56.00           C  
ATOM   3012  CB  GLU   226      33.866 -14.817   4.618  1.00 56.09           C  
ATOM   3015  CG  GLU   226      33.993 -14.072   5.938  1.00 57.31           C  
ATOM   3018  CD  GLU   226      35.403 -14.125   6.489  1.00 58.68           C  
ATOM   3019  OE1 GLU   226      35.567 -14.273   7.728  1.00 62.86           O  
ATOM   3020  OE2 GLU   226      36.356 -14.022   5.681  1.00 63.74           O  
ATOM   3021  C   GLU   226      32.580 -14.982   2.498  1.00 55.62           C  
ATOM   3022  O   GLU   226      32.486 -14.027   1.717  1.00 56.14           O  
ATOM   3024  N   LEU   227      32.789 -16.243   2.110  1.00 54.74           N  
ATOM   3025  CA  LEU   227      32.892 -16.629   0.702  1.00 54.00           C  
ATOM   3027  CB  LEU   227      33.238 -18.122   0.570  1.00 53.60           C  
ATOM   3030  CG  LEU   227      34.630 -18.577   1.055  1.00 51.81           C  
ATOM   3032  CD1 LEU   227      34.807 -20.072   0.853  1.00 49.95           C  
ATOM   3036  CD2 LEU   227      35.752 -17.817   0.379  1.00 48.92           C  
ATOM   3040  C   LEU   227      31.614 -16.322  -0.065  1.00 53.51           C  
ATOM   3041  O   LEU   227      31.656 -15.754  -1.150  1.00 53.11           O  
ATOM   3043  N   ILE   228      30.475 -16.678   0.514  1.00 53.50           N  
ATOM   3044  CA  ILE   228      29.203 -16.482  -0.160  1.00 53.52           C  
ATOM   3046  CB  ILE   228      28.049 -17.154   0.577  1.00 53.44           C  
ATOM   3048  CG1 ILE   228      28.254 -18.667   0.608  1.00 52.98           C  
ATOM   3051  CD1 ILE   228      27.358 -19.387   1.579  1.00 52.99           C  
ATOM   3055  CG2 ILE   228      26.715 -16.816  -0.115  1.00 53.43           C  
ATOM   3059  C   ILE   228      28.884 -15.006  -0.322  1.00 53.60           C  
ATOM   3060  O   ILE   228      28.446 -14.589  -1.381  1.00 53.52           O  
ATOM   3062  N   SER   229      29.098 -14.209   0.718  1.00 53.96           N  
ATOM   3063  CA  SER   229      28.725 -12.791   0.637  1.00 54.09           C  
ATOM   3065  CB  SER   229      28.635 -12.133   2.029  1.00 54.28           C  
ATOM   3068  OG  SER   229      29.898 -11.732   2.505  1.00 54.94           O  
ATOM   3070  C   SER   229      29.687 -12.042  -0.282  1.00 54.02           C  
ATOM   3071  O   SER   229      29.300 -11.089  -0.943  1.00 53.93           O  
ATOM   3073  N   ARG   230      30.933 -12.494  -0.331  1.00 53.78           N  
ATOM   3074  CA  ARG   230      31.873 -11.972  -1.286  1.00 53.91           C  
ATOM   3076  CB  ARG   230      33.253 -12.608  -1.074  1.00 53.84           C  
ATOM   3079  CG  ARG   230      34.354 -12.100  -2.035  1.00 53.79           C  
ATOM   3082  CD  ARG   230      35.344 -13.190  -2.421  1.00 54.41           C  
ATOM   3085  NE  ARG   230      34.662 -14.460  -2.689  1.00 55.48           N  
ATOM   3087  CZ  ARG   230      35.269 -15.639  -2.803  1.00 55.78           C  
ATOM   3088  NH1 ARG   230      36.593 -15.735  -2.702  1.00 57.07           N  
ATOM   3091  NH2 ARG   230      34.552 -16.733  -3.023  1.00 54.83           N  
ATOM   3094  C   ARG   230      31.339 -12.249  -2.690  1.00 54.03           C  
ATOM   3095  O   ARG   230      31.314 -11.356  -3.527  1.00 53.97           O  
ATOM   3097  N   ASP   231      30.898 -13.483  -2.934  1.00 54.38           N  
ATOM   3098  CA  ASP   231      30.337 -13.868  -4.232  1.00 54.46           C  
ATOM   3100  CB  ASP   231      29.959 -15.347  -4.244  1.00 54.27           C  
ATOM   3103  CG  ASP   231      31.173 -16.271  -4.144  1.00 55.07           C  
ATOM   3104  OD1 ASP   231      32.317 -15.766  -4.211  1.00 55.75           O  
ATOM   3105  OD2 ASP   231      30.988 -17.510  -4.014  1.00 54.44           O  
ATOM   3106  C   ASP   231      29.128 -13.018  -4.599  1.00 54.68           C  
ATOM   3107  O   ASP   231      29.017 -12.575  -5.733  1.00 54.56           O  
ATOM   3109  N   GLU   232      28.240 -12.760  -3.640  1.00 55.12           N  
ATOM   3110  CA  GLU   232      27.093 -11.872  -3.893  1.00 55.53           C  
ATOM   3112  CB  GLU   232      26.143 -11.783  -2.698  1.00 56.04           C  
ATOM   3115  CG  GLU   232      25.500 -13.087  -2.306  1.00 58.05           C  
ATOM   3118  CD  GLU   232      25.009 -13.869  -3.481  1.00 60.84           C  
ATOM   3119  OE1 GLU   232      24.168 -13.349  -4.241  1.00 64.13           O  
ATOM   3120  OE2 GLU   232      25.471 -15.011  -3.651  1.00 65.23           O  
ATOM   3121  C   GLU   232      27.502 -10.455  -4.233  1.00 55.35           C  
ATOM   3122  O   GLU   232      26.885  -9.839  -5.091  1.00 56.15           O  
ATOM   3124  N   GLY   233      28.506  -9.927  -3.545  1.00 54.65           N  
ATOM   3125  CA  GLY   233      28.983  -8.581  -3.820  1.00 54.62           C  
ATOM   3128  C   GLY   233      29.414  -8.432  -5.262  1.00 54.53           C  
ATOM   3129  O   GLY   233      29.024  -7.495  -5.951  1.00 54.47           O  
ATOM   3131  N   LEU   234      30.195  -9.400  -5.721  1.00 54.76           N  
ATOM   3132  CA  LEU   234      30.655  -9.462  -7.098  1.00 54.59           C  
ATOM   3134  CB  LEU   234      31.573 -10.677  -7.296  1.00 54.63           C  
ATOM   3137  CG  LEU   234      32.375 -10.721  -8.594  1.00 54.63           C  
ATOM   3139  CD1 LEU   234      33.572  -9.809  -8.468  1.00 55.08           C  
ATOM   3143  CD2 LEU   234      32.805 -12.134  -8.924  1.00 54.22           C  
ATOM   3147  C   LEU   234      29.475  -9.546  -8.040  1.00 54.50           C  
ATOM   3148  O   LEU   234      29.482  -8.902  -9.067  1.00 54.85           O  
ATOM   3150  N   HIS   235      28.457 -10.325  -7.697  1.00 54.67           N  
ATOM   3151  CA  HIS   235      27.279 -10.438  -8.569  1.00 55.09           C  
ATOM   3153  CB  HIS   235      26.369 -11.594  -8.164  1.00 55.40           C  
ATOM   3156  CG  HIS   235      27.049 -12.916  -8.217  1.00 55.89           C  
ATOM   3157  ND1 HIS   235      27.033 -13.800  -7.164  1.00 57.44           N  
ATOM   3159  CE1 HIS   235      27.752 -14.862  -7.479  1.00 58.20           C  
ATOM   3161  NE2 HIS   235      28.258 -14.683  -8.685  1.00 57.43           N  
ATOM   3163  CD2 HIS   235      27.838 -13.470  -9.166  1.00 56.90           C  
ATOM   3165  C   HIS   235      26.480  -9.161  -8.600  1.00 55.09           C  
ATOM   3166  O   HIS   235      26.004  -8.766  -9.655  1.00 55.28           O  
ATOM   3168  N   CYS   236      26.331  -8.522  -7.447  1.00 55.26           N  
ATOM   3169  CA  CYS   236      25.691  -7.220  -7.381  1.00 55.38           C  
ATOM   3171  CB  CYS   236      25.589  -6.768  -5.931  1.00 55.49           C  
ATOM   3174  SG  CYS   236      24.718  -5.200  -5.689  1.00 55.73           S  
ATOM   3176  C   CYS   236      26.483  -6.202  -8.211  1.00 55.60           C  
ATOM   3177  O   CYS   236      25.900  -5.420  -8.969  1.00 55.92           O  
ATOM   3179  N   ASP   237      27.810  -6.229  -8.083  1.00 55.54           N  
ATOM   3180  CA  ASP   237      28.692  -5.348  -8.868  1.00 55.33           C  
ATOM   3182  CB  ASP   237      30.149  -5.562  -8.484  1.00 55.43           C  
ATOM   3185  CG  ASP   237      30.472  -5.026  -7.129  1.00 56.57           C  
ATOM   3186  OD1 ASP   237      29.654  -4.243  -6.596  1.00 59.24           O  
ATOM   3187  OD2 ASP   237      31.548  -5.389  -6.599  1.00 58.84           O  
ATOM   3188  C   ASP   237      28.600  -5.540 -10.374  1.00 55.12           C  
ATOM   3189  O   ASP   237      28.788  -4.576 -11.135  1.00 55.12           O  
ATOM   3191  N   PHE   238      28.366  -6.776 -10.808  1.00 54.39           N  
ATOM   3192  CA  PHE   238      28.288  -7.040 -12.227  1.00 54.44           C  
ATOM   3194  CB  PHE   238      28.337  -8.521 -12.539  1.00 54.07           C  
ATOM   3197  CG  PHE   238      28.399  -8.795 -13.998  1.00 53.72           C  
ATOM   3198  CD1 PHE   238      29.581  -8.596 -14.690  1.00 53.84           C  
ATOM   3200  CE1 PHE   238      29.650  -8.821 -16.050  1.00 54.09           C  
ATOM   3202  CZ  PHE   238      28.524  -9.242 -16.730  1.00 54.13           C  
ATOM   3204  CE2 PHE   238      27.333  -9.429 -16.046  1.00 53.44           C  
ATOM   3206  CD2 PHE   238      27.277  -9.192 -14.691  1.00 52.78           C  
ATOM   3208  C   PHE   238      27.012  -6.457 -12.793  1.00 54.52           C  
ATOM   3209  O   PHE   238      27.018  -5.872 -13.867  1.00 54.69           O  
ATOM   3211  N   ALA   239      25.913  -6.638 -12.069  1.00 54.68           N  
ATOM   3212  CA  ALA   239      24.641  -6.055 -12.448  1.00 54.41           C  
ATOM   3214  CB  ALA   239      23.567  -6.450 -11.448  1.00 53.98           C  
ATOM   3218  C   ALA   239      24.768  -4.528 -12.555  1.00 54.27           C  
ATOM   3219  O   ALA   239      24.233  -3.937 -13.478  1.00 54.04           O  
ATOM   3221  N   CYS   240      25.494  -3.895 -11.636  1.00 54.36           N  
ATOM   3222  CA  CYS   240      25.709  -2.449 -11.726  1.00 54.82           C  
ATOM   3224  CB  CYS   240      26.322  -1.888 -10.452  1.00 55.12           C  
ATOM   3227  SG  CYS   240      25.193  -1.930  -9.042  1.00 57.83           S  
ATOM   3229  C   CYS   240      26.575  -2.061 -12.904  1.00 54.62           C  
ATOM   3230  O   CYS   240      26.393  -1.000 -13.472  1.00 55.20           O  
ATOM   3232  N   LEU   241      27.516  -2.912 -13.274  1.00 54.52           N  
ATOM   3233  CA  LEU   241      28.317  -2.667 -14.469  1.00 54.52           C  
ATOM   3235  CB  LEU   241      29.439  -3.694 -14.586  1.00 54.52           C  
ATOM   3238  CG  LEU   241      30.531  -3.441 -15.619  1.00 54.23           C  
ATOM   3240  CD1 LEU   241      31.139  -2.023 -15.521  1.00 52.75           C  
ATOM   3244  CD2 LEU   241      31.573  -4.520 -15.429  1.00 54.12           C  
ATOM   3248  C   LEU   241      27.462  -2.691 -15.724  1.00 54.52           C  
ATOM   3249  O   LEU   241      27.559  -1.787 -16.531  1.00 54.53           O  
ATOM   3251  N   MET   242      26.622  -3.716 -15.875  1.00 54.72           N  
ATOM   3252  CA  MET   242      25.684  -3.816 -17.014  1.00 54.88           C  
ATOM   3254  CB  MET   242      24.753  -5.035 -16.887  1.00 55.20           C  
ATOM   3257  CG  MET   242      25.406  -6.429 -16.904  1.00 56.41           C  
ATOM   3260  SD  MET   242      26.396  -6.781 -18.370  1.00 59.99           S  
ATOM   3261  CE  MET   242      27.977  -6.085 -17.845  1.00 59.64           C  
ATOM   3265  C   MET   242      24.800  -2.572 -17.153  1.00 54.70           C  
ATOM   3266  O   MET   242      24.592  -2.076 -18.261  1.00 54.68           O  
ATOM   3268  N   PHE   243      24.289  -2.084 -16.024  1.00 54.38           N  
ATOM   3269  CA  PHE   243      23.428  -0.910 -15.985  1.00 54.49           C  
ATOM   3271  CB  PHE   243      23.050  -0.604 -14.538  1.00 54.37           C  
ATOM   3274  CG  PHE   243      21.999   0.459 -14.393  1.00 54.38           C  
ATOM   3275  CD1 PHE   243      20.692   0.210 -14.787  1.00 53.99           C  
ATOM   3277  CE1 PHE   243      19.725   1.172 -14.660  1.00 54.02           C  
ATOM   3279  CZ  PHE   243      20.047   2.408 -14.118  1.00 54.42           C  
ATOM   3281  CE2 PHE   243      21.344   2.671 -13.718  1.00 54.35           C  
ATOM   3283  CD2 PHE   243      22.313   1.700 -13.856  1.00 54.16           C  
ATOM   3285  C   PHE   243      24.082   0.328 -16.603  1.00 54.63           C  
ATOM   3286  O   PHE   243      23.405   1.192 -17.156  1.00 54.48           O  
ATOM   3288  N   GLN   244      25.404   0.408 -16.492  1.00 54.91           N  
ATOM   3289  CA  GLN   244      26.169   1.495 -17.091  1.00 54.86           C  
ATOM   3291  CB  GLN   244      27.607   1.475 -16.587  1.00 55.09           C  
ATOM   3294  CG  GLN   244      27.813   1.981 -15.180  1.00 55.45           C  
ATOM   3297  CD  GLN   244      29.292   2.000 -14.858  1.00 56.04           C  
ATOM   3298  OE1 GLN   244      29.891   0.950 -14.586  1.00 60.09           O  
ATOM   3299  NE2 GLN   244      29.903   3.176 -14.934  1.00 55.51           N  
ATOM   3302  C   GLN   244      26.207   1.474 -18.617  1.00 54.48           C  
ATOM   3303  O   GLN   244      26.501   2.507 -19.212  1.00 54.38           O  
ATOM   3305  N   TYR   245      25.935   0.320 -19.236  1.00 54.10           N  
ATOM   3306  CA  TYR   245      25.920   0.186 -20.716  1.00 54.12           C  
ATOM   3308  CB  TYR   245      26.567  -1.146 -21.151  1.00 54.49           C  
ATOM   3311  CG  TYR   245      28.040  -1.236 -20.849  1.00 54.61           C  
ATOM   3312  CD1 TYR   245      28.486  -1.430 -19.554  1.00 55.84           C  
ATOM   3314  CE1 TYR   245      29.847  -1.517 -19.266  1.00 55.77           C  
ATOM   3316  CZ  TYR   245      30.761  -1.404 -20.286  1.00 54.82           C  
ATOM   3317  OH  TYR   245      32.089  -1.478 -19.995  1.00 54.94           O  
ATOM   3319  CE2 TYR   245      30.343  -1.218 -21.577  1.00 54.29           C  
ATOM   3321  CD2 TYR   245      28.988  -1.130 -21.854  1.00 54.66           C  
ATOM   3323  C   TYR   245      24.516   0.291 -21.342  1.00 53.71           C  
ATOM   3324  O   TYR   245      24.296  -0.149 -22.481  1.00 53.29           O  
ATOM   3326  N   LEU   246      23.578   0.878 -20.601  1.00 53.40           N  
ATOM   3327  CA  LEU   246      22.199   1.002 -21.054  1.00 53.24           C  
ATOM   3329  CB  LEU   246      21.241   0.855 -19.871  1.00 53.21           C  
ATOM   3332  CG  LEU   246      21.203  -0.515 -19.200  1.00 53.10           C  
ATOM   3334  CD1 LEU   246      20.290  -0.456 -17.993  1.00 53.14           C  
ATOM   3338  CD2 LEU   246      20.745  -1.597 -20.174  1.00 52.85           C  
ATOM   3342  C   LEU   246      21.954   2.345 -21.733  1.00 53.02           C  
ATOM   3343  O   LEU   246      22.334   3.385 -21.203  1.00 53.17           O  
ATOM   3345  N   VAL   247      21.325   2.316 -22.905  1.00 52.75           N  
ATOM   3346  CA  VAL   247      20.835   3.529 -23.556  1.00 52.64           C  
ATOM   3348  CB  VAL   247      20.504   3.305 -25.060  1.00 52.48           C  
ATOM   3350  CG1 VAL   247      20.012   4.602 -25.707  1.00 51.79           C  
ATOM   3354  CG2 VAL   247      21.718   2.763 -25.805  1.00 51.72           C  
ATOM   3358  C   VAL   247      19.582   3.988 -22.824  1.00 52.69           C  
ATOM   3359  O   VAL   247      19.470   5.151 -22.450  1.00 52.53           O  
ATOM   3361  N   ASN   248      18.653   3.054 -22.614  1.00 52.95           N  
ATOM   3362  CA  ASN   248      17.380   3.327 -21.943  1.00 53.07           C  
ATOM   3364  CB  ASN   248      16.221   2.683 -22.705  1.00 52.87           C  
ATOM   3367  CG  ASN   248      16.213   3.055 -24.157  1.00 52.86           C  
ATOM   3368  OD1 ASN   248      16.370   2.205 -25.031  1.00 52.98           O  
ATOM   3369  ND2 ASN   248      16.063   4.337 -24.428  1.00 52.76           N  
ATOM   3372  C   ASN   248      17.395   2.785 -20.526  1.00 53.30           C  
ATOM   3373  O   ASN   248      17.261   1.581 -20.313  1.00 53.45           O  
ATOM   3375  N   LYS   249      17.546   3.671 -19.553  1.00 53.50           N  
ATOM   3376  CA  LYS   249      17.486   3.257 -18.174  1.00 53.78           C  
ATOM   3378  CB  LYS   249      18.838   3.483 -17.506  1.00 53.81           C  
ATOM   3381  CG  LYS   249      19.286   4.910 -17.381  1.00 53.26           C  
ATOM   3384  CD  LYS   249      20.677   4.989 -16.747  1.00 53.06           C  
ATOM   3387  CE  LYS   249      21.728   4.231 -17.544  1.00 51.57           C  
ATOM   3390  NZ  LYS   249      23.099   4.747 -17.263  1.00 51.40           N  
ATOM   3394  C   LYS   249      16.325   3.938 -17.445  1.00 54.25           C  
ATOM   3395  O   LYS   249      15.790   4.926 -17.934  1.00 54.38           O  
ATOM   3397  N   PRO   250      15.903   3.389 -16.292  1.00 54.93           N  
ATOM   3398  CA  PRO   250      14.710   3.896 -15.628  1.00 55.39           C  
ATOM   3400  CB  PRO   250      14.340   2.771 -14.646  1.00 55.38           C  
ATOM   3403  CG  PRO   250      15.314   1.658 -14.891  1.00 55.34           C  
ATOM   3406  CD  PRO   250      16.493   2.273 -15.536  1.00 55.02           C  
ATOM   3409  C   PRO   250      14.916   5.191 -14.849  1.00 55.94           C  
ATOM   3410  O   PRO   250      16.039   5.532 -14.479  1.00 55.99           O  
ATOM   3411  N   SER   251      13.808   5.890 -14.610  1.00 56.64           N  
ATOM   3412  CA  SER   251      13.763   7.063 -13.739  1.00 57.09           C  
ATOM   3414  CB  SER   251      12.305   7.498 -13.574  1.00 57.13           C  
ATOM   3417  OG  SER   251      12.186   8.606 -12.695  1.00 57.93           O  
ATOM   3419  C   SER   251      14.352   6.779 -12.359  1.00 57.48           C  
ATOM   3420  O   SER   251      14.189   5.686 -11.830  1.00 57.94           O  
ATOM   3422  N   GLU   252      15.036   7.766 -11.784  1.00 58.04           N  
ATOM   3423  CA  GLU   252      15.505   7.707 -10.389  1.00 58.42           C  
ATOM   3425  CB  GLU   252      16.104   9.062  -9.993  1.00 58.39           C  
ATOM   3428  CG  GLU   252      16.655   9.148  -8.576  1.00 58.57           C  
ATOM   3431  CD  GLU   252      17.597  10.336  -8.385  1.00 59.24           C  
ATOM   3432  OE1 GLU   252      17.141  11.507  -8.459  1.00 60.26           O  
ATOM   3433  OE2 GLU   252      18.801  10.090  -8.153  1.00 60.44           O  
ATOM   3434  C   GLU   252      14.349   7.340  -9.450  1.00 58.76           C  
ATOM   3435  O   GLU   252      14.495   6.528  -8.527  1.00 58.92           O  
ATOM   3437  N   GLU   253      13.202   7.958  -9.712  1.00 59.22           N  
ATOM   3438  CA  GLU   253      11.934   7.631  -9.074  1.00 59.22           C  
ATOM   3440  CB  GLU   253      10.820   8.402  -9.799  1.00 59.48           C  
ATOM   3443  CG  GLU   253       9.471   8.445  -9.104  1.00 60.20           C  
ATOM   3446  CD  GLU   253       8.398   7.628  -9.822  1.00 61.96           C  
ATOM   3447  OE1 GLU   253       7.359   8.232 -10.198  1.00 62.24           O  
ATOM   3448  OE2 GLU   253       8.596   6.396 -10.002  1.00 61.92           O  
ATOM   3449  C   GLU   253      11.674   6.114  -9.107  1.00 59.37           C  
ATOM   3450  O   GLU   253      11.444   5.484  -8.068  1.00 59.46           O  
ATOM   3452  N   ARG   254      11.745   5.535 -10.302  1.00 59.29           N  
ATOM   3453  CA  ARG   254      11.489   4.108 -10.494  1.00 59.22           C  
ATOM   3455  CB  ARG   254      11.464   3.774 -11.983  1.00 59.20           C  
ATOM   3458  CG  ARG   254      10.895   2.418 -12.292  1.00 59.46           C  
ATOM   3461  CD  ARG   254       9.506   2.282 -11.721  1.00 61.01           C  
ATOM   3464  NE  ARG   254       8.741   1.269 -12.440  1.00 62.03           N  
ATOM   3466  CZ  ARG   254       7.705   1.500 -13.248  1.00 62.31           C  
ATOM   3467  NH1 ARG   254       7.107   0.469 -13.838  1.00 62.85           N  
ATOM   3470  NH2 ARG   254       7.256   2.731 -13.479  1.00 62.51           N  
ATOM   3473  C   ARG   254      12.520   3.217  -9.811  1.00 59.18           C  
ATOM   3474  O   ARG   254      12.164   2.195  -9.226  1.00 59.04           O  
ATOM   3476  N   VAL   255      13.792   3.600  -9.912  1.00 59.13           N  
ATOM   3477  CA  VAL   255      14.890   2.866  -9.277  1.00 59.17           C  
ATOM   3479  CB  VAL   255      16.279   3.520  -9.568  1.00 59.30           C  
ATOM   3481  CG1 VAL   255      17.421   2.676  -8.996  1.00 58.64           C  
ATOM   3485  CG2 VAL   255      16.483   3.735 -11.064  1.00 59.57           C  
ATOM   3489  C   VAL   255      14.687   2.817  -7.766  1.00 59.13           C  
ATOM   3490  O   VAL   255      15.017   1.827  -7.122  1.00 59.04           O  
ATOM   3492  N   ARG   256      14.153   3.897  -7.207  1.00 59.19           N  
ATOM   3493  CA  ARG   256      13.852   3.953  -5.778  1.00 59.17           C  
ATOM   3495  CB  ARG   256      13.483   5.380  -5.380  1.00 59.25           C  
ATOM   3498  CG  ARG   256      14.683   6.270  -5.241  1.00 59.59           C  
ATOM   3501  CD  ARG   256      14.294   7.691  -4.940  1.00 60.05           C  
ATOM   3504  NE  ARG   256      15.437   8.431  -4.418  1.00 61.07           N  
ATOM   3506  CZ  ARG   256      15.564   9.755  -4.433  1.00 61.48           C  
ATOM   3507  NH1 ARG   256      14.617  10.534  -4.954  1.00 61.90           N  
ATOM   3510  NH2 ARG   256      16.661  10.307  -3.929  1.00 61.62           N  
ATOM   3513  C   ARG   256      12.731   2.999  -5.381  1.00 58.89           C  
ATOM   3514  O   ARG   256      12.797   2.376  -4.328  1.00 58.85           O  
ATOM   3516  N   GLU   257      11.706   2.892  -6.225  1.00 58.75           N  
ATOM   3517  CA  GLU   257      10.551   2.039  -5.936  1.00 58.54           C  
ATOM   3519  CB  GLU   257       9.445   2.200  -6.992  1.00 58.56           C  
ATOM   3522  CG  GLU   257       8.634   3.493  -6.868  1.00 59.13           C  
ATOM   3525  CD  GLU   257       7.672   3.719  -8.047  1.00 59.91           C  
ATOM   3526  OE1 GLU   257       7.678   2.897  -8.992  1.00 62.19           O  
ATOM   3527  OE2 GLU   257       6.914   4.727  -8.037  1.00 61.67           O  
ATOM   3528  C   GLU   257      10.970   0.587  -5.841  1.00 57.87           C  
ATOM   3529  O   GLU   257      10.562  -0.111  -4.935  1.00 57.95           O  
ATOM   3531  N   ILE   258      11.786   0.139  -6.783  1.00 57.38           N  
ATOM   3532  CA  ILE   258      12.298  -1.224  -6.761  1.00 57.33           C  
ATOM   3534  CB  ILE   258      13.171  -1.530  -8.012  1.00 57.34           C  
ATOM   3536  CG1 ILE   258      12.327  -1.480  -9.296  1.00 57.30           C  
ATOM   3539  CD1 ILE   258      13.137  -1.543 -10.574  1.00 56.86           C  
ATOM   3543  CG2 ILE   258      13.854  -2.887  -7.874  1.00 57.01           C  
ATOM   3547  C   ILE   258      13.135  -1.439  -5.496  1.00 57.16           C  
ATOM   3548  O   ILE   258      12.898  -2.379  -4.735  1.00 57.06           O  
ATOM   3550  N   ILE   259      14.095  -0.547  -5.266  1.00 56.84           N  
ATOM   3551  CA  ILE   259      15.028  -0.707  -4.162  1.00 56.95           C  
ATOM   3553  CB  ILE   259      16.227   0.239  -4.288  1.00 56.70           C  
ATOM   3555  CG1 ILE   259      17.115  -0.228  -5.451  1.00 57.43           C  
ATOM   3558  CD1 ILE   259      18.163   0.795  -5.906  1.00 57.24           C  
ATOM   3562  CG2 ILE   259      17.047   0.248  -3.005  1.00 56.44           C  
ATOM   3566  C   ILE   259      14.348  -0.568  -2.805  1.00 56.88           C  
ATOM   3567  O   ILE   259      14.377  -1.498  -2.005  1.00 57.15           O  
ATOM   3569  N   VAL   260      13.708   0.563  -2.551  1.00 56.94           N  
ATOM   3570  CA  VAL   260      13.105   0.800  -1.242  1.00 57.09           C  
ATOM   3572  CB  VAL   260      12.503   2.231  -1.146  1.00 56.86           C  
ATOM   3574  CG1 VAL   260      11.688   2.404   0.125  1.00 56.44           C  
ATOM   3578  CG2 VAL   260      13.620   3.263  -1.187  1.00 56.41           C  
ATOM   3582  C   VAL   260      12.071  -0.280  -0.862  1.00 57.36           C  
ATOM   3583  O   VAL   260      11.822  -0.514   0.318  1.00 57.18           O  
ATOM   3585  N   ASP   261      11.505  -0.957  -1.860  1.00 57.74           N  
ATOM   3586  CA  ASP   261      10.507  -2.004  -1.629  1.00 57.89           C  
ATOM   3588  CB  ASP   261       9.793  -2.342  -2.938  1.00 58.37           C  
ATOM   3591  CG  ASP   261       8.348  -2.758  -2.735  1.00 60.24           C  
ATOM   3592  OD1 ASP   261       8.053  -3.512  -1.767  1.00 62.32           O  
ATOM   3593  OD2 ASP   261       7.512  -2.322  -3.568  1.00 62.18           O  
ATOM   3594  C   ASP   261      11.165  -3.254  -1.067  1.00 57.71           C  
ATOM   3595  O   ASP   261      10.631  -3.912  -0.171  1.00 57.64           O  
ATOM   3597  N   ALA   262      12.327  -3.582  -1.615  1.00 57.72           N  
ATOM   3598  CA  ALA   262      13.156  -4.657  -1.078  1.00 57.46           C  
ATOM   3600  CB  ALA   262      14.367  -4.877  -1.957  1.00 57.43           C  
ATOM   3604  C   ALA   262      13.580  -4.325   0.352  1.00 57.32           C  
ATOM   3605  O   ALA   262      13.588  -5.202   1.213  1.00 57.45           O  
ATOM   3607  N   VAL   263      13.905  -3.058   0.611  1.00 57.02           N  
ATOM   3608  CA  VAL   263      14.306  -2.637   1.956  1.00 56.81           C  
ATOM   3610  CB  VAL   263      14.752  -1.160   2.001  1.00 56.76           C  
ATOM   3612  CG1 VAL   263      15.307  -0.818   3.379  1.00 56.70           C  
ATOM   3616  CG2 VAL   263      15.797  -0.888   0.936  1.00 56.54           C  
ATOM   3620  C   VAL   263      13.168  -2.884   2.953  1.00 56.55           C  
ATOM   3621  O   VAL   263      13.390  -3.439   4.029  1.00 56.43           O  
ATOM   3623  N   LYS   264      11.956  -2.483   2.572  1.00 56.35           N  
ATOM   3624  CA  LYS   264      10.741  -2.819   3.315  1.00 56.25           C  
ATOM   3626  CB  LYS   264       9.485  -2.476   2.499  1.00 56.38           C  
ATOM   3629  CG  LYS   264       8.701  -1.251   2.974  1.00 56.81           C  
ATOM   3632  CD  LYS   264       9.297   0.072   2.501  1.00 57.36           C  
ATOM   3635  CE  LYS   264       8.272   1.207   2.619  1.00 57.77           C  
ATOM   3638  NZ  LYS   264       8.827   2.551   2.287  1.00 57.87           N  
ATOM   3642  C   LYS   264      10.706  -4.302   3.689  1.00 56.13           C  
ATOM   3643  O   LYS   264      10.553  -4.637   4.857  1.00 55.98           O  
ATOM   3645  N   ILE   265      10.876  -5.175   2.696  1.00 55.99           N  
ATOM   3646  CA  ILE   265      10.757  -6.627   2.888  1.00 55.99           C  
ATOM   3648  CB  ILE   265      10.756  -7.376   1.531  1.00 55.81           C  
ATOM   3650  CG1 ILE   265       9.527  -6.985   0.699  1.00 55.67           C  
ATOM   3653  CD1 ILE   265       9.662  -7.233  -0.799  1.00 55.21           C  
ATOM   3657  CG2 ILE   265      10.779  -8.883   1.735  1.00 55.62           C  
ATOM   3661  C   ILE   265      11.861  -7.189   3.792  1.00 56.24           C  
ATOM   3662  O   ILE   265      11.594  -7.992   4.691  1.00 55.92           O  
ATOM   3664  N   GLU   266      13.097  -6.756   3.559  1.00 57.12           N  
ATOM   3665  CA  GLU   266      14.248  -7.268   4.310  1.00 57.21           C  
ATOM   3667  CB  GLU   266      15.569  -6.859   3.627  1.00 57.58           C  
ATOM   3670  CG  GLU   266      16.871  -7.445   4.254  1.00 58.20           C  
ATOM   3673  CD  GLU   266      17.173  -8.910   3.876  1.00 60.09           C  
ATOM   3674  OE1 GLU   266      16.513  -9.448   2.955  1.00 61.00           O  
ATOM   3675  OE2 GLU   266      18.079  -9.522   4.505  1.00 59.51           O  
ATOM   3676  C   GLU   266      14.190  -6.803   5.776  1.00 57.22           C  
ATOM   3677  O   GLU   266      14.438  -7.593   6.678  1.00 57.27           O  
ATOM   3679  N   GLN   267      13.838  -5.537   5.997  1.00 57.22           N  
ATOM   3680  CA  GLN   267      13.734  -4.957   7.353  1.00 57.28           C  
ATOM   3682  CB  GLN   267      13.417  -3.460   7.275  1.00 57.20           C  
ATOM   3685  CG  GLN   267      14.613  -2.608   6.906  1.00 57.38           C  
ATOM   3688  CD  GLN   267      14.270  -1.148   6.763  1.00 57.42           C  
ATOM   3689  OE1 GLN   267      13.097  -0.782   6.627  1.00 58.83           O  
ATOM   3690  NE2 GLN   267      15.291  -0.296   6.796  1.00 56.43           N  
ATOM   3693  C   GLN   267      12.668  -5.627   8.201  1.00 57.14           C  
ATOM   3694  O   GLN   267      12.849  -5.856   9.386  1.00 57.06           O  
ATOM   3696  N   GLU   268      11.538  -5.898   7.576  1.00 57.29           N  
ATOM   3697  CA  GLU   268      10.429  -6.571   8.221  1.00 57.27           C  
ATOM   3699  CB  GLU   268       9.291  -6.712   7.214  1.00 57.16           C  
ATOM   3702  CG  GLU   268       8.084  -7.489   7.697  1.00 58.04           C  
ATOM   3705  CD  GLU   268       6.911  -7.322   6.749  1.00 59.31           C  
ATOM   3706  OE1 GLU   268       7.170  -6.897   5.590  1.00 62.33           O  
ATOM   3707  OE2 GLU   268       5.747  -7.595   7.156  1.00 61.57           O  
ATOM   3708  C   GLU   268      10.851  -7.938   8.720  1.00 56.84           C  
ATOM   3709  O   GLU   268      10.553  -8.314   9.844  1.00 56.73           O  
ATOM   3711  N   PHE   269      11.542  -8.682   7.865  1.00 56.46           N  
ATOM   3712  CA  PHE   269      11.978 -10.027   8.202  1.00 56.38           C  
ATOM   3714  CB  PHE   269      12.722 -10.618   7.007  1.00 55.77           C  
ATOM   3717  CG  PHE   269      13.302 -11.969   7.260  1.00 55.76           C  
ATOM   3718  CD1 PHE   269      12.524 -12.988   7.807  1.00 55.30           C  
ATOM   3720  CE1 PHE   269      13.069 -14.241   8.043  1.00 55.48           C  
ATOM   3722  CZ  PHE   269      14.403 -14.479   7.725  1.00 55.28           C  
ATOM   3724  CE2 PHE   269      15.176 -13.465   7.177  1.00 54.28           C  
ATOM   3726  CD2 PHE   269      14.626 -12.232   6.946  1.00 54.24           C  
ATOM   3728  C   PHE   269      12.865 -10.050   9.454  1.00 56.35           C  
ATOM   3729  O   PHE   269      12.565 -10.722  10.433  1.00 56.01           O  
ATOM   3731  N   LEU   270      13.945  -9.283   9.415  1.00 56.64           N  
ATOM   3732  CA  LEU   270      14.969  -9.350  10.442  1.00 56.77           C  
ATOM   3734  CB  LEU   270      16.327  -8.934   9.855  1.00 57.26           C  
ATOM   3737  CG  LEU   270      17.059 -10.037   9.077  1.00 58.15           C  
ATOM   3739  CD1 LEU   270      18.191  -9.455   8.236  1.00 59.02           C  
ATOM   3743  CD2 LEU   270      17.601 -11.112  10.016  1.00 58.66           C  
ATOM   3747  C   LEU   270      14.651  -8.530  11.691  1.00 56.63           C  
ATOM   3748  O   LEU   270      15.396  -8.600  12.671  1.00 56.76           O  
ATOM   3750  N   THR   271      13.564  -7.760  11.667  1.00 56.49           N  
ATOM   3751  CA  THR   271      13.119  -7.023  12.866  1.00 56.29           C  
ATOM   3753  CB  THR   271      13.157  -5.479  12.674  1.00 55.87           C  
ATOM   3755  OG1 THR   271      12.118  -5.064  11.788  1.00 54.95           O  
ATOM   3757  CG2 THR   271      14.508  -5.029  12.131  1.00 55.46           C  
ATOM   3761  C   THR   271      11.739  -7.453  13.382  1.00 56.43           C  
ATOM   3762  O   THR   271      11.530  -7.477  14.581  1.00 56.78           O  
ATOM   3764  N   GLU   272      10.811  -7.812  12.499  1.00 56.66           N  
ATOM   3765  CA  GLU   272       9.477  -8.252  12.928  1.00 56.80           C  
ATOM   3767  CB  GLU   272       8.377  -7.760  11.974  1.00 56.88           C  
ATOM   3770  CG  GLU   272       8.244  -6.233  11.862  1.00 58.43           C  
ATOM   3773  CD  GLU   272       7.006  -5.778  11.049  1.00 59.45           C  
ATOM   3774  OE1 GLU   272       6.229  -6.641  10.562  1.00 63.13           O  
ATOM   3775  OE2 GLU   272       6.804  -4.546  10.899  1.00 63.73           O  
ATOM   3776  C   GLU   272       9.381  -9.767  13.046  1.00 56.30           C  
ATOM   3777  O   GLU   272       8.991 -10.270  14.090  1.00 56.57           O  
ATOM   3779  N   ALA   273       9.729 -10.483  11.978  1.00 55.73           N  
ATOM   3780  CA  ALA   273       9.447 -11.919  11.862  1.00 55.36           C  
ATOM   3782  CB  ALA   273       9.347 -12.301  10.406  1.00 54.82           C  
ATOM   3786  C   ALA   273      10.483 -12.808  12.555  1.00 55.26           C  
ATOM   3787  O   ALA   273      10.137 -13.723  13.290  1.00 55.34           O  
ATOM   3789  N   LEU   274      11.754 -12.559  12.278  1.00 55.23           N  
ATOM   3790  CA  LEU   274      12.844 -13.325  12.845  1.00 54.94           C  
ATOM   3792  CB  LEU   274      13.482 -14.221  11.780  1.00 54.86           C  
ATOM   3795  CG  LEU   274      14.523 -15.223  12.288  1.00 54.95           C  
ATOM   3797  CD1 LEU   274      13.909 -16.247  13.252  1.00 54.31           C  
ATOM   3801  CD2 LEU   274      15.173 -15.922  11.123  1.00 54.64           C  
ATOM   3805  C   LEU   274      13.813 -12.286  13.383  1.00 54.88           C  
ATOM   3806  O   LEU   274      14.856 -12.013  12.783  1.00 54.82           O  
ATOM   3808  N   PRO   275      13.468 -11.691  14.530  1.00 54.91           N  
ATOM   3809  CA  PRO   275      14.207 -10.520  14.993  1.00 54.76           C  
ATOM   3811  CB  PRO   275      13.355  -9.998  16.154  1.00 54.80           C  
ATOM   3814  CG  PRO   275      12.071 -10.776  16.102  1.00 55.12           C  
ATOM   3817  CD  PRO   275      12.411 -12.071  15.478  1.00 54.82           C  
ATOM   3820  C   PRO   275      15.622 -10.842  15.466  1.00 54.53           C  
ATOM   3821  O   PRO   275      15.846 -11.843  16.139  1.00 53.93           O  
ATOM   3822  N   VAL   276      16.556  -9.968  15.111  1.00 54.65           N  
ATOM   3823  CA  VAL   276      17.970 -10.123  15.468  1.00 54.83           C  
ATOM   3825  CB  VAL   276      18.853  -9.140  14.660  1.00 54.83           C  
ATOM   3827  CG1 VAL   276      18.700  -9.406  13.150  1.00 54.42           C  
ATOM   3831  CG2 VAL   276      18.517  -7.681  15.018  1.00 54.16           C  
ATOM   3835  C   VAL   276      18.236  -9.975  16.987  1.00 54.93           C  
ATOM   3836  O   VAL   276      19.311 -10.334  17.480  1.00 54.81           O  
ATOM   3838  N   GLY   277      17.253  -9.456  17.719  1.00 54.96           N  
ATOM   3839  CA  GLY   277      17.229  -9.589  19.165  1.00 55.10           C  
ATOM   3842  C   GLY   277      17.508 -11.028  19.584  1.00 55.32           C  
ATOM   3843  O   GLY   277      18.227 -11.259  20.551  1.00 55.60           O  
ATOM   3845  N   LEU   278      16.968 -12.001  18.847  1.00 55.18           N  
ATOM   3846  CA  LEU   278      17.210 -13.414  19.162  1.00 55.19           C  
ATOM   3848  CB  LEU   278      16.535 -14.358  18.149  1.00 54.98           C  
ATOM   3851  CG  LEU   278      15.007 -14.470  18.155  1.00 54.41           C  
ATOM   3853  CD1 LEU   278      14.575 -15.432  17.065  1.00 53.51           C  
ATOM   3857  CD2 LEU   278      14.456 -14.908  19.497  1.00 52.65           C  
ATOM   3861  C   LEU   278      18.698 -13.771  19.282  1.00 55.16           C  
ATOM   3862  O   LEU   278      19.030 -14.717  19.991  1.00 54.86           O  
ATOM   3864  N   ILE   279      19.580 -13.037  18.597  1.00 55.43           N  
ATOM   3865  CA  ILE   279      21.028 -13.234  18.761  1.00 55.86           C  
ATOM   3867  CB  ILE   279      21.721 -13.732  17.456  1.00 55.70           C  
ATOM   3869  CG1 ILE   279      21.539 -12.733  16.313  1.00 56.20           C  
ATOM   3872  CD1 ILE   279      22.802 -12.554  15.446  1.00 56.30           C  
ATOM   3876  CG2 ILE   279      21.211 -15.107  17.065  1.00 55.53           C  
ATOM   3880  C   ILE   279      21.766 -11.994  19.299  1.00 56.15           C  
ATOM   3881  O   ILE   279      22.925 -11.751  18.940  1.00 56.69           O  
ATOM   3883  N   GLY   280      21.102 -11.214  20.147  1.00 56.14           N  
ATOM   3884  CA  GLY   280      21.764 -10.116  20.849  1.00 56.49           C  
ATOM   3887  C   GLY   280      22.112  -8.862  20.056  1.00 56.85           C  
ATOM   3888  O   GLY   280      22.867  -8.024  20.550  1.00 57.21           O  
ATOM   3890  N   MET   281      21.561  -8.719  18.849  1.00 57.05           N  
ATOM   3891  CA  MET   281      21.709  -7.498  18.055  1.00 57.30           C  
ATOM   3893  CB  MET   281      21.817  -7.829  16.569  1.00 57.30           C  
ATOM   3896  CG  MET   281      23.200  -8.297  16.122  1.00 58.46           C  
ATOM   3899  SD  MET   281      23.364  -8.586  14.331  1.00 58.92           S  
ATOM   3900  CE  MET   281      22.411  -7.209  13.690  1.00 58.58           C  
ATOM   3904  C   MET   281      20.534  -6.543  18.262  1.00 57.14           C  
ATOM   3905  O   MET   281      19.468  -6.953  18.706  1.00 56.73           O  
ATOM   3907  N   ASN   282      20.750  -5.273  17.913  1.00 57.45           N  
ATOM   3908  CA  ASN   282      19.739  -4.222  18.012  1.00 57.65           C  
ATOM   3910  CB  ASN   282      20.393  -2.882  18.357  1.00 57.63           C  
ATOM   3913  CG  ASN   282      19.392  -1.855  18.868  1.00 57.73           C  
ATOM   3914  OD1 ASN   282      18.537  -1.368  18.125  1.00 57.98           O  
ATOM   3915  ND2 ASN   282      19.500  -1.521  20.149  1.00 58.09           N  
ATOM   3918  C   ASN   282      18.990  -4.063  16.704  1.00 57.89           C  
ATOM   3919  O   ASN   282      19.600  -3.880  15.664  1.00 58.05           O  
ATOM   3921  N   CYS   283      17.666  -4.104  16.767  1.00 58.25           N  
ATOM   3922  CA  CYS   283      16.821  -3.979  15.580  1.00 58.47           C  
ATOM   3924  CB  CYS   283      15.363  -4.173  15.968  1.00 58.67           C  
ATOM   3927  SG  CYS   283      14.967  -5.912  16.143  1.00 61.78           S  
ATOM   3929  C   CYS   283      16.965  -2.649  14.860  1.00 58.38           C  
ATOM   3930  O   CYS   283      17.138  -2.620  13.644  1.00 58.75           O  
ATOM   3932  N   ILE   284      16.878  -1.556  15.609  1.00 58.05           N  
ATOM   3933  CA  ILE   284      17.025  -0.233  15.034  1.00 58.02           C  
ATOM   3935  CB  ILE   284      17.018   0.863  16.127  1.00 58.04           C  
ATOM   3937  CG1 ILE   284      15.622   0.964  16.762  1.00 57.74           C  
ATOM   3940  CD1 ILE   284      15.626   1.350  18.232  1.00 57.72           C  
ATOM   3944  CG2 ILE   284      17.437   2.208  15.541  1.00 57.73           C  
ATOM   3948  C   ILE   284      18.311  -0.178  14.201  1.00 58.03           C  
ATOM   3949  O   ILE   284      18.271   0.102  13.001  1.00 57.92           O  
ATOM   3951  N   LEU   285      19.444  -0.491  14.819  1.00 58.02           N  
ATOM   3952  CA  LEU   285      20.714  -0.512  14.084  1.00 58.00           C  
ATOM   3954  CB  LEU   285      21.879  -0.917  14.998  1.00 57.80           C  
ATOM   3957  CG  LEU   285      22.212   0.081  16.114  1.00 57.31           C  
ATOM   3959  CD1 LEU   285      23.510  -0.307  16.803  1.00 57.13           C  
ATOM   3963  CD2 LEU   285      22.310   1.502  15.590  1.00 55.84           C  
ATOM   3967  C   LEU   285      20.693  -1.395  12.824  1.00 57.94           C  
ATOM   3968  O   LEU   285      21.325  -1.052  11.835  1.00 57.85           O  
ATOM   3970  N   MET   286      19.969  -2.510  12.841  1.00 58.05           N  
ATOM   3971  CA  MET   286      19.913  -3.364  11.655  1.00 58.27           C  
ATOM   3973  CB  MET   286      19.358  -4.756  11.966  1.00 58.27           C  
ATOM   3976  CG  MET   286      19.343  -5.719  10.748  1.00 58.14           C  
ATOM   3979  SD  MET   286      20.972  -6.104  10.045  1.00 58.21           S  
ATOM   3980  CE  MET   286      21.405  -7.639  10.868  1.00 58.24           C  
ATOM   3984  C   MET   286      19.110  -2.705  10.530  1.00 58.52           C  
ATOM   3985  O   MET   286      19.556  -2.708   9.384  1.00 58.75           O  
ATOM   3987  N   LYS   287      17.943  -2.141  10.846  1.00 58.52           N  
ATOM   3988  CA  LYS   287      17.179  -1.363   9.861  1.00 58.58           C  
ATOM   3990  CB  LYS   287      15.980  -0.674  10.512  1.00 58.67           C  
ATOM   3993  CG  LYS   287      14.816  -1.587  10.841  1.00 59.14           C  
ATOM   3996  CD  LYS   287      13.616  -0.780  11.358  1.00 59.22           C  
ATOM   3999  CE  LYS   287      12.446  -1.690  11.757  1.00 60.02           C  
ATOM   4002  NZ  LYS   287      11.329  -0.940  12.421  1.00 60.55           N  
ATOM   4006  C   LYS   287      18.048  -0.296   9.194  1.00 58.39           C  
ATOM   4007  O   LYS   287      17.923  -0.036   8.011  1.00 58.47           O  
ATOM   4009  N   GLN   288      18.922   0.317   9.976  1.00 58.33           N  
ATOM   4010  CA  GLN   288      19.795   1.377   9.495  1.00 58.34           C  
ATOM   4012  CB  GLN   288      20.451   2.063  10.696  1.00 58.31           C  
ATOM   4015  CG  GLN   288      21.146   3.369  10.402  1.00 58.32           C  
ATOM   4018  CD  GLN   288      21.872   3.904  11.619  1.00 58.43           C  
ATOM   4019  OE1 GLN   288      21.253   4.414  12.549  1.00 57.53           O  
ATOM   4020  NE2 GLN   288      23.194   3.784  11.619  1.00 59.13           N  
ATOM   4023  C   GLN   288      20.857   0.805   8.556  1.00 58.37           C  
ATOM   4024  O   GLN   288      21.164   1.385   7.504  1.00 58.44           O  
ATOM   4026  N   TYR   289      21.417  -0.338   8.936  1.00 58.31           N  
ATOM   4027  CA  TYR   289      22.389  -1.014   8.089  1.00 58.10           C  
ATOM   4029  CB  TYR   289      22.904  -2.302   8.747  1.00 58.22           C  
ATOM   4032  CG  TYR   289      23.820  -3.085   7.845  1.00 58.46           C  
ATOM   4033  CD1 TYR   289      25.141  -2.702   7.658  1.00 59.29           C  
ATOM   4035  CE1 TYR   289      25.985  -3.421   6.805  1.00 58.77           C  
ATOM   4037  CZ  TYR   289      25.492  -4.517   6.135  1.00 58.61           C  
ATOM   4038  OH  TYR   289      26.301  -5.237   5.280  1.00 59.19           O  
ATOM   4040  CE2 TYR   289      24.183  -4.900   6.308  1.00 58.24           C  
ATOM   4042  CD2 TYR   289      23.360  -4.190   7.151  1.00 58.22           C  
ATOM   4044  C   TYR   289      21.774  -1.310   6.720  1.00 57.92           C  
ATOM   4045  O   TYR   289      22.367  -0.976   5.704  1.00 57.96           O  
ATOM   4047  N   ILE   290      20.577  -1.904   6.703  1.00 57.62           N  
ATOM   4048  CA  ILE   290      19.894  -2.263   5.451  1.00 57.52           C  
ATOM   4050  CB  ILE   290      18.442  -2.831   5.678  1.00 57.55           C  
ATOM   4052  CG1 ILE   290      18.409  -4.044   6.628  1.00 57.19           C  
ATOM   4055  CD1 ILE   290      19.018  -5.266   6.083  1.00 56.48           C  
ATOM   4059  CG2 ILE   290      17.787  -3.208   4.348  1.00 57.30           C  
ATOM   4063  C   ILE   290      19.794  -1.018   4.554  1.00 57.46           C  
ATOM   4064  O   ILE   290      19.887  -1.111   3.322  1.00 57.47           O  
ATOM   4066  N   GLU   291      19.614   0.141   5.178  1.00 57.14           N  
ATOM   4067  CA  GLU   291      19.454   1.389   4.445  1.00 57.23           C  
ATOM   4069  CB  GLU   291      18.720   2.411   5.305  1.00 57.10           C  
ATOM   4072  CG  GLU   291      17.287   2.016   5.497  1.00 57.42           C  
ATOM   4075  CD  GLU   291      16.509   2.940   6.396  1.00 57.79           C  
ATOM   4076  OE1 GLU   291      16.990   4.050   6.704  1.00 59.19           O  
ATOM   4077  OE2 GLU   291      15.390   2.550   6.788  1.00 58.99           O  
ATOM   4078  C   GLU   291      20.780   1.939   3.937  1.00 57.04           C  
ATOM   4079  O   GLU   291      20.855   2.443   2.808  1.00 56.71           O  
ATOM   4081  N   PHE   292      21.819   1.841   4.762  1.00 56.97           N  
ATOM   4082  CA  PHE   292      23.176   2.151   4.313  1.00 57.07           C  
ATOM   4084  CB  PHE   292      24.187   1.874   5.426  1.00 56.82           C  
ATOM   4087  CG  PHE   292      25.596   1.758   4.941  1.00 56.84           C  
ATOM   4088  CD1 PHE   292      26.405   2.879   4.845  1.00 57.10           C  
ATOM   4090  CE1 PHE   292      27.716   2.776   4.395  1.00 56.65           C  
ATOM   4092  CZ  PHE   292      28.224   1.542   4.029  1.00 56.93           C  
ATOM   4094  CE2 PHE   292      27.418   0.413   4.109  1.00 56.87           C  
ATOM   4096  CD2 PHE   292      26.114   0.527   4.569  1.00 56.84           C  
ATOM   4098  C   PHE   292      23.513   1.336   3.056  1.00 57.12           C  
ATOM   4099  O   PHE   292      23.958   1.884   2.042  1.00 57.18           O  
ATOM   4101  N   VAL   293      23.281   0.028   3.135  1.00 57.27           N  
ATOM   4102  CA  VAL   293      23.500  -0.885   2.010  1.00 57.60           C  
ATOM   4104  CB  VAL   293      23.148  -2.341   2.404  1.00 57.56           C  
ATOM   4106  CG1 VAL   293      22.751  -3.156   1.188  1.00 57.17           C  
ATOM   4110  CG2 VAL   293      24.309  -2.982   3.152  1.00 57.33           C  
ATOM   4114  C   VAL   293      22.707  -0.487   0.758  1.00 57.84           C  
ATOM   4115  O   VAL   293      23.235  -0.530  -0.352  1.00 57.80           O  
ATOM   4117  N   ALA   294      21.447  -0.106   0.950  1.00 58.19           N  
ATOM   4118  CA  ALA   294      20.589   0.333  -0.151  1.00 58.48           C  
ATOM   4120  CB  ALA   294      19.142   0.385   0.302  1.00 58.22           C  
ATOM   4124  C   ALA   294      21.023   1.692  -0.722  1.00 58.78           C  
ATOM   4125  O   ALA   294      20.942   1.901  -1.930  1.00 58.68           O  
ATOM   4127  N   ASP   295      21.470   2.607   0.140  1.00 59.14           N  
ATOM   4128  CA  ASP   295      22.043   3.888  -0.314  1.00 59.60           C  
ATOM   4130  CB  ASP   295      22.439   4.784   0.872  1.00 59.60           C  
ATOM   4133  CG  ASP   295      21.297   5.659   1.382  1.00 59.80           C  
ATOM   4134  OD1 ASP   295      20.168   5.604   0.837  1.00 59.69           O  
ATOM   4135  OD2 ASP   295      21.547   6.424   2.344  1.00 60.06           O  
ATOM   4136  C   ASP   295      23.289   3.653  -1.166  1.00 60.03           C  
ATOM   4137  O   ASP   295      23.487   4.290  -2.203  1.00 60.28           O  
ATOM   4139  N   ARG   296      24.143   2.746  -0.714  1.00 60.34           N  
ATOM   4140  CA  ARG   296      25.363   2.429  -1.449  1.00 60.47           C  
ATOM   4142  CB  ARG   296      26.145   1.329  -0.716  1.00 60.73           C  
ATOM   4145  CG  ARG   296      27.610   1.218  -1.130  1.00 61.10           C  
ATOM   4148  CD  ARG   296      28.354   0.282  -0.210  1.00 61.87           C  
ATOM   4151  NE  ARG   296      27.713  -1.031  -0.206  1.00 64.16           N  
ATOM   4153  CZ  ARG   296      27.876  -1.958   0.737  1.00 64.49           C  
ATOM   4154  NH1 ARG   296      28.670  -1.732   1.782  1.00 65.49           N  
ATOM   4157  NH2 ARG   296      27.231  -3.116   0.637  1.00 63.83           N  
ATOM   4160  C   ARG   296      25.045   1.974  -2.878  1.00 60.32           C  
ATOM   4161  O   ARG   296      25.703   2.393  -3.832  1.00 60.38           O  
ATOM   4163  N   LEU   297      24.035   1.112  -2.999  1.00 60.03           N  
ATOM   4164  CA  LEU   297      23.612   0.548  -4.274  1.00 59.77           C  
ATOM   4166  CB  LEU   297      22.557  -0.531  -4.043  1.00 59.54           C  
ATOM   4169  CG  LEU   297      21.990  -1.243  -5.275  1.00 59.66           C  
ATOM   4171  CD1 LEU   297      23.092  -1.920  -6.069  1.00 59.23           C  
ATOM   4175  CD2 LEU   297      20.919  -2.258  -4.863  1.00 59.84           C  
ATOM   4179  C   LEU   297      23.045   1.610  -5.203  1.00 59.62           C  
ATOM   4180  O   LEU   297      23.324   1.594  -6.402  1.00 59.53           O  
ATOM   4182  N   LEU   298      22.231   2.511  -4.655  1.00 59.52           N  
ATOM   4183  CA  LEU   298      21.669   3.599  -5.444  1.00 59.60           C  
ATOM   4185  CB  LEU   298      20.757   4.505  -4.596  1.00 59.44           C  
ATOM   4188  CG  LEU   298      19.386   3.953  -4.194  1.00 58.95           C  
ATOM   4190  CD1 LEU   298      18.775   4.794  -3.092  1.00 58.75           C  
ATOM   4194  CD2 LEU   298      18.454   3.890  -5.386  1.00 58.38           C  
ATOM   4198  C   LEU   298      22.819   4.403  -6.042  1.00 59.63           C  
ATOM   4199  O   LEU   298      22.816   4.711  -7.231  1.00 59.58           O  
ATOM   4201  N   VAL   299      23.817   4.701  -5.215  1.00 59.76           N  
ATOM   4202  CA  VAL   299      24.978   5.465  -5.656  1.00 59.99           C  
ATOM   4204  CB  VAL   299      25.853   5.923  -4.464  1.00 59.90           C  
ATOM   4206  CG1 VAL   299      27.099   6.621  -4.948  1.00 59.50           C  
ATOM   4210  CG2 VAL   299      25.064   6.855  -3.561  1.00 59.72           C  
ATOM   4214  C   VAL   299      25.806   4.690  -6.673  1.00 60.07           C  
ATOM   4215  O   VAL   299      26.356   5.281  -7.578  1.00 60.27           O  
ATOM   4217  N   GLU   300      25.881   3.374  -6.548  1.00 60.59           N  
ATOM   4218  CA  GLU   300      26.546   2.561  -7.573  1.00 61.05           C  
ATOM   4220  CB  GLU   300      26.667   1.108  -7.124  1.00 61.66           C  
ATOM   4223  CG  GLU   300      27.950   0.804  -6.350  1.00 64.26           C  
ATOM   4226  CD  GLU   300      28.978   0.018  -7.185  1.00 68.55           C  
ATOM   4227  OE1 GLU   300      30.014   0.637  -7.549  1.00 70.50           O  
ATOM   4228  OE2 GLU   300      28.748  -1.205  -7.473  1.00 69.39           O  
ATOM   4229  C   GLU   300      25.836   2.629  -8.925  1.00 60.94           C  
ATOM   4230  O   GLU   300      26.481   2.581  -9.970  1.00 61.14           O  
ATOM   4232  N   LEU   301      24.515   2.750  -8.908  1.00 60.64           N  
ATOM   4233  CA  LEU   301      23.752   2.891 -10.146  1.00 60.45           C  
ATOM   4235  CB  LEU   301      22.326   2.366  -9.949  1.00 60.30           C  
ATOM   4238  CG  LEU   301      22.249   0.869  -9.597  1.00 59.85           C  
ATOM   4240  CD1 LEU   301      20.890   0.478  -9.035  1.00 57.83           C  
ATOM   4244  CD2 LEU   301      22.594   0.019 -10.817  1.00 59.15           C  
ATOM   4248  C   LEU   301      23.755   4.346 -10.648  1.00 60.53           C  
ATOM   4249  O   LEU   301      23.133   4.667 -11.665  1.00 60.97           O  
ATOM   4251  N   GLY   302      24.461   5.222  -9.936  1.00 60.27           N  
ATOM   4252  CA  GLY   302      24.662   6.596 -10.361  1.00 59.91           C  
ATOM   4255  C   GLY   302      23.588   7.553  -9.902  1.00 59.73           C  
ATOM   4256  O   GLY   302      23.454   8.630 -10.468  1.00 59.91           O  
ATOM   4258  N   PHE   303      22.829   7.172  -8.878  1.00 59.58           N  
ATOM   4259  CA  PHE   303      21.781   8.028  -8.317  1.00 59.60           C  
ATOM   4261  CB  PHE   303      20.460   7.269  -8.248  1.00 59.26           C  
ATOM   4264  CG  PHE   303      19.997   6.735  -9.566  1.00 59.14           C  
ATOM   4265  CD1 PHE   303      19.195   7.495 -10.395  1.00 59.07           C  
ATOM   4267  CE1 PHE   303      18.758   7.001 -11.618  1.00 58.66           C  
ATOM   4269  CZ  PHE   303      19.117   5.746 -12.016  1.00 58.59           C  
ATOM   4271  CE2 PHE   303      19.919   4.970 -11.198  1.00 59.13           C  
ATOM   4273  CD2 PHE   303      20.353   5.465  -9.976  1.00 59.14           C  
ATOM   4275  C   PHE   303      22.169   8.522  -6.921  1.00 59.69           C  
ATOM   4276  O   PHE   303      23.128   8.034  -6.327  1.00 59.75           O  
ATOM   4278  N   SER   304      21.420   9.489  -6.395  1.00 59.89           N  
ATOM   4279  CA  SER   304      21.678  10.009  -5.047  1.00 60.02           C  
ATOM   4281  CB  SER   304      21.218  11.463  -4.921  1.00 59.91           C  
ATOM   4284  OG  SER   304      19.811  11.550  -5.030  1.00 60.00           O  
ATOM   4286  C   SER   304      21.011   9.150  -3.966  1.00 60.10           C  
ATOM   4287  O   SER   304      20.170   8.291  -4.245  1.00 60.08           O  
ATOM   4289  N   LYS   305      21.401   9.404  -2.726  1.00 60.25           N  
ATOM   4290  CA  LYS   305      20.903   8.651  -1.583  1.00 60.29           C  
ATOM   4292  CB  LYS   305      21.780   8.922  -0.354  1.00 60.13           C  
ATOM   4295  CG  LYS   305      23.203   8.402  -0.535  1.00 60.08           C  
ATOM   4298  CD  LYS   305      24.135   8.855   0.557  1.00 59.90           C  
ATOM   4301  CE  LYS   305      25.507   8.265   0.352  1.00 59.64           C  
ATOM   4304  NZ  LYS   305      26.526   9.045   1.079  1.00 59.57           N  
ATOM   4308  C   LYS   305      19.453   8.998  -1.286  1.00 60.47           C  
ATOM   4309  O   LYS   305      18.958  10.048  -1.696  1.00 60.36           O  
ATOM   4311  N   VAL   306      18.779   8.094  -0.584  1.00 60.72           N  
ATOM   4312  CA  VAL   306      17.401   8.308  -0.150  1.00 60.88           C  
ATOM   4314  CB  VAL   306      16.466   7.184  -0.664  1.00 60.80           C  
ATOM   4316  CG1 VAL   306      16.941   5.829  -0.192  1.00 61.26           C  
ATOM   4320  CG2 VAL   306      15.045   7.423  -0.223  1.00 60.70           C  
ATOM   4324  C   VAL   306      17.334   8.421   1.375  1.00 61.11           C  
ATOM   4325  O   VAL   306      16.730   9.363   1.902  1.00 61.41           O  
ATOM   4327  N   PHE   307      17.987   7.490   2.075  1.00 61.32           N  
ATOM   4328  CA  PHE   307      17.884   7.379   3.536  1.00 61.37           C  
ATOM   4330  CB  PHE   307      17.999   5.916   3.976  1.00 61.61           C  
ATOM   4333  CG  PHE   307      17.017   4.994   3.307  1.00 61.81           C  
ATOM   4334  CD1 PHE   307      15.664   5.076   3.594  1.00 61.46           C  
ATOM   4336  CE1 PHE   307      14.752   4.227   2.987  1.00 61.37           C  
ATOM   4338  CZ  PHE   307      15.182   3.277   2.089  1.00 62.03           C  
ATOM   4340  CE2 PHE   307      16.541   3.172   1.791  1.00 62.53           C  
ATOM   4342  CD2 PHE   307      17.451   4.029   2.405  1.00 62.34           C  
ATOM   4344  C   PHE   307      18.930   8.178   4.305  1.00 61.31           C  
ATOM   4345  O   PHE   307      18.702   8.522   5.458  1.00 61.25           O  
ATOM   4347  N   GLN   308      20.079   8.444   3.692  1.00 61.32           N  
ATOM   4348  CA  GLN   308      21.176   9.118   4.384  1.00 61.63           C  
ATOM   4350  CB  GLN   308      20.765  10.532   4.835  1.00 61.82           C  
ATOM   4353  CG  GLN   308      20.016  11.382   3.801  1.00 62.21           C  
ATOM   4356  CD  GLN   308      20.797  11.581   2.516  1.00 62.52           C  
ATOM   4357  OE1 GLN   308      22.033  11.634   2.516  1.00 62.36           O  
ATOM   4358  NE2 GLN   308      20.075  11.687   1.407  1.00 62.79           N  
ATOM   4361  C   GLN   308      21.649   8.333   5.612  1.00 61.73           C  
ATOM   4362  O   GLN   308      22.151   8.916   6.566  1.00 61.85           O  
ATOM   4364  N   ALA   309      21.494   7.014   5.588  1.00 61.98           N  
ATOM   4365  CA  ALA   309      21.805   6.186   6.748  1.00 61.93           C  
ATOM   4367  CB  ALA   309      20.949   4.933   6.738  1.00 61.61           C  
ATOM   4371  C   ALA   309      23.282   5.818   6.753  1.00 62.03           C  
ATOM   4372  O   ALA   309      23.789   5.237   5.791  1.00 61.96           O  
ATOM   4374  N   GLU   310      23.974   6.157   7.834  1.00 62.21           N  
ATOM   4375  CA  GLU   310      25.347   5.693   8.028  1.00 62.50           C  
ATOM   4377  CB  GLU   310      26.047   6.553   9.079  1.00 62.40           C  
ATOM   4380  CG  GLU   310      26.400   7.941   8.568  1.00 62.69           C  
ATOM   4383  CD  GLU   310      26.884   8.880   9.666  1.00 63.31           C  
ATOM   4384  OE1 GLU   310      26.758   8.537  10.871  1.00 63.74           O  
ATOM   4385  OE2 GLU   310      27.383   9.977   9.314  1.00 64.95           O  
ATOM   4386  C   GLU   310      25.394   4.213   8.432  1.00 62.49           C  
ATOM   4387  O   GLU   310      24.417   3.667   8.947  1.00 62.48           O  
ATOM   4389  N   ASN   311      26.533   3.574   8.191  1.00 62.47           N  
ATOM   4390  CA  ASN   311      26.760   2.201   8.641  1.00 62.81           C  
ATOM   4392  CB  ASN   311      27.959   1.600   7.905  1.00 62.51           C  
ATOM   4395  CG  ASN   311      28.198   0.148   8.241  1.00 62.12           C  
ATOM   4396  OD1 ASN   311      27.540  -0.446   9.085  1.00 61.17           O  
ATOM   4397  ND2 ASN   311      29.157  -0.434   7.569  1.00 63.19           N  
ATOM   4400  C   ASN   311      26.996   2.152  10.158  1.00 63.12           C  
ATOM   4401  O   ASN   311      27.945   2.762  10.660  1.00 62.89           O  
ATOM   4403  N   PRO   312      26.124   1.431  10.896  1.00 63.69           N  
ATOM   4404  CA  PRO   312      26.283   1.273  12.350  1.00 64.13           C  
ATOM   4406  CB  PRO   312      24.872   0.892  12.806  1.00 64.06           C  
ATOM   4409  CG  PRO   312      24.252   0.234  11.633  1.00 63.72           C  
ATOM   4412  CD  PRO   312      24.913   0.746  10.401  1.00 63.54           C  
ATOM   4415  C   PRO   312      27.282   0.199  12.796  1.00 64.50           C  
ATOM   4416  O   PRO   312      27.648   0.147  13.972  1.00 64.12           O  
ATOM   4417  N   PHE   313      27.721  -0.642  11.867  1.00 65.28           N  
ATOM   4418  CA  PHE   313      28.516  -1.809  12.214  1.00 65.97           C  
ATOM   4420  CB  PHE   313      27.909  -3.074  11.592  1.00 65.69           C  
ATOM   4423  CG  PHE   313      26.465  -3.332  11.982  1.00 65.49           C  
ATOM   4424  CD1 PHE   313      26.011  -3.093  13.280  1.00 64.81           C  
ATOM   4426  CE1 PHE   313      24.699  -3.336  13.628  1.00 64.70           C  
ATOM   4428  CZ  PHE   313      23.825  -3.843  12.691  1.00 64.92           C  
ATOM   4430  CE2 PHE   313      24.262  -4.096  11.398  1.00 65.05           C  
ATOM   4432  CD2 PHE   313      25.570  -3.842  11.050  1.00 64.65           C  
ATOM   4434  C   PHE   313      29.963  -1.662  11.780  1.00 66.61           C  
ATOM   4435  O   PHE   313      30.296  -1.823  10.604  1.00 66.75           O  
ATOM   4437  N   ASP   314      30.809  -1.342  12.752  1.00 67.62           N  
ATOM   4438  CA  ASP   314      32.264  -1.381  12.597  1.00 68.41           C  
ATOM   4440  CB  ASP   314      32.960  -1.255  13.969  1.00 68.74           C  
ATOM   4443  CG  ASP   314      32.320  -2.146  15.073  1.00 69.73           C  
ATOM   4444  OD1 ASP   314      31.162  -2.624  14.931  1.00 69.35           O  
ATOM   4445  OD2 ASP   314      32.994  -2.353  16.108  1.00 71.46           O  
ATOM   4446  C   ASP   314      32.715  -2.658  11.888  1.00 69.07           C  
ATOM   4447  O   ASP   314      33.346  -2.598  10.823  1.00 69.28           O  
ATOM   4449  N   PHE   315      32.345  -3.808  12.455  1.00 69.70           N  
ATOM   4450  CA  PHE   315      32.752  -5.118  11.920  1.00 69.95           C  
ATOM   4452  CB  PHE   315      32.202  -6.269  12.779  1.00 69.93           C  
ATOM   4455  CG  PHE   315      30.696  -6.328  12.846  1.00 70.22           C  
ATOM   4456  CD1 PHE   315      29.969  -7.062  11.913  1.00 70.16           C  
ATOM   4458  CE1 PHE   315      28.585  -7.115  11.978  1.00 69.75           C  
ATOM   4460  CZ  PHE   315      27.913  -6.442  12.988  1.00 69.37           C  
ATOM   4462  CE2 PHE   315      28.620  -5.720  13.921  1.00 69.40           C  
ATOM   4464  CD2 PHE   315      30.005  -5.666  13.853  1.00 69.96           C  
ATOM   4466  C   PHE   315      32.376  -5.313  10.450  1.00 70.32           C  
ATOM   4467  O   PHE   315      32.970  -6.146   9.771  1.00 70.29           O  
ATOM   4469  N   MET   316      31.395  -4.552   9.964  1.00 70.86           N  
ATOM   4470  CA  MET   316      31.126  -4.471   8.523  1.00 71.07           C  
ATOM   4472  CB  MET   316      29.639  -4.208   8.256  1.00 71.24           C  
ATOM   4475  CG  MET   316      28.682  -5.248   8.832  1.00 70.95           C  
ATOM   4478  SD  MET   316      28.985  -6.928   8.267  1.00 70.78           S  
ATOM   4479  CE  MET   316      28.601  -6.855   6.524  1.00 68.99           C  
ATOM   4483  C   MET   316      31.967  -3.357   7.887  1.00 71.46           C  
ATOM   4484  O   MET   316      32.035  -3.242   6.657  1.00 71.85           O  
END
