
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  170 ( 1283),  selected  170 , name 1k1e_D
# Molecule2: number of CA atoms  155 ( 1208),  selected  155 , name T0445_1_81_191_264.pdb
# PARAMETERS: 1k1e_D.T0445_1_81_191_264.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L     5_D      -       -           -
LGA    E     6_D      -       -           -
LGA    N     7_D      M       1          0.656
LGA    I     8_D      I       2          0.690
LGA    K     9_D      K       3          1.095
LGA    F    10_D      L       4          0.678
LGA    V    11_D      I       5          0.381
LGA    I    12_D      A       6          0.534
LGA    T    13_D      T       7          0.681
LGA    D    14_D      D       8          0.785
LGA    V    15_D      I       9          1.300
LGA    D    16_D      D      10          1.049
LGA    G    17_D      G      11          1.178
LGA    V    18_D      T      12          1.361
LGA    L    19_D      L      13          1.895
LGA    T    20_D      V      14          1.055
LGA    D    21_D      K      15          2.458
LGA    G    22_D      D      16          2.751
LGA    Q    23_D      -       -           -
LGA    L    24_D      G      17          2.474
LGA    H    25_D      -       -           -
LGA    Y    26_D      -       -           -
LGA    D    27_D      -       -           -
LGA    A    28_D      -       -           -
LGA    N    29_D      -       -           -
LGA    G    30_D      -       -           -
LGA    E    31_D      -       -           -
LGA    A    32_D      -       -           -
LGA    I    33_D      S      18          5.136
LGA    K    34_D      L      19          1.856
LGA    S    35_D      L      20          2.532
LGA    F    36_D      I      21          1.750
LGA    H    37_D      D      22          2.325
LGA    V    38_D      P      23          2.258
LGA    R    39_D      E      24          2.373
LGA    D    40_D      Y      25          1.900
LGA    G    41_D      M      26          1.840
LGA    L    42_D      S      27          1.976
LGA    G    43_D      V      28          1.908
LGA    I    44_D      I      29          0.845
LGA    K    45_D      D      30          1.313
LGA    M    46_D      R      31          1.870
LGA    L    47_D      L      32          0.822
LGA    M    48_D      I      33          0.927
LGA    D    49_D      D      34          1.945
LGA    A    50_D      K      35          1.475
LGA    D    51_D      G      36          1.270
LGA    I    52_D      I      37          1.197
LGA    Q    53_D      I      38          1.309
LGA    V    54_D      F      39          0.609
LGA    A    55_D      V      40          0.615
LGA    V    56_D      V      41          0.688
LGA    L    57_D      C      42          0.405
LGA    S    58_D      S      43          0.826
LGA    G    59_D      G      44          1.648
LGA    R    60_D      R      45          1.777
LGA    D    61_D      Q      46          0.436
LGA    S    62_D      F      47          4.735
LGA    P    63_D      S      48          1.823
LGA    I    64_D      S      49          2.976
LGA    L    65_D      E      50          1.958
LGA    R    66_D      F      51          1.312
LGA    R    67_D      K      52          2.038
LGA    R    68_D      L      53          2.742
LGA    I    69_D      F      54          3.242
LGA    A    70_D      A      55          4.055
LGA    D    71_D      P      56          2.225
LGA    L    72_D      I      57          1.608
LGA    G    73_D      K      58          3.545
LGA    -       -      X      59           -
LGA    I    74_D      K      60          3.333
LGA    K    75_D      L      61          2.409
LGA    L    76_D      L      62          1.002
LGA    F    77_D      Y      63          1.322
LGA    F    78_D      I      64          0.941
LGA    L    79_D      T      65          0.811
LGA    G    80_D      D      66          1.073
LGA    K    81_D      G      67          2.164
LGA    L    82_D      G      68          5.017
LGA    -       -      T      69           -
LGA    -       -      V      70           -
LGA    -       -      V      71           -
LGA    -       -      R      72           -
LGA    -       -      T      73           -
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    -       -      E      76           -
LGA    -       -      I      77           -
LGA    -       -      L      78           -
LGA    -       -      K      79           -
LGA    -       -      T      80           -
LGA    -       -      Y      81           -
LGA    E    83_D      V     191          4.159
LGA    -       -      S     192           -
LGA    K    84_D      K     193          0.997
LGA    E    85_D      W     194          1.338
LGA    T    86_D      T     195          0.212
LGA    A    87_D      A     196          1.414
LGA    C    88_D      L     197          1.701
LGA    F    89_D      S     198          0.132
LGA    D    90_D      Y     199          1.094
LGA    L    91_D      L     200          1.998
LGA    M    92_D      I     201          1.145
LGA    K    93_D      D     202          2.358
LGA    Q    94_D      R     203          3.343
LGA    A    95_D      F     204          3.328
LGA    G    96_D      D     205          3.210
LGA    V    97_D      L     206          1.766
LGA    T    98_D      L     207          1.167
LGA    A    99_D      P     208          0.690
LGA    E   100_D      D     209          0.507
LGA    Q   101_D      E     210          0.465
LGA    T   102_D      V     211          0.502
LGA    A   103_D      C     212          0.583
LGA    Y   104_D      C     213          0.252
LGA    I   105_D      F     214          0.261
LGA    G   106_D      G     215          0.339
LGA    D   107_D      D     216          0.503
LGA    D   108_D      N     217          0.908
LGA    S   109_D      L     218          0.256
LGA    V   110_D      N     219          0.652
LGA    D   111_D      D     220          0.217
LGA    L   112_D      I     221          0.262
LGA    P   113_D      E     222          1.021
LGA    A   114_D      M     223          1.069
LGA    F   115_D      L     224          1.049
LGA    A   116_D      Q     225          2.028
LGA    A   117_D      N     226          2.596
LGA    C   118_D      A     227          1.370
LGA    G   119_D      G     228          1.395
LGA    T   120_D      I     229          1.066
LGA    S   121_D      S     230          0.748
LGA    F   122_D      Y     231          0.593
LGA    A   123_D      A     232          0.857
LGA    V   124_D      V     233          1.409
LGA    A   125_D      S     234          2.407
LGA    D   126_D      N     235          1.774
LGA    A   127_D      A     236          1.546
LGA    P   128_D      R     237          1.782
LGA    I   129_D      Q     238          1.809
LGA    Y   130_D      E     239          1.640
LGA    V   131_D      V     240          0.920
LGA    K   132_D      I     241          1.031
LGA    N   133_D      A     242          1.549
LGA    A   134_D      A     243          1.460
LGA    V   135_D      A     244          0.887
LGA    D   136_D      K     245          0.755
LGA    H   137_D      X     246          1.096
LGA    V   138_D      T     247          0.564
LGA    L   139_D      C     248          0.896
LGA    S   140_D      A     249          2.952
LGA    T   141_D      -       -           -
LGA    H   142_D      P     250          1.032
LGA    G   143_D      Y     251          1.965
LGA    G   144_D      W     252          5.289
LGA    K   145_D      E     253          3.999
LGA    G   146_D      N     254          1.988
LGA    A   147_D      G     255          2.198
LGA    F   148_D      V     256          2.287
LGA    R   149_D      L     257          1.431
LGA    E   150_D      S     258          1.209
LGA    M   151_D      V     259          1.512
LGA    S   152_D      L     260          1.017
LGA    D   153_D      K     261          1.753
LGA    M   154_D      S     262          2.137
LGA    I   155_D      F     263          2.253
LGA    L   156_D      L     264          2.617
LGA    Q   157_D      -       -           -
LGA    A   158_D      -       -           -
LGA    Q   159_D      -       -           -
LGA    G   160_D      -       -           -
LGA    K   161_D      -       -           -
LGA    S   162_D      -       -           -
LGA    S   163_D      -       -           -
LGA    V   164_D      -       -           -
LGA    F   165_D      -       -           -
LGA    D   166_D      -       -           -
LGA    T   167_D      -       -           -
LGA    A   168_D      -       -           -
LGA    Q   169_D      -       -           -
LGA    G   170_D      -       -           -
LGA    F   171_D      -       -           -
LGA    L   172_D      -       -           -
LGA    K   173_D      -       -           -
LGA    S   174_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  170  155    5.0    140    1.91    22.86     79.890     6.964

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.197372 * X  +  -0.799884 * Y  +   0.566771 * Z  + -62.706921
  Y_new =   0.921796 * X  +  -0.045354 * Y  +  -0.385013 * Z  +  55.275536
  Z_new =   0.333671 * X  +   0.598438 * Y  +   0.728378 * Z  + -54.109871 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.687776   -2.453817  [ DEG:    39.4067   -140.5933 ]
  Theta =  -0.340195   -2.801398  [ DEG:   -19.4917   -160.5083 ]
  Phi   =   1.359865   -1.781728  [ DEG:    77.9145   -102.0855 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k1e_D                                        
REMARK     2: T0445_1_81_191_264.pdb                        
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k1e_D.T0445_1_81_191_264.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  170  155   5.0  140   1.91   22.86  79.890
REMARK  ---------------------------------------------------------- 
MOLECULE 1k1e_D
HEADER    HYDROLASE                               25-SEP-01   1K1E              
TITLE     STRUCTURE OF THE COBALT-BOUND FORM OF THE DEOXY-D-MANNOSE-            
TITLE    2 OCTULOSONATE 8-PHOSPHATE PHOSPHATASE (YRBI) FROM                     
TITLE    3 HAEMOPHILUS INFLUENZAE (HI1679)                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEOXY-D-MANNOSE-OCTULOSONATE 8-PHOSPHATE                   
COMPND   3 PHOSPHATASE;                                                         
COMPND   4 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   5 SYNONYM: YRBI, KDO 8-P PHOSPHATASE, HI1679;                          
COMPND   6 EC: 3.1.3.-;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: KW20;                                                        
SOURCE   5 GENE: HI1679;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B21(DE3);                                  
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDEST17-HI1679                            
KEYWDS    HI1679, STRUCTURAL GENOMICS, KDO 8-P PHOSPHATASE, STRUCTURE           
KEYWDS   2 2 FUNCTION PROJECT, S2F                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.LIM,O.HERZBERG,STRUCTURE 2 FUNCTION PROJECT (S2F)                   
REVDAT   3   12-AUG-03 1K1E    1       REMARK                                   
REVDAT   2   22-APR-03 1K1E    1       JRNL   TITLE  COMPND KEYWDS              
REVDAT   1   27-FEB-02 1K1E    0                                                
JRNL        AUTH   J.F.PARSONS,K.LIM,A.TEMPCZYK,W.KRAJEWSKI,                    
JRNL        AUTH 2 E.EISENSTEIN,O.HERZBERG                                      
JRNL        TITL   FROM STRUCTURE TO FUNCTION: YRBI FROM HAEMOPHILUS            
JRNL        TITL 2 INFLUENZAE (HI1679) IS A PHOSPHATASE.                        
JRNL        REF    PROTEINS: STRUCT., FUNCT.,    V.  46   393 2002              
JRNL        REF  2 GENET.                                                       
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 1.67 ANGSTROMS.                                          
DBREF  1K1E A    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E B    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E C    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E D    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E E    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E F    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E G    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E H    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E I    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E J    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E K    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E L    1   180  UNP    P45314   KDOP_HAEIN       1    180             
SEQRES   1 A  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 A  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 A  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 A  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 A  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 A  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 A  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 A  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 A  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 A  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 A  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 A  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 A  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 A  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 B  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 B  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 B  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 B  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 B  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 B  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 B  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 B  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 B  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 B  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 B  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 B  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 B  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 B  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 C  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 C  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 C  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 C  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 C  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 C  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 C  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 C  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 C  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 C  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 C  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 C  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 C  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 C  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 D  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 D  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 D  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 D  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 D  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 D  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 D  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 D  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 D  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 D  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 D  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 D  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 D  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 D  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 E  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 E  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 E  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 E  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 E  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 E  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 E  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 E  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 E  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 E  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 E  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 E  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 E  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 E  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 F  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 F  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 F  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 F  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 F  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 F  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 F  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 F  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 F  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 F  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 F  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 F  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 F  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 F  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 G  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 G  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 G  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 G  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 G  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 G  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 G  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 G  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 G  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 G  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 G  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 G  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 G  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 G  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 H  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 H  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 H  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 H  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 H  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 H  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 H  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 H  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 H  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 H  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 H  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 H  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 H  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 H  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 I  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 I  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 I  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 I  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 I  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 I  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 I  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 I  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 I  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 I  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 I  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 I  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 I  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 I  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 J  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 J  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 J  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 J  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 J  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 J  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 J  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 J  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 J  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 J  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 J  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 J  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 J  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 J  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 K  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 K  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 K  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 K  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 K  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 K  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 K  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 K  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 K  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 K  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 K  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 K  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 K  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 K  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 L  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 L  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 L  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 L  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 L  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 L  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 L  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 L  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 L  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 L  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 L  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 L  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 L  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 L  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
HET     CO  A 201       1                                                       
HET     CO  B 202       1                                                       
HET     CO  C 203       1                                                       
HET     CO  D 204       1                                                       
HET     CO  E 205       1                                                       
HET     CO  F 206       1                                                       
HET     CO  G 207       1                                                       
HET     CO  H 208       1                                                       
HET     CO  I 209       1                                                       
HET     CO  J 210       1                                                       
HET     CO  K 211       1                                                       
HET     CO  L 212       1                                                       
HET     HG  A 301       1                                                       
HET     HG  B 302       1                                                       
HET     HG  C 303       1                                                       
HET     HG  D 304       1                                                       
HET     HG  E 305       1                                                       
HET     HG  F 306       1                                                       
HET     HG  G 307       1                                                       
HET     HG  H 308       1                                                       
HET     HG  I 309       1                                                       
HET     HG  J 310       1                                                       
HET     HG  K 311       1                                                       
HET     HG  L 312       1                                                       
HET    SO4   2401       5                                                       
HET    SO4   2402       5                                                       
HET    SO4   2403       5                                                       
HET    SO4   2404       5                                                       
HET    SO4   2405       5                                                       
HET    SO4   2406       5                                                       
HET    SO4   2407       5                                                       
HET    SO4   2408       5                                                       
HET    SO4   2409       5                                                       
HET    SO4   2410       5                                                       
HET    SO4   2411       5                                                       
HET    SO4   2412       5                                                       
HET    SO4   2413       5                                                       
HET    SO4   2414       5                                                       
HET    SO4   2415       5                                                       
HET    SO4   2416       5                                                       
HET    SO4   2417       5                                                       
HET    SO4   2418       5                                                       
HET    MES   2601      12                                                       
HET    MES   2602      12                                                       
HET    MES   2603      12                                                       
HET    GOL   2501       6                                                       
HET    GOL   2502       6                                                       
HET    GOL   2503       6                                                       
HET    GOL   2504       6                                                       
HET    GOL   2505       6                                                       
HET    GOL   2506       6                                                       
HETNAM      CO COBALT (II) ION                                                  
HETNAM      HG MERCURY (II) ION                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
HETNAM     GOL GLYCEROL                                                         
FORMUL  13   CO    12(CO 2+)                                                    
FORMUL  25   HG    12(HG 2+)                                                    
FORMUL  37  SO4    18(O4 S 2-)                                                  
FORMUL  55  MES    3(C6 H13 N O4 S)                                             
FORMUL  58  GOL    6(C3 H8 O3)                                                  
FORMUL  64  HOH   *1414(H2 O)                                                   
CRYST1  109.300  109.100  179.100  90.00 107.60  90.00 C 1 2 1      48          
ATOM   3993  N   LEU D   5      14.312  31.917  27.097  1.00 23.83           N  
ATOM   3994  CA  LEU D   5      12.893  32.435  27.006  1.00 20.23           C  
ATOM   3995  C   LEU D   5      12.840  33.942  27.163  1.00 18.48           C  
ATOM   3996  O   LEU D   5      12.038  34.604  26.563  1.00 17.31           O  
ATOM   3997  CB  LEU D   5      11.961  31.851  28.097  1.00 25.71           C  
ATOM   3998  CG  LEU D   5      11.626  30.390  27.999  1.00 24.76           C  
ATOM   3999  CD1 LEU D   5      10.437  29.980  28.877  1.00 23.52           C  
ATOM   4000  CD2 LEU D   5      11.288  30.154  26.558  1.00 22.24           C  
ATOM   4001  N   GLU D   6      13.737  34.488  27.976  1.00 22.95           N  
ATOM   4002  CA  GLU D   6      13.772  35.937  28.212  1.00 24.51           C  
ATOM   4003  C   GLU D   6      14.037  36.705  26.938  1.00 25.29           C  
ATOM   4004  O   GLU D   6      13.714  37.880  26.834  1.00 23.35           O  
ATOM   4005  CB  GLU D   6      14.893  36.248  29.228  1.00 32.01           C  
ATOM   4006  CG  GLU D   6      14.796  37.581  29.883  1.00 37.92           C  
ATOM   4007  CD  GLU D   6      15.637  37.632  31.150  1.00 42.43           C  
ATOM   4008  OE1 GLU D   6      16.767  37.025  31.154  1.00 36.75           O  
ATOM   4009  OE2 GLU D   6      15.147  38.287  32.129  1.00 44.97           O  
ATOM   4010  N   ASN D   7      14.669  36.061  25.973  1.00 21.74           N  
ATOM   4011  CA  ASN D   7      14.988  36.745  24.719  1.00 24.95           C  
ATOM   4012  C   ASN D   7      14.041  36.448  23.572  1.00 29.82           C  
ATOM   4013  O   ASN D   7      14.281  36.868  22.426  1.00 21.93           O  
ATOM   4014  CB  ASN D   7      16.406  36.405  24.285  1.00 28.41           C  
ATOM   4015  CG  ASN D   7      17.428  36.866  25.301  1.00 35.46           C  
ATOM   4016  OD1 ASN D   7      17.147  37.762  26.112  1.00 34.55           O  
ATOM   4017  ND2 ASN D   7      18.625  36.272  25.258  1.00 36.79           N  
ATOM   4018  N   ILE D   8      12.963  35.729  23.867  1.00 24.64           N  
ATOM   4019  CA  ILE D   8      12.039  35.440  22.791  1.00 17.87           C  
ATOM   4020  C   ILE D   8      11.363  36.714  22.346  1.00 14.89           C  
ATOM   4021  O   ILE D   8      10.811  37.468  23.159  1.00 17.21           O  
ATOM   4022  CB  ILE D   8      11.001  34.422  23.206  1.00 20.74           C  
ATOM   4023  CG1 ILE D   8      11.654  33.045  23.365  1.00 17.64           C  
ATOM   4024  CG2 ILE D   8       9.919  34.360  22.161  1.00 18.56           C  
ATOM   4025  CD1 ILE D   8      10.701  32.072  24.039  1.00 22.74           C  
ATOM   4026  N   LYS D   9      11.425  36.969  21.038  1.00 18.67           N  
ATOM   4027  CA  LYS D   9      10.766  38.139  20.486  1.00 17.13           C  
ATOM   4028  C   LYS D   9       9.685  37.743  19.445  1.00 15.41           C  
ATOM   4029  O   LYS D   9       8.998  38.617  18.930  1.00 15.21           O  
ATOM   4030  CB  LYS D   9      11.749  39.074  19.723  1.00 21.54           C  
ATOM   4031  CG  LYS D   9      12.920  39.662  20.509  1.00 24.74           C  
ATOM   4032  CD  LYS D   9      13.769  40.652  19.625  1.00 35.77           C  
ATOM   4033  CE  LYS D   9      13.194  42.118  19.584  1.00 35.20           C  
ATOM   4034  NZ  LYS D   9      14.000  43.248  18.879  1.00 31.72           N  
ATOM   4035  N   PHE D  10       9.608  36.468  19.084  1.00 18.62           N  
ATOM   4036  CA  PHE D  10       8.678  36.004  18.054  1.00 15.05           C  
ATOM   4037  C   PHE D  10       8.259  34.564  18.406  1.00  8.49           C  
ATOM   4038  O   PHE D  10       9.078  33.710  18.779  1.00 12.32           O  
ATOM   4039  CB  PHE D  10       9.431  36.046  16.706  1.00 14.19           C  
ATOM   4040  CG  PHE D  10       8.603  35.638  15.516  1.00 17.18           C  
ATOM   4041  CD1 PHE D  10       7.268  35.959  15.460  1.00 13.18           C  
ATOM   4042  CD2 PHE D  10       9.203  35.019  14.431  1.00 15.99           C  
ATOM   4043  CE1 PHE D  10       6.496  35.655  14.276  1.00 13.66           C  
ATOM   4044  CE2 PHE D  10       8.462  34.733  13.276  1.00 15.30           C  
ATOM   4045  CZ  PHE D  10       7.122  35.057  13.226  1.00 12.25           C  
ATOM   4046  N   VAL D  11       6.960  34.288  18.293  1.00 17.33           N  
ATOM   4047  CA  VAL D  11       6.446  32.981  18.600  1.00 18.00           C  
ATOM   4048  C   VAL D  11       5.619  32.569  17.384  1.00 12.98           C  
ATOM   4049  O   VAL D  11       4.786  33.326  16.938  1.00 15.40           O  
ATOM   4050  CB  VAL D  11       5.546  33.033  19.837  1.00 20.81           C  
ATOM   4051  CG1 VAL D  11       4.775  31.675  20.012  1.00 10.51           C  
ATOM   4052  CG2 VAL D  11       6.387  33.321  21.046  1.00 18.82           C  
ATOM   4053  N   ILE D  12       5.919  31.385  16.874  1.00 14.67           N  
ATOM   4054  CA  ILE D  12       5.242  30.760  15.749  1.00 11.65           C  
ATOM   4055  C   ILE D  12       4.504  29.535  16.286  1.00 14.21           C  
ATOM   4056  O   ILE D  12       5.075  28.669  16.969  1.00 11.17           O  
ATOM   4057  CB  ILE D  12       6.265  30.268  14.705  1.00 16.71           C  
ATOM   4058  CG1 ILE D  12       7.112  31.470  14.245  1.00 16.45           C  
ATOM   4059  CG2 ILE D  12       5.553  29.554  13.559  1.00 11.66           C  
ATOM   4060  CD1 ILE D  12       8.353  31.110  13.365  1.00 20.38           C  
ATOM   4061  N   THR D  13       3.213  29.465  15.990  1.00 12.99           N  
ATOM   4062  CA  THR D  13       2.453  28.333  16.456  1.00 10.21           C  
ATOM   4063  C   THR D  13       1.753  27.570  15.342  1.00  9.22           C  
ATOM   4064  O   THR D  13       1.174  28.170  14.410  1.00 12.94           O  
ATOM   4065  CB  THR D  13       1.391  28.757  17.471  1.00 13.41           C  
ATOM   4066  OG1 THR D  13       0.638  27.612  17.908  1.00 13.43           O  
ATOM   4067  CG2 THR D  13       0.383  29.708  16.791  1.00 12.16           C  
ATOM   4068  N   ASP D  14       1.895  26.264  15.416  1.00 12.07           N  
ATOM   4069  CA  ASP D  14       1.161  25.358  14.544  1.00 12.21           C  
ATOM   4070  C   ASP D  14      -0.302  25.573  14.966  1.00 13.89           C  
ATOM   4071  O   ASP D  14      -0.601  26.121  16.044  1.00 13.50           O  
ATOM   4072  CB  ASP D  14       1.584  23.930  14.840  1.00  8.96           C  
ATOM   4073  CG  ASP D  14       0.740  22.871  14.097  1.00 16.82           C  
ATOM   4074  OD1 ASP D  14       0.444  23.021  12.910  1.00 14.72           O  
ATOM   4075  OD2 ASP D  14       0.468  21.870  14.735  1.00 11.59           O  
ATOM   4076  N   VAL D  15      -1.213  25.122  14.118  1.00 10.35           N  
ATOM   4077  CA  VAL D  15      -2.619  25.301  14.413  1.00  7.80           C  
ATOM   4078  C   VAL D  15      -3.216  23.977  14.869  1.00 10.81           C  
ATOM   4079  O   VAL D  15      -3.686  23.854  16.003  1.00 12.84           O  
ATOM   4080  CB  VAL D  15      -3.442  25.789  13.157  1.00  6.93           C  
ATOM   4081  CG1 VAL D  15      -4.940  25.809  13.462  1.00 14.77           C  
ATOM   4082  CG2 VAL D  15      -3.008  27.195  12.792  1.00 13.95           C  
ATOM   4083  N   ASP D  16      -3.260  22.975  13.991  1.00 12.44           N  
ATOM   4084  CA  ASP D  16      -3.930  21.745  14.398  1.00 12.98           C  
ATOM   4085  C   ASP D  16      -3.193  20.917  15.436  1.00 13.18           C  
ATOM   4086  O   ASP D  16      -2.010  20.591  15.252  1.00 16.84           O  
ATOM   4087  CB  ASP D  16      -4.284  20.943  13.159  1.00 13.35           C  
ATOM   4088  CG  ASP D  16      -5.193  21.753  12.233  1.00 18.12           C  
ATOM   4089  OD1 ASP D  16      -6.314  22.093  12.649  1.00 14.26           O  
ATOM   4090  OD2 ASP D  16      -4.744  22.048  11.104  1.00 15.23           O  
ATOM   4091  N   GLY D  17      -3.912  20.614  16.531  1.00 10.90           N  
ATOM   4092  CA  GLY D  17      -3.336  19.911  17.668  1.00 10.66           C  
ATOM   4093  C   GLY D  17      -2.607  20.841  18.625  1.00 13.12           C  
ATOM   4094  O   GLY D  17      -2.110  20.383  19.689  1.00 13.55           O  
ATOM   4095  N   VAL D  18      -2.493  22.116  18.257  1.00 12.26           N  
ATOM   4096  CA  VAL D  18      -1.852  23.080  19.177  1.00 12.51           C  
ATOM   4097  C   VAL D  18      -2.909  24.104  19.623  1.00 10.85           C  
ATOM   4098  O   VAL D  18      -3.269  24.149  20.814  1.00 13.82           O  
ATOM   4099  CB  VAL D  18      -0.678  23.741  18.547  1.00 15.40           C  
ATOM   4100  CG1 VAL D  18      -0.114  24.816  19.568  1.00  9.34           C  
ATOM   4101  CG2 VAL D  18       0.393  22.653  18.248  1.00 15.43           C  
ATOM   4102  N   LEU D  19      -3.422  24.904  18.689  1.00  7.53           N  
ATOM   4103  CA  LEU D  19      -4.505  25.859  18.968  1.00  9.17           C  
ATOM   4104  C   LEU D  19      -5.860  25.098  18.985  1.00 11.59           C  
ATOM   4105  O   LEU D  19      -6.859  25.661  19.379  1.00 14.72           O  
ATOM   4106  CB  LEU D  19      -4.515  26.942  17.883  1.00 12.00           C  
ATOM   4107  CG  LEU D  19      -3.286  27.837  17.869  1.00 11.64           C  
ATOM   4108  CD1 LEU D  19      -3.489  29.012  16.860  1.00 12.34           C  
ATOM   4109  CD2 LEU D  19      -3.114  28.356  19.315  1.00 16.74           C  
ATOM   4110  N   THR D  20      -5.877  23.852  18.472  1.00 16.46           N  
ATOM   4111  CA  THR D  20      -7.088  22.989  18.520  1.00 10.58           C  
ATOM   4112  C   THR D  20      -6.672  21.666  19.164  1.00 13.77           C  
ATOM   4113  O   THR D  20      -5.454  21.333  19.282  1.00 13.19           O  
ATOM   4114  CB  THR D  20      -7.617  22.621  17.166  1.00 11.83           C  
ATOM   4115  OG1 THR D  20      -6.798  21.587  16.644  1.00 13.00           O  
ATOM   4116  CG2 THR D  20      -7.567  23.776  16.224  1.00 12.45           C  
ATOM   4117  N   ASP D  21      -7.667  20.847  19.531  1.00  9.87           N  
ATOM   4118  CA  ASP D  21      -7.315  19.569  20.085  1.00 10.95           C  
ATOM   4119  C   ASP D  21      -7.011  18.543  19.014  1.00 14.38           C  
ATOM   4120  O   ASP D  21      -6.919  17.343  19.314  1.00 13.32           O  
ATOM   4121  CB  ASP D  21      -8.398  19.030  21.007  1.00 14.96           C  
ATOM   4122  CG  ASP D  21      -9.688  18.706  20.290  1.00 20.31           C  
ATOM   4123  OD1 ASP D  21      -9.813  18.935  19.072  1.00 14.82           O  
ATOM   4124  OD2 ASP D  21     -10.597  18.199  20.995  1.00 20.04           O  
ATOM   4125  N   GLY D  22      -6.828  19.021  17.792  1.00 13.62           N  
ATOM   4126  CA  GLY D  22      -6.459  18.099  16.707  1.00  9.41           C  
ATOM   4127  C   GLY D  22      -7.671  17.580  15.942  1.00 18.83           C  
ATOM   4128  O   GLY D  22      -7.512  16.900  14.898  1.00 12.67           O  
ATOM   4129  N   GLN D  23      -8.856  17.909  16.420  1.00 11.49           N  
ATOM   4130  CA  GLN D  23     -10.054  17.440  15.689  1.00 14.78           C  
ATOM   4131  C   GLN D  23     -10.266  18.314  14.448  1.00  9.59           C  
ATOM   4132  O   GLN D  23      -9.984  19.528  14.442  1.00 10.85           O  
ATOM   4133  CB  GLN D  23     -11.304  17.494  16.589  1.00 12.80           C  
ATOM   4134  CG  GLN D  23     -11.398  16.410  17.631  1.00 11.82           C  
ATOM   4135  CD  GLN D  23     -12.696  16.489  18.362  1.00 24.01           C  
ATOM   4136  OE1 GLN D  23     -13.695  15.926  17.911  1.00 21.35           O  
ATOM   4137  NE2 GLN D  23     -12.715  17.185  19.508  1.00 16.07           N  
ATOM   4138  N   LEU D  24     -10.737  17.667  13.364  1.00 10.07           N  
ATOM   4139  CA  LEU D  24     -11.015  18.316  12.054  1.00 13.50           C  
ATOM   4140  C   LEU D  24     -12.506  17.971  11.867  1.00 12.85           C  
ATOM   4141  O   LEU D  24     -12.893  16.788  11.704  1.00 10.82           O  
ATOM   4142  CB  LEU D  24     -10.178  17.700  10.940  1.00 11.51           C  
ATOM   4143  CG  LEU D  24      -8.632  17.939  11.084  1.00 12.95           C  
ATOM   4144  CD1 LEU D  24      -7.823  17.271   9.929  1.00 18.15           C  
ATOM   4145  CD2 LEU D  24      -8.379  19.419  11.064  1.00 14.26           C  
ATOM   4146  N   HIS D  25     -13.305  19.037  12.017  1.00 13.61           N  
ATOM   4147  CA  HIS D  25     -14.763  18.971  11.960  1.00  9.07           C  
ATOM   4148  C   HIS D  25     -15.177  19.206  10.536  1.00 13.55           C  
ATOM   4149  O   HIS D  25     -15.136  20.333  10.061  1.00 14.66           O  
ATOM   4150  CB  HIS D  25     -15.364  20.103  12.849  1.00 11.46           C  
ATOM   4151  CG  HIS D  25     -14.962  19.992  14.275  1.00 14.67           C  
ATOM   4152  ND1 HIS D  25     -15.071  18.818  14.971  1.00 13.59           N  
ATOM   4153  CD2 HIS D  25     -14.426  20.896  15.134  1.00 22.04           C  
ATOM   4154  CE1 HIS D  25     -14.624  18.990  16.199  1.00 18.04           C  
ATOM   4155  NE2 HIS D  25     -14.228  20.246  16.326  1.00 19.20           N  
ATOM   4156  N   TYR D  26     -15.543  18.124   9.858  1.00 10.00           N  
ATOM   4157  CA  TYR D  26     -15.923  18.174   8.405  1.00  8.49           C  
ATOM   4158  C   TYR D  26     -17.378  18.160   8.103  1.00  9.23           C  
ATOM   4159  O   TYR D  26     -18.132  17.530   8.852  1.00 13.07           O  
ATOM   4160  CB  TYR D  26     -15.460  16.880   7.737  1.00 12.78           C  
ATOM   4161  CG  TYR D  26     -14.059  16.788   7.218  1.00 12.60           C  
ATOM   4162  CD1 TYR D  26     -12.937  16.896   8.072  1.00 14.27           C  
ATOM   4163  CD2 TYR D  26     -13.854  16.632   5.846  1.00 13.73           C  
ATOM   4164  CE1 TYR D  26     -11.645  16.869   7.517  1.00 12.76           C  
ATOM   4165  CE2 TYR D  26     -12.603  16.575   5.291  1.00 13.14           C  
ATOM   4166  CZ  TYR D  26     -11.503  16.711   6.143  1.00 16.28           C  
ATOM   4167  OH  TYR D  26     -10.287  16.769   5.592  1.00 14.10           O  
ATOM   4168  N   ASP D  27     -17.773  18.851   7.022  1.00  9.38           N  
ATOM   4169  CA  ASP D  27     -19.102  18.620   6.505  1.00  9.72           C  
ATOM   4170  C   ASP D  27     -18.802  18.039   5.111  1.00 15.31           C  
ATOM   4171  O   ASP D  27     -17.680  17.536   4.878  1.00 12.73           O  
ATOM   4172  CB  ASP D  27     -20.003  19.868   6.497  1.00 12.66           C  
ATOM   4173  CG  ASP D  27     -19.518  20.982   5.648  1.00 12.21           C  
ATOM   4174  OD1 ASP D  27     -20.198  22.044   5.732  1.00 14.21           O  
ATOM   4175  OD2 ASP D  27     -18.505  20.861   4.922  1.00 13.74           O  
ATOM   4176  N   ALA D  28     -19.761  18.033   4.205  1.00 14.31           N  
ATOM   4177  CA  ALA D  28     -19.460  17.403   2.878  1.00 17.29           C  
ATOM   4178  C   ALA D  28     -18.465  18.156   2.031  1.00 17.97           C  
ATOM   4179  O   ALA D  28     -18.008  17.676   0.990  1.00 16.45           O  
ATOM   4180  CB  ALA D  28     -20.745  17.288   2.073  1.00 19.10           C  
ATOM   4181  N   ASN D  29     -18.239  19.395   2.431  1.00 12.32           N  
ATOM   4182  CA  ASN D  29     -17.365  20.325   1.710  1.00 17.36           C  
ATOM   4183  C   ASN D  29     -15.968  20.545   2.277  1.00 18.93           C  
ATOM   4184  O   ASN D  29     -15.195  21.370   1.736  1.00 19.60           O  
ATOM   4185  CB  ASN D  29     -18.108  21.672   1.565  1.00 17.24           C  
ATOM   4186  CG  ASN D  29     -19.308  21.543   0.667  1.00 22.37           C  
ATOM   4187  OD1 ASN D  29     -20.418  22.012   0.978  1.00 28.30           O  
ATOM   4188  ND2 ASN D  29     -19.098  20.889  -0.489  1.00 27.30           N  
ATOM   4189  N   GLY D  30     -15.645  19.833   3.359  1.00 12.17           N  
ATOM   4190  CA  GLY D  30     -14.324  19.988   3.915  1.00 11.89           C  
ATOM   4191  C   GLY D  30     -14.458  20.459   5.340  1.00 18.07           C  
ATOM   4192  O   GLY D  30     -15.482  20.234   5.973  1.00 12.79           O  
ATOM   4193  N   GLU D  31     -13.453  21.119   5.864  1.00 10.56           N  
ATOM   4194  CA  GLU D  31     -13.654  21.569   7.263  1.00 16.07           C  
ATOM   4195  C   GLU D  31     -14.842  22.522   7.365  1.00 15.23           C  
ATOM   4196  O   GLU D  31     -14.993  23.435   6.557  1.00 16.02           O  
ATOM   4197  CB  GLU D  31     -12.427  22.296   7.803  1.00 17.14           C  
ATOM   4198  CG  GLU D  31     -11.199  21.521   7.840  1.00 17.36           C  
ATOM   4199  CD  GLU D  31     -10.132  22.331   8.501  1.00 17.90           C  
ATOM   4200  OE1 GLU D  31     -10.122  22.394   9.738  1.00 15.38           O  
ATOM   4201  OE2 GLU D  31      -9.317  22.945   7.804  1.00 23.08           O  
ATOM   4202  N   ALA D  32     -15.640  22.356   8.410  1.00 12.14           N  
ATOM   4203  CA  ALA D  32     -16.834  23.146   8.564  1.00 10.79           C  
ATOM   4204  C   ALA D  32     -16.816  24.043   9.797  1.00 13.92           C  
ATOM   4205  O   ALA D  32     -17.455  25.093   9.833  1.00 13.98           O  
ATOM   4206  CB  ALA D  32     -18.050  22.180   8.601  1.00 10.68           C  
ATOM   4207  N   ILE D  33     -16.019  23.599  10.757  1.00 15.21           N  
ATOM   4208  CA  ILE D  33     -15.866  24.270  12.024  1.00 14.46           C  
ATOM   4209  C   ILE D  33     -14.443  24.030  12.467  1.00 11.28           C  
ATOM   4210  O   ILE D  33     -13.888  22.957  12.188  1.00 13.23           O  
ATOM   4211  CB  ILE D  33     -16.803  23.624  13.073  1.00 11.35           C  
ATOM   4212  CG1 ILE D  33     -18.248  23.981  12.786  1.00 18.72           C  
ATOM   4213  CG2 ILE D  33     -16.541  24.178  14.530  1.00 11.10           C  
ATOM   4214  CD1 ILE D  33     -19.146  23.313  13.728  1.00 30.80           C  
ATOM   4215  N   LYS D  34     -13.842  25.010  13.146  1.00 15.00           N  
ATOM   4216  CA  LYS D  34     -12.520  24.820  13.746  1.00 15.33           C  
ATOM   4217  C   LYS D  34     -12.760  25.354  15.176  1.00 10.72           C  
ATOM   4218  O   LYS D  34     -13.380  26.392  15.351  1.00 12.01           O  
ATOM   4219  CB  LYS D  34     -11.434  25.636  13.033  1.00  9.11           C  
ATOM   4220  CG  LYS D  34     -11.124  25.062  11.644  1.00 12.98           C  
ATOM   4221  CD  LYS D  34      -9.846  25.675  11.045  1.00 13.84           C  
ATOM   4222  CE  LYS D  34      -8.593  25.176  11.815  1.00 14.86           C  
ATOM   4223  NZ  LYS D  34      -8.477  23.689  11.644  1.00 20.14           N  
ATOM   4224  N   SER D  35     -12.236  24.636  16.168  1.00  9.29           N  
ATOM   4225  CA  SER D  35     -12.434  24.984  17.552  1.00 12.62           C  
ATOM   4226  C   SER D  35     -11.165  25.506  18.187  1.00 16.61           C  
ATOM   4227  O   SER D  35     -10.197  24.755  18.305  1.00 12.62           O  
ATOM   4228  CB  SER D  35     -12.884  23.739  18.287  1.00 19.57           C  
ATOM   4229  OG  SER D  35     -14.069  23.254  17.658  1.00 17.34           O  
ATOM   4230  N   PHE D  36     -11.218  26.741  18.666  1.00 13.87           N  
ATOM   4231  CA  PHE D  36     -10.026  27.365  19.245  1.00 10.43           C  
ATOM   4232  C   PHE D  36     -10.263  27.464  20.750  1.00 15.11           C  
ATOM   4233  O   PHE D  36     -11.281  26.998  21.235  1.00 19.52           O  
ATOM   4234  CB  PHE D  36      -9.835  28.725  18.582  1.00 11.50           C  
ATOM   4235  CG  PHE D  36      -9.504  28.612  17.097  1.00 13.94           C  
ATOM   4236  CD1 PHE D  36     -10.520  28.735  16.133  1.00 17.87           C  
ATOM   4237  CD2 PHE D  36      -8.238  28.293  16.687  1.00 15.63           C  
ATOM   4238  CE1 PHE D  36     -10.259  28.530  14.797  1.00  9.75           C  
ATOM   4239  CE2 PHE D  36      -7.951  28.073  15.327  1.00 14.55           C  
ATOM   4240  CZ  PHE D  36      -8.961  28.187  14.385  1.00 16.69           C  
ATOM   4241  N   HIS D  37      -9.332  28.015  21.494  1.00 12.69           N  
ATOM   4242  CA  HIS D  37      -9.545  28.093  22.924  1.00 11.76           C  
ATOM   4243  C   HIS D  37      -9.453  29.564  23.333  1.00  8.96           C  
ATOM   4244  O   HIS D  37      -8.518  30.282  22.980  1.00 15.18           O  
ATOM   4245  CB  HIS D  37      -8.472  27.261  23.666  1.00 10.71           C  
ATOM   4246  CG  HIS D  37      -8.842  26.988  25.087  1.00 16.68           C  
ATOM   4247  ND1 HIS D  37      -9.367  25.784  25.503  1.00 19.02           N  
ATOM   4248  CD2 HIS D  37      -8.870  27.810  26.165  1.00  9.12           C  
ATOM   4249  CE1 HIS D  37      -9.715  25.881  26.781  1.00 16.08           C  
ATOM   4250  NE2 HIS D  37      -9.427  27.096  27.203  1.00 20.55           N  
ATOM   4251  N   VAL D  38     -10.404  29.987  24.160  1.00 13.51           N  
ATOM   4252  CA  VAL D  38     -10.447  31.360  24.554  1.00 13.66           C  
ATOM   4253  C   VAL D  38      -9.228  31.813  25.330  1.00 17.17           C  
ATOM   4254  O   VAL D  38      -8.773  32.961  25.161  1.00 13.72           O  
ATOM   4255  CB  VAL D  38     -11.734  31.663  25.364  1.00 15.78           C  
ATOM   4256  CG1 VAL D  38     -11.772  30.859  26.679  1.00 12.62           C  
ATOM   4257  CG2 VAL D  38     -11.827  33.138  25.589  1.00 19.26           C  
ATOM   4258  N   ARG D  39      -8.686  30.926  26.177  1.00 13.12           N  
ATOM   4259  CA  ARG D  39      -7.552  31.357  26.994  1.00 14.95           C  
ATOM   4260  C   ARG D  39      -6.282  31.494  26.148  1.00 14.88           C  
ATOM   4261  O   ARG D  39      -5.378  32.328  26.448  1.00 13.69           O  
ATOM   4262  CB  ARG D  39      -7.394  30.465  28.277  1.00 10.27           C  
ATOM   4263  CG  ARG D  39      -8.635  30.686  29.262  1.00 17.56           C  
ATOM   4264  CD  ARG D  39      -8.422  30.114  30.665  1.00 12.52           C  
ATOM   4265  NE  ARG D  39      -8.171  28.703  30.601  1.00 10.17           N  
ATOM   4266  CZ  ARG D  39      -9.167  27.805  30.727  1.00 12.58           C  
ATOM   4267  NH1 ARG D  39     -10.434  28.214  30.906  1.00 14.73           N  
ATOM   4268  NH2 ARG D  39      -8.885  26.514  30.709  1.00 17.40           N  
ATOM   4269  N   ASP D  40      -6.203  30.732  25.046  1.00 12.15           N  
ATOM   4270  CA  ASP D  40      -5.091  30.919  24.155  1.00 12.00           C  
ATOM   4271  C   ASP D  40      -5.230  32.275  23.456  1.00 11.81           C  
ATOM   4272  O   ASP D  40      -4.211  32.950  23.184  1.00 14.13           O  
ATOM   4273  CB  ASP D  40      -5.101  29.886  23.025  1.00 15.03           C  
ATOM   4274  CG  ASP D  40      -4.730  28.498  23.468  1.00 19.92           C  
ATOM   4275  OD1 ASP D  40      -4.024  28.333  24.491  1.00 14.98           O  
ATOM   4276  OD2 ASP D  40      -5.133  27.544  22.722  1.00 16.87           O  
ATOM   4277  N   GLY D  41      -6.449  32.667  23.100  1.00 11.89           N  
ATOM   4278  CA  GLY D  41      -6.583  33.956  22.411  1.00 11.65           C  
ATOM   4279  C   GLY D  41      -6.079  35.093  23.297  1.00 17.39           C  
ATOM   4280  O   GLY D  41      -5.470  36.043  22.806  1.00 15.48           O  
ATOM   4281  N   LEU D  42      -6.339  35.015  24.607  1.00 18.40           N  
ATOM   4282  CA  LEU D  42      -5.903  36.095  25.492  1.00 13.98           C  
ATOM   4283  C   LEU D  42      -4.390  36.049  25.566  1.00 11.96           C  
ATOM   4284  O   LEU D  42      -3.725  37.093  25.527  1.00 16.61           O  
ATOM   4285  CB  LEU D  42      -6.505  35.933  26.883  1.00 15.33           C  
ATOM   4286  CG  LEU D  42      -6.187  37.090  27.855  1.00 17.49           C  
ATOM   4287  CD1 LEU D  42      -6.658  38.411  27.288  1.00 18.48           C  
ATOM   4288  CD2 LEU D  42      -6.900  36.868  29.206  1.00 19.00           C  
ATOM   4289  N   GLY D  43      -3.845  34.840  25.653  1.00 18.06           N  
ATOM   4290  CA  GLY D  43      -2.396  34.686  25.698  1.00 15.42           C  
ATOM   4291  C   GLY D  43      -1.766  35.291  24.442  1.00 14.14           C  
ATOM   4292  O   GLY D  43      -0.697  35.902  24.469  1.00 12.38           O  
ATOM   4293  N   ILE D  44      -2.451  35.155  23.327  1.00 11.89           N  
ATOM   4294  CA  ILE D  44      -1.877  35.700  22.065  1.00 13.73           C  
ATOM   4295  C   ILE D  44      -1.849  37.193  22.141  1.00 16.31           C  
ATOM   4296  O   ILE D  44      -0.842  37.853  21.821  1.00 18.20           O  
ATOM   4297  CB  ILE D  44      -2.702  35.213  20.864  1.00 12.27           C  
ATOM   4298  CG1 ILE D  44      -2.294  33.776  20.560  1.00 10.01           C  
ATOM   4299  CG2 ILE D  44      -2.440  36.108  19.649  1.00 14.59           C  
ATOM   4300  CD1 ILE D  44      -3.223  33.094  19.604  1.00 16.53           C  
ATOM   4301  N   LYS D  45      -2.931  37.756  22.630  1.00 13.82           N  
ATOM   4302  CA  LYS D  45      -2.991  39.198  22.771  1.00 16.40           C  
ATOM   4303  C   LYS D  45      -1.958  39.679  23.791  1.00 18.44           C  
ATOM   4304  O   LYS D  45      -1.350  40.736  23.567  1.00 17.70           O  
ATOM   4305  CB  LYS D  45      -4.395  39.618  23.185  1.00 26.08           C  
ATOM   4306  CG  LYS D  45      -5.459  39.286  22.111  1.00 29.62           C  
ATOM   4307  CD  LYS D  45      -5.223  39.970  20.733  1.00 32.33           C  
ATOM   4308  CE  LYS D  45      -5.240  41.510  20.826  1.00 32.92           C  
ATOM   4309  NZ  LYS D  45      -5.105  42.123  19.469  1.00 41.80           N  
ATOM   4310  N   MET D  46      -1.752  38.940  24.894  1.00 13.46           N  
ATOM   4311  CA  MET D  46      -0.756  39.382  25.876  1.00 10.44           C  
ATOM   4312  C   MET D  46       0.617  39.450  25.254  1.00 17.27           C  
ATOM   4313  O   MET D  46       1.394  40.346  25.531  1.00 14.43           O  
ATOM   4314  CB  MET D  46      -0.749  38.418  27.069  1.00 18.17           C  
ATOM   4315  CG  MET D  46      -2.031  38.583  27.928  1.00 23.62           C  
ATOM   4316  SD  MET D  46      -2.248  37.289  29.168  1.00 18.53           S  
ATOM   4317  CE  MET D  46      -3.487  38.041  30.156  1.00 14.08           C  
ATOM   4318  N   LEU D  47       0.968  38.450  24.456  1.00 15.04           N  
ATOM   4319  CA  LEU D  47       2.257  38.462  23.843  1.00 15.06           C  
ATOM   4320  C   LEU D  47       2.404  39.727  22.980  1.00 17.68           C  
ATOM   4321  O   LEU D  47       3.410  40.458  23.079  1.00 16.44           O  
ATOM   4322  CB  LEU D  47       2.417  37.212  22.942  1.00 17.49           C  
ATOM   4323  CG  LEU D  47       2.576  35.874  23.676  1.00 16.63           C  
ATOM   4324  CD1 LEU D  47       2.653  34.766  22.683  1.00 16.34           C  
ATOM   4325  CD2 LEU D  47       3.916  35.892  24.528  1.00 14.15           C  
ATOM   4326  N   MET D  48       1.418  39.965  22.116  1.00 14.08           N  
ATOM   4327  CA  MET D  48       1.460  41.134  21.231  1.00 21.33           C  
ATOM   4328  C   MET D  48       1.549  42.441  21.994  1.00 21.92           C  
ATOM   4329  O   MET D  48       2.283  43.387  21.579  1.00 18.74           O  
ATOM   4330  CB  MET D  48       0.253  41.115  20.291  1.00 15.59           C  
ATOM   4331  CG  MET D  48       0.393  39.934  19.395  1.00 19.15           C  
ATOM   4332  SD  MET D  48      -0.764  39.826  18.038  1.00 30.20           S  
ATOM   4333  CE  MET D  48      -2.204  40.448  18.733  1.00 30.26           C  
ATOM   4334  N   ASP D  49       0.812  42.514  23.084  1.00 20.43           N  
ATOM   4335  CA  ASP D  49       0.846  43.715  23.922  1.00 23.33           C  
ATOM   4336  C   ASP D  49       2.255  43.858  24.462  1.00 23.92           C  
ATOM   4337  O   ASP D  49       2.666  44.986  24.768  1.00 27.02           O  
ATOM   4338  CB  ASP D  49      -0.011  43.600  25.189  1.00 21.93           C  
ATOM   4339  CG  ASP D  49      -1.511  43.711  24.940  1.00 36.65           C  
ATOM   4340  OD1 ASP D  49      -1.936  44.299  23.906  1.00 35.21           O  
ATOM   4341  OD2 ASP D  49      -2.271  43.216  25.818  1.00 34.51           O  
ATOM   4342  N   ALA D  50       2.942  42.726  24.690  1.00 16.86           N  
ATOM   4343  CA  ALA D  50       4.290  42.789  25.233  1.00 19.65           C  
ATOM   4344  C   ALA D  50       5.336  42.856  24.121  1.00 22.07           C  
ATOM   4345  O   ALA D  50       6.495  42.517  24.346  1.00 18.92           O  
ATOM   4346  CB  ALA D  50       4.579  41.615  26.152  1.00 20.02           C  
ATOM   4347  N   ASP D  51       4.898  43.298  22.946  1.00 20.00           N  
ATOM   4348  CA  ASP D  51       5.747  43.452  21.776  1.00 23.25           C  
ATOM   4349  C   ASP D  51       6.446  42.200  21.347  1.00 23.72           C  
ATOM   4350  O   ASP D  51       7.558  42.266  20.888  1.00 22.10           O  
ATOM   4351  CB  ASP D  51       6.797  44.538  22.030  1.00 27.08           C  
ATOM   4352  CG  ASP D  51       6.160  45.874  22.308  1.00 24.43           C  
ATOM   4353  OD1 ASP D  51       6.651  46.559  23.216  1.00 31.44           O  
ATOM   4354  OD2 ASP D  51       5.168  46.231  21.615  1.00 28.08           O  
ATOM   4355  N   ILE D  52       5.791  41.052  21.502  1.00 19.96           N  
ATOM   4356  CA  ILE D  52       6.339  39.806  21.087  1.00 18.63           C  
ATOM   4357  C   ILE D  52       5.472  39.500  19.888  1.00 21.13           C  
ATOM   4358  O   ILE D  52       4.262  39.398  20.012  1.00 21.69           O  
ATOM   4359  CB  ILE D  52       6.151  38.734  22.163  1.00 22.74           C  
ATOM   4360  CG1 ILE D  52       7.026  39.108  23.392  1.00 23.14           C  
ATOM   4361  CG2 ILE D  52       6.484  37.388  21.576  1.00 20.84           C  
ATOM   4362  CD1 ILE D  52       7.080  38.071  24.483  1.00 15.76           C  
ATOM   4363  N   GLN D  53       6.078  39.320  18.721  1.00 14.90           N  
ATOM   4364  CA  GLN D  53       5.252  39.082  17.547  1.00 16.73           C  
ATOM   4365  C   GLN D  53       4.754  37.662  17.572  1.00 14.92           C  
ATOM   4366  O   GLN D  53       5.444  36.780  18.125  1.00 14.49           O  
ATOM   4367  CB  GLN D  53       6.070  39.335  16.286  1.00 11.00           C  
ATOM   4368  CG  GLN D  53       6.569  40.756  16.207  1.00 24.72           C  
ATOM   4369  CD  GLN D  53       7.347  40.993  14.955  1.00 20.76           C  
ATOM   4370  OE1 GLN D  53       6.770  41.057  13.869  1.00 21.90           O  
ATOM   4371  NE2 GLN D  53       8.664  41.111  15.084  1.00 22.02           N  
ATOM   4372  N   VAL D  54       3.601  37.437  16.935  1.00 17.72           N  
ATOM   4373  CA  VAL D  54       2.989  36.102  16.880  1.00 21.77           C  
ATOM   4374  C   VAL D  54       2.656  35.734  15.447  1.00 16.01           C  
ATOM   4375  O   VAL D  54       2.100  36.525  14.710  1.00 15.59           O  
ATOM   4376  CB  VAL D  54       1.695  36.086  17.717  1.00 21.05           C  
ATOM   4377  CG1 VAL D  54       0.944  34.699  17.647  1.00 13.22           C  
ATOM   4378  CG2 VAL D  54       2.060  36.450  19.113  1.00 17.23           C  
ATOM   4379  N   ALA D  55       2.972  34.509  15.068  1.00 10.91           N  
ATOM   4380  CA  ALA D  55       2.637  34.032  13.718  1.00 14.07           C  
ATOM   4381  C   ALA D  55       1.983  32.656  13.821  1.00 14.93           C  
ATOM   4382  O   ALA D  55       2.189  31.892  14.782  1.00 14.27           O  
ATOM   4383  CB  ALA D  55       3.936  33.891  12.882  1.00 14.81           C  
ATOM   4384  N   VAL D  56       1.188  32.322  12.820  1.00 13.91           N  
ATOM   4385  CA  VAL D  56       0.612  31.011  12.763  1.00 15.57           C  
ATOM   4386  C   VAL D  56       1.152  30.311  11.554  1.00 22.18           C  
ATOM   4387  O   VAL D  56       1.262  30.913  10.506  1.00 17.85           O  
ATOM   4388  CB  VAL D  56      -0.879  31.139  12.615  1.00 24.28           C  
ATOM   4389  CG1 VAL D  56      -1.479  29.855  12.109  1.00 20.75           C  
ATOM   4390  CG2 VAL D  56      -1.441  31.574  13.980  1.00 20.07           C  
ATOM   4391  N   LEU D  57       1.433  29.028  11.703  1.00 18.94           N  
ATOM   4392  CA  LEU D  57       1.945  28.222  10.616  1.00 21.31           C  
ATOM   4393  C   LEU D  57       0.951  27.054  10.453  1.00 22.19           C  
ATOM   4394  O   LEU D  57       0.654  26.323  11.393  1.00 22.23           O  
ATOM   4395  CB  LEU D  57       3.336  27.678  11.012  1.00 25.38           C  
ATOM   4396  CG  LEU D  57       4.448  27.758   9.987  1.00 26.96           C  
ATOM   4397  CD1 LEU D  57       5.579  26.669  10.248  1.00 22.96           C  
ATOM   4398  CD2 LEU D  57       3.841  27.584   8.590  1.00 24.82           C  
ATOM   4399  N   SER D  58       0.412  26.855   9.269  1.00 20.72           N  
ATOM   4400  CA  SER D  58      -0.478  25.728   9.098  1.00 19.66           C  
ATOM   4401  C   SER D  58      -0.408  25.239   7.666  1.00 25.84           C  
ATOM   4402  O   SER D  58      -0.273  26.037   6.746  1.00 21.63           O  
ATOM   4403  CB  SER D  58      -1.939  26.089   9.399  1.00 20.87           C  
ATOM   4404  OG  SER D  58      -2.752  25.003   8.992  1.00 22.07           O  
ATOM   4405  N   GLY D  59      -0.490  23.928   7.500  1.00 26.37           N  
ATOM   4406  CA  GLY D  59      -0.495  23.372   6.175  1.00 25.11           C  
ATOM   4407  C   GLY D  59      -1.911  23.243   5.622  1.00 20.91           C  
ATOM   4408  O   GLY D  59      -2.072  22.709   4.555  1.00 20.53           O  
ATOM   4409  N   ARG D  60      -2.927  23.689   6.365  1.00 27.02           N  
ATOM   4410  CA  ARG D  60      -4.313  23.625   5.932  1.00 26.37           C  
ATOM   4411  C   ARG D  60      -4.758  25.061   5.847  1.00 29.08           C  
ATOM   4412  O   ARG D  60      -4.679  25.780   6.822  1.00 38.99           O  
ATOM   4413  CB  ARG D  60      -5.216  22.959   6.969  1.00 24.98           C  
ATOM   4414  CG  ARG D  60      -5.308  21.516   6.923  1.00 26.80           C  
ATOM   4415  CD  ARG D  60      -5.931  20.942   8.205  1.00 31.06           C  
ATOM   4416  NE  ARG D  60      -5.117  19.791   8.563  1.00 36.88           N  
ATOM   4417  CZ  ARG D  60      -3.898  19.895   9.096  1.00 29.41           C  
ATOM   4418  NH1 ARG D  60      -3.383  21.072   9.375  1.00 37.55           N  
ATOM   4419  NH2 ARG D  60      -3.124  18.834   9.183  1.00 39.20           N  
ATOM   4420  N   ASP D  61      -5.217  25.512   4.703  1.00 28.58           N  
ATOM   4421  CA  ASP D  61      -5.671  26.884   4.636  1.00 28.66           C  
ATOM   4422  C   ASP D  61      -7.202  26.696   4.667  1.00 27.73           C  
ATOM   4423  O   ASP D  61      -7.709  25.655   4.221  1.00 36.10           O  
ATOM   4424  CB  ASP D  61      -5.124  27.529   3.343  1.00 25.77           C  
ATOM   4425  CG  ASP D  61      -5.512  29.007   3.198  1.00 23.29           C  
ATOM   4426  OD1 ASP D  61      -4.919  29.722   2.372  1.00 29.00           O  
ATOM   4427  OD2 ASP D  61      -6.432  29.446   3.894  1.00 30.59           O  
ATOM   4428  N   SER D  62      -7.928  27.583   5.337  1.00 15.93           N  
ATOM   4429  CA  SER D  62      -9.374  27.534   5.306  1.00 11.72           C  
ATOM   4430  C   SER D  62      -9.818  28.928   5.682  1.00 15.24           C  
ATOM   4431  O   SER D  62      -9.131  29.664   6.391  1.00 14.32           O  
ATOM   4432  CB  SER D  62      -9.977  26.548   6.328  1.00 18.34           C  
ATOM   4433  OG  SER D  62      -9.646  26.984   7.619  1.00 17.21           O  
ATOM   4434  N   PRO D  63     -10.972  29.323   5.178  1.00 15.79           N  
ATOM   4435  CA  PRO D  63     -11.477  30.650   5.514  1.00 15.83           C  
ATOM   4436  C   PRO D  63     -11.796  30.709   6.997  1.00 13.73           C  
ATOM   4437  O   PRO D  63     -11.841  31.770   7.540  1.00 13.30           O  
ATOM   4438  CB  PRO D  63     -12.763  30.795   4.700  1.00 18.84           C  
ATOM   4439  CG  PRO D  63     -12.801  29.543   3.823  1.00 28.15           C  
ATOM   4440  CD  PRO D  63     -11.518  28.818   3.916  1.00 22.42           C  
ATOM   4441  N   ILE D  64     -12.046  29.561   7.633  1.00 12.85           N  
ATOM   4442  CA  ILE D  64     -12.355  29.534   9.064  1.00 14.68           C  
ATOM   4443  C   ILE D  64     -11.123  29.943   9.871  1.00 13.49           C  
ATOM   4444  O   ILE D  64     -11.223  30.776  10.789  1.00 13.52           O  
ATOM   4445  CB  ILE D  64     -12.771  28.084   9.540  1.00 12.56           C  
ATOM   4446  CG1 ILE D  64     -14.002  27.586   8.762  1.00 13.39           C  
ATOM   4447  CG2 ILE D  64     -13.022  28.063  11.069  1.00 11.26           C  
ATOM   4448  CD1 ILE D  64     -14.300  26.097   9.087  1.00 14.17           C  
ATOM   4449  N   LEU D  65      -9.987  29.340   9.510  1.00 12.68           N  
ATOM   4450  CA  LEU D  65      -8.744  29.647  10.209  1.00 18.94           C  
ATOM   4451  C   LEU D  65      -8.440  31.144   9.964  1.00 17.70           C  
ATOM   4452  O   LEU D  65      -8.048  31.870  10.879  1.00 17.09           O  
ATOM   4453  CB  LEU D  65      -7.609  28.743   9.678  1.00 13.09           C  
ATOM   4454  CG  LEU D  65      -6.223  29.171  10.232  1.00 13.81           C  
ATOM   4455  CD1 LEU D  65      -6.172  29.216  11.786  1.00 12.96           C  
ATOM   4456  CD2 LEU D  65      -5.224  28.129   9.715  1.00 16.47           C  
ATOM   4457  N   ARG D  66      -8.604  31.612   8.724  1.00 15.74           N  
ATOM   4458  CA  ARG D  66      -8.359  33.024   8.458  1.00 19.57           C  
ATOM   4459  C   ARG D  66      -9.303  33.924   9.266  1.00 16.17           C  
ATOM   4460  O   ARG D  66      -8.928  35.009   9.664  1.00 15.13           O  
ATOM   4461  CB  ARG D  66      -8.512  33.322   6.948  1.00 19.30           C  
ATOM   4462  CG  ARG D  66      -7.325  32.787   6.178  1.00 14.20           C  
ATOM   4463  CD  ARG D  66      -7.572  32.676   4.672  1.00 20.39           C  
ATOM   4464  NE  ARG D  66      -6.351  32.161   4.039  1.00 25.18           N  
ATOM   4465  CZ  ARG D  66      -5.261  32.907   3.835  1.00 18.56           C  
ATOM   4466  NH1 ARG D  66      -5.264  34.177   4.206  1.00 19.83           N  
ATOM   4467  NH2 ARG D  66      -4.179  32.390   3.250  1.00 18.08           N  
ATOM   4468  N   ARG D  67     -10.550  33.533   9.458  1.00 10.88           N  
ATOM   4469  CA  ARG D  67     -11.407  34.399  10.285  1.00 18.54           C  
ATOM   4470  C   ARG D  67     -10.865  34.484  11.702  1.00 18.99           C  
ATOM   4471  O   ARG D  67     -10.908  35.572  12.339  1.00 16.08           O  
ATOM   4472  CB  ARG D  67     -12.841  33.866  10.348  1.00 19.50           C  
ATOM   4473  CG  ARG D  67     -13.806  34.690  11.220  1.00 20.98           C  
ATOM   4474  CD  ARG D  67     -13.720  36.221  10.972  1.00 16.45           C  
ATOM   4475  NE  ARG D  67     -14.665  36.963  11.832  1.00 20.47           N  
ATOM   4476  CZ  ARG D  67     -15.815  37.470  11.390  1.00 31.16           C  
ATOM   4477  NH1 ARG D  67     -16.132  37.308  10.101  1.00 24.22           N  
ATOM   4478  NH2 ARG D  67     -16.646  38.155  12.213  1.00 29.55           N  
ATOM   4479  N   ARG D  68     -10.409  33.343  12.241  1.00 17.87           N  
ATOM   4480  CA  ARG D  68      -9.859  33.345  13.625  1.00 12.98           C  
ATOM   4481  C   ARG D  68      -8.595  34.246  13.717  1.00 16.37           C  
ATOM   4482  O   ARG D  68      -8.430  35.020  14.678  1.00 19.17           O  
ATOM   4483  CB  ARG D  68      -9.473  31.923  14.064  1.00 12.68           C  
ATOM   4484  CG  ARG D  68      -8.850  31.899  15.451  1.00 14.65           C  
ATOM   4485  CD  ARG D  68      -9.847  32.333  16.559  1.00 16.44           C  
ATOM   4486  NE  ARG D  68      -9.301  32.069  17.906  1.00 16.50           N  
ATOM   4487  CZ  ARG D  68      -9.690  32.707  19.020  1.00 16.05           C  
ATOM   4488  NH1 ARG D  68     -10.624  33.634  18.967  1.00 14.34           N  
ATOM   4489  NH2 ARG D  68      -9.122  32.429  20.173  1.00 16.94           N  
ATOM   4490  N   ILE D  69      -7.718  34.122  12.731  1.00 14.62           N  
ATOM   4491  CA  ILE D  69      -6.513  34.968  12.678  1.00 14.78           C  
ATOM   4492  C   ILE D  69      -6.967  36.439  12.677  1.00 22.90           C  
ATOM   4493  O   ILE D  69      -6.415  37.285  13.413  1.00 15.68           O  
ATOM   4494  CB  ILE D  69      -5.735  34.672  11.403  1.00 13.32           C  
ATOM   4495  CG1 ILE D  69      -5.061  33.317  11.546  1.00 18.00           C  
ATOM   4496  CG2 ILE D  69      -4.723  35.844  11.037  1.00 18.31           C  
ATOM   4497  CD1 ILE D  69      -4.420  32.816  10.211  1.00 19.84           C  
ATOM   4498  N   ALA D  70      -7.965  36.767  11.854  1.00 15.57           N  
ATOM   4499  CA  ALA D  70      -8.417  38.152  11.784  1.00 21.34           C  
ATOM   4500  C   ALA D  70      -8.959  38.631  13.097  1.00 20.47           C  
ATOM   4501  O   ALA D  70      -8.669  39.744  13.521  1.00 18.04           O  
ATOM   4502  CB  ALA D  70      -9.495  38.328  10.707  1.00 20.79           C  
ATOM   4503  N   ASP D  71      -9.792  37.819  13.729  1.00 12.32           N  
ATOM   4504  CA  ASP D  71     -10.336  38.212  15.004  1.00 16.80           C  
ATOM   4505  C   ASP D  71      -9.247  38.476  16.038  1.00 21.95           C  
ATOM   4506  O   ASP D  71      -9.419  39.367  16.914  1.00 21.99           O  
ATOM   4507  CB  ASP D  71     -11.209  37.120  15.553  1.00 17.41           C  
ATOM   4508  CG  ASP D  71     -12.604  37.105  14.932  1.00 22.34           C  
ATOM   4509  OD1 ASP D  71     -12.872  37.907  13.974  1.00 21.53           O  
ATOM   4510  OD2 ASP D  71     -13.411  36.276  15.433  1.00 20.53           O  
ATOM   4511  N   LEU D  72      -8.158  37.697  15.977  1.00 16.18           N  
ATOM   4512  CA  LEU D  72      -7.085  37.864  16.995  1.00 12.32           C  
ATOM   4513  C   LEU D  72      -6.057  38.933  16.677  1.00 20.79           C  
ATOM   4514  O   LEU D  72      -5.099  39.170  17.446  1.00 20.83           O  
ATOM   4515  CB  LEU D  72      -6.349  36.546  17.222  1.00 23.31           C  
ATOM   4516  CG  LEU D  72      -7.149  35.440  17.914  1.00 22.46           C  
ATOM   4517  CD1 LEU D  72      -6.295  34.189  17.880  1.00 29.01           C  
ATOM   4518  CD2 LEU D  72      -7.592  35.862  19.366  1.00 13.91           C  
ATOM   4519  N   GLY D  73      -6.192  39.521  15.496  1.00 22.53           N  
ATOM   4520  CA  GLY D  73      -5.243  40.542  15.120  1.00 27.50           C  
ATOM   4521  C   GLY D  73      -3.874  39.959  14.846  1.00 23.50           C  
ATOM   4522  O   GLY D  73      -2.908  40.655  14.947  1.00 25.39           O  
ATOM   4523  N   ILE D  74      -3.799  38.683  14.512  1.00 19.00           N  
ATOM   4524  CA  ILE D  74      -2.508  38.084  14.194  1.00 24.32           C  
ATOM   4525  C   ILE D  74      -2.065  38.628  12.847  1.00 21.92           C  
ATOM   4526  O   ILE D  74      -2.788  38.585  11.857  1.00 20.23           O  
ATOM   4527  CB  ILE D  74      -2.592  36.564  14.171  1.00 18.00           C  
ATOM   4528  CG1 ILE D  74      -2.734  36.096  15.635  1.00 21.44           C  
ATOM   4529  CG2 ILE D  74      -1.347  35.986  13.466  1.00 24.74           C  
ATOM   4530  CD1 ILE D  74      -2.899  34.614  15.814  1.00 23.29           C  
ATOM   4531  N   LYS D  75      -0.856  39.133  12.812  1.00 17.22           N  
ATOM   4532  CA  LYS D  75      -0.371  39.810  11.612  1.00 22.71           C  
ATOM   4533  C   LYS D  75       0.502  39.008  10.674  1.00 26.61           C  
ATOM   4534  O   LYS D  75       0.690  39.381   9.513  1.00 21.41           O  
ATOM   4535  CB  LYS D  75       0.390  41.093  12.052  1.00 25.98           C  
ATOM   4536  CG  LYS D  75      -0.340  41.964  13.063  1.00 29.53           C  
ATOM   4537  CD  LYS D  75       0.582  43.064  13.624  1.00 35.15           C  
ATOM   4538  CE  LYS D  75      -0.088  43.916  14.743  1.00 36.35           C  
ATOM   4539  NZ  LYS D  75       0.789  45.045  15.238  1.00 37.13           N  
ATOM   4540  N   LEU D  76       1.028  37.891  11.159  1.00 14.96           N  
ATOM   4541  CA  LEU D  76       1.947  37.096  10.373  1.00 17.19           C  
ATOM   4542  C   LEU D  76       1.489  35.700  10.293  1.00 20.43           C  
ATOM   4543  O   LEU D  76       1.136  35.138  11.308  1.00 17.03           O  
ATOM   4544  CB  LEU D  76       3.308  37.093  11.050  1.00 15.94           C  
ATOM   4545  CG  LEU D  76       3.853  38.514  11.240  1.00 24.30           C  
ATOM   4546  CD1 LEU D  76       5.016  38.510  12.234  1.00 25.07           C  
ATOM   4547  CD2 LEU D  76       4.256  39.045   9.851  1.00 26.66           C  
ATOM   4548  N   PHE D  77       1.551  35.125   9.096  1.00 16.07           N  
ATOM   4549  CA  PHE D  77       1.169  33.746   8.948  1.00 21.57           C  
ATOM   4550  C   PHE D  77       1.498  33.147   7.629  1.00 16.62           C  
ATOM   4551  O   PHE D  77       1.660  33.829   6.614  1.00 19.10           O  
ATOM   4552  CB  PHE D  77      -0.323  33.544   9.221  1.00 19.38           C  
ATOM   4553  CG  PHE D  77      -1.209  34.512   8.532  1.00 25.73           C  
ATOM   4554  CD1 PHE D  77      -1.694  34.242   7.264  1.00 24.93           C  
ATOM   4555  CD2 PHE D  77      -1.589  35.694   9.173  1.00 19.33           C  
ATOM   4556  CE1 PHE D  77      -2.540  35.118   6.644  1.00 15.91           C  
ATOM   4557  CE2 PHE D  77      -2.452  36.595   8.556  1.00 20.44           C  
ATOM   4558  CZ  PHE D  77      -2.926  36.296   7.282  1.00 22.58           C  
ATOM   4559  N   PHE D  78       1.569  31.838   7.650  1.00 17.33           N  
ATOM   4560  CA  PHE D  78       1.858  31.080   6.450  1.00 18.89           C  
ATOM   4561  C   PHE D  78       0.873  29.914   6.410  1.00 24.79           C  
ATOM   4562  O   PHE D  78       1.020  28.933   7.114  1.00 17.35           O  
ATOM   4563  CB  PHE D  78       3.311  30.659   6.554  1.00 19.36           C  
ATOM   4564  CG  PHE D  78       3.938  30.309   5.238  1.00 34.88           C  
ATOM   4565  CD1 PHE D  78       5.194  30.809   4.918  1.00 33.27           C  
ATOM   4566  CD2 PHE D  78       3.253  29.502   4.306  1.00 30.52           C  
ATOM   4567  CE1 PHE D  78       5.767  30.524   3.702  1.00 35.73           C  
ATOM   4568  CE2 PHE D  78       3.830  29.213   3.067  1.00 35.01           C  
ATOM   4569  CZ  PHE D  78       5.085  29.723   2.768  1.00 33.59           C  
ATOM   4570  N   LEU D  79      -0.151  30.022   5.574  1.00 15.13           N  
ATOM   4571  CA  LEU D  79      -1.166  28.991   5.506  1.00 16.65           C  
ATOM   4572  C   LEU D  79      -1.050  28.231   4.215  1.00 21.79           C  
ATOM   4573  O   LEU D  79      -0.809  28.852   3.190  1.00 22.00           O  
ATOM   4574  CB  LEU D  79      -2.548  29.657   5.598  1.00 22.58           C  
ATOM   4575  CG  LEU D  79      -2.695  30.617   6.806  1.00 22.24           C  
ATOM   4576  CD1 LEU D  79      -4.127  31.003   6.891  1.00 20.12           C  
ATOM   4577  CD2 LEU D  79      -2.240  29.966   8.128  1.00 19.63           C  
ATOM   4578  N   GLY D  80      -1.248  26.912   4.295  1.00 23.35           N  
ATOM   4579  CA  GLY D  80      -1.199  26.054   3.129  1.00 26.00           C  
ATOM   4580  C   GLY D  80       0.049  25.196   2.918  1.00 31.15           C  
ATOM   4581  O   GLY D  80       0.012  24.272   2.069  1.00 30.85           O  
ATOM   4582  N   LYS D  81       1.133  25.427   3.665  1.00 23.62           N  
ATOM   4583  CA  LYS D  81       2.359  24.652   3.385  1.00 38.04           C  
ATOM   4584  C   LYS D  81       2.858  23.614   4.367  1.00 40.52           C  
ATOM   4585  O   LYS D  81       3.005  23.844   5.615  1.00 40.45           O  
ATOM   4586  CB  LYS D  81       3.555  25.572   3.007  1.00 37.47           C  
ATOM   4587  CG  LYS D  81       4.756  24.806   2.313  1.00 34.45           C  
ATOM   4588  CD  LYS D  81       5.801  25.813   1.691  1.00 31.77           C  
ATOM   4589  CE  LYS D  81       6.840  26.237   2.702  1.00 31.46           C  
ATOM   4590  NZ  LYS D  81       7.347  27.659   2.488  1.00 38.65           N  
ATOM   4591  N   LEU D  82       3.174  22.470   3.761  1.00 39.13           N  
ATOM   4592  CA  LEU D  82       3.651  21.293   4.480  1.00 38.01           C  
ATOM   4593  C   LEU D  82       5.113  21.364   4.854  1.00 35.74           C  
ATOM   4594  O   LEU D  82       5.523  20.609   5.770  1.00 35.97           O  
ATOM   4595  CB  LEU D  82       3.392  20.033   3.653  0.00 32.80           C  
ATOM   4596  CG  LEU D  82       1.922  19.748   3.334  0.00 31.95           C  
ATOM   4597  CD1 LEU D  82       1.813  18.454   2.547  0.00 31.25           C  
ATOM   4598  CD2 LEU D  82       1.122  19.657   4.625  0.00 31.33           C  
ATOM   4599  N   GLU D  83       5.895  22.249   4.185  1.00 34.69           N  
ATOM   4600  CA  GLU D  83       7.319  22.361   4.529  1.00 30.28           C  
ATOM   4601  C   GLU D  83       7.634  23.519   5.475  1.00 26.47           C  
ATOM   4602  O   GLU D  83       8.061  24.618   5.125  1.00 23.41           O  
ATOM   4603  CB  GLU D  83       8.226  22.396   3.313  1.00 39.41           C  
ATOM   4604  CG  GLU D  83       9.507  21.631   3.665  1.00 39.98           C  
ATOM   4605  CD  GLU D  83      10.538  22.497   4.388  1.00 41.21           C  
ATOM   4606  OE1 GLU D  83      11.430  23.029   3.691  1.00 40.30           O  
ATOM   4607  OE2 GLU D  83      10.466  22.648   5.641  1.00 46.51           O  
ATOM   4608  N   LYS D  84       7.423  23.191   6.725  1.00 29.47           N  
ATOM   4609  CA  LYS D  84       7.542  24.145   7.782  1.00 25.10           C  
ATOM   4610  C   LYS D  84       8.883  24.743   8.067  1.00 21.02           C  
ATOM   4611  O   LYS D  84       8.935  25.858   8.545  1.00 20.45           O  
ATOM   4612  CB  LYS D  84       6.970  23.526   9.042  1.00 17.66           C  
ATOM   4613  CG  LYS D  84       5.525  23.178   8.807  1.00 15.15           C  
ATOM   4614  CD  LYS D  84       4.818  22.878  10.102  1.00 23.33           C  
ATOM   4615  CE  LYS D  84       3.405  22.466   9.811  1.00 25.03           C  
ATOM   4616  NZ  LYS D  84       2.715  22.080  11.053  1.00 28.77           N  
ATOM   4617  N   GLU D  85       9.970  24.006   7.864  1.00 14.83           N  
ATOM   4618  CA  GLU D  85      11.258  24.607   8.157  1.00 16.58           C  
ATOM   4619  C   GLU D  85      11.423  25.866   7.279  1.00 19.59           C  
ATOM   4620  O   GLU D  85      11.906  26.900   7.737  1.00 21.34           O  
ATOM   4621  CB  GLU D  85      12.367  23.600   7.830  1.00 26.20           C  
ATOM   4622  CG  GLU D  85      13.773  24.183   7.629  1.00 32.44           C  
ATOM   4623  CD  GLU D  85      14.700  23.125   7.012  1.00 31.65           C  
ATOM   4624  OE1 GLU D  85      15.512  22.517   7.758  1.00 38.48           O  
ATOM   4625  OE2 GLU D  85      14.573  22.872   5.777  1.00 37.85           O  
ATOM   4626  N   THR D  86      11.075  25.777   6.003  1.00 22.72           N  
ATOM   4627  CA  THR D  86      11.203  26.928   5.094  1.00 20.36           C  
ATOM   4628  C   THR D  86      10.269  28.036   5.512  1.00 19.21           C  
ATOM   4629  O   THR D  86      10.569  29.233   5.417  1.00 18.09           O  
ATOM   4630  CB  THR D  86      10.769  26.586   3.639  1.00 20.05           C  
ATOM   4631  OG1 THR D  86      11.499  25.453   3.144  1.00 35.27           O  
ATOM   4632  CG2 THR D  86      11.044  27.777   2.726  1.00 26.92           C  
ATOM   4633  N   ALA D  87       9.070  27.621   5.888  1.00 15.03           N  
ATOM   4634  CA  ALA D  87       8.083  28.577   6.322  1.00 15.44           C  
ATOM   4635  C   ALA D  87       8.633  29.269   7.571  1.00 15.44           C  
ATOM   4636  O   ALA D  87       8.476  30.473   7.668  1.00 17.45           O  
ATOM   4637  CB  ALA D  87       6.706  27.838   6.589  1.00 16.18           C  
ATOM   4638  N   CYS D  88       9.336  28.542   8.472  1.00 18.34           N  
ATOM   4639  CA  CYS D  88       9.870  29.165   9.690  1.00 18.91           C  
ATOM   4640  C   CYS D  88      10.811  30.303   9.304  1.00 16.99           C  
ATOM   4641  O   CYS D  88      10.648  31.432   9.751  1.00 14.01           O  
ATOM   4642  CB  CYS D  88      10.616  28.156  10.587  1.00 16.54           C  
ATOM   4643  SG  CYS D  88       9.515  27.040  11.448  1.00 21.28           S  
ATOM   4644  N   PHE D  89      11.733  30.011   8.400  1.00 13.59           N  
ATOM   4645  CA  PHE D  89      12.683  31.057   7.989  1.00 13.97           C  
ATOM   4646  C   PHE D  89      12.067  32.222   7.288  1.00 23.20           C  
ATOM   4647  O   PHE D  89      12.447  33.386   7.507  1.00 17.51           O  
ATOM   4648  CB  PHE D  89      13.782  30.385   7.176  1.00 20.83           C  
ATOM   4649  CG  PHE D  89      14.700  29.544   8.069  1.00 28.72           C  
ATOM   4650  CD1 PHE D  89      15.260  30.118   9.224  1.00 30.99           C  
ATOM   4651  CD2 PHE D  89      14.939  28.207   7.826  1.00 30.99           C  
ATOM   4652  CE1 PHE D  89      16.038  29.370  10.120  1.00 24.29           C  
ATOM   4653  CE2 PHE D  89      15.729  27.452   8.726  1.00 29.80           C  
ATOM   4654  CZ  PHE D  89      16.269  28.041   9.860  1.00 27.94           C  
ATOM   4655  N   ASP D  90      11.072  31.956   6.443  1.00 19.30           N  
ATOM   4656  CA  ASP D  90      10.443  33.062   5.749  1.00 18.59           C  
ATOM   4657  C   ASP D  90       9.688  33.965   6.722  1.00 18.75           C  
ATOM   4658  O   ASP D  90       9.649  35.186   6.541  1.00 16.96           O  
ATOM   4659  CB  ASP D  90       9.463  32.565   4.673  1.00 17.98           C  
ATOM   4660  CG  ASP D  90      10.180  31.979   3.424  1.00 25.52           C  
ATOM   4661  OD1 ASP D  90       9.536  31.208   2.679  1.00 21.76           O  
ATOM   4662  OD2 ASP D  90      11.382  32.291   3.189  1.00 21.04           O  
ATOM   4663  N   LEU D  91       9.075  33.342   7.725  1.00 15.12           N  
ATOM   4664  CA  LEU D  91       8.338  34.081   8.739  1.00 15.27           C  
ATOM   4665  C   LEU D  91       9.315  34.900   9.643  1.00 12.85           C  
ATOM   4666  O   LEU D  91       9.006  36.057  10.071  1.00 15.83           O  
ATOM   4667  CB  LEU D  91       7.487  33.124   9.610  1.00 16.95           C  
ATOM   4668  CG  LEU D  91       6.163  32.610   8.979  1.00 17.74           C  
ATOM   4669  CD1 LEU D  91       5.500  31.494   9.813  1.00 18.93           C  
ATOM   4670  CD2 LEU D  91       5.251  33.801   8.790  1.00 15.51           C  
ATOM   4671  N   MET D  92      10.422  34.269  10.016  1.00 11.85           N  
ATOM   4672  CA  MET D  92      11.426  34.987  10.820  1.00 12.53           C  
ATOM   4673  C   MET D  92      11.870  36.234  10.069  1.00 19.69           C  
ATOM   4674  O   MET D  92      11.971  37.302  10.643  1.00 19.42           O  
ATOM   4675  CB  MET D  92      12.620  34.077  11.126  1.00 17.64           C  
ATOM   4676  CG  MET D  92      12.320  33.016  12.195  1.00 15.94           C  
ATOM   4677  SD  MET D  92      13.618  31.924  12.114  1.00 22.78           S  
ATOM   4678  CE  MET D  92      12.956  30.648  12.969  1.00 21.25           C  
ATOM   4679  N   LYS D  93      12.066  36.111   8.756  1.00 18.74           N  
ATOM   4680  CA  LYS D  93      12.508  37.264   7.941  1.00 18.21           C  
ATOM   4681  C   LYS D  93      11.418  38.342   7.933  1.00 15.46           C  
ATOM   4682  O   LYS D  93      11.682  39.524   8.077  1.00 22.62           O  
ATOM   4683  CB  LYS D  93      12.885  36.788   6.501  1.00 20.96           C  
ATOM   4684  CG  LYS D  93      13.875  37.708   5.781  1.00 35.28           C  
ATOM   4685  CD  LYS D  93      14.467  37.054   4.534  1.00 35.55           C  
ATOM   4686  CE  LYS D  93      15.988  37.106   4.556  0.00 31.52           C  
ATOM   4687  NZ  LYS D  93      16.596  36.252   3.496  0.00 31.33           N  
ATOM   4688  N   GLN D  94      10.157  37.943   7.774  1.00 17.86           N  
ATOM   4689  CA  GLN D  94       9.080  38.924   7.799  1.00 17.25           C  
ATOM   4690  C   GLN D  94       9.027  39.629   9.164  1.00 14.62           C  
ATOM   4691  O   GLN D  94       8.716  40.806   9.268  1.00 14.82           O  
ATOM   4692  CB  GLN D  94       7.746  38.229   7.576  1.00 20.81           C  
ATOM   4693  CG  GLN D  94       7.539  37.742   6.173  1.00 23.61           C  
ATOM   4694  CD  GLN D  94       6.091  37.229   5.999  1.00 21.27           C  
ATOM   4695  OE1 GLN D  94       5.818  36.248   5.268  1.00 24.04           O  
ATOM   4696  NE2 GLN D  94       5.173  37.878   6.673  1.00 12.12           N  
ATOM   4697  N   ALA D  95       9.309  38.864  10.206  1.00 18.14           N  
ATOM   4698  CA  ALA D  95       9.264  39.411  11.552  1.00 15.60           C  
ATOM   4699  C   ALA D  95      10.480  40.252  11.933  1.00 19.71           C  
ATOM   4700  O   ALA D  95      10.444  41.002  12.929  1.00 20.15           O  
ATOM   4701  CB  ALA D  95       9.123  38.284  12.577  1.00 15.89           C  
ATOM   4702  N   GLY D  96      11.559  40.089  11.200  1.00 14.28           N  
ATOM   4703  CA  GLY D  96      12.775  40.830  11.513  1.00 21.77           C  
ATOM   4704  C   GLY D  96      13.551  40.246  12.702  1.00 20.88           C  
ATOM   4705  O   GLY D  96      14.331  40.964  13.351  1.00 25.15           O  
ATOM   4706  N   VAL D  97      13.389  38.942  12.980  1.00 16.38           N  
ATOM   4707  CA  VAL D  97      14.060  38.288  14.091  1.00 15.75           C  
ATOM   4708  C   VAL D  97      14.902  37.121  13.660  1.00 15.28           C  
ATOM   4709  O   VAL D  97      14.760  36.581  12.558  1.00 24.56           O  
ATOM   4710  CB  VAL D  97      13.041  37.739  15.074  1.00 25.63           C  
ATOM   4711  CG1 VAL D  97      12.152  38.842  15.580  1.00 19.34           C  
ATOM   4712  CG2 VAL D  97      12.211  36.662  14.345  1.00 13.80           C  
ATOM   4713  N   THR D  98      15.814  36.718  14.530  1.00 18.73           N  
ATOM   4714  CA  THR D  98      16.669  35.605  14.223  1.00 17.49           C  
ATOM   4715  C   THR D  98      15.995  34.358  14.809  1.00 15.36           C  
ATOM   4716  O   THR D  98      15.069  34.426  15.585  1.00 20.67           O  
ATOM   4717  CB  THR D  98      18.068  35.703  14.960  1.00 22.86           C  
ATOM   4718  OG1 THR D  98      17.841  35.585  16.372  1.00 21.65           O  
ATOM   4719  CG2 THR D  98      18.789  37.058  14.672  1.00 25.03           C  
ATOM   4720  N   ALA D  99      16.500  33.216  14.439  1.00 20.47           N  
ATOM   4721  CA  ALA D  99      15.969  31.981  14.968  1.00 22.99           C  
ATOM   4722  C   ALA D  99      16.154  31.901  16.473  1.00 20.07           C  
ATOM   4723  O   ALA D  99      15.259  31.442  17.173  1.00 18.26           O  
ATOM   4724  CB  ALA D  99      16.637  30.792  14.306  1.00 22.36           C  
ATOM   4725  N   GLU D 100      17.300  32.363  16.994  1.00 17.72           N  
ATOM   4726  CA  GLU D 100      17.492  32.231  18.438  1.00 19.98           C  
ATOM   4727  C   GLU D 100      16.486  33.084  19.203  1.00 20.33           C  
ATOM   4728  O   GLU D 100      16.305  32.910  20.414  1.00 27.63           O  
ATOM   4729  CB  GLU D 100      18.937  32.586  18.875  1.00 26.01           C  
ATOM   4730  CG  GLU D 100      19.126  32.644  20.468  1.00 35.26           C  
ATOM   4731  CD  GLU D 100      19.072  31.279  21.257  1.00 37.58           C  
ATOM   4732  OE1 GLU D 100      20.121  30.597  21.334  1.00 36.54           O  
ATOM   4733  OE2 GLU D 100      17.978  30.886  21.817  1.00 40.62           O  
ATOM   4734  N   GLN D 101      15.823  33.995  18.520  1.00 17.10           N  
ATOM   4735  CA  GLN D 101      14.854  34.857  19.183  1.00 17.64           C  
ATOM   4736  C   GLN D 101      13.451  34.338  18.918  1.00 17.57           C  
ATOM   4737  O   GLN D 101      12.505  34.988  19.257  1.00 17.68           O  
ATOM   4738  CB  GLN D 101      14.929  36.321  18.676  1.00 25.19           C  
ATOM   4739  CG  GLN D 101      16.319  36.980  18.903  1.00 24.35           C  
ATOM   4740  CD  GLN D 101      16.568  38.312  18.147  1.00 32.47           C  
ATOM   4741  OE1 GLN D 101      15.942  38.640  17.114  1.00 27.96           O  
ATOM   4742  NE2 GLN D 101      17.537  39.059  18.645  1.00 30.69           N  
ATOM   4743  N   THR D 102      13.335  33.175  18.289  1.00 20.89           N  
ATOM   4744  CA  THR D 102      11.992  32.667  17.929  1.00 11.99           C  
ATOM   4745  C   THR D 102      11.719  31.337  18.585  1.00 12.86           C  
ATOM   4746  O   THR D 102      12.613  30.481  18.660  1.00 19.88           O  
ATOM   4747  CB  THR D 102      11.967  32.435  16.386  1.00 17.52           C  
ATOM   4748  OG1 THR D 102      12.337  33.658  15.743  1.00 16.42           O  
ATOM   4749  CG2 THR D 102      10.581  31.976  15.874  1.00 18.56           C  
ATOM   4750  N   ALA D 103      10.486  31.163  19.033  1.00 13.85           N  
ATOM   4751  CA  ALA D 103      10.063  29.928  19.672  1.00 16.25           C  
ATOM   4752  C   ALA D 103       8.955  29.359  18.811  1.00 10.35           C  
ATOM   4753  O   ALA D 103       8.167  30.139  18.200  1.00 13.85           O  
ATOM   4754  CB  ALA D 103       9.442  30.199  21.099  1.00 15.63           C  
ATOM   4755  N   TYR D 104       8.849  28.031  18.854  1.00 11.49           N  
ATOM   4756  CA  TYR D 104       7.828  27.322  18.077  1.00 10.55           C  
ATOM   4757  C   TYR D 104       7.097  26.358  18.997  1.00 12.49           C  
ATOM   4758  O   TYR D 104       7.708  25.847  19.954  1.00 16.63           O  
ATOM   4759  CB  TYR D 104       8.507  26.506  16.947  1.00 12.71           C  
ATOM   4760  CG  TYR D 104       7.528  25.930  15.974  1.00 15.16           C  
ATOM   4761  CD1 TYR D 104       7.205  26.626  14.833  1.00 12.31           C  
ATOM   4762  CD2 TYR D 104       6.909  24.696  16.231  1.00 11.18           C  
ATOM   4763  CE1 TYR D 104       6.230  26.089  13.923  1.00 11.68           C  
ATOM   4764  CE2 TYR D 104       5.934  24.126  15.290  1.00  7.93           C  
ATOM   4765  CZ  TYR D 104       5.627  24.861  14.167  1.00 15.91           C  
ATOM   4766  OH  TYR D 104       4.726  24.264  13.332  1.00 13.96           O  
ATOM   4767  N   ILE D 105       5.815  26.131  18.711  1.00 10.97           N  
ATOM   4768  CA  ILE D 105       5.017  25.179  19.498  1.00 16.86           C  
ATOM   4769  C   ILE D 105       4.299  24.317  18.479  1.00 17.58           C  
ATOM   4770  O   ILE D 105       3.696  24.838  17.537  1.00 17.79           O  
ATOM   4771  CB  ILE D 105       4.033  25.859  20.490  1.00 15.09           C  
ATOM   4772  CG1 ILE D 105       3.221  24.790  21.236  1.00 10.65           C  
ATOM   4773  CG2 ILE D 105       3.207  26.954  19.825  1.00 17.18           C  
ATOM   4774  CD1 ILE D 105       2.338  25.468  22.274  1.00 11.70           C  
ATOM   4775  N   GLY D 106       4.446  23.015  18.655  1.00 16.58           N  
ATOM   4776  CA  GLY D 106       3.878  22.064  17.703  1.00 11.02           C  
ATOM   4777  C   GLY D 106       3.396  20.793  18.324  1.00 16.58           C  
ATOM   4778  O   GLY D 106       3.527  20.627  19.537  1.00 13.80           O  
ATOM   4779  N   ASP D 107       2.790  19.903  17.521  1.00 10.01           N  
ATOM   4780  CA  ASP D 107       2.353  18.649  18.093  1.00 11.07           C  
ATOM   4781  C   ASP D 107       2.721  17.333  17.366  1.00  9.86           C  
ATOM   4782  O   ASP D 107       2.445  16.235  17.882  1.00 12.39           O  
ATOM   4783  CB  ASP D 107       0.823  18.686  18.201  1.00 13.90           C  
ATOM   4784  CG  ASP D 107       0.166  18.579  16.811  1.00 12.62           C  
ATOM   4785  OD1 ASP D 107      -0.743  17.717  16.601  1.00 11.12           O  
ATOM   4786  OD2 ASP D 107       0.591  19.425  16.001  1.00 10.78           O  
ATOM   4787  N   ASP D 108       3.258  17.439  16.160  1.00 14.91           N  
ATOM   4788  CA  ASP D 108       3.480  16.205  15.373  1.00 11.62           C  
ATOM   4789  C   ASP D 108       4.758  16.226  14.574  1.00 10.42           C  
ATOM   4790  O   ASP D 108       5.540  17.201  14.599  1.00 11.97           O  
ATOM   4791  CB  ASP D 108       2.275  16.041  14.417  1.00 19.56           C  
ATOM   4792  CG  ASP D 108       2.003  14.587  14.034  1.00 16.10           C  
ATOM   4793  OD1 ASP D 108       1.033  14.345  13.286  1.00 15.78           O  
ATOM   4794  OD2 ASP D 108       2.745  13.701  14.501  1.00 19.13           O  
ATOM   4795  N   SER D 109       4.962  15.154  13.826  1.00 14.55           N  
ATOM   4796  CA  SER D 109       6.166  14.956  13.048  1.00 20.32           C  
ATOM   4797  C   SER D 109       6.523  16.074  12.126  1.00 22.17           C  
ATOM   4798  O   SER D 109       7.717  16.389  11.939  1.00 17.62           O  
ATOM   4799  CB  SER D 109       6.015  13.656  12.281  1.00 11.01           C  
ATOM   4800  OG  SER D 109       5.960  12.638  13.216  1.00 17.66           O  
ATOM   4801  N   VAL D 110       5.480  16.700  11.580  1.00 20.25           N  
ATOM   4802  CA  VAL D 110       5.630  17.759  10.611  1.00 11.84           C  
ATOM   4803  C   VAL D 110       6.265  18.962  11.254  1.00 13.96           C  
ATOM   4804  O   VAL D 110       6.810  19.837  10.542  1.00 14.59           O  
ATOM   4805  CB  VAL D 110       4.269  18.105   9.922  1.00 18.48           C  
ATOM   4806  CG1 VAL D 110       4.457  19.162   8.843  1.00 25.68           C  
ATOM   4807  CG2 VAL D 110       3.781  16.856   9.165  1.00 28.55           C  
ATOM   4808  N   ASP D 111       6.216  18.994  12.586  1.00 13.35           N  
ATOM   4809  CA  ASP D 111       6.795  20.094  13.309  1.00 18.22           C  
ATOM   4810  C   ASP D 111       8.257  19.898  13.630  1.00 18.39           C  
ATOM   4811  O   ASP D 111       8.921  20.859  13.975  1.00 14.53           O  
ATOM   4812  CB  ASP D 111       5.946  20.397  14.562  1.00  9.43           C  
ATOM   4813  CG  ASP D 111       4.487  20.698  14.155  1.00 14.28           C  
ATOM   4814  OD1 ASP D 111       4.258  21.656  13.355  1.00 13.68           O  
ATOM   4815  OD2 ASP D 111       3.611  19.921  14.594  1.00 12.36           O  
ATOM   4816  N   LEU D 112       8.773  18.688  13.442  1.00 15.87           N  
ATOM   4817  CA  LEU D 112      10.161  18.434  13.800  1.00 13.53           C  
ATOM   4818  C   LEU D 112      11.146  19.397  13.139  1.00 16.30           C  
ATOM   4819  O   LEU D 112      12.041  19.954  13.809  1.00 12.78           O  
ATOM   4820  CB  LEU D 112      10.510  16.963  13.592  1.00 13.35           C  
ATOM   4821  CG  LEU D 112       9.735  16.016  14.570  1.00 19.11           C  
ATOM   4822  CD1 LEU D 112       9.873  14.534  14.116  1.00 14.85           C  
ATOM   4823  CD2 LEU D 112      10.248  16.177  16.023  1.00 18.17           C  
ATOM   4824  N   PRO D 113      10.998  19.645  11.831  1.00 17.12           N  
ATOM   4825  CA  PRO D 113      11.913  20.584  11.132  1.00 19.84           C  
ATOM   4826  C   PRO D 113      11.726  22.015  11.677  1.00 11.75           C  
ATOM   4827  O   PRO D 113      12.645  22.838  11.673  1.00 15.41           O  
ATOM   4828  CB  PRO D 113      11.426  20.505   9.682  1.00 17.86           C  
ATOM   4829  CG  PRO D 113      10.906  19.022   9.599  1.00 21.42           C  
ATOM   4830  CD  PRO D 113      10.104  18.965  10.860  1.00 14.03           C  
ATOM   4831  N   ALA D 114      10.526  22.313  12.133  1.00 15.65           N  
ATOM   4832  CA  ALA D 114      10.244  23.671  12.667  1.00 19.74           C  
ATOM   4833  C   ALA D 114      10.903  23.864  14.034  1.00 17.79           C  
ATOM   4834  O   ALA D 114      11.464  24.961  14.321  1.00 14.19           O  
ATOM   4835  CB  ALA D 114       8.722  23.907  12.730  1.00 15.00           C  
ATOM   4836  N   PHE D 115      10.857  22.830  14.875  1.00 14.41           N  
ATOM   4837  CA  PHE D 115      11.556  22.928  16.165  1.00 14.65           C  
ATOM   4838  C   PHE D 115      13.039  23.146  15.916  1.00 18.12           C  
ATOM   4839  O   PHE D 115      13.676  23.936  16.618  1.00 17.26           O  
ATOM   4840  CB  PHE D 115      11.485  21.655  16.974  1.00 14.10           C  
ATOM   4841  CG  PHE D 115      10.102  21.197  17.268  1.00 14.29           C  
ATOM   4842  CD1 PHE D 115       9.864  19.856  17.331  1.00 14.24           C  
ATOM   4843  CD2 PHE D 115       9.062  22.109  17.484  1.00 13.08           C  
ATOM   4844  CE1 PHE D 115       8.564  19.390  17.612  1.00 18.68           C  
ATOM   4845  CE2 PHE D 115       7.757  21.680  17.772  1.00 16.56           C  
ATOM   4846  CZ  PHE D 115       7.522  20.309  17.825  1.00 17.11           C  
ATOM   4847  N   ALA D 116      13.592  22.407  14.938  1.00 11.92           N  
ATOM   4848  CA  ALA D 116      15.024  22.504  14.670  1.00 20.01           C  
ATOM   4849  C   ALA D 116      15.332  23.860  14.080  1.00 24.84           C  
ATOM   4850  O   ALA D 116      16.408  24.408  14.357  1.00 24.81           O  
ATOM   4851  CB  ALA D 116      15.496  21.399  13.713  1.00 23.87           C  
ATOM   4852  N   ALA D 117      14.432  24.387  13.231  1.00 20.99           N  
ATOM   4853  CA  ALA D 117      14.672  25.698  12.665  1.00 20.59           C  
ATOM   4854  C   ALA D 117      14.611  26.807  13.746  1.00 22.88           C  
ATOM   4855  O   ALA D 117      15.347  27.785  13.666  1.00 17.92           O  
ATOM   4856  CB  ALA D 117      13.691  25.979  11.498  1.00 18.75           C  
ATOM   4857  N   CYS D 118      13.759  26.650  14.756  1.00 19.14           N  
ATOM   4858  CA  CYS D 118      13.655  27.650  15.844  1.00 23.77           C  
ATOM   4859  C   CYS D 118      14.685  27.551  16.987  1.00 24.63           C  
ATOM   4860  O   CYS D 118      15.280  26.489  17.239  1.00 19.29           O  
ATOM   4861  CB  CYS D 118      12.226  27.611  16.428  1.00 17.88           C  
ATOM   4862  SG  CYS D 118      11.186  28.719  15.522  1.00 19.97           S  
ATOM   4863  N   GLY D 119      14.893  28.670  17.680  1.00 13.98           N  
ATOM   4864  CA  GLY D 119      15.828  28.678  18.796  1.00 18.86           C  
ATOM   4865  C   GLY D 119      15.305  27.952  20.033  1.00 15.55           C  
ATOM   4866  O   GLY D 119      16.097  27.313  20.735  1.00 19.84           O  
ATOM   4867  N   THR D 120      13.990  28.075  20.273  1.00 14.36           N  
ATOM   4868  CA  THR D 120      13.271  27.446  21.382  1.00 13.55           C  
ATOM   4869  C   THR D 120      12.040  26.696  20.835  1.00  7.93           C  
ATOM   4870  O   THR D 120      11.403  27.165  19.907  1.00 14.69           O  
ATOM   4871  CB  THR D 120      12.712  28.553  22.367  1.00 21.16           C  
ATOM   4872  OG1 THR D 120      13.799  29.293  22.902  1.00 25.25           O  
ATOM   4873  CG2 THR D 120      11.929  27.979  23.469  1.00 22.65           C  
ATOM   4874  N   SER D 121      11.718  25.549  21.430  1.00 14.79           N  
ATOM   4875  CA  SER D 121      10.558  24.794  20.966  1.00 15.60           C  
ATOM   4876  C   SER D 121       9.727  24.228  22.135  1.00 16.76           C  
ATOM   4877  O   SER D 121      10.260  23.819  23.165  1.00 18.65           O  
ATOM   4878  CB  SER D 121      11.030  23.631  20.039  1.00 18.62           C  
ATOM   4879  OG  SER D 121      12.031  22.803  20.668  1.00 14.36           O  
ATOM   4880  N   PHE D 122       8.428  24.184  21.941  1.00 13.69           N  
ATOM   4881  CA  PHE D 122       7.516  23.623  22.923  1.00 14.43           C  
ATOM   4882  C   PHE D 122       6.666  22.555  22.288  1.00 10.06           C  
ATOM   4883  O   PHE D 122       6.276  22.732  21.133  1.00 12.40           O  
ATOM   4884  CB  PHE D 122       6.544  24.693  23.378  1.00 13.11           C  
ATOM   4885  CG  PHE D 122       7.173  25.799  24.129  1.00 17.81           C  
ATOM   4886  CD1 PHE D 122       7.720  26.890  23.464  1.00 10.21           C  
ATOM   4887  CD2 PHE D 122       7.274  25.731  25.486  1.00 15.53           C  
ATOM   4888  CE1 PHE D 122       8.385  27.924  24.176  1.00 17.49           C  
ATOM   4889  CE2 PHE D 122       7.937  26.770  26.209  1.00 19.19           C  
ATOM   4890  CZ  PHE D 122       8.485  27.853  25.537  1.00 13.75           C  
ATOM   4891  N   ALA D 123       6.355  21.503  23.030  1.00 12.02           N  
ATOM   4892  CA  ALA D 123       5.440  20.450  22.562  1.00 16.68           C  
ATOM   4893  C   ALA D 123       4.208  20.463  23.460  1.00 18.44           C  
ATOM   4894  O   ALA D 123       4.337  20.643  24.675  1.00 13.46           O  
ATOM   4895  CB  ALA D 123       6.082  19.130  22.677  1.00 13.14           C  
ATOM   4896  N   VAL D 124       3.002  20.230  22.893  1.00 14.53           N  
ATOM   4897  CA  VAL D 124       1.827  20.149  23.710  1.00 13.33           C  
ATOM   4898  C   VAL D 124       1.848  18.795  24.428  1.00 10.84           C  
ATOM   4899  O   VAL D 124       2.573  17.866  23.999  1.00 14.15           O  
ATOM   4900  CB  VAL D 124       0.503  20.303  22.877  1.00 10.35           C  
ATOM   4901  CG1 VAL D 124       0.472  21.711  22.211  1.00 14.04           C  
ATOM   4902  CG2 VAL D 124       0.442  19.231  21.772  1.00 16.94           C  
ATOM   4903  N   ALA D 125       1.086  18.703  25.523  1.00 11.79           N  
ATOM   4904  CA  ALA D 125       1.086  17.508  26.430  1.00 12.64           C  
ATOM   4905  C   ALA D 125       0.669  16.186  25.813  1.00 10.34           C  
ATOM   4906  O   ALA D 125       1.015  15.125  26.310  1.00 13.77           O  
ATOM   4907  CB  ALA D 125       0.215  17.784  27.691  1.00 14.84           C  
ATOM   4908  N   ASP D 126      -0.102  16.265  24.732  1.00  9.49           N  
ATOM   4909  CA  ASP D 126      -0.533  15.048  24.041  1.00 16.86           C  
ATOM   4910  C   ASP D 126       0.261  14.771  22.755  1.00 21.06           C  
ATOM   4911  O   ASP D 126      -0.108  13.911  21.952  1.00 16.25           O  
ATOM   4912  CB  ASP D 126      -2.049  15.036  23.797  1.00 14.35           C  
ATOM   4913  CG  ASP D 126      -2.574  16.282  23.123  1.00 18.46           C  
ATOM   4914  OD1 ASP D 126      -3.598  16.139  22.424  1.00 19.72           O  
ATOM   4915  OD2 ASP D 126      -2.008  17.372  23.239  1.00 13.76           O  
ATOM   4916  N   ALA D 127       1.368  15.489  22.570  1.00 10.55           N  
ATOM   4917  CA  ALA D 127       2.233  15.199  21.407  1.00 12.92           C  
ATOM   4918  C   ALA D 127       2.884  13.820  21.638  1.00 11.92           C  
ATOM   4919  O   ALA D 127       3.036  13.350  22.765  1.00 13.15           O  
ATOM   4920  CB  ALA D 127       3.304  16.295  21.273  1.00 14.41           C  
ATOM   4921  N   PRO D 128       3.217  13.109  20.553  1.00 10.77           N  
ATOM   4922  CA  PRO D 128       3.841  11.805  20.695  1.00 13.25           C  
ATOM   4923  C   PRO D 128       5.239  11.941  21.268  1.00 12.75           C  
ATOM   4924  O   PRO D 128       5.851  12.985  21.152  1.00 13.08           O  
ATOM   4925  CB  PRO D 128       3.872  11.264  19.264  1.00 13.50           C  
ATOM   4926  CG  PRO D 128       3.854  12.495  18.409  1.00 17.59           C  
ATOM   4927  CD  PRO D 128       2.844  13.393  19.157  1.00 10.51           C  
ATOM   4928  N   ILE D 129       5.696  10.864  21.909  1.00 12.89           N  
ATOM   4929  CA  ILE D 129       7.001  10.788  22.519  1.00 15.74           C  
ATOM   4930  C   ILE D 129       8.080  11.340  21.657  1.00 14.32           C  
ATOM   4931  O   ILE D 129       8.979  12.042  22.167  1.00 16.85           O  
ATOM   4932  CB  ILE D 129       7.376   9.287  22.736  1.00 21.46           C  
ATOM   4933  CG1 ILE D 129       6.467   8.699  23.819  1.00 31.59           C  
ATOM   4934  CG2 ILE D 129       8.843   9.120  22.942  1.00 30.66           C  
ATOM   4935  CD1 ILE D 129       6.237   9.571  24.979  1.00 26.35           C  
ATOM   4936  N   TYR D 130       8.060  11.004  20.360  1.00 11.40           N  
ATOM   4937  CA  TYR D 130       9.153  11.494  19.500  1.00 16.04           C  
ATOM   4938  C   TYR D 130       9.123  12.992  19.242  1.00 22.83           C  
ATOM   4939  O   TYR D 130      10.157  13.609  18.907  1.00 19.35           O  
ATOM   4940  CB  TYR D 130       9.243  10.736  18.191  1.00 13.74           C  
ATOM   4941  CG  TYR D 130       7.916  10.449  17.588  1.00 11.78           C  
ATOM   4942  CD1 TYR D 130       7.324  11.364  16.741  1.00 12.87           C  
ATOM   4943  CD2 TYR D 130       7.251   9.251  17.888  1.00 13.13           C  
ATOM   4944  CE1 TYR D 130       6.049  11.120  16.190  1.00 15.83           C  
ATOM   4945  CE2 TYR D 130       5.966   8.985  17.307  1.00 10.18           C  
ATOM   4946  CZ  TYR D 130       5.403   9.943  16.492  1.00 11.87           C  
ATOM   4947  OH  TYR D 130       4.133   9.784  15.945  1.00 14.13           O  
ATOM   4948  N   VAL D 131       7.948  13.589  19.382  1.00 16.72           N  
ATOM   4949  CA  VAL D 131       7.858  15.025  19.245  1.00 15.07           C  
ATOM   4950  C   VAL D 131       8.310  15.624  20.606  1.00 16.30           C  
ATOM   4951  O   VAL D 131       9.109  16.568  20.636  1.00 15.12           O  
ATOM   4952  CB  VAL D 131       6.418  15.442  18.901  1.00  9.40           C  
ATOM   4953  CG1 VAL D 131       6.188  16.941  19.218  1.00 14.62           C  
ATOM   4954  CG2 VAL D 131       6.141  15.147  17.427  1.00 17.76           C  
ATOM   4955  N   LYS D 132       7.873  15.008  21.711  1.00 12.42           N  
ATOM   4956  CA  LYS D 132       8.211  15.548  23.013  1.00 17.54           C  
ATOM   4957  C   LYS D 132       9.698  15.498  23.258  1.00 16.40           C  
ATOM   4958  O   LYS D 132      10.241  16.377  23.909  1.00 14.22           O  
ATOM   4959  CB  LYS D 132       7.484  14.786  24.156  1.00 12.43           C  
ATOM   4960  CG  LYS D 132       5.991  15.058  24.243  1.00 16.94           C  
ATOM   4961  CD  LYS D 132       5.399  14.313  25.428  1.00 15.46           C  
ATOM   4962  CE  LYS D 132       4.033  14.884  25.693  1.00 11.45           C  
ATOM   4963  NZ  LYS D 132       3.464  14.075  26.854  1.00 17.28           N  
ATOM   4964  N   ASN D 133      10.375  14.494  22.692  1.00 15.55           N  
ATOM   4965  CA  ASN D 133      11.804  14.350  22.963  1.00 17.18           C  
ATOM   4966  C   ASN D 133      12.623  15.374  22.238  1.00 19.67           C  
ATOM   4967  O   ASN D 133      13.758  15.645  22.638  1.00 19.31           O  
ATOM   4968  CB  ASN D 133      12.313  12.950  22.571  1.00 18.04           C  
ATOM   4969  CG  ASN D 133      13.608  12.615  23.262  1.00 18.62           C  
ATOM   4970  OD1 ASN D 133      13.681  12.650  24.506  1.00 20.28           O  
ATOM   4971  ND2 ASN D 133      14.632  12.342  22.503  1.00 18.99           N  
ATOM   4972  N   ALA D 134      12.024  15.957  21.219  1.00 17.40           N  
ATOM   4973  CA  ALA D 134      12.715  16.908  20.352  1.00 24.30           C  
ATOM   4974  C   ALA D 134      12.619  18.334  20.778  1.00 18.16           C  
ATOM   4975  O   ALA D 134      13.369  19.157  20.278  1.00 18.79           O  
ATOM   4976  CB  ALA D 134      12.198  16.795  18.911  1.00 16.50           C  
ATOM   4977  N   VAL D 135      11.705  18.646  21.702  1.00 19.15           N  
ATOM   4978  CA  VAL D 135      11.589  20.018  22.118  1.00 18.88           C  
ATOM   4979  C   VAL D 135      12.364  20.389  23.363  1.00 20.58           C  
ATOM   4980  O   VAL D 135      12.821  19.534  24.112  1.00 20.07           O  
ATOM   4981  CB  VAL D 135      10.142  20.395  22.355  1.00 14.61           C  
ATOM   4982  CG1 VAL D 135       9.365  20.175  20.981  1.00 14.32           C  
ATOM   4983  CG2 VAL D 135       9.530  19.545  23.566  1.00 15.47           C  
ATOM   4984  N   ASP D 136      12.443  21.684  23.592  1.00 16.07           N  
ATOM   4985  CA  ASP D 136      13.124  22.200  24.784  1.00 21.21           C  
ATOM   4986  C   ASP D 136      12.193  22.044  25.952  1.00 23.25           C  
ATOM   4987  O   ASP D 136      12.626  21.595  27.048  1.00 19.73           O  
ATOM   4988  CB  ASP D 136      13.517  23.668  24.582  1.00 19.34           C  
ATOM   4989  CG  ASP D 136      14.446  23.823  23.422  1.00 31.18           C  
ATOM   4990  OD1 ASP D 136      14.179  24.706  22.586  1.00 25.69           O  
ATOM   4991  OD2 ASP D 136      15.412  23.006  23.311  1.00 28.51           O  
ATOM   4992  N   HIS D 137      10.927  22.400  25.751  1.00 14.45           N  
ATOM   4993  CA  HIS D 137       9.977  22.265  26.830  1.00 16.35           C  
ATOM   4994  C   HIS D 137       8.676  21.582  26.509  1.00 15.25           C  
ATOM   4995  O   HIS D 137       7.972  21.985  25.593  1.00 14.84           O  
ATOM   4996  CB  HIS D 137       9.588  23.594  27.500  1.00 23.74           C  
ATOM   4997  CG  HIS D 137       9.139  23.397  28.927  1.00 34.00           C  
ATOM   4998  ND1 HIS D 137      10.012  23.057  29.956  1.00 31.87           N  
ATOM   4999  CD2 HIS D 137       7.896  23.374  29.474  1.00 36.72           C  
ATOM   5000  CE1 HIS D 137       9.322  22.836  31.059  1.00 34.73           C  
ATOM   5001  NE2 HIS D 137       8.037  23.018  30.793  1.00 31.85           N  
ATOM   5002  N   VAL D 138       8.376  20.549  27.268  1.00 11.31           N  
ATOM   5003  CA  VAL D 138       7.120  19.814  27.083  1.00  7.88           C  
ATOM   5004  C   VAL D 138       6.084  20.421  28.000  1.00 17.63           C  
ATOM   5005  O   VAL D 138       6.253  20.438  29.265  1.00 12.43           O  
ATOM   5006  CB  VAL D 138       7.297  18.325  27.438  1.00 14.08           C  
ATOM   5007  CG1 VAL D 138       6.001  17.569  27.241  1.00 14.67           C  
ATOM   5008  CG2 VAL D 138       8.367  17.665  26.484  1.00 12.68           C  
ATOM   5009  N   LEU D 139       4.998  20.913  27.403  1.00 13.69           N  
ATOM   5010  CA  LEU D 139       3.920  21.536  28.185  1.00 12.87           C  
ATOM   5011  C   LEU D 139       3.066  20.485  28.903  1.00 12.74           C  
ATOM   5012  O   LEU D 139       2.994  19.336  28.503  1.00 15.81           O  
ATOM   5013  CB  LEU D 139       3.056  22.410  27.253  1.00 10.45           C  
ATOM   5014  CG  LEU D 139       3.877  23.545  26.612  1.00 10.91           C  
ATOM   5015  CD1 LEU D 139       3.112  24.021  25.400  1.00 12.89           C  
ATOM   5016  CD2 LEU D 139       4.148  24.688  27.638  1.00 13.29           C  
ATOM   5017  N   SER D 140       2.397  20.908  29.982  1.00 12.69           N  
ATOM   5018  CA  SER D 140       1.599  20.025  30.742  1.00 13.87           C  
ATOM   5019  C   SER D 140       0.167  20.054  30.220  1.00 12.79           C  
ATOM   5020  O   SER D 140      -0.627  19.182  30.591  1.00 16.50           O  
ATOM   5021  CB  SER D 140       1.614  20.444  32.222  1.00 20.41           C  
ATOM   5022  OG  SER D 140       0.825  21.588  32.287  1.00 21.78           O  
ATOM   5023  N   THR D 141      -0.154  21.028  29.358  1.00 15.28           N  
ATOM   5024  CA  THR D 141      -1.541  21.148  28.854  1.00 14.91           C  
ATOM   5025  C   THR D 141      -1.737  20.533  27.472  1.00 15.60           C  
ATOM   5026  O   THR D 141      -0.907  20.726  26.614  1.00 13.56           O  
ATOM   5027  CB  THR D 141      -1.925  22.591  28.791  1.00 14.44           C  
ATOM   5028  OG1 THR D 141      -1.735  23.156  30.101  1.00 13.65           O  
ATOM   5029  CG2 THR D 141      -3.428  22.757  28.384  1.00 13.18           C  
ATOM   5030  N   HIS D 142      -2.834  19.795  27.284  1.00 12.75           N  
ATOM   5031  CA  HIS D 142      -3.167  19.202  25.981  1.00 15.51           C  
ATOM   5032  C   HIS D 142      -3.429  20.244  24.900  1.00 17.31           C  
ATOM   5033  O   HIS D 142      -3.845  21.351  25.186  1.00 13.99           O  
ATOM   5034  CB  HIS D 142      -4.426  18.352  26.096  1.00 10.88           C  
ATOM   5035  CG  HIS D 142      -4.169  16.988  26.679  1.00 26.81           C  
ATOM   5036  ND1 HIS D 142      -3.313  16.778  27.745  1.00 32.10           N  
ATOM   5037  CD2 HIS D 142      -4.659  15.763  26.347  1.00 28.51           C  
ATOM   5038  CE1 HIS D 142      -3.278  15.491  28.040  1.00 26.96           C  
ATOM   5039  NE2 HIS D 142      -4.087  14.850  27.210  1.00 30.12           N  
ATOM   5040  N   GLY D 143      -3.140  19.892  23.644  1.00 11.67           N  
ATOM   5041  CA  GLY D 143      -3.419  20.830  22.561  1.00 13.42           C  
ATOM   5042  C   GLY D 143      -4.910  21.199  22.602  1.00 15.11           C  
ATOM   5043  O   GLY D 143      -5.770  20.380  22.977  1.00 13.75           O  
ATOM   5044  N   GLY D 144      -5.195  22.443  22.227  1.00 11.95           N  
ATOM   5045  CA  GLY D 144      -6.561  22.941  22.191  1.00 13.24           C  
ATOM   5046  C   GLY D 144      -7.213  23.222  23.543  1.00 14.58           C  
ATOM   5047  O   GLY D 144      -8.361  23.685  23.595  1.00 18.55           O  
ATOM   5048  N   LYS D 145      -6.470  23.009  24.615  1.00 12.26           N  
ATOM   5049  CA  LYS D 145      -7.006  23.215  25.955  1.00 13.85           C  
ATOM   5050  C   LYS D 145      -6.204  24.266  26.708  1.00 13.26           C  
ATOM   5051  O   LYS D 145      -6.226  24.275  27.955  1.00 14.55           O  
ATOM   5052  CB  LYS D 145      -6.992  21.908  26.794  1.00 13.97           C  
ATOM   5053  CG  LYS D 145      -7.491  20.651  26.072  1.00 15.59           C  
ATOM   5054  CD  LYS D 145      -8.847  20.945  25.526  1.00 19.06           C  
ATOM   5055  CE  LYS D 145      -9.508  19.702  25.018  1.00 23.07           C  
ATOM   5056  NZ  LYS D 145     -10.910  20.013  24.471  1.00 27.36           N  
ATOM   5057  N   GLY D 146      -5.495  25.135  25.981  1.00 10.03           N  
ATOM   5058  CA  GLY D 146      -4.774  26.179  26.702  1.00  9.97           C  
ATOM   5059  C   GLY D 146      -3.274  25.903  26.700  1.00 16.74           C  
ATOM   5060  O   GLY D 146      -2.560  26.461  27.510  1.00 13.72           O  
ATOM   5061  N   ALA D 147      -2.752  25.072  25.789  1.00 15.18           N  
ATOM   5062  CA  ALA D 147      -1.309  24.848  25.793  1.00  7.66           C  
ATOM   5063  C   ALA D 147      -0.563  26.088  25.280  1.00  8.38           C  
ATOM   5064  O   ALA D 147       0.543  26.420  25.773  1.00  9.75           O  
ATOM   5065  CB  ALA D 147      -0.908  23.582  24.901  1.00 15.00           C  
ATOM   5066  N   PHE D 148      -1.145  26.817  24.331  1.00 10.48           N  
ATOM   5067  CA  PHE D 148      -0.439  28.005  23.858  1.00 16.55           C  
ATOM   5068  C   PHE D 148      -0.332  29.020  25.041  1.00 13.46           C  
ATOM   5069  O   PHE D 148       0.687  29.712  25.219  1.00 14.03           O  
ATOM   5070  CB  PHE D 148      -1.194  28.661  22.707  1.00 14.17           C  
ATOM   5071  CG  PHE D 148      -0.481  29.845  22.150  1.00 14.01           C  
ATOM   5072  CD1 PHE D 148       0.307  29.721  21.005  1.00 12.00           C  
ATOM   5073  CD2 PHE D 148      -0.552  31.091  22.791  1.00 13.21           C  
ATOM   5074  CE1 PHE D 148       1.036  30.868  20.505  1.00 19.40           C  
ATOM   5075  CE2 PHE D 148       0.143  32.196  22.329  1.00 13.29           C  
ATOM   5076  CZ  PHE D 148       0.943  32.095  21.183  1.00 17.55           C  
ATOM   5077  N   ARG D 149      -1.451  29.143  25.762  1.00 10.00           N  
ATOM   5078  CA  ARG D 149      -1.530  30.041  26.941  1.00 13.54           C  
ATOM   5079  C   ARG D 149      -0.504  29.593  27.988  1.00 10.45           C  
ATOM   5080  O   ARG D 149       0.158  30.443  28.673  1.00 14.83           O  
ATOM   5081  CB  ARG D 149      -2.939  29.994  27.563  1.00 13.70           C  
ATOM   5082  CG  ARG D 149      -3.135  30.957  28.750  1.00 15.13           C  
ATOM   5083  CD  ARG D 149      -2.604  32.350  28.478  1.00 15.44           C  
ATOM   5084  NE  ARG D 149      -2.859  33.197  29.652  1.00 10.28           N  
ATOM   5085  CZ  ARG D 149      -4.051  33.708  29.972  1.00 13.07           C  
ATOM   5086  NH1 ARG D 149      -5.112  33.499  29.193  1.00 13.48           N  
ATOM   5087  NH2 ARG D 149      -4.197  34.340  31.149  1.00 13.78           N  
ATOM   5088  N   GLU D 150      -0.352  28.278  28.152  1.00 13.88           N  
ATOM   5089  CA  GLU D 150       0.609  27.808  29.151  1.00 11.47           C  
ATOM   5090  C   GLU D 150       1.987  28.281  28.703  1.00 10.49           C  
ATOM   5091  O   GLU D 150       2.862  28.734  29.499  1.00 14.34           O  
ATOM   5092  CB  GLU D 150       0.573  26.300  29.245  1.00 11.34           C  
ATOM   5093  CG  GLU D 150       1.562  25.749  30.249  1.00 14.62           C  
ATOM   5094  CD  GLU D 150       1.680  24.247  30.235  1.00 19.69           C  
ATOM   5095  OE1 GLU D 150       2.629  23.737  30.878  1.00 14.20           O  
ATOM   5096  OE2 GLU D 150       0.821  23.557  29.594  1.00 16.07           O  
ATOM   5097  N   MET D 151       2.191  28.217  27.393  1.00 13.25           N  
ATOM   5098  CA  MET D 151       3.445  28.691  26.858  1.00 12.50           C  
ATOM   5099  C   MET D 151       3.624  30.199  27.007  1.00 15.30           C  
ATOM   5100  O   MET D 151       4.696  30.682  27.448  1.00 14.66           O  
ATOM   5101  CB  MET D 151       3.598  28.366  25.380  1.00 13.73           C  
ATOM   5102  CG  MET D 151       4.893  28.911  24.838  1.00 16.21           C  
ATOM   5103  SD  MET D 151       4.908  28.635  23.011  1.00 16.21           S  
ATOM   5104  CE  MET D 151       3.569  29.726  22.555  1.00 19.29           C  
ATOM   5105  N   SER D 152       2.604  30.963  26.596  1.00 13.33           N  
ATOM   5106  CA  SER D 152       2.755  32.428  26.641  1.00 14.47           C  
ATOM   5107  C   SER D 152       2.946  32.913  28.080  1.00 13.23           C  
ATOM   5108  O   SER D 152       3.772  33.818  28.297  1.00 12.54           O  
ATOM   5109  CB  SER D 152       1.574  33.137  25.949  1.00 15.23           C  
ATOM   5110  OG  SER D 152       0.325  32.840  26.568  1.00 16.08           O  
ATOM   5111  N   ASP D 153       2.282  32.296  29.072  1.00 15.38           N  
ATOM   5112  CA  ASP D 153       2.463  32.725  30.481  1.00 14.09           C  
ATOM   5113  C   ASP D 153       3.928  32.514  30.863  1.00 16.27           C  
ATOM   5114  O   ASP D 153       4.563  33.366  31.545  1.00 16.89           O  
ATOM   5115  CB  ASP D 153       1.621  31.877  31.442  1.00 17.09           C  
ATOM   5116  CG  ASP D 153       0.125  32.215  31.415  1.00 14.10           C  
ATOM   5117  OD1 ASP D 153      -0.577  31.482  32.129  1.00 14.63           O  
ATOM   5118  OD2 ASP D 153      -0.357  33.161  30.746  1.00 13.00           O  
ATOM   5119  N   MET D 154       4.487  31.394  30.419  1.00  8.87           N  
ATOM   5120  CA  MET D 154       5.875  31.079  30.747  1.00 16.14           C  
ATOM   5121  C   MET D 154       6.853  32.066  30.118  1.00 22.99           C  
ATOM   5122  O   MET D 154       7.826  32.469  30.762  1.00 15.82           O  
ATOM   5123  CB  MET D 154       6.182  29.645  30.310  1.00 23.48           C  
ATOM   5124  CG  MET D 154       7.469  29.040  30.896  1.00 24.49           C  
ATOM   5125  SD  MET D 154       7.745  27.367  30.219  1.00 33.08           S  
ATOM   5126  CE  MET D 154       6.082  26.890  29.916  1.00 20.26           C  
ATOM   5127  N   ILE D 155       6.608  32.467  28.874  1.00 14.27           N  
ATOM   5128  CA  ILE D 155       7.480  33.436  28.234  1.00 11.65           C  
ATOM   5129  C   ILE D 155       7.390  34.814  28.913  1.00 21.57           C  
ATOM   5130  O   ILE D 155       8.419  35.440  29.212  1.00 20.41           O  
ATOM   5131  CB  ILE D 155       7.148  33.535  26.716  1.00 17.27           C  
ATOM   5132  CG1 ILE D 155       7.490  32.182  26.059  1.00 17.40           C  
ATOM   5133  CG2 ILE D 155       7.946  34.631  26.099  1.00 14.52           C  
ATOM   5134  CD1 ILE D 155       7.052  32.078  24.530  1.00 15.10           C  
ATOM   5135  N   LEU D 156       6.164  35.269  29.157  1.00 20.13           N  
ATOM   5136  CA  LEU D 156       5.941  36.579  29.829  1.00 22.71           C  
ATOM   5137  C   LEU D 156       6.482  36.572  31.239  1.00 24.15           C  
ATOM   5138  O   LEU D 156       7.099  37.565  31.678  1.00 19.73           O  
ATOM   5139  CB  LEU D 156       4.460  36.940  29.847  1.00 16.11           C  
ATOM   5140  CG  LEU D 156       3.973  37.182  28.415  1.00 21.74           C  
ATOM   5141  CD1 LEU D 156       2.442  37.318  28.415  1.00 15.21           C  
ATOM   5142  CD2 LEU D 156       4.688  38.462  27.797  1.00 22.82           C  
ATOM   5143  N   GLN D 157       6.244  35.485  31.966  1.00 17.82           N  
ATOM   5144  CA  GLN D 157       6.809  35.400  33.303  1.00 20.14           C  
ATOM   5145  C   GLN D 157       8.329  35.555  33.220  1.00 28.86           C  
ATOM   5146  O   GLN D 157       8.946  36.340  33.958  1.00 22.87           O  
ATOM   5147  CB  GLN D 157       6.524  34.038  33.919  1.00 19.42           C  
ATOM   5148  CG  GLN D 157       7.177  33.868  35.295  1.00 25.66           C  
ATOM   5149  CD  GLN D 157       6.369  32.919  36.157  1.00 30.83           C  
ATOM   5150  OE1 GLN D 157       5.247  33.244  36.544  1.00 36.27           O  
ATOM   5151  NE2 GLN D 157       6.904  31.751  36.426  1.00 32.04           N  
ATOM   5152  N   ALA D 158       8.939  34.766  32.339  1.00 21.14           N  
ATOM   5153  CA  ALA D 158      10.385  34.801  32.152  1.00 22.42           C  
ATOM   5154  C   ALA D 158      10.884  36.189  31.848  1.00 25.24           C  
ATOM   5155  O   ALA D 158      11.998  36.546  32.247  1.00 26.83           O  
ATOM   5156  CB  ALA D 158      10.792  33.872  31.005  1.00 21.70           C  
ATOM   5157  N   GLN D 159      10.070  36.988  31.172  1.00 16.49           N  
ATOM   5158  CA  GLN D 159      10.495  38.317  30.806  1.00 24.96           C  
ATOM   5159  C   GLN D 159      10.080  39.324  31.841  1.00 19.71           C  
ATOM   5160  O   GLN D 159      10.052  40.519  31.568  1.00 20.07           O  
ATOM   5161  CB  GLN D 159       9.932  38.679  29.428  1.00 23.16           C  
ATOM   5162  CG  GLN D 159      10.631  37.844  28.343  1.00 24.52           C  
ATOM   5163  CD  GLN D 159      10.214  38.139  26.909  1.00 25.26           C  
ATOM   5164  OE1 GLN D 159       9.648  39.181  26.601  1.00 20.86           O  
ATOM   5165  NE2 GLN D 159      10.534  37.189  26.013  1.00 17.89           N  
ATOM   5166  N   GLY D 160       9.727  38.817  33.016  1.00 21.92           N  
ATOM   5167  CA  GLY D 160       9.293  39.697  34.083  1.00 21.00           C  
ATOM   5168  C   GLY D 160       7.948  40.371  33.932  1.00 28.55           C  
ATOM   5169  O   GLY D 160       7.673  41.355  34.638  1.00 24.23           O  
ATOM   5170  N   LYS D 161       7.084  39.855  33.044  1.00 23.27           N  
ATOM   5171  CA  LYS D 161       5.781  40.456  32.851  1.00 16.72           C  
ATOM   5172  C   LYS D 161       4.585  39.617  33.322  1.00 15.85           C  
ATOM   5173  O   LYS D 161       3.476  39.814  32.822  1.00 18.40           O  
ATOM   5174  CB  LYS D 161       5.585  40.803  31.360  1.00 23.20           C  
ATOM   5175  CG  LYS D 161       6.607  41.827  30.895  1.00 31.02           C  
ATOM   5176  CD  LYS D 161       6.594  42.036  29.392  1.00 25.94           C  
ATOM   5177  CE  LYS D 161       7.673  43.090  29.020  1.00 30.81           C  
ATOM   5178  NZ  LYS D 161       7.797  44.132  30.145  1.00 36.48           N  
ATOM   5179  N   SER D 162       4.768  38.709  34.270  1.00 18.59           N  
ATOM   5180  CA  SER D 162       3.605  37.912  34.679  1.00 20.23           C  
ATOM   5181  C   SER D 162       2.487  38.781  35.287  1.00 18.69           C  
ATOM   5182  O   SER D 162       1.332  38.358  35.387  1.00 18.26           O  
ATOM   5183  CB  SER D 162       4.046  36.858  35.678  1.00 25.90           C  
ATOM   5184  OG  SER D 162       4.489  37.503  36.863  1.00 24.32           O  
ATOM   5185  N   SER D 163       2.816  40.004  35.707  1.00 17.45           N  
ATOM   5186  CA  SER D 163       1.780  40.851  36.273  1.00 24.04           C  
ATOM   5187  C   SER D 163       0.626  41.140  35.304  1.00 19.59           C  
ATOM   5188  O   SER D 163      -0.446  41.534  35.729  1.00 23.98           O  
ATOM   5189  CB  SER D 163       2.353  42.198  36.741  1.00 28.78           C  
ATOM   5190  OG  SER D 163       2.586  43.075  35.637  1.00 26.93           O  
ATOM   5191  N   VAL D 164       0.849  40.965  34.011  1.00 20.32           N  
ATOM   5192  CA  VAL D 164      -0.181  41.273  33.015  1.00 19.84           C  
ATOM   5193  C   VAL D 164      -1.278  40.216  33.062  1.00 19.86           C  
ATOM   5194  O   VAL D 164      -2.397  40.441  32.584  1.00 21.88           O  
ATOM   5195  CB  VAL D 164       0.368  41.380  31.534  1.00 18.47           C  
ATOM   5196  CG1 VAL D 164       1.341  42.540  31.400  1.00 25.08           C  
ATOM   5197  CG2 VAL D 164       1.002  40.053  31.081  1.00 22.01           C  
ATOM   5198  N   PHE D 165      -0.987  39.078  33.679  1.00 14.55           N  
ATOM   5199  CA  PHE D 165      -2.030  38.054  33.783  1.00 13.45           C  
ATOM   5200  C   PHE D 165      -2.215  37.522  35.181  1.00 14.23           C  
ATOM   5201  O   PHE D 165      -3.189  36.823  35.452  1.00 15.46           O  
ATOM   5202  CB  PHE D 165      -1.694  36.881  32.821  1.00 17.01           C  
ATOM   5203  CG  PHE D 165      -0.391  36.150  33.151  1.00 18.52           C  
ATOM   5204  CD1 PHE D 165      -0.304  35.316  34.261  1.00 21.00           C  
ATOM   5205  CD2 PHE D 165       0.756  36.292  32.328  1.00 16.97           C  
ATOM   5206  CE1 PHE D 165       0.879  34.630  34.561  1.00 19.86           C  
ATOM   5207  CE2 PHE D 165       1.935  35.619  32.625  1.00 16.81           C  
ATOM   5208  CZ  PHE D 165       2.004  34.783  33.737  1.00 20.40           C  
ATOM   5209  N   ASP D 166      -1.288  37.813  36.091  1.00 18.89           N  
ATOM   5210  CA  ASP D 166      -1.400  37.187  37.401  1.00 21.40           C  
ATOM   5211  C   ASP D 166      -1.963  37.983  38.576  1.00 19.34           C  
ATOM   5212  O   ASP D 166      -2.131  37.428  39.657  1.00 27.62           O  
ATOM   5213  CB  ASP D 166      -0.082  36.439  37.785  1.00 20.93           C  
ATOM   5214  CG  ASP D 166       1.051  37.358  38.200  1.00 22.12           C  
ATOM   5215  OD1 ASP D 166       2.183  36.860  38.301  1.00 21.89           O  
ATOM   5216  OD2 ASP D 166       0.825  38.546  38.448  1.00 17.82           O  
ATOM   5217  N   THR D 167      -2.327  39.238  38.338  1.00 21.36           N  
ATOM   5218  CA  THR D 167      -2.973  40.049  39.363  1.00 27.34           C  
ATOM   5219  C   THR D 167      -3.994  40.982  38.707  1.00 22.21           C  
ATOM   5220  O   THR D 167      -3.891  41.349  37.517  1.00 23.52           O  
ATOM   5221  CB  THR D 167      -1.986  40.932  40.146  1.00 28.83           C  
ATOM   5222  OG1 THR D 167      -1.475  41.922  39.256  1.00 28.60           O  
ATOM   5223  CG2 THR D 167      -0.822  40.077  40.747  1.00 28.82           C  
ATOM   5224  N   ALA D 168      -5.003  41.332  39.486  1.00 23.51           N  
ATOM   5225  CA  ALA D 168      -6.070  42.224  39.057  1.00 26.73           C  
ATOM   5226  C   ALA D 168      -5.486  43.588  38.636  1.00 31.48           C  
ATOM   5227  O   ALA D 168      -5.678  44.020  37.487  1.00 31.56           O  
ATOM   5228  CB  ALA D 168      -7.039  42.382  40.198  1.00 25.87           C  
ATOM   5229  N   GLN D 169      -4.777  44.259  39.548  1.00 35.61           N  
ATOM   5230  CA  GLN D 169      -4.134  45.565  39.204  1.00 36.99           C  
ATOM   5231  C   GLN D 169      -3.186  45.361  38.019  1.00 37.68           C  
ATOM   5232  O   GLN D 169      -3.143  46.172  37.060  1.00 36.74           O  
ATOM   5233  CB  GLN D 169      -3.270  46.146  40.341  1.00 35.98           C  
ATOM   5234  CG  GLN D 169      -2.662  47.505  39.870  1.00 39.48           C  
ATOM   5235  CD  GLN D 169      -1.640  48.157  40.828  1.00 42.22           C  
ATOM   5236  OE1 GLN D 169      -1.854  48.197  42.035  1.00 45.69           O  
ATOM   5237  NE2 GLN D 169      -0.546  48.701  40.266  1.00 35.27           N  
ATOM   5238  N   GLY D 170      -2.405  44.279  38.111  1.00 37.72           N  
ATOM   5239  CA  GLY D 170      -1.479  43.949  37.045  1.00 31.69           C  
ATOM   5240  C   GLY D 170      -2.234  43.952  35.742  1.00 30.58           C  
ATOM   5241  O   GLY D 170      -1.857  44.637  34.818  1.00 37.15           O  
ATOM   5242  N   PHE D 171      -3.329  43.203  35.660  1.00 34.96           N  
ATOM   5243  CA  PHE D 171      -4.108  43.143  34.416  1.00 29.78           C  
ATOM   5244  C   PHE D 171      -4.752  44.455  34.025  1.00 32.00           C  
ATOM   5245  O   PHE D 171      -4.803  44.779  32.843  1.00 36.44           O  
ATOM   5246  CB  PHE D 171      -5.241  42.118  34.527  1.00 25.66           C  
ATOM   5247  CG  PHE D 171      -6.201  42.125  33.336  1.00 29.24           C  
ATOM   5248  CD1 PHE D 171      -5.918  41.413  32.179  1.00 21.11           C  
ATOM   5249  CD2 PHE D 171      -7.399  42.843  33.385  1.00 31.95           C  
ATOM   5250  CE1 PHE D 171      -6.814  41.403  31.090  1.00 27.12           C  
ATOM   5251  CE2 PHE D 171      -8.279  42.846  32.307  1.00 25.94           C  
ATOM   5252  CZ  PHE D 171      -7.995  42.128  31.165  1.00 26.98           C  
ATOM   5253  N   LEU D 172      -5.290  45.181  35.001  1.00 34.07           N  
ATOM   5254  CA  LEU D 172      -5.988  46.446  34.700  1.00 33.57           C  
ATOM   5255  C   LEU D 172      -5.217  47.516  33.893  1.00 34.03           C  
ATOM   5256  O   LEU D 172      -5.779  48.525  33.482  1.00 40.52           O  
ATOM   5257  CB  LEU D 172      -6.577  47.039  35.986  1.00 34.83           C  
ATOM   5258  CG  LEU D 172      -7.875  46.283  36.401  1.00 34.16           C  
ATOM   5259  CD1 LEU D 172      -8.388  46.743  37.754  1.00 30.94           C  
ATOM   5260  CD2 LEU D 172      -8.946  46.441  35.286  1.00 32.10           C  
ATOM   5261  N   LYS D 173      -3.953  47.298  33.588  1.00 40.88           N  
ATOM   5262  CA  LYS D 173      -3.284  48.325  32.788  1.00 40.89           C  
ATOM   5263  C   LYS D 173      -3.452  48.219  31.265  1.00 43.24           C  
ATOM   5264  O   LYS D 173      -3.470  49.249  30.559  1.00 41.25           O  
ATOM   5265  CB  LYS D 173      -1.811  48.372  33.142  1.00 36.03           C  
ATOM   5266  CG  LYS D 173      -1.618  48.887  34.509  1.00 31.39           C  
ATOM   5267  CD  LYS D 173      -0.141  49.055  34.804  1.00 36.84           C  
ATOM   5268  CE  LYS D 173       0.017  49.142  36.303  1.00 37.48           C  
ATOM   5269  NZ  LYS D 173      -1.185  48.404  36.848  1.00 31.06           N  
ATOM   5270  N   SER D 174      -3.585  46.984  30.767  1.00 35.12           N  
ATOM   5271  CA  SER D 174      -3.727  46.732  29.341  1.00 39.76           C  
ATOM   5272  C   SER D 174      -5.033  45.951  29.001  1.00 42.51           C  
ATOM   5273  O   SER D 174      -4.981  45.115  28.052  1.00 43.54           O  
ATOM   5274  CB  SER D 174      -2.478  45.963  28.851  1.00 40.54           C  
ATOM   5275  OG  SER D 174      -2.015  45.013  29.829  1.00 45.43           O  
TER    5276      SER D 174                                                      
END
MOLECULE T0445_1_81_191_264.pdb
ATOM      5  N   MET     1      13.904  37.273  25.486  1.00 43.52          
ATOM      6  CA  MET     1      14.680  37.100  24.262  1.00 42.57          
ATOM      7  C   MET     1      13.835  36.632  23.082  1.00 37.68          
ATOM      8  O   MET     1      14.292  36.609  21.943  1.00 38.93          
ATOM      9  CB  MET     1      15.791  36.093  24.487  1.00 45.25          
ATOM     10  CG  MET     1      16.645  35.865  23.261  1.00 55.16          
ATOM     11  SD  MET     1      18.083  34.657  23.767  1.00 80.72          
ATOM     12  CE  MET     1      16.951  33.325  24.684  1.00 72.71          
ATOM     13  N   ILE     2      12.601  36.257  23.367  1.00 32.43          
ATOM     14  CA  ILE     2      11.677  35.783  22.314  1.00 28.99          
ATOM     15  C   ILE     2      11.097  36.973  21.544  1.00 26.84          
ATOM     16  O   ILE     2      10.413  37.825  22.110  1.00 27.33          
ATOM     17  CB  ILE     2      10.515  34.950  22.898  1.00 29.30          
ATOM     18  CG1 ILE     2      11.008  33.710  23.652  1.00 27.57          
ATOM     19  CG2 ILE     2       9.570  34.488  21.789  1.00 27.91          
ATOM     20  CD  ILE     2       9.829  32.967  24.435  1.00 28.89          
ATOM     21  N   LYS     3      11.355  37.009  20.243  1.00 23.71          
ATOM     22  CA  LYS     3      10.865  38.094  19.396  1.00 22.27          
ATOM     23  C   LYS     3       9.771  37.610  18.451  1.00 21.18          
ATOM     24  O   LYS     3       9.104  38.398  17.799  1.00 19.65          
ATOM     25  CB  LYS     3      12.016  38.669  18.566  1.00 22.74          
ATOM     26  CG  LYS     3      13.093  39.332  19.399  1.00 27.44          
ATOM     27  CD  LYS     3      12.497  40.534  20.097  1.00 35.85          
ATOM     28  CE  LYS     3      13.563  41.330  20.861  1.00 41.26          
ATOM     29  NZ  LYS     3      14.171  40.564  22.002  1.00 46.85          
ATOM     30  N   LEU     4       9.642  36.296  18.349  1.00 18.68          
ATOM     31  CA  LEU     4       8.616  35.675  17.465  1.00 18.53          
ATOM     32  C   LEU     4       8.139  34.320  17.969  1.00 17.37          
ATOM     33  O   LEU     4       8.935  33.447  18.359  1.00 19.50          
ATOM     34  CB  LEU     4       9.184  35.528  16.037  1.00 17.43          
ATOM     35  CG  LEU     4       8.296  35.012  14.889  1.00 19.22          
ATOM     36  CD1 LEU     4       8.811  35.579  13.522  1.00 17.87          
ATOM     37  CD2 LEU     4       8.188  33.460  14.844  1.00 17.69          
ATOM     38  N   ILE     5       6.831  34.162  17.963  1.00 14.96          
ATOM     39  CA  ILE     5       6.197  32.879  18.330  1.00 15.11          
ATOM     40  C   ILE     5       5.438  32.297  17.153  1.00 15.10          
ATOM     41  O   ILE     5       4.720  33.010  16.484  1.00 13.55          
ATOM     42  CB  ILE     5       5.262  33.011  19.534  1.00 15.13          
ATOM     43  CG1 ILE     5       6.033  33.528  20.732  1.00 15.76          
ATOM     44  CG2 ILE     5       4.593  31.663  19.843  1.00 16.91          
ATOM     45  CD  ILE     5       5.097  34.059  21.870  1.00 18.23          
ATOM     46  N   ALA     6       5.704  31.027  16.843  1.00 15.24          
ATOM     47  CA  ALA     6       4.946  30.319  15.804  1.00 14.51          
ATOM     48  C   ALA     6       4.297  29.089  16.432  1.00 16.60          
ATOM     49  O   ALA     6       4.918  28.401  17.228  1.00 19.48          
ATOM     50  CB  ALA     6       5.838  29.917  14.630  1.00 15.12          
ATOM     51  N   THR     7       3.062  28.830  16.043  1.00 16.21          
ATOM     52  CA  THR     7       2.342  27.662  16.500  1.00 16.80          
ATOM     53  C   THR     7       1.488  27.058  15.413  1.00 18.04          
ATOM     54  O   THR     7       0.948  27.788  14.564  1.00 17.34          
ATOM     55  CB  THR     7       1.436  27.979  17.731  1.00 16.99          
ATOM     56  OG1 THR     7       0.810  26.775  18.191  1.00 18.13          
ATOM     57  CG2 THR     7       0.329  28.996  17.403  1.00 13.78          
ATOM     58  N   ASP     8       1.434  25.713  15.375  1.00 17.82          
ATOM     59  CA  ASP     8       0.426  25.083  14.523  1.00 19.68          
ATOM     60  C   ASP     8      -0.872  25.049  15.335  1.00 19.14          
ATOM     61  O   ASP     8      -0.942  25.559  16.459  1.00 18.19          
ATOM     62  CB  ASP     8       0.807  23.764  13.778  1.00 22.84          
ATOM     63  CG  ASP     8       1.311  22.664  14.663  1.00 29.90          
ATOM     64  OD1 ASP     8       1.247  22.807  15.894  1.00 29.29          
ATOM     65  OD2 ASP     8       1.752  21.616  14.089  1.00 26.72          
ATOM     66  N   ILE     9      -1.895  24.475  14.742  1.00 19.28          
ATOM     67  CA  ILE     9      -3.213  24.550  15.292  1.00 20.49          
ATOM     68  C   ILE     9      -3.804  23.225  15.693  1.00 20.43          
ATOM     69  O   ILE     9      -4.179  22.995  16.858  1.00 20.29          
ATOM     70  CB  ILE     9      -4.153  25.198  14.225  1.00 22.51          
ATOM     71  CG1 ILE     9      -3.622  26.596  13.848  1.00 23.58          
ATOM     72  CG2 ILE     9      -5.602  25.247  14.708  1.00 20.10          
ATOM     73  CD  ILE     9      -4.374  27.276  12.720  1.00 21.65          
ATOM     74  N   ASP    10      -3.909  22.370  14.696  1.00 20.41          
ATOM     75  CA  ASP    10      -4.619  21.099  14.854  1.00 21.23          
ATOM     76  C   ASP    10      -3.907  20.066  15.695  1.00 22.65          
ATOM     77  O   ASP    10      -2.871  19.502  15.329  1.00 24.37          
ATOM     78  CB  ASP    10      -5.025  20.554  13.503  1.00 21.62          
ATOM     79  CG  ASP    10      -6.050  21.446  12.807  1.00 23.23          
ATOM     80  OD1 ASP    10      -7.168  21.640  13.327  1.00 23.08          
ATOM     81  OD2 ASP    10      -5.745  21.915  11.698  1.00 24.71          
ATOM     82  N   GLY    11      -4.496  19.851  16.857  1.00 20.98          
ATOM     83  CA  GLY    11      -3.957  18.923  17.835  1.00 21.29          
ATOM     84  C   GLY    11      -2.984  19.622  18.744  1.00 20.29          
ATOM     85  O   GLY    11      -2.411  19.011  19.625  1.00 20.44          
ATOM     86  N   THR    12      -2.805  20.921  18.521  1.00 19.40          
ATOM     87  CA  THR    12      -1.871  21.729  19.339  1.00 19.11          
ATOM     88  C   THR    12      -2.637  22.708  20.213  1.00 19.58          
ATOM     89  O   THR    12      -2.458  22.735  21.426  1.00 19.36          
ATOM     90  CB  THR    12      -0.867  22.495  18.453  1.00 21.12          
ATOM     91  OG1 THR    12      -0.019  21.541  17.783  1.00 20.31          
ATOM     92  CG2 THR    12       0.008  23.413  19.245  1.00 17.59          
ATOM     93  N   LEU    13      -3.474  23.521  19.569  1.00 18.83          
ATOM     94  CA  LEU    13      -4.337  24.492  20.269  1.00 19.88          
ATOM     95  C   LEU    13      -5.749  23.988  20.426  1.00 21.77          
ATOM     96  O   LEU    13      -6.442  24.308  21.389  1.00 22.36          
ATOM     97  CB  LEU    13      -4.416  25.813  19.485  1.00 20.09          
ATOM     98  CG  LEU    13      -3.072  26.518  19.181  1.00 16.57          
ATOM     99  CD1 LEU    13      -3.309  27.807  18.352  1.00 16.87          
ATOM    100  CD2 LEU    13      -2.226  26.790  20.387  1.00 17.27          
ATOM    101  N   VAL    14      -6.183  23.209  19.459  1.00 21.38          
ATOM    102  CA  VAL    14      -7.559  22.716  19.423  1.00 23.83          
ATOM    103  C   VAL    14      -7.654  21.356  18.788  1.00 24.88          
ATOM    104  O   VAL    14      -6.763  20.917  18.100  1.00 22.07          
ATOM    105  CB  VAL    14      -8.465  23.646  18.587  1.00 24.18          
ATOM    106  CG1 VAL    14      -8.415  25.085  19.152  1.00 22.94          
ATOM    107  CG2 VAL    14      -8.025  23.645  17.099  1.00 24.19          
ATOM    108  N   LYS    15      -8.786  20.725  19.014  1.00 26.16          
ATOM    109  CA  LYS    15      -9.088  19.439  18.388  1.00 27.97          
ATOM    110  C   LYS    15      -9.019  19.611  16.883  1.00 27.35          
ATOM    111  O   LYS    15      -9.466  20.603  16.330  1.00 24.55          
ATOM    112  CB  LYS    15     -10.477  18.959  18.793  1.00 27.73          
ATOM    113  CG  LYS    15     -10.779  17.547  18.334  1.00 34.64          
ATOM    114  CD  LYS    15     -12.126  17.085  18.855  1.00 39.51          
ATOM    115  CE  LYS    15     -12.488  15.720  18.263  1.00 42.92          
ATOM    116  NZ  LYS    15     -13.820  15.244  18.744  1.00 47.58          
ATOM    117  N   ASP    16      -8.465  18.621  16.215  1.00 26.97          
ATOM    118  CA  ASP    16      -8.309  18.684  14.757  0.50 27.81          
ATOM    120  C   ASP    16      -9.595  19.136  14.098  1.00 28.75          
ATOM    121  O   ASP    16     -10.682  18.610  14.367  1.00 29.43          
ATOM    122  CB  ASP    16      -7.870  17.336  14.150  0.50 28.80          
ATOM    124  CG  ASP    16      -6.464  16.937  14.550  0.50 28.38          
ATOM    126  OD1 ASP    16      -5.548  17.784  14.519  0.50 32.75          
ATOM    128  OD2 ASP    16      -6.272  15.749  14.871  0.50 37.64          
ATOM    130  N   GLY    17      -9.459  20.141  13.259  1.00 27.20          
ATOM    131  CA  GLY    17     -10.572  20.707  12.506  1.00 27.99          
ATOM    132  C   GLY    17     -11.523  21.657  13.232  1.00 27.88          
ATOM    133  O   GLY    17     -12.399  22.249  12.592  1.00 28.85          
ATOM    134  N   SER    18     -11.323  21.845  14.537  1.00 25.29          
ATOM    135  CA  SER    18     -12.216  22.731  15.293  0.50 24.71          
ATOM    137  C   SER    18     -12.245  24.139  14.754  1.00 24.30          
ATOM    138  O   SER    18     -11.260  24.663  14.231  1.00 23.46          
ATOM    139  CB  SER    18     -11.882  22.797  16.777  0.50 24.61          
ATOM    141  OG  SER    18     -12.823  23.645  17.425  0.50 18.36          
ATOM    143  N   LEU    19     -13.414  24.732  14.903  1.00 24.31          
ATOM    144  CA  LEU    19     -13.687  26.080  14.450  1.00 25.40          
ATOM    145  C   LEU    19     -13.701  27.013  15.651  1.00 26.09          
ATOM    146  O   LEU    19     -13.852  28.229  15.519  1.00 27.26          
ATOM    147  CB  LEU    19     -15.089  26.144  13.812  1.00 26.61          
ATOM    148  CG  LEU    19     -15.404  25.173  12.659  1.00 31.13          
ATOM    149  CD1 LEU    19     -16.869  25.290  12.250  1.00 33.91          
ATOM    150  CD2 LEU    19     -14.448  25.415  11.489  1.00 27.54          
ATOM    151  N   LEU    20     -13.604  26.407  16.823  1.00 25.52          
ATOM    152  CA  LEU    20     -13.667  27.127  18.097  1.00 26.84          
ATOM    153  C   LEU    20     -12.386  27.073  18.879  1.00 25.88          
ATOM    154  O   LEU    20     -11.674  26.065  18.898  1.00 25.24          
ATOM    155  CB  LEU    20     -14.771  26.543  18.988  1.00 27.40          
ATOM    156  CG  LEU    20     -16.160  26.471  18.374  1.00 31.94          
ATOM    157  CD1 LEU    20     -17.066  25.587  19.243  1.00 31.37          
ATOM    158  CD2 LEU    20     -16.710  27.880  18.198  1.00 32.05          
ATOM    159  N   ILE    21     -12.115  28.183  19.550  1.00 24.79          
ATOM    160  CA  ILE    21     -10.935  28.300  20.412  1.00 23.50          
ATOM    161  C   ILE    21     -11.229  29.244  21.580  1.00 24.54          
ATOM    162  O   ILE    21     -11.929  30.231  21.424  1.00 23.08          
ATOM    163  CB  ILE    21      -9.719  28.742  19.621  1.00 22.11          
ATOM    164  CG1 ILE    21      -8.438  28.534  20.430  1.00 20.88          
ATOM    165  CG2 ILE    21      -9.861  30.184  19.119  1.00 20.04          
ATOM    166  CD  ILE    21      -7.150  28.883  19.663  1.00 23.49          
ATOM    167  N   ASP    22     -10.724  28.864  22.754  1.00 23.93          
ATOM    168  CA  ASP    22     -10.917  29.625  24.010  1.00 23.95          
ATOM    169  C   ASP    22     -10.488  31.087  23.827  1.00 23.15          
ATOM    170  O   ASP    22      -9.372  31.334  23.384  1.00 21.96          
ATOM    171  CB  ASP    22     -10.076  28.979  25.110  1.00 25.75          
ATOM    172  CG  ASP    22     -10.408  29.480  26.467  1.00 32.99          
ATOM    173  OD1 ASP    22     -10.738  30.677  26.605  1.00 33.18          
ATOM    174  OD2 ASP    22     -10.271  28.662  27.400  1.00 38.52          
ATOM    175  N   PRO    23     -11.369  32.054  24.166  1.00 21.72          
ATOM    176  CA  PRO    23     -10.998  33.462  23.939  1.00 22.56          
ATOM    177  C   PRO    23      -9.828  33.921  24.755  1.00 20.66          
ATOM    178  O   PRO    23      -9.199  34.931  24.427  1.00 21.40          
ATOM    179  CB  PRO    23     -12.282  34.241  24.286  1.00 24.29          
ATOM    180  CG  PRO    23     -13.098  33.290  25.113  1.00 24.23          
ATOM    181  CD  PRO    23     -12.795  31.929  24.526  1.00 23.69          
ATOM    182  N   GLU    24      -9.482  33.160  25.782  1.00 20.65          
ATOM    183  CA  GLU    24      -8.342  33.558  26.591  1.00 20.30          
ATOM    184  C   GLU    24      -7.097  33.494  25.712  1.00 19.71          
ATOM    185  O   GLU    24      -6.148  34.245  25.911  1.00 17.10          
ATOM    186  CB  GLU    24      -8.187  32.751  27.885  1.00 22.30          
ATOM    187  CG  GLU    24      -7.275  33.448  28.853  1.00 26.80          
ATOM    188  CD  GLU    24      -7.094  32.706  30.158  1.00 30.68          
ATOM    189  OE1 GLU    24      -7.786  31.690  30.382  1.00 34.15          
ATOM    190  OE2 GLU    24      -6.250  33.156  30.962  1.00 35.86          
ATOM    191  N   TYR    25      -7.132  32.628  24.695  1.00 19.01          
ATOM    192  CA  TYR    25      -5.989  32.546  23.759  1.00 17.76          
ATOM    193  C   TYR    25      -5.858  33.881  23.043  1.00 18.37          
ATOM    194  O   TYR    25      -4.771  34.399  22.826  1.00 17.53          
ATOM    195  CB  TYR    25      -6.139  31.414  22.709  1.00 18.85          
ATOM    196  CG  TYR    25      -5.556  30.082  23.143  1.00 15.41          
ATOM    197  CD1 TYR    25      -4.207  29.897  23.144  1.00 18.89          
ATOM    198  CD2 TYR    25      -6.360  29.018  23.511  1.00 20.18          
ATOM    199  CE1 TYR    25      -3.647  28.698  23.522  1.00 18.55          
ATOM    200  CE2 TYR    25      -5.808  27.811  23.911  1.00 18.85          
ATOM    201  CZ  TYR    25      -4.436  27.659  23.897  1.00 16.23          
ATOM    202  OH  TYR    25      -3.809  26.461  24.290  1.00 20.29          
ATOM    203  N   MET    26      -6.993  34.448  22.684  1.00 18.83          
ATOM    204  CA  MET    26      -6.966  35.676  21.882  1.00 17.40          
ATOM    205  C   MET    26      -6.436  36.804  22.735  1.00 16.09          
ATOM    206  O   MET    26      -5.672  37.621  22.283  1.00 16.95          
ATOM    207  CB  MET    26      -8.347  36.054  21.336  1.00 18.92          
ATOM    208  CG  MET    26      -9.080  35.007  20.537  1.00 19.06          
ATOM    209  SD  MET    26      -8.130  34.465  18.937  1.00 21.41          
ATOM    210  CE  MET    26      -7.438  32.752  19.579  1.00 22.48          
ATOM    211  N   SER    27      -6.839  36.829  24.006  1.00 16.66          
ATOM    212  CA  SER    27      -6.414  37.913  24.910  1.00 15.18          
ATOM    213  C   SER    27      -4.936  37.874  25.201  1.00 15.77          
ATOM    214  O   SER    27      -4.224  38.872  25.164  1.00 15.81          
ATOM    215  CB  SER    27      -7.217  37.852  26.219  1.00 17.79          
ATOM    216  OG  SER    27      -6.719  38.813  27.147  1.00 21.89          
ATOM    217  N   VAL    28      -4.456  36.663  25.474  1.00 17.45          
ATOM    218  CA  VAL    28      -3.042  36.478  25.809  1.00 16.39          
ATOM    219  C   VAL    28      -2.153  36.789  24.602  1.00 16.85          
ATOM    220  O   VAL    28      -1.179  37.524  24.704  1.00 16.49          
ATOM    221  CB  VAL    28      -2.798  35.051  26.390  1.00 17.76          
ATOM    222  CG1 VAL    28      -1.325  34.754  26.503  1.00 17.92          
ATOM    223  CG2 VAL    28      -3.511  34.900  27.762  1.00 17.81          
ATOM    224  N   ILE    29      -2.533  36.281  23.435  1.00 17.11          
ATOM    225  CA  ILE    29      -1.742  36.520  22.218  1.00 16.42          
ATOM    226  C   ILE    29      -1.701  38.019  21.900  1.00 15.96          
ATOM    227  O   ILE    29      -0.666  38.586  21.557  1.00 14.80          
ATOM    228  CB  ILE    29      -2.286  35.665  21.017  1.00 16.22          
ATOM    229  CG1 ILE    29      -2.033  34.174  21.272  1.00 17.99          
ATOM    230  CG2 ILE    29      -1.713  36.139  19.718  1.00 15.07          
ATOM    231  CD  ILE    29      -2.790  33.241  20.319  1.00 18.03          
ATOM    232  N   ASP    30      -2.832  38.673  22.106  1.00 16.64          
ATOM    233  CA  ASP    30      -2.948  40.109  21.827  1.00 16.14          
ATOM    234  C   ASP    30      -1.968  40.842  22.731  1.00 16.31          
ATOM    235  O   ASP    30      -1.206  41.721  22.295  1.00 16.41          
ATOM    236  CB  ASP    30      -4.390  40.598  22.072  1.00 15.79          
ATOM    237  CG  ASP    30      -4.607  42.002  21.586  1.00 24.50          
ATOM    238  OD1 ASP    30      -4.290  42.292  20.433  1.00 25.90          
ATOM    239  OD2 ASP    30      -5.034  42.841  22.382  1.00 29.64          
ATOM    240  N   ARG    31      -1.912  40.382  23.975  1.00 18.56          
ATOM    241  CA  ARG    31      -1.022  40.997  24.972  1.00 19.87          
ATOM    242  C   ARG    31       0.446  40.804  24.626  1.00 20.22          
ATOM    243  O   ARG    31       1.267  41.705  24.748  1.00 20.29          
ATOM    244  CB  ARG    31      -1.328  40.459  26.384  1.00 21.41          
ATOM    245  CG  ARG    31      -2.647  40.968  26.990  1.00 23.85          
ATOM    246  CD  ARG    31      -3.095  40.137  28.186  1.00 27.63          
ATOM    247  NE  ARG    31      -2.276  40.539  29.307  1.00 34.84          
ATOM    248  CZ  ARG    31      -2.097  39.851  30.422  1.00 39.37          
ATOM    249  NH1 ARG    31      -2.671  38.684  30.594  1.00 37.75          
ATOM    250  NH2 ARG    31      -1.298  40.350  31.361  1.00 43.02          
ATOM    251  N   LEU    32       0.762  39.604  24.140  1.00 20.20          
ATOM    252  CA  LEU    32       2.141  39.269  23.737  1.00 18.96          
ATOM    253  C   LEU    32       2.523  40.106  22.531  1.00 18.91          
ATOM    254  O   LEU    32       3.635  40.653  22.447  1.00 18.03          
ATOM    255  CB  LEU    32       2.276  37.760  23.431  1.00 19.82          
ATOM    256  CG  LEU    32       2.142  36.812  24.633  1.00 21.71          
ATOM    257  CD1 LEU    32       2.080  35.333  24.156  1.00 18.46          
ATOM    258  CD2 LEU    32       3.236  37.035  25.678  1.00 24.20          
ATOM    259  N   ILE    33       1.585  40.277  21.609  1.00 19.13          
ATOM    260  CA  ILE    33       1.883  41.060  20.409  1.00 18.37          
ATOM    261  C   ILE    33       2.162  42.528  20.759  1.00 20.17          
ATOM    262  O   ILE    33       3.101  43.147  20.255  1.00 19.87          
ATOM    263  CB  ILE    33       0.788  40.946  19.372  1.00 17.75          
ATOM    264  CG1 ILE    33       0.807  39.515  18.834  1.00 18.02          
ATOM    265  CG2 ILE    33       1.044  41.968  18.223  1.00 14.83          
ATOM    266  CD  ILE    33      -0.426  39.114  17.973  1.00 16.34          
ATOM    267  N   ASP    34       1.355  43.020  21.674  1.00 20.32          
ATOM    268  CA  ASP    34       1.451  44.395  22.204  1.00 23.15          
ATOM    269  C   ASP    34       2.790  44.615  22.909  1.00 24.83          
ATOM    270  O   ASP    34       3.290  45.732  22.964  1.00 25.60          
ATOM    271  CB  ASP    34       0.274  44.714  23.143  1.00 24.52          
ATOM    272  CG  ASP    34      -1.015  44.959  22.383  1.00 24.57          
ATOM    273  OD1 ASP    34      -0.947  45.060  21.148  1.00 25.32          
ATOM    274  OD2 ASP    34      -2.096  45.012  23.007  1.00 28.19          
ATOM    275  N   LYS    35       3.395  43.530  23.387  1.00 25.53          
ATOM    276  CA  LYS    35       4.710  43.576  24.058  1.00 27.19          
ATOM    277  C   LYS    35       5.822  43.578  23.033  1.00 28.80          
ATOM    278  O   LYS    35       6.998  43.684  23.367  1.00 30.43          
ATOM    279  CB  LYS    35       4.917  42.424  25.050  1.00 27.27          
ATOM    280  CG  LYS    35       4.069  42.534  26.322  1.00 31.75          
ATOM    281  N   GLY    36       5.427  43.449  21.780  1.00 27.13          
ATOM    282  CA  GLY    36       6.342  43.510  20.656  1.00 26.73          
ATOM    283  C   GLY    36       6.720  42.176  20.027  1.00 26.17          
ATOM    284  O   GLY    36       7.608  42.112  19.194  1.00 29.30          
ATOM    285  N   ILE    37       6.057  41.111  20.446  1.00 23.45          
ATOM    286  CA  ILE    37       6.343  39.777  19.891  1.00 22.84          
ATOM    287  C   ILE    37       5.543  39.604  18.592  1.00 21.37          
ATOM    288  O   ILE    37       4.402  40.009  18.504  1.00 22.85          
ATOM    289  CB  ILE    37       5.991  38.640  20.914  1.00 23.11          
ATOM    290  CG1 ILE    37       6.827  38.805  22.202  1.00 24.52          
ATOM    291  CG2 ILE    37       6.275  37.290  20.322  1.00 24.91          
ATOM    292  CD  ILE    37       6.559  37.801  23.353  1.00 24.86          
ATOM    293  N   ILE    38       6.189  39.054  17.569  1.00 19.88          
ATOM    294  CA  ILE    38       5.509  38.716  16.316  1.00 20.62          
ATOM    295  C   ILE    38       4.887  37.335  16.490  1.00 18.13          
ATOM    296  O   ILE    38       5.543  36.397  16.934  1.00 19.11          
ATOM    297  CB  ILE    38       6.491  38.723  15.127  1.00 21.60          
ATOM    298  CG1 ILE    38       7.074  40.128  14.938  1.00 20.96          
ATOM    299  CG2 ILE    38       5.821  38.199  13.814  1.00 21.74          
ATOM    300  CD  ILE    38       8.203  40.169  14.018  1.00 23.92          
ATOM    301  N   PHE    39       3.621  37.206  16.121  1.00 16.60          
ATOM    302  CA  PHE    39       2.907  35.958  16.294  1.00 14.82          
ATOM    303  C   PHE    39       2.492  35.399  14.953  1.00 14.68          
ATOM    304  O   PHE    39       1.892  36.084  14.130  1.00 15.97          
ATOM    305  CB  PHE    39       1.714  36.109  17.209  1.00 16.09          
ATOM    306  CG  PHE    39       1.248  34.826  17.815  1.00 20.08          
ATOM    307  CD1 PHE    39       0.400  33.985  17.113  1.00 19.20          
ATOM    308  CD2 PHE    39       1.672  34.447  19.079  1.00 19.11          
ATOM    309  CE1 PHE    39      -0.014  32.796  17.653  1.00 19.85          
ATOM    310  CE2 PHE    39       1.251  33.250  19.623  1.00 21.98          
ATOM    311  CZ  PHE    39       0.427  32.424  18.908  1.00 18.35          
ATOM    312  N   VAL    40       2.867  34.142  14.755  1.00 16.68          
ATOM    313  CA  VAL    40       2.645  33.465  13.480  1.00 14.58          
ATOM    314  C   VAL    40       1.858  32.178  13.659  1.00 15.68          
ATOM    315  O   VAL    40       2.244  31.294  14.432  1.00 16.77          
ATOM    316  CB  VAL    40       3.985  33.094  12.788  1.00 14.74          
ATOM    317  CG1 VAL    40       3.745  32.463  11.381  1.00 15.68          
ATOM    318  CG2 VAL    40       5.047  34.286  12.729  1.00 12.89          
ATOM    319  N   VAL    41       0.739  32.117  12.961  1.00 15.21          
ATOM    320  CA  VAL    41      -0.060  30.892  12.851  1.00 16.78          
ATOM    321  C   VAL    41       0.558  30.143  11.668  1.00 17.32          
ATOM    322  O   VAL    41       0.618  30.675  10.560  1.00 16.55          
ATOM    323  CB  VAL    41      -1.542  31.194  12.570  1.00 19.97          
ATOM    324  CG1 VAL    41      -2.294  29.931  12.506  1.00 23.02          
ATOM    325  CG2 VAL    41      -2.141  32.106  13.646  1.00 23.91          
ATOM    326  N   CYS    42       1.009  28.921  11.926  1.00 17.87          
ATOM    327  CA  CYS    42       1.804  28.101  10.976  1.00 17.88          
ATOM    328  C   CYS    42       1.251  26.694  10.912  1.00 19.32          
ATOM    329  O   CYS    42       1.524  25.858  11.788  1.00 19.41          
ATOM    330  CB  CYS    42       3.246  28.101  11.465  1.00 17.90          
ATOM    331  SG  CYS    42       4.392  27.260  10.336  1.00 21.73          
ATOM    332  N   SER    43       0.465  26.451   9.869  1.00 17.27          
ATOM    333  CA  SER    43      -0.355  25.256   9.765  1.00 17.86          
ATOM    334  C   SER    43      -0.607  24.679   8.392  1.00 18.71          
ATOM    335  O   SER    43      -0.319  25.259   7.334  1.00 17.91          
ATOM    336  CB  SER    43      -1.717  25.658  10.370  1.00 18.91          
ATOM    337  OG  SER    43      -2.705  24.653  10.362  1.00 21.76          
ATOM    338  N   GLY    44      -1.159  23.483   8.448  1.00 17.88          
ATOM    339  CA  GLY    44      -1.597  22.783   7.249  1.00 16.37          
ATOM    340  C   GLY    44      -2.872  23.392   6.723  1.00 17.74          
ATOM    341  O   GLY    44      -3.273  23.178   5.598  1.00 16.15          
ATOM    342  N   ARG    45      -3.526  24.175   7.577  1.00 18.34          
ATOM    343  CA  ARG    45      -4.825  24.736   7.220  1.00 18.72          
ATOM    344  C   ARG    45      -4.747  25.804   6.157  1.00 18.81          
ATOM    345  O   ARG    45      -3.711  26.443   5.975  1.00 17.57          
ATOM    346  CB  ARG    45      -5.520  25.356   8.457  1.00 19.16          
ATOM    347  CG  ARG    45      -5.970  24.438   9.548  1.00 20.04          
ATOM    348  CD  ARG    45      -6.957  25.208  10.446  1.00 20.71          
ATOM    349  NE  ARG    45      -7.389  24.383  11.576  1.00 18.73          
ATOM    350  CZ  ARG    45      -8.456  24.633  12.302  1.00 17.98          
ATOM    351  NH1 ARG    45      -9.209  25.672  12.000  1.00 19.44          
ATOM    352  NH2 ARG    45      -8.775  23.825  13.294  1.00 20.03          
ATOM    353  N   GLN    46      -5.875  25.978   5.467  1.00 17.06          
ATOM    354  CA  GLN    46      -6.044  27.054   4.490  1.00 18.53          
ATOM    355  C   GLN    46      -6.136  28.368   5.225  1.00 18.10          
ATOM    356  O   GLN    46      -6.448  28.410   6.405  1.00 19.27          
ATOM    357  CB  GLN    46      -7.341  26.928   3.694  1.00 17.96          
ATOM    358  CG  GLN    46      -7.420  25.717   2.859  1.00 24.28          
ATOM    359  CD  GLN    46      -8.672  25.724   2.044  1.00 25.88          
ATOM    360  OE1 GLN    46      -9.783  25.633   2.584  1.00 26.72          
ATOM    361  NE2 GLN    46      -8.512  25.803   0.725  1.00 22.53          
ATOM    362  N   PHE    47      -5.894  29.455   4.490  1.00 17.84          
ATOM    363  CA  PHE    47      -5.955  30.802   5.082  1.00 18.91          
ATOM    364  C   PHE    47      -7.301  31.078   5.677  1.00 18.88          
ATOM    365  O   PHE    47      -7.408  31.526   6.811  1.00 18.23          
ATOM    366  CB  PHE    47      -5.579  31.884   4.067  1.00 19.57          
ATOM    367  CG  PHE    47      -5.731  33.266   4.580  1.00 18.20          
ATOM    368  CD1 PHE    47      -5.046  33.679   5.721  1.00 19.16          
ATOM    369  CD2 PHE    47      -6.557  34.167   3.937  1.00 20.32          
ATOM    370  CE1 PHE    47      -5.174  34.985   6.185  1.00 19.98          
ATOM    371  CE2 PHE    47      -6.676  35.459   4.399  1.00 24.37          
ATOM    372  CZ  PHE    47      -5.963  35.871   5.522  1.00 19.99          
ATOM    373  N   SER    48      -8.342  30.780   4.912  1.00 21.26          
ATOM    374  CA  SER    48      -9.709  31.064   5.348  1.00 20.46          
ATOM    375  C   SER    48      -9.999  30.475   6.711  1.00 19.31          
ATOM    376  O   SER    48     -10.677  31.090   7.539  1.00 19.46          
ATOM    377  CB  SER    48     -10.753  30.531   4.329  1.00 21.99          
ATOM    378  OG  SER    48     -10.622  29.122   4.144  1.00 26.11          
ATOM    379  N   SER    49      -9.476  29.280   6.937  1.00 17.66          
ATOM    380  CA  SER    49      -9.694  28.542   8.175  1.00 17.62          
ATOM    381  C   SER    49      -8.919  29.180   9.340  1.00 17.43          
ATOM    382  O   SER    49      -9.432  29.354  10.446  1.00 17.30          
ATOM    383  CB  SER    49      -9.328  27.076   8.017  1.00 17.88          
ATOM    384  OG  SER    49      -9.653  26.373   9.206  1.00 20.17          
ATOM    385  N   GLU    50      -7.691  29.584   9.064  1.00 16.79          
ATOM    386  CA  GLU    50      -6.882  30.242  10.096  1.00 17.38          
ATOM    387  C   GLU    50      -7.485  31.588  10.473  1.00 17.53          
ATOM    388  O   GLU    50      -7.549  31.973  11.658  1.00 19.94          
ATOM    389  CB  GLU    50      -5.437  30.474   9.615  1.00 15.11          
ATOM    390  CG  GLU    50      -4.650  29.239   9.323  1.00 16.05          
ATOM    391  CD  GLU    50      -3.245  29.530   8.803  1.00 18.88          
ATOM    392  OE1 GLU    50      -2.969  30.680   8.433  1.00 19.69          
ATOM    393  OE2 GLU    50      -2.403  28.617   8.768  1.00 19.05          
ATOM    394  N   PHE    51      -7.972  32.267   9.458  1.00 17.94          
ATOM    395  CA  PHE    51      -8.409  33.681   9.592  1.00 19.16          
ATOM    396  C   PHE    51      -9.703  33.700  10.396  1.00 21.13          
ATOM    397  O   PHE    51      -9.952  34.611  11.186  1.00 22.85          
ATOM    398  CB  PHE    51      -8.584  34.302   8.211  1.00 19.40          
ATOM    399  CG  PHE    51      -8.398  35.802   8.144  1.00 23.12          
ATOM    400  CD1 PHE    51      -7.277  36.424   8.693  1.00 24.77          
ATOM    401  CD2 PHE    51      -9.280  36.573   7.385  1.00 24.94          
ATOM    402  CE1 PHE    51      -7.084  37.790   8.550  1.00 20.07          
ATOM    403  CE2 PHE    51      -9.078  37.911   7.222  1.00 24.54          
ATOM    404  CZ  PHE    51      -7.999  38.528   7.824  1.00 22.96          
ATOM    405  N   LYS    52     -10.494  32.642  10.233  1.00 20.62          
ATOM    406  CA  LYS    52     -11.763  32.521  10.992  1.00 21.43          
ATOM    407  C   LYS    52     -11.527  32.123  12.456  1.00 19.36          
ATOM    408  O   LYS    52     -12.083  32.699  13.377  1.00 18.21          
ATOM    409  CB  LYS    52     -12.708  31.506  10.332  1.00 22.97          
ATOM    410  CG  LYS    52     -13.303  31.965   9.019  1.00 29.91          
ATOM    411  CD  LYS    52     -14.169  30.843   8.410  1.00 37.53          
ATOM    412  CE  LYS    52     -14.466  31.065   6.941  1.00 44.31          
ATOM    413  NZ  LYS    52     -15.101  29.836   6.340  1.00 51.01          
ATOM    414  N   LEU    53     -10.653  31.157  12.670  1.00 18.49          
ATOM    415  CA  LEU    53     -10.394  30.683  14.012  1.00 18.04          
ATOM    416  C   LEU    53      -9.833  31.818  14.903  1.00 17.36          
ATOM    417  O   LEU    53     -10.131  31.901  16.086  1.00 19.08          
ATOM    418  CB  LEU    53      -9.408  29.522  13.987  1.00 20.52          
ATOM    419  CG  LEU    53      -9.085  28.844  15.317  1.00 19.67          
ATOM    420  CD1 LEU    53     -10.320  28.140  15.864  1.00 22.05          
ATOM    421  CD2 LEU    53      -7.882  27.865  15.126  1.00 22.08          
ATOM    422  N   PHE    54      -9.036  32.685  14.300  1.00 17.30          
ATOM    423  CA  PHE    54      -8.399  33.782  15.033  1.00 15.40          
ATOM    424  C   PHE    54      -9.108  35.135  14.802  1.00 16.33          
ATOM    425  O   PHE    54      -8.535  36.220  14.981  1.00 16.29          
ATOM    426  CB  PHE    54      -6.921  33.901  14.684  1.00 15.68          
ATOM    427  CG  PHE    54      -6.070  32.787  15.241  1.00 17.72          
ATOM    428  CD1 PHE    54      -5.920  31.599  14.531  1.00 15.67          
ATOM    429  CD2 PHE    54      -5.434  32.922  16.454  1.00 19.01          
ATOM    430  CE1 PHE    54      -5.131  30.581  15.032  1.00 15.81          
ATOM    431  CE2 PHE    54      -4.661  31.892  16.978  1.00 23.59          
ATOM    432  CZ  PHE    54      -4.504  30.724  16.256  1.00 17.98          
ATOM    433  N   ALA    55     -10.365  35.032  14.421  1.00 16.94          
ATOM    434  CA  ALA    55     -11.170  36.191  14.023  1.00 17.58          
ATOM    435  C   ALA    55     -11.016  37.444  14.907  1.00 17.96          
ATOM    436  O   ALA    55     -10.851  38.535  14.374  1.00 18.51          
ATOM    437  CB  ALA    55     -12.664  35.817  13.921  1.00 17.92          
ATOM    438  N   PRO    56     -11.046  37.284  16.234  1.00 18.17          
ATOM    439  CA  PRO    56     -11.022  38.508  17.100  1.00 16.98          
ATOM    440  C   PRO    56      -9.763  39.338  17.011  1.00 18.35          
ATOM    441  O   PRO    56      -9.802  40.553  17.270  1.00 18.86          
ATOM    442  CB  PRO    56     -11.230  37.939  18.511  1.00 15.88          
ATOM    443  CG  PRO    56     -11.932  36.629  18.321  1.00 18.46          
ATOM    444  CD  PRO    56     -11.357  36.077  17.009  1.00 18.00          
ATOM    445  N   ILE    57      -8.631  38.693  16.674  1.00 17.07          
ATOM    446  CA  ILE    57      -7.350  39.383  16.541  1.00 16.55          
ATOM    447  C   ILE    57      -6.673  39.125  15.207  1.00 15.97          
ATOM    448  O   ILE    57      -5.467  39.313  15.074  1.00 15.65          
ATOM    449  CB  ILE    57      -6.346  39.032  17.683  1.00 17.83          
ATOM    450  CG1 ILE    57      -6.060  37.522  17.715  1.00 19.83          
ATOM    451  CG2 ILE    57      -6.907  39.510  19.032  1.00 23.24          
ATOM    452  CD  ILE    57      -4.959  37.084  18.646  1.00 20.74          
ATOM    453  N   LYS    58      -7.477  38.801  14.209  1.00 17.77          
ATOM    454  CA  LYS    58      -6.948  38.379  12.887  1.00 17.46          
ATOM    455  C   LYS    58      -6.040  39.374  12.193  1.00 19.00          
ATOM    456  O   LYS    58      -5.125  39.014  11.462  1.00 19.71          
ATOM    457  CB  LYS    58      -8.089  37.917  11.986  1.00 18.40          
ATOM    458  CG  LYS    58      -8.917  39.002  11.435  1.00 18.05          
ATOM    459  CD  LYS    58     -10.052  38.498  10.587  1.00 23.42          
ATOM    460  CE  LYS    58     -10.639  39.637   9.743  1.00 27.06          
ATOM    461  NZ  LYS    58     -11.063  40.845  10.553  1.00 31.31          
ATOM    462  N   HSD    59      -6.275  40.645  12.462  1.00 17.00          
ATOM    463  CA  HSD    59      -5.504  41.744  11.874  1.00 18.05          
ATOM    464  C   HSD    59      -4.070  41.865  12.379  1.00 20.22          
ATOM    465  O   HSD    59      -3.249  42.525  11.761  1.00 21.53          
ATOM    466  CB  HSD    59      -6.225  43.080  12.184  1.00 18.39          
ATOM    467  CG  HSD    59      -6.350  43.344  13.649  1.00 17.74          
ATOM    468  ND1 HSD    59      -7.271  42.687  14.441  1.00 17.01          
ATOM    469  CD2 HSD    59      -5.624  44.128  14.486  1.00 21.22          
ATOM    470  CE1 HSD    59      -7.130  43.084  15.694  1.00 19.10          
ATOM    471  NE2 HSD    59      -6.130  43.946  15.753  1.00 16.33          
ATOM    472  N   LYS    60      -3.773  41.219  13.493  1.00 18.96          
ATOM    473  CA  LYS    60      -2.493  41.416  14.163  1.00 20.77          
ATOM    474  C   LYS    60      -1.516  40.268  13.981  1.00 18.04          
ATOM    475  O   LYS    60      -0.447  40.277  14.557  1.00 18.57          
ATOM    476  CB  LYS    60      -2.688  41.508  15.689  1.00 22.78          
ATOM    477  CG  LYS    60      -3.582  42.543  16.209  1.00 32.19          
ATOM    478  CD  LYS    60      -3.345  42.711  17.679  1.00 31.54          
ATOM    479  CE  LYS    60      -2.293  43.764  17.996  1.00 32.14          
ATOM    480  NZ  LYS    60      -2.691  44.399  19.303  1.00 30.49          
ATOM    481  N   LEU    61      -1.943  39.278  13.219  1.00 17.90          
ATOM    482  CA  LEU    61      -1.159  38.039  13.043  1.00 17.08          
ATOM    483  C   LEU    61      -0.506  37.920  11.691  1.00 18.25          
ATOM    484  O   LEU    61      -0.866  38.631  10.745  1.00 16.90          
ATOM    485  CB  LEU    61      -2.070  36.796  13.231  1.00 14.69          
ATOM    486  CG  LEU    61      -2.880  36.693  14.513  1.00 19.75          
ATOM    487  CD1 LEU    61      -3.792  35.475  14.518  1.00 19.62          
ATOM    488  CD2 LEU    61      -1.911  36.655  15.719  1.00 22.12          
ATOM    489  N   LEU    62       0.504  37.030  11.645  1.00 16.83          
ATOM    490  CA  LEU    62       1.101  36.558  10.376  1.00 17.22          
ATOM    491  C   LEU    62       0.668  35.116  10.175  1.00 14.81          
ATOM    492  O   LEU    62       0.425  34.372  11.128  1.00 16.36          
ATOM    493  CB  LEU    62       2.599  36.676  10.367  1.00 17.91          
ATOM    494  CG  LEU    62       3.127  38.110  10.278  1.00 21.69          
ATOM    495  CD1 LEU    62       4.633  38.083  10.412  1.00 24.00          
ATOM    496  CD2 LEU    62       2.703  38.763   8.986  1.00 26.11          
ATOM    497  N   TYR    63       0.501  34.753   8.911  1.00 14.70          
ATOM    498  CA  TYR    63      -0.053  33.450   8.539  1.00 13.25          
ATOM    499  C   TYR    63       0.795  32.664   7.572  1.00 15.45          
ATOM    500  O   TYR    63       1.213  33.159   6.527  1.00 16.07          
ATOM    501  CB  TYR    63      -1.420  33.650   7.865  1.00 14.81          
ATOM    502  CG  TYR    63      -2.417  34.374   8.731  1.00 12.23          
ATOM    503  CD1 TYR    63      -2.433  35.752   8.799  1.00 13.85          
ATOM    504  CD2 TYR    63      -3.347  33.679   9.483  1.00 12.48          
ATOM    505  CE1 TYR    63      -3.331  36.408   9.602  1.00 13.81          
ATOM    506  CE2 TYR    63      -4.254  34.341  10.301  1.00 16.72          
ATOM    507  CZ  TYR    63      -4.242  35.693  10.362  1.00 14.19          
ATOM    508  OH  TYR    63      -5.162  36.338  11.195  1.00 15.85          
ATOM    509  N   ILE    64       1.053  31.427   7.971  1.00 14.44          
ATOM    510  CA  ILE    64       1.696  30.435   7.116  1.00 13.98          
ATOM    511  C   ILE    64       0.619  29.363   6.926  1.00 14.78          
ATOM    512  O   ILE    64       0.093  28.795   7.891  1.00 15.06          
ATOM    513  CB  ILE    64       3.018  29.896   7.682  1.00 14.83          
ATOM    514  CG1 ILE    64       4.083  31.001   7.709  1.00 14.16          
ATOM    515  CG2 ILE    64       3.507  28.684   6.816  1.00 17.85          
ATOM    516  CD  ILE    64       5.322  30.660   8.521  1.00 16.09          
ATOM    517  N   THR    65       0.266  29.114   5.665  1.00 14.07          
ATOM    518  CA  THR    65      -0.859  28.255   5.356  1.00 15.41          
ATOM    519  C   THR    65      -0.466  27.102   4.463  1.00 17.19          
ATOM    520  O   THR    65       0.610  27.080   3.868  1.00 18.68          
ATOM    521  CB  THR    65      -1.984  29.054   4.604  1.00 16.70          
ATOM    522  OG1 THR    65      -1.670  29.213   3.206  1.00 17.59          
ATOM    523  CG2 THR    65      -2.229  30.449   5.239  1.00 16.46          
ATOM    524  N   ASP    66      -1.360  26.132   4.410  1.00 16.41          
ATOM    525  CA  ASP    66      -1.222  25.026   3.435  1.00 17.14          
ATOM    526  C   ASP    66       0.109  24.331   3.540  1.00 16.06          
ATOM    527  O   ASP    66       0.727  23.945   2.515  1.00 18.83          
ATOM    528  CB  ASP    66      -1.459  25.520   2.003  1.00 17.24          
ATOM    529  CG  ASP    66      -2.884  25.963   1.758  1.00 20.63          
ATOM    530  OD1 ASP    66      -3.189  27.136   2.020  1.00 22.01          
ATOM    531  OD2 ASP    66      -3.703  25.128   1.297  1.00 20.25          
ATOM    532  N   GLY    67       0.563  24.233   4.777  1.00 15.62          
ATOM    533  CA  GLY    67       1.779  23.522   5.137  1.00 17.55          
ATOM    534  C   GLY    67       3.060  24.223   4.755  1.00 18.81          
ATOM    535  O   GLY    67       4.120  23.601   4.662  1.00 22.07          
ATOM    536  N   GLY    68       2.981  25.520   4.544  1.00 15.90          
ATOM    537  CA  GLY    68       4.186  26.273   4.190  1.00 15.65          
ATOM    538  C   GLY    68       4.301  26.763   2.760  1.00 16.03          
ATOM    539  O   GLY    68       5.337  27.280   2.376  1.00 15.98          
ATOM    540  N   THR    69       3.228  26.649   1.981  1.00 16.02          
ATOM    541  CA  THR    69       3.244  27.055   0.579  1.00 15.79          
ATOM    542  C   THR    69       2.813  28.508   0.369  1.00 18.17          
ATOM    543  O   THR    69       3.023  29.093  -0.703  1.00 17.56          
ATOM    544  CB  THR    69       2.362  26.149  -0.301  1.00 18.10          
ATOM    545  OG1 THR    69       1.028  26.098   0.223  1.00 14.38          
ATOM    546  CG2 THR    69       2.960  24.736  -0.420  1.00 16.80          
ATOM    547  N   VAL    70       2.242  29.086   1.435  1.00 16.83          
ATOM    548  CA  VAL    70       1.828  30.503   1.424  1.00 16.38          
ATOM    549  C   VAL    70       2.141  31.159   2.765  1.00 16.16          
ATOM    550  O   VAL    70       1.896  30.561   3.829  1.00 15.08          
ATOM    551  CB  VAL    70       0.324  30.666   1.173  1.00 17.51          
ATOM    552  CG1 VAL    70      -0.042  32.143   0.903  1.00 20.99          
ATOM    553  CG2 VAL    70      -0.160  29.768   0.031  1.00 18.65          
ATOM    554  N   VAL    71       2.724  32.353   2.654  1.00 15.97          
ATOM    555  CA  VAL    71       3.066  33.236   3.767  1.00 15.84          
ATOM    556  C   VAL    71       2.388  34.590   3.486  1.00 18.78          
ATOM    557  O   VAL    71       2.594  35.210   2.442  1.00 19.42          
ATOM    558  CB  VAL    71       4.571  33.467   3.885  1.00 15.88          
ATOM    559  CG1 VAL    71       4.911  34.364   5.102  1.00 17.07          
ATOM    560  CG2 VAL    71       5.365  32.152   3.912  1.00 17.82          
ATOM    561  N   ARG    72       1.579  35.043   4.430  1.00 17.16          
ATOM    562  CA  ARG    72       0.795  36.253   4.227  1.00 17.98          
ATOM    563  C   ARG    72       0.443  37.008   5.497  1.00 18.34          
ATOM    564  O   ARG    72       0.440  36.470   6.631  1.00 18.85          
ATOM    565  CB  ARG    72      -0.494  35.909   3.456  1.00 18.68          
ATOM    566  CG  ARG    72      -1.499  34.945   4.113  1.00 19.39          
ATOM    567  CD  ARG    72      -2.754  34.988   3.237  1.00 27.02          
ATOM    568  NE  ARG    72      -3.245  36.371   3.245  1.00 35.83          
ATOM    569  CZ  ARG    72      -4.176  36.869   2.449  1.00 37.04          
ATOM    570  NH1 ARG    72      -4.743  36.130   1.474  1.00 31.24          
ATOM    571  NH2 ARG    72      -4.513  38.131   2.613  1.00 41.01          
ATOM    572  N   THR    73       0.141  38.271   5.266  1.00 19.27          
ATOM    573  CA  THR    73      -0.309  39.162   6.305  1.00 19.78          
ATOM    574  C   THR    73      -1.808  39.085   6.147  1.00 21.43          
ATOM    575  O   THR    73      -2.310  38.404   5.265  1.00 21.69          
ATOM    576  CB  THR    73       0.190  40.638   6.122  1.00 21.38          
ATOM    577  OG1 THR    73      -0.625  41.290   5.149  1.00 22.94          
ATOM    578  CG2 THR    73       1.651  40.710   5.694  1.00 21.57          
ATOM    579  N   PRO    74      -2.548  39.767   7.008  1.00 22.46          
ATOM    580  CA  PRO    74      -3.972  39.694   6.853  1.00 24.12          
ATOM    581  C   PRO    74      -4.456  40.298   5.560  1.00 26.90          
ATOM    582  O   PRO    74      -5.529  39.958   5.094  1.00 29.91          
ATOM    583  CB  PRO    74      -4.504  40.547   8.026  1.00 24.11          
ATOM    584  CG  PRO    74      -3.432  40.582   9.001  1.00 21.47          
ATOM    585  CD  PRO    74      -2.142  40.403   8.270  1.00 22.90          
ATOM    586  N   LYS    75      -3.663  41.189   4.982  1.00 27.74          
ATOM    587  CA  LYS    75      -4.114  41.882   3.778  1.00 30.48          
ATOM    588  C   LYS    75      -3.383  41.506   2.502  1.00 30.90          
ATOM    589  O   LYS    75      -3.943  41.663   1.401  1.00 31.50          
ATOM    590  CB  LYS    75      -4.074  43.393   3.980  1.00 31.25          
ATOM    591  CG  LYS    75      -5.132  43.882   4.988  1.00 34.51          
ATOM    592  N   GLU    76      -2.157  41.022   2.619  1.00 28.86          
ATOM    593  CA  GLU    76      -1.419  40.645   1.401  1.00 29.71          
ATOM    594  C   GLU    76      -0.552  39.427   1.559  1.00 27.35          
ATOM    595  O   GLU    76      -0.067  39.104   2.648  1.00 26.63          
ATOM    596  CB  GLU    76      -0.538  41.808   0.926  1.00 31.94          
ATOM    597  CG  GLU    76       0.730  41.996   1.721  1.00 38.73          
ATOM    598  CD  GLU    76       1.394  43.359   1.463  1.00 52.34          
ATOM    599  OE1 GLU    76       0.670  44.271   0.991  1.00 58.89          
ATOM    600  OE2 GLU    76       2.617  43.518   1.735  1.00 50.80          
ATOM    601  N   ILE    77      -0.343  38.785   0.419  1.00 25.75          
ATOM    602  CA  ILE    77       0.494  37.608   0.325  1.00 24.37          
ATOM    603  C   ILE    77       1.897  38.113   0.221  1.00 24.01          
ATOM    604  O   ILE    77       2.179  39.002  -0.580  1.00 25.12          
ATOM    605  CB  ILE    77       0.071  36.718  -0.888  1.00 25.87          
ATOM    606  CG1 ILE    77      -1.336  36.167  -0.627  1.00 27.37          
ATOM    607  CG2 ILE    77       1.078  35.609  -1.136  1.00 22.46          
ATOM    608  CD  ILE    77      -1.906  35.322  -1.723  1.00 34.48          
ATOM    609  N   LEU    78       2.777  37.580   1.069  1.00 21.23          
ATOM    610  CA  LEU    78       4.163  37.978   1.067  1.00 19.73          
ATOM    611  C   LEU    78       4.977  37.104   0.166  1.00 20.29          
ATOM    612  O   LEU    78       5.886  37.557  -0.513  1.00 21.43          
ATOM    613  CB  LEU    78       4.763  37.932   2.459  1.00 19.49          
ATOM    614  CG  LEU    78       4.080  38.902   3.429  1.00 19.92          
ATOM    615  CD1 LEU    78       4.743  38.696   4.748  1.00 18.31          
ATOM    616  CD2 LEU    78       4.131  40.370   2.955  1.00 21.71          
ATOM    617  N   LYS    79       4.661  35.824   0.209  1.00 18.90          
ATOM    618  CA  LYS    79       5.420  34.817  -0.510  1.00 19.52          
ATOM    619  C   LYS    79       4.596  33.574  -0.747  1.00 19.01          
ATOM    620  O   LYS    79       3.940  33.087   0.170  1.00 19.06          
ATOM    621  CB  LYS    79       6.610  34.452   0.368  1.00 20.17          
ATOM    622  CG  LYS    79       7.475  33.294  -0.092  1.00 25.44          
ATOM    623  CD  LYS    79       8.378  33.680  -1.181  1.00 31.43          
ATOM    624  CE  LYS    79       9.436  32.626  -1.382  1.00 32.31          
ATOM    625  NZ  LYS    79      10.210  32.868  -2.615  1.00 33.22          
ATOM    626  N   THR    80       4.640  33.066  -1.970  1.00 19.78          
ATOM    627  CA  THR    80       4.027  31.767  -2.289  1.00 19.73          
ATOM    628  C   THR    80       5.103  30.851  -2.856  1.00 19.24          
ATOM    629  O   THR    80       6.127  31.303  -3.365  1.00 16.48          
ATOM    630  CB  THR    80       2.862  31.877  -3.259  1.00 22.68          
ATOM    631  OG1 THR    80       3.345  32.237  -4.547  1.00 27.76          
ATOM    632  CG2 THR    80       1.878  32.943  -2.826  1.00 21.50          
ATOM    633  N   TYR    81       4.897  29.561  -2.711  1.00 16.66          
ATOM    634  CA  TYR    81       5.829  28.572  -3.220  1.00 17.47          
ATOM    635  C   TYR    81       5.068  27.714  -4.233  1.00 19.04          
ATOM    636  O   TYR    81       4.672  26.593  -3.959  1.00 18.47          
ATOM    637  CB  TYR    81       6.398  27.720  -2.104  1.00 17.62          
ATOM    638  CG  TYR    81       7.193  28.482  -1.074  1.00 17.13          
ATOM    639  CD1 TYR    81       6.573  29.157  -0.023  1.00 19.82          
ATOM    640  CD2 TYR    81       8.569  28.528  -1.150  1.00 17.23          
ATOM    641  CE1 TYR    81       7.331  29.830   0.937  1.00 17.37          
ATOM    642  CE2 TYR    81       9.337  29.219  -0.207  1.00 21.12          
ATOM    643  CZ  TYR    81       8.709  29.868   0.826  1.00 20.65          
ATOM    644  OH  TYR    81       9.470  30.547   1.741  1.00 20.58          
ATOM   1570  N   VAL   191       9.538  22.838  -0.173  1.00 19.94          
ATOM   1571  CA  VAL   191       8.465  23.394   0.667  1.00 19.22          
ATOM   1572  C   VAL   191       8.452  22.738   2.035  1.00 18.39          
ATOM   1573  O   VAL   191       8.606  21.527   2.180  1.00 16.71          
ATOM   1574  CB  VAL   191       7.075  23.237   0.020  1.00 17.17          
ATOM   1575  CG1 VAL   191       5.925  23.341   1.084  1.00 18.72          
ATOM   1576  CG2 VAL   191       6.895  24.240  -1.082  1.00 16.77          
ATOM   1577  N   SER   192       8.285  23.581   3.049  1.00 19.02          
ATOM   1578  CA  SER   192       8.068  23.087   4.402  1.00 18.73          
ATOM   1579  C   SER   192       7.645  24.215   5.328  1.00 18.24          
ATOM   1580  O   SER   192       7.790  25.384   5.011  1.00 19.23          
ATOM   1581  CB  SER   192       9.329  22.474   4.984  1.00 18.55          
ATOM   1582  OG  SER   192      10.333  23.466   5.281  1.00 17.90          
ATOM   1583  N   LYS   193       7.193  23.826   6.506  1.00 18.23          
ATOM   1584  CA  LYS   193       6.856  24.823   7.528  1.00 16.91          
ATOM   1585  C   LYS   193       8.109  25.628   7.897  1.00 16.82          
ATOM   1586  O   LYS   193       8.074  26.862   8.015  1.00 18.89          
ATOM   1587  CB  LYS   193       6.258  24.160   8.784  1.00 16.99          
ATOM   1588  CG  LYS   193       4.834  23.715   8.652  1.00 16.12          
ATOM   1589  CD  LYS   193       4.411  22.995   9.951  1.00 18.94          
ATOM   1590  CE  LYS   193       2.932  22.776   9.996  1.00 24.30          
ATOM   1591  NZ  LYS   193       2.605  21.856  11.130  1.00 26.00          
ATOM   1592  N   TRP   194       9.252  24.962   8.000  1.00 16.34          
ATOM   1593  CA  TRP   194      10.490  25.677   8.395  1.00 17.10          
ATOM   1594  C   TRP   194      10.982  26.607   7.297  1.00 16.92          
ATOM   1595  O   TRP   194      11.448  27.707   7.556  1.00 21.28          
ATOM   1596  CB  TRP   194      11.620  24.737   8.829  1.00 17.43          
ATOM   1597  CG  TRP   194      12.806  25.532   9.250  1.00 18.11          
ATOM   1598  CD1 TRP   194      13.976  25.667   8.569  1.00 23.94          
ATOM   1599  CD2 TRP   194      12.895  26.419  10.376  1.00 18.62          
ATOM   1600  NE1 TRP   194      14.822  26.540   9.233  1.00 25.53          
ATOM   1601  CE2 TRP   194      14.185  27.002  10.353  1.00 23.72          
ATOM   1602  CE3 TRP   194      12.039  26.737  11.423  1.00 18.06          
ATOM   1603  CZ2 TRP   194      14.611  27.901  11.317  1.00 26.46          
ATOM   1604  CZ3 TRP   194      12.486  27.645  12.403  1.00 24.08          
ATOM   1605  CH2 TRP   194      13.740  28.203  12.336  1.00 25.07          
ATOM   1606  N   THR   195      10.847  26.190   6.055  1.00 16.60          
ATOM   1607  CA  THR   195      11.220  27.063   4.931  1.00 17.80          
ATOM   1608  C   THR   195      10.456  28.384   4.980  1.00 17.53          
ATOM   1609  O   THR   195      11.019  29.502   4.893  1.00 17.61          
ATOM   1610  CB  THR   195      10.988  26.376   3.556  1.00 18.17          
ATOM   1611  OG1 THR   195      11.842  25.230   3.471  1.00 18.78          
ATOM   1612  CG2 THR   195      11.339  27.325   2.386  1.00 19.55          
ATOM   1613  N   ALA   196       9.149  28.234   5.139  1.00 16.21          
ATOM   1614  CA  ALA   196       8.252  29.378   5.169  1.00 15.46          
ATOM   1615  C   ALA   196       8.524  30.224   6.411  1.00 16.27          
ATOM   1616  O   ALA   196       8.518  31.442   6.339  1.00 17.23          
ATOM   1617  CB  ALA   196       6.770  28.959   5.151  1.00 15.11          
ATOM   1618  N   LEU   197       8.732  29.564   7.536  1.00 14.58          
ATOM   1619  CA  LEU   197       8.989  30.299   8.779  1.00 16.60          
ATOM   1620  C   LEU   197      10.305  31.035   8.691  1.00 17.59          
ATOM   1621  O   LEU   197      10.436  32.164   9.136  1.00 18.81          
ATOM   1622  CB  LEU   197       8.902  29.389  10.005  1.00 16.73          
ATOM   1623  CG  LEU   197       8.897  30.065  11.363  1.00 23.06          
ATOM   1624  CD1 LEU   197       7.760  31.052  11.425  1.00 20.31          
ATOM   1625  CD2 LEU   197       8.823  29.031  12.511  1.00 19.45          
ATOM   1626  N   SER   198      11.288  30.403   8.064  1.00 19.84          
ATOM   1627  CA  SER   198      12.606  31.013   7.892  1.00 21.87          
ATOM   1628  C   SER   198      12.527  32.284   7.059  1.00 22.86          
ATOM   1629  O   SER   198      13.261  33.245   7.285  1.00 23.19          
ATOM   1630  CB  SER   198      13.571  30.028   7.232  1.00 22.97          
ATOM   1631  OG  SER   198      13.789  28.932   8.079  1.00 28.62          
ATOM   1632  N   TYR   199      11.610  32.270   6.102  1.00 22.89          
ATOM   1633  CA  TYR   199      11.350  33.417   5.251  1.00 22.38          
ATOM   1634  C   TYR   199      10.962  34.631   6.098  1.00 22.20          
ATOM   1635  O   TYR   199      11.484  35.764   5.905  1.00 20.88          
ATOM   1636  CB  TYR   199      10.279  33.113   4.190  1.00 22.78          
ATOM   1637  CG  TYR   199       9.761  34.346   3.547  1.00 21.06          
ATOM   1638  CD1 TYR   199      10.402  34.900   2.440  1.00 26.79          
ATOM   1639  CD2 TYR   199       8.676  35.032   4.083  1.00 23.34          
ATOM   1640  CE1 TYR   199       9.936  36.062   1.882  1.00 25.68          
ATOM   1641  CE2 TYR   199       8.218  36.184   3.537  1.00 25.78          
ATOM   1642  CZ  TYR   199       8.857  36.710   2.440  1.00 23.92          
ATOM   1643  OH  TYR   199       8.377  37.870   1.919  1.00 33.14          
ATOM   1644  N   LEU   200      10.066  34.378   7.057  1.00 20.79          
ATOM   1645  CA  LEU   200       9.608  35.418   7.970  1.00 20.67          
ATOM   1646  C   LEU   200      10.699  35.853   8.928  1.00 20.51          
ATOM   1647  O   LEU   200      10.863  37.054   9.176  1.00 21.86          
ATOM   1648  CB  LEU   200       8.372  35.010   8.770  1.00 20.17          
ATOM   1649  CG  LEU   200       7.037  35.062   8.044  1.00 20.67          
ATOM   1650  CD1 LEU   200       5.883  34.571   8.962  1.00 18.75          
ATOM   1651  CD2 LEU   200       6.773  36.486   7.456  1.00 19.29          
ATOM   1652  N   ILE   201      11.429  34.881   9.466  1.00 20.36          
ATOM   1653  CA  ILE   201      12.484  35.176  10.426  1.00 22.40          
ATOM   1654  C   ILE   201      13.479  36.131   9.786  1.00 24.95          
ATOM   1655  O   ILE   201      13.857  37.153  10.377  1.00 26.76          
ATOM   1656  CB  ILE   201      13.197  33.928  10.927  1.00 21.60          
ATOM   1657  CG1 ILE   201      12.266  33.143  11.863  1.00 19.66          
ATOM   1658  CG2 ILE   201      14.458  34.331  11.686  1.00 26.53          
ATOM   1659  CD  ILE   201      12.682  31.681  12.090  1.00 18.35          
ATOM   1660  N   ASP   202      13.831  35.822   8.544  1.00 25.88          
ATOM   1661  CA  ASP   202      14.776  36.635   7.789  1.00 27.49          
ATOM   1662  C   ASP   202      14.186  37.981   7.511  1.00 27.52          
ATOM   1663  O   ASP   202      14.867  38.979   7.605  1.00 27.98          
ATOM   1664  CB  ASP   202      15.130  36.021   6.451  1.00 27.58          
ATOM   1665  CG  ASP   202      15.929  36.979   5.574  1.00 37.41          
ATOM   1666  OD1 ASP   202      17.142  37.145   5.869  1.00 41.82          
ATOM   1667  OD2 ASP   202      15.348  37.562   4.609  1.00 34.11          
ATOM   1668  N   ARG   203      12.916  37.992   7.120  1.00 26.65          
ATOM   1669  CA  ARG   203      12.240  39.240   6.755  1.00 27.50          
ATOM   1670  C   ARG   203      12.260  40.247   7.874  1.00 27.30          
ATOM   1671  O   ARG   203      12.335  41.458   7.652  1.00 26.11          
ATOM   1672  CB  ARG   203      10.773  38.991   6.389  1.00 26.65          
ATOM   1673  CG  ARG   203      10.006  40.262   6.038  1.00 32.05          
ATOM   1674  CD  ARG   203       8.666  39.921   5.466  1.00 33.81          
ATOM   1675  NE  ARG   203       7.855  41.079   5.088  1.00 36.19          
ATOM   1676  CZ  ARG   203       7.833  41.611   3.868  1.00 36.25          
ATOM   1677  NH1 ARG   203       8.588  41.117   2.902  1.00 36.45          
ATOM   1678  NH2 ARG   203       7.051  42.647   3.614  1.00 39.53          
ATOM   1679  N   PHE   204      12.148  39.740   9.083  1.00 26.70          
ATOM   1680  CA  PHE   204      12.082  40.620  10.260  1.00 28.65          
ATOM   1681  C   PHE   204      13.411  40.789  10.946  1.00 28.46          
ATOM   1682  O   PHE   204      13.482  41.308  12.062  1.00 29.09          
ATOM   1683  CB  PHE   204      10.995  40.170  11.219  1.00 28.94          
ATOM   1684  CG  PHE   204       9.638  40.291  10.632  1.00 33.79          
ATOM   1685  CD1 PHE   204       9.138  41.533  10.316  1.00 37.87          
ATOM   1686  CD2 PHE   204       8.873  39.185  10.379  1.00 32.38          
ATOM   1687  CE1 PHE   204       7.896  41.668   9.757  1.00 41.66          
ATOM   1688  CE2 PHE   204       7.617  39.317   9.840  1.00 36.94          
ATOM   1689  CZ  PHE   204       7.133  40.554   9.515  1.00 37.62          
ATOM   1690  N   ASP   205      14.439  40.329  10.247  1.00 29.32          
ATOM   1691  CA  ASP   205      15.846  40.465  10.654  1.00 30.61          
ATOM   1692  C   ASP   205      16.085  39.857  12.014  1.00 31.28          
ATOM   1693  O   ASP   205      16.719  40.450  12.893  1.00 31.95          
ATOM   1694  CB  ASP   205      16.258  41.945  10.672  1.00 32.41          
ATOM   1695  CG  ASP   205      16.160  42.594   9.294  1.00 35.28          
ATOM   1696  OD1 ASP   205      16.618  41.963   8.317  1.00 37.65          
ATOM   1697  OD2 ASP   205      15.615  43.721   9.191  1.00 40.17          
ATOM   1698  N   LEU   206      15.511  38.681  12.189  1.00 28.65          
ATOM   1699  CA  LEU   206      15.652  37.936  13.412  1.00 27.58          
ATOM   1700  C   LEU   206      16.506  36.739  13.156  1.00 27.78          
ATOM   1701  O   LEU   206      16.884  36.435  12.020  1.00 28.67          
ATOM   1702  CB  LEU   206      14.295  37.428  13.924  1.00 27.03          
ATOM   1703  CG  LEU   206      13.205  38.439  14.239  1.00 29.15          
ATOM   1704  CD1 LEU   206      11.962  37.662  14.694  1.00 26.90          
ATOM   1705  CD2 LEU   206      13.667  39.440  15.309  1.00 24.49          
ATOM   1706  N   LEU   207      16.748  36.033  14.239  1.00 26.94          
ATOM   1707  CA  LEU   207      17.498  34.783  14.218  1.00 27.92          
ATOM   1708  C   LEU   207      16.640  33.677  14.800  1.00 26.76          
ATOM   1709  O   LEU   207      15.814  33.955  15.657  1.00 25.69          
ATOM   1710  CB  LEU   207      18.723  34.873  15.089  1.00 28.09          
ATOM   1711  CG  LEU   207      19.833  35.814  14.603  1.00 34.46          
ATOM   1712  CD1 LEU   207      20.883  35.854  15.670  1.00 29.61          
ATOM   1713  CD2 LEU   207      20.401  35.351  13.253  1.00 31.34          
ATOM   1714  N   PRO   208      16.876  32.418  14.383  1.00 27.45          
ATOM   1715  CA  PRO   208      16.094  31.305  14.912  1.00 27.16          
ATOM   1716  C   PRO   208      16.162  31.240  16.433  1.00 26.75          
ATOM   1717  O   PRO   208      15.239  30.735  17.084  1.00 25.82          
ATOM   1718  CB  PRO   208      16.762  30.076  14.271  1.00 28.01          
ATOM   1719  CG  PRO   208      17.243  30.592  12.958  1.00 28.08          
ATOM   1720  CD  PRO   208      17.732  31.994  13.257  1.00 29.62          
ATOM   1721  N   ASP   209      17.231  31.796  16.995  1.00 24.64          
ATOM   1722  CA  ASP   209      17.443  31.727  18.447  1.00 25.67          
ATOM   1723  C   ASP   209      16.437  32.583  19.197  1.00 25.35          
ATOM   1724  O   ASP   209      16.284  32.454  20.405  1.00 27.54          
ATOM   1725  CB  ASP   209      18.868  32.206  18.841  1.00 26.39          
ATOM   1726  N   GLU   210      15.776  33.447  18.447  1.00 22.82          
ATOM   1727  CA  GLU   210      14.833  34.439  18.979  1.00 22.84          
ATOM   1728  C   GLU   210      13.414  34.001  18.751  1.00 20.31          
ATOM   1729  O   GLU   210      12.465  34.773  18.906  1.00 21.65          
ATOM   1730  CB  GLU   210      15.048  35.794  18.307  1.00 23.00          
ATOM   1731  CG  GLU   210      16.400  36.407  18.635  1.00 26.07          
ATOM   1732  CD  GLU   210      16.689  37.675  17.866  1.00 29.19          
ATOM   1733  OE1 GLU   210      16.777  37.635  16.619  1.00 22.79          
ATOM   1734  OE2 GLU   210      16.841  38.722  18.520  1.00 29.71          
ATOM   1735  N   VAL   211      13.301  32.765  18.310  1.00 19.21          
ATOM   1736  CA  VAL   211      11.993  32.168  17.988  1.00 18.73          
ATOM   1737  C   VAL   211      11.550  31.093  18.977  1.00 19.21          
ATOM   1738  O   VAL   211      12.357  30.310  19.464  1.00 19.61          
ATOM   1739  CB  VAL   211      12.026  31.524  16.556  1.00 18.09          
ATOM   1740  CG1 VAL   211      10.755  30.784  16.235  1.00 23.08          
ATOM   1741  CG2 VAL   211      12.314  32.585  15.441  1.00 19.34          
ATOM   1742  N   CYS   212      10.250  31.082  19.256  1.00 18.41          
ATOM   1743  CA  CYS   212       9.609  30.016  20.027  1.00 18.73          
ATOM   1744  C   CYS   212       8.530  29.346  19.164  1.00 18.99          
ATOM   1745  O   CYS   212       7.643  30.020  18.681  1.00 17.85          
ATOM   1746  CB  CYS   212       8.989  30.546  21.322  1.00 18.56          
ATOM   1747  SG  CYS   212       8.043  29.352  22.268  1.00 22.64          
ATOM   1748  N   CYS   213       8.642  28.025  18.980  1.00 17.87          
ATOM   1749  CA  CYS   213       7.666  27.213  18.237  1.00 18.33          
ATOM   1750  C   CYS   213       6.950  26.197  19.123  1.00 18.35          
ATOM   1751  O   CYS   213       7.514  25.622  20.043  1.00 17.62          
ATOM   1752  CB  CYS   213       8.339  26.456  17.078  1.00 19.17          
ATOM   1753  SG  CYS   213       9.033  27.523  15.802  1.00 20.97          
ATOM   1754  N   PHE   214       5.689  25.993  18.796  1.00 18.04          
ATOM   1755  CA  PHE   214       4.836  25.006  19.424  1.00 17.54          
ATOM   1756  C   PHE   214       4.363  24.043  18.365  1.00 19.35          
ATOM   1757  O   PHE   214       3.952  24.441  17.277  1.00 17.87          
ATOM   1758  CB  PHE   214       3.582  25.625  20.047  1.00 17.80          
ATOM   1759  CG  PHE   214       3.873  26.529  21.193  1.00 20.75          
ATOM   1760  CD1 PHE   214       4.093  27.879  20.984  1.00 19.29          
ATOM   1761  CD2 PHE   214       3.931  26.028  22.499  1.00 20.28          
ATOM   1762  CE1 PHE   214       4.356  28.728  22.043  1.00 18.77          
ATOM   1763  CE2 PHE   214       4.203  26.886  23.560  1.00 20.43          
ATOM   1764  CZ  PHE   214       4.428  28.220  23.332  1.00 19.31          
ATOM   1765  N   GLY   215       4.412  22.765  18.689  1.00 19.48          
ATOM   1766  CA  GLY   215       3.967  21.741  17.749  1.00 18.67          
ATOM   1767  C   GLY   215       3.554  20.408  18.325  1.00 18.85          
ATOM   1768  O   GLY   215       3.629  20.168  19.527  1.00 17.48          
ATOM   1769  N   ASP   216       3.033  19.563  17.442  1.00 19.29          
ATOM   1770  CA  ASP   216       2.538  18.249  17.852  1.00 20.20          
ATOM   1771  C   ASP   216       2.714  17.123  16.838  1.00 22.24          
ATOM   1772  O   ASP   216       2.317  15.995  17.111  1.00 20.84          
ATOM   1773  CB  ASP   216       1.049  18.322  18.174  1.00 20.97          
ATOM   1774  CG  ASP   216       0.167  18.490  16.956  1.00 25.05          
ATOM   1775  OD1 ASP   216       0.658  18.880  15.884  1.00 22.80          
ATOM   1776  OD2 ASP   216      -1.055  18.221  17.069  1.00 31.81          
ATOM   1777  N   ASN   217       3.335  17.446  15.713  1.00 22.76          
ATOM   1778  CA  ASN   217       3.405  16.561  14.541  1.00 25.84          
ATOM   1779  C   ASN   217       4.825  16.287  14.112  1.00 24.78          
ATOM   1780  O   ASN   217       5.712  17.089  14.309  1.00 21.01          
ATOM   1781  CB  ASN   217       2.665  17.300  13.403  1.00 26.68          
ATOM   1782  CG  ASN   217       2.314  16.423  12.214  1.00 31.93          
ATOM   1783  OD1 ASN   217       3.177  15.876  11.505  1.00 34.91          
ATOM   1784  ND2 ASN   217       1.022  16.340  11.946  1.00 36.77          
ATOM   1785  N   LEU   218       5.033  15.126  13.500  1.00 25.32          
ATOM   1786  CA  LEU   218       6.369  14.812  12.988  1.00 25.19          
ATOM   1787  C   LEU   218       6.798  15.907  12.019  1.00 23.92          
ATOM   1788  O   LEU   218       7.972  16.225  11.954  1.00 25.03          
ATOM   1789  CB  LEU   218       6.409  13.457  12.276  1.00 25.67          
ATOM   1790  CG  LEU   218       6.256  12.206  13.148  1.00 26.22          
ATOM   1791  CD1 LEU   218       6.087  10.958  12.234  1.00 28.41          
ATOM   1792  CD2 LEU   218       7.429  12.039  14.099  1.00 26.27          
ATOM   1793  N   ASN   219       5.844  16.511  11.305  1.00 24.41          
ATOM   1794  CA  ASN   219       6.194  17.582  10.335  1.00 25.44          
ATOM   1795  C   ASN   219       6.605  18.911  11.027  1.00 25.35          
ATOM   1796  O   ASN   219       6.997  19.875  10.378  1.00 28.20          
ATOM   1797  CB  ASN   219       5.120  17.809   9.250  1.00 24.80          
ATOM   1798  CG  ASN   219       3.853  18.520   9.751  1.00 30.13          
ATOM   1799  OD1 ASN   219       3.858  19.230  10.749  1.00 29.30          
ATOM   1800  ND2 ASN   219       2.757  18.356   9.001  1.00 31.19          
ATOM   1801  N   ASP   220       6.549  18.921  12.353  1.00 23.79          
ATOM   1802  CA  ASP   220       6.936  20.109  13.144  1.00 21.60          
ATOM   1803  C   ASP   220       8.338  19.971  13.681  1.00 21.21          
ATOM   1804  O   ASP   220       8.888  20.882  14.287  1.00 19.66          
ATOM   1805  CB  ASP   220       6.009  20.268  14.364  1.00 21.06          
ATOM   1806  CG  ASP   220       4.620  20.717  13.989  1.00 21.63          
ATOM   1807  OD1 ASP   220       4.472  21.577  13.091  1.00 25.59          
ATOM   1808  OD2 ASP   220       3.666  20.209  14.597  1.00 19.78          
ATOM   1809  N   ILE   221       8.921  18.809  13.448  1.00 21.05          
ATOM   1810  CA  ILE   221      10.233  18.510  14.040  1.00 19.72          
ATOM   1811  C   ILE   221      11.339  19.512  13.676  1.00 19.77          
ATOM   1812  O   ILE   221      12.110  19.959  14.526  1.00 18.89          
ATOM   1813  CB  ILE   221      10.666  17.044  13.769  1.00 20.02          
ATOM   1814  CG1 ILE   221       9.891  16.127  14.717  1.00 18.96          
ATOM   1815  CG2 ILE   221      12.172  16.872  13.952  1.00 20.62          
ATOM   1816  CD  ILE   221      10.077  14.597  14.484  1.00 25.55          
ATOM   1817  N   GLU   222      11.415  19.862  12.410  1.00 20.96          
ATOM   1818  CA  GLU   222      12.472  20.778  11.964  1.00 20.40          
ATOM   1819  C   GLU   222      12.337  22.134  12.672  1.00 19.71          
ATOM   1820  O   GLU   222      13.324  22.680  13.175  1.00 20.28          
ATOM   1821  CB  GLU   222      12.446  20.928  10.432  1.00 20.99          
ATOM   1822  CG  GLU   222      13.557  21.804   9.913  1.00 24.17          
ATOM   1823  CD  GLU   222      13.625  21.878   8.394  1.00 25.93          
ATOM   1824  OE1 GLU   222      12.553  21.779   7.729  1.00 23.24          
ATOM   1825  OE2 GLU   222      14.772  22.047   7.894  1.00 28.82          
ATOM   1826  N   MET   223      11.115  22.653  12.774  1.00 20.66          
ATOM   1827  CA  MET   223      10.937  23.975  13.422  1.00 19.49          
ATOM   1828  C   MET   223      11.203  23.852  14.924  1.00 20.21          
ATOM   1829  O   MET   223      11.826  24.722  15.540  1.00 18.69          
ATOM   1830  CB  MET   223       9.590  24.671  13.077  1.00 19.43          
ATOM   1831  CG  MET   223       8.377  24.156  13.674  1.00 19.39          
ATOM   1832  SD  MET   223       6.938  25.373  13.130  1.00 23.53          
ATOM   1833  CE  MET   223       5.460  24.599  14.157  1.00 24.99          
ATOM   1834  N   LEU   224      10.778  22.738  15.504  1.00 19.82          
ATOM   1835  CA  LEU   224      10.998  22.531  16.960  1.00 19.83          
ATOM   1836  C   LEU   224      12.499  22.468  17.260  1.00 19.73          
ATOM   1837  O   LEU   224      12.986  22.944  18.271  1.00 19.14          
ATOM   1838  CB  LEU   224      10.279  21.274  17.456  1.00 19.42          
ATOM   1839  CG  LEU   224       8.746  21.255  17.379  1.00 22.17          
ATOM   1840  CD1 LEU   224       8.181  19.844  17.709  1.00 16.05          
ATOM   1841  CD2 LEU   224       8.106  22.320  18.273  1.00 20.47          
ATOM   1842  N   GLN   225      13.241  21.857  16.360  1.00 21.06          
ATOM   1843  CA  GLN   225      14.711  21.725  16.516  1.00 20.91          
ATOM   1844  C   GLN   225      15.475  22.989  16.286  1.00 22.65          
ATOM   1845  O   GLN   225      16.470  23.270  16.960  1.00 22.80          
ATOM   1846  CB  GLN   225      15.284  20.701  15.535  1.00 22.62          
ATOM   1847  CG  GLN   225      14.885  19.288  15.867  1.00 22.99          
ATOM   1848  CD  GLN   225      15.434  18.269  14.880  1.00 27.34          
ATOM   1849  OE1 GLN   225      15.764  18.585  13.735  1.00 31.65          
ATOM   1850  NE2 GLN   225      15.491  17.038  15.311  1.00 23.31          
ATOM   1851  N   ASN   226      15.008  23.773  15.332  1.00 21.32          
ATOM   1852  CA  ASN   226      15.741  24.977  14.918  1.00 21.35          
ATOM   1853  C   ASN   226      15.434  26.224  15.749  1.00 21.03          
ATOM   1854  O   ASN   226      16.254  27.152  15.816  1.00 22.07          
ATOM   1855  CB  ASN   226      15.495  25.268  13.436  1.00 18.86          
ATOM   1856  CG  ASN   226      16.139  24.240  12.526  1.00 27.79          
ATOM   1857  OD1 ASN   226      16.935  23.421  12.981  1.00 28.56          
ATOM   1858  ND2 ASN   226      15.805  24.283  11.244  1.00 24.78          
ATOM   1859  N   ALA   227      14.245  26.251  16.330  1.00 19.78          
ATOM   1860  CA  ALA   227      13.797  27.380  17.180  1.00 20.38          
ATOM   1861  C   ALA   227      14.608  27.391  18.485  1.00 21.37          
ATOM   1862  O   ALA   227      14.898  26.342  19.051  1.00 23.50          
ATOM   1863  CB  ALA   227      12.299  27.272  17.489  1.00 18.47          
ATOM   1864  N   GLY   228      14.961  28.581  18.949  1.00 22.05          
ATOM   1865  CA  GLY   228      15.744  28.739  20.187  1.00 21.64          
ATOM   1866  C   GLY   228      15.077  28.058  21.364  1.00 22.11          
ATOM   1867  O   GLY   228      15.741  27.491  22.250  1.00 22.48          
ATOM   1868  N   ILE   229      13.754  28.137  21.373  1.00 19.95          
ATOM   1869  CA  ILE   229      12.918  27.483  22.387  1.00 19.56          
ATOM   1870  C   ILE   229      11.726  26.909  21.656  1.00 20.28          
ATOM   1871  O   ILE   229      11.242  27.465  20.674  1.00 19.64          
ATOM   1872  CB  ILE   229      12.513  28.435  23.576  1.00 21.29          
ATOM   1873  CG1 ILE   229      12.047  27.623  24.777  1.00 26.34          
ATOM   1874  CG2 ILE   229      11.495  29.453  23.172  1.00 22.01          
ATOM   1875  CD  ILE   229      11.865  28.439  26.088  1.00 26.32          
ATOM   1876  N   SER   230      11.270  25.765  22.127  1.00 20.02          
ATOM   1877  CA  SER   230      10.155  25.089  21.522  1.00 19.23          
ATOM   1878  C   SER   230       9.477  24.153  22.487  1.00 18.86          
ATOM   1879  O   SER   230      10.088  23.685  23.465  1.00 20.05          
ATOM   1880  CB  SER   230      10.594  24.333  20.274  1.00 19.72          
ATOM   1881  OG  SER   230      11.500  23.281  20.596  1.00 18.58          
ATOM   1882  N   TYR   231       8.213  23.907  22.179  1.00 19.28          
ATOM   1883  CA  TYR   231       7.343  23.059  22.983  1.00 18.16          
ATOM   1884  C   TYR   231       6.555  22.097  22.148  1.00 19.08          
ATOM   1885  O   TYR   231       5.949  22.482  21.126  1.00 19.09          
ATOM   1886  CB  TYR   231       6.330  23.905  23.787  1.00 18.34          
ATOM   1887  CG  TYR   231       6.983  24.835  24.769  1.00 18.13          
ATOM   1888  CD1 TYR   231       7.554  26.030  24.330  1.00 20.04          
ATOM   1889  CD2 TYR   231       7.097  24.491  26.125  1.00 21.17          
ATOM   1890  CE1 TYR   231       8.193  26.882  25.228  1.00 22.77          
ATOM   1891  CE2 TYR   231       7.757  25.341  27.034  1.00 22.48          
ATOM   1892  CZ  TYR   231       8.296  26.537  26.556  1.00 23.15          
ATOM   1893  OH  TYR   231       8.953  27.417  27.383  1.00 30.34          
ATOM   1894  N   ALA   232       6.570  20.844  22.608  1.00 17.91          
ATOM   1895  CA  ALA   232       5.726  19.783  22.106  1.00 17.85          
ATOM   1896  C   ALA   232       4.620  19.463  23.061  1.00 18.55          
ATOM   1897  O   ALA   232       4.827  19.348  24.275  1.00 22.32          
ATOM   1898  CB  ALA   232       6.538  18.481  21.856  1.00 18.21          
ATOM   1899  N   VAL   233       3.420  19.331  22.522  1.00 18.10          
ATOM   1900  CA  VAL   233       2.291  18.868  23.351  1.00 18.19          
ATOM   1901  C   VAL   233       2.656  17.463  23.849  1.00 19.25          
ATOM   1902  O   VAL   233       3.258  16.676  23.122  1.00 18.13          
ATOM   1903  CB  VAL   233       0.943  18.932  22.646  1.00 20.28          
ATOM   1904  CG1 VAL   233       0.608  20.413  22.422  1.00 19.92          
ATOM   1905  CG2 VAL   233       0.937  18.136  21.326  1.00 20.56          
ATOM   1906  N   SER   234       2.297  17.166  25.095  1.00 19.86          
ATOM   1907  CA  SER   234       2.767  15.927  25.745  1.00 22.08          
ATOM   1908  C   SER   234       2.168  14.649  25.187  1.00 22.82          
ATOM   1909  O   SER   234       2.654  13.554  25.471  1.00 24.58          
ATOM   1910  CB  SER   234       2.605  16.017  27.295  1.00 21.88          
ATOM   1911  OG  SER   234       1.247  16.141  27.676  1.00 22.68          
ATOM   1912  N   ASN   235       1.128  14.777  24.382  1.00 22.27          
ATOM   1913  CA  ASN   235       0.483  13.613  23.805  1.00 22.11          
ATOM   1914  C   ASN   235       1.041  13.291  22.427  1.00 22.41          
ATOM   1915  O   ASN   235       0.582  12.367  21.760  1.00 22.07          
ATOM   1916  CB  ASN   235      -1.032  13.763  23.702  1.00 23.23          
ATOM   1917  CG  ASN   235      -1.455  14.926  22.815  1.00 24.84          
ATOM   1918  OD1 ASN   235      -1.094  16.073  23.083  1.00 22.19          
ATOM   1919  ND2 ASN   235      -2.272  14.641  21.790  1.00 21.15          
ATOM   1920  N   ALA   236       2.048  14.054  22.031  1.00 21.99          
ATOM   1921  CA  ALA   236       2.691  13.887  20.730  1.00 21.35          
ATOM   1922  C   ALA   236       3.602  12.668  20.755  1.00 22.07          
ATOM   1923  O   ALA   236       4.007  12.189  21.804  1.00 23.83          
ATOM   1924  CB  ALA   236       3.560  15.152  20.371  1.00 20.32          
ATOM   1925  N   ARG   237       3.995  12.226  19.581  1.00 22.82          
ATOM   1926  CA  ARG   237       4.977  11.143  19.492  1.00 23.74          
ATOM   1927  C   ARG   237       6.284  11.490  20.166  1.00 23.72          
ATOM   1928  O   ARG   237       6.700  12.655  20.241  1.00 23.17          
ATOM   1929  CB  ARG   237       5.261  10.751  18.041  1.00 24.49          
ATOM   1930  CG  ARG   237       4.186   9.872  17.444  1.00 26.36          
ATOM   1931  CD  ARG   237       4.712   9.100  16.253  1.00 26.48          
ATOM   1932  NE  ARG   237       5.954   8.380  16.527  1.00 24.76          
ATOM   1933  CZ  ARG   237       6.032   7.094  16.850  1.00 24.27          
ATOM   1934  NH1 ARG   237       4.944   6.373  16.954  1.00 20.26          
ATOM   1935  NH2 ARG   237       7.209   6.528  17.065  1.00 22.74          
ATOM   1936  N   GLN   238       6.962  10.435  20.596  1.00 22.13          
ATOM   1937  CA  GLN   238       8.263  10.512  21.253  1.00 23.52          
ATOM   1938  C   GLN   238       9.281  11.341  20.487  1.00 23.55          
ATOM   1939  O   GLN   238      10.119  12.066  21.072  1.00 22.62          
ATOM   1940  CB  GLN   238       8.826   9.059  21.476  1.00 26.78          
ATOM   1941  CG  GLN   238       8.075   8.280  22.557  1.00 37.89          
ATOM   1942  CD  GLN   238       8.004   6.743  22.374  1.00 47.79          
ATOM   1943  OE1 GLN   238       8.491   6.169  21.379  1.00 48.00          
ATOM   1944  NE2 GLN   238       7.364   6.079  23.349  1.00 42.37          
ATOM   1945  N   GLU   239       9.248  11.207  19.165  1.00 22.90          
ATOM   1946  CA  GLU   239      10.222  11.935  18.337  1.00 21.87          
ATOM   1947  C   GLU   239       9.966  13.434  18.347  1.00 21.99          
ATOM   1948  O   GLU   239      10.895  14.245  18.227  1.00 20.28          
ATOM   1949  CB  GLU   239      10.239  11.451  16.893  1.00 23.64          
ATOM   1950  CG  GLU   239      10.690  10.019  16.735  1.00 24.64          
ATOM   1951  CD  GLU   239       9.608   9.006  17.061  1.00 27.46          
ATOM   1952  OE1 GLU   239       8.463   9.422  17.306  1.00 22.86          
ATOM   1953  OE2 GLU   239       9.899   7.780  17.038  1.00 26.76          
ATOM   1954  N   VAL   240       8.687  13.790  18.462  1.00 20.01          
ATOM   1955  CA  VAL   240       8.309  15.227  18.469  1.00 21.08          
ATOM   1956  C   VAL   240       8.769  15.783  19.810  1.00 22.19          
ATOM   1957  O   VAL   240       9.423  16.832  19.893  1.00 22.66          
ATOM   1958  CB  VAL   240       6.821  15.422  18.246  1.00 22.09          
ATOM   1959  CG1 VAL   240       6.480  16.911  18.275  1.00 20.85          
ATOM   1960  CG2 VAL   240       6.383  14.763  16.918  1.00 21.10          
ATOM   1961  N   ILE   241       8.463  15.039  20.872  1.00 22.31          
ATOM   1962  CA  ILE   241       8.848  15.456  22.208  1.00 22.41          
ATOM   1963  C   ILE   241      10.352  15.663  22.262  1.00 22.27          
ATOM   1964  O   ILE   241      10.838  16.652  22.788  1.00 22.33          
ATOM   1965  CB  ILE   241       8.400  14.454  23.288  1.00 22.07          
ATOM   1966  CG1 ILE   241       6.871  14.521  23.407  1.00 24.68          
ATOM   1967  CG2 ILE   241       9.137  14.771  24.627  1.00 25.81          
ATOM   1968  CD  ILE   241       6.233  13.416  24.267  1.00 25.88          
ATOM   1969  N   ALA   242      11.088  14.769  21.613  1.00 23.23          
ATOM   1970  CA  ALA   242      12.556  14.806  21.688  1.00 21.73          
ATOM   1971  C   ALA   242      13.125  15.958  20.899  1.00 21.41          
ATOM   1972  O   ALA   242      14.207  16.480  21.213  1.00 21.68          
ATOM   1973  CB  ALA   242      13.178  13.483  21.184  1.00 22.83          
ATOM   1974  N   ALA   243      12.385  16.370  19.883  1.00 20.94          
ATOM   1975  CA  ALA   243      12.842  17.470  19.011  1.00 20.67          
ATOM   1976  C   ALA   243      12.711  18.796  19.730  1.00 20.90          
ATOM   1977  O   ALA   243      13.477  19.735  19.487  1.00 20.06          
ATOM   1978  CB  ALA   243      12.011  17.524  17.725  1.00 21.71          
ATOM   1979  N   ALA   244      11.689  18.869  20.572  1.00 20.97          
ATOM   1980  CA  ALA   244      11.333  20.137  21.277  1.00 21.49          
ATOM   1981  C   ALA   244      12.185  20.384  22.499  1.00 23.18          
ATOM   1982  O   ALA   244      12.622  19.441  23.156  1.00 21.72          
ATOM   1983  CB  ALA   244       9.877  20.090  21.692  1.00 20.36          
ATOM   1984  N   LYS   245      12.389  21.646  22.874  1.00 20.96          
ATOM   1985  CA  LYS   245      13.166  21.894  24.095  1.00 21.89          
ATOM   1986  C   LYS   245      12.386  21.491  25.347  1.00 22.77          
ATOM   1987  O   LYS   245      12.980  21.060  26.329  1.00 23.55          
ATOM   1988  CB  LYS   245      13.622  23.359  24.225  1.00 23.28          
ATOM   1989  CG  LYS   245      14.837  23.771  23.383  1.00 26.52          
ATOM   1990  CD  LYS   245      14.631  23.680  21.883  1.00 30.29          
ATOM   1991  CE  LYS   245      15.871  24.190  21.145  1.00 29.47          
ATOM   1992  NZ  LYS   245      15.854  23.890  19.677  1.00 27.72          
ATOM   1993  N   HSD   246      11.060  21.623  25.317  1.00 21.26          
ATOM   1994  CA  HSD   246      10.196  21.260  26.453  1.00 20.23          
ATOM   1995  C   HSD   246       8.883  20.712  25.993  1.00 20.55          
ATOM   1996  O   HSD   246       8.549  20.723  24.796  1.00 20.77          
ATOM   1997  CB  HSD   246       9.868  22.511  27.302  1.00 20.86          
ATOM   1998  CG  HSD   246      11.066  23.305  27.689  1.00 21.63          
ATOM   1999  ND1 HSD   246      11.913  22.920  28.709  1.00 21.95          
ATOM   2000  CD2 HSD   246      11.570  24.462  27.189  1.00 24.06          
ATOM   2001  CE1 HSD   246      12.887  23.810  28.812  1.00 26.39          
ATOM   2002  NE2 HSD   246      12.707  24.749  27.899  1.00 24.47          
ATOM   2003  N   THR   247       8.098  20.273  26.952  1.00 21.46          
ATOM   2004  CA  THR   247       6.762  19.808  26.647  1.00 21.70          
ATOM   2005  C   THR   247       5.746  20.707  27.336  1.00 22.21          
ATOM   2006  O   THR   247       6.048  21.385  28.325  1.00 26.12          
ATOM   2007  CB  THR   247       6.514  18.357  27.088  1.00 22.94          
ATOM   2008  OG1 THR   247       6.577  18.298  28.506  1.00 26.90          
ATOM   2009  CG2 THR   247       7.584  17.417  26.510  1.00 20.20          
ATOM   2010  N   CYS   248       4.546  20.705  26.807  1.00 21.27          
ATOM   2011  CA  CYS   248       3.433  21.379  27.450  1.00 20.83          
ATOM   2012  C   CYS   248       2.273  20.410  27.431  1.00 21.61          
ATOM   2013  O   CYS   248       2.328  19.372  26.761  1.00 23.56          
ATOM   2014  CB  CYS   248       3.063  22.735  26.781  1.00 22.15          
ATOM   2015  SG  CYS   248       2.515  22.646  25.098  1.00 23.74          
ATOM   2016  N   ALA   249       1.214  20.771  28.141  1.00 20.40          
ATOM   2017  CA  ALA   249       0.029  19.918  28.245  1.00 20.84          
ATOM   2018  C   ALA   249      -0.734  19.829  26.937  1.00 21.00          
ATOM   2019  O   ALA   249      -0.580  20.686  26.059  1.00 21.18          
ATOM   2020  CB  ALA   249      -0.913  20.442  29.377  1.00 21.44          
ATOM   2021  N   PRO   250      -1.595  18.818  26.814  1.00 20.28          
ATOM   2022  CA  PRO   250      -2.378  18.653  25.605  1.00 21.93          
ATOM   2023  C   PRO   250      -3.382  19.794  25.400  1.00 21.01          
ATOM   2024  O   PRO   250      -3.628  20.607  26.304  1.00 22.03          
ATOM   2025  CB  PRO   250      -3.098  17.329  25.812  1.00 22.02          
ATOM   2026  CG  PRO   250      -2.272  16.596  26.816  1.00 24.67          
ATOM   2027  CD  PRO   250      -1.647  17.627  27.687  1.00 22.31          
ATOM   2028  N   TYR   251      -3.947  19.857  24.212  1.00 21.06          
ATOM   2029  CA  TYR   251      -4.839  20.953  23.913  1.00 23.11          
ATOM   2030  C   TYR   251      -6.074  20.927  24.815  1.00 24.89          
ATOM   2031  O   TYR   251      -6.684  21.958  25.069  1.00 23.88          
ATOM   2032  CB  TYR   251      -5.243  20.959  22.453  1.00 23.61          
ATOM   2033  CG  TYR   251      -6.175  19.854  22.072  1.00 21.68          
ATOM   2034  CD1 TYR   251      -7.510  19.920  22.399  1.00 22.23          
ATOM   2035  CD2 TYR   251      -5.703  18.728  21.403  1.00 21.18          
ATOM   2036  CE1 TYR   251      -8.373  18.913  22.034  1.00 24.92          
ATOM   2037  CE2 TYR   251      -6.553  17.706  21.035  1.00 25.83          
ATOM   2038  CZ  TYR   251      -7.882  17.802  21.358  1.00 24.68          
ATOM   2039  OH  TYR   251      -8.725  16.780  20.991  1.00 30.55          
ATOM   2040  N   TRP   252      -6.401  19.754  25.327  1.00 25.01          
ATOM   2041  CA  TRP   252      -7.623  19.587  26.140  1.00 26.02          
ATOM   2042  C   TRP   252      -7.377  20.054  27.546  1.00 26.69          
ATOM   2043  O   TRP   252      -8.286  20.056  28.371  1.00 26.85          
ATOM   2044  CB  TRP   252      -8.202  18.157  26.119  1.00 28.34          
ATOM   2045  CG  TRP   252      -7.265  17.088  26.482  1.00 28.15          
ATOM   2046  CD1 TRP   252      -6.972  16.647  27.728  1.00 29.98          
ATOM   2047  CD2 TRP   252      -6.511  16.282  25.578  1.00 27.19          
ATOM   2048  NE1 TRP   252      -6.051  15.638  27.663  1.00 31.80          
ATOM   2049  CE2 TRP   252      -5.754  15.391  26.352  1.00 29.38          
ATOM   2050  CE3 TRP   252      -6.387  16.241  24.182  1.00 26.51          
ATOM   2051  CZ2 TRP   252      -4.895  14.456  25.784  1.00 28.21          
ATOM   2052  CZ3 TRP   252      -5.531  15.323  23.624  1.00 22.06          
ATOM   2053  CH2 TRP   252      -4.797  14.439  24.423  1.00 24.70          
ATOM   2054  N   GLU   253      -6.141  20.466  27.779  1.00 25.39          
ATOM   2055  CA  GLU   253      -5.718  21.041  29.054  1.00 26.04          
ATOM   2056  C   GLU   253      -5.186  22.446  28.827  1.00 26.21          
ATOM   2057  O   GLU   253      -4.611  23.087  29.720  1.00 26.08          
ATOM   2058  CB  GLU   253      -4.667  20.181  29.740  1.00 26.99          
ATOM   2059  CG  GLU   253      -5.270  18.910  30.274  1.00 28.04          
ATOM   2060  CD  GLU   253      -4.277  17.994  30.942  1.00 31.06          
ATOM   2061  OE1 GLU   253      -3.098  18.368  31.081  1.00 32.83          
ATOM   2062  OE2 GLU   253      -4.705  16.872  31.319  1.00 37.43          
ATOM   2063  N   ASN   254      -5.389  22.927  27.614  1.00 23.87          
ATOM   2064  CA  ASN   254      -4.937  24.283  27.277  1.00 24.04          
ATOM   2065  C   ASN   254      -3.460  24.491  27.649  1.00 21.85          
ATOM   2066  O   ASN   254      -3.056  25.497  28.210  1.00 21.02          
ATOM   2067  CB  ASN   254      -5.845  25.336  27.940  1.00 23.70          
ATOM   2068  CG  ASN   254      -7.145  25.540  27.182  1.00 26.26          
ATOM   2069  OD1 ASN   254      -7.307  25.063  26.063  1.00 27.29          
ATOM   2070  ND2 ASN   254      -8.067  26.288  27.776  1.00 32.52          
ATOM   2071  N   GLY   255      -2.627  23.521  27.281  1.00 22.16          
ATOM   2072  CA  GLY   255      -1.201  23.587  27.590  1.00 19.33          
ATOM   2073  C   GLY   255      -0.429  24.721  26.942  1.00 19.38          
ATOM   2074  O   GLY   255       0.444  25.347  27.544  1.00 18.61          
ATOM   2075  N   VAL   256      -0.708  24.985  25.678  1.00 18.22          
ATOM   2076  CA  VAL   256       0.008  26.080  25.009  1.00 16.46          
ATOM   2077  C   VAL   256      -0.374  27.410  25.699  1.00 16.22          
ATOM   2078  O   VAL   256       0.471  28.263  25.929  1.00 17.86          
ATOM   2079  CB  VAL   256      -0.274  26.140  23.496  1.00 17.76          
ATOM   2080  CG1 VAL   256       0.321  27.409  22.923  1.00 17.61          
ATOM   2081  CG2 VAL   256       0.331  24.898  22.795  1.00 14.98          
ATOM   2082  N   LEU   257      -1.623  27.512  26.110  1.00 17.62          
ATOM   2083  CA  LEU   257      -2.102  28.740  26.773  1.00 19.18          
ATOM   2084  C   LEU   257      -1.260  29.003  28.003  1.00 21.38          
ATOM   2085  O   LEU   257      -0.819  30.135  28.265  1.00 21.08          
ATOM   2086  CB  LEU   257      -3.570  28.658  27.123  1.00 21.52          
ATOM   2087  CG  LEU   257      -4.135  29.926  27.802  1.00 20.69          
ATOM   2088  CD1 LEU   257      -4.011  31.150  26.905  1.00 19.35          
ATOM   2089  CD2 LEU   257      -5.560  29.685  28.150  1.00 20.93          
ATOM   2090  N   SER   258      -0.995  27.948  28.760  1.00 21.20          
ATOM   2091  CA  SER   258      -0.205  28.115  29.991  0.50 21.01          
ATOM   2093  C   SER   258       1.188  28.606  29.724  1.00 20.86          
ATOM   2094  O   SER   258       1.700  29.449  30.443  1.00 21.32          
ATOM   2095  CB  SER   258      -0.149  26.833  30.821  0.50 20.93          
ATOM   2097  OG  SER   258      -1.446  26.495  31.230  0.50 21.54          
ATOM   2099  N   VAL   259       1.798  28.142  28.653  1.00 20.33          
ATOM   2100  CA  VAL   259       3.147  28.596  28.338  1.00 19.50          
ATOM   2101  C   VAL   259       3.121  30.042  27.871  1.00 19.40          
ATOM   2102  O   VAL   259       3.914  30.874  28.275  1.00 21.55          
ATOM   2103  CB  VAL   259       3.794  27.692  27.255  1.00 20.76          
ATOM   2104  CG1 VAL   259       5.137  28.166  26.926  1.00 18.71          
ATOM   2105  CG2 VAL   259       3.822  26.223  27.746  1.00 18.79          
ATOM   2106  N   LEU   260       2.168  30.342  27.009  1.00 18.74          
ATOM   2107  CA  LEU   260       2.057  31.700  26.510  1.00 18.06          
ATOM   2108  C   LEU   260       1.886  32.660  27.696  1.00 18.62          
ATOM   2109  O   LEU   260       2.460  33.745  27.697  1.00 19.80          
ATOM   2110  CB  LEU   260       0.881  31.850  25.560  1.00 17.88          
ATOM   2111  CG  LEU   260       0.980  31.107  24.232  1.00 17.67          
ATOM   2112  CD1 LEU   260      -0.291  31.303  23.423  1.00 16.65          
ATOM   2113  CD2 LEU   260       2.170  31.625  23.475  1.00 14.84          
ATOM   2114  N   LYS   261       1.096  32.255  28.678  1.00 19.24          
ATOM   2115  CA  LYS   261       0.871  33.139  29.875  1.00 21.79          
ATOM   2116  C   LYS   261       2.164  33.338  30.612  1.00 24.33          
ATOM   2117  O   LYS   261       2.445  34.425  31.136  1.00 26.98          
ATOM   2118  CB  LYS   261      -0.149  32.575  30.848  1.00 21.48          
ATOM   2119  CG  LYS   261      -1.578  32.675  30.379  1.00 24.78          
ATOM   2120  CD  LYS   261      -2.450  31.879  31.295  1.00 30.76          
ATOM   2121  CE  LYS   261      -3.879  32.110  31.036  1.00 35.14          
ATOM   2122  NZ  LYS   261      -4.650  31.492  32.141  1.00 35.10          
ATOM   2123  N   SER   262       3.001  32.314  30.595  1.00 25.90          
ATOM   2124  CA  SER   262       4.287  32.388  31.323  1.00 25.66          
ATOM   2125  C   SER   262       5.236  33.387  30.672  1.00 26.49          
ATOM   2126  O   SER   262       6.274  33.724  31.221  1.00 27.02          
ATOM   2127  CB  SER   262       4.978  31.015  31.429  1.00 26.62          
ATOM   2128  OG  SER   262       5.593  30.639  30.202  1.00 25.00          
ATOM   2129  N   PHE   263       4.916  33.828  29.470  1.00 25.93          
ATOM   2130  CA  PHE   263       5.762  34.795  28.763  1.00 25.21          
ATOM   2131  C   PHE   263       5.291  36.221  28.987  1.00 27.84          
ATOM   2132  O   PHE   263       5.882  37.172  28.455  1.00 27.74          
ATOM   2133  CB  PHE   263       5.696  34.635  27.247  1.00 26.33          
ATOM   2134  CG  PHE   263       6.176  33.306  26.738  1.00 21.52          
ATOM   2135  CD1 PHE   263       7.122  32.581  27.436  1.00 26.24          
ATOM   2136  CD2 PHE   263       5.756  32.836  25.528  1.00 21.16          
ATOM   2137  CE1 PHE   263       7.580  31.356  26.948  1.00 27.43          
ATOM   2138  CE2 PHE   263       6.220  31.630  25.039  1.00 24.32          
ATOM   2139  CZ  PHE   263       7.130  30.896  25.751  1.00 24.61          
ATOM   2140  N   LEU   264       4.182  36.353  29.697  1.00 27.81          
ATOM   2141  CA  LEU   264       3.574  37.694  29.902  1.00 29.44          
ATOM   2142  C   LEU   264       4.361  38.511  30.910  1.00 34.97          
ATOM   2143  OT1 LEU   264       4.810  37.964  31.933  1.00 36.15          
ATOM   2144  CB  LEU   264       2.128  37.606  30.363  1.00 26.47          
ATOM   2145  CG  LEU   264       1.058  37.194  29.348  1.00 25.94          
ATOM   2146  CD1 LEU   264      -0.250  36.905  30.048  1.00 23.39          
ATOM   2147  CD2 LEU   264       0.889  38.301  28.323  1.00 27.89          
ATOM   2148  OT2 LEU   264       4.537  39.728  30.700  1.00 37.22          
END
