
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 (  799),  selected   99 , name 2dcl_A
# Molecule2: number of CA atoms  107 (  862),  selected  107 , name T0445_83_189.pdb
# PARAMETERS: 2dcl_A.T0445_83_189.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     2_A      -       -           -
LGA    E     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    H     6_A      -       -           -
LGA    W     7_A      -       -           -
LGA    N     8_A      -       -           -
LGA    T     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    R    11_A      -       -           -
LGA    L    12_A      -       -           -
LGA    R    13_A      -       -           -
LGA    I    14_A      -       -           -
LGA    Y    15_A      -       -           -
LGA    I    16_A      -       -           -
LGA    G    17_A      M      83          2.000
LGA    E    18_A      -       -           -
LGA    N    19_A      -       -           -
LGA    D    20_A      D      84          1.367
LGA    K    21_A      -       -           -
LGA    W    22_A      -       -           -
LGA    E    23_A      -       -           -
LGA    G    24_A      -       -           -
LGA    R    25_A      E      85          4.997
LGA    P    26_A      D      86          3.119
LGA    L    27_A      I      87          1.728
LGA    Y    28_A      W      88          0.784
LGA    K    29_A      K      89          0.825
LGA    V    30_A      G      90          1.139
LGA    I    31_A      M      91          1.081
LGA    V    32_A      C      92          0.595
LGA    E    33_A      R      93          0.520
LGA    K    34_A      M      94          1.198
LGA    L    35_A      V      95          1.314
LGA    R    36_A      R      96          1.341
LGA    E    37_A      D      97          1.652
LGA    M    38_A      E      98          1.027
LGA    G    39_A      L      99          2.644
LGA    I    40_A      P     100          3.597
LGA    A    41_A      A     101          2.326
LGA    G    42_A      C     102          2.871
LGA    -       -      D     103           -
LGA    A    43_A      Y     104          0.965
LGA    T    44_A      F     105          1.424
LGA    V    45_A      A     106          1.349
LGA    Y    46_A      A     107          1.290
LGA    R    47_A      T     108          1.249
LGA    G    48_A      P     109          1.497
LGA    I    49_A      D     110          4.202
LGA    Y    50_A      F     111           -
LGA    G    51_A      C     112           -
LGA    F    52_A      F     113           -
LGA    G    53_A      A     114           -
LGA    T    68_A      E     115           -
LGA    -       -      D     116           -
LGA    -       -      G     117           -
LGA    -       -      G     118           -
LGA    -       -      S     119           -
LGA    -       -      P     120           -
LGA    -       -      I     121           -
LGA    -       -      F     122           -
LGA    -       -      X     123           -
LGA    -       -      L     124           -
LGA    -       -      L     125           -
LGA    -       -      R     126           -
LGA    -       -      D     127           -
LGA    -       -      S     128           -
LGA    -       -      Y     129           -
LGA    -       -      G     130           -
LGA    -       -      F     131           -
LGA    -       -      E     132           -
LGA    -       -      M     133           -
LGA    -       -      R     134           -
LGA    -       -      E     135           -
LGA    -       -      V     136           -
LGA    -       -      D     137           -
LGA    -       -      D     138           -
LGA    -       -      I     139           -
LGA    -       -      T     140           -
LGA    -       -      R     141           -
LGA    -       -      L     142           -
LGA    -       -      D     143           -
LGA    -       -      R     144           -
LGA    D    69_A      N     145           #
LGA    L    70_A      D     146          2.496
LGA    P    71_A      I     147          4.221
LGA    I    72_A      I     148          2.284
LGA    I    73_A      K     149          1.205
LGA    V    74_A      F     150          1.266
LGA    E    75_A      T     151          1.138
LGA    V    76_A      V     152          0.855
LGA    V    77_A      F     153          1.691
LGA    D    78_A      X     154          2.752
LGA    -       -      P     155           -
LGA    -       -      D     156           -
LGA    R    79_A      K     157          1.607
LGA    -       -      C     158           -
LGA    G    80_A      E     159          2.867
LGA    H    81_A      E     160          1.624
LGA    N    82_A      L     161          0.847
LGA    I    83_A      C     162          2.049
LGA    E    84_A      T     163          1.569
LGA    K    85_A      P     164          2.514
LGA    -       -      V     165           -
LGA    V    86_A      F     166          1.587
LGA    V    87_A      I     167          0.807
LGA    N    88_A      P     168          1.048
LGA    V    89_A      A     169          1.299
LGA    I    90_A      W     170          1.036
LGA    K    91_A      N     171          1.152
LGA    P    92_A      K     172          2.684
LGA    M    93_A      K     173          2.865
LGA    I    94_A      A     174          2.281
LGA    K    95_A      -       -           -
LGA    D    96_A      -       -           -
LGA    G    97_A      -       -           -
LGA    M    98_A      X     175          2.415
LGA    I    99_A      L     176          1.732
LGA    T   100_A      A     177          1.739
LGA    V   101_A      A     178          1.142
LGA    E   102_A      A     179          1.775
LGA    P   103_A      G     180          1.374
LGA    -       -      K     181           -
LGA    T   104_A      E     182          4.212
LGA    I   105_A      W     183           -
LGA    V   106_A      V     184           -
LGA    L   107_A      D     185           -
LGA    W   108_A      C     186           -
LGA    V   109_A      N     187           -
LGA    G   110_A      A     188           -
LGA    T   111_A      K     189           -
LGA    Q   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    E   114_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99  107    5.0     59    2.08    10.17     44.815     2.708

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.520126 * X  +   0.717236 * Y  +  -0.463726 * Z  +  14.672888
  Y_new =  -0.024798 * X  +   0.530037 * Y  +   0.847612 * Z  +  47.873611
  Z_new =   0.853729 * X  +   0.452365 * Y  +  -0.257900 * Z  +   3.197831 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.088952   -1.052641  [ DEG:   119.6881    -60.3119 ]
  Theta =  -1.023106   -2.118487  [ DEG:   -58.6196   -121.3804 ]
  Phi   =  -3.093952    0.047641  [ DEG:  -177.2704      2.7296 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dcl_A                                        
REMARK     2: T0445_83_189.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dcl_A.T0445_83_189.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99  107   5.0   59   2.08   10.17  44.815
REMARK  ---------------------------------------------------------- 
MOLECULE 2dcl_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   08-JAN-06   2DCL              
TITLE     STRUCTURE OF PH1503 PROTEIN FROM PYROCOCCUS HORIKOSHII OT3            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL UPF0166 PROTEIN PH1503;                       
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: PH1503;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    HEXAMER, X-RAY DIFFRACTION, STRUCTURAL GENOMICS, NPPSFA,              
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI                                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.BAGAUTDINOV,N.KUNISHIMA,RIKEN STRUCTURAL                            
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   08-JUL-06 2DCL    0                                                
JRNL        AUTH   B.BAGAUTDINOV,N.KUNISHIMA                                    
JRNL        TITL   CRYSTAL STRUCTURE OF PH1503 PROTEIN FROM                     
JRNL        TITL 2 PYROCOCCUS HORIKOSHII OT3                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.28 ANGSTROMS.                                          
DBREF  2DCL A    1   127  UNP    O59172   Y1503_PYRHO      1    127             
DBREF  2DCL B    1   127  UNP    O59172   Y1503_PYRHO      1    127             
DBREF  2DCL C    1   127  UNP    O59172   Y1503_PYRHO      1    127             
SEQRES   1 A  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 A  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 A  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 A  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 A  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 A  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 A  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 A  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 A  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 A  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
SEQRES   1 B  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 B  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 B  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 B  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 B  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 B  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 B  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 B  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 B  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 B  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
SEQRES   1 C  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 C  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 C  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 C  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 C  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 C  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 C  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 C  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 C  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 C  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
HET    AMP    901      23                                                       
HET    AMP    902      23                                                       
HET    AMP    903      23                                                       
HETNAM     AMP ADENOSINE MONOPHOSPHATE                                          
FORMUL   4  AMP    3(C10 H14 N5 O7 P)                                           
FORMUL   7  HOH   *123(H2 O)                                                    
CRYST1  107.562   59.647   66.738  90.00 122.47  90.00 C 1 2 1      12          
ATOM      1  N   VAL A   2     -21.200  -3.485   6.513  1.00 51.82           N  
ATOM      2  CA  VAL A   2     -21.356  -2.357   5.555  1.00 53.21           C  
ATOM      3  C   VAL A   2     -20.378  -2.524   4.390  1.00 53.41           C  
ATOM      4  O   VAL A   2     -19.549  -3.429   4.402  1.00 55.12           O  
ATOM      5  CB  VAL A   2     -21.135  -0.989   6.270  1.00 51.31           C  
ATOM      6  CG1 VAL A   2     -21.903  -0.982   7.577  1.00 51.24           C  
ATOM      7  CG2 VAL A   2     -19.657  -0.742   6.535  1.00 51.09           C  
ATOM      8  N   GLU A   3     -20.478  -1.652   3.391  1.00 54.04           N  
ATOM      9  CA  GLU A   3     -19.631  -1.729   2.206  1.00 56.55           C  
ATOM     10  C   GLU A   3     -18.756  -0.510   1.971  1.00 55.68           C  
ATOM     11  O   GLU A   3     -19.171   0.628   2.199  1.00 57.29           O  
ATOM     12  CB  GLU A   3     -20.496  -1.942   0.958  1.00 59.36           C  
ATOM     13  CG  GLU A   3     -21.207  -3.293   0.886  1.00 63.89           C  
ATOM     14  CD  GLU A   3     -22.404  -3.266  -0.057  1.00 66.90           C  
ATOM     15  OE1 GLU A   3     -22.244  -2.795  -1.205  1.00 68.18           O  
ATOM     16  OE2 GLU A   3     -23.501  -3.712   0.346  1.00 68.12           O  
ATOM     17  N   VAL A   4     -17.541  -0.760   1.495  1.00 53.49           N  
ATOM     18  CA  VAL A   4     -16.593   0.301   1.187  1.00 51.32           C  
ATOM     19  C   VAL A   4     -15.925  -0.095  -0.122  1.00 51.54           C  
ATOM     20  O   VAL A   4     -16.129  -1.206  -0.601  1.00 50.91           O  
ATOM     21  CB  VAL A   4     -15.528   0.445   2.293  1.00 50.15           C  
ATOM     22  CG1 VAL A   4     -16.207   0.572   3.635  1.00 47.04           C  
ATOM     23  CG2 VAL A   4     -14.572  -0.745   2.285  1.00 49.07           C  
ATOM     24  N   GLU A   5     -15.156   0.809  -0.718  1.00 52.64           N  
ATOM     25  CA  GLU A   5     -14.470   0.494  -1.966  1.00 54.72           C  
ATOM     26  C   GLU A   5     -13.101  -0.095  -1.676  1.00 54.45           C  
ATOM     27  O   GLU A   5     -12.718  -1.098  -2.279  1.00 54.83           O  
ATOM     28  CB  GLU A   5     -14.319   1.739  -2.836  1.00 56.24           C  
ATOM     29  CG  GLU A   5     -15.587   2.139  -3.575  1.00 63.25           C  
ATOM     30  CD  GLU A   5     -16.054   1.077  -4.558  1.00 66.95           C  
ATOM     31  OE1 GLU A   5     -15.196   0.515  -5.282  1.00 69.14           O  
ATOM     32  OE2 GLU A   5     -17.274   0.815  -4.619  1.00 67.13           O  
ATOM     33  N   HIS A   6     -12.377   0.534  -0.746  1.00 52.34           N  
ATOM     34  CA  HIS A   6     -11.046   0.090  -0.345  1.00 50.32           C  
ATOM     35  C   HIS A   6     -10.656   0.603   1.037  1.00 49.61           C  
ATOM     36  O   HIS A   6     -10.932   1.751   1.384  1.00 47.93           O  
ATOM     37  CB  HIS A   6      -9.973   0.592  -1.318  1.00 51.81           C  
ATOM     38  CG  HIS A   6     -10.175   0.166  -2.737  1.00 53.69           C  
ATOM     39  ND1 HIS A   6     -10.476   1.058  -3.743  1.00 54.07           N  
ATOM     40  CD2 HIS A   6     -10.073  -1.048  -3.328  1.00 54.72           C  
ATOM     41  CE1 HIS A   6     -10.550   0.413  -4.892  1.00 55.03           C  
ATOM     42  NE2 HIS A   6     -10.309  -0.867  -4.668  1.00 55.52           N  
ATOM     43  N   TRP A   7      -9.995  -0.244   1.817  1.00 48.97           N  
ATOM     44  CA  TRP A   7      -9.511   0.150   3.133  1.00 48.18           C  
ATOM     45  C   TRP A   7      -7.985   0.117   3.113  1.00 48.80           C  
ATOM     46  O   TRP A   7      -7.341   0.185   4.151  1.00 48.88           O  
ATOM     47  CB  TRP A   7     -10.019  -0.801   4.217  1.00 46.64           C  
ATOM     48  CG  TRP A   7     -10.037  -2.274   3.846  1.00 50.15           C  
ATOM     49  CD1 TRP A   7     -11.091  -2.975   3.318  1.00 49.37           C  
ATOM     50  CD2 TRP A   7      -8.983  -3.229   4.038  1.00 48.09           C  
ATOM     51  NE1 TRP A   7     -10.763  -4.299   3.183  1.00 48.95           N  
ATOM     52  CE2 TRP A   7      -9.478  -4.487   3.616  1.00 49.91           C  
ATOM     53  CE3 TRP A   7      -7.674  -3.148   4.527  1.00 45.96           C  
ATOM     54  CZ2 TRP A   7      -8.704  -5.660   3.672  1.00 50.50           C  
ATOM     55  CZ3 TRP A   7      -6.902  -4.317   4.582  1.00 47.66           C  
ATOM     56  CH2 TRP A   7      -7.421  -5.554   4.159  1.00 47.99           C  
ATOM     57  N   ASN A   8      -7.421   0.028   1.912  1.00 50.09           N  
ATOM     58  CA  ASN A   8      -5.977  -0.080   1.719  1.00 51.75           C  
ATOM     59  C   ASN A   8      -5.407   1.096   0.920  1.00 50.70           C  
ATOM     60  O   ASN A   8      -4.256   1.077   0.485  1.00 52.16           O  
ATOM     61  CB  ASN A   8      -5.701  -1.361   0.949  1.00 55.94           C  
ATOM     62  CG  ASN A   8      -6.225  -1.288  -0.471  1.00 59.17           C  
ATOM     63  OD1 ASN A   8      -7.394  -1.579  -0.735  1.00 63.39           O  
ATOM     64  ND2 ASN A   8      -5.349  -0.939  -1.402  1.00 62.06           N  
ATOM     65  N   THR A   9      -6.224   2.112   0.717  1.00 47.33           N  
ATOM     66  CA  THR A   9      -5.826   3.270  -0.051  1.00 44.64           C  
ATOM     67  C   THR A   9      -5.024   4.303   0.729  1.00 42.21           C  
ATOM     68  O   THR A   9      -5.033   4.333   1.953  1.00 42.49           O  
ATOM     69  CB  THR A   9      -7.077   3.945  -0.647  1.00 44.28           C  
ATOM     70  OG1 THR A   9      -8.175   3.771   0.256  1.00 41.96           O  
ATOM     71  CG2 THR A   9      -7.437   3.322  -1.992  1.00 44.78           C  
ATOM     72  N   LEU A  10      -4.324   5.151  -0.008  1.00 42.22           N  
ATOM     73  CA  LEU A  10      -3.524   6.221   0.572  1.00 42.91           C  
ATOM     74  C   LEU A  10      -3.837   7.483  -0.214  1.00 40.04           C  
ATOM     75  O   LEU A  10      -4.191   7.415  -1.382  1.00 39.16           O  
ATOM     76  CB  LEU A  10      -2.020   5.942   0.425  1.00 44.73           C  
ATOM     77  CG  LEU A  10      -1.312   4.757   1.082  1.00 45.92           C  
ATOM     78  CD1 LEU A  10       0.078   4.658   0.469  1.00 50.10           C  
ATOM     79  CD2 LEU A  10      -1.207   4.941   2.589  1.00 46.49           C  
ATOM     80  N   ARG A  11      -3.682   8.629   0.436  1.00 40.28           N  
ATOM     81  CA  ARG A  11      -3.897   9.928  -0.183  1.00 38.36           C  
ATOM     82  C   ARG A  11      -2.512  10.538  -0.421  1.00 36.52           C  
ATOM     83  O   ARG A  11      -1.760  10.760   0.518  1.00 35.39           O  
ATOM     84  CB  ARG A  11      -4.710  10.816   0.764  1.00 38.36           C  
ATOM     85  CG  ARG A  11      -4.703  12.302   0.431  1.00 39.37           C  
ATOM     86  CD  ARG A  11      -5.770  13.035   1.250  1.00 38.03           C  
ATOM     87  NE  ARG A  11      -7.104  12.871   0.662  1.00 36.32           N  
ATOM     88  CZ  ARG A  11      -8.074  12.105   1.151  1.00 29.26           C  
ATOM     89  NH1 ARG A  11      -7.900  11.400   2.256  1.00 30.67           N  
ATOM     90  NH2 ARG A  11      -9.243  12.071   0.541  1.00 30.22           N  
ATOM     91  N   LEU A  12      -2.176  10.788  -1.677  1.00 35.82           N  
ATOM     92  CA  LEU A  12      -0.886  11.365  -2.021  1.00 40.57           C  
ATOM     93  C   LEU A  12      -1.090  12.863  -2.263  1.00 41.15           C  
ATOM     94  O   LEU A  12      -2.006  13.249  -2.987  1.00 41.10           O  
ATOM     95  CB  LEU A  12      -0.321  10.692  -3.292  1.00 40.01           C  
ATOM     96  CG  LEU A  12       1.005  11.189  -3.885  1.00 42.68           C  
ATOM     97  CD1 LEU A  12       2.108  10.955  -2.851  1.00 42.98           C  
ATOM     98  CD2 LEU A  12       1.362  10.507  -5.189  1.00 44.21           C  
ATOM     99  N   ARG A  13      -0.259  13.704  -1.657  1.00 41.86           N  
ATOM    100  CA  ARG A  13      -0.388  15.145  -1.874  1.00 45.51           C  
ATOM    101  C   ARG A  13       0.927  15.763  -2.316  1.00 45.93           C  
ATOM    102  O   ARG A  13       1.929  15.740  -1.604  1.00 44.55           O  
ATOM    103  CB  ARG A  13      -0.932  15.869  -0.622  1.00 48.10           C  
ATOM    104  CG  ARG A  13      -2.474  15.835  -0.509  1.00 48.68           C  
ATOM    105  CD  ARG A  13      -3.011  16.514   0.740  1.00 49.74           C  
ATOM    106  NE  ARG A  13      -3.292  15.558   1.808  1.00 54.52           N  
ATOM    107  CZ  ARG A  13      -4.067  15.812   2.863  1.00 55.79           C  
ATOM    108  NH1 ARG A  13      -4.646  16.999   3.003  1.00 54.78           N  
ATOM    109  NH2 ARG A  13      -4.274  14.875   3.774  1.00 56.42           N  
ATOM    110  N   ILE A  14       0.886  16.328  -3.511  1.00 46.66           N  
ATOM    111  CA  ILE A  14       2.032  16.951  -4.124  1.00 47.54           C  
ATOM    112  C   ILE A  14       1.881  18.471  -4.099  1.00 49.02           C  
ATOM    113  O   ILE A  14       1.011  19.034  -4.771  1.00 49.54           O  
ATOM    114  CB  ILE A  14       2.154  16.459  -5.577  1.00 47.74           C  
ATOM    115  CG1 ILE A  14       2.097  14.926  -5.584  1.00 44.80           C  
ATOM    116  CG2 ILE A  14       3.440  16.989  -6.210  1.00 46.35           C  
ATOM    117  CD1 ILE A  14       1.688  14.321  -6.907  1.00 45.06           C  
ATOM    118  N   TYR A  15       2.743  19.120  -3.324  1.00 47.82           N  
ATOM    119  CA  TYR A  15       2.747  20.564  -3.192  1.00 49.23           C  
ATOM    120  C   TYR A  15       3.845  21.177  -4.048  1.00 51.28           C  
ATOM    121  O   TYR A  15       5.024  20.944  -3.807  1.00 54.64           O  
ATOM    122  CB  TYR A  15       2.998  20.955  -1.739  1.00 47.54           C  
ATOM    123  CG  TYR A  15       1.946  20.490  -0.768  1.00 47.89           C  
ATOM    124  CD1 TYR A  15       1.741  19.137  -0.523  1.00 46.72           C  
ATOM    125  CD2 TYR A  15       1.165  21.409  -0.069  1.00 48.19           C  
ATOM    126  CE1 TYR A  15       0.790  18.715   0.397  1.00 47.21           C  
ATOM    127  CE2 TYR A  15       0.209  20.995   0.854  1.00 45.37           C  
ATOM    128  CZ  TYR A  15       0.029  19.655   1.083  1.00 45.33           C  
ATOM    129  OH  TYR A  15      -0.900  19.257   2.011  1.00 45.57           O  
ATOM    130  N   ILE A  16       3.462  21.971  -5.037  1.00 52.87           N  
ATOM    131  CA  ILE A  16       4.431  22.619  -5.905  1.00 54.22           C  
ATOM    132  C   ILE A  16       4.096  24.095  -6.079  1.00 56.39           C  
ATOM    133  O   ILE A  16       3.295  24.663  -5.329  1.00 57.10           O  
ATOM    134  CB  ILE A  16       4.475  21.951  -7.293  1.00 54.52           C  
ATOM    135  CG1 ILE A  16       3.055  21.761  -7.825  1.00 55.51           C  
ATOM    136  CG2 ILE A  16       5.230  20.629  -7.209  1.00 56.15           C  
ATOM    137  CD1 ILE A  16       2.988  21.160  -9.213  1.00 57.04           C  
ATOM    138  N   GLY A  17       4.725  24.713  -7.070  1.00 57.98           N  
ATOM    139  CA  GLY A  17       4.493  26.115  -7.333  1.00 57.87           C  
ATOM    140  C   GLY A  17       3.806  26.270  -8.673  1.00 58.46           C  
ATOM    141  O   GLY A  17       4.208  25.653  -9.659  1.00 58.77           O  
ATOM    142  N   GLU A  18       2.758  27.087  -8.693  1.00 59.43           N  
ATOM    143  CA  GLU A  18       1.984  27.357  -9.896  1.00 62.92           C  
ATOM    144  C   GLU A  18       2.917  27.697 -11.061  1.00 64.96           C  
ATOM    145  O   GLU A  18       2.650  27.351 -12.212  1.00 64.52           O  
ATOM    146  CB  GLU A  18       0.994  28.520  -9.629  1.00 62.41           C  
ATOM    147  CG  GLU A  18       0.050  28.886 -10.791  1.00 64.17           C  
ATOM    148  CD  GLU A  18      -0.955  29.991 -10.488  1.00 64.67           C  
ATOM    149  OE1 GLU A  18      -0.699  30.856  -9.633  1.00 65.86           O  
ATOM    150  OE2 GLU A  18      -2.005  29.990 -11.153  1.00 66.71           O  
ATOM    151  N   ASN A  19       4.023  28.361 -10.745  1.00 68.25           N  
ATOM    152  CA  ASN A  19       4.987  28.778 -11.755  1.00 71.79           C  
ATOM    153  C   ASN A  19       6.091  27.762 -12.048  1.00 72.83           C  
ATOM    154  O   ASN A  19       6.871  27.944 -12.988  1.00 72.35           O  
ATOM    155  CB  ASN A  19       5.585  30.121 -11.351  1.00 74.04           C  
ATOM    156  CG  ASN A  19       4.514  31.182 -11.164  1.00 77.06           C  
ATOM    157  OD1 ASN A  19       3.932  31.648 -12.142  1.00 78.59           O  
ATOM    158  ND2 ASN A  19       4.239  31.559  -9.928  1.00 77.34           N  
ATOM    159  N   ASP A  20       6.161  26.697 -11.250  1.00 74.03           N  
ATOM    160  CA  ASP A  20       7.158  25.656 -11.463  1.00 75.96           C  
ATOM    161  C   ASP A  20       6.939  25.084 -12.855  1.00 77.88           C  
ATOM    162  O   ASP A  20       5.805  24.827 -13.268  1.00 77.71           O  
ATOM    163  CB  ASP A  20       7.026  24.553 -10.415  1.00 75.70           C  
ATOM    164  CG  ASP A  20       7.349  25.038  -9.019  1.00 75.01           C  
ATOM    165  OD1 ASP A  20       7.913  26.147  -8.885  1.00 75.98           O  
ATOM    166  OD2 ASP A  20       7.052  24.308  -8.052  1.00 73.26           O  
ATOM    167  N   LYS A  21       8.036  24.877 -13.570  1.00 80.15           N  
ATOM    168  CA  LYS A  21       7.970  24.388 -14.935  1.00 82.08           C  
ATOM    169  C   LYS A  21       8.807  23.122 -15.147  1.00 82.81           C  
ATOM    170  O   LYS A  21       9.651  22.779 -14.324  1.00 81.97           O  
ATOM    171  CB  LYS A  21       8.427  25.523 -15.869  1.00 83.58           C  
ATOM    172  CG  LYS A  21       8.650  26.860 -15.115  1.00 84.81           C  
ATOM    173  CD  LYS A  21       8.645  28.093 -16.017  1.00 86.56           C  
ATOM    174  CE  LYS A  21       9.962  28.380 -16.691  1.00 87.54           C  
ATOM    175  NZ  LYS A  21       9.838  29.007 -18.022  1.00 88.06           N  
ATOM    176  N   TRP A  22       8.548  22.422 -16.247  1.00 84.57           N  
ATOM    177  CA  TRP A  22       9.286  21.207 -16.580  1.00 86.59           C  
ATOM    178  C   TRP A  22       9.401  21.084 -18.091  1.00 87.27           C  
ATOM    179  O   TRP A  22       8.394  20.955 -18.793  1.00 86.81           O  
ATOM    180  CB  TRP A  22       8.590  19.971 -16.012  1.00 87.59           C  
ATOM    181  CG  TRP A  22       9.357  18.715 -16.258  1.00 88.63           C  
ATOM    182  CD1 TRP A  22       9.107  17.773 -17.214  1.00 89.01           C  
ATOM    183  CD2 TRP A  22      10.516  18.270 -15.547  1.00 88.82           C  
ATOM    184  NE1 TRP A  22      10.040  16.765 -17.140  1.00 88.77           N  
ATOM    185  CE2 TRP A  22      10.917  17.046 -16.126  1.00 89.42           C  
ATOM    186  CE3 TRP A  22      11.258  18.790 -14.476  1.00 89.29           C  
ATOM    187  CZ2 TRP A  22      12.029  16.328 -15.668  1.00 90.02           C  
ATOM    188  CZ3 TRP A  22      12.364  18.075 -14.020  1.00 89.87           C  
ATOM    189  CH2 TRP A  22      12.737  16.856 -14.617  1.00 90.38           C  
ATOM    190  N   GLU A  23      10.637  21.126 -18.583  1.00 88.18           N  
ATOM    191  CA  GLU A  23      10.905  21.052 -20.013  1.00 89.00           C  
ATOM    192  C   GLU A  23      10.109  22.115 -20.764  1.00 88.80           C  
ATOM    193  O   GLU A  23       9.815  21.957 -21.948  1.00 89.37           O  
ATOM    194  CB  GLU A  23      10.562  19.667 -20.563  1.00 89.80           C  
ATOM    195  CG  GLU A  23      11.579  18.589 -20.220  1.00 91.23           C  
ATOM    196  CD  GLU A  23      11.305  17.284 -20.947  1.00 91.97           C  
ATOM    197  OE1 GLU A  23      11.251  17.296 -22.198  1.00 91.62           O  
ATOM    198  OE2 GLU A  23      11.145  16.246 -20.269  1.00 92.60           O  
ATOM    199  N   GLY A  24       9.757  23.191 -20.061  1.00 88.19           N  
ATOM    200  CA  GLY A  24       9.011  24.274 -20.679  1.00 86.93           C  
ATOM    201  C   GLY A  24       7.539  24.386 -20.313  1.00 86.21           C  
ATOM    202  O   GLY A  24       6.923  25.422 -20.574  1.00 86.16           O  
ATOM    203  N   ARG A  25       6.971  23.336 -19.716  1.00 84.62           N  
ATOM    204  CA  ARG A  25       5.556  23.332 -19.328  1.00 82.65           C  
ATOM    205  C   ARG A  25       5.328  23.437 -17.820  1.00 79.72           C  
ATOM    206  O   ARG A  25       6.269  23.331 -17.036  1.00 80.44           O  
ATOM    207  CB  ARG A  25       4.867  22.065 -19.859  1.00 84.85           C  
ATOM    208  CG  ARG A  25       4.613  22.095 -21.358  1.00 87.23           C  
ATOM    209  CD  ARG A  25       3.721  20.950 -21.854  1.00 89.35           C  
ATOM    210  NE  ARG A  25       2.860  21.468 -22.910  1.00 91.98           N  
ATOM    211  CZ  ARG A  25       1.801  20.861 -23.437  1.00 92.64           C  
ATOM    212  NH1 ARG A  25       1.426  19.655 -23.024  1.00 93.01           N  
ATOM    213  NH2 ARG A  25       1.086  21.505 -24.375  1.00 92.42           N  
ATOM    214  N   PRO A  26       4.072  23.676 -17.399  1.00 77.17           N  
ATOM    215  CA  PRO A  26       3.724  23.792 -15.978  1.00 74.39           C  
ATOM    216  C   PRO A  26       3.883  22.441 -15.294  1.00 71.71           C  
ATOM    217  O   PRO A  26       3.291  21.449 -15.712  1.00 69.29           O  
ATOM    218  CB  PRO A  26       2.264  24.243 -16.015  1.00 75.74           C  
ATOM    219  CG  PRO A  26       2.176  25.005 -17.293  1.00 75.91           C  
ATOM    220  CD  PRO A  26       2.944  24.114 -18.239  1.00 76.72           C  
ATOM    221  N   LEU A  27       4.680  22.412 -14.233  1.00 71.15           N  
ATOM    222  CA  LEU A  27       4.943  21.183 -13.500  1.00 69.89           C  
ATOM    223  C   LEU A  27       3.691  20.403 -13.103  1.00 68.12           C  
ATOM    224  O   LEU A  27       3.715  19.177 -13.078  1.00 67.49           O  
ATOM    225  CB  LEU A  27       5.768  21.489 -12.248  1.00 71.15           C  
ATOM    226  CG  LEU A  27       6.223  20.309 -11.380  1.00 71.85           C  
ATOM    227  CD1 LEU A  27       7.150  19.435 -12.202  1.00 72.70           C  
ATOM    228  CD2 LEU A  27       6.932  20.787 -10.132  1.00 72.89           C  
ATOM    229  N   TYR A  28       2.593  21.087 -12.792  1.00 66.69           N  
ATOM    230  CA  TYR A  28       1.399  20.356 -12.390  1.00 64.89           C  
ATOM    231  C   TYR A  28       0.683  19.734 -13.578  1.00 64.44           C  
ATOM    232  O   TYR A  28       0.156  18.627 -13.479  1.00 63.27           O  
ATOM    233  CB  TYR A  28       0.457  21.246 -11.565  1.00 65.15           C  
ATOM    234  CG  TYR A  28      -0.262  22.347 -12.312  1.00 64.51           C  
ATOM    235  CD1 TYR A  28      -1.520  22.129 -12.885  1.00 63.11           C  
ATOM    236  CD2 TYR A  28       0.299  23.621 -12.415  1.00 64.80           C  
ATOM    237  CE1 TYR A  28      -2.200  23.155 -13.539  1.00 63.36           C  
ATOM    238  CE2 TYR A  28      -0.370  24.650 -13.065  1.00 64.55           C  
ATOM    239  CZ  TYR A  28      -1.615  24.414 -13.625  1.00 64.84           C  
ATOM    240  OH  TYR A  28      -2.264  25.439 -14.275  1.00 65.66           O  
ATOM    241  N   LYS A  29       0.677  20.433 -14.707  1.00 64.93           N  
ATOM    242  CA  LYS A  29       0.046  19.906 -15.908  1.00 64.85           C  
ATOM    243  C   LYS A  29       0.812  18.670 -16.381  1.00 64.80           C  
ATOM    244  O   LYS A  29       0.210  17.715 -16.875  1.00 64.10           O  
ATOM    245  CB  LYS A  29       0.030  20.964 -17.020  1.00 65.05           C  
ATOM    246  CG  LYS A  29      -0.892  22.154 -16.762  1.00 67.03           C  
ATOM    247  CD  LYS A  29      -0.845  23.148 -17.921  1.00 67.47           C  
ATOM    248  CE  LYS A  29      -1.674  24.392 -17.638  1.00 67.84           C  
ATOM    249  NZ  LYS A  29      -1.324  25.517 -18.547  1.00 68.65           N  
ATOM    250  N   VAL A  30       2.137  18.686 -16.226  1.00 65.29           N  
ATOM    251  CA  VAL A  30       2.966  17.555 -16.653  1.00 65.49           C  
ATOM    252  C   VAL A  30       2.732  16.347 -15.752  1.00 65.07           C  
ATOM    253  O   VAL A  30       2.602  15.218 -16.228  1.00 64.64           O  
ATOM    254  CB  VAL A  30       4.492  17.908 -16.652  1.00 65.37           C  
ATOM    255  CG1 VAL A  30       4.982  18.197 -15.252  1.00 64.73           C  
ATOM    256  CG2 VAL A  30       5.281  16.736 -17.247  1.00 65.14           C  
ATOM    257  N   ILE A  31       2.665  16.592 -14.447  1.00 63.98           N  
ATOM    258  CA  ILE A  31       2.426  15.519 -13.495  1.00 62.88           C  
ATOM    259  C   ILE A  31       1.087  14.850 -13.768  1.00 63.10           C  
ATOM    260  O   ILE A  31       1.009  13.630 -13.895  1.00 61.85           O  
ATOM    261  CB  ILE A  31       2.427  16.054 -12.058  1.00 62.48           C  
ATOM    262  CG1 ILE A  31       3.851  16.437 -11.655  1.00 62.04           C  
ATOM    263  CG2 ILE A  31       1.836  15.021 -11.120  1.00 62.97           C  
ATOM    264  CD1 ILE A  31       3.972  16.925 -10.239  1.00 61.29           C  
ATOM    265  N   VAL A  32       0.034  15.653 -13.862  1.00 63.26           N  
ATOM    266  CA  VAL A  32      -1.295  15.114 -14.117  1.00 65.25           C  
ATOM    267  C   VAL A  32      -1.317  14.275 -15.390  1.00 65.84           C  
ATOM    268  O   VAL A  32      -1.988  13.243 -15.448  1.00 65.05           O  
ATOM    269  CB  VAL A  32      -2.345  16.238 -14.223  1.00 65.16           C  
ATOM    270  CG1 VAL A  32      -3.684  15.662 -14.654  1.00 64.05           C  
ATOM    271  CG2 VAL A  32      -2.486  16.934 -12.876  1.00 64.48           C  
ATOM    272  N   GLU A  33      -0.585  14.726 -16.406  1.00 67.88           N  
ATOM    273  CA  GLU A  33      -0.502  14.012 -17.675  1.00 69.54           C  
ATOM    274  C   GLU A  33       0.057  12.628 -17.361  1.00 68.84           C  
ATOM    275  O   GLU A  33      -0.523  11.603 -17.727  1.00 68.47           O  
ATOM    276  CB  GLU A  33       0.432  14.759 -18.630  1.00 71.97           C  
ATOM    277  CG  GLU A  33       0.123  14.556 -20.107  1.00 76.15           C  
ATOM    278  CD  GLU A  33       0.983  15.427 -21.015  1.00 79.51           C  
ATOM    279  OE1 GLU A  33       1.039  16.660 -20.795  1.00 81.18           O  
ATOM    280  OE2 GLU A  33       1.599  14.880 -21.956  1.00 80.55           O  
ATOM    281  N   LYS A  34       1.188  12.612 -16.666  1.00 69.22           N  
ATOM    282  CA  LYS A  34       1.835  11.372 -16.264  1.00 70.19           C  
ATOM    283  C   LYS A  34       0.818  10.468 -15.568  1.00 70.77           C  
ATOM    284  O   LYS A  34       0.523   9.371 -16.046  1.00 70.98           O  
ATOM    285  CB  LYS A  34       2.991  11.678 -15.310  1.00 70.86           C  
ATOM    286  CG  LYS A  34       4.104  12.526 -15.915  1.00 73.04           C  
ATOM    287  CD  LYS A  34       4.627  11.888 -17.193  1.00 74.51           C  
ATOM    288  CE  LYS A  34       5.921  12.495 -17.698  1.00 76.19           C  
ATOM    289  NZ  LYS A  34       6.167  12.074 -19.099  1.00 78.59           N  
ATOM    290  N   LEU A  35       0.283  10.954 -14.447  1.00 70.19           N  
ATOM    291  CA  LEU A  35      -0.700  10.228 -13.649  1.00 70.11           C  
ATOM    292  C   LEU A  35      -1.804   9.613 -14.496  1.00 71.34           C  
ATOM    293  O   LEU A  35      -2.296   8.525 -14.199  1.00 71.65           O  
ATOM    294  CB  LEU A  35      -1.344  11.167 -12.628  1.00 68.40           C  
ATOM    295  CG  LEU A  35      -0.457  11.919 -11.633  1.00 67.33           C  
ATOM    296  CD1 LEU A  35      -1.285  13.000 -10.945  1.00 66.63           C  
ATOM    297  CD2 LEU A  35       0.128  10.958 -10.614  1.00 65.81           C  
ATOM    298  N   ARG A  36      -2.195  10.314 -15.553  1.00 72.27           N  
ATOM    299  CA  ARG A  36      -3.263   9.840 -16.418  1.00 74.69           C  
ATOM    300  C   ARG A  36      -2.777   8.755 -17.373  1.00 75.75           C  
ATOM    301  O   ARG A  36      -3.547   7.898 -17.805  1.00 75.57           O  
ATOM    302  CB  ARG A  36      -3.847  11.019 -17.201  1.00 75.90           C  
ATOM    303  CG  ARG A  36      -5.361  10.978 -17.356  1.00 77.75           C  
ATOM    304  CD  ARG A  36      -5.918  12.367 -17.629  1.00 79.66           C  
ATOM    305  NE  ARG A  36      -5.432  12.921 -18.888  1.00 82.45           N  
ATOM    306  CZ  ARG A  36      -4.970  14.160 -19.034  1.00 84.27           C  
ATOM    307  NH1 ARG A  36      -4.927  14.982 -17.991  1.00 85.10           N  
ATOM    308  NH2 ARG A  36      -4.554  14.579 -20.222  1.00 84.82           N  
ATOM    309  N   GLU A  37      -1.489   8.784 -17.693  1.00 76.37           N  
ATOM    310  CA  GLU A  37      -0.938   7.793 -18.604  1.00 78.31           C  
ATOM    311  C   GLU A  37      -0.416   6.557 -17.859  1.00 77.80           C  
ATOM    312  O   GLU A  37      -0.174   5.512 -18.463  1.00 77.92           O  
ATOM    313  CB  GLU A  37       0.149   8.440 -19.472  1.00 80.35           C  
ATOM    314  CG  GLU A  37      -0.393   9.615 -20.291  1.00 83.04           C  
ATOM    315  CD  GLU A  37       0.599  10.262 -21.225  1.00 85.13           C  
ATOM    316  OE1 GLU A  37       1.728  10.531 -20.749  1.00 85.74           O  
ATOM    317  OE2 GLU A  37       0.283  10.525 -22.399  1.00 85.26           O  
ATOM    318  N   MET A  38      -0.241   6.678 -16.545  1.00 76.56           N  
ATOM    319  CA  MET A  38       0.215   5.553 -15.728  1.00 74.84           C  
ATOM    320  C   MET A  38      -1.004   4.772 -15.245  1.00 73.84           C  
ATOM    321  O   MET A  38      -0.875   3.759 -14.561  1.00 74.15           O  
ATOM    322  CB  MET A  38       1.008   6.048 -14.517  1.00 74.02           C  
ATOM    323  CG  MET A  38       2.394   6.547 -14.836  1.00 74.74           C  
ATOM    324  SD  MET A  38       3.197   7.464 -13.337  1.00 75.96           S  
ATOM    325  CE  MET A  38       3.925   5.962 -12.359  1.00 76.82           C  
ATOM    326  N   GLY A  39      -2.189   5.263 -15.600  1.00 73.32           N  
ATOM    327  CA  GLY A  39      -3.427   4.609 -15.204  1.00 70.97           C  
ATOM    328  C   GLY A  39      -3.836   4.776 -13.746  1.00 69.08           C  
ATOM    329  O   GLY A  39      -4.438   3.869 -13.172  1.00 68.28           O  
ATOM    330  N   ILE A  40      -3.523   5.925 -13.147  1.00 67.30           N  
ATOM    331  CA  ILE A  40      -3.882   6.178 -11.750  1.00 65.61           C  
ATOM    332  C   ILE A  40      -5.389   6.382 -11.579  1.00 63.90           C  
ATOM    333  O   ILE A  40      -6.065   6.886 -12.480  1.00 63.43           O  
ATOM    334  CB  ILE A  40      -3.113   7.407 -11.188  1.00 66.01           C  
ATOM    335  CG1 ILE A  40      -1.665   7.015 -10.886  1.00 65.68           C  
ATOM    336  CG2 ILE A  40      -3.762   7.914  -9.910  1.00 66.40           C  
ATOM    337  CD1 ILE A  40      -0.836   6.774 -12.105  1.00 65.59           C  
ATOM    338  N   ALA A  41      -5.905   5.976 -10.420  1.00 61.94           N  
ATOM    339  CA  ALA A  41      -7.335   6.078 -10.110  1.00 60.83           C  
ATOM    340  C   ALA A  41      -7.928   7.422 -10.508  1.00 58.81           C  
ATOM    341  O   ALA A  41      -8.964   7.484 -11.172  1.00 60.76           O  
ATOM    342  CB  ALA A  41      -7.570   5.817  -8.616  1.00 58.97           C  
ATOM    343  N   GLY A  42      -7.263   8.495 -10.104  1.00 56.92           N  
ATOM    344  CA  GLY A  42      -7.735   9.826 -10.428  1.00 55.34           C  
ATOM    345  C   GLY A  42      -6.878  10.854  -9.730  1.00 53.72           C  
ATOM    346  O   GLY A  42      -5.910  10.506  -9.052  1.00 54.60           O  
ATOM    347  N   ALA A  43      -7.229  12.123  -9.890  1.00 51.61           N  
ATOM    348  CA  ALA A  43      -6.472  13.194  -9.259  1.00 49.74           C  
ATOM    349  C   ALA A  43      -7.325  14.448  -9.124  1.00 48.16           C  
ATOM    350  O   ALA A  43      -8.266  14.656  -9.885  1.00 48.09           O  
ATOM    351  CB  ALA A  43      -5.230  13.502 -10.073  1.00 49.01           C  
ATOM    352  N   THR A  44      -6.994  15.281  -8.141  1.00 47.12           N  
ATOM    353  CA  THR A  44      -7.710  16.539  -7.925  1.00 45.97           C  
ATOM    354  C   THR A  44      -6.632  17.593  -7.669  1.00 44.45           C  
ATOM    355  O   THR A  44      -5.782  17.411  -6.800  1.00 43.51           O  
ATOM    356  CB  THR A  44      -8.735  16.440  -6.759  1.00 44.69           C  
ATOM    357  OG1 THR A  44      -9.776  15.524  -7.098  1.00 45.58           O  
ATOM    358  CG2 THR A  44      -9.350  17.779  -6.413  1.00 42.45           C  
ATOM    359  N   VAL A  45      -6.662  18.689  -8.430  1.00 44.84           N  
ATOM    360  CA  VAL A  45      -5.684  19.761  -8.250  1.00 47.08           C  
ATOM    361  C   VAL A  45      -6.296  21.005  -7.613  1.00 47.25           C  
ATOM    362  O   VAL A  45      -7.364  21.459  -8.021  1.00 47.00           O  
ATOM    363  CB  VAL A  45      -5.043  20.189  -9.599  1.00 47.45           C  
ATOM    364  CG1 VAL A  45      -4.020  21.289  -9.362  1.00 46.82           C  
ATOM    365  CG2 VAL A  45      -4.377  19.000 -10.277  1.00 50.57           C  
ATOM    366  N   TYR A  46      -5.594  21.551  -6.623  1.00 48.25           N  
ATOM    367  CA  TYR A  46      -6.035  22.749  -5.927  1.00 50.66           C  
ATOM    368  C   TYR A  46      -5.016  23.855  -6.081  1.00 52.04           C  
ATOM    369  O   TYR A  46      -3.830  23.599  -6.279  1.00 53.66           O  
ATOM    370  CB  TYR A  46      -6.178  22.519  -4.425  1.00 49.89           C  
ATOM    371  CG  TYR A  46      -7.026  21.363  -3.983  1.00 50.45           C  
ATOM    372  CD1 TYR A  46      -6.554  20.050  -4.065  1.00 48.64           C  
ATOM    373  CD2 TYR A  46      -8.265  21.587  -3.379  1.00 49.10           C  
ATOM    374  CE1 TYR A  46      -7.287  18.991  -3.540  1.00 48.25           C  
ATOM    375  CE2 TYR A  46      -9.007  20.540  -2.853  1.00 49.55           C  
ATOM    376  CZ  TYR A  46      -8.511  19.246  -2.928  1.00 50.45           C  
ATOM    377  OH  TYR A  46      -9.215  18.226  -2.339  1.00 49.59           O  
ATOM    378  N   ARG A  47      -5.482  25.087  -5.944  1.00 52.11           N  
ATOM    379  CA  ARG A  47      -4.609  26.236  -6.034  1.00 52.74           C  
ATOM    380  C   ARG A  47      -4.892  27.071  -4.789  1.00 52.77           C  
ATOM    381  O   ARG A  47      -5.999  27.572  -4.616  1.00 52.67           O  
ATOM    382  CB  ARG A  47      -4.918  27.023  -7.298  1.00 54.70           C  
ATOM    383  CG  ARG A  47      -3.982  28.183  -7.527  1.00 57.91           C  
ATOM    384  CD  ARG A  47      -4.556  29.040  -8.644  1.00 60.51           C  
ATOM    385  NE  ARG A  47      -4.205  28.574  -9.985  1.00 65.56           N  
ATOM    386  CZ  ARG A  47      -4.930  28.858 -11.063  1.00 67.26           C  
ATOM    387  NH1 ARG A  47      -6.026  29.577 -10.892  1.00 68.96           N  
ATOM    388  NH2 ARG A  47      -4.555  28.496 -12.301  1.00 69.34           N  
ATOM    389  N   GLY A  48      -3.910  27.176  -3.899  1.00 52.18           N  
ATOM    390  CA  GLY A  48      -4.102  27.946  -2.688  1.00 50.64           C  
ATOM    391  C   GLY A  48      -4.108  29.414  -3.042  1.00 50.50           C  
ATOM    392  O   GLY A  48      -3.908  29.771  -4.204  1.00 49.16           O  
ATOM    393  N   ILE A  49      -4.347  30.270  -2.056  1.00 50.46           N  
ATOM    394  CA  ILE A  49      -4.356  31.704  -2.314  1.00 51.06           C  
ATOM    395  C   ILE A  49      -2.989  32.242  -1.913  1.00 51.61           C  
ATOM    396  O   ILE A  49      -2.546  33.281  -2.391  1.00 52.31           O  
ATOM    397  CB  ILE A  49      -5.478  32.427  -1.519  1.00 49.66           C  
ATOM    398  CG1 ILE A  49      -5.337  32.141  -0.025  1.00 48.36           C  
ATOM    399  CG2 ILE A  49      -6.839  31.975  -2.018  1.00 46.76           C  
ATOM    400  CD1 ILE A  49      -6.273  32.949   0.839  1.00 50.32           C  
ATOM    401  N   TYR A  50      -2.315  31.508  -1.040  1.00 52.88           N  
ATOM    402  CA  TYR A  50      -0.989  31.897  -0.591  1.00 54.52           C  
ATOM    403  C   TYR A  50      -0.276  30.714   0.027  1.00 54.74           C  
ATOM    404  O   TYR A  50      -0.901  29.815   0.591  1.00 55.51           O  
ATOM    405  CB  TYR A  50      -1.058  33.018   0.453  1.00 55.84           C  
ATOM    406  CG  TYR A  50       0.289  33.340   1.079  1.00 57.83           C  
ATOM    407  CD1 TYR A  50       1.265  34.043   0.368  1.00 60.06           C  
ATOM    408  CD2 TYR A  50       0.604  32.907   2.364  1.00 58.52           C  
ATOM    409  CE1 TYR A  50       2.518  34.298   0.921  1.00 58.77           C  
ATOM    410  CE2 TYR A  50       1.849  33.157   2.925  1.00 58.96           C  
ATOM    411  CZ  TYR A  50       2.800  33.848   2.201  1.00 60.35           C  
ATOM    412  OH  TYR A  50       4.040  34.077   2.755  1.00 62.66           O  
ATOM    413  N   GLY A  51       1.044  30.733  -0.076  1.00 55.41           N  
ATOM    414  CA  GLY A  51       1.845  29.679   0.502  1.00 56.13           C  
ATOM    415  C   GLY A  51       3.307  30.075   0.607  1.00 56.67           C  
ATOM    416  O   GLY A  51       3.776  30.964  -0.107  1.00 54.14           O  
ATOM    417  N   PHE A  52       4.020  29.428   1.521  1.00 57.21           N  
ATOM    418  CA  PHE A  52       5.444  29.667   1.699  1.00 59.42           C  
ATOM    419  C   PHE A  52       6.041  28.363   2.211  1.00 61.37           C  
ATOM    420  O   PHE A  52       5.475  27.722   3.101  1.00 62.93           O  
ATOM    421  CB  PHE A  52       5.694  30.840   2.673  1.00 58.22           C  
ATOM    422  CG  PHE A  52       5.609  30.483   4.132  1.00 56.65           C  
ATOM    423  CD1 PHE A  52       6.667  29.843   4.771  1.00 56.85           C  
ATOM    424  CD2 PHE A  52       4.472  30.794   4.869  1.00 56.52           C  
ATOM    425  CE1 PHE A  52       6.603  29.531   6.136  1.00 57.98           C  
ATOM    426  CE2 PHE A  52       4.392  30.488   6.238  1.00 56.82           C  
ATOM    427  CZ  PHE A  52       5.459  29.847   6.870  1.00 57.42           C  
ATOM    428  N   GLY A  53       7.159  27.953   1.619  1.00 63.65           N  
ATOM    429  CA  GLY A  53       7.801  26.714   2.024  1.00 64.43           C  
ATOM    430  C   GLY A  53       9.283  26.876   2.289  1.00 65.52           C  
ATOM    431  O   GLY A  53       9.697  27.764   3.038  1.00 66.70           O  
ATOM    432  N   THR A  68       2.917  37.055  -7.396  1.00 85.76           N  
ATOM    433  CA  THR A  68       3.672  36.017  -6.709  1.00 85.57           C  
ATOM    434  C   THR A  68       3.203  34.604  -7.071  1.00 84.30           C  
ATOM    435  O   THR A  68       2.241  34.383  -7.804  1.00 84.51           O  
ATOM    436  CB  THR A  68       3.566  36.243  -5.196  1.00 86.98           C  
ATOM    437  OG1 THR A  68       3.944  37.591  -4.905  1.00 88.78           O  
ATOM    438  CG2 THR A  68       4.523  35.296  -4.461  1.00 87.65           C  
ATOM    439  N   ASP A  69       3.977  33.637  -6.542  1.00 81.98           N  
ATOM    440  CA  ASP A  69       3.754  32.210  -6.775  1.00 79.30           C  
ATOM    441  C   ASP A  69       2.540  31.691  -5.996  1.00 75.64           C  
ATOM    442  O   ASP A  69       2.418  31.883  -4.793  1.00 76.44           O  
ATOM    443  CB  ASP A  69       5.014  31.521  -6.237  1.00 81.00           C  
ATOM    444  CG  ASP A  69       5.435  30.342  -7.104  1.00 82.98           C  
ATOM    445  OD1 ASP A  69       4.754  30.073  -8.091  1.00 83.16           O  
ATOM    446  OD2 ASP A  69       6.434  29.706  -6.775  1.00 83.94           O  
ATOM    447  N   LEU A  70       1.600  31.038  -6.719  1.00 70.15           N  
ATOM    448  CA  LEU A  70       0.476  30.373  -6.043  1.00 63.69           C  
ATOM    449  C   LEU A  70       0.759  28.874  -5.864  1.00 58.97           C  
ATOM    450  O   LEU A  70       1.161  28.174  -6.786  1.00 57.59           O  
ATOM    451  CB  LEU A  70      -0.750  30.516  -6.949  1.00 63.20           C  
ATOM    452  CG  LEU A  70      -1.416  31.891  -6.878  1.00 63.07           C  
ATOM    453  CD1 LEU A  70      -2.845  31.853  -7.417  1.00 61.51           C  
ATOM    454  CD2 LEU A  70      -1.501  32.445  -5.457  1.00 61.38           C  
ATOM    455  N   PRO A  71       0.547  28.375  -4.630  1.00 55.45           N  
ATOM    456  CA  PRO A  71       0.775  26.965  -4.344  1.00 53.88           C  
ATOM    457  C   PRO A  71      -0.183  26.100  -5.142  1.00 52.74           C  
ATOM    458  O   PRO A  71      -1.358  26.408  -5.288  1.00 52.29           O  
ATOM    459  CB  PRO A  71       0.532  26.733  -2.862  1.00 53.39           C  
ATOM    460  CG  PRO A  71      -0.147  27.978  -2.291  1.00 54.33           C  
ATOM    461  CD  PRO A  71       0.068  29.063  -3.444  1.00 55.21           C  
ATOM    462  N   ILE A  72       0.339  25.007  -5.674  1.00 52.32           N  
ATOM    463  CA  ILE A  72      -0.483  24.091  -6.436  1.00 50.86           C  
ATOM    464  C   ILE A  72      -0.341  22.734  -5.775  1.00 50.57           C  
ATOM    465  O   ILE A  72       0.767  22.251  -5.548  1.00 51.68           O  
ATOM    466  CB  ILE A  72      -0.016  24.061  -7.895  1.00 50.92           C  
ATOM    467  CG1 ILE A  72      -0.382  25.382  -8.578  1.00 52.99           C  
ATOM    468  CG2 ILE A  72      -0.617  22.875  -8.611  1.00 51.89           C  
ATOM    469  CD1 ILE A  72      -1.459  25.275  -9.671  1.00 54.55           C  
ATOM    470  N   ILE A  73      -1.476  22.127  -5.463  1.00 49.41           N  
ATOM    471  CA  ILE A  73      -1.486  20.839  -4.789  1.00 46.91           C  
ATOM    472  C   ILE A  73      -2.233  19.792  -5.642  1.00 47.75           C  
ATOM    473  O   ILE A  73      -3.419  19.936  -5.900  1.00 47.62           O  
ATOM    474  CB  ILE A  73      -2.212  20.947  -3.408  1.00 46.77           C  
ATOM    475  CG1 ILE A  73      -1.474  21.917  -2.481  1.00 45.22           C  
ATOM    476  CG2 ILE A  73      -2.329  19.585  -2.761  1.00 43.35           C  
ATOM    477  CD1 ILE A  73      -1.697  23.372  -2.826  1.00 45.24           C  
ATOM    478  N   VAL A  74      -1.518  18.756  -6.091  1.00 47.50           N  
ATOM    479  CA  VAL A  74      -2.180  17.699  -6.846  1.00 46.03           C  
ATOM    480  C   VAL A  74      -2.409  16.625  -5.806  1.00 45.55           C  
ATOM    481  O   VAL A  74      -1.473  16.210  -5.111  1.00 46.17           O  
ATOM    482  CB  VAL A  74      -1.384  16.967  -7.941  1.00 47.41           C  
ATOM    483  CG1 VAL A  74      -2.245  15.883  -8.582  1.00 47.02           C  
ATOM    484  CG2 VAL A  74      -0.838  17.917  -8.965  1.00 48.61           C  
ATOM    485  N   GLU A  75      -3.649  16.155  -5.731  1.00 42.83           N  
ATOM    486  CA  GLU A  75      -3.985  15.143  -4.777  1.00 39.31           C  
ATOM    487  C   GLU A  75      -4.354  13.874  -5.517  1.00 39.37           C  
ATOM    488  O   GLU A  75      -5.060  13.919  -6.521  1.00 41.11           O  
ATOM    489  CB  GLU A  75      -5.149  15.614  -3.929  1.00 38.29           C  
ATOM    490  CG  GLU A  75      -5.656  14.578  -2.980  1.00 37.94           C  
ATOM    491  CD  GLU A  75      -6.810  15.068  -2.155  1.00 39.40           C  
ATOM    492  OE1 GLU A  75      -7.874  15.357  -2.738  1.00 41.07           O  
ATOM    493  OE2 GLU A  75      -6.650  15.158  -0.921  1.00 39.18           O  
ATOM    494  N   VAL A  76      -3.888  12.743  -5.006  1.00 38.40           N  
ATOM    495  CA  VAL A  76      -4.159  11.459  -5.626  1.00 38.17           C  
ATOM    496  C   VAL A  76      -4.481  10.419  -4.567  1.00 37.76           C  
ATOM    497  O   VAL A  76      -3.736  10.254  -3.607  1.00 37.79           O  
ATOM    498  CB  VAL A  76      -2.924  10.991  -6.438  1.00 39.37           C  
ATOM    499  CG1 VAL A  76      -3.176   9.603  -7.029  1.00 40.81           C  
ATOM    500  CG2 VAL A  76      -2.600  12.010  -7.532  1.00 33.06           C  
ATOM    501  N   VAL A  77      -5.606   9.731  -4.737  1.00 38.86           N  
ATOM    502  CA  VAL A  77      -6.019   8.674  -3.807  1.00 40.77           C  
ATOM    503  C   VAL A  77      -6.003   7.364  -4.609  1.00 43.45           C  
ATOM    504  O   VAL A  77      -6.652   7.258  -5.645  1.00 43.59           O  
ATOM    505  CB  VAL A  77      -7.436   8.934  -3.262  1.00 38.17           C  
ATOM    506  CG1 VAL A  77      -7.837   7.821  -2.331  1.00 35.85           C  
ATOM    507  CG2 VAL A  77      -7.470  10.261  -2.535  1.00 36.87           C  
ATOM    508  N   ASP A  78      -5.267   6.368  -4.134  1.00 46.08           N  
ATOM    509  CA  ASP A  78      -5.186   5.125  -4.898  1.00 49.77           C  
ATOM    510  C   ASP A  78      -4.469   4.078  -4.046  1.00 51.70           C  
ATOM    511  O   ASP A  78      -4.061   4.352  -2.916  1.00 50.69           O  
ATOM    512  CB  ASP A  78      -4.348   5.442  -6.162  1.00 50.29           C  
ATOM    513  CG  ASP A  78      -4.689   4.589  -7.376  1.00 52.10           C  
ATOM    514  OD1 ASP A  78      -5.030   3.404  -7.194  1.00 55.25           O  
ATOM    515  OD2 ASP A  78      -4.570   5.090  -8.514  1.00 52.07           O  
ATOM    516  N   ARG A  79      -4.296   2.883  -4.600  1.00 55.85           N  
ATOM    517  CA  ARG A  79      -3.594   1.828  -3.883  1.00 58.47           C  
ATOM    518  C   ARG A  79      -2.225   2.351  -3.541  1.00 58.53           C  
ATOM    519  O   ARG A  79      -1.584   2.976  -4.377  1.00 57.73           O  
ATOM    520  CB  ARG A  79      -3.477   0.621  -4.774  1.00 62.89           C  
ATOM    521  CG  ARG A  79      -4.843   0.154  -5.217  1.00 68.73           C  
ATOM    522  CD  ARG A  79      -4.753  -0.810  -6.403  1.00 72.87           C  
ATOM    523  NE  ARG A  79      -5.950  -1.621  -6.496  1.00 76.50           N  
ATOM    524  CZ  ARG A  79      -6.420  -2.341  -5.493  1.00 79.16           C  
ATOM    525  NH1 ARG A  79      -5.816  -2.364  -4.302  1.00 80.29           N  
ATOM    526  NH2 ARG A  79      -7.515  -3.047  -5.707  1.00 80.34           N  
ATOM    527  N   GLY A  80      -1.771   2.102  -2.320  1.00 59.84           N  
ATOM    528  CA  GLY A  80      -0.470   2.609  -1.924  1.00 61.26           C  
ATOM    529  C   GLY A  80       0.618   2.112  -2.849  1.00 62.22           C  
ATOM    530  O   GLY A  80       1.762   2.583  -2.842  1.00 62.85           O  
ATOM    531  N   HIS A  81       0.226   1.165  -3.682  1.00 60.75           N  
ATOM    532  CA  HIS A  81       1.121   0.515  -4.606  1.00 59.32           C  
ATOM    533  C   HIS A  81       1.239   1.243  -5.952  1.00 59.69           C  
ATOM    534  O   HIS A  81       2.196   1.040  -6.705  1.00 60.22           O  
ATOM    535  CB  HIS A  81       0.631  -0.922  -4.690  1.00 56.15           C  
ATOM    536  CG  HIS A  81       0.187  -1.449  -3.351  1.00 52.64           C  
ATOM    537  ND1 HIS A  81       0.979  -1.369  -2.227  1.00 50.73           N  
ATOM    538  CD2 HIS A  81      -0.990  -1.981  -2.942  1.00 48.63           C  
ATOM    539  CE1 HIS A  81       0.311  -1.826  -1.182  1.00 46.91           C  
ATOM    540  NE2 HIS A  81      -0.884  -2.203  -1.589  1.00 45.10           N  
ATOM    541  N   ASN A  82       0.272   2.110  -6.235  1.00 58.60           N  
ATOM    542  CA  ASN A  82       0.297   2.933  -7.437  1.00 56.34           C  
ATOM    543  C   ASN A  82       0.942   4.243  -6.968  1.00 54.94           C  
ATOM    544  O   ASN A  82       1.775   4.833  -7.661  1.00 52.74           O  
ATOM    545  CB  ASN A  82      -1.123   3.212  -7.946  1.00 57.77           C  
ATOM    546  CG  ASN A  82      -1.702   2.059  -8.770  1.00 59.71           C  
ATOM    547  OD1 ASN A  82      -1.280   0.913  -8.640  1.00 61.13           O  
ATOM    548  ND2 ASN A  82      -2.691   2.367  -9.607  1.00 58.96           N  
ATOM    549  N   ILE A  83       0.559   4.680  -5.769  1.00 53.26           N  
ATOM    550  CA  ILE A  83       1.093   5.912  -5.200  1.00 55.29           C  
ATOM    551  C   ILE A  83       2.618   5.889  -5.213  1.00 57.40           C  
ATOM    552  O   ILE A  83       3.253   6.871  -5.594  1.00 58.80           O  
ATOM    553  CB  ILE A  83       0.595   6.146  -3.732  1.00 52.62           C  
ATOM    554  CG1 ILE A  83      -0.812   6.736  -3.733  1.00 51.35           C  
ATOM    555  CG2 ILE A  83       1.517   7.110  -2.999  1.00 49.20           C  
ATOM    556  CD1 ILE A  83      -1.822   5.903  -4.439  1.00 51.35           C  
ATOM    557  N   GLU A  84       3.213   4.779  -4.791  1.00 61.32           N  
ATOM    558  CA  GLU A  84       4.666   4.687  -4.782  1.00 63.44           C  
ATOM    559  C   GLU A  84       5.223   4.670  -6.199  1.00 63.33           C  
ATOM    560  O   GLU A  84       6.286   5.231  -6.470  1.00 63.25           O  
ATOM    561  CB  GLU A  84       5.107   3.459  -4.010  1.00 64.61           C  
ATOM    562  CG  GLU A  84       5.731   3.802  -2.665  1.00 70.49           C  
ATOM    563  CD  GLU A  84       4.837   4.443  -1.622  1.00 73.05           C  
ATOM    564  OE1 GLU A  84       3.706   3.946  -1.453  1.00 74.94           O  
ATOM    565  OE2 GLU A  84       5.264   5.392  -0.945  1.00 74.43           O  
ATOM    566  N   LYS A  85       4.499   4.039  -7.111  1.00 63.72           N  
ATOM    567  CA  LYS A  85       4.923   4.008  -8.499  1.00 65.15           C  
ATOM    568  C   LYS A  85       4.967   5.473  -8.957  1.00 65.91           C  
ATOM    569  O   LYS A  85       5.872   5.896  -9.684  1.00 66.32           O  
ATOM    570  CB  LYS A  85       3.909   3.203  -9.324  1.00 67.26           C  
ATOM    571  CG  LYS A  85       4.201   3.076 -10.816  1.00 69.46           C  
ATOM    572  CD  LYS A  85       3.091   2.247 -11.466  1.00 71.78           C  
ATOM    573  CE  LYS A  85       3.039   0.823 -10.957  1.00 72.97           C  
ATOM    574  NZ  LYS A  85       1.810   0.080 -11.277  1.00 72.50           N  
ATOM    575  N   VAL A  86       3.990   6.249  -8.492  1.00 65.99           N  
ATOM    576  CA  VAL A  86       3.888   7.668  -8.829  1.00 64.90           C  
ATOM    577  C   VAL A  86       4.983   8.501  -8.172  1.00 64.49           C  
ATOM    578  O   VAL A  86       5.521   9.419  -8.785  1.00 63.56           O  
ATOM    579  CB  VAL A  86       2.514   8.243  -8.404  1.00 64.89           C  
ATOM    580  CG1 VAL A  86       2.578   9.757  -8.327  1.00 64.54           C  
ATOM    581  CG2 VAL A  86       1.447   7.828  -9.406  1.00 63.53           C  
ATOM    582  N   VAL A  87       5.297   8.182  -6.920  1.00 65.48           N  
ATOM    583  CA  VAL A  87       6.323   8.898  -6.171  1.00 67.40           C  
ATOM    584  C   VAL A  87       7.668   8.840  -6.884  1.00 68.69           C  
ATOM    585  O   VAL A  87       8.317   9.866  -7.090  1.00 68.87           O  
ATOM    586  CB  VAL A  87       6.500   8.306  -4.753  1.00 67.68           C  
ATOM    587  CG1 VAL A  87       7.638   9.015  -4.020  1.00 65.95           C  
ATOM    588  CG2 VAL A  87       5.207   8.438  -3.976  1.00 67.14           C  
ATOM    589  N   ASN A  88       8.081   7.632  -7.255  1.00 70.02           N  
ATOM    590  CA  ASN A  88       9.350   7.441  -7.941  1.00 72.02           C  
ATOM    591  C   ASN A  88       9.484   8.358  -9.156  1.00 72.59           C  
ATOM    592  O   ASN A  88      10.441   9.132  -9.263  1.00 73.33           O  
ATOM    593  CB  ASN A  88       9.505   5.977  -8.382  1.00 72.12           C  
ATOM    594  CG  ASN A  88       9.486   5.003  -7.210  1.00 72.51           C  
ATOM    595  OD1 ASN A  88      10.101   5.254  -6.170  1.00 72.48           O  
ATOM    596  ND2 ASN A  88       8.791   3.880  -7.380  1.00 70.91           N  
ATOM    597  N   VAL A  89       8.506   8.280 -10.055  1.00 73.17           N  
ATOM    598  CA  VAL A  89       8.504   9.068 -11.284  1.00 73.96           C  
ATOM    599  C   VAL A  89       8.393  10.581 -11.130  1.00 74.67           C  
ATOM    600  O   VAL A  89       8.554  11.307 -12.110  1.00 74.87           O  
ATOM    601  CB  VAL A  89       7.361   8.636 -12.213  1.00 74.45           C  
ATOM    602  CG1 VAL A  89       7.254   7.122 -12.235  1.00 76.22           C  
ATOM    603  CG2 VAL A  89       6.057   9.269 -11.763  1.00 75.76           C  
ATOM    604  N   ILE A  90       8.118  11.060  -9.919  1.00 75.42           N  
ATOM    605  CA  ILE A  90       7.968  12.498  -9.697  1.00 75.86           C  
ATOM    606  C   ILE A  90       9.007  13.096  -8.746  1.00 75.94           C  
ATOM    607  O   ILE A  90       9.292  14.290  -8.810  1.00 76.20           O  
ATOM    608  CB  ILE A  90       6.552  12.816  -9.152  1.00 76.68           C  
ATOM    609  CG1 ILE A  90       5.496  12.170 -10.047  1.00 77.00           C  
ATOM    610  CG2 ILE A  90       6.318  14.319  -9.125  1.00 76.99           C  
ATOM    611  CD1 ILE A  90       4.086  12.345  -9.544  1.00 78.80           C  
ATOM    612  N   LYS A  91       9.569  12.269  -7.868  1.00 76.29           N  
ATOM    613  CA  LYS A  91      10.570  12.727  -6.903  1.00 77.78           C  
ATOM    614  C   LYS A  91      11.656  13.593  -7.556  1.00 79.10           C  
ATOM    615  O   LYS A  91      12.116  14.570  -6.964  1.00 78.74           O  
ATOM    616  CB  LYS A  91      11.224  11.528  -6.207  1.00 77.87           C  
ATOM    617  CG  LYS A  91      11.037  11.465  -4.702  1.00 76.32           C  
ATOM    618  CD  LYS A  91      11.670  10.207  -4.163  1.00 76.39           C  
ATOM    619  CE  LYS A  91      11.516  10.027  -2.676  1.00 77.99           C  
ATOM    620  NZ  LYS A  91      11.636   8.575  -2.424  1.00 77.93           N  
ATOM    621  N   PRO A  92      12.092  13.239  -8.780  1.00 80.37           N  
ATOM    622  CA  PRO A  92      13.128  14.023  -9.466  1.00 81.93           C  
ATOM    623  C   PRO A  92      12.618  15.327 -10.082  1.00 82.98           C  
ATOM    624  O   PRO A  92      13.322  16.338 -10.082  1.00 83.27           O  
ATOM    625  CB  PRO A  92      13.638  13.053 -10.529  1.00 82.06           C  
ATOM    626  CG  PRO A  92      12.399  12.297 -10.886  1.00 81.36           C  
ATOM    627  CD  PRO A  92      11.813  11.996  -9.524  1.00 80.51           C  
ATOM    628  N   MET A  93      11.395  15.294 -10.611  1.00 83.98           N  
ATOM    629  CA  MET A  93      10.778  16.463 -11.243  1.00 84.28           C  
ATOM    630  C   MET A  93      10.522  17.597 -10.257  1.00 84.05           C  
ATOM    631  O   MET A  93      10.455  18.760 -10.645  1.00 83.68           O  
ATOM    632  CB  MET A  93       9.444  16.079 -11.889  1.00 84.64           C  
ATOM    633  CG  MET A  93       9.509  14.917 -12.853  1.00 84.82           C  
ATOM    634  SD  MET A  93       7.763  14.521 -13.572  1.00 86.28           S  
ATOM    635  CE  MET A  93       7.972  15.269 -15.334  1.00 86.69           C  
ATOM    636  N   ILE A  94      10.366  17.243  -8.988  1.00 84.58           N  
ATOM    637  CA  ILE A  94      10.099  18.220  -7.944  1.00 85.54           C  
ATOM    638  C   ILE A  94      11.393  18.718  -7.294  1.00 86.07           C  
ATOM    639  O   ILE A  94      11.759  18.279  -6.201  1.00 85.85           O  
ATOM    640  CB  ILE A  94       9.184  17.613  -6.862  1.00 85.38           C  
ATOM    641  CG1 ILE A  94       7.903  17.093  -7.520  1.00 85.52           C  
ATOM    642  CG2 ILE A  94       8.871  18.657  -5.799  1.00 86.25           C  
ATOM    643  CD1 ILE A  94       6.919  16.460  -6.556  1.00 85.22           C  
ATOM    644  N   LYS A  95      12.078  19.634  -7.967  1.00 86.76           N  
ATOM    645  CA  LYS A  95      13.322  20.177  -7.461  1.00 87.41           C  
ATOM    646  C   LYS A  95      13.172  20.771  -6.083  1.00 87.35           C  
ATOM    647  O   LYS A  95      14.082  20.693  -5.246  1.00 88.65           O  
ATOM    648  CB  LYS A  95      13.840  21.252  -8.403  1.00 87.78           C  
ATOM    649  CG  LYS A  95      13.858  20.753  -9.824  1.00 89.68           C  
ATOM    650  CD  LYS A  95      14.312  21.835 -10.755  1.00 91.00           C  
ATOM    651  CE  LYS A  95      15.249  22.829 -10.096  1.00 90.88           C  
ATOM    652  NZ  LYS A  95      15.764  23.656 -11.191  1.00 91.57           N  
ATOM    653  N   ASP A  96      12.024  21.374  -5.824  1.00 86.00           N  
ATOM    654  CA  ASP A  96      11.816  21.975  -4.507  1.00 83.99           C  
ATOM    655  C   ASP A  96      10.308  22.089  -4.361  1.00 81.10           C  
ATOM    656  O   ASP A  96       9.601  22.552  -5.258  1.00 81.13           O  
ATOM    657  CB  ASP A  96      12.582  23.306  -4.388  1.00 86.54           C  
ATOM    658  CG  ASP A  96      13.066  23.616  -2.950  1.00 89.36           C  
ATOM    659  OD1 ASP A  96      14.235  23.926  -2.716  1.00 90.45           O  
ATOM    660  OD2 ASP A  96      12.207  23.538  -2.030  1.00 91.05           O  
ATOM    661  N   GLY A  97       9.825  21.586  -3.228  1.00 77.46           N  
ATOM    662  CA  GLY A  97       8.409  21.571  -2.894  1.00 71.95           C  
ATOM    663  C   GLY A  97       8.212  20.565  -1.770  1.00 67.73           C  
ATOM    664  O   GLY A  97       9.018  20.511  -0.838  1.00 68.43           O  
ATOM    665  N   MET A  98       7.151  19.767  -1.849  1.00 62.69           N  
ATOM    666  CA  MET A  98       6.877  18.771  -0.814  1.00 56.96           C  
ATOM    667  C   MET A  98       5.878  17.704  -1.246  1.00 55.35           C  
ATOM    668  O   MET A  98       4.934  17.981  -1.985  1.00 53.40           O  
ATOM    669  CB  MET A  98       6.357  19.453   0.452  1.00 53.74           C  
ATOM    670  CG  MET A  98       5.980  18.493   1.568  1.00 51.70           C  
ATOM    671  SD  MET A  98       5.279  19.412   3.122  1.00 41.77           S  
ATOM    672  CE  MET A  98       6.112  18.415   4.517  1.00 49.01           C  
ATOM    673  N   ILE A  99       6.108  16.478  -0.777  1.00 52.90           N  
ATOM    674  CA  ILE A  99       5.235  15.351  -1.066  1.00 50.21           C  
ATOM    675  C   ILE A  99       4.822  14.724   0.263  1.00 48.28           C  
ATOM    676  O   ILE A  99       5.642  14.529   1.164  1.00 46.41           O  
ATOM    677  CB  ILE A  99       5.932  14.292  -1.924  1.00 51.41           C  
ATOM    678  CG1 ILE A  99       6.108  14.806  -3.350  1.00 52.89           C  
ATOM    679  CG2 ILE A  99       5.121  13.011  -1.932  1.00 52.60           C  
ATOM    680  CD1 ILE A  99       6.803  13.820  -4.281  1.00 53.91           C  
ATOM    681  N   THR A 100       3.538  14.400   0.365  1.00 44.67           N  
ATOM    682  CA  THR A 100       3.022  13.822   1.593  1.00 42.43           C  
ATOM    683  C   THR A 100       2.107  12.653   1.287  1.00 40.77           C  
ATOM    684  O   THR A 100       1.548  12.557   0.195  1.00 40.86           O  
ATOM    685  CB  THR A 100       2.282  14.869   2.428  1.00 43.62           C  
ATOM    686  OG1 THR A 100       3.147  15.970   2.728  1.00 46.17           O  
ATOM    687  CG2 THR A 100       1.803  14.262   3.709  1.00 45.22           C  
ATOM    688  N   VAL A 101       1.945  11.769   2.262  1.00 39.46           N  
ATOM    689  CA  VAL A 101       1.088  10.620   2.086  1.00 38.98           C  
ATOM    690  C   VAL A 101       0.583  10.129   3.440  1.00 38.61           C  
ATOM    691  O   VAL A 101       1.292  10.193   4.441  1.00 39.98           O  
ATOM    692  CB  VAL A 101       1.835   9.457   1.378  1.00 41.21           C  
ATOM    693  CG1 VAL A 101       2.832   8.788   2.352  1.00 37.83           C  
ATOM    694  CG2 VAL A 101       0.835   8.436   0.865  1.00 40.21           C  
ATOM    695  N   GLU A 102      -0.665   9.686   3.471  1.00 38.29           N  
ATOM    696  CA  GLU A 102      -1.235   9.136   4.684  1.00 40.21           C  
ATOM    697  C   GLU A 102      -2.452   8.308   4.302  1.00 39.60           C  
ATOM    698  O   GLU A 102      -3.058   8.515   3.242  1.00 40.27           O  
ATOM    699  CB  GLU A 102      -1.589  10.234   5.719  1.00 43.31           C  
ATOM    700  CG  GLU A 102      -2.831  11.096   5.468  1.00 44.97           C  
ATOM    701  CD  GLU A 102      -2.608  12.230   4.483  1.00 47.81           C  
ATOM    702  OE1 GLU A 102      -1.577  12.934   4.575  1.00 47.76           O  
ATOM    703  OE2 GLU A 102      -3.491  12.426   3.617  1.00 52.24           O  
ATOM    704  N   PRO A 103      -2.808   7.333   5.147  1.00 40.52           N  
ATOM    705  CA  PRO A 103      -3.954   6.460   4.896  1.00 42.07           C  
ATOM    706  C   PRO A 103      -5.295   7.171   4.810  1.00 42.78           C  
ATOM    707  O   PRO A 103      -5.486   8.250   5.368  1.00 43.43           O  
ATOM    708  CB  PRO A 103      -3.927   5.494   6.079  1.00 40.59           C  
ATOM    709  CG  PRO A 103      -2.484   5.474   6.474  1.00 43.09           C  
ATOM    710  CD  PRO A 103      -2.109   6.928   6.377  1.00 39.73           C  
ATOM    711  N   THR A 104      -6.216   6.540   4.100  1.00 43.98           N  
ATOM    712  CA  THR A 104      -7.574   7.023   3.960  1.00 44.66           C  
ATOM    713  C   THR A 104      -8.399   5.849   3.438  1.00 44.75           C  
ATOM    714  O   THR A 104      -7.872   4.944   2.776  1.00 47.63           O  
ATOM    715  CB  THR A 104      -7.696   8.207   2.980  1.00 45.24           C  
ATOM    716  OG1 THR A 104      -9.015   8.760   3.093  1.00 46.07           O  
ATOM    717  CG2 THR A 104      -7.478   7.746   1.529  1.00 44.09           C  
ATOM    718  N   ILE A 105      -9.683   5.862   3.757  1.00 43.54           N  
ATOM    719  CA  ILE A 105     -10.600   4.820   3.334  1.00 41.55           C  
ATOM    720  C   ILE A 105     -11.511   5.376   2.252  1.00 42.20           C  
ATOM    721  O   ILE A 105     -12.114   6.433   2.430  1.00 42.15           O  
ATOM    722  CB  ILE A 105     -11.470   4.355   4.513  1.00 41.36           C  
ATOM    723  CG1 ILE A 105     -10.579   3.827   5.628  1.00 39.77           C  
ATOM    724  CG2 ILE A 105     -12.463   3.288   4.063  1.00 41.92           C  
ATOM    725  CD1 ILE A 105     -11.346   3.415   6.859  1.00 42.97           C  
ATOM    726  N   VAL A 106     -11.588   4.685   1.118  1.00 40.87           N  
ATOM    727  CA  VAL A 106     -12.466   5.109   0.032  1.00 41.17           C  
ATOM    728  C   VAL A 106     -13.781   4.383   0.300  1.00 43.09           C  
ATOM    729  O   VAL A 106     -13.850   3.162   0.218  1.00 43.82           O  
ATOM    730  CB  VAL A 106     -11.908   4.703  -1.335  1.00 39.31           C  
ATOM    731  CG1 VAL A 106     -12.878   5.094  -2.426  1.00 35.79           C  
ATOM    732  CG2 VAL A 106     -10.543   5.369  -1.548  1.00 35.83           C  
ATOM    733  N   LEU A 107     -14.816   5.136   0.655  1.00 44.44           N  
ATOM    734  CA  LEU A 107     -16.099   4.536   0.982  1.00 45.01           C  
ATOM    735  C   LEU A 107     -17.010   4.306  -0.203  1.00 46.06           C  
ATOM    736  O   LEU A 107     -17.874   3.438  -0.153  1.00 48.91           O  
ATOM    737  CB  LEU A 107     -16.846   5.401   1.996  1.00 43.51           C  
ATOM    738  CG  LEU A 107     -16.197   5.662   3.355  1.00 42.39           C  
ATOM    739  CD1 LEU A 107     -17.020   6.714   4.092  1.00 42.02           C  
ATOM    740  CD2 LEU A 107     -16.110   4.376   4.157  1.00 39.87           C  
ATOM    741  N   TRP A 108     -16.823   5.063  -1.274  1.00 48.19           N  
ATOM    742  CA  TRP A 108     -17.704   4.919  -2.410  1.00 51.75           C  
ATOM    743  C   TRP A 108     -17.195   5.594  -3.669  1.00 52.32           C  
ATOM    744  O   TRP A 108     -16.264   6.394  -3.627  1.00 52.47           O  
ATOM    745  CB  TRP A 108     -19.070   5.503  -2.044  1.00 55.90           C  
ATOM    746  CG  TRP A 108     -20.213   4.684  -2.513  1.00 62.02           C  
ATOM    747  CD1 TRP A 108     -20.449   3.371  -2.220  1.00 63.69           C  
ATOM    748  CD2 TRP A 108     -21.296   5.116  -3.333  1.00 63.36           C  
ATOM    749  NE1 TRP A 108     -21.621   2.957  -2.807  1.00 65.89           N  
ATOM    750  CE2 TRP A 108     -22.163   4.009  -3.498  1.00 66.08           C  
ATOM    751  CE3 TRP A 108     -21.626   6.329  -3.944  1.00 65.13           C  
ATOM    752  CZ2 TRP A 108     -23.341   4.081  -4.253  1.00 65.47           C  
ATOM    753  CZ3 TRP A 108     -22.797   6.401  -4.694  1.00 66.03           C  
ATOM    754  CH2 TRP A 108     -23.639   5.282  -4.840  1.00 65.58           C  
ATOM    755  N   VAL A 109     -17.834   5.264  -4.787  1.00 53.58           N  
ATOM    756  CA  VAL A 109     -17.503   5.836  -6.083  1.00 57.14           C  
ATOM    757  C   VAL A 109     -18.799   6.161  -6.830  1.00 60.11           C  
ATOM    758  O   VAL A 109     -18.878   7.151  -7.562  1.00 60.73           O  
ATOM    759  CB  VAL A 109     -16.607   4.875  -6.918  1.00 56.84           C  
ATOM    760  CG1 VAL A 109     -16.929   5.011  -8.402  1.00 58.17           C  
ATOM    761  CG2 VAL A 109     -15.132   5.209  -6.685  1.00 53.15           C  
ATOM    762  N   GLY A 110     -19.819   5.336  -6.626  1.00 63.36           N  
ATOM    763  CA  GLY A 110     -21.098   5.590  -7.272  1.00 67.33           C  
ATOM    764  C   GLY A 110     -21.153   5.201  -8.737  1.00 70.90           C  
ATOM    765  O   GLY A 110     -21.134   6.045  -9.626  1.00 70.69           O  
ATOM    766  N   THR A 111     -21.228   3.898  -8.959  1.00 74.51           N  
ATOM    767  CA  THR A 111     -21.269   3.324 -10.275  1.00 78.63           C  
ATOM    768  C   THR A 111     -22.645   2.648 -10.371  1.00 81.80           C  
ATOM    769  O   THR A 111     -23.315   2.699 -11.413  1.00 82.21           O  
ATOM    770  CB  THR A 111     -20.057   2.343 -10.414  1.00 78.00           C  
ATOM    771  OG1 THR A 111     -19.629   2.229 -11.773  1.00 79.68           O  
ATOM    772  CG2 THR A 111     -20.371   0.985  -9.838  1.00 77.03           C  
ATOM    773  N   GLN A 112     -23.063   2.032  -9.267  1.00 85.84           N  
ATOM    774  CA  GLN A 112     -24.348   1.339  -9.176  1.00 89.67           C  
ATOM    775  C   GLN A 112     -25.134   1.678  -7.914  1.00 91.20           C  
ATOM    776  O   GLN A 112     -24.673   1.450  -6.793  1.00 90.16           O  
ATOM    777  CB  GLN A 112     -24.156  -0.175  -9.204  1.00 89.46           C  
ATOM    778  CG  GLN A 112     -23.358  -0.705 -10.361  1.00 90.99           C  
ATOM    779  CD  GLN A 112     -23.016  -2.164 -10.170  1.00 92.03           C  
ATOM    780  OE1 GLN A 112     -22.272  -2.746 -10.957  1.00 93.19           O  
ATOM    781  NE2 GLN A 112     -23.561  -2.768  -9.116  1.00 92.69           N  
ATOM    782  N   GLU A 113     -26.345   2.182  -8.117  1.00 93.58           N  
ATOM    783  CA  GLU A 113     -27.233   2.560  -7.024  1.00 95.94           C  
ATOM    784  C   GLU A 113     -28.188   1.451  -6.603  1.00 97.07           C  
ATOM    785  O   GLU A 113     -28.819   0.826  -7.451  1.00 97.46           O  
ATOM    786  CB  GLU A 113     -28.106   3.733  -7.436  1.00 97.30           C  
ATOM    787  CG  GLU A 113     -27.534   5.102  -7.257  1.00 99.02           C  
ATOM    788  CD  GLU A 113     -28.677   6.017  -6.959  1.00100.33           C  
ATOM    789  OE1 GLU A 113     -29.343   5.876  -5.928  1.00100.45           O  
ATOM    790  OE2 GLU A 113     -28.914   6.902  -7.811  1.00101.85           O  
ATOM    791  N   GLU A 114     -28.299   1.218  -5.297  1.00 98.13           N  
ATOM    792  CA  GLU A 114     -29.230   0.224  -4.752  1.00 99.06           C  
ATOM    793  C   GLU A 114     -29.360   0.380  -3.239  1.00 99.67           C  
ATOM    794  O   GLU A 114     -28.619   1.203  -2.658  1.00 99.76           O  
ATOM    795  CB  GLU A 114     -28.791  -1.216  -5.040  1.00 98.72           C  
ATOM    796  CG  GLU A 114     -27.733  -1.438  -6.106  1.00 99.20           C  
ATOM    797  CD  GLU A 114     -26.923  -2.688  -5.813  1.00 99.78           C  
ATOM    798  OE1 GLU A 114     -26.761  -3.536  -6.717  1.00100.34           O  
ATOM    799  OE2 GLU A 114     -26.451  -2.819  -4.663  1.00 99.89           O  
TER     800      GLU A 114                                                      
END
MOLECULE T0445_83_189.pdb
ATOM    652  N   MET    83       4.067  25.598  -7.757  1.00 16.58          
ATOM    653  CA  MET    83       4.674  24.586  -8.609  0.75 18.64          
ATOM    655  C   MET    83       4.747  25.034 -10.066  1.00 17.03          
ATOM    656  O   MET    83       3.784  25.617 -10.627  1.00 16.63          
ATOM    657  CB  MET    83       3.866  23.275  -8.491  0.75 18.40          
ATOM    659  CG  MET    83       3.611  22.913  -7.027  0.75 16.49          
ATOM    661  SD  MET    83       2.428  21.377  -6.885  0.75 15.77          
ATOM    663  CE  MET    83       3.771  20.026  -7.251  0.75 18.65          
ATOM    665  N   ASP    84       5.902  24.799 -10.657  1.00 18.62          
ATOM    666  CA  ASP    84       6.082  25.086 -12.084  0.50 19.63          
ATOM    668  C   ASP    84       5.115  24.250 -12.909  1.00 19.31          
ATOM    669  O   ASP    84       4.876  23.078 -12.631  1.00 19.78          
ATOM    670  CB  ASP    84       7.487  24.789 -12.576  0.50 20.02          
ATOM    672  CG  ASP    84       7.646  25.123 -14.047  0.50 18.48          
ATOM    674  OD1 ASP    84       7.552  26.315 -14.394  0.50 24.01          
ATOM    676  OD2 ASP    84       7.828  24.198 -14.864  0.50 19.84          
ATOM    678  N   GLU    85       4.577  24.888 -13.933  1.00 20.75          
ATOM    679  CA  GLU    85       3.579  24.298 -14.841  1.00 22.44          
ATOM    680  C   GLU    85       3.934  22.894 -15.340  1.00 22.70          
ATOM    681  O   GLU    85       3.072  22.016 -15.397  1.00 22.12          
ATOM    682  CB  GLU    85       3.323  25.236 -16.044  1.00 25.48          
ATOM    683  CG  GLU    85       2.106  24.864 -16.863  1.00 34.26          
ATOM    684  CD  GLU    85       1.940  25.776 -18.059  1.00 40.74          
ATOM    685  OE1 GLU    85       2.992  26.196 -18.584  1.00 43.87          
ATOM    686  OE2 GLU    85       0.785  26.060 -18.459  1.00 43.42          
ATOM    687  N   ASP    86       5.194  22.687 -15.695  1.00 23.20          
ATOM    688  CA  ASP    86       5.697  21.385 -16.181  0.50 23.62          
ATOM    690  C   ASP    86       5.583  20.286 -15.137  1.00 23.84          
ATOM    691  O   ASP    86       5.474  19.095 -15.450  1.00 25.39          
ATOM    692  CB  ASP    86       7.179  21.461 -16.608  0.50 24.53          
ATOM    694  CG  ASP    86       7.362  22.045 -17.997  0.50 25.25          
ATOM    696  OD1 ASP    86       6.356  22.214 -18.710  0.50 26.75          
ATOM    698  OD2 ASP    86       8.519  22.306 -18.377  0.50 30.58          
ATOM    700  N   ILE    87       5.660  20.694 -13.883  1.00 19.59          
ATOM    701  CA  ILE    87       5.584  19.751 -12.775  1.00 19.25          
ATOM    702  C   ILE    87       4.107  19.340 -12.565  1.00 17.01          
ATOM    703  O   ILE    87       3.753  18.187 -12.736  1.00 16.70          
ATOM    704  CB  ILE    87       6.152  20.319 -11.467  1.00 20.26          
ATOM    705  CG1 ILE    87       7.628  20.716 -11.608  1.00 21.64          
ATOM    706  CG2 ILE    87       6.014  19.276 -10.365  1.00 15.25          
ATOM    707  CD  ILE    87       8.518  19.567 -11.919  1.00 24.96          
ATOM    708  N   TRP    88       3.246  20.285 -12.229  1.00 15.63          
ATOM    709  CA  TRP    88       1.828  19.890 -11.927  1.00 15.11          
ATOM    710  C   TRP    88       1.058  19.384 -13.143  1.00 13.18          
ATOM    711  O   TRP    88       0.231  18.468 -13.028  1.00 14.82          
ATOM    712  CB  TRP    88       1.033  20.980 -11.160  1.00 14.39          
ATOM    713  CG  TRP    88       0.845  22.311 -11.816  1.00 15.98          
ATOM    714  CD1 TRP    88       1.672  23.375 -11.706  1.00 19.30          
ATOM    715  CD2 TRP    88      -0.266  22.749 -12.602  1.00 18.85          
ATOM    716  NE1 TRP    88       1.184  24.428 -12.423  1.00 19.22          
ATOM    717  CE2 TRP    88      -0.012  24.089 -12.971  1.00 19.14          
ATOM    718  CE3 TRP    88      -1.441  22.141 -13.048  1.00 23.28          
ATOM    719  CZ2 TRP    88      -0.878  24.830 -13.775  1.00 23.66          
ATOM    720  CZ3 TRP    88      -2.323  22.888 -13.827  1.00 21.96          
ATOM    721  CH2 TRP    88      -2.019  24.208 -14.203  1.00 23.35          
ATOM    722  N   LYS    89       1.315  19.969 -14.315  1.00 15.81          
ATOM    723  CA  LYS    89       0.653  19.485 -15.543  1.00 16.78          
ATOM    724  C   LYS    89       1.223  18.113 -15.927  1.00 15.53          
ATOM    725  O   LYS    89       0.488  17.210 -16.348  1.00 16.65          
ATOM    726  CB  LYS    89       0.775  20.475 -16.702  1.00 19.32          
ATOM    727  CG  LYS    89      -0.145  21.658 -16.505  1.00 20.23          
ATOM    728  CD  LYS    89      -0.234  22.566 -17.713  1.00 22.44          
ATOM    729  CE  LYS    89      -1.281  23.646 -17.443  1.00 25.22          
ATOM    730  NZ  LYS    89      -1.517  24.578 -18.590  1.00 27.98          
ATOM    731  N   GLY    90       2.509  17.944 -15.753  1.00 15.77          
ATOM    732  CA  GLY    90       3.163  16.651 -15.988  1.00 15.65          
ATOM    733  C   GLY    90       2.581  15.545 -15.094  1.00 15.08          
ATOM    734  O   GLY    90       2.344  14.393 -15.523  1.00 13.59          
ATOM    735  N   MET    91       2.354  15.908 -13.835  1.00 14.76          
ATOM    736  CA  MET    91       1.733  14.996 -12.851  1.00 13.05          
ATOM    737  C   MET    91       0.327  14.619 -13.302  1.00 13.25          
ATOM    738  O   MET    91      -0.054  13.453 -13.241  1.00 16.07          
ATOM    739  CB  MET    91       1.700  15.603 -11.465  1.00 13.66          
ATOM    740  CG  MET    91       3.066  15.678 -10.857  1.00 13.02          
ATOM    741  SD  MET    91       3.013  16.715  -9.233  1.00 14.73          
ATOM    742  CE  MET    91       4.812  16.296  -8.537  1.00 19.49          
ATOM    743  N   CYS    92      -0.435  15.616 -13.722  1.00 13.36          
ATOM    744  CA  CYS    92      -1.810  15.398 -14.208  1.00 13.68          
ATOM    745  C   CYS    92      -1.798  14.363 -15.332  1.00 14.03          
ATOM    746  O   CYS    92      -2.557  13.396 -15.348  1.00 12.98          
ATOM    747  CB  CYS    92      -2.410  16.675 -14.789  1.00 15.04          
ATOM    748  SG  CYS    92      -2.973  17.972 -13.631  1.00 21.33          
ATOM    749  N   ARG    93      -0.945  14.609 -16.328  1.00 14.40          
ATOM    750  CA  ARG    93      -0.887  13.704 -17.509  1.00 14.40          
ATOM    751  C   ARG    93      -0.516  12.311 -17.147  1.00 14.52          
ATOM    752  O   ARG    93      -1.116  11.337 -17.647  1.00 16.69          
ATOM    753  CB  ARG    93       0.069  14.246 -18.576  1.00 13.04          
ATOM    754  CG  ARG    93      -0.436  15.526 -19.120  1.00 16.20          
ATOM    755  CD  ARG    93       0.503  16.145 -20.131  1.00 24.99          
ATOM    756  NE  ARG    93      -0.046  17.411 -20.595  1.00 26.00          
ATOM    757  CZ  ARG    93       0.541  18.580 -20.366  1.00 27.24          
ATOM    758  NH1 ARG    93       1.747  18.637 -19.832  1.00 28.01          
ATOM    759  NH2 ARG    93      -0.031  19.671 -20.777  1.00 26.55          
ATOM    760  N   MET    94       0.407  12.198 -16.200  1.00 15.36          
ATOM    761  CA  MET    94       0.863  10.885 -15.761  1.00 13.93          
ATOM    762  C   MET    94      -0.226  10.132 -15.000  1.00 14.17          
ATOM    763  O   MET    94      -0.429   8.930 -15.214  1.00 13.19          
ATOM    764  CB  MET    94       2.140  10.956 -14.936  1.00 13.65          
ATOM    765  CG  MET    94       2.525   9.611 -14.345  1.00 16.93          
ATOM    766  SD  MET    94       4.242   9.635 -13.433  1.00 16.97          
ATOM    767  CE  MET    94       5.463   9.912 -14.944  1.00 19.80          
ATOM    768  N   VAL    95      -0.940  10.833 -14.117  1.00 13.74          
ATOM    769  CA  VAL    95      -1.975  10.147 -13.340  1.00 12.44          
ATOM    770  C   VAL    95      -3.090   9.696 -14.285  1.00 14.33          
ATOM    771  O   VAL    95      -3.552   8.565 -14.244  1.00 15.21          
ATOM    772  CB  VAL    95      -2.490  11.003 -12.184  1.00 13.57          
ATOM    773  CG1 VAL    95      -3.662  10.263 -11.441  1.00 15.24          
ATOM    774  CG2 VAL    95      -1.327  11.318 -11.219  1.00 13.88          
ATOM    775  N   ARG    96      -3.417  10.577 -15.211  1.00 16.47          
ATOM    776  CA  ARG    96      -4.486  10.331 -16.172  1.00 16.84          
ATOM    777  C   ARG    96      -4.185   9.120 -17.034  1.00 17.20          
ATOM    778  O   ARG    96      -5.014   8.226 -17.203  1.00 17.19          
ATOM    779  CB  ARG    96      -4.656  11.568 -17.050  1.00 16.97          
ATOM    780  CG  ARG    96      -5.750  11.487 -18.073  1.00 20.13          
ATOM    781  CD  ARG    96      -5.601  12.641 -19.080  1.00 21.38          
ATOM    782  NE  ARG    96      -4.321  12.478 -19.775  1.00 21.29          
ATOM    783  CZ  ARG    96      -3.656  13.416 -20.441  1.00 22.90          
ATOM    784  NH1 ARG    96      -4.118  14.625 -20.509  1.00 20.99          
ATOM    785  NH2 ARG    96      -2.472  13.136 -20.990  1.00 21.51          
ATOM    786  N   ASP    97      -2.955   9.069 -17.528  1.00 17.40          
ATOM    787  CA  ASP    97      -2.567   8.042 -18.483  1.00 18.45          
ATOM    788  C   ASP    97      -2.052   6.751 -17.900  1.00 18.83          
ATOM    789  O   ASP    97      -2.250   5.680 -18.497  1.00 18.43          
ATOM    790  CB  ASP    97      -1.489   8.597 -19.432  1.00 18.73          
ATOM    791  CG  ASP    97      -2.006   9.743 -20.303  1.00 21.69          
ATOM    792  OD1 ASP    97      -3.247   9.836 -20.513  1.00 21.00          
ATOM    793  OD2 ASP    97      -1.170  10.536 -20.796  1.00 22.41          
ATOM    794  N   GLU    98      -1.355   6.854 -16.776  1.00 15.62          
ATOM    795  CA  GLU    98      -0.716   5.702 -16.135  1.00 16.21          
ATOM    796  C   GLU    98      -1.273   5.239 -14.803  1.00 15.58          
ATOM    797  O   GLU    98      -0.953   4.144 -14.351  1.00 16.09          
ATOM    798  CB  GLU    98       0.792   5.944 -15.996  1.00 18.42          
ATOM    799  CG  GLU    98       1.430   6.372 -17.301  1.00 23.02          
ATOM    800  CD  GLU    98       2.938   6.297 -17.238  1.00 27.87          
ATOM    801  OE1 GLU    98       3.453   5.197 -16.976  1.00 28.57          
ATOM    802  OE2 GLU    98       3.568   7.337 -17.456  1.00 25.79          
ATOM    803  N   LEU    99      -2.084   6.086 -14.159  1.00 13.94          
ATOM    804  CA  LEU    99      -2.780   5.730 -12.898  1.00 12.73          
ATOM    805  C   LEU    99      -4.277   6.024 -13.047  1.00 13.77          
ATOM    806  O   LEU    99      -4.876   6.717 -12.236  1.00 15.24          
ATOM    807  CB  LEU    99      -2.207   6.488 -11.702  1.00 13.23          
ATOM    808  CG  LEU    99      -0.786   6.177 -11.239  1.00 16.54          
ATOM    809  CD1 LEU    99       0.274   6.707 -12.208  1.00 16.44          
ATOM    810  CD2 LEU    99      -0.577   6.812  -9.846  1.00 15.73          
ATOM    811  N   PRO   100      -4.893   5.424 -14.065  1.00 13.83          
ATOM    812  CA  PRO   100      -6.269   5.789 -14.412  1.00 14.22          
ATOM    813  C   PRO   100      -7.308   5.399 -13.354  1.00 14.50          
ATOM    814  O   PRO   100      -8.420   5.908 -13.395  1.00 16.73          
ATOM    815  CB  PRO   100      -6.488   5.059 -15.736  1.00 14.18          
ATOM    816  CG  PRO   100      -5.597   3.842 -15.624  1.00 13.09          
ATOM    817  CD  PRO   100      -4.374   4.337 -14.918  1.00 14.03          
ATOM    818  N   ALA   101      -6.947   4.566 -12.391  1.00 15.27          
ATOM    819  CA  ALA   101      -7.918   4.194 -11.344  1.00 15.72          
ATOM    820  C   ALA   101      -8.008   5.284 -10.290  1.00 14.71          
ATOM    821  O   ALA   101      -8.882   5.247  -9.447  1.00 14.28          
ATOM    822  CB  ALA   101      -7.552   2.917 -10.658  1.00 17.66          
ATOM    823  N   CYS   102      -7.030   6.173 -10.307  1.00 12.87          
ATOM    824  CA  CYS   102      -6.911   7.296  -9.351  1.00 13.76          
ATOM    825  C   CYS   102      -7.567   8.567  -9.861  1.00 15.52          
ATOM    826  O   CYS   102      -7.783   8.764 -11.072  1.00 15.92          
ATOM    827  CB  CYS   102      -5.419   7.613  -9.054  1.00 15.04          
ATOM    828  SG  CYS   102      -4.480   6.299  -8.276  1.00 16.18          
ATOM    829  N   ASP   103      -7.920   9.418  -8.913  1.00 15.84          
ATOM    830  CA  ASP   103      -8.347  10.760  -9.221  1.00 15.63          
ATOM    831  C   ASP   103      -7.274  11.765  -8.777  1.00 15.53          
ATOM    832  O   ASP   103      -6.306  11.435  -8.084  1.00 16.42          
ATOM    833  CB  ASP   103      -9.651  11.033  -8.523  1.00 17.21          
ATOM    834  CG  ASP   103     -10.739  10.119  -9.037  1.00 26.21          
ATOM    835  OD1 ASP   103     -11.126  10.257 -10.227  1.00 42.74          
ATOM    836  OD2 ASP   103     -11.172   9.254  -8.271  1.00 35.74          
ATOM    837  N   TYR   104      -7.454  13.009  -9.162  1.00 13.17          
ATOM    838  CA  TYR   104      -6.464  14.033  -8.784  1.00 13.15          
ATOM    839  C   TYR   104      -7.076  15.407  -8.688  1.00 14.34          
ATOM    840  O   TYR   104      -8.151  15.676  -9.234  1.00 15.24          
ATOM    841  CB  TYR   104      -5.234  14.020  -9.698  1.00 15.82          
ATOM    842  CG  TYR   104      -5.525  14.077 -11.163  1.00 16.50          
ATOM    843  CD1 TYR   104      -5.802  12.913 -11.879  1.00 19.91          
ATOM    844  CD2 TYR   104      -5.496  15.290 -11.856  1.00 19.43          
ATOM    845  CE1 TYR   104      -6.048  12.949 -13.224  1.00 21.54          
ATOM    846  CE2 TYR   104      -5.746  15.333 -13.226  1.00 22.34          
ATOM    847  CZ  TYR   104      -6.016  14.160 -13.902  1.00 23.46          
ATOM    848  OH  TYR   104      -6.276  14.177 -15.263  1.00 25.06          
ATOM    849  N   PHE   105      -6.368  16.249  -7.955  1.00 13.96          
ATOM    850  CA  PHE   105      -6.810  17.610  -7.660  1.00 13.91          
ATOM    851  C   PHE   105      -5.640  18.557  -7.713  1.00 14.96          
ATOM    852  O   PHE   105      -4.500  18.163  -7.442  1.00 16.71          
ATOM    853  CB  PHE   105      -7.417  17.672  -6.246  1.00 16.62          
ATOM    854  CG  PHE   105      -8.531  16.668  -6.022  1.00 13.76          
ATOM    855  CD1 PHE   105      -9.841  16.993  -6.347  1.00 15.71          
ATOM    856  CD2 PHE   105      -8.249  15.414  -5.536  1.00 14.83          
ATOM    857  CE1 PHE   105     -10.852  16.069  -6.189  1.00 15.56          
ATOM    858  CE2 PHE   105      -9.229  14.487  -5.388  1.00 13.27          
ATOM    859  CZ  PHE   105     -10.538  14.805  -5.701  1.00 13.48          
ATOM    860  N   ALA   106      -5.912  19.789  -8.101  1.00 14.33          
ATOM    861  CA  ALA   106      -4.855  20.820  -8.146  1.00 14.53          
ATOM    862  C   ALA   106      -5.367  22.025  -7.355  1.00 15.81          
ATOM    863  O   ALA   106      -6.426  22.578  -7.668  1.00 16.17          
ATOM    864  CB  ALA   106      -4.544  21.201  -9.585  1.00 14.33          
ATOM    865  N   ALA   107      -4.643  22.391  -6.315  1.00 16.36          
ATOM    866  CA  ALA   107      -5.091  23.453  -5.401  1.00 17.06          
ATOM    867  C   ALA   107      -4.323  24.751  -5.521  1.00 16.63          
ATOM    868  O   ALA   107      -3.140  24.760  -5.760  1.00 14.98          
ATOM    869  CB  ALA   107      -5.024  22.968  -3.948  1.00 18.70          
ATOM    870  N   THR   108      -5.063  25.840  -5.346  1.00 17.32          
ATOM    871  CA  THR   108      -4.494  27.184  -5.230  1.00 17.31          
ATOM    872  C   THR   108      -4.744  27.610  -3.765  1.00 17.98          
ATOM    873  O   THR   108      -5.352  26.859  -2.988  1.00 18.79          
ATOM    874  CB  THR   108      -5.154  28.194  -6.184  1.00 17.79          
ATOM    875  OG1 THR   108      -6.392  28.650  -5.627  1.00 17.75          
ATOM    876  CG2 THR   108      -5.399  27.541  -7.536  1.00 20.48          
ATOM    877  N   PRO   109      -4.283  28.802  -3.368  1.00 17.13          
ATOM    878  CA  PRO   109      -4.529  29.199  -1.989  1.00 18.15          
ATOM    879  C   PRO   109      -5.992  29.420  -1.674  1.00 19.48          
ATOM    880  O   PRO   109      -6.403  29.338  -0.513  1.00 22.42          
ATOM    881  CB  PRO   109      -3.760  30.516  -1.848  1.00 18.35          
ATOM    882  CG  PRO   109      -2.715  30.489  -2.909  1.00 17.22          
ATOM    883  CD  PRO   109      -3.277  29.637  -4.032  1.00 18.11          
ATOM    884  N   ASP   110      -6.786  29.632  -2.708  1.00 18.92          
ATOM    885  CA  ASP   110      -8.184  29.986  -2.541  1.00 20.16          
ATOM    886  C   ASP   110      -9.201  28.881  -2.827  1.00 21.37          
ATOM    887  O   ASP   110     -10.303  28.862  -2.276  1.00 20.83          
ATOM    888  CB  ASP   110      -8.491  31.156  -3.466  1.00 20.85          
ATOM    889  CG  ASP   110      -7.624  32.328  -3.178  1.00 28.07          
ATOM    890  OD1 ASP   110      -7.577  32.705  -1.995  1.00 28.70          
ATOM    891  OD2 ASP   110      -6.976  32.855  -4.114  1.00 37.81          
ATOM    892  N   PHE   111      -8.864  28.012  -3.753  1.00 19.13          
ATOM    893  CA  PHE   111      -9.766  26.933  -4.091  1.00 20.96          
ATOM    894  C   PHE   111      -9.014  25.774  -4.672  1.00 19.74          
ATOM    895  O   PHE   111      -7.811  25.843  -4.916  1.00 19.88          
ATOM    896  CB  PHE   111     -10.864  27.407  -5.044  1.00 23.56          
ATOM    897  CG  PHE   111     -10.385  28.380  -6.066  1.00 23.95          
ATOM    898  CD1 PHE   111      -9.620  27.956  -7.119  1.00 33.89          
ATOM    899  CD2 PHE   111     -10.662  29.721  -5.939  1.00 33.53          
ATOM    900  CE1 PHE   111      -9.161  28.854  -8.039  1.00 29.95          
ATOM    901  CE2 PHE   111     -10.197  30.617  -6.846  1.00 31.99          
ATOM    902  CZ  PHE   111      -9.444  30.189  -7.890  1.00 34.24          
ATOM    903  N   CYS   112      -9.776  24.719  -4.870  1.00 18.75          
ATOM    904  CA  CYS   112      -9.245  23.452  -5.361  1.00 18.63          
ATOM    905  C   CYS   112      -9.990  22.968  -6.579  1.00 19.70          
ATOM    906  O   CYS   112     -11.220  22.811  -6.565  1.00 18.77          
ATOM    907  CB  CYS   112      -9.325  22.414  -4.267  1.00 18.23          
ATOM    908  SG  CYS   112      -8.428  20.870  -4.722  1.00 23.29          
ATOM    909  N   PHE   113      -9.222  22.775  -7.646  1.00 18.62          
ATOM    910  CA  PHE   113      -9.735  22.281  -8.929  1.00 18.87          
ATOM    911  C   PHE   113      -9.879  20.764  -8.976  1.00 18.41          
ATOM    912  O   PHE   113      -9.023  20.011  -8.507  1.00 17.61          
ATOM    913  CB  PHE   113      -8.796  22.671 -10.073  1.00 18.56          
ATOM    914  CG  PHE   113      -8.710  24.134 -10.329  1.00 20.41          
ATOM    915  CD1 PHE   113      -9.745  24.793 -10.980  1.00 26.43          
ATOM    916  CD2 PHE   113      -7.573  24.844  -9.983  1.00 22.73          
ATOM    917  CE1 PHE   113      -9.665  26.149 -11.250  1.00 28.11          
ATOM    918  CE2 PHE   113      -7.487  26.208 -10.246  1.00 27.64          
ATOM    919  CZ  PHE   113      -8.546  26.858 -10.890  1.00 29.48          
ATOM    920  N   ALA   114     -10.994  20.345  -9.559  1.00 17.81          
ATOM    921  CA  ALA   114     -11.331  18.930  -9.739  1.00 18.26          
ATOM    922  C   ALA   114     -11.967  18.751 -11.105  1.00 18.94          
ATOM    923  O   ALA   114     -12.654  19.645 -11.576  1.00 19.69          
ATOM    924  CB  ALA   114     -12.340  18.439  -8.653  1.00 19.65          
ATOM    925  N   GLU   115     -11.741  17.597 -11.724  1.00 19.84          
ATOM    926  CA  GLU   115     -12.389  17.297 -13.003  1.00 21.18          
ATOM    927  C   GLU   115     -13.671  16.514 -12.815  1.00 23.05          
ATOM    928  O   GLU   115     -14.493  16.463 -13.710  1.00 22.87          
ATOM    929  CB  GLU   115     -11.461  16.568 -13.974  1.00 21.30          
ATOM    930  CG  GLU   115     -10.301  17.451 -14.369  1.00 17.88          
ATOM    931  CD  GLU   115      -9.337  16.804 -15.318  1.00 19.37          
ATOM    932  OE1 GLU   115      -9.576  15.658 -15.726  1.00 20.97          
ATOM    933  OE2 GLU   115      -8.330  17.466 -15.678  1.00 18.16          
ATOM    934  N   ASP   116     -13.837  15.899 -11.648  1.00 23.25          
ATOM    935  CA  ASP   116     -15.048  15.098 -11.364  1.00 24.77          
ATOM    936  C   ASP   116     -15.807  15.590 -10.146  1.00 24.20          
ATOM    937  O   ASP   116     -15.454  15.297  -9.002  1.00 25.56          
ATOM    938  CB  ASP   116     -14.675  13.643 -11.169  1.00 26.07          
ATOM    939  CG  ASP   116     -15.881  12.733 -11.000  1.00 29.71          
ATOM    940  OD1 ASP   116     -17.033  13.193 -11.111  1.00 31.70          
ATOM    941  OD2 ASP   116     -15.652  11.533 -10.784  1.00 35.49          
ATOM    942  N   GLY   117     -16.887  16.298 -10.414  1.00 23.45          
ATOM    943  CA  GLY   117     -17.676  16.901  -9.381  1.00 22.71          
ATOM    944  C   GLY   117     -18.782  16.027  -8.851  1.00 22.48          
ATOM    945  O   GLY   117     -19.566  16.439  -8.017  1.00 24.71          
ATOM    946  N   GLY   118     -18.807  14.798  -9.304  1.00 24.20          
ATOM    947  CA  GLY   118     -19.885  13.890  -8.905  1.00 24.33          
ATOM    948  C   GLY   118     -19.426  12.799  -7.982  1.00 24.09          
ATOM    949  O   GLY   118     -20.206  11.978  -7.519  1.00 25.07          
ATOM    950  N   SER   119     -18.146  12.785  -7.686  1.00 19.88          
ATOM    951  CA  SER   119     -17.619  11.677  -6.883  1.00 19.00          
ATOM    952  C   SER   119     -17.906  11.778  -5.389  1.00 17.24          
ATOM    953  O   SER   119     -18.140  12.868  -4.871  1.00 15.84          
ATOM    954  CB  SER   119     -16.108  11.537  -7.063  1.00 20.53          
ATOM    955  OG  SER   119     -15.417  12.605  -6.440  1.00 20.82          
ATOM    956  N   PRO   120     -17.860  10.630  -4.688  1.00 16.01          
ATOM    957  CA  PRO   120     -18.003  10.666  -3.260  1.00 15.69          
ATOM    958  C   PRO   120     -16.952  11.548  -2.587  1.00 15.33          
ATOM    959  O   PRO   120     -17.265  12.331  -1.707  1.00 15.01          
ATOM    960  CB  PRO   120     -17.869   9.197  -2.856  1.00 15.59          
ATOM    961  CG  PRO   120     -18.359   8.432  -4.071  1.00 16.36          
ATOM    962  CD  PRO   120     -17.889   9.250  -5.218  1.00 16.83          
ATOM    963  N   ILE   121     -15.712  11.474  -3.024  1.00 16.15          
ATOM    964  CA  ILE   121     -14.673  12.224  -2.329  1.00 16.80          
ATOM    965  C   ILE   121     -14.824  13.708  -2.612  1.00 15.35          
ATOM    966  O   ILE   121     -14.576  14.540  -1.737  1.00 15.88          
ATOM    967  CB  ILE   121     -13.256  11.690  -2.660  1.00 16.78          
ATOM    968  CG1 ILE   121     -12.304  12.012  -1.501  1.00 20.09          
ATOM    969  CG2 ILE   121     -12.848  12.166  -4.016  1.00 22.12          
ATOM    970  CD  ILE   121     -12.653  11.229  -0.170  1.00 20.06          
ATOM    971  N   PHE   122     -15.248  14.044  -3.825  1.00 15.24          
ATOM    972  CA  PHE   122     -15.503  15.450  -4.169  1.00 14.99          
ATOM    973  C   PHE   122     -16.551  16.000  -3.203  1.00 13.97          
ATOM    974  O   PHE   122     -16.433  17.070  -2.640  1.00 14.38          
ATOM    975  CB  PHE   122     -16.054  15.595  -5.562  1.00 15.85          
ATOM    976  CG  PHE   122     -16.324  17.021  -5.944  1.00 20.27          
ATOM    977  CD1 PHE   122     -15.316  17.802  -6.511  1.00 19.91          
ATOM    978  CD2 PHE   122     -17.560  17.583  -5.720  1.00 20.11          
ATOM    979  CE1 PHE   122     -15.560  19.116  -6.862  1.00 19.76          
ATOM    980  CE2 PHE   122     -17.796  18.883  -6.065  1.00 15.65          
ATOM    981  CZ  PHE   122     -16.804  19.649  -6.620  1.00 17.85          
ATOM    982  N   HSD   123     -17.620  15.252  -3.055  1.00 14.22          
ATOM    983  CA  HSD   123     -18.666  15.636  -2.077  1.00 13.85          
ATOM    984  C   HSD   123     -18.187  15.742  -0.651  1.00 14.51          
ATOM    985  O   HSD   123     -18.644  16.635   0.070  1.00 15.82          
ATOM    986  CB  HSD   123     -19.907  14.741  -2.196  1.00 13.87          
ATOM    987  CG  HSD   123     -20.672  15.011  -3.452  1.00 14.41          
ATOM    988  ND1 HSD   123     -21.514  16.091  -3.579  1.00 24.61          
ATOM    989  CD2 HSD   123     -20.694  14.373  -4.643  1.00 19.87          
ATOM    990  CE1 HSD   123     -22.015  16.115  -4.800  1.00 22.70          
ATOM    991  NE2 HSD   123     -21.544  15.078  -5.466  1.00 21.14          
ATOM    992  N   LEU   124     -17.274  14.861  -0.236  1.00 14.84          
ATOM    993  CA  LEU   124     -16.751  14.898   1.119  1.00 14.30          
ATOM    994  C   LEU   124     -15.952  16.195   1.325  1.00 15.06          
ATOM    995  O   LEU   124     -16.088  16.906   2.334  1.00 17.27          
ATOM    996  CB  LEU   124     -15.868  13.699   1.434  1.00 13.87          
ATOM    997  CG  LEU   124     -15.310  13.587   2.861  1.00 14.58          
ATOM    998  CD1 LEU   124     -16.400  13.189   3.888  1.00 19.15          
ATOM    999  CD2 LEU   124     -14.142  12.618   2.862  1.00 15.72          
ATOM   1000  N   LEU   125     -15.115  16.479   0.352  1.00 15.13          
ATOM   1001  CA  LEU   125     -14.237  17.660   0.420  1.00 15.97          
ATOM   1002  C   LEU   125     -15.039  18.939   0.472  1.00 15.31          
ATOM   1003  O   LEU   125     -14.776  19.807   1.281  1.00 15.99          
ATOM   1004  CB  LEU   125     -13.308  17.718  -0.805  1.00 17.08          
ATOM   1005  CG  LEU   125     -12.313  16.591  -0.896  1.00 17.32          
ATOM   1006  CD1 LEU   125     -11.452  16.712  -2.201  1.00 16.79          
ATOM   1007  CD2 LEU   125     -11.488  16.519   0.350  1.00 21.88          
ATOM   1008  N   ARG   126     -16.052  19.026  -0.378  1.00 14.44          
ATOM   1009  CA  ARG   126     -16.845  20.263  -0.483  1.00 16.12          
ATOM   1010  C   ARG   126     -17.852  20.410   0.637  1.00 17.71          
ATOM   1011  O   ARG   126     -17.946  21.468   1.265  1.00 19.13          
ATOM   1012  CB  ARG   126     -17.613  20.340  -1.819  1.00 17.22          
ATOM   1013  CG  ARG   126     -18.301  21.706  -2.055  1.00 19.47          
ATOM   1014  CD  ARG   126     -19.131  21.723  -3.345  1.00 21.80          
ATOM   1015  NE  ARG   126     -20.308  20.906  -3.130  1.00 24.02          
ATOM   1016  CZ  ARG   126     -21.107  20.398  -4.059  1.00 26.52          
ATOM   1017  NH1 ARG   126     -20.905  20.598  -5.347  1.00 29.40          
ATOM   1018  NH2 ARG   126     -22.119  19.647  -3.667  1.00 29.46          
ATOM   1019  N   ASP   127     -18.553  19.323   0.935  1.00 17.44          
ATOM   1020  CA  ASP   127     -19.702  19.421   1.826  1.00 17.93          
ATOM   1021  C   ASP   127     -19.506  18.961   3.249  1.00 19.43          
ATOM   1022  O   ASP   127     -20.361  19.239   4.115  1.00 19.74          
ATOM   1023  CB  ASP   127     -20.908  18.758   1.168  1.00 18.36          
ATOM   1024  CG  ASP   127     -21.328  19.455  -0.094  1.00 22.06          
ATOM   1025  OD1 ASP   127     -21.033  20.652  -0.244  1.00 19.75          
ATOM   1026  OD2 ASP   127     -21.955  18.809  -0.955  1.00 24.53          
ATOM   1027  N   SER   128     -18.425  18.242   3.513  1.00 16.70          
ATOM   1028  CA  SER   128     -18.095  17.916   4.897  1.00 18.91          
ATOM   1029  C   SER   128     -16.881  18.694   5.354  1.00 21.01          
ATOM   1030  O   SER   128     -16.839  19.180   6.469  1.00 22.55          
ATOM   1031  CB  SER   128     -17.876  16.424   5.148  1.00 20.38          
ATOM   1032  OG  SER   128     -19.084  15.674   4.976  1.00 17.18          
ATOM   1033  N   TYR   129     -15.894  18.856   4.487  1.00 20.34          
ATOM   1034  CA  TYR   129     -14.678  19.543   4.892  1.00 21.19          
ATOM   1035  C   TYR   129     -14.760  21.043   4.606  1.00 21.51          
ATOM   1036  O   TYR   129     -13.942  21.821   5.095  1.00 25.39          
ATOM   1037  CB  TYR   129     -13.427  18.920   4.266  1.00 21.96          
ATOM   1038  CG  TYR   129     -13.172  17.463   4.584  1.00 22.99          
ATOM   1039  CD1 TYR   129     -13.747  16.850   5.678  1.00 28.28          
ATOM   1040  CD2 TYR   129     -12.234  16.743   3.868  1.00 27.17          
ATOM   1041  CE1 TYR   129     -13.473  15.528   5.980  1.00 26.55          
ATOM   1042  CE2 TYR   129     -11.945  15.417   4.175  1.00 27.83          
ATOM   1043  CZ  TYR   129     -12.567  14.821   5.235  1.00 27.61          
ATOM   1044  OH  TYR   129     -12.255  13.486   5.540  1.00 29.52          
ATOM   1045  N   GLY   130     -15.717  21.427   3.794  1.00 18.89          
ATOM   1046  CA  GLY   130     -15.984  22.844   3.504  1.00 20.82          
ATOM   1047  C   GLY   130     -14.934  23.496   2.611  1.00 21.44          
ATOM   1048  O   GLY   130     -14.726  24.703   2.645  1.00 22.66          
ATOM   1049  N   PHE   131     -14.248  22.690   1.815  1.00 20.04          
ATOM   1050  CA  PHE   131     -13.271  23.262   0.905  1.00 18.15          
ATOM   1051  C   PHE   131     -13.972  23.896  -0.270  1.00 19.98          
ATOM   1052  O   PHE   131     -14.957  23.365  -0.773  1.00 18.99          
ATOM   1053  CB  PHE   131     -12.303  22.219   0.359  1.00 18.36          
ATOM   1054  CG  PHE   131     -11.432  21.612   1.373  1.00 17.51          
ATOM   1055  CD1 PHE   131     -10.718  22.401   2.248  1.00 24.81          
ATOM   1056  CD2 PHE   131     -11.256  20.268   1.418  1.00 18.73          
ATOM   1057  CE1 PHE   131      -9.883  21.836   3.178  1.00 27.96          
ATOM   1058  CE2 PHE   131     -10.400  19.701   2.320  1.00 23.34          
ATOM   1059  CZ  PHE   131      -9.715  20.493   3.217  1.00 24.01          
ATOM   1060  N   GLU   132     -13.439  25.037  -0.714  1.00 19.15          
ATOM   1061  CA  GLU   132     -13.906  25.672  -1.955  1.00 19.10          
ATOM   1062  C   GLU   132     -13.361  24.900  -3.141  1.00 19.68          
ATOM   1063  O   GLU   132     -12.149  24.862  -3.378  1.00 20.74          
ATOM   1064  CB  GLU   132     -13.454  27.121  -2.069  1.00 20.32          
ATOM   1065  CG  GLU   132     -14.110  28.023  -1.067  1.00 24.61          
ATOM   1066  CD  GLU   132     -15.605  28.197  -1.327  1.00 30.58          
ATOM   1067  OE1 GLU   132     -16.035  28.206  -2.507  1.00 29.24          
ATOM   1068  OE2 GLU   132     -16.329  28.352  -0.337  1.00 32.19          
ATOM   1069  N   MET   133     -14.285  24.306  -3.888  1.00 19.50          
ATOM   1070  CA  MET   133     -13.955  23.458  -5.015  1.00 22.43          
ATOM   1071  C   MET   133     -14.415  24.115  -6.294  1.00 25.39          
ATOM   1072  O   MET   133     -15.340  24.944  -6.277  1.00 25.10          
ATOM   1073  CB  MET   133     -14.656  22.104  -4.869  1.00 22.75          
ATOM   1074  CG  MET   133     -14.411  21.390  -3.567  1.00 21.56          
ATOM   1075  SD  MET   133     -12.570  20.904  -3.232  1.00 21.01          
ATOM   1076  CE  MET   133     -12.343  19.718  -4.765  1.00 20.16          
ATOM   1077  N   ARG   134     -13.681  23.853  -7.380  1.00 22.14          
ATOM   1078  CA  ARG   134     -14.078  24.333  -8.700  0.50 22.51          
ATOM   1080  C   ARG   134     -13.920  23.188  -9.686  1.00 22.88          
ATOM   1081  O   ARG   134     -12.840  22.633  -9.855  1.00 21.88          
ATOM   1082  CB  ARG   134     -13.309  25.590  -9.151  0.50 23.07          
ATOM   1084  CG  ARG   134     -13.278  26.668  -8.065  0.50 28.19          
ATOM   1086  CD  ARG   134     -13.415  28.120  -8.534  0.50 32.98          
ATOM   1088  NE  ARG   134     -12.543  28.517  -9.621  0.50 30.28          
ATOM   1090  CZ  ARG   134     -12.213  29.781  -9.858  0.50 28.83          
ATOM   1092  NH1 ARG   134     -12.620  30.737  -9.044  0.50 28.42          
ATOM   1094  NH2 ARG   134     -11.429  30.078 -10.868  0.50 28.67          
ATOM   1096  N   GLU   135     -15.033  22.836 -10.295  1.00 23.32          
ATOM   1097  CA  GLU   135     -15.056  21.786 -11.295  1.00 23.94          
ATOM   1098  C   GLU   135     -14.662  22.400 -12.633  1.00 23.43          
ATOM   1099  O   GLU   135     -15.156  23.455 -13.026  1.00 23.39          
ATOM   1100  CB  GLU   135     -16.428  21.114 -11.339  1.00 25.99          
ATOM   1101  CG  GLU   135     -16.512  19.962 -12.313  1.00 28.95          
ATOM   1102  CD  GLU   135     -17.801  19.181 -12.225  1.00 36.11          
ATOM   1103  OE1 GLU   135     -18.757  19.638 -11.533  1.00 35.84          
ATOM   1104  OE2 GLU   135     -17.835  18.091 -12.846  1.00 35.62          
ATOM   1105  N   VAL   136     -13.733  21.747 -13.299  1.00 20.97          
ATOM   1106  CA  VAL   136     -13.282  22.147 -14.635  1.00 21.93          
ATOM   1107  C   VAL   136     -13.195  20.924 -15.546  1.00 22.03          
ATOM   1108  O   VAL   136     -13.096  19.790 -15.072  1.00 21.59          
ATOM   1109  CB  VAL   136     -11.938  22.869 -14.595  1.00 22.29          
ATOM   1110  CG1 VAL   136     -12.061  24.148 -13.814  1.00 23.51          
ATOM   1111  CG2 VAL   136     -10.835  21.954 -14.029  1.00 18.70          
ATOM   1112  N   ASP   137     -13.164  21.135 -16.868  1.00 22.39          
ATOM   1113  CA  ASP   137     -13.115  20.000 -17.797  0.50 22.87          
ATOM   1115  C   ASP   137     -11.743  19.350 -17.859  1.00 22.44          
ATOM   1116  O   ASP   137     -11.636  18.133 -17.984  1.00 22.20          
ATOM   1117  CB  ASP   137     -13.530  20.404 -19.233  0.50 23.23          
ATOM   1119  CG  ASP   137     -13.570  19.217 -20.180  0.50 27.09          
ATOM   1121  OD1 ASP   137     -14.353  18.275 -19.942  0.50 28.33          
ATOM   1123  OD2 ASP   137     -12.810  19.210 -21.172  0.50 32.09          
ATOM   1125  N   ASP   138     -10.709  20.170 -17.774  1.00 20.62          
ATOM   1126  CA  ASP   138      -9.321  19.688 -17.927  1.00 20.91          
ATOM   1127  C   ASP   138      -8.335  20.604 -17.233  1.00 20.69          
ATOM   1128  O   ASP   138      -8.092  21.720 -17.648  1.00 19.95          
ATOM   1129  CB  ASP   138      -9.030  19.576 -19.447  1.00 21.58          
ATOM   1130  CG  ASP   138      -7.681  18.990 -19.779  1.00 25.46          
ATOM   1131  OD1 ASP   138      -6.766  18.893 -18.938  1.00 21.84          
ATOM   1132  OD2 ASP   138      -7.521  18.628 -20.967  1.00 26.48          
ATOM   1133  N   ILE   139      -7.768  20.089 -16.148  1.00 19.44          
ATOM   1134  CA  ILE   139      -6.829  20.865 -15.335  1.00 19.29          
ATOM   1135  C   ILE   139      -5.602  21.293 -16.152  1.00 21.04          
ATOM   1136  O   ILE   139      -5.035  22.352 -15.910  1.00 21.17          
ATOM   1137  CB  ILE   139      -6.430  20.088 -14.046  1.00 17.68          
ATOM   1138  CG1 ILE   139      -7.647  19.992 -13.112  1.00 18.06          
ATOM   1139  CG2 ILE   139      -5.364  20.771 -13.308  1.00 20.05          
ATOM   1140  CD  ILE   139      -7.408  19.072 -11.890  1.00 20.69          
ATOM   1141  N   THR   140      -5.233  20.495 -17.151  1.00 20.49          
ATOM   1142  CA  THR   140      -4.013  20.792 -17.926  1.00 22.88          
ATOM   1143  C   THR   140      -4.260  21.941 -18.883  1.00 24.90          
ATOM   1144  O   THR   140      -3.332  22.431 -19.510  1.00 24.35          
ATOM   1145  CB  THR   140      -3.460  19.591 -18.736  1.00 22.28          
ATOM   1146  OG1 THR   140      -4.358  19.256 -19.808  1.00 22.75          
ATOM   1147  CG2 THR   140      -3.222  18.374 -17.849  1.00 19.50          
ATOM   1148  N   ARG   141      -5.498  22.396 -18.953  1.00 25.54          
ATOM   1149  CA  ARG   141      -5.854  23.499 -19.843  0.50 27.57          
ATOM   1151  C   ARG   141      -5.982  24.800 -19.057  1.00 28.62          
ATOM   1152  O   ARG   141      -6.241  25.849 -19.612  1.00 28.54          
ATOM   1153  CB  ARG   141      -7.088  23.158 -20.698  0.50 28.00          
ATOM   1155  CG  ARG   141      -6.783  22.015 -21.693  0.50 31.30          
ATOM   1157  CD  ARG   141      -7.821  21.842 -22.783  0.50 37.54          
ATOM   1159  NE  ARG   141      -7.337  20.984 -23.871  0.50 37.20          
ATOM   1161  CZ  ARG   141      -7.792  19.766 -24.155  0.50 39.81          
ATOM   1163  NH1 ARG   141      -8.782  19.227 -23.442  0.50 38.79          
ATOM   1165  NH2 ARG   141      -7.263  19.092 -25.175  0.50 37.03          
ATOM   1167  N   LEU   142      -5.722  24.726 -17.758  1.00 27.82          
ATOM   1168  CA  LEU   142      -5.761  25.927 -16.933  1.00 27.05          
ATOM   1169  C   LEU   142      -4.479  26.724 -17.104  1.00 28.19          
ATOM   1170  O   LEU   142      -3.396  26.204 -17.355  1.00 28.08          
ATOM   1171  CB  LEU   142      -5.942  25.617 -15.456  1.00 27.43          
ATOM   1172  CG  LEU   142      -7.203  24.863 -15.090  1.00 30.20          
ATOM   1173  CD1 LEU   142      -7.142  24.455 -13.631  1.00 26.48          
ATOM   1174  CD2 LEU   142      -8.421  25.744 -15.375  1.00 31.56          
ATOM   1175  N   ASP   143      -4.640  28.023 -16.970  1.00 29.47          
ATOM   1176  CA  ASP   143      -3.529  28.944 -17.086  1.00 31.38          
ATOM   1177  C   ASP   143      -3.426  29.668 -15.772  1.00 30.85          
ATOM   1178  O   ASP   143      -4.134  30.632 -15.534  1.00 31.91          
ATOM   1179  CB  ASP   143      -3.804  29.948 -18.202  1.00 33.58          
ATOM   1180  CG  ASP   143      -2.669  30.909 -18.401  1.00 39.91          
ATOM   1181  OD1 ASP   143      -1.510  30.521 -18.135  1.00 46.97          
ATOM   1182  OD2 ASP   143      -2.939  32.041 -18.848  1.00 52.27          
ATOM   1183  N   ARG   144      -2.545  29.173 -14.918  1.00 29.97          
ATOM   1184  CA  ARG   144      -2.389  29.727 -13.595  1.00 29.10          
ATOM   1185  C   ARG   144      -0.972  29.648 -13.087  1.00 27.69          
ATOM   1186  O   ARG   144      -0.182  28.796 -13.509  1.00 30.36          
ATOM   1187  CB  ARG   144      -3.323  29.006 -12.642  1.00 31.64          
ATOM   1188  CG  ARG   144      -4.762  29.111 -13.073  1.00 32.05          
ATOM   1189  CD  ARG   144      -5.611  28.648 -12.006  1.00 32.84          
ATOM   1190  NE  ARG   144      -5.484  29.519 -10.856  1.00 31.59          
ATOM   1191  CZ  ARG   144      -6.382  30.435 -10.534  1.00 35.42          
ATOM   1192  NH1 ARG   144      -7.455  30.586 -11.288  1.00 38.39          
ATOM   1193  NH2 ARG   144      -6.216  31.187  -9.469  1.00 30.94          
ATOM   1194  N   ASN   145      -0.694  30.535 -12.151  1.00 25.39          
ATOM   1195  CA  ASN   145       0.647  30.628 -11.559  0.50 26.23          
ATOM   1197  C   ASN   145       0.636  30.427 -10.064  1.00 24.24          
ATOM   1198  O   ASN   145       1.641  30.684  -9.387  1.00 23.44          
ATOM   1199  CB  ASN   145       1.294  31.988 -11.847  0.50 27.34          
ATOM   1201  CG  ASN   145       2.755  32.043 -11.415  0.50 33.01          
ATOM   1203  OD1 ASN   145       3.404  33.094 -11.512  0.50 44.81          
ATOM   1205  ND2 ASN   145       3.288  30.906 -10.943  0.50 35.88          
ATOM   1207  N   ASP   146      -0.479  29.909  -9.583  1.00 21.40          
ATOM   1208  CA  ASP   146      -0.670  29.686  -8.151  1.00 19.79          
ATOM   1209  C   ASP   146      -1.094  28.289  -7.725  1.00 17.50          
ATOM   1210  O   ASP   146      -1.823  28.159  -6.763  1.00 17.54          
ATOM   1211  CB  ASP   146      -1.680  30.690  -7.609  1.00 19.83          
ATOM   1212  CG  ASP   146      -3.053  30.578  -8.246  1.00 21.36          
ATOM   1213  OD1 ASP   146      -3.226  29.814  -9.220  1.00 23.84          
ATOM   1214  OD2 ASP   146      -3.993  31.260  -7.764  1.00 27.40          
ATOM   1215  N   ILE   147      -0.676  27.276  -8.477  1.00 17.12          
ATOM   1216  CA  ILE   147      -0.903  25.878  -8.061  1.00 16.69          
ATOM   1217  C   ILE   147       0.122  25.567  -6.981  1.00 15.97          
ATOM   1218  O   ILE   147       1.346  25.522  -7.209  1.00 15.88          
ATOM   1219  CB  ILE   147      -0.848  24.871  -9.242  1.00 17.97          
ATOM   1220  CG1 ILE   147      -1.928  25.215 -10.284  1.00 23.06          
ATOM   1221  CG2 ILE   147      -1.022  23.476  -8.724  1.00 14.70          
ATOM   1222  CD  ILE   147      -3.310  25.292  -9.774  1.00 20.72          
ATOM   1223  N   ILE   148      -0.398  25.359  -5.771  1.00 13.51          
ATOM   1224  CA  ILE   148       0.423  25.110  -4.604  1.00 15.17          
ATOM   1225  C   ILE   148       0.436  23.664  -4.159  1.00 13.84          
ATOM   1226  O   ILE   148       1.313  23.237  -3.400  1.00 15.58          
ATOM   1227  CB  ILE   148       0.059  26.056  -3.390  1.00 15.15          
ATOM   1228  CG1 ILE   148      -1.393  25.860  -2.944  1.00 15.79          
ATOM   1229  CG2 ILE   148       0.480  27.533  -3.707  1.00 15.67          
ATOM   1230  CD  ILE   148      -1.716  26.554  -1.607  1.00 19.48          
ATOM   1231  N   LYS   149      -0.484  22.877  -4.711  1.00 14.14          
ATOM   1232  CA  LYS   149      -0.539  21.444  -4.353  1.00 14.33          
ATOM   1233  C   LYS   149      -1.221  20.639  -5.449  1.00 13.90          
ATOM   1234  O   LYS   149      -2.178  21.088  -6.036  1.00 13.20          
ATOM   1235  CB  LYS   149      -1.312  21.234  -3.057  1.00 16.32          
ATOM   1236  CG  LYS   149      -1.421  19.741  -2.632  1.00 18.32          
ATOM   1237  CD  LYS   149      -2.075  19.578  -1.282  1.00 18.31          
ATOM   1238  CE  LYS   149      -3.543  19.985  -1.300  1.00 24.75          
ATOM   1239  NZ  LYS   149      -4.167  19.731   0.057  1.00 23.90          
ATOM   1240  N   PHE   150      -0.643  19.478  -5.719  1.00 15.04          
ATOM   1241  CA  PHE   150      -1.224  18.497  -6.622  1.00 13.83          
ATOM   1242  C   PHE   150      -1.388  17.247  -5.770  1.00 13.69          
ATOM   1243  O   PHE   150      -0.440  16.777  -5.134  1.00 13.05          
ATOM   1244  CB  PHE   150      -0.345  18.220  -7.831  1.00 14.39          
ATOM   1245  CG  PHE   150      -0.873  17.087  -8.706  1.00 14.83          
ATOM   1246  CD1 PHE   150      -1.704  17.341  -9.752  1.00 15.85          
ATOM   1247  CD2 PHE   150      -0.514  15.781  -8.454  1.00 14.18          
ATOM   1248  CE1 PHE   150      -2.209  16.315 -10.538  1.00 14.43          
ATOM   1249  CE2 PHE   150      -1.000  14.753  -9.258  1.00 11.35          
ATOM   1250  CZ  PHE   150      -1.845  15.043 -10.301  1.00 11.09          
ATOM   1251  N   THR   151      -2.604  16.730  -5.761  1.00 12.44          
ATOM   1252  CA  THR   151      -2.956  15.603  -4.936  1.00 12.04          
ATOM   1253  C   THR   151      -3.573  14.451  -5.711  1.00 10.52          
ATOM   1254  O   THR   151      -4.478  14.643  -6.531  1.00 11.55          
ATOM   1255  CB  THR   151      -3.991  16.056  -3.883  1.00 12.31          
ATOM   1256  OG1 THR   151      -3.370  17.013  -2.994  1.00 17.05          
ATOM   1257  CG2 THR   151      -4.521  14.874  -3.047  1.00 17.44          
ATOM   1258  N   VAL   152      -3.084  13.251  -5.413  1.00 13.75          
ATOM   1259  CA  VAL   152      -3.628  12.011  -6.007  1.00 12.28          
ATOM   1260  C   VAL   152      -4.487  11.330  -4.958  1.00 12.69          
ATOM   1261  O   VAL   152      -4.134  11.285  -3.791  1.00 14.11          
ATOM   1262  CB  VAL   152      -2.516  11.027  -6.428  1.00 15.41          
ATOM   1263  CG1 VAL   152      -3.109   9.930  -7.309  1.00 11.85          
ATOM   1264  CG2 VAL   152      -1.344  11.796  -7.158  1.00 11.86          
ATOM   1265  N   PHE   153      -5.625  10.823  -5.405  1.00 12.77          
ATOM   1266  CA  PHE   153      -6.566  10.076  -4.579  1.00 12.72          
ATOM   1267  C   PHE   153      -6.930   8.715  -5.153  1.00 12.99          
ATOM   1268  O   PHE   153      -7.085   8.520  -6.365  1.00 14.20          
ATOM   1269  CB  PHE   153      -7.886  10.850  -4.418  1.00 13.51          
ATOM   1270  CG  PHE   153      -8.955  10.065  -3.687  1.00 12.38          
ATOM   1271  CD1 PHE   153      -8.925   9.968  -2.325  1.00 12.31          
ATOM   1272  CD2 PHE   153      -9.987   9.442  -4.372  1.00 15.69          
ATOM   1273  CE1 PHE   153      -9.899   9.236  -1.628  1.00 16.14          
ATOM   1274  CE2 PHE   153     -10.967   8.728  -3.667  1.00 16.05          
ATOM   1275  CZ  PHE   153     -10.899   8.627  -2.317  1.00 14.79          
ATOM   1276  N   HSD   154      -6.986   7.771  -4.236  1.00 15.08          
ATOM   1277  CA  HSD   154      -7.570   6.438  -4.487  1.00 14.07          
ATOM   1278  C   HSD   154      -8.274   5.990  -3.194  1.00 14.14          
ATOM   1279  O   HSD   154      -7.768   6.242  -2.121  1.00 15.74          
ATOM   1280  CB  HSD   154      -6.542   5.384  -4.926  1.00 12.60          
ATOM   1281  CG  HSD   154      -7.166   4.092  -5.358  1.00 13.42          
ATOM   1282  ND1 HSD   154      -7.514   3.094  -4.469  1.00 15.12          
ATOM   1283  CD2 HSD   154      -7.535   3.651  -6.581  1.00 12.58          
ATOM   1284  CE1 HSD   154      -8.043   2.082  -5.141  1.00 11.07          
ATOM   1285  NE2 HSD   154      -8.072   2.397  -6.421  1.00 12.01          
ATOM   1286  N   PRO   155      -9.424   5.304  -3.289  1.00 15.53          
ATOM   1287  CA  PRO   155     -10.113   4.854  -2.083  1.00 15.43          
ATOM   1288  C   PRO   155      -9.322   4.013  -1.117  1.00 16.01          
ATOM   1289  O   PRO   155      -9.610   4.015   0.077  1.00 14.96          
ATOM   1290  CB  PRO   155     -11.224   3.982  -2.653  1.00 15.41          
ATOM   1291  CG  PRO   155     -11.559   4.622  -3.884  1.00 16.46          
ATOM   1292  CD  PRO   155     -10.207   4.957  -4.486  1.00 15.59          
ATOM   1293  N   ASP   156      -8.350   3.256  -1.598  1.00 14.03          
ATOM   1294  CA  ASP   156      -7.644   2.377  -0.680  1.00 16.51          
ATOM   1295  C   ASP   156      -6.224   1.940  -0.994  1.00 17.30          
ATOM   1296  O   ASP   156      -5.628   1.241  -0.171  1.00 17.31          
ATOM   1297  CB  ASP   156      -8.501   1.144  -0.430  1.00 17.81          
ATOM   1298  CG  ASP   156      -8.916   0.481  -1.677  1.00 23.66          
ATOM   1299  OD1 ASP   156      -8.005   0.018  -2.384  1.00 24.90          
ATOM   1300  OD2 ASP   156     -10.151   0.431  -1.966  1.00 24.36          
ATOM   1301  N   LYS   157      -5.677   2.341  -2.136  1.00 14.03          
ATOM   1302  CA  LYS   157      -4.272   1.961  -2.432  1.00 13.75          
ATOM   1303  C   LYS   157      -3.586   3.003  -3.257  1.00 14.38          
ATOM   1304  O   LYS   157      -2.842   2.702  -4.181  1.00 14.72          
ATOM   1305  CB  LYS   157      -4.199   0.610  -3.143  1.00 15.38          
ATOM   1306  CG  LYS   157      -5.050   0.529  -4.406  1.00 16.65          
ATOM   1307  CD  LYS   157      -4.866  -0.824  -5.116  1.00 20.06          
ATOM   1308  CE  LYS   157      -5.874  -1.021  -6.242  1.00 20.82          
ATOM   1309  NZ  LYS   157      -5.684  -2.315  -6.929  1.00 22.02          
ATOM   1310  N   CYS   158      -3.739   4.243  -2.827  1.00 13.75          
ATOM   1311  CA  CYS   158      -3.156   5.356  -3.566  1.00 14.35          
ATOM   1312  C   CYS   158      -1.621   5.311  -3.631  1.00 14.98          
ATOM   1313  O   CYS   158      -1.023   5.307  -4.711  1.00 14.87          
ATOM   1314  CB  CYS   158      -3.616   6.689  -2.984  1.00 14.15          
ATOM   1315  SG  CYS   158      -3.126   8.066  -4.038  1.00 15.55          
ATOM   1316  N   GLU   159      -0.978   5.310  -2.470  1.00 15.86          
ATOM   1317  CA  GLU   159       0.481   5.266  -2.428  0.50 15.84          
ATOM   1319  C   GLU   159       0.982   4.032  -3.177  1.00 15.08          
ATOM   1320  O   GLU   159       1.953   4.084  -3.914  1.00 15.49          
ATOM   1321  CB  GLU   159       1.012   5.265  -0.993  0.50 17.34          
ATOM   1323  CG  GLU   159       2.515   5.311  -0.941  0.50 17.77          
ATOM   1325  CD  GLU   159       3.058   5.241   0.470  0.50 17.62          
ATOM   1327  OE1 GLU   159       2.379   4.670   1.363  0.50 14.38          
ATOM   1329  OE2 GLU   159       4.199   5.692   0.660  0.50 17.82          
ATOM   1331  N   GLU   160       0.291   2.937  -2.951  1.00 15.37          
ATOM   1332  CA  GLU   160       0.638   1.647  -3.547  1.00 14.80          
ATOM   1333  C   GLU   160       0.653   1.783  -5.065  1.00 14.79          
ATOM   1334  O   GLU   160       1.565   1.295  -5.748  1.00 16.13          
ATOM   1335  CB  GLU   160      -0.339   0.575  -3.110  1.00 15.38          
ATOM   1336  CG  GLU   160      -0.148  -0.742  -3.858  1.00 18.41          
ATOM   1337  CD  GLU   160      -1.111  -1.800  -3.410  1.00 26.35          
ATOM   1338  OE1 GLU   160      -1.331  -1.927  -2.191  1.00 27.38          
ATOM   1339  OE2 GLU   160      -1.657  -2.506  -4.281  1.00 24.49          
ATOM   1340  N   LEU   161      -0.357   2.445  -5.609  1.00 13.35          
ATOM   1341  CA  LEU   161      -0.394   2.632  -7.052  1.00 13.55          
ATOM   1342  C   LEU   161       0.634   3.644  -7.535  1.00 14.99          
ATOM   1343  O   LEU   161       1.078   3.582  -8.678  1.00 15.14          
ATOM   1344  CB  LEU   161      -1.776   3.054  -7.529  1.00 13.58          
ATOM   1345  CG  LEU   161      -2.859   1.968  -7.501  1.00 12.59          
ATOM   1346  CD1 LEU   161      -4.261   2.606  -7.760  1.00 11.57          
ATOM   1347  CD2 LEU   161      -2.493   0.879  -8.519  1.00 15.39          
ATOM   1348  N   CYS   162       0.980   4.608  -6.686  1.00 13.97          
ATOM   1349  CA  CYS   162       1.921   5.656  -7.057  1.00 12.55          
ATOM   1350  C   CYS   162       3.384   5.218  -6.971  1.00 15.65          
ATOM   1351  O   CYS   162       4.261   5.821  -7.572  1.00 15.97          
ATOM   1352  CB  CYS   162       1.766   6.899  -6.159  1.00 15.52          
ATOM   1353  SG  CYS   162       0.294   7.884  -6.490  1.00 16.10          
ATOM   1354  N   THR   163       3.630   4.153  -6.233  1.00 16.21          
ATOM   1355  CA  THR   163       5.013   3.724  -5.972  1.00 17.89          
ATOM   1356  C   THR   163       5.856   3.255  -7.178  1.00 18.23          
ATOM   1357  O   THR   163       7.018   3.652  -7.302  1.00 17.98          
ATOM   1358  CB  THR   163       5.064   2.702  -4.847  1.00 18.23          
ATOM   1359  OG1 THR   163       4.998   3.426  -3.608  1.00 22.01          
ATOM   1360  CG2 THR   163       6.382   1.899  -4.879  1.00 17.41          
ATOM   1361  N   PRO   164       5.284   2.450  -8.065  1.00 17.02          
ATOM   1362  CA  PRO   164       6.127   1.897  -9.143  1.00 19.65          
ATOM   1363  C   PRO   164       6.726   2.909 -10.091  1.00 19.85          
ATOM   1364  O   PRO   164       7.847   2.704 -10.570  1.00 18.98          
ATOM   1365  CB  PRO   164       5.157   1.011  -9.904  1.00 19.39          
ATOM   1366  CG  PRO   164       4.161   0.622  -8.900  1.00 20.17          
ATOM   1367  CD  PRO   164       3.980   1.782  -8.002  1.00 21.08          
ATOM   1368  N   VAL   165       5.986   3.979 -10.369  1.00 16.55          
ATOM   1369  CA  VAL   165       6.446   5.034 -11.312  1.00 16.75          
ATOM   1370  C   VAL   165       6.278   6.485 -10.829  1.00 15.85          
ATOM   1371  O   VAL   165       7.188   7.296 -10.899  1.00 16.30          
ATOM   1372  CB  VAL   165       5.728   4.918 -12.671  1.00 17.58          
ATOM   1373  CG1 VAL   165       6.127   6.055 -13.617  1.00 19.61          
ATOM   1374  CG2 VAL   165       5.975   3.524 -13.336  1.00 21.70          
ATOM   1375  N   PHE   166       5.088   6.826 -10.353  1.00 14.53          
ATOM   1376  CA  PHE   166       4.813   8.222  -9.994  1.00 13.84          
ATOM   1377  C   PHE   166       5.758   8.832  -8.956  1.00 14.25          
ATOM   1378  O   PHE   166       6.344   9.902  -9.188  1.00 15.70          
ATOM   1379  CB  PHE   166       3.366   8.397  -9.497  1.00 14.83          
ATOM   1380  CG  PHE   166       2.985   9.820  -9.250  1.00 12.77          
ATOM   1381  CD1 PHE   166       3.210  10.403  -8.010  1.00 17.24          
ATOM   1382  CD2 PHE   166       2.383  10.575 -10.217  1.00 13.69          
ATOM   1383  CE1 PHE   166       2.863  11.716  -7.763  1.00 12.35          
ATOM   1384  CE2 PHE   166       2.048  11.898  -9.967  1.00 12.71          
ATOM   1385  CZ  PHE   166       2.291  12.462  -8.740  1.00 13.49          
ATOM   1386  N   ILE   167       5.922   8.122  -7.851  1.00 15.46          
ATOM   1387  CA  ILE   167       6.779   8.600  -6.766  0.50 16.66          
ATOM   1389  C   ILE   167       8.241   8.736  -7.252  1.00 18.06          
ATOM   1390  O   ILE   167       8.842   9.813  -7.114  1.00 18.84          
ATOM   1391  CB  ILE   167       6.604   7.754  -5.478  0.50 17.44          
ATOM   1393  CG1 ILE   167       5.180   7.977  -4.931  0.50 18.61          
ATOM   1395  CG2 ILE   167       7.655   8.122  -4.432  0.50 18.40          
ATOM   1397  CD  ILE   167       4.796   7.152  -3.695  0.50 15.83          
ATOM   1399  N   PRO   168       8.811   7.683  -7.851  1.00 18.19          
ATOM   1400  CA  PRO   168      10.198   7.957  -8.276  1.00 19.94          
ATOM   1401  C   PRO   168      10.346   8.955  -9.417  1.00 20.41          
ATOM   1402  O   PRO   168      11.394   9.583  -9.564  1.00 19.78          
ATOM   1403  CB  PRO   168      10.728   6.586  -8.666  1.00 20.55          
ATOM   1404  CG  PRO   168       9.524   5.722  -8.916  1.00 19.32          
ATOM   1405  CD  PRO   168       8.485   6.246  -7.939  1.00 19.02          
ATOM   1406  N   ALA   169       9.305   9.112 -10.221  1.00 18.62          
ATOM   1407  CA  ALA   169       9.365  10.041 -11.317  1.00 16.51          
ATOM   1408  C   ALA   169       9.327  11.490 -10.866  1.00 17.69          
ATOM   1409  O   ALA   169       9.759  12.355 -11.601  1.00 16.67          
ATOM   1410  CB  ALA   169       8.256   9.775 -12.356  1.00 17.93          
ATOM   1411  N   TRP   170       8.845  11.747  -9.657  1.00 17.60          
ATOM   1412  CA  TRP   170       8.638  13.139  -9.236  1.00 17.00          
ATOM   1413  C   TRP   170       9.300  13.543  -7.934  1.00 16.85          
ATOM   1414  O   TRP   170       9.407  14.719  -7.643  1.00 17.70          
ATOM   1415  CB  TRP   170       7.128  13.488  -9.142  1.00 16.34          
ATOM   1416  CG  TRP   170       6.426  13.415 -10.418  1.00 15.10          
ATOM   1417  CD1 TRP   170       5.588  12.438 -10.824  1.00 12.94          
ATOM   1418  CD2 TRP   170       6.547  14.331 -11.524  1.00 16.27          
ATOM   1419  NE1 TRP   170       5.154  12.697 -12.090  1.00 14.56          
ATOM   1420  CE2 TRP   170       5.715  13.856 -12.541  1.00 15.13          
ATOM   1421  CE3 TRP   170       7.280  15.507 -11.745  1.00 15.24          
ATOM   1422  CZ2 TRP   170       5.611  14.475 -13.772  1.00 13.61          
ATOM   1423  CZ3 TRP   170       7.149  16.133 -12.967  1.00 15.03          
ATOM   1424  CH2 TRP   170       6.332  15.620 -13.963  1.00 17.43          
ATOM   1425  N   ASN   171       9.746  12.565  -7.170  1.00 17.46          
ATOM   1426  CA  ASN   171      10.218  12.843  -5.812  1.00 19.09          
ATOM   1427  C   ASN   171      11.526  13.615  -5.726  1.00 19.06          
ATOM   1428  O   ASN   171      11.820  14.182  -4.689  1.00 20.37          
ATOM   1429  CB  ASN   171      10.194  11.604  -4.936  1.00 22.63          
ATOM   1430  CG  ASN   171      11.202  10.590  -5.323  1.00 24.42          
ATOM   1431  OD1 ASN   171      11.999  10.789  -6.248  1.00 36.79          
ATOM   1432  ND2 ASN   171      11.180   9.459  -4.613  1.00 35.62          
ATOM   1433  N   LYS   172      12.230  13.739  -6.837  1.00 19.75          
ATOM   1434  CA  LYS   172      13.459  14.558  -6.857  1.00 20.54          
ATOM   1435  C   LYS   172      13.169  15.942  -7.421  1.00 20.60          
ATOM   1436  O   LYS   172      13.988  16.843  -7.349  1.00 22.55          
ATOM   1437  CB  LYS   172      14.598  13.904  -7.653  1.00 23.87          
ATOM   1438  CG  LYS   172      15.198  12.743  -6.921  1.00 26.58          
ATOM   1439  CD  LYS   172      16.423  12.208  -7.576  1.00 35.06          
ATOM   1440  N   LYS   173      11.968  16.109  -7.942  1.00 17.50          
ATOM   1441  CA  LYS   173      11.576  17.317  -8.628  1.00 18.36          
ATOM   1442  C   LYS   173      10.464  18.092  -7.888  1.00 17.26          
ATOM   1443  O   LYS   173      10.087  19.194  -8.261  1.00 18.19          
ATOM   1444  CB  LYS   173      11.060  16.969 -10.029  1.00 21.15          
ATOM   1445  CG  LYS   173      12.127  16.399 -10.956  1.00 26.10          
ATOM   1446  CD  LYS   173      11.710  16.488 -12.420  1.00 32.86          
ATOM   1447  CE  LYS   173      10.858  15.354 -12.849  1.00 32.28          
ATOM   1448  NZ  LYS   173      10.488  15.439 -14.330  1.00 21.51          
ATOM   1449  N   ALA   174       9.971  17.457  -6.846  1.00 16.68          
ATOM   1450  CA  ALA   174       8.905  17.984  -6.015  1.00 16.50          
ATOM   1451  C   ALA   174       8.922  17.340  -4.631  1.00 18.34          
ATOM   1452  O   ALA   174       9.595  16.342  -4.390  1.00 18.96          
ATOM   1453  CB  ALA   174       7.528  17.754  -6.696  1.00 16.15          
ATOM   1454  N   HSD   175       8.157  17.928  -3.715  1.00 16.11          
ATOM   1455  CA  HSD   175       8.036  17.358  -2.392  1.00 18.41          
ATOM   1456  C   HSD   175       6.770  16.499  -2.327  1.00 17.62          
ATOM   1457  O   HSD   175       5.648  17.026  -2.436  1.00 18.98          
ATOM   1458  CB  HSD   175       8.004  18.453  -1.331  1.00 20.13          
ATOM   1459  CG  HSD   175       7.691  17.922   0.028  1.00 22.19          
ATOM   1460  ND1 HSD   175       8.525  17.062   0.696  1.00 31.19          
ATOM   1461  CD2 HSD   175       6.614  18.101   0.826  1.00 31.26          
ATOM   1462  CE1 HSD   175       7.978  16.729   1.855  1.00 25.70          
ATOM   1463  NE2 HSD   175       6.815  17.341   1.955  1.00 30.85          
ATOM   1464  N   LEU   176       6.983  15.190  -2.172  1.00 16.79          
ATOM   1465  CA  LEU   176       5.896  14.180  -2.158  1.00 18.20          
ATOM   1466  C   LEU   176       5.692  13.523  -0.821  1.00 20.07          
ATOM   1467  O   LEU   176       6.638  13.110  -0.189  1.00 20.89          
ATOM   1468  CB  LEU   176       6.164  13.049  -3.175  1.00 20.34          
ATOM   1469  CG  LEU   176       5.715  13.199  -4.621  1.00 23.47          
ATOM   1470  CD1 LEU   176       6.129  14.487  -5.259  1.00 21.10          
ATOM   1471  CD2 LEU   176       6.175  11.972  -5.437  1.00 20.24          
ATOM   1472  N   ALA   177       4.441  13.418  -0.385  1.00 16.37          
ATOM   1473  CA  ALA   177       4.172  12.732   0.875  1.00 16.99          
ATOM   1474  C   ALA   177       2.843  11.997   0.849  1.00 17.61          
ATOM   1475  O   ALA   177       1.845  12.589   0.522  1.00 16.61          
ATOM   1476  CB  ALA   177       4.143  13.698   2.032  1.00 16.55          
ATOM   1477  N   ALA   178       2.854  10.723   1.217  1.00 17.95          
ATOM   1478  CA  ALA   178       1.591   9.971   1.292  1.00 18.63          
ATOM   1479  C   ALA   178       0.866  10.420   2.535  1.00 20.19          
ATOM   1480  O   ALA   178       1.502  10.842   3.521  1.00 19.93          
ATOM   1481  CB  ALA   178       1.855   8.441   1.357  1.00 19.99          
ATOM   1482  N   ALA   179      -0.469  10.341   2.470  1.00 19.62          
ATOM   1483  CA  ALA   179      -1.329  10.551   3.617  1.00 20.14          
ATOM   1484  C   ALA   179      -2.306   9.362   3.659  1.00 20.22          
ATOM   1485  O   ALA   179      -3.234   9.265   2.828  1.00 16.76          
ATOM   1486  CB  ALA   179      -2.080  11.844   3.507  1.00 21.17          
ATOM   1487  N   GLY   180      -2.077   8.465   4.610  1.00 19.72          
ATOM   1488  CA  GLY   180      -2.862   7.274   4.715  1.00 20.76          
ATOM   1489  C   GLY   180      -2.749   6.392   3.472  1.00 21.48          
ATOM   1490  O   GLY   180      -1.731   6.386   2.745  1.00 20.45          
ATOM   1491  N   LYS   181      -3.825   5.668   3.210  1.00 19.38          
ATOM   1492  CA  LYS   181      -3.859   4.796   2.063  1.00 18.21          
ATOM   1493  C   LYS   181      -4.534   5.455   0.900  1.00 17.51          
ATOM   1494  O   LYS   181      -4.578   4.886  -0.212  1.00 17.03          
ATOM   1495  CB  LYS   181      -4.597   3.496   2.412  1.00 18.33          
ATOM   1496  CG  LYS   181      -3.850   2.659   3.467  1.00 23.58          
ATOM   1497  CD  LYS   181      -4.536   1.327   3.729  1.00 29.64          
ATOM   1498  CE  LYS   181      -5.862   1.512   4.407  1.00 33.36          
ATOM   1499  NZ  LYS   181      -5.736   2.260   5.718  1.00 39.22          
ATOM   1500  N   GLU   182      -5.033   6.681   1.129  1.00 15.15          
ATOM   1501  CA  GLU   182      -5.871   7.310   0.118  1.00 15.55          
ATOM   1502  C   GLU   182      -5.259   8.469  -0.664  1.00 15.02          
ATOM   1503  O   GLU   182      -5.740   8.796  -1.716  1.00 13.98          
ATOM   1504  CB  GLU   182      -7.172   7.852   0.749  1.00 16.47          
ATOM   1505  CG  GLU   182      -8.010   6.877   1.568  1.00 17.91          
ATOM   1506  CD  GLU   182      -7.452   6.620   2.957  1.00 25.06          
ATOM   1507  OE1 GLU   182      -6.600   7.433   3.394  1.00 20.24          
ATOM   1508  OE2 GLU   182      -7.913   5.645   3.630  1.00 19.14          
ATOM   1509  N   TRP   183      -4.238   9.108  -0.109  1.00 16.23          
ATOM   1510  CA  TRP   183      -3.704  10.330  -0.703  1.00 14.86          
ATOM   1511  C   TRP   183      -2.203  10.335  -0.870  1.00 14.59          
ATOM   1512  O   TRP   183      -1.447   9.756  -0.067  1.00 13.72          
ATOM   1513  CB  TRP   183      -4.024  11.541   0.213  1.00 16.98          
ATOM   1514  CG  TRP   183      -5.484  11.661   0.655  1.00 14.41          
ATOM   1515  CD1 TRP   183      -6.003  11.240   1.804  1.00 18.91          
ATOM   1516  CD2 TRP   183      -6.565  12.271  -0.079  1.00 12.74          
ATOM   1517  NE1 TRP   183      -7.343  11.506   1.837  1.00 16.42          
ATOM   1518  CE2 TRP   183      -7.703  12.175   0.710  1.00 14.73          
ATOM   1519  CE3 TRP   183      -6.659  12.899  -1.314  1.00 15.00          
ATOM   1520  CZ2 TRP   183      -8.948  12.631   0.279  1.00 14.71          
ATOM   1521  CZ3 TRP   183      -7.880  13.390  -1.727  1.00 16.51          
ATOM   1522  CH2 TRP   183      -9.008  13.242  -0.933  1.00 14.68          
ATOM   1523  N   VAL   184      -1.805  11.006  -1.934  1.00 14.55          
ATOM   1524  CA  VAL   184      -0.418  11.413  -2.141  1.00 11.97          
ATOM   1525  C   VAL   184      -0.431  12.919  -2.473  1.00 12.69          
ATOM   1526  O   VAL   184      -0.975  13.353  -3.475  1.00 13.77          
ATOM   1527  CB  VAL   184       0.346  10.614  -3.220  1.00 11.18          
ATOM   1528  CG1 VAL   184       1.775  11.193  -3.375  1.00 13.70          
ATOM   1529  CG2 VAL   184       0.414   9.148  -2.846  1.00 13.85          
ATOM   1530  N   ASP   185       0.164  13.694  -1.586  1.00 13.60          
ATOM   1531  CA  ASP   185       0.232  15.156  -1.711  1.00 14.26          
ATOM   1532  C   ASP   185       1.584  15.576  -2.225  1.00 14.94          
ATOM   1533  O   ASP   185       2.640  15.121  -1.750  1.00 14.91          
ATOM   1534  CB  ASP   185       0.044  15.844  -0.354  1.00 16.97          
ATOM   1535  CG  ASP   185      -1.364  15.688   0.183  1.00 20.18          
ATOM   1536  OD1 ASP   185      -2.325  15.765  -0.611  1.00 18.60          
ATOM   1537  OD2 ASP   185      -1.481  15.453   1.400  1.00 21.67          
ATOM   1538  N   CYS   186       1.528  16.471  -3.177  1.00 13.96          
ATOM   1539  CA  CYS   186       2.751  16.984  -3.810  1.00 14.59          
ATOM   1540  C   CYS   186       2.742  18.500  -3.794  1.00 14.14          
ATOM   1541  O   CYS   186       1.789  19.144  -4.190  1.00 15.20          
ATOM   1542  CB  CYS   186       2.843  16.521  -5.250  1.00 15.50          
ATOM   1543  SG  CYS   186       2.370  14.788  -5.589  1.00 18.41          
ATOM   1544  N   ASN   187       3.875  19.033  -3.374  1.00 16.20          
ATOM   1545  CA  ASN   187       4.110  20.463  -3.367  1.00 16.74          
ATOM   1546  C   ASN   187       5.437  20.721  -4.042  1.00 16.67          
ATOM   1547  O   ASN   187       6.179  19.811  -4.391  1.00 16.69          
ATOM   1548  CB  ASN   187       4.242  21.030  -1.972  1.00 18.61          
ATOM   1549  CG  ASN   187       3.047  20.758  -1.072  1.00 23.57          
ATOM   1550  OD1 ASN   187       3.228  20.166  -0.025  1.00 25.01          
ATOM   1551  ND2 ASN   187       1.843  21.254  -1.434  1.00 22.62          
ATOM   1552  N   ALA   188       5.758  22.007  -4.167  1.00 17.52          
ATOM   1553  CA  ALA   188       7.021  22.398  -4.799  1.00 16.57          
ATOM   1554  C   ALA   188       8.200  21.875  -4.021  1.00 17.44          
ATOM   1555  O   ALA   188       8.181  21.772  -2.789  1.00 15.22          
ATOM   1556  CB  ALA   188       7.104  23.928  -4.938  1.00 17.88          
ATOM   1557  N   LYS   189       9.258  21.535  -4.751  1.00 16.53          
ATOM   1558  CA  LYS   189      10.476  21.084  -4.101  1.00 17.73          
ATOM   1559  C   LYS   189      10.942  22.117  -3.075  1.00 18.45          
ATOM   1560  O   LYS   189      10.948  23.298  -3.332  1.00 19.11          
ATOM   1561  CB  LYS   189      11.590  20.832  -5.145  1.00 19.45          
ATOM   1562  CG  LYS   189      12.815  20.198  -4.592  1.00 27.00          
ATOM   1563  CD  LYS   189      13.835  19.985  -5.710  1.00 35.73          
ATOM   1564  CE  LYS   189      15.022  19.158  -5.243  1.00 40.61          
ATOM   1565  NZ  LYS   189      15.927  18.829  -6.389  1.00 44.36          
END
