
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 ( 1897),  selected  127 , name 2d9w_A
# Molecule2: number of CA atoms  116 (  905),  selected  116 , name T0446.pdb
# PARAMETERS: 2d9w_A.T0446.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      G       9           -
LGA    S     2_A      N      10           -
LGA    S     3_A      A      11           -
LGA    G     4_A      A      12           -
LGA    S     5_A      E      13           -
LGA    S     6_A      V      14           -
LGA    G     7_A      N      15           -
LGA    M     8_A      -       -           -
LGA    G     9_A      L      16           #
LGA    D    10_A      D      17          2.707
LGA    -       -      E      18           -
LGA    -       -      L      19           -
LGA    G    11_A      A      20          4.577
LGA    -       -      Q      21           -
LGA    -       -      E      22           -
LGA    -       -      L      23           -
LGA    -       -      G      24           -
LGA    -       -      P      25           -
LGA    -       -      I      26           -
LGA    -       -      M      27           -
LGA    -       -      G      28           -
LGA    -       -      D      29           -
LGA    -       -      N      30           -
LGA    -       -      E      31           -
LGA    -       -      Q      32           -
LGA    A    12_A      L      33          1.166
LGA    V    13_A      A      34          0.876
LGA    K    14_A      L      35          1.284
LGA    Q    15_A      A      36          1.716
LGA    G    16_A      Y      37          1.970
LGA    F    17_A      R      38          3.471
LGA    L    18_A      -       -           -
LGA    Y    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    Q    21_A      -       -           -
LGA    Q    22_A      -       -           -
LGA    Q    23_A      -       -           -
LGA    Q    24_A      -       -           -
LGA    T    25_A      -       -           -
LGA    F    26_A      -       -           -
LGA    G    27_A      -       -           -
LGA    K    28_A      -       -           -
LGA    K    29_A      -       -           -
LGA    W    30_A      -       -           -
LGA    R    31_A      V      39           #
LGA    R    32_A      I      40          5.758
LGA    -       -      R      41           -
LGA    F    33_A      D      42          2.654
LGA    G    34_A      M      43          0.727
LGA    A    35_A      F      44          1.009
LGA    S    36_A      V      45          1.026
LGA    L    37_A      F      46          0.889
LGA    Y    38_A      T      47          0.761
LGA    G    39_A      N      48          1.416
LGA    G    40_A      -       -           -
LGA    S    41_A      -       -           -
LGA    D    42_A      -       -           -
LGA    C    43_A      -       -           -
LGA    A    44_A      -       -           -
LGA    L    45_A      -       -           -
LGA    A    46_A      K      49          0.898
LGA    R    47_A      R      50          0.744
LGA    L    48_A      L      51          0.675
LGA    E    49_A      I      52          0.844
LGA    L    50_A      L      53          1.588
LGA    Q    51_A      I      54          1.675
LGA    E    52_A      D      55          1.399
LGA    G    53_A      K      56          2.009
LGA    P    54_A      Q      57          1.430
LGA    E    55_A      G      58          2.367
LGA    -       -      V      59           -
LGA    -       -      T      60           -
LGA    K    56_A      G      61           #
LGA    -       -      K      62           -
LGA    P    57_A      K      63          5.230
LGA    R    58_A      -       -           -
LGA    R    59_A      -       -           -
LGA    C    60_A      -       -           -
LGA    E    61_A      -       -           -
LGA    A    62_A      V      64          5.271
LGA    A    63_A      S      65          2.641
LGA    R    64_A      Y      66          2.435
LGA    K    65_A      H      67          2.231
LGA    V    66_A      S      68          2.440
LGA    I    67_A      V      69          1.970
LGA    R    68_A      P      70          1.946
LGA    L    69_A      Y      71          1.893
LGA    S    70_A      K      72          1.627
LGA    D    71_A      A      73          0.565
LGA    C    72_A      I      74          0.443
LGA    L    73_A      T      75          0.323
LGA    R    74_A      H      76          0.764
LGA    V    75_A      F      77          1.399
LGA    A    76_A      E      78          1.918
LGA    E    77_A      V      79          1.594
LGA    A    78_A      E      80          0.912
LGA    G    79_A      T      81          0.951
LGA    G    80_A      A      82          3.135
LGA    E    81_A      G      83          5.839
LGA    A    82_A      T      84           -
LGA    S    83_A      F      85           -
LGA    S    84_A      -       -           -
LGA    P    85_A      D      86          5.376
LGA    R    86_A      M      87          1.074
LGA    D    87_A      -       -           -
LGA    T    88_A      D      88          2.406
LGA    S    89_A      A      89          1.720
LGA    A    90_A      E      90          1.462
LGA    F    91_A      L      91          1.572
LGA    F    92_A      K      92          1.980
LGA    L    93_A      L      93          0.828
LGA    E    94_A      W      94          0.920
LGA    T    95_A      I      95          0.887
LGA    K    96_A      S      96          0.813
LGA    E    97_A      G      97          3.079
LGA    R    98_A      Q      98          2.532
LGA    -       -      K      99           -
LGA    L    99_A      D     100          3.398
LGA    Y   100_A      P     101          2.771
LGA    -       -      L     102           -
LGA    L   101_A      V     103          1.338
LGA    L   102_A      K     104          0.937
LGA    A   103_A      E     105          1.037
LGA    A   104_A      L     106          0.690
LGA    P   105_A      K     107          3.328
LGA    A   106_A      K     108           #
LGA    A   107_A      G     109           #
LGA    E   108_A      T     110          2.955
LGA    -       -      D     111           -
LGA    R   109_A      V     112          1.227
LGA    G   110_A      V     113          0.873
LGA    D   111_A      G     114          0.586
LGA    W   112_A      I     115          0.131
LGA    V   113_A      Q     116          0.774
LGA    Q   114_A      K     117          0.839
LGA    A   115_A      T     118          0.598
LGA    I   116_A      I     119          0.965
LGA    C   117_A      A     120          1.528
LGA    L   118_A      N     121          1.199
LGA    L   119_A      F     122          0.369
LGA    A   120_A      S     123          1.572
LGA    F   121_A      L     124          1.671
LGA    S   122_A      -       -           -
LGA    G   123_A      -       -           -
LGA    P   124_A      -       -           -
LGA    S   125_A      -       -           -
LGA    S   126_A      -       -           -
LGA    G   127_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127  116    5.0     81    2.20     7.41     51.603     3.529

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.596452 * X  +  -0.728378 * Y  +  -0.337210 * Z  +  56.718063
  Y_new =   0.518937 * X  +   0.670447 * Y  +  -0.530289 * Z  +  -8.596026
  Z_new =   0.612332 * X  +   0.141301 * Y  +   0.777871 * Z  +  10.835564 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.179692   -2.961901  [ DEG:    10.2956   -169.7044 ]
  Theta =  -0.659007   -2.482586  [ DEG:   -37.7583   -142.2417 ]
  Phi   =   0.716014   -2.425579  [ DEG:    41.0246   -138.9754 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d9w_A                                        
REMARK     2: T0446.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d9w_A.T0446.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127  116   5.0   81   2.20    7.41  51.603
REMARK  ---------------------------------------------------------- 
MOLECULE 2d9w_A
HEADER    SIGNALING PROTEIN                       13-DEC-05   2D9W              
TITLE     SOLUTION STRUCTURE OF THE PH DOMAIN OF DOCKING PROTEIN 2              
TITLE    2 FROM HUMAN                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DOCKING PROTEIN 2;                                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PH DOMAIN;                                                 
COMPND   5 SYNONYM: DOWNSTREAM OF TYROSINE KINASE 2, P56DOK-2;                  
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: DOK2;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050302-66;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PH DOMAIN, DOCKING PROTEIN 2, STRUCTURAL GENOMICS, NPPSFA,            
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN           
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   13-JUN-06 2D9W    0                                                
JRNL        AUTH   H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,                  
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE PH DOMAIN OF DOCKING               
JRNL        TITL 2 PROTEIN 2 FROM HUMAN                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2D9W A    8   121  UNP    O60496   DOK2_HUMAN       1    114             
SEQRES   1 A  127  GLY SER SER GLY SER SER GLY MET GLY ASP GLY ALA VAL          
SEQRES   2 A  127  LYS GLN GLY PHE LEU TYR LEU GLN GLN GLN GLN THR PHE          
SEQRES   3 A  127  GLY LYS LYS TRP ARG ARG PHE GLY ALA SER LEU TYR GLY          
SEQRES   4 A  127  GLY SER ASP CYS ALA LEU ALA ARG LEU GLU LEU GLN GLU          
SEQRES   5 A  127  GLY PRO GLU LYS PRO ARG ARG CYS GLU ALA ALA ARG LYS          
SEQRES   6 A  127  VAL ILE ARG LEU SER ASP CYS LEU ARG VAL ALA GLU ALA          
SEQRES   7 A  127  GLY GLY GLU ALA SER SER PRO ARG ASP THR SER ALA PHE          
SEQRES   8 A  127  PHE LEU GLU THR LYS GLU ARG LEU TYR LEU LEU ALA ALA          
SEQRES   9 A  127  PRO ALA ALA GLU ARG GLY ASP TRP VAL GLN ALA ILE CYS          
SEQRES  10 A  127  LEU LEU ALA PHE SER GLY PRO SER SER GLY                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      25.692 -21.723  20.240  1.00  0.00           N  
ATOM      2  CA  GLY A   1      26.828 -21.013  20.800  1.00  0.00           C  
ATOM      3  C   GLY A   1      27.088 -21.385  22.247  1.00  0.00           C  
ATOM      4  O   GLY A   1      26.916 -22.539  22.639  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      27.706 -21.245  20.217  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      26.638 -19.952  20.742  1.00  0.00           H  
ATOM      7  H1  GLY A   1      25.320 -21.444  19.378  1.00  0.00           H  
ATOM      8  N   SER A   2      27.505 -20.405  23.042  1.00  0.00           N  
ATOM      9  CA  SER A   2      27.794 -20.636  24.452  1.00  0.00           C  
ATOM     10  C   SER A   2      26.686 -20.068  25.335  1.00  0.00           C  
ATOM     11  O   SER A   2      26.492 -18.854  25.402  1.00  0.00           O  
ATOM     12  CB  SER A   2      29.136 -20.004  24.829  1.00  0.00           C  
ATOM     13  OG  SER A   2      30.217 -20.833  24.437  1.00  0.00           O  
ATOM     14  H   SER A   2      27.622 -19.505  22.670  1.00  0.00           H  
ATOM     15  HA  SER A   2      27.851 -21.702  24.609  1.00  0.00           H  
ATOM     16  HB2 SER A   2      29.232 -19.049  24.336  1.00  0.00           H  
ATOM     17  HB3 SER A   2      29.176 -19.863  25.900  1.00  0.00           H  
ATOM     18  HG  SER A   2      30.658 -21.174  25.218  1.00  0.00           H  
ATOM     19  N   SER A   3      25.962 -20.955  26.009  1.00  0.00           N  
ATOM     20  CA  SER A   3      24.871 -20.544  26.885  1.00  0.00           C  
ATOM     21  C   SER A   3      25.403 -20.105  28.246  1.00  0.00           C  
ATOM     22  O   SER A   3      25.215 -18.962  28.660  1.00  0.00           O  
ATOM     23  CB  SER A   3      23.870 -21.688  27.059  1.00  0.00           C  
ATOM     24  OG  SER A   3      22.623 -21.207  27.531  1.00  0.00           O  
ATOM     25  H   SER A   3      26.165 -21.909  25.914  1.00  0.00           H  
ATOM     26  HA  SER A   3      24.371 -19.707  26.421  1.00  0.00           H  
ATOM     27  HB2 SER A   3      23.717 -22.177  26.110  1.00  0.00           H  
ATOM     28  HB3 SER A   3      24.261 -22.399  27.772  1.00  0.00           H  
ATOM     29  HG  SER A   3      22.554 -21.369  28.475  1.00  0.00           H  
ATOM     30  N   GLY A   4      26.067 -21.026  28.939  1.00  0.00           N  
ATOM     31  CA  GLY A   4      26.616 -20.716  30.247  1.00  0.00           C  
ATOM     32  C   GLY A   4      27.925 -19.957  30.160  1.00  0.00           C  
ATOM     33  O   GLY A   4      27.934 -18.744  29.951  1.00  0.00           O  
ATOM     34  H   GLY A   4      26.186 -21.920  28.559  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      25.900 -20.120  30.793  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      26.784 -21.640  30.781  1.00  0.00           H  
ATOM     37  N   SER A   5      29.034 -20.671  30.325  1.00  0.00           N  
ATOM     38  CA  SER A   5      30.354 -20.056  30.272  1.00  0.00           C  
ATOM     39  C   SER A   5      31.293 -20.863  29.380  1.00  0.00           C  
ATOM     40  O   SER A   5      31.285 -22.094  29.404  1.00  0.00           O  
ATOM     41  CB  SER A   5      30.943 -19.938  31.679  1.00  0.00           C  
ATOM     42  OG  SER A   5      30.426 -18.806  32.355  1.00  0.00           O  
ATOM     43  H   SER A   5      28.961 -21.635  30.490  1.00  0.00           H  
ATOM     44  HA  SER A   5      30.242 -19.067  29.854  1.00  0.00           H  
ATOM     45  HB2 SER A   5      30.697 -20.824  32.245  1.00  0.00           H  
ATOM     46  HB3 SER A   5      32.018 -19.842  31.609  1.00  0.00           H  
ATOM     47  HG  SER A   5      30.219 -18.118  31.717  1.00  0.00           H  
ATOM     48  N   SER A   6      32.103 -20.160  28.595  1.00  0.00           N  
ATOM     49  CA  SER A   6      33.047 -20.811  27.693  1.00  0.00           C  
ATOM     50  C   SER A   6      34.466 -20.740  28.248  1.00  0.00           C  
ATOM     51  O   SER A   6      35.097 -21.766  28.501  1.00  0.00           O  
ATOM     52  CB  SER A   6      32.996 -20.158  26.311  1.00  0.00           C  
ATOM     53  OG  SER A   6      33.464 -21.045  25.310  1.00  0.00           O  
ATOM     54  H   SER A   6      32.064 -19.181  28.622  1.00  0.00           H  
ATOM     55  HA  SER A   6      32.759 -21.848  27.603  1.00  0.00           H  
ATOM     56  HB2 SER A   6      31.977 -19.883  26.082  1.00  0.00           H  
ATOM     57  HB3 SER A   6      33.616 -19.272  26.310  1.00  0.00           H  
ATOM     58  HG  SER A   6      34.423 -21.016  25.280  1.00  0.00           H  
ATOM     59  N   GLY A   7      34.962 -19.521  28.437  1.00  0.00           N  
ATOM     60  CA  GLY A   7      36.303 -19.338  28.960  1.00  0.00           C  
ATOM     61  C   GLY A   7      37.287 -18.901  27.894  1.00  0.00           C  
ATOM     62  O   GLY A   7      37.224 -19.363  26.754  1.00  0.00           O  
ATOM     63  H   GLY A   7      34.413 -18.739  28.217  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      36.275 -18.589  29.737  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      36.641 -20.271  29.386  1.00  0.00           H  
ATOM     66  N   MET A   8      38.200 -18.008  28.263  1.00  0.00           N  
ATOM     67  CA  MET A   8      39.203 -17.509  27.329  1.00  0.00           C  
ATOM     68  C   MET A   8      40.268 -18.566  27.058  1.00  0.00           C  
ATOM     69  O   MET A   8      40.390 -19.542  27.797  1.00  0.00           O  
ATOM     70  CB  MET A   8      39.855 -16.239  27.878  1.00  0.00           C  
ATOM     71  CG  MET A   8      38.911 -15.048  27.940  1.00  0.00           C  
ATOM     72  SD  MET A   8      39.523 -13.732  29.009  1.00  0.00           S  
ATOM     73  CE  MET A   8      38.750 -12.300  28.260  1.00  0.00           C  
ATOM     74  H   MET A   8      38.201 -17.677  29.186  1.00  0.00           H  
ATOM     75  HA  MET A   8      38.701 -17.273  26.401  1.00  0.00           H  
ATOM     76  HB2 MET A   8      40.215 -16.436  28.876  1.00  0.00           H  
ATOM     77  HB3 MET A   8      40.690 -15.975  27.247  1.00  0.00           H  
ATOM     78  HG2 MET A   8      38.787 -14.653  26.942  1.00  0.00           H  
ATOM     79  HG3 MET A   8      37.956 -15.384  28.314  1.00  0.00           H  
ATOM     80  HE1 MET A   8      37.785 -12.132  28.714  1.00  0.00           H  
ATOM     81  HE2 MET A   8      39.376 -11.434  28.412  1.00  0.00           H  
ATOM     82  HE3 MET A   8      38.625 -12.473  27.200  1.00  0.00           H  
ATOM     83  N   GLY A   9      41.038 -18.365  25.992  1.00  0.00           N  
ATOM     84  CA  GLY A   9      42.082 -19.309  25.643  1.00  0.00           C  
ATOM     85  C   GLY A   9      42.648 -19.063  24.259  1.00  0.00           C  
ATOM     86  O   GLY A   9      43.564 -18.257  24.090  1.00  0.00           O  
ATOM     87  H   GLY A   9      40.895 -17.569  25.439  1.00  0.00           H  
ATOM     88  HA2 GLY A   9      42.880 -19.231  26.367  1.00  0.00           H  
ATOM     89  HA3 GLY A   9      41.675 -20.309  25.680  1.00  0.00           H  
ATOM     90  N   ASP A  10      42.105 -19.759  23.267  1.00  0.00           N  
ATOM     91  CA  ASP A  10      42.562 -19.612  21.890  1.00  0.00           C  
ATOM     92  C   ASP A  10      42.344 -18.186  21.395  1.00  0.00           C  
ATOM     93  O   ASP A  10      41.247 -17.825  20.972  1.00  0.00           O  
ATOM     94  CB  ASP A  10      41.829 -20.599  20.979  1.00  0.00           C  
ATOM     95  CG  ASP A  10      40.370 -20.236  20.788  1.00  0.00           C  
ATOM     96  OD1 ASP A  10      39.718 -19.854  21.782  1.00  0.00           O  
ATOM     97  OD2 ASP A  10      39.879 -20.334  19.643  1.00  0.00           O  
ATOM     98  H   ASP A  10      41.378 -20.387  23.466  1.00  0.00           H  
ATOM     99  HA  ASP A  10      43.619 -19.832  21.867  1.00  0.00           H  
ATOM    100  HB2 ASP A  10      42.309 -20.609  20.011  1.00  0.00           H  
ATOM    101  HB3 ASP A  10      41.883 -21.586  21.413  1.00  0.00           H  
ATOM    102  N   GLY A  11      43.399 -17.378  21.451  1.00  0.00           N  
ATOM    103  CA  GLY A  11      43.304 -16.000  21.007  1.00  0.00           C  
ATOM    104  C   GLY A  11      44.030 -15.760  19.698  1.00  0.00           C  
ATOM    105  O   GLY A  11      43.422 -15.356  18.708  1.00  0.00           O  
ATOM    106  H   GLY A  11      44.250 -17.721  21.799  1.00  0.00           H  
ATOM    107  HA2 GLY A  11      42.261 -15.747  20.880  1.00  0.00           H  
ATOM    108  HA3 GLY A  11      43.729 -15.359  21.764  1.00  0.00           H  
ATOM    109  N   ALA A  12      45.335 -16.010  19.694  1.00  0.00           N  
ATOM    110  CA  ALA A  12      46.146 -15.820  18.498  1.00  0.00           C  
ATOM    111  C   ALA A  12      45.496 -16.477  17.285  1.00  0.00           C  
ATOM    112  O   ALA A  12      44.944 -17.574  17.382  1.00  0.00           O  
ATOM    113  CB  ALA A  12      47.546 -16.374  18.715  1.00  0.00           C  
ATOM    114  H   ALA A  12      45.763 -16.331  20.515  1.00  0.00           H  
ATOM    115  HA  ALA A  12      46.229 -14.757  18.317  1.00  0.00           H  
ATOM    116  HB1 ALA A  12      48.088 -16.354  17.781  1.00  0.00           H  
ATOM    117  HB2 ALA A  12      48.062 -15.769  19.445  1.00  0.00           H  
ATOM    118  HB3 ALA A  12      47.478 -17.391  19.071  1.00  0.00           H  
ATOM    119  N   VAL A  13      45.566 -15.801  16.142  1.00  0.00           N  
ATOM    120  CA  VAL A  13      44.986 -16.320  14.910  1.00  0.00           C  
ATOM    121  C   VAL A  13      45.596 -17.667  14.540  1.00  0.00           C  
ATOM    122  O   VAL A  13      44.883 -18.615  14.210  1.00  0.00           O  
ATOM    123  CB  VAL A  13      45.186 -15.339  13.739  1.00  0.00           C  
ATOM    124  CG1 VAL A  13      44.603 -15.914  12.457  1.00  0.00           C  
ATOM    125  CG2 VAL A  13      44.560 -13.991  14.061  1.00  0.00           C  
ATOM    126  H   VAL A  13      46.020 -14.932  16.129  1.00  0.00           H  
ATOM    127  HA  VAL A  13      43.925 -16.448  15.068  1.00  0.00           H  
ATOM    128  HB  VAL A  13      46.246 -15.195  13.593  1.00  0.00           H  
ATOM    129 HG11 VAL A  13      44.209 -15.112  11.850  1.00  0.00           H  
ATOM    130 HG12 VAL A  13      45.377 -16.433  11.910  1.00  0.00           H  
ATOM    131 HG13 VAL A  13      43.809 -16.604  12.700  1.00  0.00           H  
ATOM    132 HG21 VAL A  13      43.573 -14.142  14.472  1.00  0.00           H  
ATOM    133 HG22 VAL A  13      45.174 -13.472  14.783  1.00  0.00           H  
ATOM    134 HG23 VAL A  13      44.489 -13.402  13.159  1.00  0.00           H  
ATOM    135  N   LYS A  14      46.921 -17.746  14.598  1.00  0.00           N  
ATOM    136  CA  LYS A  14      47.629 -18.978  14.271  1.00  0.00           C  
ATOM    137  C   LYS A  14      48.882 -19.129  15.128  1.00  0.00           C  
ATOM    138  O   LYS A  14      49.606 -18.161  15.360  1.00  0.00           O  
ATOM    139  CB  LYS A  14      48.008 -18.995  12.789  1.00  0.00           C  
ATOM    140  CG  LYS A  14      48.074 -20.392  12.194  1.00  0.00           C  
ATOM    141  CD  LYS A  14      48.831 -20.401  10.877  1.00  0.00           C  
ATOM    142  CE  LYS A  14      50.318 -20.638  11.090  1.00  0.00           C  
ATOM    143  NZ  LYS A  14      50.972 -21.195   9.874  1.00  0.00           N  
ATOM    144  H   LYS A  14      47.435 -16.957  14.869  1.00  0.00           H  
ATOM    145  HA  LYS A  14      46.967 -19.806  14.475  1.00  0.00           H  
ATOM    146  HB2 LYS A  14      47.274 -18.426  12.237  1.00  0.00           H  
ATOM    147  HB3 LYS A  14      48.976 -18.531  12.671  1.00  0.00           H  
ATOM    148  HG2 LYS A  14      48.577 -21.046  12.891  1.00  0.00           H  
ATOM    149  HG3 LYS A  14      47.069 -20.750  12.024  1.00  0.00           H  
ATOM    150  HD2 LYS A  14      48.439 -21.190  10.252  1.00  0.00           H  
ATOM    151  HD3 LYS A  14      48.695 -19.448  10.387  1.00  0.00           H  
ATOM    152  HE2 LYS A  14      50.787 -19.699  11.342  1.00  0.00           H  
ATOM    153  HE3 LYS A  14      50.445 -21.333  11.907  1.00  0.00           H  
ATOM    154  HZ1 LYS A  14      50.334 -21.868   9.402  1.00  0.00           H  
ATOM    155  HZ2 LYS A  14      51.848 -21.690  10.134  1.00  0.00           H  
ATOM    156  HZ3 LYS A  14      51.203 -20.429   9.210  1.00  0.00           H  
ATOM    157  N   GLN A  15      49.132 -20.349  15.594  1.00  0.00           N  
ATOM    158  CA  GLN A  15      50.299 -20.624  16.424  1.00  0.00           C  
ATOM    159  C   GLN A  15      51.267 -21.562  15.709  1.00  0.00           C  
ATOM    160  O   GLN A  15      50.860 -22.369  14.873  1.00  0.00           O  
ATOM    161  CB  GLN A  15      49.868 -21.237  17.758  1.00  0.00           C  
ATOM    162  CG  GLN A  15      49.448 -20.206  18.793  1.00  0.00           C  
ATOM    163  CD  GLN A  15      48.498 -20.774  19.830  1.00  0.00           C  
ATOM    164  OE1 GLN A  15      48.917 -21.461  20.762  1.00  0.00           O  
ATOM    165  NE2 GLN A  15      47.212 -20.488  19.673  1.00  0.00           N  
ATOM    166  H   GLN A  15      48.517 -21.080  15.375  1.00  0.00           H  
ATOM    167  HA  GLN A  15      50.800 -19.688  16.613  1.00  0.00           H  
ATOM    168  HB2 GLN A  15      49.035 -21.901  17.583  1.00  0.00           H  
ATOM    169  HB3 GLN A  15      50.693 -21.805  18.163  1.00  0.00           H  
ATOM    170  HG2 GLN A  15      50.330 -19.842  19.298  1.00  0.00           H  
ATOM    171  HG3 GLN A  15      48.959 -19.386  18.288  1.00  0.00           H  
ATOM    172 HE21 GLN A  15      46.951 -19.936  18.905  1.00  0.00           H  
ATOM    173 HE22 GLN A  15      46.575 -20.842  20.327  1.00  0.00           H  
ATOM    174  N   GLY A  16      52.548 -21.450  16.043  1.00  0.00           N  
ATOM    175  CA  GLY A  16      53.553 -22.293  15.424  1.00  0.00           C  
ATOM    176  C   GLY A  16      54.965 -21.880  15.793  1.00  0.00           C  
ATOM    177  O   GLY A  16      55.234 -20.703  16.027  1.00  0.00           O  
ATOM    178  H   GLY A  16      52.813 -20.788  16.716  1.00  0.00           H  
ATOM    179  HA2 GLY A  16      53.394 -23.314  15.737  1.00  0.00           H  
ATOM    180  HA3 GLY A  16      53.443 -22.235  14.350  1.00  0.00           H  
ATOM    181  N   PHE A  17      55.869 -22.853  15.847  1.00  0.00           N  
ATOM    182  CA  PHE A  17      57.260 -22.586  16.194  1.00  0.00           C  
ATOM    183  C   PHE A  17      58.065 -22.205  14.955  1.00  0.00           C  
ATOM    184  O   PHE A  17      58.109 -22.951  13.976  1.00  0.00           O  
ATOM    185  CB  PHE A  17      57.884 -23.810  16.866  1.00  0.00           C  
ATOM    186  CG  PHE A  17      57.213 -24.195  18.153  1.00  0.00           C  
ATOM    187  CD1 PHE A  17      57.202 -23.325  19.231  1.00  0.00           C  
ATOM    188  CD2 PHE A  17      56.594 -25.427  18.285  1.00  0.00           C  
ATOM    189  CE1 PHE A  17      56.584 -23.676  20.417  1.00  0.00           C  
ATOM    190  CE2 PHE A  17      55.974 -25.784  19.468  1.00  0.00           C  
ATOM    191  CZ  PHE A  17      55.971 -24.908  20.537  1.00  0.00           C  
ATOM    192  H   PHE A  17      55.593 -23.773  15.649  1.00  0.00           H  
ATOM    193  HA  PHE A  17      57.274 -21.759  16.886  1.00  0.00           H  
ATOM    194  HB2 PHE A  17      57.820 -24.653  16.194  1.00  0.00           H  
ATOM    195  HB3 PHE A  17      58.922 -23.604  17.079  1.00  0.00           H  
ATOM    196  HD1 PHE A  17      57.683 -22.361  19.140  1.00  0.00           H  
ATOM    197  HD2 PHE A  17      56.596 -26.114  17.451  1.00  0.00           H  
ATOM    198  HE1 PHE A  17      56.584 -22.988  21.249  1.00  0.00           H  
ATOM    199  HE2 PHE A  17      55.495 -26.747  19.559  1.00  0.00           H  
ATOM    200  HZ  PHE A  17      55.488 -25.183  21.461  1.00  0.00           H  
ATOM    201  N   LEU A  18      58.700 -21.040  15.005  1.00  0.00           N  
ATOM    202  CA  LEU A  18      59.504 -20.558  13.887  1.00  0.00           C  
ATOM    203  C   LEU A  18      60.993 -20.670  14.200  1.00  0.00           C  
ATOM    204  O   LEU A  18      61.379 -21.016  15.317  1.00  0.00           O  
ATOM    205  CB  LEU A  18      59.147 -19.106  13.565  1.00  0.00           C  
ATOM    206  CG  LEU A  18      57.843 -18.890  12.795  1.00  0.00           C  
ATOM    207  CD1 LEU A  18      57.475 -17.415  12.772  1.00  0.00           C  
ATOM    208  CD2 LEU A  18      57.963 -19.435  11.379  1.00  0.00           C  
ATOM    209  H   LEU A  18      58.627 -20.489  15.812  1.00  0.00           H  
ATOM    210  HA  LEU A  18      59.281 -21.174  13.029  1.00  0.00           H  
ATOM    211  HB2 LEU A  18      59.073 -18.569  14.498  1.00  0.00           H  
ATOM    212  HB3 LEU A  18      59.953 -18.691  12.975  1.00  0.00           H  
ATOM    213  HG  LEU A  18      57.046 -19.424  13.294  1.00  0.00           H  
ATOM    214 HD11 LEU A  18      58.276 -16.852  12.318  1.00  0.00           H  
ATOM    215 HD12 LEU A  18      57.317 -17.067  13.782  1.00  0.00           H  
ATOM    216 HD13 LEU A  18      56.569 -17.279  12.200  1.00  0.00           H  
ATOM    217 HD21 LEU A  18      58.147 -18.620  10.696  1.00  0.00           H  
ATOM    218 HD22 LEU A  18      57.043 -19.933  11.107  1.00  0.00           H  
ATOM    219 HD23 LEU A  18      58.781 -20.137  11.333  1.00  0.00           H  
ATOM    220  N   TYR A  19      61.825 -20.373  13.207  1.00  0.00           N  
ATOM    221  CA  TYR A  19      63.271 -20.440  13.376  1.00  0.00           C  
ATOM    222  C   TYR A  19      63.938 -19.164  12.873  1.00  0.00           C  
ATOM    223  O   TYR A  19      63.846 -18.825  11.692  1.00  0.00           O  
ATOM    224  CB  TYR A  19      63.836 -21.652  12.633  1.00  0.00           C  
ATOM    225  CG  TYR A  19      62.955 -22.877  12.715  1.00  0.00           C  
ATOM    226  CD1 TYR A  19      62.556 -23.390  13.944  1.00  0.00           C  
ATOM    227  CD2 TYR A  19      62.521 -23.524  11.564  1.00  0.00           C  
ATOM    228  CE1 TYR A  19      61.752 -24.510  14.023  1.00  0.00           C  
ATOM    229  CE2 TYR A  19      61.715 -24.644  11.634  1.00  0.00           C  
ATOM    230  CZ  TYR A  19      61.334 -25.133  12.867  1.00  0.00           C  
ATOM    231  OH  TYR A  19      60.532 -26.248  12.942  1.00  0.00           O  
ATOM    232  H   TYR A  19      61.457 -20.103  12.340  1.00  0.00           H  
ATOM    233  HA  TYR A  19      63.478 -20.549  14.431  1.00  0.00           H  
ATOM    234  HB2 TYR A  19      63.958 -21.401  11.591  1.00  0.00           H  
ATOM    235  HB3 TYR A  19      64.798 -21.906  13.053  1.00  0.00           H  
ATOM    236  HD1 TYR A  19      62.884 -22.898  14.848  1.00  0.00           H  
ATOM    237  HD2 TYR A  19      62.822 -23.139  10.601  1.00  0.00           H  
ATOM    238  HE1 TYR A  19      61.452 -24.892  14.987  1.00  0.00           H  
ATOM    239  HE2 TYR A  19      61.388 -25.132  10.729  1.00  0.00           H  
ATOM    240  HH  TYR A  19      61.000 -27.004  12.579  1.00  0.00           H  
ATOM    241  N   LEU A  20      64.611 -18.459  13.776  1.00  0.00           N  
ATOM    242  CA  LEU A  20      65.295 -17.219  13.425  1.00  0.00           C  
ATOM    243  C   LEU A  20      66.806 -17.376  13.561  1.00  0.00           C  
ATOM    244  O   LEU A  20      67.320 -17.603  14.656  1.00  0.00           O  
ATOM    245  CB  LEU A  20      64.807 -16.076  14.315  1.00  0.00           C  
ATOM    246  CG  LEU A  20      65.598 -14.769  14.223  1.00  0.00           C  
ATOM    247  CD1 LEU A  20      65.861 -14.406  12.770  1.00  0.00           C  
ATOM    248  CD2 LEU A  20      64.854 -13.645  14.929  1.00  0.00           C  
ATOM    249  H   LEU A  20      64.648 -18.779  14.701  1.00  0.00           H  
ATOM    250  HA  LEU A  20      65.060 -16.991  12.397  1.00  0.00           H  
ATOM    251  HB2 LEU A  20      63.784 -15.862  14.046  1.00  0.00           H  
ATOM    252  HB3 LEU A  20      64.845 -16.415  15.340  1.00  0.00           H  
ATOM    253  HG  LEU A  20      66.552 -14.899  14.713  1.00  0.00           H  
ATOM    254 HD11 LEU A  20      64.933 -14.426  12.220  1.00  0.00           H  
ATOM    255 HD12 LEU A  20      66.550 -15.119  12.340  1.00  0.00           H  
ATOM    256 HD13 LEU A  20      66.290 -13.416  12.719  1.00  0.00           H  
ATOM    257 HD21 LEU A  20      63.993 -13.360  14.342  1.00  0.00           H  
ATOM    258 HD22 LEU A  20      65.510 -12.795  15.040  1.00  0.00           H  
ATOM    259 HD23 LEU A  20      64.532 -13.983  15.903  1.00  0.00           H  
ATOM    260  N   GLN A  21      67.512 -17.249  12.441  1.00  0.00           N  
ATOM    261  CA  GLN A  21      68.965 -17.375  12.437  1.00  0.00           C  
ATOM    262  C   GLN A  21      69.612 -16.231  13.211  1.00  0.00           C  
ATOM    263  O   GLN A  21      69.336 -15.059  12.952  1.00  0.00           O  
ATOM    264  CB  GLN A  21      69.492 -17.397  11.001  1.00  0.00           C  
ATOM    265  CG  GLN A  21      70.830 -18.102  10.855  1.00  0.00           C  
ATOM    266  CD  GLN A  21      71.279 -18.207   9.411  1.00  0.00           C  
ATOM    267  OE1 GLN A  21      72.220 -17.532   8.990  1.00  0.00           O  
ATOM    268  NE2 GLN A  21      70.608 -19.056   8.641  1.00  0.00           N  
ATOM    269  H   GLN A  21      67.045 -17.068  11.600  1.00  0.00           H  
ATOM    270  HA  GLN A  21      69.219 -18.307  12.918  1.00  0.00           H  
ATOM    271  HB2 GLN A  21      68.772 -17.902  10.374  1.00  0.00           H  
ATOM    272  HB3 GLN A  21      69.605 -16.379  10.656  1.00  0.00           H  
ATOM    273  HG2 GLN A  21      71.576 -17.550  11.408  1.00  0.00           H  
ATOM    274  HG3 GLN A  21      70.744 -19.098  11.263  1.00  0.00           H  
ATOM    275 HE21 GLN A  21      69.869 -19.559   9.045  1.00  0.00           H  
ATOM    276 HE22 GLN A  21      70.876 -19.143   7.704  1.00  0.00           H  
ATOM    277  N   GLN A  22      70.474 -16.580  14.161  1.00  0.00           N  
ATOM    278  CA  GLN A  22      71.160 -15.581  14.974  1.00  0.00           C  
ATOM    279  C   GLN A  22      72.559 -16.056  15.353  1.00  0.00           C  
ATOM    280  O   GLN A  22      72.970 -17.157  14.989  1.00  0.00           O  
ATOM    281  CB  GLN A  22      70.351 -15.278  16.236  1.00  0.00           C  
ATOM    282  CG  GLN A  22      68.954 -14.751  15.952  1.00  0.00           C  
ATOM    283  CD  GLN A  22      68.425 -13.871  17.068  1.00  0.00           C  
ATOM    284  OE1 GLN A  22      68.193 -14.337  18.184  1.00  0.00           O  
ATOM    285  NE2 GLN A  22      68.228 -12.592  16.771  1.00  0.00           N  
ATOM    286  H   GLN A  22      70.652 -17.529  14.320  1.00  0.00           H  
ATOM    287  HA  GLN A  22      71.245 -14.679  14.387  1.00  0.00           H  
ATOM    288  HB2 GLN A  22      70.261 -16.184  16.817  1.00  0.00           H  
ATOM    289  HB3 GLN A  22      70.880 -14.537  16.818  1.00  0.00           H  
ATOM    290  HG2 GLN A  22      68.979 -14.173  15.041  1.00  0.00           H  
ATOM    291  HG3 GLN A  22      68.286 -15.590  15.826  1.00  0.00           H  
ATOM    292 HE21 GLN A  22      68.433 -12.292  15.860  1.00  0.00           H  
ATOM    293 HE22 GLN A  22      67.886 -12.002  17.473  1.00  0.00           H  
ATOM    294  N   GLN A  23      73.284 -15.216  16.085  1.00  0.00           N  
ATOM    295  CA  GLN A  23      74.638 -15.550  16.511  1.00  0.00           C  
ATOM    296  C   GLN A  23      74.865 -15.149  17.965  1.00  0.00           C  
ATOM    297  O   GLN A  23      74.431 -14.082  18.398  1.00  0.00           O  
ATOM    298  CB  GLN A  23      75.664 -14.857  15.612  1.00  0.00           C  
ATOM    299  CG  GLN A  23      75.291 -13.429  15.252  1.00  0.00           C  
ATOM    300  CD  GLN A  23      76.498 -12.585  14.888  1.00  0.00           C  
ATOM    301  OE1 GLN A  23      76.694 -12.231  13.725  1.00  0.00           O  
ATOM    302  NE2 GLN A  23      77.313 -12.257  15.884  1.00  0.00           N  
ATOM    303  H   GLN A  23      72.901 -14.353  16.342  1.00  0.00           H  
ATOM    304  HA  GLN A  23      74.759 -16.619  16.423  1.00  0.00           H  
ATOM    305  HB2 GLN A  23      76.618 -14.841  16.120  1.00  0.00           H  
ATOM    306  HB3 GLN A  23      75.763 -15.423  14.697  1.00  0.00           H  
ATOM    307  HG2 GLN A  23      74.619 -13.448  14.407  1.00  0.00           H  
ATOM    308  HG3 GLN A  23      74.794 -12.977  16.097  1.00  0.00           H  
ATOM    309 HE21 GLN A  23      77.092 -12.576  16.785  1.00  0.00           H  
ATOM    310 HE22 GLN A  23      78.100 -11.713  15.678  1.00  0.00           H  
ATOM    311  N   GLN A  24      75.547 -16.010  18.712  1.00  0.00           N  
ATOM    312  CA  GLN A  24      75.831 -15.745  20.118  1.00  0.00           C  
ATOM    313  C   GLN A  24      77.313 -15.941  20.420  1.00  0.00           C  
ATOM    314  O   GLN A  24      77.990 -15.023  20.886  1.00  0.00           O  
ATOM    315  CB  GLN A  24      74.991 -16.658  21.010  1.00  0.00           C  
ATOM    316  CG  GLN A  24      75.238 -16.453  22.496  1.00  0.00           C  
ATOM    317  CD  GLN A  24      74.483 -15.263  23.054  1.00  0.00           C  
ATOM    318  OE1 GLN A  24      74.294 -14.257  22.369  1.00  0.00           O  
ATOM    319  NE2 GLN A  24      74.048 -15.370  24.304  1.00  0.00           N  
ATOM    320  H   GLN A  24      75.868 -16.844  18.309  1.00  0.00           H  
ATOM    321  HA  GLN A  24      75.568 -14.717  20.320  1.00  0.00           H  
ATOM    322  HB2 GLN A  24      73.945 -16.474  20.812  1.00  0.00           H  
ATOM    323  HB3 GLN A  24      75.218 -17.687  20.769  1.00  0.00           H  
ATOM    324  HG2 GLN A  24      74.923 -17.340  23.027  1.00  0.00           H  
ATOM    325  HG3 GLN A  24      76.295 -16.298  22.653  1.00  0.00           H  
ATOM    326 HE21 GLN A  24      74.237 -16.200  24.789  1.00  0.00           H  
ATOM    327 HE22 GLN A  24      73.558 -14.615  24.690  1.00  0.00           H  
ATOM    328  N   THR A  25      77.813 -17.144  20.154  1.00  0.00           N  
ATOM    329  CA  THR A  25      79.214 -17.461  20.400  1.00  0.00           C  
ATOM    330  C   THR A  25      80.039 -17.328  19.126  1.00  0.00           C  
ATOM    331  O   THR A  25      81.065 -16.648  19.107  1.00  0.00           O  
ATOM    332  CB  THR A  25      79.377 -18.888  20.957  1.00  0.00           C  
ATOM    333  OG1 THR A  25      78.321 -19.178  21.879  1.00  0.00           O  
ATOM    334  CG2 THR A  25      80.721 -19.046  21.653  1.00  0.00           C  
ATOM    335  H   THR A  25      77.223 -17.834  19.785  1.00  0.00           H  
ATOM    336  HA  THR A  25      79.589 -16.765  21.135  1.00  0.00           H  
ATOM    337  HB  THR A  25      79.329 -19.587  20.135  1.00  0.00           H  
ATOM    338  HG1 THR A  25      78.430 -20.068  22.222  1.00  0.00           H  
ATOM    339 HG21 THR A  25      81.484 -18.542  21.079  1.00  0.00           H  
ATOM    340 HG22 THR A  25      80.964 -20.096  21.730  1.00  0.00           H  
ATOM    341 HG23 THR A  25      80.669 -18.615  22.639  1.00  0.00           H  
ATOM    342  N   PHE A  26      79.584 -17.980  18.061  1.00  0.00           N  
ATOM    343  CA  PHE A  26      80.282 -17.934  16.781  1.00  0.00           C  
ATOM    344  C   PHE A  26      79.433 -18.558  15.676  1.00  0.00           C  
ATOM    345  O   PHE A  26      78.551 -19.373  15.941  1.00  0.00           O  
ATOM    346  CB  PHE A  26      81.623 -18.664  16.881  1.00  0.00           C  
ATOM    347  CG  PHE A  26      81.510 -20.055  17.435  1.00  0.00           C  
ATOM    348  CD1 PHE A  26      80.855 -21.047  16.721  1.00  0.00           C  
ATOM    349  CD2 PHE A  26      82.058 -20.372  18.666  1.00  0.00           C  
ATOM    350  CE1 PHE A  26      80.749 -22.328  17.228  1.00  0.00           C  
ATOM    351  CE2 PHE A  26      81.955 -21.652  19.179  1.00  0.00           C  
ATOM    352  CZ  PHE A  26      81.300 -22.632  18.458  1.00  0.00           C  
ATOM    353  H   PHE A  26      78.760 -18.505  18.138  1.00  0.00           H  
ATOM    354  HA  PHE A  26      80.462 -16.899  16.539  1.00  0.00           H  
ATOM    355  HB2 PHE A  26      82.061 -18.733  15.896  1.00  0.00           H  
ATOM    356  HB3 PHE A  26      82.283 -18.102  17.525  1.00  0.00           H  
ATOM    357  HD1 PHE A  26      80.424 -20.812  15.759  1.00  0.00           H  
ATOM    358  HD2 PHE A  26      82.570 -19.607  19.231  1.00  0.00           H  
ATOM    359  HE1 PHE A  26      80.237 -23.092  16.662  1.00  0.00           H  
ATOM    360  HE2 PHE A  26      82.387 -21.885  20.140  1.00  0.00           H  
ATOM    361  HZ  PHE A  26      81.218 -23.631  18.857  1.00  0.00           H  
ATOM    362  N   GLY A  27      79.706 -18.165  14.436  1.00  0.00           N  
ATOM    363  CA  GLY A  27      78.959 -18.694  13.309  1.00  0.00           C  
ATOM    364  C   GLY A  27      77.483 -18.353  13.381  1.00  0.00           C  
ATOM    365  O   GLY A  27      77.003 -17.848  14.396  1.00  0.00           O  
ATOM    366  H   GLY A  27      80.420 -17.511  14.283  1.00  0.00           H  
ATOM    367  HA2 GLY A  27      79.367 -18.285  12.397  1.00  0.00           H  
ATOM    368  HA3 GLY A  27      79.068 -19.768  13.291  1.00  0.00           H  
ATOM    369  N   LYS A  28      76.761 -18.629  12.300  1.00  0.00           N  
ATOM    370  CA  LYS A  28      75.331 -18.348  12.243  1.00  0.00           C  
ATOM    371  C   LYS A  28      74.520 -19.636  12.342  1.00  0.00           C  
ATOM    372  O   LYS A  28      74.460 -20.419  11.394  1.00  0.00           O  
ATOM    373  CB  LYS A  28      74.986 -17.614  10.946  1.00  0.00           C  
ATOM    374  CG  LYS A  28      75.330 -16.135  10.975  1.00  0.00           C  
ATOM    375  CD  LYS A  28      74.891 -15.435   9.698  1.00  0.00           C  
ATOM    376  CE  LYS A  28      73.436 -14.999   9.774  1.00  0.00           C  
ATOM    377  NZ  LYS A  28      73.293 -13.648  10.383  1.00  0.00           N  
ATOM    378  H   LYS A  28      77.201 -19.031  11.522  1.00  0.00           H  
ATOM    379  HA  LYS A  28      75.083 -17.716  13.082  1.00  0.00           H  
ATOM    380  HB2 LYS A  28      75.527 -18.072  10.132  1.00  0.00           H  
ATOM    381  HB3 LYS A  28      73.925 -17.712  10.763  1.00  0.00           H  
ATOM    382  HG2 LYS A  28      74.830 -15.674  11.814  1.00  0.00           H  
ATOM    383  HG3 LYS A  28      76.400 -16.025  11.085  1.00  0.00           H  
ATOM    384  HD2 LYS A  28      75.509 -14.563   9.546  1.00  0.00           H  
ATOM    385  HD3 LYS A  28      75.012 -16.115   8.867  1.00  0.00           H  
ATOM    386  HE2 LYS A  28      73.028 -14.979   8.775  1.00  0.00           H  
ATOM    387  HE3 LYS A  28      72.890 -15.714  10.371  1.00  0.00           H  
ATOM    388  HZ1 LYS A  28      73.646 -12.921   9.728  1.00  0.00           H  
ATOM    389  HZ2 LYS A  28      73.837 -13.595  11.267  1.00  0.00           H  
ATOM    390  HZ3 LYS A  28      72.292 -13.455  10.593  1.00  0.00           H  
ATOM    391  N   LYS A  29      73.896 -19.850  13.495  1.00  0.00           N  
ATOM    392  CA  LYS A  29      73.086 -21.042  13.717  1.00  0.00           C  
ATOM    393  C   LYS A  29      71.615 -20.675  13.891  1.00  0.00           C  
ATOM    394  O   LYS A  29      71.280 -19.520  14.149  1.00  0.00           O  
ATOM    395  CB  LYS A  29      73.582 -21.798  14.952  1.00  0.00           C  
ATOM    396  CG  LYS A  29      75.020 -22.274  14.836  1.00  0.00           C  
ATOM    397  CD  LYS A  29      75.110 -23.609  14.117  1.00  0.00           C  
ATOM    398  CE  LYS A  29      76.534 -23.907  13.673  1.00  0.00           C  
ATOM    399  NZ  LYS A  29      77.339 -24.522  14.765  1.00  0.00           N  
ATOM    400  H   LYS A  29      73.981 -19.189  14.214  1.00  0.00           H  
ATOM    401  HA  LYS A  29      73.185 -21.677  12.851  1.00  0.00           H  
ATOM    402  HB2 LYS A  29      73.507 -21.150  15.811  1.00  0.00           H  
ATOM    403  HB3 LYS A  29      72.952 -22.662  15.108  1.00  0.00           H  
ATOM    404  HG2 LYS A  29      75.589 -21.540  14.283  1.00  0.00           H  
ATOM    405  HG3 LYS A  29      75.435 -22.380  15.828  1.00  0.00           H  
ATOM    406  HD2 LYS A  29      74.782 -24.391  14.786  1.00  0.00           H  
ATOM    407  HD3 LYS A  29      74.469 -23.584  13.247  1.00  0.00           H  
ATOM    408  HE2 LYS A  29      76.501 -24.589  12.836  1.00  0.00           H  
ATOM    409  HE3 LYS A  29      77.003 -22.984  13.366  1.00  0.00           H  
ATOM    410  HZ1 LYS A  29      78.354 -24.421  14.560  1.00  0.00           H  
ATOM    411  HZ2 LYS A  29      77.112 -25.532  14.851  1.00  0.00           H  
ATOM    412  HZ3 LYS A  29      77.132 -24.052  15.669  1.00  0.00           H  
ATOM    413  N   TRP A  30      70.742 -21.666  13.749  1.00  0.00           N  
ATOM    414  CA  TRP A  30      69.307 -21.447  13.891  1.00  0.00           C  
ATOM    415  C   TRP A  30      68.882 -21.554  15.351  1.00  0.00           C  
ATOM    416  O   TRP A  30      69.564 -22.183  16.160  1.00  0.00           O  
ATOM    417  CB  TRP A  30      68.530 -22.458  13.045  1.00  0.00           C  
ATOM    418  CG  TRP A  30      68.741 -22.285  11.571  1.00  0.00           C  
ATOM    419  CD1 TRP A  30      69.617 -22.975  10.782  1.00  0.00           C  
ATOM    420  CD2 TRP A  30      68.066 -21.362  10.711  1.00  0.00           C  
ATOM    421  NE1 TRP A  30      69.526 -22.537   9.483  1.00  0.00           N  
ATOM    422  CE2 TRP A  30      68.580 -21.548   9.413  1.00  0.00           C  
ATOM    423  CE3 TRP A  30      67.073 -20.398  10.909  1.00  0.00           C  
ATOM    424  CZ2 TRP A  30      68.137 -20.805   8.323  1.00  0.00           C  
ATOM    425  CZ3 TRP A  30      66.635 -19.660   9.826  1.00  0.00           C  
ATOM    426  CH2 TRP A  30      67.165 -19.867   8.546  1.00  0.00           C  
ATOM    427  H   TRP A  30      71.070 -22.567  13.542  1.00  0.00           H  
ATOM    428  HA  TRP A  30      69.088 -20.451  13.536  1.00  0.00           H  
ATOM    429  HB2 TRP A  30      68.841 -23.456  13.312  1.00  0.00           H  
ATOM    430  HB3 TRP A  30      67.474 -22.347  13.246  1.00  0.00           H  
ATOM    431  HD1 TRP A  30      70.279 -23.748  11.142  1.00  0.00           H  
ATOM    432  HE1 TRP A  30      70.052 -22.879   8.730  1.00  0.00           H  
ATOM    433  HE3 TRP A  30      66.652 -20.224  11.888  1.00  0.00           H  
ATOM    434  HZ2 TRP A  30      68.536 -20.953   7.330  1.00  0.00           H  
ATOM    435  HZ3 TRP A  30      65.869 -18.910   9.961  1.00  0.00           H  
ATOM    436  HH2 TRP A  30      66.793 -19.269   7.729  1.00  0.00           H  
ATOM    437  N   ARG A  31      67.752 -20.938  15.681  1.00  0.00           N  
ATOM    438  CA  ARG A  31      67.238 -20.964  17.045  1.00  0.00           C  
ATOM    439  C   ARG A  31      65.714 -20.883  17.054  1.00  0.00           C  
ATOM    440  O   ARG A  31      65.129 -19.957  16.492  1.00  0.00           O  
ATOM    441  CB  ARG A  31      67.825 -19.807  17.856  1.00  0.00           C  
ATOM    442  CG  ARG A  31      69.270 -20.028  18.273  1.00  0.00           C  
ATOM    443  CD  ARG A  31      69.690 -19.054  19.364  1.00  0.00           C  
ATOM    444  NE  ARG A  31      71.119 -19.137  19.650  1.00  0.00           N  
ATOM    445  CZ  ARG A  31      71.659 -20.055  20.445  1.00  0.00           C  
ATOM    446  NH1 ARG A  31      70.891 -20.964  21.029  1.00  0.00           N  
ATOM    447  NH2 ARG A  31      72.969 -20.064  20.656  1.00  0.00           N  
ATOM    448  H   ARG A  31      67.253 -20.453  14.991  1.00  0.00           H  
ATOM    449  HA  ARG A  31      67.540 -21.897  17.495  1.00  0.00           H  
ATOM    450  HB2 ARG A  31      67.779 -18.907  17.262  1.00  0.00           H  
ATOM    451  HB3 ARG A  31      67.233 -19.672  18.748  1.00  0.00           H  
ATOM    452  HG2 ARG A  31      69.377 -21.036  18.645  1.00  0.00           H  
ATOM    453  HG3 ARG A  31      69.908 -19.889  17.414  1.00  0.00           H  
ATOM    454  HD2 ARG A  31      69.454 -18.052  19.043  1.00  0.00           H  
ATOM    455  HD3 ARG A  31      69.138 -19.284  20.264  1.00  0.00           H  
ATOM    456  HE  ARG A  31      71.705 -18.475  19.229  1.00  0.00           H  
ATOM    457 HH11 ARG A  31      69.903 -20.960  20.870  1.00  0.00           H  
ATOM    458 HH12 ARG A  31      71.299 -21.655  21.627  1.00  0.00           H  
ATOM    459 HH21 ARG A  31      73.550 -19.381  20.218  1.00  0.00           H  
ATOM    460 HH22 ARG A  31      73.373 -20.755  21.254  1.00  0.00           H  
ATOM    461  N   ARG A  32      65.079 -21.860  17.692  1.00  0.00           N  
ATOM    462  CA  ARG A  32      63.623 -21.901  17.771  1.00  0.00           C  
ATOM    463  C   ARG A  32      63.105 -20.872  18.772  1.00  0.00           C  
ATOM    464  O   ARG A  32      63.651 -20.726  19.866  1.00  0.00           O  
ATOM    465  CB  ARG A  32      63.152 -23.300  18.170  1.00  0.00           C  
ATOM    466  CG  ARG A  32      61.719 -23.600  17.762  1.00  0.00           C  
ATOM    467  CD  ARG A  32      61.346 -25.044  18.056  1.00  0.00           C  
ATOM    468  NE  ARG A  32      62.144 -25.985  17.276  1.00  0.00           N  
ATOM    469  CZ  ARG A  32      61.783 -27.243  17.047  1.00  0.00           C  
ATOM    470  NH1 ARG A  32      60.643 -27.708  17.538  1.00  0.00           N  
ATOM    471  NH2 ARG A  32      62.564 -28.039  16.327  1.00  0.00           N  
ATOM    472  H   ARG A  32      65.601 -22.571  18.119  1.00  0.00           H  
ATOM    473  HA  ARG A  32      63.231 -21.663  16.794  1.00  0.00           H  
ATOM    474  HB2 ARG A  32      63.796 -24.031  17.704  1.00  0.00           H  
ATOM    475  HB3 ARG A  32      63.226 -23.399  19.243  1.00  0.00           H  
ATOM    476  HG2 ARG A  32      61.055 -22.949  18.311  1.00  0.00           H  
ATOM    477  HG3 ARG A  32      61.610 -23.417  16.703  1.00  0.00           H  
ATOM    478  HD2 ARG A  32      61.506 -25.236  19.106  1.00  0.00           H  
ATOM    479  HD3 ARG A  32      60.302 -25.188  17.819  1.00  0.00           H  
ATOM    480  HE  ARG A  32      62.991 -25.662  16.904  1.00  0.00           H  
ATOM    481 HH11 ARG A  32      60.052 -27.110  18.080  1.00  0.00           H  
ATOM    482 HH12 ARG A  32      60.371 -28.655  17.364  1.00  0.00           H  
ATOM    483 HH21 ARG A  32      63.424 -27.692  15.956  1.00  0.00           H  
ATOM    484 HH22 ARG A  32      62.291 -28.985  16.157  1.00  0.00           H  
ATOM    485  N   PHE A  33      62.049 -20.163  18.390  1.00  0.00           N  
ATOM    486  CA  PHE A  33      61.457 -19.147  19.254  1.00  0.00           C  
ATOM    487  C   PHE A  33      59.935 -19.164  19.149  1.00  0.00           C  
ATOM    488  O   PHE A  33      59.371 -18.900  18.088  1.00  0.00           O  
ATOM    489  CB  PHE A  33      61.990 -17.761  18.884  1.00  0.00           C  
ATOM    490  CG  PHE A  33      63.487 -17.661  18.935  1.00  0.00           C  
ATOM    491  CD1 PHE A  33      64.176 -17.964  20.098  1.00  0.00           C  
ATOM    492  CD2 PHE A  33      64.206 -17.263  17.818  1.00  0.00           C  
ATOM    493  CE1 PHE A  33      65.554 -17.873  20.147  1.00  0.00           C  
ATOM    494  CE2 PHE A  33      65.585 -17.172  17.863  1.00  0.00           C  
ATOM    495  CZ  PHE A  33      66.259 -17.475  19.028  1.00  0.00           C  
ATOM    496  H   PHE A  33      61.657 -20.325  17.506  1.00  0.00           H  
ATOM    497  HA  PHE A  33      61.738 -19.373  20.270  1.00  0.00           H  
ATOM    498  HB2 PHE A  33      61.675 -17.517  17.881  1.00  0.00           H  
ATOM    499  HB3 PHE A  33      61.584 -17.033  19.571  1.00  0.00           H  
ATOM    500  HD1 PHE A  33      63.626 -18.275  20.975  1.00  0.00           H  
ATOM    501  HD2 PHE A  33      63.679 -17.024  16.906  1.00  0.00           H  
ATOM    502  HE1 PHE A  33      66.079 -18.112  21.062  1.00  0.00           H  
ATOM    503  HE2 PHE A  33      66.133 -16.860  16.986  1.00  0.00           H  
ATOM    504  HZ  PHE A  33      67.336 -17.405  19.065  1.00  0.00           H  
ATOM    505  N   GLY A  34      59.275 -19.477  20.260  1.00  0.00           N  
ATOM    506  CA  GLY A  34      57.824 -19.524  20.272  1.00  0.00           C  
ATOM    507  C   GLY A  34      57.200 -18.352  19.541  1.00  0.00           C  
ATOM    508  O   GLY A  34      57.270 -17.215  20.003  1.00  0.00           O  
ATOM    509  H   GLY A  34      59.777 -19.678  21.077  1.00  0.00           H  
ATOM    510  HA2 GLY A  34      57.500 -20.441  19.805  1.00  0.00           H  
ATOM    511  HA3 GLY A  34      57.484 -19.515  21.298  1.00  0.00           H  
ATOM    512  N   ALA A  35      56.588 -18.632  18.394  1.00  0.00           N  
ATOM    513  CA  ALA A  35      55.949 -17.592  17.597  1.00  0.00           C  
ATOM    514  C   ALA A  35      54.439 -17.589  17.808  1.00  0.00           C  
ATOM    515  O   ALA A  35      53.832 -18.636  18.030  1.00  0.00           O  
ATOM    516  CB  ALA A  35      56.279 -17.780  16.123  1.00  0.00           C  
ATOM    517  H   ALA A  35      56.566 -19.559  18.078  1.00  0.00           H  
ATOM    518  HA  ALA A  35      56.349 -16.638  17.911  1.00  0.00           H  
ATOM    519  HB1 ALA A  35      56.895 -18.658  16.002  1.00  0.00           H  
ATOM    520  HB2 ALA A  35      55.363 -17.902  15.563  1.00  0.00           H  
ATOM    521  HB3 ALA A  35      56.810 -16.913  15.760  1.00  0.00           H  
ATOM    522  N   SER A  36      53.838 -16.405  17.737  1.00  0.00           N  
ATOM    523  CA  SER A  36      52.400 -16.266  17.925  1.00  0.00           C  
ATOM    524  C   SER A  36      51.834 -15.185  17.009  1.00  0.00           C  
ATOM    525  O   SER A  36      52.287 -14.040  17.028  1.00  0.00           O  
ATOM    526  CB  SER A  36      52.084 -15.931  19.384  1.00  0.00           C  
ATOM    527  OG  SER A  36      52.649 -16.890  20.261  1.00  0.00           O  
ATOM    528  H   SER A  36      54.377 -15.607  17.556  1.00  0.00           H  
ATOM    529  HA  SER A  36      51.939 -17.210  17.674  1.00  0.00           H  
ATOM    530  HB2 SER A  36      52.489 -14.960  19.623  1.00  0.00           H  
ATOM    531  HB3 SER A  36      51.013 -15.918  19.523  1.00  0.00           H  
ATOM    532  HG  SER A  36      53.602 -16.788  20.276  1.00  0.00           H  
ATOM    533  N   LEU A  37      50.842 -15.556  16.208  1.00  0.00           N  
ATOM    534  CA  LEU A  37      50.213 -14.619  15.283  1.00  0.00           C  
ATOM    535  C   LEU A  37      49.006 -13.944  15.928  1.00  0.00           C  
ATOM    536  O   LEU A  37      48.049 -14.610  16.325  1.00  0.00           O  
ATOM    537  CB  LEU A  37      49.784 -15.343  14.006  1.00  0.00           C  
ATOM    538  CG  LEU A  37      49.670 -14.477  12.751  1.00  0.00           C  
ATOM    539  CD1 LEU A  37      51.038 -13.962  12.331  1.00  0.00           C  
ATOM    540  CD2 LEU A  37      49.024 -15.262  11.618  1.00  0.00           C  
ATOM    541  H   LEU A  37      50.524 -16.483  16.238  1.00  0.00           H  
ATOM    542  HA  LEU A  37      50.942 -13.863  15.032  1.00  0.00           H  
ATOM    543  HB2 LEU A  37      50.507 -16.119  13.807  1.00  0.00           H  
ATOM    544  HB3 LEU A  37      48.818 -15.791  14.189  1.00  0.00           H  
ATOM    545  HG  LEU A  37      49.044 -13.622  12.966  1.00  0.00           H  
ATOM    546 HD11 LEU A  37      51.783 -14.717  12.529  1.00  0.00           H  
ATOM    547 HD12 LEU A  37      51.273 -13.069  12.891  1.00  0.00           H  
ATOM    548 HD13 LEU A  37      51.027 -13.731  11.275  1.00  0.00           H  
ATOM    549 HD21 LEU A  37      47.956 -15.303  11.772  1.00  0.00           H  
ATOM    550 HD22 LEU A  37      49.424 -16.266  11.602  1.00  0.00           H  
ATOM    551 HD23 LEU A  37      49.233 -14.775  10.677  1.00  0.00           H  
ATOM    552  N   TYR A  38      49.059 -12.621  16.029  1.00  0.00           N  
ATOM    553  CA  TYR A  38      47.971 -11.856  16.627  1.00  0.00           C  
ATOM    554  C   TYR A  38      47.420 -10.831  15.640  1.00  0.00           C  
ATOM    555  O   TYR A  38      48.109 -10.416  14.709  1.00  0.00           O  
ATOM    556  CB  TYR A  38      48.451 -11.152  17.896  1.00  0.00           C  
ATOM    557  CG  TYR A  38      48.939 -12.100  18.967  1.00  0.00           C  
ATOM    558  CD1 TYR A  38      48.045 -12.883  19.688  1.00  0.00           C  
ATOM    559  CD2 TYR A  38      50.292 -12.214  19.259  1.00  0.00           C  
ATOM    560  CE1 TYR A  38      48.485 -13.751  20.669  1.00  0.00           C  
ATOM    561  CE2 TYR A  38      50.742 -13.080  20.237  1.00  0.00           C  
ATOM    562  CZ  TYR A  38      49.835 -13.846  20.939  1.00  0.00           C  
ATOM    563  OH  TYR A  38      50.279 -14.709  21.914  1.00  0.00           O  
ATOM    564  H   TYR A  38      49.849 -12.147  15.695  1.00  0.00           H  
ATOM    565  HA  TYR A  38      47.183 -12.549  16.886  1.00  0.00           H  
ATOM    566  HB2 TYR A  38      49.266 -10.489  17.645  1.00  0.00           H  
ATOM    567  HB3 TYR A  38      47.638 -10.574  18.309  1.00  0.00           H  
ATOM    568  HD1 TYR A  38      46.989 -12.806  19.474  1.00  0.00           H  
ATOM    569  HD2 TYR A  38      51.000 -11.612  18.708  1.00  0.00           H  
ATOM    570  HE1 TYR A  38      47.776 -14.351  21.219  1.00  0.00           H  
ATOM    571  HE2 TYR A  38      51.798 -13.154  20.450  1.00  0.00           H  
ATOM    572  HH  TYR A  38      50.994 -15.246  21.566  1.00  0.00           H  
ATOM    573  N   GLY A  39      46.171 -10.426  15.852  1.00  0.00           N  
ATOM    574  CA  GLY A  39      45.547  -9.453  14.975  1.00  0.00           C  
ATOM    575  C   GLY A  39      44.057  -9.680  14.824  1.00  0.00           C  
ATOM    576  O   GLY A  39      43.422 -10.277  15.692  1.00  0.00           O  
ATOM    577  H   GLY A  39      45.670 -10.792  16.610  1.00  0.00           H  
ATOM    578  HA2 GLY A  39      45.713  -8.464  15.377  1.00  0.00           H  
ATOM    579  HA3 GLY A  39      46.010  -9.515  14.000  1.00  0.00           H  
ATOM    580  N   GLY A  40      43.495  -9.199  13.719  1.00  0.00           N  
ATOM    581  CA  GLY A  40      42.073  -9.361  13.478  1.00  0.00           C  
ATOM    582  C   GLY A  40      41.225  -8.610  14.487  1.00  0.00           C  
ATOM    583  O   GLY A  40      40.460  -9.215  15.236  1.00  0.00           O  
ATOM    584  H   GLY A  40      44.050  -8.731  13.061  1.00  0.00           H  
ATOM    585  HA2 GLY A  40      41.843  -8.998  12.488  1.00  0.00           H  
ATOM    586  HA3 GLY A  40      41.829 -10.412  13.532  1.00  0.00           H  
ATOM    587  N   SER A  41      41.364  -7.289  14.507  1.00  0.00           N  
ATOM    588  CA  SER A  41      40.609  -6.454  15.434  1.00  0.00           C  
ATOM    589  C   SER A  41      40.337  -5.079  14.831  1.00  0.00           C  
ATOM    590  O   SER A  41      40.808  -4.765  13.737  1.00  0.00           O  
ATOM    591  CB  SER A  41      41.370  -6.304  16.753  1.00  0.00           C  
ATOM    592  OG  SER A  41      41.150  -7.419  17.600  1.00  0.00           O  
ATOM    593  H   SER A  41      41.991  -6.865  13.884  1.00  0.00           H  
ATOM    594  HA  SER A  41      39.665  -6.943  15.626  1.00  0.00           H  
ATOM    595  HB2 SER A  41      42.427  -6.226  16.548  1.00  0.00           H  
ATOM    596  HB3 SER A  41      41.034  -5.410  17.259  1.00  0.00           H  
ATOM    597  HG  SER A  41      41.744  -8.130  17.353  1.00  0.00           H  
ATOM    598  N   ASP A  42      39.575  -4.265  15.551  1.00  0.00           N  
ATOM    599  CA  ASP A  42      39.240  -2.923  15.089  1.00  0.00           C  
ATOM    600  C   ASP A  42      40.400  -1.961  15.325  1.00  0.00           C  
ATOM    601  O   ASP A  42      40.873  -1.303  14.397  1.00  0.00           O  
ATOM    602  CB  ASP A  42      37.987  -2.413  15.801  1.00  0.00           C  
ATOM    603  CG  ASP A  42      36.716  -3.040  15.260  1.00  0.00           C  
ATOM    604  OD1 ASP A  42      36.230  -2.581  14.205  1.00  0.00           O  
ATOM    605  OD2 ASP A  42      36.210  -3.991  15.889  1.00  0.00           O  
ATOM    606  H   ASP A  42      39.229  -4.573  16.415  1.00  0.00           H  
ATOM    607  HA  ASP A  42      39.043  -2.976  14.029  1.00  0.00           H  
ATOM    608  HB2 ASP A  42      38.058  -2.645  16.854  1.00  0.00           H  
ATOM    609  HB3 ASP A  42      37.919  -1.342  15.676  1.00  0.00           H  
ATOM    610  N   CYS A  43      40.854  -1.885  16.571  1.00  0.00           N  
ATOM    611  CA  CYS A  43      41.959  -1.002  16.929  1.00  0.00           C  
ATOM    612  C   CYS A  43      43.275  -1.771  16.976  1.00  0.00           C  
ATOM    613  O   CYS A  43      44.265  -1.364  16.367  1.00  0.00           O  
ATOM    614  CB  CYS A  43      41.692  -0.340  18.281  1.00  0.00           C  
ATOM    615  SG  CYS A  43      42.945   0.867  18.772  1.00  0.00           S  
ATOM    616  H   CYS A  43      40.437  -2.434  17.267  1.00  0.00           H  
ATOM    617  HA  CYS A  43      42.030  -0.237  16.171  1.00  0.00           H  
ATOM    618  HB2 CYS A  43      40.742   0.172  18.242  1.00  0.00           H  
ATOM    619  HB3 CYS A  43      41.651  -1.102  19.045  1.00  0.00           H  
ATOM    620  HG  CYS A  43      44.081   0.543  18.175  1.00  0.00           H  
ATOM    621  N   ALA A  44      43.280  -2.881  17.705  1.00  0.00           N  
ATOM    622  CA  ALA A  44      44.475  -3.707  17.832  1.00  0.00           C  
ATOM    623  C   ALA A  44      44.992  -4.138  16.464  1.00  0.00           C  
ATOM    624  O   ALA A  44      44.232  -4.626  15.626  1.00  0.00           O  
ATOM    625  CB  ALA A  44      44.186  -4.925  18.697  1.00  0.00           C  
ATOM    626  H   ALA A  44      42.460  -3.153  18.168  1.00  0.00           H  
ATOM    627  HA  ALA A  44      45.236  -3.118  18.324  1.00  0.00           H  
ATOM    628  HB1 ALA A  44      44.962  -5.662  18.548  1.00  0.00           H  
ATOM    629  HB2 ALA A  44      44.162  -4.631  19.735  1.00  0.00           H  
ATOM    630  HB3 ALA A  44      43.231  -5.345  18.418  1.00  0.00           H  
ATOM    631  N   LEU A  45      46.289  -3.953  16.241  1.00  0.00           N  
ATOM    632  CA  LEU A  45      46.908  -4.323  14.973  1.00  0.00           C  
ATOM    633  C   LEU A  45      47.579  -5.688  15.072  1.00  0.00           C  
ATOM    634  O   LEU A  45      47.734  -6.237  16.162  1.00  0.00           O  
ATOM    635  CB  LEU A  45      47.934  -3.266  14.558  1.00  0.00           C  
ATOM    636  CG  LEU A  45      48.654  -2.545  15.697  1.00  0.00           C  
ATOM    637  CD1 LEU A  45      49.996  -2.007  15.226  1.00  0.00           C  
ATOM    638  CD2 LEU A  45      47.789  -1.419  16.246  1.00  0.00           C  
ATOM    639  H   LEU A  45      46.844  -3.558  16.945  1.00  0.00           H  
ATOM    640  HA  LEU A  45      46.130  -4.369  14.226  1.00  0.00           H  
ATOM    641  HB2 LEU A  45      48.682  -3.754  13.950  1.00  0.00           H  
ATOM    642  HB3 LEU A  45      47.421  -2.523  13.965  1.00  0.00           H  
ATOM    643  HG  LEU A  45      48.840  -3.246  16.499  1.00  0.00           H  
ATOM    644 HD11 LEU A  45      50.789  -2.631  15.609  1.00  0.00           H  
ATOM    645 HD12 LEU A  45      50.127  -0.997  15.587  1.00  0.00           H  
ATOM    646 HD13 LEU A  45      50.025  -2.009  14.146  1.00  0.00           H  
ATOM    647 HD21 LEU A  45      47.745  -1.492  17.323  1.00  0.00           H  
ATOM    648 HD22 LEU A  45      46.792  -1.501  15.839  1.00  0.00           H  
ATOM    649 HD23 LEU A  45      48.216  -0.468  15.967  1.00  0.00           H  
ATOM    650  N   ALA A  46      47.976  -6.231  13.926  1.00  0.00           N  
ATOM    651  CA  ALA A  46      48.634  -7.532  13.884  1.00  0.00           C  
ATOM    652  C   ALA A  46      50.126  -7.402  14.171  1.00  0.00           C  
ATOM    653  O   ALA A  46      50.783  -6.481  13.684  1.00  0.00           O  
ATOM    654  CB  ALA A  46      48.410  -8.192  12.532  1.00  0.00           C  
ATOM    655  H   ALA A  46      47.824  -5.745  13.089  1.00  0.00           H  
ATOM    656  HA  ALA A  46      48.184  -8.157  14.641  1.00  0.00           H  
ATOM    657  HB1 ALA A  46      49.161  -7.848  11.835  1.00  0.00           H  
ATOM    658  HB2 ALA A  46      48.482  -9.264  12.639  1.00  0.00           H  
ATOM    659  HB3 ALA A  46      47.430  -7.932  12.161  1.00  0.00           H  
ATOM    660  N   ARG A  47      50.653  -8.327  14.965  1.00  0.00           N  
ATOM    661  CA  ARG A  47      52.068  -8.315  15.318  1.00  0.00           C  
ATOM    662  C   ARG A  47      52.552  -9.717  15.676  1.00  0.00           C  
ATOM    663  O   ARG A  47      51.805 -10.518  16.240  1.00  0.00           O  
ATOM    664  CB  ARG A  47      52.313  -7.364  16.492  1.00  0.00           C  
ATOM    665  CG  ARG A  47      51.661  -7.816  17.788  1.00  0.00           C  
ATOM    666  CD  ARG A  47      52.221  -7.065  18.986  1.00  0.00           C  
ATOM    667  NE  ARG A  47      51.686  -5.708  19.079  1.00  0.00           N  
ATOM    668  CZ  ARG A  47      50.427  -5.435  19.403  1.00  0.00           C  
ATOM    669  NH1 ARG A  47      49.578  -6.420  19.665  1.00  0.00           N  
ATOM    670  NH2 ARG A  47      50.015  -4.176  19.469  1.00  0.00           N  
ATOM    671  H   ARG A  47      50.077  -9.036  15.322  1.00  0.00           H  
ATOM    672  HA  ARG A  47      52.620  -7.963  14.461  1.00  0.00           H  
ATOM    673  HB2 ARG A  47      53.378  -7.285  16.659  1.00  0.00           H  
ATOM    674  HB3 ARG A  47      51.923  -6.390  16.238  1.00  0.00           H  
ATOM    675  HG2 ARG A  47      50.598  -7.634  17.728  1.00  0.00           H  
ATOM    676  HG3 ARG A  47      51.840  -8.872  17.921  1.00  0.00           H  
ATOM    677  HD2 ARG A  47      51.966  -7.605  19.885  1.00  0.00           H  
ATOM    678  HD3 ARG A  47      53.295  -7.013  18.890  1.00  0.00           H  
ATOM    679  HE  ARG A  47      52.296  -4.966  18.891  1.00  0.00           H  
ATOM    680 HH11 ARG A  47      49.886  -7.370  19.618  1.00  0.00           H  
ATOM    681 HH12 ARG A  47      48.631  -6.212  19.909  1.00  0.00           H  
ATOM    682 HH21 ARG A  47      50.652  -3.431  19.273  1.00  0.00           H  
ATOM    683 HH22 ARG A  47      49.068  -3.972  19.713  1.00  0.00           H  
ATOM    684  N   LEU A  48      53.804 -10.008  15.342  1.00  0.00           N  
ATOM    685  CA  LEU A  48      54.388 -11.314  15.628  1.00  0.00           C  
ATOM    686  C   LEU A  48      55.271 -11.256  16.871  1.00  0.00           C  
ATOM    687  O   LEU A  48      56.235 -10.494  16.924  1.00  0.00           O  
ATOM    688  CB  LEU A  48      55.205 -11.801  14.431  1.00  0.00           C  
ATOM    689  CG  LEU A  48      55.279 -13.317  14.240  1.00  0.00           C  
ATOM    690  CD1 LEU A  48      53.909 -13.879  13.898  1.00  0.00           C  
ATOM    691  CD2 LEU A  48      56.287 -13.670  13.158  1.00  0.00           C  
ATOM    692  H   LEU A  48      54.350  -9.329  14.895  1.00  0.00           H  
ATOM    693  HA  LEU A  48      53.579 -12.005  15.808  1.00  0.00           H  
ATOM    694  HB2 LEU A  48      54.770 -11.377  13.538  1.00  0.00           H  
ATOM    695  HB3 LEU A  48      56.215 -11.432  14.547  1.00  0.00           H  
ATOM    696  HG  LEU A  48      55.605 -13.774  15.164  1.00  0.00           H  
ATOM    697 HD11 LEU A  48      53.896 -14.196  12.867  1.00  0.00           H  
ATOM    698 HD12 LEU A  48      53.158 -13.117  14.050  1.00  0.00           H  
ATOM    699 HD13 LEU A  48      53.696 -14.724  14.537  1.00  0.00           H  
ATOM    700 HD21 LEU A  48      57.281 -13.414  13.495  1.00  0.00           H  
ATOM    701 HD22 LEU A  48      56.060 -13.116  12.259  1.00  0.00           H  
ATOM    702 HD23 LEU A  48      56.238 -14.728  12.951  1.00  0.00           H  
ATOM    703  N   GLU A  49      54.935 -12.069  17.868  1.00  0.00           N  
ATOM    704  CA  GLU A  49      55.698 -12.110  19.109  1.00  0.00           C  
ATOM    705  C   GLU A  49      56.660 -13.295  19.117  1.00  0.00           C  
ATOM    706  O   GLU A  49      56.391 -14.332  18.510  1.00  0.00           O  
ATOM    707  CB  GLU A  49      54.756 -12.197  20.311  1.00  0.00           C  
ATOM    708  CG  GLU A  49      54.070 -10.882  20.643  1.00  0.00           C  
ATOM    709  CD  GLU A  49      54.979  -9.920  21.381  1.00  0.00           C  
ATOM    710  OE1 GLU A  49      55.856 -10.392  22.134  1.00  0.00           O  
ATOM    711  OE2 GLU A  49      54.813  -8.695  21.207  1.00  0.00           O  
ATOM    712  H   GLU A  49      54.155 -12.654  17.766  1.00  0.00           H  
ATOM    713  HA  GLU A  49      56.270 -11.197  19.177  1.00  0.00           H  
ATOM    714  HB2 GLU A  49      53.995 -12.935  20.104  1.00  0.00           H  
ATOM    715  HB3 GLU A  49      55.322 -12.511  21.175  1.00  0.00           H  
ATOM    716  HG2 GLU A  49      53.749 -10.417  19.723  1.00  0.00           H  
ATOM    717  HG3 GLU A  49      53.208 -11.087  21.262  1.00  0.00           H  
ATOM    718  N   LEU A  50      57.784 -13.133  19.807  1.00  0.00           N  
ATOM    719  CA  LEU A  50      58.788 -14.187  19.895  1.00  0.00           C  
ATOM    720  C   LEU A  50      59.317 -14.318  21.319  1.00  0.00           C  
ATOM    721  O   LEU A  50      59.282 -13.363  22.094  1.00  0.00           O  
ATOM    722  CB  LEU A  50      59.942 -13.900  18.933  1.00  0.00           C  
ATOM    723  CG  LEU A  50      59.575 -13.813  17.451  1.00  0.00           C  
ATOM    724  CD1 LEU A  50      60.801 -13.469  16.618  1.00  0.00           C  
ATOM    725  CD2 LEU A  50      58.954 -15.118  16.977  1.00  0.00           C  
ATOM    726  H   LEU A  50      57.943 -12.283  20.270  1.00  0.00           H  
ATOM    727  HA  LEU A  50      58.316 -15.117  19.611  1.00  0.00           H  
ATOM    728  HB2 LEU A  50      60.385 -12.959  19.220  1.00  0.00           H  
ATOM    729  HB3 LEU A  50      60.671 -14.689  19.049  1.00  0.00           H  
ATOM    730  HG  LEU A  50      58.847 -13.025  17.313  1.00  0.00           H  
ATOM    731 HD11 LEU A  50      61.141 -12.477  16.871  1.00  0.00           H  
ATOM    732 HD12 LEU A  50      60.545 -13.507  15.569  1.00  0.00           H  
ATOM    733 HD13 LEU A  50      61.586 -14.182  16.821  1.00  0.00           H  
ATOM    734 HD21 LEU A  50      59.528 -15.510  16.149  1.00  0.00           H  
ATOM    735 HD22 LEU A  50      57.938 -14.938  16.658  1.00  0.00           H  
ATOM    736 HD23 LEU A  50      58.956 -15.833  17.787  1.00  0.00           H  
ATOM    737  N   GLN A  51      59.809 -15.507  21.654  1.00  0.00           N  
ATOM    738  CA  GLN A  51      60.348 -15.761  22.985  1.00  0.00           C  
ATOM    739  C   GLN A  51      61.754 -16.345  22.900  1.00  0.00           C  
ATOM    740  O   GLN A  51      61.953 -17.429  22.353  1.00  0.00           O  
ATOM    741  CB  GLN A  51      59.432 -16.714  23.755  1.00  0.00           C  
ATOM    742  CG  GLN A  51      58.095 -16.099  24.134  1.00  0.00           C  
ATOM    743  CD  GLN A  51      58.217 -15.078  25.247  1.00  0.00           C  
ATOM    744  OE1 GLN A  51      59.195 -14.332  25.317  1.00  0.00           O  
ATOM    745  NE2 GLN A  51      57.222 -15.037  26.126  1.00  0.00           N  
ATOM    746  H   GLN A  51      59.810 -16.228  20.992  1.00  0.00           H  
ATOM    747  HA  GLN A  51      60.394 -14.819  23.509  1.00  0.00           H  
ATOM    748  HB2 GLN A  51      59.244 -17.585  23.145  1.00  0.00           H  
ATOM    749  HB3 GLN A  51      59.932 -17.021  24.662  1.00  0.00           H  
ATOM    750  HG2 GLN A  51      57.677 -15.613  23.265  1.00  0.00           H  
ATOM    751  HG3 GLN A  51      57.431 -16.887  24.460  1.00  0.00           H  
ATOM    752 HE21 GLN A  51      56.477 -15.663  26.009  1.00  0.00           H  
ATOM    753 HE22 GLN A  51      57.275 -14.387  26.856  1.00  0.00           H  
ATOM    754  N   GLU A  52      62.726 -15.620  23.446  1.00  0.00           N  
ATOM    755  CA  GLU A  52      64.113 -16.067  23.430  1.00  0.00           C  
ATOM    756  C   GLU A  52      64.448 -16.848  24.698  1.00  0.00           C  
ATOM    757  O   GLU A  52      63.670 -16.868  25.651  1.00  0.00           O  
ATOM    758  CB  GLU A  52      65.056 -14.870  23.291  1.00  0.00           C  
ATOM    759  CG  GLU A  52      66.377 -15.211  22.621  1.00  0.00           C  
ATOM    760  CD  GLU A  52      66.959 -14.040  21.852  1.00  0.00           C  
ATOM    761  OE1 GLU A  52      66.246 -13.482  20.993  1.00  0.00           O  
ATOM    762  OE2 GLU A  52      68.128 -13.683  22.110  1.00  0.00           O  
ATOM    763  H   GLU A  52      62.504 -14.764  23.868  1.00  0.00           H  
ATOM    764  HA  GLU A  52      64.243 -16.716  22.577  1.00  0.00           H  
ATOM    765  HB2 GLU A  52      64.565 -14.107  22.707  1.00  0.00           H  
ATOM    766  HB3 GLU A  52      65.267 -14.477  24.275  1.00  0.00           H  
ATOM    767  HG2 GLU A  52      67.084 -15.511  23.379  1.00  0.00           H  
ATOM    768  HG3 GLU A  52      66.217 -16.029  21.935  1.00  0.00           H  
ATOM    769  N   GLY A  53      65.612 -17.491  24.701  1.00  0.00           N  
ATOM    770  CA  GLY A  53      66.029 -18.264  25.855  1.00  0.00           C  
ATOM    771  C   GLY A  53      67.319 -17.749  26.463  1.00  0.00           C  
ATOM    772  O   GLY A  53      68.361 -18.402  26.405  1.00  0.00           O  
ATOM    773  H   GLY A  53      66.192 -17.438  23.912  1.00  0.00           H  
ATOM    774  HA2 GLY A  53      65.250 -18.225  26.601  1.00  0.00           H  
ATOM    775  HA3 GLY A  53      66.173 -19.292  25.553  1.00  0.00           H  
ATOM    776  N   PRO A  54      67.258 -16.550  27.061  1.00  0.00           N  
ATOM    777  CA  PRO A  54      68.422 -15.921  27.692  1.00  0.00           C  
ATOM    778  C   PRO A  54      68.852 -16.642  28.965  1.00  0.00           C  
ATOM    779  O   PRO A  54      68.395 -17.751  29.245  1.00  0.00           O  
ATOM    780  CB  PRO A  54      67.927 -14.509  28.019  1.00  0.00           C  
ATOM    781  CG  PRO A  54      66.450 -14.644  28.142  1.00  0.00           C  
ATOM    782  CD  PRO A  54      66.049 -15.717  27.166  1.00  0.00           C  
ATOM    783  HA  PRO A  54      69.259 -15.862  27.013  1.00  0.00           H  
ATOM    784  HB2 PRO A  54      68.374 -14.175  28.945  1.00  0.00           H  
ATOM    785  HB3 PRO A  54      68.197 -13.836  27.220  1.00  0.00           H  
ATOM    786  HG2 PRO A  54      66.189 -14.936  29.148  1.00  0.00           H  
ATOM    787  HG3 PRO A  54      65.973 -13.709  27.887  1.00  0.00           H  
ATOM    788  HD2 PRO A  54      65.219 -16.289  27.555  1.00  0.00           H  
ATOM    789  HD3 PRO A  54      65.796 -15.282  26.212  1.00  0.00           H  
ATOM    790  N   GLU A  55      69.732 -16.007  29.731  1.00  0.00           N  
ATOM    791  CA  GLU A  55      70.224 -16.591  30.974  1.00  0.00           C  
ATOM    792  C   GLU A  55      69.748 -15.784  32.179  1.00  0.00           C  
ATOM    793  O   GLU A  55      69.158 -16.329  33.112  1.00  0.00           O  
ATOM    794  CB  GLU A  55      71.753 -16.658  30.962  1.00  0.00           C  
ATOM    795  CG  GLU A  55      72.309 -17.704  30.012  1.00  0.00           C  
ATOM    796  CD  GLU A  55      71.555 -17.758  28.698  1.00  0.00           C  
ATOM    797  OE1 GLU A  55      71.629 -16.774  27.931  1.00  0.00           O  
ATOM    798  OE2 GLU A  55      70.893 -18.784  28.434  1.00  0.00           O  
ATOM    799  H   GLU A  55      70.060 -15.126  29.455  1.00  0.00           H  
ATOM    800  HA  GLU A  55      69.830 -17.592  31.048  1.00  0.00           H  
ATOM    801  HB2 GLU A  55      72.141 -15.693  30.671  1.00  0.00           H  
ATOM    802  HB3 GLU A  55      72.098 -16.887  31.960  1.00  0.00           H  
ATOM    803  HG2 GLU A  55      73.344 -17.472  29.807  1.00  0.00           H  
ATOM    804  HG3 GLU A  55      72.246 -18.672  30.487  1.00  0.00           H  
ATOM    805  N   LYS A  56      70.010 -14.482  32.153  1.00  0.00           N  
ATOM    806  CA  LYS A  56      69.610 -13.598  33.241  1.00  0.00           C  
ATOM    807  C   LYS A  56      69.576 -12.146  32.778  1.00  0.00           C  
ATOM    808  O   LYS A  56      70.272 -11.750  31.843  1.00  0.00           O  
ATOM    809  CB  LYS A  56      70.569 -13.746  34.424  1.00  0.00           C  
ATOM    810  CG  LYS A  56      72.008 -14.003  34.013  1.00  0.00           C  
ATOM    811  CD  LYS A  56      72.826 -14.561  35.165  1.00  0.00           C  
ATOM    812  CE  LYS A  56      74.318 -14.491  34.875  1.00  0.00           C  
ATOM    813  NZ  LYS A  56      75.130 -14.573  36.120  1.00  0.00           N  
ATOM    814  H   LYS A  56      70.485 -14.105  31.381  1.00  0.00           H  
ATOM    815  HA  LYS A  56      68.617 -13.887  33.554  1.00  0.00           H  
ATOM    816  HB2 LYS A  56      70.540 -12.838  35.010  1.00  0.00           H  
ATOM    817  HB3 LYS A  56      70.239 -14.570  35.039  1.00  0.00           H  
ATOM    818  HG2 LYS A  56      72.018 -14.716  33.201  1.00  0.00           H  
ATOM    819  HG3 LYS A  56      72.451 -13.074  33.685  1.00  0.00           H  
ATOM    820  HD2 LYS A  56      72.617 -13.985  36.055  1.00  0.00           H  
ATOM    821  HD3 LYS A  56      72.548 -15.593  35.328  1.00  0.00           H  
ATOM    822  HE2 LYS A  56      74.584 -15.313  34.227  1.00  0.00           H  
ATOM    823  HE3 LYS A  56      74.531 -13.557  34.377  1.00  0.00           H  
ATOM    824  HZ1 LYS A  56      75.640 -13.679  36.273  1.00  0.00           H  
ATOM    825  HZ2 LYS A  56      75.822 -15.345  36.046  1.00  0.00           H  
ATOM    826  HZ3 LYS A  56      74.513 -14.751  36.938  1.00  0.00           H  
ATOM    827  N   PRO A  57      68.749 -11.328  33.447  1.00  0.00           N  
ATOM    828  CA  PRO A  57      68.607  -9.906  33.122  1.00  0.00           C  
ATOM    829  C   PRO A  57      69.851  -9.102  33.484  1.00  0.00           C  
ATOM    830  O   PRO A  57      69.976  -8.603  34.602  1.00  0.00           O  
ATOM    831  CB  PRO A  57      67.418  -9.464  33.979  1.00  0.00           C  
ATOM    832  CG  PRO A  57      67.397 -10.421  35.122  1.00  0.00           C  
ATOM    833  CD  PRO A  57      67.889 -11.731  34.573  1.00  0.00           C  
ATOM    834  HA  PRO A  57      68.375  -9.759  32.078  1.00  0.00           H  
ATOM    835  HB2 PRO A  57      67.570  -8.449  34.316  1.00  0.00           H  
ATOM    836  HB3 PRO A  57      66.509  -9.523  33.399  1.00  0.00           H  
ATOM    837  HG2 PRO A  57      68.053 -10.071  35.904  1.00  0.00           H  
ATOM    838  HG3 PRO A  57      66.389 -10.525  35.494  1.00  0.00           H  
ATOM    839  HD2 PRO A  57      68.458 -12.264  35.321  1.00  0.00           H  
ATOM    840  HD3 PRO A  57      67.061 -12.331  34.229  1.00  0.00           H  
ATOM    841  N   ARG A  58      70.769  -8.981  32.530  1.00  0.00           N  
ATOM    842  CA  ARG A  58      72.004  -8.238  32.748  1.00  0.00           C  
ATOM    843  C   ARG A  58      72.015  -6.950  31.932  1.00  0.00           C  
ATOM    844  O   ARG A  58      72.189  -5.860  32.477  1.00  0.00           O  
ATOM    845  CB  ARG A  58      73.214  -9.099  32.380  1.00  0.00           C  
ATOM    846  CG  ARG A  58      74.477  -8.735  33.145  1.00  0.00           C  
ATOM    847  CD  ARG A  58      75.283  -7.673  32.415  1.00  0.00           C  
ATOM    848  NE  ARG A  58      76.238  -7.008  33.298  1.00  0.00           N  
ATOM    849  CZ  ARG A  58      77.240  -6.254  32.861  1.00  0.00           C  
ATOM    850  NH1 ARG A  58      77.418  -6.069  31.560  1.00  0.00           N  
ATOM    851  NH2 ARG A  58      78.068  -5.681  33.727  1.00  0.00           N  
ATOM    852  H   ARG A  58      70.613  -9.403  31.660  1.00  0.00           H  
ATOM    853  HA  ARG A  58      72.059  -7.986  33.798  1.00  0.00           H  
ATOM    854  HB2 ARG A  58      72.982 -10.134  32.584  1.00  0.00           H  
ATOM    855  HB3 ARG A  58      73.413  -8.985  31.325  1.00  0.00           H  
ATOM    856  HG2 ARG A  58      74.199  -8.355  34.118  1.00  0.00           H  
ATOM    857  HG3 ARG A  58      75.083  -9.620  33.261  1.00  0.00           H  
ATOM    858  HD2 ARG A  58      75.823  -8.143  31.606  1.00  0.00           H  
ATOM    859  HD3 ARG A  58      74.604  -6.936  32.013  1.00  0.00           H  
ATOM    860  HE  ARG A  58      76.124  -7.130  34.263  1.00  0.00           H  
ATOM    861 HH11 ARG A  58      76.797  -6.499  30.906  1.00  0.00           H  
ATOM    862 HH12 ARG A  58      78.173  -5.501  31.234  1.00  0.00           H  
ATOM    863 HH21 ARG A  58      77.937  -5.817  34.708  1.00  0.00           H  
ATOM    864 HH22 ARG A  58      78.822  -5.114  33.397  1.00  0.00           H  
ATOM    865  N   ARG A  59      71.829  -7.084  30.622  1.00  0.00           N  
ATOM    866  CA  ARG A  59      71.820  -5.931  29.731  1.00  0.00           C  
ATOM    867  C   ARG A  59      70.404  -5.387  29.561  1.00  0.00           C  
ATOM    868  O   ARG A  59      70.215  -4.225  29.199  1.00  0.00           O  
ATOM    869  CB  ARG A  59      72.400  -6.309  28.366  1.00  0.00           C  
ATOM    870  CG  ARG A  59      71.963  -7.682  27.879  1.00  0.00           C  
ATOM    871  CD  ARG A  59      72.212  -7.848  26.389  1.00  0.00           C  
ATOM    872  NE  ARG A  59      71.723  -9.132  25.892  1.00  0.00           N  
ATOM    873  CZ  ARG A  59      72.361 -10.282  26.077  1.00  0.00           C  
ATOM    874  NH1 ARG A  59      73.506 -10.309  26.743  1.00  0.00           N  
ATOM    875  NH2 ARG A  59      71.853 -11.409  25.595  1.00  0.00           N  
ATOM    876  H   ARG A  59      71.696  -7.979  30.248  1.00  0.00           H  
ATOM    877  HA  ARG A  59      72.437  -5.163  30.173  1.00  0.00           H  
ATOM    878  HB2 ARG A  59      72.085  -5.576  27.638  1.00  0.00           H  
ATOM    879  HB3 ARG A  59      73.477  -6.300  28.432  1.00  0.00           H  
ATOM    880  HG2 ARG A  59      72.522  -8.437  28.413  1.00  0.00           H  
ATOM    881  HG3 ARG A  59      70.909  -7.805  28.076  1.00  0.00           H  
ATOM    882  HD2 ARG A  59      71.706  -7.053  25.861  1.00  0.00           H  
ATOM    883  HD3 ARG A  59      73.273  -7.782  26.205  1.00  0.00           H  
ATOM    884  HE  ARG A  59      70.877  -9.135  25.397  1.00  0.00           H  
ATOM    885 HH11 ARG A  59      73.892  -9.462  27.108  1.00  0.00           H  
ATOM    886 HH12 ARG A  59      73.985 -11.177  26.881  1.00  0.00           H  
ATOM    887 HH21 ARG A  59      70.988 -11.393  25.092  1.00  0.00           H  
ATOM    888 HH22 ARG A  59      72.333 -12.274  25.734  1.00  0.00           H  
ATOM    889  N   CYS A  60      69.415  -6.233  29.824  1.00  0.00           N  
ATOM    890  CA  CYS A  60      68.017  -5.839  29.698  1.00  0.00           C  
ATOM    891  C   CYS A  60      67.126  -6.706  30.580  1.00  0.00           C  
ATOM    892  O   CYS A  60      67.142  -7.932  30.479  1.00  0.00           O  
ATOM    893  CB  CYS A  60      67.565  -5.939  28.240  1.00  0.00           C  
ATOM    894  SG  CYS A  60      66.256  -4.776  27.791  1.00  0.00           S  
ATOM    895  H   CYS A  60      69.630  -7.147  30.108  1.00  0.00           H  
ATOM    896  HA  CYS A  60      67.933  -4.812  30.022  1.00  0.00           H  
ATOM    897  HB2 CYS A  60      68.410  -5.747  27.596  1.00  0.00           H  
ATOM    898  HB3 CYS A  60      67.199  -6.938  28.054  1.00  0.00           H  
ATOM    899  HG  CYS A  60      65.136  -5.177  28.373  1.00  0.00           H  
ATOM    900  N   GLU A  61      66.350  -6.061  31.446  1.00  0.00           N  
ATOM    901  CA  GLU A  61      65.455  -6.775  32.349  1.00  0.00           C  
ATOM    902  C   GLU A  61      64.569  -7.751  31.577  1.00  0.00           C  
ATOM    903  O   GLU A  61      64.453  -8.920  31.940  1.00  0.00           O  
ATOM    904  CB  GLU A  61      64.584  -5.786  33.128  1.00  0.00           C  
ATOM    905  CG  GLU A  61      65.373  -4.892  34.068  1.00  0.00           C  
ATOM    906  CD  GLU A  61      64.644  -3.605  34.399  1.00  0.00           C  
ATOM    907  OE1 GLU A  61      64.305  -2.856  33.459  1.00  0.00           O  
ATOM    908  OE2 GLU A  61      64.410  -3.348  35.599  1.00  0.00           O  
ATOM    909  H   GLU A  61      66.382  -5.082  31.480  1.00  0.00           H  
ATOM    910  HA  GLU A  61      66.062  -7.333  33.045  1.00  0.00           H  
ATOM    911  HB2 GLU A  61      64.056  -5.159  32.425  1.00  0.00           H  
ATOM    912  HB3 GLU A  61      63.866  -6.341  33.712  1.00  0.00           H  
ATOM    913  HG2 GLU A  61      65.557  -5.430  34.987  1.00  0.00           H  
ATOM    914  HG3 GLU A  61      66.317  -4.644  33.603  1.00  0.00           H  
ATOM    915  N   ALA A  62      63.947  -7.258  30.511  1.00  0.00           N  
ATOM    916  CA  ALA A  62      63.073  -8.085  29.687  1.00  0.00           C  
ATOM    917  C   ALA A  62      63.610  -8.201  28.264  1.00  0.00           C  
ATOM    918  O   ALA A  62      63.718  -7.207  27.548  1.00  0.00           O  
ATOM    919  CB  ALA A  62      61.663  -7.514  29.676  1.00  0.00           C  
ATOM    920  H   ALA A  62      64.079  -6.317  30.272  1.00  0.00           H  
ATOM    921  HA  ALA A  62      63.033  -9.070  30.128  1.00  0.00           H  
ATOM    922  HB1 ALA A  62      60.950  -8.318  29.785  1.00  0.00           H  
ATOM    923  HB2 ALA A  62      61.550  -6.818  30.493  1.00  0.00           H  
ATOM    924  HB3 ALA A  62      61.489  -7.003  28.740  1.00  0.00           H  
ATOM    925  N   ALA A  63      63.946  -9.423  27.862  1.00  0.00           N  
ATOM    926  CA  ALA A  63      64.470  -9.669  26.524  1.00  0.00           C  
ATOM    927  C   ALA A  63      63.381 -10.199  25.597  1.00  0.00           C  
ATOM    928  O   ALA A  63      63.279 -11.405  25.371  1.00  0.00           O  
ATOM    929  CB  ALA A  63      65.635 -10.647  26.587  1.00  0.00           C  
ATOM    930  H   ALA A  63      63.837 -10.176  28.479  1.00  0.00           H  
ATOM    931  HA  ALA A  63      64.838  -8.733  26.132  1.00  0.00           H  
ATOM    932  HB1 ALA A  63      66.397 -10.255  27.243  1.00  0.00           H  
ATOM    933  HB2 ALA A  63      65.287 -11.597  26.963  1.00  0.00           H  
ATOM    934  HB3 ALA A  63      66.045 -10.780  25.597  1.00  0.00           H  
ATOM    935  N   ARG A  64      62.571  -9.291  25.064  1.00  0.00           N  
ATOM    936  CA  ARG A  64      61.489  -9.667  24.163  1.00  0.00           C  
ATOM    937  C   ARG A  64      61.811  -9.262  22.727  1.00  0.00           C  
ATOM    938  O   ARG A  64      62.543  -8.300  22.492  1.00  0.00           O  
ATOM    939  CB  ARG A  64      60.178  -9.015  24.606  1.00  0.00           C  
ATOM    940  CG  ARG A  64      59.391  -9.846  25.606  1.00  0.00           C  
ATOM    941  CD  ARG A  64      57.897  -9.597  25.484  1.00  0.00           C  
ATOM    942  NE  ARG A  64      57.491  -8.362  26.151  1.00  0.00           N  
ATOM    943  CZ  ARG A  64      56.223  -8.021  26.358  1.00  0.00           C  
ATOM    944  NH1 ARG A  64      55.244  -8.818  25.952  1.00  0.00           N  
ATOM    945  NH2 ARG A  64      55.934  -6.881  26.972  1.00  0.00           N  
ATOM    946  H   ARG A  64      62.704  -8.345  25.282  1.00  0.00           H  
ATOM    947  HA  ARG A  64      61.379 -10.740  24.207  1.00  0.00           H  
ATOM    948  HB2 ARG A  64      60.399  -8.060  25.060  1.00  0.00           H  
ATOM    949  HB3 ARG A  64      59.558  -8.855  23.736  1.00  0.00           H  
ATOM    950  HG2 ARG A  64      59.587 -10.893  25.424  1.00  0.00           H  
ATOM    951  HG3 ARG A  64      59.711  -9.587  26.605  1.00  0.00           H  
ATOM    952  HD2 ARG A  64      57.640  -9.530  24.437  1.00  0.00           H  
ATOM    953  HD3 ARG A  64      57.369 -10.427  25.931  1.00  0.00           H  
ATOM    954  HE  ARG A  64      58.199  -7.759  26.459  1.00  0.00           H  
ATOM    955 HH11 ARG A  64      55.459  -9.678  25.490  1.00  0.00           H  
ATOM    956 HH12 ARG A  64      54.291  -8.559  26.110  1.00  0.00           H  
ATOM    957 HH21 ARG A  64      56.670  -6.279  27.279  1.00  0.00           H  
ATOM    958 HH22 ARG A  64      54.981  -6.625  27.127  1.00  0.00           H  
ATOM    959  N   LYS A  65      61.261 -10.003  21.772  1.00  0.00           N  
ATOM    960  CA  LYS A  65      61.488  -9.723  20.359  1.00  0.00           C  
ATOM    961  C   LYS A  65      60.184  -9.804  19.571  1.00  0.00           C  
ATOM    962  O   LYS A  65      59.648 -10.890  19.350  1.00  0.00           O  
ATOM    963  CB  LYS A  65      62.508 -10.706  19.780  1.00  0.00           C  
ATOM    964  CG  LYS A  65      62.640 -10.626  18.269  1.00  0.00           C  
ATOM    965  CD  LYS A  65      63.435  -9.405  17.842  1.00  0.00           C  
ATOM    966  CE  LYS A  65      63.725  -9.422  16.349  1.00  0.00           C  
ATOM    967  NZ  LYS A  65      64.898 -10.277  16.021  1.00  0.00           N  
ATOM    968  H   LYS A  65      60.687 -10.757  22.023  1.00  0.00           H  
ATOM    969  HA  LYS A  65      61.882  -8.721  20.280  1.00  0.00           H  
ATOM    970  HB2 LYS A  65      63.475 -10.502  20.216  1.00  0.00           H  
ATOM    971  HB3 LYS A  65      62.209 -11.711  20.042  1.00  0.00           H  
ATOM    972  HG2 LYS A  65      63.144 -11.513  17.914  1.00  0.00           H  
ATOM    973  HG3 LYS A  65      61.652 -10.573  17.833  1.00  0.00           H  
ATOM    974  HD2 LYS A  65      62.868  -8.516  18.077  1.00  0.00           H  
ATOM    975  HD3 LYS A  65      64.372  -9.389  18.381  1.00  0.00           H  
ATOM    976  HE2 LYS A  65      62.857  -9.802  15.832  1.00  0.00           H  
ATOM    977  HE3 LYS A  65      63.923  -8.411  16.023  1.00  0.00           H  
ATOM    978  HZ1 LYS A  65      64.731 -10.784  15.128  1.00  0.00           H  
ATOM    979  HZ2 LYS A  65      65.055 -10.973  16.777  1.00  0.00           H  
ATOM    980  HZ3 LYS A  65      65.751  -9.691  15.920  1.00  0.00           H  
ATOM    981  N   VAL A  66      59.680  -8.648  19.151  1.00  0.00           N  
ATOM    982  CA  VAL A  66      58.441  -8.589  18.385  1.00  0.00           C  
ATOM    983  C   VAL A  66      58.649  -7.872  17.056  1.00  0.00           C  
ATOM    984  O   VAL A  66      59.313  -6.837  16.995  1.00  0.00           O  
ATOM    985  CB  VAL A  66      57.328  -7.872  19.173  1.00  0.00           C  
ATOM    986  CG1 VAL A  66      57.646  -6.391  19.319  1.00  0.00           C  
ATOM    987  CG2 VAL A  66      55.981  -8.073  18.495  1.00  0.00           C  
ATOM    988  H   VAL A  66      60.154  -7.816  19.359  1.00  0.00           H  
ATOM    989  HA  VAL A  66      58.118  -9.602  18.191  1.00  0.00           H  
ATOM    990  HB  VAL A  66      57.278  -8.305  20.162  1.00  0.00           H  
ATOM    991 HG11 VAL A  66      57.033  -5.823  18.634  1.00  0.00           H  
ATOM    992 HG12 VAL A  66      57.442  -6.077  20.332  1.00  0.00           H  
ATOM    993 HG13 VAL A  66      58.687  -6.223  19.091  1.00  0.00           H  
ATOM    994 HG21 VAL A  66      55.645  -9.086  18.657  1.00  0.00           H  
ATOM    995 HG22 VAL A  66      55.261  -7.384  18.913  1.00  0.00           H  
ATOM    996 HG23 VAL A  66      56.080  -7.891  17.436  1.00  0.00           H  
ATOM    997  N   ILE A  67      58.077  -8.430  15.993  1.00  0.00           N  
ATOM    998  CA  ILE A  67      58.199  -7.843  14.665  1.00  0.00           C  
ATOM    999  C   ILE A  67      56.833  -7.463  14.104  1.00  0.00           C  
ATOM   1000  O   ILE A  67      56.122  -8.302  13.551  1.00  0.00           O  
ATOM   1001  CB  ILE A  67      58.894  -8.807  13.685  1.00  0.00           C  
ATOM   1002  CG1 ILE A  67      60.286  -9.179  14.201  1.00  0.00           C  
ATOM   1003  CG2 ILE A  67      58.985  -8.181  12.302  1.00  0.00           C  
ATOM   1004  CD1 ILE A  67      60.794 -10.499  13.668  1.00  0.00           C  
ATOM   1005  H   ILE A  67      57.561  -9.255  16.106  1.00  0.00           H  
ATOM   1006  HA  ILE A  67      58.803  -6.951  14.749  1.00  0.00           H  
ATOM   1007  HB  ILE A  67      58.295  -9.702  13.610  1.00  0.00           H  
ATOM   1008 HG12 ILE A  67      60.986  -8.412  13.912  1.00  0.00           H  
ATOM   1009 HG13 ILE A  67      60.256  -9.245  15.279  1.00  0.00           H  
ATOM   1010 HG21 ILE A  67      58.994  -8.961  11.554  1.00  0.00           H  
ATOM   1011 HG22 ILE A  67      58.132  -7.539  12.141  1.00  0.00           H  
ATOM   1012 HG23 ILE A  67      59.892  -7.601  12.228  1.00  0.00           H  
ATOM   1013 HD11 ILE A  67      60.254 -10.759  12.770  1.00  0.00           H  
ATOM   1014 HD12 ILE A  67      61.848 -10.416  13.443  1.00  0.00           H  
ATOM   1015 HD13 ILE A  67      60.645 -11.270  14.411  1.00  0.00           H  
ATOM   1016  N   ARG A  68      56.473  -6.192  14.250  1.00  0.00           N  
ATOM   1017  CA  ARG A  68      55.192  -5.700  13.758  1.00  0.00           C  
ATOM   1018  C   ARG A  68      54.970  -6.119  12.307  1.00  0.00           C  
ATOM   1019  O   ARG A  68      55.633  -5.617  11.397  1.00  0.00           O  
ATOM   1020  CB  ARG A  68      55.127  -4.176  13.875  1.00  0.00           C  
ATOM   1021  CG  ARG A  68      55.226  -3.671  15.306  1.00  0.00           C  
ATOM   1022  CD  ARG A  68      53.947  -3.943  16.082  1.00  0.00           C  
ATOM   1023  NE  ARG A  68      54.162  -3.896  17.526  1.00  0.00           N  
ATOM   1024  CZ  ARG A  68      54.291  -2.766  18.213  1.00  0.00           C  
ATOM   1025  NH1 ARG A  68      54.226  -1.597  17.591  1.00  0.00           N  
ATOM   1026  NH2 ARG A  68      54.484  -2.806  19.525  1.00  0.00           N  
ATOM   1027  H   ARG A  68      57.083  -5.570  14.700  1.00  0.00           H  
ATOM   1028  HA  ARG A  68      54.414  -6.132  14.368  1.00  0.00           H  
ATOM   1029  HB2 ARG A  68      55.942  -3.747  13.310  1.00  0.00           H  
ATOM   1030  HB3 ARG A  68      54.191  -3.834  13.460  1.00  0.00           H  
ATOM   1031  HG2 ARG A  68      56.046  -4.172  15.798  1.00  0.00           H  
ATOM   1032  HG3 ARG A  68      55.408  -2.607  15.290  1.00  0.00           H  
ATOM   1033  HD2 ARG A  68      53.213  -3.198  15.812  1.00  0.00           H  
ATOM   1034  HD3 ARG A  68      53.581  -4.923  15.813  1.00  0.00           H  
ATOM   1035  HE  ARG A  68      54.214  -4.748  18.005  1.00  0.00           H  
ATOM   1036 HH11 ARG A  68      54.079  -1.565  16.603  1.00  0.00           H  
ATOM   1037 HH12 ARG A  68      54.322  -0.748  18.111  1.00  0.00           H  
ATOM   1038 HH21 ARG A  68      54.534  -3.685  19.997  1.00  0.00           H  
ATOM   1039 HH22 ARG A  68      54.580  -1.955  20.041  1.00  0.00           H  
ATOM   1040  N   LEU A  69      54.035  -7.039  12.098  1.00  0.00           N  
ATOM   1041  CA  LEU A  69      53.726  -7.525  10.759  1.00  0.00           C  
ATOM   1042  C   LEU A  69      53.534  -6.363   9.788  1.00  0.00           C  
ATOM   1043  O   LEU A  69      54.068  -6.375   8.679  1.00  0.00           O  
ATOM   1044  CB  LEU A  69      52.466  -8.393  10.788  1.00  0.00           C  
ATOM   1045  CG  LEU A  69      52.650  -9.826  11.287  1.00  0.00           C  
ATOM   1046  CD1 LEU A  69      51.347 -10.603  11.173  1.00  0.00           C  
ATOM   1047  CD2 LEU A  69      53.758 -10.523  10.510  1.00  0.00           C  
ATOM   1048  H   LEU A  69      53.541  -7.400  12.863  1.00  0.00           H  
ATOM   1049  HA  LEU A  69      54.558  -8.125  10.424  1.00  0.00           H  
ATOM   1050  HB2 LEU A  69      51.746  -7.909  11.430  1.00  0.00           H  
ATOM   1051  HB3 LEU A  69      52.074  -8.439   9.782  1.00  0.00           H  
ATOM   1052  HG  LEU A  69      52.934  -9.804  12.330  1.00  0.00           H  
ATOM   1053 HD11 LEU A  69      50.908 -10.427  10.203  1.00  0.00           H  
ATOM   1054 HD12 LEU A  69      50.665 -10.275  11.942  1.00  0.00           H  
ATOM   1055 HD13 LEU A  69      51.546 -11.657  11.294  1.00  0.00           H  
ATOM   1056 HD21 LEU A  69      54.718 -10.223  10.905  1.00  0.00           H  
ATOM   1057 HD22 LEU A  69      53.695 -10.246   9.467  1.00  0.00           H  
ATOM   1058 HD23 LEU A  69      53.647 -11.593  10.607  1.00  0.00           H  
ATOM   1059  N   SER A  70      52.771  -5.362  10.215  1.00  0.00           N  
ATOM   1060  CA  SER A  70      52.509  -4.194   9.383  1.00  0.00           C  
ATOM   1061  C   SER A  70      53.812  -3.584   8.875  1.00  0.00           C  
ATOM   1062  O   SER A  70      53.841  -2.942   7.825  1.00  0.00           O  
ATOM   1063  CB  SER A  70      51.716  -3.149  10.171  1.00  0.00           C  
ATOM   1064  OG  SER A  70      51.065  -2.241   9.300  1.00  0.00           O  
ATOM   1065  H   SER A  70      52.375  -5.412  11.109  1.00  0.00           H  
ATOM   1066  HA  SER A  70      51.921  -4.516   8.536  1.00  0.00           H  
ATOM   1067  HB2 SER A  70      50.973  -3.645  10.776  1.00  0.00           H  
ATOM   1068  HB3 SER A  70      52.390  -2.596  10.809  1.00  0.00           H  
ATOM   1069  HG  SER A  70      50.465  -2.721   8.726  1.00  0.00           H  
ATOM   1070  N   ASP A  71      54.886  -3.790   9.628  1.00  0.00           N  
ATOM   1071  CA  ASP A  71      56.194  -3.263   9.255  1.00  0.00           C  
ATOM   1072  C   ASP A  71      56.764  -4.019   8.060  1.00  0.00           C  
ATOM   1073  O   ASP A  71      57.490  -3.452   7.243  1.00  0.00           O  
ATOM   1074  CB  ASP A  71      57.160  -3.350  10.438  1.00  0.00           C  
ATOM   1075  CG  ASP A  71      58.330  -2.396  10.302  1.00  0.00           C  
ATOM   1076  OD1 ASP A  71      59.175  -2.616   9.409  1.00  0.00           O  
ATOM   1077  OD2 ASP A  71      58.401  -1.429  11.089  1.00  0.00           O  
ATOM   1078  H   ASP A  71      54.799  -4.311  10.454  1.00  0.00           H  
ATOM   1079  HA  ASP A  71      56.068  -2.225   8.982  1.00  0.00           H  
ATOM   1080  HB2 ASP A  71      56.627  -3.111  11.348  1.00  0.00           H  
ATOM   1081  HB3 ASP A  71      57.545  -4.357  10.506  1.00  0.00           H  
ATOM   1082  N   CYS A  72      56.432  -5.302   7.964  1.00  0.00           N  
ATOM   1083  CA  CYS A  72      56.913  -6.136   6.870  1.00  0.00           C  
ATOM   1084  C   CYS A  72      56.763  -5.419   5.532  1.00  0.00           C  
ATOM   1085  O   CYS A  72      55.664  -5.333   4.981  1.00  0.00           O  
ATOM   1086  CB  CYS A  72      56.151  -7.462   6.839  1.00  0.00           C  
ATOM   1087  SG  CYS A  72      56.347  -8.461   8.333  1.00  0.00           S  
ATOM   1088  H   CYS A  72      55.849  -5.697   8.647  1.00  0.00           H  
ATOM   1089  HA  CYS A  72      57.960  -6.337   7.042  1.00  0.00           H  
ATOM   1090  HB2 CYS A  72      55.097  -7.260   6.716  1.00  0.00           H  
ATOM   1091  HB3 CYS A  72      56.498  -8.049   6.002  1.00  0.00           H  
ATOM   1092  HG  CYS A  72      56.590  -7.641   9.344  1.00  0.00           H  
ATOM   1093  N   LEU A  73      57.874  -4.904   5.015  1.00  0.00           N  
ATOM   1094  CA  LEU A  73      57.866  -4.193   3.742  1.00  0.00           C  
ATOM   1095  C   LEU A  73      57.580  -5.146   2.586  1.00  0.00           C  
ATOM   1096  O   LEU A  73      56.958  -4.765   1.595  1.00  0.00           O  
ATOM   1097  CB  LEU A  73      59.207  -3.491   3.520  1.00  0.00           C  
ATOM   1098  CG  LEU A  73      59.508  -2.309   4.442  1.00  0.00           C  
ATOM   1099  CD1 LEU A  73      60.995  -1.992   4.435  1.00  0.00           C  
ATOM   1100  CD2 LEU A  73      58.698  -1.090   4.026  1.00  0.00           C  
ATOM   1101  H   LEU A  73      58.719  -5.006   5.500  1.00  0.00           H  
ATOM   1102  HA  LEU A  73      57.083  -3.450   3.783  1.00  0.00           H  
ATOM   1103  HB2 LEU A  73      59.989  -4.223   3.654  1.00  0.00           H  
ATOM   1104  HB3 LEU A  73      59.226  -3.130   2.501  1.00  0.00           H  
ATOM   1105  HG  LEU A  73      59.227  -2.569   5.453  1.00  0.00           H  
ATOM   1106 HD11 LEU A  73      61.544  -2.830   4.836  1.00  0.00           H  
ATOM   1107 HD12 LEU A  73      61.179  -1.118   5.043  1.00  0.00           H  
ATOM   1108 HD13 LEU A  73      61.318  -1.801   3.423  1.00  0.00           H  
ATOM   1109 HD21 LEU A  73      58.625  -0.405   4.860  1.00  0.00           H  
ATOM   1110 HD22 LEU A  73      57.707  -1.400   3.727  1.00  0.00           H  
ATOM   1111 HD23 LEU A  73      59.187  -0.597   3.198  1.00  0.00           H  
ATOM   1112  N   ARG A  74      58.035  -6.386   2.724  1.00  0.00           N  
ATOM   1113  CA  ARG A  74      57.827  -7.395   1.690  1.00  0.00           C  
ATOM   1114  C   ARG A  74      58.192  -8.784   2.206  1.00  0.00           C  
ATOM   1115  O   ARG A  74      59.113  -8.938   3.008  1.00  0.00           O  
ATOM   1116  CB  ARG A  74      58.659  -7.064   0.450  1.00  0.00           C  
ATOM   1117  CG  ARG A  74      58.491  -8.066  -0.680  1.00  0.00           C  
ATOM   1118  CD  ARG A  74      59.475  -9.219  -0.554  1.00  0.00           C  
ATOM   1119  NE  ARG A  74      59.420 -10.114  -1.707  1.00  0.00           N  
ATOM   1120  CZ  ARG A  74      59.837  -9.773  -2.921  1.00  0.00           C  
ATOM   1121  NH1 ARG A  74      60.338  -8.564  -3.139  1.00  0.00           N  
ATOM   1122  NH2 ARG A  74      59.756 -10.643  -3.921  1.00  0.00           N  
ATOM   1123  H   ARG A  74      58.523  -6.630   3.537  1.00  0.00           H  
ATOM   1124  HA  ARG A  74      56.781  -7.385   1.424  1.00  0.00           H  
ATOM   1125  HB2 ARG A  74      58.368  -6.090   0.084  1.00  0.00           H  
ATOM   1126  HB3 ARG A  74      59.702  -7.039   0.727  1.00  0.00           H  
ATOM   1127  HG2 ARG A  74      57.486  -8.461  -0.653  1.00  0.00           H  
ATOM   1128  HG3 ARG A  74      58.656  -7.564  -1.621  1.00  0.00           H  
ATOM   1129  HD2 ARG A  74      60.473  -8.815  -0.470  1.00  0.00           H  
ATOM   1130  HD3 ARG A  74      59.237  -9.780   0.337  1.00  0.00           H  
ATOM   1131  HE  ARG A  74      59.055 -11.011  -1.569  1.00  0.00           H  
ATOM   1132 HH11 ARG A  74      60.400  -7.907  -2.389  1.00  0.00           H  
ATOM   1133 HH12 ARG A  74      60.652  -8.311  -4.055  1.00  0.00           H  
ATOM   1134 HH21 ARG A  74      59.380 -11.555  -3.760  1.00  0.00           H  
ATOM   1135 HH22 ARG A  74      60.070 -10.385  -4.834  1.00  0.00           H  
ATOM   1136  N   VAL A  75      57.463  -9.792   1.740  1.00  0.00           N  
ATOM   1137  CA  VAL A  75      57.711 -11.169   2.153  1.00  0.00           C  
ATOM   1138  C   VAL A  75      57.645 -12.120   0.963  1.00  0.00           C  
ATOM   1139  O   VAL A  75      56.937 -11.865  -0.010  1.00  0.00           O  
ATOM   1140  CB  VAL A  75      56.695 -11.627   3.216  1.00  0.00           C  
ATOM   1141  CG1 VAL A  75      56.651 -10.639   4.372  1.00  0.00           C  
ATOM   1142  CG2 VAL A  75      55.316 -11.798   2.598  1.00  0.00           C  
ATOM   1143  H   VAL A  75      56.742  -9.607   1.103  1.00  0.00           H  
ATOM   1144  HA  VAL A  75      58.699 -11.216   2.585  1.00  0.00           H  
ATOM   1145  HB  VAL A  75      57.015 -12.584   3.603  1.00  0.00           H  
ATOM   1146 HG11 VAL A  75      57.434 -10.875   5.078  1.00  0.00           H  
ATOM   1147 HG12 VAL A  75      56.794  -9.636   3.995  1.00  0.00           H  
ATOM   1148 HG13 VAL A  75      55.692 -10.705   4.865  1.00  0.00           H  
ATOM   1149 HG21 VAL A  75      55.310 -11.366   1.609  1.00  0.00           H  
ATOM   1150 HG22 VAL A  75      55.079 -12.851   2.532  1.00  0.00           H  
ATOM   1151 HG23 VAL A  75      54.581 -11.303   3.213  1.00  0.00           H  
ATOM   1152  N   ALA A  76      58.391 -13.218   1.048  1.00  0.00           N  
ATOM   1153  CA  ALA A  76      58.416 -14.208  -0.022  1.00  0.00           C  
ATOM   1154  C   ALA A  76      58.478 -15.623   0.543  1.00  0.00           C  
ATOM   1155  O   ALA A  76      58.631 -15.813   1.749  1.00  0.00           O  
ATOM   1156  CB  ALA A  76      59.596 -13.955  -0.948  1.00  0.00           C  
ATOM   1157  H   ALA A  76      58.934 -13.364   1.849  1.00  0.00           H  
ATOM   1158  HA  ALA A  76      57.508 -14.101  -0.597  1.00  0.00           H  
ATOM   1159  HB1 ALA A  76      59.730 -12.890  -1.075  1.00  0.00           H  
ATOM   1160  HB2 ALA A  76      60.489 -14.382  -0.518  1.00  0.00           H  
ATOM   1161  HB3 ALA A  76      59.404 -14.411  -1.907  1.00  0.00           H  
ATOM   1162  N   GLU A  77      58.360 -16.613  -0.337  1.00  0.00           N  
ATOM   1163  CA  GLU A  77      58.402 -18.010   0.076  1.00  0.00           C  
ATOM   1164  C   GLU A  77      59.611 -18.720  -0.527  1.00  0.00           C  
ATOM   1165  O   GLU A  77      59.697 -18.898  -1.742  1.00  0.00           O  
ATOM   1166  CB  GLU A  77      57.116 -18.727  -0.340  1.00  0.00           C  
ATOM   1167  CG  GLU A  77      55.852 -17.954  -0.004  1.00  0.00           C  
ATOM   1168  CD  GLU A  77      55.420 -17.026  -1.123  1.00  0.00           C  
ATOM   1169  OE1 GLU A  77      55.999 -15.927  -1.238  1.00  0.00           O  
ATOM   1170  OE2 GLU A  77      54.503 -17.401  -1.883  1.00  0.00           O  
ATOM   1171  H   GLU A  77      58.241 -16.397  -1.285  1.00  0.00           H  
ATOM   1172  HA  GLU A  77      58.485 -18.036   1.153  1.00  0.00           H  
ATOM   1173  HB2 GLU A  77      57.140 -18.892  -1.407  1.00  0.00           H  
ATOM   1174  HB3 GLU A  77      57.072 -19.683   0.162  1.00  0.00           H  
ATOM   1175  HG2 GLU A  77      55.055 -18.658   0.188  1.00  0.00           H  
ATOM   1176  HG3 GLU A  77      56.031 -17.365   0.883  1.00  0.00           H  
ATOM   1177  N   ALA A  78      60.542 -19.122   0.331  1.00  0.00           N  
ATOM   1178  CA  ALA A  78      61.746 -19.813  -0.116  1.00  0.00           C  
ATOM   1179  C   ALA A  78      61.544 -21.325  -0.112  1.00  0.00           C  
ATOM   1180  O   ALA A  78      60.563 -21.828   0.432  1.00  0.00           O  
ATOM   1181  CB  ALA A  78      62.930 -19.434   0.761  1.00  0.00           C  
ATOM   1182  H   ALA A  78      60.417 -18.951   1.288  1.00  0.00           H  
ATOM   1183  HA  ALA A  78      61.960 -19.492  -1.126  1.00  0.00           H  
ATOM   1184  HB1 ALA A  78      62.751 -19.775   1.771  1.00  0.00           H  
ATOM   1185  HB2 ALA A  78      63.825 -19.897   0.378  1.00  0.00           H  
ATOM   1186  HB3 ALA A  78      63.049 -18.361   0.760  1.00  0.00           H  
ATOM   1187  N   GLY A  79      62.482 -22.044  -0.722  1.00  0.00           N  
ATOM   1188  CA  GLY A  79      62.388 -23.491  -0.778  1.00  0.00           C  
ATOM   1189  C   GLY A  79      63.353 -24.172   0.173  1.00  0.00           C  
ATOM   1190  O   GLY A  79      63.772 -25.304  -0.062  1.00  0.00           O  
ATOM   1191  H   GLY A  79      63.243 -21.588  -1.138  1.00  0.00           H  
ATOM   1192  HA2 GLY A  79      61.380 -23.785  -0.523  1.00  0.00           H  
ATOM   1193  HA3 GLY A  79      62.603 -23.816  -1.785  1.00  0.00           H  
ATOM   1194  N   GLY A  80      63.708 -23.478   1.251  1.00  0.00           N  
ATOM   1195  CA  GLY A  80      64.629 -24.038   2.222  1.00  0.00           C  
ATOM   1196  C   GLY A  80      66.019 -24.243   1.653  1.00  0.00           C  
ATOM   1197  O   GLY A  80      66.604 -25.315   1.798  1.00  0.00           O  
ATOM   1198  H   GLY A  80      63.342 -22.579   1.386  1.00  0.00           H  
ATOM   1199  HA2 GLY A  80      64.692 -23.370   3.068  1.00  0.00           H  
ATOM   1200  HA3 GLY A  80      64.246 -24.991   2.557  1.00  0.00           H  
ATOM   1201  N   GLU A  81      66.548 -23.211   1.002  1.00  0.00           N  
ATOM   1202  CA  GLU A  81      67.877 -23.285   0.406  1.00  0.00           C  
ATOM   1203  C   GLU A  81      68.947 -22.870   1.413  1.00  0.00           C  
ATOM   1204  O   GLU A  81      70.090 -23.321   1.339  1.00  0.00           O  
ATOM   1205  CB  GLU A  81      67.955 -22.393  -0.834  1.00  0.00           C  
ATOM   1206  CG  GLU A  81      69.343 -22.327  -1.449  1.00  0.00           C  
ATOM   1207  CD  GLU A  81      70.330 -21.571  -0.583  1.00  0.00           C  
ATOM   1208  OE1 GLU A  81      69.995 -20.454  -0.138  1.00  0.00           O  
ATOM   1209  OE2 GLU A  81      71.438 -22.097  -0.349  1.00  0.00           O  
ATOM   1210  H   GLU A  81      66.033 -22.381   0.920  1.00  0.00           H  
ATOM   1211  HA  GLU A  81      68.053 -24.309   0.114  1.00  0.00           H  
ATOM   1212  HB2 GLU A  81      67.270 -22.771  -1.579  1.00  0.00           H  
ATOM   1213  HB3 GLU A  81      67.658 -21.391  -0.561  1.00  0.00           H  
ATOM   1214  HG2 GLU A  81      69.707 -23.333  -1.592  1.00  0.00           H  
ATOM   1215  HG3 GLU A  81      69.273 -21.831  -2.408  1.00  0.00           H  
ATOM   1216  N   ALA A  82      68.567 -22.010   2.350  1.00  0.00           N  
ATOM   1217  CA  ALA A  82      69.493 -21.535   3.372  1.00  0.00           C  
ATOM   1218  C   ALA A  82      70.051 -22.696   4.189  1.00  0.00           C  
ATOM   1219  O   ALA A  82      69.684 -23.852   3.975  1.00  0.00           O  
ATOM   1220  CB  ALA A  82      68.804 -20.530   4.283  1.00  0.00           C  
ATOM   1221  H   ALA A  82      67.643 -21.687   2.357  1.00  0.00           H  
ATOM   1222  HA  ALA A  82      70.310 -21.032   2.875  1.00  0.00           H  
ATOM   1223  HB1 ALA A  82      69.444 -19.669   4.416  1.00  0.00           H  
ATOM   1224  HB2 ALA A  82      67.871 -20.220   3.836  1.00  0.00           H  
ATOM   1225  HB3 ALA A  82      68.611 -20.986   5.242  1.00  0.00           H  
ATOM   1226  N   SER A  83      70.940 -22.381   5.126  1.00  0.00           N  
ATOM   1227  CA  SER A  83      71.552 -23.398   5.972  1.00  0.00           C  
ATOM   1228  C   SER A  83      70.491 -24.316   6.571  1.00  0.00           C  
ATOM   1229  O   SER A  83      70.749 -25.491   6.836  1.00  0.00           O  
ATOM   1230  CB  SER A  83      72.365 -22.742   7.089  1.00  0.00           C  
ATOM   1231  OG  SER A  83      73.331 -23.637   7.611  1.00  0.00           O  
ATOM   1232  H   SER A  83      71.192 -21.441   5.249  1.00  0.00           H  
ATOM   1233  HA  SER A  83      72.214 -23.988   5.356  1.00  0.00           H  
ATOM   1234  HB2 SER A  83      72.871 -21.872   6.699  1.00  0.00           H  
ATOM   1235  HB3 SER A  83      71.700 -22.443   7.886  1.00  0.00           H  
ATOM   1236  HG  SER A  83      73.503 -23.423   8.531  1.00  0.00           H  
ATOM   1237  N   SER A  84      69.298 -23.772   6.783  1.00  0.00           N  
ATOM   1238  CA  SER A  84      68.197 -24.539   7.355  1.00  0.00           C  
ATOM   1239  C   SER A  84      68.205 -25.973   6.831  1.00  0.00           C  
ATOM   1240  O   SER A  84      68.641 -26.250   5.714  1.00  0.00           O  
ATOM   1241  CB  SER A  84      66.860 -23.873   7.030  1.00  0.00           C  
ATOM   1242  OG  SER A  84      66.746 -23.606   5.643  1.00  0.00           O  
ATOM   1243  H   SER A  84      69.154 -22.831   6.551  1.00  0.00           H  
ATOM   1244  HA  SER A  84      68.329 -24.559   8.426  1.00  0.00           H  
ATOM   1245  HB2 SER A  84      66.053 -24.527   7.326  1.00  0.00           H  
ATOM   1246  HB3 SER A  84      66.784 -22.940   7.571  1.00  0.00           H  
ATOM   1247  HG  SER A  84      66.671 -22.660   5.503  1.00  0.00           H  
ATOM   1248  N   PRO A  85      67.711 -26.906   7.658  1.00  0.00           N  
ATOM   1249  CA  PRO A  85      67.648 -28.326   7.300  1.00  0.00           C  
ATOM   1250  C   PRO A  85      66.619 -28.605   6.211  1.00  0.00           C  
ATOM   1251  O   PRO A  85      65.634 -27.880   6.073  1.00  0.00           O  
ATOM   1252  CB  PRO A  85      67.239 -29.004   8.611  1.00  0.00           C  
ATOM   1253  CG  PRO A  85      66.516 -27.948   9.373  1.00  0.00           C  
ATOM   1254  CD  PRO A  85      67.174 -26.647   9.004  1.00  0.00           C  
ATOM   1255  HA  PRO A  85      68.612 -28.700   6.987  1.00  0.00           H  
ATOM   1256  HB2 PRO A  85      66.596 -29.848   8.396  1.00  0.00           H  
ATOM   1257  HB3 PRO A  85      68.119 -29.339   9.138  1.00  0.00           H  
ATOM   1258  HG2 PRO A  85      65.475 -27.936   9.088  1.00  0.00           H  
ATOM   1259  HG3 PRO A  85      66.614 -28.130  10.433  1.00  0.00           H  
ATOM   1260  HD2 PRO A  85      66.447 -25.849   8.983  1.00  0.00           H  
ATOM   1261  HD3 PRO A  85      67.969 -26.417   9.698  1.00  0.00           H  
ATOM   1262  N   ARG A  86      66.852 -29.663   5.440  1.00  0.00           N  
ATOM   1263  CA  ARG A  86      65.944 -30.037   4.362  1.00  0.00           C  
ATOM   1264  C   ARG A  86      64.594 -30.479   4.918  1.00  0.00           C  
ATOM   1265  O   ARG A  86      64.409 -30.567   6.131  1.00  0.00           O  
ATOM   1266  CB  ARG A  86      66.553 -31.159   3.520  1.00  0.00           C  
ATOM   1267  CG  ARG A  86      67.393 -30.661   2.355  1.00  0.00           C  
ATOM   1268  CD  ARG A  86      67.892 -31.812   1.496  1.00  0.00           C  
ATOM   1269  NE  ARG A  86      66.793 -32.576   0.912  1.00  0.00           N  
ATOM   1270  CZ  ARG A  86      66.170 -33.566   1.542  1.00  0.00           C  
ATOM   1271  NH1 ARG A  86      66.536 -33.909   2.769  1.00  0.00           N  
ATOM   1272  NH2 ARG A  86      65.179 -34.214   0.945  1.00  0.00           N  
ATOM   1273  H   ARG A  86      67.654 -30.203   5.598  1.00  0.00           H  
ATOM   1274  HA  ARG A  86      65.796 -29.170   3.736  1.00  0.00           H  
ATOM   1275  HB2 ARG A  86      67.183 -31.768   4.153  1.00  0.00           H  
ATOM   1276  HB3 ARG A  86      65.756 -31.771   3.125  1.00  0.00           H  
ATOM   1277  HG2 ARG A  86      66.790 -30.006   1.744  1.00  0.00           H  
ATOM   1278  HG3 ARG A  86      68.241 -30.117   2.742  1.00  0.00           H  
ATOM   1279  HD2 ARG A  86      68.501 -31.411   0.699  1.00  0.00           H  
ATOM   1280  HD3 ARG A  86      68.490 -32.469   2.110  1.00  0.00           H  
ATOM   1281  HE  ARG A  86      66.507 -32.340   0.006  1.00  0.00           H  
ATOM   1282 HH11 ARG A  86      67.282 -33.421   3.223  1.00  0.00           H  
ATOM   1283 HH12 ARG A  86      66.065 -34.654   3.243  1.00  0.00           H  
ATOM   1284 HH21 ARG A  86      64.901 -33.959   0.020  1.00  0.00           H  
ATOM   1285 HH22 ARG A  86      64.711 -34.959   1.419  1.00  0.00           H  
ATOM   1286  N   ASP A  87      63.652 -30.755   4.021  1.00  0.00           N  
ATOM   1287  CA  ASP A  87      62.319 -31.187   4.420  1.00  0.00           C  
ATOM   1288  C   ASP A  87      61.539 -30.036   5.048  1.00  0.00           C  
ATOM   1289  O   ASP A  87      60.638 -30.251   5.859  1.00  0.00           O  
ATOM   1290  CB  ASP A  87      62.412 -32.354   5.405  1.00  0.00           C  
ATOM   1291  CG  ASP A  87      61.109 -33.119   5.522  1.00  0.00           C  
ATOM   1292  OD1 ASP A  87      60.742 -33.818   4.554  1.00  0.00           O  
ATOM   1293  OD2 ASP A  87      60.453 -33.017   6.580  1.00  0.00           O  
ATOM   1294  H   ASP A  87      63.861 -30.665   3.067  1.00  0.00           H  
ATOM   1295  HA  ASP A  87      61.797 -31.516   3.535  1.00  0.00           H  
ATOM   1296  HB2 ASP A  87      63.180 -33.038   5.072  1.00  0.00           H  
ATOM   1297  HB3 ASP A  87      62.674 -31.972   6.381  1.00  0.00           H  
ATOM   1298  N   THR A  88      61.894 -28.812   4.670  1.00  0.00           N  
ATOM   1299  CA  THR A  88      61.230 -27.627   5.198  1.00  0.00           C  
ATOM   1300  C   THR A  88      61.120 -26.540   4.135  1.00  0.00           C  
ATOM   1301  O   THR A  88      61.626 -26.691   3.024  1.00  0.00           O  
ATOM   1302  CB  THR A  88      61.978 -27.061   6.420  1.00  0.00           C  
ATOM   1303  OG1 THR A  88      63.327 -26.742   6.063  1.00  0.00           O  
ATOM   1304  CG2 THR A  88      61.973 -28.060   7.567  1.00  0.00           C  
ATOM   1305  H   THR A  88      62.619 -28.705   4.021  1.00  0.00           H  
ATOM   1306  HA  THR A  88      60.236 -27.913   5.512  1.00  0.00           H  
ATOM   1307  HB  THR A  88      61.476 -26.160   6.744  1.00  0.00           H  
ATOM   1308  HG1 THR A  88      63.636 -27.359   5.395  1.00  0.00           H  
ATOM   1309 HG21 THR A  88      62.421 -27.607   8.440  1.00  0.00           H  
ATOM   1310 HG22 THR A  88      62.540 -28.934   7.285  1.00  0.00           H  
ATOM   1311 HG23 THR A  88      60.957 -28.345   7.791  1.00  0.00           H  
ATOM   1312  N   SER A  89      60.455 -25.443   4.484  1.00  0.00           N  
ATOM   1313  CA  SER A  89      60.275 -24.330   3.559  1.00  0.00           C  
ATOM   1314  C   SER A  89      60.456 -22.995   4.273  1.00  0.00           C  
ATOM   1315  O   SER A  89      59.610 -22.582   5.065  1.00  0.00           O  
ATOM   1316  CB  SER A  89      58.888 -24.393   2.915  1.00  0.00           C  
ATOM   1317  OG  SER A  89      58.667 -25.653   2.304  1.00  0.00           O  
ATOM   1318  H   SER A  89      60.073 -25.382   5.385  1.00  0.00           H  
ATOM   1319  HA  SER A  89      61.025 -24.417   2.786  1.00  0.00           H  
ATOM   1320  HB2 SER A  89      58.135 -24.237   3.672  1.00  0.00           H  
ATOM   1321  HB3 SER A  89      58.809 -23.622   2.163  1.00  0.00           H  
ATOM   1322  HG  SER A  89      59.219 -26.315   2.726  1.00  0.00           H  
ATOM   1323  N   ALA A  90      61.566 -22.322   3.985  1.00  0.00           N  
ATOM   1324  CA  ALA A  90      61.859 -21.032   4.598  1.00  0.00           C  
ATOM   1325  C   ALA A  90      61.120 -19.906   3.883  1.00  0.00           C  
ATOM   1326  O   ALA A  90      60.732 -20.042   2.723  1.00  0.00           O  
ATOM   1327  CB  ALA A  90      63.357 -20.772   4.588  1.00  0.00           C  
ATOM   1328  H   ALA A  90      62.203 -22.702   3.345  1.00  0.00           H  
ATOM   1329  HA  ALA A  90      61.530 -21.069   5.627  1.00  0.00           H  
ATOM   1330  HB1 ALA A  90      63.841 -21.478   3.928  1.00  0.00           H  
ATOM   1331  HB2 ALA A  90      63.547 -19.767   4.243  1.00  0.00           H  
ATOM   1332  HB3 ALA A  90      63.749 -20.889   5.588  1.00  0.00           H  
ATOM   1333  N   PHE A  91      60.927 -18.793   4.584  1.00  0.00           N  
ATOM   1334  CA  PHE A  91      60.233 -17.643   4.018  1.00  0.00           C  
ATOM   1335  C   PHE A  91      61.035 -16.363   4.234  1.00  0.00           C  
ATOM   1336  O   PHE A  91      61.831 -16.266   5.168  1.00  0.00           O  
ATOM   1337  CB  PHE A  91      58.845 -17.500   4.643  1.00  0.00           C  
ATOM   1338  CG  PHE A  91      58.877 -17.213   6.117  1.00  0.00           C  
ATOM   1339  CD1 PHE A  91      59.113 -18.229   7.030  1.00  0.00           C  
ATOM   1340  CD2 PHE A  91      58.674 -15.926   6.590  1.00  0.00           C  
ATOM   1341  CE1 PHE A  91      59.142 -17.966   8.386  1.00  0.00           C  
ATOM   1342  CE2 PHE A  91      58.703 -15.658   7.945  1.00  0.00           C  
ATOM   1343  CZ  PHE A  91      58.938 -16.680   8.844  1.00  0.00           C  
ATOM   1344  H   PHE A  91      61.260 -18.745   5.506  1.00  0.00           H  
ATOM   1345  HA  PHE A  91      60.127 -17.811   2.957  1.00  0.00           H  
ATOM   1346  HB2 PHE A  91      58.321 -16.689   4.159  1.00  0.00           H  
ATOM   1347  HB3 PHE A  91      58.295 -18.417   4.495  1.00  0.00           H  
ATOM   1348  HD1 PHE A  91      59.273 -19.235   6.673  1.00  0.00           H  
ATOM   1349  HD2 PHE A  91      58.489 -15.125   5.887  1.00  0.00           H  
ATOM   1350  HE1 PHE A  91      59.326 -18.767   9.087  1.00  0.00           H  
ATOM   1351  HE2 PHE A  91      58.543 -14.651   8.300  1.00  0.00           H  
ATOM   1352  HZ  PHE A  91      58.961 -16.473   9.904  1.00  0.00           H  
ATOM   1353  N   PHE A  92      60.819 -15.382   3.363  1.00  0.00           N  
ATOM   1354  CA  PHE A  92      61.523 -14.108   3.457  1.00  0.00           C  
ATOM   1355  C   PHE A  92      60.713 -13.099   4.265  1.00  0.00           C  
ATOM   1356  O   PHE A  92      59.485 -13.061   4.180  1.00  0.00           O  
ATOM   1357  CB  PHE A  92      61.803 -13.553   2.059  1.00  0.00           C  
ATOM   1358  CG  PHE A  92      63.085 -14.058   1.460  1.00  0.00           C  
ATOM   1359  CD1 PHE A  92      64.307 -13.564   1.887  1.00  0.00           C  
ATOM   1360  CD2 PHE A  92      63.067 -15.026   0.469  1.00  0.00           C  
ATOM   1361  CE1 PHE A  92      65.487 -14.026   1.336  1.00  0.00           C  
ATOM   1362  CE2 PHE A  92      64.243 -15.492  -0.086  1.00  0.00           C  
ATOM   1363  CZ  PHE A  92      65.455 -14.992   0.350  1.00  0.00           C  
ATOM   1364  H   PHE A  92      60.173 -15.520   2.639  1.00  0.00           H  
ATOM   1365  HA  PHE A  92      62.460 -14.285   3.960  1.00  0.00           H  
ATOM   1366  HB2 PHE A  92      60.997 -13.832   1.400  1.00  0.00           H  
ATOM   1367  HB3 PHE A  92      61.863 -12.476   2.113  1.00  0.00           H  
ATOM   1368  HD1 PHE A  92      64.333 -12.809   2.659  1.00  0.00           H  
ATOM   1369  HD2 PHE A  92      62.118 -15.418   0.127  1.00  0.00           H  
ATOM   1370  HE1 PHE A  92      66.432 -13.635   1.678  1.00  0.00           H  
ATOM   1371  HE2 PHE A  92      64.215 -16.248  -0.857  1.00  0.00           H  
ATOM   1372  HZ  PHE A  92      66.376 -15.356  -0.083  1.00  0.00           H  
ATOM   1373  N   LEU A  93      61.409 -12.283   5.049  1.00  0.00           N  
ATOM   1374  CA  LEU A  93      60.755 -11.272   5.874  1.00  0.00           C  
ATOM   1375  C   LEU A  93      61.574  -9.985   5.908  1.00  0.00           C  
ATOM   1376  O   LEU A  93      62.612  -9.917   6.565  1.00  0.00           O  
ATOM   1377  CB  LEU A  93      60.553 -11.799   7.295  1.00  0.00           C  
ATOM   1378  CG  LEU A  93      59.351 -11.235   8.055  1.00  0.00           C  
ATOM   1379  CD1 LEU A  93      59.309 -11.786   9.472  1.00  0.00           C  
ATOM   1380  CD2 LEU A  93      59.396  -9.714   8.072  1.00  0.00           C  
ATOM   1381  H   LEU A  93      62.385 -12.361   5.075  1.00  0.00           H  
ATOM   1382  HA  LEU A  93      59.792 -11.060   5.436  1.00  0.00           H  
ATOM   1383  HB2 LEU A  93      60.434 -12.870   7.237  1.00  0.00           H  
ATOM   1384  HB3 LEU A  93      61.442 -11.567   7.863  1.00  0.00           H  
ATOM   1385  HG  LEU A  93      58.442 -11.538   7.553  1.00  0.00           H  
ATOM   1386 HD11 LEU A  93      60.316 -11.884   9.849  1.00  0.00           H  
ATOM   1387 HD12 LEU A  93      58.830 -12.754   9.468  1.00  0.00           H  
ATOM   1388 HD13 LEU A  93      58.751 -11.110  10.104  1.00  0.00           H  
ATOM   1389 HD21 LEU A  93      59.023  -9.354   9.019  1.00  0.00           H  
ATOM   1390 HD22 LEU A  93      58.782  -9.326   7.272  1.00  0.00           H  
ATOM   1391 HD23 LEU A  93      60.415  -9.383   7.938  1.00  0.00           H  
ATOM   1392  N   GLU A  94      61.097  -8.967   5.198  1.00  0.00           N  
ATOM   1393  CA  GLU A  94      61.785  -7.683   5.149  1.00  0.00           C  
ATOM   1394  C   GLU A  94      61.072  -6.651   6.018  1.00  0.00           C  
ATOM   1395  O   GLU A  94      59.855  -6.482   5.931  1.00  0.00           O  
ATOM   1396  CB  GLU A  94      61.870  -7.179   3.707  1.00  0.00           C  
ATOM   1397  CG  GLU A  94      62.905  -6.085   3.504  1.00  0.00           C  
ATOM   1398  CD  GLU A  94      63.076  -5.707   2.045  1.00  0.00           C  
ATOM   1399  OE1 GLU A  94      62.812  -6.563   1.175  1.00  0.00           O  
ATOM   1400  OE2 GLU A  94      63.474  -4.555   1.775  1.00  0.00           O  
ATOM   1401  H   GLU A  94      60.265  -9.084   4.695  1.00  0.00           H  
ATOM   1402  HA  GLU A  94      62.785  -7.827   5.530  1.00  0.00           H  
ATOM   1403  HB2 GLU A  94      62.121  -8.008   3.063  1.00  0.00           H  
ATOM   1404  HB3 GLU A  94      60.905  -6.790   3.417  1.00  0.00           H  
ATOM   1405  HG2 GLU A  94      62.596  -5.209   4.053  1.00  0.00           H  
ATOM   1406  HG3 GLU A  94      63.855  -6.431   3.885  1.00  0.00           H  
ATOM   1407  N   THR A  95      61.839  -5.962   6.859  1.00  0.00           N  
ATOM   1408  CA  THR A  95      61.282  -4.948   7.746  1.00  0.00           C  
ATOM   1409  C   THR A  95      62.108  -3.667   7.703  1.00  0.00           C  
ATOM   1410  O   THR A  95      63.333  -3.709   7.583  1.00  0.00           O  
ATOM   1411  CB  THR A  95      61.210  -5.451   9.198  1.00  0.00           C  
ATOM   1412  OG1 THR A  95      62.524  -5.771   9.672  1.00  0.00           O  
ATOM   1413  CG2 THR A  95      60.316  -6.678   9.304  1.00  0.00           C  
ATOM   1414  H   THR A  95      62.802  -6.142   6.881  1.00  0.00           H  
ATOM   1415  HA  THR A  95      60.278  -4.729   7.412  1.00  0.00           H  
ATOM   1416  HB  THR A  95      60.795  -4.667   9.815  1.00  0.00           H  
ATOM   1417  HG1 THR A  95      62.738  -5.213  10.423  1.00  0.00           H  
ATOM   1418 HG21 THR A  95      60.217  -7.135   8.331  1.00  0.00           H  
ATOM   1419 HG22 THR A  95      59.343  -6.382   9.664  1.00  0.00           H  
ATOM   1420 HG23 THR A  95      60.756  -7.384   9.991  1.00  0.00           H  
ATOM   1421  N   LYS A  96      61.430  -2.529   7.801  1.00  0.00           N  
ATOM   1422  CA  LYS A  96      62.100  -1.234   7.776  1.00  0.00           C  
ATOM   1423  C   LYS A  96      63.460  -1.312   8.461  1.00  0.00           C  
ATOM   1424  O   LYS A  96      64.422  -0.683   8.023  1.00  0.00           O  
ATOM   1425  CB  LYS A  96      61.233  -0.174   8.459  1.00  0.00           C  
ATOM   1426  CG  LYS A  96      59.984   0.189   7.674  1.00  0.00           C  
ATOM   1427  CD  LYS A  96      59.135   1.207   8.417  1.00  0.00           C  
ATOM   1428  CE  LYS A  96      57.936   1.644   7.588  1.00  0.00           C  
ATOM   1429  NZ  LYS A  96      57.414   2.968   8.024  1.00  0.00           N  
ATOM   1430  H   LYS A  96      60.454  -2.560   7.894  1.00  0.00           H  
ATOM   1431  HA  LYS A  96      62.246  -0.956   6.743  1.00  0.00           H  
ATOM   1432  HB2 LYS A  96      60.929  -0.544   9.428  1.00  0.00           H  
ATOM   1433  HB3 LYS A  96      61.821   0.722   8.595  1.00  0.00           H  
ATOM   1434  HG2 LYS A  96      60.276   0.605   6.722  1.00  0.00           H  
ATOM   1435  HG3 LYS A  96      59.399  -0.706   7.514  1.00  0.00           H  
ATOM   1436  HD2 LYS A  96      58.781   0.766   9.337  1.00  0.00           H  
ATOM   1437  HD3 LYS A  96      59.741   2.074   8.640  1.00  0.00           H  
ATOM   1438  HE2 LYS A  96      58.236   1.707   6.552  1.00  0.00           H  
ATOM   1439  HE3 LYS A  96      57.155   0.906   7.693  1.00  0.00           H  
ATOM   1440  HZ1 LYS A  96      56.468   3.128   7.624  1.00  0.00           H  
ATOM   1441  HZ2 LYS A  96      58.048   3.727   7.699  1.00  0.00           H  
ATOM   1442  HZ3 LYS A  96      57.352   3.004   9.061  1.00  0.00           H  
ATOM   1443  N   GLU A  97      63.532  -2.089   9.537  1.00  0.00           N  
ATOM   1444  CA  GLU A  97      64.775  -2.250  10.282  1.00  0.00           C  
ATOM   1445  C   GLU A  97      65.813  -2.999   9.452  1.00  0.00           C  
ATOM   1446  O   GLU A  97      66.839  -2.438   9.068  1.00  0.00           O  
ATOM   1447  CB  GLU A  97      64.519  -2.996  11.593  1.00  0.00           C  
ATOM   1448  CG  GLU A  97      65.603  -2.784  12.636  1.00  0.00           C  
ATOM   1449  CD  GLU A  97      65.468  -3.726  13.817  1.00  0.00           C  
ATOM   1450  OE1 GLU A  97      64.322  -4.023  14.212  1.00  0.00           O  
ATOM   1451  OE2 GLU A  97      66.511  -4.166  14.346  1.00  0.00           O  
ATOM   1452  H   GLU A  97      62.730  -2.566   9.838  1.00  0.00           H  
ATOM   1453  HA  GLU A  97      65.156  -1.265  10.507  1.00  0.00           H  
ATOM   1454  HB2 GLU A  97      63.579  -2.659  12.006  1.00  0.00           H  
ATOM   1455  HB3 GLU A  97      64.451  -4.052  11.384  1.00  0.00           H  
ATOM   1456  HG2 GLU A  97      66.566  -2.947  12.174  1.00  0.00           H  
ATOM   1457  HG3 GLU A  97      65.545  -1.768  12.996  1.00  0.00           H  
ATOM   1458  N   ARG A  98      65.540  -4.271   9.181  1.00  0.00           N  
ATOM   1459  CA  ARG A  98      66.449  -5.099   8.399  1.00  0.00           C  
ATOM   1460  C   ARG A  98      65.723  -6.310   7.823  1.00  0.00           C  
ATOM   1461  O   ARG A  98      64.510  -6.453   7.979  1.00  0.00           O  
ATOM   1462  CB  ARG A  98      67.624  -5.559   9.263  1.00  0.00           C  
ATOM   1463  CG  ARG A  98      67.206  -6.387  10.468  1.00  0.00           C  
ATOM   1464  CD  ARG A  98      68.414  -6.890  11.245  1.00  0.00           C  
ATOM   1465  NE  ARG A  98      68.847  -5.936  12.262  1.00  0.00           N  
ATOM   1466  CZ  ARG A  98      69.771  -6.205  13.177  1.00  0.00           C  
ATOM   1467  NH1 ARG A  98      70.357  -7.394  13.201  1.00  0.00           N  
ATOM   1468  NH2 ARG A  98      70.111  -5.284  14.069  1.00  0.00           N  
ATOM   1469  H   ARG A  98      64.705  -4.663   9.516  1.00  0.00           H  
ATOM   1470  HA  ARG A  98      66.827  -4.499   7.585  1.00  0.00           H  
ATOM   1471  HB2 ARG A  98      68.289  -6.157   8.658  1.00  0.00           H  
ATOM   1472  HB3 ARG A  98      68.157  -4.690   9.618  1.00  0.00           H  
ATOM   1473  HG2 ARG A  98      66.602  -5.776  11.122  1.00  0.00           H  
ATOM   1474  HG3 ARG A  98      66.630  -7.234  10.129  1.00  0.00           H  
ATOM   1475  HD2 ARG A  98      68.153  -7.820  11.726  1.00  0.00           H  
ATOM   1476  HD3 ARG A  98      69.225  -7.057  10.552  1.00  0.00           H  
ATOM   1477  HE  ARG A  98      68.426  -5.050  12.262  1.00  0.00           H  
ATOM   1478 HH11 ARG A  98      70.103  -8.090  12.529  1.00  0.00           H  
ATOM   1479 HH12 ARG A  98      71.053  -7.594  13.891  1.00  0.00           H  
ATOM   1480 HH21 ARG A  98      69.671  -4.387  14.054  1.00  0.00           H  
ATOM   1481 HH22 ARG A  98      70.806  -5.488  14.757  1.00  0.00           H  
ATOM   1482  N   LEU A  99      66.472  -7.181   7.154  1.00  0.00           N  
ATOM   1483  CA  LEU A  99      65.900  -8.380   6.553  1.00  0.00           C  
ATOM   1484  C   LEU A  99      66.179  -9.607   7.415  1.00  0.00           C  
ATOM   1485  O   LEU A  99      67.333  -9.924   7.707  1.00  0.00           O  
ATOM   1486  CB  LEU A  99      66.466  -8.590   5.149  1.00  0.00           C  
ATOM   1487  CG  LEU A  99      65.982  -9.838   4.409  1.00  0.00           C  
ATOM   1488  CD1 LEU A  99      64.607  -9.602   3.805  1.00  0.00           C  
ATOM   1489  CD2 LEU A  99      66.978 -10.240   3.331  1.00  0.00           C  
ATOM   1490  H   LEU A  99      67.433  -7.013   7.063  1.00  0.00           H  
ATOM   1491  HA  LEU A  99      64.831  -8.239   6.484  1.00  0.00           H  
ATOM   1492  HB2 LEU A  99      66.201  -7.731   4.553  1.00  0.00           H  
ATOM   1493  HB3 LEU A  99      67.542  -8.651   5.232  1.00  0.00           H  
ATOM   1494  HG  LEU A  99      65.901 -10.656   5.111  1.00  0.00           H  
ATOM   1495 HD11 LEU A  99      64.064 -10.534   3.768  1.00  0.00           H  
ATOM   1496 HD12 LEU A  99      64.715  -9.208   2.805  1.00  0.00           H  
ATOM   1497 HD13 LEU A  99      64.064  -8.893   4.414  1.00  0.00           H  
ATOM   1498 HD21 LEU A  99      66.465 -10.781   2.550  1.00  0.00           H  
ATOM   1499 HD22 LEU A  99      67.742 -10.871   3.763  1.00  0.00           H  
ATOM   1500 HD23 LEU A  99      67.435  -9.354   2.915  1.00  0.00           H  
ATOM   1501  N   TYR A 100      65.116 -10.295   7.818  1.00  0.00           N  
ATOM   1502  CA  TYR A 100      65.247 -11.488   8.647  1.00  0.00           C  
ATOM   1503  C   TYR A 100      64.893 -12.742   7.854  1.00  0.00           C  
ATOM   1504  O   TYR A 100      63.805 -12.848   7.288  1.00  0.00           O  
ATOM   1505  CB  TYR A 100      64.346 -11.379   9.879  1.00  0.00           C  
ATOM   1506  CG  TYR A 100      64.702 -10.225  10.789  1.00  0.00           C  
ATOM   1507  CD1 TYR A 100      65.669 -10.365  11.776  1.00  0.00           C  
ATOM   1508  CD2 TYR A 100      64.070  -8.993  10.660  1.00  0.00           C  
ATOM   1509  CE1 TYR A 100      65.996  -9.313  12.610  1.00  0.00           C  
ATOM   1510  CE2 TYR A 100      64.392  -7.936  11.488  1.00  0.00           C  
ATOM   1511  CZ  TYR A 100      65.355  -8.101  12.462  1.00  0.00           C  
ATOM   1512  OH  TYR A 100      65.679  -7.050  13.290  1.00  0.00           O  
ATOM   1513  H   TYR A 100      64.222  -9.993   7.553  1.00  0.00           H  
ATOM   1514  HA  TYR A 100      66.274 -11.556   8.970  1.00  0.00           H  
ATOM   1515  HB2 TYR A 100      63.324 -11.246   9.558  1.00  0.00           H  
ATOM   1516  HB3 TYR A 100      64.423 -12.291  10.453  1.00  0.00           H  
ATOM   1517  HD1 TYR A 100      66.169 -11.316  11.888  1.00  0.00           H  
ATOM   1518  HD2 TYR A 100      63.317  -8.867   9.896  1.00  0.00           H  
ATOM   1519  HE1 TYR A 100      66.751  -9.442  13.372  1.00  0.00           H  
ATOM   1520  HE2 TYR A 100      63.890  -6.987  11.373  1.00  0.00           H  
ATOM   1521  HH  TYR A 100      64.886  -6.553  13.500  1.00  0.00           H  
ATOM   1522  N   LEU A 101      65.822 -13.692   7.819  1.00  0.00           N  
ATOM   1523  CA  LEU A 101      65.611 -14.943   7.098  1.00  0.00           C  
ATOM   1524  C   LEU A 101      65.276 -16.077   8.060  1.00  0.00           C  
ATOM   1525  O   LEU A 101      66.167 -16.705   8.631  1.00  0.00           O  
ATOM   1526  CB  LEU A 101      66.855 -15.300   6.284  1.00  0.00           C  
ATOM   1527  CG  LEU A 101      66.753 -16.555   5.417  1.00  0.00           C  
ATOM   1528  CD1 LEU A 101      65.613 -16.423   4.418  1.00  0.00           C  
ATOM   1529  CD2 LEU A 101      68.068 -16.815   4.696  1.00  0.00           C  
ATOM   1530  H   LEU A 101      66.670 -13.551   8.291  1.00  0.00           H  
ATOM   1531  HA  LEU A 101      64.779 -14.799   6.425  1.00  0.00           H  
ATOM   1532  HB2 LEU A 101      67.076 -14.467   5.634  1.00  0.00           H  
ATOM   1533  HB3 LEU A 101      67.673 -15.441   6.976  1.00  0.00           H  
ATOM   1534  HG  LEU A 101      66.543 -17.407   6.051  1.00  0.00           H  
ATOM   1535 HD11 LEU A 101      64.907 -17.224   4.570  1.00  0.00           H  
ATOM   1536 HD12 LEU A 101      66.007 -16.474   3.414  1.00  0.00           H  
ATOM   1537 HD13 LEU A 101      65.118 -15.474   4.562  1.00  0.00           H  
ATOM   1538 HD21 LEU A 101      68.573 -15.877   4.519  1.00  0.00           H  
ATOM   1539 HD22 LEU A 101      67.871 -17.304   3.752  1.00  0.00           H  
ATOM   1540 HD23 LEU A 101      68.693 -17.451   5.307  1.00  0.00           H  
ATOM   1541  N   LEU A 102      63.985 -16.335   8.234  1.00  0.00           N  
ATOM   1542  CA  LEU A 102      63.530 -17.397   9.126  1.00  0.00           C  
ATOM   1543  C   LEU A 102      63.165 -18.651   8.338  1.00  0.00           C  
ATOM   1544  O   LEU A 102      62.990 -18.602   7.121  1.00  0.00           O  
ATOM   1545  CB  LEU A 102      62.325 -16.924   9.940  1.00  0.00           C  
ATOM   1546  CG  LEU A 102      62.606 -15.859  11.000  1.00  0.00           C  
ATOM   1547  CD1 LEU A 102      62.523 -14.467  10.393  1.00  0.00           C  
ATOM   1548  CD2 LEU A 102      61.635 -15.994  12.164  1.00  0.00           C  
ATOM   1549  H   LEU A 102      63.320 -15.801   7.752  1.00  0.00           H  
ATOM   1550  HA  LEU A 102      64.340 -17.632   9.800  1.00  0.00           H  
ATOM   1551  HB2 LEU A 102      61.597 -16.521   9.252  1.00  0.00           H  
ATOM   1552  HB3 LEU A 102      61.905 -17.786  10.439  1.00  0.00           H  
ATOM   1553  HG  LEU A 102      63.608 -15.996  11.382  1.00  0.00           H  
ATOM   1554 HD11 LEU A 102      63.184 -14.405   9.542  1.00  0.00           H  
ATOM   1555 HD12 LEU A 102      62.816 -13.735  11.130  1.00  0.00           H  
ATOM   1556 HD13 LEU A 102      61.509 -14.272  10.076  1.00  0.00           H  
ATOM   1557 HD21 LEU A 102      61.841 -15.226  12.895  1.00  0.00           H  
ATOM   1558 HD22 LEU A 102      61.753 -16.966  12.621  1.00  0.00           H  
ATOM   1559 HD23 LEU A 102      60.623 -15.886  11.802  1.00  0.00           H  
ATOM   1560  N   ALA A 103      63.051 -19.773   9.042  1.00  0.00           N  
ATOM   1561  CA  ALA A 103      62.704 -21.039   8.409  1.00  0.00           C  
ATOM   1562  C   ALA A 103      61.430 -21.622   9.010  1.00  0.00           C  
ATOM   1563  O   ALA A 103      61.205 -21.535  10.217  1.00  0.00           O  
ATOM   1564  CB  ALA A 103      63.852 -22.028   8.542  1.00  0.00           C  
ATOM   1565  H   ALA A 103      63.204 -19.748  10.009  1.00  0.00           H  
ATOM   1566  HA  ALA A 103      62.541 -20.853   7.356  1.00  0.00           H  
ATOM   1567  HB1 ALA A 103      64.587 -21.830   7.775  1.00  0.00           H  
ATOM   1568  HB2 ALA A 103      64.308 -21.922   9.515  1.00  0.00           H  
ATOM   1569  HB3 ALA A 103      63.475 -23.034   8.428  1.00  0.00           H  
ATOM   1570  N   ALA A 104      60.598 -22.216   8.160  1.00  0.00           N  
ATOM   1571  CA  ALA A 104      59.345 -22.813   8.609  1.00  0.00           C  
ATOM   1572  C   ALA A 104      59.085 -24.138   7.900  1.00  0.00           C  
ATOM   1573  O   ALA A 104      59.550 -24.374   6.785  1.00  0.00           O  
ATOM   1574  CB  ALA A 104      58.189 -21.852   8.378  1.00  0.00           C  
ATOM   1575  H   ALA A 104      60.831 -22.253   7.210  1.00  0.00           H  
ATOM   1576  HA  ALA A 104      59.424 -22.995   9.671  1.00  0.00           H  
ATOM   1577  HB1 ALA A 104      57.280 -22.415   8.225  1.00  0.00           H  
ATOM   1578  HB2 ALA A 104      58.077 -21.212   9.241  1.00  0.00           H  
ATOM   1579  HB3 ALA A 104      58.391 -21.250   7.505  1.00  0.00           H  
ATOM   1580  N   PRO A 105      58.324 -25.023   8.560  1.00  0.00           N  
ATOM   1581  CA  PRO A 105      57.985 -26.340   8.011  1.00  0.00           C  
ATOM   1582  C   PRO A 105      57.023 -26.245   6.831  1.00  0.00           C  
ATOM   1583  O   PRO A 105      55.957 -25.640   6.934  1.00  0.00           O  
ATOM   1584  CB  PRO A 105      57.317 -27.054   9.188  1.00  0.00           C  
ATOM   1585  CG  PRO A 105      56.777 -25.957  10.040  1.00  0.00           C  
ATOM   1586  CD  PRO A 105      57.736 -24.808   9.893  1.00  0.00           C  
ATOM   1587  HA  PRO A 105      58.868 -26.885   7.711  1.00  0.00           H  
ATOM   1588  HB2 PRO A 105      56.529 -27.696   8.823  1.00  0.00           H  
ATOM   1589  HB3 PRO A 105      58.050 -27.642   9.720  1.00  0.00           H  
ATOM   1590  HG2 PRO A 105      55.795 -25.673   9.694  1.00  0.00           H  
ATOM   1591  HG3 PRO A 105      56.735 -26.280  11.070  1.00  0.00           H  
ATOM   1592  HD2 PRO A 105      57.208 -23.868   9.933  1.00  0.00           H  
ATOM   1593  HD3 PRO A 105      58.496 -24.850  10.660  1.00  0.00           H  
ATOM   1594  N   ALA A 106      57.408 -26.847   5.710  1.00  0.00           N  
ATOM   1595  CA  ALA A 106      56.579 -26.833   4.512  1.00  0.00           C  
ATOM   1596  C   ALA A 106      55.107 -27.029   4.860  1.00  0.00           C  
ATOM   1597  O   ALA A 106      54.221 -26.614   4.111  1.00  0.00           O  
ATOM   1598  CB  ALA A 106      57.039 -27.907   3.538  1.00  0.00           C  
ATOM   1599  H   ALA A 106      58.269 -27.314   5.690  1.00  0.00           H  
ATOM   1600  HA  ALA A 106      56.700 -25.871   4.033  1.00  0.00           H  
ATOM   1601  HB1 ALA A 106      56.443 -28.797   3.676  1.00  0.00           H  
ATOM   1602  HB2 ALA A 106      56.924 -27.549   2.526  1.00  0.00           H  
ATOM   1603  HB3 ALA A 106      58.078 -28.137   3.723  1.00  0.00           H  
ATOM   1604  N   ALA A 107      54.853 -27.661   6.000  1.00  0.00           N  
ATOM   1605  CA  ALA A 107      53.488 -27.911   6.448  1.00  0.00           C  
ATOM   1606  C   ALA A 107      52.816 -26.621   6.904  1.00  0.00           C  
ATOM   1607  O   ALA A 107      51.702 -26.310   6.485  1.00  0.00           O  
ATOM   1608  CB  ALA A 107      53.480 -28.938   7.570  1.00  0.00           C  
ATOM   1609  H   ALA A 107      55.601 -27.968   6.554  1.00  0.00           H  
ATOM   1610  HA  ALA A 107      52.933 -28.319   5.616  1.00  0.00           H  
ATOM   1611  HB1 ALA A 107      52.545 -29.478   7.556  1.00  0.00           H  
ATOM   1612  HB2 ALA A 107      54.298 -29.629   7.432  1.00  0.00           H  
ATOM   1613  HB3 ALA A 107      53.590 -28.435   8.519  1.00  0.00           H  
ATOM   1614  N   GLU A 108      53.501 -25.874   7.765  1.00  0.00           N  
ATOM   1615  CA  GLU A 108      52.967 -24.618   8.279  1.00  0.00           C  
ATOM   1616  C   GLU A 108      53.190 -23.484   7.282  1.00  0.00           C  
ATOM   1617  O   GLU A 108      52.286 -22.694   7.013  1.00  0.00           O  
ATOM   1618  CB  GLU A 108      53.621 -24.270   9.618  1.00  0.00           C  
ATOM   1619  CG  GLU A 108      53.597 -25.412  10.621  1.00  0.00           C  
ATOM   1620  CD  GLU A 108      52.335 -25.422  11.462  1.00  0.00           C  
ATOM   1621  OE1 GLU A 108      52.201 -24.545  12.342  1.00  0.00           O  
ATOM   1622  OE2 GLU A 108      51.483 -26.307  11.243  1.00  0.00           O  
ATOM   1623  H   GLU A 108      54.384 -26.176   8.062  1.00  0.00           H  
ATOM   1624  HA  GLU A 108      51.906 -24.745   8.430  1.00  0.00           H  
ATOM   1625  HB2 GLU A 108      54.651 -23.995   9.442  1.00  0.00           H  
ATOM   1626  HB3 GLU A 108      53.102 -23.428  10.050  1.00  0.00           H  
ATOM   1627  HG2 GLU A 108      53.662 -26.346  10.086  1.00  0.00           H  
ATOM   1628  HG3 GLU A 108      54.449 -25.315  11.278  1.00  0.00           H  
ATOM   1629  N   ARG A 109      54.401 -23.411   6.739  1.00  0.00           N  
ATOM   1630  CA  ARG A 109      54.745 -22.373   5.774  1.00  0.00           C  
ATOM   1631  C   ARG A 109      53.545 -22.029   4.897  1.00  0.00           C  
ATOM   1632  O   ARG A 109      53.096 -20.883   4.863  1.00  0.00           O  
ATOM   1633  CB  ARG A 109      55.915 -22.828   4.900  1.00  0.00           C  
ATOM   1634  CG  ARG A 109      56.700 -21.679   4.288  1.00  0.00           C  
ATOM   1635  CD  ARG A 109      55.998 -21.114   3.064  1.00  0.00           C  
ATOM   1636  NE  ARG A 109      55.752 -22.138   2.052  1.00  0.00           N  
ATOM   1637  CZ  ARG A 109      54.863 -22.007   1.074  1.00  0.00           C  
ATOM   1638  NH1 ARG A 109      54.139 -20.900   0.976  1.00  0.00           N  
ATOM   1639  NH2 ARG A 109      54.698 -22.983   0.191  1.00  0.00           N  
ATOM   1640  H   ARG A 109      55.081 -24.070   6.994  1.00  0.00           H  
ATOM   1641  HA  ARG A 109      55.039 -21.493   6.324  1.00  0.00           H  
ATOM   1642  HB2 ARG A 109      56.591 -23.417   5.502  1.00  0.00           H  
ATOM   1643  HB3 ARG A 109      55.533 -23.441   4.098  1.00  0.00           H  
ATOM   1644  HG2 ARG A 109      56.805 -20.895   5.024  1.00  0.00           H  
ATOM   1645  HG3 ARG A 109      57.677 -22.037   3.999  1.00  0.00           H  
ATOM   1646  HD2 ARG A 109      55.053 -20.691   3.371  1.00  0.00           H  
ATOM   1647  HD3 ARG A 109      56.616 -20.339   2.637  1.00  0.00           H  
ATOM   1648  HE  ARG A 109      56.277 -22.964   2.105  1.00  0.00           H  
ATOM   1649 HH11 ARG A 109      54.262 -20.162   1.639  1.00  0.00           H  
ATOM   1650 HH12 ARG A 109      53.470 -20.803   0.238  1.00  0.00           H  
ATOM   1651 HH21 ARG A 109      55.241 -23.818   0.261  1.00  0.00           H  
ATOM   1652 HH22 ARG A 109      54.028 -22.883  -0.545  1.00  0.00           H  
ATOM   1653  N   GLY A 110      53.029 -23.029   4.187  1.00  0.00           N  
ATOM   1654  CA  GLY A 110      51.887 -22.810   3.319  1.00  0.00           C  
ATOM   1655  C   GLY A 110      50.890 -21.832   3.908  1.00  0.00           C  
ATOM   1656  O   GLY A 110      50.531 -20.843   3.269  1.00  0.00           O  
ATOM   1657  H   GLY A 110      53.429 -23.922   4.254  1.00  0.00           H  
ATOM   1658  HA2 GLY A 110      52.236 -22.428   2.373  1.00  0.00           H  
ATOM   1659  HA3 GLY A 110      51.391 -23.756   3.153  1.00  0.00           H  
ATOM   1660  N   ASP A 111      50.442 -22.107   5.127  1.00  0.00           N  
ATOM   1661  CA  ASP A 111      49.480 -21.244   5.802  1.00  0.00           C  
ATOM   1662  C   ASP A 111      50.148 -19.960   6.284  1.00  0.00           C  
ATOM   1663  O   ASP A 111      49.625 -18.863   6.081  1.00  0.00           O  
ATOM   1664  CB  ASP A 111      48.844 -21.978   6.984  1.00  0.00           C  
ATOM   1665  CG  ASP A 111      47.624 -22.781   6.578  1.00  0.00           C  
ATOM   1666  OD1 ASP A 111      47.791 -23.801   5.878  1.00  0.00           O  
ATOM   1667  OD2 ASP A 111      46.503 -22.389   6.962  1.00  0.00           O  
ATOM   1668  H   ASP A 111      50.767 -22.911   5.585  1.00  0.00           H  
ATOM   1669  HA  ASP A 111      48.708 -20.989   5.092  1.00  0.00           H  
ATOM   1670  HB2 ASP A 111      49.570 -22.653   7.413  1.00  0.00           H  
ATOM   1671  HB3 ASP A 111      48.547 -21.256   7.730  1.00  0.00           H  
ATOM   1672  N   TRP A 112      51.303 -20.103   6.923  1.00  0.00           N  
ATOM   1673  CA  TRP A 112      52.041 -18.954   7.435  1.00  0.00           C  
ATOM   1674  C   TRP A 112      52.056 -17.819   6.418  1.00  0.00           C  
ATOM   1675  O   TRP A 112      51.376 -16.808   6.592  1.00  0.00           O  
ATOM   1676  CB  TRP A 112      53.474 -19.358   7.788  1.00  0.00           C  
ATOM   1677  CG  TRP A 112      53.621 -19.855   9.194  1.00  0.00           C  
ATOM   1678  CD1 TRP A 112      54.186 -21.033   9.592  1.00  0.00           C  
ATOM   1679  CD2 TRP A 112      53.196 -19.189  10.388  1.00  0.00           C  
ATOM   1680  NE1 TRP A 112      54.137 -21.140  10.961  1.00  0.00           N  
ATOM   1681  CE2 TRP A 112      53.536 -20.021  11.473  1.00  0.00           C  
ATOM   1682  CE3 TRP A 112      52.563 -17.970  10.647  1.00  0.00           C  
ATOM   1683  CZ2 TRP A 112      53.263 -19.672  12.793  1.00  0.00           C  
ATOM   1684  CZ3 TRP A 112      52.293 -17.624  11.957  1.00  0.00           C  
ATOM   1685  CH2 TRP A 112      52.642 -18.472  13.016  1.00  0.00           C  
ATOM   1686  H   TRP A 112      51.669 -21.004   7.054  1.00  0.00           H  
ATOM   1687  HA  TRP A 112      51.542 -18.613   8.331  1.00  0.00           H  
ATOM   1688  HB2 TRP A 112      53.793 -20.144   7.121  1.00  0.00           H  
ATOM   1689  HB3 TRP A 112      54.121 -18.502   7.667  1.00  0.00           H  
ATOM   1690  HD1 TRP A 112      54.603 -21.766   8.918  1.00  0.00           H  
ATOM   1691  HE1 TRP A 112      54.479 -21.894  11.485  1.00  0.00           H  
ATOM   1692  HE3 TRP A 112      52.286 -17.304   9.843  1.00  0.00           H  
ATOM   1693  HZ2 TRP A 112      53.526 -20.313  13.620  1.00  0.00           H  
ATOM   1694  HZ3 TRP A 112      51.803 -16.686  12.176  1.00  0.00           H  
ATOM   1695  HH2 TRP A 112      52.411 -18.162  14.024  1.00  0.00           H  
ATOM   1696  N   VAL A 113      52.834 -17.994   5.355  1.00  0.00           N  
ATOM   1697  CA  VAL A 113      52.935 -16.983   4.308  1.00  0.00           C  
ATOM   1698  C   VAL A 113      51.568 -16.395   3.977  1.00  0.00           C  
ATOM   1699  O   VAL A 113      51.407 -15.177   3.906  1.00  0.00           O  
ATOM   1700  CB  VAL A 113      53.556 -17.566   3.024  1.00  0.00           C  
ATOM   1701  CG1 VAL A 113      53.599 -16.514   1.926  1.00  0.00           C  
ATOM   1702  CG2 VAL A 113      54.947 -18.112   3.306  1.00  0.00           C  
ATOM   1703  H   VAL A 113      53.351 -18.821   5.271  1.00  0.00           H  
ATOM   1704  HA  VAL A 113      53.579 -16.193   4.667  1.00  0.00           H  
ATOM   1705  HB  VAL A 113      52.934 -18.382   2.686  1.00  0.00           H  
ATOM   1706 HG11 VAL A 113      54.597 -16.109   1.856  1.00  0.00           H  
ATOM   1707 HG12 VAL A 113      53.323 -16.964   0.984  1.00  0.00           H  
ATOM   1708 HG13 VAL A 113      52.905 -15.719   2.162  1.00  0.00           H  
ATOM   1709 HG21 VAL A 113      55.644 -17.291   3.397  1.00  0.00           H  
ATOM   1710 HG22 VAL A 113      54.934 -18.676   4.227  1.00  0.00           H  
ATOM   1711 HG23 VAL A 113      55.253 -18.755   2.495  1.00  0.00           H  
ATOM   1712  N   GLN A 114      50.587 -17.270   3.775  1.00  0.00           N  
ATOM   1713  CA  GLN A 114      49.233 -16.836   3.452  1.00  0.00           C  
ATOM   1714  C   GLN A 114      48.713 -15.852   4.494  1.00  0.00           C  
ATOM   1715  O   GLN A 114      48.413 -14.701   4.179  1.00  0.00           O  
ATOM   1716  CB  GLN A 114      48.297 -18.042   3.360  1.00  0.00           C  
ATOM   1717  CG  GLN A 114      47.027 -17.769   2.571  1.00  0.00           C  
ATOM   1718  CD  GLN A 114      46.464 -19.016   1.920  1.00  0.00           C  
ATOM   1719  OE1 GLN A 114      47.199 -19.957   1.614  1.00  0.00           O  
ATOM   1720  NE2 GLN A 114      45.154 -19.033   1.706  1.00  0.00           N  
ATOM   1721  H   GLN A 114      50.779 -18.228   3.846  1.00  0.00           H  
ATOM   1722  HA  GLN A 114      49.264 -16.342   2.492  1.00  0.00           H  
ATOM   1723  HB2 GLN A 114      48.823 -18.856   2.884  1.00  0.00           H  
ATOM   1724  HB3 GLN A 114      48.017 -18.341   4.359  1.00  0.00           H  
ATOM   1725  HG2 GLN A 114      46.282 -17.363   3.240  1.00  0.00           H  
ATOM   1726  HG3 GLN A 114      47.248 -17.046   1.799  1.00  0.00           H  
ATOM   1727 HE21 GLN A 114      44.631 -18.248   1.974  1.00  0.00           H  
ATOM   1728 HE22 GLN A 114      44.763 -19.826   1.286  1.00  0.00           H  
ATOM   1729  N   ALA A 115      48.609 -16.313   5.736  1.00  0.00           N  
ATOM   1730  CA  ALA A 115      48.126 -15.473   6.825  1.00  0.00           C  
ATOM   1731  C   ALA A 115      48.960 -14.201   6.947  1.00  0.00           C  
ATOM   1732  O   ALA A 115      48.429 -13.091   6.870  1.00  0.00           O  
ATOM   1733  CB  ALA A 115      48.143 -16.245   8.135  1.00  0.00           C  
ATOM   1734  H   ALA A 115      48.864 -17.239   5.925  1.00  0.00           H  
ATOM   1735  HA  ALA A 115      47.103 -15.201   6.609  1.00  0.00           H  
ATOM   1736  HB1 ALA A 115      48.474 -15.594   8.932  1.00  0.00           H  
ATOM   1737  HB2 ALA A 115      47.150 -16.605   8.354  1.00  0.00           H  
ATOM   1738  HB3 ALA A 115      48.820 -17.082   8.051  1.00  0.00           H  
ATOM   1739  N   ILE A 116      50.263 -14.369   7.140  1.00  0.00           N  
ATOM   1740  CA  ILE A 116      51.168 -13.235   7.273  1.00  0.00           C  
ATOM   1741  C   ILE A 116      50.928 -12.207   6.171  1.00  0.00           C  
ATOM   1742  O   ILE A 116      50.720 -11.025   6.444  1.00  0.00           O  
ATOM   1743  CB  ILE A 116      52.641 -13.681   7.230  1.00  0.00           C  
ATOM   1744  CG1 ILE A 116      52.989 -14.483   8.486  1.00  0.00           C  
ATOM   1745  CG2 ILE A 116      53.557 -12.474   7.095  1.00  0.00           C  
ATOM   1746  CD1 ILE A 116      54.322 -15.193   8.399  1.00  0.00           C  
ATOM   1747  H   ILE A 116      50.625 -15.278   7.194  1.00  0.00           H  
ATOM   1748  HA  ILE A 116      50.981 -12.769   8.230  1.00  0.00           H  
ATOM   1749  HB  ILE A 116      52.779 -14.307   6.362  1.00  0.00           H  
ATOM   1750 HG12 ILE A 116      53.024 -13.817   9.333  1.00  0.00           H  
ATOM   1751 HG13 ILE A 116      52.226 -15.230   8.651  1.00  0.00           H  
ATOM   1752 HG21 ILE A 116      54.278 -12.478   7.900  1.00  0.00           H  
ATOM   1753 HG22 ILE A 116      54.074 -12.519   6.150  1.00  0.00           H  
ATOM   1754 HG23 ILE A 116      52.970 -11.569   7.143  1.00  0.00           H  
ATOM   1755 HD11 ILE A 116      54.467 -15.569   7.397  1.00  0.00           H  
ATOM   1756 HD12 ILE A 116      55.116 -14.501   8.643  1.00  0.00           H  
ATOM   1757 HD13 ILE A 116      54.338 -16.018   9.097  1.00  0.00           H  
ATOM   1758  N   CYS A 117      50.957 -12.669   4.925  1.00  0.00           N  
ATOM   1759  CA  CYS A 117      50.741 -11.790   3.780  1.00  0.00           C  
ATOM   1760  C   CYS A 117      49.339 -11.189   3.812  1.00  0.00           C  
ATOM   1761  O   CYS A 117      49.106 -10.102   3.282  1.00  0.00           O  
ATOM   1762  CB  CYS A 117      50.949 -12.559   2.475  1.00  0.00           C  
ATOM   1763  SG  CYS A 117      51.312 -11.508   1.049  1.00  0.00           S  
ATOM   1764  H   CYS A 117      51.127 -13.620   4.771  1.00  0.00           H  
ATOM   1765  HA  CYS A 117      51.464 -10.990   3.837  1.00  0.00           H  
ATOM   1766  HB2 CYS A 117      51.776 -13.243   2.597  1.00  0.00           H  
ATOM   1767  HB3 CYS A 117      50.055 -13.121   2.251  1.00  0.00           H  
ATOM   1768  HG  CYS A 117      51.842 -12.270   0.104  1.00  0.00           H  
ATOM   1769  N   LEU A 118      48.409 -11.903   4.437  1.00  0.00           N  
ATOM   1770  CA  LEU A 118      47.029 -11.441   4.538  1.00  0.00           C  
ATOM   1771  C   LEU A 118      46.901 -10.331   5.575  1.00  0.00           C  
ATOM   1772  O   LEU A 118      46.089  -9.417   5.424  1.00  0.00           O  
ATOM   1773  CB  LEU A 118      46.106 -12.605   4.902  1.00  0.00           C  
ATOM   1774  CG  LEU A 118      45.561 -13.422   3.731  1.00  0.00           C  
ATOM   1775  CD1 LEU A 118      45.042 -14.768   4.214  1.00  0.00           C  
ATOM   1776  CD2 LEU A 118      44.463 -12.654   3.010  1.00  0.00           C  
ATOM   1777  H   LEU A 118      48.655 -12.761   4.840  1.00  0.00           H  
ATOM   1778  HA  LEU A 118      46.739 -11.051   3.572  1.00  0.00           H  
ATOM   1779  HB2 LEU A 118      46.657 -13.275   5.544  1.00  0.00           H  
ATOM   1780  HB3 LEU A 118      45.264 -12.201   5.445  1.00  0.00           H  
ATOM   1781  HG  LEU A 118      46.359 -13.607   3.026  1.00  0.00           H  
ATOM   1782 HD11 LEU A 118      44.716 -14.681   5.240  1.00  0.00           H  
ATOM   1783 HD12 LEU A 118      45.831 -15.502   4.149  1.00  0.00           H  
ATOM   1784 HD13 LEU A 118      44.211 -15.076   3.595  1.00  0.00           H  
ATOM   1785 HD21 LEU A 118      44.906 -11.871   2.412  1.00  0.00           H  
ATOM   1786 HD22 LEU A 118      43.793 -12.216   3.736  1.00  0.00           H  
ATOM   1787 HD23 LEU A 118      43.911 -13.327   2.371  1.00  0.00           H  
ATOM   1788  N   LEU A 119      47.708 -10.414   6.626  1.00  0.00           N  
ATOM   1789  CA  LEU A 119      47.688  -9.415   7.688  1.00  0.00           C  
ATOM   1790  C   LEU A 119      48.723  -8.325   7.431  1.00  0.00           C  
ATOM   1791  O   LEU A 119      48.379  -7.157   7.251  1.00  0.00           O  
ATOM   1792  CB  LEU A 119      47.951 -10.075   9.042  1.00  0.00           C  
ATOM   1793  CG  LEU A 119      46.733 -10.681   9.742  1.00  0.00           C  
ATOM   1794  CD1 LEU A 119      47.169 -11.592  10.879  1.00  0.00           C  
ATOM   1795  CD2 LEU A 119      45.815  -9.582  10.259  1.00  0.00           C  
ATOM   1796  H   LEU A 119      48.334 -11.165   6.690  1.00  0.00           H  
ATOM   1797  HA  LEU A 119      46.705  -8.965   7.701  1.00  0.00           H  
ATOM   1798  HB2 LEU A 119      48.670 -10.865   8.890  1.00  0.00           H  
ATOM   1799  HB3 LEU A 119      48.372  -9.327   9.698  1.00  0.00           H  
ATOM   1800  HG  LEU A 119      46.176 -11.276   9.032  1.00  0.00           H  
ATOM   1801 HD11 LEU A 119      48.049 -11.183  11.351  1.00  0.00           H  
ATOM   1802 HD12 LEU A 119      47.392 -12.573  10.486  1.00  0.00           H  
ATOM   1803 HD13 LEU A 119      46.372 -11.668  11.605  1.00  0.00           H  
ATOM   1804 HD21 LEU A 119      46.033  -9.391  11.300  1.00  0.00           H  
ATOM   1805 HD22 LEU A 119      44.785  -9.897  10.160  1.00  0.00           H  
ATOM   1806 HD23 LEU A 119      45.974  -8.680   9.686  1.00  0.00           H  
ATOM   1807  N   ALA A 120      49.993  -8.715   7.414  1.00  0.00           N  
ATOM   1808  CA  ALA A 120      51.079  -7.773   7.174  1.00  0.00           C  
ATOM   1809  C   ALA A 120      50.745  -6.831   6.022  1.00  0.00           C  
ATOM   1810  O   ALA A 120      51.041  -5.638   6.077  1.00  0.00           O  
ATOM   1811  CB  ALA A 120      52.374  -8.520   6.889  1.00  0.00           C  
ATOM   1812  H   ALA A 120      50.205  -9.660   7.564  1.00  0.00           H  
ATOM   1813  HA  ALA A 120      51.219  -7.189   8.074  1.00  0.00           H  
ATOM   1814  HB1 ALA A 120      53.160  -8.127   7.516  1.00  0.00           H  
ATOM   1815  HB2 ALA A 120      52.236  -9.571   7.099  1.00  0.00           H  
ATOM   1816  HB3 ALA A 120      52.641  -8.392   5.852  1.00  0.00           H  
ATOM   1817  N   PHE A 121      50.127  -7.376   4.979  1.00  0.00           N  
ATOM   1818  CA  PHE A 121      49.755  -6.585   3.813  1.00  0.00           C  
ATOM   1819  C   PHE A 121      48.240  -6.420   3.729  1.00  0.00           C  
ATOM   1820  O   PHE A 121      47.653  -6.516   2.652  1.00  0.00           O  
ATOM   1821  CB  PHE A 121      50.278  -7.243   2.535  1.00  0.00           C  
ATOM   1822  CG  PHE A 121      51.750  -7.543   2.575  1.00  0.00           C  
ATOM   1823  CD1 PHE A 121      52.253  -8.489   3.453  1.00  0.00           C  
ATOM   1824  CD2 PHE A 121      52.629  -6.879   1.735  1.00  0.00           C  
ATOM   1825  CE1 PHE A 121      53.607  -8.767   3.493  1.00  0.00           C  
ATOM   1826  CE2 PHE A 121      53.983  -7.154   1.769  1.00  0.00           C  
ATOM   1827  CZ  PHE A 121      54.472  -8.098   2.650  1.00  0.00           C  
ATOM   1828  H   PHE A 121      49.917  -8.334   4.995  1.00  0.00           H  
ATOM   1829  HA  PHE A 121      50.205  -5.610   3.917  1.00  0.00           H  
ATOM   1830  HB2 PHE A 121      49.755  -8.174   2.376  1.00  0.00           H  
ATOM   1831  HB3 PHE A 121      50.095  -6.585   1.699  1.00  0.00           H  
ATOM   1832  HD1 PHE A 121      51.576  -9.013   4.114  1.00  0.00           H  
ATOM   1833  HD2 PHE A 121      52.248  -6.139   1.046  1.00  0.00           H  
ATOM   1834  HE1 PHE A 121      53.986  -9.507   4.182  1.00  0.00           H  
ATOM   1835  HE2 PHE A 121      54.658  -6.629   1.109  1.00  0.00           H  
ATOM   1836  HZ  PHE A 121      55.530  -8.316   2.679  1.00  0.00           H  
ATOM   1837  N   SER A 122      47.613  -6.170   4.875  1.00  0.00           N  
ATOM   1838  CA  SER A 122      46.167  -5.997   4.933  1.00  0.00           C  
ATOM   1839  C   SER A 122      45.772  -4.586   4.506  1.00  0.00           C  
ATOM   1840  O   SER A 122      45.096  -4.397   3.495  1.00  0.00           O  
ATOM   1841  CB  SER A 122      45.654  -6.276   6.347  1.00  0.00           C  
ATOM   1842  OG  SER A 122      44.259  -6.046   6.439  1.00  0.00           O  
ATOM   1843  H   SER A 122      48.137  -6.105   5.700  1.00  0.00           H  
ATOM   1844  HA  SER A 122      45.720  -6.705   4.251  1.00  0.00           H  
ATOM   1845  HB2 SER A 122      45.856  -7.304   6.604  1.00  0.00           H  
ATOM   1846  HB3 SER A 122      46.161  -5.625   7.045  1.00  0.00           H  
ATOM   1847  HG  SER A 122      43.786  -6.818   6.120  1.00  0.00           H  
ATOM   1848  N   GLY A 123      46.199  -3.597   5.284  1.00  0.00           N  
ATOM   1849  CA  GLY A 123      45.880  -2.216   4.972  1.00  0.00           C  
ATOM   1850  C   GLY A 123      47.081  -1.300   5.105  1.00  0.00           C  
ATOM   1851  O   GLY A 123      47.281  -0.648   6.130  1.00  0.00           O  
ATOM   1852  H   GLY A 123      46.735  -3.806   6.078  1.00  0.00           H  
ATOM   1853  HA2 GLY A 123      45.511  -2.163   3.959  1.00  0.00           H  
ATOM   1854  HA3 GLY A 123      45.108  -1.876   5.645  1.00  0.00           H  
ATOM   1855  N   PRO A 124      47.906  -1.243   4.049  1.00  0.00           N  
ATOM   1856  CA  PRO A 124      49.108  -0.404   4.028  1.00  0.00           C  
ATOM   1857  C   PRO A 124      48.777   1.083   3.973  1.00  0.00           C  
ATOM   1858  O   PRO A 124      47.684   1.469   3.558  1.00  0.00           O  
ATOM   1859  CB  PRO A 124      49.824  -0.841   2.746  1.00  0.00           C  
ATOM   1860  CG  PRO A 124      48.741  -1.372   1.871  1.00  0.00           C  
ATOM   1861  CD  PRO A 124      47.729  -1.993   2.794  1.00  0.00           C  
ATOM   1862  HA  PRO A 124      49.743  -0.599   4.880  1.00  0.00           H  
ATOM   1863  HB2 PRO A 124      50.315   0.011   2.297  1.00  0.00           H  
ATOM   1864  HB3 PRO A 124      50.553  -1.603   2.979  1.00  0.00           H  
ATOM   1865  HG2 PRO A 124      48.293  -0.566   1.311  1.00  0.00           H  
ATOM   1866  HG3 PRO A 124      49.144  -2.117   1.201  1.00  0.00           H  
ATOM   1867  HD2 PRO A 124      46.731  -1.861   2.403  1.00  0.00           H  
ATOM   1868  HD3 PRO A 124      47.944  -3.041   2.939  1.00  0.00           H  
ATOM   1869  N   SER A 125      49.727   1.913   4.392  1.00  0.00           N  
ATOM   1870  CA  SER A 125      49.534   3.358   4.393  1.00  0.00           C  
ATOM   1871  C   SER A 125      50.839   4.081   4.075  1.00  0.00           C  
ATOM   1872  O   SER A 125      51.908   3.689   4.543  1.00  0.00           O  
ATOM   1873  CB  SER A 125      48.999   3.821   5.749  1.00  0.00           C  
ATOM   1874  OG  SER A 125      49.898   3.488   6.792  1.00  0.00           O  
ATOM   1875  H   SER A 125      50.577   1.543   4.710  1.00  0.00           H  
ATOM   1876  HA  SER A 125      48.808   3.596   3.629  1.00  0.00           H  
ATOM   1877  HB2 SER A 125      48.865   4.892   5.734  1.00  0.00           H  
ATOM   1878  HB3 SER A 125      48.050   3.342   5.941  1.00  0.00           H  
ATOM   1879  HG  SER A 125      50.015   4.247   7.369  1.00  0.00           H  
ATOM   1880  N   SER A 126      50.743   5.138   3.274  1.00  0.00           N  
ATOM   1881  CA  SER A 126      51.915   5.913   2.889  1.00  0.00           C  
ATOM   1882  C   SER A 126      51.801   7.352   3.383  1.00  0.00           C  
ATOM   1883  O   SER A 126      51.272   8.219   2.688  1.00  0.00           O  
ATOM   1884  CB  SER A 126      52.088   5.897   1.369  1.00  0.00           C  
ATOM   1885  OG  SER A 126      50.936   6.408   0.719  1.00  0.00           O  
ATOM   1886  H   SER A 126      49.862   5.400   2.933  1.00  0.00           H  
ATOM   1887  HA  SER A 126      52.781   5.456   3.346  1.00  0.00           H  
ATOM   1888  HB2 SER A 126      52.938   6.505   1.099  1.00  0.00           H  
ATOM   1889  HB3 SER A 126      52.252   4.882   1.040  1.00  0.00           H  
ATOM   1890  HG  SER A 126      50.329   5.689   0.532  1.00  0.00           H  
ATOM   1891  N   GLY A 127      52.301   7.599   4.591  1.00  0.00           N  
ATOM   1892  CA  GLY A 127      52.244   8.933   5.159  1.00  0.00           C  
ATOM   1893  C   GLY A 127      53.082   9.930   4.382  1.00  0.00           C  
ATOM   1894  O   GLY A 127      53.444   9.682   3.231  1.00  0.00           O  
ATOM   1895  H   GLY A 127      52.711   6.869   5.100  1.00  0.00           H  
ATOM   1896  HA2 GLY A 127      51.218   9.268   5.164  1.00  0.00           H  
ATOM   1897  HA3 GLY A 127      52.605   8.894   6.176  1.00  0.00           H  
TER    1898      GLY A 127                                                      
END
MOLECULE T0446.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
