
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  231 ( 1904),  selected  231 , name 2gcj_C
# Molecule2: number of CA atoms  116 (  905),  selected  116 , name T0446.pdb
# PARAMETERS: 2gcj_C.T0446.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E   236_C      G       9           -
LGA    -       -      N      10           -
LGA    -       -      A      11           -
LGA    -       -      A      12           -
LGA    -       -      E      13           -
LGA    -       -      V      14           -
LGA    -       -      N      15           -
LGA    -       -      L      16           -
LGA    -       -      D      17           -
LGA    V   237_C      E      18           #
LGA    A   238_C      L      19          3.543
LGA    G   239_C      A      20          0.843
LGA    -       -      Q      21           -
LGA    -       -      E      22           -
LGA    -       -      L      23           -
LGA    -       -      G      24           -
LGA    -       -      P      25           -
LGA    -       -      I      26           -
LGA    -       -      M      27           -
LGA    -       -      G      28           -
LGA    -       -      D      29           -
LGA    -       -      N      30           -
LGA    D   240_C      E      31          5.267
LGA    A   241_C      Q      32          3.386
LGA    I   242_C      L      33          2.312
LGA    V   243_C      A      34          1.754
LGA    S   244_C      L      35          3.098
LGA    F   245_C      A      36          1.671
LGA    Q   246_C      Y      37          1.637
LGA    D   247_C      R      38          1.231
LGA    V   248_C      -       -           -
LGA    F   249_C      -       -           -
LGA    F   250_C      -       -           -
LGA    T   251_C      -       -           -
LGA    T   252_C      -       -           -
LGA    P   253_C      -       -           -
LGA    R   254_C      -       -           -
LGA    G   255_C      -       -           -
LGA    R   256_C      V      39          4.241
LGA    -       -      I      40           -
LGA    -       -      R      41           -
LGA    Y   257_C      D      42          3.084
LGA    D   258_C      M      43          1.520
LGA    I   259_C      F      44          1.997
LGA    D   260_C      V      45          2.010
LGA    I   261_C      F      46          2.243
LGA    Y   262_C      T      47          2.591
LGA    K   263_C      N      48          3.055
LGA    N   264_C      K      49          2.399
LGA    S   265_C      R      50          1.932
LGA    I   266_C      L      51          1.668
LGA    R   267_C      I      52          1.055
LGA    L   268_C      L      53          0.731
LGA    R   269_C      I      54          0.998
LGA    G   270_C      D      55          1.617
LGA    K   271_C      K      56          1.265
LGA    T   272_C      Q      57          3.298
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    -       -      T      60           -
LGA    -       -      G      61           -
LGA    -       -      K      62           -
LGA    -       -      K      63           -
LGA    -       -      V      64           -
LGA    Y   273_C      S      65          2.619
LGA    E   274_C      Y      66          1.982
LGA    Y   275_C      H      67          0.565
LGA    K   276_C      S      68          1.064
LGA    L   277_C      V      69          0.969
LGA    Q   278_C      P      70          1.749
LGA    H   279_C      Y      71          1.134
LGA    R   280_C      K      72          1.388
LGA    Q   281_C      A      73          1.264
LGA    I   282_C      I      74          0.587
LGA    Q   283_C      T      75          1.292
LGA    R   284_C      H      76          1.416
LGA    I   285_C      F      77          1.911
LGA    V   286_C      E      78          0.991
LGA    S   287_C      V      79          1.146
LGA    L   288_C      E      80          1.226
LGA    P   289_C      T      81          1.704
LGA    K   290_C      A      82          3.111
LGA    A   291_C      G      83          3.727
LGA    D   292_C      T      84          4.719
LGA    D   293_C      F      85          4.029
LGA    I   294_C      D      86          2.651
LGA    -       -      M      87           -
LGA    H   295_C      D      88          1.078
LGA    H   296_C      A      89          1.361
LGA    L   297_C      E      90          1.377
LGA    L   298_C      L      91          1.368
LGA    V   299_C      K      92          1.368
LGA    L   300_C      L      93          0.920
LGA    A   301_C      W      94          1.258
LGA    I   302_C      I      95          1.255
LGA    E   303_C      S      96          1.059
LGA    P   304_C      G      97          2.101
LGA    P   305_C      Q      98          2.096
LGA    L   306_C      K      99           -
LGA    R   307_C      -       -           -
LGA    K   308_C      -       -           -
LGA    G   309_C      -       -           -
LGA    Q   310_C      -       -           -
LGA    T   311_C      -       -           -
LGA    T   312_C      -       -           -
LGA    Y   313_C      -       -           -
LGA    P   314_C      D     100          2.755
LGA    F   315_C      P     101          0.627
LGA    L   316_C      L     102          1.260
LGA    V   317_C      V     103          1.330
LGA    L   318_C      K     104          1.416
LGA    Q   319_C      E     105          1.004
LGA    F   320_C      L     106          2.698
LGA    Q   321_C      K     107          3.781
LGA    K   322_C      -       -           -
LGA    D   323_C      K     108          5.247
LGA    E   324_C      G     109          2.884
LGA    E   325_C      -       -           -
LGA    T   326_C      -       -           -
LGA    E   327_C      -       -           -
LGA    V   328_C      -       -           -
LGA    Q   329_C      -       -           -
LGA    L   330_C      -       -           -
LGA    N   331_C      -       -           -
LGA    L   332_C      -       -           -
LGA    E   333_C      -       -           -
LGA    D   334_C      -       -           -
LGA    E   335_C      -       -           -
LGA    D   336_C      -       -           -
LGA    Y   337_C      -       -           -
LGA    E   338_C      -       -           -
LGA    E   339_C      -       -           -
LGA    N   340_C      -       -           -
LGA    Y   341_C      -       -           -
LGA    K   342_C      -       -           -
LGA    D   343_C      -       -           -
LGA    K   344_C      -       -           -
LGA    L   345_C      -       -           -
LGA    K   346_C      -       -           -
LGA    K   347_C      -       -           -
LGA    Q   348_C      -       -           -
LGA    Y   349_C      -       -           -
LGA    D   350_C      -       -           -
LGA    A   351_C      -       -           -
LGA    K   352_C      T     110          5.517
LGA    T   353_C      D     111          1.422
LGA    H   354_C      V     112          1.387
LGA    I   355_C      V     113          1.097
LGA    V   356_C      G     114          0.985
LGA    L   357_C      I     115          0.827
LGA    S   358_C      Q     116          0.698
LGA    H   359_C      K     117          0.601
LGA    V   360_C      T     118          0.386
LGA    L   361_C      I     119          0.936
LGA    K   362_C      A     120          0.943
LGA    G   363_C      N     121          0.666
LGA    L   364_C      F     122          0.206
LGA    T   365_C      S     123          0.267
LGA    D   366_C      L     124          0.683
LGA    R   367_C      -       -           -
LGA    R   368_C      -       -           -
LGA    V   369_C      -       -           -
LGA    I   370_C      -       -           -
LGA    V   371_C      -       -           -
LGA    P   372_C      -       -           -
LGA    G   373_C      -       -           -
LGA    E   374_C      -       -           -
LGA    Y   375_C      -       -           -
LGA    K   376_C      -       -           -
LGA    S   377_C      -       -           -
LGA    K   378_C      -       -           -
LGA    Y   379_C      -       -           -
LGA    D   380_C      -       -           -
LGA    Q   381_C      -       -           -
LGA    C   382_C      -       -           -
LGA    A   383_C      -       -           -
LGA    V   384_C      -       -           -
LGA    S   385_C      -       -           -
LGA    C   386_C      -       -           -
LGA    S   387_C      -       -           -
LGA    F   388_C      -       -           -
LGA    K   389_C      -       -           -
LGA    A   390_C      -       -           -
LGA    N   391_C      -       -           -
LGA    E   392_C      -       -           -
LGA    G   393_C      -       -           -
LGA    Y   394_C      -       -           -
LGA    L   395_C      -       -           -
LGA    Y   396_C      -       -           -
LGA    P   397_C      -       -           -
LGA    L   398_C      -       -           -
LGA    D   399_C      -       -           -
LGA    N   400_C      -       -           -
LGA    A   401_C      -       -           -
LGA    F   402_C      -       -           -
LGA    F   403_C      -       -           -
LGA    F   404_C      -       -           -
LGA    L   405_C      -       -           -
LGA    T   406_C      -       -           -
LGA    K   407_C      -       -           -
LGA    P   408_C      -       -           -
LGA    T   409_C      -       -           -
LGA    L   410_C      -       -           -
LGA    Y   411_C      -       -           -
LGA    I   412_C      -       -           -
LGA    P   413_C      -       -           -
LGA    F   414_C      -       -           -
LGA    S   415_C      -       -           -
LGA    D   416_C      -       -           -
LGA    V   417_C      -       -           -
LGA    S   418_C      -       -           -
LGA    M   419_C      -       -           -
LGA    V   420_C      -       -           -
LGA    N   421_C      -       -           -
LGA    I   422_C      -       -           -
LGA    S   423_C      -       -           -
LGA    R   424_C      -       -           -
LGA    R   433_C      -       -           -
LGA    T   434_C      -       -           -
LGA    F   435_C      -       -           -
LGA    D   436_C      -       -           -
LGA    L   437_C      -       -           -
LGA    E   438_C      -       -           -
LGA    V   439_C      -       -           -
LGA    V   440_C      -       -           -
LGA    L   441_C      -       -           -
LGA    R   442_C      -       -           -
LGA    S   443_C      -       -           -
LGA    N   444_C      -       -           -
LGA    R   445_C      -       -           -
LGA    G   446_C      -       -           -
LGA    S   447_C      -       -           -
LGA    T   448_C      -       -           -
LGA    T   449_C      -       -           -
LGA    F   450_C      -       -           -
LGA    A   451_C      -       -           -
LGA    N   452_C      -       -           -
LGA    I   453_C      -       -           -
LGA    S   454_C      -       -           -
LGA    K   455_C      -       -           -
LGA    E   456_C      -       -           -
LGA    E   457_C      -       -           -
LGA    Q   458_C      -       -           -
LGA    Q   459_C      -       -           -
LGA    L   460_C      -       -           -
LGA    L   461_C      -       -           -
LGA    E   462_C      -       -           -
LGA    Q   463_C      -       -           -
LGA    F   464_C      -       -           -
LGA    L   465_C      -       -           -
LGA    K   466_C      -       -           -
LGA    S   467_C      -       -           -
LGA    K   468_C      -       -           -
LGA    N   469_C      -       -           -
LGA    L   470_C      -       -           -
LGA    R   471_C      -       -           -
LGA    V   472_C      -       -           -
LGA    K   473_C      -       -           -
LGA    N   474_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  231  116    5.0     85    2.19     9.41     59.533     3.718

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.464750 * X  +  -0.816256 * Y  +   0.343122 * Z  +  74.323181
  Y_new =   0.803562 * X  +  -0.226063 * Y  +   0.550622 * Z  +  -4.149565
  Z_new =  -0.371881 * X  +   0.531622 * Y  +   0.760975 * Z  +  16.609632 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.609790   -2.531803  [ DEG:    34.9384   -145.0616 ]
  Theta =   0.381035    2.760558  [ DEG:    21.8317    158.1683 ]
  Phi   =   2.095155   -1.046438  [ DEG:   120.0435    -59.9565 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gcj_C                                        
REMARK     2: T0446.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gcj_C.T0446.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  231  116   5.0   85   2.19    9.41  59.533
REMARK  ---------------------------------------------------------- 
MOLECULE 2gcj_C
HEADER    REPLICATION                             14-MAR-06   2GCJ              
TITLE     CRYSTAL STRUCTURE OF THE POB3 MIDDLE DOMAIN                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL 63.0 KDA PROTEIN IN DAK1-ORC1                 
COMPND   3 INTERGENIC REGION;                                                   
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 FRAGMENT: POB3 MIDDLE DOMAIN;                                        
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: POB3;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 CODON+;                               
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET                                       
KEYWDS    CHROMATIN, FACT, DOUBLE PH DOMAIN                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.VANDEMARK                                                         
REVDAT   1   23-MAY-06 2GCJ    0                                                
JRNL        AUTH   A.P.VANDEMARK,M.BLANKSMA,E.FERRIS,A.HEROUX,                  
JRNL        AUTH 2 C.P.HILL,T.FORMOSA                                           
JRNL        TITL   THE STRUCTURE OF THE YFACT POB3-M DOMAIN, ITS                
JRNL        TITL 2 INTERACTION WITH THE DNA REPLICATION FACTOR RPA,             
JRNL        TITL 3 AND A POTENTIAL ROLE IN NUCLEOSOME DEPOSITION.               
JRNL        REF    MOL.CELL                      V.  22   363 2006              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 2.55 ANGSTROMS.                                          
DBREF  2GCJ A  220   478  UNP    Q04636   YMG9_YEAST     220    478             
DBREF  2GCJ B  220   478  UNP    Q04636   YMG9_YEAST     220    478             
DBREF  2GCJ C  220   478  UNP    Q04636   YMG9_YEAST     220    478             
DBREF  2GCJ D  220   478  UNP    Q04636   YMG9_YEAST     220    478             
SEQRES   1 A  261  GLY HIS MET ALA GLU ALA PHE TYR GLU GLU LEU LYS GLU          
SEQRES   2 A  261  LYS ALA ASP ILE GLY GLU VAL ALA GLY ASP ALA ILE VAL          
SEQRES   3 A  261  SER PHE GLN ASP VAL PHE PHE THR THR PRO ARG GLY ARG          
SEQRES   4 A  261  TYR ASP ILE ASP ILE TYR LYS ASN SER ILE ARG LEU ARG          
SEQRES   5 A  261  GLY LYS THR TYR GLU TYR LYS LEU GLN HIS ARG GLN ILE          
SEQRES   6 A  261  GLN ARG ILE VAL SER LEU PRO LYS ALA ASP ASP ILE HIS          
SEQRES   7 A  261  HIS LEU LEU VAL LEU ALA ILE GLU PRO PRO LEU ARG LYS          
SEQRES   8 A  261  GLY GLN THR THR TYR PRO PHE LEU VAL LEU GLN PHE GLN          
SEQRES   9 A  261  LYS ASP GLU GLU THR GLU VAL GLN LEU ASN LEU GLU ASP          
SEQRES  10 A  261  GLU ASP TYR GLU GLU ASN TYR LYS ASP LYS LEU LYS LYS          
SEQRES  11 A  261  GLN TYR ASP ALA LYS THR HIS ILE VAL LEU SER HIS VAL          
SEQRES  12 A  261  LEU LYS GLY LEU THR ASP ARG ARG VAL ILE VAL PRO GLY          
SEQRES  13 A  261  GLU TYR LYS SER LYS TYR ASP GLN CYS ALA VAL SER CYS          
SEQRES  14 A  261  SER PHE LYS ALA ASN GLU GLY TYR LEU TYR PRO LEU ASP          
SEQRES  15 A  261  ASN ALA PHE PHE PHE LEU THR LYS PRO THR LEU TYR ILE          
SEQRES  16 A  261  PRO PHE SER ASP VAL SER MET VAL ASN ILE SER ARG ALA          
SEQRES  17 A  261  GLY GLN THR SER THR SER SER ARG THR PHE ASP LEU GLU          
SEQRES  18 A  261  VAL VAL LEU ARG SER ASN ARG GLY SER THR THR PHE ALA          
SEQRES  19 A  261  ASN ILE SER LYS GLU GLU GLN GLN LEU LEU GLU GLN PHE          
SEQRES  20 A  261  LEU LYS SER LYS ASN LEU ARG VAL LYS ASN GLU ASP ARG          
SEQRES  21 A  261  GLU                                                          
SEQRES   1 B  261  GLY HIS MET ALA GLU ALA PHE TYR GLU GLU LEU LYS GLU          
SEQRES   2 B  261  LYS ALA ASP ILE GLY GLU VAL ALA GLY ASP ALA ILE VAL          
SEQRES   3 B  261  SER PHE GLN ASP VAL PHE PHE THR THR PRO ARG GLY ARG          
SEQRES   4 B  261  TYR ASP ILE ASP ILE TYR LYS ASN SER ILE ARG LEU ARG          
SEQRES   5 B  261  GLY LYS THR TYR GLU TYR LYS LEU GLN HIS ARG GLN ILE          
SEQRES   6 B  261  GLN ARG ILE VAL SER LEU PRO LYS ALA ASP ASP ILE HIS          
SEQRES   7 B  261  HIS LEU LEU VAL LEU ALA ILE GLU PRO PRO LEU ARG LYS          
SEQRES   8 B  261  GLY GLN THR THR TYR PRO PHE LEU VAL LEU GLN PHE GLN          
SEQRES   9 B  261  LYS ASP GLU GLU THR GLU VAL GLN LEU ASN LEU GLU ASP          
SEQRES  10 B  261  GLU ASP TYR GLU GLU ASN TYR LYS ASP LYS LEU LYS LYS          
SEQRES  11 B  261  GLN TYR ASP ALA LYS THR HIS ILE VAL LEU SER HIS VAL          
SEQRES  12 B  261  LEU LYS GLY LEU THR ASP ARG ARG VAL ILE VAL PRO GLY          
SEQRES  13 B  261  GLU TYR LYS SER LYS TYR ASP GLN CYS ALA VAL SER CYS          
SEQRES  14 B  261  SER PHE LYS ALA ASN GLU GLY TYR LEU TYR PRO LEU ASP          
SEQRES  15 B  261  ASN ALA PHE PHE PHE LEU THR LYS PRO THR LEU TYR ILE          
SEQRES  16 B  261  PRO PHE SER ASP VAL SER MET VAL ASN ILE SER ARG ALA          
SEQRES  17 B  261  GLY GLN THR SER THR SER SER ARG THR PHE ASP LEU GLU          
SEQRES  18 B  261  VAL VAL LEU ARG SER ASN ARG GLY SER THR THR PHE ALA          
SEQRES  19 B  261  ASN ILE SER LYS GLU GLU GLN GLN LEU LEU GLU GLN PHE          
SEQRES  20 B  261  LEU LYS SER LYS ASN LEU ARG VAL LYS ASN GLU ASP ARG          
SEQRES  21 B  261  GLU                                                          
SEQRES   1 C  261  GLY HIS MET ALA GLU ALA PHE TYR GLU GLU LEU LYS GLU          
SEQRES   2 C  261  LYS ALA ASP ILE GLY GLU VAL ALA GLY ASP ALA ILE VAL          
SEQRES   3 C  261  SER PHE GLN ASP VAL PHE PHE THR THR PRO ARG GLY ARG          
SEQRES   4 C  261  TYR ASP ILE ASP ILE TYR LYS ASN SER ILE ARG LEU ARG          
SEQRES   5 C  261  GLY LYS THR TYR GLU TYR LYS LEU GLN HIS ARG GLN ILE          
SEQRES   6 C  261  GLN ARG ILE VAL SER LEU PRO LYS ALA ASP ASP ILE HIS          
SEQRES   7 C  261  HIS LEU LEU VAL LEU ALA ILE GLU PRO PRO LEU ARG LYS          
SEQRES   8 C  261  GLY GLN THR THR TYR PRO PHE LEU VAL LEU GLN PHE GLN          
SEQRES   9 C  261  LYS ASP GLU GLU THR GLU VAL GLN LEU ASN LEU GLU ASP          
SEQRES  10 C  261  GLU ASP TYR GLU GLU ASN TYR LYS ASP LYS LEU LYS LYS          
SEQRES  11 C  261  GLN TYR ASP ALA LYS THR HIS ILE VAL LEU SER HIS VAL          
SEQRES  12 C  261  LEU LYS GLY LEU THR ASP ARG ARG VAL ILE VAL PRO GLY          
SEQRES  13 C  261  GLU TYR LYS SER LYS TYR ASP GLN CYS ALA VAL SER CYS          
SEQRES  14 C  261  SER PHE LYS ALA ASN GLU GLY TYR LEU TYR PRO LEU ASP          
SEQRES  15 C  261  ASN ALA PHE PHE PHE LEU THR LYS PRO THR LEU TYR ILE          
SEQRES  16 C  261  PRO PHE SER ASP VAL SER MET VAL ASN ILE SER ARG ALA          
SEQRES  17 C  261  GLY GLN THR SER THR SER SER ARG THR PHE ASP LEU GLU          
SEQRES  18 C  261  VAL VAL LEU ARG SER ASN ARG GLY SER THR THR PHE ALA          
SEQRES  19 C  261  ASN ILE SER LYS GLU GLU GLN GLN LEU LEU GLU GLN PHE          
SEQRES  20 C  261  LEU LYS SER LYS ASN LEU ARG VAL LYS ASN GLU ASP ARG          
SEQRES  21 C  261  GLU                                                          
SEQRES   1 D  261  GLY HIS MET ALA GLU ALA PHE TYR GLU GLU LEU LYS GLU          
SEQRES   2 D  261  LYS ALA ASP ILE GLY GLU VAL ALA GLY ASP ALA ILE VAL          
SEQRES   3 D  261  SER PHE GLN ASP VAL PHE PHE THR THR PRO ARG GLY ARG          
SEQRES   4 D  261  TYR ASP ILE ASP ILE TYR LYS ASN SER ILE ARG LEU ARG          
SEQRES   5 D  261  GLY LYS THR TYR GLU TYR LYS LEU GLN HIS ARG GLN ILE          
SEQRES   6 D  261  GLN ARG ILE VAL SER LEU PRO LYS ALA ASP ASP ILE HIS          
SEQRES   7 D  261  HIS LEU LEU VAL LEU ALA ILE GLU PRO PRO LEU ARG LYS          
SEQRES   8 D  261  GLY GLN THR THR TYR PRO PHE LEU VAL LEU GLN PHE GLN          
SEQRES   9 D  261  LYS ASP GLU GLU THR GLU VAL GLN LEU ASN LEU GLU ASP          
SEQRES  10 D  261  GLU ASP TYR GLU GLU ASN TYR LYS ASP LYS LEU LYS LYS          
SEQRES  11 D  261  GLN TYR ASP ALA LYS THR HIS ILE VAL LEU SER HIS VAL          
SEQRES  12 D  261  LEU LYS GLY LEU THR ASP ARG ARG VAL ILE VAL PRO GLY          
SEQRES  13 D  261  GLU TYR LYS SER LYS TYR ASP GLN CYS ALA VAL SER CYS          
SEQRES  14 D  261  SER PHE LYS ALA ASN GLU GLY TYR LEU TYR PRO LEU ASP          
SEQRES  15 D  261  ASN ALA PHE PHE PHE LEU THR LYS PRO THR LEU TYR ILE          
SEQRES  16 D  261  PRO PHE SER ASP VAL SER MET VAL ASN ILE SER ARG ALA          
SEQRES  17 D  261  GLY GLN THR SER THR SER SER ARG THR PHE ASP LEU GLU          
SEQRES  18 D  261  VAL VAL LEU ARG SER ASN ARG GLY SER THR THR PHE ALA          
SEQRES  19 D  261  ASN ILE SER LYS GLU GLU GLN GLN LEU LEU GLU GLN PHE          
SEQRES  20 D  261  LEU LYS SER LYS ASN LEU ARG VAL LYS ASN GLU ASP ARG          
SEQRES  21 D  261  GLU                                                          
FORMUL   5  HOH   *80(H2 O)                                                     
CRYST1   57.868  157.527   57.787  90.00  89.77  90.00 P 1 21 1      8          
ATOM   3786  N   GLU C 236      53.787 -14.208  27.335  1.00 64.46           N  
ATOM   3787  CA  GLU C 236      53.805 -15.350  28.303  1.00 69.63           C  
ATOM   3788  C   GLU C 236      52.390 -15.858  28.545  1.00 73.79           C  
ATOM   3789  O   GLU C 236      52.205 -16.905  29.177  1.00 79.29           O  
ATOM   3790  CB  GLU C 236      54.495 -14.960  29.622  1.00 77.07           C  
ATOM   3791  CG  GLU C 236      56.032 -14.844  29.545  1.00 72.91           C  
ATOM   3792  CD  GLU C 236      56.497 -13.736  28.620  1.00 63.98           C  
ATOM   3793  OE1 GLU C 236      56.336 -13.897  27.394  1.00 55.88           O  
ATOM   3794  OE2 GLU C 236      57.018 -12.711  29.116  1.00 65.56           O  
ATOM   3795  N   VAL C 237      51.413 -15.076  28.073  1.00 72.11           N  
ATOM   3796  CA  VAL C 237      50.019 -15.503  27.845  1.00 72.88           C  
ATOM   3797  C   VAL C 237      49.667 -14.865  26.505  1.00 65.11           C  
ATOM   3798  O   VAL C 237      49.640 -13.637  26.388  1.00 65.48           O  
ATOM   3799  CB  VAL C 237      49.013 -15.078  28.985  1.00 82.76           C  
ATOM   3800  CG1 VAL C 237      47.560 -15.033  28.487  1.00 82.40           C  
ATOM   3801  CG2 VAL C 237      49.114 -16.021  30.173  1.00 90.93           C  
ATOM   3802  N   ALA C 238      49.450 -15.702  25.492  1.00 58.82           N  
ATOM   3803  CA  ALA C 238      49.171 -15.230  24.143  1.00 51.47           C  
ATOM   3804  C   ALA C 238      47.673 -15.143  23.856  1.00 52.67           C  
ATOM   3805  O   ALA C 238      47.263 -15.140  22.704  1.00 48.02           O  
ATOM   3806  CB  ALA C 238      49.848 -16.132  23.145  1.00 45.14           C  
ATOM   3807  N   GLY C 239      46.874 -15.036  24.912  1.00 59.70           N  
ATOM   3808  CA  GLY C 239      45.414 -15.144  24.838  1.00 62.42           C  
ATOM   3809  C   GLY C 239      44.643 -14.305  23.829  1.00 58.67           C  
ATOM   3810  O   GLY C 239      43.760 -14.811  23.144  1.00 57.34           O  
ATOM   3811  N   ASP C 240      44.952 -13.019  23.746  1.00 58.08           N  
ATOM   3812  CA  ASP C 240      44.246 -12.129  22.834  1.00 55.85           C  
ATOM   3813  C   ASP C 240      44.758 -12.178  21.380  1.00 47.25           C  
ATOM   3814  O   ASP C 240      44.242 -11.459  20.526  1.00 46.86           O  
ATOM   3815  CB  ASP C 240      44.230 -10.691  23.374  1.00 61.67           C  
ATOM   3816  CG  ASP C 240      45.607 -10.207  23.898  1.00 62.07           C  
ATOM   3817  OD1 ASP C 240      46.614 -10.963  23.896  1.00 56.28           O  
ATOM   3818  OD2 ASP C 240      45.665  -9.034  24.334  1.00 68.49           O  
ATOM   3819  N   ALA C 241      45.746 -13.029  21.098  1.00 40.99           N  
ATOM   3820  CA  ALA C 241      46.279 -13.191  19.737  1.00 33.53           C  
ATOM   3821  C   ALA C 241      45.256 -13.762  18.768  1.00 30.88           C  
ATOM   3822  O   ALA C 241      44.404 -14.535  19.172  1.00 33.85           O  
ATOM   3823  CB  ALA C 241      47.517 -14.081  19.748  1.00 30.04           C  
ATOM   3824  N   ILE C 242      45.361 -13.383  17.496  1.00 26.22           N  
ATOM   3825  CA  ILE C 242      44.542 -13.940  16.418  1.00 24.07           C  
ATOM   3826  C   ILE C 242      44.979 -15.390  16.165  1.00 21.06           C  
ATOM   3827  O   ILE C 242      44.182 -16.239  15.833  1.00 21.90           O  
ATOM   3828  CB  ILE C 242      44.682 -13.087  15.097  1.00 22.18           C  
ATOM   3829  CG1 ILE C 242      44.011 -11.716  15.255  1.00 25.92           C  
ATOM   3830  CG2 ILE C 242      44.105 -13.802  13.895  1.00 19.37           C  
ATOM   3831  CD1 ILE C 242      44.174 -10.782  14.064  1.00 25.74           C  
ATOM   3832  N   VAL C 243      46.252 -15.660  16.368  1.00 18.63           N  
ATOM   3833  CA  VAL C 243      46.816 -16.979  16.162  1.00 17.21           C  
ATOM   3834  C   VAL C 243      48.238 -16.992  16.707  1.00 16.19           C  
ATOM   3835  O   VAL C 243      48.938 -15.958  16.724  1.00 14.63           O  
ATOM   3836  CB  VAL C 243      46.797 -17.389  14.650  1.00 14.14           C  
ATOM   3837  CG1 VAL C 243      47.692 -16.492  13.824  1.00 12.07           C  
ATOM   3838  CG2 VAL C 243      47.137 -18.845  14.474  1.00 14.31           C  
ATOM   3839  N   SER C 244      48.656 -18.162  17.172  1.00 17.86           N  
ATOM   3840  CA  SER C 244      49.988 -18.312  17.744  1.00 18.27           C  
ATOM   3841  C   SER C 244      50.718 -19.523  17.227  1.00 17.49           C  
ATOM   3842  O   SER C 244      50.209 -20.624  17.329  1.00 20.96           O  
ATOM   3843  CB  SER C 244      49.895 -18.373  19.254  1.00 22.56           C  
ATOM   3844  OG  SER C 244      50.343 -17.144  19.753  1.00 24.04           O  
ATOM   3845  N   PHE C 245      51.924 -19.324  16.700  1.00 15.16           N  
ATOM   3846  CA  PHE C 245      52.690 -20.429  16.090  1.00 14.61           C  
ATOM   3847  C   PHE C 245      53.764 -20.926  17.039  1.00 16.66           C  
ATOM   3848  O   PHE C 245      54.734 -20.254  17.368  1.00 14.70           O  
ATOM   3849  CB  PHE C 245      53.260 -20.047  14.726  1.00 11.24           C  
ATOM   3850  CG  PHE C 245      52.231 -20.017  13.628  1.00 11.53           C  
ATOM   3851  CD1 PHE C 245      51.457 -18.873  13.406  1.00  8.55           C  
ATOM   3852  CD2 PHE C 245      52.049 -21.127  12.781  1.00 13.44           C  
ATOM   3853  CE1 PHE C 245      50.504 -18.850  12.398  1.00  8.27           C  
ATOM   3854  CE2 PHE C 245      51.086 -21.087  11.749  1.00 11.81           C  
ATOM   3855  CZ  PHE C 245      50.324 -19.939  11.571  1.00  8.65           C  
ATOM   3856  N   GLN C 246      53.534 -22.136  17.489  1.00 21.34           N  
ATOM   3857  CA  GLN C 246      54.311 -22.740  18.533  1.00 25.75           C  
ATOM   3858  C   GLN C 246      55.719 -23.122  18.055  1.00 24.73           C  
ATOM   3859  O   GLN C 246      55.903 -23.951  17.149  1.00 24.54           O  
ATOM   3860  CB  GLN C 246      53.537 -23.946  19.116  1.00 32.15           C  
ATOM   3861  CG  GLN C 246      52.930 -24.945  18.057  1.00 36.45           C  
ATOM   3862  CD  GLN C 246      51.614 -24.458  17.354  1.00 36.05           C  
ATOM   3863  OE1 GLN C 246      51.629 -23.561  16.502  1.00 29.46           O  
ATOM   3864  NE2 GLN C 246      50.489 -25.093  17.702  1.00 42.16           N  
ATOM   3865  N   ASP C 247      56.702 -22.462  18.662  1.00 23.80           N  
ATOM   3866  CA  ASP C 247      58.055 -22.986  18.737  1.00 25.97           C  
ATOM   3867  C   ASP C 247      58.768 -23.064  17.366  1.00 23.26           C  
ATOM   3868  O   ASP C 247      59.307 -24.085  16.966  1.00 25.83           O  
ATOM   3869  CB  ASP C 247      58.004 -24.332  19.486  1.00 32.88           C  
ATOM   3870  CG  ASP C 247      59.352 -24.838  19.867  1.00 37.89           C  
ATOM   3871  OD1 ASP C 247      60.300 -24.014  19.955  1.00 37.73           O  
ATOM   3872  OD2 ASP C 247      59.472 -26.076  20.073  1.00 47.38           O  
ATOM   3873  N   VAL C 248      58.764 -21.938  16.667  1.00 19.24           N  
ATOM   3874  CA  VAL C 248      59.346 -21.810  15.337  1.00 17.37           C  
ATOM   3875  C   VAL C 248      60.832 -21.532  15.437  1.00 17.32           C  
ATOM   3876  O   VAL C 248      61.279 -20.723  16.254  1.00 16.64           O  
ATOM   3877  CB  VAL C 248      58.699 -20.646  14.578  1.00 14.01           C  
ATOM   3878  CG1 VAL C 248      59.350 -20.451  13.201  1.00 13.51           C  
ATOM   3879  CG2 VAL C 248      57.201 -20.857  14.471  1.00 13.56           C  
ATOM   3880  N   PHE C 249      61.580 -22.208  14.582  1.00 19.23           N  
ATOM   3881  CA  PHE C 249      63.026 -22.071  14.485  1.00 20.47           C  
ATOM   3882  C   PHE C 249      63.341 -20.907  13.560  1.00 17.09           C  
ATOM   3883  O   PHE C 249      62.812 -20.802  12.435  1.00 17.11           O  
ATOM   3884  CB  PHE C 249      63.608 -23.359  13.917  1.00 25.11           C  
ATOM   3885  CG  PHE C 249      65.096 -23.402  13.891  1.00 30.44           C  
ATOM   3886  CD1 PHE C 249      65.869 -22.745  14.879  1.00 32.65           C  
ATOM   3887  CD2 PHE C 249      65.765 -24.163  12.917  1.00 36.79           C  
ATOM   3888  CE1 PHE C 249      67.295 -22.805  14.873  1.00 31.92           C  
ATOM   3889  CE2 PHE C 249      67.188 -24.234  12.904  1.00 39.54           C  
ATOM   3890  CZ  PHE C 249      67.947 -23.546  13.883  1.00 36.06           C  
ATOM   3891  N   PHE C 250      64.191 -20.019  14.025  1.00 15.04           N  
ATOM   3892  CA  PHE C 250      64.647 -18.957  13.171  1.00 13.54           C  
ATOM   3893  C   PHE C 250      66.117 -19.218  12.972  1.00 16.14           C  
ATOM   3894  O   PHE C 250      66.800 -19.617  13.915  1.00 17.44           O  
ATOM   3895  CB  PHE C 250      64.446 -17.593  13.852  1.00 11.76           C  
ATOM   3896  CG  PHE C 250      63.018 -17.051  13.823  1.00  8.62           C  
ATOM   3897  CD1 PHE C 250      61.964 -17.767  14.371  1.00  7.12           C  
ATOM   3898  CD2 PHE C 250      62.760 -15.764  13.329  1.00  7.44           C  
ATOM   3899  CE1 PHE C 250      60.647 -17.220  14.401  1.00  6.58           C  
ATOM   3900  CE2 PHE C 250      61.456 -15.215  13.359  1.00  6.87           C  
ATOM   3901  CZ  PHE C 250      60.394 -15.950  13.904  1.00  3.84           C  
ATOM   3902  N   THR C 251      66.615 -19.007  11.755  1.00 18.01           N  
ATOM   3903  CA  THR C 251      68.050 -19.137  11.485  1.00 21.52           C  
ATOM   3904  C   THR C 251      68.709 -17.778  11.642  1.00 21.56           C  
ATOM   3905  O   THR C 251      69.855 -17.691  12.050  1.00 24.10           O  
ATOM   3906  CB  THR C 251      68.379 -19.776  10.114  1.00 25.54           C  
ATOM   3907  OG1 THR C 251      67.334 -19.519   9.169  1.00 24.94           O  
ATOM   3908  CG2 THR C 251      68.488 -21.249  10.258  1.00 28.75           C  
ATOM   3909  N   THR C 252      67.961 -16.724  11.343  1.00 20.56           N  
ATOM   3910  CA  THR C 252      68.373 -15.335  11.589  1.00 21.92           C  
ATOM   3911  C   THR C 252      67.175 -14.608  12.224  1.00 19.11           C  
ATOM   3912  O   THR C 252      66.125 -14.501  11.570  1.00 18.86           O  
ATOM   3913  CB  THR C 252      68.777 -14.632  10.271  1.00 25.35           C  
ATOM   3914  OG1 THR C 252      69.992 -15.202   9.774  1.00 30.74           O  
ATOM   3915  CG2 THR C 252      68.999 -13.134  10.471  1.00 26.81           C  
ATOM   3916  N   PRO C 253      67.301 -14.167  13.493  1.00 18.02           N  
ATOM   3917  CA  PRO C 253      68.435 -14.478  14.369  1.00 20.05           C  
ATOM   3918  C   PRO C 253      68.273 -15.914  14.849  1.00 19.98           C  
ATOM   3919  O   PRO C 253      67.144 -16.428  14.858  1.00 19.89           O  
ATOM   3920  CB  PRO C 253      68.288 -13.490  15.530  1.00 19.32           C  
ATOM   3921  CG  PRO C 253      66.857 -13.136  15.568  1.00 17.78           C  
ATOM   3922  CD  PRO C 253      66.289 -13.338  14.169  1.00 16.76           C  
ATOM   3923  N   ARG C 254      69.365 -16.583  15.183  1.00 21.90           N  
ATOM   3924  CA  ARG C 254      69.287 -17.987  15.543  1.00 23.19           C  
ATOM   3925  C   ARG C 254      68.537 -18.132  16.874  1.00 21.96           C  
ATOM   3926  O   ARG C 254      68.956 -17.617  17.889  1.00 22.77           O  
ATOM   3927  CB  ARG C 254      70.706 -18.595  15.586  1.00 26.92           C  
ATOM   3928  CG  ARG C 254      70.842 -20.055  16.072  1.00 32.37           C  
ATOM   3929  CD  ARG C 254      70.713 -21.160  14.988  1.00 39.18           C  
ATOM   3930  NE  ARG C 254      70.828 -20.675  13.604  1.00 42.64           N  
ATOM   3931  CZ  ARG C 254      71.946 -20.657  12.868  1.00 46.41           C  
ATOM   3932  NH1 ARG C 254      73.106 -21.097  13.352  1.00 50.11           N  
ATOM   3933  NH2 ARG C 254      71.901 -20.187  11.630  1.00 46.48           N  
ATOM   3934  N   GLY C 255      67.406 -18.820  16.862  1.00 21.29           N  
ATOM   3935  CA  GLY C 255      66.713 -19.128  18.109  1.00 22.33           C  
ATOM   3936  C   GLY C 255      65.393 -19.796  17.832  1.00 21.53           C  
ATOM   3937  O   GLY C 255      65.022 -19.942  16.677  1.00 19.95           O  
ATOM   3938  N   ARG C 256      64.716 -20.237  18.889  1.00 23.78           N  
ATOM   3939  CA  ARG C 256      63.323 -20.685  18.802  1.00 24.39           C  
ATOM   3940  C   ARG C 256      62.437 -19.619  19.418  1.00 22.61           C  
ATOM   3941  O   ARG C 256      62.737 -19.100  20.516  1.00 25.19           O  
ATOM   3942  CB  ARG C 256      63.058 -21.975  19.566  1.00 29.05           C  
ATOM   3943  CG  ARG C 256      64.179 -22.987  19.583  1.00 37.89           C  
ATOM   3944  CD  ARG C 256      63.625 -24.424  19.767  1.00 47.33           C  
ATOM   3945  NE  ARG C 256      63.019 -24.874  18.514  1.00 49.04           N  
ATOM   3946  CZ  ARG C 256      63.711 -25.329  17.472  1.00 51.21           C  
ATOM   3947  NH1 ARG C 256      65.045 -25.423  17.534  1.00 52.27           N  
ATOM   3948  NH2 ARG C 256      63.062 -25.689  16.369  1.00 51.19           N  
ATOM   3949  N   TYR C 257      61.344 -19.305  18.733  1.00 19.11           N  
ATOM   3950  CA  TYR C 257      60.409 -18.304  19.227  1.00 17.77           C  
ATOM   3951  C   TYR C 257      58.975 -18.723  19.020  1.00 17.22           C  
ATOM   3952  O   TYR C 257      58.663 -19.502  18.117  1.00 16.91           O  
ATOM   3953  CB  TYR C 257      60.617 -16.977  18.511  1.00 15.60           C  
ATOM   3954  CG  TYR C 257      61.995 -16.396  18.655  1.00 15.83           C  
ATOM   3955  CD1 TYR C 257      63.042 -16.825  17.853  1.00 15.16           C  
ATOM   3956  CD2 TYR C 257      62.244 -15.396  19.576  1.00 18.61           C  
ATOM   3957  CE1 TYR C 257      64.327 -16.292  17.993  1.00 17.05           C  
ATOM   3958  CE2 TYR C 257      63.523 -14.842  19.715  1.00 20.50           C  
ATOM   3959  CZ  TYR C 257      64.557 -15.290  18.916  1.00 19.04           C  
ATOM   3960  OH  TYR C 257      65.819 -14.730  19.055  1.00 22.87           O  
ATOM   3961  N   ASP C 258      58.093 -18.211  19.859  1.00 17.32           N  
ATOM   3962  CA  ASP C 258      56.693 -18.255  19.526  1.00 17.13           C  
ATOM   3963  C   ASP C 258      56.334 -16.995  18.717  1.00 16.07           C  
ATOM   3964  O   ASP C 258      56.799 -15.869  19.011  1.00 15.60           O  
ATOM   3965  CB  ASP C 258      55.863 -18.384  20.784  1.00 19.51           C  
ATOM   3966  CG  ASP C 258      56.031 -19.740  21.467  1.00 20.91           C  
ATOM   3967  OD1 ASP C 258      55.203 -20.050  22.326  1.00 23.47           O  
ATOM   3968  OD2 ASP C 258      56.988 -20.489  21.180  1.00 21.03           O  
ATOM   3969  N   ILE C 259      55.574 -17.178  17.645  1.00 15.05           N  
ATOM   3970  CA  ILE C 259      55.126 -16.025  16.895  1.00 13.54           C  
ATOM   3971  C   ILE C 259      53.676 -15.814  17.260  1.00 15.10           C  
ATOM   3972  O   ILE C 259      52.837 -16.655  16.918  1.00 16.73           O  
ATOM   3973  CB  ILE C 259      55.213 -16.275  15.400  1.00 12.22           C  
ATOM   3974  CG1 ILE C 259      56.608 -16.742  14.991  1.00 10.48           C  
ATOM   3975  CG2 ILE C 259      54.824 -15.032  14.651  1.00 11.05           C  
ATOM   3976  CD1 ILE C 259      56.673 -17.007  13.520  1.00  8.45           C  
ATOM   3977  N   ASP C 260      53.370 -14.720  17.955  1.00 15.85           N  
ATOM   3978  CA  ASP C 260      51.978 -14.371  18.227  1.00 18.02           C  
ATOM   3979  C   ASP C 260      51.492 -13.282  17.259  1.00 17.37           C  
ATOM   3980  O   ASP C 260      52.094 -12.202  17.166  1.00 17.02           O  
ATOM   3981  CB  ASP C 260      51.768 -13.924  19.688  1.00 20.73           C  
ATOM   3982  CG  ASP C 260      52.436 -14.838  20.695  1.00 22.62           C  
ATOM   3983  OD1 ASP C 260      52.237 -16.067  20.638  1.00 25.28           O  
ATOM   3984  OD2 ASP C 260      53.163 -14.327  21.566  1.00 24.00           O  
ATOM   3985  N   ILE C 261      50.389 -13.559  16.568  1.00 17.50           N  
ATOM   3986  CA  ILE C 261      49.898 -12.648  15.553  1.00 17.28           C  
ATOM   3987  C   ILE C 261      48.663 -11.859  15.968  1.00 19.34           C  
ATOM   3988  O   ILE C 261      47.814 -12.370  16.684  1.00 21.44           O  
ATOM   3989  CB  ILE C 261      49.724 -13.382  14.203  1.00 16.11           C  
ATOM   3990  CG1 ILE C 261      51.072 -13.986  13.791  1.00 14.44           C  
ATOM   3991  CG2 ILE C 261      49.238 -12.402  13.113  1.00 16.52           C  
ATOM   3992  CD1 ILE C 261      51.107 -14.465  12.405  1.00 14.67           C  
ATOM   3993  N   TYR C 262      48.587 -10.608  15.514  1.00 19.88           N  
ATOM   3994  CA  TYR C 262      47.518  -9.660  15.914  1.00 23.06           C  
ATOM   3995  C   TYR C 262      46.979  -8.816  14.764  1.00 23.05           C  
ATOM   3996  O   TYR C 262      47.516  -8.825  13.665  1.00 20.51           O  
ATOM   3997  CB  TYR C 262      48.012  -8.705  17.000  1.00 24.93           C  
ATOM   3998  CG  TYR C 262      48.494  -9.375  18.270  1.00 25.70           C  
ATOM   3999  CD1 TYR C 262      49.842  -9.737  18.430  1.00 23.64           C  
ATOM   4000  CD2 TYR C 262      47.614  -9.623  19.331  1.00 29.30           C  
ATOM   4001  CE1 TYR C 262      50.296 -10.357  19.607  1.00 23.59           C  
ATOM   4002  CE2 TYR C 262      48.062 -10.239  20.511  1.00 30.40           C  
ATOM   4003  CZ  TYR C 262      49.404 -10.603  20.626  1.00 27.44           C  
ATOM   4004  OH  TYR C 262      49.850 -11.188  21.775  1.00 30.40           O  
ATOM   4005  N   LYS C 263      45.907  -8.080  15.025  1.00 26.84           N  
ATOM   4006  CA  LYS C 263      45.374  -7.162  14.025  1.00 28.16           C  
ATOM   4007  C   LYS C 263      46.488  -6.230  13.530  1.00 27.03           C  
ATOM   4008  O   LYS C 263      46.651  -6.056  12.334  1.00 25.67           O  
ATOM   4009  CB  LYS C 263      44.175  -6.382  14.569  1.00 32.61           C  
ATOM   4010  CG  LYS C 263      43.776  -5.130  13.718  1.00 35.72           C  
ATOM   4011  CD  LYS C 263      42.565  -4.414  14.281  1.00 38.53           C  
ATOM   4012  CE  LYS C 263      42.449  -2.983  13.745  1.00 42.36           C  
ATOM   4013  NZ  LYS C 263      42.867  -1.900  14.701  1.00 44.19           N  
ATOM   4014  N   ASN C 264      47.293  -5.702  14.446  1.00 27.94           N  
ATOM   4015  CA  ASN C 264      48.258  -4.667  14.108  1.00 28.57           C  
ATOM   4016  C   ASN C 264      49.691  -5.139  14.063  1.00 26.60           C  
ATOM   4017  O   ASN C 264      50.464  -4.728  13.185  1.00 25.62           O  
ATOM   4018  CB  ASN C 264      48.145  -3.506  15.092  1.00 32.38           C  
ATOM   4019  CG  ASN C 264      46.815  -2.765  14.965  1.00 36.98           C  
ATOM   4020  OD1 ASN C 264      46.127  -2.870  13.936  1.00 37.74           O  
ATOM   4021  ND2 ASN C 264      46.437  -2.028  16.011  1.00 40.05           N  
ATOM   4022  N   SER C 265      50.044  -6.007  15.010  1.00 26.25           N  
ATOM   4023  CA  SER C 265      51.431  -6.371  15.222  1.00 24.59           C  
ATOM   4024  C   SER C 265      51.663  -7.861  15.264  1.00 22.48           C  
ATOM   4025  O   SER C 265      50.714  -8.654  15.327  1.00 22.77           O  
ATOM   4026  CB  SER C 265      51.936  -5.754  16.520  1.00 26.29           C  
ATOM   4027  OG  SER C 265      50.950  -5.877  17.535  1.00 30.24           O  
ATOM   4028  N   ILE C 266      52.947  -8.214  15.183  1.00 20.64           N  
ATOM   4029  CA  ILE C 266      53.448  -9.522  15.542  1.00 19.25           C  
ATOM   4030  C   ILE C 266      54.295  -9.342  16.794  1.00 19.56           C  
ATOM   4031  O   ILE C 266      54.998  -8.331  16.936  1.00 19.53           O  
ATOM   4032  CB  ILE C 266      54.285 -10.153  14.381  1.00 17.96           C  
ATOM   4033  CG1 ILE C 266      53.435 -11.137  13.592  1.00 18.26           C  
ATOM   4034  CG2 ILE C 266      55.511 -10.915  14.868  1.00 16.35           C  
ATOM   4035  CD1 ILE C 266      52.458 -10.475  12.652  1.00 19.84           C  
ATOM   4036  N   ARG C 267      54.192 -10.311  17.703  1.00 19.10           N  
ATOM   4037  CA  ARG C 267      55.150 -10.459  18.798  1.00 19.68           C  
ATOM   4038  C   ARG C 267      55.925 -11.768  18.662  1.00 17.41           C  
ATOM   4039  O   ARG C 267      55.327 -12.828  18.559  1.00 17.34           O  
ATOM   4040  CB  ARG C 267      54.466 -10.398  20.167  1.00 21.41           C  
ATOM   4041  CG  ARG C 267      55.405 -10.801  21.317  1.00 23.53           C  
ATOM   4042  CD  ARG C 267      54.702 -10.742  22.683  1.00 27.16           C  
ATOM   4043  NE  ARG C 267      54.085  -9.438  22.908  1.00 30.97           N  
ATOM   4044  CZ  ARG C 267      52.769  -9.233  22.983  1.00 35.18           C  
ATOM   4045  NH1 ARG C 267      51.924 -10.257  22.889  1.00 32.33           N  
ATOM   4046  NH2 ARG C 267      52.302  -7.995  23.165  1.00 39.61           N  
ATOM   4047  N   LEU C 268      57.247 -11.679  18.650  1.00 16.39           N  
ATOM   4048  CA  LEU C 268      58.120 -12.848  18.693  1.00 15.87           C  
ATOM   4049  C   LEU C 268      58.621 -13.108  20.118  1.00 16.63           C  
ATOM   4050  O   LEU C 268      59.309 -12.281  20.678  1.00 17.40           O  
ATOM   4051  CB  LEU C 268      59.311 -12.657  17.764  1.00 14.79           C  
ATOM   4052  CG  LEU C 268      59.014 -12.376  16.304  1.00 14.17           C  
ATOM   4053  CD1 LEU C 268      60.347 -12.292  15.506  1.00 14.48           C  
ATOM   4054  CD2 LEU C 268      58.108 -13.439  15.751  1.00 12.62           C  
ATOM   4055  N   ARG C 269      58.265 -14.254  20.685  1.00 17.10           N  
ATOM   4056  CA  ARG C 269      58.558 -14.591  22.096  1.00 19.14           C  
ATOM   4057  C   ARG C 269      59.614 -15.683  22.135  1.00 18.60           C  
ATOM   4058  O   ARG C 269      59.372 -16.775  21.649  1.00 18.11           O  
ATOM   4059  CB  ARG C 269      57.298 -15.083  22.846  1.00 20.23           C  
ATOM   4060  CG  ARG C 269      56.498 -13.973  23.449  1.00 22.97           C  
ATOM   4061  CD  ARG C 269      55.096 -14.378  23.914  1.00 24.93           C  
ATOM   4062  NE  ARG C 269      55.055 -15.694  24.547  1.00 28.72           N  
ATOM   4063  CZ  ARG C 269      54.399 -16.751  24.059  1.00 27.68           C  
ATOM   4064  NH1 ARG C 269      53.697 -16.667  22.941  1.00 25.96           N  
ATOM   4065  NH2 ARG C 269      54.450 -17.902  24.693  1.00 28.76           N  
ATOM   4066  N   GLY C 270      60.769 -15.368  22.724  1.00 19.36           N  
ATOM   4067  CA  GLY C 270      61.895 -16.297  22.874  1.00 19.71           C  
ATOM   4068  C   GLY C 270      62.239 -16.589  24.327  1.00 21.99           C  
ATOM   4069  O   GLY C 270      61.555 -16.135  25.261  1.00 22.89           O  
ATOM   4070  N   LYS C 271      63.291 -17.377  24.515  1.00 22.76           N  
ATOM   4071  CA  LYS C 271      63.766 -17.721  25.848  1.00 24.99           C  
ATOM   4072  C   LYS C 271      64.473 -16.504  26.461  1.00 24.94           C  
ATOM   4073  O   LYS C 271      64.345 -16.232  27.658  1.00 27.17           O  
ATOM   4074  CB  LYS C 271      64.710 -18.927  25.768  1.00 25.98           C  
ATOM   4075  CG  LYS C 271      65.368 -19.316  27.079  1.00 30.09           C  
ATOM   4076  CD  LYS C 271      66.682 -20.040  26.829  1.00 32.79           C  
ATOM   4077  CE  LYS C 271      67.211 -20.663  28.099  1.00 36.29           C  
ATOM   4078  NZ  LYS C 271      67.883 -19.667  28.981  1.00 39.47           N  
ATOM   4079  N   THR C 272      65.191 -15.766  25.623  1.00 22.89           N  
ATOM   4080  CA  THR C 272      66.023 -14.662  26.070  1.00 23.45           C  
ATOM   4081  C   THR C 272      65.473 -13.284  25.650  1.00 22.36           C  
ATOM   4082  O   THR C 272      65.559 -12.319  26.412  1.00 22.67           O  
ATOM   4083  CB  THR C 272      67.476 -14.895  25.580  1.00 23.57           C  
ATOM   4084  OG1 THR C 272      68.114 -15.797  26.479  1.00 26.60           O  
ATOM   4085  CG2 THR C 272      68.292 -13.643  25.573  1.00 24.99           C  
ATOM   4086  N   TYR C 273      64.894 -13.231  24.448  1.00 20.90           N  
ATOM   4087  CA  TYR C 273      64.443 -12.005  23.818  1.00 20.48           C  
ATOM   4088  C   TYR C 273      62.990 -12.057  23.427  1.00 19.84           C  
ATOM   4089  O   TYR C 273      62.436 -13.110  23.104  1.00 18.51           O  
ATOM   4090  CB  TYR C 273      65.265 -11.701  22.554  1.00 20.28           C  
ATOM   4091  CG  TYR C 273      66.724 -11.418  22.827  1.00 21.95           C  
ATOM   4092  CD1 TYR C 273      67.143 -10.170  23.311  1.00 23.63           C  
ATOM   4093  CD2 TYR C 273      67.686 -12.396  22.605  1.00 23.66           C  
ATOM   4094  CE1 TYR C 273      68.498  -9.912  23.578  1.00 24.94           C  
ATOM   4095  CE2 TYR C 273      69.045 -12.152  22.866  1.00 26.56           C  
ATOM   4096  CZ  TYR C 273      69.436 -10.915  23.352  1.00 26.48           C  
ATOM   4097  OH  TYR C 273      70.774 -10.699  23.590  1.00 30.04           O  
ATOM   4098  N   GLU C 274      62.392 -10.875  23.397  1.00 20.84           N  
ATOM   4099  CA  GLU C 274      60.994 -10.710  23.095  1.00 21.17           C  
ATOM   4100  C   GLU C 274      60.867  -9.419  22.262  1.00 21.68           C  
ATOM   4101  O   GLU C 274      61.185  -8.314  22.753  1.00 23.79           O  
ATOM   4102  CB  GLU C 274      60.264 -10.617  24.437  1.00 23.22           C  
ATOM   4103  CG  GLU C 274      58.771 -10.783  24.444  1.00 24.45           C  
ATOM   4104  CD  GLU C 274      58.244 -11.047  25.852  1.00 27.14           C  
ATOM   4105  OE1 GLU C 274      57.522 -10.186  26.396  1.00 30.94           O  
ATOM   4106  OE2 GLU C 274      58.566 -12.112  26.422  1.00 28.27           O  
ATOM   4107  N   TYR C 275      60.435  -9.550  21.006  1.00 19.97           N  
ATOM   4108  CA  TYR C 275      60.310  -8.384  20.117  1.00 20.69           C  
ATOM   4109  C   TYR C 275      58.895  -8.058  19.678  1.00 20.41           C  
ATOM   4110  O   TYR C 275      58.092  -8.937  19.475  1.00 18.70           O  
ATOM   4111  CB  TYR C 275      61.135  -8.604  18.845  1.00 19.56           C  
ATOM   4112  CG  TYR C 275      62.554  -9.061  19.092  1.00 21.01           C  
ATOM   4113  CD1 TYR C 275      62.930 -10.414  18.952  1.00 18.70           C  
ATOM   4114  CD2 TYR C 275      63.539  -8.142  19.438  1.00 23.86           C  
ATOM   4115  CE1 TYR C 275      64.251 -10.812  19.163  1.00 19.16           C  
ATOM   4116  CE2 TYR C 275      64.855  -8.553  19.668  1.00 24.19           C  
ATOM   4117  CZ  TYR C 275      65.191  -9.868  19.526  1.00 20.95           C  
ATOM   4118  OH  TYR C 275      66.488 -10.196  19.766  1.00 23.74           O  
ATOM   4119  N   LYS C 276      58.601  -6.786  19.463  1.00 22.97           N  
ATOM   4120  CA  LYS C 276      57.359  -6.450  18.762  1.00 23.59           C  
ATOM   4121  C   LYS C 276      57.640  -5.970  17.361  1.00 23.32           C  
ATOM   4122  O   LYS C 276      58.628  -5.280  17.147  1.00 24.75           O  
ATOM   4123  CB  LYS C 276      56.554  -5.419  19.508  1.00 26.12           C  
ATOM   4124  CG  LYS C 276      55.117  -5.837  19.640  1.00 27.39           C  
ATOM   4125  CD  LYS C 276      54.249  -4.619  19.826  1.00 32.94           C  
ATOM   4126  CE  LYS C 276      52.885  -4.985  20.384  1.00 36.02           C  
ATOM   4127  NZ  LYS C 276      52.047  -3.759  20.562  1.00 41.44           N  
ATOM   4128  N   LEU C 277      56.789  -6.369  16.410  1.00 22.53           N  
ATOM   4129  CA  LEU C 277      56.838  -5.887  15.025  1.00 22.24           C  
ATOM   4130  C   LEU C 277      55.504  -5.337  14.537  1.00 22.81           C  
ATOM   4131  O   LEU C 277      54.520  -6.061  14.485  1.00 21.96           O  
ATOM   4132  CB  LEU C 277      57.230  -7.029  14.096  1.00 20.87           C  
ATOM   4133  CG  LEU C 277      58.634  -7.200  13.527  1.00 21.22           C  
ATOM   4134  CD1 LEU C 277      59.649  -7.117  14.595  1.00 22.87           C  
ATOM   4135  CD2 LEU C 277      58.680  -8.573  12.924  1.00 22.75           C  
ATOM   4136  N   GLN C 278      55.460  -4.070  14.140  1.00 25.08           N  
ATOM   4137  CA  GLN C 278      54.299  -3.580  13.399  1.00 25.62           C  
ATOM   4138  C   GLN C 278      54.159  -4.335  12.078  1.00 22.91           C  
ATOM   4139  O   GLN C 278      55.155  -4.638  11.417  1.00 21.89           O  
ATOM   4140  CB  GLN C 278      54.426  -2.106  13.129  1.00 28.84           C  
ATOM   4141  CG  GLN C 278      54.502  -1.251  14.365  1.00 34.13           C  
ATOM   4142  CD  GLN C 278      53.718  -1.825  15.508  1.00 36.15           C  
ATOM   4143  OE1 GLN C 278      52.492  -1.892  15.471  1.00 39.47           O  
ATOM   4144  NE2 GLN C 278      54.427  -2.258  16.538  1.00 38.18           N  
ATOM   4145  N   HIS C 279      52.936  -4.679  11.696  1.00 21.95           N  
ATOM   4146  CA  HIS C 279      52.766  -5.351  10.406  1.00 19.21           C  
ATOM   4147  C   HIS C 279      53.400  -4.484   9.307  1.00 19.80           C  
ATOM   4148  O   HIS C 279      54.005  -5.016   8.379  1.00 18.60           O  
ATOM   4149  CB  HIS C 279      51.306  -5.650  10.097  1.00 19.16           C  
ATOM   4150  CG  HIS C 279      50.728  -6.772  10.900  1.00 18.22           C  
ATOM   4151  ND1 HIS C 279      49.389  -6.831  11.244  1.00 22.16           N  
ATOM   4152  CD2 HIS C 279      51.297  -7.873  11.433  1.00 15.18           C  
ATOM   4153  CE1 HIS C 279      49.166  -7.917  11.959  1.00 18.24           C  
ATOM   4154  NE2 HIS C 279      50.307  -8.569  12.085  1.00 15.21           N  
ATOM   4155  N   ARG C 280      53.285  -3.160   9.456  1.00 21.35           N  
ATOM   4156  CA  ARG C 280      53.905  -2.197   8.542  1.00 23.00           C  
ATOM   4157  C   ARG C 280      55.405  -2.446   8.296  1.00 23.34           C  
ATOM   4158  O   ARG C 280      55.922  -2.112   7.237  1.00 24.78           O  
ATOM   4159  CB  ARG C 280      53.691  -0.737   9.045  1.00 25.74           C  
ATOM   4160  CG  ARG C 280      54.120   0.326   8.061  1.00 25.98           C  
ATOM   4161  CD  ARG C 280      53.529   1.736   8.341  1.00 31.45           C  
ATOM   4162  NE  ARG C 280      53.675   2.587   7.156  1.00 30.10           N  
ATOM   4163  CZ  ARG C 280      54.630   3.485   6.966  1.00 33.11           C  
ATOM   4164  NH1 ARG C 280      55.522   3.732   7.912  1.00 33.88           N  
ATOM   4165  NH2 ARG C 280      54.665   4.165   5.828  1.00 35.76           N  
ATOM   4166  N   GLN C 281      56.110  -2.977   9.291  1.00 23.23           N  
ATOM   4167  CA  GLN C 281      57.550  -3.285   9.144  1.00 23.53           C  
ATOM   4168  C   GLN C 281      57.823  -4.431   8.171  1.00 22.05           C  
ATOM   4169  O   GLN C 281      58.936  -4.550   7.639  1.00 24.14           O  
ATOM   4170  CB  GLN C 281      58.232  -3.556  10.490  1.00 22.33           C  
ATOM   4171  CG  GLN C 281      58.420  -2.300  11.331  1.00 25.68           C  
ATOM   4172  CD  GLN C 281      58.933  -2.615  12.702  1.00 24.26           C  
ATOM   4173  OE1 GLN C 281      58.158  -2.817  13.633  1.00 24.26           O  
ATOM   4174  NE2 GLN C 281      60.245  -2.697  12.835  1.00 26.72           N  
ATOM   4175  N   ILE C 282      56.827  -5.261   7.913  1.00 19.65           N  
ATOM   4176  CA  ILE C 282      57.038  -6.316   6.941  1.00 18.36           C  
ATOM   4177  C   ILE C 282      56.960  -5.744   5.499  1.00 20.18           C  
ATOM   4178  O   ILE C 282      55.912  -5.269   5.049  1.00 20.13           O  
ATOM   4179  CB  ILE C 282      56.121  -7.496   7.218  1.00 15.84           C  
ATOM   4180  CG1 ILE C 282      56.340  -7.937   8.686  1.00 15.35           C  
ATOM   4181  CG2 ILE C 282      56.421  -8.609   6.253  1.00 15.18           C  
ATOM   4182  CD1 ILE C 282      55.610  -9.156   9.146  1.00 11.80           C  
ATOM   4183  N   GLN C 283      58.093  -5.764   4.799  1.00 21.23           N  
ATOM   4184  CA  GLN C 283      58.181  -5.109   3.496  1.00 23.03           C  
ATOM   4185  C   GLN C 283      58.074  -6.102   2.342  1.00 22.37           C  
ATOM   4186  O   GLN C 283      57.613  -5.722   1.259  1.00 24.02           O  
ATOM   4187  CB  GLN C 283      59.464  -4.279   3.378  1.00 25.36           C  
ATOM   4188  CG  GLN C 283      59.641  -3.273   4.491  1.00 27.32           C  
ATOM   4189  CD  GLN C 283      59.119  -1.868   4.160  1.00 33.34           C  
ATOM   4190  OE1 GLN C 283      59.636  -1.195   3.268  1.00 38.00           O  
ATOM   4191  NE2 GLN C 283      58.104  -1.416   4.896  1.00 33.33           N  
ATOM   4192  N   ARG C 284      58.524  -7.341   2.576  1.00 20.40           N  
ATOM   4193  CA  ARG C 284      58.558  -8.435   1.586  1.00 20.00           C  
ATOM   4194  C   ARG C 284      58.454  -9.789   2.315  1.00 17.77           C  
ATOM   4195  O   ARG C 284      59.026  -9.995   3.398  1.00 16.37           O  
ATOM   4196  CB  ARG C 284      59.886  -8.482   0.798  1.00 22.60           C  
ATOM   4197  CG  ARG C 284      60.446  -7.199   0.192  1.00 26.85           C  
ATOM   4198  CD  ARG C 284      60.298  -7.126  -1.328  1.00 30.54           C  
ATOM   4199  NE  ARG C 284      61.261  -6.191  -1.897  1.00 35.70           N  
ATOM   4200  CZ  ARG C 284      60.989  -5.342  -2.886  1.00 43.43           C  
ATOM   4201  NH1 ARG C 284      59.760  -5.295  -3.399  1.00 44.10           N  
ATOM   4202  NH2 ARG C 284      61.932  -4.513  -3.359  1.00 47.80           N  
ATOM   4203  N   ILE C 285      57.744 -10.733   1.719  1.00 14.38           N  
ATOM   4204  CA  ILE C 285      57.660 -12.069   2.305  1.00 11.18           C  
ATOM   4205  C   ILE C 285      58.137 -13.018   1.237  1.00 10.85           C  
ATOM   4206  O   ILE C 285      57.577 -13.051   0.146  1.00 13.48           O  
ATOM   4207  CB  ILE C 285      56.238 -12.422   2.722  1.00 10.48           C  
ATOM   4208  CG1 ILE C 285      55.660 -11.323   3.606  1.00 11.49           C  
ATOM   4209  CG2 ILE C 285      56.232 -13.738   3.468  1.00  9.14           C  
ATOM   4210  CD1 ILE C 285      54.260 -11.652   4.177  1.00 12.91           C  
ATOM   4211  N   VAL C 286      59.213 -13.736   1.513  1.00  8.72           N  
ATOM   4212  CA  VAL C 286      59.699 -14.720   0.549  1.00  9.58           C  
ATOM   4213  C   VAL C 286      59.547 -16.136   1.095  1.00  7.96           C  
ATOM   4214  O   VAL C 286      59.805 -16.404   2.287  1.00  5.43           O  
ATOM   4215  CB  VAL C 286      61.165 -14.444   0.096  1.00 10.57           C  
ATOM   4216  CG1 VAL C 286      61.505 -15.306  -1.087  1.00 12.15           C  
ATOM   4217  CG2 VAL C 286      61.351 -12.970  -0.286  1.00 12.22           C  
ATOM   4218  N   SER C 287      59.107 -17.027   0.224  1.00  9.21           N  
ATOM   4219  CA  SER C 287      58.945 -18.421   0.602  1.00 10.05           C  
ATOM   4220  C   SER C 287      59.693 -19.320  -0.388  1.00 12.67           C  
ATOM   4221  O   SER C 287      59.376 -19.313  -1.579  1.00 15.31           O  
ATOM   4222  CB  SER C 287      57.459 -18.776   0.702  1.00 10.17           C  
ATOM   4223  OG  SER C 287      57.307 -20.136   1.051  1.00 12.40           O  
ATOM   4224  N   LEU C 288      60.681 -20.072   0.108  1.00 12.95           N  
ATOM   4225  CA  LEU C 288      61.593 -20.864  -0.742  1.00 16.98           C  
ATOM   4226  C   LEU C 288      61.963 -22.187  -0.108  1.00 17.79           C  
ATOM   4227  O   LEU C 288      62.078 -22.264   1.121  1.00 16.34           O  
ATOM   4228  CB  LEU C 288      62.943 -20.157  -0.909  1.00 17.83           C  
ATOM   4229  CG  LEU C 288      63.066 -18.656  -1.107  1.00 18.43           C  
ATOM   4230  CD1 LEU C 288      64.440 -18.228  -0.660  1.00 17.80           C  
ATOM   4231  CD2 LEU C 288      62.826 -18.315  -2.590  1.00 21.02           C  
ATOM   4232  N   PRO C 289      62.188 -23.222  -0.935  1.00 21.10           N  
ATOM   4233  CA  PRO C 289      62.852 -24.435  -0.453  1.00 22.90           C  
ATOM   4234  C   PRO C 289      64.325 -24.183  -0.131  1.00 22.85           C  
ATOM   4235  O   PRO C 289      65.028 -23.501  -0.886  1.00 23.69           O  
ATOM   4236  CB  PRO C 289      62.753 -25.412  -1.644  1.00 26.95           C  
ATOM   4237  CG  PRO C 289      61.842 -24.793  -2.616  1.00 27.33           C  
ATOM   4238  CD  PRO C 289      61.800 -23.326  -2.357  1.00 24.35           C  
ATOM   4239  N   LYS C 290      64.782 -24.743   0.984  1.00 22.77           N  
ATOM   4240  CA  LYS C 290      66.185 -24.719   1.362  1.00 23.66           C  
ATOM   4241  C   LYS C 290      66.886 -25.753   0.515  1.00 28.15           C  
ATOM   4242  O   LYS C 290      66.309 -26.803   0.198  1.00 31.59           O  
ATOM   4243  CB  LYS C 290      66.347 -25.040   2.851  1.00 23.00           C  
ATOM   4244  CG  LYS C 290      67.507 -24.340   3.531  1.00 21.43           C  
ATOM   4245  CD  LYS C 290      67.914 -25.060   4.788  1.00 22.15           C  
ATOM   4246  CE  LYS C 290      69.376 -24.769   5.138  1.00 24.06           C  
ATOM   4247  NZ  LYS C 290      69.719 -25.416   6.440  1.00 26.14           N  
ATOM   4248  N   ALA C 291      68.118 -25.457   0.134  1.00 29.46           N  
ATOM   4249  CA  ALA C 291      68.871 -26.322  -0.772  1.00 34.70           C  
ATOM   4250  C   ALA C 291      69.041 -27.737  -0.234  1.00 38.77           C  
ATOM   4251  O   ALA C 291      69.143 -28.685  -1.017  1.00 43.94           O  
ATOM   4252  CB  ALA C 291      70.226 -25.716  -1.086  1.00 35.65           C  
ATOM   4253  N   ASP C 292      69.077 -27.880   1.091  1.00 37.53           N  
ATOM   4254  CA  ASP C 292      69.235 -29.200   1.722  1.00 42.01           C  
ATOM   4255  C   ASP C 292      68.125 -30.199   1.354  1.00 44.39           C  
ATOM   4256  O   ASP C 292      68.261 -31.399   1.602  1.00 49.53           O  
ATOM   4257  CB  ASP C 292      69.411 -29.085   3.254  1.00 40.29           C  
ATOM   4258  CG  ASP C 292      68.152 -28.583   3.983  1.00 36.97           C  
ATOM   4259  OD1 ASP C 292      67.142 -28.153   3.354  1.00 30.89           O  
ATOM   4260  OD2 ASP C 292      68.195 -28.611   5.233  1.00 38.99           O  
ATOM   4261  N   ASP C 293      67.043 -29.689   0.753  1.00 41.46           N  
ATOM   4262  CA  ASP C 293      65.880 -30.493   0.347  1.00 43.33           C  
ATOM   4263  C   ASP C 293      65.056 -31.107   1.500  1.00 42.68           C  
ATOM   4264  O   ASP C 293      64.199 -31.950   1.265  1.00 45.33           O  
ATOM   4265  CB  ASP C 293      66.269 -31.572  -0.692  1.00 50.32           C  
ATOM   4266  CG  ASP C 293      65.054 -32.150  -1.433  1.00 53.82           C  
ATOM   4267  OD1 ASP C 293      64.074 -31.392  -1.648  1.00 51.21           O  
ATOM   4268  OD2 ASP C 293      65.069 -33.359  -1.790  1.00 59.53           O  
ATOM   4269  N   ILE C 294      65.313 -30.665   2.727  1.00 39.87           N  
ATOM   4270  CA  ILE C 294      64.528 -31.111   3.877  1.00 39.50           C  
ATOM   4271  C   ILE C 294      63.700 -29.976   4.474  1.00 33.48           C  
ATOM   4272  O   ILE C 294      62.602 -30.192   4.987  1.00 32.58           O  
ATOM   4273  CB  ILE C 294      65.427 -31.711   4.975  1.00 44.01           C  
ATOM   4274  CG1 ILE C 294      66.086 -30.598   5.791  1.00 40.27           C  
ATOM   4275  CG2 ILE C 294      66.478 -32.624   4.363  1.00 50.63           C  
ATOM   4276  CD1 ILE C 294      66.804 -31.092   7.029  1.00 47.50           C  
ATOM   4277  N   HIS C 295      64.242 -28.765   4.400  1.00 29.86           N  
ATOM   4278  CA  HIS C 295      63.646 -27.593   5.026  1.00 25.35           C  
ATOM   4279  C   HIS C 295      63.000 -26.638   4.028  1.00 22.55           C  
ATOM   4280  O   HIS C 295      63.467 -26.501   2.906  1.00 23.97           O  
ATOM   4281  CB  HIS C 295      64.704 -26.861   5.831  1.00 23.74           C  
ATOM   4282  CG  HIS C 295      65.160 -27.618   7.029  1.00 27.78           C  
ATOM   4283  ND1 HIS C 295      66.351 -28.310   7.060  1.00 33.78           N  
ATOM   4284  CD2 HIS C 295      64.571 -27.821   8.233  1.00 28.51           C  
ATOM   4285  CE1 HIS C 295      66.478 -28.911   8.231  1.00 37.35           C  
ATOM   4286  NE2 HIS C 295      65.418 -28.619   8.965  1.00 36.00           N  
ATOM   4287  N   HIS C 296      61.915 -25.998   4.440  1.00 20.33           N  
ATOM   4288  CA  HIS C 296      61.340 -24.876   3.697  1.00 17.83           C  
ATOM   4289  C   HIS C 296      61.610 -23.646   4.502  1.00 15.39           C  
ATOM   4290  O   HIS C 296      61.642 -23.717   5.731  1.00 14.98           O  
ATOM   4291  CB  HIS C 296      59.820 -24.993   3.531  1.00 17.11           C  
ATOM   4292  CG  HIS C 296      59.285 -24.145   2.422  1.00 15.23           C  
ATOM   4293  ND1 HIS C 296      59.176 -24.597   1.125  1.00 18.37           N  
ATOM   4294  CD2 HIS C 296      58.897 -22.847   2.400  1.00 12.53           C  
ATOM   4295  CE1 HIS C 296      58.722 -23.622   0.356  1.00 16.82           C  
ATOM   4296  NE2 HIS C 296      58.550 -22.546   1.107  1.00 12.63           N  
ATOM   4297  N   LEU C 297      61.749 -22.521   3.798  1.00 14.48           N  
ATOM   4298  CA  LEU C 297      62.134 -21.250   4.378  1.00 12.83           C  
ATOM   4299  C   LEU C 297      61.120 -20.178   4.120  1.00 11.66           C  
ATOM   4300  O   LEU C 297      60.488 -20.140   3.065  1.00 13.13           O  
ATOM   4301  CB  LEU C 297      63.453 -20.762   3.782  1.00 13.28           C  
ATOM   4302  CG  LEU C 297      64.669 -21.669   3.884  1.00 16.47           C  
ATOM   4303  CD1 LEU C 297      65.914 -20.973   3.301  1.00 18.17           C  
ATOM   4304  CD2 LEU C 297      64.889 -22.040   5.323  1.00 17.36           C  
ATOM   4305  N   LEU C 298      60.997 -19.280   5.087  1.00 10.60           N  
ATOM   4306  CA  LEU C 298      60.157 -18.117   4.967  1.00  9.21           C  
ATOM   4307  C   LEU C 298      60.973 -16.956   5.453  1.00  7.88           C  
ATOM   4308  O   LEU C 298      61.488 -16.982   6.559  1.00  8.01           O  
ATOM   4309  CB  LEU C 298      58.924 -18.243   5.830  1.00  8.94           C  
ATOM   4310  CG  LEU C 298      57.629 -18.773   5.248  1.00 11.85           C  
ATOM   4311  CD1 LEU C 298      56.543 -18.410   6.274  1.00 15.40           C  
ATOM   4312  CD2 LEU C 298      57.241 -18.214   3.891  1.00 13.24           C  
ATOM   4313  N   VAL C 299      61.089 -15.952   4.604  1.00  7.33           N  
ATOM   4314  CA  VAL C 299      61.953 -14.829   4.849  1.00  7.53           C  
ATOM   4315  C   VAL C 299      61.096 -13.546   4.904  1.00  8.37           C  
ATOM   4316  O   VAL C 299      60.273 -13.287   4.006  1.00  8.25           O  
ATOM   4317  CB  VAL C 299      63.034 -14.701   3.732  1.00  8.40           C  
ATOM   4318  CG1 VAL C 299      63.848 -13.431   3.930  1.00  8.36           C  
ATOM   4319  CG2 VAL C 299      63.929 -15.948   3.686  1.00  7.29           C  
ATOM   4320  N   LEU C 300      61.308 -12.750   5.952  1.00  8.71           N  
ATOM   4321  CA  LEU C 300      60.609 -11.497   6.096  1.00 10.48           C  
ATOM   4322  C   LEU C 300      61.606 -10.333   6.121  1.00 12.24           C  
ATOM   4323  O   LEU C 300      62.442 -10.239   7.020  1.00 13.19           O  
ATOM   4324  CB  LEU C 300      59.702 -11.503   7.352  1.00 10.67           C  
ATOM   4325  CG  LEU C 300      58.882 -12.740   7.778  1.00  9.22           C  
ATOM   4326  CD1 LEU C 300      58.278 -12.569   9.181  1.00  7.49           C  
ATOM   4327  CD2 LEU C 300      57.802 -13.032   6.775  1.00  5.96           C  
ATOM   4328  N   ALA C 301      61.512  -9.472   5.114  1.00 13.52           N  
ATOM   4329  CA  ALA C 301      62.283  -8.241   5.051  1.00 16.44           C  
ATOM   4330  C   ALA C 301      61.637  -7.226   5.966  1.00 18.38           C  
ATOM   4331  O   ALA C 301      60.432  -6.925   5.826  1.00 19.54           O  
ATOM   4332  CB  ALA C 301      62.319  -7.704   3.617  1.00 18.27           C  
ATOM   4333  N   ILE C 302      62.437  -6.698   6.893  1.00 19.32           N  
ATOM   4334  CA  ILE C 302      61.922  -5.835   7.966  1.00 22.00           C  
ATOM   4335  C   ILE C 302      62.454  -4.407   7.885  1.00 25.79           C  
ATOM   4336  O   ILE C 302      63.663  -4.193   7.842  1.00 26.84           O  
ATOM   4337  CB  ILE C 302      62.177  -6.452   9.380  1.00 21.16           C  
ATOM   4338  CG1 ILE C 302      61.860  -7.940   9.387  1.00 18.18           C  
ATOM   4339  CG2 ILE C 302      61.270  -5.846  10.411  1.00 24.77           C  
ATOM   4340  CD1 ILE C 302      60.394  -8.231   9.111  1.00 18.57           C  
ATOM   4341  N   GLU C 303      61.540  -3.438   7.857  1.00 28.44           N  
ATOM   4342  CA  GLU C 303      61.895  -2.008   7.779  1.00 33.58           C  
ATOM   4343  C   GLU C 303      61.013  -1.114   8.669  1.00 36.97           C  
ATOM   4344  O   GLU C 303      59.807  -1.039   8.465  1.00 37.51           O  
ATOM   4345  CB  GLU C 303      61.798  -1.525   6.334  1.00 35.59           C  
ATOM   4346  CG  GLU C 303      63.112  -1.217   5.676  1.00 38.91           C  
ATOM   4347  CD  GLU C 303      63.790  -0.077   6.367  1.00 45.78           C  
ATOM   4348  OE1 GLU C 303      63.063   0.819   6.859  1.00 52.01           O  
ATOM   4349  OE2 GLU C 303      65.036  -0.078   6.445  1.00 47.26           O  
ATOM   4350  N   PRO C 304      61.630  -0.451   9.642  1.00 40.12           N  
ATOM   4351  CA  PRO C 304      63.075  -0.570   9.860  1.00 40.36           C  
ATOM   4352  C   PRO C 304      63.459  -1.957  10.364  1.00 35.23           C  
ATOM   4353  O   PRO C 304      62.603  -2.836  10.464  1.00 31.76           O  
ATOM   4354  CB  PRO C 304      63.348   0.477  10.941  1.00 45.56           C  
ATOM   4355  CG  PRO C 304      62.286   1.498  10.744  1.00 48.94           C  
ATOM   4356  CD  PRO C 304      61.066   0.743  10.297  1.00 45.24           C  
ATOM   4357  N   PRO C 305      64.738  -2.144  10.679  1.00 35.18           N  
ATOM   4358  CA  PRO C 305      65.260  -3.470  11.024  1.00 31.03           C  
ATOM   4359  C   PRO C 305      64.861  -3.885  12.437  1.00 32.28           C  
ATOM   4360  O   PRO C 305      64.446  -3.043  13.232  1.00 35.91           O  
ATOM   4361  CB  PRO C 305      66.775  -3.276  10.941  1.00 31.50           C  
ATOM   4362  CG  PRO C 305      66.954  -2.181   9.952  1.00 36.18           C  
ATOM   4363  CD  PRO C 305      65.785  -1.257  10.146  1.00 38.80           C  
ATOM   4364  N   LEU C 306      64.990  -5.173  12.738  1.00 29.96           N  
ATOM   4365  CA  LEU C 306      64.809  -5.663  14.100  1.00 32.37           C  
ATOM   4366  C   LEU C 306      66.084  -5.493  14.920  1.00 36.37           C  
ATOM   4367  O   LEU C 306      67.171  -5.864  14.479  1.00 35.79           O  
ATOM   4368  CB  LEU C 306      64.383  -7.132  14.089  1.00 28.28           C  
ATOM   4369  CG  LEU C 306      63.959  -7.725  15.434  1.00 29.99           C  
ATOM   4370  CD1 LEU C 306      62.701  -8.565  15.279  1.00 24.33           C  
ATOM   4371  CD2 LEU C 306      65.086  -8.548  16.038  1.00 32.39           C  
ATOM   4372  N   ARG C 307      65.941  -4.931  16.116  1.00 41.77           N  
ATOM   4373  CA  ARG C 307      67.097  -4.667  16.989  1.00 46.51           C  
ATOM   4374  C   ARG C 307      67.119  -5.654  18.156  1.00 47.20           C  
ATOM   4375  O   ARG C 307      66.175  -5.720  18.939  1.00 48.58           O  
ATOM   4376  CB  ARG C 307      67.047  -3.237  17.558  1.00 52.76           C  
ATOM   4377  CG  ARG C 307      66.880  -2.117  16.528  1.00 55.80           C  
ATOM   4378  CD  ARG C 307      68.210  -1.435  16.162  1.00 61.38           C  
ATOM   4379  NE  ARG C 307      68.113  -0.689  14.898  1.00 62.68           N  
ATOM   4380  CZ  ARG C 307      68.315   0.624  14.741  1.00 69.29           C  
ATOM   4381  NH1 ARG C 307      68.658   1.412  15.767  1.00 74.53           N  
ATOM   4382  NH2 ARG C 307      68.188   1.153  13.526  1.00 69.13           N  
ATOM   4383  N   LYS C 308      68.188  -6.433  18.253  1.00 47.25           N  
ATOM   4384  CA  LYS C 308      68.467  -7.206  19.455  1.00 50.40           C  
ATOM   4385  C   LYS C 308      69.764  -6.621  19.982  1.00 55.32           C  
ATOM   4386  O   LYS C 308      70.784  -6.629  19.287  1.00 54.60           O  
ATOM   4387  CB  LYS C 308      68.544  -8.723  19.162  1.00 46.74           C  
ATOM   4388  CG  LYS C 308      69.933  -9.356  19.035  1.00 48.60           C  
ATOM   4389  CD  LYS C 308      70.564  -9.682  20.403  1.00 53.79           C  
ATOM   4390  CE  LYS C 308      72.088  -9.475  20.383  1.00 58.05           C  
ATOM   4391  NZ  LYS C 308      72.800 -10.110  19.228  1.00 54.67           N  
ATOM   4392  N   GLY C 309      69.710  -6.056  21.184  1.00 61.32           N  
ATOM   4393  CA  GLY C 309      70.838  -5.270  21.707  1.00 67.04           C  
ATOM   4394  C   GLY C 309      71.384  -4.332  20.632  1.00 66.30           C  
ATOM   4395  O   GLY C 309      70.615  -3.776  19.841  1.00 64.23           O  
ATOM   4396  N   GLN C 310      72.709  -4.206  20.569  1.00 68.36           N  
ATOM   4397  CA  GLN C 310      73.378  -3.239  19.682  1.00 68.71           C  
ATOM   4398  C   GLN C 310      73.342  -3.592  18.198  1.00 61.89           C  
ATOM   4399  O   GLN C 310      73.857  -2.836  17.363  1.00 62.47           O  
ATOM   4400  CB  GLN C 310      74.835  -3.093  20.090  1.00 73.93           C  
ATOM   4401  CG  GLN C 310      75.040  -2.932  21.566  1.00 81.82           C  
ATOM   4402  CD  GLN C 310      76.438  -3.325  21.974  1.00 87.80           C  
ATOM   4403  OE1 GLN C 310      77.420  -2.724  21.531  1.00 91.64           O  
ATOM   4404  NE2 GLN C 310      76.541  -4.341  22.828  1.00 89.67           N  
ATOM   4405  N   THR C 311      72.736  -4.735  17.875  1.00 55.36           N  
ATOM   4406  CA  THR C 311      72.822  -5.286  16.533  1.00 48.89           C  
ATOM   4407  C   THR C 311      71.474  -5.415  15.815  1.00 44.06           C  
ATOM   4408  O   THR C 311      70.413  -5.458  16.445  1.00 43.87           O  
ATOM   4409  CB  THR C 311      73.655  -6.597  16.502  1.00 47.35           C  
ATOM   4410  OG1 THR C 311      73.073  -7.520  15.574  1.00 40.13           O  
ATOM   4411  CG2 THR C 311      73.740  -7.238  17.884  1.00 49.65           C  
ATOM   4412  N   THR C 312      71.550  -5.507  14.490  1.00 40.20           N  
ATOM   4413  CA  THR C 312      70.459  -5.151  13.589  1.00 37.05           C  
ATOM   4414  C   THR C 312      70.174  -6.288  12.612  1.00 31.59           C  
ATOM   4415  O   THR C 312      71.092  -6.858  12.039  1.00 30.70           O  
ATOM   4416  CB  THR C 312      70.849  -3.825  12.851  1.00 40.11           C  
ATOM   4417  OG1 THR C 312      70.556  -2.710  13.695  1.00 45.02           O  
ATOM   4418  CG2 THR C 312      70.149  -3.634  11.511  1.00 37.66           C  
ATOM   4419  N   TYR C 313      68.902  -6.626  12.440  1.00 28.69           N  
ATOM   4420  CA  TYR C 313      68.500  -7.622  11.463  1.00 24.74           C  
ATOM   4421  C   TYR C 313      67.420  -7.070  10.532  1.00 24.23           C  
ATOM   4422  O   TYR C 313      66.257  -6.944  10.939  1.00 24.22           O  
ATOM   4423  CB  TYR C 313      67.967  -8.894  12.125  1.00 22.41           C  
ATOM   4424  CG  TYR C 313      68.835  -9.493  13.208  1.00 24.75           C  
ATOM   4425  CD1 TYR C 313      69.794 -10.451  12.914  1.00 24.32           C  
ATOM   4426  CD2 TYR C 313      68.677  -9.111  14.536  1.00 27.28           C  
ATOM   4427  CE1 TYR C 313      70.584 -10.997  13.912  1.00 26.59           C  
ATOM   4428  CE2 TYR C 313      69.455  -9.653  15.532  1.00 28.75           C  
ATOM   4429  CZ  TYR C 313      70.402 -10.592  15.221  1.00 29.06           C  
ATOM   4430  OH  TYR C 313      71.175 -11.115  16.241  1.00 33.31           O  
ATOM   4431  N   PRO C 314      67.794  -6.753   9.272  1.00 24.14           N  
ATOM   4432  CA  PRO C 314      66.839  -6.335   8.231  1.00 23.19           C  
ATOM   4433  C   PRO C 314      66.077  -7.497   7.605  1.00 19.25           C  
ATOM   4434  O   PRO C 314      65.123  -7.279   6.844  1.00 19.27           O  
ATOM   4435  CB  PRO C 314      67.738  -5.691   7.176  1.00 24.83           C  
ATOM   4436  CG  PRO C 314      69.014  -6.480   7.284  1.00 25.09           C  
ATOM   4437  CD  PRO C 314      69.186  -6.751   8.769  1.00 25.34           C  
ATOM   4438  N   PHE C 315      66.489  -8.724   7.898  1.00 16.72           N  
ATOM   4439  CA  PHE C 315      65.805  -9.886   7.333  1.00 13.02           C  
ATOM   4440  C   PHE C 315      65.572 -10.880   8.433  1.00 11.64           C  
ATOM   4441  O   PHE C 315      66.482 -11.113   9.236  1.00 13.02           O  
ATOM   4442  CB  PHE C 315      66.694 -10.541   6.298  1.00 12.36           C  
ATOM   4443  CG  PHE C 315      66.682  -9.876   4.968  1.00 12.29           C  
ATOM   4444  CD1 PHE C 315      67.801  -9.206   4.507  1.00 13.24           C  
ATOM   4445  CD2 PHE C 315      65.566  -9.967   4.140  1.00 10.21           C  
ATOM   4446  CE1 PHE C 315      67.791  -8.617   3.221  1.00 14.07           C  
ATOM   4447  CE2 PHE C 315      65.548  -9.359   2.879  1.00 10.11           C  
ATOM   4448  CZ  PHE C 315      66.669  -8.701   2.419  1.00 12.61           C  
ATOM   4449  N   LEU C 316      64.370 -11.460   8.497  1.00  9.67           N  
ATOM   4450  CA  LEU C 316      64.131 -12.583   9.420  1.00  8.42           C  
ATOM   4451  C   LEU C 316      63.979 -13.821   8.585  1.00  7.57           C  
ATOM   4452  O   LEU C 316      63.399 -13.778   7.489  1.00  6.62           O  
ATOM   4453  CB  LEU C 316      62.911 -12.389  10.322  1.00  8.05           C  
ATOM   4454  CG  LEU C 316      62.808 -11.106  11.158  1.00 10.14           C  
ATOM   4455  CD1 LEU C 316      61.411 -10.900  11.761  1.00  6.88           C  
ATOM   4456  CD2 LEU C 316      63.866 -11.058  12.239  1.00 11.57           C  
ATOM   4457  N   VAL C 317      64.522 -14.921   9.097  1.00  8.34           N  
ATOM   4458  CA  VAL C 317      64.576 -16.162   8.344  1.00  8.28           C  
ATOM   4459  C   VAL C 317      64.051 -17.290   9.217  1.00  9.30           C  
ATOM   4460  O   VAL C 317      64.604 -17.576  10.291  1.00 11.04           O  
ATOM   4461  CB  VAL C 317      66.025 -16.464   7.873  1.00  9.68           C  
ATOM   4462  CG1 VAL C 317      66.085 -17.795   7.185  1.00 10.79           C  
ATOM   4463  CG2 VAL C 317      66.539 -15.377   6.928  1.00  8.37           C  
ATOM   4464  N   LEU C 318      62.966 -17.919   8.777  1.00  9.14           N  
ATOM   4465  CA  LEU C 318      62.341 -18.994   9.558  1.00 10.30           C  
ATOM   4466  C   LEU C 318      62.460 -20.297   8.787  1.00 11.92           C  
ATOM   4467  O   LEU C 318      62.247 -20.314   7.561  1.00 11.47           O  
ATOM   4468  CB  LEU C 318      60.871 -18.696   9.802  1.00  9.28           C  
ATOM   4469  CG  LEU C 318      60.429 -17.365  10.424  1.00 10.53           C  
ATOM   4470  CD1 LEU C 318      61.064 -16.084   9.774  1.00  7.94           C  
ATOM   4471  CD2 LEU C 318      58.906 -17.353  10.318  1.00 10.63           C  
ATOM   4472  N   GLN C 319      62.774 -21.379   9.504  1.00 13.70           N  
ATOM   4473  CA  GLN C 319      63.028 -22.674   8.889  1.00 14.97           C  
ATOM   4474  C   GLN C 319      61.959 -23.639   9.324  1.00 16.36           C  
ATOM   4475  O   GLN C 319      61.537 -23.606  10.485  1.00 17.34           O  
ATOM   4476  CB  GLN C 319      64.395 -23.228   9.312  1.00 17.19           C  
ATOM   4477  CG  GLN C 319      64.971 -24.239   8.342  1.00 18.21           C  
ATOM   4478  CD  GLN C 319      66.342 -24.781   8.749  1.00 22.34           C  
ATOM   4479  OE1 GLN C 319      67.366 -24.315   8.275  1.00 24.07           O  
ATOM   4480  NE2 GLN C 319      66.355 -25.793   9.600  1.00 25.71           N  
ATOM   4481  N   PHE C 320      61.528 -24.502   8.400  1.00 16.74           N  
ATOM   4482  CA  PHE C 320      60.515 -25.506   8.712  1.00 17.96           C  
ATOM   4483  C   PHE C 320      60.858 -26.838   8.083  1.00 21.79           C  
ATOM   4484  O   PHE C 320      61.484 -26.879   7.040  1.00 21.92           O  
ATOM   4485  CB  PHE C 320      59.150 -25.082   8.199  1.00 15.08           C  
ATOM   4486  CG  PHE C 320      58.660 -23.779   8.741  1.00 11.83           C  
ATOM   4487  CD1 PHE C 320      57.938 -23.728   9.920  1.00 11.88           C  
ATOM   4488  CD2 PHE C 320      58.894 -22.589   8.060  1.00  8.99           C  
ATOM   4489  CE1 PHE C 320      57.446 -22.488  10.416  1.00  9.15           C  
ATOM   4490  CE2 PHE C 320      58.427 -21.358   8.580  1.00  7.85           C  
ATOM   4491  CZ  PHE C 320      57.702 -21.330   9.761  1.00  5.84           C  
ATOM   4492  N   GLN C 321      60.447 -27.929   8.726  1.00 26.27           N  
ATOM   4493  CA  GLN C 321      60.339 -29.228   8.050  1.00 30.96           C  
ATOM   4494  C   GLN C 321      59.449 -28.987   6.869  1.00 29.76           C  
ATOM   4495  O   GLN C 321      58.354 -28.441   7.015  1.00 28.09           O  
ATOM   4496  CB  GLN C 321      59.602 -30.218   8.922  1.00 34.55           C  
ATOM   4497  CG  GLN C 321      60.005 -31.664   8.763  1.00 41.37           C  
ATOM   4498  CD  GLN C 321      61.139 -31.943   9.692  1.00 44.86           C  
ATOM   4499  OE1 GLN C 321      61.261 -33.028  10.266  1.00 47.19           O  
ATOM   4500  NE2 GLN C 321      61.967 -30.915   9.897  1.00 41.07           N  
ATOM   4501  N   LYS C 322      59.934 -29.366   5.704  1.00 32.18           N  
ATOM   4502  CA  LYS C 322      59.199 -29.246   4.468  1.00 33.03           C  
ATOM   4503  C   LYS C 322      57.785 -29.833   4.615  1.00 35.10           C  
ATOM   4504  O   LYS C 322      56.835 -29.336   4.009  1.00 34.16           O  
ATOM   4505  CB  LYS C 322      59.986 -29.965   3.367  1.00 36.75           C  
ATOM   4506  CG  LYS C 322      59.239 -30.235   2.066  1.00 39.91           C  
ATOM   4507  CD  LYS C 322      59.756 -31.505   1.374  1.00 46.91           C  
ATOM   4508  CE  LYS C 322      61.126 -31.294   0.778  1.00 47.10           C  
ATOM   4509  NZ  LYS C 322      61.666 -32.584   0.261  1.00 56.89           N  
ATOM   4510  N   ASP C 323      57.638 -30.854   5.447  1.00 38.55           N  
ATOM   4511  CA  ASP C 323      56.368 -31.554   5.530  1.00 42.23           C  
ATOM   4512  C   ASP C 323      55.571 -31.320   6.818  1.00 40.99           C  
ATOM   4513  O   ASP C 323      54.465 -31.844   6.954  1.00 43.24           O  
ATOM   4514  CB  ASP C 323      56.568 -33.073   5.252  1.00 49.18           C  
ATOM   4515  CG  ASP C 323      57.149 -33.344   3.842  1.00 53.22           C  
ATOM   4516  OD1 ASP C 323      57.019 -32.440   2.966  1.00 53.10           O  
ATOM   4517  OD2 ASP C 323      57.737 -34.435   3.608  1.00 58.05           O  
ATOM   4518  N   GLU C 324      56.101 -30.533   7.751  1.00 38.11           N  
ATOM   4519  CA  GLU C 324      55.394 -30.324   9.010  1.00 37.87           C  
ATOM   4520  C   GLU C 324      54.087 -29.538   8.809  1.00 34.62           C  
ATOM   4521  O   GLU C 324      53.986 -28.677   7.912  1.00 31.21           O  
ATOM   4522  CB  GLU C 324      56.302 -29.707  10.092  1.00 35.93           C  
ATOM   4523  CG  GLU C 324      56.430 -28.227  10.073  1.00 32.83           C  
ATOM   4524  CD  GLU C 324      57.188 -27.663  11.278  1.00 33.24           C  
ATOM   4525  OE1 GLU C 324      56.559 -26.839  11.998  1.00 33.95           O  
ATOM   4526  OE2 GLU C 324      58.398 -28.005  11.483  1.00 34.04           O  
ATOM   4527  N   GLU C 325      53.086 -29.876   9.621  1.00 35.69           N  
ATOM   4528  CA  GLU C 325      51.774 -29.244   9.542  1.00 33.67           C  
ATOM   4529  C   GLU C 325      51.336 -28.592  10.838  1.00 32.83           C  
ATOM   4530  O   GLU C 325      51.679 -29.090  11.917  1.00 35.31           O  
ATOM   4531  CB  GLU C 325      50.739 -30.277   9.163  1.00 37.06           C  
ATOM   4532  CG  GLU C 325      50.544 -30.378   7.700  1.00 37.00           C  
ATOM   4533  CD  GLU C 325      50.063 -31.724   7.279  1.00 41.90           C  
ATOM   4534  OE1 GLU C 325      48.918 -32.115   7.629  1.00 43.49           O  
ATOM   4535  OE2 GLU C 325      50.848 -32.379   6.575  1.00 44.12           O  
ATOM   4536  N   THR C 326      50.595 -27.484  10.737  1.00 29.46           N  
ATOM   4537  CA  THR C 326      49.781 -27.039  11.868  1.00 30.14           C  
ATOM   4538  C   THR C 326      48.307 -27.011  11.466  1.00 30.58           C  
ATOM   4539  O   THR C 326      47.959 -26.615  10.352  1.00 28.48           O  
ATOM   4540  CB  THR C 326      50.227 -25.665  12.524  1.00 28.29           C  
ATOM   4541  OG1 THR C 326      49.442 -24.568  12.023  1.00 27.20           O  
ATOM   4542  CG2 THR C 326      51.743 -25.355  12.329  1.00 25.85           C  
ATOM   4543  N   GLU C 327      47.454 -27.460  12.385  1.00 33.21           N  
ATOM   4544  CA  GLU C 327      46.012 -27.357  12.249  1.00 34.21           C  
ATOM   4545  C   GLU C 327      45.524 -26.278  13.214  1.00 33.10           C  
ATOM   4546  O   GLU C 327      45.550 -26.485  14.423  1.00 35.56           O  
ATOM   4547  CB  GLU C 327      45.370 -28.714  12.580  1.00 38.55           C  
ATOM   4548  CG  GLU C 327      43.886 -28.642  12.989  1.00 42.06           C  
ATOM   4549  CD  GLU C 327      43.412 -29.857  13.818  1.00 48.37           C  
ATOM   4550  OE1 GLU C 327      42.184 -30.107  13.857  1.00 53.30           O  
ATOM   4551  OE2 GLU C 327      44.248 -30.570  14.424  1.00 51.20           O  
ATOM   4552  N   VAL C 328      45.061 -25.133  12.716  1.00 30.32           N  
ATOM   4553  CA  VAL C 328      44.604 -24.095  13.654  1.00 30.02           C  
ATOM   4554  C   VAL C 328      43.275 -23.409  13.341  1.00 30.89           C  
ATOM   4555  O   VAL C 328      42.908 -23.234  12.174  1.00 29.79           O  
ATOM   4556  CB  VAL C 328      45.722 -23.035  13.928  1.00 27.20           C  
ATOM   4557  CG1 VAL C 328      46.077 -22.268  12.678  1.00 22.81           C  
ATOM   4558  CG2 VAL C 328      45.320 -22.089  15.073  1.00 28.69           C  
ATOM   4559  N   GLN C 329      42.553 -23.056  14.408  1.00 33.20           N  
ATOM   4560  CA  GLN C 329      41.420 -22.133  14.327  1.00 34.86           C  
ATOM   4561  C   GLN C 329      41.887 -20.745  14.745  1.00 33.03           C  
ATOM   4562  O   GLN C 329      42.511 -20.597  15.793  1.00 33.95           O  
ATOM   4563  CB  GLN C 329      40.269 -22.565  15.244  1.00 39.21           C  
ATOM   4564  CG  GLN C 329      39.385 -23.676  14.701  1.00 42.27           C  
ATOM   4565  CD  GLN C 329      38.331 -24.155  15.707  1.00 47.96           C  
ATOM   4566  OE1 GLN C 329      37.569 -23.355  16.278  1.00 50.57           O  
ATOM   4567  NE2 GLN C 329      38.266 -25.478  15.907  1.00 51.25           N  
ATOM   4568  N   LEU C 330      41.570 -19.739  13.932  1.00 31.51           N  
ATOM   4569  CA  LEU C 330      41.897 -18.336  14.226  1.00 30.89           C  
ATOM   4570  C   LEU C 330      40.966 -17.779  15.255  1.00 34.71           C  
ATOM   4571  O   LEU C 330      39.796 -18.138  15.296  1.00 38.07           O  
ATOM   4572  CB  LEU C 330      41.821 -17.451  12.976  1.00 29.29           C  
ATOM   4573  CG  LEU C 330      42.753 -17.770  11.807  1.00 25.52           C  
ATOM   4574  CD1 LEU C 330      42.830 -16.574  10.840  1.00 25.11           C  
ATOM   4575  CD2 LEU C 330      44.137 -18.218  12.293  1.00 22.24           C  
ATOM   4576  N   ASN C 331      41.487 -16.895  16.086  1.00 35.46           N  
ATOM   4577  CA  ASN C 331      40.726 -16.421  17.224  1.00 40.48           C  
ATOM   4578  C   ASN C 331      40.091 -15.071  16.894  1.00 42.67           C  
ATOM   4579  O   ASN C 331      40.656 -14.013  17.174  1.00 43.16           O  
ATOM   4580  CB  ASN C 331      41.612 -16.343  18.465  1.00 41.08           C  
ATOM   4581  CG  ASN C 331      40.947 -15.605  19.587  1.00 46.51           C  
ATOM   4582  OD1 ASN C 331      39.810 -15.913  19.954  1.00 49.16           O  
ATOM   4583  ND2 ASN C 331      41.638 -14.603  20.131  1.00 46.37           N  
ATOM   4584  N   LEU C 332      38.919 -15.115  16.271  1.00 44.37           N  
ATOM   4585  CA  LEU C 332      38.287 -13.899  15.782  1.00 46.51           C  
ATOM   4586  C   LEU C 332      36.781 -13.930  16.025  1.00 51.26           C  
ATOM   4587  O   LEU C 332      36.146 -14.994  15.943  1.00 51.53           O  
ATOM   4588  CB  LEU C 332      38.597 -13.673  14.291  1.00 43.50           C  
ATOM   4589  CG  LEU C 332      39.944 -13.124  13.776  1.00 40.10           C  
ATOM   4590  CD1 LEU C 332      39.916 -12.965  12.264  1.00 37.11           C  
ATOM   4591  CD2 LEU C 332      40.303 -11.784  14.405  1.00 42.39           C  
ATOM   4592  N   GLU C 333      36.222 -12.766  16.354  1.00 55.29           N  
ATOM   4593  CA  GLU C 333      34.779 -12.624  16.404  1.00 60.31           C  
ATOM   4594  C   GLU C 333      34.216 -12.654  14.986  1.00 59.47           C  
ATOM   4595  O   GLU C 333      34.796 -12.073  14.061  1.00 56.96           O  
ATOM   4596  CB  GLU C 333      34.358 -11.374  17.173  1.00 65.98           C  
ATOM   4597  CG  GLU C 333      33.640 -11.682  18.486  1.00 71.20           C  
ATOM   4598  CD  GLU C 333      32.094 -11.792  18.352  1.00 77.24           C  
ATOM   4599  OE1 GLU C 333      31.575 -12.234  17.289  1.00 76.17           O  
ATOM   4600  OE2 GLU C 333      31.392 -11.444  19.334  1.00 80.92           O  
ATOM   4601  N   ASP C 334      33.102 -13.366  14.831  1.00 61.77           N  
ATOM   4602  CA  ASP C 334      32.532 -13.680  13.524  1.00 61.37           C  
ATOM   4603  C   ASP C 334      32.232 -12.450  12.691  1.00 63.74           C  
ATOM   4604  O   ASP C 334      32.569 -12.408  11.499  1.00 61.47           O  
ATOM   4605  CB  ASP C 334      31.287 -14.538  13.696  1.00 64.92           C  
ATOM   4606  CG  ASP C 334      31.624 -15.948  14.126  1.00 62.01           C  
ATOM   4607  OD1 ASP C 334      30.891 -16.520  14.954  1.00 65.13           O  
ATOM   4608  OD2 ASP C 334      32.638 -16.480  13.639  1.00 55.71           O  
ATOM   4609  N   GLU C 335      31.619 -11.460  13.334  1.00 68.56           N  
ATOM   4610  CA  GLU C 335      31.361 -10.164  12.718  1.00 72.33           C  
ATOM   4611  C   GLU C 335      32.655  -9.461  12.284  1.00 69.00           C  
ATOM   4612  O   GLU C 335      32.750  -8.978  11.151  1.00 69.33           O  
ATOM   4613  CB  GLU C 335      30.538  -9.270  13.661  1.00 79.08           C  
ATOM   4614  CG  GLU C 335      29.689  -8.215  12.957  1.00 84.36           C  
ATOM   4615  CD  GLU C 335      28.461  -8.789  12.252  1.00 87.28           C  
ATOM   4616  OE1 GLU C 335      28.307 -10.043  12.172  1.00 83.87           O  
ATOM   4617  OE2 GLU C 335      27.636  -7.966  11.769  1.00 93.14           O  
ATOM   4618  N   ASP C 336      33.653  -9.412  13.171  1.00 66.42           N  
ATOM   4619  CA  ASP C 336      34.945  -8.827  12.812  1.00 63.05           C  
ATOM   4620  C   ASP C 336      35.568  -9.599  11.655  1.00 57.96           C  
ATOM   4621  O   ASP C 336      36.151  -8.996  10.751  1.00 57.33           O  
ATOM   4622  CB  ASP C 336      35.915  -8.759  14.002  1.00 61.29           C  
ATOM   4623  CG  ASP C 336      37.107  -7.824  13.738  1.00 60.09           C  
ATOM   4624  OD1 ASP C 336      36.911  -6.778  13.077  1.00 63.33           O  
ATOM   4625  OD2 ASP C 336      38.240  -8.122  14.185  1.00 56.27           O  
ATOM   4626  N   TYR C 337      35.437 -10.928  11.679  1.00 55.16           N  
ATOM   4627  CA  TYR C 337      35.867 -11.739  10.546  1.00 51.19           C  
ATOM   4628  C   TYR C 337      35.140 -11.306   9.269  1.00 54.46           C  
ATOM   4629  O   TYR C 337      35.786 -10.940   8.282  1.00 52.61           O  
ATOM   4630  CB  TYR C 337      35.690 -13.249  10.794  1.00 48.82           C  
ATOM   4631  CG  TYR C 337      36.047 -14.060   9.564  1.00 45.05           C  
ATOM   4632  CD1 TYR C 337      37.376 -14.369   9.275  1.00 39.86           C  
ATOM   4633  CD2 TYR C 337      35.057 -14.480   8.665  1.00 47.82           C  
ATOM   4634  CE1 TYR C 337      37.717 -15.091   8.136  1.00 38.06           C  
ATOM   4635  CE2 TYR C 337      35.379 -15.195   7.520  1.00 46.14           C  
ATOM   4636  CZ  TYR C 337      36.716 -15.500   7.264  1.00 41.87           C  
ATOM   4637  OH  TYR C 337      37.044 -16.207   6.141  1.00 40.33           O  
ATOM   4638  N   GLU C 338      33.803 -11.329   9.314  1.00 59.66           N  
ATOM   4639  CA  GLU C 338      32.964 -10.987   8.165  1.00 64.30           C  
ATOM   4640  C   GLU C 338      33.320  -9.632   7.553  1.00 66.55           C  
ATOM   4641  O   GLU C 338      33.705  -9.564   6.392  1.00 65.91           O  
ATOM   4642  CB  GLU C 338      31.473 -11.035   8.544  1.00 70.37           C  
ATOM   4643  CG  GLU C 338      30.594 -11.892   7.607  1.00 73.69           C  
ATOM   4644  CD  GLU C 338      31.016 -13.381   7.543  1.00 71.21           C  
ATOM   4645  OE1 GLU C 338      30.332 -14.167   6.846  1.00 73.97           O  
ATOM   4646  OE2 GLU C 338      32.029 -13.768   8.178  1.00 66.45           O  
ATOM   4647  N   GLU C 339      33.176  -8.571   8.340  1.00 69.97           N  
ATOM   4648  CA  GLU C 339      33.412  -7.219   7.854  1.00 74.15           C  
ATOM   4649  C   GLU C 339      34.793  -7.109   7.219  1.00 70.22           C  
ATOM   4650  O   GLU C 339      34.931  -6.638   6.090  1.00 73.16           O  
ATOM   4651  CB  GLU C 339      33.278  -6.209   8.995  1.00 79.98           C  
ATOM   4652  CG  GLU C 339      32.211  -5.150   8.765  1.00129.41           C  
ATOM   4653  CD  GLU C 339      32.574  -4.190   7.649  1.00132.12           C  
ATOM   4654  OE1 GLU C 339      33.017  -4.660   6.580  1.00129.28           O  
ATOM   4655  OE2 GLU C 339      32.416  -2.966   7.841  1.00137.77           O  
ATOM   4656  N   ASN C 340      35.812  -7.547   7.951  1.00 64.50           N  
ATOM   4657  CA  ASN C 340      37.184  -7.111   7.683  1.00 61.41           C  
ATOM   4658  C   ASN C 340      38.197  -8.131   7.202  1.00 55.07           C  
ATOM   4659  O   ASN C 340      39.273  -7.743   6.753  1.00 53.14           O  
ATOM   4660  CB  ASN C 340      37.766  -6.355   8.885  1.00 62.10           C  
ATOM   4661  CG  ASN C 340      37.170  -4.973   9.049  1.00 68.92           C  
ATOM   4662  OD1 ASN C 340      36.669  -4.638  10.114  1.00 72.59           O  
ATOM   4663  ND2 ASN C 340      37.217  -4.164   7.990  1.00 71.55           N  
ATOM   4664  N   TYR C 341      37.879  -9.420   7.290  1.00 52.47           N  
ATOM   4665  CA  TYR C 341      38.897 -10.448   7.037  1.00 46.15           C  
ATOM   4666  C   TYR C 341      38.462 -11.546   6.083  1.00 45.31           C  
ATOM   4667  O   TYR C 341      39.295 -12.319   5.623  1.00 41.38           O  
ATOM   4668  CB  TYR C 341      39.367 -11.050   8.366  1.00 43.36           C  
ATOM   4669  CG  TYR C 341      40.037 -10.049   9.293  1.00 43.55           C  
ATOM   4670  CD1 TYR C 341      41.330  -9.597   9.041  1.00 40.73           C  
ATOM   4671  CD2 TYR C 341      39.375  -9.548  10.411  1.00 47.57           C  
ATOM   4672  CE1 TYR C 341      41.954  -8.683   9.876  1.00 41.80           C  
ATOM   4673  CE2 TYR C 341      39.984  -8.625  11.263  1.00 49.44           C  
ATOM   4674  CZ  TYR C 341      41.287  -8.201  10.991  1.00 47.33           C  
ATOM   4675  OH  TYR C 341      41.918  -7.279  11.819  1.00 49.23           O  
ATOM   4676  N   LYS C 342      37.167 -11.591   5.765  1.00 49.50           N  
ATOM   4677  CA  LYS C 342      36.572 -12.736   5.072  1.00 49.97           C  
ATOM   4678  C   LYS C 342      37.216 -13.072   3.738  1.00 49.03           C  
ATOM   4679  O   LYS C 342      37.108 -14.209   3.262  1.00 48.57           O  
ATOM   4680  CB  LYS C 342      35.054 -12.592   4.908  1.00 55.87           C  
ATOM   4681  CG  LYS C 342      34.558 -11.402   4.079  1.00 60.89           C  
ATOM   4682  CD  LYS C 342      33.309 -11.768   3.278  1.00 65.92           C  
ATOM   4683  CE  LYS C 342      32.132 -12.192   4.150  1.00 68.55           C  
ATOM   4684  NZ  LYS C 342      31.133 -11.090   4.360  1.00 75.07           N  
ATOM   4685  N   ASP C 343      37.904 -12.093   3.156  1.00 49.40           N  
ATOM   4686  CA  ASP C 343      38.506 -12.250   1.835  1.00 49.16           C  
ATOM   4687  C   ASP C 343      40.024 -12.288   1.861  1.00 44.31           C  
ATOM   4688  O   ASP C 343      40.659 -12.240   0.807  1.00 44.92           O  
ATOM   4689  CB  ASP C 343      37.993 -11.170   0.879  1.00 54.86           C  
ATOM   4690  CG  ASP C 343      36.570 -11.450   0.393  1.00 60.76           C  
ATOM   4691  OD1 ASP C 343      36.349 -12.525  -0.209  1.00 61.47           O  
ATOM   4692  OD2 ASP C 343      35.670 -10.602   0.611  1.00 66.93           O  
ATOM   4693  N   LYS C 344      40.601 -12.396   3.058  1.00 40.02           N  
ATOM   4694  CA  LYS C 344      42.048 -12.483   3.203  1.00 35.28           C  
ATOM   4695  C   LYS C 344      42.555 -13.490   4.263  1.00 30.45           C  
ATOM   4696  O   LYS C 344      43.754 -13.726   4.390  1.00 26.71           O  
ATOM   4697  CB  LYS C 344      42.660 -11.083   3.364  1.00 36.37           C  
ATOM   4698  CG  LYS C 344      42.081 -10.223   4.462  1.00 40.51           C  
ATOM   4699  CD  LYS C 344      42.199  -8.751   4.069  1.00 48.45           C  
ATOM   4700  CE  LYS C 344      42.251  -7.809   5.280  1.00 52.10           C  
ATOM   4701  NZ  LYS C 344      43.181  -6.643   5.022  1.00 54.82           N  
ATOM   4702  N   LEU C 345      41.630 -14.082   5.007  1.00 30.77           N  
ATOM   4703  CA  LEU C 345      41.937 -15.155   5.937  1.00 27.58           C  
ATOM   4704  C   LEU C 345      40.824 -16.213   5.995  1.00 29.79           C  
ATOM   4705  O   LEU C 345      39.654 -15.931   5.767  0.50 32.66           O  
ATOM   4706  CB  LEU C 345      42.131 -14.597   7.333  1.00 26.69           C  
ATOM   4707  CG  LEU C 345      43.262 -13.632   7.679  1.00 24.00           C  
ATOM   4708  CD1 LEU C 345      43.020 -13.106   9.081  1.00 26.13           C  
ATOM   4709  CD2 LEU C 345      44.578 -14.296   7.611  1.00 17.75           C  
ATOM   4710  N   LYS C 346      41.241 -17.437   6.297  1.00 28.70           N  
ATOM   4711  CA  LYS C 346      40.356 -18.524   6.664  1.00 31.02           C  
ATOM   4712  C   LYS C 346      40.082 -18.464   8.157  1.00 31.50           C  
ATOM   4713  O   LYS C 346      40.892 -17.921   8.908  1.00 30.77           O  
ATOM   4714  CB  LYS C 346      41.033 -19.854   6.341  1.00 29.74           C  
ATOM   4715  CG  LYS C 346      40.731 -20.375   4.951  1.00 32.39           C  
ATOM   4716  CD  LYS C 346      41.750 -21.410   4.539  1.00 34.37           C  
ATOM   4717  CE  LYS C 346      42.028 -21.324   3.044  1.00 36.22           C  
ATOM   4718  NZ  LYS C 346      40.760 -21.252   2.306  1.00 40.25           N  
ATOM   4719  N   LYS C 347      38.959 -19.006   8.606  1.00 34.01           N  
ATOM   4720  CA  LYS C 347      38.777 -19.183  10.046  1.00 34.65           C  
ATOM   4721  C   LYS C 347      39.508 -20.425  10.592  1.00 33.31           C  
ATOM   4722  O   LYS C 347      39.919 -20.451  11.742  1.00 33.19           O  
ATOM   4723  CB  LYS C 347      37.304 -19.206  10.419  1.00 38.28           C  
ATOM   4724  CG  LYS C 347      36.711 -17.829  10.473  1.00 40.18           C  
ATOM   4725  CD  LYS C 347      35.222 -17.813  10.099  1.00 43.83           C  
ATOM   4726  CE  LYS C 347      34.306 -17.741  11.306  1.00 46.26           C  
ATOM   4727  NZ  LYS C 347      32.922 -17.349  10.908  1.00 50.89           N  
ATOM   4728  N   GLN C 348      39.687 -21.445   9.761  1.00 33.21           N  
ATOM   4729  CA  GLN C 348      40.372 -22.661  10.189  1.00 32.68           C  
ATOM   4730  C   GLN C 348      41.359 -23.149   9.143  1.00 30.18           C  
ATOM   4731  O   GLN C 348      41.012 -23.314   7.975  1.00 31.16           O  
ATOM   4732  CB  GLN C 348      39.367 -23.754  10.488  1.00 36.71           C  
ATOM   4733  CG  GLN C 348      39.880 -24.738  11.472  1.00 40.26           C  
ATOM   4734  CD  GLN C 348      39.515 -26.140  11.095  1.00 47.65           C  
ATOM   4735  OE1 GLN C 348      38.376 -26.595  11.320  1.00 52.21           O  
ATOM   4736  NE2 GLN C 348      40.485 -26.854  10.505  1.00 47.55           N  
ATOM   4737  N   TYR C 349      42.595 -23.385   9.570  1.00 27.66           N  
ATOM   4738  CA  TYR C 349      43.623 -23.864   8.666  1.00 25.21           C  
ATOM   4739  C   TYR C 349      44.038 -25.291   8.994  1.00 25.98           C  
ATOM   4740  O   TYR C 349      43.862 -25.751  10.118  1.00 27.56           O  
ATOM   4741  CB  TYR C 349      44.839 -22.952   8.730  1.00 22.43           C  
ATOM   4742  CG  TYR C 349      44.681 -21.569   8.114  1.00 21.56           C  
ATOM   4743  CD1 TYR C 349      45.053 -21.323   6.798  1.00 20.61           C  
ATOM   4744  CD2 TYR C 349      44.211 -20.502   8.866  1.00 21.25           C  
ATOM   4745  CE1 TYR C 349      44.949 -20.044   6.250  1.00 20.36           C  
ATOM   4746  CE2 TYR C 349      44.089 -19.231   8.324  1.00 20.81           C  
ATOM   4747  CZ  TYR C 349      44.464 -19.007   7.022  1.00 21.30           C  
ATOM   4748  OH  TYR C 349      44.347 -17.727   6.491  1.00 22.91           O  
ATOM   4749  N   ASP C 350      44.610 -25.967   7.997  1.00 25.32           N  
ATOM   4750  CA  ASP C 350      45.126 -27.333   8.109  1.00 26.35           C  
ATOM   4751  C   ASP C 350      45.973 -27.637   6.880  1.00 25.71           C  
ATOM   4752  O   ASP C 350      45.521 -28.280   5.922  1.00 28.44           O  
ATOM   4753  CB  ASP C 350      43.982 -28.338   8.200  1.00 30.48           C  
ATOM   4754  CG  ASP C 350      44.408 -29.670   8.772  1.00 32.72           C  
ATOM   4755  OD1 ASP C 350      45.594 -30.020   8.646  1.00 31.89           O  
ATOM   4756  OD2 ASP C 350      43.543 -30.377   9.347  1.00 36.35           O  
ATOM   4757  N   ALA C 351      47.210 -27.171   6.923  1.00 10.44           N  
ATOM   4758  CA  ALA C 351      48.170 -27.342   5.829  1.00 11.75           C  
ATOM   4759  C   ALA C 351      49.577 -27.338   6.379  1.00 11.16           C  
ATOM   4760  O   ALA C 351      49.782 -27.297   7.596  1.00 10.19           O  
ATOM   4761  CB  ALA C 351      48.008 -26.220   4.791  1.00 10.55           C  
ATOM   4762  N   LYS C 352      50.560 -27.342   5.486  1.00 11.96           N  
ATOM   4763  CA  LYS C 352      51.909 -27.173   5.942  1.00 12.01           C  
ATOM   4764  C   LYS C 352      52.080 -25.917   6.765  1.00 10.16           C  
ATOM   4765  O   LYS C 352      51.607 -24.812   6.423  1.00  9.46           O  
ATOM   4766  CB  LYS C 352      52.891 -27.232   4.788  1.00 14.02           C  
ATOM   4767  CG  LYS C 352      53.067 -28.663   4.245  1.00 15.67           C  
ATOM   4768  CD  LYS C 352      53.355 -28.621   2.775  1.00 16.02           C  
ATOM   4769  CE  LYS C 352      53.941 -29.932   2.281  1.00 21.34           C  
ATOM   4770  NZ  LYS C 352      54.679 -29.752   1.015  1.00 21.15           N  
ATOM   4771  N   THR C 353      52.752 -26.077   7.888  1.00 11.31           N  
ATOM   4772  CA  THR C 353      53.081 -24.911   8.718  1.00  9.63           C  
ATOM   4773  C   THR C 353      53.460 -23.709   7.858  1.00  8.48           C  
ATOM   4774  O   THR C 353      52.806 -22.707   7.934  1.00  8.03           O  
ATOM   4775  CB  THR C 353      54.180 -25.260   9.727  1.00 11.31           C  
ATOM   4776  OG1 THR C 353      53.811 -26.475  10.401  1.00 14.33           O  
ATOM   4777  CG2 THR C 353      54.372 -24.138  10.748  1.00  6.97           C  
ATOM   4778  N   HIS C 354      54.470 -23.815   6.998  1.00  9.93           N  
ATOM   4779  CA  HIS C 354      54.921 -22.626   6.294  1.00  9.46           C  
ATOM   4780  C   HIS C 354      53.829 -22.011   5.437  1.00  9.03           C  
ATOM   4781  O   HIS C 354      53.690 -20.766   5.372  1.00  6.25           O  
ATOM   4782  CB  HIS C 354      56.227 -22.832   5.519  1.00 11.13           C  
ATOM   4783  CG  HIS C 354      56.129 -23.776   4.358  1.00 12.73           C  
ATOM   4784  ND1 HIS C 354      55.709 -23.372   3.099  1.00 13.10           N  
ATOM   4785  CD2 HIS C 354      56.457 -25.085   4.249  1.00 10.40           C  
ATOM   4786  CE1 HIS C 354      55.762 -24.407   2.278  1.00 13.91           C  
ATOM   4787  NE2 HIS C 354      56.207 -25.456   2.952  1.00 12.84           N  
ATOM   4788  N   ILE C 355      53.020 -22.884   4.838  1.00 10.42           N  
ATOM   4789  CA  ILE C 355      51.875 -22.408   4.068  1.00 11.21           C  
ATOM   4790  C   ILE C 355      50.808 -21.695   4.900  1.00 10.13           C  
ATOM   4791  O   ILE C 355      50.237 -20.704   4.437  1.00 10.92           O  
ATOM   4792  CB  ILE C 355      51.267 -23.488   3.202  1.00 13.03           C  
ATOM   4793  CG1 ILE C 355      52.237 -23.785   2.064  1.00 14.20           C  
ATOM   4794  CG2 ILE C 355      49.898 -23.024   2.666  1.00 13.67           C  
ATOM   4795  CD1 ILE C 355      51.821 -24.933   1.218  1.00 17.69           C  
ATOM   4796  N   VAL C 356      50.553 -22.151   6.125  1.00  9.63           N  
ATOM   4797  CA  VAL C 356      49.571 -21.441   6.987  1.00  8.14           C  
ATOM   4798  C   VAL C 356      50.122 -20.058   7.446  1.00  7.53           C  
ATOM   4799  O   VAL C 356      49.437 -18.999   7.297  1.00  7.27           O  
ATOM   4800  CB  VAL C 356      49.144 -22.295   8.187  1.00  8.18           C  
ATOM   4801  CG1 VAL C 356      48.082 -21.570   9.034  1.00  7.60           C  
ATOM   4802  CG2 VAL C 356      48.614 -23.668   7.717  1.00  9.68           C  
ATOM   4803  N   LEU C 357      51.349 -20.056   7.961  1.00  6.67           N  
ATOM   4804  CA  LEU C 357      51.986 -18.797   8.333  1.00  7.41           C  
ATOM   4805  C   LEU C 357      52.089 -17.795   7.174  1.00  8.99           C  
ATOM   4806  O   LEU C 357      51.753 -16.635   7.350  1.00 10.64           O  
ATOM   4807  CB  LEU C 357      53.356 -19.041   8.971  1.00  7.84           C  
ATOM   4808  CG  LEU C 357      54.178 -17.860   9.495  1.00  8.64           C  
ATOM   4809  CD1 LEU C 357      53.357 -16.864  10.351  1.00  8.50           C  
ATOM   4810  CD2 LEU C 357      55.383 -18.373  10.241  1.00  7.92           C  
ATOM   4811  N   SER C 358      52.546 -18.229   5.997  1.00 10.92           N  
ATOM   4812  CA  SER C 358      52.529 -17.399   4.782  1.00 12.21           C  
ATOM   4813  C   SER C 358      51.178 -16.753   4.628  1.00 12.09           C  
ATOM   4814  O   SER C 358      51.076 -15.527   4.473  1.00 11.07           O  
ATOM   4815  CB  SER C 358      52.714 -18.234   3.512  1.00 13.56           C  
ATOM   4816  OG  SER C 358      53.970 -18.844   3.479  1.00 19.03           O  
ATOM   4817  N   HIS C 359      50.145 -17.604   4.639  1.00 11.40           N  
ATOM   4818  CA  HIS C 359      48.828 -17.131   4.290  1.00 12.09           C  
ATOM   4819  C   HIS C 359      48.287 -16.114   5.306  1.00 10.45           C  
ATOM   4820  O   HIS C 359      47.583 -15.173   4.949  1.00 11.40           O  
ATOM   4821  CB  HIS C 359      47.876 -18.300   4.062  1.00 13.55           C  
ATOM   4822  CG  HIS C 359      46.571 -17.897   3.444  1.00 19.51           C  
ATOM   4823  ND1 HIS C 359      45.485 -17.481   4.193  1.00 21.67           N  
ATOM   4824  CD2 HIS C 359      46.180 -17.831   2.147  1.00 23.86           C  
ATOM   4825  CE1 HIS C 359      44.482 -17.184   3.384  1.00 23.79           C  
ATOM   4826  NE2 HIS C 359      44.877 -17.388   2.138  1.00 25.24           N  
ATOM   4827  N   VAL C 360      48.645 -16.272   6.569  1.00  8.19           N  
ATOM   4828  CA  VAL C 360      48.130 -15.357   7.576  1.00  7.15           C  
ATOM   4829  C   VAL C 360      48.862 -14.021   7.528  1.00  8.14           C  
ATOM   4830  O   VAL C 360      48.244 -12.941   7.628  1.00  8.35           O  
ATOM   4831  CB  VAL C 360      48.213 -16.008   8.936  1.00  5.74           C  
ATOM   4832  CG1 VAL C 360      48.117 -14.992  10.072  1.00  5.70           C  
ATOM   4833  CG2 VAL C 360      47.138 -17.094   9.033  1.00  5.46           C  
ATOM   4834  N   LEU C 361      50.185 -14.100   7.361  1.00  7.41           N  
ATOM   4835  CA  LEU C 361      50.974 -12.906   7.317  1.00  8.47           C  
ATOM   4836  C   LEU C 361      50.539 -12.070   6.124  1.00 10.29           C  
ATOM   4837  O   LEU C 361      50.229 -10.875   6.269  1.00 12.61           O  
ATOM   4838  CB  LEU C 361      52.453 -13.236   7.251  1.00  8.38           C  
ATOM   4839  CG  LEU C 361      53.125 -13.662   8.564  1.00  9.11           C  
ATOM   4840  CD1 LEU C 361      54.609 -13.914   8.319  1.00 10.54           C  
ATOM   4841  CD2 LEU C 361      52.930 -12.638   9.717  1.00 10.82           C  
ATOM   4842  N   LYS C 362      50.446 -12.719   4.972  1.00  9.41           N  
ATOM   4843  CA  LYS C 362      50.127 -12.070   3.721  1.00 12.14           C  
ATOM   4844  C   LYS C 362      48.729 -11.513   3.811  1.00 13.65           C  
ATOM   4845  O   LYS C 362      48.416 -10.465   3.244  1.00 16.60           O  
ATOM   4846  CB  LYS C 362      50.226 -13.075   2.605  1.00 11.84           C  
ATOM   4847  CG  LYS C 362      49.319 -12.842   1.454  1.00 19.17           C  
ATOM   4848  CD  LYS C 362      48.493 -14.067   1.162  1.00 25.52           C  
ATOM   4849  CE  LYS C 362      49.188 -15.000   0.176  1.00 29.69           C  
ATOM   4850  NZ  LYS C 362      48.152 -15.860  -0.480  1.00 36.02           N  
ATOM   4851  N   GLY C 363      47.893 -12.239   4.532  1.00 12.38           N  
ATOM   4852  CA  GLY C 363      46.550 -11.820   4.807  1.00 13.64           C  
ATOM   4853  C   GLY C 363      46.524 -10.513   5.542  1.00 15.66           C  
ATOM   4854  O   GLY C 363      45.829  -9.590   5.112  1.00 19.42           O  
ATOM   4855  N   LEU C 364      47.277 -10.420   6.639  1.00 14.59           N  
ATOM   4856  CA  LEU C 364      47.213  -9.245   7.534  1.00 16.60           C  
ATOM   4857  C   LEU C 364      48.076  -8.060   7.084  1.00 20.10           C  
ATOM   4858  O   LEU C 364      47.955  -6.929   7.572  1.00 23.84           O  
ATOM   4859  CB  LEU C 364      47.573  -9.667   8.953  1.00 14.00           C  
ATOM   4860  CG  LEU C 364      46.622 -10.761   9.450  1.00 12.03           C  
ATOM   4861  CD1 LEU C 364      47.215 -11.614  10.551  1.00  8.77           C  
ATOM   4862  CD2 LEU C 364      45.298 -10.150   9.883  1.00 12.66           C  
ATOM   4863  N   THR C 365      48.902  -8.310   6.090  1.00 19.92           N  
ATOM   4864  CA  THR C 365      49.999  -7.446   5.757  1.00 21.25           C  
ATOM   4865  C   THR C 365      49.800  -6.875   4.350  1.00 24.56           C  
ATOM   4866  O   THR C 365      50.614  -6.081   3.878  1.00 26.24           O  
ATOM   4867  CB  THR C 365      51.239  -8.325   5.797  1.00 18.53           C  
ATOM   4868  OG1 THR C 365      52.319  -7.650   6.427  1.00 20.87           O  
ATOM   4869  CG2 THR C 365      51.604  -8.795   4.469  1.00 16.82           C  
ATOM   4870  N   ASP C 366      48.702  -7.294   3.705  1.00 24.75           N  
ATOM   4871  CA  ASP C 366      48.467  -7.123   2.278  1.00 27.05           C  
ATOM   4872  C   ASP C 366      49.709  -7.170   1.390  1.00 27.27           C  
ATOM   4873  O   ASP C 366      49.819  -6.414   0.426  1.00 31.41           O  
ATOM   4874  CB  ASP C 366      47.697  -5.835   2.027  1.00 32.71           C  
ATOM   4875  CG  ASP C 366      46.232  -5.976   2.296  1.00 33.57           C  
ATOM   4876  OD1 ASP C 366      45.815  -7.024   2.819  1.00 32.25           O  
ATOM   4877  OD2 ASP C 366      45.490  -5.030   1.977  1.00 41.20           O  
ATOM   4878  N   ARG C 367      50.651  -8.052   1.704  1.00 24.03           N  
ATOM   4879  CA  ARG C 367      51.816  -8.260   0.860  1.00 23.43           C  
ATOM   4880  C   ARG C 367      51.566  -9.493   0.058  1.00 22.79           C  
ATOM   4881  O   ARG C 367      50.999 -10.447   0.566  1.00 21.21           O  
ATOM   4882  CB  ARG C 367      53.080  -8.464   1.695  1.00 20.64           C  
ATOM   4883  CG  ARG C 367      53.506  -7.268   2.532  1.00 21.87           C  
ATOM   4884  CD  ARG C 367      53.670  -6.045   1.670  1.00 27.87           C  
ATOM   4885  NE  ARG C 367      54.056  -4.879   2.445  1.00 31.39           N  
ATOM   4886  CZ  ARG C 367      54.665  -3.814   1.929  1.00 35.83           C  
ATOM   4887  NH1 ARG C 367      54.964  -3.758   0.634  1.00 35.10           N  
ATOM   4888  NH2 ARG C 367      54.983  -2.801   2.717  1.00 40.36           N  
ATOM   4889  N   ARG C 368      51.984  -9.505  -1.198  1.00 25.55           N  
ATOM   4890  CA  ARG C 368      52.057 -10.776  -1.921  1.00 25.54           C  
ATOM   4891  C   ARG C 368      53.206 -11.634  -1.339  1.00 21.28           C  
ATOM   4892  O   ARG C 368      54.030 -11.134  -0.578  1.00 21.48           O  
ATOM   4893  CB  ARG C 368      52.126 -10.514  -3.425  1.00 28.63           C  
ATOM   4894  CG  ARG C 368      52.923 -11.511  -4.262  1.00 30.98           C  
ATOM   4895  CD  ARG C 368      53.021 -11.023  -5.733  1.00 35.00           C  
ATOM   4896  NE  ARG C 368      54.326 -11.325  -6.338  1.00 41.72           N  
ATOM   4897  CZ  ARG C 368      55.356 -10.477  -6.374  1.00 45.11           C  
ATOM   4898  NH1 ARG C 368      55.244  -9.257  -5.846  1.00 47.76           N  
ATOM   4899  NH2 ARG C 368      56.504 -10.846  -6.941  1.00 46.86           N  
ATOM   4900  N   VAL C 369      53.235 -12.924  -1.634  1.00 19.02           N  
ATOM   4901  CA  VAL C 369      54.312 -13.771  -1.143  1.00 15.40           C  
ATOM   4902  C   VAL C 369      55.225 -14.217  -2.284  1.00 16.34           C  
ATOM   4903  O   VAL C 369      54.834 -15.040  -3.104  1.00 17.49           O  
ATOM   4904  CB  VAL C 369      53.753 -15.014  -0.415  1.00 13.96           C  
ATOM   4905  CG1 VAL C 369      54.879 -16.066  -0.130  1.00 12.12           C  
ATOM   4906  CG2 VAL C 369      53.036 -14.602   0.883  1.00 12.40           C  
ATOM   4907  N   ILE C 370      56.449 -13.703  -2.324  1.00 15.69           N  
ATOM   4908  CA  ILE C 370      57.416 -14.092  -3.352  1.00 16.06           C  
ATOM   4909  C   ILE C 370      57.862 -15.576  -3.259  1.00 15.00           C  
ATOM   4910  O   ILE C 370      58.190 -16.092  -2.179  1.00 13.42           O  
ATOM   4911  CB  ILE C 370      58.595 -13.109  -3.354  1.00 16.98           C  
ATOM   4912  CG1 ILE C 370      58.071 -11.714  -3.707  1.00 18.77           C  
ATOM   4913  CG2 ILE C 370      59.646 -13.533  -4.318  1.00 16.64           C  
ATOM   4914  CD1 ILE C 370      58.771 -10.591  -2.981  1.00 21.32           C  
ATOM   4915  N   VAL C 371      57.831 -16.261  -4.398  1.00 16.09           N  
ATOM   4916  CA  VAL C 371      58.237 -17.665  -4.485  1.00 15.79           C  
ATOM   4917  C   VAL C 371      59.094 -17.818  -5.746  1.00 18.24           C  
ATOM   4918  O   VAL C 371      59.042 -16.985  -6.624  1.00 19.14           O  
ATOM   4919  CB  VAL C 371      57.020 -18.670  -4.558  1.00 15.54           C  
ATOM   4920  CG1 VAL C 371      56.205 -18.681  -3.275  1.00 14.18           C  
ATOM   4921  CG2 VAL C 371      56.124 -18.396  -5.760  1.00 17.17           C  
ATOM   4922  N   PRO C 372      59.875 -18.892  -5.804  1.00 19.35           N  
ATOM   4923  CA  PRO C 372      60.584 -19.266  -7.031  1.00 22.19           C  
ATOM   4924  C   PRO C 372      59.677 -19.202  -8.254  1.00 24.88           C  
ATOM   4925  O   PRO C 372      58.514 -19.598  -8.182  1.00 24.26           O  
ATOM   4926  CB  PRO C 372      61.001 -20.713  -6.761  1.00 22.88           C  
ATOM   4927  CG  PRO C 372      59.978 -21.222  -5.809  1.00 21.33           C  
ATOM   4928  CD  PRO C 372      59.611 -20.056  -4.939  1.00 18.38           C  
ATOM   4929  N   GLY C 373      60.211 -18.703  -9.364  1.00 27.37           N  
ATOM   4930  CA  GLY C 373      59.479 -18.676 -10.625  1.00 31.01           C  
ATOM   4931  C   GLY C 373      60.035 -19.629 -11.669  1.00 34.59           C  
ATOM   4932  O   GLY C 373      60.212 -20.803 -11.391  1.00 34.81           O  
ATOM   4933  N   GLU C 374      60.336 -19.127 -12.861  1.00 38.11           N  
ATOM   4934  CA  GLU C 374      60.630 -20.005 -13.997  1.00 42.76           C  
ATOM   4935  C   GLU C 374      62.100 -20.449 -14.174  1.00 44.05           C  
ATOM   4936  O   GLU C 374      62.395 -21.279 -15.043  1.00 47.58           O  
ATOM   4937  CB  GLU C 374      60.094 -19.383 -15.306  1.00 46.44           C  
ATOM   4938  CG  GLU C 374      60.907 -18.152 -15.790  1.00 47.89           C  
ATOM   4939  CD  GLU C 374      60.414 -17.513 -17.100  1.00 51.92           C  
ATOM   4940  OE1 GLU C 374      61.266 -17.243 -17.998  1.00 53.39           O  
ATOM   4941  OE2 GLU C 374      59.186 -17.256 -17.211  1.00 53.71           O  
ATOM   4942  N   TYR C 375      63.024 -19.892 -13.392  1.00 41.98           N  
ATOM   4943  CA  TYR C 375      64.436 -20.262 -13.529  1.00 43.30           C  
ATOM   4944  C   TYR C 375      64.654 -21.682 -13.037  1.00 43.90           C  
ATOM   4945  O   TYR C 375      64.094 -22.077 -12.030  1.00 41.68           O  
ATOM   4946  CB  TYR C 375      65.374 -19.280 -12.779  1.00 41.41           C  
ATOM   4947  CG  TYR C 375      66.793 -19.797 -12.589  1.00 41.73           C  
ATOM   4948  CD1 TYR C 375      67.696 -19.809 -13.647  1.00 44.94           C  
ATOM   4949  CD2 TYR C 375      67.221 -20.300 -11.359  1.00 40.23           C  
ATOM   4950  CE1 TYR C 375      68.990 -20.302 -13.488  1.00 46.27           C  
ATOM   4951  CE2 TYR C 375      68.527 -20.793 -11.188  1.00 40.72           C  
ATOM   4952  CZ  TYR C 375      69.393 -20.792 -12.254  1.00 44.35           C  
ATOM   4953  OH  TYR C 375      70.676 -21.259 -12.106  1.00 46.33           O  
ATOM   4954  N   LYS C 376      65.472 -22.440 -13.759  1.00 47.80           N  
ATOM   4955  CA  LYS C 376      65.811 -23.800 -13.356  1.00 50.06           C  
ATOM   4956  C   LYS C 376      67.255 -24.137 -13.710  1.00 52.37           C  
ATOM   4957  O   LYS C 376      67.633 -24.138 -14.881  1.00 55.72           O  
ATOM   4958  CB  LYS C 376      64.860 -24.805 -14.011  1.00 52.87           C  
ATOM   4959  CG  LYS C 376      63.463 -24.817 -13.414  1.00 51.82           C  
ATOM   4960  CD  LYS C 376      62.664 -26.015 -13.904  1.00 55.10           C  
ATOM   4961  CE  LYS C 376      61.224 -25.631 -14.206  0.00 97.50           C  
ATOM   4962  NZ  LYS C 376      61.142 -24.461 -15.123  0.00 96.48           N  
ATOM   4963  N   SER C 377      68.058 -24.423 -12.690  1.00 51.65           N  
ATOM   4964  CA  SER C 377      69.500 -24.652 -12.881  1.00 54.11           C  
ATOM   4965  C   SER C 377      69.800 -25.843 -13.804  1.00 58.74           C  
ATOM   4966  O   SER C 377      68.892 -26.383 -14.449  1.00 60.36           O  
ATOM   4967  CB  SER C 377      70.204 -24.815 -11.532  1.00 52.87           C  
ATOM   4968  OG  SER C 377      70.119 -26.146 -11.056  1.00 56.12           O  
ATOM   4969  N   LYS C 378      71.066 -26.243 -13.862  1.00 61.32           N  
ATOM   4970  CA  LYS C 378      71.479 -27.351 -14.715  1.00 66.24           C  
ATOM   4971  C   LYS C 378      70.861 -28.665 -14.247  1.00 68.00           C  
ATOM   4972  O   LYS C 378      70.557 -29.543 -15.056  1.00 71.90           O  
ATOM   4973  CB  LYS C 378      73.004 -27.468 -14.742  1.00 68.65           C  
ATOM   4974  CG  LYS C 378      73.515 -28.836 -15.165  1.00 73.96           C  
ATOM   4975  CD  LYS C 378      74.837 -28.726 -15.907  0.00121.07           C  
ATOM   4976  CE  LYS C 378      74.746 -29.340 -17.293  0.00126.24           C  
ATOM   4977  NZ  LYS C 378      74.813 -28.308 -18.364  0.00131.06           N  
ATOM   4978  N   TYR C 379      70.680 -28.791 -12.937  1.00 65.31           N  
ATOM   4979  CA  TYR C 379      70.083 -29.981 -12.354  1.00 66.88           C  
ATOM   4980  C   TYR C 379      68.795 -29.592 -11.650  1.00 62.97           C  
ATOM   4981  O   TYR C 379      68.521 -30.029 -10.529  1.00 62.08           O  
ATOM   4982  CB  TYR C 379      71.095 -30.709 -11.459  1.00 69.04           C  
ATOM   4983  CG  TYR C 379      72.439 -30.896 -12.170  1.00 72.95           C  
ATOM   4984  CD1 TYR C 379      72.626 -31.914 -13.111  1.00 77.99           C  
ATOM   4985  CD2 TYR C 379      73.496 -30.020 -11.932  1.00 71.06           C  
ATOM   4986  CE1 TYR C 379      73.841 -32.058 -13.782  1.00 82.66           C  
ATOM   4987  CE2 TYR C 379      74.705 -30.155 -12.587  1.00 75.35           C  
ATOM   4988  CZ  TYR C 379      74.875 -31.173 -13.511  1.00 80.85           C  
ATOM   4989  OH  TYR C 379      76.080 -31.289 -14.153  1.00 83.61           O  
ATOM   4990  N   ASP C 380      68.029 -28.739 -12.341  1.00 61.15           N  
ATOM   4991  CA  ASP C 380      66.632 -28.388 -12.019  1.00 58.61           C  
ATOM   4992  C   ASP C 380      66.351 -27.702 -10.667  1.00 53.90           C  
ATOM   4993  O   ASP C 380      65.203 -27.676 -10.208  1.00 51.50           O  
ATOM   4994  CB  ASP C 380      65.703 -29.606 -12.192  1.00 61.92           C  
ATOM   4995  CG  ASP C 380      65.272 -29.829 -13.637  1.00 65.87           C  
ATOM   4996  OD1 ASP C 380      64.161 -30.366 -13.834  1.00 68.73           O  
ATOM   4997  OD2 ASP C 380      66.026 -29.473 -14.567  1.00 66.75           O  
ATOM   4998  N   GLN C 381      67.375 -27.129 -10.038  1.00 52.61           N  
ATOM   4999  CA  GLN C 381      67.135 -26.381  -8.798  1.00 48.55           C  
ATOM   5000  C   GLN C 381      66.778 -24.930  -9.111  1.00 45.40           C  
ATOM   5001  O   GLN C 381      66.966 -24.456 -10.239  1.00 46.67           O  
ATOM   5002  CB  GLN C 381      68.342 -26.442  -7.852  1.00 49.04           C  
ATOM   5003  CG  GLN C 381      68.911 -27.841  -7.570  1.00 52.92           C  
ATOM   5004  CD  GLN C 381      67.868 -28.874  -7.149  1.00 53.85           C  
ATOM   5005  OE1 GLN C 381      67.958 -30.043  -7.545  1.00 59.21           O  
ATOM   5006  NE2 GLN C 381      66.888 -28.458  -6.349  1.00 48.35           N  
ATOM   5007  N   CYS C 382      66.262 -24.215  -8.125  1.00 41.52           N  
ATOM   5008  CA  CYS C 382      66.028 -22.789  -8.336  1.00 39.36           C  
ATOM   5009  C   CYS C 382      67.099 -21.906  -7.690  1.00 37.40           C  
ATOM   5010  O   CYS C 382      66.965 -20.669  -7.663  1.00 35.56           O  
ATOM   5011  CB  CYS C 382      64.647 -22.413  -7.846  1.00 36.71           C  
ATOM   5012  SG  CYS C 382      64.410 -23.152  -6.288  1.00 38.44           S  
ATOM   5013  N   ALA C 383      68.163 -22.534  -7.184  1.00 28.02           N  
ATOM   5014  CA  ALA C 383      69.313 -21.776  -6.693  1.00 25.27           C  
ATOM   5015  C   ALA C 383      70.645 -22.415  -7.036  1.00 26.58           C  
ATOM   5016  O   ALA C 383      70.745 -23.635  -7.205  1.00 29.19           O  
ATOM   5017  CB  ALA C 383      69.207 -21.540  -5.189  1.00 24.35           C  
ATOM   5018  N   VAL C 384      71.669 -21.574  -7.118  1.00 24.36           N  
ATOM   5019  CA  VAL C 384      73.035 -22.049  -7.309  1.00 26.33           C  
ATOM   5020  C   VAL C 384      73.885 -21.666  -6.108  1.00 25.09           C  
ATOM   5021  O   VAL C 384      73.679 -20.624  -5.506  1.00 23.63           O  
ATOM   5022  CB  VAL C 384      73.645 -21.488  -8.610  1.00 26.91           C  
ATOM   5023  CG1 VAL C 384      72.888 -22.039  -9.784  1.00 28.32           C  
ATOM   5024  CG2 VAL C 384      73.591 -19.956  -8.638  1.00 24.40           C  
ATOM   5025  N   SER C 385      74.824 -22.508  -5.732  1.00 27.10           N  
ATOM   5026  CA  SER C 385      75.707 -22.147  -4.638  1.00 26.75           C  
ATOM   5027  C   SER C 385      76.793 -21.193  -5.132  1.00 26.20           C  
ATOM   5028  O   SER C 385      77.273 -21.312  -6.255  1.00 28.43           O  
ATOM   5029  CB  SER C 385      76.377 -23.380  -4.088  1.00 30.18           C  
ATOM   5030  OG  SER C 385      77.296 -23.805  -5.045  1.00 31.75           O  
ATOM   5031  N   CYS C 386      77.200 -20.271  -4.277  1.00 24.25           N  
ATOM   5032  CA  CYS C 386      78.214 -19.304  -4.626  1.00 23.76           C  
ATOM   5033  C   CYS C 386      78.658 -18.712  -3.319  1.00 23.95           C  
ATOM   5034  O   CYS C 386      78.256 -19.200  -2.240  1.00 24.21           O  
ATOM   5035  CB  CYS C 386      77.610 -18.215  -5.496  1.00 21.16           C  
ATOM   5036  SG  CYS C 386      76.022 -17.606  -4.862  1.00 19.16           S  
ATOM   5037  N   SER C 387      79.465 -17.657  -3.412  1.00 23.85           N  
ATOM   5038  CA  SER C 387      79.848 -16.853  -2.237  1.00 24.72           C  
ATOM   5039  C   SER C 387      79.642 -15.339  -2.412  1.00 23.22           C  
ATOM   5040  O   SER C 387      79.776 -14.789  -3.520  1.00 22.13           O  
ATOM   5041  CB  SER C 387      81.287 -17.148  -1.812  1.00 27.63           C  
ATOM   5042  OG  SER C 387      82.119 -17.288  -2.940  1.00 30.24           O  
ATOM   5043  N   PHE C 388      79.288 -14.674  -1.316  1.00 23.25           N  
ATOM   5044  CA  PHE C 388      79.264 -13.232  -1.297  1.00 23.14           C  
ATOM   5045  C   PHE C 388      80.219 -12.860  -0.209  1.00 26.62           C  
ATOM   5046  O   PHE C 388      80.059 -13.283   0.932  1.00 28.52           O  
ATOM   5047  CB  PHE C 388      77.871 -12.697  -1.015  1.00 21.55           C  
ATOM   5048  CG  PHE C 388      77.832 -11.232  -0.720  1.00 22.56           C  
ATOM   5049  CD1 PHE C 388      77.502 -10.784   0.550  1.00 25.18           C  
ATOM   5050  CD2 PHE C 388      78.127 -10.297  -1.704  1.00 22.85           C  
ATOM   5051  CE1 PHE C 388      77.460  -9.412   0.848  1.00 26.97           C  
ATOM   5052  CE2 PHE C 388      78.073  -8.924  -1.423  1.00 24.91           C  
ATOM   5053  CZ  PHE C 388      77.750  -8.482  -0.147  1.00 26.01           C  
ATOM   5054  N   LYS C 389      81.230 -12.068  -0.552  1.00 28.82           N  
ATOM   5055  CA  LYS C 389      82.395 -11.899   0.310  1.00 33.04           C  
ATOM   5056  C   LYS C 389      83.131 -13.221   0.511  1.00 34.83           C  
ATOM   5057  O   LYS C 389      83.338 -13.976  -0.439  1.00 33.45           O  
ATOM   5058  CB  LYS C 389      81.979 -11.318   1.663  1.00 34.84           C  
ATOM   5059  CG  LYS C 389      82.237  -9.826   1.803  1.00 36.66           C  
ATOM   5060  CD  LYS C 389      81.518  -9.038   0.720  1.00 33.97           C  
ATOM   5061  CE  LYS C 389      80.988  -7.719   1.256  1.00 36.63           C  
ATOM   5062  NZ  LYS C 389      81.758  -6.557   0.731  1.00 86.06           N  
ATOM   5063  N   ALA C 390      83.524 -13.494   1.751  1.00 38.38           N  
ATOM   5064  CA  ALA C 390      84.101 -14.782   2.101  1.00 41.48           C  
ATOM   5065  C   ALA C 390      83.019 -15.860   2.297  1.00 39.88           C  
ATOM   5066  O   ALA C 390      83.339 -17.017   2.570  1.00 42.39           O  
ATOM   5067  CB  ALA C 390      84.951 -14.656   3.363  1.00 46.66           C  
ATOM   5068  N   ASN C 391      81.752 -15.489   2.126  1.00 36.14           N  
ATOM   5069  CA  ASN C 391      80.651 -16.283   2.665  1.00 35.21           C  
ATOM   5070  C   ASN C 391      79.961 -17.241   1.702  1.00 32.43           C  
ATOM   5071  O   ASN C 391      79.352 -16.820   0.717  1.00 28.71           O  
ATOM   5072  CB  ASN C 391      79.609 -15.366   3.326  1.00 34.47           C  
ATOM   5073  CG  ASN C 391      80.077 -14.808   4.673  1.00 39.08           C  
ATOM   5074  OD1 ASN C 391      80.322 -15.558   5.635  1.00 40.50           O  
ATOM   5075  ND2 ASN C 391      80.185 -13.472   4.747  1.00 39.87           N  
ATOM   5076  N   GLU C 392      80.043 -18.529   2.027  1.00 34.66           N  
ATOM   5077  CA  GLU C 392      79.288 -19.563   1.326  1.00 33.89           C  
ATOM   5078  C   GLU C 392      77.773 -19.368   1.475  1.00 30.84           C  
ATOM   5079  O   GLU C 392      77.283 -18.992   2.537  1.00 31.38           O  
ATOM   5080  CB  GLU C 392      79.682 -20.952   1.831  1.00 38.08           C  
ATOM   5081  CG  GLU C 392      81.172 -21.312   1.649  1.00 44.91           C  
ATOM   5082  CD  GLU C 392      81.573 -21.542   0.174  1.00 47.49           C  
ATOM   5083  OE1 GLU C 392      82.742 -21.924  -0.081  1.00 50.01           O  
ATOM   5084  OE2 GLU C 392      80.718 -21.344  -0.731  1.00 45.63           O  
ATOM   5085  N   GLY C 393      77.048 -19.624   0.398  1.00 28.14           N  
ATOM   5086  CA  GLY C 393      75.602 -19.548   0.417  1.00 26.01           C  
ATOM   5087  C   GLY C 393      75.041 -19.773  -0.968  1.00 23.84           C  
ATOM   5088  O   GLY C 393      75.795 -19.939  -1.932  1.00 25.04           O  
ATOM   5089  N   TYR C 394      73.719 -19.764  -1.068  1.00 21.65           N  
ATOM   5090  CA  TYR C 394      73.029 -20.061  -2.311  1.00 19.40           C  
ATOM   5091  C   TYR C 394      72.356 -18.816  -2.838  1.00 16.27           C  
ATOM   5092  O   TYR C 394      71.766 -18.076  -2.075  1.00 14.81           O  
ATOM   5093  CB  TYR C 394      72.000 -21.184  -2.073  1.00 21.18           C  
ATOM   5094  CG  TYR C 394      72.646 -22.525  -1.827  1.00 25.04           C  
ATOM   5095  CD1 TYR C 394      72.792 -23.454  -2.863  1.00 27.13           C  
ATOM   5096  CD2 TYR C 394      73.153 -22.857  -0.569  1.00 27.46           C  
ATOM   5097  CE1 TYR C 394      73.399 -24.694  -2.644  1.00 30.33           C  
ATOM   5098  CE2 TYR C 394      73.769 -24.092  -0.338  1.00 30.85           C  
ATOM   5099  CZ  TYR C 394      73.891 -25.004  -1.379  1.00 33.31           C  
ATOM   5100  OH  TYR C 394      74.511 -26.232  -1.152  1.00 39.26           O  
ATOM   5101  N   LEU C 395      72.465 -18.593  -4.146  1.00 15.83           N  
ATOM   5102  CA  LEU C 395      71.839 -17.460  -4.832  1.00 14.35           C  
ATOM   5103  C   LEU C 395      70.607 -17.909  -5.605  1.00 14.80           C  
ATOM   5104  O   LEU C 395      70.695 -18.816  -6.438  1.00 16.78           O  
ATOM   5105  CB  LEU C 395      72.827 -16.860  -5.821  1.00 14.51           C  
ATOM   5106  CG  LEU C 395      72.314 -15.925  -6.921  1.00 13.95           C  
ATOM   5107  CD1 LEU C 395      71.733 -14.649  -6.380  1.00 14.36           C  
ATOM   5108  CD2 LEU C 395      73.425 -15.609  -7.866  1.00 14.47           C  
ATOM   5109  N   TYR C 396      69.469 -17.266  -5.347  1.00 13.90           N  
ATOM   5110  CA  TYR C 396      68.225 -17.559  -6.075  1.00 14.15           C  
ATOM   5111  C   TYR C 396      67.986 -16.435  -7.091  1.00 14.53           C  
ATOM   5112  O   TYR C 396      67.801 -15.248  -6.702  1.00 14.63           O  
ATOM   5113  CB  TYR C 396      67.024 -17.683  -5.134  1.00 13.29           C  
ATOM   5114  CG  TYR C 396      67.109 -18.779  -4.074  1.00 13.62           C  
ATOM   5115  CD1 TYR C 396      68.133 -18.803  -3.123  1.00 14.08           C  
ATOM   5116  CD2 TYR C 396      66.147 -19.766  -4.001  1.00 14.60           C  
ATOM   5117  CE1 TYR C 396      68.217 -19.812  -2.161  1.00 14.92           C  
ATOM   5118  CE2 TYR C 396      66.210 -20.764  -3.032  1.00 17.81           C  
ATOM   5119  CZ  TYR C 396      67.249 -20.785  -2.115  1.00 18.02           C  
ATOM   5120  OH  TYR C 396      67.288 -21.778  -1.144  1.00 19.85           O  
ATOM   5121  N   PRO C 397      68.038 -16.769  -8.400  1.00 15.61           N  
ATOM   5122  CA  PRO C 397      67.557 -15.791  -9.364  1.00 16.04           C  
ATOM   5123  C   PRO C 397      66.038 -15.842  -9.356  1.00 16.75           C  
ATOM   5124  O   PRO C 397      65.466 -16.859  -9.756  1.00 19.33           O  
ATOM   5125  CB  PRO C 397      68.127 -16.307 -10.702  1.00 17.93           C  
ATOM   5126  CG  PRO C 397      69.063 -17.442 -10.340  1.00 17.77           C  
ATOM   5127  CD  PRO C 397      68.530 -17.980  -9.071  1.00 17.01           C  
ATOM   5128  N   LEU C 398      65.371 -14.819  -8.840  1.00 16.01           N  
ATOM   5129  CA  LEU C 398      63.895 -14.905  -8.802  1.00 17.57           C  
ATOM   5130  C   LEU C 398      63.362 -14.231 -10.056  1.00 19.62           C  
ATOM   5131  O   LEU C 398      64.169 -13.777 -10.908  1.00 19.04           O  
ATOM   5132  CB  LEU C 398      63.318 -14.328  -7.519  1.00 16.22           C  
ATOM   5133  CG  LEU C 398      63.728 -15.143  -6.284  1.00 17.47           C  
ATOM   5134  CD1 LEU C 398      63.576 -14.360  -4.971  1.00 16.19           C  
ATOM   5135  CD2 LEU C 398      62.982 -16.494  -6.217  1.00 17.42           C  
ATOM   5136  N   ASP C 399      62.038 -14.194 -10.197  1.00 21.07           N  
ATOM   5137  CA  ASP C 399      61.465 -13.627 -11.391  1.00 24.05           C  
ATOM   5138  C   ASP C 399      61.673 -12.115 -11.471  1.00 24.44           C  
ATOM   5139  O   ASP C 399      61.615 -11.560 -12.560  1.00 26.87           O  
ATOM   5140  CB  ASP C 399      59.991 -14.017 -11.583  1.00 26.89           C  
ATOM   5141  CG  ASP C 399      59.815 -15.427 -12.197  1.00 28.16           C  
ATOM   5142  OD1 ASP C 399      60.814 -16.019 -12.626  1.00 25.47           O  
ATOM   5143  OD2 ASP C 399      58.668 -15.943 -12.251  1.00 32.59           O  
ATOM   5144  N   ASN C 400      61.959 -11.454 -10.350  1.00 23.01           N  
ATOM   5145  CA  ASN C 400      62.102  -9.991 -10.370  1.00 23.94           C  
ATOM   5146  C   ASN C 400      63.182  -9.436  -9.440  1.00 22.14           C  
ATOM   5147  O   ASN C 400      63.176  -8.237  -9.112  1.00 24.04           O  
ATOM   5148  CB  ASN C 400      60.763  -9.309 -10.037  1.00 26.63           C  
ATOM   5149  CG  ASN C 400      59.598  -9.846 -10.871  1.00 29.43           C  
ATOM   5150  OD1 ASN C 400      59.459  -9.538 -12.064  1.00 30.55           O  
ATOM   5151  ND2 ASN C 400      58.767 -10.668 -10.241  1.00 29.91           N  
ATOM   5152  N   ALA C 401      64.094 -10.299  -9.018  1.00 19.05           N  
ATOM   5153  CA  ALA C 401      65.083  -9.940  -8.034  1.00 17.85           C  
ATOM   5154  C   ALA C 401      66.131 -11.059  -7.863  1.00 16.33           C  
ATOM   5155  O   ALA C 401      65.858 -12.202  -8.213  1.00 16.05           O  
ATOM   5156  CB  ALA C 401      64.414  -9.644  -6.725  1.00 18.15           C  
ATOM   5157  N   PHE C 402      67.329 -10.696  -7.387  1.00 15.76           N  
ATOM   5158  CA  PHE C 402      68.305 -11.653  -6.867  1.00 15.68           C  
ATOM   5159  C   PHE C 402      68.106 -11.822  -5.377  1.00 15.78           C  
ATOM   5160  O   PHE C 402      68.073 -10.847  -4.625  1.00 16.66           O  
ATOM   5161  CB  PHE C 402      69.755 -11.185  -7.087  1.00 16.19           C  
ATOM   5162  CG  PHE C 402      70.141 -11.103  -8.522  1.00 17.47           C  
ATOM   5163  CD1 PHE C 402      70.368 -12.258  -9.260  1.00 18.50           C  
ATOM   5164  CD2 PHE C 402      70.216  -9.869  -9.159  1.00 19.68           C  
ATOM   5165  CE1 PHE C 402      70.702 -12.182 -10.622  1.00 21.43           C  
ATOM   5166  CE2 PHE C 402      70.537  -9.774 -10.511  1.00 20.92           C  
ATOM   5167  CZ  PHE C 402      70.786 -10.938 -11.241  1.00 22.52           C  
ATOM   5168  N   PHE C 403      68.039 -13.062  -4.927  1.00 15.15           N  
ATOM   5169  CA  PHE C 403      68.006 -13.257  -3.511  1.00 15.78           C  
ATOM   5170  C   PHE C 403      69.156 -14.147  -3.064  1.00 15.80           C  
ATOM   5171  O   PHE C 403      69.321 -15.264  -3.558  1.00 15.30           O  
ATOM   5172  CB  PHE C 403      66.662 -13.847  -3.125  1.00 17.20           C  
ATOM   5173  CG  PHE C 403      66.404 -13.829  -1.676  1.00 19.07           C  
ATOM   5174  CD1 PHE C 403      66.072 -12.641  -1.037  1.00 23.32           C  
ATOM   5175  CD2 PHE C 403      66.472 -14.998  -0.941  1.00 21.32           C  
ATOM   5176  CE1 PHE C 403      65.803 -12.600   0.339  1.00 24.62           C  
ATOM   5177  CE2 PHE C 403      66.220 -14.988   0.416  1.00 24.07           C  
ATOM   5178  CZ  PHE C 403      65.878 -13.774   1.059  1.00 26.36           C  
ATOM   5179  N   PHE C 404      69.953 -13.661  -2.117  1.00 16.68           N  
ATOM   5180  CA  PHE C 404      71.052 -14.482  -1.594  1.00 17.45           C  
ATOM   5181  C   PHE C 404      70.856 -14.857  -0.164  1.00 19.32           C  
ATOM   5182  O   PHE C 404      70.575 -14.005   0.639  1.00 21.21           O  
ATOM   5183  CB  PHE C 404      72.400 -13.773  -1.750  1.00 17.27           C  
ATOM   5184  CG  PHE C 404      73.552 -14.527  -1.163  1.00 17.48           C  
ATOM   5185  CD1 PHE C 404      73.942 -14.312   0.152  1.00 17.97           C  
ATOM   5186  CD2 PHE C 404      74.263 -15.438  -1.929  1.00 16.94           C  
ATOM   5187  CE1 PHE C 404      75.005 -14.999   0.690  1.00 19.98           C  
ATOM   5188  CE2 PHE C 404      75.352 -16.110  -1.394  1.00 17.68           C  
ATOM   5189  CZ  PHE C 404      75.714 -15.898  -0.080  1.00 19.04           C  
ATOM   5190  N   LEU C 405      71.032 -16.137   0.128  1.00 21.67           N  
ATOM   5191  CA  LEU C 405      70.976 -16.725   1.486  1.00 26.03           C  
ATOM   5192  C   LEU C 405      72.288 -17.442   1.803  1.00 28.34           C  
ATOM   5193  O   LEU C 405      72.807 -18.155   0.939  1.00 27.39           O  
ATOM   5194  CB  LEU C 405      69.883 -17.781   1.545  1.00 26.76           C  
ATOM   5195  CG  LEU C 405      68.462 -17.294   1.576  1.00 27.21           C  
ATOM   5196  CD1 LEU C 405      67.588 -18.395   1.048  1.00 29.17           C  
ATOM   5197  CD2 LEU C 405      68.117 -16.943   2.993  1.00 30.89           C  
ATOM   5198  N   THR C 406      72.802 -17.331   3.032  1.00 32.28           N  
ATOM   5199  CA  THR C 406      72.108 -16.764   4.194  1.00 35.34           C  
ATOM   5200  C   THR C 406      73.043 -15.928   5.051  1.00 38.02           C  
ATOM   5201  O   THR C 406      72.588 -15.185   5.923  1.00 40.57           O  
ATOM   5202  CB  THR C 406      71.605 -17.897   5.097  1.00 38.50           C  
ATOM   5203  OG1 THR C 406      70.492 -18.514   4.467  1.00 38.94           O  
ATOM   5204  CG2 THR C 406      71.167 -17.384   6.449  1.00 42.32           C  
ATOM   5205  N   LYS C 407      74.345 -16.069   4.829  1.00 38.27           N  
ATOM   5206  CA  LYS C 407      75.297 -15.583   5.819  1.00 42.11           C  
ATOM   5207  C   LYS C 407      75.155 -14.071   6.072  1.00 41.87           C  
ATOM   5208  O   LYS C 407      75.147 -13.656   7.244  1.00 46.93           O  
ATOM   5209  CB  LYS C 407      76.737 -16.049   5.537  1.00 43.37           C  
ATOM   5210  CG  LYS C 407      77.461 -16.618   6.785  1.00 49.44           C  
ATOM   5211  CD  LYS C 407      76.904 -18.005   7.227  1.00 51.47           C  
ATOM   5212  CE  LYS C 407      77.393 -18.416   8.628  1.00 56.21           C  
ATOM   5213  NZ  LYS C 407      78.868 -18.270   8.774  1.00 57.54           N  
ATOM   5214  N   PRO C 408      75.126 -13.240   5.006  1.00 37.32           N  
ATOM   5215  CA  PRO C 408      74.147 -12.156   4.978  1.00 35.96           C  
ATOM   5216  C   PRO C 408      72.999 -12.549   4.052  1.00 31.78           C  
ATOM   5217  O   PRO C 408      73.204 -13.322   3.106  1.00 29.19           O  
ATOM   5218  CB  PRO C 408      74.926 -10.989   4.374  1.00 34.89           C  
ATOM   5219  CG  PRO C 408      76.099 -11.625   3.681  1.00 34.35           C  
ATOM   5220  CD  PRO C 408      76.078 -13.112   3.895  1.00 34.67           C  
ATOM   5221  N   THR C 409      71.802 -12.044   4.328  1.00 31.39           N  
ATOM   5222  CA  THR C 409      70.692 -12.169   3.391  1.00 27.70           C  
ATOM   5223  C   THR C 409      70.609 -10.903   2.526  1.00 25.63           C  
ATOM   5224  O   THR C 409      70.640  -9.791   3.034  1.00 27.73           O  
ATOM   5225  CB  THR C 409      69.378 -12.486   4.147  1.00 29.89           C  
ATOM   5226  OG1 THR C 409      69.481 -13.802   4.707  1.00 32.59           O  
ATOM   5227  CG2 THR C 409      68.162 -12.460   3.235  1.00 26.57           C  
ATOM   5228  N   LEU C 410      70.537 -11.080   1.219  1.00 21.85           N  
ATOM   5229  CA  LEU C 410      70.377  -9.951   0.309  1.00 21.36           C  
ATOM   5230  C   LEU C 410      69.206 -10.168  -0.638  1.00 20.12           C  
ATOM   5231  O   LEU C 410      69.017 -11.285  -1.155  1.00 19.89           O  
ATOM   5232  CB  LEU C 410      71.662  -9.703  -0.504  1.00 19.61           C  
ATOM   5233  CG  LEU C 410      72.953  -9.548   0.317  1.00 21.57           C  
ATOM   5234  CD1 LEU C 410      74.162  -9.594  -0.547  1.00 22.07           C  
ATOM   5235  CD2 LEU C 410      72.988  -8.293   1.176  1.00 22.90           C  
ATOM   5236  N   TYR C 411      68.412  -9.117  -0.838  1.00 21.07           N  
ATOM   5237  CA  TYR C 411      67.374  -9.088  -1.867  1.00 20.27           C  
ATOM   5238  C   TYR C 411      67.664  -7.885  -2.762  1.00 20.58           C  
ATOM   5239  O   TYR C 411      67.652  -6.728  -2.304  1.00 22.21           O  
ATOM   5240  CB  TYR C 411      65.976  -8.979  -1.247  1.00 22.91           C  
ATOM   5241  CG  TYR C 411      64.804  -9.032  -2.236  1.00 24.06           C  
ATOM   5242  CD1 TYR C 411      64.376  -7.888  -2.928  1.00 23.95           C  
ATOM   5243  CD2 TYR C 411      64.085 -10.222  -2.435  1.00 24.63           C  
ATOM   5244  CE1 TYR C 411      63.298  -7.946  -3.812  1.00 24.55           C  
ATOM   5245  CE2 TYR C 411      63.001 -10.286  -3.318  1.00 22.66           C  
ATOM   5246  CZ  TYR C 411      62.607  -9.156  -4.000  1.00 25.17           C  
ATOM   5247  OH  TYR C 411      61.513  -9.239  -4.870  1.00 26.74           O  
ATOM   5248  N   ILE C 412      67.923  -8.183  -4.033  1.00 18.24           N  
ATOM   5249  CA  ILE C 412      68.363  -7.229  -5.038  1.00 18.62           C  
ATOM   5250  C   ILE C 412      67.310  -7.192  -6.136  1.00 18.11           C  
ATOM   5251  O   ILE C 412      67.325  -8.047  -7.026  1.00 17.02           O  
ATOM   5252  CB  ILE C 412      69.714  -7.698  -5.663  1.00 17.88           C  
ATOM   5253  CG1 ILE C 412      70.844  -7.588  -4.642  1.00 17.55           C  
ATOM   5254  CG2 ILE C 412      70.052  -6.903  -6.921  1.00 19.24           C  
ATOM   5255  CD1 ILE C 412      72.189  -7.975  -5.218  1.00 18.29           C  
ATOM   5256  N   PRO C 413      66.373  -6.229  -6.075  1.00 19.83           N  
ATOM   5257  CA  PRO C 413      65.434  -6.215  -7.189  1.00 20.11           C  
ATOM   5258  C   PRO C 413      66.073  -5.821  -8.533  1.00 20.53           C  
ATOM   5259  O   PRO C 413      66.954  -4.976  -8.587  1.00 20.70           O  
ATOM   5260  CB  PRO C 413      64.379  -5.216  -6.740  1.00 22.49           C  
ATOM   5261  CG  PRO C 413      65.116  -4.335  -5.784  1.00 24.34           C  
ATOM   5262  CD  PRO C 413      66.059  -5.192  -5.074  1.00 21.65           C  
ATOM   5263  N   PHE C 414      65.606  -6.478  -9.589  1.00 20.61           N  
ATOM   5264  CA  PHE C 414      66.058  -6.264 -10.953  1.00 22.66           C  
ATOM   5265  C   PHE C 414      65.908  -4.824 -11.452  1.00 26.21           C  
ATOM   5266  O   PHE C 414      66.510  -4.452 -12.434  1.00 27.93           O  
ATOM   5267  CB  PHE C 414      65.314  -7.212 -11.902  1.00 22.90           C  
ATOM   5268  CG  PHE C 414      65.733  -8.656 -11.784  1.00 20.69           C  
ATOM   5269  CD1 PHE C 414      66.853  -9.025 -11.053  1.00 17.96           C  
ATOM   5270  CD2 PHE C 414      65.022  -9.648 -12.457  1.00 21.94           C  
ATOM   5271  CE1 PHE C 414      67.221 -10.374 -10.959  1.00 18.09           C  
ATOM   5272  CE2 PHE C 414      65.383 -10.987 -12.384  1.00 18.23           C  
ATOM   5273  CZ  PHE C 414      66.478 -11.358 -11.625  1.00 17.82           C  
ATOM   5274  N   SER C 415      65.114  -4.015 -10.774  1.00 28.41           N  
ATOM   5275  CA  SER C 415      64.939  -2.656 -11.226  1.00 33.27           C  
ATOM   5276  C   SER C 415      65.930  -1.708 -10.555  1.00 34.73           C  
ATOM   5277  O   SER C 415      65.964  -0.527 -10.869  1.00 38.16           O  
ATOM   5278  CB  SER C 415      63.491  -2.207 -11.036  1.00 35.85           C  
ATOM   5279  OG  SER C 415      63.146  -2.134  -9.668  1.00 36.05           O  
ATOM   5280  N   ASP C 416      66.726  -2.244  -9.628  1.00 33.02           N  
ATOM   5281  CA  ASP C 416      67.879  -1.532  -9.066  1.00 35.10           C  
ATOM   5282  C   ASP C 416      69.126  -2.002  -9.778  1.00 34.20           C  
ATOM   5283  O   ASP C 416      70.225  -1.512  -9.497  1.00 36.40           O  
ATOM   5284  CB  ASP C 416      68.089  -1.844  -7.577  1.00 33.79           C  
ATOM   5285  CG  ASP C 416      66.975  -1.312  -6.672  1.00 37.92           C  
ATOM   5286  OD1 ASP C 416      66.243  -0.357  -7.037  1.00 42.17           O  
ATOM   5287  OD2 ASP C 416      66.852  -1.872  -5.559  1.00 38.89           O  
ATOM   5288  N   VAL C 417      68.983  -2.986 -10.663  1.00 32.36           N  
ATOM   5289  CA  VAL C 417      70.148  -3.523 -11.351  1.00 31.97           C  
ATOM   5290  C   VAL C 417      70.491  -2.651 -12.556  1.00 35.76           C  
ATOM   5291  O   VAL C 417      69.613  -2.286 -13.320  1.00 38.23           O  
ATOM   5292  CB  VAL C 417      69.978  -4.992 -11.759  1.00 29.53           C  
ATOM   5293  CG1 VAL C 417      71.208  -5.450 -12.531  1.00 30.47           C  
ATOM   5294  CG2 VAL C 417      69.800  -5.880 -10.511  1.00 26.77           C  
ATOM   5295  N   SER C 418      71.766  -2.296 -12.686  1.00 36.99           N  
ATOM   5296  CA  SER C 418      72.258  -1.465 -13.784  1.00 41.23           C  
ATOM   5297  C   SER C 418      72.701  -2.371 -14.928  1.00 41.49           C  
ATOM   5298  O   SER C 418      72.272  -2.214 -16.061  1.00 44.15           O  
ATOM   5299  CB  SER C 418      73.424  -0.600 -13.294  1.00 43.52           C  
ATOM   5300  OG  SER C 418      73.740   0.416 -14.208  1.00 47.22           O  
ATOM   5301  N   MET C 419      73.566  -3.325 -14.620  1.00 39.13           N  
ATOM   5302  CA  MET C 419      73.860  -4.400 -15.554  1.00 39.67           C  
ATOM   5303  C   MET C 419      74.507  -5.549 -14.839  1.00 35.89           C  
ATOM   5304  O   MET C 419      74.699  -5.506 -13.630  1.00 33.33           O  
ATOM   5305  CB  MET C 419      74.749  -3.929 -16.706  1.00 45.03           C  
ATOM   5306  CG  MET C 419      76.069  -3.350 -16.307  1.00 45.98           C  
ATOM   5307  SD  MET C 419      77.013  -3.083 -17.803  1.00 54.48           S  
ATOM   5308  CE  MET C 419      77.244  -4.791 -18.284  1.00 53.56           C  
ATOM   5309  N   VAL C 420      74.850  -6.580 -15.594  1.00 36.78           N  
ATOM   5310  CA  VAL C 420      75.405  -7.789 -15.000  1.00 34.43           C  
ATOM   5311  C   VAL C 420      76.684  -8.186 -15.694  1.00 37.64           C  
ATOM   5312  O   VAL C 420      76.841  -7.966 -16.889  1.00 41.94           O  
ATOM   5313  CB  VAL C 420      74.379  -8.941 -14.992  1.00 31.89           C  
ATOM   5314  CG1 VAL C 420      74.990 -10.196 -14.400  1.00 30.36           C  
ATOM   5315  CG2 VAL C 420      73.171  -8.531 -14.180  1.00 28.31           C  
ATOM   5316  N   ASN C 421      77.597  -8.756 -14.921  1.00 36.82           N  
ATOM   5317  CA  ASN C 421      78.919  -9.109 -15.406  1.00 40.60           C  
ATOM   5318  C   ASN C 421      79.341 -10.526 -15.052  1.00 39.67           C  
ATOM   5319  O   ASN C 421      79.122 -10.980 -13.926  1.00 36.20           O  
ATOM   5320  CB  ASN C 421      79.937  -8.104 -14.893  1.00 42.24           C  
ATOM   5321  CG  ASN C 421      79.941  -6.819 -15.701  1.00 47.05           C  
ATOM   5322  OD1 ASN C 421      79.476  -6.789 -16.838  1.00 50.70           O  
ATOM   5323  ND2 ASN C 421      80.469  -5.753 -15.118  1.00 48.58           N  
ATOM   5324  N   ILE C 422      79.938 -11.213 -16.024  1.00 43.50           N  
ATOM   5325  CA  ILE C 422      80.427 -12.575 -15.845  1.00 44.09           C  
ATOM   5326  C   ILE C 422      81.921 -12.551 -16.114  1.00 48.76           C  
ATOM   5327  O   ILE C 422      82.337 -12.095 -17.171  1.00 53.71           O  
ATOM   5328  CB  ILE C 422      79.799 -13.567 -16.870  1.00 46.04           C  
ATOM   5329  CG1 ILE C 422      78.301 -13.317 -17.092  1.00 43.37           C  
ATOM   5330  CG2 ILE C 422      80.092 -14.999 -16.475  1.00 46.01           C  
ATOM   5331  CD1 ILE C 422      77.383 -13.938 -16.071  1.00 35.90           C  
ATOM   5332  N   SER C 423      82.734 -13.030 -15.177  1.00 48.30           N  
ATOM   5333  CA  SER C 423      84.181 -13.178 -15.435  1.00 53.34           C  
ATOM   5334  C   SER C 423      84.736 -14.522 -14.955  1.00 54.07           C  
ATOM   5335  O   SER C 423      84.166 -15.144 -14.050  1.00 50.04           O  
ATOM   5336  CB  SER C 423      84.991 -12.006 -14.848  1.00 53.92           C  
ATOM   5337  OG  SER C 423      84.693 -11.782 -13.480  1.00 49.74           O  
ATOM   5338  N   ARG C 424      85.835 -14.963 -15.572  1.00 59.53           N  
ATOM   5339  CA  ARG C 424      86.513 -16.202 -15.175  1.00 61.75           C  
ATOM   5340  C   ARG C 424      87.184 -16.092 -13.792  1.00 59.94           C  
ATOM   5341  O   ARG C 424      86.588 -16.416 -12.749  1.00 55.00           O  
ATOM   5342  CB  ARG C 424      87.521 -16.614 -16.231  1.00 69.16           C  
ATOM   5343  N   ARG C 433      86.592 -23.843 -13.706  1.00 74.94           N  
ATOM   5344  CA  ARG C 433      85.474 -24.551 -13.098  1.00 71.51           C  
ATOM   5345  C   ARG C 433      84.352 -23.579 -12.726  1.00 63.96           C  
ATOM   5346  O   ARG C 433      83.166 -23.940 -12.729  1.00 61.32           O  
ATOM   5347  CB  ARG C 433      85.938 -25.294 -11.840  1.00 72.32           C  
ATOM   5348  CG  ARG C 433      84.913 -26.288 -11.283  1.00 71.50           C  
ATOM   5349  CD  ARG C 433      85.366 -27.731 -11.475  1.00 79.89           C  
ATOM   5350  NE  ARG C 433      86.460 -28.036 -10.557  1.00 83.86           N  
ATOM   5351  CZ  ARG C 433      87.067 -29.215 -10.436  1.00 90.58           C  
ATOM   5352  NH1 ARG C 433      86.713 -30.265 -11.175  1.00 95.24           N  
ATOM   5353  NH2 ARG C 433      88.046 -29.340  -9.553  1.00 93.07           N  
ATOM   5354  N   THR C 434      84.739 -22.344 -12.404  1.00 60.80           N  
ATOM   5355  CA  THR C 434      83.832 -21.373 -11.818  1.00 53.79           C  
ATOM   5356  C   THR C 434      83.931 -19.995 -12.458  1.00 52.71           C  
ATOM   5357  O   THR C 434      84.919 -19.671 -13.120  1.00 56.14           O  
ATOM   5358  CB  THR C 434      84.091 -21.203 -10.306  1.00 51.13           C  
ATOM   5359  OG1 THR C 434      85.342 -20.539 -10.119  1.00 53.42           O  
ATOM   5360  CG2 THR C 434      84.096 -22.552  -9.568  1.00 52.83           C  
ATOM   5361  N   PHE C 435      82.897 -19.180 -12.226  1.00 47.87           N  
ATOM   5362  CA  PHE C 435      82.850 -17.804 -12.717  1.00 46.86           C  
ATOM   5363  C   PHE C 435      82.220 -16.893 -11.663  1.00 42.25           C  
ATOM   5364  O   PHE C 435      81.668 -17.371 -10.674  1.00 40.51           O  
ATOM   5365  CB  PHE C 435      82.102 -17.724 -14.056  1.00 47.74           C  
ATOM   5366  CG  PHE C 435      80.656 -18.138 -13.976  1.00 43.89           C  
ATOM   5367  CD1 PHE C 435      79.652 -17.186 -13.888  1.00 39.78           C  
ATOM   5368  CD2 PHE C 435      80.300 -19.478 -13.985  1.00 44.33           C  
ATOM   5369  CE1 PHE C 435      78.302 -17.570 -13.804  1.00 37.59           C  
ATOM   5370  CE2 PHE C 435      78.960 -19.867 -13.895  1.00 42.90           C  
ATOM   5371  CZ  PHE C 435      77.962 -18.924 -13.810  1.00 38.11           C  
ATOM   5372  N   ASP C 436      82.311 -15.583 -11.862  1.00 41.93           N  
ATOM   5373  CA  ASP C 436      81.720 -14.624 -10.933  1.00 38.07           C  
ATOM   5374  C   ASP C 436      80.635 -13.836 -11.615  1.00 35.91           C  
ATOM   5375  O   ASP C 436      80.773 -13.437 -12.787  1.00 38.53           O  
ATOM   5376  CB  ASP C 436      82.755 -13.617 -10.437  1.00 40.33           C  
ATOM   5377  CG  ASP C 436      83.723 -14.202  -9.435  1.00 44.04           C  
ATOM   5378  OD1 ASP C 436      83.715 -15.442  -9.208  1.00 46.42           O  
ATOM   5379  OD2 ASP C 436      84.510 -13.394  -8.879  1.00 48.15           O  
ATOM   5380  N   LEU C 437      79.577 -13.574 -10.853  1.00 31.53           N  
ATOM   5381  CA  LEU C 437      78.475 -12.768 -11.310  1.00 29.18           C  
ATOM   5382  C   LEU C 437      78.466 -11.445 -10.541  1.00 27.79           C  
ATOM   5383  O   LEU C 437      78.131 -11.407  -9.359  1.00 25.16           O  
ATOM   5384  CB  LEU C 437      77.191 -13.548 -11.125  1.00 26.90           C  
ATOM   5385  CG  LEU C 437      75.915 -13.033 -11.754  1.00 26.18           C  
ATOM   5386  CD1 LEU C 437      74.879 -14.150 -11.727  1.00 25.87           C  
ATOM   5387  CD2 LEU C 437      75.425 -11.824 -10.988  1.00 24.62           C  
ATOM   5388  N   GLU C 438      78.864 -10.376 -11.230  1.00 29.81           N  
ATOM   5389  CA  GLU C 438      78.912  -9.029 -10.668  1.00 30.13           C  
ATOM   5390  C   GLU C 438      77.636  -8.286 -11.040  1.00 29.12           C  
ATOM   5391  O   GLU C 438      77.400  -7.968 -12.201  1.00 31.68           O  
ATOM   5392  CB  GLU C 438      80.138  -8.262 -11.203  1.00 34.44           C  
ATOM   5393  CG  GLU C 438      80.170  -6.781 -10.802  1.00 35.75           C  
ATOM   5394  CD  GLU C 438      81.293  -5.964 -11.433  1.00 40.27           C  
ATOM   5395  OE1 GLU C 438      82.049  -6.468 -12.291  1.00 44.88           O  
ATOM   5396  OE2 GLU C 438      81.420  -4.789 -11.055  1.00 41.40           O  
ATOM   5397  N   VAL C 439      76.807  -8.014 -10.050  1.00 26.70           N  
ATOM   5398  CA  VAL C 439      75.570  -7.287 -10.269  1.00 25.79           C  
ATOM   5399  C   VAL C 439      75.863  -5.845  -9.969  1.00 27.98           C  
ATOM   5400  O   VAL C 439      76.102  -5.505  -8.806  1.00 27.87           O  
ATOM   5401  CB  VAL C 439      74.483  -7.756  -9.305  1.00 22.78           C  
ATOM   5402  CG1 VAL C 439      73.279  -6.871  -9.394  1.00 23.77           C  
ATOM   5403  CG2 VAL C 439      74.113  -9.173  -9.588  1.00 20.89           C  
ATOM   5404  N   VAL C 440      75.863  -5.009 -11.010  1.00 30.61           N  
ATOM   5405  CA  VAL C 440      76.113  -3.565 -10.864  1.00 33.29           C  
ATOM   5406  C   VAL C 440      74.820  -2.829 -10.501  1.00 33.12           C  
ATOM   5407  O   VAL C 440      73.878  -2.804 -11.288  1.00 33.28           O  
ATOM   5408  CB  VAL C 440      76.728  -2.952 -12.156  1.00 37.46           C  
ATOM   5409  CG1 VAL C 440      76.911  -1.440 -12.013  1.00 40.00           C  
ATOM   5410  CG2 VAL C 440      78.047  -3.637 -12.490  1.00 38.04           C  
ATOM   5411  N   LEU C 441      74.789  -2.237  -9.308  1.00 33.61           N  
ATOM   5412  CA  LEU C 441      73.619  -1.492  -8.819  1.00 34.52           C  
ATOM   5413  C   LEU C 441      73.458  -0.157  -9.518  1.00 38.90           C  
ATOM   5414  O   LEU C 441      74.371   0.330 -10.179  1.00 42.02           O  
ATOM   5415  CB  LEU C 441      73.710  -1.277  -7.306  1.00 34.74           C  
ATOM   5416  CG  LEU C 441      72.876  -2.159  -6.375  1.00 32.17           C  
ATOM   5417  CD1 LEU C 441      73.173  -3.622  -6.624  1.00 29.09           C  
ATOM   5418  CD2 LEU C 441      73.091  -1.784  -4.886  1.00 33.14           C  
ATOM   5419  N   ARG C 442      72.287   0.439  -9.375  1.00 40.46           N  
ATOM   5420  CA  ARG C 442      72.027   1.735  -9.992  1.00 45.37           C  
ATOM   5421  C   ARG C 442      72.311   2.866  -9.007  1.00 49.26           C  
ATOM   5422  O   ARG C 442      72.530   2.627  -7.818  1.00 47.92           O  
ATOM   5423  CB  ARG C 442      70.581   1.822 -10.471  1.00 45.79           C  
ATOM   5424  CG  ARG C 442      70.277   1.015 -11.707  1.00 44.07           C  
ATOM   5425  CD  ARG C 442      69.013   1.559 -12.373  1.00 47.77           C  
ATOM   5426  NE  ARG C 442      68.383   0.552 -13.221  1.00 45.20           N  
ATOM   5427  CZ  ARG C 442      67.824   0.810 -14.395  1.00 48.60           C  
ATOM   5428  NH1 ARG C 442      67.810   2.049 -14.868  1.00 53.98           N  
ATOM   5429  NH2 ARG C 442      67.282  -0.173 -15.097  1.00 48.10           N  
ATOM   5430  N   SER C 443      72.297   4.100  -9.514  1.00 54.96           N  
ATOM   5431  CA  SER C 443      72.534   5.299  -8.697  1.00 59.83           C  
ATOM   5432  C   SER C 443      73.938   5.295  -8.076  1.00 60.40           C  
ATOM   5433  O   SER C 443      74.155   5.924  -7.030  1.00 63.48           O  
ATOM   5434  CB  SER C 443      71.460   5.449  -7.596  1.00 60.00           C  
ATOM   5435  OG  SER C 443      70.218   5.915  -8.107  1.00 61.65           O  
ATOM   5436  N   ASN C 444      74.882   4.597  -8.718  1.00 57.70           N  
ATOM   5437  CA  ASN C 444      76.220   4.436  -8.168  1.00 58.01           C  
ATOM   5438  C   ASN C 444      76.149   3.931  -6.724  1.00 55.44           C  
ATOM   5439  O   ASN C 444      76.757   4.504  -5.824  1.00 58.57           O  
ATOM   5440  CB  ASN C 444      77.002   5.760  -8.216  1.00 65.30           C  
ATOM   5441  CG  ASN C 444      77.195   6.305  -9.635  1.00 68.82           C  
ATOM   5442  OD1 ASN C 444      77.729   5.624 -10.515  1.00 67.91           O  
ATOM   5443  ND2 ASN C 444      76.800   7.552  -9.843  1.00 72.42           N  
ATOM   5444  N   ARG C 445      75.374   2.877  -6.508  1.00 50.43           N  
ATOM   5445  CA  ARG C 445      75.298   2.224  -5.194  1.00 48.89           C  
ATOM   5446  C   ARG C 445      76.339   1.103  -5.064  1.00 45.44           C  
ATOM   5447  O   ARG C 445      76.347   0.366  -4.079  1.00 43.17           O  
ATOM   5448  CB  ARG C 445      73.890   1.682  -4.921  1.00 45.21           C  
ATOM   5449  CG  ARG C 445      72.899   2.733  -4.466  1.00 50.28           C  
ATOM   5450  CD  ARG C 445      71.445   2.223  -4.503  1.00 48.81           C  
ATOM   5451  NE  ARG C 445      70.497   3.349  -4.612  1.00 56.94           N  
ATOM   5452  CZ  ARG C 445      69.177   3.288  -4.386  1.00 57.54           C  
ATOM   5453  NH1 ARG C 445      68.595   2.145  -4.013  1.00 52.98           N  
ATOM   5454  NH2 ARG C 445      68.428   4.388  -4.521  1.00 63.42           N  
ATOM   5455  N   GLY C 446      77.217   1.004  -6.063  1.00 45.69           N  
ATOM   5456  CA  GLY C 446      78.264  -0.008  -6.103  1.00 43.54           C  
ATOM   5457  C   GLY C 446      77.808  -1.283  -6.781  1.00 38.61           C  
ATOM   5458  O   GLY C 446      76.789  -1.294  -7.471  1.00 37.42           O  
ATOM   5459  N   SER C 447      78.562  -2.365  -6.585  1.00 36.16           N  
ATOM   5460  CA  SER C 447      78.131  -3.669  -7.080  1.00 31.68           C  
ATOM   5461  C   SER C 447      78.278  -4.813  -6.072  1.00 29.12           C  
ATOM   5462  O   SER C 447      79.057  -4.759  -5.119  1.00 29.57           O  
ATOM   5463  CB  SER C 447      78.770  -4.019  -8.434  1.00 32.69           C  
ATOM   5464  OG  SER C 447      80.169  -3.848  -8.432  1.00 34.16           O  
ATOM   5465  N   THR C 448      77.464  -5.828  -6.301  1.00 26.12           N  
ATOM   5466  CA  THR C 448      77.470  -7.040  -5.532  1.00 25.09           C  
ATOM   5467  C   THR C 448      77.966  -8.129  -6.445  1.00 24.33           C  
ATOM   5468  O   THR C 448      77.406  -8.324  -7.517  1.00 23.03           O  
ATOM   5469  CB  THR C 448      76.042  -7.397  -5.091  1.00 23.12           C  
ATOM   5470  OG1 THR C 448      75.522  -6.330  -4.293  1.00 25.03           O  
ATOM   5471  CG2 THR C 448      76.036  -8.680  -4.283  1.00 22.51           C  
ATOM   5472  N   THR C 449      79.020  -8.822  -6.017  1.00 25.75           N  
ATOM   5473  CA  THR C 449      79.580  -9.933  -6.783  1.00 26.90           C  
ATOM   5474  C   THR C 449      79.286 -11.286  -6.110  1.00 25.96           C  
ATOM   5475  O   THR C 449      79.666 -11.524  -4.951  1.00 27.82           O  
ATOM   5476  CB  THR C 449      81.108  -9.771  -6.950  1.00 30.13           C  
ATOM   5477  OG1 THR C 449      81.389  -8.516  -7.575  1.00 33.66           O  
ATOM   5478  CG2 THR C 449      81.672 -10.857  -7.808  1.00 30.74           C  
ATOM   5479  N   PHE C 450      78.609 -12.170  -6.822  1.00 24.52           N  
ATOM   5480  CA  PHE C 450      78.476 -13.537  -6.349  1.00 23.97           C  
ATOM   5481  C   PHE C 450      79.517 -14.371  -7.049  1.00 26.38           C  
ATOM   5482  O   PHE C 450      79.434 -14.568  -8.265  1.00 26.92           O  
ATOM   5483  CB  PHE C 450      77.068 -14.065  -6.576  1.00 21.48           C  
ATOM   5484  CG  PHE C 450      76.025 -13.238  -5.897  1.00 21.23           C  
ATOM   5485  CD1 PHE C 450      75.762 -13.405  -4.536  1.00 20.17           C  
ATOM   5486  CD2 PHE C 450      75.320 -12.266  -6.606  1.00 18.84           C  
ATOM   5487  CE1 PHE C 450      74.823 -12.627  -3.906  1.00 19.53           C  
ATOM   5488  CE2 PHE C 450      74.373 -11.507  -5.988  1.00 16.94           C  
ATOM   5489  CZ  PHE C 450      74.129 -11.673  -4.628  1.00 19.20           C  
ATOM   5490  N   ALA C 451      80.480 -14.852  -6.256  1.00 28.21           N  
ATOM   5491  CA  ALA C 451      81.685 -15.547  -6.731  1.00 31.44           C  
ATOM   5492  C   ALA C 451      81.503 -17.030  -6.728  1.00 32.41           C  
ATOM   5493  O   ALA C 451      80.669 -17.552  -5.985  1.00 30.83           O  
ATOM   5494  CB  ALA C 451      82.888 -15.208  -5.856  1.00 33.31           C  
ATOM   5495  N   ASN C 452      82.329 -17.691  -7.544  1.00 35.82           N  
ATOM   5496  CA  ASN C 452      82.458 -19.152  -7.598  1.00 38.30           C  
ATOM   5497  C   ASN C 452      81.179 -19.925  -7.862  1.00 36.40           C  
ATOM   5498  O   ASN C 452      80.775 -20.773  -7.062  1.00 36.60           O  
ATOM   5499  CB  ASN C 452      83.144 -19.695  -6.347  1.00 40.27           C  
ATOM   5500  CG  ASN C 452      84.440 -18.986  -6.042  1.00 43.16           C  
ATOM   5501  OD1 ASN C 452      84.726 -18.719  -4.885  1.00 45.89           O  
ATOM   5502  ND2 ASN C 452      85.224 -18.662  -7.069  1.00 44.67           N  
ATOM   5503  N   ILE C 453      80.550 -19.619  -8.986  1.00 35.18           N  
ATOM   5504  CA  ILE C 453      79.443 -20.400  -9.472  1.00 34.84           C  
ATOM   5505  C   ILE C 453      79.992 -21.440 -10.437  1.00 39.91           C  
ATOM   5506  O   ILE C 453      80.835 -21.128 -11.279  1.00 42.93           O  
ATOM   5507  CB  ILE C 453      78.435 -19.514 -10.181  1.00 32.03           C  
ATOM   5508  CG1 ILE C 453      77.879 -18.471  -9.203  1.00 28.22           C  
ATOM   5509  CG2 ILE C 453      77.295 -20.361 -10.689  1.00 33.29           C  
ATOM   5510  CD1 ILE C 453      77.414 -17.171  -9.845  1.00 25.54           C  
ATOM   5511  N   SER C 454      79.532 -22.679 -10.317  1.00 41.79           N  
ATOM   5512  CA  SER C 454      79.935 -23.716 -11.270  1.00 47.31           C  
ATOM   5513  C   SER C 454      79.707 -23.227 -12.716  1.00 48.78           C  
ATOM   5514  O   SER C 454      78.613 -22.785 -13.051  1.00 46.08           O  
ATOM   5515  CB  SER C 454      79.173 -25.024 -11.000  1.00 48.67           C  
ATOM   5516  OG  SER C 454      79.434 -25.989 -12.004  1.00 53.69           O  
ATOM   5517  N   LYS C 455      80.741 -23.307 -13.556  1.00 53.84           N  
ATOM   5518  CA  LYS C 455      80.634 -22.890 -14.964  1.00 56.69           C  
ATOM   5519  C   LYS C 455      79.511 -23.610 -15.727  1.00 58.95           C  
ATOM   5520  O   LYS C 455      78.919 -23.041 -16.649  1.00 59.57           O  
ATOM   5521  CB  LYS C 455      81.973 -23.034 -15.701  1.00 62.51           C  
ATOM   5522  CG  LYS C 455      81.928 -22.655 -17.187  1.00 65.85           C  
ATOM   5523  CD  LYS C 455      83.284 -22.915 -17.860  1.00 74.03           C  
ATOM   5524  CE  LYS C 455      83.138 -23.383 -19.316  1.00 79.03           C  
ATOM   5525  NZ  LYS C 455      84.372 -23.146 -20.095  1.00 83.59           N  
ATOM   5526  N   GLU C 456      79.220 -24.853 -15.350  1.00 60.91           N  
ATOM   5527  CA  GLU C 456      78.070 -25.568 -15.905  1.00 62.51           C  
ATOM   5528  C   GLU C 456      76.862 -24.633 -16.007  1.00 57.27           C  
ATOM   5529  O   GLU C 456      76.308 -24.470 -17.095  1.00 59.60           O  
ATOM   5530  CB  GLU C 456      77.731 -26.799 -15.060  1.00 63.47           C  
ATOM   5531  CG  GLU C 456      78.948 -27.624 -14.669  1.00 67.67           C  
ATOM   5532  CD  GLU C 456      78.621 -28.769 -13.722  1.00 69.10           C  
ATOM   5533  OE1 GLU C 456      79.265 -29.843 -13.862  1.00 75.30           O  
ATOM   5534  OE2 GLU C 456      77.732 -28.602 -12.852  1.00 61.70           O  
ATOM   5535  N   GLU C 457      76.510 -23.989 -14.888  1.00 50.70           N  
ATOM   5536  CA  GLU C 457      75.342 -23.096 -14.775  1.00 45.81           C  
ATOM   5537  C   GLU C 457      75.408 -21.797 -15.587  1.00 45.05           C  
ATOM   5538  O   GLU C 457      74.403 -21.108 -15.770  1.00 42.77           O  
ATOM   5539  CB  GLU C 457      75.056 -22.780 -13.296  1.00 40.36           C  
ATOM   5540  CG  GLU C 457      73.842 -23.536 -12.707  1.00 39.53           C  
ATOM   5541  CD  GLU C 457      74.128 -24.979 -12.290  1.00 43.31           C  
ATOM   5542  OE1 GLU C 457      75.298 -25.424 -12.325  1.00 48.30           O  
ATOM   5543  OE2 GLU C 457      73.170 -25.681 -11.915  1.00 43.23           O  
ATOM   5544  N   GLN C 458      76.598 -21.475 -16.069  1.00 48.00           N  
ATOM   5545  CA  GLN C 458      76.855 -20.282 -16.871  1.00 49.00           C  
ATOM   5546  C   GLN C 458      75.869 -20.045 -18.032  1.00 51.14           C  
ATOM   5547  O   GLN C 458      75.429 -18.911 -18.242  1.00 49.34           O  
ATOM   5548  CB  GLN C 458      78.306 -20.333 -17.370  1.00 53.70           C  
ATOM   5549  CG  GLN C 458      78.628 -19.549 -18.635  1.00 59.31           C  
ATOM   5550  CD  GLN C 458      79.216 -18.184 -18.349  1.00 58.60           C  
ATOM   5551  OE1 GLN C 458      78.698 -17.414 -17.521  1.00 53.58           O  
ATOM   5552  NE2 GLN C 458      80.299 -17.867 -19.047  1.00 62.59           N  
ATOM   5553  N   GLN C 459      75.537 -21.102 -18.765  1.00 55.86           N  
ATOM   5554  CA  GLN C 459      74.642 -20.983 -19.911  1.00 58.80           C  
ATOM   5555  C   GLN C 459      73.225 -20.628 -19.470  1.00 54.13           C  
ATOM   5556  O   GLN C 459      72.698 -19.572 -19.822  1.00 52.18           O  
ATOM   5557  CB  GLN C 459      74.631 -22.281 -20.720  1.00 65.79           C  
ATOM   5558  CG  GLN C 459      74.543 -22.074 -22.223  1.00114.23           C  
ATOM   5559  CD  GLN C 459      73.193 -22.470 -22.788  1.00116.79           C  
ATOM   5560  OE1 GLN C 459      72.695 -23.565 -22.528  1.00117.31           O  
ATOM   5561  NE2 GLN C 459      72.594 -21.578 -23.567  1.00119.02           N  
ATOM   5562  N   LEU C 460      72.614 -21.520 -18.698  1.00 52.59           N  
ATOM   5563  CA  LEU C 460      71.216 -21.344 -18.243  1.00 49.30           C  
ATOM   5564  C   LEU C 460      70.974 -20.048 -17.478  1.00 43.71           C  
ATOM   5565  O   LEU C 460      69.931 -19.410 -17.660  1.00 42.58           O  
ATOM   5566  CB  LEU C 460      70.725 -22.541 -17.421  1.00 48.39           C  
ATOM   5567  CG  LEU C 460      70.646 -23.879 -18.162  1.00 55.69           C  
ATOM   5568  CD1 LEU C 460      70.285 -25.009 -17.208  1.00 54.73           C  
ATOM   5569  CD2 LEU C 460      69.703 -23.843 -19.390  1.00 60.05           C  
ATOM   5570  N   LEU C 461      71.942 -19.660 -16.649  1.00 41.02           N  
ATOM   5571  CA  LEU C 461      71.861 -18.415 -15.895  1.00 36.84           C  
ATOM   5572  C   LEU C 461      71.848 -17.162 -16.790  1.00 38.26           C  
ATOM   5573  O   LEU C 461      71.000 -16.278 -16.602  1.00 35.92           O  
ATOM   5574  CB  LEU C 461      73.002 -18.347 -14.894  1.00 34.91           C  
ATOM   5575  CG  LEU C 461      72.935 -17.269 -13.812  1.00 31.07           C  
ATOM   5576  CD1 LEU C 461      71.589 -17.232 -13.147  1.00 29.04           C  
ATOM   5577  CD2 LEU C 461      73.998 -17.550 -12.771  1.00 30.70           C  
ATOM   5578  N   GLU C 462      72.790 -17.090 -17.738  1.00 41.95           N  
ATOM   5579  CA  GLU C 462      72.820 -16.028 -18.752  1.00 45.03           C  
ATOM   5580  C   GLU C 462      71.456 -15.887 -19.435  1.00 45.93           C  
ATOM   5581  O   GLU C 462      70.815 -14.840 -19.337  1.00 44.51           O  
ATOM   5582  CB  GLU C 462      73.866 -16.340 -19.838  1.00 50.85           C  
ATOM   5583  CG  GLU C 462      75.244 -15.730 -19.715  1.00 51.67           C  
ATOM   5584  CD  GLU C 462      76.204 -16.316 -20.752  1.00 60.06           C  
ATOM   5585  OE1 GLU C 462      76.084 -17.529 -21.071  1.00 66.96           O  
ATOM   5586  OE2 GLU C 462      77.082 -15.576 -21.264  1.00 65.24           O  
ATOM   5587  N   GLN C 463      71.048 -16.949 -20.141  1.00 49.33           N  
ATOM   5588  CA  GLN C 463      69.762 -17.065 -20.835  1.00 51.34           C  
ATOM   5589  C   GLN C 463      68.628 -16.437 -20.026  1.00 46.61           C  
ATOM   5590  O   GLN C 463      67.854 -15.616 -20.537  0.50 47.51           O  
ATOM   5591  CB  GLN C 463      69.444 -18.549 -21.083  1.00 54.53           C  
ATOM   5592  CG  GLN C 463      69.462 -19.006 -22.531  1.00 62.51           C  
ATOM   5593  CD  GLN C 463      70.827 -18.861 -23.208  1.00 67.03           C  
ATOM   5594  OE1 GLN C 463      71.866 -19.223 -22.649  1.00 65.46           O  
ATOM   5595  NE2 GLN C 463      70.821 -18.339 -24.430  1.00 72.47           N  
ATOM   5596  N   PHE C 464      68.557 -16.829 -18.753  1.00 41.64           N  
ATOM   5597  CA  PHE C 464      67.509 -16.376 -17.871  1.00 37.57           C  
ATOM   5598  C   PHE C 464      67.580 -14.887 -17.611  1.00 35.08           C  
ATOM   5599  O   PHE C 464      66.612 -14.179 -17.857  1.00 36.01           O  
ATOM   5600  CB  PHE C 464      67.537 -17.130 -16.554  1.00 33.87           C  
ATOM   5601  CG  PHE C 464      66.478 -16.688 -15.594  1.00 31.24           C  
ATOM   5602  CD1 PHE C 464      66.820 -16.041 -14.404  1.00 27.64           C  
ATOM   5603  CD2 PHE C 464      65.131 -16.898 -15.878  1.00 32.58           C  
ATOM   5604  CE1 PHE C 464      65.838 -15.631 -13.500  1.00 23.80           C  
ATOM   5605  CE2 PHE C 464      64.145 -16.492 -14.978  1.00 30.79           C  
ATOM   5606  CZ  PHE C 464      64.501 -15.857 -13.789  1.00 26.49           C  
ATOM   5607  N   LEU C 465      68.719 -14.413 -17.121  1.00 32.89           N  
ATOM   5608  CA  LEU C 465      68.862 -13.000 -16.795  1.00 31.57           C  
ATOM   5609  C   LEU C 465      68.581 -12.042 -17.961  1.00 35.78           C  
ATOM   5610  O   LEU C 465      67.913 -11.014 -17.758  1.00 35.45           O  
ATOM   5611  CB  LEU C 465      70.217 -12.723 -16.164  1.00 29.70           C  
ATOM   5612  CG  LEU C 465      70.425 -13.483 -14.853  1.00 26.24           C  
ATOM   5613  CD1 LEU C 465      71.826 -13.206 -14.357  1.00 25.47           C  
ATOM   5614  CD2 LEU C 465      69.375 -13.114 -13.801  1.00 23.57           C  
ATOM   5615  N   LYS C 466      69.062 -12.385 -19.163  1.00 40.34           N  
ATOM   5616  CA  LYS C 466      68.738 -11.624 -20.363  1.00 45.39           C  
ATOM   5617  C   LYS C 466      67.232 -11.647 -20.675  1.00 46.84           C  
ATOM   5618  O   LYS C 466      66.697 -10.656 -21.190  1.00 49.36           O  
ATOM   5619  CB  LYS C 466      69.561 -12.087 -21.583  1.00 51.23           C  
ATOM   5620  CG  LYS C 466      68.871 -13.107 -22.556  1.00 57.27           C  
ATOM   5621  CD  LYS C 466      67.698 -12.496 -23.377  1.00 61.18           C  
ATOM   5622  CE  LYS C 466      66.809 -13.537 -24.052  1.00 64.24           C  
ATOM   5623  NZ  LYS C 466      67.078 -13.615 -25.527  1.00 73.53           N  
ATOM   5624  N   SER C 467      66.557 -12.767 -20.379  1.00 45.55           N  
ATOM   5625  CA  SER C 467      65.118 -12.896 -20.676  1.00 47.15           C  
ATOM   5626  C   SER C 467      64.306 -11.916 -19.821  1.00 43.87           C  
ATOM   5627  O   SER C 467      63.164 -11.576 -20.154  1.00 46.14           O  
ATOM   5628  CB  SER C 467      64.615 -14.334 -20.469  1.00 47.08           C  
ATOM   5629  OG  SER C 467      63.985 -14.487 -19.199  1.00 42.54           O  
ATOM   5630  N   LYS C 468      64.926 -11.473 -18.730  1.00 38.75           N  
ATOM   5631  CA  LYS C 468      64.310 -10.566 -17.782  1.00 35.77           C  
ATOM   5632  C   LYS C 468      64.780  -9.108 -17.961  1.00 37.28           C  
ATOM   5633  O   LYS C 468      64.588  -8.268 -17.072  1.00 34.72           O  
ATOM   5634  CB  LYS C 468      64.563 -11.080 -16.364  1.00 31.06           C  
ATOM   5635  CG  LYS C 468      63.795 -12.387 -16.009  1.00 29.59           C  
ATOM   5636  CD  LYS C 468      62.297 -12.108 -15.899  1.00 29.34           C  
ATOM   5637  CE  LYS C 468      61.483 -13.389 -15.918  1.00 31.65           C  
ATOM   5638  NZ  LYS C 468      60.016 -13.175 -16.151  1.00 30.15           N  
ATOM   5639  N   ASN C 469      65.413  -8.828 -19.109  1.00 41.35           N  
ATOM   5640  CA  ASN C 469      65.657  -7.461 -19.572  1.00 44.78           C  
ATOM   5641  C   ASN C 469      66.861  -6.702 -19.006  1.00 43.43           C  
ATOM   5642  O   ASN C 469      67.012  -5.508 -19.266  1.00 46.46           O  
ATOM   5643  CB  ASN C 469      64.420  -6.593 -19.341  1.00 46.32           C  
ATOM   5644  CG  ASN C 469      63.209  -7.088 -20.076  1.00 50.13           C  
ATOM   5645  OD1 ASN C 469      63.305  -7.651 -21.174  1.00 55.35           O  
ATOM   5646  ND2 ASN C 469      62.046  -6.845 -19.491  1.00 49.07           N  
ATOM   5647  N   LEU C 470      67.709  -7.363 -18.235  1.00 39.77           N  
ATOM   5648  CA  LEU C 470      68.909  -6.698 -17.719  1.00 38.81           C  
ATOM   5649  C   LEU C 470      70.010  -6.813 -18.743  1.00 42.17           C  
ATOM   5650  O   LEU C 470      70.000  -7.734 -19.560  1.00 44.61           O  
ATOM   5651  CB  LEU C 470      69.373  -7.360 -16.423  1.00 34.42           C  
ATOM   5652  CG  LEU C 470      68.281  -7.823 -15.457  1.00 31.50           C  
ATOM   5653  CD1 LEU C 470      68.925  -8.473 -14.264  1.00 29.17           C  
ATOM   5654  CD2 LEU C 470      67.351  -6.661 -15.038  1.00 33.01           C  
ATOM   5655  N   ARG C 471      70.963  -5.891 -18.712  1.00 43.33           N  
ATOM   5656  CA  ARG C 471      72.098  -5.998 -19.608  1.00 46.36           C  
ATOM   5657  C   ARG C 471      73.050  -7.000 -18.973  1.00 43.09           C  
ATOM   5658  O   ARG C 471      73.356  -6.882 -17.785  1.00 38.90           O  
ATOM   5659  CB  ARG C 471      72.770  -4.644 -19.769  1.00 49.41           C  
ATOM   5660  CG  ARG C 471      73.562  -4.494 -21.054  1.00 56.10           C  
ATOM   5661  CD  ARG C 471      74.872  -5.269 -21.034  1.00 54.93           C  
ATOM   5662  NE  ARG C 471      75.125  -5.898 -22.324  1.00 59.83           N  
ATOM   5663  CZ  ARG C 471      76.224  -5.731 -23.046  1.00 66.81           C  
ATOM   5664  NH1 ARG C 471      77.206  -4.954 -22.608  1.00 69.02           N  
ATOM   5665  NH2 ARG C 471      76.351  -6.350 -24.212  1.00 72.69           N  
ATOM   5666  N   VAL C 472      73.477  -8.002 -19.743  1.00 45.17           N  
ATOM   5667  CA  VAL C 472      74.521  -8.940 -19.283  1.00 43.65           C  
ATOM   5668  C   VAL C 472      75.748  -8.793 -20.143  1.00 48.88           C  
ATOM   5669  O   VAL C 472      75.698  -9.144 -21.320  1.00 54.15           O  
ATOM   5670  CB  VAL C 472      74.130 -10.432 -19.424  1.00 43.07           C  
ATOM   5671  CG1 VAL C 472      75.285 -11.332 -18.922  1.00 41.59           C  
ATOM   5672  CG2 VAL C 472      72.824 -10.744 -18.701  1.00 38.84           C  
ATOM   5673  N   LYS C 473      76.844  -8.289 -19.579  1.00 48.30           N  
ATOM   5674  CA  LYS C 473      78.124  -8.288 -20.289  1.00 53.19           C  
ATOM   5675  C   LYS C 473      79.044  -9.358 -19.726  1.00 52.02           C  
ATOM   5676  O   LYS C 473      78.984  -9.659 -18.538  1.00 46.61           O  
ATOM   5677  CB  LYS C 473      78.798  -6.909 -20.231  1.00 55.39           C  
ATOM   5678  CG  LYS C 473      80.290  -6.881 -20.569  1.00 59.73           C  
ATOM   5679  CD  LYS C 473      80.630  -7.401 -21.980  1.00 66.83           C  
ATOM   5680  CE  LYS C 473      79.967  -6.600 -23.083  1.00 71.84           C  
ATOM   5681  NZ  LYS C 473      80.777  -6.569 -24.344  1.00 81.36           N  
ATOM   5682  N   ASN C 474      79.894  -9.927 -20.585  1.00 57.69           N  
ATOM   5683  CA  ASN C 474      80.933 -10.853 -20.124  1.00 58.05           C  
ATOM   5684  C   ASN C 474      82.183 -10.915 -20.982  1.00 64.98           C  
ATOM   5685  O   ASN C 474      83.276 -11.100 -20.457  1.00 66.16           O  
ATOM   5686  CB  ASN C 474      80.343 -12.253 -19.855  1.00 55.78           C  
ATOM   5687  CG  ASN C 474      80.420 -13.176 -21.043  1.00 60.30           C  
ATOM   5688  OD1 ASN C 474      81.492 -13.367 -21.624  1.00 65.86           O  
ATOM   5689  ND2 ASN C 474      79.291 -13.794 -21.384  1.00 55.78           N  
TER    5690      ASN C 474                                                      
END
MOLECULE T0446.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
