
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 (  828),  selected   99 , name 2dx5_A
# Molecule2: number of CA atoms  116 (  905),  selected  116 , name T0446.pdb
# PARAMETERS: 2dx5_A.T0446.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      G       9           -
LGA    -       -      N      10           -
LGA    -       -      A      11           -
LGA    -       -      A      12           -
LGA    -       -      E      13           -
LGA    -       -      V      14           -
LGA    -       -      N      15           -
LGA    -       -      L      16           -
LGA    -       -      D      17           -
LGA    -       -      E      18           -
LGA    -       -      L      19           -
LGA    -       -      A      20           -
LGA    -       -      Q      21           -
LGA    -       -      E      22           -
LGA    -       -      L      23           -
LGA    -       -      G      24           -
LGA    -       -      P      25           -
LGA    L    10_A      I      26          3.241
LGA    L    11_A      M      27          1.309
LGA    E    12_A      G      28          1.493
LGA    I    13_A      D      29          1.214
LGA    N    14_A      N      30          1.071
LGA    E    15_A      E      31          1.205
LGA    T    16_A      Q      32          1.065
LGA    L    17_A      L      33          0.622
LGA    V    18_A      A      34          0.747
LGA    I    19_A      L      35          0.358
LGA    Q    20_A      A      36          0.479
LGA    Q    21_A      Y      37          1.320
LGA    R    22_A      R      38          2.204
LGA    G    23_A      V      39          2.490
LGA    V    24_A      -       -           -
LGA    R    25_A      -       -           -
LGA    V    26_A      -       -           -
LGA    Y    27_A      -       -           -
LGA    D    28_A      -       -           -
LGA    G    29_A      -       -           -
LGA    E    30_A      -       -           -
LGA    E    31_A      -       -           -
LGA    K    32_A      -       -           -
LGA    F    35_A      -       -           -
LGA    D    36_A      -       -           -
LGA    A    37_A      I      40           #
LGA    -       -      R      41           -
LGA    G    38_A      D      42          1.957
LGA    T    39_A      M      43          1.648
LGA    L    40_A      F      44          0.536
LGA    L    41_A      V      45          0.444
LGA    L    42_A      F      46          0.917
LGA    S    43_A      T      47          0.715
LGA    T    44_A      N      48          1.059
LGA    H    45_A      K      49          1.006
LGA    R    46_A      R      50          1.417
LGA    L    47_A      L      51          0.896
LGA    I    48_A      I      52          0.167
LGA    W    49_A      L      53          0.775
LGA    R    50_A      I      54          1.106
LGA    D    51_A      D      55          1.700
LGA    Q    52_A      K      56          3.673
LGA    K    53_A      Q      57          3.110
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    -       -      T      60           -
LGA    N    54_A      G      61          3.850
LGA    N    55_A      K      62          1.988
LGA    E    56_A      K      63          3.005
LGA    C    57_A      V      64          2.137
LGA    C    58_A      S      65          3.662
LGA    M    59_A      Y      66          2.155
LGA    A    60_A      H      67          1.407
LGA    I    61_A      S      68          0.775
LGA    P    62_A      V      69          1.605
LGA    L    63_A      P      70          1.546
LGA    S    64_A      Y      71          3.980
LGA    -       -      K      72           -
LGA    Q    65_A      A      73          0.860
LGA    I    66_A      I      74          0.880
LGA    V    67_A      T      75          0.723
LGA    F    68_A      H      76          1.438
LGA    I    69_A      F      77          1.811
LGA    E    70_A      E      78          1.920
LGA    E    71_A      V      79          0.106
LGA    Q    72_A      E      80          2.129
LGA    A    73_A      T      81          2.975
LGA    -       -      A      82           -
LGA    -       -      G      83           -
LGA    -       -      T      84           -
LGA    -       -      F      85           -
LGA    -       -      D      86           -
LGA    -       -      M      87           -
LGA    -       -      D      88           -
LGA    -       -      A      89           -
LGA    K    81_A      E      90          1.672
LGA    I    82_A      L      91          1.126
LGA    V    83_A      K      92          1.077
LGA    V    84_A      L      93          0.345
LGA    H    85_A      W      94          0.819
LGA    L    86_A      I      95          0.925
LGA    H    87_A      S      96          1.217
LGA    S   101_A      G      97           -
LGA    K   102_A      Q      98           #
LGA    N   103_A      K      99          3.201
LGA    S   104_A      D     100          3.265
LGA    Y   105_A      P     101          1.212
LGA    I   106_A      L     102          1.200
LGA    R   107_A      V     103          1.102
LGA    L   108_A      K     104          1.060
LGA    S   109_A      E     105          0.857
LGA    F   110_A      L     106          2.496
LGA    K   111_A      K     107          2.490
LGA    E   112_A      K     108          4.081
LGA    H   113_A      G     109          1.567
LGA    G   114_A      T     110          0.488
LGA    Q   115_A      D     111          3.795
LGA    I   116_A      V     112          1.775
LGA    -       -      V     113           -
LGA    E   117_A      G     114          1.797
LGA    F   118_A      I     115          1.188
LGA    Y   119_A      Q     116          1.500
LGA    R   120_A      K     117          1.386
LGA    R   121_A      T     118          1.040
LGA    L   122_A      I     119          1.743
LGA    S   123_A      A     120          1.739
LGA    E   124_A      N     121          1.047
LGA    E   125_A      F     122          1.253
LGA    M   126_A      S     123          1.629
LGA    T   127_A      L     124          1.816
LGA    Q   128_A      -       -           -
LGA    R   129_A      -       -           -
LGA    R   130_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99  116    5.0     82    1.86    13.41     57.606     4.193

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.420297 * X  +  -0.399964 * Y  +  -0.814481 * Z  +  42.314400
  Y_new =   0.906951 * X  +   0.157346 * Y  +   0.390747 * Z  +  13.947909
  Z_new =  -0.028130 * X  +  -0.902923 * Y  +   0.428880 * Z  + -14.390364 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.127356    2.014237  [ DEG:   -64.5927    115.4073 ]
  Theta =   0.028133    3.113459  [ DEG:     1.6119    178.3881 ]
  Phi   =   1.136841   -2.004752  [ DEG:    65.1362   -114.8638 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dx5_A                                        
REMARK     2: T0446.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dx5_A.T0446.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99  116   5.0   82   1.86   13.41  57.606
REMARK  ---------------------------------------------------------- 
MOLECULE 2dx5_A
HEADER    PROTEIN TRANSPORT/SIGNALING PROTEIN     24-AUG-06   2DX5              
TITLE     THE COMPLEX STRUCTURE BETWEEN THE MOUSE EAP45-GLUE DOMAIN             
TITLE    2 AND UBIQUITIN                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: VACUOLAR PROTEIN SORTING PROTEIN 36;                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: GLUE DOMAIN;                                               
COMPND   5 SYNONYM: EAP45-GLUE;                                                 
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: UBIQUITIN;                                                 
COMPND   9 CHAIN: B                                                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: ROSETTA GAMI;                              
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PGEX4T1;                                  
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: BOS TAURUS;                                     
SOURCE  11 ORGANISM_COMMON: BOVINE                                              
KEYWDS    UBIQUITIN, PROTEIN-PROTEIN COMPLEX                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.HIRANO,N.SUZUKI,T.SLAGSVOLD,M.KAWASAKI,D.TRAMBAIOLO,                
AUTHOR   2 R.KATO,H.STENMARK,S.WAKATSUKI                                        
REVDAT   2   24-OCT-06 2DX5    1       JRNL                                     
REVDAT   1   10-OCT-06 2DX5    0                                                
JRNL        AUTH   S.HIRANO,N.SUZUKI,T.SLAGSVOLD,M.KAWASAKI,                    
JRNL        AUTH 2 D.TRAMBAIOLO,R.KATO,H.STENMARK,S.WAKATSUKI                   
JRNL        TITL   STRUCTURAL BASIS OF UBIQUITIN RECOGNITION BY                 
JRNL        TITL 2 MAMMALIAN EAP45 GLUE DOMAIN.                                 
JRNL        REF    NAT.STRUCT.MOL.BIOL.          V.  13  1031 2006              
JRNL        REFN                US ISSN 1545-9993                               
REMARK   2 RESOLUTION. 3.35 ANGSTROMS.                                          
DBREF  2DX5 A    1   139  UNP    Q91XD6   VPS36_MOUSE      1    139             
DBREF  2DX5 B    1    76  UNP    P62990   UBIQ_BOVIN       1     76             
SEQRES   1 A  139  MET ASP ARG PHE VAL TRP THR SER GLY LEU LEU GLU ILE          
SEQRES   2 A  139  ASN GLU THR LEU VAL ILE GLN GLN ARG GLY VAL ARG VAL          
SEQRES   3 A  139  TYR ASP GLY GLU GLU LYS ILE LYS PHE ASP ALA GLY THR          
SEQRES   4 A  139  LEU LEU LEU SER THR HIS ARG LEU ILE TRP ARG ASP GLN          
SEQRES   5 A  139  LYS ASN ASN GLU CYS CYS MET ALA ILE PRO LEU SER GLN          
SEQRES   6 A  139  ILE VAL PHE ILE GLU GLU GLN ALA ALA GLY ILE GLY LYS          
SEQRES   7 A  139  SER ALA LYS ILE VAL VAL HIS LEU HIS PRO ALA PRO SER          
SEQRES   8 A  139  ASN LYS GLU PRO GLY PRO PHE GLN SER SER LYS ASN SER          
SEQRES   9 A  139  TYR ILE ARG LEU SER PHE LYS GLU HIS GLY GLN ILE GLU          
SEQRES  10 A  139  PHE TYR ARG ARG LEU SER GLU GLU MET THR GLN ARG ARG          
SEQRES  11 A  139  TRP GLU THR VAL PRO VAL SER GLN SER                          
SEQRES   1 B   76  MET GLN ILE PHE VAL LYS THR LEU THR GLY LYS THR ILE          
SEQRES   2 B   76  THR LEU GLU VAL GLU PRO SER ASP THR ILE GLU ASN VAL          
SEQRES   3 B   76  LYS ALA LYS ILE GLN ASP LYS GLU GLY ILE PRO PRO ASP          
SEQRES   4 B   76  GLN GLN ARG LEU ILE PHE ALA GLY LYS GLN LEU GLU ASP          
SEQRES   5 B   76  GLY ARG THR LEU SER ASP TYR ASN ILE GLN LYS GLU SER          
SEQRES   6 B   76  THR LEU HIS LEU VAL LEU ARG LEU ARG GLY GLY                  
CRYST1   87.820   87.820   49.708  90.00  90.00  90.00 P 42 21 2     8          
ATOM      1  N   LEU A  10      51.032 -11.749  25.915  1.00 17.39           N  
ATOM      2  CA  LEU A  10      51.230 -10.283  25.966  1.00 17.27           C  
ATOM      3  C   LEU A  10      50.525  -9.613  24.788  1.00 18.17           C  
ATOM      4  O   LEU A  10      51.178  -9.190  23.830  1.00 19.11           O  
ATOM      5  CB  LEU A  10      52.729  -9.985  25.937  1.00 18.03           C  
ATOM      6  CG  LEU A  10      53.478 -10.254  27.253  1.00 19.33           C  
ATOM      7  CD1 LEU A  10      54.990 -10.267  27.014  1.00 19.08           C  
ATOM      8  CD2 LEU A  10      53.092  -9.182  28.293  1.00 19.49           C  
ATOM      9  N   LEU A  11      49.190  -9.542  24.843  1.00 18.10           N  
ATOM     10  CA  LEU A  11      48.418  -8.903  23.769  1.00 17.52           C  
ATOM     11  C   LEU A  11      47.606  -7.669  24.192  1.00 17.73           C  
ATOM     12  O   LEU A  11      47.033  -7.621  25.293  1.00 17.87           O  
ATOM     13  CB  LEU A  11      47.481  -9.907  23.086  1.00 17.37           C  
ATOM     14  CG  LEU A  11      48.141 -10.934  22.154  1.00 17.26           C  
ATOM     15  CD1 LEU A  11      48.764 -12.051  22.979  1.00 19.00           C  
ATOM     16  CD2 LEU A  11      47.103 -11.519  21.201  1.00 17.17           C  
ATOM     17  N   GLU A  12      47.571  -6.676  23.296  1.00 17.53           N  
ATOM     18  CA  GLU A  12      46.851  -5.411  23.506  1.00 16.43           C  
ATOM     19  C   GLU A  12      45.364  -5.536  23.218  1.00 16.15           C  
ATOM     20  O   GLU A  12      44.881  -6.557  22.721  1.00 16.16           O  
ATOM     21  CB  GLU A  12      47.374  -4.312  22.584  1.00 17.03           C  
ATOM     22  CG  GLU A  12      48.844  -4.150  22.565  1.00 17.96           C  
ATOM     23  CD  GLU A  12      49.360  -3.775  23.900  1.00 19.00           C  
ATOM     24  OE1 GLU A  12      48.587  -3.155  24.665  1.00 18.82           O  
ATOM     25  OE2 GLU A  12      50.537  -4.094  24.171  1.00 21.43           O  
ATOM     26  N   ILE A  13      44.648  -4.459  23.511  1.00 15.30           N  
ATOM     27  CA  ILE A  13      43.218  -4.410  23.292  1.00 15.34           C  
ATOM     28  C   ILE A  13      43.015  -4.366  21.790  1.00 16.17           C  
ATOM     29  O   ILE A  13      43.854  -3.826  21.065  1.00 15.29           O  
ATOM     30  CB  ILE A  13      42.605  -3.141  23.913  1.00 15.38           C  
ATOM     31  CG1 ILE A  13      43.125  -2.948  25.354  1.00 14.03           C  
ATOM     32  CG2 ILE A  13      41.087  -3.234  23.829  1.00 15.76           C  
ATOM     33  CD1 ILE A  13      43.178  -1.488  25.820  1.00  9.93           C  
ATOM     34  N   ASN A  14      41.909  -4.936  21.329  1.00 17.87           N  
ATOM     35  CA  ASN A  14      41.593  -4.967  19.905  1.00 19.32           C  
ATOM     36  C   ASN A  14      42.599  -5.770  19.095  1.00 19.43           C  
ATOM     37  O   ASN A  14      42.516  -5.834  17.872  1.00 19.69           O  
ATOM     38  CB  ASN A  14      41.480  -3.542  19.367  1.00 20.33           C  
ATOM     39  CG  ASN A  14      40.536  -2.693  20.197  1.00 22.36           C  
ATOM     40  OD1 ASN A  14      39.422  -3.120  20.515  1.00 23.20           O  
ATOM     41  ND2 ASN A  14      40.976  -1.489  20.560  1.00 23.62           N  
ATOM     42  N   GLU A  15      43.550  -6.384  19.783  1.00 20.30           N  
ATOM     43  CA  GLU A  15      44.545  -7.224  19.126  1.00 21.93           C  
ATOM     44  C   GLU A  15      44.206  -8.664  19.475  1.00 23.17           C  
ATOM     45  O   GLU A  15      43.970  -8.979  20.640  1.00 24.21           O  
ATOM     46  CB  GLU A  15      45.961  -6.904  19.622  1.00 21.17           C  
ATOM     47  CG  GLU A  15      47.030  -7.876  19.101  1.00 18.89           C  
ATOM     48  CD  GLU A  15      48.434  -7.530  19.579  1.00 17.70           C  
ATOM     49  OE1 GLU A  15      48.565  -6.711  20.516  1.00 14.48           O  
ATOM     50  OE2 GLU A  15      49.405  -8.092  19.022  1.00 17.96           O  
ATOM     51  N   THR A  16      44.181  -9.543  18.482  1.00 23.48           N  
ATOM     52  CA  THR A  16      43.857 -10.934  18.761  1.00 23.67           C  
ATOM     53  C   THR A  16      44.847 -11.890  18.137  1.00 23.72           C  
ATOM     54  O   THR A  16      45.551 -11.532  17.192  1.00 25.14           O  
ATOM     55  CB  THR A  16      42.434 -11.280  18.291  1.00 24.28           C  
ATOM     56  OG1 THR A  16      42.255 -10.862  16.930  1.00 23.71           O  
ATOM     57  CG2 THR A  16      41.408 -10.581  19.184  1.00 25.07           C  
ATOM     58  N   LEU A  17      44.896 -13.103  18.677  1.00 22.91           N  
ATOM     59  CA  LEU A  17      45.816 -14.132  18.220  1.00 21.20           C  
ATOM     60  C   LEU A  17      45.366 -14.744  16.911  1.00 20.25           C  
ATOM     61  O   LEU A  17      44.180 -14.808  16.625  1.00 19.22           O  
ATOM     62  CB  LEU A  17      45.934 -15.202  19.298  1.00 21.51           C  
ATOM     63  CG  LEU A  17      47.113 -16.165  19.248  1.00 22.15           C  
ATOM     64  CD1 LEU A  17      47.392 -16.719  20.648  1.00 21.86           C  
ATOM     65  CD2 LEU A  17      46.805 -17.264  18.245  1.00 23.60           C  
ATOM     66  N   VAL A  18      46.338 -15.170  16.114  1.00 21.13           N  
ATOM     67  CA  VAL A  18      46.099 -15.792  14.816  1.00 22.39           C  
ATOM     68  C   VAL A  18      46.586 -17.241  14.868  1.00 22.56           C  
ATOM     69  O   VAL A  18      45.781 -18.148  14.706  1.00 22.83           O  
ATOM     70  CB  VAL A  18      46.810 -15.008  13.694  1.00 22.35           C  
ATOM     71  CG1 VAL A  18      46.753 -15.793  12.397  1.00 22.52           C  
ATOM     72  CG2 VAL A  18      46.144 -13.615  13.522  1.00 21.32           C  
ATOM     73  N   ILE A  19      47.887 -17.455  15.081  1.00 23.24           N  
ATOM     74  CA  ILE A  19      48.442 -18.811  15.239  1.00 24.63           C  
ATOM     75  C   ILE A  19      49.764 -18.789  15.986  1.00 24.97           C  
ATOM     76  O   ILE A  19      50.548 -17.852  15.857  1.00 25.45           O  
ATOM     77  CB  ILE A  19      48.720 -19.606  13.887  1.00 24.78           C  
ATOM     78  CG1 ILE A  19      49.867 -18.976  13.099  1.00 24.85           C  
ATOM     79  CG2 ILE A  19      47.456 -19.761  13.072  1.00 24.98           C  
ATOM     80  CD1 ILE A  19      49.602 -17.569  12.616  1.00 27.01           C  
ATOM     81  N   GLN A  20      50.005 -19.837  16.762  1.00 25.78           N  
ATOM     82  CA  GLN A  20      51.253 -19.981  17.499  1.00 26.54           C  
ATOM     83  C   GLN A  20      51.957 -21.197  16.908  1.00 26.16           C  
ATOM     84  O   GLN A  20      51.372 -22.277  16.823  1.00 25.63           O  
ATOM     85  CB  GLN A  20      50.975 -20.213  18.999  1.00 27.54           C  
ATOM     86  CG  GLN A  20      52.172 -20.770  19.822  1.00 27.37           C  
ATOM     87  CD  GLN A  20      52.847 -19.735  20.737  1.00 26.91           C  
ATOM     88  OE1 GLN A  20      54.074 -19.706  20.854  1.00 26.46           O  
ATOM     89  NE2 GLN A  20      52.046 -18.904  21.402  1.00 25.51           N  
ATOM     90  N   GLN A  21      53.201 -21.029  16.483  1.00 25.56           N  
ATOM     91  CA  GLN A  21      53.926 -22.166  15.947  1.00 26.21           C  
ATOM     92  C   GLN A  21      55.315 -22.159  16.566  1.00 26.37           C  
ATOM     93  O   GLN A  21      55.879 -21.089  16.797  1.00 27.28           O  
ATOM     94  CB  GLN A  21      53.997 -22.094  14.419  1.00 26.65           C  
ATOM     95  CG  GLN A  21      53.925 -23.464  13.726  1.00 27.56           C  
ATOM     96  CD  GLN A  21      55.243 -24.212  13.807  1.00 28.20           C  
ATOM     97  OE1 GLN A  21      55.286 -25.426  14.039  1.00 27.76           O  
ATOM     98  NE2 GLN A  21      56.335 -23.481  13.607  1.00 27.75           N  
ATOM     99  N   ARG A  22      55.853 -23.352  16.834  1.00 25.47           N  
ATOM    100  CA  ARG A  22      57.172 -23.511  17.457  1.00 24.78           C  
ATOM    101  C   ARG A  22      58.346 -23.900  16.533  1.00 25.48           C  
ATOM    102  O   ARG A  22      58.214 -23.987  15.310  1.00 25.82           O  
ATOM    103  CB  ARG A  22      57.059 -24.541  18.572  1.00 24.19           C  
ATOM    104  CG  ARG A  22      55.632 -24.985  18.770  1.00 23.76           C  
ATOM    105  CD  ARG A  22      55.508 -26.146  19.739  1.00 25.02           C  
ATOM    106  NE  ARG A  22      56.185 -25.890  21.004  1.00 24.70           N  
ATOM    107  CZ  ARG A  22      57.418 -26.293  21.295  1.00 25.21           C  
ATOM    108  NH1 ARG A  22      58.135 -26.987  20.416  1.00 23.06           N  
ATOM    109  NH2 ARG A  22      57.938 -25.987  22.474  1.00 27.15           N  
ATOM    110  N   GLY A  23      59.507 -24.123  17.143  1.00 25.50           N  
ATOM    111  CA  GLY A  23      60.689 -24.497  16.387  1.00 26.13           C  
ATOM    112  C   GLY A  23      61.177 -23.449  15.392  1.00 27.16           C  
ATOM    113  O   GLY A  23      61.779 -23.781  14.366  1.00 27.94           O  
ATOM    114  N   VAL A  24      60.934 -22.178  15.682  1.00 27.36           N  
ATOM    115  CA  VAL A  24      61.355 -21.122  14.783  1.00 26.57           C  
ATOM    116  C   VAL A  24      62.752 -20.597  15.095  1.00 26.85           C  
ATOM    117  O   VAL A  24      63.219 -20.622  16.243  1.00 25.32           O  
ATOM    118  CB  VAL A  24      60.355 -19.965  14.812  1.00 26.22           C  
ATOM    119  CG1 VAL A  24      60.848 -18.833  13.929  1.00 26.20           C  
ATOM    120  CG2 VAL A  24      58.986 -20.467  14.359  1.00 25.45           C  
ATOM    121  N   ARG A  25      63.411 -20.144  14.035  1.00 27.84           N  
ATOM    122  CA  ARG A  25      64.751 -19.585  14.095  1.00 28.71           C  
ATOM    123  C   ARG A  25      64.678 -18.228  13.419  1.00 27.75           C  
ATOM    124  O   ARG A  25      63.889 -18.027  12.496  1.00 27.03           O  
ATOM    125  CB  ARG A  25      65.741 -20.478  13.334  1.00 30.60           C  
ATOM    126  CG  ARG A  25      66.016 -21.834  13.988  1.00 34.02           C  
ATOM    127  CD  ARG A  25      66.903 -22.725  13.114  1.00 35.74           C  
ATOM    128  NE  ARG A  25      67.316 -23.940  13.808  1.00 36.08           N  
ATOM    129  CZ  ARG A  25      67.379 -25.133  13.230  1.00 37.17           C  
ATOM    130  NH1 ARG A  25      67.058 -25.264  11.948  1.00 37.31           N  
ATOM    131  NH2 ARG A  25      67.748 -26.197  13.931  1.00 37.95           N  
ATOM    132  N   VAL A  26      65.495 -17.295  13.884  1.00 27.34           N  
ATOM    133  CA  VAL A  26      65.514 -15.971  13.297  1.00 27.50           C  
ATOM    134  C   VAL A  26      66.925 -15.564  12.857  1.00 27.66           C  
ATOM    135  O   VAL A  26      67.767 -15.230  13.688  1.00 29.17           O  
ATOM    136  CB  VAL A  26      64.993 -14.936  14.287  1.00 26.83           C  
ATOM    137  CG1 VAL A  26      64.647 -13.651  13.549  1.00 27.49           C  
ATOM    138  CG2 VAL A  26      63.791 -15.485  15.012  1.00 27.35           C  
ATOM    139  N   TYR A  27      67.176 -15.596  11.550  1.00 26.10           N  
ATOM    140  CA  TYR A  27      68.476 -15.222  11.003  1.00 24.37           C  
ATOM    141  C   TYR A  27      68.452 -13.763  10.546  1.00 24.13           C  
ATOM    142  O   TYR A  27      67.389 -13.250  10.187  1.00 23.89           O  
ATOM    143  CB  TYR A  27      68.800 -16.096   9.797  1.00 24.67           C  
ATOM    144  CG  TYR A  27      68.717 -17.579  10.043  1.00 24.64           C  
ATOM    145  CD1 TYR A  27      69.870 -18.333  10.269  1.00 25.72           C  
ATOM    146  CD2 TYR A  27      67.490 -18.240  10.019  1.00 24.50           C  
ATOM    147  CE1 TYR A  27      69.802 -19.714  10.469  1.00 25.35           C  
ATOM    148  CE2 TYR A  27      67.410 -19.613  10.220  1.00 24.35           C  
ATOM    149  CZ  TYR A  27      68.566 -20.346  10.441  1.00 24.85           C  
ATOM    150  OH  TYR A  27      68.482 -21.702  10.661  1.00 23.94           O  
ATOM    151  N   ASP A  28      69.615 -13.099  10.569  1.00 23.75           N  
ATOM    152  CA  ASP A  28      69.729 -11.708  10.112  1.00 23.87           C  
ATOM    153  C   ASP A  28      69.872 -11.812   8.615  1.00 25.10           C  
ATOM    154  O   ASP A  28      68.879 -11.889   7.908  1.00 25.41           O  
ATOM    155  CB  ASP A  28      70.968 -11.010  10.673  1.00 23.25           C  
ATOM    156  CG  ASP A  28      70.804 -10.582  12.120  1.00 23.72           C  
ATOM    157  OD1 ASP A  28      69.753  -9.993  12.462  1.00 23.88           O  
ATOM    158  OD2 ASP A  28      71.741 -10.823  12.913  1.00 24.42           O  
ATOM    159  N   GLY A  29      71.107 -11.814   8.129  1.00 26.90           N  
ATOM    160  CA  GLY A  29      71.325 -11.972   6.701  1.00 29.97           C  
ATOM    161  C   GLY A  29      71.431 -13.466   6.568  1.00 31.52           C  
ATOM    162  O   GLY A  29      70.455 -14.179   6.722  1.00 31.24           O  
ATOM    163  N   GLU A  30      72.624 -13.949   6.298  1.00 34.90           N  
ATOM    164  CA  GLU A  30      72.829 -15.384   6.248  1.00 38.10           C  
ATOM    165  C   GLU A  30      73.658 -15.607   7.508  1.00 38.98           C  
ATOM    166  O   GLU A  30      74.566 -14.825   7.796  1.00 40.31           O  
ATOM    167  CB  GLU A  30      73.602 -15.795   4.991  1.00 40.13           C  
ATOM    168  CG  GLU A  30      72.748 -15.897   3.704  1.00 41.65           C  
ATOM    169  CD  GLU A  30      71.691 -17.006   3.768  1.00 41.27           C  
ATOM    170  OE1 GLU A  30      70.936 -17.180   2.778  1.00 39.99           O  
ATOM    171  OE2 GLU A  30      71.619 -17.702   4.811  1.00 40.08           O  
ATOM    172  N   GLU A  31      73.341 -16.644   8.272  1.00 38.68           N  
ATOM    173  CA  GLU A  31      74.070 -16.876   9.502  1.00 38.57           C  
ATOM    174  C   GLU A  31      74.558 -18.282   9.804  1.00 38.59           C  
ATOM    175  O   GLU A  31      73.845 -19.266   9.630  1.00 36.41           O  
ATOM    176  CB  GLU A  31      73.230 -16.370  10.672  1.00 39.70           C  
ATOM    177  CG  GLU A  31      73.255 -14.865  10.792  1.00 43.02           C  
ATOM    178  CD  GLU A  31      74.651 -14.323  11.110  1.00 44.79           C  
ATOM    179  OE1 GLU A  31      75.135 -14.528  12.252  1.00 45.94           O  
ATOM    180  OE2 GLU A  31      75.263 -13.694  10.217  1.00 44.76           O  
ATOM    181  N   LYS A  32      75.790 -18.359  10.283  1.00 38.93           N  
ATOM    182  CA  LYS A  32      76.365 -19.632  10.654  1.00 41.21           C  
ATOM    183  C   LYS A  32      75.624 -20.045  11.929  1.00 41.62           C  
ATOM    184  O   LYS A  32      74.614 -19.392  12.257  1.00 41.02           O  
ATOM    185  CB  LYS A  32      77.872 -19.481  10.929  1.00 40.84           C  
ATOM    186  CG  LYS A  32      78.650 -18.751   9.821  1.00 43.14           C  
ATOM    187  CD  LYS A  32      80.186 -18.779  10.023  1.00 42.10           C  
ATOM    188  CE  LYS A  32      80.816 -20.114   9.593  1.00 40.11           C  
ATOM    189  NZ  LYS A  32      82.300 -20.047   9.649  1.00 38.48           N  
ATOM    190  N   PHE A  35      71.542 -17.657  14.758  1.00 17.21           N  
ATOM    191  CA  PHE A  35      70.063 -17.703  14.912  1.00 17.96           C  
ATOM    192  C   PHE A  35      69.581 -17.768  16.363  1.00 17.96           C  
ATOM    193  O   PHE A  35      70.369 -17.732  17.298  1.00 16.38           O  
ATOM    194  CB  PHE A  35      69.499 -18.900  14.153  1.00 18.38           C  
ATOM    195  CG  PHE A  35      69.846 -20.233  14.773  1.00 19.86           C  
ATOM    196  CD1 PHE A  35      71.164 -20.681  14.824  1.00 20.89           C  
ATOM    197  CD2 PHE A  35      68.843 -21.068  15.264  1.00 20.16           C  
ATOM    198  CE1 PHE A  35      71.470 -21.939  15.368  1.00 19.56           C  
ATOM    199  CE2 PHE A  35      69.147 -22.326  15.806  1.00 18.56           C  
ATOM    200  CZ  PHE A  35      70.455 -22.756  15.847  1.00 18.39           C  
ATOM    201  N   ASP A  36      68.268 -17.883  16.527  1.00 20.00           N  
ATOM    202  CA  ASP A  36      67.631 -17.944  17.839  1.00 22.80           C  
ATOM    203  C   ASP A  36      66.472 -18.937  17.772  1.00 23.17           C  
ATOM    204  O   ASP A  36      65.599 -18.818  16.907  1.00 23.73           O  
ATOM    205  CB  ASP A  36      67.087 -16.564  18.211  1.00 25.60           C  
ATOM    206  CG  ASP A  36      68.175 -15.503  18.282  1.00 28.18           C  
ATOM    207  OD1 ASP A  36      68.908 -15.467  19.294  1.00 29.99           O  
ATOM    208  OD2 ASP A  36      68.301 -14.705  17.323  1.00 30.18           O  
ATOM    209  N   ALA A  37      66.458 -19.901  18.689  1.00 22.53           N  
ATOM    210  CA  ALA A  37      65.410 -20.915  18.716  1.00 21.55           C  
ATOM    211  C   ALA A  37      64.270 -20.482  19.635  1.00 20.83           C  
ATOM    212  O   ALA A  37      64.475 -19.674  20.542  1.00 21.68           O  
ATOM    213  CB  ALA A  37      66.002 -22.248  19.178  1.00 21.69           C  
ATOM    214  N   GLY A  38      63.073 -21.007  19.400  1.00 18.73           N  
ATOM    215  CA  GLY A  38      61.949 -20.628  20.242  1.00 17.70           C  
ATOM    216  C   GLY A  38      60.602 -20.784  19.564  1.00 16.36           C  
ATOM    217  O   GLY A  38      60.391 -21.737  18.815  1.00 16.82           O  
ATOM    218  N   THR A  39      59.685 -19.856  19.815  1.00 14.47           N  
ATOM    219  CA  THR A  39      58.381 -19.934  19.178  1.00 13.71           C  
ATOM    220  C   THR A  39      57.827 -18.589  18.691  1.00 13.92           C  
ATOM    221  O   THR A  39      57.538 -17.696  19.483  1.00 14.24           O  
ATOM    222  CB  THR A  39      57.360 -20.605  20.108  1.00 12.89           C  
ATOM    223  OG1 THR A  39      56.031 -20.356  19.631  1.00 11.80           O  
ATOM    224  CG2 THR A  39      57.511 -20.087  21.516  1.00 13.96           C  
ATOM    225  N   LEU A  40      57.692 -18.455  17.376  1.00 13.74           N  
ATOM    226  CA  LEU A  40      57.163 -17.239  16.768  1.00 13.24           C  
ATOM    227  C   LEU A  40      55.640 -17.277  16.904  1.00 13.67           C  
ATOM    228  O   LEU A  40      55.021 -18.310  16.619  1.00 14.04           O  
ATOM    229  CB  LEU A  40      57.558 -17.199  15.280  1.00 12.86           C  
ATOM    230  CG  LEU A  40      57.602 -15.918  14.414  1.00 12.81           C  
ATOM    231  CD1 LEU A  40      56.217 -15.532  13.985  1.00 12.86           C  
ATOM    232  CD2 LEU A  40      58.265 -14.760  15.162  1.00 13.20           C  
ATOM    233  N   LEU A  41      55.051 -16.160  17.346  1.00 12.63           N  
ATOM    234  CA  LEU A  41      53.596 -16.017  17.504  1.00 10.33           C  
ATOM    235  C   LEU A  41      53.079 -14.813  16.712  1.00  8.55           C  
ATOM    236  O   LEU A  41      53.405 -13.676  17.045  1.00  7.32           O  
ATOM    237  CB  LEU A  41      53.239 -15.817  18.978  1.00 12.47           C  
ATOM    238  CG  LEU A  41      51.816 -15.298  19.228  1.00 13.98           C  
ATOM    239  CD1 LEU A  41      50.812 -16.395  18.828  1.00 14.88           C  
ATOM    240  CD2 LEU A  41      51.658 -14.863  20.700  1.00 13.14           C  
ATOM    241  N   LEU A  42      52.272 -15.059  15.682  1.00  7.96           N  
ATOM    242  CA  LEU A  42      51.699 -13.981  14.857  1.00  8.21           C  
ATOM    243  C   LEU A  42      50.394 -13.491  15.453  1.00  7.37           C  
ATOM    244  O   LEU A  42      49.722 -14.235  16.150  1.00  8.23           O  
ATOM    245  CB  LEU A  42      51.410 -14.482  13.441  1.00  9.01           C  
ATOM    246  CG  LEU A  42      50.599 -13.546  12.539  1.00  8.80           C  
ATOM    247  CD1 LEU A  42      51.510 -12.457  12.008  1.00  8.70           C  
ATOM    248  CD2 LEU A  42      49.992 -14.336  11.380  1.00  7.88           C  
ATOM    249  N   SER A  43      50.020 -12.255  15.172  1.00  6.65           N  
ATOM    250  CA  SER A  43      48.772 -11.741  15.712  1.00  7.71           C  
ATOM    251  C   SER A  43      48.219 -10.787  14.692  1.00  8.25           C  
ATOM    252  O   SER A  43      48.855 -10.544  13.672  1.00  8.30           O  
ATOM    253  CB  SER A  43      48.983 -11.017  17.066  1.00  7.42           C  
ATOM    254  OG  SER A  43      49.493  -9.694  16.942  1.00  6.97           O  
ATOM    255  N   THR A  44      47.035 -10.258  14.975  1.00  8.51           N  
ATOM    256  CA  THR A  44      46.365  -9.308  14.099  1.00  8.42           C  
ATOM    257  C   THR A  44      47.121  -8.002  13.896  1.00  8.91           C  
ATOM    258  O   THR A  44      46.933  -7.326  12.888  1.00  8.60           O  
ATOM    259  CB  THR A  44      45.003  -8.945  14.666  1.00  7.95           C  
ATOM    260  OG1 THR A  44      45.108  -8.788  16.093  1.00  7.12           O  
ATOM    261  CG2 THR A  44      43.989 -10.008  14.314  1.00  8.80           C  
ATOM    262  N   HIS A  45      47.962  -7.642  14.857  1.00  9.19           N  
ATOM    263  CA  HIS A  45      48.690  -6.390  14.780  1.00  9.90           C  
ATOM    264  C   HIS A  45      50.221  -6.489  14.928  1.00 10.62           C  
ATOM    265  O   HIS A  45      50.959  -5.664  14.370  1.00 10.15           O  
ATOM    266  CB  HIS A  45      48.127  -5.432  15.841  1.00  9.56           C  
ATOM    267  CG  HIS A  45      46.693  -5.055  15.626  1.00  9.10           C  
ATOM    268  ND1 HIS A  45      45.696  -5.987  15.439  1.00  8.23           N  
ATOM    269  CD2 HIS A  45      46.081  -3.846  15.622  1.00 10.73           C  
ATOM    270  CE1 HIS A  45      44.533  -5.369  15.332  1.00  9.65           C  
ATOM    271  NE2 HIS A  45      44.737  -4.069  15.441  1.00 10.25           N  
ATOM    272  N   ARG A  46      50.696  -7.485  15.671  1.00 11.66           N  
ATOM    273  CA  ARG A  46      52.135  -7.639  15.906  1.00 13.15           C  
ATOM    274  C   ARG A  46      52.682  -8.984  15.482  1.00 13.52           C  
ATOM    275  O   ARG A  46      51.946  -9.952  15.320  1.00 14.41           O  
ATOM    276  CB  ARG A  46      52.457  -7.464  17.402  1.00 14.02           C  
ATOM    277  CG  ARG A  46      52.401  -6.043  17.933  1.00 15.44           C  
ATOM    278  CD  ARG A  46      51.888  -6.034  19.368  1.00 17.24           C  
ATOM    279  NE  ARG A  46      52.829  -6.564  20.358  1.00 18.84           N  
ATOM    280  CZ  ARG A  46      52.457  -7.124  21.510  1.00 20.31           C  
ATOM    281  NH1 ARG A  46      51.164  -7.239  21.810  1.00 20.10           N  
ATOM    282  NH2 ARG A  46      53.376  -7.542  22.379  1.00 20.37           N  
ATOM    283  N   LEU A  47      53.993  -9.028  15.303  1.00 13.98           N  
ATOM    284  CA  LEU A  47      54.684 -10.265  14.971  1.00 14.81           C  
ATOM    285  C   LEU A  47      55.436 -10.582  16.250  1.00 15.25           C  
ATOM    286  O   LEU A  47      56.600 -10.238  16.374  1.00 15.63           O  
ATOM    287  CB  LEU A  47      55.685 -10.049  13.838  1.00 15.56           C  
ATOM    288  CG  LEU A  47      56.678 -11.205  13.621  1.00 16.24           C  
ATOM    289  CD1 LEU A  47      55.977 -12.405  12.974  1.00 16.68           C  
ATOM    290  CD2 LEU A  47      57.837 -10.718  12.751  1.00 15.98           C  
ATOM    291  N   ILE A  48      54.761 -11.217  17.204  1.00 15.56           N  
ATOM    292  CA  ILE A  48      55.362 -11.543  18.497  1.00 15.60           C  
ATOM    293  C   ILE A  48      56.421 -12.658  18.451  1.00 16.30           C  
ATOM    294  O   ILE A  48      56.306 -13.614  17.686  1.00 15.91           O  
ATOM    295  CB  ILE A  48      54.259 -11.921  19.511  1.00 14.93           C  
ATOM    296  CG1 ILE A  48      53.152 -10.853  19.475  1.00 14.12           C  
ATOM    297  CG2 ILE A  48      54.860 -12.038  20.915  1.00 13.23           C  
ATOM    298  CD1 ILE A  48      51.814 -11.276  20.058  1.00 13.06           C  
ATOM    299  N   TRP A  49      57.451 -12.534  19.285  1.00 16.92           N  
ATOM    300  CA  TRP A  49      58.516 -13.525  19.318  1.00 17.68           C  
ATOM    301  C   TRP A  49      58.953 -13.832  20.754  1.00 18.13           C  
ATOM    302  O   TRP A  49      59.602 -13.013  21.388  1.00 18.96           O  
ATOM    303  CB  TRP A  49      59.709 -13.015  18.482  1.00 17.37           C  
ATOM    304  CG  TRP A  49      60.982 -13.833  18.626  1.00 17.51           C  
ATOM    305  CD1 TRP A  49      62.147 -13.432  19.219  1.00 17.20           C  
ATOM    306  CD2 TRP A  49      61.169 -15.213  18.277  1.00 17.25           C  
ATOM    307  NE1 TRP A  49      63.047 -14.469  19.262  1.00 16.55           N  
ATOM    308  CE2 TRP A  49      62.480 -15.572  18.676  1.00 17.14           C  
ATOM    309  CE3 TRP A  49      60.372 -16.177  17.637  1.00 16.88           C  
ATOM    310  CZ2 TRP A  49      62.996 -16.862  18.503  1.00 18.09           C  
ATOM    311  CZ3 TRP A  49      60.884 -17.460  17.458  1.00 17.04           C  
ATOM    312  CH2 TRP A  49      62.193 -17.785  17.876  1.00 18.55           C  
ATOM    313  N   ARG A  50      58.582 -15.001  21.272  1.00 18.08           N  
ATOM    314  CA  ARG A  50      58.984 -15.367  22.625  1.00 19.06           C  
ATOM    315  C   ARG A  50      60.104 -16.357  22.485  1.00 19.42           C  
ATOM    316  O   ARG A  50      59.945 -17.378  21.821  1.00 18.63           O  
ATOM    317  CB  ARG A  50      57.823 -15.980  23.442  1.00 20.46           C  
ATOM    318  CG  ARG A  50      57.003 -17.088  22.771  1.00 23.20           C  
ATOM    319  CD  ARG A  50      55.906 -17.685  23.698  1.00 23.65           C  
ATOM    320  NE  ARG A  50      54.933 -16.699  24.182  1.00 25.54           N  
ATOM    321  CZ  ARG A  50      53.783 -17.017  24.779  1.00 26.17           C  
ATOM    322  NH1 ARG A  50      53.474 -18.291  24.945  1.00 26.91           N  
ATOM    323  NH2 ARG A  50      52.956 -16.076  25.236  1.00 26.00           N  
ATOM    324  N   ASP A  51      61.231 -16.039  23.122  1.00 20.90           N  
ATOM    325  CA  ASP A  51      62.455 -16.841  23.080  1.00 21.67           C  
ATOM    326  C   ASP A  51      62.526 -18.089  23.959  1.00 22.95           C  
ATOM    327  O   ASP A  51      61.688 -18.320  24.838  1.00 22.73           O  
ATOM    328  CB  ASP A  51      63.629 -15.942  23.429  1.00 20.45           C  
ATOM    329  CG  ASP A  51      64.795 -16.140  22.511  1.00 19.72           C  
ATOM    330  OD1 ASP A  51      64.646 -15.909  21.289  1.00 18.64           O  
ATOM    331  OD2 ASP A  51      65.864 -16.524  23.024  1.00 20.11           O  
ATOM    332  N   GLN A  52      63.561 -18.887  23.718  1.00 25.48           N  
ATOM    333  CA  GLN A  52      63.777 -20.110  24.480  1.00 28.76           C  
ATOM    334  C   GLN A  52      64.246 -19.760  25.895  1.00 29.54           C  
ATOM    335  O   GLN A  52      63.830 -20.395  26.863  1.00 29.88           O  
ATOM    336  CB  GLN A  52      64.812 -21.016  23.781  1.00 30.60           C  
ATOM    337  CG  GLN A  52      66.285 -20.537  23.859  1.00 33.29           C  
ATOM    338  CD  GLN A  52      67.322 -21.601  23.417  1.00 34.50           C  
ATOM    339  OE1 GLN A  52      67.353 -22.724  23.938  1.00 35.43           O  
ATOM    340  NE2 GLN A  52      68.177 -21.234  22.464  1.00 34.49           N  
ATOM    341  N   LYS A  53      65.110 -18.749  26.004  1.00 30.33           N  
ATOM    342  CA  LYS A  53      65.625 -18.294  27.297  1.00 30.85           C  
ATOM    343  C   LYS A  53      64.667 -17.271  27.903  1.00 32.24           C  
ATOM    344  O   LYS A  53      64.766 -16.077  27.618  1.00 32.39           O  
ATOM    345  CB  LYS A  53      67.016 -17.667  27.124  1.00 30.09           C  
ATOM    346  CG  LYS A  53      68.091 -18.659  26.683  1.00 29.75           C  
ATOM    347  CD  LYS A  53      69.337 -17.992  26.089  1.00 29.28           C  
ATOM    348  CE  LYS A  53      70.280 -19.041  25.464  1.00 29.11           C  
ATOM    349  NZ  LYS A  53      71.360 -18.472  24.585  1.00 27.40           N  
ATOM    350  N   ASN A  54      63.745 -17.743  28.741  1.00 33.84           N  
ATOM    351  CA  ASN A  54      62.746 -16.877  29.380  1.00 35.42           C  
ATOM    352  C   ASN A  54      63.216 -15.577  30.074  1.00 37.21           C  
ATOM    353  O   ASN A  54      62.458 -14.606  30.152  1.00 36.71           O  
ATOM    354  CB  ASN A  54      61.874 -17.705  30.359  1.00 34.37           C  
ATOM    355  CG  ASN A  54      62.692 -18.539  31.361  1.00 33.11           C  
ATOM    356  OD1 ASN A  54      63.602 -18.035  32.029  1.00 33.03           O  
ATOM    357  ND2 ASN A  54      62.339 -19.818  31.483  1.00 31.15           N  
ATOM    358  N   ASN A  55      64.453 -15.550  30.568  1.00 40.22           N  
ATOM    359  CA  ASN A  55      64.998 -14.372  31.259  1.00 42.69           C  
ATOM    360  C   ASN A  55      64.687 -13.049  30.553  1.00 43.23           C  
ATOM    361  O   ASN A  55      64.355 -12.051  31.198  1.00 43.98           O  
ATOM    362  CB  ASN A  55      66.512 -14.518  31.422  1.00 43.84           C  
ATOM    363  CG  ASN A  55      66.926 -15.955  31.712  1.00 46.06           C  
ATOM    364  OD1 ASN A  55      66.225 -16.680  32.424  1.00 47.35           O  
ATOM    365  ND2 ASN A  55      68.072 -16.371  31.170  1.00 46.93           N  
ATOM    366  N   GLU A  56      64.811 -13.042  29.231  1.00 42.93           N  
ATOM    367  CA  GLU A  56      64.525 -11.847  28.450  1.00 42.35           C  
ATOM    368  C   GLU A  56      63.481 -12.227  27.424  1.00 40.78           C  
ATOM    369  O   GLU A  56      63.446 -11.692  26.323  1.00 39.93           O  
ATOM    370  CB  GLU A  56      65.808 -11.329  27.773  1.00 44.05           C  
ATOM    371  CG  GLU A  56      66.752 -12.412  27.218  1.00 45.47           C  
ATOM    372  CD  GLU A  56      66.316 -12.973  25.871  1.00 46.08           C  
ATOM    373  OE1 GLU A  56      66.200 -14.211  25.746  1.00 46.92           O  
ATOM    374  OE2 GLU A  56      66.102 -12.181  24.932  1.00 46.83           O  
ATOM    375  N   CYS A  57      62.620 -13.158  27.809  1.00 40.09           N  
ATOM    376  CA  CYS A  57      61.569 -13.658  26.933  1.00 40.69           C  
ATOM    377  C   CYS A  57      60.613 -12.613  26.379  1.00 38.67           C  
ATOM    378  O   CYS A  57      60.315 -11.604  27.031  1.00 38.49           O  
ATOM    379  CB  CYS A  57      60.754 -14.714  27.663  1.00 43.65           C  
ATOM    380  SG  CYS A  57      59.595 -15.643  26.618  1.00 50.06           S  
ATOM    381  N   CYS A  58      60.116 -12.888  25.175  1.00 36.35           N  
ATOM    382  CA  CYS A  58      59.184 -12.006  24.487  1.00 34.10           C  
ATOM    383  C   CYS A  58      59.786 -10.659  24.036  1.00 34.71           C  
ATOM    384  O   CYS A  58      59.792  -9.675  24.775  1.00 34.11           O  
ATOM    385  CB  CYS A  58      57.961 -11.815  25.377  1.00 32.06           C  
ATOM    386  SG  CYS A  58      57.516 -13.374  26.168  1.00 24.60           S  
ATOM    387  N   MET A  59      60.313 -10.645  22.811  1.00 35.57           N  
ATOM    388  CA  MET A  59      60.922  -9.444  22.228  1.00 36.54           C  
ATOM    389  C   MET A  59      60.180  -8.715  21.089  1.00 37.37           C  
ATOM    390  O   MET A  59      59.234  -7.951  21.318  1.00 37.30           O  
ATOM    391  CB  MET A  59      62.357  -9.758  21.762  1.00 36.27           C  
ATOM    392  CG  MET A  59      63.433  -9.309  22.744  1.00 35.44           C  
ATOM    393  SD  MET A  59      63.684  -7.493  22.724  1.00 32.08           S  
ATOM    394  CE  MET A  59      65.065  -7.300  21.654  1.00 32.75           C  
ATOM    395  N   ALA A  60      60.653  -8.951  19.865  1.00 38.15           N  
ATOM    396  CA  ALA A  60      60.135  -8.309  18.655  1.00 39.09           C  
ATOM    397  C   ALA A  60      58.603  -8.248  18.529  1.00 39.22           C  
ATOM    398  O   ALA A  60      57.882  -9.115  19.061  1.00 39.25           O  
ATOM    399  CB  ALA A  60      60.774  -8.982  17.390  1.00 37.65           C  
ATOM    400  N   ILE A  61      58.127  -7.186  17.867  1.00 38.72           N  
ATOM    401  CA  ILE A  61      56.704  -6.985  17.618  1.00 38.71           C  
ATOM    402  C   ILE A  61      56.414  -5.942  16.508  1.00 37.36           C  
ATOM    403  O   ILE A  61      55.647  -4.992  16.699  1.00 37.71           O  
ATOM    404  CB  ILE A  61      55.943  -6.567  18.928  1.00 40.61           C  
ATOM    405  CG1 ILE A  61      56.684  -5.417  19.642  1.00 41.33           C  
ATOM    406  CG2 ILE A  61      55.760  -7.781  19.847  1.00 40.11           C  
ATOM    407  CD1 ILE A  61      55.852  -4.704  20.722  1.00 39.70           C  
ATOM    408  N   PRO A  62      56.996  -6.122  15.322  1.00 36.03           N  
ATOM    409  CA  PRO A  62      56.769  -5.171  14.223  1.00 35.49           C  
ATOM    410  C   PRO A  62      55.295  -5.042  13.766  1.00 35.66           C  
ATOM    411  O   PRO A  62      54.493  -4.328  14.382  1.00 35.57           O  
ATOM    412  CB  PRO A  62      57.676  -5.712  13.118  1.00 35.11           C  
ATOM    413  CG  PRO A  62      58.758  -6.480  13.886  1.00 34.49           C  
ATOM    414  CD  PRO A  62      57.961  -7.170  14.946  1.00 35.12           C  
ATOM    415  N   LEU A  63      54.979  -5.740  12.669  1.00 35.98           N  
ATOM    416  CA  LEU A  63      53.654  -5.796  12.027  1.00 35.36           C  
ATOM    417  C   LEU A  63      52.933  -4.479  11.887  1.00 33.78           C  
ATOM    418  O   LEU A  63      52.016  -4.153  12.644  1.00 32.93           O  
ATOM    419  CB  LEU A  63      52.734  -6.821  12.712  1.00 37.33           C  
ATOM    420  CG  LEU A  63      52.801  -8.316  12.335  1.00 38.31           C  
ATOM    421  CD1 LEU A  63      51.384  -8.864  12.327  1.00 39.41           C  
ATOM    422  CD2 LEU A  63      53.421  -8.532  10.956  1.00 38.98           C  
ATOM    423  N   SER A  64      53.392  -3.737  10.889  1.00 32.45           N  
ATOM    424  CA  SER A  64      52.883  -2.427  10.513  1.00 31.23           C  
ATOM    425  C   SER A  64      54.068  -1.813   9.798  1.00 30.49           C  
ATOM    426  O   SER A  64      53.922  -0.879   9.017  1.00 31.46           O  
ATOM    427  CB  SER A  64      52.521  -1.573  11.733  1.00 30.73           C  
ATOM    428  OG  SER A  64      53.663  -0.895  12.216  1.00 30.34           O  
ATOM    429  N   GLN A  65      55.245  -2.367  10.076  1.00 28.82           N  
ATOM    430  CA  GLN A  65      56.482  -1.906   9.470  1.00 26.76           C  
ATOM    431  C   GLN A  65      57.009  -2.933   8.456  1.00 25.92           C  
ATOM    432  O   GLN A  65      57.627  -2.553   7.468  1.00 27.40           O  
ATOM    433  CB  GLN A  65      57.533  -1.620  10.559  1.00 26.12           C  
ATOM    434  CG  GLN A  65      56.998  -0.820  11.773  1.00 26.46           C  
ATOM    435  CD  GLN A  65      58.089  -0.372  12.764  1.00 26.09           C  
ATOM    436  OE1 GLN A  65      58.921  -1.174  13.204  1.00 24.74           O  
ATOM    437  NE2 GLN A  65      58.069   0.915  13.130  1.00 23.87           N  
ATOM    438  N   ILE A  66      56.763  -4.225   8.686  1.00 24.00           N  
ATOM    439  CA  ILE A  66      57.222  -5.264   7.753  1.00 21.52           C  
ATOM    440  C   ILE A  66      56.749  -4.878   6.354  1.00 20.20           C  
ATOM    441  O   ILE A  66      55.564  -4.937   6.068  1.00 20.22           O  
ATOM    442  CB  ILE A  66      56.667  -6.706   8.126  1.00 21.28           C  
ATOM    443  CG1 ILE A  66      55.151  -6.795   7.941  1.00 21.36           C  
ATOM    444  CG2 ILE A  66      57.000  -7.056   9.569  1.00 20.09           C  
ATOM    445  CD1 ILE A  66      54.328  -5.809   8.777  1.00 21.29           C  
ATOM    446  N   VAL A  67      57.662  -4.449   5.491  1.00 19.64           N  
ATOM    447  CA  VAL A  67      57.267  -4.024   4.153  1.00 18.99           C  
ATOM    448  C   VAL A  67      56.803  -5.152   3.244  1.00 19.08           C  
ATOM    449  O   VAL A  67      55.755  -5.043   2.597  1.00 19.26           O  
ATOM    450  CB  VAL A  67      58.405  -3.263   3.440  1.00 18.60           C  
ATOM    451  CG1 VAL A  67      57.993  -2.892   2.036  1.00 18.39           C  
ATOM    452  CG2 VAL A  67      58.735  -2.006   4.188  1.00 16.98           C  
ATOM    453  N   PHE A  68      57.563  -6.239   3.185  1.00 18.55           N  
ATOM    454  CA  PHE A  68      57.176  -7.334   2.300  1.00 18.44           C  
ATOM    455  C   PHE A  68      57.722  -8.675   2.784  1.00 18.56           C  
ATOM    456  O   PHE A  68      58.818  -8.715   3.333  1.00 19.74           O  
ATOM    457  CB  PHE A  68      57.685  -7.018   0.886  1.00 16.56           C  
ATOM    458  CG  PHE A  68      57.351  -8.055  -0.120  1.00 15.55           C  
ATOM    459  CD1 PHE A  68      56.044  -8.503  -0.261  1.00 16.34           C  
ATOM    460  CD2 PHE A  68      58.334  -8.572  -0.947  1.00 15.02           C  
ATOM    461  CE1 PHE A  68      55.719  -9.463  -1.215  1.00 16.83           C  
ATOM    462  CE2 PHE A  68      58.024  -9.532  -1.906  1.00 15.85           C  
ATOM    463  CZ  PHE A  68      56.716  -9.977  -2.042  1.00 16.35           C  
ATOM    464  N   ILE A  69      56.951  -9.756   2.614  1.00 17.50           N  
ATOM    465  CA  ILE A  69      57.406 -11.089   3.019  1.00 16.28           C  
ATOM    466  C   ILE A  69      57.364 -11.998   1.816  1.00 14.77           C  
ATOM    467  O   ILE A  69      56.628 -11.731   0.874  1.00 12.56           O  
ATOM    468  CB  ILE A  69      56.552 -11.730   4.173  1.00 17.43           C  
ATOM    469  CG1 ILE A  69      55.135 -12.070   3.707  1.00 17.92           C  
ATOM    470  CG2 ILE A  69      56.506 -10.794   5.367  1.00 17.31           C  
ATOM    471  CD1 ILE A  69      54.235 -10.864   3.517  1.00 19.89           C  
ATOM    472  N   GLU A  70      58.177 -13.055   1.864  1.00 15.35           N  
ATOM    473  CA  GLU A  70      58.307 -14.045   0.791  1.00 15.91           C  
ATOM    474  C   GLU A  70      58.907 -15.367   1.304  1.00 17.73           C  
ATOM    475  O   GLU A  70      59.143 -15.543   2.501  1.00 18.59           O  
ATOM    476  CB  GLU A  70      59.203 -13.485  -0.320  1.00 12.86           C  
ATOM    477  CG  GLU A  70      60.563 -13.080   0.174  1.00 10.78           C  
ATOM    478  CD  GLU A  70      61.442 -12.518  -0.907  1.00 10.27           C  
ATOM    479  OE1 GLU A  70      61.935 -13.289  -1.753  1.00 11.16           O  
ATOM    480  OE2 GLU A  70      61.644 -11.292  -0.915  1.00 11.07           O  
ATOM    481  N   GLU A  71      59.152 -16.296   0.388  1.00 19.65           N  
ATOM    482  CA  GLU A  71      59.734 -17.583   0.746  1.00 21.38           C  
ATOM    483  C   GLU A  71      61.113 -17.584   0.124  1.00 22.78           C  
ATOM    484  O   GLU A  71      61.308 -16.946  -0.902  1.00 24.16           O  
ATOM    485  CB  GLU A  71      58.913 -18.717   0.155  1.00 21.01           C  
ATOM    486  CG  GLU A  71      57.428 -18.520   0.289  1.00 21.01           C  
ATOM    487  CD  GLU A  71      56.650 -19.751  -0.116  1.00 21.65           C  
ATOM    488  OE1 GLU A  71      55.448 -19.606  -0.432  1.00 20.48           O  
ATOM    489  OE2 GLU A  71      57.234 -20.865  -0.109  1.00 22.88           O  
ATOM    490  N   GLN A  72      62.065 -18.292   0.724  1.00 24.23           N  
ATOM    491  CA  GLN A  72      63.427 -18.323   0.192  1.00 25.27           C  
ATOM    492  C   GLN A  72      63.776 -19.662  -0.440  1.00 26.42           C  
ATOM    493  O   GLN A  72      64.206 -19.727  -1.600  1.00 24.81           O  
ATOM    494  CB  GLN A  72      64.421 -17.999   1.303  1.00 25.47           C  
ATOM    495  CG  GLN A  72      65.848 -17.878   0.832  1.00 27.61           C  
ATOM    496  CD  GLN A  72      66.790 -17.459   1.945  1.00 30.08           C  
ATOM    497  OE1 GLN A  72      67.131 -16.278   2.078  1.00 31.79           O  
ATOM    498  NE2 GLN A  72      67.207 -18.425   2.764  1.00 30.98           N  
ATOM    499  N   ALA A  73      63.598 -20.722   0.343  1.00 27.90           N  
ATOM    500  CA  ALA A  73      63.860 -22.088  -0.099  1.00 30.08           C  
ATOM    501  C   ALA A  73      63.090 -23.016   0.816  1.00 31.33           C  
ATOM    502  O   ALA A  73      62.277 -22.496   1.619  1.00 31.23           O  
ATOM    503  CB  ALA A  73      65.356 -22.411  -0.034  1.00 28.53           C  
ATOM    504  N   LYS A  81      61.754 -21.841   4.301  1.00 19.22           N  
ATOM    505  CA  LYS A  81      61.783 -20.761   5.329  1.00 19.33           C  
ATOM    506  C   LYS A  81      61.187 -19.467   4.776  1.00 18.66           C  
ATOM    507  O   LYS A  81      61.252 -19.206   3.573  1.00 18.39           O  
ATOM    508  CB  LYS A  81      63.219 -20.520   5.788  1.00 21.41           C  
ATOM    509  CG  LYS A  81      64.180 -20.159   4.673  1.00 24.40           C  
ATOM    510  CD  LYS A  81      65.619 -20.200   5.174  1.00 27.55           C  
ATOM    511  CE  LYS A  81      66.084 -21.626   5.480  1.00 28.68           C  
ATOM    512  NZ  LYS A  81      67.529 -21.646   5.886  1.00 30.99           N  
ATOM    513  N   ILE A  82      60.606 -18.665   5.668  1.00 17.49           N  
ATOM    514  CA  ILE A  82      59.967 -17.398   5.301  1.00 15.70           C  
ATOM    515  C   ILE A  82      60.802 -16.153   5.652  1.00 14.83           C  
ATOM    516  O   ILE A  82      61.250 -15.982   6.788  1.00 14.16           O  
ATOM    517  CB  ILE A  82      58.579 -17.304   5.974  1.00 14.64           C  
ATOM    518  CG1 ILE A  82      57.834 -16.048   5.511  1.00 14.39           C  
ATOM    519  CG2 ILE A  82      58.746 -17.372   7.466  1.00 13.73           C  
ATOM    520  CD1 ILE A  82      58.389 -14.733   6.023  1.00 13.37           C  
ATOM    521  N   VAL A  83      60.984 -15.285   4.658  1.00 13.55           N  
ATOM    522  CA  VAL A  83      61.758 -14.060   4.813  1.00 12.74           C  
ATOM    523  C   VAL A  83      60.865 -12.850   5.126  1.00 13.05           C  
ATOM    524  O   VAL A  83      59.725 -12.776   4.649  1.00 12.16           O  
ATOM    525  CB  VAL A  83      62.517 -13.748   3.528  1.00 12.68           C  
ATOM    526  CG1 VAL A  83      63.575 -12.695   3.805  1.00 13.69           C  
ATOM    527  CG2 VAL A  83      63.105 -15.023   2.938  1.00 11.78           C  
ATOM    528  N   VAL A  84      61.391 -11.907   5.916  1.00 12.81           N  
ATOM    529  CA  VAL A  84      60.650 -10.705   6.294  1.00 11.81           C  
ATOM    530  C   VAL A  84      61.487  -9.432   6.215  1.00 13.28           C  
ATOM    531  O   VAL A  84      62.441  -9.250   6.964  1.00 13.88           O  
ATOM    532  CB  VAL A  84      60.119 -10.810   7.710  1.00  9.55           C  
ATOM    533  CG1 VAL A  84      59.420  -9.533   8.064  1.00  7.24           C  
ATOM    534  CG2 VAL A  84      59.185 -12.019   7.835  1.00  8.48           C  
ATOM    535  N   HIS A  85      61.122  -8.549   5.296  1.00 15.05           N  
ATOM    536  CA  HIS A  85      61.820  -7.278   5.111  1.00 16.41           C  
ATOM    537  C   HIS A  85      61.086  -6.333   6.034  1.00 18.54           C  
ATOM    538  O   HIS A  85      60.163  -5.653   5.608  1.00 18.61           O  
ATOM    539  CB  HIS A  85      61.676  -6.826   3.658  1.00 15.22           C  
ATOM    540  CG  HIS A  85      62.263  -7.787   2.668  1.00 13.00           C  
ATOM    541  ND1 HIS A  85      63.583  -7.735   2.278  1.00 11.94           N  
ATOM    542  CD2 HIS A  85      61.724  -8.862   2.042  1.00 11.06           C  
ATOM    543  CE1 HIS A  85      63.832  -8.740   1.457  1.00 12.85           C  
ATOM    544  NE2 HIS A  85      62.723  -9.439   1.298  1.00 10.95           N  
ATOM    545  N   LEU A  86      61.489  -6.321   7.301  1.00 21.31           N  
ATOM    546  CA  LEU A  86      60.828  -5.520   8.329  1.00 24.12           C  
ATOM    547  C   LEU A  86      60.886  -4.022   8.209  1.00 26.46           C  
ATOM    548  O   LEU A  86      59.954  -3.343   8.635  1.00 27.00           O  
ATOM    549  CB  LEU A  86      61.359  -5.854   9.720  1.00 24.10           C  
ATOM    550  CG  LEU A  86      61.967  -7.222   9.959  1.00 25.67           C  
ATOM    551  CD1 LEU A  86      63.390  -7.234   9.399  1.00 26.90           C  
ATOM    552  CD2 LEU A  86      61.986  -7.507  11.455  1.00 26.02           C  
ATOM    553  N   HIS A  87      61.962  -3.483   7.657  1.00 29.11           N  
ATOM    554  CA  HIS A  87      62.057  -2.032   7.596  1.00 32.17           C  
ATOM    555  C   HIS A  87      61.552  -1.306   6.325  1.00 34.07           C  
ATOM    556  O   HIS A  87      62.393  -0.904   5.494  1.00 37.57           O  
ATOM    557  CB  HIS A  87      63.491  -1.626   7.915  1.00 31.42           C  
ATOM    558  CG  HIS A  87      63.618  -0.192   8.272  1.00 31.67           C  
ATOM    559  ND1 HIS A  87      63.698   0.806   7.325  1.00 31.46           N  
ATOM    560  CD2 HIS A  87      63.598   0.422   9.475  1.00 33.01           C  
ATOM    561  CE1 HIS A  87      63.723   1.976   7.932  1.00 33.94           C  
ATOM    562  NE2 HIS A  87      63.664   1.771   9.237  1.00 35.11           N  
ATOM    563  N   SER A 101      74.748  -1.097   3.922  1.00 26.52           N  
ATOM    564  CA  SER A 101      75.719  -1.338   5.029  1.00 27.07           C  
ATOM    565  C   SER A 101      75.131  -2.291   6.068  1.00 26.78           C  
ATOM    566  O   SER A 101      75.861  -3.034   6.723  1.00 28.01           O  
ATOM    567  CB  SER A 101      76.111   0.000   5.690  1.00 28.16           C  
ATOM    568  OG  SER A 101      74.977   0.808   5.999  1.00 28.45           O  
ATOM    569  N   LYS A 102      73.809  -2.260   6.212  1.00 26.10           N  
ATOM    570  CA  LYS A 102      73.095  -3.114   7.159  1.00 25.13           C  
ATOM    571  C   LYS A 102      72.082  -4.001   6.421  1.00 24.72           C  
ATOM    572  O   LYS A 102      71.621  -3.663   5.325  1.00 23.05           O  
ATOM    573  CB  LYS A 102      72.383  -2.245   8.204  1.00 25.56           C  
ATOM    574  CG  LYS A 102      73.329  -1.498   9.129  1.00 25.49           C  
ATOM    575  CD  LYS A 102      72.615  -0.453   9.965  1.00 26.02           C  
ATOM    576  CE  LYS A 102      73.615   0.274  10.853  1.00 28.59           C  
ATOM    577  NZ  LYS A 102      73.145   1.630  11.267  1.00 30.73           N  
ATOM    578  N   ASN A 103      71.731  -5.139   7.013  1.00 25.02           N  
ATOM    579  CA  ASN A 103      70.787  -6.035   6.356  1.00 25.25           C  
ATOM    580  C   ASN A 103      69.359  -5.498   6.339  1.00 24.48           C  
ATOM    581  O   ASN A 103      68.899  -4.844   7.283  1.00 22.34           O  
ATOM    582  CB  ASN A 103      70.832  -7.432   6.983  1.00 26.25           C  
ATOM    583  CG  ASN A 103      70.677  -7.400   8.479  1.00 26.86           C  
ATOM    584  OD1 ASN A 103      71.538  -6.861   9.190  1.00 27.22           O  
ATOM    585  ND2 ASN A 103      69.574  -7.973   8.977  1.00 26.17           N  
ATOM    586  N   SER A 104      68.681  -5.794   5.235  1.00 24.74           N  
ATOM    587  CA  SER A 104      67.318  -5.352   4.975  1.00 25.59           C  
ATOM    588  C   SER A 104      66.256  -6.209   5.627  1.00 25.82           C  
ATOM    589  O   SER A 104      65.150  -5.733   5.879  1.00 27.86           O  
ATOM    590  CB  SER A 104      67.056  -5.347   3.473  1.00 26.08           C  
ATOM    591  OG  SER A 104      68.171  -4.828   2.781  1.00 27.76           O  
ATOM    592  N   TYR A 105      66.574  -7.474   5.887  1.00 25.31           N  
ATOM    593  CA  TYR A 105      65.595  -8.383   6.483  1.00 23.93           C  
ATOM    594  C   TYR A 105      66.154  -9.363   7.511  1.00 23.60           C  
ATOM    595  O   TYR A 105      67.333  -9.331   7.873  1.00 23.51           O  
ATOM    596  CB  TYR A 105      64.923  -9.197   5.380  1.00 23.46           C  
ATOM    597  CG  TYR A 105      65.932  -9.913   4.495  1.00 22.89           C  
ATOM    598  CD1 TYR A 105      66.483  -9.280   3.384  1.00 23.32           C  
ATOM    599  CD2 TYR A 105      66.365 -11.209   4.787  1.00 21.78           C  
ATOM    600  CE1 TYR A 105      67.446  -9.917   2.574  1.00 22.53           C  
ATOM    601  CE2 TYR A 105      67.333 -11.860   3.981  1.00 21.68           C  
ATOM    602  CZ  TYR A 105      67.867 -11.203   2.873  1.00 22.38           C  
ATOM    603  OH  TYR A 105      68.809 -11.815   2.059  1.00 23.43           O  
ATOM    604  N   ILE A 106      65.260 -10.237   7.960  1.00 22.64           N  
ATOM    605  CA  ILE A 106      65.539 -11.300   8.907  1.00 21.38           C  
ATOM    606  C   ILE A 106      64.794 -12.435   8.269  1.00 21.28           C  
ATOM    607  O   ILE A 106      63.863 -12.195   7.504  1.00 21.70           O  
ATOM    608  CB  ILE A 106      64.872 -11.078  10.265  1.00 21.71           C  
ATOM    609  CG1 ILE A 106      63.348 -11.110  10.102  1.00 22.68           C  
ATOM    610  CG2 ILE A 106      65.335  -9.762  10.877  1.00 22.35           C  
ATOM    611  CD1 ILE A 106      62.574 -11.213  11.416  1.00 24.83           C  
ATOM    612  N   ARG A 107      65.169 -13.665   8.563  1.00 21.19           N  
ATOM    613  CA  ARG A 107      64.422 -14.747   7.965  1.00 21.76           C  
ATOM    614  C   ARG A 107      64.048 -15.763   9.021  1.00 20.67           C  
ATOM    615  O   ARG A 107      64.737 -15.909  10.030  1.00 20.00           O  
ATOM    616  CB  ARG A 107      65.199 -15.384   6.808  1.00 23.03           C  
ATOM    617  CG  ARG A 107      66.317 -16.334   7.182  1.00 26.31           C  
ATOM    618  CD  ARG A 107      66.891 -16.962   5.916  1.00 27.46           C  
ATOM    619  NE  ARG A 107      67.581 -15.971   5.097  1.00 27.85           N  
ATOM    620  CZ  ARG A 107      68.899 -15.823   5.069  1.00 28.58           C  
ATOM    621  NH1 ARG A 107      69.672 -16.608   5.815  1.00 27.27           N  
ATOM    622  NH2 ARG A 107      69.443 -14.891   4.296  1.00 29.57           N  
ATOM    623  N   LEU A 108      62.938 -16.451   8.785  1.00 19.19           N  
ATOM    624  CA  LEU A 108      62.448 -17.421   9.732  1.00 18.19           C  
ATOM    625  C   LEU A 108      62.439 -18.836   9.180  1.00 18.76           C  
ATOM    626  O   LEU A 108      61.871 -19.098   8.120  1.00 17.37           O  
ATOM    627  CB  LEU A 108      61.043 -17.035  10.154  1.00 17.78           C  
ATOM    628  CG  LEU A 108      60.776 -15.543  10.340  1.00 17.35           C  
ATOM    629  CD1 LEU A 108      59.388 -15.401  10.971  1.00 17.03           C  
ATOM    630  CD2 LEU A 108      61.859 -14.879  11.208  1.00 16.92           C  
ATOM    631  N   SER A 109      63.073 -19.742   9.920  1.00 20.73           N  
ATOM    632  CA  SER A 109      63.160 -21.151   9.546  1.00 23.30           C  
ATOM    633  C   SER A 109      62.159 -21.919  10.384  1.00 24.19           C  
ATOM    634  O   SER A 109      62.026 -21.669  11.585  1.00 24.40           O  
ATOM    635  CB  SER A 109      64.565 -21.707   9.827  1.00 24.99           C  
ATOM    636  OG  SER A 109      65.562 -21.105   9.011  1.00 27.77           O  
ATOM    637  N   PHE A 110      61.456 -22.856   9.756  1.00 24.43           N  
ATOM    638  CA  PHE A 110      60.466 -23.652  10.470  1.00 24.39           C  
ATOM    639  C   PHE A 110      60.948 -25.092  10.561  1.00 26.43           C  
ATOM    640  O   PHE A 110      60.660 -25.912   9.695  1.00 26.53           O  
ATOM    641  CB  PHE A 110      59.101 -23.579   9.764  1.00 20.32           C  
ATOM    642  CG  PHE A 110      58.352 -22.277   9.990  1.00 16.74           C  
ATOM    643  CD1 PHE A 110      57.529 -22.111  11.101  1.00 16.18           C  
ATOM    644  CD2 PHE A 110      58.476 -21.215   9.096  1.00 14.81           C  
ATOM    645  CE1 PHE A 110      56.839 -20.908  11.318  1.00 14.51           C  
ATOM    646  CE2 PHE A 110      57.792 -20.011   9.303  1.00 12.84           C  
ATOM    647  CZ  PHE A 110      56.975 -19.858  10.414  1.00 13.40           C  
ATOM    648  N   LYS A 111      61.710 -25.379  11.612  1.00 29.12           N  
ATOM    649  CA  LYS A 111      62.243 -26.713  11.851  1.00 31.68           C  
ATOM    650  C   LYS A 111      61.087 -27.641  12.174  1.00 33.83           C  
ATOM    651  O   LYS A 111      60.897 -28.644  11.502  1.00 34.68           O  
ATOM    652  CB  LYS A 111      63.234 -26.682  13.013  1.00 31.23           C  
ATOM    653  CG  LYS A 111      63.988 -27.985  13.249  1.00 31.60           C  
ATOM    654  CD  LYS A 111      64.986 -27.852  14.400  1.00 31.88           C  
ATOM    655  CE  LYS A 111      65.753 -29.153  14.622  1.00 32.15           C  
ATOM    656  NZ  LYS A 111      64.870 -30.308  14.986  1.00 32.38           N  
ATOM    657  N   GLU A 112      60.312 -27.314  13.204  1.00 36.82           N  
ATOM    658  CA  GLU A 112      59.157 -28.146  13.552  1.00 39.83           C  
ATOM    659  C   GLU A 112      58.073 -27.758  12.563  1.00 40.64           C  
ATOM    660  O   GLU A 112      57.681 -26.597  12.508  1.00 40.58           O  
ATOM    661  CB  GLU A 112      58.682 -27.885  14.999  1.00 41.01           C  
ATOM    662  CG  GLU A 112      57.496 -28.771  15.463  1.00 40.72           C  
ATOM    663  CD  GLU A 112      57.303 -28.805  16.990  1.00 40.68           C  
ATOM    664  OE1 GLU A 112      58.291 -28.583  17.730  1.00 42.08           O  
ATOM    665  OE2 GLU A 112      56.169 -29.080  17.454  1.00 38.21           O  
ATOM    666  N   HIS A 113      57.610 -28.724  11.775  1.00 41.83           N  
ATOM    667  CA  HIS A 113      56.593 -28.446  10.776  1.00 43.47           C  
ATOM    668  C   HIS A 113      55.492 -27.465  11.207  1.00 44.22           C  
ATOM    669  O   HIS A 113      54.861 -27.612  12.265  1.00 44.27           O  
ATOM    670  CB  HIS A 113      55.971 -29.754  10.224  1.00 44.61           C  
ATOM    671  CG  HIS A 113      55.682 -30.808  11.258  1.00 46.02           C  
ATOM    672  ND1 HIS A 113      56.432 -31.961  11.375  1.00 46.32           N  
ATOM    673  CD2 HIS A 113      54.689 -30.914  12.175  1.00 46.58           C  
ATOM    674  CE1 HIS A 113      55.914 -32.731  12.316  1.00 46.00           C  
ATOM    675  NE2 HIS A 113      54.855 -32.120  12.818  1.00 46.45           N  
ATOM    676  N   GLY A 114      55.294 -26.456  10.354  1.00 44.33           N  
ATOM    677  CA  GLY A 114      54.292 -25.430  10.580  1.00 43.98           C  
ATOM    678  C   GLY A 114      54.425 -24.325   9.554  1.00 44.04           C  
ATOM    679  O   GLY A 114      53.901 -23.221   9.748  1.00 44.75           O  
ATOM    680  N   GLN A 115      55.129 -24.624   8.462  1.00 43.63           N  
ATOM    681  CA  GLN A 115      55.341 -23.667   7.369  1.00 42.70           C  
ATOM    682  C   GLN A 115      54.167 -23.698   6.380  1.00 42.03           C  
ATOM    683  O   GLN A 115      53.481 -24.726   6.234  1.00 42.72           O  
ATOM    684  CB  GLN A 115      56.663 -23.977   6.642  1.00 42.33           C  
ATOM    685  CG  GLN A 115      56.872 -23.295   5.294  1.00 40.88           C  
ATOM    686  CD  GLN A 115      56.984 -21.791   5.409  1.00 40.28           C  
ATOM    687  OE1 GLN A 115      56.092 -21.125   5.940  1.00 39.86           O  
ATOM    688  NE2 GLN A 115      58.083 -21.244   4.912  1.00 40.04           N  
ATOM    689  N   ILE A 116      53.946 -22.547   5.741  1.00 40.28           N  
ATOM    690  CA  ILE A 116      52.893 -22.278   4.742  1.00 37.31           C  
ATOM    691  C   ILE A 116      51.461 -22.241   5.253  1.00 35.01           C  
ATOM    692  O   ILE A 116      50.530 -22.019   4.492  1.00 34.18           O  
ATOM    693  CB  ILE A 116      53.002 -23.169   3.406  1.00 37.08           C  
ATOM    694  CG1 ILE A 116      52.985 -24.677   3.686  1.00 37.59           C  
ATOM    695  CG2 ILE A 116      54.248 -22.748   2.602  1.00 36.26           C  
ATOM    696  CD1 ILE A 116      51.585 -25.277   3.726  1.00 38.41           C  
ATOM    697  N   GLU A 117      51.290 -22.458   6.547  1.00 33.19           N  
ATOM    698  CA  GLU A 117      49.981 -22.322   7.144  1.00 33.17           C  
ATOM    699  C   GLU A 117      50.242 -20.978   7.764  1.00 32.80           C  
ATOM    700  O   GLU A 117      49.328 -20.201   7.992  1.00 32.83           O  
ATOM    701  CB  GLU A 117      49.724 -23.332   8.260  1.00 34.24           C  
ATOM    702  CG  GLU A 117      49.139 -24.679   7.840  1.00 37.70           C  
ATOM    703  CD  GLU A 117      48.752 -25.565   9.043  1.00 38.31           C  
ATOM    704  OE1 GLU A 117      47.783 -25.229   9.764  1.00 38.34           O  
ATOM    705  OE2 GLU A 117      49.422 -26.601   9.269  1.00 38.78           O  
ATOM    706  N   PHE A 118      51.527 -20.729   8.027  1.00 32.50           N  
ATOM    707  CA  PHE A 118      51.999 -19.481   8.626  1.00 31.18           C  
ATOM    708  C   PHE A 118      52.210 -18.412   7.532  1.00 30.33           C  
ATOM    709  O   PHE A 118      51.883 -17.234   7.708  1.00 28.72           O  
ATOM    710  CB  PHE A 118      53.326 -19.727   9.383  1.00 30.81           C  
ATOM    711  CG  PHE A 118      53.549 -18.783  10.554  1.00 29.17           C  
ATOM    712  CD1 PHE A 118      53.317 -19.210  11.854  1.00 28.36           C  
ATOM    713  CD2 PHE A 118      53.921 -17.455  10.347  1.00 27.61           C  
ATOM    714  CE1 PHE A 118      53.435 -18.335  12.927  1.00 28.07           C  
ATOM    715  CE2 PHE A 118      54.042 -16.569  11.411  1.00 26.76           C  
ATOM    716  CZ  PHE A 118      53.801 -17.007  12.701  1.00 27.43           C  
ATOM    717  N   TYR A 119      52.773 -18.838   6.407  1.00 30.06           N  
ATOM    718  CA  TYR A 119      53.024 -17.929   5.302  1.00 30.74           C  
ATOM    719  C   TYR A 119      51.697 -17.358   4.848  1.00 31.76           C  
ATOM    720  O   TYR A 119      51.583 -16.168   4.532  1.00 32.29           O  
ATOM    721  CB  TYR A 119      53.674 -18.669   4.133  1.00 30.35           C  
ATOM    722  CG  TYR A 119      53.949 -17.777   2.935  1.00 30.40           C  
ATOM    723  CD1 TYR A 119      55.078 -16.957   2.889  1.00 30.43           C  
ATOM    724  CD2 TYR A 119      53.067 -17.739   1.853  1.00 29.95           C  
ATOM    725  CE1 TYR A 119      55.320 -16.118   1.795  1.00 31.04           C  
ATOM    726  CE2 TYR A 119      53.296 -16.903   0.756  1.00 30.40           C  
ATOM    727  CZ  TYR A 119      54.423 -16.097   0.731  1.00 31.38           C  
ATOM    728  OH  TYR A 119      54.652 -15.261  -0.347  1.00 32.37           O  
ATOM    729  N   ARG A 120      50.692 -18.224   4.814  1.00 32.74           N  
ATOM    730  CA  ARG A 120      49.368 -17.814   4.390  1.00 33.79           C  
ATOM    731  C   ARG A 120      48.811 -16.785   5.368  1.00 33.11           C  
ATOM    732  O   ARG A 120      48.411 -15.689   4.954  1.00 33.30           O  
ATOM    733  CB  ARG A 120      48.438 -19.035   4.276  1.00 35.66           C  
ATOM    734  CG  ARG A 120      48.444 -19.727   2.887  1.00 38.73           C  
ATOM    735  CD  ARG A 120      47.774 -21.118   2.920  1.00 41.49           C  
ATOM    736  NE  ARG A 120      46.453 -21.117   3.563  1.00 44.81           N  
ATOM    737  CZ  ARG A 120      45.326 -20.706   2.984  1.00 46.74           C  
ATOM    738  NH1 ARG A 120      45.336 -20.255   1.731  1.00 48.10           N  
ATOM    739  NH2 ARG A 120      44.184 -20.736   3.665  1.00 47.61           N  
ATOM    740  N   ARG A 121      48.820 -17.119   6.659  1.00 31.04           N  
ATOM    741  CA  ARG A 121      48.303 -16.216   7.684  1.00 29.02           C  
ATOM    742  C   ARG A 121      49.164 -14.983   7.947  1.00 28.09           C  
ATOM    743  O   ARG A 121      48.670 -14.004   8.502  1.00 27.34           O  
ATOM    744  CB  ARG A 121      48.088 -16.965   9.000  1.00 28.26           C  
ATOM    745  CG  ARG A 121      47.099 -18.111   8.914  1.00 27.76           C  
ATOM    746  CD  ARG A 121      45.653 -17.661   8.643  1.00 27.44           C  
ATOM    747  NE  ARG A 121      44.806 -18.822   8.359  1.00 29.92           N  
ATOM    748  CZ  ARG A 121      44.692 -19.408   7.161  1.00 31.28           C  
ATOM    749  NH1 ARG A 121      45.353 -18.934   6.107  1.00 30.68           N  
ATOM    750  NH2 ARG A 121      43.957 -20.508   7.020  1.00 30.98           N  
ATOM    751  N   LEU A 122      50.442 -15.023   7.576  1.00 28.22           N  
ATOM    752  CA  LEU A 122      51.313 -13.862   7.789  1.00 28.75           C  
ATOM    753  C   LEU A 122      51.094 -12.836   6.661  1.00 29.22           C  
ATOM    754  O   LEU A 122      51.155 -11.616   6.882  1.00 29.09           O  
ATOM    755  CB  LEU A 122      52.790 -14.281   7.831  1.00 27.92           C  
ATOM    756  CG  LEU A 122      53.756 -13.367   8.605  1.00 26.85           C  
ATOM    757  CD1 LEU A 122      55.175 -13.841   8.369  1.00 26.47           C  
ATOM    758  CD2 LEU A 122      53.615 -11.926   8.172  1.00 26.23           C  
ATOM    759  N   SER A 123      50.843 -13.332   5.450  1.00 28.55           N  
ATOM    760  CA  SER A 123      50.598 -12.439   4.324  1.00 27.36           C  
ATOM    761  C   SER A 123      49.215 -11.809   4.492  1.00 26.21           C  
ATOM    762  O   SER A 123      49.078 -10.585   4.499  1.00 25.81           O  
ATOM    763  CB  SER A 123      50.677 -13.201   2.991  1.00 27.86           C  
ATOM    764  OG  SER A 123      50.505 -12.330   1.869  1.00 27.62           O  
ATOM    765  N   GLU A 124      48.196 -12.649   4.656  1.00 25.07           N  
ATOM    766  CA  GLU A 124      46.825 -12.170   4.809  1.00 24.04           C  
ATOM    767  C   GLU A 124      46.680 -11.086   5.874  1.00 22.33           C  
ATOM    768  O   GLU A 124      46.078 -10.041   5.637  1.00 21.64           O  
ATOM    769  CB  GLU A 124      45.868 -13.340   5.130  1.00 25.23           C  
ATOM    770  CG  GLU A 124      45.688 -14.370   3.993  1.00 25.66           C  
ATOM    771  CD  GLU A 124      44.615 -15.423   4.295  1.00 25.67           C  
ATOM    772  OE1 GLU A 124      44.713 -16.109   5.337  1.00 25.52           O  
ATOM    773  OE2 GLU A 124      43.672 -15.567   3.485  1.00 25.95           O  
ATOM    774  N   GLU A 125      47.239 -11.330   7.047  1.00 21.18           N  
ATOM    775  CA  GLU A 125      47.127 -10.369   8.128  1.00 21.14           C  
ATOM    776  C   GLU A 125      48.001  -9.128   7.938  1.00 21.41           C  
ATOM    777  O   GLU A 125      47.545  -8.006   8.156  1.00 22.54           O  
ATOM    778  CB  GLU A 125      47.461 -11.047   9.461  1.00 19.69           C  
ATOM    779  CG  GLU A 125      46.524 -10.661  10.611  1.00 18.83           C  
ATOM    780  CD  GLU A 125      45.083 -11.150  10.421  1.00 17.97           C  
ATOM    781  OE1 GLU A 125      44.887 -12.360  10.190  1.00 17.10           O  
ATOM    782  OE2 GLU A 125      44.143 -10.327  10.519  1.00 16.39           O  
ATOM    783  N   MET A 126      49.249  -9.322   7.533  1.00 21.04           N  
ATOM    784  CA  MET A 126      50.171  -8.205   7.337  1.00 20.65           C  
ATOM    785  C   MET A 126      49.753  -7.159   6.296  1.00 21.89           C  
ATOM    786  O   MET A 126      49.981  -5.970   6.498  1.00 21.74           O  
ATOM    787  CB  MET A 126      51.561  -8.755   7.006  1.00 18.57           C  
ATOM    788  CG  MET A 126      52.473  -7.786   6.302  1.00 15.67           C  
ATOM    789  SD  MET A 126      52.490  -8.150   4.561  1.00 12.37           S  
ATOM    790  CE  MET A 126      53.928  -7.274   4.031  1.00 14.11           C  
ATOM    791  N   THR A 127      49.143  -7.588   5.194  1.00 23.99           N  
ATOM    792  CA  THR A 127      48.716  -6.662   4.146  1.00 26.47           C  
ATOM    793  C   THR A 127      47.575  -5.699   4.521  1.00 28.73           C  
ATOM    794  O   THR A 127      47.516  -4.577   4.012  1.00 28.70           O  
ATOM    795  CB  THR A 127      48.303  -7.424   2.878  1.00 26.88           C  
ATOM    796  OG1 THR A 127      47.271  -8.364   3.202  1.00 26.60           O  
ATOM    797  CG2 THR A 127      49.509  -8.152   2.270  1.00 27.13           C  
ATOM    798  N   GLN A 128      46.664  -6.128   5.394  1.00 31.68           N  
ATOM    799  CA  GLN A 128      45.551  -5.266   5.822  1.00 34.79           C  
ATOM    800  C   GLN A 128      45.895  -4.487   7.092  1.00 35.94           C  
ATOM    801  O   GLN A 128      45.022  -3.976   7.796  1.00 34.84           O  
ATOM    802  CB  GLN A 128      44.280  -6.093   6.040  1.00 36.19           C  
ATOM    803  CG  GLN A 128      43.492  -6.324   4.765  1.00 39.62           C  
ATOM    804  CD  GLN A 128      44.330  -6.985   3.662  1.00 42.28           C  
ATOM    805  OE1 GLN A 128      44.199  -6.655   2.476  1.00 42.91           O  
ATOM    806  NE2 GLN A 128      45.182  -7.928   4.051  1.00 42.27           N  
ATOM    807  N   ARG A 129      47.191  -4.407   7.362  1.00 38.35           N  
ATOM    808  CA  ARG A 129      47.737  -3.711   8.517  1.00 41.03           C  
ATOM    809  C   ARG A 129      48.417  -2.456   7.997  1.00 43.07           C  
ATOM    810  O   ARG A 129      49.631  -2.317   8.141  1.00 43.91           O  
ATOM    811  CB  ARG A 129      48.785  -4.596   9.193  1.00 40.95           C  
ATOM    812  CG  ARG A 129      48.462  -5.078  10.592  1.00 42.06           C  
ATOM    813  CD  ARG A 129      48.715  -3.999  11.624  1.00 41.94           C  
ATOM    814  NE  ARG A 129      47.591  -3.086  11.731  1.00 42.50           N  
ATOM    815  CZ  ARG A 129      47.590  -1.994  12.481  1.00 43.17           C  
ATOM    816  NH1 ARG A 129      48.669  -1.676  13.191  1.00 43.22           N  
ATOM    817  NH2 ARG A 129      46.503  -1.232  12.530  1.00 44.29           N  
ATOM    818  N   ARG A 130      47.653  -1.556   7.380  1.00 44.53           N  
ATOM    819  CA  ARG A 130      48.231  -0.326   6.824  1.00 45.38           C  
ATOM    820  C   ARG A 130      47.756   0.933   7.551  1.00 45.98           C  
ATOM    821  O   ARG A 130      46.735   0.833   8.270  1.00 46.23           O  
ATOM    822  CB  ARG A 130      47.883  -0.216   5.333  1.00 43.67           C  
ATOM    823  CG  ARG A 130      48.274  -1.427   4.496  1.00 42.47           C  
ATOM    824  CD  ARG A 130      49.783  -1.626   4.428  1.00 42.46           C  
ATOM    825  NE  ARG A 130      50.286  -2.519   5.462  1.00 43.08           N  
ATOM    826  CZ  ARG A 130      51.565  -2.852   5.591  1.00 44.75           C  
ATOM    827  NH1 ARG A 130      52.467  -2.365   4.745  1.00 45.56           N  
ATOM    828  NH2 ARG A 130      51.945  -3.666   6.570  1.00 46.30           N  
TER     829      ARG A 130                                                      
END
MOLECULE T0446.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
