
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 ( 1060),  selected  127 , name 2qkm_G
# Molecule2: number of CA atoms  116 (  905),  selected  116 , name T0446.pdb
# PARAMETERS: 2qkm_G.T0446.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_G      G       9           -
LGA    E     2_G      N      10           -
LGA    D     3_G      A      11           -
LGA    E     4_G      A      12           -
LGA    -       -      E      13           -
LGA    N     5_G      V      14           #
LGA    I     6_G      -       -           -
LGA    L     7_G      -       -           -
LGA    R     8_G      N      15          3.792
LGA    N     9_G      L      16          2.599
LGA    A    10_G      D      17          3.019
LGA    V    11_G      E      18          2.357
LGA    N    12_G      L      19          0.383
LGA    L    13_G      A      20          1.093
LGA    Q    14_G      Q      21          2.278
LGA    V    15_G      E      22          2.097
LGA    L    16_G      L      23          1.932
LGA    K    17_G      G      24          2.871
LGA    F    18_G      P      25          3.009
LGA    H    19_G      -       -           -
LGA    Y    20_G      I      26          2.378
LGA    P    21_G      M      27          3.417
LGA    E    22_G      G      28          1.414
LGA    I    23_G      D      29           #
LGA    -       -      N      30           -
LGA    E    24_G      E      31          2.639
LGA    S    25_G      Q      32          0.513
LGA    I    26_G      L      33          0.208
LGA    I    27_G      A      34          0.794
LGA    D    28_G      L      35          1.156
LGA    I    29_G      A      36          1.676
LGA    A    30_G      Y      37          2.283
LGA    S    31_G      R      38          2.962
LGA    H    32_G      V      39          2.405
LGA    V    33_G      I      40           #
LGA    A    34_G      -       -           -
LGA    V    35_G      -       -           -
LGA    Y    36_G      -       -           -
LGA    Q    37_G      -       -           -
LGA    F    38_G      -       -           -
LGA    D    39_G      -       -           -
LGA    V    40_G      -       -           -
LGA    G    41_G      -       -           -
LGA    S    42_G      -       -           -
LGA    Q    43_G      -       -           -
LGA    K    44_G      -       -           -
LGA    W    45_G      -       -           -
LGA    L    46_G      -       -           -
LGA    K    47_G      -       -           -
LGA    T    48_G      -       -           -
LGA    S    49_G      -       -           -
LGA    I    50_G      -       -           -
LGA    E    51_G      R      41           #
LGA    G    52_G      D      42          1.391
LGA    T    53_G      M      43          1.854
LGA    F    54_G      F      44          1.344
LGA    F    55_G      V      45          1.041
LGA    L    56_G      F      46          0.233
LGA    V    57_G      T      47          0.531
LGA    K    58_G      N      48          1.988
LGA    D    59_G      -       -           -
LGA    Q    60_G      -       -           -
LGA    R    61_G      -       -           -
LGA    A    62_G      -       -           -
LGA    R    63_G      -       -           -
LGA    V    64_G      K      49          2.819
LGA    G    65_G      R      50          1.222
LGA    Y    66_G      L      51          0.717
LGA    V    67_G      I      52          1.087
LGA    I    68_G      L      53          2.228
LGA    L    69_G      I      54          2.172
LGA    N    70_G      D      55          1.793
LGA    R    71_G      K      56          3.033
LGA    N    72_G      Q      57          2.418
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    -       -      T      60           -
LGA    -       -      G      61           -
LGA    -       -      K      62           -
LGA    S    73_G      K      63          3.027
LGA    P    74_G      V      64          0.676
LGA    E    75_G      S      65          1.320
LGA    N    76_G      Y      66          2.301
LGA    L    77_G      H      67          2.205
LGA    Y    78_G      S      68          1.692
LGA    L    79_G      V      69          0.768
LGA    F    80_G      P      70          1.374
LGA    I    81_G      Y      71          1.733
LGA    N    82_G      K      72          1.398
LGA    H    83_G      A      73           #
LGA    P    84_G      I      74           #
LGA    S    85_G      T      75           #
LGA    N    86_G      H      76          1.859
LGA    V    87_G      F      77          2.291
LGA    H    88_G      E      78          1.539
LGA    L    89_G      V      79          0.611
LGA    V    90_G      E      80          2.066
LGA    D    91_G      T      81          3.990
LGA    -       -      A      82           -
LGA    -       -      G      83           -
LGA    -       -      T      84           -
LGA    -       -      F      85           -
LGA    -       -      D      86           -
LGA    -       -      M      87           -
LGA    -       -      D      88           -
LGA    R    92_G      A      89          1.366
LGA    Y    93_G      E      90          1.395
LGA    L    94_G      L      91          0.961
LGA    I    95_G      K      92          0.659
LGA    H    96_G      L      93          0.564
LGA    R    97_G      W      94          0.732
LGA    T    98_G      I      95          1.109
LGA    E    99_G      S      96          1.367
LGA    N   100_G      G      97          1.391
LGA    Q   101_G      Q      98          3.136
LGA    H   102_G      K      99          3.910
LGA    V   103_G      D     100          3.261
LGA    -       -      P     101           -
LGA    V   104_G      L     102          1.010
LGA    G   105_G      V     103          0.888
LGA    L   106_G      K     104          1.655
LGA    W   107_G      E     105          1.894
LGA    M   108_G      L     106          3.090
LGA    F   109_G      K     107          2.344
LGA    D   110_G      K     108          2.474
LGA    P   111_G      G     109          5.343
LGA    N   112_G      T     110          3.360
LGA    D   113_G      D     111          2.777
LGA    M   114_G      V     112          2.930
LGA    S   115_G      V     113          2.916
LGA    R   116_G      G     114          2.017
LGA    I   117_G      I     115          0.513
LGA    F   118_G      Q     116          0.947
LGA    N   119_G      K     117          1.938
LGA    I   120_G      T     118          1.938
LGA    V   121_G      I     119          1.298
LGA    K   122_G      A     120          2.352
LGA    E   123_G      N     121          5.869
LGA    S   124_G      F     122           -
LGA    L   125_G      S     123           -
LGA    L   126_G      L     124           -
LGA    R   127_G      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127  116    5.0     87    2.22     9.20     51.452     3.748

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.765406 * X  +  -0.386076 * Y  +   0.514878 * Z  +  67.255531
  Y_new =  -0.115530 * X  +  -0.704631 * Y  +  -0.700105 * Z  + -13.257034
  Z_new =   0.633093 * X  +  -0.595348 * Y  +   0.494726 * Z  +  18.395285 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.877446    2.264147  [ DEG:   -50.2739    129.7261 ]
  Theta =  -0.685543   -2.456050  [ DEG:   -39.2787   -140.7213 ]
  Phi   =  -2.991784    0.149808  [ DEG:  -171.4166      8.5834 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qkm_G                                        
REMARK     2: T0446.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qkm_G.T0446.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127  116   5.0   87   2.22    9.20  51.452
REMARK  ---------------------------------------------------------- 
MOLECULE 2qkm_G
HEADER    HYDROLASE                               11-JUL-07   2QKM              
TITLE     THE CRYSTAL STRUCTURE OF FISSION YEAST MRNA DECAPPING                 
TITLE    2 ENZYME DCP1-DCP2 COMPLEX                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SPBC3B9.21 PROTEIN;                                        
COMPND   3 CHAIN: A, C, E, G;                                                   
COMPND   4 SYNONYM: DCP1 PROTEIN;                                               
COMPND   5 EC: 3.6.1.30;                                                        
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: SPAC19A8.12 PROTEIN;                                       
COMPND   9 CHAIN: B, D, F, H;                                                   
COMPND  10 FRAGMENT: RESIDUES 1-266;                                            
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SCHIZOSACCHAROMYCES POMBE;                      
SOURCE   3 GENE: DCP1;                                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 STAR;                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PGEX-6P-1;                                
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 ORGANISM_SCIENTIFIC: SCHIZOSACCHAROMYCES POMBE;                      
SOURCE  10 GENE: SPAC19A8.12;                                                   
SOURCE  11 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  12 EXPRESSION_SYSTEM_STRAIN: BL21 STAR;                                 
SOURCE  13 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  14 EXPRESSION_SYSTEM_PLASMID: PGEX-6P-1                                 
KEYWDS    PROTEIN-PROTEIN COMPLEX, HYDROLASE                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.SHE,H.SONG                                                          
REVDAT   1   15-APR-08 2QKM    0                                                
JRNL        AUTH   M.SHE,C.J.DECKER,D.I.SVERGUN,A.ROUND,N.CHEN,                 
JRNL        AUTH 2 D.MUHLRAD,R.PARKER,H.SONG                                    
JRNL        TITL   STRUCTURAL BASIS OF DCP2 RECOGNITION AND                     
JRNL        TITL 2 ACTIVATION BY DCP1.                                          
JRNL        REF    MOL.CELL                      V.  29   337 2008              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  2QKM A    1   127  UNP    Q9P805   Q9P805_SCHPO     1    127             
DBREF  2QKM B    1   266  UNP    O13828   O13828_SCHPO     1    266             
DBREF  2QKM C    1   127  UNP    Q9P805   Q9P805_SCHPO     1    127             
DBREF  2QKM D    1   266  UNP    O13828   O13828_SCHPO     1    266             
DBREF  2QKM E    1   127  UNP    Q9P805   Q9P805_SCHPO     1    127             
DBREF  2QKM F    1   266  UNP    O13828   O13828_SCHPO     1    266             
DBREF  2QKM G    1   127  UNP    Q9P805   Q9P805_SCHPO     1    127             
DBREF  2QKM H    1   266  UNP    O13828   O13828_SCHPO     1    266             
SEQRES   1 A  127  MET GLU ASP GLU ASN ILE LEU ARG ASN ALA VAL ASN LEU          
SEQRES   2 A  127  GLN VAL LEU LYS PHE HIS TYR PRO GLU ILE GLU SER ILE          
SEQRES   3 A  127  ILE ASP ILE ALA SER HIS VAL ALA VAL TYR GLN PHE ASP          
SEQRES   4 A  127  VAL GLY SER GLN LYS TRP LEU LYS THR SER ILE GLU GLY          
SEQRES   5 A  127  THR PHE PHE LEU VAL LYS ASP GLN ARG ALA ARG VAL GLY          
SEQRES   6 A  127  TYR VAL ILE LEU ASN ARG ASN SER PRO GLU ASN LEU TYR          
SEQRES   7 A  127  LEU PHE ILE ASN HIS PRO SER ASN VAL HIS LEU VAL ASP          
SEQRES   8 A  127  ARG TYR LEU ILE HIS ARG THR GLU ASN GLN HIS VAL VAL          
SEQRES   9 A  127  GLY LEU TRP MET PHE ASP PRO ASN ASP MET SER ARG ILE          
SEQRES  10 A  127  PHE ASN ILE VAL LYS GLU SER LEU LEU ARG                      
SEQRES   1 B  266  MET SER PHE THR ASN ALA THR PHE SER GLN VAL LEU ASP          
SEQRES   2 B  266  ASP LEU SER ALA ARG PHE ILE LEU ASN LEU PRO ALA GLU          
SEQRES   3 B  266  GLU GLN SER SER VAL GLU ARG LEU CYS PHE GLN ILE GLU          
SEQRES   4 B  266  GLN ALA HIS TRP PHE TYR GLU ASP PHE ILE ARG ALA GLN          
SEQRES   5 B  266  ASN ASP GLN LEU PRO SER LEU GLY LEU ARG VAL PHE SER          
SEQRES   6 B  266  ALA LYS LEU PHE ALA HIS CYS PRO LEU LEU TRP LYS TRP          
SEQRES   7 B  266  SER LYS VAL HIS GLU GLU ALA PHE ASP ASP PHE LEU ARG          
SEQRES   8 B  266  TYR LYS THR ARG ILE PRO VAL ARG GLY ALA ILE MET LEU          
SEQRES   9 B  266  ASP MET SER MET GLN GLN CYS VAL LEU VAL LYS GLY TRP          
SEQRES  10 B  266  LYS ALA SER SER GLY TRP GLY PHE PRO LYS GLY LYS ILE          
SEQRES  11 B  266  ASP LYS ASP GLU SER ASP VAL ASP CYS ALA ILE ARG GLU          
SEQRES  12 B  266  VAL TYR GLU GLU THR GLY PHE ASP CYS SER SER ARG ILE          
SEQRES  13 B  266  ASN PRO ASN GLU PHE ILE ASP MET THR ILE ARG GLY GLN          
SEQRES  14 B  266  ASN VAL ARG LEU TYR ILE ILE PRO GLY ILE SER LEU ASP          
SEQRES  15 B  266  THR ARG PHE GLU SER ARG THR ARG LYS GLU ILE SER LYS          
SEQRES  16 B  266  ILE GLU TRP HIS ASN LEU MET ASP LEU PRO THR PHE LYS          
SEQRES  17 B  266  LYS ASN LYS PRO GLN THR MET LYS ASN LYS PHE TYR MET          
SEQRES  18 B  266  VAL ILE PRO PHE LEU ALA PRO LEU LYS LYS TRP ILE LYS          
SEQRES  19 B  266  LYS ARG ASN ILE ALA ASN ASN THR THR LYS GLU LYS ASN          
SEQRES  20 B  266  ILE SER VAL ASP VAL ASP ALA ASP ALA SER SER GLN LEU          
SEQRES  21 B  266  LEU SER LEU LEU LYS SER                                      
SEQRES   1 C  127  MET GLU ASP GLU ASN ILE LEU ARG ASN ALA VAL ASN LEU          
SEQRES   2 C  127  GLN VAL LEU LYS PHE HIS TYR PRO GLU ILE GLU SER ILE          
SEQRES   3 C  127  ILE ASP ILE ALA SER HIS VAL ALA VAL TYR GLN PHE ASP          
SEQRES   4 C  127  VAL GLY SER GLN LYS TRP LEU LYS THR SER ILE GLU GLY          
SEQRES   5 C  127  THR PHE PHE LEU VAL LYS ASP GLN ARG ALA ARG VAL GLY          
SEQRES   6 C  127  TYR VAL ILE LEU ASN ARG ASN SER PRO GLU ASN LEU TYR          
SEQRES   7 C  127  LEU PHE ILE ASN HIS PRO SER ASN VAL HIS LEU VAL ASP          
SEQRES   8 C  127  ARG TYR LEU ILE HIS ARG THR GLU ASN GLN HIS VAL VAL          
SEQRES   9 C  127  GLY LEU TRP MET PHE ASP PRO ASN ASP MET SER ARG ILE          
SEQRES  10 C  127  PHE ASN ILE VAL LYS GLU SER LEU LEU ARG                      
SEQRES   1 D  266  MET SER PHE THR ASN ALA THR PHE SER GLN VAL LEU ASP          
SEQRES   2 D  266  ASP LEU SER ALA ARG PHE ILE LEU ASN LEU PRO ALA GLU          
SEQRES   3 D  266  GLU GLN SER SER VAL GLU ARG LEU CYS PHE GLN ILE GLU          
SEQRES   4 D  266  GLN ALA HIS TRP PHE TYR GLU ASP PHE ILE ARG ALA GLN          
SEQRES   5 D  266  ASN ASP GLN LEU PRO SER LEU GLY LEU ARG VAL PHE SER          
SEQRES   6 D  266  ALA LYS LEU PHE ALA HIS CYS PRO LEU LEU TRP LYS TRP          
SEQRES   7 D  266  SER LYS VAL HIS GLU GLU ALA PHE ASP ASP PHE LEU ARG          
SEQRES   8 D  266  TYR LYS THR ARG ILE PRO VAL ARG GLY ALA ILE MET LEU          
SEQRES   9 D  266  ASP MET SER MET GLN GLN CYS VAL LEU VAL LYS GLY TRP          
SEQRES  10 D  266  LYS ALA SER SER GLY TRP GLY PHE PRO LYS GLY LYS ILE          
SEQRES  11 D  266  ASP LYS ASP GLU SER ASP VAL ASP CYS ALA ILE ARG GLU          
SEQRES  12 D  266  VAL TYR GLU GLU THR GLY PHE ASP CYS SER SER ARG ILE          
SEQRES  13 D  266  ASN PRO ASN GLU PHE ILE ASP MET THR ILE ARG GLY GLN          
SEQRES  14 D  266  ASN VAL ARG LEU TYR ILE ILE PRO GLY ILE SER LEU ASP          
SEQRES  15 D  266  THR ARG PHE GLU SER ARG THR ARG LYS GLU ILE SER LYS          
SEQRES  16 D  266  ILE GLU TRP HIS ASN LEU MET ASP LEU PRO THR PHE LYS          
SEQRES  17 D  266  LYS ASN LYS PRO GLN THR MET LYS ASN LYS PHE TYR MET          
SEQRES  18 D  266  VAL ILE PRO PHE LEU ALA PRO LEU LYS LYS TRP ILE LYS          
SEQRES  19 D  266  LYS ARG ASN ILE ALA ASN ASN THR THR LYS GLU LYS ASN          
SEQRES  20 D  266  ILE SER VAL ASP VAL ASP ALA ASP ALA SER SER GLN LEU          
SEQRES  21 D  266  LEU SER LEU LEU LYS SER                                      
SEQRES   1 E  127  MET GLU ASP GLU ASN ILE LEU ARG ASN ALA VAL ASN LEU          
SEQRES   2 E  127  GLN VAL LEU LYS PHE HIS TYR PRO GLU ILE GLU SER ILE          
SEQRES   3 E  127  ILE ASP ILE ALA SER HIS VAL ALA VAL TYR GLN PHE ASP          
SEQRES   4 E  127  VAL GLY SER GLN LYS TRP LEU LYS THR SER ILE GLU GLY          
SEQRES   5 E  127  THR PHE PHE LEU VAL LYS ASP GLN ARG ALA ARG VAL GLY          
SEQRES   6 E  127  TYR VAL ILE LEU ASN ARG ASN SER PRO GLU ASN LEU TYR          
SEQRES   7 E  127  LEU PHE ILE ASN HIS PRO SER ASN VAL HIS LEU VAL ASP          
SEQRES   8 E  127  ARG TYR LEU ILE HIS ARG THR GLU ASN GLN HIS VAL VAL          
SEQRES   9 E  127  GLY LEU TRP MET PHE ASP PRO ASN ASP MET SER ARG ILE          
SEQRES  10 E  127  PHE ASN ILE VAL LYS GLU SER LEU LEU ARG                      
SEQRES   1 F  266  MET SER PHE THR ASN ALA THR PHE SER GLN VAL LEU ASP          
SEQRES   2 F  266  ASP LEU SER ALA ARG PHE ILE LEU ASN LEU PRO ALA GLU          
SEQRES   3 F  266  GLU GLN SER SER VAL GLU ARG LEU CYS PHE GLN ILE GLU          
SEQRES   4 F  266  GLN ALA HIS TRP PHE TYR GLU ASP PHE ILE ARG ALA GLN          
SEQRES   5 F  266  ASN ASP GLN LEU PRO SER LEU GLY LEU ARG VAL PHE SER          
SEQRES   6 F  266  ALA LYS LEU PHE ALA HIS CYS PRO LEU LEU TRP LYS TRP          
SEQRES   7 F  266  SER LYS VAL HIS GLU GLU ALA PHE ASP ASP PHE LEU ARG          
SEQRES   8 F  266  TYR LYS THR ARG ILE PRO VAL ARG GLY ALA ILE MET LEU          
SEQRES   9 F  266  ASP MET SER MET GLN GLN CYS VAL LEU VAL LYS GLY TRP          
SEQRES  10 F  266  LYS ALA SER SER GLY TRP GLY PHE PRO LYS GLY LYS ILE          
SEQRES  11 F  266  ASP LYS ASP GLU SER ASP VAL ASP CYS ALA ILE ARG GLU          
SEQRES  12 F  266  VAL TYR GLU GLU THR GLY PHE ASP CYS SER SER ARG ILE          
SEQRES  13 F  266  ASN PRO ASN GLU PHE ILE ASP MET THR ILE ARG GLY GLN          
SEQRES  14 F  266  ASN VAL ARG LEU TYR ILE ILE PRO GLY ILE SER LEU ASP          
SEQRES  15 F  266  THR ARG PHE GLU SER ARG THR ARG LYS GLU ILE SER LYS          
SEQRES  16 F  266  ILE GLU TRP HIS ASN LEU MET ASP LEU PRO THR PHE LYS          
SEQRES  17 F  266  LYS ASN LYS PRO GLN THR MET LYS ASN LYS PHE TYR MET          
SEQRES  18 F  266  VAL ILE PRO PHE LEU ALA PRO LEU LYS LYS TRP ILE LYS          
SEQRES  19 F  266  LYS ARG ASN ILE ALA ASN ASN THR THR LYS GLU LYS ASN          
SEQRES  20 F  266  ILE SER VAL ASP VAL ASP ALA ASP ALA SER SER GLN LEU          
SEQRES  21 F  266  LEU SER LEU LEU LYS SER                                      
SEQRES   1 G  127  MET GLU ASP GLU ASN ILE LEU ARG ASN ALA VAL ASN LEU          
SEQRES   2 G  127  GLN VAL LEU LYS PHE HIS TYR PRO GLU ILE GLU SER ILE          
SEQRES   3 G  127  ILE ASP ILE ALA SER HIS VAL ALA VAL TYR GLN PHE ASP          
SEQRES   4 G  127  VAL GLY SER GLN LYS TRP LEU LYS THR SER ILE GLU GLY          
SEQRES   5 G  127  THR PHE PHE LEU VAL LYS ASP GLN ARG ALA ARG VAL GLY          
SEQRES   6 G  127  TYR VAL ILE LEU ASN ARG ASN SER PRO GLU ASN LEU TYR          
SEQRES   7 G  127  LEU PHE ILE ASN HIS PRO SER ASN VAL HIS LEU VAL ASP          
SEQRES   8 G  127  ARG TYR LEU ILE HIS ARG THR GLU ASN GLN HIS VAL VAL          
SEQRES   9 G  127  GLY LEU TRP MET PHE ASP PRO ASN ASP MET SER ARG ILE          
SEQRES  10 G  127  PHE ASN ILE VAL LYS GLU SER LEU LEU ARG                      
SEQRES   1 H  266  MET SER PHE THR ASN ALA THR PHE SER GLN VAL LEU ASP          
SEQRES   2 H  266  ASP LEU SER ALA ARG PHE ILE LEU ASN LEU PRO ALA GLU          
SEQRES   3 H  266  GLU GLN SER SER VAL GLU ARG LEU CYS PHE GLN ILE GLU          
SEQRES   4 H  266  GLN ALA HIS TRP PHE TYR GLU ASP PHE ILE ARG ALA GLN          
SEQRES   5 H  266  ASN ASP GLN LEU PRO SER LEU GLY LEU ARG VAL PHE SER          
SEQRES   6 H  266  ALA LYS LEU PHE ALA HIS CYS PRO LEU LEU TRP LYS TRP          
SEQRES   7 H  266  SER LYS VAL HIS GLU GLU ALA PHE ASP ASP PHE LEU ARG          
SEQRES   8 H  266  TYR LYS THR ARG ILE PRO VAL ARG GLY ALA ILE MET LEU          
SEQRES   9 H  266  ASP MET SER MET GLN GLN CYS VAL LEU VAL LYS GLY TRP          
SEQRES  10 H  266  LYS ALA SER SER GLY TRP GLY PHE PRO LYS GLY LYS ILE          
SEQRES  11 H  266  ASP LYS ASP GLU SER ASP VAL ASP CYS ALA ILE ARG GLU          
SEQRES  12 H  266  VAL TYR GLU GLU THR GLY PHE ASP CYS SER SER ARG ILE          
SEQRES  13 H  266  ASN PRO ASN GLU PHE ILE ASP MET THR ILE ARG GLY GLN          
SEQRES  14 H  266  ASN VAL ARG LEU TYR ILE ILE PRO GLY ILE SER LEU ASP          
SEQRES  15 H  266  THR ARG PHE GLU SER ARG THR ARG LYS GLU ILE SER LYS          
SEQRES  16 H  266  ILE GLU TRP HIS ASN LEU MET ASP LEU PRO THR PHE LYS          
SEQRES  17 H  266  LYS ASN LYS PRO GLN THR MET LYS ASN LYS PHE TYR MET          
SEQRES  18 H  266  VAL ILE PRO PHE LEU ALA PRO LEU LYS LYS TRP ILE LYS          
SEQRES  19 H  266  LYS ARG ASN ILE ALA ASN ASN THR THR LYS GLU LYS ASN          
SEQRES  20 H  266  ILE SER VAL ASP VAL ASP ALA ASP ALA SER SER GLN LEU          
SEQRES  21 H  266  LEU SER LEU LEU LYS SER                                      
HET    ATP  B 267      31                                                       
HET    ATP  F 267      31                                                       
HETNAM     ATP ADENOSINE-5'-TRIPHOSPHATE                                        
FORMUL   9  ATP    2(C10 H16 N5 O13 P3)                                         
FORMUL  11  HOH   *108(H2 O)                                                    
CRYST1   68.289  161.443   91.386  90.00  97.49  90.00 P 1 21 1      8          
ATOM   9089  N   MET G   1      39.248 -32.411  24.589  1.00100.64           N  
ATOM   9090  CA  MET G   1      38.930 -32.444  23.134  1.00100.66           C  
ATOM   9091  C   MET G   1      39.161 -31.044  22.556  1.00100.28           C  
ATOM   9092  O   MET G   1      40.280 -30.525  22.630  1.00100.22           O  
ATOM   9093  CB  MET G   1      37.488 -32.929  22.921  1.00100.76           C  
ATOM   9094  CG  MET G   1      37.290 -33.830  21.695  1.00101.21           C  
ATOM   9095  SD  MET G   1      35.714 -34.738  21.666  1.00101.16           S  
ATOM   9096  CE  MET G   1      36.003 -36.038  22.873  1.00101.60           C  
ATOM   9097  N   GLU G   2      38.114 -30.438  21.991  1.00 99.81           N  
ATOM   9098  CA  GLU G   2      38.154 -29.023  21.595  1.00 99.25           C  
ATOM   9099  C   GLU G   2      38.136 -28.148  22.847  1.00 98.55           C  
ATOM   9100  O   GLU G   2      38.669 -27.030  22.855  1.00 98.44           O  
ATOM   9101  CB  GLU G   2      36.974 -28.662  20.684  1.00 99.45           C  
ATOM   9102  CG  GLU G   2      37.028 -29.275  19.290  1.00 99.93           C  
ATOM   9103  CD  GLU G   2      36.329 -30.615  19.212  1.00100.57           C  
ATOM   9104  OE1 GLU G   2      35.076 -30.643  19.247  1.00100.76           O  
ATOM   9105  OE2 GLU G   2      37.033 -31.641  19.103  1.00100.60           O  
ATOM   9106  N   ASP G   3      37.509 -28.683  23.897  1.00 97.58           N  
ATOM   9107  CA  ASP G   3      37.496 -28.090  25.231  1.00 96.57           C  
ATOM   9108  C   ASP G   3      38.915 -27.718  25.669  1.00 95.61           C  
ATOM   9109  O   ASP G   3      39.126 -26.687  26.310  1.00 95.60           O  
ATOM   9110  CB  ASP G   3      36.885 -29.089  26.222  1.00 96.70           C  
ATOM   9111  CG  ASP G   3      35.908 -28.440  27.193  1.00 97.03           C  
ATOM   9112  OD1 ASP G   3      35.736 -28.984  28.305  1.00 97.18           O  
ATOM   9113  OD2 ASP G   3      35.301 -27.401  26.846  1.00 97.24           O  
ATOM   9114  N   GLU G   4      39.874 -28.568  25.298  1.00 94.29           N  
ATOM   9115  CA  GLU G   4      41.285 -28.378  25.624  1.00 92.83           C  
ATOM   9116  C   GLU G   4      41.908 -27.239  24.812  1.00 91.52           C  
ATOM   9117  O   GLU G   4      42.708 -26.464  25.343  1.00 91.50           O  
ATOM   9118  CB  GLU G   4      42.063 -29.684  25.405  1.00 92.87           C  
ATOM   9119  CG  GLU G   4      43.297 -29.838  26.292  1.00 92.99           C  
ATOM   9120  CD  GLU G   4      44.089 -31.112  26.009  1.00 93.13           C  
ATOM   9121  OE1 GLU G   4      44.656 -31.681  26.966  1.00 93.29           O  
ATOM   9122  OE2 GLU G   4      44.153 -31.544  24.837  1.00 93.39           O  
ATOM   9123  N   ASN G   5      41.536 -27.137  23.537  1.00 89.74           N  
ATOM   9124  CA  ASN G   5      42.079 -26.098  22.659  1.00 87.99           C  
ATOM   9125  C   ASN G   5      41.646 -24.678  23.022  1.00 86.74           C  
ATOM   9126  O   ASN G   5      42.399 -23.724  22.802  1.00 86.59           O  
ATOM   9127  CB  ASN G   5      41.784 -26.403  21.189  1.00 88.01           C  
ATOM   9128  CG  ASN G   5      42.950 -27.074  20.491  1.00 87.69           C  
ATOM   9129  OD1 ASN G   5      43.900 -26.414  20.067  1.00 87.37           O  
ATOM   9130  ND2 ASN G   5      42.880 -28.390  20.361  1.00 87.40           N  
ATOM   9131  N   ILE G   6      40.439 -24.549  23.576  1.00 85.07           N  
ATOM   9132  CA  ILE G   6      39.959 -23.270  24.103  1.00 83.45           C  
ATOM   9133  C   ILE G   6      40.893 -22.829  25.221  1.00 82.19           C  
ATOM   9134  O   ILE G   6      41.316 -21.673  25.269  1.00 82.13           O  
ATOM   9135  CB  ILE G   6      38.508 -23.358  24.664  1.00 83.64           C  
ATOM   9136  CG1 ILE G   6      37.522 -23.892  23.609  1.00 83.62           C  
ATOM   9137  CG2 ILE G   6      38.056 -22.001  25.246  1.00 83.45           C  
ATOM   9138  CD1 ILE G   6      37.217 -22.939  22.444  1.00 83.62           C  
ATOM   9139  N   LEU G   7      41.219 -23.772  26.103  1.00 80.44           N  
ATOM   9140  CA  LEU G   7      42.108 -23.515  27.229  1.00 78.70           C  
ATOM   9141  C   LEU G   7      43.500 -23.066  26.787  1.00 77.36           C  
ATOM   9142  O   LEU G   7      43.966 -22.022  27.244  1.00 77.34           O  
ATOM   9143  CB  LEU G   7      42.179 -24.727  28.165  1.00 78.81           C  
ATOM   9144  CG  LEU G   7      40.867 -25.184  28.818  1.00 78.81           C  
ATOM   9145  CD1 LEU G   7      41.088 -26.479  29.579  1.00 78.77           C  
ATOM   9146  CD2 LEU G   7      40.261 -24.114  29.732  1.00 78.85           C  
ATOM   9147  N   ARG G   8      44.149 -23.824  25.897  1.00 75.54           N  
ATOM   9148  CA  ARG G   8      45.462 -23.427  25.370  1.00 73.96           C  
ATOM   9149  C   ARG G   8      45.414 -21.976  24.913  1.00 72.82           C  
ATOM   9150  O   ARG G   8      46.200 -21.151  25.375  1.00 72.67           O  
ATOM   9151  CB  ARG G   8      45.925 -24.302  24.194  1.00 74.06           C  
ATOM   9152  CG  ARG G   8      46.164 -25.769  24.507  1.00 74.48           C  
ATOM   9153  CD  ARG G   8      47.187 -26.396  23.566  1.00 74.84           C  
ATOM   9154  NE  ARG G   8      46.909 -26.110  22.161  1.00 76.03           N  
ATOM   9155  CZ  ARG G   8      47.735 -26.390  21.149  1.00 77.17           C  
ATOM   9156  NH1 ARG G   8      48.909 -26.972  21.369  1.00 76.74           N  
ATOM   9157  NH2 ARG G   8      47.391 -26.082  19.902  1.00 77.20           N  
ATOM   9158  N   ASN G   9      44.470 -21.669  24.024  1.00 71.26           N  
ATOM   9159  CA  ASN G   9      44.341 -20.329  23.475  1.00 69.74           C  
ATOM   9160  C   ASN G   9      44.038 -19.273  24.539  1.00 68.43           C  
ATOM   9161  O   ASN G   9      44.600 -18.177  24.505  1.00 68.26           O  
ATOM   9162  CB  ASN G   9      43.287 -20.299  22.371  1.00 69.95           C  
ATOM   9163  CG  ASN G   9      43.606 -19.279  21.286  1.00 70.66           C  
ATOM   9164  OD1 ASN G   9      43.453 -18.068  21.476  1.00 70.68           O  
ATOM   9165  ND2 ASN G   9      44.052 -19.771  20.136  1.00 71.91           N  
ATOM   9166  N   ALA G  10      43.160 -19.611  25.484  1.00 66.81           N  
ATOM   9167  CA  ALA G  10      42.803 -18.708  26.576  1.00 65.07           C  
ATOM   9168  C   ALA G  10      44.044 -18.305  27.369  1.00 64.16           C  
ATOM   9169  O   ALA G  10      44.242 -17.119  27.661  1.00 63.94           O  
ATOM   9170  CB  ALA G  10      41.767 -19.348  27.478  1.00 65.09           C  
ATOM   9171  N   VAL G  11      44.879 -19.298  27.691  1.00 62.78           N  
ATOM   9172  CA  VAL G  11      46.162 -19.069  28.362  1.00 61.50           C  
ATOM   9173  C   VAL G  11      47.164 -18.346  27.441  1.00 60.80           C  
ATOM   9174  O   VAL G  11      47.712 -17.308  27.821  1.00 60.75           O  
ATOM   9175  CB  VAL G  11      46.792 -20.384  28.923  1.00 61.48           C  
ATOM   9176  CG1 VAL G  11      48.106 -20.090  29.639  1.00 61.21           C  
ATOM   9177  CG2 VAL G  11      45.829 -21.109  29.869  1.00 61.10           C  
ATOM   9178  N   ASN G  12      47.392 -18.885  26.242  1.00 59.72           N  
ATOM   9179  CA  ASN G  12      48.316 -18.275  25.280  1.00 58.88           C  
ATOM   9180  C   ASN G  12      48.074 -16.776  25.163  1.00 58.60           C  
ATOM   9181  O   ASN G  12      49.013 -15.978  25.199  1.00 58.57           O  
ATOM   9182  CB  ASN G  12      48.184 -18.926  23.896  1.00 58.85           C  
ATOM   9183  CG  ASN G  12      48.990 -20.215  23.764  1.00 58.05           C  
ATOM   9184  OD1 ASN G  12      50.093 -20.322  24.285  1.00 58.51           O  
ATOM   9185  ND2 ASN G  12      48.441 -21.193  23.051  1.00 57.07           N  
ATOM   9186  N   LEU G  13      46.798 -16.415  25.051  1.00 58.06           N  
ATOM   9187  CA  LEU G  13      46.366 -15.036  24.904  1.00 57.74           C  
ATOM   9188  C   LEU G  13      46.550 -14.245  26.202  1.00 57.95           C  
ATOM   9189  O   LEU G  13      46.953 -13.075  26.176  1.00 57.96           O  
ATOM   9190  CB  LEU G  13      44.903 -15.011  24.453  1.00 57.59           C  
ATOM   9191  CG  LEU G  13      44.163 -13.709  24.149  1.00 57.27           C  
ATOM   9192  CD1 LEU G  13      44.772 -12.979  22.966  1.00 57.03           C  
ATOM   9193  CD2 LEU G  13      42.701 -14.029  23.876  1.00 57.26           C  
ATOM   9194  N   GLN G  14      46.256 -14.879  27.335  1.00 57.81           N  
ATOM   9195  CA  GLN G  14      46.446 -14.232  28.631  1.00 57.87           C  
ATOM   9196  C   GLN G  14      47.913 -13.824  28.791  1.00 57.63           C  
ATOM   9197  O   GLN G  14      48.217 -12.718  29.233  1.00 57.56           O  
ATOM   9198  CB  GLN G  14      46.003 -15.160  29.770  1.00 58.01           C  
ATOM   9199  CG  GLN G  14      45.526 -14.447  31.026  1.00 58.88           C  
ATOM   9200  CD  GLN G  14      46.638 -13.667  31.717  1.00 60.81           C  
ATOM   9201  OE1 GLN G  14      47.485 -14.238  32.430  1.00 60.24           O  
ATOM   9202  NE2 GLN G  14      46.643 -12.349  31.501  1.00 60.78           N  
ATOM   9203  N   VAL G  15      48.809 -14.726  28.405  1.00 57.54           N  
ATOM   9204  CA  VAL G  15      50.251 -14.486  28.428  1.00 57.33           C  
ATOM   9205  C   VAL G  15      50.678 -13.349  27.485  1.00 57.24           C  
ATOM   9206  O   VAL G  15      51.458 -12.476  27.866  1.00 57.26           O  
ATOM   9207  CB  VAL G  15      51.009 -15.771  28.061  1.00 57.17           C  
ATOM   9208  CG1 VAL G  15      52.492 -15.503  27.916  1.00 57.29           C  
ATOM   9209  CG2 VAL G  15      50.765 -16.828  29.108  1.00 57.55           C  
ATOM   9210  N   LEU G  16      50.168 -13.360  26.260  1.00 56.91           N  
ATOM   9211  CA  LEU G  16      50.571 -12.365  25.285  1.00 56.99           C  
ATOM   9212  C   LEU G  16      50.227 -10.941  25.727  1.00 57.33           C  
ATOM   9213  O   LEU G  16      51.066 -10.037  25.634  1.00 57.34           O  
ATOM   9214  CB  LEU G  16      49.937 -12.663  23.939  1.00 56.81           C  
ATOM   9215  CG  LEU G  16      50.494 -13.801  23.099  1.00 56.63           C  
ATOM   9216  CD1 LEU G  16      49.493 -14.094  22.005  1.00 55.93           C  
ATOM   9217  CD2 LEU G  16      51.854 -13.442  22.520  1.00 55.96           C  
ATOM   9218  N   LYS G  17      48.993 -10.761  26.207  1.00 57.63           N  
ATOM   9219  CA  LYS G  17      48.516  -9.488  26.766  1.00 57.60           C  
ATOM   9220  C   LYS G  17      49.400  -9.002  27.905  1.00 57.67           C  
ATOM   9221  O   LYS G  17      49.650  -7.808  28.031  1.00 57.65           O  
ATOM   9222  CB  LYS G  17      47.068  -9.613  27.245  1.00 57.54           C  
ATOM   9223  CG  LYS G  17      46.049  -9.583  26.124  1.00 58.11           C  
ATOM   9224  CD  LYS G  17      44.664  -9.993  26.582  1.00 58.47           C  
ATOM   9225  CE  LYS G  17      43.725 -10.061  25.383  1.00 59.39           C  
ATOM   9226  NZ  LYS G  17      42.276 -10.165  25.757  1.00 60.18           N  
ATOM   9227  N   PHE G  18      49.884  -9.932  28.724  1.00 57.92           N  
ATOM   9228  CA  PHE G  18      50.763  -9.577  29.836  1.00 58.07           C  
ATOM   9229  C   PHE G  18      52.001  -8.831  29.355  1.00 58.10           C  
ATOM   9230  O   PHE G  18      52.376  -7.812  29.918  1.00 58.23           O  
ATOM   9231  CB  PHE G  18      51.163 -10.808  30.641  1.00 58.00           C  
ATOM   9232  CG  PHE G  18      52.228 -10.538  31.648  1.00 58.32           C  
ATOM   9233  CD1 PHE G  18      51.923  -9.898  32.847  1.00 58.53           C  
ATOM   9234  CD2 PHE G  18      53.546 -10.908  31.399  1.00 58.63           C  
ATOM   9235  CE1 PHE G  18      52.915  -9.638  33.787  1.00 58.76           C  
ATOM   9236  CE2 PHE G  18      54.551 -10.649  32.337  1.00 58.77           C  
ATOM   9237  CZ  PHE G  18      54.237 -10.016  33.530  1.00 58.61           C  
ATOM   9238  N   HIS G  19      52.625  -9.339  28.304  1.00 58.35           N  
ATOM   9239  CA  HIS G  19      53.795  -8.686  27.748  1.00 58.60           C  
ATOM   9240  C   HIS G  19      53.429  -7.524  26.831  1.00 58.70           C  
ATOM   9241  O   HIS G  19      54.171  -6.547  26.745  1.00 58.63           O  
ATOM   9242  CB  HIS G  19      54.679  -9.713  27.054  1.00 58.63           C  
ATOM   9243  CG  HIS G  19      55.186 -10.769  27.982  1.00 59.07           C  
ATOM   9244  ND1 HIS G  19      56.256 -10.562  28.830  1.00 59.29           N  
ATOM   9245  CD2 HIS G  19      54.740 -12.021  28.237  1.00 59.06           C  
ATOM   9246  CE1 HIS G  19      56.462 -11.651  29.548  1.00 59.34           C  
ATOM   9247  NE2 HIS G  19      55.557 -12.551  29.206  1.00 59.69           N  
ATOM   9248  N   TYR G  20      52.275  -7.630  26.171  1.00 58.94           N  
ATOM   9249  CA  TYR G  20      51.796  -6.617  25.224  1.00 58.97           C  
ATOM   9250  C   TYR G  20      50.272  -6.454  25.326  1.00 59.38           C  
ATOM   9251  O   TYR G  20      49.529  -7.127  24.612  1.00 59.58           O  
ATOM   9252  CB  TYR G  20      52.191  -7.000  23.790  1.00 58.47           C  
ATOM   9253  CG  TYR G  20      53.680  -7.181  23.559  1.00 57.51           C  
ATOM   9254  CD1 TYR G  20      54.269  -8.448  23.618  1.00 57.12           C  
ATOM   9255  CD2 TYR G  20      54.497  -6.087  23.270  1.00 56.56           C  
ATOM   9256  CE1 TYR G  20      55.641  -8.615  23.400  1.00 56.63           C  
ATOM   9257  CE2 TYR G  20      55.860  -6.240  23.050  1.00 56.32           C  
ATOM   9258  CZ  TYR G  20      56.422  -7.504  23.115  1.00 57.05           C  
ATOM   9259  OH  TYR G  20      57.768  -7.647  22.894  1.00 57.62           O  
ATOM   9260  N   PRO G  21      49.797  -5.542  26.199  1.00 59.82           N  
ATOM   9261  CA  PRO G  21      48.369  -5.494  26.565  1.00 60.19           C  
ATOM   9262  C   PRO G  21      47.377  -5.344  25.393  1.00 60.63           C  
ATOM   9263  O   PRO G  21      46.200  -5.702  25.526  1.00 60.47           O  
ATOM   9264  CB  PRO G  21      48.294  -4.290  27.513  1.00 59.97           C  
ATOM   9265  CG  PRO G  21      49.669  -4.135  28.038  1.00 59.54           C  
ATOM   9266  CD  PRO G  21      50.563  -4.491  26.895  1.00 59.79           C  
ATOM   9267  N   GLU G  22      47.862  -4.837  24.263  1.00 61.18           N  
ATOM   9268  CA  GLU G  22      47.024  -4.576  23.096  1.00 61.97           C  
ATOM   9269  C   GLU G  22      46.453  -5.850  22.449  1.00 62.05           C  
ATOM   9270  O   GLU G  22      45.299  -6.206  22.695  1.00 62.58           O  
ATOM   9271  CB  GLU G  22      47.797  -3.743  22.069  1.00 61.94           C  
ATOM   9272  CG  GLU G  22      48.135  -2.326  22.537  1.00 62.54           C  
ATOM   9273  CD  GLU G  22      48.980  -1.576  21.524  1.00 62.64           C  
ATOM   9274  OE1 GLU G  22      49.849  -2.224  20.897  1.00 63.31           O  
ATOM   9275  OE2 GLU G  22      48.775  -0.349  21.354  1.00 63.32           O  
ATOM   9276  N   ILE G  23      47.268  -6.522  21.635  1.00 61.80           N  
ATOM   9277  CA  ILE G  23      46.870  -7.715  20.864  1.00 61.68           C  
ATOM   9278  C   ILE G  23      45.357  -8.064  20.793  1.00 61.40           C  
ATOM   9279  O   ILE G  23      44.678  -7.700  19.831  1.00 61.29           O  
ATOM   9280  CB  ILE G  23      47.735  -8.956  21.221  1.00 61.85           C  
ATOM   9281  CG1 ILE G  23      47.588  -9.303  22.697  1.00 62.67           C  
ATOM   9282  CG2 ILE G  23      49.223  -8.709  20.882  1.00 61.75           C  
ATOM   9283  CD1 ILE G  23      47.846 -10.753  22.991  1.00 62.97           C  
ATOM   9284  N   GLU G  24      44.830  -8.774  21.785  1.00 61.13           N  
ATOM   9285  CA  GLU G  24      43.401  -9.125  21.780  1.00 61.02           C  
ATOM   9286  C   GLU G  24      43.010 -10.275  20.816  1.00 60.26           C  
ATOM   9287  O   GLU G  24      41.914 -10.825  20.933  1.00 60.18           O  
ATOM   9288  CB  GLU G  24      42.550  -7.851  21.577  1.00 61.46           C  
ATOM   9289  CG  GLU G  24      41.084  -8.025  21.157  1.00 63.06           C  
ATOM   9290  CD  GLU G  24      40.903  -8.196  19.657  1.00 64.08           C  
ATOM   9291  OE1 GLU G  24      41.902  -8.122  18.906  1.00 65.42           O  
ATOM   9292  OE2 GLU G  24      39.751  -8.413  19.233  1.00 64.49           O  
ATOM   9293  N   SER G  25      43.899 -10.656  19.895  1.00 59.47           N  
ATOM   9294  CA  SER G  25      43.635 -11.815  19.024  1.00 58.75           C  
ATOM   9295  C   SER G  25      44.848 -12.624  18.535  1.00 58.26           C  
ATOM   9296  O   SER G  25      45.851 -12.058  18.089  1.00 58.16           O  
ATOM   9297  CB  SER G  25      42.817 -11.390  17.815  1.00 58.82           C  
ATOM   9298  OG  SER G  25      42.516 -12.522  17.029  1.00 59.45           O  
ATOM   9299  N   ILE G  26      44.725 -13.953  18.597  1.00 57.52           N  
ATOM   9300  CA  ILE G  26      45.720 -14.874  18.032  1.00 56.86           C  
ATOM   9301  C   ILE G  26      45.215 -15.487  16.730  1.00 56.41           C  
ATOM   9302  O   ILE G  26      44.132 -16.069  16.686  1.00 56.49           O  
ATOM   9303  CB  ILE G  26      46.082 -16.016  19.009  1.00 56.87           C  
ATOM   9304  CG1 ILE G  26      46.938 -15.491  20.166  1.00 56.90           C  
ATOM   9305  CG2 ILE G  26      46.833 -17.113  18.292  1.00 56.90           C  
ATOM   9306  CD1 ILE G  26      47.263 -16.538  21.233  1.00 56.74           C  
ATOM   9307  N   ILE G  27      46.010 -15.365  15.673  1.00 55.85           N  
ATOM   9308  CA  ILE G  27      45.605 -15.861  14.368  1.00 55.34           C  
ATOM   9309  C   ILE G  27      46.086 -17.290  14.108  1.00 55.14           C  
ATOM   9310  O   ILE G  27      45.283 -18.153  13.727  1.00 55.07           O  
ATOM   9311  CB  ILE G  27      46.060 -14.928  13.234  1.00 55.38           C  
ATOM   9312  CG1 ILE G  27      45.822 -13.461  13.629  1.00 55.43           C  
ATOM   9313  CG2 ILE G  27      45.340 -15.306  11.925  1.00 55.90           C  
ATOM   9314  CD1 ILE G  27      45.874 -12.429  12.480  1.00 54.89           C  
ATOM   9315  N   ASP G  28      47.387 -17.528  14.309  1.00 54.54           N  
ATOM   9316  CA  ASP G  28      47.996 -18.841  14.083  1.00 53.98           C  
ATOM   9317  C   ASP G  28      49.333 -18.990  14.820  1.00 53.14           C  
ATOM   9318  O   ASP G  28      49.963 -17.993  15.171  1.00 53.35           O  
ATOM   9319  CB  ASP G  28      48.172 -19.105  12.579  1.00 54.26           C  
ATOM   9320  CG  ASP G  28      48.511 -20.562  12.272  1.00 55.88           C  
ATOM   9321  OD1 ASP G  28      47.900 -21.475  12.871  1.00 57.13           O  
ATOM   9322  OD2 ASP G  28      49.402 -20.805  11.430  1.00 58.36           O  
ATOM   9323  N   ILE G  29      49.756 -20.237  15.035  1.00 52.14           N  
ATOM   9324  CA  ILE G  29      50.925 -20.568  15.865  1.00 51.26           C  
ATOM   9325  C   ILE G  29      51.951 -21.489  15.166  1.00 50.79           C  
ATOM   9326  O   ILE G  29      51.589 -22.521  14.578  1.00 50.29           O  
ATOM   9327  CB  ILE G  29      50.489 -21.239  17.198  1.00 51.16           C  
ATOM   9328  CG1 ILE G  29      49.738 -20.249  18.094  1.00 51.41           C  
ATOM   9329  CG2 ILE G  29      51.689 -21.845  17.925  1.00 50.45           C  
ATOM   9330  CD1 ILE G  29      49.361 -20.814  19.470  1.00 51.20           C  
ATOM   9331  N   ALA G  30      53.224 -21.101  15.236  1.00 50.11           N  
ATOM   9332  CA  ALA G  30      54.317 -21.959  14.805  1.00 50.11           C  
ATOM   9333  C   ALA G  30      55.032 -22.440  16.059  1.00 50.43           C  
ATOM   9334  O   ALA G  30      55.628 -21.649  16.801  1.00 50.99           O  
ATOM   9335  CB  ALA G  30      55.273 -21.218  13.877  1.00 49.42           C  
ATOM   9336  N   SER G  31      54.955 -23.739  16.309  1.00 50.30           N  
ATOM   9337  CA  SER G  31      55.467 -24.311  17.551  1.00 50.77           C  
ATOM   9338  C   SER G  31      56.875 -23.831  17.957  1.00 50.44           C  
ATOM   9339  O   SER G  31      57.137 -23.608  19.144  1.00 50.50           O  
ATOM   9340  CB  SER G  31      55.417 -25.846  17.473  1.00 51.09           C  
ATOM   9341  OG  SER G  31      55.704 -26.297  16.146  1.00 52.59           O  
ATOM   9342  N   HIS G  32      57.760 -23.670  16.972  1.00 50.08           N  
ATOM   9343  CA  HIS G  32      59.174 -23.363  17.210  1.00 49.82           C  
ATOM   9344  C   HIS G  32      59.836 -22.671  16.023  1.00 49.27           C  
ATOM   9345  O   HIS G  32      60.038 -23.289  14.972  1.00 49.76           O  
ATOM   9346  CB  HIS G  32      59.937 -24.644  17.526  1.00 50.00           C  
ATOM   9347  CG  HIS G  32      61.393 -24.435  17.789  1.00 51.55           C  
ATOM   9348  ND1 HIS G  32      62.347 -25.377  17.467  1.00 53.37           N  
ATOM   9349  CD2 HIS G  32      62.061 -23.402  18.357  1.00 53.23           C  
ATOM   9350  CE1 HIS G  32      63.541 -24.932  17.817  1.00 53.37           C  
ATOM   9351  NE2 HIS G  32      63.395 -23.733  18.355  1.00 54.08           N  
ATOM   9352  N   VAL G  33      60.180 -21.398  16.205  1.00 48.30           N  
ATOM   9353  CA  VAL G  33      60.875 -20.608  15.189  1.00 47.25           C  
ATOM   9354  C   VAL G  33      62.182 -20.022  15.736  1.00 46.71           C  
ATOM   9355  O   VAL G  33      62.254 -19.597  16.885  1.00 46.45           O  
ATOM   9356  CB  VAL G  33      59.997 -19.450  14.679  1.00 47.31           C  
ATOM   9357  CG1 VAL G  33      60.768 -18.588  13.699  1.00 47.35           C  
ATOM   9358  CG2 VAL G  33      58.748 -19.974  14.030  1.00 47.19           C  
ATOM   9359  N   ALA G  34      63.205 -20.023  14.889  1.00 46.20           N  
ATOM   9360  CA  ALA G  34      64.479 -19.369  15.144  1.00 45.41           C  
ATOM   9361  C   ALA G  34      64.527 -18.127  14.276  1.00 45.32           C  
ATOM   9362  O   ALA G  34      64.097 -18.178  13.111  1.00 45.29           O  
ATOM   9363  CB  ALA G  34      65.589 -20.279  14.753  1.00 45.32           C  
ATOM   9364  N   VAL G  35      65.043 -17.025  14.828  1.00 44.83           N  
ATOM   9365  CA  VAL G  35      65.191 -15.778  14.074  1.00 44.35           C  
ATOM   9366  C   VAL G  35      66.618 -15.562  13.572  1.00 44.81           C  
ATOM   9367  O   VAL G  35      67.572 -15.717  14.330  1.00 44.61           O  
ATOM   9368  CB  VAL G  35      64.767 -14.571  14.907  1.00 44.09           C  
ATOM   9369  CG1 VAL G  35      65.032 -13.245  14.159  1.00 42.40           C  
ATOM   9370  CG2 VAL G  35      63.322 -14.697  15.280  1.00 43.77           C  
ATOM   9371  N   TYR G  36      66.749 -15.207  12.294  1.00 45.39           N  
ATOM   9372  CA  TYR G  36      68.041 -14.773  11.734  1.00 46.48           C  
ATOM   9373  C   TYR G  36      67.961 -13.312  11.331  1.00 47.56           C  
ATOM   9374  O   TYR G  36      66.879 -12.751  11.226  1.00 47.79           O  
ATOM   9375  CB  TYR G  36      68.449 -15.609  10.516  1.00 45.75           C  
ATOM   9376  CG  TYR G  36      68.835 -17.029  10.830  1.00 44.97           C  
ATOM   9377  CD1 TYR G  36      67.870 -17.961  11.184  1.00 43.35           C  
ATOM   9378  CD2 TYR G  36      70.163 -17.447  10.749  1.00 44.81           C  
ATOM   9379  CE1 TYR G  36      68.203 -19.258  11.468  1.00 43.64           C  
ATOM   9380  CE2 TYR G  36      70.510 -18.754  11.026  1.00 44.64           C  
ATOM   9381  CZ  TYR G  36      69.516 -19.655  11.390  1.00 44.59           C  
ATOM   9382  OH  TYR G  36      69.821 -20.967  11.682  1.00 45.63           O  
ATOM   9383  N   GLN G  37      69.110 -12.702  11.097  1.00 49.19           N  
ATOM   9384  CA  GLN G  37      69.155 -11.298  10.752  1.00 51.36           C  
ATOM   9385  C   GLN G  37      70.306 -11.055   9.783  1.00 52.83           C  
ATOM   9386  O   GLN G  37      71.406 -11.602   9.946  1.00 52.70           O  
ATOM   9387  CB  GLN G  37      69.340 -10.463  12.013  1.00 51.41           C  
ATOM   9388  CG  GLN G  37      68.806  -9.048  11.902  1.00 53.08           C  
ATOM   9389  CD  GLN G  37      69.289  -8.138  13.026  1.00 54.76           C  
ATOM   9390  OE1 GLN G  37      70.304  -8.419  13.687  1.00 55.37           O  
ATOM   9391  NE2 GLN G  37      68.567  -7.035  13.245  1.00 54.40           N  
ATOM   9392  N   PHE G  38      70.047 -10.255   8.754  1.00 54.69           N  
ATOM   9393  CA  PHE G  38      71.083  -9.929   7.797  1.00 56.75           C  
ATOM   9394  C   PHE G  38      71.735  -8.627   8.228  1.00 58.14           C  
ATOM   9395  O   PHE G  38      71.058  -7.617   8.404  1.00 58.40           O  
ATOM   9396  CB  PHE G  38      70.500  -9.816   6.395  1.00 56.77           C  
ATOM   9397  CG  PHE G  38      71.500  -9.406   5.354  1.00 57.22           C  
ATOM   9398  CD1 PHE G  38      72.189 -10.367   4.621  1.00 57.63           C  
ATOM   9399  CD2 PHE G  38      71.746  -8.057   5.096  1.00 57.82           C  
ATOM   9400  CE1 PHE G  38      73.109  -9.990   3.651  1.00 57.99           C  
ATOM   9401  CE2 PHE G  38      72.669  -7.671   4.128  1.00 58.08           C  
ATOM   9402  CZ  PHE G  38      73.345  -8.640   3.403  1.00 57.82           C  
ATOM   9403  N   ASP G  39      73.049  -8.650   8.404  1.00 59.91           N  
ATOM   9404  CA  ASP G  39      73.735  -7.475   8.909  1.00 61.77           C  
ATOM   9405  C   ASP G  39      74.172  -6.539   7.783  1.00 62.97           C  
ATOM   9406  O   ASP G  39      74.578  -6.994   6.704  1.00 63.23           O  
ATOM   9407  CB  ASP G  39      74.921  -7.877   9.776  1.00 61.80           C  
ATOM   9408  CG  ASP G  39      75.411  -6.744  10.635  1.00 62.42           C  
ATOM   9409  OD1 ASP G  39      75.071  -6.731  11.846  1.00 62.54           O  
ATOM   9410  OD2 ASP G  39      76.120  -5.852  10.098  1.00 63.53           O  
ATOM   9411  N   VAL G  40      74.066  -5.233   8.041  1.00 64.24           N  
ATOM   9412  CA  VAL G  40      74.547  -4.205   7.109  1.00 65.39           C  
ATOM   9413  C   VAL G  40      76.083  -4.197   7.053  1.00 65.78           C  
ATOM   9414  O   VAL G  40      76.667  -4.428   5.989  1.00 65.80           O  
ATOM   9415  CB  VAL G  40      73.957  -2.780   7.416  1.00 65.55           C  
ATOM   9416  CG1 VAL G  40      74.271  -2.318   8.849  1.00 65.86           C  
ATOM   9417  CG2 VAL G  40      74.442  -1.751   6.389  1.00 65.90           C  
ATOM   9418  N   GLY G  41      76.714  -3.943   8.201  1.00 66.36           N  
ATOM   9419  CA  GLY G  41      78.161  -4.075   8.356  1.00 67.02           C  
ATOM   9420  C   GLY G  41      78.549  -5.493   7.988  1.00 67.38           C  
ATOM   9421  O   GLY G  41      78.347  -6.430   8.776  1.00 67.45           O  
ATOM   9422  N   SER G  42      79.094  -5.634   6.777  1.00 67.50           N  
ATOM   9423  CA  SER G  42      79.315  -6.926   6.114  1.00 67.58           C  
ATOM   9424  C   SER G  42      77.994  -7.610   5.763  1.00 67.57           C  
ATOM   9425  O   SER G  42      77.128  -7.811   6.621  1.00 67.70           O  
ATOM   9426  CB  SER G  42      80.215  -7.857   6.931  1.00 67.62           C  
ATOM   9427  OG  SER G  42      80.557  -9.001   6.174  1.00 67.68           O  
ATOM   9428  N   GLN G  43      77.862  -7.964   4.490  1.00 67.40           N  
ATOM   9429  CA  GLN G  43      76.639  -8.544   3.942  1.00 67.10           C  
ATOM   9430  C   GLN G  43      76.453 -10.014   4.347  1.00 66.65           C  
ATOM   9431  O   GLN G  43      76.477 -10.908   3.498  1.00 66.93           O  
ATOM   9432  CB  GLN G  43      76.638  -8.398   2.408  1.00 67.26           C  
ATOM   9433  CG  GLN G  43      76.746  -6.962   1.907  1.00 67.54           C  
ATOM   9434  CD  GLN G  43      75.550  -6.111   2.302  1.00 67.99           C  
ATOM   9435  OE1 GLN G  43      74.468  -6.243   1.732  1.00 67.97           O  
ATOM   9436  NE2 GLN G  43      75.744  -5.230   3.281  1.00 67.87           N  
ATOM   9437  N   LYS G  44      76.253 -10.261   5.640  1.00 65.82           N  
ATOM   9438  CA  LYS G  44      76.173 -11.628   6.156  1.00 64.79           C  
ATOM   9439  C   LYS G  44      74.927 -11.845   6.987  1.00 63.80           C  
ATOM   9440  O   LYS G  44      74.538 -10.980   7.775  1.00 63.44           O  
ATOM   9441  CB  LYS G  44      77.395 -11.967   7.020  1.00 65.10           C  
ATOM   9442  CG  LYS G  44      78.752 -11.804   6.342  1.00 65.82           C  
ATOM   9443  CD  LYS G  44      79.781 -12.760   6.953  1.00 67.09           C  
ATOM   9444  CE  LYS G  44      81.191 -12.160   7.032  1.00 67.20           C  
ATOM   9445  NZ  LYS G  44      81.826 -11.953   5.706  1.00 66.72           N  
ATOM   9446  N   TRP G  45      74.309 -13.008   6.799  1.00 62.90           N  
ATOM   9447  CA  TRP G  45      73.226 -13.464   7.664  1.00 62.01           C  
ATOM   9448  C   TRP G  45      73.845 -13.927   8.974  1.00 60.77           C  
ATOM   9449  O   TRP G  45      74.761 -14.754   8.969  1.00 60.71           O  
ATOM   9450  CB  TRP G  45      72.438 -14.612   7.019  1.00 62.70           C  
ATOM   9451  CG  TRP G  45      71.369 -14.163   6.046  1.00 63.86           C  
ATOM   9452  CD1 TRP G  45      71.496 -14.023   4.689  1.00 64.69           C  
ATOM   9453  CD2 TRP G  45      70.018 -13.798   6.358  1.00 64.46           C  
ATOM   9454  NE1 TRP G  45      70.308 -13.595   4.139  1.00 64.76           N  
ATOM   9455  CE2 TRP G  45      69.387 -13.446   5.142  1.00 65.07           C  
ATOM   9456  CE3 TRP G  45      69.280 -13.728   7.543  1.00 64.34           C  
ATOM   9457  CZ2 TRP G  45      68.048 -13.034   5.083  1.00 64.73           C  
ATOM   9458  CZ3 TRP G  45      67.948 -13.316   7.483  1.00 64.03           C  
ATOM   9459  CH2 TRP G  45      67.350 -12.978   6.265  1.00 64.17           C  
ATOM   9460  N   LEU G  46      73.368 -13.375  10.088  1.00 59.05           N  
ATOM   9461  CA  LEU G  46      73.865 -13.763  11.407  1.00 57.28           C  
ATOM   9462  C   LEU G  46      72.765 -14.340  12.286  1.00 56.28           C  
ATOM   9463  O   LEU G  46      71.634 -13.851  12.298  1.00 56.10           O  
ATOM   9464  CB  LEU G  46      74.560 -12.598  12.107  1.00 57.14           C  
ATOM   9465  CG  LEU G  46      75.836 -12.042  11.468  1.00 56.96           C  
ATOM   9466  CD1 LEU G  46      76.339 -10.834  12.249  1.00 56.64           C  
ATOM   9467  CD2 LEU G  46      76.927 -13.099  11.355  1.00 56.23           C  
ATOM   9468  N   LYS G  47      73.105 -15.398  13.011  1.00 54.90           N  
ATOM   9469  CA  LYS G  47      72.141 -16.078  13.841  1.00 53.48           C  
ATOM   9470  C   LYS G  47      71.859 -15.261  15.098  1.00 52.58           C  
ATOM   9471  O   LYS G  47      72.764 -14.819  15.804  1.00 52.55           O  
ATOM   9472  CB  LYS G  47      72.623 -17.488  14.166  1.00 53.58           C  
ATOM   9473  CG  LYS G  47      71.756 -18.268  15.148  1.00 53.86           C  
ATOM   9474  CD  LYS G  47      70.463 -18.768  14.521  1.00 53.28           C  
ATOM   9475  CE  LYS G  47      69.865 -19.898  15.339  1.00 53.46           C  
ATOM   9476  NZ  LYS G  47      70.942 -20.726  15.951  1.00 54.37           N  
ATOM   9477  N   THR G  48      70.578 -15.049  15.342  1.00 51.55           N  
ATOM   9478  CA  THR G  48      70.085 -14.312  16.482  1.00 50.39           C  
ATOM   9479  C   THR G  48      69.938 -15.321  17.607  1.00 49.95           C  
ATOM   9480  O   THR G  48      69.993 -16.520  17.355  1.00 49.77           O  
ATOM   9481  CB  THR G  48      68.740 -13.663  16.085  1.00 50.45           C  
ATOM   9482  OG1 THR G  48      68.954 -12.306  15.671  1.00 50.16           O  
ATOM   9483  CG2 THR G  48      67.745 -13.699  17.190  1.00 49.92           C  
ATOM   9484  N   SER G  49      69.778 -14.854  18.843  1.00 49.57           N  
ATOM   9485  CA  SER G  49      69.554 -15.762  19.981  1.00 49.00           C  
ATOM   9486  C   SER G  49      68.071 -15.942  20.343  1.00 48.73           C  
ATOM   9487  O   SER G  49      67.752 -16.614  21.321  1.00 48.79           O  
ATOM   9488  CB  SER G  49      70.288 -15.255  21.204  1.00 48.87           C  
ATOM   9489  OG  SER G  49      69.610 -14.130  21.722  1.00 49.29           O  
ATOM   9490  N   ILE G  50      67.182 -15.330  19.563  1.00 48.03           N  
ATOM   9491  CA  ILE G  50      65.749 -15.421  19.780  1.00 47.68           C  
ATOM   9492  C   ILE G  50      65.244 -16.700  19.145  1.00 47.61           C  
ATOM   9493  O   ILE G  50      65.516 -16.981  17.978  1.00 48.27           O  
ATOM   9494  CB  ILE G  50      64.999 -14.185  19.196  1.00 47.72           C  
ATOM   9495  CG1 ILE G  50      65.506 -12.890  19.856  1.00 47.94           C  
ATOM   9496  CG2 ILE G  50      63.497 -14.317  19.408  1.00 47.07           C  
ATOM   9497  CD1 ILE G  50      65.370 -11.643  19.010  1.00 47.52           C  
ATOM   9498  N   GLU G  51      64.503 -17.478  19.920  1.00 47.30           N  
ATOM   9499  CA  GLU G  51      64.069 -18.799  19.488  1.00 47.11           C  
ATOM   9500  C   GLU G  51      62.951 -19.264  20.407  1.00 46.59           C  
ATOM   9501  O   GLU G  51      63.118 -19.299  21.624  1.00 46.52           O  
ATOM   9502  CB  GLU G  51      65.259 -19.760  19.531  1.00 46.82           C  
ATOM   9503  CG  GLU G  51      64.992 -21.191  19.150  1.00 47.11           C  
ATOM   9504  CD  GLU G  51      66.276 -22.046  19.144  1.00 48.15           C  
ATOM   9505  OE1 GLU G  51      66.397 -22.923  18.255  1.00 49.33           O  
ATOM   9506  OE2 GLU G  51      67.168 -21.839  20.016  1.00 48.95           O  
ATOM   9507  N   GLY G  52      61.812 -19.610  19.821  1.00 46.14           N  
ATOM   9508  CA  GLY G  52      60.661 -20.037  20.598  1.00 45.90           C  
ATOM   9509  C   GLY G  52      59.420 -20.158  19.747  1.00 45.80           C  
ATOM   9510  O   GLY G  52      59.507 -20.206  18.523  1.00 45.60           O  
ATOM   9511  N   THR G  53      58.271 -20.217  20.414  1.00 45.88           N  
ATOM   9512  CA  THR G  53      56.968 -20.322  19.766  1.00 45.98           C  
ATOM   9513  C   THR G  53      56.643 -19.016  19.067  1.00 46.25           C  
ATOM   9514  O   THR G  53      56.974 -17.927  19.562  1.00 46.34           O  
ATOM   9515  CB  THR G  53      55.843 -20.637  20.787  1.00 46.16           C  
ATOM   9516  OG1 THR G  53      56.050 -21.935  21.379  1.00 46.53           O  
ATOM   9517  CG2 THR G  53      54.491 -20.609  20.115  1.00 46.09           C  
ATOM   9518  N   PHE G  54      55.987 -19.140  17.913  1.00 46.30           N  
ATOM   9519  CA  PHE G  54      55.645 -18.017  17.054  1.00 45.85           C  
ATOM   9520  C   PHE G  54      54.140 -17.831  17.099  1.00 46.31           C  
ATOM   9521  O   PHE G  54      53.382 -18.768  16.845  1.00 46.70           O  
ATOM   9522  CB  PHE G  54      56.109 -18.361  15.654  1.00 45.68           C  
ATOM   9523  CG  PHE G  54      55.759 -17.357  14.605  1.00 44.74           C  
ATOM   9524  CD1 PHE G  54      56.658 -16.364  14.261  1.00 44.18           C  
ATOM   9525  CD2 PHE G  54      54.559 -17.454  13.905  1.00 44.75           C  
ATOM   9526  CE1 PHE G  54      56.358 -15.453  13.254  1.00 45.13           C  
ATOM   9527  CE2 PHE G  54      54.242 -16.554  12.895  1.00 45.56           C  
ATOM   9528  CZ  PHE G  54      55.144 -15.543  12.569  1.00 45.91           C  
ATOM   9529  N   PHE G  55      53.714 -16.620  17.455  1.00 46.50           N  
ATOM   9530  CA  PHE G  55      52.304 -16.293  17.567  1.00 46.40           C  
ATOM   9531  C   PHE G  55      52.003 -15.199  16.581  1.00 46.57           C  
ATOM   9532  O   PHE G  55      52.391 -14.048  16.797  1.00 46.46           O  
ATOM   9533  CB  PHE G  55      51.976 -15.760  18.969  1.00 46.56           C  
ATOM   9534  CG  PHE G  55      52.206 -16.745  20.076  1.00 46.20           C  
ATOM   9535  CD1 PHE G  55      53.401 -16.733  20.790  1.00 46.52           C  
ATOM   9536  CD2 PHE G  55      51.229 -17.674  20.411  1.00 46.23           C  
ATOM   9537  CE1 PHE G  55      53.630 -17.640  21.819  1.00 47.21           C  
ATOM   9538  CE2 PHE G  55      51.433 -18.585  21.439  1.00 47.09           C  
ATOM   9539  CZ  PHE G  55      52.638 -18.571  22.154  1.00 47.47           C  
ATOM   9540  N   LEU G  56      51.315 -15.544  15.498  1.00 46.91           N  
ATOM   9541  CA  LEU G  56      50.827 -14.525  14.576  1.00 47.20           C  
ATOM   9542  C   LEU G  56      49.603 -13.897  15.222  1.00 47.96           C  
ATOM   9543  O   LEU G  56      48.647 -14.602  15.559  1.00 48.39           O  
ATOM   9544  CB  LEU G  56      50.485 -15.135  13.220  1.00 46.74           C  
ATOM   9545  CG  LEU G  56      50.011 -14.175  12.132  1.00 45.37           C  
ATOM   9546  CD1 LEU G  56      51.177 -13.465  11.492  1.00 44.77           C  
ATOM   9547  CD2 LEU G  56      49.258 -14.960  11.097  1.00 44.83           C  
ATOM   9548  N   VAL G  57      49.651 -12.581  15.431  1.00 48.57           N  
ATOM   9549  CA  VAL G  57      48.640 -11.902  16.241  1.00 48.95           C  
ATOM   9550  C   VAL G  57      48.074 -10.689  15.549  1.00 49.84           C  
ATOM   9551  O   VAL G  57      48.754 -10.053  14.746  1.00 49.98           O  
ATOM   9552  CB  VAL G  57      49.190 -11.420  17.605  1.00 48.79           C  
ATOM   9553  CG1 VAL G  57      49.508 -12.591  18.523  1.00 48.27           C  
ATOM   9554  CG2 VAL G  57      50.390 -10.491  17.422  1.00 48.21           C  
ATOM   9555  N   LYS G  58      46.825 -10.382  15.889  1.00 50.81           N  
ATOM   9556  CA  LYS G  58      46.142  -9.170  15.480  1.00 51.95           C  
ATOM   9557  C   LYS G  58      45.959  -8.350  16.750  1.00 52.66           C  
ATOM   9558  O   LYS G  58      45.816  -8.929  17.827  1.00 52.79           O  
ATOM   9559  CB  LYS G  58      44.776  -9.534  14.909  1.00 52.05           C  
ATOM   9560  CG  LYS G  58      44.343  -8.691  13.736  1.00 52.72           C  
ATOM   9561  CD  LYS G  58      42.830  -8.546  13.692  1.00 55.13           C  
ATOM   9562  CE  LYS G  58      42.124  -9.651  12.920  1.00 55.88           C  
ATOM   9563  NZ  LYS G  58      40.705  -9.237  12.698  1.00 56.22           N  
ATOM   9564  N   ASP G  59      45.961  -7.021  16.632  1.00 53.58           N  
ATOM   9565  CA  ASP G  59      45.838  -6.118  17.791  1.00 54.47           C  
ATOM   9566  C   ASP G  59      44.583  -5.231  17.776  1.00 55.50           C  
ATOM   9567  O   ASP G  59      43.657  -5.463  16.993  1.00 55.56           O  
ATOM   9568  CB  ASP G  59      47.107  -5.258  17.944  1.00 54.25           C  
ATOM   9569  CG  ASP G  59      47.158  -4.093  16.966  1.00 53.37           C  
ATOM   9570  OD1 ASP G  59      46.468  -4.136  15.934  1.00 52.34           O  
ATOM   9571  OD2 ASP G  59      47.891  -3.122  17.229  1.00 52.83           O  
ATOM   9572  N   GLN G  60      44.556  -4.227  18.654  1.00 56.96           N  
ATOM   9573  CA  GLN G  60      43.589  -3.126  18.541  1.00 58.39           C  
ATOM   9574  C   GLN G  60      44.004  -2.283  17.330  1.00 59.25           C  
ATOM   9575  O   GLN G  60      45.173  -1.919  17.202  1.00 59.93           O  
ATOM   9576  CB  GLN G  60      43.568  -2.241  19.796  1.00 58.44           C  
ATOM   9577  CG  GLN G  60      43.749  -2.939  21.155  1.00 59.55           C  
ATOM   9578  CD  GLN G  60      42.576  -3.825  21.583  1.00 60.51           C  
ATOM   9579  OE1 GLN G  60      42.708  -4.628  22.512  1.00 61.03           O  
ATOM   9580  NE2 GLN G  60      41.436  -3.687  20.912  1.00 60.11           N  
ATOM   9581  N   ARG G  61      43.053  -1.973  16.450  1.00 60.00           N  
ATOM   9582  CA  ARG G  61      43.349  -1.392  15.125  1.00 60.73           C  
ATOM   9583  C   ARG G  61      43.636  -2.473  14.072  1.00 60.58           C  
ATOM   9584  O   ARG G  61      44.042  -2.167  12.942  1.00 60.57           O  
ATOM   9585  CB  ARG G  61      44.511  -0.380  15.176  1.00 61.08           C  
ATOM   9586  CG  ARG G  61      44.088   1.086  15.259  1.00 62.57           C  
ATOM   9587  CD  ARG G  61      44.478   1.739  16.587  1.00 64.04           C  
ATOM   9588  NE  ARG G  61      44.062   3.145  16.613  1.00 65.34           N  
ATOM   9589  CZ  ARG G  61      44.182   3.963  17.659  1.00 65.82           C  
ATOM   9590  NH1 ARG G  61      44.711   3.529  18.796  1.00 65.96           N  
ATOM   9591  NH2 ARG G  61      43.768   5.222  17.564  1.00 66.08           N  
ATOM   9592  N   ALA G  62      43.430  -3.734  14.460  1.00 60.52           N  
ATOM   9593  CA  ALA G  62      43.552  -4.893  13.568  1.00 60.25           C  
ATOM   9594  C   ALA G  62      44.836  -4.925  12.726  1.00 60.16           C  
ATOM   9595  O   ALA G  62      44.807  -5.305  11.555  1.00 60.32           O  
ATOM   9596  CB  ALA G  62      42.304  -5.021  12.673  1.00 60.12           C  
ATOM   9597  N   ARG G  63      45.954  -4.523  13.327  1.00 59.96           N  
ATOM   9598  CA  ARG G  63      47.257  -4.591  12.671  1.00 59.92           C  
ATOM   9599  C   ARG G  63      47.777  -6.004  12.804  1.00 59.14           C  
ATOM   9600  O   ARG G  63      47.646  -6.619  13.866  1.00 59.30           O  
ATOM   9601  CB  ARG G  63      48.263  -3.636  13.319  1.00 59.96           C  
ATOM   9602  CG  ARG G  63      48.068  -2.155  13.005  1.00 60.75           C  
ATOM   9603  CD  ARG G  63      48.969  -1.291  13.898  1.00 61.50           C  
ATOM   9604  NE  ARG G  63      50.377  -1.332  13.488  1.00 64.84           N  
ATOM   9605  CZ  ARG G  63      51.378  -0.731  14.131  1.00 65.99           C  
ATOM   9606  NH1 ARG G  63      51.155  -0.030  15.242  1.00 66.79           N  
ATOM   9607  NH2 ARG G  63      52.615  -0.829  13.659  1.00 66.04           N  
ATOM   9608  N   VAL G  64      48.369  -6.525  11.737  1.00 58.11           N  
ATOM   9609  CA  VAL G  64      48.988  -7.840  11.825  1.00 57.15           C  
ATOM   9610  C   VAL G  64      50.454  -7.778  12.244  1.00 56.17           C  
ATOM   9611  O   VAL G  64      51.247  -6.999  11.706  1.00 56.34           O  
ATOM   9612  CB  VAL G  64      48.823  -8.679  10.542  1.00 57.17           C  
ATOM   9613  CG1 VAL G  64      47.670  -9.646  10.702  1.00 57.46           C  
ATOM   9614  CG2 VAL G  64      48.630  -7.788   9.317  1.00 57.58           C  
ATOM   9615  N   GLY G  65      50.788  -8.598  13.235  1.00 54.79           N  
ATOM   9616  CA  GLY G  65      52.150  -8.740  13.715  1.00 52.85           C  
ATOM   9617  C   GLY G  65      52.410 -10.140  14.239  1.00 51.48           C  
ATOM   9618  O   GLY G  65      51.520 -11.005  14.210  1.00 51.18           O  
ATOM   9619  N   TYR G  66      53.633 -10.362  14.719  1.00 50.04           N  
ATOM   9620  CA  TYR G  66      53.989 -11.639  15.306  1.00 48.92           C  
ATOM   9621  C   TYR G  66      54.837 -11.552  16.556  1.00 48.62           C  
ATOM   9622  O   TYR G  66      55.666 -10.653  16.705  1.00 48.41           O  
ATOM   9623  CB  TYR G  66      54.627 -12.577  14.280  1.00 48.55           C  
ATOM   9624  CG  TYR G  66      55.892 -12.094  13.605  1.00 47.71           C  
ATOM   9625  CD1 TYR G  66      57.128 -12.251  14.217  1.00 46.97           C  
ATOM   9626  CD2 TYR G  66      55.852 -11.521  12.326  1.00 46.98           C  
ATOM   9627  CE1 TYR G  66      58.288 -11.843  13.596  1.00 46.91           C  
ATOM   9628  CE2 TYR G  66      57.013 -11.102  11.686  1.00 46.65           C  
ATOM   9629  CZ  TYR G  66      58.231 -11.273  12.332  1.00 47.71           C  
ATOM   9630  OH  TYR G  66      59.402 -10.870  11.736  1.00 48.29           O  
ATOM   9631  N   VAL G  67      54.600 -12.498  17.458  1.00 48.26           N  
ATOM   9632  CA  VAL G  67      55.274 -12.554  18.744  1.00 47.75           C  
ATOM   9633  C   VAL G  67      55.936 -13.912  18.882  1.00 47.80           C  
ATOM   9634  O   VAL G  67      55.286 -14.963  18.706  1.00 47.73           O  
ATOM   9635  CB  VAL G  67      54.300 -12.369  19.946  1.00 47.72           C  
ATOM   9636  CG1 VAL G  67      55.079 -12.307  21.260  1.00 46.94           C  
ATOM   9637  CG2 VAL G  67      53.439 -11.131  19.768  1.00 47.13           C  
ATOM   9638  N   ILE G  68      57.230 -13.862  19.203  1.00 47.31           N  
ATOM   9639  CA  ILE G  68      58.024 -15.016  19.550  1.00 46.67           C  
ATOM   9640  C   ILE G  68      58.398 -14.905  21.035  1.00 46.36           C  
ATOM   9641  O   ILE G  68      59.170 -14.020  21.411  1.00 46.36           O  
ATOM   9642  CB  ILE G  68      59.289 -15.031  18.692  1.00 46.81           C  
ATOM   9643  CG1 ILE G  68      58.936 -15.360  17.243  1.00 46.79           C  
ATOM   9644  CG2 ILE G  68      60.342 -16.002  19.258  1.00 46.82           C  
ATOM   9645  CD1 ILE G  68      60.138 -15.333  16.294  1.00 46.21           C  
ATOM   9646  N   LEU G  69      57.838 -15.774  21.878  1.00 46.05           N  
ATOM   9647  CA  LEU G  69      58.179 -15.783  23.311  1.00 46.03           C  
ATOM   9648  C   LEU G  69      59.499 -16.509  23.471  1.00 45.97           C  
ATOM   9649  O   LEU G  69      59.547 -17.740  23.533  1.00 45.90           O  
ATOM   9650  CB  LEU G  69      57.111 -16.461  24.175  1.00 45.88           C  
ATOM   9651  CG  LEU G  69      55.696 -15.888  24.279  1.00 46.46           C  
ATOM   9652  CD1 LEU G  69      54.784 -16.856  25.023  1.00 46.35           C  
ATOM   9653  CD2 LEU G  69      55.690 -14.527  24.961  1.00 46.90           C  
ATOM   9654  N   ASN G  70      60.567 -15.726  23.538  1.00 45.71           N  
ATOM   9655  CA  ASN G  70      61.913 -16.244  23.503  1.00 45.50           C  
ATOM   9656  C   ASN G  70      62.189 -17.241  24.634  1.00 45.68           C  
ATOM   9657  O   ASN G  70      61.827 -16.990  25.783  1.00 45.67           O  
ATOM   9658  CB  ASN G  70      62.884 -15.064  23.535  1.00 45.36           C  
ATOM   9659  CG  ASN G  70      64.304 -15.466  23.222  1.00 44.76           C  
ATOM   9660  OD1 ASN G  70      64.583 -16.627  22.961  1.00 44.57           O  
ATOM   9661  ND2 ASN G  70      65.215 -14.500  23.249  1.00 44.71           N  
ATOM   9662  N   ARG G  71      62.814 -18.370  24.288  1.00 45.90           N  
ATOM   9663  CA  ARG G  71      63.207 -19.416  25.251  1.00 46.04           C  
ATOM   9664  C   ARG G  71      64.602 -19.235  25.803  1.00 46.14           C  
ATOM   9665  O   ARG G  71      64.905 -19.708  26.897  1.00 46.10           O  
ATOM   9666  CB  ARG G  71      63.131 -20.803  24.626  1.00 45.98           C  
ATOM   9667  CG  ARG G  71      61.739 -21.388  24.613  1.00 47.47           C  
ATOM   9668  CD  ARG G  71      61.722 -22.786  24.027  1.00 49.79           C  
ATOM   9669  NE  ARG G  71      60.356 -23.169  23.679  1.00 52.45           N  
ATOM   9670  CZ  ARG G  71      60.028 -24.018  22.709  1.00 53.78           C  
ATOM   9671  NH1 ARG G  71      60.966 -24.588  21.962  1.00 54.86           N  
ATOM   9672  NH2 ARG G  71      58.753 -24.286  22.477  1.00 54.49           N  
ATOM   9673  N   ASN G  72      65.461 -18.571  25.045  1.00 46.56           N  
ATOM   9674  CA  ASN G  72      66.834 -18.381  25.475  1.00 47.33           C  
ATOM   9675  C   ASN G  72      66.974 -17.299  26.540  1.00 47.65           C  
ATOM   9676  O   ASN G  72      67.836 -17.389  27.401  1.00 47.70           O  
ATOM   9677  CB  ASN G  72      67.732 -18.085  24.278  1.00 47.53           C  
ATOM   9678  CG  ASN G  72      67.823 -19.264  23.299  1.00 48.78           C  
ATOM   9679  OD1 ASN G  72      67.105 -20.271  23.436  1.00 48.47           O  
ATOM   9680  ND2 ASN G  72      68.714 -19.136  22.297  1.00 49.59           N  
ATOM   9681  N   SER G  73      66.103 -16.292  26.486  1.00 48.39           N  
ATOM   9682  CA  SER G  73      66.143 -15.138  27.396  1.00 48.59           C  
ATOM   9683  C   SER G  73      64.764 -14.477  27.443  1.00 48.86           C  
ATOM   9684  O   SER G  73      63.892 -14.824  26.643  1.00 48.66           O  
ATOM   9685  CB  SER G  73      67.205 -14.132  26.933  1.00 48.61           C  
ATOM   9686  OG  SER G  73      66.693 -13.280  25.921  1.00 48.59           O  
ATOM   9687  N   PRO G  74      64.556 -13.512  28.363  1.00 49.36           N  
ATOM   9688  CA  PRO G  74      63.216 -12.935  28.471  1.00 50.00           C  
ATOM   9689  C   PRO G  74      62.966 -11.800  27.469  1.00 50.47           C  
ATOM   9690  O   PRO G  74      61.936 -11.136  27.545  1.00 50.42           O  
ATOM   9691  CB  PRO G  74      63.181 -12.410  29.914  1.00 49.75           C  
ATOM   9692  CG  PRO G  74      64.574 -12.073  30.219  1.00 49.33           C  
ATOM   9693  CD  PRO G  74      65.482 -12.882  29.321  1.00 49.22           C  
ATOM   9694  N   GLU G  75      63.907 -11.583  26.553  1.00 51.18           N  
ATOM   9695  CA  GLU G  75      63.758 -10.575  25.517  1.00 52.23           C  
ATOM   9696  C   GLU G  75      63.058 -11.181  24.299  1.00 52.49           C  
ATOM   9697  O   GLU G  75      63.671 -11.921  23.517  1.00 52.66           O  
ATOM   9698  CB  GLU G  75      65.120  -9.997  25.121  1.00 52.18           C  
ATOM   9699  CG  GLU G  75      65.042  -8.854  24.114  1.00 53.28           C  
ATOM   9700  CD  GLU G  75      66.398  -8.408  23.613  1.00 53.32           C  
ATOM   9701  OE1 GLU G  75      67.175  -7.860  24.423  1.00 54.94           O  
ATOM   9702  OE2 GLU G  75      66.678  -8.589  22.407  1.00 54.68           O  
ATOM   9703  N   ASN G  76      61.776 -10.851  24.145  1.00 52.70           N  
ATOM   9704  CA  ASN G  76      60.958 -11.378  23.054  1.00 53.03           C  
ATOM   9705  C   ASN G  76      61.125 -10.621  21.734  1.00 53.12           C  
ATOM   9706  O   ASN G  76      61.838  -9.612  21.654  1.00 53.17           O  
ATOM   9707  CB  ASN G  76      59.473 -11.384  23.456  1.00 53.15           C  
ATOM   9708  CG  ASN G  76      59.246 -11.907  24.860  1.00 53.29           C  
ATOM   9709  OD1 ASN G  76      60.174 -12.348  25.522  1.00 53.63           O  
ATOM   9710  ND2 ASN G  76      58.008 -11.842  25.326  1.00 54.38           N  
ATOM   9711  N   LEU G  77      60.465 -11.129  20.696  1.00 53.19           N  
ATOM   9712  CA  LEU G  77      60.359 -10.404  19.442  1.00 53.13           C  
ATOM   9713  C   LEU G  77      58.901 -10.206  19.070  1.00 53.15           C  
ATOM   9714  O   LEU G  77      58.110 -11.151  19.101  1.00 53.24           O  
ATOM   9715  CB  LEU G  77      61.107 -11.119  18.325  1.00 52.97           C  
ATOM   9716  CG  LEU G  77      61.263 -10.324  17.029  1.00 53.24           C  
ATOM   9717  CD1 LEU G  77      61.862  -8.938  17.280  1.00 53.51           C  
ATOM   9718  CD2 LEU G  77      62.114 -11.105  16.044  1.00 54.16           C  
ATOM   9719  N   TYR G  78      58.560  -8.964  18.736  1.00 53.15           N  
ATOM   9720  CA  TYR G  78      57.223  -8.591  18.302  1.00 53.40           C  
ATOM   9721  C   TYR G  78      57.334  -7.587  17.169  1.00 53.39           C  
ATOM   9722  O   TYR G  78      57.632  -6.412  17.397  1.00 53.45           O  
ATOM   9723  CB  TYR G  78      56.446  -7.952  19.456  1.00 53.56           C  
ATOM   9724  CG  TYR G  78      54.984  -7.671  19.164  1.00 53.62           C  
ATOM   9725  CD1 TYR G  78      54.447  -7.838  17.886  1.00 53.54           C  
ATOM   9726  CD2 TYR G  78      54.142  -7.216  20.173  1.00 53.72           C  
ATOM   9727  CE1 TYR G  78      53.099  -7.571  17.636  1.00 54.37           C  
ATOM   9728  CE2 TYR G  78      52.802  -6.939  19.936  1.00 53.92           C  
ATOM   9729  CZ  TYR G  78      52.287  -7.117  18.672  1.00 54.08           C  
ATOM   9730  OH  TYR G  78      50.961  -6.844  18.449  1.00 54.44           O  
ATOM   9731  N   LEU G  79      57.100  -8.046  15.948  1.00 53.41           N  
ATOM   9732  CA  LEU G  79      57.178  -7.164  14.795  1.00 53.64           C  
ATOM   9733  C   LEU G  79      55.868  -7.156  14.032  1.00 54.22           C  
ATOM   9734  O   LEU G  79      55.232  -8.192  13.879  1.00 54.39           O  
ATOM   9735  CB  LEU G  79      58.318  -7.573  13.864  1.00 53.18           C  
ATOM   9736  CG  LEU G  79      59.733  -7.688  14.424  1.00 52.53           C  
ATOM   9737  CD1 LEU G  79      60.686  -8.212  13.351  1.00 51.41           C  
ATOM   9738  CD2 LEU G  79      60.218  -6.360  14.982  1.00 51.11           C  
ATOM   9739  N   PHE G  80      55.470  -5.977  13.566  1.00 55.16           N  
ATOM   9740  CA  PHE G  80      54.312  -5.828  12.682  1.00 55.83           C  
ATOM   9741  C   PHE G  80      54.700  -6.137  11.246  1.00 55.86           C  
ATOM   9742  O   PHE G  80      55.835  -5.896  10.826  1.00 55.99           O  
ATOM   9743  CB  PHE G  80      53.773  -4.404  12.737  1.00 56.18           C  
ATOM   9744  CG  PHE G  80      53.610  -3.879  14.117  1.00 57.31           C  
ATOM   9745  CD1 PHE G  80      52.416  -4.075  14.806  1.00 58.23           C  
ATOM   9746  CD2 PHE G  80      54.651  -3.184  14.736  1.00 58.66           C  
ATOM   9747  CE1 PHE G  80      52.256  -3.592  16.095  1.00 59.46           C  
ATOM   9748  CE2 PHE G  80      54.509  -2.695  16.033  1.00 59.68           C  
ATOM   9749  CZ  PHE G  80      53.306  -2.897  16.716  1.00 59.31           C  
ATOM   9750  N   ILE G  81      53.750  -6.679  10.500  1.00 55.84           N  
ATOM   9751  CA  ILE G  81      53.919  -6.851   9.073  1.00 55.98           C  
ATOM   9752  C   ILE G  81      53.053  -5.782   8.466  1.00 56.04           C  
ATOM   9753  O   ILE G  81      51.825  -5.915   8.452  1.00 56.50           O  
ATOM   9754  CB  ILE G  81      53.457  -8.247   8.602  1.00 55.91           C  
ATOM   9755  CG1 ILE G  81      54.261  -9.341   9.302  1.00 55.73           C  
ATOM   9756  CG2 ILE G  81      53.610  -8.367   7.103  1.00 55.93           C  
ATOM   9757  CD1 ILE G  81      53.528 -10.644   9.469  1.00 55.74           C  
ATOM   9758  N   ASN G  82      53.679  -4.701   8.009  1.00 56.12           N  
ATOM   9759  CA  ASN G  82      52.932  -3.550   7.479  1.00 56.21           C  
ATOM   9760  C   ASN G  82      52.147  -3.860   6.225  1.00 55.87           C  
ATOM   9761  O   ASN G  82      51.058  -3.342   6.037  1.00 56.06           O  
ATOM   9762  CB  ASN G  82      53.857  -2.367   7.207  1.00 56.48           C  
ATOM   9763  CG  ASN G  82      54.160  -1.572   8.450  1.00 57.25           C  
ATOM   9764  OD1 ASN G  82      55.180  -0.880   8.515  1.00 58.37           O  
ATOM   9765  ND2 ASN G  82      53.280  -1.664   9.453  1.00 57.42           N  
ATOM   9766  N   HIS G  83      52.716  -4.700   5.369  1.00 55.67           N  
ATOM   9767  CA  HIS G  83      52.096  -5.061   4.110  1.00 55.62           C  
ATOM   9768  C   HIS G  83      52.525  -6.456   3.648  1.00 55.43           C  
ATOM   9769  O   HIS G  83      53.698  -6.802   3.726  1.00 55.44           O  
ATOM   9770  CB  HIS G  83      52.438  -4.022   3.045  1.00 55.68           C  
ATOM   9771  CG  HIS G  83      51.600  -4.137   1.813  1.00 56.01           C  
ATOM   9772  ND1 HIS G  83      51.993  -4.868   0.712  1.00 56.04           N  
ATOM   9773  CD2 HIS G  83      50.376  -3.639   1.520  1.00 55.88           C  
ATOM   9774  CE1 HIS G  83      51.054  -4.802  -0.214  1.00 56.10           C  
ATOM   9775  NE2 HIS G  83      50.064  -4.057   0.250  1.00 56.37           N  
ATOM   9776  N   PRO G  84      51.570  -7.265   3.158  1.00 55.40           N  
ATOM   9777  CA  PRO G  84      51.905  -8.639   2.794  1.00 55.22           C  
ATOM   9778  C   PRO G  84      53.118  -8.780   1.875  1.00 55.06           C  
ATOM   9779  O   PRO G  84      53.768  -9.811   1.913  1.00 55.43           O  
ATOM   9780  CB  PRO G  84      50.635  -9.132   2.089  1.00 55.38           C  
ATOM   9781  CG  PRO G  84      49.540  -8.343   2.710  1.00 55.26           C  
ATOM   9782  CD  PRO G  84      50.138  -6.976   2.933  1.00 55.58           C  
ATOM   9783  N   SER G  85      53.431  -7.760   1.078  1.00 54.75           N  
ATOM   9784  CA  SER G  85      54.573  -7.814   0.156  1.00 54.34           C  
ATOM   9785  C   SER G  85      55.923  -7.641   0.852  1.00 54.43           C  
ATOM   9786  O   SER G  85      56.967  -7.606   0.193  1.00 54.64           O  
ATOM   9787  CB  SER G  85      54.428  -6.770  -0.960  1.00 54.56           C  
ATOM   9788  OG  SER G  85      54.672  -5.445  -0.511  1.00 53.80           O  
ATOM   9789  N   ASN G  86      55.890  -7.519   2.177  1.00 54.19           N  
ATOM   9790  CA  ASN G  86      57.084  -7.313   2.986  1.00 54.23           C  
ATOM   9791  C   ASN G  86      57.663  -8.638   3.451  1.00 53.83           C  
ATOM   9792  O   ASN G  86      58.789  -8.697   3.954  1.00 53.57           O  
ATOM   9793  CB  ASN G  86      56.764  -6.433   4.208  1.00 54.56           C  
ATOM   9794  CG  ASN G  86      56.568  -4.968   3.849  1.00 55.31           C  
ATOM   9795  OD1 ASN G  86      57.265  -4.440   2.983  1.00 57.63           O  
ATOM   9796  ND2 ASN G  86      55.625  -4.305   4.519  1.00 55.15           N  
ATOM   9797  N   VAL G  87      56.871  -9.695   3.299  1.00 53.59           N  
ATOM   9798  CA  VAL G  87      57.264 -11.034   3.732  1.00 53.32           C  
ATOM   9799  C   VAL G  87      57.514 -11.885   2.507  1.00 53.06           C  
ATOM   9800  O   VAL G  87      56.784 -11.793   1.515  1.00 53.12           O  
ATOM   9801  CB  VAL G  87      56.192 -11.714   4.610  1.00 53.32           C  
ATOM   9802  CG1 VAL G  87      56.727 -13.015   5.186  1.00 53.48           C  
ATOM   9803  CG2 VAL G  87      55.766 -10.801   5.737  1.00 53.26           C  
ATOM   9804  N   HIS G  88      58.555 -12.703   2.587  1.00 52.83           N  
ATOM   9805  CA  HIS G  88      59.008 -13.512   1.470  1.00 52.52           C  
ATOM   9806  C   HIS G  88      59.329 -14.925   1.916  1.00 52.44           C  
ATOM   9807  O   HIS G  88      59.564 -15.170   3.100  1.00 52.75           O  
ATOM   9808  CB  HIS G  88      60.236 -12.867   0.831  1.00 52.46           C  
ATOM   9809  CG  HIS G  88      59.907 -11.743  -0.100  1.00 52.30           C  
ATOM   9810  ND1 HIS G  88      59.017 -10.743   0.226  1.00 52.38           N  
ATOM   9811  CD2 HIS G  88      60.349 -11.460  -1.345  1.00 52.38           C  
ATOM   9812  CE1 HIS G  88      58.914  -9.899  -0.783  1.00 52.24           C  
ATOM   9813  NE2 HIS G  88      59.714 -10.309  -1.748  1.00 53.01           N  
ATOM   9814  N   LEU G  89      59.338 -15.841   0.951  1.00 52.22           N  
ATOM   9815  CA  LEU G  89      59.564 -17.250   1.185  1.00 51.85           C  
ATOM   9816  C   LEU G  89      60.668 -17.733   0.260  1.00 52.22           C  
ATOM   9817  O   LEU G  89      60.434 -18.072  -0.903  1.00 52.20           O  
ATOM   9818  CB  LEU G  89      58.266 -18.041   0.974  1.00 51.68           C  
ATOM   9819  CG  LEU G  89      58.345 -19.565   1.128  1.00 51.51           C  
ATOM   9820  CD1 LEU G  89      58.881 -19.934   2.480  1.00 51.02           C  
ATOM   9821  CD2 LEU G  89      56.997 -20.198   0.914  1.00 51.79           C  
ATOM   9822  N   VAL G  90      61.881 -17.744   0.795  1.00 52.81           N  
ATOM   9823  CA  VAL G  90      63.066 -18.158   0.064  1.00 53.48           C  
ATOM   9824  C   VAL G  90      63.672 -19.353   0.796  1.00 54.18           C  
ATOM   9825  O   VAL G  90      63.906 -19.282   1.999  1.00 54.33           O  
ATOM   9826  CB  VAL G  90      64.097 -17.000  -0.023  1.00 53.29           C  
ATOM   9827  CG1 VAL G  90      65.355 -17.439  -0.758  1.00 53.89           C  
ATOM   9828  CG2 VAL G  90      63.502 -15.799  -0.717  1.00 53.54           C  
ATOM   9829  N   ASP G  91      63.904 -20.447   0.074  1.00 55.08           N  
ATOM   9830  CA  ASP G  91      64.533 -21.645   0.622  1.00 56.28           C  
ATOM   9831  C   ASP G  91      64.214 -21.869   2.103  1.00 56.37           C  
ATOM   9832  O   ASP G  91      65.069 -21.644   2.969  1.00 56.57           O  
ATOM   9833  CB  ASP G  91      66.058 -21.566   0.460  1.00 56.97           C  
ATOM   9834  CG  ASP G  91      66.498 -21.408  -0.985  1.00 59.12           C  
ATOM   9835  OD1 ASP G  91      66.250 -22.327  -1.804  1.00 60.56           O  
ATOM   9836  OD2 ASP G  91      67.123 -20.367  -1.291  1.00 61.55           O  
ATOM   9837  N   ARG G  92      62.988 -22.287   2.399  1.00 56.26           N  
ATOM   9838  CA  ARG G  92      62.588 -22.627   3.780  1.00 56.02           C  
ATOM   9839  C   ARG G  92      62.671 -21.509   4.825  1.00 56.02           C  
ATOM   9840  O   ARG G  92      62.274 -21.702   5.975  1.00 55.78           O  
ATOM   9841  CB  ARG G  92      63.312 -23.882   4.276  1.00 55.59           C  
ATOM   9842  CG  ARG G  92      62.649 -25.158   3.819  1.00 55.60           C  
ATOM   9843  CD  ARG G  92      62.494 -26.132   4.967  1.00 56.06           C  
ATOM   9844  NE  ARG G  92      61.690 -25.561   6.049  1.00 55.49           N  
ATOM   9845  CZ  ARG G  92      61.628 -26.051   7.281  1.00 54.33           C  
ATOM   9846  NH1 ARG G  92      62.318 -27.132   7.613  1.00 54.55           N  
ATOM   9847  NH2 ARG G  92      60.869 -25.456   8.181  1.00 53.84           N  
ATOM   9848  N   TYR G  93      63.187 -20.352   4.427  1.00 56.44           N  
ATOM   9849  CA  TYR G  93      63.199 -19.177   5.289  1.00 57.26           C  
ATOM   9850  C   TYR G  93      61.941 -18.370   5.065  1.00 57.31           C  
ATOM   9851  O   TYR G  93      61.321 -18.434   3.998  1.00 57.47           O  
ATOM   9852  CB  TYR G  93      64.353 -18.251   4.929  1.00 57.83           C  
ATOM   9853  CG  TYR G  93      65.691 -18.545   5.538  1.00 58.71           C  
ATOM   9854  CD1 TYR G  93      66.816 -18.688   4.720  1.00 60.22           C  
ATOM   9855  CD2 TYR G  93      65.861 -18.633   6.924  1.00 59.46           C  
ATOM   9856  CE1 TYR G  93      68.091 -18.932   5.269  1.00 61.08           C  
ATOM   9857  CE2 TYR G  93      67.135 -18.884   7.486  1.00 59.96           C  
ATOM   9858  CZ  TYR G  93      68.239 -19.027   6.647  1.00 59.69           C  
ATOM   9859  OH  TYR G  93      69.491 -19.275   7.158  1.00 59.42           O  
ATOM   9860  N   LEU G  94      61.587 -17.565   6.050  1.00 57.29           N  
ATOM   9861  CA  LEU G  94      60.544 -16.584   5.855  1.00 57.47           C  
ATOM   9862  C   LEU G  94      61.217 -15.233   6.027  1.00 57.49           C  
ATOM   9863  O   LEU G  94      61.461 -14.786   7.146  1.00 57.70           O  
ATOM   9864  CB  LEU G  94      59.430 -16.798   6.876  1.00 57.59           C  
ATOM   9865  CG  LEU G  94      58.021 -16.338   6.551  1.00 57.74           C  
ATOM   9866  CD1 LEU G  94      57.384 -17.275   5.553  1.00 58.02           C  
ATOM   9867  CD2 LEU G  94      57.217 -16.315   7.819  1.00 57.93           C  
ATOM   9868  N   ILE G  95      61.563 -14.610   4.908  1.00 57.51           N  
ATOM   9869  CA  ILE G  95      62.264 -13.334   4.930  1.00 57.44           C  
ATOM   9870  C   ILE G  95      61.274 -12.193   5.105  1.00 57.70           C  
ATOM   9871  O   ILE G  95      60.365 -12.007   4.290  1.00 57.56           O  
ATOM   9872  CB  ILE G  95      63.108 -13.122   3.656  1.00 57.34           C  
ATOM   9873  CG1 ILE G  95      64.264 -14.116   3.614  1.00 56.97           C  
ATOM   9874  CG2 ILE G  95      63.657 -11.705   3.593  1.00 57.31           C  
ATOM   9875  CD1 ILE G  95      65.034 -14.061   2.316  1.00 57.19           C  
ATOM   9876  N   HIS G  96      61.466 -11.429   6.172  1.00 58.16           N  
ATOM   9877  CA  HIS G  96      60.649 -10.250   6.449  1.00 58.64           C  
ATOM   9878  C   HIS G  96      61.497  -8.982   6.504  1.00 59.25           C  
ATOM   9879  O   HIS G  96      62.449  -8.899   7.271  1.00 59.29           O  
ATOM   9880  CB  HIS G  96      59.882 -10.458   7.759  1.00 58.37           C  
ATOM   9881  CG  HIS G  96      59.088  -9.270   8.207  1.00 57.09           C  
ATOM   9882  ND1 HIS G  96      58.713  -9.086   9.519  1.00 55.88           N  
ATOM   9883  CD2 HIS G  96      58.594  -8.212   7.523  1.00 57.02           C  
ATOM   9884  CE1 HIS G  96      58.025  -7.965   9.626  1.00 56.68           C  
ATOM   9885  NE2 HIS G  96      57.939  -7.414   8.429  1.00 56.80           N  
ATOM   9886  N   ARG G  97      61.158  -8.000   5.680  1.00 60.52           N  
ATOM   9887  CA  ARG G  97      61.777  -6.676   5.801  1.00 61.88           C  
ATOM   9888  C   ARG G  97      60.864  -5.679   6.496  1.00 62.56           C  
ATOM   9889  O   ARG G  97      59.755  -5.401   6.031  1.00 62.71           O  
ATOM   9890  CB  ARG G  97      62.272  -6.124   4.458  1.00 61.88           C  
ATOM   9891  CG  ARG G  97      61.453  -6.509   3.251  1.00 62.70           C  
ATOM   9892  CD  ARG G  97      62.273  -6.313   1.970  1.00 64.18           C  
ATOM   9893  NE  ARG G  97      61.509  -6.676   0.774  1.00 64.91           N  
ATOM   9894  CZ  ARG G  97      60.630  -5.882   0.164  1.00 65.04           C  
ATOM   9895  NH1 ARG G  97      60.382  -4.658   0.625  1.00 64.79           N  
ATOM   9896  NH2 ARG G  97      59.993  -6.317  -0.913  1.00 65.62           N  
ATOM   9897  N   THR G  98      61.349  -5.149   7.614  1.00 63.54           N  
ATOM   9898  CA  THR G  98      60.594  -4.187   8.399  1.00 64.82           C  
ATOM   9899  C   THR G  98      60.812  -2.743   7.914  1.00 65.62           C  
ATOM   9900  O   THR G  98      61.579  -2.498   6.972  1.00 65.73           O  
ATOM   9901  CB  THR G  98      60.936  -4.308   9.886  1.00 64.88           C  
ATOM   9902  OG1 THR G  98      61.532  -5.589  10.139  1.00 64.71           O  
ATOM   9903  CG2 THR G  98      59.665  -4.141  10.724  1.00 65.20           C  
ATOM   9904  N   GLU G  99      60.119  -1.799   8.554  1.00 66.61           N  
ATOM   9905  CA  GLU G  99      60.212  -0.373   8.217  1.00 67.57           C  
ATOM   9906  C   GLU G  99      61.649   0.132   8.358  1.00 67.86           C  
ATOM   9907  O   GLU G  99      62.176   0.804   7.466  1.00 67.92           O  
ATOM   9908  CB  GLU G  99      59.278   0.452   9.115  1.00 67.66           C  
ATOM   9909  CG  GLU G  99      59.125   1.921   8.708  1.00 68.71           C  
ATOM   9910  CD  GLU G  99      58.121   2.132   7.574  1.00 70.25           C  
ATOM   9911  OE1 GLU G  99      57.174   1.325   7.449  1.00 71.15           O  
ATOM   9912  OE2 GLU G  99      58.271   3.110   6.810  1.00 70.14           O  
ATOM   9913  N   ASN G 100      62.273  -0.236   9.475  1.00 68.19           N  
ATOM   9914  CA  ASN G 100      63.608   0.220   9.839  1.00 68.38           C  
ATOM   9915  C   ASN G 100      64.722  -0.267   8.917  1.00 68.11           C  
ATOM   9916  O   ASN G 100      65.902  -0.096   9.233  1.00 68.43           O  
ATOM   9917  CB  ASN G 100      63.911  -0.202  11.278  1.00 68.78           C  
ATOM   9918  CG  ASN G 100      62.959   0.422  12.285  1.00 70.10           C  
ATOM   9919  OD1 ASN G 100      61.762   0.586  12.018  1.00 70.68           O  
ATOM   9920  ND2 ASN G 100      63.489   0.775  13.458  1.00 71.33           N  
ATOM   9921  N   GLN G 101      64.343  -0.858   7.781  1.00 67.56           N  
ATOM   9922  CA  GLN G 101      65.286  -1.478   6.842  1.00 67.12           C  
ATOM   9923  C   GLN G 101      66.012  -2.703   7.436  1.00 66.23           C  
ATOM   9924  O   GLN G 101      67.086  -3.085   6.948  1.00 66.30           O  
ATOM   9925  CB  GLN G 101      66.318  -0.461   6.317  1.00 67.07           C  
ATOM   9926  CG  GLN G 101      65.767   0.651   5.440  1.00 67.76           C  
ATOM   9927  CD  GLN G 101      66.872   1.446   4.740  1.00 68.12           C  
ATOM   9928  OE1 GLN G 101      67.306   1.090   3.641  1.00 69.52           O  
ATOM   9929  NE2 GLN G 101      67.322   2.530   5.372  1.00 68.52           N  
ATOM   9930  N   HIS G 102      65.443  -3.307   8.484  1.00 64.97           N  
ATOM   9931  CA  HIS G 102      66.039  -4.498   9.096  1.00 63.64           C  
ATOM   9932  C   HIS G 102      65.453  -5.755   8.493  1.00 62.13           C  
ATOM   9933  O   HIS G 102      64.254  -6.021   8.637  1.00 62.30           O  
ATOM   9934  CB  HIS G 102      65.856  -4.515  10.614  1.00 64.10           C  
ATOM   9935  CG  HIS G 102      66.599  -3.427  11.325  1.00 66.32           C  
ATOM   9936  ND1 HIS G 102      67.943  -3.184  11.123  1.00 68.00           N  
ATOM   9937  CD2 HIS G 102      66.187  -2.517  12.242  1.00 68.10           C  
ATOM   9938  CE1 HIS G 102      68.323  -2.166  11.875  1.00 69.04           C  
ATOM   9939  NE2 HIS G 102      67.277  -1.743  12.564  1.00 69.30           N  
ATOM   9940  N   VAL G 103      66.298  -6.518   7.805  1.00 60.04           N  
ATOM   9941  CA  VAL G 103      65.876  -7.776   7.198  1.00 57.93           C  
ATOM   9942  C   VAL G 103      65.933  -8.906   8.226  1.00 56.39           C  
ATOM   9943  O   VAL G 103      66.955  -9.111   8.881  1.00 56.28           O  
ATOM   9944  CB  VAL G 103      66.714  -8.123   5.942  1.00 58.07           C  
ATOM   9945  CG1 VAL G 103      66.438  -9.550   5.482  1.00 57.84           C  
ATOM   9946  CG2 VAL G 103      66.427  -7.133   4.812  1.00 57.51           C  
ATOM   9947  N   VAL G 104      64.822  -9.625   8.354  1.00 54.40           N  
ATOM   9948  CA  VAL G 104      64.682 -10.705   9.322  1.00 52.56           C  
ATOM   9949  C   VAL G 104      64.331 -12.023   8.618  1.00 51.44           C  
ATOM   9950  O   VAL G 104      63.459 -12.050   7.753  1.00 51.16           O  
ATOM   9951  CB  VAL G 104      63.660 -10.296  10.436  1.00 52.54           C  
ATOM   9952  CG1 VAL G 104      62.750 -11.440  10.861  1.00 52.57           C  
ATOM   9953  CG2 VAL G 104      64.391  -9.719  11.628  1.00 51.68           C  
ATOM   9954  N   GLY G 105      65.050 -13.093   8.962  1.00 50.34           N  
ATOM   9955  CA  GLY G 105      64.768 -14.446   8.465  1.00 48.98           C  
ATOM   9956  C   GLY G 105      64.087 -15.289   9.534  1.00 48.42           C  
ATOM   9957  O   GLY G 105      64.540 -15.353  10.681  1.00 48.13           O  
ATOM   9958  N   LEU G 106      62.986 -15.933   9.169  1.00 47.69           N  
ATOM   9959  CA  LEU G 106      62.265 -16.777  10.114  1.00 46.99           C  
ATOM   9960  C   LEU G 106      62.354 -18.250   9.729  1.00 46.54           C  
ATOM   9961  O   LEU G 106      61.806 -18.659   8.703  1.00 46.68           O  
ATOM   9962  CB  LEU G 106      60.804 -16.325  10.238  1.00 46.78           C  
ATOM   9963  CG  LEU G 106      60.618 -14.907  10.778  1.00 46.61           C  
ATOM   9964  CD1 LEU G 106      59.236 -14.363  10.496  1.00 46.19           C  
ATOM   9965  CD2 LEU G 106      60.923 -14.844  12.276  1.00 47.18           C  
ATOM   9966  N   TRP G 107      63.070 -19.035  10.535  1.00 45.91           N  
ATOM   9967  CA  TRP G 107      63.099 -20.482  10.341  1.00 45.04           C  
ATOM   9968  C   TRP G 107      62.064 -21.198  11.208  1.00 45.73           C  
ATOM   9969  O   TRP G 107      62.310 -21.478  12.390  1.00 45.17           O  
ATOM   9970  CB  TRP G 107      64.481 -21.066  10.594  1.00 43.78           C  
ATOM   9971  CG  TRP G 107      64.586 -22.476  10.082  1.00 42.45           C  
ATOM   9972  CD1 TRP G 107      64.149 -23.622  10.700  1.00 40.59           C  
ATOM   9973  CD2 TRP G 107      65.138 -22.886   8.830  1.00 41.30           C  
ATOM   9974  NE1 TRP G 107      64.408 -24.710   9.919  1.00 39.15           N  
ATOM   9975  CE2 TRP G 107      65.012 -24.292   8.762  1.00 40.22           C  
ATOM   9976  CE3 TRP G 107      65.733 -22.200   7.755  1.00 40.41           C  
ATOM   9977  CZ2 TRP G 107      65.468 -25.030   7.665  1.00 41.03           C  
ATOM   9978  CZ3 TRP G 107      66.184 -22.932   6.670  1.00 40.75           C  
ATOM   9979  CH2 TRP G 107      66.044 -24.335   6.630  1.00 41.26           C  
ATOM   9980  N   MET G 108      60.893 -21.453  10.615  1.00 46.66           N  
ATOM   9981  CA  MET G 108      59.890 -22.353  11.186  1.00 47.47           C  
ATOM   9982  C   MET G 108      60.495 -23.748  11.247  1.00 47.24           C  
ATOM   9983  O   MET G 108      61.080 -24.193  10.268  1.00 47.32           O  
ATOM   9984  CB  MET G 108      58.658 -22.398  10.282  1.00 48.03           C  
ATOM   9985  CG  MET G 108      57.583 -21.395  10.606  1.00 49.40           C  
ATOM   9986  SD  MET G 108      58.212 -19.720  10.627  1.00 55.59           S  
ATOM   9987  CE  MET G 108      56.679 -18.789  10.542  1.00 50.35           C  
ATOM   9988  N   PHE G 109      60.366 -24.447  12.370  1.00 47.05           N  
ATOM   9989  CA  PHE G 109      60.969 -25.787  12.451  1.00 47.11           C  
ATOM   9990  C   PHE G 109      60.149 -26.885  11.800  1.00 46.52           C  
ATOM   9991  O   PHE G 109      60.677 -27.909  11.401  1.00 46.90           O  
ATOM   9992  CB  PHE G 109      61.370 -26.140  13.880  1.00 47.36           C  
ATOM   9993  CG  PHE G 109      62.752 -25.680  14.228  1.00 48.49           C  
ATOM   9994  CD1 PHE G 109      63.084 -24.327  14.167  1.00 48.94           C  
ATOM   9995  CD2 PHE G 109      63.734 -26.598  14.600  1.00 50.54           C  
ATOM   9996  CE1 PHE G 109      64.366 -23.889  14.484  1.00 50.31           C  
ATOM   9997  CE2 PHE G 109      65.041 -26.175  14.919  1.00 51.10           C  
ATOM   9998  CZ  PHE G 109      65.357 -24.821  14.858  1.00 50.63           C  
ATOM   9999  N   ASP G 110      58.861 -26.634  11.675  1.00 46.07           N  
ATOM  10000  CA  ASP G 110      57.925 -27.517  11.035  1.00 45.64           C  
ATOM  10001  C   ASP G 110      57.649 -26.925   9.646  1.00 45.27           C  
ATOM  10002  O   ASP G 110      57.204 -25.772   9.551  1.00 45.13           O  
ATOM  10003  CB  ASP G 110      56.650 -27.523  11.876  1.00 45.87           C  
ATOM  10004  CG  ASP G 110      55.605 -28.475  11.370  1.00 46.67           C  
ATOM  10005  OD1 ASP G 110      55.396 -28.591  10.138  1.00 46.74           O  
ATOM  10006  OD2 ASP G 110      54.972 -29.105  12.237  1.00 48.75           O  
ATOM  10007  N   PRO G 111      57.898 -27.708   8.568  1.00 44.66           N  
ATOM  10008  CA  PRO G 111      57.726 -27.246   7.187  1.00 44.36           C  
ATOM  10009  C   PRO G 111      56.320 -26.731   6.952  1.00 44.18           C  
ATOM  10010  O   PRO G 111      56.127 -25.821   6.156  1.00 44.37           O  
ATOM  10011  CB  PRO G 111      57.920 -28.515   6.353  1.00 44.24           C  
ATOM  10012  CG  PRO G 111      58.684 -29.435   7.206  1.00 44.84           C  
ATOM  10013  CD  PRO G 111      58.332 -29.114   8.626  1.00 44.71           C  
ATOM  10014  N   ASN G 112      55.355 -27.317   7.658  1.00 43.84           N  
ATOM  10015  CA  ASN G 112      53.945 -27.013   7.471  1.00 43.13           C  
ATOM  10016  C   ASN G 112      53.465 -25.726   8.110  1.00 43.01           C  
ATOM  10017  O   ASN G 112      52.438 -25.178   7.713  1.00 43.23           O  
ATOM  10018  CB  ASN G 112      53.098 -28.195   7.923  1.00 42.92           C  
ATOM  10019  CG  ASN G 112      53.119 -29.309   6.919  1.00 42.47           C  
ATOM  10020  OD1 ASN G 112      53.410 -29.079   5.751  1.00 42.92           O  
ATOM  10021  ND2 ASN G 112      52.826 -30.524   7.359  1.00 43.02           N  
ATOM  10022  N   ASP G 113      54.206 -25.241   9.092  1.00 42.76           N  
ATOM  10023  CA  ASP G 113      53.912 -23.955   9.674  1.00 42.66           C  
ATOM  10024  C   ASP G 113      54.357 -22.855   8.713  1.00 42.89           C  
ATOM  10025  O   ASP G 113      53.648 -21.857   8.519  1.00 42.81           O  
ATOM  10026  CB  ASP G 113      54.603 -23.808  11.024  1.00 42.66           C  
ATOM  10027  CG  ASP G 113      53.964 -24.661  12.101  1.00 43.41           C  
ATOM  10028  OD1 ASP G 113      52.719 -24.839  12.052  1.00 43.24           O  
ATOM  10029  OD2 ASP G 113      54.710 -25.145  12.999  1.00 43.08           O  
ATOM  10030  N   MET G 114      55.521 -23.054   8.099  1.00 42.88           N  
ATOM  10031  CA  MET G 114      56.081 -22.078   7.187  1.00 42.78           C  
ATOM  10032  C   MET G 114      55.101 -21.834   6.064  1.00 43.56           C  
ATOM  10033  O   MET G 114      54.557 -20.737   5.938  1.00 44.07           O  
ATOM  10034  CB  MET G 114      57.400 -22.579   6.627  1.00 43.00           C  
ATOM  10035  CG  MET G 114      58.016 -21.673   5.572  1.00 42.70           C  
ATOM  10036  SD  MET G 114      59.236 -22.576   4.594  1.00 41.65           S  
ATOM  10037  CE  MET G 114      58.192 -23.629   3.561  1.00 40.64           C  
ATOM  10038  N   SER G 115      54.843 -22.855   5.259  1.00 43.81           N  
ATOM  10039  CA  SER G 115      53.935 -22.676   4.147  1.00 44.34           C  
ATOM  10040  C   SER G 115      52.533 -22.240   4.592  1.00 44.49           C  
ATOM  10041  O   SER G 115      51.880 -21.500   3.865  1.00 44.92           O  
ATOM  10042  CB  SER G 115      53.904 -23.908   3.247  1.00 44.31           C  
ATOM  10043  OG  SER G 115      53.356 -25.009   3.934  1.00 45.64           O  
ATOM  10044  N   ARG G 116      52.074 -22.658   5.772  1.00 44.70           N  
ATOM  10045  CA  ARG G 116      50.731 -22.251   6.212  1.00 45.38           C  
ATOM  10046  C   ARG G 116      50.661 -20.770   6.556  1.00 46.12           C  
ATOM  10047  O   ARG G 116      49.874 -20.034   5.980  1.00 46.21           O  
ATOM  10048  CB  ARG G 116      50.222 -23.089   7.385  1.00 45.32           C  
ATOM  10049  CG  ARG G 116      48.749 -22.848   7.729  1.00 44.32           C  
ATOM  10050  CD  ARG G 116      48.296 -23.694   8.911  1.00 44.70           C  
ATOM  10051  NE  ARG G 116      48.997 -23.296  10.125  1.00 45.40           N  
ATOM  10052  CZ  ARG G 116      50.045 -23.931  10.640  1.00 45.85           C  
ATOM  10053  NH1 ARG G 116      50.524 -25.029  10.072  1.00 46.72           N  
ATOM  10054  NH2 ARG G 116      50.612 -23.463  11.736  1.00 46.80           N  
ATOM  10055  N   ILE G 117      51.498 -20.346   7.495  1.00 47.45           N  
ATOM  10056  CA  ILE G 117      51.615 -18.940   7.890  1.00 48.37           C  
ATOM  10057  C   ILE G 117      51.960 -18.005   6.719  1.00 49.51           C  
ATOM  10058  O   ILE G 117      51.494 -16.869   6.673  1.00 49.59           O  
ATOM  10059  CB  ILE G 117      52.614 -18.799   9.040  1.00 48.13           C  
ATOM  10060  CG1 ILE G 117      52.083 -19.590  10.244  1.00 47.94           C  
ATOM  10061  CG2 ILE G 117      52.871 -17.330   9.372  1.00 48.29           C  
ATOM  10062  CD1 ILE G 117      53.001 -19.658  11.421  1.00 46.47           C  
ATOM  10063  N   PHE G 118      52.753 -18.481   5.762  1.00 50.88           N  
ATOM  10064  CA  PHE G 118      53.041 -17.675   4.599  1.00 52.12           C  
ATOM  10065  C   PHE G 118      51.741 -17.342   3.867  1.00 53.75           C  
ATOM  10066  O   PHE G 118      51.462 -16.168   3.621  1.00 54.39           O  
ATOM  10067  CB  PHE G 118      54.067 -18.341   3.690  1.00 51.71           C  
ATOM  10068  CG  PHE G 118      54.445 -17.505   2.512  1.00 51.51           C  
ATOM  10069  CD1 PHE G 118      55.089 -16.289   2.686  1.00 51.63           C  
ATOM  10070  CD2 PHE G 118      54.133 -17.918   1.221  1.00 51.64           C  
ATOM  10071  CE1 PHE G 118      55.432 -15.491   1.585  1.00 51.98           C  
ATOM  10072  CE2 PHE G 118      54.476 -17.134   0.114  1.00 51.77           C  
ATOM  10073  CZ  PHE G 118      55.126 -15.918   0.298  1.00 51.42           C  
ATOM  10074  N   ASN G 119      50.930 -18.357   3.561  1.00 55.34           N  
ATOM  10075  CA  ASN G 119      49.630 -18.137   2.916  1.00 57.26           C  
ATOM  10076  C   ASN G 119      48.799 -17.054   3.590  1.00 58.45           C  
ATOM  10077  O   ASN G 119      48.242 -16.190   2.918  1.00 58.50           O  
ATOM  10078  CB  ASN G 119      48.801 -19.426   2.864  1.00 57.42           C  
ATOM  10079  CG  ASN G 119      49.487 -20.539   2.100  1.00 58.18           C  
ATOM  10080  OD1 ASN G 119      50.331 -20.296   1.236  1.00 59.68           O  
ATOM  10081  ND2 ASN G 119      49.125 -21.777   2.421  1.00 58.79           N  
ATOM  10082  N   ILE G 120      48.712 -17.113   4.917  1.00 59.97           N  
ATOM  10083  CA  ILE G 120      47.902 -16.167   5.677  1.00 61.54           C  
ATOM  10084  C   ILE G 120      48.391 -14.736   5.457  1.00 62.59           C  
ATOM  10085  O   ILE G 120      47.595 -13.836   5.192  1.00 62.86           O  
ATOM  10086  CB  ILE G 120      47.874 -16.522   7.187  1.00 61.42           C  
ATOM  10087  CG1 ILE G 120      46.760 -17.526   7.509  1.00 61.96           C  
ATOM  10088  CG2 ILE G 120      47.574 -15.308   8.013  1.00 61.77           C  
ATOM  10089  CD1 ILE G 120      46.969 -18.941   6.991  1.00 62.95           C  
ATOM  10090  N   VAL G 121      49.701 -14.546   5.528  1.00 64.15           N  
ATOM  10091  CA  VAL G 121      50.291 -13.217   5.519  1.00 65.89           C  
ATOM  10092  C   VAL G 121      50.883 -12.900   4.153  1.00 67.31           C  
ATOM  10093  O   VAL G 121      51.974 -12.341   4.060  1.00 67.66           O  
ATOM  10094  CB  VAL G 121      51.393 -13.084   6.606  1.00 65.79           C  
ATOM  10095  CG1 VAL G 121      51.615 -11.624   6.953  1.00 66.23           C  
ATOM  10096  CG2 VAL G 121      51.024 -13.855   7.860  1.00 65.13           C  
ATOM  10097  N   LYS G 122      50.143 -13.253   3.101  1.00 69.28           N  
ATOM  10098  CA  LYS G 122      50.610 -13.239   1.701  1.00 71.05           C  
ATOM  10099  C   LYS G 122      49.741 -14.228   0.912  1.00 72.66           C  
ATOM  10100  O   LYS G 122      50.260 -15.200   0.330  1.00 72.99           O  
ATOM  10101  CB  LYS G 122      52.078 -13.671   1.601  1.00 70.68           C  
ATOM  10102  CG  LYS G 122      52.718 -13.441   0.249  1.00 70.90           C  
ATOM  10103  CD  LYS G 122      53.554 -12.171   0.209  1.00 70.31           C  
ATOM  10104  CE  LYS G 122      54.243 -12.012  -1.136  1.00 70.05           C  
ATOM  10105  NZ  LYS G 122      55.185 -10.869  -1.152  1.00 70.42           N  
ATOM  10106  N   GLU G 123      48.429 -13.972   0.899  1.00 74.32           N  
ATOM  10107  CA  GLU G 123      47.404 -14.939   0.450  1.00 76.16           C  
ATOM  10108  C   GLU G 123      47.435 -15.259  -1.056  1.00 77.43           C  
ATOM  10109  O   GLU G 123      48.363 -15.920  -1.531  1.00 77.43           O  
ATOM  10110  CB  GLU G 123      45.992 -14.500   0.895  1.00 76.11           C  
ATOM  10111  CG  GLU G 123      45.948 -13.650   2.170  1.00 76.87           C  
ATOM  10112  CD  GLU G 123      46.631 -12.285   1.998  1.00 78.17           C  
ATOM  10113  OE1 GLU G 123      46.093 -11.423   1.254  1.00 77.58           O  
ATOM  10114  OE2 GLU G 123      47.712 -12.087   2.606  1.00 78.11           O  
ATOM  10115  N   SER G 124      46.422 -14.800  -1.795  1.00 79.35           N  
ATOM  10116  CA  SER G 124      46.306 -15.114  -3.226  1.00 81.23           C  
ATOM  10117  C   SER G 124      46.212 -13.831  -4.076  1.00 82.35           C  
ATOM  10118  O   SER G 124      46.934 -12.857  -3.824  1.00 82.33           O  
ATOM  10119  CB  SER G 124      45.119 -16.073  -3.477  1.00 81.20           C  
ATOM  10120  OG  SER G 124      45.351 -16.923  -4.594  1.00 81.34           O  
ATOM  10121  N   LEU G 125      45.342 -13.836  -5.085  1.00 83.81           N  
ATOM  10122  CA  LEU G 125      45.115 -12.641  -5.891  1.00 85.15           C  
ATOM  10123  C   LEU G 125      43.627 -12.455  -6.166  1.00 85.96           C  
ATOM  10124  O   LEU G 125      42.883 -13.439  -6.239  1.00 86.11           O  
ATOM  10125  CB  LEU G 125      45.898 -12.718  -7.203  1.00 85.13           C  
ATOM  10126  CG  LEU G 125      46.684 -11.440  -7.501  1.00 85.51           C  
ATOM  10127  CD1 LEU G 125      48.123 -11.537  -6.970  1.00 85.26           C  
ATOM  10128  CD2 LEU G 125      46.676 -11.133  -8.986  1.00 85.55           C  
ATOM  10129  N   LEU G 126      43.198 -11.199  -6.307  1.00 87.10           N  
ATOM  10130  CA  LEU G 126      41.782 -10.885  -6.573  1.00 87.93           C  
ATOM  10131  C   LEU G 126      41.521 -10.541  -8.046  1.00 88.53           C  
ATOM  10132  O   LEU G 126      42.208  -9.692  -8.627  1.00 88.62           O  
ATOM  10133  CB  LEU G 126      41.257  -9.772  -5.631  1.00 88.01           C  
ATOM  10134  CG  LEU G 126      39.744  -9.446  -5.529  1.00 87.60           C  
ATOM  10135  CD1 LEU G 126      38.882 -10.661  -5.165  1.00 88.08           C  
ATOM  10136  CD2 LEU G 126      39.484  -8.322  -4.534  1.00 87.76           C  
ATOM  10137  N   ARG G 127      40.538 -11.227  -8.631  1.00 89.21           N  
ATOM  10138  CA  ARG G 127      40.049 -10.963  -9.992  1.00 89.79           C  
ATOM  10139  C   ARG G 127      38.585 -10.493  -9.938  1.00 90.03           C  
ATOM  10140  O   ARG G 127      37.907 -10.635  -8.913  1.00 90.29           O  
ATOM  10141  CB  ARG G 127      40.232 -12.215 -10.885  1.00 89.92           C  
ATOM  10142  CG  ARG G 127      39.400 -12.278 -12.189  1.00 90.06           C  
ATOM  10143  CD  ARG G 127      39.865 -11.295 -13.272  1.00 90.16           C  
ATOM  10144  NE  ARG G 127      38.729 -10.773 -14.042  1.00 90.32           N  
ATOM  10145  CZ  ARG G 127      38.822  -9.959 -15.093  1.00 90.19           C  
ATOM  10146  NH1 ARG G 127      40.007  -9.544 -15.534  1.00 89.70           N  
ATOM  10147  NH2 ARG G 127      37.715  -9.546 -15.702  1.00 89.89           N  
ATOM  10148  OXT ARG G 127      38.035  -9.940 -10.895  1.00 90.22           O  
TER   10149      ARG G 127                                                      
END
MOLECULE T0446.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
