
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  125 (  949),  selected  125 , name 1ocv_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1ocv_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      M       1           -
LGA    N     2_A      M       2           -
LGA    -       -      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    T     3_A      S       6          4.733
LGA    P     4_A      D       7          3.694
LGA    -       -      N       8           -
LGA    -       -      T       9           -
LGA    -       -      L      10           -
LGA    E     5_A      K      11          2.610
LGA    H     6_A      V      12          2.942
LGA    M     7_A      A      13          2.416
LGA    T     8_A      H      14          2.052
LGA    A     9_A      Q      15          2.566
LGA    V    10_A      G      16          2.284
LGA    V    11_A      F      17          2.004
LGA    Q    12_A      E      18          2.332
LGA    R    13_A      F      19          2.598
LGA    Y    14_A      F      20          1.899
LGA    V    15_A      T      21          1.466
LGA    A    16_A      Q      22          2.432
LGA    A    17_A      G      23          2.850
LGA    L    18_A      L      24          2.065
LGA    N    19_A      A      25          1.506
LGA    A    20_A      T      26          2.587
LGA    G    21_A      G      27          1.835
LGA    D    22_A      E      28          1.492
LGA    L    23_A      W      29          1.684
LGA    D    24_A      Q      30          0.909
LGA    G    25_A      K      31          1.360
LGA    I    26_A      F      32          2.108
LGA    V    27_A      L      33          1.161
LGA    A    28_A      D      34          1.265
LGA    L    29_A      M      35          2.112
LGA    F    30_A      L      36          1.269
LGA    A    31_A      T      37          0.863
LGA    D    32_A      E      38          1.212
LGA    D    33_A      D      39          0.660
LGA    A    34_A      F      40          0.561
LGA    T    35_A      T      41          0.528
LGA    V    36_A      F      42          0.939
LGA    E    37_A      W      43          0.704
LGA    D    38_A      F      44          1.587
LGA    P    39_A      P      45          2.434
LGA    V    40_A      M      46           #
LGA    G    41_A      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    S    42_A      H      50          2.930
LGA    E    43_A      G      51          1.850
LGA    P    44_A      L      52          1.472
LGA    R    45_A      N      53          1.191
LGA    S    46_A      V      54          0.565
LGA    G    47_A      G      55          0.392
LGA    T    48_A      K      56          0.813
LGA    A    49_A      E      57          0.496
LGA    A    50_A      R      58          0.565
LGA    I    51_A      A      59          0.514
LGA    R    52_A      K      60          0.514
LGA    E    53_A      E      61          0.361
LGA    F    54_A      F      62          0.334
LGA    Y    55_A      F      63          0.249
LGA    A    56_A      T      64          0.806
LGA    N    57_A      Y      65          0.594
LGA    S    58_A      V      66          0.605
LGA    L    59_A      S      67          0.844
LGA    K    60_A      E      68          0.738
LGA    L    61_A      S      69          2.934
LGA    P    62_A      F      70          3.254
LGA    -       -      H      71           -
LGA    -       -      T      72           -
LGA    -       -      G      73           -
LGA    L    63_A      I      74          1.736
LGA    A    64_A      Q      75          1.696
LGA    V    65_A      I      76          2.674
LGA    E    66_A      S      77          4.014
LGA    L    67_A      S      78          4.057
LGA    T    68_A      L      79          2.231
LGA    Q    69_A      D      80          1.518
LGA    E    70_A      R      81          4.147
LGA    V    71_A      V      82          2.292
LGA    R    72_A      T      83          1.970
LGA    A    73_A      S      84          2.794
LGA    V    74_A      N      85          2.824
LGA    A    75_A      E      86          0.522
LGA    N    76_A      T      87          1.630
LGA    E    77_A      T      88          1.208
LGA    A    78_A      V      89          0.324
LGA    A    79_A      V      90          0.281
LGA    F    80_A      F      91          0.422
LGA    A    81_A      E      92          1.023
LGA    F    82_A      F      93          1.317
LGA    I    83_A      R      94          2.480
LGA    V    84_A      D      95          3.013
LGA    S    85_A      E      96          1.501
LGA    F    86_A      G      97          2.151
LGA    E    87_A      L      98          1.942
LGA    Y    88_A      F      99          3.189
LGA    Q    89_A      L     100          4.803
LGA    G    90_A      G     101          4.167
LGA    R    91_A      K     102          2.454
LGA    K    92_A      P     103          0.564
LGA    T    93_A      Y     104          1.315
LGA    V    94_A      K     105          0.631
LGA    V    95_A      N     106          1.721
LGA    A    96_A      R     107          0.991
LGA    P    97_A      V     108          1.044
LGA    I    98_A      A     109          0.662
LGA    D    99_A      V     110          0.835
LGA    H   100_A      S     111          0.627
LGA    F   101_A      F     112          0.532
LGA    R   102_A      D     113          0.497
LGA    F   103_A      V     114          1.071
LGA    N   104_A      R     115          1.389
LGA    G   105_A      G     116          2.958
LGA    A   106_A      -       -           -
LGA    G   107_A      D     117          2.054
LGA    K   108_A      K     118          1.048
LGA    V   109_A      I     119          0.938
LGA    V   110_A      C     120          0.766
LGA    S   111_A      S     121          0.698
LGA    M   112_A      Y     122          0.447
LGA    R   113_A      R     123          0.316
LGA    A   114_A      E     124          0.580
LGA    L   115_A      Y     125          1.086
LGA    W   116_A      F     126          1.128
LGA    G   117_A      G     127          5.464
LGA    E   118_A      -       -           -
LGA    K   119_A      -       -           -
LGA    N   120_A      S     128          0.927
LGA    I   121_A      D     129          1.950
LGA    H   122_A      G     130          3.696
LGA    A   123_A      K     131          1.864
LGA    G   124_A      S     132           #
LGA    A   125_A      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  125  133    5.0    116    2.01    15.52     75.313     5.498

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.157541 * X  +  -0.770148 * Y  +   0.618104 * Z  +  50.587238
  Y_new =  -0.317999 * X  +   0.553015 * Y  +   0.770098 * Z  + -15.428644
  Z_new =  -0.934910 * X  +  -0.317879 * Y  +  -0.157784 * Z  +  -0.317414 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.031531    1.110061  [ DEG:  -116.3982     63.6018 ]
  Theta =   1.208006    1.933587  [ DEG:    69.2136    110.7864 ]
  Phi   =  -1.110824    2.030768  [ DEG:   -63.6455    116.3544 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ocv_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ocv_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  125  133   5.0  116   2.01   15.52  75.313
REMARK  ---------------------------------------------------------- 
MOLECULE 1ocv_A
HEADER    KETOSTEROID ISOMERASE                   11-FEB-03   1OCV              
TITLE     THE F116W MUTANT STRUCTURE OF KETOSTEROID ISOMERASE FROM              
TITLE    2 COMAMONAS TESTOSTERONI                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STEROID DELTA-ISOMERASE;                                   
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: KETOSTEROID ISOMERASE;                                      
COMPND   5 EC: 5.3.3.1;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: COMAMONAS TESTOSTERONI;                         
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: BL21 DE3;                                  
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PKK223-3                                  
KEYWDS    KETOSTEROID ISOMERASE, DELTA-5-3-KETOSTEROID                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.S.YUN,T.-H.LEE,S.SHIN                                               
REVDAT   1   24-JUL-03 1OCV    0                                                
JRNL        AUTH   Y.S.YUN,T.H.LEE,G.H.NAM,D.S.JANG,S.SHIN,B.H.OH,              
JRNL        AUTH 2 K.Y.CHOI                                                     
JRNL        TITL   ORIGIN OF THE DIFFERENT PH ACTIVITY PROFILE IN TWO           
JRNL        TITL 2 HOMOLOGOUS KETOSTEROID ISOMERASES.                           
JRNL        REF    J.BIOL.CHEM.                  V. 278 28229 2003              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1OCV A    1   125  UNP    P00947   SDIS_COMTE       1    125             
DBREF  1OCV B  201   325  UNP    P00947   SDIS_COMTE       1    125             
DBREF  1OCV C  401   525  UNP    P00947   SDIS_COMTE       1    125             
DBREF  1OCV D  601   725  UNP    P00947   SDIS_COMTE       1    125             
SEQRES   1 A  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 A  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 A  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 A  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 A  125  GLU PHE TYR ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 A  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 A  125  ALA PHE ALA PHE ILE VAL SER PHE GLU TYR GLN GLY ARG          
SEQRES   8 A  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 A  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU TRP GLY          
SEQRES  10 A  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
SEQRES   1 B  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 B  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 B  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 B  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 B  125  GLU PHE TYR ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 B  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 B  125  ALA PHE ALA PHE ILE VAL SER PHE GLU TYR GLN GLY ARG          
SEQRES   8 B  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 B  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU TRP GLY          
SEQRES  10 B  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
SEQRES   1 C  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 C  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 C  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 C  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 C  125  GLU PHE TYR ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 C  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 C  125  ALA PHE ALA PHE ILE VAL SER PHE GLU TYR GLN GLY ARG          
SEQRES   8 C  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 C  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU TRP GLY          
SEQRES  10 C  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
SEQRES   1 D  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 D  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 D  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 D  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 D  125  GLU PHE TYR ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 D  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 D  125  ALA PHE ALA PHE ILE VAL SER PHE GLU TYR GLN GLY ARG          
SEQRES   8 D  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 D  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU TRP GLY          
SEQRES  10 D  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
FORMUL   5  HOH   *357(H2 O)                                                    
CRYST1   71.525   71.525  103.340  90.00  90.00 120.00 P 31         12          
ATOM      1  N   MET A   1      37.396  23.158   7.426  1.00 69.09           N  
ATOM      2  CA  MET A   1      37.335  21.763   6.896  1.00 69.00           C  
ATOM      3  C   MET A   1      36.584  20.864   7.874  1.00 65.89           C  
ATOM      4  O   MET A   1      36.335  21.247   9.021  1.00 67.68           O  
ATOM      5  CB  MET A   1      38.750  21.219   6.676  1.00 84.40           C  
ATOM      6  CG  MET A   1      38.822  19.916   5.890  1.00 87.67           C  
ATOM      7  SD  MET A   1      38.245  20.077   4.185  1.00 93.50           S  
ATOM      8  CE  MET A   1      36.749  19.105   4.238  1.00 90.35           C  
ATOM      9  N   ASN A   2      36.238  19.663   7.422  1.00 32.04           N  
ATOM     10  CA  ASN A   2      35.495  18.729   8.258  1.00 26.54           C  
ATOM     11  C   ASN A   2      36.073  17.324   8.280  1.00 24.22           C  
ATOM     12  O   ASN A   2      36.168  16.658   7.249  1.00 24.20           O  
ATOM     13  CB  ASN A   2      34.044  18.646   7.785  1.00 24.51           C  
ATOM     14  CG  ASN A   2      33.279  19.924   8.027  1.00 23.67           C  
ATOM     15  OD1 ASN A   2      32.892  20.223   9.158  1.00 21.60           O  
ATOM     16  ND2 ASN A   2      33.056  20.692   6.962  1.00 21.95           N  
ATOM     17  N   THR A   3      36.461  16.867   9.462  1.00 19.73           N  
ATOM     18  CA  THR A   3      36.977  15.517   9.571  1.00 15.68           C  
ATOM     19  C   THR A   3      35.769  14.607   9.705  1.00 14.99           C  
ATOM     20  O   THR A   3      34.683  15.058  10.102  1.00 10.32           O  
ATOM     21  CB  THR A   3      37.810  15.326  10.822  1.00 14.08           C  
ATOM     22  OG1 THR A   3      36.992  15.594  11.965  1.00 13.86           O  
ATOM     23  CG2 THR A   3      39.020  16.267  10.811  1.00 14.97           C  
ATOM     24  N   PRO A   4      35.933  13.325   9.354  1.00 15.66           N  
ATOM     25  CA  PRO A   4      34.845  12.351   9.452  1.00 16.68           C  
ATOM     26  C   PRO A   4      34.485  12.221  10.940  1.00 16.08           C  
ATOM     27  O   PRO A   4      33.323  12.018  11.297  1.00 14.17           O  
ATOM     28  CB  PRO A   4      35.473  11.068   8.900  1.00 15.10           C  
ATOM     29  CG  PRO A   4      36.536  11.575   7.962  1.00 16.23           C  
ATOM     30  CD  PRO A   4      37.124  12.729   8.723  1.00 14.88           C  
ATOM     31  N   GLU A   5      35.497  12.344  11.801  1.00 14.87           N  
ATOM     32  CA  GLU A   5      35.281  12.250  13.247  1.00 16.03           C  
ATOM     33  C   GLU A   5      34.305  13.331  13.693  1.00 14.46           C  
ATOM     34  O   GLU A   5      33.324  13.051  14.371  1.00 14.10           O  
ATOM     35  CB  GLU A   5      36.601  12.414  14.016  1.00 16.15           C  
ATOM     36  CG  GLU A   5      37.605  11.286  13.811  1.00 19.62           C  
ATOM     37  CD  GLU A   5      38.102  11.194  12.376  1.00 22.79           C  
ATOM     38  OE1 GLU A   5      38.268  12.255  11.728  1.00 18.16           O  
ATOM     39  OE2 GLU A   5      38.331  10.057  11.900  1.00 27.98           O  
ATOM     40  N   HIS A   6      34.581  14.570  13.305  1.00 17.02           N  
ATOM     41  CA  HIS A   6      33.716  15.688  13.661  1.00 17.22           C  
ATOM     42  C   HIS A   6      32.289  15.487  13.160  1.00 17.55           C  
ATOM     43  O   HIS A   6      31.324  15.624  13.921  1.00 18.49           O  
ATOM     44  CB  HIS A   6      34.266  16.992  13.082  1.00 20.76           C  
ATOM     45  CG  HIS A   6      33.364  18.168  13.287  1.00 19.98           C  
ATOM     46  ND1 HIS A   6      33.165  18.745  14.522  1.00 21.39           N  
ATOM     47  CD2 HIS A   6      32.582  18.854  12.420  1.00 21.51           C  
ATOM     48  CE1 HIS A   6      32.300  19.737  14.408  1.00 20.93           C  
ATOM     49  NE2 HIS A   6      31.930  19.824  13.142  1.00 22.74           N  
ATOM     50  N   MET A   7      32.152  15.162  11.877  1.00 18.36           N  
ATOM     51  CA  MET A   7      30.831  14.966  11.293  1.00 18.26           C  
ATOM     52  C   MET A   7      30.063  13.867  12.020  1.00 15.50           C  
ATOM     53  O   MET A   7      28.878  14.019  12.301  1.00 15.94           O  
ATOM     54  CB  MET A   7      30.959  14.674   9.794  1.00 15.46           C  
ATOM     55  CG  MET A   7      31.596  15.842   9.024  1.00 13.98           C  
ATOM     56  SD  MET A   7      31.349  15.781   7.245  1.00 17.93           S  
ATOM     57  CE  MET A   7      32.782  14.843   6.704  1.00 19.42           C  
ATOM     58  N   THR A   8      30.743  12.774  12.341  1.00 11.26           N  
ATOM     59  CA  THR A   8      30.121  11.681  13.071  1.00 10.68           C  
ATOM     60  C   THR A   8      29.704  12.180  14.462  1.00 11.30           C  
ATOM     61  O   THR A   8      28.619  11.881  14.938  1.00 10.33           O  
ATOM     62  CB  THR A   8      31.096  10.502  13.233  1.00 12.87           C  
ATOM     63  OG1 THR A   8      31.370   9.931  11.947  1.00 14.42           O  
ATOM     64  CG2 THR A   8      30.485   9.423  14.137  1.00 11.63           C  
ATOM     65  N   ALA A   9      30.576  12.953  15.103  1.00 14.70           N  
ATOM     66  CA  ALA A   9      30.286  13.485  16.432  1.00 15.39           C  
ATOM     67  C   ALA A   9      29.003  14.301  16.405  1.00 16.07           C  
ATOM     68  O   ALA A   9      28.176  14.208  17.318  1.00 16.36           O  
ATOM     69  CB  ALA A   9      31.454  14.347  16.919  1.00 20.02           C  
ATOM     70  N   VAL A  10      28.843  15.098  15.349  1.00 11.87           N  
ATOM     71  CA  VAL A  10      27.664  15.935  15.181  1.00 12.24           C  
ATOM     72  C   VAL A  10      26.442  15.051  14.958  1.00 11.95           C  
ATOM     73  O   VAL A  10      25.378  15.293  15.533  1.00 13.88           O  
ATOM     74  CB  VAL A  10      27.844  16.927  13.996  1.00 13.94           C  
ATOM     75  CG1 VAL A  10      26.547  17.659  13.721  1.00 15.83           C  
ATOM     76  CG2 VAL A  10      28.940  17.938  14.320  1.00 16.86           C  
ATOM     77  N   VAL A  11      26.594  14.021  14.131  1.00 17.23           N  
ATOM     78  CA  VAL A  11      25.495  13.089  13.875  1.00 16.50           C  
ATOM     79  C   VAL A  11      24.977  12.527  15.203  1.00 16.90           C  
ATOM     80  O   VAL A  11      23.773  12.493  15.452  1.00 17.96           O  
ATOM     81  CB  VAL A  11      25.956  11.913  12.991  1.00 11.30           C  
ATOM     82  CG1 VAL A  11      24.886  10.825  12.966  1.00 10.99           C  
ATOM     83  CG2 VAL A  11      26.247  12.411  11.582  1.00  9.79           C  
ATOM     84  N   GLN A  12      25.897  12.095  16.057  1.00 11.31           N  
ATOM     85  CA  GLN A  12      25.515  11.534  17.343  1.00 12.91           C  
ATOM     86  C   GLN A  12      24.916  12.557  18.305  1.00 13.94           C  
ATOM     87  O   GLN A  12      23.972  12.244  19.033  1.00 11.92           O  
ATOM     88  CB  GLN A  12      26.708  10.822  17.985  1.00 21.89           C  
ATOM     89  CG  GLN A  12      26.559   9.302  17.973  1.00 25.22           C  
ATOM     90  CD  GLN A  12      27.781   8.586  17.443  1.00 26.03           C  
ATOM     91  OE1 GLN A  12      27.822   7.358  17.412  1.00 26.52           O  
ATOM     92  NE2 GLN A  12      28.785   9.349  17.020  1.00 28.02           N  
ATOM     93  N   ARG A  13      25.449  13.777  18.314  1.00 16.66           N  
ATOM     94  CA  ARG A  13      24.903  14.813  19.187  1.00 18.67           C  
ATOM     95  C   ARG A  13      23.472  15.136  18.755  1.00 18.31           C  
ATOM     96  O   ARG A  13      22.629  15.517  19.578  1.00 15.89           O  
ATOM     97  CB  ARG A  13      25.768  16.072  19.118  1.00 19.21           C  
ATOM     98  CG  ARG A  13      27.002  16.020  19.999  1.00 21.50           C  
ATOM     99  CD  ARG A  13      28.117  16.905  19.456  1.00 25.79           C  
ATOM    100  NE  ARG A  13      27.733  18.308  19.348  1.00 26.47           N  
ATOM    101  CZ  ARG A  13      28.465  19.238  18.736  1.00 31.28           C  
ATOM    102  NH1 ARG A  13      29.625  18.916  18.171  1.00 29.83           N  
ATOM    103  NH2 ARG A  13      28.038  20.496  18.684  1.00 31.90           N  
ATOM    104  N   TYR A  14      23.212  14.977  17.457  1.00 18.97           N  
ATOM    105  CA  TYR A  14      21.896  15.231  16.867  1.00 19.68           C  
ATOM    106  C   TYR A  14      20.897  14.206  17.411  1.00 20.73           C  
ATOM    107  O   TYR A  14      19.811  14.553  17.880  1.00 19.01           O  
ATOM    108  CB  TYR A  14      21.976  15.116  15.334  1.00 15.37           C  
ATOM    109  CG  TYR A  14      20.646  15.241  14.613  1.00 15.73           C  
ATOM    110  CD1 TYR A  14      19.925  16.440  14.632  1.00 13.02           C  
ATOM    111  CD2 TYR A  14      20.099  14.155  13.919  1.00 12.44           C  
ATOM    112  CE1 TYR A  14      18.691  16.551  13.976  1.00 13.61           C  
ATOM    113  CE2 TYR A  14      18.878  14.253  13.271  1.00 12.40           C  
ATOM    114  CZ  TYR A  14      18.174  15.454  13.302  1.00 14.22           C  
ATOM    115  OH  TYR A  14      16.952  15.549  12.674  1.00 15.72           O  
ATOM    116  N   VAL A  15      21.286  12.940  17.345  1.00 19.25           N  
ATOM    117  CA  VAL A  15      20.445  11.861  17.829  1.00 17.02           C  
ATOM    118  C   VAL A  15      20.205  12.027  19.319  1.00 17.53           C  
ATOM    119  O   VAL A  15      19.070  11.977  19.785  1.00 16.52           O  
ATOM    120  CB  VAL A  15      21.113  10.499  17.583  1.00 15.95           C  
ATOM    121  CG1 VAL A  15      20.305   9.397  18.261  1.00 12.65           C  
ATOM    122  CG2 VAL A  15      21.241  10.252  16.072  1.00 12.55           C  
ATOM    123  N   ALA A  16      21.291  12.221  20.061  1.00 21.46           N  
ATOM    124  CA  ALA A  16      21.219  12.390  21.506  1.00 21.80           C  
ATOM    125  C   ALA A  16      20.291  13.542  21.883  1.00 21.34           C  
ATOM    126  O   ALA A  16      19.532  13.442  22.849  1.00 22.64           O  
ATOM    127  CB  ALA A  16      22.615  12.635  22.072  1.00 10.74           C  
ATOM    128  N   ALA A  17      20.356  14.633  21.122  1.00 13.81           N  
ATOM    129  CA  ALA A  17      19.515  15.795  21.397  1.00 13.89           C  
ATOM    130  C   ALA A  17      18.042  15.471  21.171  1.00 14.93           C  
ATOM    131  O   ALA A  17      17.172  15.957  21.903  1.00 14.19           O  
ATOM    132  CB  ALA A  17      19.933  16.976  20.522  1.00 10.52           C  
ATOM    133  N   LEU A  18      17.757  14.658  20.157  1.00 17.30           N  
ATOM    134  CA  LEU A  18      16.379  14.279  19.874  1.00 18.27           C  
ATOM    135  C   LEU A  18      15.849  13.398  21.002  1.00 20.33           C  
ATOM    136  O   LEU A  18      14.699  13.555  21.439  1.00 20.13           O  
ATOM    137  CB  LEU A  18      16.287  13.547  18.534  1.00 21.46           C  
ATOM    138  CG  LEU A  18      16.400  14.387  17.252  1.00 21.05           C  
ATOM    139  CD1 LEU A  18      16.732  13.483  16.076  1.00 19.63           C  
ATOM    140  CD2 LEU A  18      15.103  15.152  17.003  1.00 20.37           C  
ATOM    141  N   ASN A  19      16.696  12.486  21.483  1.00 20.62           N  
ATOM    142  CA  ASN A  19      16.324  11.585  22.577  1.00 21.16           C  
ATOM    143  C   ASN A  19      16.197  12.343  23.888  1.00 21.85           C  
ATOM    144  O   ASN A  19      15.424  11.962  24.769  1.00 21.46           O  
ATOM    145  CB  ASN A  19      17.372  10.489  22.762  1.00 19.81           C  
ATOM    146  CG  ASN A  19      17.252   9.383  21.743  1.00 21.92           C  
ATOM    147  OD1 ASN A  19      16.183   8.786  21.581  1.00 20.66           O  
ATOM    148  ND2 ASN A  19      18.352   9.089  21.056  1.00 17.44           N  
ATOM    149  N   ALA A  20      16.977  13.408  24.027  1.00 27.73           N  
ATOM    150  CA  ALA A  20      16.946  14.210  25.242  1.00 29.24           C  
ATOM    151  C   ALA A  20      15.904  15.322  25.148  1.00 29.40           C  
ATOM    152  O   ALA A  20      15.606  15.989  26.140  1.00 30.32           O  
ATOM    153  CB  ALA A  20      18.331  14.806  25.518  1.00 18.70           C  
ATOM    154  N   GLY A  21      15.349  15.514  23.956  1.00 23.37           N  
ATOM    155  CA  GLY A  21      14.361  16.559  23.770  1.00 23.06           C  
ATOM    156  C   GLY A  21      15.029  17.910  23.891  1.00 24.15           C  
ATOM    157  O   GLY A  21      14.415  18.886  24.316  1.00 25.53           O  
ATOM    158  N   ASP A  22      16.299  17.968  23.514  1.00 28.28           N  
ATOM    159  CA  ASP A  22      17.066  19.206  23.585  1.00 29.29           C  
ATOM    160  C   ASP A  22      16.930  20.006  22.286  1.00 29.82           C  
ATOM    161  O   ASP A  22      17.707  19.822  21.352  1.00 31.12           O  
ATOM    162  CB  ASP A  22      18.540  18.882  23.862  1.00 27.15           C  
ATOM    163  CG  ASP A  22      19.378  20.123  24.132  1.00 30.74           C  
ATOM    164  OD1 ASP A  22      18.805  21.234  24.196  1.00 26.73           O  
ATOM    165  OD2 ASP A  22      20.614  19.981  24.288  1.00 31.59           O  
ATOM    166  N   LEU A  23      15.938  20.893  22.237  1.00 31.48           N  
ATOM    167  CA  LEU A  23      15.701  21.723  21.058  1.00 30.22           C  
ATOM    168  C   LEU A  23      16.860  22.687  20.807  1.00 30.08           C  
ATOM    169  O   LEU A  23      17.285  22.881  19.665  1.00 28.93           O  
ATOM    170  CB  LEU A  23      14.398  22.519  21.224  1.00 21.38           C  
ATOM    171  CG  LEU A  23      14.026  23.526  20.129  1.00 18.02           C  
ATOM    172  CD1 LEU A  23      13.969  22.825  18.781  1.00 19.36           C  
ATOM    173  CD2 LEU A  23      12.673  24.161  20.449  1.00 17.10           C  
ATOM    174  N   ASP A  24      17.366  23.298  21.875  1.00 23.26           N  
ATOM    175  CA  ASP A  24      18.474  24.239  21.743  1.00 23.33           C  
ATOM    176  C   ASP A  24      19.710  23.550  21.169  1.00 21.06           C  
ATOM    177  O   ASP A  24      20.340  24.061  20.238  1.00 21.05           O  
ATOM    178  CB  ASP A  24      18.811  24.869  23.099  1.00 36.11           C  
ATOM    179  CG  ASP A  24      17.775  25.887  23.542  1.00 38.46           C  
ATOM    180  OD1 ASP A  24      17.884  26.389  24.679  1.00 42.70           O  
ATOM    181  OD2 ASP A  24      16.857  26.192  22.753  1.00 38.44           O  
ATOM    182  N   GLY A  25      20.039  22.386  21.721  1.00 21.28           N  
ATOM    183  CA  GLY A  25      21.197  21.642  21.258  1.00 18.70           C  
ATOM    184  C   GLY A  25      21.052  21.240  19.806  1.00 19.25           C  
ATOM    185  O   GLY A  25      22.028  21.243  19.054  1.00 19.94           O  
ATOM    186  N   ILE A  26      19.833  20.891  19.406  1.00 20.18           N  
ATOM    187  CA  ILE A  26      19.585  20.503  18.022  1.00 21.30           C  
ATOM    188  C   ILE A  26      19.901  21.693  17.115  1.00 20.14           C  
ATOM    189  O   ILE A  26      20.784  21.623  16.259  1.00 17.80           O  
ATOM    190  CB  ILE A  26      18.109  20.074  17.806  1.00 22.56           C  
ATOM    191  CG1 ILE A  26      17.824  18.774  18.560  1.00 21.41           C  
ATOM    192  CG2 ILE A  26      17.838  19.885  16.317  1.00 21.42           C  
ATOM    193  CD1 ILE A  26      16.372  18.340  18.537  1.00 23.84           C  
ATOM    194  N   VAL A  27      19.184  22.789  17.333  1.00 20.78           N  
ATOM    195  CA  VAL A  27      19.362  24.005  16.551  1.00 21.29           C  
ATOM    196  C   VAL A  27      20.807  24.503  16.494  1.00 21.87           C  
ATOM    197  O   VAL A  27      21.246  25.005  15.463  1.00 23.00           O  
ATOM    198  CB  VAL A  27      18.490  25.140  17.107  1.00 23.39           C  
ATOM    199  CG1 VAL A  27      18.537  26.335  16.174  1.00 23.56           C  
ATOM    200  CG2 VAL A  27      17.067  24.652  17.296  1.00 23.07           C  
ATOM    201  N   ALA A  28      21.539  24.372  17.597  1.00 25.91           N  
ATOM    202  CA  ALA A  28      22.931  24.824  17.663  1.00 24.47           C  
ATOM    203  C   ALA A  28      23.866  24.046  16.732  1.00 24.97           C  
ATOM    204  O   ALA A  28      25.024  24.426  16.533  1.00 24.63           O  
ATOM    205  CB  ALA A  28      23.438  24.735  19.094  1.00 39.11           C  
ATOM    206  N   LEU A  29      23.373  22.951  16.169  1.00 18.09           N  
ATOM    207  CA  LEU A  29      24.186  22.158  15.252  1.00 16.86           C  
ATOM    208  C   LEU A  29      24.146  22.763  13.853  1.00 16.01           C  
ATOM    209  O   LEU A  29      25.089  22.627  13.077  1.00 17.50           O  
ATOM    210  CB  LEU A  29      23.677  20.721  15.189  1.00 18.40           C  
ATOM    211  CG  LEU A  29      23.630  19.939  16.501  1.00 20.67           C  
ATOM    212  CD1 LEU A  29      23.157  18.527  16.212  1.00 23.10           C  
ATOM    213  CD2 LEU A  29      25.003  19.916  17.151  1.00 20.20           C  
ATOM    214  N   PHE A  30      23.046  23.438  13.546  1.00 18.40           N  
ATOM    215  CA  PHE A  30      22.842  24.048  12.238  1.00 19.83           C  
ATOM    216  C   PHE A  30      23.391  25.460  12.106  1.00 20.11           C  
ATOM    217  O   PHE A  30      23.507  26.183  13.091  1.00 20.90           O  
ATOM    218  CB  PHE A  30      21.349  24.074  11.928  1.00 17.53           C  
ATOM    219  CG  PHE A  30      20.748  22.716  11.727  1.00 17.20           C  
ATOM    220  CD1 PHE A  30      20.573  22.204  10.447  1.00 17.75           C  
ATOM    221  CD2 PHE A  30      20.347  21.948  12.815  1.00 18.19           C  
ATOM    222  CE1 PHE A  30      20.001  20.942  10.249  1.00 18.40           C  
ATOM    223  CE2 PHE A  30      19.772  20.683  12.629  1.00 17.56           C  
ATOM    224  CZ  PHE A  30      19.599  20.182  11.343  1.00 18.17           C  
ATOM    225  N   ALA A  31      23.722  25.845  10.876  1.00 22.45           N  
ATOM    226  CA  ALA A  31      24.217  27.191  10.593  1.00 23.75           C  
ATOM    227  C   ALA A  31      22.990  28.096  10.564  1.00 24.86           C  
ATOM    228  O   ALA A  31      21.863  27.608  10.463  1.00 22.75           O  
ATOM    229  CB  ALA A  31      24.914  27.230   9.244  1.00 15.84           C  
ATOM    230  N   ASP A  32      23.199  29.405  10.647  1.00 24.40           N  
ATOM    231  CA  ASP A  32      22.077  30.338  10.631  1.00 26.80           C  
ATOM    232  C   ASP A  32      21.433  30.396   9.249  1.00 26.20           C  
ATOM    233  O   ASP A  32      20.313  30.870   9.098  1.00 26.68           O  
ATOM    234  CB  ASP A  32      22.535  31.739  11.042  1.00 76.40           C  
ATOM    235  CG  ASP A  32      23.553  32.325  10.086  1.00 81.99           C  
ATOM    236  OD1 ASP A  32      23.933  33.500  10.277  1.00 86.23           O  
ATOM    237  OD2 ASP A  32      23.975  31.614   9.148  1.00 84.75           O  
ATOM    238  N   ASP A  33      22.143  29.902   8.242  1.00 27.32           N  
ATOM    239  CA  ASP A  33      21.632  29.911   6.875  1.00 26.96           C  
ATOM    240  C   ASP A  33      21.215  28.520   6.397  1.00 25.10           C  
ATOM    241  O   ASP A  33      20.842  28.344   5.238  1.00 22.87           O  
ATOM    242  CB  ASP A  33      22.705  30.468   5.939  1.00 47.58           C  
ATOM    243  CG  ASP A  33      23.995  29.668   5.996  1.00 50.78           C  
ATOM    244  OD1 ASP A  33      24.534  29.484   7.107  1.00 53.48           O  
ATOM    245  OD2 ASP A  33      24.472  29.226   4.931  1.00 53.49           O  
ATOM    246  N   ALA A  34      21.267  27.542   7.297  1.00 26.46           N  
ATOM    247  CA  ALA A  34      20.941  26.156   6.969  1.00 25.79           C  
ATOM    248  C   ALA A  34      19.513  25.892   6.508  1.00 25.80           C  
ATOM    249  O   ALA A  34      18.608  26.702   6.724  1.00 25.73           O  
ATOM    250  CB  ALA A  34      21.267  25.262   8.159  1.00 35.25           C  
ATOM    251  N   THR A  35      19.328  24.740   5.866  1.00 22.39           N  
ATOM    252  CA  THR A  35      18.024  24.317   5.374  1.00 20.28           C  
ATOM    253  C   THR A  35      17.754  22.873   5.776  1.00 19.06           C  
ATOM    254  O   THR A  35      18.665  22.047   5.812  1.00 17.70           O  
ATOM    255  CB  THR A  35      17.943  24.392   3.848  1.00 20.57           C  
ATOM    256  OG1 THR A  35      18.922  23.514   3.282  1.00 21.60           O  
ATOM    257  CG2 THR A  35      18.193  25.813   3.366  1.00 23.73           C  
ATOM    258  N   VAL A  36      16.489  22.588   6.064  1.00 20.59           N  
ATOM    259  CA  VAL A  36      16.028  21.261   6.459  1.00 21.88           C  
ATOM    260  C   VAL A  36      14.898  20.814   5.523  1.00 22.40           C  
ATOM    261  O   VAL A  36      13.871  21.490   5.402  1.00 23.16           O  
ATOM    262  CB  VAL A  36      15.481  21.270   7.917  1.00 25.97           C  
ATOM    263  CG1 VAL A  36      14.746  19.969   8.222  1.00 25.15           C  
ATOM    264  CG2 VAL A  36      16.623  21.470   8.898  1.00 25.18           C  
ATOM    265  N   GLU A  37      15.096  19.683   4.853  1.00 18.98           N  
ATOM    266  CA  GLU A  37      14.083  19.139   3.956  1.00 17.63           C  
ATOM    267  C   GLU A  37      13.657  17.771   4.476  1.00 18.88           C  
ATOM    268  O   GLU A  37      14.257  16.756   4.140  1.00 19.29           O  
ATOM    269  CB  GLU A  37      14.634  19.008   2.537  1.00 19.81           C  
ATOM    270  CG  GLU A  37      13.644  18.387   1.556  1.00 19.41           C  
ATOM    271  CD  GLU A  37      14.154  18.380   0.134  1.00 19.85           C  
ATOM    272  OE1 GLU A  37      13.488  17.782  -0.735  1.00 21.30           O  
ATOM    273  OE2 GLU A  37      15.222  18.973  -0.117  1.00 21.05           O  
ATOM    274  N   ASP A  38      12.616  17.758   5.304  1.00 20.55           N  
ATOM    275  CA  ASP A  38      12.111  16.526   5.893  1.00 19.67           C  
ATOM    276  C   ASP A  38      10.591  16.419   5.778  1.00 21.35           C  
ATOM    277  O   ASP A  38       9.853  17.171   6.418  1.00 20.16           O  
ATOM    278  CB  ASP A  38      12.512  16.432   7.366  1.00 16.19           C  
ATOM    279  CG  ASP A  38      12.056  15.139   8.013  1.00 15.99           C  
ATOM    280  OD1 ASP A  38      11.130  14.498   7.471  1.00 15.29           O  
ATOM    281  OD2 ASP A  38      12.623  14.767   9.061  1.00 20.00           O  
ATOM    282  N   PRO A  39      10.104  15.455   4.978  1.00 22.04           N  
ATOM    283  CA  PRO A  39      10.945  14.520   4.226  1.00 21.80           C  
ATOM    284  C   PRO A  39      11.330  15.062   2.860  1.00 21.71           C  
ATOM    285  O   PRO A  39      10.837  16.114   2.438  1.00 20.97           O  
ATOM    286  CB  PRO A  39      10.061  13.289   4.119  1.00 46.21           C  
ATOM    287  CG  PRO A  39       8.713  13.900   3.904  1.00 47.07           C  
ATOM    288  CD  PRO A  39       8.689  15.045   4.919  1.00 44.98           C  
ATOM    289  N   VAL A  40      12.213  14.332   2.180  1.00 24.14           N  
ATOM    290  CA  VAL A  40      12.673  14.685   0.845  1.00 23.55           C  
ATOM    291  C   VAL A  40      11.473  14.845  -0.092  1.00 25.41           C  
ATOM    292  O   VAL A  40      10.568  14.007  -0.111  1.00 24.09           O  
ATOM    293  CB  VAL A  40      13.633  13.590   0.273  1.00 16.70           C  
ATOM    294  CG1 VAL A  40      13.731  13.708  -1.248  1.00 14.23           C  
ATOM    295  CG2 VAL A  40      15.022  13.749   0.888  1.00 14.01           C  
ATOM    296  N   GLY A  41      11.482  15.920  -0.872  1.00 20.97           N  
ATOM    297  CA  GLY A  41      10.390  16.177  -1.787  1.00 22.21           C  
ATOM    298  C   GLY A  41       9.500  17.269  -1.225  1.00 24.55           C  
ATOM    299  O   GLY A  41       8.699  17.861  -1.948  1.00 24.27           O  
ATOM    300  N   SER A  42       9.644  17.537   0.072  1.00 23.47           N  
ATOM    301  CA  SER A  42       8.850  18.564   0.732  1.00 23.61           C  
ATOM    302  C   SER A  42       9.541  19.922   0.673  1.00 24.01           C  
ATOM    303  O   SER A  42      10.729  20.024   0.357  1.00 21.64           O  
ATOM    304  CB  SER A  42       8.588  18.190   2.193  1.00 29.55           C  
ATOM    305  OG  SER A  42       9.774  18.275   2.963  1.00 28.78           O  
ATOM    306  N   GLU A  43       8.774  20.962   0.982  1.00 23.91           N  
ATOM    307  CA  GLU A  43       9.260  22.334   0.971  1.00 24.68           C  
ATOM    308  C   GLU A  43      10.293  22.490   2.080  1.00 23.92           C  
ATOM    309  O   GLU A  43       9.958  22.444   3.262  1.00 21.39           O  
ATOM    310  CB  GLU A  43       8.093  23.297   1.204  1.00 50.32           C  
ATOM    311  CG  GLU A  43       6.762  22.795   0.647  1.00 54.13           C  
ATOM    312  CD  GLU A  43       6.129  21.713   1.515  1.00 55.15           C  
ATOM    313  OE1 GLU A  43       5.412  20.849   0.965  1.00 56.21           O  
ATOM    314  OE2 GLU A  43       6.339  21.736   2.747  1.00 56.01           O  
ATOM    315  N   PRO A  44      11.566  22.680   1.706  1.00 31.73           N  
ATOM    316  CA  PRO A  44      12.671  22.843   2.653  1.00 32.39           C  
ATOM    317  C   PRO A  44      12.516  24.071   3.537  1.00 33.44           C  
ATOM    318  O   PRO A  44      12.142  25.142   3.062  1.00 37.07           O  
ATOM    319  CB  PRO A  44      13.895  22.966   1.745  1.00 32.33           C  
ATOM    320  CG  PRO A  44      13.472  22.263   0.485  1.00 34.56           C  
ATOM    321  CD  PRO A  44      12.058  22.736   0.321  1.00 31.63           C  
ATOM    322  N   ARG A  45      12.800  23.920   4.822  1.00 24.48           N  
ATOM    323  CA  ARG A  45      12.717  25.047   5.731  1.00 23.72           C  
ATOM    324  C   ARG A  45      14.093  25.701   5.782  1.00 22.41           C  
ATOM    325  O   ARG A  45      15.108  25.023   5.945  1.00 19.72           O  
ATOM    326  CB  ARG A  45      12.300  24.592   7.126  1.00 32.39           C  
ATOM    327  CG  ARG A  45      10.888  24.061   7.216  1.00 36.61           C  
ATOM    328  CD  ARG A  45      10.816  22.577   6.927  1.00 40.39           C  
ATOM    329  NE  ARG A  45       9.494  22.050   7.254  1.00 43.77           N  
ATOM    330  CZ  ARG A  45       9.174  20.760   7.252  1.00 45.13           C  
ATOM    331  NH1 ARG A  45      10.081  19.846   6.937  1.00 47.88           N  
ATOM    332  NH2 ARG A  45       7.945  20.382   7.574  1.00 45.96           N  
ATOM    333  N   SER A  46      14.130  27.019   5.632  1.00 23.68           N  
ATOM    334  CA  SER A  46      15.396  27.735   5.662  1.00 24.74           C  
ATOM    335  C   SER A  46      15.474  28.658   6.874  1.00 22.79           C  
ATOM    336  O   SER A  46      14.472  29.231   7.287  1.00 23.25           O  
ATOM    337  CB  SER A  46      15.565  28.553   4.376  1.00 26.62           C  
ATOM    338  OG  SER A  46      16.768  29.296   4.405  1.00 29.06           O  
ATOM    339  N   GLY A  47      16.663  28.786   7.452  1.00 21.58           N  
ATOM    340  CA  GLY A  47      16.838  29.668   8.592  1.00 22.47           C  
ATOM    341  C   GLY A  47      16.622  29.095   9.978  1.00 21.48           C  
ATOM    342  O   GLY A  47      15.847  28.163  10.170  1.00 22.60           O  
ATOM    343  N   THR A  48      17.315  29.685  10.947  1.00 27.65           N  
ATOM    344  CA  THR A  48      17.250  29.286  12.347  1.00 28.40           C  
ATOM    345  C   THR A  48      15.820  29.181  12.863  1.00 28.22           C  
ATOM    346  O   THR A  48      15.431  28.160  13.429  1.00 28.99           O  
ATOM    347  CB  THR A  48      18.016  30.296  13.238  1.00 25.67           C  
ATOM    348  OG1 THR A  48      19.404  30.283  12.892  1.00 24.54           O  
ATOM    349  CG2 THR A  48      17.860  29.943  14.707  1.00 25.33           C  
ATOM    350  N   ALA A  49      15.044  30.244  12.674  1.00 23.48           N  
ATOM    351  CA  ALA A  49      13.657  30.274  13.131  1.00 23.77           C  
ATOM    352  C   ALA A  49      12.827  29.152  12.517  1.00 22.66           C  
ATOM    353  O   ALA A  49      12.161  28.405  13.225  1.00 21.97           O  
ATOM    354  CB  ALA A  49      13.033  31.627  12.799  1.00 57.91           C  
ATOM    355  N   ALA A  50      12.863  29.043  11.194  1.00 25.23           N  
ATOM    356  CA  ALA A  50      12.114  28.001  10.509  1.00 24.62           C  
ATOM    357  C   ALA A  50      12.527  26.644  11.072  1.00 25.09           C  
ATOM    358  O   ALA A  50      11.684  25.814  11.412  1.00 24.71           O  
ATOM    359  CB  ALA A  50      12.391  28.055   9.016  1.00 36.65           C  
ATOM    360  N   ILE A  51      13.835  26.442  11.180  1.00 23.91           N  
ATOM    361  CA  ILE A  51      14.391  25.200  11.695  1.00 24.03           C  
ATOM    362  C   ILE A  51      13.960  24.916  13.138  1.00 25.22           C  
ATOM    363  O   ILE A  51      13.613  23.781  13.470  1.00 25.90           O  
ATOM    364  CB  ILE A  51      15.938  25.230  11.596  1.00 18.48           C  
ATOM    365  CG1 ILE A  51      16.348  25.261  10.124  1.00 17.80           C  
ATOM    366  CG2 ILE A  51      16.546  24.017  12.297  1.00 18.14           C  
ATOM    367  CD1 ILE A  51      17.788  25.600   9.887  1.00 17.99           C  
ATOM    368  N   ARG A  52      13.967  25.940  13.991  1.00 22.68           N  
ATOM    369  CA  ARG A  52      13.577  25.756  15.386  1.00 23.01           C  
ATOM    370  C   ARG A  52      12.115  25.351  15.494  1.00 23.43           C  
ATOM    371  O   ARG A  52      11.749  24.512  16.322  1.00 23.90           O  
ATOM    372  CB  ARG A  52      13.826  27.035  16.193  1.00 30.69           C  
ATOM    373  CG  ARG A  52      13.726  26.839  17.706  1.00 33.51           C  
ATOM    374  CD  ARG A  52      14.003  28.135  18.470  1.00 35.73           C  
ATOM    375  NE  ARG A  52      13.684  28.020  19.892  1.00 38.41           N  
ATOM    376  CZ  ARG A  52      14.401  27.331  20.776  1.00 40.60           C  
ATOM    377  NH1 ARG A  52      15.496  26.687  20.390  1.00 40.89           N  
ATOM    378  NH2 ARG A  52      14.024  27.283  22.048  1.00 39.61           N  
ATOM    379  N   GLU A  53      11.281  25.959  14.661  1.00 28.40           N  
ATOM    380  CA  GLU A  53       9.860  25.651  14.636  1.00 28.92           C  
ATOM    381  C   GLU A  53       9.697  24.181  14.268  1.00 28.10           C  
ATOM    382  O   GLU A  53       8.895  23.460  14.865  1.00 28.23           O  
ATOM    383  CB  GLU A  53       9.152  26.527  13.597  1.00 60.79           C  
ATOM    384  CG  GLU A  53       7.709  26.131  13.302  1.00 64.89           C  
ATOM    385  CD  GLU A  53       6.772  26.390  14.467  1.00 68.36           C  
ATOM    386  OE1 GLU A  53       5.589  25.995  14.380  1.00 71.93           O  
ATOM    387  OE2 GLU A  53       7.211  26.992  15.467  1.00 70.88           O  
ATOM    388  N   PHE A  54      10.474  23.742  13.285  1.00 24.67           N  
ATOM    389  CA  PHE A  54      10.418  22.361  12.822  1.00 23.93           C  
ATOM    390  C   PHE A  54      10.661  21.342  13.933  1.00 21.36           C  
ATOM    391  O   PHE A  54       9.818  20.481  14.180  1.00 19.80           O  
ATOM    392  CB  PHE A  54      11.436  22.122  11.705  1.00 25.75           C  
ATOM    393  CG  PHE A  54      11.372  20.739  11.129  1.00 28.08           C  
ATOM    394  CD1 PHE A  54      10.326  20.367  10.295  1.00 27.32           C  
ATOM    395  CD2 PHE A  54      12.323  19.783  11.472  1.00 28.48           C  
ATOM    396  CE1 PHE A  54      10.224  19.062   9.812  1.00 29.11           C  
ATOM    397  CE2 PHE A  54      12.228  18.475  10.994  1.00 28.22           C  
ATOM    398  CZ  PHE A  54      11.176  18.116  10.165  1.00 27.46           C  
ATOM    399  N   TYR A  55      11.811  21.431  14.596  1.00 16.35           N  
ATOM    400  CA  TYR A  55      12.127  20.487  15.657  1.00 16.76           C  
ATOM    401  C   TYR A  55      11.229  20.696  16.866  1.00 19.19           C  
ATOM    402  O   TYR A  55      10.972  19.768  17.642  1.00 17.49           O  
ATOM    403  CB  TYR A  55      13.610  20.581  16.034  1.00 19.83           C  
ATOM    404  CG  TYR A  55      14.504  19.945  14.986  1.00 19.61           C  
ATOM    405  CD1 TYR A  55      15.272  20.721  14.119  1.00 20.88           C  
ATOM    406  CD2 TYR A  55      14.501  18.560  14.798  1.00 20.41           C  
ATOM    407  CE1 TYR A  55      16.015  20.125  13.078  1.00 18.17           C  
ATOM    408  CE2 TYR A  55      15.228  17.963  13.767  1.00 18.75           C  
ATOM    409  CZ  TYR A  55      15.978  18.748  12.910  1.00 18.72           C  
ATOM    410  OH  TYR A  55      16.658  18.147  11.871  1.00 15.43           O  
ATOM    411  N   ALA A  56      10.738  21.919  17.015  1.00 29.77           N  
ATOM    412  CA  ALA A  56       9.844  22.230  18.116  1.00 31.46           C  
ATOM    413  C   ALA A  56       8.633  21.315  17.978  1.00 31.60           C  
ATOM    414  O   ALA A  56       8.251  20.612  18.917  1.00 31.62           O  
ATOM    415  CB  ALA A  56       9.418  23.682  18.037  1.00 25.11           C  
ATOM    416  N   ASN A  57       8.045  21.320  16.787  1.00 28.81           N  
ATOM    417  CA  ASN A  57       6.873  20.506  16.491  1.00 30.87           C  
ATOM    418  C   ASN A  57       7.164  19.007  16.551  1.00 30.30           C  
ATOM    419  O   ASN A  57       6.317  18.221  16.980  1.00 29.12           O  
ATOM    420  CB  ASN A  57       6.327  20.864  15.105  1.00 62.38           C  
ATOM    421  CG  ASN A  57       5.904  22.317  15.002  1.00 64.95           C  
ATOM    422  OD1 ASN A  57       5.065  22.789  15.770  1.00 67.13           O  
ATOM    423  ND2 ASN A  57       6.481  23.034  14.045  1.00 67.88           N  
ATOM    424  N   SER A  58       8.360  18.619  16.117  1.00 27.11           N  
ATOM    425  CA  SER A  58       8.769  17.214  16.108  1.00 27.81           C  
ATOM    426  C   SER A  58       8.900  16.619  17.509  1.00 27.98           C  
ATOM    427  O   SER A  58       8.814  15.400  17.689  1.00 29.04           O  
ATOM    428  CB  SER A  58      10.103  17.058  15.371  1.00 30.73           C  
ATOM    429  OG  SER A  58       9.994  17.471  14.021  1.00 32.92           O  
ATOM    430  N   LEU A  59       9.112  17.476  18.501  1.00 31.53           N  
ATOM    431  CA  LEU A  59       9.275  17.010  19.866  1.00 31.42           C  
ATOM    432  C   LEU A  59       8.000  17.071  20.694  1.00 33.01           C  
ATOM    433  O   LEU A  59       8.054  17.086  21.924  1.00 32.71           O  
ATOM    434  CB  LEU A  59      10.380  17.805  20.556  1.00 23.15           C  
ATOM    435  CG  LEU A  59      11.785  17.568  20.000  1.00 21.73           C  
ATOM    436  CD1 LEU A  59      12.775  18.456  20.745  1.00 21.28           C  
ATOM    437  CD2 LEU A  59      12.159  16.080  20.142  1.00 20.76           C  
ATOM    438  N   LYS A  60       6.857  17.101  20.013  1.00 48.27           N  
ATOM    439  CA  LYS A  60       5.559  17.130  20.681  1.00 48.68           C  
ATOM    440  C   LYS A  60       5.395  15.841  21.485  1.00 47.19           C  
ATOM    441  O   LYS A  60       4.850  15.850  22.587  1.00 48.81           O  
ATOM    442  CB  LYS A  60       4.434  17.231  19.645  1.00 36.76           C  
ATOM    443  CG  LYS A  60       3.757  18.592  19.537  1.00 36.97           C  
ATOM    444  CD  LYS A  60       4.727  19.706  19.180  1.00 36.80           C  
ATOM    445  CE  LYS A  60       3.987  20.935  18.646  1.00 36.24           C  
ATOM    446  NZ  LYS A  60       2.947  21.473  19.573  1.00 33.86           N  
ATOM    447  N   LEU A  61       5.873  14.737  20.918  1.00 22.52           N  
ATOM    448  CA  LEU A  61       5.796  13.428  21.559  1.00 22.74           C  
ATOM    449  C   LEU A  61       7.211  12.954  21.858  1.00 22.70           C  
ATOM    450  O   LEU A  61       8.116  13.154  21.052  1.00 24.18           O  
ATOM    451  CB  LEU A  61       5.143  12.410  20.618  1.00 45.40           C  
ATOM    452  CG  LEU A  61       3.945  12.813  19.755  1.00 45.39           C  
ATOM    453  CD1 LEU A  61       3.692  11.723  18.726  1.00 46.36           C  
ATOM    454  CD2 LEU A  61       2.719  13.039  20.621  1.00 45.48           C  
ATOM    455  N   PRO A  62       7.431  12.315  23.016  1.00 38.53           N  
ATOM    456  CA  PRO A  62       8.799  11.860  23.277  1.00 38.07           C  
ATOM    457  C   PRO A  62       9.241  10.917  22.151  1.00 37.34           C  
ATOM    458  O   PRO A  62       8.477  10.052  21.721  1.00 37.72           O  
ATOM    459  CB  PRO A  62       8.678  11.163  24.632  1.00 38.02           C  
ATOM    460  CG  PRO A  62       7.272  10.663  24.633  1.00 40.11           C  
ATOM    461  CD  PRO A  62       6.506  11.834  24.055  1.00 39.80           C  
ATOM    462  N   LEU A  63      10.466  11.097  21.669  1.00 28.19           N  
ATOM    463  CA  LEU A  63      10.987  10.278  20.578  1.00 24.87           C  
ATOM    464  C   LEU A  63      12.133   9.377  21.017  1.00 23.61           C  
ATOM    465  O   LEU A  63      12.983   9.772  21.810  1.00 24.01           O  
ATOM    466  CB  LEU A  63      11.490  11.173  19.443  1.00 23.30           C  
ATOM    467  CG  LEU A  63      10.618  12.324  18.939  1.00 24.27           C  
ATOM    468  CD1 LEU A  63      11.410  13.148  17.927  1.00 22.23           C  
ATOM    469  CD2 LEU A  63       9.346  11.783  18.314  1.00 24.27           C  
ATOM    470  N   ALA A  64      12.145   8.159  20.497  1.00 21.94           N  
ATOM    471  CA  ALA A  64      13.209   7.216  20.795  1.00 20.79           C  
ATOM    472  C   ALA A  64      13.963   7.087  19.480  1.00 19.41           C  
ATOM    473  O   ALA A  64      13.481   6.460  18.536  1.00 20.13           O  
ATOM    474  CB  ALA A  64      12.628   5.883  21.227  1.00 16.05           C  
ATOM    475  N   VAL A  65      15.136   7.710  19.414  1.00 20.65           N  
ATOM    476  CA  VAL A  65      15.940   7.703  18.195  1.00 21.03           C  
ATOM    477  C   VAL A  65      17.252   6.942  18.329  1.00 21.55           C  
ATOM    478  O   VAL A  65      18.039   7.183  19.246  1.00 21.79           O  
ATOM    479  CB  VAL A  65      16.255   9.133  17.755  1.00 20.08           C  
ATOM    480  CG1 VAL A  65      17.005   9.119  16.418  1.00 18.64           C  
ATOM    481  CG2 VAL A  65      14.969   9.932  17.673  1.00 19.97           C  
ATOM    482  N   GLU A  66      17.498   6.037  17.390  1.00 17.17           N  
ATOM    483  CA  GLU A  66      18.706   5.241  17.434  1.00 16.42           C  
ATOM    484  C   GLU A  66      19.367   5.055  16.084  1.00 13.95           C  
ATOM    485  O   GLU A  66      18.703   4.889  15.065  1.00 11.61           O  
ATOM    486  CB  GLU A  66      18.405   3.856  18.020  1.00 55.35           C  
ATOM    487  CG  GLU A  66      17.721   3.864  19.376  1.00 62.68           C  
ATOM    488  CD  GLU A  66      17.400   2.464  19.867  1.00 66.53           C  
ATOM    489  OE1 GLU A  66      16.843   2.328  20.978  1.00 70.71           O  
ATOM    490  OE2 GLU A  66      17.707   1.495  19.141  1.00 68.63           O  
ATOM    491  N   LEU A  67      20.692   5.098  16.093  1.00 15.27           N  
ATOM    492  CA  LEU A  67      21.477   4.875  14.896  1.00 14.22           C  
ATOM    493  C   LEU A  67      21.472   3.355  14.756  1.00 14.19           C  
ATOM    494  O   LEU A  67      21.629   2.636  15.749  1.00 11.16           O  
ATOM    495  CB  LEU A  67      22.890   5.434  15.107  1.00 15.14           C  
ATOM    496  CG  LEU A  67      22.919   6.961  14.920  1.00 15.42           C  
ATOM    497  CD1 LEU A  67      24.151   7.610  15.557  1.00 14.38           C  
ATOM    498  CD2 LEU A  67      22.872   7.234  13.429  1.00 15.55           C  
ATOM    499  N   THR A  68      21.269   2.868  13.534  1.00 13.77           N  
ATOM    500  CA  THR A  68      21.206   1.431  13.282  1.00 14.68           C  
ATOM    501  C   THR A  68      22.421   0.899  12.522  1.00 15.03           C  
ATOM    502  O   THR A  68      22.584  -0.316  12.337  1.00 12.41           O  
ATOM    503  CB  THR A  68      19.909   1.073  12.514  1.00 12.76           C  
ATOM    504  OG1 THR A  68      19.863   1.797  11.280  1.00 12.94           O  
ATOM    505  CG2 THR A  68      18.677   1.446  13.350  1.00 12.01           C  
ATOM    506  N   GLN A  69      23.266   1.814  12.070  1.00 16.33           N  
ATOM    507  CA  GLN A  69      24.485   1.433  11.376  1.00 16.77           C  
ATOM    508  C   GLN A  69      25.527   2.501  11.576  1.00 15.82           C  
ATOM    509  O   GLN A  69      25.243   3.585  12.089  1.00 15.16           O  
ATOM    510  CB  GLN A  69      24.264   1.242   9.875  1.00 12.56           C  
ATOM    511  CG  GLN A  69      23.378   0.083   9.518  1.00 14.45           C  
ATOM    512  CD  GLN A  69      23.442  -0.243   8.047  1.00 16.14           C  
ATOM    513  OE1 GLN A  69      23.741   0.618   7.221  1.00 16.34           O  
ATOM    514  NE2 GLN A  69      23.152  -1.487   7.707  1.00 14.72           N  
ATOM    515  N   GLU A  70      26.745   2.167  11.177  1.00 12.96           N  
ATOM    516  CA  GLU A  70      27.869   3.079  11.278  1.00 11.82           C  
ATOM    517  C   GLU A  70      27.534   4.322  10.460  1.00  9.02           C  
ATOM    518  O   GLU A  70      26.825   4.235   9.459  1.00  7.09           O  
ATOM    519  CB  GLU A  70      29.113   2.412  10.690  1.00 13.85           C  
ATOM    520  CG  GLU A  70      28.987   2.159   9.188  1.00 14.78           C  
ATOM    521  CD  GLU A  70      29.980   1.135   8.676  1.00 15.78           C  
ATOM    522  OE1 GLU A  70      29.830  -0.051   9.025  1.00 16.76           O  
ATOM    523  OE2 GLU A  70      30.905   1.517   7.932  1.00 14.38           O  
ATOM    524  N   VAL A  71      28.040   5.469  10.889  1.00 10.50           N  
ATOM    525  CA  VAL A  71      27.830   6.711  10.158  1.00 10.59           C  
ATOM    526  C   VAL A  71      28.767   6.730   8.950  1.00 11.50           C  
ATOM    527  O   VAL A  71      29.895   6.221   9.008  1.00 13.10           O  
ATOM    528  CB  VAL A  71      28.155   7.952  11.035  1.00 16.61           C  
ATOM    529  CG1 VAL A  71      28.005   9.235  10.210  1.00 13.46           C  
ATOM    530  CG2 VAL A  71      27.232   8.000  12.247  1.00 15.09           C  
ATOM    531  N   ARG A  72      28.294   7.291   7.845  1.00 14.32           N  
ATOM    532  CA  ARG A  72      29.128   7.419   6.653  1.00 14.07           C  
ATOM    533  C   ARG A  72      29.535   8.882   6.623  1.00 15.07           C  
ATOM    534  O   ARG A  72      28.686   9.766   6.733  1.00 14.37           O  
ATOM    535  CB  ARG A  72      28.350   7.092   5.378  1.00 11.25           C  
ATOM    536  CG  ARG A  72      28.230   5.610   5.056  1.00 10.09           C  
ATOM    537  CD  ARG A  72      27.463   4.803   6.108  1.00  9.19           C  
ATOM    538  NE  ARG A  72      27.091   3.512   5.535  1.00 10.98           N  
ATOM    539  CZ  ARG A  72      26.300   2.611   6.105  1.00  9.31           C  
ATOM    540  NH1 ARG A  72      25.774   2.831   7.307  1.00  7.25           N  
ATOM    541  NH2 ARG A  72      26.004   1.498   5.441  1.00  9.60           N  
ATOM    542  N   ALA A  73      30.825   9.146   6.483  1.00 11.36           N  
ATOM    543  CA  ALA A  73      31.265  10.528   6.456  1.00 10.72           C  
ATOM    544  C   ALA A  73      32.462  10.731   5.556  1.00 12.46           C  
ATOM    545  O   ALA A  73      33.404   9.936   5.571  1.00 11.14           O  
ATOM    546  CB  ALA A  73      31.579  10.997   7.871  1.00  8.46           C  
ATOM    547  N   VAL A  74      32.412  11.798   4.761  1.00 11.71           N  
ATOM    548  CA  VAL A  74      33.503  12.121   3.853  1.00 13.90           C  
ATOM    549  C   VAL A  74      33.238  13.465   3.168  1.00 14.27           C  
ATOM    550  O   VAL A  74      32.096  13.890   3.046  1.00 15.31           O  
ATOM    551  CB  VAL A  74      33.657  11.011   2.784  1.00 22.35           C  
ATOM    552  CG1 VAL A  74      32.536  11.118   1.745  1.00 23.14           C  
ATOM    553  CG2 VAL A  74      35.039  11.088   2.137  1.00 24.75           C  
ATOM    554  N   ALA A  75      34.300  14.144   2.755  1.00 23.35           N  
ATOM    555  CA  ALA A  75      34.183  15.425   2.049  1.00 24.19           C  
ATOM    556  C   ALA A  75      33.026  16.335   2.459  1.00 25.22           C  
ATOM    557  O   ALA A  75      32.104  16.557   1.684  1.00 27.71           O  
ATOM    558  CB  ALA A  75      34.107  15.163   0.543  1.00 15.14           C  
ATOM    559  N   ASN A  76      33.088  16.876   3.667  1.00 20.80           N  
ATOM    560  CA  ASN A  76      32.061  17.778   4.174  1.00 18.68           C  
ATOM    561  C   ASN A  76      30.663  17.189   4.205  1.00 16.92           C  
ATOM    562  O   ASN A  76      29.694  17.915   4.421  1.00 13.89           O  
ATOM    563  CB  ASN A  76      32.034  19.075   3.353  1.00 24.67           C  
ATOM    564  CG  ASN A  76      33.363  19.800   3.365  1.00 26.87           C  
ATOM    565  OD1 ASN A  76      33.976  19.981   4.418  1.00 26.95           O  
ATOM    566  ND2 ASN A  76      33.811  20.233   2.192  1.00 29.34           N  
ATOM    567  N   GLU A  77      30.542  15.881   4.000  1.00 15.59           N  
ATOM    568  CA  GLU A  77      29.213  15.273   4.015  1.00 14.24           C  
ATOM    569  C   GLU A  77      29.064  14.017   4.866  1.00 13.28           C  
ATOM    570  O   GLU A  77      30.026  13.297   5.115  1.00 12.12           O  
ATOM    571  CB  GLU A  77      28.757  14.983   2.586  1.00 15.87           C  
ATOM    572  CG  GLU A  77      28.451  16.245   1.785  1.00 19.40           C  
ATOM    573  CD  GLU A  77      27.930  15.948   0.390  1.00 21.33           C  
ATOM    574  OE1 GLU A  77      26.999  15.130   0.268  1.00 19.63           O  
ATOM    575  OE2 GLU A  77      28.444  16.538  -0.584  1.00 21.07           O  
ATOM    576  N   ALA A  78      27.839  13.768   5.316  1.00 17.11           N  
ATOM    577  CA  ALA A  78      27.548  12.601   6.133  1.00 17.92           C  
ATOM    578  C   ALA A  78      26.127  12.109   5.904  1.00 18.05           C  
ATOM    579  O   ALA A  78      25.228  12.894   5.595  1.00 17.55           O  
ATOM    580  CB  ALA A  78      27.744  12.935   7.604  1.00 15.23           C  
ATOM    581  N   ALA A  79      25.937  10.799   6.035  1.00 12.14           N  
ATOM    582  CA  ALA A  79      24.618  10.192   5.894  1.00 12.54           C  
ATOM    583  C   ALA A  79      24.544   9.095   6.952  1.00 12.36           C  
ATOM    584  O   ALA A  79      25.539   8.418   7.221  1.00  8.85           O  
ATOM    585  CB  ALA A  79      24.434   9.601   4.486  1.00  5.68           C  
ATOM    586  N   PHE A  80      23.375   8.928   7.561  1.00 13.66           N  
ATOM    587  CA  PHE A  80      23.213   7.906   8.588  1.00 14.41           C  
ATOM    588  C   PHE A  80      21.868   7.190   8.524  1.00 13.89           C  
ATOM    589  O   PHE A  80      20.877   7.756   8.072  1.00 12.98           O  
ATOM    590  CB  PHE A  80      23.403   8.509   9.993  1.00 11.70           C  
ATOM    591  CG  PHE A  80      22.644   9.794  10.227  1.00 12.55           C  
ATOM    592  CD1 PHE A  80      23.154  11.011   9.784  1.00 10.82           C  
ATOM    593  CD2 PHE A  80      21.438   9.790  10.931  1.00 12.13           C  
ATOM    594  CE1 PHE A  80      22.481  12.211  10.043  1.00  8.17           C  
ATOM    595  CE2 PHE A  80      20.748  10.984  11.196  1.00  9.74           C  
ATOM    596  CZ  PHE A  80      21.275  12.198  10.751  1.00  8.76           C  
ATOM    597  N   ALA A  81      21.868   5.933   8.971  1.00 14.57           N  
ATOM    598  CA  ALA A  81      20.677   5.094   9.012  1.00 13.78           C  
ATOM    599  C   ALA A  81      20.226   5.052  10.462  1.00 14.62           C  
ATOM    600  O   ALA A  81      21.035   4.855  11.372  1.00 14.17           O  
ATOM    601  CB  ALA A  81      21.003   3.688   8.532  1.00 21.35           C  
ATOM    602  N   PHE A  82      18.930   5.216  10.680  1.00 14.40           N  
ATOM    603  CA  PHE A  82      18.406   5.229  12.036  1.00 14.12           C  
ATOM    604  C   PHE A  82      16.905   5.006  12.044  1.00 13.46           C  
ATOM    605  O   PHE A  82      16.287   4.825  10.998  1.00 13.26           O  
ATOM    606  CB  PHE A  82      18.721   6.584  12.681  1.00 16.46           C  
ATOM    607  CG  PHE A  82      17.994   7.743  12.046  1.00 18.35           C  
ATOM    608  CD1 PHE A  82      16.928   8.360  12.700  1.00 15.20           C  
ATOM    609  CD2 PHE A  82      18.362   8.210  10.785  1.00 18.04           C  
ATOM    610  CE1 PHE A  82      16.243   9.425  12.109  1.00 17.83           C  
ATOM    611  CE2 PHE A  82      17.685   9.270  10.188  1.00 15.26           C  
ATOM    612  CZ  PHE A  82      16.625   9.881  10.852  1.00 18.59           C  
ATOM    613  N   ILE A  83      16.328   5.002  13.239  1.00 13.04           N  
ATOM    614  CA  ILE A  83      14.896   4.847  13.389  1.00 12.92           C  
ATOM    615  C   ILE A  83      14.379   5.892  14.363  1.00 14.19           C  
ATOM    616  O   ILE A  83      15.132   6.433  15.194  1.00 10.87           O  
ATOM    617  CB  ILE A  83      14.499   3.432  13.894  1.00 17.09           C  
ATOM    618  CG1 ILE A  83      15.075   3.172  15.288  1.00 14.21           C  
ATOM    619  CG2 ILE A  83      14.942   2.377  12.898  1.00 16.25           C  
ATOM    620  CD1 ILE A  83      16.557   3.083  15.358  1.00 23.47           C  
ATOM    621  N   VAL A  84      13.092   6.193  14.220  1.00 15.23           N  
ATOM    622  CA  VAL A  84      12.395   7.159  15.051  1.00 16.02           C  
ATOM    623  C   VAL A  84      11.110   6.479  15.512  1.00 17.13           C  
ATOM    624  O   VAL A  84      10.175   6.293  14.727  1.00 17.19           O  
ATOM    625  CB  VAL A  84      12.034   8.434  14.252  1.00 24.25           C  
ATOM    626  CG1 VAL A  84      11.251   9.394  15.129  1.00 26.51           C  
ATOM    627  CG2 VAL A  84      13.298   9.109  13.744  1.00 25.08           C  
ATOM    628  N   SER A  85      11.079   6.093  16.785  1.00 24.11           N  
ATOM    629  CA  SER A  85       9.919   5.416  17.362  1.00 23.53           C  
ATOM    630  C   SER A  85       9.142   6.363  18.262  1.00 25.40           C  
ATOM    631  O   SER A  85       9.727   7.135  19.032  1.00 23.27           O  
ATOM    632  CB  SER A  85      10.363   4.204  18.185  1.00 17.11           C  
ATOM    633  OG  SER A  85      11.287   3.411  17.468  1.00 16.59           O  
ATOM    634  N   PHE A  86       7.819   6.284  18.179  1.00 18.24           N  
ATOM    635  CA  PHE A  86       6.964   7.141  18.978  1.00 19.96           C  
ATOM    636  C   PHE A  86       5.569   6.532  19.069  1.00 21.98           C  
ATOM    637  O   PHE A  86       5.262   5.529  18.410  1.00 16.61           O  
ATOM    638  CB  PHE A  86       6.893   8.528  18.337  1.00 22.49           C  
ATOM    639  CG  PHE A  86       6.302   8.522  16.956  1.00 23.53           C  
ATOM    640  CD1 PHE A  86       4.923   8.621  16.773  1.00 22.09           C  
ATOM    641  CD2 PHE A  86       7.119   8.369  15.840  1.00 22.83           C  
ATOM    642  CE1 PHE A  86       4.366   8.563  15.500  1.00 25.10           C  
ATOM    643  CE2 PHE A  86       6.570   8.308  14.553  1.00 24.50           C  
ATOM    644  CZ  PHE A  86       5.191   8.404  14.383  1.00 24.34           C  
ATOM    645  N   GLU A  87       4.730   7.143  19.896  1.00 20.78           N  
ATOM    646  CA  GLU A  87       3.365   6.667  20.065  1.00 27.50           C  
ATOM    647  C   GLU A  87       2.366   7.817  19.997  1.00 31.10           C  
ATOM    648  O   GLU A  87       2.736   8.990  20.122  1.00 30.10           O  
ATOM    649  CB  GLU A  87       3.225   5.929  21.396  1.00 49.71           C  
ATOM    650  CG  GLU A  87       4.144   4.729  21.517  1.00 53.22           C  
ATOM    651  CD  GLU A  87       3.792   3.843  22.691  1.00 55.70           C  
ATOM    652  OE1 GLU A  87       4.517   2.850  22.918  1.00 57.49           O  
ATOM    653  OE2 GLU A  87       2.790   4.137  23.380  1.00 56.21           O  
ATOM    654  N   TYR A  88       1.100   7.469  19.787  1.00 47.91           N  
ATOM    655  CA  TYR A  88       0.028   8.453  19.693  1.00 52.90           C  
ATOM    656  C   TYR A  88      -1.298   7.718  19.505  1.00 54.66           C  
ATOM    657  O   TYR A  88      -1.382   6.769  18.723  1.00 54.62           O  
ATOM    658  CB  TYR A  88       0.281   9.390  18.505  1.00 65.29           C  
ATOM    659  CG  TYR A  88      -0.696  10.538  18.399  1.00 67.76           C  
ATOM    660  CD1 TYR A  88      -0.793  11.491  19.413  1.00 69.03           C  
ATOM    661  CD2 TYR A  88      -1.528  10.670  17.288  1.00 68.81           C  
ATOM    662  CE1 TYR A  88      -1.695  12.549  19.323  1.00 69.82           C  
ATOM    663  CE2 TYR A  88      -2.435  11.723  17.186  1.00 69.77           C  
ATOM    664  CZ  TYR A  88      -2.513  12.659  18.208  1.00 70.09           C  
ATOM    665  OH  TYR A  88      -3.408  13.699  18.118  1.00 70.33           O  
ATOM    666  N   GLN A  89      -2.324   8.156  20.228  1.00 65.10           N  
ATOM    667  CA  GLN A  89      -3.647   7.539  20.148  1.00 66.75           C  
ATOM    668  C   GLN A  89      -3.565   6.030  20.353  1.00 66.09           C  
ATOM    669  O   GLN A  89      -4.304   5.271  19.725  1.00 66.44           O  
ATOM    670  CB  GLN A  89      -4.294   7.830  18.788  1.00 72.49           C  
ATOM    671  CG  GLN A  89      -4.642   9.292  18.540  1.00 74.34           C  
ATOM    672  CD  GLN A  89      -5.308   9.514  17.189  1.00 75.01           C  
ATOM    673  OE1 GLN A  89      -5.678  10.636  16.843  1.00 74.83           O  
ATOM    674  NE2 GLN A  89      -5.461   8.440  16.420  1.00 75.30           N  
ATOM    675  N   GLY A  90      -2.667   5.604  21.234  1.00 72.13           N  
ATOM    676  CA  GLY A  90      -2.505   4.185  21.494  1.00 70.86           C  
ATOM    677  C   GLY A  90      -2.132   3.435  20.230  1.00 68.99           C  
ATOM    678  O   GLY A  90      -2.982   2.808  19.596  1.00 70.12           O  
ATOM    679  N   ARG A  91      -0.856   3.500  19.865  1.00 36.97           N  
ATOM    680  CA  ARG A  91      -0.360   2.838  18.666  1.00 34.65           C  
ATOM    681  C   ARG A  91       1.120   3.181  18.516  1.00 30.56           C  
ATOM    682  O   ARG A  91       1.476   4.348  18.374  1.00 29.95           O  
ATOM    683  CB  ARG A  91      -1.138   3.336  17.444  1.00 72.27           C  
ATOM    684  CG  ARG A  91      -1.462   2.274  16.405  1.00 76.98           C  
ATOM    685  CD  ARG A  91      -0.230   1.785  15.665  1.00 81.22           C  
ATOM    686  NE  ARG A  91      -0.587   0.925  14.537  1.00 85.69           N  
ATOM    687  CZ  ARG A  91      -1.316   1.316  13.494  1.00 88.04           C  
ATOM    688  NH1 ARG A  91      -1.776   2.560  13.423  1.00 89.10           N  
ATOM    689  NH2 ARG A  91      -1.588   0.462  12.515  1.00 88.54           N  
ATOM    690  N   LYS A  92       1.973   2.163  18.544  1.00 33.10           N  
ATOM    691  CA  LYS A  92       3.414   2.362  18.426  1.00 27.53           C  
ATOM    692  C   LYS A  92       3.861   2.388  16.964  1.00 24.67           C  
ATOM    693  O   LYS A  92       3.524   1.496  16.182  1.00 22.26           O  
ATOM    694  CB  LYS A  92       4.150   1.249  19.170  1.00 28.48           C  
ATOM    695  CG  LYS A  92       5.624   1.512  19.365  1.00 30.61           C  
ATOM    696  CD  LYS A  92       6.320   0.325  20.009  1.00 29.97           C  
ATOM    697  CE  LYS A  92       7.741   0.689  20.399  1.00 30.37           C  
ATOM    698  NZ  LYS A  92       8.491   1.257  19.245  1.00 29.83           N  
ATOM    699  N   THR A  93       4.631   3.405  16.598  1.00 23.26           N  
ATOM    700  CA  THR A  93       5.094   3.523  15.220  1.00 21.43           C  
ATOM    701  C   THR A  93       6.597   3.753  15.098  1.00 19.15           C  
ATOM    702  O   THR A  93       7.199   4.473  15.899  1.00 18.62           O  
ATOM    703  CB  THR A  93       4.351   4.666  14.485  1.00 24.08           C  
ATOM    704  OG1 THR A  93       2.984   4.289  14.275  1.00 26.36           O  
ATOM    705  CG2 THR A  93       5.004   4.958  13.136  1.00 25.14           C  
ATOM    706  N   VAL A  94       7.191   3.130  14.087  1.00 18.25           N  
ATOM    707  CA  VAL A  94       8.614   3.271  13.825  1.00 15.28           C  
ATOM    708  C   VAL A  94       8.884   3.710  12.387  1.00 15.78           C  
ATOM    709  O   VAL A  94       8.447   3.066  11.425  1.00 14.40           O  
ATOM    710  CB  VAL A  94       9.369   1.948  14.065  1.00 16.24           C  
ATOM    711  CG1 VAL A  94      10.854   2.134  13.764  1.00 16.38           C  
ATOM    712  CG2 VAL A  94       9.177   1.488  15.510  1.00 16.52           C  
ATOM    713  N   VAL A  95       9.589   4.821  12.238  1.00 19.01           N  
ATOM    714  CA  VAL A  95       9.958   5.295  10.915  1.00 19.63           C  
ATOM    715  C   VAL A  95      11.473   5.103  10.797  1.00 19.53           C  
ATOM    716  O   VAL A  95      12.222   5.472  11.705  1.00 19.84           O  
ATOM    717  CB  VAL A  95       9.616   6.791  10.716  1.00 14.15           C  
ATOM    718  CG1 VAL A  95       9.978   7.210   9.310  1.00 13.17           C  
ATOM    719  CG2 VAL A  95       8.130   7.031  10.972  1.00 14.02           C  
ATOM    720  N   ALA A  96      11.918   4.519   9.688  1.00 12.61           N  
ATOM    721  CA  ALA A  96      13.341   4.277   9.480  1.00 12.45           C  
ATOM    722  C   ALA A  96      13.833   5.006   8.237  1.00 11.36           C  
ATOM    723  O   ALA A  96      13.771   4.480   7.121  1.00 10.61           O  
ATOM    724  CB  ALA A  96      13.604   2.779   9.349  1.00 25.94           C  
ATOM    725  N   PRO A  97      14.323   6.239   8.414  1.00 11.26           N  
ATOM    726  CA  PRO A  97      14.806   6.981   7.253  1.00 12.58           C  
ATOM    727  C   PRO A  97      16.327   6.986   7.145  1.00 12.44           C  
ATOM    728  O   PRO A  97      17.023   6.310   7.904  1.00  9.99           O  
ATOM    729  CB  PRO A  97      14.246   8.369   7.502  1.00 20.14           C  
ATOM    730  CG  PRO A  97      14.410   8.517   8.979  1.00 18.18           C  
ATOM    731  CD  PRO A  97      14.055   7.146   9.545  1.00 18.52           C  
ATOM    732  N   ILE A  98      16.825   7.725   6.165  1.00 16.14           N  
ATOM    733  CA  ILE A  98      18.252   7.903   5.974  1.00 16.96           C  
ATOM    734  C   ILE A  98      18.424   9.405   5.823  1.00 17.02           C  
ATOM    735  O   ILE A  98      17.823  10.021   4.946  1.00 17.90           O  
ATOM    736  CB  ILE A  98      18.786   7.189   4.721  1.00 13.62           C  
ATOM    737  CG1 ILE A  98      18.784   5.673   4.954  1.00 14.11           C  
ATOM    738  CG2 ILE A  98      20.197   7.687   4.403  1.00 12.62           C  
ATOM    739  CD1 ILE A  98      19.582   4.887   3.933  1.00 14.12           C  
ATOM    740  N   ASP A  99      19.216   9.992   6.711  1.00 17.05           N  
ATOM    741  CA  ASP A  99      19.458  11.430   6.699  1.00 16.55           C  
ATOM    742  C   ASP A  99      20.783  11.779   6.046  1.00 17.35           C  
ATOM    743  O   ASP A  99      21.735  11.002   6.091  1.00 14.96           O  
ATOM    744  CB  ASP A  99      19.474  11.978   8.123  1.00 13.30           C  
ATOM    745  CG  ASP A  99      18.099  12.280   8.653  1.00 15.07           C  
ATOM    746  OD1 ASP A  99      17.105  11.853   8.029  1.00 12.14           O  
ATOM    747  OD2 ASP A  99      18.024  12.941   9.710  1.00 12.75           O  
ATOM    748  N   HIS A 100      20.826  12.958   5.443  1.00 13.69           N  
ATOM    749  CA  HIS A 100      22.034  13.447   4.807  1.00 14.52           C  
ATOM    750  C   HIS A 100      22.412  14.802   5.420  1.00 14.43           C  
ATOM    751  O   HIS A 100      21.569  15.691   5.558  1.00 13.93           O  
ATOM    752  CB  HIS A 100      21.822  13.596   3.301  1.00 17.03           C  
ATOM    753  CG  HIS A 100      23.002  14.177   2.593  1.00 19.53           C  
ATOM    754  ND1 HIS A 100      24.278  13.681   2.753  1.00 21.91           N  
ATOM    755  CD2 HIS A 100      23.111  15.228   1.747  1.00 22.83           C  
ATOM    756  CE1 HIS A 100      25.121  14.403   2.039  1.00 22.80           C  
ATOM    757  NE2 HIS A 100      24.440  15.350   1.420  1.00 23.18           N  
ATOM    758  N   PHE A 101      23.679  14.941   5.799  1.00 16.14           N  
ATOM    759  CA  PHE A 101      24.194  16.165   6.398  1.00 15.85           C  
ATOM    760  C   PHE A 101      25.274  16.769   5.513  1.00 16.09           C  
ATOM    761  O   PHE A 101      26.189  16.072   5.087  1.00 16.15           O  
ATOM    762  CB  PHE A 101      24.825  15.879   7.762  1.00 14.76           C  
ATOM    763  CG  PHE A 101      23.870  15.931   8.929  1.00 14.08           C  
ATOM    764  CD1 PHE A 101      22.492  15.990   8.745  1.00 13.93           C  
ATOM    765  CD2 PHE A 101      24.370  15.881  10.232  1.00 11.89           C  
ATOM    766  CE1 PHE A 101      21.631  15.996   9.831  1.00 16.00           C  
ATOM    767  CE2 PHE A 101      23.518  15.886  11.325  1.00 12.55           C  
ATOM    768  CZ  PHE A 101      22.143  15.943  11.127  1.00 15.70           C  
ATOM    769  N   ARG A 102      25.157  18.067   5.259  1.00 13.49           N  
ATOM    770  CA  ARG A 102      26.128  18.823   4.476  1.00 15.79           C  
ATOM    771  C   ARG A 102      26.663  19.907   5.432  1.00 15.54           C  
ATOM    772  O   ARG A 102      25.905  20.719   5.943  1.00 12.48           O  
ATOM    773  CB  ARG A 102      25.440  19.458   3.265  1.00 34.62           C  
ATOM    774  CG  ARG A 102      26.342  20.313   2.395  1.00 41.34           C  
ATOM    775  CD  ARG A 102      25.577  20.844   1.182  1.00 45.13           C  
ATOM    776  NE  ARG A 102      25.164  19.770   0.280  1.00 49.58           N  
ATOM    777  CZ  ARG A 102      26.010  18.984  -0.382  1.00 52.35           C  
ATOM    778  NH1 ARG A 102      27.318  19.149  -0.243  1.00 52.75           N  
ATOM    779  NH2 ARG A 102      25.550  18.034  -1.186  1.00 52.41           N  
ATOM    780  N   PHE A 103      27.970  19.917   5.678  1.00 17.41           N  
ATOM    781  CA  PHE A 103      28.548  20.884   6.606  1.00 18.48           C  
ATOM    782  C   PHE A 103      29.230  22.060   5.909  1.00 21.79           C  
ATOM    783  O   PHE A 103      29.645  21.944   4.753  1.00 20.60           O  
ATOM    784  CB  PHE A 103      29.582  20.190   7.503  1.00 20.05           C  
ATOM    785  CG  PHE A 103      29.028  19.061   8.341  1.00 17.92           C  
ATOM    786  CD1 PHE A 103      28.644  17.859   7.758  1.00 18.50           C  
ATOM    787  CD2 PHE A 103      28.932  19.191   9.728  1.00 18.39           C  
ATOM    788  CE1 PHE A 103      28.180  16.797   8.541  1.00 18.02           C  
ATOM    789  CE2 PHE A 103      28.466  18.135  10.525  1.00 17.47           C  
ATOM    790  CZ  PHE A 103      28.093  16.937   9.927  1.00 18.03           C  
ATOM    791  N   ASN A 104      29.342  23.187   6.618  1.00 25.88           N  
ATOM    792  CA  ASN A 104      30.021  24.367   6.087  1.00 27.66           C  
ATOM    793  C   ASN A 104      31.444  24.369   6.631  1.00 29.11           C  
ATOM    794  O   ASN A 104      31.828  23.459   7.364  1.00 30.99           O  
ATOM    795  CB  ASN A 104      29.289  25.676   6.471  1.00 22.54           C  
ATOM    796  CG  ASN A 104      29.273  25.958   7.982  1.00 21.86           C  
ATOM    797  OD1 ASN A 104      28.516  26.814   8.440  1.00 24.68           O  
ATOM    798  ND2 ASN A 104      30.106  25.264   8.746  1.00 18.95           N  
ATOM    799  N   GLY A 105      32.220  25.387   6.276  1.00 31.58           N  
ATOM    800  CA  GLY A 105      33.597  25.461   6.731  1.00 30.68           C  
ATOM    801  C   GLY A 105      33.790  25.506   8.235  1.00 30.97           C  
ATOM    802  O   GLY A 105      34.787  24.989   8.746  1.00 31.14           O  
ATOM    803  N   ALA A 106      32.845  26.119   8.944  1.00 32.23           N  
ATOM    804  CA  ALA A 106      32.924  26.241  10.398  1.00 32.21           C  
ATOM    805  C   ALA A 106      32.377  25.012  11.127  1.00 31.45           C  
ATOM    806  O   ALA A 106      31.981  25.096  12.290  1.00 31.47           O  
ATOM    807  CB  ALA A 106      32.186  27.502  10.859  1.00 16.50           C  
ATOM    808  N   GLY A 107      32.353  23.878  10.434  1.00 22.77           N  
ATOM    809  CA  GLY A 107      31.878  22.642  11.034  1.00 19.35           C  
ATOM    810  C   GLY A 107      30.392  22.536  11.314  1.00 18.83           C  
ATOM    811  O   GLY A 107      29.948  21.560  11.924  1.00 15.60           O  
ATOM    812  N   LYS A 108      29.612  23.521  10.880  1.00 20.47           N  
ATOM    813  CA  LYS A 108      28.168  23.486  11.115  1.00 20.44           C  
ATOM    814  C   LYS A 108      27.403  22.861   9.947  1.00 20.06           C  
ATOM    815  O   LYS A 108      27.882  22.839   8.814  1.00 18.73           O  
ATOM    816  CB  LYS A 108      27.642  24.897  11.365  1.00 29.62           C  
ATOM    817  CG  LYS A 108      28.289  25.614  12.543  1.00 30.59           C  
ATOM    818  CD  LYS A 108      27.956  27.097  12.506  1.00 35.23           C  
ATOM    819  CE  LYS A 108      28.463  27.743  11.212  1.00 35.16           C  
ATOM    820  NZ  LYS A 108      28.075  29.175  11.072  1.00 37.30           N  
ATOM    821  N   VAL A 109      26.210  22.346  10.234  1.00 18.95           N  
ATOM    822  CA  VAL A 109      25.390  21.738   9.198  1.00 16.39           C  
ATOM    823  C   VAL A 109      24.635  22.849   8.474  1.00 16.97           C  
ATOM    824  O   VAL A 109      23.903  23.616   9.099  1.00 14.59           O  
ATOM    825  CB  VAL A 109      24.356  20.758   9.786  1.00 12.32           C  
ATOM    826  CG1 VAL A 109      23.632  20.035   8.657  1.00 10.96           C  
ATOM    827  CG2 VAL A 109      25.035  19.757  10.707  1.00 14.59           C  
ATOM    828  N   VAL A 110      24.818  22.935   7.160  1.00 17.17           N  
ATOM    829  CA  VAL A 110      24.129  23.946   6.369  1.00 19.72           C  
ATOM    830  C   VAL A 110      22.938  23.332   5.643  1.00 19.99           C  
ATOM    831  O   VAL A 110      22.115  24.040   5.068  1.00 22.45           O  
ATOM    832  CB  VAL A 110      25.068  24.598   5.326  1.00 20.73           C  
ATOM    833  CG1 VAL A 110      26.169  25.368   6.037  1.00 24.10           C  
ATOM    834  CG2 VAL A 110      25.657  23.536   4.395  1.00 20.94           C  
ATOM    835  N   SER A 111      22.839  22.009   5.678  1.00 19.58           N  
ATOM    836  CA  SER A 111      21.735  21.332   5.004  1.00 18.37           C  
ATOM    837  C   SER A 111      21.491  19.917   5.514  1.00 15.74           C  
ATOM    838  O   SER A 111      22.429  19.138   5.687  1.00 14.26           O  
ATOM    839  CB  SER A 111      22.009  21.292   3.498  1.00 42.67           C  
ATOM    840  OG  SER A 111      20.988  20.597   2.809  1.00 49.43           O  
ATOM    841  N   MET A 112      20.228  19.598   5.779  1.00 19.15           N  
ATOM    842  CA  MET A 112      19.860  18.257   6.221  1.00 20.06           C  
ATOM    843  C   MET A 112      18.735  17.813   5.304  1.00 19.54           C  
ATOM    844  O   MET A 112      17.941  18.630   4.830  1.00 20.80           O  
ATOM    845  CB  MET A 112      19.398  18.244   7.695  1.00 21.81           C  
ATOM    846  CG  MET A 112      17.888  18.351   7.936  1.00 25.36           C  
ATOM    847  SD  MET A 112      16.965  16.792   7.725  1.00 27.38           S  
ATOM    848  CE  MET A 112      15.870  16.822   9.157  1.00 26.02           C  
ATOM    849  N   ARG A 113      18.690  16.520   5.027  1.00 17.47           N  
ATOM    850  CA  ARG A 113      17.656  15.953   4.177  1.00 16.40           C  
ATOM    851  C   ARG A 113      17.333  14.572   4.717  1.00 15.49           C  
ATOM    852  O   ARG A 113      18.230  13.748   4.913  1.00 11.37           O  
ATOM    853  CB  ARG A 113      18.133  15.852   2.726  1.00 21.93           C  
ATOM    854  CG  ARG A 113      18.540  17.188   2.122  1.00 24.21           C  
ATOM    855  CD  ARG A 113      18.680  17.095   0.616  1.00 24.34           C  
ATOM    856  NE  ARG A 113      17.384  17.096  -0.062  1.00 26.30           N  
ATOM    857  CZ  ARG A 113      17.086  16.308  -1.089  1.00 25.95           C  
ATOM    858  NH1 ARG A 113      17.992  15.454  -1.542  1.00 21.89           N  
ATOM    859  NH2 ARG A 113      15.893  16.382  -1.671  1.00 25.73           N  
ATOM    860  N   ALA A 114      16.053  14.337   4.974  1.00 16.30           N  
ATOM    861  CA  ALA A 114      15.601  13.063   5.504  1.00 17.76           C  
ATOM    862  C   ALA A 114      14.831  12.350   4.412  1.00 17.20           C  
ATOM    863  O   ALA A 114      13.780  12.823   3.975  1.00 18.67           O  
ATOM    864  CB  ALA A 114      14.709  13.294   6.727  1.00 21.29           C  
ATOM    865  N   LEU A 115      15.358  11.213   3.968  1.00 17.07           N  
ATOM    866  CA  LEU A 115      14.718  10.445   2.910  1.00 14.41           C  
ATOM    867  C   LEU A 115      14.002   9.227   3.485  1.00 16.05           C  
ATOM    868  O   LEU A 115      14.629   8.278   3.962  1.00 15.66           O  
ATOM    869  CB  LEU A 115      15.765  10.020   1.871  1.00 10.40           C  
ATOM    870  CG  LEU A 115      15.296   9.776   0.431  1.00 10.50           C  
ATOM    871  CD1 LEU A 115      16.495   9.662  -0.491  1.00 14.75           C  
ATOM    872  CD2 LEU A 115      14.442   8.514   0.365  1.00 10.96           C  
ATOM    873  N   TRP A 116      12.676   9.280   3.452  1.00 17.01           N  
ATOM    874  CA  TRP A 116      11.835   8.199   3.944  1.00 17.38           C  
ATOM    875  C   TRP A 116      10.479   8.311   3.271  1.00 15.41           C  
ATOM    876  O   TRP A 116      10.015   9.410   2.981  1.00 16.78           O  
ATOM    877  CB  TRP A 116      11.662   8.283   5.467  1.00 17.40           C  
ATOM    878  CG  TRP A 116      11.170   9.616   5.959  1.00 16.30           C  
ATOM    879  CD1 TRP A 116      11.891  10.768   6.065  1.00 15.90           C  
ATOM    880  CD2 TRP A 116       9.842   9.931   6.408  1.00 16.95           C  
ATOM    881  NE1 TRP A 116      11.099  11.780   6.551  1.00 16.78           N  
ATOM    882  CE2 TRP A 116       9.838  11.294   6.770  1.00 17.80           C  
ATOM    883  CE3 TRP A 116       8.656   9.192   6.536  1.00 19.38           C  
ATOM    884  CZ2 TRP A 116       8.690  11.939   7.256  1.00 20.35           C  
ATOM    885  CZ3 TRP A 116       7.513   9.836   7.020  1.00 18.48           C  
ATOM    886  CH2 TRP A 116       7.542  11.197   7.373  1.00 20.16           C  
ATOM    887  N   GLY A 117       9.861   7.166   3.004  1.00 14.43           N  
ATOM    888  CA  GLY A 117       8.557   7.145   2.364  1.00 14.04           C  
ATOM    889  C   GLY A 117       7.597   6.256   3.127  1.00 15.83           C  
ATOM    890  O   GLY A 117       7.882   5.848   4.256  1.00 13.00           O  
ATOM    891  N   GLU A 118       6.463   5.943   2.508  1.00 17.78           N  
ATOM    892  CA  GLU A 118       5.444   5.105   3.139  1.00 20.09           C  
ATOM    893  C   GLU A 118       5.924   3.695   3.473  1.00 17.20           C  
ATOM    894  O   GLU A 118       5.397   3.052   4.374  1.00 16.47           O  
ATOM    895  CB  GLU A 118       4.205   5.024   2.243  1.00 68.23           C  
ATOM    896  CG  GLU A 118       3.508   6.359   2.035  1.00 73.70           C  
ATOM    897  CD  GLU A 118       2.965   6.946   3.328  1.00 77.64           C  
ATOM    898  OE1 GLU A 118       2.525   8.115   3.310  1.00 80.56           O  
ATOM    899  OE2 GLU A 118       2.970   6.241   4.360  1.00 79.80           O  
ATOM    900  N   LYS A 119       6.922   3.215   2.743  1.00 15.20           N  
ATOM    901  CA  LYS A 119       7.450   1.889   2.995  1.00 15.82           C  
ATOM    902  C   LYS A 119       8.425   1.910   4.163  1.00 14.59           C  
ATOM    903  O   LYS A 119       8.877   0.867   4.625  1.00 11.54           O  
ATOM    904  CB  LYS A 119       8.152   1.349   1.749  1.00 32.39           C  
ATOM    905  CG  LYS A 119       7.282   0.468   0.874  1.00 35.63           C  
ATOM    906  CD  LYS A 119       6.029   1.184   0.411  1.00 40.27           C  
ATOM    907  CE  LYS A 119       5.171   0.280  -0.463  1.00 40.84           C  
ATOM    908  NZ  LYS A 119       3.932   0.974  -0.909  1.00 42.28           N  
ATOM    909  N   ASN A 120       8.750   3.104   4.641  1.00 17.35           N  
ATOM    910  CA  ASN A 120       9.685   3.235   5.744  1.00 17.93           C  
ATOM    911  C   ASN A 120       8.989   3.553   7.052  1.00 17.42           C  
ATOM    912  O   ASN A 120       9.632   3.889   8.040  1.00 17.37           O  
ATOM    913  CB  ASN A 120      10.726   4.298   5.403  1.00 19.60           C  
ATOM    914  CG  ASN A 120      11.535   3.928   4.170  1.00 20.02           C  
ATOM    915  OD1 ASN A 120      11.493   4.616   3.142  1.00 16.22           O  
ATOM    916  ND2 ASN A 120      12.261   2.822   4.262  1.00 13.77           N  
ATOM    917  N   ILE A 121       7.665   3.441   7.040  1.00 20.92           N  
ATOM    918  CA  ILE A 121       6.839   3.687   8.218  1.00 21.16           C  
ATOM    919  C   ILE A 121       6.240   2.336   8.605  1.00 23.67           C  
ATOM    920  O   ILE A 121       5.511   1.726   7.822  1.00 23.08           O  
ATOM    921  CB  ILE A 121       5.699   4.675   7.905  1.00 15.34           C  
ATOM    922  CG1 ILE A 121       6.277   5.948   7.277  1.00 15.75           C  
ATOM    923  CG2 ILE A 121       4.935   5.010   9.173  1.00 15.52           C  
ATOM    924  CD1 ILE A 121       5.228   6.981   6.851  1.00 14.95           C  
ATOM    925  N   HIS A 122       6.567   1.858   9.802  1.00 18.44           N  
ATOM    926  CA  HIS A 122       6.072   0.573  10.276  1.00 20.27           C  
ATOM    927  C   HIS A 122       5.198   0.771  11.516  1.00 21.50           C  
ATOM    928  O   HIS A 122       5.706   1.059  12.598  1.00 19.21           O  
ATOM    929  CB  HIS A 122       7.257  -0.343  10.603  1.00 26.51           C  
ATOM    930  CG  HIS A 122       8.363  -0.292   9.591  1.00 28.47           C  
ATOM    931  ND1 HIS A 122       9.199   0.797   9.454  1.00 28.63           N  
ATOM    932  CD2 HIS A 122       8.786  -1.206   8.685  1.00 28.32           C  
ATOM    933  CE1 HIS A 122      10.091   0.548   8.511  1.00 27.75           C  
ATOM    934  NE2 HIS A 122       9.863  -0.659   8.030  1.00 30.46           N  
ATOM    935  N   ALA A 123       3.885   0.619  11.348  1.00 30.21           N  
ATOM    936  CA  ALA A 123       2.933   0.806  12.444  1.00 34.63           C  
ATOM    937  C   ALA A 123       2.733  -0.458  13.271  1.00 37.78           C  
ATOM    938  O   ALA A 123       3.000  -1.564  12.806  1.00 38.87           O  
ATOM    939  CB  ALA A 123       1.580   1.294  11.894  1.00 12.30           C  
ATOM    940  N   GLY A 124       2.253  -0.283  14.498  1.00 92.80           N  
ATOM    941  CA  GLY A 124       2.032  -1.415  15.378  1.00 98.22           C  
ATOM    942  C   GLY A 124       3.306  -1.759  16.125  1.00101.25           C  
ATOM    943  O   GLY A 124       3.279  -2.079  17.316  1.00103.98           O  
ATOM    944  N   ALA A 125       4.427  -1.688  15.414  1.00 56.02           N  
ATOM    945  CA  ALA A 125       5.739  -1.980  15.977  1.00 55.22           C  
ATOM    946  C   ALA A 125       6.784  -1.890  14.869  1.00 54.59           C  
ATOM    947  O   ALA A 125       7.636  -0.983  14.940  1.00 53.50           O  
ATOM    948  CB  ALA A 125       5.748  -3.378  16.603  1.00 41.43           C  
ATOM    949  OXT ALA A 125       6.729  -2.722  13.938  1.00 34.58           O  
TER     950      ALA A 125                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
