
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  976),  selected  126 , name 2z7a_D
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 2z7a_D.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      M       2           -
LGA    -       -      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    -       -      D       7           -
LGA    -       -      N       8           -
LGA    -       -      T       9           -
LGA    -       -      L      10           -
LGA    S     7_D      K      11          1.908
LGA    P     8_D      V      12          1.580
LGA    A     9_D      A      13          1.879
LGA    L    10_D      H      14          2.118
LGA    I    11_D      Q      15          1.990
LGA    A    12_D      G      16          1.722
LGA    S    13_D      F      17          2.163
LGA    Q    14_D      E      18          2.648
LGA    S    15_D      F      19          2.377
LGA    S    16_D      F      20          1.870
LGA    W    17_D      T      21          1.729
LGA    R    18_D      Q      22          1.955
LGA    C    19_D      G      23          2.798
LGA    V    20_D      L      24          2.713
LGA    Q    21_D      A      25          1.570
LGA    A    22_D      T      26          2.238
LGA    H    23_D      G      27          1.750
LGA    D    24_D      E      28          1.412
LGA    R    25_D      W      29          2.848
LGA    E    26_D      Q      30          1.971
LGA    G    27_D      K      31          1.876
LGA    W    28_D      F      32          2.457
LGA    L    29_D      L      33          1.162
LGA    A    30_D      D      34          0.820
LGA    L    31_D      M      35          1.994
LGA    M    32_D      L      36          1.531
LGA    A    33_D      T      37          1.358
LGA    D    34_D      E      38          1.363
LGA    D    35_D      D      39          1.615
LGA    V    36_D      F      40          1.291
LGA    V    37_D      T      41          1.272
LGA    I    38_D      F      42          1.714
LGA    E    39_D      W      43          1.547
LGA    D    40_D      F      44          3.078
LGA    P    41_D      P      45          3.470
LGA    I    42_D      -       -           -
LGA    G    43_D      -       -           -
LGA    K    44_D      -       -           -
LGA    S    45_D      M      46          0.744
LGA    V    46_D      G      47          2.362
LGA    T    47_D      E      48          5.648
LGA    N    48_D      F      49          2.732
LGA    P    49_D      H      50          3.065
LGA    D    50_D      -       -           -
LGA    G    51_D      G      51          1.958
LGA    S    52_D      L      52          2.150
LGA    G    53_D      N      53          3.245
LGA    I    54_D      -       -           -
LGA    K    55_D      V      54          1.664
LGA    G    56_D      G      55          0.931
LGA    K    57_D      K      56          1.001
LGA    E    58_D      E      57          0.516
LGA    A    59_D      R      58          0.686
LGA    V    60_D      A      59          1.149
LGA    G    61_D      K      60          1.148
LGA    A    62_D      E      61          1.024
LGA    F    63_D      F      62          1.021
LGA    F    64_D      F      63          2.197
LGA    D    65_D      T      64          2.248
LGA    T    66_D      Y      65          1.562
LGA    H    67_D      V      66          1.694
LGA    I    68_D      S      67          1.351
LGA    A    69_D      E      68          3.531
LGA    A    70_D      S      69          3.066
LGA    N    71_D      F      70          1.548
LGA    -       -      H      71           -
LGA    -       -      T      72           -
LGA    R    72_D      G      73          1.900
LGA    L    73_D      I      74          0.924
LGA    T    74_D      Q      75          1.282
LGA    V    75_D      I      76          2.284
LGA    T    76_D      S      77          3.456
LGA    -       -      S      78           -
LGA    C    77_D      L      79          1.525
LGA    E    78_D      D      80          1.866
LGA    E    79_D      R      81          1.796
LGA    T    80_D      V      82          1.282
LGA    F    81_D      T      83          1.414
LGA    P    82_D      S      84          2.759
LGA    S    83_D      N      85          2.272
LGA    S    84_D      -       -           -
LGA    S    85_D      E      86          1.628
LGA    P    86_D      -       -           -
LGA    D    87_D      T      87          3.709
LGA    E    88_D      T      88          1.915
LGA    I    89_D      V      89          0.887
LGA    A    90_D      V      90          1.101
LGA    H    91_D      F      91          1.625
LGA    I    92_D      E      92          0.851
LGA    L    93_D      F      93          1.270
LGA    V    94_D      R      94          1.514
LGA    L    95_D      D      95          2.962
LGA    H    96_D      E      96          1.924
LGA    S    97_D      G      97          3.230
LGA    E    98_D      L      98          1.662
LGA    F    99_D      F      99          2.857
LGA    -       -      L     100           -
LGA    -       -      G     101           -
LGA    F   103_D      K     102          0.724
LGA    T   104_D      P     103          1.804
LGA    S   105_D      Y     104          1.768
LGA    E   106_D      K     105          1.912
LGA    V   107_D      N     106          1.909
LGA    R   108_D      R     107          0.682
LGA    G   109_D      V     108          2.753
LGA    V   110_D      A     109          2.326
LGA    F   111_D      V     110          1.783
LGA    T   112_D      S     111          1.008
LGA    Y   113_D      F     112          0.738
LGA    R   114_D      D     113          0.891
LGA    V   115_D      V     114          1.772
LGA    N   116_D      R     115          1.155
LGA    K   117_D      G     116          1.349
LGA    A   118_D      D     117          2.898
LGA    G   119_D      -       -           -
LGA    L   120_D      K     118          1.387
LGA    I   121_D      I     119          1.524
LGA    T   122_D      C     120          1.086
LGA    N   123_D      S     121          1.028
LGA    M   124_D      Y     122          1.169
LGA    R   125_D      R     123          0.921
LGA    G   126_D      E     124          1.671
LGA    Y   127_D      Y     125          2.132
LGA    W   128_D      F     126          1.732
LGA    N   129_D      G     127           #
LGA    L   130_D      -       -           -
LGA    D   131_D      -       -           -
LGA    M   132_D      S     128          2.799
LGA    M   133_D      D     129          1.555
LGA    T   134_D      G     130          3.044
LGA    F   135_D      K     131          2.791
LGA    -       -      S     132           -
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  133    5.0    115    2.03    13.91     71.664     5.398

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.010945 * X  +  -0.997715 * Y  +   0.066677 * Z  +  35.104057
  Y_new =  -0.975529 * X  +   0.025298 * Y  +   0.218413 * Z  +  -0.864989
  Z_new =  -0.219600 * X  +  -0.062655 * Y  +  -0.973576 * Z  +  42.400105 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.077326    0.064267  [ DEG:  -176.3178      3.6822 ]
  Theta =   0.221405    2.920188  [ DEG:    12.6856    167.3144 ]
  Phi   =  -1.582015    1.559577  [ DEG:   -90.6428     89.3572 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2z7a_D                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2z7a_D.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  133   5.0  115   2.03   13.91  71.664
REMARK  ---------------------------------------------------------- 
MOLECULE 2z7a_D
HEADER    ISOMERASE                               17-AUG-07   2Z7A              
TITLE     X-RAY CRYSTAL STRUCTURE OF RV0760C FROM MYCOBACTERIUM                 
TITLE    2 TUBERCULOSIS AT 2.10 ANGSTROM RESOLUTION                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE STEROID ISOMERASE;                                
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS H37RV;               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: H37RV;                                                       
SOURCE   5 ATCC: 25618;                                                         
SOURCE   6 GENE: RV0760C, MT0785;                                               
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_VECTOR: PDEST15-RV0760C;                           
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PGST-0760C                                
KEYWDS    ALPHA+BETA CONICAL BARREL, STRUCTURAL GENOMICS, TB                    
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, TBSGC, ISOMERASE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.M.CHERNEY,C.R.GAREN,M.N.G.JAMES,TB STRUCTURAL GENOMICS              
AUTHOR   2 CONSORTIUM (TBSGC)                                                   
REVDAT   1   11-SEP-07 2Z7A    0                                                
JRNL        AUTH   M.M.CHERNEY,C.R.GAREN,M.N.G.JAMES                            
JRNL        TITL   CRYSTAL STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS              
JRNL        TITL 2 RV0760C AT 1.50 A RESOLUTION, A STRUCTURAL HOMOLOG           
JRNL        TITL 3 OF KETOSTEROID ISOMERASE                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2Z7A A    1   139  UNP    P71817   P71817_MYCTU     1    139             
DBREF  2Z7A B    1   139  UNP    P71817   P71817_MYCTU     1    139             
DBREF  2Z7A C    1   139  UNP    P71817   P71817_MYCTU     1    139             
DBREF  2Z7A D    1   139  UNP    P71817   P71817_MYCTU     1    139             
SEQRES   1 A  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 A  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 A  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 A  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 A  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 A  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 A  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 A  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 A  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 A  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 A  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
SEQRES   1 B  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 B  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 B  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 B  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 B  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 B  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 B  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 B  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 B  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 B  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 B  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
SEQRES   1 C  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 C  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 C  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 C  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 C  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 C  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 C  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 C  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 C  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 C  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 C  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
SEQRES   1 D  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 D  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 D  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 D  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 D  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 D  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 D  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 D  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 D  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 D  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 D  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
HET    ACT  B 140       4                                                       
HET    ACT  B 141       4                                                       
HET    ACT  A 140       4                                                       
HET    ACT  C 140       4                                                       
HETNAM     ACT ACETATE ION                                                      
FORMUL   5  ACT    4(C2 H3 O2 1-)                                               
FORMUL   9  HOH   *332(H2 O)                                                    
CRYST1   38.968   83.239  164.691  90.00  90.00  90.00 P 21 21 21   16          
ATOM   3048  N   SER D   7      34.997  12.603  12.648  1.00 51.83           N  
ATOM   3049  CA  SER D   7      34.673  13.735  11.727  1.00 51.82           C  
ATOM   3050  C   SER D   7      33.649  14.706  12.328  1.00 50.54           C  
ATOM   3051  O   SER D   7      32.767  14.282  13.118  1.00 50.45           O  
ATOM   3052  CB  SER D   7      34.189  13.205  10.346  1.00 52.84           C  
ATOM   3053  OG  SER D   7      32.808  12.803  10.347  1.00 54.01           O  
ATOM   3054  N   PRO D   8      33.734  16.002  11.946  1.00 49.39           N  
ATOM   3055  CA  PRO D   8      32.739  17.028  12.401  1.00 48.74           C  
ATOM   3056  C   PRO D   8      31.277  16.633  12.048  1.00 49.67           C  
ATOM   3057  O   PRO D   8      30.368  16.745  12.875  1.00 47.97           O  
ATOM   3058  CB  PRO D   8      33.167  18.308  11.666  1.00 47.18           C  
ATOM   3059  CG  PRO D   8      34.545  18.053  11.141  1.00 46.97           C  
ATOM   3060  CD  PRO D   8      34.764  16.572  11.049  1.00 49.39           C  
ATOM   3061  N   ALA D   9      31.085  16.140  10.823  1.00 50.95           N  
ATOM   3062  CA  ALA D   9      29.781  15.701  10.357  1.00 51.49           C  
ATOM   3063  C   ALA D   9      29.266  14.525  11.194  1.00 51.51           C  
ATOM   3064  O   ALA D   9      28.073  14.478  11.495  1.00 52.30           O  
ATOM   3065  CB  ALA D   9      29.826  15.353   8.866  1.00 50.84           C  
ATOM   3066  N   LEU D  10      30.151  13.605  11.587  1.00 51.59           N  
ATOM   3067  CA  LEU D  10      29.765  12.459  12.460  1.00 51.29           C  
ATOM   3068  C   LEU D  10      29.380  12.911  13.858  1.00 50.76           C  
ATOM   3069  O   LEU D  10      28.350  12.467  14.375  1.00 50.09           O  
ATOM   3070  CB  LEU D  10      30.860  11.387  12.558  1.00 50.99           C  
ATOM   3071  CG  LEU D  10      30.508  10.113  13.357  1.00 51.97           C  
ATOM   3072  CD1 LEU D  10      29.225   9.438  12.857  1.00 47.83           C  
ATOM   3073  CD2 LEU D  10      31.655   9.084  13.392  1.00 51.33           C  
ATOM   3074  N   ILE D  11      30.218  13.767  14.455  1.00 50.57           N  
ATOM   3075  CA  ILE D  11      29.905  14.446  15.718  1.00 51.35           C  
ATOM   3076  C   ILE D  11      28.507  15.058  15.595  1.00 51.58           C  
ATOM   3077  O   ILE D  11      27.575  14.606  16.265  1.00 53.18           O  
ATOM   3078  CB  ILE D  11      30.953  15.566  16.129  1.00 50.98           C  
ATOM   3079  CG1 ILE D  11      32.382  15.027  16.432  1.00 53.13           C  
ATOM   3080  CG2 ILE D  11      30.411  16.441  17.261  1.00 49.61           C  
ATOM   3081  CD1 ILE D  11      32.503  13.850  17.440  1.00 52.39           C  
ATOM   3082  N   ALA D  12      28.365  16.068  14.736  1.00 51.95           N  
ATOM   3083  CA  ALA D  12      27.105  16.805  14.587  1.00 51.62           C  
ATOM   3084  C   ALA D  12      25.854  15.923  14.368  1.00 51.44           C  
ATOM   3085  O   ALA D  12      24.797  16.230  14.918  1.00 50.68           O  
ATOM   3086  CB  ALA D  12      27.219  17.858  13.491  1.00 51.81           C  
ATOM   3087  N   SER D  13      25.963  14.842  13.584  1.00 51.19           N  
ATOM   3088  CA  SER D  13      24.785  13.991  13.377  1.00 51.45           C  
ATOM   3089  C   SER D  13      24.364  13.345  14.677  1.00 51.74           C  
ATOM   3090  O   SER D  13      23.250  13.588  15.145  1.00 53.15           O  
ATOM   3091  CB  SER D  13      24.903  12.979  12.226  1.00 51.18           C  
ATOM   3092  OG  SER D  13      26.231  12.666  11.888  1.00 52.59           O  
ATOM   3093  N   GLN D  14      25.275  12.568  15.267  1.00 52.49           N  
ATOM   3094  CA  GLN D  14      25.134  11.923  16.594  1.00 51.91           C  
ATOM   3095  C   GLN D  14      24.636  12.829  17.721  1.00 51.86           C  
ATOM   3096  O   GLN D  14      23.859  12.393  18.559  1.00 51.34           O  
ATOM   3097  CB  GLN D  14      26.471  11.286  17.005  1.00 52.89           C  
ATOM   3098  CG  GLN D  14      26.991  10.262  16.004  1.00 52.54           C  
ATOM   3099  CD  GLN D  14      28.151   9.455  16.541  1.00 55.94           C  
ATOM   3100  OE1 GLN D  14      29.194   9.999  16.899  1.00 52.80           O  
ATOM   3101  NE2 GLN D  14      27.972   8.141  16.595  1.00 59.43           N  
ATOM   3102  N   SER D  15      25.092  14.085  17.731  1.00 52.88           N  
ATOM   3103  CA  SER D  15      24.659  15.081  18.718  1.00 53.26           C  
ATOM   3104  C   SER D  15      23.215  15.476  18.505  1.00 54.09           C  
ATOM   3105  O   SER D  15      22.418  15.508  19.454  1.00 54.32           O  
ATOM   3106  CB  SER D  15      25.548  16.315  18.657  1.00 53.22           C  
ATOM   3107  OG  SER D  15      26.862  16.022  19.101  1.00 55.93           O  
ATOM   3108  N   SER D  16      22.897  15.787  17.246  1.00 54.25           N  
ATOM   3109  CA  SER D  16      21.547  16.033  16.792  1.00 53.63           C  
ATOM   3110  C   SER D  16      20.561  14.968  17.301  1.00 53.87           C  
ATOM   3111  O   SER D  16      19.535  15.318  17.885  1.00 53.65           O  
ATOM   3112  CB  SER D  16      21.540  16.174  15.253  1.00 53.22           C  
ATOM   3113  OG  SER D  16      20.260  15.930  14.718  1.00 51.70           O  
ATOM   3114  N   TRP D  17      20.886  13.688  17.110  1.00 55.05           N  
ATOM   3115  CA  TRP D  17      20.063  12.566  17.615  1.00 57.48           C  
ATOM   3116  C   TRP D  17      19.859  12.616  19.134  1.00 58.92           C  
ATOM   3117  O   TRP D  17      18.772  12.286  19.654  1.00 58.93           O  
ATOM   3118  CB  TRP D  17      20.671  11.185  17.254  1.00 57.96           C  
ATOM   3119  CG  TRP D  17      21.164  11.018  15.822  1.00 59.54           C  
ATOM   3120  CD1 TRP D  17      20.708  11.673  14.702  1.00 59.25           C  
ATOM   3121  CD2 TRP D  17      22.185  10.115  15.368  1.00 61.28           C  
ATOM   3122  NE1 TRP D  17      21.395  11.246  13.592  1.00 61.18           N  
ATOM   3123  CE2 TRP D  17      22.308  10.293  13.967  1.00 62.47           C  
ATOM   3124  CE3 TRP D  17      23.013   9.177  16.008  1.00 62.29           C  
ATOM   3125  CZ2 TRP D  17      23.230   9.564  13.190  1.00 59.87           C  
ATOM   3126  CZ3 TRP D  17      23.935   8.451  15.235  1.00 61.43           C  
ATOM   3127  CH2 TRP D  17      24.033   8.651  13.841  1.00 60.73           C  
ATOM   3128  N   ARG D  18      20.922  13.016  19.830  1.00 58.94           N  
ATOM   3129  CA  ARG D  18      20.932  13.134  21.280  1.00 59.21           C  
ATOM   3130  C   ARG D  18      20.027  14.290  21.754  1.00 58.71           C  
ATOM   3131  O   ARG D  18      19.137  14.052  22.576  1.00 57.86           O  
ATOM   3132  CB  ARG D  18      22.378  13.299  21.748  1.00 59.25           C  
ATOM   3133  CG  ARG D  18      22.719  12.786  23.151  1.00 61.53           C  
ATOM   3134  CD  ARG D  18      24.258  12.750  23.368  1.00 59.56           C  
ATOM   3135  NE  ARG D  18      25.034  13.726  22.576  1.00 62.62           N  
ATOM   3136  CZ  ARG D  18      25.131  15.035  22.846  1.00 65.77           C  
ATOM   3137  NH1 ARG D  18      24.488  15.569  23.888  1.00 66.34           N  
ATOM   3138  NH2 ARG D  18      25.865  15.826  22.064  1.00 62.20           N  
ATOM   3139  N   CYS D  19      20.216  15.510  21.232  1.00 57.96           N  
ATOM   3140  CA  CYS D  19      19.344  16.634  21.616  1.00 58.39           C  
ATOM   3141  C   CYS D  19      17.901  16.427  21.175  1.00 59.56           C  
ATOM   3142  O   CYS D  19      16.964  16.949  21.800  1.00 59.18           O  
ATOM   3143  CB  CYS D  19      19.832  17.943  21.050  1.00 58.43           C  
ATOM   3144  SG  CYS D  19      21.506  18.319  21.435  1.00 60.65           S  
ATOM   3145  N   VAL D  20      17.727  15.644  20.108  1.00 60.30           N  
ATOM   3146  CA  VAL D  20      16.398  15.219  19.670  1.00 60.39           C  
ATOM   3147  C   VAL D  20      15.695  14.243  20.650  1.00 61.01           C  
ATOM   3148  O   VAL D  20      14.561  14.495  21.054  1.00 61.46           O  
ATOM   3149  CB  VAL D  20      16.412  14.744  18.187  1.00 59.20           C  
ATOM   3150  CG1 VAL D  20      15.328  13.705  17.902  1.00 59.13           C  
ATOM   3151  CG2 VAL D  20      16.259  15.945  17.278  1.00 59.00           C  
ATOM   3152  N   GLN D  21      16.347  13.152  21.040  1.00 61.80           N  
ATOM   3153  CA  GLN D  21      15.732  12.222  22.002  1.00 63.41           C  
ATOM   3154  C   GLN D  21      15.564  12.834  23.411  1.00 64.04           C  
ATOM   3155  O   GLN D  21      14.616  12.513  24.147  1.00 64.02           O  
ATOM   3156  CB  GLN D  21      16.563  10.948  22.118  1.00 63.19           C  
ATOM   3157  CG  GLN D  21      16.599  10.101  20.878  1.00 64.04           C  
ATOM   3158  CD  GLN D  21      17.632   9.004  20.968  1.00 66.39           C  
ATOM   3159  OE1 GLN D  21      17.331   7.833  20.719  1.00 70.13           O  
ATOM   3160  NE2 GLN D  21      18.856   9.371  21.333  1.00 63.44           N  
ATOM   3161  N   ALA D  22      16.510  13.699  23.767  1.00 64.99           N  
ATOM   3162  CA  ALA D  22      16.601  14.308  25.087  1.00 65.43           C  
ATOM   3163  C   ALA D  22      15.861  15.637  25.151  1.00 66.11           C  
ATOM   3164  O   ALA D  22      15.883  16.317  26.186  1.00 66.37           O  
ATOM   3165  CB  ALA D  22      18.070  14.475  25.494  1.00 65.25           C  
ATOM   3166  N   HIS D  23      15.201  15.997  24.050  1.00 66.43           N  
ATOM   3167  CA  HIS D  23      14.268  17.132  24.012  1.00 66.73           C  
ATOM   3168  C   HIS D  23      14.910  18.478  24.366  1.00 66.69           C  
ATOM   3169  O   HIS D  23      14.225  19.392  24.855  1.00 66.58           O  
ATOM   3170  CB  HIS D  23      13.059  16.881  24.927  1.00 67.48           C  
ATOM   3171  CG  HIS D  23      12.108  15.843  24.414  1.00 69.13           C  
ATOM   3172  ND1 HIS D  23      12.433  14.506  24.340  1.00 71.96           N  
ATOM   3173  CD2 HIS D  23      10.833  15.946  23.972  1.00 70.24           C  
ATOM   3174  CE1 HIS D  23      11.404  13.831  23.860  1.00 72.61           C  
ATOM   3175  NE2 HIS D  23      10.420  14.684  23.630  1.00 72.01           N  
ATOM   3176  N   ASP D  24      16.220  18.588  24.118  1.00 65.88           N  
ATOM   3177  CA  ASP D  24      16.974  19.823  24.342  1.00 64.95           C  
ATOM   3178  C   ASP D  24      16.790  20.781  23.141  1.00 64.57           C  
ATOM   3179  O   ASP D  24      17.586  20.782  22.195  1.00 64.43           O  
ATOM   3180  CB  ASP D  24      18.466  19.509  24.640  1.00 64.51           C  
ATOM   3181  CG  ASP D  24      19.285  20.750  25.022  1.00 64.73           C  
ATOM   3182  OD1 ASP D  24      18.700  21.839  25.230  1.00 64.32           O  
ATOM   3183  OD2 ASP D  24      20.531  20.636  25.123  1.00 66.70           O  
ATOM   3184  N   ARG D  25      15.730  21.591  23.204  1.00 64.36           N  
ATOM   3185  CA  ARG D  25      15.413  22.581  22.168  1.00 64.09           C  
ATOM   3186  C   ARG D  25      16.579  23.505  21.869  1.00 64.17           C  
ATOM   3187  O   ARG D  25      16.922  23.724  20.703  1.00 64.43           O  
ATOM   3188  CB  ARG D  25      14.199  23.416  22.573  1.00 63.90           C  
ATOM   3189  CG  ARG D  25      13.639  24.280  21.458  1.00 62.22           C  
ATOM   3190  CD  ARG D  25      12.242  24.816  21.816  1.00 62.61           C  
ATOM   3191  NE  ARG D  25      11.631  25.570  20.724  1.00 59.61           N  
ATOM   3192  CZ  ARG D  25      12.175  26.643  20.152  1.00 62.45           C  
ATOM   3193  NH1 ARG D  25      13.364  27.099  20.546  1.00 63.45           N  
ATOM   3194  NH2 ARG D  25      11.530  27.260  19.168  1.00 64.37           N  
ATOM   3195  N   GLU D  26      17.175  24.028  22.935  1.00 64.31           N  
ATOM   3196  CA  GLU D  26      18.276  24.991  22.870  1.00 64.77           C  
ATOM   3197  C   GLU D  26      19.557  24.330  22.333  1.00 62.70           C  
ATOM   3198  O   GLU D  26      20.353  24.962  21.628  1.00 62.24           O  
ATOM   3199  CB  GLU D  26      18.530  25.590  24.269  1.00 64.76           C  
ATOM   3200  CG  GLU D  26      17.476  25.197  25.361  1.00 68.33           C  
ATOM   3201  CD  GLU D  26      17.954  25.475  26.808  1.00 68.31           C  
ATOM   3202  OE1 GLU D  26      18.607  26.533  27.024  1.00 69.94           O  
ATOM   3203  OE2 GLU D  26      17.674  24.640  27.713  1.00 70.08           O  
ATOM   3204  N   GLY D  27      19.744  23.058  22.678  1.00 61.78           N  
ATOM   3205  CA  GLY D  27      20.942  22.304  22.297  1.00 60.31           C  
ATOM   3206  C   GLY D  27      20.921  21.907  20.829  1.00 59.59           C  
ATOM   3207  O   GLY D  27      21.912  22.096  20.104  1.00 59.17           O  
ATOM   3208  N   TRP D  28      19.783  21.369  20.400  1.00 58.03           N  
ATOM   3209  CA  TRP D  28      19.532  21.061  19.002  1.00 58.24           C  
ATOM   3210  C   TRP D  28      19.866  22.210  18.037  1.00 58.83           C  
ATOM   3211  O   TRP D  28      20.535  21.985  17.052  1.00 59.13           O  
ATOM   3212  CB  TRP D  28      18.082  20.621  18.825  1.00 56.66           C  
ATOM   3213  CG  TRP D  28      17.849  19.860  17.556  1.00 56.88           C  
ATOM   3214  CD1 TRP D  28      18.591  18.810  17.075  1.00 54.39           C  
ATOM   3215  CD2 TRP D  28      16.782  20.064  16.614  1.00 55.80           C  
ATOM   3216  NE1 TRP D  28      18.061  18.362  15.890  1.00 53.92           N  
ATOM   3217  CE2 TRP D  28      16.949  19.109  15.584  1.00 55.83           C  
ATOM   3218  CE3 TRP D  28      15.713  20.974  16.532  1.00 54.92           C  
ATOM   3219  CZ2 TRP D  28      16.075  19.031  14.491  1.00 55.63           C  
ATOM   3220  CZ3 TRP D  28      14.842  20.890  15.454  1.00 54.35           C  
ATOM   3221  CH2 TRP D  28      15.031  19.928  14.446  1.00 54.95           C  
ATOM   3222  N   LEU D  29      19.428  23.432  18.347  1.00 60.56           N  
ATOM   3223  CA  LEU D  29      19.671  24.620  17.503  1.00 61.63           C  
ATOM   3224  C   LEU D  29      21.114  25.127  17.517  1.00 62.49           C  
ATOM   3225  O   LEU D  29      21.587  25.679  16.512  1.00 62.33           O  
ATOM   3226  CB  LEU D  29      18.740  25.782  17.889  1.00 61.38           C  
ATOM   3227  CG  LEU D  29      17.222  25.571  17.894  1.00 63.44           C  
ATOM   3228  CD1 LEU D  29      16.490  26.891  18.160  1.00 65.58           C  
ATOM   3229  CD2 LEU D  29      16.736  24.948  16.575  1.00 65.48           C  
ATOM   3230  N   ALA D  30      21.802  24.973  18.650  1.00 62.82           N  
ATOM   3231  CA  ALA D  30      23.213  25.403  18.749  1.00 62.66           C  
ATOM   3232  C   ALA D  30      24.031  24.623  17.745  1.00 62.49           C  
ATOM   3233  O   ALA D  30      25.052  25.121  17.248  1.00 63.06           O  
ATOM   3234  CB  ALA D  30      23.769  25.208  20.159  1.00 61.94           C  
ATOM   3235  N   LEU D  31      23.567  23.399  17.459  1.00 61.68           N  
ATOM   3236  CA  LEU D  31      24.115  22.563  16.389  1.00 60.57           C  
ATOM   3237  C   LEU D  31      23.922  23.146  14.978  1.00 59.85           C  
ATOM   3238  O   LEU D  31      24.719  22.851  14.078  1.00 60.16           O  
ATOM   3239  CB  LEU D  31      23.516  21.161  16.453  1.00 60.37           C  
ATOM   3240  CG  LEU D  31      23.837  20.303  17.683  1.00 62.08           C  
ATOM   3241  CD1 LEU D  31      22.816  19.189  17.829  1.00 61.03           C  
ATOM   3242  CD2 LEU D  31      25.273  19.728  17.668  1.00 60.38           C  
ATOM   3243  N   MET D  32      22.898  23.988  14.807  1.00 58.73           N  
ATOM   3244  CA  MET D  32      22.456  24.449  13.499  1.00 58.39           C  
ATOM   3245  C   MET D  32      23.205  25.694  13.058  1.00 59.01           C  
ATOM   3246  O   MET D  32      23.376  26.640  13.848  1.00 58.20           O  
ATOM   3247  CB  MET D  32      20.944  24.762  13.487  1.00 57.91           C  
ATOM   3248  CG  MET D  32      19.978  23.585  13.750  1.00 58.93           C  
ATOM   3249  SD  MET D  32      20.449  22.008  12.985  1.00 61.84           S  
ATOM   3250  CE  MET D  32      19.400  20.854  13.880  1.00 55.66           C  
ATOM   3251  N   ALA D  33      23.634  25.694  11.787  1.00 58.78           N  
ATOM   3252  CA  ALA D  33      24.059  26.919  11.090  1.00 57.20           C  
ATOM   3253  C   ALA D  33      22.896  27.910  11.046  1.00 56.71           C  
ATOM   3254  O   ALA D  33      21.749  27.555  11.320  1.00 55.34           O  
ATOM   3255  CB  ALA D  33      24.574  26.599   9.681  1.00 56.71           C  
ATOM   3256  N   ASP D  34      23.182  29.169  10.741  1.00 58.22           N  
ATOM   3257  CA  ASP D  34      22.115  30.167  10.781  1.00 59.64           C  
ATOM   3258  C   ASP D  34      21.164  30.078   9.562  1.00 60.31           C  
ATOM   3259  O   ASP D  34      19.981  30.431   9.670  1.00 61.17           O  
ATOM   3260  CB  ASP D  34      22.668  31.587  11.064  1.00 60.81           C  
ATOM   3261  CG  ASP D  34      22.709  31.925  12.599  1.00 61.65           C  
ATOM   3262  OD1 ASP D  34      21.644  32.317  13.158  1.00 59.19           O  
ATOM   3263  OD2 ASP D  34      23.795  31.789  13.228  1.00 57.27           O  
ATOM   3264  N   ASP D  35      21.673  29.574   8.431  1.00 59.77           N  
ATOM   3265  CA  ASP D  35      20.830  29.250   7.259  1.00 59.66           C  
ATOM   3266  C   ASP D  35      20.667  27.715   7.016  1.00 57.49           C  
ATOM   3267  O   ASP D  35      20.840  27.215   5.892  1.00 58.36           O  
ATOM   3268  CB  ASP D  35      21.331  29.989   5.997  1.00 59.77           C  
ATOM   3269  CG  ASP D  35      22.740  29.577   5.578  1.00 63.41           C  
ATOM   3270  OD1 ASP D  35      23.472  29.002   6.409  1.00 64.14           O  
ATOM   3271  OD2 ASP D  35      23.108  29.815   4.398  1.00 69.06           O  
ATOM   3272  N   VAL D  36      20.358  26.977   8.085  1.00 53.57           N  
ATOM   3273  CA  VAL D  36      20.110  25.533   8.007  1.00 48.67           C  
ATOM   3274  C   VAL D  36      18.862  25.250   7.167  1.00 46.79           C  
ATOM   3275  O   VAL D  36      17.865  25.985   7.234  1.00 45.39           O  
ATOM   3276  CB  VAL D  36      19.926  24.897   9.416  1.00 47.78           C  
ATOM   3277  CG1 VAL D  36      18.670  25.425  10.068  1.00 47.36           C  
ATOM   3278  CG2 VAL D  36      19.885  23.354   9.332  1.00 44.27           C  
ATOM   3279  N   VAL D  37      18.929  24.208   6.341  1.00 44.69           N  
ATOM   3280  CA  VAL D  37      17.711  23.713   5.689  1.00 44.04           C  
ATOM   3281  C   VAL D  37      17.487  22.268   6.139  1.00 42.94           C  
ATOM   3282  O   VAL D  37      18.330  21.392   5.918  1.00 43.93           O  
ATOM   3283  CB  VAL D  37      17.706  23.891   4.103  1.00 43.50           C  
ATOM   3284  CG1 VAL D  37      16.388  23.399   3.507  1.00 43.24           C  
ATOM   3285  CG2 VAL D  37      17.930  25.349   3.707  1.00 42.96           C  
ATOM   3286  N   ILE D  38      16.358  22.018   6.779  1.00 42.20           N  
ATOM   3287  CA  ILE D  38      15.999  20.636   7.068  1.00 41.66           C  
ATOM   3288  C   ILE D  38      14.948  20.121   6.085  1.00 41.43           C  
ATOM   3289  O   ILE D  38      13.869  20.708   5.916  1.00 41.18           O  
ATOM   3290  CB  ILE D  38      15.614  20.441   8.575  1.00 42.36           C  
ATOM   3291  CG1 ILE D  38      16.867  20.636   9.436  0.50 42.22           C  
ATOM   3292  CG2 ILE D  38      14.964  19.048   8.813  1.00 37.77           C  
ATOM   3293  CD1 ILE D  38      16.615  20.984  10.869  1.00 47.58           C  
ATOM   3294  N   GLU D  39      15.273  19.015   5.428  1.00 40.87           N  
ATOM   3295  CA  GLU D  39      14.320  18.367   4.538  1.00 40.10           C  
ATOM   3296  C   GLU D  39      14.183  16.961   5.000  1.00 40.05           C  
ATOM   3297  O   GLU D  39      14.875  16.068   4.495  1.00 39.13           O  
ATOM   3298  CB  GLU D  39      14.787  18.370   3.092  1.00 38.26           C  
ATOM   3299  CG  GLU D  39      14.982  19.735   2.578  1.00 40.93           C  
ATOM   3300  CD  GLU D  39      15.728  19.716   1.293  1.00 43.66           C  
ATOM   3301  OE1 GLU D  39      16.894  20.162   1.320  1.00 36.76           O  
ATOM   3302  OE2 GLU D  39      15.156  19.221   0.268  1.00 41.65           O  
ATOM   3303  N   ASP D  40      13.266  16.777   5.948  1.00 39.91           N  
ATOM   3304  CA  ASP D  40      13.070  15.501   6.616  1.00 39.85           C  
ATOM   3305  C   ASP D  40      11.560  15.119   6.592  1.00 39.63           C  
ATOM   3306  O   ASP D  40      10.810  15.447   7.521  1.00 39.77           O  
ATOM   3307  CB  ASP D  40      13.657  15.608   8.032  1.00 40.99           C  
ATOM   3308  CG  ASP D  40      13.499  14.338   8.855  1.00 44.59           C  
ATOM   3309  OD1 ASP D  40      13.374  13.228   8.275  1.00 43.95           O  
ATOM   3310  OD2 ASP D  40      13.539  14.470  10.110  1.00 48.33           O  
ATOM   3311  N   PRO D  41      11.113  14.456   5.490  1.00 38.18           N  
ATOM   3312  CA  PRO D  41      12.002  14.006   4.393  1.00 35.61           C  
ATOM   3313  C   PRO D  41      12.182  15.058   3.264  1.00 34.45           C  
ATOM   3314  O   PRO D  41      11.640  16.158   3.320  1.00 35.57           O  
ATOM   3315  CB  PRO D  41      11.266  12.789   3.848  1.00 33.59           C  
ATOM   3316  CG  PRO D  41       9.795  13.159   4.007  1.00 34.65           C  
ATOM   3317  CD  PRO D  41       9.699  14.173   5.166  1.00 37.41           C  
ATOM   3318  N   ILE D  42      12.963  14.708   2.257  1.00 34.31           N  
ATOM   3319  CA  ILE D  42      12.959  15.429   0.981  1.00 33.60           C  
ATOM   3320  C   ILE D  42      11.606  15.262   0.272  1.00 31.26           C  
ATOM   3321  O   ILE D  42      11.127  14.160   0.132  1.00 32.43           O  
ATOM   3322  CB  ILE D  42      14.113  14.928   0.075  1.00 32.10           C  
ATOM   3323  CG1 ILE D  42      15.457  15.127   0.779  1.00 31.76           C  
ATOM   3324  CG2 ILE D  42      14.077  15.582  -1.330  1.00 30.03           C  
ATOM   3325  CD1 ILE D  42      16.523  14.127   0.260  1.00 27.56           C  
ATOM   3326  N   GLY D  43      11.008  16.361  -0.175  1.00 32.54           N  
ATOM   3327  CA  GLY D  43       9.729  16.325  -0.891  1.00 35.05           C  
ATOM   3328  C   GLY D  43       8.583  16.665   0.044  1.00 36.98           C  
ATOM   3329  O   GLY D  43       8.794  16.818   1.258  1.00 35.10           O  
ATOM   3330  N   LYS D  44       7.358  16.736  -0.491  1.00 37.90           N  
ATOM   3331  CA  LYS D  44       6.229  17.165   0.342  1.00 40.20           C  
ATOM   3332  C   LYS D  44       5.750  16.040   1.214  1.00 38.35           C  
ATOM   3333  O   LYS D  44       5.450  14.954   0.719  1.00 38.73           O  
ATOM   3334  CB  LYS D  44       5.072  17.707  -0.501  1.00 41.28           C  
ATOM   3335  CG  LYS D  44       5.107  19.220  -0.726  1.00 44.80           C  
ATOM   3336  CD  LYS D  44       3.966  19.676  -1.645  1.00 45.41           C  
ATOM   3337  CE  LYS D  44       4.212  19.256  -3.113  1.00 52.30           C  
ATOM   3338  NZ  LYS D  44       5.087  20.244  -3.821  1.00 54.64           N  
ATOM   3339  N   SER D  45       5.654  16.324   2.516  1.00 39.05           N  
ATOM   3340  CA  SER D  45       5.164  15.370   3.550  1.00 38.37           C  
ATOM   3341  C   SER D  45       4.596  16.175   4.724  1.00 38.60           C  
ATOM   3342  O   SER D  45       4.678  17.401   4.715  1.00 37.64           O  
ATOM   3343  CB  SER D  45       6.321  14.473   4.026  1.00 37.31           C  
ATOM   3344  OG  SER D  45       5.868  13.236   4.556  1.00 37.09           O  
ATOM   3345  N   VAL D  46       4.018  15.515   5.729  1.00 38.99           N  
ATOM   3346  CA  VAL D  46       3.574  16.231   6.949  1.00 41.26           C  
ATOM   3347  C   VAL D  46       4.693  17.166   7.475  1.00 43.36           C  
ATOM   3348  O   VAL D  46       4.425  18.341   7.814  1.00 44.58           O  
ATOM   3349  CB  VAL D  46       3.136  15.259   8.108  1.00 41.46           C  
ATOM   3350  CG1 VAL D  46       2.484  16.044   9.274  1.00 44.00           C  
ATOM   3351  CG2 VAL D  46       2.183  14.162   7.611  1.00 44.45           C  
ATOM   3352  N   THR D  47       5.932  16.628   7.517  1.00 44.66           N  
ATOM   3353  CA  THR D  47       7.124  17.279   8.110  1.00 43.70           C  
ATOM   3354  C   THR D  47       7.905  18.189   7.148  1.00 43.98           C  
ATOM   3355  O   THR D  47       8.877  18.881   7.542  1.00 43.02           O  
ATOM   3356  CB  THR D  47       8.059  16.245   8.751  1.00 44.33           C  
ATOM   3357  OG1 THR D  47       8.301  15.174   7.842  1.00 42.17           O  
ATOM   3358  CG2 THR D  47       7.431  15.672  10.031  1.00 44.23           C  
ATOM   3359  N   ASN D  48       7.474  18.197   5.889  1.00 43.00           N  
ATOM   3360  CA  ASN D  48       8.002  19.144   4.888  1.00 44.62           C  
ATOM   3361  C   ASN D  48       6.816  19.613   4.034  1.00 44.83           C  
ATOM   3362  O   ASN D  48       6.597  19.081   2.953  1.00 44.86           O  
ATOM   3363  CB  ASN D  48       9.109  18.479   4.029  1.00 40.97           C  
ATOM   3364  CG  ASN D  48       9.845  19.479   3.109  1.00 42.93           C  
ATOM   3365  OD1 ASN D  48       9.646  20.708   3.170  1.00 37.48           O  
ATOM   3366  ND2 ASN D  48      10.730  18.946   2.271  1.00 40.02           N  
ATOM   3367  N   PRO D  49       6.002  20.548   4.563  1.00 46.19           N  
ATOM   3368  CA  PRO D  49       4.725  20.907   3.927  1.00 46.66           C  
ATOM   3369  C   PRO D  49       4.802  21.458   2.511  1.00 48.13           C  
ATOM   3370  O   PRO D  49       3.929  21.134   1.697  1.00 48.91           O  
ATOM   3371  CB  PRO D  49       4.154  21.962   4.869  1.00 46.43           C  
ATOM   3372  CG  PRO D  49       4.777  21.641   6.202  1.00 46.33           C  
ATOM   3373  CD  PRO D  49       6.183  21.258   5.846  1.00 46.19           C  
ATOM   3374  N   ASP D  50       5.804  22.283   2.208  1.00 49.31           N  
ATOM   3375  CA  ASP D  50       5.974  22.830   0.831  1.00 51.02           C  
ATOM   3376  C   ASP D  50       6.996  22.067  -0.065  1.00 50.10           C  
ATOM   3377  O   ASP D  50       7.280  22.479  -1.204  1.00 51.25           O  
ATOM   3378  CB  ASP D  50       6.349  24.320   0.894  1.00 52.00           C  
ATOM   3379  CG  ASP D  50       7.534  24.574   1.816  1.00 59.53           C  
ATOM   3380  OD1 ASP D  50       8.575  23.897   1.637  1.00 64.21           O  
ATOM   3381  OD2 ASP D  50       7.425  25.419   2.741  1.00 64.54           O  
ATOM   3382  N   GLY D  51       7.560  20.984   0.462  1.00 48.15           N  
ATOM   3383  CA  GLY D  51       8.612  20.230  -0.209  1.00 46.24           C  
ATOM   3384  C   GLY D  51       9.945  20.944  -0.349  1.00 45.77           C  
ATOM   3385  O   GLY D  51      10.873  20.406  -0.934  1.00 43.71           O  
ATOM   3386  N   SER D  52      10.053  22.172   0.150  1.00 45.66           N  
ATOM   3387  CA  SER D  52      11.311  22.874  -0.019  1.00 47.98           C  
ATOM   3388  C   SER D  52      12.232  22.883   1.231  1.00 48.29           C  
ATOM   3389  O   SER D  52      13.309  23.497   1.206  1.00 47.94           O  
ATOM   3390  CB  SER D  52      11.053  24.270  -0.581  1.00 48.18           C  
ATOM   3391  OG  SER D  52      10.375  25.081   0.379  1.00 53.57           O  
ATOM   3392  N   GLY D  53      11.806  22.195   2.303  1.00 48.46           N  
ATOM   3393  CA  GLY D  53      12.549  22.150   3.560  1.00 49.12           C  
ATOM   3394  C   GLY D  53      12.161  23.182   4.626  1.00 50.81           C  
ATOM   3395  O   GLY D  53      11.354  24.084   4.381  1.00 50.03           O  
ATOM   3396  N   ILE D  54      12.750  23.050   5.817  1.00 52.58           N  
ATOM   3397  CA  ILE D  54      12.551  24.037   6.905  1.00 53.92           C  
ATOM   3398  C   ILE D  54      13.774  24.969   6.950  1.00 54.58           C  
ATOM   3399  O   ILE D  54      14.892  24.503   7.129  1.00 54.13           O  
ATOM   3400  CB  ILE D  54      12.270  23.344   8.288  1.00 54.13           C  
ATOM   3401  CG1 ILE D  54      11.183  22.249   8.194  1.00 52.79           C  
ATOM   3402  CG2 ILE D  54      11.875  24.361   9.325  1.00 53.64           C  
ATOM   3403  CD1 ILE D  54       9.763  22.749   7.769  1.00 53.90           C  
ATOM   3404  N   LYS D  55      13.555  26.270   6.754  1.00 56.45           N  
ATOM   3405  CA  LYS D  55      14.655  27.238   6.514  1.00 58.27           C  
ATOM   3406  C   LYS D  55      14.984  28.224   7.673  1.00 59.42           C  
ATOM   3407  O   LYS D  55      14.159  29.077   8.047  1.00 57.67           O  
ATOM   3408  CB  LYS D  55      14.399  28.040   5.219  1.00 59.12           C  
ATOM   3409  CG  LYS D  55      13.904  27.218   4.011  1.00 58.89           C  
ATOM   3410  CD  LYS D  55      13.426  28.109   2.856  1.00 59.03           C  
ATOM   3411  CE  LYS D  55      12.409  27.403   1.965  1.00 61.89           C  
ATOM   3412  NZ  LYS D  55      11.161  27.051   2.733  1.00 61.24           N  
ATOM   3413  N   GLY D  56      16.211  28.107   8.197  1.00 60.86           N  
ATOM   3414  CA  GLY D  56      16.718  28.955   9.300  1.00 62.89           C  
ATOM   3415  C   GLY D  56      16.452  28.479  10.732  1.00 63.77           C  
ATOM   3416  O   GLY D  56      15.492  27.737  10.971  1.00 64.23           O  
ATOM   3417  N   LYS D  57      17.285  28.932  11.685  1.00 64.67           N  
ATOM   3418  CA  LYS D  57      17.141  28.592  13.127  1.00 65.61           C  
ATOM   3419  C   LYS D  57      15.707  28.735  13.712  1.00 65.59           C  
ATOM   3420  O   LYS D  57      15.275  27.912  14.537  1.00 65.96           O  
ATOM   3421  CB  LYS D  57      18.191  29.336  13.989  1.00 65.00           C  
ATOM   3422  CG  LYS D  57      19.475  28.504  14.258  1.00 66.38           C  
ATOM   3423  CD  LYS D  57      20.624  29.325  14.867  1.00 66.71           C  
ATOM   3424  CE  LYS D  57      21.441  28.501  15.873  1.00 70.82           C  
ATOM   3425  NZ  LYS D  57      22.900  28.895  15.991  1.00 71.15           N  
ATOM   3426  N   GLU D  58      14.984  29.763  13.261  1.00 65.29           N  
ATOM   3427  CA  GLU D  58      13.613  30.047  13.694  1.00 64.84           C  
ATOM   3428  C   GLU D  58      12.579  28.995  13.263  1.00 64.24           C  
ATOM   3429  O   GLU D  58      11.812  28.494  14.108  1.00 63.70           O  
ATOM   3430  CB  GLU D  58      13.196  31.443  13.208  1.00 65.79           C  
ATOM   3431  CG  GLU D  58      11.686  31.717  13.274  1.00 70.84           C  
ATOM   3432  CD  GLU D  58      11.335  33.139  13.708  1.00 76.95           C  
ATOM   3433  OE1 GLU D  58      10.117  33.411  13.874  1.00 76.45           O  
ATOM   3434  OE2 GLU D  58      12.267  33.971  13.895  1.00 79.70           O  
ATOM   3435  N   ALA D  59      12.544  28.682  11.957  1.00 62.72           N  
ATOM   3436  CA  ALA D  59      11.573  27.727  11.389  1.00 60.78           C  
ATOM   3437  C   ALA D  59      11.798  26.296  11.918  1.00 59.33           C  
ATOM   3438  O   ALA D  59      10.843  25.516  12.104  1.00 57.64           O  
ATOM   3439  CB  ALA D  59      11.636  27.764   9.873  1.00 60.82           C  
ATOM   3440  N   VAL D  60      13.074  25.983  12.147  1.00 58.19           N  
ATOM   3441  CA  VAL D  60      13.521  24.730  12.752  1.00 58.26           C  
ATOM   3442  C   VAL D  60      13.092  24.721  14.214  1.00 58.41           C  
ATOM   3443  O   VAL D  60      12.612  23.699  14.716  1.00 59.01           O  
ATOM   3444  CB  VAL D  60      15.058  24.542  12.599  1.00 58.20           C  
ATOM   3445  CG1 VAL D  60      15.561  23.371  13.421  1.00 57.18           C  
ATOM   3446  CG2 VAL D  60      15.430  24.362  11.134  1.00 58.60           C  
ATOM   3447  N   GLY D  61      13.247  25.867  14.886  1.00 59.10           N  
ATOM   3448  CA  GLY D  61      12.669  26.077  16.200  1.00 57.99           C  
ATOM   3449  C   GLY D  61      11.243  25.560  16.240  1.00 59.22           C  
ATOM   3450  O   GLY D  61      10.922  24.650  17.023  1.00 58.88           O  
ATOM   3451  N   ALA D  62      10.393  26.120  15.376  1.00 59.72           N  
ATOM   3452  CA  ALA D  62       8.975  25.709  15.242  1.00 60.51           C  
ATOM   3453  C   ALA D  62       8.801  24.241  14.831  1.00 60.26           C  
ATOM   3454  O   ALA D  62       7.804  23.606  15.171  1.00 59.63           O  
ATOM   3455  CB  ALA D  62       8.221  26.641  14.261  1.00 60.23           C  
ATOM   3456  N   PHE D  63       9.784  23.725  14.096  1.00 60.79           N  
ATOM   3457  CA  PHE D  63       9.828  22.315  13.726  1.00 61.08           C  
ATOM   3458  C   PHE D  63       9.927  21.451  14.983  1.00 60.86           C  
ATOM   3459  O   PHE D  63       9.194  20.453  15.112  1.00 60.58           O  
ATOM   3460  CB  PHE D  63      11.003  22.051  12.771  1.00 61.04           C  
ATOM   3461  CG  PHE D  63      11.083  20.645  12.277  1.00 61.52           C  
ATOM   3462  CD1 PHE D  63      10.385  20.254  11.130  1.00 64.00           C  
ATOM   3463  CD2 PHE D  63      11.861  19.700  12.949  1.00 62.01           C  
ATOM   3464  CE1 PHE D  63      10.468  18.914  10.661  1.00 64.44           C  
ATOM   3465  CE2 PHE D  63      11.949  18.369  12.498  1.00 61.81           C  
ATOM   3466  CZ  PHE D  63      11.257  17.973  11.355  1.00 61.91           C  
ATOM   3467  N   PHE D  64      10.824  21.859  15.893  1.00 60.84           N  
ATOM   3468  CA  PHE D  64      11.011  21.214  17.205  1.00 60.99           C  
ATOM   3469  C   PHE D  64       9.693  21.118  17.979  1.00 60.34           C  
ATOM   3470  O   PHE D  64       9.261  20.021  18.358  1.00 59.68           O  
ATOM   3471  CB  PHE D  64      12.082  21.943  18.058  1.00 60.24           C  
ATOM   3472  CG  PHE D  64      12.491  21.172  19.311  1.00 61.04           C  
ATOM   3473  CD1 PHE D  64      13.622  20.353  19.303  1.00 60.40           C  
ATOM   3474  CD2 PHE D  64      11.721  21.241  20.492  1.00 62.29           C  
ATOM   3475  CE1 PHE D  64      13.996  19.626  20.451  1.00 60.03           C  
ATOM   3476  CE2 PHE D  64      12.083  20.506  21.653  1.00 58.07           C  
ATOM   3477  CZ  PHE D  64      13.210  19.708  21.628  1.00 58.28           C  
ATOM   3478  N   ASP D  65       9.068  22.274  18.198  1.00 60.67           N  
ATOM   3479  CA  ASP D  65       7.814  22.371  18.952  1.00 61.26           C  
ATOM   3480  C   ASP D  65       6.746  21.441  18.360  1.00 62.20           C  
ATOM   3481  O   ASP D  65       6.048  20.734  19.107  1.00 61.83           O  
ATOM   3482  CB  ASP D  65       7.307  23.830  18.979  1.00 61.40           C  
ATOM   3483  CG  ASP D  65       8.375  24.820  19.444  1.00 58.09           C  
ATOM   3484  OD1 ASP D  65       9.338  24.372  20.099  1.00 56.46           O  
ATOM   3485  OD2 ASP D  65       8.254  26.034  19.153  1.00 53.92           O  
ATOM   3486  N   THR D  66       6.671  21.412  17.020  1.00 62.74           N  
ATOM   3487  CA  THR D  66       5.578  20.771  16.305  1.00 63.03           C  
ATOM   3488  C   THR D  66       5.663  19.263  16.291  1.00 63.29           C  
ATOM   3489  O   THR D  66       4.643  18.598  16.549  1.00 63.77           O  
ATOM   3490  CB  THR D  66       5.482  21.256  14.864  1.00 63.74           C  
ATOM   3491  OG1 THR D  66       5.211  22.663  14.850  1.00 67.37           O  
ATOM   3492  CG2 THR D  66       4.363  20.519  14.133  1.00 63.67           C  
ATOM   3493  N   HIS D  67       6.861  18.735  15.989  1.00 63.38           N  
ATOM   3494  CA  HIS D  67       7.084  17.276  15.792  1.00 62.78           C  
ATOM   3495  C   HIS D  67       7.918  16.567  16.870  1.00 63.38           C  
ATOM   3496  O   HIS D  67       7.687  15.393  17.146  1.00 63.39           O  
ATOM   3497  CB  HIS D  67       7.686  16.983  14.407  1.00 61.77           C  
ATOM   3498  CG  HIS D  67       6.907  17.564  13.262  1.00 59.27           C  
ATOM   3499  ND1 HIS D  67       5.603  17.207  12.986  1.00 54.23           N  
ATOM   3500  CD2 HIS D  67       7.254  18.477  12.320  1.00 55.45           C  
ATOM   3501  CE1 HIS D  67       5.183  17.881  11.929  1.00 54.18           C  
ATOM   3502  NE2 HIS D  67       6.162  18.659  11.507  1.00 48.79           N  
ATOM   3503  N   ILE D  68       8.878  17.269  17.479  1.00 64.83           N  
ATOM   3504  CA  ILE D  68       9.779  16.642  18.474  1.00 65.90           C  
ATOM   3505  C   ILE D  68       9.336  16.837  19.928  1.00 67.69           C  
ATOM   3506  O   ILE D  68       9.276  15.872  20.691  1.00 68.45           O  
ATOM   3507  CB  ILE D  68      11.269  17.089  18.318  1.00 65.06           C  
ATOM   3508  CG1 ILE D  68      11.781  16.781  16.904  1.00 64.45           C  
ATOM   3509  CG2 ILE D  68      12.146  16.407  19.371  1.00 62.66           C  
ATOM   3510  CD1 ILE D  68      12.804  17.766  16.377  1.00 60.89           C  
ATOM   3511  N   ALA D  69       9.044  18.077  20.315  1.00 69.03           N  
ATOM   3512  CA  ALA D  69       8.699  18.377  21.711  1.00 70.19           C  
ATOM   3513  C   ALA D  69       7.457  17.609  22.169  1.00 71.30           C  
ATOM   3514  O   ALA D  69       7.297  17.334  23.360  1.00 71.50           O  
ATOM   3515  CB  ALA D  69       8.520  19.878  21.917  1.00 69.64           C  
ATOM   3516  N   ALA D  70       6.589  17.257  21.217  1.00 72.56           N  
ATOM   3517  CA  ALA D  70       5.402  16.452  21.505  1.00 73.72           C  
ATOM   3518  C   ALA D  70       5.717  14.953  21.600  1.00 74.37           C  
ATOM   3519  O   ALA D  70       4.898  14.177  22.113  1.00 75.43           O  
ATOM   3520  CB  ALA D  70       4.325  16.710  20.442  1.00 73.91           C  
ATOM   3521  N   ASN D  71       6.921  14.575  21.153  1.00 74.09           N  
ATOM   3522  CA  ASN D  71       7.258  13.206  20.715  1.00 73.29           C  
ATOM   3523  C   ASN D  71       8.189  12.397  21.637  1.00 73.37           C  
ATOM   3524  O   ASN D  71       9.199  12.905  22.104  1.00 73.89           O  
ATOM   3525  CB  ASN D  71       7.905  13.308  19.325  1.00 72.52           C  
ATOM   3526  CG  ASN D  71       7.890  12.006  18.561  1.00 71.83           C  
ATOM   3527  OD1 ASN D  71       7.713  10.927  19.131  1.00 68.03           O  
ATOM   3528  ND2 ASN D  71       8.080  12.100  17.245  1.00 70.72           N  
ATOM   3529  N   ARG D  72       7.863  11.126  21.864  1.00 72.92           N  
ATOM   3530  CA  ARG D  72       8.767  10.203  22.569  1.00 73.33           C  
ATOM   3531  C   ARG D  72       9.618   9.413  21.548  1.00 71.36           C  
ATOM   3532  O   ARG D  72       9.370   8.222  21.263  1.00 70.32           O  
ATOM   3533  CB  ARG D  72       7.993   9.282  23.539  1.00 73.55           C  
ATOM   3534  CG  ARG D  72       8.864   8.531  24.559  1.00 75.03           C  
ATOM   3535  CD  ARG D  72       8.011   7.844  25.628  1.00 76.25           C  
ATOM   3536  NE  ARG D  72       7.928   8.630  26.870  1.00 84.22           N  
ATOM   3537  CZ  ARG D  72       6.971   8.511  27.795  1.00 86.21           C  
ATOM   3538  NH1 ARG D  72       5.981   7.639  27.631  1.00 86.89           N  
ATOM   3539  NH2 ARG D  72       6.997   9.270  28.892  1.00 85.65           N  
ATOM   3540  N   LEU D  73      10.635  10.110  21.029  1.00 69.82           N  
ATOM   3541  CA  LEU D  73      11.412   9.683  19.860  1.00 68.06           C  
ATOM   3542  C   LEU D  73      12.657   8.858  20.182  1.00 66.44           C  
ATOM   3543  O   LEU D  73      13.472   9.246  21.014  1.00 65.30           O  
ATOM   3544  CB  LEU D  73      11.813  10.912  19.029  1.00 68.37           C  
ATOM   3545  CG  LEU D  73      11.835  10.801  17.504  1.00 68.40           C  
ATOM   3546  CD1 LEU D  73      11.836  12.199  16.857  1.00 69.80           C  
ATOM   3547  CD2 LEU D  73      13.002   9.948  17.013  1.00 71.26           C  
ATOM   3548  N   THR D  74      12.781   7.714  19.509  1.00 65.37           N  
ATOM   3549  CA  THR D  74      14.017   6.930  19.518  1.00 64.46           C  
ATOM   3550  C   THR D  74      14.659   6.976  18.119  1.00 63.79           C  
ATOM   3551  O   THR D  74      14.032   6.572  17.133  1.00 64.20           O  
ATOM   3552  CB  THR D  74      13.789   5.423  19.928  1.00 65.00           C  
ATOM   3553  OG1 THR D  74      12.743   5.317  20.902  1.00 64.56           O  
ATOM   3554  CG2 THR D  74      15.078   4.797  20.477  1.00 63.00           C  
ATOM   3555  N   VAL D  75      15.893   7.487  18.042  1.00 61.73           N  
ATOM   3556  CA  VAL D  75      16.735   7.344  16.860  1.00 59.22           C  
ATOM   3557  C   VAL D  75      17.570   6.078  17.028  1.00 58.39           C  
ATOM   3558  O   VAL D  75      18.243   5.907  18.046  1.00 58.88           O  
ATOM   3559  CB  VAL D  75      17.730   8.533  16.706  1.00 59.75           C  
ATOM   3560  CG1 VAL D  75      18.292   8.561  15.310  1.00 57.94           C  
ATOM   3561  CG2 VAL D  75      17.075   9.869  17.051  1.00 59.10           C  
ATOM   3562  N   THR D  76      17.551   5.186  16.047  1.00 56.53           N  
ATOM   3563  CA  THR D  76      18.500   4.075  16.047  1.00 55.61           C  
ATOM   3564  C   THR D  76      19.397   4.199  14.822  1.00 55.13           C  
ATOM   3565  O   THR D  76      18.936   3.968  13.698  1.00 54.59           O  
ATOM   3566  CB  THR D  76      17.781   2.691  16.039  1.00 56.26           C  
ATOM   3567  OG1 THR D  76      16.937   2.587  17.193  1.00 60.07           O  
ATOM   3568  CG2 THR D  76      18.772   1.517  16.045  1.00 54.03           C  
ATOM   3569  N   CYS D  77      20.668   4.559  15.025  1.00 53.55           N  
ATOM   3570  CA  CYS D  77      21.649   4.480  13.929  1.00 52.10           C  
ATOM   3571  C   CYS D  77      22.036   3.044  13.576  1.00 51.36           C  
ATOM   3572  O   CYS D  77      22.844   2.417  14.278  1.00 51.37           O  
ATOM   3573  CB  CYS D  77      22.926   5.272  14.207  1.00 51.93           C  
ATOM   3574  SG  CYS D  77      24.177   4.968  12.910  1.00 52.36           S  
ATOM   3575  N   GLU D  78      21.485   2.542  12.474  1.00 49.60           N  
ATOM   3576  CA  GLU D  78      21.815   1.206  12.002  1.00 48.10           C  
ATOM   3577  C   GLU D  78      23.151   1.094  11.255  1.00 47.81           C  
ATOM   3578  O   GLU D  78      23.778   0.031  11.293  1.00 47.71           O  
ATOM   3579  CB  GLU D  78      20.690   0.671  11.140  1.00 48.10           C  
ATOM   3580  CG  GLU D  78      21.054  -0.531  10.328  1.00 46.64           C  
ATOM   3581  CD  GLU D  78      19.974  -0.879   9.349  1.00 50.91           C  
ATOM   3582  OE1 GLU D  78      18.780  -0.703   9.699  1.00 49.65           O  
ATOM   3583  OE2 GLU D  78      20.331  -1.333   8.240  1.00 52.12           O  
ATOM   3584  N   GLU D  79      23.573   2.154  10.549  1.00 46.40           N  
ATOM   3585  CA  GLU D  79      24.862   2.104   9.803  1.00 44.02           C  
ATOM   3586  C   GLU D  79      25.303   3.457   9.381  1.00 43.05           C  
ATOM   3587  O   GLU D  79      24.477   4.330   9.151  1.00 43.73           O  
ATOM   3588  CB  GLU D  79      24.816   1.179   8.583  1.00 42.54           C  
ATOM   3589  CG  GLU D  79      26.177   0.983   7.867  1.00 45.86           C  
ATOM   3590  CD  GLU D  79      26.177  -0.203   6.904  1.00 45.09           C  
ATOM   3591  OE1 GLU D  79      25.067  -0.646   6.542  1.00 46.73           O  
ATOM   3592  OE2 GLU D  79      27.279  -0.701   6.517  1.00 46.54           O  
ATOM   3593  N   THR D  80      26.614   3.637   9.281  1.00 41.44           N  
ATOM   3594  CA  THR D  80      27.172   4.897   8.854  1.00 40.74           C  
ATOM   3595  C   THR D  80      27.950   4.678   7.550  1.00 40.99           C  
ATOM   3596  O   THR D  80      28.569   3.610   7.313  1.00 39.75           O  
ATOM   3597  CB  THR D  80      28.012   5.569  10.001  1.00 41.14           C  
ATOM   3598  OG1 THR D  80      27.129   5.910  11.080  1.00 44.22           O  
ATOM   3599  CG2 THR D  80      28.696   6.843   9.554  1.00 39.67           C  
ATOM   3600  N   PHE D  81      27.856   5.700   6.699  1.00 40.87           N  
ATOM   3601  CA  PHE D  81      28.554   5.810   5.410  1.00 38.88           C  
ATOM   3602  C   PHE D  81      29.246   7.164   5.339  1.00 39.93           C  
ATOM   3603  O   PHE D  81      28.628   8.195   5.066  1.00 39.24           O  
ATOM   3604  CB  PHE D  81      27.575   5.637   4.275  1.00 37.98           C  
ATOM   3605  CG  PHE D  81      27.042   4.254   4.168  1.00 33.35           C  
ATOM   3606  CD1 PHE D  81      27.682   3.332   3.389  1.00 27.04           C  
ATOM   3607  CD2 PHE D  81      25.909   3.883   4.847  1.00 33.70           C  
ATOM   3608  CE1 PHE D  81      27.218   2.048   3.278  1.00 33.89           C  
ATOM   3609  CE2 PHE D  81      25.402   2.579   4.711  1.00 35.22           C  
ATOM   3610  CZ  PHE D  81      26.062   1.667   3.930  1.00 33.77           C  
ATOM   3611  N   PRO D  82      30.547   7.162   5.652  1.00 40.50           N  
ATOM   3612  CA  PRO D  82      31.399   8.346   5.560  1.00 39.78           C  
ATOM   3613  C   PRO D  82      31.589   8.680   4.086  1.00 37.33           C  
ATOM   3614  O   PRO D  82      31.577   7.770   3.245  1.00 35.37           O  
ATOM   3615  CB  PRO D  82      32.748   7.861   6.162  1.00 40.48           C  
ATOM   3616  CG  PRO D  82      32.426   6.559   6.884  1.00 42.83           C  
ATOM   3617  CD  PRO D  82      31.281   5.965   6.118  1.00 41.64           C  
ATOM   3618  N   SER D  83      31.751   9.949   3.766  1.00 35.71           N  
ATOM   3619  CA  SER D  83      32.239  10.317   2.437  1.00 37.33           C  
ATOM   3620  C   SER D  83      33.798  10.491   2.486  1.00 39.84           C  
ATOM   3621  O   SER D  83      34.455   9.939   3.384  1.00 39.66           O  
ATOM   3622  CB  SER D  83      31.546  11.594   1.930  1.00 36.81           C  
ATOM   3623  OG  SER D  83      32.002  12.752   2.625  1.00 28.92           O  
ATOM   3624  N   SER D  84      34.351  11.237   1.521  1.00 40.44           N  
ATOM   3625  CA  SER D  84      35.748  11.693   1.512  1.00 40.14           C  
ATOM   3626  C   SER D  84      35.821  13.181   1.903  1.00 41.82           C  
ATOM   3627  O   SER D  84      36.888  13.805   1.832  1.00 42.78           O  
ATOM   3628  CB  SER D  84      36.371  11.474   0.149  1.00 37.25           C  
ATOM   3629  OG  SER D  84      36.213  10.119  -0.253  1.00 38.37           O  
ATOM   3630  N   SER D  85      34.687  13.749   2.307  1.00 42.09           N  
ATOM   3631  CA  SER D  85      34.710  15.005   3.017  1.00 43.96           C  
ATOM   3632  C   SER D  85      34.448  14.709   4.506  1.00 46.27           C  
ATOM   3633  O   SER D  85      33.597  13.866   4.828  1.00 45.47           O  
ATOM   3634  CB  SER D  85      33.694  15.988   2.450  1.00 44.12           C  
ATOM   3635  OG  SER D  85      33.819  17.290   3.008  1.00 44.39           O  
ATOM   3636  N   PRO D  86      35.237  15.338   5.418  1.00 47.44           N  
ATOM   3637  CA  PRO D  86      34.955  15.306   6.863  1.00 46.90           C  
ATOM   3638  C   PRO D  86      33.627  15.986   7.215  1.00 47.59           C  
ATOM   3639  O   PRO D  86      33.074  15.737   8.306  1.00 47.72           O  
ATOM   3640  CB  PRO D  86      36.119  16.105   7.458  1.00 47.28           C  
ATOM   3641  CG  PRO D  86      36.615  16.953   6.332  1.00 47.94           C  
ATOM   3642  CD  PRO D  86      36.489  16.074   5.132  1.00 47.56           C  
ATOM   3643  N   ASP D  87      33.112  16.787   6.268  1.00 46.30           N  
ATOM   3644  CA  ASP D  87      31.936  17.645   6.452  1.00 44.60           C  
ATOM   3645  C   ASP D  87      30.606  17.084   5.910  1.00 42.89           C  
ATOM   3646  O   ASP D  87      29.571  17.762   5.978  1.00 42.07           O  
ATOM   3647  CB  ASP D  87      32.202  19.005   5.797  1.00 44.98           C  
ATOM   3648  CG  ASP D  87      33.221  19.851   6.582  1.00 49.02           C  
ATOM   3649  OD1 ASP D  87      33.681  19.390   7.663  1.00 52.78           O  
ATOM   3650  OD2 ASP D  87      33.531  20.974   6.122  1.00 51.56           O  
ATOM   3651  N   GLU D  88      30.635  15.868   5.376  1.00 40.41           N  
ATOM   3652  CA  GLU D  88      29.436  15.243   4.840  1.00 40.27           C  
ATOM   3653  C   GLU D  88      29.398  13.735   5.116  1.00 39.67           C  
ATOM   3654  O   GLU D  88      30.348  13.004   4.819  1.00 37.98           O  
ATOM   3655  CB  GLU D  88      29.297  15.549   3.324  1.00 39.77           C  
ATOM   3656  CG  GLU D  88      29.002  17.046   2.995  1.00 38.90           C  
ATOM   3657  CD  GLU D  88      28.491  17.280   1.580  1.00 41.93           C  
ATOM   3658  OE1 GLU D  88      27.344  16.847   1.258  1.00 41.22           O  
ATOM   3659  OE2 GLU D  88      29.221  17.933   0.800  1.00 40.30           O  
ATOM   3660  N   ILE D  89      28.267  13.297   5.658  1.00 39.27           N  
ATOM   3661  CA  ILE D  89      28.045  11.941   6.128  1.00 38.14           C  
ATOM   3662  C   ILE D  89      26.604  11.439   5.818  1.00 37.17           C  
ATOM   3663  O   ILE D  89      25.650  12.213   5.752  1.00 35.71           O  
ATOM   3664  CB  ILE D  89      28.309  11.872   7.657  1.00 38.44           C  
ATOM   3665  CG1 ILE D  89      28.681  10.456   8.084  1.00 42.86           C  
ATOM   3666  CG2 ILE D  89      27.102  12.358   8.469  1.00 37.75           C  
ATOM   3667  CD1 ILE D  89      29.693  10.415   9.248  1.00 42.51           C  
ATOM   3668  N   ALA D  90      26.463  10.130   5.659  1.00 37.11           N  
ATOM   3669  CA  ALA D  90      25.175   9.528   5.418  1.00 37.43           C  
ATOM   3670  C   ALA D  90      24.979   8.430   6.442  1.00 39.22           C  
ATOM   3671  O   ALA D  90      25.947   7.823   6.858  1.00 39.07           O  
ATOM   3672  CB  ALA D  90      25.133   8.960   4.023  1.00 36.02           C  
ATOM   3673  N   HIS D  91      23.735   8.163   6.835  1.00 39.94           N  
ATOM   3674  CA  HIS D  91      23.425   7.052   7.729  1.00 39.97           C  
ATOM   3675  C   HIS D  91      22.132   6.368   7.314  1.00 41.76           C  
ATOM   3676  O   HIS D  91      21.263   6.987   6.682  1.00 42.79           O  
ATOM   3677  CB  HIS D  91      23.158   7.545   9.162  1.00 40.34           C  
ATOM   3678  CG  HIS D  91      24.181   8.487   9.695  1.00 38.38           C  
ATOM   3679  ND1 HIS D  91      25.312   8.058  10.351  1.00 41.53           N  
ATOM   3680  CD2 HIS D  91      24.239   9.840   9.679  1.00 40.85           C  
ATOM   3681  CE1 HIS D  91      26.035   9.108  10.707  1.00 45.66           C  
ATOM   3682  NE2 HIS D  91      25.401  10.204  10.322  1.00 41.42           N  
ATOM   3683  N   ILE D  92      21.992   5.101   7.694  1.00 40.70           N  
ATOM   3684  CA  ILE D  92      20.674   4.492   7.791  1.00 41.29           C  
ATOM   3685  C   ILE D  92      20.243   4.655   9.276  1.00 41.39           C  
ATOM   3686  O   ILE D  92      21.004   4.315  10.202  1.00 40.63           O  
ATOM   3687  CB  ILE D  92      20.717   3.055   7.322  1.00 40.56           C  
ATOM   3688  CG1 ILE D  92      21.494   2.971   6.000  1.00 44.84           C  
ATOM   3689  CG2 ILE D  92      19.300   2.463   7.165  1.00 45.18           C  
ATOM   3690  CD1 ILE D  92      22.040   1.610   5.716  1.00 51.97           C  
ATOM   3691  N   LEU D  93      19.066   5.255   9.474  1.00 40.63           N  
ATOM   3692  CA  LEU D  93      18.414   5.443  10.770  1.00 40.14           C  
ATOM   3693  C   LEU D  93      17.017   4.781  10.798  1.00 43.05           C  
ATOM   3694  O   LEU D  93      16.291   4.730   9.794  1.00 42.11           O  
ATOM   3695  CB  LEU D  93      18.279   6.945  11.114  1.00 39.71           C  
ATOM   3696  CG  LEU D  93      19.545   7.805  10.949  1.00 39.76           C  
ATOM   3697  CD1 LEU D  93      19.358   9.245  11.338  1.00 38.10           C  
ATOM   3698  CD2 LEU D  93      20.722   7.244  11.754  1.00 43.20           C  
ATOM   3699  N   VAL D  94      16.649   4.257  11.962  1.00 44.59           N  
ATOM   3700  CA  VAL D  94      15.264   3.897  12.219  1.00 45.03           C  
ATOM   3701  C   VAL D  94      14.709   4.969  13.142  1.00 45.84           C  
ATOM   3702  O   VAL D  94      15.282   5.242  14.182  1.00 46.11           O  
ATOM   3703  CB  VAL D  94      15.147   2.506  12.810  1.00 44.60           C  
ATOM   3704  CG1 VAL D  94      13.709   2.147  12.957  1.00 46.22           C  
ATOM   3705  CG2 VAL D  94      15.825   1.514  11.889  1.00 41.13           C  
ATOM   3706  N   LEU D  95      13.635   5.621  12.713  1.00 46.76           N  
ATOM   3707  CA  LEU D  95      13.030   6.703  13.482  1.00 48.42           C  
ATOM   3708  C   LEU D  95      11.751   6.186  14.109  1.00 49.58           C  
ATOM   3709  O   LEU D  95      10.818   5.766  13.404  1.00 49.21           O  
ATOM   3710  CB  LEU D  95      12.779   7.941  12.611  1.00 48.57           C  
ATOM   3711  CG  LEU D  95      13.731   9.151  12.668  1.00 46.36           C  
ATOM   3712  CD1 LEU D  95      15.188   8.784  12.941  1.00 39.37           C  
ATOM   3713  CD2 LEU D  95      13.592  10.004  11.392  1.00 47.41           C  
ATOM   3714  N   HIS D  96      11.742   6.194  15.443  1.00 50.75           N  
ATOM   3715  CA  HIS D  96      10.667   5.615  16.230  1.00 52.22           C  
ATOM   3716  C   HIS D  96       9.962   6.663  17.089  1.00 53.45           C  
ATOM   3717  O   HIS D  96      10.585   7.335  17.907  1.00 53.16           O  
ATOM   3718  CB  HIS D  96      11.177   4.457  17.080  1.00 52.87           C  
ATOM   3719  CG  HIS D  96      10.078   3.662  17.709  1.00 55.30           C  
ATOM   3720  ND1 HIS D  96       9.471   2.600  17.066  1.00 53.60           N  
ATOM   3721  CD2 HIS D  96       9.445   3.801  18.902  1.00 55.68           C  
ATOM   3722  CE1 HIS D  96       8.521   2.109  17.846  1.00 57.88           C  
ATOM   3723  NE2 HIS D  96       8.489   2.816  18.966  1.00 58.52           N  
ATOM   3724  N   SER D  97       8.652   6.789  16.877  1.00 55.06           N  
ATOM   3725  CA  SER D  97       7.870   7.904  17.386  1.00 56.25           C  
ATOM   3726  C   SER D  97       6.724   7.458  18.278  1.00 58.57           C  
ATOM   3727  O   SER D  97       6.160   6.377  18.100  1.00 58.26           O  
ATOM   3728  CB  SER D  97       7.343   8.730  16.224  1.00 55.19           C  
ATOM   3729  OG  SER D  97       8.282   9.710  15.861  1.00 53.10           O  
ATOM   3730  N   GLU D  98       6.398   8.300  19.253  1.00 62.12           N  
ATOM   3731  CA  GLU D  98       5.331   8.019  20.222  1.00 66.01           C  
ATOM   3732  C   GLU D  98       4.797   9.337  20.787  1.00 66.96           C  
ATOM   3733  O   GLU D  98       5.553  10.137  21.343  1.00 67.76           O  
ATOM   3734  CB  GLU D  98       5.836   7.120  21.379  1.00 66.25           C  
ATOM   3735  CG  GLU D  98       6.079   5.625  21.045  1.00 67.18           C  
ATOM   3736  CD  GLU D  98       6.073   4.699  22.276  1.00 69.02           C  
ATOM   3737  OE1 GLU D  98       6.718   3.615  22.234  1.00 71.14           O  
ATOM   3738  OE2 GLU D  98       5.414   5.051  23.288  1.00 73.25           O  
ATOM   3739  N   PHE D  99       3.499   9.571  20.637  1.00 68.49           N  
ATOM   3740  CA  PHE D  99       2.855  10.722  21.297  1.00 70.44           C  
ATOM   3741  C   PHE D  99       1.858  10.216  22.362  1.00 71.01           C  
ATOM   3742  O   PHE D  99       1.545  10.936  23.337  1.00 71.31           O  
ATOM   3743  CB  PHE D  99       2.162  11.662  20.280  1.00 70.47           C  
ATOM   3744  CG  PHE D  99       2.903  11.806  18.972  1.00 70.37           C  
ATOM   3745  CD1 PHE D  99       2.875  10.777  18.015  1.00 68.36           C  
ATOM   3746  CD2 PHE D  99       3.627  12.973  18.691  1.00 70.40           C  
ATOM   3747  CE1 PHE D  99       3.573  10.896  16.814  1.00 68.98           C  
ATOM   3748  CE2 PHE D  99       4.322  13.112  17.482  1.00 69.85           C  
ATOM   3749  CZ  PHE D  99       4.292  12.074  16.543  1.00 70.47           C  
ATOM   3750  N   PHE D 103       0.160   5.128  20.476  1.00 64.45           N  
ATOM   3751  CA  PHE D 103       0.362   5.269  18.996  1.00 65.13           C  
ATOM   3752  C   PHE D 103       1.820   5.493  18.556  1.00 64.39           C  
ATOM   3753  O   PHE D 103       2.397   6.595  18.705  1.00 63.11           O  
ATOM   3754  CB  PHE D 103      -0.512   6.384  18.413  1.00 65.46           C  
ATOM   3755  CG  PHE D 103      -0.324   6.587  16.923  1.00 65.72           C  
ATOM   3756  CD1 PHE D 103      -0.829   5.646  16.005  1.00 61.79           C  
ATOM   3757  CD2 PHE D 103       0.366   7.722  16.437  1.00 66.17           C  
ATOM   3758  CE1 PHE D 103      -0.655   5.828  14.634  1.00 60.68           C  
ATOM   3759  CE2 PHE D 103       0.547   7.910  15.066  1.00 64.09           C  
ATOM   3760  CZ  PHE D 103       0.035   6.960  14.160  1.00 61.90           C  
ATOM   3761  N   THR D 104       2.373   4.434  17.975  1.00 63.33           N  
ATOM   3762  CA  THR D 104       3.724   4.437  17.475  1.00 62.78           C  
ATOM   3763  C   THR D 104       3.780   4.580  15.949  1.00 61.11           C  
ATOM   3764  O   THR D 104       2.863   4.163  15.240  1.00 61.74           O  
ATOM   3765  CB  THR D 104       4.508   3.174  17.960  1.00 63.61           C  
ATOM   3766  OG1 THR D 104       3.944   1.962  17.411  1.00 64.59           O  
ATOM   3767  CG2 THR D 104       4.485   3.096  19.491  1.00 64.61           C  
ATOM   3768  N   SER D 105       4.839   5.217  15.463  1.00 59.10           N  
ATOM   3769  CA  SER D 105       5.225   5.155  14.053  1.00 56.52           C  
ATOM   3770  C   SER D 105       6.720   4.842  13.970  1.00 56.03           C  
ATOM   3771  O   SER D 105       7.500   5.188  14.867  1.00 56.04           O  
ATOM   3772  CB  SER D 105       4.959   6.480  13.345  1.00 55.65           C  
ATOM   3773  OG  SER D 105       6.098   7.313  13.409  1.00 52.98           O  
ATOM   3774  N   GLU D 106       7.115   4.204  12.881  1.00 54.07           N  
ATOM   3775  CA  GLU D 106       8.521   3.908  12.641  1.00 52.86           C  
ATOM   3776  C   GLU D 106       8.838   4.012  11.155  1.00 49.49           C  
ATOM   3777  O   GLU D 106       8.070   3.526  10.320  1.00 48.57           O  
ATOM   3778  CB  GLU D 106       8.844   2.504  13.118  1.00 52.94           C  
ATOM   3779  CG  GLU D 106      10.300   2.263  13.386  1.00 56.73           C  
ATOM   3780  CD  GLU D 106      10.503   0.999  14.195  1.00 62.19           C  
ATOM   3781  OE1 GLU D 106      10.192  -0.093  13.672  1.00 60.83           O  
ATOM   3782  OE2 GLU D 106      10.947   1.107  15.360  1.00 66.95           O  
ATOM   3783  N   VAL D 107       9.963   4.650  10.847  1.00 46.98           N  
ATOM   3784  CA  VAL D 107      10.477   4.705   9.478  1.00 45.13           C  
ATOM   3785  C   VAL D 107      12.000   4.550   9.443  1.00 45.52           C  
ATOM   3786  O   VAL D 107      12.725   5.154  10.238  1.00 44.69           O  
ATOM   3787  CB  VAL D 107      10.028   5.994   8.731  1.00 44.73           C  
ATOM   3788  CG1 VAL D 107      10.634   7.272   9.349  1.00 37.97           C  
ATOM   3789  CG2 VAL D 107      10.334   5.870   7.260  1.00 43.02           C  
ATOM   3790  N   ARG D 108      12.469   3.709   8.530  1.00 45.25           N  
ATOM   3791  CA  ARG D 108      13.892   3.503   8.321  1.00 43.70           C  
ATOM   3792  C   ARG D 108      14.269   4.178   6.990  1.00 43.65           C  
ATOM   3793  O   ARG D 108      13.635   3.928   5.948  1.00 43.51           O  
ATOM   3794  CB  ARG D 108      14.179   1.997   8.302  1.00 44.07           C  
ATOM   3795  CG  ARG D 108      15.566   1.613   7.866  1.00 43.69           C  
ATOM   3796  CD  ARG D 108      15.828   0.136   8.102  1.00 43.64           C  
ATOM   3797  NE  ARG D 108      17.138  -0.196   7.580  1.00 43.22           N  
ATOM   3798  CZ  ARG D 108      17.358  -0.573   6.330  1.00 45.67           C  
ATOM   3799  NH1 ARG D 108      16.325  -0.710   5.502  1.00 44.29           N  
ATOM   3800  NH2 ARG D 108      18.599  -0.846   5.914  1.00 41.24           N  
ATOM   3801  N   GLY D 109      15.253   5.064   7.032  1.00 41.34           N  
ATOM   3802  CA  GLY D 109      15.735   5.671   5.799  1.00 41.34           C  
ATOM   3803  C   GLY D 109      17.197   6.102   5.824  1.00 40.14           C  
ATOM   3804  O   GLY D 109      17.870   6.014   6.862  1.00 39.43           O  
ATOM   3805  N   VAL D 110      17.680   6.561   4.666  1.00 38.77           N  
ATOM   3806  CA  VAL D 110      18.959   7.255   4.571  1.00 35.77           C  
ATOM   3807  C   VAL D 110      18.767   8.730   4.925  1.00 36.42           C  
ATOM   3808  O   VAL D 110      17.779   9.397   4.522  1.00 37.17           O  
ATOM   3809  CB  VAL D 110      19.595   7.096   3.182  1.00 36.63           C  
ATOM   3810  CG1 VAL D 110      20.799   8.005   3.030  1.00 34.21           C  
ATOM   3811  CG2 VAL D 110      19.978   5.620   2.933  1.00 34.90           C  
ATOM   3812  N   PHE D 111      19.713   9.237   5.707  1.00 35.89           N  
ATOM   3813  CA  PHE D 111      19.686  10.588   6.193  1.00 34.24           C  
ATOM   3814  C   PHE D 111      21.084  11.073   5.957  1.00 34.71           C  
ATOM   3815  O   PHE D 111      22.023  10.349   6.195  1.00 35.78           O  
ATOM   3816  CB  PHE D 111      19.297  10.628   7.686  1.00 32.62           C  
ATOM   3817  CG  PHE D 111      17.874  10.204   7.966  1.00 34.25           C  
ATOM   3818  CD1 PHE D 111      16.872  11.162   8.174  1.00 30.78           C  
ATOM   3819  CD2 PHE D 111      17.540   8.861   8.022  1.00 25.57           C  
ATOM   3820  CE1 PHE D 111      15.578  10.776   8.433  1.00 30.50           C  
ATOM   3821  CE2 PHE D 111      16.259   8.443   8.277  1.00 31.31           C  
ATOM   3822  CZ  PHE D 111      15.247   9.396   8.488  1.00 32.32           C  
ATOM   3823  N   THR D 112      21.219  12.279   5.423  1.00 36.79           N  
ATOM   3824  CA  THR D 112      22.511  12.842   5.083  1.00 37.67           C  
ATOM   3825  C   THR D 112      22.673  14.184   5.815  1.00 37.89           C  
ATOM   3826  O   THR D 112      21.670  14.852   6.103  1.00 36.00           O  
ATOM   3827  CB  THR D 112      22.690  13.025   3.484  1.00 39.02           C  
ATOM   3828  OG1 THR D 112      21.847  14.081   2.982  1.00 35.10           O  
ATOM   3829  CG2 THR D 112      22.418  11.718   2.719  1.00 36.77           C  
ATOM   3830  N   TYR D 113      23.925  14.587   6.095  1.00 38.37           N  
ATOM   3831  CA  TYR D 113      24.187  15.812   6.862  1.00 38.85           C  
ATOM   3832  C   TYR D 113      25.312  16.560   6.241  1.00 38.98           C  
ATOM   3833  O   TYR D 113      26.289  15.959   5.784  1.00 40.93           O  
ATOM   3834  CB  TYR D 113      24.568  15.503   8.331  1.00 40.41           C  
ATOM   3835  CG  TYR D 113      23.474  14.887   9.185  1.00 38.57           C  
ATOM   3836  CD1 TYR D 113      22.820  15.652  10.140  1.00 38.77           C  
ATOM   3837  CD2 TYR D 113      23.081  13.551   9.018  1.00 35.00           C  
ATOM   3838  CE1 TYR D 113      21.817  15.117  10.935  1.00 39.10           C  
ATOM   3839  CE2 TYR D 113      22.067  13.001   9.810  1.00 39.61           C  
ATOM   3840  CZ  TYR D 113      21.445  13.800  10.776  1.00 43.05           C  
ATOM   3841  OH  TYR D 113      20.435  13.309  11.579  1.00 43.72           O  
ATOM   3842  N   ARG D 114      25.176  17.870   6.225  1.00 39.10           N  
ATOM   3843  CA  ARG D 114      26.244  18.726   5.816  1.00 41.35           C  
ATOM   3844  C   ARG D 114      26.468  19.817   6.883  1.00 43.31           C  
ATOM   3845  O   ARG D 114      25.529  20.477   7.337  1.00 43.70           O  
ATOM   3846  CB  ARG D 114      25.959  19.356   4.454  1.00 40.30           C  
ATOM   3847  CG  ARG D 114      27.170  20.078   3.842  1.00 44.28           C  
ATOM   3848  CD  ARG D 114      26.788  21.120   2.811  1.00 45.36           C  
ATOM   3849  NE  ARG D 114      27.950  21.923   2.425  1.00 53.39           N  
ATOM   3850  CZ  ARG D 114      28.277  23.106   2.951  1.00 57.66           C  
ATOM   3851  NH1 ARG D 114      27.538  23.671   3.904  1.00 57.91           N  
ATOM   3852  NH2 ARG D 114      29.356  23.729   2.521  1.00 57.46           N  
ATOM   3853  N   VAL D 115      27.730  19.991   7.252  1.00 44.88           N  
ATOM   3854  CA  VAL D 115      28.151  20.985   8.213  1.00 45.99           C  
ATOM   3855  C   VAL D 115      29.052  21.948   7.466  1.00 48.75           C  
ATOM   3856  O   VAL D 115      29.809  21.525   6.555  1.00 48.46           O  
ATOM   3857  CB  VAL D 115      28.884  20.331   9.455  1.00 45.81           C  
ATOM   3858  CG1 VAL D 115      27.978  19.295  10.135  1.00 46.28           C  
ATOM   3859  CG2 VAL D 115      30.239  19.707   9.100  1.00 41.38           C  
ATOM   3860  N   ASN D 116      28.953  23.235   7.796  1.00 51.54           N  
ATOM   3861  CA  ASN D 116      29.919  24.218   7.264  1.00 55.43           C  
ATOM   3862  C   ASN D 116      31.337  24.058   7.918  1.00 57.91           C  
ATOM   3863  O   ASN D 116      31.616  23.033   8.570  1.00 58.86           O  
ATOM   3864  CB  ASN D 116      29.364  25.637   7.385  1.00 54.45           C  
ATOM   3865  CG  ASN D 116      29.117  26.038   8.808  1.00 55.78           C  
ATOM   3866  OD1 ASN D 116      29.651  25.427   9.739  1.00 58.85           O  
ATOM   3867  ND2 ASN D 116      28.293  27.061   9.000  1.00 54.86           N  
ATOM   3868  N   LYS D 117      32.235  25.030   7.741  1.00 60.35           N  
ATOM   3869  CA  LYS D 117      33.613  24.885   8.273  1.00 62.16           C  
ATOM   3870  C   LYS D 117      33.756  25.192   9.778  1.00 62.34           C  
ATOM   3871  O   LYS D 117      34.746  24.796  10.404  1.00 63.72           O  
ATOM   3872  CB  LYS D 117      34.655  25.619   7.414  1.00 62.23           C  
ATOM   3873  CG  LYS D 117      34.562  27.151   7.398  1.00 63.60           C  
ATOM   3874  CD  LYS D 117      35.781  27.725   6.644  1.00 64.14           C  
ATOM   3875  CE  LYS D 117      36.004  29.225   6.888  1.00 66.94           C  
ATOM   3876  NZ  LYS D 117      37.023  29.466   7.946  1.00 66.73           N  
ATOM   3877  N   ALA D 118      32.752  25.863  10.343  1.00 61.68           N  
ATOM   3878  CA  ALA D 118      32.563  25.962  11.796  1.00 61.33           C  
ATOM   3879  C   ALA D 118      32.214  24.627  12.468  1.00 60.66           C  
ATOM   3880  O   ALA D 118      32.309  24.514  13.697  1.00 62.36           O  
ATOM   3881  CB  ALA D 118      31.473  26.989  12.123  1.00 60.71           C  
ATOM   3882  N   GLY D 119      31.801  23.633  11.681  1.00 58.83           N  
ATOM   3883  CA  GLY D 119      31.271  22.375  12.206  1.00 56.44           C  
ATOM   3884  C   GLY D 119      29.775  22.430  12.510  1.00 55.80           C  
ATOM   3885  O   GLY D 119      29.228  21.486  13.117  1.00 55.36           O  
ATOM   3886  N   LEU D 120      29.116  23.523  12.097  1.00 54.15           N  
ATOM   3887  CA  LEU D 120      27.650  23.693  12.248  1.00 53.64           C  
ATOM   3888  C   LEU D 120      26.840  23.084  11.058  1.00 53.21           C  
ATOM   3889  O   LEU D 120      27.326  23.097   9.915  1.00 51.35           O  
ATOM   3890  CB  LEU D 120      27.288  25.188  12.383  1.00 54.35           C  
ATOM   3891  CG  LEU D 120      27.762  26.067  13.550  1.00 56.37           C  
ATOM   3892  CD1 LEU D 120      27.882  27.512  13.088  1.00 61.80           C  
ATOM   3893  CD2 LEU D 120      26.830  25.972  14.761  1.00 58.90           C  
ATOM   3894  N   ILE D 121      25.619  22.600  11.346  1.00 51.38           N  
ATOM   3895  CA  ILE D 121      24.710  21.930  10.375  1.00 51.05           C  
ATOM   3896  C   ILE D 121      23.998  22.882   9.388  1.00 49.47           C  
ATOM   3897  O   ILE D 121      23.133  23.679   9.786  1.00 49.73           O  
ATOM   3898  CB  ILE D 121      23.599  21.108  11.099  1.00 50.81           C  
ATOM   3899  CG1 ILE D 121      24.190  19.993  11.962  1.00 47.71           C  
ATOM   3900  CG2 ILE D 121      22.566  20.522  10.084  1.00 50.70           C  
ATOM   3901  CD1 ILE D 121      23.193  19.465  12.970  1.00 44.37           C  
ATOM   3902  N   THR D 122      24.347  22.789   8.109  1.00 47.70           N  
ATOM   3903  CA  THR D 122      23.652  23.564   7.055  1.00 46.31           C  
ATOM   3904  C   THR D 122      22.479  22.795   6.430  1.00 45.15           C  
ATOM   3905  O   THR D 122      21.463  23.400   6.064  1.00 44.83           O  
ATOM   3906  CB  THR D 122      24.594  23.908   5.928  1.00 45.37           C  
ATOM   3907  OG1 THR D 122      25.175  22.692   5.456  1.00 47.29           O  
ATOM   3908  CG2 THR D 122      25.689  24.861   6.425  1.00 45.71           C  
ATOM   3909  N   ASN D 123      22.642  21.472   6.291  1.00 42.85           N  
ATOM   3910  CA  ASN D 123      21.641  20.614   5.630  1.00 41.32           C  
ATOM   3911  C   ASN D 123      21.472  19.295   6.333  1.00 39.33           C  
ATOM   3912  O   ASN D 123      22.447  18.656   6.736  1.00 38.82           O  
ATOM   3913  CB  ASN D 123      21.986  20.351   4.146  1.00 39.91           C  
ATOM   3914  CG  ASN D 123      22.197  21.637   3.353  1.00 42.50           C  
ATOM   3915  OD1 ASN D 123      21.269  22.151   2.713  1.00 40.34           O  
ATOM   3916  ND2 ASN D 123      23.425  22.168   3.398  1.00 36.40           N  
ATOM   3917  N   MET D 124      20.214  18.900   6.460  1.00 36.69           N  
ATOM   3918  CA  MET D 124      19.854  17.609   6.960  1.00 37.74           C  
ATOM   3919  C   MET D 124      18.776  17.061   6.022  1.00 35.42           C  
ATOM   3920  O   MET D 124      17.720  17.655   5.860  1.00 34.18           O  
ATOM   3921  CB  MET D 124      19.319  17.714   8.384  1.00 38.74           C  
ATOM   3922  CG  MET D 124      19.396  16.412   9.208  1.00 47.21           C  
ATOM   3923  SD  MET D 124      18.558  14.905   8.617  1.00 65.35           S  
ATOM   3924  CE  MET D 124      16.864  15.475   8.549  1.00 62.68           C  
ATOM   3925  N   ARG D 125      19.037  15.908   5.429  1.00 34.50           N  
ATOM   3926  CA  ARG D 125      18.154  15.421   4.344  1.00 33.31           C  
ATOM   3927  C   ARG D 125      17.788  13.977   4.504  1.00 31.45           C  
ATOM   3928  O   ARG D 125      18.647  13.147   4.662  1.00 30.88           O  
ATOM   3929  CB  ARG D 125      18.806  15.675   2.988  1.00 32.06           C  
ATOM   3930  CG  ARG D 125      19.263  17.092   2.826  1.00 28.30           C  
ATOM   3931  CD  ARG D 125      19.674  17.349   1.403  1.00 34.13           C  
ATOM   3932  NE  ARG D 125      18.554  17.851   0.597  1.00 34.11           N  
ATOM   3933  CZ  ARG D 125      18.270  17.414  -0.621  1.00 32.11           C  
ATOM   3934  NH1 ARG D 125      19.007  16.436  -1.144  1.00 23.59           N  
ATOM   3935  NH2 ARG D 125      17.264  17.938  -1.302  1.00 23.03           N  
ATOM   3936  N   GLY D 126      16.496  13.692   4.487  1.00 31.41           N  
ATOM   3937  CA  GLY D 126      15.990  12.329   4.736  1.00 29.94           C  
ATOM   3938  C   GLY D 126      15.329  11.684   3.537  1.00 29.91           C  
ATOM   3939  O   GLY D 126      14.409  12.253   2.921  1.00 30.91           O  
ATOM   3940  N   TYR D 127      15.775  10.482   3.203  1.00 30.18           N  
ATOM   3941  CA  TYR D 127      15.185   9.767   2.099  1.00 31.01           C  
ATOM   3942  C   TYR D 127      14.253   8.739   2.687  1.00 32.94           C  
ATOM   3943  O   TYR D 127      14.613   7.579   2.824  1.00 33.67           O  
ATOM   3944  CB  TYR D 127      16.234   9.084   1.227  1.00 30.55           C  
ATOM   3945  CG  TYR D 127      17.157  10.058   0.545  1.00 32.04           C  
ATOM   3946  CD1 TYR D 127      16.994  10.342  -0.801  1.00 33.25           C  
ATOM   3947  CD2 TYR D 127      18.199  10.693   1.242  1.00 29.23           C  
ATOM   3948  CE1 TYR D 127      17.795  11.219  -1.438  1.00 28.75           C  
ATOM   3949  CE2 TYR D 127      19.023  11.602   0.598  1.00 29.40           C  
ATOM   3950  CZ  TYR D 127      18.809  11.853  -0.763  1.00 30.77           C  
ATOM   3951  OH  TYR D 127      19.588  12.763  -1.471  1.00 31.12           O  
ATOM   3952  N   TRP D 128      13.037   9.187   3.014  1.00 33.60           N  
ATOM   3953  CA  TRP D 128      11.958   8.295   3.352  1.00 33.41           C  
ATOM   3954  C   TRP D 128      10.636   8.945   2.900  1.00 34.41           C  
ATOM   3955  O   TRP D 128      10.598  10.132   2.514  1.00 32.64           O  
ATOM   3956  CB  TRP D 128      11.965   8.010   4.866  1.00 35.23           C  
ATOM   3957  CG  TRP D 128      11.870   9.255   5.760  1.00 34.42           C  
ATOM   3958  CD1 TRP D 128      12.898  10.054   6.172  1.00 36.26           C  
ATOM   3959  CD2 TRP D 128      10.679   9.800   6.348  1.00 35.38           C  
ATOM   3960  NE1 TRP D 128      12.412  11.102   6.957  1.00 38.50           N  
ATOM   3961  CE2 TRP D 128      11.056  10.957   7.085  1.00 35.15           C  
ATOM   3962  CE3 TRP D 128       9.320   9.456   6.282  1.00 39.62           C  
ATOM   3963  CZ2 TRP D 128      10.137  11.731   7.791  1.00 37.47           C  
ATOM   3964  CZ3 TRP D 128       8.388  10.260   6.972  1.00 37.24           C  
ATOM   3965  CH2 TRP D 128       8.809  11.375   7.719  1.00 36.30           C  
ATOM   3966  N   ASN D 129       9.554   8.172   2.944  1.00 35.64           N  
ATOM   3967  CA  ASN D 129       8.204   8.735   2.761  1.00 36.61           C  
ATOM   3968  C   ASN D 129       7.182   8.025   3.643  1.00 38.43           C  
ATOM   3969  O   ASN D 129       7.476   6.961   4.160  1.00 38.03           O  
ATOM   3970  CB  ASN D 129       7.817   8.786   1.264  1.00 35.52           C  
ATOM   3971  CG  ASN D 129       7.868   7.422   0.594  1.00 31.48           C  
ATOM   3972  OD1 ASN D 129       7.435   6.468   1.162  1.00 36.73           O  
ATOM   3973  ND2 ASN D 129       8.424   7.344  -0.591  1.00 28.71           N  
ATOM   3974  N   LEU D 130       5.989   8.610   3.841  1.00 41.54           N  
ATOM   3975  CA  LEU D 130       4.935   7.960   4.686  1.00 42.43           C  
ATOM   3976  C   LEU D 130       4.533   6.556   4.217  1.00 43.38           C  
ATOM   3977  O   LEU D 130       4.070   5.743   5.017  1.00 44.16           O  
ATOM   3978  CB  LEU D 130       3.710   8.848   4.873  1.00 42.35           C  
ATOM   3979  CG  LEU D 130       4.017  10.237   5.470  1.00 43.56           C  
ATOM   3980  CD1 LEU D 130       3.002  11.260   4.961  1.00 48.46           C  
ATOM   3981  CD2 LEU D 130       4.132  10.253   7.005  1.00 43.36           C  
ATOM   3982  N   ASP D 131       4.754   6.252   2.942  1.00 43.51           N  
ATOM   3983  CA  ASP D 131       4.580   4.883   2.438  1.00 44.80           C  
ATOM   3984  C   ASP D 131       5.512   3.815   3.028  1.00 44.39           C  
ATOM   3985  O   ASP D 131       5.185   2.622   3.042  1.00 43.47           O  
ATOM   3986  CB  ASP D 131       4.762   4.882   0.924  1.00 45.39           C  
ATOM   3987  CG  ASP D 131       3.491   5.181   0.188  1.00 48.08           C  
ATOM   3988  OD1 ASP D 131       2.397   5.261   0.809  1.00 46.03           O  
ATOM   3989  OD2 ASP D 131       3.604   5.312  -1.045  1.00 51.74           O  
ATOM   3990  N   MET D 132       6.679   4.247   3.486  1.00 45.66           N  
ATOM   3991  CA  MET D 132       7.697   3.365   4.070  1.00 46.74           C  
ATOM   3992  C   MET D 132       7.517   3.185   5.575  1.00 48.08           C  
ATOM   3993  O   MET D 132       8.202   2.380   6.222  1.00 47.07           O  
ATOM   3994  CB  MET D 132       9.077   3.975   3.817  1.00 46.44           C  
ATOM   3995  CG  MET D 132       9.523   3.874   2.352  1.00 47.27           C  
ATOM   3996  SD  MET D 132      10.701   5.156   1.974  1.00 45.02           S  
ATOM   3997  CE  MET D 132      12.113   4.594   2.962  1.00 44.61           C  
ATOM   3998  N   MET D 133       6.615   3.989   6.121  1.00 49.93           N  
ATOM   3999  CA  MET D 133       6.421   4.093   7.547  1.00 52.48           C  
ATOM   4000  C   MET D 133       5.411   3.035   7.976  1.00 53.11           C  
ATOM   4001  O   MET D 133       4.444   2.729   7.259  1.00 51.55           O  
ATOM   4002  CB  MET D 133       5.965   5.517   7.890  1.00 51.68           C  
ATOM   4003  CG  MET D 133       5.748   5.768   9.354  1.00 55.05           C  
ATOM   4004  SD  MET D 133       5.466   7.503   9.747  1.00 56.28           S  
ATOM   4005  CE  MET D 133       7.123   8.198   9.700  1.00 55.17           C  
ATOM   4006  N   THR D 134       5.683   2.441   9.135  1.00 55.46           N  
ATOM   4007  CA  THR D 134       4.773   1.497   9.776  1.00 57.00           C  
ATOM   4008  C   THR D 134       4.216   2.120  11.054  1.00 58.27           C  
ATOM   4009  O   THR D 134       4.811   3.042  11.637  1.00 58.15           O  
ATOM   4010  CB  THR D 134       5.479   0.195  10.102  1.00 56.90           C  
ATOM   4011  OG1 THR D 134       6.600   0.468  10.955  1.00 61.15           O  
ATOM   4012  CG2 THR D 134       5.971  -0.468   8.810  1.00 56.60           C  
ATOM   4013  N   PHE D 135       3.060   1.630  11.489  1.00 60.01           N  
ATOM   4014  CA  PHE D 135       2.371   2.266  12.612  1.00 60.40           C  
ATOM   4015  C   PHE D 135       2.018   1.314  13.752  1.00 61.22           C  
ATOM   4016  O   PHE D 135       2.348   0.114  13.729  1.00 61.59           O  
ATOM   4017  CB  PHE D 135       1.164   3.070  12.127  1.00 59.80           C  
ATOM   4018  CG  PHE D 135       1.515   4.135  11.127  1.00 57.54           C  
ATOM   4019  CD1 PHE D 135       2.128   5.321  11.539  1.00 56.86           C  
ATOM   4020  CD2 PHE D 135       1.245   3.948   9.779  1.00 56.02           C  
ATOM   4021  CE1 PHE D 135       2.455   6.313  10.611  1.00 58.15           C  
ATOM   4022  CE2 PHE D 135       1.572   4.924   8.830  1.00 54.86           C  
ATOM   4023  CZ  PHE D 135       2.180   6.105   9.232  1.00 59.14           C  
TER    4024      PHE D 135                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
