
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  148 ( 1104),  selected  148 , name 3cnx_C
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 3cnx_C.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_C      M       1           -
LGA    -       -      M       2           -
LGA    P     6_C      T       3          5.213
LGA    D     7_C      H       4          1.369
LGA    T     8_C      Y       5          1.894
LGA    D     9_C      S       6          3.897
LGA    V    10_C      D       7          3.405
LGA    -       -      N       8           -
LGA    -       -      T       9           -
LGA    E    11_C      L      10          5.006
LGA    Q    12_C      K      11          1.589
LGA    V    13_C      V      12          2.753
LGA    G    14_C      A      13          4.546
LGA    L    15_C      H      14          2.835
LGA    A    16_C      Q      15          1.518
LGA    N    17_C      G      16          3.424
LGA    T    18_C      F      17          2.474
LGA    A    19_C      E      18          1.667
LGA    F    20_C      F      19          3.223
LGA    Y    21_C      F      20          2.274
LGA    E    22_C      T      21          1.778
LGA    A    23_C      Q      22          2.506
LGA    X    24_C      G      23          1.782
LGA    E    25_C      L      24          2.408
LGA    R    26_C      A      25          2.997
LGA    -       -      T      26           -
LGA    G    27_C      G      27          1.518
LGA    D    28_C      E      28          1.570
LGA    F    29_C      W      29          1.915
LGA    E    30_C      Q      30          1.458
LGA    T    31_C      K      31          0.997
LGA    L    32_C      F      32          1.989
LGA    S    33_C      L      33          1.534
LGA    S    34_C      D      34          0.954
LGA    L    35_C      M      35          1.941
LGA    W    36_C      L      36          1.182
LGA    L    37_C      T      37          1.451
LGA    T    38_C      E      38          2.474
LGA    P    39_C      -       -           -
LGA    A    40_C      -       -           -
LGA    D    41_C      -       -           -
LGA    L    42_C      -       -           -
LGA    G    43_C      -       -           -
LGA    V    44_C      -       -           -
LGA    D    45_C      -       -           -
LGA    P    51_C      -       -           -
LGA    A    52_C      -       -           -
LGA    D    53_C      -       -           -
LGA    A    54_C      -       -           -
LGA    G    55_C      -       -           -
LGA    V    56_C      D      39          1.174
LGA    V    57_C      F      40          1.153
LGA    S    58_C      T      41          0.718
LGA    C    59_C      F      42          0.913
LGA    V    60_C      W      43          1.746
LGA    H    61_C      F      44          2.691
LGA    P    62_C      P      45          3.822
LGA    G    63_C      M      46          2.681
LGA    W    64_C      G      47          4.829
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    -       -      H      50           -
LGA    P    65_C      G      51          1.954
LGA    V    66_C      L      52          1.608
LGA    L    67_C      N      53          0.894
LGA    S    68_C      V      54          0.946
LGA    G    69_C      G      55          1.426
LGA    R    70_C      K      56          1.493
LGA    G    71_C      E      57          1.658
LGA    E    72_C      R      58          1.409
LGA    V    73_C      A      59          1.606
LGA    L    74_C      K      60          1.661
LGA    R    75_C      E      61          1.404
LGA    S    76_C      F      62          1.075
LGA    Y    77_C      F      63          1.049
LGA    A    78_C      T      64          1.753
LGA    L    79_C      Y      65          1.942
LGA    I    80_C      V      66          1.710
LGA    X    81_C      S      67          1.827
LGA    A    82_C      E      68          2.238
LGA    N    83_C      S      69          2.639
LGA    T    84_C      F      70          2.117
LGA    E    85_C      H      71          2.113
LGA    Y    86_C      T      72          3.756
LGA    -       -      G      73           -
LGA    I    87_C      I      74          0.397
LGA    Q    88_C      Q      75          1.441
LGA    F    89_C      I      76          2.264
LGA    -       -      S      77           -
LGA    F    90_C      S      78          2.879
LGA    L    91_C      L      79          2.292
LGA    T    92_C      D      80          1.680
LGA    D    93_C      R      81          1.210
LGA    V    94_C      V      82          0.675
LGA    H    95_C      T      83          0.701
LGA    V    96_C      S      84          2.088
LGA    S    97_C      N      85          1.828
LGA    V    98_C      E      86          2.580
LGA    T    99_C      -       -           -
LGA    G   100_C      -       -           -
LGA    D   101_C      -       -           -
LGA    T   102_C      -       -           -
LGA    A   103_C      T      87          2.348
LGA    L   104_C      T      88          0.410
LGA    V   105_C      V      89          0.411
LGA    T   106_C      V      90          1.280
LGA    C   107_C      F      91          2.226
LGA    T   108_C      E      92          1.312
LGA    E   109_C      F      93          2.912
LGA    N   110_C      R      94          1.490
LGA    I   111_C      D      95          2.100
LGA    L   112_C      E      96          1.027
LGA    S   113_C      G      97          1.954
LGA    G   114_C      L      98          0.970
LGA    G   115_C      F      99          2.640
LGA    P   116_C      L     100          3.845
LGA    P   117_C      -       -           -
LGA    P   118_C      -       -           -
LGA    D   119_C      -       -           -
LGA    D   120_C      -       -           -
LGA    S   121_C      -       -           -
LGA    D   122_C      -       -           -
LGA    E   123_C      -       -           -
LGA    L   124_C      G     101          4.896
LGA    G   125_C      K     102          3.908
LGA    P   126_C      -       -           -
LGA    L   127_C      P     103          1.988
LGA    V   128_C      Y     104          1.885
LGA    G   129_C      K     105          1.152
LGA    Q   130_C      N     106          1.372
LGA    L   131_C      R     107          1.731
LGA    V   132_C      V     108          2.017
LGA    V   133_C      A     109          1.827
LGA    A   134_C      V     110          2.166
LGA    T   135_C      S     111          1.695
LGA    N   136_C      F     112          1.102
LGA    V   137_C      D     113          0.784
LGA    F   138_C      V     114          1.433
LGA    R   139_C      R     115          1.279
LGA    R   140_C      G     116          0.936
LGA    T   141_C      D     117          3.010
LGA    P   142_C      -       -           -
LGA    D   143_C      -       -           -
LGA    G   144_C      -       -           -
LGA    W   145_C      -       -           -
LGA    K   146_C      K     118          1.666
LGA    L   147_C      I     119          1.608
LGA    W   148_C      C     120          0.782
LGA    S   149_C      S     121          0.814
LGA    H   150_C      Y     122          0.789
LGA    H   151_C      R     123          0.456
LGA    A   152_C      E     124          0.588
LGA    S   153_C      Y     125          1.386
LGA    P   154_C      F     126          1.565
LGA    V   155_C      G     127          2.830
LGA    L   156_C      S     128           #
LGA    A   157_C      D     129           -
LGA    -       -      G     130           -
LGA    -       -      K     131           -
LGA    -       -      S     132           -
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  148  133    5.0    117    2.18    11.97     72.000     5.130

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.471126 * X  +  -0.040565 * Y  +  -0.881133 * Z  +  73.287315
  Y_new =   0.871294 * X  +   0.134235 * Y  +  -0.472046 * Z  + -80.981293
  Z_new =   0.137428 * X  +  -0.990119 * Y  +  -0.027898 * Z  +  50.473965 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.598966    1.542627  [ DEG:   -91.6140     88.3860 ]
  Theta =  -0.137864   -3.003729  [ DEG:    -7.8990   -172.1010 ]
  Phi   =   2.066487   -1.075106  [ DEG:   118.4010    -61.5990 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cnx_C                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cnx_C.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  148  133   5.0  117   2.18   11.97  72.000
REMARK  ---------------------------------------------------------- 
MOLECULE 3cnx_C
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   26-MAR-08   3CNX              
TITLE     CRYSTAL STRUCTURE OF NTF2-LIKE PROTEIN OF UNKNOWN FUNCTION            
TITLE    2 (NP_825848.1) FROM STREPTOMYCES AVERMITILIS AT 2.10 A                
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES AVERMITILIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: DSM 46492 / JCM 5070 / NCIMB 12804 / NRRL 8165;              
SOURCE   5 ATCC: 31267;                                                         
SOURCE   6 GENE: NP_825848.1, SAV4671;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_825848.1, NTF2-LIKE PROTEIN OF UNKNOWN FUNCTION,                   
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2, STRUCTURAL                
KEYWDS   4 GENOMICS, UNKNOWN FUNCTION                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   08-APR-08 3CNX    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF NTF2-LIKE PROTEIN OF UNKNOWN            
JRNL        TITL 2 FUNCTION (NP_825848.1) FROM STREPTOMYCES                     
JRNL        TITL 3 AVERMITILIS AT 2.10 A RESOLUTION                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  3CNX A    1   169  UNP    Q82EE4   Q82EE4_STRAW     1    169             
DBREF  3CNX B    1   169  UNP    Q82EE4   Q82EE4_STRAW     1    169             
DBREF  3CNX C    1   169  UNP    Q82EE4   Q82EE4_STRAW     1    169             
SEQRES   1 A  170  GLY MSE SER THR PRO THR PRO ASP THR ASP VAL GLU GLN          
SEQRES   2 A  170  VAL GLY LEU ALA ASN THR ALA PHE TYR GLU ALA MSE GLU          
SEQRES   3 A  170  ARG GLY ASP PHE GLU THR LEU SER SER LEU TRP LEU THR          
SEQRES   4 A  170  PRO ALA ASP LEU GLY VAL ASP GLU GLU TYR HIS ASP PRO          
SEQRES   5 A  170  ALA ASP ALA GLY VAL VAL SER CYS VAL HIS PRO GLY TRP          
SEQRES   6 A  170  PRO VAL LEU SER GLY ARG GLY GLU VAL LEU ARG SER TYR          
SEQRES   7 A  170  ALA LEU ILE MSE ALA ASN THR GLU TYR ILE GLN PHE PHE          
SEQRES   8 A  170  LEU THR ASP VAL HIS VAL SER VAL THR GLY ASP THR ALA          
SEQRES   9 A  170  LEU VAL THR CYS THR GLU ASN ILE LEU SER GLY GLY PRO          
SEQRES  10 A  170  PRO PRO ASP ASP SER ASP GLU LEU GLY PRO LEU VAL GLY          
SEQRES  11 A  170  GLN LEU VAL VAL ALA THR ASN VAL PHE ARG ARG THR PRO          
SEQRES  12 A  170  ASP GLY TRP LYS LEU TRP SER HIS HIS ALA SER PRO VAL          
SEQRES  13 A  170  LEU ALA GLU THR GLY ALA GLU GLU GLY ASP GLU SER PRO          
SEQRES  14 A  170  ASP                                                          
SEQRES   1 B  170  GLY MSE SER THR PRO THR PRO ASP THR ASP VAL GLU GLN          
SEQRES   2 B  170  VAL GLY LEU ALA ASN THR ALA PHE TYR GLU ALA MSE GLU          
SEQRES   3 B  170  ARG GLY ASP PHE GLU THR LEU SER SER LEU TRP LEU THR          
SEQRES   4 B  170  PRO ALA ASP LEU GLY VAL ASP GLU GLU TYR HIS ASP PRO          
SEQRES   5 B  170  ALA ASP ALA GLY VAL VAL SER CYS VAL HIS PRO GLY TRP          
SEQRES   6 B  170  PRO VAL LEU SER GLY ARG GLY GLU VAL LEU ARG SER TYR          
SEQRES   7 B  170  ALA LEU ILE MSE ALA ASN THR GLU TYR ILE GLN PHE PHE          
SEQRES   8 B  170  LEU THR ASP VAL HIS VAL SER VAL THR GLY ASP THR ALA          
SEQRES   9 B  170  LEU VAL THR CYS THR GLU ASN ILE LEU SER GLY GLY PRO          
SEQRES  10 B  170  PRO PRO ASP ASP SER ASP GLU LEU GLY PRO LEU VAL GLY          
SEQRES  11 B  170  GLN LEU VAL VAL ALA THR ASN VAL PHE ARG ARG THR PRO          
SEQRES  12 B  170  ASP GLY TRP LYS LEU TRP SER HIS HIS ALA SER PRO VAL          
SEQRES  13 B  170  LEU ALA GLU THR GLY ALA GLU GLU GLY ASP GLU SER PRO          
SEQRES  14 B  170  ASP                                                          
SEQRES   1 C  170  GLY MSE SER THR PRO THR PRO ASP THR ASP VAL GLU GLN          
SEQRES   2 C  170  VAL GLY LEU ALA ASN THR ALA PHE TYR GLU ALA MSE GLU          
SEQRES   3 C  170  ARG GLY ASP PHE GLU THR LEU SER SER LEU TRP LEU THR          
SEQRES   4 C  170  PRO ALA ASP LEU GLY VAL ASP GLU GLU TYR HIS ASP PRO          
SEQRES   5 C  170  ALA ASP ALA GLY VAL VAL SER CYS VAL HIS PRO GLY TRP          
SEQRES   6 C  170  PRO VAL LEU SER GLY ARG GLY GLU VAL LEU ARG SER TYR          
SEQRES   7 C  170  ALA LEU ILE MSE ALA ASN THR GLU TYR ILE GLN PHE PHE          
SEQRES   8 C  170  LEU THR ASP VAL HIS VAL SER VAL THR GLY ASP THR ALA          
SEQRES   9 C  170  LEU VAL THR CYS THR GLU ASN ILE LEU SER GLY GLY PRO          
SEQRES  10 C  170  PRO PRO ASP ASP SER ASP GLU LEU GLY PRO LEU VAL GLY          
SEQRES  11 C  170  GLN LEU VAL VAL ALA THR ASN VAL PHE ARG ARG THR PRO          
SEQRES  12 C  170  ASP GLY TRP LYS LEU TRP SER HIS HIS ALA SER PRO VAL          
SEQRES  13 C  170  LEU ALA GLU THR GLY ALA GLU GLU GLY ASP GLU SER PRO          
SEQRES  14 C  170  ASP                                                          
HET    MSE  A  24      13                                                       
HET    MSE  A  81       8                                                       
HET    MSE  B  24      13                                                       
HET    MSE  B  81       8                                                       
HET    MSE  C  24      13                                                       
HET    MSE  C  81       8                                                       
HET     CL  A 170       1                                                       
HET     MG  B 170       1                                                       
HET     CL  B 171       1                                                       
HET     MG  C 170       1                                                       
HET     CL  C 171       1                                                       
HET    UNL  A 201       3                                                       
HET    PGE  A 202      10                                                       
HET    UNL  B 201       3                                                       
HET    PG6  B 202      18                                                       
HET    UNL  C 201       3                                                       
HET    PEG  A 203       7                                                       
HET    PEG  A 204       7                                                       
HET    GOL  B 203       6                                                       
HET    GOL  B 204       6                                                       
HET    PEG  B 205       7                                                       
HET    GOL  C 202       6                                                       
HET    PEG  C 203       7                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     PGE TRIETHYLENE GLYCOL                                               
HETNAM     PG6 1-(2-METHOXY-ETHOXY)-2-{2-[2-(2-METHOXY-ETHOXY]-                 
HETNAM   2 PG6  ETHOXY}-ETHANE                                                  
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   4   CL    3(CL 1-)                                                     
FORMUL   5   MG    2(MG 2+)                                                     
FORMUL  10  PGE    C6 H14 O4                                                    
FORMUL  12  PG6    C12 H26 O6                                                   
FORMUL  14  PEG    4(C4 H10 O3)                                                 
FORMUL  16  GOL    3(C3 H8 O3)                                                  
FORMUL  21  HOH   *95(H2 O)                                                     
CRYST1  103.000  128.750   44.380  90.00  90.00  90.00 P 21 21 2    12          
ATOM   2143  N   THR C   5      43.497  16.148  10.173  1.00 64.90           N  
ATOM   2144  CA  THR C   5      43.565  14.717   9.731  1.00 64.81           C  
ATOM   2145  C   THR C   5      42.206  14.291   9.183  1.00 63.88           C  
ATOM   2146  O   THR C   5      41.162  14.653   9.746  1.00 64.03           O  
ATOM   2147  CB  THR C   5      43.935  13.742  10.885  1.00 65.10           C  
ATOM   2148  OG1 THR C   5      45.130  14.196  11.531  1.00 67.78           O  
ATOM   2149  CG2 THR C   5      44.152  12.294  10.362  1.00 64.92           C  
ATOM   2150  N   PRO C   6      42.214  13.523   8.081  1.00 62.04           N  
ATOM   2151  CA  PRO C   6      40.988  12.938   7.539  1.00 60.96           C  
ATOM   2152  C   PRO C   6      40.336  12.024   8.561  1.00 58.79           C  
ATOM   2153  O   PRO C   6      39.151  12.072   8.772  1.00 58.47           O  
ATOM   2154  CB  PRO C   6      41.502  12.117   6.349  1.00 61.17           C  
ATOM   2155  CG  PRO C   6      42.717  12.854   5.889  1.00 61.48           C  
ATOM   2156  CD  PRO C   6      43.363  13.333   7.174  1.00 62.21           C  
ATOM   2157  N   ASP C   7      41.154  11.184   9.167  1.00 56.93           N  
ATOM   2158  CA  ASP C   7      40.674  10.240  10.178  1.00 54.93           C  
ATOM   2159  C   ASP C   7      40.014  11.005  11.319  1.00 53.04           C  
ATOM   2160  O   ASP C   7      38.964  10.607  11.829  1.00 52.99           O  
ATOM   2161  CB  ASP C   7      41.806   9.341  10.687  1.00 55.07           C  
ATOM   2162  N   THR C   8      40.600  12.145  11.659  1.00 50.47           N  
ATOM   2163  CA  THR C   8      40.101  12.971  12.762  1.00 48.41           C  
ATOM   2164  C   THR C   8      38.829  13.686  12.341  1.00 46.44           C  
ATOM   2165  O   THR C   8      37.867  13.739  13.078  1.00 46.41           O  
ATOM   2166  CB  THR C   8      41.106  14.043  13.220  1.00 48.45           C  
ATOM   2167  OG1 THR C   8      42.181  13.422  13.951  1.00 49.68           O  
ATOM   2168  CG2 THR C   8      40.418  15.063  14.123  1.00 47.82           C  
ATOM   2169  N   ASP C   9      38.865  14.245  11.142  1.00 44.26           N  
ATOM   2170  CA  ASP C   9      37.713  14.937  10.562  1.00 43.07           C  
ATOM   2171  C   ASP C   9      36.493  14.004  10.512  1.00 41.65           C  
ATOM   2172  O   ASP C   9      35.400  14.347  10.918  1.00 39.97           O  
ATOM   2173  CB  ASP C   9      38.008  15.436   9.145  1.00 42.99           C  
ATOM   2174  CG  ASP C   9      38.706  16.756   9.123  1.00 42.45           C  
ATOM   2175  OD1 ASP C   9      38.771  17.430  10.174  1.00 41.29           O  
ATOM   2176  OD2 ASP C   9      39.175  17.133   8.030  1.00 43.54           O  
ATOM   2177  N   VAL C  10      36.724  12.810   9.997  1.00 41.07           N  
ATOM   2178  CA  VAL C  10      35.669  11.809   9.904  1.00 40.55           C  
ATOM   2179  C   VAL C  10      35.094  11.525  11.297  1.00 40.63           C  
ATOM   2180  O   VAL C  10      33.888  11.461  11.459  1.00 40.25           O  
ATOM   2181  CB  VAL C  10      36.140  10.504   9.229  1.00 41.09           C  
ATOM   2182  CG1 VAL C  10      35.181   9.350   9.602  1.00 40.19           C  
ATOM   2183  CG2 VAL C  10      36.234  10.711   7.711  1.00 38.81           C  
ATOM   2184  N   GLU C  11      35.961  11.419  12.303  1.00 40.22           N  
ATOM   2185  CA  GLU C  11      35.518  11.123  13.678  1.00 40.20           C  
ATOM   2186  C   GLU C  11      34.724  12.297  14.254  1.00 40.25           C  
ATOM   2187  O   GLU C  11      33.696  12.112  14.912  1.00 40.78           O  
ATOM   2188  CB  GLU C  11      36.694  10.759  14.604  1.00 40.06           C  
ATOM   2189  N   GLN C  12      35.184  13.508  13.975  1.00 40.03           N  
ATOM   2190  CA  GLN C  12      34.548  14.708  14.543  1.00 39.89           C  
ATOM   2191  C   GLN C  12      33.179  14.981  13.899  1.00 38.88           C  
ATOM   2192  O   GLN C  12      32.247  15.419  14.551  1.00 38.72           O  
ATOM   2193  CB  GLN C  12      35.456  15.928  14.422  1.00 40.61           C  
ATOM   2194  CG  GLN C  12      36.769  15.823  15.249  1.00 42.19           C  
ATOM   2195  CD  GLN C  12      36.541  15.392  16.702  1.00 46.01           C  
ATOM   2196  OE1 GLN C  12      35.517  15.708  17.305  1.00 48.93           O  
ATOM   2197  NE2 GLN C  12      37.517  14.674  17.275  1.00 50.24           N  
ATOM   2198  N   VAL C  13      33.077  14.712  12.607  1.00 37.98           N  
ATOM   2199  CA  VAL C  13      31.789  14.816  11.887  1.00 37.14           C  
ATOM   2200  C   VAL C  13      30.833  13.766  12.416  1.00 37.40           C  
ATOM   2201  O   VAL C  13      29.664  14.015  12.588  1.00 38.39           O  
ATOM   2202  CB  VAL C  13      31.968  14.656  10.366  1.00 37.30           C  
ATOM   2203  CG1 VAL C  13      30.619  14.508   9.681  1.00 37.01           C  
ATOM   2204  CG2 VAL C  13      32.759  15.837   9.810  1.00 35.13           C  
ATOM   2205  N   GLY C  14      31.348  12.587  12.717  1.00 37.08           N  
ATOM   2206  CA  GLY C  14      30.517  11.490  13.213  1.00 37.38           C  
ATOM   2207  C   GLY C  14      29.915  11.818  14.571  1.00 37.15           C  
ATOM   2208  O   GLY C  14      28.790  11.449  14.885  1.00 37.07           O  
ATOM   2209  N   LEU C  15      30.677  12.562  15.346  1.00 37.57           N  
ATOM   2210  CA  LEU C  15      30.320  12.880  16.728  1.00 38.51           C  
ATOM   2211  C   LEU C  15      29.225  13.909  16.648  1.00 38.47           C  
ATOM   2212  O   LEU C  15      28.215  13.804  17.336  1.00 39.60           O  
ATOM   2213  CB  LEU C  15      31.528  13.402  17.541  1.00 38.66           C  
ATOM   2214  CG  LEU C  15      32.541  12.335  17.956  1.00 39.86           C  
ATOM   2215  CD1 LEU C  15      33.888  12.955  18.469  1.00 39.17           C  
ATOM   2216  CD2 LEU C  15      31.927  11.415  18.993  1.00 39.53           C  
ATOM   2217  N   ALA C  16      29.384  14.848  15.718  1.00 37.99           N  
ATOM   2218  CA  ALA C  16      28.403  15.931  15.528  1.00 37.07           C  
ATOM   2219  C   ALA C  16      27.092  15.355  15.006  1.00 37.48           C  
ATOM   2220  O   ALA C  16      26.006  15.746  15.433  1.00 36.30           O  
ATOM   2221  CB  ALA C  16      28.956  17.045  14.560  1.00 36.00           C  
ATOM   2222  N   ASN C  17      27.205  14.403  14.090  1.00 37.71           N  
ATOM   2223  CA  ASN C  17      26.033  13.777  13.483  1.00 37.94           C  
ATOM   2224  C   ASN C  17      25.229  13.084  14.574  1.00 39.13           C  
ATOM   2225  O   ASN C  17      24.004  13.167  14.676  1.00 40.05           O  
ATOM   2226  CB  ASN C  17      26.462  12.730  12.459  1.00 38.15           C  
ATOM   2227  CG  ASN C  17      25.288  12.203  11.600  1.00 37.49           C  
ATOM   2228  OD1 ASN C  17      24.632  12.975  10.894  1.00 35.59           O  
ATOM   2229  ND2 ASN C  17      25.053  10.879  11.637  1.00 34.72           N  
ATOM   2230  N   THR C  18      25.988  12.379  15.384  1.00 38.97           N  
ATOM   2231  CA  THR C  18      25.467  11.641  16.527  1.00 39.96           C  
ATOM   2232  C   THR C  18      24.764  12.465  17.561  1.00 39.05           C  
ATOM   2233  O   THR C  18      23.756  12.039  18.102  1.00 38.92           O  
ATOM   2234  CB  THR C  18      26.612  10.913  17.268  1.00 40.23           C  
ATOM   2235  OG1 THR C  18      26.994   9.817  16.445  1.00 41.04           O  
ATOM   2236  CG2 THR C  18      26.160  10.411  18.612  1.00 39.74           C  
ATOM   2237  N   ALA C  19      25.301  13.655  17.772  1.00 38.88           N  
ATOM   2238  CA  ALA C  19      24.830  14.581  18.799  1.00 38.97           C  
ATOM   2239  C   ALA C  19      23.542  15.215  18.364  1.00 39.19           C  
ATOM   2240  O   ALA C  19      22.674  15.629  19.154  1.00 39.11           O  
ATOM   2241  CB  ALA C  19      25.907  15.666  19.045  1.00 39.40           C  
ATOM   2242  N   PHE C  20      23.418  15.282  17.054  1.00 39.93           N  
ATOM   2243  CA  PHE C  20      22.228  15.854  16.390  1.00 39.68           C  
ATOM   2244  C   PHE C  20      21.012  15.002  16.771  1.00 39.68           C  
ATOM   2245  O   PHE C  20      20.036  15.444  17.373  1.00 39.42           O  
ATOM   2246  CB  PHE C  20      22.474  15.847  14.865  1.00 40.22           C  
ATOM   2247  CG  PHE C  20      21.261  16.123  14.022  1.00 41.00           C  
ATOM   2248  CD1 PHE C  20      20.379  17.118  14.347  1.00 41.86           C  
ATOM   2249  CD2 PHE C  20      21.043  15.400  12.864  1.00 41.72           C  
ATOM   2250  CE1 PHE C  20      19.265  17.357  13.570  1.00 41.01           C  
ATOM   2251  CE2 PHE C  20      19.943  15.645  12.087  1.00 41.52           C  
ATOM   2252  CZ  PHE C  20      19.058  16.638  12.451  1.00 42.45           C  
ATOM   2253  N   TYR C  21      21.107  13.754  16.396  1.00 39.77           N  
ATOM   2254  CA  TYR C  21      20.076  12.757  16.704  1.00 40.42           C  
ATOM   2255  C   TYR C  21      19.789  12.591  18.185  1.00 41.14           C  
ATOM   2256  O   TYR C  21      18.641  12.548  18.582  1.00 41.73           O  
ATOM   2257  CB  TYR C  21      20.417  11.418  16.067  1.00 39.86           C  
ATOM   2258  CG  TYR C  21      20.306  11.538  14.572  1.00 39.73           C  
ATOM   2259  CD1 TYR C  21      19.066  11.636  13.947  1.00 39.60           C  
ATOM   2260  CD2 TYR C  21      21.426  11.674  13.790  1.00 39.05           C  
ATOM   2261  CE1 TYR C  21      18.973  11.783  12.569  1.00 40.37           C  
ATOM   2262  CE2 TYR C  21      21.324  11.836  12.419  1.00 36.83           C  
ATOM   2263  CZ  TYR C  21      20.145  11.864  11.821  1.00 35.60           C  
ATOM   2264  OH  TYR C  21      20.111  11.990  10.462  1.00 38.80           O  
ATOM   2265  N   GLU C  22      20.838  12.543  18.999  1.00 41.59           N  
ATOM   2266  CA  GLU C  22      20.683  12.381  20.447  1.00 42.39           C  
ATOM   2267  C   GLU C  22      19.966  13.559  21.064  1.00 41.72           C  
ATOM   2268  O   GLU C  22      19.189  13.403  21.975  1.00 41.01           O  
ATOM   2269  CB  GLU C  22      22.037  12.224  21.153  1.00 42.89           C  
ATOM   2270  CG  GLU C  22      22.755  10.904  20.883  1.00 46.06           C  
ATOM   2271  CD  GLU C  22      24.004  10.753  21.735  1.00 50.34           C  
ATOM   2272  OE1 GLU C  22      24.483  11.762  22.327  1.00 53.13           O  
ATOM   2273  OE2 GLU C  22      24.503   9.619  21.830  1.00 54.30           O  
ATOM   2274  N   ALA C  23      20.242  14.744  20.550  1.00 41.85           N  
ATOM   2275  CA  ALA C  23      19.606  15.965  21.057  1.00 41.84           C  
ATOM   2276  C   ALA C  23      18.088  15.870  20.832  1.00 42.88           C  
ATOM   2277  O   ALA C  23      17.256  16.318  21.645  1.00 41.86           O  
ATOM   2278  CB  ALA C  23      20.151  17.170  20.346  1.00 41.66           C  
HETATM 2279  N   MSE C  24      17.779  15.269  19.697  1.00 42.35           N  
HETATM 2280  CA  MSE C  24      16.401  15.056  19.301  0.50 43.24           C  
HETATM 2282  C   MSE C  24      15.754  13.993  20.164  1.00 43.92           C  
HETATM 2283  O   MSE C  24      14.637  14.160  20.615  1.00 45.22           O  
HETATM 2284  CB  MSE C  24      16.297  14.659  17.830  0.50 42.92           C  
HETATM 2286  CG  MSE C  24      16.416  15.829  16.909  0.50 43.25           C  
HETATM 2288 SE   MSE C  24      15.726  15.273  15.223  0.38 41.65          SE  
HETATM 2290  CE  MSE C  24      17.230  14.245  14.571  0.50 37.24           C  
ATOM   2292  N   GLU C  25      16.473  12.915  20.408  1.00 43.50           N  
ATOM   2293  CA  GLU C  25      15.960  11.852  21.254  1.00 43.23           C  
ATOM   2294  C   GLU C  25      15.581  12.352  22.627  1.00 43.94           C  
ATOM   2295  O   GLU C  25      14.606  11.876  23.233  1.00 43.86           O  
ATOM   2296  CB  GLU C  25      16.972  10.741  21.402  1.00 42.56           C  
ATOM   2297  CG  GLU C  25      17.049   9.891  20.166  1.00 41.70           C  
ATOM   2298  CD  GLU C  25      18.228   8.980  20.172  1.00 41.41           C  
ATOM   2299  OE1 GLU C  25      19.072   9.155  21.055  1.00 42.59           O  
ATOM   2300  OE2 GLU C  25      18.325   8.077  19.308  1.00 38.33           O  
ATOM   2301  N   ARG C  26      16.344  13.299  23.141  1.00 43.91           N  
ATOM   2302  CA  ARG C  26      16.138  13.677  24.515  1.00 44.63           C  
ATOM   2303  C   ARG C  26      15.419  14.989  24.602  1.00 44.16           C  
ATOM   2304  O   ARG C  26      15.191  15.516  25.667  1.00 45.37           O  
ATOM   2305  CB  ARG C  26      17.433  13.608  25.344  1.00 45.45           C  
ATOM   2306  CG  ARG C  26      18.485  14.470  24.939  1.00 47.24           C  
ATOM   2307  CD  ARG C  26      19.687  14.415  25.871  1.00 49.97           C  
ATOM   2308  NE  ARG C  26      20.447  15.605  25.477  1.00 53.32           N  
ATOM   2309  CZ  ARG C  26      21.353  15.641  24.506  1.00 54.19           C  
ATOM   2310  NH1 ARG C  26      21.714  14.524  23.904  1.00 56.05           N  
ATOM   2311  NH2 ARG C  26      21.923  16.790  24.173  1.00 53.73           N  
ATOM   2312  N   GLY C  27      14.999  15.466  23.447  1.00 43.73           N  
ATOM   2313  CA  GLY C  27      14.176  16.654  23.359  1.00 42.91           C  
ATOM   2314  C   GLY C  27      14.944  17.890  23.763  1.00 42.71           C  
ATOM   2315  O   GLY C  27      14.396  18.837  24.310  1.00 43.00           O  
ATOM   2316  N   ASP C  28      16.231  17.882  23.460  1.00 41.26           N  
ATOM   2317  CA  ASP C  28      17.117  18.961  23.894  1.00 40.71           C  
ATOM   2318  C   ASP C  28      17.212  20.037  22.817  1.00 39.63           C  
ATOM   2319  O   ASP C  28      18.066  19.993  21.929  1.00 39.22           O  
ATOM   2320  CB  ASP C  28      18.475  18.368  24.271  1.00 40.66           C  
ATOM   2321  CG  ASP C  28      19.410  19.385  24.758  1.00 41.37           C  
ATOM   2322  OD1 ASP C  28      18.979  20.556  24.820  1.00 44.90           O  
ATOM   2323  OD2 ASP C  28      20.569  19.028  25.049  1.00 39.53           O  
ATOM   2324  N   PHE C  29      16.264  20.969  22.879  1.00 38.77           N  
ATOM   2325  CA  PHE C  29      16.136  21.991  21.855  1.00 38.46           C  
ATOM   2326  C   PHE C  29      17.384  22.853  21.851  1.00 38.70           C  
ATOM   2327  O   PHE C  29      17.890  23.187  20.800  1.00 39.18           O  
ATOM   2328  CB  PHE C  29      14.863  22.835  21.995  1.00 38.89           C  
ATOM   2329  CG  PHE C  29      14.676  23.858  20.886  1.00 38.13           C  
ATOM   2330  CD1 PHE C  29      14.187  23.487  19.660  1.00 40.52           C  
ATOM   2331  CD2 PHE C  29      14.964  25.189  21.099  1.00 37.46           C  
ATOM   2332  CE1 PHE C  29      14.033  24.426  18.652  1.00 39.84           C  
ATOM   2333  CE2 PHE C  29      14.809  26.114  20.119  1.00 36.95           C  
ATOM   2334  CZ  PHE C  29      14.343  25.733  18.885  1.00 38.90           C  
ATOM   2335  N   GLU C  30      17.927  23.170  23.019  1.00 39.08           N  
ATOM   2336  CA  GLU C  30      19.077  24.098  23.071  1.00 39.02           C  
ATOM   2337  C   GLU C  30      20.293  23.536  22.316  1.00 38.97           C  
ATOM   2338  O   GLU C  30      20.944  24.242  21.564  1.00 38.50           O  
ATOM   2339  CB  GLU C  30      19.480  24.459  24.490  1.00 39.03           C  
ATOM   2340  CG  GLU C  30      20.636  25.487  24.557  1.00 40.73           C  
ATOM   2341  N   THR C  31      20.579  22.263  22.550  1.00 38.66           N  
ATOM   2342  CA  THR C  31      21.758  21.621  21.981  1.00 39.09           C  
ATOM   2343  C   THR C  31      21.535  21.487  20.487  1.00 39.02           C  
ATOM   2344  O   THR C  31      22.422  21.712  19.643  1.00 38.38           O  
ATOM   2345  CB  THR C  31      22.004  20.214  22.591  1.00 38.61           C  
ATOM   2346  OG1 THR C  31      22.327  20.334  23.978  1.00 38.99           O  
ATOM   2347  CG2 THR C  31      23.112  19.540  21.892  1.00 38.12           C  
ATOM   2348  N   LEU C  32      20.308  21.126  20.172  1.00 39.57           N  
ATOM   2349  CA  LEU C  32      19.931  20.951  18.780  1.00 39.33           C  
ATOM   2350  C   LEU C  32      20.126  22.242  18.041  1.00 39.80           C  
ATOM   2351  O   LEU C  32      20.661  22.281  16.919  1.00 38.03           O  
ATOM   2352  CB  LEU C  32      18.492  20.508  18.637  1.00 39.78           C  
ATOM   2353  CG  LEU C  32      18.122  20.377  17.143  1.00 41.61           C  
ATOM   2354  CD1 LEU C  32      17.943  18.916  16.711  1.00 44.81           C  
ATOM   2355  CD2 LEU C  32      16.930  21.254  16.872  1.00 41.02           C  
ATOM   2356  N   SER C  33      19.673  23.308  18.674  1.00 39.75           N  
ATOM   2357  CA  SER C  33      19.775  24.645  18.088  1.00 40.71           C  
ATOM   2358  C   SER C  33      21.209  25.055  17.848  1.00 40.32           C  
ATOM   2359  O   SER C  33      21.506  25.742  16.882  1.00 40.27           O  
ATOM   2360  CB  SER C  33      19.155  25.700  19.012  1.00 41.25           C  
ATOM   2361  OG  SER C  33      17.744  25.591  18.926  1.00 45.73           O  
ATOM   2362  N   SER C  34      22.067  24.663  18.782  1.00 39.52           N  
ATOM   2363  CA  SER C  34      23.477  25.046  18.763  1.00 39.94           C  
ATOM   2364  C   SER C  34      24.234  24.311  17.695  1.00 39.02           C  
ATOM   2365  O   SER C  34      25.340  24.684  17.360  1.00 39.86           O  
ATOM   2366  CB  SER C  34      24.143  24.748  20.104  1.00 40.12           C  
ATOM   2367  OG  SER C  34      24.270  23.333  20.239  1.00 41.73           O  
ATOM   2368  N   LEU C  35      23.605  23.285  17.143  1.00 39.32           N  
ATOM   2369  CA  LEU C  35      24.240  22.389  16.176  1.00 39.14           C  
ATOM   2370  C   LEU C  35      24.034  22.872  14.744  1.00 40.31           C  
ATOM   2371  O   LEU C  35      24.692  22.404  13.817  1.00 40.46           O  
ATOM   2372  CB  LEU C  35      23.721  20.960  16.319  1.00 39.01           C  
ATOM   2373  CG  LEU C  35      24.333  20.129  17.463  1.00 39.93           C  
ATOM   2374  CD1 LEU C  35      23.655  18.768  17.587  1.00 40.09           C  
ATOM   2375  CD2 LEU C  35      25.849  19.960  17.297  1.00 39.76           C  
ATOM   2376  N   TRP C  36      23.104  23.800  14.576  1.00 40.68           N  
ATOM   2377  CA  TRP C  36      22.798  24.356  13.253  1.00 40.93           C  
ATOM   2378  C   TRP C  36      23.643  25.571  13.002  1.00 41.46           C  
ATOM   2379  O   TRP C  36      23.715  26.470  13.809  1.00 41.48           O  
ATOM   2380  CB  TRP C  36      21.316  24.723  13.093  1.00 40.69           C  
ATOM   2381  CG  TRP C  36      20.492  23.554  12.831  1.00 40.32           C  
ATOM   2382  CD1 TRP C  36      19.887  22.744  13.752  1.00 38.13           C  
ATOM   2383  CD2 TRP C  36      20.174  23.019  11.548  1.00 38.66           C  
ATOM   2384  NE1 TRP C  36      19.221  21.721  13.110  1.00 39.72           N  
ATOM   2385  CE2 TRP C  36      19.375  21.875  11.756  1.00 40.68           C  
ATOM   2386  CE3 TRP C  36      20.492  23.396  10.228  1.00 40.35           C  
ATOM   2387  CZ2 TRP C  36      18.900  21.086  10.689  1.00 39.60           C  
ATOM   2388  CZ3 TRP C  36      20.001  22.624   9.175  1.00 38.19           C  
ATOM   2389  CH2 TRP C  36      19.213  21.485   9.418  1.00 39.57           C  
ATOM   2390  N   LEU C  37      24.254  25.564  11.831  1.00 42.64           N  
ATOM   2391  CA  LEU C  37      25.047  26.662  11.340  1.00 43.78           C  
ATOM   2392  C   LEU C  37      24.321  27.991  11.460  1.00 44.86           C  
ATOM   2393  O   LEU C  37      23.119  28.075  11.311  1.00 44.44           O  
ATOM   2394  CB  LEU C  37      25.420  26.400   9.871  1.00 43.73           C  
ATOM   2395  CG  LEU C  37      26.649  27.053   9.274  1.00 44.89           C  
ATOM   2396  CD1 LEU C  37      27.887  26.821  10.148  1.00 44.32           C  
ATOM   2397  CD2 LEU C  37      26.877  26.527   7.839  1.00 43.80           C  
ATOM   2398  N   THR C  38      25.087  29.034  11.741  1.00 46.65           N  
ATOM   2399  CA  THR C  38      24.640  30.431  11.598  1.00 48.27           C  
ATOM   2400  C   THR C  38      25.688  31.171  10.758  1.00 49.68           C  
ATOM   2401  O   THR C  38      26.868  30.831  10.818  1.00 50.05           O  
ATOM   2402  CB  THR C  38      24.592  31.185  12.935  1.00 48.22           C  
ATOM   2403  OG1 THR C  38      25.934  31.456  13.346  1.00 49.26           O  
ATOM   2404  CG2 THR C  38      23.911  30.401  14.005  1.00 48.32           C  
ATOM   2405  N   PRO C  39      25.292  32.211  10.005  1.00 51.39           N  
ATOM   2406  CA  PRO C  39      26.366  32.830   9.184  1.00 52.38           C  
ATOM   2407  C   PRO C  39      27.452  33.498  10.016  1.00 53.16           C  
ATOM   2408  O   PRO C  39      28.594  33.663   9.552  1.00 53.28           O  
ATOM   2409  CB  PRO C  39      25.620  33.852   8.329  1.00 52.43           C  
ATOM   2410  CG  PRO C  39      24.204  33.338   8.278  1.00 51.86           C  
ATOM   2411  CD  PRO C  39      23.945  32.618   9.576  1.00 51.13           C  
ATOM   2412  N   ALA C  40      27.099  33.827  11.251  1.00 54.03           N  
ATOM   2413  CA  ALA C  40      28.070  34.369  12.218  1.00 54.61           C  
ATOM   2414  C   ALA C  40      29.201  33.359  12.511  1.00 55.39           C  
ATOM   2415  O   ALA C  40      30.317  33.738  12.864  1.00 54.56           O  
ATOM   2416  CB  ALA C  40      27.368  34.756  13.522  1.00 54.64           C  
ATOM   2417  N   ASP C  41      28.881  32.075  12.335  1.00 56.57           N  
ATOM   2418  CA  ASP C  41      29.826  30.955  12.575  1.00 57.33           C  
ATOM   2419  C   ASP C  41      30.926  31.075  11.552  1.00 58.14           C  
ATOM   2420  O   ASP C  41      32.051  30.580  11.720  1.00 57.99           O  
ATOM   2421  CB  ASP C  41      29.167  29.578  12.409  1.00 57.24           C  
ATOM   2422  CG  ASP C  41      28.475  29.103  13.657  1.00 57.65           C  
ATOM   2423  OD1 ASP C  41      29.031  29.293  14.763  1.00 58.94           O  
ATOM   2424  OD2 ASP C  41      27.387  28.508  13.533  1.00 54.52           O  
ATOM   2425  N   LEU C  42      30.548  31.766  10.484  1.00 59.24           N  
ATOM   2426  CA  LEU C  42      31.372  31.914   9.273  1.00 60.14           C  
ATOM   2427  C   LEU C  42      32.058  33.288   9.228  1.00 60.71           C  
ATOM   2428  O   LEU C  42      33.015  33.512   8.485  1.00 60.47           O  
ATOM   2429  CB  LEU C  42      30.516  31.694   8.012  1.00 60.30           C  
ATOM   2430  CG  LEU C  42      30.277  30.239   7.579  1.00 60.51           C  
ATOM   2431  CD1 LEU C  42      30.646  29.265   8.690  1.00 60.79           C  
ATOM   2432  CD2 LEU C  42      28.848  30.065   7.107  1.00 60.35           C  
ATOM   2433  N   GLY C  43      31.551  34.201  10.037  1.00 61.54           N  
ATOM   2434  CA  GLY C  43      32.143  35.534  10.142  1.00 62.34           C  
ATOM   2435  C   GLY C  43      31.398  36.492   9.244  1.00 63.01           C  
ATOM   2436  O   GLY C  43      31.849  37.623   8.995  1.00 62.98           O  
ATOM   2437  N   VAL C  44      30.249  36.012   8.767  1.00 63.54           N  
ATOM   2438  CA  VAL C  44      29.312  36.824   7.973  1.00 64.18           C  
ATOM   2439  C   VAL C  44      28.565  37.822   8.869  1.00 65.20           C  
ATOM   2440  O   VAL C  44      28.849  37.973  10.065  1.00 65.32           O  
ATOM   2441  CB  VAL C  44      28.269  35.957   7.192  1.00 64.25           C  
ATOM   2442  CG1 VAL C  44      27.329  36.838   6.359  1.00 64.25           C  
ATOM   2443  CG2 VAL C  44      28.965  34.927   6.302  1.00 63.45           C  
ATOM   2444  N   ASP C  45      27.591  38.495   8.273  1.00 66.33           N  
ATOM   2445  CA  ASP C  45      26.835  39.547   8.982  1.00 66.69           C  
ATOM   2446  C   ASP C  45      25.657  40.086   8.157  1.00 67.19           C  
ATOM   2447  O   ASP C  45      25.181  41.207   8.384  1.00 67.91           O  
ATOM   2448  CB  ASP C  45      27.779  40.698   9.392  1.00 66.67           C  
ATOM   2449  N   PRO C  51      24.207  38.249   0.373  1.00 61.37           N  
ATOM   2450  CA  PRO C  51      25.371  37.683  -0.299  1.00 61.21           C  
ATOM   2451  C   PRO C  51      25.068  36.697  -1.433  1.00 60.88           C  
ATOM   2452  O   PRO C  51      24.350  36.997  -2.414  1.00 61.55           O  
ATOM   2453  CB  PRO C  51      26.082  36.881   0.828  1.00 61.00           C  
ATOM   2454  CG  PRO C  51      25.346  37.205   2.117  1.00 61.23           C  
ATOM   2455  CD  PRO C  51      24.454  38.402   1.816  1.00 61.57           C  
ATOM   2456  N   ALA C  52      25.729  35.551  -1.264  1.00 59.36           N  
ATOM   2457  CA  ALA C  52      25.473  34.300  -1.964  1.00 57.84           C  
ATOM   2458  C   ALA C  52      24.890  33.382  -0.888  1.00 56.53           C  
ATOM   2459  O   ALA C  52      25.021  32.174  -0.919  1.00 54.57           O  
ATOM   2460  CB  ALA C  52      26.774  33.735  -2.528  1.00 57.92           C  
ATOM   2461  N   ASP C  53      24.281  34.054   0.084  1.00 55.15           N  
ATOM   2462  CA  ASP C  53      23.596  33.441   1.232  1.00 54.77           C  
ATOM   2463  C   ASP C  53      24.419  32.431   1.997  1.00 53.52           C  
ATOM   2464  O   ASP C  53      23.890  31.432   2.468  1.00 53.40           O  
ATOM   2465  CB  ASP C  53      22.285  32.794   0.818  1.00 54.66           C  
ATOM   2466  CG  ASP C  53      21.124  33.732   0.964  1.00 56.47           C  
ATOM   2467  OD1 ASP C  53      21.354  34.961   1.102  1.00 57.92           O  
ATOM   2468  OD2 ASP C  53      19.980  33.229   0.942  1.00 58.54           O  
ATOM   2469  N   ALA C  54      25.709  32.726   2.091  1.00 52.14           N  
ATOM   2470  CA  ALA C  54      26.665  31.969   2.907  1.00 51.52           C  
ATOM   2471  C   ALA C  54      26.114  31.560   4.266  1.00 51.18           C  
ATOM   2472  O   ALA C  54      25.644  32.398   5.078  1.00 51.88           O  
ATOM   2473  CB  ALA C  54      27.981  32.759   3.085  1.00 51.10           C  
ATOM   2474  N   GLY C  55      26.195  30.252   4.498  1.00 49.99           N  
ATOM   2475  CA  GLY C  55      25.813  29.639   5.773  1.00 49.13           C  
ATOM   2476  C   GLY C  55      24.323  29.569   6.061  1.00 47.98           C  
ATOM   2477  O   GLY C  55      23.936  29.209   7.171  1.00 49.39           O  
ATOM   2478  N   VAL C  56      23.506  29.924   5.074  1.00 45.78           N  
ATOM   2479  CA  VAL C  56      22.009  29.847   5.155  1.00 44.17           C  
ATOM   2480  C   VAL C  56      21.471  28.406   5.080  1.00 42.45           C  
ATOM   2481  O   VAL C  56      21.600  27.719   4.083  1.00 42.96           O  
ATOM   2482  CB  VAL C  56      21.307  30.702   4.069  1.00 43.58           C  
ATOM   2483  CG1 VAL C  56      19.794  30.639   4.233  1.00 43.37           C  
ATOM   2484  CG2 VAL C  56      21.798  32.166   4.149  1.00 43.91           C  
ATOM   2485  N   VAL C  57      20.862  27.986   6.174  1.00 40.10           N  
ATOM   2486  CA  VAL C  57      20.524  26.591   6.408  1.00 38.67           C  
ATOM   2487  C   VAL C  57      19.189  26.176   5.782  1.00 38.54           C  
ATOM   2488  O   VAL C  57      18.367  27.018   5.405  1.00 36.77           O  
ATOM   2489  CB  VAL C  57      20.561  26.228   7.923  1.00 38.07           C  
ATOM   2490  CG1 VAL C  57      21.981  26.516   8.522  1.00 36.71           C  
ATOM   2491  CG2 VAL C  57      19.451  26.945   8.712  1.00 36.27           C  
ATOM   2492  N   SER C  58      19.045  24.858   5.604  1.00 38.52           N  
ATOM   2493  CA  SER C  58      17.774  24.259   5.187  1.00 38.64           C  
ATOM   2494  C   SER C  58      17.528  22.840   5.696  1.00 38.58           C  
ATOM   2495  O   SER C  58      18.411  22.129   6.088  1.00 36.81           O  
ATOM   2496  CB  SER C  58      17.612  24.280   3.667  1.00 39.98           C  
ATOM   2497  OG  SER C  58      18.662  23.606   2.983  1.00 40.40           O  
ATOM   2498  N   CYS C  59      16.267  22.486   5.642  1.00 38.15           N  
ATOM   2499  CA  CYS C  59      15.767  21.281   6.231  1.00 39.03           C  
ATOM   2500  C   CYS C  59      14.572  20.717   5.466  1.00 38.48           C  
ATOM   2501  O   CYS C  59      13.613  21.442   5.160  1.00 38.95           O  
ATOM   2502  CB  CYS C  59      15.308  21.602   7.663  1.00 39.46           C  
ATOM   2503  SG  CYS C  59      15.032  20.215   8.600  1.00 44.36           S  
ATOM   2504  N   VAL C  60      14.635  19.423   5.236  1.00 37.48           N  
ATOM   2505  CA  VAL C  60      13.522  18.637   4.702  1.00 36.93           C  
ATOM   2506  C   VAL C  60      13.295  17.437   5.627  1.00 37.47           C  
ATOM   2507  O   VAL C  60      14.111  16.522   5.698  1.00 36.02           O  
ATOM   2508  CB  VAL C  60      13.754  18.149   3.230  1.00 36.78           C  
ATOM   2509  CG1 VAL C  60      12.540  17.260   2.748  1.00 36.08           C  
ATOM   2510  CG2 VAL C  60      13.976  19.320   2.276  1.00 33.97           C  
ATOM   2511  N   HIS C  61      12.167  17.479   6.330  1.00 37.66           N  
ATOM   2512  CA  HIS C  61      11.679  16.371   7.159  1.00 37.34           C  
ATOM   2513  C   HIS C  61      10.927  15.367   6.251  1.00 37.78           C  
ATOM   2514  O   HIS C  61      10.443  15.731   5.194  1.00 36.15           O  
ATOM   2515  CB  HIS C  61      10.723  16.900   8.269  1.00 37.61           C  
ATOM   2516  CG  HIS C  61      11.334  17.934   9.166  1.00 36.05           C  
ATOM   2517  ND1 HIS C  61      12.413  17.669   9.989  1.00 37.17           N  
ATOM   2518  CD2 HIS C  61      10.978  19.216   9.420  1.00 37.72           C  
ATOM   2519  CE1 HIS C  61      12.675  18.740  10.724  1.00 38.58           C  
ATOM   2520  NE2 HIS C  61      11.840  19.705  10.372  1.00 35.89           N  
ATOM   2521  N   PRO C  62      10.815  14.096   6.672  1.00 37.61           N  
ATOM   2522  CA  PRO C  62      10.187  13.089   5.820  1.00 38.75           C  
ATOM   2523  C   PRO C  62       8.819  13.504   5.296  1.00 39.46           C  
ATOM   2524  O   PRO C  62       7.894  13.768   6.059  1.00 40.56           O  
ATOM   2525  CB  PRO C  62      10.105  11.877   6.758  1.00 38.83           C  
ATOM   2526  CG  PRO C  62      11.333  12.012   7.561  1.00 37.81           C  
ATOM   2527  CD  PRO C  62      11.397  13.479   7.871  1.00 38.57           C  
ATOM   2528  N   GLY C  63       8.738  13.634   3.974  1.00 39.74           N  
ATOM   2529  CA  GLY C  63       7.501  14.033   3.270  1.00 39.30           C  
ATOM   2530  C   GLY C  63       7.155  15.501   3.247  1.00 39.66           C  
ATOM   2531  O   GLY C  63       6.109  15.891   2.725  1.00 39.44           O  
ATOM   2532  N   TRP C  64       8.023  16.329   3.816  1.00 39.20           N  
ATOM   2533  CA  TRP C  64       7.738  17.756   3.873  1.00 39.26           C  
ATOM   2534  C   TRP C  64       8.289  18.557   2.679  1.00 38.37           C  
ATOM   2535  O   TRP C  64       9.135  18.100   1.906  1.00 37.99           O  
ATOM   2536  CB  TRP C  64       8.344  18.405   5.103  1.00 39.33           C  
ATOM   2537  CG  TRP C  64       7.777  18.118   6.388  1.00 42.08           C  
ATOM   2538  CD1 TRP C  64       7.418  16.912   6.874  1.00 46.73           C  
ATOM   2539  CD2 TRP C  64       7.591  19.060   7.463  1.00 44.85           C  
ATOM   2540  NE1 TRP C  64       6.984  17.043   8.172  1.00 47.82           N  
ATOM   2541  CE2 TRP C  64       7.077  18.357   8.550  1.00 47.21           C  
ATOM   2542  CE3 TRP C  64       7.792  20.435   7.594  1.00 46.64           C  
ATOM   2543  CZ2 TRP C  64       6.750  18.982   9.761  1.00 48.35           C  
ATOM   2544  CZ3 TRP C  64       7.482  21.052   8.815  1.00 45.51           C  
ATOM   2545  CH2 TRP C  64       6.973  20.327   9.865  1.00 46.16           C  
ATOM   2546  N   PRO C  65       7.806  19.784   2.547  1.00 37.55           N  
ATOM   2547  CA  PRO C  65       8.473  20.709   1.657  1.00 37.22           C  
ATOM   2548  C   PRO C  65       9.773  21.213   2.320  1.00 36.79           C  
ATOM   2549  O   PRO C  65      10.142  20.796   3.457  1.00 36.58           O  
ATOM   2550  CB  PRO C  65       7.457  21.845   1.478  1.00 37.23           C  
ATOM   2551  CG  PRO C  65       6.435  21.678   2.536  1.00 37.76           C  
ATOM   2552  CD  PRO C  65       6.721  20.406   3.312  1.00 38.07           C  
ATOM   2553  N   VAL C  66      10.449  22.096   1.610  1.00 36.00           N  
ATOM   2554  CA  VAL C  66      11.747  22.593   2.062  1.00 35.85           C  
ATOM   2555  C   VAL C  66      11.516  23.715   3.069  1.00 37.18           C  
ATOM   2556  O   VAL C  66      10.720  24.617   2.842  1.00 36.52           O  
ATOM   2557  CB  VAL C  66      12.603  23.150   0.946  1.00 36.29           C  
ATOM   2558  CG1 VAL C  66      13.874  23.754   1.554  1.00 35.54           C  
ATOM   2559  CG2 VAL C  66      12.944  22.068  -0.119  1.00 32.63           C  
ATOM   2560  N   LEU C  67      12.249  23.670   4.160  1.00 36.46           N  
ATOM   2561  CA  LEU C  67      12.314  24.824   5.076  1.00 37.39           C  
ATOM   2562  C   LEU C  67      13.666  25.502   4.920  1.00 37.58           C  
ATOM   2563  O   LEU C  67      14.698  24.854   4.886  1.00 37.86           O  
ATOM   2564  CB  LEU C  67      12.177  24.331   6.503  1.00 36.52           C  
ATOM   2565  CG  LEU C  67      10.901  23.603   6.898  1.00 38.32           C  
ATOM   2566  CD1 LEU C  67      11.135  22.875   8.202  1.00 38.38           C  
ATOM   2567  CD2 LEU C  67       9.714  24.574   7.041  1.00 38.17           C  
ATOM   2568  N   SER C  68      13.642  26.812   4.768  1.00 39.03           N  
ATOM   2569  CA  SER C  68      14.853  27.606   4.551  1.00 39.81           C  
ATOM   2570  C   SER C  68      15.072  28.676   5.611  1.00 39.24           C  
ATOM   2571  O   SER C  68      14.163  29.359   6.012  1.00 40.22           O  
ATOM   2572  CB  SER C  68      14.794  28.281   3.187  1.00 40.02           C  
ATOM   2573  OG  SER C  68      14.489  27.369   2.162  1.00 45.03           O  
ATOM   2574  N   GLY C  69      16.313  28.805   6.051  1.00 39.60           N  
ATOM   2575  CA  GLY C  69      16.661  29.749   7.116  1.00 39.57           C  
ATOM   2576  C   GLY C  69      16.491  29.179   8.509  1.00 39.47           C  
ATOM   2577  O   GLY C  69      15.645  28.347   8.751  1.00 39.59           O  
ATOM   2578  N   ARG C  70      17.355  29.623   9.407  1.00 39.46           N  
ATOM   2579  CA  ARG C  70      17.445  29.061  10.765  1.00 39.80           C  
ATOM   2580  C   ARG C  70      16.075  29.177  11.463  1.00 39.38           C  
ATOM   2581  O   ARG C  70      15.651  28.295  12.209  1.00 38.55           O  
ATOM   2582  CB  ARG C  70      18.496  29.800  11.607  1.00 40.43           C  
ATOM   2583  CG  ARG C  70      19.387  28.888  12.364  1.00 43.23           C  
ATOM   2584  CD  ARG C  70      20.546  29.647  13.005  1.00 44.31           C  
ATOM   2585  NE  ARG C  70      20.365  29.757  14.444  1.00 44.85           N  
ATOM   2586  CZ  ARG C  70      20.801  28.850  15.310  1.00 47.35           C  
ATOM   2587  NH1 ARG C  70      21.472  27.790  14.884  1.00 50.09           N  
ATOM   2588  NH2 ARG C  70      20.599  29.005  16.603  1.00 47.23           N  
ATOM   2589  N   GLY C  71      15.388  30.271  11.174  1.00 38.97           N  
ATOM   2590  CA  GLY C  71      14.080  30.557  11.801  1.00 39.15           C  
ATOM   2591  C   GLY C  71      13.075  29.471  11.443  1.00 39.06           C  
ATOM   2592  O   GLY C  71      12.429  28.883  12.314  1.00 37.55           O  
ATOM   2593  N   GLU C  72      12.966  29.193  10.142  1.00 39.27           N  
ATOM   2594  CA  GLU C  72      11.975  28.225   9.698  1.00 38.75           C  
ATOM   2595  C   GLU C  72      12.363  26.866  10.231  1.00 38.27           C  
ATOM   2596  O   GLU C  72      11.517  26.087  10.640  1.00 38.57           O  
ATOM   2597  CB  GLU C  72      11.821  28.196   8.182  1.00 40.04           C  
ATOM   2598  CG  GLU C  72      10.888  29.242   7.536  1.00 42.56           C  
ATOM   2599  CD  GLU C  72      10.887  29.085   5.989  1.00 48.86           C  
ATOM   2600  OE1 GLU C  72      11.226  27.966   5.492  1.00 50.50           O  
ATOM   2601  OE2 GLU C  72      10.629  30.077   5.253  1.00 53.30           O  
ATOM   2602  N   VAL C  73      13.666  26.607  10.249  1.00 37.42           N  
ATOM   2603  CA  VAL C  73      14.207  25.276  10.535  1.00 36.58           C  
ATOM   2604  C   VAL C  73      14.017  24.939  12.027  1.00 36.90           C  
ATOM   2605  O   VAL C  73      13.486  23.874  12.384  1.00 37.38           O  
ATOM   2606  CB  VAL C  73      15.712  25.108  10.120  1.00 37.00           C  
ATOM   2607  CG1 VAL C  73      16.365  23.889  10.830  1.00 33.24           C  
ATOM   2608  CG2 VAL C  73      15.841  24.984   8.618  1.00 33.98           C  
ATOM   2609  N   LEU C  74      14.426  25.865  12.880  1.00 36.10           N  
ATOM   2610  CA  LEU C  74      14.325  25.678  14.332  1.00 36.46           C  
ATOM   2611  C   LEU C  74      12.865  25.599  14.766  1.00 35.74           C  
ATOM   2612  O   LEU C  74      12.510  24.830  15.621  1.00 34.01           O  
ATOM   2613  CB  LEU C  74      15.060  26.803  15.083  1.00 36.47           C  
ATOM   2614  CG  LEU C  74      16.594  26.795  14.900  1.00 37.96           C  
ATOM   2615  CD1 LEU C  74      17.230  27.827  15.867  1.00 37.33           C  
ATOM   2616  CD2 LEU C  74      17.143  25.402  15.143  1.00 35.41           C  
ATOM   2617  N   ARG C  75      12.040  26.444  14.173  1.00 36.14           N  
ATOM   2618  CA  ARG C  75      10.609  26.398  14.444  1.00 37.00           C  
ATOM   2619  C   ARG C  75      10.015  25.017  14.192  1.00 37.10           C  
ATOM   2620  O   ARG C  75       9.164  24.566  14.940  1.00 34.92           O  
ATOM   2621  CB  ARG C  75       9.850  27.429  13.620  1.00 38.20           C  
ATOM   2622  CG  ARG C  75       8.338  27.338  13.736  1.00 38.34           C  
ATOM   2623  CD  ARG C  75       7.697  28.479  12.958  1.00 40.24           C  
ATOM   2624  NE  ARG C  75       6.237  28.402  12.947  1.00 42.95           N  
ATOM   2625  CZ  ARG C  75       5.443  29.098  13.755  1.00 47.16           C  
ATOM   2626  NH1 ARG C  75       5.942  29.954  14.615  1.00 44.96           N  
ATOM   2627  NH2 ARG C  75       4.135  28.980  13.660  1.00 48.31           N  
ATOM   2628  N   SER C  76      10.459  24.357  13.121  1.00 37.27           N  
ATOM   2629  CA  SER C  76       9.902  23.047  12.791  1.00 37.62           C  
ATOM   2630  C   SER C  76      10.342  22.066  13.861  1.00 38.24           C  
ATOM   2631  O   SER C  76       9.559  21.207  14.273  1.00 38.75           O  
ATOM   2632  CB  SER C  76      10.293  22.583  11.366  1.00 38.75           C  
ATOM   2633  OG  SER C  76      11.655  22.274  11.295  1.00 36.21           O  
ATOM   2634  N   TYR C  77      11.589  22.191  14.333  1.00 38.99           N  
ATOM   2635  CA  TYR C  77      12.106  21.267  15.387  1.00 38.48           C  
ATOM   2636  C   TYR C  77      11.412  21.472  16.729  1.00 39.51           C  
ATOM   2637  O   TYR C  77      11.157  20.529  17.483  1.00 39.17           O  
ATOM   2638  CB  TYR C  77      13.630  21.358  15.584  1.00 39.75           C  
ATOM   2639  CG  TYR C  77      14.354  20.500  14.572  1.00 39.05           C  
ATOM   2640  CD1 TYR C  77      14.453  19.140  14.730  1.00 38.78           C  
ATOM   2641  CD2 TYR C  77      14.866  21.051  13.429  1.00 38.79           C  
ATOM   2642  CE1 TYR C  77      15.119  18.349  13.774  1.00 37.73           C  
ATOM   2643  CE2 TYR C  77      15.515  20.255  12.464  1.00 39.74           C  
ATOM   2644  CZ  TYR C  77      15.628  18.924  12.651  1.00 37.35           C  
ATOM   2645  OH  TYR C  77      16.258  18.160  11.669  1.00 42.65           O  
ATOM   2646  N   ALA C  78      11.124  22.720  17.022  1.00 38.85           N  
ATOM   2647  CA  ALA C  78      10.428  23.060  18.275  1.00 39.31           C  
ATOM   2648  C   ALA C  78       9.058  22.375  18.248  1.00 39.98           C  
ATOM   2649  O   ALA C  78       8.674  21.708  19.188  1.00 41.11           O  
ATOM   2650  CB  ALA C  78      10.294  24.548  18.415  1.00 37.48           C  
ATOM   2651  N   LEU C  79       8.371  22.473  17.113  1.00 40.73           N  
ATOM   2652  CA  LEU C  79       7.044  21.855  16.932  1.00 41.29           C  
ATOM   2653  C   LEU C  79       7.096  20.341  16.983  1.00 41.71           C  
ATOM   2654  O   LEU C  79       6.299  19.678  17.642  1.00 41.13           O  
ATOM   2655  CB  LEU C  79       6.451  22.256  15.591  1.00 40.96           C  
ATOM   2656  CG  LEU C  79       5.098  21.655  15.202  1.00 42.07           C  
ATOM   2657  CD1 LEU C  79       3.911  22.038  16.161  1.00 40.21           C  
ATOM   2658  CD2 LEU C  79       4.788  22.037  13.793  1.00 41.38           C  
ATOM   2659  N   ILE C  80       8.044  19.785  16.247  1.00 43.16           N  
ATOM   2660  CA  ILE C  80       8.142  18.332  16.146  1.00 43.83           C  
ATOM   2661  C   ILE C  80       8.424  17.748  17.522  1.00 44.23           C  
ATOM   2662  O   ILE C  80       7.822  16.774  17.971  1.00 44.75           O  
ATOM   2663  CB  ILE C  80       9.321  17.875  15.243  1.00 44.89           C  
ATOM   2664  CG1 ILE C  80       9.169  18.378  13.799  1.00 47.86           C  
ATOM   2665  CG2 ILE C  80       9.497  16.358  15.333  1.00 42.46           C  
ATOM   2666  CD1 ILE C  80       7.839  18.147  13.219  1.00 50.38           C  
HETATM 2667  N   MSE C  81       9.407  18.344  18.149  1.00 44.66           N  
HETATM 2668  CA  MSE C  81       9.835  17.938  19.481  1.00 45.56           C  
HETATM 2669  C   MSE C  81       8.717  18.045  20.496  1.00 45.22           C  
HETATM 2670  O   MSE C  81       8.617  17.230  21.394  1.00 45.44           O  
HETATM 2671  CB  MSE C  81      11.065  18.740  19.927  1.00 45.42           C  
HETATM 2672  CG  MSE C  81      12.329  18.204  19.253  1.00 47.68           C  
HETATM 2673 SE   MSE C  81      13.976  19.253  19.485  0.75 48.02          SE  
HETATM 2674  CE  MSE C  81      13.809  19.713  21.282  1.00 46.52           C  
ATOM   2675  N   ALA C  82       7.853  19.036  20.347  1.00 45.93           N  
ATOM   2676  CA  ALA C  82       6.826  19.275  21.391  1.00 45.60           C  
ATOM   2677  C   ALA C  82       5.761  18.236  21.200  1.00 45.66           C  
ATOM   2678  O   ALA C  82       5.081  17.850  22.123  1.00 45.79           O  
ATOM   2679  CB  ALA C  82       6.209  20.678  21.286  1.00 45.92           C  
ATOM   2680  N   ASN C  83       5.672  17.758  19.976  1.00 45.40           N  
ATOM   2681  CA  ASN C  83       4.584  16.912  19.567  1.00 45.91           C  
ATOM   2682  C   ASN C  83       4.961  15.443  19.546  1.00 45.98           C  
ATOM   2683  O   ASN C  83       4.161  14.594  19.169  1.00 46.72           O  
ATOM   2684  CB  ASN C  83       4.033  17.350  18.211  1.00 46.07           C  
ATOM   2685  CG  ASN C  83       3.025  18.458  18.361  1.00 47.46           C  
ATOM   2686  OD1 ASN C  83       2.447  18.611  19.422  1.00 48.88           O  
ATOM   2687  ND2 ASN C  83       2.829  19.249  17.315  1.00 53.14           N  
ATOM   2688  N   THR C  84       6.173  15.164  19.987  1.00 45.53           N  
ATOM   2689  CA  THR C  84       6.677  13.808  19.995  1.00 45.45           C  
ATOM   2690  C   THR C  84       6.886  13.359  21.413  1.00 44.83           C  
ATOM   2691  O   THR C  84       7.670  13.937  22.145  1.00 44.90           O  
ATOM   2692  CB  THR C  84       8.010  13.684  19.221  1.00 46.19           C  
ATOM   2693  OG1 THR C  84       7.838  14.168  17.888  1.00 45.67           O  
ATOM   2694  CG2 THR C  84       8.469  12.229  19.172  1.00 45.94           C  
ATOM   2695  N   GLU C  85       6.181  12.300  21.788  1.00 44.31           N  
ATOM   2696  CA  GLU C  85       6.213  11.799  23.187  1.00 43.76           C  
ATOM   2697  C   GLU C  85       7.476  11.014  23.430  1.00 42.55           C  
ATOM   2698  O   GLU C  85       8.125  11.092  24.480  1.00 42.57           O  
ATOM   2699  CB  GLU C  85       5.005  10.905  23.455  1.00 44.26           C  
ATOM   2700  CG  GLU C  85       4.958  10.397  24.865  1.00 46.28           C  
ATOM   2701  CD  GLU C  85       4.405  11.435  25.835  1.00 50.56           C  
ATOM   2702  OE1 GLU C  85       3.750  12.412  25.382  1.00 48.67           O  
ATOM   2703  OE2 GLU C  85       4.618  11.256  27.058  1.00 53.17           O  
ATOM   2704  N   TYR C  86       7.813  10.243  22.418  1.00 41.92           N  
ATOM   2705  CA  TYR C  86       8.973   9.350  22.455  1.00 40.97           C  
ATOM   2706  C   TYR C  86       9.557   9.091  21.077  1.00 40.40           C  
ATOM   2707  O   TYR C  86       8.850   8.706  20.132  1.00 40.20           O  
ATOM   2708  CB  TYR C  86       8.569   8.015  23.105  1.00 40.63           C  
ATOM   2709  CG  TYR C  86       9.702   7.004  23.173  1.00 40.60           C  
ATOM   2710  CD1 TYR C  86      10.599   7.031  24.214  1.00 41.00           C  
ATOM   2711  CD2 TYR C  86       9.878   6.051  22.183  1.00 38.64           C  
ATOM   2712  CE1 TYR C  86      11.653   6.135  24.278  1.00 41.39           C  
ATOM   2713  CE2 TYR C  86      10.917   5.152  22.241  1.00 40.12           C  
ATOM   2714  CZ  TYR C  86      11.802   5.197  23.285  1.00 40.58           C  
ATOM   2715  OH  TYR C  86      12.825   4.286  23.367  1.00 43.44           O  
ATOM   2716  N   ILE C  87      10.862   9.315  20.970  1.00 40.19           N  
ATOM   2717  CA  ILE C  87      11.602   9.013  19.735  1.00 39.71           C  
ATOM   2718  C   ILE C  87      12.998   8.450  19.991  1.00 39.65           C  
ATOM   2719  O   ILE C  87      13.694   8.863  20.894  1.00 40.45           O  
ATOM   2720  CB  ILE C  87      11.655  10.247  18.785  1.00 40.45           C  
ATOM   2721  CG1 ILE C  87      12.087   9.841  17.377  1.00 38.13           C  
ATOM   2722  CG2 ILE C  87      12.564  11.351  19.304  1.00 38.87           C  
ATOM   2723  CD1 ILE C  87      11.438  10.810  16.295  1.00 39.65           C  
ATOM   2724  N   GLN C  88      13.370   7.489  19.160  1.00 38.94           N  
ATOM   2725  CA  GLN C  88      14.705   6.920  19.160  1.00 38.98           C  
ATOM   2726  C   GLN C  88      15.129   6.713  17.753  1.00 38.41           C  
ATOM   2727  O   GLN C  88      14.354   6.279  16.934  1.00 38.84           O  
ATOM   2728  CB  GLN C  88      14.765   5.570  19.889  1.00 38.53           C  
ATOM   2729  CG  GLN C  88      14.405   5.654  21.315  1.00 39.79           C  
ATOM   2730  CD  GLN C  88      15.576   6.020  22.148  1.00 42.40           C  
ATOM   2731  OE1 GLN C  88      16.501   5.224  22.309  1.00 43.95           O  
ATOM   2732  NE2 GLN C  88      15.576   7.240  22.665  1.00 41.85           N  
ATOM   2733  N   PHE C  89      16.368   7.073  17.497  1.00 37.77           N  
ATOM   2734  CA  PHE C  89      17.017   6.840  16.202  1.00 37.96           C  
ATOM   2735  C   PHE C  89      18.067   5.794  16.377  1.00 37.35           C  
ATOM   2736  O   PHE C  89      18.856   5.825  17.328  1.00 38.38           O  
ATOM   2737  CB  PHE C  89      17.679   8.105  15.656  1.00 37.97           C  
ATOM   2738  CG  PHE C  89      16.717   9.211  15.329  1.00 37.58           C  
ATOM   2739  CD1 PHE C  89      16.247  10.046  16.324  1.00 38.30           C  
ATOM   2740  CD2 PHE C  89      16.295   9.426  14.031  1.00 38.99           C  
ATOM   2741  CE1 PHE C  89      15.358  11.063  16.035  1.00 38.73           C  
ATOM   2742  CE2 PHE C  89      15.414  10.419  13.736  1.00 34.98           C  
ATOM   2743  CZ  PHE C  89      14.938  11.252  14.730  1.00 39.46           C  
ATOM   2744  N   PHE C  90      18.024   4.829  15.481  1.00 37.74           N  
ATOM   2745  CA  PHE C  90      19.089   3.849  15.310  1.00 38.08           C  
ATOM   2746  C   PHE C  90      19.662   3.953  13.907  1.00 38.52           C  
ATOM   2747  O   PHE C  90      19.122   3.403  12.942  1.00 39.72           O  
ATOM   2748  CB  PHE C  90      18.584   2.422  15.574  1.00 37.76           C  
ATOM   2749  CG  PHE C  90      17.824   2.283  16.850  1.00 37.55           C  
ATOM   2750  CD1 PHE C  90      16.468   2.545  16.892  1.00 37.07           C  
ATOM   2751  CD2 PHE C  90      18.472   1.915  18.007  1.00 37.86           C  
ATOM   2752  CE1 PHE C  90      15.774   2.426  18.060  1.00 37.34           C  
ATOM   2753  CE2 PHE C  90      17.772   1.794  19.190  1.00 39.36           C  
ATOM   2754  CZ  PHE C  90      16.433   2.027  19.211  1.00 38.39           C  
ATOM   2755  N   LEU C  91      20.784   4.655  13.812  1.00 38.72           N  
ATOM   2756  CA  LEU C  91      21.440   4.905  12.520  1.00 37.99           C  
ATOM   2757  C   LEU C  91      22.169   3.673  12.069  1.00 38.09           C  
ATOM   2758  O   LEU C  91      22.887   3.031  12.846  1.00 39.18           O  
ATOM   2759  CB  LEU C  91      22.433   6.043  12.609  1.00 37.67           C  
ATOM   2760  CG  LEU C  91      21.936   7.383  13.140  1.00 37.56           C  
ATOM   2761  CD1 LEU C  91      23.045   8.392  12.892  1.00 35.62           C  
ATOM   2762  CD2 LEU C  91      20.668   7.743  12.453  1.00 34.20           C  
ATOM   2763  N   THR C  92      21.980   3.347  10.807  1.00 37.48           N  
ATOM   2764  CA  THR C  92      22.793   2.339  10.121  1.00 36.91           C  
ATOM   2765  C   THR C  92      23.326   2.872   8.790  1.00 37.74           C  
ATOM   2766  O   THR C  92      22.828   3.852   8.226  1.00 37.38           O  
ATOM   2767  CB  THR C  92      21.996   1.047   9.853  1.00 37.22           C  
ATOM   2768  OG1 THR C  92      20.812   1.363   9.112  1.00 36.09           O  
ATOM   2769  CG2 THR C  92      21.595   0.327  11.175  1.00 34.86           C  
ATOM   2770  N   ASP C  93      24.367   2.228   8.311  1.00 38.23           N  
ATOM   2771  CA  ASP C  93      24.928   2.473   6.986  0.50 38.62           C  
ATOM   2773  C   ASP C  93      25.407   3.909   6.889  1.00 38.96           C  
ATOM   2774  O   ASP C  93      25.254   4.574   5.857  1.00 38.36           O  
ATOM   2775  CB  ASP C  93      23.882   2.157   5.914  0.50 39.19           C  
ATOM   2777  CG  ASP C  93      24.495   1.722   4.587  0.50 40.22           C  
ATOM   2779  OD1 ASP C  93      25.673   1.314   4.554  0.50 42.38           O  
ATOM   2781  OD2 ASP C  93      23.782   1.782   3.566  0.50 44.04           O  
ATOM   2783  N   VAL C  94      25.965   4.386   7.996  1.00 39.12           N  
ATOM   2784  CA  VAL C  94      26.497   5.736   8.047  1.00 39.06           C  
ATOM   2785  C   VAL C  94      27.758   5.856   7.189  1.00 39.59           C  
ATOM   2786  O   VAL C  94      28.729   5.134   7.376  1.00 39.71           O  
ATOM   2787  CB  VAL C  94      26.752   6.245   9.476  1.00 39.12           C  
ATOM   2788  CG1 VAL C  94      27.263   7.691   9.413  1.00 37.43           C  
ATOM   2789  CG2 VAL C  94      25.456   6.215  10.307  1.00 37.38           C  
ATOM   2790  N   HIS C  95      27.720   6.773   6.227  1.00 39.80           N  
ATOM   2791  CA  HIS C  95      28.887   7.073   5.415  1.00 40.23           C  
ATOM   2792  C   HIS C  95      29.249   8.538   5.500  1.00 39.59           C  
ATOM   2793  O   HIS C  95      28.423   9.371   5.351  1.00 40.20           O  
ATOM   2794  CB  HIS C  95      28.706   6.683   3.939  1.00 40.51           C  
ATOM   2795  CG  HIS C  95      29.929   6.966   3.118  1.00 44.33           C  
ATOM   2796  ND1 HIS C  95      29.999   7.999   2.201  1.00 49.70           N  
ATOM   2797  CD2 HIS C  95      31.157   6.383   3.121  1.00 48.25           C  
ATOM   2798  CE1 HIS C  95      31.203   8.011   1.651  1.00 49.58           C  
ATOM   2799  NE2 HIS C  95      31.926   7.042   2.190  1.00 48.70           N  
ATOM   2800  N   VAL C  96      30.524   8.817   5.716  1.00 40.01           N  
ATOM   2801  CA  VAL C  96      31.033  10.196   5.805  1.00 39.89           C  
ATOM   2802  C   VAL C  96      32.035  10.481   4.729  1.00 40.32           C  
ATOM   2803  O   VAL C  96      32.983   9.719   4.506  1.00 40.41           O  
ATOM   2804  CB  VAL C  96      31.738  10.475   7.146  1.00 39.83           C  
ATOM   2805  CG1 VAL C  96      32.182  11.931   7.232  1.00 38.17           C  
ATOM   2806  CG2 VAL C  96      30.819  10.120   8.278  1.00 37.35           C  
ATOM   2807  N   SER C  97      31.817  11.611   4.079  1.00 40.21           N  
ATOM   2808  CA  SER C  97      32.739  12.102   3.066  1.00 40.73           C  
ATOM   2809  C   SER C  97      33.126  13.551   3.400  1.00 40.79           C  
ATOM   2810  O   SER C  97      32.269  14.455   3.477  1.00 40.61           O  
ATOM   2811  CB  SER C  97      32.088  11.976   1.677  1.00 41.86           C  
ATOM   2812  OG  SER C  97      32.485  13.000   0.748  1.00 43.45           O  
ATOM   2813  N   VAL C  98      34.415  13.761   3.648  1.00 39.88           N  
ATOM   2814  CA  VAL C  98      34.898  15.095   4.010  1.00 39.78           C  
ATOM   2815  C   VAL C  98      35.713  15.644   2.876  1.00 39.70           C  
ATOM   2816  O   VAL C  98      36.659  15.024   2.404  1.00 38.98           O  
ATOM   2817  CB  VAL C  98      35.734  15.117   5.328  1.00 39.98           C  
ATOM   2818  CG1 VAL C  98      36.048  16.565   5.714  1.00 39.50           C  
ATOM   2819  CG2 VAL C  98      34.992  14.436   6.458  1.00 37.98           C  
ATOM   2820  N   THR C  99      35.281  16.788   2.393  1.00 39.56           N  
ATOM   2821  CA  THR C  99      36.030  17.497   1.371  1.00 40.65           C  
ATOM   2822  C   THR C  99      36.224  18.950   1.790  1.00 39.96           C  
ATOM   2823  O   THR C  99      35.279  19.720   1.788  1.00 40.30           O  
ATOM   2824  CB  THR C  99      35.317  17.481  -0.027  1.00 41.07           C  
ATOM   2825  OG1 THR C  99      34.685  16.214  -0.289  1.00 42.69           O  
ATOM   2826  CG2 THR C  99      36.329  17.767  -1.117  1.00 41.47           C  
ATOM   2827  N   GLY C 100      37.447  19.316   2.145  1.00 39.68           N  
ATOM   2828  CA  GLY C 100      37.749  20.690   2.601  1.00 38.60           C  
ATOM   2829  C   GLY C 100      37.108  20.997   3.928  1.00 38.16           C  
ATOM   2830  O   GLY C 100      37.362  20.319   4.908  1.00 39.19           O  
ATOM   2831  N   ASP C 101      36.228  21.988   3.950  1.00 37.78           N  
ATOM   2832  CA  ASP C 101      35.538  22.396   5.188  1.00 37.14           C  
ATOM   2833  C   ASP C 101      34.061  22.029   5.178  1.00 36.79           C  
ATOM   2834  O   ASP C 101      33.246  22.571   5.941  1.00 36.78           O  
ATOM   2835  CB  ASP C 101      35.697  23.896   5.373  1.00 37.63           C  
ATOM   2836  CG  ASP C 101      37.153  24.299   5.457  1.00 38.17           C  
ATOM   2837  OD1 ASP C 101      37.888  23.608   6.183  1.00 39.76           O  
ATOM   2838  OD2 ASP C 101      37.566  25.268   4.794  1.00 40.91           O  
ATOM   2839  N   THR C 102      33.736  21.106   4.291  1.00 36.25           N  
ATOM   2840  CA  THR C 102      32.386  20.535   4.194  1.00 35.54           C  
ATOM   2841  C   THR C 102      32.418  19.016   4.321  1.00 35.87           C  
ATOM   2842  O   THR C 102      33.320  18.368   3.807  1.00 35.00           O  
ATOM   2843  CB  THR C 102      31.726  20.906   2.866  1.00 35.78           C  
ATOM   2844  OG1 THR C 102      31.831  22.317   2.653  1.00 35.39           O  
ATOM   2845  CG2 THR C 102      30.263  20.539   2.826  1.00 33.61           C  
ATOM   2846  N   ALA C 103      31.421  18.472   5.028  1.00 35.84           N  
ATOM   2847  CA  ALA C 103      31.205  17.028   5.124  1.00 36.14           C  
ATOM   2848  C   ALA C 103      29.783  16.680   4.771  1.00 37.55           C  
ATOM   2849  O   ALA C 103      28.822  17.382   5.080  1.00 37.96           O  
ATOM   2850  CB  ALA C 103      31.578  16.470   6.491  1.00 35.15           C  
ATOM   2851  N   LEU C 104      29.701  15.607   4.024  1.00 38.56           N  
ATOM   2852  CA  LEU C 104      28.454  15.030   3.635  1.00 39.24           C  
ATOM   2853  C   LEU C 104      28.351  13.681   4.293  1.00 38.99           C  
ATOM   2854  O   LEU C 104      29.217  12.837   4.139  1.00 38.45           O  
ATOM   2855  CB  LEU C 104      28.457  14.870   2.131  1.00 40.03           C  
ATOM   2856  CG  LEU C 104      27.205  14.642   1.334  1.00 41.48           C  
ATOM   2857  CD1 LEU C 104      26.586  15.960   1.176  1.00 44.05           C  
ATOM   2858  CD2 LEU C 104      27.710  14.089  -0.027  1.00 44.62           C  
ATOM   2859  N   VAL C 105      27.303  13.533   5.094  1.00 38.82           N  
ATOM   2860  CA  VAL C 105      27.017  12.303   5.782  1.00 38.26           C  
ATOM   2861  C   VAL C 105      25.711  11.763   5.216  1.00 38.78           C  
ATOM   2862  O   VAL C 105      24.732  12.489   5.109  1.00 39.39           O  
ATOM   2863  CB  VAL C 105      26.867  12.527   7.302  1.00 38.71           C  
ATOM   2864  CG1 VAL C 105      26.426  11.249   7.996  1.00 36.95           C  
ATOM   2865  CG2 VAL C 105      28.187  13.088   7.915  1.00 36.92           C  
ATOM   2866  N   THR C 106      25.707  10.488   4.841  1.00 37.96           N  
ATOM   2867  CA  THR C 106      24.447   9.832   4.548  1.00 36.81           C  
ATOM   2868  C   THR C 106      24.230   8.696   5.518  1.00 37.49           C  
ATOM   2869  O   THR C 106      25.176   8.046   5.994  1.00 37.31           O  
ATOM   2870  CB  THR C 106      24.353   9.353   3.074  1.00 36.91           C  
ATOM   2871  OG1 THR C 106      25.309   8.353   2.820  1.00 36.35           O  
ATOM   2872  CG2 THR C 106      24.569  10.493   2.074  1.00 35.14           C  
ATOM   2873  N   CYS C 107      22.975   8.514   5.898  1.00 37.45           N  
ATOM   2874  CA  CYS C 107      22.653   7.386   6.741  1.00 37.61           C  
ATOM   2875  C   CYS C 107      21.219   6.919   6.593  1.00 37.17           C  
ATOM   2876  O   CYS C 107      20.353   7.608   6.023  1.00 35.84           O  
ATOM   2877  CB  CYS C 107      22.914   7.751   8.189  1.00 37.51           C  
ATOM   2878  SG  CYS C 107      22.036   9.259   8.687  1.00 41.27           S  
ATOM   2879  N   THR C 108      20.999   5.750   7.166  1.00 36.38           N  
ATOM   2880  CA  THR C 108      19.655   5.245   7.406  1.00 36.33           C  
ATOM   2881  C   THR C 108      19.201   5.571   8.816  1.00 36.53           C  
ATOM   2882  O   THR C 108      19.861   5.202   9.795  1.00 37.67           O  
ATOM   2883  CB  THR C 108      19.574   3.731   7.184  1.00 36.86           C  
ATOM   2884  OG1 THR C 108      20.132   3.420   5.889  1.00 36.21           O  
ATOM   2885  CG2 THR C 108      18.128   3.244   7.282  1.00 35.78           C  
ATOM   2886  N   GLU C 109      18.085   6.281   8.891  1.00 36.04           N  
ATOM   2887  CA  GLU C 109      17.372   6.591  10.169  1.00 35.81           C  
ATOM   2888  C   GLU C 109      16.305   5.541  10.389  1.00 35.83           C  
ATOM   2889  O   GLU C 109      15.272   5.505   9.730  1.00 34.46           O  
ATOM   2890  CB  GLU C 109      16.742   7.989  10.121  1.00 36.14           C  
ATOM   2891  CG  GLU C 109      17.758   9.153   9.877  1.00 38.25           C  
ATOM   2892  CD  GLU C 109      17.122  10.532   9.863  1.00 40.85           C  
ATOM   2893  OE1 GLU C 109      15.955  10.665  10.273  1.00 43.37           O  
ATOM   2894  OE2 GLU C 109      17.799  11.509   9.473  1.00 43.20           O  
ATOM   2895  N   ASN C 110      16.601   4.617  11.286  1.00 36.41           N  
ATOM   2896  CA  ASN C 110      15.648   3.594  11.670  1.00 36.96           C  
ATOM   2897  C   ASN C 110      14.965   4.223  12.881  1.00 37.21           C  
ATOM   2898  O   ASN C 110      15.543   4.271  13.960  1.00 37.91           O  
ATOM   2899  CB  ASN C 110      16.375   2.274  11.998  1.00 36.41           C  
ATOM   2900  CG  ASN C 110      17.142   1.683  10.813  1.00 37.71           C  
ATOM   2901  OD1 ASN C 110      16.540   1.136   9.876  1.00 38.81           O  
ATOM   2902  ND2 ASN C 110      18.483   1.734  10.872  1.00 35.96           N  
ATOM   2903  N   ILE C 111      13.797   4.823  12.654  1.00 37.28           N  
ATOM   2904  CA  ILE C 111      13.100   5.632  13.683  1.00 37.93           C  
ATOM   2905  C   ILE C 111      12.023   4.811  14.380  1.00 38.90           C  
ATOM   2906  O   ILE C 111      11.157   4.175  13.738  1.00 38.84           O  
ATOM   2907  CB  ILE C 111      12.428   6.934  13.105  1.00 37.68           C  
ATOM   2908  CG1 ILE C 111      13.407   7.672  12.174  1.00 37.86           C  
ATOM   2909  CG2 ILE C 111      11.955   7.790  14.229  1.00 38.88           C  
ATOM   2910  CD1 ILE C 111      12.828   8.876  11.432  1.00 33.32           C  
ATOM   2911  N   LEU C 112      12.120   4.803  15.699  1.00 38.57           N  
ATOM   2912  CA  LEU C 112      11.101   4.189  16.549  1.00 39.09           C  
ATOM   2913  C   LEU C 112      10.488   5.296  17.372  1.00 39.44           C  
ATOM   2914  O   LEU C 112      11.203   6.052  18.028  1.00 38.43           O  
ATOM   2915  CB  LEU C 112      11.736   3.125  17.456  1.00 39.00           C  
ATOM   2916  CG  LEU C 112      10.852   2.269  18.366  1.00 40.07           C  
ATOM   2917  CD1 LEU C 112       9.968   1.320  17.571  1.00 40.57           C  
ATOM   2918  CD2 LEU C 112      11.744   1.465  19.347  1.00 36.54           C  
ATOM   2919  N   SER C 113       9.159   5.423  17.300  1.00 39.97           N  
ATOM   2920  CA  SER C 113       8.482   6.480  18.037  1.00 40.07           C  
ATOM   2921  C   SER C 113       7.197   5.998  18.657  1.00 40.58           C  
ATOM   2922  O   SER C 113       6.582   5.038  18.205  1.00 40.09           O  
ATOM   2923  CB  SER C 113       8.205   7.690  17.122  1.00 41.08           C  
ATOM   2924  OG  SER C 113       7.346   7.352  16.060  1.00 37.92           O  
ATOM   2925  N   GLY C 114       6.817   6.656  19.729  1.00 40.75           N  
ATOM   2926  CA  GLY C 114       5.518   6.391  20.327  1.00 42.18           C  
ATOM   2927  C   GLY C 114       4.828   7.611  20.858  1.00 42.45           C  
ATOM   2928  O   GLY C 114       5.447   8.623  21.142  1.00 43.24           O  
ATOM   2929  N   GLY C 115       3.518   7.486  20.976  1.00 43.64           N  
ATOM   2930  CA  GLY C 115       2.683   8.525  21.537  1.00 43.36           C  
ATOM   2931  C   GLY C 115       2.287   8.279  22.988  1.00 43.55           C  
ATOM   2932  O   GLY C 115       2.661   7.274  23.620  1.00 43.16           O  
ATOM   2933  N   PRO C 116       1.510   9.201  23.546  1.00 43.26           N  
ATOM   2934  CA  PRO C 116       1.107   9.017  24.932  1.00 43.48           C  
ATOM   2935  C   PRO C 116       0.323   7.727  25.166  1.00 43.11           C  
ATOM   2936  O   PRO C 116      -0.322   7.201  24.259  1.00 43.53           O  
ATOM   2937  CB  PRO C 116       0.199  10.209  25.200  1.00 43.74           C  
ATOM   2938  CG  PRO C 116       0.495  11.203  24.125  1.00 43.46           C  
ATOM   2939  CD  PRO C 116       1.009  10.453  22.952  1.00 43.49           C  
ATOM   2940  N   PRO C 117       0.328   7.245  26.397  1.00 42.44           N  
ATOM   2941  CA  PRO C 117      -0.437   6.048  26.663  1.00 42.51           C  
ATOM   2942  C   PRO C 117      -1.940   6.287  26.763  1.00 43.21           C  
ATOM   2943  O   PRO C 117      -2.388   7.370  27.154  1.00 42.88           O  
ATOM   2944  CB  PRO C 117       0.085   5.616  28.028  1.00 42.30           C  
ATOM   2945  CG  PRO C 117       0.420   6.879  28.699  1.00 41.95           C  
ATOM   2946  CD  PRO C 117       0.969   7.777  27.606  1.00 42.69           C  
ATOM   2947  N   PRO C 118      -2.727   5.262  26.457  1.00 43.59           N  
ATOM   2948  CA  PRO C 118      -4.153   5.504  26.540  1.00 43.46           C  
ATOM   2949  C   PRO C 118      -4.576   5.646  27.998  1.00 43.80           C  
ATOM   2950  O   PRO C 118      -5.636   6.169  28.310  1.00 43.63           O  
ATOM   2951  CB  PRO C 118      -4.733   4.231  25.954  1.00 43.67           C  
ATOM   2952  CG  PRO C 118      -3.793   3.176  26.458  1.00 43.62           C  
ATOM   2953  CD  PRO C 118      -2.412   3.829  26.388  1.00 43.63           C  
ATOM   2954  N   ASP C 119      -3.736   5.150  28.887  1.00 44.37           N  
ATOM   2955  CA  ASP C 119      -4.009   5.303  30.323  1.00 44.57           C  
ATOM   2956  C   ASP C 119      -2.784   5.071  31.141  1.00 44.30           C  
ATOM   2957  O   ASP C 119      -1.757   4.726  30.587  1.00 44.07           O  
ATOM   2958  CB  ASP C 119      -5.094   4.343  30.755  1.00 45.31           C  
ATOM   2959  CG  ASP C 119      -4.634   2.913  30.736  1.00 47.48           C  
ATOM   2960  OD1 ASP C 119      -3.580   2.614  31.345  1.00 49.48           O  
ATOM   2961  OD2 ASP C 119      -5.332   2.089  30.114  1.00 50.94           O  
ATOM   2962  N   ASP C 120      -2.879   5.259  32.455  1.00 44.35           N  
ATOM   2963  CA  ASP C 120      -1.663   5.175  33.283  1.00 44.81           C  
ATOM   2964  C   ASP C 120      -1.302   3.754  33.650  1.00 43.55           C  
ATOM   2965  O   ASP C 120      -0.429   3.551  34.477  1.00 44.42           O  
ATOM   2966  CB  ASP C 120      -1.558   6.132  34.504  1.00 45.39           C  
ATOM   2967  CG  ASP C 120      -2.874   6.562  35.073  1.00 48.21           C  
ATOM   2968  OD1 ASP C 120      -3.432   5.817  35.910  1.00 50.36           O  
ATOM   2969  OD2 ASP C 120      -3.321   7.684  34.717  1.00 52.77           O  
ATOM   2970  N   SER C 121      -1.933   2.768  33.027  1.00 41.99           N  
ATOM   2971  CA  SER C 121      -1.503   1.376  33.277  1.00 40.47           C  
ATOM   2972  C   SER C 121      -0.379   1.127  32.290  1.00 38.75           C  
ATOM   2973  O   SER C 121       0.325   0.145  32.375  1.00 36.88           O  
ATOM   2974  CB  SER C 121      -2.632   0.343  33.125  1.00 40.23           C  
ATOM   2975  OG  SER C 121      -2.805  -0.067  31.773  1.00 40.63           O  
ATOM   2976  N   ASP C 122      -0.221   2.070  31.368  1.00 37.62           N  
ATOM   2977  CA  ASP C 122       0.852   1.995  30.355  1.00 37.49           C  
ATOM   2978  C   ASP C 122       1.749   3.200  30.332  1.00 37.67           C  
ATOM   2979  O   ASP C 122       1.361   4.336  30.605  1.00 37.50           O  
ATOM   2980  CB  ASP C 122       0.337   1.827  28.925  1.00 37.56           C  
ATOM   2981  CG  ASP C 122      -0.505   0.590  28.732  1.00 38.48           C  
ATOM   2982  OD1 ASP C 122      -0.459  -0.331  29.569  1.00 37.11           O  
ATOM   2983  OD2 ASP C 122      -1.223   0.560  27.717  1.00 41.58           O  
ATOM   2984  N   GLU C 123       2.945   2.922  29.870  1.00 37.76           N  
ATOM   2985  CA  GLU C 123       4.044   3.886  29.893  1.00 38.02           C  
ATOM   2986  C   GLU C 123       3.948   4.772  28.634  1.00 37.90           C  
ATOM   2987  O   GLU C 123       4.070   5.997  28.677  1.00 37.81           O  
ATOM   2988  CB  GLU C 123       5.384   3.127  30.037  1.00 37.94           C  
ATOM   2989  CG  GLU C 123       6.620   3.962  29.895  1.00 38.99           C  
ATOM   2990  CD  GLU C 123       7.922   3.168  30.008  1.00 38.61           C  
ATOM   2991  OE1 GLU C 123       7.996   2.136  30.725  1.00 36.48           O  
ATOM   2992  OE2 GLU C 123       8.913   3.604  29.361  1.00 42.94           O  
ATOM   2993  N   LEU C 124       3.653   4.114  27.530  1.00 37.95           N  
ATOM   2994  CA  LEU C 124       3.535   4.745  26.250  1.00 39.05           C  
ATOM   2995  C   LEU C 124       2.404   4.146  25.439  1.00 39.58           C  
ATOM   2996  O   LEU C 124       1.928   3.038  25.680  1.00 38.88           O  
ATOM   2997  CB  LEU C 124       4.835   4.609  25.427  1.00 39.11           C  
ATOM   2998  CG  LEU C 124       5.975   5.620  25.366  1.00 40.11           C  
ATOM   2999  CD1 LEU C 124       7.057   5.044  24.441  1.00 38.41           C  
ATOM   3000  CD2 LEU C 124       5.514   6.960  24.888  1.00 38.01           C  
ATOM   3001  N   GLY C 125       2.028   4.892  24.429  1.00 40.82           N  
ATOM   3002  CA  GLY C 125       1.160   4.364  23.393  1.00 42.26           C  
ATOM   3003  C   GLY C 125       1.924   3.325  22.587  1.00 43.30           C  
ATOM   3004  O   GLY C 125       3.109   3.106  22.822  1.00 43.39           O  
ATOM   3005  N   PRO C 126       1.254   2.690  21.622  1.00 44.33           N  
ATOM   3006  CA  PRO C 126       1.891   1.821  20.628  1.00 45.15           C  
ATOM   3007  C   PRO C 126       3.096   2.463  19.946  1.00 45.27           C  
ATOM   3008  O   PRO C 126       3.085   3.646  19.647  1.00 44.99           O  
ATOM   3009  CB  PRO C 126       0.797   1.604  19.589  1.00 45.00           C  
ATOM   3010  CG  PRO C 126      -0.266   2.578  19.893  1.00 45.49           C  
ATOM   3011  CD  PRO C 126      -0.166   2.925  21.328  1.00 44.92           C  
ATOM   3012  N   LEU C 127       4.106   1.651  19.691  1.00 45.34           N  
ATOM   3013  CA  LEU C 127       5.357   2.132  19.044  1.00 45.85           C  
ATOM   3014  C   LEU C 127       5.308   1.958  17.547  1.00 45.55           C  
ATOM   3015  O   LEU C 127       4.863   0.939  17.059  1.00 46.29           O  
ATOM   3016  CB  LEU C 127       6.565   1.345  19.543  1.00 44.96           C  
ATOM   3017  CG  LEU C 127       6.997   1.549  20.994  1.00 46.68           C  
ATOM   3018  CD1 LEU C 127       7.970   0.427  21.396  1.00 46.49           C  
ATOM   3019  CD2 LEU C 127       7.651   2.912  21.182  1.00 48.24           C  
ATOM   3020  N   VAL C 128       5.799   2.933  16.809  1.00 45.40           N  
ATOM   3021  CA  VAL C 128       5.872   2.778  15.361  1.00 45.16           C  
ATOM   3022  C   VAL C 128       7.287   3.025  14.856  1.00 44.42           C  
ATOM   3023  O   VAL C 128       8.036   3.826  15.422  1.00 44.78           O  
ATOM   3024  CB  VAL C 128       4.785   3.639  14.641  1.00 45.74           C  
ATOM   3025  CG1 VAL C 128       3.533   3.726  15.528  1.00 46.81           C  
ATOM   3026  CG2 VAL C 128       5.263   4.994  14.309  1.00 44.49           C  
ATOM   3027  N   GLY C 129       7.648   2.224  13.858  1.00 42.96           N  
ATOM   3028  CA  GLY C 129       8.915   2.309  13.148  1.00 42.76           C  
ATOM   3029  C   GLY C 129       8.765   2.951  11.785  1.00 42.58           C  
ATOM   3030  O   GLY C 129       7.720   2.846  11.146  1.00 43.00           O  
ATOM   3031  N   GLN C 130       9.794   3.678  11.386  1.00 41.61           N  
ATOM   3032  CA  GLN C 130       9.884   4.251  10.042  1.00 41.55           C  
ATOM   3033  C   GLN C 130      11.237   4.001   9.484  1.00 40.11           C  
ATOM   3034  O   GLN C 130      12.227   4.166  10.157  1.00 41.38           O  
ATOM   3035  CB  GLN C 130       9.732   5.764  10.078  1.00 42.14           C  
ATOM   3036  CG  GLN C 130       8.475   6.306  10.597  1.00 44.43           C  
ATOM   3037  CD  GLN C 130       8.649   7.810  10.759  1.00 47.82           C  
ATOM   3038  OE1 GLN C 130       8.752   8.298  11.873  1.00 47.40           O  
ATOM   3039  NE2 GLN C 130       8.791   8.527   9.641  1.00 46.97           N  
ATOM   3040  N   LEU C 131      11.292   3.622   8.231  1.00 39.26           N  
ATOM   3041  CA  LEU C 131      12.575   3.519   7.556  1.00 38.30           C  
ATOM   3042  C   LEU C 131      12.754   4.825   6.762  1.00 37.36           C  
ATOM   3043  O   LEU C 131      11.989   5.124   5.863  1.00 35.78           O  
ATOM   3044  CB  LEU C 131      12.601   2.313   6.635  1.00 38.55           C  
ATOM   3045  CG  LEU C 131      13.923   1.965   5.932  1.00 39.44           C  
ATOM   3046  CD1 LEU C 131      14.992   1.532   6.947  1.00 39.72           C  
ATOM   3047  CD2 LEU C 131      13.682   0.839   4.954  1.00 38.46           C  
ATOM   3048  N   VAL C 132      13.767   5.583   7.144  1.00 36.09           N  
ATOM   3049  CA  VAL C 132      14.060   6.901   6.541  1.00 34.91           C  
ATOM   3050  C   VAL C 132      15.529   6.917   6.129  1.00 34.62           C  
ATOM   3051  O   VAL C 132      16.360   6.125   6.632  1.00 33.61           O  
ATOM   3052  CB  VAL C 132      13.701   8.040   7.516  1.00 36.07           C  
ATOM   3053  CG1 VAL C 132      14.392   9.374   7.142  1.00 33.20           C  
ATOM   3054  CG2 VAL C 132      12.161   8.206   7.575  1.00 34.73           C  
ATOM   3055  N   VAL C 133      15.840   7.746   5.147  1.00 34.28           N  
ATOM   3056  CA  VAL C 133      17.253   8.022   4.801  1.00 33.49           C  
ATOM   3057  C   VAL C 133      17.515   9.501   4.830  1.00 34.17           C  
ATOM   3058  O   VAL C 133      16.650  10.305   4.518  1.00 35.71           O  
ATOM   3059  CB  VAL C 133      17.708   7.348   3.431  1.00 33.55           C  
ATOM   3060  CG1 VAL C 133      17.677   5.816   3.554  1.00 32.25           C  
ATOM   3061  CG2 VAL C 133      16.817   7.789   2.256  1.00 30.25           C  
ATOM   3062  N   ALA C 134      18.737   9.852   5.191  1.00 35.56           N  
ATOM   3063  CA  ALA C 134      19.147  11.258   5.308  1.00 35.69           C  
ATOM   3064  C   ALA C 134      20.495  11.576   4.688  1.00 35.65           C  
ATOM   3065  O   ALA C 134      21.407  10.768   4.669  1.00 36.50           O  
ATOM   3066  CB  ALA C 134      19.120  11.710   6.759  1.00 35.41           C  
ATOM   3067  N   THR C 135      20.552  12.749   4.092  1.00 35.87           N  
ATOM   3068  CA  THR C 135      21.815  13.401   3.717  1.00 36.84           C  
ATOM   3069  C   THR C 135      21.939  14.628   4.580  1.00 36.73           C  
ATOM   3070  O   THR C 135      21.120  15.537   4.518  1.00 36.40           O  
ATOM   3071  CB  THR C 135      21.906  13.844   2.288  1.00 36.89           C  
ATOM   3072  OG1 THR C 135      21.568  12.759   1.416  1.00 37.30           O  
ATOM   3073  CG2 THR C 135      23.383  14.294   1.962  1.00 37.79           C  
ATOM   3074  N   ASN C 136      22.984  14.618   5.387  1.00 36.67           N  
ATOM   3075  CA  ASN C 136      23.280  15.717   6.308  1.00 36.22           C  
ATOM   3076  C   ASN C 136      24.559  16.364   5.836  1.00 36.29           C  
ATOM   3077  O   ASN C 136      25.535  15.685   5.695  1.00 38.17           O  
ATOM   3078  CB  ASN C 136      23.461  15.188   7.700  1.00 35.76           C  
ATOM   3079  CG  ASN C 136      22.190  14.556   8.267  1.00 36.43           C  
ATOM   3080  OD1 ASN C 136      21.103  14.994   7.955  1.00 35.54           O  
ATOM   3081  ND2 ASN C 136      22.336  13.516   9.089  1.00 35.91           N  
ATOM   3082  N   VAL C 137      24.526  17.661   5.537  1.00 35.52           N  
ATOM   3083  CA  VAL C 137      25.719  18.425   5.207  1.00 35.03           C  
ATOM   3084  C   VAL C 137      26.157  19.285   6.419  1.00 36.08           C  
ATOM   3085  O   VAL C 137      25.348  20.011   6.991  1.00 35.89           O  
ATOM   3086  CB  VAL C 137      25.453  19.345   3.986  1.00 35.47           C  
ATOM   3087  CG1 VAL C 137      26.752  20.051   3.499  1.00 30.82           C  
ATOM   3088  CG2 VAL C 137      24.784  18.542   2.882  1.00 34.85           C  
ATOM   3089  N   PHE C 138      27.431  19.122   6.797  1.00 35.91           N  
ATOM   3090  CA  PHE C 138      28.088  19.821   7.907  1.00 35.86           C  
ATOM   3091  C   PHE C 138      29.151  20.730   7.366  1.00 36.94           C  
ATOM   3092  O   PHE C 138      29.799  20.480   6.320  1.00 38.03           O  
ATOM   3093  CB  PHE C 138      28.751  18.858   8.926  1.00 36.03           C  
ATOM   3094  CG  PHE C 138      27.804  17.952   9.600  1.00 34.43           C  
ATOM   3095  CD1 PHE C 138      27.388  16.777   8.986  1.00 36.08           C  
ATOM   3096  CD2 PHE C 138      27.299  18.270  10.846  1.00 35.41           C  
ATOM   3097  CE1 PHE C 138      26.492  15.933   9.612  1.00 34.62           C  
ATOM   3098  CE2 PHE C 138      26.398  17.444  11.479  1.00 35.06           C  
ATOM   3099  CZ  PHE C 138      25.976  16.297  10.869  1.00 36.56           C  
ATOM   3100  N   ARG C 139      29.318  21.805   8.115  1.00 37.96           N  
ATOM   3101  CA  ARG C 139      30.309  22.828   7.842  1.00 39.37           C  
ATOM   3102  C   ARG C 139      31.285  22.984   9.009  1.00 39.26           C  
ATOM   3103  O   ARG C 139      30.896  23.035  10.178  1.00 39.17           O  
ATOM   3104  CB  ARG C 139      29.539  24.122   7.631  1.00 40.25           C  
ATOM   3105  CG  ARG C 139      30.261  25.132   6.968  1.00 42.25           C  
ATOM   3106  CD  ARG C 139      30.537  24.748   5.552  1.00 44.86           C  
ATOM   3107  NE  ARG C 139      31.695  25.533   5.192  1.00 43.44           N  
ATOM   3108  CZ  ARG C 139      32.191  25.644   3.981  1.00 46.13           C  
ATOM   3109  NH1 ARG C 139      31.629  25.005   2.956  1.00 48.06           N  
ATOM   3110  NH2 ARG C 139      33.243  26.416   3.808  1.00 44.36           N  
ATOM   3111  N   ARG C 140      32.566  23.013   8.680  1.00 39.92           N  
ATOM   3112  CA  ARG C 140      33.620  23.186   9.694  1.00 40.12           C  
ATOM   3113  C   ARG C 140      33.604  24.605  10.202  1.00 40.61           C  
ATOM   3114  O   ARG C 140      33.717  25.534   9.416  1.00 41.52           O  
ATOM   3115  CB  ARG C 140      34.988  22.853   9.105  1.00 40.42           C  
ATOM   3116  CG  ARG C 140      36.164  23.099  10.030  1.00 40.70           C  
ATOM   3117  CD  ARG C 140      37.522  22.873   9.301  1.00 41.38           C  
ATOM   3118  NE  ARG C 140      38.012  21.539   9.622  1.00 42.87           N  
ATOM   3119  CZ  ARG C 140      38.234  20.585   8.739  1.00 43.46           C  
ATOM   3120  NH1 ARG C 140      38.079  20.842   7.465  1.00 42.88           N  
ATOM   3121  NH2 ARG C 140      38.654  19.388   9.140  1.00 45.47           N  
ATOM   3122  N   THR C 141      33.444  24.749  11.519  1.00 41.27           N  
ATOM   3123  CA  THR C 141      33.546  26.048  12.226  1.00 41.25           C  
ATOM   3124  C   THR C 141      34.476  25.995  13.460  1.00 42.41           C  
ATOM   3125  O   THR C 141      34.818  24.924  13.960  1.00 43.28           O  
ATOM   3126  CB  THR C 141      32.179  26.522  12.744  1.00 41.00           C  
ATOM   3127  OG1 THR C 141      31.929  25.920  14.017  1.00 39.11           O  
ATOM   3128  CG2 THR C 141      31.045  26.173  11.755  1.00 40.17           C  
ATOM   3129  N   PRO C 142      34.866  27.159  13.984  1.00 42.60           N  
ATOM   3130  CA  PRO C 142      35.730  27.170  15.147  1.00 43.16           C  
ATOM   3131  C   PRO C 142      35.109  26.441  16.313  1.00 43.95           C  
ATOM   3132  O   PRO C 142      35.796  25.974  17.209  1.00 43.91           O  
ATOM   3133  CB  PRO C 142      35.852  28.650  15.465  1.00 43.19           C  
ATOM   3134  CG  PRO C 142      35.705  29.316  14.147  1.00 42.88           C  
ATOM   3135  CD  PRO C 142      34.653  28.508  13.443  1.00 42.82           C  
ATOM   3136  N   ASP C 143      33.799  26.314  16.270  1.00 44.61           N  
ATOM   3137  CA  ASP C 143      33.062  25.744  17.383  1.00 45.06           C  
ATOM   3138  C   ASP C 143      32.669  24.351  17.025  1.00 44.37           C  
ATOM   3139  O   ASP C 143      31.788  23.772  17.623  1.00 44.81           O  
ATOM   3140  CB  ASP C 143      31.810  26.564  17.692  1.00 46.08           C  
ATOM   3141  CG  ASP C 143      32.124  27.891  18.371  1.00 49.39           C  
ATOM   3142  OD1 ASP C 143      33.315  28.289  18.478  1.00 54.68           O  
ATOM   3143  OD2 ASP C 143      31.163  28.557  18.813  1.00 55.42           O  
ATOM   3144  N   GLY C 144      33.317  23.824  16.001  1.00 43.94           N  
ATOM   3145  CA  GLY C 144      33.043  22.459  15.545  1.00 42.60           C  
ATOM   3146  C   GLY C 144      32.162  22.378  14.328  1.00 41.69           C  
ATOM   3147  O   GLY C 144      31.784  23.376  13.726  1.00 41.89           O  
ATOM   3148  N   TRP C 145      31.837  21.158  13.967  1.00 40.36           N  
ATOM   3149  CA  TRP C 145      31.058  20.927  12.773  1.00 39.77           C  
ATOM   3150  C   TRP C 145      29.595  21.188  13.020  1.00 39.37           C  
ATOM   3151  O   TRP C 145      28.969  20.622  13.931  1.00 39.71           O  
ATOM   3152  CB  TRP C 145      31.249  19.506  12.239  1.00 39.21           C  
ATOM   3153  CG  TRP C 145      32.655  19.193  11.732  1.00 38.61           C  
ATOM   3154  CD1 TRP C 145      33.701  18.736  12.481  1.00 37.22           C  
ATOM   3155  CD2 TRP C 145      33.147  19.283  10.376  1.00 39.02           C  
ATOM   3156  NE1 TRP C 145      34.803  18.542  11.690  1.00 37.32           N  
ATOM   3157  CE2 TRP C 145      34.498  18.865  10.395  1.00 39.32           C  
ATOM   3158  CE3 TRP C 145      32.587  19.687   9.159  1.00 37.82           C  
ATOM   3159  CZ2 TRP C 145      35.296  18.835   9.244  1.00 38.21           C  
ATOM   3160  CZ3 TRP C 145      33.370  19.640   8.023  1.00 38.27           C  
ATOM   3161  CH2 TRP C 145      34.719  19.211   8.070  1.00 37.34           C  
ATOM   3162  N   LYS C 146      29.049  22.037  12.172  1.00 39.20           N  
ATOM   3163  CA  LYS C 146      27.670  22.456  12.291  1.00 39.91           C  
ATOM   3164  C   LYS C 146      26.823  22.120  11.066  1.00 39.45           C  
ATOM   3165  O   LYS C 146      27.299  22.165   9.939  1.00 38.92           O  
ATOM   3166  CB  LYS C 146      27.668  23.968  12.501  1.00 40.79           C  
ATOM   3167  CG  LYS C 146      28.488  24.441  13.689  1.00 41.31           C  
ATOM   3168  CD  LYS C 146      27.632  24.665  14.890  1.00 41.48           C  
ATOM   3169  CE  LYS C 146      28.322  25.555  15.881  1.00 42.73           C  
ATOM   3170  NZ  LYS C 146      28.539  24.843  17.174  1.00 44.47           N  
ATOM   3171  N   LEU C 147      25.559  21.802  11.311  1.00 38.66           N  
ATOM   3172  CA  LEU C 147      24.596  21.534  10.222  1.00 38.19           C  
ATOM   3173  C   LEU C 147      24.270  22.706   9.335  1.00 37.80           C  
ATOM   3174  O   LEU C 147      23.819  23.765   9.785  1.00 38.60           O  
ATOM   3175  CB  LEU C 147      23.269  21.030  10.751  1.00 38.32           C  
ATOM   3176  CG  LEU C 147      23.172  19.549  11.053  1.00 39.60           C  
ATOM   3177  CD1 LEU C 147      21.864  19.275  11.842  1.00 38.57           C  
ATOM   3178  CD2 LEU C 147      23.324  18.725   9.787  1.00 35.04           C  
ATOM   3179  N   TRP C 148      24.446  22.452   8.053  1.00 37.98           N  
ATOM   3180  CA  TRP C 148      24.088  23.372   6.975  1.00 36.76           C  
ATOM   3181  C   TRP C 148      22.775  22.897   6.331  1.00 37.14           C  
ATOM   3182  O   TRP C 148      21.869  23.701   6.084  1.00 37.78           O  
ATOM   3183  CB  TRP C 148      25.236  23.440   5.979  1.00 36.74           C  
ATOM   3184  CG  TRP C 148      25.135  24.437   4.842  1.00 35.56           C  
ATOM   3185  CD1 TRP C 148      24.212  25.420   4.687  1.00 38.19           C  
ATOM   3186  CD2 TRP C 148      26.038  24.567   3.743  1.00 36.82           C  
ATOM   3187  NE1 TRP C 148      24.470  26.155   3.545  1.00 36.71           N  
ATOM   3188  CE2 TRP C 148      25.579  25.639   2.942  1.00 36.62           C  
ATOM   3189  CE3 TRP C 148      27.180  23.871   3.341  1.00 37.52           C  
ATOM   3190  CZ2 TRP C 148      26.224  26.026   1.777  1.00 36.27           C  
ATOM   3191  CZ3 TRP C 148      27.824  24.273   2.201  1.00 36.96           C  
ATOM   3192  CH2 TRP C 148      27.341  25.337   1.424  1.00 36.12           C  
ATOM   3193  N   SER C 149      22.684  21.590   6.086  1.00 36.64           N  
ATOM   3194  CA  SER C 149      21.480  20.929   5.525  1.00 36.98           C  
ATOM   3195  C   SER C 149      21.170  19.576   6.157  1.00 35.92           C  
ATOM   3196  O   SER C 149      22.063  18.844   6.533  1.00 34.91           O  
ATOM   3197  CB  SER C 149      21.578  20.771   4.011  1.00 37.83           C  
ATOM   3198  OG  SER C 149      20.529  19.962   3.468  1.00 40.79           O  
ATOM   3199  N   HIS C 150      19.875  19.332   6.346  1.00 35.57           N  
ATOM   3200  CA  HIS C 150      19.342  18.020   6.701  1.00 36.29           C  
ATOM   3201  C   HIS C 150      18.215  17.703   5.745  1.00 36.44           C  
ATOM   3202  O   HIS C 150      17.245  18.390   5.723  1.00 37.04           O  
ATOM   3203  CB  HIS C 150      18.805  17.987   8.133  1.00 35.92           C  
ATOM   3204  CG  HIS C 150      18.140  16.688   8.516  1.00 37.02           C  
ATOM   3205  ND1 HIS C 150      16.795  16.589   8.837  1.00 37.05           N  
ATOM   3206  CD2 HIS C 150      18.655  15.449   8.680  1.00 32.39           C  
ATOM   3207  CE1 HIS C 150      16.513  15.334   9.126  1.00 34.57           C  
ATOM   3208  NE2 HIS C 150      17.619  14.619   9.018  1.00 36.01           N  
ATOM   3209  N   HIS C 151      18.391  16.689   4.917  1.00 36.04           N  
ATOM   3210  CA  HIS C 151      17.335  16.200   4.062  1.00 35.01           C  
ATOM   3211  C   HIS C 151      17.036  14.761   4.403  1.00 35.15           C  
ATOM   3212  O   HIS C 151      17.873  13.902   4.235  1.00 36.17           O  
ATOM   3213  CB  HIS C 151      17.754  16.298   2.608  1.00 35.55           C  
ATOM   3214  CG  HIS C 151      16.617  16.246   1.647  1.00 33.62           C  
ATOM   3215  ND1 HIS C 151      16.521  17.101   0.576  1.00 32.61           N  
ATOM   3216  CD2 HIS C 151      15.532  15.443   1.584  1.00 34.25           C  
ATOM   3217  CE1 HIS C 151      15.409  16.840  -0.091  1.00 34.08           C  
ATOM   3218  NE2 HIS C 151      14.786  15.839   0.500  1.00 30.83           N  
ATOM   3219  N   ALA C 152      15.824  14.515   4.861  1.00 35.28           N  
ATOM   3220  CA  ALA C 152      15.377  13.172   5.225  1.00 36.88           C  
ATOM   3221  C   ALA C 152      14.104  12.790   4.472  1.00 36.05           C  
ATOM   3222  O   ALA C 152      13.257  13.603   4.153  1.00 36.06           O  
ATOM   3223  CB  ALA C 152      15.200  13.005   6.767  1.00 35.72           C  
ATOM   3224  N   SER C 153      14.056  11.520   4.119  1.00 35.69           N  
ATOM   3225  CA  SER C 153      13.022  11.006   3.259  1.00 35.56           C  
ATOM   3226  C   SER C 153      12.676   9.550   3.544  1.00 35.54           C  
ATOM   3227  O   SER C 153      13.529   8.760   3.951  1.00 35.39           O  
ATOM   3228  CB  SER C 153      13.464  11.202   1.799  1.00 36.12           C  
ATOM   3229  OG  SER C 153      14.611  10.438   1.488  1.00 36.90           O  
ATOM   3230  N   PRO C 154      11.404   9.179   3.323  1.00 35.45           N  
ATOM   3231  CA  PRO C 154      10.996   7.801   3.521  1.00 35.74           C  
ATOM   3232  C   PRO C 154      11.524   6.914   2.407  1.00 36.21           C  
ATOM   3233  O   PRO C 154      11.676   7.347   1.280  1.00 34.85           O  
ATOM   3234  CB  PRO C 154       9.481   7.880   3.454  1.00 35.10           C  
ATOM   3235  CG  PRO C 154       9.255   9.025   2.489  1.00 36.97           C  
ATOM   3236  CD  PRO C 154      10.303  10.030   2.873  1.00 35.63           C  
ATOM   3237  N   VAL C 155      11.895   5.703   2.782  1.00 37.96           N  
ATOM   3238  CA  VAL C 155      12.204   4.676   1.794  1.00 38.77           C  
ATOM   3239  C   VAL C 155      10.882   3.952   1.496  1.00 41.12           C  
ATOM   3240  O   VAL C 155      10.336   3.288   2.346  1.00 41.03           O  
ATOM   3241  CB  VAL C 155      13.292   3.692   2.281  1.00 38.72           C  
ATOM   3242  CG1 VAL C 155      13.607   2.631   1.161  1.00 35.18           C  
ATOM   3243  CG2 VAL C 155      14.545   4.426   2.685  1.00 35.72           C  
ATOM   3244  N   LEU C 156      10.370   4.165   0.291  1.00 43.28           N  
ATOM   3245  CA  LEU C 156       9.053   3.719  -0.105  1.00 45.02           C  
ATOM   3246  C   LEU C 156       9.274   2.507  -0.919  1.00 47.41           C  
ATOM   3247  O   LEU C 156       8.387   1.682  -1.108  1.00 48.75           O  
ATOM   3248  CB  LEU C 156       8.328   4.795  -0.926  1.00 44.76           C  
ATOM   3249  CG  LEU C 156       8.110   6.054  -0.093  1.00 44.11           C  
ATOM   3250  CD1 LEU C 156       7.566   7.251  -0.933  1.00 42.37           C  
ATOM   3251  CD2 LEU C 156       7.209   5.721   1.083  1.00 43.99           C  
ATOM   3252  N   ALA C 157      10.509   2.414  -1.379  1.00 49.92           N  
ATOM   3253  CA  ALA C 157      11.029   1.229  -2.079  1.00 51.57           C  
ATOM   3254  C   ALA C 157      11.728   1.615  -3.376  1.00 52.63           C  
ATOM   3255  O   ALA C 157      12.968   1.736  -3.380  1.00 54.11           O  
ATOM   3256  CB  ALA C 157       9.939   0.204  -2.329  1.00 51.99           C  
TER    3257      ALA C 157                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
