
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  291 ( 2195),  selected  291 , name 3bio_B
# Molecule2: number of CA atoms  320 ( 2378),  selected  320 , name T0452.pdb
# PARAMETERS: 3bio_B.T0452.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     5_B      -       -           -
LGA    K     6_B      M       1          4.019
LGA    I     7_B      I       2          1.887
LGA    R     8_B      K       3          2.057
LGA    A     9_B      I       4          1.128
LGA    A    10_B      A       5          1.419
LGA    I    11_B      I       6          0.593
LGA    V    12_B      V       7          0.859
LGA    G    13_B      G       8          1.517
LGA    Y    14_B      F       9          1.313
LGA    G    15_B      G      10          2.092
LGA    N    16_B      T      11          2.182
LGA    I    17_B      V      12          1.744
LGA    G    18_B      G      13          1.184
LGA    R    19_B      Q      14          1.385
LGA    Y    20_B      G      15          1.263
LGA    A    21_B      V      16          1.705
LGA    L    22_B      A      17          1.530
LGA    Q    23_B      E      18          1.744
LGA    A    24_B      L      19          2.377
LGA    L    25_B      L      20          2.106
LGA    R    26_B      I      21          1.923
LGA    E    27_B      R      22          3.016
LGA    A    28_B      K      23          3.827
LGA    P    29_B      R      24          2.882
LGA    -       -      E      25           -
LGA    -       -      E      26           -
LGA    -       -      I      27           -
LGA    D    30_B      E      28          2.290
LGA    -       -      K      29           -
LGA    -       -      A      30           -
LGA    -       -      I      31           -
LGA    -       -      G      32           -
LGA    -       -      E      33           -
LGA    F    31_B      F      34          3.078
LGA    E    32_B      K      35          2.172
LGA    I    33_B      V      36          2.098
LGA    A    34_B      T      37          1.756
LGA    G    35_B      A      38          2.668
LGA    I    36_B      V      39          0.584
LGA    V    37_B      A      40          2.045
LGA    R    38_B      D      41          2.785
LGA    R    39_B      S      42          3.341
LGA    N    40_B      K      43          1.204
LGA    P    41_B      S      44          3.037
LGA    -       -      S      45           -
LGA    A    42_B      I      46           #
LGA    Q    49_B      S      47           -
LGA    -       -      G      48           -
LGA    -       -      D      49           -
LGA    -       -      F      50           -
LGA    -       -      S      51           -
LGA    -       -      L      52           -
LGA    -       -      V      53           -
LGA    P    50_B      E      54          1.433
LGA    F    51_B      A      55          3.469
LGA    R    52_B      L      56           -
LGA    -       -      R      57           -
LGA    -       -      M      58           -
LGA    -       -      K      59           -
LGA    -       -      R      60           -
LGA    -       -      E      61           -
LGA    -       -      T      62           -
LGA    -       -      G      63           -
LGA    -       -      M      64           -
LGA    -       -      L      65           -
LGA    V    53_B      R      66          4.727
LGA    -       -      D      67           -
LGA    -       -      D      68           -
LGA    V    54_B      A      69          4.975
LGA    S    55_B      K      70          2.764
LGA    -       -      A      71           -
LGA    -       -      I      72           -
LGA    D    56_B      E      73          2.915
LGA    I    57_B      V      74          1.954
LGA    -       -      V      75           -
LGA    -       -      R      76           -
LGA    E    58_B      S      77          2.891
LGA    Q    59_B      A      78          4.950
LGA    L    60_B      -       -           -
LGA    E    61_B      -       -           -
LGA    S    62_B      D      79          4.117
LGA    V    63_B      Y      80          1.949
LGA    D    64_B      D      81          1.979
LGA    V    65_B      V      82          1.410
LGA    A    66_B      L      83          1.319
LGA    L    67_B      I      84          0.444
LGA    V    68_B      E      85          1.013
LGA    C    69_B      A      86          1.139
LGA    S    70_B      S      87          1.833
LGA    -       -      V      88           -
LGA    P    71_B      T      89          3.141
LGA    S    72_B      R      90           -
LGA    R    73_B      -       -           -
LGA    E    74_B      E      95          2.676
LGA    V    75_B      G      96          2.437
LGA    E    76_B      V      97          2.183
LGA    R    77_B      N      98          0.711
LGA    T    78_B      Y      99          0.741
LGA    A    79_B      I     100          1.849
LGA    L    80_B      R     101          2.185
LGA    E    81_B      E     102          2.088
LGA    I    82_B      A     103          2.326
LGA    L    83_B      L     104          3.009
LGA    K    84_B      K     105          3.364
LGA    K    85_B      R     106          3.369
LGA    G    86_B      G     107          3.727
LGA    I    87_B      K     108          3.077
LGA    C    88_B      H     109          2.482
LGA    T    89_B      V     110          1.879
LGA    A    90_B      V     111          1.518
LGA    D    91_B      T     112          1.406
LGA    S    92_B      S     113          2.218
LGA    F    93_B      N     114          3.225
LGA    D    94_B      K     115          1.831
LGA    I    95_B      G     116          4.535
LGA    -       -      P     117           -
LGA    H    96_B      L     118           #
LGA    D    97_B      V     119          4.064
LGA    G    98_B      A     120          3.523
LGA    -       -      E     121           -
LGA    I    99_B      F     122          2.190
LGA    L   100_B      H     123          2.169
LGA    A   101_B      G     124          2.898
LGA    L   102_B      L     125          2.368
LGA    R   103_B      M     126          1.444
LGA    R   104_B      S     127          2.567
LGA    S   105_B      L     128          3.623
LGA    L   106_B      A     129          3.935
LGA    G   107_B      E     130          3.484
LGA    D   108_B      R     131          3.440
LGA    A   109_B      -       -           -
LGA    A   110_B      -       -           -
LGA    G   111_B      N     132          1.366
LGA    K   112_B      -       -           -
LGA    S   113_B      -       -           -
LGA    G   114_B      -       -           -
LGA    A   115_B      G     133          4.614
LGA    A   116_B      V     134          1.398
LGA    A   117_B      R     135          2.988
LGA    V   118_B      L     136          1.904
LGA    I   119_B      M     137          3.228
LGA    A   120_B      Y     138          2.564
LGA    S   121_B      E     139          2.750
LGA    G   122_B      A     140          0.762
LGA    -       -      T     141           -
LGA    W   123_B      V     142          3.837
LGA    D   124_B      G     143          3.607
LGA    P   125_B      G     144           -
LGA    -       -      A     145           -
LGA    G   126_B      M     146           #
LGA    S   127_B      P     147          3.199
LGA    D   128_B      V     148          1.142
LGA    S   129_B      V     149          2.416
LGA    V   130_B      K     150          2.872
LGA    V   131_B      L     151          2.810
LGA    R   132_B      A     152          3.905
LGA    T   133_B      -       -           -
LGA    L   134_B      K     153           #
LGA    X   135_B      R     154           -
LGA    -       -      Y     155           -
LGA    -       -      L     156           -
LGA    -       -      A     157           -
LGA    -       -      L     158           -
LGA    Q   136_B      C     159           #
LGA    A   137_B      -       -           -
LGA    I   138_B      E     160           #
LGA    V   139_B      I     161           #
LGA    P   140_B      E     162           #
LGA    K   141_B      -       -           -
LGA    G   142_B      -       -           -
LGA    I   143_B      S     163          4.302
LGA    T   144_B      V     164          3.068
LGA    Y   145_B      K     165          1.217
LGA    T   146_B      G     166          0.853
LGA    N   147_B      I     167          1.447
LGA    F   148_B      F     168          2.981
LGA    -       -      N     169           -
LGA    G   149_B      G     170          2.354
LGA    -       -      T     171           -
LGA    -       -      C     172           -
LGA    -       -      N     173           -
LGA    P   150_B      Y     174          2.917
LGA    G   151_B      I     175           -
LGA    X   152_B      L     176           -
LGA    S   153_B      S     177           -
LGA    X   154_B      R     178           -
LGA    G   155_B      M     179           -
LGA    -       -      E     180           -
LGA    -       -      E     181           -
LGA    -       -      E     182           -
LGA    -       -      R     183           -
LGA    -       -      L     184           -
LGA    -       -      P     185           -
LGA    -       -      Y     186           -
LGA    -       -      E     187           -
LGA    -       -      H     188           -
LGA    -       -      I     189           -
LGA    -       -      L     190           -
LGA    -       -      K     191           -
LGA    -       -      E     192           -
LGA    -       -      A     193           -
LGA    -       -      Q     194           -
LGA    -       -      E     195           -
LGA    -       -      L     196           -
LGA    -       -      G     197           -
LGA    -       -      Y     198           -
LGA    -       -      A     199           -
LGA    -       -      E     200           -
LGA    -       -      A     201           -
LGA    -       -      D     202           -
LGA    -       -      P     203           -
LGA    H   156_B      S     204          3.395
LGA    T   157_B      Y     205          3.674
LGA    V   158_B      -       -           -
LGA    A   159_B      -       -           -
LGA    V   160_B      -       -           -
LGA    K   161_B      -       -           -
LGA    A   162_B      -       -           -
LGA    I   163_B      -       -           -
LGA    D   164_B      -       -           -
LGA    G   165_B      -       -           -
LGA    V   166_B      -       -           -
LGA    K   167_B      -       -           -
LGA    A   168_B      -       -           -
LGA    A   169_B      -       -           -
LGA    L   170_B      -       -           -
LGA    S   171_B      D     206          4.211
LGA    X   172_B      -       -           -
LGA    T   173_B      -       -           -
LGA    I   174_B      -       -           -
LGA    P   175_B      -       -           -
LGA    L   176_B      -       -           -
LGA    G   177_B      -       -           -
LGA    T   178_B      -       -           -
LGA    G   179_B      -       -           -
LGA    V   180_B      -       -           -
LGA    H   181_B      -       -           -
LGA    R   182_B      -       -           -
LGA    R   183_B      V     207          3.528
LGA    X   184_B      -       -           -
LGA    V   185_B      -       -           -
LGA    Y   186_B      -       -           -
LGA    V   187_B      -       -           -
LGA    E   188_B      -       -           -
LGA    L   189_B      -       -           -
LGA    L   190_B      -       -           -
LGA    P   191_B      -       -           -
LGA    G   192_B      -       -           -
LGA    H   193_B      -       -           -
LGA    N   194_B      -       -           -
LGA    L   195_B      -       -           -
LGA    E   196_B      -       -           -
LGA    E   197_B      -       -           -
LGA    V   198_B      -       -           -
LGA    S   199_B      -       -           -
LGA    A   200_B      -       -           -
LGA    A   201_B      -       -           -
LGA    I   202_B      -       -           -
LGA    K   203_B      -       -           -
LGA    A   204_B      -       -           -
LGA    D   205_B      -       -           -
LGA    E   206_B      -       -           -
LGA    Y   207_B      E     208          4.048
LGA    F   208_B      G     209           #
LGA    V   209_B      I     210           -
LGA    -       -      D     211           -
LGA    -       -      A     212           -
LGA    -       -      A     213           -
LGA    -       -      L     214           -
LGA    -       -      K     215           -
LGA    -       -      L     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -
LGA    -       -      I     219           -
LGA    -       -      A     220           -
LGA    -       -      N     221           -
LGA    -       -      T     222           -
LGA    -       -      I     223           -
LGA    -       -      G     224           -
LGA    -       -      V     225           -
LGA    -       -      K     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      Y     229           -
LGA    -       -      E     230           -
LGA    -       -      D     231           -
LGA    -       -      V     232           -
LGA    -       -      E     233           -
LGA    -       -      V     234           -
LGA    H   210_B      T     235          2.182
LGA    D   211_B      G     236          2.798
LGA    E   212_B      I     237          3.174
LGA    T   213_B      T     238          0.937
LGA    H   214_B      Q     239          5.030
LGA    V   215_B      I     240           -
LGA    I   216_B      T     241           -
LGA    Q   217_B      P     242           -
LGA    V   218_B      E     243           -
LGA    D   219_B      A     244           -
LGA    E   220_B      F     245           -
LGA    V   221_B      Q     246           -
LGA    D   222_B      V     247           -
LGA    A   223_B      A     248           -
LGA    L   224_B      A     249           -
LGA    I   225_B      E     250           -
LGA    D   226_B      K     251           -
LGA    X   227_B      G     252           -
LGA    -       -      Y     253           -
LGA    -       -      T     254           -
LGA    -       -      I     255           -
LGA    -       -      R     256           -
LGA    -       -      L     257           -
LGA    -       -      I     258           -
LGA    -       -      A     259           -
LGA    -       -      E     260           -
LGA    -       -      V     261           -
LGA    -       -      S     262           -
LGA    -       -      R     263           -
LGA    -       -      E     264           -
LGA    -       -      K     265           -
LGA    -       -      L     266           -
LGA    -       -      K     267           -
LGA    -       -      V     268           -
LGA    -       -      S     269           -
LGA    -       -      P     270           -
LGA    -       -      R     271           -
LGA    -       -      L     272           -
LGA    -       -      V     273           -
LGA    -       -      P     274           -
LGA    -       -      F     275           -
LGA    -       -      H     276           -
LGA    -       -      H     277           -
LGA    -       -      P     278           -
LGA    -       -      L     279           -
LGA    -       -      A     280           -
LGA    -       -      I     281           -
LGA    -       -      K     282           -
LGA    G   228_B      G     283           #
LGA    H   229_B      T     284          3.698
LGA    G   230_B      M     285          2.271
LGA    V   231_B      N     286          1.023
LGA    R   232_B      A     287          1.662
LGA    X   233_B      A     288          1.542
LGA    V   234_B      M     289          2.338
LGA    R   235_B      F     290          4.304
LGA    K   236_B      K     291           #
LGA    G   237_B      -       -           -
LGA    V   238_B      T     292           #
LGA    S   239_B      D     293          5.384
LGA    G   240_B      T     294           #
LGA    S   241_B      A     295           -
LGA    T   242_B      -       -           -
LGA    Q   243_B      -       -           -
LGA    N   244_B      -       -           -
LGA    Q   245_B      G     296          5.065
LGA    R   246_B      S     297          4.648
LGA    X   247_B      I     298          3.692
LGA    S   248_B      F     299          1.950
LGA    F   249_B      V     300          1.167
LGA    D   250_B      A     301          1.023
LGA    X   251_B      G     302          0.448
LGA    E   252_B      R     303          3.113
LGA    I   253_B      G     304           #
LGA    N   254_B      A     305          4.407
LGA    N   255_B      G     306          2.897
LGA    P   256_B      K     307          3.614
LGA    A   257_B      E     308          2.479
LGA    L   258_B      E     309          2.178
LGA    T   259_B      T     310          2.161
LGA    G   260_B      A     311          1.946
LGA    Q   261_B      S     312          2.187
LGA    V   262_B      A     313          1.899
LGA    L   263_B      I     314          1.864
LGA    V   264_B      L     315          2.629
LGA    C   265_B      S     316          2.841
LGA    A   266_B      D     317          2.084
LGA    A   267_B      L     318          3.096
LGA    R   268_B      Y     319          3.994
LGA    A   269_B      E     320          3.312
LGA    A   270_B      I     321          3.509
LGA    X   271_B      Y     322          4.522
LGA    R   272_B      -       -           -
LGA    Q   273_B      -       -           -
LGA    Q   274_B      -       -           -
LGA    P   275_B      -       -           -
LGA    G   276_B      -       -           -
LGA    A   277_B      -       -           -
LGA    Y   278_B      -       -           -
LGA    T   279_B      -       -           -
LGA    L   280_B      -       -           -
LGA    Q   281_B      -       -           -
LGA    E   282_B      -       -           -
LGA    I   283_B      -       -           -
LGA    P   284_B      -       -           -
LGA    V   285_B      -       -           -
LGA    I   286_B      -       -           -
LGA    D   287_B      -       -           -
LGA    L   288_B      -       -           -
LGA    L   289_B      -       -           -
LGA    P   290_B      -       -           -
LGA    G   291_B      A     323          4.954
LGA    D   292_B      G     324          3.435
LGA    R   293_B      -       -           -
LGA    E   294_B      -       -           -
LGA    Q   295_B      -       -           -
LGA    W   296_B      -       -           -
LGA    I   297_B      -       -           -
LGA    G   298_B      -       -           -
LGA    K   299_B      -       -           -
LGA    L   300_B      -       -           -
LGA    C   301_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  291  320    5.0    160    2.80    14.38     29.339     5.515

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.594510 * X  +  -0.784932 * Y  +  -0.174467 * Z  +  77.541298
  Y_new =  -0.717258 * X  +   0.419604 * Y  +   0.556303 * Z  + -106.602394
  Z_new =  -0.363453 * X  +   0.455866 * Y  +  -0.812458 * Z  +  98.243942 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.630271   -0.511321  [ DEG:   150.7035    -29.2965 ]
  Theta =   0.371972    2.769621  [ DEG:    21.3124    158.6876 ]
  Phi   =  -2.262892    0.878701  [ DEG:  -129.6542     50.3458 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bio_B                                        
REMARK     2: T0452.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bio_B.T0452.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  291  320   5.0  160   2.80   14.38  29.339
REMARK  ---------------------------------------------------------- 
MOLECULE 3bio_B
HEADER    OXIDOREDUCTASE                          30-NOV-07   3BIO              
TITLE     CRYSTAL STRUCTURE OF OXIDOREDUCTASE (GFO/IDH/MOCA FAMILY              
TITLE    2 MEMBER) FROM PORPHYROMONAS GINGIVALIS W83                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: OXIDOREDUCTASE, GFO/IDH/MOCA FAMILY;                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PORPHYROMONAS GINGIVALIS W83;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: W83;                                                         
SOURCE   5 ATCC: BAA-308;                                                       
SOURCE   6 GENE: PG_0806;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    STRUCTURAL GENOMICS, OXIDOREDUCTASE, MCSG, PSI-2,                     
KEYWDS   2 GFO/IDH/MOCA FAMILY, PROTEIN STRUCTURE INITIATIVE, MIDWEST           
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,R.MULLIGAN,S.MOY,A.JOACHIMIAK,MIDWEST CENTER FOR              
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   25-DEC-07 3BIO    0                                                
JRNL        AUTH   B.NOCEK,R.MULLIGAN,S.MOY,A.JOACHIMIAK                        
JRNL        TITL   CRYSTAL STRUCTURE OF OXIDOREDUCTASE (GFO/IDH/MOCA            
JRNL        TITL 2 FAMILY MEMBER) FROM PORPHYROMONAS GINGIVALIS W83.            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  3BIO A    1   301  UNP    Q7MW40   Q7MW40_PORGI     1    301             
DBREF  3BIO B    1   301  UNP    Q7MW40   Q7MW40_PORGI     1    301             
SEQRES   1 A  304  SER ASN ALA MSE THR ASP ASP LYS LYS ILE ARG ALA ALA          
SEQRES   2 A  304  ILE VAL GLY TYR GLY ASN ILE GLY ARG TYR ALA LEU GLN          
SEQRES   3 A  304  ALA LEU ARG GLU ALA PRO ASP PHE GLU ILE ALA GLY ILE          
SEQRES   4 A  304  VAL ARG ARG ASN PRO ALA GLU VAL PRO PHE GLU LEU GLN          
SEQRES   5 A  304  PRO PHE ARG VAL VAL SER ASP ILE GLU GLN LEU GLU SER          
SEQRES   6 A  304  VAL ASP VAL ALA LEU VAL CYS SER PRO SER ARG GLU VAL          
SEQRES   7 A  304  GLU ARG THR ALA LEU GLU ILE LEU LYS LYS GLY ILE CYS          
SEQRES   8 A  304  THR ALA ASP SER PHE ASP ILE HIS ASP GLY ILE LEU ALA          
SEQRES   9 A  304  LEU ARG ARG SER LEU GLY ASP ALA ALA GLY LYS SER GLY          
SEQRES  10 A  304  ALA ALA ALA VAL ILE ALA SER GLY TRP ASP PRO GLY SER          
SEQRES  11 A  304  ASP SER VAL VAL ARG THR LEU MSE GLN ALA ILE VAL PRO          
SEQRES  12 A  304  LYS GLY ILE THR TYR THR ASN PHE GLY PRO GLY MSE SER          
SEQRES  13 A  304  MSE GLY HIS THR VAL ALA VAL LYS ALA ILE ASP GLY VAL          
SEQRES  14 A  304  LYS ALA ALA LEU SER MSE THR ILE PRO LEU GLY THR GLY          
SEQRES  15 A  304  VAL HIS ARG ARG MSE VAL TYR VAL GLU LEU LEU PRO GLY          
SEQRES  16 A  304  HIS ASN LEU GLU GLU VAL SER ALA ALA ILE LYS ALA ASP          
SEQRES  17 A  304  GLU TYR PHE VAL HIS ASP GLU THR HIS VAL ILE GLN VAL          
SEQRES  18 A  304  ASP GLU VAL ASP ALA LEU ILE ASP MSE GLY HIS GLY VAL          
SEQRES  19 A  304  ARG MSE VAL ARG LYS GLY VAL SER GLY SER THR GLN ASN          
SEQRES  20 A  304  GLN ARG MSE SER PHE ASP MSE GLU ILE ASN ASN PRO ALA          
SEQRES  21 A  304  LEU THR GLY GLN VAL LEU VAL CYS ALA ALA ARG ALA ALA          
SEQRES  22 A  304  MSE ARG GLN GLN PRO GLY ALA TYR THR LEU GLN GLU ILE          
SEQRES  23 A  304  PRO VAL ILE ASP LEU LEU PRO GLY ASP ARG GLU GLN TRP          
SEQRES  24 A  304  ILE GLY LYS LEU CYS                                          
SEQRES   1 B  304  SER ASN ALA MSE THR ASP ASP LYS LYS ILE ARG ALA ALA          
SEQRES   2 B  304  ILE VAL GLY TYR GLY ASN ILE GLY ARG TYR ALA LEU GLN          
SEQRES   3 B  304  ALA LEU ARG GLU ALA PRO ASP PHE GLU ILE ALA GLY ILE          
SEQRES   4 B  304  VAL ARG ARG ASN PRO ALA GLU VAL PRO PHE GLU LEU GLN          
SEQRES   5 B  304  PRO PHE ARG VAL VAL SER ASP ILE GLU GLN LEU GLU SER          
SEQRES   6 B  304  VAL ASP VAL ALA LEU VAL CYS SER PRO SER ARG GLU VAL          
SEQRES   7 B  304  GLU ARG THR ALA LEU GLU ILE LEU LYS LYS GLY ILE CYS          
SEQRES   8 B  304  THR ALA ASP SER PHE ASP ILE HIS ASP GLY ILE LEU ALA          
SEQRES   9 B  304  LEU ARG ARG SER LEU GLY ASP ALA ALA GLY LYS SER GLY          
SEQRES  10 B  304  ALA ALA ALA VAL ILE ALA SER GLY TRP ASP PRO GLY SER          
SEQRES  11 B  304  ASP SER VAL VAL ARG THR LEU MSE GLN ALA ILE VAL PRO          
SEQRES  12 B  304  LYS GLY ILE THR TYR THR ASN PHE GLY PRO GLY MSE SER          
SEQRES  13 B  304  MSE GLY HIS THR VAL ALA VAL LYS ALA ILE ASP GLY VAL          
SEQRES  14 B  304  LYS ALA ALA LEU SER MSE THR ILE PRO LEU GLY THR GLY          
SEQRES  15 B  304  VAL HIS ARG ARG MSE VAL TYR VAL GLU LEU LEU PRO GLY          
SEQRES  16 B  304  HIS ASN LEU GLU GLU VAL SER ALA ALA ILE LYS ALA ASP          
SEQRES  17 B  304  GLU TYR PHE VAL HIS ASP GLU THR HIS VAL ILE GLN VAL          
SEQRES  18 B  304  ASP GLU VAL ASP ALA LEU ILE ASP MSE GLY HIS GLY VAL          
SEQRES  19 B  304  ARG MSE VAL ARG LYS GLY VAL SER GLY SER THR GLN ASN          
SEQRES  20 B  304  GLN ARG MSE SER PHE ASP MSE GLU ILE ASN ASN PRO ALA          
SEQRES  21 B  304  LEU THR GLY GLN VAL LEU VAL CYS ALA ALA ARG ALA ALA          
SEQRES  22 B  304  MSE ARG GLN GLN PRO GLY ALA TYR THR LEU GLN GLU ILE          
SEQRES  23 B  304  PRO VAL ILE ASP LEU LEU PRO GLY ASP ARG GLU GLN TRP          
SEQRES  24 B  304  ILE GLY LYS LEU CYS                                          
HET    MSE  A 135       8                                                       
HET    MSE  A 152       8                                                       
HET    MSE  A 154       8                                                       
HET    MSE  A 172       8                                                       
HET    MSE  A 184       8                                                       
HET    MSE  A 227       8                                                       
HET    MSE  A 233      13                                                       
HET    MSE  A 247       8                                                       
HET    MSE  A 251       8                                                       
HET    MSE  A 271       8                                                       
HET    MSE  B 135       8                                                       
HET    MSE  B 152       8                                                       
HET    MSE  B 154       8                                                       
HET    MSE  B 172       8                                                       
HET    MSE  B 184       8                                                       
HET    MSE  B 227       8                                                       
HET    MSE  B 233      13                                                       
HET    MSE  B 247       8                                                       
HET    MSE  B 251       8                                                       
HET    MSE  B 271       8                                                       
HET    ACT  A3001       4                                                       
HET    EPE  A1001      15                                                       
HET    EPE  B1001      15                                                       
HET    GOL  A5001       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACT ACETATE ION                                                      
HETNAM     EPE 4-(2-HYDROXYETHYL)-1-PIPERAZINE ETHANESULFONIC ACID              
HETNAM     GOL GLYCEROL                                                         
HETSYN     EPE HEPES                                                            
FORMUL   1  MSE    20(C5 H11 N O2 SE)                                           
FORMUL   3  ACT    C2 H3 O2 1-                                                  
FORMUL   4  EPE    2(C8 H18 N2 O4 S)                                            
FORMUL   6  GOL    C3 H8 O3                                                     
FORMUL   7  HOH   *433(H2 O)                                                    
CRYST1   99.268   99.268  356.025  90.00  90.00 120.00 H 3 2        36          
ATOM   2212  N   LYS B   5      52.364  11.540  13.375  1.00 33.63           N  
ATOM   2213  CA  LYS B   5      51.793  10.552  12.405  1.00 33.30           C  
ATOM   2214  C   LYS B   5      50.339  10.831  12.036  1.00 32.64           C  
ATOM   2215  O   LYS B   5      49.735  10.045  11.311  1.00 34.04           O  
ATOM   2216  CB  LYS B   5      51.942   9.121  12.921  1.00 34.20           C  
ATOM   2217  CG  LYS B   5      51.565   8.908  14.385  1.00 36.32           C  
ATOM   2218  CD  LYS B   5      50.066   8.729  14.581  1.00 38.29           C  
ATOM   2219  CE  LYS B   5      49.784   7.742  15.710  1.00 39.55           C  
ATOM   2220  NZ  LYS B   5      50.300   6.370  15.391  1.00 39.54           N  
ATOM   2221  N   LYS B   6      49.781  11.931  12.543  1.00 30.99           N  
ATOM   2222  CA  LYS B   6      48.550  12.509  12.001  1.00 29.78           C  
ATOM   2223  C   LYS B   6      48.745  12.935  10.543  1.00 28.40           C  
ATOM   2224  O   LYS B   6      49.822  13.382  10.157  1.00 27.92           O  
ATOM   2225  CB  LYS B   6      48.158  13.763  12.791  1.00 30.17           C  
ATOM   2226  CG  LYS B   6      47.086  13.589  13.815  1.00 31.98           C  
ATOM   2227  CD  LYS B   6      47.381  12.488  14.772  1.00 33.62           C  
ATOM   2228  CE  LYS B   6      46.517  12.618  16.014  1.00 36.28           C  
ATOM   2229  NZ  LYS B   6      46.821  11.537  16.983  1.00 37.16           N  
ATOM   2230  N   ILE B   7      47.679  12.819   9.762  1.00 26.24           N  
ATOM   2231  CA  ILE B   7      47.578  13.409   8.433  1.00 25.18           C  
ATOM   2232  C   ILE B   7      47.254  14.890   8.611  1.00 24.65           C  
ATOM   2233  O   ILE B   7      46.269  15.240   9.265  1.00 24.04           O  
ATOM   2234  CB  ILE B   7      46.443  12.745   7.597  1.00 24.64           C  
ATOM   2235  CG1 ILE B   7      46.657  11.228   7.495  1.00 24.35           C  
ATOM   2236  CG2 ILE B   7      46.333  13.395   6.213  1.00 25.00           C  
ATOM   2237  CD1 ILE B   7      45.402  10.435   7.098  1.00 23.80           C  
ATOM   2238  N   ARG B   8      48.084  15.746   8.013  1.00 23.77           N  
ATOM   2239  CA  ARG B   8      47.874  17.189   8.033  1.00 24.39           C  
ATOM   2240  C   ARG B   8      47.047  17.637   6.825  1.00 23.41           C  
ATOM   2241  O   ARG B   8      47.505  17.588   5.669  1.00 23.33           O  
ATOM   2242  CB  ARG B   8      49.230  17.912   8.117  1.00 24.28           C  
ATOM   2243  CG  ARG B   8      49.854  17.812   9.509  1.00 25.00           C  
ATOM   2244  CD  ARG B   8      51.134  18.661   9.677  1.00 25.71           C  
ATOM   2245  NE  ARG B   8      50.898  20.084   9.429  1.00 27.15           N  
ATOM   2246  CZ  ARG B   8      50.334  20.935  10.286  1.00 26.75           C  
ATOM   2247  NH1 ARG B   8      49.941  20.535  11.489  1.00 28.28           N  
ATOM   2248  NH2 ARG B   8      50.183  22.208   9.944  1.00 26.61           N  
ATOM   2249  N   ALA B   9      45.822  18.071   7.111  1.00 22.90           N  
ATOM   2250  CA  ALA B   9      44.862  18.414   6.073  1.00 22.57           C  
ATOM   2251  C   ALA B   9      44.524  19.888   6.044  1.00 22.77           C  
ATOM   2252  O   ALA B   9      44.327  20.515   7.089  1.00 23.15           O  
ATOM   2253  CB  ALA B   9      43.566  17.606   6.269  1.00 21.79           C  
ATOM   2254  N   ALA B  10      44.387  20.420   4.832  1.00 22.91           N  
ATOM   2255  CA  ALA B  10      43.876  21.761   4.631  1.00 23.25           C  
ATOM   2256  C   ALA B  10      42.483  21.703   4.024  1.00 23.04           C  
ATOM   2257  O   ALA B  10      42.211  20.845   3.207  1.00 23.66           O  
ATOM   2258  CB  ALA B  10      44.839  22.572   3.709  1.00 23.39           C  
ATOM   2259  N   ILE B  11      41.614  22.631   4.404  1.00 22.68           N  
ATOM   2260  CA  ILE B  11      40.347  22.827   3.711  1.00 23.52           C  
ATOM   2261  C   ILE B  11      40.602  23.955   2.711  1.00 23.55           C  
ATOM   2262  O   ILE B  11      41.113  24.979   3.106  1.00 24.20           O  
ATOM   2263  CB  ILE B  11      39.236  23.300   4.698  1.00 23.56           C  
ATOM   2264  CG1 ILE B  11      38.873  22.190   5.706  1.00 24.63           C  
ATOM   2265  CG2 ILE B  11      38.003  23.812   3.934  1.00 23.28           C  
ATOM   2266  CD1 ILE B  11      38.122  21.000   5.110  1.00 25.48           C  
ATOM   2267  N   VAL B  12      40.232  23.781   1.444  1.00 23.83           N  
ATOM   2268  CA  VAL B  12      40.395  24.821   0.421  1.00 24.45           C  
ATOM   2269  C   VAL B  12      39.012  25.178  -0.065  1.00 24.75           C  
ATOM   2270  O   VAL B  12      38.341  24.333  -0.637  1.00 24.99           O  
ATOM   2271  CB  VAL B  12      41.257  24.293  -0.746  1.00 24.06           C  
ATOM   2272  CG1 VAL B  12      41.393  25.345  -1.876  1.00 24.85           C  
ATOM   2273  CG2 VAL B  12      42.626  23.855  -0.218  1.00 25.05           C  
ATOM   2274  N   GLY B  13      38.577  26.417   0.169  1.00 25.66           N  
ATOM   2275  CA  GLY B  13      37.182  26.816  -0.091  1.00 26.37           C  
ATOM   2276  C   GLY B  13      36.258  26.640   1.120  1.00 26.95           C  
ATOM   2277  O   GLY B  13      35.961  25.521   1.534  1.00 28.98           O  
ATOM   2278  N   TYR B  14      35.797  27.744   1.692  1.00 27.23           N  
ATOM   2279  CA  TYR B  14      34.979  27.687   2.899  1.00 26.65           C  
ATOM   2280  C   TYR B  14      33.530  28.126   2.664  1.00 26.90           C  
ATOM   2281  O   TYR B  14      33.044  29.078   3.275  1.00 26.82           O  
ATOM   2282  CB  TYR B  14      35.629  28.477   4.025  1.00 26.91           C  
ATOM   2283  CG  TYR B  14      35.133  28.057   5.384  1.00 26.94           C  
ATOM   2284  CD1 TYR B  14      35.427  26.801   5.887  1.00 25.71           C  
ATOM   2285  CD2 TYR B  14      34.368  28.908   6.166  1.00 27.50           C  
ATOM   2286  CE1 TYR B  14      34.967  26.394   7.103  1.00 26.15           C  
ATOM   2287  CE2 TYR B  14      33.898  28.509   7.416  1.00 27.25           C  
ATOM   2288  CZ  TYR B  14      34.204  27.250   7.873  1.00 27.68           C  
ATOM   2289  OH  TYR B  14      33.765  26.836   9.107  1.00 28.07           O  
ATOM   2290  N   GLY B  15      32.847  27.401   1.782  1.00 26.25           N  
ATOM   2291  CA  GLY B  15      31.394  27.513   1.612  1.00 26.11           C  
ATOM   2292  C   GLY B  15      30.688  26.470   2.462  1.00 25.63           C  
ATOM   2293  O   GLY B  15      31.216  26.004   3.473  1.00 26.01           O  
ATOM   2294  N   ASN B  16      29.491  26.076   2.056  1.00 25.42           N  
ATOM   2295  CA  ASN B  16      28.716  25.117   2.855  1.00 24.94           C  
ATOM   2296  C   ASN B  16      29.471  23.818   3.045  1.00 23.92           C  
ATOM   2297  O   ASN B  16      29.551  23.301   4.150  1.00 23.37           O  
ATOM   2298  CB  ASN B  16      27.355  24.835   2.208  1.00 25.58           C  
ATOM   2299  CG  ASN B  16      26.246  24.602   3.233  1.00 27.84           C  
ATOM   2300  OD1 ASN B  16      26.326  25.053   4.378  1.00 32.29           O  
ATOM   2301  ND2 ASN B  16      25.180  23.929   2.803  1.00 31.11           N  
ATOM   2302  N   ILE B  17      30.040  23.296   1.963  1.00 23.11           N  
ATOM   2303  CA  ILE B  17      30.699  22.000   2.031  1.00 23.00           C  
ATOM   2304  C   ILE B  17      31.958  22.106   2.899  1.00 22.64           C  
ATOM   2305  O   ILE B  17      32.218  21.234   3.741  1.00 22.96           O  
ATOM   2306  CB  ILE B  17      30.988  21.462   0.624  1.00 22.66           C  
ATOM   2307  CG1 ILE B  17      29.659  21.028  -0.020  1.00 23.03           C  
ATOM   2308  CG2 ILE B  17      31.936  20.288   0.667  1.00 24.56           C  
ATOM   2309  CD1 ILE B  17      29.789  20.450  -1.434  1.00 25.55           C  
ATOM   2310  N   GLY B  18      32.717  23.178   2.717  1.00 22.04           N  
ATOM   2311  CA  GLY B  18      33.909  23.446   3.533  1.00 22.00           C  
ATOM   2312  C   GLY B  18      33.661  23.430   5.031  1.00 21.74           C  
ATOM   2313  O   GLY B  18      34.453  22.836   5.786  1.00 21.68           O  
ATOM   2314  N   ARG B  19      32.553  24.045   5.464  1.00 21.71           N  
ATOM   2315  CA  ARG B  19      32.232  24.075   6.885  0.50 21.50           C  
ATOM   2317  C   ARG B  19      32.001  22.664   7.443  1.00 21.30           C  
ATOM   2318  O   ARG B  19      32.459  22.337   8.547  1.00 20.59           O  
ATOM   2319  CB  ARG B  19      31.008  24.960   7.150  0.50 21.62           C  
ATOM   2321  CG  ARG B  19      30.895  25.404   8.601  0.50 22.39           C  
ATOM   2323  CD  ARG B  19      29.615  26.192   8.859  0.50 22.88           C  
ATOM   2325  NE  ARG B  19      28.448  25.328   8.728  0.50 24.43           N  
ATOM   2327  CZ  ARG B  19      27.215  25.739   8.450  0.50 24.85           C  
ATOM   2329  NH1 ARG B  19      26.949  27.029   8.257  0.50 25.03           N  
ATOM   2331  NH2 ARG B  19      26.237  24.845   8.353  0.50 24.30           N  
ATOM   2333  N   TYR B  20      31.288  21.833   6.698  1.00 20.70           N  
ATOM   2334  CA  TYR B  20      31.001  20.489   7.152  1.00 20.36           C  
ATOM   2335  C   TYR B  20      32.226  19.565   7.022  1.00 19.84           C  
ATOM   2336  O   TYR B  20      32.382  18.604   7.799  1.00 20.78           O  
ATOM   2337  CB  TYR B  20      29.796  19.928   6.372  1.00 20.12           C  
ATOM   2338  CG  TYR B  20      28.421  20.378   6.859  1.00 18.98           C  
ATOM   2339  CD1 TYR B  20      27.794  19.726   7.909  1.00 19.54           C  
ATOM   2340  CD2 TYR B  20      27.704  21.394   6.216  1.00 19.84           C  
ATOM   2341  CE1 TYR B  20      26.528  20.091   8.343  1.00 19.26           C  
ATOM   2342  CE2 TYR B  20      26.416  21.774   6.663  1.00 18.60           C  
ATOM   2343  CZ  TYR B  20      25.833  21.091   7.715  1.00 19.59           C  
ATOM   2344  OH  TYR B  20      24.558  21.387   8.168  1.00 18.97           O  
ATOM   2345  N   ALA B  21      33.092  19.851   6.050  1.00 19.45           N  
ATOM   2346  CA  ALA B  21      34.357  19.125   5.915  1.00 20.21           C  
ATOM   2347  C   ALA B  21      35.252  19.390   7.112  1.00 20.18           C  
ATOM   2348  O   ALA B  21      35.898  18.465   7.657  1.00 20.29           O  
ATOM   2349  CB  ALA B  21      35.058  19.500   4.634  1.00 20.13           C  
ATOM   2350  N   LEU B  22      35.280  20.648   7.555  1.00 20.61           N  
ATOM   2351  CA  LEU B  22      36.024  21.010   8.761  1.00 20.75           C  
ATOM   2352  C   LEU B  22      35.515  20.266   9.973  1.00 20.05           C  
ATOM   2353  O   LEU B  22      36.300  19.803  10.794  1.00 19.86           O  
ATOM   2354  CB  LEU B  22      35.918  22.504   9.042  1.00 21.15           C  
ATOM   2355  CG  LEU B  22      36.781  23.077  10.169  1.00 21.91           C  
ATOM   2356  CD1 LEU B  22      38.261  22.783   9.920  1.00 22.62           C  
ATOM   2357  CD2 LEU B  22      36.540  24.582  10.308  1.00 22.02           C  
ATOM   2358  N   GLN B  23      34.191  20.179  10.110  1.00 19.85           N  
ATOM   2359  CA  GLN B  23      33.601  19.463  11.257  1.00 19.92           C  
ATOM   2360  C   GLN B  23      34.034  18.004  11.236  1.00 19.33           C  
ATOM   2361  O   GLN B  23      34.375  17.444  12.270  1.00 17.47           O  
ATOM   2362  CB  GLN B  23      32.075  19.563  11.253  1.00 20.45           C  
ATOM   2363  CG  GLN B  23      31.563  20.905  11.712  1.00 22.12           C  
ATOM   2364  CD  GLN B  23      30.035  21.059  11.638  1.00 22.26           C  
ATOM   2365  OE1 GLN B  23      29.309  20.213  11.106  1.00 20.37           O  
ATOM   2366  NE2 GLN B  23      29.550  22.158  12.196  1.00 24.63           N  
ATOM   2367  N   ALA B  24      34.030  17.403  10.036  1.00 18.51           N  
ATOM   2368  CA  ALA B  24      34.452  16.014   9.870  1.00 18.89           C  
ATOM   2369  C   ALA B  24      35.952  15.822  10.158  1.00 18.56           C  
ATOM   2370  O   ALA B  24      36.328  14.847  10.810  1.00 19.68           O  
ATOM   2371  CB  ALA B  24      34.054  15.498   8.484  1.00 18.80           C  
ATOM   2372  N   LEU B  25      36.798  16.755   9.729  1.00 18.79           N  
ATOM   2373  CA  LEU B  25      38.243  16.699  10.061  1.00 19.75           C  
ATOM   2374  C   LEU B  25      38.462  16.784  11.552  1.00 20.71           C  
ATOM   2375  O   LEU B  25      39.280  16.049  12.098  1.00 21.07           O  
ATOM   2376  CB  LEU B  25      39.040  17.825   9.407  1.00 20.07           C  
ATOM   2377  CG  LEU B  25      39.369  17.706   7.950  1.00 20.91           C  
ATOM   2378  CD1 LEU B  25      40.076  18.995   7.484  1.00 20.84           C  
ATOM   2379  CD2 LEU B  25      40.259  16.479   7.698  1.00 20.60           C  
ATOM   2380  N   ARG B  26      37.726  17.687  12.202  1.00 21.33           N  
ATOM   2381  CA  ARG B  26      37.861  17.891  13.637  1.00 22.81           C  
ATOM   2382  C   ARG B  26      37.563  16.623  14.414  1.00 21.95           C  
ATOM   2383  O   ARG B  26      38.203  16.357  15.438  1.00 19.78           O  
ATOM   2384  CB  ARG B  26      36.944  19.018  14.121  1.00 23.23           C  
ATOM   2385  CG  ARG B  26      37.550  19.826  15.214  1.00 27.65           C  
ATOM   2386  CD  ARG B  26      36.692  21.009  15.693  1.00 28.36           C  
ATOM   2387  NE  ARG B  26      36.518  22.085  14.721  1.00 33.41           N  
ATOM   2388  CZ  ARG B  26      35.984  23.266  15.033  1.00 35.08           C  
ATOM   2389  NH1 ARG B  26      35.852  24.210  14.115  1.00 36.49           N  
ATOM   2390  NH2 ARG B  26      35.578  23.511  16.277  1.00 37.98           N  
ATOM   2391  N   GLU B  27      36.577  15.846  13.958  1.00 21.91           N  
ATOM   2392  CA  GLU B  27      36.206  14.650  14.673  1.00 22.53           C  
ATOM   2393  C   GLU B  27      37.018  13.447  14.253  1.00 22.35           C  
ATOM   2394  O   GLU B  27      36.994  12.443  14.937  1.00 23.17           O  
ATOM   2395  CB  GLU B  27      34.724  14.337  14.483  1.00 23.05           C  
ATOM   2396  CG  GLU B  27      33.779  15.439  14.893  1.00 24.20           C  
ATOM   2397  CD  GLU B  27      33.723  15.685  16.385  1.00 27.92           C  
ATOM   2398  OE1 GLU B  27      33.569  14.734  17.164  1.00 30.62           O  
ATOM   2399  OE2 GLU B  27      33.811  16.862  16.780  1.00 32.02           O  
ATOM   2400  N   ALA B  28      37.738  13.516  13.142  1.00 23.17           N  
ATOM   2401  CA  ALA B  28      38.546  12.367  12.710  1.00 23.63           C  
ATOM   2402  C   ALA B  28      39.783  12.218  13.585  1.00 24.82           C  
ATOM   2403  O   ALA B  28      40.573  13.134  13.678  1.00 25.73           O  
ATOM   2404  CB  ALA B  28      38.947  12.512  11.234  1.00 23.48           C  
ATOM   2405  N   PRO B  29      40.000  11.037  14.176  1.00 25.39           N  
ATOM   2406  CA  PRO B  29      41.127  10.982  15.102  1.00 25.64           C  
ATOM   2407  C   PRO B  29      42.514  10.957  14.430  1.00 25.03           C  
ATOM   2408  O   PRO B  29      43.527  11.225  15.091  1.00 25.46           O  
ATOM   2409  CB  PRO B  29      40.882   9.689  15.873  1.00 26.07           C  
ATOM   2410  CG  PRO B  29      40.127   8.822  14.946  1.00 26.88           C  
ATOM   2411  CD  PRO B  29      39.322   9.737  14.041  1.00 26.61           C  
ATOM   2412  N   ASP B  30      42.561  10.648  13.137  1.00 23.96           N  
ATOM   2413  CA  ASP B  30      43.830  10.509  12.447  1.00 23.21           C  
ATOM   2414  C   ASP B  30      44.256  11.743  11.650  1.00 22.88           C  
ATOM   2415  O   ASP B  30      45.263  11.697  10.926  1.00 22.33           O  
ATOM   2416  CB  ASP B  30      43.792   9.282  11.543  1.00 22.92           C  
ATOM   2417  CG  ASP B  30      42.627   9.298  10.563  1.00 21.57           C  
ATOM   2418  OD1 ASP B  30      41.563   9.894  10.874  1.00 17.36           O  
ATOM   2419  OD2 ASP B  30      42.781   8.671   9.491  1.00 19.69           O  
ATOM   2420  N   PHE B  31      43.525  12.848  11.820  1.00 22.64           N  
ATOM   2421  CA  PHE B  31      43.822  14.089  11.131  1.00 22.58           C  
ATOM   2422  C   PHE B  31      44.148  15.235  12.093  1.00 23.69           C  
ATOM   2423  O   PHE B  31      43.682  15.276  13.226  1.00 22.06           O  
ATOM   2424  CB  PHE B  31      42.642  14.538  10.269  1.00 22.76           C  
ATOM   2425  CG  PHE B  31      42.498  13.808   8.967  1.00 22.06           C  
ATOM   2426  CD1 PHE B  31      41.756  12.656   8.891  1.00 20.92           C  
ATOM   2427  CD2 PHE B  31      43.038  14.329   7.790  1.00 21.26           C  
ATOM   2428  CE1 PHE B  31      41.581  12.014   7.695  1.00 19.33           C  
ATOM   2429  CE2 PHE B  31      42.861  13.678   6.589  1.00 21.05           C  
ATOM   2430  CZ  PHE B  31      42.148  12.534   6.536  1.00 20.47           C  
ATOM   2431  N   GLU B  32      44.954  16.156  11.578  1.00 24.88           N  
ATOM   2432  CA  GLU B  32      45.312  17.412  12.217  1.00 26.66           C  
ATOM   2433  C   GLU B  32      44.982  18.502  11.192  1.00 25.92           C  
ATOM   2434  O   GLU B  32      45.266  18.326  10.013  1.00 25.75           O  
ATOM   2435  CB  GLU B  32      46.801  17.330  12.470  1.00 27.39           C  
ATOM   2436  CG  GLU B  32      47.478  18.467  13.089  1.00 30.22           C  
ATOM   2437  CD  GLU B  32      48.833  18.025  13.589  1.00 31.60           C  
ATOM   2438  OE1 GLU B  32      49.768  17.875  12.760  1.00 35.62           O  
ATOM   2439  OE2 GLU B  32      48.935  17.775  14.813  1.00 37.26           O  
ATOM   2440  N   ILE B  33      44.346  19.588  11.616  1.00 25.02           N  
ATOM   2441  CA  ILE B  33      43.922  20.635  10.679  1.00 25.16           C  
ATOM   2442  C   ILE B  33      45.060  21.613  10.468  1.00 25.16           C  
ATOM   2443  O   ILE B  33      45.462  22.332  11.404  1.00 24.61           O  
ATOM   2444  CB  ILE B  33      42.651  21.365  11.152  1.00 25.39           C  
ATOM   2445  CG1 ILE B  33      41.438  20.399  11.138  1.00 24.96           C  
ATOM   2446  CG2 ILE B  33      42.331  22.553  10.245  1.00 24.09           C  
ATOM   2447  CD1 ILE B  33      40.296  20.840  12.064  1.00 25.76           C  
ATOM   2448  N   ALA B  34      45.582  21.642   9.242  1.00 24.83           N  
ATOM   2449  CA  ALA B  34      46.702  22.524   8.877  1.00 25.62           C  
ATOM   2450  C   ALA B  34      46.230  23.960   8.730  1.00 25.75           C  
ATOM   2451  O   ALA B  34      46.934  24.874   9.099  1.00 26.30           O  
ATOM   2452  CB  ALA B  34      47.358  22.063   7.589  1.00 25.39           C  
ATOM   2453  N   GLY B  35      45.032  24.137   8.190  1.00 26.16           N  
ATOM   2454  CA  GLY B  35      44.462  25.467   7.996  1.00 26.11           C  
ATOM   2455  C   GLY B  35      43.368  25.476   6.953  1.00 25.98           C  
ATOM   2456  O   GLY B  35      42.963  24.428   6.432  1.00 24.93           O  
ATOM   2457  N   ILE B  36      42.896  26.681   6.666  1.00 25.80           N  
ATOM   2458  CA  ILE B  36      41.820  26.917   5.725  1.00 26.83           C  
ATOM   2459  C   ILE B  36      42.344  27.908   4.690  1.00 26.75           C  
ATOM   2460  O   ILE B  36      42.862  28.959   5.047  1.00 25.84           O  
ATOM   2461  CB  ILE B  36      40.576  27.514   6.417  1.00 26.83           C  
ATOM   2462  CG1 ILE B  36      39.976  26.502   7.393  1.00 29.56           C  
ATOM   2463  CG2 ILE B  36      39.533  27.880   5.387  1.00 26.95           C  
ATOM   2464  CD1 ILE B  36      40.743  26.317   8.667  1.00 33.73           C  
ATOM   2465  N   VAL B  37      42.232  27.532   3.423  1.00 28.06           N  
ATOM   2466  CA  VAL B  37      42.609  28.386   2.312  1.00 29.36           C  
ATOM   2467  C   VAL B  37      41.344  28.970   1.728  1.00 30.99           C  
ATOM   2468  O   VAL B  37      40.465  28.253   1.234  1.00 29.97           O  
ATOM   2469  CB  VAL B  37      43.389  27.618   1.239  1.00 29.46           C  
ATOM   2470  CG1 VAL B  37      43.823  28.570   0.095  1.00 29.54           C  
ATOM   2471  CG2 VAL B  37      44.598  26.937   1.865  1.00 29.75           C  
ATOM   2472  N   ARG B  38      41.244  30.290   1.794  1.00 33.19           N  
ATOM   2473  CA  ARG B  38      40.029  30.961   1.417  1.00 35.48           C  
ATOM   2474  C   ARG B  38      40.313  31.871   0.243  1.00 36.33           C  
ATOM   2475  O   ARG B  38      41.329  32.566   0.220  1.00 36.89           O  
ATOM   2476  CB  ARG B  38      39.503  31.761   2.601  1.00 35.79           C  
ATOM   2477  CG  ARG B  38      38.025  31.825   2.648  1.00 37.32           C  
ATOM   2478  CD  ARG B  38      37.534  32.360   3.965  1.00 38.23           C  
ATOM   2479  NE  ARG B  38      36.084  32.240   4.054  1.00 40.86           N  
ATOM   2480  CZ  ARG B  38      35.346  32.718   5.051  1.00 42.07           C  
ATOM   2481  NH1 ARG B  38      35.911  33.371   6.065  1.00 43.59           N  
ATOM   2482  NH2 ARG B  38      34.027  32.554   5.025  1.00 42.69           N  
ATOM   2483  N   ARG B  39      39.391  31.874  -0.709  1.00 37.41           N  
ATOM   2484  CA  ARG B  39      39.522  32.646  -1.940  1.00 38.33           C  
ATOM   2485  C   ARG B  39      38.988  34.066  -1.767  1.00 38.65           C  
ATOM   2486  O   ARG B  39      39.511  35.005  -2.371  1.00 38.71           O  
ATOM   2487  CB  ARG B  39      38.835  31.946  -3.135  1.00 38.39           C  
ATOM   2488  CG  ARG B  39      37.830  30.807  -2.813  1.00 38.65           C  
ATOM   2489  CD  ARG B  39      36.530  31.287  -2.134  1.00 37.91           C  
ATOM   2490  NE  ARG B  39      36.406  30.921  -0.712  1.00 36.35           N  
ATOM   2491  CZ  ARG B  39      35.282  31.062  -0.011  1.00 35.90           C  
ATOM   2492  NH1 ARG B  39      34.172  31.533  -0.580  1.00 36.42           N  
ATOM   2493  NH2 ARG B  39      35.251  30.716   1.259  1.00 35.79           N  
ATOM   2494  N   ASN B  40      37.947  34.208  -0.950  1.00 39.17           N  
ATOM   2495  CA  ASN B  40      37.334  35.502  -0.670  1.00 39.74           C  
ATOM   2496  C   ASN B  40      37.640  35.927   0.766  1.00 40.26           C  
ATOM   2497  O   ASN B  40      36.958  35.491   1.698  1.00 40.17           O  
ATOM   2498  CB  ASN B  40      35.823  35.426  -0.902  1.00 39.65           C  
ATOM   2499  CG  ASN B  40      35.469  35.179  -2.361  1.00 39.93           C  
ATOM   2500  OD1 ASN B  40      35.897  35.919  -3.250  1.00 40.38           O  
ATOM   2501  ND2 ASN B  40      34.682  34.135  -2.614  1.00 39.97           N  
ATOM   2502  N   PRO B  41      38.685  36.763   0.954  1.00 40.97           N  
ATOM   2503  CA  PRO B  41      39.030  37.229   2.299  1.00 41.67           C  
ATOM   2504  C   PRO B  41      37.834  37.815   3.058  1.00 42.44           C  
ATOM   2505  O   PRO B  41      37.089  38.635   2.511  1.00 42.63           O  
ATOM   2506  CB  PRO B  41      40.091  38.303   2.039  1.00 41.42           C  
ATOM   2507  CG  PRO B  41      40.703  37.923   0.745  1.00 41.21           C  
ATOM   2508  CD  PRO B  41      39.608  37.297  -0.065  1.00 40.91           C  
ATOM   2509  N   ALA B  42      37.648  37.353   4.294  1.00 43.66           N  
ATOM   2510  CA  ALA B  42      36.642  37.882   5.222  1.00 44.39           C  
ATOM   2511  C   ALA B  42      37.210  37.829   6.701  1.00 46.20           C  
ATOM   2512  O   ALA B  42      36.826  38.598   7.538  1.00 49.74           O  
ATOM   2513  CB  ALA B  42      35.339  37.082   5.102  1.00 44.85           C  
ATOM   2514  N   GLN B  49      38.635  30.564  14.072  1.00 39.92           N  
ATOM   2515  CA  GLN B  49      39.495  31.332  14.970  1.00 39.63           C  
ATOM   2516  C   GLN B  49      40.706  30.517  15.452  1.00 39.33           C  
ATOM   2517  O   GLN B  49      41.826  31.040  15.496  1.00 38.94           O  
ATOM   2518  CB  GLN B  49      38.706  31.898  16.171  1.00 40.66           C  
ATOM   2519  CG  GLN B  49      37.997  33.249  15.913  1.00 42.59           C  
ATOM   2520  CD  GLN B  49      38.941  34.440  15.809  1.00 44.72           C  
ATOM   2521  OE1 GLN B  49      39.755  34.516  14.889  1.00 47.41           O  
ATOM   2522  NE2 GLN B  49      38.823  35.394  16.746  1.00 44.58           N  
ATOM   2523  N   PRO B  50      40.502  29.234  15.809  1.00 38.47           N  
ATOM   2524  CA  PRO B  50      41.660  28.432  16.214  1.00 37.96           C  
ATOM   2525  C   PRO B  50      42.535  27.970  15.049  1.00 37.16           C  
ATOM   2526  O   PRO B  50      43.577  27.365  15.277  1.00 36.51           O  
ATOM   2527  CB  PRO B  50      41.033  27.214  16.923  1.00 38.02           C  
ATOM   2528  CG  PRO B  50      39.554  27.480  16.988  1.00 38.52           C  
ATOM   2529  CD  PRO B  50      39.256  28.457  15.891  1.00 38.73           C  
ATOM   2530  N   PHE B  51      42.118  28.244  13.814  1.00 36.56           N  
ATOM   2531  CA  PHE B  51      42.833  27.740  12.646  1.00 36.45           C  
ATOM   2532  C   PHE B  51      43.468  28.884  11.875  1.00 35.65           C  
ATOM   2533  O   PHE B  51      43.044  30.033  11.992  1.00 35.61           O  
ATOM   2534  CB  PHE B  51      41.875  26.933  11.753  1.00 36.46           C  
ATOM   2535  CG  PHE B  51      41.149  25.855  12.499  1.00 36.69           C  
ATOM   2536  CD1 PHE B  51      41.844  24.761  13.003  1.00 37.23           C  
ATOM   2537  CD2 PHE B  51      39.790  25.958  12.758  1.00 36.87           C  
ATOM   2538  CE1 PHE B  51      41.189  23.774  13.738  1.00 37.54           C  
ATOM   2539  CE2 PHE B  51      39.129  24.971  13.486  1.00 37.13           C  
ATOM   2540  CZ  PHE B  51      39.827  23.880  13.973  1.00 37.05           C  
ATOM   2541  N   ARG B  52      44.500  28.568  11.104  1.00 34.65           N  
ATOM   2542  CA  ARG B  52      45.101  29.556  10.216  1.00 34.49           C  
ATOM   2543  C   ARG B  52      44.194  29.701   9.004  1.00 33.99           C  
ATOM   2544  O   ARG B  52      43.775  28.696   8.441  1.00 33.63           O  
ATOM   2545  CB  ARG B  52      46.504  29.139   9.758  1.00 34.49           C  
ATOM   2546  CG  ARG B  52      47.318  28.365  10.795  1.00 34.60           C  
ATOM   2547  CD  ARG B  52      48.825  28.620  10.709  1.00 35.00           C  
ATOM   2548  NE  ARG B  52      49.242  29.207   9.435  1.00 35.34           N  
ATOM   2549  CZ  ARG B  52      49.506  30.498   9.229  1.00 35.82           C  
ATOM   2550  NH1 ARG B  52      49.412  31.392  10.213  1.00 36.57           N  
ATOM   2551  NH2 ARG B  52      49.870  30.900   8.023  1.00 35.66           N  
ATOM   2552  N   VAL B  53      43.890  30.941   8.617  1.00 33.93           N  
ATOM   2553  CA  VAL B  53      43.068  31.214   7.432  1.00 33.73           C  
ATOM   2554  C   VAL B  53      43.863  32.066   6.458  1.00 33.55           C  
ATOM   2555  O   VAL B  53      44.173  33.217   6.749  1.00 33.16           O  
ATOM   2556  CB  VAL B  53      41.757  31.923   7.808  1.00 33.62           C  
ATOM   2557  CG1 VAL B  53      40.962  32.274   6.564  1.00 34.80           C  
ATOM   2558  CG2 VAL B  53      40.940  31.041   8.744  1.00 34.09           C  
ATOM   2559  N   VAL B  54      44.184  31.488   5.300  1.00 33.71           N  
ATOM   2560  CA  VAL B  54      45.097  32.099   4.335  1.00 33.77           C  
ATOM   2561  C   VAL B  54      44.448  32.181   2.962  1.00 33.64           C  
ATOM   2562  O   VAL B  54      43.385  31.590   2.732  1.00 33.48           O  
ATOM   2563  CB  VAL B  54      46.413  31.279   4.251  1.00 34.11           C  
ATOM   2564  CG1 VAL B  54      47.150  31.312   5.595  1.00 32.83           C  
ATOM   2565  CG2 VAL B  54      46.132  29.836   3.839  1.00 33.85           C  
ATOM   2566  N   SER B  55      45.072  32.921   2.045  1.00 33.75           N  
ATOM   2567  CA  SER B  55      44.610  32.946   0.660  1.00 34.18           C  
ATOM   2568  C   SER B  55      45.428  32.025  -0.275  1.00 34.32           C  
ATOM   2569  O   SER B  55      45.070  31.883  -1.437  1.00 34.58           O  
ATOM   2570  CB  SER B  55      44.626  34.372   0.117  1.00 34.66           C  
ATOM   2571  OG  SER B  55      45.957  34.822  -0.045  1.00 36.21           O  
ATOM   2572  N   ASP B  56      46.507  31.425   0.240  1.00 34.38           N  
ATOM   2573  CA  ASP B  56      47.420  30.559  -0.528  1.00 33.90           C  
ATOM   2574  C   ASP B  56      47.909  29.390   0.341  1.00 33.70           C  
ATOM   2575  O   ASP B  56      48.450  29.611   1.430  1.00 33.14           O  
ATOM   2576  CB  ASP B  56      48.623  31.384  -0.981  1.00 34.68           C  
ATOM   2577  CG  ASP B  56      49.502  30.665  -2.007  1.00 35.17           C  
ATOM   2578  OD1 ASP B  56      49.749  29.440  -1.898  1.00 36.46           O  
ATOM   2579  OD2 ASP B  56      49.967  31.362  -2.925  1.00 38.12           O  
ATOM   2580  N   ILE B  57      47.738  28.158  -0.156  1.00 32.79           N  
ATOM   2581  CA  ILE B  57      48.150  26.934   0.567  1.00 32.58           C  
ATOM   2582  C   ILE B  57      49.645  26.913   0.976  1.00 32.46           C  
ATOM   2583  O   ILE B  57      49.999  26.281   1.976  1.00 33.05           O  
ATOM   2584  CB  ILE B  57      47.783  25.628  -0.243  1.00 32.22           C  
ATOM   2585  CG1 ILE B  57      47.737  24.401   0.687  1.00 32.17           C  
ATOM   2586  CG2 ILE B  57      48.767  25.398  -1.381  1.00 30.97           C  
ATOM   2587  CD1 ILE B  57      46.852  23.270   0.199  1.00 31.33           C  
ATOM   2588  N   GLU B  58      50.504  27.629   0.243  1.00 32.68           N  
ATOM   2589  CA  GLU B  58      51.952  27.686   0.578  1.00 33.01           C  
ATOM   2590  C   GLU B  58      52.240  28.365   1.936  1.00 32.75           C  
ATOM   2591  O   GLU B  58      53.310  28.176   2.511  1.00 32.27           O  
ATOM   2592  CB  GLU B  58      52.796  28.333  -0.551  1.00 33.37           C  
ATOM   2593  CG  GLU B  58      52.982  27.422  -1.791  1.00 33.95           C  
ATOM   2594  CD  GLU B  58      54.412  27.336  -2.324  1.00 35.51           C  
ATOM   2595  OE1 GLU B  58      55.367  27.747  -1.624  1.00 39.22           O  
ATOM   2596  OE2 GLU B  58      54.593  26.848  -3.474  1.00 38.54           O  
ATOM   2597  N   GLN B  59      51.280  29.117   2.465  1.00 32.36           N  
ATOM   2598  CA  GLN B  59      51.454  29.744   3.771  1.00 32.44           C  
ATOM   2599  C   GLN B  59      51.151  28.832   4.955  1.00 32.23           C  
ATOM   2600  O   GLN B  59      51.463  29.172   6.089  1.00 33.08           O  
ATOM   2601  CB  GLN B  59      50.627  31.018   3.839  1.00 32.53           C  
ATOM   2602  CG  GLN B  59      51.209  32.094   2.946  1.00 34.06           C  
ATOM   2603  CD  GLN B  59      50.168  32.970   2.313  1.00 36.05           C  
ATOM   2604  OE1 GLN B  59      49.034  33.071   2.802  1.00 39.40           O  
ATOM   2605  NE2 GLN B  59      50.543  33.626   1.222  1.00 33.37           N  
ATOM   2606  N   LEU B  60      50.530  27.688   4.697  1.00 31.97           N  
ATOM   2607  CA  LEU B  60      50.323  26.658   5.725  1.00 31.34           C  
ATOM   2608  C   LEU B  60      51.560  25.762   5.762  1.00 30.52           C  
ATOM   2609  O   LEU B  60      52.276  25.693   4.782  1.00 30.74           O  
ATOM   2610  CB  LEU B  60      49.075  25.835   5.393  1.00 31.21           C  
ATOM   2611  CG  LEU B  60      47.776  26.641   5.208  1.00 31.98           C  
ATOM   2612  CD1 LEU B  60      46.598  25.732   4.876  1.00 29.46           C  
ATOM   2613  CD2 LEU B  60      47.468  27.524   6.422  1.00 30.50           C  
ATOM   2614  N   GLU B  61      51.793  25.070   6.882  1.00 29.64           N  
ATOM   2615  CA  GLU B  61      53.003  24.260   7.072  1.00 29.12           C  
ATOM   2616  C   GLU B  61      52.753  22.759   6.884  1.00 28.06           C  
ATOM   2617  O   GLU B  61      51.768  22.226   7.379  1.00 27.21           O  
ATOM   2618  CB  GLU B  61      53.585  24.496   8.478  1.00 29.78           C  
ATOM   2619  CG  GLU B  61      53.994  25.964   8.782  1.00 31.37           C  
ATOM   2620  CD  GLU B  61      55.250  26.444   8.036  1.00 33.76           C  
ATOM   2621  OE1 GLU B  61      55.843  25.658   7.261  1.00 36.27           O  
ATOM   2622  OE2 GLU B  61      55.649  27.624   8.227  1.00 34.77           O  
ATOM   2623  N   SER B  62      53.655  22.094   6.162  1.00 27.26           N  
ATOM   2624  CA  SER B  62      53.671  20.624   6.040  1.00 26.97           C  
ATOM   2625  C   SER B  62      52.289  20.013   5.792  1.00 25.86           C  
ATOM   2626  O   SER B  62      51.851  19.157   6.561  1.00 25.44           O  
ATOM   2627  CB  SER B  62      54.278  19.989   7.304  1.00 27.14           C  
ATOM   2628  OG  SER B  62      55.614  20.429   7.522  1.00 29.38           O  
ATOM   2629  N   VAL B  63      51.610  20.463   4.739  1.00 24.80           N  
ATOM   2630  CA  VAL B  63      50.287  19.960   4.364  1.00 24.45           C  
ATOM   2631  C   VAL B  63      50.450  18.635   3.611  1.00 24.50           C  
ATOM   2632  O   VAL B  63      51.216  18.547   2.651  1.00 23.88           O  
ATOM   2633  CB  VAL B  63      49.533  20.985   3.462  1.00 24.23           C  
ATOM   2634  CG1 VAL B  63      48.236  20.397   2.916  1.00 22.84           C  
ATOM   2635  CG2 VAL B  63      49.244  22.276   4.226  1.00 23.94           C  
ATOM   2636  N   ASP B  64      49.729  17.612   4.052  1.00 23.54           N  
ATOM   2637  CA  ASP B  64      49.757  16.309   3.383  1.00 23.72           C  
ATOM   2638  C   ASP B  64      48.714  16.230   2.290  1.00 23.49           C  
ATOM   2639  O   ASP B  64      48.961  15.679   1.212  1.00 24.37           O  
ATOM   2640  CB  ASP B  64      49.508  15.187   4.393  1.00 23.50           C  
ATOM   2641  CG  ASP B  64      50.651  15.021   5.368  1.00 26.15           C  
ATOM   2642  OD1 ASP B  64      51.816  14.980   4.921  1.00 26.39           O  
ATOM   2643  OD2 ASP B  64      50.386  14.962   6.577  1.00 26.99           O  
ATOM   2644  N   VAL B  65      47.538  16.769   2.571  1.00 22.87           N  
ATOM   2645  CA  VAL B  65      46.386  16.605   1.688  1.00 22.87           C  
ATOM   2646  C   VAL B  65      45.497  17.833   1.777  1.00 22.43           C  
ATOM   2647  O   VAL B  65      45.384  18.441   2.836  1.00 21.42           O  
ATOM   2648  CB  VAL B  65      45.599  15.292   2.050  1.00 22.59           C  
ATOM   2649  CG1 VAL B  65      45.059  15.371   3.470  1.00 22.67           C  
ATOM   2650  CG2 VAL B  65      44.473  14.979   1.024  1.00 22.46           C  
ATOM   2651  N   ALA B  66      44.913  18.211   0.638  1.00 21.96           N  
ATOM   2652  CA  ALA B  66      43.933  19.279   0.566  1.00 21.70           C  
ATOM   2653  C   ALA B  66      42.544  18.739   0.225  1.00 21.13           C  
ATOM   2654  O   ALA B  66      42.378  17.964  -0.717  1.00 22.31           O  
ATOM   2655  CB  ALA B  66      44.337  20.300  -0.452  1.00 21.50           C  
ATOM   2656  N   LEU B  67      41.553  19.160   1.016  1.00 20.99           N  
ATOM   2657  CA  LEU B  67      40.155  18.867   0.757  1.00 20.81           C  
ATOM   2658  C   LEU B  67      39.622  20.040  -0.028  1.00 21.23           C  
ATOM   2659  O   LEU B  67      39.383  21.119   0.535  1.00 22.51           O  
ATOM   2660  CB  LEU B  67      39.334  18.699   2.026  1.00 20.40           C  
ATOM   2661  CG  LEU B  67      39.464  17.374   2.802  1.00 21.50           C  
ATOM   2662  CD1 LEU B  67      40.872  17.240   3.340  1.00 21.55           C  
ATOM   2663  CD2 LEU B  67      38.465  17.300   3.944  1.00 20.17           C  
ATOM   2664  N   VAL B  68      39.485  19.832  -1.325  1.00 21.47           N  
ATOM   2665  CA  VAL B  68      39.035  20.875  -2.246  1.00 22.03           C  
ATOM   2666  C   VAL B  68      37.524  20.987  -2.222  1.00 23.04           C  
ATOM   2667  O   VAL B  68      36.818  20.159  -2.804  1.00 24.56           O  
ATOM   2668  CB  VAL B  68      39.553  20.609  -3.678  1.00 21.74           C  
ATOM   2669  CG1 VAL B  68      39.097  21.701  -4.661  1.00 20.77           C  
ATOM   2670  CG2 VAL B  68      41.075  20.554  -3.669  1.00 22.77           C  
ATOM   2671  N   CYS B  69      37.034  22.022  -1.539  1.00 24.23           N  
ATOM   2672  CA  CYS B  69      35.610  22.219  -1.331  1.00 25.13           C  
ATOM   2673  C   CYS B  69      35.065  23.346  -2.211  1.00 26.02           C  
ATOM   2674  O   CYS B  69      34.037  23.941  -1.907  1.00 27.09           O  
ATOM   2675  CB  CYS B  69      35.356  22.529   0.144  1.00 24.14           C  
ATOM   2676  SG  CYS B  69      35.994  21.264   1.266  1.00 23.84           S  
ATOM   2677  N   SER B  70      35.760  23.634  -3.304  1.00 26.87           N  
ATOM   2678  CA  SER B  70      35.361  24.674  -4.248  1.00 27.40           C  
ATOM   2679  C   SER B  70      34.172  24.235  -5.082  1.00 27.86           C  
ATOM   2680  O   SER B  70      33.873  23.050  -5.136  1.00 27.20           O  
ATOM   2681  CB  SER B  70      36.535  24.971  -5.183  1.00 27.89           C  
ATOM   2682  OG  SER B  70      37.766  24.816  -4.495  1.00 29.22           O  
ATOM   2683  N   PRO B  71      33.498  25.192  -5.757  1.00 28.48           N  
ATOM   2684  CA  PRO B  71      32.475  24.850  -6.757  1.00 28.77           C  
ATOM   2685  C   PRO B  71      33.062  23.938  -7.839  1.00 29.00           C  
ATOM   2686  O   PRO B  71      34.236  24.087  -8.179  1.00 28.77           O  
ATOM   2687  CB  PRO B  71      32.108  26.212  -7.359  1.00 29.11           C  
ATOM   2688  CG  PRO B  71      32.440  27.197  -6.258  1.00 29.48           C  
ATOM   2689  CD  PRO B  71      33.668  26.652  -5.623  1.00 28.83           C  
ATOM   2690  N   SER B  72      32.258  23.016  -8.368  1.00 29.06           N  
ATOM   2691  CA  SER B  72      32.734  22.021  -9.343  1.00 28.87           C  
ATOM   2692  C   SER B  72      33.556  22.618 -10.490  1.00 29.19           C  
ATOM   2693  O   SER B  72      34.581  22.075 -10.891  1.00 28.09           O  
ATOM   2694  CB  SER B  72      31.553  21.225  -9.915  1.00 28.71           C  
ATOM   2695  OG  SER B  72      31.065  20.292  -8.948  1.00 29.81           O  
ATOM   2696  N   ARG B  73      33.106  23.739 -11.025  1.00 30.03           N  
ATOM   2697  CA  ARG B  73      33.778  24.316 -12.185  1.00 30.88           C  
ATOM   2698  C   ARG B  73      35.127  24.962 -11.851  1.00 29.88           C  
ATOM   2699  O   ARG B  73      35.859  25.340 -12.752  1.00 29.90           O  
ATOM   2700  CB  ARG B  73      32.826  25.260 -12.913  1.00 32.23           C  
ATOM   2701  CG  ARG B  73      31.684  24.440 -13.548  1.00 34.47           C  
ATOM   2702  CD  ARG B  73      30.637  25.274 -14.284  1.00 36.07           C  
ATOM   2703  NE  ARG B  73      29.537  24.420 -14.764  1.00 39.74           N  
ATOM   2704  CZ  ARG B  73      28.598  23.868 -13.989  1.00 41.58           C  
ATOM   2705  NH1 ARG B  73      27.656  23.102 -14.539  1.00 41.74           N  
ATOM   2706  NH2 ARG B  73      28.587  24.071 -12.672  1.00 42.64           N  
ATOM   2707  N   GLU B  74      35.463  25.048 -10.560  1.00 28.68           N  
ATOM   2708  CA  GLU B  74      36.769  25.529 -10.111  1.00 28.00           C  
ATOM   2709  C   GLU B  74      37.690  24.412  -9.585  1.00 26.39           C  
ATOM   2710  O   GLU B  74      38.861  24.629  -9.299  1.00 24.96           O  
ATOM   2711  CB  GLU B  74      36.558  26.578  -9.029  1.00 28.09           C  
ATOM   2712  CG  GLU B  74      35.988  27.852  -9.598  1.00 29.53           C  
ATOM   2713  CD  GLU B  74      35.770  28.908  -8.551  1.00 30.94           C  
ATOM   2714  OE1 GLU B  74      35.972  28.615  -7.349  1.00 35.68           O  
ATOM   2715  OE2 GLU B  74      35.397  30.036  -8.939  1.00 36.90           O  
ATOM   2716  N   VAL B  75      37.157  23.211  -9.459  1.00 24.75           N  
ATOM   2717  CA  VAL B  75      37.911  22.123  -8.856  1.00 24.91           C  
ATOM   2718  C   VAL B  75      39.183  21.761  -9.630  1.00 24.02           C  
ATOM   2719  O   VAL B  75      40.236  21.539  -9.030  1.00 23.84           O  
ATOM   2720  CB  VAL B  75      37.000  20.881  -8.679  1.00 24.46           C  
ATOM   2721  CG1 VAL B  75      37.827  19.613  -8.388  1.00 25.34           C  
ATOM   2722  CG2 VAL B  75      35.970  21.161  -7.589  1.00 24.50           C  
ATOM   2723  N   GLU B  76      39.100  21.685 -10.954  1.00 23.99           N  
ATOM   2724  CA  GLU B  76      40.230  21.189 -11.726  1.00 23.90           C  
ATOM   2725  C   GLU B  76      41.413  22.127 -11.584  1.00 23.03           C  
ATOM   2726  O   GLU B  76      42.513  21.693 -11.277  1.00 22.22           O  
ATOM   2727  CB  GLU B  76      39.874  20.984 -13.195  1.00 23.51           C  
ATOM   2728  CG  GLU B  76      41.028  20.381 -14.017  1.00 24.95           C  
ATOM   2729  CD  GLU B  76      40.688  20.224 -15.475  1.00 25.89           C  
ATOM   2730  OE1 GLU B  76      39.523  20.473 -15.851  1.00 29.71           O  
ATOM   2731  OE2 GLU B  76      41.588  19.852 -16.256  1.00 28.29           O  
ATOM   2732  N   ARG B  77      41.187  23.424 -11.788  1.00 23.36           N  
ATOM   2733  CA  ARG B  77      42.297  24.379 -11.728  1.00 23.90           C  
ATOM   2734  C   ARG B  77      42.907  24.449 -10.326  1.00 22.54           C  
ATOM   2735  O   ARG B  77      44.119  24.494 -10.162  1.00 20.94           O  
ATOM   2736  CB  ARG B  77      41.837  25.757 -12.170  1.00 23.73           C  
ATOM   2737  CG  ARG B  77      42.938  26.751 -12.175  1.00 26.89           C  
ATOM   2738  CD  ARG B  77      42.502  28.048 -12.856  1.00 27.67           C  
ATOM   2739  NE  ARG B  77      41.475  28.751 -12.086  1.00 30.83           N  
ATOM   2740  CZ  ARG B  77      40.951  29.930 -12.416  1.00 31.73           C  
ATOM   2741  NH1 ARG B  77      41.345  30.563 -13.513  1.00 31.71           N  
ATOM   2742  NH2 ARG B  77      40.026  30.480 -11.639  1.00 32.10           N  
ATOM   2743  N   THR B  78      42.045  24.392  -9.325  1.00 23.14           N  
ATOM   2744  CA  THR B  78      42.456  24.408  -7.928  1.00 22.90           C  
ATOM   2745  C   THR B  78      43.258  23.168  -7.534  1.00 23.47           C  
ATOM   2746  O   THR B  78      44.295  23.280  -6.887  1.00 23.75           O  
ATOM   2747  CB  THR B  78      41.219  24.558  -7.023  1.00 22.67           C  
ATOM   2748  OG1 THR B  78      40.501  25.760  -7.385  1.00 20.72           O  
ATOM   2749  CG2 THR B  78      41.622  24.591  -5.548  1.00 22.51           C  
ATOM   2750  N   ALA B  79      42.772  21.981  -7.899  1.00 23.20           N  
ATOM   2751  CA  ALA B  79      43.462  20.735  -7.583  1.00 23.23           C  
ATOM   2752  C   ALA B  79      44.766  20.594  -8.372  1.00 23.05           C  
ATOM   2753  O   ALA B  79      45.768  20.095  -7.866  1.00 22.00           O  
ATOM   2754  CB  ALA B  79      42.525  19.528  -7.827  1.00 22.62           C  
ATOM   2755  N   LEU B  80      44.770  21.059  -9.616  1.00 22.60           N  
ATOM   2756  CA  LEU B  80      46.001  21.040 -10.403  1.00 22.93           C  
ATOM   2757  C   LEU B  80      47.147  21.785  -9.718  1.00 23.45           C  
ATOM   2758  O   LEU B  80      48.276  21.286  -9.680  1.00 24.47           O  
ATOM   2759  CB  LEU B  80      45.750  21.605 -11.810  1.00 22.22           C  
ATOM   2760  CG  LEU B  80      45.113  20.675 -12.835  1.00 21.67           C  
ATOM   2761  CD1 LEU B  80      45.022  21.389 -14.163  1.00 21.85           C  
ATOM   2762  CD2 LEU B  80      45.910  19.352 -12.966  1.00 20.47           C  
ATOM   2763  N   GLU B  81      46.871  22.958  -9.155  1.00 24.06           N  
ATOM   2764  CA  GLU B  81      47.922  23.766  -8.525  1.00 24.25           C  
ATOM   2765  C   GLU B  81      48.482  23.101  -7.277  1.00 24.01           C  
ATOM   2766  O   GLU B  81      49.684  23.117  -7.034  1.00 24.06           O  
ATOM   2767  CB  GLU B  81      47.410  25.176  -8.227  1.00 25.41           C  
ATOM   2768  CG  GLU B  81      47.382  26.042  -9.474  1.00 29.57           C  
ATOM   2769  CD  GLU B  81      48.784  26.246 -10.074  1.00 35.55           C  
ATOM   2770  OE1 GLU B  81      49.686  26.731  -9.341  1.00 40.06           O  
ATOM   2771  OE2 GLU B  81      48.986  25.907 -11.263  1.00 38.29           O  
ATOM   2772  N   ILE B  82      47.598  22.449  -6.544  1.00 23.30           N  
ATOM   2773  CA  ILE B  82      47.956  21.734  -5.333  1.00 22.79           C  
ATOM   2774  C   ILE B  82      48.771  20.477  -5.661  1.00 22.13           C  
ATOM   2775  O   ILE B  82      49.826  20.241  -5.082  1.00 22.17           O  
ATOM   2776  CB  ILE B  82      46.701  21.409  -4.552  1.00 22.60           C  
ATOM   2777  CG1 ILE B  82      46.017  22.704  -4.088  1.00 23.83           C  
ATOM   2778  CG2 ILE B  82      47.023  20.546  -3.316  1.00 22.01           C  
ATOM   2779  CD1 ILE B  82      44.567  22.534  -3.589  1.00 22.42           C  
ATOM   2780  N   LEU B  83      48.289  19.673  -6.596  1.00 22.71           N  
ATOM   2781  CA  LEU B  83      48.987  18.448  -6.980  1.00 23.24           C  
ATOM   2782  C   LEU B  83      50.399  18.755  -7.493  1.00 24.10           C  
ATOM   2783  O   LEU B  83      51.353  18.034  -7.200  1.00 25.14           O  
ATOM   2784  CB  LEU B  83      48.190  17.684  -8.035  1.00 22.55           C  
ATOM   2785  CG  LEU B  83      46.824  17.140  -7.605  1.00 22.55           C  
ATOM   2786  CD1 LEU B  83      45.966  16.776  -8.833  1.00 21.28           C  
ATOM   2787  CD2 LEU B  83      47.033  15.958  -6.649  1.00 20.56           C  
ATOM   2788  N   LYS B  84      50.539  19.849  -8.227  1.00 24.77           N  
ATOM   2789  CA  LYS B  84      51.862  20.264  -8.701  1.00 25.47           C  
ATOM   2790  C   LYS B  84      52.882  20.511  -7.579  1.00 25.57           C  
ATOM   2791  O   LYS B  84      54.090  20.416  -7.814  1.00 26.09           O  
ATOM   2792  CB  LYS B  84      51.725  21.497  -9.581  1.00 25.94           C  
ATOM   2793  CG  LYS B  84      51.092  21.158 -10.911  1.00 27.77           C  
ATOM   2794  CD  LYS B  84      50.967  22.355 -11.822  1.00 28.40           C  
ATOM   2795  CE  LYS B  84      50.034  22.089 -12.992  1.00 31.23           C  
ATOM   2796  NZ  LYS B  84      49.901  20.644 -13.356  1.00 34.68           N  
ATOM   2797  N   LYS B  85      52.410  20.834  -6.378  1.00 24.97           N  
ATOM   2798  CA  LYS B  85      53.274  21.023  -5.198  1.00 25.05           C  
ATOM   2799  C   LYS B  85      53.556  19.732  -4.446  1.00 25.24           C  
ATOM   2800  O   LYS B  85      54.168  19.761  -3.382  1.00 24.92           O  
ATOM   2801  CB  LYS B  85      52.637  22.025  -4.212  1.00 25.43           C  
ATOM   2802  CG  LYS B  85      52.207  23.353  -4.828  1.00 25.95           C  
ATOM   2803  CD  LYS B  85      51.480  24.210  -3.793  1.00 26.31           C  
ATOM   2804  CE  LYS B  85      50.904  25.468  -4.396  1.00 27.62           C  
ATOM   2805  NZ  LYS B  85      51.964  26.371  -4.904  1.00 28.20           N  
ATOM   2806  N   GLY B  86      53.074  18.599  -4.958  1.00 25.05           N  
ATOM   2807  CA  GLY B  86      53.270  17.304  -4.304  1.00 24.85           C  
ATOM   2808  C   GLY B  86      52.279  17.054  -3.171  1.00 24.65           C  
ATOM   2809  O   GLY B  86      52.510  16.191  -2.331  1.00 25.85           O  
ATOM   2810  N   ILE B  87      51.184  17.813  -3.134  1.00 23.81           N  
ATOM   2811  CA  ILE B  87      50.178  17.678  -2.078  1.00 22.75           C  
ATOM   2812  C   ILE B  87      48.990  16.875  -2.627  1.00 21.88           C  
ATOM   2813  O   ILE B  87      48.513  17.134  -3.708  1.00 20.51           O  
ATOM   2814  CB  ILE B  87      49.686  19.056  -1.587  1.00 22.67           C  
ATOM   2815  CG1 ILE B  87      50.847  19.853  -0.976  1.00 22.82           C  
ATOM   2816  CG2 ILE B  87      48.584  18.926  -0.533  1.00 23.26           C  
ATOM   2817  CD1 ILE B  87      50.515  21.328  -0.798  1.00 22.99           C  
ATOM   2818  N   CYS B  88      48.533  15.875  -1.881  1.00 21.43           N  
ATOM   2819  CA  CYS B  88      47.399  15.067  -2.334  1.00 21.82           C  
ATOM   2820  C   CYS B  88      46.118  15.888  -2.317  1.00 20.97           C  
ATOM   2821  O   CYS B  88      46.045  16.891  -1.610  1.00 19.97           O  
ATOM   2822  CB  CYS B  88      47.252  13.838  -1.443  1.00 21.45           C  
ATOM   2823  SG  CYS B  88      48.593  12.711  -1.751  1.00 26.98           S  
ATOM   2824  N   THR B  89      45.123  15.472  -3.102  1.00 20.37           N  
ATOM   2825  CA  THR B  89      43.834  16.162  -3.115  1.00 20.45           C  
ATOM   2826  C   THR B  89      42.643  15.221  -3.003  1.00 20.08           C  
ATOM   2827  O   THR B  89      42.674  14.055  -3.441  1.00 20.41           O  
ATOM   2828  CB  THR B  89      43.630  17.085  -4.363  1.00 20.42           C  
ATOM   2829  OG1 THR B  89      43.633  16.291  -5.550  1.00 21.67           O  
ATOM   2830  CG2 THR B  89      44.756  18.134  -4.467  1.00 19.70           C  
ATOM   2831  N   ALA B  90      41.601  15.737  -2.360  1.00 19.75           N  
ATOM   2832  CA  ALA B  90      40.281  15.128  -2.341  1.00 19.60           C  
ATOM   2833  C   ALA B  90      39.283  16.172  -2.765  1.00 19.56           C  
ATOM   2834  O   ALA B  90      39.333  17.313  -2.292  1.00 19.90           O  
ATOM   2835  CB  ALA B  90      39.933  14.611  -0.957  1.00 19.21           C  
ATOM   2836  N   ASP B  91      38.391  15.810  -3.679  1.00 19.70           N  
ATOM   2837  CA  ASP B  91      37.340  16.743  -4.124  1.00 20.38           C  
ATOM   2838  C   ASP B  91      35.967  16.060  -4.261  1.00 20.30           C  
ATOM   2839  O   ASP B  91      35.888  14.837  -4.367  1.00 20.70           O  
ATOM   2840  CB  ASP B  91      37.735  17.417  -5.456  1.00 19.70           C  
ATOM   2841  CG  ASP B  91      37.643  16.465  -6.638  1.00 22.60           C  
ATOM   2842  OD1 ASP B  91      36.491  16.107  -7.028  1.00 24.52           O  
ATOM   2843  OD2 ASP B  91      38.706  16.059  -7.168  1.00 24.29           O  
ATOM   2844  N   SER B  92      34.908  16.865  -4.270  1.00 21.14           N  
ATOM   2845  CA  SER B  92      33.537  16.363  -4.470  1.00 21.11           C  
ATOM   2846  C   SER B  92      32.930  16.865  -5.781  1.00 21.86           C  
ATOM   2847  O   SER B  92      31.718  17.026  -5.873  1.00 22.55           O  
ATOM   2848  CB  SER B  92      32.618  16.736  -3.295  1.00 21.52           C  
ATOM   2849  OG  SER B  92      32.528  18.134  -3.100  1.00 21.56           O  
ATOM   2850  N   PHE B  93      33.766  17.064  -6.798  1.00 20.88           N  
ATOM   2851  CA  PHE B  93      33.299  17.443  -8.143  1.00 21.02           C  
ATOM   2852  C   PHE B  93      32.018  16.673  -8.471  1.00 21.04           C  
ATOM   2853  O   PHE B  93      32.025  15.460  -8.400  1.00 20.78           O  
ATOM   2854  CB  PHE B  93      34.408  17.086  -9.138  1.00 21.22           C  
ATOM   2855  CG  PHE B  93      34.125  17.460 -10.563  1.00 20.18           C  
ATOM   2856  CD1 PHE B  93      34.378  18.740 -11.012  1.00 22.91           C  
ATOM   2857  CD2 PHE B  93      33.655  16.519 -11.461  1.00 22.74           C  
ATOM   2858  CE1 PHE B  93      34.157  19.077 -12.335  1.00 20.97           C  
ATOM   2859  CE2 PHE B  93      33.411  16.850 -12.784  1.00 21.77           C  
ATOM   2860  CZ  PHE B  93      33.682  18.128 -13.219  1.00 21.98           C  
ATOM   2861  N   ASP B  94      30.930  17.357  -8.832  1.00 20.53           N  
ATOM   2862  CA  ASP B  94      29.639  16.668  -8.967  1.00 21.38           C  
ATOM   2863  C   ASP B  94      29.026  16.596 -10.366  1.00 21.56           C  
ATOM   2864  O   ASP B  94      27.876  16.203 -10.515  1.00 21.58           O  
ATOM   2865  CB  ASP B  94      28.631  17.178  -7.929  1.00 21.78           C  
ATOM   2866  CG  ASP B  94      28.173  18.575  -8.173  1.00 25.45           C  
ATOM   2867  OD1 ASP B  94      28.641  19.218  -9.140  1.00 27.10           O  
ATOM   2868  OD2 ASP B  94      27.303  19.028  -7.380  1.00 27.83           O  
ATOM   2869  N   ILE B  95      29.795  16.934 -11.387  1.00 21.30           N  
ATOM   2870  CA  ILE B  95      29.274  16.903 -12.752  1.00 22.18           C  
ATOM   2871  C   ILE B  95      29.609  15.544 -13.328  1.00 21.98           C  
ATOM   2872  O   ILE B  95      30.740  15.294 -13.732  1.00 21.73           O  
ATOM   2873  CB  ILE B  95      29.867  18.016 -13.599  1.00 21.91           C  
ATOM   2874  CG1 ILE B  95      29.638  19.363 -12.908  1.00 24.36           C  
ATOM   2875  CG2 ILE B  95      29.180  18.069 -14.966  1.00 21.91           C  
ATOM   2876  CD1 ILE B  95      30.287  20.516 -13.627  1.00 23.51           C  
ATOM   2877  N   HIS B  96      28.628  14.648 -13.340  1.00 22.05           N  
ATOM   2878  CA  HIS B  96      28.878  13.243 -13.690  1.00 22.38           C  
ATOM   2879  C   HIS B  96      29.587  13.069 -15.020  1.00 22.64           C  
ATOM   2880  O   HIS B  96      30.519  12.288 -15.122  1.00 22.66           O  
ATOM   2881  CB  HIS B  96      27.566  12.473 -13.726  1.00 22.63           C  
ATOM   2882  CG  HIS B  96      26.959  12.267 -12.382  1.00 23.02           C  
ATOM   2883  ND1 HIS B  96      27.286  11.196 -11.582  1.00 26.10           N  
ATOM   2884  CD2 HIS B  96      26.028  12.978 -11.704  1.00 26.00           C  
ATOM   2885  CE1 HIS B  96      26.583  11.254 -10.465  1.00 26.40           C  
ATOM   2886  NE2 HIS B  96      25.817  12.327 -10.510  1.00 25.77           N  
ATOM   2887  N   ASP B  97      29.160  13.816 -16.038  1.00 22.95           N  
ATOM   2888  CA  ASP B  97      29.753  13.685 -17.362  1.00 23.75           C  
ATOM   2889  C   ASP B  97      31.163  14.240 -17.498  1.00 23.35           C  
ATOM   2890  O   ASP B  97      31.813  13.993 -18.521  1.00 24.56           O  
ATOM   2891  CB  ASP B  97      28.866  14.369 -18.415  1.00 24.97           C  
ATOM   2892  CG  ASP B  97      27.556  13.640 -18.609  1.00 29.25           C  
ATOM   2893  OD1 ASP B  97      27.372  12.570 -17.983  1.00 35.26           O  
ATOM   2894  OD2 ASP B  97      26.716  14.116 -19.392  1.00 37.93           O  
ATOM   2895  N   GLY B  98      31.617  15.018 -16.523  1.00 21.64           N  
ATOM   2896  CA  GLY B  98      32.962  15.595 -16.560  1.00 21.71           C  
ATOM   2897  C   GLY B  98      34.025  14.794 -15.811  1.00 20.31           C  
ATOM   2898  O   GLY B  98      35.190  15.176 -15.785  1.00 18.41           O  
ATOM   2899  N   ILE B  99      33.641  13.657 -15.244  1.00 19.48           N  
ATOM   2900  CA  ILE B  99      34.524  12.923 -14.362  1.00 19.30           C  
ATOM   2901  C   ILE B  99      35.703  12.311 -15.108  1.00 19.34           C  
ATOM   2902  O   ILE B  99      36.839  12.362 -14.632  1.00 19.14           O  
ATOM   2903  CB  ILE B  99      33.740  11.873 -13.499  1.00 19.94           C  
ATOM   2904  CG1 ILE B  99      32.856  12.601 -12.475  1.00 19.97           C  
ATOM   2905  CG2 ILE B  99      34.704  10.929 -12.754  1.00 19.68           C  
ATOM   2906  CD1 ILE B  99      31.833  11.735 -11.788  1.00 19.79           C  
ATOM   2907  N   LEU B 100      35.461  11.736 -16.278  1.00 19.01           N  
ATOM   2908  CA  LEU B 100      36.547  11.093 -17.016  1.00 18.45           C  
ATOM   2909  C   LEU B 100      37.624  12.119 -17.407  1.00 18.90           C  
ATOM   2910  O   LEU B 100      38.803  11.855 -17.290  1.00 19.32           O  
ATOM   2911  CB  LEU B 100      35.993  10.378 -18.236  1.00 18.37           C  
ATOM   2912  CG  LEU B 100      35.278   9.054 -17.971  1.00 18.80           C  
ATOM   2913  CD1 LEU B 100      34.585   8.585 -19.220  1.00 18.48           C  
ATOM   2914  CD2 LEU B 100      36.270   8.023 -17.458  1.00 19.47           C  
ATOM   2915  N   ALA B 101      37.190  13.283 -17.890  1.00 19.33           N  
ATOM   2916  CA  ALA B 101      38.088  14.404 -18.191  1.00 19.51           C  
ATOM   2917  C   ALA B 101      38.911  14.865 -16.991  1.00 19.95           C  
ATOM   2918  O   ALA B 101      40.124  15.083 -17.084  1.00 19.22           O  
ATOM   2919  CB  ALA B 101      37.266  15.572 -18.760  1.00 20.47           C  
ATOM   2920  N   LEU B 102      38.244  15.000 -15.847  1.00 20.59           N  
ATOM   2921  CA  LEU B 102      38.900  15.426 -14.618  1.00 20.13           C  
ATOM   2922  C   LEU B 102      39.946  14.411 -14.197  1.00 19.53           C  
ATOM   2923  O   LEU B 102      41.060  14.769 -13.818  1.00 18.56           O  
ATOM   2924  CB  LEU B 102      37.866  15.612 -13.509  1.00 19.96           C  
ATOM   2925  CG  LEU B 102      38.404  16.117 -12.165  1.00 20.25           C  
ATOM   2926  CD1 LEU B 102      39.022  17.554 -12.313  1.00 21.96           C  
ATOM   2927  CD2 LEU B 102      37.289  16.070 -11.137  1.00 21.61           C  
ATOM   2928  N   ARG B 103      39.586  13.133 -14.278  1.00 19.78           N  
ATOM   2929  CA  ARG B 103      40.492  12.049 -13.920  1.00 19.94           C  
ATOM   2930  C   ARG B 103      41.741  12.043 -14.813  1.00 20.05           C  
ATOM   2931  O   ARG B 103      42.842  11.841 -14.327  1.00 19.33           O  
ATOM   2932  CB  ARG B 103      39.729  10.721 -14.020  1.00 20.20           C  
ATOM   2933  CG  ARG B 103      40.537   9.491 -13.694  1.00 19.67           C  
ATOM   2934  CD  ARG B 103      39.584   8.319 -13.634  1.00 19.72           C  
ATOM   2935  NE  ARG B 103      40.178   6.987 -13.534  1.00 17.61           N  
ATOM   2936  CZ  ARG B 103      40.527   6.240 -14.584  1.00 19.13           C  
ATOM   2937  NH1 ARG B 103      40.482   6.719 -15.827  1.00 18.41           N  
ATOM   2938  NH2 ARG B 103      40.952   5.002 -14.391  1.00 17.57           N  
ATOM   2939  N   ARG B 104      41.572  12.285 -16.117  1.00 20.13           N  
ATOM   2940  CA  ARG B 104      42.716  12.365 -17.020  1.00 20.84           C  
ATOM   2941  C   ARG B 104      43.621  13.523 -16.618  1.00 20.03           C  
ATOM   2942  O   ARG B 104      44.830  13.403 -16.625  1.00 19.54           O  
ATOM   2943  CB  ARG B 104      42.277  12.569 -18.480  1.00 20.55           C  
ATOM   2944  CG  ARG B 104      41.720  11.313 -19.138  1.00 23.17           C  
ATOM   2945  CD  ARG B 104      41.598  11.424 -20.665  1.00 25.27           C  
ATOM   2946  NE  ARG B 104      40.728  12.530 -21.080  1.00 28.41           N  
ATOM   2947  CZ  ARG B 104      39.399  12.465 -21.198  1.00 30.09           C  
ATOM   2948  NH1 ARG B 104      38.726  11.344 -20.936  1.00 28.72           N  
ATOM   2949  NH2 ARG B 104      38.727  13.546 -21.603  1.00 31.64           N  
ATOM   2950  N   SER B 105      43.018  14.660 -16.290  1.00 20.38           N  
ATOM   2951  CA  SER B 105      43.770  15.884 -16.047  1.00 20.19           C  
ATOM   2952  C   SER B 105      44.523  15.822 -14.734  1.00 19.96           C  
ATOM   2953  O   SER B 105      45.735  16.093 -14.664  1.00 18.87           O  
ATOM   2954  CB  SER B 105      42.820  17.073 -16.008  1.00 20.24           C  
ATOM   2955  OG  SER B 105      43.582  18.236 -15.786  1.00 20.97           O  
ATOM   2956  N   LEU B 106      43.795  15.486 -13.676  1.00 19.30           N  
ATOM   2957  CA  LEU B 106      44.401  15.385 -12.357  1.00 18.67           C  
ATOM   2958  C   LEU B 106      45.338  14.182 -12.267  1.00 18.84           C  
ATOM   2959  O   LEU B 106      46.341  14.243 -11.579  1.00 18.67           O  
ATOM   2960  CB  LEU B 106      43.351  15.329 -11.258  1.00 18.50           C  
ATOM   2961  CG  LEU B 106      42.372  16.491 -11.157  1.00 17.51           C  
ATOM   2962  CD1 LEU B 106      41.688  16.423  -9.809  1.00 16.42           C  
ATOM   2963  CD2 LEU B 106      43.079  17.843 -11.315  1.00 18.31           C  
ATOM   2964  N   GLY B 107      45.024  13.098 -12.970  1.00 19.01           N  
ATOM   2965  CA  GLY B 107      45.884  11.913 -12.989  1.00 19.44           C  
ATOM   2966  C   GLY B 107      47.271  12.189 -13.560  1.00 19.97           C  
ATOM   2967  O   GLY B 107      48.279  11.711 -13.024  1.00 19.57           O  
ATOM   2968  N   ASP B 108      47.306  12.982 -14.626  1.00 20.37           N  
ATOM   2969  CA  ASP B 108      48.557  13.382 -15.267  1.00 20.37           C  
ATOM   2970  C   ASP B 108      49.426  14.223 -14.326  1.00 20.58           C  
ATOM   2971  O   ASP B 108      50.613  13.928 -14.136  1.00 21.71           O  
ATOM   2972  CB  ASP B 108      48.249  14.144 -16.548  1.00 20.81           C  
ATOM   2973  CG  ASP B 108      49.512  14.600 -17.273  1.00 23.03           C  
ATOM   2974  OD1 ASP B 108      50.139  13.748 -17.951  1.00 29.41           O  
ATOM   2975  OD2 ASP B 108      49.866  15.789 -17.138  1.00 27.95           O  
ATOM   2976  N   ALA B 109      48.827  15.235 -13.713  1.00 20.07           N  
ATOM   2977  CA  ALA B 109      49.506  16.071 -12.729  1.00 20.01           C  
ATOM   2978  C   ALA B 109      50.009  15.276 -11.516  1.00 20.33           C  
ATOM   2979  O   ALA B 109      51.171  15.396 -11.096  1.00 19.87           O  
ATOM   2980  CB  ALA B 109      48.569  17.189 -12.270  1.00 20.45           C  
ATOM   2981  N   ALA B 110      49.146  14.422 -10.985  1.00 20.12           N  
ATOM   2982  CA  ALA B 110      49.497  13.613  -9.831  1.00 20.27           C  
ATOM   2983  C   ALA B 110      50.669  12.659 -10.100  1.00 20.36           C  
ATOM   2984  O   ALA B 110      51.572  12.507  -9.250  1.00 21.33           O  
ATOM   2985  CB  ALA B 110      48.230  12.832  -9.318  1.00 20.35           C  
ATOM   2986  N   GLY B 111      50.668  12.001 -11.256  1.00 20.81           N  
ATOM   2987  CA  GLY B 111      51.746  11.080 -11.628  1.00 21.68           C  
ATOM   2988  C   GLY B 111      53.089  11.777 -11.741  1.00 22.46           C  
ATOM   2989  O   GLY B 111      54.135  11.178 -11.454  1.00 23.25           O  
ATOM   2990  N   LYS B 112      53.061  13.040 -12.160  1.00 22.56           N  
ATOM   2991  CA  LYS B 112      54.276  13.852 -12.328  1.00 23.37           C  
ATOM   2992  C   LYS B 112      54.818  14.395 -11.015  1.00 23.52           C  
ATOM   2993  O   LYS B 112      55.998  14.715 -10.918  1.00 23.96           O  
ATOM   2994  CB  LYS B 112      54.000  15.006 -13.304  1.00 23.51           C  
ATOM   2995  CG  LYS B 112      53.876  14.538 -14.740  1.00 24.44           C  
ATOM   2996  CD  LYS B 112      53.298  15.580 -15.677  1.00 25.05           C  
ATOM   2997  CE  LYS B 112      53.354  15.058 -17.114  1.00 26.40           C  
ATOM   2998  NZ  LYS B 112      52.580  15.874 -18.077  1.00 28.84           N  
ATOM   2999  N   SER B 113      53.973  14.514  -9.996  1.00 23.51           N  
ATOM   3000  CA  SER B 113      54.409  15.061  -8.720  1.00 23.39           C  
ATOM   3001  C   SER B 113      54.582  13.997  -7.655  1.00 23.64           C  
ATOM   3002  O   SER B 113      55.116  14.300  -6.600  1.00 24.29           O  
ATOM   3003  CB  SER B 113      53.420  16.110  -8.210  1.00 24.11           C  
ATOM   3004  OG  SER B 113      52.175  15.525  -7.848  1.00 24.31           O  
ATOM   3005  N   GLY B 114      54.089  12.781  -7.896  1.00 22.07           N  
ATOM   3006  CA  GLY B 114      54.144  11.716  -6.901  1.00 21.39           C  
ATOM   3007  C   GLY B 114      52.954  11.752  -5.949  1.00 21.05           C  
ATOM   3008  O   GLY B 114      52.920  11.000  -4.998  1.00 22.60           O  
ATOM   3009  N   ALA B 115      51.980  12.613  -6.217  1.00 20.07           N  
ATOM   3010  CA  ALA B 115      50.795  12.759  -5.365  1.00 19.57           C  
ATOM   3011  C   ALA B 115      49.625  11.908  -5.874  1.00 18.50           C  
ATOM   3012  O   ALA B 115      49.710  11.269  -6.926  1.00 16.69           O  
ATOM   3013  CB  ALA B 115      50.385  14.229  -5.256  1.00 20.13           C  
ATOM   3014  N   ALA B 116      48.554  11.873  -5.091  1.00 18.34           N  
ATOM   3015  CA  ALA B 116      47.321  11.167  -5.470  1.00 18.30           C  
ATOM   3016  C   ALA B 116      46.141  12.116  -5.337  1.00 18.03           C  
ATOM   3017  O   ALA B 116      46.095  12.899  -4.370  1.00 18.00           O  
ATOM   3018  CB  ALA B 116      47.112   9.913  -4.592  1.00 18.35           C  
ATOM   3019  N   ALA B 117      45.223  12.062  -6.319  1.00 17.31           N  
ATOM   3020  CA  ALA B 117      43.941  12.768  -6.277  1.00 16.97           C  
ATOM   3021  C   ALA B 117      42.796  11.764  -6.186  1.00 17.12           C  
ATOM   3022  O   ALA B 117      42.701  10.855  -7.020  1.00 15.98           O  
ATOM   3023  CB  ALA B 117      43.771  13.606  -7.521  1.00 15.86           C  
ATOM   3024  N   VAL B 118      41.926  11.924  -5.187  1.00 16.92           N  
ATOM   3025  CA  VAL B 118      40.699  11.122  -5.098  1.00 16.91           C  
ATOM   3026  C   VAL B 118      39.555  12.073  -5.411  1.00 17.22           C  
ATOM   3027  O   VAL B 118      39.376  13.117  -4.743  1.00 18.27           O  
ATOM   3028  CB  VAL B 118      40.536  10.402  -3.748  1.00 17.06           C  
ATOM   3029  CG1 VAL B 118      39.176   9.669  -3.699  1.00 16.47           C  
ATOM   3030  CG2 VAL B 118      41.740   9.444  -3.513  1.00 16.44           C  
ATOM   3031  N   ILE B 119      38.846  11.768  -6.486  1.00 16.54           N  
ATOM   3032  CA  ILE B 119      38.002  12.764  -7.143  1.00 15.93           C  
ATOM   3033  C   ILE B 119      36.524  12.411  -7.052  1.00 15.83           C  
ATOM   3034  O   ILE B 119      36.162  11.261  -6.778  1.00 16.89           O  
ATOM   3035  CB  ILE B 119      38.387  12.951  -8.622  1.00 15.08           C  
ATOM   3036  CG1 ILE B 119      37.925  11.774  -9.477  1.00 16.18           C  
ATOM   3037  CG2 ILE B 119      39.873  13.202  -8.770  1.00 16.87           C  
ATOM   3038  CD1 ILE B 119      38.325  11.806 -10.919  1.00 15.87           C  
ATOM   3039  N   ALA B 120      35.659  13.401  -7.244  1.00 15.48           N  
ATOM   3040  CA  ALA B 120      34.216  13.178  -7.301  1.00 15.30           C  
ATOM   3041  C   ALA B 120      33.735  12.392  -6.097  1.00 15.06           C  
ATOM   3042  O   ALA B 120      32.907  11.480  -6.217  1.00 15.86           O  
ATOM   3043  CB  ALA B 120      33.819  12.449  -8.609  1.00 16.10           C  
ATOM   3044  N   SER B 121      34.239  12.782  -4.947  1.00 14.51           N  
ATOM   3045  CA  SER B 121      33.982  12.069  -3.688  1.00 15.63           C  
ATOM   3046  C   SER B 121      33.028  12.815  -2.750  1.00 16.01           C  
ATOM   3047  O   SER B 121      33.401  13.198  -1.645  1.00 16.05           O  
ATOM   3048  CB  SER B 121      35.312  11.805  -3.022  1.00 16.12           C  
ATOM   3049  OG  SER B 121      36.044  10.857  -3.803  1.00 17.42           O  
ATOM   3050  N   GLY B 122      31.793  13.004  -3.194  1.00 16.59           N  
ATOM   3051  CA  GLY B 122      30.696  13.386  -2.292  1.00 16.61           C  
ATOM   3052  C   GLY B 122      29.866  12.134  -2.097  1.00 16.58           C  
ATOM   3053  O   GLY B 122      30.417  11.035  -2.031  1.00 16.19           O  
ATOM   3054  N   TRP B 123      28.550  12.276  -2.019  1.00 16.05           N  
ATOM   3055  CA  TRP B 123      27.693  11.095  -1.991  1.00 15.76           C  
ATOM   3056  C   TRP B 123      27.114  10.755  -3.357  1.00 15.49           C  
ATOM   3057  O   TRP B 123      26.848   9.584  -3.637  1.00 15.79           O  
ATOM   3058  CB  TRP B 123      26.622  11.136  -0.902  1.00 16.33           C  
ATOM   3059  CG  TRP B 123      25.700  12.327  -0.851  1.00 15.92           C  
ATOM   3060  CD1 TRP B 123      25.952  13.534  -0.272  1.00 16.00           C  
ATOM   3061  CD2 TRP B 123      24.355  12.388  -1.338  1.00 16.10           C  
ATOM   3062  NE1 TRP B 123      24.862  14.352  -0.379  1.00 15.83           N  
ATOM   3063  CE2 TRP B 123      23.854  13.667  -1.011  1.00 17.36           C  
ATOM   3064  CE3 TRP B 123      23.516  11.480  -1.994  1.00 16.91           C  
ATOM   3065  CZ2 TRP B 123      22.576  14.073  -1.368  1.00 18.19           C  
ATOM   3066  CZ3 TRP B 123      22.229  11.873  -2.303  1.00 16.35           C  
ATOM   3067  CH2 TRP B 123      21.767  13.143  -1.982  1.00 17.66           C  
ATOM   3068  N   ASP B 124      26.931  11.735  -4.237  1.00 14.92           N  
ATOM   3069  CA  ASP B 124      26.596  11.344  -5.616  1.00 15.75           C  
ATOM   3070  C   ASP B 124      26.967  12.467  -6.582  1.00 15.82           C  
ATOM   3071  O   ASP B 124      26.335  13.507  -6.563  1.00 16.95           O  
ATOM   3072  CB  ASP B 124      25.118  10.922  -5.745  1.00 16.26           C  
ATOM   3073  CG  ASP B 124      24.897   9.877  -6.839  1.00 17.49           C  
ATOM   3074  OD1 ASP B 124      25.615   9.969  -7.867  1.00 17.44           O  
ATOM   3075  OD2 ASP B 124      24.060   8.945  -6.667  1.00 15.19           O  
ATOM   3076  N   PRO B 125      28.063  12.299  -7.346  1.00 15.69           N  
ATOM   3077  CA  PRO B 125      28.930  11.145  -7.385  1.00 16.01           C  
ATOM   3078  C   PRO B 125      29.699  10.970  -6.088  1.00 16.36           C  
ATOM   3079  O   PRO B 125      29.847  11.928  -5.291  1.00 15.16           O  
ATOM   3080  CB  PRO B 125      29.891  11.466  -8.524  1.00 17.09           C  
ATOM   3081  CG  PRO B 125      29.911  12.936  -8.571  1.00 16.78           C  
ATOM   3082  CD  PRO B 125      28.544  13.366  -8.234  1.00 16.22           C  
ATOM   3083  N   GLY B 126      30.179   9.750  -5.879  1.00 15.27           N  
ATOM   3084  CA  GLY B 126      31.052   9.428  -4.758  1.00 15.48           C  
ATOM   3085  C   GLY B 126      30.602   8.142  -4.096  1.00 14.62           C  
ATOM   3086  O   GLY B 126      30.670   7.068  -4.702  1.00 15.89           O  
ATOM   3087  N   SER B 127      30.089   8.229  -2.882  1.00 15.30           N  
ATOM   3088  CA  SER B 127      29.738   7.018  -2.142  1.00 15.26           C  
ATOM   3089  C   SER B 127      28.659   6.220  -2.883  1.00 15.58           C  
ATOM   3090  O   SER B 127      28.790   5.003  -2.992  1.00 15.89           O  
ATOM   3091  CB  SER B 127      29.368   7.311  -0.681  1.00 15.84           C  
ATOM   3092  OG  SER B 127      28.343   8.261  -0.594  1.00 14.80           O  
ATOM   3093  N   ASP B 128      27.663   6.894  -3.468  1.00 15.23           N  
ATOM   3094  CA  ASP B 128      26.615   6.207  -4.249  1.00 14.65           C  
ATOM   3095  C   ASP B 128      27.236   5.473  -5.442  1.00 14.63           C  
ATOM   3096  O   ASP B 128      26.752   4.404  -5.820  1.00 14.69           O  
ATOM   3097  CB  ASP B 128      25.577   7.167  -4.831  1.00 13.94           C  
ATOM   3098  CG  ASP B 128      24.548   7.662  -3.827  1.00 15.67           C  
ATOM   3099  OD1 ASP B 128      24.589   7.304  -2.632  1.00 14.15           O  
ATOM   3100  OD2 ASP B 128      23.669   8.426  -4.279  1.00 14.58           O  
ATOM   3101  N   SER B 129      28.287   6.045  -6.027  1.00 14.04           N  
ATOM   3102  CA  SER B 129      29.012   5.425  -7.146  1.00 14.41           C  
ATOM   3103  C   SER B 129      29.587   4.067  -6.793  1.00 13.46           C  
ATOM   3104  O   SER B 129      29.540   3.168  -7.601  1.00 14.03           O  
ATOM   3105  CB  SER B 129      30.125   6.337  -7.670  1.00 14.81           C  
ATOM   3106  OG  SER B 129      29.615   7.648  -7.853  1.00 16.78           O  
ATOM   3107  N   VAL B 130      30.068   3.920  -5.573  1.00 13.00           N  
ATOM   3108  CA  VAL B 130      30.582   2.654  -5.080  1.00 13.27           C  
ATOM   3109  C   VAL B 130      29.467   1.608  -5.025  1.00 12.90           C  
ATOM   3110  O   VAL B 130      29.585   0.538  -5.571  1.00 13.76           O  
ATOM   3111  CB  VAL B 130      31.224   2.829  -3.657  1.00 13.54           C  
ATOM   3112  CG1 VAL B 130      31.662   1.459  -3.087  1.00 15.80           C  
ATOM   3113  CG2 VAL B 130      32.427   3.809  -3.679  1.00 14.18           C  
ATOM   3114  N   VAL B 131      28.361   1.950  -4.390  1.00 13.65           N  
ATOM   3115  CA  VAL B 131      27.184   1.055  -4.351  1.00 12.98           C  
ATOM   3116  C   VAL B 131      26.684   0.673  -5.741  1.00 12.36           C  
ATOM   3117  O   VAL B 131      26.475  -0.489  -6.009  1.00 13.57           O  
ATOM   3118  CB  VAL B 131      26.041   1.660  -3.504  1.00 14.65           C  
ATOM   3119  CG1 VAL B 131      24.927   0.613  -3.371  1.00 13.89           C  
ATOM   3120  CG2 VAL B 131      26.575   2.064  -2.150  1.00 13.85           C  
ATOM   3121  N   ARG B 132      26.577   1.639  -6.651  1.00 12.43           N  
ATOM   3122  CA  ARG B 132      26.099   1.414  -7.973  1.00 13.25           C  
ATOM   3123  C   ARG B 132      27.006   0.457  -8.742  1.00 13.32           C  
ATOM   3124  O   ARG B 132      26.529  -0.370  -9.530  1.00 13.97           O  
ATOM   3125  CB  ARG B 132      25.997   2.781  -8.704  1.00 13.70           C  
ATOM   3126  CG  ARG B 132      25.043   2.844  -9.801  1.00 17.22           C  
ATOM   3127  CD  ARG B 132      24.431   4.285 -10.079  1.00 15.66           C  
ATOM   3128  NE  ARG B 132      25.408   5.366  -9.901  1.00 15.90           N  
ATOM   3129  CZ  ARG B 132      25.236   6.459  -9.166  1.00 14.01           C  
ATOM   3130  NH1 ARG B 132      24.109   6.683  -8.485  1.00 15.53           N  
ATOM   3131  NH2 ARG B 132      26.193   7.333  -9.082  1.00 16.54           N  
ATOM   3132  N   THR B 133      28.310   0.582  -8.519  1.00 13.14           N  
ATOM   3133  CA  THR B 133      29.305  -0.258  -9.173  1.00 12.63           C  
ATOM   3134  C   THR B 133      29.266  -1.679  -8.638  1.00 12.24           C  
ATOM   3135  O   THR B 133      29.263  -2.645  -9.400  1.00 12.98           O  
ATOM   3136  CB  THR B 133      30.692   0.424  -9.107  1.00 12.53           C  
ATOM   3137  OG1 THR B 133      30.587   1.724  -9.735  1.00 13.53           O  
ATOM   3138  CG2 THR B 133      31.769  -0.385  -9.822  1.00 12.99           C  
ATOM   3139  N   LEU B 134      29.157  -1.811  -7.336  1.00 13.16           N  
ATOM   3140  CA  LEU B 134      28.976  -3.120  -6.724  1.00 13.54           C  
ATOM   3141  C   LEU B 134      27.730  -3.846  -7.262  1.00 13.39           C  
ATOM   3142  O   LEU B 134      27.817  -5.026  -7.626  1.00 14.36           O  
ATOM   3143  CB  LEU B 134      28.959  -3.013  -5.211  1.00 13.05           C  
ATOM   3144  CG  LEU B 134      28.770  -4.319  -4.400  1.00 13.52           C  
ATOM   3145  CD1 LEU B 134      29.991  -5.254  -4.544  1.00 15.40           C  
ATOM   3146  CD2 LEU B 134      28.501  -3.973  -2.932  1.00 15.05           C  
HETATM 3147  N   MSE B 135      26.599  -3.143  -7.350  1.00 12.92           N  
HETATM 3148  CA  MSE B 135      25.358  -3.686  -7.846  1.00 13.73           C  
HETATM 3149  C   MSE B 135      25.493  -4.149  -9.277  1.00 13.37           C  
HETATM 3150  O   MSE B 135      25.008  -5.225  -9.625  1.00 12.90           O  
HETATM 3151  CB  MSE B 135      24.246  -2.616  -7.757  1.00 14.33           C  
HETATM 3152  CG  MSE B 135      23.780  -2.356  -6.336  1.00 15.50           C  
HETATM 3153 SE   MSE B 135      22.161  -1.239  -6.481  0.80 20.74          SE  
HETATM 3154  CE  MSE B 135      21.654  -1.101  -4.574  1.00 17.86           C  
ATOM   3155  N   GLN B 136      26.168  -3.340 -10.094  1.00 13.85           N  
ATOM   3156  CA  GLN B 136      26.410  -3.687 -11.487  1.00 14.04           C  
ATOM   3157  C   GLN B 136      27.200  -4.978 -11.610  1.00 14.04           C  
ATOM   3158  O   GLN B 136      26.938  -5.797 -12.495  1.00 14.43           O  
ATOM   3159  CB  GLN B 136      27.148  -2.561 -12.219  1.00 14.63           C  
ATOM   3160  CG  GLN B 136      27.131  -2.698 -13.736  1.00 14.44           C  
ATOM   3161  CD  GLN B 136      25.835  -2.268 -14.368  1.00 15.86           C  
ATOM   3162  OE1 GLN B 136      25.106  -1.466 -13.808  1.00 18.15           O  
ATOM   3163  NE2 GLN B 136      25.544  -2.803 -15.575  1.00 19.24           N  
ATOM   3164  N   ALA B 137      28.149  -5.178 -10.714  1.00 14.28           N  
ATOM   3165  CA  ALA B 137      29.053  -6.347 -10.775  1.00 13.54           C  
ATOM   3166  C   ALA B 137      28.350  -7.637 -10.402  1.00 13.07           C  
ATOM   3167  O   ALA B 137      28.497  -8.675 -11.079  1.00 13.16           O  
ATOM   3168  CB  ALA B 137      30.277  -6.097  -9.856  1.00 12.05           C  
ATOM   3169  N   ILE B 138      27.562  -7.592  -9.339  1.00 12.82           N  
ATOM   3170  CA  ILE B 138      26.950  -8.799  -8.771  1.00 13.29           C  
ATOM   3171  C   ILE B 138      25.575  -9.173  -9.348  1.00 13.72           C  
ATOM   3172  O   ILE B 138      25.107 -10.283  -9.152  1.00 13.42           O  
ATOM   3173  CB  ILE B 138      26.980  -8.754  -7.218  1.00 13.79           C  
ATOM   3174  CG1 ILE B 138      25.977  -7.778  -6.625  1.00 12.42           C  
ATOM   3175  CG2 ILE B 138      28.388  -8.402  -6.753  1.00 14.53           C  
ATOM   3176  CD1 ILE B 138      26.074  -7.707  -5.075  1.00 12.24           C  
ATOM   3177  N   VAL B 139      24.991  -8.254 -10.120  1.00 13.62           N  
ATOM   3178  CA  VAL B 139      23.807  -8.496 -10.899  1.00 13.61           C  
ATOM   3179  C   VAL B 139      24.083  -7.912 -12.280  1.00 14.33           C  
ATOM   3180  O   VAL B 139      23.657  -6.816 -12.577  1.00 14.12           O  
ATOM   3181  CB  VAL B 139      22.552  -7.816 -10.226  1.00 13.10           C  
ATOM   3182  CG1 VAL B 139      21.325  -8.074 -11.040  1.00 14.13           C  
ATOM   3183  CG2 VAL B 139      22.358  -8.371  -8.795  1.00 14.79           C  
ATOM   3184  N   PRO B 140      24.879  -8.621 -13.102  1.00 14.74           N  
ATOM   3185  CA  PRO B 140      25.402  -7.976 -14.302  1.00 14.72           C  
ATOM   3186  C   PRO B 140      24.411  -7.639 -15.401  1.00 13.99           C  
ATOM   3187  O   PRO B 140      24.759  -6.879 -16.314  1.00 15.24           O  
ATOM   3188  CB  PRO B 140      26.436  -8.986 -14.834  1.00 15.21           C  
ATOM   3189  CG  PRO B 140      26.544 -10.048 -13.855  1.00 16.23           C  
ATOM   3190  CD  PRO B 140      25.425  -9.975 -12.909  1.00 15.81           C  
ATOM   3191  N   LYS B 141      23.232  -8.250 -15.401  1.00 13.73           N  
ATOM   3192  CA  LYS B 141      22.194  -7.874 -16.371  1.00 14.66           C  
ATOM   3193  C   LYS B 141      21.026  -7.274 -15.617  1.00 14.23           C  
ATOM   3194  O   LYS B 141      20.688  -7.712 -14.508  1.00 12.77           O  
ATOM   3195  CB  LYS B 141      21.723  -9.045 -17.221  1.00 15.45           C  
ATOM   3196  CG  LYS B 141      22.779  -9.620 -18.167  1.00 18.05           C  
ATOM   3197  CD  LYS B 141      22.237 -10.790 -18.964  1.00 19.51           C  
ATOM   3198  CE  LYS B 141      23.263 -11.337 -19.963  1.00 24.13           C  
ATOM   3199  NZ  LYS B 141      22.637 -11.592 -21.350  1.00 29.68           N  
ATOM   3200  N   GLY B 142      20.395  -6.281 -16.202  1.00 13.15           N  
ATOM   3201  CA  GLY B 142      19.309  -5.572 -15.528  1.00 12.96           C  
ATOM   3202  C   GLY B 142      19.475  -4.069 -15.639  1.00 14.01           C  
ATOM   3203  O   GLY B 142      20.304  -3.580 -16.411  1.00 13.20           O  
ATOM   3204  N   ILE B 143      18.715  -3.341 -14.823  1.00 13.69           N  
ATOM   3205  CA  ILE B 143      18.686  -1.893 -14.851  1.00 14.00           C  
ATOM   3206  C   ILE B 143      18.762  -1.347 -13.420  1.00 13.66           C  
ATOM   3207  O   ILE B 143      18.065  -1.868 -12.525  1.00 13.12           O  
ATOM   3208  CB  ILE B 143      17.364  -1.399 -15.487  1.00 14.22           C  
ATOM   3209  CG1 ILE B 143      17.242  -1.889 -16.935  1.00 14.01           C  
ATOM   3210  CG2 ILE B 143      17.273   0.142 -15.455  1.00 14.27           C  
ATOM   3211  CD1 ILE B 143      15.844  -1.678 -17.525  1.00 13.15           C  
ATOM   3212  N   THR B 144      19.592  -0.319 -13.223  1.00 13.68           N  
ATOM   3213  CA  THR B 144      19.664   0.417 -11.955  1.00 13.91           C  
ATOM   3214  C   THR B 144      19.014   1.767 -12.078  1.00 14.67           C  
ATOM   3215  O   THR B 144      19.230   2.500 -13.079  1.00 14.95           O  
ATOM   3216  CB  THR B 144      21.130   0.617 -11.505  1.00 15.97           C  
ATOM   3217  OG1 THR B 144      21.711  -0.667 -11.317  1.00 15.33           O  
ATOM   3218  CG2 THR B 144      21.218   1.367 -10.161  1.00 14.09           C  
ATOM   3219  N   TYR B 145      18.204   2.113 -11.089  1.00 13.98           N  
ATOM   3220  CA  TYR B 145      17.575   3.429 -11.048  1.00 14.23           C  
ATOM   3221  C   TYR B 145      18.091   4.128  -9.795  1.00 14.03           C  
ATOM   3222  O   TYR B 145      18.127   3.510  -8.719  1.00 15.40           O  
ATOM   3223  CB  TYR B 145      16.066   3.273 -10.999  1.00 14.84           C  
ATOM   3224  CG  TYR B 145      15.479   2.665 -12.238  1.00 15.16           C  
ATOM   3225  CD1 TYR B 145      15.591   3.321 -13.446  1.00 17.91           C  
ATOM   3226  CD2 TYR B 145      14.793   1.461 -12.213  1.00 17.24           C  
ATOM   3227  CE1 TYR B 145      15.024   2.804 -14.613  1.00 17.67           C  
ATOM   3228  CE2 TYR B 145      14.246   0.920 -13.386  1.00 17.11           C  
ATOM   3229  CZ  TYR B 145      14.363   1.614 -14.585  1.00 15.37           C  
ATOM   3230  OH  TYR B 145      13.827   1.127 -15.784  1.00 18.31           O  
ATOM   3231  N   THR B 146      18.502   5.380  -9.943  1.00 14.21           N  
ATOM   3232  CA  THR B 146      18.900   6.234  -8.826  1.00 13.41           C  
ATOM   3233  C   THR B 146      17.864   7.378  -8.672  1.00 13.32           C  
ATOM   3234  O   THR B 146      17.692   8.226  -9.556  1.00 13.37           O  
ATOM   3235  CB  THR B 146      20.346   6.790  -8.992  1.00 14.47           C  
ATOM   3236  OG1 THR B 146      21.275   5.729  -9.233  1.00 14.48           O  
ATOM   3237  CG2 THR B 146      20.773   7.574  -7.764  1.00 14.51           C  
ATOM   3238  N   ASN B 147      17.205   7.386  -7.531  1.00 12.64           N  
ATOM   3239  CA  ASN B 147      16.073   8.235  -7.235  1.00 13.16           C  
ATOM   3240  C   ASN B 147      16.482   9.168  -6.103  1.00 12.09           C  
ATOM   3241  O   ASN B 147      16.777   8.711  -4.994  1.00 13.63           O  
ATOM   3242  CB  ASN B 147      14.884   7.372  -6.826  1.00 12.52           C  
ATOM   3243  CG  ASN B 147      14.539   6.342  -7.863  1.00 15.83           C  
ATOM   3244  OD1 ASN B 147      14.117   6.711  -8.953  1.00 13.27           O  
ATOM   3245  ND2 ASN B 147      14.750   5.023  -7.550  1.00 13.15           N  
ATOM   3246  N   PHE B 148      16.529  10.459  -6.402  1.00 12.16           N  
ATOM   3247  CA  PHE B 148      16.942  11.491  -5.473  1.00 12.75           C  
ATOM   3248  C   PHE B 148      15.808  12.190  -4.742  1.00 13.43           C  
ATOM   3249  O   PHE B 148      14.747  12.458  -5.312  1.00 12.41           O  
ATOM   3250  CB  PHE B 148      17.766  12.543  -6.217  1.00 12.84           C  
ATOM   3251  CG  PHE B 148      19.074  12.031  -6.689  1.00 13.59           C  
ATOM   3252  CD1 PHE B 148      20.072  11.666  -5.770  1.00 14.26           C  
ATOM   3253  CD2 PHE B 148      19.314  11.860  -8.029  1.00 13.45           C  
ATOM   3254  CE1 PHE B 148      21.295  11.196  -6.217  1.00 14.62           C  
ATOM   3255  CE2 PHE B 148      20.512  11.358  -8.472  1.00 15.16           C  
ATOM   3256  CZ  PHE B 148      21.515  11.050  -7.566  1.00 12.46           C  
ATOM   3257  N   GLY B 149      16.088  12.524  -3.474  1.00 13.32           N  
ATOM   3258  CA  GLY B 149      15.233  13.369  -2.670  1.00 14.35           C  
ATOM   3259  C   GLY B 149      14.237  12.611  -1.805  1.00 14.89           C  
ATOM   3260  O   GLY B 149      14.339  11.373  -1.651  1.00 16.15           O  
ATOM   3261  N   PRO B 150      13.270  13.335  -1.215  1.00 14.67           N  
ATOM   3262  CA  PRO B 150      13.084  14.800  -1.335  1.00 14.74           C  
ATOM   3263  C   PRO B 150      14.254  15.609  -0.764  1.00 14.23           C  
ATOM   3264  O   PRO B 150      14.819  15.260   0.290  1.00 12.76           O  
ATOM   3265  CB  PRO B 150      11.843  15.077  -0.489  1.00 14.82           C  
ATOM   3266  CG  PRO B 150      11.185  13.779  -0.307  1.00 17.32           C  
ATOM   3267  CD  PRO B 150      12.231  12.718  -0.381  1.00 15.39           C  
ATOM   3268  N   GLY B 151      14.645  16.647  -1.472  1.00 12.88           N  
ATOM   3269  CA  GLY B 151      15.753  17.477  -1.020  1.00 13.58           C  
ATOM   3270  C   GLY B 151      15.996  18.630  -1.976  1.00 15.06           C  
ATOM   3271  O   GLY B 151      15.532  18.613  -3.111  1.00 15.81           O  
HETATM 3272  N   MSE B 152      16.745  19.628  -1.504  1.00 16.60           N  
HETATM 3273  CA  MSE B 152      17.079  20.781  -2.300  1.00 18.76           C  
HETATM 3274  C   MSE B 152      18.127  20.447  -3.355  1.00 18.74           C  
HETATM 3275  O   MSE B 152      19.140  19.819  -3.050  1.00 19.00           O  
HETATM 3276  CB  MSE B 152      17.608  21.894  -1.392  1.00 19.35           C  
HETATM 3277  CG  MSE B 152      18.022  23.120  -2.122  1.00 20.65           C  
HETATM 3278 SE   MSE B 152      18.501  24.541  -0.859  0.70 24.92          SE  
HETATM 3279  CE  MSE B 152      18.550  25.904  -2.201  1.00 22.18           C  
ATOM   3280  N   SER B 153      17.868  20.883  -4.589  1.00 18.78           N  
ATOM   3281  CA  SER B 153      18.827  20.828  -5.676  1.00 19.97           C  
ATOM   3282  C   SER B 153      19.564  22.139  -5.779  1.00 20.25           C  
ATOM   3283  O   SER B 153      18.957  23.191  -6.057  1.00 20.23           O  
ATOM   3284  CB  SER B 153      18.120  20.580  -7.022  1.00 19.80           C  
ATOM   3285  OG  SER B 153      19.045  20.680  -8.108  1.00 20.14           O  
HETATM 3286  N   MSE B 154      20.870  22.101  -5.579  1.00 21.51           N  
HETATM 3287  CA  MSE B 154      21.632  23.347  -5.609  1.00 22.83           C  
HETATM 3288  C   MSE B 154      21.628  23.872  -7.029  1.00 22.81           C  
HETATM 3289  O   MSE B 154      21.381  25.048  -7.252  1.00 21.54           O  
HETATM 3290  CB  MSE B 154      23.049  23.145  -5.109  1.00 24.13           C  
HETATM 3291  CG  MSE B 154      23.124  22.579  -3.697  1.00 27.60           C  
HETATM 3292 SE   MSE B 154      22.138  23.643  -2.360  0.70 36.42          SE  
HETATM 3293  CE  MSE B 154      22.362  22.471  -0.816  1.00 31.50           C  
ATOM   3294  N   GLY B 155      21.902  22.977  -7.983  1.00 22.62           N  
ATOM   3295  CA  GLY B 155      21.987  23.349  -9.385  1.00 22.44           C  
ATOM   3296  C   GLY B 155      20.696  23.894  -9.948  1.00 21.75           C  
ATOM   3297  O   GLY B 155      20.689  24.898 -10.687  1.00 20.98           O  
ATOM   3298  N   HIS B 156      19.588  23.228  -9.657  1.00 21.36           N  
ATOM   3299  CA  HIS B 156      18.302  23.684 -10.151  1.00 21.25           C  
ATOM   3300  C   HIS B 156      17.857  24.982  -9.481  1.00 21.08           C  
ATOM   3301  O   HIS B 156      17.238  25.839 -10.115  1.00 22.02           O  
ATOM   3302  CB  HIS B 156      17.233  22.591 -10.003  1.00 22.48           C  
ATOM   3303  CG  HIS B 156      17.310  21.547 -11.068  1.00 23.37           C  
ATOM   3304  ND1 HIS B 156      18.306  20.595 -11.100  1.00 26.02           N  
ATOM   3305  CD2 HIS B 156      16.553  21.338 -12.168  1.00 24.83           C  
ATOM   3306  CE1 HIS B 156      18.142  19.829 -12.162  1.00 26.13           C  
ATOM   3307  NE2 HIS B 156      17.079  20.255 -12.824  1.00 26.67           N  
ATOM   3308  N   THR B 157      18.202  25.153  -8.216  1.00 20.99           N  
ATOM   3309  CA  THR B 157      17.898  26.385  -7.513  1.00 21.46           C  
ATOM   3310  C   THR B 157      18.646  27.569  -8.154  1.00 22.06           C  
ATOM   3311  O   THR B 157      18.066  28.640  -8.359  1.00 22.86           O  
ATOM   3312  CB  THR B 157      18.226  26.271  -6.017  1.00 21.04           C  
ATOM   3313  OG1 THR B 157      17.392  25.274  -5.408  1.00 21.14           O  
ATOM   3314  CG2 THR B 157      18.026  27.618  -5.320  1.00 20.34           C  
ATOM   3315  N   VAL B 158      19.921  27.366  -8.482  1.00 22.29           N  
ATOM   3316  CA  VAL B 158      20.722  28.381  -9.188  1.00 22.45           C  
ATOM   3317  C   VAL B 158      20.046  28.761 -10.502  1.00 22.92           C  
ATOM   3318  O   VAL B 158      19.932  29.936 -10.802  1.00 21.87           O  
ATOM   3319  CB  VAL B 158      22.189  27.906  -9.436  1.00 22.61           C  
ATOM   3320  CG1 VAL B 158      22.923  28.827 -10.455  1.00 21.75           C  
ATOM   3321  CG2 VAL B 158      22.961  27.822  -8.105  1.00 22.88           C  
ATOM   3322  N   ALA B 159      19.580  27.758 -11.257  1.00 23.60           N  
ATOM   3323  CA  ALA B 159      18.889  27.959 -12.534  1.00 24.10           C  
ATOM   3324  C   ALA B 159      17.629  28.814 -12.399  1.00 24.76           C  
ATOM   3325  O   ALA B 159      17.369  29.687 -13.252  1.00 24.73           O  
ATOM   3326  CB  ALA B 159      18.558  26.620 -13.172  1.00 24.33           C  
ATOM   3327  N   VAL B 160      16.855  28.589 -11.335  1.00 25.10           N  
ATOM   3328  CA  VAL B 160      15.641  29.376 -11.090  1.00 25.39           C  
ATOM   3329  C   VAL B 160      15.960  30.826 -10.700  1.00 26.27           C  
ATOM   3330  O   VAL B 160      15.274  31.766 -11.146  1.00 27.27           O  
ATOM   3331  CB  VAL B 160      14.750  28.712 -10.021  1.00 25.38           C  
ATOM   3332  CG1 VAL B 160      13.510  29.573  -9.727  1.00 24.67           C  
ATOM   3333  CG2 VAL B 160      14.336  27.327 -10.470  1.00 23.85           C  
ATOM   3334  N   LYS B 161      17.016  31.027  -9.909  1.00 26.89           N  
ATOM   3335  CA  LYS B 161      17.400  32.378  -9.490  1.00 27.16           C  
ATOM   3336  C   LYS B 161      17.876  33.213 -10.660  1.00 26.98           C  
ATOM   3337  O   LYS B 161      17.860  34.434 -10.570  1.00 26.54           O  
ATOM   3338  CB  LYS B 161      18.498  32.345  -8.426  1.00 27.70           C  
ATOM   3339  CG  LYS B 161      18.057  31.713  -7.126  1.00 29.18           C  
ATOM   3340  CD  LYS B 161      19.132  31.813  -6.033  1.00 30.05           C  
ATOM   3341  CE  LYS B 161      18.606  31.291  -4.693  1.00 32.79           C  
ATOM   3342  NZ  LYS B 161      17.819  32.329  -3.891  1.00 33.20           N  
ATOM   3343  N   ALA B 162      18.299  32.562 -11.745  1.00 26.81           N  
ATOM   3344  CA  ALA B 162      18.704  33.266 -12.973  1.00 26.70           C  
ATOM   3345  C   ALA B 162      17.539  33.746 -13.850  1.00 26.83           C  
ATOM   3346  O   ALA B 162      17.742  34.540 -14.781  1.00 26.43           O  
ATOM   3347  CB  ALA B 162      19.644  32.376 -13.791  1.00 26.67           C  
ATOM   3348  N   ILE B 163      16.321  33.294 -13.569  1.00 26.47           N  
ATOM   3349  CA  ILE B 163      15.161  33.607 -14.400  1.00 26.52           C  
ATOM   3350  C   ILE B 163      14.662  35.023 -14.088  1.00 26.72           C  
ATOM   3351  O   ILE B 163      14.582  35.407 -12.930  1.00 26.40           O  
ATOM   3352  CB  ILE B 163      14.021  32.587 -14.164  1.00 26.50           C  
ATOM   3353  CG1 ILE B 163      14.393  31.201 -14.707  1.00 26.63           C  
ATOM   3354  CG2 ILE B 163      12.702  33.080 -14.771  1.00 26.04           C  
ATOM   3355  CD1 ILE B 163      14.242  31.028 -16.177  1.00 26.22           C  
ATOM   3356  N   ASP B 164      14.300  35.796 -15.114  1.00 27.32           N  
ATOM   3357  CA  ASP B 164      13.847  37.170 -14.875  1.00 27.37           C  
ATOM   3358  C   ASP B 164      12.670  37.173 -13.912  1.00 27.03           C  
ATOM   3359  O   ASP B 164      11.746  36.373 -14.066  1.00 27.23           O  
ATOM   3360  CB  ASP B 164      13.399  37.831 -16.181  1.00 28.45           C  
ATOM   3361  CG  ASP B 164      14.545  38.076 -17.140  1.00 31.58           C  
ATOM   3362  OD1 ASP B 164      15.722  38.033 -16.709  1.00 36.65           O  
ATOM   3363  OD2 ASP B 164      14.268  38.326 -18.333  1.00 35.70           O  
ATOM   3364  N   GLY B 165      12.702  38.061 -12.921  1.00 25.63           N  
ATOM   3365  CA  GLY B 165      11.541  38.283 -12.061  1.00 25.10           C  
ATOM   3366  C   GLY B 165      11.577  37.473 -10.774  1.00 24.37           C  
ATOM   3367  O   GLY B 165      10.696  37.606  -9.931  1.00 23.95           O  
ATOM   3368  N   VAL B 166      12.618  36.665 -10.617  1.00 23.91           N  
ATOM   3369  CA  VAL B 166      12.764  35.820  -9.433  1.00 23.67           C  
ATOM   3370  C   VAL B 166      13.635  36.550  -8.428  1.00 23.09           C  
ATOM   3371  O   VAL B 166      14.788  36.874  -8.706  1.00 23.59           O  
ATOM   3372  CB  VAL B 166      13.431  34.470  -9.775  1.00 23.64           C  
ATOM   3373  CG1 VAL B 166      13.759  33.683  -8.468  1.00 22.92           C  
ATOM   3374  CG2 VAL B 166      12.537  33.657 -10.692  1.00 23.32           C  
ATOM   3375  N   LYS B 167      13.074  36.801  -7.257  1.00 22.24           N  
ATOM   3376  CA  LYS B 167      13.774  37.457  -6.190  1.00 22.62           C  
ATOM   3377  C   LYS B 167      14.530  36.459  -5.314  1.00 22.46           C  
ATOM   3378  O   LYS B 167      15.649  36.728  -4.892  1.00 22.54           O  
ATOM   3379  CB  LYS B 167      12.761  38.231  -5.356  1.00 22.85           C  
ATOM   3380  CG  LYS B 167      13.320  38.912  -4.132  1.00 24.45           C  
ATOM   3381  CD  LYS B 167      12.175  39.618  -3.436  1.00 25.08           C  
ATOM   3382  CE  LYS B 167      12.586  40.348  -2.156  1.00 28.18           C  
ATOM   3383  NZ  LYS B 167      11.415  41.110  -1.584  1.00 29.16           N  
ATOM   3384  N   ALA B 168      13.893  35.317  -5.049  1.00 21.62           N  
ATOM   3385  CA  ALA B 168      14.449  34.246  -4.227  1.00 21.12           C  
ATOM   3386  C   ALA B 168      13.845  32.913  -4.704  1.00 20.80           C  
ATOM   3387  O   ALA B 168      12.724  32.904  -5.220  1.00 21.18           O  
ATOM   3388  CB  ALA B 168      14.106  34.478  -2.768  1.00 21.43           C  
ATOM   3389  N   ALA B 169      14.599  31.817  -4.582  1.00 20.19           N  
ATOM   3390  CA  ALA B 169      14.167  30.509  -5.144  1.00 19.81           C  
ATOM   3391  C   ALA B 169      14.632  29.325  -4.319  1.00 19.07           C  
ATOM   3392  O   ALA B 169      15.670  29.375  -3.678  1.00 18.25           O  
ATOM   3393  CB  ALA B 169      14.657  30.350  -6.592  1.00 19.10           C  
ATOM   3394  N   LEU B 170      13.838  28.251  -4.354  1.00 18.46           N  
ATOM   3395  CA  LEU B 170      14.200  26.953  -3.810  1.00 18.56           C  
ATOM   3396  C   LEU B 170      13.615  25.913  -4.762  1.00 17.88           C  
ATOM   3397  O   LEU B 170      12.406  25.912  -4.969  1.00 18.02           O  
ATOM   3398  CB  LEU B 170      13.594  26.754  -2.417  1.00 18.29           C  
ATOM   3399  CG  LEU B 170      13.514  25.315  -1.896  1.00 19.21           C  
ATOM   3400  CD1 LEU B 170      14.930  24.761  -1.731  1.00 19.56           C  
ATOM   3401  CD2 LEU B 170      12.745  25.285  -0.583  1.00 19.77           C  
ATOM   3402  N   SER B 171      14.460  25.080  -5.372  1.00 17.65           N  
ATOM   3403  CA  SER B 171      13.992  23.985  -6.203  1.00 17.78           C  
ATOM   3404  C   SER B 171      14.200  22.673  -5.435  1.00 18.00           C  
ATOM   3405  O   SER B 171      15.330  22.301  -5.106  1.00 17.41           O  
ATOM   3406  CB  SER B 171      14.724  23.965  -7.560  1.00 18.32           C  
ATOM   3407  OG  SER B 171      14.207  22.960  -8.432  1.00 18.13           O  
HETATM 3408  N   MSE B 172      13.088  21.995  -5.136  1.00 18.41           N  
HETATM 3409  CA  MSE B 172      13.125  20.691  -4.490  1.00 17.42           C  
HETATM 3410  C   MSE B 172      13.053  19.607  -5.545  1.00 17.21           C  
HETATM 3411  O   MSE B 172      12.291  19.703  -6.505  1.00 16.46           O  
HETATM 3412  CB  MSE B 172      11.948  20.524  -3.539  1.00 18.46           C  
HETATM 3413  CG  MSE B 172      11.899  21.553  -2.430  1.00 20.51           C  
HETATM 3414 SE   MSE B 172      13.190  21.083  -1.092  0.80 26.30          SE  
HETATM 3415  CE  MSE B 172      12.399  19.433  -0.504  1.00 19.51           C  
ATOM   3416  N   THR B 173      13.856  18.571  -5.345  1.00 14.73           N  
ATOM   3417  CA  THR B 173      13.853  17.409  -6.186  1.00 15.29           C  
ATOM   3418  C   THR B 173      13.062  16.319  -5.476  1.00 14.62           C  
ATOM   3419  O   THR B 173      13.404  15.921  -4.368  1.00 14.88           O  
ATOM   3420  CB  THR B 173      15.283  16.934  -6.429  1.00 16.13           C  
ATOM   3421  OG1 THR B 173      15.978  17.916  -7.222  1.00 17.43           O  
ATOM   3422  CG2 THR B 173      15.309  15.569  -7.159  1.00 16.42           C  
ATOM   3423  N   ILE B 174      12.047  15.780  -6.134  1.00 14.47           N  
ATOM   3424  CA  ILE B 174      11.166  14.771  -5.517  1.00 13.94           C  
ATOM   3425  C   ILE B 174      11.203  13.485  -6.361  1.00 13.26           C  
ATOM   3426  O   ILE B 174      11.028  13.535  -7.590  1.00 13.61           O  
ATOM   3427  CB  ILE B 174       9.710  15.292  -5.545  1.00 14.25           C  
ATOM   3428  CG1 ILE B 174       9.585  16.686  -4.873  1.00 15.46           C  
ATOM   3429  CG2 ILE B 174       8.733  14.217  -5.094  1.00 13.29           C  
ATOM   3430  CD1 ILE B 174      10.078  16.798  -3.439  1.00 14.77           C  
ATOM   3431  N   PRO B 175      11.452  12.338  -5.745  1.00 13.61           N  
ATOM   3432  CA  PRO B 175      11.588  11.105  -6.517  1.00 12.76           C  
ATOM   3433  C   PRO B 175      10.251  10.487  -6.888  1.00 13.68           C  
ATOM   3434  O   PRO B 175       9.408  10.266  -6.009  1.00 14.10           O  
ATOM   3435  CB  PRO B 175      12.362  10.212  -5.557  1.00 13.40           C  
ATOM   3436  CG  PRO B 175      11.921  10.646  -4.239  1.00 13.38           C  
ATOM   3437  CD  PRO B 175      11.674  12.094  -4.309  1.00 13.14           C  
ATOM   3438  N   LEU B 176      10.033  10.255  -8.186  1.00 13.10           N  
ATOM   3439  CA  LEU B 176       8.882   9.495  -8.656  1.00 13.57           C  
ATOM   3440  C   LEU B 176       9.166   8.069  -9.132  1.00 14.08           C  
ATOM   3441  O   LEU B 176       8.306   7.447  -9.777  1.00 14.12           O  
ATOM   3442  CB  LEU B 176       8.162  10.280  -9.781  1.00 13.73           C  
ATOM   3443  CG  LEU B 176       7.759  11.722  -9.464  1.00 15.97           C  
ATOM   3444  CD1 LEU B 176       7.069  12.352 -10.680  1.00 17.10           C  
ATOM   3445  CD2 LEU B 176       6.892  11.830  -8.220  1.00 15.16           C  
ATOM   3446  N   GLY B 177      10.330   7.534  -8.769  1.00 15.11           N  
ATOM   3447  CA  GLY B 177      10.718   6.182  -9.168  1.00 14.27           C  
ATOM   3448  C   GLY B 177      11.328   6.119 -10.560  1.00 14.95           C  
ATOM   3449  O   GLY B 177      11.156   7.016 -11.391  1.00 13.10           O  
ATOM   3450  N   THR B 178      12.045   5.031 -10.788  1.00 15.22           N  
ATOM   3451  CA  THR B 178      12.711   4.742 -12.057  1.00 15.41           C  
ATOM   3452  C   THR B 178      13.494   5.920 -12.659  1.00 15.29           C  
ATOM   3453  O   THR B 178      13.518   6.093 -13.890  1.00 15.14           O  
ATOM   3454  CB  THR B 178      11.773   4.020 -13.088  1.00 15.63           C  
ATOM   3455  OG1 THR B 178      10.848   4.931 -13.694  1.00 16.53           O  
ATOM   3456  CG2 THR B 178      11.007   2.892 -12.373  1.00 16.45           C  
ATOM   3457  N   GLY B 179      14.123   6.716 -11.782  1.00 14.89           N  
ATOM   3458  CA  GLY B 179      15.014   7.797 -12.179  1.00 14.75           C  
ATOM   3459  C   GLY B 179      14.275   9.012 -12.708  1.00 14.82           C  
ATOM   3460  O   GLY B 179      14.887   9.916 -13.260  1.00 15.75           O  
ATOM   3461  N   VAL B 180      12.962   9.056 -12.471  1.00 15.11           N  
ATOM   3462  CA  VAL B 180      12.082  10.120 -12.920  1.00 14.96           C  
ATOM   3463  C   VAL B 180      11.842  11.009 -11.718  1.00 15.37           C  
ATOM   3464  O   VAL B 180      11.624  10.492 -10.610  1.00 15.04           O  
ATOM   3465  CB  VAL B 180      10.743   9.556 -13.494  1.00 15.15           C  
ATOM   3466  CG1 VAL B 180       9.725  10.690 -13.780  1.00 17.38           C  
ATOM   3467  CG2 VAL B 180      11.040   8.703 -14.766  1.00 14.74           C  
ATOM   3468  N   HIS B 181      11.893  12.326 -11.906  1.00 14.78           N  
ATOM   3469  CA  HIS B 181      11.761  13.265 -10.786  1.00 14.32           C  
ATOM   3470  C   HIS B 181      10.703  14.333 -11.046  1.00 15.62           C  
ATOM   3471  O   HIS B 181      10.481  14.742 -12.195  1.00 15.01           O  
ATOM   3472  CB  HIS B 181      13.121  13.923 -10.451  1.00 14.75           C  
ATOM   3473  CG  HIS B 181      14.141  12.949  -9.974  1.00 14.45           C  
ATOM   3474  ND1 HIS B 181      14.955  12.253 -10.844  1.00 14.04           N  
ATOM   3475  CD2 HIS B 181      14.441  12.505  -8.734  1.00 14.51           C  
ATOM   3476  CE1 HIS B 181      15.728  11.429 -10.147  1.00 16.77           C  
ATOM   3477  NE2 HIS B 181      15.431  11.557  -8.868  1.00 14.48           N  
ATOM   3478  N   ARG B 182      10.079  14.772  -9.969  1.00 15.71           N  
ATOM   3479  CA  ARG B 182       9.220  15.946  -9.965  1.00 15.54           C  
ATOM   3480  C   ARG B 182      10.015  17.087  -9.369  1.00 15.49           C  
ATOM   3481  O   ARG B 182      10.820  16.884  -8.459  1.00 14.38           O  
ATOM   3482  CB  ARG B 182       7.955  15.643  -9.170  1.00 15.85           C  
ATOM   3483  CG  ARG B 182       7.082  16.823  -8.887  1.00 15.80           C  
ATOM   3484  CD  ARG B 182       6.015  16.498  -7.823  1.00 16.47           C  
ATOM   3485  NE  ARG B 182       5.064  15.484  -8.295  1.00 15.03           N  
ATOM   3486  CZ  ARG B 182       4.555  14.509  -7.551  1.00 15.53           C  
ATOM   3487  NH1 ARG B 182       4.890  14.358  -6.262  1.00 13.68           N  
ATOM   3488  NH2 ARG B 182       3.726  13.643  -8.115  1.00 15.71           N  
ATOM   3489  N   ARG B 183       9.830  18.291  -9.898  1.00 15.06           N  
ATOM   3490  CA  ARG B 183      10.479  19.464  -9.333  1.00 16.21           C  
ATOM   3491  C   ARG B 183       9.434  20.390  -8.750  1.00 16.11           C  
ATOM   3492  O   ARG B 183       8.514  20.832  -9.459  1.00 17.18           O  
ATOM   3493  CB  ARG B 183      11.306  20.194 -10.395  1.00 17.65           C  
ATOM   3494  CG  ARG B 183      12.104  19.222 -11.249  1.00 19.41           C  
ATOM   3495  CD  ARG B 183      13.543  19.604 -11.398  1.00 25.23           C  
ATOM   3496  NE  ARG B 183      14.293  18.565 -12.099  1.00 25.15           N  
ATOM   3497  CZ  ARG B 183      15.191  17.750 -11.555  1.00 28.85           C  
ATOM   3498  NH1 ARG B 183      15.536  17.832 -10.278  1.00 31.68           N  
ATOM   3499  NH2 ARG B 183      15.785  16.847 -12.313  1.00 27.76           N  
HETATM 3500  N   MSE B 184       9.589  20.703  -7.471  1.00 15.93           N  
HETATM 3501  CA  MSE B 184       8.691  21.619  -6.753  1.00 15.97           C  
HETATM 3502  C   MSE B 184       9.482  22.872  -6.537  1.00 16.37           C  
HETATM 3503  O   MSE B 184      10.454  22.869  -5.781  1.00 17.48           O  
HETATM 3504  CB  MSE B 184       8.259  21.034  -5.390  1.00 16.38           C  
HETATM 3505  CG  MSE B 184       7.493  19.712  -5.446  1.00 18.53           C  
HETATM 3506 SE   MSE B 184       5.743  19.887  -6.303  0.80 24.51          SE  
HETATM 3507  CE  MSE B 184       4.776  20.931  -4.921  1.00 23.17           C  
ATOM   3508  N   VAL B 185       9.107  23.943  -7.223  1.00 16.02           N  
ATOM   3509  CA  VAL B 185       9.887  25.176  -7.216  1.00 17.08           C  
ATOM   3510  C   VAL B 185       9.141  26.246  -6.469  1.00 17.77           C  
ATOM   3511  O   VAL B 185       8.031  26.574  -6.834  1.00 19.79           O  
ATOM   3512  CB  VAL B 185      10.198  25.641  -8.646  1.00 16.25           C  
ATOM   3513  CG1 VAL B 185      10.972  27.002  -8.631  1.00 16.85           C  
ATOM   3514  CG2 VAL B 185      10.957  24.547  -9.446  1.00 18.05           C  
ATOM   3515  N   TYR B 186       9.763  26.811  -5.439  1.00 18.52           N  
ATOM   3516  CA  TYR B 186       9.180  27.863  -4.631  1.00 18.27           C  
ATOM   3517  C   TYR B 186       9.925  29.181  -4.880  1.00 19.48           C  
ATOM   3518  O   TYR B 186      11.166  29.241  -4.850  1.00 19.98           O  
ATOM   3519  CB  TYR B 186       9.248  27.476  -3.153  1.00 18.76           C  
ATOM   3520  CG  TYR B 186       8.543  26.180  -2.883  1.00 17.21           C  
ATOM   3521  CD1 TYR B 186       9.188  24.951  -3.065  1.00 17.15           C  
ATOM   3522  CD2 TYR B 186       7.225  26.164  -2.472  1.00 17.84           C  
ATOM   3523  CE1 TYR B 186       8.538  23.753  -2.836  1.00 17.57           C  
ATOM   3524  CE2 TYR B 186       6.556  24.965  -2.243  1.00 16.83           C  
ATOM   3525  CZ  TYR B 186       7.218  23.756  -2.444  1.00 17.31           C  
ATOM   3526  OH  TYR B 186       6.590  22.559  -2.230  1.00 17.34           O  
ATOM   3527  N   VAL B 187       9.166  30.227  -5.165  1.00 20.47           N  
ATOM   3528  CA  VAL B 187       9.755  31.503  -5.499  1.00 21.11           C  
ATOM   3529  C   VAL B 187       9.092  32.690  -4.831  1.00 22.42           C  
ATOM   3530  O   VAL B 187       7.866  32.731  -4.637  1.00 21.17           O  
ATOM   3531  CB  VAL B 187       9.751  31.772  -7.030  1.00 21.82           C  
ATOM   3532  CG1 VAL B 187      10.667  30.786  -7.730  1.00 21.89           C  
ATOM   3533  CG2 VAL B 187       8.334  31.737  -7.595  1.00 20.52           C  
ATOM   3534  N   GLU B 188       9.935  33.680  -4.521  1.00 24.08           N  
ATOM   3535  CA  GLU B 188       9.491  35.035  -4.253  1.00 24.77           C  
ATOM   3536  C   GLU B 188       9.700  35.812  -5.533  1.00 24.70           C  
ATOM   3537  O   GLU B 188      10.690  35.614  -6.218  1.00 24.42           O  
ATOM   3538  CB  GLU B 188      10.329  35.684  -3.156  1.00 25.30           C  
ATOM   3539  CG  GLU B 188      10.229  35.024  -1.830  1.00 24.27           C  
ATOM   3540  CD  GLU B 188      11.240  35.582  -0.836  1.00 25.24           C  
ATOM   3541  OE1 GLU B 188      11.435  36.821  -0.810  1.00 25.80           O  
ATOM   3542  OE2 GLU B 188      11.831  34.788  -0.072  1.00 22.60           O  
ATOM   3543  N   LEU B 189       8.777  36.703  -5.850  1.00 25.17           N  
ATOM   3544  CA  LEU B 189       8.845  37.427  -7.101  1.00 25.87           C  
ATOM   3545  C   LEU B 189       9.327  38.865  -6.900  1.00 27.16           C  
ATOM   3546  O   LEU B 189       9.108  39.466  -5.844  1.00 27.22           O  
ATOM   3547  CB  LEU B 189       7.469  37.434  -7.759  1.00 25.93           C  
ATOM   3548  CG  LEU B 189       6.906  36.088  -8.176  1.00 24.62           C  
ATOM   3549  CD1 LEU B 189       5.607  36.305  -8.915  1.00 22.54           C  
ATOM   3550  CD2 LEU B 189       7.931  35.300  -9.007  1.00 24.57           C  
ATOM   3551  N   LEU B 190       9.956  39.422  -7.929  1.00 28.35           N  
ATOM   3552  CA  LEU B 190      10.393  40.809  -7.871  1.00 29.53           C  
ATOM   3553  C   LEU B 190       9.184  41.713  -8.129  1.00 30.19           C  
ATOM   3554  O   LEU B 190       8.173  41.257  -8.678  1.00 30.05           O  
ATOM   3555  CB  LEU B 190      11.504  41.074  -8.900  1.00 29.49           C  
ATOM   3556  CG  LEU B 190      12.884  40.528  -8.524  1.00 29.30           C  
ATOM   3557  CD1 LEU B 190      13.841  40.542  -9.706  1.00 29.97           C  
ATOM   3558  CD2 LEU B 190      13.476  41.262  -7.336  1.00 28.74           C  
ATOM   3559  N   PRO B 191       9.274  42.999  -7.738  1.00 30.79           N  
ATOM   3560  CA  PRO B 191       8.184  43.926  -8.048  1.00 30.94           C  
ATOM   3561  C   PRO B 191       7.832  43.963  -9.520  1.00 31.02           C  
ATOM   3562  O   PRO B 191       8.732  44.013 -10.371  1.00 32.00           O  
ATOM   3563  CB  PRO B 191       8.747  45.282  -7.609  1.00 30.98           C  
ATOM   3564  CG  PRO B 191       9.748  44.939  -6.538  1.00 30.98           C  
ATOM   3565  CD  PRO B 191      10.362  43.664  -6.994  1.00 30.93           C  
ATOM   3566  N   GLY B 192       6.533  43.934  -9.823  1.00 31.12           N  
ATOM   3567  CA  GLY B 192       6.047  44.081 -11.198  1.00 31.01           C  
ATOM   3568  C   GLY B 192       5.916  42.789 -11.991  1.00 31.29           C  
ATOM   3569  O   GLY B 192       5.343  42.780 -13.080  1.00 31.36           O  
ATOM   3570  N   HIS B 193       6.431  41.690 -11.441  1.00 31.30           N  
ATOM   3571  CA  HIS B 193       6.389  40.403 -12.125  1.00 31.35           C  
ATOM   3572  C   HIS B 193       5.257  39.569 -11.538  1.00 31.47           C  
ATOM   3573  O   HIS B 193       5.015  39.622 -10.327  1.00 31.57           O  
ATOM   3574  CB  HIS B 193       7.728  39.683 -11.971  1.00 31.59           C  
ATOM   3575  CG  HIS B 193       8.877  40.384 -12.636  1.00 31.03           C  
ATOM   3576  ND1 HIS B 193       9.347  40.027 -13.880  1.00 31.20           N  
ATOM   3577  CD2 HIS B 193       9.666  41.400 -12.214  1.00 31.52           C  
ATOM   3578  CE1 HIS B 193      10.365  40.804 -14.203  1.00 32.63           C  
ATOM   3579  NE2 HIS B 193      10.579  41.647 -13.209  1.00 31.74           N  
ATOM   3580  N   ASN B 194       4.551  38.826 -12.390  1.00 31.56           N  
ATOM   3581  CA  ASN B 194       3.487  37.927 -11.930  1.00 32.01           C  
ATOM   3582  C   ASN B 194       3.863  36.459 -12.102  1.00 32.07           C  
ATOM   3583  O   ASN B 194       4.671  36.107 -12.957  1.00 31.91           O  
ATOM   3584  CB  ASN B 194       2.137  38.227 -12.602  1.00 32.35           C  
ATOM   3585  CG  ASN B 194       2.181  38.162 -14.126  1.00 34.04           C  
ATOM   3586  OD1 ASN B 194       2.911  37.367 -14.724  1.00 37.74           O  
ATOM   3587  ND2 ASN B 194       1.360  39.005 -14.767  1.00 35.37           N  
ATOM   3588  N   LEU B 195       3.251  35.612 -11.285  1.00 32.31           N  
ATOM   3589  CA  LEU B 195       3.605  34.200 -11.217  1.00 32.34           C  
ATOM   3590  C   LEU B 195       3.398  33.493 -12.563  1.00 32.26           C  
ATOM   3591  O   LEU B 195       4.229  32.678 -12.956  1.00 31.63           O  
ATOM   3592  CB  LEU B 195       2.779  33.516 -10.130  1.00 31.95           C  
ATOM   3593  CG  LEU B 195       3.061  32.044  -9.866  1.00 32.80           C  
ATOM   3594  CD1 LEU B 195       4.521  31.838  -9.446  1.00 31.45           C  
ATOM   3595  CD2 LEU B 195       2.098  31.511  -8.813  1.00 32.86           C  
ATOM   3596  N   GLU B 196       2.299  33.814 -13.257  1.00 32.44           N  
ATOM   3597  CA  GLU B 196       1.963  33.194 -14.539  1.00 33.13           C  
ATOM   3598  C   GLU B 196       3.164  33.168 -15.468  1.00 32.69           C  
ATOM   3599  O   GLU B 196       3.480  32.131 -16.075  1.00 32.51           O  
ATOM   3600  CB  GLU B 196       0.836  33.963 -15.248  1.00 33.45           C  
ATOM   3601  CG  GLU B 196      -0.503  34.045 -14.486  1.00 35.80           C  
ATOM   3602  CD  GLU B 196      -1.339  35.286 -14.844  1.00 35.84           C  
ATOM   3603  OE1 GLU B 196      -0.938  36.427 -14.480  1.00 39.69           O  
ATOM   3604  OE2 GLU B 196      -2.419  35.121 -15.465  1.00 41.65           O  
ATOM   3605  N   GLU B 197       3.821  34.320 -15.594  1.00 32.38           N  
ATOM   3606  CA  GLU B 197       4.906  34.481 -16.564  1.00 32.11           C  
ATOM   3607  C   GLU B 197       6.207  33.858 -16.075  1.00 31.13           C  
ATOM   3608  O   GLU B 197       6.906  33.195 -16.843  1.00 29.78           O  
ATOM   3609  CB  GLU B 197       5.105  35.944 -16.897  1.00 32.90           C  
ATOM   3610  CG  GLU B 197       4.027  36.459 -17.837  1.00 33.81           C  
ATOM   3611  CD  GLU B 197       3.821  37.949 -17.755  1.00 35.56           C  
ATOM   3612  OE1 GLU B 197       4.767  38.674 -17.374  1.00 42.40           O  
ATOM   3613  OE2 GLU B 197       2.710  38.403 -18.083  1.00 39.01           O  
ATOM   3614  N   VAL B 198       6.523  34.062 -14.802  1.00 29.79           N  
ATOM   3615  CA  VAL B 198       7.724  33.459 -14.192  1.00 29.52           C  
ATOM   3616  C   VAL B 198       7.642  31.923 -14.174  1.00 29.04           C  
ATOM   3617  O   VAL B 198       8.630  31.222 -14.453  1.00 28.11           O  
ATOM   3618  CB  VAL B 198       7.930  34.037 -12.776  1.00 29.55           C  
ATOM   3619  CG1 VAL B 198       9.054  33.346 -12.023  1.00 29.29           C  
ATOM   3620  CG2 VAL B 198       8.186  35.543 -12.872  1.00 29.70           C  
ATOM   3621  N   SER B 199       6.469  31.400 -13.849  1.00 28.47           N  
ATOM   3622  CA  SER B 199       6.240  29.963 -13.867  1.00 28.05           C  
ATOM   3623  C   SER B 199       6.486  29.423 -15.266  1.00 27.39           C  
ATOM   3624  O   SER B 199       7.183  28.439 -15.444  1.00 27.26           O  
ATOM   3625  CB  SER B 199       4.809  29.659 -13.422  1.00 28.20           C  
ATOM   3626  OG  SER B 199       4.450  28.313 -13.653  1.00 30.62           O  
ATOM   3627  N   ALA B 200       5.927  30.089 -16.273  1.00 26.05           N  
ATOM   3628  CA  ALA B 200       6.131  29.650 -17.647  1.00 25.67           C  
ATOM   3629  C   ALA B 200       7.617  29.626 -18.040  1.00 25.47           C  
ATOM   3630  O   ALA B 200       8.050  28.709 -18.740  1.00 25.22           O  
ATOM   3631  CB  ALA B 200       5.320  30.527 -18.625  1.00 25.82           C  
ATOM   3632  N   ALA B 201       8.380  30.636 -17.612  1.00 24.79           N  
ATOM   3633  CA  ALA B 201       9.809  30.731 -17.942  1.00 24.37           C  
ATOM   3634  C   ALA B 201      10.603  29.624 -17.274  1.00 24.30           C  
ATOM   3635  O   ALA B 201      11.472  29.031 -17.879  1.00 24.43           O  
ATOM   3636  CB  ALA B 201      10.365  32.071 -17.511  1.00 24.18           C  
ATOM   3637  N   ILE B 202      10.307  29.373 -16.012  1.00 24.50           N  
ATOM   3638  CA  ILE B 202      10.942  28.272 -15.283  1.00 24.15           C  
ATOM   3639  C   ILE B 202      10.706  26.926 -15.966  1.00 24.95           C  
ATOM   3640  O   ILE B 202      11.657  26.162 -16.207  1.00 24.45           O  
ATOM   3641  CB  ILE B 202      10.444  28.217 -13.816  1.00 24.69           C  
ATOM   3642  CG1 ILE B 202      10.944  29.447 -13.051  1.00 25.04           C  
ATOM   3643  CG2 ILE B 202      10.921  26.901 -13.101  1.00 24.27           C  
ATOM   3644  CD1 ILE B 202      10.269  29.722 -11.684  1.00 23.42           C  
ATOM   3645  N   LYS B 203       9.446  26.630 -16.270  1.00 24.36           N  
ATOM   3646  CA  LYS B 203       9.095  25.335 -16.847  1.00 24.61           C  
ATOM   3647  C   LYS B 203       9.688  25.110 -18.231  1.00 24.73           C  
ATOM   3648  O   LYS B 203       9.918  23.969 -18.615  1.00 25.23           O  
ATOM   3649  CB  LYS B 203       7.580  25.169 -16.914  1.00 24.88           C  
ATOM   3650  CG  LYS B 203       6.911  25.133 -15.573  1.00 25.37           C  
ATOM   3651  CD  LYS B 203       5.407  24.961 -15.678  1.00 26.03           C  
ATOM   3652  CE  LYS B 203       4.805  24.980 -14.288  1.00 27.90           C  
ATOM   3653  NZ  LYS B 203       3.408  24.487 -14.230  1.00 28.94           N  
ATOM   3654  N   ALA B 204       9.876  26.185 -18.996  1.00 24.37           N  
ATOM   3655  CA  ALA B 204      10.499  26.119 -20.320  1.00 24.73           C  
ATOM   3656  C   ALA B 204      12.032  26.067 -20.295  1.00 24.87           C  
ATOM   3657  O   ALA B 204      12.648  25.781 -21.306  1.00 24.72           O  
ATOM   3658  CB  ALA B 204      10.059  27.320 -21.145  1.00 24.31           C  
ATOM   3659  N   ASP B 205      12.649  26.363 -19.155  1.00 25.57           N  
ATOM   3660  CA  ASP B 205      14.117  26.370 -19.033  1.00 25.51           C  
ATOM   3661  C   ASP B 205      14.644  24.966 -19.246  1.00 25.45           C  
ATOM   3662  O   ASP B 205      13.995  23.990 -18.867  1.00 25.47           O  
ATOM   3663  CB  ASP B 205      14.532  26.887 -17.649  1.00 25.94           C  
ATOM   3664  CG  ASP B 205      16.027  27.153 -17.533  1.00 26.66           C  
ATOM   3665  OD1 ASP B 205      16.804  26.202 -17.294  1.00 28.28           O  
ATOM   3666  OD2 ASP B 205      16.425  28.330 -17.626  1.00 26.66           O  
ATOM   3667  N   GLU B 206      15.833  24.850 -19.830  1.00 25.90           N  
ATOM   3668  CA  GLU B 206      16.402  23.527 -20.129  1.00 26.54           C  
ATOM   3669  C   GLU B 206      16.580  22.667 -18.900  1.00 25.93           C  
ATOM   3670  O   GLU B 206      16.594  21.435 -19.010  1.00 25.48           O  
ATOM   3671  CB  GLU B 206      17.756  23.636 -20.841  1.00 27.82           C  
ATOM   3672  CG  GLU B 206      17.675  23.387 -22.335  1.00 32.04           C  
ATOM   3673  CD  GLU B 206      17.146  21.991 -22.708  1.00 36.87           C  
ATOM   3674  OE1 GLU B 206      17.386  20.997 -21.964  1.00 42.27           O  
ATOM   3675  OE2 GLU B 206      16.493  21.890 -23.775  1.00 41.47           O  
ATOM   3676  N   TYR B 207      16.742  23.303 -17.743  1.00 25.16           N  
ATOM   3677  CA  TYR B 207      16.862  22.566 -16.486  1.00 25.05           C  
ATOM   3678  C   TYR B 207      15.558  21.878 -16.066  1.00 24.24           C  
ATOM   3679  O   TYR B 207      15.599  20.931 -15.268  1.00 24.62           O  
ATOM   3680  CB  TYR B 207      17.325  23.482 -15.347  1.00 26.63           C  
ATOM   3681  CG  TYR B 207      18.822  23.565 -15.153  1.00 27.84           C  
ATOM   3682  CD1 TYR B 207      19.604  24.451 -15.898  1.00 29.84           C  
ATOM   3683  CD2 TYR B 207      19.450  22.788 -14.192  1.00 27.92           C  
ATOM   3684  CE1 TYR B 207      20.993  24.526 -15.699  1.00 29.52           C  
ATOM   3685  CE2 TYR B 207      20.817  22.854 -13.984  1.00 28.51           C  
ATOM   3686  CZ  TYR B 207      21.587  23.716 -14.734  1.00 29.40           C  
ATOM   3687  OH  TYR B 207      22.946  23.747 -14.496  1.00 28.90           O  
ATOM   3688  N   PHE B 208      14.417  22.363 -16.576  1.00 23.15           N  
ATOM   3689  CA  PHE B 208      13.076  21.901 -16.135  1.00 21.70           C  
ATOM   3690  C   PHE B 208      12.160  21.289 -17.200  1.00 21.64           C  
ATOM   3691  O   PHE B 208      11.208  20.570 -16.884  1.00 20.93           O  
ATOM   3692  CB  PHE B 208      12.345  23.075 -15.480  1.00 22.18           C  
ATOM   3693  CG  PHE B 208      12.970  23.518 -14.191  1.00 20.73           C  
ATOM   3694  CD1 PHE B 208      13.948  24.513 -14.177  1.00 21.77           C  
ATOM   3695  CD2 PHE B 208      12.636  22.897 -13.004  1.00 22.77           C  
ATOM   3696  CE1 PHE B 208      14.561  24.880 -12.980  1.00 21.34           C  
ATOM   3697  CE2 PHE B 208      13.238  23.265 -11.810  1.00 21.28           C  
ATOM   3698  CZ  PHE B 208      14.196  24.250 -11.796  1.00 21.32           C  
ATOM   3699  N   VAL B 209      12.435  21.578 -18.467  1.00 21.39           N  
ATOM   3700  CA  VAL B 209      11.529  21.228 -19.549  1.00 21.34           C  
ATOM   3701  C   VAL B 209      11.245  19.742 -19.714  1.00 21.11           C  
ATOM   3702  O   VAL B 209      10.180  19.378 -20.179  1.00 21.10           O  
ATOM   3703  CB  VAL B 209      12.037  21.815 -20.886  1.00 20.64           C  
ATOM   3704  CG1 VAL B 209      13.250  21.037 -21.410  1.00 20.21           C  
ATOM   3705  CG2 VAL B 209      10.919  21.844 -21.897  1.00 22.79           C  
ATOM   3706  N   HIS B 210      12.163  18.888 -19.290  1.00 21.42           N  
ATOM   3707  CA  HIS B 210      11.979  17.449 -19.397  1.00 21.87           C  
ATOM   3708  C   HIS B 210      11.255  16.825 -18.191  1.00 21.81           C  
ATOM   3709  O   HIS B 210      10.897  15.648 -18.246  1.00 20.87           O  
ATOM   3710  CB  HIS B 210      13.342  16.769 -19.578  1.00 22.98           C  
ATOM   3711  CG  HIS B 210      14.171  17.387 -20.663  1.00 25.36           C  
ATOM   3712  ND1 HIS B 210      13.823  17.310 -21.993  1.00 28.66           N  
ATOM   3713  CD2 HIS B 210      15.319  18.104 -20.613  1.00 27.61           C  
ATOM   3714  CE1 HIS B 210      14.720  17.957 -22.719  1.00 27.21           C  
ATOM   3715  NE2 HIS B 210      15.637  18.450 -21.904  1.00 28.95           N  
ATOM   3716  N   ASP B 211      11.057  17.610 -17.123  1.00 21.17           N  
ATOM   3717  CA  ASP B 211      10.507  17.121 -15.883  1.00 21.31           C  
ATOM   3718  C   ASP B 211       9.183  17.777 -15.516  1.00 20.42           C  
ATOM   3719  O   ASP B 211       8.972  18.970 -15.776  1.00 19.07           O  
ATOM   3720  CB  ASP B 211      11.487  17.404 -14.754  1.00 21.45           C  
ATOM   3721  CG  ASP B 211      12.861  16.826 -14.997  1.00 24.37           C  
ATOM   3722  OD1 ASP B 211      12.985  15.705 -15.529  1.00 24.29           O  
ATOM   3723  OD2 ASP B 211      13.844  17.511 -14.626  1.00 29.78           O  
ATOM   3724  N   GLU B 212       8.302  16.991 -14.891  1.00 18.50           N  
ATOM   3725  CA  GLU B 212       7.130  17.524 -14.229  1.00 18.62           C  
ATOM   3726  C   GLU B 212       7.556  18.580 -13.213  1.00 18.79           C  
ATOM   3727  O   GLU B 212       8.263  18.265 -12.253  1.00 17.75           O  
ATOM   3728  CB  GLU B 212       6.380  16.412 -13.454  1.00 17.51           C  
ATOM   3729  CG  GLU B 212       5.125  16.905 -12.758  1.00 18.71           C  
ATOM   3730  CD  GLU B 212       4.549  15.872 -11.819  1.00 19.39           C  
ATOM   3731  OE1 GLU B 212       4.780  14.676 -12.084  1.00 20.74           O  
ATOM   3732  OE2 GLU B 212       3.889  16.257 -10.824  1.00 17.32           O  
ATOM   3733  N   THR B 213       7.093  19.810 -13.404  1.00 18.44           N  
ATOM   3734  CA  THR B 213       7.536  20.939 -12.598  1.00 18.87           C  
ATOM   3735  C   THR B 213       6.332  21.744 -12.133  1.00 19.46           C  
ATOM   3736  O   THR B 213       5.463  22.078 -12.936  1.00 20.16           O  
ATOM   3737  CB  THR B 213       8.453  21.855 -13.438  1.00 19.27           C  
ATOM   3738  OG1 THR B 213       9.614  21.110 -13.831  1.00 20.10           O  
ATOM   3739  CG2 THR B 213       8.865  23.141 -12.660  1.00 18.75           C  
ATOM   3740  N   HIS B 214       6.317  22.080 -10.848  1.00 18.75           N  
ATOM   3741  CA  HIS B 214       5.305  22.927 -10.273  1.00 19.41           C  
ATOM   3742  C   HIS B 214       5.979  24.147  -9.669  1.00 19.90           C  
ATOM   3743  O   HIS B 214       7.013  24.026  -9.007  1.00 20.94           O  
ATOM   3744  CB  HIS B 214       4.529  22.202  -9.181  1.00 19.00           C  
ATOM   3745  CG  HIS B 214       3.926  20.899  -9.625  1.00 20.49           C  
ATOM   3746  ND1 HIS B 214       2.592  20.764  -9.939  1.00 21.72           N  
ATOM   3747  CD2 HIS B 214       4.475  19.675  -9.800  1.00 19.76           C  
ATOM   3748  CE1 HIS B 214       2.350  19.519 -10.306  1.00 19.44           C  
ATOM   3749  NE2 HIS B 214       3.480  18.838 -10.239  1.00 19.66           N  
ATOM   3750  N   VAL B 215       5.387  25.315  -9.907  1.00 19.65           N  
ATOM   3751  CA  VAL B 215       5.912  26.579  -9.407  1.00 20.04           C  
ATOM   3752  C   VAL B 215       4.886  27.242  -8.468  1.00 20.59           C  
ATOM   3753  O   VAL B 215       3.737  27.493  -8.861  1.00 19.59           O  
ATOM   3754  CB  VAL B 215       6.300  27.533 -10.590  1.00 20.81           C  
ATOM   3755  CG1 VAL B 215       6.957  28.782 -10.059  1.00 22.07           C  
ATOM   3756  CG2 VAL B 215       7.240  26.821 -11.566  1.00 19.72           C  
ATOM   3757  N   ILE B 216       5.333  27.523  -7.244  1.00 20.33           N  
ATOM   3758  CA  ILE B 216       4.520  28.005  -6.145  1.00 20.83           C  
ATOM   3759  C   ILE B 216       5.141  29.294  -5.614  1.00 20.49           C  
ATOM   3760  O   ILE B 216       6.326  29.314  -5.283  1.00 20.93           O  
ATOM   3761  CB  ILE B 216       4.491  26.973  -4.988  1.00 20.49           C  
ATOM   3762  CG1 ILE B 216       3.904  25.638  -5.448  1.00 24.43           C  
ATOM   3763  CG2 ILE B 216       3.719  27.534  -3.796  1.00 21.60           C  
ATOM   3764  CD1 ILE B 216       4.926  24.614  -5.704  1.00 25.69           C  
ATOM   3765  N   GLN B 217       4.342  30.359  -5.558  1.00 21.65           N  
ATOM   3766  CA  GLN B 217       4.775  31.655  -5.014  1.00 21.96           C  
ATOM   3767  C   GLN B 217       4.651  31.634  -3.494  1.00 22.91           C  
ATOM   3768  O   GLN B 217       3.630  31.206  -2.962  1.00 23.94           O  
ATOM   3769  CB  GLN B 217       3.943  32.791  -5.617  1.00 22.16           C  
ATOM   3770  CG  GLN B 217       4.402  34.173  -5.179  1.00 21.47           C  
ATOM   3771  CD  GLN B 217       3.660  35.288  -5.858  1.00 22.77           C  
ATOM   3772  OE1 GLN B 217       2.812  35.049  -6.717  1.00 24.79           O  
ATOM   3773  NE2 GLN B 217       3.979  36.517  -5.486  1.00 24.45           N  
ATOM   3774  N   VAL B 218       5.713  32.049  -2.805  1.00 22.53           N  
ATOM   3775  CA  VAL B 218       5.744  32.114  -1.353  1.00 23.04           C  
ATOM   3776  C   VAL B 218       6.199  33.488  -0.867  1.00 23.34           C  
ATOM   3777  O   VAL B 218       6.763  34.260  -1.637  1.00 22.92           O  
ATOM   3778  CB  VAL B 218       6.664  30.997  -0.765  1.00 22.45           C  
ATOM   3779  CG1 VAL B 218       6.237  29.632  -1.279  1.00 21.96           C  
ATOM   3780  CG2 VAL B 218       8.148  31.215  -1.146  1.00 21.84           C  
ATOM   3781  N   ASP B 219       5.947  33.766   0.416  1.00 24.67           N  
ATOM   3782  CA  ASP B 219       6.357  35.014   1.065  1.00 25.44           C  
ATOM   3783  C   ASP B 219       7.839  34.999   1.374  1.00 25.07           C  
ATOM   3784  O   ASP B 219       8.501  36.028   1.285  1.00 24.34           O  
ATOM   3785  CB  ASP B 219       5.646  35.208   2.402  1.00 26.84           C  
ATOM   3786  CG  ASP B 219       4.148  35.402   2.274  1.00 30.85           C  
ATOM   3787  OD1 ASP B 219       3.672  35.921   1.244  1.00 36.09           O  
ATOM   3788  OD2 ASP B 219       3.434  35.046   3.243  1.00 38.59           O  
ATOM   3789  N   GLU B 220       8.344  33.837   1.787  1.00 24.49           N  
ATOM   3790  CA  GLU B 220       9.693  33.729   2.335  1.00 24.38           C  
ATOM   3791  C   GLU B 220      10.347  32.378   2.027  1.00 23.18           C  
ATOM   3792  O   GLU B 220      10.118  31.383   2.732  1.00 23.02           O  
ATOM   3793  CB  GLU B 220       9.662  33.929   3.848  1.00 24.89           C  
ATOM   3794  CG  GLU B 220      11.054  34.161   4.431  1.00 26.22           C  
ATOM   3795  CD  GLU B 220      11.055  34.309   5.938  1.00 29.39           C  
ATOM   3796  OE1 GLU B 220       9.961  34.427   6.544  1.00 37.32           O  
ATOM   3797  OE2 GLU B 220      12.167  34.290   6.523  1.00 37.37           O  
ATOM   3798  N   VAL B 221      11.210  32.361   1.017  1.00 21.54           N  
ATOM   3799  CA  VAL B 221      11.918  31.134   0.642  1.00 21.32           C  
ATOM   3800  C   VAL B 221      12.792  30.599   1.778  1.00 20.84           C  
ATOM   3801  O   VAL B 221      12.883  29.386   1.970  1.00 19.21           O  
ATOM   3802  CB  VAL B 221      12.744  31.361  -0.632  1.00 21.62           C  
ATOM   3803  CG1 VAL B 221      13.844  30.313  -0.787  1.00 21.22           C  
ATOM   3804  CG2 VAL B 221      11.824  31.358  -1.826  1.00 20.41           C  
ATOM   3805  N   ASP B 222      13.422  31.488   2.551  1.00 20.34           N  
ATOM   3806  CA  ASP B 222      14.338  31.002   3.599  1.00 20.64           C  
ATOM   3807  C   ASP B 222      13.654  30.172   4.657  1.00 20.02           C  
ATOM   3808  O   ASP B 222      14.313  29.350   5.304  1.00 20.40           O  
ATOM   3809  CB  ASP B 222      15.083  32.147   4.267  1.00 21.88           C  
ATOM   3810  CG  ASP B 222      16.173  32.750   3.375  1.00 27.07           C  
ATOM   3811  OD1 ASP B 222      16.559  32.133   2.345  1.00 31.71           O  
ATOM   3812  OD2 ASP B 222      16.653  33.853   3.717  1.00 32.25           O  
ATOM   3813  N   ALA B 223      12.352  30.367   4.858  1.00 18.47           N  
ATOM   3814  CA  ALA B 223      11.617  29.606   5.871  1.00 18.65           C  
ATOM   3815  C   ALA B 223      11.357  28.162   5.417  1.00 17.75           C  
ATOM   3816  O   ALA B 223      10.860  27.330   6.191  1.00 19.02           O  
ATOM   3817  CB  ALA B 223      10.323  30.302   6.202  1.00 18.13           C  
ATOM   3818  N   LEU B 224      11.692  27.859   4.158  1.00 17.74           N  
ATOM   3819  CA  LEU B 224      11.421  26.540   3.595  1.00 17.15           C  
ATOM   3820  C   LEU B 224      12.669  25.674   3.484  1.00 17.37           C  
ATOM   3821  O   LEU B 224      12.555  24.481   3.204  1.00 17.45           O  
ATOM   3822  CB  LEU B 224      10.783  26.665   2.207  1.00 16.87           C  
ATOM   3823  CG  LEU B 224       9.581  27.590   2.118  1.00 17.32           C  
ATOM   3824  CD1 LEU B 224       9.059  27.692   0.651  1.00 16.31           C  
ATOM   3825  CD2 LEU B 224       8.490  27.186   3.039  1.00 14.10           C  
ATOM   3826  N   ILE B 225      13.851  26.257   3.695  1.00 17.25           N  
ATOM   3827  CA  ILE B 225      15.100  25.583   3.349  1.00 17.48           C  
ATOM   3828  C   ILE B 225      15.541  24.617   4.446  1.00 16.43           C  
ATOM   3829  O   ILE B 225      15.501  24.950   5.608  1.00 17.18           O  
ATOM   3830  CB  ILE B 225      16.205  26.611   3.074  1.00 17.35           C  
ATOM   3831  CG1 ILE B 225      15.837  27.423   1.819  1.00 19.81           C  
ATOM   3832  CG2 ILE B 225      17.551  25.921   2.868  1.00 18.37           C  
ATOM   3833  CD1 ILE B 225      16.729  28.574   1.570  1.00 20.22           C  
ATOM   3834  N   ASP B 226      15.947  23.410   4.050  1.00 15.81           N  
ATOM   3835  CA  ASP B 226      16.435  22.381   4.959  1.00 15.96           C  
ATOM   3836  C   ASP B 226      17.472  21.549   4.175  1.00 15.18           C  
ATOM   3837  O   ASP B 226      17.306  21.333   2.955  1.00 16.37           O  
ATOM   3838  CB  ASP B 226      15.317  21.466   5.427  1.00 15.56           C  
ATOM   3839  CG  ASP B 226      15.845  20.262   6.184  1.00 16.69           C  
ATOM   3840  OD1 ASP B 226      16.415  20.457   7.261  1.00 18.97           O  
ATOM   3841  OD2 ASP B 226      15.762  19.136   5.675  1.00 17.42           O  
HETATM 3842  N   MSE B 227      18.508  21.088   4.861  1.00 15.19           N  
HETATM 3843  CA  MSE B 227      19.605  20.338   4.200  1.00 15.44           C  
HETATM 3844  C   MSE B 227      19.391  18.820   4.112  1.00 14.95           C  
HETATM 3845  O   MSE B 227      20.224  18.101   3.528  1.00 15.65           O  
HETATM 3846  CB  MSE B 227      20.929  20.586   4.913  1.00 15.63           C  
HETATM 3847  CG  MSE B 227      21.545  21.948   4.703  1.00 17.34           C  
HETATM 3848 SE   MSE B 227      21.881  22.403   2.830  0.70 21.28          SE  
HETATM 3849  CE  MSE B 227      20.304  23.458   2.558  1.00 19.79           C  
ATOM   3850  N   GLY B 228      18.267  18.342   4.619  1.00 14.84           N  
ATOM   3851  CA  GLY B 228      17.870  16.924   4.508  1.00 13.95           C  
ATOM   3852  C   GLY B 228      17.703  16.538   3.062  1.00 14.22           C  
ATOM   3853  O   GLY B 228      17.206  17.319   2.265  1.00 13.81           O  
ATOM   3854  N   HIS B 229      18.178  15.353   2.715  1.00 14.14           N  
ATOM   3855  CA  HIS B 229      18.120  14.870   1.330  1.00 14.17           C  
ATOM   3856  C   HIS B 229      18.204  13.376   1.386  1.00 14.48           C  
ATOM   3857  O   HIS B 229      18.347  12.737   2.472  1.00 15.13           O  
ATOM   3858  CB  HIS B 229      19.294  15.441   0.515  1.00 13.51           C  
ATOM   3859  CG  HIS B 229      18.988  15.736  -0.926  1.00 13.70           C  
ATOM   3860  ND1 HIS B 229      18.269  14.882  -1.743  1.00 14.97           N  
ATOM   3861  CD2 HIS B 229      19.348  16.784  -1.706  1.00 14.61           C  
ATOM   3862  CE1 HIS B 229      18.179  15.401  -2.953  1.00 16.03           C  
ATOM   3863  NE2 HIS B 229      18.832  16.553  -2.963  1.00 16.05           N  
ATOM   3864  N   GLY B 230      18.171  12.761   0.222  1.00 15.40           N  
ATOM   3865  CA  GLY B 230      18.388  11.322   0.239  1.00 15.62           C  
ATOM   3866  C   GLY B 230      18.422  10.714  -1.121  1.00 14.07           C  
ATOM   3867  O   GLY B 230      18.326  11.408  -2.160  1.00 14.05           O  
ATOM   3868  N   VAL B 231      18.520   9.398  -1.103  1.00 13.88           N  
ATOM   3869  CA  VAL B 231      18.569   8.612  -2.314  1.00 13.36           C  
ATOM   3870  C   VAL B 231      17.857   7.290  -2.081  1.00 14.55           C  
ATOM   3871  O   VAL B 231      17.776   6.775  -0.957  1.00 13.36           O  
ATOM   3872  CB  VAL B 231      20.044   8.374  -2.781  1.00 13.81           C  
ATOM   3873  CG1 VAL B 231      20.762   7.360  -1.895  1.00 14.39           C  
ATOM   3874  CG2 VAL B 231      20.109   8.009  -4.275  1.00 13.40           C  
ATOM   3875  N   ARG B 232      17.376   6.730  -3.182  1.00 15.51           N  
ATOM   3876  CA  ARG B 232      16.961   5.345  -3.216  1.00 15.61           C  
ATOM   3877  C   ARG B 232      17.447   4.776  -4.531  1.00 14.99           C  
ATOM   3878  O   ARG B 232      17.031   5.227  -5.579  1.00 12.84           O  
ATOM   3879  CB  ARG B 232      15.460   5.172  -3.090  1.00 16.15           C  
ATOM   3880  CG  ARG B 232      15.011   3.699  -3.256  1.00 16.47           C  
ATOM   3881  CD  ARG B 232      13.573   3.489  -2.860  1.00 19.99           C  
ATOM   3882  NE  ARG B 232      13.202   2.116  -3.141  1.00 24.17           N  
ATOM   3883  CZ  ARG B 232      13.458   1.071  -2.356  1.00 25.25           C  
ATOM   3884  NH1 ARG B 232      14.088   1.208  -1.198  1.00 27.40           N  
ATOM   3885  NH2 ARG B 232      13.058  -0.127  -2.738  1.00 26.74           N  
HETATM 3886  N   MSE B 233      18.392   3.847  -4.452  1.00 14.21           N  
HETATM 3887  CA  MSE B 233      18.919   3.194  -5.627  0.50 15.03           C  
HETATM 3889  C   MSE B 233      18.397   1.770  -5.674  1.00 14.73           C  
HETATM 3890  O   MSE B 233      18.445   1.061  -4.669  1.00 13.92           O  
HETATM 3891  CB  MSE B 233      20.432   3.205  -5.560  0.50 15.07           C  
HETATM 3893  CG  MSE B 233      21.107   2.318  -6.522  0.50 15.07           C  
HETATM 3895 SE   MSE B 233      22.982   2.420  -6.106  0.50 19.07          SE  
HETATM 3897  CE  MSE B 233      23.171   4.334  -6.511  0.50 19.79           C  
ATOM   3899  N   VAL B 234      17.892   1.361  -6.827  1.00 14.64           N  
ATOM   3900  CA  VAL B 234      17.289   0.051  -6.984  1.00 14.71           C  
ATOM   3901  C   VAL B 234      17.861  -0.629  -8.221  1.00 14.63           C  
ATOM   3902  O   VAL B 234      17.976  -0.012  -9.284  1.00 13.83           O  
ATOM   3903  CB  VAL B 234      15.735   0.188  -7.133  1.00 15.67           C  
ATOM   3904  CG1 VAL B 234      15.105  -1.138  -7.567  1.00 18.25           C  
ATOM   3905  CG2 VAL B 234      15.099   0.740  -5.849  1.00 16.16           C  
ATOM   3906  N   ARG B 235      18.199  -1.901  -8.095  1.00 14.64           N  
ATOM   3907  CA  ARG B 235      18.529  -2.726  -9.256  1.00 14.93           C  
ATOM   3908  C   ARG B 235      17.766  -4.043  -9.183  1.00 15.73           C  
ATOM   3909  O   ARG B 235      17.735  -4.706  -8.130  1.00 17.10           O  
ATOM   3910  CB  ARG B 235      20.031  -2.988  -9.345  1.00 15.22           C  
ATOM   3911  CG  ARG B 235      20.461  -3.750 -10.570  1.00 14.68           C  
ATOM   3912  CD  ARG B 235      21.943  -3.737 -10.762  1.00 14.26           C  
ATOM   3913  NE  ARG B 235      22.374  -4.410 -11.979  1.00 13.29           N  
ATOM   3914  CZ  ARG B 235      22.402  -3.868 -13.179  1.00 13.55           C  
ATOM   3915  NH1 ARG B 235      21.946  -2.629 -13.385  1.00 14.04           N  
ATOM   3916  NH2 ARG B 235      22.847  -4.593 -14.210  1.00 15.76           N  
ATOM   3917  N   LYS B 236      17.167  -4.400 -10.317  1.00 14.47           N  
ATOM   3918  CA  LYS B 236      16.541  -5.689 -10.525  1.00 15.25           C  
ATOM   3919  C   LYS B 236      17.179  -6.324 -11.757  1.00 13.78           C  
ATOM   3920  O   LYS B 236      17.270  -5.708 -12.830  1.00 13.14           O  
ATOM   3921  CB  LYS B 236      15.026  -5.570 -10.706  1.00 14.83           C  
ATOM   3922  CG  LYS B 236      14.331  -6.913 -10.970  1.00 15.77           C  
ATOM   3923  CD  LYS B 236      12.801  -6.808 -11.181  1.00 16.23           C  
ATOM   3924  CE  LYS B 236      12.430  -6.218 -12.560  1.00 13.83           C  
ATOM   3925  NZ  LYS B 236      12.914  -7.053 -13.709  1.00 17.50           N  
ATOM   3926  N   GLY B 237      17.642  -7.554 -11.599  1.00 12.53           N  
ATOM   3927  CA  GLY B 237      18.218  -8.234 -12.736  1.00 13.37           C  
ATOM   3928  C   GLY B 237      18.696  -9.626 -12.497  1.00 13.32           C  
ATOM   3929  O   GLY B 237      18.137 -10.366 -11.636  1.00 14.47           O  
ATOM   3930  N   VAL B 238      19.720  -9.989 -13.265  1.00 12.38           N  
ATOM   3931  CA  VAL B 238      20.152 -11.377 -13.398  1.00 13.12           C  
ATOM   3932  C   VAL B 238      21.521 -11.538 -12.769  1.00 13.16           C  
ATOM   3933  O   VAL B 238      22.389 -10.776 -13.082  1.00 13.61           O  
ATOM   3934  CB  VAL B 238      20.277 -11.778 -14.866  1.00 13.81           C  
ATOM   3935  CG1 VAL B 238      20.626 -13.219 -15.006  1.00 11.81           C  
ATOM   3936  CG2 VAL B 238      18.996 -11.431 -15.620  1.00 12.59           C  
ATOM   3937  N   SER B 239      21.686 -12.484 -11.839  1.00 13.03           N  
ATOM   3938  CA  SER B 239      23.010 -12.932 -11.383  1.00 13.35           C  
ATOM   3939  C   SER B 239      23.282 -14.258 -12.100  1.00 13.68           C  
ATOM   3940  O   SER B 239      22.497 -15.211 -11.960  1.00 15.09           O  
ATOM   3941  CB  SER B 239      23.075 -13.189  -9.868  1.00 13.51           C  
ATOM   3942  OG  SER B 239      22.915 -12.013  -9.110  1.00 14.25           O  
ATOM   3943  N   GLY B 240      24.378 -14.335 -12.850  1.00 13.91           N  
ATOM   3944  CA  GLY B 240      24.628 -15.509 -13.702  1.00 13.77           C  
ATOM   3945  C   GLY B 240      23.546 -15.664 -14.758  1.00 13.31           C  
ATOM   3946  O   GLY B 240      23.440 -14.839 -15.665  1.00 14.01           O  
ATOM   3947  N   SER B 241      22.726 -16.703 -14.645  1.00 14.15           N  
ATOM   3948  CA  SER B 241      21.535 -16.848 -15.473  1.00 14.42           C  
ATOM   3949  C   SER B 241      20.249 -16.828 -14.666  1.00 14.52           C  
ATOM   3950  O   SER B 241      19.171 -17.042 -15.219  1.00 14.26           O  
ATOM   3951  CB  SER B 241      21.617 -18.116 -16.340  1.00 15.93           C  
ATOM   3952  OG  SER B 241      21.692 -19.258 -15.530  1.00 18.41           O  
ATOM   3953  N   THR B 242      20.366 -16.559 -13.371  1.00 13.93           N  
ATOM   3954  CA  THR B 242      19.234 -16.510 -12.452  1.00 14.19           C  
ATOM   3955  C   THR B 242      18.559 -15.146 -12.439  1.00 14.08           C  
ATOM   3956  O   THR B 242      19.139 -14.130 -12.036  1.00 13.09           O  
ATOM   3957  CB  THR B 242      19.679 -16.898 -11.039  1.00 15.17           C  
ATOM   3958  OG1 THR B 242      20.371 -18.151 -11.103  1.00 13.40           O  
ATOM   3959  CG2 THR B 242      18.487 -16.987 -10.042  1.00 13.56           C  
ATOM   3960  N   GLN B 243      17.301 -15.139 -12.881  1.00 14.11           N  
ATOM   3961  CA  GLN B 243      16.511 -13.924 -12.978  1.00 13.76           C  
ATOM   3962  C   GLN B 243      15.961 -13.459 -11.626  1.00 13.92           C  
ATOM   3963  O   GLN B 243      15.942 -14.209 -10.640  1.00 13.32           O  
ATOM   3964  CB  GLN B 243      15.320 -14.174 -13.899  1.00 14.29           C  
ATOM   3965  CG  GLN B 243      15.644 -15.002 -15.161  1.00 14.14           C  
ATOM   3966  CD  GLN B 243      16.469 -14.221 -16.131  1.00 15.76           C  
ATOM   3967  OE1 GLN B 243      16.023 -13.196 -16.638  1.00 14.46           O  
ATOM   3968  NE2 GLN B 243      17.661 -14.725 -16.452  1.00 15.29           N  
ATOM   3969  N   ASN B 244      15.440 -12.244 -11.612  1.00 14.05           N  
ATOM   3970  CA  ASN B 244      14.645 -11.727 -10.512  1.00 14.45           C  
ATOM   3971  C   ASN B 244      15.409 -11.513  -9.213  1.00 15.11           C  
ATOM   3972  O   ASN B 244      14.895 -11.786  -8.168  1.00 15.84           O  
ATOM   3973  CB  ASN B 244      13.416 -12.595 -10.293  1.00 14.65           C  
ATOM   3974  CG  ASN B 244      12.413 -11.981  -9.359  1.00 14.58           C  
ATOM   3975  OD1 ASN B 244      12.197 -10.820  -9.356  1.00 15.46           O  
ATOM   3976  ND2 ASN B 244      11.837 -12.790  -8.567  1.00 15.66           N  
ATOM   3977  N   GLN B 245      16.639 -11.021  -9.335  1.00 20.00           N  
ATOM   3978  CA  GLN B 245      17.447 -10.640  -8.198  1.00 20.00           C  
ATOM   3979  C   GLN B 245      17.151  -9.187  -7.914  1.00 20.00           C  
ATOM   3980  O   GLN B 245      17.205  -8.397  -8.793  1.00 15.08           O  
ATOM   3981  CB  GLN B 245      18.935 -10.760  -8.496  1.00 20.00           C  
ATOM   3982  CG  GLN B 245      19.409 -12.067  -8.946  1.00 20.00           C  
ATOM   3983  CD  GLN B 245      19.545 -13.034  -7.803  1.00 20.00           C  
ATOM   3984  OE1 GLN B 245      18.597 -13.511  -7.276  1.00 20.00           O  
ATOM   3985  NE2 GLN B 245      20.738 -13.285  -7.424  1.00 20.00           N  
ATOM   3986  N   ARG B 246      16.877  -8.849  -6.663  1.00 15.11           N  
ATOM   3987  CA  ARG B 246      16.494  -7.496  -6.321  1.00 15.63           C  
ATOM   3988  C   ARG B 246      17.346  -6.900  -5.198  1.00 15.19           C  
ATOM   3989  O   ARG B 246      17.586  -7.530  -4.264  1.00 14.86           O  
ATOM   3990  CB  ARG B 246      15.000  -7.414  -5.985  1.00 15.97           C  
ATOM   3991  CG  ARG B 246      14.091  -7.722  -7.146  1.00 16.52           C  
ATOM   3992  CD  ARG B 246      12.639  -7.796  -6.751  1.00 18.26           C  
ATOM   3993  NE  ARG B 246      11.870  -8.548  -7.713  1.00 21.28           N  
ATOM   3994  CZ  ARG B 246      10.857  -8.050  -8.408  1.00 21.38           C  
ATOM   3995  NH1 ARG B 246      10.505  -6.788  -8.209  1.00 22.24           N  
ATOM   3996  NH2 ARG B 246      10.214  -8.786  -9.297  1.00 16.24           N  
HETATM 3997  N   MSE B 247      17.767  -5.666  -5.351  1.00 15.06           N  
HETATM 3998  CA  MSE B 247      18.565  -4.987  -4.318  1.00 15.99           C  
HETATM 3999  C   MSE B 247      18.203  -3.499  -4.286  1.00 14.61           C  
HETATM 4000  O   MSE B 247      17.767  -2.916  -5.294  1.00 14.78           O  
HETATM 4001  CB  MSE B 247      20.062  -5.069  -4.637  1.00 16.36           C  
HETATM 4002  CG  MSE B 247      20.527  -6.401  -5.109  1.00 19.00           C  
HETATM 4003 SE   MSE B 247      22.424  -6.301  -5.550  0.80 20.73          SE  
HETATM 4004  CE  MSE B 247      22.261  -5.328  -7.141  1.00 15.34           C  
ATOM   4005  N   SER B 248      18.422  -2.880  -3.141  1.00 14.20           N  
ATOM   4006  CA  SER B 248      18.171  -1.445  -3.032  1.00 13.72           C  
ATOM   4007  C   SER B 248      19.070  -0.864  -1.971  1.00 13.86           C  
ATOM   4008  O   SER B 248      19.490  -1.545  -1.054  1.00 12.80           O  
ATOM   4009  CB  SER B 248      16.689  -1.170  -2.724  1.00 14.44           C  
ATOM   4010  OG  SER B 248      16.352  -1.598  -1.434  1.00 17.15           O  
ATOM   4011  N   PHE B 249      19.318   0.418  -2.085  1.00 13.60           N  
ATOM   4012  CA  PHE B 249      20.112   1.158  -1.125  1.00 13.22           C  
ATOM   4013  C   PHE B 249      19.430   2.513  -0.911  1.00 13.61           C  
ATOM   4014  O   PHE B 249      19.106   3.229  -1.891  1.00 12.47           O  
ATOM   4015  CB  PHE B 249      21.522   1.374  -1.706  1.00 14.24           C  
ATOM   4016  CG  PHE B 249      22.427   2.192  -0.826  1.00 13.13           C  
ATOM   4017  CD1 PHE B 249      22.655   3.526  -1.106  1.00 17.10           C  
ATOM   4018  CD2 PHE B 249      23.041   1.636   0.258  1.00 14.82           C  
ATOM   4019  CE1 PHE B 249      23.482   4.286  -0.290  1.00 15.55           C  
ATOM   4020  CE2 PHE B 249      23.865   2.410   1.087  1.00 17.24           C  
ATOM   4021  CZ  PHE B 249      24.076   3.713   0.793  1.00 15.30           C  
ATOM   4022  N   ASP B 250      19.200   2.857   0.339  1.00 13.49           N  
ATOM   4023  CA  ASP B 250      18.503   4.101   0.705  1.00 15.38           C  
ATOM   4024  C   ASP B 250      19.322   4.917   1.689  1.00 14.72           C  
ATOM   4025  O   ASP B 250      19.967   4.370   2.558  1.00 14.23           O  
ATOM   4026  CB  ASP B 250      17.182   3.865   1.433  1.00 17.57           C  
ATOM   4027  CG  ASP B 250      16.196   3.074   0.668  1.00 24.58           C  
ATOM   4028  OD1 ASP B 250      15.963   3.354  -0.513  1.00 31.40           O  
ATOM   4029  OD2 ASP B 250      15.608   2.164   1.297  1.00 32.93           O  
HETATM 4030  N   MSE B 251      19.226   6.234   1.591  1.00 14.08           N  
HETATM 4031  CA  MSE B 251      19.732   7.120   2.644  1.00 14.64           C  
HETATM 4032  C   MSE B 251      18.739   8.247   2.910  1.00 14.54           C  
HETATM 4033  O   MSE B 251      18.047   8.724   1.990  1.00 13.74           O  
HETATM 4034  CB  MSE B 251      21.070   7.751   2.247  1.00 15.45           C  
HETATM 4035  CG  MSE B 251      22.124   6.806   1.764  1.00 14.80           C  
HETATM 4036 SE   MSE B 251      23.853   7.708   1.789  0.80 19.09          SE  
HETATM 4037  CE  MSE B 251      23.542   8.963   0.377  1.00 11.36           C  
ATOM   4038  N   GLU B 252      18.670   8.665   4.164  1.00 13.69           N  
ATOM   4039  CA  GLU B 252      17.976   9.926   4.571  1.00 14.95           C  
ATOM   4040  C   GLU B 252      19.028  10.652   5.421  1.00 13.89           C  
ATOM   4041  O   GLU B 252      19.351  10.213   6.518  1.00 13.05           O  
ATOM   4042  CB  GLU B 252      16.650   9.652   5.334  1.00 13.98           C  
ATOM   4043  CG  GLU B 252      15.601   8.997   4.433  1.00 16.69           C  
ATOM   4044  CD  GLU B 252      14.198   8.828   5.031  1.00 20.04           C  
ATOM   4045  OE1 GLU B 252      13.950   9.126   6.228  1.00 29.62           O  
ATOM   4046  OE2 GLU B 252      13.291   8.374   4.274  1.00 29.49           O  
ATOM   4047  N   ILE B 253      19.603  11.701   4.850  1.00 13.34           N  
ATOM   4048  CA  ILE B 253      20.814  12.305   5.364  1.00 13.72           C  
ATOM   4049  C   ILE B 253      20.803  13.825   5.230  1.00 14.59           C  
ATOM   4050  O   ILE B 253      20.012  14.398   4.471  1.00 13.56           O  
ATOM   4051  CB  ILE B 253      22.095  11.693   4.693  1.00 14.19           C  
ATOM   4052  CG1 ILE B 253      21.985  11.596   3.179  1.00 15.49           C  
ATOM   4053  CG2 ILE B 253      22.352  10.281   5.213  1.00 13.82           C  
ATOM   4054  CD1 ILE B 253      22.199  12.909   2.463  1.00 16.03           C  
ATOM   4055  N   ASN B 254      21.717  14.449   5.969  1.00 14.27           N  
ATOM   4056  CA  ASN B 254      22.040  15.847   5.780  1.00 14.45           C  
ATOM   4057  C   ASN B 254      23.062  15.863   4.637  1.00 14.48           C  
ATOM   4058  O   ASN B 254      24.127  15.271   4.742  1.00 14.65           O  
ATOM   4059  CB  ASN B 254      22.543  16.447   7.112  1.00 14.68           C  
ATOM   4060  CG  ASN B 254      23.090  17.870   6.976  1.00 14.70           C  
ATOM   4061  OD1 ASN B 254      23.686  18.205   5.958  1.00 13.58           O  
ATOM   4062  ND2 ASN B 254      22.868  18.717   8.000  1.00 12.25           N  
ATOM   4063  N   ASN B 255      22.701  16.508   3.522  1.00 13.04           N  
ATOM   4064  CA  ASN B 255      23.466  16.498   2.285  1.00 14.21           C  
ATOM   4065  C   ASN B 255      24.923  16.980   2.428  1.00 14.04           C  
ATOM   4066  O   ASN B 255      25.863  16.185   2.254  1.00 14.11           O  
ATOM   4067  CB  ASN B 255      22.665  17.320   1.267  1.00 12.50           C  
ATOM   4068  CG  ASN B 255      23.423  17.664   0.008  1.00 14.47           C  
ATOM   4069  OD1 ASN B 255      24.454  17.089  -0.315  1.00 15.93           O  
ATOM   4070  ND2 ASN B 255      22.857  18.608  -0.742  1.00 12.99           N  
ATOM   4071  N   PRO B 256      25.123  18.265   2.765  1.00 13.76           N  
ATOM   4072  CA  PRO B 256      26.518  18.743   2.906  1.00 14.14           C  
ATOM   4073  C   PRO B 256      27.276  18.061   4.054  1.00 14.30           C  
ATOM   4074  O   PRO B 256      28.510  17.895   3.975  1.00 15.00           O  
ATOM   4075  CB  PRO B 256      26.343  20.240   3.179  1.00 14.80           C  
ATOM   4076  CG  PRO B 256      24.981  20.373   3.727  1.00 14.51           C  
ATOM   4077  CD  PRO B 256      24.153  19.334   3.039  1.00 15.05           C  
ATOM   4078  N   ALA B 257      26.571  17.659   5.107  1.00 14.17           N  
ATOM   4079  CA  ALA B 257      27.244  16.928   6.198  1.00 13.60           C  
ATOM   4080  C   ALA B 257      27.876  15.633   5.691  1.00 13.84           C  
ATOM   4081  O   ALA B 257      29.027  15.280   6.044  1.00 13.67           O  
ATOM   4082  CB  ALA B 257      26.275  16.651   7.364  1.00 13.65           C  
ATOM   4083  N   LEU B 258      27.135  14.889   4.876  1.00 13.60           N  
ATOM   4084  CA  LEU B 258      27.670  13.657   4.336  1.00 13.81           C  
ATOM   4085  C   LEU B 258      28.809  13.936   3.353  1.00 14.17           C  
ATOM   4086  O   LEU B 258      29.839  13.288   3.416  1.00 15.32           O  
ATOM   4087  CB  LEU B 258      26.551  12.816   3.708  1.00 14.13           C  
ATOM   4088  CG  LEU B 258      26.938  11.442   3.163  1.00 12.78           C  
ATOM   4089  CD1 LEU B 258      27.610  10.569   4.222  1.00 14.58           C  
ATOM   4090  CD2 LEU B 258      25.719  10.722   2.559  1.00 13.31           C  
ATOM   4091  N   THR B 259      28.639  14.906   2.452  1.00 14.31           N  
ATOM   4092  CA  THR B 259      29.712  15.265   1.525  1.00 14.47           C  
ATOM   4093  C   THR B 259      31.004  15.594   2.298  1.00 14.21           C  
ATOM   4094  O   THR B 259      32.099  15.135   1.955  1.00 14.16           O  
ATOM   4095  CB  THR B 259      29.290  16.420   0.646  1.00 15.42           C  
ATOM   4096  OG1 THR B 259      28.141  16.018  -0.117  1.00 15.40           O  
ATOM   4097  CG2 THR B 259      30.448  16.832  -0.305  1.00 14.73           C  
ATOM   4098  N   GLY B 260      30.891  16.381   3.363  1.00 13.45           N  
ATOM   4099  CA  GLY B 260      32.051  16.742   4.129  1.00 14.04           C  
ATOM   4100  C   GLY B 260      32.759  15.549   4.698  1.00 13.20           C  
ATOM   4101  O   GLY B 260      33.967  15.477   4.681  1.00 13.16           O  
ATOM   4102  N   GLN B 261      31.990  14.583   5.186  1.00 13.82           N  
ATOM   4103  CA  GLN B 261      32.575  13.382   5.755  1.00 12.83           C  
ATOM   4104  C   GLN B 261      33.197  12.503   4.669  1.00 13.47           C  
ATOM   4105  O   GLN B 261      34.280  11.952   4.884  1.00 14.07           O  
ATOM   4106  CB  GLN B 261      31.543  12.573   6.528  1.00 13.60           C  
ATOM   4107  CG  GLN B 261      32.098  11.247   7.082  1.00 13.72           C  
ATOM   4108  CD  GLN B 261      33.157  11.432   8.177  1.00 15.33           C  
ATOM   4109  OE1 GLN B 261      32.857  11.936   9.239  1.00 15.65           O  
ATOM   4110  NE2 GLN B 261      34.366  10.936   7.937  1.00 16.12           N  
ATOM   4111  N   VAL B 262      32.564  12.399   3.491  1.00 14.06           N  
ATOM   4112  CA  VAL B 262      33.155  11.560   2.422  1.00 12.96           C  
ATOM   4113  C   VAL B 262      34.481  12.171   1.994  1.00 14.26           C  
ATOM   4114  O   VAL B 262      35.421  11.452   1.674  1.00 14.56           O  
ATOM   4115  CB  VAL B 262      32.228  11.363   1.203  1.00 13.24           C  
ATOM   4116  CG1 VAL B 262      32.876  10.401   0.169  1.00 11.55           C  
ATOM   4117  CG2 VAL B 262      30.851  10.776   1.646  1.00 14.30           C  
ATOM   4118  N   LEU B 263      34.552  13.500   1.949  1.00 14.32           N  
ATOM   4119  CA  LEU B 263      35.835  14.181   1.650  1.00 14.21           C  
ATOM   4120  C   LEU B 263      36.965  13.803   2.582  1.00 14.18           C  
ATOM   4121  O   LEU B 263      38.088  13.608   2.130  1.00 13.93           O  
ATOM   4122  CB  LEU B 263      35.674  15.701   1.639  1.00 14.16           C  
ATOM   4123  CG  LEU B 263      35.019  16.182   0.351  1.00 15.39           C  
ATOM   4124  CD1 LEU B 263      34.540  17.634   0.543  1.00 15.95           C  
ATOM   4125  CD2 LEU B 263      35.997  16.088  -0.826  1.00 17.07           C  
ATOM   4126  N   VAL B 264      36.686  13.689   3.875  1.00 13.48           N  
ATOM   4127  CA  VAL B 264      37.685  13.225   4.834  1.00 12.97           C  
ATOM   4128  C   VAL B 264      38.123  11.779   4.547  1.00 13.75           C  
ATOM   4129  O   VAL B 264      39.314  11.446   4.552  1.00 13.11           O  
ATOM   4130  CB  VAL B 264      37.102  13.358   6.255  1.00 13.36           C  
ATOM   4131  CG1 VAL B 264      37.979  12.671   7.306  1.00 12.70           C  
ATOM   4132  CG2 VAL B 264      36.902  14.839   6.587  1.00 12.81           C  
ATOM   4133  N   CYS B 265      37.148  10.913   4.311  1.00 12.73           N  
ATOM   4134  CA  CYS B 265      37.429   9.545   3.893  1.00 13.34           C  
ATOM   4135  C   CYS B 265      38.307   9.457   2.663  1.00 13.28           C  
ATOM   4136  O   CYS B 265      39.251   8.662   2.625  1.00 13.94           O  
ATOM   4137  CB  CYS B 265      36.130   8.826   3.610  1.00 13.89           C  
ATOM   4138  SG  CYS B 265      35.081   8.608   5.040  1.00 14.82           S  
ATOM   4139  N   ALA B 266      37.967  10.259   1.638  1.00 12.68           N  
ATOM   4140  CA  ALA B 266      38.729  10.317   0.398  1.00 13.75           C  
ATOM   4141  C   ALA B 266      40.164  10.849   0.613  1.00 14.19           C  
ATOM   4142  O   ALA B 266      41.114  10.416  -0.053  1.00 13.79           O  
ATOM   4143  CB  ALA B 266      37.996  11.179  -0.606  1.00 13.02           C  
ATOM   4144  N   ALA B 267      40.306  11.827   1.509  1.00 13.63           N  
ATOM   4145  CA  ALA B 267      41.609  12.393   1.821  1.00 13.78           C  
ATOM   4146  C   ALA B 267      42.500  11.354   2.514  1.00 14.00           C  
ATOM   4147  O   ALA B 267      43.680  11.218   2.215  1.00 14.41           O  
ATOM   4148  CB  ALA B 267      41.427  13.642   2.718  1.00 13.46           C  
ATOM   4149  N   ARG B 268      41.906  10.582   3.404  1.00 14.98           N  
ATOM   4150  CA  ARG B 268      42.607   9.521   4.086  1.00 15.70           C  
ATOM   4151  C   ARG B 268      43.019   8.464   3.067  1.00 16.02           C  
ATOM   4152  O   ARG B 268      44.160   7.967   3.093  1.00 15.20           O  
ATOM   4153  CB  ARG B 268      41.646   8.939   5.148  1.00 16.37           C  
ATOM   4154  CG  ARG B 268      42.098   7.735   5.838  1.00 18.07           C  
ATOM   4155  CD  ARG B 268      40.991   7.219   6.730  1.00 16.86           C  
ATOM   4156  NE  ARG B 268      40.659   8.151   7.801  1.00 16.74           N  
ATOM   4157  CZ  ARG B 268      39.442   8.579   8.123  1.00 16.54           C  
ATOM   4158  NH1 ARG B 268      39.307   9.411   9.166  1.00 17.18           N  
ATOM   4159  NH2 ARG B 268      38.353   8.158   7.481  1.00 14.96           N  
ATOM   4160  N   ALA B 269      42.097   8.114   2.162  1.00 16.07           N  
ATOM   4161  CA  ALA B 269      42.399   7.137   1.109  1.00 16.32           C  
ATOM   4162  C   ALA B 269      43.491   7.612   0.156  1.00 16.35           C  
ATOM   4163  O   ALA B 269      44.334   6.817  -0.274  1.00 15.01           O  
ATOM   4164  CB  ALA B 269      41.107   6.765   0.310  1.00 15.74           C  
ATOM   4165  N   ALA B 270      43.472   8.892  -0.193  1.00 16.42           N  
ATOM   4166  CA  ALA B 270      44.507   9.462  -1.090  1.00 17.87           C  
ATOM   4167  C   ALA B 270      45.911   9.199  -0.565  1.00 18.16           C  
ATOM   4168  O   ALA B 270      46.832   8.946  -1.341  1.00 18.62           O  
ATOM   4169  CB  ALA B 270      44.287  10.961  -1.286  1.00 16.74           C  
HETATM 4170  N   MSE B 271      46.059   9.215   0.764  1.00 18.57           N  
HETATM 4171  CA  MSE B 271      47.367   8.961   1.391  1.00 19.63           C  
HETATM 4172  C   MSE B 271      47.871   7.517   1.250  1.00 19.32           C  
HETATM 4173  O   MSE B 271      49.053   7.229   1.521  1.00 20.35           O  
HETATM 4174  CB  MSE B 271      47.352   9.357   2.865  1.00 20.39           C  
HETATM 4175  CG  MSE B 271      46.949  10.787   3.154  1.00 23.23           C  
HETATM 4176 SE   MSE B 271      48.156  12.071   2.304  0.80 31.53          SE  
HETATM 4177  CE  MSE B 271      49.742  11.505   3.275  1.00 30.81           C  
ATOM   4178  N   ARG B 272      47.007   6.619   0.824  1.00 18.30           N  
ATOM   4179  CA  ARG B 272      47.313   5.211   0.733  1.00 19.03           C  
ATOM   4180  C   ARG B 272      47.444   4.718  -0.705  1.00 19.22           C  
ATOM   4181  O   ARG B 272      47.598   3.519  -0.918  1.00 19.64           O  
ATOM   4182  CB  ARG B 272      46.193   4.438   1.447  1.00 19.15           C  
ATOM   4183  CG  ARG B 272      46.236   4.666   2.937  1.00 19.94           C  
ATOM   4184  CD  ARG B 272      44.908   4.391   3.601  1.00 18.72           C  
ATOM   4185  NE  ARG B 272      45.091   4.068   5.026  1.00 18.85           N  
ATOM   4186  CZ  ARG B 272      44.079   3.900   5.871  1.00 19.19           C  
ATOM   4187  NH1 ARG B 272      42.852   4.047   5.441  1.00 17.93           N  
ATOM   4188  NH2 ARG B 272      44.294   3.603   7.149  1.00 20.45           N  
ATOM   4189  N   GLN B 273      47.298   5.613  -1.687  1.00 18.49           N  
ATOM   4190  CA  GLN B 273      47.356   5.219  -3.107  1.00 19.13           C  
ATOM   4191  C   GLN B 273      48.717   5.508  -3.744  1.00 19.41           C  
ATOM   4192  O   GLN B 273      49.459   6.394  -3.302  1.00 19.59           O  
ATOM   4193  CB  GLN B 273      46.297   5.937  -3.941  1.00 18.86           C  
ATOM   4194  CG  GLN B 273      44.826   5.791  -3.429  1.00 17.40           C  
ATOM   4195  CD  GLN B 273      44.462   4.388  -3.025  1.00 18.20           C  
ATOM   4196  OE1 GLN B 273      44.614   3.436  -3.813  1.00 16.64           O  
ATOM   4197  NE2 GLN B 273      43.988   4.233  -1.788  1.00 16.76           N  
ATOM   4198  N   GLN B 274      48.994   4.780  -4.818  1.00 18.55           N  
ATOM   4199  CA  GLN B 274      50.102   5.091  -5.725  1.00 19.22           C  
ATOM   4200  C   GLN B 274      49.726   6.360  -6.465  1.00 19.10           C  
ATOM   4201  O   GLN B 274      48.547   6.720  -6.500  1.00 18.14           O  
ATOM   4202  CB  GLN B 274      50.328   3.940  -6.709  1.00 19.53           C  
ATOM   4203  CG  GLN B 274      50.698   2.653  -6.011  1.00 23.52           C  
ATOM   4204  CD  GLN B 274      51.979   2.807  -5.250  1.00 28.41           C  
ATOM   4205  OE1 GLN B 274      53.005   3.171  -5.825  1.00 30.34           O  
ATOM   4206  NE2 GLN B 274      51.931   2.555  -3.940  1.00 31.54           N  
ATOM   4207  N   PRO B 275      50.729   7.073  -7.021  1.00 18.95           N  
ATOM   4208  CA  PRO B 275      50.428   8.319  -7.720  1.00 18.72           C  
ATOM   4209  C   PRO B 275      49.389   8.148  -8.815  1.00 18.30           C  
ATOM   4210  O   PRO B 275      49.394   7.138  -9.522  1.00 20.20           O  
ATOM   4211  CB  PRO B 275      51.794   8.735  -8.306  1.00 18.30           C  
ATOM   4212  CG  PRO B 275      52.759   8.176  -7.303  1.00 20.01           C  
ATOM   4213  CD  PRO B 275      52.182   6.808  -6.991  1.00 18.97           C  
ATOM   4214  N   GLY B 276      48.523   9.139  -8.972  1.00 18.08           N  
ATOM   4215  CA  GLY B 276      47.472   9.109  -9.983  1.00 18.24           C  
ATOM   4216  C   GLY B 276      46.177   9.711  -9.484  1.00 18.57           C  
ATOM   4217  O   GLY B 276      46.146  10.280  -8.383  1.00 18.88           O  
ATOM   4218  N   ALA B 277      45.117   9.597 -10.294  1.00 17.35           N  
ATOM   4219  CA  ALA B 277      43.794  10.099  -9.903  1.00 17.28           C  
ATOM   4220  C   ALA B 277      42.807   8.929  -9.878  1.00 17.62           C  
ATOM   4221  O   ALA B 277      42.859   8.042 -10.750  1.00 17.62           O  
ATOM   4222  CB  ALA B 277      43.299  11.199 -10.855  1.00 16.76           C  
ATOM   4223  N   TYR B 278      41.891   8.972  -8.913  1.00 16.20           N  
ATOM   4224  CA  TYR B 278      40.952   7.869  -8.629  1.00 16.16           C  
ATOM   4225  C   TYR B 278      39.537   8.356  -8.335  1.00 15.76           C  
ATOM   4226  O   TYR B 278      39.365   9.258  -7.530  1.00 15.55           O  
ATOM   4227  CB  TYR B 278      41.424   7.124  -7.368  1.00 16.31           C  
ATOM   4228  CG  TYR B 278      42.856   6.620  -7.454  1.00 15.87           C  
ATOM   4229  CD1 TYR B 278      43.918   7.403  -7.044  1.00 16.11           C  
ATOM   4230  CD2 TYR B 278      43.129   5.373  -7.960  1.00 17.88           C  
ATOM   4231  CE1 TYR B 278      45.235   6.966  -7.162  1.00 17.39           C  
ATOM   4232  CE2 TYR B 278      44.439   4.902  -8.072  1.00 18.88           C  
ATOM   4233  CZ  TYR B 278      45.487   5.714  -7.672  1.00 17.88           C  
ATOM   4234  OH  TYR B 278      46.776   5.266  -7.792  1.00 18.48           O  
ATOM   4235  N   THR B 279      38.522   7.703  -8.903  1.00 15.51           N  
ATOM   4236  CA  THR B 279      37.156   7.857  -8.380  1.00 14.80           C  
ATOM   4237  C   THR B 279      37.036   6.885  -7.203  1.00 14.65           C  
ATOM   4238  O   THR B 279      37.914   6.032  -7.046  1.00 15.04           O  
ATOM   4239  CB  THR B 279      36.088   7.524  -9.407  1.00 15.33           C  
ATOM   4240  OG1 THR B 279      35.960   6.103  -9.559  1.00 13.35           O  
ATOM   4241  CG2 THR B 279      36.389   8.193 -10.771  1.00 15.51           C  
ATOM   4242  N   LEU B 280      35.974   6.991  -6.409  1.00 14.93           N  
ATOM   4243  CA  LEU B 280      35.798   6.075  -5.262  1.00 14.31           C  
ATOM   4244  C   LEU B 280      35.517   4.642  -5.701  1.00 14.68           C  
ATOM   4245  O   LEU B 280      35.722   3.710  -4.918  1.00 14.44           O  
ATOM   4246  CB  LEU B 280      34.719   6.563  -4.292  1.00 14.67           C  
ATOM   4247  CG  LEU B 280      35.059   7.761  -3.400  1.00 17.41           C  
ATOM   4248  CD1 LEU B 280      33.890   8.031  -2.457  1.00 18.83           C  
ATOM   4249  CD2 LEU B 280      36.372   7.574  -2.621  1.00 17.43           C  
ATOM   4250  N   GLN B 281      35.112   4.453  -6.942  1.00 14.15           N  
ATOM   4251  CA  GLN B 281      35.017   3.096  -7.548  1.00 15.02           C  
ATOM   4252  C   GLN B 281      36.389   2.398  -7.600  1.00 14.85           C  
ATOM   4253  O   GLN B 281      36.464   1.179  -7.694  1.00 15.66           O  
ATOM   4254  CB  GLN B 281      34.501   3.184  -8.993  1.00 16.38           C  
ATOM   4255  CG  GLN B 281      33.175   3.874  -9.200  1.00 16.90           C  
ATOM   4256  CD  GLN B 281      32.934   4.226 -10.663  1.00 16.47           C  
ATOM   4257  OE1 GLN B 281      32.099   3.601 -11.377  1.00 20.34           O  
ATOM   4258  NE2 GLN B 281      33.682   5.173 -11.131  1.00 15.54           N  
ATOM   4259  N   GLU B 282      37.461   3.188  -7.580  1.00 14.40           N  
ATOM   4260  CA  GLU B 282      38.808   2.723  -7.747  1.00 14.74           C  
ATOM   4261  C   GLU B 282      39.580   2.618  -6.435  1.00 15.12           C  
ATOM   4262  O   GLU B 282      40.772   2.303  -6.464  1.00 15.42           O  
ATOM   4263  CB  GLU B 282      39.549   3.680  -8.683  1.00 14.55           C  
ATOM   4264  CG  GLU B 282      38.909   3.873 -10.030  1.00 15.31           C  
ATOM   4265  CD  GLU B 282      39.748   4.739 -10.939  1.00 14.14           C  
ATOM   4266  OE1 GLU B 282      40.665   4.181 -11.603  1.00 15.89           O  
ATOM   4267  OE2 GLU B 282      39.471   5.954 -10.996  1.00 15.61           O  
ATOM   4268  N   ILE B 283      38.911   2.881  -5.306  1.00 14.96           N  
ATOM   4269  CA  ILE B 283      39.528   2.863  -3.971  1.00 14.67           C  
ATOM   4270  C   ILE B 283      38.944   1.706  -3.157  1.00 14.73           C  
ATOM   4271  O   ILE B 283      37.737   1.614  -3.040  1.00 15.05           O  
ATOM   4272  CB  ILE B 283      39.190   4.205  -3.262  1.00 14.61           C  
ATOM   4273  CG1 ILE B 283      39.809   5.376  -4.029  1.00 15.58           C  
ATOM   4274  CG2 ILE B 283      39.652   4.230  -1.797  1.00 15.17           C  
ATOM   4275  CD1 ILE B 283      41.343   5.351  -4.089  1.00 11.78           C  
ATOM   4276  N   PRO B 284      39.790   0.832  -2.573  1.00 13.96           N  
ATOM   4277  CA  PRO B 284      39.233  -0.175  -1.677  1.00 14.12           C  
ATOM   4278  C   PRO B 284      38.475   0.516  -0.559  1.00 12.95           C  
ATOM   4279  O   PRO B 284      39.022   1.434   0.039  1.00 13.21           O  
ATOM   4280  CB  PRO B 284      40.499  -0.840  -1.092  1.00 14.11           C  
ATOM   4281  CG  PRO B 284      41.541  -0.632  -2.078  1.00 15.21           C  
ATOM   4282  CD  PRO B 284      41.254   0.718  -2.679  1.00 14.66           C  
ATOM   4283  N   VAL B 285      37.258   0.073  -0.246  1.00 13.14           N  
ATOM   4284  CA  VAL B 285      36.467   0.781   0.750  1.00 13.46           C  
ATOM   4285  C   VAL B 285      37.163   0.819   2.111  1.00 13.99           C  
ATOM   4286  O   VAL B 285      37.017   1.793   2.854  1.00 13.86           O  
ATOM   4287  CB  VAL B 285      35.024   0.241   0.860  1.00 13.14           C  
ATOM   4288  CG1 VAL B 285      34.212   0.559  -0.412  1.00 15.46           C  
ATOM   4289  CG2 VAL B 285      35.011  -1.287   1.200  1.00 12.94           C  
ATOM   4290  N   ILE B 286      37.982  -0.196   2.409  1.00 14.48           N  
ATOM   4291  CA  ILE B 286      38.706  -0.235   3.684  1.00 13.77           C  
ATOM   4292  C   ILE B 286      39.724   0.937   3.798  1.00 14.60           C  
ATOM   4293  O   ILE B 286      40.018   1.392   4.896  1.00 15.64           O  
ATOM   4294  CB  ILE B 286      39.382  -1.589   3.910  1.00 14.34           C  
ATOM   4295  CG1 ILE B 286      39.672  -1.841   5.405  1.00 13.84           C  
ATOM   4296  CG2 ILE B 286      40.664  -1.732   3.057  1.00 12.54           C  
ATOM   4297  CD1 ILE B 286      39.921  -3.336   5.720  1.00 13.71           C  
ATOM   4298  N   ASP B 287      40.167   1.485   2.652  1.00 14.06           N  
ATOM   4299  CA  ASP B 287      41.113   2.613   2.653  1.00 14.05           C  
ATOM   4300  C   ASP B 287      40.415   3.897   3.102  1.00 14.27           C  
ATOM   4301  O   ASP B 287      41.071   4.895   3.390  1.00 14.68           O  
ATOM   4302  CB  ASP B 287      41.738   2.815   1.284  1.00 14.20           C  
ATOM   4303  CG  ASP B 287      42.899   1.865   1.028  1.00 15.41           C  
ATOM   4304  OD1 ASP B 287      43.326   1.123   1.980  1.00 15.16           O  
ATOM   4305  OD2 ASP B 287      43.405   1.887  -0.121  1.00 16.49           O  
ATOM   4306  N   LEU B 288      39.086   3.868   3.188  1.00 13.88           N  
ATOM   4307  CA  LEU B 288      38.329   5.049   3.646  1.00 14.42           C  
ATOM   4308  C   LEU B 288      38.262   5.123   5.149  1.00 14.62           C  
ATOM   4309  O   LEU B 288      37.714   6.104   5.686  1.00 15.69           O  
ATOM   4310  CB  LEU B 288      36.890   5.008   3.122  1.00 14.52           C  
ATOM   4311  CG  LEU B 288      36.723   4.901   1.619  1.00 14.59           C  
ATOM   4312  CD1 LEU B 288      35.204   4.617   1.329  1.00 14.92           C  
ATOM   4313  CD2 LEU B 288      37.236   6.176   0.928  1.00 13.53           C  
ATOM   4314  N   LEU B 289      38.718   4.070   5.853  1.00 14.60           N  
ATOM   4315  CA  LEU B 289      38.637   3.995   7.314  1.00 14.56           C  
ATOM   4316  C   LEU B 289      39.983   4.223   7.999  1.00 15.25           C  
ATOM   4317  O   LEU B 289      41.030   3.824   7.479  1.00 14.18           O  
ATOM   4318  CB  LEU B 289      38.155   2.625   7.766  1.00 14.79           C  
ATOM   4319  CG  LEU B 289      36.688   2.322   7.452  1.00 14.01           C  
ATOM   4320  CD1 LEU B 289      36.426   0.832   7.513  1.00 16.82           C  
ATOM   4321  CD2 LEU B 289      35.803   3.067   8.449  1.00 15.24           C  
ATOM   4322  N   PRO B 290      39.968   4.894   9.153  1.00 15.14           N  
ATOM   4323  CA  PRO B 290      41.215   5.211   9.849  1.00 16.07           C  
ATOM   4324  C   PRO B 290      41.898   3.969  10.436  1.00 17.26           C  
ATOM   4325  O   PRO B 290      41.233   3.079  10.909  1.00 18.16           O  
ATOM   4326  CB  PRO B 290      40.752   6.119  10.998  1.00 16.34           C  
ATOM   4327  CG  PRO B 290      39.301   5.737  11.205  1.00 16.32           C  
ATOM   4328  CD  PRO B 290      38.775   5.381   9.875  1.00 14.85           C  
ATOM   4329  N   GLY B 291      43.216   3.922  10.393  1.00 18.33           N  
ATOM   4330  CA  GLY B 291      43.950   2.910  11.113  1.00 18.65           C  
ATOM   4331  C   GLY B 291      44.125   1.678  10.253  1.00 19.03           C  
ATOM   4332  O   GLY B 291      43.715   1.634   9.086  1.00 19.40           O  
ATOM   4333  N   ASP B 292      44.717   0.657  10.833  1.00 18.98           N  
ATOM   4334  CA  ASP B 292      45.093  -0.511  10.043  1.00 19.59           C  
ATOM   4335  C   ASP B 292      43.893  -1.377   9.690  1.00 17.97           C  
ATOM   4336  O   ASP B 292      42.830  -1.294  10.298  1.00 17.85           O  
ATOM   4337  CB  ASP B 292      46.155  -1.333  10.776  1.00 20.32           C  
ATOM   4338  CG  ASP B 292      47.526  -0.624  10.833  1.00 25.32           C  
ATOM   4339  OD1 ASP B 292      47.885   0.196   9.921  1.00 29.13           O  
ATOM   4340  OD2 ASP B 292      48.237  -0.897  11.810  1.00 30.76           O  
ATOM   4341  N   ARG B 293      44.072  -2.234   8.694  1.00 16.07           N  
ATOM   4342  CA  ARG B 293      42.945  -2.971   8.129  1.00 15.85           C  
ATOM   4343  C   ARG B 293      42.387  -4.076   8.994  1.00 16.01           C  
ATOM   4344  O   ARG B 293      41.191  -4.354   8.919  1.00 16.05           O  
ATOM   4345  CB  ARG B 293      43.372  -3.590   6.791  1.00 16.15           C  
ATOM   4346  CG  ARG B 293      43.679  -2.536   5.737  1.00 15.89           C  
ATOM   4347  CD  ARG B 293      44.022  -3.189   4.417  1.00 15.90           C  
ATOM   4348  NE  ARG B 293      44.056  -2.200   3.357  1.00 15.68           N  
ATOM   4349  CZ  ARG B 293      44.124  -2.459   2.052  1.00 15.95           C  
ATOM   4350  NH1 ARG B 293      44.195  -3.699   1.594  1.00 15.46           N  
ATOM   4351  NH2 ARG B 293      44.141  -1.436   1.187  1.00 16.64           N  
ATOM   4352  N   GLU B 294      43.237  -4.737   9.768  1.00 15.27           N  
ATOM   4353  CA  GLU B 294      42.793  -5.940  10.449  1.00 16.74           C  
ATOM   4354  C   GLU B 294      41.579  -5.683  11.373  1.00 17.50           C  
ATOM   4355  O   GLU B 294      40.650  -6.501  11.447  1.00 16.50           O  
ATOM   4356  CB  GLU B 294      43.951  -6.618  11.203  1.00 16.94           C  
ATOM   4357  CG  GLU B 294      44.961  -7.341  10.256  1.00 18.78           C  
ATOM   4358  CD  GLU B 294      45.844  -6.384   9.443  1.00 23.39           C  
ATOM   4359  OE1 GLU B 294      46.009  -5.197   9.845  1.00 21.12           O  
ATOM   4360  OE2 GLU B 294      46.392  -6.831   8.388  1.00 26.88           O  
ATOM   4361  N   GLN B 295      41.597  -4.579  12.112  1.00 17.96           N  
ATOM   4362  CA  GLN B 295      40.468  -4.293  13.009  1.00 18.42           C  
ATOM   4363  C   GLN B 295      39.146  -4.232  12.226  1.00 17.97           C  
ATOM   4364  O   GLN B 295      38.099  -4.665  12.730  1.00 18.26           O  
ATOM   4365  CB  GLN B 295      40.684  -2.981  13.768  1.00 19.02           C  
ATOM   4366  CG  GLN B 295      40.661  -1.757  12.887  1.00 20.00           C  
ATOM   4367  CD  GLN B 295      41.133  -0.488  13.609  1.00 22.19           C  
ATOM   4368  OE1 GLN B 295      40.608  -0.154  14.663  1.00 25.88           O  
ATOM   4369  NE2 GLN B 295      42.113   0.233  13.018  1.00 25.23           N  
ATOM   4370  N   TRP B 296      39.180  -3.705  10.997  1.00 16.49           N  
ATOM   4371  CA  TRP B 296      37.954  -3.504  10.233  1.00 16.61           C  
ATOM   4372  C   TRP B 296      37.502  -4.787   9.545  1.00 16.80           C  
ATOM   4373  O   TRP B 296      36.308  -4.991   9.301  1.00 16.76           O  
ATOM   4374  CB  TRP B 296      38.149  -2.395   9.209  1.00 16.55           C  
ATOM   4375  CG  TRP B 296      38.493  -1.098   9.853  1.00 15.74           C  
ATOM   4376  CD1 TRP B 296      39.652  -0.412   9.733  1.00 17.07           C  
ATOM   4377  CD2 TRP B 296      37.677  -0.365  10.770  1.00 15.26           C  
ATOM   4378  NE1 TRP B 296      39.598   0.737  10.483  1.00 16.64           N  
ATOM   4379  CE2 TRP B 296      38.400   0.788  11.141  1.00 16.31           C  
ATOM   4380  CE3 TRP B 296      36.392  -0.561  11.296  1.00 15.92           C  
ATOM   4381  CZ2 TRP B 296      37.882   1.752  12.004  1.00 16.34           C  
ATOM   4382  CZ3 TRP B 296      35.886   0.377  12.185  1.00 16.30           C  
ATOM   4383  CH2 TRP B 296      36.631   1.531  12.526  1.00 17.77           C  
ATOM   4384  N   ILE B 297      38.470  -5.651   9.228  1.00 16.40           N  
ATOM   4385  CA  ILE B 297      38.138  -6.958   8.670  1.00 15.85           C  
ATOM   4386  C   ILE B 297      37.433  -7.738   9.769  1.00 16.65           C  
ATOM   4387  O   ILE B 297      36.361  -8.329   9.554  1.00 15.38           O  
ATOM   4388  CB  ILE B 297      39.412  -7.679   8.133  1.00 15.49           C  
ATOM   4389  CG1 ILE B 297      39.954  -6.934   6.896  1.00 16.01           C  
ATOM   4390  CG2 ILE B 297      39.131  -9.149   7.752  1.00 16.65           C  
ATOM   4391  CD1 ILE B 297      41.371  -7.404   6.457  1.00 15.96           C  
ATOM   4392  N   GLY B 298      38.037  -7.717  10.955  1.00 17.14           N  
ATOM   4393  CA  GLY B 298      37.488  -8.416  12.086  1.00 17.80           C  
ATOM   4394  C   GLY B 298      36.109  -7.907  12.463  1.00 18.56           C  
ATOM   4395  O   GLY B 298      35.217  -8.688  12.756  1.00 18.93           O  
ATOM   4396  N   LYS B 299      35.915  -6.593  12.452  1.00 19.37           N  
ATOM   4397  CA  LYS B 299      34.620  -6.027  12.870  1.00 20.14           C  
ATOM   4398  C   LYS B 299      33.539  -6.076  11.816  1.00 19.57           C  
ATOM   4399  O   LYS B 299      32.360  -6.188  12.167  1.00 19.40           O  
ATOM   4400  CB  LYS B 299      34.774  -4.568  13.293  1.00 20.49           C  
ATOM   4401  CG  LYS B 299      35.524  -4.384  14.612  1.00 23.06           C  
ATOM   4402  CD  LYS B 299      35.756  -2.906  14.910  1.00 24.17           C  
ATOM   4403  CE  LYS B 299      36.078  -2.676  16.371  1.00 26.96           C  
ATOM   4404  NZ  LYS B 299      36.683  -1.319  16.595  1.00 30.28           N  
ATOM   4405  N   LEU B 300      33.911  -5.895  10.551  1.00 18.24           N  
ATOM   4406  CA  LEU B 300      32.924  -5.683   9.493  1.00 18.27           C  
ATOM   4407  C   LEU B 300      32.807  -6.749   8.412  1.00 19.05           C  
ATOM   4408  O   LEU B 300      31.798  -6.778   7.708  1.00 17.36           O  
ATOM   4409  CB  LEU B 300      33.204  -4.370   8.779  1.00 18.46           C  
ATOM   4410  CG  LEU B 300      33.409  -3.140   9.677  1.00 17.60           C  
ATOM   4411  CD1 LEU B 300      33.809  -1.907   8.811  1.00 16.83           C  
ATOM   4412  CD2 LEU B 300      32.173  -2.867  10.516  1.00 18.10           C  
ATOM   4413  N   CYS B 301      33.823  -7.587   8.220  1.00 18.77           N  
ATOM   4414  CA  CYS B 301      33.780  -8.485   7.068  1.00 18.67           C  
ATOM   4415  C   CYS B 301      32.787  -9.580   7.296  1.00 18.65           C  
ATOM   4416  O   CYS B 301      32.837 -10.288   8.336  1.00 20.06           O  
ATOM   4417  CB  CYS B 301      35.148  -9.065   6.721  1.00 18.84           C  
ATOM   4418  SG  CYS B 301      35.219  -9.636   4.989  1.00 20.97           S  
ATOM   4419  OXT CYS B 301      31.902  -9.778   6.458  1.00 18.36           O  
TER    4420      CYS B 301                                                      
END
MOLECULE T0452.pdb
ATOM      1  N   MET     1      52.780  12.131   9.830  1.00 64.27           N  
ATOM      2  CA  MET     1      51.866  13.329   9.884  1.00 62.83           C  
ATOM      3  C   MET     1      51.173  13.643   8.544  1.00 60.55           C  
ATOM      4  O   MET     1      51.817  14.126   7.602  1.00 57.92           O  
ATOM      5  CB  MET     1      52.673  14.551  10.319  1.00 66.08           C  
ATOM      6  CG  MET     1      51.875  15.808  10.723  1.00 68.81           C  
ATOM      7  SD  MET     1      50.702  15.464  12.236  0.75 84.58          SE  
ATOM      8  CE  MET     1      51.122  17.040  13.324  1.00 62.48           C  
ATOM      9  N   ILE     2      49.865  13.365   8.474  1.00 58.05           N  
ATOM     10  CA  ILE     2      49.049  13.668   7.280  1.00 58.01           C  
ATOM     11  C   ILE     2      48.619  15.140   7.290  1.00 55.65           C  
ATOM     12  O   ILE     2      47.911  15.582   8.206  1.00 53.04           O  
ATOM     13  CB  ILE     2      47.760  12.805   7.198  1.00 58.03           C  
ATOM     14  CG1 ILE     2      48.102  11.309   7.195  1.00 54.77           C  
ATOM     15  CG2 ILE     2      46.954  13.201   5.952  1.00 57.20           C  
ATOM     16  CD1 ILE     2      46.907  10.395   7.282  1.00 57.93           C  
ATOM     17  N   LYS     3      49.008  15.877   6.251  1.00 55.60           N  
ATOM     18  CA  LYS     3      48.740  17.321   6.172  1.00 56.35           C  
ATOM     19  C   LYS     3      47.600  17.604   5.221  1.00 55.84           C  
ATOM     20  O   LYS     3      47.654  17.245   4.049  1.00 55.14           O  
ATOM     21  CB  LYS     3      50.035  18.069   5.816  1.00 57.38           C  
ATOM     22  CG  LYS     3      51.033  17.984   6.990  1.00 58.52           C  
ATOM     23  CD  LYS     3      52.475  17.739   6.602  1.00 60.97           C  
ATOM     24  CE  LYS     3      53.207  18.959   6.163  1.00 63.65           C  
ATOM     25  NZ  LYS     3      54.708  18.695   6.249  1.00 66.08           N  
ATOM     26  N   ILE     4      46.562  18.239   5.765  1.00 53.56           N  
ATOM     27  CA  ILE     4      45.340  18.514   5.056  1.00 53.76           C  
ATOM     28  C   ILE     4      45.113  20.003   4.818  1.00 53.93           C  
ATOM     29  O   ILE     4      45.241  20.810   5.741  1.00 53.51           O  
ATOM     30  CB  ILE     4      44.105  18.015   5.905  1.00 55.30           C  
ATOM     31  CG1 ILE     4      44.159  16.496   6.186  1.00 55.04           C  
ATOM     32  CG2 ILE     4      42.821  18.376   5.214  1.00 50.36           C  
ATOM     33  CD1 ILE     4      43.204  16.037   7.255  1.00 53.20           C  
ATOM     34  N   ALA     5      44.778  20.365   3.584  1.00 52.17           N  
ATOM     35  CA  ALA     5      44.327  21.720   3.286  1.00 51.01           C  
ATOM     36  C   ALA     5      42.835  21.602   3.012  1.00 50.72           C  
ATOM     37  O   ALA     5      42.402  20.614   2.424  1.00 50.92           O  
ATOM     38  CB  ALA     5      45.041  22.295   2.077  1.00 51.38           C  
ATOM     39  N   ILE     6      42.053  22.567   3.502  1.00 49.77           N  
ATOM     40  CA  ILE     6      40.637  22.647   3.226  1.00 47.38           C  
ATOM     41  C   ILE     6      40.416  23.919   2.411  1.00 48.11           C  
ATOM     42  O   ILE     6      40.780  24.992   2.841  1.00 47.01           O  
ATOM     43  CB  ILE     6      39.782  22.717   4.472  1.00 47.03           C  
ATOM     44  CG1 ILE     6      39.970  21.496   5.353  1.00 51.49           C  
ATOM     45  CG2 ILE     6      38.311  22.816   4.072  1.00 46.79           C  
ATOM     46  CD1 ILE     6      39.234  21.618   6.720  1.00 41.91           C  
ATOM     47  N   VAL     7      39.830  23.789   1.228  1.00 47.88           N  
ATOM     48  CA  VAL     7      39.543  24.920   0.368  1.00 47.35           C  
ATOM     49  C   VAL     7      38.056  24.961   0.193  1.00 49.39           C  
ATOM     50  O   VAL     7      37.452  24.018  -0.300  1.00 50.39           O  
ATOM     51  CB  VAL     7      40.252  24.813  -0.981  1.00 49.31           C  
ATOM     52  CG1 VAL     7      39.610  25.733  -1.959  1.00 53.41           C  
ATOM     53  CG2 VAL     7      41.722  25.158  -0.807  1.00 43.12           C  
ATOM     54  N   GLY     8      37.456  26.063   0.593  1.00 50.03           N  
ATOM     55  CA  GLY     8      36.004  26.154   0.599  1.00 50.42           C  
ATOM     56  C   GLY     8      35.642  26.000   2.054  1.00 47.71           C  
ATOM     57  O   GLY     8      35.959  24.985   2.672  1.00 47.68           O  
ATOM     58  N   PHE     9      35.050  27.038   2.614  1.00 45.40           N  
ATOM     59  CA  PHE     9      34.735  27.048   4.020  1.00 44.91           C  
ATOM     60  C   PHE     9      33.347  27.619   4.296  1.00 44.43           C  
ATOM     61  O   PHE     9      33.143  28.367   5.264  1.00 44.10           O  
ATOM     62  CB  PHE     9      35.832  27.773   4.797  1.00 44.89           C  
ATOM     63  CG  PHE     9      36.080  27.213   6.187  1.00 46.74           C  
ATOM     64  CD1 PHE     9      36.321  25.852   6.367  1.00 45.28           C  
ATOM     65  CD2 PHE     9      36.171  28.053   7.293  1.00 44.41           C  
ATOM     66  CE1 PHE     9      36.605  25.329   7.622  1.00 46.75           C  
ATOM     67  CE2 PHE     9      36.465  27.547   8.553  1.00 40.55           C  
ATOM     68  CZ  PHE     9      36.696  26.169   8.720  1.00 40.87           C  
ATOM     69  N   GLY    10      32.401  27.246   3.429  1.00 43.72           N  
ATOM     70  CA  GLY    10      30.998  27.527   3.667  1.00 44.66           C  
ATOM     71  C   GLY    10      30.510  26.334   4.482  1.00 48.29           C  
ATOM     72  O   GLY    10      31.269  25.749   5.241  1.00 49.37           O  
ATOM     73  N   THR    11      29.254  25.953   4.292  1.00 50.86           N  
ATOM     74  CA  THR    11      28.627  24.852   5.019  1.00 51.81           C  
ATOM     75  C   THR    11      29.371  23.522   5.011  1.00 49.50           C  
ATOM     76  O   THR    11      29.564  22.923   6.059  1.00 51.59           O  
ATOM     77  CB  THR    11      27.191  24.637   4.490  1.00 53.76           C  
ATOM     78  OG1 THR    11      26.379  25.748   4.915  1.00 53.97           O  
ATOM     79  CG2 THR    11      26.590  23.379   5.041  1.00 57.42           C  
ATOM     80  N   VAL    12      29.827  23.082   3.851  1.00 46.51           N  
ATOM     81  CA  VAL    12      30.500  21.800   3.752  1.00 47.29           C  
ATOM     82  C   VAL    12      31.869  21.826   4.436  1.00 50.52           C  
ATOM     83  O   VAL    12      32.173  20.965   5.268  1.00 51.91           O  
ATOM     84  CB  VAL    12      30.693  21.382   2.287  1.00 49.55           C  
ATOM     85  CG1 VAL    12      31.536  20.094   2.183  1.00 40.83           C  
ATOM     86  CG2 VAL    12      29.302  21.256   1.548  1.00 42.52           C  
ATOM     87  N   GLY    13      32.683  22.820   4.075  1.00 49.44           N  
ATOM     88  CA  GLY    13      34.035  22.947   4.600  1.00 46.72           C  
ATOM     89  C   GLY    13      34.013  23.103   6.086  1.00 44.10           C  
ATOM     90  O   GLY    13      34.875  22.570   6.754  1.00 46.40           O  
ATOM     91  N   GLN    14      33.056  23.861   6.614  1.00 45.08           N  
ATOM     92  CA  GLN    14      32.964  24.028   8.061  1.00 46.74           C  
ATOM     93  C   GLN    14      32.542  22.687   8.684  1.00 47.58           C  
ATOM     94  O   GLN    14      33.015  22.328   9.756  1.00 51.45           O  
ATOM     95  CB  GLN    14      32.006  25.147   8.437  1.00 46.08           C  
ATOM     96  CG  GLN    14      32.486  26.525   8.017  1.00 47.44           C  
ATOM     97  CD  GLN    14      31.468  27.593   8.266  1.00 46.95           C  
ATOM     98  OE1 GLN    14      30.745  27.562   9.275  1.00 51.27           O  
ATOM     99  NE2 GLN    14      31.409  28.578   7.358  1.00 42.84           N  
ATOM    100  N   GLY    15      31.663  21.962   7.995  1.00 47.70           N  
ATOM    101  CA  GLY    15      31.237  20.600   8.388  1.00 46.12           C  
ATOM    102  C   GLY    15      32.400  19.637   8.510  1.00 46.71           C  
ATOM    103  O   GLY    15      32.479  18.855   9.460  1.00 49.04           O  
ATOM    104  N   VAL    16      33.327  19.707   7.564  1.00 46.53           N  
ATOM    105  CA  VAL    16      34.524  18.879   7.594  1.00 45.65           C  
ATOM    106  C   VAL    16      35.404  19.222   8.804  1.00 48.76           C  
ATOM    107  O   VAL    16      35.902  18.321   9.483  1.00 52.31           O  
ATOM    108  CB  VAL    16      35.329  19.006   6.247  1.00 47.14           C  
ATOM    109  CG1 VAL    16      36.711  18.302   6.347  1.00 42.27           C  
ATOM    110  CG2 VAL    16      34.473  18.477   5.045  1.00 42.69           C  
ATOM    111  N   ALA    17      35.568  20.510   9.108  1.00 45.69           N  
ATOM    112  CA  ALA    17      36.354  20.909  10.251  1.00 45.90           C  
ATOM    113  C   ALA    17      35.674  20.444  11.546  1.00 46.43           C  
ATOM    114  O   ALA    17      36.327  19.942  12.456  1.00 45.17           O  
ATOM    115  CB  ALA    17      36.590  22.427  10.243  1.00 43.86           C  
ATOM    116  N   GLU    18      34.365  20.612  11.648  1.00 47.89           N  
ATOM    117  CA  GLU    18      33.655  20.172  12.850  1.00 51.23           C  
ATOM    118  C   GLU    18      33.869  18.667  13.098  1.00 52.35           C  
ATOM    119  O   GLU    18      34.136  18.234  14.223  1.00 50.83           O  
ATOM    120  CB  GLU    18      32.166  20.422  12.710  1.00 48.26           C  
ATOM    121  CG  GLU    18      31.747  21.852  12.867  1.00 56.31           C  
ATOM    122  CD  GLU    18      30.335  22.104  12.327  1.00 60.70           C  
ATOM    123  OE1 GLU    18      29.628  21.141  11.892  1.00 72.28           O  
ATOM    124  OE2 GLU    18      29.938  23.278  12.321  1.00 67.63           O  
ATOM    125  N   LEU    19      33.766  17.883  12.030  1.00 52.89           N  
ATOM    126  CA  LEU    19      33.887  16.439  12.139  1.00 54.26           C  
ATOM    127  C   LEU    19      35.334  16.029  12.471  1.00 53.09           C  
ATOM    128  O   LEU    19      35.555  15.184  13.342  1.00 53.03           O  
ATOM    129  CB  LEU    19      33.392  15.798  10.846  1.00 55.45           C  
ATOM    130  CG  LEU    19      32.420  14.642  11.012  1.00 63.13           C  
ATOM    131  CD1 LEU    19      31.289  15.037  12.018  1.00 59.21           C  
ATOM    132  CD2 LEU    19      31.879  14.292   9.621  1.00 58.38           C  
ATOM    133  N   LEU    20      36.310  16.628  11.791  1.00 51.90           N  
ATOM    134  CA  LEU    20      37.719  16.374  12.075  1.00 51.88           C  
ATOM    135  C   LEU    20      38.049  16.642  13.536  1.00 53.28           C  
ATOM    136  O   LEU    20      38.901  15.943  14.115  1.00 51.85           O  
ATOM    137  CB  LEU    20      38.645  17.239  11.219  1.00 51.14           C  
ATOM    138  CG  LEU    20      38.829  16.884   9.745  1.00 53.15           C  
ATOM    139  CD1 LEU    20      39.788  17.894   9.182  1.00 43.05           C  
ATOM    140  CD2 LEU    20      39.342  15.459   9.496  1.00 48.98           C  
ATOM    141  N   ILE    21      37.402  17.666  14.118  1.00 54.64           N  
ATOM    142  CA  ILE    21      37.587  18.017  15.536  1.00 54.55           C  
ATOM    143  C   ILE    21      36.880  16.988  16.421  1.00 56.62           C  
ATOM    144  O   ILE    21      37.502  16.361  17.271  1.00 56.43           O  
ATOM    145  CB  ILE    21      37.038  19.436  15.877  1.00 55.74           C  
ATOM    146  CG1 ILE    21      37.904  20.531  15.229  1.00 53.49           C  
ATOM    147  CG2 ILE    21      37.002  19.660  17.408  1.00 51.22           C  
ATOM    148  CD1 ILE    21      37.263  21.896  15.245  1.00 51.16           C  
ATOM    149  N   ARG    22      35.578  16.846  16.215  1.00 57.54           N  
ATOM    150  CA  ARG    22      34.734  15.925  16.976  1.00 59.75           C  
ATOM    151  C   ARG    22      35.217  14.442  16.971  1.00 58.99           C  
ATOM    152  O   ARG    22      35.242  13.781  18.020  1.00 56.93           O  
ATOM    153  CB  ARG    22      33.289  16.101  16.478  1.00 59.84           C  
ATOM    154  CG  ARG    22      32.304  14.970  16.713  1.00 65.23           C  
ATOM    155  CD  ARG    22      30.893  15.451  16.313  1.00 66.81           C  
ATOM    156  NE  ARG    22      29.973  14.389  15.896  1.00 72.65           N  
ATOM    157  CZ  ARG    22      29.467  13.450  16.697  1.00 78.63           C  
ATOM    158  NH1 ARG    22      29.832  13.374  17.981  1.00 85.78           N  
ATOM    159  NH2 ARG    22      28.620  12.546  16.206  1.00 74.42           N  
ATOM    160  N   LYS    23      35.620  13.938  15.807  1.00 59.10           N  
ATOM    161  CA  LYS    23      36.115  12.562  15.660  1.00 58.67           C  
ATOM    162  C   LYS    23      37.656  12.477  15.597  1.00 56.52           C  
ATOM    163  O   LYS    23      38.190  11.561  15.005  1.00 57.54           O  
ATOM    164  CB  LYS    23      35.542  11.946  14.373  1.00 59.36           C  
ATOM    165  CG  LYS    23      33.995  11.816  14.279  1.00 61.86           C  
ATOM    166  CD  LYS    23      33.474  10.645  15.084  1.00 67.73           C  
ATOM    167  CE  LYS    23      32.043  10.279  14.717  1.00 68.93           C  
ATOM    168  NZ  LYS    23      31.620   9.080  15.497  1.00 69.41           N  
ATOM    169  N   ARG    24      38.382  13.392  16.215  1.00 56.81           N  
ATOM    170  CA  ARG    24      39.857  13.360  16.122  1.00 58.96           C  
ATOM    171  C   ARG    24      40.510  12.061  16.670  1.00 60.92           C  
ATOM    172  O   ARG    24      41.434  11.509  16.045  1.00 57.97           O  
ATOM    173  CB  ARG    24      40.481  14.576  16.825  1.00 58.10           C  
ATOM    174  CG  ARG    24      42.014  14.698  16.650  1.00 59.47           C  
ATOM    175  CD  ARG    24      42.603  15.885  17.417  1.00 56.47           C  
ATOM    176  N   GLU    25      40.052  11.584  17.831  1.00 62.93           N  
ATOM    177  CA  GLU    25      40.651  10.379  18.429  1.00 63.11           C  
ATOM    178  C   GLU    25      40.434   9.182  17.486  1.00 62.24           C  
ATOM    179  O   GLU    25      41.389   8.502  17.107  1.00 62.51           O  
ATOM    180  CB  GLU    25      40.136  10.106  19.865  1.00 63.51           C  
ATOM    181  CG  GLU    25      41.118   9.248  20.728  1.00 65.66           C  
ATOM    182  CD  GLU    25      40.757   9.175  22.216  1.00 63.61           C  
ATOM    183  N   GLU    26      39.200   8.966  17.055  1.00 61.11           N  
ATOM    184  CA  GLU    26      38.902   7.833  16.165  1.00 61.23           C  
ATOM    185  C   GLU    26      39.605   7.940  14.799  1.00 60.58           C  
ATOM    186  O   GLU    26      40.126   6.939  14.291  1.00 63.12           O  
ATOM    187  CB  GLU    26      37.391   7.521  16.058  1.00 60.40           C  
ATOM    188  CG  GLU    26      36.428   8.692  16.135  1.00 65.99           C  
ATOM    189  CD  GLU    26      36.232   9.259  17.550  1.00 69.89           C  
ATOM    190  OE1 GLU    26      37.204   9.779  18.145  1.00 73.11           O  
ATOM    191  OE2 GLU    26      35.086   9.227  18.053  1.00 74.67           O  
ATOM    192  N   ILE    27      39.670   9.140  14.232  1.00 57.22           N  
ATOM    193  CA  ILE    27      40.368   9.316  12.960  1.00 55.95           C  
ATOM    194  C   ILE    27      41.849   8.995  13.113  1.00 57.56           C  
ATOM    195  O   ILE    27      42.430   8.329  12.268  1.00 56.95           O  
ATOM    196  CB  ILE    27      40.261  10.769  12.399  1.00 55.02           C  
ATOM    197  CG1 ILE    27      38.821  11.132  12.039  1.00 49.34           C  
ATOM    198  CG2 ILE    27      41.133  10.922  11.165  1.00 50.75           C  
ATOM    199  CD1 ILE    27      38.624  12.577  11.770  1.00 52.22           C  
ATOM    200  N   GLU    28      42.465   9.479  14.184  1.00 61.32           N  
ATOM    201  CA  GLU    28      43.903   9.271  14.373  1.00 64.28           C  
ATOM    202  C   GLU    28      44.266   7.807  14.654  1.00 64.22           C  
ATOM    203  O   GLU    28      45.319   7.331  14.211  1.00 62.93           O  
ATOM    204  CB  GLU    28      44.489  10.218  15.439  1.00 64.78           C  
ATOM    205  CG  GLU    28      44.654  11.679  14.954  1.00 68.38           C  
ATOM    206  CD  GLU    28      45.433  12.572  15.939  1.00 68.30           C  
ATOM    207  OE1 GLU    28      45.742  12.102  17.058  1.00 70.55           O  
ATOM    208  OE2 GLU    28      45.730  13.744  15.587  1.00 73.13           O  
ATOM    209  N   LYS    29      43.405   7.086  15.367  1.00 64.63           N  
ATOM    210  CA  LYS    29      43.688   5.674  15.625  1.00 66.71           C  
ATOM    211  C   LYS    29      43.320   4.792  14.440  1.00 64.27           C  
ATOM    212  O   LYS    29      43.488   3.590  14.516  1.00 66.43           O  
ATOM    213  CB  LYS    29      43.073   5.170  16.949  1.00 68.44           C  
ATOM    214  CG  LYS    29      41.549   5.216  17.117  1.00 71.38           C  
ATOM    215  CD  LYS    29      41.198   5.127  18.641  1.00 71.88           C  
ATOM    216  CE  LYS    29      39.729   5.491  18.956  1.00 76.70           C  
ATOM    217  NZ  LYS    29      39.490   5.736  20.420  1.00 78.05           N  
ATOM    218  N   ALA    30      42.842   5.401  13.350  1.00 62.35           N  
ATOM    219  CA  ALA    30      42.498   4.704  12.117  1.00 59.58           C  
ATOM    220  C   ALA    30      43.511   4.999  10.990  1.00 59.19           C  
ATOM    221  O   ALA    30      43.926   4.084  10.282  1.00 58.82           O  
ATOM    222  CB  ALA    30      41.104   5.089  11.679  1.00 58.95           C  
ATOM    223  N   ILE    31      43.905   6.264  10.824  1.00 58.50           N  
ATOM    224  CA  ILE    31      44.836   6.662   9.747  1.00 58.25           C  
ATOM    225  C   ILE    31      46.124   7.324  10.230  1.00 56.93           C  
ATOM    226  O   ILE    31      46.986   7.654   9.415  1.00 56.58           O  
ATOM    227  CB  ILE    31      44.148   7.616   8.698  1.00 60.03           C  
ATOM    228  CG1 ILE    31      43.729   8.952   9.327  1.00 63.44           C  
ATOM    229  CG2 ILE    31      42.920   6.948   8.083  1.00 59.44           C  
ATOM    230  CD1 ILE    31      43.310  10.005   8.313  1.00 57.81           C  
ATOM    231  N   GLY    32      46.265   7.504  11.544  1.00 56.22           N  
ATOM    232  CA  GLY    32      47.450   8.154  12.123  1.00 56.26           C  
ATOM    233  C   GLY    32      47.259   9.639  12.384  1.00 56.15           C  
ATOM    234  O   GLY    32      46.173  10.193  12.194  1.00 54.12           O  
ATOM    235  N   GLU    33      48.332  10.296  12.799  1.00 57.20           N  
ATOM    236  CA  GLU    33      48.274  11.730  13.117  1.00 57.41           C  
ATOM    237  C   GLU    33      47.980  12.615  11.898  1.00 56.42           C  
ATOM    238  O   GLU    33      48.489  12.381  10.791  1.00 55.32           O  
ATOM    239  CB  GLU    33      49.571  12.202  13.797  1.00 54.88           C  
ATOM    240  N   PHE    34      47.153  13.635  12.122  1.00 56.05           N  
ATOM    241  CA  PHE    34      46.853  14.621  11.082  1.00 55.66           C  
ATOM    242  C   PHE    34      46.741  16.029  11.657  1.00 54.59           C  
ATOM    243  O   PHE    34      46.352  16.223  12.810  1.00 52.19           O  
ATOM    244  CB  PHE    34      45.539  14.293  10.356  1.00 53.22           C  
ATOM    245  CG  PHE    34      44.307  14.535  11.191  1.00 51.30           C  
ATOM    246  CD1 PHE    34      43.696  15.778  11.207  1.00 52.89           C  
ATOM    247  CD2 PHE    34      43.764  13.525  11.972  1.00 52.61           C  
ATOM    248  CE1 PHE    34      42.561  16.004  11.992  1.00 56.64           C  
ATOM    249  CE2 PHE    34      42.622  13.754  12.749  1.00 52.83           C  
ATOM    250  CZ  PHE    34      42.030  14.997  12.759  1.00 49.58           C  
ATOM    251  N   LYS    35      47.048  16.999  10.806  1.00 55.52           N  
ATOM    252  CA  LYS    35      46.903  18.402  11.119  1.00 55.01           C  
ATOM    253  C   LYS    35      46.397  19.124   9.852  1.00 53.92           C  
ATOM    254  O   LYS    35      46.825  18.822   8.738  1.00 52.95           O  
ATOM    255  CB  LYS    35      48.248  18.998  11.581  1.00 55.35           C  
ATOM    256  N   VAL    36      45.463  20.052  10.021  1.00 53.85           N  
ATOM    257  CA  VAL    36      45.023  20.896   8.912  1.00 51.19           C  
ATOM    258  C   VAL    36      46.012  22.068   8.889  1.00 50.76           C  
ATOM    259  O   VAL    36      46.081  22.869   9.825  1.00 51.72           O  
ATOM    260  CB  VAL    36      43.595  21.377   9.116  1.00 51.26           C  
ATOM    261  CG1 VAL    36      43.214  22.449   8.086  1.00 50.58           C  
ATOM    262  CG2 VAL    36      42.643  20.177   9.107  1.00 51.69           C  
ATOM    263  N   THR    37      46.798  22.142   7.825  1.00 49.63           N  
ATOM    264  CA  THR    37      47.828  23.154   7.685  1.00 48.79           C  
ATOM    265  C   THR    37      47.379  24.424   6.954  1.00 49.33           C  
ATOM    266  O   THR    37      48.097  25.425   6.971  1.00 48.55           O  
ATOM    267  CB  THR    37      49.039  22.547   6.963  1.00 51.11           C  
ATOM    268  OG1 THR    37      48.633  22.053   5.675  1.00 49.84           O  
ATOM    269  CG2 THR    37      49.661  21.384   7.816  1.00 47.18           C  
ATOM    270  N   ALA    38      46.211  24.385   6.303  1.00 48.85           N  
ATOM    271  CA  ALA    38      45.661  25.561   5.615  1.00 48.33           C  
ATOM    272  C   ALA    38      44.151  25.472   5.443  1.00 47.20           C  
ATOM    273  O   ALA    38      43.596  24.393   5.295  1.00 47.14           O  
ATOM    274  CB  ALA    38      46.319  25.748   4.256  1.00 48.10           C  
ATOM    275  N   VAL    39      43.474  26.614   5.516  1.00 46.50           N  
ATOM    276  CA  VAL    39      42.029  26.679   5.235  1.00 41.88           C  
ATOM    277  C   VAL    39      41.837  27.944   4.433  1.00 42.19           C  
ATOM    278  O   VAL    39      42.487  28.952   4.705  1.00 42.21           O  
ATOM    279  CB  VAL    39      41.134  26.697   6.499  1.00 41.10           C  
ATOM    280  CG1 VAL    39      39.640  26.750   6.099  1.00 34.79           C  
ATOM    281  CG2 VAL    39      41.379  25.436   7.334  1.00 37.90           C  
ATOM    282  N   ALA    40      40.965  27.891   3.438  1.00 42.83           N  
ATOM    283  CA  ALA    40      40.698  29.054   2.605  1.00 43.95           C  
ATOM    284  C   ALA    40      39.229  29.118   2.235  1.00 44.80           C  
ATOM    285  O   ALA    40      38.595  28.097   2.022  1.00 45.76           O  
ATOM    286  CB  ALA    40      41.583  29.062   1.350  1.00 41.09           C  
ATOM    287  N   ASP    41      38.678  30.332   2.260  1.00 47.12           N  
ATOM    288  CA  ASP    41      37.309  30.548   1.849  1.00 48.13           C  
ATOM    289  C   ASP    41      37.362  31.268   0.495  1.00 48.80           C  
ATOM    290  O   ASP    41      38.365  31.177  -0.211  1.00 46.41           O  
ATOM    291  CB  ASP    41      36.437  31.219   2.935  1.00 47.62           C  
ATOM    292  CG  ASP    41      36.796  32.655   3.226  1.00 49.98           C  
ATOM    293  OD1 ASP    41      37.592  33.291   2.504  1.00 58.19           O  
ATOM    294  OD2 ASP    41      36.230  33.163   4.208  1.00 51.58           O  
ATOM    295  N   SER    42      36.302  31.967   0.120  1.00 49.95           N  
ATOM    296  CA  SER    42      36.264  32.567  -1.204  1.00 52.64           C  
ATOM    297  C   SER    42      37.116  33.819  -1.333  1.00 52.63           C  
ATOM    298  O   SER    42      37.251  34.311  -2.423  1.00 55.48           O  
ATOM    299  CB  SER    42      34.820  32.904  -1.582  1.00 52.96           C  
ATOM    300  OG  SER    42      34.336  34.013  -0.823  1.00 58.23           O  
ATOM    301  N   LYS    43      37.665  34.347  -0.241  1.00 51.92           N  
ATOM    302  CA  LYS    43      38.480  35.552  -0.305  1.00 52.93           C  
ATOM    303  C   LYS    43      39.599  35.700   0.718  1.00 47.85           C  
ATOM    304  O   LYS    43      40.298  36.685   0.689  1.00 45.16           O  
ATOM    305  CB  LYS    43      37.585  36.781  -0.203  1.00 55.82           C  
ATOM    306  CG  LYS    43      36.657  36.790   0.999  1.00 60.82           C  
ATOM    307  CD  LYS    43      35.892  38.100   1.051  1.00 61.10           C  
ATOM    308  CE  LYS    43      34.742  38.052   2.059  1.00 71.03           C  
ATOM    309  NZ  LYS    43      34.194  39.422   2.317  1.00 69.35           N  
ATOM    310  N   SER    44      39.796  34.718   1.583  1.00 47.19           N  
ATOM    311  CA  SER    44      40.817  34.796   2.632  1.00 44.50           C  
ATOM    312  C   SER    44      41.304  33.408   3.011  1.00 43.16           C  
ATOM    313  O   SER    44      40.816  32.381   2.497  1.00 43.03           O  
ATOM    314  CB  SER    44      40.216  35.482   3.859  1.00 43.90           C  
ATOM    315  OG  SER    44      39.006  34.830   4.247  1.00 40.74           O  
ATOM    316  N   SER    45      42.257  33.361   3.929  1.00 43.34           N  
ATOM    317  CA  SER    45      42.822  32.086   4.339  1.00 44.16           C  
ATOM    318  C   SER    45      43.499  32.135   5.691  1.00 43.92           C  
ATOM    319  O   SER    45      43.653  33.190   6.280  1.00 45.20           O  
ATOM    320  CB  SER    45      43.819  31.603   3.276  1.00 43.89           C  
ATOM    321  OG  SER    45      44.824  32.582   3.070  1.00 44.61           O  
ATOM    322  N   ILE    46      43.822  30.958   6.207  1.00 44.82           N  
ATOM    323  CA  ILE    46      44.567  30.829   7.448  1.00 45.74           C  
ATOM    324  C   ILE    46      45.498  29.626   7.232  1.00 48.74           C  
ATOM    325  O   ILE    46      45.074  28.574   6.760  1.00 48.63           O  
ATOM    326  CB  ILE    46      43.651  30.702   8.698  1.00 45.65           C  
ATOM    327  CG1 ILE    46      44.485  30.784   9.991  1.00 46.96           C  
ATOM    328  CG2 ILE    46      42.820  29.444   8.634  1.00 39.08           C  
ATOM    329  CD1 ILE    46      43.657  30.960  11.292  1.00 44.17           C  
ATOM    330  N   SER    47      46.772  29.825   7.533  1.00 51.76           N  
ATOM    331  CA  SER    47      47.810  28.828   7.336  1.00 55.63           C  
ATOM    332  C   SER    47      48.871  28.999   8.418  1.00 59.36           C  
ATOM    333  O   SER    47      48.792  29.920   9.232  1.00 59.41           O  
ATOM    334  CB  SER    47      48.405  28.970   5.934  1.00 55.81           C  
ATOM    335  OG  SER    47      48.695  30.327   5.660  1.00 60.76           O  
ATOM    336  N   GLY    48      49.858  28.113   8.438  1.00 62.08           N  
ATOM    337  CA  GLY    48      50.859  28.117   9.496  1.00 64.35           C  
ATOM    338  C   GLY    48      50.278  27.283  10.621  1.00 66.48           C  
ATOM    339  O   GLY    48      49.457  26.385  10.379  1.00 68.53           O  
ATOM    340  N   ASP    49      50.707  27.547  11.849  1.00 69.50           N  
ATOM    341  CA  ASP    49      50.151  26.823  12.986  1.00 69.13           C  
ATOM    342  C   ASP    49      48.987  27.680  13.482  1.00 66.46           C  
ATOM    343  O   ASP    49      49.128  28.880  13.721  1.00 64.46           O  
ATOM    344  CB  ASP    49      51.192  26.564  14.094  1.00 71.09           C  
ATOM    345  CG  ASP    49      50.708  25.533  15.149  1.00 73.05           C  
ATOM    346  OD1 ASP    49      49.573  25.006  15.036  1.00 77.90           O  
ATOM    347  OD2 ASP    49      51.474  25.243  16.099  1.00 84.77           O  
ATOM    348  N   PHE    50      47.829  27.042  13.569  1.00 63.84           N  
ATOM    349  CA  PHE    50      46.599  27.667  14.005  1.00 61.11           C  
ATOM    350  C   PHE    50      45.774  26.477  14.406  1.00 61.21           C  
ATOM    351  O   PHE    50      46.136  25.360  14.054  1.00 65.03           O  
ATOM    352  CB  PHE    50      45.944  28.441  12.845  1.00 60.61           C  
ATOM    353  CG  PHE    50      45.450  27.562  11.718  1.00 56.00           C  
ATOM    354  CD1 PHE    50      46.296  27.183  10.687  1.00 57.36           C  
ATOM    355  CD2 PHE    50      44.134  27.104  11.698  1.00 60.04           C  
ATOM    356  CE1 PHE    50      45.838  26.367   9.652  1.00 54.45           C  
ATOM    357  CE2 PHE    50      43.683  26.282  10.679  1.00 53.05           C  
ATOM    358  CZ  PHE    50      44.542  25.922   9.658  1.00 54.95           C  
ATOM    359  N   SER    51      44.685  26.657  15.137  1.00 61.52           N  
ATOM    360  CA  SER    51      43.842  25.505  15.454  1.00 61.50           C  
ATOM    361  C   SER    51      42.601  25.509  14.543  1.00 62.12           C  
ATOM    362  O   SER    51      42.165  26.569  14.080  1.00 62.67           O  
ATOM    363  CB  SER    51      43.459  25.482  16.943  1.00 61.95           C  
ATOM    364  OG  SER    51      42.527  26.486  17.308  1.00 60.44           O  
ATOM    365  N   LEU    52      42.052  24.331  14.263  1.00 60.09           N  
ATOM    366  CA  LEU    52      40.833  24.252  13.472  1.00 60.05           C  
ATOM    367  C   LEU    52      39.696  24.966  14.153  1.00 59.93           C  
ATOM    368  O   LEU    52      38.865  25.578  13.482  1.00 60.87           O  
ATOM    369  CB  LEU    52      40.377  22.809  13.213  1.00 61.30           C  
ATOM    370  CG  LEU    52      40.904  22.097  11.981  1.00 58.66           C  
ATOM    371  CD1 LEU    52      40.284  20.695  11.921  1.00 53.94           C  
ATOM    372  CD2 LEU    52      40.584  22.906  10.726  1.00 52.52           C  
ATOM    373  N   VAL    53      39.638  24.874  15.475  1.00 58.86           N  
ATOM    374  CA  VAL    53      38.578  25.528  16.212  1.00 59.32           C  
ATOM    375  C   VAL    53      38.797  27.061  16.134  1.00 59.34           C  
ATOM    376  O   VAL    53      37.839  27.826  16.222  1.00 58.98           O  
ATOM    377  CB  VAL    53      38.498  25.009  17.680  1.00 60.99           C  
ATOM    378  CG1 VAL    53      39.747  25.416  18.481  1.00 59.44           C  
ATOM    379  CG2 VAL    53      37.251  25.532  18.356  1.00 63.08           C  
ATOM    380  N   GLU    54      40.053  27.491  15.970  1.00 58.08           N  
ATOM    381  CA  GLU    54      40.382  28.916  15.783  1.00 58.11           C  
ATOM    382  C   GLU    54      39.791  29.372  14.453  1.00 54.78           C  
ATOM    383  O   GLU    54      39.060  30.351  14.393  1.00 51.96           O  
ATOM    384  CB  GLU    54      41.911  29.142  15.808  1.00 57.95           C  
ATOM    385  CG  GLU    54      42.433  30.512  15.286  1.00 60.54           C  
ATOM    386  CD  GLU    54      43.974  30.637  15.312  1.00 63.57           C  
ATOM    387  OE1 GLU    54      44.645  29.639  15.675  1.00 69.48           O  
ATOM    388  OE2 GLU    54      44.511  31.734  14.978  1.00 64.98           O  
ATOM    389  N   ALA    55      40.106  28.628  13.397  1.00 52.28           N  
ATOM    390  CA  ALA    55      39.628  28.928  12.057  1.00 50.48           C  
ATOM    391  C   ALA    55      38.105  29.014  12.006  1.00 50.08           C  
ATOM    392  O   ALA    55      37.523  29.899  11.369  1.00 48.20           O  
ATOM    393  CB  ALA    55      40.128  27.854  11.084  1.00 47.73           C  
ATOM    394  N   LEU    56      37.479  28.089  12.715  1.00 50.68           N  
ATOM    395  CA  LEU    56      36.040  27.925  12.734  1.00 48.42           C  
ATOM    396  C   LEU    56      35.405  29.084  13.485  1.00 48.89           C  
ATOM    397  O   LEU    56      34.422  29.675  13.027  1.00 49.34           O  
ATOM    398  CB  LEU    56      35.749  26.567  13.386  1.00 49.56           C  
ATOM    399  CG  LEU    56      34.499  25.721  13.144  1.00 52.04           C  
ATOM    400  CD1 LEU    56      34.203  25.561  11.685  1.00 38.31           C  
ATOM    401  CD2 LEU    56      34.698  24.344  13.791  1.00 47.26           C  
ATOM    402  N   ARG    57      35.973  29.419  14.637  1.00 46.37           N  
ATOM    403  CA  ARG    57      35.474  30.521  15.430  1.00 48.89           C  
ATOM    404  C   ARG    57      35.549  31.828  14.619  1.00 46.79           C  
ATOM    405  O   ARG    57      34.608  32.605  14.544  1.00 46.32           O  
ATOM    406  CB  ARG    57      36.298  30.654  16.742  1.00 51.31           C  
ATOM    407  CG  ARG    57      36.110  29.490  17.783  1.00 56.80           C  
ATOM    408  CD  ARG    57      37.030  29.595  19.028  1.00 49.52           C  
ATOM    409  N   MET    58      36.694  32.040  14.000  1.00 45.43           N  
ATOM    410  CA  MET    58      36.952  33.231  13.205  1.00 47.00           C  
ATOM    411  C   MET    58      35.968  33.370  12.026  1.00 44.58           C  
ATOM    412  O   MET    58      35.461  34.448  11.784  1.00 44.79           O  
ATOM    413  CB  MET    58      38.398  33.160  12.703  1.00 46.90           C  
ATOM    414  CG  MET    58      38.910  34.397  12.064  1.00 47.83           C  
ATOM    415  SD  MET    58      40.713  34.060  11.481  0.75 49.26          SE  
ATOM    416  CE  MET    58      41.667  34.170  13.280  1.00 37.49           C  
ATOM    417  N   LYS    59      35.692  32.285  11.313  1.00 45.02           N  
ATOM    418  CA  LYS    59      34.772  32.318  10.170  1.00 44.70           C  
ATOM    419  C   LYS    59      33.356  32.681  10.611  1.00 48.20           C  
ATOM    420  O   LYS    59      32.692  33.542  10.016  1.00 49.01           O  
ATOM    421  CB  LYS    59      34.811  30.975   9.455  1.00 43.78           C  
ATOM    422  CG  LYS    59      33.941  30.862   8.201  1.00 46.14           C  
ATOM    423  CD  LYS    59      34.236  31.951   7.144  1.00 42.99           C  
ATOM    424  CE  LYS    59      33.424  31.659   5.852  1.00 41.18           C  
ATOM    425  NZ  LYS    59      33.477  32.781   4.910  1.00 42.03           N  
ATOM    426  N   ARG    60      32.914  32.073  11.702  1.00 51.20           N  
ATOM    427  CA  ARG    60      31.569  32.311  12.219  1.00 53.26           C  
ATOM    428  C   ARG    60      31.456  33.712  12.766  1.00 50.92           C  
ATOM    429  O   ARG    60      30.478  34.414  12.503  1.00 49.06           O  
ATOM    430  CB  ARG    60      31.236  31.290  13.306  1.00 54.29           C  
ATOM    431  CG  ARG    60      31.258  29.845  12.781  1.00 60.02           C  
ATOM    432  CD  ARG    60      31.161  28.754  13.885  1.00 61.47           C  
ATOM    433  NE  ARG    60      31.138  27.446  13.233  1.00 72.90           N  
ATOM    434  CZ  ARG    60      30.086  26.940  12.579  1.00 79.62           C  
ATOM    435  NH1 ARG    60      28.925  27.591  12.512  1.00 89.86           N  
ATOM    436  NH2 ARG    60      30.186  25.765  11.989  1.00 71.49           N  
ATOM    437  N   GLU    61      32.479  34.114  13.518  1.00 52.25           N  
ATOM    438  CA  GLU    61      32.532  35.431  14.158  1.00 50.35           C  
ATOM    439  C   GLU    61      32.672  36.615  13.194  1.00 47.88           C  
ATOM    440  O   GLU    61      32.191  37.705  13.494  1.00 49.25           O  
ATOM    441  CB  GLU    61      33.737  35.503  15.129  1.00 51.84           C  
ATOM    442  CG  GLU    61      33.666  34.671  16.443  1.00 59.20           C  
ATOM    443  CD  GLU    61      35.045  34.509  17.193  1.00 59.29           C  
ATOM    444  OE1 GLU    61      36.086  35.085  16.766  1.00 61.69           O  
ATOM    445  OE2 GLU    61      35.076  33.780  18.225  1.00 72.24           O  
ATOM    446  N   THR    62      33.389  36.428  12.085  1.00 42.88           N  
ATOM    447  CA  THR    62      33.716  37.549  11.186  1.00 43.33           C  
ATOM    448  C   THR    62      33.312  37.384   9.719  1.00 40.36           C  
ATOM    449  O   THR    62      33.360  38.340   8.954  1.00 42.65           O  
ATOM    450  CB  THR    62      35.255  37.824  11.195  1.00 40.65           C  
ATOM    451  OG1 THR    62      35.926  36.769  10.495  1.00 35.15           O  
ATOM    452  CG2 THR    62      35.833  37.990  12.648  1.00 34.73           C  
ATOM    453  N   GLY    63      32.923  36.184   9.336  1.00 40.64           N  
ATOM    454  CA  GLY    63      32.560  35.872   7.952  1.00 41.41           C  
ATOM    455  C   GLY    63      33.742  35.592   7.044  1.00 43.27           C  
ATOM    456  O   GLY    63      33.561  35.358   5.845  1.00 45.21           O  
ATOM    457  N   MET    64      34.953  35.619   7.603  1.00 44.51           N  
ATOM    458  CA  MET    64      36.175  35.382   6.839  1.00 45.50           C  
ATOM    459  C   MET    64      37.294  34.864   7.728  1.00 44.26           C  
ATOM    460  O   MET    64      37.122  34.693   8.941  1.00 41.59           O  
ATOM    461  CB  MET    64      36.605  36.663   6.121  1.00 45.04           C  
ATOM    462  CG  MET    64      36.613  37.860   6.986  1.00 47.01           C  
ATOM    463  SD  MET    64      37.029  39.482   6.004  0.75 47.90          SE  
ATOM    464  CE  MET    64      38.901  38.862   5.439  1.00 59.66           C  
ATOM    465  N   LEU    65      38.448  34.626   7.115  1.00 44.77           N  
ATOM    466  CA  LEU    65      39.608  34.125   7.841  1.00 43.33           C  
ATOM    467  C   LEU    65      40.633  35.227   8.089  1.00 42.87           C  
ATOM    468  O   LEU    65      40.295  36.395   8.095  1.00 44.04           O  
ATOM    469  CB  LEU    65      40.167  32.869   7.154  1.00 42.69           C  
ATOM    470  CG  LEU    65      39.144  31.724   7.110  1.00 44.17           C  
ATOM    471  CD1 LEU    65      39.490  30.693   6.027  1.00 35.33           C  
ATOM    472  CD2 LEU    65      38.968  31.084   8.505  1.00 39.69           C  
ATOM    473  N   ARG    66      41.884  34.845   8.293  1.00 43.65           N  
ATOM    474  CA  ARG    66      42.884  35.734   8.801  1.00 44.40           C  
ATOM    475  C   ARG    66      43.758  36.465   7.784  1.00 45.38           C  
ATOM    476  O   ARG    66      44.102  37.626   7.979  1.00 44.47           O  
ATOM    477  CB  ARG    66      43.789  34.898   9.713  1.00 43.61           C  
ATOM    478  CG  ARG    66      44.744  35.697  10.608  1.00 48.49           C  
ATOM    479  CD  ARG    66      45.695  34.730  11.281  1.00 47.22           C  
ATOM    480  NE  ARG    66      46.594  34.150  10.295  1.00 45.47           N  
ATOM    481  CZ  ARG    66      47.396  33.103  10.502  1.00 50.34           C  
ATOM    482  NH1 ARG    66      47.450  32.484  11.683  1.00 48.62           N  
ATOM    483  NH2 ARG    66      48.155  32.672   9.502  1.00 48.61           N  
ATOM    484  N   ASP    67      44.128  35.766   6.730  1.00 46.81           N  
ATOM    485  CA  ASP    67      45.040  36.281   5.741  1.00 47.75           C  
ATOM    486  C   ASP    67      44.333  36.578   4.453  1.00 49.32           C  
ATOM    487  O   ASP    67      43.305  36.007   4.133  1.00 47.49           O  
ATOM    488  CB  ASP    67      46.117  35.235   5.482  1.00 48.48           C  
ATOM    489  CG  ASP    67      46.804  34.797   6.752  1.00 47.99           C  
ATOM    490  OD1 ASP    67      46.953  35.636   7.668  1.00 44.98           O  
ATOM    491  OD2 ASP    67      47.179  33.620   6.840  1.00 48.00           O  
ATOM    492  N   ASP    68      44.976  37.423   3.679  1.00 51.15           N  
ATOM    493  CA  ASP    68      44.436  37.930   2.447  1.00 52.86           C  
ATOM    494  C   ASP    68      44.663  36.946   1.300  1.00 51.66           C  
ATOM    495  O   ASP    68      43.905  36.955   0.329  1.00 52.78           O  
ATOM    496  CB  ASP    68      45.090  39.285   2.168  1.00 55.83           C  
ATOM    497  CG  ASP    68      44.094  40.319   1.731  1.00 63.82           C  
ATOM    498  OD1 ASP    68      43.435  40.113   0.679  1.00 74.55           O  
ATOM    499  OD2 ASP    68      43.973  41.326   2.465  1.00 63.73           O  
ATOM    500  N   ALA    69      45.687  36.101   1.432  1.00 48.53           N  
ATOM    501  CA  ALA    69      45.999  35.066   0.444  1.00 48.57           C  
ATOM    502  C   ALA    69      44.772  34.204   0.079  1.00 48.52           C  
ATOM    503  O   ALA    69      44.108  33.618   0.943  1.00 48.23           O  
ATOM    504  CB  ALA    69      47.113  34.187   0.943  1.00 48.89           C  
ATOM    505  N   LYS    70      44.518  34.119  -1.226  1.00 47.87           N  
ATOM    506  CA  LYS    70      43.378  33.426  -1.768  1.00 47.57           C  
ATOM    507  C   LYS    70      43.628  31.917  -1.869  1.00 48.60           C  
ATOM    508  O   LYS    70      44.767  31.449  -1.745  1.00 49.21           O  
ATOM    509  CB  LYS    70      43.005  34.016  -3.129  1.00 44.83           C  
ATOM    510  CG  LYS    70      42.774  35.545  -3.104  1.00 49.98           C  
ATOM    511  CD  LYS    70      41.537  35.965  -2.297  1.00 48.83           C  
ATOM    512  CE  LYS    70      41.353  37.514  -2.246  1.00 44.39           C  
ATOM    513  NZ  LYS    70      42.399  38.226  -1.427  1.00 45.46           N  
ATOM    514  N   ALA    71      42.526  31.188  -2.046  1.00 46.47           N  
ATOM    515  CA  ALA    71      42.513  29.729  -2.160  1.00 48.77           C  
ATOM    516  C   ALA    71      43.544  29.228  -3.176  1.00 48.96           C  
ATOM    517  O   ALA    71      44.238  28.233  -2.930  1.00 48.08           O  
ATOM    518  CB  ALA    71      41.104  29.246  -2.554  1.00 45.13           C  
ATOM    519  N   ILE    72      43.668  29.938  -4.298  1.00 49.21           N  
ATOM    520  CA  ILE    72      44.594  29.502  -5.340  1.00 49.29           C  
ATOM    521  C   ILE    72      46.038  29.493  -4.796  1.00 49.91           C  
ATOM    522  O   ILE    72      46.765  28.530  -5.020  1.00 49.57           O  
ATOM    523  CB  ILE    72      44.416  30.310  -6.659  1.00 50.44           C  
ATOM    524  CG1 ILE    72      45.048  29.560  -7.851  1.00 54.22           C  
ATOM    525  CG2 ILE    72      44.959  31.731  -6.521  1.00 43.02           C  
ATOM    526  CD1 ILE    72      44.386  28.211  -8.196  1.00 52.07           C  
ATOM    527  N   GLU    73      46.424  30.516  -4.025  1.00 48.92           N  
ATOM    528  CA  GLU    73      47.773  30.575  -3.422  1.00 48.38           C  
ATOM    529  C   GLU    73      47.994  29.436  -2.412  1.00 49.08           C  
ATOM    530  O   GLU    73      49.084  28.844  -2.353  1.00 51.64           O  
ATOM    531  CB  GLU    73      48.056  31.960  -2.789  1.00 44.72           C  
ATOM    532  N   VAL    74      46.982  29.133  -1.606  1.00 48.95           N  
ATOM    533  CA  VAL    74      47.082  28.009  -0.667  1.00 48.44           C  
ATOM    534  C   VAL    74      47.245  26.694  -1.431  1.00 49.47           C  
ATOM    535  O   VAL    74      48.026  25.811  -1.033  1.00 46.63           O  
ATOM    536  CB  VAL    74      45.847  27.929   0.247  1.00 48.50           C  
ATOM    537  CG1 VAL    74      45.675  26.519   0.870  1.00 42.05           C  
ATOM    538  CG2 VAL    74      45.918  29.060   1.306  1.00 50.41           C  
ATOM    539  N   VAL    75      46.495  26.553  -2.523  1.00 50.49           N  
ATOM    540  CA  VAL    75      46.587  25.340  -3.336  1.00 50.30           C  
ATOM    541  C   VAL    75      47.957  25.175  -3.988  1.00 51.72           C  
ATOM    542  O   VAL    75      48.516  24.091  -3.968  1.00 49.57           O  
ATOM    543  CB  VAL    75      45.533  25.289  -4.436  1.00 50.92           C  
ATOM    544  CG1 VAL    75      45.860  24.141  -5.398  1.00 48.68           C  
ATOM    545  CG2 VAL    75      44.119  25.153  -3.812  1.00 47.79           C  
ATOM    546  N   ARG    76      48.495  26.253  -4.550  1.00 54.91           N  
ATOM    547  CA  ARG    76      49.776  26.162  -5.238  1.00 57.13           C  
ATOM    548  C   ARG    76      50.999  26.330  -4.351  1.00 55.63           C  
ATOM    549  O   ARG    76      52.078  25.993  -4.788  1.00 56.56           O  
ATOM    550  CB  ARG    76      49.841  27.044  -6.514  1.00 57.62           C  
ATOM    551  CG  ARG    76      49.219  28.414  -6.426  1.00 62.82           C  
ATOM    552  CD  ARG    76      49.329  29.243  -7.718  1.00 61.44           C  
ATOM    553  NE  ARG    76      48.558  28.687  -8.827  1.00 68.70           N  
ATOM    554  CZ  ARG    76      48.114  29.388  -9.876  1.00 72.60           C  
ATOM    555  NH1 ARG    76      48.301  30.707  -9.949  1.00 71.64           N  
ATOM    556  NH2 ARG    76      47.428  28.771 -10.839  1.00 74.37           N  
ATOM    557  N   SER    77      50.841  26.766  -3.102  1.00 56.55           N  
ATOM    558  CA  SER    77      52.011  26.999  -2.230  1.00 56.57           C  
ATOM    559  C   SER    77      51.990  26.386  -0.839  1.00 56.05           C  
ATOM    560  O   SER    77      53.052  26.152  -0.275  1.00 58.37           O  
ATOM    561  CB  SER    77      52.242  28.499  -2.049  1.00 55.87           C  
ATOM    562  OG  SER    77      52.404  29.148  -3.298  1.00 60.87           O  
ATOM    563  N   ALA    78      50.816  26.152  -0.264  1.00 53.72           N  
ATOM    564  CA  ALA    78      50.739  25.637   1.102  1.00 51.81           C  
ATOM    565  C   ALA    78      51.302  24.229   1.200  1.00 52.20           C  
ATOM    566  O   ALA    78      51.362  23.489   0.203  1.00 49.94           O  
ATOM    567  CB  ALA    78      49.297  25.683   1.616  1.00 50.36           C  
ATOM    568  N   ASP    79      51.708  23.862   2.413  1.00 54.01           N  
ATOM    569  CA  ASP    79      52.279  22.537   2.670  1.00 55.96           C  
ATOM    570  C   ASP    79      51.217  21.544   3.152  1.00 55.20           C  
ATOM    571  O   ASP    79      50.816  21.537   4.330  1.00 57.13           O  
ATOM    572  CB  ASP    79      53.413  22.632   3.691  1.00 57.64           C  
ATOM    573  CG  ASP    79      54.084  21.292   3.941  1.00 63.21           C  
ATOM    574  OD1 ASP    79      53.813  20.320   3.183  1.00 72.09           O  
ATOM    575  OD2 ASP    79      54.875  21.211   4.904  1.00 70.17           O  
ATOM    576  N   TYR    80      50.770  20.704   2.226  1.00 52.70           N  
ATOM    577  CA  TYR    80      49.740  19.707   2.511  1.00 50.65           C  
ATOM    578  C   TYR    80      49.966  18.467   1.647  1.00 50.59           C  
ATOM    579  O   TYR    80      50.675  18.507   0.631  1.00 48.13           O  
ATOM    580  CB  TYR    80      48.336  20.285   2.275  1.00 49.01           C  
ATOM    581  CG  TYR    80      48.087  20.691   0.838  1.00 48.83           C  
ATOM    582  CD1 TYR    80      48.447  21.950   0.376  1.00 46.01           C  
ATOM    583  CD2 TYR    80      47.512  19.806  -0.066  1.00 50.85           C  
ATOM    584  CE1 TYR    80      48.244  22.306  -0.956  1.00 48.56           C  
ATOM    585  CE2 TYR    80      47.298  20.160  -1.389  1.00 49.09           C  
ATOM    586  CZ  TYR    80      47.664  21.405  -1.827  1.00 45.04           C  
ATOM    587  OH  TYR    80      47.448  21.760  -3.136  1.00 46.31           O  
ATOM    588  N   ASP    81      49.359  17.372   2.094  1.00 50.85           N  
ATOM    589  CA  ASP    81      49.426  16.077   1.445  1.00 50.80           C  
ATOM    590  C   ASP    81      48.141  15.778   0.682  1.00 49.39           C  
ATOM    591  O   ASP    81      48.193  15.248  -0.423  1.00 48.44           O  
ATOM    592  CB  ASP    81      49.680  15.009   2.504  1.00 51.60           C  
ATOM    593  CG  ASP    81      51.024  15.184   3.165  1.00 52.29           C  
ATOM    594  OD1 ASP    81      51.983  15.436   2.413  1.00 50.80           O  
ATOM    595  OD2 ASP    81      51.114  15.094   4.405  1.00 52.87           O  
ATOM    596  N   VAL    82      47.005  16.131   1.280  1.00 48.04           N  
ATOM    597  CA  VAL    82      45.679  15.929   0.673  1.00 49.37           C  
ATOM    598  C   VAL    82      44.902  17.249   0.701  1.00 51.01           C  
ATOM    599  O   VAL    82      44.898  17.942   1.713  1.00 49.19           O  
ATOM    600  CB  VAL    82      44.861  14.815   1.432  1.00 50.01           C  
ATOM    601  CG1 VAL    82      44.888  15.036   2.950  1.00 45.54           C  
ATOM    602  CG2 VAL    82      43.413  14.695   0.911  1.00 45.57           C  
ATOM    603  N   LEU    83      44.281  17.601  -0.431  1.00 51.29           N  
ATOM    604  CA  LEU    83      43.392  18.753  -0.515  1.00 49.17           C  
ATOM    605  C   LEU    83      41.920  18.317  -0.411  1.00 49.00           C  
ATOM    606  O   LEU    83      41.450  17.460  -1.165  1.00 48.75           O  
ATOM    607  CB  LEU    83      43.555  19.471  -1.847  1.00 46.98           C  
ATOM    608  CG  LEU    83      42.636  20.677  -2.069  1.00 48.83           C  
ATOM    609  CD1 LEU    83      42.959  21.779  -1.048  1.00 42.31           C  
ATOM    610  CD2 LEU    83      42.764  21.161  -3.508  1.00 42.84           C  
ATOM    611  N   ILE    84      41.197  18.934   0.516  1.00 48.92           N  
ATOM    612  CA  ILE    84      39.746  18.767   0.619  1.00 46.97           C  
ATOM    613  C   ILE    84      39.160  19.989  -0.089  1.00 45.43           C  
ATOM    614  O   ILE    84      39.314  21.113   0.354  1.00 44.83           O  
ATOM    615  CB  ILE    84      39.276  18.666   2.071  1.00 46.15           C  
ATOM    616  CG1 ILE    84      39.852  17.365   2.668  1.00 47.29           C  
ATOM    617  CG2 ILE    84      37.762  18.689   2.092  1.00 46.24           C  
ATOM    618  CD1 ILE    84      39.445  17.067   4.080  1.00 50.14           C  
ATOM    619  N   GLU    85      38.522  19.748  -1.216  1.00 46.60           N  
ATOM    620  CA  GLU    85      38.039  20.784  -2.084  1.00 47.89           C  
ATOM    621  C   GLU    85      36.520  20.804  -2.013  1.00 49.62           C  
ATOM    622  O   GLU    85      35.832  20.028  -2.692  1.00 51.63           O  
ATOM    623  CB  GLU    85      38.573  20.475  -3.490  1.00 51.71           C  
ATOM    624  CG  GLU    85      38.765  21.692  -4.368  1.00 57.75           C  
ATOM    625  CD  GLU    85      37.511  22.140  -5.000  1.00 60.03           C  
ATOM    626  OE1 GLU    85      37.080  21.474  -5.960  1.00 68.42           O  
ATOM    627  OE2 GLU    85      36.983  23.178  -4.569  1.00 72.90           O  
ATOM    628  N   ALA    86      36.025  21.714  -1.175  1.00 50.24           N  
ATOM    629  CA  ALA    86      34.621  21.906  -0.862  1.00 51.22           C  
ATOM    630  C   ALA    86      34.248  23.339  -1.231  1.00 51.93           C  
ATOM    631  O   ALA    86      33.511  24.004  -0.489  1.00 47.88           O  
ATOM    632  CB  ALA    86      34.436  21.671   0.646  1.00 42.93           C  
ATOM    633  N   SER    87      34.774  23.845  -2.363  1.00 55.52           N  
ATOM    634  CA  SER    87      34.591  25.281  -2.700  1.00 57.00           C  
ATOM    635  C   SER    87      33.147  25.630  -3.017  1.00 61.90           C  
ATOM    636  O   SER    87      32.398  24.811  -3.514  1.00 59.30           O  
ATOM    637  CB  SER    87      35.575  25.809  -3.754  1.00 55.15           C  
ATOM    638  OG  SER    87      35.372  25.244  -5.030  1.00 56.86           O  
ATOM    639  N   VAL    88      32.775  26.852  -2.642  1.00 69.20           N  
ATOM    640  CA  VAL    88      31.417  27.390  -2.824  1.00 73.90           C  
ATOM    641  C   VAL    88      31.318  27.964  -4.261  1.00 76.16           C  
ATOM    642  O   VAL    88      31.702  29.098  -4.513  1.00 73.54           O  
ATOM    643  CB  VAL    88      31.120  28.461  -1.715  1.00 73.08           C  
ATOM    644  CG1 VAL    88      29.731  29.066  -1.894  1.00 69.80           C  
ATOM    645  CG2 VAL    88      31.289  27.840  -0.312  1.00 61.02           C  
ATOM    646  N   THR    89      30.828  27.137  -5.190  1.00 81.00           N  
ATOM    647  CA  THR    89      30.745  27.468  -6.637  1.00 82.65           C  
ATOM    648  C   THR    89      30.000  28.772  -6.989  1.00 85.93           C  
ATOM    649  O   THR    89      30.596  29.691  -7.569  1.00 87.51           O  
ATOM    650  CB  THR    89      30.105  26.289  -7.430  1.00 83.25           C  
ATOM    651  OG1 THR    89      30.674  25.064  -6.969  1.00 82.01           O  
ATOM    652  CG2 THR    89      30.323  26.436  -8.944  1.00 80.95           C  
ATOM    653  N   ARG    90      28.711  28.843  -6.654  1.00 87.96           N  
ATOM    654  CA  ARG    90      27.909  30.034  -6.955  1.00 90.26           C  
ATOM    655  C   ARG    90      28.283  31.197  -6.028  1.00 91.70           C  
ATOM    656  O   ARG    90      29.381  31.757  -6.132  1.00 92.21           O  
ATOM    657  CB  ARG    90      26.401  29.730  -6.884  1.00 90.72           C  
ATOM    658  CG  ARG    90      25.902  28.808  -7.988  1.00 88.44           C  
ATOM    659  N   GLU    95      36.980  27.853 -10.944  1.00 71.42           N  
ATOM    660  CA  GLU    95      37.985  27.902  -9.881  1.00 70.39           C  
ATOM    661  C   GLU    95      38.234  26.504  -9.345  1.00 67.32           C  
ATOM    662  O   GLU    95      39.382  26.078  -9.244  1.00 66.47           O  
ATOM    663  CB  GLU    95      37.552  28.843  -8.747  1.00 70.36           C  
ATOM    664  CG  GLU    95      37.322  30.293  -9.198  1.00 74.88           C  
ATOM    665  CD  GLU    95      37.005  31.238  -8.055  1.00 74.03           C  
ATOM    666  N   GLY    96      37.146  25.793  -9.032  1.00 64.05           N  
ATOM    667  CA  GLY    96      37.204  24.430  -8.510  1.00 61.48           C  
ATOM    668  C   GLY    96      38.060  23.472  -9.322  1.00 59.51           C  
ATOM    669  O   GLY    96      38.877  22.737  -8.755  1.00 56.52           O  
ATOM    670  N   VAL    97      37.863  23.492 -10.646  1.00 56.94           N  
ATOM    671  CA  VAL    97      38.614  22.650 -11.595  1.00 55.26           C  
ATOM    672  C   VAL    97      40.127  22.928 -11.513  1.00 56.32           C  
ATOM    673  O   VAL    97      40.927  21.991 -11.518  1.00 55.09           O  
ATOM    674  CB  VAL    97      38.070  22.803 -13.045  1.00 53.78           C  
ATOM    675  CG1 VAL    97      38.066  24.261 -13.494  1.00 58.74           C  
ATOM    676  CG2 VAL    97      38.864  21.960 -14.008  1.00 59.11           C  
ATOM    677  N   ASN    98      40.480  24.214 -11.389  1.00 54.22           N  
ATOM    678  CA  ASN    98      41.857  24.660 -11.246  1.00 54.30           C  
ATOM    679  C   ASN    98      42.453  24.285  -9.882  1.00 51.57           C  
ATOM    680  O   ASN    98      43.645  23.998  -9.795  1.00 47.91           O  
ATOM    681  CB  ASN    98      41.962  26.177 -11.474  1.00 55.52           C  
ATOM    682  CG  ASN    98      41.589  26.593 -12.901  1.00 61.57           C  
ATOM    683  OD1 ASN    98      41.665  25.800 -13.848  1.00 71.44           O  
ATOM    684  ND2 ASN    98      41.197  27.849 -13.056  1.00 66.79           N  
ATOM    685  N   TYR    99      41.643  24.288  -8.820  1.00 48.54           N  
ATOM    686  CA  TYR    99      42.161  23.863  -7.522  1.00 49.64           C  
ATOM    687  C   TYR    99      42.500  22.371  -7.569  1.00 49.05           C  
ATOM    688  O   TYR    99      43.541  21.952  -7.053  1.00 51.64           O  
ATOM    689  CB  TYR    99      41.194  24.121  -6.350  1.00 48.05           C  
ATOM    690  CG  TYR    99      40.754  25.556  -6.162  1.00 46.23           C  
ATOM    691  CD1 TYR    99      41.623  26.625  -6.348  1.00 46.50           C  
ATOM    692  CD2 TYR    99      39.490  25.832  -5.724  1.00 45.42           C  
ATOM    693  CE1 TYR    99      41.192  27.936  -6.155  1.00 46.16           C  
ATOM    694  CE2 TYR    99      39.064  27.119  -5.519  1.00 46.77           C  
ATOM    695  CZ  TYR    99      39.904  28.166  -5.733  1.00 45.70           C  
ATOM    696  OH  TYR    99      39.402  29.434  -5.514  1.00 51.84           O  
ATOM    697  N   ILE   100      41.628  21.574  -8.179  1.00 47.86           N  
ATOM    698  CA  ILE   100      41.874  20.132  -8.314  1.00 49.67           C  
ATOM    699  C   ILE   100      43.122  19.875  -9.195  1.00 51.71           C  
ATOM    700  O   ILE   100      44.067  19.252  -8.743  1.00 51.29           O  
ATOM    701  CB  ILE   100      40.659  19.376  -8.896  1.00 48.81           C  
ATOM    702  CG1 ILE   100      39.469  19.386  -7.930  1.00 48.30           C  
ATOM    703  CG2 ILE   100      41.003  17.910  -9.176  1.00 44.61           C  
ATOM    704  CD1 ILE   100      38.199  18.752  -8.519  1.00 49.51           C  
ATOM    705  N   ARG   101      43.108  20.369 -10.431  1.00 52.51           N  
ATOM    706  CA  ARG   101      44.230  20.194 -11.364  1.00 55.14           C  
ATOM    707  C   ARG   101      45.554  20.601 -10.734  1.00 54.85           C  
ATOM    708  O   ARG   101      46.535  19.874 -10.839  1.00 55.38           O  
ATOM    709  CB  ARG   101      44.035  21.011 -12.650  1.00 55.82           C  
ATOM    710  CG  ARG   101      42.778  20.674 -13.456  1.00 58.03           C  
ATOM    711  CD  ARG   101      42.829  21.241 -14.900  1.00 62.37           C  
ATOM    712  NE  ARG   101      43.768  20.500 -15.761  1.00 74.76           N  
ATOM    713  CZ  ARG   101      43.525  19.324 -16.364  1.00 73.10           C  
ATOM    714  NH1 ARG   101      42.371  18.678 -16.211  1.00 82.89           N  
ATOM    715  NH2 ARG   101      44.462  18.763 -17.113  1.00 77.93           N  
ATOM    716  N   GLU   102      45.570  21.741 -10.047  1.00 55.06           N  
ATOM    717  CA  GLU   102      46.809  22.249  -9.432  1.00 52.94           C  
ATOM    718  C   GLU   102      47.251  21.434  -8.207  1.00 50.92           C  
ATOM    719  O   GLU   102      48.438  21.306  -7.962  1.00 50.71           O  
ATOM    720  CB  GLU   102      46.692  23.751  -9.127  1.00 53.31           C  
ATOM    721  CG  GLU   102      47.894  24.396  -8.412  1.00 59.26           C  
ATOM    722  CD  GLU   102      49.247  24.233  -9.132  1.00 73.51           C  
ATOM    723  OE1 GLU   102      49.290  23.801 -10.310  1.00 79.16           O  
ATOM    724  OE2 GLU   102      50.281  24.545  -8.500  1.00 74.49           O  
ATOM    725  N   ALA   103      46.331  20.875  -7.431  1.00 48.87           N  
ATOM    726  CA  ALA   103      46.771  20.000  -6.334  1.00 49.59           C  
ATOM    727  C   ALA   103      47.291  18.658  -6.928  1.00 50.34           C  
ATOM    728  O   ALA   103      48.342  18.160  -6.523  1.00 49.72           O  
ATOM    729  CB  ALA   103      45.681  19.771  -5.339  1.00 49.73           C  
ATOM    730  N   LEU   104      46.581  18.114  -7.920  1.00 49.91           N  
ATOM    731  CA  LEU   104      46.985  16.867  -8.575  1.00 51.67           C  
ATOM    732  C   LEU   104      48.338  17.020  -9.279  1.00 52.40           C  
ATOM    733  O   LEU   104      49.191  16.145  -9.171  1.00 50.76           O  
ATOM    734  CB  LEU   104      45.928  16.407  -9.568  1.00 49.76           C  
ATOM    735  CG  LEU   104      44.547  16.002  -9.041  1.00 53.38           C  
ATOM    736  CD1 LEU   104      43.662  15.662 -10.233  1.00 37.65           C  
ATOM    737  CD2 LEU   104      44.609  14.837  -8.066  1.00 50.22           C  
ATOM    738  N   LYS   105      48.533  18.144  -9.976  1.00 56.09           N  
ATOM    739  CA  LYS   105      49.814  18.446 -10.655  1.00 57.24           C  
ATOM    740  C   LYS   105      50.963  18.669  -9.692  1.00 57.39           C  
ATOM    741  O   LYS   105      52.103  18.672 -10.107  1.00 59.78           O  
ATOM    742  CB  LYS   105      49.703  19.640 -11.618  1.00 57.94           C  
ATOM    743  CG  LYS   105      49.032  19.267 -12.935  1.00 61.88           C  
ATOM    744  CD  LYS   105      49.179  20.332 -14.006  1.00 62.50           C  
ATOM    745  CE  LYS   105      48.876  19.739 -15.402  1.00 70.85           C  
ATOM    746  NZ  LYS   105      49.886  18.699 -15.892  1.00 70.98           N  
ATOM    747  N   ARG   106      50.658  18.892  -8.420  1.00 58.13           N  
ATOM    748  CA  ARG   106      51.672  19.005  -7.369  1.00 56.77           C  
ATOM    749  C   ARG   106      51.905  17.619  -6.740  1.00 56.15           C  
ATOM    750  O   ARG   106      52.762  17.458  -5.857  1.00 54.66           O  
ATOM    751  CB  ARG   106      51.227  19.993  -6.282  1.00 56.17           C  
ATOM    752  CG  ARG   106      51.323  21.464  -6.672  1.00 56.67           C  
ATOM    753  CD  ARG   106      51.087  22.367  -5.465  1.00 55.82           C  
ATOM    754  NE  ARG   106      52.073  22.124  -4.405  1.00 53.50           N  
ATOM    755  CZ  ARG   106      51.980  22.577  -3.155  1.00 56.94           C  
ATOM    756  NH1 ARG   106      50.933  23.294  -2.762  1.00 58.09           N  
ATOM    757  NH2 ARG   106      52.925  22.285  -2.278  1.00 50.02           N  
ATOM    758  N   GLY   107      51.131  16.628  -7.195  1.00 55.48           N  
ATOM    759  CA  GLY   107      51.208  15.275  -6.654  1.00 55.17           C  
ATOM    760  C   GLY   107      50.539  15.197  -5.295  1.00 54.21           C  
ATOM    761  O   GLY   107      51.081  14.619  -4.345  1.00 54.11           O  
ATOM    762  N   LYS   108      49.371  15.816  -5.186  1.00 51.69           N  
ATOM    763  CA  LYS   108      48.619  15.784  -3.935  1.00 51.31           C  
ATOM    764  C   LYS   108      47.323  15.041  -4.178  1.00 48.74           C  
ATOM    765  O   LYS   108      46.741  15.138  -5.251  1.00 48.93           O  
ATOM    766  CB  LYS   108      48.273  17.194  -3.456  1.00 51.38           C  
ATOM    767  CG  LYS   108      49.419  18.169  -3.456  1.00 56.15           C  
ATOM    768  CD  LYS   108      50.515  17.765  -2.520  1.00 58.85           C  
ATOM    769  CE  LYS   108      51.599  18.829  -2.498  1.00 60.63           C  
ATOM    770  NZ  LYS   108      52.697  18.433  -1.593  1.00 62.62           N  
ATOM    771  N   HIS   109      46.874  14.297  -3.182  1.00 49.47           N  
ATOM    772  CA  HIS   109      45.569  13.666  -3.256  1.00 49.40           C  
ATOM    773  C   HIS   109      44.517  14.758  -3.203  1.00 50.51           C  
ATOM    774  O   HIS   109      44.791  15.847  -2.689  1.00 47.92           O  
ATOM    775  CB  HIS   109      45.343  12.730  -2.073  1.00 49.59           C  
ATOM    776  CG  HIS   109      46.234  11.536  -2.078  1.00 48.32           C  
ATOM    777  ND1 HIS   109      46.214  10.603  -3.090  1.00 46.44           N  
ATOM    778  CD2 HIS   109      47.148  11.101  -1.183  1.00 56.19           C  
ATOM    779  CE1 HIS   109      47.073   9.642  -2.817  1.00 46.97           C  
ATOM    780  NE2 HIS   109      47.665   9.927  -1.671  1.00 52.45           N  
ATOM    781  N   VAL   110      43.330  14.473  -3.752  1.00 50.11           N  
ATOM    782  CA  VAL   110      42.217  15.417  -3.717  1.00 48.52           C  
ATOM    783  C   VAL   110      40.909  14.683  -3.375  1.00 49.34           C  
ATOM    784  O   VAL   110      40.607  13.641  -3.948  1.00 48.90           O  
ATOM    785  CB  VAL   110      42.041  16.184  -5.047  1.00 48.35           C  
ATOM    786  CG1 VAL   110      40.770  17.073  -5.010  1.00 44.89           C  
ATOM    787  CG2 VAL   110      43.297  17.022  -5.380  1.00 49.41           C  
ATOM    788  N   VAL   111      40.183  15.217  -2.388  1.00 49.95           N  
ATOM    789  CA  VAL   111      38.847  14.747  -2.023  1.00 47.72           C  
ATOM    790  C   VAL   111      37.955  15.932  -2.284  1.00 47.79           C  
ATOM    791  O   VAL   111      38.155  16.980  -1.698  1.00 48.65           O  
ATOM    792  CB  VAL   111      38.744  14.330  -0.539  1.00 50.88           C  
ATOM    793  CG1 VAL   111      37.274  13.885  -0.179  1.00 43.38           C  
ATOM    794  CG2 VAL   111      39.822  13.221  -0.211  1.00 37.10           C  
ATOM    795  N   THR   112      36.975  15.786  -3.170  1.00 48.71           N  
ATOM    796  CA  THR   112      36.090  16.889  -3.497  1.00 48.68           C  
ATOM    797  C   THR   112      34.581  16.600  -3.306  1.00 47.62           C  
ATOM    798  O   THR   112      34.144  15.451  -3.292  1.00 46.68           O  
ATOM    799  CB  THR   112      36.337  17.321  -4.968  1.00 50.41           C  
ATOM    800  OG1 THR   112      35.673  18.561  -5.241  1.00 47.66           O  
ATOM    801  CG2 THR   112      35.852  16.241  -5.934  1.00 45.32           C  
ATOM    802  N   SER   113      33.820  17.681  -3.147  1.00 45.75           N  
ATOM    803  CA  SER   113      32.375  17.659  -3.096  1.00 46.09           C  
ATOM    804  C   SER   113      31.789  18.458  -4.240  1.00 47.40           C  
ATOM    805  O   SER   113      30.560  18.580  -4.317  1.00 45.48           O  
ATOM    806  CB  SER   113      31.875  18.236  -1.788  1.00 45.43           C  
ATOM    807  OG  SER   113      32.284  19.584  -1.646  1.00 48.74           O  
ATOM    808  N   ASN   114      32.644  19.035  -5.109  1.00 50.21           N  
ATOM    809  CA  ASN   114      32.192  19.825  -6.272  1.00 48.59           C  
ATOM    810  C   ASN   114      31.952  18.966  -7.482  1.00 50.23           C  
ATOM    811  O   ASN   114      32.851  18.267  -7.955  1.00 53.11           O  
ATOM    812  CB  ASN   114      33.234  20.855  -6.728  1.00 53.83           C  
ATOM    813  CG  ASN   114      33.505  21.943  -5.724  1.00 55.30           C  
ATOM    814  OD1 ASN   114      32.666  22.306  -4.903  1.00 62.72           O  
ATOM    815  ND2 ASN   114      34.684  22.520  -5.836  1.00 64.14           N  
ATOM    816  N   LYS   115      30.766  19.082  -8.045  1.00 50.56           N  
ATOM    817  CA  LYS   115      30.398  18.316  -9.208  1.00 51.29           C  
ATOM    818  C   LYS   115      30.955  18.846 -10.506  1.00 51.41           C  
ATOM    819  O   LYS   115      31.316  18.065 -11.374  1.00 51.72           O  
ATOM    820  CB  LYS   115      28.881  18.263  -9.341  1.00 49.65           C  
ATOM    821  CG  LYS   115      28.202  17.499  -8.226  1.00 52.75           C  
ATOM    822  CD  LYS   115      26.694  17.359  -8.422  1.00 53.62           C  
ATOM    823  CE  LYS   115      25.950  18.662  -8.349  1.00 50.26           C  
ATOM    824  NZ  LYS   115      26.141  19.356  -7.059  1.00 50.30           N  
ATOM    825  N   GLY   116      30.971  20.166 -10.651  1.00 52.85           N  
ATOM    826  CA  GLY   116      31.371  20.831 -11.893  1.00 53.63           C  
ATOM    827  C   GLY   116      32.590  20.334 -12.641  1.00 52.17           C  
ATOM    828  O   GLY   116      32.525  20.138 -13.850  1.00 52.80           O  
ATOM    829  N   PRO   117      33.732  20.230 -11.942  1.00 54.21           N  
ATOM    830  CA  PRO   117      34.969  19.755 -12.567  1.00 54.55           C  
ATOM    831  C   PRO   117      34.874  18.330 -13.110  1.00 54.36           C  
ATOM    832  O   PRO   117      35.433  18.031 -14.153  1.00 53.77           O  
ATOM    833  CB  PRO   117      36.012  19.857 -11.431  1.00 55.95           C  
ATOM    834  CG  PRO   117      35.430  20.794 -10.416  1.00 56.94           C  
ATOM    835  CD  PRO   117      33.940  20.671 -10.539  1.00 53.64           C  
ATOM    836  N   LEU   118      34.183  17.465 -12.378  1.00 55.23           N  
ATOM    837  CA  LEU   118      33.987  16.075 -12.757  1.00 55.96           C  
ATOM    838  C   LEU   118      33.057  15.968 -13.965  1.00 55.80           C  
ATOM    839  O   LEU   118      33.257  15.138 -14.825  1.00 58.23           O  
ATOM    840  CB  LEU   118      33.446  15.262 -11.545  1.00 58.62           C  
ATOM    841  CG  LEU   118      34.500  15.044 -10.441  1.00 61.54           C  
ATOM    842  CD1 LEU   118      33.928  14.742  -9.107  1.00 71.04           C  
ATOM    843  CD2 LEU   118      35.406  13.924 -10.859  1.00 68.06           C  
ATOM    844  N   VAL   119      32.046  16.817 -14.035  1.00 54.86           N  
ATOM    845  CA  VAL   119      31.113  16.814 -15.154  1.00 53.09           C  
ATOM    846  C   VAL   119      31.791  17.310 -16.443  1.00 55.58           C  
ATOM    847  O   VAL   119      31.652  16.694 -17.498  1.00 56.38           O  
ATOM    848  CB  VAL   119      29.889  17.628 -14.764  1.00 54.44           C  
ATOM    849  CG1 VAL   119      28.941  17.805 -15.914  1.00 52.88           C  
ATOM    850  CG2 VAL   119      29.207  16.909 -13.621  1.00 44.67           C  
ATOM    851  N   ALA   120      32.582  18.373 -16.318  1.00 54.44           N  
ATOM    852  CA  ALA   120      33.290  18.992 -17.435  1.00 54.29           C  
ATOM    853  C   ALA   120      34.518  18.235 -17.921  1.00 55.34           C  
ATOM    854  O   ALA   120      34.811  18.247 -19.105  1.00 57.54           O  
ATOM    855  CB  ALA   120      33.737  20.410 -17.029  1.00 51.93           C  
ATOM    856  N   GLU   121      35.213  17.545 -17.025  1.00 56.00           N  
ATOM    857  CA  GLU   121      36.541  17.038 -17.323  1.00 58.35           C  
ATOM    858  C   GLU   121      36.841  15.724 -16.611  1.00 55.53           C  
ATOM    859  O   GLU   121      37.940  15.530 -16.113  1.00 56.64           O  
ATOM    860  CB  GLU   121      37.464  18.167 -16.815  1.00 59.18           C  
ATOM    861  CG  GLU   121      38.830  18.362 -17.439  1.00 70.74           C  
ATOM    862  CD  GLU   121      39.409  19.783 -17.142  1.00 65.74           C  
ATOM    863  OE1 GLU   121      38.645  20.684 -16.743  1.00 79.01           O  
ATOM    864  OE2 GLU   121      40.619  20.015 -17.355  1.00 85.72           O  
ATOM    865  N   PHE   122      35.876  14.802 -16.601  1.00 56.63           N  
ATOM    866  CA  PHE   122      36.010  13.547 -15.844  1.00 55.23           C  
ATOM    867  C   PHE   122      37.264  12.738 -16.151  1.00 54.15           C  
ATOM    868  O   PHE   122      38.086  12.516 -15.264  1.00 52.49           O  
ATOM    869  CB  PHE   122      34.777  12.655 -16.018  1.00 54.88           C  
ATOM    870  CG  PHE   122      34.693  11.521 -15.020  1.00 50.49           C  
ATOM    871  CD1 PHE   122      35.355  10.327 -15.244  1.00 55.24           C  
ATOM    872  CD2 PHE   122      33.935  11.644 -13.876  1.00 50.51           C  
ATOM    873  CE1 PHE   122      35.289   9.278 -14.335  1.00 51.72           C  
ATOM    874  CE2 PHE   122      33.841  10.587 -12.970  1.00 51.01           C  
ATOM    875  CZ  PHE   122      34.524   9.416 -13.196  1.00 52.74           C  
ATOM    876  N   HIS   123      37.401  12.272 -17.392  1.00 56.63           N  
ATOM    877  CA  HIS   123      38.563  11.450 -17.733  0.50 55.39           C  
ATOM    879  C   HIS   123      39.863  12.266 -17.699  1.00 54.42           C  
ATOM    880  O   HIS   123      40.909  11.736 -17.299  1.00 53.57           O  
ATOM    881  CB  HIS   123      38.302  10.658 -19.024  0.50 56.22           C  
ATOM    883  CG  HIS   123      37.164   9.680 -18.890  0.50 57.00           C  
ATOM    885  ND1 HIS   123      37.353   8.347 -18.593  0.50 58.87           N  
ATOM    887  CD2 HIS   123      35.821   9.859 -18.951  0.50 55.15           C  
ATOM    889  CE1 HIS   123      36.178   7.744 -18.505  0.50 56.16           C  
ATOM    891  NE2 HIS   123      35.233   8.640 -18.717  0.50 47.93           N  
ATOM    893  N   GLY   124      39.796  13.550 -18.054  1.00 53.91           N  
ATOM    894  CA  GLY   124      40.978  14.415 -17.976  1.00 53.04           C  
ATOM    895  C   GLY   124      41.543  14.511 -16.555  1.00 51.96           C  
ATOM    896  O   GLY   124      42.753  14.529 -16.351  1.00 50.24           O  
ATOM    897  N   LEU   125      40.664  14.563 -15.559  1.00 53.43           N  
ATOM    898  CA  LEU   125      41.097  14.673 -14.155  1.00 52.48           C  
ATOM    899  C   LEU   125      41.531  13.328 -13.551  1.00 50.24           C  
ATOM    900  O   LEU   125      42.487  13.275 -12.777  1.00 49.73           O  
ATOM    901  CB  LEU   125      40.000  15.344 -13.308  1.00 53.01           C  
ATOM    902  CG  LEU   125      39.695  16.826 -13.543  1.00 54.32           C  
ATOM    903  CD1 LEU   125      38.510  17.280 -12.725  1.00 55.94           C  
ATOM    904  CD2 LEU   125      40.916  17.652 -13.194  1.00 52.48           C  
ATOM    905  N   MET   126      40.808  12.256 -13.865  1.00 52.81           N  
ATOM    906  CA  MET   126      41.185  10.893 -13.402  1.00 54.54           C  
ATOM    907  C   MET   126      42.575  10.517 -13.924  1.00 53.83           C  
ATOM    908  O   MET   126      43.378   9.944 -13.184  1.00 53.10           O  
ATOM    909  CB  MET   126      40.189   9.807 -13.835  1.00 54.20           C  
ATOM    910  CG  MET   126      38.795   9.855 -13.183  1.00 58.18           C  
ATOM    911  SD  MET   126      38.751  10.091 -11.219  0.75 60.16          SE  
ATOM    912  CE  MET   126      39.752   8.577 -10.538  1.00 78.54           C  
ATOM    913  N   SER   127      42.844  10.862 -15.186  1.00 54.62           N  
ATOM    914  CA  SER   127      44.147  10.597 -15.831  1.00 54.86           C  
ATOM    915  C   SER   127      45.267  11.425 -15.241  1.00 53.47           C  
ATOM    916  O   SER   127      46.381  10.950 -15.131  1.00 55.47           O  
ATOM    917  CB  SER   127      44.094  10.894 -17.332  1.00 54.90           C  
ATOM    918  OG  SER   127      43.186  10.041 -17.993  1.00 61.83           O  
ATOM    919  N   LEU   128      44.978  12.684 -14.919  1.00 52.40           N  
ATOM    920  CA  LEU   128      45.966  13.574 -14.325  1.00 50.90           C  
ATOM    921  C   LEU   128      46.372  13.016 -12.972  1.00 51.93           C  
ATOM    922  O   LEU   128      47.555  12.994 -12.633  1.00 53.62           O  
ATOM    923  CB  LEU   128      45.395  14.980 -14.198  1.00 51.03           C  
ATOM    924  CG  LEU   128      46.234  16.105 -13.596  1.00 49.96           C  
ATOM    925  CD1 LEU   128      47.568  16.259 -14.343  1.00 56.86           C  
ATOM    926  CD2 LEU   128      45.413  17.380 -13.639  1.00 50.06           C  
ATOM    927  N   ALA   129      45.385  12.556 -12.208  1.00 51.61           N  
ATOM    928  CA  ALA   129      45.632  11.936 -10.915  1.00 51.88           C  
ATOM    929  C   ALA   129      46.487  10.673 -11.099  1.00 52.40           C  
ATOM    930  O   ALA   129      47.434  10.443 -10.339  1.00 50.89           O  
ATOM    931  CB  ALA   129      44.296  11.596 -10.207  1.00 50.63           C  
ATOM    932  N   GLU   130      46.137   9.856 -12.094  1.00 53.27           N  
ATOM    933  CA  GLU   130      46.895   8.632 -12.398  1.00 54.20           C  
ATOM    934  C   GLU   130      48.324   8.963 -12.851  1.00 54.83           C  
ATOM    935  O   GLU   130      49.264   8.333 -12.362  1.00 54.37           O  
ATOM    936  CB  GLU   130      46.193   7.791 -13.462  1.00 52.41           C  
ATOM    937  N   ARG   131      48.492   9.955 -13.743  1.00 55.42           N  
ATOM    938  CA  ARG   131      49.840  10.356 -14.250  1.00 56.32           C  
ATOM    939  C   ARG   131      50.738  10.829 -13.114  1.00 55.67           C  
ATOM    940  O   ARG   131      51.926  10.576 -13.118  1.00 56.70           O  
ATOM    941  CB  ARG   131      49.758  11.431 -15.348  1.00 56.34           C  
ATOM    942  CG  ARG   131      49.050  10.967 -16.660  1.00 62.98           C  
ATOM    943  CD  ARG   131      48.982  12.092 -17.710  1.00 61.66           C  
ATOM    944  NE  ARG   131      48.426  13.344 -17.177  1.00 64.09           N  
ATOM    945  N   ASN   132      50.177  11.568 -12.168  1.00 56.65           N  
ATOM    946  CA  ASN   132      50.895  11.901 -10.943  1.00 56.97           C  
ATOM    947  C   ASN   132      50.559  10.651 -10.117  1.00 58.00           C  
ATOM    948  O   ASN   132      49.869   9.779 -10.637  1.00 59.78           O  
ATOM    949  CB  ASN   132      50.415  13.238 -10.413  1.00 57.33           C  
ATOM    950  CG  ASN   132      50.664  14.355 -11.420  1.00 57.24           C  
ATOM    951  OD1 ASN   132      51.786  14.816 -11.570  1.00 61.01           O  
ATOM    952  ND2 ASN   132      49.626  14.760 -12.140  1.00 60.01           N  
ATOM    953  N   GLY   133      51.018  10.477  -8.889  1.00 57.07           N  
ATOM    954  CA  GLY   133      50.747   9.159  -8.251  1.00 56.86           C  
ATOM    955  C   GLY   133      49.713   9.238  -7.162  1.00 56.82           C  
ATOM    956  O   GLY   133      49.919   8.703  -6.070  1.00 58.77           O  
ATOM    957  N   VAL   134      48.579   9.858  -7.474  1.00 53.08           N  
ATOM    958  CA  VAL   134      47.616  10.206  -6.441  1.00 51.32           C  
ATOM    959  C   VAL   134      46.175   9.874  -6.828  1.00 50.72           C  
ATOM    960  O   VAL   134      45.910   9.435  -7.945  1.00 48.58           O  
ATOM    961  CB  VAL   134      47.796  11.703  -6.057  1.00 51.01           C  
ATOM    962  CG1 VAL   134      49.012  11.872  -5.150  1.00 54.40           C  
ATOM    963  CG2 VAL   134      47.930  12.580  -7.305  1.00 45.88           C  
ATOM    964  N   ARG   135      45.268  10.139  -5.895  0.50 49.42           N  
ATOM    966  CA  ARG   135      43.865   9.791  -6.030  0.50 48.64           C  
ATOM    968  C   ARG   135      42.945  11.001  -6.034  0.50 49.96           C  
ATOM    970  O   ARG   135      43.253  12.019  -5.408  0.50 49.55           O  
ATOM    972  CB  ARG   135      43.520   8.818  -4.889  0.50 49.07           C  
ATOM    974  CG  ARG   135      44.238   7.447  -5.089  0.50 42.86           C  
ATOM    976  CD  ARG   135      44.600   6.726  -3.784  0.50 47.77           C  
ATOM    978  NE  ARG   135      43.639   5.901  -3.034  0.50 45.67           N  
ATOM    980  CZ  ARG   135      42.520   5.335  -3.464  0.50 34.61           C  
ATOM    982  NH1 ARG   135      42.107   5.428  -4.715  0.50 49.68           N  
ATOM    984  NH2 ARG   135      41.807   4.612  -2.611  0.50 41.15           N  
ATOM    986  N   LEU   136      41.850  10.901  -6.803  1.00 51.89           N  
ATOM    987  CA  LEU   136      40.819  11.910  -6.827  1.00 50.18           C  
ATOM    988  C   LEU   136      39.542  11.204  -6.338  1.00 49.36           C  
ATOM    989  O   LEU   136      38.971  10.354  -7.025  1.00 47.37           O  
ATOM    990  CB  LEU   136      40.644  12.459  -8.244  1.00 48.45           C  
ATOM    991  CG  LEU   136      39.474  13.415  -8.427  1.00 52.91           C  
ATOM    992  CD1 LEU   136      39.544  14.575  -7.432  1.00 49.89           C  
ATOM    993  CD2 LEU   136      39.446  13.914  -9.835  1.00 50.66           C  
ATOM    994  N   MET   137      39.124  11.584  -5.133  1.00 49.57           N  
ATOM    995  CA  MET   137      37.985  11.000  -4.440  1.00 47.97           C  
ATOM    996  C   MET   137      36.838  11.987  -4.519  1.00 47.50           C  
ATOM    997  O   MET   137      37.051  13.185  -4.449  1.00 47.68           O  
ATOM    998  CB  MET   137      38.368  10.700  -2.991  1.00 48.53           C  
ATOM    999  CG  MET   137      39.656   9.905  -2.862  1.00 42.73           C  
ATOM   1000  SD  MET   137      39.679   8.179  -3.673  0.75 46.98          SE  
ATOM   1001  CE  MET   137      38.432   7.168  -2.288  1.00 38.10           C  
ATOM   1002  N   TYR   138      35.630  11.460  -4.661  1.00 48.91           N  
ATOM   1003  CA  TYR   138      34.475  12.256  -4.923  1.00 47.22           C  
ATOM   1004  C   TYR   138      33.151  11.698  -4.424  1.00 47.83           C  
ATOM   1005  O   TYR   138      32.087  12.015  -4.959  1.00 45.61           O  
ATOM   1006  CB  TYR   138      34.424  12.553  -6.412  1.00 44.71           C  
ATOM   1007  CG  TYR   138      34.385  11.379  -7.364  1.00 46.33           C  
ATOM   1008  CD1 TYR   138      35.546  10.696  -7.704  1.00 52.94           C  
ATOM   1009  CD2 TYR   138      33.214  11.025  -8.019  1.00 44.16           C  
ATOM   1010  CE1 TYR   138      35.532   9.650  -8.594  1.00 43.58           C  
ATOM   1011  CE2 TYR   138      33.201  10.003  -8.915  1.00 46.47           C  
ATOM   1012  CZ  TYR   138      34.374   9.332  -9.212  1.00 48.02           C  
ATOM   1013  OH  TYR   138      34.369   8.298 -10.104  1.00 46.71           O  
ATOM   1014  N   GLU   139      33.216  10.954  -3.334  1.00 45.83           N  
ATOM   1015  CA  GLU   139      32.017  10.400  -2.731  1.00 47.57           C  
ATOM   1016  C   GLU   139      30.970  11.444  -2.426  1.00 49.18           C  
ATOM   1017  O   GLU   139      29.768  11.190  -2.572  1.00 50.54           O  
ATOM   1018  CB  GLU   139      32.335   9.668  -1.414  1.00 48.35           C  
ATOM   1019  CG  GLU   139      31.164   8.835  -0.884  1.00 47.00           C  
ATOM   1020  CD  GLU   139      30.758   7.711  -1.860  1.00 43.98           C  
ATOM   1021  OE1 GLU   139      31.478   6.693  -1.942  1.00 46.77           O  
ATOM   1022  OE2 GLU   139      29.693   7.834  -2.501  1.00 51.48           O  
ATOM   1023  N   ALA   140      31.410  12.632  -2.008  1.00 47.25           N  
ATOM   1024  CA  ALA   140      30.466  13.630  -1.608  1.00 46.58           C  
ATOM   1025  C   ALA   140      29.757  14.314  -2.779  1.00 47.40           C  
ATOM   1026  O   ALA   140      28.847  15.054  -2.526  1.00 48.49           O  
ATOM   1027  CB  ALA   140      31.140  14.651  -0.721  1.00 44.92           C  
ATOM   1028  N   THR   141      30.195  14.090  -4.022  1.00 46.91           N  
ATOM   1029  CA  THR   141      29.588  14.714  -5.207  1.00 48.12           C  
ATOM   1030  C   THR   141      28.202  14.200  -5.568  1.00 50.80           C  
ATOM   1031  O   THR   141      27.416  14.944  -6.177  1.00 51.29           O  
ATOM   1032  CB  THR   141      30.478  14.659  -6.488  1.00 47.24           C  
ATOM   1033  OG1 THR   141      30.723  13.294  -6.859  1.00 48.28           O  
ATOM   1034  CG2 THR   141      31.825  15.414  -6.262  1.00 43.30           C  
ATOM   1035  N   VAL   142      27.914  12.957  -5.200  1.00 53.48           N  
ATOM   1036  CA  VAL   142      26.622  12.313  -5.469  1.00 53.95           C  
ATOM   1037  C   VAL   142      26.171  11.369  -4.346  1.00 54.69           C  
ATOM   1038  O   VAL   142      26.930  10.513  -3.878  1.00 55.37           O  
ATOM   1039  CB  VAL   142      26.618  11.611  -6.854  1.00 54.18           C  
ATOM   1040  CG1 VAL   142      27.955  10.999  -7.161  1.00 57.67           C  
ATOM   1041  CG2 VAL   142      25.479  10.619  -6.943  1.00 52.95           C  
ATOM   1042  N   GLY   143      24.958  11.600  -3.856  1.00 52.14           N  
ATOM   1043  CA  GLY   143      24.374  10.750  -2.838  1.00 50.98           C  
ATOM   1044  C   GLY   143      24.609  11.204  -1.432  1.00 51.28           C  
ATOM   1045  O   GLY   143      24.085  10.613  -0.496  1.00 55.26           O  
ATOM   1046  N   GLY   144      25.396  12.256  -1.251  1.00 52.65           N  
ATOM   1047  CA  GLY   144      25.723  12.698   0.083  1.00 51.40           C  
ATOM   1048  C   GLY   144      26.376  11.565   0.871  1.00 50.65           C  
ATOM   1049  O   GLY   144      27.388  11.001   0.447  1.00 48.18           O  
ATOM   1050  N   ALA   145      25.768  11.212   2.002  1.00 51.56           N  
ATOM   1051  CA  ALA   145      26.327  10.204   2.909  1.00 52.26           C  
ATOM   1052  C   ALA   145      26.139   8.777   2.348  1.00 53.05           C  
ATOM   1053  O   ALA   145      26.863   7.857   2.708  1.00 53.99           O  
ATOM   1054  CB  ALA   145      25.677  10.322   4.270  1.00 50.99           C  
ATOM   1055  N   MET   146      25.158   8.618   1.462  1.00 50.60           N  
ATOM   1056  CA  MET   146      24.891   7.368   0.851  1.00 50.52           C  
ATOM   1057  C   MET   146      26.084   6.894   0.012  1.00 50.64           C  
ATOM   1058  O   MET   146      26.504   7.577  -0.892  1.00 48.54           O  
ATOM   1059  CB  MET   146      23.694   7.542  -0.055  1.00 51.68           C  
ATOM   1060  CG  MET   146      23.106   6.288  -0.514  1.00 53.42           C  
ATOM   1061  SD  MET   146      21.639   6.652  -1.726  0.75 51.40          SE  
ATOM   1062  CE  MET   146      22.421   7.137  -3.397  1.00 41.76           C  
ATOM   1063  N   PRO   147      26.590   5.680   0.272  1.00 55.27           N  
ATOM   1064  CA  PRO   147      27.666   5.168  -0.554  1.00 59.57           C  
ATOM   1065  C   PRO   147      27.109   4.969  -1.970  1.00 62.01           C  
ATOM   1066  O   PRO   147      26.020   4.430  -2.168  1.00 69.27           O  
ATOM   1067  CB  PRO   147      27.996   3.825   0.115  1.00 62.74           C  
ATOM   1068  CG  PRO   147      26.726   3.399   0.712  1.00 58.36           C  
ATOM   1069  CD  PRO   147      26.153   4.675   1.262  1.00 57.17           C  
ATOM   1070  N   VAL   148      27.811   5.458  -2.944  1.00 58.57           N  
ATOM   1071  CA  VAL   148      27.372   5.354  -4.306  1.00 57.54           C  
ATOM   1072  C   VAL   148      28.616   5.216  -5.127  1.00 54.59           C  
ATOM   1073  O   VAL   148      28.723   4.308  -5.944  1.00 52.23           O  
ATOM   1074  CB  VAL   148      26.547   6.614  -4.724  1.00 60.30           C  
ATOM   1075  CG1 VAL   148      26.965   7.147  -6.068  1.00 66.42           C  
ATOM   1076  CG2 VAL   148      25.075   6.275  -4.725  1.00 68.44           C  
ATOM   1077  N   VAL   149      29.574   6.114  -4.890  1.00 52.03           N  
ATOM   1078  CA  VAL   149      30.798   6.115  -5.672  1.00 51.15           C  
ATOM   1079  C   VAL   149      31.675   4.920  -5.288  1.00 50.57           C  
ATOM   1080  O   VAL   149      32.071   4.145  -6.167  1.00 45.42           O  
ATOM   1081  CB  VAL   149      31.546   7.468  -5.571  1.00 53.38           C  
ATOM   1082  CG1 VAL   149      32.893   7.384  -6.303  1.00 49.14           C  
ATOM   1083  CG2 VAL   149      30.649   8.600  -6.096  1.00 47.53           C  
ATOM   1084  N   LYS   150      31.952   4.755  -3.989  1.00 48.79           N  
ATOM   1085  CA  LYS   150      32.784   3.626  -3.512  1.00 49.43           C  
ATOM   1086  C   LYS   150      32.095   2.320  -3.764  1.00 47.11           C  
ATOM   1087  O   LYS   150      32.760   1.332  -4.023  1.00 46.70           O  
ATOM   1088  CB  LYS   150      33.287   3.796  -2.039  1.00 47.93           C  
ATOM   1089  CG  LYS   150      34.373   4.877  -1.975  1.00 54.17           C  
ATOM   1090  CD  LYS   150      35.164   5.020  -0.677  1.00 51.38           C  
ATOM   1091  CE  LYS   150      34.367   5.564   0.440  1.00 49.40           C  
ATOM   1092  NZ  LYS   150      33.730   6.839   0.047  1.00 45.36           N  
ATOM   1093  N   LEU   151      30.766   2.343  -3.813  1.00 47.45           N  
ATOM   1094  CA  LEU   151      29.981   1.164  -4.115  1.00 50.05           C  
ATOM   1095  C   LEU   151      30.137   0.788  -5.590  1.00 50.80           C  
ATOM   1096  O   LEU   151      30.518  -0.323  -5.894  1.00 50.90           O  
ATOM   1097  CB  LEU   151      28.510   1.423  -3.788  1.00 50.10           C  
ATOM   1098  CG  LEU   151      27.572   0.282  -3.453  1.00 53.83           C  
ATOM   1099  CD1 LEU   151      28.191  -0.557  -2.376  1.00 52.95           C  
ATOM   1100  CD2 LEU   151      26.256   0.818  -2.940  1.00 51.54           C  
ATOM   1101  N   ALA   152      29.828   1.712  -6.498  1.00 51.01           N  
ATOM   1102  CA  ALA   152      30.003   1.494  -7.945  1.00 51.04           C  
ATOM   1103  C   ALA   152      31.442   1.116  -8.305  1.00 53.77           C  
ATOM   1104  O   ALA   152      31.685   0.143  -9.005  1.00 60.02           O  
ATOM   1105  CB  ALA   152      29.575   2.740  -8.712  1.00 52.32           C  
ATOM   1106  N   LYS   153      32.398   1.805  -7.706  1.00 54.40           N  
ATOM   1107  CA  LYS   153      33.807   1.695  -8.037  1.00 53.36           C  
ATOM   1108  C   LYS   153      34.665   0.702  -7.258  1.00 55.14           C  
ATOM   1109  O   LYS   153      35.620   0.158  -7.812  1.00 57.79           O  
ATOM   1110  CB  LYS   153      34.377   3.115  -7.900  1.00 54.63           C  
ATOM   1111  CG  LYS   153      35.746   3.330  -8.418  1.00 58.39           C  
ATOM   1112  CD  LYS   153      36.106   4.819  -8.468  1.00 52.71           C  
ATOM   1113  CE  LYS   153      37.502   4.973  -9.105  1.00 61.35           C  
ATOM   1114  NZ  LYS   153      37.926   6.379  -9.270  1.00 66.54           N  
ATOM   1115  N   ARG   154      34.395   0.477  -5.980  1.00 54.31           N  
ATOM   1116  CA  ARG   154      35.188  -0.505  -5.228  1.00 54.23           C  
ATOM   1117  C   ARG   154      34.476  -1.840  -4.948  1.00 55.81           C  
ATOM   1118  O   ARG   154      34.992  -2.916  -5.324  1.00 57.05           O  
ATOM   1119  CB  ARG   154      35.708   0.073  -3.925  1.00 54.10           C  
ATOM   1120  CG  ARG   154      36.583   1.271  -4.109  1.00 57.75           C  
ATOM   1121  CD  ARG   154      37.445   1.469  -2.909  1.00 70.09           C  
ATOM   1122  NE  ARG   154      38.334   0.318  -2.732  1.00 74.67           N  
ATOM   1123  CZ  ARG   154      39.451   0.100  -3.430  1.00 77.44           C  
ATOM   1124  NH1 ARG   154      39.846   0.949  -4.379  1.00 81.46           N  
ATOM   1125  NH2 ARG   154      40.178  -0.983  -3.187  1.00 76.63           N  
ATOM   1126  N   TYR   155      33.295  -1.785  -4.322  0.50 54.71           N  
ATOM   1128  CA  TYR   155      32.536  -3.010  -4.014  0.50 53.40           C  
ATOM   1130  C   TYR   155      32.141  -3.747  -5.269  0.50 54.30           C  
ATOM   1132  O   TYR   155      32.419  -4.925  -5.428  0.50 53.99           O  
ATOM   1134  CB  TYR   155      31.255  -2.734  -3.218  0.50 51.83           C  
ATOM   1136  CG  TYR   155      30.583  -4.021  -2.795  0.50 43.29           C  
ATOM   1138  CD1 TYR   155      31.041  -4.726  -1.709  0.50 41.08           C  
ATOM   1140  CD2 TYR   155      29.518  -4.539  -3.500  0.50 48.09           C  
ATOM   1142  CE1 TYR   155      30.462  -5.905  -1.330  0.50 48.06           C  
ATOM   1144  CE2 TYR   155      28.924  -5.719  -3.138  0.50 42.41           C  
ATOM   1146  CZ  TYR   155      29.397  -6.402  -2.040  0.50 45.37           C  
ATOM   1148  OH  TYR   155      28.828  -7.589  -1.643  0.50 44.65           O  
ATOM   1150  N   LEU   156      31.501  -3.034  -6.177  1.00 55.32           N  
ATOM   1151  CA  LEU   156      31.031  -3.657  -7.435  1.00 56.06           C  
ATOM   1152  C   LEU   156      32.119  -3.608  -8.588  1.00 57.02           C  
ATOM   1153  O   LEU   156      31.785  -3.715  -9.780  1.00 59.87           O  
ATOM   1154  CB  LEU   156      29.713  -2.989  -7.882  1.00 55.67           C  
ATOM   1155  CG  LEU   156      28.350  -3.341  -7.236  1.00 60.67           C  
ATOM   1156  CD1 LEU   156      28.451  -3.636  -5.794  1.00 66.28           C  
ATOM   1157  CD2 LEU   156      27.290  -2.228  -7.457  1.00 57.19           C  
ATOM   1158  N   ALA   157      33.400  -3.468  -8.226  1.00 56.54           N  
ATOM   1159  CA  ALA   157      34.521  -3.350  -9.184  1.00 56.55           C  
ATOM   1160  C   ALA   157      34.622  -4.450 -10.263  1.00 59.66           C  
ATOM   1161  O   ALA   157      34.781  -4.134 -11.446  1.00 61.89           O  
ATOM   1162  CB  ALA   157      35.839  -3.295  -8.418  1.00 55.50           C  
ATOM   1163  N   LEU   158      34.555  -5.728  -9.864  1.00 56.71           N  
ATOM   1164  CA  LEU   158      34.674  -6.827 -10.825  1.00 55.58           C  
ATOM   1165  C   LEU   158      33.330  -7.304 -11.373  1.00 53.88           C  
ATOM   1166  O   LEU   158      33.243  -8.387 -11.927  1.00 54.06           O  
ATOM   1167  CB  LEU   158      35.522  -7.974 -10.251  1.00 52.64           C  
ATOM   1168  CG  LEU   158      36.933  -7.510  -9.841  1.00 55.52           C  
ATOM   1169  CD1 LEU   158      37.710  -8.657  -9.185  1.00 48.73           C  
ATOM   1170  CD2 LEU   158      37.732  -6.940 -11.023  1.00 52.52           C  
ATOM   1171  N   CYS   159      32.288  -6.496 -11.200  1.00 56.59           N  
ATOM   1172  CA  CYS   159      30.969  -6.723 -11.822  1.00 59.68           C  
ATOM   1173  C   CYS   159      30.829  -5.783 -12.996  1.00 61.90           C  
ATOM   1174  O   CYS   159      31.402  -4.686 -13.006  1.00 62.77           O  
ATOM   1175  CB  CYS   159      29.800  -6.251 -10.943  1.00 61.49           C  
ATOM   1176  SG  CYS   159      29.435  -7.136  -9.519  1.00 64.20           S  
ATOM   1177  N   GLU   160      29.971  -6.169 -13.921  1.00 61.80           N  
ATOM   1178  CA  GLU   160      29.610  -5.314 -15.002  1.00 63.32           C  
ATOM   1179  C   GLU   160      28.327  -4.673 -14.491  1.00 59.95           C  
ATOM   1180  O   GLU   160      27.312  -5.341 -14.330  1.00 58.39           O  
ATOM   1181  CB  GLU   160      29.344  -6.146 -16.256  1.00 65.37           C  
ATOM   1182  CG  GLU   160      29.285  -5.391 -17.590  1.00 70.26           C  
ATOM   1183  CD  GLU   160      28.942  -6.339 -18.739  1.00 72.53           C  
ATOM   1184  OE1 GLU   160      27.785  -6.829 -18.776  1.00 88.10           O  
ATOM   1185  OE2 GLU   160      29.825  -6.598 -19.602  1.00 88.52           O  
ATOM   1186  N   ILE   161      28.384  -3.387 -14.175  1.00 59.80           N  
ATOM   1187  CA  ILE   161      27.187  -2.659 -13.768  1.00 57.54           C  
ATOM   1188  C   ILE   161      26.499  -2.299 -15.053  1.00 58.17           C  
ATOM   1189  O   ILE   161      27.023  -1.517 -15.833  1.00 60.25           O  
ATOM   1190  CB  ILE   161      27.495  -1.412 -12.991  1.00 56.04           C  
ATOM   1191  CG1 ILE   161      28.227  -1.781 -11.711  1.00 52.54           C  
ATOM   1192  CG2 ILE   161      26.190  -0.668 -12.657  1.00 55.86           C  
ATOM   1193  CD1 ILE   161      28.695  -0.602 -10.903  1.00 50.27           C  
ATOM   1194  N   GLU   162      25.334  -2.887 -15.275  1.00 57.24           N  
ATOM   1195  CA  GLU   162      24.576  -2.677 -16.487  1.00 58.11           C  
ATOM   1196  C   GLU   162      23.718  -1.408 -16.454  1.00 57.49           C  
ATOM   1197  O   GLU   162      23.480  -0.797 -17.494  1.00 59.56           O  
ATOM   1198  CB  GLU   162      23.697  -3.889 -16.727  1.00 57.98           C  
ATOM   1199  CG  GLU   162      24.499  -5.191 -16.812  1.00 62.57           C  
ATOM   1200  CD  GLU   162      23.610  -6.411 -16.803  1.00 64.20           C  
ATOM   1201  OE1 GLU   162      22.363  -6.256 -16.710  1.00 79.58           O  
ATOM   1202  OE2 GLU   162      24.159  -7.536 -16.893  1.00 79.67           O  
ATOM   1203  N   SER   163      23.227  -1.024 -15.281  1.00 55.55           N  
ATOM   1204  CA  SER   163      22.434   0.196 -15.163  1.00 53.26           C  
ATOM   1205  C   SER   163      22.339   0.681 -13.745  1.00 53.60           C  
ATOM   1206  O   SER   163      22.535  -0.078 -12.796  1.00 51.06           O  
ATOM   1207  CB  SER   163      21.015  -0.012 -15.689  1.00 54.07           C  
ATOM   1208  OG  SER   163      20.234  -0.788 -14.798  1.00 55.86           O  
ATOM   1209  N   VAL   164      22.066   1.972 -13.619  1.00 53.90           N  
ATOM   1210  CA  VAL   164      21.791   2.593 -12.351  1.00 52.14           C  
ATOM   1211  C   VAL   164      20.548   3.461 -12.555  1.00 53.15           C  
ATOM   1212  O   VAL   164      20.476   4.212 -13.504  1.00 53.64           O  
ATOM   1213  CB  VAL   164      22.943   3.463 -11.847  1.00 53.97           C  
ATOM   1214  CG1 VAL   164      22.580   4.024 -10.475  1.00 47.02           C  
ATOM   1215  CG2 VAL   164      24.252   2.669 -11.801  1.00 49.17           C  
ATOM   1216  N   LYS   165      19.550   3.286 -11.700  1.00 50.54           N  
ATOM   1217  CA  LYS   165      18.361   4.096 -11.694  1.00 50.85           C  
ATOM   1218  C   LYS   165      18.305   4.638 -10.285  1.00 49.44           C  
ATOM   1219  O   LYS   165      18.298   3.869  -9.361  1.00 51.81           O  
ATOM   1220  CB  LYS   165      17.078   3.267 -11.907  1.00 48.82           C  
ATOM   1221  CG  LYS   165      16.852   2.702 -13.298  1.00 58.14           C  
ATOM   1222  CD  LYS   165      15.757   1.614 -13.278  1.00 56.98           C  
ATOM   1223  CE  LYS   165      15.609   0.870 -14.656  1.00 62.75           C  
ATOM   1224  N   GLY   166      18.215   5.940 -10.096  1.00 50.52           N  
ATOM   1225  CA  GLY   166      18.076   6.433  -8.737  1.00 52.09           C  
ATOM   1226  C   GLY   166      17.413   7.776  -8.608  1.00 50.03           C  
ATOM   1227  O   GLY   166      16.976   8.384  -9.574  1.00 50.54           O  
ATOM   1228  N   ILE   167      17.360   8.196  -7.363  1.00 50.68           N  
ATOM   1229  CA  ILE   167      16.806   9.440  -6.913  1.00 48.61           C  
ATOM   1230  C   ILE   167      18.001  10.209  -6.380  1.00 47.71           C  
ATOM   1231  O   ILE   167      18.515   9.831  -5.339  1.00 48.18           O  
ATOM   1232  CB  ILE   167      15.807   9.155  -5.766  1.00 48.07           C  
ATOM   1233  CG1 ILE   167      14.529   8.498  -6.338  1.00 50.59           C  
ATOM   1234  CG2 ILE   167      15.538  10.450  -4.952  1.00 43.73           C  
ATOM   1235  CD1 ILE   167      13.550   8.006  -5.275  1.00 50.03           C  
ATOM   1236  N   PHE   168      18.457  11.255  -7.076  1.00 49.17           N  
ATOM   1237  CA  PHE   168      19.643  11.994  -6.629  1.00 53.28           C  
ATOM   1238  C   PHE   168      19.449  13.446  -6.169  1.00 53.86           C  
ATOM   1239  O   PHE   168      20.428  14.171  -5.955  1.00 56.61           O  
ATOM   1240  CB  PHE   168      20.742  11.946  -7.665  1.00 55.25           C  
ATOM   1241  CG  PHE   168      21.126  10.555  -8.061  1.00 60.38           C  
ATOM   1242  CD1 PHE   168      21.444   9.618  -7.095  1.00 55.13           C  
ATOM   1243  CD2 PHE   168      21.242  10.209  -9.403  1.00 64.34           C  
ATOM   1244  CE1 PHE   168      21.818   8.343  -7.445  1.00 62.51           C  
ATOM   1245  CE2 PHE   168      21.631   8.925  -9.766  1.00 65.66           C  
ATOM   1246  CZ  PHE   168      21.889   7.986  -8.783  1.00 61.09           C  
ATOM   1247  N   ASN   169      18.208  13.835  -5.936  1.00 50.08           N  
ATOM   1248  CA  ASN   169      17.913  15.167  -5.468  1.00 49.52           C  
ATOM   1249  C   ASN   169      16.835  15.097  -4.392  1.00 49.88           C  
ATOM   1250  O   ASN   169      15.668  14.786  -4.680  1.00 47.54           O  
ATOM   1251  CB  ASN   169      17.444  16.047  -6.615  1.00 50.62           C  
ATOM   1252  CG  ASN   169      17.304  17.487  -6.203  1.00 56.69           C  
ATOM   1253  OD1 ASN   169      16.187  17.970  -5.928  1.00 59.40           O  
ATOM   1254  ND2 ASN   169      18.438  18.169  -6.081  1.00 49.38           N  
ATOM   1255  N   GLY   170      17.250  15.344  -3.149  1.00 49.57           N  
ATOM   1256  CA  GLY   170      16.328  15.345  -2.010  1.00 48.89           C  
ATOM   1257  C   GLY   170      15.186  16.344  -2.083  1.00 50.94           C  
ATOM   1258  O   GLY   170      14.064  16.056  -1.634  1.00 54.52           O  
ATOM   1259  N   THR   171      15.461  17.532  -2.608  1.00 51.55           N  
ATOM   1260  CA  THR   171      14.452  18.594  -2.699  1.00 51.75           C  
ATOM   1261  C   THR   171      13.273  18.219  -3.600  1.00 48.23           C  
ATOM   1262  O   THR   171      12.120  18.396  -3.208  1.00 51.94           O  
ATOM   1263  CB  THR   171      15.096  19.923  -3.121  1.00 51.47           C  
ATOM   1264  OG1 THR   171      16.043  20.287  -2.117  1.00 54.73           O  
ATOM   1265  CG2 THR   171      14.038  21.044  -3.258  1.00 49.75           C  
ATOM   1266  N   CYS   172      13.551  17.705  -4.788  1.00 47.31           N  
ATOM   1267  CA  CYS   172      12.497  17.214  -5.672  1.00 50.28           C  
ATOM   1268  C   CYS   172      11.789  16.024  -5.055  1.00 50.89           C  
ATOM   1269  O   CYS   172      10.593  15.883  -5.205  1.00 52.21           O  
ATOM   1270  CB  CYS   172      13.058  16.770  -7.016  1.00 51.40           C  
ATOM   1271  SG  CYS   172      13.781  18.090  -7.952  1.00 62.23           S  
ATOM   1272  N   ASN   173      12.520  15.163  -4.345  1.00 51.55           N  
ATOM   1273  CA  ASN   173      11.874  14.014  -3.749  1.00 50.79           C  
ATOM   1274  C   ASN   173      10.907  14.494  -2.683  1.00 49.78           C  
ATOM   1275  O   ASN   173       9.780  14.000  -2.573  1.00 51.45           O  
ATOM   1276  CB  ASN   173      12.862  12.977  -3.160  1.00 48.42           C  
ATOM   1277  CG  ASN   173      12.263  11.591  -3.178  1.00 49.97           C  
ATOM   1278  OD1 ASN   173      12.061  11.052  -4.259  1.00 50.87           O  
ATOM   1279  ND2 ASN   173      11.912  11.032  -2.010  1.00 48.67           N  
ATOM   1280  N   TYR   174      11.345  15.473  -1.910  1.00 48.66           N  
ATOM   1281  CA  TYR   174      10.493  16.058  -0.873  1.00 49.81           C  
ATOM   1282  C   TYR   174       9.258  16.724  -1.488  1.00 48.59           C  
ATOM   1283  O   TYR   174       8.148  16.559  -1.001  1.00 48.45           O  
ATOM   1284  CB  TYR   174      11.280  17.093  -0.040  1.00 50.52           C  
ATOM   1285  CG  TYR   174      10.400  17.838   0.950  1.00 54.37           C  
ATOM   1286  CD1 TYR   174      10.127  17.311   2.196  1.00 49.94           C  
ATOM   1287  CD2 TYR   174       9.821  19.058   0.610  1.00 54.64           C  
ATOM   1288  CE1 TYR   174       9.282  17.977   3.083  1.00 58.48           C  
ATOM   1289  CE2 TYR   174       9.005  19.735   1.476  1.00 51.60           C  
ATOM   1290  CZ  TYR   174       8.726  19.194   2.719  1.00 57.19           C  
ATOM   1291  OH  TYR   174       7.888  19.867   3.593  1.00 55.85           O  
ATOM   1292  N   ILE   175       9.463  17.510  -2.541  1.00 50.25           N  
ATOM   1293  CA  ILE   175       8.360  18.244  -3.157  1.00 51.12           C  
ATOM   1294  C   ILE   175       7.298  17.276  -3.693  1.00 49.03           C  
ATOM   1295  O   ILE   175       6.111  17.472  -3.486  1.00 47.68           O  
ATOM   1296  CB  ILE   175       8.845  19.265  -4.238  1.00 50.51           C  
ATOM   1297  CG1 ILE   175       9.587  20.428  -3.556  1.00 56.75           C  
ATOM   1298  CG2 ILE   175       7.646  19.785  -5.041  1.00 50.40           C  
ATOM   1299  CD1 ILE   175      10.293  21.433  -4.496  1.00 52.24           C  
ATOM   1300  N   LEU   176       7.746  16.224  -4.356  1.00 50.24           N  
ATOM   1301  CA  LEU   176       6.846  15.197  -4.892  1.00 48.11           C  
ATOM   1302  C   LEU   176       6.146  14.396  -3.775  1.00 47.17           C  
ATOM   1303  O   LEU   176       4.947  14.184  -3.846  1.00 47.47           O  
ATOM   1304  CB  LEU   176       7.610  14.299  -5.857  1.00 46.39           C  
ATOM   1305  CG  LEU   176       8.149  14.968  -7.122  1.00 50.90           C  
ATOM   1306  CD1 LEU   176       9.070  14.008  -7.864  1.00 47.93           C  
ATOM   1307  CD2 LEU   176       6.983  15.471  -8.048  1.00 40.04           C  
ATOM   1308  N   SER   177       6.876  13.961  -2.747  1.00 48.51           N  
ATOM   1309  CA  SER   177       6.260  13.258  -1.586  1.00 50.08           C  
ATOM   1310  C   SER   177       5.239  14.115  -0.880  1.00 47.81           C  
ATOM   1311  O   SER   177       4.202  13.645  -0.454  1.00 48.79           O  
ATOM   1312  CB  SER   177       7.300  12.921  -0.525  1.00 50.57           C  
ATOM   1313  OG  SER   177       8.221  12.006  -1.027  1.00 61.77           O  
ATOM   1314  N   ARG   178       5.583  15.380  -0.719  1.00 48.42           N  
ATOM   1315  CA  ARG   178       4.713  16.333  -0.051  1.00 47.43           C  
ATOM   1316  C   ARG   178       3.465  16.603  -0.904  1.00 46.52           C  
ATOM   1317  O   ARG   178       2.338  16.681  -0.393  1.00 45.49           O  
ATOM   1318  CB  ARG   178       5.493  17.621   0.221  1.00 47.04           C  
ATOM   1319  CG  ARG   178       4.848  18.508   1.208  1.00 56.97           C  
ATOM   1320  CD  ARG   178       5.183  18.038   2.594  1.00 68.09           C  
ATOM   1321  NE  ARG   178       4.508  18.837   3.606  1.00 68.53           N  
ATOM   1322  CZ  ARG   178       3.527  18.390   4.384  1.00 75.35           C  
ATOM   1323  NH1 ARG   178       3.128  17.121   4.313  1.00 77.00           N  
ATOM   1324  NH2 ARG   178       2.968  19.210   5.274  1.00 71.97           N  
ATOM   1325  N   MET   179       3.658  16.766  -2.208  1.00 47.62           N  
ATOM   1326  CA  MET   179       2.519  16.939  -3.122  1.00 48.36           C  
ATOM   1327  C   MET   179       1.618  15.713  -3.112  1.00 48.14           C  
ATOM   1328  O   MET   179       0.399  15.833  -3.217  1.00 51.18           O  
ATOM   1329  CB  MET   179       3.000  17.205  -4.542  1.00 45.91           C  
ATOM   1330  CG  MET   179       1.840  17.597  -5.483  1.00 56.49           C  
ATOM   1331  SD  MET   179       2.441  18.167  -7.258  0.75 54.81          SE  
ATOM   1332  CE  MET   179       3.997  19.219  -6.628  1.00 45.84           C  
ATOM   1333  N   GLU   180       2.210  14.528  -3.009  1.00 50.05           N  
ATOM   1334  CA  GLU   180       1.427  13.294  -2.941  1.00 51.64           C  
ATOM   1335  C   GLU   180       0.542  13.294  -1.715  1.00 49.64           C  
ATOM   1336  O   GLU   180      -0.611  12.941  -1.776  1.00 52.27           O  
ATOM   1337  CB  GLU   180       2.357  12.069  -2.866  1.00 51.90           C  
ATOM   1338  CG  GLU   180       1.658  10.718  -2.586  1.00 55.71           C  
ATOM   1339  CD  GLU   180       0.995  10.086  -3.817  1.00 66.02           C  
ATOM   1340  OE1 GLU   180      -0.195  10.339  -4.091  1.00 63.96           O  
ATOM   1341  OE2 GLU   180       1.665   9.268  -4.479  1.00 73.52           O  
ATOM   1342  N   GLU   181       1.101  13.697  -0.590  1.00 51.44           N  
ATOM   1343  CA  GLU   181       0.395  13.645   0.684  1.00 52.99           C  
ATOM   1344  C   GLU   181      -0.657  14.751   0.851  1.00 50.86           C  
ATOM   1345  O   GLU   181      -1.810  14.491   1.236  1.00 51.34           O  
ATOM   1346  CB  GLU   181       1.436  13.741   1.807  1.00 52.57           C  
ATOM   1347  CG  GLU   181       0.877  13.620   3.202  1.00 57.00           C  
ATOM   1348  CD  GLU   181       1.872  14.069   4.266  1.00 61.56           C  
ATOM   1349  OE1 GLU   181       3.071  14.272   3.921  1.00 76.08           O  
ATOM   1350  OE2 GLU   181       1.440  14.230   5.443  1.00 74.24           O  
ATOM   1351  N   GLU   182      -0.250  15.985   0.578  1.00 48.88           N  
ATOM   1352  CA  GLU   182      -1.125  17.139   0.748  1.00 47.99           C  
ATOM   1353  C   GLU   182      -2.036  17.408  -0.428  1.00 45.65           C  
ATOM   1354  O   GLU   182      -3.071  17.995  -0.243  1.00 43.85           O  
ATOM   1355  CB  GLU   182      -0.299  18.401   0.986  1.00 48.49           C  
ATOM   1356  CG  GLU   182       0.459  18.450   2.284  1.00 49.55           C  
ATOM   1357  CD  GLU   182       1.087  19.809   2.486  1.00 49.39           C  
ATOM   1358  OE1 GLU   182       2.133  20.060   1.866  1.00 57.73           O  
ATOM   1359  OE2 GLU   182       0.523  20.637   3.252  1.00 63.87           O  
ATOM   1360  N   ARG   183      -1.627  17.016  -1.635  1.00 47.50           N  
ATOM   1361  CA  ARG   183      -2.409  17.260  -2.848  1.00 46.60           C  
ATOM   1362  C   ARG   183      -2.627  18.761  -3.060  1.00 46.49           C  
ATOM   1363  O   ARG   183      -3.739  19.197  -3.345  1.00 45.39           O  
ATOM   1364  CB  ARG   183      -3.746  16.526  -2.785  1.00 46.84           C  
ATOM   1365  CG  ARG   183      -3.667  14.996  -2.917  1.00 50.98           C  
ATOM   1366  CD  ARG   183      -3.969  14.539  -4.367  1.00 60.13           C  
ATOM   1367  NE  ARG   183      -4.200  13.094  -4.504  1.00 49.76           N  
ATOM   1368  CZ  ARG   183      -3.221  12.221  -4.391  1.00 47.02           C  
ATOM   1369  NH1 ARG   183      -2.019  12.672  -4.106  1.00 42.53           N  
ATOM   1370  NH2 ARG   183      -3.439  10.925  -4.523  1.00 48.32           N  
ATOM   1371  N   LEU   184      -1.560  19.549  -2.937  1.00 46.90           N  
ATOM   1372  CA  LEU   184      -1.668  20.996  -3.130  1.00 48.03           C  
ATOM   1373  C   LEU   184      -0.774  21.392  -4.292  1.00 47.57           C  
ATOM   1374  O   LEU   184       0.155  20.676  -4.603  1.00 46.62           O  
ATOM   1375  CB  LEU   184      -1.320  21.766  -1.847  1.00 48.11           C  
ATOM   1376  CG  LEU   184      -2.272  21.591  -0.657  1.00 45.33           C  
ATOM   1377  CD1 LEU   184      -1.624  22.116   0.616  1.00 46.80           C  
ATOM   1378  CD2 LEU   184      -3.630  22.262  -0.909  1.00 42.37           C  
ATOM   1379  N   PRO   185      -1.075  22.524  -4.956  1.00 49.82           N  
ATOM   1380  CA  PRO   185      -0.326  22.941  -6.135  1.00 49.73           C  
ATOM   1381  C   PRO   185       1.167  23.068  -5.930  1.00 50.62           C  
ATOM   1382  O   PRO   185       1.633  23.337  -4.819  1.00 52.62           O  
ATOM   1383  CB  PRO   185      -0.927  24.310  -6.469  1.00 49.87           C  
ATOM   1384  CG  PRO   185      -2.269  24.269  -5.920  1.00 49.71           C  
ATOM   1385  CD  PRO   185      -2.161  23.473  -4.657  1.00 49.76           C  
ATOM   1386  N   TYR   186       1.906  22.900  -7.019  1.00 49.39           N  
ATOM   1387  CA  TYR   186       3.342  23.010  -6.975  1.00 49.71           C  
ATOM   1388  C   TYR   186       3.824  24.304  -6.315  1.00 48.74           C  
ATOM   1389  O   TYR   186       4.752  24.261  -5.496  1.00 49.05           O  
ATOM   1390  CB  TYR   186       3.951  22.845  -8.398  1.00 50.69           C  
ATOM   1391  CG  TYR   186       5.397  23.260  -8.475  1.00 51.42           C  
ATOM   1392  CD1 TYR   186       6.405  22.412  -8.061  1.00 51.78           C  
ATOM   1393  CD2 TYR   186       5.748  24.536  -8.926  1.00 54.64           C  
ATOM   1394  CE1 TYR   186       7.726  22.810  -8.111  1.00 56.91           C  
ATOM   1395  CE2 TYR   186       7.056  24.945  -8.961  1.00 49.56           C  
ATOM   1396  CZ  TYR   186       8.039  24.084  -8.555  1.00 52.76           C  
ATOM   1397  OH  TYR   186       9.349  24.487  -8.606  1.00 57.36           O  
ATOM   1398  N   GLU   187       3.229  25.443  -6.692  1.00 49.83           N  
ATOM   1399  CA  GLU   187       3.615  26.773  -6.155  1.00 50.15           C  
ATOM   1400  C   GLU   187       3.642  26.798  -4.611  1.00 50.21           C  
ATOM   1401  O   GLU   187       4.594  27.299  -4.002  1.00 50.99           O  
ATOM   1402  CB  GLU   187       2.692  27.871  -6.712  1.00 49.73           C  
ATOM   1403  N   HIS   188       2.601  26.220  -4.009  1.00 50.31           N  
ATOM   1404  CA  HIS   188       2.453  26.097  -2.565  1.00 50.29           C  
ATOM   1405  C   HIS   188       3.445  25.125  -1.913  1.00 50.89           C  
ATOM   1406  O   HIS   188       4.006  25.447  -0.865  1.00 49.57           O  
ATOM   1407  CB  HIS   188       1.049  25.611  -2.243  1.00 51.54           C  
ATOM   1408  CG  HIS   188       0.729  25.625  -0.782  1.00 57.63           C  
ATOM   1409  ND1 HIS   188       1.225  24.686   0.098  1.00 61.10           N  
ATOM   1410  CD2 HIS   188      -0.056  26.450  -0.049  1.00 58.91           C  
ATOM   1411  CE1 HIS   188       0.774  24.943   1.312  1.00 57.63           C  
ATOM   1412  NE2 HIS   188      -0.012  26.003   1.250  1.00 60.26           N  
ATOM   1413  N   ILE   189       3.653  23.941  -2.506  1.00 50.32           N  
ATOM   1414  CA  ILE   189       4.562  22.950  -1.921  1.00 50.34           C  
ATOM   1415  C   ILE   189       5.993  23.477  -2.014  1.00 53.25           C  
ATOM   1416  O   ILE   189       6.816  23.219  -1.131  1.00 54.26           O  
ATOM   1417  CB  ILE   189       4.474  21.550  -2.589  1.00 50.20           C  
ATOM   1418  CG1 ILE   189       3.048  20.984  -2.564  1.00 53.02           C  
ATOM   1419  CG2 ILE   189       5.414  20.583  -1.911  1.00 48.21           C  
ATOM   1420  CD1 ILE   189       2.486  20.718  -1.189  1.00 50.90           C  
ATOM   1421  N   LEU   190       6.301  24.195  -3.094  1.00 54.47           N  
ATOM   1422  CA  LEU   190       7.611  24.836  -3.241  1.00 54.56           C  
ATOM   1423  C   LEU   190       7.853  25.850  -2.119  1.00 56.21           C  
ATOM   1424  O   LEU   190       8.951  25.913  -1.591  1.00 55.77           O  
ATOM   1425  CB  LEU   190       7.738  25.529  -4.594  1.00 53.43           C  
ATOM   1426  CG  LEU   190       8.984  26.378  -4.847  1.00 53.95           C  
ATOM   1427  CD1 LEU   190      10.191  25.499  -4.858  1.00 54.46           C  
ATOM   1428  CD2 LEU   190       8.878  27.181  -6.145  1.00 53.20           C  
ATOM   1429  N   LYS   191       6.836  26.643  -1.764  1.00 59.35           N  
ATOM   1430  CA  LYS   191       6.970  27.625  -0.664  1.00 59.85           C  
ATOM   1431  C   LYS   191       7.256  26.942   0.675  1.00 62.71           C  
ATOM   1432  O   LYS   191       8.009  27.478   1.487  1.00 65.04           O  
ATOM   1433  CB  LYS   191       5.760  28.544  -0.565  1.00 59.39           C  
ATOM   1434  CG  LYS   191       5.594  29.462  -1.764  1.00 62.81           C  
ATOM   1435  N   GLU   192       6.667  25.766   0.901  1.00 64.24           N  
ATOM   1436  CA  GLU   192       6.983  24.973   2.093  1.00 65.95           C  
ATOM   1437  C   GLU   192       8.445  24.528   2.004  1.00 65.32           C  
ATOM   1438  O   GLU   192       9.215  24.662   2.951  1.00 66.59           O  
ATOM   1439  CB  GLU   192       6.114  23.722   2.189  1.00 66.21           C  
ATOM   1440  CG  GLU   192       4.627  23.967   2.325  1.00 68.09           C  
ATOM   1441  CD  GLU   192       3.848  22.657   2.393  1.00 68.34           C  
ATOM   1442  OE1 GLU   192       4.186  21.795   3.237  1.00 68.68           O  
ATOM   1443  OE2 GLU   192       2.892  22.493   1.604  1.00 72.99           O  
ATOM   1444  N   ALA   193       8.822  23.990   0.850  1.00 64.18           N  
ATOM   1445  CA  ALA   193      10.191  23.554   0.631  1.00 64.49           C  
ATOM   1446  C   ALA   193      11.188  24.699   0.926  1.00 65.36           C  
ATOM   1447  O   ALA   193      12.274  24.479   1.480  1.00 66.60           O  
ATOM   1448  CB  ALA   193      10.356  23.036  -0.788  1.00 63.88           C  
ATOM   1449  N   GLN   194      10.806  25.913   0.556  1.00 64.64           N  
ATOM   1450  CA  GLN   194      11.630  27.088   0.789  1.00 64.41           C  
ATOM   1451  C   GLN   194      11.662  27.458   2.279  1.00 65.12           C  
ATOM   1452  O   GLN   194      12.744  27.704   2.823  1.00 61.97           O  
ATOM   1453  CB  GLN   194      11.180  28.244  -0.123  1.00 63.16           C  
ATOM   1454  CG  GLN   194      11.572  27.983  -1.600  1.00 61.72           C  
ATOM   1455  CD  GLN   194      10.958  28.958  -2.585  1.00 58.96           C  
ATOM   1456  OE1 GLN   194       9.811  29.344  -2.449  1.00 49.46           O  
ATOM   1457  NE2 GLN   194      11.717  29.329  -3.605  1.00 50.16           N  
ATOM   1458  N   GLU   195      10.498  27.457   2.935  1.00 67.33           N  
ATOM   1459  CA  GLU   195      10.419  27.725   4.380  1.00 68.56           C  
ATOM   1460  C   GLU   195      11.315  26.735   5.150  1.00 70.71           C  
ATOM   1461  O   GLU   195      12.058  27.136   6.042  1.00 73.46           O  
ATOM   1462  CB  GLU   195       8.969  27.668   4.888  1.00 67.50           C  
ATOM   1463  N   LEU   196      11.272  25.456   4.781  1.00 72.16           N  
ATOM   1464  CA  LEU   196      12.104  24.409   5.424  1.00 71.93           C  
ATOM   1465  C   LEU   196      13.613  24.514   5.119  1.00 72.29           C  
ATOM   1466  O   LEU   196      14.428  23.867   5.782  1.00 72.44           O  
ATOM   1467  CB  LEU   196      11.602  23.001   5.032  1.00 72.75           C  
ATOM   1468  CG  LEU   196      10.386  22.463   5.785  1.00 73.55           C  
ATOM   1469  CD1 LEU   196      10.794  22.218   7.234  1.00 71.91           C  
ATOM   1470  CD2 LEU   196       9.164  23.396   5.711  1.00 80.49           C  
ATOM   1471  N   GLY   197      13.974  25.299   4.103  1.00 71.91           N  
ATOM   1472  CA  GLY   197      15.365  25.504   3.721  1.00 69.37           C  
ATOM   1473  C   GLY   197      15.841  24.542   2.662  1.00 71.28           C  
ATOM   1474  O   GLY   197      17.023  24.568   2.284  1.00 71.05           O  
ATOM   1475  N   TYR   198      14.943  23.690   2.158  1.00 71.91           N  
ATOM   1476  CA  TYR   198      15.350  22.701   1.151  1.00 70.29           C  
ATOM   1477  C   TYR   198      15.620  23.320  -0.211  1.00 68.90           C  
ATOM   1478  O   TYR   198      16.493  22.848  -0.935  1.00 69.01           O  
ATOM   1479  CB  TYR   198      14.334  21.569   1.003  1.00 70.32           C  
ATOM   1480  CG  TYR   198      14.013  20.843   2.282  1.00 71.40           C  
ATOM   1481  CD1 TYR   198      14.969  20.670   3.280  1.00 71.74           C  
ATOM   1482  CD2 TYR   198      12.770  20.255   2.460  1.00 70.09           C  
ATOM   1483  CE1 TYR   198      14.658  19.993   4.454  1.00 73.66           C  
ATOM   1484  CE2 TYR   198      12.463  19.571   3.610  1.00 69.46           C  
ATOM   1485  CZ  TYR   198      13.404  19.438   4.607  1.00 71.92           C  
ATOM   1486  OH  TYR   198      13.069  18.758   5.765  1.00 73.80           O  
ATOM   1487  N   ALA   199      14.862  24.357  -0.556  1.00 68.19           N  
ATOM   1488  CA  ALA   199      15.021  25.035  -1.829  1.00 66.85           C  
ATOM   1489  C   ALA   199      15.321  26.524  -1.634  1.00 66.32           C  
ATOM   1490  O   ALA   199      14.768  27.161  -0.738  1.00 64.86           O  
ATOM   1491  CB  ALA   199      13.753  24.841  -2.687  1.00 67.08           C  
ATOM   1492  N   GLU   200      16.197  27.053  -2.488  1.00 65.83           N  
ATOM   1493  CA  GLU   200      16.566  28.461  -2.496  1.00 67.83           C  
ATOM   1494  C   GLU   200      15.466  29.277  -3.185  1.00 68.19           C  
ATOM   1495  O   GLU   200      14.520  28.705  -3.757  1.00 65.69           O  
ATOM   1496  CB  GLU   200      17.908  28.669  -3.225  1.00 67.97           C  
ATOM   1497  CG  GLU   200      19.120  27.995  -2.549  1.00 72.33           C  
ATOM   1498  CD  GLU   200      20.349  27.924  -3.451  1.00 69.69           C  
ATOM   1499  N   ALA   201      15.607  30.610  -3.111  1.00 68.46           N  
ATOM   1500  CA  ALA   201      14.672  31.576  -3.717  1.00 68.54           C  
ATOM   1501  C   ALA   201      14.496  31.297  -5.200  1.00 68.47           C  
ATOM   1502  O   ALA   201      13.428  31.519  -5.758  1.00 68.13           O  
ATOM   1503  CB  ALA   201      15.165  33.006  -3.506  1.00 68.07           C  
ATOM   1504  N   ASP   202      15.586  30.866  -5.831  1.00 69.18           N  
ATOM   1505  CA  ASP   202      15.580  30.368  -7.202  1.00 68.04           C  
ATOM   1506  C   ASP   202      15.849  28.869  -7.019  1.00 64.63           C  
ATOM   1507  O   ASP   202      16.992  28.476  -6.817  1.00 62.25           O  
ATOM   1508  CB  ASP   202      16.676  31.025  -8.048  1.00 70.21           C  
ATOM   1509  CG  ASP   202      16.945  30.266  -9.352  1.00 79.05           C  
ATOM   1510  OD1 ASP   202      15.961  29.692  -9.892  1.00 78.98           O  
ATOM   1511  OD2 ASP   202      18.133  30.242  -9.813  1.00 76.93           O  
ATOM   1512  N   PRO   203      14.789  28.034  -7.056  1.00 63.72           N  
ATOM   1513  CA  PRO   203      14.898  26.580  -6.832  1.00 61.75           C  
ATOM   1514  C   PRO   203      15.229  25.740  -8.078  1.00 59.45           C  
ATOM   1515  O   PRO   203      15.237  24.521  -7.998  1.00 59.32           O  
ATOM   1516  CB  PRO   203      13.482  26.233  -6.353  1.00 61.07           C  
ATOM   1517  CG  PRO   203      12.622  27.105  -7.172  1.00 59.95           C  
ATOM   1518  CD  PRO   203      13.390  28.413  -7.351  1.00 63.64           C  
ATOM   1519  N   SER   204      15.447  26.412  -9.201  1.00 58.82           N  
ATOM   1520  CA  SER   204      15.723  25.858 -10.537  1.00 60.32           C  
ATOM   1521  C   SER   204      16.726  24.693 -10.641  1.00 58.74           C  
ATOM   1522  O   SER   204      16.479  23.682 -11.315  1.00 57.35           O  
ATOM   1523  CB  SER   204      16.203  27.042 -11.401  1.00 61.40           C  
ATOM   1524  OG  SER   204      16.597  26.650 -12.692  1.00 74.01           O  
ATOM   1525  N   TYR   205      17.871  24.859  -9.996  1.00 58.63           N  
ATOM   1526  CA  TYR   205      18.929  23.844  -9.958  1.00 58.51           C  
ATOM   1527  C   TYR   205      18.345  22.511  -9.489  1.00 56.16           C  
ATOM   1528  O   TYR   205      18.691  21.463 -10.007  1.00 52.02           O  
ATOM   1529  CB  TYR   205      20.009  24.334  -9.021  1.00 59.98           C  
ATOM   1530  CG  TYR   205      21.303  23.546  -8.918  1.00 66.63           C  
ATOM   1531  CD1 TYR   205      22.284  23.633  -9.926  1.00 58.78           C  
ATOM   1532  CD2 TYR   205      21.608  22.819  -7.744  1.00 69.11           C  
ATOM   1533  CE1 TYR   205      23.504  22.973  -9.798  1.00 64.53           C  
ATOM   1534  CE2 TYR   205      22.837  22.125  -7.610  1.00 68.87           C  
ATOM   1535  CZ  TYR   205      23.773  22.215  -8.639  1.00 71.51           C  
ATOM   1536  OH  TYR   205      24.970  21.573  -8.495  1.00 70.59           O  
ATOM   1537  N   ASP   206      17.409  22.570  -8.543  1.00 55.98           N  
ATOM   1538  CA  ASP   206      16.725  21.382  -8.071  1.00 54.69           C  
ATOM   1539  C   ASP   206      15.564  21.016  -8.983  1.00 54.42           C  
ATOM   1540  O   ASP   206      15.590  19.965  -9.606  1.00 54.38           O  
ATOM   1541  CB  ASP   206      16.173  21.563  -6.643  1.00 54.91           C  
ATOM   1542  CG  ASP   206      17.258  21.735  -5.592  1.00 55.86           C  
ATOM   1543  OD1 ASP   206      18.302  21.060  -5.674  1.00 61.04           O  
ATOM   1544  OD2 ASP   206      17.034  22.521  -4.645  1.00 64.32           O  
ATOM   1545  N   VAL   207      14.548  21.884  -9.040  1.00 52.94           N  
ATOM   1546  CA  VAL   207      13.286  21.567  -9.714  1.00 51.67           C  
ATOM   1547  C   VAL   207      13.301  21.354 -11.232  1.00 52.00           C  
ATOM   1548  O   VAL   207      12.367  20.748 -11.769  1.00 52.24           O  
ATOM   1549  CB  VAL   207      12.123  22.512  -9.272  1.00 52.21           C  
ATOM   1550  CG1 VAL   207      12.009  22.472  -7.741  1.00 45.97           C  
ATOM   1551  CG2 VAL   207      12.271  23.948  -9.823  1.00 47.72           C  
ATOM   1552  N   GLU   208      14.331  21.858 -11.911  1.00 52.85           N  
ATOM   1553  CA  GLU   208      14.482  21.642 -13.345  1.00 54.65           C  
ATOM   1554  C   GLU   208      15.363  20.399 -13.623  1.00 54.89           C  
ATOM   1555  O   GLU   208      15.709  20.113 -14.770  1.00 54.82           O  
ATOM   1556  CB  GLU   208      15.072  22.879 -14.037  1.00 52.72           C  
ATOM   1557  CG  GLU   208      14.282  24.159 -13.869  1.00 52.72           C  
ATOM   1558  CD  GLU   208      12.881  24.099 -14.478  1.00 53.88           C  
ATOM   1559  OE1 GLU   208      12.543  23.109 -15.164  1.00 50.07           O  
ATOM   1560  OE2 GLU   208      12.117  25.068 -14.280  1.00 57.93           O  
ATOM   1561  N   GLY   209      15.743  19.687 -12.565  1.00 56.82           N  
ATOM   1562  CA  GLY   209      16.528  18.452 -12.688  1.00 55.27           C  
ATOM   1563  C   GLY   209      18.003  18.604 -12.995  1.00 54.85           C  
ATOM   1564  O   GLY   209      18.652  17.625 -13.323  1.00 55.73           O  
ATOM   1565  N   ILE   210      18.542  19.821 -12.861  1.00 54.76           N  
ATOM   1566  CA  ILE   210      19.938  20.078 -13.186  1.00 54.36           C  
ATOM   1567  C   ILE   210      20.869  19.337 -12.215  1.00 53.25           C  
ATOM   1568  O   ILE   210      21.816  18.673 -12.622  1.00 52.64           O  
ATOM   1569  CB  ILE   210      20.291  21.605 -13.141  1.00 52.69           C  
ATOM   1570  CG1 ILE   210      19.380  22.462 -14.046  1.00 59.17           C  
ATOM   1571  CG2 ILE   210      21.751  21.828 -13.472  1.00 49.21           C  
ATOM   1572  CD1 ILE   210      19.444  22.148 -15.502  1.00 66.10           C  
ATOM   1573  N   ASP   211      20.618  19.479 -10.921  1.00 54.09           N  
ATOM   1574  CA  ASP   211      21.428  18.807  -9.892  1.00 51.97           C  
ATOM   1575  C   ASP   211      21.493  17.301 -10.113  1.00 49.67           C  
ATOM   1576  O   ASP   211      22.586  16.702 -10.113  1.00 51.24           O  
ATOM   1577  CB  ASP   211      20.846  19.123  -8.512  1.00 53.71           C  
ATOM   1578  CG  ASP   211      21.631  18.481  -7.370  1.00 55.47           C  
ATOM   1579  OD1 ASP   211      22.812  18.853  -7.180  1.00 55.59           O  
ATOM   1580  OD2 ASP   211      21.033  17.648  -6.633  1.00 58.46           O  
ATOM   1581  N   ALA   212      20.327  16.679 -10.309  1.00 48.11           N  
ATOM   1582  CA  ALA   212      20.238  15.237 -10.529  1.00 45.99           C  
ATOM   1583  C   ALA   212      21.009  14.799 -11.795  1.00 46.22           C  
ATOM   1584  O   ALA   212      21.658  13.743 -11.797  1.00 48.01           O  
ATOM   1585  CB  ALA   212      18.789  14.778 -10.612  1.00 43.79           C  
ATOM   1586  N   ALA   213      20.930  15.613 -12.836  1.00 43.54           N  
ATOM   1587  CA  ALA   213      21.603  15.326 -14.133  1.00 45.45           C  
ATOM   1588  C   ALA   213      23.138  15.428 -14.047  1.00 45.51           C  
ATOM   1589  O   ALA   213      23.840  14.670 -14.675  1.00 48.79           O  
ATOM   1590  CB  ALA   213      21.073  16.230 -15.185  1.00 42.66           C  
ATOM   1591  N   LEU   214      23.642  16.435 -13.335  1.00 46.63           N  
ATOM   1592  CA  LEU   214      25.075  16.566 -13.043  1.00 45.43           C  
ATOM   1593  C   LEU   214      25.588  15.300 -12.366  1.00 46.14           C  
ATOM   1594  O   LEU   214      26.591  14.722 -12.778  1.00 49.16           O  
ATOM   1595  CB  LEU   214      25.324  17.796 -12.168  1.00 48.56           C  
ATOM   1596  CG  LEU   214      25.104  19.180 -12.854  1.00 53.32           C  
ATOM   1597  CD1 LEU   214      25.037  20.368 -11.881  1.00 43.38           C  
ATOM   1598  CD2 LEU   214      26.140  19.444 -13.913  1.00 50.20           C  
ATOM   1599  N   LYS   215      24.876  14.864 -11.331  1.00 46.82           N  
ATOM   1600  CA  LYS   215      25.162  13.647 -10.580  1.00 45.75           C  
ATOM   1601  C   LYS   215      25.074  12.405 -11.442  1.00 47.88           C  
ATOM   1602  O   LYS   215      25.912  11.521 -11.321  1.00 49.56           O  
ATOM   1603  CB  LYS   215      24.183  13.547  -9.403  1.00 45.01           C  
ATOM   1604  CG  LYS   215      24.509  14.589  -8.295  1.00 50.10           C  
ATOM   1605  CD  LYS   215      23.415  14.675  -7.203  1.00 47.84           C  
ATOM   1606  CE  LYS   215      23.750  15.716  -6.145  1.00 48.71           C  
ATOM   1607  NZ  LYS   215      22.596  15.971  -5.201  1.00 46.57           N  
ATOM   1608  N   LEU   216      24.074  12.350 -12.327  1.00 47.48           N  
ATOM   1609  CA  LEU   216      23.907  11.245 -13.264  1.00 45.00           C  
ATOM   1610  C   LEU   216      25.121  11.167 -14.163  1.00 45.39           C  
ATOM   1611  O   LEU   216      25.597  10.072 -14.432  1.00 45.92           O  
ATOM   1612  CB  LEU   216      22.619  11.407 -14.114  1.00 43.78           C  
ATOM   1613  CG  LEU   216      22.337  10.265 -15.126  1.00 49.21           C  
ATOM   1614  CD1 LEU   216      22.286   8.883 -14.438  1.00 48.68           C  
ATOM   1615  CD2 LEU   216      21.096  10.551 -15.976  1.00 46.60           C  
ATOM   1616  N   VAL   217      25.642  12.313 -14.619  1.00 45.94           N  
ATOM   1617  CA  VAL   217      26.867  12.291 -15.450  1.00 47.16           C  
ATOM   1618  C   VAL   217      28.091  11.698 -14.696  1.00 47.12           C  
ATOM   1619  O   VAL   217      28.905  10.941 -15.254  1.00 45.73           O  
ATOM   1620  CB  VAL   217      27.214  13.691 -16.050  1.00 50.11           C  
ATOM   1621  CG1 VAL   217      28.552  13.659 -16.786  1.00 47.66           C  
ATOM   1622  CG2 VAL   217      26.103  14.167 -17.012  1.00 49.14           C  
ATOM   1623  N   ILE   218      28.220  12.056 -13.433  1.00 47.15           N  
ATOM   1624  CA  ILE   218      29.319  11.568 -12.622  1.00 48.08           C  
ATOM   1625  C   ILE   218      29.211  10.046 -12.488  1.00 47.79           C  
ATOM   1626  O   ILE   218      30.167   9.343 -12.742  1.00 48.88           O  
ATOM   1627  CB  ILE   218      29.338  12.277 -11.269  1.00 45.60           C  
ATOM   1628  CG1 ILE   218      29.710  13.744 -11.498  1.00 49.59           C  
ATOM   1629  CG2 ILE   218      30.280  11.563 -10.283  1.00 49.52           C  
ATOM   1630  CD1 ILE   218      29.738  14.603 -10.283  1.00 46.99           C  
ATOM   1631  N   ILE   219      28.019   9.559 -12.152  1.00 47.86           N  
ATOM   1632  CA  ILE   219      27.752   8.136 -12.022  1.00 47.51           C  
ATOM   1633  C   ILE   219      27.966   7.329 -13.304  1.00 48.65           C  
ATOM   1634  O   ILE   219      28.525   6.247 -13.254  1.00 46.75           O  
ATOM   1635  CB  ILE   219      26.325   7.884 -11.565  1.00 47.39           C  
ATOM   1636  CG1 ILE   219      26.167   8.369 -10.142  1.00 54.24           C  
ATOM   1637  CG2 ILE   219      26.008   6.405 -11.579  1.00 46.64           C  
ATOM   1638  CD1 ILE   219      24.762   8.300  -9.693  1.00 67.32           C  
ATOM   1639  N   ALA   220      27.448   7.840 -14.420  1.00 49.50           N  
ATOM   1640  CA  ALA   220      27.589   7.210 -15.733  1.00 47.31           C  
ATOM   1641  C   ALA   220      29.053   6.992 -15.974  1.00 46.34           C  
ATOM   1642  O   ALA   220      29.476   5.900 -16.280  1.00 48.33           O  
ATOM   1643  CB  ALA   220      26.996   8.113 -16.830  1.00 46.80           C  
ATOM   1644  N   ASN   221      29.841   8.045 -15.835  1.00 49.27           N  
ATOM   1645  CA  ASN   221      31.275   7.937 -16.036  1.00 49.43           C  
ATOM   1646  C   ASN   221      31.992   6.989 -15.073  1.00 48.47           C  
ATOM   1647  O   ASN   221      32.946   6.296 -15.464  1.00 48.69           O  
ATOM   1648  CB  ASN   221      31.919   9.332 -15.988  1.00 52.71           C  
ATOM   1649  CG  ASN   221      31.734  10.109 -17.297  1.00 54.77           C  
ATOM   1650  OD1 ASN   221      32.409   9.834 -18.299  1.00 55.54           O  
ATOM   1651  ND2 ASN   221      30.865  11.117 -17.269  1.00 51.91           N  
ATOM   1652  N   THR   222      31.556   6.979 -13.818  1.00 49.74           N  
ATOM   1653  CA  THR   222      32.152   6.126 -12.781  1.00 48.37           C  
ATOM   1654  C   THR   222      31.970   4.642 -13.142  1.00 47.02           C  
ATOM   1655  O   THR   222      32.849   3.842 -12.910  1.00 50.70           O  
ATOM   1656  CB  THR   222      31.548   6.442 -11.365  1.00 49.83           C  
ATOM   1657  OG1 THR   222      31.871   7.791 -10.976  1.00 47.96           O  
ATOM   1658  CG2 THR   222      32.084   5.501 -10.322  1.00 47.19           C  
ATOM   1659  N   ILE   223      30.841   4.296 -13.743  1.00 48.55           N  
ATOM   1660  CA  ILE   223      30.549   2.926 -14.121  1.00 48.58           C  
ATOM   1661  C   ILE   223      31.020   2.587 -15.542  1.00 49.45           C  
ATOM   1662  O   ILE   223      30.683   1.518 -16.068  1.00 50.54           O  
ATOM   1663  CB  ILE   223      29.035   2.536 -13.963  1.00 49.21           C  
ATOM   1664  CG1 ILE   223      28.150   3.202 -15.036  1.00 53.85           C  
ATOM   1665  CG2 ILE   223      28.507   2.838 -12.521  1.00 42.11           C  
ATOM   1666  CD1 ILE   223      26.711   2.618 -15.127  1.00 44.95           C  
ATOM   1667  N   GLY   224      31.784   3.468 -16.171  1.00 48.78           N  
ATOM   1668  CA  GLY   224      32.353   3.156 -17.506  1.00 47.84           C  
ATOM   1669  C   GLY   224      31.582   3.624 -18.721  1.00 49.39           C  
ATOM   1670  O   GLY   224      31.932   3.253 -19.834  1.00 50.20           O  
ATOM   1671  N   VAL   225      30.521   4.409 -18.523  1.00 50.37           N  
ATOM   1672  CA  VAL   225      29.749   4.972 -19.631  1.00 51.28           C  
ATOM   1673  C   VAL   225      30.218   6.425 -19.850  1.00 53.00           C  
ATOM   1674  O   VAL   225      29.899   7.310 -19.063  1.00 53.69           O  
ATOM   1675  CB  VAL   225      28.242   4.906 -19.342  1.00 52.17           C  
ATOM   1676  CG1 VAL   225      27.435   5.576 -20.441  1.00 52.80           C  
ATOM   1677  CG2 VAL   225      27.783   3.424 -19.177  1.00 48.22           C  
ATOM   1678  N   LYS   226      31.046   6.658 -20.870  1.00 52.56           N  
ATOM   1679  CA  LYS   226      31.503   8.019 -21.182  1.00 52.99           C  
ATOM   1680  C   LYS   226      30.235   8.850 -21.450  1.00 54.80           C  
ATOM   1681  O   LYS   226      29.377   8.462 -22.244  1.00 59.18           O  
ATOM   1682  CB  LYS   226      32.445   8.028 -22.396  1.00 48.62           C  
ATOM   1683  N   ALA   227      30.079   9.956 -20.747  1.00 53.19           N  
ATOM   1684  CA  ALA   227      28.902  10.780 -20.915  1.00 51.60           C  
ATOM   1685  C   ALA   227      29.222  12.223 -20.595  1.00 50.01           C  
ATOM   1686  O   ALA   227      30.017  12.500 -19.713  1.00 47.38           O  
ATOM   1687  CB  ALA   227      27.754  10.282 -19.982  1.00 48.88           C  
ATOM   1688  N   SER   228      28.600  13.137 -21.337  1.00 51.41           N  
ATOM   1689  CA  SER   228      28.678  14.567 -21.064  1.00 51.50           C  
ATOM   1690  C   SER   228      27.276  15.047 -20.658  1.00 48.76           C  
ATOM   1691  O   SER   228      26.305  14.323 -20.819  1.00 47.86           O  
ATOM   1692  CB  SER   228      29.170  15.301 -22.300  1.00 52.99           C  
ATOM   1693  OG  SER   228      28.314  15.003 -23.387  1.00 69.90           O  
ATOM   1694  N   TYR   229      27.171  16.252 -20.107  1.00 48.74           N  
ATOM   1695  CA  TYR   229      25.865  16.800 -19.734  1.00 48.29           C  
ATOM   1696  C   TYR   229      24.890  16.855 -20.940  1.00 48.25           C  
ATOM   1697  O   TYR   229      23.708  16.575 -20.798  1.00 47.01           O  
ATOM   1698  CB  TYR   229      26.006  18.203 -19.101  1.00 48.01           C  
ATOM   1699  CG  TYR   229      24.718  18.650 -18.473  1.00 49.61           C  
ATOM   1700  CD1 TYR   229      23.719  19.281 -19.229  1.00 48.16           C  
ATOM   1701  CD2 TYR   229      24.476  18.403 -17.128  1.00 47.46           C  
ATOM   1702  CE1 TYR   229      22.505  19.635 -18.642  1.00 47.96           C  
ATOM   1703  CE2 TYR   229      23.302  18.771 -16.549  1.00 46.96           C  
ATOM   1704  CZ  TYR   229      22.322  19.384 -17.303  1.00 47.60           C  
ATOM   1705  OH  TYR   229      21.150  19.690 -16.687  1.00 48.70           O  
ATOM   1706  N   GLU   230      25.390  17.199 -22.125  1.00 46.91           N  
ATOM   1707  CA  GLU   230      24.523  17.360 -23.279  1.00 51.69           C  
ATOM   1708  C   GLU   230      23.897  16.068 -23.740  1.00 51.62           C  
ATOM   1709  O   GLU   230      22.951  16.115 -24.529  1.00 52.91           O  
ATOM   1710  CB  GLU   230      25.267  17.991 -24.449  1.00 52.98           C  
ATOM   1711  CG  GLU   230      26.377  17.113 -25.003  1.00 59.12           C  
ATOM   1712  CD  GLU   230      27.116  17.758 -26.156  1.00 60.66           C  
ATOM   1713  OE1 GLU   230      26.703  18.862 -26.588  1.00 64.84           O  
ATOM   1714  OE2 GLU   230      28.104  17.141 -26.621  1.00 73.65           O  
ATOM   1715  N   ASP   231      24.432  14.936 -23.271  1.00 49.16           N  
ATOM   1716  CA  ASP   231      23.905  13.619 -23.603  1.00 48.16           C  
ATOM   1717  C   ASP   231      22.683  13.247 -22.771  1.00 47.73           C  
ATOM   1718  O   ASP   231      21.976  12.344 -23.136  1.00 48.39           O  
ATOM   1719  CB  ASP   231      24.976  12.526 -23.385  1.00 46.15           C  
ATOM   1720  CG  ASP   231      26.167  12.665 -24.301  1.00 51.11           C  
ATOM   1721  OD1 ASP   231      25.989  13.031 -25.473  1.00 60.41           O  
ATOM   1722  OD2 ASP   231      27.292  12.419 -23.848  1.00 54.74           O  
ATOM   1723  N   VAL   232      22.452  13.914 -21.642  1.00 48.20           N  
ATOM   1724  CA  VAL   232      21.338  13.577 -20.752  1.00 47.24           C  
ATOM   1725  C   VAL   232      20.055  14.265 -21.206  1.00 49.91           C  
ATOM   1726  O   VAL   232      20.080  15.431 -21.577  1.00 51.25           O  
ATOM   1727  CB  VAL   232      21.631  14.023 -19.295  1.00 50.55           C  
ATOM   1728  CG1 VAL   232      20.552  13.483 -18.336  1.00 41.85           C  
ATOM   1729  CG2 VAL   232      23.044  13.579 -18.852  1.00 47.15           C  
ATOM   1730  N   GLU   233      18.944  13.537 -21.239  1.00 48.85           N  
ATOM   1731  CA  GLU   233      17.648  14.149 -21.527  1.00 53.13           C  
ATOM   1732  C   GLU   233      17.132  14.530 -20.160  1.00 49.36           C  
ATOM   1733  O   GLU   233      16.885  13.648 -19.330  1.00 47.10           O  
ATOM   1734  CB  GLU   233      16.668  13.170 -22.132  1.00 54.59           C  
ATOM   1735  CG  GLU   233      16.961  12.735 -23.549  1.00 65.54           C  
ATOM   1736  CD  GLU   233      15.904  11.725 -24.068  1.00 65.50           C  
ATOM   1737  OE1 GLU   233      15.341  10.954 -23.234  1.00 66.60           O  
ATOM   1738  OE2 GLU   233      15.659  11.718 -25.308  1.00 74.23           O  
ATOM   1739  N   VAL   234      17.018  15.829 -19.910  1.00 49.46           N  
ATOM   1740  CA  VAL   234      16.619  16.350 -18.595  1.00 51.05           C  
ATOM   1741  C   VAL   234      15.191  16.925 -18.609  1.00 51.67           C  
ATOM   1742  O   VAL   234      14.884  17.749 -19.432  1.00 49.34           O  
ATOM   1743  CB  VAL   234      17.574  17.477 -18.150  1.00 51.02           C  
ATOM   1744  CG1 VAL   234      17.289  17.869 -16.680  1.00 53.81           C  
ATOM   1745  CG2 VAL   234      19.054  17.058 -18.306  1.00 47.25           C  
ATOM   1746  N   THR   235      14.339  16.479 -17.691  1.00 53.01           N  
ATOM   1747  CA  THR   235      12.985  17.024 -17.508  1.00 52.97           C  
ATOM   1748  C   THR   235      12.769  17.196 -16.000  1.00 51.14           C  
ATOM   1749  O   THR   235      13.036  16.296 -15.235  1.00 52.16           O  
ATOM   1750  CB  THR   235      11.902  16.077 -18.040  1.00 54.80           C  
ATOM   1751  OG1 THR   235      12.152  15.813 -19.409  1.00 51.05           O  
ATOM   1752  CG2 THR   235      10.514  16.681 -17.896  1.00 55.94           C  
ATOM   1753  N   GLY   236      12.313  18.374 -15.598  1.00 51.80           N  
ATOM   1754  CA  GLY   236      12.066  18.716 -14.194  1.00 53.90           C  
ATOM   1755  C   GLY   236      10.688  18.305 -13.707  1.00 52.14           C  
ATOM   1756  O   GLY   236       9.980  17.518 -14.380  1.00 51.12           O  
ATOM   1757  N   ILE   237      10.312  18.844 -12.550  1.00 51.45           N  
ATOM   1758  CA  ILE   237       9.046  18.470 -11.882  1.00 50.57           C  
ATOM   1759  C   ILE   237       7.962  19.527 -11.830  1.00 50.30           C  
ATOM   1760  O   ILE   237       6.879  19.296 -11.274  1.00 47.12           O  
ATOM   1761  CB  ILE   237       9.289  18.041 -10.404  1.00 50.11           C  
ATOM   1762  CG1 ILE   237       9.712  19.221  -9.521  1.00 52.04           C  
ATOM   1763  CG2 ILE   237      10.299  16.904 -10.330  1.00 47.51           C  
ATOM   1764  CD1 ILE   237       9.653  18.912  -7.994  1.00 47.30           C  
ATOM   1765  N   THR   238       8.227  20.676 -12.428  1.00 51.91           N  
ATOM   1766  CA  THR   238       7.322  21.804 -12.310  1.00 52.06           C  
ATOM   1767  C   THR   238       5.966  21.616 -12.996  1.00 51.29           C  
ATOM   1768  O   THR   238       5.079  22.411 -12.750  1.00 49.88           O  
ATOM   1769  CB  THR   238       7.992  23.079 -12.835  1.00 53.51           C  
ATOM   1770  OG1 THR   238       8.062  23.024 -14.263  1.00 53.36           O  
ATOM   1771  CG2 THR   238       9.384  23.208 -12.261  1.00 52.87           C  
ATOM   1772  N   GLN   239       5.806  20.593 -13.852  1.00 51.70           N  
ATOM   1773  CA  GLN   239       4.500  20.332 -14.506  1.00 51.14           C  
ATOM   1774  C   GLN   239       3.770  19.083 -13.956  1.00 50.90           C  
ATOM   1775  O   GLN   239       2.852  18.542 -14.606  1.00 50.87           O  
ATOM   1776  CB  GLN   239       4.651  20.213 -16.025  1.00 50.95           C  
ATOM   1777  CG  GLN   239       5.346  21.370 -16.684  1.00 49.53           C  
ATOM   1778  CD  GLN   239       4.687  22.714 -16.431  1.00 53.21           C  
ATOM   1779  OE1 GLN   239       3.488  22.914 -16.677  1.00 52.14           O  
ATOM   1780  NE2 GLN   239       5.489  23.661 -15.965  1.00 60.22           N  
ATOM   1781  N   ILE   240       4.187  18.627 -12.774  1.00 50.50           N  
ATOM   1782  CA  ILE   240       3.534  17.526 -12.068  1.00 49.76           C  
ATOM   1783  C   ILE   240       2.551  18.217 -11.127  1.00 49.62           C  
ATOM   1784  O   ILE   240       2.916  19.113 -10.366  1.00 50.34           O  
ATOM   1785  CB  ILE   240       4.531  16.637 -11.289  1.00 51.40           C  
ATOM   1786  CG1 ILE   240       5.580  16.030 -12.240  1.00 50.23           C  
ATOM   1787  CG2 ILE   240       3.794  15.516 -10.526  1.00 51.15           C  
ATOM   1788  CD1 ILE   240       5.047  15.071 -13.283  1.00 40.36           C  
ATOM   1789  N   THR   241       1.287  17.826 -11.231  1.00 48.18           N  
ATOM   1790  CA  THR   241       0.218  18.419 -10.464  1.00 44.92           C  
ATOM   1791  C   THR   241      -0.417  17.385  -9.522  1.00 45.39           C  
ATOM   1792  O   THR   241      -0.223  16.160  -9.666  1.00 48.75           O  
ATOM   1793  CB  THR   241      -0.903  18.900 -11.423  1.00 45.41           C  
ATOM   1794  OG1 THR   241      -1.461  17.762 -12.093  1.00 42.33           O  
ATOM   1795  CG2 THR   241      -0.385  19.906 -12.461  1.00 39.55           C  
ATOM   1796  N   PRO   242      -1.178  17.862  -8.540  1.00 43.72           N  
ATOM   1797  CA  PRO   242      -1.898  16.935  -7.697  1.00 42.02           C  
ATOM   1798  C   PRO   242      -2.739  15.965  -8.512  1.00 40.79           C  
ATOM   1799  O   PRO   242      -2.818  14.793  -8.167  1.00 40.36           O  
ATOM   1800  CB  PRO   242      -2.789  17.855  -6.875  1.00 45.16           C  
ATOM   1801  CG  PRO   242      -1.977  19.111  -6.759  1.00 40.89           C  
ATOM   1802  CD  PRO   242      -1.351  19.257  -8.098  1.00 43.85           C  
ATOM   1803  N   GLU   243      -3.326  16.439  -9.607  1.00 41.11           N  
ATOM   1804  CA  GLU   243      -4.181  15.595 -10.436  1.00 40.13           C  
ATOM   1805  C   GLU   243      -3.392  14.439 -11.052  1.00 40.44           C  
ATOM   1806  O   GLU   243      -3.890  13.332 -11.171  1.00 39.81           O  
ATOM   1807  CB  GLU   243      -4.916  16.436 -11.483  1.00 43.04           C  
ATOM   1808  CG  GLU   243      -5.965  15.667 -12.266  1.00 43.85           C  
ATOM   1809  CD  GLU   243      -6.988  14.994 -11.381  1.00 45.41           C  
ATOM   1810  OE1 GLU   243      -7.357  15.601 -10.365  1.00 41.82           O  
ATOM   1811  OE2 GLU   243      -7.443  13.874 -11.714  1.00 55.23           O  
ATOM   1812  N   ALA   244      -2.142  14.685 -11.401  1.00 40.95           N  
ATOM   1813  CA  ALA   244      -1.283  13.629 -11.875  1.00 42.78           C  
ATOM   1814  C   ALA   244      -1.108  12.543 -10.786  1.00 40.92           C  
ATOM   1815  O   ALA   244      -1.111  11.358 -11.086  1.00 41.81           O  
ATOM   1816  CB  ALA   244       0.125  14.216 -12.341  1.00 40.76           C  
ATOM   1817  N   PHE   245      -0.923  12.949  -9.537  1.00 42.02           N  
ATOM   1818  CA  PHE   245      -0.764  11.996  -8.432  1.00 41.77           C  
ATOM   1819  C   PHE   245      -2.051  11.208  -8.199  1.00 42.19           C  
ATOM   1820  O   PHE   245      -2.029  10.038  -7.840  1.00 47.13           O  
ATOM   1821  CB  PHE   245      -0.344  12.695  -7.121  1.00 42.89           C  
ATOM   1822  CG  PHE   245       1.125  12.972  -7.017  1.00 40.18           C  
ATOM   1823  CD1 PHE   245       1.991  11.972  -6.609  1.00 39.79           C  
ATOM   1824  CD2 PHE   245       1.640  14.247  -7.280  1.00 42.93           C  
ATOM   1825  CE1 PHE   245       3.358  12.220  -6.490  1.00 42.20           C  
ATOM   1826  CE2 PHE   245       2.994  14.499  -7.176  1.00 45.15           C  
ATOM   1827  CZ  PHE   245       3.860  13.478  -6.792  1.00 47.39           C  
ATOM   1828  N   GLN   246      -3.181  11.842  -8.408  1.00 41.99           N  
ATOM   1829  CA  GLN   246      -4.450  11.162  -8.233  1.00 41.40           C  
ATOM   1830  C   GLN   246      -4.657  10.066  -9.283  1.00 42.17           C  
ATOM   1831  O   GLN   246      -5.041   8.964  -8.938  1.00 44.25           O  
ATOM   1832  CB  GLN   246      -5.586  12.155  -8.301  1.00 38.86           C  
ATOM   1833  CG  GLN   246      -6.995  11.535  -8.182  1.00 39.79           C  
ATOM   1834  CD  GLN   246      -7.226  10.792  -6.872  1.00 39.15           C  
ATOM   1835  OE1 GLN   246      -6.626  11.101  -5.848  1.00 43.01           O  
ATOM   1836  NE2 GLN   246      -8.108   9.803  -6.909  1.00 40.19           N  
ATOM   1837  N   VAL   247      -4.403  10.354 -10.554  1.00 43.07           N  
ATOM   1838  CA  VAL   247      -4.644   9.347 -11.614  1.00 40.38           C  
ATOM   1839  C   VAL   247      -3.631   8.202 -11.505  1.00 40.18           C  
ATOM   1840  O   VAL   247      -3.953   7.047 -11.779  1.00 40.19           O  
ATOM   1841  CB  VAL   247      -4.683   9.963 -13.031  1.00 39.05           C  
ATOM   1842  CG1 VAL   247      -5.787  10.993 -13.100  1.00 35.51           C  
ATOM   1843  CG2 VAL   247      -3.361  10.586 -13.417  1.00 35.10           C  
ATOM   1844  N   ALA   248      -2.418   8.524 -11.081  1.00 41.55           N  
ATOM   1845  CA  ALA   248      -1.380   7.504 -10.858  1.00 43.61           C  
ATOM   1846  C   ALA   248      -1.725   6.612  -9.628  1.00 44.76           C  
ATOM   1847  O   ALA   248      -1.574   5.389  -9.671  1.00 45.16           O  
ATOM   1848  CB  ALA   248      -0.031   8.158 -10.698  1.00 39.93           C  
ATOM   1849  N   ALA   249      -2.221   7.231  -8.558  1.00 46.58           N  
ATOM   1850  CA  ALA   249      -2.593   6.516  -7.324  1.00 45.65           C  
ATOM   1851  C   ALA   249      -3.641   5.455  -7.600  1.00 45.82           C  
ATOM   1852  O   ALA   249      -3.556   4.343  -7.109  1.00 48.91           O  
ATOM   1853  CB  ALA   249      -3.098   7.493  -6.272  1.00 44.69           C  
ATOM   1854  N   GLU   250      -4.604   5.790  -8.442  1.00 46.64           N  
ATOM   1855  CA  GLU   250      -5.681   4.892  -8.778  1.00 44.96           C  
ATOM   1856  C   GLU   250      -5.190   3.582  -9.409  1.00 43.24           C  
ATOM   1857  O   GLU   250      -5.881   2.579  -9.352  1.00 43.54           O  
ATOM   1858  CB  GLU   250      -6.685   5.625  -9.684  1.00 44.73           C  
ATOM   1859  CG  GLU   250      -7.422   6.787  -8.970  1.00 46.14           C  
ATOM   1860  CD  GLU   250      -8.346   7.599  -9.889  1.00 49.43           C  
ATOM   1861  OE1 GLU   250      -8.366   7.356 -11.120  1.00 45.92           O  
ATOM   1862  OE2 GLU   250      -9.068   8.486  -9.372  1.00 59.08           O  
ATOM   1863  N   LYS   251      -3.984   3.578  -9.961  1.00 44.52           N  
ATOM   1864  CA  LYS   251      -3.406   2.384 -10.600  1.00 45.68           C  
ATOM   1865  C   LYS   251      -2.169   1.837  -9.853  1.00 48.30           C  
ATOM   1866  O   LYS   251      -1.402   1.056 -10.409  1.00 50.79           O  
ATOM   1867  CB  LYS   251      -3.034   2.707 -12.066  1.00 43.07           C  
ATOM   1868  CG  LYS   251      -4.193   3.318 -12.900  1.00 43.05           C  
ATOM   1869  CD  LYS   251      -5.392   2.388 -13.003  1.00 45.17           C  
ATOM   1870  CE  LYS   251      -6.557   2.995 -13.834  1.00 48.14           C  
ATOM   1871  N   GLY   252      -1.955   2.291  -8.622  1.00 48.48           N  
ATOM   1872  CA  GLY   252      -0.867   1.797  -7.782  1.00 47.58           C  
ATOM   1873  C   GLY   252       0.466   2.488  -7.861  1.00 48.28           C  
ATOM   1874  O   GLY   252       1.452   1.972  -7.316  1.00 47.63           O  
ATOM   1875  N   TYR   253       0.497   3.673  -8.473  1.00 46.78           N  
ATOM   1876  CA  TYR   253       1.734   4.393  -8.659  1.00 47.90           C  
ATOM   1877  C   TYR   253       1.828   5.714  -7.926  1.00 47.46           C  
ATOM   1878  O   TYR   253       0.847   6.393  -7.699  1.00 46.82           O  
ATOM   1879  CB  TYR   253       1.936   4.728 -10.139  1.00 49.96           C  
ATOM   1880  CG  TYR   253       1.994   3.555 -11.078  1.00 49.64           C  
ATOM   1881  CD1 TYR   253       3.191   2.906 -11.319  1.00 52.34           C  
ATOM   1882  CD2 TYR   253       0.861   3.108 -11.735  1.00 50.30           C  
ATOM   1883  CE1 TYR   253       3.265   1.824 -12.168  1.00 52.09           C  
ATOM   1884  CE2 TYR   253       0.915   2.030 -12.591  1.00 59.56           C  
ATOM   1885  CZ  TYR   253       2.127   1.382 -12.812  1.00 63.02           C  
ATOM   1886  OH  TYR   253       2.213   0.304 -13.682  1.00 58.75           O  
ATOM   1887  N   THR   254       3.054   6.059  -7.571  1.00 48.76           N  
ATOM   1888  CA  THR   254       3.372   7.392  -7.097  1.00 47.08           C  
ATOM   1889  C   THR   254       4.245   7.928  -8.228  1.00 49.16           C  
ATOM   1890  O   THR   254       4.402   7.259  -9.259  1.00 48.78           O  
ATOM   1891  CB  THR   254       4.072   7.429  -5.731  1.00 46.40           C  
ATOM   1892  OG1 THR   254       4.178   8.792  -5.330  1.00 42.73           O  
ATOM   1893  CG2 THR   254       5.444   6.781  -5.772  1.00 41.30           C  
ATOM   1894  N   ILE   255       4.780   9.130  -8.066  1.00 51.63           N  
ATOM   1895  CA  ILE   255       5.599   9.773  -9.103  1.00 49.60           C  
ATOM   1896  C   ILE   255       6.888  10.243  -8.454  1.00 50.49           C  
ATOM   1897  O   ILE   255       6.858  10.837  -7.367  1.00 47.75           O  
ATOM   1898  CB  ILE   255       4.891  11.000  -9.715  1.00 48.87           C  
ATOM   1899  CG1 ILE   255       3.530  10.607 -10.320  1.00 47.92           C  
ATOM   1900  CG2 ILE   255       5.777  11.660 -10.774  1.00 46.19           C  
ATOM   1901  CD1 ILE   255       2.656  11.771 -10.677  1.00 47.03           C  
ATOM   1902  N   ARG   256       8.011   9.986  -9.125  1.00 50.08           N  
ATOM   1903  CA  ARG   256       9.330  10.376  -8.613  1.00 50.31           C  
ATOM   1904  C   ARG   256      10.209  10.882  -9.721  1.00 49.70           C  
ATOM   1905  O   ARG   256      10.014  10.517 -10.874  1.00 50.83           O  
ATOM   1906  CB  ARG   256      10.002   9.153  -7.995  1.00 51.89           C  
ATOM   1907  CG  ARG   256       9.358   8.667  -6.706  1.00 53.29           C  
ATOM   1908  CD  ARG   256       9.722   9.572  -5.582  1.00 55.52           C  
ATOM   1909  NE  ARG   256       9.123   9.135  -4.334  1.00 55.85           N  
ATOM   1910  CZ  ARG   256       7.874   9.391  -3.947  1.00 54.21           C  
ATOM   1911  NH1 ARG   256       7.025  10.085  -4.709  1.00 56.43           N  
ATOM   1912  NH2 ARG   256       7.465   8.921  -2.780  1.00 59.54           N  
ATOM   1913  N   LEU   257      11.207  11.697  -9.383  1.00 51.04           N  
ATOM   1914  CA  LEU   257      12.173  12.161 -10.376  1.00 47.61           C  
ATOM   1915  C   LEU   257      13.278  11.112 -10.339  1.00 49.86           C  
ATOM   1916  O   LEU   257      13.995  10.959  -9.340  1.00 50.23           O  
ATOM   1917  CB  LEU   257      12.722  13.556 -10.073  1.00 47.72           C  
ATOM   1918  CG  LEU   257      13.746  14.106 -11.093  1.00 49.63           C  
ATOM   1919  CD1 LEU   257      13.060  14.484 -12.363  1.00 52.20           C  
ATOM   1920  CD2 LEU   257      14.508  15.303 -10.533  1.00 50.78           C  
ATOM   1921  N   ILE   258      13.407  10.392 -11.443  1.00 49.48           N  
ATOM   1922  CA  ILE   258      14.334   9.305 -11.546  1.00 50.05           C  
ATOM   1923  C   ILE   258      15.436   9.615 -12.550  1.00 50.57           C  
ATOM   1924  O   ILE   258      15.166  10.017 -13.692  1.00 50.24           O  
ATOM   1925  CB  ILE   258      13.600   7.972 -11.984  1.00 48.16           C  
ATOM   1926  CG1 ILE   258      12.490   7.570 -10.985  1.00 49.81           C  
ATOM   1927  CG2 ILE   258      14.567   6.829 -12.134  1.00 44.38           C  
ATOM   1928  CD1 ILE   258      12.970   7.197  -9.627  1.00 44.62           C  
ATOM   1929  N   ALA   259      16.674   9.393 -12.107  1.00 49.90           N  
ATOM   1930  CA  ALA   259      17.877   9.530 -12.937  1.00 50.69           C  
ATOM   1931  C   ALA   259      18.273   8.100 -13.356  1.00 50.89           C  
ATOM   1932  O   ALA   259      18.341   7.205 -12.511  1.00 50.11           O  
ATOM   1933  CB  ALA   259      19.039  10.257 -12.136  1.00 47.55           C  
ATOM   1934  N   GLU   260      18.501   7.880 -14.651  1.00 51.07           N  
ATOM   1935  CA  GLU   260      18.846   6.576 -15.138  1.00 52.95           C  
ATOM   1936  C   GLU   260      19.957   6.562 -16.149  1.00 50.27           C  
ATOM   1937  O   GLU   260      19.947   7.360 -17.070  1.00 54.09           O  
ATOM   1938  CB  GLU   260      17.610   5.915 -15.801  1.00 54.66           C  
ATOM   1939  CG  GLU   260      17.984   4.637 -16.571  1.00 56.10           C  
ATOM   1940  CD  GLU   260      16.811   3.823 -17.087  1.00 61.73           C  
ATOM   1941  OE1 GLU   260      15.656   4.100 -16.697  1.00 61.72           O  
ATOM   1942  OE2 GLU   260      17.063   2.893 -17.898  1.00 69.02           O  
ATOM   1943  N   VAL   261      20.909   5.639 -15.990  1.00 48.24           N  
ATOM   1944  CA  VAL   261      21.954   5.381 -16.989  1.00 48.31           C  
ATOM   1945  C   VAL   261      21.846   3.876 -17.266  1.00 51.87           C  
ATOM   1946  O   VAL   261      21.948   3.070 -16.352  1.00 51.60           O  
ATOM   1947  CB  VAL   261      23.425   5.795 -16.585  1.00 48.63           C  
ATOM   1948  CG1 VAL   261      23.837   5.279 -15.231  1.00 48.90           C  
ATOM   1949  CG2 VAL   261      24.421   5.316 -17.661  1.00 41.92           C  
ATOM   1950  N   SER   262      21.544   3.520 -18.506  1.00 53.92           N  
ATOM   1951  CA  SER   262      21.405   2.117 -18.961  1.00 54.45           C  
ATOM   1952  C   SER   262      21.855   2.099 -20.380  1.00 55.86           C  
ATOM   1953  O   SER   262      22.365   3.111 -20.863  1.00 57.01           O  
ATOM   1954  CB  SER   262      19.957   1.623 -18.892  1.00 54.67           C  
ATOM   1955  OG  SER   262      19.077   2.430 -19.661  1.00 59.40           O  
ATOM   1956  N   ARG   263      21.672   0.964 -21.045  1.00 59.14           N  
ATOM   1957  CA  ARG   263      22.034   0.802 -22.459  1.00 59.93           C  
ATOM   1958  C   ARG   263      21.059   1.632 -23.301  1.00 62.30           C  
ATOM   1959  O   ARG   263      21.455   2.339 -24.218  1.00 63.10           O  
ATOM   1960  CB  ARG   263      21.976  -0.692 -22.855  1.00 59.62           C  
ATOM   1961  CG  ARG   263      22.596  -1.039 -24.229  1.00 60.73           C  
ATOM   1962  N   GLU   264      19.781   1.566 -22.939  1.00 65.99           N  
ATOM   1963  CA  GLU   264      18.722   2.291 -23.633  1.00 68.06           C  
ATOM   1964  C   GLU   264      18.665   3.813 -23.330  1.00 69.57           C  
ATOM   1965  O   GLU   264      18.291   4.616 -24.199  1.00 70.88           O  
ATOM   1966  CB  GLU   264      17.363   1.661 -23.250  1.00 68.88           C  
ATOM   1967  N   LYS   265      19.079   4.206 -22.123  1.00 67.14           N  
ATOM   1968  CA  LYS   265      18.847   5.557 -21.641  1.00 65.36           C  
ATOM   1969  C   LYS   265      19.928   6.290 -20.858  1.00 60.82           C  
ATOM   1970  O   LYS   265      20.834   5.712 -20.273  1.00 56.75           O  
ATOM   1971  CB  LYS   265      17.634   5.474 -20.694  1.00 65.07           C  
ATOM   1972  CG  LYS   265      16.370   5.080 -21.410  1.00 67.60           C  
ATOM   1973  CD  LYS   265      15.201   4.860 -20.482  1.00 73.63           C  
ATOM   1974  CE  LYS   265      13.889   4.905 -21.267  1.00 79.42           C  
ATOM   1975  NZ  LYS   265      13.993   4.235 -22.594  1.00 74.09           N  
ATOM   1976  N   LEU   266      19.769   7.606 -20.862  1.00 56.90           N  
ATOM   1977  CA  LEU   266      20.560   8.522 -20.069  1.00 52.32           C  
ATOM   1978  C   LEU   266      19.590   9.686 -19.842  1.00 49.93           C  
ATOM   1979  O   LEU   266      19.467  10.576 -20.674  1.00 46.28           O  
ATOM   1980  CB  LEU   266      21.845   8.934 -20.793  1.00 49.25           C  
ATOM   1981  CG  LEU   266      22.812   9.786 -19.974  1.00 53.47           C  
ATOM   1982  CD1 LEU   266      23.260   9.026 -18.727  1.00 52.75           C  
ATOM   1983  CD2 LEU   266      24.012  10.263 -20.800  1.00 51.30           C  
ATOM   1984  N   LYS   267      18.834   9.633 -18.758  1.00 47.82           N  
ATOM   1985  CA  LYS   267      17.887  10.660 -18.510  1.00 51.06           C  
ATOM   1986  C   LYS   267      17.526  10.887 -17.072  1.00 49.84           C  
ATOM   1987  O   LYS   267      17.724  10.027 -16.200  1.00 49.24           O  
ATOM   1988  CB  LYS   267      16.598  10.390 -19.297  1.00 53.67           C  
ATOM   1989  CG  LYS   267      15.810   9.149 -18.924  1.00 60.78           C  
ATOM   1990  CD  LYS   267      14.541   8.944 -19.815  1.00 60.18           C  
ATOM   1991  CE  LYS   267      13.575  10.193 -19.966  1.00 76.63           C  
ATOM   1992  NZ  LYS   267      13.784  11.228 -21.118  1.00 67.91           N  
ATOM   1993  N   VAL   268      17.003  12.087 -16.860  1.00 49.68           N  
ATOM   1994  CA  VAL   268      16.426  12.519 -15.606  1.00 51.35           C  
ATOM   1995  C   VAL   268      15.037  13.025 -15.979  1.00 51.93           C  
ATOM   1996  O   VAL   268      14.903  13.866 -16.867  1.00 48.66           O  
ATOM   1997  CB  VAL   268      17.234  13.667 -14.963  1.00 52.83           C  
ATOM   1998  CG1 VAL   268      16.513  14.203 -13.740  1.00 49.39           C  
ATOM   1999  CG2 VAL   268      18.658  13.167 -14.599  1.00 47.14           C  
ATOM   2000  N   SER   269      14.010  12.457 -15.359  1.00 51.69           N  
ATOM   2001  CA  SER   269      12.653  12.879 -15.592  1.00 53.24           C  
ATOM   2002  C   SER   269      11.710  12.306 -14.563  1.00 53.14           C  
ATOM   2003  O   SER   269      12.048  11.354 -13.829  1.00 54.67           O  
ATOM   2004  CB  SER   269      12.152  12.423 -16.965  1.00 53.66           C  
ATOM   2005  OG  SER   269      12.163  11.010 -17.043  1.00 57.01           O  
ATOM   2006  N   PRO   270      10.522  12.919 -14.450  1.00 51.63           N  
ATOM   2007  CA  PRO   270       9.501  12.260 -13.627  1.00 52.74           C  
ATOM   2008  C   PRO   270       9.123  10.884 -14.204  1.00 51.85           C  
ATOM   2009  O   PRO   270       9.159  10.691 -15.414  1.00 53.70           O  
ATOM   2010  CB  PRO   270       8.330  13.226 -13.689  1.00 52.28           C  
ATOM   2011  CG  PRO   270       9.016  14.589 -13.893  1.00 53.95           C  
ATOM   2012  CD  PRO   270      10.110  14.258 -14.872  1.00 48.97           C  
ATOM   2013  N   ARG   271       8.723   9.969 -13.335  1.00 49.90           N  
ATOM   2014  CA  ARG   271       8.358   8.651 -13.730  1.00 53.06           C  
ATOM   2015  C   ARG   271       7.373   8.023 -12.742  1.00 50.72           C  
ATOM   2016  O   ARG   271       7.444   8.310 -11.557  1.00 50.11           O  
ATOM   2017  CB  ARG   271       9.624   7.817 -13.760  1.00 54.71           C  
ATOM   2018  CG  ARG   271       9.445   6.443 -14.341  1.00 60.14           C  
ATOM   2019  CD  ARG   271      10.752   5.656 -14.346  1.00 60.69           C  
ATOM   2020  NE  ARG   271      11.780   6.259 -15.198  1.00 63.06           N  
ATOM   2021  CZ  ARG   271      12.936   5.661 -15.502  1.00 68.10           C  
ATOM   2022  NH1 ARG   271      13.195   4.432 -15.042  1.00 61.75           N  
ATOM   2023  NH2 ARG   271      13.827   6.274 -16.296  1.00 63.05           N  
ATOM   2024  N   LEU   272       6.461   7.173 -13.243  1.00 49.75           N  
ATOM   2025  CA  LEU   272       5.549   6.418 -12.381  1.00 50.07           C  
ATOM   2026  C   LEU   272       6.342   5.288 -11.692  1.00 52.05           C  
ATOM   2027  O   LEU   272       7.090   4.570 -12.348  1.00 56.31           O  
ATOM   2028  CB  LEU   272       4.385   5.853 -13.165  1.00 47.30           C  
ATOM   2029  CG  LEU   272       3.434   6.882 -13.793  1.00 46.63           C  
ATOM   2030  CD1 LEU   272       2.246   6.223 -14.527  1.00 40.52           C  
ATOM   2031  CD2 LEU   272       2.954   7.860 -12.713  1.00 40.96           C  
ATOM   2032  N   VAL   273       6.201   5.181 -10.374  1.00 51.42           N  
ATOM   2033  CA  VAL   273       6.858   4.165  -9.560  1.00 51.89           C  
ATOM   2034  C   VAL   273       5.812   3.483  -8.666  1.00 53.90           C  
ATOM   2035  O   VAL   273       5.110   4.174  -7.912  1.00 55.96           O  
ATOM   2036  CB  VAL   273       7.916   4.799  -8.620  1.00 53.50           C  
ATOM   2037  CG1 VAL   273       8.583   3.717  -7.749  1.00 49.92           C  
ATOM   2038  CG2 VAL   273       8.955   5.633  -9.421  1.00 47.84           C  
ATOM   2039  N   PRO   274       5.675   2.135  -8.755  1.00 52.64           N  
ATOM   2040  CA  PRO   274       4.728   1.432  -7.891  1.00 53.96           C  
ATOM   2041  C   PRO   274       4.977   1.737  -6.425  1.00 54.64           C  
ATOM   2042  O   PRO   274       6.127   1.797  -6.004  1.00 54.38           O  
ATOM   2043  CB  PRO   274       4.995  -0.035  -8.194  1.00 53.52           C  
ATOM   2044  CG  PRO   274       5.512  -0.028  -9.586  1.00 51.92           C  
ATOM   2045  CD  PRO   274       6.332   1.208  -9.692  1.00 53.02           C  
ATOM   2046  N   PHE   275       3.899   1.932  -5.675  1.00 54.72           N  
ATOM   2047  CA  PHE   275       3.974   2.293  -4.272  1.00 55.62           C  
ATOM   2048  C   PHE   275       4.891   1.449  -3.413  1.00 58.81           C  
ATOM   2049  O   PHE   275       5.520   1.943  -2.483  1.00 60.70           O  
ATOM   2050  CB  PHE   275       2.588   2.209  -3.655  1.00 57.01           C  
ATOM   2051  CG  PHE   275       1.686   3.318  -4.045  1.00 55.28           C  
ATOM   2052  CD1 PHE   275       2.029   4.624  -3.764  1.00 56.36           C  
ATOM   2053  CD2 PHE   275       0.454   3.057  -4.604  1.00 55.16           C  
ATOM   2054  CE1 PHE   275       1.184   5.657  -4.092  1.00 59.77           C  
ATOM   2055  CE2 PHE   275      -0.402   4.086  -4.922  1.00 58.80           C  
ATOM   2056  CZ  PHE   275      -0.037   5.391  -4.666  1.00 54.00           C  
ATOM   2057  N   HIS   276       4.944   0.160  -3.681  1.00 63.00           N  
ATOM   2058  CA  HIS   276       5.792  -0.693  -2.857  1.00 66.83           C  
ATOM   2059  C   HIS   276       7.177  -0.994  -3.461  1.00 66.08           C  
ATOM   2060  O   HIS   276       7.884  -1.870  -2.970  1.00 68.94           O  
ATOM   2061  CB  HIS   276       5.045  -1.990  -2.492  1.00 69.40           C  
ATOM   2062  CG  HIS   276       3.897  -1.777  -1.545  1.00 77.16           C  
ATOM   2063  ND1 HIS   276       2.577  -1.957  -1.910  1.00 84.07           N  
ATOM   2064  CD2 HIS   276       3.879  -1.381  -0.251  1.00 76.56           C  
ATOM   2065  CE1 HIS   276       1.800  -1.695  -0.873  1.00 86.57           C  
ATOM   2066  NE2 HIS   276       2.565  -1.339   0.143  1.00 82.10           N  
ATOM   2067  N   HIS   277       7.551  -0.272  -4.528  0.50 63.14           N  
ATOM   2069  CA  HIS   277       8.868  -0.436  -5.158  0.50 61.64           C  
ATOM   2071  C   HIS   277       9.907   0.297  -4.304  0.50 59.06           C  
ATOM   2073  O   HIS   277       9.579   1.288  -3.648  0.50 57.93           O  
ATOM   2075  CB  HIS   277       8.892   0.092  -6.606  0.50 60.27           C  
ATOM   2077  CG  HIS   277      10.214  -0.095  -7.300  0.50 60.02           C  
ATOM   2079  ND1 HIS   277      11.153   0.911  -7.410  0.50 40.88           N  
ATOM   2081  CD2 HIS   277      10.760  -1.182  -7.896  0.50 56.22           C  
ATOM   2083  CE1 HIS   277      12.226   0.446  -8.026  0.50 44.71           C  
ATOM   2085  NE2 HIS   277      12.015  -0.820  -8.332  0.50 55.69           N  
ATOM   2087  N   PRO   278      11.150  -0.214  -4.260  1.00 57.57           N  
ATOM   2088  CA  PRO   278      12.187   0.488  -3.504  1.00 55.58           C  
ATOM   2089  C   PRO   278      12.443   1.954  -3.879  1.00 53.90           C  
ATOM   2090  O   PRO   278      12.796   2.721  -3.013  1.00 55.60           O  
ATOM   2091  CB  PRO   278      13.427  -0.369  -3.747  1.00 54.22           C  
ATOM   2092  CG  PRO   278      12.895  -1.721  -3.973  1.00 54.80           C  
ATOM   2093  CD  PRO   278      11.685  -1.478  -4.812  1.00 57.70           C  
ATOM   2094  N   LEU   279      12.219   2.352  -5.123  1.00 52.42           N  
ATOM   2095  CA  LEU   279      12.427   3.737  -5.518  1.00 53.39           C  
ATOM   2096  C   LEU   279      11.205   4.624  -5.231  1.00 54.49           C  
ATOM   2097  O   LEU   279      11.191   5.766  -5.658  1.00 55.60           O  
ATOM   2098  CB  LEU   279      12.864   3.842  -6.983  1.00 52.72           C  
ATOM   2099  CG  LEU   279      14.279   3.350  -7.343  1.00 59.22           C  
ATOM   2100  CD1 LEU   279      14.465   3.288  -8.857  1.00 50.14           C  
ATOM   2101  CD2 LEU   279      15.331   4.266  -6.687  1.00 47.94           C  
ATOM   2102  N   ALA   280      10.207   4.121  -4.489  1.00 57.24           N  
ATOM   2103  CA  ALA   280       9.030   4.925  -4.056  1.00 56.16           C  
ATOM   2104  C   ALA   280       9.281   5.644  -2.719  1.00 57.69           C  
ATOM   2105  O   ALA   280       8.379   6.213  -2.131  1.00 58.14           O  
ATOM   2106  CB  ALA   280       7.779   4.045  -3.936  1.00 56.25           C  
ATOM   2107  N   ILE   281      10.508   5.582  -2.235  1.00 59.74           N  
ATOM   2108  CA  ILE   281      10.947   6.265  -1.016  1.00 60.78           C  
ATOM   2109  C   ILE   281      10.517   7.750  -0.945  1.00 60.99           C  
ATOM   2110  O   ILE   281      10.586   8.508  -1.927  1.00 58.34           O  
ATOM   2111  CB  ILE   281      12.498   6.161  -0.924  1.00 60.10           C  
ATOM   2112  CG1 ILE   281      12.971   6.338   0.509  1.00 66.46           C  
ATOM   2113  CG2 ILE   281      13.189   7.127  -1.969  1.00 57.81           C  
ATOM   2114  CD1 ILE   281      14.303   5.653   0.779  1.00 67.85           C  
ATOM   2115  N   LYS   282      10.080   8.173   0.229  1.00 61.35           N  
ATOM   2116  CA  LYS   282       9.619   9.539   0.388  1.00 63.67           C  
ATOM   2117  C   LYS   282      10.551  10.419   1.229  1.00 61.25           C  
ATOM   2118  O   LYS   282      11.502   9.933   1.803  1.00 61.51           O  
ATOM   2119  CB  LYS   282       8.141   9.570   0.846  1.00 64.98           C  
ATOM   2120  CG  LYS   282       7.766   8.583   1.882  1.00 67.64           C  
ATOM   2121  CD  LYS   282       6.285   8.645   2.238  1.00 67.61           C  
ATOM   2122  CE  LYS   282       5.385   8.048   1.180  1.00 67.77           C  
ATOM   2123  NZ  LYS   282       4.075   7.599   1.782  1.00 67.80           N  
ATOM   2124  N   GLY   283      10.295  11.729   1.221  1.00 60.05           N  
ATOM   2125  CA  GLY   283      11.082  12.711   1.977  1.00 56.85           C  
ATOM   2126  C   GLY   283      12.323  13.165   1.249  1.00 55.49           C  
ATOM   2127  O   GLY   283      12.490  12.857   0.075  1.00 56.61           O  
ATOM   2128  N   THR   284      13.186  13.922   1.937  1.00 55.16           N  
ATOM   2129  CA  THR   284      14.458  14.352   1.366  1.00 58.60           C  
ATOM   2130  C   THR   284      15.396  13.158   1.510  1.00 58.29           C  
ATOM   2131  O   THR   284      16.127  13.025   2.498  1.00 64.26           O  
ATOM   2132  CB  THR   284      15.068  15.562   2.103  1.00 58.81           C  
ATOM   2133  OG1 THR   284      15.282  15.184   3.465  1.00 61.42           O  
ATOM   2134  CG2 THR   284      14.130  16.791   2.063  1.00 54.55           C  
ATOM   2135  N   MET   285      15.348  12.279   0.533  1.00 55.74           N  
ATOM   2136  CA  MET   285      16.149  11.090   0.542  1.00 54.80           C  
ATOM   2137  C   MET   285      16.820  10.866  -0.798  1.00 53.76           C  
ATOM   2138  O   MET   285      16.468  11.517  -1.812  1.00 51.16           O  
ATOM   2139  CB  MET   285      15.254   9.895   0.817  1.00 59.08           C  
ATOM   2140  CG  MET   285      16.023   8.803   1.486  1.00 70.72           C  
ATOM   2141  SD  MET   285      15.988   9.191   3.365  0.75 72.71          SE  
ATOM   2142  CE  MET   285      14.036   7.971   3.245  1.00 55.49           C  
ATOM   2143  N   ASN   286      17.863  10.041  -0.795  1.00 50.19           N  
ATOM   2144  CA  ASN   286      18.458   9.596  -2.055  1.00 50.76           C  
ATOM   2145  C   ASN   286      18.290   8.081  -2.142  1.00 50.97           C  
ATOM   2146  O   ASN   286      17.978   7.440  -1.131  1.00 44.71           O  
ATOM   2147  CB  ASN   286      19.923   9.981  -2.224  1.00 49.58           C  
ATOM   2148  CG  ASN   286      20.112  11.403  -2.696  1.00 50.93           C  
ATOM   2149  OD1 ASN   286      21.105  11.690  -3.318  1.00 57.81           O  
ATOM   2150  ND2 ASN   286      19.143  12.297  -2.415  1.00 52.94           N  
ATOM   2151  N   ALA   287      18.425   7.550  -3.367  1.00 47.85           N  
ATOM   2152  CA  ALA   287      18.376   6.142  -3.571  1.00 50.04           C  
ATOM   2153  C   ALA   287      18.981   5.740  -4.931  1.00 48.49           C  
ATOM   2154  O   ALA   287      19.136   6.564  -5.846  1.00 49.11           O  
ATOM   2155  CB  ALA   287      16.931   5.601  -3.350  1.00 50.22           C  
ATOM   2156  N   ALA   288      19.445   4.498  -5.024  1.00 45.47           N  
ATOM   2157  CA  ALA   288      20.031   4.040  -6.281  1.00 47.90           C  
ATOM   2158  C   ALA   288      19.895   2.544  -6.375  1.00 48.41           C  
ATOM   2159  O   ALA   288      20.132   1.835  -5.394  1.00 49.24           O  
ATOM   2160  CB  ALA   288      21.514   4.466  -6.395  1.00 45.62           C  
ATOM   2161  N   MET   289      19.483   2.070  -7.545  1.00 48.34           N  
ATOM   2162  CA  MET   289      19.390   0.672  -7.800  1.00 48.98           C  
ATOM   2163  C   MET   289      20.462   0.335  -8.825  1.00 48.97           C  
ATOM   2164  O   MET   289      20.379   0.806  -9.935  1.00 48.56           O  
ATOM   2165  CB  MET   289      17.991   0.333  -8.359  1.00 52.88           C  
ATOM   2166  CG  MET   289      17.745  -1.165  -8.616  1.00 52.27           C  
ATOM   2167  SD  MET   289      17.752  -2.323  -7.100  0.75 51.82          SE  
ATOM   2168  CE  MET   289      15.943  -2.000  -6.436  1.00 70.48           C  
ATOM   2169  N   PHE   290      21.442  -0.498  -8.466  1.00 49.09           N  
ATOM   2170  CA  PHE   290      22.459  -0.980  -9.434  1.00 48.88           C  
ATOM   2171  C   PHE   290      22.062  -2.356  -9.940  1.00 50.07           C  
ATOM   2172  O   PHE   290      21.818  -3.239  -9.154  1.00 49.92           O  
ATOM   2173  CB  PHE   290      23.842  -1.103  -8.779  1.00 48.79           C  
ATOM   2174  CG  PHE   290      24.349   0.158  -8.204  1.00 48.96           C  
ATOM   2175  CD1 PHE   290      23.896   0.613  -6.969  1.00 46.94           C  
ATOM   2176  CD2 PHE   290      25.285   0.908  -8.884  1.00 55.03           C  
ATOM   2177  CE1 PHE   290      24.328   1.791  -6.463  1.00 52.75           C  
ATOM   2178  CE2 PHE   290      25.744   2.085  -8.363  1.00 56.17           C  
ATOM   2179  CZ  PHE   290      25.264   2.539  -7.158  1.00 55.13           C  
ATOM   2180  N   LYS   291      21.959  -2.515 -11.248  1.00 51.01           N  
ATOM   2181  CA  LYS   291      21.694  -3.786 -11.860  1.00 52.81           C  
ATOM   2182  C   LYS   291      23.043  -4.249 -12.413  1.00 51.70           C  
ATOM   2183  O   LYS   291      23.681  -3.528 -13.179  1.00 46.61           O  
ATOM   2184  CB  LYS   291      20.655  -3.672 -12.988  1.00 55.77           C  
ATOM   2185  CG  LYS   291      20.211  -5.026 -13.568  1.00 60.53           C  
ATOM   2186  CD  LYS   291      19.325  -4.887 -14.824  1.00 60.07           C  
ATOM   2187  CE  LYS   291      19.053  -6.265 -15.511  1.00 65.73           C  
ATOM   2188  N   THR   292      23.471  -5.450 -12.003  1.00 51.30           N  
ATOM   2189  CA  THR   292      24.770  -5.989 -12.373  1.00 49.62           C  
ATOM   2190  C   THR   292      24.610  -7.333 -12.985  1.00 49.16           C  
ATOM   2191  O   THR   292      23.529  -7.930 -12.921  1.00 48.79           O  
ATOM   2192  CB  THR   292      25.703  -6.186 -11.143  1.00 48.95           C  
ATOM   2193  OG1 THR   292      25.250  -7.297 -10.356  1.00 50.84           O  
ATOM   2194  CG2 THR   292      25.770  -4.949 -10.307  1.00 46.35           C  
ATOM   2195  N   ASP   293      25.702  -7.828 -13.561  1.00 50.04           N  
ATOM   2196  CA  ASP   293      25.686  -9.165 -14.146  1.00 51.52           C  
ATOM   2197  C   ASP   293      25.922 -10.287 -13.124  1.00 49.74           C  
ATOM   2198  O   ASP   293      25.258 -11.309 -13.205  1.00 48.01           O  
ATOM   2199  CB  ASP   293      26.698  -9.294 -15.298  1.00 54.21           C  
ATOM   2200  CG  ASP   293      28.150  -9.077 -14.857  1.00 59.78           C  
ATOM   2201  OD1 ASP   293      28.405  -8.547 -13.750  1.00 65.09           O  
ATOM   2202  OD2 ASP   293      29.048  -9.430 -15.645  1.00 72.52           O  
ATOM   2203  N   THR   294      26.840 -10.111 -12.170  1.00 49.18           N  
ATOM   2204  CA  THR   294      27.170 -11.225 -11.231  1.00 51.89           C  
ATOM   2205  C   THR   294      26.646 -11.106  -9.783  1.00 50.82           C  
ATOM   2206  O   THR   294      26.422 -12.115  -9.128  1.00 53.77           O  
ATOM   2207  CB  THR   294      28.695 -11.537 -11.205  1.00 51.02           C  
ATOM   2208  OG1 THR   294      29.416 -10.394 -10.734  1.00 55.62           O  
ATOM   2209  CG2 THR   294      29.192 -11.907 -12.592  1.00 48.56           C  
ATOM   2210  N   ALA   295      26.447  -9.891  -9.299  1.00 50.60           N  
ATOM   2211  CA  ALA   295      25.931  -9.652  -7.943  1.00 51.30           C  
ATOM   2212  C   ALA   295      24.421  -9.398  -7.876  1.00 51.09           C  
ATOM   2213  O   ALA   295      23.939  -8.902  -6.864  1.00 55.53           O  
ATOM   2214  CB  ALA   295      26.662  -8.445  -7.319  1.00 46.14           C  
ATOM   2215  N   GLY   296      23.684  -9.701  -8.938  1.00 50.47           N  
ATOM   2216  CA  GLY   296      22.274  -9.345  -9.021  1.00 47.00           C  
ATOM   2217  C   GLY   296      22.038  -7.833  -9.002  1.00 46.99           C  
ATOM   2218  O   GLY   296      22.866  -7.023  -9.452  1.00 47.94           O  
ATOM   2219  N   SER   297      20.890  -7.462  -8.447  1.00 45.29           N  
ATOM   2220  CA  SER   297      20.485  -6.093  -8.245  1.00 47.70           C  
ATOM   2221  C   SER   297      20.820  -5.625  -6.796  1.00 46.66           C  
ATOM   2222  O   SER   297      20.489  -6.288  -5.816  1.00 44.07           O  
ATOM   2223  CB  SER   297      18.998  -5.935  -8.600  1.00 49.61           C  
ATOM   2224  OG  SER   297      18.838  -5.667  -9.996  1.00 52.39           O  
ATOM   2225  N   ILE   298      21.514  -4.502  -6.693  1.00 45.48           N  
ATOM   2226  CA  ILE   298      21.926  -3.930  -5.421  1.00 47.62           C  
ATOM   2227  C   ILE   298      21.326  -2.541  -5.248  1.00 48.50           C  
ATOM   2228  O   ILE   298      21.430  -1.691  -6.129  1.00 46.75           O  
ATOM   2229  CB  ILE   298      23.437  -3.863  -5.292  1.00 48.14           C  
ATOM   2230  CG1 ILE   298      24.008  -5.275  -5.412  1.00 52.40           C  
ATOM   2231  CG2 ILE   298      23.839  -3.298  -3.937  1.00 46.53           C  
ATOM   2232  CD1 ILE   298      25.442  -5.340  -5.113  1.00 58.92           C  
ATOM   2233  N   PHE   299      20.665  -2.360  -4.103  1.00 47.41           N  
ATOM   2234  CA  PHE   299      19.949  -1.156  -3.780  1.00 46.70           C  
ATOM   2235  C   PHE   299      20.528  -0.494  -2.544  1.00 46.08           C  
ATOM   2236  O   PHE   299      20.912  -1.168  -1.560  1.00 43.64           O  
ATOM   2237  CB  PHE   299      18.478  -1.497  -3.523  1.00 48.44           C  
ATOM   2238  CG  PHE   299      17.602  -0.290  -3.232  1.00 47.77           C  
ATOM   2239  CD1 PHE   299      17.231   0.577  -4.250  1.00 54.31           C  
ATOM   2240  CD2 PHE   299      17.121  -0.051  -1.962  1.00 51.44           C  
ATOM   2241  CE1 PHE   299      16.429   1.664  -3.983  1.00 58.81           C  
ATOM   2242  CE2 PHE   299      16.302   1.044  -1.694  1.00 53.15           C  
ATOM   2243  CZ  PHE   299      15.966   1.892  -2.684  1.00 50.25           C  
ATOM   2244  N   VAL   300      20.611   0.835  -2.631  1.00 45.97           N  
ATOM   2245  CA  VAL   300      21.075   1.669  -1.543  1.00 48.52           C  
ATOM   2246  C   VAL   300      20.181   2.923  -1.440  1.00 47.59           C  
ATOM   2247  O   VAL   300      19.665   3.417  -2.434  1.00 46.65           O  
ATOM   2248  CB  VAL   300      22.596   2.002  -1.680  1.00 46.77           C  
ATOM   2249  CG1 VAL   300      22.890   2.751  -2.965  1.00 43.95           C  
ATOM   2250  CG2 VAL   300      23.089   2.794  -0.501  1.00 60.08           C  
ATOM   2251  N   ALA   301      19.992   3.392  -0.208  1.00 50.33           N  
ATOM   2252  CA  ALA   301      19.200   4.567   0.119  1.00 51.53           C  
ATOM   2253  C   ALA   301      19.778   5.233   1.390  1.00 53.33           C  
ATOM   2254  O   ALA   301      20.325   4.544   2.281  1.00 51.18           O  
ATOM   2255  CB  ALA   301      17.762   4.175   0.341  1.00 49.38           C  
ATOM   2256  N   GLY   302      19.701   6.569   1.436  1.00 53.20           N  
ATOM   2257  CA  GLY   302      20.105   7.365   2.605  1.00 55.07           C  
ATOM   2258  C   GLY   302      19.862   8.871   2.399  1.00 58.52           C  
ATOM   2259  O   GLY   302      19.121   9.260   1.513  1.00 56.23           O  
ATOM   2260  N   ARG   303      20.488   9.717   3.224  1.00 59.94           N  
ATOM   2261  CA  ARG   303      20.404  11.197   3.094  1.00 62.24           C  
ATOM   2262  C   ARG   303      21.276  11.642   1.924  1.00 64.44           C  
ATOM   2263  O   ARG   303      22.448  11.243   1.845  1.00 68.05           O  
ATOM   2264  CB  ARG   303      20.869  11.921   4.391  1.00 63.46           C  
ATOM   2265  CG  ARG   303      19.777  12.296   5.367  1.00 65.42           C  
ATOM   2266  CD  ARG   303      18.777  11.215   5.621  1.00 63.53           C  
ATOM   2267  NE  ARG   303      17.603  11.763   6.311  1.00 68.32           N  
ATOM   2268  N   GLY   304      20.724  12.474   1.041  1.00 61.92           N  
ATOM   2269  CA  GLY   304      21.473  12.933  -0.135  1.00 62.60           C  
ATOM   2270  C   GLY   304      22.240  14.246  -0.001  1.00 64.51           C  
ATOM   2271  O   GLY   304      22.921  14.670  -0.953  1.00 64.41           O  
ATOM   2272  N   ALA   305      22.127  14.880   1.170  1.00 64.80           N  
ATOM   2273  CA  ALA   305      22.749  16.192   1.444  1.00 67.40           C  
ATOM   2274  C   ALA   305      22.657  16.541   2.944  1.00 69.25           C  
ATOM   2275  O   ALA   305      22.008  15.827   3.739  1.00 71.21           O  
ATOM   2276  CB  ALA   305      22.084  17.306   0.597  1.00 64.41           C  
ATOM   2277  N   GLY   306      23.261  17.669   3.312  1.00 68.12           N  
ATOM   2278  CA  GLY   306      23.350  18.082   4.708  1.00 65.78           C  
ATOM   2279  C   GLY   306      24.808  18.328   5.029  1.00 64.76           C  
ATOM   2280  O   GLY   306      25.708  17.837   4.332  1.00 63.93           O  
ATOM   2281  N   LYS   307      25.046  19.108   6.073  1.00 62.64           N  
ATOM   2282  CA  LYS   307      26.399  19.476   6.443  1.00 62.49           C  
ATOM   2283  C   LYS   307      27.186  18.288   6.978  1.00 59.09           C  
ATOM   2284  O   LYS   307      28.273  17.993   6.470  1.00 59.47           O  
ATOM   2285  CB  LYS   307      26.409  20.646   7.456  1.00 61.25           C  
ATOM   2286  CG  LYS   307      27.799  20.931   7.994  1.00 64.49           C  
ATOM   2287  CD  LYS   307      27.953  22.314   8.630  1.00 66.08           C  
ATOM   2288  CE  LYS   307      27.276  22.452   9.964  1.00 72.37           C  
ATOM   2289  NZ  LYS   307      27.655  23.784  10.595  1.00 74.14           N  
ATOM   2290  N   GLU   308      26.636  17.617   7.989  1.00 59.41           N  
ATOM   2291  CA  GLU   308      27.331  16.507   8.639  1.00 60.01           C  
ATOM   2292  C   GLU   308      27.386  15.318   7.665  1.00 58.28           C  
ATOM   2293  O   GLU   308      28.396  14.646   7.582  1.00 57.19           O  
ATOM   2294  CB  GLU   308      26.672  16.146   9.994  1.00 62.01           C  
ATOM   2295  CG  GLU   308      27.710  15.741  11.112  1.00 64.45           C  
ATOM   2296  CD  GLU   308      27.100  15.204  12.438  1.00 66.17           C  
ATOM   2297  OE1 GLU   308      26.057  14.504  12.406  1.00 74.01           O  
ATOM   2298  OE2 GLU   308      27.705  15.442  13.523  1.00 82.29           O  
ATOM   2299  N   GLU   309      26.323  15.131   6.884  1.00 56.89           N  
ATOM   2300  CA  GLU   309      26.215  14.060   5.906  1.00 57.35           C  
ATOM   2301  C   GLU   309      27.263  14.198   4.803  1.00 57.25           C  
ATOM   2302  O   GLU   309      27.924  13.219   4.446  1.00 56.95           O  
ATOM   2303  CB  GLU   309      24.797  14.007   5.285  1.00 59.26           C  
ATOM   2304  CG  GLU   309      23.674  13.493   6.241  1.00 63.49           C  
ATOM   2305  CD  GLU   309      23.312  14.466   7.369  1.00 73.49           C  
ATOM   2306  OE1 GLU   309      23.256  15.706   7.132  1.00 72.66           O  
ATOM   2307  OE2 GLU   309      23.080  13.975   8.495  1.00 76.48           O  
ATOM   2308  N   THR   310      27.432  15.404   4.266  1.00 54.46           N  
ATOM   2309  CA  THR   310      28.431  15.620   3.229  1.00 51.76           C  
ATOM   2310  C   THR   310      29.824  15.483   3.822  1.00 52.76           C  
ATOM   2311  O   THR   310      30.729  14.912   3.197  1.00 55.41           O  
ATOM   2312  CB  THR   310      28.256  16.986   2.567  1.00 53.49           C  
ATOM   2313  OG1 THR   310      26.956  17.041   1.990  1.00 55.20           O  
ATOM   2314  CG2 THR   310      29.285  17.211   1.444  1.00 52.64           C  
ATOM   2315  N   ALA   311      30.008  16.034   5.019  1.00 50.52           N  
ATOM   2316  CA  ALA   311      31.277  15.932   5.720  1.00 49.19           C  
ATOM   2317  C   ALA   311      31.689  14.452   5.889  1.00 48.65           C  
ATOM   2318  O   ALA   311      32.884  14.124   5.745  1.00 49.41           O  
ATOM   2319  CB  ALA   311      31.169  16.616   7.114  1.00 47.13           C  
ATOM   2320  N   SER   312      30.723  13.599   6.263  1.00 46.95           N  
ATOM   2321  CA  SER   312      30.915  12.131   6.434  1.00 50.66           C  
ATOM   2322  C   SER   312      31.468  11.472   5.178  1.00 46.93           C  
ATOM   2323  O   SER   312      32.356  10.659   5.257  1.00 50.54           O  
ATOM   2324  CB  SER   312      29.588  11.393   6.731  1.00 51.96           C  
ATOM   2325  OG  SER   312      29.093  11.705   8.000  1.00 67.21           O  
ATOM   2326  N   ALA   313      30.857  11.775   4.046  1.00 44.96           N  
ATOM   2327  CA  ALA   313      31.306  11.265   2.741  1.00 46.84           C  
ATOM   2328  C   ALA   313      32.756  11.664   2.510  1.00 45.11           C  
ATOM   2329  O   ALA   313      33.556  10.848   2.101  1.00 48.10           O  
ATOM   2330  CB  ALA   313      30.397  11.801   1.619  1.00 44.44           C  
ATOM   2331  N   ILE   314      33.097  12.925   2.792  1.00 47.45           N  
ATOM   2332  CA  ILE   314      34.449  13.394   2.616  1.00 46.75           C  
ATOM   2333  C   ILE   314      35.403  12.565   3.491  1.00 47.25           C  
ATOM   2334  O   ILE   314      36.446  12.090   3.020  1.00 45.24           O  
ATOM   2335  CB  ILE   314      34.558  14.915   2.895  1.00 47.78           C  
ATOM   2336  CG1 ILE   314      33.914  15.679   1.745  1.00 48.95           C  
ATOM   2337  CG2 ILE   314      36.023  15.318   3.057  1.00 44.35           C  
ATOM   2338  CD1 ILE   314      33.797  17.158   1.936  1.00 51.85           C  
ATOM   2339  N   LEU   315      35.031  12.368   4.753  1.00 48.16           N  
ATOM   2340  CA  LEU   315      35.822  11.560   5.653  1.00 49.56           C  
ATOM   2341  C   LEU   315      35.978  10.110   5.207  1.00 49.36           C  
ATOM   2342  O   LEU   315      37.047   9.538   5.409  1.00 47.25           O  
ATOM   2343  CB  LEU   315      35.255  11.563   7.078  1.00 51.04           C  
ATOM   2344  CG  LEU   315      35.854  12.567   8.060  1.00 59.62           C  
ATOM   2345  CD1 LEU   315      35.674  14.044   7.569  1.00 51.16           C  
ATOM   2346  CD2 LEU   315      35.221  12.282   9.446  1.00 52.56           C  
ATOM   2347  N   SER   316      34.923   9.512   4.640  1.00 49.02           N  
ATOM   2348  CA  SER   316      34.996   8.106   4.182  1.00 47.88           C  
ATOM   2349  C   SER   316      36.082   8.026   3.098  1.00 47.56           C  
ATOM   2350  O   SER   316      36.860   7.078   3.063  1.00 49.39           O  
ATOM   2351  CB  SER   316      33.642   7.620   3.698  1.00 48.36           C  
ATOM   2352  OG  SER   316      33.242   8.292   2.495  1.00 55.46           O  
ATOM   2353  N   ASP   317      36.191   9.078   2.273  1.00 46.72           N  
ATOM   2354  CA  ASP   317      37.227   9.137   1.230  1.00 46.53           C  
ATOM   2355  C   ASP   317      38.627   9.292   1.807  1.00 50.16           C  
ATOM   2356  O   ASP   317      39.573   8.696   1.312  1.00 53.23           O  
ATOM   2357  CB  ASP   317      36.938  10.256   0.239  1.00 41.60           C  
ATOM   2358  CG  ASP   317      35.834   9.908  -0.751  1.00 43.80           C  
ATOM   2359  OD1 ASP   317      35.538   8.695  -0.958  1.00 52.19           O  
ATOM   2360  OD2 ASP   317      35.326  10.862  -1.390  1.00 50.91           O  
ATOM   2361  N   LEU   318      38.760  10.086   2.862  1.00 52.68           N  
ATOM   2362  CA  LEU   318      40.060  10.306   3.503  1.00 52.67           C  
ATOM   2363  C   LEU   318      40.528   8.961   4.104  1.00 50.21           C  
ATOM   2364  O   LEU   318      41.663   8.570   3.915  1.00 48.06           O  
ATOM   2365  CB  LEU   318      39.920  11.404   4.559  1.00 54.71           C  
ATOM   2366  CG  LEU   318      41.133  12.145   5.091  1.00 58.12           C  
ATOM   2367  CD1 LEU   318      41.863  12.903   3.970  1.00 62.27           C  
ATOM   2368  CD2 LEU   318      40.626  13.101   6.178  1.00 56.81           C  
ATOM   2369  N   TYR   319      39.620   8.261   4.789  1.00 48.95           N  
ATOM   2370  CA  TYR   319      39.844   6.910   5.310  1.00 50.03           C  
ATOM   2371  C   TYR   319      40.305   5.925   4.213  1.00 49.32           C  
ATOM   2372  O   TYR   319      41.253   5.163   4.388  1.00 49.39           O  
ATOM   2373  CB  TYR   319      38.543   6.354   5.911  1.00 49.58           C  
ATOM   2374  CG  TYR   319      38.735   5.000   6.509  1.00 50.71           C  
ATOM   2375  CD1 TYR   319      39.209   4.868   7.816  1.00 53.95           C  
ATOM   2376  CD2 TYR   319      38.503   3.839   5.769  1.00 49.76           C  
ATOM   2377  CE1 TYR   319      39.417   3.611   8.382  1.00 50.20           C  
ATOM   2378  CE2 TYR   319      38.715   2.570   6.332  1.00 50.70           C  
ATOM   2379  CZ  TYR   319      39.181   2.473   7.636  1.00 48.87           C  
ATOM   2380  OH  TYR   319      39.412   1.243   8.222  1.00 55.17           O  
ATOM   2381  N   GLU   320      39.610   5.942   3.087  1.00 48.44           N  
ATOM   2382  CA  GLU   320      39.949   5.081   1.969  1.00 47.40           C  
ATOM   2383  C   GLU   320      41.382   5.376   1.478  1.00 47.27           C  
ATOM   2384  O   GLU   320      42.144   4.470   1.218  1.00 47.01           O  
ATOM   2385  CB  GLU   320      38.899   5.230   0.862  1.00 48.25           C  
ATOM   2386  CG  GLU   320      39.146   4.413  -0.404  1.00 53.06           C  
ATOM   2387  CD  GLU   320      39.248   2.937  -0.131  1.00 60.01           C  
ATOM   2388  OE1 GLU   320      38.389   2.421   0.625  1.00 62.46           O  
ATOM   2389  OE2 GLU   320      40.173   2.300  -0.683  1.00 64.07           O  
ATOM   2390  N   ILE   321      41.783   6.634   1.401  1.00 47.78           N  
ATOM   2391  CA  ILE   321      43.124   6.945   0.927  1.00 46.61           C  
ATOM   2392  C   ILE   321      44.188   6.472   1.918  1.00 49.20           C  
ATOM   2393  O   ILE   321      45.181   5.905   1.503  1.00 49.99           O  
ATOM   2394  CB  ILE   321      43.345   8.474   0.697  1.00 46.65           C  
ATOM   2395  CG1 ILE   321      42.435   9.044  -0.399  1.00 47.24           C  
ATOM   2396  CG2 ILE   321      44.833   8.770   0.354  1.00 46.81           C  
ATOM   2397  CD1 ILE   321      42.475  10.581  -0.480  1.00 44.25           C  
ATOM   2398  N   TYR   322      43.944   6.659   3.217  1.00 51.37           N  
ATOM   2399  CA  TYR   322      44.955   6.426   4.255  1.00 52.11           C  
ATOM   2400  C   TYR   322      44.790   5.294   5.274  1.00 52.84           C  
ATOM   2401  O   TYR   322      45.648   5.158   6.141  1.00 52.73           O  
ATOM   2402  CB  TYR   322      45.131   7.731   5.054  1.00 52.56           C  
ATOM   2403  CG  TYR   322      45.728   8.878   4.272  1.00 50.98           C  
ATOM   2404  CD1 TYR   322      47.060   8.846   3.839  1.00 48.79           C  
ATOM   2405  CD2 TYR   322      44.983  10.011   4.001  1.00 45.02           C  
ATOM   2406  CE1 TYR   322      47.617   9.924   3.125  1.00 52.27           C  
ATOM   2407  CE2 TYR   322      45.528  11.084   3.301  1.00 45.41           C  
ATOM   2408  CZ  TYR   322      46.823  11.035   2.861  1.00 48.21           C  
ATOM   2409  OH  TYR   322      47.315  12.106   2.173  1.00 52.00           O  
ATOM   2410  N   ALA   323      43.736   4.487   5.217  1.00 53.51           N  
ATOM   2411  CA  ALA   323      43.591   3.392   6.196  1.00 53.48           C  
ATOM   2412  C   ALA   323      44.597   2.246   5.980  1.00 58.30           C  
ATOM   2413  O   ALA   323      44.793   1.789   4.856  1.00 59.82           O  
ATOM   2414  CB  ALA   323      42.200   2.847   6.174  1.00 53.05           C  
ATOM   2415  N   GLY   324      45.207   1.768   7.069  1.00 60.94           N  
ATOM   2416  CA  GLY   324      46.171   0.668   7.002  1.00 63.08           C  
ATOM   2417  C   GLY   324      46.514   0.095   8.376  1.00 65.62           C  
ATOM   2418  O   GLY   324      47.440  -0.725   8.525  1.00 67.71           O  
END
