
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  324 ( 2550),  selected  324 , name 3c8m_A
# Molecule2: number of CA atoms  320 ( 2378),  selected  320 , name T0452.pdb
# PARAMETERS: 3c8m_A.T0452.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    T     3_A      M       1          2.096
LGA    I     4_A      I       2          1.197
LGA    N     5_A      K       3          0.734
LGA    L     6_A      I       4          1.031
LGA    S     7_A      A       5          0.918
LGA    I     8_A      I       6          0.472
LGA    F     9_A      V       7          0.956
LGA    G    10_A      G       8          1.291
LGA    L    11_A      F       9          1.579
LGA    G    12_A      G      10          1.808
LGA    N    13_A      T      11          1.791
LGA    V    14_A      V      12          1.447
LGA    G    15_A      G      13          1.044
LGA    L    16_A      Q      14          0.855
LGA    N    17_A      G      15          1.288
LGA    L    18_A      V      16          0.608
LGA    L    19_A      A      17          0.547
LGA    R    20_A      E      18          1.373
LGA    I    21_A      L      19          1.242
LGA    I    22_A      L      20          1.081
LGA    R    23_A      I      21          1.716
LGA    S    24_A      R      22          2.917
LGA    F    25_A      K      23          3.048
LGA    N    26_A      R      24          2.443
LGA    E    27_A      E      25          1.656
LGA    E    28_A      E      26          2.262
LGA    N    29_A      I      27          3.442
LGA    -       -      E      28           -
LGA    R    30_A      K      29          3.103
LGA    L    31_A      A      30          1.429
LGA    G    32_A      I      31          4.114
LGA    L    33_A      G      32          1.728
LGA    K    34_A      E      33          2.494
LGA    F    35_A      F      34          2.451
LGA    N    36_A      K      35          1.189
LGA    V    37_A      V      36          0.627
LGA    V    38_A      T      37          0.970
LGA    F    39_A      A      38          0.867
LGA    V    40_A      V      39          0.612
LGA    A    41_A      A      40          1.158
LGA    D    42_A      D      41          1.449
LGA    S    43_A      S      42          2.251
LGA    L    44_A      K      43          3.629
LGA    H    45_A      S      44          1.976
LGA    S    46_A      S      45          1.298
LGA    Y    47_A      I      46          1.465
LGA    Y    48_A      S      47          1.329
LGA    N    49_A      G      48          1.332
LGA    E    50_A      -       -           -
LGA    R    51_A      D      49          3.530
LGA    I    52_A      F      50          3.242
LGA    D    53_A      S      51          0.465
LGA    I    54_A      L      52          0.759
LGA    G    55_A      V      53          1.519
LGA    K    56_A      E      54          1.503
LGA    V    57_A      A      55          1.651
LGA    I    58_A      L      56          2.114
LGA    S    59_A      R      57          2.369
LGA    Y    60_A      M      58          2.550
LGA    K    61_A      K      59          2.697
LGA    E    62_A      R      60          3.276
LGA    K    63_A      E      61          3.184
LGA    G    64_A      T      62          3.909
LGA    S    65_A      G      63           #
LGA    L    66_A      M      64          4.276
LGA    D    67_A      L      65          5.096
LGA    S    68_A      -       -           -
LGA    L    69_A      R      66          3.974
LGA    E    70_A      -       -           -
LGA    Y    71_A      -       -           -
LGA    E    72_A      D      67          4.987
LGA    S    73_A      D      68          4.300
LGA    I    74_A      A      69          2.452
LGA    S    75_A      K      70          2.663
LGA    A    76_A      A      71          2.461
LGA    S    77_A      I      72          2.942
LGA    E    78_A      E      73          2.400
LGA    A    79_A      V      74          1.547
LGA    L    80_A      V      75          2.133
LGA    A    81_A      R      76          3.126
LGA    -       -      S      77           -
LGA    R    82_A      A      78          2.669
LGA    D    83_A      D      79          2.420
LGA    F    84_A      Y      80          1.207
LGA    D    85_A      D      81          0.946
LGA    I    86_A      V      82          1.224
LGA    V    87_A      L      83          1.159
LGA    V    88_A      I      84          1.079
LGA    D    89_A      E      85          1.181
LGA    A    90_A      A      86          0.778
LGA    T    91_A      S      87          1.140
LGA    P    92_A      V      88          1.954
LGA    A    93_A      T      89          2.781
LGA    S    94_A      R      90          5.186
LGA    A    95_A      -       -           -
LGA    D    96_A      -       -           -
LGA    G    97_A      -       -           -
LGA    K    98_A      -       -           -
LGA    K    99_A      E      95          2.661
LGA    E   100_A      G      96          2.498
LGA    L   101_A      V      97          2.327
LGA    A   102_A      N      98          2.394
LGA    F   103_A      Y      99          2.396
LGA    Y   104_A      I     100          1.894
LGA    K   105_A      R     101          1.857
LGA    E   106_A      E     102          1.678
LGA    T   107_A      A     103          1.763
LGA    F   108_A      L     104          1.602
LGA    E   109_A      K     105          1.633
LGA    N   110_A      R     106          1.834
LGA    G   111_A      G     107          1.879
LGA    K   112_A      K     108          1.291
LGA    D   113_A      H     109          1.813
LGA    V   114_A      V     110          1.277
LGA    V   115_A      V     111          0.786
LGA    T   116_A      T     112          0.613
LGA    A   117_A      S     113          0.414
LGA    N   118_A      N     114          0.867
LGA    K   119_A      K     115          0.511
LGA    S   120_A      G     116          0.990
LGA    G   121_A      P     117          1.117
LGA    L   122_A      L     118          1.005
LGA    A   123_A      V     119          1.429
LGA    N   124_A      A     120          2.017
LGA    F   125_A      E     121          2.152
LGA    W   126_A      F     122          1.638
LGA    P   127_A      H     123          2.849
LGA    E   128_A      G     124          2.707
LGA    I   129_A      L     125          2.166
LGA    X   130_A      M     126          2.702
LGA    E   131_A      S     127          3.573
LGA    Y   132_A      L     128          2.860
LGA    A   133_A      A     129          2.542
LGA    R   134_A      E     130          3.405
LGA    S   135_A      R     131          3.553
LGA    N   136_A      N     132          3.099
LGA    N   137_A      G     133          3.565
LGA    R   138_A      V     134          3.051
LGA    R   139_A      R     135          2.012
LGA    I   140_A      L     136          0.714
LGA    R   141_A      M     137          0.897
LGA    Y   142_A      Y     138          0.493
LGA    E   143_A      E     139          0.197
LGA    A   144_A      A     140          0.483
LGA    T   145_A      T     141          0.527
LGA    V   146_A      V     142          0.489
LGA    A   147_A      G     143          0.557
LGA    G   148_A      G     144          0.465
LGA    G   149_A      A     145          0.614
LGA    V   150_A      M     146          0.576
LGA    P   151_A      P     147          1.027
LGA    L   152_A      V     148          1.150
LGA    F   153_A      V     149          1.141
LGA    S   154_A      K     150          1.327
LGA    F   155_A      L     151          1.764
LGA    I   156_A      A     152          2.424
LGA    D   157_A      K     153          2.828
LGA    Y   158_A      R     154          2.871
LGA    S   159_A      Y     155          2.076
LGA    V   160_A      L     156          2.326
LGA    L   161_A      A     157          2.777
LGA    P   162_A      L     158          2.647
LGA    S   163_A      C     159          1.107
LGA    R   164_A      E     160          1.071
LGA    I   165_A      I     161          1.063
LGA    K   166_A      E     162          1.823
LGA    K   167_A      S     163          1.736
LGA    F   168_A      V     164          1.229
LGA    R   169_A      K     165          1.505
LGA    G   170_A      G     166          1.317
LGA    I   171_A      I     167          1.117
LGA    V   172_A      F     168          0.983
LGA    S   173_A      N     169          0.792
LGA    L   174_A      G     170          1.294
LGA    T   175_A      T     171          1.015
LGA    I   176_A      C     172          1.672
LGA    N   177_A      N     173          2.182
LGA    Y   178_A      Y     174          1.890
LGA    F   179_A      I     175          1.943
LGA    I   180_A      L     176          2.280
LGA    R   181_A      S     177          2.671
LGA    E   182_A      R     178          2.738
LGA    L   183_A      M     179          2.895
LGA    A   184_A      E     180          3.075
LGA    N   185_A      E     181          3.777
LGA    -       -      E     182           -
LGA    K   186_A      R     183          1.773
LGA    R   187_A      L     184          0.704
LGA    E   188_A      P     185          1.574
LGA    F   189_A      Y     186          2.101
LGA    D   190_A      E     187          1.999
LGA    D   191_A      H     188          1.508
LGA    V   192_A      I     189          1.626
LGA    L   193_A      L     190          2.239
LGA    S   194_A      K     191          2.149
LGA    E   195_A      E     192          2.323
LGA    A   196_A      A     193          2.044
LGA    T   197_A      Q     194          1.818
LGA    K   198_A      E     195          1.902
LGA    L   199_A      L     196          1.769
LGA    G   200_A      G     197          1.063
LGA    I   201_A      Y     198          1.490
LGA    V   202_A      A     199          0.641
LGA    E   203_A      E     200          0.655
LGA    K   204_A      A     201          1.662
LGA    N   205_A      D     202          1.680
LGA    Y   206_A      P     203          1.007
LGA    K   207_A      S     204          0.995
LGA    D   208_A      Y     205          1.231
LGA    D   209_A      D     206          0.869
LGA    L   210_A      V     207          0.820
LGA    T   211_A      E     208          0.663
LGA    G   212_A      G     209          0.587
LGA    L   213_A      I     210          0.810
LGA    D   214_A      D     211          0.775
LGA    A   215_A      A     212          0.693
LGA    A   216_A      A     213          0.567
LGA    R   217_A      L     214          0.370
LGA    K   218_A      K     215          0.420
LGA    S   219_A      L     216          0.332
LGA    V   220_A      V     217          0.306
LGA    I   221_A      I     218          0.082
LGA    L   222_A      I     219          0.328
LGA    C   223_A      A     220          0.160
LGA    N   224_A      N     221          0.148
LGA    H   225_A      T     222          0.259
LGA    L   226_A      I     223          0.621
LGA    Y   227_A      G     224          1.478
LGA    G   228_A      V     225          4.769
LGA    S   229_A      K     226          1.652
LGA    S   230_A      -       -           -
LGA    Y   231_A      A     227          1.942
LGA    R   232_A      S     228          1.646
LGA    L   233_A      Y     229          0.490
LGA    S   234_A      E     230          0.340
LGA    D   235_A      D     231          1.371
LGA    V   236_A      V     232          1.403
LGA    F   237_A      E     233          1.751
LGA    Y   238_A      V     234          1.388
LGA    E   239_A      T     235          0.596
LGA    G   240_A      G     236          0.376
LGA    I   241_A      I     237          2.315
LGA    L   242_A      T     238          3.231
LGA    Q   244_A      Q     239          3.755
LGA    D   245_A      I     240           #
LGA    R   246_A      T     241          4.161
LGA    S   247_A      P     242          3.961
LGA    -       -      E     243           -
LGA    F   248_A      A     244          3.178
LGA    G   249_A      F     245          1.491
LGA    -       -      Q     246           -
LGA    -       -      V     247           -
LGA    K   250_A      A     248           #
LGA    -       -      A     249           -
LGA    -       -      E     250           -
LGA    -       -      K     251           -
LGA    -       -      G     252           -
LGA    -       -      Y     253           -
LGA    N   251_A      T     254          0.459
LGA    E   252_A      I     255          0.180
LGA    R   253_A      R     256          0.052
LGA    L   254_A      L     257          0.301
LGA    V   255_A      I     258          0.870
LGA    T   256_A      A     259          1.124
LGA    E   257_A      E     260          1.437
LGA    T   258_A      V     261          1.569
LGA    G   259_A      S     262          2.184
LGA    I   260_A      R     263          2.973
LGA    V   261_A      E     264          3.366
LGA    N   262_A      -       -           -
LGA    G   263_A      -       -           -
LGA    K   264_A      -       -           -
LGA    P   265_A      -       -           -
LGA    S   266_A      K     265          4.363
LGA    A   267_A      L     266          2.477
LGA    E   268_A      K     267          1.456
LGA    S   269_A      V     268          1.247
LGA    R   270_A      S     269          1.716
LGA    I   271_A      P     270          0.724
LGA    K   272_A      R     271          0.642
LGA    S   273_A      L     272          0.659
LGA    L   274_A      V     273          0.771
LGA    D   275_A      P     274          1.732
LGA    S   276_A      F     275          2.498
LGA    N   277_A      H     276          2.239
LGA    D   278_A      H     277          0.831
LGA    Y   279_A      P     278          0.554
LGA    L   280_A      L     279          1.205
LGA    L   281_A      A     280          1.046
LGA    T   282_A      I     281          3.405
LGA    L   283_A      -       -           -
LGA    G   284_A      K     282          2.976
LGA    K   285_A      G     283          0.485
LGA    G   286_A      T     284          2.145
LGA    S   287_A      M     285          1.969
LGA    L   288_A      N     286          1.468
LGA    G   289_A      A     287          1.794
LGA    Y   290_A      A     288          1.661
LGA    Q   291_A      M     289          1.650
LGA    L   292_A      F     290          1.678
LGA    Q   293_A      K     291          1.810
LGA    T   294_A      T     292          1.874
LGA    D   295_A      D     293          1.731
LGA    T   296_A      T     294          1.785
LGA    N   297_A      A     295          1.816
LGA    G   298_A      G     296          2.268
LGA    T   299_A      S     297          1.636
LGA    L   300_A      I     298          1.800
LGA    N   301_A      F     299          1.845
LGA    V   302_A      V     300          1.493
LGA    S   303_A      A     301          1.542
LGA    D   304_A      G     302          2.047
LGA    L   305_A      -       -           -
LGA    Y   306_A      R     303          4.165
LGA    D   307_A      G     304          4.453
LGA    -       -      A     305           -
LGA    G   308_A      G     306          2.266
LGA    P   309_A      K     307          1.781
LGA    Y   310_A      E     308          0.277
LGA    E   311_A      E     309          1.528
LGA    T   312_A      T     310          1.258
LGA    A   313_A      A     311          0.583
LGA    G   314_A      S     312          0.487
LGA    A   315_A      A     313          0.438
LGA    V   316_A      I     314          0.415
LGA    X   317_A      L     315          0.747
LGA    N   318_A      S     316          0.884
LGA    D   319_A      D     317          0.709
LGA    L   320_A      L     318          1.232
LGA    V   321_A      Y     319          1.618
LGA    I   322_A      E     320          1.253
LGA    L   323_A      I     321          1.662
LGA    S   324_A      Y     322          2.192
LGA    X   325_A      A     323          3.284
LGA    -       -      G     324           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  324  320    5.0    304    2.01    26.97     77.552    14.374

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.527360 * X  +   0.845870 * Y  +  -0.079972 * Z  + -25.495432
  Y_new =   0.807512 * X  +  -0.469715 * Y  +   0.356780 * Z  +  -0.309106
  Z_new =   0.264226 * X  +  -0.252730 * Y  +  -0.930759 * Z  +   5.554074 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.876454    0.265138  [ DEG:  -164.8087     15.1913 ]
  Theta =  -0.267401   -2.874192  [ DEG:   -15.3209   -164.6790 ]
  Phi   =   0.992268   -2.149325  [ DEG:    56.8528   -123.1472 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3c8m_A                                        
REMARK     2: T0452.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3c8m_A.T0452.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  324  320   5.0  304   2.01   26.97  77.552
REMARK  ---------------------------------------------------------- 
MOLECULE 3c8m_A
HEADER    OXIDOREDUCTASE                          12-FEB-08   3C8M              
TITLE     CRYSTAL STRUCTURE OF HOMOSERINE DEHYDROGENASE FROM                    
TITLE    2 THERMOPLASMA VOLCANIUM                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HOMOSERINE DEHYDROGENASE;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOPLASMA VOLCANIUM GSS1;                    
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: GSS1 / DSM 4299 / IFO 15438 / JCM 9571;                      
SOURCE   5 ATCC: 51530;                                                         
SOURCE   6 GENE: TVG0375766, TV0389;                                            
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    STRUCTURAL GENOMICS, APC89447, HOMOSERINE, DEHYDROGENASE,             
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR              
KEYWDS   3 STRUCTURAL GENOMICS, MCSG, OXIDOREDUCTASE                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.OSIPIUK,R.HENDRICKS,J.ABDULLAH,A.JOACHIMIAK,MIDWEST                 
AUTHOR   2 CENTER FOR STRUCTURAL GENOMICS (MCSG)                                
REVDAT   1   19-FEB-08 3C8M    0                                                
JRNL        AUTH   J.OSIPIUK,R.HENDRICKS,J.ABDULLAH,A.JOACHIMIAK                
JRNL        TITL   X-RAY CRYSTAL STRUCTURE OF HOMOSERINE                        
JRNL        TITL 2 DEHYDROGENASE FROM THERMOPLASMA VOLCANIUM.                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  3C8M A    1   328  UNP    Q97BR6   Q97BR6_THEVO     1    328             
SEQRES   1 A  331  SER ASN ALA MSE LYS THR ILE ASN LEU SER ILE PHE GLY          
SEQRES   2 A  331  LEU GLY ASN VAL GLY LEU ASN LEU LEU ARG ILE ILE ARG          
SEQRES   3 A  331  SER PHE ASN GLU GLU ASN ARG LEU GLY LEU LYS PHE ASN          
SEQRES   4 A  331  VAL VAL PHE VAL ALA ASP SER LEU HIS SER TYR TYR ASN          
SEQRES   5 A  331  GLU ARG ILE ASP ILE GLY LYS VAL ILE SER TYR LYS GLU          
SEQRES   6 A  331  LYS GLY SER LEU ASP SER LEU GLU TYR GLU SER ILE SER          
SEQRES   7 A  331  ALA SER GLU ALA LEU ALA ARG ASP PHE ASP ILE VAL VAL          
SEQRES   8 A  331  ASP ALA THR PRO ALA SER ALA ASP GLY LYS LYS GLU LEU          
SEQRES   9 A  331  ALA PHE TYR LYS GLU THR PHE GLU ASN GLY LYS ASP VAL          
SEQRES  10 A  331  VAL THR ALA ASN LYS SER GLY LEU ALA ASN PHE TRP PRO          
SEQRES  11 A  331  GLU ILE MSE GLU TYR ALA ARG SER ASN ASN ARG ARG ILE          
SEQRES  12 A  331  ARG TYR GLU ALA THR VAL ALA GLY GLY VAL PRO LEU PHE          
SEQRES  13 A  331  SER PHE ILE ASP TYR SER VAL LEU PRO SER ARG ILE LYS          
SEQRES  14 A  331  LYS PHE ARG GLY ILE VAL SER LEU THR ILE ASN TYR PHE          
SEQRES  15 A  331  ILE ARG GLU LEU ALA ASN LYS ARG GLU PHE ASP ASP VAL          
SEQRES  16 A  331  LEU SER GLU ALA THR LYS LEU GLY ILE VAL GLU LYS ASN          
SEQRES  17 A  331  TYR LYS ASP ASP LEU THR GLY LEU ASP ALA ALA ARG LYS          
SEQRES  18 A  331  SER VAL ILE LEU CYS ASN HIS LEU TYR GLY SER SER TYR          
SEQRES  19 A  331  ARG LEU SER ASP VAL PHE TYR GLU GLY ILE LEU ASP GLN          
SEQRES  20 A  331  ASP ARG SER PHE GLY LYS ASN GLU ARG LEU VAL THR GLU          
SEQRES  21 A  331  THR GLY ILE VAL ASN GLY LYS PRO SER ALA GLU SER ARG          
SEQRES  22 A  331  ILE LYS SER LEU ASP SER ASN ASP TYR LEU LEU THR LEU          
SEQRES  23 A  331  GLY LYS GLY SER LEU GLY TYR GLN LEU GLN THR ASP THR          
SEQRES  24 A  331  ASN GLY THR LEU ASN VAL SER ASP LEU TYR ASP GLY PRO          
SEQRES  25 A  331  TYR GLU THR ALA GLY ALA VAL MSE ASN ASP LEU VAL ILE          
SEQRES  26 A  331  LEU SER MSE PHE THR VAL                                      
HET    MSE  A   1       8                                                       
HET    MSE  A 130       8                                                       
HET    MSE  A 317       8                                                       
HET    MSE  A 325      13                                                       
HET    SO4  A 401       5                                                       
HET    SO4  A 402       5                                                       
HET    SO4  A 403       5                                                       
HET    SO4  A 404       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  SO4    4(O4 S 2-)                                                   
FORMUL   6  HOH   *342(H2 O)                                                    
CRYST1  108.404  108.404   60.458  90.00  90.00 120.00 P 32 2 1      6          
HETATM    1  N   MSE A   1      49.888   7.701  14.166  1.00 27.64           N  
HETATM    2  CA  MSE A   1      51.252   7.475  13.610  1.00 27.77           C  
HETATM    3  C   MSE A   1      51.451   8.202  12.279  1.00 24.61           C  
HETATM    4  O   MSE A   1      52.380   8.988  12.177  1.00 23.97           O  
HETATM    5  CB  MSE A   1      51.628   5.986  13.508  1.00 27.39           C  
HETATM    6  CG  MSE A   1      52.097   5.385  14.811  1.00 30.12           C  
HETATM    7 SE   MSE A   1      53.313   3.839  14.628  0.50 34.25          SE  
HETATM    8  CE  MSE A   1      54.347   4.466  13.052  1.00 32.88           C  
ATOM      9  N   LYS A   2      50.602   7.966  11.280  1.00 21.55           N  
ATOM     10  CA  LYS A   2      50.782   8.658   9.995  1.00 20.15           C  
ATOM     11  C   LYS A   2      49.987   9.968   9.891  1.00 18.75           C  
ATOM     12  O   LYS A   2      48.763   9.951  10.034  1.00 17.20           O  
ATOM     13  CB  LYS A   2      50.446   7.731   8.826  1.00 20.58           C  
ATOM     14  CG  LYS A   2      50.599   8.395   7.479  1.00 24.10           C  
ATOM     15  CD  LYS A   2      50.772   7.396   6.336  1.00 30.79           C  
ATOM     16  CE  LYS A   2      49.478   7.136   5.570  1.00 32.95           C  
ATOM     17  NZ  LYS A   2      49.817   6.729   4.141  1.00 35.92           N  
ATOM     18  N   THR A   3      50.676  11.086   9.624  1.00 16.80           N  
ATOM     19  CA  THR A   3      50.023  12.400   9.520  1.00 16.00           C  
ATOM     20  C   THR A   3      49.847  12.791   8.053  1.00 15.35           C  
ATOM     21  O   THR A   3      50.808  12.783   7.257  1.00 15.05           O  
ATOM     22  CB  THR A   3      50.863  13.522  10.190  1.00 16.46           C  
ATOM     23  OG1 THR A   3      51.039  13.211  11.572  1.00 19.00           O  
ATOM     24  CG2 THR A   3      50.163  14.895  10.100  1.00 16.61           C  
ATOM     25  N   ILE A   4      48.616  13.154   7.726  1.00 14.34           N  
ATOM     26  CA  ILE A   4      48.237  13.572   6.405  1.00 14.09           C  
ATOM     27  C   ILE A   4      47.858  15.051   6.489  1.00 14.24           C  
ATOM     28  O   ILE A   4      46.978  15.432   7.273  1.00 14.44           O  
ATOM     29  CB  ILE A   4      47.009  12.758   5.912  1.00 14.88           C  
ATOM     30  CG1 ILE A   4      47.245  11.245   6.123  1.00 14.46           C  
ATOM     31  CG2 ILE A   4      46.620  13.178   4.439  1.00 14.05           C  
ATOM     32  CD1 ILE A   4      48.332  10.705   5.253  1.00 19.06           C  
ATOM     33  N   ASN A   5      48.476  15.862   5.641  1.00 14.66           N  
ATOM     34  CA  ASN A   5      48.232  17.310   5.642  1.00 14.69           C  
ATOM     35  C   ASN A   5      47.208  17.740   4.597  1.00 14.36           C  
ATOM     36  O   ASN A   5      47.323  17.354   3.433  1.00 13.94           O  
ATOM     37  CB  ASN A   5      49.572  18.036   5.435  1.00 14.24           C  
ATOM     38  CG  ASN A   5      50.527  17.730   6.528  1.00 17.06           C  
ATOM     39  OD1 ASN A   5      50.252  18.040   7.678  1.00 15.00           O  
ATOM     40  ND2 ASN A   5      51.641  17.059   6.198  1.00 15.62           N  
ATOM     41  N   LEU A   6      46.223  18.551   5.009  1.00 14.06           N  
ATOM     42  CA  LEU A   6      45.105  18.923   4.140  1.00 14.47           C  
ATOM     43  C   LEU A   6      45.024  20.408   3.910  1.00 14.76           C  
ATOM     44  O   LEU A   6      45.333  21.182   4.810  1.00 14.39           O  
ATOM     45  CB  LEU A   6      43.767  18.563   4.794  1.00 14.40           C  
ATOM     46  CG  LEU A   6      43.665  17.091   5.225  1.00 15.85           C  
ATOM     47  CD1 LEU A   6      42.307  16.854   5.874  1.00 17.56           C  
ATOM     48  CD2 LEU A   6      43.862  16.175   4.029  1.00 16.23           C  
ATOM     49  N   SER A   7      44.520  20.803   2.732  1.00 13.54           N  
ATOM     50  CA  SER A   7      44.147  22.211   2.531  1.00 14.62           C  
ATOM     51  C   SER A   7      42.644  22.168   2.195  1.00 15.00           C  
ATOM     52  O   SER A   7      42.250  21.473   1.243  1.00 15.68           O  
ATOM     53  CB  SER A   7      44.964  22.810   1.374  1.00 14.18           C  
ATOM     54  OG  SER A   7      46.346  22.985   1.747  1.00 16.08           O  
ATOM     55  N   ILE A   8      41.834  22.859   2.987  1.00 13.85           N  
ATOM     56  CA  ILE A   8      40.378  22.787   2.858  1.00 14.20           C  
ATOM     57  C   ILE A   8      39.822  24.093   2.258  1.00 14.57           C  
ATOM     58  O   ILE A   8      40.091  25.175   2.757  1.00 14.31           O  
ATOM     59  CB  ILE A   8      39.766  22.529   4.225  1.00 15.01           C  
ATOM     60  CG1 ILE A   8      40.270  21.131   4.707  1.00 19.34           C  
ATOM     61  CG2 ILE A   8      38.184  22.507   4.135  1.00 13.61           C  
ATOM     62  CD1 ILE A   8      40.045  20.913   6.131  1.00 26.40           C  
ATOM     63  N   PHE A   9      39.114  23.978   1.142  1.00 14.10           N  
ATOM     64  CA  PHE A   9      38.623  25.164   0.451  1.00 14.37           C  
ATOM     65  C   PHE A   9      37.115  25.099   0.563  1.00 14.51           C  
ATOM     66  O   PHE A   9      36.485  24.193   0.008  1.00 14.02           O  
ATOM     67  CB  PHE A   9      39.029  25.168  -1.020  1.00 13.89           C  
ATOM     68  CG  PHE A   9      40.497  25.302  -1.247  1.00 15.57           C  
ATOM     69  CD1 PHE A   9      41.019  26.509  -1.715  1.00 16.40           C  
ATOM     70  CD2 PHE A   9      41.371  24.232  -0.986  1.00 17.73           C  
ATOM     71  CE1 PHE A   9      42.409  26.640  -1.954  1.00 16.17           C  
ATOM     72  CE2 PHE A   9      42.732  24.368  -1.187  1.00 17.53           C  
ATOM     73  CZ  PHE A   9      43.248  25.581  -1.679  1.00 14.88           C  
ATOM     74  N   GLY A  10      36.539  26.050   1.278  1.00 14.35           N  
ATOM     75  CA  GLY A  10      35.097  26.094   1.516  1.00 15.70           C  
ATOM     76  C   GLY A  10      34.746  25.756   2.956  1.00 15.36           C  
ATOM     77  O   GLY A  10      35.074  24.656   3.446  1.00 15.06           O  
ATOM     78  N   LEU A  11      34.068  26.705   3.624  1.00 15.13           N  
ATOM     79  CA  LEU A  11      33.629  26.529   5.020  1.00 15.79           C  
ATOM     80  C   LEU A  11      32.128  26.710   5.186  1.00 15.86           C  
ATOM     81  O   LEU A  11      31.675  27.246   6.197  1.00 14.52           O  
ATOM     82  CB  LEU A  11      34.420  27.457   5.995  1.00 16.89           C  
ATOM     83  CG  LEU A  11      35.917  27.097   6.088  1.00 15.78           C  
ATOM     84  CD1 LEU A  11      36.565  28.082   7.062  1.00 21.63           C  
ATOM     85  CD2 LEU A  11      36.201  25.628   6.478  1.00 20.15           C  
ATOM     86  N   GLY A  12      31.370  26.254   4.175  1.00 15.86           N  
ATOM     87  CA  GLY A  12      29.906  26.209   4.249  1.00 15.39           C  
ATOM     88  C   GLY A  12      29.502  24.996   5.072  1.00 15.61           C  
ATOM     89  O   GLY A  12      30.299  24.491   5.848  1.00 16.17           O  
ATOM     90  N   ASN A  13      28.261  24.531   4.930  1.00 14.56           N  
ATOM     91  CA  ASN A  13      27.798  23.478   5.815  1.00 15.94           C  
ATOM     92  C   ASN A  13      28.668  22.207   5.747  1.00 15.89           C  
ATOM     93  O   ASN A  13      28.918  21.569   6.774  1.00 15.72           O  
ATOM     94  CB  ASN A  13      26.338  23.132   5.543  1.00 16.97           C  
ATOM     95  CG  ASN A  13      25.436  24.285   5.787  1.00 19.48           C  
ATOM     96  OD1 ASN A  13      25.700  25.106   6.664  1.00 20.76           O  
ATOM     97  ND2 ASN A  13      24.341  24.361   5.028  1.00 23.37           N  
ATOM     98  N   VAL A  14      29.130  21.855   4.551  1.00 13.68           N  
ATOM     99  CA  VAL A  14      29.962  20.642   4.432  1.00 14.11           C  
ATOM    100  C   VAL A  14      31.360  20.878   4.997  1.00 14.54           C  
ATOM    101  O   VAL A  14      31.837  20.085   5.807  1.00 14.19           O  
ATOM    102  CB  VAL A  14      29.995  20.138   2.971  1.00 14.80           C  
ATOM    103  CG1 VAL A  14      30.959  18.929   2.813  1.00 17.30           C  
ATOM    104  CG2 VAL A  14      28.531  19.770   2.509  1.00 15.05           C  
ATOM    105  N   GLY A  15      32.013  21.967   4.582  1.00 13.14           N  
ATOM    106  CA  GLY A  15      33.402  22.206   4.974  1.00 13.37           C  
ATOM    107  C   GLY A  15      33.538  22.416   6.471  1.00 13.23           C  
ATOM    108  O   GLY A  15      34.472  21.903   7.073  1.00 14.25           O  
ATOM    109  N   LEU A  16      32.601  23.144   7.067  1.00 13.15           N  
ATOM    110  CA  LEU A  16      32.636  23.374   8.504  1.00 13.40           C  
ATOM    111  C   LEU A  16      32.399  22.065   9.305  1.00 13.67           C  
ATOM    112  O   LEU A  16      33.074  21.800  10.306  1.00 13.73           O  
ATOM    113  CB  LEU A  16      31.644  24.467   8.893  1.00 12.69           C  
ATOM    114  CG  LEU A  16      31.697  24.975  10.335  1.00 12.50           C  
ATOM    115  CD1 LEU A  16      33.091  25.488  10.747  1.00 13.41           C  
ATOM    116  CD2 LEU A  16      30.639  26.027  10.560  1.00 14.84           C  
ATOM    117  N   ASN A  17      31.410  21.276   8.907  1.00 12.84           N  
ATOM    118  CA  ASN A  17      31.236  19.968   9.511  1.00 13.44           C  
ATOM    119  C   ASN A  17      32.437  19.059   9.284  1.00 14.12           C  
ATOM    120  O   ASN A  17      32.758  18.219  10.144  1.00 14.52           O  
ATOM    121  CB  ASN A  17      29.946  19.320   8.969  1.00 12.91           C  
ATOM    122  CG  ASN A  17      28.743  19.824   9.687  1.00 17.59           C  
ATOM    123  OD1 ASN A  17      28.697  19.776  10.928  1.00 17.32           O  
ATOM    124  ND2 ASN A  17      27.764  20.331   8.944  1.00 18.27           N  
ATOM    125  N   LEU A  18      33.102  19.181   8.137  1.00 13.76           N  
ATOM    126  CA  LEU A  18      34.327  18.411   7.928  1.00 13.80           C  
ATOM    127  C   LEU A  18      35.410  18.726   8.981  1.00 14.49           C  
ATOM    128  O   LEU A  18      36.065  17.811   9.503  1.00 13.32           O  
ATOM    129  CB  LEU A  18      34.887  18.628   6.514  1.00 14.40           C  
ATOM    130  CG  LEU A  18      36.196  17.870   6.264  1.00 15.94           C  
ATOM    131  CD1 LEU A  18      36.016  16.342   6.285  1.00 17.42           C  
ATOM    132  CD2 LEU A  18      36.771  18.343   4.912  1.00 16.57           C  
ATOM    133  N   LEU A  19      35.601  20.022   9.277  1.00 13.76           N  
ATOM    134  CA  LEU A  19      36.501  20.398  10.380  1.00 13.68           C  
ATOM    135  C   LEU A  19      36.132  19.724  11.703  1.00 13.60           C  
ATOM    136  O   LEU A  19      36.997  19.227  12.395  1.00 13.19           O  
ATOM    137  CB  LEU A  19      36.539  21.925  10.565  1.00 12.25           C  
ATOM    138  CG  LEU A  19      37.074  22.721   9.360  1.00 14.60           C  
ATOM    139  CD1 LEU A  19      37.233  24.204   9.785  1.00 12.19           C  
ATOM    140  CD2 LEU A  19      38.441  22.187   8.929  1.00 15.73           C  
ATOM    141  N   ARG A  20      34.847  19.723  12.051  1.00 13.79           N  
ATOM    142  CA  ARG A  20      34.390  19.094  13.278  1.00 13.88           C  
ATOM    143  C   ARG A  20      34.738  17.596  13.255  1.00 14.45           C  
ATOM    144  O   ARG A  20      35.235  17.049  14.250  1.00 13.93           O  
ATOM    145  CB  ARG A  20      32.862  19.250  13.411  1.00 13.07           C  
ATOM    146  CG  ARG A  20      32.417  20.693  13.739  1.00 13.79           C  
ATOM    147  CD  ARG A  20      30.895  20.760  13.807  1.00 16.51           C  
ATOM    148  NE  ARG A  20      30.508  22.143  14.099  1.00 15.09           N  
ATOM    149  CZ  ARG A  20      29.807  22.900  13.278  1.00 17.09           C  
ATOM    150  NH1 ARG A  20      29.367  22.402  12.129  1.00 16.99           N  
ATOM    151  NH2 ARG A  20      29.531  24.164  13.628  1.00 19.02           N  
ATOM    152  N   ILE A  21      34.473  16.954  12.110  1.00 13.36           N  
ATOM    153  CA  ILE A  21      34.711  15.529  11.949  1.00 15.20           C  
ATOM    154  C   ILE A  21      36.200  15.244  12.064  1.00 15.11           C  
ATOM    155  O   ILE A  21      36.580  14.320  12.749  1.00 14.68           O  
ATOM    156  CB  ILE A  21      34.151  15.005  10.590  1.00 15.33           C  
ATOM    157  CG1 ILE A  21      32.603  15.054  10.657  1.00 15.00           C  
ATOM    158  CG2 ILE A  21      34.697  13.579  10.288  1.00 16.44           C  
ATOM    159  CD1 ILE A  21      31.920  14.715   9.327  1.00 16.16           C  
ATOM    160  N   ILE A  22      37.033  16.064  11.419  1.00 14.72           N  
ATOM    161  CA  ILE A  22      38.484  15.844  11.524  1.00 16.44           C  
ATOM    162  C   ILE A  22      38.949  15.859  12.997  1.00 16.22           C  
ATOM    163  O   ILE A  22      39.741  15.005  13.421  1.00 15.59           O  
ATOM    164  CB  ILE A  22      39.275  16.903  10.700  1.00 16.49           C  
ATOM    165  CG1 ILE A  22      39.049  16.640   9.189  1.00 17.24           C  
ATOM    166  CG2 ILE A  22      40.800  16.895  11.107  1.00 16.06           C  
ATOM    167  CD1 ILE A  22      39.439  17.848   8.277  1.00 15.88           C  
ATOM    168  N   ARG A  23      38.465  16.827  13.772  1.00 16.88           N  
ATOM    169  CA  ARG A  23      38.833  16.892  15.180  1.00 18.76           C  
ATOM    170  C   ARG A  23      38.450  15.639  15.954  1.00 18.87           C  
ATOM    171  O   ARG A  23      39.266  15.094  16.687  1.00 19.72           O  
ATOM    172  CB  ARG A  23      38.226  18.116  15.840  1.00 19.70           C  
ATOM    173  CG  ARG A  23      38.775  19.366  15.320  1.00 23.90           C  
ATOM    174  CD  ARG A  23      38.355  20.471  16.250  1.00 31.32           C  
ATOM    175  NE  ARG A  23      38.955  20.282  17.562  1.00 33.40           N  
ATOM    176  CZ  ARG A  23      38.410  20.700  18.695  1.00 38.34           C  
ATOM    177  NH1 ARG A  23      37.227  21.316  18.681  1.00 39.04           N  
ATOM    178  NH2 ARG A  23      39.050  20.500  19.846  1.00 40.79           N  
ATOM    179  N   SER A  24      37.234  15.148  15.766  1.00 18.52           N  
ATOM    180  CA  SER A  24      36.812  13.941  16.468  0.60 18.52           C  
ATOM    182  C   SER A  24      37.561  12.719  15.959  1.00 18.20           C  
ATOM    183  O   SER A  24      37.916  11.849  16.744  1.00 18.19           O  
ATOM    184  CB  SER A  24      35.305  13.722  16.325  0.60 18.51           C  
ATOM    186  OG  SER A  24      34.601  14.656  17.123  0.60 20.35           O  
ATOM    188  N   PHE A  25      37.777  12.652  14.649  1.00 17.24           N  
ATOM    189  CA  PHE A  25      38.493  11.530  14.057  1.00 16.57           C  
ATOM    190  C   PHE A  25      39.915  11.443  14.630  1.00 17.02           C  
ATOM    191  O   PHE A  25      40.382  10.363  15.007  1.00 17.22           O  
ATOM    192  CB  PHE A  25      38.573  11.711  12.533  1.00 15.41           C  
ATOM    193  CG  PHE A  25      39.327  10.594  11.836  1.00 15.35           C  
ATOM    194  CD1 PHE A  25      38.666   9.417  11.470  1.00 14.29           C  
ATOM    195  CD2 PHE A  25      40.699  10.696  11.632  1.00 14.47           C  
ATOM    196  CE1 PHE A  25      39.340   8.367  10.848  1.00 15.44           C  
ATOM    197  CE2 PHE A  25      41.389   9.666  11.019  1.00 17.30           C  
ATOM    198  CZ  PHE A  25      40.702   8.495  10.618  1.00 16.52           C  
ATOM    199  N   ASN A  26      40.616  12.574  14.646  1.00 17.64           N  
ATOM    200  CA  ASN A  26      41.977  12.611  15.166  1.00 19.56           C  
ATOM    201  C   ASN A  26      42.053  12.072  16.599  1.00 21.78           C  
ATOM    202  O   ASN A  26      42.967  11.300  16.951  1.00 21.13           O  
ATOM    203  CB  ASN A  26      42.530  14.030  15.084  1.00 18.49           C  
ATOM    204  CG  ASN A  26      42.905  14.414  13.679  1.00 17.50           C  
ATOM    205  OD1 ASN A  26      42.999  13.554  12.809  1.00 17.88           O  
ATOM    206  ND2 ASN A  26      43.142  15.707  13.442  1.00 16.95           N  
ATOM    207  N   GLU A  27      41.048  12.423  17.397  1.00 23.98           N  
ATOM    208  CA  GLU A  27      40.943  11.969  18.787  0.50 25.70           C  
ATOM    210  C   GLU A  27      40.641  10.468  18.942  1.00 26.19           C  
ATOM    211  O   GLU A  27      41.175   9.811  19.843  1.00 25.71           O  
ATOM    212  CB  GLU A  27      39.880  12.806  19.522  0.50 25.63           C  
ATOM    214  CG  GLU A  27      40.224  14.300  19.626  0.50 27.01           C  
ATOM    216  CD  GLU A  27      39.166  15.148  20.353  0.50 27.55           C  
ATOM    218  OE1 GLU A  27      39.380  16.382  20.502  0.50 30.68           O  
ATOM    220  OE2 GLU A  27      38.131  14.591  20.780  0.50 30.13           O  
ATOM    222  N   GLU A  28      39.785   9.934  18.060  1.00 27.53           N  
ATOM    223  CA  GLU A  28      39.086   8.647  18.268  0.70 28.68           C  
ATOM    225  C   GLU A  28      39.465   7.473  17.348  1.00 28.91           C  
ATOM    226  O   GLU A  28      39.259   6.287  17.702  1.00 29.47           O  
ATOM    227  CB  GLU A  28      37.572   8.851  18.154  0.70 29.21           C  
ATOM    229  CG  GLU A  28      36.914   9.575  19.316  0.70 30.06           C  
ATOM    231  CD  GLU A  28      35.531   9.011  19.637  0.70 32.96           C  
ATOM    233  OE1 GLU A  28      35.452   8.076  20.466  0.70 32.16           O  
ATOM    235  OE2 GLU A  28      34.525   9.473  19.042  0.70 33.75           O  
ATOM    237  N   ASN A  29      39.981   7.764  16.153  1.00 28.66           N  
ATOM    238  CA  ASN A  29      40.236   6.687  15.178  1.00 27.41           C  
ATOM    239  C   ASN A  29      41.256   5.609  15.622  1.00 28.07           C  
ATOM    240  O   ASN A  29      42.247   5.918  16.291  1.00 27.76           O  
ATOM    241  CB  ASN A  29      40.614   7.259  13.821  1.00 26.77           C  
ATOM    242  CG  ASN A  29      42.120   7.472  13.678  1.00 23.60           C  
ATOM    243  OD1 ASN A  29      42.839   6.583  13.255  1.00 24.12           O  
ATOM    244  ND2 ASN A  29      42.600   8.642  14.080  1.00 21.89           N  
ATOM    245  N   ARG A  30      40.976   4.363  15.223  1.00 27.94           N  
ATOM    246  CA  ARG A  30      41.822   3.199  15.484  0.60 28.93           C  
ATOM    248  C   ARG A  30      42.642   2.840  14.245  1.00 28.57           C  
ATOM    249  O   ARG A  30      43.093   1.675  14.089  1.00 28.70           O  
ATOM    250  CB  ARG A  30      40.949   2.001  15.899  0.60 29.50           C  
ATOM    252  CG  ARG A  30      39.905   2.323  16.983  0.60 32.34           C  
ATOM    254  CD  ARG A  30      39.527   1.082  17.785  0.60 37.15           C  
ATOM    256  NE  ARG A  30      39.682   1.297  19.231  0.60 40.37           N  
ATOM    258  CZ  ARG A  30      40.830   1.177  19.905  0.60 41.69           C  
ATOM    260  NH1 ARG A  30      41.961   0.844  19.286  0.60 42.12           N  
ATOM    262  NH2 ARG A  30      40.849   1.393  21.212  0.60 42.27           N  
ATOM    264  N   LEU A  31      42.824   3.826  13.361  1.00 27.00           N  
ATOM    265  CA  LEU A  31      43.386   3.586  12.054  1.00 25.60           C  
ATOM    266  C   LEU A  31      44.826   4.023  11.980  1.00 25.30           C  
ATOM    267  O   LEU A  31      45.457   3.849  10.940  1.00 25.56           O  
ATOM    268  CB  LEU A  31      42.582   4.330  10.980  1.00 25.34           C  
ATOM    269  CG  LEU A  31      41.083   4.018  10.877  1.00 25.19           C  
ATOM    270  CD1 LEU A  31      40.441   4.800   9.747  1.00 20.91           C  
ATOM    271  CD2 LEU A  31      40.903   2.532  10.668  1.00 28.19           C  
ATOM    272  N   GLY A  32      45.360   4.594  13.060  1.00 23.84           N  
ATOM    273  CA  GLY A  32      46.743   5.065  13.024  1.00 22.89           C  
ATOM    274  C   GLY A  32      46.982   6.268  12.123  1.00 23.20           C  
ATOM    275  O   GLY A  32      48.093   6.442  11.576  1.00 22.43           O  
ATOM    276  N   LEU A  33      45.960   7.124  12.000  1.00 21.74           N  
ATOM    277  CA  LEU A  33      46.028   8.308  11.155  1.00 21.74           C  
ATOM    278  C   LEU A  33      45.819   9.591  11.967  1.00 21.80           C  
ATOM    279  O   LEU A  33      45.128   9.576  12.991  1.00 21.65           O  
ATOM    280  CB  LEU A  33      44.933   8.226  10.060  1.00 21.99           C  
ATOM    281  CG  LEU A  33      45.200   7.273   8.896  1.00 23.05           C  
ATOM    282  CD1 LEU A  33      43.958   7.111   8.029  1.00 21.10           C  
ATOM    283  CD2 LEU A  33      46.345   7.780   8.031  1.00 26.49           C  
ATOM    284  N   LYS A  34      46.382  10.701  11.502  1.00 21.22           N  
ATOM    285  CA  LYS A  34      46.025  12.000  12.072  1.00 21.89           C  
ATOM    286  C   LYS A  34      45.938  12.930  10.880  1.00 20.40           C  
ATOM    287  O   LYS A  34      46.802  12.893  10.022  1.00 21.34           O  
ATOM    288  CB  LYS A  34      47.106  12.445  13.081  1.00 22.33           C  
ATOM    289  CG  LYS A  34      46.933  13.882  13.652  1.00 25.74           C  
ATOM    290  CD  LYS A  34      48.129  14.243  14.596  1.00 26.91           C  
ATOM    291  CE  LYS A  34      49.279  14.870  13.780  1.00 32.83           C  
ATOM    292  NZ  LYS A  34      50.640  14.910  14.435  1.00 32.72           N  
ATOM    293  N   PHE A  35      44.896  13.747  10.799  1.00 18.85           N  
ATOM    294  CA  PHE A  35      44.819  14.723   9.717  1.00 18.65           C  
ATOM    295  C   PHE A  35      45.148  16.091  10.250  1.00 19.27           C  
ATOM    296  O   PHE A  35      44.479  16.564  11.172  1.00 21.42           O  
ATOM    297  CB  PHE A  35      43.432  14.706   9.087  1.00 18.59           C  
ATOM    298  CG  PHE A  35      43.201  13.484   8.250  1.00 17.74           C  
ATOM    299  CD1 PHE A  35      43.561  13.485   6.904  1.00 17.62           C  
ATOM    300  CD2 PHE A  35      42.701  12.322   8.823  1.00 19.16           C  
ATOM    301  CE1 PHE A  35      43.378  12.349   6.098  1.00 17.37           C  
ATOM    302  CE2 PHE A  35      42.489  11.169   8.026  1.00 19.07           C  
ATOM    303  CZ  PHE A  35      42.835  11.185   6.669  1.00 19.51           C  
ATOM    304  N   ASN A  36      46.171  16.702   9.669  1.00 18.08           N  
ATOM    305  CA  ASN A  36      46.596  18.059  10.022  1.00 17.56           C  
ATOM    306  C   ASN A  36      46.134  19.017   8.907  1.00 17.53           C  
ATOM    307  O   ASN A  36      46.284  18.723   7.700  1.00 18.45           O  
ATOM    308  CB  ASN A  36      48.114  18.094  10.231  1.00 18.46           C  
ATOM    309  CG  ASN A  36      48.632  19.514  10.469  1.00 20.23           C  
ATOM    310  OD1 ASN A  36      48.270  20.144  11.456  1.00 23.41           O  
ATOM    311  ND2 ASN A  36      49.469  20.021   9.559  1.00 22.00           N  
ATOM    312  N   VAL A  37      45.510  20.121   9.295  1.00 17.11           N  
ATOM    313  CA  VAL A  37      45.068  21.119   8.328  1.00 16.16           C  
ATOM    314  C   VAL A  37      46.125  22.226   8.262  1.00 17.05           C  
ATOM    315  O   VAL A  37      46.534  22.752   9.315  1.00 16.83           O  
ATOM    316  CB  VAL A  37      43.695  21.660   8.727  1.00 16.13           C  
ATOM    317  CG1 VAL A  37      43.298  22.876   7.866  1.00 15.69           C  
ATOM    318  CG2 VAL A  37      42.648  20.561   8.618  1.00 15.74           C  
ATOM    319  N   VAL A  38      46.585  22.558   7.048  1.00 16.59           N  
ATOM    320  CA  VAL A  38      47.567  23.642   6.889  1.00 16.42           C  
ATOM    321  C   VAL A  38      46.953  24.902   6.275  1.00 16.48           C  
ATOM    322  O   VAL A  38      47.556  25.977   6.323  1.00 16.84           O  
ATOM    323  CB  VAL A  38      48.817  23.204   6.059  1.00 17.08           C  
ATOM    324  CG1 VAL A  38      49.516  22.000   6.726  1.00 16.49           C  
ATOM    325  CG2 VAL A  38      48.449  22.894   4.563  1.00 16.38           C  
ATOM    326  N   PHE A  39      45.758  24.776   5.697  1.00 15.94           N  
ATOM    327  CA  PHE A  39      45.154  25.880   4.988  1.00 15.92           C  
ATOM    328  C   PHE A  39      43.632  25.726   5.043  1.00 16.68           C  
ATOM    329  O   PHE A  39      43.106  24.618   4.832  1.00 17.05           O  
ATOM    330  CB  PHE A  39      45.653  25.880   3.530  1.00 16.05           C  
ATOM    331  CG  PHE A  39      45.002  26.920   2.668  1.00 17.26           C  
ATOM    332  CD1 PHE A  39      45.506  28.211   2.610  1.00 16.59           C  
ATOM    333  CD2 PHE A  39      43.820  26.622   1.970  1.00 19.21           C  
ATOM    334  CE1 PHE A  39      44.868  29.203   1.816  1.00 18.18           C  
ATOM    335  CE2 PHE A  39      43.198  27.588   1.206  1.00 18.82           C  
ATOM    336  CZ  PHE A  39      43.727  28.868   1.107  1.00 18.74           C  
ATOM    337  N   VAL A  40      42.924  26.824   5.325  1.00 16.40           N  
ATOM    338  CA  VAL A  40      41.447  26.860   5.179  1.00 15.56           C  
ATOM    339  C   VAL A  40      41.067  28.131   4.426  1.00 17.29           C  
ATOM    340  O   VAL A  40      41.679  29.201   4.634  1.00 17.05           O  
ATOM    341  CB  VAL A  40      40.711  26.830   6.524  1.00 16.15           C  
ATOM    342  CG1 VAL A  40      41.052  25.591   7.271  1.00 18.00           C  
ATOM    343  CG2 VAL A  40      41.098  28.049   7.396  1.00 15.95           C  
ATOM    344  N   ALA A  41      40.110  28.029   3.506  1.00 17.12           N  
ATOM    345  CA  ALA A  41      39.586  29.224   2.880  1.00 17.56           C  
ATOM    346  C   ALA A  41      38.080  29.214   2.871  1.00 18.95           C  
ATOM    347  O   ALA A  41      37.441  28.150   2.770  1.00 18.52           O  
ATOM    348  CB  ALA A  41      40.104  29.384   1.480  1.00 17.61           C  
ATOM    349  N   ASP A  42      37.487  30.394   2.990  1.00 19.72           N  
ATOM    350  CA  ASP A  42      36.085  30.525   2.625  1.00 22.55           C  
ATOM    351  C   ASP A  42      36.002  31.674   1.595  1.00 23.53           C  
ATOM    352  O   ASP A  42      37.011  31.992   0.972  1.00 24.84           O  
ATOM    353  CB  ASP A  42      35.250  30.721   3.874  1.00 22.73           C  
ATOM    354  CG  ASP A  42      35.585  32.016   4.608  1.00 26.98           C  
ATOM    355  OD1 ASP A  42      36.237  32.919   4.004  1.00 24.66           O  
ATOM    356  OD2 ASP A  42      35.158  32.127   5.781  1.00 32.37           O  
ATOM    357  N   SER A  43      34.850  32.299   1.388  1.00 24.61           N  
ATOM    358  CA  SER A  43      34.778  33.302   0.319  1.00 26.16           C  
ATOM    359  C   SER A  43      35.435  34.594   0.732  1.00 27.35           C  
ATOM    360  O   SER A  43      35.693  35.459  -0.114  1.00 28.56           O  
ATOM    361  CB  SER A  43      33.338  33.575  -0.125  1.00 26.89           C  
ATOM    362  OG  SER A  43      32.581  34.172   0.915  1.00 27.59           O  
ATOM    363  N   LEU A  44      35.692  34.756   2.024  1.00 27.42           N  
ATOM    364  CA  LEU A  44      36.237  36.027   2.508  1.00 28.41           C  
ATOM    365  C   LEU A  44      37.713  35.932   2.932  1.00 28.60           C  
ATOM    366  O   LEU A  44      38.443  36.912   2.804  1.00 30.26           O  
ATOM    367  CB  LEU A  44      35.366  36.594   3.652  1.00 29.06           C  
ATOM    368  CG  LEU A  44      33.843  36.516   3.465  1.00 31.28           C  
ATOM    369  CD1 LEU A  44      33.067  36.784   4.774  1.00 33.49           C  
ATOM    370  CD2 LEU A  44      33.396  37.473   2.347  1.00 33.36           C  
ATOM    371  N   HIS A  45      38.146  34.755   3.376  1.00 25.87           N  
ATOM    372  CA  HIS A  45      39.443  34.588   4.036  1.00 25.70           C  
ATOM    373  C   HIS A  45      40.191  33.395   3.507  1.00 23.82           C  
ATOM    374  O   HIS A  45      39.557  32.412   3.058  1.00 23.11           O  
ATOM    375  CB  HIS A  45      39.229  34.376   5.536  1.00 26.46           C  
ATOM    376  CG  HIS A  45      38.197  35.286   6.111  1.00 30.37           C  
ATOM    377  ND1 HIS A  45      38.491  36.562   6.536  1.00 33.39           N  
ATOM    378  CD2 HIS A  45      36.860  35.132   6.262  1.00 33.17           C  
ATOM    379  CE1 HIS A  45      37.382  37.152   6.947  1.00 34.84           C  
ATOM    380  NE2 HIS A  45      36.379  36.303   6.799  1.00 34.63           N  
ATOM    381  N   SER A  46      41.523  33.483   3.535  1.00 22.04           N  
ATOM    382  CA  SER A  46      42.390  32.363   3.147  0.50 22.18           C  
ATOM    384  C   SER A  46      43.553  32.334   4.112  1.00 22.42           C  
ATOM    385  O   SER A  46      44.400  33.227   4.085  1.00 24.23           O  
ATOM    386  CB  SER A  46      42.903  32.521   1.718  0.50 22.47           C  
ATOM    388  OG  SER A  46      41.830  32.704   0.826  0.50 22.32           O  
ATOM    390  N   TYR A  47      43.582  31.331   4.980  1.00 20.30           N  
ATOM    391  CA  TYR A  47      44.561  31.283   6.055  1.00 18.96           C  
ATOM    392  C   TYR A  47      45.452  30.066   5.944  1.00 18.39           C  
ATOM    393  O   TYR A  47      44.949  28.949   5.727  1.00 16.97           O  
ATOM    394  CB  TYR A  47      43.845  31.231   7.388  1.00 19.18           C  
ATOM    395  CG  TYR A  47      43.079  32.488   7.736  1.00 22.20           C  
ATOM    396  CD1 TYR A  47      43.706  33.716   7.724  1.00 22.73           C  
ATOM    397  CD2 TYR A  47      41.732  32.435   8.127  1.00 24.41           C  
ATOM    398  CE1 TYR A  47      43.042  34.876   8.090  1.00 26.73           C  
ATOM    399  CE2 TYR A  47      41.046  33.607   8.506  1.00 26.65           C  
ATOM    400  CZ  TYR A  47      41.713  34.817   8.477  1.00 25.40           C  
ATOM    401  OH  TYR A  47      41.085  36.005   8.816  1.00 27.87           O  
ATOM    402  N   TYR A  48      46.764  30.288   6.086  1.00 17.10           N  
ATOM    403  CA  TYR A  48      47.767  29.199   6.060  1.00 17.22           C  
ATOM    404  C   TYR A  48      48.486  29.155   7.402  1.00 17.05           C  
ATOM    405  O   TYR A  48      48.766  30.203   7.979  1.00 15.80           O  
ATOM    406  CB  TYR A  48      48.796  29.404   4.937  1.00 18.47           C  
ATOM    407  CG  TYR A  48      49.886  28.376   4.998  1.00 19.92           C  
ATOM    408  CD1 TYR A  48      49.741  27.149   4.348  1.00 18.70           C  
ATOM    409  CD2 TYR A  48      51.046  28.605   5.740  1.00 19.51           C  
ATOM    410  CE1 TYR A  48      50.709  26.161   4.454  1.00 20.12           C  
ATOM    411  CE2 TYR A  48      52.044  27.618   5.849  1.00 23.73           C  
ATOM    412  CZ  TYR A  48      51.864  26.406   5.193  1.00 22.06           C  
ATOM    413  OH  TYR A  48      52.843  25.454   5.285  1.00 25.01           O  
ATOM    414  N   ASN A  49      48.773  27.949   7.900  1.00 16.32           N  
ATOM    415  CA  ASN A  49      49.650  27.776   9.052  1.00 18.09           C  
ATOM    416  C   ASN A  49      50.102  26.329   9.012  1.00 19.03           C  
ATOM    417  O   ASN A  49      49.324  25.455   8.613  1.00 17.48           O  
ATOM    418  CB  ASN A  49      48.941  28.143  10.372  1.00 16.71           C  
ATOM    419  CG  ASN A  49      49.880  28.132  11.569  1.00 19.40           C  
ATOM    420  OD1 ASN A  49      50.149  27.076  12.142  1.00 18.96           O  
ATOM    421  ND2 ASN A  49      50.389  29.310  11.944  1.00 18.63           N  
ATOM    422  N   GLU A  50      51.354  26.068   9.375  1.00 19.55           N  
ATOM    423  CA  GLU A  50      51.868  24.683   9.508  0.50 21.06           C  
ATOM    425  C   GLU A  50      50.913  23.759  10.248  1.00 20.30           C  
ATOM    426  O   GLU A  50      50.845  22.558   9.969  1.00 20.25           O  
ATOM    427  CB  GLU A  50      53.241  24.662  10.200  0.50 21.20           C  
ATOM    429  CG  GLU A  50      54.418  24.565   9.234  0.50 23.43           C  
ATOM    431  CD  GLU A  50      55.756  24.236   9.898  0.50 23.07           C  
ATOM    433  OE1 GLU A  50      55.792  23.574  10.963  0.50 26.64           O  
ATOM    435  OE2 GLU A  50      56.802  24.637   9.342  0.50 29.95           O  
ATOM    437  N   ARG A  51      50.191  24.316  11.219  1.00 20.44           N  
ATOM    438  CA  ARG A  51      49.234  23.551  12.031  0.50 20.99           C  
ATOM    440  C   ARG A  51      48.053  24.432  12.417  1.00 20.37           C  
ATOM    441  O   ARG A  51      48.030  25.026  13.497  1.00 19.21           O  
ATOM    442  CB  ARG A  51      49.907  23.032  13.305  0.50 21.83           C  
ATOM    444  CG  ARG A  51      50.540  21.630  13.226  0.50 23.25           C  
ATOM    446  CD  ARG A  51      51.290  21.301  14.548  0.50 24.58           C  
ATOM    448  NE  ARG A  51      52.581  21.995  14.606  0.50 30.50           N  
ATOM    450  CZ  ARG A  51      52.815  23.140  15.248  0.50 32.79           C  
ATOM    452  NH1 ARG A  51      54.024  23.679  15.194  0.50 34.86           N  
ATOM    454  NH2 ARG A  51      51.857  23.753  15.944  0.50 36.15           N  
ATOM    456  N   ILE A  52      47.086  24.562  11.522  1.00 18.75           N  
ATOM    457  CA  ILE A  52      45.937  25.388  11.796  1.00 18.21           C  
ATOM    458  C   ILE A  52      45.291  24.817  13.053  1.00 19.16           C  
ATOM    459  O   ILE A  52      45.244  23.606  13.222  1.00 19.37           O  
ATOM    460  CB  ILE A  52      44.940  25.355  10.592  1.00 17.75           C  
ATOM    461  CG1 ILE A  52      45.517  26.071   9.369  1.00 18.91           C  
ATOM    462  CG2 ILE A  52      43.573  25.916  10.963  1.00 18.37           C  
ATOM    463  CD1 ILE A  52      45.528  27.612   9.410  1.00 20.54           C  
ATOM    464  N   ASP A  53      44.820  25.700  13.934  1.00 19.16           N  
ATOM    465  CA  ASP A  53      44.060  25.293  15.102  1.00 19.47           C  
ATOM    466  C   ASP A  53      42.604  25.123  14.636  1.00 19.31           C  
ATOM    467  O   ASP A  53      41.871  26.106  14.445  1.00 18.91           O  
ATOM    468  CB  ASP A  53      44.218  26.346  16.218  1.00 20.07           C  
ATOM    469  CG  ASP A  53      43.407  26.019  17.466  1.00 21.99           C  
ATOM    470  OD1 ASP A  53      42.370  25.308  17.376  1.00 22.11           O  
ATOM    471  OD2 ASP A  53      43.774  26.545  18.542  1.00 25.35           O  
ATOM    472  N   ILE A  54      42.210  23.869  14.418  1.00 18.56           N  
ATOM    473  CA  ILE A  54      40.914  23.583  13.823  1.00 19.72           C  
ATOM    474  C   ILE A  54      39.790  24.033  14.726  1.00 18.48           C  
ATOM    475  O   ILE A  54      38.812  24.599  14.254  1.00 19.30           O  
ATOM    476  CB  ILE A  54      40.724  22.066  13.511  1.00 20.10           C  
ATOM    477  CG1 ILE A  54      41.818  21.587  12.559  1.00 20.53           C  
ATOM    478  CG2 ILE A  54      39.351  21.834  12.870  1.00 19.46           C  
ATOM    479  CD1 ILE A  54      41.900  20.044  12.476  1.00 21.09           C  
ATOM    480  N   GLY A  55      39.913  23.776  16.012  1.00 17.98           N  
ATOM    481  CA  GLY A  55      38.902  24.242  16.953  1.00 19.41           C  
ATOM    482  C   GLY A  55      38.671  25.741  16.898  1.00 20.21           C  
ATOM    483  O   GLY A  55      37.535  26.201  16.978  1.00 19.96           O  
ATOM    484  N   LYS A  56      39.745  26.510  16.801  1.00 21.10           N  
ATOM    485  CA  LYS A  56      39.638  27.971  16.685  1.00 22.31           C  
ATOM    486  C   LYS A  56      38.945  28.419  15.400  1.00 21.83           C  
ATOM    487  O   LYS A  56      38.170  29.392  15.402  1.00 21.98           O  
ATOM    488  CB  LYS A  56      41.032  28.589  16.708  1.00 23.68           C  
ATOM    489  CG  LYS A  56      41.109  29.981  17.292  1.00 27.71           C  
ATOM    490  CD  LYS A  56      42.559  30.443  17.302  1.00 32.67           C  
ATOM    491  CE  LYS A  56      42.958  30.991  18.678  1.00 37.45           C  
ATOM    492  NZ  LYS A  56      42.616  32.428  18.888  1.00 39.90           N  
ATOM    493  N   VAL A  57      39.280  27.760  14.285  1.00 20.36           N  
ATOM    494  CA  VAL A  57      38.620  28.037  13.014  1.00 19.75           C  
ATOM    495  C   VAL A  57      37.105  27.793  13.130  1.00 19.76           C  
ATOM    496  O   VAL A  57      36.308  28.630  12.665  1.00 20.32           O  
ATOM    497  CB  VAL A  57      39.239  27.209  11.849  1.00 18.89           C  
ATOM    498  CG1 VAL A  57      38.521  27.466  10.509  1.00 18.75           C  
ATOM    499  CG2 VAL A  57      40.725  27.573  11.712  1.00 19.49           C  
ATOM    500  N   ILE A  58      36.722  26.636  13.691  1.00 18.40           N  
ATOM    501  CA  ILE A  58      35.301  26.328  13.905  1.00 18.58           C  
ATOM    502  C   ILE A  58      34.637  27.431  14.738  1.00 20.01           C  
ATOM    503  O   ILE A  58      33.593  28.000  14.338  1.00 19.50           O  
ATOM    504  CB  ILE A  58      35.120  24.971  14.594  1.00 18.41           C  
ATOM    505  CG1 ILE A  58      35.565  23.858  13.636  1.00 16.81           C  
ATOM    506  CG2 ILE A  58      33.644  24.744  14.994  1.00 17.28           C  
ATOM    507  CD1 ILE A  58      35.799  22.540  14.338  1.00 13.73           C  
ATOM    508  N   SER A  59      35.266  27.754  15.862  1.00 19.66           N  
ATOM    509  CA  SER A  59      34.704  28.729  16.775  1.00 22.35           C  
ATOM    510  C   SER A  59      34.527  30.094  16.085  1.00 22.76           C  
ATOM    511  O   SER A  59      33.477  30.741  16.209  1.00 24.82           O  
ATOM    512  CB  SER A  59      35.629  28.897  17.983  1.00 21.27           C  
ATOM    513  OG  SER A  59      35.002  29.755  18.907  1.00 27.46           O  
ATOM    514  N   TYR A  60      35.543  30.537  15.366  1.00 23.21           N  
ATOM    515  CA  TYR A  60      35.479  31.860  14.771  1.00 24.82           C  
ATOM    516  C   TYR A  60      34.442  31.908  13.655  1.00 23.92           C  
ATOM    517  O   TYR A  60      33.680  32.896  13.526  1.00 22.88           O  
ATOM    518  CB  TYR A  60      36.867  32.328  14.323  1.00 26.67           C  
ATOM    519  CG  TYR A  60      37.734  32.879  15.478  1.00 31.02           C  
ATOM    520  CD1 TYR A  60      38.003  32.111  16.626  1.00 32.49           C  
ATOM    521  CD2 TYR A  60      38.300  34.156  15.402  1.00 33.52           C  
ATOM    522  CE1 TYR A  60      38.819  32.618  17.681  1.00 35.74           C  
ATOM    523  CE2 TYR A  60      39.130  34.670  16.440  1.00 36.20           C  
ATOM    524  CZ  TYR A  60      39.384  33.884  17.573  1.00 34.79           C  
ATOM    525  OH  TYR A  60      40.178  34.382  18.602  1.00 34.59           O  
ATOM    526  N   LYS A  61      34.397  30.836  12.867  1.00 22.59           N  
ATOM    527  CA  LYS A  61      33.391  30.700  11.829  1.00 22.12           C  
ATOM    528  C   LYS A  61      31.970  30.642  12.409  1.00 22.81           C  
ATOM    529  O   LYS A  61      31.055  31.274  11.870  1.00 22.48           O  
ATOM    530  CB  LYS A  61      33.682  29.476  10.930  1.00 22.20           C  
ATOM    531  CG  LYS A  61      32.719  29.351   9.745  1.00 24.47           C  
ATOM    532  CD  LYS A  61      33.103  30.313   8.589  1.00 27.68           C  
ATOM    533  CE  LYS A  61      31.988  30.461   7.573  1.00 28.54           C  
ATOM    534  NZ  LYS A  61      32.481  31.340   6.472  1.00 33.66           N  
ATOM    535  N   GLU A  62      31.768  29.918  13.508  1.00 23.16           N  
ATOM    536  CA  GLU A  62      30.435  29.914  14.142  1.00 25.34           C  
ATOM    537  C   GLU A  62      30.027  31.308  14.638  1.00 26.74           C  
ATOM    538  O   GLU A  62      28.851  31.710  14.570  1.00 26.28           O  
ATOM    539  CB  GLU A  62      30.382  28.926  15.312  1.00 25.71           C  
ATOM    540  CG  GLU A  62      30.460  27.460  14.895  1.00 26.13           C  
ATOM    541  CD  GLU A  62      30.624  26.513  16.098  1.00 26.74           C  
ATOM    542  OE1 GLU A  62      31.118  26.945  17.185  1.00 24.94           O  
ATOM    543  OE2 GLU A  62      30.260  25.331  15.942  1.00 25.08           O  
ATOM    544  N   LYS A  63      30.996  32.054  15.133  1.00 27.95           N  
ATOM    545  CA  LYS A  63      30.705  33.350  15.730  1.00 30.01           C  
ATOM    546  C   LYS A  63      30.612  34.426  14.663  1.00 31.00           C  
ATOM    547  O   LYS A  63      30.304  35.580  14.961  1.00 31.89           O  
ATOM    548  CB  LYS A  63      31.780  33.704  16.764  1.00 30.35           C  
ATOM    549  CG  LYS A  63      31.739  32.815  17.987  1.00 32.02           C  
ATOM    550  CD  LYS A  63      32.934  33.038  18.872  1.00 34.78           C  
ATOM    551  CE  LYS A  63      32.948  32.004  19.983  1.00 38.58           C  
ATOM    552  NZ  LYS A  63      34.203  32.118  20.779  1.00 40.50           N  
ATOM    553  N   GLY A  64      30.876  34.042  13.419  1.00 32.44           N  
ATOM    554  CA  GLY A  64      30.987  34.988  12.314  1.00 33.80           C  
ATOM    555  C   GLY A  64      32.066  36.017  12.604  1.00 35.47           C  
ATOM    556  O   GLY A  64      31.803  37.224  12.616  1.00 35.45           O  
ATOM    557  N   SER A  65      33.283  35.539  12.859  1.00 35.91           N  
ATOM    558  CA  SER A  65      34.395  36.421  13.146  1.00 36.18           C  
ATOM    559  C   SER A  65      35.760  35.798  12.754  1.00 35.35           C  
ATOM    560  O   SER A  65      36.754  35.922  13.491  1.00 35.54           O  
ATOM    561  CB  SER A  65      34.356  36.875  14.620  1.00 36.86           C  
ATOM    562  OG  SER A  65      34.884  35.873  15.469  1.00 40.54           O  
ATOM    563  N   LEU A  66      35.811  35.166  11.577  1.00 33.50           N  
ATOM    564  CA  LEU A  66      37.090  34.756  10.968  1.00 31.76           C  
ATOM    565  C   LEU A  66      37.987  35.933  10.588  1.00 31.07           C  
ATOM    566  O   LEU A  66      39.199  35.756  10.482  1.00 30.89           O  
ATOM    567  CB  LEU A  66      36.879  33.888   9.729  1.00 31.53           C  
ATOM    568  CG  LEU A  66      36.603  32.392   9.875  1.00 30.18           C  
ATOM    569  CD1 LEU A  66      36.481  31.808   8.485  1.00 29.34           C  
ATOM    570  CD2 LEU A  66      37.691  31.672  10.655  1.00 27.65           C  
ATOM    571  N   ASP A  67      37.392  37.116  10.375  1.00 30.08           N  
ATOM    572  CA  ASP A  67      38.140  38.384  10.222  1.00 29.36           C  
ATOM    573  C   ASP A  67      39.297  38.482  11.213  1.00 28.74           C  
ATOM    574  O   ASP A  67      40.422  38.824  10.850  1.00 28.85           O  
ATOM    575  CB  ASP A  67      37.221  39.595  10.429  1.00 29.29           C  
ATOM    576  CG  ASP A  67      36.842  40.292   9.127  1.00 29.64           C  
ATOM    577  OD1 ASP A  67      37.647  40.296   8.169  1.00 29.52           O  
ATOM    578  OD2 ASP A  67      35.730  40.870   9.077  1.00 30.42           O  
ATOM    579  N   SER A  68      39.001  38.136  12.459  1.00 28.02           N  
ATOM    580  CA  SER A  68      39.938  38.268  13.555  1.00 27.59           C  
ATOM    581  C   SER A  68      41.039  37.189  13.681  1.00 27.28           C  
ATOM    582  O   SER A  68      41.725  37.149  14.716  1.00 27.55           O  
ATOM    583  CB  SER A  68      39.145  38.377  14.848  1.00 27.27           C  
ATOM    584  OG  SER A  68      38.090  39.293  14.654  1.00 27.41           O  
ATOM    585  N   LEU A  69      41.220  36.337  12.661  1.00 26.66           N  
ATOM    586  CA  LEU A  69      42.280  35.307  12.705  1.00 25.46           C  
ATOM    587  C   LEU A  69      43.618  35.766  12.148  1.00 25.37           C  
ATOM    588  O   LEU A  69      43.700  36.341  11.050  1.00 25.72           O  
ATOM    589  CB  LEU A  69      41.864  34.031  11.981  1.00 25.70           C  
ATOM    590  CG  LEU A  69      41.110  32.913  12.682  1.00 23.58           C  
ATOM    591  CD1 LEU A  69      41.339  31.643  11.845  1.00 22.28           C  
ATOM    592  CD2 LEU A  69      41.555  32.708  14.118  1.00 23.71           C  
ATOM    593  N   GLU A  70      44.692  35.456  12.868  1.00 24.43           N  
ATOM    594  CA  GLU A  70      45.947  36.153  12.615  1.00 24.34           C  
ATOM    595  C   GLU A  70      47.001  35.391  11.776  1.00 23.43           C  
ATOM    596  O   GLU A  70      48.168  35.826  11.634  1.00 23.22           O  
ATOM    597  CB  GLU A  70      46.457  36.778  13.930  1.00 24.36           C  
ATOM    598  CG  GLU A  70      45.422  37.794  14.490  1.00 25.75           C  
ATOM    599  CD  GLU A  70      45.796  38.409  15.824  1.00 26.73           C  
ATOM    600  OE1 GLU A  70      45.595  39.638  15.977  1.00 31.19           O  
ATOM    601  OE2 GLU A  70      46.267  37.680  16.734  1.00 30.47           O  
ATOM    602  N   TYR A  71      46.541  34.320  11.134  1.00 20.70           N  
ATOM    603  CA  TYR A  71      47.369  33.470  10.328  1.00 19.55           C  
ATOM    604  C   TYR A  71      47.799  34.158   9.058  1.00 20.28           C  
ATOM    605  O   TYR A  71      47.140  35.107   8.599  1.00 19.11           O  
ATOM    606  CB  TYR A  71      46.545  32.238   9.915  1.00 18.90           C  
ATOM    607  CG  TYR A  71      46.232  31.276  11.039  1.00 17.23           C  
ATOM    608  CD1 TYR A  71      47.208  30.906  11.971  1.00 17.97           C  
ATOM    609  CD2 TYR A  71      44.961  30.697  11.156  1.00 16.69           C  
ATOM    610  CE1 TYR A  71      46.910  29.997  13.006  1.00 15.70           C  
ATOM    611  CE2 TYR A  71      44.664  29.805  12.190  1.00 14.31           C  
ATOM    612  CZ  TYR A  71      45.652  29.466  13.101  1.00 15.33           C  
ATOM    613  OH  TYR A  71      45.367  28.551  14.080  1.00 16.02           O  
ATOM    614  N   GLU A  72      48.877  33.648   8.462  1.00 21.61           N  
ATOM    615  CA  GLU A  72      49.293  34.076   7.126  1.00 23.18           C  
ATOM    616  C   GLU A  72      48.070  34.041   6.203  1.00 21.67           C  
ATOM    617  O   GLU A  72      47.273  33.078   6.274  1.00 21.49           O  
ATOM    618  CB  GLU A  72      50.311  33.093   6.553  1.00 23.33           C  
ATOM    619  CG  GLU A  72      51.772  33.284   7.007  1.00 26.49           C  
ATOM    620  CD  GLU A  72      52.668  32.256   6.317  1.00 27.23           C  
ATOM    621  OE1 GLU A  72      52.769  32.294   5.055  1.00 29.99           O  
ATOM    622  OE2 GLU A  72      53.241  31.391   7.034  1.00 33.84           O  
ATOM    623  N   SER A  73      47.933  35.044   5.336  1.00 20.03           N  
ATOM    624  CA  SER A  73      46.980  34.960   4.235  1.00 18.69           C  
ATOM    625  C   SER A  73      47.738  34.750   2.913  1.00 19.41           C  
ATOM    626  O   SER A  73      48.701  35.471   2.643  1.00 20.46           O  
ATOM    627  CB  SER A  73      46.083  36.201   4.129  1.00 19.12           C  
ATOM    628  OG  SER A  73      45.168  36.273   5.215  1.00 20.07           O  
ATOM    629  N   ILE A  74      47.307  33.783   2.106  1.00 17.14           N  
ATOM    630  CA  ILE A  74      47.887  33.541   0.792  1.00 17.84           C  
ATOM    631  C   ILE A  74      46.758  33.139  -0.148  1.00 17.30           C  
ATOM    632  O   ILE A  74      45.724  32.613   0.300  1.00 18.57           O  
ATOM    633  CB  ILE A  74      48.952  32.447   0.821  1.00 16.83           C  
ATOM    634  CG1 ILE A  74      48.368  31.111   1.324  1.00 17.17           C  
ATOM    635  CG2 ILE A  74      50.132  32.897   1.692  1.00 19.04           C  
ATOM    636  CD1 ILE A  74      49.413  29.958   1.379  1.00 20.55           C  
ATOM    637  N   SER A  75      46.934  33.379  -1.439  1.00 17.20           N  
ATOM    638  CA  SER A  75      45.924  33.009  -2.428  1.00 17.57           C  
ATOM    639  C   SER A  75      45.874  31.479  -2.574  1.00 17.86           C  
ATOM    640  O   SER A  75      46.803  30.762  -2.166  1.00 17.96           O  
ATOM    641  CB  SER A  75      46.274  33.591  -3.796  1.00 18.20           C  
ATOM    642  OG  SER A  75      47.477  33.005  -4.272  1.00 16.56           O  
ATOM    643  N   ALA A  76      44.808  31.021  -3.206  1.00 17.23           N  
ATOM    644  CA  ALA A  76      44.608  29.600  -3.445  1.00 17.89           C  
ATOM    645  C   ALA A  76      45.810  29.021  -4.208  1.00 17.49           C  
ATOM    646  O   ALA A  76      46.330  27.984  -3.794  1.00 17.21           O  
ATOM    647  CB  ALA A  76      43.312  29.381  -4.187  1.00 15.96           C  
ATOM    648  N   SER A  77      46.304  29.734  -5.250  1.00 17.43           N  
ATOM    649  CA  SER A  77      47.432  29.217  -6.063  1.00 17.32           C  
ATOM    650  C   SER A  77      48.707  29.082  -5.231  1.00 17.26           C  
ATOM    651  O   SER A  77      49.446  28.073  -5.334  1.00 15.78           O  
ATOM    652  CB  SER A  77      47.696  30.104  -7.297  1.00 17.66           C  
ATOM    653  OG  SER A  77      46.583  30.025  -8.200  1.00 20.03           O  
ATOM    654  N   GLU A  78      48.993  30.099  -4.419  1.00 16.35           N  
ATOM    655  CA  GLU A  78      50.107  30.017  -3.458  0.50 16.38           C  
ATOM    657  C   GLU A  78      49.955  28.816  -2.514  1.00 15.62           C  
ATOM    658  O   GLU A  78      50.912  28.062  -2.251  1.00 16.02           O  
ATOM    659  CB  GLU A  78      50.154  31.297  -2.623  0.50 16.23           C  
ATOM    661  CG  GLU A  78      50.746  32.474  -3.360  0.50 16.72           C  
ATOM    663  CD  GLU A  78      50.526  33.793  -2.644  0.50 18.04           C  
ATOM    665  OE1 GLU A  78      51.219  34.032  -1.631  0.50 19.59           O  
ATOM    667  OE2 GLU A  78      49.670  34.583  -3.107  0.50 16.75           O  
ATOM    669  N   ALA A  79      48.754  28.648  -1.975  1.00 16.32           N  
ATOM    670  CA  ALA A  79      48.513  27.540  -1.022  1.00 16.34           C  
ATOM    671  C   ALA A  79      48.812  26.200  -1.690  1.00 16.62           C  
ATOM    672  O   ALA A  79      49.356  25.293  -1.060  1.00 17.43           O  
ATOM    673  CB  ALA A  79      47.063  27.555  -0.566  1.00 17.07           C  
ATOM    674  N   LEU A  80      48.449  26.084  -2.971  1.00 16.13           N  
ATOM    675  CA  LEU A  80      48.621  24.798  -3.679  1.00 14.95           C  
ATOM    676  C   LEU A  80      50.109  24.433  -3.795  1.00 15.44           C  
ATOM    677  O   LEU A  80      50.456  23.268  -3.897  1.00 13.37           O  
ATOM    678  CB  LEU A  80      47.954  24.799  -5.050  1.00 14.55           C  
ATOM    679  CG  LEU A  80      46.410  24.845  -5.091  1.00 12.79           C  
ATOM    680  CD1 LEU A  80      45.902  24.837  -6.537  1.00 13.79           C  
ATOM    681  CD2 LEU A  80      45.789  23.677  -4.343  1.00 12.79           C  
ATOM    682  N   ALA A  81      50.969  25.453  -3.755  1.00 17.01           N  
ATOM    683  CA  ALA A  81      52.416  25.240  -3.840  1.00 18.82           C  
ATOM    684  C   ALA A  81      53.091  24.920  -2.497  1.00 19.83           C  
ATOM    685  O   ALA A  81      54.286  24.560  -2.471  1.00 20.25           O  
ATOM    686  CB  ALA A  81      53.079  26.452  -4.476  1.00 19.06           C  
ATOM    687  N   ARG A  82      52.372  25.051  -1.389  1.00 19.62           N  
ATOM    688  CA  ARG A  82      52.943  24.699  -0.076  1.00 20.60           C  
ATOM    689  C   ARG A  82      52.980  23.181   0.099  1.00 20.70           C  
ATOM    690  O   ARG A  82      52.381  22.450  -0.680  1.00 21.38           O  
ATOM    691  CB  ARG A  82      52.137  25.339   1.070  1.00 20.33           C  
ATOM    692  CG  ARG A  82      51.988  26.880   1.005  1.00 24.31           C  
ATOM    693  CD  ARG A  82      53.249  27.584   1.530  1.00 24.19           C  
ATOM    694  NE  ARG A  82      53.270  29.031   1.244  1.00 29.25           N  
ATOM    695  CZ  ARG A  82      53.181  29.989   2.177  1.00 29.59           C  
ATOM    696  NH1 ARG A  82      53.059  29.683   3.472  1.00 27.14           N  
ATOM    697  NH2 ARG A  82      53.214  31.267   1.820  1.00 28.71           N  
ATOM    698  N   ASP A  83      53.680  22.671   1.095  1.00 20.87           N  
ATOM    699  CA  ASP A  83      53.717  21.225   1.233  0.50 21.56           C  
ATOM    701  C   ASP A  83      52.541  20.655   2.016  1.00 20.75           C  
ATOM    702  O   ASP A  83      52.305  20.956   3.198  1.00 21.28           O  
ATOM    703  CB  ASP A  83      55.031  20.706   1.801  0.50 22.90           C  
ATOM    705  CG  ASP A  83      55.046  19.192   1.907  0.50 24.64           C  
ATOM    707  OD1 ASP A  83      54.737  18.496   0.903  0.50 29.23           O  
ATOM    709  OD2 ASP A  83      55.355  18.699   3.009  0.50 29.91           O  
ATOM    711  N   PHE A  84      51.776  19.819   1.322  1.00 20.09           N  
ATOM    712  CA  PHE A  84      50.629  19.123   1.942  1.00 17.81           C  
ATOM    713  C   PHE A  84      50.251  17.961   1.005  1.00 17.33           C  
ATOM    714  O   PHE A  84      50.904  17.775  -0.036  1.00 17.17           O  
ATOM    715  CB  PHE A  84      49.477  20.093   2.262  1.00 16.76           C  
ATOM    716  CG  PHE A  84      48.777  20.605   1.044  1.00 16.48           C  
ATOM    717  CD1 PHE A  84      47.563  20.048   0.661  1.00 15.29           C  
ATOM    718  CD2 PHE A  84      49.343  21.609   0.258  1.00 15.81           C  
ATOM    719  CE1 PHE A  84      46.891  20.481  -0.497  1.00 15.31           C  
ATOM    720  CE2 PHE A  84      48.710  22.052  -0.896  1.00 15.72           C  
ATOM    721  CZ  PHE A  84      47.461  21.449  -1.297  1.00 15.70           C  
ATOM    722  N   ASP A  85      49.241  17.173   1.376  1.00 16.80           N  
ATOM    723  CA  ASP A  85      48.925  15.933   0.655  1.00 15.99           C  
ATOM    724  C   ASP A  85      47.682  16.031  -0.235  1.00 15.07           C  
ATOM    725  O   ASP A  85      47.721  15.623  -1.401  1.00 14.96           O  
ATOM    726  CB  ASP A  85      48.806  14.790   1.678  1.00 16.26           C  
ATOM    727  CG  ASP A  85      50.115  14.623   2.491  1.00 20.29           C  
ATOM    728  OD1 ASP A  85      51.168  14.503   1.825  1.00 25.92           O  
ATOM    729  OD2 ASP A  85      50.113  14.703   3.731  1.00 18.92           O  
ATOM    730  N   ILE A  86      46.590  16.559   0.320  1.00 13.93           N  
ATOM    731  CA  ILE A  86      45.268  16.497  -0.330  1.00 14.05           C  
ATOM    732  C   ILE A  86      44.523  17.824  -0.207  1.00 12.62           C  
ATOM    733  O   ILE A  86      44.425  18.430   0.897  1.00 14.53           O  
ATOM    734  CB  ILE A  86      44.378  15.360   0.263  1.00 13.47           C  
ATOM    735  CG1 ILE A  86      45.138  14.020   0.272  1.00 14.70           C  
ATOM    736  CG2 ILE A  86      42.985  15.232  -0.501  1.00 13.69           C  
ATOM    737  CD1 ILE A  86      44.501  12.930   1.151  1.00 16.41           C  
ATOM    738  N   VAL A  87      43.956  18.244  -1.328  1.00 13.32           N  
ATOM    739  CA  VAL A  87      43.004  19.372  -1.415  1.00 12.60           C  
ATOM    740  C   VAL A  87      41.589  18.840  -1.199  1.00 13.71           C  
ATOM    741  O   VAL A  87      41.179  17.829  -1.811  1.00 13.52           O  
ATOM    742  CB  VAL A  87      43.087  20.027  -2.835  1.00 13.72           C  
ATOM    743  CG1 VAL A  87      41.869  20.939  -3.128  1.00 14.38           C  
ATOM    744  CG2 VAL A  87      44.421  20.857  -2.992  1.00 13.18           C  
ATOM    745  N   VAL A  88      40.824  19.515  -0.341  1.00 13.17           N  
ATOM    746  CA  VAL A  88      39.379  19.262  -0.267  1.00 13.29           C  
ATOM    747  C   VAL A  88      38.664  20.447  -0.917  1.00 14.24           C  
ATOM    748  O   VAL A  88      38.840  21.591  -0.504  1.00 12.85           O  
ATOM    749  CB  VAL A  88      38.924  19.140   1.195  1.00 13.28           C  
ATOM    750  CG1 VAL A  88      37.360  19.045   1.278  1.00 13.12           C  
ATOM    751  CG2 VAL A  88      39.648  17.927   1.826  1.00 15.43           C  
ATOM    752  N   ASP A  89      37.858  20.154  -1.926  1.00 13.59           N  
ATOM    753  CA  ASP A  89      37.055  21.173  -2.609  1.00 14.17           C  
ATOM    754  C   ASP A  89      35.613  21.094  -2.086  1.00 14.01           C  
ATOM    755  O   ASP A  89      34.814  20.258  -2.538  1.00 13.10           O  
ATOM    756  CB  ASP A  89      37.070  20.985  -4.137  1.00 14.37           C  
ATOM    757  CG  ASP A  89      36.257  22.089  -4.875  1.00 18.03           C  
ATOM    758  OD1 ASP A  89      35.684  22.975  -4.176  1.00 17.91           O  
ATOM    759  OD2 ASP A  89      36.179  22.058  -6.142  1.00 19.25           O  
ATOM    760  N   ALA A  90      35.280  21.997  -1.162  1.00 13.55           N  
ATOM    761  CA  ALA A  90      33.906  22.140  -0.665  1.00 13.55           C  
ATOM    762  C   ALA A  90      33.420  23.560  -0.970  1.00 14.91           C  
ATOM    763  O   ALA A  90      32.652  24.137  -0.205  1.00 15.04           O  
ATOM    764  CB  ALA A  90      33.850  21.860   0.852  1.00 14.16           C  
ATOM    765  N   THR A  91      33.861  24.106  -2.106  1.00 15.17           N  
ATOM    766  CA  THR A  91      33.475  25.459  -2.546  1.00 16.13           C  
ATOM    767  C   THR A  91      32.129  25.441  -3.277  1.00 16.97           C  
ATOM    768  O   THR A  91      31.646  24.369  -3.702  1.00 16.81           O  
ATOM    769  CB  THR A  91      34.496  26.044  -3.508  1.00 16.58           C  
ATOM    770  OG1 THR A  91      34.506  25.242  -4.704  1.00 16.20           O  
ATOM    771  CG2 THR A  91      35.923  25.997  -2.847  1.00 14.18           C  
ATOM    772  N   PRO A  92      31.503  26.622  -3.427  1.00 17.96           N  
ATOM    773  CA  PRO A  92      30.289  26.709  -4.266  1.00 18.06           C  
ATOM    774  C   PRO A  92      30.552  26.302  -5.720  1.00 19.24           C  
ATOM    775  O   PRO A  92      31.581  26.623  -6.305  1.00 18.13           O  
ATOM    776  CB  PRO A  92      29.870  28.196  -4.171  1.00 18.63           C  
ATOM    777  CG  PRO A  92      30.585  28.698  -2.912  1.00 18.63           C  
ATOM    778  CD  PRO A  92      31.868  27.921  -2.826  1.00 18.01           C  
ATOM    779  N   ALA A  93      29.593  25.603  -6.288  1.00 19.86           N  
ATOM    780  CA  ALA A  93      29.720  25.078  -7.623  1.00 21.04           C  
ATOM    781  C   ALA A  93      29.484  26.207  -8.635  1.00 22.00           C  
ATOM    782  O   ALA A  93      28.497  26.974  -8.517  1.00 23.13           O  
ATOM    783  CB  ALA A  93      28.708  24.007  -7.790  1.00 20.96           C  
ATOM    784  N   SER A  94      30.393  26.345  -9.596  1.00 20.88           N  
ATOM    785  CA  SER A  94      30.186  27.286 -10.718  1.00 20.93           C  
ATOM    786  C   SER A  94      29.147  26.737 -11.702  1.00 21.33           C  
ATOM    787  O   SER A  94      28.828  25.544 -11.701  1.00 20.54           O  
ATOM    788  CB  SER A  94      31.499  27.514 -11.467  1.00 21.00           C  
ATOM    789  OG  SER A  94      31.820  26.350 -12.224  1.00 20.97           O  
ATOM    790  N   ALA A  95      28.635  27.599 -12.572  1.00 21.42           N  
ATOM    791  CA  ALA A  95      27.651  27.161 -13.552  1.00 21.97           C  
ATOM    792  C   ALA A  95      28.279  26.245 -14.604  1.00 21.69           C  
ATOM    793  O   ALA A  95      27.681  25.248 -15.003  1.00 23.37           O  
ATOM    794  CB  ALA A  95      27.007  28.386 -14.211  1.00 23.16           C  
ATOM    795  N   ASP A  96      29.512  26.538 -15.001  1.00 20.49           N  
ATOM    796  CA  ASP A  96      30.105  25.901 -16.180  1.00 19.25           C  
ATOM    797  C   ASP A  96      31.263  24.944 -15.902  1.00 17.50           C  
ATOM    798  O   ASP A  96      31.687  24.246 -16.802  1.00 16.87           O  
ATOM    799  CB  ASP A  96      30.522  26.954 -17.211  1.00 20.02           C  
ATOM    800  CG  ASP A  96      31.575  27.932 -16.686  1.00 24.43           C  
ATOM    801  OD1 ASP A  96      32.180  27.697 -15.610  1.00 23.35           O  
ATOM    802  OD2 ASP A  96      31.810  28.976 -17.361  1.00 29.13           O  
ATOM    803  N   GLY A  97      31.725  24.878 -14.660  1.00 15.40           N  
ATOM    804  CA  GLY A  97      32.752  23.926 -14.285  1.00 15.04           C  
ATOM    805  C   GLY A  97      34.176  24.358 -14.599  1.00 14.95           C  
ATOM    806  O   GLY A  97      35.099  23.631 -14.270  1.00 13.98           O  
ATOM    807  N   LYS A  98      34.377  25.523 -15.242  1.00 15.07           N  
ATOM    808  CA  LYS A  98      35.737  25.947 -15.623  1.00 14.73           C  
ATOM    809  C   LYS A  98      36.655  26.244 -14.424  1.00 14.49           C  
ATOM    810  O   LYS A  98      37.841  25.887 -14.434  1.00 14.58           O  
ATOM    811  CB  LYS A  98      35.682  27.176 -16.552  1.00 14.59           C  
ATOM    812  CG  LYS A  98      34.998  26.886 -17.883  1.00 15.37           C  
ATOM    813  CD  LYS A  98      35.042  28.116 -18.802  1.00 16.88           C  
ATOM    814  CE  LYS A  98      34.371  27.791 -20.124  1.00 23.93           C  
ATOM    815  NZ  LYS A  98      34.919  28.708 -21.188  1.00 29.61           N  
ATOM    816  N   LYS A  99      36.134  26.933 -13.417  1.00 15.67           N  
ATOM    817  CA  LYS A  99      36.956  27.255 -12.249  1.00 16.24           C  
ATOM    818  C   LYS A  99      37.414  25.978 -11.529  1.00 16.06           C  
ATOM    819  O   LYS A  99      38.565  25.879 -11.088  1.00 15.02           O  
ATOM    820  CB  LYS A  99      36.273  28.277 -11.315  1.00 18.77           C  
ATOM    821  CG  LYS A  99      35.186  27.738 -10.430  1.00 24.72           C  
ATOM    822  CD  LYS A  99      35.343  28.267  -9.005  1.00 29.65           C  
ATOM    823  CE  LYS A  99      34.204  27.741  -8.073  1.00 32.26           C  
ATOM    824  NZ  LYS A  99      34.597  26.589  -7.148  1.00 29.82           N  
ATOM    825  N   GLU A 100      36.535  24.970 -11.491  1.00 14.72           N  
ATOM    826  CA  GLU A 100      36.876  23.673 -10.868  1.00 14.47           C  
ATOM    827  C   GLU A 100      37.936  22.949 -11.686  1.00 14.60           C  
ATOM    828  O   GLU A 100      38.930  22.450 -11.151  1.00 14.41           O  
ATOM    829  CB  GLU A 100      35.606  22.825 -10.746  1.00 14.37           C  
ATOM    830  CG  GLU A 100      34.639  23.319  -9.683  1.00 14.55           C  
ATOM    831  CD  GLU A 100      33.685  24.441 -10.135  1.00 17.53           C  
ATOM    832  OE1 GLU A 100      33.683  24.862 -11.321  1.00 16.87           O  
ATOM    833  OE2 GLU A 100      32.918  24.912  -9.251  1.00 18.68           O  
ATOM    834  N   LEU A 101      37.742  22.916 -13.004  1.00 14.92           N  
ATOM    835  CA  LEU A 101      38.759  22.321 -13.894  1.00 14.42           C  
ATOM    836  C   LEU A 101      40.139  22.970 -13.681  1.00 14.75           C  
ATOM    837  O   LEU A 101      41.146  22.261 -13.462  1.00 15.19           O  
ATOM    838  CB  LEU A 101      38.324  22.425 -15.390  1.00 13.88           C  
ATOM    839  CG  LEU A 101      39.351  21.911 -16.401  1.00 12.79           C  
ATOM    840  CD1 LEU A 101      39.610  20.393 -16.194  1.00 13.09           C  
ATOM    841  CD2 LEU A 101      38.912  22.231 -17.817  1.00 14.89           C  
ATOM    842  N   ALA A 102      40.194  24.301 -13.724  1.00 14.34           N  
ATOM    843  CA  ALA A 102      41.460  25.004 -13.581  1.00 15.22           C  
ATOM    844  C   ALA A 102      42.082  24.720 -12.206  1.00 15.10           C  
ATOM    845  O   ALA A 102      43.310  24.522 -12.087  1.00 15.83           O  
ATOM    846  CB  ALA A 102      41.268  26.494 -13.801  1.00 15.53           C  
ATOM    847  N   PHE A 103      41.232  24.648 -11.186  1.00 13.28           N  
ATOM    848  CA  PHE A 103      41.702  24.368  -9.819  1.00 13.63           C  
ATOM    849  C   PHE A 103      42.312  22.969  -9.656  1.00 14.09           C  
ATOM    850  O   PHE A 103      43.372  22.805  -9.013  1.00 13.43           O  
ATOM    851  CB  PHE A 103      40.541  24.586  -8.855  1.00 15.06           C  
ATOM    852  CG  PHE A 103      40.905  24.455  -7.391  1.00 16.05           C  
ATOM    853  CD1 PHE A 103      41.926  25.229  -6.819  1.00 17.01           C  
ATOM    854  CD2 PHE A 103      40.159  23.621  -6.574  1.00 16.71           C  
ATOM    855  CE1 PHE A 103      42.224  25.128  -5.427  1.00 20.34           C  
ATOM    856  CE2 PHE A 103      40.433  23.529  -5.190  1.00 20.17           C  
ATOM    857  CZ  PHE A 103      41.486  24.276  -4.633  1.00 18.53           C  
ATOM    858  N   TYR A 104      41.653  21.961 -10.231  1.00 13.41           N  
ATOM    859  CA  TYR A 104      42.173  20.600 -10.125  1.00 14.51           C  
ATOM    860  C   TYR A 104      43.464  20.485 -10.949  1.00 15.01           C  
ATOM    861  O   TYR A 104      44.418  19.868 -10.496  1.00 15.93           O  
ATOM    862  CB  TYR A 104      41.130  19.550 -10.528  1.00 13.60           C  
ATOM    863  CG  TYR A 104      39.791  19.673  -9.779  1.00 15.41           C  
ATOM    864  CD1 TYR A 104      39.708  20.269  -8.516  1.00 12.92           C  
ATOM    865  CD2 TYR A 104      38.617  19.186 -10.354  1.00 16.86           C  
ATOM    866  CE1 TYR A 104      38.486  20.409  -7.852  1.00 15.73           C  
ATOM    867  CE2 TYR A 104      37.371  19.313  -9.699  1.00 16.96           C  
ATOM    868  CZ  TYR A 104      37.322  19.903  -8.446  1.00 16.36           C  
ATOM    869  OH  TYR A 104      36.099  20.058  -7.852  1.00 17.49           O  
ATOM    870  N   LYS A 105      43.509  21.118 -12.125  1.00 14.81           N  
ATOM    871  CA  LYS A 105      44.738  21.074 -12.919  1.00 16.04           C  
ATOM    872  C   LYS A 105      45.910  21.598 -12.076  1.00 15.12           C  
ATOM    873  O   LYS A 105      46.965  20.974 -11.981  1.00 14.80           O  
ATOM    874  CB  LYS A 105      44.579  21.923 -14.180  1.00 16.84           C  
ATOM    875  CG  LYS A 105      45.808  21.949 -15.103  1.00 16.70           C  
ATOM    876  CD  LYS A 105      45.585  22.987 -16.216  1.00 16.42           C  
ATOM    877  CE  LYS A 105      46.799  23.034 -17.224  1.00 16.88           C  
ATOM    878  NZ  LYS A 105      47.997  23.747 -16.648  1.00 20.08           N  
ATOM    879  N   GLU A 106      45.706  22.742 -11.434  1.00 15.27           N  
ATOM    880  CA  GLU A 106      46.790  23.360 -10.689  1.00 15.24           C  
ATOM    881  C   GLU A 106      47.143  22.503  -9.469  1.00 14.71           C  
ATOM    882  O   GLU A 106      48.317  22.424  -9.073  1.00 14.96           O  
ATOM    883  CB  GLU A 106      46.385  24.761 -10.234  1.00 16.55           C  
ATOM    884  CG  GLU A 106      47.579  25.601  -9.892  1.00 21.64           C  
ATOM    885  CD  GLU A 106      47.227  27.028  -9.486  1.00 27.29           C  
ATOM    886  OE1 GLU A 106      46.040  27.380  -9.382  1.00 32.92           O  
ATOM    887  OE2 GLU A 106      48.180  27.785  -9.311  1.00 32.70           O  
ATOM    888  N   THR A 107      46.134  21.879  -8.871  1.00 14.35           N  
ATOM    889  CA  THR A 107      46.359  20.969  -7.747  1.00 14.66           C  
ATOM    890  C   THR A 107      47.241  19.761  -8.148  1.00 15.01           C  
ATOM    891  O   THR A 107      48.262  19.442  -7.468  1.00 14.48           O  
ATOM    892  CB  THR A 107      44.998  20.469  -7.121  1.00 14.96           C  
ATOM    893  OG1 THR A 107      44.239  21.583  -6.617  1.00 14.96           O  
ATOM    894  CG2 THR A 107      45.275  19.463  -5.966  1.00 13.24           C  
ATOM    895  N   PHE A 108      46.850  19.075  -9.222  1.00 15.41           N  
ATOM    896  CA  PHE A 108      47.582  17.883  -9.661  1.00 15.83           C  
ATOM    897  C   PHE A 108      49.013  18.274 -10.057  1.00 16.74           C  
ATOM    898  O   PHE A 108      49.968  17.546  -9.780  1.00 17.27           O  
ATOM    899  CB  PHE A 108      46.887  17.240 -10.879  1.00 15.10           C  
ATOM    900  CG  PHE A 108      45.476  16.754 -10.599  1.00 15.39           C  
ATOM    901  CD1 PHE A 108      45.151  16.195  -9.360  1.00 14.68           C  
ATOM    902  CD2 PHE A 108      44.496  16.812 -11.595  1.00 13.15           C  
ATOM    903  CE1 PHE A 108      43.815  15.739  -9.079  1.00 14.06           C  
ATOM    904  CE2 PHE A 108      43.189  16.344 -11.358  1.00 14.34           C  
ATOM    905  CZ  PHE A 108      42.843  15.793 -10.087  1.00 11.87           C  
ATOM    906  N   GLU A 109      49.150  19.387 -10.757  1.00 16.71           N  
ATOM    907  CA  GLU A 109      50.473  19.843 -11.185  1.00 18.31           C  
ATOM    908  C   GLU A 109      51.395  20.145 -10.019  1.00 18.90           C  
ATOM    909  O   GLU A 109      52.631  20.007 -10.142  1.00 19.37           O  
ATOM    910  CB  GLU A 109      50.344  21.075 -12.059  1.00 18.42           C  
ATOM    911  CG  GLU A 109      49.883  20.750 -13.440  1.00 21.18           C  
ATOM    912  CD  GLU A 109      49.557  22.011 -14.244  1.00 26.46           C  
ATOM    913  OE1 GLU A 109      49.580  23.139 -13.674  1.00 28.22           O  
ATOM    914  OE2 GLU A 109      49.258  21.850 -15.439  1.00 27.62           O  
ATOM    915  N   ASN A 110      50.812  20.543  -8.891  1.00 17.40           N  
ATOM    916  CA  ASN A 110      51.557  20.812  -7.661  1.00 18.17           C  
ATOM    917  C   ASN A 110      51.771  19.554  -6.818  1.00 18.26           C  
ATOM    918  O   ASN A 110      52.394  19.603  -5.747  1.00 17.87           O  
ATOM    919  CB  ASN A 110      50.853  21.896  -6.856  1.00 17.91           C  
ATOM    920  CG  ASN A 110      51.267  23.288  -7.296  1.00 21.69           C  
ATOM    921  OD1 ASN A 110      52.402  23.720  -7.028  1.00 22.47           O  
ATOM    922  ND2 ASN A 110      50.364  24.002  -7.953  1.00 20.36           N  
ATOM    923  N   GLY A 111      51.280  18.428  -7.334  1.00 17.45           N  
ATOM    924  CA  GLY A 111      51.560  17.118  -6.739  1.00 16.41           C  
ATOM    925  C   GLY A 111      50.646  16.748  -5.587  1.00 16.05           C  
ATOM    926  O   GLY A 111      51.046  15.989  -4.698  1.00 15.24           O  
ATOM    927  N   LYS A 112      49.400  17.257  -5.598  1.00 15.34           N  
ATOM    928  CA  LYS A 112      48.442  16.901  -4.557  1.00 14.07           C  
ATOM    929  C   LYS A 112      47.247  16.169  -5.145  1.00 14.05           C  
ATOM    930  O   LYS A 112      46.948  16.330  -6.329  1.00 13.97           O  
ATOM    931  CB  LYS A 112      48.000  18.122  -3.720  1.00 14.91           C  
ATOM    932  CG  LYS A 112      49.123  18.644  -2.767  1.00 13.10           C  
ATOM    933  CD  LYS A 112      50.013  19.690  -3.435  1.00 13.64           C  
ATOM    934  CE  LYS A 112      51.204  20.057  -2.535  1.00 14.46           C  
ATOM    935  NZ  LYS A 112      52.070  21.071  -3.222  1.00 15.62           N  
ATOM    936  N   ASP A 113      46.617  15.316  -4.336  1.00 13.74           N  
ATOM    937  CA  ASP A 113      45.316  14.695  -4.728  1.00 14.05           C  
ATOM    938  C   ASP A 113      44.131  15.618  -4.412  1.00 13.47           C  
ATOM    939  O   ASP A 113      44.292  16.638  -3.715  1.00 13.88           O  
ATOM    940  CB  ASP A 113      45.135  13.381  -4.015  1.00 14.44           C  
ATOM    941  CG  ASP A 113      46.274  12.411  -4.309  1.00 19.18           C  
ATOM    942  OD1 ASP A 113      46.727  12.301  -5.468  1.00 18.49           O  
ATOM    943  OD2 ASP A 113      46.695  11.746  -3.369  1.00 24.27           O  
ATOM    944  N   VAL A 114      42.955  15.282  -4.948  1.00 12.63           N  
ATOM    945  CA  VAL A 114      41.732  16.072  -4.700  1.00 13.10           C  
ATOM    946  C   VAL A 114      40.652  15.180  -4.123  1.00 12.22           C  
ATOM    947  O   VAL A 114      40.453  14.059  -4.607  1.00 13.83           O  
ATOM    948  CB  VAL A 114      41.165  16.705  -6.021  1.00 12.27           C  
ATOM    949  CG1 VAL A 114      39.762  17.318  -5.769  1.00 12.09           C  
ATOM    950  CG2 VAL A 114      42.128  17.782  -6.535  1.00 14.18           C  
ATOM    951  N   VAL A 115      39.914  15.683  -3.122  1.00 11.99           N  
ATOM    952  CA  VAL A 115      38.647  15.109  -2.692  1.00 11.51           C  
ATOM    953  C   VAL A 115      37.666  16.233  -2.857  1.00 11.68           C  
ATOM    954  O   VAL A 115      37.874  17.316  -2.299  1.00 13.68           O  
ATOM    955  CB  VAL A 115      38.660  14.652  -1.202  1.00 10.91           C  
ATOM    956  CG1 VAL A 115      37.236  14.282  -0.777  1.00 14.18           C  
ATOM    957  CG2 VAL A 115      39.602  13.403  -1.071  1.00 11.57           C  
ATOM    958  N   THR A 116      36.622  16.017  -3.643  1.00 12.61           N  
ATOM    959  CA  THR A 116      35.645  17.064  -3.880  1.00 12.08           C  
ATOM    960  C   THR A 116      34.233  16.721  -3.485  1.00 13.64           C  
ATOM    961  O   THR A 116      33.756  15.571  -3.661  1.00 12.62           O  
ATOM    962  CB  THR A 116      35.699  17.542  -5.349  1.00 13.35           C  
ATOM    963  OG1 THR A 116      34.781  18.639  -5.549  1.00 13.31           O  
ATOM    964  CG2 THR A 116      35.340  16.400  -6.358  1.00 10.55           C  
ATOM    965  N   ALA A 117      33.529  17.748  -2.997  1.00 13.10           N  
ATOM    966  CA  ALA A 117      32.092  17.688  -2.795  1.00 14.25           C  
ATOM    967  C   ALA A 117      31.353  18.552  -3.842  1.00 14.48           C  
ATOM    968  O   ALA A 117      30.143  18.584  -3.876  1.00 15.67           O  
ATOM    969  CB  ALA A 117      31.729  18.123  -1.328  1.00 13.94           C  
ATOM    970  N   ASN A 118      32.112  19.244  -4.686  1.00 13.67           N  
ATOM    971  CA  ASN A 118      31.593  20.134  -5.727  1.00 14.68           C  
ATOM    972  C   ASN A 118      31.513  19.336  -7.016  1.00 14.15           C  
ATOM    973  O   ASN A 118      32.524  18.739  -7.482  1.00 14.57           O  
ATOM    974  CB  ASN A 118      32.584  21.307  -5.810  1.00 14.92           C  
ATOM    975  CG  ASN A 118      32.284  22.273  -6.904  1.00 16.11           C  
ATOM    976  OD1 ASN A 118      31.729  21.914  -7.928  1.00 16.01           O  
ATOM    977  ND2 ASN A 118      32.732  23.524  -6.715  1.00 15.21           N  
ATOM    978  N   LYS A 119      30.320  19.275  -7.596  1.00 13.75           N  
ATOM    979  CA  LYS A 119      30.138  18.421  -8.781  1.00 16.06           C  
ATOM    980  C   LYS A 119      30.369  19.091 -10.157  1.00 16.19           C  
ATOM    981  O   LYS A 119      30.360  18.413 -11.180  1.00 13.74           O  
ATOM    982  CB  LYS A 119      28.752  17.729  -8.721  1.00 17.14           C  
ATOM    983  CG  LYS A 119      27.587  18.632  -8.729  1.00 19.40           C  
ATOM    984  CD  LYS A 119      26.296  17.796  -8.781  1.00 19.97           C  
ATOM    985  CE  LYS A 119      25.098  18.741  -8.698  1.00 19.82           C  
ATOM    986  NZ  LYS A 119      25.145  19.247  -7.276  1.00 19.27           N  
ATOM    987  N   SER A 120      30.585  20.416 -10.163  1.00 15.12           N  
ATOM    988  CA  SER A 120      30.593  21.194 -11.400  0.60 16.78           C  
ATOM    990  C   SER A 120      31.709  20.842 -12.375  1.00 15.75           C  
ATOM    991  O   SER A 120      31.464  20.706 -13.583  1.00 16.80           O  
ATOM    992  CB  SER A 120      30.651  22.701 -11.095  0.60 16.42           C  
ATOM    994  OG  SER A 120      29.378  23.208 -10.758  0.60 18.52           O  
ATOM    996  N   GLY A 121      32.931  20.736 -11.878  1.00 14.93           N  
ATOM    997  CA  GLY A 121      34.049  20.363 -12.743  1.00 14.20           C  
ATOM    998  C   GLY A 121      33.812  18.984 -13.350  1.00 14.48           C  
ATOM    999  O   GLY A 121      33.979  18.766 -14.552  1.00 13.79           O  
ATOM   1000  N   LEU A 122      33.402  18.047 -12.510  1.00 14.45           N  
ATOM   1001  CA  LEU A 122      33.199  16.669 -12.949  1.00 14.91           C  
ATOM   1002  C   LEU A 122      32.034  16.500 -13.922  1.00 15.47           C  
ATOM   1003  O   LEU A 122      32.094  15.666 -14.838  1.00 14.76           O  
ATOM   1004  CB  LEU A 122      33.032  15.741 -11.710  1.00 14.92           C  
ATOM   1005  CG  LEU A 122      34.318  15.612 -10.903  1.00 15.40           C  
ATOM   1006  CD1 LEU A 122      33.947  14.985  -9.545  1.00 17.88           C  
ATOM   1007  CD2 LEU A 122      35.397  14.801 -11.616  1.00 15.06           C  
ATOM   1008  N   ALA A 123      30.978  17.292 -13.756  1.00 15.48           N  
ATOM   1009  CA  ALA A 123      29.828  17.183 -14.648  1.00 16.23           C  
ATOM   1010  C   ALA A 123      30.068  17.797 -16.019  1.00 16.86           C  
ATOM   1011  O   ALA A 123      29.359  17.478 -16.970  1.00 17.07           O  
ATOM   1012  CB  ALA A 123      28.567  17.800 -13.991  1.00 15.92           C  
ATOM   1013  N   ASN A 124      31.071  18.669 -16.134  1.00 16.30           N  
ATOM   1014  CA  ASN A 124      31.315  19.398 -17.377  1.00 16.38           C  
ATOM   1015  C   ASN A 124      32.614  19.044 -18.067  1.00 16.44           C  
ATOM   1016  O   ASN A 124      32.689  19.118 -19.314  1.00 17.22           O  
ATOM   1017  CB  ASN A 124      31.330  20.917 -17.091  1.00 16.38           C  
ATOM   1018  CG  ASN A 124      29.959  21.447 -16.804  1.00 19.35           C  
ATOM   1019  OD1 ASN A 124      29.145  21.591 -17.722  1.00 19.86           O  
ATOM   1020  ND2 ASN A 124      29.667  21.698 -15.526  1.00 17.92           N  
ATOM   1021  N   PHE A 125      33.635  18.676 -17.271  1.00 15.28           N  
ATOM   1022  CA  PHE A 125      34.982  18.446 -17.789  1.00 15.22           C  
ATOM   1023  C   PHE A 125      35.614  17.159 -17.278  1.00 14.65           C  
ATOM   1024  O   PHE A 125      36.807  17.107 -17.016  1.00 14.83           O  
ATOM   1025  CB  PHE A 125      35.869  19.660 -17.442  1.00 14.78           C  
ATOM   1026  CG  PHE A 125      35.442  20.910 -18.140  1.00 15.90           C  
ATOM   1027  CD1 PHE A 125      35.586  21.037 -19.549  1.00 18.04           C  
ATOM   1028  CD2 PHE A 125      34.866  21.954 -17.417  1.00 13.88           C  
ATOM   1029  CE1 PHE A 125      35.155  22.209 -20.221  1.00 17.17           C  
ATOM   1030  CE2 PHE A 125      34.454  23.133 -18.050  1.00 15.04           C  
ATOM   1031  CZ  PHE A 125      34.581  23.268 -19.464  1.00 18.15           C  
ATOM   1032  N   TRP A 126      34.826  16.102 -17.164  1.00 13.85           N  
ATOM   1033  CA  TRP A 126      35.349  14.812 -16.648  1.00 14.21           C  
ATOM   1034  C   TRP A 126      36.618  14.318 -17.386  1.00 15.08           C  
ATOM   1035  O   TRP A 126      37.639  14.054 -16.756  1.00 15.06           O  
ATOM   1036  CB  TRP A 126      34.238  13.760 -16.739  1.00 13.41           C  
ATOM   1037  CG  TRP A 126      34.649  12.389 -16.301  1.00 14.25           C  
ATOM   1038  CD1 TRP A 126      35.405  11.490 -16.986  1.00 15.13           C  
ATOM   1039  CD2 TRP A 126      34.322  11.773 -15.044  1.00 15.51           C  
ATOM   1040  NE1 TRP A 126      35.556  10.344 -16.240  1.00 16.63           N  
ATOM   1041  CE2 TRP A 126      34.891  10.492 -15.050  1.00 15.14           C  
ATOM   1042  CE3 TRP A 126      33.561  12.175 -13.941  1.00 15.24           C  
ATOM   1043  CZ2 TRP A 126      34.749   9.600 -13.976  1.00 18.72           C  
ATOM   1044  CZ3 TRP A 126      33.408  11.274 -12.869  1.00 15.20           C  
ATOM   1045  CH2 TRP A 126      34.001  10.026 -12.895  1.00 14.71           C  
ATOM   1046  N   PRO A 127      36.589  14.232 -18.742  1.00 16.28           N  
ATOM   1047  CA  PRO A 127      37.774  13.636 -19.380  1.00 15.98           C  
ATOM   1048  C   PRO A 127      39.028  14.492 -19.201  1.00 16.55           C  
ATOM   1049  O   PRO A 127      40.141  13.941 -19.059  1.00 16.47           O  
ATOM   1050  CB  PRO A 127      37.369  13.524 -20.866  1.00 16.62           C  
ATOM   1051  CG  PRO A 127      36.218  14.481 -21.034  1.00 17.46           C  
ATOM   1052  CD  PRO A 127      35.526  14.568 -19.721  1.00 16.52           C  
ATOM   1053  N   GLU A 128      38.851  15.818 -19.176  1.00 16.37           N  
ATOM   1054  CA  GLU A 128      39.970  16.725 -18.963  1.00 16.45           C  
ATOM   1055  C   GLU A 128      40.534  16.575 -17.561  1.00 16.01           C  
ATOM   1056  O   GLU A 128      41.750  16.525 -17.388  1.00 16.41           O  
ATOM   1057  CB  GLU A 128      39.589  18.195 -19.231  1.00 16.66           C  
ATOM   1058  CG  GLU A 128      39.305  18.497 -20.698  1.00 17.30           C  
ATOM   1059  CD  GLU A 128      37.875  18.154 -21.133  1.00 21.81           C  
ATOM   1060  OE1 GLU A 128      37.008  17.840 -20.263  1.00 20.84           O  
ATOM   1061  OE2 GLU A 128      37.617  18.187 -22.375  1.00 22.41           O  
ATOM   1062  N   ILE A 129      39.655  16.501 -16.556  1.00 15.79           N  
ATOM   1063  CA  ILE A 129      40.096  16.292 -15.189  1.00 14.18           C  
ATOM   1064  C   ILE A 129      40.860  14.969 -15.087  1.00 15.36           C  
ATOM   1065  O   ILE A 129      41.976  14.908 -14.542  1.00 15.56           O  
ATOM   1066  CB  ILE A 129      38.876  16.321 -14.205  1.00 14.69           C  
ATOM   1067  CG1 ILE A 129      38.296  17.749 -14.115  1.00 14.32           C  
ATOM   1068  CG2 ILE A 129      39.268  15.773 -12.802  1.00 13.98           C  
ATOM   1069  CD1 ILE A 129      36.937  17.846 -13.291  1.00 14.65           C  
HETATM 1070  N   MSE A 130      40.279  13.887 -15.611  1.00 15.78           N  
HETATM 1071  CA  MSE A 130      40.951  12.581 -15.498  1.00 16.81           C  
HETATM 1072  C   MSE A 130      42.301  12.557 -16.231  1.00 17.88           C  
HETATM 1073  O   MSE A 130      43.233  11.902 -15.778  1.00 18.85           O  
HETATM 1074  CB  MSE A 130      40.020  11.450 -15.982  1.00 17.32           C  
HETATM 1075  CG  MSE A 130      38.746  11.258 -15.126  1.00 16.49           C  
HETATM 1076 SE   MSE A 130      39.054  11.356 -13.188  0.50 19.99          SE  
HETATM 1077  CE  MSE A 130      37.346  12.052 -12.595  1.00 20.96           C  
ATOM   1078  N   GLU A 131      42.409  13.257 -17.359  1.00 18.38           N  
ATOM   1079  CA  GLU A 131      43.681  13.332 -18.082  1.00 20.09           C  
ATOM   1080  C   GLU A 131      44.764  14.084 -17.297  1.00 19.59           C  
ATOM   1081  O   GLU A 131      45.914  13.614 -17.231  1.00 19.55           O  
ATOM   1082  CB  GLU A 131      43.497  13.912 -19.493  1.00 21.40           C  
ATOM   1083  CG  GLU A 131      44.815  14.092 -20.307  1.00 26.92           C  
ATOM   1084  CD  GLU A 131      45.651  12.786 -20.451  1.00 34.58           C  
ATOM   1085  OE1 GLU A 131      45.136  11.657 -20.182  1.00 37.75           O  
ATOM   1086  OE2 GLU A 131      46.834  12.911 -20.851  1.00 37.93           O  
ATOM   1087  N   TYR A 132      44.401  15.220 -16.680  1.00 18.02           N  
ATOM   1088  CA  TYR A 132      45.327  15.947 -15.789  1.00 17.31           C  
ATOM   1089  C   TYR A 132      45.746  15.091 -14.593  1.00 18.24           C  
ATOM   1090  O   TYR A 132      46.934  15.075 -14.248  1.00 19.33           O  
ATOM   1091  CB  TYR A 132      44.747  17.269 -15.288  1.00 18.21           C  
ATOM   1092  CG  TYR A 132      44.558  18.357 -16.324  1.00 18.14           C  
ATOM   1093  CD1 TYR A 132      45.619  18.756 -17.159  1.00 20.07           C  
ATOM   1094  CD2 TYR A 132      43.336  19.023 -16.445  1.00 18.67           C  
ATOM   1095  CE1 TYR A 132      45.444  19.778 -18.102  1.00 21.42           C  
ATOM   1096  CE2 TYR A 132      43.148  20.021 -17.375  1.00 18.65           C  
ATOM   1097  CZ  TYR A 132      44.202  20.392 -18.204  1.00 19.78           C  
ATOM   1098  OH  TYR A 132      44.008  21.409 -19.098  1.00 21.64           O  
ATOM   1099  N   ALA A 133      44.803  14.361 -13.986  1.00 17.70           N  
ATOM   1100  CA  ALA A 133      45.144  13.434 -12.910  1.00 19.18           C  
ATOM   1101  C   ALA A 133      46.154  12.376 -13.375  1.00 20.29           C  
ATOM   1102  O   ALA A 133      47.160  12.110 -12.685  1.00 21.56           O  
ATOM   1103  CB  ALA A 133      43.913  12.761 -12.362  1.00 18.28           C  
ATOM   1104  N   ARG A 134      45.870  11.778 -14.527  1.00 21.39           N  
ATOM   1105  CA  ARG A 134      46.701  10.711 -15.087  1.00 23.80           C  
ATOM   1106  C   ARG A 134      48.113  11.252 -15.404  1.00 22.73           C  
ATOM   1107  O   ARG A 134      49.117  10.642 -15.004  1.00 21.94           O  
ATOM   1108  CB  ARG A 134      46.049  10.137 -16.355  1.00 23.44           C  
ATOM   1109  CG  ARG A 134      46.766   8.875 -16.918  1.00 27.35           C  
ATOM   1110  CD  ARG A 134      46.546   8.697 -18.438  1.00 28.98           C  
ATOM   1111  NE  ARG A 134      47.118   9.830 -19.180  1.00 37.47           N  
ATOM   1112  CZ  ARG A 134      48.427  10.069 -19.316  1.00 39.70           C  
ATOM   1113  NH1 ARG A 134      49.324   9.230 -18.810  1.00 42.43           N  
ATOM   1114  NH2 ARG A 134      48.846  11.136 -19.981  1.00 40.19           N  
ATOM   1115  N   SER A 135      48.162  12.389 -16.101  1.00 22.76           N  
ATOM   1116  CA  SER A 135      49.400  13.075 -16.494  0.60 23.39           C  
ATOM   1118  C   SER A 135      50.305  13.297 -15.321  1.00 23.39           C  
ATOM   1119  O   SER A 135      51.525  13.156 -15.396  1.00 22.59           O  
ATOM   1120  CB  SER A 135      49.089  14.468 -17.039  0.60 23.79           C  
ATOM   1122  OG  SER A 135      48.907  14.438 -18.431  0.60 27.51           O  
ATOM   1124  N   ASN A 136      49.686  13.727 -14.236  1.00 22.61           N  
ATOM   1125  CA  ASN A 136      50.423  14.121 -13.053  1.00 22.03           C  
ATOM   1126  C   ASN A 136      50.563  13.022 -12.011  1.00 21.94           C  
ATOM   1127  O   ASN A 136      51.199  13.249 -10.977  1.00 23.00           O  
ATOM   1128  CB  ASN A 136      49.782  15.371 -12.488  1.00 21.42           C  
ATOM   1129  CG  ASN A 136      50.041  16.563 -13.355  1.00 23.46           C  
ATOM   1130  OD1 ASN A 136      51.166  17.046 -13.372  1.00 23.81           O  
ATOM   1131  ND2 ASN A 136      49.026  17.026 -14.119  1.00 20.29           N  
ATOM   1132  N   ASN A 137      50.015  11.836 -12.310  1.00 21.06           N  
ATOM   1133  CA  ASN A 137      50.048  10.699 -11.389  0.50 20.74           C  
ATOM   1135  C   ASN A 137      49.382  11.040 -10.045  1.00 20.20           C  
ATOM   1136  O   ASN A 137      49.905  10.699  -8.980  1.00 19.31           O  
ATOM   1137  CB  ASN A 137      51.501  10.214 -11.164  0.50 21.44           C  
ATOM   1139  CG  ASN A 137      52.171   9.707 -12.444  0.50 22.47           C  
ATOM   1141  OD1 ASN A 137      51.615   8.888 -13.176  0.50 25.22           O  
ATOM   1143  ND2 ASN A 137      53.392  10.169 -12.688  0.50 26.03           N  
ATOM   1145  N   ARG A 138      48.245  11.735 -10.097  1.00 19.26           N  
ATOM   1146  CA  ARG A 138      47.500  12.040  -8.877  0.50 19.11           C  
ATOM   1148  C   ARG A 138      46.096  11.435  -8.957  1.00 18.82           C  
ATOM   1149  O   ARG A 138      45.709  10.870  -9.998  1.00 18.96           O  
ATOM   1150  CB  ARG A 138      47.464  13.554  -8.613  0.50 19.43           C  
ATOM   1152  CG  ARG A 138      48.845  14.184  -8.305  0.50 19.76           C  
ATOM   1154  CD  ARG A 138      49.508  13.584  -7.048  0.50 22.13           C  
ATOM   1156  NE  ARG A 138      50.966  13.620  -7.147  0.50 23.86           N  
ATOM   1158  CZ  ARG A 138      51.815  13.292  -6.173  0.50 25.61           C  
ATOM   1160  NH1 ARG A 138      51.380  12.899  -4.980  0.50 25.56           N  
ATOM   1162  NH2 ARG A 138      53.116  13.372  -6.394  0.50 26.46           N  
ATOM   1164  N   ARG A 139      45.355  11.512  -7.848  1.00 17.23           N  
ATOM   1165  CA  ARG A 139      44.037  10.865  -7.722  0.50 16.96           C  
ATOM   1167  C   ARG A 139      42.997  11.887  -7.335  1.00 15.83           C  
ATOM   1168  O   ARG A 139      43.337  12.907  -6.706  1.00 14.39           O  
ATOM   1169  CB  ARG A 139      44.068   9.799  -6.629  0.50 16.84           C  
ATOM   1171  CG  ARG A 139      45.055   8.653  -6.870  0.50 18.52           C  
ATOM   1173  CD  ARG A 139      45.153   7.753  -5.645  0.50 19.44           C  
ATOM   1175  NE  ARG A 139      45.855   8.408  -4.528  0.50 23.45           N  
ATOM   1177  CZ  ARG A 139      46.051   7.856  -3.326  0.50 22.06           C  
ATOM   1179  NH1 ARG A 139      45.594   6.631  -3.068  0.50 23.27           N  
ATOM   1181  NH2 ARG A 139      46.702   8.534  -2.390  0.50 22.61           N  
ATOM   1183  N   ILE A 140      41.748  11.610  -7.712  1.00 15.08           N  
ATOM   1184  CA  ILE A 140      40.591  12.421  -7.271  1.00 13.90           C  
ATOM   1185  C   ILE A 140      39.466  11.503  -6.824  1.00 13.97           C  
ATOM   1186  O   ILE A 140      39.180  10.473  -7.488  1.00 13.59           O  
ATOM   1187  CB  ILE A 140      40.137  13.401  -8.365  1.00 14.32           C  
ATOM   1188  CG1 ILE A 140      38.909  14.222  -7.881  1.00 13.32           C  
ATOM   1189  CG2 ILE A 140      39.944  12.646  -9.762  1.00 15.41           C  
ATOM   1190  CD1 ILE A 140      38.601  15.426  -8.748  1.00 16.67           C  
ATOM   1191  N   ARG A 141      38.844  11.826  -5.681  1.00 13.02           N  
ATOM   1192  CA  ARG A 141      37.653  11.089  -5.269  1.00 12.67           C  
ATOM   1193  C   ARG A 141      36.565  12.081  -5.055  1.00 12.34           C  
ATOM   1194  O   ARG A 141      36.847  13.286  -4.855  1.00 12.59           O  
ATOM   1195  CB  ARG A 141      37.904  10.304  -3.986  1.00 12.09           C  
ATOM   1196  CG  ARG A 141      38.943   9.130  -4.198  1.00 14.96           C  
ATOM   1197  CD  ARG A 141      38.899   8.104  -2.994  1.00 15.79           C  
ATOM   1198  NE  ARG A 141      37.615   7.365  -2.963  1.00 16.15           N  
ATOM   1199  CZ  ARG A 141      37.392   6.247  -3.661  1.00 18.04           C  
ATOM   1200  NH1 ARG A 141      38.376   5.723  -4.377  1.00 17.68           N  
ATOM   1201  NH2 ARG A 141      36.200   5.625  -3.621  1.00 20.41           N  
ATOM   1202  N   TYR A 142      35.321  11.609  -5.108  1.00 10.62           N  
ATOM   1203  CA  TYR A 142      34.180  12.540  -5.199  1.00 11.21           C  
ATOM   1204  C   TYR A 142      32.901  11.908  -4.618  1.00 10.84           C  
ATOM   1205  O   TYR A 142      31.790  12.132  -5.125  1.00 10.46           O  
ATOM   1206  CB  TYR A 142      34.003  12.961  -6.701  1.00 11.96           C  
ATOM   1207  CG  TYR A 142      34.209  11.784  -7.643  1.00 13.80           C  
ATOM   1208  CD1 TYR A 142      33.165  10.883  -7.934  1.00 11.83           C  
ATOM   1209  CD2 TYR A 142      35.478  11.537  -8.191  1.00 15.41           C  
ATOM   1210  CE1 TYR A 142      33.382   9.775  -8.762  1.00 12.00           C  
ATOM   1211  CE2 TYR A 142      35.709  10.448  -9.035  1.00 17.44           C  
ATOM   1212  CZ  TYR A 142      34.680   9.576  -9.314  1.00 15.75           C  
ATOM   1213  OH  TYR A 142      34.964   8.498 -10.131  1.00 16.11           O  
ATOM   1214  N   GLU A 143      33.053  11.146  -3.531  1.00 11.28           N  
ATOM   1215  CA  GLU A 143      31.905  10.479  -2.872  1.00 11.28           C  
ATOM   1216  C   GLU A 143      30.738  11.448  -2.658  1.00 11.40           C  
ATOM   1217  O   GLU A 143      29.566  11.128  -2.955  1.00 11.02           O  
ATOM   1218  CB  GLU A 143      32.347   9.909  -1.498  1.00 11.21           C  
ATOM   1219  CG  GLU A 143      31.242   9.009  -0.872  1.00 11.34           C  
ATOM   1220  CD  GLU A 143      31.008   7.793  -1.717  1.00 14.56           C  
ATOM   1221  OE1 GLU A 143      31.974   7.023  -1.916  1.00 15.23           O  
ATOM   1222  OE2 GLU A 143      29.871   7.612  -2.190  1.00 14.63           O  
ATOM   1223  N   ALA A 144      31.046  12.640  -2.136  1.00 10.36           N  
ATOM   1224  CA  ALA A 144      30.000  13.559  -1.711  1.00 11.65           C  
ATOM   1225  C   ALA A 144      29.255  14.227  -2.874  1.00 11.98           C  
ATOM   1226  O   ALA A 144      28.239  14.905  -2.657  1.00 11.73           O  
ATOM   1227  CB  ALA A 144      30.599  14.645  -0.753  1.00 11.42           C  
ATOM   1228  N   THR A 145      29.727  14.017  -4.107  1.00 11.40           N  
ATOM   1229  CA  THR A 145      29.064  14.676  -5.240  1.00 12.42           C  
ATOM   1230  C   THR A 145      27.699  14.082  -5.644  1.00 13.41           C  
ATOM   1231  O   THR A 145      26.893  14.777  -6.276  1.00 14.67           O  
ATOM   1232  CB  THR A 145      29.973  14.721  -6.501  1.00 10.85           C  
ATOM   1233  OG1 THR A 145      30.271  13.386  -6.932  1.00 10.43           O  
ATOM   1234  CG2 THR A 145      31.283  15.514  -6.208  1.00 11.74           C  
ATOM   1235  N   VAL A 146      27.464  12.800  -5.332  1.00 12.87           N  
ATOM   1236  CA  VAL A 146      26.215  12.133  -5.671  1.00 13.18           C  
ATOM   1237  C   VAL A 146      25.749  11.285  -4.483  1.00 12.97           C  
ATOM   1238  O   VAL A 146      26.515  10.465  -3.949  1.00 13.61           O  
ATOM   1239  CB  VAL A 146      26.353  11.223  -6.964  1.00 14.49           C  
ATOM   1240  CG1 VAL A 146      24.956  10.580  -7.347  1.00 13.45           C  
ATOM   1241  CG2 VAL A 146      26.943  12.019  -8.163  1.00 12.10           C  
ATOM   1242  N   ALA A 147      24.480  11.439  -4.119  1.00 12.72           N  
ATOM   1243  CA  ALA A 147      23.844  10.708  -3.007  1.00 13.79           C  
ATOM   1244  C   ALA A 147      24.477  11.094  -1.639  1.00 13.42           C  
ATOM   1245  O   ALA A 147      24.446  10.319  -0.697  1.00 13.14           O  
ATOM   1246  CB  ALA A 147      23.876   9.148  -3.219  1.00 11.58           C  
ATOM   1247  N   GLY A 148      25.002  12.312  -1.541  1.00 14.41           N  
ATOM   1248  CA  GLY A 148      25.458  12.867  -0.259  1.00 15.13           C  
ATOM   1249  C   GLY A 148      26.291  11.913   0.591  1.00 14.26           C  
ATOM   1250  O   GLY A 148      27.356  11.445   0.159  1.00 14.04           O  
ATOM   1251  N   GLY A 149      25.806  11.604   1.797  1.00 14.36           N  
ATOM   1252  CA  GLY A 149      26.566  10.728   2.697  1.00 14.10           C  
ATOM   1253  C   GLY A 149      26.289   9.231   2.503  1.00 14.51           C  
ATOM   1254  O   GLY A 149      26.818   8.402   3.275  1.00 15.12           O  
ATOM   1255  N   VAL A 150      25.453   8.853   1.532  1.00 12.85           N  
ATOM   1256  CA  VAL A 150      25.154   7.409   1.362  1.00 12.01           C  
ATOM   1257  C   VAL A 150      26.269   6.792   0.577  1.00 11.04           C  
ATOM   1258  O   VAL A 150      26.519   7.249  -0.543  1.00 11.83           O  
ATOM   1259  CB  VAL A 150      23.850   7.167   0.562  1.00 13.14           C  
ATOM   1260  CG1 VAL A 150      23.552   5.647   0.439  1.00 13.57           C  
ATOM   1261  CG2 VAL A 150      22.712   7.873   1.271  1.00 13.64           C  
ATOM   1262  N   PRO A 151      26.955   5.780   1.135  1.00 10.90           N  
ATOM   1263  CA  PRO A 151      28.106   5.224   0.372  1.00 10.56           C  
ATOM   1264  C   PRO A 151      27.644   4.778  -1.018  1.00 10.36           C  
ATOM   1265  O   PRO A 151      26.647   4.042  -1.122  1.00 10.53           O  
ATOM   1266  CB  PRO A 151      28.519   4.020   1.199  1.00 10.86           C  
ATOM   1267  CG  PRO A 151      28.199   4.454   2.648  1.00 11.62           C  
ATOM   1268  CD  PRO A 151      26.802   5.149   2.466  1.00 11.72           C  
ATOM   1269  N   LEU A 152      28.362   5.196  -2.057  1.00 10.13           N  
ATOM   1270  CA  LEU A 152      27.977   4.895  -3.443  1.00 10.78           C  
ATOM   1271  C   LEU A 152      29.231   4.590  -4.254  1.00 10.31           C  
ATOM   1272  O   LEU A 152      29.410   3.503  -4.744  1.00 11.08           O  
ATOM   1273  CB  LEU A 152      27.226   6.099  -4.074  1.00  9.76           C  
ATOM   1274  CG  LEU A 152      26.892   5.989  -5.594  1.00 10.82           C  
ATOM   1275  CD1 LEU A 152      26.196   4.691  -5.899  1.00 14.53           C  
ATOM   1276  CD2 LEU A 152      25.986   7.211  -5.982  1.00 12.77           C  
ATOM   1277  N   PHE A 153      30.140   5.567  -4.353  1.00 10.18           N  
ATOM   1278  CA  PHE A 153      31.366   5.326  -5.076  1.00 11.20           C  
ATOM   1279  C   PHE A 153      32.301   4.392  -4.338  1.00 11.77           C  
ATOM   1280  O   PHE A 153      32.898   3.485  -4.953  1.00 12.27           O  
ATOM   1281  CB  PHE A 153      32.030   6.646  -5.484  1.00 11.13           C  
ATOM   1282  CG  PHE A 153      31.148   7.460  -6.416  1.00 12.51           C  
ATOM   1283  CD1 PHE A 153      30.815   6.943  -7.678  1.00 15.68           C  
ATOM   1284  CD2 PHE A 153      30.557   8.621  -5.997  1.00 15.57           C  
ATOM   1285  CE1 PHE A 153      29.947   7.648  -8.526  1.00 16.43           C  
ATOM   1286  CE2 PHE A 153      29.674   9.357  -6.864  1.00 15.85           C  
ATOM   1287  CZ  PHE A 153      29.390   8.846  -8.126  1.00 13.72           C  
ATOM   1288  N   SER A 154      32.432   4.577  -3.036  1.00 10.83           N  
ATOM   1289  CA  SER A 154      33.185   3.592  -2.247  1.00 11.37           C  
ATOM   1290  C   SER A 154      32.528   2.197  -2.287  1.00 10.76           C  
ATOM   1291  O   SER A 154      33.239   1.167  -2.267  1.00 11.05           O  
ATOM   1292  CB  SER A 154      33.314   4.046  -0.783  1.00 11.06           C  
ATOM   1293  OG  SER A 154      32.034   4.166  -0.133  1.00 10.41           O  
ATOM   1294  N   PHE A 155      31.193   2.165  -2.314  1.00  9.81           N  
ATOM   1295  CA  PHE A 155      30.420   0.911  -2.426  1.00 10.32           C  
ATOM   1296  C   PHE A 155      30.751   0.182  -3.722  1.00  9.98           C  
ATOM   1297  O   PHE A 155      31.120  -1.016  -3.746  1.00 11.24           O  
ATOM   1298  CB  PHE A 155      28.924   1.242  -2.401  1.00 10.43           C  
ATOM   1299  CG  PHE A 155      28.039   0.032  -2.172  1.00 11.22           C  
ATOM   1300  CD1 PHE A 155      27.772  -0.410  -0.885  1.00 12.74           C  
ATOM   1301  CD2 PHE A 155      27.470  -0.637  -3.247  1.00 13.28           C  
ATOM   1302  CE1 PHE A 155      26.942  -1.515  -0.662  1.00 12.17           C  
ATOM   1303  CE2 PHE A 155      26.636  -1.784  -3.037  1.00 12.94           C  
ATOM   1304  CZ  PHE A 155      26.363  -2.193  -1.739  1.00 11.62           C  
ATOM   1305  N   ILE A 156      30.690   0.914  -4.814  1.00 10.18           N  
ATOM   1306  CA  ILE A 156      31.114   0.369  -6.108  1.00 11.44           C  
ATOM   1307  C   ILE A 156      32.573  -0.086  -6.130  1.00 12.61           C  
ATOM   1308  O   ILE A 156      32.888  -1.191  -6.667  1.00 12.08           O  
ATOM   1309  CB  ILE A 156      30.846   1.398  -7.240  1.00 10.56           C  
ATOM   1310  CG1 ILE A 156      29.332   1.541  -7.427  1.00 14.29           C  
ATOM   1311  CG2 ILE A 156      31.496   0.990  -8.595  1.00 12.33           C  
ATOM   1312  CD1 ILE A 156      28.983   2.915  -8.069  1.00 13.84           C  
ATOM   1313  N   ASP A 157      33.452   0.732  -5.534  1.00 12.13           N  
ATOM   1314  CA  ASP A 157      34.887   0.569  -5.678  1.00 12.86           C  
ATOM   1315  C   ASP A 157      35.462  -0.538  -4.769  1.00 13.46           C  
ATOM   1316  O   ASP A 157      36.557  -1.044  -5.025  1.00 13.78           O  
ATOM   1317  CB  ASP A 157      35.599   1.878  -5.327  1.00 13.10           C  
ATOM   1318  CG  ASP A 157      35.496   2.945  -6.443  1.00 17.75           C  
ATOM   1319  OD1 ASP A 157      34.978   2.611  -7.520  1.00 16.67           O  
ATOM   1320  OD2 ASP A 157      35.871   4.105  -6.177  1.00 17.88           O  
ATOM   1321  N   TYR A 158      34.756  -0.858  -3.688  1.00 12.54           N  
ATOM   1322  CA  TYR A 158      35.283  -1.780  -2.658  1.00 13.02           C  
ATOM   1323  C   TYR A 158      34.342  -2.892  -2.234  1.00 11.98           C  
ATOM   1324  O   TYR A 158      34.783  -3.822  -1.585  1.00 12.65           O  
ATOM   1325  CB  TYR A 158      35.770  -1.040  -1.404  1.00 12.95           C  
ATOM   1326  CG  TYR A 158      36.863  -0.074  -1.755  1.00 16.85           C  
ATOM   1327  CD1 TYR A 158      38.175  -0.519  -1.925  1.00 20.63           C  
ATOM   1328  CD2 TYR A 158      36.583   1.275  -1.973  1.00 14.57           C  
ATOM   1329  CE1 TYR A 158      39.193   0.372  -2.273  1.00 21.59           C  
ATOM   1330  CE2 TYR A 158      37.591   2.166  -2.347  1.00 17.23           C  
ATOM   1331  CZ  TYR A 158      38.881   1.703  -2.514  1.00 20.16           C  
ATOM   1332  OH  TYR A 158      39.904   2.547  -2.890  1.00 21.81           O  
ATOM   1333  N   SER A 159      33.068  -2.790  -2.596  1.00 10.52           N  
ATOM   1334  CA  SER A 159      32.101  -3.811  -2.149  1.00 11.83           C  
ATOM   1335  C   SER A 159      31.565  -4.734  -3.249  1.00 11.75           C  
ATOM   1336  O   SER A 159      31.061  -5.832  -2.922  1.00 12.36           O  
ATOM   1337  CB  SER A 159      30.931  -3.168  -1.359  1.00 11.68           C  
ATOM   1338  OG  SER A 159      31.330  -2.812  -0.015  1.00 11.44           O  
ATOM   1339  N   VAL A 160      31.614  -4.302  -4.514  1.00 11.02           N  
ATOM   1340  CA  VAL A 160      31.103  -5.121  -5.630  1.00 11.70           C  
ATOM   1341  C   VAL A 160      32.147  -5.170  -6.755  1.00 12.37           C  
ATOM   1342  O   VAL A 160      31.818  -5.169  -7.964  1.00 12.20           O  
ATOM   1343  CB  VAL A 160      29.717  -4.655  -6.149  1.00 12.24           C  
ATOM   1344  CG1 VAL A 160      28.636  -4.793  -5.066  1.00 12.75           C  
ATOM   1345  CG2 VAL A 160      29.768  -3.158  -6.576  1.00 11.85           C  
ATOM   1346  N   LEU A 161      33.411  -5.277  -6.343  1.00 12.06           N  
ATOM   1347  CA  LEU A 161      34.533  -5.390  -7.301  1.00 13.21           C  
ATOM   1348  C   LEU A 161      34.360  -6.445  -8.402  1.00 13.97           C  
ATOM   1349  O   LEU A 161      34.736  -6.202  -9.559  1.00 15.72           O  
ATOM   1350  CB  LEU A 161      35.841  -5.665  -6.545  1.00 13.23           C  
ATOM   1351  CG  LEU A 161      36.361  -4.355  -5.960  1.00 13.52           C  
ATOM   1352  CD1 LEU A 161      37.203  -4.626  -4.720  1.00 14.46           C  
ATOM   1353  CD2 LEU A 161      37.093  -3.494  -7.056  1.00 16.86           C  
ATOM   1354  N   PRO A 162      33.842  -7.625  -8.056  1.00 14.15           N  
ATOM   1355  CA  PRO A 162      33.762  -8.634  -9.120  1.00 14.66           C  
ATOM   1356  C   PRO A 162      32.701  -8.369 -10.198  1.00 15.45           C  
ATOM   1357  O   PRO A 162      32.699  -9.069 -11.236  1.00 13.65           O  
ATOM   1358  CB  PRO A 162      33.354  -9.915  -8.381  1.00 14.04           C  
ATOM   1359  CG  PRO A 162      33.472  -9.639  -6.925  1.00 15.24           C  
ATOM   1360  CD  PRO A 162      33.355  -8.133  -6.753  1.00 13.91           C  
ATOM   1361  N   SER A 163      31.767  -7.449  -9.948  1.00 14.91           N  
ATOM   1362  CA  SER A 163      30.657  -7.250 -10.900  1.00 16.00           C  
ATOM   1363  C   SER A 163      31.037  -6.334 -12.044  1.00 18.26           C  
ATOM   1364  O   SER A 163      31.719  -5.310 -11.829  1.00 18.53           O  
ATOM   1365  CB  SER A 163      29.447  -6.665 -10.180  1.00 16.46           C  
ATOM   1366  OG  SER A 163      28.878  -7.678  -9.351  1.00 15.97           O  
ATOM   1367  N   ARG A 164      30.417  -6.565 -13.193  0.50 19.18           N  
ATOM   1369  CA  ARG A 164      30.308  -5.526 -14.218  0.50 21.05           C  
ATOM   1371  C   ARG A 164      28.941  -4.862 -14.152  0.50 21.04           C  
ATOM   1373  O   ARG A 164      28.074  -5.238 -14.944  0.50 23.75           O  
ATOM   1375  CB  ARG A 164      30.508  -6.125 -15.619  0.50 20.89           C  
ATOM   1377  CG  ARG A 164      31.942  -6.494 -16.001  0.50 23.81           C  
ATOM   1379  CD  ARG A 164      32.421  -7.840 -15.406  0.50 28.25           C  
ATOM   1381  NE  ARG A 164      31.535  -8.981 -15.683  0.50 30.61           N  
ATOM   1383  CZ  ARG A 164      31.515 -10.116 -14.979  0.50 31.78           C  
ATOM   1385  NH1 ARG A 164      32.339 -10.295 -13.944  0.50 31.46           N  
ATOM   1387  NH2 ARG A 164      30.671 -11.084 -15.316  0.50 32.04           N  
ATOM   1389  N   ILE A 165      28.771  -3.848 -13.284  0.50 19.62           N  
ATOM   1391  CA  ILE A 165      27.475  -3.222 -12.914  0.50 18.46           C  
ATOM   1393  C   ILE A 165      26.453  -2.973 -14.018  0.50 17.58           C  
ATOM   1395  O   ILE A 165      26.678  -2.198 -14.937  0.50 17.58           O  
ATOM   1397  CB  ILE A 165      27.680  -1.934 -12.042  0.50 18.67           C  
ATOM   1399  CG1 ILE A 165      28.057  -2.348 -10.609  0.50 19.38           C  
ATOM   1401  CG2 ILE A 165      26.448  -1.048 -12.047  0.50 17.46           C  
ATOM   1403  CD1 ILE A 165      29.172  -1.541 -10.039  0.50 20.41           C  
ATOM   1405  N   LYS A 166      25.290  -3.607 -13.883  0.50 16.82           N  
ATOM   1407  CA  LYS A 166      24.334  -3.673 -14.980  0.50 15.91           C  
ATOM   1409  C   LYS A 166      23.422  -2.508 -14.952  0.50 16.94           C  
ATOM   1411  O   LYS A 166      22.907  -2.104 -16.010  0.50 15.61           O  
ATOM   1413  CB  LYS A 166      23.520  -4.978 -14.962  0.50 15.53           C  
ATOM   1415  CG  LYS A 166      24.396  -6.208 -15.036  0.50 12.77           C  
ATOM   1417  CD  LYS A 166      25.563  -5.954 -16.009  0.50 15.13           C  
ATOM   1419  CE  LYS A 166      25.262  -6.405 -17.440  0.50 14.71           C  
ATOM   1421  NZ  LYS A 166      24.995  -7.872 -17.478  0.50 10.43           N  
ATOM   1423  N   LYS A 167      23.219  -1.929 -13.752  1.00 18.92           N  
ATOM   1424  CA  LYS A 167      22.259  -0.832 -13.775  1.00 17.35           C  
ATOM   1425  C   LYS A 167      22.146  -0.118 -12.425  1.00 15.87           C  
ATOM   1426  O   LYS A 167      22.242  -0.745 -11.358  1.00 14.93           O  
ATOM   1427  CB  LYS A 167      20.874  -1.365 -14.194  1.00 17.76           C  
ATOM   1428  CG  LYS A 167      19.844  -0.293 -14.333  1.00 21.65           C  
ATOM   1429  CD  LYS A 167      18.456  -0.780 -14.061  1.00 28.50           C  
ATOM   1430  CE  LYS A 167      17.697  -0.966 -15.316  1.00 32.72           C  
ATOM   1431  NZ  LYS A 167      16.311  -1.397 -14.918  1.00 39.11           N  
ATOM   1432  N   PHE A 168      21.935   1.193 -12.488  1.00 13.04           N  
ATOM   1433  CA  PHE A 168      21.720   1.988 -11.283  1.00 11.59           C  
ATOM   1434  C   PHE A 168      20.373   2.689 -11.407  1.00 12.00           C  
ATOM   1435  O   PHE A 168      20.070   3.222 -12.486  1.00 11.17           O  
ATOM   1436  CB  PHE A 168      22.858   3.020 -11.107  1.00 11.76           C  
ATOM   1437  CG  PHE A 168      22.575   4.072 -10.036  1.00 11.47           C  
ATOM   1438  CD1 PHE A 168      23.238   4.020  -8.806  1.00 10.93           C  
ATOM   1439  CD2 PHE A 168      21.647   5.129 -10.262  1.00 12.22           C  
ATOM   1440  CE1 PHE A 168      22.965   5.015  -7.778  1.00 10.95           C  
ATOM   1441  CE2 PHE A 168      21.377   6.107  -9.269  1.00 13.45           C  
ATOM   1442  CZ  PHE A 168      22.052   6.056  -8.028  1.00 12.57           C  
ATOM   1443  N   ARG A 169      19.551   2.662 -10.357  1.00 10.92           N  
ATOM   1444  CA  ARG A 169      18.337   3.487 -10.318  1.00 13.00           C  
ATOM   1445  C   ARG A 169      18.251   4.090  -8.970  1.00 11.88           C  
ATOM   1446  O   ARG A 169      18.334   3.360  -7.973  1.00 12.17           O  
ATOM   1447  CB  ARG A 169      17.060   2.644 -10.380  1.00 14.78           C  
ATOM   1448  CG  ARG A 169      16.875   1.668 -11.448  1.00 22.53           C  
ATOM   1449  CD  ARG A 169      15.706   0.730 -10.907  1.00 26.16           C  
ATOM   1450  NE  ARG A 169      14.467   1.476 -10.852  1.00 27.52           N  
ATOM   1451  CZ  ARG A 169      13.558   1.409  -9.875  1.00 26.35           C  
ATOM   1452  NH1 ARG A 169      13.690   0.572  -8.852  1.00 27.47           N  
ATOM   1453  NH2 ARG A 169      12.491   2.168  -9.962  1.00 23.99           N  
ATOM   1454  N   GLY A 170      18.036   5.397  -8.867  1.00 13.46           N  
ATOM   1455  CA  GLY A 170      17.920   5.946  -7.524  1.00 12.75           C  
ATOM   1456  C   GLY A 170      17.272   7.322  -7.452  1.00 13.96           C  
ATOM   1457  O   GLY A 170      17.002   7.971  -8.481  1.00 13.12           O  
ATOM   1458  N   ILE A 171      16.982   7.704  -6.224  1.00 12.42           N  
ATOM   1459  CA  ILE A 171      16.555   9.064  -5.891  0.60 13.41           C  
ATOM   1461  C   ILE A 171      17.816   9.770  -5.381  1.00 14.26           C  
ATOM   1462  O   ILE A 171      18.309   9.485  -4.258  1.00 14.17           O  
ATOM   1463  CB  ILE A 171      15.464   9.065  -4.802  0.60 13.32           C  
ATOM   1465  CG1 ILE A 171      14.275   8.149  -5.165  0.60 13.58           C  
ATOM   1467  CG2 ILE A 171      15.001  10.508  -4.478  0.60 14.92           C  
ATOM   1469  CD1 ILE A 171      13.557   8.499  -6.426  0.60 16.09           C  
ATOM   1471  N   VAL A 172      18.369  10.644  -6.210  1.00 14.74           N  
ATOM   1472  CA  VAL A 172      19.633  11.351  -5.886  1.00 15.62           C  
ATOM   1473  C   VAL A 172      19.443  12.883  -5.843  1.00 16.31           C  
ATOM   1474  O   VAL A 172      20.389  13.618  -5.532  1.00 17.38           O  
ATOM   1475  CB  VAL A 172      20.827  10.955  -6.848  1.00 15.43           C  
ATOM   1476  CG1 VAL A 172      21.081   9.450  -6.845  1.00 16.82           C  
ATOM   1477  CG2 VAL A 172      20.609  11.455  -8.297  1.00 17.22           C  
ATOM   1478  N   SER A 173      18.217  13.352  -6.123  1.00 17.16           N  
ATOM   1479  CA  SER A 173      17.891  14.802  -6.171  1.00 16.01           C  
ATOM   1480  C   SER A 173      16.604  15.044  -5.352  1.00 16.50           C  
ATOM   1481  O   SER A 173      15.485  14.889  -5.842  1.00 16.06           O  
ATOM   1482  CB  SER A 173      17.704  15.258  -7.618  1.00 16.97           C  
ATOM   1483  OG  SER A 173      17.829  16.676  -7.781  1.00 17.11           O  
ATOM   1484  N   LEU A 174      16.785  15.428  -4.098  1.00 15.44           N  
ATOM   1485  CA  LEU A 174      15.678  15.440  -3.124  1.00 16.26           C  
ATOM   1486  C   LEU A 174      14.701  16.607  -3.269  1.00 15.98           C  
ATOM   1487  O   LEU A 174      13.477  16.441  -3.035  1.00 17.03           O  
ATOM   1488  CB  LEU A 174      16.246  15.436  -1.699  1.00 15.54           C  
ATOM   1489  CG  LEU A 174      16.843  14.109  -1.214  1.00 19.87           C  
ATOM   1490  CD1 LEU A 174      17.230  14.229   0.266  1.00 20.29           C  
ATOM   1491  CD2 LEU A 174      15.873  12.938  -1.468  1.00 23.69           C  
ATOM   1492  N   THR A 175      15.214  17.789  -3.616  1.00 15.76           N  
ATOM   1493  CA  THR A 175      14.354  18.993  -3.627  1.00 16.19           C  
ATOM   1494  C   THR A 175      13.236  18.859  -4.691  1.00 16.80           C  
ATOM   1495  O   THR A 175      12.039  19.145  -4.412  1.00 16.48           O  
ATOM   1496  CB  THR A 175      15.182  20.305  -3.824  1.00 16.25           C  
ATOM   1497  OG1 THR A 175      16.080  20.448  -2.726  1.00 16.62           O  
ATOM   1498  CG2 THR A 175      14.270  21.528  -3.847  1.00 17.01           C  
ATOM   1499  N   ILE A 176      13.604  18.425  -5.900  1.00 16.79           N  
ATOM   1500  CA  ILE A 176      12.590  18.274  -6.961  1.00 16.47           C  
ATOM   1501  C   ILE A 176      11.588  17.194  -6.588  1.00 17.60           C  
ATOM   1502  O   ILE A 176      10.366  17.325  -6.827  1.00 17.45           O  
ATOM   1503  CB  ILE A 176      13.220  18.052  -8.365  1.00 16.22           C  
ATOM   1504  CG1 ILE A 176      12.137  18.126  -9.459  1.00 17.06           C  
ATOM   1505  CG2 ILE A 176      14.044  16.734  -8.403  1.00 16.19           C  
ATOM   1506  CD1 ILE A 176      12.659  17.980 -10.905  1.00 14.50           C  
ATOM   1507  N   ASN A 177      12.083  16.124  -5.985  1.00 16.50           N  
ATOM   1508  CA  ASN A 177      11.198  15.081  -5.528  1.00 17.41           C  
ATOM   1509  C   ASN A 177      10.289  15.516  -4.371  1.00 17.15           C  
ATOM   1510  O   ASN A 177       9.152  15.103  -4.302  1.00 17.14           O  
ATOM   1511  CB  ASN A 177      11.990  13.813  -5.159  1.00 16.28           C  
ATOM   1512  CG  ASN A 177      12.252  12.958  -6.375  1.00 16.24           C  
ATOM   1513  OD1 ASN A 177      11.325  12.427  -6.949  1.00 16.54           O  
ATOM   1514  ND2 ASN A 177      13.512  12.895  -6.822  1.00 15.53           N  
ATOM   1515  N   TYR A 178      10.797  16.356  -3.487  1.00 18.97           N  
ATOM   1516  CA  TYR A 178       9.968  16.957  -2.450  1.00 19.78           C  
ATOM   1517  C   TYR A 178       8.793  17.716  -3.105  1.00 20.08           C  
ATOM   1518  O   TYR A 178       7.629  17.528  -2.739  1.00 20.67           O  
ATOM   1519  CB  TYR A 178      10.829  17.882  -1.590  1.00 21.14           C  
ATOM   1520  CG  TYR A 178      10.013  18.727  -0.630  1.00 21.29           C  
ATOM   1521  CD1 TYR A 178       9.750  18.275   0.657  1.00 22.83           C  
ATOM   1522  CD2 TYR A 178       9.495  19.961  -1.023  1.00 22.01           C  
ATOM   1523  CE1 TYR A 178       8.975  19.036   1.545  1.00 26.79           C  
ATOM   1524  CE2 TYR A 178       8.752  20.758  -0.131  1.00 23.49           C  
ATOM   1525  CZ  TYR A 178       8.493  20.287   1.147  1.00 24.77           C  
ATOM   1526  OH  TYR A 178       7.734  21.063   2.036  1.00 25.49           O  
ATOM   1527  N   PHE A 179       9.103  18.568  -4.071  1.00 18.61           N  
ATOM   1528  CA  PHE A 179       8.066  19.318  -4.749  1.00 20.26           C  
ATOM   1529  C   PHE A 179       7.058  18.419  -5.442  1.00 20.16           C  
ATOM   1530  O   PHE A 179       5.860  18.661  -5.335  1.00 20.83           O  
ATOM   1531  CB  PHE A 179       8.666  20.300  -5.743  1.00 18.91           C  
ATOM   1532  CG  PHE A 179       9.021  21.616  -5.149  1.00 21.57           C  
ATOM   1533  CD1 PHE A 179      10.183  21.766  -4.361  1.00 20.98           C  
ATOM   1534  CD2 PHE A 179       8.220  22.736  -5.401  1.00 22.02           C  
ATOM   1535  CE1 PHE A 179      10.518  23.000  -3.836  1.00 23.01           C  
ATOM   1536  CE2 PHE A 179       8.564  23.982  -4.872  1.00 23.60           C  
ATOM   1537  CZ  PHE A 179       9.691  24.118  -4.099  1.00 21.99           C  
ATOM   1538  N   ILE A 180       7.537  17.378  -6.130  1.00 19.62           N  
ATOM   1539  CA  ILE A 180       6.659  16.424  -6.804  1.00 19.78           C  
ATOM   1540  C   ILE A 180       5.656  15.809  -5.820  1.00 20.51           C  
ATOM   1541  O   ILE A 180       4.436  15.799  -6.066  1.00 20.66           O  
ATOM   1542  CB  ILE A 180       7.489  15.305  -7.560  1.00 20.07           C  
ATOM   1543  CG1 ILE A 180       8.182  15.909  -8.792  1.00 18.86           C  
ATOM   1544  CG2 ILE A 180       6.576  14.168  -7.976  1.00 20.32           C  
ATOM   1545  CD1 ILE A 180       9.241  14.974  -9.524  1.00 19.60           C  
ATOM   1546  N   ARG A 181       6.167  15.343  -4.680  1.00 20.47           N  
ATOM   1547  CA  ARG A 181       5.364  14.665  -3.672  1.00 20.68           C  
ATOM   1548  C   ARG A 181       4.374  15.621  -2.995  1.00 21.25           C  
ATOM   1549  O   ARG A 181       3.248  15.242  -2.726  1.00 22.23           O  
ATOM   1550  CB  ARG A 181       6.271  13.949  -2.660  1.00 19.78           C  
ATOM   1551  CG  ARG A 181       7.076  12.814  -3.345  1.00 20.28           C  
ATOM   1552  CD  ARG A 181       8.195  12.238  -2.470  1.00 20.88           C  
ATOM   1553  NE  ARG A 181       7.688  11.467  -1.336  1.00 20.12           N  
ATOM   1554  CZ  ARG A 181       8.447  10.682  -0.582  1.00 22.44           C  
ATOM   1555  NH1 ARG A 181       9.771  10.561  -0.813  1.00 17.28           N  
ATOM   1556  NH2 ARG A 181       7.888  10.023   0.416  1.00 22.66           N  
ATOM   1557  N   GLU A 182       4.778  16.853  -2.730  1.00 21.79           N  
ATOM   1558  CA  GLU A 182       3.844  17.845  -2.162  1.00 22.06           C  
ATOM   1559  C   GLU A 182       2.733  18.217  -3.129  1.00 23.21           C  
ATOM   1560  O   GLU A 182       1.551  18.322  -2.739  1.00 22.88           O  
ATOM   1561  CB  GLU A 182       4.618  19.087  -1.746  1.00 22.34           C  
ATOM   1562  CG  GLU A 182       5.419  18.837  -0.509  1.00 24.39           C  
ATOM   1563  CD  GLU A 182       4.578  18.322   0.636  1.00 29.57           C  
ATOM   1564  OE1 GLU A 182       3.422  18.778   0.811  1.00 28.03           O  
ATOM   1565  OE2 GLU A 182       5.074  17.460   1.378  1.00 34.34           O  
ATOM   1566  N   LEU A 183       3.106  18.400  -4.397  1.00 23.65           N  
ATOM   1567  CA  LEU A 183       2.136  18.601  -5.460  1.00 25.19           C  
ATOM   1568  C   LEU A 183       1.173  17.408  -5.585  1.00 26.45           C  
ATOM   1569  O   LEU A 183      -0.027  17.584  -5.853  1.00 26.54           O  
ATOM   1570  CB  LEU A 183       2.841  18.892  -6.786  1.00 24.93           C  
ATOM   1571  CG  LEU A 183       3.612  20.214  -6.905  1.00 25.05           C  
ATOM   1572  CD1 LEU A 183       4.558  20.184  -8.126  1.00 25.76           C  
ATOM   1573  CD2 LEU A 183       2.699  21.423  -6.984  1.00 22.79           C  
ATOM   1574  N   ALA A 184       1.676  16.197  -5.381  1.00 26.90           N  
ATOM   1575  CA  ALA A 184       0.805  15.027  -5.403  1.00 28.28           C  
ATOM   1576  C   ALA A 184      -0.158  15.005  -4.199  1.00 29.18           C  
ATOM   1577  O   ALA A 184      -1.143  14.257  -4.208  1.00 29.86           O  
ATOM   1578  CB  ALA A 184       1.614  13.738  -5.496  1.00 27.56           C  
ATOM   1579  N   ASN A 185       0.111  15.819  -3.175  1.00 29.88           N  
ATOM   1580  CA  ASN A 185      -0.817  15.968  -2.036  1.00 30.94           C  
ATOM   1581  C   ASN A 185      -1.950  16.912  -2.382  1.00 31.71           C  
ATOM   1582  O   ASN A 185      -2.681  17.344  -1.490  1.00 32.25           O  
ATOM   1583  CB  ASN A 185      -0.111  16.503  -0.777  1.00 31.26           C  
ATOM   1584  CG  ASN A 185       0.683  15.446  -0.057  1.00 33.10           C  
ATOM   1585  OD1 ASN A 185       0.459  14.250  -0.251  1.00 35.35           O  
ATOM   1586  ND2 ASN A 185       1.642  15.877   0.768  1.00 33.68           N  
ATOM   1587  N   LYS A 186      -2.082  17.207  -3.677  1.00 31.78           N  
ATOM   1588  CA  LYS A 186      -3.030  18.181  -4.230  1.00 32.25           C  
ATOM   1589  C   LYS A 186      -2.802  19.595  -3.692  1.00 31.58           C  
ATOM   1590  O   LYS A 186      -3.710  20.237  -3.169  1.00 32.24           O  
ATOM   1591  CB  LYS A 186      -4.480  17.707  -4.086  1.00 32.63           C  
ATOM   1592  CG  LYS A 186      -4.670  16.290  -4.608  1.00 34.89           C  
ATOM   1593  CD  LYS A 186      -6.035  16.052  -5.202  1.00 40.35           C  
ATOM   1594  CE  LYS A 186      -5.984  14.822  -6.114  1.00 42.50           C  
ATOM   1595  NZ  LYS A 186      -7.304  14.589  -6.787  1.00 44.28           N  
ATOM   1596  N   ARG A 187      -1.572  20.076  -3.837  1.00 30.44           N  
ATOM   1597  CA  ARG A 187      -1.243  21.441  -3.472  1.00 28.85           C  
ATOM   1598  C   ARG A 187      -0.854  22.217  -4.723  1.00 28.26           C  
ATOM   1599  O   ARG A 187      -0.508  21.619  -5.735  1.00 27.70           O  
ATOM   1600  CB  ARG A 187      -0.127  21.458  -2.432  1.00 28.65           C  
ATOM   1601  CG  ARG A 187      -0.512  20.767  -1.108  1.00 28.11           C  
ATOM   1602  CD  ARG A 187       0.631  20.779  -0.101  1.00 28.47           C  
ATOM   1603  NE  ARG A 187       0.952  22.136   0.344  1.00 27.06           N  
ATOM   1604  CZ  ARG A 187       2.110  22.490   0.900  1.00 29.82           C  
ATOM   1605  NH1 ARG A 187       3.079  21.595   1.067  1.00 27.40           N  
ATOM   1606  NH2 ARG A 187       2.297  23.741   1.291  1.00 29.05           N  
ATOM   1607  N   GLU A 188      -0.944  23.539  -4.638  1.00 28.20           N  
ATOM   1608  CA  GLU A 188      -0.572  24.440  -5.724  0.50 28.26           C  
ATOM   1610  C   GLU A 188       0.921  24.725  -5.638  1.00 27.85           C  
ATOM   1611  O   GLU A 188       1.449  24.879  -4.538  1.00 26.89           O  
ATOM   1612  CB  GLU A 188      -1.348  25.755  -5.610  0.50 28.37           C  
ATOM   1614  CG  GLU A 188      -2.760  25.732  -6.217  0.50 29.21           C  
ATOM   1616  CD  GLU A 188      -3.539  27.018  -5.979  0.50 29.27           C  
ATOM   1618  OE1 GLU A 188      -2.904  28.092  -5.850  0.50 29.37           O  
ATOM   1620  OE2 GLU A 188      -4.794  26.955  -5.924  0.50 30.22           O  
ATOM   1622  N   PHE A 189       1.585  24.822  -6.795  1.00 27.52           N  
ATOM   1623  CA  PHE A 189       3.035  25.085  -6.851  1.00 27.14           C  
ATOM   1624  C   PHE A 189       3.431  26.292  -6.021  1.00 26.92           C  
ATOM   1625  O   PHE A 189       4.406  26.264  -5.267  1.00 25.73           O  
ATOM   1626  CB  PHE A 189       3.533  25.292  -8.297  1.00 27.22           C  
ATOM   1627  CG  PHE A 189       5.026  25.608  -8.396  1.00 25.83           C  
ATOM   1628  CD1 PHE A 189       5.976  24.574  -8.445  1.00 27.32           C  
ATOM   1629  CD2 PHE A 189       5.475  26.916  -8.438  1.00 25.47           C  
ATOM   1630  CE1 PHE A 189       7.348  24.841  -8.532  1.00 24.61           C  
ATOM   1631  CE2 PHE A 189       6.859  27.200  -8.533  1.00 26.88           C  
ATOM   1632  CZ  PHE A 189       7.797  26.147  -8.587  1.00 25.79           C  
ATOM   1633  N   ASP A 190       2.687  27.373  -6.163  1.00 26.80           N  
ATOM   1634  CA  ASP A 190       3.104  28.581  -5.472  1.00 27.96           C  
ATOM   1635  C   ASP A 190       3.010  28.475  -3.939  1.00 26.65           C  
ATOM   1636  O   ASP A 190       3.785  29.114  -3.242  1.00 26.83           O  
ATOM   1637  CB  ASP A 190       2.429  29.834  -6.061  1.00 29.84           C  
ATOM   1638  CG  ASP A 190       3.144  30.310  -7.341  1.00 34.36           C  
ATOM   1639  OD1 ASP A 190       2.754  29.883  -8.446  1.00 39.32           O  
ATOM   1640  OD2 ASP A 190       4.160  31.040  -7.229  1.00 40.49           O  
ATOM   1641  N   ASP A 191       2.096  27.647  -3.437  1.00 25.09           N  
ATOM   1642  CA  ASP A 191       1.967  27.404  -1.990  1.00 24.50           C  
ATOM   1643  C   ASP A 191       3.088  26.492  -1.513  1.00 23.41           C  
ATOM   1644  O   ASP A 191       3.664  26.685  -0.436  1.00 23.23           O  
ATOM   1645  CB  ASP A 191       0.611  26.758  -1.698  1.00 24.12           C  
ATOM   1646  CG  ASP A 191      -0.549  27.701  -1.982  1.00 24.81           C  
ATOM   1647  OD1 ASP A 191      -0.393  28.929  -1.766  1.00 25.20           O  
ATOM   1648  OD2 ASP A 191      -1.607  27.227  -2.437  1.00 23.70           O  
ATOM   1649  N   VAL A 192       3.381  25.480  -2.315  1.00 22.67           N  
ATOM   1650  CA  VAL A 192       4.505  24.572  -2.007  1.00 22.16           C  
ATOM   1651  C   VAL A 192       5.812  25.371  -1.972  1.00 21.52           C  
ATOM   1652  O   VAL A 192       6.596  25.236  -1.033  1.00 21.19           O  
ATOM   1653  CB  VAL A 192       4.646  23.428  -3.054  1.00 22.27           C  
ATOM   1654  CG1 VAL A 192       5.900  22.579  -2.762  1.00 20.02           C  
ATOM   1655  CG2 VAL A 192       3.415  22.541  -3.065  1.00 22.57           C  
ATOM   1656  N   LEU A 193       6.035  26.192  -3.005  1.00 20.64           N  
ATOM   1657  CA  LEU A 193       7.239  27.038  -3.078  1.00 20.44           C  
ATOM   1658  C   LEU A 193       7.356  27.997  -1.888  1.00 20.74           C  
ATOM   1659  O   LEU A 193       8.423  28.119  -1.279  1.00 20.49           O  
ATOM   1660  CB  LEU A 193       7.273  27.829  -4.387  1.00 20.07           C  
ATOM   1661  CG  LEU A 193       8.480  28.751  -4.576  1.00 20.07           C  
ATOM   1662  CD1 LEU A 193       9.803  27.966  -4.590  1.00 18.05           C  
ATOM   1663  CD2 LEU A 193       8.315  29.611  -5.863  1.00 19.60           C  
ATOM   1664  N   SER A 194       6.253  28.661  -1.551  1.00 20.79           N  
ATOM   1665  CA  SER A 194       6.258  29.644  -0.475  0.60 21.45           C  
ATOM   1667  C   SER A 194       6.701  29.038   0.857  1.00 21.31           C  
ATOM   1668  O   SER A 194       7.560  29.590   1.560  1.00 21.43           O  
ATOM   1669  CB  SER A 194       4.869  30.265  -0.308  0.60 20.88           C  
ATOM   1671  OG  SER A 194       4.880  31.129   0.803  0.60 22.94           O  
ATOM   1673  N   GLU A 195       6.108  27.902   1.207  1.00 21.67           N  
ATOM   1674  CA  GLU A 195       6.456  27.210   2.433  1.00 21.67           C  
ATOM   1675  C   GLU A 195       7.879  26.647   2.381  1.00 21.06           C  
ATOM   1676  O   GLU A 195       8.608  26.704   3.357  1.00 21.37           O  
ATOM   1677  CB  GLU A 195       5.493  26.046   2.648  1.00 22.39           C  
ATOM   1678  CG  GLU A 195       5.720  25.274   3.967  1.00 22.17           C  
ATOM   1679  CD  GLU A 195       4.808  24.060   4.068  1.00 24.01           C  
ATOM   1680  OE1 GLU A 195       4.471  23.498   2.983  1.00 25.44           O  
ATOM   1681  OE2 GLU A 195       4.447  23.676   5.211  1.00 21.20           O  
ATOM   1682  N   ALA A 196       8.258  26.071   1.249  1.00 20.91           N  
ATOM   1683  CA  ALA A 196       9.590  25.451   1.097  1.00 19.88           C  
ATOM   1684  C   ALA A 196      10.690  26.501   1.285  1.00 18.59           C  
ATOM   1685  O   ALA A 196      11.751  26.202   1.843  1.00 18.80           O  
ATOM   1686  CB  ALA A 196       9.706  24.783  -0.282  1.00 19.35           C  
ATOM   1687  N   THR A 197      10.406  27.735   0.847  1.00 17.40           N  
ATOM   1688  CA  THR A 197      11.310  28.859   1.045  1.00 17.60           C  
ATOM   1689  C   THR A 197      11.485  29.195   2.536  1.00 17.67           C  
ATOM   1690  O   THR A 197      12.609  29.340   3.015  1.00 16.70           O  
ATOM   1691  CB  THR A 197      10.815  30.091   0.260  1.00 17.86           C  
ATOM   1692  OG1 THR A 197      10.870  29.800  -1.146  1.00 17.30           O  
ATOM   1693  CG2 THR A 197      11.671  31.285   0.548  1.00 17.81           C  
ATOM   1694  N   LYS A 198      10.365  29.314   3.262  1.00 17.84           N  
ATOM   1695  CA  LYS A 198      10.407  29.599   4.702  1.00 17.91           C  
ATOM   1696  C   LYS A 198      11.137  28.482   5.474  1.00 17.20           C  
ATOM   1697  O   LYS A 198      11.850  28.759   6.451  1.00 18.33           O  
ATOM   1698  CB  LYS A 198       9.000  29.783   5.266  1.00 17.82           C  
ATOM   1699  CG  LYS A 198       8.199  30.888   4.607  1.00 18.75           C  
ATOM   1700  CD  LYS A 198       6.823  30.981   5.228  1.00 19.12           C  
ATOM   1701  CE  LYS A 198       5.886  31.846   4.410  1.00 18.41           C  
ATOM   1702  NZ  LYS A 198       4.592  31.967   5.087  1.00 20.56           N  
ATOM   1703  N   LEU A 199      10.950  27.233   5.039  1.00 17.12           N  
ATOM   1704  CA  LEU A 199      11.621  26.093   5.666  1.00 17.34           C  
ATOM   1705  C   LEU A 199      13.102  25.919   5.333  1.00 17.07           C  
ATOM   1706  O   LEU A 199      13.796  25.121   5.986  1.00 16.77           O  
ATOM   1707  CB  LEU A 199      10.883  24.783   5.333  1.00 17.63           C  
ATOM   1708  CG  LEU A 199       9.456  24.759   5.872  1.00 18.31           C  
ATOM   1709  CD1 LEU A 199       8.724  23.531   5.327  1.00 17.33           C  
ATOM   1710  CD2 LEU A 199       9.446  24.808   7.421  1.00 17.12           C  
ATOM   1711  N   GLY A 200      13.592  26.651   4.333  1.00 16.19           N  
ATOM   1712  CA  GLY A 200      14.966  26.477   3.874  1.00 16.09           C  
ATOM   1713  C   GLY A 200      15.172  25.226   3.011  1.00 16.33           C  
ATOM   1714  O   GLY A 200      16.304  24.784   2.833  1.00 15.09           O  
ATOM   1715  N   ILE A 201      14.088  24.667   2.474  1.00 17.01           N  
ATOM   1716  CA  ILE A 201      14.166  23.479   1.613  1.00 18.93           C  
ATOM   1717  C   ILE A 201      14.667  23.858   0.236  1.00 19.14           C  
ATOM   1718  O   ILE A 201      15.454  23.150  -0.393  1.00 19.31           O  
ATOM   1719  CB  ILE A 201      12.805  22.788   1.495  1.00 18.96           C  
ATOM   1720  CG1 ILE A 201      12.547  21.976   2.767  1.00 23.18           C  
ATOM   1721  CG2 ILE A 201      12.740  21.902   0.226  1.00 20.25           C  
ATOM   1722  CD1 ILE A 201      11.103  21.539   2.908  1.00 28.12           C  
ATOM   1723  N   VAL A 202      14.245  25.015  -0.217  1.00 20.17           N  
ATOM   1724  CA  VAL A 202      14.593  25.426  -1.554  1.00 22.30           C  
ATOM   1725  C   VAL A 202      15.353  26.733  -1.438  1.00 23.62           C  
ATOM   1726  O   VAL A 202      15.079  27.549  -0.553  1.00 25.08           O  
ATOM   1727  CB  VAL A 202      13.314  25.545  -2.396  1.00 21.64           C  
ATOM   1728  CG1 VAL A 202      12.636  26.901  -2.166  1.00 23.37           C  
ATOM   1729  CG2 VAL A 202      13.582  25.290  -3.842  1.00 23.32           C  
ATOM   1730  N   GLU A 203      16.322  26.894  -2.316  1.00 25.07           N  
ATOM   1731  CA  GLU A 203      17.117  28.112  -2.437  1.00 26.96           C  
ATOM   1732  C   GLU A 203      16.323  29.297  -3.042  1.00 27.11           C  
ATOM   1733  O   GLU A 203      15.178  29.134  -3.501  1.00 27.19           O  
ATOM   1734  CB  GLU A 203      18.354  27.796  -3.275  1.00 26.68           C  
ATOM   1735  CG  GLU A 203      19.139  26.580  -2.759  1.00 28.08           C  
ATOM   1736  CD  GLU A 203      20.238  26.108  -3.708  1.00 28.50           C  
ATOM   1737  OE1 GLU A 203      20.662  26.874  -4.611  1.00 32.22           O  
ATOM   1738  OE2 GLU A 203      20.697  24.955  -3.546  1.00 30.97           O  
ATOM   1739  N   LYS A 204      16.921  30.486  -3.012  1.00 27.21           N  
ATOM   1740  CA  LYS A 204      16.331  31.668  -3.656  1.00 27.78           C  
ATOM   1741  C   LYS A 204      16.211  31.404  -5.157  1.00 27.29           C  
ATOM   1742  O   LYS A 204      15.177  31.665  -5.780  1.00 27.38           O  
ATOM   1743  CB  LYS A 204      17.196  32.918  -3.408  1.00 27.73           C  
ATOM   1744  CG  LYS A 204      17.353  33.277  -1.928  1.00 28.43           C  
ATOM   1745  CD  LYS A 204      17.796  34.741  -1.729  1.00 28.63           C  
ATOM   1746  CE  LYS A 204      18.041  35.056  -0.241  1.00 29.03           C  
ATOM   1747  NZ  LYS A 204      16.935  34.571   0.656  1.00 29.80           N  
ATOM   1748  N   ASN A 205      17.278  30.860  -5.723  1.00 26.73           N  
ATOM   1749  CA  ASN A 205      17.255  30.427  -7.098  1.00 26.05           C  
ATOM   1750  C   ASN A 205      17.056  28.913  -7.190  1.00 25.27           C  
ATOM   1751  O   ASN A 205      18.003  28.137  -7.002  1.00 25.08           O  
ATOM   1752  CB  ASN A 205      18.538  30.830  -7.809  1.00 26.29           C  
ATOM   1753  CG  ASN A 205      18.433  30.675  -9.312  1.00 28.55           C  
ATOM   1754  OD1 ASN A 205      17.766  29.758  -9.828  1.00 26.09           O  
ATOM   1755  ND2 ASN A 205      19.082  31.581 -10.032  1.00 30.55           N  
ATOM   1756  N   TYR A 206      15.842  28.496  -7.532  1.00 23.63           N  
ATOM   1757  CA  TYR A 206      15.526  27.068  -7.450  1.00 22.56           C  
ATOM   1758  C   TYR A 206      15.571  26.356  -8.795  1.00 21.46           C  
ATOM   1759  O   TYR A 206      15.234  25.173  -8.879  1.00 19.43           O  
ATOM   1760  CB  TYR A 206      14.160  26.886  -6.817  1.00 23.23           C  
ATOM   1761  CG  TYR A 206      13.056  27.656  -7.502  1.00 24.16           C  
ATOM   1762  CD1 TYR A 206      12.544  27.225  -8.729  1.00 25.68           C  
ATOM   1763  CD2 TYR A 206      12.536  28.814  -6.933  1.00 25.97           C  
ATOM   1764  CE1 TYR A 206      11.530  27.912  -9.368  1.00 27.47           C  
ATOM   1765  CE2 TYR A 206      11.514  29.525  -7.562  1.00 25.78           C  
ATOM   1766  CZ  TYR A 206      11.015  29.063  -8.778  1.00 26.75           C  
ATOM   1767  OH  TYR A 206      10.003  29.720  -9.419  1.00 26.17           O  
ATOM   1768  N   LYS A 207      16.031  27.072  -9.820  1.00 20.21           N  
ATOM   1769  CA  LYS A 207      15.943  26.581 -11.184  0.50 20.74           C  
ATOM   1771  C   LYS A 207      16.742  25.298 -11.391  1.00 19.62           C  
ATOM   1772  O   LYS A 207      16.223  24.334 -11.934  1.00 20.77           O  
ATOM   1773  CB  LYS A 207      16.391  27.648 -12.185  0.50 20.42           C  
ATOM   1775  CG  LYS A 207      16.087  27.264 -13.621  0.50 21.90           C  
ATOM   1777  CD  LYS A 207      16.661  28.252 -14.637  0.50 22.04           C  
ATOM   1779  CE  LYS A 207      16.804  27.587 -16.016  0.50 23.99           C  
ATOM   1781  NZ  LYS A 207      15.470  27.286 -16.630  0.50 25.07           N  
ATOM   1783  N   ASP A 208      17.997  25.281 -10.959  1.00 19.18           N  
ATOM   1784  CA  ASP A 208      18.836  24.070 -11.165  1.00 18.48           C  
ATOM   1785  C   ASP A 208      18.193  22.797 -10.605  1.00 17.26           C  
ATOM   1786  O   ASP A 208      18.234  21.709 -11.239  1.00 17.58           O  
ATOM   1787  CB  ASP A 208      20.222  24.221 -10.545  1.00 18.73           C  
ATOM   1788  CG  ASP A 208      21.122  25.191 -11.303  1.00 22.49           C  
ATOM   1789  OD1 ASP A 208      20.688  25.799 -12.301  1.00 26.09           O  
ATOM   1790  OD2 ASP A 208      22.256  25.379 -10.842  1.00 26.58           O  
ATOM   1791  N   ASP A 209      17.613  22.900  -9.413  1.00 16.17           N  
ATOM   1792  CA  ASP A 209      16.903  21.733  -8.845  1.00 15.50           C  
ATOM   1793  C   ASP A 209      15.639  21.413  -9.594  1.00 15.88           C  
ATOM   1794  O   ASP A 209      15.456  20.265 -10.030  1.00 14.81           O  
ATOM   1795  CB  ASP A 209      16.548  21.912  -7.399  1.00 14.70           C  
ATOM   1796  CG  ASP A 209      17.737  21.699  -6.492  1.00 21.43           C  
ATOM   1797  OD1 ASP A 209      18.230  20.553  -6.382  1.00 26.51           O  
ATOM   1798  OD2 ASP A 209      18.194  22.693  -5.915  1.00 28.41           O  
ATOM   1799  N   LEU A 210      14.775  22.419  -9.767  1.00 14.91           N  
ATOM   1800  CA  LEU A 210      13.429  22.127 -10.295  1.00 15.86           C  
ATOM   1801  C   LEU A 210      13.332  21.849 -11.801  1.00 15.68           C  
ATOM   1802  O   LEU A 210      12.314  21.311 -12.263  1.00 17.14           O  
ATOM   1803  CB  LEU A 210      12.372  23.183  -9.818  1.00 14.09           C  
ATOM   1804  CG  LEU A 210      12.208  23.313  -8.295  1.00 15.46           C  
ATOM   1805  CD1 LEU A 210      10.955  24.122  -7.859  1.00 14.68           C  
ATOM   1806  CD2 LEU A 210      12.248  21.944  -7.592  1.00 14.41           C  
ATOM   1807  N   THR A 211      14.365  22.188 -12.565  1.00 15.96           N  
ATOM   1808  CA  THR A 211      14.435  21.803 -13.986  1.00 15.82           C  
ATOM   1809  C   THR A 211      15.067  20.425 -14.191  1.00 16.22           C  
ATOM   1810  O   THR A 211      15.145  19.922 -15.333  1.00 15.58           O  
ATOM   1811  CB  THR A 211      15.293  22.762 -14.803  1.00 16.47           C  
ATOM   1812  OG1 THR A 211      16.648  22.796 -14.290  1.00 18.99           O  
ATOM   1813  CG2 THR A 211      14.651  24.144 -14.859  1.00 15.87           C  
ATOM   1814  N   GLY A 212      15.504  19.817 -13.090  1.00 14.10           N  
ATOM   1815  CA  GLY A 212      16.160  18.486 -13.144  1.00 14.42           C  
ATOM   1816  C   GLY A 212      17.639  18.545 -13.460  1.00 13.26           C  
ATOM   1817  O   GLY A 212      18.281  17.503 -13.611  1.00 13.35           O  
ATOM   1818  N   LEU A 213      18.201  19.749 -13.519  1.00 13.28           N  
ATOM   1819  CA  LEU A 213      19.595  19.912 -13.900  1.00 13.93           C  
ATOM   1820  C   LEU A 213      20.552  19.407 -12.801  1.00 14.05           C  
ATOM   1821  O   LEU A 213      21.643  18.859 -13.086  1.00 13.52           O  
ATOM   1822  CB  LEU A 213      19.880  21.381 -14.207  1.00 14.86           C  
ATOM   1823  CG  LEU A 213      21.325  21.756 -14.592  1.00 14.28           C  
ATOM   1824  CD1 LEU A 213      21.861  20.897 -15.705  1.00 17.21           C  
ATOM   1825  CD2 LEU A 213      21.416  23.261 -14.955  1.00 16.63           C  
ATOM   1826  N   ASP A 214      20.140  19.573 -11.550  1.00 12.76           N  
ATOM   1827  CA  ASP A 214      20.903  19.006 -10.426  1.00 14.11           C  
ATOM   1828  C   ASP A 214      21.017  17.494 -10.579  1.00 13.81           C  
ATOM   1829  O   ASP A 214      22.126  16.935 -10.506  1.00 12.69           O  
ATOM   1830  CB  ASP A 214      20.218  19.325  -9.104  1.00 14.05           C  
ATOM   1831  CG  ASP A 214      20.838  18.561  -7.925  1.00 18.15           C  
ATOM   1832  OD1 ASP A 214      21.952  18.960  -7.507  1.00 17.19           O  
ATOM   1833  OD2 ASP A 214      20.248  17.547  -7.436  1.00 19.47           O  
ATOM   1834  N   ALA A 215      19.874  16.822 -10.782  1.00 12.83           N  
ATOM   1835  CA  ALA A 215      19.931  15.390 -11.131  1.00 13.01           C  
ATOM   1836  C   ALA A 215      20.824  15.103 -12.348  1.00 12.97           C  
ATOM   1837  O   ALA A 215      21.630  14.169 -12.333  1.00 11.92           O  
ATOM   1838  CB  ALA A 215      18.519  14.841 -11.335  1.00 12.48           C  
ATOM   1839  N   ALA A 216      20.702  15.881 -13.422  1.00 13.31           N  
ATOM   1840  CA  ALA A 216      21.491  15.606 -14.613  1.00 13.44           C  
ATOM   1841  C   ALA A 216      22.999  15.656 -14.329  1.00 12.61           C  
ATOM   1842  O   ALA A 216      23.762  14.800 -14.813  1.00 12.91           O  
ATOM   1843  CB  ALA A 216      21.127  16.576 -15.733  1.00 13.83           C  
ATOM   1844  N   ARG A 217      23.443  16.653 -13.562  1.00 12.13           N  
ATOM   1845  CA  ARG A 217      24.869  16.786 -13.257  1.00 12.35           C  
ATOM   1846  C   ARG A 217      25.357  15.561 -12.497  1.00 11.57           C  
ATOM   1847  O   ARG A 217      26.458  15.054 -12.744  1.00 11.10           O  
ATOM   1848  CB  ARG A 217      25.133  18.051 -12.431  1.00 12.11           C  
ATOM   1849  CG  ARG A 217      24.882  19.299 -13.262  1.00 14.74           C  
ATOM   1850  CD  ARG A 217      24.790  20.493 -12.320  1.00 20.60           C  
ATOM   1851  NE  ARG A 217      24.820  21.767 -13.033  1.00 21.88           N  
ATOM   1852  CZ  ARG A 217      24.330  22.901 -12.522  1.00 26.04           C  
ATOM   1853  NH1 ARG A 217      23.753  22.922 -11.306  1.00 25.20           N  
ATOM   1854  NH2 ARG A 217      24.405  24.007 -13.221  1.00 23.03           N  
ATOM   1855  N   LYS A 218      24.530  15.088 -11.576  1.00 12.38           N  
ATOM   1856  CA  LYS A 218      24.872  13.877 -10.777  1.00 12.29           C  
ATOM   1857  C   LYS A 218      24.947  12.649 -11.673  1.00 13.48           C  
ATOM   1858  O   LYS A 218      25.817  11.782 -11.507  1.00 13.33           O  
ATOM   1859  CB  LYS A 218      23.845  13.692  -9.669  1.00 13.00           C  
ATOM   1860  CG  LYS A 218      24.038  14.736  -8.549  1.00 11.67           C  
ATOM   1861  CD  LYS A 218      22.845  14.750  -7.581  1.00 14.42           C  
ATOM   1862  CE  LYS A 218      23.118  15.844  -6.506  1.00 15.63           C  
ATOM   1863  NZ  LYS A 218      21.881  16.043  -5.670  1.00 17.71           N  
ATOM   1864  N   SER A 219      24.047  12.579 -12.634  1.00 12.51           N  
ATOM   1865  CA  SER A 219      24.018  11.419 -13.524  1.00 13.75           C  
ATOM   1866  C   SER A 219      25.242  11.337 -14.435  1.00 13.19           C  
ATOM   1867  O   SER A 219      25.649  10.235 -14.827  1.00 13.70           O  
ATOM   1868  CB  SER A 219      22.712  11.418 -14.324  1.00 13.54           C  
ATOM   1869  OG  SER A 219      22.771  12.306 -15.447  1.00 13.29           O  
ATOM   1870  N   VAL A 220      25.862  12.469 -14.755  1.00 11.83           N  
ATOM   1871  CA  VAL A 220      27.097  12.442 -15.583  1.00 12.63           C  
ATOM   1872  C   VAL A 220      28.208  11.725 -14.822  1.00 13.10           C  
ATOM   1873  O   VAL A 220      28.898  10.839 -15.353  1.00 13.71           O  
ATOM   1874  CB  VAL A 220      27.568  13.880 -15.959  1.00 12.05           C  
ATOM   1875  CG1 VAL A 220      28.960  13.873 -16.604  1.00 12.25           C  
ATOM   1876  CG2 VAL A 220      26.498  14.588 -16.849  1.00 12.55           C  
ATOM   1877  N   ILE A 221      28.341  12.112 -13.567  1.00 11.84           N  
ATOM   1878  CA  ILE A 221      29.370  11.589 -12.682  1.00 13.03           C  
ATOM   1879  C   ILE A 221      29.151  10.098 -12.466  1.00 13.12           C  
ATOM   1880  O   ILE A 221      30.100   9.309 -12.562  1.00 13.04           O  
ATOM   1881  CB  ILE A 221      29.377  12.348 -11.351  1.00 12.57           C  
ATOM   1882  CG1 ILE A 221      29.713  13.821 -11.612  1.00 13.20           C  
ATOM   1883  CG2 ILE A 221      30.376  11.673 -10.290  1.00 12.11           C  
ATOM   1884  CD1 ILE A 221      29.585  14.707 -10.356  1.00 13.07           C  
ATOM   1885  N   LEU A 222      27.910   9.746 -12.153  1.00 12.99           N  
ATOM   1886  CA  LEU A 222      27.514   8.358 -11.978  0.70 14.84           C  
ATOM   1888  C   LEU A 222      27.849   7.484 -13.193  1.00 13.99           C  
ATOM   1889  O   LEU A 222      28.471   6.404 -13.070  1.00 13.83           O  
ATOM   1890  CB  LEU A 222      26.001   8.286 -11.742  0.70 15.30           C  
ATOM   1892  CG  LEU A 222      25.398   8.248 -10.349  0.70 18.00           C  
ATOM   1894  CD1 LEU A 222      23.886   8.449 -10.464  0.70 18.27           C  
ATOM   1896  CD2 LEU A 222      25.719   6.908  -9.703  0.70 21.70           C  
ATOM   1898  N   CYS A 223      27.382   7.930 -14.357  1.00 13.87           N  
ATOM   1899  CA  CYS A 223      27.532   7.181 -15.586  1.00 14.27           C  
ATOM   1900  C   CYS A 223      29.038   7.037 -15.930  1.00 14.76           C  
ATOM   1901  O   CYS A 223      29.514   5.944 -16.227  1.00 14.84           O  
ATOM   1902  CB  CYS A 223      26.789   7.900 -16.728  1.00 15.27           C  
ATOM   1903  SG  CYS A 223      26.798   6.966 -18.274  1.00 16.54           S  
ATOM   1904  N   ASN A 224      29.805   8.125 -15.841  1.00 13.28           N  
ATOM   1905  CA  ASN A 224      31.232   8.022 -16.149  1.00 13.68           C  
ATOM   1906  C   ASN A 224      31.974   7.097 -15.174  1.00 13.57           C  
ATOM   1907  O   ASN A 224      32.873   6.335 -15.574  1.00 14.56           O  
ATOM   1908  CB  ASN A 224      31.903   9.416 -16.138  1.00 12.92           C  
ATOM   1909  CG  ASN A 224      31.438  10.322 -17.293  1.00 16.10           C  
ATOM   1910  OD1 ASN A 224      31.669  11.544 -17.262  1.00 18.99           O  
ATOM   1911  ND2 ASN A 224      30.806   9.740 -18.301  1.00 13.06           N  
ATOM   1912  N   HIS A 225      31.598   7.147 -13.899  1.00 13.03           N  
ATOM   1913  CA  HIS A 225      32.289   6.309 -12.903  1.00 13.75           C  
ATOM   1914  C   HIS A 225      31.968   4.842 -13.193  1.00 14.15           C  
ATOM   1915  O   HIS A 225      32.833   3.980 -13.171  1.00 12.42           O  
ATOM   1916  CB  HIS A 225      31.795   6.630 -11.496  1.00 13.53           C  
ATOM   1917  CG  HIS A 225      32.496   5.838 -10.435  1.00 16.11           C  
ATOM   1918  ND1 HIS A 225      33.689   6.239  -9.879  1.00 18.78           N  
ATOM   1919  CD2 HIS A 225      32.193   4.650  -9.862  1.00 15.15           C  
ATOM   1920  CE1 HIS A 225      34.090   5.333  -8.998  1.00 18.17           C  
ATOM   1921  NE2 HIS A 225      33.197   4.361  -8.968  1.00 18.84           N  
ATOM   1922  N   LEU A 226      30.691   4.559 -13.417  1.00 13.86           N  
ATOM   1923  CA  LEU A 226      30.271   3.174 -13.625  1.00 14.67           C  
ATOM   1924  C   LEU A 226      30.771   2.527 -14.911  1.00 16.27           C  
ATOM   1925  O   LEU A 226      31.104   1.321 -14.925  1.00 16.38           O  
ATOM   1926  CB  LEU A 226      28.750   3.103 -13.559  1.00 15.81           C  
ATOM   1927  CG  LEU A 226      28.208   3.195 -12.148  1.00 15.44           C  
ATOM   1928  CD1 LEU A 226      26.718   3.420 -12.285  1.00 17.97           C  
ATOM   1929  CD2 LEU A 226      28.540   1.900 -11.376  1.00 17.06           C  
ATOM   1930  N   TYR A 227      30.764   3.286 -16.000  1.00 16.29           N  
ATOM   1931  CA  TYR A 227      30.956   2.710 -17.321  1.00 17.56           C  
ATOM   1932  C   TYR A 227      32.211   3.149 -18.034  1.00 18.77           C  
ATOM   1933  O   TYR A 227      32.527   2.621 -19.111  1.00 19.67           O  
ATOM   1934  CB  TYR A 227      29.720   2.923 -18.202  1.00 17.10           C  
ATOM   1935  CG  TYR A 227      28.500   2.461 -17.490  1.00 16.97           C  
ATOM   1936  CD1 TYR A 227      28.366   1.099 -17.073  1.00 18.75           C  
ATOM   1937  CD2 TYR A 227      27.501   3.363 -17.175  1.00 13.93           C  
ATOM   1938  CE1 TYR A 227      27.228   0.669 -16.361  1.00 17.85           C  
ATOM   1939  CE2 TYR A 227      26.383   2.950 -16.462  1.00 18.02           C  
ATOM   1940  CZ  TYR A 227      26.265   1.618 -16.046  1.00 21.36           C  
ATOM   1941  OH  TYR A 227      25.138   1.273 -15.347  1.00 21.96           O  
ATOM   1942  N   GLY A 228      32.953   4.062 -17.430  1.00 18.77           N  
ATOM   1943  CA  GLY A 228      34.214   4.519 -18.015  1.00 19.76           C  
ATOM   1944  C   GLY A 228      33.965   5.397 -19.223  1.00 19.74           C  
ATOM   1945  O   GLY A 228      34.881   5.635 -20.013  1.00 18.94           O  
ATOM   1946  N   SER A 229      32.739   5.895 -19.354  1.00 18.75           N  
ATOM   1947  CA  SER A 229      32.417   6.917 -20.357  1.00 18.81           C  
ATOM   1948  C   SER A 229      33.064   8.274 -20.002  1.00 19.37           C  
ATOM   1949  O   SER A 229      33.557   8.457 -18.883  1.00 19.57           O  
ATOM   1950  CB  SER A 229      30.889   7.097 -20.507  1.00 19.01           C  
ATOM   1951  OG  SER A 229      30.256   7.285 -19.254  1.00 16.85           O  
ATOM   1952  N   SER A 230      33.068   9.193 -20.973  1.00 18.02           N  
ATOM   1953  CA  SER A 230      33.645  10.526 -20.809  1.00 18.81           C  
ATOM   1954  C   SER A 230      32.584  11.551 -21.094  1.00 18.38           C  
ATOM   1955  O   SER A 230      32.862  12.557 -21.736  1.00 18.57           O  
ATOM   1956  CB  SER A 230      34.771  10.737 -21.816  1.00 18.91           C  
ATOM   1957  OG  SER A 230      35.889  10.004 -21.373  1.00 24.03           O  
ATOM   1958  N   TYR A 231      31.381  11.313 -20.593  1.00 16.69           N  
ATOM   1959  CA  TYR A 231      30.240  12.188 -20.878  1.00 16.70           C  
ATOM   1960  C   TYR A 231      30.327  13.552 -20.206  1.00 15.88           C  
ATOM   1961  O   TYR A 231      31.042  13.728 -19.209  1.00 15.03           O  
ATOM   1962  CB  TYR A 231      28.968  11.492 -20.433  1.00 16.18           C  
ATOM   1963  CG  TYR A 231      28.557  10.320 -21.309  1.00 17.06           C  
ATOM   1964  CD1 TYR A 231      29.199  10.050 -22.528  1.00 18.43           C  
ATOM   1965  CD2 TYR A 231      27.492   9.504 -20.928  1.00 18.89           C  
ATOM   1966  CE1 TYR A 231      28.799   8.945 -23.349  1.00 17.91           C  
ATOM   1967  CE2 TYR A 231      27.059   8.428 -21.750  1.00 14.65           C  
ATOM   1968  CZ  TYR A 231      27.718   8.166 -22.942  1.00 16.46           C  
ATOM   1969  OH  TYR A 231      27.294   7.101 -23.714  1.00 16.35           O  
ATOM   1970  N   ARG A 232      29.622  14.511 -20.803  1.00 15.59           N  
ATOM   1971  CA  ARG A 232      29.364  15.817 -20.243  1.00 16.61           C  
ATOM   1972  C   ARG A 232      27.844  15.911 -20.164  1.00 16.38           C  
ATOM   1973  O   ARG A 232      27.112  14.989 -20.566  1.00 15.19           O  
ATOM   1974  CB  ARG A 232      29.888  16.950 -21.192  1.00 17.15           C  
ATOM   1975  CG  ARG A 232      31.307  16.736 -21.708  1.00 18.30           C  
ATOM   1976  CD  ARG A 232      31.793  17.900 -22.601  1.00 19.95           C  
ATOM   1977  NE  ARG A 232      33.043  17.542 -23.287  1.00 23.44           N  
ATOM   1978  CZ  ARG A 232      34.258  17.505 -22.729  1.00 23.41           C  
ATOM   1979  NH1 ARG A 232      35.315  17.170 -23.479  1.00 24.93           N  
ATOM   1980  NH2 ARG A 232      34.434  17.800 -21.445  1.00 20.51           N  
ATOM   1981  N   LEU A 233      27.357  17.050 -19.686  1.00 17.17           N  
ATOM   1982  CA  LEU A 233      25.913  17.238 -19.518  1.00 18.26           C  
ATOM   1983  C   LEU A 233      25.077  16.957 -20.758  1.00 17.99           C  
ATOM   1984  O   LEU A 233      23.980  16.378 -20.662  1.00 18.82           O  
ATOM   1985  CB  LEU A 233      25.614  18.662 -19.042  1.00 17.64           C  
ATOM   1986  CG  LEU A 233      25.684  18.807 -17.535  1.00 21.64           C  
ATOM   1987  CD1 LEU A 233      25.736  20.318 -17.209  1.00 25.31           C  
ATOM   1988  CD2 LEU A 233      24.456  18.117 -16.833  1.00 21.18           C  
ATOM   1989  N   SER A 234      25.580  17.353 -21.928  1.00 17.55           N  
ATOM   1990  CA  SER A 234      24.810  17.211 -23.174  1.00 17.17           C  
ATOM   1991  C   SER A 234      24.581  15.731 -23.531  1.00 17.33           C  
ATOM   1992  O   SER A 234      23.741  15.421 -24.377  1.00 17.50           O  
ATOM   1993  CB  SER A 234      25.516  17.975 -24.320  1.00 17.20           C  
ATOM   1994  OG  SER A 234      26.807  17.389 -24.470  1.00 18.71           O  
ATOM   1995  N   ASP A 235      25.301  14.807 -22.880  1.00 16.26           N  
ATOM   1996  CA  ASP A 235      25.182  13.361 -23.176  1.00 16.95           C  
ATOM   1997  C   ASP A 235      24.076  12.656 -22.391  1.00 17.37           C  
ATOM   1998  O   ASP A 235      23.823  11.468 -22.599  1.00 16.70           O  
ATOM   1999  CB  ASP A 235      26.503  12.635 -22.897  1.00 17.14           C  
ATOM   2000  CG  ASP A 235      27.581  13.079 -23.812  1.00 21.04           C  
ATOM   2001  OD1 ASP A 235      27.393  12.882 -25.016  1.00 26.79           O  
ATOM   2002  OD2 ASP A 235      28.589  13.659 -23.366  1.00 21.44           O  
ATOM   2003  N   VAL A 236      23.440  13.370 -21.465  1.00 15.97           N  
ATOM   2004  CA  VAL A 236      22.446  12.729 -20.601  1.00 15.81           C  
ATOM   2005  C   VAL A 236      21.079  13.348 -20.822  1.00 16.05           C  
ATOM   2006  O   VAL A 236      20.960  14.465 -21.332  1.00 14.97           O  
ATOM   2007  CB  VAL A 236      22.853  12.792 -19.071  1.00 15.46           C  
ATOM   2008  CG1 VAL A 236      24.297  12.335 -18.871  1.00 15.23           C  
ATOM   2009  CG2 VAL A 236      22.683  14.234 -18.485  1.00 14.01           C  
ATOM   2010  N   PHE A 237      20.037  12.619 -20.453  1.00 16.51           N  
ATOM   2011  CA  PHE A 237      18.699  13.158 -20.537  1.00 16.66           C  
ATOM   2012  C   PHE A 237      18.229  13.662 -19.192  1.00 15.92           C  
ATOM   2013  O   PHE A 237      18.451  13.007 -18.182  1.00 16.27           O  
ATOM   2014  CB  PHE A 237      17.710  12.069 -20.989  1.00 17.43           C  
ATOM   2015  CG  PHE A 237      16.278  12.535 -20.968  1.00 19.26           C  
ATOM   2016  CD1 PHE A 237      15.710  13.142 -22.097  1.00 22.81           C  
ATOM   2017  CD2 PHE A 237      15.508  12.405 -19.815  1.00 20.43           C  
ATOM   2018  CE1 PHE A 237      14.406  13.587 -22.069  1.00 23.80           C  
ATOM   2019  CE2 PHE A 237      14.210  12.881 -19.774  1.00 21.77           C  
ATOM   2020  CZ  PHE A 237      13.658  13.451 -20.896  1.00 23.38           C  
ATOM   2021  N   TYR A 238      17.499  14.778 -19.162  1.00 15.05           N  
ATOM   2022  CA  TYR A 238      16.806  15.148 -17.928  1.00 15.95           C  
ATOM   2023  C   TYR A 238      15.561  15.956 -18.181  1.00 16.36           C  
ATOM   2024  O   TYR A 238      15.392  16.549 -19.264  1.00 15.26           O  
ATOM   2025  CB  TYR A 238      17.710  15.926 -16.933  1.00 16.26           C  
ATOM   2026  CG  TYR A 238      18.152  17.312 -17.399  1.00 15.98           C  
ATOM   2027  CD1 TYR A 238      17.558  18.462 -16.867  1.00 17.58           C  
ATOM   2028  CD2 TYR A 238      19.185  17.471 -18.314  1.00 15.16           C  
ATOM   2029  CE1 TYR A 238      17.956  19.739 -17.280  1.00 18.67           C  
ATOM   2030  CE2 TYR A 238      19.597  18.744 -18.716  1.00 19.46           C  
ATOM   2031  CZ  TYR A 238      18.969  19.870 -18.184  1.00 19.43           C  
ATOM   2032  OH  TYR A 238      19.391  21.140 -18.550  1.00 19.76           O  
ATOM   2033  N   GLU A 239      14.699  16.006 -17.168  1.00 16.79           N  
ATOM   2034  CA  GLU A 239      13.492  16.829 -17.263  1.00 18.28           C  
ATOM   2035  C   GLU A 239      13.107  17.295 -15.849  1.00 17.81           C  
ATOM   2036  O   GLU A 239      13.632  16.784 -14.856  1.00 16.26           O  
ATOM   2037  CB  GLU A 239      12.346  16.022 -17.924  1.00 19.43           C  
ATOM   2038  CG  GLU A 239      11.816  14.885 -17.036  1.00 19.16           C  
ATOM   2039  CD  GLU A 239      10.794  14.009 -17.734  1.00 21.88           C  
ATOM   2040  OE1 GLU A 239      10.463  14.328 -18.885  1.00 27.55           O  
ATOM   2041  OE2 GLU A 239      10.334  13.010 -17.147  1.00 19.22           O  
ATOM   2042  N   GLY A 240      12.216  18.281 -15.761  1.00 17.98           N  
ATOM   2043  CA  GLY A 240      11.874  18.877 -14.475  1.00 19.49           C  
ATOM   2044  C   GLY A 240      10.381  19.178 -14.371  1.00 19.89           C  
ATOM   2045  O   GLY A 240       9.563  18.563 -15.065  1.00 19.94           O  
ATOM   2046  N   ILE A 241      10.025  20.095 -13.489  1.00 20.54           N  
ATOM   2047  CA  ILE A 241       8.616  20.329 -13.194  1.00 21.13           C  
ATOM   2048  C   ILE A 241       8.132  21.742 -13.531  1.00 23.00           C  
ATOM   2049  O   ILE A 241       6.945  22.055 -13.339  1.00 23.72           O  
ATOM   2050  CB  ILE A 241       8.269  19.973 -11.708  1.00 20.80           C  
ATOM   2051  CG1 ILE A 241       9.040  20.856 -10.721  1.00 19.06           C  
ATOM   2052  CG2 ILE A 241       8.583  18.485 -11.392  1.00 21.22           C  
ATOM   2053  CD1 ILE A 241       8.544  20.744  -9.328  1.00 16.89           C  
ATOM   2054  N   LEU A 242       9.018  22.594 -14.033  1.00 24.13           N  
ATOM   2055  CA  LEU A 242       8.673  23.988 -14.271  1.00 25.85           C  
ATOM   2056  C   LEU A 242       7.904  24.234 -15.592  1.00 28.10           C  
ATOM   2057  O   LEU A 242       8.054  23.456 -16.544  1.00 30.10           O  
ATOM   2058  CB  LEU A 242       9.928  24.869 -14.218  1.00 25.74           C  
ATOM   2059  CG  LEU A 242      10.720  24.808 -12.903  1.00 23.47           C  
ATOM   2060  CD1 LEU A 242      11.907  25.758 -12.972  1.00 22.82           C  
ATOM   2061  CD2 LEU A 242       9.838  25.125 -11.680  1.00 22.61           C  
ATOM   2062  N   GLN A 244       5.228  23.992 -17.302  1.00 58.82           N  
ATOM   2063  CA  GLN A 244       4.455  22.750 -17.379  1.00 58.60           C  
ATOM   2064  C   GLN A 244       3.454  22.629 -16.218  1.00 58.23           C  
ATOM   2065  O   GLN A 244       3.861  22.410 -15.066  1.00 58.50           O  
ATOM   2066  CB  GLN A 244       5.397  21.548 -17.364  1.00 58.18           C  
ATOM   2067  CG  GLN A 244       4.680  20.192 -17.198  1.00 59.15           C  
ATOM   2068  CD  GLN A 244       5.482  19.128 -16.421  1.00 58.00           C  
ATOM   2069  OE1 GLN A 244       5.406  17.941 -16.730  1.00 57.48           O  
ATOM   2070  NE2 GLN A 244       6.225  19.555 -15.403  1.00 57.70           N  
ATOM   2071  N   ASP A 245       2.157  22.751 -16.510  1.00 57.29           N  
ATOM   2072  CA  ASP A 245       1.147  22.559 -15.453  1.00 56.30           C  
ATOM   2073  C   ASP A 245       0.346  21.243 -15.592  1.00 54.95           C  
ATOM   2074  O   ASP A 245      -0.404  21.041 -16.562  1.00 55.27           O  
ATOM   2075  CB  ASP A 245       0.293  23.831 -15.213  1.00 56.55           C  
ATOM   2076  CG  ASP A 245      -1.093  23.781 -15.866  1.00 58.13           C  
ATOM   2077  OD1 ASP A 245      -1.197  23.633 -17.107  1.00 60.25           O  
ATOM   2078  OD2 ASP A 245      -2.096  23.935 -15.129  1.00 59.00           O  
ATOM   2079  N   ARG A 246       0.538  20.353 -14.618  1.00 52.58           N  
ATOM   2080  CA  ARG A 246      -0.173  19.072 -14.555  1.00 50.20           C  
ATOM   2081  C   ARG A 246      -0.244  18.542 -13.116  1.00 48.43           C  
ATOM   2082  O   ARG A 246       0.544  18.954 -12.247  1.00 48.84           O  
ATOM   2083  CB  ARG A 246       0.517  18.026 -15.441  1.00 50.41           C  
ATOM   2084  CG  ARG A 246       1.797  17.411 -14.849  1.00 49.60           C  
ATOM   2085  CD  ARG A 246       2.234  16.252 -15.726  1.00 48.75           C  
ATOM   2086  NE  ARG A 246       3.405  15.509 -15.251  1.00 46.82           N  
ATOM   2087  CZ  ARG A 246       3.370  14.392 -14.518  1.00 45.27           C  
ATOM   2088  NH1 ARG A 246       4.494  13.804 -14.197  1.00 48.00           N  
ATOM   2089  NH2 ARG A 246       2.237  13.859 -14.089  1.00 44.29           N  
ATOM   2090  N   SER A 247      -1.176  17.622 -12.876  1.00 45.37           N  
ATOM   2091  CA  SER A 247      -1.233  16.904 -11.602  1.00 42.25           C  
ATOM   2092  C   SER A 247      -0.145  15.813 -11.538  1.00 39.44           C  
ATOM   2093  O   SER A 247       0.272  15.280 -12.563  1.00 39.43           O  
ATOM   2094  CB  SER A 247      -2.642  16.316 -11.354  1.00 42.51           C  
ATOM   2095  OG  SER A 247      -2.945  15.220 -12.218  1.00 42.80           O  
ATOM   2096  N   PHE A 248       0.325  15.514 -10.336  1.00 35.53           N  
ATOM   2097  CA  PHE A 248       1.256  14.418 -10.134  1.00 32.21           C  
ATOM   2098  C   PHE A 248       0.571  13.376  -9.278  1.00 30.27           C  
ATOM   2099  O   PHE A 248      -0.198  13.721  -8.386  1.00 29.90           O  
ATOM   2100  CB  PHE A 248       2.548  14.896  -9.437  1.00 31.50           C  
ATOM   2101  CG  PHE A 248       3.441  15.746 -10.316  1.00 31.03           C  
ATOM   2102  CD1 PHE A 248       3.442  17.136 -10.202  1.00 32.57           C  
ATOM   2103  CD2 PHE A 248       4.270  15.160 -11.264  1.00 30.09           C  
ATOM   2104  CE1 PHE A 248       4.269  17.927 -11.014  1.00 30.70           C  
ATOM   2105  CE2 PHE A 248       5.089  15.945 -12.090  1.00 28.81           C  
ATOM   2106  CZ  PHE A 248       5.090  17.323 -11.963  1.00 29.79           C  
ATOM   2107  N   GLY A 249       0.848  12.108  -9.543  1.00 28.20           N  
ATOM   2108  CA  GLY A 249       0.318  11.016  -8.732  1.00 26.91           C  
ATOM   2109  C   GLY A 249       1.213  10.722  -7.538  1.00 25.69           C  
ATOM   2110  O   GLY A 249       2.383  11.101  -7.535  1.00 24.55           O  
ATOM   2111  N   LYS A 250       0.676  10.030  -6.533  1.00 24.94           N  
ATOM   2112  CA  LYS A 250       1.426   9.673  -5.314  1.00 26.05           C  
ATOM   2113  C   LYS A 250       2.669   8.802  -5.561  1.00 24.87           C  
ATOM   2114  O   LYS A 250       3.591   8.757  -4.739  1.00 24.73           O  
ATOM   2115  CB  LYS A 250       0.508   8.935  -4.323  1.00 26.02           C  
ATOM   2116  CG  LYS A 250      -0.621   9.787  -3.707  1.00 30.86           C  
ATOM   2117  CD  LYS A 250      -0.076  10.898  -2.791  1.00 34.74           C  
ATOM   2118  CE  LYS A 250       0.250  10.371  -1.392  1.00 36.44           C  
ATOM   2119  NZ  LYS A 250       0.442  11.475  -0.411  1.00 36.37           N  
ATOM   2120  N   ASN A 251       2.663   8.080  -6.680  1.00 24.72           N  
ATOM   2121  CA  ASN A 251       3.761   7.170  -6.997  1.00 23.38           C  
ATOM   2122  C   ASN A 251       4.781   7.733  -7.987  1.00 22.15           C  
ATOM   2123  O   ASN A 251       5.661   6.986  -8.443  1.00 21.74           O  
ATOM   2124  CB  ASN A 251       3.206   5.865  -7.540  1.00 24.86           C  
ATOM   2125  CG  ASN A 251       2.578   5.017  -6.467  1.00 27.77           C  
ATOM   2126  OD1 ASN A 251       2.647   5.342  -5.273  1.00 32.06           O  
ATOM   2127  ND2 ASN A 251       1.979   3.908  -6.876  1.00 31.93           N  
ATOM   2128  N   GLU A 252       4.677   9.023  -8.317  1.00 20.37           N  
ATOM   2129  CA  GLU A 252       5.672   9.647  -9.209  1.00 20.21           C  
ATOM   2130  C   GLU A 252       6.923  10.133  -8.469  1.00 18.90           C  
ATOM   2131  O   GLU A 252       6.819  10.719  -7.380  1.00 18.90           O  
ATOM   2132  CB  GLU A 252       5.053  10.788 -10.030  1.00 20.58           C  
ATOM   2133  CG  GLU A 252       3.981  10.289 -10.987  1.00 23.13           C  
ATOM   2134  CD  GLU A 252       3.557  11.318 -12.022  1.00 27.69           C  
ATOM   2135  OE1 GLU A 252       4.253  11.472 -13.045  1.00 27.84           O  
ATOM   2136  OE2 GLU A 252       2.495  11.941 -11.825  1.00 28.92           O  
ATOM   2137  N   ARG A 253       8.081   9.906  -9.091  1.00 17.98           N  
ATOM   2138  CA  ARG A 253       9.381  10.376  -8.606  1.00 17.29           C  
ATOM   2139  C   ARG A 253      10.259  10.781  -9.799  1.00 17.07           C  
ATOM   2140  O   ARG A 253      10.102  10.254 -10.906  1.00 17.98           O  
ATOM   2141  CB  ARG A 253      10.106   9.262  -7.831  1.00 16.45           C  
ATOM   2142  CG  ARG A 253       9.398   8.722  -6.554  1.00 18.18           C  
ATOM   2143  CD  ARG A 253       9.323   9.755  -5.395  1.00 17.57           C  
ATOM   2144  NE  ARG A 253       8.787   9.134  -4.168  1.00 17.27           N  
ATOM   2145  CZ  ARG A 253       7.490   8.938  -3.928  1.00 20.74           C  
ATOM   2146  NH1 ARG A 253       6.567   9.338  -4.795  1.00 19.44           N  
ATOM   2147  NH2 ARG A 253       7.110   8.326  -2.816  1.00 19.76           N  
ATOM   2148  N   LEU A 254      11.181  11.699  -9.576  1.00 16.06           N  
ATOM   2149  CA  LEU A 254      12.241  11.921 -10.545  1.00 15.49           C  
ATOM   2150  C   LEU A 254      13.319  10.914 -10.205  1.00 15.32           C  
ATOM   2151  O   LEU A 254      14.002  11.043  -9.173  1.00 15.68           O  
ATOM   2152  CB  LEU A 254      12.778  13.352 -10.495  1.00 16.47           C  
ATOM   2153  CG  LEU A 254      13.852  13.448 -11.596  1.00 16.19           C  
ATOM   2154  CD1 LEU A 254      13.215  13.935 -12.904  1.00 16.43           C  
ATOM   2155  CD2 LEU A 254      14.999  14.306 -11.207  1.00 18.77           C  
ATOM   2156  N   VAL A 255      13.412   9.886 -11.040  1.00 14.32           N  
ATOM   2157  CA  VAL A 255      14.364   8.800 -10.838  1.00 15.19           C  
ATOM   2158  C   VAL A 255      15.553   8.971 -11.776  1.00 14.54           C  
ATOM   2159  O   VAL A 255      15.374   9.185 -12.985  1.00 14.22           O  
ATOM   2160  CB  VAL A 255      13.719   7.418 -11.143  1.00 15.55           C  
ATOM   2161  CG1 VAL A 255      14.743   6.296 -10.909  1.00 15.82           C  
ATOM   2162  CG2 VAL A 255      12.469   7.138 -10.218  1.00 16.43           C  
ATOM   2163  N   THR A 256      16.756   8.853 -11.228  1.00 13.11           N  
ATOM   2164  CA  THR A 256      17.981   8.901 -12.011  1.00 13.11           C  
ATOM   2165  C   THR A 256      18.416   7.468 -12.258  1.00 15.40           C  
ATOM   2166  O   THR A 256      18.595   6.691 -11.290  1.00 13.22           O  
ATOM   2167  CB  THR A 256      19.039   9.724 -11.270  1.00 13.94           C  
ATOM   2168  OG1 THR A 256      18.551  11.064 -11.143  1.00 12.74           O  
ATOM   2169  CG2 THR A 256      20.392   9.745 -12.004  1.00 13.07           C  
ATOM   2170  N   GLU A 257      18.578   7.126 -13.545  1.00 15.61           N  
ATOM   2171  CA  GLU A 257      18.881   5.750 -13.962  0.50 17.95           C  
ATOM   2173  C   GLU A 257      20.063   5.752 -14.913  1.00 17.94           C  
ATOM   2174  O   GLU A 257      20.100   6.555 -15.870  1.00 18.43           O  
ATOM   2175  CB  GLU A 257      17.685   5.089 -14.679  0.50 18.00           C  
ATOM   2177  CG  GLU A 257      16.423   4.876 -13.828  0.50 19.71           C  
ATOM   2179  CD  GLU A 257      15.251   4.297 -14.635  0.50 20.41           C  
ATOM   2181  OE1 GLU A 257      15.510   3.463 -15.548  0.50 23.94           O  
ATOM   2183  OE2 GLU A 257      14.076   4.666 -14.358  0.50 19.32           O  
ATOM   2185  N   THR A 258      21.014   4.851 -14.681  1.00 17.69           N  
ATOM   2186  CA  THR A 258      22.147   4.676 -15.600  0.50 18.27           C  
ATOM   2188  C   THR A 258      22.350   3.200 -15.932  1.00 18.22           C  
ATOM   2189  O   THR A 258      22.155   2.332 -15.062  1.00 18.29           O  
ATOM   2190  CB  THR A 258      23.463   5.244 -15.005  0.50 18.61           C  
ATOM   2192  OG1 THR A 258      24.017   4.295 -14.085  0.50 19.51           O  
ATOM   2194  CG2 THR A 258      23.222   6.588 -14.282  0.50 18.13           C  
ATOM   2196  N   GLY A 259      22.756   2.906 -17.162  1.00 18.25           N  
ATOM   2197  CA  GLY A 259      22.985   1.521 -17.576  1.00 17.61           C  
ATOM   2198  C   GLY A 259      23.604   1.519 -18.970  1.00 19.12           C  
ATOM   2199  O   GLY A 259      23.751   2.576 -19.607  1.00 17.83           O  
ATOM   2200  N   ILE A 260      23.995   0.343 -19.438  1.00 19.55           N  
ATOM   2201  CA  ILE A 260      24.433   0.236 -20.798  1.00 22.42           C  
ATOM   2202  C   ILE A 260      23.235  -0.140 -21.643  1.00 23.85           C  
ATOM   2203  O   ILE A 260      22.665  -1.205 -21.457  1.00 24.67           O  
ATOM   2204  CB  ILE A 260      25.587  -0.734 -20.911  1.00 23.64           C  
ATOM   2205  CG1 ILE A 260      26.857   0.015 -20.438  1.00 24.42           C  
ATOM   2206  CG2 ILE A 260      25.662  -1.302 -22.368  1.00 23.56           C  
ATOM   2207  CD1 ILE A 260      28.163  -0.711 -20.639  1.00 28.29           C  
ATOM   2208  N   VAL A 261      22.827   0.767 -22.540  1.00 25.39           N  
ATOM   2209  CA  VAL A 261      21.607   0.581 -23.345  1.00 26.79           C  
ATOM   2210  C   VAL A 261      21.945   0.605 -24.830  1.00 28.08           C  
ATOM   2211  O   VAL A 261      22.568   1.535 -25.312  1.00 28.02           O  
ATOM   2212  CB  VAL A 261      20.498   1.611 -23.028  1.00 26.99           C  
ATOM   2213  CG1 VAL A 261      19.282   1.395 -23.941  1.00 27.97           C  
ATOM   2214  CG2 VAL A 261      20.096   1.557 -21.544  1.00 27.62           C  
ATOM   2215  N   ASN A 262      21.553  -0.452 -25.535  1.00 28.45           N  
ATOM   2216  CA  ASN A 262      21.920  -0.639 -26.929  1.00 29.58           C  
ATOM   2217  C   ASN A 262      23.457  -0.551 -27.143  1.00 29.46           C  
ATOM   2218  O   ASN A 262      23.930   0.029 -28.136  1.00 29.30           O  
ATOM   2219  CB  ASN A 262      21.162   0.371 -27.803  1.00 29.69           C  
ATOM   2220  CG  ASN A 262      21.153  -0.026 -29.262  1.00 31.57           C  
ATOM   2221  OD1 ASN A 262      21.120  -1.213 -29.591  1.00 33.07           O  
ATOM   2222  ND2 ASN A 262      21.213   0.964 -30.148  1.00 32.87           N  
ATOM   2223  N   GLY A 263      24.217  -1.107 -26.185  1.00 29.47           N  
ATOM   2224  CA  GLY A 263      25.701  -1.110 -26.230  1.00 28.34           C  
ATOM   2225  C   GLY A 263      26.390   0.194 -25.788  1.00 27.26           C  
ATOM   2226  O   GLY A 263      27.638   0.263 -25.728  1.00 28.69           O  
ATOM   2227  N   LYS A 264      25.593   1.219 -25.460  1.00 23.73           N  
ATOM   2228  CA  LYS A 264      26.114   2.534 -25.116  1.00 21.26           C  
ATOM   2229  C   LYS A 264      25.744   2.898 -23.678  1.00 18.29           C  
ATOM   2230  O   LYS A 264      24.602   2.698 -23.307  1.00 16.25           O  
ATOM   2231  CB  LYS A 264      25.459   3.543 -26.056  1.00 21.53           C  
ATOM   2232  CG  LYS A 264      26.023   4.932 -26.022  1.00 24.87           C  
ATOM   2233  CD  LYS A 264      25.152   5.819 -26.940  1.00 26.30           C  
ATOM   2234  CE  LYS A 264      25.544   7.259 -26.888  1.00 28.36           C  
ATOM   2235  NZ  LYS A 264      27.029   7.437 -26.962  1.00 29.56           N  
ATOM   2236  N   PRO A 265      26.704   3.423 -22.873  1.00 17.38           N  
ATOM   2237  CA  PRO A 265      26.312   3.927 -21.546  1.00 17.36           C  
ATOM   2238  C   PRO A 265      25.241   4.979 -21.718  1.00 17.97           C  
ATOM   2239  O   PRO A 265      25.291   5.826 -22.643  1.00 16.29           O  
ATOM   2240  CB  PRO A 265      27.598   4.575 -21.005  1.00 18.36           C  
ATOM   2241  CG  PRO A 265      28.719   3.745 -21.667  1.00 16.51           C  
ATOM   2242  CD  PRO A 265      28.159   3.561 -23.100  1.00 17.82           C  
ATOM   2243  N   SER A 266      24.292   4.951 -20.813  1.00 18.64           N  
ATOM   2244  CA  SER A 266      23.136   5.819 -20.885  1.00 19.44           C  
ATOM   2245  C   SER A 266      22.804   6.379 -19.496  1.00 18.73           C  
ATOM   2246  O   SER A 266      22.958   5.672 -18.484  1.00 18.55           O  
ATOM   2247  CB  SER A 266      21.988   4.947 -21.380  1.00 19.40           C  
ATOM   2248  OG  SER A 266      20.765   5.621 -21.163  1.00 26.66           O  
ATOM   2249  N   ALA A 267      22.384   7.640 -19.408  1.00 16.80           N  
ATOM   2250  CA  ALA A 267      22.009   8.197 -18.087  1.00 16.86           C  
ATOM   2251  C   ALA A 267      20.812   9.110 -18.292  1.00 16.59           C  
ATOM   2252  O   ALA A 267      20.835   9.934 -19.235  1.00 16.32           O  
ATOM   2253  CB  ALA A 267      23.136   9.014 -17.514  1.00 16.90           C  
ATOM   2254  N   GLU A 268      19.778   8.947 -17.466  1.00 15.87           N  
ATOM   2255  CA  GLU A 268      18.529   9.710 -17.613  0.60 16.74           C  
ATOM   2257  C   GLU A 268      17.906   9.981 -16.247  1.00 17.11           C  
ATOM   2258  O   GLU A 268      17.929   9.102 -15.352  1.00 19.04           O  
ATOM   2259  CB  GLU A 268      17.513   8.918 -18.444  0.60 17.04           C  
ATOM   2261  CG  GLU A 268      16.799   7.897 -17.588  0.60 18.93           C  
ATOM   2263  CD  GLU A 268      15.749   7.081 -18.287  0.60 22.54           C  
ATOM   2265  OE1 GLU A 268      15.894   6.818 -19.496  0.60 21.32           O  
ATOM   2267  OE2 GLU A 268      14.792   6.670 -17.591  0.60 22.76           O  
ATOM   2269  N   SER A 269      17.330  11.174 -16.084  1.00 16.48           N  
ATOM   2270  CA  SER A 269      16.581  11.513 -14.885  1.00 15.76           C  
ATOM   2271  C   SER A 269      15.205  11.869 -15.418  1.00 16.67           C  
ATOM   2272  O   SER A 269      15.063  12.828 -16.186  1.00 16.57           O  
ATOM   2273  CB  SER A 269      17.231  12.678 -14.124  1.00 15.93           C  
ATOM   2274  OG  SER A 269      18.576  12.329 -13.754  1.00 14.37           O  
ATOM   2275  N   ARG A 270      14.205  11.081 -15.040  1.00 17.10           N  
ATOM   2276  CA  ARG A 270      12.865  11.176 -15.630  1.00 19.28           C  
ATOM   2277  C   ARG A 270      11.832  11.028 -14.535  1.00 19.79           C  
ATOM   2278  O   ARG A 270      12.051  10.276 -13.578  1.00 18.91           O  
ATOM   2279  CB  ARG A 270      12.587  10.005 -16.590  1.00 18.73           C  
ATOM   2280  CG  ARG A 270      13.266  10.092 -17.897  1.00 23.28           C  
ATOM   2281  CD  ARG A 270      12.649   9.008 -18.870  1.00 23.39           C  
ATOM   2282  NE  ARG A 270      13.464   8.948 -20.079  1.00 27.76           N  
ATOM   2283  CZ  ARG A 270      13.236   9.709 -21.149  1.00 30.36           C  
ATOM   2284  NH1 ARG A 270      12.213  10.536 -21.166  1.00 30.28           N  
ATOM   2285  NH2 ARG A 270      14.012   9.634 -22.207  1.00 31.85           N  
ATOM   2286  N   ILE A 271      10.690  11.694 -14.713  1.00 19.90           N  
ATOM   2287  CA  ILE A 271       9.579  11.557 -13.780  1.00 21.41           C  
ATOM   2288  C   ILE A 271       8.780  10.332 -14.146  1.00 22.02           C  
ATOM   2289  O   ILE A 271       8.187  10.284 -15.219  1.00 20.11           O  
ATOM   2290  CB  ILE A 271       8.677  12.817 -13.763  1.00 21.11           C  
ATOM   2291  CG1 ILE A 271       9.537  14.014 -13.334  1.00 21.16           C  
ATOM   2292  CG2 ILE A 271       7.571  12.638 -12.756  1.00 22.01           C  
ATOM   2293  CD1 ILE A 271       8.836  15.368 -13.362  1.00 23.76           C  
ATOM   2294  N   LYS A 272       8.771   9.349 -13.254  1.00 22.10           N  
ATOM   2295  CA  LYS A 272       8.140   8.074 -13.553  1.00 24.51           C  
ATOM   2296  C   LYS A 272       7.110   7.759 -12.521  1.00 24.52           C  
ATOM   2297  O   LYS A 272       7.286   8.056 -11.343  1.00 23.21           O  
ATOM   2298  CB  LYS A 272       9.186   6.956 -13.579  1.00 24.70           C  
ATOM   2299  CG  LYS A 272      10.459   7.386 -14.285  1.00 30.50           C  
ATOM   2300  CD  LYS A 272      11.314   6.237 -14.689  1.00 32.33           C  
ATOM   2301  CE  LYS A 272      10.741   5.607 -15.924  1.00 35.10           C  
ATOM   2302  NZ  LYS A 272      11.290   4.241 -16.060  1.00 38.95           N  
ATOM   2303  N   SER A 273       6.036   7.114 -12.959  1.00 24.94           N  
ATOM   2304  CA  SER A 273       5.044   6.656 -12.030  1.00 24.95           C  
ATOM   2305  C   SER A 273       5.465   5.225 -11.709  1.00 25.04           C  
ATOM   2306  O   SER A 273       5.404   4.353 -12.572  1.00 25.56           O  
ATOM   2307  CB  SER A 273       3.653   6.731 -12.668  1.00 26.08           C  
ATOM   2308  OG  SER A 273       2.693   6.220 -11.767  1.00 29.40           O  
ATOM   2309  N   LEU A 274       5.931   4.996 -10.486  1.00 23.42           N  
ATOM   2310  CA  LEU A 274       6.562   3.734 -10.126  1.00 24.06           C  
ATOM   2311  C   LEU A 274       5.497   2.766  -9.680  1.00 24.23           C  
ATOM   2312  O   LEU A 274       4.446   3.187  -9.229  1.00 24.31           O  
ATOM   2313  CB  LEU A 274       7.558   3.952  -8.982  1.00 23.55           C  
ATOM   2314  CG  LEU A 274       8.722   4.908  -9.297  1.00 24.08           C  
ATOM   2315  CD1 LEU A 274       9.552   5.055  -8.076  1.00 22.26           C  
ATOM   2316  CD2 LEU A 274       9.561   4.357 -10.464  1.00 23.95           C  
ATOM   2317  N   ASP A 275       5.772   1.478  -9.804  1.00 25.28           N  
ATOM   2318  CA  ASP A 275       4.862   0.438  -9.304  1.00 26.62           C  
ATOM   2319  C   ASP A 275       4.808   0.533  -7.787  1.00 25.91           C  
ATOM   2320  O   ASP A 275       5.814   0.891  -7.167  1.00 25.44           O  
ATOM   2321  CB  ASP A 275       5.400  -0.936  -9.679  1.00 27.15           C  
ATOM   2322  CG  ASP A 275       5.385  -1.188 -11.166  1.00 31.67           C  
ATOM   2323  OD1 ASP A 275       4.683  -0.463 -11.932  1.00 35.42           O  
ATOM   2324  OD2 ASP A 275       6.069  -2.151 -11.564  1.00 37.16           O  
ATOM   2325  N   SER A 276       3.661   0.183  -7.201  1.00 25.38           N  
ATOM   2326  CA  SER A 276       3.430   0.367  -5.767  0.50 25.32           C  
ATOM   2328  C   SER A 276       4.470  -0.320  -4.867  1.00 25.07           C  
ATOM   2329  O   SER A 276       4.760   0.171  -3.768  1.00 24.34           O  
ATOM   2330  CB  SER A 276       2.012  -0.067  -5.378  0.50 25.96           C  
ATOM   2332  OG  SER A 276       1.053   0.894  -5.789  0.50 26.96           O  
ATOM   2334  N   ASN A 277       5.047  -1.432  -5.331  1.00 24.67           N  
ATOM   2335  CA  ASN A 277       6.037  -2.162  -4.529  1.00 25.13           C  
ATOM   2336  C   ASN A 277       7.497  -1.753  -4.839  1.00 24.68           C  
ATOM   2337  O   ASN A 277       8.455  -2.405  -4.379  1.00 25.06           O  
ATOM   2338  CB  ASN A 277       5.864  -3.667  -4.703  1.00 26.16           C  
ATOM   2339  CG  ASN A 277       6.095  -4.102  -6.127  1.00 28.87           C  
ATOM   2340  OD1 ASN A 277       6.524  -3.302  -6.972  1.00 30.73           O  
ATOM   2341  ND2 ASN A 277       5.784  -5.365  -6.424  1.00 32.44           N  
ATOM   2342  N   ASP A 278       7.673  -0.672  -5.597  1.00 23.03           N  
ATOM   2343  CA  ASP A 278       9.027  -0.223  -5.945  1.00 22.37           C  
ATOM   2344  C   ASP A 278       9.821   0.209  -4.680  1.00 21.26           C  
ATOM   2345  O   ASP A 278       9.330   0.972  -3.848  1.00 19.95           O  
ATOM   2346  CB  ASP A 278       8.939   0.919  -6.954  1.00 23.08           C  
ATOM   2347  CG  ASP A 278      10.260   1.171  -7.667  1.00 24.57           C  
ATOM   2348  OD1 ASP A 278      11.315   1.281  -7.008  1.00 24.32           O  
ATOM   2349  OD2 ASP A 278      10.232   1.263  -8.898  1.00 29.43           O  
ATOM   2350  N   TYR A 279      11.047  -0.281  -4.551  1.00 19.70           N  
ATOM   2351  CA  TYR A 279      11.859   0.056  -3.391  1.00 19.80           C  
ATOM   2352  C   TYR A 279      11.991   1.586  -3.263  1.00 19.53           C  
ATOM   2353  O   TYR A 279      11.976   2.144  -2.159  1.00 17.91           O  
ATOM   2354  CB  TYR A 279      13.234  -0.597  -3.529  1.00 20.85           C  
ATOM   2355  CG  TYR A 279      14.266   0.005  -2.661  1.00 20.48           C  
ATOM   2356  CD1 TYR A 279      14.325  -0.271  -1.284  1.00 19.50           C  
ATOM   2357  CD2 TYR A 279      15.188   0.887  -3.210  1.00 23.64           C  
ATOM   2358  CE1 TYR A 279      15.290   0.335  -0.504  1.00 21.58           C  
ATOM   2359  CE2 TYR A 279      16.134   1.462  -2.460  1.00 19.78           C  
ATOM   2360  CZ  TYR A 279      16.187   1.195  -1.140  1.00 21.34           C  
ATOM   2361  OH  TYR A 279      17.198   1.804  -0.491  1.00 25.49           O  
ATOM   2362  N   LEU A 280      12.105   2.275  -4.398  1.00 18.24           N  
ATOM   2363  CA  LEU A 280      12.329   3.741  -4.317  1.00 19.02           C  
ATOM   2364  C   LEU A 280      11.155   4.476  -3.688  1.00 18.85           C  
ATOM   2365  O   LEU A 280      11.318   5.565  -3.151  1.00 19.34           O  
ATOM   2366  CB  LEU A 280      12.678   4.334  -5.688  1.00 18.64           C  
ATOM   2367  CG  LEU A 280      14.017   3.816  -6.260  1.00 19.61           C  
ATOM   2368  CD1 LEU A 280      14.343   4.482  -7.606  1.00 18.99           C  
ATOM   2369  CD2 LEU A 280      15.197   4.030  -5.263  1.00 17.73           C  
ATOM   2370  N   LEU A 281       9.967   3.887  -3.765  1.00 19.88           N  
ATOM   2371  CA  LEU A 281       8.783   4.489  -3.138  1.00 21.77           C  
ATOM   2372  C   LEU A 281       8.818   4.378  -1.627  1.00 21.54           C  
ATOM   2373  O   LEU A 281       8.045   5.053  -0.946  1.00 24.50           O  
ATOM   2374  CB  LEU A 281       7.472   3.866  -3.696  1.00 20.56           C  
ATOM   2375  CG  LEU A 281       7.097   4.240  -5.129  1.00 20.78           C  
ATOM   2376  CD1 LEU A 281       5.728   3.586  -5.521  1.00 20.96           C  
ATOM   2377  CD2 LEU A 281       7.047   5.762  -5.346  1.00 21.70           C  
ATOM   2378  N   THR A 282       9.710   3.562  -1.080  1.00 20.85           N  
ATOM   2379  CA  THR A 282       9.731   3.400   0.365  1.00 21.42           C  
ATOM   2380  C   THR A 282      10.555   4.525   1.014  1.00 20.95           C  
ATOM   2381  O   THR A 282      10.628   4.589   2.219  1.00 21.08           O  
ATOM   2382  CB  THR A 282      10.354   2.054   0.782  1.00 21.56           C  
ATOM   2383  OG1 THR A 282      11.741   2.069   0.421  1.00 21.46           O  
ATOM   2384  CG2 THR A 282       9.661   0.859   0.109  1.00 22.99           C  
ATOM   2385  N   LEU A 283      11.215   5.377   0.229  1.00 19.24           N  
ATOM   2386  CA  LEU A 283      12.148   6.361   0.802  1.00 19.65           C  
ATOM   2387  C   LEU A 283      11.392   7.621   1.205  1.00 19.91           C  
ATOM   2388  O   LEU A 283      10.558   8.103   0.438  1.00 20.37           O  
ATOM   2389  CB  LEU A 283      13.289   6.672  -0.186  1.00 19.23           C  
ATOM   2390  CG  LEU A 283      14.043   5.457  -0.771  1.00 19.73           C  
ATOM   2391  CD1 LEU A 283      15.064   5.910  -1.820  1.00 21.33           C  
ATOM   2392  CD2 LEU A 283      14.756   4.691   0.374  1.00 19.79           C  
ATOM   2393  N   GLY A 284      11.679   8.121   2.413  1.00 19.73           N  
ATOM   2394  CA  GLY A 284      11.080   9.337   2.973  1.00 18.59           C  
ATOM   2395  C   GLY A 284      11.545  10.530   2.168  1.00 18.39           C  
ATOM   2396  O   GLY A 284      12.486  10.423   1.388  1.00 17.26           O  
ATOM   2397  N   LYS A 285      10.901  11.681   2.348  1.00 18.07           N  
ATOM   2398  CA  LYS A 285      11.260  12.858   1.550  1.00 18.46           C  
ATOM   2399  C   LYS A 285      12.665  13.373   1.838  1.00 17.80           C  
ATOM   2400  O   LYS A 285      13.214  14.174   1.060  1.00 17.89           O  
ATOM   2401  CB  LYS A 285      10.280  14.017   1.789  1.00 19.25           C  
ATOM   2402  CG  LYS A 285       8.928  13.785   1.159  1.00 22.31           C  
ATOM   2403  CD  LYS A 285       8.135  15.094   1.211  1.00 29.92           C  
ATOM   2404  CE  LYS A 285       6.737  14.844   1.704  1.00 37.25           C  
ATOM   2405  NZ  LYS A 285       6.727  14.772   3.208  1.00 39.90           N  
ATOM   2406  N   GLY A 286      13.237  12.940   2.951  1.00 17.12           N  
ATOM   2407  CA  GLY A 286      14.595  13.375   3.271  1.00 16.91           C  
ATOM   2408  C   GLY A 286      15.654  12.319   3.033  1.00 16.33           C  
ATOM   2409  O   GLY A 286      16.821  12.492   3.460  1.00 16.58           O  
ATOM   2410  N   SER A 287      15.259  11.239   2.361  1.00 15.21           N  
ATOM   2411  CA  SER A 287      16.107  10.062   2.220  1.00 15.69           C  
ATOM   2412  C   SER A 287      16.619   9.897   0.782  1.00 15.40           C  
ATOM   2413  O   SER A 287      15.812   9.903  -0.173  1.00 16.30           O  
ATOM   2414  CB  SER A 287      15.335   8.820   2.686  1.00 15.32           C  
ATOM   2415  OG  SER A 287      15.999   7.607   2.301  1.00 19.04           O  
ATOM   2416  N   LEU A 288      17.935   9.747   0.648  1.00 13.59           N  
ATOM   2417  CA  LEU A 288      18.575   9.378  -0.608  1.00 11.88           C  
ATOM   2418  C   LEU A 288      18.733   7.864  -0.641  1.00 12.05           C  
ATOM   2419  O   LEU A 288      19.020   7.236   0.372  1.00 11.41           O  
ATOM   2420  CB  LEU A 288      19.995  10.031  -0.714  1.00 12.59           C  
ATOM   2421  CG  LEU A 288      20.042  11.573  -0.700  1.00 13.90           C  
ATOM   2422  CD1 LEU A 288      21.419  12.039  -0.247  1.00 16.19           C  
ATOM   2423  CD2 LEU A 288      19.797  12.092  -2.082  1.00 15.06           C  
ATOM   2424  N   GLY A 289      18.584   7.252  -1.803  1.00 10.90           N  
ATOM   2425  CA  GLY A 289      18.754   5.793  -1.852  1.00 11.01           C  
ATOM   2426  C   GLY A 289      18.783   5.334  -3.281  1.00 10.92           C  
ATOM   2427  O   GLY A 289      18.350   6.086  -4.196  1.00 11.01           O  
ATOM   2428  N   TYR A 290      19.237   4.102  -3.487  1.00 10.02           N  
ATOM   2429  CA  TYR A 290      19.356   3.608  -4.826  1.00  9.88           C  
ATOM   2430  C   TYR A 290      19.307   2.093  -4.829  1.00 10.75           C  
ATOM   2431  O   TYR A 290      19.472   1.440  -3.788  1.00 10.61           O  
ATOM   2432  CB  TYR A 290      20.641   4.088  -5.460  1.00 10.31           C  
ATOM   2433  CG  TYR A 290      21.923   3.639  -4.754  1.00 10.96           C  
ATOM   2434  CD1 TYR A 290      22.509   2.424  -5.076  1.00 10.92           C  
ATOM   2435  CD2 TYR A 290      22.564   4.468  -3.825  1.00 11.62           C  
ATOM   2436  CE1 TYR A 290      23.730   1.996  -4.442  1.00 10.15           C  
ATOM   2437  CE2 TYR A 290      23.771   4.094  -3.207  1.00  9.19           C  
ATOM   2438  CZ  TYR A 290      24.338   2.832  -3.520  1.00 12.20           C  
ATOM   2439  OH  TYR A 290      25.505   2.368  -2.941  1.00 11.13           O  
ATOM   2440  N   GLN A 291      19.059   1.567  -6.016  1.00 10.36           N  
ATOM   2441  CA  GLN A 291      19.114   0.160  -6.256  0.50 11.91           C  
ATOM   2443  C   GLN A 291      20.243  -0.055  -7.255  1.00 11.93           C  
ATOM   2444  O   GLN A 291      20.258   0.577  -8.331  1.00 11.87           O  
ATOM   2445  CB  GLN A 291      17.805  -0.305  -6.875  0.50 12.45           C  
ATOM   2447  CG  GLN A 291      16.670  -0.497  -5.896  0.50 14.18           C  
ATOM   2449  CD  GLN A 291      15.738  -1.603  -6.390  0.50 16.60           C  
ATOM   2451  OE1 GLN A 291      15.483  -1.709  -7.595  0.50 22.21           O  
ATOM   2453  NE2 GLN A 291      15.279  -2.449  -5.488  0.50 14.10           N  
ATOM   2455  N   LEU A 292      21.153  -0.948  -6.916  1.00 13.21           N  
ATOM   2456  CA  LEU A 292      22.282  -1.257  -7.789  1.00 13.23           C  
ATOM   2457  C   LEU A 292      22.150  -2.692  -8.282  1.00 13.57           C  
ATOM   2458  O   LEU A 292      22.253  -3.651  -7.502  1.00 13.25           O  
ATOM   2459  CB  LEU A 292      23.576  -1.086  -6.986  1.00 13.72           C  
ATOM   2460  CG  LEU A 292      24.867  -1.022  -7.790  1.00 16.06           C  
ATOM   2461  CD1 LEU A 292      24.934   0.312  -8.662  1.00 14.29           C  
ATOM   2462  CD2 LEU A 292      26.094  -1.103  -6.826  1.00 15.53           C  
ATOM   2463  N   GLN A 293      21.931  -2.867  -9.580  1.00 13.61           N  
ATOM   2464  CA  GLN A 293      21.753  -4.204 -10.100  1.00 14.91           C  
ATOM   2465  C   GLN A 293      23.106  -4.685 -10.652  1.00 15.29           C  
ATOM   2466  O   GLN A 293      23.682  -4.051 -11.569  1.00 17.00           O  
ATOM   2467  CB  GLN A 293      20.712  -4.076 -11.199  1.00 16.44           C  
ATOM   2468  CG  GLN A 293      20.067  -5.301 -11.668  1.00 20.74           C  
ATOM   2469  CD  GLN A 293      19.174  -4.956 -12.844  1.00 26.59           C  
ATOM   2470  OE1 GLN A 293      19.659  -4.878 -13.966  1.00 30.80           O  
ATOM   2471  NE2 GLN A 293      17.911  -4.628 -12.581  1.00 29.50           N  
ATOM   2472  N   THR A 294      23.634  -5.782 -10.134  1.00 15.29           N  
ATOM   2473  CA  THR A 294      25.003  -6.217 -10.528  1.00 14.20           C  
ATOM   2474  C   THR A 294      24.956  -7.657 -11.032  1.00 16.14           C  
ATOM   2475  O   THR A 294      24.036  -8.407 -10.681  1.00 15.48           O  
ATOM   2476  CB  THR A 294      25.996  -6.148  -9.348  1.00 14.69           C  
ATOM   2477  OG1 THR A 294      25.756  -7.239  -8.454  1.00 14.21           O  
ATOM   2478  CG2 THR A 294      25.863  -4.795  -8.529  1.00 14.74           C  
ATOM   2479  N   ASP A 295      25.938  -8.045 -11.847  1.00 16.10           N  
ATOM   2480  CA  ASP A 295      25.897  -9.377 -12.441  1.00 17.04           C  
ATOM   2481  C   ASP A 295      26.518 -10.445 -11.570  1.00 17.57           C  
ATOM   2482  O   ASP A 295      26.306 -11.632 -11.848  1.00 16.95           O  
ATOM   2483  CB  ASP A 295      26.497  -9.413 -13.859  1.00 17.36           C  
ATOM   2484  CG  ASP A 295      27.975  -9.025 -13.908  1.00 21.48           C  
ATOM   2485  OD1 ASP A 295      28.581  -8.773 -12.856  1.00 22.67           O  
ATOM   2486  OD2 ASP A 295      28.548  -8.947 -15.022  1.00 25.55           O  
ATOM   2487  N   THR A 296      27.230 -10.040 -10.505  1.00 16.48           N  
ATOM   2488  CA  THR A 296      27.955 -11.008  -9.643  1.00 16.11           C  
ATOM   2489  C   THR A 296      27.642 -10.846  -8.143  1.00 15.64           C  
ATOM   2490  O   THR A 296      27.926 -11.720  -7.300  1.00 16.24           O  
ATOM   2491  CB  THR A 296      29.479 -10.899  -9.925  1.00 16.29           C  
ATOM   2492  OG1 THR A 296      29.685 -10.965 -11.340  1.00 17.33           O  
ATOM   2493  CG2 THR A 296      30.236 -12.087  -9.302  1.00 17.79           C  
ATOM   2494  N   ASN A 297      27.064  -9.710  -7.788  1.00 14.68           N  
ATOM   2495  CA  ASN A 297      26.790  -9.438  -6.357  1.00 13.07           C  
ATOM   2496  C   ASN A 297      25.312  -9.154  -6.092  1.00 13.35           C  
ATOM   2497  O   ASN A 297      24.958  -8.517  -5.091  1.00 13.84           O  
ATOM   2498  CB  ASN A 297      27.644  -8.257  -5.886  1.00 13.95           C  
ATOM   2499  CG  ASN A 297      29.109  -8.602  -5.912  1.00 14.78           C  
ATOM   2500  OD1 ASN A 297      29.610  -9.327  -5.028  1.00 15.16           O  
ATOM   2501  ND2 ASN A 297      29.789  -8.165  -6.955  1.00 10.43           N  
ATOM   2502  N   GLY A 298      24.464  -9.596  -7.008  1.00 12.96           N  
ATOM   2503  CA  GLY A 298      23.005  -9.472  -6.878  1.00 14.28           C  
ATOM   2504  C   GLY A 298      22.492  -8.047  -7.046  1.00 13.71           C  
ATOM   2505  O   GLY A 298      23.187  -7.173  -7.577  1.00 14.62           O  
ATOM   2506  N   THR A 299      21.249  -7.820  -6.613  1.00 13.56           N  
ATOM   2507  CA  THR A 299      20.654  -6.475  -6.664  1.00 14.61           C  
ATOM   2508  C   THR A 299      20.644  -5.953  -5.238  1.00 14.96           C  
ATOM   2509  O   THR A 299      20.102  -6.619  -4.329  1.00 15.50           O  
ATOM   2510  CB  THR A 299      19.220  -6.533  -7.228  1.00 15.54           C  
ATOM   2511  OG1 THR A 299      19.286  -7.009  -8.586  1.00 17.83           O  
ATOM   2512  CG2 THR A 299      18.518  -5.145  -7.209  1.00 15.67           C  
ATOM   2513  N   LEU A 300      21.265  -4.800  -5.043  1.00 14.15           N  
ATOM   2514  CA  LEU A 300      21.486  -4.251  -3.706  1.00 13.31           C  
ATOM   2515  C   LEU A 300      20.757  -2.941  -3.550  1.00 13.51           C  
ATOM   2516  O   LEU A 300      20.805  -2.096  -4.460  1.00 15.13           O  
ATOM   2517  CB  LEU A 300      22.970  -4.044  -3.464  1.00 13.72           C  
ATOM   2518  CG  LEU A 300      23.695  -5.387  -3.594  1.00 14.55           C  
ATOM   2519  CD1 LEU A 300      25.123  -5.242  -3.971  1.00 16.73           C  
ATOM   2520  CD2 LEU A 300      23.456  -6.211  -2.300  1.00 13.63           C  
ATOM   2521  N   ASN A 301      20.111  -2.769  -2.395  1.00 12.84           N  
ATOM   2522  CA  ASN A 301      19.381  -1.538  -2.067  1.00 12.97           C  
ATOM   2523  C   ASN A 301      20.111  -0.835  -0.949  1.00 11.87           C  
ATOM   2524  O   ASN A 301      20.388  -1.453   0.068  1.00 12.73           O  
ATOM   2525  CB  ASN A 301      18.009  -1.896  -1.504  1.00 14.08           C  
ATOM   2526  CG  ASN A 301      17.099  -2.591  -2.510  1.00 16.86           C  
ATOM   2527  OD1 ASN A 301      17.217  -2.419  -3.712  1.00 16.95           O  
ATOM   2528  ND2 ASN A 301      16.132  -3.352  -1.987  1.00 20.25           N  
ATOM   2529  N   VAL A 302      20.473   0.439  -1.134  1.00 11.50           N  
ATOM   2530  CA  VAL A 302      21.245   1.173  -0.145  1.00 11.09           C  
ATOM   2531  C   VAL A 302      20.599   2.538   0.038  1.00 11.76           C  
ATOM   2532  O   VAL A 302      20.312   3.235  -0.956  1.00  9.41           O  
ATOM   2533  CB  VAL A 302      22.711   1.360  -0.665  1.00 11.76           C  
ATOM   2534  CG1 VAL A 302      23.603   2.068   0.404  1.00 12.67           C  
ATOM   2535  CG2 VAL A 302      23.299  -0.044  -1.040  1.00 12.96           C  
ATOM   2536  N   SER A 303      20.405   2.962   1.290  1.00 11.52           N  
ATOM   2537  CA  SER A 303      19.824   4.311   1.506  1.00 13.65           C  
ATOM   2538  C   SER A 303      20.231   4.807   2.875  1.00 13.24           C  
ATOM   2539  O   SER A 303      20.704   4.034   3.675  1.00 11.77           O  
ATOM   2540  CB  SER A 303      18.301   4.276   1.449  1.00 14.72           C  
ATOM   2541  OG  SER A 303      17.756   3.589   2.572  1.00 19.10           O  
ATOM   2542  N   ASP A 304      20.017   6.095   3.140  1.00 14.15           N  
ATOM   2543  CA  ASP A 304      20.120   6.598   4.503  1.00 13.80           C  
ATOM   2544  C   ASP A 304      18.708   6.923   5.006  1.00 14.97           C  
ATOM   2545  O   ASP A 304      17.695   6.665   4.329  1.00 16.37           O  
ATOM   2546  CB  ASP A 304      21.017   7.857   4.560  1.00 12.99           C  
ATOM   2547  CG  ASP A 304      20.472   9.038   3.687  1.00 16.57           C  
ATOM   2548  OD1 ASP A 304      19.312   8.998   3.207  1.00 19.18           O  
ATOM   2549  OD2 ASP A 304      21.205  10.057   3.523  1.00 19.55           O  
ATOM   2550  N   LEU A 305      18.626   7.441   6.216  1.00 15.45           N  
ATOM   2551  CA  LEU A 305      17.331   7.854   6.735  1.00 17.19           C  
ATOM   2552  C   LEU A 305      17.112   9.339   6.479  1.00 17.29           C  
ATOM   2553  O   LEU A 305      16.052   9.742   6.038  1.00 17.12           O  
ATOM   2554  CB  LEU A 305      17.250   7.542   8.237  1.00 16.99           C  
ATOM   2555  CG  LEU A 305      17.138   6.052   8.585  1.00 20.12           C  
ATOM   2556  CD1 LEU A 305      16.917   5.815  10.075  1.00 17.57           C  
ATOM   2557  CD2 LEU A 305      16.019   5.404   7.785  1.00 21.90           C  
ATOM   2558  N   TYR A 306      18.119  10.143   6.756  1.00 17.35           N  
ATOM   2559  CA  TYR A 306      18.018  11.567   6.487  1.00 19.60           C  
ATOM   2560  C   TYR A 306      19.342  12.108   5.922  1.00 20.53           C  
ATOM   2561  O   TYR A 306      20.409  11.865   6.472  1.00 22.05           O  
ATOM   2562  CB  TYR A 306      17.606  12.326   7.760  1.00 21.46           C  
ATOM   2563  CG  TYR A 306      16.263  11.880   8.274  1.00 21.57           C  
ATOM   2564  CD1 TYR A 306      15.079  12.419   7.751  1.00 24.26           C  
ATOM   2565  CD2 TYR A 306      16.172  10.905   9.257  1.00 21.51           C  
ATOM   2566  CE1 TYR A 306      13.845  12.000   8.206  1.00 25.61           C  
ATOM   2567  CE2 TYR A 306      14.936  10.471   9.728  1.00 22.74           C  
ATOM   2568  CZ  TYR A 306      13.780  11.024   9.198  1.00 26.41           C  
ATOM   2569  OH  TYR A 306      12.549  10.593   9.671  1.00 27.44           O  
ATOM   2570  N   ASP A 307      19.262  12.799   4.794  1.00 19.79           N  
ATOM   2571  CA  ASP A 307      20.418  13.396   4.166  1.00 19.54           C  
ATOM   2572  C   ASP A 307      20.721  14.677   4.906  1.00 17.56           C  
ATOM   2573  O   ASP A 307      19.792  15.401   5.345  1.00 17.88           O  
ATOM   2574  CB  ASP A 307      20.090  13.709   2.684  1.00 20.64           C  
ATOM   2575  CG  ASP A 307      21.200  14.516   1.963  1.00 26.04           C  
ATOM   2576  OD1 ASP A 307      22.402  14.180   2.108  1.00 27.33           O  
ATOM   2577  OD2 ASP A 307      20.854  15.479   1.212  1.00 28.92           O  
ATOM   2578  N   GLY A 308      22.000  14.985   5.059  1.00 15.02           N  
ATOM   2579  CA  GLY A 308      22.345  16.285   5.653  1.00 14.44           C  
ATOM   2580  C   GLY A 308      23.822  16.545   5.474  1.00 14.06           C  
ATOM   2581  O   GLY A 308      24.584  15.616   5.125  1.00 13.16           O  
ATOM   2582  N   PRO A 309      24.236  17.797   5.714  1.00 14.16           N  
ATOM   2583  CA  PRO A 309      25.611  18.200   5.481  1.00 13.57           C  
ATOM   2584  C   PRO A 309      26.614  17.494   6.367  1.00 13.13           C  
ATOM   2585  O   PRO A 309      27.770  17.330   5.959  1.00 13.27           O  
ATOM   2586  CB  PRO A 309      25.604  19.728   5.758  1.00 14.06           C  
ATOM   2587  CG  PRO A 309      24.352  20.016   6.455  1.00 15.91           C  
ATOM   2588  CD  PRO A 309      23.366  18.927   6.118  1.00 14.39           C  
ATOM   2589  N   TYR A 310      26.210  17.107   7.569  1.00 12.76           N  
ATOM   2590  CA  TYR A 310      27.168  16.424   8.431  1.00 14.37           C  
ATOM   2591  C   TYR A 310      27.535  15.041   7.854  1.00 14.18           C  
ATOM   2592  O   TYR A 310      28.726  14.689   7.776  1.00 13.00           O  
ATOM   2593  CB  TYR A 310      26.597  16.276   9.845  1.00 16.34           C  
ATOM   2594  CG  TYR A 310      27.527  15.533  10.779  1.00 18.25           C  
ATOM   2595  CD1 TYR A 310      28.546  16.191  11.475  1.00 20.51           C  
ATOM   2596  CD2 TYR A 310      27.337  14.175  10.997  1.00 21.88           C  
ATOM   2597  CE1 TYR A 310      29.388  15.469  12.354  1.00 22.17           C  
ATOM   2598  CE2 TYR A 310      28.143  13.469  11.837  1.00 24.06           C  
ATOM   2599  CZ  TYR A 310      29.175  14.098  12.485  1.00 20.59           C  
ATOM   2600  OH  TYR A 310      29.914  13.293  13.316  1.00 24.33           O  
ATOM   2601  N   GLU A 311      26.525  14.279   7.429  1.00 13.17           N  
ATOM   2602  CA  GLU A 311      26.774  12.959   6.807  1.00 14.04           C  
ATOM   2603  C   GLU A 311      27.474  13.097   5.463  1.00 12.99           C  
ATOM   2604  O   GLU A 311      28.277  12.243   5.077  1.00 12.84           O  
ATOM   2605  CB  GLU A 311      25.453  12.185   6.651  1.00 14.68           C  
ATOM   2606  CG  GLU A 311      24.755  11.925   8.007  1.00 22.03           C  
ATOM   2607  CD  GLU A 311      24.047  13.155   8.648  1.00 32.37           C  
ATOM   2608  OE1 GLU A 311      23.799  14.225   8.015  1.00 32.25           O  
ATOM   2609  OE2 GLU A 311      23.724  13.039   9.852  1.00 41.01           O  
ATOM   2610  N   THR A 312      27.167  14.180   4.745  1.00 12.59           N  
ATOM   2611  CA  THR A 312      27.904  14.512   3.507  1.00 11.87           C  
ATOM   2612  C   THR A 312      29.401  14.752   3.783  1.00 11.34           C  
ATOM   2613  O   THR A 312      30.272  14.258   3.054  1.00 10.45           O  
ATOM   2614  CB  THR A 312      27.225  15.683   2.751  1.00 11.88           C  
ATOM   2615  OG1 THR A 312      25.911  15.240   2.357  1.00 13.30           O  
ATOM   2616  CG2 THR A 312      27.993  16.063   1.464  1.00 12.80           C  
ATOM   2617  N   ALA A 313      29.703  15.531   4.807  1.00 11.36           N  
ATOM   2618  CA  ALA A 313      31.084  15.744   5.203  1.00 11.55           C  
ATOM   2619  C   ALA A 313      31.708  14.410   5.658  1.00 12.34           C  
ATOM   2620  O   ALA A 313      32.898  14.175   5.430  1.00 11.97           O  
ATOM   2621  CB  ALA A 313      31.163  16.814   6.297  1.00 11.24           C  
ATOM   2622  N   GLY A 314      30.920  13.544   6.292  1.00 12.45           N  
ATOM   2623  CA  GLY A 314      31.379  12.166   6.580  1.00 11.75           C  
ATOM   2624  C   GLY A 314      31.802  11.390   5.313  1.00 12.64           C  
ATOM   2625  O   GLY A 314      32.764  10.602   5.363  1.00 12.68           O  
ATOM   2626  N   ALA A 315      31.097  11.543   4.201  1.00 11.87           N  
ATOM   2627  CA  ALA A 315      31.546  10.946   2.922  1.00 12.65           C  
ATOM   2628  C   ALA A 315      32.885  11.531   2.431  1.00 12.32           C  
ATOM   2629  O   ALA A 315      33.751  10.835   1.866  1.00 12.73           O  
ATOM   2630  CB  ALA A 315      30.490  11.158   1.846  1.00 12.45           C  
ATOM   2631  N   VAL A 316      33.029  12.839   2.580  1.00 12.80           N  
ATOM   2632  CA  VAL A 316      34.328  13.496   2.232  1.00 12.47           C  
ATOM   2633  C   VAL A 316      35.409  12.862   3.078  1.00 11.39           C  
ATOM   2634  O   VAL A 316      36.481  12.520   2.558  1.00 12.66           O  
ATOM   2635  CB  VAL A 316      34.289  15.007   2.518  1.00 12.25           C  
ATOM   2636  CG1 VAL A 316      35.673  15.679   2.238  1.00 13.10           C  
ATOM   2637  CG2 VAL A 316      33.258  15.640   1.618  1.00 14.02           C  
HETATM 2638  N   MSE A 317      35.130  12.708   4.383  1.00 10.70           N  
HETATM 2639  CA  MSE A 317      36.123  12.143   5.296  1.00 11.86           C  
HETATM 2640  C   MSE A 317      36.466  10.686   4.900  1.00 11.89           C  
HETATM 2641  O   MSE A 317      37.625  10.275   4.941  1.00 11.86           O  
HETATM 2642  CB  MSE A 317      35.605  12.191   6.730  1.00 12.85           C  
HETATM 2643  CG  MSE A 317      36.641  11.791   7.764  1.00 14.56           C  
HETATM 2644 SE   MSE A 317      38.016  13.178   7.955  0.50 13.20          SE  
HETATM 2645  CE  MSE A 317      39.251  12.114   8.899  1.00 21.28           C  
ATOM   2646  N   ASN A 318      35.454   9.906   4.534  1.00 11.37           N  
ATOM   2647  CA  ASN A 318      35.738   8.558   4.022  1.00 10.72           C  
ATOM   2648  C   ASN A 318      36.701   8.576   2.830  1.00  9.35           C  
ATOM   2649  O   ASN A 318      37.653   7.798   2.805  1.00  9.90           O  
ATOM   2650  CB  ASN A 318      34.452   7.796   3.692  1.00 11.50           C  
ATOM   2651  CG  ASN A 318      34.709   6.299   3.579  1.00 11.34           C  
ATOM   2652  OD1 ASN A 318      34.918   5.594   4.578  1.00 12.16           O  
ATOM   2653  ND2 ASN A 318      34.736   5.810   2.341  1.00  7.77           N  
ATOM   2654  N   ASP A 319      36.474   9.457   1.850  1.00 11.29           N  
ATOM   2655  CA  ASP A 319      37.411   9.604   0.729  1.00 10.55           C  
ATOM   2656  C   ASP A 319      38.826   9.941   1.197  1.00 10.34           C  
ATOM   2657  O   ASP A 319      39.817   9.449   0.636  1.00 11.13           O  
ATOM   2658  CB  ASP A 319      36.970  10.725  -0.236  1.00 10.24           C  
ATOM   2659  CG  ASP A 319      35.922  10.250  -1.240  1.00 14.54           C  
ATOM   2660  OD1 ASP A 319      35.780   8.997  -1.443  1.00 13.39           O  
ATOM   2661  OD2 ASP A 319      35.288  11.139  -1.862  1.00 15.00           O  
ATOM   2662  N   LEU A 320      38.933  10.862   2.137  1.00 11.43           N  
ATOM   2663  CA  LEU A 320      40.264  11.214   2.697  1.00 11.55           C  
ATOM   2664  C   LEU A 320      40.974  10.006   3.309  1.00 11.56           C  
ATOM   2665  O   LEU A 320      42.171   9.790   3.060  1.00 11.03           O  
ATOM   2666  CB  LEU A 320      40.139  12.314   3.738  1.00 11.44           C  
ATOM   2667  CG  LEU A 320      39.717  13.675   3.194  1.00 13.24           C  
ATOM   2668  CD1 LEU A 320      39.399  14.663   4.318  1.00 13.83           C  
ATOM   2669  CD2 LEU A 320      40.879  14.247   2.348  1.00 15.73           C  
ATOM   2670  N   VAL A 321      40.238   9.195   4.068  1.00 10.82           N  
ATOM   2671  CA  VAL A 321      40.849   7.986   4.639  1.00 10.69           C  
ATOM   2672  C   VAL A 321      41.289   7.002   3.535  1.00 10.38           C  
ATOM   2673  O   VAL A 321      42.408   6.433   3.578  1.00 10.96           O  
ATOM   2674  CB  VAL A 321      39.926   7.329   5.681  1.00 10.10           C  
ATOM   2675  CG1 VAL A 321      40.556   6.058   6.242  1.00  8.95           C  
ATOM   2676  CG2 VAL A 321      39.684   8.355   6.869  1.00  8.95           C  
ATOM   2677  N   ILE A 322      40.405   6.775   2.560  1.00 11.51           N  
ATOM   2678  CA  ILE A 322      40.757   5.878   1.438  1.00 11.85           C  
ATOM   2679  C   ILE A 322      42.047   6.340   0.780  1.00 11.26           C  
ATOM   2680  O   ILE A 322      42.951   5.517   0.513  1.00 11.84           O  
ATOM   2681  CB  ILE A 322      39.616   5.838   0.348  1.00 12.52           C  
ATOM   2682  CG1 ILE A 322      38.414   5.068   0.901  1.00 12.00           C  
ATOM   2683  CG2 ILE A 322      40.150   5.174  -0.991  1.00 12.02           C  
ATOM   2684  CD1 ILE A 322      37.139   5.224   0.095  1.00 14.70           C  
ATOM   2685  N   LEU A 323      42.151   7.644   0.493  1.00 11.74           N  
ATOM   2686  CA  LEU A 323      43.354   8.148  -0.197  1.00 13.55           C  
ATOM   2687  C   LEU A 323      44.600   8.013   0.671  1.00 15.00           C  
ATOM   2688  O   LEU A 323      45.709   7.831   0.154  1.00 14.78           O  
ATOM   2689  CB  LEU A 323      43.184   9.617  -0.664  1.00 13.48           C  
ATOM   2690  CG  LEU A 323      42.275   9.891  -1.872  1.00 12.29           C  
ATOM   2691  CD1 LEU A 323      42.262  11.403  -2.123  1.00 16.69           C  
ATOM   2692  CD2 LEU A 323      42.785   9.178  -3.144  1.00 16.47           C  
ATOM   2693  N   SER A 324      44.412   8.053   1.989  1.00 15.10           N  
ATOM   2694  CA  SER A 324      45.553   8.047   2.906  1.00 16.22           C  
ATOM   2695  C   SER A 324      46.032   6.663   3.232  1.00 17.46           C  
ATOM   2696  O   SER A 324      47.199   6.463   3.572  1.00 17.44           O  
ATOM   2697  CB  SER A 324      45.194   8.780   4.183  1.00 16.34           C  
ATOM   2698  OG  SER A 324      44.883  10.121   3.833  1.00 18.72           O  
HETATM 2699  N   MSE A 325      45.142   5.693   3.146  1.00 18.48           N  
HETATM 2700  CA  MSE A 325      45.371   4.323   3.598  0.60 19.31           C  
HETATM 2702  C   MSE A 325      45.411   3.362   2.407  1.00 20.43           C  
HETATM 2703  O   MSE A 325      46.187   2.402   2.382  1.00 21.73           O  
HETATM 2704  CB  MSE A 325      44.232   3.920   4.548  0.60 19.20           C  
HETATM 2706  CG  MSE A 325      43.581   2.613   4.176  0.60 20.15           C  
HETATM 2708 SE   MSE A 325      41.629   2.558   3.983  0.30 18.36          SE  
HETATM 2710  CE  MSE A 325      41.637   1.883   2.156  0.60 17.59           C  
TER    2712      MSE A 325                                                      
END
MOLECULE T0452.pdb
ATOM      1  N   MET     1      52.780  12.131   9.830  1.00 64.27           N  
ATOM      2  CA  MET     1      51.866  13.329   9.884  1.00 62.83           C  
ATOM      3  C   MET     1      51.173  13.643   8.544  1.00 60.55           C  
ATOM      4  O   MET     1      51.817  14.126   7.602  1.00 57.92           O  
ATOM      5  CB  MET     1      52.673  14.551  10.319  1.00 66.08           C  
ATOM      6  CG  MET     1      51.875  15.808  10.723  1.00 68.81           C  
ATOM      7  SD  MET     1      50.702  15.464  12.236  0.75 84.58          SE  
ATOM      8  CE  MET     1      51.122  17.040  13.324  1.00 62.48           C  
ATOM      9  N   ILE     2      49.865  13.365   8.474  1.00 58.05           N  
ATOM     10  CA  ILE     2      49.049  13.668   7.280  1.00 58.01           C  
ATOM     11  C   ILE     2      48.619  15.140   7.290  1.00 55.65           C  
ATOM     12  O   ILE     2      47.911  15.582   8.206  1.00 53.04           O  
ATOM     13  CB  ILE     2      47.760  12.805   7.198  1.00 58.03           C  
ATOM     14  CG1 ILE     2      48.102  11.309   7.195  1.00 54.77           C  
ATOM     15  CG2 ILE     2      46.954  13.201   5.952  1.00 57.20           C  
ATOM     16  CD1 ILE     2      46.907  10.395   7.282  1.00 57.93           C  
ATOM     17  N   LYS     3      49.008  15.877   6.251  1.00 55.60           N  
ATOM     18  CA  LYS     3      48.740  17.321   6.172  1.00 56.35           C  
ATOM     19  C   LYS     3      47.600  17.604   5.221  1.00 55.84           C  
ATOM     20  O   LYS     3      47.654  17.245   4.049  1.00 55.14           O  
ATOM     21  CB  LYS     3      50.035  18.069   5.816  1.00 57.38           C  
ATOM     22  CG  LYS     3      51.033  17.984   6.990  1.00 58.52           C  
ATOM     23  CD  LYS     3      52.475  17.739   6.602  1.00 60.97           C  
ATOM     24  CE  LYS     3      53.207  18.959   6.163  1.00 63.65           C  
ATOM     25  NZ  LYS     3      54.708  18.695   6.249  1.00 66.08           N  
ATOM     26  N   ILE     4      46.562  18.239   5.765  1.00 53.56           N  
ATOM     27  CA  ILE     4      45.340  18.514   5.056  1.00 53.76           C  
ATOM     28  C   ILE     4      45.113  20.003   4.818  1.00 53.93           C  
ATOM     29  O   ILE     4      45.241  20.810   5.741  1.00 53.51           O  
ATOM     30  CB  ILE     4      44.105  18.015   5.905  1.00 55.30           C  
ATOM     31  CG1 ILE     4      44.159  16.496   6.186  1.00 55.04           C  
ATOM     32  CG2 ILE     4      42.821  18.376   5.214  1.00 50.36           C  
ATOM     33  CD1 ILE     4      43.204  16.037   7.255  1.00 53.20           C  
ATOM     34  N   ALA     5      44.778  20.365   3.584  1.00 52.17           N  
ATOM     35  CA  ALA     5      44.327  21.720   3.286  1.00 51.01           C  
ATOM     36  C   ALA     5      42.835  21.602   3.012  1.00 50.72           C  
ATOM     37  O   ALA     5      42.402  20.614   2.424  1.00 50.92           O  
ATOM     38  CB  ALA     5      45.041  22.295   2.077  1.00 51.38           C  
ATOM     39  N   ILE     6      42.053  22.567   3.502  1.00 49.77           N  
ATOM     40  CA  ILE     6      40.637  22.647   3.226  1.00 47.38           C  
ATOM     41  C   ILE     6      40.416  23.919   2.411  1.00 48.11           C  
ATOM     42  O   ILE     6      40.780  24.992   2.841  1.00 47.01           O  
ATOM     43  CB  ILE     6      39.782  22.717   4.472  1.00 47.03           C  
ATOM     44  CG1 ILE     6      39.970  21.496   5.353  1.00 51.49           C  
ATOM     45  CG2 ILE     6      38.311  22.816   4.072  1.00 46.79           C  
ATOM     46  CD1 ILE     6      39.234  21.618   6.720  1.00 41.91           C  
ATOM     47  N   VAL     7      39.830  23.789   1.228  1.00 47.88           N  
ATOM     48  CA  VAL     7      39.543  24.920   0.368  1.00 47.35           C  
ATOM     49  C   VAL     7      38.056  24.961   0.193  1.00 49.39           C  
ATOM     50  O   VAL     7      37.452  24.018  -0.300  1.00 50.39           O  
ATOM     51  CB  VAL     7      40.252  24.813  -0.981  1.00 49.31           C  
ATOM     52  CG1 VAL     7      39.610  25.733  -1.959  1.00 53.41           C  
ATOM     53  CG2 VAL     7      41.722  25.158  -0.807  1.00 43.12           C  
ATOM     54  N   GLY     8      37.456  26.063   0.593  1.00 50.03           N  
ATOM     55  CA  GLY     8      36.004  26.154   0.599  1.00 50.42           C  
ATOM     56  C   GLY     8      35.642  26.000   2.054  1.00 47.71           C  
ATOM     57  O   GLY     8      35.959  24.985   2.672  1.00 47.68           O  
ATOM     58  N   PHE     9      35.050  27.038   2.614  1.00 45.40           N  
ATOM     59  CA  PHE     9      34.735  27.048   4.020  1.00 44.91           C  
ATOM     60  C   PHE     9      33.347  27.619   4.296  1.00 44.43           C  
ATOM     61  O   PHE     9      33.143  28.367   5.264  1.00 44.10           O  
ATOM     62  CB  PHE     9      35.832  27.773   4.797  1.00 44.89           C  
ATOM     63  CG  PHE     9      36.080  27.213   6.187  1.00 46.74           C  
ATOM     64  CD1 PHE     9      36.321  25.852   6.367  1.00 45.28           C  
ATOM     65  CD2 PHE     9      36.171  28.053   7.293  1.00 44.41           C  
ATOM     66  CE1 PHE     9      36.605  25.329   7.622  1.00 46.75           C  
ATOM     67  CE2 PHE     9      36.465  27.547   8.553  1.00 40.55           C  
ATOM     68  CZ  PHE     9      36.696  26.169   8.720  1.00 40.87           C  
ATOM     69  N   GLY    10      32.401  27.246   3.429  1.00 43.72           N  
ATOM     70  CA  GLY    10      30.998  27.527   3.667  1.00 44.66           C  
ATOM     71  C   GLY    10      30.510  26.334   4.482  1.00 48.29           C  
ATOM     72  O   GLY    10      31.269  25.749   5.241  1.00 49.37           O  
ATOM     73  N   THR    11      29.254  25.953   4.292  1.00 50.86           N  
ATOM     74  CA  THR    11      28.627  24.852   5.019  1.00 51.81           C  
ATOM     75  C   THR    11      29.371  23.522   5.011  1.00 49.50           C  
ATOM     76  O   THR    11      29.564  22.923   6.059  1.00 51.59           O  
ATOM     77  CB  THR    11      27.191  24.637   4.490  1.00 53.76           C  
ATOM     78  OG1 THR    11      26.379  25.748   4.915  1.00 53.97           O  
ATOM     79  CG2 THR    11      26.590  23.379   5.041  1.00 57.42           C  
ATOM     80  N   VAL    12      29.827  23.082   3.851  1.00 46.51           N  
ATOM     81  CA  VAL    12      30.500  21.800   3.752  1.00 47.29           C  
ATOM     82  C   VAL    12      31.869  21.826   4.436  1.00 50.52           C  
ATOM     83  O   VAL    12      32.173  20.965   5.268  1.00 51.91           O  
ATOM     84  CB  VAL    12      30.693  21.382   2.287  1.00 49.55           C  
ATOM     85  CG1 VAL    12      31.536  20.094   2.183  1.00 40.83           C  
ATOM     86  CG2 VAL    12      29.302  21.256   1.548  1.00 42.52           C  
ATOM     87  N   GLY    13      32.683  22.820   4.075  1.00 49.44           N  
ATOM     88  CA  GLY    13      34.035  22.947   4.600  1.00 46.72           C  
ATOM     89  C   GLY    13      34.013  23.103   6.086  1.00 44.10           C  
ATOM     90  O   GLY    13      34.875  22.570   6.754  1.00 46.40           O  
ATOM     91  N   GLN    14      33.056  23.861   6.614  1.00 45.08           N  
ATOM     92  CA  GLN    14      32.964  24.028   8.061  1.00 46.74           C  
ATOM     93  C   GLN    14      32.542  22.687   8.684  1.00 47.58           C  
ATOM     94  O   GLN    14      33.015  22.328   9.756  1.00 51.45           O  
ATOM     95  CB  GLN    14      32.006  25.147   8.437  1.00 46.08           C  
ATOM     96  CG  GLN    14      32.486  26.525   8.017  1.00 47.44           C  
ATOM     97  CD  GLN    14      31.468  27.593   8.266  1.00 46.95           C  
ATOM     98  OE1 GLN    14      30.745  27.562   9.275  1.00 51.27           O  
ATOM     99  NE2 GLN    14      31.409  28.578   7.358  1.00 42.84           N  
ATOM    100  N   GLY    15      31.663  21.962   7.995  1.00 47.70           N  
ATOM    101  CA  GLY    15      31.237  20.600   8.388  1.00 46.12           C  
ATOM    102  C   GLY    15      32.400  19.637   8.510  1.00 46.71           C  
ATOM    103  O   GLY    15      32.479  18.855   9.460  1.00 49.04           O  
ATOM    104  N   VAL    16      33.327  19.707   7.564  1.00 46.53           N  
ATOM    105  CA  VAL    16      34.524  18.879   7.594  1.00 45.65           C  
ATOM    106  C   VAL    16      35.404  19.222   8.804  1.00 48.76           C  
ATOM    107  O   VAL    16      35.902  18.321   9.483  1.00 52.31           O  
ATOM    108  CB  VAL    16      35.329  19.006   6.247  1.00 47.14           C  
ATOM    109  CG1 VAL    16      36.711  18.302   6.347  1.00 42.27           C  
ATOM    110  CG2 VAL    16      34.473  18.477   5.045  1.00 42.69           C  
ATOM    111  N   ALA    17      35.568  20.510   9.108  1.00 45.69           N  
ATOM    112  CA  ALA    17      36.354  20.909  10.251  1.00 45.90           C  
ATOM    113  C   ALA    17      35.674  20.444  11.546  1.00 46.43           C  
ATOM    114  O   ALA    17      36.327  19.942  12.456  1.00 45.17           O  
ATOM    115  CB  ALA    17      36.590  22.427  10.243  1.00 43.86           C  
ATOM    116  N   GLU    18      34.365  20.612  11.648  1.00 47.89           N  
ATOM    117  CA  GLU    18      33.655  20.172  12.850  1.00 51.23           C  
ATOM    118  C   GLU    18      33.869  18.667  13.098  1.00 52.35           C  
ATOM    119  O   GLU    18      34.136  18.234  14.223  1.00 50.83           O  
ATOM    120  CB  GLU    18      32.166  20.422  12.710  1.00 48.26           C  
ATOM    121  CG  GLU    18      31.747  21.852  12.867  1.00 56.31           C  
ATOM    122  CD  GLU    18      30.335  22.104  12.327  1.00 60.70           C  
ATOM    123  OE1 GLU    18      29.628  21.141  11.892  1.00 72.28           O  
ATOM    124  OE2 GLU    18      29.938  23.278  12.321  1.00 67.63           O  
ATOM    125  N   LEU    19      33.766  17.883  12.030  1.00 52.89           N  
ATOM    126  CA  LEU    19      33.887  16.439  12.139  1.00 54.26           C  
ATOM    127  C   LEU    19      35.334  16.029  12.471  1.00 53.09           C  
ATOM    128  O   LEU    19      35.555  15.184  13.342  1.00 53.03           O  
ATOM    129  CB  LEU    19      33.392  15.798  10.846  1.00 55.45           C  
ATOM    130  CG  LEU    19      32.420  14.642  11.012  1.00 63.13           C  
ATOM    131  CD1 LEU    19      31.289  15.037  12.018  1.00 59.21           C  
ATOM    132  CD2 LEU    19      31.879  14.292   9.621  1.00 58.38           C  
ATOM    133  N   LEU    20      36.310  16.628  11.791  1.00 51.90           N  
ATOM    134  CA  LEU    20      37.719  16.374  12.075  1.00 51.88           C  
ATOM    135  C   LEU    20      38.049  16.642  13.536  1.00 53.28           C  
ATOM    136  O   LEU    20      38.901  15.943  14.115  1.00 51.85           O  
ATOM    137  CB  LEU    20      38.645  17.239  11.219  1.00 51.14           C  
ATOM    138  CG  LEU    20      38.829  16.884   9.745  1.00 53.15           C  
ATOM    139  CD1 LEU    20      39.788  17.894   9.182  1.00 43.05           C  
ATOM    140  CD2 LEU    20      39.342  15.459   9.496  1.00 48.98           C  
ATOM    141  N   ILE    21      37.402  17.666  14.118  1.00 54.64           N  
ATOM    142  CA  ILE    21      37.587  18.017  15.536  1.00 54.55           C  
ATOM    143  C   ILE    21      36.880  16.988  16.421  1.00 56.62           C  
ATOM    144  O   ILE    21      37.502  16.361  17.271  1.00 56.43           O  
ATOM    145  CB  ILE    21      37.038  19.436  15.877  1.00 55.74           C  
ATOM    146  CG1 ILE    21      37.904  20.531  15.229  1.00 53.49           C  
ATOM    147  CG2 ILE    21      37.002  19.660  17.408  1.00 51.22           C  
ATOM    148  CD1 ILE    21      37.263  21.896  15.245  1.00 51.16           C  
ATOM    149  N   ARG    22      35.578  16.846  16.215  1.00 57.54           N  
ATOM    150  CA  ARG    22      34.734  15.925  16.976  1.00 59.75           C  
ATOM    151  C   ARG    22      35.217  14.442  16.971  1.00 58.99           C  
ATOM    152  O   ARG    22      35.242  13.781  18.020  1.00 56.93           O  
ATOM    153  CB  ARG    22      33.289  16.101  16.478  1.00 59.84           C  
ATOM    154  CG  ARG    22      32.304  14.970  16.713  1.00 65.23           C  
ATOM    155  CD  ARG    22      30.893  15.451  16.313  1.00 66.81           C  
ATOM    156  NE  ARG    22      29.973  14.389  15.896  1.00 72.65           N  
ATOM    157  CZ  ARG    22      29.467  13.450  16.697  1.00 78.63           C  
ATOM    158  NH1 ARG    22      29.832  13.374  17.981  1.00 85.78           N  
ATOM    159  NH2 ARG    22      28.620  12.546  16.206  1.00 74.42           N  
ATOM    160  N   LYS    23      35.620  13.938  15.807  1.00 59.10           N  
ATOM    161  CA  LYS    23      36.115  12.562  15.660  1.00 58.67           C  
ATOM    162  C   LYS    23      37.656  12.477  15.597  1.00 56.52           C  
ATOM    163  O   LYS    23      38.190  11.561  15.005  1.00 57.54           O  
ATOM    164  CB  LYS    23      35.542  11.946  14.373  1.00 59.36           C  
ATOM    165  CG  LYS    23      33.995  11.816  14.279  1.00 61.86           C  
ATOM    166  CD  LYS    23      33.474  10.645  15.084  1.00 67.73           C  
ATOM    167  CE  LYS    23      32.043  10.279  14.717  1.00 68.93           C  
ATOM    168  NZ  LYS    23      31.620   9.080  15.497  1.00 69.41           N  
ATOM    169  N   ARG    24      38.382  13.392  16.215  1.00 56.81           N  
ATOM    170  CA  ARG    24      39.857  13.360  16.122  1.00 58.96           C  
ATOM    171  C   ARG    24      40.510  12.061  16.670  1.00 60.92           C  
ATOM    172  O   ARG    24      41.434  11.509  16.045  1.00 57.97           O  
ATOM    173  CB  ARG    24      40.481  14.576  16.825  1.00 58.10           C  
ATOM    174  CG  ARG    24      42.014  14.698  16.650  1.00 59.47           C  
ATOM    175  CD  ARG    24      42.603  15.885  17.417  1.00 56.47           C  
ATOM    176  N   GLU    25      40.052  11.584  17.831  1.00 62.93           N  
ATOM    177  CA  GLU    25      40.651  10.379  18.429  1.00 63.11           C  
ATOM    178  C   GLU    25      40.434   9.182  17.486  1.00 62.24           C  
ATOM    179  O   GLU    25      41.389   8.502  17.107  1.00 62.51           O  
ATOM    180  CB  GLU    25      40.136  10.106  19.865  1.00 63.51           C  
ATOM    181  CG  GLU    25      41.118   9.248  20.728  1.00 65.66           C  
ATOM    182  CD  GLU    25      40.757   9.175  22.216  1.00 63.61           C  
ATOM    183  N   GLU    26      39.200   8.966  17.055  1.00 61.11           N  
ATOM    184  CA  GLU    26      38.902   7.833  16.165  1.00 61.23           C  
ATOM    185  C   GLU    26      39.605   7.940  14.799  1.00 60.58           C  
ATOM    186  O   GLU    26      40.126   6.939  14.291  1.00 63.12           O  
ATOM    187  CB  GLU    26      37.391   7.521  16.058  1.00 60.40           C  
ATOM    188  CG  GLU    26      36.428   8.692  16.135  1.00 65.99           C  
ATOM    189  CD  GLU    26      36.232   9.259  17.550  1.00 69.89           C  
ATOM    190  OE1 GLU    26      37.204   9.779  18.145  1.00 73.11           O  
ATOM    191  OE2 GLU    26      35.086   9.227  18.053  1.00 74.67           O  
ATOM    192  N   ILE    27      39.670   9.140  14.232  1.00 57.22           N  
ATOM    193  CA  ILE    27      40.368   9.316  12.960  1.00 55.95           C  
ATOM    194  C   ILE    27      41.849   8.995  13.113  1.00 57.56           C  
ATOM    195  O   ILE    27      42.430   8.329  12.268  1.00 56.95           O  
ATOM    196  CB  ILE    27      40.261  10.769  12.399  1.00 55.02           C  
ATOM    197  CG1 ILE    27      38.821  11.132  12.039  1.00 49.34           C  
ATOM    198  CG2 ILE    27      41.133  10.922  11.165  1.00 50.75           C  
ATOM    199  CD1 ILE    27      38.624  12.577  11.770  1.00 52.22           C  
ATOM    200  N   GLU    28      42.465   9.479  14.184  1.00 61.32           N  
ATOM    201  CA  GLU    28      43.903   9.271  14.373  1.00 64.28           C  
ATOM    202  C   GLU    28      44.266   7.807  14.654  1.00 64.22           C  
ATOM    203  O   GLU    28      45.319   7.331  14.211  1.00 62.93           O  
ATOM    204  CB  GLU    28      44.489  10.218  15.439  1.00 64.78           C  
ATOM    205  CG  GLU    28      44.654  11.679  14.954  1.00 68.38           C  
ATOM    206  CD  GLU    28      45.433  12.572  15.939  1.00 68.30           C  
ATOM    207  OE1 GLU    28      45.742  12.102  17.058  1.00 70.55           O  
ATOM    208  OE2 GLU    28      45.730  13.744  15.587  1.00 73.13           O  
ATOM    209  N   LYS    29      43.405   7.086  15.367  1.00 64.63           N  
ATOM    210  CA  LYS    29      43.688   5.674  15.625  1.00 66.71           C  
ATOM    211  C   LYS    29      43.320   4.792  14.440  1.00 64.27           C  
ATOM    212  O   LYS    29      43.488   3.590  14.516  1.00 66.43           O  
ATOM    213  CB  LYS    29      43.073   5.170  16.949  1.00 68.44           C  
ATOM    214  CG  LYS    29      41.549   5.216  17.117  1.00 71.38           C  
ATOM    215  CD  LYS    29      41.198   5.127  18.641  1.00 71.88           C  
ATOM    216  CE  LYS    29      39.729   5.491  18.956  1.00 76.70           C  
ATOM    217  NZ  LYS    29      39.490   5.736  20.420  1.00 78.05           N  
ATOM    218  N   ALA    30      42.842   5.401  13.350  1.00 62.35           N  
ATOM    219  CA  ALA    30      42.498   4.704  12.117  1.00 59.58           C  
ATOM    220  C   ALA    30      43.511   4.999  10.990  1.00 59.19           C  
ATOM    221  O   ALA    30      43.926   4.084  10.282  1.00 58.82           O  
ATOM    222  CB  ALA    30      41.104   5.089  11.679  1.00 58.95           C  
ATOM    223  N   ILE    31      43.905   6.264  10.824  1.00 58.50           N  
ATOM    224  CA  ILE    31      44.836   6.662   9.747  1.00 58.25           C  
ATOM    225  C   ILE    31      46.124   7.324  10.230  1.00 56.93           C  
ATOM    226  O   ILE    31      46.986   7.654   9.415  1.00 56.58           O  
ATOM    227  CB  ILE    31      44.148   7.616   8.698  1.00 60.03           C  
ATOM    228  CG1 ILE    31      43.729   8.952   9.327  1.00 63.44           C  
ATOM    229  CG2 ILE    31      42.920   6.948   8.083  1.00 59.44           C  
ATOM    230  CD1 ILE    31      43.310  10.005   8.313  1.00 57.81           C  
ATOM    231  N   GLY    32      46.265   7.504  11.544  1.00 56.22           N  
ATOM    232  CA  GLY    32      47.450   8.154  12.123  1.00 56.26           C  
ATOM    233  C   GLY    32      47.259   9.639  12.384  1.00 56.15           C  
ATOM    234  O   GLY    32      46.173  10.193  12.194  1.00 54.12           O  
ATOM    235  N   GLU    33      48.332  10.296  12.799  1.00 57.20           N  
ATOM    236  CA  GLU    33      48.274  11.730  13.117  1.00 57.41           C  
ATOM    237  C   GLU    33      47.980  12.615  11.898  1.00 56.42           C  
ATOM    238  O   GLU    33      48.489  12.381  10.791  1.00 55.32           O  
ATOM    239  CB  GLU    33      49.571  12.202  13.797  1.00 54.88           C  
ATOM    240  N   PHE    34      47.153  13.635  12.122  1.00 56.05           N  
ATOM    241  CA  PHE    34      46.853  14.621  11.082  1.00 55.66           C  
ATOM    242  C   PHE    34      46.741  16.029  11.657  1.00 54.59           C  
ATOM    243  O   PHE    34      46.352  16.223  12.810  1.00 52.19           O  
ATOM    244  CB  PHE    34      45.539  14.293  10.356  1.00 53.22           C  
ATOM    245  CG  PHE    34      44.307  14.535  11.191  1.00 51.30           C  
ATOM    246  CD1 PHE    34      43.696  15.778  11.207  1.00 52.89           C  
ATOM    247  CD2 PHE    34      43.764  13.525  11.972  1.00 52.61           C  
ATOM    248  CE1 PHE    34      42.561  16.004  11.992  1.00 56.64           C  
ATOM    249  CE2 PHE    34      42.622  13.754  12.749  1.00 52.83           C  
ATOM    250  CZ  PHE    34      42.030  14.997  12.759  1.00 49.58           C  
ATOM    251  N   LYS    35      47.048  16.999  10.806  1.00 55.52           N  
ATOM    252  CA  LYS    35      46.903  18.402  11.119  1.00 55.01           C  
ATOM    253  C   LYS    35      46.397  19.124   9.852  1.00 53.92           C  
ATOM    254  O   LYS    35      46.825  18.822   8.738  1.00 52.95           O  
ATOM    255  CB  LYS    35      48.248  18.998  11.581  1.00 55.35           C  
ATOM    256  N   VAL    36      45.463  20.052  10.021  1.00 53.85           N  
ATOM    257  CA  VAL    36      45.023  20.896   8.912  1.00 51.19           C  
ATOM    258  C   VAL    36      46.012  22.068   8.889  1.00 50.76           C  
ATOM    259  O   VAL    36      46.081  22.869   9.825  1.00 51.72           O  
ATOM    260  CB  VAL    36      43.595  21.377   9.116  1.00 51.26           C  
ATOM    261  CG1 VAL    36      43.214  22.449   8.086  1.00 50.58           C  
ATOM    262  CG2 VAL    36      42.643  20.177   9.107  1.00 51.69           C  
ATOM    263  N   THR    37      46.798  22.142   7.825  1.00 49.63           N  
ATOM    264  CA  THR    37      47.828  23.154   7.685  1.00 48.79           C  
ATOM    265  C   THR    37      47.379  24.424   6.954  1.00 49.33           C  
ATOM    266  O   THR    37      48.097  25.425   6.971  1.00 48.55           O  
ATOM    267  CB  THR    37      49.039  22.547   6.963  1.00 51.11           C  
ATOM    268  OG1 THR    37      48.633  22.053   5.675  1.00 49.84           O  
ATOM    269  CG2 THR    37      49.661  21.384   7.816  1.00 47.18           C  
ATOM    270  N   ALA    38      46.211  24.385   6.303  1.00 48.85           N  
ATOM    271  CA  ALA    38      45.661  25.561   5.615  1.00 48.33           C  
ATOM    272  C   ALA    38      44.151  25.472   5.443  1.00 47.20           C  
ATOM    273  O   ALA    38      43.596  24.393   5.295  1.00 47.14           O  
ATOM    274  CB  ALA    38      46.319  25.748   4.256  1.00 48.10           C  
ATOM    275  N   VAL    39      43.474  26.614   5.516  1.00 46.50           N  
ATOM    276  CA  VAL    39      42.029  26.679   5.235  1.00 41.88           C  
ATOM    277  C   VAL    39      41.837  27.944   4.433  1.00 42.19           C  
ATOM    278  O   VAL    39      42.487  28.952   4.705  1.00 42.21           O  
ATOM    279  CB  VAL    39      41.134  26.697   6.499  1.00 41.10           C  
ATOM    280  CG1 VAL    39      39.640  26.750   6.099  1.00 34.79           C  
ATOM    281  CG2 VAL    39      41.379  25.436   7.334  1.00 37.90           C  
ATOM    282  N   ALA    40      40.965  27.891   3.438  1.00 42.83           N  
ATOM    283  CA  ALA    40      40.698  29.054   2.605  1.00 43.95           C  
ATOM    284  C   ALA    40      39.229  29.118   2.235  1.00 44.80           C  
ATOM    285  O   ALA    40      38.595  28.097   2.022  1.00 45.76           O  
ATOM    286  CB  ALA    40      41.583  29.062   1.350  1.00 41.09           C  
ATOM    287  N   ASP    41      38.678  30.332   2.260  1.00 47.12           N  
ATOM    288  CA  ASP    41      37.309  30.548   1.849  1.00 48.13           C  
ATOM    289  C   ASP    41      37.362  31.268   0.495  1.00 48.80           C  
ATOM    290  O   ASP    41      38.365  31.177  -0.211  1.00 46.41           O  
ATOM    291  CB  ASP    41      36.437  31.219   2.935  1.00 47.62           C  
ATOM    292  CG  ASP    41      36.796  32.655   3.226  1.00 49.98           C  
ATOM    293  OD1 ASP    41      37.592  33.291   2.504  1.00 58.19           O  
ATOM    294  OD2 ASP    41      36.230  33.163   4.208  1.00 51.58           O  
ATOM    295  N   SER    42      36.302  31.967   0.120  1.00 49.95           N  
ATOM    296  CA  SER    42      36.264  32.567  -1.204  1.00 52.64           C  
ATOM    297  C   SER    42      37.116  33.819  -1.333  1.00 52.63           C  
ATOM    298  O   SER    42      37.251  34.311  -2.423  1.00 55.48           O  
ATOM    299  CB  SER    42      34.820  32.904  -1.582  1.00 52.96           C  
ATOM    300  OG  SER    42      34.336  34.013  -0.823  1.00 58.23           O  
ATOM    301  N   LYS    43      37.665  34.347  -0.241  1.00 51.92           N  
ATOM    302  CA  LYS    43      38.480  35.552  -0.305  1.00 52.93           C  
ATOM    303  C   LYS    43      39.599  35.700   0.718  1.00 47.85           C  
ATOM    304  O   LYS    43      40.298  36.685   0.689  1.00 45.16           O  
ATOM    305  CB  LYS    43      37.585  36.781  -0.203  1.00 55.82           C  
ATOM    306  CG  LYS    43      36.657  36.790   0.999  1.00 60.82           C  
ATOM    307  CD  LYS    43      35.892  38.100   1.051  1.00 61.10           C  
ATOM    308  CE  LYS    43      34.742  38.052   2.059  1.00 71.03           C  
ATOM    309  NZ  LYS    43      34.194  39.422   2.317  1.00 69.35           N  
ATOM    310  N   SER    44      39.796  34.718   1.583  1.00 47.19           N  
ATOM    311  CA  SER    44      40.817  34.796   2.632  1.00 44.50           C  
ATOM    312  C   SER    44      41.304  33.408   3.011  1.00 43.16           C  
ATOM    313  O   SER    44      40.816  32.381   2.497  1.00 43.03           O  
ATOM    314  CB  SER    44      40.216  35.482   3.859  1.00 43.90           C  
ATOM    315  OG  SER    44      39.006  34.830   4.247  1.00 40.74           O  
ATOM    316  N   SER    45      42.257  33.361   3.929  1.00 43.34           N  
ATOM    317  CA  SER    45      42.822  32.086   4.339  1.00 44.16           C  
ATOM    318  C   SER    45      43.499  32.135   5.691  1.00 43.92           C  
ATOM    319  O   SER    45      43.653  33.190   6.280  1.00 45.20           O  
ATOM    320  CB  SER    45      43.819  31.603   3.276  1.00 43.89           C  
ATOM    321  OG  SER    45      44.824  32.582   3.070  1.00 44.61           O  
ATOM    322  N   ILE    46      43.822  30.958   6.207  1.00 44.82           N  
ATOM    323  CA  ILE    46      44.567  30.829   7.448  1.00 45.74           C  
ATOM    324  C   ILE    46      45.498  29.626   7.232  1.00 48.74           C  
ATOM    325  O   ILE    46      45.074  28.574   6.760  1.00 48.63           O  
ATOM    326  CB  ILE    46      43.651  30.702   8.698  1.00 45.65           C  
ATOM    327  CG1 ILE    46      44.485  30.784   9.991  1.00 46.96           C  
ATOM    328  CG2 ILE    46      42.820  29.444   8.634  1.00 39.08           C  
ATOM    329  CD1 ILE    46      43.657  30.960  11.292  1.00 44.17           C  
ATOM    330  N   SER    47      46.772  29.825   7.533  1.00 51.76           N  
ATOM    331  CA  SER    47      47.810  28.828   7.336  1.00 55.63           C  
ATOM    332  C   SER    47      48.871  28.999   8.418  1.00 59.36           C  
ATOM    333  O   SER    47      48.792  29.920   9.232  1.00 59.41           O  
ATOM    334  CB  SER    47      48.405  28.970   5.934  1.00 55.81           C  
ATOM    335  OG  SER    47      48.695  30.327   5.660  1.00 60.76           O  
ATOM    336  N   GLY    48      49.858  28.113   8.438  1.00 62.08           N  
ATOM    337  CA  GLY    48      50.859  28.117   9.496  1.00 64.35           C  
ATOM    338  C   GLY    48      50.278  27.283  10.621  1.00 66.48           C  
ATOM    339  O   GLY    48      49.457  26.385  10.379  1.00 68.53           O  
ATOM    340  N   ASP    49      50.707  27.547  11.849  1.00 69.50           N  
ATOM    341  CA  ASP    49      50.151  26.823  12.986  1.00 69.13           C  
ATOM    342  C   ASP    49      48.987  27.680  13.482  1.00 66.46           C  
ATOM    343  O   ASP    49      49.128  28.880  13.721  1.00 64.46           O  
ATOM    344  CB  ASP    49      51.192  26.564  14.094  1.00 71.09           C  
ATOM    345  CG  ASP    49      50.708  25.533  15.149  1.00 73.05           C  
ATOM    346  OD1 ASP    49      49.573  25.006  15.036  1.00 77.90           O  
ATOM    347  OD2 ASP    49      51.474  25.243  16.099  1.00 84.77           O  
ATOM    348  N   PHE    50      47.829  27.042  13.569  1.00 63.84           N  
ATOM    349  CA  PHE    50      46.599  27.667  14.005  1.00 61.11           C  
ATOM    350  C   PHE    50      45.774  26.477  14.406  1.00 61.21           C  
ATOM    351  O   PHE    50      46.136  25.360  14.054  1.00 65.03           O  
ATOM    352  CB  PHE    50      45.944  28.441  12.845  1.00 60.61           C  
ATOM    353  CG  PHE    50      45.450  27.562  11.718  1.00 56.00           C  
ATOM    354  CD1 PHE    50      46.296  27.183  10.687  1.00 57.36           C  
ATOM    355  CD2 PHE    50      44.134  27.104  11.698  1.00 60.04           C  
ATOM    356  CE1 PHE    50      45.838  26.367   9.652  1.00 54.45           C  
ATOM    357  CE2 PHE    50      43.683  26.282  10.679  1.00 53.05           C  
ATOM    358  CZ  PHE    50      44.542  25.922   9.658  1.00 54.95           C  
ATOM    359  N   SER    51      44.685  26.657  15.137  1.00 61.52           N  
ATOM    360  CA  SER    51      43.842  25.505  15.454  1.00 61.50           C  
ATOM    361  C   SER    51      42.601  25.509  14.543  1.00 62.12           C  
ATOM    362  O   SER    51      42.165  26.569  14.080  1.00 62.67           O  
ATOM    363  CB  SER    51      43.459  25.482  16.943  1.00 61.95           C  
ATOM    364  OG  SER    51      42.527  26.486  17.308  1.00 60.44           O  
ATOM    365  N   LEU    52      42.052  24.331  14.263  1.00 60.09           N  
ATOM    366  CA  LEU    52      40.833  24.252  13.472  1.00 60.05           C  
ATOM    367  C   LEU    52      39.696  24.966  14.153  1.00 59.93           C  
ATOM    368  O   LEU    52      38.865  25.578  13.482  1.00 60.87           O  
ATOM    369  CB  LEU    52      40.377  22.809  13.213  1.00 61.30           C  
ATOM    370  CG  LEU    52      40.904  22.097  11.981  1.00 58.66           C  
ATOM    371  CD1 LEU    52      40.284  20.695  11.921  1.00 53.94           C  
ATOM    372  CD2 LEU    52      40.584  22.906  10.726  1.00 52.52           C  
ATOM    373  N   VAL    53      39.638  24.874  15.475  1.00 58.86           N  
ATOM    374  CA  VAL    53      38.578  25.528  16.212  1.00 59.32           C  
ATOM    375  C   VAL    53      38.797  27.061  16.134  1.00 59.34           C  
ATOM    376  O   VAL    53      37.839  27.826  16.222  1.00 58.98           O  
ATOM    377  CB  VAL    53      38.498  25.009  17.680  1.00 60.99           C  
ATOM    378  CG1 VAL    53      39.747  25.416  18.481  1.00 59.44           C  
ATOM    379  CG2 VAL    53      37.251  25.532  18.356  1.00 63.08           C  
ATOM    380  N   GLU    54      40.053  27.491  15.970  1.00 58.08           N  
ATOM    381  CA  GLU    54      40.382  28.916  15.783  1.00 58.11           C  
ATOM    382  C   GLU    54      39.791  29.372  14.453  1.00 54.78           C  
ATOM    383  O   GLU    54      39.060  30.351  14.393  1.00 51.96           O  
ATOM    384  CB  GLU    54      41.911  29.142  15.808  1.00 57.95           C  
ATOM    385  CG  GLU    54      42.433  30.512  15.286  1.00 60.54           C  
ATOM    386  CD  GLU    54      43.974  30.637  15.312  1.00 63.57           C  
ATOM    387  OE1 GLU    54      44.645  29.639  15.675  1.00 69.48           O  
ATOM    388  OE2 GLU    54      44.511  31.734  14.978  1.00 64.98           O  
ATOM    389  N   ALA    55      40.106  28.628  13.397  1.00 52.28           N  
ATOM    390  CA  ALA    55      39.628  28.928  12.057  1.00 50.48           C  
ATOM    391  C   ALA    55      38.105  29.014  12.006  1.00 50.08           C  
ATOM    392  O   ALA    55      37.523  29.899  11.369  1.00 48.20           O  
ATOM    393  CB  ALA    55      40.128  27.854  11.084  1.00 47.73           C  
ATOM    394  N   LEU    56      37.479  28.089  12.715  1.00 50.68           N  
ATOM    395  CA  LEU    56      36.040  27.925  12.734  1.00 48.42           C  
ATOM    396  C   LEU    56      35.405  29.084  13.485  1.00 48.89           C  
ATOM    397  O   LEU    56      34.422  29.675  13.027  1.00 49.34           O  
ATOM    398  CB  LEU    56      35.749  26.567  13.386  1.00 49.56           C  
ATOM    399  CG  LEU    56      34.499  25.721  13.144  1.00 52.04           C  
ATOM    400  CD1 LEU    56      34.203  25.561  11.685  1.00 38.31           C  
ATOM    401  CD2 LEU    56      34.698  24.344  13.791  1.00 47.26           C  
ATOM    402  N   ARG    57      35.973  29.419  14.637  1.00 46.37           N  
ATOM    403  CA  ARG    57      35.474  30.521  15.430  1.00 48.89           C  
ATOM    404  C   ARG    57      35.549  31.828  14.619  1.00 46.79           C  
ATOM    405  O   ARG    57      34.608  32.605  14.544  1.00 46.32           O  
ATOM    406  CB  ARG    57      36.298  30.654  16.742  1.00 51.31           C  
ATOM    407  CG  ARG    57      36.110  29.490  17.783  1.00 56.80           C  
ATOM    408  CD  ARG    57      37.030  29.595  19.028  1.00 49.52           C  
ATOM    409  N   MET    58      36.694  32.040  14.000  1.00 45.43           N  
ATOM    410  CA  MET    58      36.952  33.231  13.205  1.00 47.00           C  
ATOM    411  C   MET    58      35.968  33.370  12.026  1.00 44.58           C  
ATOM    412  O   MET    58      35.461  34.448  11.784  1.00 44.79           O  
ATOM    413  CB  MET    58      38.398  33.160  12.703  1.00 46.90           C  
ATOM    414  CG  MET    58      38.910  34.397  12.064  1.00 47.83           C  
ATOM    415  SD  MET    58      40.713  34.060  11.481  0.75 49.26          SE  
ATOM    416  CE  MET    58      41.667  34.170  13.280  1.00 37.49           C  
ATOM    417  N   LYS    59      35.692  32.285  11.313  1.00 45.02           N  
ATOM    418  CA  LYS    59      34.772  32.318  10.170  1.00 44.70           C  
ATOM    419  C   LYS    59      33.356  32.681  10.611  1.00 48.20           C  
ATOM    420  O   LYS    59      32.692  33.542  10.016  1.00 49.01           O  
ATOM    421  CB  LYS    59      34.811  30.975   9.455  1.00 43.78           C  
ATOM    422  CG  LYS    59      33.941  30.862   8.201  1.00 46.14           C  
ATOM    423  CD  LYS    59      34.236  31.951   7.144  1.00 42.99           C  
ATOM    424  CE  LYS    59      33.424  31.659   5.852  1.00 41.18           C  
ATOM    425  NZ  LYS    59      33.477  32.781   4.910  1.00 42.03           N  
ATOM    426  N   ARG    60      32.914  32.073  11.702  1.00 51.20           N  
ATOM    427  CA  ARG    60      31.569  32.311  12.219  1.00 53.26           C  
ATOM    428  C   ARG    60      31.456  33.712  12.766  1.00 50.92           C  
ATOM    429  O   ARG    60      30.478  34.414  12.503  1.00 49.06           O  
ATOM    430  CB  ARG    60      31.236  31.290  13.306  1.00 54.29           C  
ATOM    431  CG  ARG    60      31.258  29.845  12.781  1.00 60.02           C  
ATOM    432  CD  ARG    60      31.161  28.754  13.885  1.00 61.47           C  
ATOM    433  NE  ARG    60      31.138  27.446  13.233  1.00 72.90           N  
ATOM    434  CZ  ARG    60      30.086  26.940  12.579  1.00 79.62           C  
ATOM    435  NH1 ARG    60      28.925  27.591  12.512  1.00 89.86           N  
ATOM    436  NH2 ARG    60      30.186  25.765  11.989  1.00 71.49           N  
ATOM    437  N   GLU    61      32.479  34.114  13.518  1.00 52.25           N  
ATOM    438  CA  GLU    61      32.532  35.431  14.158  1.00 50.35           C  
ATOM    439  C   GLU    61      32.672  36.615  13.194  1.00 47.88           C  
ATOM    440  O   GLU    61      32.191  37.705  13.494  1.00 49.25           O  
ATOM    441  CB  GLU    61      33.737  35.503  15.129  1.00 51.84           C  
ATOM    442  CG  GLU    61      33.666  34.671  16.443  1.00 59.20           C  
ATOM    443  CD  GLU    61      35.045  34.509  17.193  1.00 59.29           C  
ATOM    444  OE1 GLU    61      36.086  35.085  16.766  1.00 61.69           O  
ATOM    445  OE2 GLU    61      35.076  33.780  18.225  1.00 72.24           O  
ATOM    446  N   THR    62      33.389  36.428  12.085  1.00 42.88           N  
ATOM    447  CA  THR    62      33.716  37.549  11.186  1.00 43.33           C  
ATOM    448  C   THR    62      33.312  37.384   9.719  1.00 40.36           C  
ATOM    449  O   THR    62      33.360  38.340   8.954  1.00 42.65           O  
ATOM    450  CB  THR    62      35.255  37.824  11.195  1.00 40.65           C  
ATOM    451  OG1 THR    62      35.926  36.769  10.495  1.00 35.15           O  
ATOM    452  CG2 THR    62      35.833  37.990  12.648  1.00 34.73           C  
ATOM    453  N   GLY    63      32.923  36.184   9.336  1.00 40.64           N  
ATOM    454  CA  GLY    63      32.560  35.872   7.952  1.00 41.41           C  
ATOM    455  C   GLY    63      33.742  35.592   7.044  1.00 43.27           C  
ATOM    456  O   GLY    63      33.561  35.358   5.845  1.00 45.21           O  
ATOM    457  N   MET    64      34.953  35.619   7.603  1.00 44.51           N  
ATOM    458  CA  MET    64      36.175  35.382   6.839  1.00 45.50           C  
ATOM    459  C   MET    64      37.294  34.864   7.728  1.00 44.26           C  
ATOM    460  O   MET    64      37.122  34.693   8.941  1.00 41.59           O  
ATOM    461  CB  MET    64      36.605  36.663   6.121  1.00 45.04           C  
ATOM    462  CG  MET    64      36.613  37.860   6.986  1.00 47.01           C  
ATOM    463  SD  MET    64      37.029  39.482   6.004  0.75 47.90          SE  
ATOM    464  CE  MET    64      38.901  38.862   5.439  1.00 59.66           C  
ATOM    465  N   LEU    65      38.448  34.626   7.115  1.00 44.77           N  
ATOM    466  CA  LEU    65      39.608  34.125   7.841  1.00 43.33           C  
ATOM    467  C   LEU    65      40.633  35.227   8.089  1.00 42.87           C  
ATOM    468  O   LEU    65      40.295  36.395   8.095  1.00 44.04           O  
ATOM    469  CB  LEU    65      40.167  32.869   7.154  1.00 42.69           C  
ATOM    470  CG  LEU    65      39.144  31.724   7.110  1.00 44.17           C  
ATOM    471  CD1 LEU    65      39.490  30.693   6.027  1.00 35.33           C  
ATOM    472  CD2 LEU    65      38.968  31.084   8.505  1.00 39.69           C  
ATOM    473  N   ARG    66      41.884  34.845   8.293  1.00 43.65           N  
ATOM    474  CA  ARG    66      42.884  35.734   8.801  1.00 44.40           C  
ATOM    475  C   ARG    66      43.758  36.465   7.784  1.00 45.38           C  
ATOM    476  O   ARG    66      44.102  37.626   7.979  1.00 44.47           O  
ATOM    477  CB  ARG    66      43.789  34.898   9.713  1.00 43.61           C  
ATOM    478  CG  ARG    66      44.744  35.697  10.608  1.00 48.49           C  
ATOM    479  CD  ARG    66      45.695  34.730  11.281  1.00 47.22           C  
ATOM    480  NE  ARG    66      46.594  34.150  10.295  1.00 45.47           N  
ATOM    481  CZ  ARG    66      47.396  33.103  10.502  1.00 50.34           C  
ATOM    482  NH1 ARG    66      47.450  32.484  11.683  1.00 48.62           N  
ATOM    483  NH2 ARG    66      48.155  32.672   9.502  1.00 48.61           N  
ATOM    484  N   ASP    67      44.128  35.766   6.730  1.00 46.81           N  
ATOM    485  CA  ASP    67      45.040  36.281   5.741  1.00 47.75           C  
ATOM    486  C   ASP    67      44.333  36.578   4.453  1.00 49.32           C  
ATOM    487  O   ASP    67      43.305  36.007   4.133  1.00 47.49           O  
ATOM    488  CB  ASP    67      46.117  35.235   5.482  1.00 48.48           C  
ATOM    489  CG  ASP    67      46.804  34.797   6.752  1.00 47.99           C  
ATOM    490  OD1 ASP    67      46.953  35.636   7.668  1.00 44.98           O  
ATOM    491  OD2 ASP    67      47.179  33.620   6.840  1.00 48.00           O  
ATOM    492  N   ASP    68      44.976  37.423   3.679  1.00 51.15           N  
ATOM    493  CA  ASP    68      44.436  37.930   2.447  1.00 52.86           C  
ATOM    494  C   ASP    68      44.663  36.946   1.300  1.00 51.66           C  
ATOM    495  O   ASP    68      43.905  36.955   0.329  1.00 52.78           O  
ATOM    496  CB  ASP    68      45.090  39.285   2.168  1.00 55.83           C  
ATOM    497  CG  ASP    68      44.094  40.319   1.731  1.00 63.82           C  
ATOM    498  OD1 ASP    68      43.435  40.113   0.679  1.00 74.55           O  
ATOM    499  OD2 ASP    68      43.973  41.326   2.465  1.00 63.73           O  
ATOM    500  N   ALA    69      45.687  36.101   1.432  1.00 48.53           N  
ATOM    501  CA  ALA    69      45.999  35.066   0.444  1.00 48.57           C  
ATOM    502  C   ALA    69      44.772  34.204   0.079  1.00 48.52           C  
ATOM    503  O   ALA    69      44.108  33.618   0.943  1.00 48.23           O  
ATOM    504  CB  ALA    69      47.113  34.187   0.943  1.00 48.89           C  
ATOM    505  N   LYS    70      44.518  34.119  -1.226  1.00 47.87           N  
ATOM    506  CA  LYS    70      43.378  33.426  -1.768  1.00 47.57           C  
ATOM    507  C   LYS    70      43.628  31.917  -1.869  1.00 48.60           C  
ATOM    508  O   LYS    70      44.767  31.449  -1.745  1.00 49.21           O  
ATOM    509  CB  LYS    70      43.005  34.016  -3.129  1.00 44.83           C  
ATOM    510  CG  LYS    70      42.774  35.545  -3.104  1.00 49.98           C  
ATOM    511  CD  LYS    70      41.537  35.965  -2.297  1.00 48.83           C  
ATOM    512  CE  LYS    70      41.353  37.514  -2.246  1.00 44.39           C  
ATOM    513  NZ  LYS    70      42.399  38.226  -1.427  1.00 45.46           N  
ATOM    514  N   ALA    71      42.526  31.188  -2.046  1.00 46.47           N  
ATOM    515  CA  ALA    71      42.513  29.729  -2.160  1.00 48.77           C  
ATOM    516  C   ALA    71      43.544  29.228  -3.176  1.00 48.96           C  
ATOM    517  O   ALA    71      44.238  28.233  -2.930  1.00 48.08           O  
ATOM    518  CB  ALA    71      41.104  29.246  -2.554  1.00 45.13           C  
ATOM    519  N   ILE    72      43.668  29.938  -4.298  1.00 49.21           N  
ATOM    520  CA  ILE    72      44.594  29.502  -5.340  1.00 49.29           C  
ATOM    521  C   ILE    72      46.038  29.493  -4.796  1.00 49.91           C  
ATOM    522  O   ILE    72      46.765  28.530  -5.020  1.00 49.57           O  
ATOM    523  CB  ILE    72      44.416  30.310  -6.659  1.00 50.44           C  
ATOM    524  CG1 ILE    72      45.048  29.560  -7.851  1.00 54.22           C  
ATOM    525  CG2 ILE    72      44.959  31.731  -6.521  1.00 43.02           C  
ATOM    526  CD1 ILE    72      44.386  28.211  -8.196  1.00 52.07           C  
ATOM    527  N   GLU    73      46.424  30.516  -4.025  1.00 48.92           N  
ATOM    528  CA  GLU    73      47.773  30.575  -3.422  1.00 48.38           C  
ATOM    529  C   GLU    73      47.994  29.436  -2.412  1.00 49.08           C  
ATOM    530  O   GLU    73      49.084  28.844  -2.353  1.00 51.64           O  
ATOM    531  CB  GLU    73      48.056  31.960  -2.789  1.00 44.72           C  
ATOM    532  N   VAL    74      46.982  29.133  -1.606  1.00 48.95           N  
ATOM    533  CA  VAL    74      47.082  28.009  -0.667  1.00 48.44           C  
ATOM    534  C   VAL    74      47.245  26.694  -1.431  1.00 49.47           C  
ATOM    535  O   VAL    74      48.026  25.811  -1.033  1.00 46.63           O  
ATOM    536  CB  VAL    74      45.847  27.929   0.247  1.00 48.50           C  
ATOM    537  CG1 VAL    74      45.675  26.519   0.870  1.00 42.05           C  
ATOM    538  CG2 VAL    74      45.918  29.060   1.306  1.00 50.41           C  
ATOM    539  N   VAL    75      46.495  26.553  -2.523  1.00 50.49           N  
ATOM    540  CA  VAL    75      46.587  25.340  -3.336  1.00 50.30           C  
ATOM    541  C   VAL    75      47.957  25.175  -3.988  1.00 51.72           C  
ATOM    542  O   VAL    75      48.516  24.091  -3.968  1.00 49.57           O  
ATOM    543  CB  VAL    75      45.533  25.289  -4.436  1.00 50.92           C  
ATOM    544  CG1 VAL    75      45.860  24.141  -5.398  1.00 48.68           C  
ATOM    545  CG2 VAL    75      44.119  25.153  -3.812  1.00 47.79           C  
ATOM    546  N   ARG    76      48.495  26.253  -4.550  1.00 54.91           N  
ATOM    547  CA  ARG    76      49.776  26.162  -5.238  1.00 57.13           C  
ATOM    548  C   ARG    76      50.999  26.330  -4.351  1.00 55.63           C  
ATOM    549  O   ARG    76      52.078  25.993  -4.788  1.00 56.56           O  
ATOM    550  CB  ARG    76      49.841  27.044  -6.514  1.00 57.62           C  
ATOM    551  CG  ARG    76      49.219  28.414  -6.426  1.00 62.82           C  
ATOM    552  CD  ARG    76      49.329  29.243  -7.718  1.00 61.44           C  
ATOM    553  NE  ARG    76      48.558  28.687  -8.827  1.00 68.70           N  
ATOM    554  CZ  ARG    76      48.114  29.388  -9.876  1.00 72.60           C  
ATOM    555  NH1 ARG    76      48.301  30.707  -9.949  1.00 71.64           N  
ATOM    556  NH2 ARG    76      47.428  28.771 -10.839  1.00 74.37           N  
ATOM    557  N   SER    77      50.841  26.766  -3.102  1.00 56.55           N  
ATOM    558  CA  SER    77      52.011  26.999  -2.230  1.00 56.57           C  
ATOM    559  C   SER    77      51.990  26.386  -0.839  1.00 56.05           C  
ATOM    560  O   SER    77      53.052  26.152  -0.275  1.00 58.37           O  
ATOM    561  CB  SER    77      52.242  28.499  -2.049  1.00 55.87           C  
ATOM    562  OG  SER    77      52.404  29.148  -3.298  1.00 60.87           O  
ATOM    563  N   ALA    78      50.816  26.152  -0.264  1.00 53.72           N  
ATOM    564  CA  ALA    78      50.739  25.637   1.102  1.00 51.81           C  
ATOM    565  C   ALA    78      51.302  24.229   1.200  1.00 52.20           C  
ATOM    566  O   ALA    78      51.362  23.489   0.203  1.00 49.94           O  
ATOM    567  CB  ALA    78      49.297  25.683   1.616  1.00 50.36           C  
ATOM    568  N   ASP    79      51.708  23.862   2.413  1.00 54.01           N  
ATOM    569  CA  ASP    79      52.279  22.537   2.670  1.00 55.96           C  
ATOM    570  C   ASP    79      51.217  21.544   3.152  1.00 55.20           C  
ATOM    571  O   ASP    79      50.816  21.537   4.330  1.00 57.13           O  
ATOM    572  CB  ASP    79      53.413  22.632   3.691  1.00 57.64           C  
ATOM    573  CG  ASP    79      54.084  21.292   3.941  1.00 63.21           C  
ATOM    574  OD1 ASP    79      53.813  20.320   3.183  1.00 72.09           O  
ATOM    575  OD2 ASP    79      54.875  21.211   4.904  1.00 70.17           O  
ATOM    576  N   TYR    80      50.770  20.704   2.226  1.00 52.70           N  
ATOM    577  CA  TYR    80      49.740  19.707   2.511  1.00 50.65           C  
ATOM    578  C   TYR    80      49.966  18.467   1.647  1.00 50.59           C  
ATOM    579  O   TYR    80      50.675  18.507   0.631  1.00 48.13           O  
ATOM    580  CB  TYR    80      48.336  20.285   2.275  1.00 49.01           C  
ATOM    581  CG  TYR    80      48.087  20.691   0.838  1.00 48.83           C  
ATOM    582  CD1 TYR    80      48.447  21.950   0.376  1.00 46.01           C  
ATOM    583  CD2 TYR    80      47.512  19.806  -0.066  1.00 50.85           C  
ATOM    584  CE1 TYR    80      48.244  22.306  -0.956  1.00 48.56           C  
ATOM    585  CE2 TYR    80      47.298  20.160  -1.389  1.00 49.09           C  
ATOM    586  CZ  TYR    80      47.664  21.405  -1.827  1.00 45.04           C  
ATOM    587  OH  TYR    80      47.448  21.760  -3.136  1.00 46.31           O  
ATOM    588  N   ASP    81      49.359  17.372   2.094  1.00 50.85           N  
ATOM    589  CA  ASP    81      49.426  16.077   1.445  1.00 50.80           C  
ATOM    590  C   ASP    81      48.141  15.778   0.682  1.00 49.39           C  
ATOM    591  O   ASP    81      48.193  15.248  -0.423  1.00 48.44           O  
ATOM    592  CB  ASP    81      49.680  15.009   2.504  1.00 51.60           C  
ATOM    593  CG  ASP    81      51.024  15.184   3.165  1.00 52.29           C  
ATOM    594  OD1 ASP    81      51.983  15.436   2.413  1.00 50.80           O  
ATOM    595  OD2 ASP    81      51.114  15.094   4.405  1.00 52.87           O  
ATOM    596  N   VAL    82      47.005  16.131   1.280  1.00 48.04           N  
ATOM    597  CA  VAL    82      45.679  15.929   0.673  1.00 49.37           C  
ATOM    598  C   VAL    82      44.902  17.249   0.701  1.00 51.01           C  
ATOM    599  O   VAL    82      44.898  17.942   1.713  1.00 49.19           O  
ATOM    600  CB  VAL    82      44.861  14.815   1.432  1.00 50.01           C  
ATOM    601  CG1 VAL    82      44.888  15.036   2.950  1.00 45.54           C  
ATOM    602  CG2 VAL    82      43.413  14.695   0.911  1.00 45.57           C  
ATOM    603  N   LEU    83      44.281  17.601  -0.431  1.00 51.29           N  
ATOM    604  CA  LEU    83      43.392  18.753  -0.515  1.00 49.17           C  
ATOM    605  C   LEU    83      41.920  18.317  -0.411  1.00 49.00           C  
ATOM    606  O   LEU    83      41.450  17.460  -1.165  1.00 48.75           O  
ATOM    607  CB  LEU    83      43.555  19.471  -1.847  1.00 46.98           C  
ATOM    608  CG  LEU    83      42.636  20.677  -2.069  1.00 48.83           C  
ATOM    609  CD1 LEU    83      42.959  21.779  -1.048  1.00 42.31           C  
ATOM    610  CD2 LEU    83      42.764  21.161  -3.508  1.00 42.84           C  
ATOM    611  N   ILE    84      41.197  18.934   0.516  1.00 48.92           N  
ATOM    612  CA  ILE    84      39.746  18.767   0.619  1.00 46.97           C  
ATOM    613  C   ILE    84      39.160  19.989  -0.089  1.00 45.43           C  
ATOM    614  O   ILE    84      39.314  21.113   0.354  1.00 44.83           O  
ATOM    615  CB  ILE    84      39.276  18.666   2.071  1.00 46.15           C  
ATOM    616  CG1 ILE    84      39.852  17.365   2.668  1.00 47.29           C  
ATOM    617  CG2 ILE    84      37.762  18.689   2.092  1.00 46.24           C  
ATOM    618  CD1 ILE    84      39.445  17.067   4.080  1.00 50.14           C  
ATOM    619  N   GLU    85      38.522  19.748  -1.216  1.00 46.60           N  
ATOM    620  CA  GLU    85      38.039  20.784  -2.084  1.00 47.89           C  
ATOM    621  C   GLU    85      36.520  20.804  -2.013  1.00 49.62           C  
ATOM    622  O   GLU    85      35.832  20.028  -2.692  1.00 51.63           O  
ATOM    623  CB  GLU    85      38.573  20.475  -3.490  1.00 51.71           C  
ATOM    624  CG  GLU    85      38.765  21.692  -4.368  1.00 57.75           C  
ATOM    625  CD  GLU    85      37.511  22.140  -5.000  1.00 60.03           C  
ATOM    626  OE1 GLU    85      37.080  21.474  -5.960  1.00 68.42           O  
ATOM    627  OE2 GLU    85      36.983  23.178  -4.569  1.00 72.90           O  
ATOM    628  N   ALA    86      36.025  21.714  -1.175  1.00 50.24           N  
ATOM    629  CA  ALA    86      34.621  21.906  -0.862  1.00 51.22           C  
ATOM    630  C   ALA    86      34.248  23.339  -1.231  1.00 51.93           C  
ATOM    631  O   ALA    86      33.511  24.004  -0.489  1.00 47.88           O  
ATOM    632  CB  ALA    86      34.436  21.671   0.646  1.00 42.93           C  
ATOM    633  N   SER    87      34.774  23.845  -2.363  1.00 55.52           N  
ATOM    634  CA  SER    87      34.591  25.281  -2.700  1.00 57.00           C  
ATOM    635  C   SER    87      33.147  25.630  -3.017  1.00 61.90           C  
ATOM    636  O   SER    87      32.398  24.811  -3.514  1.00 59.30           O  
ATOM    637  CB  SER    87      35.575  25.809  -3.754  1.00 55.15           C  
ATOM    638  OG  SER    87      35.372  25.244  -5.030  1.00 56.86           O  
ATOM    639  N   VAL    88      32.775  26.852  -2.642  1.00 69.20           N  
ATOM    640  CA  VAL    88      31.417  27.390  -2.824  1.00 73.90           C  
ATOM    641  C   VAL    88      31.318  27.964  -4.261  1.00 76.16           C  
ATOM    642  O   VAL    88      31.702  29.098  -4.513  1.00 73.54           O  
ATOM    643  CB  VAL    88      31.120  28.461  -1.715  1.00 73.08           C  
ATOM    644  CG1 VAL    88      29.731  29.066  -1.894  1.00 69.80           C  
ATOM    645  CG2 VAL    88      31.289  27.840  -0.312  1.00 61.02           C  
ATOM    646  N   THR    89      30.828  27.137  -5.190  1.00 81.00           N  
ATOM    647  CA  THR    89      30.745  27.468  -6.637  1.00 82.65           C  
ATOM    648  C   THR    89      30.000  28.772  -6.989  1.00 85.93           C  
ATOM    649  O   THR    89      30.596  29.691  -7.569  1.00 87.51           O  
ATOM    650  CB  THR    89      30.105  26.289  -7.430  1.00 83.25           C  
ATOM    651  OG1 THR    89      30.674  25.064  -6.969  1.00 82.01           O  
ATOM    652  CG2 THR    89      30.323  26.436  -8.944  1.00 80.95           C  
ATOM    653  N   ARG    90      28.711  28.843  -6.654  1.00 87.96           N  
ATOM    654  CA  ARG    90      27.909  30.034  -6.955  1.00 90.26           C  
ATOM    655  C   ARG    90      28.283  31.197  -6.028  1.00 91.70           C  
ATOM    656  O   ARG    90      29.381  31.757  -6.132  1.00 92.21           O  
ATOM    657  CB  ARG    90      26.401  29.730  -6.884  1.00 90.72           C  
ATOM    658  CG  ARG    90      25.902  28.808  -7.988  1.00 88.44           C  
ATOM    659  N   GLU    95      36.980  27.853 -10.944  1.00 71.42           N  
ATOM    660  CA  GLU    95      37.985  27.902  -9.881  1.00 70.39           C  
ATOM    661  C   GLU    95      38.234  26.504  -9.345  1.00 67.32           C  
ATOM    662  O   GLU    95      39.382  26.078  -9.244  1.00 66.47           O  
ATOM    663  CB  GLU    95      37.552  28.843  -8.747  1.00 70.36           C  
ATOM    664  CG  GLU    95      37.322  30.293  -9.198  1.00 74.88           C  
ATOM    665  CD  GLU    95      37.005  31.238  -8.055  1.00 74.03           C  
ATOM    666  N   GLY    96      37.146  25.793  -9.032  1.00 64.05           N  
ATOM    667  CA  GLY    96      37.204  24.430  -8.510  1.00 61.48           C  
ATOM    668  C   GLY    96      38.060  23.472  -9.322  1.00 59.51           C  
ATOM    669  O   GLY    96      38.877  22.737  -8.755  1.00 56.52           O  
ATOM    670  N   VAL    97      37.863  23.492 -10.646  1.00 56.94           N  
ATOM    671  CA  VAL    97      38.614  22.650 -11.595  1.00 55.26           C  
ATOM    672  C   VAL    97      40.127  22.928 -11.513  1.00 56.32           C  
ATOM    673  O   VAL    97      40.927  21.991 -11.518  1.00 55.09           O  
ATOM    674  CB  VAL    97      38.070  22.803 -13.045  1.00 53.78           C  
ATOM    675  CG1 VAL    97      38.066  24.261 -13.494  1.00 58.74           C  
ATOM    676  CG2 VAL    97      38.864  21.960 -14.008  1.00 59.11           C  
ATOM    677  N   ASN    98      40.480  24.214 -11.389  1.00 54.22           N  
ATOM    678  CA  ASN    98      41.857  24.660 -11.246  1.00 54.30           C  
ATOM    679  C   ASN    98      42.453  24.285  -9.882  1.00 51.57           C  
ATOM    680  O   ASN    98      43.645  23.998  -9.795  1.00 47.91           O  
ATOM    681  CB  ASN    98      41.962  26.177 -11.474  1.00 55.52           C  
ATOM    682  CG  ASN    98      41.589  26.593 -12.901  1.00 61.57           C  
ATOM    683  OD1 ASN    98      41.665  25.800 -13.848  1.00 71.44           O  
ATOM    684  ND2 ASN    98      41.197  27.849 -13.056  1.00 66.79           N  
ATOM    685  N   TYR    99      41.643  24.288  -8.820  1.00 48.54           N  
ATOM    686  CA  TYR    99      42.161  23.863  -7.522  1.00 49.64           C  
ATOM    687  C   TYR    99      42.500  22.371  -7.569  1.00 49.05           C  
ATOM    688  O   TYR    99      43.541  21.952  -7.053  1.00 51.64           O  
ATOM    689  CB  TYR    99      41.194  24.121  -6.350  1.00 48.05           C  
ATOM    690  CG  TYR    99      40.754  25.556  -6.162  1.00 46.23           C  
ATOM    691  CD1 TYR    99      41.623  26.625  -6.348  1.00 46.50           C  
ATOM    692  CD2 TYR    99      39.490  25.832  -5.724  1.00 45.42           C  
ATOM    693  CE1 TYR    99      41.192  27.936  -6.155  1.00 46.16           C  
ATOM    694  CE2 TYR    99      39.064  27.119  -5.519  1.00 46.77           C  
ATOM    695  CZ  TYR    99      39.904  28.166  -5.733  1.00 45.70           C  
ATOM    696  OH  TYR    99      39.402  29.434  -5.514  1.00 51.84           O  
ATOM    697  N   ILE   100      41.628  21.574  -8.179  1.00 47.86           N  
ATOM    698  CA  ILE   100      41.874  20.132  -8.314  1.00 49.67           C  
ATOM    699  C   ILE   100      43.122  19.875  -9.195  1.00 51.71           C  
ATOM    700  O   ILE   100      44.067  19.252  -8.743  1.00 51.29           O  
ATOM    701  CB  ILE   100      40.659  19.376  -8.896  1.00 48.81           C  
ATOM    702  CG1 ILE   100      39.469  19.386  -7.930  1.00 48.30           C  
ATOM    703  CG2 ILE   100      41.003  17.910  -9.176  1.00 44.61           C  
ATOM    704  CD1 ILE   100      38.199  18.752  -8.519  1.00 49.51           C  
ATOM    705  N   ARG   101      43.108  20.369 -10.431  1.00 52.51           N  
ATOM    706  CA  ARG   101      44.230  20.194 -11.364  1.00 55.14           C  
ATOM    707  C   ARG   101      45.554  20.601 -10.734  1.00 54.85           C  
ATOM    708  O   ARG   101      46.535  19.874 -10.839  1.00 55.38           O  
ATOM    709  CB  ARG   101      44.035  21.011 -12.650  1.00 55.82           C  
ATOM    710  CG  ARG   101      42.778  20.674 -13.456  1.00 58.03           C  
ATOM    711  CD  ARG   101      42.829  21.241 -14.900  1.00 62.37           C  
ATOM    712  NE  ARG   101      43.768  20.500 -15.761  1.00 74.76           N  
ATOM    713  CZ  ARG   101      43.525  19.324 -16.364  1.00 73.10           C  
ATOM    714  NH1 ARG   101      42.371  18.678 -16.211  1.00 82.89           N  
ATOM    715  NH2 ARG   101      44.462  18.763 -17.113  1.00 77.93           N  
ATOM    716  N   GLU   102      45.570  21.741 -10.047  1.00 55.06           N  
ATOM    717  CA  GLU   102      46.809  22.249  -9.432  1.00 52.94           C  
ATOM    718  C   GLU   102      47.251  21.434  -8.207  1.00 50.92           C  
ATOM    719  O   GLU   102      48.438  21.306  -7.962  1.00 50.71           O  
ATOM    720  CB  GLU   102      46.692  23.751  -9.127  1.00 53.31           C  
ATOM    721  CG  GLU   102      47.894  24.396  -8.412  1.00 59.26           C  
ATOM    722  CD  GLU   102      49.247  24.233  -9.132  1.00 73.51           C  
ATOM    723  OE1 GLU   102      49.290  23.801 -10.310  1.00 79.16           O  
ATOM    724  OE2 GLU   102      50.281  24.545  -8.500  1.00 74.49           O  
ATOM    725  N   ALA   103      46.331  20.875  -7.431  1.00 48.87           N  
ATOM    726  CA  ALA   103      46.771  20.000  -6.334  1.00 49.59           C  
ATOM    727  C   ALA   103      47.291  18.658  -6.928  1.00 50.34           C  
ATOM    728  O   ALA   103      48.342  18.160  -6.523  1.00 49.72           O  
ATOM    729  CB  ALA   103      45.681  19.771  -5.339  1.00 49.73           C  
ATOM    730  N   LEU   104      46.581  18.114  -7.920  1.00 49.91           N  
ATOM    731  CA  LEU   104      46.985  16.867  -8.575  1.00 51.67           C  
ATOM    732  C   LEU   104      48.338  17.020  -9.279  1.00 52.40           C  
ATOM    733  O   LEU   104      49.191  16.145  -9.171  1.00 50.76           O  
ATOM    734  CB  LEU   104      45.928  16.407  -9.568  1.00 49.76           C  
ATOM    735  CG  LEU   104      44.547  16.002  -9.041  1.00 53.38           C  
ATOM    736  CD1 LEU   104      43.662  15.662 -10.233  1.00 37.65           C  
ATOM    737  CD2 LEU   104      44.609  14.837  -8.066  1.00 50.22           C  
ATOM    738  N   LYS   105      48.533  18.144  -9.976  1.00 56.09           N  
ATOM    739  CA  LYS   105      49.814  18.446 -10.655  1.00 57.24           C  
ATOM    740  C   LYS   105      50.963  18.669  -9.692  1.00 57.39           C  
ATOM    741  O   LYS   105      52.103  18.672 -10.107  1.00 59.78           O  
ATOM    742  CB  LYS   105      49.703  19.640 -11.618  1.00 57.94           C  
ATOM    743  CG  LYS   105      49.032  19.267 -12.935  1.00 61.88           C  
ATOM    744  CD  LYS   105      49.179  20.332 -14.006  1.00 62.50           C  
ATOM    745  CE  LYS   105      48.876  19.739 -15.402  1.00 70.85           C  
ATOM    746  NZ  LYS   105      49.886  18.699 -15.892  1.00 70.98           N  
ATOM    747  N   ARG   106      50.658  18.892  -8.420  1.00 58.13           N  
ATOM    748  CA  ARG   106      51.672  19.005  -7.369  1.00 56.77           C  
ATOM    749  C   ARG   106      51.905  17.619  -6.740  1.00 56.15           C  
ATOM    750  O   ARG   106      52.762  17.458  -5.857  1.00 54.66           O  
ATOM    751  CB  ARG   106      51.227  19.993  -6.282  1.00 56.17           C  
ATOM    752  CG  ARG   106      51.323  21.464  -6.672  1.00 56.67           C  
ATOM    753  CD  ARG   106      51.087  22.367  -5.465  1.00 55.82           C  
ATOM    754  NE  ARG   106      52.073  22.124  -4.405  1.00 53.50           N  
ATOM    755  CZ  ARG   106      51.980  22.577  -3.155  1.00 56.94           C  
ATOM    756  NH1 ARG   106      50.933  23.294  -2.762  1.00 58.09           N  
ATOM    757  NH2 ARG   106      52.925  22.285  -2.278  1.00 50.02           N  
ATOM    758  N   GLY   107      51.131  16.628  -7.195  1.00 55.48           N  
ATOM    759  CA  GLY   107      51.208  15.275  -6.654  1.00 55.17           C  
ATOM    760  C   GLY   107      50.539  15.197  -5.295  1.00 54.21           C  
ATOM    761  O   GLY   107      51.081  14.619  -4.345  1.00 54.11           O  
ATOM    762  N   LYS   108      49.371  15.816  -5.186  1.00 51.69           N  
ATOM    763  CA  LYS   108      48.619  15.784  -3.935  1.00 51.31           C  
ATOM    764  C   LYS   108      47.323  15.041  -4.178  1.00 48.74           C  
ATOM    765  O   LYS   108      46.741  15.138  -5.251  1.00 48.93           O  
ATOM    766  CB  LYS   108      48.273  17.194  -3.456  1.00 51.38           C  
ATOM    767  CG  LYS   108      49.419  18.169  -3.456  1.00 56.15           C  
ATOM    768  CD  LYS   108      50.515  17.765  -2.520  1.00 58.85           C  
ATOM    769  CE  LYS   108      51.599  18.829  -2.498  1.00 60.63           C  
ATOM    770  NZ  LYS   108      52.697  18.433  -1.593  1.00 62.62           N  
ATOM    771  N   HIS   109      46.874  14.297  -3.182  1.00 49.47           N  
ATOM    772  CA  HIS   109      45.569  13.666  -3.256  1.00 49.40           C  
ATOM    773  C   HIS   109      44.517  14.758  -3.203  1.00 50.51           C  
ATOM    774  O   HIS   109      44.791  15.847  -2.689  1.00 47.92           O  
ATOM    775  CB  HIS   109      45.343  12.730  -2.073  1.00 49.59           C  
ATOM    776  CG  HIS   109      46.234  11.536  -2.078  1.00 48.32           C  
ATOM    777  ND1 HIS   109      46.214  10.603  -3.090  1.00 46.44           N  
ATOM    778  CD2 HIS   109      47.148  11.101  -1.183  1.00 56.19           C  
ATOM    779  CE1 HIS   109      47.073   9.642  -2.817  1.00 46.97           C  
ATOM    780  NE2 HIS   109      47.665   9.927  -1.671  1.00 52.45           N  
ATOM    781  N   VAL   110      43.330  14.473  -3.752  1.00 50.11           N  
ATOM    782  CA  VAL   110      42.217  15.417  -3.717  1.00 48.52           C  
ATOM    783  C   VAL   110      40.909  14.683  -3.375  1.00 49.34           C  
ATOM    784  O   VAL   110      40.607  13.641  -3.948  1.00 48.90           O  
ATOM    785  CB  VAL   110      42.041  16.184  -5.047  1.00 48.35           C  
ATOM    786  CG1 VAL   110      40.770  17.073  -5.010  1.00 44.89           C  
ATOM    787  CG2 VAL   110      43.297  17.022  -5.380  1.00 49.41           C  
ATOM    788  N   VAL   111      40.183  15.217  -2.388  1.00 49.95           N  
ATOM    789  CA  VAL   111      38.847  14.747  -2.023  1.00 47.72           C  
ATOM    790  C   VAL   111      37.955  15.932  -2.284  1.00 47.79           C  
ATOM    791  O   VAL   111      38.155  16.980  -1.698  1.00 48.65           O  
ATOM    792  CB  VAL   111      38.744  14.330  -0.539  1.00 50.88           C  
ATOM    793  CG1 VAL   111      37.274  13.885  -0.179  1.00 43.38           C  
ATOM    794  CG2 VAL   111      39.822  13.221  -0.211  1.00 37.10           C  
ATOM    795  N   THR   112      36.975  15.786  -3.170  1.00 48.71           N  
ATOM    796  CA  THR   112      36.090  16.889  -3.497  1.00 48.68           C  
ATOM    797  C   THR   112      34.581  16.600  -3.306  1.00 47.62           C  
ATOM    798  O   THR   112      34.144  15.451  -3.292  1.00 46.68           O  
ATOM    799  CB  THR   112      36.337  17.321  -4.968  1.00 50.41           C  
ATOM    800  OG1 THR   112      35.673  18.561  -5.241  1.00 47.66           O  
ATOM    801  CG2 THR   112      35.852  16.241  -5.934  1.00 45.32           C  
ATOM    802  N   SER   113      33.820  17.681  -3.147  1.00 45.75           N  
ATOM    803  CA  SER   113      32.375  17.659  -3.096  1.00 46.09           C  
ATOM    804  C   SER   113      31.789  18.458  -4.240  1.00 47.40           C  
ATOM    805  O   SER   113      30.560  18.580  -4.317  1.00 45.48           O  
ATOM    806  CB  SER   113      31.875  18.236  -1.788  1.00 45.43           C  
ATOM    807  OG  SER   113      32.284  19.584  -1.646  1.00 48.74           O  
ATOM    808  N   ASN   114      32.644  19.035  -5.109  1.00 50.21           N  
ATOM    809  CA  ASN   114      32.192  19.825  -6.272  1.00 48.59           C  
ATOM    810  C   ASN   114      31.952  18.966  -7.482  1.00 50.23           C  
ATOM    811  O   ASN   114      32.851  18.267  -7.955  1.00 53.11           O  
ATOM    812  CB  ASN   114      33.234  20.855  -6.728  1.00 53.83           C  
ATOM    813  CG  ASN   114      33.505  21.943  -5.724  1.00 55.30           C  
ATOM    814  OD1 ASN   114      32.666  22.306  -4.903  1.00 62.72           O  
ATOM    815  ND2 ASN   114      34.684  22.520  -5.836  1.00 64.14           N  
ATOM    816  N   LYS   115      30.766  19.082  -8.045  1.00 50.56           N  
ATOM    817  CA  LYS   115      30.398  18.316  -9.208  1.00 51.29           C  
ATOM    818  C   LYS   115      30.955  18.846 -10.506  1.00 51.41           C  
ATOM    819  O   LYS   115      31.316  18.065 -11.374  1.00 51.72           O  
ATOM    820  CB  LYS   115      28.881  18.263  -9.341  1.00 49.65           C  
ATOM    821  CG  LYS   115      28.202  17.499  -8.226  1.00 52.75           C  
ATOM    822  CD  LYS   115      26.694  17.359  -8.422  1.00 53.62           C  
ATOM    823  CE  LYS   115      25.950  18.662  -8.349  1.00 50.26           C  
ATOM    824  NZ  LYS   115      26.141  19.356  -7.059  1.00 50.30           N  
ATOM    825  N   GLY   116      30.971  20.166 -10.651  1.00 52.85           N  
ATOM    826  CA  GLY   116      31.371  20.831 -11.893  1.00 53.63           C  
ATOM    827  C   GLY   116      32.590  20.334 -12.641  1.00 52.17           C  
ATOM    828  O   GLY   116      32.525  20.138 -13.850  1.00 52.80           O  
ATOM    829  N   PRO   117      33.732  20.230 -11.942  1.00 54.21           N  
ATOM    830  CA  PRO   117      34.969  19.755 -12.567  1.00 54.55           C  
ATOM    831  C   PRO   117      34.874  18.330 -13.110  1.00 54.36           C  
ATOM    832  O   PRO   117      35.433  18.031 -14.153  1.00 53.77           O  
ATOM    833  CB  PRO   117      36.012  19.857 -11.431  1.00 55.95           C  
ATOM    834  CG  PRO   117      35.430  20.794 -10.416  1.00 56.94           C  
ATOM    835  CD  PRO   117      33.940  20.671 -10.539  1.00 53.64           C  
ATOM    836  N   LEU   118      34.183  17.465 -12.378  1.00 55.23           N  
ATOM    837  CA  LEU   118      33.987  16.075 -12.757  1.00 55.96           C  
ATOM    838  C   LEU   118      33.057  15.968 -13.965  1.00 55.80           C  
ATOM    839  O   LEU   118      33.257  15.138 -14.825  1.00 58.23           O  
ATOM    840  CB  LEU   118      33.446  15.262 -11.545  1.00 58.62           C  
ATOM    841  CG  LEU   118      34.500  15.044 -10.441  1.00 61.54           C  
ATOM    842  CD1 LEU   118      33.928  14.742  -9.107  1.00 71.04           C  
ATOM    843  CD2 LEU   118      35.406  13.924 -10.859  1.00 68.06           C  
ATOM    844  N   VAL   119      32.046  16.817 -14.035  1.00 54.86           N  
ATOM    845  CA  VAL   119      31.113  16.814 -15.154  1.00 53.09           C  
ATOM    846  C   VAL   119      31.791  17.310 -16.443  1.00 55.58           C  
ATOM    847  O   VAL   119      31.652  16.694 -17.498  1.00 56.38           O  
ATOM    848  CB  VAL   119      29.889  17.628 -14.764  1.00 54.44           C  
ATOM    849  CG1 VAL   119      28.941  17.805 -15.914  1.00 52.88           C  
ATOM    850  CG2 VAL   119      29.207  16.909 -13.621  1.00 44.67           C  
ATOM    851  N   ALA   120      32.582  18.373 -16.318  1.00 54.44           N  
ATOM    852  CA  ALA   120      33.290  18.992 -17.435  1.00 54.29           C  
ATOM    853  C   ALA   120      34.518  18.235 -17.921  1.00 55.34           C  
ATOM    854  O   ALA   120      34.811  18.247 -19.105  1.00 57.54           O  
ATOM    855  CB  ALA   120      33.737  20.410 -17.029  1.00 51.93           C  
ATOM    856  N   GLU   121      35.213  17.545 -17.025  1.00 56.00           N  
ATOM    857  CA  GLU   121      36.541  17.038 -17.323  1.00 58.35           C  
ATOM    858  C   GLU   121      36.841  15.724 -16.611  1.00 55.53           C  
ATOM    859  O   GLU   121      37.940  15.530 -16.113  1.00 56.64           O  
ATOM    860  CB  GLU   121      37.464  18.167 -16.815  1.00 59.18           C  
ATOM    861  CG  GLU   121      38.830  18.362 -17.439  1.00 70.74           C  
ATOM    862  CD  GLU   121      39.409  19.783 -17.142  1.00 65.74           C  
ATOM    863  OE1 GLU   121      38.645  20.684 -16.743  1.00 79.01           O  
ATOM    864  OE2 GLU   121      40.619  20.015 -17.355  1.00 85.72           O  
ATOM    865  N   PHE   122      35.876  14.802 -16.601  1.00 56.63           N  
ATOM    866  CA  PHE   122      36.010  13.547 -15.844  1.00 55.23           C  
ATOM    867  C   PHE   122      37.264  12.738 -16.151  1.00 54.15           C  
ATOM    868  O   PHE   122      38.086  12.516 -15.264  1.00 52.49           O  
ATOM    869  CB  PHE   122      34.777  12.655 -16.018  1.00 54.88           C  
ATOM    870  CG  PHE   122      34.693  11.521 -15.020  1.00 50.49           C  
ATOM    871  CD1 PHE   122      35.355  10.327 -15.244  1.00 55.24           C  
ATOM    872  CD2 PHE   122      33.935  11.644 -13.876  1.00 50.51           C  
ATOM    873  CE1 PHE   122      35.289   9.278 -14.335  1.00 51.72           C  
ATOM    874  CE2 PHE   122      33.841  10.587 -12.970  1.00 51.01           C  
ATOM    875  CZ  PHE   122      34.524   9.416 -13.196  1.00 52.74           C  
ATOM    876  N   HIS   123      37.401  12.272 -17.392  1.00 56.63           N  
ATOM    877  CA  HIS   123      38.563  11.450 -17.733  0.50 55.39           C  
ATOM    879  C   HIS   123      39.863  12.266 -17.699  1.00 54.42           C  
ATOM    880  O   HIS   123      40.909  11.736 -17.299  1.00 53.57           O  
ATOM    881  CB  HIS   123      38.302  10.658 -19.024  0.50 56.22           C  
ATOM    883  CG  HIS   123      37.164   9.680 -18.890  0.50 57.00           C  
ATOM    885  ND1 HIS   123      37.353   8.347 -18.593  0.50 58.87           N  
ATOM    887  CD2 HIS   123      35.821   9.859 -18.951  0.50 55.15           C  
ATOM    889  CE1 HIS   123      36.178   7.744 -18.505  0.50 56.16           C  
ATOM    891  NE2 HIS   123      35.233   8.640 -18.717  0.50 47.93           N  
ATOM    893  N   GLY   124      39.796  13.550 -18.054  1.00 53.91           N  
ATOM    894  CA  GLY   124      40.978  14.415 -17.976  1.00 53.04           C  
ATOM    895  C   GLY   124      41.543  14.511 -16.555  1.00 51.96           C  
ATOM    896  O   GLY   124      42.753  14.529 -16.351  1.00 50.24           O  
ATOM    897  N   LEU   125      40.664  14.563 -15.559  1.00 53.43           N  
ATOM    898  CA  LEU   125      41.097  14.673 -14.155  1.00 52.48           C  
ATOM    899  C   LEU   125      41.531  13.328 -13.551  1.00 50.24           C  
ATOM    900  O   LEU   125      42.487  13.275 -12.777  1.00 49.73           O  
ATOM    901  CB  LEU   125      40.000  15.344 -13.308  1.00 53.01           C  
ATOM    902  CG  LEU   125      39.695  16.826 -13.543  1.00 54.32           C  
ATOM    903  CD1 LEU   125      38.510  17.280 -12.725  1.00 55.94           C  
ATOM    904  CD2 LEU   125      40.916  17.652 -13.194  1.00 52.48           C  
ATOM    905  N   MET   126      40.808  12.256 -13.865  1.00 52.81           N  
ATOM    906  CA  MET   126      41.185  10.893 -13.402  1.00 54.54           C  
ATOM    907  C   MET   126      42.575  10.517 -13.924  1.00 53.83           C  
ATOM    908  O   MET   126      43.378   9.944 -13.184  1.00 53.10           O  
ATOM    909  CB  MET   126      40.189   9.807 -13.835  1.00 54.20           C  
ATOM    910  CG  MET   126      38.795   9.855 -13.183  1.00 58.18           C  
ATOM    911  SD  MET   126      38.751  10.091 -11.219  0.75 60.16          SE  
ATOM    912  CE  MET   126      39.752   8.577 -10.538  1.00 78.54           C  
ATOM    913  N   SER   127      42.844  10.862 -15.186  1.00 54.62           N  
ATOM    914  CA  SER   127      44.147  10.597 -15.831  1.00 54.86           C  
ATOM    915  C   SER   127      45.267  11.425 -15.241  1.00 53.47           C  
ATOM    916  O   SER   127      46.381  10.950 -15.131  1.00 55.47           O  
ATOM    917  CB  SER   127      44.094  10.894 -17.332  1.00 54.90           C  
ATOM    918  OG  SER   127      43.186  10.041 -17.993  1.00 61.83           O  
ATOM    919  N   LEU   128      44.978  12.684 -14.919  1.00 52.40           N  
ATOM    920  CA  LEU   128      45.966  13.574 -14.325  1.00 50.90           C  
ATOM    921  C   LEU   128      46.372  13.016 -12.972  1.00 51.93           C  
ATOM    922  O   LEU   128      47.555  12.994 -12.633  1.00 53.62           O  
ATOM    923  CB  LEU   128      45.395  14.980 -14.198  1.00 51.03           C  
ATOM    924  CG  LEU   128      46.234  16.105 -13.596  1.00 49.96           C  
ATOM    925  CD1 LEU   128      47.568  16.259 -14.343  1.00 56.86           C  
ATOM    926  CD2 LEU   128      45.413  17.380 -13.639  1.00 50.06           C  
ATOM    927  N   ALA   129      45.385  12.556 -12.208  1.00 51.61           N  
ATOM    928  CA  ALA   129      45.632  11.936 -10.915  1.00 51.88           C  
ATOM    929  C   ALA   129      46.487  10.673 -11.099  1.00 52.40           C  
ATOM    930  O   ALA   129      47.434  10.443 -10.339  1.00 50.89           O  
ATOM    931  CB  ALA   129      44.296  11.596 -10.207  1.00 50.63           C  
ATOM    932  N   GLU   130      46.137   9.856 -12.094  1.00 53.27           N  
ATOM    933  CA  GLU   130      46.895   8.632 -12.398  1.00 54.20           C  
ATOM    934  C   GLU   130      48.324   8.963 -12.851  1.00 54.83           C  
ATOM    935  O   GLU   130      49.264   8.333 -12.362  1.00 54.37           O  
ATOM    936  CB  GLU   130      46.193   7.791 -13.462  1.00 52.41           C  
ATOM    937  N   ARG   131      48.492   9.955 -13.743  1.00 55.42           N  
ATOM    938  CA  ARG   131      49.840  10.356 -14.250  1.00 56.32           C  
ATOM    939  C   ARG   131      50.738  10.829 -13.114  1.00 55.67           C  
ATOM    940  O   ARG   131      51.926  10.576 -13.118  1.00 56.70           O  
ATOM    941  CB  ARG   131      49.758  11.431 -15.348  1.00 56.34           C  
ATOM    942  CG  ARG   131      49.050  10.967 -16.660  1.00 62.98           C  
ATOM    943  CD  ARG   131      48.982  12.092 -17.710  1.00 61.66           C  
ATOM    944  NE  ARG   131      48.426  13.344 -17.177  1.00 64.09           N  
ATOM    945  N   ASN   132      50.177  11.568 -12.168  1.00 56.65           N  
ATOM    946  CA  ASN   132      50.895  11.901 -10.943  1.00 56.97           C  
ATOM    947  C   ASN   132      50.559  10.651 -10.117  1.00 58.00           C  
ATOM    948  O   ASN   132      49.869   9.779 -10.637  1.00 59.78           O  
ATOM    949  CB  ASN   132      50.415  13.238 -10.413  1.00 57.33           C  
ATOM    950  CG  ASN   132      50.664  14.355 -11.420  1.00 57.24           C  
ATOM    951  OD1 ASN   132      51.786  14.816 -11.570  1.00 61.01           O  
ATOM    952  ND2 ASN   132      49.626  14.760 -12.140  1.00 60.01           N  
ATOM    953  N   GLY   133      51.018  10.477  -8.889  1.00 57.07           N  
ATOM    954  CA  GLY   133      50.747   9.159  -8.251  1.00 56.86           C  
ATOM    955  C   GLY   133      49.713   9.238  -7.162  1.00 56.82           C  
ATOM    956  O   GLY   133      49.919   8.703  -6.070  1.00 58.77           O  
ATOM    957  N   VAL   134      48.579   9.858  -7.474  1.00 53.08           N  
ATOM    958  CA  VAL   134      47.616  10.206  -6.441  1.00 51.32           C  
ATOM    959  C   VAL   134      46.175   9.874  -6.828  1.00 50.72           C  
ATOM    960  O   VAL   134      45.910   9.435  -7.945  1.00 48.58           O  
ATOM    961  CB  VAL   134      47.796  11.703  -6.057  1.00 51.01           C  
ATOM    962  CG1 VAL   134      49.012  11.872  -5.150  1.00 54.40           C  
ATOM    963  CG2 VAL   134      47.930  12.580  -7.305  1.00 45.88           C  
ATOM    964  N   ARG   135      45.268  10.139  -5.895  0.50 49.42           N  
ATOM    966  CA  ARG   135      43.865   9.791  -6.030  0.50 48.64           C  
ATOM    968  C   ARG   135      42.945  11.001  -6.034  0.50 49.96           C  
ATOM    970  O   ARG   135      43.253  12.019  -5.408  0.50 49.55           O  
ATOM    972  CB  ARG   135      43.520   8.818  -4.889  0.50 49.07           C  
ATOM    974  CG  ARG   135      44.238   7.447  -5.089  0.50 42.86           C  
ATOM    976  CD  ARG   135      44.600   6.726  -3.784  0.50 47.77           C  
ATOM    978  NE  ARG   135      43.639   5.901  -3.034  0.50 45.67           N  
ATOM    980  CZ  ARG   135      42.520   5.335  -3.464  0.50 34.61           C  
ATOM    982  NH1 ARG   135      42.107   5.428  -4.715  0.50 49.68           N  
ATOM    984  NH2 ARG   135      41.807   4.612  -2.611  0.50 41.15           N  
ATOM    986  N   LEU   136      41.850  10.901  -6.803  1.00 51.89           N  
ATOM    987  CA  LEU   136      40.819  11.910  -6.827  1.00 50.18           C  
ATOM    988  C   LEU   136      39.542  11.204  -6.338  1.00 49.36           C  
ATOM    989  O   LEU   136      38.971  10.354  -7.025  1.00 47.37           O  
ATOM    990  CB  LEU   136      40.644  12.459  -8.244  1.00 48.45           C  
ATOM    991  CG  LEU   136      39.474  13.415  -8.427  1.00 52.91           C  
ATOM    992  CD1 LEU   136      39.544  14.575  -7.432  1.00 49.89           C  
ATOM    993  CD2 LEU   136      39.446  13.914  -9.835  1.00 50.66           C  
ATOM    994  N   MET   137      39.124  11.584  -5.133  1.00 49.57           N  
ATOM    995  CA  MET   137      37.985  11.000  -4.440  1.00 47.97           C  
ATOM    996  C   MET   137      36.838  11.987  -4.519  1.00 47.50           C  
ATOM    997  O   MET   137      37.051  13.185  -4.449  1.00 47.68           O  
ATOM    998  CB  MET   137      38.368  10.700  -2.991  1.00 48.53           C  
ATOM    999  CG  MET   137      39.656   9.905  -2.862  1.00 42.73           C  
ATOM   1000  SD  MET   137      39.679   8.179  -3.673  0.75 46.98          SE  
ATOM   1001  CE  MET   137      38.432   7.168  -2.288  1.00 38.10           C  
ATOM   1002  N   TYR   138      35.630  11.460  -4.661  1.00 48.91           N  
ATOM   1003  CA  TYR   138      34.475  12.256  -4.923  1.00 47.22           C  
ATOM   1004  C   TYR   138      33.151  11.698  -4.424  1.00 47.83           C  
ATOM   1005  O   TYR   138      32.087  12.015  -4.959  1.00 45.61           O  
ATOM   1006  CB  TYR   138      34.424  12.553  -6.412  1.00 44.71           C  
ATOM   1007  CG  TYR   138      34.385  11.379  -7.364  1.00 46.33           C  
ATOM   1008  CD1 TYR   138      35.546  10.696  -7.704  1.00 52.94           C  
ATOM   1009  CD2 TYR   138      33.214  11.025  -8.019  1.00 44.16           C  
ATOM   1010  CE1 TYR   138      35.532   9.650  -8.594  1.00 43.58           C  
ATOM   1011  CE2 TYR   138      33.201  10.003  -8.915  1.00 46.47           C  
ATOM   1012  CZ  TYR   138      34.374   9.332  -9.212  1.00 48.02           C  
ATOM   1013  OH  TYR   138      34.369   8.298 -10.104  1.00 46.71           O  
ATOM   1014  N   GLU   139      33.216  10.954  -3.334  1.00 45.83           N  
ATOM   1015  CA  GLU   139      32.017  10.400  -2.731  1.00 47.57           C  
ATOM   1016  C   GLU   139      30.970  11.444  -2.426  1.00 49.18           C  
ATOM   1017  O   GLU   139      29.768  11.190  -2.572  1.00 50.54           O  
ATOM   1018  CB  GLU   139      32.335   9.668  -1.414  1.00 48.35           C  
ATOM   1019  CG  GLU   139      31.164   8.835  -0.884  1.00 47.00           C  
ATOM   1020  CD  GLU   139      30.758   7.711  -1.860  1.00 43.98           C  
ATOM   1021  OE1 GLU   139      31.478   6.693  -1.942  1.00 46.77           O  
ATOM   1022  OE2 GLU   139      29.693   7.834  -2.501  1.00 51.48           O  
ATOM   1023  N   ALA   140      31.410  12.632  -2.008  1.00 47.25           N  
ATOM   1024  CA  ALA   140      30.466  13.630  -1.608  1.00 46.58           C  
ATOM   1025  C   ALA   140      29.757  14.314  -2.779  1.00 47.40           C  
ATOM   1026  O   ALA   140      28.847  15.054  -2.526  1.00 48.49           O  
ATOM   1027  CB  ALA   140      31.140  14.651  -0.721  1.00 44.92           C  
ATOM   1028  N   THR   141      30.195  14.090  -4.022  1.00 46.91           N  
ATOM   1029  CA  THR   141      29.588  14.714  -5.207  1.00 48.12           C  
ATOM   1030  C   THR   141      28.202  14.200  -5.568  1.00 50.80           C  
ATOM   1031  O   THR   141      27.416  14.944  -6.177  1.00 51.29           O  
ATOM   1032  CB  THR   141      30.478  14.659  -6.488  1.00 47.24           C  
ATOM   1033  OG1 THR   141      30.723  13.294  -6.859  1.00 48.28           O  
ATOM   1034  CG2 THR   141      31.825  15.414  -6.262  1.00 43.30           C  
ATOM   1035  N   VAL   142      27.914  12.957  -5.200  1.00 53.48           N  
ATOM   1036  CA  VAL   142      26.622  12.313  -5.469  1.00 53.95           C  
ATOM   1037  C   VAL   142      26.171  11.369  -4.346  1.00 54.69           C  
ATOM   1038  O   VAL   142      26.930  10.513  -3.878  1.00 55.37           O  
ATOM   1039  CB  VAL   142      26.618  11.611  -6.854  1.00 54.18           C  
ATOM   1040  CG1 VAL   142      27.955  10.999  -7.161  1.00 57.67           C  
ATOM   1041  CG2 VAL   142      25.479  10.619  -6.943  1.00 52.95           C  
ATOM   1042  N   GLY   143      24.958  11.600  -3.856  1.00 52.14           N  
ATOM   1043  CA  GLY   143      24.374  10.750  -2.838  1.00 50.98           C  
ATOM   1044  C   GLY   143      24.609  11.204  -1.432  1.00 51.28           C  
ATOM   1045  O   GLY   143      24.085  10.613  -0.496  1.00 55.26           O  
ATOM   1046  N   GLY   144      25.396  12.256  -1.251  1.00 52.65           N  
ATOM   1047  CA  GLY   144      25.723  12.698   0.083  1.00 51.40           C  
ATOM   1048  C   GLY   144      26.376  11.565   0.871  1.00 50.65           C  
ATOM   1049  O   GLY   144      27.388  11.001   0.447  1.00 48.18           O  
ATOM   1050  N   ALA   145      25.768  11.212   2.002  1.00 51.56           N  
ATOM   1051  CA  ALA   145      26.327  10.204   2.909  1.00 52.26           C  
ATOM   1052  C   ALA   145      26.139   8.777   2.348  1.00 53.05           C  
ATOM   1053  O   ALA   145      26.863   7.857   2.708  1.00 53.99           O  
ATOM   1054  CB  ALA   145      25.677  10.322   4.270  1.00 50.99           C  
ATOM   1055  N   MET   146      25.158   8.618   1.462  1.00 50.60           N  
ATOM   1056  CA  MET   146      24.891   7.368   0.851  1.00 50.52           C  
ATOM   1057  C   MET   146      26.084   6.894   0.012  1.00 50.64           C  
ATOM   1058  O   MET   146      26.504   7.577  -0.892  1.00 48.54           O  
ATOM   1059  CB  MET   146      23.694   7.542  -0.055  1.00 51.68           C  
ATOM   1060  CG  MET   146      23.106   6.288  -0.514  1.00 53.42           C  
ATOM   1061  SD  MET   146      21.639   6.652  -1.726  0.75 51.40          SE  
ATOM   1062  CE  MET   146      22.421   7.137  -3.397  1.00 41.76           C  
ATOM   1063  N   PRO   147      26.590   5.680   0.272  1.00 55.27           N  
ATOM   1064  CA  PRO   147      27.666   5.168  -0.554  1.00 59.57           C  
ATOM   1065  C   PRO   147      27.109   4.969  -1.970  1.00 62.01           C  
ATOM   1066  O   PRO   147      26.020   4.430  -2.168  1.00 69.27           O  
ATOM   1067  CB  PRO   147      27.996   3.825   0.115  1.00 62.74           C  
ATOM   1068  CG  PRO   147      26.726   3.399   0.712  1.00 58.36           C  
ATOM   1069  CD  PRO   147      26.153   4.675   1.262  1.00 57.17           C  
ATOM   1070  N   VAL   148      27.811   5.458  -2.944  1.00 58.57           N  
ATOM   1071  CA  VAL   148      27.372   5.354  -4.306  1.00 57.54           C  
ATOM   1072  C   VAL   148      28.616   5.216  -5.127  1.00 54.59           C  
ATOM   1073  O   VAL   148      28.723   4.308  -5.944  1.00 52.23           O  
ATOM   1074  CB  VAL   148      26.547   6.614  -4.724  1.00 60.30           C  
ATOM   1075  CG1 VAL   148      26.965   7.147  -6.068  1.00 66.42           C  
ATOM   1076  CG2 VAL   148      25.075   6.275  -4.725  1.00 68.44           C  
ATOM   1077  N   VAL   149      29.574   6.114  -4.890  1.00 52.03           N  
ATOM   1078  CA  VAL   149      30.798   6.115  -5.672  1.00 51.15           C  
ATOM   1079  C   VAL   149      31.675   4.920  -5.288  1.00 50.57           C  
ATOM   1080  O   VAL   149      32.071   4.145  -6.167  1.00 45.42           O  
ATOM   1081  CB  VAL   149      31.546   7.468  -5.571  1.00 53.38           C  
ATOM   1082  CG1 VAL   149      32.893   7.384  -6.303  1.00 49.14           C  
ATOM   1083  CG2 VAL   149      30.649   8.600  -6.096  1.00 47.53           C  
ATOM   1084  N   LYS   150      31.952   4.755  -3.989  1.00 48.79           N  
ATOM   1085  CA  LYS   150      32.784   3.626  -3.512  1.00 49.43           C  
ATOM   1086  C   LYS   150      32.095   2.320  -3.764  1.00 47.11           C  
ATOM   1087  O   LYS   150      32.760   1.332  -4.023  1.00 46.70           O  
ATOM   1088  CB  LYS   150      33.287   3.796  -2.039  1.00 47.93           C  
ATOM   1089  CG  LYS   150      34.373   4.877  -1.975  1.00 54.17           C  
ATOM   1090  CD  LYS   150      35.164   5.020  -0.677  1.00 51.38           C  
ATOM   1091  CE  LYS   150      34.367   5.564   0.440  1.00 49.40           C  
ATOM   1092  NZ  LYS   150      33.730   6.839   0.047  1.00 45.36           N  
ATOM   1093  N   LEU   151      30.766   2.343  -3.813  1.00 47.45           N  
ATOM   1094  CA  LEU   151      29.981   1.164  -4.115  1.00 50.05           C  
ATOM   1095  C   LEU   151      30.137   0.788  -5.590  1.00 50.80           C  
ATOM   1096  O   LEU   151      30.518  -0.323  -5.894  1.00 50.90           O  
ATOM   1097  CB  LEU   151      28.510   1.423  -3.788  1.00 50.10           C  
ATOM   1098  CG  LEU   151      27.572   0.282  -3.453  1.00 53.83           C  
ATOM   1099  CD1 LEU   151      28.191  -0.557  -2.376  1.00 52.95           C  
ATOM   1100  CD2 LEU   151      26.256   0.818  -2.940  1.00 51.54           C  
ATOM   1101  N   ALA   152      29.828   1.712  -6.498  1.00 51.01           N  
ATOM   1102  CA  ALA   152      30.003   1.494  -7.945  1.00 51.04           C  
ATOM   1103  C   ALA   152      31.442   1.116  -8.305  1.00 53.77           C  
ATOM   1104  O   ALA   152      31.685   0.143  -9.005  1.00 60.02           O  
ATOM   1105  CB  ALA   152      29.575   2.740  -8.712  1.00 52.32           C  
ATOM   1106  N   LYS   153      32.398   1.805  -7.706  1.00 54.40           N  
ATOM   1107  CA  LYS   153      33.807   1.695  -8.037  1.00 53.36           C  
ATOM   1108  C   LYS   153      34.665   0.702  -7.258  1.00 55.14           C  
ATOM   1109  O   LYS   153      35.620   0.158  -7.812  1.00 57.79           O  
ATOM   1110  CB  LYS   153      34.377   3.115  -7.900  1.00 54.63           C  
ATOM   1111  CG  LYS   153      35.746   3.330  -8.418  1.00 58.39           C  
ATOM   1112  CD  LYS   153      36.106   4.819  -8.468  1.00 52.71           C  
ATOM   1113  CE  LYS   153      37.502   4.973  -9.105  1.00 61.35           C  
ATOM   1114  NZ  LYS   153      37.926   6.379  -9.270  1.00 66.54           N  
ATOM   1115  N   ARG   154      34.395   0.477  -5.980  1.00 54.31           N  
ATOM   1116  CA  ARG   154      35.188  -0.505  -5.228  1.00 54.23           C  
ATOM   1117  C   ARG   154      34.476  -1.840  -4.948  1.00 55.81           C  
ATOM   1118  O   ARG   154      34.992  -2.916  -5.324  1.00 57.05           O  
ATOM   1119  CB  ARG   154      35.708   0.073  -3.925  1.00 54.10           C  
ATOM   1120  CG  ARG   154      36.583   1.271  -4.109  1.00 57.75           C  
ATOM   1121  CD  ARG   154      37.445   1.469  -2.909  1.00 70.09           C  
ATOM   1122  NE  ARG   154      38.334   0.318  -2.732  1.00 74.67           N  
ATOM   1123  CZ  ARG   154      39.451   0.100  -3.430  1.00 77.44           C  
ATOM   1124  NH1 ARG   154      39.846   0.949  -4.379  1.00 81.46           N  
ATOM   1125  NH2 ARG   154      40.178  -0.983  -3.187  1.00 76.63           N  
ATOM   1126  N   TYR   155      33.295  -1.785  -4.322  0.50 54.71           N  
ATOM   1128  CA  TYR   155      32.536  -3.010  -4.014  0.50 53.40           C  
ATOM   1130  C   TYR   155      32.141  -3.747  -5.269  0.50 54.30           C  
ATOM   1132  O   TYR   155      32.419  -4.925  -5.428  0.50 53.99           O  
ATOM   1134  CB  TYR   155      31.255  -2.734  -3.218  0.50 51.83           C  
ATOM   1136  CG  TYR   155      30.583  -4.021  -2.795  0.50 43.29           C  
ATOM   1138  CD1 TYR   155      31.041  -4.726  -1.709  0.50 41.08           C  
ATOM   1140  CD2 TYR   155      29.518  -4.539  -3.500  0.50 48.09           C  
ATOM   1142  CE1 TYR   155      30.462  -5.905  -1.330  0.50 48.06           C  
ATOM   1144  CE2 TYR   155      28.924  -5.719  -3.138  0.50 42.41           C  
ATOM   1146  CZ  TYR   155      29.397  -6.402  -2.040  0.50 45.37           C  
ATOM   1148  OH  TYR   155      28.828  -7.589  -1.643  0.50 44.65           O  
ATOM   1150  N   LEU   156      31.501  -3.034  -6.177  1.00 55.32           N  
ATOM   1151  CA  LEU   156      31.031  -3.657  -7.435  1.00 56.06           C  
ATOM   1152  C   LEU   156      32.119  -3.608  -8.588  1.00 57.02           C  
ATOM   1153  O   LEU   156      31.785  -3.715  -9.780  1.00 59.87           O  
ATOM   1154  CB  LEU   156      29.713  -2.989  -7.882  1.00 55.67           C  
ATOM   1155  CG  LEU   156      28.350  -3.341  -7.236  1.00 60.67           C  
ATOM   1156  CD1 LEU   156      28.451  -3.636  -5.794  1.00 66.28           C  
ATOM   1157  CD2 LEU   156      27.290  -2.228  -7.457  1.00 57.19           C  
ATOM   1158  N   ALA   157      33.400  -3.468  -8.226  1.00 56.54           N  
ATOM   1159  CA  ALA   157      34.521  -3.350  -9.184  1.00 56.55           C  
ATOM   1160  C   ALA   157      34.622  -4.450 -10.263  1.00 59.66           C  
ATOM   1161  O   ALA   157      34.781  -4.134 -11.446  1.00 61.89           O  
ATOM   1162  CB  ALA   157      35.839  -3.295  -8.418  1.00 55.50           C  
ATOM   1163  N   LEU   158      34.555  -5.728  -9.864  1.00 56.71           N  
ATOM   1164  CA  LEU   158      34.674  -6.827 -10.825  1.00 55.58           C  
ATOM   1165  C   LEU   158      33.330  -7.304 -11.373  1.00 53.88           C  
ATOM   1166  O   LEU   158      33.243  -8.387 -11.927  1.00 54.06           O  
ATOM   1167  CB  LEU   158      35.522  -7.974 -10.251  1.00 52.64           C  
ATOM   1168  CG  LEU   158      36.933  -7.510  -9.841  1.00 55.52           C  
ATOM   1169  CD1 LEU   158      37.710  -8.657  -9.185  1.00 48.73           C  
ATOM   1170  CD2 LEU   158      37.732  -6.940 -11.023  1.00 52.52           C  
ATOM   1171  N   CYS   159      32.288  -6.496 -11.200  1.00 56.59           N  
ATOM   1172  CA  CYS   159      30.969  -6.723 -11.822  1.00 59.68           C  
ATOM   1173  C   CYS   159      30.829  -5.783 -12.996  1.00 61.90           C  
ATOM   1174  O   CYS   159      31.402  -4.686 -13.006  1.00 62.77           O  
ATOM   1175  CB  CYS   159      29.800  -6.251 -10.943  1.00 61.49           C  
ATOM   1176  SG  CYS   159      29.435  -7.136  -9.519  1.00 64.20           S  
ATOM   1177  N   GLU   160      29.971  -6.169 -13.921  1.00 61.80           N  
ATOM   1178  CA  GLU   160      29.610  -5.314 -15.002  1.00 63.32           C  
ATOM   1179  C   GLU   160      28.327  -4.673 -14.491  1.00 59.95           C  
ATOM   1180  O   GLU   160      27.312  -5.341 -14.330  1.00 58.39           O  
ATOM   1181  CB  GLU   160      29.344  -6.146 -16.256  1.00 65.37           C  
ATOM   1182  CG  GLU   160      29.285  -5.391 -17.590  1.00 70.26           C  
ATOM   1183  CD  GLU   160      28.942  -6.339 -18.739  1.00 72.53           C  
ATOM   1184  OE1 GLU   160      27.785  -6.829 -18.776  1.00 88.10           O  
ATOM   1185  OE2 GLU   160      29.825  -6.598 -19.602  1.00 88.52           O  
ATOM   1186  N   ILE   161      28.384  -3.387 -14.175  1.00 59.80           N  
ATOM   1187  CA  ILE   161      27.187  -2.659 -13.768  1.00 57.54           C  
ATOM   1188  C   ILE   161      26.499  -2.299 -15.053  1.00 58.17           C  
ATOM   1189  O   ILE   161      27.023  -1.517 -15.833  1.00 60.25           O  
ATOM   1190  CB  ILE   161      27.495  -1.412 -12.991  1.00 56.04           C  
ATOM   1191  CG1 ILE   161      28.227  -1.781 -11.711  1.00 52.54           C  
ATOM   1192  CG2 ILE   161      26.190  -0.668 -12.657  1.00 55.86           C  
ATOM   1193  CD1 ILE   161      28.695  -0.602 -10.903  1.00 50.27           C  
ATOM   1194  N   GLU   162      25.334  -2.887 -15.275  1.00 57.24           N  
ATOM   1195  CA  GLU   162      24.576  -2.677 -16.487  1.00 58.11           C  
ATOM   1196  C   GLU   162      23.718  -1.408 -16.454  1.00 57.49           C  
ATOM   1197  O   GLU   162      23.480  -0.797 -17.494  1.00 59.56           O  
ATOM   1198  CB  GLU   162      23.697  -3.889 -16.727  1.00 57.98           C  
ATOM   1199  CG  GLU   162      24.499  -5.191 -16.812  1.00 62.57           C  
ATOM   1200  CD  GLU   162      23.610  -6.411 -16.803  1.00 64.20           C  
ATOM   1201  OE1 GLU   162      22.363  -6.256 -16.710  1.00 79.58           O  
ATOM   1202  OE2 GLU   162      24.159  -7.536 -16.893  1.00 79.67           O  
ATOM   1203  N   SER   163      23.227  -1.024 -15.281  1.00 55.55           N  
ATOM   1204  CA  SER   163      22.434   0.196 -15.163  1.00 53.26           C  
ATOM   1205  C   SER   163      22.339   0.681 -13.745  1.00 53.60           C  
ATOM   1206  O   SER   163      22.535  -0.078 -12.796  1.00 51.06           O  
ATOM   1207  CB  SER   163      21.015  -0.012 -15.689  1.00 54.07           C  
ATOM   1208  OG  SER   163      20.234  -0.788 -14.798  1.00 55.86           O  
ATOM   1209  N   VAL   164      22.066   1.972 -13.619  1.00 53.90           N  
ATOM   1210  CA  VAL   164      21.791   2.593 -12.351  1.00 52.14           C  
ATOM   1211  C   VAL   164      20.548   3.461 -12.555  1.00 53.15           C  
ATOM   1212  O   VAL   164      20.476   4.212 -13.504  1.00 53.64           O  
ATOM   1213  CB  VAL   164      22.943   3.463 -11.847  1.00 53.97           C  
ATOM   1214  CG1 VAL   164      22.580   4.024 -10.475  1.00 47.02           C  
ATOM   1215  CG2 VAL   164      24.252   2.669 -11.801  1.00 49.17           C  
ATOM   1216  N   LYS   165      19.550   3.286 -11.700  1.00 50.54           N  
ATOM   1217  CA  LYS   165      18.361   4.096 -11.694  1.00 50.85           C  
ATOM   1218  C   LYS   165      18.305   4.638 -10.285  1.00 49.44           C  
ATOM   1219  O   LYS   165      18.298   3.869  -9.361  1.00 51.81           O  
ATOM   1220  CB  LYS   165      17.078   3.267 -11.907  1.00 48.82           C  
ATOM   1221  CG  LYS   165      16.852   2.702 -13.298  1.00 58.14           C  
ATOM   1222  CD  LYS   165      15.757   1.614 -13.278  1.00 56.98           C  
ATOM   1223  CE  LYS   165      15.609   0.870 -14.656  1.00 62.75           C  
ATOM   1224  N   GLY   166      18.215   5.940 -10.096  1.00 50.52           N  
ATOM   1225  CA  GLY   166      18.076   6.433  -8.737  1.00 52.09           C  
ATOM   1226  C   GLY   166      17.413   7.776  -8.608  1.00 50.03           C  
ATOM   1227  O   GLY   166      16.976   8.384  -9.574  1.00 50.54           O  
ATOM   1228  N   ILE   167      17.360   8.196  -7.363  1.00 50.68           N  
ATOM   1229  CA  ILE   167      16.806   9.440  -6.913  1.00 48.61           C  
ATOM   1230  C   ILE   167      18.001  10.209  -6.380  1.00 47.71           C  
ATOM   1231  O   ILE   167      18.515   9.831  -5.339  1.00 48.18           O  
ATOM   1232  CB  ILE   167      15.807   9.155  -5.766  1.00 48.07           C  
ATOM   1233  CG1 ILE   167      14.529   8.498  -6.338  1.00 50.59           C  
ATOM   1234  CG2 ILE   167      15.538  10.450  -4.952  1.00 43.73           C  
ATOM   1235  CD1 ILE   167      13.550   8.006  -5.275  1.00 50.03           C  
ATOM   1236  N   PHE   168      18.457  11.255  -7.076  1.00 49.17           N  
ATOM   1237  CA  PHE   168      19.643  11.994  -6.629  1.00 53.28           C  
ATOM   1238  C   PHE   168      19.449  13.446  -6.169  1.00 53.86           C  
ATOM   1239  O   PHE   168      20.428  14.171  -5.955  1.00 56.61           O  
ATOM   1240  CB  PHE   168      20.742  11.946  -7.665  1.00 55.25           C  
ATOM   1241  CG  PHE   168      21.126  10.555  -8.061  1.00 60.38           C  
ATOM   1242  CD1 PHE   168      21.444   9.618  -7.095  1.00 55.13           C  
ATOM   1243  CD2 PHE   168      21.242  10.209  -9.403  1.00 64.34           C  
ATOM   1244  CE1 PHE   168      21.818   8.343  -7.445  1.00 62.51           C  
ATOM   1245  CE2 PHE   168      21.631   8.925  -9.766  1.00 65.66           C  
ATOM   1246  CZ  PHE   168      21.889   7.986  -8.783  1.00 61.09           C  
ATOM   1247  N   ASN   169      18.208  13.835  -5.936  1.00 50.08           N  
ATOM   1248  CA  ASN   169      17.913  15.167  -5.468  1.00 49.52           C  
ATOM   1249  C   ASN   169      16.835  15.097  -4.392  1.00 49.88           C  
ATOM   1250  O   ASN   169      15.668  14.786  -4.680  1.00 47.54           O  
ATOM   1251  CB  ASN   169      17.444  16.047  -6.615  1.00 50.62           C  
ATOM   1252  CG  ASN   169      17.304  17.487  -6.203  1.00 56.69           C  
ATOM   1253  OD1 ASN   169      16.187  17.970  -5.928  1.00 59.40           O  
ATOM   1254  ND2 ASN   169      18.438  18.169  -6.081  1.00 49.38           N  
ATOM   1255  N   GLY   170      17.250  15.344  -3.149  1.00 49.57           N  
ATOM   1256  CA  GLY   170      16.328  15.345  -2.010  1.00 48.89           C  
ATOM   1257  C   GLY   170      15.186  16.344  -2.083  1.00 50.94           C  
ATOM   1258  O   GLY   170      14.064  16.056  -1.634  1.00 54.52           O  
ATOM   1259  N   THR   171      15.461  17.532  -2.608  1.00 51.55           N  
ATOM   1260  CA  THR   171      14.452  18.594  -2.699  1.00 51.75           C  
ATOM   1261  C   THR   171      13.273  18.219  -3.600  1.00 48.23           C  
ATOM   1262  O   THR   171      12.120  18.396  -3.208  1.00 51.94           O  
ATOM   1263  CB  THR   171      15.096  19.923  -3.121  1.00 51.47           C  
ATOM   1264  OG1 THR   171      16.043  20.287  -2.117  1.00 54.73           O  
ATOM   1265  CG2 THR   171      14.038  21.044  -3.258  1.00 49.75           C  
ATOM   1266  N   CYS   172      13.551  17.705  -4.788  1.00 47.31           N  
ATOM   1267  CA  CYS   172      12.497  17.214  -5.672  1.00 50.28           C  
ATOM   1268  C   CYS   172      11.789  16.024  -5.055  1.00 50.89           C  
ATOM   1269  O   CYS   172      10.593  15.883  -5.205  1.00 52.21           O  
ATOM   1270  CB  CYS   172      13.058  16.770  -7.016  1.00 51.40           C  
ATOM   1271  SG  CYS   172      13.781  18.090  -7.952  1.00 62.23           S  
ATOM   1272  N   ASN   173      12.520  15.163  -4.345  1.00 51.55           N  
ATOM   1273  CA  ASN   173      11.874  14.014  -3.749  1.00 50.79           C  
ATOM   1274  C   ASN   173      10.907  14.494  -2.683  1.00 49.78           C  
ATOM   1275  O   ASN   173       9.780  14.000  -2.573  1.00 51.45           O  
ATOM   1276  CB  ASN   173      12.862  12.977  -3.160  1.00 48.42           C  
ATOM   1277  CG  ASN   173      12.263  11.591  -3.178  1.00 49.97           C  
ATOM   1278  OD1 ASN   173      12.061  11.052  -4.259  1.00 50.87           O  
ATOM   1279  ND2 ASN   173      11.912  11.032  -2.010  1.00 48.67           N  
ATOM   1280  N   TYR   174      11.345  15.473  -1.910  1.00 48.66           N  
ATOM   1281  CA  TYR   174      10.493  16.058  -0.873  1.00 49.81           C  
ATOM   1282  C   TYR   174       9.258  16.724  -1.488  1.00 48.59           C  
ATOM   1283  O   TYR   174       8.148  16.559  -1.001  1.00 48.45           O  
ATOM   1284  CB  TYR   174      11.280  17.093  -0.040  1.00 50.52           C  
ATOM   1285  CG  TYR   174      10.400  17.838   0.950  1.00 54.37           C  
ATOM   1286  CD1 TYR   174      10.127  17.311   2.196  1.00 49.94           C  
ATOM   1287  CD2 TYR   174       9.821  19.058   0.610  1.00 54.64           C  
ATOM   1288  CE1 TYR   174       9.282  17.977   3.083  1.00 58.48           C  
ATOM   1289  CE2 TYR   174       9.005  19.735   1.476  1.00 51.60           C  
ATOM   1290  CZ  TYR   174       8.726  19.194   2.719  1.00 57.19           C  
ATOM   1291  OH  TYR   174       7.888  19.867   3.593  1.00 55.85           O  
ATOM   1292  N   ILE   175       9.463  17.510  -2.541  1.00 50.25           N  
ATOM   1293  CA  ILE   175       8.360  18.244  -3.157  1.00 51.12           C  
ATOM   1294  C   ILE   175       7.298  17.276  -3.693  1.00 49.03           C  
ATOM   1295  O   ILE   175       6.111  17.472  -3.486  1.00 47.68           O  
ATOM   1296  CB  ILE   175       8.845  19.265  -4.238  1.00 50.51           C  
ATOM   1297  CG1 ILE   175       9.587  20.428  -3.556  1.00 56.75           C  
ATOM   1298  CG2 ILE   175       7.646  19.785  -5.041  1.00 50.40           C  
ATOM   1299  CD1 ILE   175      10.293  21.433  -4.496  1.00 52.24           C  
ATOM   1300  N   LEU   176       7.746  16.224  -4.356  1.00 50.24           N  
ATOM   1301  CA  LEU   176       6.846  15.197  -4.892  1.00 48.11           C  
ATOM   1302  C   LEU   176       6.146  14.396  -3.775  1.00 47.17           C  
ATOM   1303  O   LEU   176       4.947  14.184  -3.846  1.00 47.47           O  
ATOM   1304  CB  LEU   176       7.610  14.299  -5.857  1.00 46.39           C  
ATOM   1305  CG  LEU   176       8.149  14.968  -7.122  1.00 50.90           C  
ATOM   1306  CD1 LEU   176       9.070  14.008  -7.864  1.00 47.93           C  
ATOM   1307  CD2 LEU   176       6.983  15.471  -8.048  1.00 40.04           C  
ATOM   1308  N   SER   177       6.876  13.961  -2.747  1.00 48.51           N  
ATOM   1309  CA  SER   177       6.260  13.258  -1.586  1.00 50.08           C  
ATOM   1310  C   SER   177       5.239  14.115  -0.880  1.00 47.81           C  
ATOM   1311  O   SER   177       4.202  13.645  -0.454  1.00 48.79           O  
ATOM   1312  CB  SER   177       7.300  12.921  -0.525  1.00 50.57           C  
ATOM   1313  OG  SER   177       8.221  12.006  -1.027  1.00 61.77           O  
ATOM   1314  N   ARG   178       5.583  15.380  -0.719  1.00 48.42           N  
ATOM   1315  CA  ARG   178       4.713  16.333  -0.051  1.00 47.43           C  
ATOM   1316  C   ARG   178       3.465  16.603  -0.904  1.00 46.52           C  
ATOM   1317  O   ARG   178       2.338  16.681  -0.393  1.00 45.49           O  
ATOM   1318  CB  ARG   178       5.493  17.621   0.221  1.00 47.04           C  
ATOM   1319  CG  ARG   178       4.848  18.508   1.208  1.00 56.97           C  
ATOM   1320  CD  ARG   178       5.183  18.038   2.594  1.00 68.09           C  
ATOM   1321  NE  ARG   178       4.508  18.837   3.606  1.00 68.53           N  
ATOM   1322  CZ  ARG   178       3.527  18.390   4.384  1.00 75.35           C  
ATOM   1323  NH1 ARG   178       3.128  17.121   4.313  1.00 77.00           N  
ATOM   1324  NH2 ARG   178       2.968  19.210   5.274  1.00 71.97           N  
ATOM   1325  N   MET   179       3.658  16.766  -2.208  1.00 47.62           N  
ATOM   1326  CA  MET   179       2.519  16.939  -3.122  1.00 48.36           C  
ATOM   1327  C   MET   179       1.618  15.713  -3.112  1.00 48.14           C  
ATOM   1328  O   MET   179       0.399  15.833  -3.217  1.00 51.18           O  
ATOM   1329  CB  MET   179       3.000  17.205  -4.542  1.00 45.91           C  
ATOM   1330  CG  MET   179       1.840  17.597  -5.483  1.00 56.49           C  
ATOM   1331  SD  MET   179       2.441  18.167  -7.258  0.75 54.81          SE  
ATOM   1332  CE  MET   179       3.997  19.219  -6.628  1.00 45.84           C  
ATOM   1333  N   GLU   180       2.210  14.528  -3.009  1.00 50.05           N  
ATOM   1334  CA  GLU   180       1.427  13.294  -2.941  1.00 51.64           C  
ATOM   1335  C   GLU   180       0.542  13.294  -1.715  1.00 49.64           C  
ATOM   1336  O   GLU   180      -0.611  12.941  -1.776  1.00 52.27           O  
ATOM   1337  CB  GLU   180       2.357  12.069  -2.866  1.00 51.90           C  
ATOM   1338  CG  GLU   180       1.658  10.718  -2.586  1.00 55.71           C  
ATOM   1339  CD  GLU   180       0.995  10.086  -3.817  1.00 66.02           C  
ATOM   1340  OE1 GLU   180      -0.195  10.339  -4.091  1.00 63.96           O  
ATOM   1341  OE2 GLU   180       1.665   9.268  -4.479  1.00 73.52           O  
ATOM   1342  N   GLU   181       1.101  13.697  -0.590  1.00 51.44           N  
ATOM   1343  CA  GLU   181       0.395  13.645   0.684  1.00 52.99           C  
ATOM   1344  C   GLU   181      -0.657  14.751   0.851  1.00 50.86           C  
ATOM   1345  O   GLU   181      -1.810  14.491   1.236  1.00 51.34           O  
ATOM   1346  CB  GLU   181       1.436  13.741   1.807  1.00 52.57           C  
ATOM   1347  CG  GLU   181       0.877  13.620   3.202  1.00 57.00           C  
ATOM   1348  CD  GLU   181       1.872  14.069   4.266  1.00 61.56           C  
ATOM   1349  OE1 GLU   181       3.071  14.272   3.921  1.00 76.08           O  
ATOM   1350  OE2 GLU   181       1.440  14.230   5.443  1.00 74.24           O  
ATOM   1351  N   GLU   182      -0.250  15.985   0.578  1.00 48.88           N  
ATOM   1352  CA  GLU   182      -1.125  17.139   0.748  1.00 47.99           C  
ATOM   1353  C   GLU   182      -2.036  17.408  -0.428  1.00 45.65           C  
ATOM   1354  O   GLU   182      -3.071  17.995  -0.243  1.00 43.85           O  
ATOM   1355  CB  GLU   182      -0.299  18.401   0.986  1.00 48.49           C  
ATOM   1356  CG  GLU   182       0.459  18.450   2.284  1.00 49.55           C  
ATOM   1357  CD  GLU   182       1.087  19.809   2.486  1.00 49.39           C  
ATOM   1358  OE1 GLU   182       2.133  20.060   1.866  1.00 57.73           O  
ATOM   1359  OE2 GLU   182       0.523  20.637   3.252  1.00 63.87           O  
ATOM   1360  N   ARG   183      -1.627  17.016  -1.635  1.00 47.50           N  
ATOM   1361  CA  ARG   183      -2.409  17.260  -2.848  1.00 46.60           C  
ATOM   1362  C   ARG   183      -2.627  18.761  -3.060  1.00 46.49           C  
ATOM   1363  O   ARG   183      -3.739  19.197  -3.345  1.00 45.39           O  
ATOM   1364  CB  ARG   183      -3.746  16.526  -2.785  1.00 46.84           C  
ATOM   1365  CG  ARG   183      -3.667  14.996  -2.917  1.00 50.98           C  
ATOM   1366  CD  ARG   183      -3.969  14.539  -4.367  1.00 60.13           C  
ATOM   1367  NE  ARG   183      -4.200  13.094  -4.504  1.00 49.76           N  
ATOM   1368  CZ  ARG   183      -3.221  12.221  -4.391  1.00 47.02           C  
ATOM   1369  NH1 ARG   183      -2.019  12.672  -4.106  1.00 42.53           N  
ATOM   1370  NH2 ARG   183      -3.439  10.925  -4.523  1.00 48.32           N  
ATOM   1371  N   LEU   184      -1.560  19.549  -2.937  1.00 46.90           N  
ATOM   1372  CA  LEU   184      -1.668  20.996  -3.130  1.00 48.03           C  
ATOM   1373  C   LEU   184      -0.774  21.392  -4.292  1.00 47.57           C  
ATOM   1374  O   LEU   184       0.155  20.676  -4.603  1.00 46.62           O  
ATOM   1375  CB  LEU   184      -1.320  21.766  -1.847  1.00 48.11           C  
ATOM   1376  CG  LEU   184      -2.272  21.591  -0.657  1.00 45.33           C  
ATOM   1377  CD1 LEU   184      -1.624  22.116   0.616  1.00 46.80           C  
ATOM   1378  CD2 LEU   184      -3.630  22.262  -0.909  1.00 42.37           C  
ATOM   1379  N   PRO   185      -1.075  22.524  -4.956  1.00 49.82           N  
ATOM   1380  CA  PRO   185      -0.326  22.941  -6.135  1.00 49.73           C  
ATOM   1381  C   PRO   185       1.167  23.068  -5.930  1.00 50.62           C  
ATOM   1382  O   PRO   185       1.633  23.337  -4.819  1.00 52.62           O  
ATOM   1383  CB  PRO   185      -0.927  24.310  -6.469  1.00 49.87           C  
ATOM   1384  CG  PRO   185      -2.269  24.269  -5.920  1.00 49.71           C  
ATOM   1385  CD  PRO   185      -2.161  23.473  -4.657  1.00 49.76           C  
ATOM   1386  N   TYR   186       1.906  22.900  -7.019  1.00 49.39           N  
ATOM   1387  CA  TYR   186       3.342  23.010  -6.975  1.00 49.71           C  
ATOM   1388  C   TYR   186       3.824  24.304  -6.315  1.00 48.74           C  
ATOM   1389  O   TYR   186       4.752  24.261  -5.496  1.00 49.05           O  
ATOM   1390  CB  TYR   186       3.951  22.845  -8.398  1.00 50.69           C  
ATOM   1391  CG  TYR   186       5.397  23.260  -8.475  1.00 51.42           C  
ATOM   1392  CD1 TYR   186       6.405  22.412  -8.061  1.00 51.78           C  
ATOM   1393  CD2 TYR   186       5.748  24.536  -8.926  1.00 54.64           C  
ATOM   1394  CE1 TYR   186       7.726  22.810  -8.111  1.00 56.91           C  
ATOM   1395  CE2 TYR   186       7.056  24.945  -8.961  1.00 49.56           C  
ATOM   1396  CZ  TYR   186       8.039  24.084  -8.555  1.00 52.76           C  
ATOM   1397  OH  TYR   186       9.349  24.487  -8.606  1.00 57.36           O  
ATOM   1398  N   GLU   187       3.229  25.443  -6.692  1.00 49.83           N  
ATOM   1399  CA  GLU   187       3.615  26.773  -6.155  1.00 50.15           C  
ATOM   1400  C   GLU   187       3.642  26.798  -4.611  1.00 50.21           C  
ATOM   1401  O   GLU   187       4.594  27.299  -4.002  1.00 50.99           O  
ATOM   1402  CB  GLU   187       2.692  27.871  -6.712  1.00 49.73           C  
ATOM   1403  N   HIS   188       2.601  26.220  -4.009  1.00 50.31           N  
ATOM   1404  CA  HIS   188       2.453  26.097  -2.565  1.00 50.29           C  
ATOM   1405  C   HIS   188       3.445  25.125  -1.913  1.00 50.89           C  
ATOM   1406  O   HIS   188       4.006  25.447  -0.865  1.00 49.57           O  
ATOM   1407  CB  HIS   188       1.049  25.611  -2.243  1.00 51.54           C  
ATOM   1408  CG  HIS   188       0.729  25.625  -0.782  1.00 57.63           C  
ATOM   1409  ND1 HIS   188       1.225  24.686   0.098  1.00 61.10           N  
ATOM   1410  CD2 HIS   188      -0.056  26.450  -0.049  1.00 58.91           C  
ATOM   1411  CE1 HIS   188       0.774  24.943   1.312  1.00 57.63           C  
ATOM   1412  NE2 HIS   188      -0.012  26.003   1.250  1.00 60.26           N  
ATOM   1413  N   ILE   189       3.653  23.941  -2.506  1.00 50.32           N  
ATOM   1414  CA  ILE   189       4.562  22.950  -1.921  1.00 50.34           C  
ATOM   1415  C   ILE   189       5.993  23.477  -2.014  1.00 53.25           C  
ATOM   1416  O   ILE   189       6.816  23.219  -1.131  1.00 54.26           O  
ATOM   1417  CB  ILE   189       4.474  21.550  -2.589  1.00 50.20           C  
ATOM   1418  CG1 ILE   189       3.048  20.984  -2.564  1.00 53.02           C  
ATOM   1419  CG2 ILE   189       5.414  20.583  -1.911  1.00 48.21           C  
ATOM   1420  CD1 ILE   189       2.486  20.718  -1.189  1.00 50.90           C  
ATOM   1421  N   LEU   190       6.301  24.195  -3.094  1.00 54.47           N  
ATOM   1422  CA  LEU   190       7.611  24.836  -3.241  1.00 54.56           C  
ATOM   1423  C   LEU   190       7.853  25.850  -2.119  1.00 56.21           C  
ATOM   1424  O   LEU   190       8.951  25.913  -1.591  1.00 55.77           O  
ATOM   1425  CB  LEU   190       7.738  25.529  -4.594  1.00 53.43           C  
ATOM   1426  CG  LEU   190       8.984  26.378  -4.847  1.00 53.95           C  
ATOM   1427  CD1 LEU   190      10.191  25.499  -4.858  1.00 54.46           C  
ATOM   1428  CD2 LEU   190       8.878  27.181  -6.145  1.00 53.20           C  
ATOM   1429  N   LYS   191       6.836  26.643  -1.764  1.00 59.35           N  
ATOM   1430  CA  LYS   191       6.970  27.625  -0.664  1.00 59.85           C  
ATOM   1431  C   LYS   191       7.256  26.942   0.675  1.00 62.71           C  
ATOM   1432  O   LYS   191       8.009  27.478   1.487  1.00 65.04           O  
ATOM   1433  CB  LYS   191       5.760  28.544  -0.565  1.00 59.39           C  
ATOM   1434  CG  LYS   191       5.594  29.462  -1.764  1.00 62.81           C  
ATOM   1435  N   GLU   192       6.667  25.766   0.901  1.00 64.24           N  
ATOM   1436  CA  GLU   192       6.983  24.973   2.093  1.00 65.95           C  
ATOM   1437  C   GLU   192       8.445  24.528   2.004  1.00 65.32           C  
ATOM   1438  O   GLU   192       9.215  24.662   2.951  1.00 66.59           O  
ATOM   1439  CB  GLU   192       6.114  23.722   2.189  1.00 66.21           C  
ATOM   1440  CG  GLU   192       4.627  23.967   2.325  1.00 68.09           C  
ATOM   1441  CD  GLU   192       3.848  22.657   2.393  1.00 68.34           C  
ATOM   1442  OE1 GLU   192       4.186  21.795   3.237  1.00 68.68           O  
ATOM   1443  OE2 GLU   192       2.892  22.493   1.604  1.00 72.99           O  
ATOM   1444  N   ALA   193       8.822  23.990   0.850  1.00 64.18           N  
ATOM   1445  CA  ALA   193      10.191  23.554   0.631  1.00 64.49           C  
ATOM   1446  C   ALA   193      11.188  24.699   0.926  1.00 65.36           C  
ATOM   1447  O   ALA   193      12.274  24.479   1.480  1.00 66.60           O  
ATOM   1448  CB  ALA   193      10.356  23.036  -0.788  1.00 63.88           C  
ATOM   1449  N   GLN   194      10.806  25.913   0.556  1.00 64.64           N  
ATOM   1450  CA  GLN   194      11.630  27.088   0.789  1.00 64.41           C  
ATOM   1451  C   GLN   194      11.662  27.458   2.279  1.00 65.12           C  
ATOM   1452  O   GLN   194      12.744  27.704   2.823  1.00 61.97           O  
ATOM   1453  CB  GLN   194      11.180  28.244  -0.123  1.00 63.16           C  
ATOM   1454  CG  GLN   194      11.572  27.983  -1.600  1.00 61.72           C  
ATOM   1455  CD  GLN   194      10.958  28.958  -2.585  1.00 58.96           C  
ATOM   1456  OE1 GLN   194       9.811  29.344  -2.449  1.00 49.46           O  
ATOM   1457  NE2 GLN   194      11.717  29.329  -3.605  1.00 50.16           N  
ATOM   1458  N   GLU   195      10.498  27.457   2.935  1.00 67.33           N  
ATOM   1459  CA  GLU   195      10.419  27.725   4.380  1.00 68.56           C  
ATOM   1460  C   GLU   195      11.315  26.735   5.150  1.00 70.71           C  
ATOM   1461  O   GLU   195      12.058  27.136   6.042  1.00 73.46           O  
ATOM   1462  CB  GLU   195       8.969  27.668   4.888  1.00 67.50           C  
ATOM   1463  N   LEU   196      11.272  25.456   4.781  1.00 72.16           N  
ATOM   1464  CA  LEU   196      12.104  24.409   5.424  1.00 71.93           C  
ATOM   1465  C   LEU   196      13.613  24.514   5.119  1.00 72.29           C  
ATOM   1466  O   LEU   196      14.428  23.867   5.782  1.00 72.44           O  
ATOM   1467  CB  LEU   196      11.602  23.001   5.032  1.00 72.75           C  
ATOM   1468  CG  LEU   196      10.386  22.463   5.785  1.00 73.55           C  
ATOM   1469  CD1 LEU   196      10.794  22.218   7.234  1.00 71.91           C  
ATOM   1470  CD2 LEU   196       9.164  23.396   5.711  1.00 80.49           C  
ATOM   1471  N   GLY   197      13.974  25.299   4.103  1.00 71.91           N  
ATOM   1472  CA  GLY   197      15.365  25.504   3.721  1.00 69.37           C  
ATOM   1473  C   GLY   197      15.841  24.542   2.662  1.00 71.28           C  
ATOM   1474  O   GLY   197      17.023  24.568   2.284  1.00 71.05           O  
ATOM   1475  N   TYR   198      14.943  23.690   2.158  1.00 71.91           N  
ATOM   1476  CA  TYR   198      15.350  22.701   1.151  1.00 70.29           C  
ATOM   1477  C   TYR   198      15.620  23.320  -0.211  1.00 68.90           C  
ATOM   1478  O   TYR   198      16.493  22.848  -0.935  1.00 69.01           O  
ATOM   1479  CB  TYR   198      14.334  21.569   1.003  1.00 70.32           C  
ATOM   1480  CG  TYR   198      14.013  20.843   2.282  1.00 71.40           C  
ATOM   1481  CD1 TYR   198      14.969  20.670   3.280  1.00 71.74           C  
ATOM   1482  CD2 TYR   198      12.770  20.255   2.460  1.00 70.09           C  
ATOM   1483  CE1 TYR   198      14.658  19.993   4.454  1.00 73.66           C  
ATOM   1484  CE2 TYR   198      12.463  19.571   3.610  1.00 69.46           C  
ATOM   1485  CZ  TYR   198      13.404  19.438   4.607  1.00 71.92           C  
ATOM   1486  OH  TYR   198      13.069  18.758   5.765  1.00 73.80           O  
ATOM   1487  N   ALA   199      14.862  24.357  -0.556  1.00 68.19           N  
ATOM   1488  CA  ALA   199      15.021  25.035  -1.829  1.00 66.85           C  
ATOM   1489  C   ALA   199      15.321  26.524  -1.634  1.00 66.32           C  
ATOM   1490  O   ALA   199      14.768  27.161  -0.738  1.00 64.86           O  
ATOM   1491  CB  ALA   199      13.753  24.841  -2.687  1.00 67.08           C  
ATOM   1492  N   GLU   200      16.197  27.053  -2.488  1.00 65.83           N  
ATOM   1493  CA  GLU   200      16.566  28.461  -2.496  1.00 67.83           C  
ATOM   1494  C   GLU   200      15.466  29.277  -3.185  1.00 68.19           C  
ATOM   1495  O   GLU   200      14.520  28.705  -3.757  1.00 65.69           O  
ATOM   1496  CB  GLU   200      17.908  28.669  -3.225  1.00 67.97           C  
ATOM   1497  CG  GLU   200      19.120  27.995  -2.549  1.00 72.33           C  
ATOM   1498  CD  GLU   200      20.349  27.924  -3.451  1.00 69.69           C  
ATOM   1499  N   ALA   201      15.607  30.610  -3.111  1.00 68.46           N  
ATOM   1500  CA  ALA   201      14.672  31.576  -3.717  1.00 68.54           C  
ATOM   1501  C   ALA   201      14.496  31.297  -5.200  1.00 68.47           C  
ATOM   1502  O   ALA   201      13.428  31.519  -5.758  1.00 68.13           O  
ATOM   1503  CB  ALA   201      15.165  33.006  -3.506  1.00 68.07           C  
ATOM   1504  N   ASP   202      15.586  30.866  -5.831  1.00 69.18           N  
ATOM   1505  CA  ASP   202      15.580  30.368  -7.202  1.00 68.04           C  
ATOM   1506  C   ASP   202      15.849  28.869  -7.019  1.00 64.63           C  
ATOM   1507  O   ASP   202      16.992  28.476  -6.817  1.00 62.25           O  
ATOM   1508  CB  ASP   202      16.676  31.025  -8.048  1.00 70.21           C  
ATOM   1509  CG  ASP   202      16.945  30.266  -9.352  1.00 79.05           C  
ATOM   1510  OD1 ASP   202      15.961  29.692  -9.892  1.00 78.98           O  
ATOM   1511  OD2 ASP   202      18.133  30.242  -9.813  1.00 76.93           O  
ATOM   1512  N   PRO   203      14.789  28.034  -7.056  1.00 63.72           N  
ATOM   1513  CA  PRO   203      14.898  26.580  -6.832  1.00 61.75           C  
ATOM   1514  C   PRO   203      15.229  25.740  -8.078  1.00 59.45           C  
ATOM   1515  O   PRO   203      15.237  24.521  -7.998  1.00 59.32           O  
ATOM   1516  CB  PRO   203      13.482  26.233  -6.353  1.00 61.07           C  
ATOM   1517  CG  PRO   203      12.622  27.105  -7.172  1.00 59.95           C  
ATOM   1518  CD  PRO   203      13.390  28.413  -7.351  1.00 63.64           C  
ATOM   1519  N   SER   204      15.447  26.412  -9.201  1.00 58.82           N  
ATOM   1520  CA  SER   204      15.723  25.858 -10.537  1.00 60.32           C  
ATOM   1521  C   SER   204      16.726  24.693 -10.641  1.00 58.74           C  
ATOM   1522  O   SER   204      16.479  23.682 -11.315  1.00 57.35           O  
ATOM   1523  CB  SER   204      16.203  27.042 -11.401  1.00 61.40           C  
ATOM   1524  OG  SER   204      16.597  26.650 -12.692  1.00 74.01           O  
ATOM   1525  N   TYR   205      17.871  24.859  -9.996  1.00 58.63           N  
ATOM   1526  CA  TYR   205      18.929  23.844  -9.958  1.00 58.51           C  
ATOM   1527  C   TYR   205      18.345  22.511  -9.489  1.00 56.16           C  
ATOM   1528  O   TYR   205      18.691  21.463 -10.007  1.00 52.02           O  
ATOM   1529  CB  TYR   205      20.009  24.334  -9.021  1.00 59.98           C  
ATOM   1530  CG  TYR   205      21.303  23.546  -8.918  1.00 66.63           C  
ATOM   1531  CD1 TYR   205      22.284  23.633  -9.926  1.00 58.78           C  
ATOM   1532  CD2 TYR   205      21.608  22.819  -7.744  1.00 69.11           C  
ATOM   1533  CE1 TYR   205      23.504  22.973  -9.798  1.00 64.53           C  
ATOM   1534  CE2 TYR   205      22.837  22.125  -7.610  1.00 68.87           C  
ATOM   1535  CZ  TYR   205      23.773  22.215  -8.639  1.00 71.51           C  
ATOM   1536  OH  TYR   205      24.970  21.573  -8.495  1.00 70.59           O  
ATOM   1537  N   ASP   206      17.409  22.570  -8.543  1.00 55.98           N  
ATOM   1538  CA  ASP   206      16.725  21.382  -8.071  1.00 54.69           C  
ATOM   1539  C   ASP   206      15.564  21.016  -8.983  1.00 54.42           C  
ATOM   1540  O   ASP   206      15.590  19.965  -9.606  1.00 54.38           O  
ATOM   1541  CB  ASP   206      16.173  21.563  -6.643  1.00 54.91           C  
ATOM   1542  CG  ASP   206      17.258  21.735  -5.592  1.00 55.86           C  
ATOM   1543  OD1 ASP   206      18.302  21.060  -5.674  1.00 61.04           O  
ATOM   1544  OD2 ASP   206      17.034  22.521  -4.645  1.00 64.32           O  
ATOM   1545  N   VAL   207      14.548  21.884  -9.040  1.00 52.94           N  
ATOM   1546  CA  VAL   207      13.286  21.567  -9.714  1.00 51.67           C  
ATOM   1547  C   VAL   207      13.301  21.354 -11.232  1.00 52.00           C  
ATOM   1548  O   VAL   207      12.367  20.748 -11.769  1.00 52.24           O  
ATOM   1549  CB  VAL   207      12.123  22.512  -9.272  1.00 52.21           C  
ATOM   1550  CG1 VAL   207      12.009  22.472  -7.741  1.00 45.97           C  
ATOM   1551  CG2 VAL   207      12.271  23.948  -9.823  1.00 47.72           C  
ATOM   1552  N   GLU   208      14.331  21.858 -11.911  1.00 52.85           N  
ATOM   1553  CA  GLU   208      14.482  21.642 -13.345  1.00 54.65           C  
ATOM   1554  C   GLU   208      15.363  20.399 -13.623  1.00 54.89           C  
ATOM   1555  O   GLU   208      15.709  20.113 -14.770  1.00 54.82           O  
ATOM   1556  CB  GLU   208      15.072  22.879 -14.037  1.00 52.72           C  
ATOM   1557  CG  GLU   208      14.282  24.159 -13.869  1.00 52.72           C  
ATOM   1558  CD  GLU   208      12.881  24.099 -14.478  1.00 53.88           C  
ATOM   1559  OE1 GLU   208      12.543  23.109 -15.164  1.00 50.07           O  
ATOM   1560  OE2 GLU   208      12.117  25.068 -14.280  1.00 57.93           O  
ATOM   1561  N   GLY   209      15.743  19.687 -12.565  1.00 56.82           N  
ATOM   1562  CA  GLY   209      16.528  18.452 -12.688  1.00 55.27           C  
ATOM   1563  C   GLY   209      18.003  18.604 -12.995  1.00 54.85           C  
ATOM   1564  O   GLY   209      18.652  17.625 -13.323  1.00 55.73           O  
ATOM   1565  N   ILE   210      18.542  19.821 -12.861  1.00 54.76           N  
ATOM   1566  CA  ILE   210      19.938  20.078 -13.186  1.00 54.36           C  
ATOM   1567  C   ILE   210      20.869  19.337 -12.215  1.00 53.25           C  
ATOM   1568  O   ILE   210      21.816  18.673 -12.622  1.00 52.64           O  
ATOM   1569  CB  ILE   210      20.291  21.605 -13.141  1.00 52.69           C  
ATOM   1570  CG1 ILE   210      19.380  22.462 -14.046  1.00 59.17           C  
ATOM   1571  CG2 ILE   210      21.751  21.828 -13.472  1.00 49.21           C  
ATOM   1572  CD1 ILE   210      19.444  22.148 -15.502  1.00 66.10           C  
ATOM   1573  N   ASP   211      20.618  19.479 -10.921  1.00 54.09           N  
ATOM   1574  CA  ASP   211      21.428  18.807  -9.892  1.00 51.97           C  
ATOM   1575  C   ASP   211      21.493  17.301 -10.113  1.00 49.67           C  
ATOM   1576  O   ASP   211      22.586  16.702 -10.113  1.00 51.24           O  
ATOM   1577  CB  ASP   211      20.846  19.123  -8.512  1.00 53.71           C  
ATOM   1578  CG  ASP   211      21.631  18.481  -7.370  1.00 55.47           C  
ATOM   1579  OD1 ASP   211      22.812  18.853  -7.180  1.00 55.59           O  
ATOM   1580  OD2 ASP   211      21.033  17.648  -6.633  1.00 58.46           O  
ATOM   1581  N   ALA   212      20.327  16.679 -10.309  1.00 48.11           N  
ATOM   1582  CA  ALA   212      20.238  15.237 -10.529  1.00 45.99           C  
ATOM   1583  C   ALA   212      21.009  14.799 -11.795  1.00 46.22           C  
ATOM   1584  O   ALA   212      21.658  13.743 -11.797  1.00 48.01           O  
ATOM   1585  CB  ALA   212      18.789  14.778 -10.612  1.00 43.79           C  
ATOM   1586  N   ALA   213      20.930  15.613 -12.836  1.00 43.54           N  
ATOM   1587  CA  ALA   213      21.603  15.326 -14.133  1.00 45.45           C  
ATOM   1588  C   ALA   213      23.138  15.428 -14.047  1.00 45.51           C  
ATOM   1589  O   ALA   213      23.840  14.670 -14.675  1.00 48.79           O  
ATOM   1590  CB  ALA   213      21.073  16.230 -15.185  1.00 42.66           C  
ATOM   1591  N   LEU   214      23.642  16.435 -13.335  1.00 46.63           N  
ATOM   1592  CA  LEU   214      25.075  16.566 -13.043  1.00 45.43           C  
ATOM   1593  C   LEU   214      25.588  15.300 -12.366  1.00 46.14           C  
ATOM   1594  O   LEU   214      26.591  14.722 -12.778  1.00 49.16           O  
ATOM   1595  CB  LEU   214      25.324  17.796 -12.168  1.00 48.56           C  
ATOM   1596  CG  LEU   214      25.104  19.180 -12.854  1.00 53.32           C  
ATOM   1597  CD1 LEU   214      25.037  20.368 -11.881  1.00 43.38           C  
ATOM   1598  CD2 LEU   214      26.140  19.444 -13.913  1.00 50.20           C  
ATOM   1599  N   LYS   215      24.876  14.864 -11.331  1.00 46.82           N  
ATOM   1600  CA  LYS   215      25.162  13.647 -10.580  1.00 45.75           C  
ATOM   1601  C   LYS   215      25.074  12.405 -11.442  1.00 47.88           C  
ATOM   1602  O   LYS   215      25.912  11.521 -11.321  1.00 49.56           O  
ATOM   1603  CB  LYS   215      24.183  13.547  -9.403  1.00 45.01           C  
ATOM   1604  CG  LYS   215      24.509  14.589  -8.295  1.00 50.10           C  
ATOM   1605  CD  LYS   215      23.415  14.675  -7.203  1.00 47.84           C  
ATOM   1606  CE  LYS   215      23.750  15.716  -6.145  1.00 48.71           C  
ATOM   1607  NZ  LYS   215      22.596  15.971  -5.201  1.00 46.57           N  
ATOM   1608  N   LEU   216      24.074  12.350 -12.327  1.00 47.48           N  
ATOM   1609  CA  LEU   216      23.907  11.245 -13.264  1.00 45.00           C  
ATOM   1610  C   LEU   216      25.121  11.167 -14.163  1.00 45.39           C  
ATOM   1611  O   LEU   216      25.597  10.072 -14.432  1.00 45.92           O  
ATOM   1612  CB  LEU   216      22.619  11.407 -14.114  1.00 43.78           C  
ATOM   1613  CG  LEU   216      22.337  10.265 -15.126  1.00 49.21           C  
ATOM   1614  CD1 LEU   216      22.286   8.883 -14.438  1.00 48.68           C  
ATOM   1615  CD2 LEU   216      21.096  10.551 -15.976  1.00 46.60           C  
ATOM   1616  N   VAL   217      25.642  12.313 -14.619  1.00 45.94           N  
ATOM   1617  CA  VAL   217      26.867  12.291 -15.450  1.00 47.16           C  
ATOM   1618  C   VAL   217      28.091  11.698 -14.696  1.00 47.12           C  
ATOM   1619  O   VAL   217      28.905  10.941 -15.254  1.00 45.73           O  
ATOM   1620  CB  VAL   217      27.214  13.691 -16.050  1.00 50.11           C  
ATOM   1621  CG1 VAL   217      28.552  13.659 -16.786  1.00 47.66           C  
ATOM   1622  CG2 VAL   217      26.103  14.167 -17.012  1.00 49.14           C  
ATOM   1623  N   ILE   218      28.220  12.056 -13.433  1.00 47.15           N  
ATOM   1624  CA  ILE   218      29.319  11.568 -12.622  1.00 48.08           C  
ATOM   1625  C   ILE   218      29.211  10.046 -12.488  1.00 47.79           C  
ATOM   1626  O   ILE   218      30.167   9.343 -12.742  1.00 48.88           O  
ATOM   1627  CB  ILE   218      29.338  12.277 -11.269  1.00 45.60           C  
ATOM   1628  CG1 ILE   218      29.710  13.744 -11.498  1.00 49.59           C  
ATOM   1629  CG2 ILE   218      30.280  11.563 -10.283  1.00 49.52           C  
ATOM   1630  CD1 ILE   218      29.738  14.603 -10.283  1.00 46.99           C  
ATOM   1631  N   ILE   219      28.019   9.559 -12.152  1.00 47.86           N  
ATOM   1632  CA  ILE   219      27.752   8.136 -12.022  1.00 47.51           C  
ATOM   1633  C   ILE   219      27.966   7.329 -13.304  1.00 48.65           C  
ATOM   1634  O   ILE   219      28.525   6.247 -13.254  1.00 46.75           O  
ATOM   1635  CB  ILE   219      26.325   7.884 -11.565  1.00 47.39           C  
ATOM   1636  CG1 ILE   219      26.167   8.369 -10.142  1.00 54.24           C  
ATOM   1637  CG2 ILE   219      26.008   6.405 -11.579  1.00 46.64           C  
ATOM   1638  CD1 ILE   219      24.762   8.300  -9.693  1.00 67.32           C  
ATOM   1639  N   ALA   220      27.448   7.840 -14.420  1.00 49.50           N  
ATOM   1640  CA  ALA   220      27.589   7.210 -15.733  1.00 47.31           C  
ATOM   1641  C   ALA   220      29.053   6.992 -15.974  1.00 46.34           C  
ATOM   1642  O   ALA   220      29.476   5.900 -16.280  1.00 48.33           O  
ATOM   1643  CB  ALA   220      26.996   8.113 -16.830  1.00 46.80           C  
ATOM   1644  N   ASN   221      29.841   8.045 -15.835  1.00 49.27           N  
ATOM   1645  CA  ASN   221      31.275   7.937 -16.036  1.00 49.43           C  
ATOM   1646  C   ASN   221      31.992   6.989 -15.073  1.00 48.47           C  
ATOM   1647  O   ASN   221      32.946   6.296 -15.464  1.00 48.69           O  
ATOM   1648  CB  ASN   221      31.919   9.332 -15.988  1.00 52.71           C  
ATOM   1649  CG  ASN   221      31.734  10.109 -17.297  1.00 54.77           C  
ATOM   1650  OD1 ASN   221      32.409   9.834 -18.299  1.00 55.54           O  
ATOM   1651  ND2 ASN   221      30.865  11.117 -17.269  1.00 51.91           N  
ATOM   1652  N   THR   222      31.556   6.979 -13.818  1.00 49.74           N  
ATOM   1653  CA  THR   222      32.152   6.126 -12.781  1.00 48.37           C  
ATOM   1654  C   THR   222      31.970   4.642 -13.142  1.00 47.02           C  
ATOM   1655  O   THR   222      32.849   3.842 -12.910  1.00 50.70           O  
ATOM   1656  CB  THR   222      31.548   6.442 -11.365  1.00 49.83           C  
ATOM   1657  OG1 THR   222      31.871   7.791 -10.976  1.00 47.96           O  
ATOM   1658  CG2 THR   222      32.084   5.501 -10.322  1.00 47.19           C  
ATOM   1659  N   ILE   223      30.841   4.296 -13.743  1.00 48.55           N  
ATOM   1660  CA  ILE   223      30.549   2.926 -14.121  1.00 48.58           C  
ATOM   1661  C   ILE   223      31.020   2.587 -15.542  1.00 49.45           C  
ATOM   1662  O   ILE   223      30.683   1.518 -16.068  1.00 50.54           O  
ATOM   1663  CB  ILE   223      29.035   2.536 -13.963  1.00 49.21           C  
ATOM   1664  CG1 ILE   223      28.150   3.202 -15.036  1.00 53.85           C  
ATOM   1665  CG2 ILE   223      28.507   2.838 -12.521  1.00 42.11           C  
ATOM   1666  CD1 ILE   223      26.711   2.618 -15.127  1.00 44.95           C  
ATOM   1667  N   GLY   224      31.784   3.468 -16.171  1.00 48.78           N  
ATOM   1668  CA  GLY   224      32.353   3.156 -17.506  1.00 47.84           C  
ATOM   1669  C   GLY   224      31.582   3.624 -18.721  1.00 49.39           C  
ATOM   1670  O   GLY   224      31.932   3.253 -19.834  1.00 50.20           O  
ATOM   1671  N   VAL   225      30.521   4.409 -18.523  1.00 50.37           N  
ATOM   1672  CA  VAL   225      29.749   4.972 -19.631  1.00 51.28           C  
ATOM   1673  C   VAL   225      30.218   6.425 -19.850  1.00 53.00           C  
ATOM   1674  O   VAL   225      29.899   7.310 -19.063  1.00 53.69           O  
ATOM   1675  CB  VAL   225      28.242   4.906 -19.342  1.00 52.17           C  
ATOM   1676  CG1 VAL   225      27.435   5.576 -20.441  1.00 52.80           C  
ATOM   1677  CG2 VAL   225      27.783   3.424 -19.177  1.00 48.22           C  
ATOM   1678  N   LYS   226      31.046   6.658 -20.870  1.00 52.56           N  
ATOM   1679  CA  LYS   226      31.503   8.019 -21.182  1.00 52.99           C  
ATOM   1680  C   LYS   226      30.235   8.850 -21.450  1.00 54.80           C  
ATOM   1681  O   LYS   226      29.377   8.462 -22.244  1.00 59.18           O  
ATOM   1682  CB  LYS   226      32.445   8.028 -22.396  1.00 48.62           C  
ATOM   1683  N   ALA   227      30.079   9.956 -20.747  1.00 53.19           N  
ATOM   1684  CA  ALA   227      28.902  10.780 -20.915  1.00 51.60           C  
ATOM   1685  C   ALA   227      29.222  12.223 -20.595  1.00 50.01           C  
ATOM   1686  O   ALA   227      30.017  12.500 -19.713  1.00 47.38           O  
ATOM   1687  CB  ALA   227      27.754  10.282 -19.982  1.00 48.88           C  
ATOM   1688  N   SER   228      28.600  13.137 -21.337  1.00 51.41           N  
ATOM   1689  CA  SER   228      28.678  14.567 -21.064  1.00 51.50           C  
ATOM   1690  C   SER   228      27.276  15.047 -20.658  1.00 48.76           C  
ATOM   1691  O   SER   228      26.305  14.323 -20.819  1.00 47.86           O  
ATOM   1692  CB  SER   228      29.170  15.301 -22.300  1.00 52.99           C  
ATOM   1693  OG  SER   228      28.314  15.003 -23.387  1.00 69.90           O  
ATOM   1694  N   TYR   229      27.171  16.252 -20.107  1.00 48.74           N  
ATOM   1695  CA  TYR   229      25.865  16.800 -19.734  1.00 48.29           C  
ATOM   1696  C   TYR   229      24.890  16.855 -20.940  1.00 48.25           C  
ATOM   1697  O   TYR   229      23.708  16.575 -20.798  1.00 47.01           O  
ATOM   1698  CB  TYR   229      26.006  18.203 -19.101  1.00 48.01           C  
ATOM   1699  CG  TYR   229      24.718  18.650 -18.473  1.00 49.61           C  
ATOM   1700  CD1 TYR   229      23.719  19.281 -19.229  1.00 48.16           C  
ATOM   1701  CD2 TYR   229      24.476  18.403 -17.128  1.00 47.46           C  
ATOM   1702  CE1 TYR   229      22.505  19.635 -18.642  1.00 47.96           C  
ATOM   1703  CE2 TYR   229      23.302  18.771 -16.549  1.00 46.96           C  
ATOM   1704  CZ  TYR   229      22.322  19.384 -17.303  1.00 47.60           C  
ATOM   1705  OH  TYR   229      21.150  19.690 -16.687  1.00 48.70           O  
ATOM   1706  N   GLU   230      25.390  17.199 -22.125  1.00 46.91           N  
ATOM   1707  CA  GLU   230      24.523  17.360 -23.279  1.00 51.69           C  
ATOM   1708  C   GLU   230      23.897  16.068 -23.740  1.00 51.62           C  
ATOM   1709  O   GLU   230      22.951  16.115 -24.529  1.00 52.91           O  
ATOM   1710  CB  GLU   230      25.267  17.991 -24.449  1.00 52.98           C  
ATOM   1711  CG  GLU   230      26.377  17.113 -25.003  1.00 59.12           C  
ATOM   1712  CD  GLU   230      27.116  17.758 -26.156  1.00 60.66           C  
ATOM   1713  OE1 GLU   230      26.703  18.862 -26.588  1.00 64.84           O  
ATOM   1714  OE2 GLU   230      28.104  17.141 -26.621  1.00 73.65           O  
ATOM   1715  N   ASP   231      24.432  14.936 -23.271  1.00 49.16           N  
ATOM   1716  CA  ASP   231      23.905  13.619 -23.603  1.00 48.16           C  
ATOM   1717  C   ASP   231      22.683  13.247 -22.771  1.00 47.73           C  
ATOM   1718  O   ASP   231      21.976  12.344 -23.136  1.00 48.39           O  
ATOM   1719  CB  ASP   231      24.976  12.526 -23.385  1.00 46.15           C  
ATOM   1720  CG  ASP   231      26.167  12.665 -24.301  1.00 51.11           C  
ATOM   1721  OD1 ASP   231      25.989  13.031 -25.473  1.00 60.41           O  
ATOM   1722  OD2 ASP   231      27.292  12.419 -23.848  1.00 54.74           O  
ATOM   1723  N   VAL   232      22.452  13.914 -21.642  1.00 48.20           N  
ATOM   1724  CA  VAL   232      21.338  13.577 -20.752  1.00 47.24           C  
ATOM   1725  C   VAL   232      20.055  14.265 -21.206  1.00 49.91           C  
ATOM   1726  O   VAL   232      20.080  15.431 -21.577  1.00 51.25           O  
ATOM   1727  CB  VAL   232      21.631  14.023 -19.295  1.00 50.55           C  
ATOM   1728  CG1 VAL   232      20.552  13.483 -18.336  1.00 41.85           C  
ATOM   1729  CG2 VAL   232      23.044  13.579 -18.852  1.00 47.15           C  
ATOM   1730  N   GLU   233      18.944  13.537 -21.239  1.00 48.85           N  
ATOM   1731  CA  GLU   233      17.648  14.149 -21.527  1.00 53.13           C  
ATOM   1732  C   GLU   233      17.132  14.530 -20.160  1.00 49.36           C  
ATOM   1733  O   GLU   233      16.885  13.648 -19.330  1.00 47.10           O  
ATOM   1734  CB  GLU   233      16.668  13.170 -22.132  1.00 54.59           C  
ATOM   1735  CG  GLU   233      16.961  12.735 -23.549  1.00 65.54           C  
ATOM   1736  CD  GLU   233      15.904  11.725 -24.068  1.00 65.50           C  
ATOM   1737  OE1 GLU   233      15.341  10.954 -23.234  1.00 66.60           O  
ATOM   1738  OE2 GLU   233      15.659  11.718 -25.308  1.00 74.23           O  
ATOM   1739  N   VAL   234      17.018  15.829 -19.910  1.00 49.46           N  
ATOM   1740  CA  VAL   234      16.619  16.350 -18.595  1.00 51.05           C  
ATOM   1741  C   VAL   234      15.191  16.925 -18.609  1.00 51.67           C  
ATOM   1742  O   VAL   234      14.884  17.749 -19.432  1.00 49.34           O  
ATOM   1743  CB  VAL   234      17.574  17.477 -18.150  1.00 51.02           C  
ATOM   1744  CG1 VAL   234      17.289  17.869 -16.680  1.00 53.81           C  
ATOM   1745  CG2 VAL   234      19.054  17.058 -18.306  1.00 47.25           C  
ATOM   1746  N   THR   235      14.339  16.479 -17.691  1.00 53.01           N  
ATOM   1747  CA  THR   235      12.985  17.024 -17.508  1.00 52.97           C  
ATOM   1748  C   THR   235      12.769  17.196 -16.000  1.00 51.14           C  
ATOM   1749  O   THR   235      13.036  16.296 -15.235  1.00 52.16           O  
ATOM   1750  CB  THR   235      11.902  16.077 -18.040  1.00 54.80           C  
ATOM   1751  OG1 THR   235      12.152  15.813 -19.409  1.00 51.05           O  
ATOM   1752  CG2 THR   235      10.514  16.681 -17.896  1.00 55.94           C  
ATOM   1753  N   GLY   236      12.313  18.374 -15.598  1.00 51.80           N  
ATOM   1754  CA  GLY   236      12.066  18.716 -14.194  1.00 53.90           C  
ATOM   1755  C   GLY   236      10.688  18.305 -13.707  1.00 52.14           C  
ATOM   1756  O   GLY   236       9.980  17.518 -14.380  1.00 51.12           O  
ATOM   1757  N   ILE   237      10.312  18.844 -12.550  1.00 51.45           N  
ATOM   1758  CA  ILE   237       9.046  18.470 -11.882  1.00 50.57           C  
ATOM   1759  C   ILE   237       7.962  19.527 -11.830  1.00 50.30           C  
ATOM   1760  O   ILE   237       6.879  19.296 -11.274  1.00 47.12           O  
ATOM   1761  CB  ILE   237       9.289  18.041 -10.404  1.00 50.11           C  
ATOM   1762  CG1 ILE   237       9.712  19.221  -9.521  1.00 52.04           C  
ATOM   1763  CG2 ILE   237      10.299  16.904 -10.330  1.00 47.51           C  
ATOM   1764  CD1 ILE   237       9.653  18.912  -7.994  1.00 47.30           C  
ATOM   1765  N   THR   238       8.227  20.676 -12.428  1.00 51.91           N  
ATOM   1766  CA  THR   238       7.322  21.804 -12.310  1.00 52.06           C  
ATOM   1767  C   THR   238       5.966  21.616 -12.996  1.00 51.29           C  
ATOM   1768  O   THR   238       5.079  22.411 -12.750  1.00 49.88           O  
ATOM   1769  CB  THR   238       7.992  23.079 -12.835  1.00 53.51           C  
ATOM   1770  OG1 THR   238       8.062  23.024 -14.263  1.00 53.36           O  
ATOM   1771  CG2 THR   238       9.384  23.208 -12.261  1.00 52.87           C  
ATOM   1772  N   GLN   239       5.806  20.593 -13.852  1.00 51.70           N  
ATOM   1773  CA  GLN   239       4.500  20.332 -14.506  1.00 51.14           C  
ATOM   1774  C   GLN   239       3.770  19.083 -13.956  1.00 50.90           C  
ATOM   1775  O   GLN   239       2.852  18.542 -14.606  1.00 50.87           O  
ATOM   1776  CB  GLN   239       4.651  20.213 -16.025  1.00 50.95           C  
ATOM   1777  CG  GLN   239       5.346  21.370 -16.684  1.00 49.53           C  
ATOM   1778  CD  GLN   239       4.687  22.714 -16.431  1.00 53.21           C  
ATOM   1779  OE1 GLN   239       3.488  22.914 -16.677  1.00 52.14           O  
ATOM   1780  NE2 GLN   239       5.489  23.661 -15.965  1.00 60.22           N  
ATOM   1781  N   ILE   240       4.187  18.627 -12.774  1.00 50.50           N  
ATOM   1782  CA  ILE   240       3.534  17.526 -12.068  1.00 49.76           C  
ATOM   1783  C   ILE   240       2.551  18.217 -11.127  1.00 49.62           C  
ATOM   1784  O   ILE   240       2.916  19.113 -10.366  1.00 50.34           O  
ATOM   1785  CB  ILE   240       4.531  16.637 -11.289  1.00 51.40           C  
ATOM   1786  CG1 ILE   240       5.580  16.030 -12.240  1.00 50.23           C  
ATOM   1787  CG2 ILE   240       3.794  15.516 -10.526  1.00 51.15           C  
ATOM   1788  CD1 ILE   240       5.047  15.071 -13.283  1.00 40.36           C  
ATOM   1789  N   THR   241       1.287  17.826 -11.231  1.00 48.18           N  
ATOM   1790  CA  THR   241       0.218  18.419 -10.464  1.00 44.92           C  
ATOM   1791  C   THR   241      -0.417  17.385  -9.522  1.00 45.39           C  
ATOM   1792  O   THR   241      -0.223  16.160  -9.666  1.00 48.75           O  
ATOM   1793  CB  THR   241      -0.903  18.900 -11.423  1.00 45.41           C  
ATOM   1794  OG1 THR   241      -1.461  17.762 -12.093  1.00 42.33           O  
ATOM   1795  CG2 THR   241      -0.385  19.906 -12.461  1.00 39.55           C  
ATOM   1796  N   PRO   242      -1.178  17.862  -8.540  1.00 43.72           N  
ATOM   1797  CA  PRO   242      -1.898  16.935  -7.697  1.00 42.02           C  
ATOM   1798  C   PRO   242      -2.739  15.965  -8.512  1.00 40.79           C  
ATOM   1799  O   PRO   242      -2.818  14.793  -8.167  1.00 40.36           O  
ATOM   1800  CB  PRO   242      -2.789  17.855  -6.875  1.00 45.16           C  
ATOM   1801  CG  PRO   242      -1.977  19.111  -6.759  1.00 40.89           C  
ATOM   1802  CD  PRO   242      -1.351  19.257  -8.098  1.00 43.85           C  
ATOM   1803  N   GLU   243      -3.326  16.439  -9.607  1.00 41.11           N  
ATOM   1804  CA  GLU   243      -4.181  15.595 -10.436  1.00 40.13           C  
ATOM   1805  C   GLU   243      -3.392  14.439 -11.052  1.00 40.44           C  
ATOM   1806  O   GLU   243      -3.890  13.332 -11.171  1.00 39.81           O  
ATOM   1807  CB  GLU   243      -4.916  16.436 -11.483  1.00 43.04           C  
ATOM   1808  CG  GLU   243      -5.965  15.667 -12.266  1.00 43.85           C  
ATOM   1809  CD  GLU   243      -6.988  14.994 -11.381  1.00 45.41           C  
ATOM   1810  OE1 GLU   243      -7.357  15.601 -10.365  1.00 41.82           O  
ATOM   1811  OE2 GLU   243      -7.443  13.874 -11.714  1.00 55.23           O  
ATOM   1812  N   ALA   244      -2.142  14.685 -11.401  1.00 40.95           N  
ATOM   1813  CA  ALA   244      -1.283  13.629 -11.875  1.00 42.78           C  
ATOM   1814  C   ALA   244      -1.108  12.543 -10.786  1.00 40.92           C  
ATOM   1815  O   ALA   244      -1.111  11.358 -11.086  1.00 41.81           O  
ATOM   1816  CB  ALA   244       0.125  14.216 -12.341  1.00 40.76           C  
ATOM   1817  N   PHE   245      -0.923  12.949  -9.537  1.00 42.02           N  
ATOM   1818  CA  PHE   245      -0.764  11.996  -8.432  1.00 41.77           C  
ATOM   1819  C   PHE   245      -2.051  11.208  -8.199  1.00 42.19           C  
ATOM   1820  O   PHE   245      -2.029  10.038  -7.840  1.00 47.13           O  
ATOM   1821  CB  PHE   245      -0.344  12.695  -7.121  1.00 42.89           C  
ATOM   1822  CG  PHE   245       1.125  12.972  -7.017  1.00 40.18           C  
ATOM   1823  CD1 PHE   245       1.991  11.972  -6.609  1.00 39.79           C  
ATOM   1824  CD2 PHE   245       1.640  14.247  -7.280  1.00 42.93           C  
ATOM   1825  CE1 PHE   245       3.358  12.220  -6.490  1.00 42.20           C  
ATOM   1826  CE2 PHE   245       2.994  14.499  -7.176  1.00 45.15           C  
ATOM   1827  CZ  PHE   245       3.860  13.478  -6.792  1.00 47.39           C  
ATOM   1828  N   GLN   246      -3.181  11.842  -8.408  1.00 41.99           N  
ATOM   1829  CA  GLN   246      -4.450  11.162  -8.233  1.00 41.40           C  
ATOM   1830  C   GLN   246      -4.657  10.066  -9.283  1.00 42.17           C  
ATOM   1831  O   GLN   246      -5.041   8.964  -8.938  1.00 44.25           O  
ATOM   1832  CB  GLN   246      -5.586  12.155  -8.301  1.00 38.86           C  
ATOM   1833  CG  GLN   246      -6.995  11.535  -8.182  1.00 39.79           C  
ATOM   1834  CD  GLN   246      -7.226  10.792  -6.872  1.00 39.15           C  
ATOM   1835  OE1 GLN   246      -6.626  11.101  -5.848  1.00 43.01           O  
ATOM   1836  NE2 GLN   246      -8.108   9.803  -6.909  1.00 40.19           N  
ATOM   1837  N   VAL   247      -4.403  10.354 -10.554  1.00 43.07           N  
ATOM   1838  CA  VAL   247      -4.644   9.347 -11.614  1.00 40.38           C  
ATOM   1839  C   VAL   247      -3.631   8.202 -11.505  1.00 40.18           C  
ATOM   1840  O   VAL   247      -3.953   7.047 -11.779  1.00 40.19           O  
ATOM   1841  CB  VAL   247      -4.683   9.963 -13.031  1.00 39.05           C  
ATOM   1842  CG1 VAL   247      -5.787  10.993 -13.100  1.00 35.51           C  
ATOM   1843  CG2 VAL   247      -3.361  10.586 -13.417  1.00 35.10           C  
ATOM   1844  N   ALA   248      -2.418   8.524 -11.081  1.00 41.55           N  
ATOM   1845  CA  ALA   248      -1.380   7.504 -10.858  1.00 43.61           C  
ATOM   1846  C   ALA   248      -1.725   6.612  -9.628  1.00 44.76           C  
ATOM   1847  O   ALA   248      -1.574   5.389  -9.671  1.00 45.16           O  
ATOM   1848  CB  ALA   248      -0.031   8.158 -10.698  1.00 39.93           C  
ATOM   1849  N   ALA   249      -2.221   7.231  -8.558  1.00 46.58           N  
ATOM   1850  CA  ALA   249      -2.593   6.516  -7.324  1.00 45.65           C  
ATOM   1851  C   ALA   249      -3.641   5.455  -7.600  1.00 45.82           C  
ATOM   1852  O   ALA   249      -3.556   4.343  -7.109  1.00 48.91           O  
ATOM   1853  CB  ALA   249      -3.098   7.493  -6.272  1.00 44.69           C  
ATOM   1854  N   GLU   250      -4.604   5.790  -8.442  1.00 46.64           N  
ATOM   1855  CA  GLU   250      -5.681   4.892  -8.778  1.00 44.96           C  
ATOM   1856  C   GLU   250      -5.190   3.582  -9.409  1.00 43.24           C  
ATOM   1857  O   GLU   250      -5.881   2.579  -9.352  1.00 43.54           O  
ATOM   1858  CB  GLU   250      -6.685   5.625  -9.684  1.00 44.73           C  
ATOM   1859  CG  GLU   250      -7.422   6.787  -8.970  1.00 46.14           C  
ATOM   1860  CD  GLU   250      -8.346   7.599  -9.889  1.00 49.43           C  
ATOM   1861  OE1 GLU   250      -8.366   7.356 -11.120  1.00 45.92           O  
ATOM   1862  OE2 GLU   250      -9.068   8.486  -9.372  1.00 59.08           O  
ATOM   1863  N   LYS   251      -3.984   3.578  -9.961  1.00 44.52           N  
ATOM   1864  CA  LYS   251      -3.406   2.384 -10.600  1.00 45.68           C  
ATOM   1865  C   LYS   251      -2.169   1.837  -9.853  1.00 48.30           C  
ATOM   1866  O   LYS   251      -1.402   1.056 -10.409  1.00 50.79           O  
ATOM   1867  CB  LYS   251      -3.034   2.707 -12.066  1.00 43.07           C  
ATOM   1868  CG  LYS   251      -4.193   3.318 -12.900  1.00 43.05           C  
ATOM   1869  CD  LYS   251      -5.392   2.388 -13.003  1.00 45.17           C  
ATOM   1870  CE  LYS   251      -6.557   2.995 -13.834  1.00 48.14           C  
ATOM   1871  N   GLY   252      -1.955   2.291  -8.622  1.00 48.48           N  
ATOM   1872  CA  GLY   252      -0.867   1.797  -7.782  1.00 47.58           C  
ATOM   1873  C   GLY   252       0.466   2.488  -7.861  1.00 48.28           C  
ATOM   1874  O   GLY   252       1.452   1.972  -7.316  1.00 47.63           O  
ATOM   1875  N   TYR   253       0.497   3.673  -8.473  1.00 46.78           N  
ATOM   1876  CA  TYR   253       1.734   4.393  -8.659  1.00 47.90           C  
ATOM   1877  C   TYR   253       1.828   5.714  -7.926  1.00 47.46           C  
ATOM   1878  O   TYR   253       0.847   6.393  -7.699  1.00 46.82           O  
ATOM   1879  CB  TYR   253       1.936   4.728 -10.139  1.00 49.96           C  
ATOM   1880  CG  TYR   253       1.994   3.555 -11.078  1.00 49.64           C  
ATOM   1881  CD1 TYR   253       3.191   2.906 -11.319  1.00 52.34           C  
ATOM   1882  CD2 TYR   253       0.861   3.108 -11.735  1.00 50.30           C  
ATOM   1883  CE1 TYR   253       3.265   1.824 -12.168  1.00 52.09           C  
ATOM   1884  CE2 TYR   253       0.915   2.030 -12.591  1.00 59.56           C  
ATOM   1885  CZ  TYR   253       2.127   1.382 -12.812  1.00 63.02           C  
ATOM   1886  OH  TYR   253       2.213   0.304 -13.682  1.00 58.75           O  
ATOM   1887  N   THR   254       3.054   6.059  -7.571  1.00 48.76           N  
ATOM   1888  CA  THR   254       3.372   7.392  -7.097  1.00 47.08           C  
ATOM   1889  C   THR   254       4.245   7.928  -8.228  1.00 49.16           C  
ATOM   1890  O   THR   254       4.402   7.259  -9.259  1.00 48.78           O  
ATOM   1891  CB  THR   254       4.072   7.429  -5.731  1.00 46.40           C  
ATOM   1892  OG1 THR   254       4.178   8.792  -5.330  1.00 42.73           O  
ATOM   1893  CG2 THR   254       5.444   6.781  -5.772  1.00 41.30           C  
ATOM   1894  N   ILE   255       4.780   9.130  -8.066  1.00 51.63           N  
ATOM   1895  CA  ILE   255       5.599   9.773  -9.103  1.00 49.60           C  
ATOM   1896  C   ILE   255       6.888  10.243  -8.454  1.00 50.49           C  
ATOM   1897  O   ILE   255       6.858  10.837  -7.367  1.00 47.75           O  
ATOM   1898  CB  ILE   255       4.891  11.000  -9.715  1.00 48.87           C  
ATOM   1899  CG1 ILE   255       3.530  10.607 -10.320  1.00 47.92           C  
ATOM   1900  CG2 ILE   255       5.777  11.660 -10.774  1.00 46.19           C  
ATOM   1901  CD1 ILE   255       2.656  11.771 -10.677  1.00 47.03           C  
ATOM   1902  N   ARG   256       8.011   9.986  -9.125  1.00 50.08           N  
ATOM   1903  CA  ARG   256       9.330  10.376  -8.613  1.00 50.31           C  
ATOM   1904  C   ARG   256      10.209  10.882  -9.721  1.00 49.70           C  
ATOM   1905  O   ARG   256      10.014  10.517 -10.874  1.00 50.83           O  
ATOM   1906  CB  ARG   256      10.002   9.153  -7.995  1.00 51.89           C  
ATOM   1907  CG  ARG   256       9.358   8.667  -6.706  1.00 53.29           C  
ATOM   1908  CD  ARG   256       9.722   9.572  -5.582  1.00 55.52           C  
ATOM   1909  NE  ARG   256       9.123   9.135  -4.334  1.00 55.85           N  
ATOM   1910  CZ  ARG   256       7.874   9.391  -3.947  1.00 54.21           C  
ATOM   1911  NH1 ARG   256       7.025  10.085  -4.709  1.00 56.43           N  
ATOM   1912  NH2 ARG   256       7.465   8.921  -2.780  1.00 59.54           N  
ATOM   1913  N   LEU   257      11.207  11.697  -9.383  1.00 51.04           N  
ATOM   1914  CA  LEU   257      12.173  12.161 -10.376  1.00 47.61           C  
ATOM   1915  C   LEU   257      13.278  11.112 -10.339  1.00 49.86           C  
ATOM   1916  O   LEU   257      13.995  10.959  -9.340  1.00 50.23           O  
ATOM   1917  CB  LEU   257      12.722  13.556 -10.073  1.00 47.72           C  
ATOM   1918  CG  LEU   257      13.746  14.106 -11.093  1.00 49.63           C  
ATOM   1919  CD1 LEU   257      13.060  14.484 -12.363  1.00 52.20           C  
ATOM   1920  CD2 LEU   257      14.508  15.303 -10.533  1.00 50.78           C  
ATOM   1921  N   ILE   258      13.407  10.392 -11.443  1.00 49.48           N  
ATOM   1922  CA  ILE   258      14.334   9.305 -11.546  1.00 50.05           C  
ATOM   1923  C   ILE   258      15.436   9.615 -12.550  1.00 50.57           C  
ATOM   1924  O   ILE   258      15.166  10.017 -13.692  1.00 50.24           O  
ATOM   1925  CB  ILE   258      13.600   7.972 -11.984  1.00 48.16           C  
ATOM   1926  CG1 ILE   258      12.490   7.570 -10.985  1.00 49.81           C  
ATOM   1927  CG2 ILE   258      14.567   6.829 -12.134  1.00 44.38           C  
ATOM   1928  CD1 ILE   258      12.970   7.197  -9.627  1.00 44.62           C  
ATOM   1929  N   ALA   259      16.674   9.393 -12.107  1.00 49.90           N  
ATOM   1930  CA  ALA   259      17.877   9.530 -12.937  1.00 50.69           C  
ATOM   1931  C   ALA   259      18.273   8.100 -13.356  1.00 50.89           C  
ATOM   1932  O   ALA   259      18.341   7.205 -12.511  1.00 50.11           O  
ATOM   1933  CB  ALA   259      19.039  10.257 -12.136  1.00 47.55           C  
ATOM   1934  N   GLU   260      18.501   7.880 -14.651  1.00 51.07           N  
ATOM   1935  CA  GLU   260      18.846   6.576 -15.138  1.00 52.95           C  
ATOM   1936  C   GLU   260      19.957   6.562 -16.149  1.00 50.27           C  
ATOM   1937  O   GLU   260      19.947   7.360 -17.070  1.00 54.09           O  
ATOM   1938  CB  GLU   260      17.610   5.915 -15.801  1.00 54.66           C  
ATOM   1939  CG  GLU   260      17.984   4.637 -16.571  1.00 56.10           C  
ATOM   1940  CD  GLU   260      16.811   3.823 -17.087  1.00 61.73           C  
ATOM   1941  OE1 GLU   260      15.656   4.100 -16.697  1.00 61.72           O  
ATOM   1942  OE2 GLU   260      17.063   2.893 -17.898  1.00 69.02           O  
ATOM   1943  N   VAL   261      20.909   5.639 -15.990  1.00 48.24           N  
ATOM   1944  CA  VAL   261      21.954   5.381 -16.989  1.00 48.31           C  
ATOM   1945  C   VAL   261      21.846   3.876 -17.266  1.00 51.87           C  
ATOM   1946  O   VAL   261      21.948   3.070 -16.352  1.00 51.60           O  
ATOM   1947  CB  VAL   261      23.425   5.795 -16.585  1.00 48.63           C  
ATOM   1948  CG1 VAL   261      23.837   5.279 -15.231  1.00 48.90           C  
ATOM   1949  CG2 VAL   261      24.421   5.316 -17.661  1.00 41.92           C  
ATOM   1950  N   SER   262      21.544   3.520 -18.506  1.00 53.92           N  
ATOM   1951  CA  SER   262      21.405   2.117 -18.961  1.00 54.45           C  
ATOM   1952  C   SER   262      21.855   2.099 -20.380  1.00 55.86           C  
ATOM   1953  O   SER   262      22.365   3.111 -20.863  1.00 57.01           O  
ATOM   1954  CB  SER   262      19.957   1.623 -18.892  1.00 54.67           C  
ATOM   1955  OG  SER   262      19.077   2.430 -19.661  1.00 59.40           O  
ATOM   1956  N   ARG   263      21.672   0.964 -21.045  1.00 59.14           N  
ATOM   1957  CA  ARG   263      22.034   0.802 -22.459  1.00 59.93           C  
ATOM   1958  C   ARG   263      21.059   1.632 -23.301  1.00 62.30           C  
ATOM   1959  O   ARG   263      21.455   2.339 -24.218  1.00 63.10           O  
ATOM   1960  CB  ARG   263      21.976  -0.692 -22.855  1.00 59.62           C  
ATOM   1961  CG  ARG   263      22.596  -1.039 -24.229  1.00 60.73           C  
ATOM   1962  N   GLU   264      19.781   1.566 -22.939  1.00 65.99           N  
ATOM   1963  CA  GLU   264      18.722   2.291 -23.633  1.00 68.06           C  
ATOM   1964  C   GLU   264      18.665   3.813 -23.330  1.00 69.57           C  
ATOM   1965  O   GLU   264      18.291   4.616 -24.199  1.00 70.88           O  
ATOM   1966  CB  GLU   264      17.363   1.661 -23.250  1.00 68.88           C  
ATOM   1967  N   LYS   265      19.079   4.206 -22.123  1.00 67.14           N  
ATOM   1968  CA  LYS   265      18.847   5.557 -21.641  1.00 65.36           C  
ATOM   1969  C   LYS   265      19.928   6.290 -20.858  1.00 60.82           C  
ATOM   1970  O   LYS   265      20.834   5.712 -20.273  1.00 56.75           O  
ATOM   1971  CB  LYS   265      17.634   5.474 -20.694  1.00 65.07           C  
ATOM   1972  CG  LYS   265      16.370   5.080 -21.410  1.00 67.60           C  
ATOM   1973  CD  LYS   265      15.201   4.860 -20.482  1.00 73.63           C  
ATOM   1974  CE  LYS   265      13.889   4.905 -21.267  1.00 79.42           C  
ATOM   1975  NZ  LYS   265      13.993   4.235 -22.594  1.00 74.09           N  
ATOM   1976  N   LEU   266      19.769   7.606 -20.862  1.00 56.90           N  
ATOM   1977  CA  LEU   266      20.560   8.522 -20.069  1.00 52.32           C  
ATOM   1978  C   LEU   266      19.590   9.686 -19.842  1.00 49.93           C  
ATOM   1979  O   LEU   266      19.467  10.576 -20.674  1.00 46.28           O  
ATOM   1980  CB  LEU   266      21.845   8.934 -20.793  1.00 49.25           C  
ATOM   1981  CG  LEU   266      22.812   9.786 -19.974  1.00 53.47           C  
ATOM   1982  CD1 LEU   266      23.260   9.026 -18.727  1.00 52.75           C  
ATOM   1983  CD2 LEU   266      24.012  10.263 -20.800  1.00 51.30           C  
ATOM   1984  N   LYS   267      18.834   9.633 -18.758  1.00 47.82           N  
ATOM   1985  CA  LYS   267      17.887  10.660 -18.510  1.00 51.06           C  
ATOM   1986  C   LYS   267      17.526  10.887 -17.072  1.00 49.84           C  
ATOM   1987  O   LYS   267      17.724  10.027 -16.200  1.00 49.24           O  
ATOM   1988  CB  LYS   267      16.598  10.390 -19.297  1.00 53.67           C  
ATOM   1989  CG  LYS   267      15.810   9.149 -18.924  1.00 60.78           C  
ATOM   1990  CD  LYS   267      14.541   8.944 -19.815  1.00 60.18           C  
ATOM   1991  CE  LYS   267      13.575  10.193 -19.966  1.00 76.63           C  
ATOM   1992  NZ  LYS   267      13.784  11.228 -21.118  1.00 67.91           N  
ATOM   1993  N   VAL   268      17.003  12.087 -16.860  1.00 49.68           N  
ATOM   1994  CA  VAL   268      16.426  12.519 -15.606  1.00 51.35           C  
ATOM   1995  C   VAL   268      15.037  13.025 -15.979  1.00 51.93           C  
ATOM   1996  O   VAL   268      14.903  13.866 -16.867  1.00 48.66           O  
ATOM   1997  CB  VAL   268      17.234  13.667 -14.963  1.00 52.83           C  
ATOM   1998  CG1 VAL   268      16.513  14.203 -13.740  1.00 49.39           C  
ATOM   1999  CG2 VAL   268      18.658  13.167 -14.599  1.00 47.14           C  
ATOM   2000  N   SER   269      14.010  12.457 -15.359  1.00 51.69           N  
ATOM   2001  CA  SER   269      12.653  12.879 -15.592  1.00 53.24           C  
ATOM   2002  C   SER   269      11.710  12.306 -14.563  1.00 53.14           C  
ATOM   2003  O   SER   269      12.048  11.354 -13.829  1.00 54.67           O  
ATOM   2004  CB  SER   269      12.152  12.423 -16.965  1.00 53.66           C  
ATOM   2005  OG  SER   269      12.163  11.010 -17.043  1.00 57.01           O  
ATOM   2006  N   PRO   270      10.522  12.919 -14.450  1.00 51.63           N  
ATOM   2007  CA  PRO   270       9.501  12.260 -13.627  1.00 52.74           C  
ATOM   2008  C   PRO   270       9.123  10.884 -14.204  1.00 51.85           C  
ATOM   2009  O   PRO   270       9.159  10.691 -15.414  1.00 53.70           O  
ATOM   2010  CB  PRO   270       8.330  13.226 -13.689  1.00 52.28           C  
ATOM   2011  CG  PRO   270       9.016  14.589 -13.893  1.00 53.95           C  
ATOM   2012  CD  PRO   270      10.110  14.258 -14.872  1.00 48.97           C  
ATOM   2013  N   ARG   271       8.723   9.969 -13.335  1.00 49.90           N  
ATOM   2014  CA  ARG   271       8.358   8.651 -13.730  1.00 53.06           C  
ATOM   2015  C   ARG   271       7.373   8.023 -12.742  1.00 50.72           C  
ATOM   2016  O   ARG   271       7.444   8.310 -11.557  1.00 50.11           O  
ATOM   2017  CB  ARG   271       9.624   7.817 -13.760  1.00 54.71           C  
ATOM   2018  CG  ARG   271       9.445   6.443 -14.341  1.00 60.14           C  
ATOM   2019  CD  ARG   271      10.752   5.656 -14.346  1.00 60.69           C  
ATOM   2020  NE  ARG   271      11.780   6.259 -15.198  1.00 63.06           N  
ATOM   2021  CZ  ARG   271      12.936   5.661 -15.502  1.00 68.10           C  
ATOM   2022  NH1 ARG   271      13.195   4.432 -15.042  1.00 61.75           N  
ATOM   2023  NH2 ARG   271      13.827   6.274 -16.296  1.00 63.05           N  
ATOM   2024  N   LEU   272       6.461   7.173 -13.243  1.00 49.75           N  
ATOM   2025  CA  LEU   272       5.549   6.418 -12.381  1.00 50.07           C  
ATOM   2026  C   LEU   272       6.342   5.288 -11.692  1.00 52.05           C  
ATOM   2027  O   LEU   272       7.090   4.570 -12.348  1.00 56.31           O  
ATOM   2028  CB  LEU   272       4.385   5.853 -13.165  1.00 47.30           C  
ATOM   2029  CG  LEU   272       3.434   6.882 -13.793  1.00 46.63           C  
ATOM   2030  CD1 LEU   272       2.246   6.223 -14.527  1.00 40.52           C  
ATOM   2031  CD2 LEU   272       2.954   7.860 -12.713  1.00 40.96           C  
ATOM   2032  N   VAL   273       6.201   5.181 -10.374  1.00 51.42           N  
ATOM   2033  CA  VAL   273       6.858   4.165  -9.560  1.00 51.89           C  
ATOM   2034  C   VAL   273       5.812   3.483  -8.666  1.00 53.90           C  
ATOM   2035  O   VAL   273       5.110   4.174  -7.912  1.00 55.96           O  
ATOM   2036  CB  VAL   273       7.916   4.799  -8.620  1.00 53.50           C  
ATOM   2037  CG1 VAL   273       8.583   3.717  -7.749  1.00 49.92           C  
ATOM   2038  CG2 VAL   273       8.955   5.633  -9.421  1.00 47.84           C  
ATOM   2039  N   PRO   274       5.675   2.135  -8.755  1.00 52.64           N  
ATOM   2040  CA  PRO   274       4.728   1.432  -7.891  1.00 53.96           C  
ATOM   2041  C   PRO   274       4.977   1.737  -6.425  1.00 54.64           C  
ATOM   2042  O   PRO   274       6.127   1.797  -6.004  1.00 54.38           O  
ATOM   2043  CB  PRO   274       4.995  -0.035  -8.194  1.00 53.52           C  
ATOM   2044  CG  PRO   274       5.512  -0.028  -9.586  1.00 51.92           C  
ATOM   2045  CD  PRO   274       6.332   1.208  -9.692  1.00 53.02           C  
ATOM   2046  N   PHE   275       3.899   1.932  -5.675  1.00 54.72           N  
ATOM   2047  CA  PHE   275       3.974   2.293  -4.272  1.00 55.62           C  
ATOM   2048  C   PHE   275       4.891   1.449  -3.413  1.00 58.81           C  
ATOM   2049  O   PHE   275       5.520   1.943  -2.483  1.00 60.70           O  
ATOM   2050  CB  PHE   275       2.588   2.209  -3.655  1.00 57.01           C  
ATOM   2051  CG  PHE   275       1.686   3.318  -4.045  1.00 55.28           C  
ATOM   2052  CD1 PHE   275       2.029   4.624  -3.764  1.00 56.36           C  
ATOM   2053  CD2 PHE   275       0.454   3.057  -4.604  1.00 55.16           C  
ATOM   2054  CE1 PHE   275       1.184   5.657  -4.092  1.00 59.77           C  
ATOM   2055  CE2 PHE   275      -0.402   4.086  -4.922  1.00 58.80           C  
ATOM   2056  CZ  PHE   275      -0.037   5.391  -4.666  1.00 54.00           C  
ATOM   2057  N   HIS   276       4.944   0.160  -3.681  1.00 63.00           N  
ATOM   2058  CA  HIS   276       5.792  -0.693  -2.857  1.00 66.83           C  
ATOM   2059  C   HIS   276       7.177  -0.994  -3.461  1.00 66.08           C  
ATOM   2060  O   HIS   276       7.884  -1.870  -2.970  1.00 68.94           O  
ATOM   2061  CB  HIS   276       5.045  -1.990  -2.492  1.00 69.40           C  
ATOM   2062  CG  HIS   276       3.897  -1.777  -1.545  1.00 77.16           C  
ATOM   2063  ND1 HIS   276       2.577  -1.957  -1.910  1.00 84.07           N  
ATOM   2064  CD2 HIS   276       3.879  -1.381  -0.251  1.00 76.56           C  
ATOM   2065  CE1 HIS   276       1.800  -1.695  -0.873  1.00 86.57           C  
ATOM   2066  NE2 HIS   276       2.565  -1.339   0.143  1.00 82.10           N  
ATOM   2067  N   HIS   277       7.551  -0.272  -4.528  0.50 63.14           N  
ATOM   2069  CA  HIS   277       8.868  -0.436  -5.158  0.50 61.64           C  
ATOM   2071  C   HIS   277       9.907   0.297  -4.304  0.50 59.06           C  
ATOM   2073  O   HIS   277       9.579   1.288  -3.648  0.50 57.93           O  
ATOM   2075  CB  HIS   277       8.892   0.092  -6.606  0.50 60.27           C  
ATOM   2077  CG  HIS   277      10.214  -0.095  -7.300  0.50 60.02           C  
ATOM   2079  ND1 HIS   277      11.153   0.911  -7.410  0.50 40.88           N  
ATOM   2081  CD2 HIS   277      10.760  -1.182  -7.896  0.50 56.22           C  
ATOM   2083  CE1 HIS   277      12.226   0.446  -8.026  0.50 44.71           C  
ATOM   2085  NE2 HIS   277      12.015  -0.820  -8.332  0.50 55.69           N  
ATOM   2087  N   PRO   278      11.150  -0.214  -4.260  1.00 57.57           N  
ATOM   2088  CA  PRO   278      12.187   0.488  -3.504  1.00 55.58           C  
ATOM   2089  C   PRO   278      12.443   1.954  -3.879  1.00 53.90           C  
ATOM   2090  O   PRO   278      12.796   2.721  -3.013  1.00 55.60           O  
ATOM   2091  CB  PRO   278      13.427  -0.369  -3.747  1.00 54.22           C  
ATOM   2092  CG  PRO   278      12.895  -1.721  -3.973  1.00 54.80           C  
ATOM   2093  CD  PRO   278      11.685  -1.478  -4.812  1.00 57.70           C  
ATOM   2094  N   LEU   279      12.219   2.352  -5.123  1.00 52.42           N  
ATOM   2095  CA  LEU   279      12.427   3.737  -5.518  1.00 53.39           C  
ATOM   2096  C   LEU   279      11.205   4.624  -5.231  1.00 54.49           C  
ATOM   2097  O   LEU   279      11.191   5.766  -5.658  1.00 55.60           O  
ATOM   2098  CB  LEU   279      12.864   3.842  -6.983  1.00 52.72           C  
ATOM   2099  CG  LEU   279      14.279   3.350  -7.343  1.00 59.22           C  
ATOM   2100  CD1 LEU   279      14.465   3.288  -8.857  1.00 50.14           C  
ATOM   2101  CD2 LEU   279      15.331   4.266  -6.687  1.00 47.94           C  
ATOM   2102  N   ALA   280      10.207   4.121  -4.489  1.00 57.24           N  
ATOM   2103  CA  ALA   280       9.030   4.925  -4.056  1.00 56.16           C  
ATOM   2104  C   ALA   280       9.281   5.644  -2.719  1.00 57.69           C  
ATOM   2105  O   ALA   280       8.379   6.213  -2.131  1.00 58.14           O  
ATOM   2106  CB  ALA   280       7.779   4.045  -3.936  1.00 56.25           C  
ATOM   2107  N   ILE   281      10.508   5.582  -2.235  1.00 59.74           N  
ATOM   2108  CA  ILE   281      10.947   6.265  -1.016  1.00 60.78           C  
ATOM   2109  C   ILE   281      10.517   7.750  -0.945  1.00 60.99           C  
ATOM   2110  O   ILE   281      10.586   8.508  -1.927  1.00 58.34           O  
ATOM   2111  CB  ILE   281      12.498   6.161  -0.924  1.00 60.10           C  
ATOM   2112  CG1 ILE   281      12.971   6.338   0.509  1.00 66.46           C  
ATOM   2113  CG2 ILE   281      13.189   7.127  -1.969  1.00 57.81           C  
ATOM   2114  CD1 ILE   281      14.303   5.653   0.779  1.00 67.85           C  
ATOM   2115  N   LYS   282      10.080   8.173   0.229  1.00 61.35           N  
ATOM   2116  CA  LYS   282       9.619   9.539   0.388  1.00 63.67           C  
ATOM   2117  C   LYS   282      10.551  10.419   1.229  1.00 61.25           C  
ATOM   2118  O   LYS   282      11.502   9.933   1.803  1.00 61.51           O  
ATOM   2119  CB  LYS   282       8.141   9.570   0.846  1.00 64.98           C  
ATOM   2120  CG  LYS   282       7.766   8.583   1.882  1.00 67.64           C  
ATOM   2121  CD  LYS   282       6.285   8.645   2.238  1.00 67.61           C  
ATOM   2122  CE  LYS   282       5.385   8.048   1.180  1.00 67.77           C  
ATOM   2123  NZ  LYS   282       4.075   7.599   1.782  1.00 67.80           N  
ATOM   2124  N   GLY   283      10.295  11.729   1.221  1.00 60.05           N  
ATOM   2125  CA  GLY   283      11.082  12.711   1.977  1.00 56.85           C  
ATOM   2126  C   GLY   283      12.323  13.165   1.249  1.00 55.49           C  
ATOM   2127  O   GLY   283      12.490  12.857   0.075  1.00 56.61           O  
ATOM   2128  N   THR   284      13.186  13.922   1.937  1.00 55.16           N  
ATOM   2129  CA  THR   284      14.458  14.352   1.366  1.00 58.60           C  
ATOM   2130  C   THR   284      15.396  13.158   1.510  1.00 58.29           C  
ATOM   2131  O   THR   284      16.127  13.025   2.498  1.00 64.26           O  
ATOM   2132  CB  THR   284      15.068  15.562   2.103  1.00 58.81           C  
ATOM   2133  OG1 THR   284      15.282  15.184   3.465  1.00 61.42           O  
ATOM   2134  CG2 THR   284      14.130  16.791   2.063  1.00 54.55           C  
ATOM   2135  N   MET   285      15.348  12.279   0.533  1.00 55.74           N  
ATOM   2136  CA  MET   285      16.149  11.090   0.542  1.00 54.80           C  
ATOM   2137  C   MET   285      16.820  10.866  -0.798  1.00 53.76           C  
ATOM   2138  O   MET   285      16.468  11.517  -1.812  1.00 51.16           O  
ATOM   2139  CB  MET   285      15.254   9.895   0.817  1.00 59.08           C  
ATOM   2140  CG  MET   285      16.023   8.803   1.486  1.00 70.72           C  
ATOM   2141  SD  MET   285      15.988   9.191   3.365  0.75 72.71          SE  
ATOM   2142  CE  MET   285      14.036   7.971   3.245  1.00 55.49           C  
ATOM   2143  N   ASN   286      17.863  10.041  -0.795  1.00 50.19           N  
ATOM   2144  CA  ASN   286      18.458   9.596  -2.055  1.00 50.76           C  
ATOM   2145  C   ASN   286      18.290   8.081  -2.142  1.00 50.97           C  
ATOM   2146  O   ASN   286      17.978   7.440  -1.131  1.00 44.71           O  
ATOM   2147  CB  ASN   286      19.923   9.981  -2.224  1.00 49.58           C  
ATOM   2148  CG  ASN   286      20.112  11.403  -2.696  1.00 50.93           C  
ATOM   2149  OD1 ASN   286      21.105  11.690  -3.318  1.00 57.81           O  
ATOM   2150  ND2 ASN   286      19.143  12.297  -2.415  1.00 52.94           N  
ATOM   2151  N   ALA   287      18.425   7.550  -3.367  1.00 47.85           N  
ATOM   2152  CA  ALA   287      18.376   6.142  -3.571  1.00 50.04           C  
ATOM   2153  C   ALA   287      18.981   5.740  -4.931  1.00 48.49           C  
ATOM   2154  O   ALA   287      19.136   6.564  -5.846  1.00 49.11           O  
ATOM   2155  CB  ALA   287      16.931   5.601  -3.350  1.00 50.22           C  
ATOM   2156  N   ALA   288      19.445   4.498  -5.024  1.00 45.47           N  
ATOM   2157  CA  ALA   288      20.031   4.040  -6.281  1.00 47.90           C  
ATOM   2158  C   ALA   288      19.895   2.544  -6.375  1.00 48.41           C  
ATOM   2159  O   ALA   288      20.132   1.835  -5.394  1.00 49.24           O  
ATOM   2160  CB  ALA   288      21.514   4.466  -6.395  1.00 45.62           C  
ATOM   2161  N   MET   289      19.483   2.070  -7.545  1.00 48.34           N  
ATOM   2162  CA  MET   289      19.390   0.672  -7.800  1.00 48.98           C  
ATOM   2163  C   MET   289      20.462   0.335  -8.825  1.00 48.97           C  
ATOM   2164  O   MET   289      20.379   0.806  -9.935  1.00 48.56           O  
ATOM   2165  CB  MET   289      17.991   0.333  -8.359  1.00 52.88           C  
ATOM   2166  CG  MET   289      17.745  -1.165  -8.616  1.00 52.27           C  
ATOM   2167  SD  MET   289      17.752  -2.323  -7.100  0.75 51.82          SE  
ATOM   2168  CE  MET   289      15.943  -2.000  -6.436  1.00 70.48           C  
ATOM   2169  N   PHE   290      21.442  -0.498  -8.466  1.00 49.09           N  
ATOM   2170  CA  PHE   290      22.459  -0.980  -9.434  1.00 48.88           C  
ATOM   2171  C   PHE   290      22.062  -2.356  -9.940  1.00 50.07           C  
ATOM   2172  O   PHE   290      21.818  -3.239  -9.154  1.00 49.92           O  
ATOM   2173  CB  PHE   290      23.842  -1.103  -8.779  1.00 48.79           C  
ATOM   2174  CG  PHE   290      24.349   0.158  -8.204  1.00 48.96           C  
ATOM   2175  CD1 PHE   290      23.896   0.613  -6.969  1.00 46.94           C  
ATOM   2176  CD2 PHE   290      25.285   0.908  -8.884  1.00 55.03           C  
ATOM   2177  CE1 PHE   290      24.328   1.791  -6.463  1.00 52.75           C  
ATOM   2178  CE2 PHE   290      25.744   2.085  -8.363  1.00 56.17           C  
ATOM   2179  CZ  PHE   290      25.264   2.539  -7.158  1.00 55.13           C  
ATOM   2180  N   LYS   291      21.959  -2.515 -11.248  1.00 51.01           N  
ATOM   2181  CA  LYS   291      21.694  -3.786 -11.860  1.00 52.81           C  
ATOM   2182  C   LYS   291      23.043  -4.249 -12.413  1.00 51.70           C  
ATOM   2183  O   LYS   291      23.681  -3.528 -13.179  1.00 46.61           O  
ATOM   2184  CB  LYS   291      20.655  -3.672 -12.988  1.00 55.77           C  
ATOM   2185  CG  LYS   291      20.211  -5.026 -13.568  1.00 60.53           C  
ATOM   2186  CD  LYS   291      19.325  -4.887 -14.824  1.00 60.07           C  
ATOM   2187  CE  LYS   291      19.053  -6.265 -15.511  1.00 65.73           C  
ATOM   2188  N   THR   292      23.471  -5.450 -12.003  1.00 51.30           N  
ATOM   2189  CA  THR   292      24.770  -5.989 -12.373  1.00 49.62           C  
ATOM   2190  C   THR   292      24.610  -7.333 -12.985  1.00 49.16           C  
ATOM   2191  O   THR   292      23.529  -7.930 -12.921  1.00 48.79           O  
ATOM   2192  CB  THR   292      25.703  -6.186 -11.143  1.00 48.95           C  
ATOM   2193  OG1 THR   292      25.250  -7.297 -10.356  1.00 50.84           O  
ATOM   2194  CG2 THR   292      25.770  -4.949 -10.307  1.00 46.35           C  
ATOM   2195  N   ASP   293      25.702  -7.828 -13.561  1.00 50.04           N  
ATOM   2196  CA  ASP   293      25.686  -9.165 -14.146  1.00 51.52           C  
ATOM   2197  C   ASP   293      25.922 -10.287 -13.124  1.00 49.74           C  
ATOM   2198  O   ASP   293      25.258 -11.309 -13.205  1.00 48.01           O  
ATOM   2199  CB  ASP   293      26.698  -9.294 -15.298  1.00 54.21           C  
ATOM   2200  CG  ASP   293      28.150  -9.077 -14.857  1.00 59.78           C  
ATOM   2201  OD1 ASP   293      28.405  -8.547 -13.750  1.00 65.09           O  
ATOM   2202  OD2 ASP   293      29.048  -9.430 -15.645  1.00 72.52           O  
ATOM   2203  N   THR   294      26.840 -10.111 -12.170  1.00 49.18           N  
ATOM   2204  CA  THR   294      27.170 -11.225 -11.231  1.00 51.89           C  
ATOM   2205  C   THR   294      26.646 -11.106  -9.783  1.00 50.82           C  
ATOM   2206  O   THR   294      26.422 -12.115  -9.128  1.00 53.77           O  
ATOM   2207  CB  THR   294      28.695 -11.537 -11.205  1.00 51.02           C  
ATOM   2208  OG1 THR   294      29.416 -10.394 -10.734  1.00 55.62           O  
ATOM   2209  CG2 THR   294      29.192 -11.907 -12.592  1.00 48.56           C  
ATOM   2210  N   ALA   295      26.447  -9.891  -9.299  1.00 50.60           N  
ATOM   2211  CA  ALA   295      25.931  -9.652  -7.943  1.00 51.30           C  
ATOM   2212  C   ALA   295      24.421  -9.398  -7.876  1.00 51.09           C  
ATOM   2213  O   ALA   295      23.939  -8.902  -6.864  1.00 55.53           O  
ATOM   2214  CB  ALA   295      26.662  -8.445  -7.319  1.00 46.14           C  
ATOM   2215  N   GLY   296      23.684  -9.701  -8.938  1.00 50.47           N  
ATOM   2216  CA  GLY   296      22.274  -9.345  -9.021  1.00 47.00           C  
ATOM   2217  C   GLY   296      22.038  -7.833  -9.002  1.00 46.99           C  
ATOM   2218  O   GLY   296      22.866  -7.023  -9.452  1.00 47.94           O  
ATOM   2219  N   SER   297      20.890  -7.462  -8.447  1.00 45.29           N  
ATOM   2220  CA  SER   297      20.485  -6.093  -8.245  1.00 47.70           C  
ATOM   2221  C   SER   297      20.820  -5.625  -6.796  1.00 46.66           C  
ATOM   2222  O   SER   297      20.489  -6.288  -5.816  1.00 44.07           O  
ATOM   2223  CB  SER   297      18.998  -5.935  -8.600  1.00 49.61           C  
ATOM   2224  OG  SER   297      18.838  -5.667  -9.996  1.00 52.39           O  
ATOM   2225  N   ILE   298      21.514  -4.502  -6.693  1.00 45.48           N  
ATOM   2226  CA  ILE   298      21.926  -3.930  -5.421  1.00 47.62           C  
ATOM   2227  C   ILE   298      21.326  -2.541  -5.248  1.00 48.50           C  
ATOM   2228  O   ILE   298      21.430  -1.691  -6.129  1.00 46.75           O  
ATOM   2229  CB  ILE   298      23.437  -3.863  -5.292  1.00 48.14           C  
ATOM   2230  CG1 ILE   298      24.008  -5.275  -5.412  1.00 52.40           C  
ATOM   2231  CG2 ILE   298      23.839  -3.298  -3.937  1.00 46.53           C  
ATOM   2232  CD1 ILE   298      25.442  -5.340  -5.113  1.00 58.92           C  
ATOM   2233  N   PHE   299      20.665  -2.360  -4.103  1.00 47.41           N  
ATOM   2234  CA  PHE   299      19.949  -1.156  -3.780  1.00 46.70           C  
ATOM   2235  C   PHE   299      20.528  -0.494  -2.544  1.00 46.08           C  
ATOM   2236  O   PHE   299      20.912  -1.168  -1.560  1.00 43.64           O  
ATOM   2237  CB  PHE   299      18.478  -1.497  -3.523  1.00 48.44           C  
ATOM   2238  CG  PHE   299      17.602  -0.290  -3.232  1.00 47.77           C  
ATOM   2239  CD1 PHE   299      17.231   0.577  -4.250  1.00 54.31           C  
ATOM   2240  CD2 PHE   299      17.121  -0.051  -1.962  1.00 51.44           C  
ATOM   2241  CE1 PHE   299      16.429   1.664  -3.983  1.00 58.81           C  
ATOM   2242  CE2 PHE   299      16.302   1.044  -1.694  1.00 53.15           C  
ATOM   2243  CZ  PHE   299      15.966   1.892  -2.684  1.00 50.25           C  
ATOM   2244  N   VAL   300      20.611   0.835  -2.631  1.00 45.97           N  
ATOM   2245  CA  VAL   300      21.075   1.669  -1.543  1.00 48.52           C  
ATOM   2246  C   VAL   300      20.181   2.923  -1.440  1.00 47.59           C  
ATOM   2247  O   VAL   300      19.665   3.417  -2.434  1.00 46.65           O  
ATOM   2248  CB  VAL   300      22.596   2.002  -1.680  1.00 46.77           C  
ATOM   2249  CG1 VAL   300      22.890   2.751  -2.965  1.00 43.95           C  
ATOM   2250  CG2 VAL   300      23.089   2.794  -0.501  1.00 60.08           C  
ATOM   2251  N   ALA   301      19.992   3.392  -0.208  1.00 50.33           N  
ATOM   2252  CA  ALA   301      19.200   4.567   0.119  1.00 51.53           C  
ATOM   2253  C   ALA   301      19.778   5.233   1.390  1.00 53.33           C  
ATOM   2254  O   ALA   301      20.325   4.544   2.281  1.00 51.18           O  
ATOM   2255  CB  ALA   301      17.762   4.175   0.341  1.00 49.38           C  
ATOM   2256  N   GLY   302      19.701   6.569   1.436  1.00 53.20           N  
ATOM   2257  CA  GLY   302      20.105   7.365   2.605  1.00 55.07           C  
ATOM   2258  C   GLY   302      19.862   8.871   2.399  1.00 58.52           C  
ATOM   2259  O   GLY   302      19.121   9.260   1.513  1.00 56.23           O  
ATOM   2260  N   ARG   303      20.488   9.717   3.224  1.00 59.94           N  
ATOM   2261  CA  ARG   303      20.404  11.197   3.094  1.00 62.24           C  
ATOM   2262  C   ARG   303      21.276  11.642   1.924  1.00 64.44           C  
ATOM   2263  O   ARG   303      22.448  11.243   1.845  1.00 68.05           O  
ATOM   2264  CB  ARG   303      20.869  11.921   4.391  1.00 63.46           C  
ATOM   2265  CG  ARG   303      19.777  12.296   5.367  1.00 65.42           C  
ATOM   2266  CD  ARG   303      18.777  11.215   5.621  1.00 63.53           C  
ATOM   2267  NE  ARG   303      17.603  11.763   6.311  1.00 68.32           N  
ATOM   2268  N   GLY   304      20.724  12.474   1.041  1.00 61.92           N  
ATOM   2269  CA  GLY   304      21.473  12.933  -0.135  1.00 62.60           C  
ATOM   2270  C   GLY   304      22.240  14.246  -0.001  1.00 64.51           C  
ATOM   2271  O   GLY   304      22.921  14.670  -0.953  1.00 64.41           O  
ATOM   2272  N   ALA   305      22.127  14.880   1.170  1.00 64.80           N  
ATOM   2273  CA  ALA   305      22.749  16.192   1.444  1.00 67.40           C  
ATOM   2274  C   ALA   305      22.657  16.541   2.944  1.00 69.25           C  
ATOM   2275  O   ALA   305      22.008  15.827   3.739  1.00 71.21           O  
ATOM   2276  CB  ALA   305      22.084  17.306   0.597  1.00 64.41           C  
ATOM   2277  N   GLY   306      23.261  17.669   3.312  1.00 68.12           N  
ATOM   2278  CA  GLY   306      23.350  18.082   4.708  1.00 65.78           C  
ATOM   2279  C   GLY   306      24.808  18.328   5.029  1.00 64.76           C  
ATOM   2280  O   GLY   306      25.708  17.837   4.332  1.00 63.93           O  
ATOM   2281  N   LYS   307      25.046  19.108   6.073  1.00 62.64           N  
ATOM   2282  CA  LYS   307      26.399  19.476   6.443  1.00 62.49           C  
ATOM   2283  C   LYS   307      27.186  18.288   6.978  1.00 59.09           C  
ATOM   2284  O   LYS   307      28.273  17.993   6.470  1.00 59.47           O  
ATOM   2285  CB  LYS   307      26.409  20.646   7.456  1.00 61.25           C  
ATOM   2286  CG  LYS   307      27.799  20.931   7.994  1.00 64.49           C  
ATOM   2287  CD  LYS   307      27.953  22.314   8.630  1.00 66.08           C  
ATOM   2288  CE  LYS   307      27.276  22.452   9.964  1.00 72.37           C  
ATOM   2289  NZ  LYS   307      27.655  23.784  10.595  1.00 74.14           N  
ATOM   2290  N   GLU   308      26.636  17.617   7.989  1.00 59.41           N  
ATOM   2291  CA  GLU   308      27.331  16.507   8.639  1.00 60.01           C  
ATOM   2292  C   GLU   308      27.386  15.318   7.665  1.00 58.28           C  
ATOM   2293  O   GLU   308      28.396  14.646   7.582  1.00 57.19           O  
ATOM   2294  CB  GLU   308      26.672  16.146   9.994  1.00 62.01           C  
ATOM   2295  CG  GLU   308      27.710  15.741  11.112  1.00 64.45           C  
ATOM   2296  CD  GLU   308      27.100  15.204  12.438  1.00 66.17           C  
ATOM   2297  OE1 GLU   308      26.057  14.504  12.406  1.00 74.01           O  
ATOM   2298  OE2 GLU   308      27.705  15.442  13.523  1.00 82.29           O  
ATOM   2299  N   GLU   309      26.323  15.131   6.884  1.00 56.89           N  
ATOM   2300  CA  GLU   309      26.215  14.060   5.906  1.00 57.35           C  
ATOM   2301  C   GLU   309      27.263  14.198   4.803  1.00 57.25           C  
ATOM   2302  O   GLU   309      27.924  13.219   4.446  1.00 56.95           O  
ATOM   2303  CB  GLU   309      24.797  14.007   5.285  1.00 59.26           C  
ATOM   2304  CG  GLU   309      23.674  13.493   6.241  1.00 63.49           C  
ATOM   2305  CD  GLU   309      23.312  14.466   7.369  1.00 73.49           C  
ATOM   2306  OE1 GLU   309      23.256  15.706   7.132  1.00 72.66           O  
ATOM   2307  OE2 GLU   309      23.080  13.975   8.495  1.00 76.48           O  
ATOM   2308  N   THR   310      27.432  15.404   4.266  1.00 54.46           N  
ATOM   2309  CA  THR   310      28.431  15.620   3.229  1.00 51.76           C  
ATOM   2310  C   THR   310      29.824  15.483   3.822  1.00 52.76           C  
ATOM   2311  O   THR   310      30.729  14.912   3.197  1.00 55.41           O  
ATOM   2312  CB  THR   310      28.256  16.986   2.567  1.00 53.49           C  
ATOM   2313  OG1 THR   310      26.956  17.041   1.990  1.00 55.20           O  
ATOM   2314  CG2 THR   310      29.285  17.211   1.444  1.00 52.64           C  
ATOM   2315  N   ALA   311      30.008  16.034   5.019  1.00 50.52           N  
ATOM   2316  CA  ALA   311      31.277  15.932   5.720  1.00 49.19           C  
ATOM   2317  C   ALA   311      31.689  14.452   5.889  1.00 48.65           C  
ATOM   2318  O   ALA   311      32.884  14.124   5.745  1.00 49.41           O  
ATOM   2319  CB  ALA   311      31.169  16.616   7.114  1.00 47.13           C  
ATOM   2320  N   SER   312      30.723  13.599   6.263  1.00 46.95           N  
ATOM   2321  CA  SER   312      30.915  12.131   6.434  1.00 50.66           C  
ATOM   2322  C   SER   312      31.468  11.472   5.178  1.00 46.93           C  
ATOM   2323  O   SER   312      32.356  10.659   5.257  1.00 50.54           O  
ATOM   2324  CB  SER   312      29.588  11.393   6.731  1.00 51.96           C  
ATOM   2325  OG  SER   312      29.093  11.705   8.000  1.00 67.21           O  
ATOM   2326  N   ALA   313      30.857  11.775   4.046  1.00 44.96           N  
ATOM   2327  CA  ALA   313      31.306  11.265   2.741  1.00 46.84           C  
ATOM   2328  C   ALA   313      32.756  11.664   2.510  1.00 45.11           C  
ATOM   2329  O   ALA   313      33.556  10.848   2.101  1.00 48.10           O  
ATOM   2330  CB  ALA   313      30.397  11.801   1.619  1.00 44.44           C  
ATOM   2331  N   ILE   314      33.097  12.925   2.792  1.00 47.45           N  
ATOM   2332  CA  ILE   314      34.449  13.394   2.616  1.00 46.75           C  
ATOM   2333  C   ILE   314      35.403  12.565   3.491  1.00 47.25           C  
ATOM   2334  O   ILE   314      36.446  12.090   3.020  1.00 45.24           O  
ATOM   2335  CB  ILE   314      34.558  14.915   2.895  1.00 47.78           C  
ATOM   2336  CG1 ILE   314      33.914  15.679   1.745  1.00 48.95           C  
ATOM   2337  CG2 ILE   314      36.023  15.318   3.057  1.00 44.35           C  
ATOM   2338  CD1 ILE   314      33.797  17.158   1.936  1.00 51.85           C  
ATOM   2339  N   LEU   315      35.031  12.368   4.753  1.00 48.16           N  
ATOM   2340  CA  LEU   315      35.822  11.560   5.653  1.00 49.56           C  
ATOM   2341  C   LEU   315      35.978  10.110   5.207  1.00 49.36           C  
ATOM   2342  O   LEU   315      37.047   9.538   5.409  1.00 47.25           O  
ATOM   2343  CB  LEU   315      35.255  11.563   7.078  1.00 51.04           C  
ATOM   2344  CG  LEU   315      35.854  12.567   8.060  1.00 59.62           C  
ATOM   2345  CD1 LEU   315      35.674  14.044   7.569  1.00 51.16           C  
ATOM   2346  CD2 LEU   315      35.221  12.282   9.446  1.00 52.56           C  
ATOM   2347  N   SER   316      34.923   9.512   4.640  1.00 49.02           N  
ATOM   2348  CA  SER   316      34.996   8.106   4.182  1.00 47.88           C  
ATOM   2349  C   SER   316      36.082   8.026   3.098  1.00 47.56           C  
ATOM   2350  O   SER   316      36.860   7.078   3.063  1.00 49.39           O  
ATOM   2351  CB  SER   316      33.642   7.620   3.698  1.00 48.36           C  
ATOM   2352  OG  SER   316      33.242   8.292   2.495  1.00 55.46           O  
ATOM   2353  N   ASP   317      36.191   9.078   2.273  1.00 46.72           N  
ATOM   2354  CA  ASP   317      37.227   9.137   1.230  1.00 46.53           C  
ATOM   2355  C   ASP   317      38.627   9.292   1.807  1.00 50.16           C  
ATOM   2356  O   ASP   317      39.573   8.696   1.312  1.00 53.23           O  
ATOM   2357  CB  ASP   317      36.938  10.256   0.239  1.00 41.60           C  
ATOM   2358  CG  ASP   317      35.834   9.908  -0.751  1.00 43.80           C  
ATOM   2359  OD1 ASP   317      35.538   8.695  -0.958  1.00 52.19           O  
ATOM   2360  OD2 ASP   317      35.326  10.862  -1.390  1.00 50.91           O  
ATOM   2361  N   LEU   318      38.760  10.086   2.862  1.00 52.68           N  
ATOM   2362  CA  LEU   318      40.060  10.306   3.503  1.00 52.67           C  
ATOM   2363  C   LEU   318      40.528   8.961   4.104  1.00 50.21           C  
ATOM   2364  O   LEU   318      41.663   8.570   3.915  1.00 48.06           O  
ATOM   2365  CB  LEU   318      39.920  11.404   4.559  1.00 54.71           C  
ATOM   2366  CG  LEU   318      41.133  12.145   5.091  1.00 58.12           C  
ATOM   2367  CD1 LEU   318      41.863  12.903   3.970  1.00 62.27           C  
ATOM   2368  CD2 LEU   318      40.626  13.101   6.178  1.00 56.81           C  
ATOM   2369  N   TYR   319      39.620   8.261   4.789  1.00 48.95           N  
ATOM   2370  CA  TYR   319      39.844   6.910   5.310  1.00 50.03           C  
ATOM   2371  C   TYR   319      40.305   5.925   4.213  1.00 49.32           C  
ATOM   2372  O   TYR   319      41.253   5.163   4.388  1.00 49.39           O  
ATOM   2373  CB  TYR   319      38.543   6.354   5.911  1.00 49.58           C  
ATOM   2374  CG  TYR   319      38.735   5.000   6.509  1.00 50.71           C  
ATOM   2375  CD1 TYR   319      39.209   4.868   7.816  1.00 53.95           C  
ATOM   2376  CD2 TYR   319      38.503   3.839   5.769  1.00 49.76           C  
ATOM   2377  CE1 TYR   319      39.417   3.611   8.382  1.00 50.20           C  
ATOM   2378  CE2 TYR   319      38.715   2.570   6.332  1.00 50.70           C  
ATOM   2379  CZ  TYR   319      39.181   2.473   7.636  1.00 48.87           C  
ATOM   2380  OH  TYR   319      39.412   1.243   8.222  1.00 55.17           O  
ATOM   2381  N   GLU   320      39.610   5.942   3.087  1.00 48.44           N  
ATOM   2382  CA  GLU   320      39.949   5.081   1.969  1.00 47.40           C  
ATOM   2383  C   GLU   320      41.382   5.376   1.478  1.00 47.27           C  
ATOM   2384  O   GLU   320      42.144   4.470   1.218  1.00 47.01           O  
ATOM   2385  CB  GLU   320      38.899   5.230   0.862  1.00 48.25           C  
ATOM   2386  CG  GLU   320      39.146   4.413  -0.404  1.00 53.06           C  
ATOM   2387  CD  GLU   320      39.248   2.937  -0.131  1.00 60.01           C  
ATOM   2388  OE1 GLU   320      38.389   2.421   0.625  1.00 62.46           O  
ATOM   2389  OE2 GLU   320      40.173   2.300  -0.683  1.00 64.07           O  
ATOM   2390  N   ILE   321      41.783   6.634   1.401  1.00 47.78           N  
ATOM   2391  CA  ILE   321      43.124   6.945   0.927  1.00 46.61           C  
ATOM   2392  C   ILE   321      44.188   6.472   1.918  1.00 49.20           C  
ATOM   2393  O   ILE   321      45.181   5.905   1.503  1.00 49.99           O  
ATOM   2394  CB  ILE   321      43.345   8.474   0.697  1.00 46.65           C  
ATOM   2395  CG1 ILE   321      42.435   9.044  -0.399  1.00 47.24           C  
ATOM   2396  CG2 ILE   321      44.833   8.770   0.354  1.00 46.81           C  
ATOM   2397  CD1 ILE   321      42.475  10.581  -0.480  1.00 44.25           C  
ATOM   2398  N   TYR   322      43.944   6.659   3.217  1.00 51.37           N  
ATOM   2399  CA  TYR   322      44.955   6.426   4.255  1.00 52.11           C  
ATOM   2400  C   TYR   322      44.790   5.294   5.274  1.00 52.84           C  
ATOM   2401  O   TYR   322      45.648   5.158   6.141  1.00 52.73           O  
ATOM   2402  CB  TYR   322      45.131   7.731   5.054  1.00 52.56           C  
ATOM   2403  CG  TYR   322      45.728   8.878   4.272  1.00 50.98           C  
ATOM   2404  CD1 TYR   322      47.060   8.846   3.839  1.00 48.79           C  
ATOM   2405  CD2 TYR   322      44.983  10.011   4.001  1.00 45.02           C  
ATOM   2406  CE1 TYR   322      47.617   9.924   3.125  1.00 52.27           C  
ATOM   2407  CE2 TYR   322      45.528  11.084   3.301  1.00 45.41           C  
ATOM   2408  CZ  TYR   322      46.823  11.035   2.861  1.00 48.21           C  
ATOM   2409  OH  TYR   322      47.315  12.106   2.173  1.00 52.00           O  
ATOM   2410  N   ALA   323      43.736   4.487   5.217  1.00 53.51           N  
ATOM   2411  CA  ALA   323      43.591   3.392   6.196  1.00 53.48           C  
ATOM   2412  C   ALA   323      44.597   2.246   5.980  1.00 58.30           C  
ATOM   2413  O   ALA   323      44.793   1.789   4.856  1.00 59.82           O  
ATOM   2414  CB  ALA   323      42.200   2.847   6.174  1.00 53.05           C  
ATOM   2415  N   GLY   324      45.207   1.768   7.069  1.00 60.94           N  
ATOM   2416  CA  GLY   324      46.171   0.668   7.002  1.00 63.08           C  
ATOM   2417  C   GLY   324      46.514   0.095   8.376  1.00 65.62           C  
ATOM   2418  O   GLY   324      47.440  -0.725   8.525  1.00 67.71           O  
END
