
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   81 (  629),  selected   81 , name 2o1r_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2o1r_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -2_A      D       5          4.211
LGA    N    -1_A      E       6          0.639
LGA    A     0_A      I       7          0.464
LGA    I     1_A      V       8          0.167
LGA    Q     2_A      Q       9          0.610
LGA    Q     3_A      R      10          0.426
LGA    S     4_A      E      11          0.601
LGA    D     5_A      D      12          0.728
LGA    G     6_A      G      13          0.696
LGA    S     7_A      S      14          0.579
LGA    X     8_A      W      15          0.887
LGA    I     9_A      L      16          0.886
LGA    I    10_A      V      17          0.633
LGA    D    11_A      D      18          0.691
LGA    G    12_A      G      19          0.326
LGA    S    13_A      M      20          0.577
LGA    A    14_A      V      21          0.820
LGA    N    15_A      S      22          0.863
LGA    L    16_A      L      23          0.955
LGA    R    17_A      D      24          1.365
LGA    D    18_A      R      25          1.003
LGA    L    19_A      F      26          1.006
LGA    N    20_A      R      27          1.200
LGA    K    21_A      E      28          1.005
LGA    X    22_A      F      29          1.450
LGA    F    23_A      F      30          1.806
LGA    N    24_A      E      31          0.418
LGA    W    25_A      L      32          2.248
LGA    E    26_A      E      33          4.152
LGA    L    27_A      A      34          5.327
LGA    D    28_A      P      35          1.899
LGA    -       -      L      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    T    29_A      E      39          3.293
LGA    E    30_A      A      40          2.427
LGA    D    31_A      G      41          3.247
LGA    -       -      G      42           -
LGA    -       -      N      43           -
LGA    A    32_A      I      44          1.317
LGA    R    33_A      H      45          0.483
LGA    T    34_A      T      46          0.603
LGA    F    35_A      L      47          0.370
LGA    N    36_A      A      48          0.489
LGA    G    37_A      G      49          0.514
LGA    L    38_A      V      50          0.970
LGA    I    39_A      M      51          1.231
LGA    L    40_A      L      52          0.658
LGA    E    41_A      Y      53          1.038
LGA    H    42_A      Q      54          1.500
LGA    L    43_A      L      55          1.862
LGA    E    44_A      G      56          3.035
LGA    E    45_A      R      57          4.225
LGA    I    46_A      V      58          1.736
LGA    P    47_A      P      59          1.364
LGA    D    48_A      S      60          0.731
LGA    E    49_A      V      61          0.730
LGA    G    50_A      T      62          1.498
LGA    T    51_A      D      63          1.698
LGA    I    52_A      R      64          2.072
LGA    C    53_A      F      65          1.464
LGA    E    54_A      E      66          1.607
LGA    I    55_A      W      67          2.975
LGA    D    56_A      N      68          4.051
LGA    G    57_A      G      69          3.248
LGA    L    58_A      F      70          1.563
LGA    L    59_A      S      71          0.712
LGA    I    60_A      F      72          1.333
LGA    T    61_A      E      73          1.569
LGA    I    62_A      V      74          0.852
LGA    L    63_A      V      75          0.781
LGA    E    64_A      D      76          0.553
LGA    V    65_A      M      77          0.908
LGA    G    66_A      D      78          1.565
LGA    D    67_A      R      79          3.597
LGA    N    68_A      T      80          1.370
LGA    X    69_A      R      81          2.179
LGA    I    70_A      V      82          1.028
LGA    K    71_A      D      83          0.665
LGA    Q    72_A      K      84          0.488
LGA    A    73_A      I      85          0.726
LGA    K    74_A      L      86          0.675
LGA    V    75_A      V      87          0.857
LGA    V    76_A      Q      88          0.920
LGA    K    77_A      R      89          1.302
LGA    L    78_A      H      90          3.686
LGA    -       -      H      91           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   81   87    5.0     81    1.81    20.99     85.274     4.235

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.841325 * X  +  -0.072791 * Y  +  -0.535606 * Z  +  57.992588
  Y_new =  -0.524769 * X  +   0.347529 * Y  +   0.777072 * Z  + -29.550028
  Z_new =   0.129575 * X  +   0.934840 * Y  +  -0.330583 * Z  +   4.599896 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.910698   -1.230895  [ DEG:   109.4749    -70.5251 ]
  Theta =  -0.129940   -3.011652  [ DEG:    -7.4450   -172.5550 ]
  Phi   =  -2.583899    0.557693  [ DEG:  -148.0465     31.9535 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o1r_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o1r_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   81   87   5.0   81   1.81   20.99  85.274
REMARK  ---------------------------------------------------------- 
MOLECULE 2o1r_A
HEADER    MEMBRANE PROTEIN                        29-NOV-06   2O1R              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF A CONSERVED             
TITLE    2 PUTATIVE PROTEIN FROM HAEMOPHILUS INFLUENZAE RD KW20                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0053 PROTEIN HI0107;                                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 343-420;                                          
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: UNKNOWN PEPTIDE FRAGMENT;                                  
COMPND   8 CHAIN: X;                                                            
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: RD KW20;                                                     
SOURCE   5 GENE: HI0107;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG19;                                  
SOURCE  11 MOL_ID: 2;                                                           
SOURCE  12 SYNTHETIC: YES;                                                      
SOURCE  13 OTHER_DETAILS: PEPTIDE FRAGMENT OF UNKNOWN SOURCE, ITS               
SOURCE  14 SEQUENCE HAS BEEN ASSIGNED ACCORDING TO ELECTRON DENSITY             
KEYWDS    APC85784.2, CONSERVED PUTATIVE PROTEIN, HAEMOPHILUS                   
KEYWDS   2 INFLUENZAE RD KW20, STRUCTURAL GENOMICS, PSI-2, PROTEIN              
KEYWDS   3 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   4 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,H.LI,M.BARGASSA,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER            
AUTHOR   2 FOR STRUCTURAL GENOMICS (MCSG)                                       
REVDAT   1   26-DEC-06 2O1R    0                                                
JRNL        AUTH   K.TAN,H.LI,M.BARGASSA,S.CLANCY,A.JOACHIMIAK                  
JRNL        TITL   THE CRYSTAL STRUCTURE OF A CONSERVED PUTATIVE                
JRNL        TITL 2 PROTEIN FROM HAEMOPHILUS INFLUENZAE RD KW20                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.52 ANGSTROMS.                                          
DBREF  2O1R A    1    78  UNP    Q57017   Y107_HAEIN     343    420             
SEQRES   1 A   81  SER ASN ALA ILE GLN GLN SER ASP GLY SER MSE ILE ILE          
SEQRES   2 A   81  ASP GLY SER ALA ASN LEU ARG ASP LEU ASN LYS MSE PHE          
SEQRES   3 A   81  ASN TRP GLU LEU ASP THR GLU ASP ALA ARG THR PHE ASN          
SEQRES   4 A   81  GLY LEU ILE LEU GLU HIS LEU GLU GLU ILE PRO ASP GLU          
SEQRES   5 A   81  GLY THR ILE CYS GLU ILE ASP GLY LEU LEU ILE THR ILE          
SEQRES   6 A   81  LEU GLU VAL GLY ASP ASN MSE ILE LYS GLN ALA LYS VAL          
SEQRES   7 A   81  VAL LYS LEU                                                  
SEQRES   1 X    3  ILE PHE GLY                                                  
HET    MSE  A   8      13                                                       
HET    MSE  A  22      16                                                       
HET    MSE  A  69      16                                                       
HET    EDO    201       4                                                       
HET    EDO    202       4                                                       
HET    EDO    203       4                                                       
HET    EDO    204       4                                                       
HET    EDO    205       4                                                       
HET    EDO    206       4                                                       
HET    EDO    207       4                                                       
HET    EDO    208       4                                                       
HET    EDO    209       4                                                       
HET    EDO    210       4                                                       
HET    EDO    211       4                                                       
HET    EDO    212       4                                                       
HET    PEG    101       7                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   3  EDO    12(C2 H6 O2)                                                 
FORMUL  15  PEG    C4 H10 O3                                                    
FORMUL  16  HOH   *61(H2 O)                                                     
CRYST1   25.604   77.563   79.107  90.00  90.00  90.00 C 2 2 21      8          
ATOM      1  N   SER A  -2      10.953   8.930  26.822  1.00 19.22           N  
ATOM      2  CA  SER A  -2      11.672   8.172  25.767  1.00 14.76           C  
ATOM      3  C   SER A  -2      12.626   7.226  26.411  1.00 16.53           C  
ATOM      4  O   SER A  -2      13.104   7.479  27.534  1.00 19.39           O  
ATOM      5  CB  SER A  -2      12.445   9.137  24.864  1.00 18.95           C  
ATOM      6  OG  SER A  -2      11.601  10.145  24.430  1.00 21.45           O  
ATOM      7  N   ASN A  -1      12.840   6.074  25.764  1.00 18.59           N  
ATOM      8  CA  ASN A  -1      13.525   4.943  26.356  1.00 21.53           C  
ATOM      9  C   ASN A  -1      14.773   4.822  25.500  1.00 22.29           C  
ATOM     10  O   ASN A  -1      14.784   5.106  24.233  1.00 24.90           O  
ATOM     11  CB  ASN A  -1      12.622   3.597  26.363  1.00 22.13           C  
ATOM     12  CG  ASN A  -1      11.300   3.685  27.301  1.00 25.47           C  
ATOM     13  OD1 ASN A  -1      10.209   3.081  27.019  1.00 33.25           O  
ATOM     14  ND2 ASN A  -1      11.441   4.329  28.422  1.00 31.10           N  
ATOM     15  N   ALA A   0      15.862   4.384  26.126  0.50 23.27           N  
ATOM     17  CA  ALA A   0      17.184   4.306  25.455  0.50 22.02           C  
ATOM     19  C   ALA A   0      18.110   3.225  26.042  0.50 21.11           C  
ATOM     21  O   ALA A   0      18.614   3.429  27.200  0.50 21.05           O  
ATOM     23  CB  ALA A   0      17.829   5.594  25.560  0.50 22.03           C  
ATOM     25  N   ILE A   1      18.343   2.137  25.247  1.00 16.59           N  
ATOM     26  CA  ILE A   1      18.820   0.817  25.724  1.00 17.28           C  
ATOM     27  C   ILE A   1      20.285   0.667  25.348  1.00 15.89           C  
ATOM     28  O   ILE A   1      20.601   0.755  24.194  1.00 14.32           O  
ATOM     29  CB  ILE A   1      17.970  -0.326  25.156  1.00 20.45           C  
ATOM     30  CG1 ILE A   1      16.453  -0.154  25.571  1.00 25.46           C  
ATOM     31  CG2 ILE A   1      18.477  -1.663  25.698  1.00 23.28           C  
ATOM     32  CD1 ILE A   1      15.542  -1.288  24.978  1.00 25.89           C  
ATOM     33  N   GLN A   2      21.161   0.503  26.306  1.00 15.98           N  
ATOM     34  CA  GLN A   2      22.549   0.127  25.977  1.00 17.06           C  
ATOM     35  C   GLN A   2      22.618  -1.338  25.537  1.00 19.79           C  
ATOM     36  O   GLN A   2      22.086  -2.237  26.219  1.00 19.23           O  
ATOM     37  CB  GLN A   2      23.466   0.276  27.173  1.00 19.15           C  
ATOM     38  CG  GLN A   2      24.915   0.106  26.695  1.00 23.74           C  
ATOM     39  CD  GLN A   2      25.844   0.060  27.809  1.00 30.76           C  
ATOM     40  OE1 GLN A   2      25.550  -0.578  28.837  1.00 34.94           O  
ATOM     41  NE2 GLN A   2      27.012   0.705  27.646  1.00 29.94           N  
ATOM     42  N   GLN A   3      23.336  -1.579  24.442  1.00 20.55           N  
ATOM     43  CA  GLN A   3      23.497  -2.932  23.913  1.00 22.30           C  
ATOM     44  C   GLN A   3      24.803  -3.475  24.486  1.00 24.16           C  
ATOM     45  O   GLN A   3      25.640  -2.734  24.994  1.00 22.63           O  
ATOM     46  CB  GLN A   3      23.424  -2.986  22.379  1.00 24.34           C  
ATOM     47  CG  GLN A   3      22.212  -2.199  21.870  1.00 24.15           C  
ATOM     48  CD  GLN A   3      20.948  -2.897  22.374  1.00 27.26           C  
ATOM     49  OE1 GLN A   3      20.833  -4.077  22.214  1.00 31.97           O  
ATOM     50  NE2 GLN A   3      20.094  -2.194  23.081  1.00 28.40           N  
ATOM     51  N   SER A   4      24.894  -4.796  24.448  1.00 27.42           N  
ATOM     52  CA  SER A   4      26.096  -5.474  24.906  1.00 29.20           C  
ATOM     53  C   SER A   4      27.361  -5.044  24.158  1.00 29.26           C  
ATOM     54  O   SER A   4      28.454  -5.120  24.740  1.00 30.83           O  
ATOM     55  CB  SER A   4      25.889  -6.998  24.837  1.00 29.23           C  
ATOM     56  OG  SER A   4      25.652  -7.404  23.469  1.00 33.53           O  
ATOM     57  N   ASP A   5      27.234  -4.590  22.905  1.00 25.66           N  
ATOM     58  CA  ASP A   5      28.415  -4.172  22.169  1.00 25.71           C  
ATOM     59  C   ASP A   5      28.743  -2.718  22.394  1.00 23.54           C  
ATOM     60  O   ASP A   5      29.634  -2.176  21.744  1.00 25.11           O  
ATOM     61  CB  ASP A   5      28.284  -4.500  20.685  1.00 24.31           C  
ATOM     62  CG  ASP A   5      27.294  -3.620  19.982  1.00 24.43           C  
ATOM     63  OD1 ASP A   5      26.622  -2.794  20.674  1.00 24.07           O  
ATOM     64  OD2 ASP A   5      27.204  -3.744  18.729  1.00 24.42           O  
ATOM     65  N   GLY A   6      27.957  -2.053  23.277  1.00 21.44           N  
ATOM     66  CA  GLY A   6      28.242  -0.662  23.636  1.00 23.06           C  
ATOM     67  C   GLY A   6      27.475   0.341  22.786  1.00 21.62           C  
ATOM     68  O   GLY A   6      27.487   1.596  23.095  1.00 24.25           O  
ATOM     69  N   SER A   7      26.786  -0.157  21.760  1.00 17.09           N  
ATOM     70  CA  SER A   7      25.921   0.773  20.997  1.00 15.87           C  
ATOM     71  C   SER A   7      24.682   1.069  21.838  1.00 14.44           C  
ATOM     72  O   SER A   7      24.420   0.404  22.829  1.00 18.03           O  
ATOM     73  CB  SER A   7      25.549   0.226  19.639  1.00 15.62           C  
ATOM     74  OG  SER A   7      24.772  -0.930  19.800  1.00 17.30           O  
HETATM   75  N   MSE A   8      23.984   2.130  21.470  1.00 13.02           N  
HETATM   76  CA  MSE A   8      22.735   2.598  22.127  0.50 11.98           C  
HETATM   78  C   MSE A   8      21.579   2.407  21.163  1.00 11.95           C  
HETATM   79  O   MSE A   8      21.739   2.749  20.014  1.00 13.49           O  
HETATM   80  CB  MSE A   8      22.753   4.143  22.399  0.50 12.92           C  
HETATM   82  CG  MSE A   8      23.738   4.611  23.412  0.50 15.94           C  
HETATM   84 SE   MSE A   8      23.507   3.738  25.233  0.30 24.34          SE  
HETATM   86  CE  MSE A   8      21.653   3.770  25.317  0.50 10.13           C  
ATOM     88  N   ILE A   9      20.421   1.945  21.623  1.00  9.91           N  
ATOM     89  CA  ILE A   9      19.204   2.061  20.798  0.50 10.24           C  
ATOM     91  C   ILE A   9      18.365   3.195  21.377  1.00 10.13           C  
ATOM     92  O   ILE A   9      18.048   3.193  22.583  1.00 11.18           O  
ATOM     93  CB  ILE A   9      18.350   0.765  20.821  0.50 11.09           C  
ATOM     95  CG1 ILE A   9      19.237  -0.443  20.508  0.50 15.62           C  
ATOM     97  CG2 ILE A   9      17.251   0.796  19.714  0.50 10.71           C  
ATOM     99  CD1 ILE A   9      20.306  -0.168  19.562  0.50 16.43           C  
ATOM    101  N   ILE A  10      18.036   4.181  20.571  0.50 11.45           N  
ATOM    103  CA  ILE A  10      17.327   5.314  21.131  0.50 11.00           C  
ATOM    105  C   ILE A  10      16.120   5.635  20.272  0.50 10.87           C  
ATOM    107  O   ILE A  10      16.153   5.542  19.027  0.50  8.30           O  
ATOM    109  CB  ILE A  10      18.195   6.501  21.145  0.50 13.15           C  
ATOM    111  CG1 ILE A  10      18.617   6.697  19.730  0.50 11.87           C  
ATOM    113  CG2 ILE A  10      19.409   6.297  22.011  0.50 13.46           C  
ATOM    115  CD1 ILE A  10      17.642   7.280  19.031  0.50 17.62           C  
ATOM    117  N   ASP A  11      15.077   6.029  20.963  1.00 11.68           N  
ATOM    118  CA  ASP A  11      13.809   6.277  20.331  1.00 11.42           C  
ATOM    119  C   ASP A  11      13.914   7.558  19.500  1.00 11.85           C  
ATOM    120  O   ASP A  11      14.587   8.546  19.948  1.00 11.87           O  
ATOM    121  CB  ASP A  11      12.766   6.575  21.432  1.00 15.10           C  
ATOM    122  CG  ASP A  11      12.325   5.358  22.147  1.00 17.03           C  
ATOM    123  OD1 ASP A  11      12.512   4.195  21.648  1.00 20.42           O  
ATOM    124  OD2 ASP A  11      11.734   5.637  23.257  1.00 22.35           O  
ATOM    125  N   GLY A  12      13.152   7.620  18.420  1.00 11.10           N  
ATOM    126  CA  GLY A  12      12.982   8.853  17.653  1.00 11.01           C  
ATOM    127  C   GLY A  12      12.531  10.050  18.521  1.00  9.27           C  
ATOM    128  O   GLY A  12      12.904  11.217  18.269  1.00 11.27           O  
ATOM    129  N   SER A  13      11.674   9.760  19.535  1.00 10.95           N  
ATOM    130  CA  SER A  13      11.096  10.818  20.359  1.00 10.18           C  
ATOM    131  C   SER A  13      12.098  11.445  21.332  1.00 10.90           C  
ATOM    132  O   SER A  13      11.785  12.418  21.997  1.00 11.77           O  
ATOM    133  CB  SER A  13       9.971  10.282  21.204  1.00 11.67           C  
ATOM    134  OG  SER A  13      10.440   9.220  22.042  1.00 13.98           O  
ATOM    135  N   ALA A  14      13.321  10.877  21.394  1.00  9.30           N  
ATOM    136  CA  ALA A  14      14.288  11.338  22.387  1.00 10.52           C  
ATOM    137  C   ALA A  14      14.571  12.835  22.170  1.00  9.86           C  
ATOM    138  O   ALA A  14      14.838  13.253  21.047  1.00 12.51           O  
ATOM    139  CB  ALA A  14      15.615  10.549  22.269  1.00 11.72           C  
ATOM    140  N   ASN A  15      14.566  13.582  23.280  1.00 11.44           N  
ATOM    141  CA  ASN A  15      14.842  15.007  23.274  1.00  9.96           C  
ATOM    142  C   ASN A  15      16.355  15.244  23.110  1.00 11.02           C  
ATOM    143  O   ASN A  15      17.165  14.671  23.855  1.00 12.15           O  
ATOM    144  CB  ASN A  15      14.285  15.602  24.579  1.00 11.61           C  
ATOM    145  CG  ASN A  15      14.528  17.034  24.734  1.00 14.51           C  
ATOM    146  OD1 ASN A  15      15.615  17.438  25.177  1.00 16.71           O  
ATOM    147  ND2 ASN A  15      13.556  17.824  24.371  1.00 15.85           N  
ATOM    148  N   LEU A  16      16.718  16.092  22.151  1.00 10.43           N  
ATOM    149  CA  LEU A  16      18.130  16.298  21.804  1.00 11.00           C  
ATOM    150  C   LEU A  16      18.864  16.916  22.975  1.00 11.78           C  
ATOM    151  O   LEU A  16      20.009  16.488  23.274  1.00 12.96           O  
ATOM    152  CB  LEU A  16      18.277  17.194  20.563  1.00  9.76           C  
ATOM    153  CG  LEU A  16      17.729  16.623  19.280  1.00 10.77           C  
ATOM    154  CD1 LEU A  16      17.846  17.725  18.203  1.00 12.91           C  
ATOM    155  CD2 LEU A  16      18.428  15.318  18.898  1.00 13.27           C  
ATOM    156  N   ARG A  17      18.271  17.893  23.676  1.00 12.87           N  
ATOM    157  CA  ARG A  17      19.016  18.506  24.822  1.00 14.61           C  
ATOM    158  C   ARG A  17      19.229  17.464  25.914  1.00 14.70           C  
ATOM    159  O   ARG A  17      20.295  17.446  26.550  1.00 16.72           O  
ATOM    160  CB  ARG A  17      18.268  19.733  25.343  1.00 16.10           C  
ATOM    161  CG  ARG A  17      18.273  20.857  24.347  1.00 16.08           C  
ATOM    162  CD  ARG A  17      17.585  22.037  24.941  1.00 21.59           C  
ATOM    163  NE  ARG A  17      17.885  23.228  24.163  1.00 26.99           N  
ATOM    164  CZ  ARG A  17      17.094  24.305  24.108  1.00 31.06           C  
ATOM    165  NH1 ARG A  17      15.919  24.333  24.753  1.00 30.40           N  
ATOM    166  NH2 ARG A  17      17.491  25.327  23.370  1.00 33.63           N  
ATOM    167  N   ASP A  18      18.223  16.593  26.153  1.00 13.82           N  
ATOM    168  CA  ASP A  18      18.391  15.490  27.112  1.00 15.63           C  
ATOM    169  C   ASP A  18      19.524  14.513  26.716  1.00 14.70           C  
ATOM    170  O   ASP A  18      20.349  14.123  27.574  1.00 15.47           O  
ATOM    171  CB  ASP A  18      17.125  14.653  27.261  1.00 16.57           C  
ATOM    172  CG  ASP A  18      15.992  15.393  27.929  1.00 20.36           C  
ATOM    173  OD1 ASP A  18      16.242  16.440  28.511  1.00 21.33           O  
ATOM    174  OD2 ASP A  18      14.844  14.876  27.915  1.00 24.77           O  
ATOM    175  N   LEU A  19      19.580  14.156  25.423  1.00 13.70           N  
ATOM    176  CA  LEU A  19      20.640  13.263  24.979  1.00 13.83           C  
ATOM    177  C   LEU A  19      22.003  13.895  25.164  1.00 14.85           C  
ATOM    178  O   LEU A  19      22.974  13.236  25.621  1.00 15.94           O  
ATOM    179  CB  LEU A  19      20.461  12.916  23.492  1.00 13.85           C  
ATOM    180  CG  LEU A  19      19.228  12.109  23.141  1.00 13.07           C  
ATOM    181  CD1 LEU A  19      19.069  11.966  21.621  1.00 14.02           C  
ATOM    182  CD2 LEU A  19      19.306  10.623  23.713  1.00 14.41           C  
ATOM    183  N   ASN A  20      22.120  15.150  24.756  1.00 16.61           N  
ATOM    184  CA  ASN A  20      23.409  15.838  24.913  1.00 16.94           C  
ATOM    185  C   ASN A  20      23.840  15.889  26.382  1.00 19.60           C  
ATOM    186  O   ASN A  20      25.063  15.555  26.674  1.00 21.21           O  
ATOM    187  CB  ASN A  20      23.315  17.255  24.353  1.00 19.19           C  
ATOM    188  CG  ASN A  20      23.377  17.285  22.875  1.00 15.91           C  
ATOM    189  OD1 ASN A  20      23.733  16.278  22.217  1.00 19.97           O  
ATOM    190  ND2 ASN A  20      23.103  18.479  22.306  1.00 19.38           N  
ATOM    191  N   LYS A  21      22.913  16.265  27.281  1.00 18.72           N  
ATOM    192  CA  LYS A  21      23.230  16.284  28.725  1.00 21.82           C  
ATOM    193  C   LYS A  21      23.621  14.946  29.258  1.00 20.26           C  
ATOM    194  O   LYS A  21      24.612  14.859  30.065  1.00 22.46           O  
ATOM    195  CB  LYS A  21      22.070  16.827  29.552  1.00 21.44           C  
ATOM    196  CG  LYS A  21      22.428  16.917  31.052  1.00 28.74           C  
ATOM    197  CD  LYS A  21      21.802  18.053  31.825  1.00 34.49           C  
ATOM    198  CE  LYS A  21      22.266  17.912  33.293  1.00 34.53           C  
ATOM    199  NZ  LYS A  21      22.836  19.212  33.859  1.00 38.70           N  
HETATM  200  N   MSE A  22      22.890  13.888  28.865  0.50 18.21           N  
HETATM  202  CA  MSE A  22      23.114  12.569  29.475  0.50 17.49           C  
HETATM  204  C   MSE A  22      24.370  11.860  28.969  0.50 18.10           C  
HETATM  206  O   MSE A  22      25.064  11.147  29.724  0.50 15.92           O  
HETATM  208  CB  MSE A  22      21.833  11.748  29.327  0.50 16.34           C  
HETATM  210  CG  MSE A  22      20.584  12.512  29.783  0.50 17.00           C  
HETATM  212 SE   MSE A  22      19.352  11.151  29.872  0.00 35.74          SE  
HETATM  214  CE  MSE A  22      20.255   8.961  29.511  0.50 10.51           C  
ATOM    216  N   PHE A  23      24.642  12.014  27.671  1.00 19.84           N  
ATOM    217  CA  PHE A  23      25.714  11.249  26.992  1.00 20.61           C  
ATOM    218  C   PHE A  23      26.948  12.064  26.589  1.00 22.83           C  
ATOM    219  O   PHE A  23      27.879  11.460  26.015  1.00 23.47           O  
ATOM    220  CB  PHE A  23      25.142  10.519  25.793  1.00 20.71           C  
ATOM    221  CG  PHE A  23      24.012   9.635  26.118  1.00 19.82           C  
ATOM    222  CD1 PHE A  23      24.051   8.769  27.251  1.00 24.50           C  
ATOM    223  CD2 PHE A  23      22.883   9.628  25.369  1.00 17.79           C  
ATOM    224  CE1 PHE A  23      22.957   7.936  27.623  1.00 26.09           C  
ATOM    225  CE2 PHE A  23      21.797   8.767  25.693  1.00 17.82           C  
ATOM    226  CZ  PHE A  23      21.829   7.914  26.842  1.00 22.10           C  
ATOM    227  N   ASN A  24      26.920  13.377  26.821  1.00 23.28           N  
ATOM    228  CA  ASN A  24      28.011  14.238  26.385  0.50 24.71           C  
ATOM    230  C   ASN A  24      28.106  14.330  24.857  1.00 25.26           C  
ATOM    231  O   ASN A  24      29.239  14.514  24.296  1.00 26.92           O  
ATOM    232  CB  ASN A  24      29.345  13.722  26.966  0.50 25.65           C  
ATOM    234  CG  ASN A  24      30.466  14.646  26.698  0.50 25.21           C  
ATOM    236  OD1 ASN A  24      30.258  15.859  26.531  0.50 28.73           O  
ATOM    238  ND2 ASN A  24      31.678  14.109  26.649  0.50 26.85           N  
ATOM    240  N   TRP A  25      26.971  14.167  24.186  1.00 23.69           N  
ATOM    241  CA  TRP A  25      26.893  14.237  22.720  1.00 19.87           C  
ATOM    242  C   TRP A  25      26.842  15.667  22.270  1.00 21.07           C  
ATOM    243  O   TRP A  25      26.657  16.633  23.079  1.00 21.12           O  
ATOM    244  CB  TRP A  25      25.726  13.419  22.160  1.00 21.12           C  
ATOM    245  CG  TRP A  25      25.834  11.855  22.329  1.00 15.71           C  
ATOM    246  CD1 TRP A  25      26.949  11.096  22.689  1.00 19.46           C  
ATOM    247  CD2 TRP A  25      24.784  10.907  22.066  1.00 17.28           C  
ATOM    248  NE1 TRP A  25      26.608   9.750  22.696  1.00 18.63           N  
ATOM    249  CE2 TRP A  25      25.291   9.606  22.324  1.00 19.34           C  
ATOM    250  CE3 TRP A  25      23.447  11.034  21.675  1.00 18.18           C  
ATOM    251  CZ2 TRP A  25      24.505   8.463  22.209  1.00 19.66           C  
ATOM    252  CZ3 TRP A  25      22.642   9.857  21.580  1.00 19.81           C  
ATOM    253  CH2 TRP A  25      23.192   8.588  21.818  1.00 20.97           C  
ATOM    254  N   GLU A  26      26.995  15.826  20.958  1.00 19.93           N  
ATOM    255  CA  GLU A  26      26.977  17.172  20.469  1.00 21.19           C  
ATOM    256  C   GLU A  26      26.007  17.366  19.339  1.00 20.06           C  
ATOM    257  O   GLU A  26      26.322  17.944  18.306  1.00 22.58           O  
ATOM    258  CB  GLU A  26      28.394  17.596  20.121  1.00 21.41           C  
ATOM    259  CG  GLU A  26      29.208  17.592  21.466  1.00 25.73           C  
ATOM    260  CD  GLU A  26      30.591  18.151  21.302  1.00 30.54           C  
ATOM    261  OE1 GLU A  26      31.409  17.482  20.661  1.00 29.39           O  
ATOM    262  OE2 GLU A  26      30.846  19.251  21.832  1.00 32.11           O  
ATOM    263  N   LEU A  27      24.784  16.911  19.582  1.00 16.98           N  
ATOM    264  CA  LEU A  27      23.773  17.070  18.564  1.00 16.29           C  
ATOM    265  C   LEU A  27      23.363  18.538  18.457  1.00 15.35           C  
ATOM    266  O   LEU A  27      23.243  19.272  19.480  1.00 16.17           O  
ATOM    267  CB  LEU A  27      22.561  16.230  19.006  1.00 15.23           C  
ATOM    268  CG  LEU A  27      22.949  14.755  19.200  1.00 17.20           C  
ATOM    269  CD1 LEU A  27      21.810  13.917  19.610  1.00 18.61           C  
ATOM    270  CD2 LEU A  27      23.711  14.220  17.915  1.00 24.11           C  
ATOM    271  N   ASP A  28      23.063  18.935  17.212  1.00 16.31           N  
ATOM    272  CA  ASP A  28      22.688  20.333  16.964  1.00 14.42           C  
ATOM    273  C   ASP A  28      21.241  20.516  17.448  1.00 13.61           C  
ATOM    274  O   ASP A  28      20.342  19.829  16.969  1.00 15.44           O  
ATOM    275  CB  ASP A  28      22.783  20.588  15.474  1.00 14.73           C  
ATOM    276  CG  ASP A  28      22.443  21.993  15.098  1.00 18.21           C  
ATOM    277  OD1 ASP A  28      22.065  22.834  15.912  1.00 18.45           O  
ATOM    278  OD2 ASP A  28      22.631  22.262  13.914  1.00 28.11           O  
ATOM    279  N   THR A  29      21.045  21.414  18.392  1.00 12.46           N  
ATOM    280  CA  THR A  29      19.747  21.634  18.998  1.00 12.95           C  
ATOM    281  C   THR A  29      19.055  22.943  18.514  1.00 14.13           C  
ATOM    282  O   THR A  29      17.978  23.310  19.023  1.00 15.78           O  
ATOM    283  CB  THR A  29      19.846  21.729  20.518  1.00 15.57           C  
ATOM    284  OG1 THR A  29      20.676  22.863  20.859  1.00 18.51           O  
ATOM    285  CG2 THR A  29      20.419  20.418  21.125  1.00 17.34           C  
ATOM    286  N   GLU A  30      19.621  23.588  17.516  0.50 14.21           N  
ATOM    288  CA  GLU A  30      19.091  24.897  17.180  0.50 13.75           C  
ATOM    290  C   GLU A  30      17.824  24.857  16.350  0.50 12.68           C  
ATOM    292  O   GLU A  30      17.051  25.801  16.408  0.50 12.80           O  
ATOM    294  CB  GLU A  30      20.127  25.702  16.440  0.50 14.95           C  
ATOM    296  CG  GLU A  30      21.353  26.028  17.280  0.50 17.57           C  
ATOM    298  CD  GLU A  30      22.140  27.138  16.659  0.50 25.65           C  
ATOM    300  OE1 GLU A  30      21.567  27.780  15.752  0.50 26.19           O  
ATOM    302  OE2 GLU A  30      23.319  27.329  17.046  0.50 27.96           O  
ATOM    304  N   ASP A  31      17.605  23.781  15.586  1.00 11.81           N  
ATOM    305  CA  ASP A  31      16.409  23.770  14.744  1.00 11.17           C  
ATOM    306  C   ASP A  31      15.470  22.596  15.016  1.00 11.86           C  
ATOM    307  O   ASP A  31      14.285  22.709  14.692  1.00 13.28           O  
ATOM    308  CB  ASP A  31      16.791  23.759  13.284  1.00 12.13           C  
ATOM    309  CG  ASP A  31      17.466  25.074  12.877  1.00 13.51           C  
ATOM    310  OD1 ASP A  31      16.782  26.106  12.728  1.00 13.32           O  
ATOM    311  OD2 ASP A  31      18.725  25.092  12.782  1.00 19.91           O  
ATOM    312  N   ALA A  32      16.026  21.509  15.536  1.00 11.66           N  
ATOM    313  CA  ALA A  32      15.226  20.324  15.878  1.00 11.20           C  
ATOM    314  C   ALA A  32      15.109  20.176  17.376  1.00 11.28           C  
ATOM    315  O   ALA A  32      15.957  20.672  18.148  1.00 11.79           O  
ATOM    316  CB  ALA A  32      15.895  19.081  15.329  1.00 11.25           C  
ATOM    317  N   ARG A  33      14.032  19.498  17.781  1.00 11.03           N  
ATOM    318  CA  ARG A  33      13.843  19.239  19.199  1.00 10.85           C  
ATOM    319  C   ARG A  33      14.150  17.762  19.572  1.00 10.67           C  
ATOM    320  O   ARG A  33      14.634  17.465  20.679  1.00 11.14           O  
ATOM    321  CB  ARG A  33      12.404  19.490  19.594  1.00 12.54           C  
ATOM    322  CG  ARG A  33      12.183  19.504  21.115  1.00 15.17           C  
ATOM    323  CD  ARG A  33      10.662  19.726  21.419  1.00 16.72           C  
ATOM    324  NE  ARG A  33      10.090  20.794  20.641  1.00 18.11           N  
ATOM    325  CZ  ARG A  33      10.303  22.072  20.908  1.00 19.71           C  
ATOM    326  NH1 ARG A  33      10.996  22.401  21.991  1.00 22.97           N  
ATOM    327  NH2 ARG A  33       9.749  23.001  20.144  1.00 19.84           N  
ATOM    328  N   THR A  34      13.823  16.858  18.649  1.00  9.78           N  
ATOM    329  CA  THR A  34      13.986  15.403  18.948  1.00  9.50           C  
ATOM    330  C   THR A  34      14.976  14.761  17.981  1.00 10.21           C  
ATOM    331  O   THR A  34      15.380  15.374  16.921  1.00  9.72           O  
ATOM    332  CB  THR A  34      12.654  14.701  18.715  1.00 10.08           C  
ATOM    333  OG1 THR A  34      12.276  14.900  17.351  1.00 10.50           O  
ATOM    334  CG2 THR A  34      11.567  15.196  19.633  1.00 11.90           C  
ATOM    335  N   PHE A  35      15.366  13.525  18.329  1.00 10.55           N  
ATOM    336  CA  PHE A  35      16.262  12.785  17.435  1.00 10.39           C  
ATOM    337  C   PHE A  35      15.656  12.541  16.077  1.00  9.09           C  
ATOM    338  O   PHE A  35      16.321  12.715  15.035  1.00 11.56           O  
ATOM    339  CB  PHE A  35      16.652  11.466  18.148  1.00 11.91           C  
ATOM    340  CG  PHE A  35      17.880  10.801  17.601  1.00 14.96           C  
ATOM    341  CD1 PHE A  35      19.056  11.514  17.464  1.00 16.77           C  
ATOM    342  CD2 PHE A  35      17.889   9.484  17.387  1.00 23.62           C  
ATOM    343  CE1 PHE A  35      20.206  10.955  17.005  1.00 24.54           C  
ATOM    344  CE2 PHE A  35      19.107   8.867  16.922  1.00 20.48           C  
ATOM    345  CZ  PHE A  35      20.254   9.676  16.743  1.00 21.96           C  
ATOM    346  N   ASN A  36      14.373  12.178  16.056  1.00 10.16           N  
ATOM    347  CA  ASN A  36      13.629  12.042  14.803  1.00  9.49           C  
ATOM    348  C   ASN A  36      13.716  13.350  14.013  1.00 10.16           C  
ATOM    349  O   ASN A  36      14.013  13.323  12.822  1.00 12.21           O  
ATOM    350  CB  ASN A  36      12.168  11.708  15.137  1.00 10.68           C  
ATOM    351  CG  ASN A  36      11.271  11.780  13.921  1.00 11.03           C  
ATOM    352  OD1 ASN A  36      11.524  11.107  12.890  1.00 12.90           O  
ATOM    353  ND2 ASN A  36      10.256  12.675  13.996  1.00 13.90           N  
ATOM    354  N   GLY A  37      13.425  14.481  14.673  1.00 10.17           N  
ATOM    355  CA  GLY A  37      13.455  15.770  13.933  1.00 10.47           C  
ATOM    356  C   GLY A  37      14.855  16.064  13.364  1.00 10.06           C  
ATOM    357  O   GLY A  37      14.981  16.502  12.233  1.00 12.69           O  
ATOM    358  N   LEU A  38      15.890  15.768  14.120  1.00 10.80           N  
ATOM    359  CA  LEU A  38      17.269  16.045  13.628  1.00 11.70           C  
ATOM    360  C   LEU A  38      17.534  15.202  12.372  1.00 12.02           C  
ATOM    361  O   LEU A  38      18.134  15.668  11.374  1.00 14.82           O  
ATOM    362  CB  LEU A  38      18.284  15.674  14.741  1.00 11.48           C  
ATOM    363  CG  LEU A  38      19.755  15.842  14.408  1.00 13.03           C  
ATOM    364  CD1 LEU A  38      19.886  17.342  14.123  1.00 16.22           C  
ATOM    365  CD2 LEU A  38      20.669  15.262  15.490  1.00 15.25           C  
ATOM    366  N   ILE A  39      17.154  13.906  12.416  1.00 12.25           N  
ATOM    367  CA  ILE A  39      17.417  13.040  11.302  0.50 13.08           C  
ATOM    369  C   ILE A  39      16.564  13.508  10.094  1.00 13.87           C  
ATOM    370  O   ILE A  39      17.086  13.618   8.940  1.00 16.00           O  
ATOM    371  CB  ILE A  39      17.242  11.552  11.705  0.50 10.10           C  
ATOM    373  CG1 ILE A  39      18.114  11.189  12.941  0.50  9.80           C  
ATOM    375  CG2 ILE A  39      17.581  10.625  10.524  0.50 14.61           C  
ATOM    377  CD1 ILE A  39      17.663   9.712  13.449  0.50 12.39           C  
ATOM    379  N   LEU A  40      15.283  13.828  10.302  1.00 14.13           N  
ATOM    380  CA  LEU A  40      14.442  14.211   9.156  1.00 14.77           C  
ATOM    381  C   LEU A  40      14.906  15.532   8.515  1.00 15.50           C  
ATOM    382  O   LEU A  40      14.833  15.715   7.296  1.00 19.82           O  
ATOM    383  CB  LEU A  40      12.997  14.314   9.612  1.00 14.75           C  
ATOM    384  CG  LEU A  40      12.315  13.013  10.027  1.00 17.96           C  
ATOM    385  CD1 LEU A  40      10.961  13.443  10.481  1.00 23.22           C  
ATOM    386  CD2 LEU A  40      12.234  12.105   8.841  1.00 21.69           C  
ATOM    387  N   GLU A  41      15.459  16.412   9.309  1.00 16.32           N  
ATOM    388  CA  GLU A  41      15.810  17.719   8.780  1.00 19.50           C  
ATOM    389  C   GLU A  41      17.022  17.539   7.948  1.00 21.63           C  
ATOM    390  O   GLU A  41      17.285  18.338   7.108  1.00 22.54           O  
ATOM    391  CB  GLU A  41      16.038  18.763   9.891  1.00 20.41           C  
ATOM    392  CG  GLU A  41      14.777  19.089  10.706  1.00 23.18           C  
ATOM    393  CD  GLU A  41      14.988  20.123  11.812  1.00 20.14           C  
ATOM    394  OE1 GLU A  41      16.063  20.562  11.949  1.00 26.73           O  
ATOM    395  OE2 GLU A  41      14.070  20.409  12.539  1.00 24.77           O  
ATOM    396  N   HIS A  42      17.752  16.477   8.181  1.00 24.71           N  
ATOM    397  CA  HIS A  42      18.969  16.221   7.383  1.00 30.04           C  
ATOM    398  C   HIS A  42      18.701  15.479   6.119  1.00 31.97           C  
ATOM    399  O   HIS A  42      19.393  15.718   5.112  1.00 32.69           O  
ATOM    400  CB  HIS A  42      20.046  15.494   8.172  1.00 30.93           C  
ATOM    401  CG  HIS A  42      20.780  16.377   9.112  1.00 34.64           C  
ATOM    402  ND1 HIS A  42      20.158  17.031  10.152  1.00 35.39           N  
ATOM    403  CD2 HIS A  42      22.088  16.722   9.178  1.00 38.02           C  
ATOM    404  CE1 HIS A  42      21.047  17.734  10.834  1.00 37.05           C  
ATOM    405  NE2 HIS A  42      22.226  17.571  10.258  1.00 39.67           N  
ATOM    406  N   LEU A  43      17.671  14.644   6.122  1.00 33.51           N  
ATOM    407  CA  LEU A  43      17.408  13.734   4.991  1.00 36.36           C  
ATOM    408  C   LEU A  43      16.504  14.291   3.891  1.00 38.45           C  
ATOM    409  O   LEU A  43      15.568  15.049   4.140  1.00 39.54           O  
ATOM    410  CB  LEU A  43      16.878  12.411   5.502  1.00 36.96           C  
ATOM    411  CG  LEU A  43      18.031  11.633   6.156  1.00 38.82           C  
ATOM    412  CD1 LEU A  43      17.817  10.203   5.965  1.00 38.03           C  
ATOM    413  CD2 LEU A  43      19.442  12.005   5.606  1.00 39.21           C  
ATOM    414  N   GLU A  44      16.773  13.871   2.657  1.00 41.37           N  
ATOM    415  CA  GLU A  44      15.926  14.252   1.533  1.00 44.46           C  
ATOM    416  C   GLU A  44      14.837  13.196   1.171  1.00 45.67           C  
ATOM    417  O   GLU A  44      14.304  13.184   0.024  1.00 47.26           O  
ATOM    418  CB  GLU A  44      16.789  14.636   0.321  1.00 46.04           C  
ATOM    419  CG  GLU A  44      17.372  16.064   0.386  1.00 49.16           C  
ATOM    420  CD  GLU A  44      18.645  16.208   1.262  1.00 53.03           C  
ATOM    421  OE1 GLU A  44      18.622  15.799   2.451  1.00 54.16           O  
ATOM    422  OE2 GLU A  44      19.662  16.770   0.762  1.00 55.91           O  
ATOM    423  N   GLU A  45      14.545  12.320   2.136  0.50 45.09           N  
ATOM    425  CA  GLU A  45      13.509  11.280   2.066  0.50 44.38           C  
ATOM    427  C   GLU A  45      13.475  10.574   3.415  0.50 43.46           C  
ATOM    429  O   GLU A  45      14.527  10.411   4.007  0.50 43.77           O  
ATOM    431  CB  GLU A  45      13.803  10.280   0.942  0.50 44.58           C  
ATOM    433  CG  GLU A  45      15.254  10.198   0.466  0.50 44.58           C  
ATOM    435  CD  GLU A  45      16.127   9.306   1.320  0.50 43.96           C  
ATOM    437  OE1 GLU A  45      16.466   9.686   2.467  0.50 41.17           O  
ATOM    439  OE2 GLU A  45      16.505   8.227   0.817  0.50 44.49           O  
ATOM    441  N   ILE A  46      12.292  10.177   3.922  1.00 43.20           N  
ATOM    442  CA  ILE A  46      12.215   9.430   5.220  1.00 40.06           C  
ATOM    443  C   ILE A  46      13.030   8.193   4.902  1.00 37.56           C  
ATOM    444  O   ILE A  46      12.912   7.631   3.788  1.00 36.36           O  
ATOM    445  CB  ILE A  46      10.749   9.221   5.695  1.00 40.33           C  
ATOM    446  CG1 ILE A  46      10.614   8.224   6.845  1.00 38.43           C  
ATOM    447  CG2 ILE A  46       9.834   8.838   4.525  1.00 42.05           C  
ATOM    448  CD1 ILE A  46      11.714   8.269   7.848  1.00 34.85           C  
ATOM    449  N   PRO A  47      14.053   7.915   5.737  1.00 34.30           N  
ATOM    450  CA  PRO A  47      14.993   6.893   5.279  1.00 32.06           C  
ATOM    451  C   PRO A  47      14.399   5.534   5.524  1.00 29.22           C  
ATOM    452  O   PRO A  47      13.540   5.406   6.325  1.00 29.91           O  
ATOM    453  CB  PRO A  47      16.232   7.077   6.154  1.00 30.90           C  
ATOM    454  CG  PRO A  47      15.664   7.680   7.423  1.00 33.21           C  
ATOM    455  CD  PRO A  47      14.502   8.576   6.973  1.00 34.40           C  
ATOM    456  N   ASP A  48      14.872   4.543   4.795  1.00 28.05           N  
ATOM    457  CA  ASP A  48      14.387   3.269   4.984  1.00 23.36           C  
ATOM    458  C   ASP A  48      15.073   2.745   6.227  1.00 18.74           C  
ATOM    459  O   ASP A  48      16.207   3.140   6.605  1.00 16.60           O  
ATOM    460  CB  ASP A  48      14.854   2.369   3.819  1.00 24.18           C  
ATOM    461  CG  ASP A  48      14.298   2.770   2.511  1.00 31.89           C  
ATOM    462  OD1 ASP A  48      13.236   3.450   2.473  1.00 35.26           O  
ATOM    463  OD2 ASP A  48      14.943   2.373   1.517  1.00 38.88           O  
ATOM    464  N   GLU A  49      14.415   1.785   6.852  1.00 14.67           N  
ATOM    465  CA  GLU A  49      15.122   0.963   7.803  1.00 11.81           C  
ATOM    466  C   GLU A  49      16.379   0.342   7.164  1.00 10.73           C  
ATOM    467  O   GLU A  49      16.376  -0.023   5.982  1.00 15.58           O  
ATOM    468  CB  GLU A  49      14.182  -0.152   8.276  1.00 11.52           C  
ATOM    469  CG  GLU A  49      13.016   0.462   9.022  1.00 11.86           C  
ATOM    470  CD  GLU A  49      11.937  -0.572   9.425  1.00 13.12           C  
ATOM    471  OE1 GLU A  49      12.090  -1.785   9.093  1.00 12.48           O  
ATOM    472  OE2 GLU A  49      10.973  -0.188  10.082  1.00 12.32           O  
ATOM    473  N   GLY A  50      17.413   0.241   7.979  1.00 11.51           N  
ATOM    474  CA  GLY A  50      18.716  -0.232   7.601  1.00 13.02           C  
ATOM    475  C   GLY A  50      19.659   0.832   7.075  1.00 13.69           C  
ATOM    476  O   GLY A  50      20.829   0.506   6.787  1.00 16.74           O  
ATOM    477  N   THR A  51      19.163   2.025   6.835  1.00 14.30           N  
ATOM    478  CA  THR A  51      20.019   3.131   6.381  1.00 14.67           C  
ATOM    479  C   THR A  51      21.049   3.448   7.476  1.00 14.94           C  
ATOM    480  O   THR A  51      20.714   3.506   8.660  1.00 14.76           O  
ATOM    481  CB  THR A  51      19.187   4.398   6.214  1.00 16.52           C  
ATOM    482  OG1 THR A  51      18.321   4.208   5.126  1.00 21.29           O  
ATOM    483  CG2 THR A  51      20.157   5.636   5.914  1.00 21.68           C  
ATOM    484  N   ILE A  52      22.307   3.688   7.070  1.00 16.37           N  
ATOM    485  CA  ILE A  52      23.369   4.048   8.011  1.00 17.32           C  
ATOM    486  C   ILE A  52      23.851   5.422   7.553  1.00 18.03           C  
ATOM    487  O   ILE A  52      24.095   5.670   6.341  1.00 20.51           O  
ATOM    488  CB  ILE A  52      24.535   3.021   7.969  1.00 16.75           C  
ATOM    489  CG1 ILE A  52      24.137   1.639   8.523  1.00 19.03           C  
ATOM    490  CG2 ILE A  52      25.795   3.489   8.715  1.00 20.65           C  
ATOM    491  CD1 ILE A  52      25.138   0.516   8.116  1.00 22.22           C  
ATOM    492  N   CYS A  53      23.963   6.343   8.505  1.00 16.78           N  
ATOM    493  CA  CYS A  53      24.230   7.757   8.226  0.50 18.99           C  
ATOM    495  C   CYS A  53      25.150   8.279   9.334  1.00 16.20           C  
ATOM    496  O   CYS A  53      25.187   7.709  10.456  1.00 16.08           O  
ATOM    497  CB  CYS A  53      22.914   8.529   8.336  0.50 21.08           C  
ATOM    499  SG  CYS A  53      22.021   8.891   6.796  0.50 33.53           S  
ATOM    501  N   GLU A  54      25.821   9.376   9.062  1.00 15.33           N  
ATOM    502  CA  GLU A  54      26.625  10.026  10.055  0.50 15.19           C  
ATOM    504  C   GLU A  54      25.990  11.427  10.305  1.00 15.96           C  
ATOM    505  O   GLU A  54      25.784  12.181   9.326  1.00 18.85           O  
ATOM    506  CB  GLU A  54      28.095  10.129   9.512  0.50 16.28           C  
ATOM    508  CG  GLU A  54      28.904   8.740   9.535  0.50 18.92           C  
ATOM    510  CD  GLU A  54      28.977   7.925   8.212  0.50 21.38           C  
ATOM    512  OE1 GLU A  54      29.059   8.510   7.104  0.50 21.73           O  
ATOM    514  OE2 GLU A  54      28.977   6.668   8.251  0.50 22.02           O  
ATOM    516  N   ILE A  55      25.767  11.783  11.577  1.00 14.81           N  
ATOM    517  CA  ILE A  55      25.248  13.115  11.915  1.00 15.94           C  
ATOM    518  C   ILE A  55      25.866  13.536  13.206  1.00 14.78           C  
ATOM    519  O   ILE A  55      25.782  12.833  14.212  1.00 15.23           O  
ATOM    520  CB  ILE A  55      23.682  13.138  12.062  1.00 16.05           C  
ATOM    521  CG1 ILE A  55      22.974  12.732  10.750  1.00 21.24           C  
ATOM    522  CG2 ILE A  55      23.289  14.567  12.372  1.00 20.08           C  
ATOM    523  CD1 ILE A  55      21.434  12.618  10.893  1.00 20.63           C  
ATOM    524  N   ASP A  56      26.499  14.702  13.185  1.00 15.37           N  
ATOM    525  CA  ASP A  56      26.898  15.353  14.431  1.00 15.43           C  
ATOM    526  C   ASP A  56      27.693  14.433  15.345  1.00 14.42           C  
ATOM    527  O   ASP A  56      27.430  14.368  16.574  1.00 15.46           O  
ATOM    528  CB  ASP A  56      25.699  15.900  15.210  1.00 17.36           C  
ATOM    529  CG  ASP A  56      24.967  16.973  14.467  1.00 16.80           C  
ATOM    530  OD1 ASP A  56      23.865  17.276  14.892  1.00 21.75           O  
ATOM    531  OD2 ASP A  56      25.499  17.540  13.441  1.00 20.85           O  
ATOM    532  N   GLY A  57      28.660  13.735  14.767  1.00 13.12           N  
ATOM    533  CA  GLY A  57      29.573  12.904  15.597  1.00 13.95           C  
ATOM    534  C   GLY A  57      28.997  11.538  15.982  1.00 12.16           C  
ATOM    535  O   GLY A  57      29.674  10.791  16.729  1.00 15.18           O  
ATOM    536  N   LEU A  58      27.833  11.180  15.421  1.00 12.35           N  
ATOM    537  CA  LEU A  58      27.244   9.846  15.660  1.00 12.25           C  
ATOM    538  C   LEU A  58      27.119   9.034  14.357  1.00 11.80           C  
ATOM    539  O   LEU A  58      26.823   9.582  13.266  1.00 12.79           O  
ATOM    540  CB  LEU A  58      25.847   9.967  16.248  1.00 13.91           C  
ATOM    541  CG  LEU A  58      25.718  10.796  17.568  1.00 15.30           C  
ATOM    542  CD1 LEU A  58      24.262  10.787  17.901  1.00 16.20           C  
ATOM    543  CD2 LEU A  58      26.629  10.231  18.660  1.00 18.37           C  
ATOM    544  N   LEU A  59      27.346   7.729  14.497  1.00  9.95           N  
ATOM    545  CA  LEU A  59      27.089   6.810  13.359  1.00 11.00           C  
ATOM    546  C   LEU A  59      25.756   6.133  13.681  1.00 10.61           C  
ATOM    547  O   LEU A  59      25.670   5.372  14.690  1.00  9.35           O  
ATOM    548  CB  LEU A  59      28.228   5.789  13.314  1.00 12.47           C  
ATOM    549  CG  LEU A  59      28.054   4.720  12.237  1.00 13.37           C  
ATOM    550  CD1 LEU A  59      28.028   5.349  10.833  1.00 14.90           C  
ATOM    551  CD2 LEU A  59      29.205   3.727  12.311  1.00 14.25           C  
ATOM    552  N   ILE A  60      24.758   6.359  12.840  1.00  9.82           N  
ATOM    553  CA  ILE A  60      23.375   6.010  13.164  1.00 11.43           C  
ATOM    554  C   ILE A  60      22.864   4.947  12.225  1.00 10.86           C  
ATOM    555  O   ILE A  60      23.086   5.098  11.017  1.00 13.09           O  
ATOM    556  CB  ILE A  60      22.475   7.326  13.007  1.00 12.60           C  
ATOM    557  CG1 ILE A  60      22.953   8.342  14.042  1.00 13.24           C  
ATOM    558  CG2 ILE A  60      21.028   7.009  13.258  1.00 16.10           C  
ATOM    559  CD1 ILE A  60      22.428   9.799  13.737  1.00 17.44           C  
ATOM    560  N   THR A  61      22.183   3.913  12.731  1.00  9.26           N  
ATOM    561  CA  THR A  61      21.529   2.912  11.870  1.00  9.75           C  
ATOM    562  C   THR A  61      20.015   2.984  12.167  1.00  8.48           C  
ATOM    563  O   THR A  61      19.575   2.878  13.319  1.00  9.71           O  
ATOM    564  CB  THR A  61      22.009   1.511  12.179  1.00 10.58           C  
ATOM    565  OG1 THR A  61      23.438   1.496  11.959  1.00 10.45           O  
ATOM    566  CG2 THR A  61      21.389   0.488  11.188  1.00 11.16           C  
ATOM    567  N   ILE A  62      19.227   3.287  11.151  1.00 10.10           N  
ATOM    568  CA  ILE A  62      17.774   3.351  11.319  0.50  8.40           C  
ATOM    570  C   ILE A  62      17.265   1.923  11.539  1.00 10.41           C  
ATOM    571  O   ILE A  62      17.439   1.066  10.643  1.00 10.83           O  
ATOM    572  CB  ILE A  62      17.069   4.022  10.114  0.50  9.21           C  
ATOM    574  CG1 ILE A  62      17.790   5.355   9.775  0.50  7.42           C  
ATOM    576  CG2 ILE A  62      15.563   4.287  10.485  0.50  9.13           C  
ATOM    578  CD1 ILE A  62      17.608   6.362  10.978  0.50  7.22           C  
ATOM    580  N   LEU A  63      16.590   1.657  12.680  1.00  9.81           N  
ATOM    581  CA  LEU A  63      16.063   0.305  12.944  1.00  9.44           C  
ATOM    582  C   LEU A  63      14.565   0.164  12.662  1.00 10.69           C  
ATOM    583  O   LEU A  63      14.097  -0.918  12.261  1.00 11.97           O  
ATOM    584  CB  LEU A  63      16.287  -0.109  14.382  1.00 11.46           C  
ATOM    585  CG  LEU A  63      17.711  -0.098  14.893  1.00 11.22           C  
ATOM    586  CD1 LEU A  63      17.839  -0.551  16.354  1.00 13.54           C  
ATOM    587  CD2 LEU A  63      18.602  -1.009  13.977  1.00 11.56           C  
ATOM    588  N   GLU A  64      13.818   1.247  12.897  1.00  9.06           N  
ATOM    589  CA  GLU A  64      12.356   1.143  12.840  1.00 10.24           C  
ATOM    590  C   GLU A  64      11.810   2.490  12.361  1.00 11.30           C  
ATOM    591  O   GLU A  64      12.154   3.499  13.000  1.00 10.64           O  
ATOM    592  CB  GLU A  64      11.711   0.837  14.225  1.00 10.14           C  
ATOM    593  CG  GLU A  64      10.223   0.559  14.024  1.00 11.03           C  
ATOM    594  CD  GLU A  64       9.434   0.384  15.341  1.00 14.28           C  
ATOM    595  OE1 GLU A  64      10.112   0.265  16.382  1.00 16.93           O  
ATOM    596  OE2 GLU A  64       8.128   0.368  15.301  1.00 15.28           O  
ATOM    597  N   VAL A  65      11.001   2.465  11.306  1.00 11.87           N  
ATOM    598  CA  VAL A  65      10.344   3.634  10.777  0.50 11.99           C  
ATOM    600  C   VAL A  65       8.833   3.341  10.800  1.00 12.71           C  
ATOM    601  O   VAL A  65       8.424   2.206  10.468  1.00 17.03           O  
ATOM    602  CB  VAL A  65      10.848   3.924   9.396  0.50 13.17           C  
ATOM    604  CG1 VAL A  65      10.081   5.120   8.829  0.50 12.11           C  
ATOM    606  CG2 VAL A  65      12.330   4.172   9.409  0.50 14.35           C  
ATOM    608  N   GLY A  66       8.060   4.345  11.145  1.00 13.88           N  
ATOM    609  CA  GLY A  66       6.616   4.190  11.094  1.00 17.12           C  
ATOM    610  C   GLY A  66       5.979   5.538  11.096  1.00 22.86           C  
ATOM    611  O   GLY A  66       6.506   6.479  11.748  1.00 23.61           O  
ATOM    612  N   ASP A  67       4.903   5.680  10.306  1.00 25.71           N  
ATOM    613  CA  ASP A  67       4.250   6.993  10.228  1.00 29.09           C  
ATOM    614  C   ASP A  67       5.205   8.027   9.599  1.00 28.36           C  
ATOM    615  O   ASP A  67       5.171   9.179   9.946  1.00 31.19           O  
ATOM    616  CB  ASP A  67       3.842   7.386  11.642  1.00 31.08           C  
ATOM    617  CG  ASP A  67       2.658   6.552  12.155  1.00 38.50           C  
ATOM    618  OD1 ASP A  67       1.581   7.142  12.480  1.00 40.62           O  
ATOM    619  OD2 ASP A  67       2.786   5.293  12.226  1.00 46.33           O  
ATOM    620  N   ASN A  68       6.018   7.614   8.621  1.00 28.09           N  
ATOM    621  CA  ASN A  68       7.177   8.423   8.167  1.00 28.04           C  
ATOM    622  C   ASN A  68       7.998   9.125   9.246  1.00 26.29           C  
ATOM    623  O   ASN A  68       8.580  10.213   8.925  1.00 28.84           O  
ATOM    624  CB  ASN A  68       6.771   9.517   7.162  1.00 31.30           C  
ATOM    625  CG  ASN A  68       5.870   8.986   6.068  1.00 35.50           C  
ATOM    626  OD1 ASN A  68       4.674   9.317   6.022  1.00 42.79           O  
ATOM    627  ND2 ASN A  68       6.423   8.136   5.199  1.00 40.89           N  
HETATM  628  N   MSE A  69       7.974   8.651  10.505  0.50 22.65           N  
HETATM  630  CA  MSE A  69       8.932   9.136  11.511  0.50 19.49           C  
HETATM  632  C   MSE A  69       9.931   7.999  11.802  0.50 16.02           C  
HETATM  634  O   MSE A  69       9.629   6.814  11.596  0.50 14.90           O  
HETATM  636  CB  MSE A  69       8.322   9.525  12.865  0.50 21.14           C  
HETATM  638  CG  MSE A  69       7.373  10.703  12.969  0.50 26.62           C  
HETATM  640 SE   MSE A  69       7.435  12.214  11.772  0.20 28.09          SE  
HETATM  642  CE  MSE A  69       8.116  13.791  12.609  0.50 25.67           C  
ATOM    644  N   ILE A  70      11.108   8.383  12.310  1.00 13.07           N  
ATOM    645  CA  ILE A  70      12.044   7.431  12.863  1.00 12.41           C  
ATOM    646  C   ILE A  70      11.544   7.031  14.268  1.00 10.85           C  
ATOM    647  O   ILE A  70      11.372   7.908  15.147  1.00 13.50           O  
ATOM    648  CB  ILE A  70      13.430   8.071  12.964  1.00 11.54           C  
ATOM    649  CG1 ILE A  70      14.036   8.409  11.574  1.00 16.96           C  
ATOM    650  CG2 ILE A  70      14.406   7.091  13.647  1.00 13.35           C  
ATOM    651  CD1 ILE A  70      13.549   9.591  10.984  1.00 26.00           C  
ATOM    652  N   LYS A  71      11.263   5.738  14.446  1.00 10.15           N  
ATOM    653  CA  LYS A  71      10.852   5.257  15.743  1.00 10.41           C  
ATOM    654  C   LYS A  71      11.992   4.778  16.614  1.00  9.33           C  
ATOM    655  O   LYS A  71      12.004   5.027  17.811  1.00 12.01           O  
ATOM    656  CB  LYS A  71       9.824   4.116  15.639  1.00 12.16           C  
ATOM    657  CG  LYS A  71       8.496   4.591  14.968  1.00 15.88           C  
ATOM    658  CD  LYS A  71       7.697   5.538  15.887  1.00 19.46           C  
ATOM    659  CE  LYS A  71       6.316   5.838  15.224  1.00 21.89           C  
ATOM    660  NZ  LYS A  71       5.485   6.688  16.088  1.00 26.39           N  
ATOM    661  N   GLN A  72      12.983   4.077  16.006  1.00  8.89           N  
ATOM    662  CA  GLN A  72      14.164   3.597  16.805  1.00  9.80           C  
ATOM    663  C   GLN A  72      15.371   3.624  15.898  1.00  9.18           C  
ATOM    664  O   GLN A  72      15.281   3.328  14.680  1.00  9.49           O  
ATOM    665  CB  GLN A  72      14.018   2.129  17.287  1.00 12.44           C  
ATOM    666  CG  GLN A  72      12.875   2.031  18.361  1.00 15.63           C  
ATOM    667  CD  GLN A  72      12.788   0.680  19.041  1.00 19.46           C  
ATOM    668  OE1 GLN A  72      13.776  -0.068  19.187  1.00 25.83           O  
ATOM    669  NE2 GLN A  72      11.580   0.360  19.498  1.00 26.73           N  
ATOM    670  N   ALA A  73      16.490   4.012  16.489  1.00 10.45           N  
ATOM    671  CA  ALA A  73      17.773   3.991  15.791  1.00 10.49           C  
ATOM    672  C   ALA A  73      18.882   3.506  16.694  1.00 10.85           C  
ATOM    673  O   ALA A  73      18.860   3.778  17.886  1.00 11.85           O  
ATOM    674  CB  ALA A  73      18.137   5.397  15.276  1.00 11.79           C  
ATOM    675  N   LYS A  74      19.828   2.811  16.102  1.00  9.79           N  
ATOM    676  CA  LYS A  74      21.048   2.390  16.797  1.00  8.72           C  
ATOM    677  C   LYS A  74      22.074   3.479  16.651  1.00  9.23           C  
ATOM    678  O   LYS A  74      22.224   4.074  15.555  1.00  9.65           O  
ATOM    679  CB  LYS A  74      21.579   1.094  16.186  1.00  8.97           C  
ATOM    680  CG  LYS A  74      22.971   0.759  16.552  1.00 11.26           C  
ATOM    681  CD  LYS A  74      23.396  -0.498  15.679  1.00 11.35           C  
ATOM    682  CE  LYS A  74      24.886  -0.746  15.783  1.00 11.54           C  
ATOM    683  NZ  LYS A  74      25.263  -1.942  14.998  1.00 14.97           N  
ATOM    684  N   VAL A  75      22.810   3.792  17.735  1.00  9.50           N  
ATOM    685  CA  VAL A  75      23.810   4.894  17.640  1.00  9.74           C  
ATOM    686  C   VAL A  75      25.140   4.453  18.226  1.00 11.12           C  
ATOM    687  O   VAL A  75      25.172   3.816  19.309  1.00 12.72           O  
ATOM    688  CB  VAL A  75      23.281   6.055  18.520  1.00 12.05           C  
ATOM    689  CG1 VAL A  75      24.382   7.187  18.699  1.00 16.24           C  
ATOM    690  CG2 VAL A  75      21.974   6.588  17.954  1.00 13.37           C  
ATOM    691  N   VAL A  76      26.206   4.752  17.501  1.00 11.55           N  
ATOM    692  CA  VAL A  76      27.549   4.563  17.985  0.50 12.51           C  
ATOM    694  C   VAL A  76      28.264   5.929  17.869  1.00 12.67           C  
ATOM    695  O   VAL A  76      28.021   6.653  16.946  1.00 13.78           O  
ATOM    696  CB  VAL A  76      28.299   3.475  17.102  0.50 14.16           C  
ATOM    698  CG1 VAL A  76      29.659   3.216  17.673  0.50 16.38           C  
ATOM    700  CG2 VAL A  76      27.484   2.171  16.923  0.50 13.32           C  
ATOM    702  N   LYS A  77      29.159   6.254  18.788  1.00 15.17           N  
ATOM    703  CA  LYS A  77      29.905   7.539  18.687  1.00 18.36           C  
ATOM    704  C   LYS A  77      31.066   7.422  17.682  1.00 19.93           C  
ATOM    705  O   LYS A  77      31.799   6.371  17.625  1.00 21.93           O  
ATOM    706  CB  LYS A  77      30.497   7.882  20.048  1.00 22.89           C  
ATOM    707  CG  LYS A  77      31.052   9.275  20.113  1.00 26.75           C  
ATOM    708  CD  LYS A  77      30.091  10.207  20.763  1.00 35.11           C  
ATOM    709  CE  LYS A  77      30.305  10.096  22.300  1.00 39.22           C  
ATOM    710  NZ  LYS A  77      31.351  11.020  22.889  1.00 45.54           N  
ATOM    711  N   LEU A  78      31.241   8.474  16.917  1.00 19.75           N  
ATOM    712  CA  LEU A  78      32.436   8.696  16.074  1.00 20.61           C  
ATOM    713  C   LEU A  78      33.454   9.552  16.818  1.00 24.39           C  
ATOM    714  O   LEU A  78      33.793   9.187  17.903  1.00 27.13           O  
ATOM    715  CB  LEU A  78      32.055   9.490  14.876  1.00 21.29           C  
ATOM    716  CG  LEU A  78      31.156   8.853  13.829  1.00 16.51           C  
ATOM    717  CD1 LEU A  78      30.720   9.882  12.762  1.00 19.89           C  
ATOM    718  CD2 LEU A  78      31.763   7.622  13.069  1.00 19.78           C  
TER     719      LEU A  78                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
