
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   86 (  688),  selected   86 , name 2pls_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2pls_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S   343_A      D       5          4.952
LGA    N   344_A      E       6          0.398
LGA    A   345_A      I       7          1.007
LGA    V   346_A      V       8          1.235
LGA    Q   347_A      Q       9          1.380
LGA    R   348_A      R      10          1.480
LGA    E   349_A      E      11          1.531
LGA    D   350_A      D      12          1.823
LGA    G   351_A      G      13          1.323
LGA    S   352_A      S      14          1.118
LGA    W   353_A      W      15          0.939
LGA    L   354_A      L      16          1.047
LGA    L   355_A      V      17          0.411
LGA    D   356_A      D      18          0.377
LGA    G   357_A      G      19          0.583
LGA    L   358_A      M      20          0.652
LGA    I   359_A      V      21          0.494
LGA    A   360_A      S      22          0.489
LGA    V   361_A      L      23          0.318
LGA    P   362_A      D      24          0.491
LGA    E   363_A      R      25          1.035
LGA    L   364_A      F      26          1.099
LGA    K   365_A      R      27          0.636
LGA    D   366_A      E      28          2.043
LGA    T   367_A      F      29          2.586
LGA    L   368_A      F      30          2.106
LGA    G   369_A      E      31          2.071
LGA    L   370_A      L      32          1.523
LGA    R   371_A      E      33          1.399
LGA    A   372_A      A      34          1.949
LGA    V   373_A      P      35          1.922
LGA    -       -      L      36           -
LGA    P   374_A      P      37          2.820
LGA    E   375_A      G      38          3.250
LGA    E   376_A      E      39          3.172
LGA    E   377_A      A      40          4.356
LGA    K   378_A      G      41          1.917
LGA    G   379_A      G      42          3.041
LGA    V   380_A      N      43          2.980
LGA    Y   381_A      I      44          1.814
LGA    H   382_A      H      45          1.400
LGA    T   383_A      T      46          0.598
LGA    L   384_A      L      47          0.375
LGA    S   385_A      A      48          0.554
LGA    G   386_A      G      49          0.777
LGA    X   387_A      V      50          0.425
LGA    I   388_A      M      51          1.200
LGA    X   389_A      L      52          1.259
LGA    W   390_A      Y      53          0.939
LGA    L   391_A      Q      54          1.482
LGA    L   392_A      L      55          1.885
LGA    G   393_A      -       -           -
LGA    R   394_A      G      56          1.113
LGA    L   395_A      R      57          2.264
LGA    -       -      V      58           -
LGA    P   396_A      P      59          1.331
LGA    Q   397_A      S      60          1.308
LGA    T   398_A      V      61          1.039
LGA    G   399_A      T      62          1.175
LGA    D   400_A      D      63          0.461
LGA    I   401_A      R      64          0.338
LGA    T   402_A      F      65          1.494
LGA    F   403_A      E      66          1.742
LGA    W   404_A      W      67          1.311
LGA    E   405_A      N      68          0.804
LGA    N   406_A      G      69          1.128
LGA    W   407_A      F      70          0.454
LGA    R   408_A      S      71          0.596
LGA    L   409_A      F      72          0.596
LGA    E   410_A      E      73          0.730
LGA    V   411_A      V      74          0.433
LGA    I   412_A      V      75          0.571
LGA    D   413_A      D      76          0.331
LGA    X   414_A      M      77          1.025
LGA    D   415_A      D      78          1.844
LGA    S   416_A      R      79          1.599
LGA    K   417_A      T      80          1.335
LGA    R   418_A      R      81          1.885
LGA    I   419_A      V      82          0.774
LGA    D   420_A      D      83          0.570
LGA    K   421_A      K      84          0.598
LGA    V   422_A      I      85          0.677
LGA    L   423_A      L      86          0.648
LGA    A   424_A      V      87          0.874
LGA    T   425_A      Q      88          1.459
LGA    K   426_A      R      89          1.735
LGA    I   427_A      H      90          2.313
LGA    D   428_A      H      91          3.870

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   86   87    5.0     85    1.64    37.65     90.048     4.890

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.504133 * X  +  -0.361917 * Y  +   0.784134 * Z  +  31.386644
  Y_new =   0.821700 * X  +  -0.480472 * Y  +   0.306523 * Z  + -58.034840
  Z_new =   0.265818 * X  +   0.798851 * Y  +   0.539609 * Z  + -69.991600 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.976716   -2.164876  [ DEG:    55.9617   -124.0383 ]
  Theta =  -0.269052   -2.872540  [ DEG:   -15.4156   -164.5844 ]
  Phi   =   2.121101   -1.020492  [ DEG:   121.5301    -58.4699 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pls_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pls_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   86   87   5.0   85   1.64   37.65  90.048
REMARK  ---------------------------------------------------------- 
MOLECULE 2pls_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   20-APR-07   2PLS              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF THE CORC/HLYC           
TITLE    2 TRANSPORTER ASSOCIATED DOMAIN OF A CBS DOMAIN PROTEIN FROM           
TITLE    3 CHLOROBIUM TEPIDUM TLS                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CBS DOMAIN PROTEIN;                                        
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 FRAGMENT: CORC/HLYC TRANSPORTER ASSOCIATED DOMAIN;                   
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CHLOROBIUM TEPIDUM TLS;                         
SOURCE   3 STRAIN: TLS, DSM 12025;                                              
SOURCE   4 ATCC: 49652;                                                         
SOURCE   5 GENE: CT0541;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG19                                   
KEYWDS    APC86064.2, CORC/HLYC TRANSPORTER ASSOCIATED DOMAIN, CBS              
KEYWDS   2 DOMAIN PROTEIN, CHLOROBIUM TEPIDUM TLS, STRUCTURAL GENOMICS,         
KEYWDS   3 PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR              
KEYWDS   4 STRUCTURAL GENOMICS, MCSG, STRUCTURAL GENOMICS, UNKNOWN              
KEYWDS   5 FUNCTION                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,L.VOLKART,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR              
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   2   13-MAY-08 2PLS    1       REMARK VERSN                             
REVDAT   1   22-MAY-07 2PLS    0                                                
JRNL        AUTH   K.TAN,L.VOLKART,S.CLANCY,A.JOACHIMIAK                        
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE CORC/HLYC TRANSPORTER           
JRNL        TITL 2 ASSOCIATED DOMAIN OF A CBS DOMAIN PROTEIN FROM               
JRNL        TITL 3 CHLOROBIUM TEPIDUM TLS.                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.15 ANGSTROMS.                                          
DBREF  2PLS A  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS B  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS C  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS D  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS E  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS F  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS G  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS H  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS I  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS J  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS K  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
DBREF  2PLS L  346   428  UNP    Q8KEZ1   Q8KEZ1_CHLTE   346    428             
SEQRES   1 A   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 A   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 A   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 A   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 A   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 A   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 A   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 B   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 B   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 B   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 B   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 B   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 B   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 B   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 C   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 C   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 C   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 C   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 C   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 C   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 C   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 D   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 D   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 D   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 D   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 D   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 D   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 D   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 E   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 E   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 E   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 E   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 E   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 E   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 E   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 F   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 F   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 F   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 F   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 F   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 F   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 F   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 G   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 G   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 G   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 G   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 G   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 G   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 G   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 H   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 H   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 H   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 H   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 H   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 H   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 H   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 I   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 I   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 I   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 I   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 I   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 I   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 I   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 J   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 J   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 J   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 J   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 J   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 J   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 J   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 K   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 K   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 K   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 K   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 K   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 K   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 K   86  LYS VAL LEU ALA THR LYS ILE ASP                              
SEQRES   1 L   86  SER ASN ALA VAL GLN ARG GLU ASP GLY SER TRP LEU LEU          
SEQRES   2 L   86  ASP GLY LEU ILE ALA VAL PRO GLU LEU LYS ASP THR LEU          
SEQRES   3 L   86  GLY LEU ARG ALA VAL PRO GLU GLU GLU LYS GLY VAL TYR          
SEQRES   4 L   86  HIS THR LEU SER GLY MSE ILE MSE TRP LEU LEU GLY ARG          
SEQRES   5 L   86  LEU PRO GLN THR GLY ASP ILE THR PHE TRP GLU ASN TRP          
SEQRES   6 L   86  ARG LEU GLU VAL ILE ASP MSE ASP SER LYS ARG ILE ASP          
SEQRES   7 L   86  LYS VAL LEU ALA THR LYS ILE ASP                              
HET    MSE  A 387       8                                                       
HET    MSE  A 389       8                                                       
HET    MSE  A 414       8                                                       
HET    MSE  B 387       8                                                       
HET    MSE  B 389       8                                                       
HET    MSE  B 414       8                                                       
HET    MSE  C 387       8                                                       
HET    MSE  C 389       8                                                       
HET    MSE  C 414       8                                                       
HET    MSE  D 387       8                                                       
HET    MSE  D 389       8                                                       
HET    MSE  D 414       8                                                       
HET    MSE  E 387       8                                                       
HET    MSE  E 389       8                                                       
HET    MSE  E 414       8                                                       
HET    MSE  F 387       8                                                       
HET    MSE  F 389       8                                                       
HET    MSE  F 414       8                                                       
HET    MSE  G 387       8                                                       
HET    MSE  G 389       8                                                       
HET    MSE  G 414       8                                                       
HET    MSE  H 387       8                                                       
HET    MSE  H 389       8                                                       
HET    MSE  H 414       8                                                       
HET    MSE  I 387       8                                                       
HET    MSE  I 389       8                                                       
HET    MSE  I 414       8                                                       
HET    MSE  J 387       8                                                       
HET    MSE  J 389       8                                                       
HET    MSE  J 414       8                                                       
HET    MSE  K 387       8                                                       
HET    MSE  K 389       8                                                       
HET    MSE  K 414       8                                                       
HET    MSE  L 387       8                                                       
HET    MSE  L 389       8                                                       
HET    MSE  L 414       8                                                       
HET    ACT  A 904       4                                                       
HET    ACT  D 902       4                                                       
HET    ACT  E 903       4                                                       
HET     MG  G 603       1                                                       
HET     MG  H 601       1                                                       
HET     MG  H 602       1                                                       
HET     MG  I 605       1                                                       
HET     MG  I 606       1                                                       
HET     MG  J 604       1                                                       
HET    ACT  K 901       4                                                       
HET    EDO  A 706       4                                                       
HET    EDO  A 712       4                                                       
HET    EDO  B 702       4                                                       
HET    EDO  C 703       4                                                       
HET    EDO  C 709       4                                                       
HET    EDO  C 714       4                                                       
HET    EDO  E 704       4                                                       
HET    EDO  E 705       4                                                       
HET    EDO  F 701       4                                                       
HET    EDO  F 710       4                                                       
HET    EDO  F 713       4                                                       
HET    EDO  I 708       4                                                       
HET    EDO  J 711       4                                                       
HET    FMT  B 804       3                                                       
HET    FMT  C 802       3                                                       
HET    FMT  D 803       3                                                       
HET    FMT  I 801       3                                                       
HET    FMT  I 805       3                                                       
HET    FMT  L 806       3                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACT ACETATE ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     FMT FORMIC ACID                                                      
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    36(C5 H11 N O2 SE)                                           
FORMUL  13  ACT    4(C2 H3 O2 1-)                                               
FORMUL  16   MG    6(MG 2+)                                                     
FORMUL  23  EDO    13(C2 H6 O2)                                                 
FORMUL  36  FMT    6(C H2 O2)                                                   
FORMUL  42  HOH   *559(H2 O)                                                    
CRYST1  108.243  108.493  106.370  90.00  90.00  90.00 P 21 21 2    48          
ATOM      1  N   SER A 343      10.351   7.478  25.017  1.00 68.22           N  
ATOM      2  CA  SER A 343      11.543   8.375  24.896  1.00 68.09           C  
ATOM      3  C   SER A 343      12.813   7.730  25.475  1.00 67.72           C  
ATOM      4  O   SER A 343      13.778   8.413  25.854  1.00 67.68           O  
ATOM      5  CB  SER A 343      11.248   9.731  25.548  1.00 68.26           C  
ATOM      6  OG  SER A 343      10.187  10.374  24.862  1.00 68.76           O  
ATOM      7  N   ASN A 344      12.814   6.413  25.531  1.00 67.06           N  
ATOM      8  CA  ASN A 344      13.900   5.714  26.155  1.00 65.86           C  
ATOM      9  C   ASN A 344      15.219   5.734  25.437  1.00 64.69           C  
ATOM     10  O   ASN A 344      15.295   5.991  24.260  1.00 64.63           O  
ATOM     11  CB  ASN A 344      13.498   4.298  26.458  1.00 65.90           C  
ATOM     12  CG  ASN A 344      13.305   4.081  27.910  1.00 65.98           C  
ATOM     13  OD1 ASN A 344      14.099   4.529  28.718  1.00 65.78           O  
ATOM     14  ND2 ASN A 344      12.241   3.402  28.257  1.00 65.84           N  
ATOM     15  N   ALA A 345      16.258   5.453  26.191  1.00 63.28           N  
ATOM     16  CA  ALA A 345      17.501   4.982  25.694  1.00 62.12           C  
ATOM     17  C   ALA A 345      17.974   3.873  26.566  1.00 61.28           C  
ATOM     18  O   ALA A 345      17.651   3.814  27.726  1.00 61.40           O  
ATOM     19  CB  ALA A 345      18.490   6.075  25.709  1.00 62.19           C  
ATOM     20  N   VAL A 346      18.753   2.991  25.994  1.00 60.41           N  
ATOM     21  CA  VAL A 346      19.133   1.765  26.609  1.00 59.32           C  
ATOM     22  C   VAL A 346      20.446   1.491  25.985  1.00 58.85           C  
ATOM     23  O   VAL A 346      20.551   1.526  24.793  1.00 58.39           O  
ATOM     24  CB  VAL A 346      18.231   0.650  26.176  1.00 59.43           C  
ATOM     25  CG1 VAL A 346      18.627  -0.617  26.853  1.00 59.47           C  
ATOM     26  CG2 VAL A 346      16.814   0.980  26.458  1.00 59.34           C  
ATOM     27  N   GLN A 347      21.453   1.247  26.805  1.00 58.02           N  
ATOM     28  CA  GLN A 347      22.808   0.919  26.384  1.00 57.32           C  
ATOM     29  C   GLN A 347      22.995  -0.586  26.300  1.00 56.96           C  
ATOM     30  O   GLN A 347      22.843  -1.298  27.295  1.00 56.72           O  
ATOM     31  CB  GLN A 347      23.844   1.544  27.316  1.00 57.41           C  
ATOM     32  CG  GLN A 347      25.283   1.272  26.902  1.00 57.03           C  
ATOM     33  CD  GLN A 347      26.251   2.292  27.452  1.00 56.81           C  
ATOM     34  OE1 GLN A 347      26.057   2.831  28.542  1.00 56.73           O  
ATOM     35  NE2 GLN A 347      27.310   2.561  26.699  1.00 55.79           N  
ATOM     36  N   ARG A 348      23.321  -1.059  25.100  1.00 56.44           N  
ATOM     37  CA  ARG A 348      23.600  -2.474  24.868  1.00 55.95           C  
ATOM     38  C   ARG A 348      24.924  -2.930  25.510  1.00 55.30           C  
ATOM     39  O   ARG A 348      25.678  -2.113  26.052  1.00 55.22           O  
ATOM     40  CB  ARG A 348      23.594  -2.756  23.369  1.00 56.09           C  
ATOM     41  CG  ARG A 348      22.206  -2.896  22.774  1.00 56.85           C  
ATOM     42  CD  ARG A 348      22.131  -2.183  21.441  1.00 57.34           C  
ATOM     43  NE  ARG A 348      21.705  -3.067  20.357  1.00 57.53           N  
ATOM     44  CZ  ARG A 348      22.475  -3.430  19.329  1.00 57.75           C  
ATOM     45  NH1 ARG A 348      23.729  -2.986  19.220  1.00 57.11           N  
ATOM     46  NH2 ARG A 348      21.986  -4.242  18.394  1.00 57.36           N  
ATOM     47  N   GLU A 349      25.192  -4.235  25.441  1.00 54.45           N  
ATOM     48  CA  GLU A 349      26.384  -4.851  26.044  1.00 53.49           C  
ATOM     49  C   GLU A 349      27.728  -4.341  25.517  1.00 52.45           C  
ATOM     50  O   GLU A 349      28.752  -4.480  26.189  1.00 52.31           O  
ATOM     51  CB  GLU A 349      26.331  -6.374  25.882  1.00 53.79           C  
ATOM     52  CG  GLU A 349      25.081  -7.028  26.449  1.00 54.81           C  
ATOM     53  CD  GLU A 349      25.012  -6.940  27.965  1.00 56.34           C  
ATOM     54  OE1 GLU A 349      25.800  -7.633  28.649  1.00 56.25           O  
ATOM     55  OE2 GLU A 349      24.161  -6.176  28.472  1.00 57.29           O  
ATOM     56  N   ASP A 350      27.728  -3.764  24.317  1.00 51.23           N  
ATOM     57  CA  ASP A 350      28.977  -3.353  23.662  1.00 49.98           C  
ATOM     58  C   ASP A 350      29.212  -1.838  23.646  1.00 48.77           C  
ATOM     59  O   ASP A 350      30.079  -1.343  22.929  1.00 48.56           O  
ATOM     60  CB  ASP A 350      29.066  -3.935  22.236  1.00 50.24           C  
ATOM     61  CG  ASP A 350      27.966  -3.415  21.307  1.00 50.15           C  
ATOM     62  OD1 ASP A 350      27.440  -2.305  21.538  1.00 50.64           O  
ATOM     63  OD2 ASP A 350      27.633  -4.127  20.334  1.00 49.56           O  
ATOM     64  N   GLY A 351      28.434  -1.110  24.439  1.00 47.50           N  
ATOM     65  CA  GLY A 351      28.536   0.340  24.476  1.00 45.81           C  
ATOM     66  C   GLY A 351      27.522   1.044  23.599  1.00 44.75           C  
ATOM     67  O   GLY A 351      27.200   2.207  23.850  1.00 44.69           O  
ATOM     68  N   SER A 352      27.014   0.362  22.571  1.00 43.50           N  
ATOM     69  CA  SER A 352      26.109   1.022  21.624  1.00 42.86           C  
ATOM     70  C   SER A 352      24.745   1.308  22.242  1.00 42.27           C  
ATOM     71  O   SER A 352      24.402   0.755  23.309  1.00 42.52           O  
ATOM     72  CB  SER A 352      25.991   0.265  20.289  1.00 42.69           C  
ATOM     73  OG  SER A 352      25.074  -0.803  20.374  1.00 43.92           O  
ATOM     74  N   TRP A 353      23.994   2.196  21.595  1.00 40.97           N  
ATOM     75  CA  TRP A 353      22.734   2.685  22.149  1.00 40.38           C  
ATOM     76  C   TRP A 353      21.528   2.379  21.250  1.00 40.18           C  
ATOM     77  O   TRP A 353      21.579   2.552  20.026  1.00 40.11           O  
ATOM     78  CB  TRP A 353      22.812   4.198  22.436  1.00 39.87           C  
ATOM     79  CG  TRP A 353      23.664   4.595  23.630  1.00 39.85           C  
ATOM     80  CD1 TRP A 353      24.985   4.955  23.611  1.00 39.71           C  
ATOM     81  CD2 TRP A 353      23.246   4.684  25.009  1.00 39.49           C  
ATOM     82  NE1 TRP A 353      25.413   5.255  24.883  1.00 39.45           N  
ATOM     83  CE2 TRP A 353      24.371   5.095  25.761  1.00 39.57           C  
ATOM     84  CE3 TRP A 353      22.034   4.457  25.678  1.00 39.32           C  
ATOM     85  CZ2 TRP A 353      24.322   5.280  27.160  1.00 39.29           C  
ATOM     86  CZ3 TRP A 353      21.987   4.650  27.081  1.00 39.76           C  
ATOM     87  CH2 TRP A 353      23.128   5.056  27.794  1.00 39.05           C  
ATOM     88  N   LEU A 354      20.467   1.891  21.865  1.00 39.65           N  
ATOM     89  CA  LEU A 354      19.160   1.847  21.256  1.00 40.63           C  
ATOM     90  C   LEU A 354      18.346   3.031  21.740  1.00 40.92           C  
ATOM     91  O   LEU A 354      18.146   3.196  22.942  1.00 41.28           O  
ATOM     92  CB  LEU A 354      18.419   0.571  21.650  1.00 40.33           C  
ATOM     93  CG  LEU A 354      18.054  -0.446  20.566  1.00 42.36           C  
ATOM     94  CD1 LEU A 354      16.935  -1.337  21.097  1.00 44.32           C  
ATOM     95  CD2 LEU A 354      17.650   0.190  19.220  1.00 42.19           C  
ATOM     96  N   LEU A 355      17.858   3.842  20.805  1.00 41.28           N  
ATOM     97  CA  LEU A 355      17.125   5.062  21.140  1.00 41.68           C  
ATOM     98  C   LEU A 355      15.776   5.124  20.436  1.00 41.84           C  
ATOM     99  O   LEU A 355      15.656   4.748  19.267  1.00 41.99           O  
ATOM    100  CB  LEU A 355      17.937   6.287  20.722  1.00 41.60           C  
ATOM    101  CG  LEU A 355      19.204   6.825  21.419  1.00 42.80           C  
ATOM    102  CD1 LEU A 355      19.762   5.974  22.558  1.00 42.74           C  
ATOM    103  CD2 LEU A 355      20.254   7.062  20.361  1.00 40.43           C  
ATOM    104  N   ASP A 356      14.782   5.622  21.159  1.00 42.11           N  
ATOM    105  CA  ASP A 356      13.454   5.946  20.633  1.00 43.00           C  
ATOM    106  C   ASP A 356      13.633   7.112  19.664  1.00 43.23           C  
ATOM    107  O   ASP A 356      14.390   8.022  19.959  1.00 43.30           O  
ATOM    108  CB  ASP A 356      12.556   6.393  21.814  1.00 42.65           C  
ATOM    109  CG  ASP A 356      11.052   6.255  21.528  1.00 44.13           C  
ATOM    110  OD1 ASP A 356      10.578   6.560  20.408  1.00 45.78           O  
ATOM    111  OD2 ASP A 356      10.322   5.842  22.453  1.00 47.82           O  
ATOM    112  N   GLY A 357      12.949   7.101  18.526  1.00 43.64           N  
ATOM    113  CA  GLY A 357      13.036   8.226  17.593  1.00 44.46           C  
ATOM    114  C   GLY A 357      12.391   9.510  18.138  1.00 45.63           C  
ATOM    115  O   GLY A 357      12.720  10.607  17.698  1.00 45.97           O  
ATOM    116  N   LEU A 358      11.483   9.380  19.101  1.00 45.32           N  
ATOM    117  CA  LEU A 358      10.832  10.558  19.677  1.00 46.11           C  
ATOM    118  C   LEU A 358      11.559  11.049  20.919  1.00 46.25           C  
ATOM    119  O   LEU A 358      11.049  11.903  21.623  1.00 46.91           O  
ATOM    120  CB  LEU A 358       9.329  10.329  19.937  1.00 45.42           C  
ATOM    121  CG  LEU A 358       8.505   9.754  18.755  1.00 45.99           C  
ATOM    122  CD1 LEU A 358       7.055   9.468  19.163  1.00 45.15           C  
ATOM    123  CD2 LEU A 358       8.567  10.635  17.464  1.00 45.47           C  
ATOM    124  N   ILE A 359      12.760  10.531  21.169  1.00 46.62           N  
ATOM    125  CA  ILE A 359      13.621  11.086  22.213  1.00 46.92           C  
ATOM    126  C   ILE A 359      13.936  12.572  21.924  1.00 47.73           C  
ATOM    127  O   ILE A 359      14.388  12.934  20.831  1.00 47.53           O  
ATOM    128  CB  ILE A 359      14.922  10.240  22.415  1.00 46.86           C  
ATOM    129  CG1 ILE A 359      15.557  10.508  23.784  1.00 46.81           C  
ATOM    130  CG2 ILE A 359      15.936  10.459  21.277  1.00 46.38           C  
ATOM    131  CD1 ILE A 359      16.950   9.864  23.983  1.00 46.27           C  
ATOM    132  N   ALA A 360      13.688  13.430  22.905  1.00 48.82           N  
ATOM    133  CA  ALA A 360      13.907  14.871  22.726  1.00 50.34           C  
ATOM    134  C   ALA A 360      15.416  15.225  22.707  1.00 51.16           C  
ATOM    135  O   ALA A 360      16.266  14.464  23.219  1.00 51.85           O  
ATOM    136  CB  ALA A 360      13.162  15.663  23.807  1.00 49.70           C  
ATOM    137  N   VAL A 361      15.745  16.367  22.103  1.00 52.76           N  
ATOM    138  CA  VAL A 361      17.153  16.799  21.915  1.00 53.79           C  
ATOM    139  C   VAL A 361      17.977  16.924  23.227  1.00 54.89           C  
ATOM    140  O   VAL A 361      19.131  16.430  23.271  1.00 55.97           O  
ATOM    141  CB  VAL A 361      17.242  18.126  21.086  1.00 53.52           C  
ATOM    142  CG1 VAL A 361      18.653  18.749  21.138  1.00 52.88           C  
ATOM    143  CG2 VAL A 361      16.773  17.904  19.649  1.00 52.63           C  
ATOM    144  N   PRO A 362      17.425  17.598  24.273  1.00 54.86           N  
ATOM    145  CA  PRO A 362      18.131  17.623  25.565  1.00 55.24           C  
ATOM    146  C   PRO A 362      18.665  16.256  25.955  1.00 55.79           C  
ATOM    147  O   PRO A 362      19.903  16.045  26.049  1.00 56.27           O  
ATOM    148  CB  PRO A 362      17.017  18.122  26.570  1.00 55.29           C  
ATOM    149  CG  PRO A 362      16.150  18.989  25.740  1.00 55.10           C  
ATOM    150  CD  PRO A 362      16.170  18.389  24.314  1.00 55.24           C  
ATOM    151  N   GLU A 363      17.742  15.269  26.074  1.00 55.23           N  
ATOM    152  CA  GLU A 363      18.067  13.909  26.491  1.00 54.95           C  
ATOM    153  C   GLU A 363      19.021  13.205  25.515  1.00 54.07           C  
ATOM    154  O   GLU A 363      19.829  12.353  25.927  1.00 53.92           O  
ATOM    155  CB  GLU A 363      16.767  13.127  26.688  1.00 55.41           C  
ATOM    156  CG  GLU A 363      16.945  11.718  27.248  1.00 56.85           C  
ATOM    157  CD  GLU A 363      15.594  10.965  27.496  1.00 56.83           C  
ATOM    158  OE1 GLU A 363      15.653   9.787  27.933  1.00 60.28           O  
ATOM    159  OE2 GLU A 363      14.478  11.541  27.284  1.00 58.72           O  
ATOM    160  N   LEU A 364      18.939  13.571  24.227  1.00 52.43           N  
ATOM    161  CA  LEU A 364      19.813  12.998  23.221  1.00 51.54           C  
ATOM    162  C   LEU A 364      21.267  13.476  23.416  1.00 51.42           C  
ATOM    163  O   LEU A 364      22.190  12.614  23.314  1.00 50.72           O  
ATOM    164  CB  LEU A 364      19.299  13.307  21.801  1.00 51.06           C  
ATOM    165  CG  LEU A 364      20.130  12.898  20.596  1.00 51.05           C  
ATOM    166  CD1 LEU A 364      20.167  11.367  20.423  1.00 49.71           C  
ATOM    167  CD2 LEU A 364      19.589  13.583  19.339  1.00 50.25           C  
ATOM    168  N   LYS A 365      21.460  14.832  23.720  1.00 51.02           N  
ATOM    169  CA  LYS A 365      22.823  15.332  23.940  1.00 51.08           C  
ATOM    170  C   LYS A 365      23.422  14.636  25.164  1.00 50.94           C  
ATOM    171  O   LYS A 365      24.549  14.155  25.118  1.00 50.85           O  
ATOM    172  CB  LYS A 365      22.832  16.851  24.162  1.00 51.14           C  
ATOM    173  CG  LYS A 365      22.639  17.713  22.903  1.00 51.34           C  
ATOM    174  CD  LYS A 365      22.847  19.205  23.240  1.00 51.60           C  
ATOM    175  CE  LYS A 365      24.343  19.573  23.252  1.00 50.30           C  
ATOM    176  NZ  LYS A 365      24.616  20.943  23.820  1.00 48.60           N  
ATOM    177  N   ASP A 366      22.650  14.596  26.254  1.00 50.89           N  
ATOM    178  CA  ASP A 366      23.058  13.952  27.499  1.00 50.61           C  
ATOM    179  C   ASP A 366      23.453  12.481  27.314  1.00 50.38           C  
ATOM    180  O   ASP A 366      24.538  12.072  27.776  1.00 50.49           O  
ATOM    181  CB  ASP A 366      21.949  14.089  28.542  1.00 50.87           C  
ATOM    182  CG  ASP A 366      21.875  15.500  29.133  1.00 52.01           C  
ATOM    183  OD1 ASP A 366      22.004  16.505  28.373  1.00 53.98           O  
ATOM    184  OD2 ASP A 366      21.700  15.603  30.372  1.00 52.28           O  
ATOM    185  N   THR A 367      22.579  11.706  26.623  1.00 49.61           N  
ATOM    186  CA  THR A 367      22.840  10.280  26.370  1.00 48.94           C  
ATOM    187  C   THR A 367      24.126  10.032  25.557  1.00 48.47           C  
ATOM    188  O   THR A 367      24.983   9.243  25.974  1.00 48.12           O  
ATOM    189  CB  THR A 367      21.615   9.580  25.718  1.00 48.46           C  
ATOM    190  OG1 THR A 367      20.527   9.575  26.650  1.00 48.90           O  
ATOM    191  CG2 THR A 367      21.928   8.143  25.370  1.00 47.97           C  
ATOM    192  N   LEU A 368      24.272  10.722  24.425  1.00 48.43           N  
ATOM    193  CA  LEU A 368      25.384  10.446  23.500  1.00 48.18           C  
ATOM    194  C   LEU A 368      26.629  11.303  23.698  1.00 48.47           C  
ATOM    195  O   LEU A 368      27.634  11.135  22.991  1.00 49.03           O  
ATOM    196  CB  LEU A 368      24.927  10.584  22.049  1.00 48.29           C  
ATOM    197  CG  LEU A 368      23.796   9.684  21.581  1.00 47.05           C  
ATOM    198  CD1 LEU A 368      23.628   9.890  20.093  1.00 44.74           C  
ATOM    199  CD2 LEU A 368      24.096   8.234  21.927  1.00 45.83           C  
ATOM    200  N   GLY A 369      26.549  12.236  24.631  1.00 48.35           N  
ATOM    201  CA  GLY A 369      27.624  13.177  24.880  1.00 48.44           C  
ATOM    202  C   GLY A 369      27.856  14.072  23.682  1.00 48.29           C  
ATOM    203  O   GLY A 369      29.007  14.347  23.345  1.00 48.72           O  
ATOM    204  N   LEU A 370      26.777  14.511  23.028  1.00 47.87           N  
ATOM    205  CA  LEU A 370      26.906  15.439  21.895  1.00 47.87           C  
ATOM    206  C   LEU A 370      27.214  16.821  22.418  1.00 48.34           C  
ATOM    207  O   LEU A 370      26.629  17.261  23.409  1.00 48.04           O  
ATOM    208  CB  LEU A 370      25.641  15.520  21.042  1.00 47.09           C  
ATOM    209  CG  LEU A 370      24.963  14.208  20.689  1.00 46.53           C  
ATOM    210  CD1 LEU A 370      23.604  14.476  20.049  1.00 45.60           C  
ATOM    211  CD2 LEU A 370      25.882  13.408  19.793  1.00 46.32           C  
ATOM    212  N   ARG A 371      28.137  17.490  21.731  1.00 48.79           N  
ATOM    213  CA  ARG A 371      28.525  18.863  22.029  1.00 49.13           C  
ATOM    214  C   ARG A 371      27.460  19.835  21.544  1.00 48.64           C  
ATOM    215  O   ARG A 371      27.163  20.832  22.211  1.00 48.91           O  
ATOM    216  CB  ARG A 371      29.807  19.177  21.285  1.00 49.41           C  
ATOM    217  CG  ARG A 371      31.083  18.868  22.004  1.00 51.46           C  
ATOM    218  CD  ARG A 371      32.232  19.454  21.174  1.00 55.84           C  
ATOM    219  NE  ARG A 371      32.247  20.925  21.225  1.00 58.12           N  
ATOM    220  CZ  ARG A 371      31.739  21.743  20.294  1.00 58.95           C  
ATOM    221  NH1 ARG A 371      31.156  21.262  19.188  1.00 57.17           N  
ATOM    222  NH2 ARG A 371      31.822  23.061  20.474  1.00 58.53           N  
ATOM    223  N   ALA A 372      26.920  19.531  20.360  1.00 47.98           N  
ATOM    224  CA  ALA A 372      25.941  20.349  19.661  1.00 47.18           C  
ATOM    225  C   ALA A 372      25.018  19.460  18.830  1.00 47.27           C  
ATOM    226  O   ALA A 372      25.230  18.251  18.708  1.00 46.72           O  
ATOM    227  CB  ALA A 372      26.647  21.326  18.763  1.00 47.43           C  
ATOM    228  N   VAL A 373      23.996  20.073  18.253  1.00 47.00           N  
ATOM    229  CA  VAL A 373      23.125  19.399  17.312  1.00 47.16           C  
ATOM    230  C   VAL A 373      22.977  20.315  16.103  1.00 47.19           C  
ATOM    231  O   VAL A 373      23.142  21.529  16.243  1.00 47.06           O  
ATOM    232  CB  VAL A 373      21.729  19.055  17.951  1.00 47.66           C  
ATOM    233  CG1 VAL A 373      21.845  17.878  18.926  1.00 47.48           C  
ATOM    234  CG2 VAL A 373      21.120  20.260  18.643  1.00 46.49           C  
ATOM    235  N   PRO A 374      22.672  19.752  14.912  1.00 47.15           N  
ATOM    236  CA  PRO A 374      22.527  20.667  13.770  1.00 47.75           C  
ATOM    237  C   PRO A 374      21.348  21.631  13.920  1.00 48.46           C  
ATOM    238  O   PRO A 374      20.374  21.307  14.585  1.00 48.66           O  
ATOM    239  CB  PRO A 374      22.336  19.729  12.566  1.00 47.28           C  
ATOM    240  CG  PRO A 374      21.904  18.418  13.145  1.00 46.34           C  
ATOM    241  CD  PRO A 374      22.464  18.337  14.534  1.00 47.08           C  
ATOM    242  N   GLU A 375      21.449  22.811  13.317  1.00 49.93           N  
ATOM    243  CA  GLU A 375      20.373  23.809  13.376  1.00 51.32           C  
ATOM    244  C   GLU A 375      19.907  24.088  14.799  1.00 52.28           C  
ATOM    245  O   GLU A 375      18.721  24.342  15.009  1.00 52.61           O  
ATOM    246  CB  GLU A 375      19.147  23.365  12.564  1.00 51.17           C  
ATOM    247  CG  GLU A 375      19.400  23.170  11.104  1.00 53.07           C  
ATOM    248  CD  GLU A 375      19.599  24.473  10.382  1.00 55.07           C  
ATOM    249  OE1 GLU A 375      20.702  25.045  10.476  1.00 55.60           O  
ATOM    250  OE2 GLU A 375      18.649  24.926   9.712  1.00 57.35           O  
ATOM    251  N   GLU A 376      20.818  24.026  15.770  1.00 53.03           N  
ATOM    252  CA  GLU A 376      20.436  24.214  17.164  1.00 54.18           C  
ATOM    253  C   GLU A 376      19.806  25.600  17.349  1.00 54.48           C  
ATOM    254  O   GLU A 376      20.243  26.564  16.702  1.00 55.15           O  
ATOM    255  CB  GLU A 376      21.627  23.992  18.092  1.00 53.98           C  
ATOM    256  CG  GLU A 376      21.209  23.546  19.492  1.00 55.46           C  
ATOM    257  CD  GLU A 376      22.374  23.070  20.353  1.00 55.20           C  
ATOM    258  OE1 GLU A 376      22.098  22.619  21.500  1.00 55.97           O  
ATOM    259  OE2 GLU A 376      23.550  23.163  19.895  1.00 55.91           O  
ATOM    260  N   GLU A 377      18.824  25.704  18.218  1.00 54.69           N  
ATOM    261  CA  GLU A 377      18.064  26.929  18.339  0.50 54.75           C  
ATOM    263  C   GLU A 377      17.498  27.555  17.106  1.00 54.66           C  
ATOM    264  O   GLU A 377      17.432  28.757  17.071  1.00 55.33           O  
ATOM    265  CB  GLU A 377      18.816  27.980  19.170  0.50 54.81           C  
ATOM    267  CG  GLU A 377      20.269  28.251  18.754  0.50 54.70           C  
ATOM    269  CD  GLU A 377      21.294  28.042  19.873  0.50 54.09           C  
ATOM    271  OE1 GLU A 377      22.447  28.511  19.732  0.50 52.89           O  
ATOM    273  OE2 GLU A 377      20.951  27.414  20.898  0.50 53.58           O  
ATOM    275  N   LYS A 378      17.082  26.771  16.132  1.00 54.38           N  
ATOM    276  CA  LYS A 378      16.399  27.290  14.929  1.00 53.69           C  
ATOM    277  C   LYS A 378      14.971  26.672  14.771  1.00 53.42           C  
ATOM    278  O   LYS A 378      14.346  26.792  13.719  1.00 53.85           O  
ATOM    279  CB  LYS A 378      17.242  27.058  13.670  1.00 53.25           C  
ATOM    280  CG  LYS A 378      18.387  28.052  13.478  1.00 53.85           C  
ATOM    281  CD  LYS A 378      19.190  27.645  12.268  1.00 54.09           C  
ATOM    282  CE  LYS A 378      20.637  28.126  12.362  1.00 55.09           C  
ATOM    283  NZ  LYS A 378      21.537  27.196  11.583  1.00 56.16           N  
ATOM    284  N   GLY A 379      14.548  25.911  15.790  1.00 52.38           N  
ATOM    285  CA  GLY A 379      13.185  25.371  15.887  1.00 51.08           C  
ATOM    286  C   GLY A 379      12.786  24.524  14.683  1.00 49.98           C  
ATOM    287  O   GLY A 379      11.629  24.631  14.153  1.00 50.73           O  
ATOM    288  N   VAL A 380      13.758  23.665  14.277  1.00 48.60           N  
ATOM    289  CA  VAL A 380      13.651  22.963  12.999  1.00 46.36           C  
ATOM    290  C   VAL A 380      13.138  21.542  13.235  1.00 45.62           C  
ATOM    291  O   VAL A 380      12.351  21.002  12.445  1.00 45.30           O  
ATOM    292  CB  VAL A 380      15.028  22.952  12.310  1.00 46.49           C  
ATOM    293  CG1 VAL A 380      14.933  22.451  10.899  1.00 45.57           C  
ATOM    294  CG2 VAL A 380      15.604  24.376  12.342  1.00 46.09           C  
ATOM    295  N   TYR A 381      13.614  20.917  14.311  1.00 44.31           N  
ATOM    296  CA  TYR A 381      13.196  19.579  14.687  1.00 43.10           C  
ATOM    297  C   TYR A 381      13.358  19.549  16.192  1.00 43.44           C  
ATOM    298  O   TYR A 381      14.083  20.395  16.782  1.00 44.09           O  
ATOM    299  CB  TYR A 381      14.068  18.494  14.020  1.00 43.20           C  
ATOM    300  CG  TYR A 381      15.542  18.649  14.344  1.00 41.97           C  
ATOM    301  CD1 TYR A 381      16.058  18.090  15.504  1.00 41.08           C  
ATOM    302  CD2 TYR A 381      16.412  19.361  13.496  1.00 41.34           C  
ATOM    303  CE1 TYR A 381      17.381  18.233  15.834  1.00 41.39           C  
ATOM    304  CE2 TYR A 381      17.782  19.515  13.821  1.00 40.40           C  
ATOM    305  CZ  TYR A 381      18.241  18.937  14.997  1.00 41.98           C  
ATOM    306  OH  TYR A 381      19.540  19.020  15.400  1.00 41.59           O  
ATOM    307  N   HIS A 382      12.683  18.620  16.844  1.00 43.69           N  
ATOM    308  CA  HIS A 382      12.724  18.518  18.285  1.00 43.37           C  
ATOM    309  C   HIS A 382      13.009  17.181  18.804  1.00 42.67           C  
ATOM    310  O   HIS A 382      13.166  16.992  19.987  1.00 42.49           O  
ATOM    311  CB  HIS A 382      11.483  19.095  18.917  1.00 43.96           C  
ATOM    312  CG  HIS A 382      11.407  20.549  18.730  1.00 47.17           C  
ATOM    313  ND1 HIS A 382      10.714  21.119  17.695  1.00 49.52           N  
ATOM    314  CD2 HIS A 382      12.063  21.548  19.346  1.00 48.68           C  
ATOM    315  CE1 HIS A 382      10.900  22.419  17.713  1.00 48.27           C  
ATOM    316  NE2 HIS A 382      11.710  22.702  18.711  1.00 47.54           N  
ATOM    317  N   THR A 383      13.102  16.236  17.902  1.00 40.92           N  
ATOM    318  CA  THR A 383      13.360  14.875  18.313  1.00 40.90           C  
ATOM    319  C   THR A 383      14.496  14.318  17.502  1.00 41.17           C  
ATOM    320  O   THR A 383      14.934  14.935  16.514  1.00 41.48           O  
ATOM    321  CB  THR A 383      12.143  13.972  18.094  1.00 40.68           C  
ATOM    322  OG1 THR A 383      11.857  13.907  16.701  1.00 39.87           O  
ATOM    323  CG2 THR A 383      10.904  14.492  18.856  1.00 40.72           C  
ATOM    324  N   LEU A 384      14.965  13.142  17.914  1.00 41.25           N  
ATOM    325  CA  LEU A 384      15.992  12.421  17.170  1.00 40.78           C  
ATOM    326  C   LEU A 384      15.521  12.110  15.756  1.00 40.89           C  
ATOM    327  O   LEU A 384      16.262  12.316  14.810  1.00 41.89           O  
ATOM    328  CB  LEU A 384      16.403  11.141  17.904  1.00 40.64           C  
ATOM    329  CG  LEU A 384      17.393  10.225  17.178  1.00 40.28           C  
ATOM    330  CD1 LEU A 384      18.722  10.968  16.790  1.00 39.60           C  
ATOM    331  CD2 LEU A 384      17.655   8.970  17.995  1.00 40.21           C  
ATOM    332  N   SER A 385      14.291  11.605  15.622  1.00 40.21           N  
ATOM    333  CA  SER A 385      13.667  11.402  14.316  1.00 38.93           C  
ATOM    334  C   SER A 385      13.827  12.635  13.380  1.00 37.83           C  
ATOM    335  O   SER A 385      14.299  12.509  12.247  1.00 38.40           O  
ATOM    336  CB  SER A 385      12.196  11.041  14.529  1.00 38.15           C  
ATOM    337  OG  SER A 385      11.570  10.765  13.290  1.00 39.15           O  
ATOM    338  N   GLY A 386      13.467  13.830  13.862  1.00 38.38           N  
ATOM    339  CA  GLY A 386      13.544  15.048  13.049  1.00 37.37           C  
ATOM    340  C   GLY A 386      14.969  15.475  12.708  1.00 38.33           C  
ATOM    341  O   GLY A 386      15.205  16.102  11.671  1.00 39.18           O  
HETATM  342  N   MSE A 387      15.920  15.165  13.590  1.00 38.75           N  
HETATM  343  CA  MSE A 387      17.338  15.473  13.366  1.00 39.53           C  
HETATM  344  C   MSE A 387      17.864  14.578  12.262  1.00 38.43           C  
HETATM  345  O   MSE A 387      18.538  15.045  11.333  1.00 38.67           O  
HETATM  346  CB  MSE A 387      18.156  15.255  14.644  1.00 39.25           C  
HETATM  347  CG  MSE A 387      19.629  15.755  14.564  1.00 41.32           C  
HETATM  348 SE   MSE A 387      20.675  15.309  16.178  0.75 44.94          SE  
HETATM  349  CE  MSE A 387      21.356  13.597  15.622  1.00 41.76           C  
ATOM    350  N   ILE A 388      17.532  13.285  12.350  1.00 38.03           N  
ATOM    351  CA  ILE A 388      17.905  12.336  11.293  1.00 37.81           C  
ATOM    352  C   ILE A 388      17.314  12.745   9.948  1.00 37.75           C  
ATOM    353  O   ILE A 388      18.034  12.792   8.954  1.00 37.38           O  
ATOM    354  CB  ILE A 388      17.628  10.881  11.667  1.00 37.35           C  
ATOM    355  CG1 ILE A 388      18.627  10.455  12.740  1.00 37.50           C  
ATOM    356  CG2 ILE A 388      17.751   9.976  10.422  1.00 37.32           C  
ATOM    357  CD1 ILE A 388      18.290   9.112  13.436  1.00 40.20           C  
HETATM  358  N   MSE A 389      16.027  13.097   9.937  1.00 38.26           N  
HETATM  359  CA  MSE A 389      15.400  13.591   8.727  1.00 39.26           C  
HETATM  360  C   MSE A 389      16.107  14.860   8.173  1.00 38.43           C  
HETATM  361  O   MSE A 389      16.287  14.984   6.968  1.00 37.64           O  
HETATM  362  CB  MSE A 389      13.891  13.805   8.961  1.00 39.21           C  
HETATM  363  CG  MSE A 389      13.197  14.548   7.814  1.00 41.02           C  
HETATM  364 SE   MSE A 389      11.245  14.441   7.713  0.90 45.68          SE  
HETATM  365  CE  MSE A 389      10.755  15.687   9.155  1.00 40.91           C  
ATOM    366  N   TRP A 390      16.446  15.820   9.052  1.00 38.14           N  
ATOM    367  CA  TRP A 390      17.222  16.986   8.643  1.00 37.09           C  
ATOM    368  C   TRP A 390      18.572  16.563   7.988  1.00 37.36           C  
ATOM    369  O   TRP A 390      18.885  16.989   6.862  1.00 36.32           O  
ATOM    370  CB  TRP A 390      17.427  17.966   9.807  1.00 36.37           C  
ATOM    371  CG  TRP A 390      17.912  19.262   9.308  1.00 37.31           C  
ATOM    372  CD1 TRP A 390      17.147  20.299   8.860  1.00 36.51           C  
ATOM    373  CD2 TRP A 390      19.283  19.665   9.118  1.00 36.12           C  
ATOM    374  NE1 TRP A 390      17.940  21.313   8.433  1.00 35.96           N  
ATOM    375  CE2 TRP A 390      19.257  20.956   8.580  1.00 35.87           C  
ATOM    376  CE3 TRP A 390      20.526  19.055   9.366  1.00 36.81           C  
ATOM    377  CZ2 TRP A 390      20.428  21.681   8.290  1.00 36.76           C  
ATOM    378  CZ3 TRP A 390      21.691  19.774   9.082  1.00 37.50           C  
ATOM    379  CH2 TRP A 390      21.628  21.077   8.552  1.00 36.59           C  
ATOM    380  N   LEU A 391      19.337  15.704   8.665  1.00 37.28           N  
ATOM    381  CA  LEU A 391      20.660  15.271   8.142  1.00 38.08           C  
ATOM    382  C   LEU A 391      20.599  14.552   6.804  1.00 38.33           C  
ATOM    383  O   LEU A 391      21.504  14.696   5.972  1.00 38.47           O  
ATOM    384  CB  LEU A 391      21.388  14.372   9.149  1.00 38.83           C  
ATOM    385  CG  LEU A 391      21.937  15.120  10.367  1.00 40.98           C  
ATOM    386  CD1 LEU A 391      22.148  14.154  11.506  1.00 41.10           C  
ATOM    387  CD2 LEU A 391      23.234  15.905   9.980  1.00 39.23           C  
ATOM    388  N   LEU A 392      19.533  13.789   6.592  1.00 37.69           N  
ATOM    389  CA  LEU A 392      19.338  13.095   5.328  1.00 37.70           C  
ATOM    390  C   LEU A 392      18.790  14.026   4.257  1.00 37.00           C  
ATOM    391  O   LEU A 392      18.957  13.768   3.058  1.00 38.38           O  
ATOM    392  CB  LEU A 392      18.436  11.875   5.498  1.00 36.44           C  
ATOM    393  CG  LEU A 392      19.002  10.726   6.303  1.00 38.11           C  
ATOM    394  CD1 LEU A 392      17.859   9.785   6.637  1.00 39.03           C  
ATOM    395  CD2 LEU A 392      20.184   9.921   5.560  1.00 37.66           C  
ATOM    396  N   GLY A 393      18.142  15.097   4.686  1.00 36.70           N  
ATOM    397  CA  GLY A 393      17.481  16.038   3.765  1.00 35.47           C  
ATOM    398  C   GLY A 393      16.307  15.387   3.030  1.00 34.70           C  
ATOM    399  O   GLY A 393      15.944  15.821   1.953  1.00 33.73           O  
ATOM    400  N   ARG A 394      15.710  14.351   3.619  1.00 33.49           N  
ATOM    401  CA  ARG A 394      14.538  13.682   3.037  1.00 34.19           C  
ATOM    402  C   ARG A 394      13.913  12.768   4.093  1.00 34.96           C  
ATOM    403  O   ARG A 394      14.487  12.566   5.170  1.00 34.75           O  
ATOM    404  CB  ARG A 394      14.937  12.820   1.817  1.00 33.89           C  
ATOM    405  CG  ARG A 394      15.913  11.739   2.165  1.00 32.36           C  
ATOM    406  CD  ARG A 394      16.102  10.679   1.056  1.00 33.62           C  
ATOM    407  NE  ARG A 394      17.306   9.841   1.290  1.00 33.20           N  
ATOM    408  CZ  ARG A 394      17.395   8.837   2.161  1.00 34.37           C  
ATOM    409  NH1 ARG A 394      18.537   8.127   2.251  1.00 33.59           N  
ATOM    410  NH2 ARG A 394      16.356   8.520   2.940  1.00 34.00           N  
ATOM    411  N   LEU A 395      12.748  12.206   3.775  1.00 35.94           N  
ATOM    412  CA  LEU A 395      12.091  11.239   4.659  1.00 37.73           C  
ATOM    413  C   LEU A 395      12.986  10.022   4.884  1.00 37.22           C  
ATOM    414  O   LEU A 395      13.462   9.411   3.915  1.00 36.65           O  
ATOM    415  CB  LEU A 395      10.735  10.791   4.099  1.00 38.51           C  
ATOM    416  CG  LEU A 395       9.460  11.524   4.579  1.00 44.25           C  
ATOM    417  CD1 LEU A 395       9.228  11.372   6.108  1.00 46.77           C  
ATOM    418  CD2 LEU A 395       9.354  13.020   4.178  1.00 48.70           C  
ATOM    419  N   PRO A 396      13.249   9.694   6.160  1.00 37.34           N  
ATOM    420  CA  PRO A 396      14.099   8.552   6.452  1.00 36.10           C  
ATOM    421  C   PRO A 396      13.429   7.224   6.084  1.00 37.05           C  
ATOM    422  O   PRO A 396      12.187   7.142   5.978  1.00 36.72           O  
ATOM    423  CB  PRO A 396      14.309   8.635   7.967  1.00 35.81           C  
ATOM    424  CG  PRO A 396      13.933  10.039   8.343  1.00 37.95           C  
ATOM    425  CD  PRO A 396      12.794  10.359   7.398  1.00 36.56           C  
ATOM    426  N   GLN A 397      14.261   6.205   5.882  1.00 36.91           N  
ATOM    427  CA  GLN A 397      13.822   4.828   5.680  1.00 38.09           C  
ATOM    428  C   GLN A 397      14.613   3.925   6.589  1.00 38.26           C  
ATOM    429  O   GLN A 397      15.746   4.234   6.951  1.00 39.31           O  
ATOM    430  CB  GLN A 397      13.983   4.401   4.217  1.00 38.51           C  
ATOM    431  CG  GLN A 397      12.933   5.098   3.391  1.00 38.10           C  
ATOM    432  CD  GLN A 397      12.899   4.755   1.961  1.00 35.17           C  
ATOM    433  OE1 GLN A 397      12.931   3.590   1.596  1.00 34.25           O  
ATOM    434  NE2 GLN A 397      12.763   5.775   1.112  1.00 37.03           N  
ATOM    435  N   THR A 398      14.003   2.817   6.965  1.00 36.98           N  
ATOM    436  CA  THR A 398      14.641   1.823   7.791  1.00 36.51           C  
ATOM    437  C   THR A 398      15.809   1.225   7.011  1.00 36.14           C  
ATOM    438  O   THR A 398      15.632   0.711   5.902  1.00 35.53           O  
ATOM    439  CB  THR A 398      13.597   0.721   8.197  1.00 36.83           C  
ATOM    440  OG1 THR A 398      12.736   1.284   9.179  1.00 36.71           O  
ATOM    441  CG2 THR A 398      14.261  -0.508   8.779  1.00 36.15           C  
ATOM    442  N   GLY A 399      17.000   1.334   7.584  1.00 35.50           N  
ATOM    443  CA  GLY A 399      18.225   0.929   6.889  1.00 36.00           C  
ATOM    444  C   GLY A 399      19.133   2.118   6.644  1.00 35.93           C  
ATOM    445  O   GLY A 399      20.283   1.917   6.346  1.00 34.73           O  
ATOM    446  N   ASP A 400      18.591   3.346   6.748  1.00 35.93           N  
ATOM    447  CA  ASP A 400      19.361   4.577   6.495  1.00 37.13           C  
ATOM    448  C   ASP A 400      20.387   4.849   7.588  1.00 37.89           C  
ATOM    449  O   ASP A 400      20.118   4.623   8.772  1.00 37.52           O  
ATOM    450  CB  ASP A 400      18.458   5.834   6.431  1.00 35.71           C  
ATOM    451  CG  ASP A 400      18.008   6.190   5.009  1.00 36.36           C  
ATOM    452  OD1 ASP A 400      18.779   6.045   4.044  1.00 36.70           O  
ATOM    453  OD2 ASP A 400      16.869   6.701   4.864  1.00 39.55           O  
ATOM    454  N   ILE A 401      21.532   5.392   7.176  1.00 39.06           N  
ATOM    455  CA  ILE A 401      22.647   5.654   8.075  1.00 40.18           C  
ATOM    456  C   ILE A 401      22.978   7.136   7.950  1.00 41.21           C  
ATOM    457  O   ILE A 401      23.178   7.651   6.849  1.00 40.31           O  
ATOM    458  CB  ILE A 401      23.912   4.810   7.683  1.00 40.18           C  
ATOM    459  CG1 ILE A 401      23.583   3.318   7.433  1.00 40.12           C  
ATOM    460  CG2 ILE A 401      25.064   5.012   8.664  1.00 39.41           C  
ATOM    461  CD1 ILE A 401      23.000   2.550   8.643  1.00 38.42           C  
ATOM    462  N   THR A 402      23.018   7.838   9.075  1.00 41.80           N  
ATOM    463  CA  THR A 402      23.623   9.164   9.051  1.00 42.20           C  
ATOM    464  C   THR A 402      24.685   9.344  10.151  1.00 41.10           C  
ATOM    465  O   THR A 402      24.897   8.468  10.974  1.00 40.72           O  
ATOM    466  CB  THR A 402      22.550  10.336   9.003  1.00 43.39           C  
ATOM    467  OG1 THR A 402      23.240  11.591   8.807  1.00 46.03           O  
ATOM    468  CG2 THR A 402      21.720  10.393  10.289  1.00 41.38           C  
ATOM    469  N   PHE A 403      25.341  10.494  10.151  1.00 40.94           N  
ATOM    470  CA  PHE A 403      26.534  10.703  10.959  1.00 40.27           C  
ATOM    471  C   PHE A 403      26.532  12.086  11.572  1.00 40.42           C  
ATOM    472  O   PHE A 403      26.096  13.055  10.943  1.00 40.14           O  
ATOM    473  CB  PHE A 403      27.790  10.533  10.097  1.00 40.09           C  
ATOM    474  CG  PHE A 403      27.967   9.137   9.525  1.00 39.26           C  
ATOM    475  CD1 PHE A 403      28.623   8.148  10.251  1.00 39.92           C  
ATOM    476  CD2 PHE A 403      27.470   8.823   8.251  1.00 38.63           C  
ATOM    477  CE1 PHE A 403      28.805   6.863   9.703  1.00 39.44           C  
ATOM    478  CE2 PHE A 403      27.611   7.549   7.697  1.00 36.77           C  
ATOM    479  CZ  PHE A 403      28.299   6.571   8.406  1.00 39.36           C  
ATOM    480  N   TRP A 404      27.028  12.166  12.803  1.00 40.30           N  
ATOM    481  CA  TRP A 404      27.144  13.414  13.530  1.00 40.50           C  
ATOM    482  C   TRP A 404      28.129  13.232  14.681  1.00 41.01           C  
ATOM    483  O   TRP A 404      27.928  12.381  15.551  1.00 40.61           O  
ATOM    484  CB  TRP A 404      25.772  13.891  14.050  1.00 40.12           C  
ATOM    485  CG  TRP A 404      25.814  15.224  14.764  1.00 40.09           C  
ATOM    486  CD1 TRP A 404      25.739  15.438  16.143  1.00 41.35           C  
ATOM    487  CD2 TRP A 404      25.915  16.527  14.170  1.00 40.14           C  
ATOM    488  NE1 TRP A 404      25.819  16.786  16.413  1.00 40.35           N  
ATOM    489  CE2 TRP A 404      25.916  17.479  15.235  1.00 40.31           C  
ATOM    490  CE3 TRP A 404      26.003  16.993  12.844  1.00 41.63           C  
ATOM    491  CZ2 TRP A 404      26.002  18.865  15.009  1.00 39.80           C  
ATOM    492  CZ3 TRP A 404      26.103  18.382  12.616  1.00 40.01           C  
ATOM    493  CH2 TRP A 404      26.094  19.295  13.696  1.00 40.96           C  
ATOM    494  N   GLU A 405      29.185  14.056  14.669  1.00 41.45           N  
ATOM    495  CA  GLU A 405      30.249  14.041  15.671  1.00 41.62           C  
ATOM    496  C   GLU A 405      30.923  12.667  15.741  1.00 42.22           C  
ATOM    497  O   GLU A 405      31.467  12.196  14.745  1.00 42.76           O  
ATOM    498  CB  GLU A 405      29.735  14.539  17.031  1.00 41.44           C  
ATOM    499  CG  GLU A 405      29.118  15.947  16.966  1.00 41.12           C  
ATOM    500  CD  GLU A 405      28.840  16.569  18.330  1.00 41.99           C  
ATOM    501  OE1 GLU A 405      29.189  15.967  19.371  1.00 42.62           O  
ATOM    502  OE2 GLU A 405      28.274  17.681  18.364  1.00 42.18           O  
ATOM    503  N   ASN A 406      30.895  12.027  16.904  1.00 42.92           N  
ATOM    504  CA  ASN A 406      31.508  10.696  17.047  0.50 42.93           C  
ATOM    506  C   ASN A 406      30.496   9.553  16.809  1.00 42.62           C  
ATOM    507  O   ASN A 406      30.788   8.398  17.079  1.00 42.27           O  
ATOM    508  CB  ASN A 406      32.209  10.554  18.422  0.50 43.12           C  
ATOM    510  CG  ASN A 406      33.560   9.819  18.341  0.50 43.83           C  
ATOM    512  OD1 ASN A 406      34.091   9.570  17.253  0.50 44.82           O  
ATOM    514  ND2 ASN A 406      34.122   9.487  19.497  0.50 42.87           N  
ATOM    516  N   TRP A 407      29.324   9.874  16.263  1.00 42.28           N  
ATOM    517  CA  TRP A 407      28.236   8.873  16.129  1.00 42.38           C  
ATOM    518  C   TRP A 407      27.729   8.517  14.730  1.00 42.66           C  
ATOM    519  O   TRP A 407      27.528   9.387  13.864  1.00 42.18           O  
ATOM    520  CB  TRP A 407      27.039   9.269  16.999  1.00 42.23           C  
ATOM    521  CG  TRP A 407      27.397   9.372  18.453  1.00 42.11           C  
ATOM    522  CD1 TRP A 407      27.819  10.492  19.107  1.00 41.64           C  
ATOM    523  CD2 TRP A 407      27.404   8.315  19.417  1.00 41.40           C  
ATOM    524  NE1 TRP A 407      28.088  10.201  20.416  1.00 41.96           N  
ATOM    525  CE2 TRP A 407      27.825   8.873  20.641  1.00 42.84           C  
ATOM    526  CE3 TRP A 407      27.066   6.957  19.377  1.00 42.41           C  
ATOM    527  CZ2 TRP A 407      27.925   8.112  21.824  1.00 42.65           C  
ATOM    528  CZ3 TRP A 407      27.169   6.200  20.552  1.00 41.59           C  
ATOM    529  CH2 TRP A 407      27.596   6.782  21.753  1.00 42.28           C  
ATOM    530  N   ARG A 408      27.539   7.210  14.543  1.00 42.69           N  
ATOM    531  CA  ARG A 408      26.803   6.616  13.438  1.00 41.91           C  
ATOM    532  C   ARG A 408      25.390   6.310  13.973  1.00 41.48           C  
ATOM    533  O   ARG A 408      25.211   5.678  14.999  1.00 40.70           O  
ATOM    534  CB  ARG A 408      27.482   5.334  13.010  1.00 42.20           C  
ATOM    535  CG  ARG A 408      26.830   4.679  11.835  1.00 46.36           C  
ATOM    536  CD  ARG A 408      27.714   3.591  11.223  1.00 52.70           C  
ATOM    537  NE  ARG A 408      27.706   2.367  12.027  1.00 56.61           N  
ATOM    538  CZ  ARG A 408      28.731   1.914  12.755  1.00 58.94           C  
ATOM    539  NH1 ARG A 408      28.602   0.782  13.450  1.00 59.27           N  
ATOM    540  NH2 ARG A 408      29.887   2.567  12.788  1.00 58.42           N  
ATOM    541  N   LEU A 409      24.389   6.790  13.255  1.00 41.23           N  
ATOM    542  CA  LEU A 409      23.016   6.612  13.629  1.00 40.54           C  
ATOM    543  C   LEU A 409      22.336   5.811  12.523  1.00 39.92           C  
ATOM    544  O   LEU A 409      22.296   6.245  11.381  1.00 38.54           O  
ATOM    545  CB  LEU A 409      22.380   7.997  13.772  1.00 41.12           C  
ATOM    546  CG  LEU A 409      23.094   8.983  14.699  1.00 42.70           C  
ATOM    547  CD1 LEU A 409      22.529  10.391  14.532  1.00 42.53           C  
ATOM    548  CD2 LEU A 409      22.965   8.520  16.162  1.00 41.29           C  
ATOM    549  N   GLU A 410      21.805   4.640  12.875  1.00 39.67           N  
ATOM    550  CA  GLU A 410      21.178   3.721  11.916  1.00 39.60           C  
ATOM    551  C   GLU A 410      19.675   3.651  12.237  1.00 38.84           C  
ATOM    552  O   GLU A 410      19.303   3.467  13.399  1.00 37.53           O  
ATOM    553  CB  GLU A 410      21.805   2.318  12.029  1.00 39.03           C  
ATOM    554  CG  GLU A 410      21.124   1.300  11.120  1.00 41.41           C  
ATOM    555  CD  GLU A 410      21.756  -0.089  11.110  1.00 42.11           C  
ATOM    556  OE1 GLU A 410      22.811  -0.281  11.760  1.00 45.94           O  
ATOM    557  OE2 GLU A 410      21.180  -0.999  10.443  1.00 44.79           O  
ATOM    558  N   VAL A 411      18.825   3.821  11.213  1.00 38.20           N  
ATOM    559  CA  VAL A 411      17.376   3.749  11.409  1.00 37.64           C  
ATOM    560  C   VAL A 411      17.002   2.266  11.396  1.00 38.27           C  
ATOM    561  O   VAL A 411      17.201   1.544  10.388  1.00 36.70           O  
ATOM    562  CB  VAL A 411      16.544   4.468  10.305  1.00 37.75           C  
ATOM    563  CG1 VAL A 411      15.036   4.373  10.638  1.00 37.12           C  
ATOM    564  CG2 VAL A 411      17.002   5.911  10.056  1.00 36.31           C  
ATOM    565  N   ILE A 412      16.472   1.827  12.535  1.00 38.12           N  
ATOM    566  CA  ILE A 412      16.248   0.411  12.819  1.00 40.21           C  
ATOM    567  C   ILE A 412      14.767   0.088  12.635  1.00 39.23           C  
ATOM    568  O   ILE A 412      14.435  -0.969  12.162  1.00 39.62           O  
ATOM    569  CB  ILE A 412      16.753   0.049  14.278  1.00 40.65           C  
ATOM    570  CG1 ILE A 412      18.275   0.026  14.332  1.00 41.40           C  
ATOM    571  CG2 ILE A 412      16.236  -1.277  14.769  1.00 42.79           C  
ATOM    572  CD1 ILE A 412      18.896  -0.835  13.328  1.00 43.03           C  
ATOM    573  N   ASP A 413      13.898   1.042  12.926  1.00 39.25           N  
ATOM    574  CA  ASP A 413      12.462   0.848  12.789  1.00 40.30           C  
ATOM    575  C   ASP A 413      11.720   2.162  12.575  1.00 39.93           C  
ATOM    576  O   ASP A 413      12.153   3.179  13.075  1.00 39.97           O  
ATOM    577  CB  ASP A 413      11.925   0.182  14.063  1.00 41.18           C  
ATOM    578  CG  ASP A 413      10.580  -0.441  13.847  1.00 45.35           C  
ATOM    579  OD1 ASP A 413       9.741  -0.386  14.779  1.00 51.74           O  
ATOM    580  OD2 ASP A 413      10.349  -0.944  12.723  1.00 48.84           O  
HETATM  581  N   MSE A 414      10.603   2.132  11.848  1.00 39.59           N  
HETATM  582  CA  MSE A 414       9.792   3.311  11.614  1.00 40.16           C  
HETATM  583  C   MSE A 414       8.405   3.086  12.132  1.00 38.91           C  
HETATM  584  O   MSE A 414       7.884   1.973  12.037  1.00 38.15           O  
HETATM  585  CB  MSE A 414       9.567   3.596  10.108  1.00 40.69           C  
HETATM  586  CG  MSE A 414      10.746   3.637   9.177  1.00 46.80           C  
HETATM  587 SE   MSE A 414      11.747   5.296   9.069  0.90 52.78          SE  
HETATM  588  CE  MSE A 414      10.379   6.743   8.888  1.00 47.75           C  
ATOM    589  N   ASP A 415       7.782   4.175  12.565  1.00 37.39           N  
ATOM    590  CA  ASP A 415       6.313   4.247  12.710  1.00 37.50           C  
ATOM    591  C   ASP A 415       5.754   5.139  11.583  1.00 36.55           C  
ATOM    592  O   ASP A 415       5.709   6.338  11.719  1.00 36.88           O  
ATOM    593  CB  ASP A 415       5.955   4.778  14.118  1.00 36.99           C  
ATOM    594  CG  ASP A 415       4.471   5.077  14.306  1.00 37.17           C  
ATOM    595  OD1 ASP A 415       3.590   4.645  13.528  1.00 35.44           O  
ATOM    596  OD2 ASP A 415       4.176   5.751  15.305  1.00 40.62           O  
ATOM    597  N   SER A 416       5.325   4.535  10.484  1.00 36.52           N  
ATOM    598  CA  SER A 416       5.033   5.256   9.236  1.00 36.54           C  
ATOM    599  C   SER A 416       6.134   6.317   8.909  1.00 36.86           C  
ATOM    600  O   SER A 416       7.295   5.939   8.714  1.00 36.12           O  
ATOM    601  CB  SER A 416       3.614   5.827   9.223  1.00 36.50           C  
ATOM    602  OG  SER A 416       2.599   4.854   9.521  1.00 36.69           O  
ATOM    603  N   LYS A 417       5.790   7.614   8.872  1.00 36.58           N  
ATOM    604  CA  LYS A 417       6.778   8.673   8.493  1.00 37.00           C  
ATOM    605  C   LYS A 417       7.851   9.026   9.522  1.00 36.12           C  
ATOM    606  O   LYS A 417       8.840   9.681   9.189  1.00 36.07           O  
ATOM    607  CB  LYS A 417       6.073   9.983   8.117  1.00 37.52           C  
ATOM    608  CG  LYS A 417       5.550  10.046   6.697  1.00 39.18           C  
ATOM    609  CD  LYS A 417       5.259  11.479   6.373  1.00 39.99           C  
ATOM    610  CE  LYS A 417       4.333  11.582   5.205  1.00 41.01           C  
ATOM    611  NZ  LYS A 417       4.407  12.988   4.722  1.00 43.18           N  
ATOM    612  N   ARG A 418       7.670   8.626  10.769  1.00 35.68           N  
ATOM    613  CA  ARG A 418       8.612   9.057  11.806  1.00 36.00           C  
ATOM    614  C   ARG A 418       9.482   7.884  12.278  1.00 36.26           C  
ATOM    615  O   ARG A 418       9.039   6.750  12.239  1.00 36.28           O  
ATOM    616  CB  ARG A 418       7.861   9.703  12.966  1.00 35.17           C  
ATOM    617  CG  ARG A 418       7.071  10.963  12.524  1.00 35.00           C  
ATOM    618  CD  ARG A 418       6.571  11.767  13.691  1.00 36.01           C  
ATOM    619  NE  ARG A 418       5.716  10.958  14.556  1.00 37.22           N  
ATOM    620  CZ  ARG A 418       5.196  11.380  15.703  1.00 36.91           C  
ATOM    621  NH1 ARG A 418       5.447  12.598  16.126  1.00 35.35           N  
ATOM    622  NH2 ARG A 418       4.448  10.560  16.429  1.00 36.49           N  
ATOM    623  N   ILE A 419      10.708   8.159  12.705  1.00 36.59           N  
ATOM    624  CA  ILE A 419      11.580   7.082  13.153  1.00 37.86           C  
ATOM    625  C   ILE A 419      11.185   6.605  14.525  1.00 38.25           C  
ATOM    626  O   ILE A 419      10.877   7.408  15.411  1.00 38.74           O  
ATOM    627  CB  ILE A 419      13.043   7.468  13.147  1.00 37.89           C  
ATOM    628  CG1 ILE A 419      13.501   7.721  11.703  1.00 37.36           C  
ATOM    629  CG2 ILE A 419      13.899   6.334  13.814  1.00 37.16           C  
ATOM    630  CD1 ILE A 419      14.539   8.815  11.588  1.00 39.40           C  
ATOM    631  N   ASP A 420      11.213   5.293  14.710  1.00 38.90           N  
ATOM    632  CA  ASP A 420      10.731   4.715  15.963  1.00 39.51           C  
ATOM    633  C   ASP A 420      11.913   4.198  16.801  1.00 39.91           C  
ATOM    634  O   ASP A 420      11.945   4.411  18.020  1.00 37.88           O  
ATOM    635  CB  ASP A 420       9.713   3.624  15.669  1.00 39.32           C  
ATOM    636  CG  ASP A 420       9.123   3.026  16.916  1.00 42.56           C  
ATOM    637  OD1 ASP A 420       8.684   3.797  17.809  1.00 44.84           O  
ATOM    638  OD2 ASP A 420       9.081   1.775  16.994  1.00 46.05           O  
ATOM    639  N   LYS A 421      12.883   3.543  16.140  1.00 40.07           N  
ATOM    640  CA  LYS A 421      14.121   3.079  16.810  1.00 41.28           C  
ATOM    641  C   LYS A 421      15.390   3.388  16.014  1.00 41.28           C  
ATOM    642  O   LYS A 421      15.373   3.351  14.791  1.00 40.68           O  
ATOM    643  CB  LYS A 421      14.040   1.596  17.223  1.00 42.34           C  
ATOM    644  CG  LYS A 421      13.453   1.439  18.647  1.00 45.25           C  
ATOM    645  CD  LYS A 421      12.572   0.211  18.826  1.00 49.83           C  
ATOM    646  CE  LYS A 421      11.511   0.388  19.980  1.00 48.75           C  
ATOM    647  NZ  LYS A 421      11.731   1.582  20.890  1.00 51.17           N  
ATOM    648  N   VAL A 422      16.465   3.721  16.735  1.00 40.95           N  
ATOM    649  CA  VAL A 422      17.715   4.185  16.162  1.00 41.15           C  
ATOM    650  C   VAL A 422      18.842   3.518  16.927  1.00 41.31           C  
ATOM    651  O   VAL A 422      18.822   3.508  18.148  1.00 41.00           O  
ATOM    652  CB  VAL A 422      17.872   5.727  16.292  1.00 41.21           C  
ATOM    653  CG1 VAL A 422      19.317   6.205  15.916  1.00 40.82           C  
ATOM    654  CG2 VAL A 422      16.803   6.445  15.469  1.00 41.10           C  
ATOM    655  N   LEU A 423      19.811   2.961  16.198  1.00 41.20           N  
ATOM    656  CA  LEU A 423      21.016   2.407  16.796  1.00 41.31           C  
ATOM    657  C   LEU A 423      22.167   3.400  16.636  1.00 41.17           C  
ATOM    658  O   LEU A 423      22.572   3.711  15.513  1.00 41.08           O  
ATOM    659  CB  LEU A 423      21.361   1.037  16.182  1.00 41.21           C  
ATOM    660  CG  LEU A 423      22.652   0.299  16.607  1.00 41.56           C  
ATOM    661  CD1 LEU A 423      22.659  -0.036  18.109  1.00 42.44           C  
ATOM    662  CD2 LEU A 423      22.865  -0.977  15.786  1.00 42.11           C  
ATOM    663  N   ALA A 424      22.678   3.888  17.764  1.00 41.29           N  
ATOM    664  CA  ALA A 424      23.808   4.802  17.791  1.00 41.76           C  
ATOM    665  C   ALA A 424      25.067   4.065  18.228  1.00 42.68           C  
ATOM    666  O   ALA A 424      25.084   3.394  19.275  1.00 43.50           O  
ATOM    667  CB  ALA A 424      23.524   5.968  18.719  1.00 41.08           C  
ATOM    668  N   THR A 425      26.119   4.207  17.427  1.00 43.37           N  
ATOM    669  CA  THR A 425      27.414   3.585  17.664  1.00 44.36           C  
ATOM    670  C   THR A 425      28.485   4.655  17.495  1.00 45.76           C  
ATOM    671  O   THR A 425      28.478   5.429  16.517  1.00 45.34           O  
ATOM    672  CB  THR A 425      27.681   2.413  16.682  1.00 44.15           C  
ATOM    673  OG1 THR A 425      26.529   1.573  16.632  1.00 44.23           O  
ATOM    674  CG2 THR A 425      28.865   1.556  17.136  1.00 44.46           C  
ATOM    675  N   LYS A 426      29.393   4.695  18.458  1.00 47.18           N  
ATOM    676  CA  LYS A 426      30.488   5.643  18.457  1.00 49.66           C  
ATOM    677  C   LYS A 426      31.629   5.148  17.561  1.00 50.86           C  
ATOM    678  O   LYS A 426      32.270   4.144  17.873  1.00 51.35           O  
ATOM    679  CB  LYS A 426      30.974   5.894  19.893  1.00 49.71           C  
ATOM    680  CG  LYS A 426      31.909   7.103  20.039  1.00 51.60           C  
ATOM    681  CD  LYS A 426      31.725   7.869  21.363  1.00 53.09           C  
ATOM    682  CE  LYS A 426      32.513   7.260  22.505  1.00 54.14           C  
ATOM    683  NZ  LYS A 426      31.785   6.100  23.107  1.00 55.31           N  
ATOM    684  N   ILE A 427      31.862   5.853  16.453  1.00 52.33           N  
ATOM    685  CA  ILE A 427      32.986   5.585  15.533  1.00 54.39           C  
ATOM    686  C   ILE A 427      34.350   5.779  16.208  1.00 55.29           C  
ATOM    687  O   ILE A 427      34.721   6.902  16.569  1.00 55.96           O  
ATOM    688  CB  ILE A 427      32.928   6.506  14.308  1.00 54.11           C  
ATOM    689  CG1 ILE A 427      31.476   6.842  13.948  1.00 54.05           C  
ATOM    690  CG2 ILE A 427      33.706   5.875  13.142  1.00 55.92           C  
ATOM    691  CD1 ILE A 427      31.316   8.024  12.975  1.00 54.80           C  
ATOM    692  N   ASP A 428      35.098   4.689  16.378  1.00 56.47           N  
ATOM    693  CA  ASP A 428      36.335   4.710  17.179  1.00 57.25           C  
ATOM    694  C   ASP A 428      36.194   5.558  18.460  1.00 57.38           C  
ATOM    695  O   ASP A 428      35.613   5.125  19.464  1.00 57.46           O  
ATOM    696  CB  ASP A 428      37.530   5.196  16.334  1.00 57.73           C  
ATOM    697  CG  ASP A 428      38.887   5.049  17.060  1.00 58.71           C  
ATOM    698  OD1 ASP A 428      39.916   5.461  16.472  1.00 59.22           O  
ATOM    699  OD2 ASP A 428      38.938   4.529  18.204  1.00 59.62           O  
TER     700      ASP A 428                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
