
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   86 (  684),  selected   86 , name 2rk5_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2rk5_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      D       5           -
LGA    Q     3_A      E       6          1.516
LGA    S     4_A      I       7          1.246
LGA    R     5_A      V       8          0.734
LGA    E     6_A      Q       9          0.430
LGA    I     7_A      R      10          0.957
LGA    A     8_A      E      11          2.219
LGA    D     9_A      D      12          2.396
LGA    N    10_A      G      13          2.289
LGA    T    11_A      S      14          0.594
LGA    Y    12_A      W      15          0.529
LGA    I    13_A      L      16          0.434
LGA    V    14_A      V      17          0.501
LGA    L    15_A      D      18          0.651
LGA    G    16_A      G      19          0.421
LGA    T    17_A      M      20          0.384
LGA    M    18_A      V      21          0.365
LGA    T    19_A      S      22          0.366
LGA    L    20_A      L      23          0.497
LGA    N    21_A      D      24          0.527
LGA    D    22_A      R      25          0.472
LGA    F    23_A      F      26          0.471
LGA    N    24_A      R      27          0.733
LGA    E    25_A      E      28          1.307
LGA    Y    26_A      F      29          1.303
LGA    F    27_A      F      30          0.710
LGA    E    28_A      E      31          0.732
LGA    T    29_A      L      32          0.851
LGA    D    30_A      E      33          3.719
LGA    -       -      A      34           -
LGA    L    31_A      P      35          2.877
LGA    E    32_A      L      36          3.793
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    S    33_A      E      39          1.367
LGA    -       -      A      40           -
LGA    D    34_A      G      41          2.325
LGA    -       -      G      42           -
LGA    N    35_A      N      43          1.741
LGA    V    36_A      I      44          0.468
LGA    D    37_A      H      45          0.437
LGA    T    38_A      T      46          0.447
LGA    I    39_A      L      47          0.768
LGA    A    40_A      A      48          0.873
LGA    G    41_A      G      49          0.479
LGA    F    42_A      V      50          0.912
LGA    Y    43_A      M      51          1.577
LGA    L    44_A      L      52          1.366
LGA    T    45_A      Y      53          0.356
LGA    G    46_A      Q      54          1.090
LGA    V    47_A      L      55          1.485
LGA    G    48_A      G      56          1.927
LGA    T    49_A      R      57          4.315
LGA    I    50_A      V      58          1.469
LGA    P    51_A      P      59          2.166
LGA    S    52_A      S      60          2.566
LGA    Q    53_A      V      61          3.006
LGA    E    54_A      -       -           -
LGA    E    55_A      -       -           -
LGA    K    56_A      T      62          2.388
LGA    E    57_A      D      63          0.979
LGA    H    58_A      R      64          0.559
LGA    F    59_A      F      65          1.749
LGA    E    60_A      E      66          1.230
LGA    V    61_A      W      67          0.528
LGA    E    62_A      N      68          0.283
LGA    S    63_A      -       -           -
LGA    N    64_A      -       -           -
LGA    G    65_A      -       -           -
LGA    K    66_A      -       -           -
LGA    H    67_A      G      69          0.684
LGA    L    68_A      F      70          0.610
LGA    E    69_A      S      71          0.463
LGA    L    70_A      F      72          0.280
LGA    I    71_A      E      73          0.469
LGA    N    72_A      V      74          0.558
LGA    D    73_A      V      75          1.327
LGA    K    74_A      D      76          0.939
LGA    V    75_A      M      77          0.543
LGA    K    76_A      D      78          1.116
LGA    D    77_A      R      79          2.308
LGA    G    78_A      T      80          0.996
LGA    R    79_A      R      81          1.155
LGA    V    80_A      V      82          0.314
LGA    T    81_A      D      83          0.984
LGA    K    82_A      K      84          0.709
LGA    L    83_A      I      85          0.376
LGA    K    84_A      L      86          0.301
LGA    I    85_A      V      87          0.513
LGA    L    86_A      Q      88          1.471
LGA    V    87_A      R      89          1.011
LGA    S    88_A      H      90          0.820
LGA    -       -      H      91           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   86   87    5.0     80    1.43    26.25     86.651     5.223

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.112087 * X  +   0.581687 * Y  +  -0.805653 * Z  +  11.974347
  Y_new =   0.993031 * X  +   0.035849 * Y  +  -0.112273 * Z  +  -2.104336
  Z_new =  -0.036426 * X  +  -0.812622 * Y  +  -0.581651 * Z  +  57.046051 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.192028    0.949565  [ DEG:  -125.5940     54.4060 ]
  Theta =   0.036434    3.105159  [ DEG:     2.0875    177.9125 ]
  Phi   =   1.683194   -1.458399  [ DEG:    96.4399    -83.5601 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rk5_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rk5_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   86   87   5.0   80   1.43   26.25  86.651
REMARK  ---------------------------------------------------------- 
MOLECULE 2rk5_A
HEADER    TOXIN                                   16-OCT-07   2RK5              
TITLE     CRYSTAL STRUCTURE OF A DOMAIN OF THE PUTATIVE HEMOLYSIN               
TITLE    2 FROM STREPTOCOCCUS MUTANS UA159                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE HEMOLYSIN;                                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: DOMAIN: RESIDUES 352-436;                                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS MUTANS UA159;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: UA159 / SEROTYPE C;                                          
SOURCE   5 ATCC: 700610;                                                        
SOURCE   6 GENE: HLYX, SMU_1693;                                                
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    HEMOLYSIN, STRUCTURAL GENOMICS, PSI-2, MCSG, PROTEIN                  
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MEMBRANE, TRANSMEMBRANE, TOXIN                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,H.LI,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR                 
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   06-NOV-07 2RK5    0                                                
JRNL        AUTH   R.ZHANG,S.CLANCY,H.LI,A.JOACHIMIAK                           
JRNL        TITL   THE CRYSTAL STRUCTURE OF A DOMAIN OF THE PUTATIVE            
JRNL        TITL 2 HEMOLYSIN FROM STREPTOCOCCUS MUTANS UA159.                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2RK5 A    5    89  UNP    O68574   O68574_STRMU   352    436             
SEQRES   1 A   87  GLN SER ARG GLU ILE ALA ASP ASN THR TYR ILE VAL LEU          
SEQRES   2 A   87  GLY THR MET THR LEU ASN ASP PHE ASN GLU TYR PHE GLU          
SEQRES   3 A   87  THR ASP LEU GLU SER ASP ASN VAL ASP THR ILE ALA GLY          
SEQRES   4 A   87  PHE TYR LEU THR GLY VAL GLY THR ILE PRO SER GLN GLU          
SEQRES   5 A   87  GLU LYS GLU HIS PHE GLU VAL GLU SER ASN GLY LYS HIS          
SEQRES   6 A   87  LEU GLU LEU ILE ASN ASP LYS VAL LYS ASP GLY ARG VAL          
SEQRES   7 A   87  THR LYS LEU LYS ILE LEU VAL SER GLU                          
FORMUL   2  HOH   *100(H2 O)                                                    
CRYST1   34.490   40.598   57.630  90.00  91.58  90.00 C 1 2 1       4          
ATOM      1  N   GLN A   3      14.787   6.133  27.720  1.00 20.63           N  
ATOM      2  CA  GLN A   3      14.706   6.517  26.267  1.00 19.68           C  
ATOM      3  C   GLN A   3      15.845   5.908  25.445  1.00 19.08           C  
ATOM      4  O   GLN A   3      15.734   5.788  24.202  1.00 16.55           O  
ATOM      5  CB  GLN A   3      14.766   8.045  26.110  1.00 20.60           C  
ATOM      6  CG  GLN A   3      13.596   8.810  26.653  1.00 24.82           C  
ATOM      7  CD  GLN A   3      12.303   8.382  26.028  1.00 27.83           C  
ATOM      8  OE1 GLN A   3      12.266   7.992  24.868  1.00 34.29           O  
ATOM      9  NE2 GLN A   3      11.216   8.449  26.801  1.00 33.48           N  
ATOM     10  N   SER A   4      16.946   5.585  26.133  1.00 18.59           N  
ATOM     11  CA  SER A   4      18.125   4.987  25.496  1.00 20.04           C  
ATOM     12  C   SER A   4      18.541   3.708  26.219  1.00 19.65           C  
ATOM     13  O   SER A   4      18.537   3.670  27.451  1.00 20.20           O  
ATOM     14  CB  SER A   4      19.295   5.965  25.518  1.00 20.10           C  
ATOM     15  OG  SER A   4      19.056   7.081  24.660  1.00 27.13           O  
ATOM     16  N   ARG A   5      18.951   2.695  25.451  1.00 18.88           N  
ATOM     17  CA  ARG A   5      19.289   1.380  25.979  1.00 20.55           C  
ATOM     18  C   ARG A   5      20.572   0.956  25.304  1.00 19.77           C  
ATOM     19  O   ARG A   5      20.649   0.974  24.073  1.00 17.92           O  
ATOM     20  CB  ARG A   5      18.191   0.380  25.610  1.00 20.81           C  
ATOM     21  CG  ARG A   5      17.719  -0.527  26.717  1.00 23.77           C  
ATOM     22  CD  ARG A   5      16.416  -1.210  26.318  1.00 23.88           C  
ATOM     23  NE  ARG A   5      16.594  -2.067  25.145  1.00 26.43           N  
ATOM     24  CZ  ARG A   5      16.113  -1.823  23.927  1.00 26.40           C  
ATOM     25  NH1 ARG A   5      15.377  -0.739  23.671  1.00 30.93           N  
ATOM     26  NH2 ARG A   5      16.356  -2.687  22.951  1.00 25.58           N  
ATOM     27  N   GLU A   6      21.573   0.557  26.083  1.00 19.52           N  
ATOM     28  CA  GLU A   6      22.773  -0.020  25.516  1.00 21.20           C  
ATOM     29  C   GLU A   6      22.490  -1.464  25.091  1.00 20.66           C  
ATOM     30  O   GLU A   6      21.939  -2.237  25.876  1.00 22.04           O  
ATOM     31  CB  GLU A   6      23.897   0.017  26.556  1.00 20.65           C  
ATOM     32  CG  GLU A   6      25.257  -0.365  26.023  1.00 22.35           C  
ATOM     33  CD  GLU A   6      26.393  -0.045  27.003  1.00 24.67           C  
ATOM     34  OE1 GLU A   6      26.234   0.837  27.886  1.00 29.97           O  
ATOM     35  OE2 GLU A   6      27.460  -0.671  26.873  1.00 29.87           O  
ATOM     36  N   ILE A   7      22.839  -1.834  23.858  1.00 19.78           N  
ATOM     37  CA  ILE A   7      22.577  -3.196  23.369  1.00 20.22           C  
ATOM     38  C   ILE A   7      23.867  -3.989  23.076  1.00 20.51           C  
ATOM     39  O   ILE A   7      23.844  -5.226  23.016  1.00 22.56           O  
ATOM     40  CB  ILE A   7      21.602  -3.210  22.161  1.00 19.67           C  
ATOM     41  CG1 ILE A   7      22.209  -2.517  20.946  1.00 18.89           C  
ATOM     42  CG2 ILE A   7      20.285  -2.527  22.558  1.00 19.32           C  
ATOM     43  CD1 ILE A   7      21.511  -2.865  19.660  1.00 19.86           C  
ATOM     44  N   ALA A   8      24.981  -3.278  22.935  1.00 19.33           N  
ATOM     45  CA  ALA A   8      26.305  -3.880  22.738  1.00 19.69           C  
ATOM     46  C   ALA A   8      27.286  -2.760  23.058  1.00 19.32           C  
ATOM     47  O   ALA A   8      26.848  -1.645  23.316  1.00 18.02           O  
ATOM     48  CB  ALA A   8      26.449  -4.347  21.313  1.00 19.00           C  
ATOM     49  N   ASP A   9      28.589  -3.029  23.086  1.00 19.77           N  
ATOM     50  CA  ASP A   9      29.544  -1.991  23.462  1.00 19.69           C  
ATOM     51  C   ASP A   9      29.417  -0.838  22.460  1.00 18.78           C  
ATOM     52  O   ASP A   9      29.407  -1.074  21.263  1.00 18.37           O  
ATOM     53  CB  ASP A   9      30.993  -2.507  23.469  1.00 20.84           C  
ATOM     54  CG  ASP A   9      31.351  -3.286  24.733  1.00 24.16           C  
ATOM     55  OD1 ASP A   9      30.534  -3.380  25.685  1.00 29.00           O  
ATOM     56  OD2 ASP A   9      32.479  -3.809  24.778  1.00 27.41           O  
ATOM     57  N   ASN A  10      29.264   0.373  22.980  1.00 17.43           N  
ATOM     58  CA  ASN A  10      29.144   1.591  22.164  1.00 16.83           C  
ATOM     59  C   ASN A  10      28.011   1.550  21.133  1.00 15.46           C  
ATOM     60  O   ASN A  10      28.058   2.268  20.128  1.00 14.31           O  
ATOM     61  CB  ASN A  10      30.486   1.866  21.480  1.00 17.59           C  
ATOM     62  CG  ASN A  10      31.616   2.078  22.486  1.00 18.81           C  
ATOM     63  OD1 ASN A  10      32.671   1.446  22.397  1.00 25.66           O  
ATOM     64  ND2 ASN A  10      31.379   2.934  23.469  1.00 21.65           N  
ATOM     65  N   THR A  11      26.996   0.726  21.393  1.00 14.77           N  
ATOM     66  CA  THR A  11      25.857   0.581  20.492  1.00 14.29           C  
ATOM     67  C   THR A  11      24.576   0.697  21.285  1.00 12.87           C  
ATOM     68  O   THR A  11      24.405   0.012  22.280  1.00 11.78           O  
ATOM     69  CB  THR A  11      25.905  -0.777  19.773  1.00 15.54           C  
ATOM     70  OG1 THR A  11      27.235  -0.989  19.263  1.00 17.72           O  
ATOM     71  CG2 THR A  11      24.863  -0.851  18.658  1.00 16.15           C  
ATOM     72  N   TYR A  12      23.661   1.561  20.828  1.00 10.60           N  
ATOM     73  CA  TYR A  12      22.452   1.897  21.573  1.00 11.19           C  
ATOM     74  C   TYR A  12      21.213   1.917  20.688  1.00  9.99           C  
ATOM     75  O   TYR A  12      21.312   2.171  19.489  1.00 10.74           O  
ATOM     76  CB  TYR A  12      22.594   3.275  22.225  1.00 11.79           C  
ATOM     77  CG  TYR A  12      23.838   3.433  23.054  1.00 12.30           C  
ATOM     78  CD1 TYR A  12      23.802   3.307  24.432  1.00 15.25           C  
ATOM     79  CD2 TYR A  12      25.064   3.686  22.452  1.00 14.45           C  
ATOM     80  CE1 TYR A  12      24.974   3.423  25.196  1.00 15.22           C  
ATOM     81  CE2 TYR A  12      26.225   3.817  23.212  1.00 14.97           C  
ATOM     82  CZ  TYR A  12      26.172   3.677  24.579  1.00 15.13           C  
ATOM     83  OH  TYR A  12      27.323   3.794  25.352  1.00 17.89           O  
ATOM     84  N   ILE A  13      20.061   1.615  21.286  1.00  9.92           N  
ATOM     85  CA  ILE A  13      18.772   1.890  20.651  1.00 10.07           C  
ATOM     86  C   ILE A  13      18.130   3.026  21.413  1.00  9.27           C  
ATOM     87  O   ILE A  13      18.054   2.992  22.645  1.00 10.00           O  
ATOM     88  CB  ILE A  13      17.837   0.656  20.608  1.00 10.74           C  
ATOM     89  CG1 ILE A  13      18.504  -0.478  19.826  1.00 12.44           C  
ATOM     90  CG2 ILE A  13      16.499   0.993  19.975  1.00 12.26           C  
ATOM     91  CD1 ILE A  13      18.648  -0.234  18.352  1.00 14.09           C  
ATOM     92  N   VAL A  14      17.720   4.063  20.679  1.00  9.25           N  
ATOM     93  CA  VAL A  14      16.981   5.191  21.258  1.00  9.90           C  
ATOM     94  C   VAL A  14      15.613   5.333  20.617  1.00  9.44           C  
ATOM     95  O   VAL A  14      15.467   5.113  19.425  1.00  9.36           O  
ATOM     96  CB  VAL A  14      17.731   6.559  21.163  1.00 10.77           C  
ATOM     97  CG1 VAL A  14      19.105   6.427  21.809  1.00 11.54           C  
ATOM     98  CG2 VAL A  14      17.809   7.083  19.764  1.00 13.15           C  
ATOM     99  N   LEU A  15      14.645   5.754  21.437  1.00  8.88           N  
ATOM    100  CA  LEU A  15      13.348   6.134  20.949  1.00  9.15           C  
ATOM    101  C   LEU A  15      13.457   7.427  20.151  1.00  9.45           C  
ATOM    102  O   LEU A  15      14.139   8.373  20.566  1.00  9.40           O  
ATOM    103  CB  LEU A  15      12.353   6.313  22.087  1.00  9.33           C  
ATOM    104  CG  LEU A  15      12.176   5.073  22.961  1.00 13.63           C  
ATOM    105  CD1 LEU A  15      11.048   5.361  23.932  1.00 18.50           C  
ATOM    106  CD2 LEU A  15      11.911   3.795  22.144  1.00 18.54           C  
ATOM    107  N   GLY A  16      12.787   7.458  19.001  1.00  8.90           N  
ATOM    108  CA  GLY A  16      12.814   8.644  18.153  1.00  8.55           C  
ATOM    109  C   GLY A  16      12.293   9.882  18.856  1.00  8.04           C  
ATOM    110  O   GLY A  16      12.638  11.007  18.522  1.00  9.15           O  
ATOM    111  N   THR A  17      11.396   9.662  19.804  1.00  9.06           N  
ATOM    112  CA  THR A  17      10.763  10.757  20.564  1.00  9.58           C  
ATOM    113  C   THR A  17      11.684  11.303  21.657  1.00  9.57           C  
ATOM    114  O   THR A  17      11.357  12.293  22.300  1.00  9.92           O  
ATOM    115  CB  THR A  17       9.424  10.308  21.205  1.00 11.10           C  
ATOM    116  OG1 THR A  17       9.655   9.093  21.916  1.00 12.73           O  
ATOM    117  CG2 THR A  17       8.383  10.109  20.126  1.00 11.76           C  
ATOM    118  N   MET A  18      12.832  10.660  21.883  1.00  9.03           N  
ATOM    119  CA  MET A  18      13.803  11.207  22.861  1.00  8.26           C  
ATOM    120  C   MET A  18      14.157  12.657  22.454  1.00  8.63           C  
ATOM    121  O   MET A  18      14.497  12.947  21.305  1.00  8.47           O  
ATOM    122  CB  MET A  18      15.051  10.330  22.936  1.00  8.67           C  
ATOM    123  CG  MET A  18      16.068  10.717  24.028  1.00 10.52           C  
ATOM    124  SD  MET A  18      17.503   9.563  24.063  1.00  6.50           S  
ATOM    125  CE  MET A  18      18.199   9.792  25.782  1.00 14.09           C  
ATOM    126  N   THR A  19      14.041  13.592  23.398  1.00  8.31           N  
ATOM    127  CA  THR A  19      14.327  14.974  23.064  1.00  9.01           C  
ATOM    128  C   THR A  19      15.808  15.123  22.789  1.00  8.94           C  
ATOM    129  O   THR A  19      16.621  14.367  23.294  1.00  8.86           O  
ATOM    130  CB  THR A  19      13.932  15.955  24.191  1.00  9.92           C  
ATOM    131  OG1 THR A  19      14.824  15.791  25.303  1.00 12.13           O  
ATOM    132  CG2 THR A  19      12.488  15.717  24.652  1.00 12.34           C  
ATOM    133  N   LEU A  20      16.174  16.129  22.018  1.00 10.19           N  
ATOM    134  CA  LEU A  20      17.582  16.368  21.780  1.00 11.09           C  
ATOM    135  C   LEU A  20      18.296  16.728  23.057  1.00 11.66           C  
ATOM    136  O   LEU A  20      19.464  16.359  23.250  1.00 12.78           O  
ATOM    137  CB  LEU A  20      17.840  17.490  20.807  1.00 13.55           C  
ATOM    138  CG  LEU A  20      17.880  17.148  19.346  1.00 15.80           C  
ATOM    139  CD1 LEU A  20      18.408  18.373  18.549  1.00 17.78           C  
ATOM    140  CD2 LEU A  20      18.730  15.881  19.065  1.00 15.16           C  
ATOM    141  N   ASN A  21      17.614  17.439  23.947  1.00 10.60           N  
ATOM    142  CA  ASN A  21      18.233  17.778  25.227  1.00 11.48           C  
ATOM    143  C   ASN A  21      18.533  16.516  26.056  1.00 10.32           C  
ATOM    144  O   ASN A  21      19.599  16.376  26.659  1.00 11.45           O  
ATOM    145  CB  ASN A  21      17.350  18.755  26.000  1.00 11.05           C  
ATOM    146  CG  ASN A  21      17.375  20.152  25.393  1.00 13.37           C  
ATOM    147  OD1 ASN A  21      18.310  20.517  24.672  1.00 15.08           O  
ATOM    148  ND2 ASN A  21      16.378  20.957  25.718  1.00 18.11           N  
ATOM    149  N   ASP A  22      17.593  15.573  26.104  1.00 10.28           N  
ATOM    150  CA  ASP A  22      17.836  14.324  26.829  1.00 11.18           C  
ATOM    151  C   ASP A  22      18.932  13.498  26.125  1.00 10.81           C  
ATOM    152  O   ASP A  22      19.796  12.908  26.781  1.00 10.84           O  
ATOM    153  CB  ASP A  22      16.538  13.534  26.960  1.00 12.55           C  
ATOM    154  CG  ASP A  22      15.558  14.128  27.978  1.00 15.36           C  
ATOM    155  OD1 ASP A  22      15.842  15.209  28.562  1.00 18.77           O  
ATOM    156  OD2 ASP A  22      14.489  13.493  28.194  1.00 17.87           O  
ATOM    157  N   PHE A  23      18.894  13.435  24.792  1.00  9.66           N  
ATOM    158  CA  PHE A  23      19.899  12.728  24.023  1.00 10.19           C  
ATOM    159  C   PHE A  23      21.293  13.284  24.339  1.00 10.04           C  
ATOM    160  O   PHE A  23      22.241  12.547  24.623  1.00  9.08           O  
ATOM    161  CB  PHE A  23      19.592  12.859  22.524  1.00 10.16           C  
ATOM    162  CG  PHE A  23      20.522  12.112  21.648  1.00  9.87           C  
ATOM    163  CD1 PHE A  23      20.209  10.841  21.195  1.00 10.37           C  
ATOM    164  CD2 PHE A  23      21.731  12.657  21.290  1.00  9.68           C  
ATOM    165  CE1 PHE A  23      21.087  10.138  20.379  1.00 11.38           C  
ATOM    166  CE2 PHE A  23      22.651  11.954  20.478  1.00 11.16           C  
ATOM    167  CZ  PHE A  23      22.335  10.678  20.044  1.00 10.53           C  
ATOM    168  N   ASN A  24      21.400  14.598  24.281  1.00 10.92           N  
ATOM    169  CA  ASN A  24      22.681  15.268  24.495  1.00 11.29           C  
ATOM    170  C   ASN A  24      23.217  15.030  25.905  1.00 11.16           C  
ATOM    171  O   ASN A  24      24.431  14.903  26.099  1.00 13.11           O  
ATOM    172  CB  ASN A  24      22.551  16.764  24.203  1.00 11.40           C  
ATOM    173  CG  ASN A  24      22.534  17.070  22.730  1.00 10.08           C  
ATOM    174  OD1 ASN A  24      23.132  16.348  21.924  1.00 10.34           O  
ATOM    175  ND2 ASN A  24      21.906  18.197  22.367  1.00 10.66           N  
ATOM    176  N   GLU A  25      22.322  14.995  26.893  1.00 12.92           N  
ATOM    177  CA  GLU A  25      22.716  14.722  28.273  1.00 13.77           C  
ATOM    178  C   GLU A  25      23.254  13.284  28.402  1.00 13.87           C  
ATOM    179  O   GLU A  25      24.307  13.056  29.026  1.00 14.75           O  
ATOM    180  CB  GLU A  25      21.553  14.987  29.246  1.00 14.23           C  
ATOM    181  CG  GLU A  25      21.888  14.759  30.701  1.00 16.36           C  
ATOM    182  CD  GLU A  25      20.666  14.906  31.611  1.00 19.48           C  
ATOM    183  OE1 GLU A  25      19.660  14.187  31.379  1.00 28.40           O  
ATOM    184  OE2 GLU A  25      20.707  15.736  32.555  1.00 28.13           O  
ATOM    185  N   TYR A  26      22.564  12.332  27.771  1.00 13.10           N  
ATOM    186  CA  TYR A  26      22.935  10.927  27.848  1.00 13.12           C  
ATOM    187  C   TYR A  26      24.265  10.638  27.156  1.00 12.32           C  
ATOM    188  O   TYR A  26      25.137   9.913  27.676  1.00 13.03           O  
ATOM    189  CB  TYR A  26      21.821  10.082  27.209  1.00 13.60           C  
ATOM    190  CG  TYR A  26      22.004   8.588  27.379  1.00 13.22           C  
ATOM    191  CD1 TYR A  26      21.438   7.915  28.441  1.00 15.97           C  
ATOM    192  CD2 TYR A  26      22.760   7.864  26.474  1.00 13.59           C  
ATOM    193  CE1 TYR A  26      21.625   6.544  28.591  1.00 15.59           C  
ATOM    194  CE2 TYR A  26      22.968   6.501  26.625  1.00 16.62           C  
ATOM    195  CZ  TYR A  26      22.395   5.850  27.673  1.00 15.47           C  
ATOM    196  OH  TYR A  26      22.622   4.491  27.807  1.00 18.46           O  
ATOM    197  N   PHE A  27      24.414  11.196  25.961  1.00 11.40           N  
ATOM    198  CA  PHE A  27      25.574  10.924  25.111  1.00 11.32           C  
ATOM    199  C   PHE A  27      26.694  11.932  25.220  1.00 11.39           C  
ATOM    200  O   PHE A  27      27.744  11.739  24.616  1.00 11.21           O  
ATOM    201  CB  PHE A  27      25.132  10.754  23.636  1.00 11.64           C  
ATOM    202  CG  PHE A  27      24.332   9.511  23.394  1.00 11.81           C  
ATOM    203  CD1 PHE A  27      24.970   8.284  23.311  1.00 11.48           C  
ATOM    204  CD2 PHE A  27      22.958   9.548  23.283  1.00 12.63           C  
ATOM    205  CE1 PHE A  27      24.244   7.136  23.095  1.00 12.05           C  
ATOM    206  CE2 PHE A  27      22.244   8.394  23.106  1.00 12.25           C  
ATOM    207  CZ  PHE A  27      22.886   7.197  23.006  1.00 12.22           C  
ATOM    208  N   GLU A  28      26.495  12.970  26.031  1.00 11.29           N  
ATOM    209  CA  GLU A  28      27.522  14.013  26.249  1.00 12.14           C  
ATOM    210  C   GLU A  28      27.854  14.723  24.947  1.00 11.82           C  
ATOM    211  O   GLU A  28      29.021  14.994  24.614  1.00 11.58           O  
ATOM    212  CB  GLU A  28      28.778  13.460  26.962  1.00 11.88           C  
ATOM    213  CG  GLU A  28      28.399  12.740  28.254  1.00 13.65           C  
ATOM    214  CD  GLU A  28      29.573  12.386  29.183  1.00 15.96           C  
ATOM    215  OE1 GLU A  28      30.748  12.577  28.825  1.00 20.10           O  
ATOM    216  OE2 GLU A  28      29.288  11.913  30.309  1.00 24.81           O  
ATOM    217  N   THR A  29      26.797  15.042  24.198  1.00 10.15           N  
ATOM    218  CA  THR A  29      26.942  15.706  22.920  1.00 11.10           C  
ATOM    219  C   THR A  29      26.183  17.047  22.948  1.00 10.30           C  
ATOM    220  O   THR A  29      25.612  17.440  23.992  1.00 11.54           O  
ATOM    221  CB  THR A  29      26.398  14.791  21.789  1.00 10.19           C  
ATOM    222  OG1 THR A  29      25.086  14.340  22.136  1.00 12.03           O  
ATOM    223  CG2 THR A  29      27.291  13.570  21.629  1.00 11.83           C  
ATOM    224  N   ASP A  30      26.230  17.743  21.813  1.00 11.63           N  
ATOM    225  CA  ASP A  30      25.630  19.071  21.651  1.00 12.55           C  
ATOM    226  C   ASP A  30      24.937  19.206  20.290  1.00 12.34           C  
ATOM    227  O   ASP A  30      25.057  20.234  19.611  1.00 13.64           O  
ATOM    228  CB  ASP A  30      26.706  20.182  21.843  1.00 12.95           C  
ATOM    229  CG  ASP A  30      27.753  20.222  20.694  1.00 19.65           C  
ATOM    230  OD1 ASP A  30      27.762  19.332  19.800  1.00 25.07           O  
ATOM    231  OD2 ASP A  30      28.574  21.180  20.682  1.00 28.43           O  
ATOM    232  N   LEU A  31      24.172  18.189  19.922  1.00 11.45           N  
ATOM    233  CA  LEU A  31      23.466  18.197  18.639  1.00 12.65           C  
ATOM    234  C   LEU A  31      22.396  19.266  18.668  1.00 13.71           C  
ATOM    235  O   LEU A  31      21.747  19.450  19.688  1.00 13.94           O  
ATOM    236  CB  LEU A  31      22.780  16.866  18.400  1.00 11.73           C  
ATOM    237  CG  LEU A  31      23.712  15.658  18.355  1.00 12.83           C  
ATOM    238  CD1 LEU A  31      22.945  14.408  17.942  1.00 12.52           C  
ATOM    239  CD2 LEU A  31      24.925  15.965  17.445  1.00 16.10           C  
ATOM    240  N   GLU A  32      22.232  19.970  17.557  1.00 14.39           N  
ATOM    241  CA  GLU A  32      21.141  20.932  17.439  1.00 15.98           C  
ATOM    242  C   GLU A  32      20.808  21.142  15.992  1.00 15.00           C  
ATOM    243  O   GLU A  32      21.657  20.990  15.121  1.00 15.56           O  
ATOM    244  CB  GLU A  32      21.516  22.256  18.088  1.00 17.28           C  
ATOM    245  CG  GLU A  32      22.712  22.926  17.464  1.00 20.75           C  
ATOM    246  CD  GLU A  32      23.118  24.204  18.202  1.00 22.34           C  
ATOM    247  OE1 GLU A  32      22.224  25.020  18.560  1.00 31.28           O  
ATOM    248  OE2 GLU A  32      24.339  24.395  18.431  1.00 30.92           O  
ATOM    249  N   SER A  33      19.557  21.479  15.738  1.00 13.87           N  
ATOM    250  CA  SER A  33      19.135  21.855  14.402  1.00 14.06           C  
ATOM    251  C   SER A  33      17.899  22.732  14.508  1.00 13.41           C  
ATOM    252  O   SER A  33      17.087  22.583  15.417  1.00 12.29           O  
ATOM    253  CB  SER A  33      18.866  20.614  13.573  1.00 15.12           C  
ATOM    254  OG  SER A  33      18.293  20.906  12.336  1.00 20.01           O  
ATOM    255  N   ASP A  34      17.778  23.673  13.579  1.00 14.49           N  
ATOM    256  CA  ASP A  34      16.631  24.555  13.554  1.00 15.15           C  
ATOM    257  C   ASP A  34      15.340  23.774  13.381  1.00 14.84           C  
ATOM    258  O   ASP A  34      15.275  22.861  12.571  1.00 16.87           O  
ATOM    259  CB  ASP A  34      16.782  25.567  12.405  1.00 15.92           C  
ATOM    260  CG  ASP A  34      17.771  26.705  12.725  1.00 20.66           C  
ATOM    261  OD1 ASP A  34      18.211  26.875  13.883  1.00 23.48           O  
ATOM    262  OD2 ASP A  34      18.073  27.475  11.790  1.00 26.91           O  
ATOM    263  N   ASN A  35      14.315  24.138  14.146  1.00 15.43           N  
ATOM    264  CA  ASN A  35      12.977  23.528  14.006  1.00 15.50           C  
ATOM    265  C   ASN A  35      12.955  22.039  14.318  1.00 14.52           C  
ATOM    266  O   ASN A  35      12.124  21.287  13.790  1.00 15.19           O  
ATOM    267  CB  ASN A  35      12.362  23.789  12.609  1.00 15.91           C  
ATOM    268  CG  ASN A  35      10.827  23.578  12.564  1.00 17.10           C  
ATOM    269  OD1 ASN A  35      10.165  23.596  13.595  1.00 22.56           O  
ATOM    270  ND2 ASN A  35      10.263  23.407  11.352  1.00 17.98           N  
ATOM    271  N   VAL A  36      13.882  21.619  15.183  1.00 12.48           N  
ATOM    272  CA  VAL A  36      13.948  20.264  15.660  1.00 11.20           C  
ATOM    273  C   VAL A  36      13.962  20.182  17.184  1.00  9.08           C  
ATOM    274  O   VAL A  36      14.710  20.912  17.833  1.00  9.48           O  
ATOM    275  CB  VAL A  36      15.240  19.589  15.083  1.00 11.13           C  
ATOM    276  CG1 VAL A  36      15.601  18.291  15.792  1.00 12.82           C  
ATOM    277  CG2 VAL A  36      15.032  19.396  13.593  1.00 14.22           C  
ATOM    278  N   ASP A  37      13.175  19.242  17.706  1.00  8.67           N  
ATOM    279  CA  ASP A  37      13.117  18.973  19.133  1.00  8.83           C  
ATOM    280  C   ASP A  37      13.580  17.610  19.568  1.00  8.65           C  
ATOM    281  O   ASP A  37      13.956  17.449  20.735  1.00  8.84           O  
ATOM    282  CB  ASP A  37      11.691  19.220  19.620  1.00  9.99           C  
ATOM    283  CG  ASP A  37      11.313  20.690  19.489  1.00 12.84           C  
ATOM    284  OD1 ASP A  37      12.046  21.547  20.032  1.00 17.87           O  
ATOM    285  OD2 ASP A  37      10.309  20.966  18.844  1.00 20.35           O  
ATOM    286  N   THR A  38      13.498  16.626  18.669  1.00  7.80           N  
ATOM    287  CA  THR A  38      13.808  15.248  19.059  1.00  7.72           C  
ATOM    288  C   THR A  38      14.882  14.649  18.171  1.00  7.61           C  
ATOM    289  O   THR A  38      15.229  15.189  17.127  1.00  8.86           O  
ATOM    290  CB  THR A  38      12.572  14.311  18.925  1.00  7.93           C  
ATOM    291  OG1 THR A  38      12.192  14.169  17.549  1.00  9.88           O  
ATOM    292  CG2 THR A  38      11.405  14.834  19.711  1.00  8.75           C  
ATOM    293  N   ILE A  39      15.447  13.543  18.628  1.00  6.70           N  
ATOM    294  CA  ILE A  39      16.488  12.851  17.880  1.00  7.08           C  
ATOM    295  C   ILE A  39      15.958  12.363  16.528  1.00  7.43           C  
ATOM    296  O   ILE A  39      16.697  12.458  15.527  1.00  8.03           O  
ATOM    297  CB  ILE A  39      17.147  11.744  18.710  1.00  7.45           C  
ATOM    298  CG1 ILE A  39      18.433  11.251  18.025  1.00  7.53           C  
ATOM    299  CG2 ILE A  39      16.163  10.622  19.069  1.00  8.97           C  
ATOM    300  CD1 ILE A  39      19.481  12.328  17.810  1.00 10.07           C  
ATOM    301  N   ALA A  40      14.708  11.897  16.457  1.00  7.66           N  
ATOM    302  CA  ALA A  40      14.144  11.547  15.126  1.00  7.53           C  
ATOM    303  C   ALA A  40      14.091  12.767  14.209  1.00  7.61           C  
ATOM    304  O   ALA A  40      14.375  12.676  13.006  1.00  9.12           O  
ATOM    305  CB  ALA A  40      12.755  10.911  15.220  1.00  8.93           C  
ATOM    306  N   GLY A  41      13.687  13.906  14.751  1.00  7.37           N  
ATOM    307  CA  GLY A  41      13.625  15.122  13.960  1.00  8.32           C  
ATOM    308  C   GLY A  41      15.003  15.487  13.446  1.00  7.58           C  
ATOM    309  O   GLY A  41      15.161  15.906  12.287  1.00  8.80           O  
ATOM    310  N   PHE A  42      16.008  15.394  14.316  1.00  7.52           N  
ATOM    311  CA  PHE A  42      17.391  15.706  13.923  1.00  8.22           C  
ATOM    312  C   PHE A  42      17.864  14.766  12.798  1.00  7.62           C  
ATOM    313  O   PHE A  42      18.469  15.190  11.786  1.00  7.91           O  
ATOM    314  CB  PHE A  42      18.292  15.599  15.145  1.00  8.94           C  
ATOM    315  CG  PHE A  42      19.736  15.845  14.861  1.00  9.40           C  
ATOM    316  CD1 PHE A  42      20.257  17.106  14.915  1.00  8.59           C  
ATOM    317  CD2 PHE A  42      20.569  14.801  14.557  1.00  9.77           C  
ATOM    318  CE1 PHE A  42      21.574  17.341  14.627  1.00 10.05           C  
ATOM    319  CE2 PHE A  42      21.910  15.008  14.271  1.00  9.62           C  
ATOM    320  CZ  PHE A  42      22.411  16.286  14.301  1.00  9.85           C  
ATOM    321  N   TYR A  43      17.602  13.469  12.983  1.00  7.74           N  
ATOM    322  CA  TYR A  43      18.017  12.464  11.999  1.00  7.89           C  
ATOM    323  C   TYR A  43      17.302  12.693  10.675  1.00  8.58           C  
ATOM    324  O   TYR A  43      17.932  12.714   9.597  1.00  8.68           O  
ATOM    325  CB  TYR A  43      17.697  11.090  12.543  1.00  7.76           C  
ATOM    326  CG  TYR A  43      17.733   9.997  11.535  1.00  7.04           C  
ATOM    327  CD1 TYR A  43      18.915   9.316  11.237  1.00  7.19           C  
ATOM    328  CD2 TYR A  43      16.562   9.551  10.943  1.00  8.44           C  
ATOM    329  CE1 TYR A  43      18.938   8.252  10.324  1.00  7.60           C  
ATOM    330  CE2 TYR A  43      16.584   8.515  10.006  1.00  7.45           C  
ATOM    331  CZ  TYR A  43      17.756   7.846   9.725  1.00  6.70           C  
ATOM    332  OH  TYR A  43      17.721   6.796   8.832  1.00  8.90           O  
ATOM    333  N   LEU A  44      15.996  12.892  10.725  1.00  8.34           N  
ATOM    334  CA  LEU A  44      15.224  13.022   9.461  1.00  9.57           C  
ATOM    335  C   LEU A  44      15.598  14.287   8.679  1.00 10.10           C  
ATOM    336  O   LEU A  44      15.692  14.285   7.424  1.00 10.99           O  
ATOM    337  CB  LEU A  44      13.705  13.018   9.704  1.00  9.71           C  
ATOM    338  CG  LEU A  44      13.153  11.652  10.140  1.00 13.41           C  
ATOM    339  CD1 LEU A  44      11.682  11.807  10.575  1.00 14.57           C  
ATOM    340  CD2 LEU A  44      13.277  10.600   9.029  1.00 15.35           C  
ATOM    341  N   THR A  45      15.807  15.382   9.409  1.00 11.09           N  
ATOM    342  CA  THR A  45      16.226  16.638   8.759  1.00 12.33           C  
ATOM    343  C   THR A  45      17.642  16.494   8.193  1.00 11.78           C  
ATOM    344  O   THR A  45      17.962  17.092   7.146  1.00 12.97           O  
ATOM    345  CB  THR A  45      16.113  17.824   9.709  1.00 14.48           C  
ATOM    346  OG1 THR A  45      16.952  17.600  10.806  1.00 20.31           O  
ATOM    347  CG2 THR A  45      14.753  17.946  10.228  1.00 14.11           C  
ATOM    348  N   GLY A  46      18.482  15.693   8.850  1.00 11.75           N  
ATOM    349  CA  GLY A  46      19.840  15.409   8.360  1.00 13.42           C  
ATOM    350  C   GLY A  46      19.920  14.533   7.127  1.00 14.20           C  
ATOM    351  O   GLY A  46      20.724  14.788   6.232  1.00 15.62           O  
ATOM    352  N   VAL A  47      19.145  13.457   7.076  1.00 14.76           N  
ATOM    353  CA  VAL A  47      19.131  12.585   5.868  1.00 16.44           C  
ATOM    354  C   VAL A  47      18.223  13.104   4.726  1.00 17.58           C  
ATOM    355  O   VAL A  47      18.418  12.773   3.549  1.00 19.90           O  
ATOM    356  CB  VAL A  47      18.691  11.112   6.203  1.00 16.16           C  
ATOM    357  CG1 VAL A  47      19.636  10.495   7.231  1.00 15.18           C  
ATOM    358  CG2 VAL A  47      17.263  11.038   6.707  1.00 15.26           C  
ATOM    359  N   GLY A  48      17.135  13.789   5.072  1.00 19.12           N  
ATOM    360  CA  GLY A  48      16.241  14.370   4.069  1.00 20.14           C  
ATOM    361  C   GLY A  48      15.339  13.415   3.313  1.00 20.87           C  
ATOM    362  O   GLY A  48      14.868  13.751   2.227  1.00 21.95           O  
ATOM    363  N   THR A  49      15.024  12.273   3.922  1.00 21.51           N  
ATOM    364  CA  THR A  49      14.368  11.133   3.258  1.00 21.91           C  
ATOM    365  C   THR A  49      13.650  10.285   4.274  1.00 21.55           C  
ATOM    366  O   THR A  49      14.204  10.045   5.292  1.00 21.81           O  
ATOM    367  CB  THR A  49      15.442  10.217   2.575  1.00 23.41           C  
ATOM    368  OG1 THR A  49      16.344   9.683   3.552  1.00 26.27           O  
ATOM    369  CG2 THR A  49      16.263  11.025   1.601  1.00 24.20           C  
ATOM    370  N   ILE A  50      12.442   9.812   4.012  1.00 18.84           N  
ATOM    371  CA  ILE A  50      11.920   8.774   4.870  1.00 18.97           C  
ATOM    372  C   ILE A  50      12.641   7.454   4.503  1.00 17.59           C  
ATOM    373  O   ILE A  50      12.421   6.939   3.400  1.00 18.48           O  
ATOM    374  CB  ILE A  50      10.374   8.621   4.718  1.00 17.99           C  
ATOM    375  CG1 ILE A  50       9.682   9.960   4.998  1.00 19.99           C  
ATOM    376  CG2 ILE A  50       9.834   7.526   5.682  1.00 18.12           C  
ATOM    377  CD1 ILE A  50      10.075  10.641   6.336  1.00 20.67           C  
ATOM    378  N   PRO A  51      13.546   6.936   5.376  1.00 17.04           N  
ATOM    379  CA  PRO A  51      14.084   5.590   5.102  1.00 16.11           C  
ATOM    380  C   PRO A  51      13.058   4.531   5.328  1.00 17.46           C  
ATOM    381  O   PRO A  51      11.998   4.840   5.845  1.00 17.25           O  
ATOM    382  CB  PRO A  51      15.108   5.387   6.219  1.00 15.65           C  
ATOM    383  CG  PRO A  51      14.582   6.197   7.336  1.00 13.98           C  
ATOM    384  CD  PRO A  51      14.099   7.457   6.637  1.00 16.99           C  
ATOM    385  N   SER A  52      13.449   3.291   5.006  1.00 17.76           N  
ATOM    386  CA  SER A  52      12.755   2.073   5.416  1.00 18.03           C  
ATOM    387  C   SER A  52      13.769   1.019   5.870  1.00 19.14           C  
ATOM    388  O   SER A  52      15.019   1.197   5.756  1.00 18.08           O  
ATOM    389  CB  SER A  52      11.941   1.514   4.249  1.00 18.06           C  
ATOM    390  OG  SER A  52      12.761   1.185   3.146  1.00 17.77           O  
ATOM    391  N   GLN A  53      13.258  -0.101   6.374  1.00 20.49           N  
ATOM    392  CA  GLN A  53      14.147  -1.200   6.728  1.00 21.46           C  
ATOM    393  C   GLN A  53      14.904  -1.707   5.485  1.00 21.16           C  
ATOM    394  O   GLN A  53      16.081  -2.072   5.565  1.00 20.23           O  
ATOM    395  CB  GLN A  53      13.389  -2.331   7.418  1.00 21.99           C  
ATOM    396  CG  GLN A  53      14.299  -3.505   7.724  1.00 23.81           C  
ATOM    397  CD  GLN A  53      13.793  -4.418   8.817  1.00 25.80           C  
ATOM    398  OE1 GLN A  53      12.689  -4.252   9.342  1.00 31.62           O  
ATOM    399  NE2 GLN A  53      14.617  -5.408   9.166  1.00 31.02           N  
ATOM    400  N   GLU A  54      14.242  -1.713   4.331  1.00 21.16           N  
ATOM    401  CA  GLU A  54      14.871  -2.185   3.101  1.00 21.47           C  
ATOM    402  C   GLU A  54      15.927  -1.205   2.613  1.00 21.05           C  
ATOM    403  O   GLU A  54      16.930  -1.612   2.036  1.00 20.32           O  
ATOM    404  CB  GLU A  54      13.819  -2.374   1.998  1.00 22.43           C  
ATOM    405  CG  GLU A  54      12.816  -3.482   2.267  1.00 24.42           C  
ATOM    406  CD  GLU A  54      11.608  -3.072   3.104  1.00 27.37           C  
ATOM    407  OE1 GLU A  54      11.554  -1.925   3.619  1.00 29.18           O  
ATOM    408  OE2 GLU A  54      10.699  -3.927   3.246  1.00 27.84           O  
ATOM    409  N   GLU A  55      15.683   0.081   2.863  1.00 20.27           N  
ATOM    410  CA  GLU A  55      16.482   1.162   2.332  1.00 19.75           C  
ATOM    411  C   GLU A  55      16.846   2.051   3.496  1.00 18.89           C  
ATOM    412  O   GLU A  55      16.261   3.123   3.677  1.00 18.68           O  
ATOM    413  CB  GLU A  55      15.663   1.918   1.282  1.00 19.84           C  
ATOM    414  CG  GLU A  55      15.332   1.012   0.103  1.00 20.13           C  
ATOM    415  CD  GLU A  55      14.415   1.625  -0.945  1.00 20.51           C  
ATOM    416  OE1 GLU A  55      14.127   2.845  -0.860  1.00 23.61           O  
ATOM    417  OE2 GLU A  55      13.977   0.867  -1.841  1.00 19.67           O  
ATOM    418  N   LYS A  56      17.754   1.552   4.340  1.00 16.46           N  
ATOM    419  CA  LYS A  56      18.164   2.288   5.533  1.00 17.15           C  
ATOM    420  C   LYS A  56      18.941   3.505   5.163  1.00 14.64           C  
ATOM    421  O   LYS A  56      19.606   3.560   4.123  1.00 16.59           O  
ATOM    422  CB  LYS A  56      19.026   1.427   6.427  1.00 16.56           C  
ATOM    423  CG  LYS A  56      18.285   0.218   6.949  1.00 19.74           C  
ATOM    424  CD  LYS A  56      19.107  -0.570   7.900  1.00 19.84           C  
ATOM    425  CE  LYS A  56      18.296  -1.724   8.477  1.00 22.31           C  
ATOM    426  NZ  LYS A  56      19.112  -2.697   9.222  1.00 25.95           N  
ATOM    427  N   GLU A  57      18.889   4.478   6.058  1.00 12.52           N  
ATOM    428  CA  GLU A  57      19.640   5.698   5.863  1.00 11.25           C  
ATOM    429  C   GLU A  57      20.536   5.911   7.074  1.00 10.25           C  
ATOM    430  O   GLU A  57      20.110   5.765   8.205  1.00  9.74           O  
ATOM    431  CB  GLU A  57      18.726   6.889   5.637  1.00 11.96           C  
ATOM    432  CG  GLU A  57      17.952   6.822   4.290  1.00 13.69           C  
ATOM    433  CD  GLU A  57      18.806   7.025   3.045  1.00 17.88           C  
ATOM    434  OE1 GLU A  57      19.943   7.510   3.173  1.00 21.26           O  
ATOM    435  OE2 GLU A  57      18.333   6.710   1.925  1.00 19.42           O  
ATOM    436  N   HIS A  58      21.792   6.228   6.799  1.00  9.26           N  
ATOM    437  CA  HIS A  58      22.816   6.445   7.818  1.00  9.61           C  
ATOM    438  C   HIS A  58      23.163   7.917   7.870  1.00 10.50           C  
ATOM    439  O   HIS A  58      23.299   8.545   6.826  1.00 10.62           O  
ATOM    440  CB  HIS A  58      24.068   5.710   7.418  1.00 10.25           C  
ATOM    441  CG  HIS A  58      23.920   4.231   7.388  1.00 11.91           C  
ATOM    442  ND1 HIS A  58      22.982   3.568   6.622  1.00 14.47           N  
ATOM    443  CD2 HIS A  58      24.675   3.271   7.962  1.00 13.98           C  
ATOM    444  CE1 HIS A  58      23.132   2.266   6.773  1.00 13.27           C  
ATOM    445  NE2 HIS A  58      24.159   2.058   7.569  1.00 17.78           N  
ATOM    446  N   PHE A  59      23.281   8.458   9.077  1.00  9.42           N  
ATOM    447  CA  PHE A  59      23.693   9.854   9.241  1.00 10.12           C  
ATOM    448  C   PHE A  59      24.801   9.922  10.258  1.00 10.40           C  
ATOM    449  O   PHE A  59      24.653   9.430  11.358  1.00 11.47           O  
ATOM    450  CB  PHE A  59      22.517  10.720   9.713  1.00 10.98           C  
ATOM    451  CG  PHE A  59      22.760  12.196   9.576  1.00 10.37           C  
ATOM    452  CD1 PHE A  59      23.096  12.734   8.366  1.00 12.44           C  
ATOM    453  CD2 PHE A  59      22.611  13.046  10.650  1.00 16.08           C  
ATOM    454  CE1 PHE A  59      23.293  14.086   8.213  1.00 14.55           C  
ATOM    455  CE2 PHE A  59      22.817  14.427  10.493  1.00 14.64           C  
ATOM    456  CZ  PHE A  59      23.170  14.920   9.290  1.00 13.69           C  
ATOM    457  N   GLU A  60      25.917  10.517   9.874  1.00 10.45           N  
ATOM    458  CA  GLU A  60      27.082  10.559  10.736  1.00 12.33           C  
ATOM    459  C   GLU A  60      27.349  11.998  11.142  1.00 12.13           C  
ATOM    460  O   GLU A  60      27.358  12.917  10.311  1.00 12.27           O  
ATOM    461  CB  GLU A  60      28.293   9.957  10.010  1.00 13.10           C  
ATOM    462  CG  GLU A  60      28.160   8.455   9.866  1.00 16.31           C  
ATOM    463  CD  GLU A  60      29.334   7.808   9.164  1.00 17.93           C  
ATOM    464  OE1 GLU A  60      30.412   7.731   9.769  1.00 24.86           O  
ATOM    465  OE2 GLU A  60      29.174   7.365   8.009  1.00 25.11           O  
ATOM    466  N   VAL A  61      27.555  12.179  12.436  1.00 11.96           N  
ATOM    467  CA  VAL A  61      27.899  13.495  12.950  1.00 13.03           C  
ATOM    468  C   VAL A  61      28.990  13.406  13.993  1.00 12.99           C  
ATOM    469  O   VAL A  61      29.202  12.364  14.581  1.00 13.06           O  
ATOM    470  CB  VAL A  61      26.664  14.227  13.517  1.00 13.78           C  
ATOM    471  CG1 VAL A  61      25.643  14.503  12.419  1.00 15.63           C  
ATOM    472  CG2 VAL A  61      26.047  13.462  14.664  1.00 16.13           C  
ATOM    473  N   GLU A  62      29.697  14.505  14.197  1.00 13.36           N  
ATOM    474  CA  GLU A  62      30.699  14.588  15.243  1.00 14.51           C  
ATOM    475  C   GLU A  62      30.275  15.641  16.251  1.00 13.80           C  
ATOM    476  O   GLU A  62      29.880  16.745  15.872  1.00 13.54           O  
ATOM    477  CB  GLU A  62      32.080  14.953  14.679  1.00 15.00           C  
ATOM    478  CG  GLU A  62      33.128  15.127  15.765  1.00 15.96           C  
ATOM    479  CD  GLU A  62      34.504  15.346  15.190  1.00 19.35           C  
ATOM    480  OE1 GLU A  62      34.620  15.534  13.943  1.00 24.26           O  
ATOM    481  OE2 GLU A  62      35.481  15.321  15.978  1.00 25.83           O  
ATOM    482  N   SER A  63      30.360  15.311  17.535  1.00 12.88           N  
ATOM    483  CA  SER A  63      29.980  16.254  18.577  1.00 13.86           C  
ATOM    484  C   SER A  63      30.764  15.979  19.865  1.00 13.59           C  
ATOM    485  O   SER A  63      30.812  14.841  20.370  1.00 13.55           O  
ATOM    486  CB  SER A  63      28.475  16.176  18.847  1.00 14.20           C  
ATOM    487  OG  SER A  63      28.135  17.012  19.941  1.00 17.76           O  
ATOM    488  N   ASN A  64      31.413  17.023  20.377  1.00 13.29           N  
ATOM    489  CA  ASN A  64      32.132  16.914  21.663  1.00 13.25           C  
ATOM    490  C   ASN A  64      33.113  15.763  21.625  1.00 12.84           C  
ATOM    491  O   ASN A  64      33.300  15.039  22.603  1.00 12.25           O  
ATOM    492  CB  ASN A  64      31.150  16.812  22.837  1.00 13.23           C  
ATOM    493  CG  ASN A  64      30.424  18.126  23.101  1.00 12.79           C  
ATOM    494  OD1 ASN A  64      30.775  19.166  22.525  1.00 14.75           O  
ATOM    495  ND2 ASN A  64      29.411  18.093  23.962  1.00 14.86           N  
ATOM    496  N   GLY A  65      33.747  15.627  20.466  1.00 13.90           N  
ATOM    497  CA  GLY A  65      34.768  14.628  20.254  1.00 13.89           C  
ATOM    498  C   GLY A  65      34.271  13.211  20.067  1.00 14.91           C  
ATOM    499  O   GLY A  65      35.077  12.295  19.906  1.00 16.21           O  
ATOM    500  N   LYS A  66      32.958  13.028  20.092  1.00 14.57           N  
ATOM    501  CA  LYS A  66      32.351  11.733  19.783  1.00 14.80           C  
ATOM    502  C   LYS A  66      31.891  11.723  18.318  1.00 14.12           C  
ATOM    503  O   LYS A  66      31.338  12.727  17.818  1.00 15.61           O  
ATOM    504  CB  LYS A  66      31.131  11.458  20.662  1.00 16.62           C  
ATOM    505  CG  LYS A  66      31.396  11.319  22.172  1.00 20.14           C  
ATOM    506  CD  LYS A  66      30.988  12.657  22.829  1.00 21.44           C  
ATOM    507  CE  LYS A  66      31.397  12.779  24.234  1.00 22.76           C  
ATOM    508  NZ  LYS A  66      31.510  14.167  24.688  1.00 19.16           N  
ATOM    509  N   HIS A  67      32.151  10.618  17.619  0.50 13.93           N  
ATOM    511  CA  HIS A  67      31.553  10.385  16.311  0.50 13.25           C  
ATOM    513  C   HIS A  67      30.334   9.516  16.549  0.50 12.50           C  
ATOM    515  O   HIS A  67      30.423   8.524  17.238  0.50 12.01           O  
ATOM    517  CB  HIS A  67      32.512   9.674  15.356  0.50 14.09           C  
ATOM    519  CG  HIS A  67      31.866   9.213  14.085  0.50 14.69           C  
ATOM    521  ND1 HIS A  67      31.932   9.924  12.904  0.50 17.22           N  
ATOM    523  CD2 HIS A  67      31.147   8.100  13.810  0.50 16.69           C  
ATOM    525  CE1 HIS A  67      31.278   9.267  11.963  0.50 17.42           C  
ATOM    527  NE2 HIS A  67      30.781   8.161  12.490  0.50 17.26           N  
ATOM    529  N   LEU A  68      29.192   9.934  16.013  1.00 11.20           N  
ATOM    530  CA  LEU A  68      27.940   9.191  16.142  1.00 11.46           C  
ATOM    531  C   LEU A  68      27.498   8.775  14.748  1.00 10.77           C  
ATOM    532  O   LEU A  68      27.518   9.580  13.813  1.00 10.77           O  
ATOM    533  CB  LEU A  68      26.855  10.075  16.726  1.00 11.78           C  
ATOM    534  CG  LEU A  68      27.057  10.709  18.100  1.00 15.41           C  
ATOM    535  CD1 LEU A  68      25.822  11.528  18.516  1.00 18.05           C  
ATOM    536  CD2 LEU A  68      27.336   9.674  19.088  1.00 17.86           C  
ATOM    537  N   GLU A  69      27.044   7.533  14.639  1.00  9.75           N  
ATOM    538  CA  GLU A  69      26.379   7.055  13.422  1.00  9.37           C  
ATOM    539  C   GLU A  69      24.937   6.729  13.810  1.00  8.50           C  
ATOM    540  O   GLU A  69      24.705   5.938  14.719  1.00  9.59           O  
ATOM    541  CB  GLU A  69      27.080   5.836  12.814  1.00  9.87           C  
ATOM    542  CG  GLU A  69      26.410   5.352  11.544  1.00 10.47           C  
ATOM    543  CD  GLU A  69      27.076   4.147  10.907  1.00 10.51           C  
ATOM    544  OE1 GLU A  69      27.916   3.521  11.556  1.00 13.82           O  
ATOM    545  OE2 GLU A  69      26.711   3.810   9.764  1.00 16.93           O  
ATOM    546  N   LEU A  70      23.983   7.367  13.138  1.00  8.83           N  
ATOM    547  CA  LEU A  70      22.555   7.188  13.418  1.00  9.83           C  
ATOM    548  C   LEU A  70      21.944   6.413  12.251  1.00  9.34           C  
ATOM    549  O   LEU A  70      22.136   6.792  11.105  1.00  9.32           O  
ATOM    550  CB  LEU A  70      21.856   8.527  13.543  1.00  9.21           C  
ATOM    551  CG  LEU A  70      22.110   9.431  14.739  1.00 11.94           C  
ATOM    552  CD1 LEU A  70      23.551   9.750  14.857  1.00 17.13           C  
ATOM    553  CD2 LEU A  70      21.305  10.707  14.557  1.00 12.23           C  
ATOM    554  N   ILE A  71      21.203   5.354  12.567  1.00  8.90           N  
ATOM    555  CA  ILE A  71      20.583   4.493  11.565  1.00  9.74           C  
ATOM    556  C   ILE A  71      19.157   4.180  11.974  1.00  8.95           C  
ATOM    557  O   ILE A  71      18.899   3.873  13.125  1.00  9.17           O  
ATOM    558  CB  ILE A  71      21.332   3.152  11.398  1.00  9.86           C  
ATOM    559  CG1 ILE A  71      22.847   3.334  11.341  1.00 12.26           C  
ATOM    560  CG2 ILE A  71      20.858   2.456  10.119  1.00 11.11           C  
ATOM    561  CD1 ILE A  71      23.612   1.988  11.293  1.00 12.22           C  
ATOM    562  N   ASN A  72      18.225   4.215  11.029  1.00  8.48           N  
ATOM    563  CA  ASN A  72      16.855   3.850  11.390  1.00  8.96           C  
ATOM    564  C   ASN A  72      16.807   2.405  11.843  1.00  8.42           C  
ATOM    565  O   ASN A  72      17.404   1.519  11.204  1.00  9.12           O  
ATOM    566  CB  ASN A  72      15.881   4.079  10.251  1.00  9.34           C  
ATOM    567  CG  ASN A  72      16.300   3.398   8.981  1.00  8.90           C  
ATOM    568  OD1 ASN A  72      17.341   3.740   8.450  1.00  9.53           O  
ATOM    569  ND2 ASN A  72      15.464   2.486   8.451  1.00  9.13           N  
ATOM    570  N   ASP A  73      16.092   2.177  12.945  1.00  9.27           N  
ATOM    571  CA  ASP A  73      15.801   0.831  13.415  1.00  9.96           C  
ATOM    572  C   ASP A  73      14.328   0.452  13.259  1.00  9.91           C  
ATOM    573  O   ASP A  73      14.009  -0.718  13.082  1.00 12.21           O  
ATOM    574  CB  ASP A  73      16.241   0.692  14.873  1.00 10.20           C  
ATOM    575  CG  ASP A  73      15.912  -0.667  15.468  1.00 14.05           C  
ATOM    576  OD1 ASP A  73      16.604  -1.647  15.146  1.00 18.77           O  
ATOM    577  OD2 ASP A  73      14.954  -0.741  16.287  1.00 20.71           O  
ATOM    578  N   LYS A  74      13.429   1.427  13.334  1.00  9.72           N  
ATOM    579  CA  LYS A  74      12.003   1.158  13.111  1.00 10.49           C  
ATOM    580  C   LYS A  74      11.371   2.421  12.540  1.00 10.21           C  
ATOM    581  O   LYS A  74      11.671   3.519  13.020  1.00 10.62           O  
ATOM    582  CB  LYS A  74      11.308   0.773  14.411  1.00 11.96           C  
ATOM    583  CG  LYS A  74       9.846   0.453  14.294  1.00 15.11           C  
ATOM    584  CD  LYS A  74       9.633  -0.825  13.604  1.00 19.43           C  
ATOM    585  CE  LYS A  74       8.264  -1.436  13.863  1.00 21.09           C  
ATOM    586  NZ  LYS A  74       8.075  -2.682  13.048  1.00 23.66           N  
ATOM    587  N   VAL A  75      10.522   2.254  11.526  1.00 10.40           N  
ATOM    588  CA  VAL A  75       9.787   3.325  10.898  1.00 11.40           C  
ATOM    589  C   VAL A  75       8.304   2.956  10.852  1.00 11.97           C  
ATOM    590  O   VAL A  75       7.951   1.822  10.543  1.00 12.92           O  
ATOM    591  CB  VAL A  75      10.290   3.533   9.464  1.00 11.78           C  
ATOM    592  CG1 VAL A  75       9.486   4.617   8.740  1.00 13.57           C  
ATOM    593  CG2 VAL A  75      11.773   3.887   9.464  1.00 12.64           C  
ATOM    594  N   LYS A  76       7.449   3.931  11.141  1.00 12.16           N  
ATOM    595  CA  LYS A  76       5.988   3.768  11.196  1.00 13.43           C  
ATOM    596  C   LYS A  76       5.363   5.020  10.563  1.00 12.89           C  
ATOM    597  O   LYS A  76       5.619   6.134  11.033  1.00 12.65           O  
ATOM    598  CB  LYS A  76       5.490   3.673  12.643  1.00 14.78           C  
ATOM    599  CG  LYS A  76       6.141   2.663  13.613  1.00 18.84           C  
ATOM    600  CD  LYS A  76       5.417   2.641  15.015  1.00 18.59           C  
ATOM    601  CE  LYS A  76       6.281   1.999  16.123  1.00 21.83           C  
ATOM    602  NZ  LYS A  76       5.673   2.187  17.509  1.00 23.22           N  
ATOM    603  N   ASP A  77       4.565   4.874   9.503  1.00 12.05           N  
ATOM    604  CA  ASP A  77       3.850   6.012   8.909  1.00 13.12           C  
ATOM    605  C   ASP A  77       4.743   7.212   8.603  1.00 13.98           C  
ATOM    606  O   ASP A  77       4.380   8.341   8.892  1.00 14.43           O  
ATOM    607  CB  ASP A  77       2.748   6.487   9.867  1.00 11.68           C  
ATOM    608  CG  ASP A  77       1.739   7.404   9.189  1.00 11.00           C  
ATOM    609  OD1 ASP A  77       1.359   7.123   8.036  1.00  9.34           O  
ATOM    610  OD2 ASP A  77       1.301   8.373   9.827  1.00 11.01           O  
ATOM    611  N   GLY A  78       5.938   6.956   8.094  1.00 16.47           N  
ATOM    612  CA  GLY A  78       6.888   8.054   7.842  1.00 17.00           C  
ATOM    613  C   GLY A  78       7.627   8.590   9.058  1.00 18.04           C  
ATOM    614  O   GLY A  78       8.439   9.538   8.961  1.00 21.71           O  
ATOM    615  N   ARG A  79       7.348   8.036  10.232  0.50 16.88           N  
ATOM    617  CA  ARG A  79       8.056   8.473  11.430  0.50 15.78           C  
ATOM    619  C   ARG A  79       9.153   7.455  11.728  0.50 14.84           C  
ATOM    621  O   ARG A  79       8.887   6.270  11.778  0.50 13.18           O  
ATOM    623  CB  ARG A  79       7.100   8.594  12.624  0.50 16.01           C  
ATOM    625  CG  ARG A  79       7.605   9.533  13.715  0.50 17.06           C  
ATOM    627  CD  ARG A  79       7.822  10.956  13.209  0.50 17.39           C  
ATOM    629  NE  ARG A  79       8.608  11.749  14.158  0.50 14.67           N  
ATOM    631  CZ  ARG A  79       9.201  12.917  13.898  0.50 13.74           C  
ATOM    633  NH1 ARG A  79       9.173  13.461  12.685  0.50 13.53           N  
ATOM    635  NH2 ARG A  79       9.837  13.551  14.860  0.50 14.33           N  
ATOM    637  N   VAL A  80      10.390   7.913  11.927  1.00 14.58           N  
ATOM    638  CA  VAL A  80      11.401   7.044  12.512  1.00 13.98           C  
ATOM    639  C   VAL A  80      11.092   7.001  13.992  1.00 13.48           C  
ATOM    640  O   VAL A  80      11.239   7.994  14.712  1.00 15.06           O  
ATOM    641  CB  VAL A  80      12.805   7.583  12.274  1.00 13.37           C  
ATOM    642  CG1 VAL A  80      13.823   6.561  12.742  1.00 14.70           C  
ATOM    643  CG2 VAL A  80      12.985   7.877  10.786  1.00 17.08           C  
ATOM    644  N   THR A  81      10.703   5.840  14.477  1.00 11.61           N  
ATOM    645  CA  THR A  81      10.320   5.679  15.881  1.00 11.54           C  
ATOM    646  C   THR A  81      11.437   5.091  16.772  1.00 10.40           C  
ATOM    647  O   THR A  81      11.384   5.245  18.003  1.00 10.05           O  
ATOM    648  CB  THR A  81       9.068   4.830  15.987  1.00 12.04           C  
ATOM    649  OG1 THR A  81       9.340   3.550  15.441  1.00 12.89           O  
ATOM    650  CG2 THR A  81       7.942   5.472  15.211  1.00 12.20           C  
ATOM    651  N   LYS A  82      12.414   4.416  16.170  1.00 10.70           N  
ATOM    652  CA  LYS A  82      13.591   3.905  16.876  1.00 10.85           C  
ATOM    653  C   LYS A  82      14.804   4.079  16.011  1.00  9.73           C  
ATOM    654  O   LYS A  82      14.738   3.878  14.797  1.00  9.68           O  
ATOM    655  CB  LYS A  82      13.461   2.439  17.249  1.00 11.64           C  
ATOM    656  CG  LYS A  82      12.397   2.142  18.284  1.00 13.95           C  
ATOM    657  CD  LYS A  82      12.456   0.702  18.820  1.00 15.71           C  
ATOM    658  CE  LYS A  82      11.310   0.449  19.834  1.00 17.24           C  
ATOM    659  NZ  LYS A  82      11.207  -0.971  20.315  1.00 20.83           N  
ATOM    660  N   LEU A  83      15.900   4.482  16.648  1.00  8.63           N  
ATOM    661  CA  LEU A  83      17.185   4.649  15.987  1.00  9.90           C  
ATOM    662  C   LEU A  83      18.238   3.801  16.673  1.00  9.10           C  
ATOM    663  O   LEU A  83      18.236   3.678  17.894  1.00  9.89           O  
ATOM    664  CB  LEU A  83      17.648   6.097  16.061  1.00 10.08           C  
ATOM    665  CG  LEU A  83      17.016   7.135  15.148  1.00 11.03           C  
ATOM    666  CD1 LEU A  83      17.437   8.538  15.622  1.00 17.32           C  
ATOM    667  CD2 LEU A  83      17.488   6.931  13.699  1.00 17.39           C  
ATOM    668  N   LYS A  84      19.163   3.267  15.882  1.00  9.16           N  
ATOM    669  CA  LYS A  84      20.398   2.689  16.369  1.00 10.55           C  
ATOM    670  C   LYS A  84      21.477   3.767  16.365  1.00  9.78           C  
ATOM    671  O   LYS A  84      21.624   4.474  15.376  1.00 10.46           O  
ATOM    672  CB  LYS A  84      20.830   1.550  15.468  1.00 11.67           C  
ATOM    673  CG  LYS A  84      21.986   0.734  15.997  1.00 13.03           C  
ATOM    674  CD  LYS A  84      22.330  -0.376  15.007  1.00 14.33           C  
ATOM    675  CE  LYS A  84      23.134  -1.446  15.637  1.00 18.84           C  
ATOM    676  NZ  LYS A  84      23.213  -2.631  14.718  1.00 22.90           N  
ATOM    677  N   ILE A  85      22.205   3.894  17.469  1.00  9.58           N  
ATOM    678  CA  ILE A  85      23.285   4.884  17.612  1.00 10.15           C  
ATOM    679  C   ILE A  85      24.554   4.124  17.890  1.00 10.74           C  
ATOM    680  O   ILE A  85      24.615   3.355  18.833  1.00 11.10           O  
ATOM    681  CB  ILE A  85      23.039   5.833  18.810  1.00  9.86           C  
ATOM    682  CG1 ILE A  85      21.612   6.365  18.763  1.00 11.44           C  
ATOM    683  CG2 ILE A  85      24.097   6.959  18.854  1.00 12.05           C  
ATOM    684  CD1 ILE A  85      21.267   7.281  17.629  1.00 11.98           C  
ATOM    685  N   LEU A  86      25.561   4.337  17.051  1.00 11.05           N  
ATOM    686  CA  LEU A  86      26.886   3.759  17.287  1.00 11.71           C  
ATOM    687  C   LEU A  86      27.844   4.889  17.612  1.00 12.33           C  
ATOM    688  O   LEU A  86      27.933   5.880  16.851  1.00 11.50           O  
ATOM    689  CB  LEU A  86      27.365   3.039  16.030  1.00 11.91           C  
ATOM    690  CG  LEU A  86      26.533   1.863  15.486  1.00 15.47           C  
ATOM    691  CD1 LEU A  86      25.803   1.136  16.560  1.00 18.77           C  
ATOM    692  CD2 LEU A  86      25.607   2.283  14.404  1.00 17.69           C  
ATOM    693  N   VAL A  87      28.540   4.759  18.743  1.00 13.11           N  
ATOM    694  CA  VAL A  87      29.433   5.814  19.207  1.00 14.74           C  
ATOM    695  C   VAL A  87      30.891   5.431  18.981  1.00 15.65           C  
ATOM    696  O   VAL A  87      31.308   4.300  19.291  1.00 16.87           O  
ATOM    697  CB  VAL A  87      29.211   6.140  20.699  1.00 14.79           C  
ATOM    698  CG1 VAL A  87      30.080   7.317  21.122  1.00 17.06           C  
ATOM    699  CG2 VAL A  87      27.720   6.481  20.969  1.00 14.31           C  
ATOM    700  N   SER A  88      31.621   6.400  18.427  1.00 16.28           N  
ATOM    701  CA  SER A  88      32.983   6.308  17.887  1.00 18.80           C  
ATOM    702  C   SER A  88      33.438   5.004  17.335  1.00 21.00           C  
ATOM    703  O   SER A  88      32.840   4.581  16.342  1.00 24.72           O  
ATOM    704  CB  SER A  88      33.955   7.031  18.790  1.00 19.19           C  
ATOM    705  OG  SER A  88      33.536   8.374  18.786  1.00 16.83           O  
TER     706      SER A  88                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
