
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   84 (  656),  selected   84 , name 2pli_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2pli_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     5_A      -       -           -
LGA    A     6_A      -       -           -
LGA    D     7_A      D       5          4.465
LGA    N     8_A      E       6          1.011
LGA    I     9_A      I       7          1.594
LGA    H    10_A      V       8          0.850
LGA    A    11_A      Q       9          0.565
LGA    V    12_A      R      10          1.579
LGA    S    13_A      E      11          1.849
LGA    S    14_A      D      12          5.123
LGA    E    15_A      G      13          1.171
LGA    R    16_A      S      14          0.848
LGA    W    17_A      W      15          0.399
LGA    R    18_A      L      16          0.424
LGA    I    19_A      V      17          0.244
LGA    H    20_A      D      18          0.505
LGA    A    21_A      G      19          0.518
LGA    A    22_A      M      20          0.459
LGA    T    23_A      V      21          0.463
LGA    E    24_A      S      22          0.599
LGA    I    25_A      L      23          0.710
LGA    E    26_A      D      24          1.031
LGA    D    27_A      R      25          0.941
LGA    I    28_A      F      26          1.005
LGA    N    29_A      R      27          0.851
LGA    T    30_A      E      28          1.257
LGA    F    31_A      F      29          1.269
LGA    F    32_A      F      30          0.820
LGA    G    33_A      E      31          0.834
LGA    T    34_A      L      32          1.047
LGA    E    35_A      E      33          3.371
LGA    -       -      A      34           -
LGA    Y    36_A      P      35          2.339
LGA    S    37_A      L      36          4.741
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    S    38_A      E      39          1.061
LGA    -       -      A      40           -
LGA    E    39_A      G      41          2.044
LGA    -       -      G      42           -
LGA    E    40_A      N      43          2.647
LGA    A    41_A      I      44          1.158
LGA    D    42_A      H      45          0.473
LGA    T    43_A      T      46          0.485
LGA    I    44_A      L      47          0.794
LGA    G    45_A      A      48          0.964
LGA    G    46_A      G      49          0.546
LGA    L    47_A      V      50          0.645
LGA    V    48_A      M      51          1.326
LGA    I    49_A      L      52          1.084
LGA    Q    50_A      Y      53          0.614
LGA    E    51_A      Q      54          1.214
LGA    L    52_A      L      55          1.412
LGA    G    53_A      G      56          2.660
LGA    H    54_A      R      57          2.669
LGA    L    55_A      V      58          2.280
LGA    P    56_A      P      59          0.684
LGA    V    57_A      S      60          1.382
LGA    R    58_A      V      61          0.969
LGA    G    59_A      T      62          0.935
LGA    E    60_A      D      63          0.748
LGA    K    61_A      R      64          0.555
LGA    V    62_A      F      65          1.582
LGA    L    63_A      E      66          1.490
LGA    I    64_A      W      67          2.166
LGA    G    65_A      N      68          1.849
LGA    G    66_A      G      69          1.529
LGA    L    67_A      F      70          0.895
LGA    Q    68_A      S      71          0.429
LGA    F    69_A      F      72          0.757
LGA    T    70_A      E      73          0.716
LGA    V    71_A      V      74          0.574
LGA    A    72_A      V      75          1.040
LGA    R    73_A      D      76          0.686
LGA    A    74_A      M      77          0.549
LGA    D    75_A      D      78          3.358
LGA    N    76_A      R      79          3.034
LGA    R    77_A      T      80          1.952
LGA    R    78_A      R      81          0.800
LGA    L    79_A      V      82          0.578
LGA    H    80_A      D      83          0.432
LGA    T    81_A      K      84          0.355
LGA    L    82_A      I      85          0.436
LGA    X    83_A      L      86          0.651
LGA    A    84_A      V      87          1.128
LGA    T    85_A      Q      88          1.309
LGA    R    86_A      R      89          1.842
LGA    V    87_A      H      90          3.430
LGA    K    88_A      H      91           #

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   84   87    5.0     81    1.65    20.99     87.220     4.624

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.274204 * X  +  -0.071759 * Y  +  -0.958991 * Z  +  22.505228
  Y_new =   0.304609 * X  +  -0.939384 * Y  +   0.157389 * Z  +  -1.884119
  Z_new =  -0.912155 * X  +  -0.335273 * Y  +  -0.235724 * Z  +  54.255177 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.183586    0.958006  [ DEG:  -125.1103     54.8897 ]
  Theta =   1.148511    1.993082  [ DEG:    65.8048    114.1952 ]
  Phi   =   0.837880   -2.303713  [ DEG:    48.0070   -131.9930 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pli_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pli_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   84   87   5.0   81   1.65   20.99  87.220
REMARK  ---------------------------------------------------------- 
MOLECULE 2pli_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-APR-07   2PLI              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE MG2+ AND CO2+                           
TITLE    2 TRANSPORTER(CORC)ASSOCIATED REGION FROM NEISSERIA                    
TITLE    3 MENINGITIDIS MC58                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: RESIDUES 187-274;                                          
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS MC58;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MC58;                                                        
SOURCE   5 GENE: NMB0537;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    CORC-ASSOCIATED REGION, MCSG, PSI2, STRUCTURAL GENOMICS,              
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,E.DUGGAN,M.GU,A.JOACHIMIAK,MIDWEST CENTER FOR                 
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   22-MAY-07 2PLI    0                                                
JRNL        AUTH   B.NOCEK,E.DUGGAN,M.GU,A.JOACHIMIAK                           
JRNL        TITL   STRUCTURE OF PUTATIVE MG2+ AND CO2+                          
JRNL        TITL 2 TRANSPORTER(CORC)ASSOCIATED REGION FROM NEISSERIA            
JRNL        TITL 3 MENINGITIDIS MC58.                                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2PLI A    1    88  UNP    Q9K0P8   Q9K0P8_NEIMB   187    274             
DBREF  2PLI B    1    88  UNP    Q9K0P8   Q9K0P8_NEIMB   187    274             
DBREF  2PLI C    1    88  UNP    Q9K0P8   Q9K0P8_NEIMB   187    274             
DBREF  2PLI D    1    88  UNP    Q9K0P8   Q9K0P8_NEIMB   187    274             
SEQRES   1 A   91  SER ASN ALA ASP GLU ASP ASP SER ALA ASP ASN ILE HIS          
SEQRES   2 A   91  ALA VAL SER SER GLU ARG TRP ARG ILE HIS ALA ALA THR          
SEQRES   3 A   91  GLU ILE GLU ASP ILE ASN THR PHE PHE GLY THR GLU TYR          
SEQRES   4 A   91  SER SER GLU GLU ALA ASP THR ILE GLY GLY LEU VAL ILE          
SEQRES   5 A   91  GLN GLU LEU GLY HIS LEU PRO VAL ARG GLY GLU LYS VAL          
SEQRES   6 A   91  LEU ILE GLY GLY LEU GLN PHE THR VAL ALA ARG ALA ASP          
SEQRES   7 A   91  ASN ARG ARG LEU HIS THR LEU MSE ALA THR ARG VAL LYS          
SEQRES   1 B   91  SER ASN ALA ASP GLU ASP ASP SER ALA ASP ASN ILE HIS          
SEQRES   2 B   91  ALA VAL SER SER GLU ARG TRP ARG ILE HIS ALA ALA THR          
SEQRES   3 B   91  GLU ILE GLU ASP ILE ASN THR PHE PHE GLY THR GLU TYR          
SEQRES   4 B   91  SER SER GLU GLU ALA ASP THR ILE GLY GLY LEU VAL ILE          
SEQRES   5 B   91  GLN GLU LEU GLY HIS LEU PRO VAL ARG GLY GLU LYS VAL          
SEQRES   6 B   91  LEU ILE GLY GLY LEU GLN PHE THR VAL ALA ARG ALA ASP          
SEQRES   7 B   91  ASN ARG ARG LEU HIS THR LEU MSE ALA THR ARG VAL LYS          
SEQRES   1 C   91  SER ASN ALA ASP GLU ASP ASP SER ALA ASP ASN ILE HIS          
SEQRES   2 C   91  ALA VAL SER SER GLU ARG TRP ARG ILE HIS ALA ALA THR          
SEQRES   3 C   91  GLU ILE GLU ASP ILE ASN THR PHE PHE GLY THR GLU TYR          
SEQRES   4 C   91  SER SER GLU GLU ALA ASP THR ILE GLY GLY LEU VAL ILE          
SEQRES   5 C   91  GLN GLU LEU GLY HIS LEU PRO VAL ARG GLY GLU LYS VAL          
SEQRES   6 C   91  LEU ILE GLY GLY LEU GLN PHE THR VAL ALA ARG ALA ASP          
SEQRES   7 C   91  ASN ARG ARG LEU HIS THR LEU MSE ALA THR ARG VAL LYS          
SEQRES   1 D   91  SER ASN ALA ASP GLU ASP ASP SER ALA ASP ASN ILE HIS          
SEQRES   2 D   91  ALA VAL SER SER GLU ARG TRP ARG ILE HIS ALA ALA THR          
SEQRES   3 D   91  GLU ILE GLU ASP ILE ASN THR PHE PHE GLY THR GLU TYR          
SEQRES   4 D   91  SER SER GLU GLU ALA ASP THR ILE GLY GLY LEU VAL ILE          
SEQRES   5 D   91  GLN GLU LEU GLY HIS LEU PRO VAL ARG GLY GLU LYS VAL          
SEQRES   6 D   91  LEU ILE GLY GLY LEU GLN PHE THR VAL ALA ARG ALA ASP          
SEQRES   7 D   91  ASN ARG ARG LEU HIS THR LEU MSE ALA THR ARG VAL LYS          
HET    MSE  A  83       8                                                       
HET    MSE  B  83       8                                                       
HET    MSE  C  83       8                                                       
HET    MSE  D  83       8                                                       
HET    ACT  B 801       4                                                       
HET    ACT  B 802       4                                                       
HET    ACT  C 801       4                                                       
HET    ACT  C 803       4                                                       
HET     ZN    701       1                                                       
HET     ZN    702       1                                                       
HET     ZN    703       1                                                       
HET     ZN    704       1                                                       
HET     ZN    705       1                                                       
HET     ZN    706       1                                                       
HET     ZN    707       1                                                       
HET     ZN    708       1                                                       
HET     ZN    709       1                                                       
HET     ZN    710       1                                                       
HET     ZN    711       1                                                       
HET     ZN    712       1                                                       
HET     ZN    713       1                                                       
HET    ACT    801       4                                                       
HET    ACT    802       4                                                       
HET    GOL  A  89       6                                                       
HET    GOL  A  90       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACT ACETATE ION                                                      
HETNAM      ZN ZINC ION                                                         
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   5  ACT    6(C2 H3 O2 1-)                                               
FORMUL   9   ZN    13(ZN 2+)                                                    
FORMUL  24  GOL    2(C3 H8 O3)                                                  
FORMUL  26  HOH   *455(H2 O)                                                    
CRYST1   53.718   67.991  129.044  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   SER A   5      13.014  -2.592  27.637  1.00 17.53           N  
ATOM      2  CA  SER A   5      13.173  -1.813  28.914  1.00 17.15           C  
ATOM      3  C   SER A   5      12.471  -0.478  28.753  1.00 16.74           C  
ATOM      4  O   SER A   5      11.924  -0.197  27.695  1.00 17.40           O  
ATOM      5  CB  SER A   5      14.663  -1.626  29.267  1.00 18.28           C  
ATOM      6  OG  SER A   5      15.194  -0.400  28.782  1.00 18.91           O  
ATOM      7  N   ALA A   6      12.498   0.362  29.783  1.00 15.16           N  
ATOM      8  CA  ALA A   6      11.808   1.665  29.702  1.00 14.52           C  
ATOM      9  C   ALA A   6      12.770   2.798  29.304  1.00 13.01           C  
ATOM     10  O   ALA A   6      12.367   3.939  29.223  1.00 14.29           O  
ATOM     11  CB  ALA A   6      11.136   1.984  30.997  1.00 14.01           C  
ATOM     12  N   ASP A   7      14.019   2.456  29.015  1.00 12.22           N  
ATOM     13  CA  ASP A   7      15.052   3.435  28.670  1.00 11.32           C  
ATOM     14  C   ASP A   7      14.732   4.057  27.303  1.00 10.29           C  
ATOM     15  O   ASP A   7      14.627   3.313  26.314  1.00 11.25           O  
ATOM     16  CB  ASP A   7      16.421   2.730  28.497  1.00 11.32           C  
ATOM     17  CG  ASP A   7      16.915   1.975  29.728  1.00 12.43           C  
ATOM     18  OD1 ASP A   7      16.276   2.012  30.783  1.00  4.74           O  
ATOM     19  OD2 ASP A   7      17.969   1.295  29.613  1.00 13.93           O  
ATOM     20  N   ASN A   8      14.672   5.389  27.192  1.00  8.38           N  
ATOM     21  CA  ASN A   8      14.551   5.950  25.844  1.00  7.92           C  
ATOM     22  C   ASN A   8      15.870   5.779  25.088  1.00  6.38           C  
ATOM     23  O   ASN A   8      15.868   5.738  23.893  1.00  4.70           O  
ATOM     24  CB  ASN A   8      14.082   7.391  25.795  1.00  8.36           C  
ATOM     25  CG  ASN A   8      14.808   8.313  26.700  1.00 13.53           C  
ATOM     26  OD1 ASN A   8      15.946   8.066  27.133  1.00 22.85           O  
ATOM     27  ND2 ASN A   8      14.119   9.451  27.040  1.00 20.89           N  
ATOM     28  N   ILE A   9      16.977   5.714  25.828  1.00  6.77           N  
ATOM     29  CA  ILE A   9      18.304   5.441  25.268  1.00  6.64           C  
ATOM     30  C   ILE A   9      18.809   4.199  25.959  1.00  7.62           C  
ATOM     31  O   ILE A   9      19.238   4.288  27.112  1.00  8.21           O  
ATOM     32  CB  ILE A   9      19.309   6.606  25.493  1.00  7.40           C  
ATOM     33  CG1 ILE A   9      18.784   7.937  24.960  1.00  6.04           C  
ATOM     34  CG2 ILE A   9      20.670   6.283  24.852  1.00  8.56           C  
ATOM     35  CD1 ILE A   9      19.665   9.140  25.263  1.00  4.09           C  
ATOM     36  N   HIS A  10      18.736   3.060  25.280  1.00  5.63           N  
ATOM     37  CA  HIS A  10      18.944   1.759  25.920  1.00  4.86           C  
ATOM     38  C   HIS A  10      20.222   1.151  25.451  1.00  3.07           C  
ATOM     39  O   HIS A  10      20.378   0.915  24.275  1.00  2.97           O  
ATOM     40  CB  HIS A  10      17.816   0.843  25.547  1.00  5.54           C  
ATOM     41  CG  HIS A  10      17.918  -0.482  26.195  1.00  6.42           C  
ATOM     42  ND1 HIS A  10      17.987  -0.625  27.569  1.00  9.35           N  
ATOM     43  CD2 HIS A  10      17.963  -1.722  25.669  1.00 10.76           C  
ATOM     44  CE1 HIS A  10      18.113  -1.913  27.851  1.00 10.85           C  
ATOM     45  NE2 HIS A  10      18.101  -2.590  26.714  1.00  6.61           N  
ATOM     46  N   ALA A  11      21.147   0.887  26.350  1.00  3.29           N  
ATOM     47  CA  ALA A  11      22.383   0.262  25.927  1.00  4.05           C  
ATOM     48  C   ALA A  11      22.126  -1.222  25.712  1.00  4.24           C  
ATOM     49  O   ALA A  11      21.880  -1.934  26.683  1.00  6.38           O  
ATOM     50  CB  ALA A  11      23.475   0.458  26.975  1.00  3.56           C  
ATOM     51  N   VAL A  12      22.248  -1.686  24.481  1.00  5.65           N  
ATOM     52  CA  VAL A  12      22.088  -3.090  24.182  1.00  5.75           C  
ATOM     53  C   VAL A  12      23.365  -3.859  24.491  1.00  6.03           C  
ATOM     54  O   VAL A  12      23.344  -5.093  24.705  1.00  6.76           O  
ATOM     55  CB  VAL A  12      21.629  -3.320  22.729  1.00  7.06           C  
ATOM     56  CG1 VAL A  12      20.270  -2.653  22.481  1.00  6.12           C  
ATOM     57  CG2 VAL A  12      22.622  -2.819  21.738  1.00  7.61           C  
ATOM     58  N   SER A  13      24.472  -3.120  24.419  1.00  6.34           N  
ATOM     59  CA  SER A  13      25.784  -3.481  24.938  1.00  6.54           C  
ATOM     60  C   SER A  13      26.537  -2.212  25.308  1.00  6.61           C  
ATOM     61  O   SER A  13      26.035  -1.079  25.128  1.00  6.16           O  
ATOM     62  CB  SER A  13      26.541  -4.287  23.898  1.00  6.86           C  
ATOM     63  OG  SER A  13      26.774  -3.523  22.728  1.00  7.91           O  
ATOM     64  N   SER A  14      27.746  -2.352  25.835  1.00  5.57           N  
ATOM     65  CA  SER A  14      28.396  -1.168  26.382  1.00  6.09           C  
ATOM     66  C   SER A  14      28.576  -0.046  25.366  1.00  6.57           C  
ATOM     67  O   SER A  14      28.563   1.122  25.759  1.00  7.63           O  
ATOM     68  CB  SER A  14      29.719  -1.504  27.072  1.00  5.60           C  
ATOM     69  OG  SER A  14      30.701  -1.879  26.129  1.00  6.09           O  
ATOM     70  N   GLU A  15      28.754  -0.387  24.077  1.00  6.17           N  
ATOM     71  CA  GLU A  15      28.969   0.626  23.044  1.00  6.31           C  
ATOM     72  C   GLU A  15      27.943   0.700  21.897  1.00  5.13           C  
ATOM     73  O   GLU A  15      28.246   1.188  20.812  1.00  3.98           O  
ATOM     74  CB  GLU A  15      30.389   0.554  22.498  1.00  8.38           C  
ATOM     75  CG  GLU A  15      31.463   1.009  23.508  1.00 12.71           C  
ATOM     76  CD  GLU A  15      31.370   2.514  23.850  1.00 19.70           C  
ATOM     77  OE1 GLU A  15      31.453   3.381  22.909  1.00 19.36           O  
ATOM     78  OE2 GLU A  15      31.174   2.820  25.063  1.00 24.38           O  
ATOM     79  N   ARG A  16      26.714   0.307  22.173  1.00  5.44           N  
ATOM     80  CA  ARG A  16      25.661   0.357  21.163  1.00  5.67           C  
ATOM     81  C   ARG A  16      24.350   0.611  21.867  1.00  4.57           C  
ATOM     82  O   ARG A  16      24.082   0.021  22.897  1.00  4.75           O  
ATOM     83  CB  ARG A  16      25.612  -0.977  20.444  1.00  8.71           C  
ATOM     84  CG  ARG A  16      24.960  -0.925  19.141  1.00 11.42           C  
ATOM     85  CD  ARG A  16      25.707  -1.919  18.230  1.00 11.93           C  
ATOM     86  NE  ARG A  16      24.898  -2.190  17.089  1.00 16.70           N  
ATOM     87  CZ  ARG A  16      24.048  -3.193  16.987  1.00 12.89           C  
ATOM     88  NH1 ARG A  16      23.936  -4.133  17.920  1.00 14.24           N  
ATOM     89  NH2 ARG A  16      23.357  -3.258  15.898  1.00 12.17           N  
ATOM     90  N   TRP A  17      23.552   1.505  21.298  1.00  2.96           N  
ATOM     91  CA  TRP A  17      22.349   1.972  21.936  1.00  2.66           C  
ATOM     92  C   TRP A  17      21.136   1.941  21.023  1.00  3.29           C  
ATOM     93  O   TRP A  17      21.196   2.421  19.885  1.00  4.21           O  
ATOM     94  CB  TRP A  17      22.552   3.423  22.417  1.00  3.40           C  
ATOM     95  CG  TRP A  17      23.735   3.564  23.283  1.00  2.11           C  
ATOM     96  CD1 TRP A  17      23.775   3.392  24.627  1.00  3.16           C  
ATOM     97  CD2 TRP A  17      25.076   3.876  22.880  1.00  3.17           C  
ATOM     98  NE1 TRP A  17      25.056   3.555  25.097  1.00  3.74           N  
ATOM     99  CE2 TRP A  17      25.879   3.830  24.040  1.00  3.27           C  
ATOM    100  CE3 TRP A  17      25.690   4.175  21.657  1.00  2.00           C  
ATOM    101  CZ2 TRP A  17      27.248   4.084  24.010  1.00  4.20           C  
ATOM    102  CZ3 TRP A  17      27.085   4.408  21.635  1.00  2.75           C  
ATOM    103  CH2 TRP A  17      27.825   4.369  22.801  1.00  3.46           C  
ATOM    104  N   ARG A  18      20.020   1.437  21.534  1.00  2.00           N  
ATOM    105  CA  ARG A  18      18.775   1.520  20.804  1.00  3.37           C  
ATOM    106  C   ARG A  18      18.033   2.730  21.329  1.00  2.38           C  
ATOM    107  O   ARG A  18      17.842   2.846  22.560  1.00  3.03           O  
ATOM    108  CB  ARG A  18      17.939   0.264  21.002  1.00  3.49           C  
ATOM    109  CG  ARG A  18      16.694   0.308  20.103  1.00  6.42           C  
ATOM    110  CD  ARG A  18      15.803  -0.926  20.301  1.00  9.08           C  
ATOM    111  NE  ARG A  18      16.493  -2.170  20.056  1.00 15.43           N  
ATOM    112  CZ  ARG A  18      16.819  -3.059  21.000  1.00 18.52           C  
ATOM    113  NH1 ARG A  18      16.519  -2.852  22.291  1.00 19.80           N  
ATOM    114  NH2 ARG A  18      17.460  -4.160  20.655  1.00 18.06           N  
ATOM    115  N   ILE A  19      17.645   3.636  20.433  1.00  2.07           N  
ATOM    116  CA  ILE A  19      17.122   4.934  20.871  1.00  2.17           C  
ATOM    117  C   ILE A  19      15.720   5.201  20.299  1.00  2.09           C  
ATOM    118  O   ILE A  19      15.509   5.124  19.087  1.00  2.00           O  
ATOM    119  CB  ILE A  19      18.080   6.082  20.405  1.00  2.40           C  
ATOM    120  CG1 ILE A  19      19.495   5.868  20.946  1.00  4.22           C  
ATOM    121  CG2 ILE A  19      17.555   7.463  20.848  1.00  2.15           C  
ATOM    122  CD1 ILE A  19      20.512   6.941  20.552  1.00  3.73           C  
ATOM    123  N   HIS A  20      14.788   5.537  21.186  0.50  2.00           N  
ATOM    125  CA  HIS A  20      13.454   5.960  20.788  0.50  2.21           C  
ATOM    127  C   HIS A  20      13.608   7.252  20.023  0.50  2.00           C  
ATOM    129  O   HIS A  20      14.220   8.194  20.493  0.50  2.00           O  
ATOM    131  CB  HIS A  20      12.553   6.207  21.996  0.50  2.00           C  
ATOM    133  CG  HIS A  20      12.154   4.970  22.726  0.50  2.00           C  
ATOM    135  ND1 HIS A  20      11.101   4.947  23.619  0.50  5.22           N  
ATOM    137  CD2 HIS A  20      12.681   3.725  22.733  0.50  3.84           C  
ATOM    139  CE1 HIS A  20      10.993   3.734  24.129  0.50  2.51           C  
ATOM    141  NE2 HIS A  20      11.932   2.976  23.605  0.50  4.91           N  
ATOM    143  N   ALA A  21      12.998   7.318  18.850  1.00  2.25           N  
ATOM    144  CA  ALA A  21      13.103   8.531  18.051  1.00  2.60           C  
ATOM    145  C   ALA A  21      12.574   9.806  18.706  1.00  2.90           C  
ATOM    146  O   ALA A  21      12.984  10.915  18.321  1.00  4.80           O  
ATOM    147  CB  ALA A  21      12.424   8.326  16.694  1.00  3.94           C  
ATOM    148  N   ALA A  22      11.627   9.633  19.609  1.00  2.01           N  
ATOM    149  CA  ALA A  22      11.001  10.756  20.288  1.00  3.41           C  
ATOM    150  C   ALA A  22      11.857  11.353  21.420  1.00  2.89           C  
ATOM    151  O   ALA A  22      11.501  12.418  21.974  1.00  4.45           O  
ATOM    152  CB  ALA A  22       9.651  10.319  20.779  1.00  4.83           C  
ATOM    153  N   THR A  23      13.038  10.766  21.659  1.00  3.10           N  
ATOM    154  CA  THR A  23      13.975  11.258  22.689  1.00  3.32           C  
ATOM    155  C   THR A  23      14.386  12.709  22.346  1.00  3.15           C  
ATOM    156  O   THR A  23      14.736  13.018  21.215  1.00  3.07           O  
ATOM    157  CB  THR A  23      15.213  10.395  22.795  1.00  3.42           C  
ATOM    158  OG1 THR A  23      14.848   9.041  23.065  1.00  2.00           O  
ATOM    159  CG2 THR A  23      16.120  10.935  23.905  1.00  4.71           C  
ATOM    160  N   GLU A  24      14.284  13.591  23.326  1.00  4.01           N  
ATOM    161  CA  GLU A  24      14.577  14.993  23.105  1.00  4.26           C  
ATOM    162  C   GLU A  24      16.060  15.191  22.905  1.00  5.15           C  
ATOM    163  O   GLU A  24      16.913  14.568  23.582  1.00  4.90           O  
ATOM    164  CB  GLU A  24      14.012  15.812  24.276  1.00  4.35           C  
ATOM    165  CG  GLU A  24      12.491  15.766  24.270  1.00  7.20           C  
ATOM    166  CD  GLU A  24      11.830  16.168  25.579  1.00  6.49           C  
ATOM    167  OE1 GLU A  24      12.105  17.250  26.117  1.00  3.04           O  
ATOM    168  OE2 GLU A  24      10.966  15.425  26.151  1.00  9.37           O  
ATOM    169  N   ILE A  25      16.311  16.111  21.948  1.00  5.72           N  
ATOM    170  CA  ILE A  25      17.719  16.354  21.605  1.00  6.11           C  
ATOM    171  C   ILE A  25      18.556  16.711  22.825  1.00  5.40           C  
ATOM    172  O   ILE A  25      19.682  16.253  22.945  1.00  5.38           O  
ATOM    173  CB  ILE A  25      17.821  17.439  20.490  1.00  6.68           C  
ATOM    174  CG1 ILE A  25      17.235  16.917  19.181  1.00  9.80           C  
ATOM    175  CG2 ILE A  25      19.286  17.847  20.300  1.00  7.42           C  
ATOM    176  CD1 ILE A  25      17.205  18.006  18.054  1.00  8.54           C  
ATOM    177  N   GLU A  26      17.995  17.472  23.781  1.00  5.92           N  
ATOM    178  CA  GLU A  26      18.761  17.821  24.976  1.00  5.90           C  
ATOM    179  C   GLU A  26      19.124  16.619  25.825  1.00  5.50           C  
ATOM    180  O   GLU A  26      20.177  16.581  26.429  1.00  6.43           O  
ATOM    181  CB  GLU A  26      18.017  18.823  25.840  1.00  6.08           C  
ATOM    182  CG  GLU A  26      17.690  20.102  25.125  1.00  6.82           C  
ATOM    183  CD  GLU A  26      16.359  20.122  24.445  1.00  8.16           C  
ATOM    184  OE1 GLU A  26      15.766  19.084  24.117  1.00  7.72           O  
ATOM    185  OE2 GLU A  26      15.866  21.245  24.242  1.00 12.47           O  
ATOM    186  N   ASP A  27      18.246  15.632  25.850  1.00  4.15           N  
ATOM    187  CA  ASP A  27      18.524  14.409  26.582  1.00  5.28           C  
ATOM    188  C   ASP A  27      19.552  13.516  25.893  1.00  4.76           C  
ATOM    189  O   ASP A  27      20.393  12.849  26.555  1.00  5.22           O  
ATOM    190  CB  ASP A  27      17.229  13.704  26.922  1.00  4.81           C  
ATOM    191  CG  ASP A  27      16.338  14.573  27.831  1.00  6.97           C  
ATOM    192  OD1 ASP A  27      16.843  15.182  28.809  1.00 10.46           O  
ATOM    193  OD2 ASP A  27      15.145  14.736  27.500  1.00  8.69           O  
ATOM    194  N   ILE A  28      19.659  13.521  24.550  1.00  4.55           N  
ATOM    195  CA  ILE A  28      20.733  12.934  23.765  1.00  3.80           C  
ATOM    196  C   ILE A  28      22.050  13.608  24.137  1.00  4.88           C  
ATOM    197  O   ILE A  28      23.046  12.961  24.386  1.00  4.54           O  
ATOM    198  CB  ILE A  28      20.455  13.109  22.257  1.00  3.75           C  
ATOM    199  CG1 ILE A  28      19.196  12.293  21.854  1.00  3.80           C  
ATOM    200  CG2 ILE A  28      21.673  12.714  21.430  1.00  4.79           C  
ATOM    201  CD1 ILE A  28      19.337  10.746  21.857  1.00  6.70           C  
ATOM    202  N   ASN A  29      22.014  14.928  24.249  1.00  4.29           N  
ATOM    203  CA  ASN A  29      23.246  15.659  24.504  1.00  5.35           C  
ATOM    204  C   ASN A  29      23.823  15.342  25.869  1.00  5.17           C  
ATOM    205  O   ASN A  29      25.029  15.181  26.022  1.00  6.03           O  
ATOM    206  CB  ASN A  29      23.020  17.165  24.340  1.00  6.10           C  
ATOM    207  CG  ASN A  29      22.914  17.587  22.874  1.00  6.36           C  
ATOM    208  OD1 ASN A  29      23.354  16.891  21.953  1.00  6.51           O  
ATOM    209  ND2 ASN A  29      22.372  18.772  22.666  1.00  7.16           N  
ATOM    210  N   THR A  30      22.951  15.238  26.868  1.00  5.62           N  
ATOM    211  CA  THR A  30      23.392  14.880  28.221  1.00  5.70           C  
ATOM    212  C   THR A  30      24.016  13.492  28.220  1.00  6.80           C  
ATOM    213  O   THR A  30      25.070  13.272  28.839  1.00  7.54           O  
ATOM    214  CB  THR A  30      22.220  14.992  29.192  1.00  6.18           C  
ATOM    215  OG1 THR A  30      21.781  16.344  29.182  1.00  7.47           O  
ATOM    216  CG2 THR A  30      22.623  14.622  30.609  1.00  8.44           C  
ATOM    217  N   PHE A  31      23.368  12.580  27.499  1.00  5.17           N  
ATOM    218  CA  PHE A  31      23.776  11.179  27.500  1.00  4.49           C  
ATOM    219  C   PHE A  31      25.111  10.969  26.832  1.00  6.09           C  
ATOM    220  O   PHE A  31      25.975  10.219  27.350  1.00  6.34           O  
ATOM    221  CB  PHE A  31      22.687  10.316  26.881  1.00  5.33           C  
ATOM    222  CG  PHE A  31      22.951   8.829  26.992  1.00  3.06           C  
ATOM    223  CD1 PHE A  31      22.369   8.083  28.047  1.00  2.76           C  
ATOM    224  CD2 PHE A  31      23.728   8.153  26.056  1.00  4.39           C  
ATOM    225  CE1 PHE A  31      22.556   6.729  28.152  1.00  3.62           C  
ATOM    226  CE2 PHE A  31      23.922   6.810  26.157  1.00  3.34           C  
ATOM    227  CZ  PHE A  31      23.380   6.082  27.220  1.00  3.42           C  
ATOM    228  N   PHE A  32      25.325  11.647  25.706  1.00  4.91           N  
ATOM    229  CA  PHE A  32      26.479  11.397  24.880  1.00  6.09           C  
ATOM    230  C   PHE A  32      27.552  12.458  24.952  1.00  6.70           C  
ATOM    231  O   PHE A  32      28.638  12.258  24.430  1.00  8.11           O  
ATOM    232  CB  PHE A  32      26.068  11.257  23.414  1.00  6.20           C  
ATOM    233  CG  PHE A  32      25.341   9.987  23.116  1.00  2.80           C  
ATOM    234  CD1 PHE A  32      26.015   8.782  23.068  1.00  3.82           C  
ATOM    235  CD2 PHE A  32      23.974   9.984  22.899  1.00  3.31           C  
ATOM    236  CE1 PHE A  32      25.345   7.611  22.832  1.00  3.58           C  
ATOM    237  CE2 PHE A  32      23.299   8.819  22.645  1.00  4.77           C  
ATOM    238  CZ  PHE A  32      23.969   7.623  22.629  1.00  3.76           C  
ATOM    239  N   GLY A  33      27.257  13.579  25.566  1.00  8.73           N  
ATOM    240  CA  GLY A  33      28.191  14.714  25.546  1.00  9.71           C  
ATOM    241  C   GLY A  33      28.291  15.434  24.199  1.00 10.91           C  
ATOM    242  O   GLY A  33      29.253  16.203  23.946  1.00 12.77           O  
ATOM    243  N   THR A  34      27.305  15.224  23.345  1.00 11.21           N  
ATOM    244  CA  THR A  34      27.141  15.919  22.067  1.00 10.22           C  
ATOM    245  C   THR A  34      26.568  17.321  22.296  1.00 11.63           C  
ATOM    246  O   THR A  34      26.087  17.650  23.377  1.00 10.17           O  
ATOM    247  CB  THR A  34      26.256  15.090  21.122  1.00 10.79           C  
ATOM    248  OG1 THR A  34      25.060  14.697  21.818  1.00  9.09           O  
ATOM    249  CG2 THR A  34      26.991  13.817  20.666  1.00  9.08           C  
ATOM    250  N   GLU A  35      26.623  18.139  21.249  1.00 11.78           N  
ATOM    251  CA  GLU A  35      26.098  19.488  21.293  1.00 13.81           C  
ATOM    252  C   GLU A  35      25.204  19.743  20.087  1.00 13.41           C  
ATOM    253  O   GLU A  35      25.292  20.782  19.401  1.00 11.96           O  
ATOM    254  CB  GLU A  35      27.268  20.487  21.355  1.00 13.85           C  
ATOM    255  CG  GLU A  35      28.011  20.486  22.683  1.00 16.86           C  
ATOM    256  CD  GLU A  35      29.255  21.366  22.650  1.00 19.44           C  
ATOM    257  OE1 GLU A  35      29.307  22.311  21.824  1.00 24.77           O  
ATOM    258  OE2 GLU A  35      30.186  21.108  23.452  1.00 27.93           O  
ATOM    259  N   TYR A  36      24.339  18.767  19.815  1.00 13.20           N  
ATOM    260  CA  TYR A  36      23.387  18.888  18.758  1.00 13.74           C  
ATOM    261  C   TYR A  36      22.403  19.987  19.042  1.00 15.50           C  
ATOM    262  O   TYR A  36      22.029  20.256  20.177  1.00 15.37           O  
ATOM    263  CB  TYR A  36      22.600  17.610  18.618  1.00 13.63           C  
ATOM    264  CG  TYR A  36      23.386  16.371  18.297  1.00 13.04           C  
ATOM    265  CD1 TYR A  36      24.392  16.365  17.356  1.00 12.58           C  
ATOM    266  CD2 TYR A  36      23.060  15.158  18.889  1.00 15.09           C  
ATOM    267  CE1 TYR A  36      25.072  15.202  17.035  1.00 11.74           C  
ATOM    268  CE2 TYR A  36      23.716  14.011  18.555  1.00 14.26           C  
ATOM    269  CZ  TYR A  36      24.745  14.030  17.655  1.00 12.93           C  
ATOM    270  OH  TYR A  36      25.376  12.834  17.366  1.00 12.29           O  
ATOM    271  N   SER A  37      21.963  20.613  17.970  1.00 18.46           N  
ATOM    272  CA  SER A  37      21.052  21.712  18.096  1.00 20.67           C  
ATOM    273  C   SER A  37      20.422  21.847  16.731  1.00 21.86           C  
ATOM    274  O   SER A  37      21.092  21.686  15.723  1.00 22.44           O  
ATOM    275  CB  SER A  37      21.853  22.951  18.507  1.00 21.67           C  
ATOM    276  OG  SER A  37      21.215  24.139  18.162  1.00 24.84           O  
ATOM    277  N   SER A  38      19.125  22.105  16.703  1.00 22.95           N  
ATOM    278  CA  SER A  38      18.441  22.362  15.452  1.00 22.91           C  
ATOM    279  C   SER A  38      17.535  23.546  15.662  1.00 24.14           C  
ATOM    280  O   SER A  38      17.059  23.796  16.767  1.00 24.36           O  
ATOM    281  CB  SER A  38      17.639  21.131  15.020  1.00 23.48           C  
ATOM    282  OG  SER A  38      16.858  21.390  13.862  1.00 20.11           O  
ATOM    283  N   GLU A  39      17.340  24.304  14.602  1.00 25.14           N  
ATOM    284  CA  GLU A  39      16.356  25.341  14.628  1.00 26.22           C  
ATOM    285  C   GLU A  39      14.964  24.736  14.479  1.00 26.51           C  
ATOM    286  O   GLU A  39      13.988  25.309  14.960  1.00 27.88           O  
ATOM    287  CB  GLU A  39      16.653  26.325  13.503  1.00 26.61           C  
ATOM    288  CG  GLU A  39      17.927  27.102  13.744  1.00 26.69           C  
ATOM    289  CD  GLU A  39      17.747  28.182  14.793  1.00 27.83           C  
ATOM    290  OE1 GLU A  39      16.649  28.776  14.871  1.00 28.00           O  
ATOM    291  OE2 GLU A  39      18.716  28.456  15.520  1.00 28.72           O  
ATOM    292  N   GLU A  40      14.884  23.584  13.815  1.00 25.89           N  
ATOM    293  CA  GLU A  40      13.617  23.036  13.340  1.00 25.23           C  
ATOM    294  C   GLU A  40      13.273  21.646  13.894  1.00 25.06           C  
ATOM    295  O   GLU A  40      12.183  21.133  13.599  1.00 26.04           O  
ATOM    296  CB  GLU A  40      13.638  22.984  11.802  1.00 26.27           C  
ATOM    297  CG  GLU A  40      14.463  21.822  11.226  1.00 26.85           C  
ATOM    298  CD  GLU A  40      14.835  21.966   9.747  1.00 27.20           C  
ATOM    299  OE1 GLU A  40      14.505  22.993   9.110  1.00 29.51           O  
ATOM    300  OE2 GLU A  40      15.466  21.016   9.220  1.00 30.71           O  
ATOM    301  N   ALA A  41      14.205  21.032  14.636  1.00 22.25           N  
ATOM    302  CA  ALA A  41      14.000  19.708  15.250  1.00 21.10           C  
ATOM    303  C   ALA A  41      14.148  19.784  16.756  1.00 17.99           C  
ATOM    304  O   ALA A  41      15.042  20.444  17.263  1.00 19.63           O  
ATOM    305  CB  ALA A  41      14.999  18.691  14.702  1.00 20.85           C  
ATOM    306  N   ASP A  42      13.310  19.044  17.455  1.00 13.70           N  
ATOM    307  CA  ASP A  42      13.401  18.936  18.908  1.00 11.53           C  
ATOM    308  C   ASP A  42      13.743  17.548  19.461  1.00  9.71           C  
ATOM    309  O   ASP A  42      14.080  17.393  20.658  1.00  8.39           O  
ATOM    310  CB  ASP A  42      12.085  19.308  19.492  1.00 11.35           C  
ATOM    311  CG  ASP A  42      12.196  19.515  20.937  1.00 15.98           C  
ATOM    312  OD1 ASP A  42      13.241  20.137  21.368  1.00 20.59           O  
ATOM    313  OD2 ASP A  42      11.305  19.015  21.661  1.00 26.94           O  
ATOM    314  N   THR A  43      13.634  16.553  18.584  1.00  7.92           N  
ATOM    315  CA  THR A  43      13.907  15.159  18.933  1.00  7.36           C  
ATOM    316  C   THR A  43      15.006  14.578  18.037  1.00  6.52           C  
ATOM    317  O   THR A  43      15.327  15.093  16.948  1.00  6.03           O  
ATOM    318  CB  THR A  43      12.671  14.264  18.786  1.00  7.83           C  
ATOM    319  OG1 THR A  43      12.326  14.132  17.386  1.00  7.01           O  
ATOM    320  CG2 THR A  43      11.460  14.789  19.577  1.00  7.18           C  
ATOM    321  N   ILE A  44      15.543  13.438  18.470  1.00  5.16           N  
ATOM    322  CA  ILE A  44      16.628  12.830  17.701  1.00  4.92           C  
ATOM    323  C   ILE A  44      16.095  12.330  16.357  1.00  4.95           C  
ATOM    324  O   ILE A  44      16.780  12.427  15.357  1.00  5.30           O  
ATOM    325  CB  ILE A  44      17.333  11.758  18.519  1.00  5.63           C  
ATOM    326  CG1 ILE A  44      18.601  11.248  17.821  1.00  5.54           C  
ATOM    327  CG2 ILE A  44      16.377  10.620  18.854  1.00  5.20           C  
ATOM    328  CD1 ILE A  44      19.625  12.318  17.436  1.00  7.08           C  
ATOM    329  N   GLY A  45      14.871  11.797  16.330  1.00  4.97           N  
ATOM    330  CA  GLY A  45      14.242  11.389  15.065  1.00  5.82           C  
ATOM    331  C   GLY A  45      14.123  12.571  14.108  1.00  5.58           C  
ATOM    332  O   GLY A  45      14.388  12.469  12.902  1.00  3.92           O  
ATOM    333  N   GLY A  46      13.684  13.715  14.640  1.00  5.62           N  
ATOM    334  CA  GLY A  46      13.625  14.949  13.867  1.00  6.49           C  
ATOM    335  C   GLY A  46      14.957  15.379  13.309  1.00  5.60           C  
ATOM    336  O   GLY A  46      15.037  15.839  12.149  1.00  6.15           O  
ATOM    337  N   LEU A  47      16.010  15.244  14.107  1.00  5.08           N  
ATOM    338  CA  LEU A  47      17.333  15.589  13.671  1.00  5.75           C  
ATOM    339  C   LEU A  47      17.843  14.661  12.564  1.00  5.42           C  
ATOM    340  O   LEU A  47      18.436  15.112  11.583  1.00  5.28           O  
ATOM    341  CB  LEU A  47      18.273  15.596  14.867  1.00  6.66           C  
ATOM    342  CG  LEU A  47      19.623  16.234  14.636  1.00  9.05           C  
ATOM    343  CD1 LEU A  47      19.529  17.750  14.451  1.00 12.13           C  
ATOM    344  CD2 LEU A  47      20.498  15.954  15.818  1.00  8.67           C  
ATOM    345  N   VAL A  48      17.593  13.364  12.712  1.00  4.97           N  
ATOM    346  CA  VAL A  48      17.928  12.401  11.651  1.00  5.04           C  
ATOM    347  C   VAL A  48      17.212  12.742  10.367  1.00  3.94           C  
ATOM    348  O   VAL A  48      17.799  12.719   9.302  1.00  6.22           O  
ATOM    349  CB  VAL A  48      17.642  10.994  12.104  1.00  4.73           C  
ATOM    350  CG1 VAL A  48      17.695  10.036  10.951  1.00  4.15           C  
ATOM    351  CG2 VAL A  48      18.687  10.599  13.208  1.00  4.30           C  
ATOM    352  N   ILE A  49      15.928  13.043  10.443  1.00  4.80           N  
ATOM    353  CA  ILE A  49      15.146  13.387   9.248  1.00  5.52           C  
ATOM    354  C   ILE A  49      15.719  14.666   8.613  1.00  6.89           C  
ATOM    355  O   ILE A  49      15.814  14.755   7.375  1.00  7.10           O  
ATOM    356  CB  ILE A  49      13.666  13.518   9.616  1.00  4.84           C  
ATOM    357  CG1 ILE A  49      13.036  12.156   9.950  1.00  4.31           C  
ATOM    358  CG2 ILE A  49      12.872  14.163   8.497  1.00  5.76           C  
ATOM    359  CD1 ILE A  49      11.652  12.234  10.576  1.00  5.97           C  
ATOM    360  N   GLN A  50      16.076  15.646   9.429  1.00  7.71           N  
ATOM    361  CA  GLN A  50      16.719  16.893   8.941  1.00  8.19           C  
ATOM    362  C   GLN A  50      17.995  16.597   8.174  1.00  8.34           C  
ATOM    363  O   GLN A  50      18.197  17.126   7.087  1.00  6.80           O  
ATOM    364  CB  GLN A  50      16.988  17.874  10.080  1.00  9.33           C  
ATOM    365  CG  GLN A  50      17.935  19.089   9.762  1.00 10.44           C  
ATOM    366  CD  GLN A  50      18.453  19.756  11.045  1.00 14.56           C  
ATOM    367  OE1 GLN A  50      17.658  20.179  11.889  1.00 21.78           O  
ATOM    368  NE2 GLN A  50      19.783  19.747  11.247  1.00 20.23           N  
ATOM    369  N   GLU A  51      18.859  15.772   8.747  1.00  7.58           N  
ATOM    370  CA  GLU A  51      20.174  15.502   8.161  1.00  8.62           C  
ATOM    371  C   GLU A  51      20.096  14.615   6.928  1.00  8.40           C  
ATOM    372  O   GLU A  51      20.889  14.795   5.999  1.00 10.06           O  
ATOM    373  CB  GLU A  51      21.091  14.849   9.158  1.00  9.61           C  
ATOM    374  CG  GLU A  51      21.462  15.754  10.320  1.00 10.89           C  
ATOM    375  CD  GLU A  51      22.452  16.834   9.933  1.00 18.85           C  
ATOM    376  OE1 GLU A  51      23.375  16.571   9.132  1.00 20.88           O  
ATOM    377  OE2 GLU A  51      22.299  17.958  10.434  1.00 24.76           O  
ATOM    378  N   LEU A  52      19.162  13.669   6.911  1.00  7.35           N  
ATOM    379  CA  LEU A  52      18.915  12.863   5.691  1.00  7.51           C  
ATOM    380  C   LEU A  52      18.098  13.577   4.621  1.00  7.58           C  
ATOM    381  O   LEU A  52      18.190  13.211   3.429  1.00  7.87           O  
ATOM    382  CB  LEU A  52      18.236  11.535   5.995  1.00  7.09           C  
ATOM    383  CG  LEU A  52      19.150  10.530   6.666  1.00  6.42           C  
ATOM    384  CD1 LEU A  52      18.385   9.270   7.186  1.00 11.01           C  
ATOM    385  CD2 LEU A  52      20.284  10.111   5.737  1.00  9.46           C  
ATOM    386  N   GLY A  53      17.281  14.546   5.018  1.00  7.77           N  
ATOM    387  CA  GLY A  53      16.446  15.295   4.072  1.00  7.31           C  
ATOM    388  C   GLY A  53      15.044  14.777   3.851  1.00  7.28           C  
ATOM    389  O   GLY A  53      14.248  15.406   3.145  1.00  7.61           O  
ATOM    390  N   HIS A  54      14.736  13.618   4.439  1.00  5.38           N  
ATOM    391  CA  HIS A  54      13.464  12.941   4.202  1.00  5.69           C  
ATOM    392  C   HIS A  54      13.229  11.922   5.276  1.00  5.37           C  
ATOM    393  O   HIS A  54      14.131  11.664   6.071  1.00  5.80           O  
ATOM    394  CB  HIS A  54      13.493  12.238   2.854  1.00  5.78           C  
ATOM    395  CG  HIS A  54      14.518  11.126   2.767  1.00  6.89           C  
ATOM    396  ND1 HIS A  54      15.870  11.360   2.590  1.00  8.24           N  
ATOM    397  CD2 HIS A  54      14.370   9.777   2.773  1.00  9.45           C  
ATOM    398  CE1 HIS A  54      16.506  10.198   2.510  1.00  8.15           C  
ATOM    399  NE2 HIS A  54      15.622   9.220   2.620  1.00  5.86           N  
ATOM    400  N   LEU A  55      11.992  11.410   5.332  1.00  5.05           N  
ATOM    401  CA  LEU A  55      11.648  10.315   6.246  1.00  5.56           C  
ATOM    402  C   LEU A  55      12.305   9.039   5.733  1.00  4.99           C  
ATOM    403  O   LEU A  55      11.940   8.546   4.669  1.00  5.66           O  
ATOM    404  CB  LEU A  55      10.129  10.145   6.284  1.00  5.94           C  
ATOM    405  CG  LEU A  55       9.597   8.934   7.068  1.00  5.71           C  
ATOM    406  CD1 LEU A  55      10.043   9.024   8.505  1.00  9.77           C  
ATOM    407  CD2 LEU A  55       8.076   8.868   6.970  1.00  6.22           C  
ATOM    408  N   PRO A  56      13.283   8.507   6.472  1.00  5.26           N  
ATOM    409  CA  PRO A  56      14.002   7.355   5.992  1.00  4.61           C  
ATOM    410  C   PRO A  56      13.325   6.003   6.244  1.00  4.85           C  
ATOM    411  O   PRO A  56      12.407   5.863   7.076  1.00  6.23           O  
ATOM    412  CB  PRO A  56      15.309   7.434   6.779  1.00  6.22           C  
ATOM    413  CG  PRO A  56      14.880   7.946   8.064  1.00  5.66           C  
ATOM    414  CD  PRO A  56      13.810   8.986   7.754  1.00  6.01           C  
ATOM    415  N   VAL A  57      13.852   4.988   5.559  1.00  4.72           N  
ATOM    416  CA  VAL A  57      13.414   3.625   5.775  1.00  4.74           C  
ATOM    417  C   VAL A  57      14.433   2.868   6.610  1.00  5.50           C  
ATOM    418  O   VAL A  57      15.582   3.320   6.816  1.00  5.13           O  
ATOM    419  CB  VAL A  57      13.205   2.885   4.412  1.00  5.24           C  
ATOM    420  CG1 VAL A  57      12.173   3.571   3.557  1.00  4.73           C  
ATOM    421  CG2 VAL A  57      14.522   2.795   3.631  1.00  4.59           C  
ATOM    422  N   ARG A  58      14.018   1.722   7.144  1.00  4.88           N  
ATOM    423  CA  ARG A  58      14.916   0.867   7.920  0.50  5.92           C  
ATOM    425  C   ARG A  58      16.236   0.637   7.167  1.00  4.87           C  
ATOM    426  O   ARG A  58      16.243   0.341   5.940  1.00  5.90           O  
ATOM    427  CB  ARG A  58      14.224  -0.461   8.190  0.50  5.53           C  
ATOM    429  CG  ARG A  58      14.909  -1.340   9.201  0.50  7.28           C  
ATOM    431  CD  ARG A  58      13.961  -2.419   9.717  0.50  9.40           C  
ATOM    433  NE  ARG A  58      13.430  -3.280   8.654  0.50 15.09           N  
ATOM    435  CZ  ARG A  58      14.135  -4.201   7.995  0.50 16.37           C  
ATOM    437  NH1 ARG A  58      15.420  -4.388   8.259  0.50 18.81           N  
ATOM    439  NH2 ARG A  58      13.554  -4.947   7.061  0.50 16.59           N  
ATOM    441  N   GLY A  59      17.343   0.723   7.880  1.00  4.96           N  
ATOM    442  CA  GLY A  59      18.638   0.467   7.308  1.00  5.61           C  
ATOM    443  C   GLY A  59      19.384   1.699   6.876  1.00  5.68           C  
ATOM    444  O   GLY A  59      20.609   1.639   6.693  1.00  5.56           O  
ATOM    445  N   GLU A  60      18.685   2.830   6.681  1.00  5.08           N  
ATOM    446  CA  GLU A  60      19.392   4.067   6.309  1.00  5.68           C  
ATOM    447  C   GLU A  60      20.233   4.561   7.472  1.00  7.02           C  
ATOM    448  O   GLU A  60      19.855   4.401   8.627  1.00  5.35           O  
ATOM    449  CB  GLU A  60      18.460   5.177   5.878  1.00  5.90           C  
ATOM    450  CG  GLU A  60      17.703   4.842   4.699  1.00  7.44           C  
ATOM    451  CD  GLU A  60      17.123   6.065   4.008  1.00  6.67           C  
ATOM    452  OE1 GLU A  60      17.868   7.065   3.705  1.00 12.19           O  
ATOM    453  OE2 GLU A  60      15.923   5.986   3.792  1.00  7.50           O  
ATOM    454  N   LYS A  61      21.397   5.097   7.154  1.00  7.37           N  
ATOM    455  CA  LYS A  61      22.297   5.574   8.178  1.00  9.00           C  
ATOM    456  C   LYS A  61      22.682   7.017   7.936  1.00  9.00           C  
ATOM    457  O   LYS A  61      22.727   7.495   6.772  1.00  8.08           O  
ATOM    458  CB  LYS A  61      23.524   4.702   8.306  1.00 10.49           C  
ATOM    459  CG  LYS A  61      24.540   4.793   7.240  1.00 14.25           C  
ATOM    460  CD  LYS A  61      25.830   4.003   7.682  1.00 13.94           C  
ATOM    461  CE  LYS A  61      27.072   4.480   6.954  1.00 17.33           C  
ATOM    462  NZ  LYS A  61      28.288   3.617   7.255  1.00 20.36           N  
ATOM    463  N   VAL A  62      22.980   7.688   9.044  1.00  7.78           N  
ATOM    464  CA  VAL A  62      23.503   9.035   9.009  1.00  9.02           C  
ATOM    465  C   VAL A  62      24.519   9.266  10.120  1.00  8.58           C  
ATOM    466  O   VAL A  62      24.322   8.846  11.261  1.00  9.45           O  
ATOM    467  CB  VAL A  62      22.351  10.100   8.961  1.00  9.63           C  
ATOM    468  CG1 VAL A  62      21.581  10.067  10.216  1.00  8.41           C  
ATOM    469  CG2 VAL A  62      22.890  11.471   8.620  1.00  9.60           C  
ATOM    470  N   LEU A  63      25.633   9.902   9.766  1.00  9.05           N  
ATOM    471  CA  LEU A  63      26.622  10.341  10.752  1.00 10.53           C  
ATOM    472  C   LEU A  63      26.343  11.776  11.174  1.00 10.90           C  
ATOM    473  O   LEU A  63      26.280  12.680  10.328  1.00 10.60           O  
ATOM    474  CB  LEU A  63      28.049  10.282  10.166  1.00 11.11           C  
ATOM    475  CG  LEU A  63      28.560   8.957   9.619  1.00 16.63           C  
ATOM    476  CD1 LEU A  63      30.105   8.931   9.637  1.00 20.49           C  
ATOM    477  CD2 LEU A  63      27.991   7.786  10.366  1.00 21.14           C  
ATOM    478  N   ILE A  64      26.190  11.999  12.473  1.00 10.56           N  
ATOM    479  CA  ILE A  64      25.982  13.353  12.981  1.00 10.47           C  
ATOM    480  C   ILE A  64      26.947  13.534  14.137  1.00 11.02           C  
ATOM    481  O   ILE A  64      26.854  12.856  15.159  1.00  8.54           O  
ATOM    482  CB  ILE A  64      24.553  13.596  13.495  1.00 10.04           C  
ATOM    483  CG1 ILE A  64      23.501  12.966  12.568  1.00 10.19           C  
ATOM    484  CG2 ILE A  64      24.339  15.107  13.715  1.00 11.17           C  
ATOM    485  CD1 ILE A  64      22.043  13.100  13.090  1.00 11.75           C  
ATOM    486  N   GLY A  65      27.898  14.440  13.972  1.00 12.02           N  
ATOM    487  CA  GLY A  65      28.928  14.555  14.977  1.00 13.23           C  
ATOM    488  C   GLY A  65      29.649  13.219  15.028  1.00 13.79           C  
ATOM    489  O   GLY A  65      29.964  12.616  13.978  1.00 16.35           O  
ATOM    490  N   GLY A  66      29.909  12.737  16.225  1.00 12.12           N  
ATOM    491  CA  GLY A  66      30.703  11.525  16.372  1.00 10.93           C  
ATOM    492  C   GLY A  66      29.854  10.277  16.549  1.00  9.87           C  
ATOM    493  O   GLY A  66      30.357   9.273  17.039  1.00 10.89           O  
ATOM    494  N   LEU A  67      28.583  10.355  16.172  1.00  8.91           N  
ATOM    495  CA  LEU A  67      27.654   9.237  16.319  1.00  8.71           C  
ATOM    496  C   LEU A  67      27.074   8.838  14.964  1.00  8.00           C  
ATOM    497  O   LEU A  67      26.720   9.704  14.156  1.00  8.85           O  
ATOM    498  CB  LEU A  67      26.493   9.582  17.248  1.00  8.45           C  
ATOM    499  CG  LEU A  67      26.796   9.845  18.717  1.00  9.93           C  
ATOM    500  CD1 LEU A  67      25.492  10.142  19.471  1.00  9.60           C  
ATOM    501  CD2 LEU A  67      27.567   8.698  19.356  1.00 11.60           C  
ATOM    502  N   GLN A  68      26.946   7.535  14.744  1.00  7.58           N  
ATOM    503  CA  GLN A  68      26.260   6.991  13.564  1.00  7.60           C  
ATOM    504  C   GLN A  68      24.910   6.482  14.021  1.00  6.58           C  
ATOM    505  O   GLN A  68      24.822   5.708  15.010  1.00  7.97           O  
ATOM    506  CB  GLN A  68      27.042   5.825  12.978  1.00  7.44           C  
ATOM    507  CG  GLN A  68      26.305   5.202  11.793  1.00 10.62           C  
ATOM    508  CD  GLN A  68      26.964   3.953  11.306  1.00 11.22           C  
ATOM    509  OE1 GLN A  68      27.943   4.013  10.551  1.00 16.31           O  
ATOM    510  NE2 GLN A  68      26.455   2.799  11.733  1.00 16.30           N  
ATOM    511  N   PHE A  69      23.864   6.912  13.341  1.00  5.21           N  
ATOM    512  CA  PHE A  69      22.508   6.478  13.640  1.00  5.48           C  
ATOM    513  C   PHE A  69      22.028   5.679  12.463  1.00  5.53           C  
ATOM    514  O   PHE A  69      22.077   6.191  11.339  1.00  7.52           O  
ATOM    515  CB  PHE A  69      21.580   7.661  13.812  1.00  6.89           C  
ATOM    516  CG  PHE A  69      21.901   8.498  14.981  1.00  4.39           C  
ATOM    517  CD1 PHE A  69      21.448   8.173  16.231  1.00  5.20           C  
ATOM    518  CD2 PHE A  69      22.755   9.580  14.845  1.00  5.16           C  
ATOM    519  CE1 PHE A  69      21.796   8.934  17.345  1.00  7.08           C  
ATOM    520  CE2 PHE A  69      23.093  10.369  15.917  1.00  5.74           C  
ATOM    521  CZ  PHE A  69      22.635  10.050  17.191  1.00  6.42           C  
ATOM    522  N   THR A  70      21.548   4.476  12.711  1.00  4.45           N  
ATOM    523  CA  THR A  70      20.933   3.674  11.668  1.00  3.74           C  
ATOM    524  C   THR A  70      19.475   3.525  11.995  1.00  3.28           C  
ATOM    525  O   THR A  70      19.108   3.251  13.113  1.00  3.18           O  
ATOM    526  CB  THR A  70      21.594   2.269  11.537  1.00  3.85           C  
ATOM    527  OG1 THR A  70      23.006   2.423  11.349  1.00  4.31           O  
ATOM    528  CG2 THR A  70      21.011   1.504  10.350  1.00  4.40           C  
ATOM    529  N   VAL A  71      18.616   3.654  11.009  1.00  3.15           N  
ATOM    530  CA  VAL A  71      17.177   3.467  11.244  1.00  3.04           C  
ATOM    531  C   VAL A  71      16.830   2.022  11.537  1.00  3.54           C  
ATOM    532  O   VAL A  71      17.103   1.157  10.708  1.00  3.27           O  
ATOM    533  CB  VAL A  71      16.363   3.995  10.028  1.00  2.71           C  
ATOM    534  CG1 VAL A  71      14.887   3.778  10.259  1.00  3.98           C  
ATOM    535  CG2 VAL A  71      16.699   5.504   9.770  1.00  5.94           C  
ATOM    536  N   ALA A  72      16.237   1.749  12.706  1.00  3.66           N  
ATOM    537  CA  ALA A  72      15.816   0.389  13.118  1.00  4.31           C  
ATOM    538  C   ALA A  72      14.334   0.069  12.935  1.00  6.19           C  
ATOM    539  O   ALA A  72      13.951  -1.078  12.691  1.00  8.10           O  
ATOM    540  CB  ALA A  72      16.192   0.173  14.567  1.00  4.52           C  
ATOM    541  N   ARG A  73      13.486   1.072  13.153  1.00  5.44           N  
ATOM    542  CA  ARG A  73      12.056   0.906  12.880  1.00  6.22           C  
ATOM    543  C   ARG A  73      11.536   2.194  12.323  1.00  5.46           C  
ATOM    544  O   ARG A  73      11.674   3.249  12.919  1.00  3.64           O  
ATOM    545  CB  ARG A  73      11.269   0.504  14.134  1.00  5.90           C  
ATOM    546  CG  ARG A  73       9.798   0.233  13.844  1.00  8.12           C  
ATOM    547  CD  ARG A  73       9.012  -0.065  15.112  1.00 12.62           C  
ATOM    548  NE  ARG A  73       7.578   0.137  14.880  1.00 19.98           N  
ATOM    549  CZ  ARG A  73       6.787   0.904  15.630  1.00 23.27           C  
ATOM    550  NH1 ARG A  73       7.256   1.535  16.716  1.00 28.43           N  
ATOM    551  NH2 ARG A  73       5.509   0.999  15.325  1.00 26.31           N  
ATOM    552  N   ALA A  74      10.877   2.098  11.173  1.00  4.77           N  
ATOM    553  CA  ALA A  74      10.235   3.257  10.566  1.00  5.39           C  
ATOM    554  C   ALA A  74       9.140   2.766   9.645  1.00  6.00           C  
ATOM    555  O   ALA A  74       9.182   1.641   9.166  1.00  6.36           O  
ATOM    556  CB  ALA A  74      11.286   4.098   9.739  1.00  5.18           C  
ATOM    557  N   ASP A  75       8.192   3.637   9.387  1.00  6.83           N  
ATOM    558  CA  ASP A  75       7.129   3.334   8.429  1.00  7.32           C  
ATOM    559  C   ASP A  75       6.832   4.558   7.577  1.00  7.73           C  
ATOM    560  O   ASP A  75       7.564   5.523   7.616  1.00  7.98           O  
ATOM    561  CB  ASP A  75       5.911   2.777   9.169  1.00  8.08           C  
ATOM    562  CG  ASP A  75       5.438   3.664  10.276  1.00  7.81           C  
ATOM    563  OD1 ASP A  75       5.331   4.898  10.043  1.00  7.51           O  
ATOM    564  OD2 ASP A  75       5.218   3.116  11.387  1.00  9.20           O  
ATOM    565  N   ASN A  76       5.735   4.493   6.818  0.50  8.13           N  
ATOM    567  CA  ASN A  76       5.353   5.565   5.909  0.50  8.11           C  
ATOM    569  C   ASN A  76       4.914   6.828   6.622  0.50  7.74           C  
ATOM    571  O   ASN A  76       4.764   7.880   5.986  0.50  8.35           O  
ATOM    573  CB  ASN A  76       4.211   5.100   5.006  0.50  9.26           C  
ATOM    575  CG  ASN A  76       4.648   4.054   3.992  0.50 10.42           C  
ATOM    577  OD1 ASN A  76       3.830   3.257   3.537  0.50 16.78           O  
ATOM    579  ND2 ASN A  76       5.936   4.054   3.630  0.50 13.75           N  
ATOM    581  N   ARG A  77       4.682   6.724   7.927  0.50  6.73           N  
ATOM    583  CA  ARG A  77       4.288   7.886   8.726  0.50  6.55           C  
ATOM    585  C   ARG A  77       5.437   8.520   9.536  0.50  5.91           C  
ATOM    587  O   ARG A  77       5.654   9.735   9.497  0.50  5.00           O  
ATOM    589  CB  ARG A  77       3.156   7.481   9.665  0.50  6.02           C  
ATOM    591  CG  ARG A  77       1.820   7.217   8.995  0.50  8.37           C  
ATOM    593  CD  ARG A  77       1.154   8.543   8.504  0.50 10.60           C  
ATOM    595  NE  ARG A  77       0.872   9.489   9.591  0.50 10.84           N  
ATOM    597  CZ  ARG A  77      -0.206   9.476  10.379  0.50 13.14           C  
ATOM    599  NH1 ARG A  77      -1.176   8.579  10.224  0.50 11.84           N  
ATOM    601  NH2 ARG A  77      -0.323  10.381  11.341  0.50 13.83           N  
ATOM    603  N   ARG A  78       6.188   7.672  10.220  1.00  5.94           N  
ATOM    604  CA  ARG A  78       7.071   8.045  11.286  1.00  5.87           C  
ATOM    605  C   ARG A  78       8.329   7.216  11.382  1.00  4.35           C  
ATOM    606  O   ARG A  78       8.352   6.027  11.032  1.00  4.53           O  
ATOM    607  CB  ARG A  78       6.348   7.982  12.648  1.00  7.78           C  
ATOM    608  CG  ARG A  78       5.236   8.968  12.775  1.00  9.58           C  
ATOM    609  CD  ARG A  78       4.801   9.138  14.199  1.00 13.46           C  
ATOM    610  NE  ARG A  78       3.704  10.101  14.235  1.00 19.28           N  
ATOM    611  CZ  ARG A  78       3.000  10.371  15.323  1.00 18.85           C  
ATOM    612  NH1 ARG A  78       3.272   9.757  16.459  1.00 20.55           N  
ATOM    613  NH2 ARG A  78       2.015  11.254  15.254  1.00 22.36           N  
ATOM    614  N   LEU A  79       9.375   7.857  11.904  1.00  3.35           N  
ATOM    615  CA  LEU A  79      10.593   7.176  12.281  1.00  3.11           C  
ATOM    616  C   LEU A  79      10.423   6.905  13.776  1.00  3.48           C  
ATOM    617  O   LEU A  79      10.179   7.843  14.547  1.00  3.26           O  
ATOM    618  CB  LEU A  79      11.766   8.152  12.036  1.00  3.52           C  
ATOM    619  CG  LEU A  79      13.129   7.822  12.571  1.00  5.79           C  
ATOM    620  CD1 LEU A  79      13.611   6.462  12.118  1.00  7.38           C  
ATOM    621  CD2 LEU A  79      14.104   8.951  12.167  1.00  4.16           C  
ATOM    622  N   HIS A  80      10.542   5.630  14.155  1.00  2.13           N  
ATOM    623  CA  HIS A  80      10.305   5.199  15.506  1.00  2.00           C  
ATOM    624  C   HIS A  80      11.545   4.881  16.360  1.00  2.16           C  
ATOM    625  O   HIS A  80      11.576   5.181  17.556  1.00  2.37           O  
ATOM    626  CB  HIS A  80       9.362   4.014  15.476  1.00  3.02           C  
ATOM    627  CG  HIS A  80       7.971   4.362  15.046  1.00  2.95           C  
ATOM    628  ND1 HIS A  80       7.129   5.097  15.843  1.00  6.40           N  
ATOM    629  CD2 HIS A  80       7.246   4.016  13.955  1.00  5.48           C  
ATOM    630  CE1 HIS A  80       5.951   5.225  15.251  1.00  5.25           C  
ATOM    631  NE2 HIS A  80       6.003   4.569  14.114  1.00  2.00           N  
ATOM    632  N   THR A  81      12.534   4.205  15.786  1.00  2.79           N  
ATOM    633  CA  THR A  81      13.689   3.723  16.536  1.00  2.53           C  
ATOM    634  C   THR A  81      14.949   3.814  15.723  1.00  2.53           C  
ATOM    635  O   THR A  81      14.958   3.535  14.514  1.00  2.60           O  
ATOM    636  CB  THR A  81      13.470   2.237  16.931  1.00  5.29           C  
ATOM    637  OG1 THR A  81      12.115   2.110  17.455  1.00  7.88           O  
ATOM    638  CG2 THR A  81      14.482   1.801  17.975  1.00  8.20           C  
ATOM    639  N   LEU A  82      16.019   4.139  16.431  1.00  2.00           N  
ATOM    640  CA  LEU A  82      17.370   4.238  15.859  1.00  2.00           C  
ATOM    641  C   LEU A  82      18.310   3.306  16.631  1.00  2.39           C  
ATOM    642  O   LEU A  82      18.086   3.029  17.796  1.00  2.37           O  
ATOM    643  CB  LEU A  82      17.883   5.665  16.018  1.00  2.00           C  
ATOM    644  CG  LEU A  82      17.067   6.758  15.314  1.00  4.25           C  
ATOM    645  CD1 LEU A  82      17.392   8.086  15.867  1.00  7.55           C  
ATOM    646  CD2 LEU A  82      17.326   6.666  13.781  1.00  4.27           C  
HETATM  647  N   MSE A  83      19.358   2.843  15.961  1.00  2.29           N  
HETATM  648  CA  MSE A  83      20.509   2.186  16.608  1.00  3.90           C  
HETATM  649  C   MSE A  83      21.703   3.072  16.399  1.00  4.60           C  
HETATM  650  O   MSE A  83      22.019   3.439  15.252  1.00  6.16           O  
HETATM  651  CB  MSE A  83      20.758   0.817  15.985  1.00  5.55           C  
HETATM  652  CG  MSE A  83      21.832  -0.002  16.663  1.00  6.44           C  
HETATM  653 SE   MSE A  83      21.247  -0.610  18.435  0.70 12.29          SE  
HETATM  654  CE  MSE A  83      20.332  -2.239  18.005  1.00 15.04           C  
ATOM    655  N   ALA A  84      22.373   3.415  17.490  1.00  4.65           N  
ATOM    656  CA  ALA A  84      23.517   4.335  17.429  1.00  3.33           C  
ATOM    657  C   ALA A  84      24.780   3.655  17.880  1.00  3.89           C  
ATOM    658  O   ALA A  84      24.756   2.783  18.777  1.00  4.68           O  
ATOM    659  CB  ALA A  84      23.283   5.525  18.282  1.00  5.33           C  
ATOM    660  N   THR A  85      25.896   4.060  17.259  1.00  4.21           N  
ATOM    661  CA  THR A  85      27.223   3.651  17.712  1.00  6.73           C  
ATOM    662  C   THR A  85      28.117   4.858  17.503  1.00  7.40           C  
ATOM    663  O   THR A  85      27.785   5.773  16.733  1.00  5.21           O  
ATOM    664  CB  THR A  85      27.757   2.449  16.941  1.00  8.73           C  
ATOM    665  OG1 THR A  85      27.765   2.737  15.545  1.00 10.41           O  
ATOM    666  CG2 THR A  85      26.913   1.237  17.206  1.00 11.44           C  
ATOM    667  N   ARG A  86      29.255   4.861  18.205  0.50  8.86           N  
ATOM    669  CA  ARG A  86      30.263   5.914  18.045  0.50 10.38           C  
ATOM    671  C   ARG A  86      31.086   5.723  16.767  0.50 11.74           C  
ATOM    673  O   ARG A  86      31.549   4.620  16.470  0.50 12.40           O  
ATOM    675  CB  ARG A  86      31.188   5.955  19.280  0.50 10.39           C  
ATOM    677  CG  ARG A  86      30.511   6.575  20.517  0.50 10.94           C  
ATOM    679  CD  ARG A  86      31.504   7.014  21.615  0.50 10.12           C  
ATOM    681  NE  ARG A  86      30.836   7.696  22.751  0.50  9.59           N  
ATOM    683  CZ  ARG A  86      30.362   8.949  22.754  0.50  9.41           C  
ATOM    685  NH1 ARG A  86      30.428   9.713  21.679  0.50 11.35           N  
ATOM    687  NH2 ARG A  86      29.803   9.459  23.855  0.50  8.69           N  
ATOM    689  N   VAL A  87      31.277   6.807  16.022  0.50 13.06           N  
ATOM    691  CA  VAL A  87      32.045   6.775  14.775  0.50 14.55           C  
ATOM    693  C   VAL A  87      33.454   6.310  15.094  0.50 16.05           C  
ATOM    695  O   VAL A  87      33.984   6.655  16.146  0.50 16.51           O  
ATOM    697  CB  VAL A  87      32.127   8.178  14.131  0.50 14.41           C  
ATOM    699  CG1 VAL A  87      32.960   9.113  15.016  0.50 14.79           C  
ATOM    701  CG2 VAL A  87      32.718   8.105  12.711  0.50 13.53           C  
ATOM    703  N   LYS A  88      34.051   5.526  14.197  1.00 17.87           N  
ATOM    704  CA  LYS A  88      35.447   5.079  14.366  1.00 19.16           C  
ATOM    705  C   LYS A  88      36.485   5.806  13.486  1.00 20.63           C  
ATOM    706  O   LYS A  88      36.214   6.849  12.868  1.00 22.19           O  
ATOM    707  CB  LYS A  88      35.554   3.567  14.111  1.00 20.52           C  
ATOM    708  CG  LYS A  88      34.943   3.078  12.795  1.00 22.97           C  
ATOM    709  CD  LYS A  88      35.544   1.726  12.351  1.00 22.75           C  
ATOM    710  CE  LYS A  88      36.636   1.876  11.292  1.00 25.35           C  
ATOM    711  NZ  LYS A  88      36.941   0.564  10.606  1.00 26.91           N  
TER     712      LYS A  88                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
