
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  192 ( 1503),  selected  192 , name 2ibd_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 2ibd_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    S    13_A      -       -           -
LGA    G    14_A      D       5          3.923
LGA    R    15_A      C       6          3.264
LGA    R    16_A      R       7          1.526
LGA    T    17_A      S       8          2.393
LGA    E    18_A      R       9          2.797
LGA    L    19_A      L      10          1.788
LGA    L    20_A      M      11          1.071
LGA    D    21_A      E      12          2.285
LGA    I    22_A      V      13          2.043
LGA    A    23_A      A      14          1.262
LGA    A    24_A      T      15          1.337
LGA    T    25_A      E      16          1.849
LGA    L    26_A      L      17          1.764
LGA    F    27_A      F      18          1.540
LGA    A    28_A      A      19          1.715
LGA    E    29_A      Q      20          1.802
LGA    R    30_A      K      21          1.623
LGA    G    31_A      G      22          1.710
LGA    L    32_A      F      23          1.681
LGA    R    33_A      Y      24          0.545
LGA    A    34_A      G      25          0.823
LGA    T    35_A      V      26          1.389
LGA    T    36_A      S      27          1.514
LGA    V    37_A      I      28          2.009
LGA    R    38_A      R      29          2.162
LGA    D    39_A      E      30          2.252
LGA    I    40_A      L      31          2.360
LGA    A    41_A      A      32          2.702
LGA    D    42_A      Q      33          3.020
LGA    A    43_A      A      34          2.820
LGA    A    44_A      A      35          2.647
LGA    G    45_A      G      36          4.197
LGA    I    46_A      A      37          4.446
LGA    L    47_A      S      38          4.423
LGA    S    48_A      I      39          3.091
LGA    G    49_A      S      40          3.509
LGA    S    50_A      M      41          4.226
LGA    L    51_A      I      42          3.441
LGA    Y    52_A      S      43          3.601
LGA    H    53_A      Y      44           #
LGA    H    54_A      H      45          4.494
LGA    F    55_A      F      46          1.084
LGA    D    56_A      G      47          0.865
LGA    S    57_A      G      48          1.683
LGA    K    58_A      K      49          1.536
LGA    E    59_A      E      50          1.545
LGA    S    60_A      G      51          1.490
LGA    X    61_A      L      52          1.611
LGA    V    62_A      Y      53          1.963
LGA    D    63_A      A      54          1.522
LGA    E    64_A      A      55          1.493
LGA    I    65_A      V      56          1.922
LGA    L    66_A      L      57          2.054
LGA    R    67_A      Q      58          1.872
LGA    G    68_A      E      59          2.307
LGA    F    69_A      Q      60          3.225
LGA    L    70_A      F      61          2.382
LGA    D    71_A      A      62          3.022
LGA    D    72_A      C      63          2.282
LGA    L    73_A      F      64          2.406
LGA    F    74_A      G      65          2.688
LGA    G    75_A      Q      66          1.218
LGA    K    76_A      L      67          2.291
LGA    Y    77_A      -       -           -
LGA    R    78_A      D      68          4.453
LGA    E    79_A      D      69          4.965
LGA    I    80_A      I      70          2.095
LGA    V    81_A      R      71          1.350
LGA    A    82_A      G      72          3.498
LGA    S    83_A      Q      73          4.200
LGA    G    84_A      A      74          4.582
LGA    L    85_A      G      75           #
LGA    D    86_A      D      76          1.958
LGA    S    87_A      P      77          1.281
LGA    R    88_A      L      78          0.971
LGA    A    89_A      A      79          1.361
LGA    T    90_A      V      80          1.135
LGA    L    91_A      M      81          0.953
LGA    E    92_A      T      82          1.064
LGA    A    93_A      A      83          0.786
LGA    L    94_A      Y      84          1.235
LGA    V    95_A      L      85          1.851
LGA    T    96_A      R      86          1.462
LGA    T    97_A      W      87          1.089
LGA    S    98_A      T      88          1.525
LGA    Y    99_A      I      89          1.688
LGA    E   100_A      Q      90          1.205
LGA    A   101_A      R      91          1.334
LGA    I   102_A      H      92          1.294
LGA    D   103_A      R      93          1.851
LGA    A   104_A      N      94          1.688
LGA    S   105_A      N      95          2.481
LGA    H   106_A      P      96          2.537
LGA    S   107_A      Q      97          1.886
LGA    A   108_A      L      98          3.635
LGA    V   109_A      L      99          3.815
LGA    A   110_A      R     100          2.002
LGA    I   111_A      F     101          0.402
LGA    Y   112_A      Y     102          1.871
LGA    Q   113_A      T     103          2.485
LGA    D   114_A      S     104          2.444
LGA    E   115_A      E     105          3.090
LGA    V   116_A      L     106          4.640
LGA    K   117_A      T     107          3.998
LGA    H   118_A      N     108          4.079
LGA    L   119_A      P     109          3.487
LGA    V   120_A      T     110           #
LGA    A   121_A      -       -           -
LGA    N   122_A      P     111          2.751
LGA    E   123_A      -       -           -
LGA    R   124_A      C     112           #
LGA    F   125_A      F     113          4.947
LGA    T   126_A      A     114          3.215
LGA    Y   127_A      A     115          2.770
LGA    L   128_A      I     116          3.430
LGA    -       -      V     117           -
LGA    S   129_A      S     118          3.267
LGA    E   130_A      P     119          3.066
LGA    L   131_A      A     120          3.215
LGA    N   132_A      I     121          3.899
LGA    T   133_A      A     122          3.422
LGA    E   134_A      S     123          2.290
LGA    F   135_A      V     124          2.584
LGA    R   136_A      I     125          2.667
LGA    E   137_A      R     126          1.705
LGA    L   138_A      L     127          0.911
LGA    W   139_A      L     128          1.470
LGA    X   140_A      A     129          0.843
LGA    G   141_A      E     130          0.834
LGA    V   142_A      S     131          1.685
LGA    L   143_A      I     132          1.690
LGA    E   144_A      E     133          1.592
LGA    A   145_A      A     134          2.036
LGA    G   146_A      G     135          2.747
LGA    V   147_A      M     136          3.072
LGA    K   148_A      T     137          3.242
LGA    D   149_A      R     138          3.543
LGA    G   150_A      G     139          4.716
LGA    S   151_A      L     140          4.481
LGA    F   152_A      F     141          4.017
LGA    R   153_A      R     142          4.558
LGA    S   154_A      R     143          4.601
LGA    D   155_A      D     144          5.108
LGA    I   156_A      L     145          3.948
LGA    D   157_A      H     146          3.533
LGA    V   158_A      A     147          2.527
LGA    E   159_A      V     148          3.043
LGA    L   160_A      N     149          2.483
LGA    A   161_A      S     150          1.465
LGA    F   162_A      A     151          1.872
LGA    R   163_A      L     152          2.163
LGA    F   164_A      A     153          1.664
LGA    L   165_A      L     154          2.769
LGA    R   166_A      A     155          3.643
LGA    D   167_A      G     156          3.639
LGA    T   168_A      M     157          4.373
LGA    A   169_A      V     158          4.833
LGA    W   170_A      N     159          3.412
LGA    V   171_A      Y     160          3.620
LGA    -       -      F     161           -
LGA    A   172_A      F     162          1.245
LGA    V   173_A      L     163          4.419
LGA    R   174_A      S     164           #
LGA    W   175_A      T     165          3.425
LGA    Y   176_A      L     166           -
LGA    R   177_A      A     167           -
LGA    P   178_A      T     168           -
LGA    G   179_A      E     169           -
LGA    G   180_A      G     170           -
LGA    S   181_A      L     171           -
LGA    -       -      T     172           -
LGA    -       -      S     173           -
LGA    V   182_A      H     174          4.954
LGA    T   183_A      S     175          4.713
LGA    V   184_A      P     176          4.126
LGA    D   185_A      D     177           #
LGA    T   186_A      Q     178          2.684
LGA    V   187_A      D     179          3.335
LGA    A   188_A      -       -           -
LGA    K   189_A      E     180          3.058
LGA    Q   190_A      E     181          4.094
LGA    Y   191_A      L     182          3.908
LGA    L   192_A      I     183          2.928
LGA    S   193_A      R     184          2.964
LGA    I   194_A      Q     185          3.250
LGA    V   195_A      Y     186          2.855
LGA    L   196_A      V     187          2.440
LGA    D   197_A      A     188          1.409
LGA    G   198_A      I     189          2.972
LGA    -       -      F     190           -
LGA    -       -      T     191           -
LGA    -       -      R     192           -
LGA    -       -      G     193           -
LGA    L   199_A      I     194          4.980
LGA    A   200_A      -       -           -
LGA    S   201_A      M     195           #
LGA    P   202_A      A     196          3.930

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  192  192    5.0    171    2.85    19.88     53.816     5.803

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.124167 * X  +  -0.424949 * Y  +   0.896661 * Z  + -27.459234
  Y_new =   0.578702 * X  +  -0.765067 * Y  +  -0.282446 * Z  +  35.297615
  Z_new =   0.806031 * X  +   0.483829 * Y  +   0.340915 * Z  + -19.985561 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.956978   -2.184615  [ DEG:    54.8308   -125.1692 ]
  Theta =  -0.937415   -2.204177  [ DEG:   -53.7099   -126.2901 ]
  Phi   =   1.782153   -1.359440  [ DEG:   102.1098    -77.8902 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ibd_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ibd_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  192  192   5.0  171   2.85   19.88  53.816
REMARK  ---------------------------------------------------------- 
MOLECULE 2ibd_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   11-SEP-06   2IBD              
TITLE     CRYSTAL STRUCTURE OF PROBABLE TRANSCRIPTIONAL REGULATORY              
TITLE    2 PROTEIN RHA5900                                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: POSSIBLE TRANSCRIPTIONAL REGULATOR;                        
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOCOCCUS SP.;                                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: RHA1;                                                        
SOURCE   5 GENE: RHA1_RO04598;                                                  
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) DERIVATIVES;                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET DERIVATIVES                           
KEYWDS    PROBABLE TRANSCRIPTIONAL REGULATORY PROTEIN, RHODOCOCCUS              
KEYWDS   2 SP. RHA1, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE              
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,E.EVDOKIMOVA,O.KAGAN,A.SAVCHENKO,A.M.EDWARDS,                 
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   2   14-AUG-07 2IBD    1       AUTHOR JRNL                              
REVDAT   1   10-OCT-06 2IBD    0                                                
JRNL        AUTH   C.CHANG,E.EVDOKIMOVA,O.KAGAN,A.SAVCHENKO,                    
JRNL        AUTH 2 A.M.EDWARDS,A.JOACHIMIAK                                     
JRNL        TITL   CRYSTAL STRUCTURE OF PROBABLE TRANSCRIPTIONAL                
JRNL        TITL 2 REGULATORY PROTEIN RHA5900                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2IBD A    1   204  UNP    Q0S7V2   Q0S7V2_RHOSR     1    204             
DBREF  2IBD B    1   204  UNP    Q0S7V2   Q0S7V2_RHOSR     1    204             
SEQRES   1 A  204  MSE THR PRO PRO PRO ALA ASP ASP THR SER GLY LYS SER          
SEQRES   2 A  204  GLY ARG ARG THR GLU LEU LEU ASP ILE ALA ALA THR LEU          
SEQRES   3 A  204  PHE ALA GLU ARG GLY LEU ARG ALA THR THR VAL ARG ASP          
SEQRES   4 A  204  ILE ALA ASP ALA ALA GLY ILE LEU SER GLY SER LEU TYR          
SEQRES   5 A  204  HIS HIS PHE ASP SER LYS GLU SER MSE VAL ASP GLU ILE          
SEQRES   6 A  204  LEU ARG GLY PHE LEU ASP ASP LEU PHE GLY LYS TYR ARG          
SEQRES   7 A  204  GLU ILE VAL ALA SER GLY LEU ASP SER ARG ALA THR LEU          
SEQRES   8 A  204  GLU ALA LEU VAL THR THR SER TYR GLU ALA ILE ASP ALA          
SEQRES   9 A  204  SER HIS SER ALA VAL ALA ILE TYR GLN ASP GLU VAL LYS          
SEQRES  10 A  204  HIS LEU VAL ALA ASN GLU ARG PHE THR TYR LEU SER GLU          
SEQRES  11 A  204  LEU ASN THR GLU PHE ARG GLU LEU TRP MSE GLY VAL LEU          
SEQRES  12 A  204  GLU ALA GLY VAL LYS ASP GLY SER PHE ARG SER ASP ILE          
SEQRES  13 A  204  ASP VAL GLU LEU ALA PHE ARG PHE LEU ARG ASP THR ALA          
SEQRES  14 A  204  TRP VAL ALA VAL ARG TRP TYR ARG PRO GLY GLY SER VAL          
SEQRES  15 A  204  THR VAL ASP THR VAL ALA LYS GLN TYR LEU SER ILE VAL          
SEQRES  16 A  204  LEU ASP GLY LEU ALA SER PRO HIS ASN                          
SEQRES   1 B  204  MSE THR PRO PRO PRO ALA ASP ASP THR SER GLY LYS SER          
SEQRES   2 B  204  GLY ARG ARG THR GLU LEU LEU ASP ILE ALA ALA THR LEU          
SEQRES   3 B  204  PHE ALA GLU ARG GLY LEU ARG ALA THR THR VAL ARG ASP          
SEQRES   4 B  204  ILE ALA ASP ALA ALA GLY ILE LEU SER GLY SER LEU TYR          
SEQRES   5 B  204  HIS HIS PHE ASP SER LYS GLU SER MSE VAL ASP GLU ILE          
SEQRES   6 B  204  LEU ARG GLY PHE LEU ASP ASP LEU PHE GLY LYS TYR ARG          
SEQRES   7 B  204  GLU ILE VAL ALA SER GLY LEU ASP SER ARG ALA THR LEU          
SEQRES   8 B  204  GLU ALA LEU VAL THR THR SER TYR GLU ALA ILE ASP ALA          
SEQRES   9 B  204  SER HIS SER ALA VAL ALA ILE TYR GLN ASP GLU VAL LYS          
SEQRES  10 B  204  HIS LEU VAL ALA ASN GLU ARG PHE THR TYR LEU SER GLU          
SEQRES  11 B  204  LEU ASN THR GLU PHE ARG GLU LEU TRP MSE GLY VAL LEU          
SEQRES  12 B  204  GLU ALA GLY VAL LYS ASP GLY SER PHE ARG SER ASP ILE          
SEQRES  13 B  204  ASP VAL GLU LEU ALA PHE ARG PHE LEU ARG ASP THR ALA          
SEQRES  14 B  204  TRP VAL ALA VAL ARG TRP TYR ARG PRO GLY GLY SER VAL          
SEQRES  15 B  204  THR VAL ASP THR VAL ALA LYS GLN TYR LEU SER ILE VAL          
SEQRES  16 B  204  LEU ASP GLY LEU ALA SER PRO HIS ASN                          
HET    MSE  A  61       8                                                       
HET    MSE  A 140       8                                                       
HET    MSE  B  61       8                                                       
HET    MSE  B 140       8                                                       
HET     MG  B 301       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   MG    MG 2+                                                        
FORMUL   4  HOH   *485(H2 O)                                                    
CRYST1   70.588  118.778   97.173  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   GLY A  11      -9.575  29.839   1.571  1.00 31.26           N  
ATOM      2  CA  GLY A  11     -10.065  31.159   2.058  1.00 29.28           C  
ATOM      3  C   GLY A  11     -11.254  31.691   1.219  1.00 28.11           C  
ATOM      4  O   GLY A  11     -12.400  31.760   1.714  1.00 26.67           O  
ATOM      5  N   LYS A  12     -10.980  32.009  -0.051  1.00 26.56           N  
ATOM      6  CA  LYS A  12     -11.943  32.692  -0.943  1.00 25.52           C  
ATOM      7  C   LYS A  12     -13.198  31.872  -1.246  1.00 23.80           C  
ATOM      8  O   LYS A  12     -14.318  32.399  -1.165  1.00 21.88           O  
ATOM      9  CB  LYS A  12     -11.276  33.130  -2.267  1.00 26.15           C  
ATOM     10  CG  LYS A  12     -12.170  34.095  -3.080  1.00 26.94           C  
ATOM     11  CD  LYS A  12     -11.823  34.203  -4.585  1.00 27.63           C  
ATOM     12  CE  LYS A  12     -13.018  34.772  -5.407  1.00 28.09           C  
ATOM     13  NZ  LYS A  12     -14.408  34.191  -5.025  1.00 27.59           N  
ATOM     14  N   SER A  13     -13.006  30.596  -1.593  1.00 23.02           N  
ATOM     15  CA  SER A  13     -14.113  29.685  -1.902  1.00 22.10           C  
ATOM     16  C   SER A  13     -15.060  29.507  -0.719  1.00 21.28           C  
ATOM     17  O   SER A  13     -16.279  29.463  -0.891  1.00 20.02           O  
ATOM     18  CB  SER A  13     -13.575  28.319  -2.325  1.00 23.78           C  
ATOM     19  OG  SER A  13     -13.125  28.359  -3.656  1.00 26.71           O  
ATOM     20  N   GLY A  14     -14.502  29.368   0.486  1.00 19.31           N  
ATOM     21  CA  GLY A  14     -15.339  29.272   1.684  1.00 19.01           C  
ATOM     22  C   GLY A  14     -16.122  30.545   1.973  1.00 18.51           C  
ATOM     23  O   GLY A  14     -17.301  30.497   2.355  1.00 17.95           O  
ATOM     24  N   ARG A  15     -15.459  31.691   1.819  1.00 18.94           N  
ATOM     25  CA  ARG A  15     -16.134  32.982   1.953  1.00 18.76           C  
ATOM     26  C   ARG A  15     -17.267  33.142   0.947  1.00 19.17           C  
ATOM     27  O   ARG A  15     -18.350  33.615   1.307  1.00 19.85           O  
ATOM     28  CB  ARG A  15     -15.136  34.132   1.808  1.00 19.61           C  
ATOM     29  CG  ARG A  15     -15.768  35.521   1.863  1.00 20.81           C  
ATOM     30  CD  ARG A  15     -16.499  35.773   3.174  1.00 24.42           C  
ATOM     31  NE  ARG A  15     -16.739  37.199   3.391  1.00 24.89           N  
ATOM     32  CZ  ARG A  15     -17.582  37.683   4.300  1.00 27.35           C  
ATOM     33  NH1 ARG A  15     -18.267  36.859   5.093  1.00 27.42           N  
ATOM     34  NH2 ARG A  15     -17.736  38.998   4.429  1.00 28.30           N  
ATOM     35  N   ARG A  16     -17.032  32.743  -0.298  1.00 19.35           N  
ATOM     36  CA  ARG A  16     -18.072  32.791  -1.319  1.00 20.03           C  
ATOM     37  C   ARG A  16     -19.297  32.009  -0.864  1.00 20.00           C  
ATOM     38  O   ARG A  16     -20.418  32.494  -0.894  1.00 19.88           O  
ATOM     39  CB  ARG A  16     -17.553  32.246  -2.654  1.00 20.19           C  
ATOM     40  CG  ARG A  16     -18.484  32.526  -3.796  1.00 22.84           C  
ATOM     41  CD  ARG A  16     -17.796  32.180  -5.099  1.00 24.58           C  
ATOM     42  NE  ARG A  16     -18.588  32.569  -6.265  1.00 28.34           N  
ATOM     43  CZ  ARG A  16     -19.661  31.903  -6.686  1.00 29.40           C  
ATOM     44  NH1 ARG A  16     -20.079  30.838  -6.015  1.00 28.54           N  
ATOM     45  NH2 ARG A  16     -20.320  32.321  -7.767  1.00 30.41           N  
ATOM     46  N   THR A  17     -19.072  30.792  -0.391  1.00 19.70           N  
ATOM     47  CA  THR A  17     -20.160  29.966   0.072  1.00 19.27           C  
ATOM     48  C   THR A  17     -20.915  30.617   1.237  1.00 19.02           C  
ATOM     49  O   THR A  17     -22.150  30.588   1.278  1.00 19.20           O  
ATOM     50  CB  THR A  17     -19.641  28.590   0.460  1.00 19.62           C  
ATOM     51  OG1 THR A  17     -19.034  28.006  -0.695  1.00 20.14           O  
ATOM     52  CG2 THR A  17     -20.773  27.688   0.947  1.00 20.72           C  
ATOM     53  N   GLU A  18     -20.177  31.206   2.171  1.00 18.82           N  
ATOM     54  CA  GLU A  18     -20.784  31.905   3.312  1.00 20.24           C  
ATOM     55  C   GLU A  18     -21.671  33.071   2.875  1.00 19.36           C  
ATOM     56  O   GLU A  18     -22.792  33.232   3.393  1.00 19.46           O  
ATOM     57  CB  GLU A  18     -19.699  32.415   4.261  1.00 20.08           C  
ATOM     58  CG  GLU A  18     -20.208  33.278   5.406  1.00 22.59           C  
ATOM     59  CD  GLU A  18     -19.099  33.755   6.308  1.00 23.25           C  
ATOM     60  OE1 GLU A  18     -18.010  34.114   5.798  1.00 25.70           O  
ATOM     61  OE2 GLU A  18     -19.323  33.769   7.542  1.00 28.79           O  
ATOM     62  N   LEU A  19     -21.184  33.857   1.912  1.00 19.21           N  
ATOM     63  CA  LEU A  19     -21.922  35.004   1.418  1.00 18.56           C  
ATOM     64  C   LEU A  19     -23.201  34.550   0.724  1.00 18.59           C  
ATOM     65  O   LEU A  19     -24.275  35.164   0.865  1.00 19.36           O  
ATOM     66  CB  LEU A  19     -21.046  35.764   0.416  1.00 19.15           C  
ATOM     67  CG  LEU A  19     -19.912  36.532   1.070  1.00 20.66           C  
ATOM     68  CD1 LEU A  19     -19.068  37.146  -0.018  1.00 21.48           C  
ATOM     69  CD2 LEU A  19     -20.446  37.617   2.033  1.00 20.54           C  
ATOM     70  N   LEU A  20     -23.089  33.455  -0.020  1.00 18.96           N  
ATOM     71  CA  LEU A  20     -24.226  32.929  -0.744  1.00 18.91           C  
ATOM     72  C   LEU A  20     -25.304  32.434   0.233  1.00 18.39           C  
ATOM     73  O   LEU A  20     -26.503  32.648   0.005  1.00 19.55           O  
ATOM     74  CB  LEU A  20     -23.779  31.791  -1.663  1.00 19.80           C  
ATOM     75  CG  LEU A  20     -24.803  31.421  -2.736  1.00 21.12           C  
ATOM     76  CD1 LEU A  20     -25.087  32.609  -3.669  1.00 20.93           C  
ATOM     77  CD2 LEU A  20     -24.312  30.233  -3.543  1.00 22.05           C  
ATOM     78  N   ASP A  21     -24.881  31.791   1.321  0.50 17.66           N  
ATOM     80  CA  ASP A  21     -25.829  31.326   2.329  0.50 17.17           C  
ATOM     82  C   ASP A  21     -26.499  32.500   3.076  0.50 16.93           C  
ATOM     84  O   ASP A  21     -27.692  32.437   3.396  0.50 17.05           O  
ATOM     86  CB  ASP A  21     -25.163  30.353   3.309  0.50 17.20           C  
ATOM     88  CG  ASP A  21     -26.128  29.842   4.349  0.50 18.19           C  
ATOM     90  OD1 ASP A  21     -27.109  29.172   3.973  0.50 19.76           O  
ATOM     92  OD2 ASP A  21     -25.909  30.120   5.543  0.50 20.52           O  
ATOM     94  N   ILE A  22     -25.745  33.575   3.326  1.00 16.53           N  
ATOM     95  CA  ILE A  22     -26.325  34.796   3.905  1.00 16.61           C  
ATOM     96  C   ILE A  22     -27.392  35.384   2.953  1.00 16.05           C  
ATOM     97  O   ILE A  22     -28.502  35.746   3.378  1.00 17.01           O  
ATOM     98  CB  ILE A  22     -25.212  35.843   4.187  1.00 17.38           C  
ATOM     99  CG1 ILE A  22     -24.388  35.382   5.388  1.00 18.28           C  
ATOM    100  CG2 ILE A  22     -25.813  37.220   4.496  1.00 18.18           C  
ATOM    101  CD1 ILE A  22     -23.147  36.217   5.666  1.00 18.44           C  
ATOM    102  N   ALA A  23     -27.068  35.437   1.663  1.00 16.53           N  
ATOM    103  CA  ALA A  23     -28.036  35.928   0.687  1.00 15.87           C  
ATOM    104  C   ALA A  23     -29.280  35.028   0.708  1.00 15.79           C  
ATOM    105  O   ALA A  23     -30.401  35.525   0.718  1.00 16.60           O  
ATOM    106  CB  ALA A  23     -27.448  35.930  -0.692  1.00 16.02           C  
ATOM    107  N   ALA A  24     -29.078  33.715   0.696  1.00 15.15           N  
ATOM    108  CA  ALA A  24     -30.235  32.792   0.670  1.00 14.51           C  
ATOM    109  C   ALA A  24     -31.176  33.051   1.831  1.00 14.91           C  
ATOM    110  O   ALA A  24     -32.401  33.027   1.685  1.00 16.13           O  
ATOM    111  CB  ALA A  24     -29.776  31.353   0.657  1.00 14.61           C  
ATOM    112  N   THR A  25     -30.596  33.275   3.005  1.00 15.04           N  
ATOM    113  CA  THR A  25     -31.378  33.456   4.226  1.00 16.29           C  
ATOM    114  C   THR A  25     -32.193  34.748   4.117  1.00 15.26           C  
ATOM    115  O   THR A  25     -33.371  34.777   4.474  1.00 16.03           O  
ATOM    116  CB  THR A  25     -30.409  33.527   5.418  1.00 17.77           C  
ATOM    117  OG1 THR A  25     -29.738  32.255   5.562  1.00 20.57           O  
ATOM    118  CG2 THR A  25     -31.172  33.871   6.685  1.00 19.13           C  
ATOM    119  N   LEU A  26     -31.581  35.812   3.579  1.00 15.48           N  
ATOM    120  CA  LEU A  26     -32.302  37.085   3.419  1.00 15.75           C  
ATOM    121  C   LEU A  26     -33.389  36.940   2.379  1.00 15.95           C  
ATOM    122  O   LEU A  26     -34.518  37.425   2.560  1.00 16.21           O  
ATOM    123  CB  LEU A  26     -31.359  38.232   3.003  1.00 16.73           C  
ATOM    124  CG  LEU A  26     -30.494  38.757   4.135  1.00 19.13           C  
ATOM    125  CD1 LEU A  26     -29.316  39.559   3.603  1.00 22.89           C  
ATOM    126  CD2 LEU A  26     -31.365  39.608   5.038  1.00 22.22           C  
ATOM    127  N   PHE A  27     -33.068  36.279   1.262  1.00 15.58           N  
ATOM    128  CA  PHE A  27     -34.101  36.089   0.249  1.00 15.05           C  
ATOM    129  C   PHE A  27     -35.286  35.307   0.793  1.00 14.97           C  
ATOM    130  O   PHE A  27     -36.448  35.608   0.463  1.00 16.15           O  
ATOM    131  CB  PHE A  27     -33.583  35.320  -0.956  1.00 16.01           C  
ATOM    132  CG  PHE A  27     -32.471  36.017  -1.728  1.00 15.07           C  
ATOM    133  CD1 PHE A  27     -32.401  37.410  -1.839  1.00 16.76           C  
ATOM    134  CD2 PHE A  27     -31.490  35.250  -2.377  1.00 16.36           C  
ATOM    135  CE1 PHE A  27     -31.379  38.018  -2.590  1.00 18.00           C  
ATOM    136  CE2 PHE A  27     -30.446  35.867  -3.123  1.00 16.09           C  
ATOM    137  CZ  PHE A  27     -30.397  37.238  -3.221  1.00 16.94           C  
ATOM    138  N   ALA A  28     -35.003  34.273   1.595  1.00 14.63           N  
ATOM    139  CA  ALA A  28     -36.093  33.461   2.158  1.00 15.22           C  
ATOM    140  C   ALA A  28     -36.962  34.256   3.126  1.00 16.23           C  
ATOM    141  O   ALA A  28     -38.185  34.058   3.201  1.00 17.49           O  
ATOM    142  CB  ALA A  28     -35.516  32.251   2.856  1.00 15.90           C  
ATOM    143  N   GLU A  29     -36.335  35.154   3.881  1.00 16.98           N  
ATOM    144  CA  GLU A  29     -37.096  35.907   4.853  1.00 18.42           C  
ATOM    145  C   GLU A  29     -37.852  37.067   4.212  1.00 19.45           C  
ATOM    146  O   GLU A  29     -39.085  37.174   4.338  1.00 20.42           O  
ATOM    147  CB  GLU A  29     -36.184  36.412   5.965  1.00 17.53           C  
ATOM    148  CG  GLU A  29     -36.960  37.113   7.050  1.00 19.32           C  
ATOM    149  CD  GLU A  29     -37.858  36.128   7.806  1.00 20.32           C  
ATOM    150  OE1 GLU A  29     -37.305  35.168   8.435  1.00 19.50           O  
ATOM    151  OE2 GLU A  29     -39.112  36.276   7.743  1.00 20.90           O  
ATOM    152  N   ARG A  30     -37.104  37.919   3.512  0.50 19.98           N  
ATOM    154  CA  ARG A  30     -37.631  39.175   2.969  0.50 21.00           C  
ATOM    156  C   ARG A  30     -38.290  39.058   1.594  0.50 21.22           C  
ATOM    158  O   ARG A  30     -39.158  39.867   1.234  0.50 21.85           O  
ATOM    160  CB  ARG A  30     -36.502  40.187   2.862  0.50 21.41           C  
ATOM    162  CG  ARG A  30     -35.785  40.522   4.152  0.50 22.04           C  
ATOM    164  CD  ARG A  30     -35.149  41.887   4.000  0.50 27.05           C  
ATOM    166  NE  ARG A  30     -36.115  42.864   3.497  0.50 29.35           N  
ATOM    168  CZ  ARG A  30     -35.846  44.135   3.224  0.50 29.15           C  
ATOM    170  NH1 ARG A  30     -34.626  44.623   3.410  0.50 30.32           N  
ATOM    172  NH2 ARG A  30     -36.811  44.921   2.774  0.50 30.60           N  
ATOM    174  N   GLY A  31     -37.847  38.088   0.807  1.00 20.80           N  
ATOM    175  CA  GLY A  31     -38.300  37.961  -0.550  1.00 21.49           C  
ATOM    176  C   GLY A  31     -37.216  38.442  -1.475  1.00 21.35           C  
ATOM    177  O   GLY A  31     -36.308  39.192  -1.091  1.00 21.95           O  
ATOM    178  N   LEU A  32     -37.308  38.010  -2.720  1.00 21.84           N  
ATOM    179  CA  LEU A  32     -36.294  38.353  -3.698  1.00 22.30           C  
ATOM    180  C   LEU A  32     -36.335  39.815  -4.068  1.00 22.23           C  
ATOM    181  O   LEU A  32     -35.308  40.483  -4.060  1.00 23.21           O  
ATOM    182  CB  LEU A  32     -36.499  37.545  -4.974  1.00 22.98           C  
ATOM    183  CG  LEU A  32     -36.093  36.078  -4.956  1.00 23.85           C  
ATOM    184  CD1 LEU A  32     -36.225  35.519  -6.367  1.00 24.96           C  
ATOM    185  CD2 LEU A  32     -34.667  35.984  -4.495  1.00 26.49           C  
ATOM    186  N   ARG A  33     -37.519  40.314  -4.405  1.00 22.56           N  
ATOM    187  CA  ARG A  33     -37.641  41.671  -4.927  1.00 22.55           C  
ATOM    188  C   ARG A  33     -37.303  42.732  -3.887  1.00 22.02           C  
ATOM    189  O   ARG A  33     -36.838  43.811  -4.248  1.00 23.30           O  
ATOM    190  CB  ARG A  33     -39.046  41.901  -5.498  1.00 22.80           C  
ATOM    191  CG  ARG A  33     -39.371  41.057  -6.711  1.00 24.27           C  
ATOM    192  CD  ARG A  33     -40.883  41.014  -6.952  1.00 29.94           C  
ATOM    193  NE  ARG A  33     -41.255  41.781  -8.133  1.00 33.47           N  
ATOM    194  CZ  ARG A  33     -42.507  42.025  -8.531  1.00 33.83           C  
ATOM    195  NH1 ARG A  33     -43.558  41.569  -7.839  1.00 34.10           N  
ATOM    196  NH2 ARG A  33     -42.702  42.749  -9.627  1.00 34.15           N  
ATOM    197  N   ALA A  34     -37.527  42.435  -2.605  1.00 20.85           N  
ATOM    198  CA  ALA A  34     -37.302  43.400  -1.524  1.00 20.20           C  
ATOM    199  C   ALA A  34     -35.901  43.339  -0.874  1.00 20.22           C  
ATOM    200  O   ALA A  34     -35.624  44.119   0.053  1.00 22.54           O  
ATOM    201  CB  ALA A  34     -38.391  43.216  -0.458  1.00 21.07           C  
ATOM    202  N   THR A  35     -35.016  42.454  -1.345  1.00 18.32           N  
ATOM    203  CA  THR A  35     -33.661  42.305  -0.797  1.00 17.95           C  
ATOM    204  C   THR A  35     -32.638  42.880  -1.770  1.00 18.07           C  
ATOM    205  O   THR A  35     -32.610  42.482  -2.932  1.00 18.69           O  
ATOM    206  CB  THR A  35     -33.303  40.826  -0.561  1.00 18.98           C  
ATOM    207  OG1 THR A  35     -34.190  40.271   0.416  1.00 19.97           O  
ATOM    208  CG2 THR A  35     -31.878  40.689  -0.049  1.00 19.13           C  
ATOM    209  N   THR A  36     -31.813  43.816  -1.308  1.00 17.39           N  
ATOM    210  CA  THR A  36     -30.797  44.408  -2.189  1.00 17.23           C  
ATOM    211  C   THR A  36     -29.419  43.822  -1.928  1.00 17.52           C  
ATOM    212  O   THR A  36     -29.197  43.181  -0.900  1.00 18.24           O  
ATOM    213  CB  THR A  36     -30.723  45.918  -1.999  1.00 17.41           C  
ATOM    214  OG1 THR A  36     -30.260  46.201  -0.668  1.00 19.00           O  
ATOM    215  CG2 THR A  36     -32.059  46.572  -2.286  1.00 17.69           C  
ATOM    216  N   VAL A  37     -28.466  44.120  -2.823  1.00 17.39           N  
ATOM    217  CA  VAL A  37     -27.100  43.690  -2.586  1.00 17.73           C  
ATOM    218  C   VAL A  37     -26.519  44.380  -1.335  1.00 17.63           C  
ATOM    219  O   VAL A  37     -25.697  43.789  -0.631  1.00 18.88           O  
ATOM    220  CB  VAL A  37     -26.197  43.926  -3.830  1.00 18.11           C  
ATOM    221  CG1 VAL A  37     -24.783  43.653  -3.509  1.00 22.68           C  
ATOM    222  CG2 VAL A  37     -26.634  43.012  -4.960  1.00 19.68           C  
ATOM    223  N   ARG A  38     -26.952  45.618  -1.061  1.00 17.21           N  
ATOM    224  CA  ARG A  38     -26.517  46.335   0.153  1.00 17.31           C  
ATOM    225  C   ARG A  38     -27.045  45.606   1.405  1.00 17.36           C  
ATOM    226  O   ARG A  38     -26.312  45.497   2.407  1.00 16.94           O  
ATOM    227  CB  ARG A  38     -26.995  47.788   0.132  1.00 16.89           C  
ATOM    228  CG  ARG A  38     -26.423  48.658   1.261  1.00 17.19           C  
ATOM    229  CD  ARG A  38     -26.899  50.105   1.128  1.00 18.41           C  
ATOM    230  NE  ARG A  38     -26.362  50.718  -0.090  1.00 18.91           N  
ATOM    231  CZ  ARG A  38     -27.046  51.522  -0.913  1.00 20.52           C  
ATOM    232  NH1 ARG A  38     -28.316  51.838  -0.669  1.00 22.80           N  
ATOM    233  NH2 ARG A  38     -26.449  52.031  -1.980  1.00 23.96           N  
ATOM    234  N   ASP A  39     -28.288  45.101   1.346  1.00 17.52           N  
ATOM    235  CA  ASP A  39     -28.827  44.340   2.472  1.00 17.62           C  
ATOM    236  C   ASP A  39     -27.936  43.131   2.728  1.00 18.04           C  
ATOM    237  O   ASP A  39     -27.687  42.800   3.872  1.00 18.66           O  
ATOM    238  CB  ASP A  39     -30.239  43.811   2.199  1.00 17.43           C  
ATOM    239  CG  ASP A  39     -31.284  44.907   2.113  1.00 18.10           C  
ATOM    240  OD1 ASP A  39     -31.094  46.008   2.705  1.00 19.38           O  
ATOM    241  OD2 ASP A  39     -32.341  44.621   1.488  1.00 19.20           O  
ATOM    242  N   ILE A  40     -27.516  42.450   1.652  1.00 17.93           N  
ATOM    243  CA  ILE A  40     -26.694  41.249   1.779  1.00 18.58           C  
ATOM    244  C   ILE A  40     -25.327  41.607   2.345  1.00 19.09           C  
ATOM    245  O   ILE A  40     -24.832  40.995   3.306  1.00 19.71           O  
ATOM    246  CB  ILE A  40     -26.580  40.468   0.418  1.00 18.25           C  
ATOM    247  CG1 ILE A  40     -27.970  40.021  -0.057  1.00 19.11           C  
ATOM    248  CG2 ILE A  40     -25.673  39.262   0.561  1.00 19.59           C  
ATOM    249  CD1 ILE A  40     -27.982  39.641  -1.558  1.00 19.91           C  
ATOM    250  N   ALA A  41     -24.715  42.616   1.750  1.00 18.99           N  
ATOM    251  CA  ALA A  41     -23.427  43.077   2.219  1.00 18.82           C  
ATOM    252  C   ALA A  41     -23.474  43.502   3.695  1.00 19.33           C  
ATOM    253  O   ALA A  41     -22.572  43.164   4.475  1.00 20.23           O  
ATOM    254  CB  ALA A  41     -22.921  44.228   1.333  1.00 19.09           C  
ATOM    255  N   ASP A  42     -24.504  44.249   4.081  1.00 19.64           N  
ATOM    256  CA  ASP A  42     -24.653  44.678   5.495  1.00 20.60           C  
ATOM    257  C   ASP A  42     -24.669  43.457   6.408  1.00 20.46           C  
ATOM    258  O   ASP A  42     -24.019  43.442   7.454  1.00 21.59           O  
ATOM    259  CB  ASP A  42     -25.972  45.432   5.743  1.00 20.83           C  
ATOM    260  CG  ASP A  42     -25.980  46.846   5.201  1.00 23.05           C  
ATOM    261  OD1 ASP A  42     -24.909  47.393   4.903  1.00 25.55           O  
ATOM    262  OD2 ASP A  42     -27.086  47.423   5.103  1.00 27.01           O  
ATOM    263  N   ALA A  43     -25.457  42.448   6.026  1.00 20.29           N  
ATOM    264  CA  ALA A  43     -25.592  41.224   6.830  1.00 20.29           C  
ATOM    265  C   ALA A  43     -24.257  40.478   6.926  1.00 20.44           C  
ATOM    266  O   ALA A  43     -24.010  39.750   7.906  1.00 21.03           O  
ATOM    267  CB  ALA A  43     -26.664  40.330   6.225  1.00 20.30           C  
ATOM    268  N   ALA A  44     -23.405  40.658   5.908  1.00 20.21           N  
ATOM    269  CA  ALA A  44     -22.079  40.019   5.853  1.00 21.33           C  
ATOM    270  C   ALA A  44     -20.949  40.856   6.443  1.00 21.93           C  
ATOM    271  O   ALA A  44     -19.792  40.423   6.449  1.00 23.60           O  
ATOM    272  CB  ALA A  44     -21.739  39.619   4.415  1.00 21.00           C  
ATOM    273  N   GLY A  45     -21.280  42.054   6.929  1.00 21.44           N  
ATOM    274  CA  GLY A  45     -20.309  42.973   7.511  1.00 20.76           C  
ATOM    275  C   GLY A  45     -19.375  43.629   6.514  1.00 20.65           C  
ATOM    276  O   GLY A  45     -18.311  44.081   6.890  1.00 20.63           O  
ATOM    277  N   ILE A  46     -19.781  43.684   5.247  1.00 20.38           N  
ATOM    278  CA  ILE A  46     -18.965  44.291   4.184  1.00 20.00           C  
ATOM    279  C   ILE A  46     -19.738  45.357   3.387  1.00 19.32           C  
ATOM    280  O   ILE A  46     -20.917  45.632   3.663  1.00 19.45           O  
ATOM    281  CB  ILE A  46     -18.423  43.217   3.201  1.00 20.20           C  
ATOM    282  CG1 ILE A  46     -19.595  42.471   2.545  1.00 19.88           C  
ATOM    283  CG2 ILE A  46     -17.432  42.283   3.897  1.00 21.95           C  
ATOM    284  CD1 ILE A  46     -19.219  41.343   1.588  1.00 20.62           C  
ATOM    285  N   LEU A  47     -19.067  45.941   2.394  1.00 18.79           N  
ATOM    286  CA  LEU A  47     -19.717  46.823   1.433  1.00 18.43           C  
ATOM    287  C   LEU A  47     -20.022  46.064   0.136  1.00 18.56           C  
ATOM    288  O   LEU A  47     -19.406  45.042  -0.155  1.00 18.38           O  
ATOM    289  CB  LEU A  47     -18.823  48.039   1.134  1.00 18.48           C  
ATOM    290  CG  LEU A  47     -18.413  48.910   2.340  1.00 17.86           C  
ATOM    291  CD1 LEU A  47     -17.533  50.085   1.922  1.00 20.91           C  
ATOM    292  CD2 LEU A  47     -19.629  49.411   3.097  1.00 20.01           C  
ATOM    293  N   SER A  48     -20.972  46.575  -0.636  1.00 18.42           N  
ATOM    294  CA  SER A  48     -21.419  45.898  -1.855  1.00 19.62           C  
ATOM    295  C   SER A  48     -20.277  45.556  -2.803  1.00 19.11           C  
ATOM    296  O   SER A  48     -20.296  44.499  -3.436  1.00 19.39           O  
ATOM    297  CB  SER A  48     -22.435  46.766  -2.593  1.00 21.01           C  
ATOM    298  OG  SER A  48     -23.665  46.845  -1.890  1.00 23.24           O  
ATOM    299  N   GLY A  49     -19.276  46.431  -2.902  1.00 19.11           N  
ATOM    300  CA  GLY A  49     -18.134  46.146  -3.745  1.00 19.86           C  
ATOM    301  C   GLY A  49     -17.469  44.808  -3.461  1.00 19.46           C  
ATOM    302  O   GLY A  49     -17.021  44.130  -4.387  1.00 19.61           O  
ATOM    303  N   SER A  50     -17.379  44.438  -2.184  1.00 19.21           N  
ATOM    304  CA  SER A  50     -16.757  43.165  -1.818  1.00 19.90           C  
ATOM    305  C   SER A  50     -17.586  42.003  -2.315  1.00 20.45           C  
ATOM    306  O   SER A  50     -17.064  40.970  -2.733  1.00 21.32           O  
ATOM    307  CB  SER A  50     -16.545  43.079  -0.314  1.00 19.95           C  
ATOM    308  OG  SER A  50     -15.430  43.894   0.036  1.00 19.49           O  
ATOM    309  N   LEU A  51     -18.890  42.217  -2.313  1.00 20.31           N  
ATOM    310  CA  LEU A  51     -19.816  41.199  -2.794  1.00 20.15           C  
ATOM    311  C   LEU A  51     -19.618  40.970  -4.300  1.00 19.52           C  
ATOM    312  O   LEU A  51     -19.628  39.828  -4.793  1.00 19.61           O  
ATOM    313  CB  LEU A  51     -21.258  41.615  -2.470  1.00 21.67           C  
ATOM    314  CG  LEU A  51     -22.393  40.625  -2.589  1.00 25.79           C  
ATOM    315  CD1 LEU A  51     -22.610  40.274  -4.040  1.00 28.82           C  
ATOM    316  CD2 LEU A  51     -22.123  39.416  -1.668  1.00 28.87           C  
ATOM    317  N   TYR A  52     -19.425  42.062  -5.036  1.00 19.23           N  
ATOM    318  CA  TYR A  52     -19.279  41.978  -6.491  1.00 19.05           C  
ATOM    319  C   TYR A  52     -17.939  41.381  -6.926  1.00 20.51           C  
ATOM    320  O   TYR A  52     -17.783  40.931  -8.064  1.00 20.81           O  
ATOM    321  CB  TYR A  52     -19.490  43.352  -7.129  1.00 18.36           C  
ATOM    322  CG  TYR A  52     -20.947  43.747  -7.211  1.00 18.04           C  
ATOM    323  CD1 TYR A  52     -21.838  42.990  -7.978  1.00 18.45           C  
ATOM    324  CD2 TYR A  52     -21.449  44.858  -6.521  1.00 17.71           C  
ATOM    325  CE1 TYR A  52     -23.176  43.342  -8.073  1.00 18.78           C  
ATOM    326  CE2 TYR A  52     -22.785  45.217  -6.615  1.00 17.73           C  
ATOM    327  CZ  TYR A  52     -23.639  44.454  -7.399  1.00 17.75           C  
ATOM    328  OH  TYR A  52     -24.963  44.796  -7.509  1.00 19.51           O  
ATOM    329  N   HIS A  53     -16.973  41.378  -6.020  1.00 21.01           N  
ATOM    330  CA  HIS A  53     -15.740  40.671  -6.267  1.00 22.28           C  
ATOM    331  C   HIS A  53     -16.002  39.157  -6.374  1.00 21.44           C  
ATOM    332  O   HIS A  53     -15.329  38.454  -7.130  1.00 22.78           O  
ATOM    333  CB  HIS A  53     -14.732  40.973  -5.159  1.00 23.19           C  
ATOM    334  CG  HIS A  53     -13.441  40.252  -5.328  1.00 26.50           C  
ATOM    335  ND1 HIS A  53     -12.443  40.706  -6.164  1.00 29.26           N  
ATOM    336  CD2 HIS A  53     -12.991  39.093  -4.792  1.00 29.56           C  
ATOM    337  CE1 HIS A  53     -11.428  39.860  -6.129  1.00 30.24           C  
ATOM    338  NE2 HIS A  53     -11.736  38.871  -5.307  1.00 30.04           N  
ATOM    339  N   HIS A  54     -17.001  38.652  -5.646  1.00 20.21           N  
ATOM    340  CA  HIS A  54     -17.317  37.229  -5.653  1.00 20.36           C  
ATOM    341  C   HIS A  54     -18.404  36.851  -6.648  1.00 19.91           C  
ATOM    342  O   HIS A  54     -18.372  35.739  -7.180  1.00 21.12           O  
ATOM    343  CB  HIS A  54     -17.819  36.796  -4.272  1.00 20.40           C  
ATOM    344  CG  HIS A  54     -16.761  36.761  -3.214  1.00 21.91           C  
ATOM    345  ND1 HIS A  54     -15.878  35.712  -3.078  1.00 24.70           N  
ATOM    346  CD2 HIS A  54     -16.464  37.634  -2.225  1.00 22.75           C  
ATOM    347  CE1 HIS A  54     -15.070  35.949  -2.061  1.00 24.22           C  
ATOM    348  NE2 HIS A  54     -15.404  37.109  -1.524  1.00 23.90           N  
ATOM    349  N   PHE A  55     -19.387  37.734  -6.848  1.00 18.42           N  
ATOM    350  CA  PHE A  55     -20.576  37.425  -7.682  1.00 17.80           C  
ATOM    351  C   PHE A  55     -20.829  38.456  -8.774  1.00 18.58           C  
ATOM    352  O   PHE A  55     -20.627  39.651  -8.550  1.00 19.07           O  
ATOM    353  CB  PHE A  55     -21.817  37.349  -6.807  1.00 18.20           C  
ATOM    354  CG  PHE A  55     -21.679  36.376  -5.707  1.00 18.67           C  
ATOM    355  CD1 PHE A  55     -21.845  35.034  -5.957  1.00 18.57           C  
ATOM    356  CD2 PHE A  55     -21.334  36.796  -4.430  1.00 18.98           C  
ATOM    357  CE1 PHE A  55     -21.670  34.097  -4.916  1.00 20.79           C  
ATOM    358  CE2 PHE A  55     -21.185  35.889  -3.396  1.00 20.30           C  
ATOM    359  CZ  PHE A  55     -21.344  34.545  -3.645  1.00 20.05           C  
ATOM    360  N   ASP A  56     -21.330  38.001  -9.927  1.00 18.27           N  
ATOM    361  CA  ASP A  56     -21.635  38.929 -11.017  1.00 18.92           C  
ATOM    362  C   ASP A  56     -22.789  39.835 -10.653  1.00 18.12           C  
ATOM    363  O   ASP A  56     -22.778  41.013 -11.010  1.00 18.12           O  
ATOM    364  CB  ASP A  56     -22.029  38.169 -12.282  1.00 19.21           C  
ATOM    365  CG  ASP A  56     -20.855  37.467 -12.949  1.00 23.54           C  
ATOM    366  OD1 ASP A  56     -19.695  37.826 -12.658  1.00 25.92           O  
ATOM    367  OD2 ASP A  56     -21.113  36.561 -13.789  1.00 27.25           O  
ATOM    368  N   SER A  57     -23.801  39.289  -9.968  1.00 17.29           N  
ATOM    369  CA  SER A  57     -25.037  40.016  -9.770  1.00 17.65           C  
ATOM    370  C   SER A  57     -25.866  39.323  -8.698  1.00 16.93           C  
ATOM    371  O   SER A  57     -25.651  38.142  -8.384  1.00 17.26           O  
ATOM    372  CB  SER A  57     -25.847  40.027 -11.077  1.00 18.05           C  
ATOM    373  OG  SER A  57     -26.265  38.720 -11.437  1.00 19.01           O  
ATOM    374  N   LYS A  58     -26.873  40.029  -8.196  1.00 16.99           N  
ATOM    375  CA  LYS A  58     -27.881  39.419  -7.319  1.00 17.64           C  
ATOM    376  C   LYS A  58     -28.534  38.213  -8.013  1.00 16.72           C  
ATOM    377  O   LYS A  58     -28.748  37.148  -7.395  1.00 17.31           O  
ATOM    378  CB  LYS A  58     -28.932  40.466  -6.966  1.00 18.88           C  
ATOM    379  CG  LYS A  58     -30.070  39.974  -6.086  1.00 20.13           C  
ATOM    380  CD  LYS A  58     -31.101  41.110  -5.940  1.00 21.42           C  
ATOM    381  CE  LYS A  58     -32.403  40.592  -5.432  1.00 22.96           C  
ATOM    382  NZ  LYS A  58     -33.358  41.699  -5.451  1.00 22.67           N  
ATOM    383  N   GLU A  59     -28.816  38.410  -9.295  0.50 16.66           N  
ATOM    385  CA  GLU A  59     -29.463  37.430 -10.147  0.50 16.56           C  
ATOM    387  C   GLU A  59     -28.694  36.119 -10.125  0.50 15.98           C  
ATOM    389  O   GLU A  59     -29.258  35.035  -9.907  0.50 15.85           O  
ATOM    391  CB  GLU A  59     -29.496  37.959 -11.590  0.50 16.29           C  
ATOM    393  CG  GLU A  59     -30.383  37.137 -12.526  0.50 17.54           C  
ATOM    395  CD  GLU A  59     -30.394  37.678 -13.950  0.50 17.11           C  
ATOM    397  OE1 GLU A  59     -29.315  37.761 -14.575  0.50 16.81           O  
ATOM    399  OE2 GLU A  59     -31.477  38.034 -14.450  0.50 17.73           O  
ATOM    401  N   SER A  60     -27.392  36.232 -10.357  1.00 16.03           N  
ATOM    402  CA  SER A  60     -26.519  35.051 -10.427  1.00 16.18           C  
ATOM    403  C   SER A  60     -26.505  34.342  -9.072  1.00 15.81           C  
ATOM    404  O   SER A  60     -26.416  33.106  -9.044  1.00 15.74           O  
ATOM    405  CB  SER A  60     -25.098  35.356 -10.921  1.00 18.60           C  
ATOM    406  OG  SER A  60     -24.385  36.105  -9.980  1.00 22.52           O  
HETATM  407  N   MSE A  61     -26.557  35.097  -7.963  1.00 15.73           N  
HETATM  408  CA  MSE A  61     -26.660  34.460  -6.640  1.00 16.83           C  
HETATM  409  C   MSE A  61     -27.922  33.609  -6.504  1.00 15.50           C  
HETATM  410  O   MSE A  61     -27.864  32.450  -6.093  1.00 14.96           O  
HETATM  411  CB  MSE A  61     -26.605  35.512  -5.545  1.00 16.62           C  
HETATM  412  CG  MSE A  61     -25.283  36.292  -5.609  1.00 17.18           C  
HETATM  413 SE   MSE A  61     -25.219  37.644  -4.208  1.00 27.34          SE  
HETATM  414  CE  MSE A  61     -24.637  36.498  -2.742  1.00 25.38           C  
ATOM    415  N   VAL A  62     -29.060  34.195  -6.860  1.00 15.08           N  
ATOM    416  CA  VAL A  62     -30.355  33.470  -6.847  1.00 15.52           C  
ATOM    417  C   VAL A  62     -30.268  32.206  -7.689  1.00 14.01           C  
ATOM    418  O   VAL A  62     -30.718  31.134  -7.274  1.00 14.08           O  
ATOM    419  CB  VAL A  62     -31.502  34.378  -7.396  1.00 17.02           C  
ATOM    420  CG1 VAL A  62     -32.819  33.607  -7.573  1.00 19.53           C  
ATOM    421  CG2 VAL A  62     -31.681  35.646  -6.494  1.00 18.68           C  
ATOM    422  N   ASP A  63     -29.700  32.346  -8.884  1.00 11.95           N  
ATOM    423  CA  ASP A  63     -29.611  31.228  -9.821  1.00 12.08           C  
ATOM    424  C   ASP A  63     -28.782  30.106  -9.186  1.00 12.18           C  
ATOM    425  O   ASP A  63     -29.183  28.921  -9.222  1.00 13.69           O  
ATOM    426  CB  ASP A  63     -28.949  31.747 -11.101  1.00 11.72           C  
ATOM    427  CG  ASP A  63     -29.149  30.838 -12.315  1.00 14.55           C  
ATOM    428  OD1 ASP A  63     -29.863  29.836 -12.252  1.00 14.19           O  
ATOM    429  OD2 ASP A  63     -28.577  31.177 -13.381  1.00 16.85           O  
ATOM    430  N   GLU A  64     -27.658  30.467  -8.572  1.00 12.04           N  
ATOM    431  CA  GLU A  64     -26.778  29.447  -7.983  1.00 12.58           C  
ATOM    432  C   GLU A  64     -27.465  28.739  -6.805  1.00 12.69           C  
ATOM    433  O   GLU A  64     -27.361  27.514  -6.657  1.00 14.60           O  
ATOM    434  CB  GLU A  64     -25.477  30.104  -7.531  1.00 12.94           C  
ATOM    435  CG  GLU A  64     -24.410  29.127  -7.102  1.00 16.93           C  
ATOM    436  CD  GLU A  64     -23.033  29.775  -7.000  1.00 20.98           C  
ATOM    437  OE1 GLU A  64     -22.837  30.838  -7.593  1.00 23.43           O  
ATOM    438  OE2 GLU A  64     -22.153  29.206  -6.331  1.00 25.55           O  
ATOM    439  N   ILE A  65     -28.161  29.514  -5.972  1.00 12.44           N  
ATOM    440  CA  ILE A  65     -28.911  28.937  -4.842  1.00 12.58           C  
ATOM    441  C   ILE A  65     -29.965  27.964  -5.355  1.00 13.56           C  
ATOM    442  O   ILE A  65     -30.069  26.827  -4.856  1.00 15.50           O  
ATOM    443  CB  ILE A  65     -29.577  30.070  -4.002  1.00 11.92           C  
ATOM    444  CG1 ILE A  65     -28.484  30.861  -3.269  1.00 13.03           C  
ATOM    445  CG2 ILE A  65     -30.602  29.480  -3.046  1.00 13.10           C  
ATOM    446  CD1 ILE A  65     -28.894  32.285  -2.894  1.00 14.11           C  
ATOM    447  N   LEU A  66     -30.760  28.397  -6.335  1.00 13.52           N  
ATOM    448  CA  LEU A  66     -31.836  27.539  -6.833  1.00 14.64           C  
ATOM    449  C   LEU A  66     -31.281  26.294  -7.499  1.00 14.78           C  
ATOM    450  O   LEU A  66     -31.794  25.201  -7.263  1.00 16.34           O  
ATOM    451  CB  LEU A  66     -32.775  28.307  -7.769  1.00 14.76           C  
ATOM    452  CG  LEU A  66     -33.659  29.297  -7.030  1.00 14.40           C  
ATOM    453  CD1 LEU A  66     -34.449  30.079  -8.070  1.00 15.70           C  
ATOM    454  CD2 LEU A  66     -34.599  28.547  -6.060  1.00 16.74           C  
ATOM    455  N   ARG A  67     -30.260  26.442  -8.340  1.00 15.37           N  
ATOM    456  CA  ARG A  67     -29.700  25.263  -9.032  1.00 15.45           C  
ATOM    457  C   ARG A  67     -29.071  24.277  -8.066  1.00 15.90           C  
ATOM    458  O   ARG A  67     -29.191  23.050  -8.244  1.00 15.58           O  
ATOM    459  CB  ARG A  67     -28.705  25.675 -10.103  1.00 15.97           C  
ATOM    460  CG  ARG A  67     -29.370  26.247 -11.322  1.00 16.70           C  
ATOM    461  CD  ARG A  67     -28.359  26.913 -12.229  1.00 17.58           C  
ATOM    462  NE  ARG A  67     -28.937  27.438 -13.462  1.00 19.48           N  
ATOM    463  CZ  ARG A  67     -29.087  26.731 -14.583  1.00 19.20           C  
ATOM    464  NH1 ARG A  67     -28.742  25.447 -14.612  1.00 21.86           N  
ATOM    465  NH2 ARG A  67     -29.600  27.299 -15.670  1.00 20.90           N  
ATOM    466  N   GLY A  68     -28.402  24.784  -7.038  1.00 16.37           N  
ATOM    467  CA  GLY A  68     -27.755  23.862  -6.090  1.00 17.07           C  
ATOM    468  C   GLY A  68     -28.811  22.914  -5.539  1.00 17.43           C  
ATOM    469  O   GLY A  68     -28.615  21.676  -5.517  1.00 19.45           O  
ATOM    470  N   PHE A  69     -29.930  23.505  -5.115  1.00 15.87           N  
ATOM    471  CA  PHE A  69     -31.024  22.771  -4.499  1.00 14.81           C  
ATOM    472  C   PHE A  69     -31.715  21.883  -5.531  1.00 14.31           C  
ATOM    473  O   PHE A  69     -31.868  20.680  -5.317  1.00 14.54           O  
ATOM    474  CB  PHE A  69     -31.988  23.790  -3.851  1.00 16.24           C  
ATOM    475  CG  PHE A  69     -33.412  23.324  -3.698  1.00 15.25           C  
ATOM    476  CD1 PHE A  69     -33.743  22.150  -3.007  1.00 18.53           C  
ATOM    477  CD2 PHE A  69     -34.449  24.088  -4.239  1.00 18.30           C  
ATOM    478  CE1 PHE A  69     -35.064  21.759  -2.900  1.00 17.74           C  
ATOM    479  CE2 PHE A  69     -35.758  23.708  -4.107  1.00 18.65           C  
ATOM    480  CZ  PHE A  69     -36.068  22.541  -3.440  1.00 18.15           C  
ATOM    481  N   LEU A  70     -32.093  22.464  -6.658  1.00 12.99           N  
ATOM    482  CA  LEU A  70     -32.935  21.738  -7.618  1.00 12.92           C  
ATOM    483  C   LEU A  70     -32.190  20.639  -8.376  1.00 13.36           C  
ATOM    484  O   LEU A  70     -32.771  19.605  -8.705  1.00 14.14           O  
ATOM    485  CB  LEU A  70     -33.587  22.709  -8.600  1.00 13.07           C  
ATOM    486  CG  LEU A  70     -34.592  23.660  -7.925  1.00 13.22           C  
ATOM    487  CD1 LEU A  70     -34.847  24.857  -8.856  1.00 14.92           C  
ATOM    488  CD2 LEU A  70     -35.888  22.923  -7.614  1.00 15.07           C  
ATOM    489  N   ASP A  71     -30.911  20.855  -8.668  1.00 13.34           N  
ATOM    490  CA  ASP A  71     -30.164  19.814  -9.345  1.00 14.10           C  
ATOM    491  C   ASP A  71     -30.105  18.547  -8.498  1.00 14.20           C  
ATOM    492  O   ASP A  71     -30.280  17.414  -9.012  1.00 15.26           O  
ATOM    493  CB  ASP A  71     -28.749  20.302  -9.641  1.00 14.84           C  
ATOM    494  CG  ASP A  71     -28.694  21.301 -10.763  1.00 18.73           C  
ATOM    495  OD1 ASP A  71     -29.666  21.439 -11.538  1.00 22.89           O  
ATOM    496  OD2 ASP A  71     -27.633  21.919 -10.903  1.00 21.62           O  
ATOM    497  N   ASP A  72     -29.881  18.739  -7.205  1.00 14.17           N  
ATOM    498  CA  ASP A  72     -29.778  17.625  -6.254  1.00 15.30           C  
ATOM    499  C   ASP A  72     -31.163  16.969  -6.116  1.00 14.62           C  
ATOM    500  O   ASP A  72     -31.316  15.747  -6.203  1.00 15.03           O  
ATOM    501  CB  ASP A  72     -29.283  18.169  -4.895  1.00 16.43           C  
ATOM    502  CG  ASP A  72     -29.212  17.111  -3.835  1.00 20.57           C  
ATOM    503  OD1 ASP A  72     -28.171  16.435  -3.737  1.00 26.58           O  
ATOM    504  OD2 ASP A  72     -30.186  16.960  -3.083  1.00 21.75           O  
ATOM    505  N   LEU A  73     -32.174  17.809  -5.901  1.00 13.03           N  
ATOM    506  CA  LEU A  73     -33.533  17.316  -5.690  1.00 12.51           C  
ATOM    507  C   LEU A  73     -34.040  16.514  -6.877  1.00 12.62           C  
ATOM    508  O   LEU A  73     -34.505  15.358  -6.708  1.00 12.63           O  
ATOM    509  CB  LEU A  73     -34.458  18.504  -5.440  1.00 12.05           C  
ATOM    510  CG  LEU A  73     -35.908  18.081  -5.183  1.00 12.90           C  
ATOM    511  CD1 LEU A  73     -36.082  17.591  -3.738  1.00 13.21           C  
ATOM    512  CD2 LEU A  73     -36.862  19.281  -5.487  1.00 13.92           C  
ATOM    513  N   PHE A  74     -33.969  17.124  -8.069  1.00 12.74           N  
ATOM    514  CA  PHE A  74     -34.460  16.408  -9.258  1.00 12.41           C  
ATOM    515  C   PHE A  74     -33.613  15.182  -9.615  1.00 12.45           C  
ATOM    516  O   PHE A  74     -34.147  14.189 -10.124  1.00 14.21           O  
ATOM    517  CB  PHE A  74     -34.701  17.309 -10.460  1.00 13.33           C  
ATOM    518  CG  PHE A  74     -36.001  18.064 -10.376  1.00 12.07           C  
ATOM    519  CD1 PHE A  74     -37.109  17.659 -11.148  1.00 12.58           C  
ATOM    520  CD2 PHE A  74     -36.137  19.155  -9.514  1.00 12.81           C  
ATOM    521  CE1 PHE A  74     -38.352  18.328 -11.064  1.00 12.89           C  
ATOM    522  CE2 PHE A  74     -37.388  19.819  -9.425  1.00 12.42           C  
ATOM    523  CZ  PHE A  74     -38.493  19.410 -10.203  1.00 12.64           C  
ATOM    524  N   GLY A  75     -32.321  15.225  -9.324  1.00 12.21           N  
ATOM    525  CA  GLY A  75     -31.481  14.041  -9.494  1.00 12.13           C  
ATOM    526  C   GLY A  75     -32.020  12.884  -8.659  1.00 12.38           C  
ATOM    527  O   GLY A  75     -32.105  11.744  -9.138  1.00 13.71           O  
ATOM    528  N   LYS A  76     -32.396  13.171  -7.416  1.00 11.24           N  
ATOM    529  CA  LYS A  76     -32.975  12.133  -6.546  1.00 12.14           C  
ATOM    530  C   LYS A  76     -34.339  11.690  -7.053  1.00 12.59           C  
ATOM    531  O   LYS A  76     -34.598  10.484  -7.095  1.00 13.48           O  
ATOM    532  CB  LYS A  76     -33.046  12.640  -5.100  1.00 13.37           C  
ATOM    533  CG  LYS A  76     -31.683  12.723  -4.441  1.00 14.24           C  
ATOM    534  CD  LYS A  76     -31.717  13.584  -3.202  1.00 17.62           C  
ATOM    535  CE  LYS A  76     -30.296  13.678  -2.614  1.00 20.48           C  
ATOM    536  NZ  LYS A  76     -30.178  14.789  -1.614  1.00 25.11           N  
ATOM    537  N   TYR A  77     -35.205  12.640  -7.432  1.00 12.23           N  
ATOM    538  CA  TYR A  77     -36.505  12.234  -7.963  1.00 11.49           C  
ATOM    539  C   TYR A  77     -36.347  11.270  -9.156  1.00 11.98           C  
ATOM    540  O   TYR A  77     -37.052  10.246  -9.251  1.00 12.90           O  
ATOM    541  CB  TYR A  77     -37.295  13.439  -8.454  1.00 11.80           C  
ATOM    542  CG  TYR A  77     -37.862  14.383  -7.422  1.00 11.80           C  
ATOM    543  CD1 TYR A  77     -38.071  14.012  -6.087  1.00 11.35           C  
ATOM    544  CD2 TYR A  77     -38.253  15.654  -7.824  1.00 12.34           C  
ATOM    545  CE1 TYR A  77     -38.656  14.914  -5.148  1.00 11.82           C  
ATOM    546  CE2 TYR A  77     -38.853  16.568  -6.922  1.00 12.35           C  
ATOM    547  CZ  TYR A  77     -39.047  16.193  -5.588  1.00 11.55           C  
ATOM    548  OH  TYR A  77     -39.643  17.095  -4.742  1.00 12.83           O  
ATOM    549  N   ARG A  78     -35.458  11.636 -10.077  1.00 11.56           N  
ATOM    550  CA  ARG A  78     -35.281  10.847 -11.304  1.00 11.29           C  
ATOM    551  C   ARG A  78     -34.797   9.441 -10.966  1.00 11.56           C  
ATOM    552  O   ARG A  78     -35.295   8.451 -11.510  1.00 11.74           O  
ATOM    553  CB  ARG A  78     -34.329  11.529 -12.275  1.00 11.14           C  
ATOM    554  CG  ARG A  78     -34.908  12.824 -12.849  1.00 11.93           C  
ATOM    555  CD  ARG A  78     -33.729  13.695 -13.338  1.00 13.43           C  
ATOM    556  NE  ARG A  78     -34.197  15.016 -13.769  1.00 14.21           N  
ATOM    557  CZ  ARG A  78     -33.499  16.137 -13.677  1.00 14.93           C  
ATOM    558  NH1 ARG A  78     -32.251  16.123 -13.240  1.00 16.39           N  
ATOM    559  NH2 ARG A  78     -34.055  17.291 -14.038  1.00 15.49           N  
ATOM    560  N   GLU A  79     -33.842   9.355 -10.044  1.00 11.07           N  
ATOM    561  CA  GLU A  79     -33.339   8.026  -9.676  1.00 10.95           C  
ATOM    562  C   GLU A  79     -34.408   7.222  -8.927  1.00 10.70           C  
ATOM    563  O   GLU A  79     -34.520   5.990  -9.130  1.00 11.82           O  
ATOM    564  CB  GLU A  79     -32.032   8.098  -8.891  1.00 11.10           C  
ATOM    565  CG  GLU A  79     -30.850   8.641  -9.729  1.00 11.01           C  
ATOM    566  CD  GLU A  79     -30.865   8.062 -11.149  1.00 11.60           C  
ATOM    567  OE1 GLU A  79     -30.694   6.841 -11.306  1.00 11.82           O  
ATOM    568  OE2 GLU A  79     -31.089   8.835 -12.112  1.00 12.10           O  
ATOM    569  N   ILE A  80     -35.155   7.878  -8.035  1.00 11.06           N  
ATOM    570  CA  ILE A  80     -36.232   7.158  -7.332  1.00 11.47           C  
ATOM    571  C   ILE A  80     -37.197   6.523  -8.322  1.00 12.14           C  
ATOM    572  O   ILE A  80     -37.542   5.335  -8.212  1.00 12.58           O  
ATOM    573  CB  ILE A  80     -36.964   8.123  -6.371  1.00 11.31           C  
ATOM    574  CG1 ILE A  80     -36.068   8.363  -5.154  1.00 12.62           C  
ATOM    575  CG2 ILE A  80     -38.338   7.560  -5.971  1.00 12.30           C  
ATOM    576  CD1 ILE A  80     -36.413   9.561  -4.311  1.00 15.43           C  
ATOM    577  N   VAL A  81     -37.658   7.290  -9.305  1.00 12.81           N  
ATOM    578  CA  VAL A  81     -38.636   6.753 -10.254  0.50 13.84           C  
ATOM    580  C   VAL A  81     -38.041   5.632 -11.117  1.00 13.90           C  
ATOM    581  O   VAL A  81     -38.766   4.749 -11.554  1.00 14.71           O  
ATOM    582  CB  VAL A  81     -39.288   7.862 -11.105  0.50 14.29           C  
ATOM    584  CG1 VAL A  81     -40.107   7.299 -12.278  0.50 14.77           C  
ATOM    586  CG2 VAL A  81     -40.148   8.779 -10.237  0.50 14.29           C  
ATOM    588  N   ALA A  82     -36.729   5.679 -11.350  1.00 13.32           N  
ATOM    589  CA  ALA A  82     -36.076   4.640 -12.162  1.00 13.75           C  
ATOM    590  C   ALA A  82     -35.630   3.421 -11.345  1.00 14.60           C  
ATOM    591  O   ALA A  82     -35.163   2.436 -11.933  1.00 16.80           O  
ATOM    592  CB  ALA A  82     -34.882   5.222 -12.905  1.00 14.08           C  
ATOM    593  N   SER A  83     -35.769   3.491 -10.014  1.00 15.13           N  
ATOM    594  CA  SER A  83     -35.124   2.532  -9.082  1.00 15.62           C  
ATOM    595  C   SER A  83     -35.785   1.189  -8.871  1.00 17.16           C  
ATOM    596  O   SER A  83     -35.190   0.344  -8.187  1.00 18.61           O  
ATOM    597  CB  SER A  83     -34.931   3.143  -7.703  1.00 15.41           C  
ATOM    598  OG  SER A  83     -36.169   3.307  -7.035  1.00 17.17           O  
ATOM    599  N   GLY A  84     -36.980   1.002  -9.418  1.00 16.68           N  
ATOM    600  CA  GLY A  84     -37.641  -0.315  -9.332  1.00 17.22           C  
ATOM    601  C   GLY A  84     -38.478  -0.480  -8.065  1.00 17.18           C  
ATOM    602  O   GLY A  84     -38.930  -1.596  -7.769  1.00 18.39           O  
ATOM    603  N   LEU A  85     -38.724   0.612  -7.329  1.00 16.66           N  
ATOM    604  CA  LEU A  85     -39.597   0.536  -6.134  1.00 15.35           C  
ATOM    605  C   LEU A  85     -41.049   0.329  -6.597  1.00 14.67           C  
ATOM    606  O   LEU A  85     -41.403   0.767  -7.685  1.00 15.54           O  
ATOM    607  CB  LEU A  85     -39.520   1.805  -5.289  1.00 15.72           C  
ATOM    608  CG  LEU A  85     -38.260   2.104  -4.452  1.00 17.23           C  
ATOM    609  CD1 LEU A  85     -38.289   3.536  -3.984  1.00 19.35           C  
ATOM    610  CD2 LEU A  85     -38.278   1.157  -3.247  1.00 19.80           C  
ATOM    611  N   ASP A  86     -41.898  -0.346  -5.810  1.00 13.44           N  
ATOM    612  CA  ASP A  86     -43.312  -0.424  -6.190  1.00 14.02           C  
ATOM    613  C   ASP A  86     -43.979   0.978  -6.143  1.00 13.58           C  
ATOM    614  O   ASP A  86     -43.364   1.962  -5.723  1.00 13.67           O  
ATOM    615  CB  ASP A  86     -44.065  -1.485  -5.390  1.00 14.34           C  
ATOM    616  CG  ASP A  86     -44.192  -1.162  -3.900  1.00 16.30           C  
ATOM    617  OD1 ASP A  86     -44.506  -0.021  -3.481  1.00 17.66           O  
ATOM    618  OD2 ASP A  86     -44.026  -2.138  -3.133  1.00 24.82           O  
ATOM    619  N   SER A  87     -45.228   1.083  -6.588  1.00 13.51           N  
ATOM    620  CA  SER A  87     -45.812   2.416  -6.749  1.00 13.23           C  
ATOM    621  C   SER A  87     -45.940   3.186  -5.426  1.00 12.90           C  
ATOM    622  O   SER A  87     -45.607   4.383  -5.367  1.00 13.47           O  
ATOM    623  CB  SER A  87     -47.162   2.344  -7.475  1.00 15.05           C  
ATOM    624  OG  SER A  87     -46.977   1.845  -8.799  1.00 15.92           O  
ATOM    625  N   ARG A  88     -46.482   2.531  -4.384  1.00 13.28           N  
ATOM    626  CA  ARG A  88     -46.630   3.225  -3.101  1.00 12.72           C  
ATOM    627  C   ARG A  88     -45.257   3.611  -2.540  1.00 12.29           C  
ATOM    628  O   ARG A  88     -45.052   4.744  -2.084  1.00 13.58           O  
ATOM    629  CB  ARG A  88     -47.436   2.412  -2.069  1.00 13.19           C  
ATOM    630  CG  ARG A  88     -47.486   3.116  -0.725  1.00 14.43           C  
ATOM    631  CD  ARG A  88     -48.395   2.428   0.268  1.00 16.49           C  
ATOM    632  NE  ARG A  88     -48.338   3.133   1.540  1.00 14.63           N  
ATOM    633  CZ  ARG A  88     -49.388   3.305   2.351  1.00 14.67           C  
ATOM    634  NH1 ARG A  88     -50.590   2.773   2.049  1.00 13.56           N  
ATOM    635  NH2 ARG A  88     -49.220   4.007   3.472  1.00 15.86           N  
ATOM    636  N   ALA A  89     -44.297   2.680  -2.618  1.00 12.24           N  
ATOM    637  CA  ALA A  89     -42.964   2.986  -2.071  1.00 12.49           C  
ATOM    638  C   ALA A  89     -42.285   4.115  -2.840  1.00 12.58           C  
ATOM    639  O   ALA A  89     -41.468   4.865  -2.278  1.00 13.88           O  
ATOM    640  CB  ALA A  89     -42.049   1.714  -2.085  1.00 13.09           C  
ATOM    641  N   THR A  90     -42.543   4.155  -4.148  1.00 11.44           N  
ATOM    642  CA  THR A  90     -41.977   5.218  -4.993  1.00 11.45           C  
ATOM    643  C   THR A  90     -42.522   6.583  -4.531  1.00 12.09           C  
ATOM    644  O   THR A  90     -41.758   7.545  -4.348  1.00 12.17           O  
ATOM    645  CB  THR A  90     -42.313   4.973  -6.498  1.00 13.13           C  
ATOM    646  OG1 THR A  90     -41.717   3.746  -6.919  1.00 12.51           O  
ATOM    647  CG2 THR A  90     -41.745   6.123  -7.351  1.00 11.76           C  
ATOM    648  N   LEU A  91     -43.844   6.654  -4.345  1.00 12.54           N  
ATOM    649  CA  LEU A  91     -44.461   7.911  -3.907  1.00 12.43           C  
ATOM    650  C   LEU A  91     -43.941   8.285  -2.532  1.00 11.95           C  
ATOM    651  O   LEU A  91     -43.599   9.452  -2.286  1.00 13.34           O  
ATOM    652  CB  LEU A  91     -45.992   7.791  -3.906  1.00 12.83           C  
ATOM    653  CG  LEU A  91     -46.695   9.098  -3.508  1.00 14.51           C  
ATOM    654  CD1 LEU A  91     -46.326  10.246  -4.439  1.00 17.74           C  
ATOM    655  CD2 LEU A  91     -48.148   8.881  -3.605  1.00 14.85           C  
ATOM    656  N   GLU A  92     -43.839   7.286  -1.647  1.00 12.07           N  
ATOM    657  CA  GLU A  92     -43.300   7.564  -0.311  1.00 11.43           C  
ATOM    658  C   GLU A  92     -41.885   8.127  -0.385  1.00 11.72           C  
ATOM    659  O   GLU A  92     -41.551   9.094   0.322  1.00 13.47           O  
ATOM    660  CB  GLU A  92     -43.335   6.327   0.595  1.00 12.20           C  
ATOM    661  CG  GLU A  92     -44.743   5.906   0.949  1.00 11.58           C  
ATOM    662  CD  GLU A  92     -44.855   4.526   1.564  1.00 15.48           C  
ATOM    663  OE1 GLU A  92     -43.997   3.635   1.269  1.00 19.51           O  
ATOM    664  OE2 GLU A  92     -45.857   4.325   2.299  1.00 16.78           O  
ATOM    665  N   ALA A  93     -41.074   7.561  -1.279  1.00 11.34           N  
ATOM    666  CA  ALA A  93     -39.686   8.026  -1.414  1.00 11.14           C  
ATOM    667  C   ALA A  93     -39.611   9.449  -1.974  1.00 11.34           C  
ATOM    668  O   ALA A  93     -38.769  10.256  -1.563  1.00 13.11           O  
ATOM    669  CB  ALA A  93     -38.906   7.083  -2.300  1.00 11.73           C  
ATOM    670  N   LEU A  94     -40.449   9.744  -2.966  1.00 11.74           N  
ATOM    671  CA  LEU A  94     -40.465  11.094  -3.525  1.00 11.30           C  
ATOM    672  C   LEU A  94     -40.817  12.123  -2.443  1.00 11.87           C  
ATOM    673  O   LEU A  94     -40.172  13.169  -2.333  1.00 13.10           O  
ATOM    674  CB  LEU A  94     -41.455  11.155  -4.684  1.00 11.70           C  
ATOM    675  CG  LEU A  94     -41.120  10.341  -5.928  1.00 12.68           C  
ATOM    676  CD1 LEU A  94     -42.237  10.445  -6.968  1.00 14.17           C  
ATOM    677  CD2 LEU A  94     -39.816  10.874  -6.479  1.00 13.66           C  
ATOM    678  N   VAL A  95     -41.850  11.832  -1.661  1.00 12.21           N  
ATOM    679  CA  VAL A  95     -42.307  12.786  -0.647  1.00 12.60           C  
ATOM    680  C   VAL A  95     -41.246  12.943   0.438  1.00 12.92           C  
ATOM    681  O   VAL A  95     -40.945  14.048   0.906  1.00 13.54           O  
ATOM    682  CB  VAL A  95     -43.640  12.323  -0.069  1.00 12.69           C  
ATOM    683  CG1 VAL A  95     -43.974  13.152   1.176  1.00 14.26           C  
ATOM    684  CG2 VAL A  95     -44.729  12.521  -1.139  1.00 14.28           C  
ATOM    685  N   THR A  96     -40.659  11.820   0.852  1.00 12.38           N  
ATOM    686  CA  THR A  96     -39.622  11.857   1.879  1.00 13.30           C  
ATOM    687  C   THR A  96     -38.431  12.693   1.415  1.00 13.29           C  
ATOM    688  O   THR A  96     -37.838  13.434   2.222  1.00 14.17           O  
ATOM    689  CB  THR A  96     -39.210  10.432   2.286  1.00 13.79           C  
ATOM    690  OG1 THR A  96     -40.382   9.771   2.770  1.00 15.12           O  
ATOM    691  CG2 THR A  96     -38.159  10.454   3.416  1.00 17.34           C  
ATOM    692  N   THR A  97     -38.091  12.589   0.131  1.00 13.29           N  
ATOM    693  CA  THR A  97     -37.003  13.365  -0.446  1.00 13.98           C  
ATOM    694  C   THR A  97     -37.318  14.837  -0.380  1.00 14.65           C  
ATOM    695  O   THR A  97     -36.446  15.678  -0.088  1.00 14.43           O  
ATOM    696  CB  THR A  97     -36.811  12.923  -1.908  1.00 15.15           C  
ATOM    697  OG1 THR A  97     -36.317  11.605  -1.865  1.00 15.80           O  
ATOM    698  CG2 THR A  97     -35.814  13.793  -2.653  1.00 15.61           C  
ATOM    699  N   SER A  98     -38.567  15.174  -0.638  1.00 13.59           N  
ATOM    700  CA  SER A  98     -38.945  16.602  -0.548  1.00 12.56           C  
ATOM    701  C   SER A  98     -38.794  17.128   0.876  1.00 13.39           C  
ATOM    702  O   SER A  98     -38.237  18.229   1.106  1.00 13.85           O  
ATOM    703  CB  SER A  98     -40.374  16.856  -1.030  1.00 13.24           C  
ATOM    704  OG  SER A  98     -40.576  16.279  -2.315  1.00 14.44           O  
ATOM    705  N   TYR A  99     -39.316  16.375   1.844  1.00 13.39           N  
ATOM    706  CA  TYR A  99     -39.194  16.804   3.234  1.00 13.08           C  
ATOM    707  C   TYR A  99     -37.728  16.893   3.636  1.00 14.18           C  
ATOM    708  O   TYR A  99     -37.346  17.815   4.391  1.00 14.11           O  
ATOM    709  CB  TYR A  99     -39.976  15.868   4.183  1.00 13.19           C  
ATOM    710  CG  TYR A  99     -41.429  16.272   4.307  1.00 12.58           C  
ATOM    711  CD1 TYR A  99     -41.796  17.360   5.073  1.00 14.10           C  
ATOM    712  CD2 TYR A  99     -42.422  15.595   3.611  1.00 15.86           C  
ATOM    713  CE1 TYR A  99     -43.117  17.750   5.197  1.00 14.89           C  
ATOM    714  CE2 TYR A  99     -43.766  15.976   3.733  1.00 15.75           C  
ATOM    715  CZ  TYR A  99     -44.100  17.065   4.516  1.00 15.90           C  
ATOM    716  OH  TYR A  99     -45.420  17.441   4.629  1.00 18.73           O  
ATOM    717  N   GLU A 100     -36.880  15.961   3.171  1.00 14.35           N  
ATOM    718  CA  GLU A 100     -35.470  16.039   3.531  0.50 15.53           C  
ATOM    720  C   GLU A 100     -34.848  17.349   3.033  1.00 15.01           C  
ATOM    721  O   GLU A 100     -33.998  17.929   3.713  1.00 15.91           O  
ATOM    722  CB  GLU A 100     -34.708  14.807   3.042  0.50 15.91           C  
ATOM    724  CG  GLU A 100     -34.984  13.581   3.929  0.50 15.95           C  
ATOM    726  CD  GLU A 100     -34.512  12.256   3.340  0.50 18.63           C  
ATOM    728  OE1 GLU A 100     -33.938  12.262   2.240  0.50 22.49           O  
ATOM    730  OE2 GLU A 100     -34.729  11.197   3.971  0.50 20.76           O  
ATOM    732  N   ALA A 101     -35.269  17.815   1.850  1.00 13.79           N  
ATOM    733  CA  ALA A 101     -34.792  19.115   1.331  1.00 14.27           C  
ATOM    734  C   ALA A 101     -35.269  20.305   2.187  1.00 14.57           C  
ATOM    735  O   ALA A 101     -34.574  21.311   2.311  1.00 14.69           O  
ATOM    736  CB  ALA A 101     -35.260  19.290  -0.118  1.00 15.09           C  
ATOM    737  N   ILE A 102     -36.493  20.227   2.709  1.00 14.09           N  
ATOM    738  CA  ILE A 102     -36.984  21.297   3.632  1.00 14.93           C  
ATOM    739  C   ILE A 102     -36.035  21.425   4.819  1.00 16.36           C  
ATOM    740  O   ILE A 102     -35.825  22.523   5.340  1.00 17.82           O  
ATOM    741  CB  ILE A 102     -38.433  21.036   4.091  1.00 15.30           C  
ATOM    742  CG1 ILE A 102     -39.392  21.084   2.892  1.00 14.64           C  
ATOM    743  CG2 ILE A 102     -38.885  22.088   5.133  1.00 17.49           C  
ATOM    744  CD1 ILE A 102     -40.822  20.711   3.217  1.00 15.23           C  
ATOM    745  N   ASP A 103     -35.498  20.290   5.269  1.00 16.46           N  
ATOM    746  CA  ASP A 103     -34.530  20.281   6.380  1.00 17.27           C  
ATOM    747  C   ASP A 103     -33.127  20.710   5.974  1.00 17.32           C  
ATOM    748  O   ASP A 103     -32.476  21.491   6.687  1.00 19.49           O  
ATOM    749  CB  ASP A 103     -34.440  18.895   7.030  1.00 18.11           C  
ATOM    750  CG  ASP A 103     -33.644  18.928   8.301  1.00 21.96           C  
ATOM    751  OD1 ASP A 103     -34.207  19.303   9.336  1.00 22.75           O  
ATOM    752  OD2 ASP A 103     -32.424  18.630   8.260  1.00 27.14           O  
ATOM    753  N   ALA A 104     -32.655  20.208   4.834  1.00 16.17           N  
ATOM    754  CA  ALA A 104     -31.261  20.405   4.419  1.00 16.20           C  
ATOM    755  C   ALA A 104     -31.019  21.713   3.664  1.00 16.09           C  
ATOM    756  O   ALA A 104     -29.901  22.250   3.688  1.00 17.23           O  
ATOM    757  CB  ALA A 104     -30.815  19.224   3.567  1.00 17.16           C  
ATOM    758  N   SER A 105     -32.069  22.212   3.010  1.00 15.44           N  
ATOM    759  CA  SER A 105     -31.977  23.368   2.106  1.00 15.46           C  
ATOM    760  C   SER A 105     -33.148  24.307   2.351  1.00 14.48           C  
ATOM    761  O   SER A 105     -33.840  24.762   1.425  1.00 15.00           O  
ATOM    762  CB  SER A 105     -31.969  22.902   0.637  1.00 15.96           C  
ATOM    763  OG  SER A 105     -30.823  22.102   0.338  1.00 20.02           O  
ATOM    764  N   HIS A 106     -33.348  24.608   3.624  1.00 14.44           N  
ATOM    765  CA  HIS A 106     -34.541  25.330   4.057  1.00 13.80           C  
ATOM    766  C   HIS A 106     -34.733  26.658   3.305  1.00 13.73           C  
ATOM    767  O   HIS A 106     -35.809  26.942   2.785  1.00 13.84           O  
ATOM    768  CB  HIS A 106     -34.468  25.572   5.571  1.00 14.43           C  
ATOM    769  CG  HIS A 106     -35.755  26.023   6.171  1.00 17.59           C  
ATOM    770  ND1 HIS A 106     -36.041  27.349   6.405  1.00 21.40           N  
ATOM    771  CD2 HIS A 106     -36.832  25.321   6.592  1.00 18.64           C  
ATOM    772  CE1 HIS A 106     -37.244  27.444   6.955  1.00 21.19           C  
ATOM    773  NE2 HIS A 106     -37.739  26.228   7.091  1.00 20.50           N  
ATOM    774  N   SER A 107     -33.687  27.485   3.249  1.00 13.03           N  
ATOM    775  CA  SER A 107     -33.808  28.780   2.591  0.50 12.32           C  
ATOM    777  C   SER A 107     -34.128  28.625   1.109  1.00 12.98           C  
ATOM    778  O   SER A 107     -34.998  29.341   0.566  1.00 12.98           O  
ATOM    779  CB  SER A 107     -32.522  29.567   2.781  0.50 12.69           C  
ATOM    781  OG  SER A 107     -32.301  29.824   4.160  0.50 11.51           O  
ATOM    783  N   ALA A 108     -33.430  27.691   0.448  1.00 13.02           N  
ATOM    784  CA  ALA A 108     -33.688  27.474  -0.982  1.00 12.93           C  
ATOM    785  C   ALA A 108     -35.127  27.047  -1.225  1.00 13.03           C  
ATOM    786  O   ALA A 108     -35.775  27.495  -2.191  1.00 14.89           O  
ATOM    787  CB  ALA A 108     -32.755  26.425  -1.546  1.00 14.13           C  
ATOM    788  N   VAL A 109     -35.621  26.141  -0.364  1.00 12.51           N  
ATOM    789  CA  VAL A 109     -37.029  25.668  -0.499  1.00 13.40           C  
ATOM    790  C   VAL A 109     -37.972  26.843  -0.331  1.00 12.97           C  
ATOM    791  O   VAL A 109     -38.927  27.000  -1.094  1.00 13.85           O  
ATOM    792  CB  VAL A 109     -37.372  24.509   0.479  1.00 13.52           C  
ATOM    793  CG1 VAL A 109     -38.905  24.232   0.491  1.00 15.26           C  
ATOM    794  CG2 VAL A 109     -36.544  23.261   0.137  1.00 14.02           C  
ATOM    795  N   ALA A 110     -37.727  27.683   0.676  1.00 13.02           N  
ATOM    796  CA  ALA A 110     -38.588  28.855   0.879  1.00 13.16           C  
ATOM    797  C   ALA A 110     -38.624  29.772  -0.336  1.00 13.30           C  
ATOM    798  O   ALA A 110     -39.686  30.280  -0.728  1.00 15.83           O  
ATOM    799  CB  ALA A 110     -38.127  29.616   2.106  1.00 13.82           C  
ATOM    800  N   ILE A 111     -37.463  29.989  -0.945  1.00 13.31           N  
ATOM    801  CA  ILE A 111     -37.409  30.822  -2.135  1.00 13.20           C  
ATOM    802  C   ILE A 111     -38.175  30.130  -3.274  1.00 14.55           C  
ATOM    803  O   ILE A 111     -38.998  30.748  -3.956  1.00 16.00           O  
ATOM    804  CB  ILE A 111     -35.927  31.038  -2.549  1.00 13.42           C  
ATOM    805  CG1 ILE A 111     -35.209  31.873  -1.496  1.00 13.64           C  
ATOM    806  CG2 ILE A 111     -35.820  31.663  -3.946  1.00 15.90           C  
ATOM    807  CD1 ILE A 111     -33.662  31.701  -1.580  1.00 13.35           C  
ATOM    808  N   TYR A 112     -37.948  28.830  -3.453  1.00 14.87           N  
ATOM    809  CA  TYR A 112     -38.666  28.072  -4.485  1.00 16.63           C  
ATOM    810  C   TYR A 112     -40.188  28.081  -4.315  1.00 17.61           C  
ATOM    811  O   TYR A 112     -40.928  28.194  -5.287  1.00 19.19           O  
ATOM    812  CB  TYR A 112     -38.156  26.648  -4.452  1.00 16.38           C  
ATOM    813  CG  TYR A 112     -38.551  25.793  -5.626  1.00 17.44           C  
ATOM    814  CD1 TYR A 112     -38.254  26.190  -6.927  1.00 15.53           C  
ATOM    815  CD2 TYR A 112     -39.171  24.548  -5.433  1.00 17.96           C  
ATOM    816  CE1 TYR A 112     -38.580  25.387  -8.010  1.00 16.48           C  
ATOM    817  CE2 TYR A 112     -39.502  23.740  -6.514  1.00 19.61           C  
ATOM    818  CZ  TYR A 112     -39.217  24.175  -7.802  1.00 18.15           C  
ATOM    819  OH  TYR A 112     -39.513  23.369  -8.888  1.00 21.04           O  
ATOM    820  N   GLN A 113     -40.641  27.951  -3.075  1.00 17.65           N  
ATOM    821  CA  GLN A 113     -42.068  27.855  -2.779  1.00 18.74           C  
ATOM    822  C   GLN A 113     -42.799  29.191  -2.874  1.00 21.06           C  
ATOM    823  O   GLN A 113     -43.954  29.236  -3.351  1.00 21.46           O  
ATOM    824  CB  GLN A 113     -42.274  27.247  -1.379  1.00 18.37           C  
ATOM    825  CG  GLN A 113     -43.740  27.328  -0.844  1.00 19.73           C  
ATOM    826  CD  GLN A 113     -44.755  26.557  -1.683  1.00 20.72           C  
ATOM    827  OE1 GLN A 113     -44.409  25.749  -2.547  1.00 19.11           O  
ATOM    828  NE2 GLN A 113     -46.039  26.835  -1.433  1.00 22.11           N  
ATOM    829  N   ASP A 114     -42.180  30.261  -2.365  1.00 22.09           N  
ATOM    830  CA  ASP A 114     -42.907  31.522  -2.105  1.00 24.61           C  
ATOM    831  C   ASP A 114     -42.317  32.693  -2.811  1.00 26.10           C  
ATOM    832  O   ASP A 114     -42.924  33.757  -2.802  1.00 26.82           O  
ATOM    833  CB  ASP A 114     -42.981  31.864  -0.596  1.00 24.51           C  
ATOM    834  CG  ASP A 114     -44.033  31.059   0.130  1.00 25.82           C  
ATOM    835  OD1 ASP A 114     -45.037  30.680  -0.502  1.00 28.07           O  
ATOM    836  OD2 ASP A 114     -43.868  30.802   1.347  1.00 27.37           O  
ATOM    837  N   GLU A 115     -41.139  32.533  -3.419  1.00 27.25           N  
ATOM    838  CA  GLU A 115     -40.397  33.710  -3.901  1.00 29.05           C  
ATOM    839  C   GLU A 115     -40.128  33.865  -5.388  1.00 29.47           C  
ATOM    840  O   GLU A 115     -39.577  34.912  -5.781  1.00 30.21           O  
ATOM    841  CB  GLU A 115     -39.066  33.852  -3.167  1.00 29.56           C  
ATOM    842  CG  GLU A 115     -39.135  34.768  -2.010  1.00 32.56           C  
ATOM    843  CD  GLU A 115     -39.995  35.979  -2.326  1.00 34.06           C  
ATOM    844  OE1 GLU A 115     -39.721  36.689  -3.335  1.00 35.44           O  
ATOM    845  OE2 GLU A 115     -40.975  36.188  -1.571  1.00 34.53           O  
ATOM    846  N   VAL A 116     -40.526  32.878  -6.190  1.00 29.57           N  
ATOM    847  CA  VAL A 116     -40.130  32.797  -7.616  1.00 30.77           C  
ATOM    848  C   VAL A 116     -41.246  32.904  -8.648  1.00 31.09           C  
ATOM    849  O   VAL A 116     -41.033  32.626  -9.846  1.00 30.79           O  
ATOM    850  CB  VAL A 116     -39.284  31.518  -7.920  1.00 30.61           C  
ATOM    851  CG1 VAL A 116     -38.015  31.482  -7.044  1.00 31.12           C  
ATOM    852  CG2 VAL A 116     -40.108  30.221  -7.783  1.00 31.71           C  
ATOM    853  N   LYS A 117     -42.441  33.282  -8.193  1.00 31.14           N  
ATOM    854  CA  LYS A 117     -43.561  33.517  -9.115  1.00 31.29           C  
ATOM    855  C   LYS A 117     -43.138  34.419 -10.273  1.00 31.15           C  
ATOM    856  O   LYS A 117     -43.428  34.154 -11.437  1.00 31.60           O  
ATOM    857  CB  LYS A 117     -44.730  34.158  -8.364  1.00 31.74           C  
ATOM    858  CG  LYS A 117     -45.513  33.146  -7.558  1.00 33.93           C  
ATOM    859  CD  LYS A 117     -46.167  33.782  -6.350  1.00 36.58           C  
ATOM    860  CE  LYS A 117     -46.967  32.737  -5.598  1.00 38.25           C  
ATOM    861  NZ  LYS A 117     -48.313  33.265  -5.261  1.00 39.51           N  
ATOM    862  N   HIS A 118     -42.407  35.461  -9.924  1.00 30.97           N  
ATOM    863  CA  HIS A 118     -42.036  36.495 -10.863  1.00 31.36           C  
ATOM    864  C   HIS A 118     -40.711  36.213 -11.608  1.00 30.64           C  
ATOM    865  O   HIS A 118     -40.279  37.044 -12.414  1.00 31.04           O  
ATOM    866  CB  HIS A 118     -41.918  37.810 -10.099  1.00 32.53           C  
ATOM    867  CG  HIS A 118     -40.674  37.887  -9.276  1.00 35.87           C  
ATOM    868  ND1 HIS A 118     -40.471  37.096  -8.165  1.00 37.98           N  
ATOM    869  CD2 HIS A 118     -39.540  38.608  -9.440  1.00 37.68           C  
ATOM    870  CE1 HIS A 118     -39.275  37.349  -7.662  1.00 39.40           C  
ATOM    871  NE2 HIS A 118     -38.686  38.256  -8.423  1.00 39.11           N  
ATOM    872  N   LEU A 119     -40.044  35.090 -11.334  1.00 29.06           N  
ATOM    873  CA  LEU A 119     -38.838  34.757 -12.107  1.00 28.58           C  
ATOM    874  C   LEU A 119     -39.167  34.163 -13.480  1.00 29.70           C  
ATOM    875  O   LEU A 119     -38.298  34.097 -14.350  1.00 30.05           O  
ATOM    876  CB  LEU A 119     -37.921  33.800 -11.351  1.00 27.67           C  
ATOM    877  CG  LEU A 119     -37.239  34.350 -10.100  1.00 25.73           C  
ATOM    878  CD1 LEU A 119     -36.472  33.232  -9.417  1.00 24.94           C  
ATOM    879  CD2 LEU A 119     -36.322  35.539 -10.457  1.00 24.79           C  
ATOM    880  N   VAL A 120     -40.419  33.739 -13.650  1.00 30.45           N  
ATOM    881  CA  VAL A 120     -40.918  33.160 -14.910  1.00 31.51           C  
ATOM    882  C   VAL A 120     -40.723  34.122 -16.076  1.00 30.06           C  
ATOM    883  O   VAL A 120     -40.427  33.693 -17.191  1.00 31.28           O  
ATOM    884  CB  VAL A 120     -42.419  32.759 -14.792  1.00 31.77           C  
ATOM    885  CG1 VAL A 120     -42.956  32.186 -16.109  1.00 33.79           C  
ATOM    886  CG2 VAL A 120     -42.602  31.758 -13.671  1.00 33.53           C  
ATOM    887  N   ALA A 121     -40.859  35.418 -15.804  1.00 28.51           N  
ATOM    888  CA  ALA A 121     -40.692  36.453 -16.820  1.00 26.62           C  
ATOM    889  C   ALA A 121     -39.247  36.554 -17.354  1.00 25.07           C  
ATOM    890  O   ALA A 121     -39.023  37.089 -18.443  1.00 24.05           O  
ATOM    891  CB  ALA A 121     -41.150  37.810 -16.261  1.00 27.11           C  
ATOM    892  N   ASN A 122     -38.285  36.035 -16.590  1.00 22.77           N  
ATOM    893  CA  ASN A 122     -36.856  36.216 -16.839  1.00 20.78           C  
ATOM    894  C   ASN A 122     -36.286  34.996 -17.573  1.00 19.91           C  
ATOM    895  O   ASN A 122     -36.330  33.870 -17.058  1.00 19.29           O  
ATOM    896  CB  ASN A 122     -36.139  36.457 -15.483  1.00 20.95           C  
ATOM    897  CG  ASN A 122     -34.628  36.782 -15.616  1.00 19.48           C  
ATOM    898  OD1 ASN A 122     -33.965  36.402 -16.600  1.00 18.80           O  
ATOM    899  ND2 ASN A 122     -34.072  37.492 -14.596  1.00 19.63           N  
ATOM    900  N   GLU A 123     -35.777  35.242 -18.782  1.00 19.73           N  
ATOM    901  CA  GLU A 123     -35.065  34.289 -19.657  0.50 20.20           C  
ATOM    903  C   GLU A 123     -34.156  33.345 -18.885  1.00 19.49           C  
ATOM    904  O   GLU A 123     -34.016  32.156 -19.178  1.00 19.57           O  
ATOM    905  CB  GLU A 123     -34.146  35.080 -20.628  0.50 20.28           C  
ATOM    907  CG  GLU A 123     -34.827  36.065 -21.603  0.50 21.50           C  
ATOM    909  CD  GLU A 123     -33.962  37.292 -21.973  0.50 21.25           C  
ATOM    911  OE1 GLU A 123     -32.731  37.168 -22.148  0.50 23.78           O  
ATOM    913  OE2 GLU A 123     -34.526  38.399 -22.104  0.50 21.15           O  
ATOM    915  N   ARG A 124     -33.437  33.936 -17.936  1.00 17.23           N  
ATOM    916  CA  ARG A 124     -32.393  33.213 -17.233  1.00 17.67           C  
ATOM    917  C   ARG A 124     -32.962  32.057 -16.410  1.00 16.27           C  
ATOM    918  O   ARG A 124     -32.246  31.103 -16.049  1.00 17.95           O  
ATOM    919  CB  ARG A 124     -31.672  34.175 -16.303  1.00 18.22           C  
ATOM    920  CG  ARG A 124     -30.597  33.527 -15.528  1.00 21.02           C  
ATOM    921  CD  ARG A 124     -29.851  34.499 -14.752  1.00 23.30           C  
ATOM    922  NE  ARG A 124     -28.674  33.808 -14.289  1.00 25.45           N  
ATOM    923  CZ  ARG A 124     -27.520  34.384 -14.047  1.00 23.11           C  
ATOM    924  NH1 ARG A 124     -27.384  35.719 -14.176  1.00 21.05           N  
ATOM    925  NH2 ARG A 124     -26.531  33.605 -13.634  1.00 21.62           N  
ATOM    926  N   PHE A 125     -34.247  32.156 -16.111  1.00 15.15           N  
ATOM    927  CA  PHE A 125     -34.899  31.171 -15.232  1.00 14.34           C  
ATOM    928  C   PHE A 125     -35.931  30.310 -15.959  1.00 15.08           C  
ATOM    929  O   PHE A 125     -36.805  29.713 -15.335  1.00 14.96           O  
ATOM    930  CB  PHE A 125     -35.501  31.872 -14.022  1.00 14.49           C  
ATOM    931  CG  PHE A 125     -34.465  32.543 -13.155  1.00 14.00           C  
ATOM    932  CD1 PHE A 125     -33.782  31.818 -12.182  1.00 13.13           C  
ATOM    933  CD2 PHE A 125     -34.155  33.881 -13.323  1.00 16.01           C  
ATOM    934  CE1 PHE A 125     -32.795  32.434 -11.382  1.00 14.14           C  
ATOM    935  CE2 PHE A 125     -33.164  34.505 -12.524  1.00 16.85           C  
ATOM    936  CZ  PHE A 125     -32.500  33.771 -11.559  1.00 15.63           C  
ATOM    937  N   THR A 126     -35.810  30.226 -17.276  1.00 15.44           N  
ATOM    938  CA  THR A 126     -36.689  29.316 -18.032  1.00 15.67           C  
ATOM    939  C   THR A 126     -36.679  27.885 -17.483  1.00 15.47           C  
ATOM    940  O   THR A 126     -37.720  27.195 -17.508  1.00 15.59           O  
ATOM    941  CB  THR A 126     -36.310  29.330 -19.503  1.00 16.98           C  
ATOM    942  OG1 THR A 126     -36.448  30.664 -19.987  1.00 19.41           O  
ATOM    943  CG2 THR A 126     -37.251  28.430 -20.292  1.00 18.08           C  
ATOM    944  N   TYR A 127     -35.535  27.465 -16.938  1.00 15.05           N  
ATOM    945  CA  TYR A 127     -35.428  26.120 -16.377  1.00 15.10           C  
ATOM    946  C   TYR A 127     -36.454  25.854 -15.287  1.00 15.05           C  
ATOM    947  O   TYR A 127     -36.831  24.702 -15.058  1.00 14.28           O  
ATOM    948  CB  TYR A 127     -34.023  25.798 -15.872  1.00 15.55           C  
ATOM    949  CG  TYR A 127     -33.560  26.580 -14.663  1.00 15.72           C  
ATOM    950  CD1 TYR A 127     -32.874  27.782 -14.805  1.00 16.27           C  
ATOM    951  CD2 TYR A 127     -33.755  26.083 -13.378  1.00 15.81           C  
ATOM    952  CE1 TYR A 127     -32.419  28.488 -13.681  1.00 15.24           C  
ATOM    953  CE2 TYR A 127     -33.305  26.779 -12.249  1.00 16.63           C  
ATOM    954  CZ  TYR A 127     -32.642  27.981 -12.413  1.00 15.12           C  
ATOM    955  OH  TYR A 127     -32.196  28.659 -11.320  1.00 15.02           O  
ATOM    956  N   LEU A 128     -36.905  26.900 -14.597  1.00 14.08           N  
ATOM    957  CA  LEU A 128     -37.948  26.699 -13.571  1.00 14.23           C  
ATOM    958  C   LEU A 128     -39.230  26.135 -14.200  1.00 14.12           C  
ATOM    959  O   LEU A 128     -39.831  25.203 -13.645  1.00 13.87           O  
ATOM    960  CB  LEU A 128     -38.267  27.989 -12.820  1.00 15.48           C  
ATOM    961  CG  LEU A 128     -37.115  28.499 -11.952  1.00 16.06           C  
ATOM    962  CD1 LEU A 128     -37.487  29.849 -11.346  1.00 16.95           C  
ATOM    963  CD2 LEU A 128     -36.701  27.450 -10.877  1.00 15.60           C  
ATOM    964  N   SER A 129     -39.642  26.668 -15.354  1.00 14.30           N  
ATOM    965  CA  SER A 129     -40.860  26.142 -15.990  0.50 14.28           C  
ATOM    967  C   SER A 129     -40.630  24.730 -16.518  1.00 14.51           C  
ATOM    968  O   SER A 129     -41.521  23.903 -16.448  1.00 15.29           O  
ATOM    969  CB  SER A 129     -41.377  27.063 -17.099  0.50 14.64           C  
ATOM    971  OG  SER A 129     -40.443  27.132 -18.148  0.50 14.49           O  
ATOM    973  N   GLU A 130     -39.424  24.462 -17.013  1.00 13.62           N  
ATOM    974  CA  GLU A 130     -39.071  23.118 -17.491  1.00 14.00           C  
ATOM    975  C   GLU A 130     -39.174  22.149 -16.330  1.00 13.48           C  
ATOM    976  O   GLU A 130     -39.687  21.019 -16.473  1.00 13.21           O  
ATOM    977  CB  GLU A 130     -37.664  23.099 -18.089  1.00 15.78           C  
ATOM    978  CG  GLU A 130     -37.601  23.956 -19.364  1.00 18.13           C  
ATOM    979  CD  GLU A 130     -36.189  24.176 -19.892  1.00 23.12           C  
ATOM    980  OE1 GLU A 130     -35.207  23.874 -19.167  1.00 24.44           O  
ATOM    981  OE2 GLU A 130     -36.065  24.661 -21.045  1.00 27.54           O  
ATOM    982  N   LEU A 131     -38.672  22.571 -15.175  1.00 12.40           N  
ATOM    983  CA  LEU A 131     -38.751  21.675 -14.012  1.00 12.38           C  
ATOM    984  C   LEU A 131     -40.176  21.481 -13.523  1.00 12.48           C  
ATOM    985  O   LEU A 131     -40.505  20.400 -13.036  1.00 14.59           O  
ATOM    986  CB  LEU A 131     -37.861  22.170 -12.863  1.00 12.67           C  
ATOM    987  CG  LEU A 131     -36.335  22.056 -13.100  1.00 13.38           C  
ATOM    988  CD1 LEU A 131     -35.602  22.799 -11.977  1.00 15.64           C  
ATOM    989  CD2 LEU A 131     -35.847  20.601 -13.178  1.00 15.23           C  
ATOM    990  N   ASN A 132     -41.027  22.500 -13.647  1.00 12.93           N  
ATOM    991  CA  ASN A 132     -42.442  22.285 -13.321  1.00 14.72           C  
ATOM    992  C   ASN A 132     -43.084  21.236 -14.229  1.00 13.78           C  
ATOM    993  O   ASN A 132     -43.800  20.355 -13.757  1.00 14.69           O  
ATOM    994  CB  ASN A 132     -43.250  23.573 -13.382  1.00 16.26           C  
ATOM    995  CG  ASN A 132     -42.959  24.505 -12.236  1.00 18.74           C  
ATOM    996  OD1 ASN A 132     -42.533  24.089 -11.158  1.00 23.15           O  
ATOM    997  ND2 ASN A 132     -43.228  25.790 -12.464  1.00 24.43           N  
ATOM    998  N   THR A 133     -42.780  21.310 -15.516  1.00 12.99           N  
ATOM    999  CA  THR A 133     -43.299  20.326 -16.463  1.00 12.31           C  
ATOM   1000  C   THR A 133     -42.791  18.938 -16.070  1.00 12.65           C  
ATOM   1001  O   THR A 133     -43.571  17.967 -16.064  1.00 13.37           O  
ATOM   1002  CB  THR A 133     -42.868  20.700 -17.879  1.00 12.75           C  
ATOM   1003  OG1 THR A 133     -43.452  21.971 -18.182  1.00 15.66           O  
ATOM   1004  CG2 THR A 133     -43.293  19.638 -18.933  1.00 14.23           C  
ATOM   1005  N   GLU A 134     -41.489  18.853 -15.773  1.00 12.99           N  
ATOM   1006  CA  GLU A 134     -40.863  17.576 -15.432  1.00 13.52           C  
ATOM   1007  C   GLU A 134     -41.384  16.992 -14.100  1.00 13.13           C  
ATOM   1008  O   GLU A 134     -41.617  15.782 -13.990  1.00 14.21           O  
ATOM   1009  CB  GLU A 134     -39.353  17.689 -15.396  1.00 13.26           C  
ATOM   1010  CG  GLU A 134     -38.736  16.324 -15.224  1.00 14.51           C  
ATOM   1011  CD  GLU A 134     -37.251  16.332 -15.164  1.00 16.26           C  
ATOM   1012  OE1 GLU A 134     -36.645  17.423 -15.186  1.00 17.64           O  
ATOM   1013  OE2 GLU A 134     -36.686  15.215 -15.106  1.00 20.22           O  
ATOM   1014  N   PHE A 135     -41.568  17.861 -13.102  1.00 13.00           N  
ATOM   1015  CA  PHE A 135     -42.088  17.424 -11.812  1.00 12.78           C  
ATOM   1016  C   PHE A 135     -43.479  16.759 -12.024  1.00 12.54           C  
ATOM   1017  O   PHE A 135     -43.783  15.684 -11.446  1.00 14.20           O  
ATOM   1018  CB  PHE A 135     -42.227  18.625 -10.893  1.00 13.07           C  
ATOM   1019  CG  PHE A 135     -42.725  18.284  -9.512  1.00 12.03           C  
ATOM   1020  CD1 PHE A 135     -41.816  17.984  -8.486  1.00 12.93           C  
ATOM   1021  CD2 PHE A 135     -44.093  18.335  -9.218  1.00 13.99           C  
ATOM   1022  CE1 PHE A 135     -42.277  17.689  -7.205  1.00 14.57           C  
ATOM   1023  CE2 PHE A 135     -44.549  18.038  -7.932  1.00 14.20           C  
ATOM   1024  CZ  PHE A 135     -43.661  17.737  -6.924  1.00 13.12           C  
ATOM   1025  N   ARG A 136     -44.309  17.372 -12.886  1.00 12.91           N  
ATOM   1026  CA  ARG A 136     -45.654  16.814 -13.175  1.00 13.34           C  
ATOM   1027  C   ARG A 136     -45.487  15.459 -13.866  1.00 13.62           C  
ATOM   1028  O   ARG A 136     -46.152  14.486 -13.513  1.00 14.85           O  
ATOM   1029  CB  ARG A 136     -46.487  17.790 -14.017  1.00 12.93           C  
ATOM   1030  CG  ARG A 136     -47.875  17.229 -14.363  1.00 13.14           C  
ATOM   1031  CD  ARG A 136     -48.789  18.335 -14.925  1.00 14.42           C  
ATOM   1032  NE  ARG A 136     -49.997  17.767 -15.530  1.00 15.66           N  
ATOM   1033  CZ  ARG A 136     -50.035  17.166 -16.719  1.00 14.34           C  
ATOM   1034  NH1 ARG A 136     -48.930  17.054 -17.463  1.00 16.46           N  
ATOM   1035  NH2 ARG A 136     -51.192  16.679 -17.194  1.00 15.74           N  
ATOM   1036  N   GLU A 137     -44.608  15.387 -14.868  1.00 13.82           N  
ATOM   1037  CA  GLU A 137     -44.371  14.133 -15.597  0.50 14.16           C  
ATOM   1039  C   GLU A 137     -43.959  13.014 -14.634  1.00 14.21           C  
ATOM   1040  O   GLU A 137     -44.494  11.905 -14.682  1.00 14.54           O  
ATOM   1041  CB  GLU A 137     -43.323  14.327 -16.691  0.50 14.72           C  
ATOM   1043  CG  GLU A 137     -43.030  13.048 -17.456  0.50 15.21           C  
ATOM   1045  CD  GLU A 137     -44.213  12.518 -18.266  0.50 16.92           C  
ATOM   1047  OE1 GLU A 137     -45.154  13.276 -18.567  0.50 19.25           O  
ATOM   1049  OE2 GLU A 137     -44.180  11.334 -18.645  0.50 18.97           O  
ATOM   1051  N   LEU A 138     -43.024  13.340 -13.746  1.00 13.77           N  
ATOM   1052  CA  LEU A 138     -42.488  12.345 -12.813  1.00 14.78           C  
ATOM   1053  C   LEU A 138     -43.544  11.891 -11.815  1.00 14.93           C  
ATOM   1054  O   LEU A 138     -43.808  10.703 -11.656  1.00 15.88           O  
ATOM   1055  CB  LEU A 138     -41.258  12.903 -12.076  1.00 15.90           C  
ATOM   1056  CG  LEU A 138     -39.923  13.051 -12.862  1.00 17.16           C  
ATOM   1057  CD1 LEU A 138     -38.979  13.989 -12.111  1.00 20.12           C  
ATOM   1058  CD2 LEU A 138     -39.261  11.717 -13.041  1.00 18.23           C  
ATOM   1059  N   TRP A 139     -44.113  12.854 -11.092  1.00 15.23           N  
ATOM   1060  CA  TRP A 139     -45.029  12.515 -10.012  1.00 14.82           C  
ATOM   1061  C   TRP A 139     -46.375  12.027 -10.544  1.00 14.77           C  
ATOM   1062  O   TRP A 139     -46.949  11.048 -10.005  1.00 15.43           O  
ATOM   1063  CB  TRP A 139     -45.212  13.723  -9.106  1.00 16.04           C  
ATOM   1064  CG  TRP A 139     -44.015  14.037  -8.208  1.00 15.82           C  
ATOM   1065  CD1 TRP A 139     -42.704  14.288  -8.577  1.00 16.39           C  
ATOM   1066  CD2 TRP A 139     -44.058  14.161  -6.786  1.00 14.49           C  
ATOM   1067  NE1 TRP A 139     -41.941  14.555  -7.449  1.00 16.51           N  
ATOM   1068  CE2 TRP A 139     -42.751  14.471  -6.342  1.00 14.88           C  
ATOM   1069  CE3 TRP A 139     -45.078  14.007  -5.846  1.00 17.53           C  
ATOM   1070  CZ2 TRP A 139     -42.451  14.660  -5.001  1.00 16.61           C  
ATOM   1071  CZ3 TRP A 139     -44.768  14.188  -4.498  1.00 17.43           C  
ATOM   1072  CH2 TRP A 139     -43.476  14.540  -4.100  1.00 18.32           C  
HETATM 1073  N   MSE A 140     -46.940  12.719 -11.537  1.00 15.57           N  
HETATM 1074  CA  MSE A 140     -48.209  12.279 -12.072  1.00 16.79           C  
HETATM 1075  C   MSE A 140     -48.042  10.930 -12.791  1.00 16.53           C  
HETATM 1076  O   MSE A 140     -48.939  10.109 -12.776  1.00 17.47           O  
HETATM 1077  CB  MSE A 140     -48.913  13.380 -12.886  1.00 16.77           C  
HETATM 1078  CG  MSE A 140     -50.363  13.063 -13.217  1.00 16.10           C  
HETATM 1079 SE   MSE A 140     -51.041  14.655 -14.044  1.00 20.13          SE  
HETATM 1080  CE  MSE A 140     -52.479  13.735 -14.976  1.00 15.84           C  
ATOM   1081  N   GLY A 141     -46.855  10.659 -13.346  1.00 16.90           N  
ATOM   1082  CA  GLY A 141     -46.569   9.347 -13.893  1.00 16.05           C  
ATOM   1083  C   GLY A 141     -46.626   8.225 -12.857  1.00 15.04           C  
ATOM   1084  O   GLY A 141     -47.161   7.151 -13.102  1.00 16.07           O  
ATOM   1085  N   VAL A 142     -46.079   8.501 -11.674  1.00 14.67           N  
ATOM   1086  CA  VAL A 142     -46.154   7.551 -10.557  1.00 13.41           C  
ATOM   1087  C   VAL A 142     -47.600   7.305 -10.155  1.00 13.78           C  
ATOM   1088  O   VAL A 142     -48.008   6.151  -9.888  1.00 14.44           O  
ATOM   1089  CB  VAL A 142     -45.289   8.033  -9.366  1.00 13.19           C  
ATOM   1090  CG1 VAL A 142     -45.554   7.189  -8.121  1.00 15.87           C  
ATOM   1091  CG2 VAL A 142     -43.802   8.006  -9.765  1.00 13.56           C  
ATOM   1092  N   LEU A 143     -48.381   8.384 -10.089  1.00 13.24           N  
ATOM   1093  CA  LEU A 143     -49.795   8.209  -9.776  1.00 12.68           C  
ATOM   1094  C   LEU A 143     -50.514   7.349 -10.801  1.00 13.21           C  
ATOM   1095  O   LEU A 143     -51.275   6.451 -10.430  1.00 14.28           O  
ATOM   1096  CB  LEU A 143     -50.483   9.549  -9.660  1.00 13.18           C  
ATOM   1097  CG  LEU A 143     -50.064  10.356  -8.425  1.00 13.91           C  
ATOM   1098  CD1 LEU A 143     -50.704  11.769  -8.526  1.00 16.44           C  
ATOM   1099  CD2 LEU A 143     -50.477   9.712  -7.143  1.00 15.59           C  
ATOM   1100  N   GLU A 144     -50.254   7.617 -12.084  1.00 14.21           N  
ATOM   1101  CA  GLU A 144     -50.930   6.873 -13.151  1.00 15.82           C  
ATOM   1102  C   GLU A 144     -50.579   5.381 -13.053  1.00 15.54           C  
ATOM   1103  O   GLU A 144     -51.456   4.497 -13.184  1.00 17.25           O  
ATOM   1104  CB  GLU A 144     -50.564   7.439 -14.531  1.00 16.27           C  
ATOM   1105  CG  GLU A 144     -51.278   8.747 -14.775  1.00 18.98           C  
ATOM   1106  CD  GLU A 144     -50.978   9.390 -16.100  1.00 23.43           C  
ATOM   1107  OE1 GLU A 144     -50.336   8.767 -16.975  1.00 26.91           O  
ATOM   1108  OE2 GLU A 144     -51.384  10.552 -16.271  1.00 26.79           O  
ATOM   1109  N   ALA A 145     -49.292   5.098 -12.853  1.00 15.93           N  
ATOM   1110  CA  ALA A 145     -48.805   3.713 -12.763  1.00 15.61           C  
ATOM   1111  C   ALA A 145     -49.412   3.012 -11.542  1.00 15.41           C  
ATOM   1112  O   ALA A 145     -49.749   1.834 -11.597  1.00 16.04           O  
ATOM   1113  CB  ALA A 145     -47.279   3.704 -12.690  1.00 16.53           C  
ATOM   1114  N   GLY A 146     -49.612   3.749 -10.452  1.00 14.56           N  
ATOM   1115  CA  GLY A 146     -50.160   3.129  -9.255  1.00 14.35           C  
ATOM   1116  C   GLY A 146     -51.677   2.957  -9.333  1.00 14.17           C  
ATOM   1117  O   GLY A 146     -52.243   2.070  -8.700  1.00 15.26           O  
ATOM   1118  N   VAL A 147     -52.353   3.803 -10.099  1.00 13.90           N  
ATOM   1119  CA  VAL A 147     -53.773   3.497 -10.349  1.00 15.11           C  
ATOM   1120  C   VAL A 147     -53.876   2.215 -11.202  1.00 15.99           C  
ATOM   1121  O   VAL A 147     -54.645   1.287 -10.870  1.00 16.73           O  
ATOM   1122  CB  VAL A 147     -54.507   4.662 -10.990  1.00 14.29           C  
ATOM   1123  CG1 VAL A 147     -55.921   4.218 -11.426  1.00 15.67           C  
ATOM   1124  CG2 VAL A 147     -54.635   5.816  -9.975  1.00 14.71           C  
ATOM   1125  N   LYS A 148     -53.070   2.145 -12.266  1.00 16.62           N  
ATOM   1126  CA  LYS A 148     -53.154   1.019 -13.210  1.00 17.25           C  
ATOM   1127  C   LYS A 148     -52.831  -0.300 -12.510  1.00 15.87           C  
ATOM   1128  O   LYS A 148     -53.437  -1.350 -12.809  1.00 18.74           O  
ATOM   1129  CB  LYS A 148     -52.223   1.275 -14.397  1.00 17.43           C  
ATOM   1130  CG  LYS A 148     -52.321   0.243 -15.514  1.00 20.70           C  
ATOM   1131  CD  LYS A 148     -51.300   0.536 -16.575  1.00 24.27           C  
ATOM   1132  CE  LYS A 148     -51.418  -0.481 -17.702  1.00 26.31           C  
ATOM   1133  NZ  LYS A 148     -51.630  -1.863 -17.161  1.00 27.57           N  
ATOM   1134  N   ASP A 149     -51.865  -0.262 -11.592  1.00 16.75           N  
ATOM   1135  CA  ASP A 149     -51.463  -1.480 -10.891  1.00 17.15           C  
ATOM   1136  C   ASP A 149     -52.251  -1.794  -9.600  1.00 17.13           C  
ATOM   1137  O   ASP A 149     -51.970  -2.778  -8.906  1.00 19.03           O  
ATOM   1138  CB  ASP A 149     -49.937  -1.538 -10.700  1.00 17.23           C  
ATOM   1139  CG  ASP A 149     -49.427  -0.639  -9.567  1.00 17.45           C  
ATOM   1140  OD1 ASP A 149     -50.227  -0.184  -8.701  1.00 19.76           O  
ATOM   1141  OD2 ASP A 149     -48.190  -0.443  -9.550  1.00 19.14           O  
ATOM   1142  N   GLY A 150     -53.247  -0.970  -9.279  1.00 16.75           N  
ATOM   1143  CA  GLY A 150     -54.110  -1.236  -8.138  1.00 17.13           C  
ATOM   1144  C   GLY A 150     -53.645  -0.675  -6.803  1.00 17.45           C  
ATOM   1145  O   GLY A 150     -54.342  -0.827  -5.808  1.00 18.22           O  
ATOM   1146  N   SER A 151     -52.501   0.022  -6.787  1.00 16.41           N  
ATOM   1147  CA  SER A 151     -51.964   0.545  -5.516  1.00 15.43           C  
ATOM   1148  C   SER A 151     -52.765   1.729  -5.021  1.00 15.09           C  
ATOM   1149  O   SER A 151     -52.879   1.961  -3.806  1.00 15.64           O  
ATOM   1150  CB  SER A 151     -50.507   0.997  -5.675  1.00 15.27           C  
ATOM   1151  OG  SER A 151     -49.661  -0.054  -6.109  1.00 17.05           O  
ATOM   1152  N   PHE A 152     -53.242   2.518  -5.974  1.00 13.74           N  
ATOM   1153  CA  PHE A 152     -53.984   3.741  -5.648  1.00 14.07           C  
ATOM   1154  C   PHE A 152     -55.393   3.631  -6.178  1.00 14.95           C  
ATOM   1155  O   PHE A 152     -55.655   2.895  -7.144  1.00 14.91           O  
ATOM   1156  CB  PHE A 152     -53.330   5.000  -6.249  1.00 14.00           C  
ATOM   1157  CG  PHE A 152     -51.853   5.160  -5.911  1.00 12.20           C  
ATOM   1158  CD1 PHE A 152     -51.377   4.861  -4.635  1.00 13.73           C  
ATOM   1159  CD2 PHE A 152     -50.953   5.604  -6.870  1.00 12.41           C  
ATOM   1160  CE1 PHE A 152     -49.996   5.018  -4.327  1.00 13.90           C  
ATOM   1161  CE2 PHE A 152     -49.602   5.743  -6.582  1.00 12.83           C  
ATOM   1162  CZ  PHE A 152     -49.119   5.452  -5.301  1.00 12.75           C  
ATOM   1163  N   ARG A 153     -56.299   4.393  -5.567  1.00 15.66           N  
ATOM   1164  CA  ARG A 153     -57.726   4.265  -5.861  1.00 16.17           C  
ATOM   1165  C   ARG A 153     -58.022   4.689  -7.279  1.00 16.43           C  
ATOM   1166  O   ARG A 153     -57.413   5.614  -7.784  1.00 16.99           O  
ATOM   1167  CB  ARG A 153     -58.549   5.141  -4.913  1.00 16.10           C  
ATOM   1168  CG  ARG A 153     -58.631   4.590  -3.515  1.00 17.07           C  
ATOM   1169  CD  ARG A 153     -59.003   5.716  -2.533  1.00 18.47           C  
ATOM   1170  NE  ARG A 153     -60.257   6.331  -2.934  1.00 19.02           N  
ATOM   1171  CZ  ARG A 153     -60.766   7.412  -2.374  1.00 16.40           C  
ATOM   1172  NH1 ARG A 153     -60.084   8.066  -1.414  1.00 15.69           N  
ATOM   1173  NH2 ARG A 153     -61.937   7.852  -2.812  1.00 18.70           N  
ATOM   1174  N   SER A 154     -58.996   4.031  -7.896  1.00 16.80           N  
ATOM   1175  CA  SER A 154     -59.376   4.359  -9.264  1.00 18.44           C  
ATOM   1176  C   SER A 154     -60.514   5.382  -9.333  1.00 17.92           C  
ATOM   1177  O   SER A 154     -60.956   5.738 -10.430  1.00 20.29           O  
ATOM   1178  CB  SER A 154     -59.805   3.087  -9.990  1.00 19.04           C  
ATOM   1179  OG  SER A 154     -60.903   2.529  -9.321  1.00 22.12           O  
ATOM   1180  N   ASP A 155     -60.979   5.863  -8.184  1.00 16.23           N  
ATOM   1181  CA  ASP A 155     -62.048   6.854  -8.158  1.00 16.16           C  
ATOM   1182  C   ASP A 155     -61.602   8.273  -7.769  1.00 16.33           C  
ATOM   1183  O   ASP A 155     -62.443   9.126  -7.430  1.00 17.79           O  
ATOM   1184  CB  ASP A 155     -63.193   6.409  -7.248  1.00 14.33           C  
ATOM   1185  CG  ASP A 155     -62.775   6.213  -5.806  1.00 15.83           C  
ATOM   1186  OD1 ASP A 155     -61.572   6.089  -5.554  1.00 16.46           O  
ATOM   1187  OD2 ASP A 155     -63.675   6.127  -4.932  1.00 20.23           O  
ATOM   1188  N   ILE A 156     -60.300   8.527  -7.827  1.00 15.24           N  
ATOM   1189  CA  ILE A 156     -59.758   9.853  -7.601  1.00 15.22           C  
ATOM   1190  C   ILE A 156     -59.129  10.299  -8.931  1.00 14.44           C  
ATOM   1191  O   ILE A 156     -58.390   9.556  -9.559  1.00 16.17           O  
ATOM   1192  CB  ILE A 156     -58.701   9.855  -6.459  1.00 16.71           C  
ATOM   1193  CG1 ILE A 156     -59.355   9.566  -5.093  1.00 18.77           C  
ATOM   1194  CG2 ILE A 156     -57.949  11.170  -6.413  1.00 19.20           C  
ATOM   1195  CD1 ILE A 156     -60.352  10.637  -4.604  1.00 22.86           C  
ATOM   1196  N   ASP A 157     -59.419  11.518  -9.341  1.00 11.33           N  
ATOM   1197  CA  ASP A 157     -58.822  12.053 -10.547  1.00 10.29           C  
ATOM   1198  C   ASP A 157     -57.323  12.249 -10.348  1.00 10.58           C  
ATOM   1199  O   ASP A 157     -56.890  12.877  -9.374  1.00 10.93           O  
ATOM   1200  CB  ASP A 157     -59.491  13.376 -10.940  1.00 10.64           C  
ATOM   1201  CG  ASP A 157     -58.899  13.931 -12.209  1.00  9.51           C  
ATOM   1202  OD1 ASP A 157     -59.403  13.550 -13.289  1.00 10.69           O  
ATOM   1203  OD2 ASP A 157     -57.880  14.661 -12.108  1.00 11.32           O  
ATOM   1204  N   VAL A 158     -56.540  11.712 -11.280  1.00 10.99           N  
ATOM   1205  CA  VAL A 158     -55.075  11.769 -11.131  1.00 12.48           C  
ATOM   1206  C   VAL A 158     -54.472  13.175 -11.248  1.00 12.12           C  
ATOM   1207  O   VAL A 158     -53.472  13.482 -10.587  1.00 12.05           O  
ATOM   1208  CB  VAL A 158     -54.367  10.795 -12.096  1.00 13.65           C  
ATOM   1209  CG1 VAL A 158     -52.878  10.984 -12.053  1.00 17.05           C  
ATOM   1210  CG2 VAL A 158     -54.728   9.399 -11.671  1.00 16.42           C  
ATOM   1211  N   GLU A 159     -55.098  14.041 -12.045  1.00 10.95           N  
ATOM   1212  CA  GLU A 159     -54.585  15.411 -12.153  1.00 11.11           C  
ATOM   1213  C   GLU A 159     -54.859  16.139 -10.831  1.00 11.14           C  
ATOM   1214  O   GLU A 159     -53.982  16.825 -10.321  1.00 11.57           O  
ATOM   1215  CB  GLU A 159     -55.251  16.168 -13.307  1.00 11.16           C  
ATOM   1216  CG  GLU A 159     -54.816  17.596 -13.453  1.00 12.27           C  
ATOM   1217  CD  GLU A 159     -53.445  17.781 -14.082  1.00 13.22           C  
ATOM   1218  OE1 GLU A 159     -53.130  17.057 -15.057  1.00 14.87           O  
ATOM   1219  OE2 GLU A 159     -52.699  18.689 -13.618  1.00 14.90           O  
ATOM   1220  N   LEU A 160     -56.074  15.994 -10.275  1.00 11.02           N  
ATOM   1221  CA  LEU A 160     -56.350  16.613  -8.983  1.00 10.19           C  
ATOM   1222  C   LEU A 160     -55.425  16.087  -7.889  1.00 11.24           C  
ATOM   1223  O   LEU A 160     -54.936  16.870  -7.067  1.00 12.54           O  
ATOM   1224  CB  LEU A 160     -57.841  16.504  -8.578  1.00 10.33           C  
ATOM   1225  CG  LEU A 160     -58.802  17.300  -9.471  1.00 11.11           C  
ATOM   1226  CD1 LEU A 160     -60.238  16.996  -9.008  1.00 11.07           C  
ATOM   1227  CD2 LEU A 160     -58.513  18.782  -9.432  1.00 11.88           C  
ATOM   1228  N   ALA A 161     -55.201  14.782  -7.885  1.00 11.43           N  
ATOM   1229  CA  ALA A 161     -54.296  14.188  -6.877  1.00 12.43           C  
ATOM   1230  C   ALA A 161     -52.898  14.727  -7.072  1.00 11.62           C  
ATOM   1231  O   ALA A 161     -52.194  15.064  -6.085  1.00 13.16           O  
ATOM   1232  CB  ALA A 161     -54.297  12.704  -6.981  1.00 13.31           C  
ATOM   1233  N   PHE A 162     -52.446  14.789  -8.330  1.00 11.61           N  
ATOM   1234  CA  PHE A 162     -51.158  15.411  -8.596  1.00 11.48           C  
ATOM   1235  C   PHE A 162     -51.084  16.838  -8.078  1.00 11.60           C  
ATOM   1236  O   PHE A 162     -50.082  17.258  -7.437  1.00 12.62           O  
ATOM   1237  CB  PHE A 162     -50.813  15.396 -10.100  1.00 11.62           C  
ATOM   1238  CG  PHE A 162     -49.718  16.364 -10.417  1.00 10.96           C  
ATOM   1239  CD1 PHE A 162     -48.430  16.110  -9.961  1.00 12.80           C  
ATOM   1240  CD2 PHE A 162     -49.992  17.571 -11.054  1.00 11.83           C  
ATOM   1241  CE1 PHE A 162     -47.426  17.022 -10.162  1.00 13.40           C  
ATOM   1242  CE2 PHE A 162     -48.983  18.534 -11.228  1.00 14.10           C  
ATOM   1243  CZ  PHE A 162     -47.717  18.264 -10.764  1.00 13.23           C  
ATOM   1244  N   ARG A 163     -52.099  17.625  -8.424  1.00 10.73           N  
ATOM   1245  CA  ARG A 163     -52.034  19.038  -7.986  1.00 12.09           C  
ATOM   1246  C   ARG A 163     -52.014  19.155  -6.466  1.00 13.05           C  
ATOM   1247  O   ARG A 163     -51.327  20.022  -5.924  1.00 14.23           O  
ATOM   1248  CB  ARG A 163     -53.164  19.869  -8.573  1.00 11.94           C  
ATOM   1249  CG  ARG A 163     -53.069  19.957 -10.076  1.00 12.39           C  
ATOM   1250  CD  ARG A 163     -54.095  20.863 -10.688  1.00 13.89           C  
ATOM   1251  NE  ARG A 163     -53.959  20.771 -12.148  1.00 13.37           N  
ATOM   1252  CZ  ARG A 163     -54.524  21.605 -13.008  1.00 11.56           C  
ATOM   1253  NH1 ARG A 163     -55.257  22.607 -12.535  1.00 14.52           N  
ATOM   1254  NH2 ARG A 163     -54.336  21.463 -14.333  1.00 13.21           N  
ATOM   1255  N   PHE A 164     -52.731  18.258  -5.775  1.00 12.45           N  
ATOM   1256  CA  PHE A 164     -52.676  18.259  -4.297  1.00 14.12           C  
ATOM   1257  C   PHE A 164     -51.225  18.010  -3.837  1.00 14.27           C  
ATOM   1258  O   PHE A 164     -50.709  18.735  -2.937  1.00 14.45           O  
ATOM   1259  CB  PHE A 164     -53.629  17.211  -3.726  1.00 14.71           C  
ATOM   1260  CG  PHE A 164     -53.433  16.980  -2.280  1.00 17.85           C  
ATOM   1261  CD1 PHE A 164     -54.055  17.796  -1.362  1.00 22.00           C  
ATOM   1262  CD2 PHE A 164     -52.596  15.947  -1.842  1.00 20.12           C  
ATOM   1263  CE1 PHE A 164     -53.830  17.579   0.046  1.00 24.09           C  
ATOM   1264  CE2 PHE A 164     -52.377  15.735  -0.514  1.00 24.12           C  
ATOM   1265  CZ  PHE A 164     -52.979  16.536   0.429  1.00 21.79           C  
ATOM   1266  N   LEU A 165     -50.575  16.993  -4.414  1.00 13.60           N  
ATOM   1267  CA  LEU A 165     -49.194  16.704  -4.008  1.00 14.16           C  
ATOM   1268  C   LEU A 165     -48.262  17.857  -4.334  1.00 14.38           C  
ATOM   1269  O   LEU A 165     -47.380  18.230  -3.542  1.00 14.12           O  
ATOM   1270  CB  LEU A 165     -48.690  15.410  -4.665  1.00 13.95           C  
ATOM   1271  CG  LEU A 165     -49.411  14.154  -4.159  1.00 15.24           C  
ATOM   1272  CD1 LEU A 165     -49.048  12.984  -5.106  1.00 15.94           C  
ATOM   1273  CD2 LEU A 165     -49.068  13.775  -2.758  1.00 15.90           C  
ATOM   1274  N   ARG A 166     -48.455  18.436  -5.505  1.00 14.83           N  
ATOM   1275  CA  ARG A 166     -47.566  19.518  -5.947  1.00 14.59           C  
ATOM   1276  C   ARG A 166     -47.723  20.723  -5.017  1.00 15.96           C  
ATOM   1277  O   ARG A 166     -46.754  21.346  -4.527  1.00 16.19           O  
ATOM   1278  CB  ARG A 166     -47.929  19.926  -7.384  1.00 14.77           C  
ATOM   1279  CG  ARG A 166     -47.033  21.036  -7.898  1.00 14.73           C  
ATOM   1280  CD  ARG A 166     -47.653  21.792  -9.012  1.00 21.66           C  
ATOM   1281  NE  ARG A 166     -48.978  22.330  -8.665  1.00 21.31           N  
ATOM   1282  CZ  ARG A 166     -49.912  22.518  -9.565  1.00 21.46           C  
ATOM   1283  NH1 ARG A 166     -49.677  22.240 -10.846  1.00 24.61           N  
ATOM   1284  NH2 ARG A 166     -51.093  22.909  -9.183  1.00 19.22           N  
ATOM   1285  N   ASP A 167     -48.946  21.061  -4.734  1.00 15.49           N  
ATOM   1286  CA  ASP A 167     -49.206  22.251  -3.946  0.50 15.79           C  
ATOM   1288  C   ASP A 167     -48.971  22.138  -2.483  1.00 16.09           C  
ATOM   1289  O   ASP A 167     -48.897  23.150  -1.775  1.00 15.95           O  
ATOM   1290  CB  ASP A 167     -50.544  22.747  -4.308  0.50 16.38           C  
ATOM   1292  CG  ASP A 167     -50.552  23.184  -5.748  0.50 15.10           C  
ATOM   1294  OD1 ASP A 167     -49.474  23.581  -6.299  0.50 17.03           O  
ATOM   1296  OD2 ASP A 167     -51.561  23.077  -6.337  0.50 12.15           O  
ATOM   1298  N   THR A 168     -48.870  20.899  -2.031  1.00 15.03           N  
ATOM   1299  CA  THR A 168     -48.538  20.702  -0.620  1.00 14.93           C  
ATOM   1300  C   THR A 168     -47.100  20.235  -0.402  1.00 15.00           C  
ATOM   1301  O   THR A 168     -46.715  19.969   0.734  1.00 16.27           O  
ATOM   1302  CB  THR A 168     -49.521  19.728   0.046  1.00 15.41           C  
ATOM   1303  OG1 THR A 168     -49.401  18.448  -0.604  1.00 15.28           O  
ATOM   1304  CG2 THR A 168     -50.969  20.245  -0.070  1.00 17.81           C  
ATOM   1305  N   ALA A 169     -46.281  20.177  -1.456  1.00 15.71           N  
ATOM   1306  CA  ALA A 169     -44.906  19.626  -1.283  1.00 15.06           C  
ATOM   1307  C   ALA A 169     -44.038  20.421  -0.325  1.00 15.51           C  
ATOM   1308  O   ALA A 169     -43.283  19.842   0.476  1.00 16.54           O  
ATOM   1309  CB  ALA A 169     -44.174  19.479  -2.628  1.00 16.29           C  
ATOM   1310  N   TRP A 170     -44.188  21.746  -0.397  1.00 14.15           N  
ATOM   1311  CA  TRP A 170     -43.178  22.628   0.243  1.00 13.45           C  
ATOM   1312  C   TRP A 170     -43.775  23.477   1.342  1.00 13.73           C  
ATOM   1313  O   TRP A 170     -43.025  24.187   2.028  1.00 14.54           O  
ATOM   1314  CB  TRP A 170     -42.479  23.582  -0.756  1.00 14.49           C  
ATOM   1315  CG  TRP A 170     -41.969  22.847  -1.941  1.00 13.59           C  
ATOM   1316  CD1 TRP A 170     -42.408  22.974  -3.229  1.00 15.31           C  
ATOM   1317  CD2 TRP A 170     -40.939  21.844  -1.961  1.00 13.99           C  
ATOM   1318  NE1 TRP A 170     -41.723  22.098  -4.051  1.00 16.06           N  
ATOM   1319  CE2 TRP A 170     -40.825  21.388  -3.290  1.00 15.15           C  
ATOM   1320  CE3 TRP A 170     -40.124  21.270  -0.975  1.00 13.68           C  
ATOM   1321  CZ2 TRP A 170     -39.906  20.401  -3.666  1.00 15.75           C  
ATOM   1322  CZ3 TRP A 170     -39.223  20.281  -1.349  1.00 15.38           C  
ATOM   1323  CH2 TRP A 170     -39.123  19.869  -2.682  1.00 14.95           C  
ATOM   1324  N   VAL A 171     -45.092  23.391   1.539  1.00 14.62           N  
ATOM   1325  CA  VAL A 171     -45.783  24.322   2.450  1.00 15.60           C  
ATOM   1326  C   VAL A 171     -45.275  24.290   3.890  1.00 14.61           C  
ATOM   1327  O   VAL A 171     -45.338  25.318   4.597  1.00 14.99           O  
ATOM   1328  CB  VAL A 171     -47.327  24.137   2.425  1.00 16.71           C  
ATOM   1329  CG1 VAL A 171     -47.851  24.517   1.069  1.00 19.27           C  
ATOM   1330  CG2 VAL A 171     -47.715  22.715   2.780  1.00 18.24           C  
ATOM   1331  N   ALA A 172     -44.771  23.144   4.349  1.00 14.43           N  
ATOM   1332  CA  ALA A 172     -44.250  23.085   5.718  1.00 15.14           C  
ATOM   1333  C   ALA A 172     -43.052  23.994   5.928  1.00 14.33           C  
ATOM   1334  O   ALA A 172     -42.661  24.249   7.074  1.00 14.78           O  
ATOM   1335  CB  ALA A 172     -43.908  21.615   6.131  1.00 17.02           C  
ATOM   1336  N   VAL A 173     -42.430  24.466   4.840  1.00 13.97           N  
ATOM   1337  CA  VAL A 173     -41.269  25.333   5.001  1.00 14.19           C  
ATOM   1338  C   VAL A 173     -41.630  26.595   5.790  1.00 14.21           C  
ATOM   1339  O   VAL A 173     -40.751  27.210   6.407  1.00 15.92           O  
ATOM   1340  CB  VAL A 173     -40.632  25.688   3.632  1.00 14.25           C  
ATOM   1341  CG1 VAL A 173     -41.503  26.732   2.853  1.00 15.16           C  
ATOM   1342  CG2 VAL A 173     -39.187  26.148   3.841  1.00 14.26           C  
ATOM   1343  N   ARG A 174     -42.907  26.976   5.792  1.00 14.89           N  
ATOM   1344  CA  ARG A 174     -43.329  28.202   6.494  1.00 16.24           C  
ATOM   1345  C   ARG A 174     -43.184  28.088   8.019  1.00 16.66           C  
ATOM   1346  O   ARG A 174     -43.007  29.113   8.680  1.00 18.03           O  
ATOM   1347  CB  ARG A 174     -44.766  28.593   6.080  1.00 18.05           C  
ATOM   1348  CG  ARG A 174     -44.853  29.107   4.622  1.00 19.43           C  
ATOM   1349  CD  ARG A 174     -46.234  29.752   4.291  1.00 19.87           C  
ATOM   1350  NE  ARG A 174     -46.316  30.292   2.925  1.00 22.29           N  
ATOM   1351  CZ  ARG A 174     -47.345  31.007   2.452  1.00 23.74           C  
ATOM   1352  NH1 ARG A 174     -48.381  31.319   3.226  1.00 23.22           N  
ATOM   1353  NH2 ARG A 174     -47.331  31.455   1.203  1.00 25.02           N  
ATOM   1354  N   TRP A 175     -43.242  26.854   8.559  1.00 15.90           N  
ATOM   1355  CA  TRP A 175     -43.174  26.654  10.013  1.00 16.93           C  
ATOM   1356  C   TRP A 175     -42.063  25.691  10.478  1.00 16.59           C  
ATOM   1357  O   TRP A 175     -41.607  25.791  11.651  1.00 17.96           O  
ATOM   1358  CB  TRP A 175     -44.538  26.230  10.583  1.00 17.30           C  
ATOM   1359  CG  TRP A 175     -45.044  24.953  10.006  1.00 16.84           C  
ATOM   1360  CD1 TRP A 175     -45.974  24.806   8.992  1.00 15.95           C  
ATOM   1361  CD2 TRP A 175     -44.643  23.607  10.370  1.00 17.12           C  
ATOM   1362  NE1 TRP A 175     -46.167  23.473   8.726  1.00 17.52           N  
ATOM   1363  CE2 TRP A 175     -45.374  22.718   9.556  1.00 17.28           C  
ATOM   1364  CE3 TRP A 175     -43.754  23.077  11.329  1.00 18.46           C  
ATOM   1365  CZ2 TRP A 175     -45.224  21.315   9.641  1.00 17.78           C  
ATOM   1366  CZ3 TRP A 175     -43.610  21.684  11.422  1.00 17.87           C  
ATOM   1367  CH2 TRP A 175     -44.349  20.822  10.570  1.00 17.53           C  
ATOM   1368  N   TYR A 176     -41.581  24.812   9.586  1.00 15.78           N  
ATOM   1369  CA  TYR A 176     -40.642  23.770  10.011  1.00 17.54           C  
ATOM   1370  C   TYR A 176     -39.296  24.378  10.357  1.00 18.41           C  
ATOM   1371  O   TYR A 176     -38.767  25.219   9.620  1.00 19.21           O  
ATOM   1372  CB  TYR A 176     -40.502  22.666   8.926  1.00 17.86           C  
ATOM   1373  CG  TYR A 176     -39.477  21.616   9.319  1.00 18.91           C  
ATOM   1374  CD1 TYR A 176     -39.790  20.626  10.250  1.00 20.06           C  
ATOM   1375  CD2 TYR A 176     -38.181  21.659   8.818  1.00 18.80           C  
ATOM   1376  CE1 TYR A 176     -38.827  19.685  10.639  1.00 20.55           C  
ATOM   1377  CE2 TYR A 176     -37.231  20.742   9.206  1.00 19.84           C  
ATOM   1378  CZ  TYR A 176     -37.563  19.758  10.099  1.00 19.95           C  
ATOM   1379  OH  TYR A 176     -36.592  18.861  10.456  1.00 21.88           O  
ATOM   1380  N   ARG A 177     -38.722  23.953  11.475  1.00 18.50           N  
ATOM   1381  CA  ARG A 177     -37.413  24.440  11.856  1.00 19.61           C  
ATOM   1382  C   ARG A 177     -36.394  23.312  11.823  1.00 19.77           C  
ATOM   1383  O   ARG A 177     -36.485  22.376  12.626  1.00 19.44           O  
ATOM   1384  CB  ARG A 177     -37.431  25.036  13.257  1.00 20.14           C  
ATOM   1385  CG  ARG A 177     -36.111  25.699  13.593  1.00 21.38           C  
ATOM   1386  CD  ARG A 177     -36.108  26.263  14.994  1.00 23.85           C  
ATOM   1387  NE  ARG A 177     -35.884  25.277  16.067  1.00 23.81           N  
ATOM   1388  CZ  ARG A 177     -34.684  24.856  16.481  1.00 23.95           C  
ATOM   1389  NH1 ARG A 177     -33.560  25.274  15.878  1.00 22.76           N  
ATOM   1390  NH2 ARG A 177     -34.609  24.004  17.502  1.00 23.85           N  
ATOM   1391  N   PRO A 178     -35.405  23.416  10.927  1.00 20.66           N  
ATOM   1392  CA  PRO A 178     -34.283  22.475  10.927  1.00 21.64           C  
ATOM   1393  C   PRO A 178     -33.543  22.511  12.266  1.00 22.64           C  
ATOM   1394  O   PRO A 178     -33.290  23.592  12.796  1.00 23.39           O  
ATOM   1395  CB  PRO A 178     -33.404  23.001   9.790  1.00 21.88           C  
ATOM   1396  CG  PRO A 178     -34.387  23.709   8.880  1.00 21.89           C  
ATOM   1397  CD  PRO A 178     -35.281  24.413   9.842  1.00 20.50           C  
ATOM   1398  N   GLY A 179     -33.214  21.342  12.812  1.00 23.35           N  
ATOM   1399  CA  GLY A 179     -32.516  21.284  14.106  1.00 23.84           C  
ATOM   1400  C   GLY A 179     -33.450  21.208  15.299  1.00 23.93           C  
ATOM   1401  O   GLY A 179     -32.986  21.134  16.447  1.00 23.76           O  
ATOM   1402  N   GLY A 180     -34.762  21.234  15.049  1.00 23.52           N  
ATOM   1403  CA  GLY A 180     -35.740  21.110  16.128  1.00 23.57           C  
ATOM   1404  C   GLY A 180     -35.917  19.673  16.595  1.00 23.98           C  
ATOM   1405  O   GLY A 180     -35.449  18.749  15.942  1.00 23.51           O  
ATOM   1406  N   SER A 181     -36.609  19.471  17.715  1.00 24.34           N  
ATOM   1407  CA  SER A 181     -36.858  18.110  18.210  1.00 24.54           C  
ATOM   1408  C   SER A 181     -37.777  17.297  17.276  1.00 25.06           C  
ATOM   1409  O   SER A 181     -37.707  16.067  17.259  1.00 25.98           O  
ATOM   1410  CB  SER A 181     -37.428  18.144  19.633  1.00 25.21           C  
ATOM   1411  OG  SER A 181     -38.704  18.755  19.636  1.00 25.83           O  
ATOM   1412  N   VAL A 182     -38.628  17.984  16.517  1.00 24.24           N  
ATOM   1413  CA  VAL A 182     -39.501  17.349  15.514  1.00 24.70           C  
ATOM   1414  C   VAL A 182     -38.699  17.064  14.238  1.00 23.87           C  
ATOM   1415  O   VAL A 182     -38.295  18.004  13.523  1.00 24.58           O  
ATOM   1416  CB  VAL A 182     -40.739  18.239  15.225  1.00 25.19           C  
ATOM   1417  CG1 VAL A 182     -41.538  17.710  14.048  1.00 26.29           C  
ATOM   1418  CG2 VAL A 182     -41.629  18.353  16.475  1.00 25.72           C  
ATOM   1419  N   THR A 183     -38.439  15.784  13.955  1.00 22.16           N  
ATOM   1420  CA  THR A 183     -37.574  15.435  12.823  1.00 21.77           C  
ATOM   1421  C   THR A 183     -38.389  15.540  11.560  1.00 21.83           C  
ATOM   1422  O   THR A 183     -39.595  15.297  11.545  1.00 21.58           O  
ATOM   1423  CB  THR A 183     -36.980  14.027  12.935  1.00 21.71           C  
ATOM   1424  OG1 THR A 183     -38.037  13.063  12.954  1.00 21.46           O  
ATOM   1425  CG2 THR A 183     -36.154  13.890  14.223  1.00 22.81           C  
ATOM   1426  N   VAL A 184     -37.726  15.905  10.481  1.00 22.56           N  
ATOM   1427  CA  VAL A 184     -38.458  16.110   9.258  1.00 22.68           C  
ATOM   1428  C   VAL A 184     -39.012  14.748   8.839  1.00 23.30           C  
ATOM   1429  O   VAL A 184     -40.085  14.682   8.237  1.00 23.36           O  
ATOM   1430  CB  VAL A 184     -37.619  16.865   8.203  1.00 22.64           C  
ATOM   1431  CG1 VAL A 184     -36.670  15.907   7.437  1.00 23.01           C  
ATOM   1432  CG2 VAL A 184     -38.541  17.701   7.305  1.00 24.16           C  
ATOM   1433  N   ASP A 185     -38.327  13.673   9.224  1.00 22.91           N  
ATOM   1434  CA  ASP A 185     -38.808  12.284   9.065  1.00 24.17           C  
ATOM   1435  C   ASP A 185     -40.176  11.942   9.723  1.00 22.00           C  
ATOM   1436  O   ASP A 185     -41.071  11.352   9.092  1.00 21.97           O  
ATOM   1437  CB  ASP A 185     -37.774  11.321   9.598  1.00 26.07           C  
ATOM   1438  CG  ASP A 185     -38.216   9.863   9.477  1.00 30.60           C  
ATOM   1439  OD1 ASP A 185     -38.361   9.402   8.318  1.00 35.24           O  
ATOM   1440  OD2 ASP A 185     -38.418   9.189  10.517  1.00 33.95           O  
ATOM   1441  N   THR A 186     -40.321  12.261  11.001  1.00 19.58           N  
ATOM   1442  CA  THR A 186     -41.629  12.246  11.652  1.00 17.56           C  
ATOM   1443  C   THR A 186     -42.699  12.995  10.829  1.00 16.59           C  
ATOM   1444  O   THR A 186     -43.830  12.504  10.651  1.00 16.49           O  
ATOM   1445  CB  THR A 186     -41.522  12.847  13.068  1.00 18.03           C  
ATOM   1446  OG1 THR A 186     -40.692  11.987  13.859  1.00 19.95           O  
ATOM   1447  CG2 THR A 186     -42.899  12.961  13.719  1.00 18.15           C  
ATOM   1448  N   VAL A 187     -42.362  14.196  10.378  1.00 15.52           N  
ATOM   1449  CA  VAL A 187     -43.303  14.999   9.610  1.00 15.13           C  
ATOM   1450  C   VAL A 187     -43.660  14.287   8.284  1.00 14.04           C  
ATOM   1451  O   VAL A 187     -44.838  14.190   7.923  1.00 14.12           O  
ATOM   1452  CB  VAL A 187     -42.787  16.448   9.357  1.00 14.52           C  
ATOM   1453  CG1 VAL A 187     -43.852  17.242   8.665  1.00 16.80           C  
ATOM   1454  CG2 VAL A 187     -42.451  17.171  10.668  1.00 18.51           C  
ATOM   1455  N   ALA A 188     -42.650  13.795   7.560  1.00 14.44           N  
ATOM   1456  CA  ALA A 188     -42.905  13.050   6.303  1.00 14.12           C  
ATOM   1457  C   ALA A 188     -43.787  11.837   6.540  1.00 13.87           C  
ATOM   1458  O   ALA A 188     -44.738  11.605   5.787  1.00 14.03           O  
ATOM   1459  CB  ALA A 188     -41.614  12.641   5.625  1.00 16.02           C  
ATOM   1460  N   LYS A 189     -43.484  11.067   7.567  1.00 14.77           N  
ATOM   1461  CA  LYS A 189     -44.217   9.832   7.792  1.00 14.82           C  
ATOM   1462  C   LYS A 189     -45.666  10.129   8.096  1.00 14.81           C  
ATOM   1463  O   LYS A 189     -46.558   9.421   7.602  1.00 14.93           O  
ATOM   1464  CB  LYS A 189     -43.564   8.976   8.880  1.00 16.85           C  
ATOM   1465  CG  LYS A 189     -42.263   8.373   8.384  1.00 20.99           C  
ATOM   1466  CD  LYS A 189     -41.719   7.378   9.384  1.00 26.75           C  
ATOM   1467  CE  LYS A 189     -40.385   6.800   8.929  1.00 30.49           C  
ATOM   1468  NZ  LYS A 189     -40.568   5.908   7.751  1.00 33.82           N  
ATOM   1469  N   GLN A 190     -45.920  11.192   8.857  1.00 13.70           N  
ATOM   1470  CA  GLN A 190     -47.313  11.512   9.166  1.00 15.08           C  
ATOM   1471  C   GLN A 190     -48.068  12.050   7.962  1.00 14.62           C  
ATOM   1472  O   GLN A 190     -49.248  11.728   7.750  1.00 15.85           O  
ATOM   1473  CB  GLN A 190     -47.469  12.452  10.342  1.00 15.80           C  
ATOM   1474  CG  GLN A 190     -48.931  12.648  10.546  1.00 19.79           C  
ATOM   1475  CD  GLN A 190     -49.317  12.893  11.940  1.00 22.96           C  
ATOM   1476  OE1 GLN A 190     -49.008  12.084  12.853  1.00 24.14           O  
ATOM   1477  NE2 GLN A 190     -50.024  14.015  12.147  1.00 20.84           N  
ATOM   1478  N   TYR A 191     -47.412  12.919   7.196  1.00 13.19           N  
ATOM   1479  CA  TYR A 191     -48.056  13.438   5.989  1.00 12.80           C  
ATOM   1480  C   TYR A 191     -48.451  12.246   5.087  1.00 12.75           C  
ATOM   1481  O   TYR A 191     -49.585  12.167   4.546  1.00 13.79           O  
ATOM   1482  CB  TYR A 191     -47.083  14.362   5.255  1.00 13.78           C  
ATOM   1483  CG  TYR A 191     -47.516  14.802   3.862  1.00 12.66           C  
ATOM   1484  CD1 TYR A 191     -48.186  16.019   3.682  1.00 13.72           C  
ATOM   1485  CD2 TYR A 191     -47.224  14.022   2.738  1.00 13.16           C  
ATOM   1486  CE1 TYR A 191     -48.547  16.450   2.397  1.00 13.67           C  
ATOM   1487  CE2 TYR A 191     -47.592  14.414   1.476  1.00 13.82           C  
ATOM   1488  CZ  TYR A 191     -48.235  15.633   1.296  1.00 14.71           C  
ATOM   1489  OH  TYR A 191     -48.578  16.011   0.014  1.00 15.74           O  
ATOM   1490  N   LEU A 192     -47.502  11.309   4.925  1.00 13.55           N  
ATOM   1491  CA  LEU A 192     -47.758  10.171   4.075  1.00 13.28           C  
ATOM   1492  C   LEU A 192     -48.863   9.278   4.622  1.00 13.99           C  
ATOM   1493  O   LEU A 192     -49.683   8.758   3.863  1.00 13.51           O  
ATOM   1494  CB  LEU A 192     -46.465   9.360   3.876  1.00 13.20           C  
ATOM   1495  CG  LEU A 192     -45.498   9.995   2.867  1.00 13.75           C  
ATOM   1496  CD1 LEU A 192     -44.084   9.365   3.031  1.00 14.81           C  
ATOM   1497  CD2 LEU A 192     -46.066   9.860   1.437  1.00 14.01           C  
ATOM   1498  N   SER A 193     -48.899   9.107   5.937  1.00 13.68           N  
ATOM   1499  CA  SER A 193     -49.940   8.261   6.520  1.00 14.45           C  
ATOM   1500  C   SER A 193     -51.328   8.862   6.265  1.00 14.89           C  
ATOM   1501  O   SER A 193     -52.297   8.141   5.944  1.00 15.84           O  
ATOM   1502  CB  SER A 193     -49.689   8.119   8.014  1.00 15.74           C  
ATOM   1503  OG  SER A 193     -50.636   7.241   8.574  1.00 17.72           O  
ATOM   1504  N   ILE A 194     -51.418  10.181   6.399  1.00 14.40           N  
ATOM   1505  CA  ILE A 194     -52.705  10.870   6.119  1.00 14.21           C  
ATOM   1506  C   ILE A 194     -53.099  10.764   4.645  1.00 13.47           C  
ATOM   1507  O   ILE A 194     -54.201  10.299   4.308  1.00 14.45           O  
ATOM   1508  CB  ILE A 194     -52.672  12.328   6.556  1.00 15.11           C  
ATOM   1509  CG1 ILE A 194     -52.660  12.360   8.090  1.00 17.71           C  
ATOM   1510  CG2 ILE A 194     -53.862  13.105   5.973  1.00 17.03           C  
ATOM   1511  CD1 ILE A 194     -52.371  13.749   8.663  1.00 20.32           C  
ATOM   1512  N   VAL A 195     -52.177  11.160   3.775  1.00 13.82           N  
ATOM   1513  CA  VAL A 195     -52.481  11.190   2.347  1.00 13.62           C  
ATOM   1514  C   VAL A 195     -52.721   9.803   1.751  1.00 13.84           C  
ATOM   1515  O   VAL A 195     -53.571   9.669   0.857  1.00 13.83           O  
ATOM   1516  CB  VAL A 195     -51.384  11.952   1.583  1.00 14.25           C  
ATOM   1517  CG1 VAL A 195     -51.512  11.746   0.080  1.00 17.37           C  
ATOM   1518  CG2 VAL A 195     -51.438  13.438   2.015  1.00 16.07           C  
ATOM   1519  N   LEU A 196     -51.969   8.790   2.202  1.00 13.20           N  
ATOM   1520  CA  LEU A 196     -52.191   7.445   1.665  1.00 12.78           C  
ATOM   1521  C   LEU A 196     -53.282   6.647   2.367  1.00 13.13           C  
ATOM   1522  O   LEU A 196     -54.050   5.953   1.699  1.00 12.76           O  
ATOM   1523  CB  LEU A 196     -50.894   6.655   1.651  1.00 13.27           C  
ATOM   1524  CG  LEU A 196     -49.914   7.116   0.569  1.00 16.44           C  
ATOM   1525  CD1 LEU A 196     -48.494   6.746   0.925  1.00 16.31           C  
ATOM   1526  CD2 LEU A 196     -50.313   6.414  -0.722  1.00 17.28           C  
ATOM   1527  N   ASP A 197     -53.362   6.757   3.694  1.00 12.97           N  
ATOM   1528  CA  ASP A 197     -54.284   5.903   4.467  1.00 12.52           C  
ATOM   1529  C   ASP A 197     -55.452   6.647   5.127  1.00 11.95           C  
ATOM   1530  O   ASP A 197     -56.391   6.005   5.618  1.00 13.29           O  
ATOM   1531  CB  ASP A 197     -53.492   5.109   5.505  1.00 13.69           C  
ATOM   1532  CG  ASP A 197     -52.457   4.205   4.867  1.00 14.89           C  
ATOM   1533  OD1 ASP A 197     -52.753   3.637   3.782  1.00 15.31           O  
ATOM   1534  OD2 ASP A 197     -51.349   4.068   5.453  1.00 17.40           O  
ATOM   1535  N   GLY A 198     -55.407   7.985   5.119  1.00 11.57           N  
ATOM   1536  CA  GLY A 198     -56.535   8.808   5.583  1.00 12.39           C  
ATOM   1537  C   GLY A 198     -56.468   9.120   7.067  1.00 12.66           C  
ATOM   1538  O   GLY A 198     -55.956   8.322   7.894  1.00 13.06           O  
ATOM   1539  N   LEU A 199     -57.022  10.274   7.412  1.00 12.50           N  
ATOM   1540  CA  LEU A 199     -57.149  10.722   8.787  1.00 13.43           C  
ATOM   1541  C   LEU A 199     -58.277   9.999   9.532  1.00 13.37           C  
ATOM   1542  O   LEU A 199     -58.210   9.838  10.758  1.00 13.60           O  
ATOM   1543  CB  LEU A 199     -57.446  12.225   8.762  1.00 14.30           C  
ATOM   1544  CG  LEU A 199     -57.712  12.918  10.089  1.00 16.36           C  
ATOM   1545  CD1 LEU A 199     -56.471  12.824  10.980  1.00 20.50           C  
ATOM   1546  CD2 LEU A 199     -58.151  14.365   9.812  1.00 17.58           C  
ATOM   1547  N   ALA A 200     -59.308   9.569   8.804  1.00 12.57           N  
ATOM   1548  CA  ALA A 200     -60.449   8.889   9.471  1.00 14.16           C  
ATOM   1549  C   ALA A 200     -60.041   7.532  10.033  1.00 15.63           C  
ATOM   1550  O   ALA A 200     -59.194   6.837   9.466  1.00 14.82           O  
ATOM   1551  CB  ALA A 200     -61.638   8.712   8.505  1.00 15.71           C  
ATOM   1552  N   SER A 201     -60.665   7.147  11.144  1.00 16.34           N  
ATOM   1553  CA  SER A 201     -60.490   5.788  11.662  1.00 18.09           C  
ATOM   1554  C   SER A 201     -60.983   4.764  10.633  1.00 20.11           C  
ATOM   1555  O   SER A 201     -62.037   4.960  10.033  1.00 19.84           O  
ATOM   1556  CB  SER A 201     -61.267   5.646  12.961  1.00 17.90           C  
ATOM   1557  OG  SER A 201     -60.719   6.538  13.912  1.00 17.69           O  
ATOM   1558  N   PRO A 202     -60.210   3.680  10.412  1.00 22.62           N  
ATOM   1559  CA  PRO A 202     -60.603   2.607   9.480  1.00 24.37           C  
ATOM   1560  C   PRO A 202     -61.710   1.705  10.056  1.00 25.08           C  
ATOM   1561  O   PRO A 202     -61.959   1.750  11.258  1.00 26.00           O  
ATOM   1562  CB  PRO A 202     -59.301   1.810   9.315  1.00 24.87           C  
ATOM   1563  CG  PRO A 202     -58.618   1.956  10.667  1.00 24.90           C  
ATOM   1564  CD  PRO A 202     -58.891   3.426  11.027  1.00 23.86           C  
TER    1565      PRO A 202                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
