
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  179 ( 1391),  selected  179 , name 2pz9_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 2pz9_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    30_A      D       5          3.406
LGA    T    31_A      C       6          3.489
LGA    R    32_A      R       7          3.051
LGA    Q    33_A      S       8          3.224
LGA    R    34_A      R       9          2.741
LGA    I    35_A      L      10          1.778
LGA    V    36_A      M      11          1.960
LGA    A    37_A      E      12          2.340
LGA    A    38_A      V      13          1.753
LGA    A    39_A      A      14          0.886
LGA    K    40_A      T      15          0.979
LGA    E    41_A      E      16          1.099
LGA    E    42_A      L      17          0.927
LGA    F    43_A      F      18          0.850
LGA    A    44_A      A      19          0.803
LGA    R    45_A      Q      20          0.673
LGA    H    46_A      K      21          0.892
LGA    G    47_A      G      22          0.802
LGA    I    48_A      F      23          1.341
LGA    A    49_A      Y      24          1.942
LGA    G    50_A      G      25          1.481
LGA    A    51_A      V      26          1.712
LGA    R    52_A      S      27          3.253
LGA    V    53_A      I      28          2.635
LGA    D    54_A      R      29          3.027
LGA    R    55_A      E      30          3.354
LGA    I    56_A      L      31          2.426
LGA    A    57_A      A      32          2.710
LGA    K    58_A      Q      33          3.397
LGA    Q    59_A      A      34          3.528
LGA    A    60_A      A      35          3.303
LGA    R    61_A      G      36          4.113
LGA    T    62_A      A      37          2.254
LGA    S    63_A      S      38          2.055
LGA    K    64_A      I      39          1.778
LGA    E    65_A      S      40          1.202
LGA    R    66_A      M      41          0.959
LGA    V    67_A      I      42          1.303
LGA    Y    68_A      S      43          1.161
LGA    A    69_A      Y      44          1.770
LGA    Y    70_A      H      45          3.570
LGA    F    71_A      F      46          4.447
LGA    R    72_A      G      47          4.283
LGA    S    73_A      G      48          4.037
LGA    K    74_A      K      49          2.325
LGA    E    75_A      E      50          3.342
LGA    A    76_A      G      51          3.862
LGA    L    77_A      L      52          2.752
LGA    Y    78_A      Y      53          1.856
LGA    A    79_A      A      54          2.686
LGA    H    80_A      A      55          2.912
LGA    V    81_A      V      56          1.809
LGA    A    82_A      L      57          1.321
LGA    E    83_A      Q      58          2.329
LGA    R    84_A      E      59          2.721
LGA    E    85_A      Q      60          1.703
LGA    T    86_A      F      61          1.262
LGA    T    87_A      A      62          1.767
LGA    A    88_A      C      63          3.151
LGA    L    89_A      F      64          3.783
LGA    I    90_A      G      65          3.342
LGA    E    91_A      Q      66          2.287
LGA    A    92_A      -       -           -
LGA    T    93_A      L      67          4.217
LGA    Q    94_A      D      68          3.461
LGA    -       -      D      69           -
LGA    L    95_A      I      70          2.164
LGA    -       -      R      71           -
LGA    -       -      G      72           -
LGA    D    96_A      Q      73          3.910
LGA    -       -      A      74           -
LGA    -       -      G      75           -
LGA    P    97_A      D      76           #
LGA    A    98_A      P      77          3.883
LGA    -       -      L      78           -
LGA    D    99_A      A      79          1.722
LGA    -       -      V      80           -
LGA    L   100_A      M      81          1.054
LGA    P   101_A      T      82          2.119
LGA    G   102_A      A      83          3.019
LGA    Y   103_A      Y      84          1.746
LGA    A   104_A      L      85          0.631
LGA    G   105_A      R      86          1.998
LGA    I   106_A      W      87          1.529
LGA    L   107_A      T      88          0.541
LGA    F   108_A      I      89          1.246
LGA    D   109_A      Q      90          1.943
LGA    H   110_A      R      91          1.171
LGA    F   111_A      H      92          0.991
LGA    A   112_A      R      93          2.330
LGA    A   113_A      N      94          2.450
LGA    R   114_A      N      95          1.211
LGA    P   115_A      P      96          1.594
LGA    D   116_A      Q      97          1.010
LGA    H   117_A      L      98          1.532
LGA    Y   118_A      L      99          1.202
LGA    R   119_A      R     100          0.415
LGA    L   120_A      F     101          1.617
LGA    I   121_A      Y     102          2.247
LGA    T   122_A      T     103          1.665
LGA    W   123_A      S     104          1.747
LGA    G   124_A      E     105          1.937
LGA    R   125_A      L     106          2.115
LGA    L   126_A      T     107          2.282
LGA    E   127_A      N     108          2.177
LGA    L   128_A      P     109          2.025
LGA    A   129_A      T     110           #
LGA    -       -      P     111           -
LGA    -       -      C     112           -
LGA    -       -      F     113           -
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      I     116           -
LGA    -       -      V     117           -
LGA    -       -      S     118           -
LGA    P   138_A      P     119          4.196
LGA    L   139_A      A     120          2.782
LGA    Q   140_A      I     121           #
LGA    A   141_A      A     122           #
LGA    T   142_A      S     123          2.797
LGA    I   143_A      V     124          4.250
LGA    A   144_A      I     125           #
LGA    G   145_A      R     126           #
LGA    K   146_A      L     127          1.774
LGA    L   147_A      L     128          5.366
LGA    D   148_A      A     129           #
LGA    K   149_A      -       -           -
LGA    L   150_A      E     130          2.245
LGA    R   151_A      -       -           -
LGA    D   152_A      -       -           -
LGA    A   153_A      S     131          3.717
LGA    -       -      I     132           -
LGA    Q   154_A      E     133          4.394
LGA    R   155_A      A     134          3.513
LGA    I   156_A      -       -           -
LGA    G   157_A      -       -           -
LGA    L   158_A      -       -           -
LGA    L   159_A      G     135          2.776
LGA    D   160_A      M     136          3.670
LGA    P   161_A      T     137          3.848
LGA    -       -      R     138           -
LGA    -       -      G     139           -
LGA    -       -      L     140           -
LGA    -       -      F     141           -
LGA    -       -      R     142           -
LGA    A   162_A      R     143          2.642
LGA    -       -      D     144           -
LGA    W   163_A      L     145          4.513
LGA    D   164_A      H     146          3.226
LGA    P   165_A      A     147          3.129
LGA    V   166_A      V     148          1.248
LGA    D   167_A      N     149          2.269
LGA    V   168_A      S     150          3.491
LGA    L   169_A      A     151          2.808
LGA    A   170_A      L     152          1.788
LGA    L   171_A      A     153          2.196
LGA    I   172_A      L     154          2.395
LGA    N   173_A      A     155          2.033
LGA    Q   174_A      G     156          1.652
LGA    I   175_A      M     157          1.623
LGA    A   176_A      V     158          1.799
LGA    X   177_A      N     159          1.533
LGA    T   178_A      Y     160          2.290
LGA    W   179_A      F     161          3.098
LGA    A   180_A      F     162          2.847
LGA    G   181_A      L     163          1.858
LGA    Q   182_A      S     164          1.208
LGA    P   183_A      T     165          3.633
LGA    E   184_A      L     166          4.792
LGA    I   185_A      A     167          3.366
LGA    A   186_A      T     168          2.505
LGA    A   187_A      -       -           -
LGA    A   188_A      -       -           -
LGA    A   189_A      -       -           -
LGA    A   190_A      E     169          3.327
LGA    D   191_A      G     170          3.958
LGA    Q   192_A      L     171          4.004
LGA    A   193_A      T     172          3.756
LGA    V   194_A      -       -           -
LGA    D   195_A      -       -           -
LGA    P   196_A      S     173          3.694
LGA    S   197_A      H     174           #
LGA    V   198_A      S     175          1.119
LGA    T   199_A      P     176          3.002
LGA    A   200_A      D     177          5.211
LGA    R   201_A      Q     178          4.650
LGA    R   202_A      D     179          1.942
LGA    A   203_A      E     180          3.439
LGA    A   204_A      E     181          4.398
LGA    L   205_A      L     182          2.954
LGA    V   206_A      I     183          0.825
LGA    T   207_A      R     184          1.888
LGA    A   208_A      Q     185          3.078
LGA    V   209_A      Y     186          3.051
LGA    E   210_A      V     187          1.691
LGA    H   211_A      A     188          1.597
LGA    -       -      I     189           -
LGA    X   212_A      F     190          1.596
LGA    F   213_A      T     191          3.171
LGA    P   214_A      R     192           #
LGA    R   215_A      G     193           -
LGA    P   216_A      I     194           -
LGA    -       -      M     195           -
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  179  192    5.0    156    2.69    16.67     50.292     5.601

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.379421 * X  +  -0.187982 * Y  +  -0.905926 * Z  + -42.888962
  Y_new =   0.922815 * X  +   0.006275 * Y  +   0.385192 * Z  +  -6.087199
  Z_new =  -0.066725 * X  +  -0.982152 * Y  +   0.175854 * Z  +  -1.120299 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.393625    1.747968  [ DEG:   -79.8488    100.1512 ]
  Theta =   0.066775    3.074818  [ DEG:     3.8259    176.1741 ]
  Phi   =   1.180710   -1.960883  [ DEG:    67.6497   -112.3503 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pz9_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pz9_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  179  192   5.0  156   2.69   16.67  50.292
REMARK  ---------------------------------------------------------- 
MOLECULE 2pz9_A
HEADER    TRANSCRIPTION                           17-MAY-07   2PZ9              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSCRIPTIONAL REGULATOR               
TITLE    2 SCO4942 FROM STREPTOMYCES COELICOLOR                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE REGULATORY PROTEIN;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES COELICOLOR A3(2);                  
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: A3(2), M145;                                                 
SOURCE   5 ATCC: BAA-471;                                                       
SOURCE   6 GENE: SCO4942, 2SCK31.02C;                                           
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) GOLD MAGIC;                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: P15TV LIC                                 
KEYWDS    STRUCTURAL GENOMICS, TRANSCRIPTIONAL REGULATOR,                       
KEYWDS   2 STREPTOMYCES COELICOLOR A3(2), PSI, PROTEIN STRUCTURE                
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.FILIPPOVA,M.CHRUSZCZ,X.XU,H.ZHENG,M.CYMBOROWSKI,                    
AUTHOR   2 A.SAVCHENKO,A.EDWARDS,W.MINOR,MIDWEST CENTER FOR STRUCTURAL          
AUTHOR   3 GENOMICS (MCSG)                                                      
REVDAT   2   20-NOV-07 2PZ9    1       JRNL                                     
REVDAT   1   19-JUN-07 2PZ9    0                                                
JRNL        AUTH   A.DONG,X.XU,A.M.EDWARDS,C.CHANG,M.CHRUSZCZ,M.CUFF,           
JRNL        AUTH 2 M.CYMBOROWSKI,R.D.LEO,O.EGOROVA,E.EVDOKIMOVA,                
JRNL        AUTH 3 E.FILIPPOVA,J.GU,J.GUTHRIE,A.IGNATCHENKO,                    
JRNL        AUTH 4 A.JOACHIMIAK,N.KLOSTERMANN,Y.KIM,Y.KORNIYENKO,               
JRNL        AUTH 5 W.MINOR,Q.QUE,A.SAVCHENKO,T.SKARINA,K.TAN,                   
JRNL        AUTH 6 A.YAKUNIN,A.YEE,V.YIM,R.ZHANG,H.ZHENG,M.AKUTSU,              
JRNL        AUTH 7 C.ARROWSMITH,G.V.AVVAKUMOV,A.BOCHKAREV,                      
JRNL        AUTH 8 L.G.DAHLGREN,S.DHE-PAGANON,S.DIMOV,L.DOMBROVSKI,             
JRNL        AUTH 9 P.FINERTY,S.FLODIN,A.FLORES,S.GRASLUND,                      
JRNL        AUTH10 M.HAMMERSTROM,M.D.HERMAN,B.S.HONG,R.HUI,                     
JRNL        AUTH11 I.JOHANSSON,Y.LIU,M.NILSSON,L.NEDYALKOVA,                    
JRNL        AUTH12 P.NORDLUND,T.NYMAN,J.MIN,H.OUYANG,H.W.PARK,C.QI,             
JRNL        AUTH13 W.RABEH,L.SHEN,Y.SHEN,D.SUKUMARD,W.TEMPEL,Y.TONG,            
JRNL        AUTH14 L.TRESAGUES,M.VEDADI,J.R.WALKER,J.WEIGELT,M.WELIN,           
JRNL        AUTH15 H.WU,T.XIAO,H.ZENG,H.ZHU                                     
JRNL        TITL   IN SITU PROTEOLYSIS FOR PROTEIN CRYSTALLIZATION              
JRNL        TITL 2 AND STRUCTURE DETERMINATION.                                 
JRNL        REF    NAT.METHODS                                2007              
JRNL        REFN                US ESSN 1548-7105                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  2PZ9 A    1   226  UNP    Q9EWE9   Q9EWE9_STRCO     1    226             
SEQRES   1 A  226  MSE VAL ALA TYR PRO GLY PRO MSE PRO ARG SER PRO SER          
SEQRES   2 A  226  PRO GLY GLN THR PRO ASP ALA PRO THR SER GLY GLY GLY          
SEQRES   3 A  226  SER THR ASP SER THR ARG GLN ARG ILE VAL ALA ALA ALA          
SEQRES   4 A  226  LYS GLU GLU PHE ALA ARG HIS GLY ILE ALA GLY ALA ARG          
SEQRES   5 A  226  VAL ASP ARG ILE ALA LYS GLN ALA ARG THR SER LYS GLU          
SEQRES   6 A  226  ARG VAL TYR ALA TYR PHE ARG SER LYS GLU ALA LEU TYR          
SEQRES   7 A  226  ALA HIS VAL ALA GLU ARG GLU THR THR ALA LEU ILE GLU          
SEQRES   8 A  226  ALA THR GLN LEU ASP PRO ALA ASP LEU PRO GLY TYR ALA          
SEQRES   9 A  226  GLY ILE LEU PHE ASP HIS PHE ALA ALA ARG PRO ASP HIS          
SEQRES  10 A  226  TYR ARG LEU ILE THR TRP GLY ARG LEU GLU LEU ALA GLU          
SEQRES  11 A  226  SER ALA ASP ASN THR SER GLY PRO LEU GLN ALA THR ILE          
SEQRES  12 A  226  ALA GLY LYS LEU ASP LYS LEU ARG ASP ALA GLN ARG ILE          
SEQRES  13 A  226  GLY LEU LEU ASP PRO ALA TRP ASP PRO VAL ASP VAL LEU          
SEQRES  14 A  226  ALA LEU ILE ASN GLN ILE ALA MSE THR TRP ALA GLY GLN          
SEQRES  15 A  226  PRO GLU ILE ALA ALA ALA ALA ALA ASP GLN ALA VAL ASP          
SEQRES  16 A  226  PRO SER VAL THR ALA ARG ARG ALA ALA LEU VAL THR ALA          
SEQRES  17 A  226  VAL GLU HIS MSE PHE PRO ARG PRO ASP ARG ASP GLN ARG          
SEQRES  18 A  226  PRO ASN ARG LEU THR                                          
HET    MSE  A 177       8                                                       
HET    MSE  A 212       8                                                       
HET    SO4  A 227       5                                                       
HET    SO4  A 228       5                                                       
HET    SO4  A 229       5                                                       
HET    SO4  A 230       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   2  SO4    4(O4 S 2-)                                                   
FORMUL   6  HOH   *10(H2 O)                                                     
CRYST1   66.960   66.960  104.345  90.00  90.00 120.00 P 32 2 1      6          
ATOM      1  N   SER A  30     -14.203  29.504   0.094  1.00 63.18           N  
ATOM      2  CA  SER A  30     -14.090  30.305  -1.179  1.00 64.11           C  
ATOM      3  C   SER A  30     -14.850  31.637  -1.096  1.00 64.58           C  
ATOM      4  O   SER A  30     -15.290  32.016  -0.013  1.00 65.57           O  
ATOM      5  CB  SER A  30     -14.518  29.478  -2.403  1.00 63.72           C  
ATOM      6  OG  SER A  30     -15.589  30.074  -3.109  1.00 63.05           O  
ATOM      7  N   THR A  31     -14.991  32.347  -2.216  1.00 64.37           N  
ATOM      8  CA  THR A  31     -15.647  33.661  -2.206  1.00 64.29           C  
ATOM      9  C   THR A  31     -16.995  33.682  -2.949  1.00 63.93           C  
ATOM     10  O   THR A  31     -17.964  34.294  -2.494  1.00 63.69           O  
ATOM     11  CB  THR A  31     -14.719  34.750  -2.765  1.00 64.68           C  
ATOM     12  OG1 THR A  31     -13.443  34.674  -2.106  1.00 65.22           O  
ATOM     13  CG2 THR A  31     -15.315  36.145  -2.550  1.00 64.78           C  
ATOM     14  N   ARG A  32     -17.055  33.022  -4.098  1.00 63.34           N  
ATOM     15  CA  ARG A  32     -18.335  32.770  -4.714  1.00 62.49           C  
ATOM     16  C   ARG A  32     -19.210  32.079  -3.669  1.00 62.07           C  
ATOM     17  O   ARG A  32     -20.336  32.508  -3.436  1.00 62.20           O  
ATOM     18  CB  ARG A  32     -18.185  31.925  -5.982  1.00 62.38           C  
ATOM     19  CG  ARG A  32     -19.417  31.923  -6.881  1.00 62.83           C  
ATOM     20  CD  ARG A  32     -19.327  30.852  -7.957  1.00 64.63           C  
ATOM     21  NE  ARG A  32     -18.910  29.597  -7.358  1.00 66.64           N  
ATOM     22  CZ  ARG A  32     -19.703  28.813  -6.636  1.00 67.93           C  
ATOM     23  NH1 ARG A  32     -20.985  29.127  -6.441  1.00 68.33           N  
ATOM     24  NH2 ARG A  32     -19.209  27.710  -6.107  1.00 68.27           N  
ATOM     25  N   GLN A  33     -18.689  31.044  -3.005  1.00 61.64           N  
ATOM     26  CA  GLN A  33     -19.511  30.271  -2.059  1.00 60.91           C  
ATOM     27  C   GLN A  33     -20.029  31.142  -0.948  1.00 60.39           C  
ATOM     28  O   GLN A  33     -21.214  31.099  -0.620  1.00 60.42           O  
ATOM     29  CB  GLN A  33     -18.734  29.141  -1.448  1.00 60.68           C  
ATOM     30  CG  GLN A  33     -18.096  28.260  -2.443  1.00 62.23           C  
ATOM     31  CD  GLN A  33     -17.191  27.257  -1.771  1.00 65.04           C  
ATOM     32  OE1 GLN A  33     -16.477  27.578  -0.802  1.00 66.35           O  
ATOM     33  NE2 GLN A  33     -17.211  26.029  -2.272  1.00 65.25           N  
ATOM     34  N   ARG A  34     -19.129  31.940  -0.382  1.00 60.09           N  
ATOM     35  CA  ARG A  34     -19.473  32.845   0.700  1.00 59.67           C  
ATOM     36  C   ARG A  34     -20.557  33.842   0.317  1.00 60.12           C  
ATOM     37  O   ARG A  34     -21.459  34.079   1.113  1.00 60.76           O  
ATOM     38  CB  ARG A  34     -18.236  33.559   1.228  1.00 59.20           C  
ATOM     39  CG  ARG A  34     -17.677  32.899   2.456  1.00 57.80           C  
ATOM     40  CD  ARG A  34     -16.686  33.764   3.188  1.00 55.04           C  
ATOM     41  NE  ARG A  34     -15.378  33.774   2.543  1.00 52.96           N  
ATOM     42  CZ  ARG A  34     -14.932  34.758   1.767  1.00 52.06           C  
ATOM     43  NH1 ARG A  34     -15.679  35.831   1.523  1.00 51.05           N  
ATOM     44  NH2 ARG A  34     -13.731  34.667   1.231  1.00 50.96           N  
ATOM     45  N   ILE A  35     -20.472  34.416  -0.887  1.00 60.04           N  
ATOM     46  CA  ILE A  35     -21.538  35.283  -1.437  1.00 59.99           C  
ATOM     47  C   ILE A  35     -22.854  34.519  -1.588  1.00 60.06           C  
ATOM     48  O   ILE A  35     -23.932  35.042  -1.320  1.00 60.03           O  
ATOM     49  CB  ILE A  35     -21.158  35.859  -2.845  1.00 60.11           C  
ATOM     50  CG1 ILE A  35     -20.054  36.919  -2.746  1.00 59.89           C  
ATOM     51  CG2 ILE A  35     -22.376  36.430  -3.557  1.00 59.25           C  
ATOM     52  CD1 ILE A  35     -19.342  37.193  -4.078  1.00 59.55           C  
ATOM     53  N   VAL A  36     -22.759  33.286  -2.053  1.00 60.25           N  
ATOM     54  CA  VAL A  36     -23.944  32.486  -2.303  1.00 60.37           C  
ATOM     55  C   VAL A  36     -24.610  32.124  -0.978  1.00 60.59           C  
ATOM     56  O   VAL A  36     -25.806  32.328  -0.813  1.00 60.33           O  
ATOM     57  CB  VAL A  36     -23.594  31.224  -3.118  1.00 60.43           C  
ATOM     58  CG1 VAL A  36     -24.723  30.161  -3.017  1.00 60.30           C  
ATOM     59  CG2 VAL A  36     -23.283  31.614  -4.549  1.00 58.42           C  
ATOM     60  N   ALA A  37     -23.825  31.611  -0.031  1.00 60.87           N  
ATOM     61  CA  ALA A  37     -24.348  31.263   1.294  1.00 60.75           C  
ATOM     62  C   ALA A  37     -25.048  32.459   1.929  1.00 60.77           C  
ATOM     63  O   ALA A  37     -26.139  32.324   2.474  1.00 61.11           O  
ATOM     64  CB  ALA A  37     -23.243  30.762   2.188  1.00 60.35           C  
ATOM     65  N   ALA A  38     -24.422  33.625   1.837  1.00 60.87           N  
ATOM     66  CA  ALA A  38     -24.975  34.850   2.399  1.00 61.46           C  
ATOM     67  C   ALA A  38     -26.182  35.341   1.615  1.00 61.88           C  
ATOM     68  O   ALA A  38     -27.114  35.897   2.196  1.00 62.59           O  
ATOM     69  CB  ALA A  38     -23.903  35.951   2.498  1.00 61.35           C  
ATOM     70  N   ALA A  39     -26.180  35.141   0.303  1.00 62.15           N  
ATOM     71  CA  ALA A  39     -27.342  35.513  -0.502  1.00 62.63           C  
ATOM     72  C   ALA A  39     -28.563  34.630  -0.177  1.00 62.98           C  
ATOM     73  O   ALA A  39     -29.687  35.125  -0.154  1.00 63.52           O  
ATOM     74  CB  ALA A  39     -27.011  35.496  -1.999  1.00 62.16           C  
ATOM     75  N   LYS A  40     -28.329  33.338   0.089  1.00 63.33           N  
ATOM     76  CA  LYS A  40     -29.358  32.381   0.518  1.00 63.26           C  
ATOM     77  C   LYS A  40     -30.115  32.889   1.729  1.00 63.40           C  
ATOM     78  O   LYS A  40     -31.345  32.844   1.779  1.00 63.96           O  
ATOM     79  CB  LYS A  40     -28.717  31.071   0.931  1.00 63.18           C  
ATOM     80  CG  LYS A  40     -28.722  29.984  -0.091  1.00 65.04           C  
ATOM     81  CD  LYS A  40     -28.895  28.643   0.650  1.00 69.59           C  
ATOM     82  CE  LYS A  40     -28.005  27.514   0.104  1.00 71.16           C  
ATOM     83  NZ  LYS A  40     -26.558  27.720   0.412  1.00 73.86           N  
ATOM     84  N   GLU A  41     -29.368  33.354   2.720  1.00 63.20           N  
ATOM     85  CA  GLU A  41     -29.922  33.723   4.008  1.00 62.82           C  
ATOM     86  C   GLU A  41     -30.672  35.051   3.895  1.00 62.25           C  
ATOM     87  O   GLU A  41     -31.718  35.218   4.511  1.00 61.96           O  
ATOM     88  CB  GLU A  41     -28.781  33.803   5.000  1.00 63.00           C  
ATOM     89  CG  GLU A  41     -29.135  33.572   6.420  1.00 64.50           C  
ATOM     90  CD  GLU A  41     -28.291  34.452   7.353  1.00 67.96           C  
ATOM     91  OE1 GLU A  41     -28.672  34.590   8.536  1.00 68.10           O  
ATOM     92  OE2 GLU A  41     -27.258  35.028   6.907  1.00 69.79           O  
ATOM     93  N   GLU A  42     -30.145  35.969   3.077  1.00 61.86           N  
ATOM     94  CA  GLU A  42     -30.792  37.263   2.768  1.00 61.78           C  
ATOM     95  C   GLU A  42     -32.038  37.204   1.863  1.00 61.71           C  
ATOM     96  O   GLU A  42     -32.965  38.002   2.029  1.00 62.03           O  
ATOM     97  CB  GLU A  42     -29.782  38.229   2.145  1.00 62.10           C  
ATOM     98  CG  GLU A  42     -30.349  39.613   1.751  1.00 62.28           C  
ATOM     99  CD  GLU A  42     -30.478  40.578   2.927  1.00 62.75           C  
ATOM    100  OE1 GLU A  42     -29.919  40.295   4.012  1.00 63.78           O  
ATOM    101  OE2 GLU A  42     -31.137  41.627   2.759  1.00 62.44           O  
ATOM    102  N   PHE A  43     -32.051  36.303   0.886  1.00 61.54           N  
ATOM    103  CA  PHE A  43     -33.246  36.099   0.069  1.00 61.50           C  
ATOM    104  C   PHE A  43     -34.394  35.440   0.842  1.00 60.88           C  
ATOM    105  O   PHE A  43     -35.537  35.839   0.699  1.00 60.74           O  
ATOM    106  CB  PHE A  43     -32.931  35.309  -1.208  1.00 61.90           C  
ATOM    107  CG  PHE A  43     -32.115  36.085  -2.235  1.00 63.55           C  
ATOM    108  CD1 PHE A  43     -32.337  37.456  -2.452  1.00 64.39           C  
ATOM    109  CD2 PHE A  43     -31.145  35.437  -3.012  1.00 63.02           C  
ATOM    110  CE1 PHE A  43     -31.582  38.168  -3.417  1.00 63.72           C  
ATOM    111  CE2 PHE A  43     -30.398  36.142  -3.969  1.00 62.93           C  
ATOM    112  CZ  PHE A  43     -30.621  37.512  -4.170  1.00 62.29           C  
ATOM    113  N   ALA A  44     -34.091  34.448   1.670  1.00 60.36           N  
ATOM    114  CA  ALA A  44     -35.118  33.829   2.487  1.00 60.41           C  
ATOM    115  C   ALA A  44     -35.791  34.853   3.416  1.00 60.59           C  
ATOM    116  O   ALA A  44     -37.003  34.846   3.570  1.00 60.60           O  
ATOM    117  CB  ALA A  44     -34.558  32.647   3.270  1.00 60.15           C  
ATOM    118  N   ARG A  45     -34.999  35.742   4.007  1.00 60.78           N  
ATOM    119  CA  ARG A  45     -35.498  36.801   4.879  1.00 60.75           C  
ATOM    120  C   ARG A  45     -36.370  37.823   4.173  1.00 60.19           C  
ATOM    121  O   ARG A  45     -37.500  38.061   4.561  1.00 59.96           O  
ATOM    122  CB  ARG A  45     -34.321  37.548   5.491  1.00 61.16           C  
ATOM    123  CG  ARG A  45     -34.193  37.421   6.979  1.00 63.68           C  
ATOM    124  CD  ARG A  45     -32.839  37.949   7.433  1.00 68.34           C  
ATOM    125  NE  ARG A  45     -32.379  37.249   8.632  1.00 71.72           N  
ATOM    126  CZ  ARG A  45     -31.857  36.019   8.640  1.00 73.56           C  
ATOM    127  NH1 ARG A  45     -31.719  35.322   7.509  1.00 75.16           N  
ATOM    128  NH2 ARG A  45     -31.481  35.472   9.791  1.00 73.53           N  
ATOM    129  N   HIS A  46     -35.830  38.444   3.141  1.00 60.08           N  
ATOM    130  CA  HIS A  46     -36.401  39.693   2.671  1.00 60.05           C  
ATOM    131  C   HIS A  46     -36.977  39.587   1.273  1.00 60.43           C  
ATOM    132  O   HIS A  46     -37.654  40.504   0.799  1.00 60.18           O  
ATOM    133  CB  HIS A  46     -35.336  40.779   2.725  1.00 59.69           C  
ATOM    134  CG  HIS A  46     -34.806  41.046   4.102  1.00 59.33           C  
ATOM    135  ND1 HIS A  46     -33.535  40.680   4.497  1.00 59.21           N  
ATOM    136  CD2 HIS A  46     -35.370  41.653   5.174  1.00 57.51           C  
ATOM    137  CE1 HIS A  46     -33.339  41.047   5.752  1.00 57.01           C  
ATOM    138  NE2 HIS A  46     -34.438  41.635   6.185  1.00 56.62           N  
ATOM    139  N   GLY A  47     -36.727  38.450   0.626  1.00 60.86           N  
ATOM    140  CA  GLY A  47     -37.057  38.267  -0.784  1.00 61.26           C  
ATOM    141  C   GLY A  47     -36.084  39.024  -1.646  1.00 61.76           C  
ATOM    142  O   GLY A  47     -35.033  39.450  -1.168  1.00 61.88           O  
ATOM    143  N   ILE A  48     -36.441  39.199  -2.915  1.00 62.39           N  
ATOM    144  CA  ILE A  48     -35.593  39.907  -3.898  1.00 62.43           C  
ATOM    145  C   ILE A  48     -35.603  41.438  -3.742  1.00 62.40           C  
ATOM    146  O   ILE A  48     -34.573  42.029  -3.427  1.00 62.51           O  
ATOM    147  CB  ILE A  48     -35.992  39.567  -5.349  1.00 62.61           C  
ATOM    148  CG1 ILE A  48     -36.039  38.055  -5.560  1.00 61.81           C  
ATOM    149  CG2 ILE A  48     -35.064  40.296  -6.352  1.00 63.05           C  
ATOM    150  CD1 ILE A  48     -37.019  37.650  -6.623  1.00 63.30           C  
ATOM    151  N   ALA A  49     -36.755  42.073  -3.978  1.00 62.27           N  
ATOM    152  CA  ALA A  49     -36.885  43.515  -3.773  1.00 62.15           C  
ATOM    153  C   ALA A  49     -36.383  43.905  -2.382  1.00 62.11           C  
ATOM    154  O   ALA A  49     -35.673  44.887  -2.236  1.00 62.11           O  
ATOM    155  CB  ALA A  49     -38.326  43.968  -3.979  1.00 61.88           C  
ATOM    156  N   GLY A  50     -36.718  43.103  -1.374  1.00 62.15           N  
ATOM    157  CA  GLY A  50     -36.278  43.366  -0.014  1.00 62.25           C  
ATOM    158  C   GLY A  50     -34.832  43.048   0.341  1.00 62.69           C  
ATOM    159  O   GLY A  50     -34.338  43.496   1.365  1.00 62.98           O  
ATOM    160  N   ALA A  51     -34.133  42.257  -0.456  1.00 63.09           N  
ATOM    161  CA  ALA A  51     -32.748  41.948  -0.101  1.00 63.67           C  
ATOM    162  C   ALA A  51     -31.777  43.084  -0.486  1.00 64.27           C  
ATOM    163  O   ALA A  51     -31.969  43.770  -1.509  1.00 64.29           O  
ATOM    164  CB  ALA A  51     -32.314  40.606  -0.693  1.00 63.19           C  
ATOM    165  N   ARG A  52     -30.745  43.275   0.343  1.00 64.73           N  
ATOM    166  CA  ARG A  52     -29.691  44.267   0.099  1.00 65.11           C  
ATOM    167  C   ARG A  52     -28.324  43.635  -0.196  1.00 65.30           C  
ATOM    168  O   ARG A  52     -27.803  42.842   0.595  1.00 65.49           O  
ATOM    169  CB  ARG A  52     -29.578  45.251   1.264  1.00 65.01           C  
ATOM    170  CG  ARG A  52     -30.720  46.238   1.326  1.00 66.95           C  
ATOM    171  CD  ARG A  52     -30.221  47.646   1.661  1.00 71.09           C  
ATOM    172  NE  ARG A  52     -31.333  48.601   1.737  1.00 73.89           N  
ATOM    173  CZ  ARG A  52     -31.977  48.936   2.859  1.00 75.16           C  
ATOM    174  NH1 ARG A  52     -31.622  48.414   4.028  1.00 75.88           N  
ATOM    175  NH2 ARG A  52     -32.983  49.803   2.820  1.00 75.46           N  
ATOM    176  N   VAL A  53     -27.751  43.998  -1.346  1.00 65.44           N  
ATOM    177  CA  VAL A  53     -26.377  43.634  -1.721  1.00 65.39           C  
ATOM    178  C   VAL A  53     -25.362  44.134  -0.681  1.00 65.28           C  
ATOM    179  O   VAL A  53     -24.411  43.423  -0.357  1.00 64.93           O  
ATOM    180  CB  VAL A  53     -26.040  44.170  -3.140  1.00 65.78           C  
ATOM    181  CG1 VAL A  53     -24.572  43.916  -3.523  1.00 65.73           C  
ATOM    182  CG2 VAL A  53     -26.995  43.563  -4.174  1.00 65.70           C  
ATOM    183  N   ASP A  54     -25.578  45.353  -0.175  1.00 65.49           N  
ATOM    184  CA  ASP A  54     -24.938  45.840   1.061  1.00 66.02           C  
ATOM    185  C   ASP A  54     -24.801  44.731   2.100  1.00 65.58           C  
ATOM    186  O   ASP A  54     -23.695  44.266   2.370  1.00 65.67           O  
ATOM    187  CB  ASP A  54     -25.743  46.994   1.679  1.00 66.41           C  
ATOM    188  CG  ASP A  54     -25.428  48.331   1.047  1.00 68.72           C  
ATOM    189  OD1 ASP A  54     -24.925  48.345  -0.104  1.00 71.74           O  
ATOM    190  OD2 ASP A  54     -25.679  49.374   1.703  1.00 70.28           O  
ATOM    191  N   ARG A  55     -25.932  44.308   2.666  1.00 65.09           N  
ATOM    192  CA  ARG A  55     -25.941  43.259   3.685  1.00 64.85           C  
ATOM    193  C   ARG A  55     -25.263  41.978   3.204  1.00 63.82           C  
ATOM    194  O   ARG A  55     -24.527  41.337   3.964  1.00 63.89           O  
ATOM    195  CB  ARG A  55     -27.367  42.920   4.126  1.00 65.27           C  
ATOM    196  CG  ARG A  55     -28.038  43.905   5.053  1.00 66.70           C  
ATOM    197  CD  ARG A  55     -29.390  43.320   5.396  1.00 69.67           C  
ATOM    198  NE  ARG A  55     -30.395  44.332   5.706  1.00 72.70           N  
ATOM    199  CZ  ARG A  55     -31.485  44.572   4.978  1.00 73.65           C  
ATOM    200  NH1 ARG A  55     -31.726  43.878   3.868  1.00 72.81           N  
ATOM    201  NH2 ARG A  55     -32.344  45.512   5.371  1.00 74.07           N  
ATOM    202  N   ILE A  56     -25.519  41.602   1.954  1.00 62.42           N  
ATOM    203  CA  ILE A  56     -24.994  40.346   1.443  1.00 61.37           C  
ATOM    204  C   ILE A  56     -23.466  40.335   1.410  1.00 61.30           C  
ATOM    205  O   ILE A  56     -22.854  39.367   1.856  1.00 61.17           O  
ATOM    206  CB  ILE A  56     -25.579  39.979   0.068  1.00 61.35           C  
ATOM    207  CG1 ILE A  56     -27.023  39.478   0.229  1.00 61.04           C  
ATOM    208  CG2 ILE A  56     -24.693  38.927  -0.631  1.00 59.94           C  
ATOM    209  CD1 ILE A  56     -27.820  39.385  -1.076  1.00 60.58           C  
ATOM    210  N   ALA A  57     -22.872  41.405   0.879  1.00 60.84           N  
ATOM    211  CA  ALA A  57     -21.430  41.528   0.801  1.00 60.48           C  
ATOM    212  C   ALA A  57     -20.852  41.660   2.209  1.00 60.73           C  
ATOM    213  O   ALA A  57     -19.856  41.006   2.541  1.00 60.81           O  
ATOM    214  CB  ALA A  57     -21.053  42.709  -0.046  1.00 60.10           C  
ATOM    215  N   LYS A  58     -21.487  42.492   3.035  1.00 60.60           N  
ATOM    216  CA  LYS A  58     -21.073  42.680   4.419  1.00 60.78           C  
ATOM    217  C   LYS A  58     -21.068  41.322   5.131  1.00 60.75           C  
ATOM    218  O   LYS A  58     -20.138  41.014   5.859  1.00 60.57           O  
ATOM    219  CB  LYS A  58     -21.973  43.730   5.105  1.00 60.97           C  
ATOM    220  CG  LYS A  58     -21.999  43.774   6.637  1.00 61.45           C  
ATOM    221  CD  LYS A  58     -23.070  42.808   7.212  1.00 63.63           C  
ATOM    222  CE  LYS A  58     -23.986  43.441   8.290  1.00 64.00           C  
ATOM    223  NZ  LYS A  58     -23.261  44.198   9.355  1.00 63.70           N  
ATOM    224  N   GLN A  59     -22.084  40.501   4.881  1.00 60.90           N  
ATOM    225  CA  GLN A  59     -22.169  39.167   5.487  1.00 61.33           C  
ATOM    226  C   GLN A  59     -21.203  38.142   4.871  1.00 61.14           C  
ATOM    227  O   GLN A  59     -20.627  37.329   5.581  1.00 61.28           O  
ATOM    228  CB  GLN A  59     -23.616  38.633   5.465  1.00 61.39           C  
ATOM    229  CG  GLN A  59     -23.929  37.621   6.577  1.00 63.02           C  
ATOM    230  CD  GLN A  59     -23.720  38.194   8.000  1.00 65.79           C  
ATOM    231  OE1 GLN A  59     -23.727  39.417   8.212  1.00 67.09           O  
ATOM    232  NE2 GLN A  59     -23.536  37.304   8.976  1.00 66.37           N  
ATOM    233  N   ALA A  60     -21.038  38.186   3.551  1.00 61.14           N  
ATOM    234  CA  ALA A  60     -20.139  37.280   2.829  1.00 60.81           C  
ATOM    235  C   ALA A  60     -18.657  37.621   3.034  1.00 60.81           C  
ATOM    236  O   ALA A  60     -17.786  36.989   2.425  1.00 61.02           O  
ATOM    237  CB  ALA A  60     -20.480  37.285   1.336  1.00 60.74           C  
ATOM    238  N   ARG A  61     -18.381  38.616   3.885  1.00 60.41           N  
ATOM    239  CA  ARG A  61     -17.027  39.109   4.146  1.00 59.72           C  
ATOM    240  C   ARG A  61     -16.340  39.545   2.850  1.00 59.51           C  
ATOM    241  O   ARG A  61     -15.191  39.177   2.604  1.00 59.30           O  
ATOM    242  CB  ARG A  61     -16.206  38.040   4.870  1.00 59.69           C  
ATOM    243  CG  ARG A  61     -15.301  38.573   5.950  1.00 59.80           C  
ATOM    244  CD  ARG A  61     -15.262  37.611   7.115  1.00 60.19           C  
ATOM    245  NE  ARG A  61     -16.616  37.295   7.581  1.00 60.39           N  
ATOM    246  CZ  ARG A  61     -16.943  37.005   8.842  1.00 60.94           C  
ATOM    247  NH1 ARG A  61     -16.016  36.994   9.803  1.00 60.42           N  
ATOM    248  NH2 ARG A  61     -18.212  36.739   9.149  1.00 60.03           N  
ATOM    249  N   THR A  62     -17.065  40.309   2.026  1.00 59.32           N  
ATOM    250  CA  THR A  62     -16.547  40.874   0.758  1.00 59.21           C  
ATOM    251  C   THR A  62     -17.129  42.286   0.433  1.00 59.10           C  
ATOM    252  O   THR A  62     -17.728  42.912   1.302  1.00 59.08           O  
ATOM    253  CB  THR A  62     -16.691  39.854  -0.429  1.00 59.25           C  
ATOM    254  OG1 THR A  62     -15.904  40.296  -1.543  1.00 59.30           O  
ATOM    255  CG2 THR A  62     -18.158  39.657  -0.868  1.00 59.22           C  
ATOM    256  N   SER A  63     -16.935  42.797  -0.788  1.00 59.34           N  
ATOM    257  CA  SER A  63     -17.493  44.115  -1.195  1.00 59.60           C  
ATOM    258  C   SER A  63     -18.597  44.052  -2.266  1.00 60.58           C  
ATOM    259  O   SER A  63     -18.705  43.076  -3.034  1.00 60.39           O  
ATOM    260  CB  SER A  63     -16.389  45.081  -1.664  1.00 59.28           C  
ATOM    261  OG  SER A  63     -15.939  44.775  -2.971  1.00 57.42           O  
ATOM    262  N   LYS A  64     -19.407  45.110  -2.313  1.00 61.52           N  
ATOM    263  CA  LYS A  64     -20.394  45.284  -3.373  1.00 62.54           C  
ATOM    264  C   LYS A  64     -19.751  45.086  -4.749  1.00 62.91           C  
ATOM    265  O   LYS A  64     -20.266  44.308  -5.546  1.00 62.92           O  
ATOM    266  CB  LYS A  64     -21.066  46.661  -3.291  1.00 62.62           C  
ATOM    267  CG  LYS A  64     -22.209  46.768  -2.281  1.00 63.12           C  
ATOM    268  CD  LYS A  64     -22.915  48.121  -2.380  1.00 63.10           C  
ATOM    269  CE  LYS A  64     -23.878  48.152  -3.560  1.00 64.97           C  
ATOM    270  NZ  LYS A  64     -24.783  49.332  -3.511  1.00 65.95           N  
ATOM    271  N   GLU A  65     -18.618  45.754  -5.016  1.00 63.45           N  
ATOM    272  CA  GLU A  65     -17.976  45.635  -6.332  1.00 63.96           C  
ATOM    273  C   GLU A  65     -17.656  44.177  -6.692  1.00 63.67           C  
ATOM    274  O   GLU A  65     -17.866  43.754  -7.834  1.00 63.87           O  
ATOM    275  CB  GLU A  65     -16.739  46.535  -6.493  1.00 63.75           C  
ATOM    276  CG  GLU A  65     -16.547  46.995  -7.973  1.00 65.12           C  
ATOM    277  CD  GLU A  65     -15.129  47.516  -8.339  1.00 65.00           C  
ATOM    278  OE1 GLU A  65     -14.185  47.281  -7.551  1.00 66.70           O  
ATOM    279  OE2 GLU A  65     -14.958  48.145  -9.425  1.00 63.99           O  
ATOM    280  N   ARG A  66     -17.180  43.415  -5.710  1.00 63.53           N  
ATOM    281  CA  ARG A  66     -16.835  42.004  -5.907  1.00 63.51           C  
ATOM    282  C   ARG A  66     -18.055  41.161  -6.290  1.00 63.02           C  
ATOM    283  O   ARG A  66     -18.019  40.383  -7.257  1.00 62.88           O  
ATOM    284  CB  ARG A  66     -16.215  41.439  -4.638  1.00 63.93           C  
ATOM    285  CG  ARG A  66     -15.054  40.531  -4.883  1.00 65.52           C  
ATOM    286  CD  ARG A  66     -13.749  41.227  -4.505  1.00 70.36           C  
ATOM    287  NE  ARG A  66     -12.633  40.921  -5.413  1.00 74.25           N  
ATOM    288  CZ  ARG A  66     -12.700  40.174  -6.525  1.00 75.15           C  
ATOM    289  NH1 ARG A  66     -13.835  39.597  -6.919  1.00 75.44           N  
ATOM    290  NH2 ARG A  66     -11.607  39.993  -7.254  1.00 75.11           N  
ATOM    291  N   VAL A  67     -19.133  41.325  -5.524  1.00 62.26           N  
ATOM    292  CA  VAL A  67     -20.381  40.624  -5.778  1.00 61.55           C  
ATOM    293  C   VAL A  67     -20.770  40.788  -7.250  1.00 61.43           C  
ATOM    294  O   VAL A  67     -21.017  39.802  -7.961  1.00 61.56           O  
ATOM    295  CB  VAL A  67     -21.497  41.132  -4.843  1.00 61.48           C  
ATOM    296  CG1 VAL A  67     -22.831  40.459  -5.154  1.00 60.99           C  
ATOM    297  CG2 VAL A  67     -21.110  40.908  -3.373  1.00 60.76           C  
ATOM    298  N   TYR A  68     -20.765  42.034  -7.707  1.00 60.65           N  
ATOM    299  CA  TYR A  68     -21.138  42.370  -9.070  1.00 59.94           C  
ATOM    300  C   TYR A  68     -20.141  41.924 -10.138  1.00 59.10           C  
ATOM    301  O   TYR A  68     -20.417  42.048 -11.326  1.00 58.74           O  
ATOM    302  CB  TYR A  68     -21.407  43.869  -9.203  1.00 60.38           C  
ATOM    303  CG  TYR A  68     -22.608  44.395  -8.430  1.00 61.60           C  
ATOM    304  CD1 TYR A  68     -23.886  43.808  -8.552  1.00 62.00           C  
ATOM    305  CD2 TYR A  68     -22.477  45.505  -7.595  1.00 62.53           C  
ATOM    306  CE1 TYR A  68     -24.991  44.319  -7.848  1.00 61.97           C  
ATOM    307  CE2 TYR A  68     -23.578  46.014  -6.881  1.00 63.65           C  
ATOM    308  CZ  TYR A  68     -24.827  45.424  -7.016  1.00 62.24           C  
ATOM    309  OH  TYR A  68     -25.883  45.959  -6.299  1.00 63.15           O  
ATOM    310  N   ALA A  69     -18.982  41.421  -9.735  1.00 58.51           N  
ATOM    311  CA  ALA A  69     -18.097  40.781 -10.705  1.00 57.85           C  
ATOM    312  C   ALA A  69     -18.658  39.389 -11.036  1.00 57.68           C  
ATOM    313  O   ALA A  69     -18.772  39.028 -12.206  1.00 58.02           O  
ATOM    314  CB  ALA A  69     -16.684  40.704 -10.198  1.00 57.17           C  
ATOM    315  N   TYR A  70     -19.048  38.624 -10.015  1.00 57.01           N  
ATOM    316  CA  TYR A  70     -19.629  37.309 -10.247  1.00 56.56           C  
ATOM    317  C   TYR A  70     -21.009  37.420 -10.865  1.00 56.51           C  
ATOM    318  O   TYR A  70     -21.360  36.675 -11.774  1.00 56.63           O  
ATOM    319  CB  TYR A  70     -19.719  36.505  -8.942  1.00 56.54           C  
ATOM    320  CG  TYR A  70     -18.377  36.076  -8.392  1.00 56.16           C  
ATOM    321  CD1 TYR A  70     -17.624  36.945  -7.581  1.00 56.07           C  
ATOM    322  CD2 TYR A  70     -17.855  34.812  -8.683  1.00 53.68           C  
ATOM    323  CE1 TYR A  70     -16.369  36.571  -7.087  1.00 55.88           C  
ATOM    324  CE2 TYR A  70     -16.617  34.423  -8.192  1.00 55.23           C  
ATOM    325  CZ  TYR A  70     -15.872  35.310  -7.394  1.00 56.31           C  
ATOM    326  OH  TYR A  70     -14.639  34.948  -6.903  1.00 55.50           O  
ATOM    327  N   PHE A  71     -21.802  38.353 -10.369  1.00 56.49           N  
ATOM    328  CA  PHE A  71     -23.194  38.409 -10.756  1.00 56.69           C  
ATOM    329  C   PHE A  71     -23.547  39.773 -11.301  1.00 57.15           C  
ATOM    330  O   PHE A  71     -23.151  40.795 -10.746  1.00 57.84           O  
ATOM    331  CB  PHE A  71     -24.077  38.060  -9.569  1.00 56.46           C  
ATOM    332  CG  PHE A  71     -23.675  36.775  -8.872  1.00 55.78           C  
ATOM    333  CD1 PHE A  71     -22.891  36.807  -7.721  1.00 55.67           C  
ATOM    334  CD2 PHE A  71     -24.086  35.538  -9.367  1.00 54.02           C  
ATOM    335  CE1 PHE A  71     -22.524  35.623  -7.064  1.00 56.18           C  
ATOM    336  CE2 PHE A  71     -23.726  34.354  -8.731  1.00 54.11           C  
ATOM    337  CZ  PHE A  71     -22.946  34.392  -7.567  1.00 56.09           C  
ATOM    338  N   ARG A  72     -24.281  39.777 -12.407  1.00 56.88           N  
ATOM    339  CA  ARG A  72     -24.680  40.998 -13.085  1.00 55.90           C  
ATOM    340  C   ARG A  72     -25.529  41.943 -12.193  1.00 55.62           C  
ATOM    341  O   ARG A  72     -25.357  43.157 -12.220  1.00 55.55           O  
ATOM    342  CB  ARG A  72     -25.431  40.565 -14.338  1.00 55.67           C  
ATOM    343  CG  ARG A  72     -25.964  41.628 -15.215  1.00 55.50           C  
ATOM    344  CD  ARG A  72     -26.800  40.900 -16.245  1.00 56.87           C  
ATOM    345  NE  ARG A  72     -27.357  41.810 -17.231  1.00 57.05           N  
ATOM    346  CZ  ARG A  72     -26.750  42.163 -18.357  1.00 57.32           C  
ATOM    347  NH1 ARG A  72     -25.551  41.681 -18.661  1.00 58.25           N  
ATOM    348  NH2 ARG A  72     -27.344  43.008 -19.189  1.00 57.98           N  
ATOM    349  N   SER A  73     -26.433  41.375 -11.392  1.00 55.22           N  
ATOM    350  CA  SER A  73     -27.494  42.141 -10.729  1.00 54.31           C  
ATOM    351  C   SER A  73     -28.038  41.420  -9.507  1.00 53.85           C  
ATOM    352  O   SER A  73     -27.892  40.209  -9.365  1.00 53.63           O  
ATOM    353  CB  SER A  73     -28.645  42.378 -11.712  1.00 54.41           C  
ATOM    354  OG  SER A  73     -29.348  41.171 -11.992  1.00 54.49           O  
ATOM    355  N   LYS A  74     -28.693  42.155  -8.625  1.00 53.47           N  
ATOM    356  CA  LYS A  74     -29.393  41.511  -7.526  1.00 53.38           C  
ATOM    357  C   LYS A  74     -30.257  40.355  -8.048  1.00 53.38           C  
ATOM    358  O   LYS A  74     -30.338  39.295  -7.431  1.00 53.71           O  
ATOM    359  CB  LYS A  74     -30.258  42.536  -6.789  1.00 53.27           C  
ATOM    360  CG  LYS A  74     -30.546  42.223  -5.318  1.00 53.10           C  
ATOM    361  CD  LYS A  74     -31.332  43.349  -4.614  1.00 53.72           C  
ATOM    362  CE  LYS A  74     -32.735  43.533  -5.184  1.00 53.29           C  
ATOM    363  NZ  LYS A  74     -33.399  44.744  -4.664  1.00 53.64           N  
ATOM    364  N   GLU A  75     -30.888  40.554  -9.201  1.00 53.53           N  
ATOM    365  CA  GLU A  75     -31.844  39.573  -9.731  1.00 53.82           C  
ATOM    366  C   GLU A  75     -31.126  38.356 -10.351  1.00 52.61           C  
ATOM    367  O   GLU A  75     -31.556  37.211 -10.179  1.00 52.39           O  
ATOM    368  CB  GLU A  75     -32.850  40.236 -10.706  1.00 54.57           C  
ATOM    369  CG  GLU A  75     -33.445  41.606 -10.224  1.00 58.19           C  
ATOM    370  CD  GLU A  75     -32.538  42.835 -10.557  1.00 63.14           C  
ATOM    371  OE1 GLU A  75     -32.199  43.033 -11.758  1.00 64.80           O  
ATOM    372  OE2 GLU A  75     -32.175  43.608  -9.625  1.00 64.63           O  
ATOM    373  N   ALA A  76     -30.019  38.622 -11.038  1.00 51.16           N  
ATOM    374  CA  ALA A  76     -29.128  37.572 -11.519  1.00 50.17           C  
ATOM    375  C   ALA A  76     -28.608  36.703 -10.382  1.00 49.62           C  
ATOM    376  O   ALA A  76     -28.537  35.487 -10.507  1.00 49.66           O  
ATOM    377  CB  ALA A  76     -27.975  38.173 -12.314  1.00 49.70           C  
ATOM    378  N   LEU A  77     -28.261  37.338  -9.269  1.00 49.41           N  
ATOM    379  CA  LEU A  77     -27.790  36.641  -8.100  1.00 49.16           C  
ATOM    380  C   LEU A  77     -28.877  35.728  -7.570  1.00 50.70           C  
ATOM    381  O   LEU A  77     -28.627  34.537  -7.362  1.00 50.85           O  
ATOM    382  CB  LEU A  77     -27.349  37.640  -7.035  1.00 49.07           C  
ATOM    383  CG  LEU A  77     -26.864  37.152  -5.657  1.00 47.76           C  
ATOM    384  CD1 LEU A  77     -25.787  36.088  -5.736  1.00 46.79           C  
ATOM    385  CD2 LEU A  77     -26.382  38.302  -4.814  1.00 47.76           C  
ATOM    386  N   TYR A  78     -30.084  36.267  -7.361  1.00 51.99           N  
ATOM    387  CA  TYR A  78     -31.216  35.410  -7.007  1.00 53.48           C  
ATOM    388  C   TYR A  78     -31.287  34.191  -7.938  1.00 53.83           C  
ATOM    389  O   TYR A  78     -31.230  33.049  -7.461  1.00 54.21           O  
ATOM    390  CB  TYR A  78     -32.565  36.146  -6.973  1.00 54.05           C  
ATOM    391  CG  TYR A  78     -33.720  35.216  -6.563  1.00 55.79           C  
ATOM    392  CD1 TYR A  78     -34.544  34.594  -7.529  1.00 55.57           C  
ATOM    393  CD2 TYR A  78     -33.977  34.937  -5.206  1.00 57.11           C  
ATOM    394  CE1 TYR A  78     -35.583  33.737  -7.156  1.00 55.25           C  
ATOM    395  CE2 TYR A  78     -35.025  34.080  -4.817  1.00 55.66           C  
ATOM    396  CZ  TYR A  78     -35.818  33.481  -5.795  1.00 56.54           C  
ATOM    397  OH  TYR A  78     -36.844  32.618  -5.398  1.00 57.92           O  
ATOM    398  N   ALA A  79     -31.375  34.433  -9.251  1.00 53.85           N  
ATOM    399  CA  ALA A  79     -31.589  33.356 -10.221  1.00 54.08           C  
ATOM    400  C   ALA A  79     -30.619  32.223  -9.956  1.00 54.23           C  
ATOM    401  O   ALA A  79     -31.023  31.059  -9.843  1.00 53.63           O  
ATOM    402  CB  ALA A  79     -31.461  33.868 -11.667  1.00 53.76           C  
ATOM    403  N   HIS A  80     -29.344  32.602  -9.810  1.00 55.00           N  
ATOM    404  CA  HIS A  80     -28.246  31.673  -9.540  1.00 55.34           C  
ATOM    405  C   HIS A  80     -28.511  30.832  -8.294  1.00 55.83           C  
ATOM    406  O   HIS A  80     -28.412  29.591  -8.321  1.00 55.80           O  
ATOM    407  CB  HIS A  80     -26.945  32.434  -9.383  1.00 54.75           C  
ATOM    408  CG  HIS A  80     -25.739  31.555  -9.287  1.00 55.42           C  
ATOM    409  ND1 HIS A  80     -25.207  30.898 -10.375  1.00 56.39           N  
ATOM    410  CD2 HIS A  80     -24.947  31.237  -8.233  1.00 56.15           C  
ATOM    411  CE1 HIS A  80     -24.147  30.203  -9.995  1.00 56.36           C  
ATOM    412  NE2 HIS A  80     -23.965  30.393  -8.700  1.00 55.98           N  
ATOM    413  N   VAL A  81     -28.871  31.519  -7.219  1.00 56.21           N  
ATOM    414  CA  VAL A  81     -29.147  30.873  -5.968  1.00 57.12           C  
ATOM    415  C   VAL A  81     -30.304  29.880  -6.084  1.00 58.25           C  
ATOM    416  O   VAL A  81     -30.190  28.744  -5.610  1.00 58.20           O  
ATOM    417  CB  VAL A  81     -29.426  31.904  -4.901  1.00 56.95           C  
ATOM    418  CG1 VAL A  81     -29.769  31.219  -3.608  1.00 56.93           C  
ATOM    419  CG2 VAL A  81     -28.206  32.822  -4.735  1.00 56.39           C  
ATOM    420  N   ALA A  82     -31.389  30.305  -6.735  1.00 59.59           N  
ATOM    421  CA  ALA A  82     -32.564  29.466  -6.954  1.00 60.92           C  
ATOM    422  C   ALA A  82     -32.177  28.204  -7.713  1.00 62.38           C  
ATOM    423  O   ALA A  82     -32.408  27.101  -7.204  1.00 62.81           O  
ATOM    424  CB  ALA A  82     -33.638  30.228  -7.694  1.00 60.67           C  
ATOM    425  N   GLU A  83     -31.586  28.362  -8.905  1.00 63.64           N  
ATOM    426  CA  GLU A  83     -31.027  27.232  -9.670  1.00 65.59           C  
ATOM    427  C   GLU A  83     -30.281  26.262  -8.756  1.00 65.21           C  
ATOM    428  O   GLU A  83     -30.665  25.100  -8.604  1.00 65.00           O  
ATOM    429  CB  GLU A  83     -30.056  27.726 -10.741  1.00 65.22           C  
ATOM    430  CG  GLU A  83     -30.712  28.357 -11.967  1.00 68.12           C  
ATOM    431  CD  GLU A  83     -29.747  29.242 -12.801  1.00 68.97           C  
ATOM    432  OE1 GLU A  83     -28.733  28.709 -13.337  1.00 72.80           O  
ATOM    433  OE2 GLU A  83     -30.009  30.477 -12.928  1.00 73.58           O  
ATOM    434  N   ARG A  84     -29.219  26.776  -8.141  1.00 65.74           N  
ATOM    435  CA  ARG A  84     -28.379  26.026  -7.221  1.00 66.05           C  
ATOM    436  C   ARG A  84     -29.264  25.274  -6.218  1.00 65.85           C  
ATOM    437  O   ARG A  84     -29.032  24.094  -5.956  1.00 65.98           O  
ATOM    438  CB  ARG A  84     -27.376  26.973  -6.517  1.00 66.54           C  
ATOM    439  CG  ARG A  84     -25.938  26.436  -6.359  1.00 67.47           C  
ATOM    440  CD  ARG A  84     -24.990  26.800  -7.554  1.00 70.15           C  
ATOM    441  NE  ARG A  84     -23.590  26.340  -7.378  1.00 70.55           N  
ATOM    442  CZ  ARG A  84     -22.580  26.574  -8.232  1.00 72.94           C  
ATOM    443  NH1 ARG A  84     -22.761  27.268  -9.351  1.00 73.47           N  
ATOM    444  NH2 ARG A  84     -21.363  26.104  -7.978  1.00 73.30           N  
ATOM    445  N   GLU A  85     -30.297  25.939  -5.697  1.00 65.65           N  
ATOM    446  CA  GLU A  85     -31.218  25.330  -4.717  1.00 65.78           C  
ATOM    447  C   GLU A  85     -32.057  24.208  -5.302  1.00 65.34           C  
ATOM    448  O   GLU A  85     -32.149  23.114  -4.724  1.00 64.95           O  
ATOM    449  CB  GLU A  85     -32.156  26.385  -4.139  1.00 66.06           C  
ATOM    450  CG  GLU A  85     -31.531  27.232  -3.045  1.00 69.64           C  
ATOM    451  CD  GLU A  85     -30.967  26.383  -1.916  1.00 73.99           C  
ATOM    452  OE1 GLU A  85     -31.783  25.841  -1.134  1.00 76.81           O  
ATOM    453  OE2 GLU A  85     -29.717  26.246  -1.816  1.00 75.61           O  
ATOM    454  N   THR A  86     -32.677  24.515  -6.439  1.00 64.96           N  
ATOM    455  CA  THR A  86     -33.472  23.574  -7.200  1.00 65.09           C  
ATOM    456  C   THR A  86     -32.697  22.302  -7.508  1.00 65.13           C  
ATOM    457  O   THR A  86     -33.216  21.203  -7.290  1.00 65.29           O  
ATOM    458  CB  THR A  86     -33.932  24.193  -8.526  1.00 65.28           C  
ATOM    459  OG1 THR A  86     -34.403  25.520  -8.287  1.00 66.12           O  
ATOM    460  CG2 THR A  86     -35.051  23.386  -9.130  1.00 64.54           C  
ATOM    461  N   THR A  87     -31.466  22.452  -8.004  1.00 64.63           N  
ATOM    462  CA  THR A  87     -30.630  21.313  -8.373  1.00 64.47           C  
ATOM    463  C   THR A  87     -30.296  20.479  -7.150  1.00 64.44           C  
ATOM    464  O   THR A  87     -30.372  19.266  -7.189  1.00 63.87           O  
ATOM    465  CB  THR A  87     -29.321  21.775  -9.034  1.00 64.68           C  
ATOM    466  OG1 THR A  87     -29.496  23.101  -9.537  1.00 64.98           O  
ATOM    467  CG2 THR A  87     -28.912  20.848 -10.178  1.00 63.53           C  
ATOM    468  N   ALA A  88     -29.932  21.148  -6.061  1.00 65.17           N  
ATOM    469  CA  ALA A  88     -29.711  20.493  -4.769  1.00 66.07           C  
ATOM    470  C   ALA A  88     -30.887  19.592  -4.403  1.00 66.70           C  
ATOM    471  O   ALA A  88     -30.709  18.457  -3.936  1.00 66.59           O  
ATOM    472  CB  ALA A  88     -29.518  21.535  -3.692  1.00 65.88           C  
ATOM    473  N   LEU A  89     -32.081  20.134  -4.623  1.00 67.38           N  
ATOM    474  CA  LEU A  89     -33.330  19.486  -4.310  1.00 68.25           C  
ATOM    475  C   LEU A  89     -33.552  18.287  -5.217  1.00 68.80           C  
ATOM    476  O   LEU A  89     -33.669  17.161  -4.735  1.00 69.20           O  
ATOM    477  CB  LEU A  89     -34.473  20.493  -4.471  1.00 68.42           C  
ATOM    478  CG  LEU A  89     -35.941  20.011  -4.411  1.00 69.66           C  
ATOM    479  CD1 LEU A  89     -36.383  19.644  -2.973  1.00 69.05           C  
ATOM    480  CD2 LEU A  89     -36.936  21.020  -5.085  1.00 68.61           C  
ATOM    481  N   ILE A  90     -33.608  18.545  -6.525  1.00 68.91           N  
ATOM    482  CA  ILE A  90     -33.830  17.529  -7.545  1.00 68.74           C  
ATOM    483  C   ILE A  90     -32.977  16.289  -7.296  1.00 69.65           C  
ATOM    484  O   ILE A  90     -33.455  15.163  -7.426  1.00 69.79           O  
ATOM    485  CB  ILE A  90     -33.587  18.129  -8.940  1.00 68.21           C  
ATOM    486  CG1 ILE A  90     -34.801  18.950  -9.340  1.00 67.71           C  
ATOM    487  CG2 ILE A  90     -33.358  17.065  -9.982  1.00 67.63           C  
ATOM    488  CD1 ILE A  90     -34.524  19.990 -10.372  1.00 67.85           C  
ATOM    489  N   GLU A  91     -31.723  16.513  -6.914  1.00 70.81           N  
ATOM    490  CA  GLU A  91     -30.773  15.438  -6.609  1.00 72.07           C  
ATOM    491  C   GLU A  91     -31.078  14.715  -5.303  1.00 72.32           C  
ATOM    492  O   GLU A  91     -30.947  13.499  -5.220  1.00 72.71           O  
ATOM    493  CB  GLU A  91     -29.349  15.973  -6.597  1.00 72.09           C  
ATOM    494  CG  GLU A  91     -28.927  16.439  -7.971  1.00 73.90           C  
ATOM    495  CD  GLU A  91     -27.492  16.910  -8.031  1.00 76.26           C  
ATOM    496  OE1 GLU A  91     -26.669  16.485  -7.184  1.00 77.60           O  
ATOM    497  OE2 GLU A  91     -27.185  17.705  -8.942  1.00 77.00           O  
ATOM    498  N   ALA A  92     -31.494  15.465  -4.291  1.00 72.57           N  
ATOM    499  CA  ALA A  92     -31.944  14.881  -3.034  1.00 72.56           C  
ATOM    500  C   ALA A  92     -33.282  14.125  -3.186  1.00 72.41           C  
ATOM    501  O   ALA A  92     -33.748  13.482  -2.239  1.00 72.66           O  
ATOM    502  CB  ALA A  92     -32.063  15.979  -1.967  1.00 72.49           C  
ATOM    503  N   THR A  93     -33.878  14.183  -4.379  1.00 71.92           N  
ATOM    504  CA  THR A  93     -35.309  13.879  -4.547  1.00 71.21           C  
ATOM    505  C   THR A  93     -35.611  12.903  -5.673  1.00 71.01           C  
ATOM    506  O   THR A  93     -36.687  12.952  -6.264  1.00 71.08           O  
ATOM    507  CB  THR A  93     -36.134  15.207  -4.651  1.00 71.31           C  
ATOM    508  OG1 THR A  93     -36.613  15.542  -3.347  1.00 71.56           O  
ATOM    509  CG2 THR A  93     -37.325  15.153  -5.637  1.00 70.25           C  
ATOM    510  N   GLN A  94     -34.660  12.015  -5.962  1.00 70.30           N  
ATOM    511  CA  GLN A  94     -34.927  10.874  -6.830  1.00 69.61           C  
ATOM    512  C   GLN A  94     -36.346  10.341  -6.520  1.00 68.44           C  
ATOM    513  O   GLN A  94     -36.650   9.961  -5.381  1.00 67.58           O  
ATOM    514  CB  GLN A  94     -33.822   9.815  -6.624  1.00 70.46           C  
ATOM    515  CG  GLN A  94     -34.147   8.339  -6.999  1.00 72.65           C  
ATOM    516  CD  GLN A  94     -34.096   8.051  -8.510  1.00 76.27           C  
ATOM    517  OE1 GLN A  94     -35.033   7.455  -9.080  1.00 78.46           O  
ATOM    518  NE2 GLN A  94     -33.007   8.465  -9.160  1.00 75.61           N  
ATOM    519  N   LEU A  95     -37.225  10.370  -7.519  1.00 67.13           N  
ATOM    520  CA  LEU A  95     -38.571   9.855  -7.324  1.00 66.33           C  
ATOM    521  C   LEU A  95     -38.644   8.344  -7.451  1.00 65.80           C  
ATOM    522  O   LEU A  95     -38.224   7.772  -8.455  1.00 66.15           O  
ATOM    523  CB  LEU A  95     -39.575  10.498  -8.282  1.00 66.25           C  
ATOM    524  CG  LEU A  95     -40.902   9.728  -8.507  1.00 66.57           C  
ATOM    525  CD1 LEU A  95     -41.768   9.566  -7.247  1.00 65.55           C  
ATOM    526  CD2 LEU A  95     -41.726  10.363  -9.616  1.00 66.72           C  
ATOM    527  N   ASP A  96     -39.190   7.705  -6.420  1.00 65.02           N  
ATOM    528  CA  ASP A  96     -39.487   6.290  -6.475  1.00 64.02           C  
ATOM    529  C   ASP A  96     -40.994   6.069  -6.593  1.00 63.10           C  
ATOM    530  O   ASP A  96     -41.720   6.256  -5.610  1.00 62.99           O  
ATOM    531  CB  ASP A  96     -38.947   5.569  -5.249  1.00 64.11           C  
ATOM    532  CG  ASP A  96     -38.894   4.056  -5.446  1.00 65.42           C  
ATOM    533  OD1 ASP A  96     -39.804   3.471  -6.095  1.00 65.07           O  
ATOM    534  OD2 ASP A  96     -37.924   3.444  -4.950  1.00 67.18           O  
ATOM    535  N   PRO A  97     -41.470   5.672  -7.798  1.00 61.92           N  
ATOM    536  CA  PRO A  97     -42.896   5.503  -8.053  1.00 60.95           C  
ATOM    537  C   PRO A  97     -43.494   4.347  -7.262  1.00 60.27           C  
ATOM    538  O   PRO A  97     -44.705   4.312  -7.036  1.00 60.19           O  
ATOM    539  CB  PRO A  97     -42.947   5.216  -9.547  1.00 60.46           C  
ATOM    540  CG  PRO A  97     -41.670   5.721 -10.072  1.00 61.05           C  
ATOM    541  CD  PRO A  97     -40.690   5.403  -9.014  1.00 61.80           C  
ATOM    542  N   ALA A  98     -42.630   3.438  -6.821  1.00 59.46           N  
ATOM    543  CA  ALA A  98     -43.025   2.259  -6.069  1.00 58.58           C  
ATOM    544  C   ALA A  98     -42.987   2.509  -4.564  1.00 58.12           C  
ATOM    545  O   ALA A  98     -43.360   1.632  -3.781  1.00 58.38           O  
ATOM    546  CB  ALA A  98     -42.137   1.083  -6.438  1.00 58.75           C  
ATOM    547  N   ASP A  99     -42.535   3.694  -4.166  1.00 57.00           N  
ATOM    548  CA  ASP A  99     -42.650   4.132  -2.791  1.00 56.22           C  
ATOM    549  C   ASP A  99     -42.932   5.624  -2.748  1.00 55.63           C  
ATOM    550  O   ASP A  99     -42.053   6.457  -2.517  1.00 56.15           O  
ATOM    551  CB  ASP A  99     -41.394   3.787  -1.990  1.00 56.60           C  
ATOM    552  CG  ASP A  99     -41.524   4.133  -0.490  1.00 57.22           C  
ATOM    553  OD1 ASP A  99     -42.598   4.557  -0.012  1.00 57.91           O  
ATOM    554  OD2 ASP A  99     -40.528   3.985   0.226  1.00 59.09           O  
ATOM    555  N   LEU A 100     -44.178   5.963  -2.982  1.00 54.74           N  
ATOM    556  CA  LEU A 100     -44.569   7.337  -2.954  1.00 53.79           C  
ATOM    557  C   LEU A 100     -44.555   7.938  -1.534  1.00 54.52           C  
ATOM    558  O   LEU A 100     -44.096   9.073  -1.374  1.00 54.79           O  
ATOM    559  CB  LEU A 100     -45.914   7.486  -3.626  1.00 52.97           C  
ATOM    560  CG  LEU A 100     -45.853   7.143  -5.107  1.00 51.76           C  
ATOM    561  CD1 LEU A 100     -47.255   6.955  -5.614  1.00 51.97           C  
ATOM    562  CD2 LEU A 100     -45.121   8.204  -5.912  1.00 49.94           C  
ATOM    563  N   PRO A 101     -45.045   7.193  -0.499  1.00 54.52           N  
ATOM    564  CA  PRO A 101     -44.952   7.773   0.867  1.00 54.35           C  
ATOM    565  C   PRO A 101     -43.509   7.979   1.358  1.00 54.63           C  
ATOM    566  O   PRO A 101     -43.237   8.928   2.099  1.00 54.68           O  
ATOM    567  CB  PRO A 101     -45.713   6.759   1.749  1.00 54.32           C  
ATOM    568  CG  PRO A 101     -45.805   5.498   0.957  1.00 53.21           C  
ATOM    569  CD  PRO A 101     -45.707   5.865  -0.498  1.00 54.23           C  
ATOM    570  N   GLY A 102     -42.604   7.095   0.941  1.00 54.87           N  
ATOM    571  CA  GLY A 102     -41.194   7.238   1.226  1.00 55.30           C  
ATOM    572  C   GLY A 102     -40.696   8.464   0.492  1.00 56.12           C  
ATOM    573  O   GLY A 102     -39.879   9.217   1.015  1.00 56.70           O  
ATOM    574  N   TYR A 103     -41.194   8.673  -0.721  1.00 56.41           N  
ATOM    575  CA  TYR A 103     -40.873   9.874  -1.485  1.00 57.06           C  
ATOM    576  C   TYR A 103     -41.256  11.133  -0.698  1.00 57.35           C  
ATOM    577  O   TYR A 103     -40.496  12.112  -0.637  1.00 58.13           O  
ATOM    578  CB  TYR A 103     -41.588   9.835  -2.849  1.00 57.05           C  
ATOM    579  CG  TYR A 103     -41.431  11.084  -3.683  1.00 56.95           C  
ATOM    580  CD1 TYR A 103     -42.552  11.728  -4.230  1.00 57.00           C  
ATOM    581  CD2 TYR A 103     -40.165  11.642  -3.926  1.00 57.63           C  
ATOM    582  CE1 TYR A 103     -42.424  12.906  -5.013  1.00 56.24           C  
ATOM    583  CE2 TYR A 103     -40.019  12.817  -4.713  1.00 57.22           C  
ATOM    584  CZ  TYR A 103     -41.150  13.436  -5.246  1.00 57.07           C  
ATOM    585  OH  TYR A 103     -41.008  14.586  -5.989  1.00 57.78           O  
ATOM    586  N   ALA A 104     -42.436  11.100  -0.087  1.00 57.29           N  
ATOM    587  CA  ALA A 104     -42.960  12.249   0.636  1.00 56.72           C  
ATOM    588  C   ALA A 104     -42.106  12.524   1.854  1.00 56.59           C  
ATOM    589  O   ALA A 104     -41.867  13.681   2.169  1.00 57.01           O  
ATOM    590  CB  ALA A 104     -44.402  12.019   1.034  1.00 56.53           C  
ATOM    591  N   GLY A 105     -41.651  11.463   2.527  1.00 55.88           N  
ATOM    592  CA  GLY A 105     -40.789  11.599   3.687  1.00 55.32           C  
ATOM    593  C   GLY A 105     -39.513  12.275   3.252  1.00 55.42           C  
ATOM    594  O   GLY A 105     -39.002  13.154   3.938  1.00 55.77           O  
ATOM    595  N   ILE A 106     -39.017  11.885   2.086  1.00 55.39           N  
ATOM    596  CA  ILE A 106     -37.819  12.484   1.508  1.00 55.98           C  
ATOM    597  C   ILE A 106     -37.964  14.027   1.398  1.00 56.40           C  
ATOM    598  O   ILE A 106     -37.141  14.770   1.948  1.00 56.32           O  
ATOM    599  CB  ILE A 106     -37.378  11.709   0.198  1.00 56.07           C  
ATOM    600  CG1 ILE A 106     -36.214  10.770   0.507  1.00 56.53           C  
ATOM    601  CG2 ILE A 106     -36.964  12.605  -0.947  1.00 56.51           C  
ATOM    602  CD1 ILE A 106     -36.620   9.336   0.949  1.00 58.40           C  
ATOM    603  N   LEU A 107     -39.039  14.498   0.757  1.00 56.74           N  
ATOM    604  CA  LEU A 107     -39.310  15.949   0.647  1.00 56.75           C  
ATOM    605  C   LEU A 107     -39.531  16.584   2.009  1.00 56.53           C  
ATOM    606  O   LEU A 107     -39.120  17.722   2.252  1.00 56.38           O  
ATOM    607  CB  LEU A 107     -40.521  16.226  -0.249  1.00 56.52           C  
ATOM    608  CG  LEU A 107     -40.390  15.743  -1.692  1.00 58.18           C  
ATOM    609  CD1 LEU A 107     -41.723  15.545  -2.426  1.00 55.48           C  
ATOM    610  CD2 LEU A 107     -39.497  16.734  -2.444  1.00 60.50           C  
ATOM    611  N   PHE A 108     -40.186  15.852   2.899  1.00 56.15           N  
ATOM    612  CA  PHE A 108     -40.452  16.395   4.196  1.00 56.64           C  
ATOM    613  C   PHE A 108     -39.132  16.717   4.876  1.00 57.76           C  
ATOM    614  O   PHE A 108     -38.943  17.814   5.414  1.00 57.72           O  
ATOM    615  CB  PHE A 108     -41.229  15.415   5.039  1.00 56.10           C  
ATOM    616  CG  PHE A 108     -41.437  15.884   6.444  1.00 56.70           C  
ATOM    617  CD1 PHE A 108     -42.473  16.768   6.750  1.00 56.93           C  
ATOM    618  CD2 PHE A 108     -40.577  15.471   7.469  1.00 55.28           C  
ATOM    619  CE1 PHE A 108     -42.646  17.219   8.067  1.00 56.74           C  
ATOM    620  CE2 PHE A 108     -40.747  15.912   8.776  1.00 53.32           C  
ATOM    621  CZ  PHE A 108     -41.774  16.773   9.084  1.00 55.07           C  
ATOM    622  N   ASP A 109     -38.226  15.738   4.826  1.00 58.73           N  
ATOM    623  CA  ASP A 109     -36.915  15.820   5.430  1.00 59.10           C  
ATOM    624  C   ASP A 109     -36.149  17.006   4.919  1.00 59.81           C  
ATOM    625  O   ASP A 109     -35.572  17.757   5.698  1.00 59.96           O  
ATOM    626  CB  ASP A 109     -36.149  14.557   5.096  1.00 58.99           C  
ATOM    627  CG  ASP A 109     -36.692  13.339   5.812  1.00 59.46           C  
ATOM    628  OD1 ASP A 109     -37.418  13.494   6.832  1.00 58.50           O  
ATOM    629  OD2 ASP A 109     -36.388  12.218   5.346  1.00 59.01           O  
ATOM    630  N   HIS A 110     -36.152  17.160   3.603  1.00 60.79           N  
ATOM    631  CA  HIS A 110     -35.423  18.205   2.953  1.00 62.26           C  
ATOM    632  C   HIS A 110     -35.818  19.589   3.450  1.00 63.10           C  
ATOM    633  O   HIS A 110     -34.967  20.403   3.772  1.00 63.53           O  
ATOM    634  CB  HIS A 110     -35.635  18.119   1.461  1.00 62.61           C  
ATOM    635  CG  HIS A 110     -34.899  19.174   0.695  1.00 65.46           C  
ATOM    636  ND1 HIS A 110     -33.736  18.913  -0.000  1.00 66.91           N  
ATOM    637  CD2 HIS A 110     -35.151  20.496   0.523  1.00 66.95           C  
ATOM    638  CE1 HIS A 110     -33.311  20.028  -0.573  1.00 67.30           C  
ATOM    639  NE2 HIS A 110     -34.152  21.002  -0.272  1.00 66.97           N  
ATOM    640  N   PHE A 111     -37.107  19.863   3.514  1.00 63.97           N  
ATOM    641  CA  PHE A 111     -37.539  21.161   3.960  1.00 64.92           C  
ATOM    642  C   PHE A 111     -37.547  21.273   5.457  1.00 65.55           C  
ATOM    643  O   PHE A 111     -37.509  22.381   5.985  1.00 66.66           O  
ATOM    644  CB  PHE A 111     -38.903  21.505   3.389  1.00 65.20           C  
ATOM    645  CG  PHE A 111     -38.880  21.733   1.910  1.00 67.04           C  
ATOM    646  CD1 PHE A 111     -39.504  20.834   1.040  1.00 69.35           C  
ATOM    647  CD2 PHE A 111     -38.207  22.843   1.369  1.00 68.04           C  
ATOM    648  CE1 PHE A 111     -39.467  21.052  -0.351  1.00 69.40           C  
ATOM    649  CE2 PHE A 111     -38.167  23.071  -0.015  1.00 66.65           C  
ATOM    650  CZ  PHE A 111     -38.797  22.180  -0.872  1.00 67.02           C  
ATOM    651  N   ALA A 112     -37.604  20.150   6.162  1.00 65.91           N  
ATOM    652  CA  ALA A 112     -37.406  20.192   7.604  1.00 66.03           C  
ATOM    653  C   ALA A 112     -35.991  20.715   7.833  1.00 66.49           C  
ATOM    654  O   ALA A 112     -35.774  21.619   8.635  1.00 66.18           O  
ATOM    655  CB  ALA A 112     -37.600  18.814   8.230  1.00 65.88           C  
ATOM    656  N   ALA A 113     -35.040  20.165   7.079  1.00 67.44           N  
ATOM    657  CA  ALA A 113     -33.644  20.580   7.155  1.00 68.32           C  
ATOM    658  C   ALA A 113     -33.455  22.055   6.741  1.00 69.08           C  
ATOM    659  O   ALA A 113     -32.872  22.848   7.496  1.00 69.18           O  
ATOM    660  CB  ALA A 113     -32.764  19.647   6.309  1.00 67.90           C  
ATOM    661  N   ARG A 114     -33.975  22.413   5.562  1.00 69.67           N  
ATOM    662  CA  ARG A 114     -33.729  23.726   4.948  1.00 70.16           C  
ATOM    663  C   ARG A 114     -35.014  24.572   4.880  1.00 69.75           C  
ATOM    664  O   ARG A 114     -35.609  24.742   3.806  1.00 69.23           O  
ATOM    665  CB  ARG A 114     -33.089  23.575   3.557  1.00 70.50           C  
ATOM    666  CG  ARG A 114     -32.233  22.316   3.345  1.00 72.93           C  
ATOM    667  CD  ARG A 114     -30.757  22.605   3.073  1.00 78.28           C  
ATOM    668  NE  ARG A 114     -29.863  22.159   4.159  1.00 83.16           N  
ATOM    669  CZ  ARG A 114     -29.414  20.905   4.347  1.00 84.63           C  
ATOM    670  NH1 ARG A 114     -29.776  19.910   3.527  1.00 84.03           N  
ATOM    671  NH2 ARG A 114     -28.599  20.641   5.374  1.00 84.44           N  
ATOM    672  N   PRO A 115     -35.433  25.122   6.041  1.00 69.90           N  
ATOM    673  CA  PRO A 115     -36.665  25.896   6.136  1.00 70.08           C  
ATOM    674  C   PRO A 115     -36.646  27.050   5.151  1.00 70.50           C  
ATOM    675  O   PRO A 115     -37.675  27.410   4.573  1.00 70.77           O  
ATOM    676  CB  PRO A 115     -36.630  26.446   7.568  1.00 69.66           C  
ATOM    677  CG  PRO A 115     -35.735  25.548   8.309  1.00 69.62           C  
ATOM    678  CD  PRO A 115     -34.720  25.073   7.335  1.00 69.82           C  
ATOM    679  N   ASP A 116     -35.464  27.608   4.951  1.00 70.91           N  
ATOM    680  CA  ASP A 116     -35.305  28.803   4.149  1.00 71.37           C  
ATOM    681  C   ASP A 116     -35.199  28.559   2.626  1.00 71.06           C  
ATOM    682  O   ASP A 116     -35.242  29.512   1.846  1.00 70.98           O  
ATOM    683  CB  ASP A 116     -34.126  29.607   4.688  1.00 71.65           C  
ATOM    684  CG  ASP A 116     -32.814  28.844   4.611  1.00 73.58           C  
ATOM    685  OD1 ASP A 116     -32.818  27.597   4.398  1.00 72.82           O  
ATOM    686  OD2 ASP A 116     -31.762  29.520   4.760  1.00 77.31           O  
ATOM    687  N   HIS A 117     -35.077  27.303   2.201  1.00 70.99           N  
ATOM    688  CA  HIS A 117     -35.200  26.986   0.778  1.00 71.17           C  
ATOM    689  C   HIS A 117     -36.638  27.269   0.440  1.00 69.83           C  
ATOM    690  O   HIS A 117     -36.953  27.862  -0.607  1.00 69.71           O  
ATOM    691  CB  HIS A 117     -34.873  25.511   0.486  1.00 72.40           C  
ATOM    692  CG  HIS A 117     -35.135  25.082  -0.940  1.00 77.25           C  
ATOM    693  ND1 HIS A 117     -34.373  24.118  -1.581  1.00 81.32           N  
ATOM    694  CD2 HIS A 117     -36.074  25.473  -1.845  1.00 81.05           C  
ATOM    695  CE1 HIS A 117     -34.829  23.936  -2.812  1.00 82.49           C  
ATOM    696  NE2 HIS A 117     -35.859  24.750  -3.000  1.00 83.08           N  
ATOM    697  N   TYR A 118     -37.507  26.849   1.350  1.00 68.34           N  
ATOM    698  CA  TYR A 118     -38.922  27.039   1.166  1.00 67.36           C  
ATOM    699  C   TYR A 118     -39.305  28.529   1.057  1.00 66.33           C  
ATOM    700  O   TYR A 118     -40.026  28.915   0.131  1.00 65.80           O  
ATOM    701  CB  TYR A 118     -39.707  26.343   2.271  1.00 67.39           C  
ATOM    702  CG  TYR A 118     -41.188  26.539   2.095  1.00 67.92           C  
ATOM    703  CD1 TYR A 118     -41.913  25.737   1.216  1.00 67.19           C  
ATOM    704  CD2 TYR A 118     -41.865  27.566   2.768  1.00 69.21           C  
ATOM    705  CE1 TYR A 118     -43.275  25.917   1.033  1.00 65.92           C  
ATOM    706  CE2 TYR A 118     -43.232  27.765   2.579  1.00 69.04           C  
ATOM    707  CZ  TYR A 118     -43.927  26.927   1.712  1.00 67.64           C  
ATOM    708  OH  TYR A 118     -45.279  27.101   1.533  1.00 68.74           O  
ATOM    709  N   ARG A 119     -38.817  29.344   1.996  1.00 65.41           N  
ATOM    710  CA  ARG A 119     -39.030  30.799   1.981  1.00 64.79           C  
ATOM    711  C   ARG A 119     -38.543  31.369   0.679  1.00 64.48           C  
ATOM    712  O   ARG A 119     -39.225  32.154   0.026  1.00 64.66           O  
ATOM    713  CB  ARG A 119     -38.213  31.486   3.056  1.00 64.78           C  
ATOM    714  CG  ARG A 119     -38.618  31.241   4.459  1.00 64.24           C  
ATOM    715  CD  ARG A 119     -38.348  32.510   5.211  1.00 64.34           C  
ATOM    716  NE  ARG A 119     -39.600  33.172   5.556  1.00 65.90           N  
ATOM    717  CZ  ARG A 119     -39.790  34.487   5.682  1.00 67.07           C  
ATOM    718  NH1 ARG A 119     -38.817  35.366   5.462  1.00 67.19           N  
ATOM    719  NH2 ARG A 119     -40.991  34.927   6.027  1.00 68.55           N  
ATOM    720  N   LEU A 120     -37.338  30.967   0.317  1.00 64.00           N  
ATOM    721  CA  LEU A 120     -36.689  31.490  -0.862  1.00 63.88           C  
ATOM    722  C   LEU A 120     -37.409  31.160  -2.179  1.00 63.70           C  
ATOM    723  O   LEU A 120     -37.509  32.043  -3.042  1.00 63.53           O  
ATOM    724  CB  LEU A 120     -35.206  31.111  -0.875  1.00 63.85           C  
ATOM    725  CG  LEU A 120     -34.367  31.453  -2.088  1.00 63.44           C  
ATOM    726  CD1 LEU A 120     -32.940  31.543  -1.678  1.00 63.80           C  
ATOM    727  CD2 LEU A 120     -34.532  30.343  -3.099  1.00 64.63           C  
ATOM    728  N   ILE A 121     -37.930  29.948  -2.358  1.00 63.20           N  
ATOM    729  CA  ILE A 121     -38.702  29.777  -3.591  1.00 63.81           C  
ATOM    730  C   ILE A 121     -40.065  30.444  -3.567  1.00 63.97           C  
ATOM    731  O   ILE A 121     -40.538  30.931  -4.604  1.00 64.00           O  
ATOM    732  CB  ILE A 121     -38.804  28.334  -4.152  1.00 63.89           C  
ATOM    733  CG1 ILE A 121     -39.454  27.386  -3.139  1.00 63.41           C  
ATOM    734  CG2 ILE A 121     -37.423  27.900  -4.797  1.00 63.62           C  
ATOM    735  CD1 ILE A 121     -39.366  25.911  -3.518  1.00 64.05           C  
ATOM    736  N   THR A 122     -40.680  30.489  -2.387  1.00 64.14           N  
ATOM    737  CA  THR A 122     -41.980  31.160  -2.232  1.00 64.08           C  
ATOM    738  C   THR A 122     -41.884  32.651  -2.580  1.00 64.05           C  
ATOM    739  O   THR A 122     -42.735  33.176  -3.278  1.00 64.00           O  
ATOM    740  CB  THR A 122     -42.544  31.002  -0.809  1.00 64.21           C  
ATOM    741  OG1 THR A 122     -42.438  29.634  -0.403  1.00 64.34           O  
ATOM    742  CG2 THR A 122     -43.997  31.445  -0.752  1.00 63.20           C  
ATOM    743  N   TRP A 123     -40.848  33.330  -2.101  1.00 64.04           N  
ATOM    744  CA  TRP A 123     -40.617  34.701  -2.512  1.00 64.60           C  
ATOM    745  C   TRP A 123     -40.608  34.815  -4.025  1.00 65.19           C  
ATOM    746  O   TRP A 123     -41.194  35.733  -4.585  1.00 65.62           O  
ATOM    747  CB  TRP A 123     -39.279  35.165  -2.019  1.00 64.46           C  
ATOM    748  CG  TRP A 123     -39.222  35.524  -0.609  1.00 64.89           C  
ATOM    749  CD1 TRP A 123     -38.596  34.828   0.379  1.00 65.40           C  
ATOM    750  CD2 TRP A 123     -39.760  36.708   0.007  1.00 65.50           C  
ATOM    751  NE1 TRP A 123     -38.709  35.501   1.581  1.00 66.28           N  
ATOM    752  CE2 TRP A 123     -39.412  36.660   1.380  1.00 65.74           C  
ATOM    753  CE3 TRP A 123     -40.492  37.807  -0.465  1.00 65.11           C  
ATOM    754  CZ2 TRP A 123     -39.777  37.663   2.283  1.00 65.07           C  
ATOM    755  CZ3 TRP A 123     -40.853  38.804   0.433  1.00 64.17           C  
ATOM    756  CH2 TRP A 123     -40.498  38.719   1.793  1.00 64.53           C  
ATOM    757  N   GLY A 124     -39.935  33.872  -4.679  1.00 65.67           N  
ATOM    758  CA  GLY A 124     -39.810  33.870  -6.125  1.00 65.94           C  
ATOM    759  C   GLY A 124     -41.114  33.628  -6.851  1.00 66.34           C  
ATOM    760  O   GLY A 124     -41.330  34.187  -7.922  1.00 66.48           O  
ATOM    761  N   ARG A 125     -41.985  32.792  -6.301  1.00 66.68           N  
ATOM    762  CA  ARG A 125     -43.265  32.546  -6.974  1.00 67.83           C  
ATOM    763  C   ARG A 125     -44.079  33.829  -7.047  1.00 68.18           C  
ATOM    764  O   ARG A 125     -44.554  34.214  -8.115  1.00 68.47           O  
ATOM    765  CB  ARG A 125     -44.059  31.450  -6.282  1.00 68.04           C  
ATOM    766  CG  ARG A 125     -43.218  30.237  -5.997  1.00 69.66           C  
ATOM    767  CD  ARG A 125     -44.045  29.024  -5.802  1.00 72.86           C  
ATOM    768  NE  ARG A 125     -43.313  28.059  -4.987  1.00 77.17           N  
ATOM    769  CZ  ARG A 125     -43.640  26.776  -4.843  1.00 77.66           C  
ATOM    770  NH1 ARG A 125     -44.691  26.266  -5.476  1.00 78.14           N  
ATOM    771  NH2 ARG A 125     -42.892  25.995  -4.071  1.00 77.93           N  
ATOM    772  N   LEU A 126     -44.170  34.505  -5.905  1.00 68.55           N  
ATOM    773  CA  LEU A 126     -44.863  35.780  -5.766  1.00 68.85           C  
ATOM    774  C   LEU A 126     -44.192  36.971  -6.444  1.00 69.19           C  
ATOM    775  O   LEU A 126     -44.864  37.800  -7.053  1.00 68.95           O  
ATOM    776  CB  LEU A 126     -45.048  36.112  -4.288  1.00 68.79           C  
ATOM    777  CG  LEU A 126     -45.948  35.189  -3.462  1.00 69.11           C  
ATOM    778  CD1 LEU A 126     -45.605  35.378  -2.002  1.00 69.11           C  
ATOM    779  CD2 LEU A 126     -47.445  35.427  -3.704  1.00 68.72           C  
ATOM    780  N   GLU A 127     -42.877  37.084  -6.316  1.00 69.87           N  
ATOM    781  CA  GLU A 127     -42.193  38.254  -6.862  1.00 70.44           C  
ATOM    782  C   GLU A 127     -42.043  38.216  -8.409  1.00 71.55           C  
ATOM    783  O   GLU A 127     -42.143  39.251  -9.056  1.00 72.27           O  
ATOM    784  CB  GLU A 127     -40.857  38.509  -6.157  1.00 69.73           C  
ATOM    785  CG  GLU A 127     -40.975  38.803  -4.690  1.00 68.27           C  
ATOM    786  CD  GLU A 127     -39.822  39.627  -4.156  1.00 68.34           C  
ATOM    787  OE1 GLU A 127     -39.490  40.643  -4.801  1.00 69.63           O  
ATOM    788  OE2 GLU A 127     -39.254  39.288  -3.090  1.00 66.72           O  
ATOM    789  N   LEU A 128     -41.839  37.038  -8.998  1.00 72.39           N  
ATOM    790  CA  LEU A 128     -41.675  36.920 -10.452  1.00 73.13           C  
ATOM    791  C   LEU A 128     -42.971  36.478 -11.155  1.00 73.71           C  
ATOM    792  O   LEU A 128     -43.581  37.280 -11.883  1.00 73.82           O  
ATOM    793  CB  LEU A 128     -40.496  36.001 -10.783  1.00 72.95           C  
ATOM    794  CG  LEU A 128     -39.245  36.393  -9.975  1.00 73.66           C  
ATOM    795  CD1 LEU A 128     -38.393  35.167  -9.645  1.00 73.47           C  
ATOM    796  CD2 LEU A 128     -38.405  37.528 -10.627  1.00 72.59           C  
ATOM    797  N   ALA A 129     -43.388  35.225 -10.925  1.00 74.16           N  
ATOM    798  CA  ALA A 129     -44.631  34.654 -11.511  1.00 74.63           C  
ATOM    799  C   ALA A 129     -44.983  35.067 -12.969  1.00 74.73           C  
ATOM    800  O   ALA A 129     -44.189  34.910 -13.912  1.00 74.31           O  
ATOM    801  N   PRO A 138     -36.041  23.551 -17.652  1.00 77.88           N  
ATOM    802  CA  PRO A 138     -35.119  23.221 -16.563  1.00 77.77           C  
ATOM    803  C   PRO A 138     -35.790  22.436 -15.411  1.00 77.77           C  
ATOM    804  O   PRO A 138     -35.531  21.227 -15.244  1.00 77.51           O  
ATOM    805  CB  PRO A 138     -34.621  24.599 -16.111  1.00 77.78           C  
ATOM    806  CG  PRO A 138     -34.625  25.432 -17.436  1.00 78.22           C  
ATOM    807  CD  PRO A 138     -35.580  24.729 -18.414  1.00 77.97           C  
ATOM    808  N   LEU A 139     -36.635  23.099 -14.616  1.00 77.47           N  
ATOM    809  CA  LEU A 139     -37.386  22.370 -13.585  1.00 76.90           C  
ATOM    810  C   LEU A 139     -38.488  21.560 -14.269  1.00 76.41           C  
ATOM    811  O   LEU A 139     -38.638  20.355 -14.025  1.00 76.41           O  
ATOM    812  CB  LEU A 139     -37.964  23.318 -12.535  1.00 76.89           C  
ATOM    813  CG  LEU A 139     -38.794  22.705 -11.392  1.00 77.15           C  
ATOM    814  CD1 LEU A 139     -38.038  21.647 -10.591  1.00 75.81           C  
ATOM    815  CD2 LEU A 139     -39.323  23.792 -10.457  1.00 77.08           C  
ATOM    816  N   GLN A 140     -39.233  22.253 -15.135  1.00 75.56           N  
ATOM    817  CA  GLN A 140     -40.168  21.662 -16.099  1.00 74.41           C  
ATOM    818  C   GLN A 140     -39.701  20.317 -16.665  1.00 73.33           C  
ATOM    819  O   GLN A 140     -40.495  19.374 -16.826  1.00 72.96           O  
ATOM    820  CB  GLN A 140     -40.409  22.654 -17.248  1.00 74.47           C  
ATOM    821  CG  GLN A 140     -41.212  23.889 -16.851  1.00 74.60           C  
ATOM    822  CD  GLN A 140     -42.614  23.546 -16.338  1.00 75.72           C  
ATOM    823  OE1 GLN A 140     -43.341  22.753 -16.945  1.00 75.54           O  
ATOM    824  NE2 GLN A 140     -42.993  24.148 -15.216  1.00 75.54           N  
ATOM    825  N   ALA A 141     -38.408  20.249 -16.963  1.00 72.01           N  
ATOM    826  CA  ALA A 141     -37.793  19.035 -17.445  1.00 70.95           C  
ATOM    827  C   ALA A 141     -37.973  17.929 -16.427  1.00 69.95           C  
ATOM    828  O   ALA A 141     -38.631  16.942 -16.715  1.00 70.24           O  
ATOM    829  CB  ALA A 141     -36.315  19.250 -17.769  1.00 71.23           C  
ATOM    830  N   THR A 142     -37.435  18.080 -15.229  1.00 68.55           N  
ATOM    831  CA  THR A 142     -37.539  16.958 -14.301  1.00 67.61           C  
ATOM    832  C   THR A 142     -39.011  16.560 -14.037  1.00 66.43           C  
ATOM    833  O   THR A 142     -39.316  15.372 -13.942  1.00 66.42           O  
ATOM    834  CB  THR A 142     -36.653  17.119 -13.004  1.00 68.10           C  
ATOM    835  OG1 THR A 142     -37.435  17.591 -11.895  1.00 67.58           O  
ATOM    836  CG2 THR A 142     -35.425  18.042 -13.271  1.00 68.03           C  
ATOM    837  N   ILE A 143     -39.909  17.545 -13.978  1.00 64.83           N  
ATOM    838  CA  ILE A 143     -41.357  17.309 -13.884  1.00 63.59           C  
ATOM    839  C   ILE A 143     -41.882  16.451 -15.048  1.00 63.11           C  
ATOM    840  O   ILE A 143     -42.480  15.402 -14.827  1.00 62.72           O  
ATOM    841  CB  ILE A 143     -42.154  18.641 -13.832  1.00 63.74           C  
ATOM    842  CG1 ILE A 143     -41.906  19.376 -12.517  1.00 63.11           C  
ATOM    843  CG2 ILE A 143     -43.666  18.417 -14.062  1.00 63.25           C  
ATOM    844  CD1 ILE A 143     -42.068  20.859 -12.649  1.00 64.05           C  
ATOM    845  N   ALA A 144     -41.656  16.893 -16.286  1.00 62.26           N  
ATOM    846  CA  ALA A 144     -42.020  16.078 -17.439  1.00 61.19           C  
ATOM    847  C   ALA A 144     -41.472  14.663 -17.288  1.00 60.60           C  
ATOM    848  O   ALA A 144     -42.145  13.687 -17.657  1.00 60.84           O  
ATOM    849  CB  ALA A 144     -41.546  16.701 -18.719  1.00 60.80           C  
ATOM    850  N   GLY A 145     -40.277  14.551 -16.713  1.00 59.86           N  
ATOM    851  CA  GLY A 145     -39.650  13.249 -16.478  1.00 59.51           C  
ATOM    852  C   GLY A 145     -40.389  12.413 -15.438  1.00 59.39           C  
ATOM    853  O   GLY A 145     -40.664  11.224 -15.646  1.00 59.03           O  
ATOM    854  N   LYS A 146     -40.713  13.037 -14.311  1.00 59.02           N  
ATOM    855  CA  LYS A 146     -41.420  12.344 -13.234  1.00 58.91           C  
ATOM    856  C   LYS A 146     -42.833  11.915 -13.622  1.00 58.71           C  
ATOM    857  O   LYS A 146     -43.312  10.881 -13.179  1.00 58.61           O  
ATOM    858  CB  LYS A 146     -41.453  13.200 -11.973  1.00 58.43           C  
ATOM    859  CG  LYS A 146     -40.096  13.411 -11.365  1.00 59.29           C  
ATOM    860  CD  LYS A 146     -40.208  14.205 -10.103  1.00 59.69           C  
ATOM    861  CE  LYS A 146     -38.882  14.717  -9.679  1.00 60.57           C  
ATOM    862  NZ  LYS A 146     -39.033  15.271  -8.297  1.00 63.63           N  
ATOM    863  N   LEU A 147     -43.502  12.715 -14.444  1.00 58.80           N  
ATOM    864  CA  LEU A 147     -44.815  12.343 -14.934  1.00 58.94           C  
ATOM    865  C   LEU A 147     -44.673  11.125 -15.824  1.00 59.06           C  
ATOM    866  O   LEU A 147     -45.519  10.240 -15.810  1.00 59.17           O  
ATOM    867  CB  LEU A 147     -45.476  13.494 -15.689  1.00 58.98           C  
ATOM    868  CG  LEU A 147     -45.816  14.731 -14.852  1.00 59.21           C  
ATOM    869  CD1 LEU A 147     -46.185  15.905 -15.752  1.00 58.06           C  
ATOM    870  CD2 LEU A 147     -46.920  14.438 -13.834  1.00 58.80           C  
ATOM    871  N   ASP A 148     -43.591  11.054 -16.586  1.00 59.05           N  
ATOM    872  CA  ASP A 148     -43.347   9.839 -17.326  1.00 59.25           C  
ATOM    873  C   ASP A 148     -43.078   8.639 -16.421  1.00 58.93           C  
ATOM    874  O   ASP A 148     -43.587   7.560 -16.666  1.00 58.64           O  
ATOM    875  CB  ASP A 148     -42.273  10.046 -18.380  1.00 59.63           C  
ATOM    876  CG  ASP A 148     -42.874  10.245 -19.750  1.00 61.38           C  
ATOM    877  OD1 ASP A 148     -43.566  11.269 -19.952  1.00 62.75           O  
ATOM    878  OD2 ASP A 148     -42.697   9.351 -20.613  1.00 64.49           O  
ATOM    879  N   LYS A 149     -42.321   8.856 -15.353  1.00 59.32           N  
ATOM    880  CA  LYS A 149     -42.002   7.821 -14.373  1.00 59.76           C  
ATOM    881  C   LYS A 149     -43.304   7.293 -13.751  1.00 59.73           C  
ATOM    882  O   LYS A 149     -43.493   6.088 -13.586  1.00 60.51           O  
ATOM    883  CB  LYS A 149     -41.064   8.412 -13.307  1.00 60.04           C  
ATOM    884  CG  LYS A 149     -39.818   7.581 -12.925  1.00 61.53           C  
ATOM    885  CD  LYS A 149     -38.527   8.480 -12.932  1.00 63.76           C  
ATOM    886  CE  LYS A 149     -37.583   8.340 -11.699  1.00 63.24           C  
ATOM    887  NZ  LYS A 149     -37.164   6.949 -11.357  1.00 63.39           N  
ATOM    888  N   LEU A 150     -44.229   8.189 -13.442  1.00 59.52           N  
ATOM    889  CA  LEU A 150     -45.527   7.764 -12.933  1.00 59.29           C  
ATOM    890  C   LEU A 150     -46.376   7.065 -13.999  1.00 59.51           C  
ATOM    891  O   LEU A 150     -47.001   6.060 -13.694  1.00 59.80           O  
ATOM    892  CB  LEU A 150     -46.273   8.934 -12.290  1.00 59.10           C  
ATOM    893  CG  LEU A 150     -45.537   9.594 -11.104  1.00 59.07           C  
ATOM    894  CD1 LEU A 150     -45.857  11.080 -10.989  1.00 58.51           C  
ATOM    895  CD2 LEU A 150     -45.801   8.877  -9.782  1.00 57.24           C  
ATOM    896  N   ARG A 151     -46.390   7.576 -15.235  1.00 59.62           N  
ATOM    897  CA  ARG A 151     -47.092   6.913 -16.332  1.00 60.30           C  
ATOM    898  C   ARG A 151     -46.628   5.472 -16.378  1.00 60.99           C  
ATOM    899  O   ARG A 151     -47.428   4.557 -16.559  1.00 60.93           O  
ATOM    900  CB  ARG A 151     -46.824   7.597 -17.677  1.00 60.21           C  
ATOM    901  CG  ARG A 151     -47.926   8.555 -18.127  1.00 60.48           C  
ATOM    902  CD  ARG A 151     -47.414   9.717 -18.992  1.00 60.31           C  
ATOM    903  NE  ARG A 151     -47.968  10.985 -18.490  1.00 61.00           N  
ATOM    904  CZ  ARG A 151     -47.462  12.212 -18.695  1.00 60.66           C  
ATOM    905  NH1 ARG A 151     -46.360  12.407 -19.420  1.00 59.61           N  
ATOM    906  NH2 ARG A 151     -48.071  13.267 -18.158  1.00 59.56           N  
ATOM    907  N   ASP A 152     -45.329   5.281 -16.163  1.00 61.95           N  
ATOM    908  CA  ASP A 152     -44.712   3.954 -16.198  1.00 62.85           C  
ATOM    909  C   ASP A 152     -45.157   3.085 -15.051  1.00 63.19           C  
ATOM    910  O   ASP A 152     -45.486   1.927 -15.255  1.00 63.55           O  
ATOM    911  CB  ASP A 152     -43.198   4.068 -16.172  1.00 62.84           C  
ATOM    912  CG  ASP A 152     -42.644   4.632 -17.454  1.00 64.23           C  
ATOM    913  OD1 ASP A 152     -43.396   4.652 -18.466  1.00 65.00           O  
ATOM    914  OD2 ASP A 152     -41.458   5.054 -17.449  1.00 64.73           O  
ATOM    915  N   ALA A 153     -45.148   3.645 -13.843  1.00 63.41           N  
ATOM    916  CA  ALA A 153     -45.647   2.940 -12.668  1.00 63.36           C  
ATOM    917  C   ALA A 153     -47.039   2.367 -12.922  1.00 63.27           C  
ATOM    918  O   ALA A 153     -47.316   1.228 -12.561  1.00 63.01           O  
ATOM    919  CB  ALA A 153     -45.665   3.875 -11.480  1.00 63.48           C  
ATOM    920  N   GLN A 154     -47.896   3.163 -13.561  1.00 63.51           N  
ATOM    921  CA  GLN A 154     -49.279   2.786 -13.815  1.00 63.74           C  
ATOM    922  C   GLN A 154     -49.339   1.632 -14.786  1.00 64.25           C  
ATOM    923  O   GLN A 154     -50.030   0.649 -14.516  1.00 64.53           O  
ATOM    924  CB  GLN A 154     -50.080   3.975 -14.327  1.00 63.42           C  
ATOM    925  CG  GLN A 154     -50.290   5.006 -13.236  1.00 64.06           C  
ATOM    926  CD  GLN A 154     -51.163   6.176 -13.644  1.00 64.57           C  
ATOM    927  OE1 GLN A 154     -50.854   6.895 -14.592  1.00 64.44           O  
ATOM    928  NE2 GLN A 154     -52.247   6.396 -12.901  1.00 64.88           N  
ATOM    929  N   ARG A 155     -48.585   1.743 -15.886  1.00 64.36           N  
ATOM    930  CA  ARG A 155     -48.474   0.694 -16.901  1.00 64.46           C  
ATOM    931  C   ARG A 155     -47.980  -0.661 -16.356  1.00 64.35           C  
ATOM    932  O   ARG A 155     -48.450  -1.723 -16.805  1.00 64.72           O  
ATOM    933  CB  ARG A 155     -47.598   1.166 -18.075  1.00 64.34           C  
ATOM    934  CG  ARG A 155     -47.374   0.137 -19.240  1.00 64.71           C  
ATOM    935  CD  ARG A 155     -46.672   0.767 -20.474  1.00 65.88           C  
ATOM    936  NE  ARG A 155     -45.968   2.021 -20.135  1.00 70.33           N  
ATOM    937  CZ  ARG A 155     -46.415   3.256 -20.400  1.00 71.49           C  
ATOM    938  NH1 ARG A 155     -47.566   3.436 -21.048  1.00 73.33           N  
ATOM    939  NH2 ARG A 155     -45.708   4.322 -20.024  1.00 71.03           N  
ATOM    940  N   ILE A 156     -47.041  -0.655 -15.410  1.00 63.86           N  
ATOM    941  CA  ILE A 156     -46.574  -1.931 -14.870  1.00 63.47           C  
ATOM    942  C   ILE A 156     -47.350  -2.318 -13.616  1.00 63.32           C  
ATOM    943  O   ILE A 156     -46.987  -3.252 -12.899  1.00 63.42           O  
ATOM    944  CB  ILE A 156     -45.024  -2.050 -14.754  1.00 63.39           C  
ATOM    945  CG1 ILE A 156     -44.453  -1.239 -13.617  1.00 64.43           C  
ATOM    946  CG2 ILE A 156     -44.335  -1.591 -16.018  1.00 63.21           C  
ATOM    947  CD1 ILE A 156     -42.973  -1.531 -13.433  1.00 65.78           C  
ATOM    948  N   GLY A 157     -48.439  -1.589 -13.385  1.00 63.00           N  
ATOM    949  CA  GLY A 157     -49.474  -1.982 -12.436  1.00 62.89           C  
ATOM    950  C   GLY A 157     -49.162  -1.662 -10.992  1.00 62.65           C  
ATOM    951  O   GLY A 157     -49.555  -2.395 -10.088  1.00 62.70           O  
ATOM    952  N   LEU A 158     -48.483  -0.545 -10.776  1.00 62.41           N  
ATOM    953  CA  LEU A 158     -47.900  -0.244  -9.486  1.00 62.20           C  
ATOM    954  C   LEU A 158     -48.568   0.937  -8.829  1.00 61.96           C  
ATOM    955  O   LEU A 158     -48.256   1.280  -7.693  1.00 62.40           O  
ATOM    956  CB  LEU A 158     -46.422   0.076  -9.679  1.00 62.46           C  
ATOM    957  CG  LEU A 158     -45.436  -0.760  -8.870  1.00 63.35           C  
ATOM    958  CD1 LEU A 158     -45.665  -2.310  -9.024  1.00 63.59           C  
ATOM    959  CD2 LEU A 158     -44.043  -0.350  -9.288  1.00 63.80           C  
ATOM    960  N   LEU A 159     -49.475   1.571  -9.561  1.00 61.38           N  
ATOM    961  CA  LEU A 159     -50.144   2.788  -9.131  1.00 60.64           C  
ATOM    962  C   LEU A 159     -51.472   2.811  -9.897  1.00 60.69           C  
ATOM    963  O   LEU A 159     -51.497   2.732 -11.122  1.00 61.17           O  
ATOM    964  CB  LEU A 159     -49.260   3.998  -9.457  1.00 60.07           C  
ATOM    965  CG  LEU A 159     -49.781   5.430  -9.504  1.00 59.47           C  
ATOM    966  CD1 LEU A 159     -49.836   6.048  -8.142  1.00 58.39           C  
ATOM    967  CD2 LEU A 159     -48.858   6.221 -10.360  1.00 59.58           C  
ATOM    968  N   ASP A 160     -52.573   2.868  -9.162  1.00 60.31           N  
ATOM    969  CA  ASP A 160     -53.902   2.841  -9.736  1.00 60.08           C  
ATOM    970  C   ASP A 160     -53.983   3.625 -11.062  1.00 59.41           C  
ATOM    971  O   ASP A 160     -53.672   4.820 -11.090  1.00 59.34           O  
ATOM    972  CB  ASP A 160     -54.844   3.430  -8.703  1.00 60.71           C  
ATOM    973  CG  ASP A 160     -56.283   3.102  -8.960  1.00 62.60           C  
ATOM    974  OD1 ASP A 160     -56.703   3.062 -10.147  1.00 65.04           O  
ATOM    975  OD2 ASP A 160     -56.999   2.908  -7.947  1.00 64.93           O  
ATOM    976  N   PRO A 161     -54.405   2.959 -12.165  1.00 58.72           N  
ATOM    977  CA  PRO A 161     -54.343   3.611 -13.484  1.00 58.13           C  
ATOM    978  C   PRO A 161     -55.380   4.722 -13.651  1.00 57.62           C  
ATOM    979  O   PRO A 161     -55.349   5.451 -14.648  1.00 57.49           O  
ATOM    980  CB  PRO A 161     -54.613   2.457 -14.464  1.00 57.88           C  
ATOM    981  CG  PRO A 161     -55.442   1.508 -13.696  1.00 57.61           C  
ATOM    982  CD  PRO A 161     -54.960   1.592 -12.263  1.00 58.60           C  
ATOM    983  N   ALA A 162     -56.281   4.834 -12.675  1.00 56.86           N  
ATOM    984  CA  ALA A 162     -57.327   5.842 -12.669  1.00 56.12           C  
ATOM    985  C   ALA A 162     -56.804   7.249 -12.384  1.00 55.99           C  
ATOM    986  O   ALA A 162     -57.369   8.186 -12.878  1.00 56.28           O  
ATOM    987  CB  ALA A 162     -58.418   5.458 -11.683  1.00 55.80           C  
ATOM    988  N   TRP A 163     -55.733   7.402 -11.601  1.00 56.18           N  
ATOM    989  CA  TRP A 163     -55.175   8.731 -11.277  1.00 56.35           C  
ATOM    990  C   TRP A 163     -54.538   9.410 -12.469  1.00 56.27           C  
ATOM    991  O   TRP A 163     -53.889   8.770 -13.282  1.00 56.42           O  
ATOM    992  CB  TRP A 163     -54.067   8.645 -10.231  1.00 56.65           C  
ATOM    993  CG  TRP A 163     -54.485   8.189  -8.907  1.00 57.10           C  
ATOM    994  CD1 TRP A 163     -54.303   6.949  -8.385  1.00 57.78           C  
ATOM    995  CD2 TRP A 163     -55.156   8.958  -7.904  1.00 57.71           C  
ATOM    996  NE1 TRP A 163     -54.826   6.883  -7.112  1.00 57.92           N  
ATOM    997  CE2 TRP A 163     -55.352   8.104  -6.785  1.00 58.22           C  
ATOM    998  CE3 TRP A 163     -55.612  10.281  -7.837  1.00 56.93           C  
ATOM    999  CZ2 TRP A 163     -55.986   8.532  -5.606  1.00 57.99           C  
ATOM   1000  CZ3 TRP A 163     -56.242  10.708  -6.668  1.00 57.49           C  
ATOM   1001  CH2 TRP A 163     -56.429   9.831  -5.566  1.00 57.74           C  
ATOM   1002  N   ASP A 164     -54.670  10.720 -12.553  1.00 56.11           N  
ATOM   1003  CA  ASP A 164     -53.827  11.429 -13.481  1.00 55.83           C  
ATOM   1004  C   ASP A 164     -52.483  11.690 -12.812  1.00 55.38           C  
ATOM   1005  O   ASP A 164     -52.411  12.277 -11.739  1.00 54.41           O  
ATOM   1006  CB  ASP A 164     -54.448  12.738 -13.930  1.00 56.27           C  
ATOM   1007  CG  ASP A 164     -53.878  13.231 -15.240  1.00 56.73           C  
ATOM   1008  OD1 ASP A 164     -52.644  13.454 -15.349  1.00 56.36           O  
ATOM   1009  OD2 ASP A 164     -54.696  13.398 -16.164  1.00 59.81           O  
ATOM   1010  N   PRO A 165     -51.404  11.240 -13.463  1.00 55.20           N  
ATOM   1011  CA  PRO A 165     -50.058  11.515 -13.015  1.00 55.02           C  
ATOM   1012  C   PRO A 165     -49.932  12.954 -12.518  1.00 54.85           C  
ATOM   1013  O   PRO A 165     -49.432  13.191 -11.418  1.00 54.51           O  
ATOM   1014  CB  PRO A 165     -49.255  11.321 -14.299  1.00 54.89           C  
ATOM   1015  CG  PRO A 165     -49.955  10.226 -14.966  1.00 55.01           C  
ATOM   1016  CD  PRO A 165     -51.409  10.422 -14.689  1.00 54.77           C  
ATOM   1017  N   VAL A 166     -50.398  13.890 -13.347  1.00 54.57           N  
ATOM   1018  CA  VAL A 166     -50.416  15.313 -13.039  1.00 54.16           C  
ATOM   1019  C   VAL A 166     -50.941  15.565 -11.618  1.00 54.04           C  
ATOM   1020  O   VAL A 166     -50.317  16.286 -10.840  1.00 53.79           O  
ATOM   1021  CB  VAL A 166     -51.221  16.102 -14.128  1.00 54.11           C  
ATOM   1022  CG1 VAL A 166     -51.450  17.536 -13.739  1.00 53.49           C  
ATOM   1023  CG2 VAL A 166     -50.475  16.078 -15.440  1.00 54.04           C  
ATOM   1024  N   ASP A 167     -52.071  14.957 -11.278  1.00 53.86           N  
ATOM   1025  CA  ASP A 167     -52.636  15.126  -9.940  1.00 53.92           C  
ATOM   1026  C   ASP A 167     -51.757  14.463  -8.856  1.00 53.52           C  
ATOM   1027  O   ASP A 167     -51.561  15.033  -7.767  1.00 54.14           O  
ATOM   1028  CB  ASP A 167     -54.088  14.616  -9.880  1.00 54.06           C  
ATOM   1029  CG  ASP A 167     -55.047  15.429 -10.781  1.00 56.52           C  
ATOM   1030  OD1 ASP A 167     -55.148  16.668 -10.601  1.00 59.41           O  
ATOM   1031  OD2 ASP A 167     -55.719  14.830 -11.664  1.00 58.04           O  
ATOM   1032  N   VAL A 168     -51.222  13.280  -9.157  1.00 52.43           N  
ATOM   1033  CA  VAL A 168     -50.423  12.507  -8.206  1.00 50.94           C  
ATOM   1034  C   VAL A 168     -49.180  13.299  -7.783  1.00 50.42           C  
ATOM   1035  O   VAL A 168     -48.902  13.465  -6.585  1.00 50.12           O  
ATOM   1036  CB  VAL A 168     -50.022  11.121  -8.804  1.00 50.92           C  
ATOM   1037  CG1 VAL A 168     -49.184  10.328  -7.823  1.00 49.84           C  
ATOM   1038  CG2 VAL A 168     -51.245  10.339  -9.218  1.00 49.51           C  
ATOM   1039  N   LEU A 169     -48.459  13.802  -8.775  1.00 49.88           N  
ATOM   1040  CA  LEU A 169     -47.243  14.566  -8.539  1.00 50.29           C  
ATOM   1041  C   LEU A 169     -47.500  15.821  -7.699  1.00 51.47           C  
ATOM   1042  O   LEU A 169     -46.914  15.991  -6.627  1.00 51.95           O  
ATOM   1043  CB  LEU A 169     -46.592  14.931  -9.866  1.00 49.82           C  
ATOM   1044  CG  LEU A 169     -45.262  15.658  -9.752  1.00 49.82           C  
ATOM   1045  CD1 LEU A 169     -44.207  14.680  -9.283  1.00 49.98           C  
ATOM   1046  CD2 LEU A 169     -44.850  16.357 -11.058  1.00 49.56           C  
ATOM   1047  N   ALA A 170     -48.399  16.683  -8.186  1.00 52.43           N  
ATOM   1048  CA  ALA A 170     -48.797  17.914  -7.500  1.00 53.02           C  
ATOM   1049  C   ALA A 170     -49.185  17.694  -6.041  1.00 53.61           C  
ATOM   1050  O   ALA A 170     -48.623  18.327  -5.141  1.00 53.29           O  
ATOM   1051  CB  ALA A 170     -49.930  18.558  -8.242  1.00 52.53           C  
ATOM   1052  N   LEU A 171     -50.148  16.801  -5.834  1.00 54.58           N  
ATOM   1053  CA  LEU A 171     -50.619  16.442  -4.501  1.00 56.40           C  
ATOM   1054  C   LEU A 171     -49.492  16.060  -3.544  1.00 57.38           C  
ATOM   1055  O   LEU A 171     -49.336  16.652  -2.466  1.00 57.63           O  
ATOM   1056  CB  LEU A 171     -51.626  15.287  -4.568  1.00 56.56           C  
ATOM   1057  CG  LEU A 171     -52.962  15.639  -5.243  1.00 56.39           C  
ATOM   1058  CD1 LEU A 171     -53.697  14.376  -5.705  1.00 53.09           C  
ATOM   1059  CD2 LEU A 171     -53.849  16.560  -4.363  1.00 54.73           C  
ATOM   1060  N   ILE A 172     -48.698  15.079  -3.943  1.00 58.08           N  
ATOM   1061  CA  ILE A 172     -47.661  14.595  -3.059  1.00 58.91           C  
ATOM   1062  C   ILE A 172     -46.636  15.702  -2.663  1.00 59.04           C  
ATOM   1063  O   ILE A 172     -46.277  15.846  -1.483  1.00 59.26           O  
ATOM   1064  CB  ILE A 172     -47.017  13.334  -3.636  1.00 59.20           C  
ATOM   1065  CG1 ILE A 172     -48.085  12.239  -3.742  1.00 59.45           C  
ATOM   1066  CG2 ILE A 172     -45.855  12.880  -2.742  1.00 59.99           C  
ATOM   1067  CD1 ILE A 172     -47.632  11.001  -4.464  1.00 59.84           C  
ATOM   1068  N   ASN A 173     -46.185  16.476  -3.642  1.00 58.54           N  
ATOM   1069  CA  ASN A 173     -45.468  17.696  -3.371  1.00 58.53           C  
ATOM   1070  C   ASN A 173     -46.124  18.665  -2.377  1.00 58.64           C  
ATOM   1071  O   ASN A 173     -45.438  19.224  -1.515  1.00 58.08           O  
ATOM   1072  CB  ASN A 173     -45.238  18.406  -4.672  1.00 58.77           C  
ATOM   1073  CG  ASN A 173     -44.059  17.880  -5.378  1.00 59.90           C  
ATOM   1074  OD1 ASN A 173     -42.977  18.453  -5.260  1.00 63.43           O  
ATOM   1075  ND2 ASN A 173     -44.215  16.755  -6.073  1.00 59.85           N  
ATOM   1076  N   GLN A 174     -47.432  18.878  -2.515  1.00 59.11           N  
ATOM   1077  CA  GLN A 174     -48.167  19.746  -1.591  1.00 60.11           C  
ATOM   1078  C   GLN A 174     -48.082  19.232  -0.183  1.00 61.40           C  
ATOM   1079  O   GLN A 174     -47.510  19.898   0.660  1.00 61.38           O  
ATOM   1080  CB  GLN A 174     -49.637  19.856  -1.953  1.00 58.82           C  
ATOM   1081  CG  GLN A 174     -49.960  21.090  -2.651  1.00 58.27           C  
ATOM   1082  CD  GLN A 174     -49.677  22.359  -1.865  1.00 55.90           C  
ATOM   1083  OE1 GLN A 174     -50.294  22.624  -0.843  1.00 55.67           O  
ATOM   1084  NE2 GLN A 174     -48.778  23.178  -2.385  1.00 54.98           N  
ATOM   1085  N   ILE A 175     -48.655  18.041   0.041  1.00 63.39           N  
ATOM   1086  CA  ILE A 175     -48.776  17.403   1.362  1.00 65.71           C  
ATOM   1087  C   ILE A 175     -47.459  17.452   2.136  1.00 66.47           C  
ATOM   1088  O   ILE A 175     -47.454  17.678   3.345  1.00 66.26           O  
ATOM   1089  CB  ILE A 175     -49.210  15.909   1.248  1.00 65.57           C  
ATOM   1090  CG1 ILE A 175     -50.127  15.698   0.054  1.00 67.20           C  
ATOM   1091  CG2 ILE A 175     -49.973  15.437   2.473  1.00 65.61           C  
ATOM   1092  CD1 ILE A 175     -50.343  14.191  -0.285  1.00 66.68           C  
ATOM   1093  N   ALA A 176     -46.367  17.247   1.399  1.00 67.71           N  
ATOM   1094  CA  ALA A 176     -45.008  17.223   1.919  1.00 69.16           C  
ATOM   1095  C   ALA A 176     -44.557  18.555   2.482  1.00 70.78           C  
ATOM   1096  O   ALA A 176     -43.757  18.587   3.414  1.00 70.44           O  
ATOM   1097  CB  ALA A 176     -44.059  16.787   0.832  1.00 68.81           C  
HETATM 1098  N   MSE A 177     -45.043  19.656   1.920  1.00 72.62           N  
HETATM 1099  CA  MSE A 177     -44.669  20.943   2.464  1.00 76.67           C  
HETATM 1100  C   MSE A 177     -45.750  21.510   3.336  1.00 72.84           C  
HETATM 1101  O   MSE A 177     -45.853  22.710   3.539  1.00 72.52           O  
HETATM 1102  CB  MSE A 177     -44.277  21.882   1.371  1.00 76.25           C  
HETATM 1103  CG  MSE A 177     -42.992  21.464   0.702  1.00 80.48           C  
HETATM 1104 SE   MSE A 177     -43.405  22.079  -1.091  1.00 92.30          SE  
HETATM 1105  CE  MSE A 177     -42.227  20.833  -2.487  1.00 83.38           C  
ATOM   1106  N   THR A 178     -46.521  20.582   3.878  1.00 71.03           N  
ATOM   1107  CA  THR A 178     -47.611  20.807   4.810  1.00 68.86           C  
ATOM   1108  C   THR A 178     -47.296  21.728   5.999  1.00 67.54           C  
ATOM   1109  O   THR A 178     -48.109  22.575   6.346  1.00 66.81           O  
ATOM   1110  CB  THR A 178     -48.138  19.444   5.280  1.00 68.59           C  
ATOM   1111  OG1 THR A 178     -49.426  19.585   5.847  1.00 67.84           O  
ATOM   1112  CG2 THR A 178     -47.220  18.855   6.296  1.00 69.48           C  
ATOM   1113  N   TRP A 179     -46.115  21.573   6.591  1.00 66.39           N  
ATOM   1114  CA  TRP A 179     -45.746  22.299   7.816  1.00 65.96           C  
ATOM   1115  C   TRP A 179     -45.022  23.613   7.554  1.00 66.24           C  
ATOM   1116  O   TRP A 179     -45.129  24.568   8.337  1.00 66.37           O  
ATOM   1117  CB  TRP A 179     -44.967  21.393   8.768  1.00 64.71           C  
ATOM   1118  CG  TRP A 179     -45.886  20.352   9.283  1.00 64.30           C  
ATOM   1119  CD1 TRP A 179     -45.930  19.029   8.919  1.00 63.62           C  
ATOM   1120  CD2 TRP A 179     -46.975  20.552  10.202  1.00 64.35           C  
ATOM   1121  NE1 TRP A 179     -46.966  18.382   9.581  1.00 63.98           N  
ATOM   1122  CE2 TRP A 179     -47.621  19.296  10.370  1.00 64.07           C  
ATOM   1123  CE3 TRP A 179     -47.458  21.665  10.913  1.00 62.45           C  
ATOM   1124  CZ2 TRP A 179     -48.713  19.133  11.212  1.00 62.62           C  
ATOM   1125  CZ3 TRP A 179     -48.529  21.499  11.742  1.00 62.49           C  
ATOM   1126  CH2 TRP A 179     -49.150  20.245  11.888  1.00 63.01           C  
ATOM   1127  N   ALA A 180     -44.285  23.629   6.449  1.00 66.21           N  
ATOM   1128  CA  ALA A 180     -43.863  24.840   5.788  1.00 66.27           C  
ATOM   1129  C   ALA A 180     -45.082  25.662   5.375  1.00 66.47           C  
ATOM   1130  O   ALA A 180     -45.185  26.824   5.731  1.00 67.08           O  
ATOM   1131  CB  ALA A 180     -43.018  24.486   4.565  1.00 66.39           C  
ATOM   1132  N   GLY A 181     -46.011  25.049   4.645  1.00 66.76           N  
ATOM   1133  CA  GLY A 181     -47.185  25.751   4.107  1.00 66.75           C  
ATOM   1134  C   GLY A 181     -48.313  26.131   5.072  1.00 67.11           C  
ATOM   1135  O   GLY A 181     -49.184  26.920   4.703  1.00 67.61           O  
ATOM   1136  N   GLN A 182     -48.331  25.573   6.290  1.00 66.94           N  
ATOM   1137  CA  GLN A 182     -49.373  25.890   7.303  1.00 66.20           C  
ATOM   1138  C   GLN A 182     -48.752  26.375   8.626  1.00 65.85           C  
ATOM   1139  O   GLN A 182     -48.830  25.660   9.628  1.00 65.85           O  
ATOM   1140  CB  GLN A 182     -50.246  24.654   7.612  1.00 66.37           C  
ATOM   1141  CG  GLN A 182     -50.918  23.971   6.417  1.00 65.39           C  
ATOM   1142  CD  GLN A 182     -52.064  24.788   5.819  1.00 65.31           C  
ATOM   1143  OE1 GLN A 182     -52.347  24.664   4.634  1.00 65.10           O  
ATOM   1144  NE2 GLN A 182     -52.725  25.618   6.633  1.00 63.71           N  
ATOM   1145  N   PRO A 183     -48.133  27.579   8.640  1.00 65.43           N  
ATOM   1146  CA  PRO A 183     -47.417  28.021   9.856  1.00 64.97           C  
ATOM   1147  C   PRO A 183     -48.353  28.351  11.008  1.00 64.36           C  
ATOM   1148  O   PRO A 183     -47.985  28.159  12.178  1.00 64.21           O  
ATOM   1149  CB  PRO A 183     -46.680  29.290   9.405  1.00 64.74           C  
ATOM   1150  CG  PRO A 183     -47.458  29.785   8.251  1.00 65.11           C  
ATOM   1151  CD  PRO A 183     -48.062  28.590   7.567  1.00 65.36           C  
ATOM   1152  N   GLU A 184     -49.546  28.849  10.676  1.00 63.78           N  
ATOM   1153  CA  GLU A 184     -50.539  29.196  11.692  1.00 63.47           C  
ATOM   1154  C   GLU A 184     -50.938  27.953  12.520  1.00 63.73           C  
ATOM   1155  O   GLU A 184     -50.753  27.958  13.726  1.00 63.71           O  
ATOM   1156  CB  GLU A 184     -51.759  29.903  11.072  0.50 63.44           C  
ATOM   1158  CG  GLU A 184     -52.715  29.028  10.221  0.50 62.91           C  
ATOM   1160  CD  GLU A 184     -52.033  28.301   9.065  0.50 61.40           C  
ATOM   1162  OE1 GLU A 184     -52.269  27.081   8.914  0.50 60.01           O  
ATOM   1164  OE2 GLU A 184     -51.263  28.945   8.318  0.50 61.08           O  
ATOM   1166  N   ILE A 185     -51.412  26.882  11.872  1.00 64.29           N  
ATOM   1167  CA  ILE A 185     -51.635  25.584  12.530  1.00 64.73           C  
ATOM   1168  C   ILE A 185     -50.327  25.062  13.137  1.00 65.55           C  
ATOM   1169  O   ILE A 185     -50.330  24.550  14.262  1.00 65.60           O  
ATOM   1170  CB  ILE A 185     -52.236  24.508  11.558  1.00 64.62           C  
ATOM   1171  CG1 ILE A 185     -53.541  24.997  10.915  1.00 65.02           C  
ATOM   1172  CG2 ILE A 185     -52.486  23.170  12.268  1.00 63.52           C  
ATOM   1173  CD1 ILE A 185     -53.925  24.263   9.599  1.00 65.27           C  
ATOM   1174  N   ALA A 186     -49.212  25.188  12.406  1.00 66.27           N  
ATOM   1175  CA  ALA A 186     -47.908  24.790  12.946  1.00 67.03           C  
ATOM   1176  C   ALA A 186     -47.680  25.455  14.299  1.00 67.75           C  
ATOM   1177  O   ALA A 186     -47.192  24.815  15.224  1.00 68.01           O  
ATOM   1178  CB  ALA A 186     -46.769  25.102  11.978  1.00 66.75           C  
ATOM   1179  N   ALA A 187     -48.062  26.728  14.430  1.00 68.82           N  
ATOM   1180  CA  ALA A 187     -47.964  27.415  15.732  1.00 69.82           C  
ATOM   1181  C   ALA A 187     -48.806  26.710  16.818  1.00 70.41           C  
ATOM   1182  O   ALA A 187     -48.289  26.384  17.899  1.00 70.38           O  
ATOM   1183  CB  ALA A 187     -48.322  28.903  15.611  1.00 69.26           C  
ATOM   1184  N   ALA A 188     -50.085  26.455  16.505  1.00 71.12           N  
ATOM   1185  CA  ALA A 188     -51.020  25.780  17.424  1.00 71.54           C  
ATOM   1186  C   ALA A 188     -50.533  24.386  17.762  1.00 71.93           C  
ATOM   1187  O   ALA A 188     -50.748  23.898  18.864  1.00 72.23           O  
ATOM   1188  CB  ALA A 188     -52.429  25.719  16.828  1.00 71.35           C  
ATOM   1189  N   ALA A 189     -49.859  23.765  16.796  1.00 72.44           N  
ATOM   1190  CA  ALA A 189     -49.317  22.420  16.932  1.00 72.57           C  
ATOM   1191  C   ALA A 189     -48.443  22.333  18.163  1.00 72.63           C  
ATOM   1192  O   ALA A 189     -48.297  21.256  18.731  1.00 72.65           O  
ATOM   1193  CB  ALA A 189     -48.525  22.044  15.682  1.00 72.32           C  
ATOM   1194  N   ALA A 190     -47.905  23.491  18.565  1.00 73.07           N  
ATOM   1195  CA  ALA A 190     -46.988  23.657  19.702  1.00 73.38           C  
ATOM   1196  C   ALA A 190     -47.256  22.663  20.815  1.00 73.68           C  
ATOM   1197  O   ALA A 190     -46.547  21.669  20.954  1.00 73.93           O  
ATOM   1198  CB  ALA A 190     -47.053  25.088  20.241  1.00 73.36           C  
ATOM   1199  N   ASP A 191     -48.286  22.920  21.604  1.00 73.93           N  
ATOM   1200  CA  ASP A 191     -48.650  21.979  22.659  1.00 74.40           C  
ATOM   1201  C   ASP A 191     -50.109  21.593  22.528  1.00 73.53           C  
ATOM   1202  O   ASP A 191     -50.759  21.253  23.515  1.00 73.58           O  
ATOM   1203  CB  ASP A 191     -48.300  22.502  24.084  1.00 75.20           C  
ATOM   1204  CG  ASP A 191     -48.646  23.993  24.288  1.00 76.81           C  
ATOM   1205  OD1 ASP A 191     -48.966  24.691  23.283  1.00 78.30           O  
ATOM   1206  OD2 ASP A 191     -48.583  24.457  25.460  1.00 77.17           O  
ATOM   1207  N   GLN A 192     -50.608  21.669  21.295  1.00 72.46           N  
ATOM   1208  CA  GLN A 192     -51.875  21.049  20.925  1.00 71.45           C  
ATOM   1209  C   GLN A 192     -51.666  19.625  20.360  1.00 70.52           C  
ATOM   1210  O   GLN A 192     -52.639  18.909  20.095  1.00 70.82           O  
ATOM   1211  CB  GLN A 192     -52.636  21.921  19.915  1.00 71.56           C  
ATOM   1212  CG  GLN A 192     -53.601  22.937  20.544  1.00 72.55           C  
ATOM   1213  CD  GLN A 192     -55.082  22.489  20.552  1.00 73.25           C  
ATOM   1214  OE1 GLN A 192     -55.413  21.326  20.788  1.00 72.87           O  
ATOM   1215  NE2 GLN A 192     -55.972  23.435  20.306  1.00 74.87           N  
ATOM   1216  N   ALA A 193     -50.410  19.221  20.157  1.00 69.01           N  
ATOM   1217  CA  ALA A 193     -50.115  17.898  19.600  1.00 67.25           C  
ATOM   1218  C   ALA A 193     -49.897  16.912  20.722  1.00 66.32           C  
ATOM   1219  O   ALA A 193     -49.229  17.244  21.699  1.00 66.39           O  
ATOM   1220  CB  ALA A 193     -48.905  17.953  18.710  1.00 66.85           C  
ATOM   1221  N   VAL A 194     -50.458  15.708  20.590  1.00 65.11           N  
ATOM   1222  CA  VAL A 194     -50.221  14.638  21.562  1.00 63.96           C  
ATOM   1223  C   VAL A 194     -48.728  14.312  21.641  1.00 63.61           C  
ATOM   1224  O   VAL A 194     -48.188  14.207  22.723  1.00 63.76           O  
ATOM   1225  CB  VAL A 194     -50.993  13.356  21.232  1.00 63.81           C  
ATOM   1226  CG1 VAL A 194     -50.815  12.331  22.332  1.00 62.96           C  
ATOM   1227  CG2 VAL A 194     -52.452  13.654  21.036  1.00 64.19           C  
ATOM   1228  N   ASP A 195     -48.071  14.160  20.492  1.00 63.02           N  
ATOM   1229  CA  ASP A 195     -46.636  13.903  20.430  1.00 61.94           C  
ATOM   1230  C   ASP A 195     -45.991  15.030  19.617  1.00 61.12           C  
ATOM   1231  O   ASP A 195     -46.036  15.014  18.387  1.00 60.96           O  
ATOM   1232  CB  ASP A 195     -46.402  12.531  19.789  1.00 62.12           C  
ATOM   1233  CG  ASP A 195     -44.923  12.190  19.592  1.00 63.90           C  
ATOM   1234  OD1 ASP A 195     -44.044  13.087  19.623  1.00 65.77           O  
ATOM   1235  OD2 ASP A 195     -44.638  10.989  19.389  1.00 65.96           O  
ATOM   1236  N   PRO A 196     -45.396  16.022  20.307  1.00 60.45           N  
ATOM   1237  CA  PRO A 196     -44.812  17.209  19.657  1.00 59.87           C  
ATOM   1238  C   PRO A 196     -43.656  16.886  18.689  1.00 59.43           C  
ATOM   1239  O   PRO A 196     -43.428  17.627  17.703  1.00 59.28           O  
ATOM   1240  CB  PRO A 196     -44.315  18.059  20.832  1.00 59.63           C  
ATOM   1241  CG  PRO A 196     -45.010  17.540  22.016  1.00 59.96           C  
ATOM   1242  CD  PRO A 196     -45.242  16.078  21.770  1.00 60.47           C  
ATOM   1243  N   SER A 197     -42.959  15.780  18.956  1.00 58.40           N  
ATOM   1244  CA  SER A 197     -41.889  15.297  18.088  1.00 57.43           C  
ATOM   1245  C   SER A 197     -42.162  15.521  16.590  1.00 56.49           C  
ATOM   1246  O   SER A 197     -43.132  15.015  16.040  1.00 56.29           O  
ATOM   1247  CB  SER A 197     -41.615  13.820  18.382  1.00 57.61           C  
ATOM   1248  OG  SER A 197     -41.191  13.144  17.216  1.00 58.44           O  
ATOM   1249  N   VAL A 198     -41.302  16.303  15.953  1.00 55.40           N  
ATOM   1250  CA  VAL A 198     -41.292  16.474  14.502  1.00 54.98           C  
ATOM   1251  C   VAL A 198     -41.500  15.181  13.692  1.00 54.85           C  
ATOM   1252  O   VAL A 198     -42.205  15.167  12.673  1.00 54.60           O  
ATOM   1253  CB  VAL A 198     -39.983  17.145  14.055  1.00 55.10           C  
ATOM   1254  CG1 VAL A 198     -39.818  17.127  12.524  1.00 54.13           C  
ATOM   1255  CG2 VAL A 198     -39.923  18.589  14.604  1.00 56.56           C  
ATOM   1256  N   THR A 199     -40.929  14.075  14.138  1.00 20.00           N  
ATOM   1257  CA  THR A 199     -41.038  12.853  13.353  1.00 20.00           C  
ATOM   1258  C   THR A 199     -42.420  12.225  13.500  1.00 20.00           C  
ATOM   1259  O   THR A 199     -42.793  11.350  12.672  1.00 53.54           O  
ATOM   1260  CB  THR A 199     -39.951  11.844  13.769  1.00 20.00           C  
ATOM   1261  OG1 THR A 199     -40.157  10.605  13.081  1.00 20.00           O  
ATOM   1262  CG2 THR A 199     -40.111  11.462  15.232  1.00 20.00           C  
ATOM   1263  N   ALA A 200     -43.164  12.631  14.502  1.00 53.04           N  
ATOM   1264  CA  ALA A 200     -44.611  12.390  14.552  1.00 52.69           C  
ATOM   1265  C   ALA A 200     -45.367  13.075  13.383  1.00 52.22           C  
ATOM   1266  O   ALA A 200     -46.274  12.454  12.791  1.00 52.20           O  
ATOM   1267  CB  ALA A 200     -45.206  12.799  15.933  1.00 52.41           C  
ATOM   1268  N   ARG A 201     -44.997  14.328  13.061  1.00 51.23           N  
ATOM   1269  CA  ARG A 201     -45.539  15.025  11.879  1.00 50.95           C  
ATOM   1270  C   ARG A 201     -45.207  14.201  10.643  1.00 50.74           C  
ATOM   1271  O   ARG A 201     -46.033  14.048   9.737  1.00 50.84           O  
ATOM   1272  CB  ARG A 201     -44.970  16.452  11.693  1.00 50.66           C  
ATOM   1273  CG  ARG A 201     -44.965  17.398  12.927  1.00 50.91           C  
ATOM   1274  CD  ARG A 201     -46.357  17.837  13.430  1.00 49.89           C  
ATOM   1275  NE  ARG A 201     -47.193  16.690  13.812  1.00 53.09           N  
ATOM   1276  CZ  ARG A 201     -47.234  16.131  15.029  1.00 53.14           C  
ATOM   1277  NH1 ARG A 201     -46.482  16.620  16.022  1.00 52.48           N  
ATOM   1278  NH2 ARG A 201     -48.029  15.078  15.253  1.00 51.23           N  
ATOM   1279  N   ARG A 202     -43.990  13.662  10.629  1.00 50.60           N  
ATOM   1280  CA  ARG A 202     -43.482  12.916   9.485  1.00 50.13           C  
ATOM   1281  C   ARG A 202     -44.295  11.650   9.305  1.00 49.82           C  
ATOM   1282  O   ARG A 202     -44.728  11.341   8.171  1.00 50.04           O  
ATOM   1283  CB  ARG A 202     -41.998  12.572   9.662  1.00 50.30           C  
ATOM   1284  CG  ARG A 202     -41.313  12.103   8.379  1.00 48.92           C  
ATOM   1285  CD  ARG A 202     -39.903  11.641   8.658  1.00 44.62           C  
ATOM   1286  NE  ARG A 202     -39.138  11.356   7.436  1.00 45.91           N  
ATOM   1287  CZ  ARG A 202     -39.282  10.266   6.673  1.00 42.71           C  
ATOM   1288  NH1 ARG A 202     -40.197   9.366   6.986  1.00 41.75           N  
ATOM   1289  NH2 ARG A 202     -38.521  10.083   5.597  1.00 39.04           N  
ATOM   1290  N   ALA A 203     -44.517  10.939  10.416  1.00 48.63           N  
ATOM   1291  CA  ALA A 203     -45.275   9.682  10.363  1.00 48.42           C  
ATOM   1292  C   ALA A 203     -46.673   9.881   9.752  1.00 48.17           C  
ATOM   1293  O   ALA A 203     -47.085   9.143   8.854  1.00 47.48           O  
ATOM   1294  CB  ALA A 203     -45.364   9.065  11.715  1.00 48.02           C  
ATOM   1295  N   ALA A 204     -47.358  10.923  10.225  1.00 48.09           N  
ATOM   1296  CA  ALA A 204     -48.708  11.226   9.820  1.00 47.67           C  
ATOM   1297  C   ALA A 204     -48.663  11.414   8.326  1.00 47.80           C  
ATOM   1298  O   ALA A 204     -49.408  10.795   7.581  1.00 47.93           O  
ATOM   1299  CB  ALA A 204     -49.200  12.499  10.514  1.00 46.65           C  
ATOM   1300  N   LEU A 205     -47.740  12.246   7.895  1.00 48.13           N  
ATOM   1301  CA  LEU A 205     -47.686  12.632   6.515  1.00 48.90           C  
ATOM   1302  C   LEU A 205     -47.433  11.419   5.607  1.00 48.91           C  
ATOM   1303  O   LEU A 205     -48.089  11.250   4.573  1.00 48.26           O  
ATOM   1304  CB  LEU A 205     -46.599  13.668   6.356  1.00 49.15           C  
ATOM   1305  CG  LEU A 205     -45.891  13.634   5.025  1.00 51.23           C  
ATOM   1306  CD1 LEU A 205     -46.841  13.813   3.842  1.00 53.10           C  
ATOM   1307  CD2 LEU A 205     -44.903  14.764   5.077  1.00 56.93           C  
ATOM   1308  N   VAL A 206     -46.485  10.579   6.013  1.00 48.93           N  
ATOM   1309  CA  VAL A 206     -46.155   9.421   5.247  1.00 48.57           C  
ATOM   1310  C   VAL A 206     -47.340   8.456   5.243  1.00 49.64           C  
ATOM   1311  O   VAL A 206     -47.650   7.821   4.208  1.00 50.81           O  
ATOM   1312  CB  VAL A 206     -44.894   8.779   5.773  1.00 48.21           C  
ATOM   1313  CG1 VAL A 206     -44.731   7.391   5.196  1.00 47.11           C  
ATOM   1314  CG2 VAL A 206     -43.710   9.635   5.415  1.00 46.48           C  
ATOM   1315  N   THR A 207     -48.025   8.368   6.382  1.00 49.83           N  
ATOM   1316  CA  THR A 207     -49.160   7.477   6.530  1.00 49.58           C  
ATOM   1317  C   THR A 207     -50.267   7.959   5.635  1.00 50.16           C  
ATOM   1318  O   THR A 207     -50.912   7.165   4.968  1.00 50.59           O  
ATOM   1319  CB  THR A 207     -49.628   7.432   7.980  1.00 49.63           C  
ATOM   1320  OG1 THR A 207     -48.568   6.906   8.792  1.00 49.78           O  
ATOM   1321  CG2 THR A 207     -50.856   6.556   8.133  1.00 49.36           C  
ATOM   1322  N   ALA A 208     -50.464   9.270   5.590  1.00 50.59           N  
ATOM   1323  CA  ALA A 208     -51.487   9.855   4.744  1.00 51.36           C  
ATOM   1324  C   ALA A 208     -51.251   9.532   3.265  1.00 52.46           C  
ATOM   1325  O   ALA A 208     -52.202   9.275   2.502  1.00 52.69           O  
ATOM   1326  CB  ALA A 208     -51.562  11.356   4.965  1.00 50.34           C  
ATOM   1327  N   VAL A 209     -49.990   9.550   2.855  1.00 54.14           N  
ATOM   1328  CA  VAL A 209     -49.667   9.339   1.456  1.00 56.14           C  
ATOM   1329  C   VAL A 209     -49.832   7.866   1.167  1.00 58.40           C  
ATOM   1330  O   VAL A 209     -50.320   7.491   0.085  1.00 58.21           O  
ATOM   1331  CB  VAL A 209     -48.255   9.844   1.082  1.00 55.90           C  
ATOM   1332  CG1 VAL A 209     -47.903   9.497  -0.368  1.00 55.02           C  
ATOM   1333  CG2 VAL A 209     -48.171  11.339   1.274  1.00 54.98           C  
ATOM   1334  N   GLU A 210     -49.454   7.037   2.149  1.00 61.20           N  
ATOM   1335  CA  GLU A 210     -49.772   5.621   2.087  1.00 63.94           C  
ATOM   1336  C   GLU A 210     -51.275   5.408   1.870  1.00 65.21           C  
ATOM   1337  O   GLU A 210     -51.664   4.576   1.043  1.00 65.68           O  
ATOM   1338  CB  GLU A 210     -49.282   4.874   3.321  1.00 64.29           C  
ATOM   1339  CG  GLU A 210     -49.885   3.451   3.496  1.00 68.05           C  
ATOM   1340  CD  GLU A 210     -49.575   2.463   2.332  1.00 74.73           C  
ATOM   1341  OE1 GLU A 210     -48.493   2.573   1.685  1.00 78.35           O  
ATOM   1342  OE2 GLU A 210     -50.415   1.556   2.069  1.00 76.03           O  
ATOM   1343  N   HIS A 211     -52.124   6.158   2.568  1.00 66.63           N  
ATOM   1344  CA  HIS A 211     -53.563   5.996   2.361  1.00 68.42           C  
ATOM   1345  C   HIS A 211     -54.004   6.380   0.969  1.00 70.18           C  
ATOM   1346  O   HIS A 211     -54.815   5.695   0.387  1.00 69.98           O  
ATOM   1347  CB  HIS A 211     -54.385   6.707   3.426  1.00 68.03           C  
ATOM   1348  CG  HIS A 211     -54.408   5.979   4.728  1.00 68.06           C  
ATOM   1349  ND1 HIS A 211     -53.516   6.242   5.748  1.00 68.94           N  
ATOM   1350  CD2 HIS A 211     -55.184   4.961   5.162  1.00 66.50           C  
ATOM   1351  CE1 HIS A 211     -53.760   5.436   6.763  1.00 66.01           C  
ATOM   1352  NE2 HIS A 211     -54.766   4.650   6.433  1.00 65.69           N  
HETATM 1353  N   MSE A 212     -53.453   7.446   0.409  1.00 72.93           N  
HETATM 1354  CA  MSE A 212     -53.820   7.815  -0.952  1.00 76.78           C  
HETATM 1355  C   MSE A 212     -53.428   6.806  -2.015  1.00 76.59           C  
HETATM 1356  O   MSE A 212     -54.279   6.332  -2.770  1.00 76.84           O  
HETATM 1357  CB  MSE A 212     -53.199   9.118  -1.312  1.00 75.72           C  
HETATM 1358  CG  MSE A 212     -54.055  10.246  -0.969  1.00 78.66           C  
HETATM 1359 SE   MSE A 212     -52.821  11.718  -0.808  1.00 84.31          SE  
HETATM 1360  CE  MSE A 212     -52.391  12.115  -2.691  1.00 83.13           C  
ATOM   1361  N   PHE A 213     -52.137   6.501  -2.082  1.00 77.56           N  
ATOM   1362  CA  PHE A 213     -51.615   5.546  -3.056  1.00 78.27           C  
ATOM   1363  C   PHE A 213     -50.929   4.386  -2.333  1.00 79.60           C  
ATOM   1364  O   PHE A 213     -49.720   4.453  -2.077  1.00 79.90           O  
ATOM   1365  CB  PHE A 213     -50.623   6.229  -4.003  1.00 77.33           C  
ATOM   1366  CG  PHE A 213     -50.968   7.653  -4.330  1.00 75.94           C  
ATOM   1367  CD1 PHE A 213     -50.409   8.706  -3.600  1.00 74.74           C  
ATOM   1368  CD2 PHE A 213     -51.825   7.952  -5.379  1.00 72.94           C  
ATOM   1369  CE1 PHE A 213     -50.722  10.028  -3.915  1.00 72.70           C  
ATOM   1370  CE2 PHE A 213     -52.135   9.272  -5.690  1.00 71.77           C  
ATOM   1371  CZ  PHE A 213     -51.586  10.303  -4.964  1.00 72.30           C  
ATOM   1372  N   PRO A 214     -51.691   3.318  -1.998  1.00 80.97           N  
ATOM   1373  CA  PRO A 214     -51.148   2.264  -1.124  1.00 82.17           C  
ATOM   1374  C   PRO A 214     -50.079   1.396  -1.815  1.00 83.79           C  
ATOM   1375  O   PRO A 214     -50.373   0.777  -2.855  1.00 84.07           O  
ATOM   1376  CB  PRO A 214     -52.383   1.437  -0.746  1.00 81.85           C  
ATOM   1377  CG  PRO A 214     -53.572   2.208  -1.275  1.00 81.36           C  
ATOM   1378  CD  PRO A 214     -53.076   3.027  -2.403  1.00 80.81           C  
ATOM   1379  N   ARG A 215     -48.856   1.374  -1.250  1.00 85.15           N  
ATOM   1380  CA  ARG A 215     -47.711   0.591  -1.793  1.00 86.36           C  
ATOM   1381  C   ARG A 215     -48.043  -0.890  -2.116  1.00 86.67           C  
ATOM   1382  O   ARG A 215     -48.855  -1.515  -1.403  1.00 86.76           O  
ATOM   1383  CB  ARG A 215     -46.507   0.659  -0.853  1.00 86.44           C  
ATOM   1384  CG  ARG A 215     -45.877   2.016  -0.769  1.00 87.86           C  
ATOM   1385  CD  ARG A 215     -44.657   1.965   0.138  1.00 91.13           C  
ATOM   1386  NE  ARG A 215     -43.440   1.530  -0.560  1.00 93.72           N  
ATOM   1387  CZ  ARG A 215     -42.776   0.392  -0.333  1.00 94.41           C  
ATOM   1388  NH1 ARG A 215     -43.200  -0.472   0.589  1.00 95.47           N  
ATOM   1389  NH2 ARG A 215     -41.675   0.113  -1.029  1.00 92.97           N  
ATOM   1390  N   PRO A 216     -47.413  -1.450  -3.184  1.00 86.89           N  
ATOM   1391  CA  PRO A 216     -47.712  -2.828  -3.619  1.00 86.94           C  
ATOM   1392  C   PRO A 216     -46.760  -3.875  -3.006  1.00 86.62           C  
ATOM   1393  O   PRO A 216     -46.787  -5.042  -3.397  1.00 86.08           O  
ATOM   1394  CB  PRO A 216     -47.535  -2.746  -5.140  1.00 86.95           C  
ATOM   1395  CG  PRO A 216     -46.456  -1.635  -5.324  1.00 86.89           C  
ATOM   1396  CD  PRO A 216     -46.385  -0.823  -4.044  1.00 86.71           C  
TER    1397      PRO A 216                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
