
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  206 ( 1601),  selected  206 , name 2uxh_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 2uxh_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_A      D       5           -
LGA    K     6_A      C       6           -
LGA    E     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    Q    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    T    12_A      R       7          2.179
LGA    R    13_A      -       -           -
LGA    A    14_A      S       8          4.506
LGA    Q    15_A      R       9          4.004
LGA    I    16_A      L      10          3.412
LGA    I    17_A      M      11          2.912
LGA    E    18_A      E      12          2.251
LGA    A    19_A      V      13          1.866
LGA    A    20_A      A      14          1.618
LGA    E    21_A      T      15          1.407
LGA    R    22_A      E      16          1.327
LGA    A    23_A      L      17          1.281
LGA    F    24_A      F      18          1.892
LGA    Y    25_A      A      19          3.107
LGA    K    26_A      Q      20          3.715
LGA    R    27_A      K      21          3.384
LGA    G    28_A      G      22          3.498
LGA    V    29_A      F      23          3.072
LGA    A    30_A      Y      24          2.233
LGA    R    31_A      G      25          1.250
LGA    T    32_A      V      26          0.791
LGA    T    33_A      S      27          3.026
LGA    L    34_A      I      28          4.054
LGA    A    35_A      R      29          4.433
LGA    D    36_A      E      30          3.239
LGA    I    37_A      L      31          2.990
LGA    A    38_A      A      32          4.167
LGA    E    39_A      Q      33          4.322
LGA    L    40_A      A      34          3.344
LGA    A    41_A      A      35          3.845
LGA    G    42_A      G      36          4.419
LGA    V    43_A      A      37          4.675
LGA    -       -      S      38           -
LGA    -       -      I      39           -
LGA    -       -      S      40           -
LGA    T    44_A      M      41          1.592
LGA    R    45_A      I      42          1.536
LGA    -       -      S      43           -
LGA    G    46_A      Y      44          1.502
LGA    A    47_A      H      45          1.876
LGA    I    48_A      F      46          1.851
LGA    Y    49_A      G      47          1.163
LGA    W    50_A      G      48           -
LGA    H    51_A      K      49           -
LGA    F    52_A      -       -           -
LGA    N    53_A      E      50          4.672
LGA    N    54_A      G      51          4.373
LGA    K    55_A      L      52           #
LGA    A    56_A      Y      53           #
LGA    E    57_A      A      54          2.455
LGA    L    58_A      A      55          3.821
LGA    V    59_A      V      56           #
LGA    Q    60_A      L      57          3.062
LGA    A    61_A      Q      58          1.288
LGA    L    62_A      E      59          3.562
LGA    L    63_A      Q      60          2.975
LGA    D    64_A      F      61          1.742
LGA    S    65_A      A      62          3.313
LGA    L    66_A      C      63          4.225
LGA    H    67_A      F      64          3.217
LGA    E    68_A      G      65           #
LGA    T    69_A      -       -           -
LGA    H    70_A      Q      66           #
LGA    D    71_A      L      67          3.505
LGA    H    72_A      D      68          3.010
LGA    L    73_A      D      69          0.671
LGA    A    74_A      I      70          2.347
LGA    R    75_A      R      71          2.717
LGA    A    76_A      G      72          1.194
LGA    S    77_A      Q      73          3.204
LGA    E    78_A      A      74          4.271
LGA    S    79_A      -       -           -
LGA    E    80_A      -       -           -
LGA    D    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    V    83_A      G      75          4.702
LGA    D    84_A      D      76          4.007
LGA    P    85_A      P      77          4.741
LGA    L    86_A      L      78          2.540
LGA    G    87_A      A      79          2.406
LGA    C    88_A      V      80          4.466
LGA    M    89_A      M      81          3.499
LGA    R    90_A      T      82          1.320
LGA    K    91_A      A      83          3.486
LGA    L    92_A      Y      84          3.990
LGA    L    93_A      L      85          1.818
LGA    L    94_A      R      86          2.468
LGA    Q    95_A      W      87          4.113
LGA    V    96_A      T      88          2.918
LGA    F    97_A      I      89          1.864
LGA    N    98_A      Q      90          4.290
LGA    E    99_A      R      91          4.929
LGA    L   100_A      H      92          2.667
LGA    V   101_A      R      93          3.655
LGA    L   102_A      -       -           -
LGA    D   103_A      N      94          3.151
LGA    A   104_A      -       -           -
LGA    R   105_A      -       -           -
LGA    T   106_A      N      95          0.313
LGA    R   107_A      P      96          0.617
LGA    R   108_A      Q      97          2.021
LGA    I   109_A      L      98          2.848
LGA    N   110_A      L      99          2.255
LGA    E   111_A      R     100          2.871
LGA    I   112_A      F     101          3.732
LGA    L   113_A      Y     102          2.975
LGA    H   114_A      T     103          3.113
LGA    H   115_A      -       -           -
LGA    K   116_A      -       -           -
LGA    C   117_A      S     104          2.627
LGA    E   118_A      E     105           #
LGA    -       -      L     106           -
LGA    F   119_A      T     107          4.107
LGA    T   120_A      N     108          4.448
LGA    D   121_A      -       -           -
LGA    D   122_A      -       -           -
LGA    M   123_A      P     109           #
LGA    C   124_A      T     110          4.347
LGA    E   125_A      P     111          2.216
LGA    I   126_A      C     112          4.781
LGA    R   127_A      F     113          4.651
LGA    Q   128_A      A     114          3.642
LGA    -       -      A     115           -
LGA    Q   129_A      I     116          4.915
LGA    R   130_A      V     117          3.840
LGA    Q   131_A      S     118          3.716
LGA    S   132_A      P     119          3.328
LGA    A   133_A      A     120          3.141
LGA    V   134_A      I     121          2.772
LGA    L   135_A      A     122          1.927
LGA    D   136_A      S     123          2.050
LGA    C   137_A      V     124          1.978
LGA    H   138_A      I     125          1.025
LGA    K   139_A      R     126          0.832
LGA    G   140_A      L     127          1.429
LGA    I   141_A      L     128          1.198
LGA    T   142_A      A     129          1.292
LGA    L   143_A      E     130          2.125
LGA    A   144_A      S     131          3.085
LGA    L   145_A      I     132          2.976
LGA    A   146_A      E     133          3.634
LGA    N   147_A      A     134          4.713
LGA    A   148_A      -       -           -
LGA    V   149_A      G     135          1.507
LGA    R   150_A      M     136           -
LGA    -       -      T     137           -
LGA    R   151_A      R     138           #
LGA    G   152_A      -       -           -
LGA    Q   153_A      -       -           -
LGA    L   154_A      -       -           -
LGA    P   155_A      G     139           #
LGA    G   156_A      L     140          2.453
LGA    E   157_A      F     141          4.104
LGA    L   158_A      R     142          3.318
LGA    D   159_A      R     143          5.103
LGA    -       -      D     144           -
LGA    -       -      L     145           -
LGA    A   160_A      H     146           #
LGA    E   161_A      A     147          1.383
LGA    -       -      V     148           -
LGA    R   162_A      N     149          2.836
LGA    A   163_A      S     150          1.756
LGA    A   164_A      A     151          0.672
LGA    V   165_A      L     152          1.785
LGA    A   166_A      A     153          1.325
LGA    M   167_A      L     154          0.774
LGA    F   168_A      A     155          1.423
LGA    A   169_A      G     156          1.794
LGA    Y   170_A      M     157          1.405
LGA    V   171_A      V     158          1.675
LGA    D   172_A      N     159          1.975
LGA    G   173_A      Y     160          1.483
LGA    L   174_A      F     161          1.450
LGA    I   175_A      F     162          1.803
LGA    R   176_A      L     163          0.668
LGA    R   177_A      S     164          0.892
LGA    W   178_A      T     165          1.664
LGA    L   179_A      -       -           -
LGA    L   180_A      L     166          2.745
LGA    L   181_A      A     167          3.217
LGA    P   182_A      T     168           #
LGA    D   183_A      E     169          2.992
LGA    S   184_A      G     170          3.425
LGA    -       -      L     171           -
LGA    V   185_A      T     172          3.278
LGA    D   186_A      S     173          2.026
LGA    L   187_A      H     174          2.949
LGA    L   188_A      S     175          3.230
LGA    -       -      P     176           -
LGA    G   189_A      D     177          2.866
LGA    D   190_A      Q     178          2.536
LGA    V   191_A      D     179          1.681
LGA    E   192_A      E     180          2.568
LGA    K   193_A      E     181          3.176
LGA    W   194_A      L     182          2.191
LGA    V   195_A      I     183          1.960
LGA    D   196_A      R     184          2.733
LGA    T   197_A      Q     185          2.833
LGA    G   198_A      Y     186          2.470
LGA    L   199_A      V     187          2.031
LGA    D   200_A      A     188          2.284
LGA    M   201_A      I     189          3.187
LGA    L   202_A      F     190          3.113
LGA    R   203_A      T     191          2.064
LGA    L   204_A      R     192          2.305
LGA    S   205_A      G     193          4.815
LGA    P   206_A      I     194           -
LGA    A   207_A      M     195           -
LGA    L   208_A      A     196           -
LGA    R   209_A      -       -           -
LGA    K   210_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  206  192    5.0    161    2.97    11.80     47.449     5.239

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.304691 * X  +  -0.471617 * Y  +  -0.827491 * Z  + -33.081635
  Y_new =  -0.285155 * X  +  -0.874119 * Y  +   0.393195 * Z  +  53.874836
  Z_new =  -0.908763 * X  +   0.116160 * Y  +  -0.400821 * Z  +   5.915531 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.859514   -0.282079  [ DEG:   163.8381    -16.1619 ]
  Theta =   1.140309    2.001283  [ DEG:    65.3349    114.6651 ]
  Phi   =  -0.752290    2.389303  [ DEG:   -43.1030    136.8970 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uxh_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uxh_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  206  192   5.0  161   2.97   11.80  47.449
REMARK  ---------------------------------------------------------- 
MOLECULE 2uxh_A
HEADER    TRANSCRIPTION                           28-MAR-07   2UXH              
TITLE     TTGR IN COMPLEX WITH QUERCETIN                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HTH-TYPE TRANSCRIPTIONAL REGULATOR TTGR;                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: TOLUENE EFFLUX PUMP TTGABC OPERON REPRESSOR,                
COMPND   5 TRANSCRIPTIONAL REPRESSOR;                                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS PUTIDA;                             
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: N/AK12;                                    
SOURCE   5 EXPRESSION_SYSTEM_CELL_LINE: B834;                                   
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET28(B)                                  
KEYWDS    TRANSCRIPTION REGULATION, MULTIDRUG BINDING PROTEIN,                  
KEYWDS   2 TRANSCRIPTIONAL REGULATOR OF EFFLUX PUMPS, REPRESSOR, DNA-           
KEYWDS   3 BINDING, TETR FAMILIY, TRANSCRIPTION                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.ALGUEL,C.MENG,W.TERAN,T.KRELL,J.L.RAMOS,M.-T.GALLEGOS,              
AUTHOR   2 X.ZHANG                                                              
REVDAT   1   08-MAY-07 2UXH    0                                                
JRNL        AUTH   Y.ALGUEL,C.MENG,W.TERAN,T.KRELL,J.L.RAMOS,                   
JRNL        AUTH 2 M.-T.GALLEGOS,X.ZHANG                                        
JRNL        TITL   CRYSTAL STRUCTURES OF MULTIDRUG BINDING PROTEIN              
JRNL        TITL 2 TTGR IN COMPLEX WITH ANTIBIOTICS AND PLANT                   
JRNL        TITL 3 ANTIMICROBIALS                                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2UXH A    1   210  UNP    Q9AIU0   TTGR_PSEPU       1    210             
DBREF  2UXH B    1   210  UNP    Q9AIU0   TTGR_PSEPU       1    210             
SEQRES   1 A  210  MET VAL ARG ARG THR LYS GLU GLU ALA GLN GLU THR ARG          
SEQRES   2 A  210  ALA GLN ILE ILE GLU ALA ALA GLU ARG ALA PHE TYR LYS          
SEQRES   3 A  210  ARG GLY VAL ALA ARG THR THR LEU ALA ASP ILE ALA GLU          
SEQRES   4 A  210  LEU ALA GLY VAL THR ARG GLY ALA ILE TYR TRP HIS PHE          
SEQRES   5 A  210  ASN ASN LYS ALA GLU LEU VAL GLN ALA LEU LEU ASP SER          
SEQRES   6 A  210  LEU HIS GLU THR HIS ASP HIS LEU ALA ARG ALA SER GLU          
SEQRES   7 A  210  SER GLU ASP GLU VAL ASP PRO LEU GLY CYS MET ARG LYS          
SEQRES   8 A  210  LEU LEU LEU GLN VAL PHE ASN GLU LEU VAL LEU ASP ALA          
SEQRES   9 A  210  ARG THR ARG ARG ILE ASN GLU ILE LEU HIS HIS LYS CYS          
SEQRES  10 A  210  GLU PHE THR ASP ASP MET CYS GLU ILE ARG GLN GLN ARG          
SEQRES  11 A  210  GLN SER ALA VAL LEU ASP CYS HIS LYS GLY ILE THR LEU          
SEQRES  12 A  210  ALA LEU ALA ASN ALA VAL ARG ARG GLY GLN LEU PRO GLY          
SEQRES  13 A  210  GLU LEU ASP ALA GLU ARG ALA ALA VAL ALA MET PHE ALA          
SEQRES  14 A  210  TYR VAL ASP GLY LEU ILE ARG ARG TRP LEU LEU LEU PRO          
SEQRES  15 A  210  ASP SER VAL ASP LEU LEU GLY ASP VAL GLU LYS TRP VAL          
SEQRES  16 A  210  ASP THR GLY LEU ASP MET LEU ARG LEU SER PRO ALA LEU          
SEQRES  17 A  210  ARG LYS                                                      
SEQRES   1 B  210  MET VAL ARG ARG THR LYS GLU GLU ALA GLN GLU THR ARG          
SEQRES   2 B  210  ALA GLN ILE ILE GLU ALA ALA GLU ARG ALA PHE TYR LYS          
SEQRES   3 B  210  ARG GLY VAL ALA ARG THR THR LEU ALA ASP ILE ALA GLU          
SEQRES   4 B  210  LEU ALA GLY VAL THR ARG GLY ALA ILE TYR TRP HIS PHE          
SEQRES   5 B  210  ASN ASN LYS ALA GLU LEU VAL GLN ALA LEU LEU ASP SER          
SEQRES   6 B  210  LEU HIS GLU THR HIS ASP HIS LEU ALA ARG ALA SER GLU          
SEQRES   7 B  210  SER GLU ASP GLU VAL ASP PRO LEU GLY CYS MET ARG LYS          
SEQRES   8 B  210  LEU LEU LEU GLN VAL PHE ASN GLU LEU VAL LEU ASP ALA          
SEQRES   9 B  210  ARG THR ARG ARG ILE ASN GLU ILE LEU HIS HIS LYS CYS          
SEQRES  10 B  210  GLU PHE THR ASP ASP MET CYS GLU ILE ARG GLN GLN ARG          
SEQRES  11 B  210  GLN SER ALA VAL LEU ASP CYS HIS LYS GLY ILE THR LEU          
SEQRES  12 B  210  ALA LEU ALA ASN ALA VAL ARG ARG GLY GLN LEU PRO GLY          
SEQRES  13 B  210  GLU LEU ASP ALA GLU ARG ALA ALA VAL ALA MET PHE ALA          
SEQRES  14 B  210  TYR VAL ASP GLY LEU ILE ARG ARG TRP LEU LEU LEU PRO          
SEQRES  15 B  210  ASP SER VAL ASP LEU LEU GLY ASP VAL GLU LYS TRP VAL          
SEQRES  16 B  210  ASP THR GLY LEU ASP MET LEU ARG LEU SER PRO ALA LEU          
SEQRES  17 B  210  ARG LYS                                                      
HET    QUE  A1211      22                                                       
HET    QUE  B1211      22                                                       
HETNAM     QUE 3,5,7,3',4'-PENTAHYDROXYFLAVONE                                  
FORMUL   3  QUE    2(C15 H10 O7)                                                
FORMUL   5  HOH   *191(H2 O)                                                    
CRYST1   46.650  231.881   44.330  90.00  90.00  90.00 P 21 21 2     8          
ATOM      1  N   THR A   5      -7.286  29.614  -9.056  1.00 71.94           N  
ATOM      2  CA  THR A   5      -8.175  29.063 -10.059  1.00 71.78           C  
ATOM      3  C   THR A   5      -9.458  28.608  -9.413  1.00 71.64           C  
ATOM      4  O   THR A   5     -10.201  29.426  -8.888  1.00 71.81           O  
ATOM      5  CB  THR A   5      -7.524  27.922 -10.815  1.00 71.70           C  
ATOM      6  N   LYS A   6      -9.600  27.527 -10.154  1.00 71.38           N  
ATOM      7  CA  LYS A   6     -10.857  26.830 -10.121  1.00 70.92           C  
ATOM      8  C   LYS A   6     -11.268  26.758  -8.680  1.00 70.82           C  
ATOM      9  O   LYS A   6     -12.333  27.200  -8.311  1.00 70.74           O  
ATOM     10  CB  LYS A   6     -10.742  25.454 -10.727  1.00 71.03           C  
ATOM     11  CG  LYS A   6     -11.999  25.031 -11.399  1.00 71.02           C  
ATOM     12  CD  LYS A   6     -11.744  24.511 -12.776  1.00 71.00           C  
ATOM     13  CE  LYS A   6     -11.811  23.025 -12.843  1.00 71.03           C  
ATOM     14  NZ  LYS A   6     -11.815  22.596 -14.249  1.00 70.76           N  
ATOM     15  N   GLU A   7     -10.399  26.229  -7.852  1.00 70.55           N  
ATOM     16  CA  GLU A   7     -10.743  26.028  -6.466  1.00 70.59           C  
ATOM     17  C   GLU A   7     -11.290  27.289  -5.882  1.00 70.31           C  
ATOM     18  O   GLU A   7     -12.230  27.254  -5.130  1.00 70.55           O  
ATOM     19  CB  GLU A   7      -9.568  25.541  -5.625  1.00 70.69           C  
ATOM     20  CG  GLU A   7      -9.174  24.095  -5.859  1.00 70.89           C  
ATOM     21  CD  GLU A   7      -8.887  23.348  -4.566  1.00 71.07           C  
ATOM     22  OE1 GLU A   7      -8.200  23.917  -3.696  1.00 71.13           O  
ATOM     23  OE2 GLU A   7      -9.356  22.191  -4.421  1.00 70.91           O  
ATOM     24  N   GLU A   8     -10.718  28.420  -6.236  1.00 70.00           N  
ATOM     25  CA  GLU A   8     -11.084  29.675  -5.604  1.00 69.36           C  
ATOM     26  C   GLU A   8     -12.399  30.292  -6.109  1.00 68.84           C  
ATOM     27  O   GLU A   8     -13.149  30.871  -5.342  1.00 68.70           O  
ATOM     28  CB  GLU A   8      -9.920  30.672  -5.647  1.00 69.77           C  
ATOM     29  CG  GLU A   8      -9.869  31.593  -4.449  1.00 70.16           C  
ATOM     30  CD  GLU A   8      -8.589  32.392  -4.358  1.00 70.34           C  
ATOM     31  OE1 GLU A   8      -8.422  33.151  -3.371  1.00 70.62           O  
ATOM     32  OE2 GLU A   8      -7.755  32.261  -5.272  1.00 70.32           O  
ATOM     33  N   ALA A   9     -12.665  30.175  -7.396  1.00 67.93           N  
ATOM     34  CA  ALA A   9     -14.002  30.367  -7.909  1.00 67.41           C  
ATOM     35  C   ALA A   9     -15.061  29.536  -7.221  1.00 66.94           C  
ATOM     36  O   ALA A   9     -16.176  29.986  -7.053  1.00 66.81           O  
ATOM     37  CB  ALA A   9     -14.058  30.124  -9.384  1.00 67.22           C  
ATOM     38  N   GLN A  10     -14.755  28.297  -6.878  1.00 66.59           N  
ATOM     39  CA  GLN A  10     -15.849  27.415  -6.523  1.00 66.29           C  
ATOM     40  C   GLN A  10     -16.064  27.377  -5.031  1.00 66.05           C  
ATOM     41  O   GLN A  10     -16.948  26.709  -4.542  1.00 66.19           O  
ATOM     42  CB  GLN A  10     -15.658  26.034  -7.097  1.00 66.21           C  
ATOM     43  N   GLU A  11     -15.234  28.122  -4.331  1.00 65.67           N  
ATOM     44  CA  GLU A  11     -15.364  28.439  -2.916  1.00 65.60           C  
ATOM     45  C   GLU A  11     -16.175  29.713  -2.672  1.00 65.54           C  
ATOM     46  O   GLU A  11     -16.929  29.778  -1.701  1.00 65.65           O  
ATOM     47  CB  GLU A  11     -14.005  28.537  -2.256  1.00 65.46           C  
ATOM     48  N   THR A  12     -16.018  30.717  -3.540  1.00 65.66           N  
ATOM     49  CA  THR A  12     -16.756  31.977  -3.397  1.00 65.44           C  
ATOM     50  C   THR A  12     -18.160  31.866  -3.969  1.00 65.54           C  
ATOM     51  O   THR A  12     -19.048  32.614  -3.557  1.00 65.36           O  
ATOM     52  CB  THR A  12     -16.029  33.253  -3.983  1.00 65.69           C  
ATOM     53  OG1 THR A  12     -16.356  33.434  -5.370  1.00 65.67           O  
ATOM     54  CG2 THR A  12     -14.493  33.216  -3.776  1.00 65.35           C  
ATOM     55  N   ARG A  13     -18.368  30.949  -4.916  1.00 65.41           N  
ATOM     56  CA  ARG A  13     -19.728  30.618  -5.339  1.00 65.36           C  
ATOM     57  C   ARG A  13     -20.497  30.070  -4.132  1.00 65.18           C  
ATOM     58  O   ARG A  13     -21.621  30.496  -3.884  1.00 65.32           O  
ATOM     59  CB  ARG A  13     -19.771  29.645  -6.525  1.00 65.69           C  
ATOM     60  CG  ARG A  13     -21.204  29.308  -6.978  1.00 66.40           C  
ATOM     61  CD  ARG A  13     -21.264  28.488  -8.276  1.00 66.93           C  
ATOM     62  NE  ARG A  13     -22.512  28.726  -9.017  1.00 67.26           N  
ATOM     63  CZ  ARG A  13     -23.551  27.893  -9.057  1.00 67.40           C  
ATOM     64  NH1 ARG A  13     -23.524  26.739  -8.395  1.00 67.69           N  
ATOM     65  NH2 ARG A  13     -24.635  28.219  -9.759  1.00 67.78           N  
ATOM     66  N   ALA A  14     -19.876  29.157  -3.376  1.00 64.83           N  
ATOM     67  CA  ALA A  14     -20.452  28.632  -2.131  1.00 64.27           C  
ATOM     68  C   ALA A  14     -20.669  29.716  -1.083  1.00 64.12           C  
ATOM     69  O   ALA A  14     -21.677  29.678  -0.364  1.00 64.53           O  
ATOM     70  CB  ALA A  14     -19.589  27.512  -1.561  1.00 64.62           C  
ATOM     71  N   GLN A  15     -19.729  30.664  -0.996  1.00 63.34           N  
ATOM     72  CA  GLN A  15     -19.827  31.823  -0.092  1.00 62.71           C  
ATOM     73  C   GLN A  15     -20.935  32.800  -0.478  1.00 62.23           C  
ATOM     74  O   GLN A  15     -21.564  33.402   0.392  1.00 62.41           O  
ATOM     75  CB  GLN A  15     -18.519  32.604  -0.063  1.00 62.75           C  
ATOM     76  CG  GLN A  15     -17.358  31.936   0.638  1.00 62.94           C  
ATOM     77  CD  GLN A  15     -16.067  32.692   0.393  1.00 63.05           C  
ATOM     78  OE1 GLN A  15     -16.020  33.921   0.524  1.00 62.99           O  
ATOM     79  NE2 GLN A  15     -15.013  31.967   0.023  1.00 63.22           N  
ATOM     80  N   ILE A  16     -21.143  32.978  -1.780  1.00 61.53           N  
ATOM     81  CA  ILE A  16     -22.191  33.851  -2.293  1.00 60.85           C  
ATOM     82  C   ILE A  16     -23.546  33.245  -1.970  1.00 60.40           C  
ATOM     83  O   ILE A  16     -24.327  33.847  -1.244  1.00 60.03           O  
ATOM     84  CB  ILE A  16     -22.056  34.094  -3.812  1.00 61.01           C  
ATOM     85  CG1 ILE A  16     -20.934  35.099  -4.089  1.00 61.26           C  
ATOM     86  CG2 ILE A  16     -23.366  34.623  -4.381  1.00 61.36           C  
ATOM     87  CD1 ILE A  16     -20.310  34.985  -5.486  1.00 61.20           C  
ATOM     88  N   ILE A  17     -23.790  32.045  -2.494  1.00 59.65           N  
ATOM     89  CA  ILE A  17     -24.981  31.267  -2.192  1.00 59.58           C  
ATOM     90  C   ILE A  17     -25.315  31.209  -0.688  1.00 59.73           C  
ATOM     91  O   ILE A  17     -26.489  31.280  -0.312  1.00 59.62           O  
ATOM     92  CB  ILE A  17     -24.894  29.839  -2.782  1.00 59.42           C  
ATOM     93  CG1 ILE A  17     -25.222  29.863  -4.280  1.00 59.31           C  
ATOM     94  CG2 ILE A  17     -25.835  28.898  -2.054  1.00 59.07           C  
ATOM     95  CD1 ILE A  17     -24.778  28.628  -5.034  1.00 59.01           C  
ATOM     96  N   GLU A  18     -24.301  31.106   0.169  1.00 59.55           N  
ATOM     97  CA  GLU A  18     -24.571  31.089   1.607  1.00 59.47           C  
ATOM     98  C   GLU A  18     -24.973  32.406   2.285  1.00 58.75           C  
ATOM     99  O   GLU A  18     -25.792  32.396   3.207  1.00 58.26           O  
ATOM    100  CB  GLU A  18     -23.508  30.320   2.383  1.00 60.31           C  
ATOM    101  CG  GLU A  18     -23.884  28.841   2.467  1.00 62.00           C  
ATOM    102  CD  GLU A  18     -25.400  28.613   2.355  1.00 62.53           C  
ATOM    103  OE1 GLU A  18     -25.922  27.662   2.976  1.00 63.94           O  
ATOM    104  OE2 GLU A  18     -26.101  29.376   1.644  1.00 63.41           O  
ATOM    105  N   ALA A  19     -24.410  33.518   1.817  1.00 57.67           N  
ATOM    106  CA  ALA A  19     -24.834  34.842   2.238  1.00 56.69           C  
ATOM    107  C   ALA A  19     -26.201  35.204   1.641  1.00 56.37           C  
ATOM    108  O   ALA A  19     -26.917  36.049   2.188  1.00 56.17           O  
ATOM    109  CB  ALA A  19     -23.793  35.878   1.843  1.00 56.80           C  
ATOM    110  N   ALA A  20     -26.552  34.571   0.523  1.00 55.56           N  
ATOM    111  CA  ALA A  20     -27.833  34.794  -0.149  1.00 54.82           C  
ATOM    112  C   ALA A  20     -28.992  34.234   0.665  1.00 54.61           C  
ATOM    113  O   ALA A  20     -30.009  34.911   0.890  1.00 54.50           O  
ATOM    114  CB  ALA A  20     -27.811  34.183  -1.537  1.00 55.24           C  
ATOM    115  N   GLU A  21     -28.840  32.979   1.076  1.00 54.11           N  
ATOM    116  CA  GLU A  21     -29.723  32.344   2.034  1.00 53.73           C  
ATOM    117  C   GLU A  21     -29.958  33.222   3.278  1.00 53.06           C  
ATOM    118  O   GLU A  21     -31.097  33.485   3.624  1.00 52.74           O  
ATOM    119  CB  GLU A  21     -29.163  30.991   2.449  1.00 54.02           C  
ATOM    120  CG  GLU A  21     -30.038  30.255   3.453  1.00 55.44           C  
ATOM    121  CD  GLU A  21     -29.251  29.282   4.318  1.00 56.06           C  
ATOM    122  OE1 GLU A  21     -29.796  28.863   5.369  1.00 56.68           O  
ATOM    123  OE2 GLU A  21     -28.095  28.930   3.956  1.00 56.60           O  
ATOM    124  N   ARG A  22     -28.883  33.666   3.930  1.00 52.32           N  
ATOM    125  CA  ARG A  22     -28.984  34.512   5.133  1.00 51.93           C  
ATOM    126  C   ARG A  22     -29.634  35.885   4.878  1.00 51.36           C  
ATOM    127  O   ARG A  22     -30.417  36.363   5.703  1.00 51.68           O  
ATOM    128  CB  ARG A  22     -27.620  34.669   5.815  1.00 51.48           C  
ATOM    129  N   ALA A  23     -29.327  36.492   3.733  1.00 50.57           N  
ATOM    130  CA  ALA A  23     -29.869  37.793   3.384  1.00 49.84           C  
ATOM    131  C   ALA A  23     -31.332  37.731   2.943  1.00 49.68           C  
ATOM    132  O   ALA A  23     -32.136  38.557   3.387  1.00 49.51           O  
ATOM    133  CB  ALA A  23     -29.023  38.470   2.328  1.00 49.69           C  
ATOM    134  N   PHE A  24     -31.673  36.770   2.072  1.00 49.02           N  
ATOM    135  CA  PHE A  24     -33.064  36.560   1.672  1.00 47.91           C  
ATOM    136  C   PHE A  24     -33.868  36.194   2.879  1.00 47.61           C  
ATOM    137  O   PHE A  24     -35.006  36.591   2.985  1.00 47.88           O  
ATOM    138  CB  PHE A  24     -33.228  35.444   0.632  1.00 47.99           C  
ATOM    139  CG  PHE A  24     -32.677  35.769  -0.731  1.00 47.54           C  
ATOM    140  CD1 PHE A  24     -32.378  34.740  -1.617  1.00 47.79           C  
ATOM    141  CD2 PHE A  24     -32.467  37.091  -1.139  1.00 47.62           C  
ATOM    142  CE1 PHE A  24     -31.879  35.017  -2.896  1.00 47.61           C  
ATOM    143  CE2 PHE A  24     -31.996  37.387  -2.405  1.00 46.68           C  
ATOM    144  CZ  PHE A  24     -31.686  36.347  -3.288  1.00 47.54           C  
ATOM    145  N   TYR A  25     -33.294  35.411   3.788  1.00 47.33           N  
ATOM    146  CA  TYR A  25     -34.015  35.029   5.008  1.00 47.02           C  
ATOM    147  C   TYR A  25     -34.340  36.215   5.947  1.00 46.86           C  
ATOM    148  O   TYR A  25     -35.414  36.294   6.499  1.00 47.17           O  
ATOM    149  CB  TYR A  25     -33.240  33.944   5.764  1.00 46.15           C  
ATOM    150  CG  TYR A  25     -34.018  33.314   6.878  1.00 45.75           C  
ATOM    151  CD1 TYR A  25     -34.834  32.204   6.642  1.00 45.38           C  
ATOM    152  CD2 TYR A  25     -33.953  33.829   8.169  1.00 45.37           C  
ATOM    153  CE1 TYR A  25     -35.563  31.619   7.665  1.00 45.18           C  
ATOM    154  CE2 TYR A  25     -34.688  33.255   9.203  1.00 45.50           C  
ATOM    155  CZ  TYR A  25     -35.479  32.149   8.940  1.00 45.23           C  
ATOM    156  OH  TYR A  25     -36.190  31.589   9.960  1.00 45.66           O  
ATOM    157  N   LYS A  26     -33.397  37.127   6.143  1.00 47.68           N  
ATOM    158  CA  LYS A  26     -33.607  38.237   7.085  1.00 47.56           C  
ATOM    159  C   LYS A  26     -34.525  39.298   6.478  1.00 47.04           C  
ATOM    160  O   LYS A  26     -35.413  39.823   7.160  1.00 46.90           O  
ATOM    161  CB  LYS A  26     -32.254  38.872   7.485  1.00 48.17           C  
ATOM    162  CG  LYS A  26     -32.107  39.307   8.971  1.00 48.19           C  
ATOM    163  CD  LYS A  26     -33.281  40.160   9.477  1.00 49.12           C  
ATOM    164  CE  LYS A  26     -32.903  41.107  10.639  1.00 48.97           C  
ATOM    165  NZ  LYS A  26     -32.616  40.407  11.931  1.00 49.09           N  
ATOM    166  N   ARG A  27     -34.306  39.587   5.192  1.00 46.16           N  
ATOM    167  CA  ARG A  27     -34.884  40.752   4.533  1.00 45.68           C  
ATOM    168  C   ARG A  27     -35.828  40.427   3.381  1.00 45.51           C  
ATOM    169  O   ARG A  27     -36.502  41.317   2.867  1.00 45.48           O  
ATOM    170  CB  ARG A  27     -33.783  41.697   4.080  1.00 45.69           C  
ATOM    171  N   GLY A  28     -35.868  39.151   2.995  1.00 45.27           N  
ATOM    172  CA  GLY A  28     -36.722  38.635   1.926  1.00 44.74           C  
ATOM    173  C   GLY A  28     -36.134  38.959   0.584  1.00 44.72           C  
ATOM    174  O   GLY A  28     -35.335  39.877   0.497  1.00 44.61           O  
ATOM    175  N   VAL A  29     -36.542  38.222  -0.452  1.00 44.81           N  
ATOM    176  CA  VAL A  29     -36.032  38.393  -1.814  1.00 45.19           C  
ATOM    177  C   VAL A  29     -36.307  39.763  -2.454  1.00 46.54           C  
ATOM    178  O   VAL A  29     -35.413  40.313  -3.111  1.00 46.83           O  
ATOM    179  CB  VAL A  29     -36.534  37.290  -2.758  1.00 45.02           C  
ATOM    180  CG1 VAL A  29     -36.142  37.599  -4.177  1.00 44.26           C  
ATOM    181  CG2 VAL A  29     -35.948  35.958  -2.376  1.00 45.01           C  
ATOM    182  N   ALA A  30     -37.506  40.320  -2.257  1.00 47.47           N  
ATOM    183  CA  ALA A  30     -37.913  41.578  -2.916  1.00 48.78           C  
ATOM    184  C   ALA A  30     -36.935  42.757  -2.783  1.00 49.74           C  
ATOM    185  O   ALA A  30     -36.601  43.432  -3.796  1.00 49.56           O  
ATOM    186  CB  ALA A  30     -39.320  42.006  -2.460  1.00 48.32           C  
ATOM    187  N   ARG A  31     -36.489  43.003  -1.541  1.00 50.71           N  
ATOM    188  CA  ARG A  31     -35.640  44.165  -1.206  1.00 51.62           C  
ATOM    189  C   ARG A  31     -34.179  43.814  -0.868  1.00 52.56           C  
ATOM    190  O   ARG A  31     -33.485  44.553  -0.154  1.00 53.11           O  
ATOM    191  CB  ARG A  31     -36.277  44.988  -0.090  1.00 51.23           C  
ATOM    192  CG  ARG A  31     -37.648  45.537  -0.452  1.00 51.15           C  
ATOM    193  CD  ARG A  31     -38.384  45.947   0.777  1.00 51.33           C  
ATOM    194  NE  ARG A  31     -38.244  44.913   1.790  1.00 51.60           N  
ATOM    195  CZ  ARG A  31     -38.482  45.075   3.088  1.00 51.98           C  
ATOM    196  NH1 ARG A  31     -38.890  46.258   3.578  1.00 51.54           N  
ATOM    197  NH2 ARG A  31     -38.308  44.031   3.898  1.00 51.85           N  
ATOM    198  N   THR A  32     -33.717  42.692  -1.398  1.00 53.47           N  
ATOM    199  CA  THR A  32     -32.336  42.309  -1.282  1.00 54.65           C  
ATOM    200  C   THR A  32     -31.808  42.298  -2.697  1.00 55.20           C  
ATOM    201  O   THR A  32     -32.297  41.558  -3.549  1.00 55.23           O  
ATOM    202  CB  THR A  32     -32.165  40.866  -0.704  1.00 54.46           C  
ATOM    203  OG1 THR A  32     -32.811  40.752   0.564  1.00 54.88           O  
ATOM    204  CG2 THR A  32     -30.705  40.536  -0.513  1.00 54.80           C  
ATOM    205  N   THR A  33     -30.798  43.105  -2.968  1.00 56.20           N  
ATOM    206  CA  THR A  33     -30.192  43.013  -4.284  1.00 57.25           C  
ATOM    207  C   THR A  33     -28.808  42.336  -4.243  1.00 57.88           C  
ATOM    208  O   THR A  33     -28.316  41.984  -3.162  1.00 57.98           O  
ATOM    209  CB  THR A  33     -30.253  44.359  -5.047  1.00 57.09           C  
ATOM    210  OG1 THR A  33     -29.567  44.216  -6.294  1.00 57.49           O  
ATOM    211  CG2 THR A  33     -29.671  45.493  -4.226  1.00 57.05           C  
ATOM    212  N   LEU A  34     -28.212  42.103  -5.411  1.00 58.76           N  
ATOM    213  CA  LEU A  34     -26.895  41.445  -5.480  1.00 59.84           C  
ATOM    214  C   LEU A  34     -25.772  42.264  -4.838  1.00 60.12           C  
ATOM    215  O   LEU A  34     -24.827  41.709  -4.290  1.00 60.09           O  
ATOM    216  CB  LEU A  34     -26.556  40.997  -6.910  1.00 59.61           C  
ATOM    217  CG  LEU A  34     -27.247  39.689  -7.342  1.00 60.06           C  
ATOM    218  CD1 LEU A  34     -28.769  39.851  -7.528  1.00 59.66           C  
ATOM    219  CD2 LEU A  34     -26.615  39.113  -8.612  1.00 59.93           C  
ATOM    220  N   ALA A  35     -25.904  43.585  -4.884  1.00 61.14           N  
ATOM    221  CA  ALA A  35     -25.008  44.476  -4.154  1.00 62.29           C  
ATOM    222  C   ALA A  35     -24.887  44.060  -2.687  1.00 62.77           C  
ATOM    223  O   ALA A  35     -23.789  44.047  -2.128  1.00 63.40           O  
ATOM    224  CB  ALA A  35     -25.492  45.926  -4.260  1.00 61.95           C  
ATOM    225  N   ASP A  36     -26.014  43.709  -2.073  1.00 63.85           N  
ATOM    226  CA  ASP A  36     -26.043  43.437  -0.643  1.00 64.54           C  
ATOM    227  C   ASP A  36     -25.560  42.044  -0.300  1.00 64.56           C  
ATOM    228  O   ASP A  36     -25.020  41.807   0.788  1.00 64.65           O  
ATOM    229  CB  ASP A  36     -27.441  43.632  -0.076  1.00 65.35           C  
ATOM    230  CG  ASP A  36     -27.457  43.569   1.436  1.00 65.90           C  
ATOM    231  OD1 ASP A  36     -26.491  44.092   2.065  1.00 66.33           O  
ATOM    232  OD2 ASP A  36     -28.418  42.981   1.988  1.00 66.27           O  
ATOM    233  N   ILE A  37     -25.769  41.125  -1.234  1.00 64.49           N  
ATOM    234  CA  ILE A  37     -25.307  39.759  -1.089  1.00 64.17           C  
ATOM    235  C   ILE A  37     -23.787  39.745  -1.180  1.00 64.12           C  
ATOM    236  O   ILE A  37     -23.128  38.999  -0.454  1.00 64.47           O  
ATOM    237  CB  ILE A  37     -25.978  38.843  -2.134  1.00 63.96           C  
ATOM    238  CG1 ILE A  37     -27.491  38.757  -1.833  1.00 63.90           C  
ATOM    239  CG2 ILE A  37     -25.284  37.481  -2.189  1.00 63.97           C  
ATOM    240  CD1 ILE A  37     -28.342  38.021  -2.847  1.00 63.31           C  
ATOM    241  N   ALA A  38     -23.238  40.593  -2.048  1.00 64.24           N  
ATOM    242  CA  ALA A  38     -21.777  40.747  -2.193  1.00 64.27           C  
ATOM    243  C   ALA A  38     -21.098  41.093  -0.868  1.00 64.20           C  
ATOM    244  O   ALA A  38     -20.158  40.410  -0.469  1.00 64.52           O  
ATOM    245  CB  ALA A  38     -21.441  41.797  -3.242  1.00 63.98           C  
ATOM    246  N   GLU A  39     -21.572  42.145  -0.193  1.00 64.47           N  
ATOM    247  CA  GLU A  39     -20.954  42.591   1.064  1.00 64.39           C  
ATOM    248  C   GLU A  39     -21.021  41.562   2.193  1.00 64.15           C  
ATOM    249  O   GLU A  39     -20.032  41.370   2.907  1.00 64.21           O  
ATOM    250  CB  GLU A  39     -21.520  43.929   1.549  1.00 64.85           C  
ATOM    251  CG  GLU A  39     -21.063  44.322   2.975  1.00 65.25           C  
ATOM    252  CD  GLU A  39     -19.555  44.569   3.101  1.00 65.63           C  
ATOM    253  OE1 GLU A  39     -19.150  45.748   3.271  1.00 65.69           O  
ATOM    254  OE2 GLU A  39     -18.771  43.591   3.033  1.00 65.88           O  
ATOM    255  N   LEU A  40     -22.175  40.918   2.367  1.00 63.47           N  
ATOM    256  CA  LEU A  40     -22.305  39.895   3.400  1.00 62.99           C  
ATOM    257  C   LEU A  40     -21.319  38.740   3.153  1.00 62.69           C  
ATOM    258  O   LEU A  40     -20.716  38.223   4.093  1.00 62.20           O  
ATOM    259  CB  LEU A  40     -23.759  39.391   3.505  1.00 62.97           C  
ATOM    260  N   ALA A  41     -21.151  38.369   1.885  1.00 62.18           N  
ATOM    261  CA  ALA A  41     -20.246  37.289   1.488  1.00 62.44           C  
ATOM    262  C   ALA A  41     -18.767  37.691   1.605  1.00 62.63           C  
ATOM    263  O   ALA A  41     -17.893  36.834   1.765  1.00 62.42           O  
ATOM    264  CB  ALA A  41     -20.561  36.828   0.068  1.00 62.06           C  
ATOM    265  N   GLY A  42     -18.503  38.993   1.520  1.00 62.83           N  
ATOM    266  CA  GLY A  42     -17.151  39.531   1.596  1.00 63.49           C  
ATOM    267  C   GLY A  42     -16.500  39.609   0.229  1.00 63.77           C  
ATOM    268  O   GLY A  42     -15.437  40.204   0.075  1.00 63.55           O  
ATOM    269  N   VAL A  43     -17.154  39.011  -0.768  1.00 64.12           N  
ATOM    270  CA  VAL A  43     -16.644  39.004  -2.138  1.00 64.39           C  
ATOM    271  C   VAL A  43     -16.755  40.391  -2.752  1.00 64.51           C  
ATOM    272  O   VAL A  43     -17.133  41.350  -2.079  1.00 64.67           O  
ATOM    273  CB  VAL A  43     -17.381  37.972  -3.029  1.00 64.11           C  
ATOM    274  CG1 VAL A  43     -17.088  36.552  -2.550  1.00 64.17           C  
ATOM    275  CG2 VAL A  43     -18.880  38.245  -3.043  1.00 64.24           C  
ATOM    276  N   THR A  44     -16.417  40.487  -4.029  1.00 64.88           N  
ATOM    277  CA  THR A  44     -16.532  41.740  -4.758  1.00 65.12           C  
ATOM    278  C   THR A  44     -17.884  41.750  -5.489  1.00 65.24           C  
ATOM    279  O   THR A  44     -18.605  40.748  -5.475  1.00 65.10           O  
ATOM    280  CB  THR A  44     -15.359  41.917  -5.759  1.00 65.03           C  
ATOM    281  OG1 THR A  44     -15.771  41.514  -7.070  1.00 65.16           O  
ATOM    282  CG2 THR A  44     -14.133  41.094  -5.329  1.00 65.10           C  
ATOM    283  N   ARG A  45     -18.220  42.884  -6.112  1.00 65.58           N  
ATOM    284  CA  ARG A  45     -19.419  43.001  -6.958  1.00 65.60           C  
ATOM    285  C   ARG A  45     -19.318  42.223  -8.278  1.00 65.71           C  
ATOM    286  O   ARG A  45     -20.292  41.601  -8.706  1.00 65.70           O  
ATOM    287  CB  ARG A  45     -19.747  44.463  -7.250  1.00 65.58           C  
ATOM    288  CG  ARG A  45     -20.721  45.077  -6.279  1.00 65.68           C  
ATOM    289  CD  ARG A  45     -21.384  46.306  -6.934  1.00 65.80           C  
ATOM    290  NE  ARG A  45     -22.221  47.004  -5.942  1.00 66.01           N  
ATOM    291  CZ  ARG A  45     -21.727  47.963  -5.130  1.00 66.03           C  
ATOM    292  NH1 ARG A  45     -20.396  48.355  -5.183  1.00 66.10           N  
ATOM    293  NH2 ARG A  45     -22.576  48.527  -4.256  1.00 66.07           N  
ATOM    294  N   GLY A  46     -18.147  42.266  -8.917  1.00 65.46           N  
ATOM    295  CA  GLY A  46     -17.911  41.541 -10.167  1.00 65.38           C  
ATOM    296  C   GLY A  46     -17.854  40.040  -9.965  1.00 65.41           C  
ATOM    297  O   GLY A  46     -18.166  39.266 -10.875  1.00 65.46           O  
ATOM    298  N   ALA A  47     -17.444  39.631  -8.767  1.00 65.35           N  
ATOM    299  CA  ALA A  47     -17.558  38.241  -8.350  1.00 65.48           C  
ATOM    300  C   ALA A  47     -18.985  37.739  -8.587  1.00 65.45           C  
ATOM    301  O   ALA A  47     -19.175  36.758  -9.313  1.00 65.75           O  
ATOM    302  CB  ALA A  47     -17.159  38.081  -6.888  1.00 65.36           C  
ATOM    303  N   ILE A  48     -19.981  38.433  -8.020  1.00 65.45           N  
ATOM    304  CA  ILE A  48     -21.396  38.005  -8.116  1.00 65.23           C  
ATOM    305  C   ILE A  48     -21.900  37.963  -9.557  1.00 65.25           C  
ATOM    306  O   ILE A  48     -22.608  37.042  -9.930  1.00 65.42           O  
ATOM    307  CB  ILE A  48     -22.387  38.901  -7.308  1.00 65.12           C  
ATOM    308  CG1 ILE A  48     -21.669  39.888  -6.395  1.00 65.22           C  
ATOM    309  CG2 ILE A  48     -23.346  38.057  -6.500  1.00 64.92           C  
ATOM    310  CD1 ILE A  48     -22.376  41.217  -6.303  1.00 65.32           C  
ATOM    311  N   TYR A  49     -21.526  38.959 -10.358  1.00 65.37           N  
ATOM    312  CA  TYR A  49     -22.059  39.115 -11.722  1.00 65.37           C  
ATOM    313  C   TYR A  49     -21.478  38.134 -12.729  1.00 65.16           C  
ATOM    314  O   TYR A  49     -22.124  37.806 -13.724  1.00 65.03           O  
ATOM    315  CB  TYR A  49     -21.893  40.558 -12.212  1.00 65.52           C  
ATOM    316  CG  TYR A  49     -22.668  41.537 -11.368  1.00 65.81           C  
ATOM    317  CD1 TYR A  49     -22.061  42.682 -10.849  1.00 65.91           C  
ATOM    318  CD2 TYR A  49     -24.014  41.305 -11.067  1.00 65.80           C  
ATOM    319  CE1 TYR A  49     -22.789  43.581 -10.056  1.00 66.19           C  
ATOM    320  CE2 TYR A  49     -24.746  42.189 -10.284  1.00 66.04           C  
ATOM    321  CZ  TYR A  49     -24.131  43.320  -9.781  1.00 66.03           C  
ATOM    322  OH  TYR A  49     -24.865  44.185  -9.010  1.00 66.39           O  
ATOM    323  N   TRP A  50     -20.255  37.688 -12.464  1.00 64.96           N  
ATOM    324  CA  TRP A  50     -19.658  36.566 -13.171  1.00 64.68           C  
ATOM    325  C   TRP A  50     -20.423  35.297 -12.817  1.00 64.36           C  
ATOM    326  O   TRP A  50     -20.851  34.545 -13.696  1.00 64.21           O  
ATOM    327  CB  TRP A  50     -18.211  36.413 -12.738  1.00 64.99           C  
ATOM    328  CG  TRP A  50     -17.402  35.530 -13.624  1.00 65.42           C  
ATOM    329  CD1 TRP A  50     -16.960  35.821 -14.885  1.00 65.34           C  
ATOM    330  CD2 TRP A  50     -16.908  34.219 -13.311  1.00 65.48           C  
ATOM    331  NE1 TRP A  50     -16.232  34.766 -15.383  1.00 65.62           N  
ATOM    332  CE2 TRP A  50     -16.175  33.773 -14.438  1.00 65.54           C  
ATOM    333  CE3 TRP A  50     -17.010  33.380 -12.188  1.00 65.47           C  
ATOM    334  CZ2 TRP A  50     -15.545  32.516 -14.479  1.00 65.63           C  
ATOM    335  CZ3 TRP A  50     -16.385  32.131 -12.226  1.00 65.58           C  
ATOM    336  CH2 TRP A  50     -15.662  31.711 -13.368  1.00 65.62           C  
ATOM    337  N   HIS A  51     -20.603  35.092 -11.513  1.00 63.80           N  
ATOM    338  CA  HIS A  51     -21.297  33.938 -10.981  1.00 63.20           C  
ATOM    339  C   HIS A  51     -22.785  33.922 -11.358  1.00 62.68           C  
ATOM    340  O   HIS A  51     -23.257  32.977 -11.992  1.00 62.34           O  
ATOM    341  CB  HIS A  51     -21.122  33.885  -9.460  1.00 63.66           C  
ATOM    342  CG  HIS A  51     -19.733  33.537  -9.017  1.00 63.79           C  
ATOM    343  ND1 HIS A  51     -19.316  32.236  -8.831  1.00 64.00           N  
ATOM    344  CD2 HIS A  51     -18.675  34.318  -8.700  1.00 63.85           C  
ATOM    345  CE1 HIS A  51     -18.055  32.232  -8.436  1.00 63.97           C  
ATOM    346  NE2 HIS A  51     -17.642  33.483  -8.345  1.00 64.01           N  
ATOM    347  N   PHE A  52     -23.505  34.978 -10.985  1.00 61.58           N  
ATOM    348  CA  PHE A  52     -24.957  35.057 -11.174  1.00 60.87           C  
ATOM    349  C   PHE A  52     -25.391  36.334 -11.896  1.00 60.64           C  
ATOM    350  O   PHE A  52     -25.224  37.436 -11.365  1.00 60.78           O  
ATOM    351  CB  PHE A  52     -25.688  34.954  -9.819  1.00 60.20           C  
ATOM    352  CG  PHE A  52     -25.274  33.770  -8.994  1.00 59.52           C  
ATOM    353  CD1 PHE A  52     -24.315  33.909  -7.988  1.00 59.07           C  
ATOM    354  CD2 PHE A  52     -25.836  32.514  -9.226  1.00 59.19           C  
ATOM    355  CE1 PHE A  52     -23.926  32.825  -7.241  1.00 58.53           C  
ATOM    356  CE2 PHE A  52     -25.449  31.423  -8.475  1.00 58.85           C  
ATOM    357  CZ  PHE A  52     -24.490  31.583  -7.477  1.00 58.76           C  
ATOM    358  N   ASN A  53     -25.958  36.164 -13.097  1.00 60.41           N  
ATOM    359  CA  ASN A  53     -26.475  37.268 -13.924  1.00 59.90           C  
ATOM    360  C   ASN A  53     -27.395  38.230 -13.186  1.00 59.67           C  
ATOM    361  O   ASN A  53     -27.297  39.445 -13.364  1.00 59.49           O  
ATOM    362  CB  ASN A  53     -27.222  36.720 -15.141  1.00 59.93           C  
ATOM    363  CG  ASN A  53     -26.291  36.256 -16.233  1.00 59.95           C  
ATOM    364  OD1 ASN A  53     -25.658  37.063 -16.923  1.00 59.79           O  
ATOM    365  ND2 ASN A  53     -26.207  34.943 -16.403  1.00 59.97           N  
ATOM    366  N   ASN A  54     -28.291  37.667 -12.373  1.00 59.39           N  
ATOM    367  CA  ASN A  54     -29.279  38.428 -11.605  1.00 58.92           C  
ATOM    368  C   ASN A  54     -29.904  37.540 -10.534  1.00 58.57           C  
ATOM    369  O   ASN A  54     -29.601  36.345 -10.468  1.00 58.50           O  
ATOM    370  CB  ASN A  54     -30.373  38.976 -12.526  1.00 59.25           C  
ATOM    371  CG  ASN A  54     -31.181  37.874 -13.190  1.00 59.34           C  
ATOM    372  OD1 ASN A  54     -30.637  36.839 -13.577  1.00 59.85           O  
ATOM    373  ND2 ASN A  54     -32.487  38.089 -13.312  1.00 59.71           N  
ATOM    374  N   LYS A  55     -30.788  38.139  -9.733  1.00 57.87           N  
ATOM    375  CA  LYS A  55     -31.426  37.527  -8.560  1.00 57.31           C  
ATOM    376  C   LYS A  55     -32.220  36.261  -8.838  1.00 57.12           C  
ATOM    377  O   LYS A  55     -32.180  35.315  -8.042  1.00 56.89           O  
ATOM    378  CB  LYS A  55     -32.351  38.551  -7.907  1.00 57.63           C  
ATOM    379  CG  LYS A  55     -32.500  38.411  -6.409  1.00 57.49           C  
ATOM    380  CD  LYS A  55     -32.700  39.781  -5.789  1.00 57.44           C  
ATOM    381  CE  LYS A  55     -34.146  40.270  -5.916  1.00 57.37           C  
ATOM    382  NZ  LYS A  55     -34.264  41.700  -5.497  1.00 57.35           N  
ATOM    383  N   ALA A  56     -32.945  36.248  -9.953  1.00 56.57           N  
ATOM    384  CA  ALA A  56     -33.734  35.080 -10.353  1.00 56.40           C  
ATOM    385  C   ALA A  56     -32.883  33.826 -10.554  1.00 56.20           C  
ATOM    386  O   ALA A  56     -33.340  32.713 -10.331  1.00 55.76           O  
ATOM    387  CB  ALA A  56     -34.524  35.385 -11.608  1.00 56.39           C  
ATOM    388  N   GLU A  57     -31.637  34.038 -10.960  1.00 56.28           N  
ATOM    389  CA  GLU A  57     -30.694  32.970 -11.265  1.00 56.16           C  
ATOM    390  C   GLU A  57     -30.153  32.371  -9.967  1.00 56.03           C  
ATOM    391  O   GLU A  57     -29.880  31.166  -9.891  1.00 55.89           O  
ATOM    392  CB  GLU A  57     -29.549  33.535 -12.105  1.00 56.48           C  
ATOM    393  CG  GLU A  57     -29.094  32.615 -13.215  1.00 56.94           C  
ATOM    394  CD  GLU A  57     -27.588  32.635 -13.420  1.00 56.95           C  
ATOM    395  OE1 GLU A  57     -27.022  33.717 -13.695  1.00 57.00           O  
ATOM    396  OE2 GLU A  57     -26.970  31.550 -13.316  1.00 57.22           O  
ATOM    397  N   LEU A  58     -30.032  33.224  -8.952  1.00 55.68           N  
ATOM    398  CA  LEU A  58     -29.573  32.845  -7.617  1.00 55.61           C  
ATOM    399  C   LEU A  58     -30.662  32.120  -6.828  1.00 55.79           C  
ATOM    400  O   LEU A  58     -30.404  31.094  -6.187  1.00 56.21           O  
ATOM    401  CB  LEU A  58     -29.096  34.093  -6.874  1.00 55.24           C  
ATOM    402  CG  LEU A  58     -28.475  34.091  -5.479  1.00 55.16           C  
ATOM    403  CD1 LEU A  58     -27.619  32.849  -5.190  1.00 54.96           C  
ATOM    404  CD2 LEU A  58     -27.657  35.370  -5.341  1.00 54.90           C  
ATOM    405  N   VAL A  59     -31.880  32.660  -6.870  1.00 56.01           N  
ATOM    406  CA  VAL A  59     -33.063  31.993  -6.314  1.00 55.89           C  
ATOM    407  C   VAL A  59     -33.171  30.558  -6.836  1.00 55.92           C  
ATOM    408  O   VAL A  59     -33.397  29.638  -6.065  1.00 55.96           O  
ATOM    409  CB  VAL A  59     -34.365  32.829  -6.593  1.00 55.84           C  
ATOM    410  CG1 VAL A  59     -35.628  32.033  -6.309  1.00 55.68           C  
ATOM    411  CG2 VAL A  59     -34.350  34.120  -5.781  1.00 55.55           C  
ATOM    412  N   GLN A  60     -32.969  30.372  -8.135  1.00 56.57           N  
ATOM    413  CA  GLN A  60     -33.008  29.047  -8.750  1.00 57.43           C  
ATOM    414  C   GLN A  60     -31.887  28.132  -8.277  1.00 57.34           C  
ATOM    415  O   GLN A  60     -32.080  26.925  -8.210  1.00 57.68           O  
ATOM    416  CB  GLN A  60     -32.988  29.156 -10.281  1.00 58.14           C  
ATOM    417  CG  GLN A  60     -32.968  27.817 -11.047  1.00 59.46           C  
ATOM    418  CD  GLN A  60     -34.237  26.974 -10.854  1.00 59.72           C  
ATOM    419  OE1 GLN A  60     -34.504  26.455  -9.768  1.00 60.39           O  
ATOM    420  NE2 GLN A  60     -35.005  26.817 -11.924  1.00 60.40           N  
ATOM    421  N   ALA A  61     -30.726  28.703  -7.956  1.00 57.60           N  
ATOM    422  CA  ALA A  61     -29.597  27.937  -7.389  1.00 57.88           C  
ATOM    423  C   ALA A  61     -29.901  27.336  -5.997  1.00 58.12           C  
ATOM    424  O   ALA A  61     -29.540  26.177  -5.721  1.00 57.88           O  
ATOM    425  CB  ALA A  61     -28.334  28.788  -7.343  1.00 57.22           C  
ATOM    426  N   LEU A  62     -30.543  28.132  -5.133  1.00 58.38           N  
ATOM    427  CA  LEU A  62     -30.997  27.671  -3.809  1.00 59.26           C  
ATOM    428  C   LEU A  62     -32.031  26.550  -3.925  1.00 59.52           C  
ATOM    429  O   LEU A  62     -31.879  25.498  -3.308  1.00 59.20           O  
ATOM    430  CB  LEU A  62     -31.590  28.820  -2.974  1.00 58.98           C  
ATOM    431  CG  LEU A  62     -30.730  30.021  -2.560  1.00 59.21           C  
ATOM    432  CD1 LEU A  62     -31.506  30.853  -1.542  1.00 58.92           C  
ATOM    433  CD2 LEU A  62     -29.387  29.586  -2.002  1.00 58.70           C  
ATOM    434  N   LEU A  63     -33.073  26.800  -4.717  1.00 60.48           N  
ATOM    435  CA  LEU A  63     -34.102  25.808  -5.045  1.00 61.43           C  
ATOM    436  C   LEU A  63     -33.504  24.512  -5.612  1.00 62.08           C  
ATOM    437  O   LEU A  63     -34.042  23.425  -5.368  1.00 62.32           O  
ATOM    438  CB  LEU A  63     -35.153  26.436  -5.986  1.00 61.48           C  
ATOM    439  CG  LEU A  63     -36.128  25.688  -6.913  1.00 61.40           C  
ATOM    440  CD1 LEU A  63     -36.742  24.417  -6.309  1.00 62.05           C  
ATOM    441  CD2 LEU A  63     -37.233  26.628  -7.363  1.00 61.65           C  
ATOM    442  N   ASP A  64     -32.382  24.627  -6.332  1.00 62.86           N  
ATOM    443  CA  ASP A  64     -31.676  23.457  -6.876  1.00 63.65           C  
ATOM    444  C   ASP A  64     -30.894  22.650  -5.837  1.00 63.87           C  
ATOM    445  O   ASP A  64     -30.811  21.423  -5.930  1.00 63.81           O  
ATOM    446  CB  ASP A  64     -30.741  23.868  -8.014  1.00 64.14           C  
ATOM    447  CG  ASP A  64     -31.457  23.989  -9.350  1.00 64.55           C  
ATOM    448  OD1 ASP A  64     -32.712  23.927  -9.378  1.00 64.79           O  
ATOM    449  OD2 ASP A  64     -30.756  24.152 -10.379  1.00 64.82           O  
ATOM    450  N   SER A  65     -30.307  23.345  -4.866  1.00 64.08           N  
ATOM    451  CA  SER A  65     -29.601  22.708  -3.757  1.00 64.39           C  
ATOM    452  C   SER A  65     -30.500  21.776  -2.925  1.00 64.65           C  
ATOM    453  O   SER A  65     -29.997  20.933  -2.170  1.00 64.80           O  
ATOM    454  CB  SER A  65     -28.980  23.773  -2.853  1.00 64.50           C  
ATOM    455  OG  SER A  65     -29.991  24.462  -2.126  1.00 64.51           O  
ATOM    456  N   LEU A  66     -31.818  21.939  -3.073  1.00 64.93           N  
ATOM    457  CA  LEU A  66     -32.825  21.104  -2.395  1.00 65.17           C  
ATOM    458  C   LEU A  66     -32.998  19.701  -2.999  1.00 65.42           C  
ATOM    459  O   LEU A  66     -33.509  18.793  -2.325  1.00 65.30           O  
ATOM    460  CB  LEU A  66     -34.193  21.807  -2.392  1.00 64.90           C  
ATOM    461  CG  LEU A  66     -34.432  23.060  -1.545  1.00 64.72           C  
ATOM    462  CD1 LEU A  66     -35.851  23.597  -1.779  1.00 64.15           C  
ATOM    463  CD2 LEU A  66     -34.166  22.786  -0.061  1.00 64.33           C  
ATOM    464  N   HIS A  67     -32.599  19.541  -4.267  1.00 65.78           N  
ATOM    465  CA  HIS A  67     -32.776  18.282  -4.987  1.00 66.32           C  
ATOM    466  C   HIS A  67     -31.712  17.265  -4.620  1.00 66.36           C  
ATOM    467  O   HIS A  67     -32.003  16.069  -4.553  1.00 66.35           O  
ATOM    468  CB  HIS A  67     -32.770  18.474  -6.514  1.00 66.84           C  
ATOM    469  CG  HIS A  67     -33.899  19.309  -7.032  1.00 67.44           C  
ATOM    470  ND1 HIS A  67     -35.189  19.209  -6.551  1.00 67.75           N  
ATOM    471  CD2 HIS A  67     -33.936  20.248  -8.008  1.00 67.66           C  
ATOM    472  CE1 HIS A  67     -35.968  20.060  -7.197  1.00 67.75           C  
ATOM    473  NE2 HIS A  67     -35.232  20.705  -8.086  1.00 67.91           N  
ATOM    474  N   GLU A  68     -30.488  17.741  -4.390  1.00 66.38           N  
ATOM    475  CA  GLU A  68     -29.327  16.864  -4.193  1.00 66.46           C  
ATOM    476  C   GLU A  68     -29.607  15.686  -3.242  1.00 66.45           C  
ATOM    477  O   GLU A  68     -29.360  14.521  -3.588  1.00 66.39           O  
ATOM    478  CB  GLU A  68     -28.105  17.675  -3.730  1.00 66.31           C  
ATOM    479  N   THR A  69     -30.158  16.007  -2.070  1.00 66.46           N  
ATOM    480  CA  THR A  69     -30.346  15.056  -0.966  1.00 66.55           C  
ATOM    481  C   THR A  69     -31.373  13.963  -1.273  1.00 66.62           C  
ATOM    482  O   THR A  69     -31.307  12.869  -0.706  1.00 66.41           O  
ATOM    483  CB  THR A  69     -30.749  15.797   0.340  1.00 66.61           C  
ATOM    484  OG1 THR A  69     -29.896  16.933   0.535  1.00 66.59           O  
ATOM    485  CG2 THR A  69     -30.652  14.877   1.560  1.00 66.52           C  
ATOM    486  N   HIS A  70     -32.305  14.267  -2.178  1.00 66.68           N  
ATOM    487  CA  HIS A  70     -33.420  13.374  -2.511  1.00 66.63           C  
ATOM    488  C   HIS A  70     -33.267  12.695  -3.869  1.00 66.56           C  
ATOM    489  O   HIS A  70     -34.113  11.893  -4.270  1.00 66.36           O  
ATOM    490  CB  HIS A  70     -34.735  14.153  -2.474  1.00 66.71           C  
ATOM    491  CG  HIS A  70     -34.858  15.063  -1.296  1.00 66.71           C  
ATOM    492  ND1 HIS A  70     -34.679  14.629   0.001  1.00 66.52           N  
ATOM    493  CD2 HIS A  70     -35.140  16.387  -1.217  1.00 66.72           C  
ATOM    494  CE1 HIS A  70     -34.846  15.646   0.827  1.00 66.71           C  
ATOM    495  NE2 HIS A  70     -35.128  16.724   0.114  1.00 66.70           N  
ATOM    496  N   ASP A  71     -32.174  13.008  -4.555  1.00 66.54           N  
ATOM    497  CA  ASP A  71     -31.960  12.596  -5.933  1.00 66.57           C  
ATOM    498  C   ASP A  71     -32.236  11.117  -6.189  1.00 66.56           C  
ATOM    499  O   ASP A  71     -33.215  10.779  -6.862  1.00 66.55           O  
ATOM    500  CB  ASP A  71     -30.542  12.973  -6.370  1.00 67.00           C  
ATOM    501  CG  ASP A  71     -30.233  12.548  -7.794  1.00 67.24           C  
ATOM    502  OD1 ASP A  71     -29.951  11.347  -8.029  1.00 67.41           O  
ATOM    503  OD2 ASP A  71     -30.266  13.425  -8.677  1.00 67.39           O  
ATOM    504  N   HIS A  72     -31.371  10.260  -5.637  1.00 66.51           N  
ATOM    505  CA  HIS A  72     -31.352   8.817  -5.902  1.00 66.09           C  
ATOM    506  C   HIS A  72     -32.701   8.123  -5.774  1.00 65.78           C  
ATOM    507  O   HIS A  72     -33.099   7.385  -6.678  1.00 65.67           O  
ATOM    508  CB  HIS A  72     -30.313   8.132  -5.007  1.00 66.74           C  
ATOM    509  CG  HIS A  72     -30.724   6.773  -4.529  1.00 67.12           C  
ATOM    510  ND1 HIS A  72     -30.724   5.661  -5.347  1.00 67.24           N  
ATOM    511  CD2 HIS A  72     -31.163   6.351  -3.317  1.00 67.12           C  
ATOM    512  CE1 HIS A  72     -31.141   4.612  -4.659  1.00 67.32           C  
ATOM    513  NE2 HIS A  72     -31.415   5.005  -3.424  1.00 67.31           N  
ATOM    514  N   LEU A  73     -33.385   8.365  -4.653  1.00 65.10           N  
ATOM    515  CA  LEU A  73     -34.680   7.751  -4.352  1.00 64.54           C  
ATOM    516  C   LEU A  73     -35.769   8.145  -5.339  1.00 64.35           C  
ATOM    517  O   LEU A  73     -36.716   7.391  -5.545  1.00 64.23           O  
ATOM    518  CB  LEU A  73     -35.132   8.125  -2.935  1.00 64.64           C  
ATOM    519  CG  LEU A  73     -34.575   7.352  -1.725  1.00 64.58           C  
ATOM    520  CD1 LEU A  73     -34.735   8.159  -0.432  1.00 64.53           C  
ATOM    521  CD2 LEU A  73     -35.253   5.977  -1.605  1.00 64.78           C  
ATOM    522  N   ALA A  74     -35.630   9.336  -5.927  1.00 64.12           N  
ATOM    523  CA  ALA A  74     -36.614   9.887  -6.867  1.00 63.75           C  
ATOM    524  C   ALA A  74     -36.508   9.276  -8.258  1.00 63.49           C  
ATOM    525  O   ALA A  74     -37.524   8.963  -8.865  1.00 63.35           O  
ATOM    526  CB  ALA A  74     -36.497  11.408  -6.949  1.00 63.89           C  
ATOM    527  N   ARG A  75     -35.289   9.122  -8.767  1.00 63.22           N  
ATOM    528  CA  ARG A  75     -35.087   8.477 -10.069  1.00 63.03           C  
ATOM    529  C   ARG A  75     -35.403   6.972 -10.022  1.00 62.58           C  
ATOM    530  O   ARG A  75     -35.851   6.401 -11.017  1.00 62.07           O  
ATOM    531  CB  ARG A  75     -33.676   8.748 -10.611  1.00 63.40           C  
ATOM    532  CG  ARG A  75     -33.523   8.533 -12.128  1.00 63.82           C  
ATOM    533  CD  ARG A  75     -32.410   9.410 -12.717  1.00 64.07           C  
ATOM    534  NE  ARG A  75     -31.640   8.741 -13.777  1.00 64.17           N  
ATOM    535  CZ  ARG A  75     -30.604   9.286 -14.419  1.00 64.33           C  
ATOM    536  NH1 ARG A  75     -30.194  10.520 -14.122  1.00 64.28           N  
ATOM    537  NH2 ARG A  75     -29.969   8.600 -15.365  1.00 64.17           N  
ATOM    538  N   ALA A  76     -35.194   6.353  -8.857  1.00 62.08           N  
ATOM    539  CA  ALA A  76     -35.534   4.943  -8.641  1.00 61.98           C  
ATOM    540  C   ALA A  76     -37.048   4.750  -8.555  1.00 61.80           C  
ATOM    541  O   ALA A  76     -37.613   3.874  -9.211  1.00 61.63           O  
ATOM    542  CB  ALA A  76     -34.842   4.407  -7.389  1.00 61.91           C  
ATOM    543  N   SER A  77     -37.694   5.586  -7.748  1.00 61.74           N  
ATOM    544  CA  SER A  77     -39.155   5.704  -7.711  1.00 61.70           C  
ATOM    545  C   SER A  77     -39.800   5.820  -9.091  1.00 61.64           C  
ATOM    546  O   SER A  77     -40.953   5.438  -9.282  1.00 61.31           O  
ATOM    547  CB  SER A  77     -39.547   6.927  -6.877  1.00 61.76           C  
ATOM    548  OG  SER A  77     -40.330   7.847  -7.635  1.00 62.03           O  
ATOM    549  N   GLU A  78     -39.043   6.358 -10.040  1.00 61.66           N  
ATOM    550  CA  GLU A  78     -39.584   6.745 -11.328  1.00 61.90           C  
ATOM    551  C   GLU A  78     -39.256   5.780 -12.459  1.00 61.86           C  
ATOM    552  O   GLU A  78     -39.967   5.758 -13.466  1.00 61.83           O  
ATOM    553  CB  GLU A  78     -39.150   8.172 -11.677  1.00 62.05           C  
ATOM    554  CG  GLU A  78     -39.832   9.233 -10.829  1.00 62.47           C  
ATOM    555  CD  GLU A  78     -39.119  10.571 -10.876  1.00 62.70           C  
ATOM    556  OE1 GLU A  78     -38.710  10.987 -11.983  1.00 63.06           O  
ATOM    557  OE2 GLU A  78     -38.970  11.207  -9.804  1.00 62.65           O  
ATOM    558  N   SER A  79     -38.195   4.987 -12.301  1.00 61.99           N  
ATOM    559  CA  SER A  79     -37.852   3.973 -13.305  1.00 61.91           C  
ATOM    560  C   SER A  79     -38.864   2.838 -13.275  1.00 61.89           C  
ATOM    561  O   SER A  79     -39.224   2.338 -12.208  1.00 61.79           O  
ATOM    562  CB  SER A  79     -36.429   3.434 -13.110  1.00 62.00           C  
ATOM    563  OG  SER A  79     -36.072   2.522 -14.141  1.00 62.13           O  
ATOM    564  N   GLU A  80     -39.318   2.453 -14.461  1.00 61.88           N  
ATOM    565  CA  GLU A  80     -40.314   1.402 -14.622  1.00 61.94           C  
ATOM    566  C   GLU A  80     -39.726  -0.010 -14.398  1.00 61.57           C  
ATOM    567  O   GLU A  80     -40.461  -1.001 -14.392  1.00 61.50           O  
ATOM    568  CB  GLU A  80     -40.971   1.529 -16.009  1.00 62.37           C  
ATOM    569  CG  GLU A  80     -42.243   0.688 -16.219  1.00 62.74           C  
ATOM    570  CD  GLU A  80     -42.769   0.755 -17.649  1.00 62.83           C  
ATOM    571  OE1 GLU A  80     -42.783   1.861 -18.238  1.00 63.11           O  
ATOM    572  OE2 GLU A  80     -43.178  -0.300 -18.177  1.00 62.85           O  
ATOM    573  N   ASP A  81     -38.409  -0.094 -14.205  1.00 61.03           N  
ATOM    574  CA  ASP A  81     -37.757  -1.363 -13.848  1.00 60.61           C  
ATOM    575  C   ASP A  81     -37.926  -1.710 -12.364  1.00 60.32           C  
ATOM    576  O   ASP A  81     -38.281  -2.845 -12.022  1.00 60.47           O  
ATOM    577  CB  ASP A  81     -36.276  -1.359 -14.243  1.00 60.48           C  
ATOM    578  CG  ASP A  81     -36.066  -1.555 -15.742  1.00 60.45           C  
ATOM    579  OD1 ASP A  81     -36.667  -2.489 -16.327  1.00 60.22           O  
ATOM    580  OD2 ASP A  81     -35.289  -0.773 -16.334  1.00 60.38           O  
ATOM    581  N   GLU A  82     -37.665  -0.726 -11.502  1.00 59.82           N  
ATOM    582  CA  GLU A  82     -37.884  -0.811 -10.052  1.00 59.41           C  
ATOM    583  C   GLU A  82     -39.231  -1.457  -9.698  1.00 59.22           C  
ATOM    584  O   GLU A  82     -40.268  -1.105 -10.264  1.00 58.97           O  
ATOM    585  CB  GLU A  82     -37.777   0.592  -9.441  1.00 59.25           C  
ATOM    586  CG  GLU A  82     -38.044   0.691  -7.950  1.00 59.18           C  
ATOM    587  CD  GLU A  82     -36.800   0.514  -7.096  1.00 59.16           C  
ATOM    588  OE1 GLU A  82     -35.735   1.079  -7.422  1.00 59.07           O  
ATOM    589  OE2 GLU A  82     -36.892  -0.183  -6.071  1.00 59.29           O  
ATOM    590  N   VAL A  83     -39.202  -2.400  -8.759  1.00 59.02           N  
ATOM    591  CA  VAL A  83     -40.391  -3.189  -8.416  1.00 58.86           C  
ATOM    592  C   VAL A  83     -41.220  -2.691  -7.216  1.00 58.66           C  
ATOM    593  O   VAL A  83     -42.347  -3.150  -7.020  1.00 58.82           O  
ATOM    594  CB  VAL A  83     -40.073  -4.704  -8.262  1.00 58.90           C  
ATOM    595  CG1 VAL A  83     -39.782  -5.325  -9.625  1.00 58.99           C  
ATOM    596  CG2 VAL A  83     -38.925  -4.943  -7.278  1.00 58.98           C  
ATOM    597  N   ASP A  84     -40.671  -1.765  -6.425  1.00 58.21           N  
ATOM    598  CA  ASP A  84     -41.412  -1.155  -5.298  1.00 57.81           C  
ATOM    599  C   ASP A  84     -41.371   0.395  -5.360  1.00 57.48           C  
ATOM    600  O   ASP A  84     -40.850   1.061  -4.455  1.00 57.39           O  
ATOM    601  CB  ASP A  84     -40.904  -1.714  -3.951  1.00 57.67           C  
ATOM    602  CG  ASP A  84     -41.661  -1.168  -2.744  1.00 57.67           C  
ATOM    603  OD1 ASP A  84     -42.872  -0.830  -2.874  1.00 57.49           O  
ATOM    604  OD2 ASP A  84     -41.031  -1.087  -1.656  1.00 57.51           O  
ATOM    605  N   PRO A  85     -41.914   0.971  -6.446  1.00 57.09           N  
ATOM    606  CA  PRO A  85     -41.901   2.426  -6.610  1.00 57.03           C  
ATOM    607  C   PRO A  85     -42.687   3.236  -5.562  1.00 56.65           C  
ATOM    608  O   PRO A  85     -42.300   4.371  -5.275  1.00 57.14           O  
ATOM    609  CB  PRO A  85     -42.491   2.623  -8.015  1.00 57.07           C  
ATOM    610  CG  PRO A  85     -42.287   1.284  -8.702  1.00 57.18           C  
ATOM    611  CD  PRO A  85     -42.539   0.309  -7.606  1.00 57.04           C  
ATOM    612  N   LEU A  86     -43.763   2.684  -4.997  1.00 56.23           N  
ATOM    613  CA  LEU A  86     -44.529   3.405  -3.966  1.00 55.42           C  
ATOM    614  C   LEU A  86     -43.762   3.452  -2.642  1.00 55.28           C  
ATOM    615  O   LEU A  86     -43.868   4.421  -1.887  1.00 54.77           O  
ATOM    616  CB  LEU A  86     -45.925   2.802  -3.770  1.00 55.72           C  
ATOM    617  CG  LEU A  86     -46.969   3.622  -2.998  1.00 55.48           C  
ATOM    618  CD1 LEU A  86     -47.434   4.843  -3.790  1.00 55.89           C  
ATOM    619  CD2 LEU A  86     -48.165   2.784  -2.618  1.00 55.78           C  
ATOM    620  N   GLY A  87     -42.984   2.403  -2.380  1.00 54.64           N  
ATOM    621  CA  GLY A  87     -42.064   2.374  -1.248  1.00 54.35           C  
ATOM    622  C   GLY A  87     -40.862   3.296  -1.424  1.00 54.23           C  
ATOM    623  O   GLY A  87     -40.299   3.783  -0.446  1.00 53.80           O  
ATOM    624  N   CYS A  88     -40.455   3.524  -2.668  1.00 54.08           N  
ATOM    625  CA  CYS A  88     -39.418   4.511  -2.961  1.00 54.75           C  
ATOM    626  C   CYS A  88     -39.942   5.944  -2.802  1.00 54.62           C  
ATOM    627  O   CYS A  88     -39.216   6.826  -2.331  1.00 54.56           O  
ATOM    628  CB  CYS A  88     -38.869   4.315  -4.366  1.00 54.58           C  
ATOM    629  SG  CYS A  88     -37.673   2.985  -4.496  1.00 56.30           S  
ATOM    630  N   MET A  89     -41.198   6.157  -3.206  1.00 54.78           N  
ATOM    631  CA  MET A  89     -41.883   7.439  -3.046  1.00 54.82           C  
ATOM    632  C   MET A  89     -42.197   7.718  -1.583  1.00 54.23           C  
ATOM    633  O   MET A  89     -42.110   8.857  -1.140  1.00 54.48           O  
ATOM    634  CB  MET A  89     -43.154   7.500  -3.893  1.00 55.38           C  
ATOM    635  CG  MET A  89     -44.105   8.596  -3.442  1.00 56.76           C  
ATOM    636  SD  MET A  89     -45.113   9.357  -4.721  1.00 57.50           S  
ATOM    637  CE  MET A  89     -46.241   7.994  -5.024  1.00 57.83           C  
ATOM    638  N   ARG A  90     -42.546   6.673  -0.843  1.00 53.72           N  
ATOM    639  CA  ARG A  90     -42.779   6.781   0.590  1.00 53.14           C  
ATOM    640  C   ARG A  90     -41.506   7.196   1.309  1.00 53.04           C  
ATOM    641  O   ARG A  90     -41.545   8.069   2.178  1.00 52.96           O  
ATOM    642  CB  ARG A  90     -43.293   5.452   1.187  1.00 53.05           C  
ATOM    643  CG  ARG A  90     -43.907   5.617   2.575  1.00 52.54           C  
ATOM    644  CD  ARG A  90     -44.293   4.317   3.217  1.00 52.40           C  
ATOM    645  NE  ARG A  90     -43.347   3.962   4.278  1.00 52.37           N  
ATOM    646  CZ  ARG A  90     -43.568   4.111   5.580  1.00 51.97           C  
ATOM    647  NH1 ARG A  90     -44.719   4.585   6.030  1.00 52.03           N  
ATOM    648  NH2 ARG A  90     -42.628   3.777   6.443  1.00 52.14           N  
ATOM    649  N   LYS A  91     -40.388   6.563   0.949  1.00 52.70           N  
ATOM    650  CA  LYS A  91     -39.121   6.784   1.637  1.00 52.51           C  
ATOM    651  C   LYS A  91     -38.524   8.148   1.296  1.00 52.15           C  
ATOM    652  O   LYS A  91     -37.888   8.780   2.139  1.00 51.97           O  
ATOM    653  CB  LYS A  91     -38.126   5.652   1.355  1.00 53.10           C  
ATOM    654  CG  LYS A  91     -37.493   5.077   2.630  1.00 53.66           C  
ATOM    655  CD  LYS A  91     -36.308   4.146   2.344  1.00 54.43           C  
ATOM    656  CE  LYS A  91     -34.962   4.905   2.294  1.00 54.61           C  
ATOM    657  NZ  LYS A  91     -33.770   3.972   2.354  1.00 55.14           N  
ATOM    658  N   LEU A  92     -38.746   8.602   0.065  1.00 51.59           N  
ATOM    659  CA  LEU A  92     -38.472   9.988  -0.308  1.00 51.14           C  
ATOM    660  C   LEU A  92     -39.184  10.985   0.599  1.00 50.87           C  
ATOM    661  O   LEU A  92     -38.566  11.929   1.100  1.00 51.01           O  
ATOM    662  CB  LEU A  92     -38.877  10.254  -1.751  1.00 51.27           C  
ATOM    663  CG  LEU A  92     -38.517  11.647  -2.258  1.00 51.02           C  
ATOM    664  CD1 LEU A  92     -37.939  11.565  -3.651  1.00 51.56           C  
ATOM    665  CD2 LEU A  92     -39.731  12.564  -2.243  1.00 51.49           C  
ATOM    666  N   LEU A  93     -40.483  10.782   0.803  1.00 50.20           N  
ATOM    667  CA  LEU A  93     -41.281  11.739   1.561  1.00 49.39           C  
ATOM    668  C   LEU A  93     -40.872  11.810   3.025  1.00 49.07           C  
ATOM    669  O   LEU A  93     -40.884  12.886   3.624  1.00 48.40           O  
ATOM    670  CB  LEU A  93     -42.775  11.452   1.395  1.00 49.76           C  
ATOM    671  CG  LEU A  93     -43.388  11.808   0.033  1.00 49.29           C  
ATOM    672  CD1 LEU A  93     -44.762  11.201  -0.092  1.00 49.76           C  
ATOM    673  CD2 LEU A  93     -43.456  13.300  -0.138  1.00 49.54           C  
ATOM    674  N   LEU A  94     -40.494  10.653   3.570  1.00 48.73           N  
ATOM    675  CA  LEU A  94     -39.883  10.534   4.890  1.00 48.52           C  
ATOM    676  C   LEU A  94     -38.564  11.299   5.002  1.00 48.22           C  
ATOM    677  O   LEU A  94     -38.313  11.940   6.009  1.00 47.88           O  
ATOM    678  CB  LEU A  94     -39.636   9.061   5.242  1.00 48.87           C  
ATOM    679  CG  LEU A  94     -40.625   8.211   6.060  1.00 49.41           C  
ATOM    680  CD1 LEU A  94     -41.656   9.041   6.850  1.00 49.22           C  
ATOM    681  CD2 LEU A  94     -41.323   7.181   5.188  1.00 49.55           C  
ATOM    682  N   GLN A  95     -37.724  11.212   3.973  1.00 47.95           N  
ATOM    683  CA  GLN A  95     -36.455  11.940   3.944  1.00 48.32           C  
ATOM    684  C   GLN A  95     -36.641  13.440   3.742  1.00 47.82           C  
ATOM    685  O   GLN A  95     -35.881  14.245   4.277  1.00 48.02           O  
ATOM    686  CB  GLN A  95     -35.553  11.404   2.843  1.00 48.69           C  
ATOM    687  CG  GLN A  95     -34.080  11.678   3.109  1.00 50.08           C  
ATOM    688  CD  GLN A  95     -33.189  11.025   2.074  1.00 50.42           C  
ATOM    689  OE1 GLN A  95     -33.325  11.287   0.868  1.00 51.40           O  
ATOM    690  NE2 GLN A  95     -32.278  10.169   2.530  1.00 50.31           N  
ATOM    691  N   VAL A  96     -37.655  13.806   2.961  1.00 47.55           N  
ATOM    692  CA  VAL A  96     -37.997  15.208   2.728  1.00 46.64           C  
ATOM    693  C   VAL A  96     -38.459  15.851   4.036  1.00 46.64           C  
ATOM    694  O   VAL A  96     -38.054  16.972   4.355  1.00 46.72           O  
ATOM    695  CB  VAL A  96     -39.082  15.335   1.633  1.00 46.70           C  
ATOM    696  CG1 VAL A  96     -39.803  16.660   1.717  1.00 46.35           C  
ATOM    697  CG2 VAL A  96     -38.461  15.119   0.248  1.00 46.63           C  
ATOM    698  N   PHE A  97     -39.287  15.140   4.796  1.00 45.71           N  
ATOM    699  CA  PHE A  97     -39.787  15.681   6.036  1.00 45.82           C  
ATOM    700  C   PHE A  97     -38.723  15.708   7.127  1.00 46.08           C  
ATOM    701  O   PHE A  97     -38.652  16.666   7.894  1.00 45.62           O  
ATOM    702  CB  PHE A  97     -41.006  14.906   6.506  1.00 45.58           C  
ATOM    703  CG  PHE A  97     -42.268  15.240   5.761  1.00 46.28           C  
ATOM    704  CD1 PHE A  97     -42.515  16.545   5.312  1.00 45.23           C  
ATOM    705  CD2 PHE A  97     -43.251  14.256   5.549  1.00 45.93           C  
ATOM    706  CE1 PHE A  97     -43.699  16.866   4.653  1.00 45.88           C  
ATOM    707  CE2 PHE A  97     -44.444  14.573   4.864  1.00 46.28           C  
ATOM    708  CZ  PHE A  97     -44.663  15.885   4.412  1.00 45.65           C  
ATOM    709  N   ASN A  98     -37.897  14.662   7.189  1.00 46.34           N  
ATOM    710  CA  ASN A  98     -36.838  14.567   8.198  1.00 46.73           C  
ATOM    711  C   ASN A  98     -35.799  15.651   8.024  1.00 47.14           C  
ATOM    712  O   ASN A  98     -35.439  16.328   8.990  1.00 46.96           O  
ATOM    713  CB  ASN A  98     -36.155  13.211   8.158  1.00 46.64           C  
ATOM    714  CG  ASN A  98     -36.599  12.309   9.281  1.00 46.88           C  
ATOM    715  OD1 ASN A  98     -35.932  12.223  10.315  1.00 47.06           O  
ATOM    716  ND2 ASN A  98     -37.728  11.631   9.094  1.00 46.74           N  
ATOM    717  N   GLU A  99     -35.332  15.805   6.787  1.00 47.51           N  
ATOM    718  CA  GLU A  99     -34.363  16.828   6.429  1.00 48.41           C  
ATOM    719  C   GLU A  99     -34.852  18.237   6.742  1.00 47.91           C  
ATOM    720  O   GLU A  99     -34.088  19.101   7.115  1.00 47.45           O  
ATOM    721  CB  GLU A  99     -34.067  16.749   4.943  1.00 49.40           C  
ATOM    722  CG  GLU A  99     -33.042  17.755   4.520  1.00 51.55           C  
ATOM    723  CD  GLU A  99     -33.027  17.954   3.039  1.00 52.28           C  
ATOM    724  OE1 GLU A  99     -34.098  17.750   2.418  1.00 53.58           O  
ATOM    725  OE2 GLU A  99     -31.949  18.323   2.498  1.00 53.32           O  
ATOM    726  N   LEU A 100     -36.147  18.439   6.561  1.00 47.82           N  
ATOM    727  CA  LEU A 100     -36.818  19.694   6.810  1.00 47.50           C  
ATOM    728  C   LEU A 100     -36.704  20.045   8.305  1.00 47.01           C  
ATOM    729  O   LEU A 100     -36.407  21.167   8.664  1.00 46.58           O  
ATOM    730  CB  LEU A 100     -38.280  19.501   6.387  1.00 48.08           C  
ATOM    731  CG  LEU A 100     -39.217  20.423   5.617  1.00 48.48           C  
ATOM    732  CD1 LEU A 100     -40.113  19.594   4.692  1.00 48.39           C  
ATOM    733  CD2 LEU A 100     -40.080  21.180   6.593  1.00 48.87           C  
ATOM    734  N   VAL A 101     -36.920  19.068   9.172  1.00 46.85           N  
ATOM    735  CA  VAL A 101     -36.911  19.295  10.622  1.00 46.93           C  
ATOM    736  C   VAL A 101     -35.500  19.339  11.220  1.00 47.10           C  
ATOM    737  O   VAL A 101     -35.238  20.111  12.152  1.00 47.12           O  
ATOM    738  CB  VAL A 101     -37.709  18.205  11.356  1.00 47.18           C  
ATOM    739  CG1 VAL A 101     -38.109  18.680  12.756  1.00 46.99           C  
ATOM    740  CG2 VAL A 101     -38.941  17.827  10.552  1.00 46.88           C  
ATOM    741  N   LEU A 102     -34.606  18.513  10.671  1.00 47.12           N  
ATOM    742  CA  LEU A 102     -33.220  18.375  11.141  1.00 46.90           C  
ATOM    743  C   LEU A 102     -32.229  19.385  10.534  1.00 47.46           C  
ATOM    744  O   LEU A 102     -31.357  19.891  11.254  1.00 47.38           O  
ATOM    745  CB  LEU A 102     -32.725  16.950  10.893  1.00 46.11           C  
ATOM    746  CG  LEU A 102     -33.554  15.795  11.470  1.00 45.75           C  
ATOM    747  CD1 LEU A 102     -32.911  14.470  11.123  1.00 45.32           C  
ATOM    748  CD2 LEU A 102     -33.761  15.928  12.969  1.00 45.47           C  
ATOM    749  N   ASP A 103     -32.364  19.660   9.228  1.00 47.73           N  
ATOM    750  CA  ASP A 103     -31.447  20.538   8.486  1.00 47.94           C  
ATOM    751  C   ASP A 103     -31.945  21.975   8.459  1.00 47.83           C  
ATOM    752  O   ASP A 103     -32.880  22.314   7.726  1.00 47.98           O  
ATOM    753  CB  ASP A 103     -31.266  20.026   7.049  1.00 48.92           C  
ATOM    754  CG  ASP A 103     -30.162  20.774   6.273  1.00 50.02           C  
ATOM    755  OD1 ASP A 103     -29.562  21.739   6.807  1.00 50.62           O  
ATOM    756  OD2 ASP A 103     -29.871  20.379   5.112  1.00 50.46           O  
ATOM    757  N   ALA A 104     -31.317  22.828   9.253  1.00 47.48           N  
ATOM    758  CA  ALA A 104     -31.713  24.235   9.321  1.00 47.38           C  
ATOM    759  C   ALA A 104     -31.585  24.960   7.977  1.00 47.20           C  
ATOM    760  O   ALA A 104     -32.338  25.887   7.700  1.00 47.01           O  
ATOM    761  CB  ALA A 104     -30.922  24.963  10.403  1.00 47.20           C  
ATOM    762  N   ARG A 105     -30.635  24.526   7.157  1.00 47.12           N  
ATOM    763  CA  ARG A 105     -30.393  25.106   5.839  1.00 47.64           C  
ATOM    764  C   ARG A 105     -31.626  24.884   4.991  1.00 47.38           C  
ATOM    765  O   ARG A 105     -32.183  25.832   4.457  1.00 47.75           O  
ATOM    766  CB  ARG A 105     -29.156  24.444   5.185  1.00 48.26           C  
ATOM    767  CG  ARG A 105     -28.520  25.163   4.001  1.00 48.70           C  
ATOM    768  CD  ARG A 105     -27.253  25.926   4.415  1.00 49.55           C  
ATOM    769  NE  ARG A 105     -26.045  25.088   4.477  1.00 50.45           N  
ATOM    770  CZ  ARG A 105     -24.815  25.536   4.747  1.00 50.73           C  
ATOM    771  NH1 ARG A 105     -24.605  26.826   4.988  1.00 51.16           N  
ATOM    772  NH2 ARG A 105     -23.778  24.697   4.779  1.00 51.08           N  
ATOM    773  N   THR A 106     -32.046  23.624   4.892  1.00 47.29           N  
ATOM    774  CA  THR A 106     -33.215  23.198   4.134  1.00 47.13           C  
ATOM    775  C   THR A 106     -34.502  23.909   4.579  1.00 47.16           C  
ATOM    776  O   THR A 106     -35.294  24.334   3.748  1.00 46.70           O  
ATOM    777  CB  THR A 106     -33.404  21.675   4.259  1.00 47.10           C  
ATOM    778  OG1 THR A 106     -32.232  21.017   3.771  1.00 47.82           O  
ATOM    779  CG2 THR A 106     -34.582  21.191   3.460  1.00 47.14           C  
ATOM    780  N   ARG A 107     -34.705  24.007   5.887  1.00 46.99           N  
ATOM    781  CA  ARG A 107     -35.826  24.745   6.448  1.00 46.86           C  
ATOM    782  C   ARG A 107     -35.763  26.218   6.095  1.00 46.15           C  
ATOM    783  O   ARG A 107     -36.790  26.792   5.792  1.00 46.81           O  
ATOM    784  CB  ARG A 107     -35.887  24.580   7.971  1.00 47.27           C  
ATOM    785  CG  ARG A 107     -36.701  25.644   8.661  1.00 48.37           C  
ATOM    786  CD  ARG A 107     -37.143  25.222  10.046  1.00 49.21           C  
ATOM    787  NE  ARG A 107     -36.141  25.479  11.072  1.00 49.80           N  
ATOM    788  CZ  ARG A 107     -35.343  24.547  11.594  1.00 50.59           C  
ATOM    789  NH1 ARG A 107     -35.427  23.278  11.182  1.00 50.92           N  
ATOM    790  NH2 ARG A 107     -34.462  24.879  12.543  1.00 50.63           N  
ATOM    791  N   ARG A 108     -34.574  26.824   6.149  1.00 45.29           N  
ATOM    792  CA  ARG A 108     -34.399  28.250   5.819  1.00 44.57           C  
ATOM    793  C   ARG A 108     -34.691  28.586   4.337  1.00 43.44           C  
ATOM    794  O   ARG A 108     -35.379  29.572   4.046  1.00 43.34           O  
ATOM    795  CB  ARG A 108     -32.991  28.753   6.189  1.00 45.25           C  
ATOM    796  CG  ARG A 108     -32.757  29.133   7.652  1.00 46.03           C  
ATOM    797  CD  ARG A 108     -31.431  29.942   7.775  1.00 46.70           C  
ATOM    798  NE  ARG A 108     -30.685  29.742   9.027  1.00 47.41           N  
ATOM    799  CZ  ARG A 108     -29.501  29.117   9.128  1.00 48.05           C  
ATOM    800  NH1 ARG A 108     -28.885  28.618   8.047  1.00 48.06           N  
ATOM    801  NH2 ARG A 108     -28.905  28.994  10.322  1.00 48.16           N  
ATOM    802  N   ILE A 109     -34.144  27.781   3.424  1.00 41.71           N  
ATOM    803  CA  ILE A 109     -34.445  27.863   1.992  1.00 40.43           C  
ATOM    804  C   ILE A 109     -35.943  27.678   1.701  1.00 39.65           C  
ATOM    805  O   ILE A 109     -36.529  28.418   0.973  1.00 39.50           O  
ATOM    806  CB  ILE A 109     -33.570  26.853   1.189  1.00 40.19           C  
ATOM    807  CG1 ILE A 109     -32.125  27.348   1.129  1.00 39.88           C  
ATOM    808  CG2 ILE A 109     -34.109  26.661  -0.211  1.00 39.87           C  
ATOM    809  CD1 ILE A 109     -31.067  26.251   0.936  1.00 39.84           C  
ATOM    810  N   ASN A 110     -36.575  26.693   2.301  1.00 39.82           N  
ATOM    811  CA  ASN A 110     -37.997  26.505   2.104  1.00 39.74           C  
ATOM    812  C   ASN A 110     -38.791  27.682   2.639  1.00 39.72           C  
ATOM    813  O   ASN A 110     -39.803  28.027   2.073  1.00 38.89           O  
ATOM    814  CB  ASN A 110     -38.491  25.203   2.749  1.00 40.05           C  
ATOM    815  CG  ASN A 110     -38.124  23.983   1.954  1.00 39.20           C  
ATOM    816  OD1 ASN A 110     -37.200  23.296   2.289  1.00 40.64           O  
ATOM    817  ND2 ASN A 110     -38.859  23.701   0.912  1.00 40.23           N  
ATOM    818  N   GLU A 111     -38.340  28.294   3.727  1.00 39.75           N  
ATOM    819  CA  GLU A 111     -39.069  29.438   4.254  1.00 41.14           C  
ATOM    820  C   GLU A 111     -38.887  30.672   3.357  1.00 41.02           C  
ATOM    821  O   GLU A 111     -39.783  31.501   3.273  1.00 41.78           O  
ATOM    822  CB  GLU A 111     -38.736  29.690   5.724  1.00 41.01           C  
ATOM    823  CG  GLU A 111     -39.164  31.034   6.286  1.00 42.34           C  
ATOM    824  CD  GLU A 111     -40.590  31.100   6.859  1.00 42.53           C  
ATOM    825  OE1 GLU A 111     -41.398  30.182   6.639  1.00 43.24           O  
ATOM    826  OE2 GLU A 111     -40.914  32.108   7.529  1.00 43.24           O  
ATOM    827  N   ILE A 112     -37.752  30.767   2.665  1.00 41.12           N  
ATOM    828  CA  ILE A 112     -37.533  31.808   1.665  1.00 40.61           C  
ATOM    829  C   ILE A 112     -38.429  31.556   0.479  1.00 41.41           C  
ATOM    830  O   ILE A 112     -39.189  32.434   0.063  1.00 42.13           O  
ATOM    831  CB  ILE A 112     -36.069  31.838   1.192  1.00 40.47           C  
ATOM    832  CG1 ILE A 112     -35.121  32.150   2.349  1.00 39.16           C  
ATOM    833  CG2 ILE A 112     -35.883  32.821   0.052  1.00 39.79           C  
ATOM    834  CD1 ILE A 112     -33.691  31.832   2.017  1.00 39.42           C  
ATOM    835  N   LEU A 113     -38.354  30.361  -0.087  1.00 42.05           N  
ATOM    836  CA  LEU A 113     -39.286  29.988  -1.151  1.00 43.11           C  
ATOM    837  C   LEU A 113     -40.777  30.229  -0.817  1.00 43.23           C  
ATOM    838  O   LEU A 113     -41.502  30.813  -1.606  1.00 43.14           O  
ATOM    839  CB  LEU A 113     -39.053  28.540  -1.519  1.00 44.11           C  
ATOM    840  CG  LEU A 113     -37.998  28.276  -2.600  1.00 44.83           C  
ATOM    841  CD1 LEU A 113     -38.721  27.759  -3.839  1.00 46.44           C  
ATOM    842  CD2 LEU A 113     -37.157  29.481  -2.987  1.00 45.55           C  
ATOM    843  N   HIS A 114     -41.208  29.807   0.376  1.00 43.12           N  
ATOM    844  CA  HIS A 114     -42.596  29.924   0.800  1.00 42.53           C  
ATOM    845  C   HIS A 114     -43.034  31.280   1.366  1.00 42.49           C  
ATOM    846  O   HIS A 114     -44.132  31.731   1.050  1.00 42.87           O  
ATOM    847  CB  HIS A 114     -42.942  28.826   1.794  1.00 43.02           C  
ATOM    848  CG  HIS A 114     -43.153  27.497   1.153  1.00 43.89           C  
ATOM    849  ND1 HIS A 114     -44.369  27.107   0.627  1.00 44.33           N  
ATOM    850  CD2 HIS A 114     -42.301  26.474   0.926  1.00 44.18           C  
ATOM    851  CE1 HIS A 114     -44.258  25.893   0.120  1.00 44.37           C  
ATOM    852  NE2 HIS A 114     -43.012  25.487   0.286  1.00 44.82           N  
ATOM    853  N   HIS A 115     -42.224  31.924   2.202  1.00 41.29           N  
ATOM    854  CA  HIS A 115     -42.745  33.046   2.948  1.00 41.03           C  
ATOM    855  C   HIS A 115     -41.968  34.316   2.774  1.00 41.59           C  
ATOM    856  O   HIS A 115     -42.274  35.296   3.446  1.00 41.50           O  
ATOM    857  CB  HIS A 115     -42.887  32.742   4.455  1.00 39.91           C  
ATOM    858  CG  HIS A 115     -43.860  31.640   4.788  1.00 38.57           C  
ATOM    859  ND1 HIS A 115     -45.182  31.658   4.395  1.00 37.79           N  
ATOM    860  CD2 HIS A 115     -43.705  30.514   5.530  1.00 37.69           C  
ATOM    861  CE1 HIS A 115     -45.785  30.573   4.855  1.00 37.36           C  
ATOM    862  NE2 HIS A 115     -44.905  29.851   5.520  1.00 36.30           N  
ATOM    863  N   LYS A 116     -40.979  34.321   1.879  1.00 42.18           N  
ATOM    864  CA  LYS A 116     -40.185  35.529   1.645  1.00 42.92           C  
ATOM    865  C   LYS A 116     -39.818  35.766   0.205  1.00 43.41           C  
ATOM    866  O   LYS A 116     -38.803  36.370  -0.061  1.00 43.82           O  
ATOM    867  CB  LYS A 116     -38.875  35.480   2.422  1.00 42.89           C  
ATOM    868  CG  LYS A 116     -38.993  35.747   3.893  1.00 42.73           C  
ATOM    869  CD  LYS A 116     -37.832  35.127   4.559  1.00 42.07           C  
ATOM    870  CE  LYS A 116     -38.254  34.530   5.871  1.00 41.84           C  
ATOM    871  NZ  LYS A 116     -38.026  35.563   6.928  1.00 41.57           N  
ATOM    872  N   CYS A 117     -40.636  35.319  -0.726  1.00 44.59           N  
ATOM    873  CA  CYS A 117     -40.309  35.462  -2.129  1.00 46.33           C  
ATOM    874  C   CYS A 117     -41.553  35.811  -2.933  1.00 46.21           C  
ATOM    875  O   CYS A 117     -42.365  34.946  -3.243  1.00 47.71           O  
ATOM    876  CB  CYS A 117     -39.683  34.164  -2.621  1.00 45.85           C  
ATOM    877  SG  CYS A 117     -38.957  34.233  -4.230  1.00 49.52           S  
ATOM    878  N   GLU A 118     -41.711  37.086  -3.245  1.00 47.01           N  
ATOM    879  CA  GLU A 118     -42.872  37.592  -3.981  1.00 47.54           C  
ATOM    880  C   GLU A 118     -42.795  37.329  -5.479  1.00 47.88           C  
ATOM    881  O   GLU A 118     -41.723  37.361  -6.064  1.00 48.06           O  
ATOM    882  CB  GLU A 118     -43.001  39.108  -3.794  1.00 47.41           C  
ATOM    883  CG  GLU A 118     -43.199  39.578  -2.374  1.00 48.02           C  
ATOM    884  CD  GLU A 118     -43.343  41.089  -2.278  1.00 48.74           C  
ATOM    885  OE1 GLU A 118     -42.925  41.800  -3.243  1.00 48.56           O  
ATOM    886  OE2 GLU A 118     -43.866  41.559  -1.232  1.00 48.25           O  
ATOM    887  N   PHE A 119     -43.951  37.106  -6.095  1.00 48.56           N  
ATOM    888  CA  PHE A 119     -44.079  37.094  -7.544  1.00 49.72           C  
ATOM    889  C   PHE A 119     -44.526  38.457  -8.022  1.00 50.68           C  
ATOM    890  O   PHE A 119     -45.688  38.797  -7.851  1.00 51.40           O  
ATOM    891  CB  PHE A 119     -45.139  36.089  -7.981  1.00 48.40           C  
ATOM    892  CG  PHE A 119     -44.816  34.668  -7.644  1.00 47.79           C  
ATOM    893  CD1 PHE A 119     -45.800  33.699  -7.711  1.00 47.25           C  
ATOM    894  CD2 PHE A 119     -43.538  34.293  -7.265  1.00 47.58           C  
ATOM    895  CE1 PHE A 119     -45.516  32.403  -7.433  1.00 46.81           C  
ATOM    896  CE2 PHE A 119     -43.259  32.992  -6.953  1.00 47.18           C  
ATOM    897  CZ  PHE A 119     -44.255  32.049  -7.046  1.00 47.08           C  
ATOM    898  N   THR A 120     -43.627  39.243  -8.612  1.00 52.55           N  
ATOM    899  CA  THR A 120     -44.038  40.520  -9.213  1.00 54.28           C  
ATOM    900  C   THR A 120     -43.661  40.604 -10.707  1.00 55.55           C  
ATOM    901  O   THR A 120     -42.704  39.965 -11.146  1.00 55.64           O  
ATOM    902  CB  THR A 120     -43.509  41.761  -8.421  1.00 54.20           C  
ATOM    903  OG1 THR A 120     -42.092  41.899  -8.592  1.00 54.27           O  
ATOM    904  CG2 THR A 120     -43.842  41.651  -6.924  1.00 54.30           C  
ATOM    905  N   ASP A 121     -44.435  41.363 -11.486  1.00 56.95           N  
ATOM    906  CA  ASP A 121     -44.078  41.678 -12.874  1.00 58.74           C  
ATOM    907  C   ASP A 121     -42.647  42.209 -13.007  1.00 59.59           C  
ATOM    908  O   ASP A 121     -42.037  42.107 -14.075  1.00 59.81           O  
ATOM    909  CB  ASP A 121     -45.051  42.715 -13.458  1.00 58.94           C  
ATOM    910  CG  ASP A 121     -46.283  42.077 -14.075  1.00 59.33           C  
ATOM    911  OD1 ASP A 121     -46.357  40.822 -14.101  1.00 59.19           O  
ATOM    912  OD2 ASP A 121     -47.172  42.833 -14.549  1.00 59.43           O  
ATOM    913  N   ASP A 122     -42.130  42.783 -11.919  1.00 60.94           N  
ATOM    914  CA  ASP A 122     -40.771  43.329 -11.882  1.00 61.98           C  
ATOM    915  C   ASP A 122     -39.745  42.234 -12.225  1.00 62.38           C  
ATOM    916  O   ASP A 122     -38.961  42.407 -13.165  1.00 62.48           O  
ATOM    917  CB  ASP A 122     -40.490  44.007 -10.525  1.00 62.42           C  
ATOM    918  CG  ASP A 122     -41.360  45.261 -10.299  1.00 63.04           C  
ATOM    919  OD1 ASP A 122     -40.973  46.358 -10.779  1.00 63.17           O  
ATOM    920  OD2 ASP A 122     -42.433  45.160  -9.639  1.00 63.30           O  
ATOM    921  N   MET A 123     -39.774  41.112 -11.496  1.00 62.78           N  
ATOM    922  CA  MET A 123     -38.997  39.921 -11.865  1.00 63.02           C  
ATOM    923  C   MET A 123     -39.890  38.691 -12.147  1.00 62.84           C  
ATOM    924  O   MET A 123     -40.061  37.809 -11.269  1.00 62.46           O  
ATOM    925  CB  MET A 123     -37.982  39.543 -10.779  1.00 64.42           C  
ATOM    926  CG  MET A 123     -37.299  40.673 -10.017  1.00 65.37           C  
ATOM    927  SD  MET A 123     -36.407  39.916  -8.614  1.00 67.57           S  
ATOM    928  CE  MET A 123     -37.645  39.982  -7.290  1.00 66.44           C  
ATOM    929  N   CYS A 124     -40.440  38.623 -13.365  1.00 61.77           N  
ATOM    930  CA  CYS A 124     -41.304  37.502 -13.791  1.00 61.19           C  
ATOM    931  C   CYS A 124     -40.607  36.135 -13.796  1.00 60.12           C  
ATOM    932  O   CYS A 124     -41.273  35.099 -13.929  1.00 59.56           O  
ATOM    933  CB  CYS A 124     -41.865  37.744 -15.195  1.00 61.52           C  
ATOM    934  SG  CYS A 124     -43.214  38.926 -15.320  1.00 64.08           S  
ATOM    935  N   GLU A 125     -39.278  36.137 -13.685  1.00 58.71           N  
ATOM    936  CA  GLU A 125     -38.496  34.913 -13.830  1.00 57.43           C  
ATOM    937  C   GLU A 125     -38.678  34.021 -12.634  1.00 56.17           C  
ATOM    938  O   GLU A 125     -38.607  32.806 -12.760  1.00 56.01           O  
ATOM    939  CB  GLU A 125     -37.004  35.181 -14.065  1.00 57.77           C  
ATOM    940  CG  GLU A 125     -36.627  35.343 -15.532  1.00 58.57           C  
ATOM    941  CD  GLU A 125     -35.278  34.697 -15.902  1.00 58.84           C  
ATOM    942  OE1 GLU A 125     -35.008  33.531 -15.500  1.00 58.75           O  
ATOM    943  OE2 GLU A 125     -34.498  35.362 -16.627  1.00 59.15           O  
ATOM    944  N   ILE A 126     -38.902  34.638 -11.480  1.00 54.68           N  
ATOM    945  CA  ILE A 126     -39.129  33.909 -10.233  1.00 53.22           C  
ATOM    946  C   ILE A 126     -40.393  33.058 -10.316  1.00 52.28           C  
ATOM    947  O   ILE A 126     -40.356  31.886  -9.989  1.00 52.11           O  
ATOM    948  CB  ILE A 126     -39.088  34.855  -8.984  1.00 53.40           C  
ATOM    949  CG1 ILE A 126     -37.654  35.358  -8.787  1.00 53.00           C  
ATOM    950  CG2 ILE A 126     -39.519  34.125  -7.715  1.00 53.17           C  
ATOM    951  CD1 ILE A 126     -37.546  36.591  -7.999  1.00 53.37           C  
ATOM    952  N   ARG A 127     -41.484  33.646 -10.794  1.00 51.16           N  
ATOM    953  CA  ARG A 127     -42.732  32.930 -11.051  1.00 50.24           C  
ATOM    954  C   ARG A 127     -42.595  31.826 -12.093  1.00 49.91           C  
ATOM    955  O   ARG A 127     -42.961  30.687 -11.827  1.00 49.80           O  
ATOM    956  CB  ARG A 127     -43.814  33.891 -11.509  1.00 50.52           C  
ATOM    957  CG  ARG A 127     -45.113  33.552 -10.904  1.00 50.95           C  
ATOM    958  CD  ARG A 127     -46.321  33.895 -11.718  1.00 51.89           C  
ATOM    959  NE  ARG A 127     -47.449  33.661 -10.838  1.00 52.36           N  
ATOM    960  CZ  ARG A 127     -48.598  33.095 -11.176  1.00 52.79           C  
ATOM    961  NH1 ARG A 127     -48.822  32.682 -12.419  1.00 52.31           N  
ATOM    962  NH2 ARG A 127     -49.530  32.941 -10.230  1.00 53.28           N  
ATOM    963  N   GLN A 128     -42.108  32.195 -13.281  1.00 49.04           N  
ATOM    964  CA  GLN A 128     -41.776  31.273 -14.364  1.00 48.66           C  
ATOM    965  C   GLN A 128     -41.017  30.053 -13.844  1.00 48.01           C  
ATOM    966  O   GLN A 128     -41.450  28.925 -14.052  1.00 48.17           O  
ATOM    967  CB  GLN A 128     -40.944  31.996 -15.450  1.00 48.86           C  
ATOM    968  CG  GLN A 128     -41.736  32.952 -16.332  1.00 49.36           C  
ATOM    969  CD  GLN A 128     -40.875  33.759 -17.337  1.00 50.09           C  
ATOM    970  OE1 GLN A 128     -40.052  33.196 -18.088  1.00 50.18           O  
ATOM    971  NE2 GLN A 128     -41.092  35.076 -17.368  1.00 49.15           N  
ATOM    972  N   GLN A 129     -39.889  30.303 -13.177  1.00 47.40           N  
ATOM    973  CA  GLN A 129     -39.037  29.295 -12.530  1.00 46.99           C  
ATOM    974  C   GLN A 129     -39.850  28.306 -11.735  1.00 46.10           C  
ATOM    975  O   GLN A 129     -39.778  27.115 -11.947  1.00 45.72           O  
ATOM    976  CB  GLN A 129     -38.163  29.990 -11.507  1.00 47.74           C  
ATOM    977  CG  GLN A 129     -36.779  29.538 -11.453  1.00 48.98           C  
ATOM    978  CD  GLN A 129     -35.886  30.556 -12.061  1.00 49.42           C  
ATOM    979  OE1 GLN A 129     -35.148  31.231 -11.354  1.00 50.51           O  
ATOM    980  NE2 GLN A 129     -35.972  30.720 -13.384  1.00 50.19           N  
ATOM    981  N   ARG A 130     -40.614  28.856 -10.800  1.00 45.59           N  
ATOM    982  CA  ARG A 130     -41.486  28.119  -9.918  1.00 44.99           C  
ATOM    983  C   ARG A 130     -42.512  27.263 -10.640  1.00 44.48           C  
ATOM    984  O   ARG A 130     -42.735  26.128 -10.248  1.00 43.71           O  
ATOM    985  CB  ARG A 130     -42.185  29.081  -8.954  1.00 45.16           C  
ATOM    986  CG  ARG A 130     -42.794  28.363  -7.798  1.00 46.23           C  
ATOM    987  CD  ARG A 130     -41.709  27.953  -6.792  1.00 46.98           C  
ATOM    988  NE  ARG A 130     -41.865  28.799  -5.629  1.00 48.21           N  
ATOM    989  CZ  ARG A 130     -41.152  29.882  -5.374  1.00 48.14           C  
ATOM    990  NH1 ARG A 130     -40.149  30.260  -6.162  1.00 48.60           N  
ATOM    991  NH2 ARG A 130     -41.445  30.578  -4.293  1.00 49.02           N  
ATOM    992  N   GLN A 131     -43.149  27.810 -11.677  1.00 43.91           N  
ATOM    993  CA  GLN A 131     -44.073  27.029 -12.490  1.00 43.55           C  
ATOM    994  C   GLN A 131     -43.347  25.815 -13.106  1.00 43.69           C  
ATOM    995  O   GLN A 131     -43.907  24.722 -13.130  1.00 42.87           O  
ATOM    996  CB  GLN A 131     -44.735  27.887 -13.578  1.00 43.62           C  
ATOM    997  CG  GLN A 131     -45.546  29.063 -13.082  1.00 43.64           C  
ATOM    998  CD  GLN A 131     -46.158  29.881 -14.220  1.00 44.48           C  
ATOM    999  OE1 GLN A 131     -45.498  30.161 -15.224  1.00 44.01           O  
ATOM   1000  NE2 GLN A 131     -47.432  30.263 -14.066  1.00 43.95           N  
ATOM   1001  N   SER A 132     -42.108  26.002 -13.584  1.00 43.84           N  
ATOM   1002  CA  SER A 132     -41.302  24.882 -14.136  1.00 44.69           C  
ATOM   1003  C   SER A 132     -41.049  23.788 -13.120  1.00 44.62           C  
ATOM   1004  O   SER A 132     -41.357  22.621 -13.367  1.00 45.02           O  
ATOM   1005  CB  SER A 132     -39.965  25.341 -14.724  1.00 44.50           C  
ATOM   1006  OG  SER A 132     -40.162  25.923 -16.003  1.00 44.95           O  
ATOM   1007  N   ALA A 133     -40.504  24.177 -11.971  1.00 44.79           N  
ATOM   1008  CA  ALA A 133     -40.224  23.243 -10.892  1.00 44.74           C  
ATOM   1009  C   ALA A 133     -41.436  22.421 -10.469  1.00 44.94           C  
ATOM   1010  O   ALA A 133     -41.301  21.224 -10.194  1.00 45.69           O  
ATOM   1011  CB  ALA A 133     -39.638  23.958  -9.719  1.00 44.36           C  
ATOM   1012  N   VAL A 134     -42.611  23.044 -10.410  1.00 45.06           N  
ATOM   1013  CA  VAL A 134     -43.827  22.339  -9.972  1.00 45.18           C  
ATOM   1014  C   VAL A 134     -44.302  21.432 -11.100  1.00 45.73           C  
ATOM   1015  O   VAL A 134     -44.754  20.324 -10.865  1.00 45.98           O  
ATOM   1016  CB  VAL A 134     -44.944  23.302  -9.526  1.00 44.52           C  
ATOM   1017  CG1 VAL A 134     -46.104  22.537  -8.973  1.00 44.47           C  
ATOM   1018  CG2 VAL A 134     -44.449  24.227  -8.470  1.00 44.73           C  
ATOM   1019  N   LEU A 135     -44.159  21.899 -12.333  1.00 46.65           N  
ATOM   1020  CA  LEU A 135     -44.306  21.019 -13.472  1.00 47.75           C  
ATOM   1021  C   LEU A 135     -43.283  19.855 -13.447  1.00 48.21           C  
ATOM   1022  O   LEU A 135     -43.685  18.708 -13.635  1.00 48.49           O  
ATOM   1023  CB  LEU A 135     -44.282  21.796 -14.797  1.00 47.30           C  
ATOM   1024  CG  LEU A 135     -45.483  22.709 -15.092  1.00 47.61           C  
ATOM   1025  CD1 LEU A 135     -45.107  23.836 -16.089  1.00 47.33           C  
ATOM   1026  CD2 LEU A 135     -46.724  21.968 -15.561  1.00 47.43           C  
ATOM   1027  N   ASP A 136     -41.993  20.126 -13.202  1.00 49.24           N  
ATOM   1028  CA  ASP A 136     -40.984  19.032 -13.107  1.00 50.22           C  
ATOM   1029  C   ASP A 136     -41.437  18.031 -12.074  1.00 50.07           C  
ATOM   1030  O   ASP A 136     -41.648  16.867 -12.386  1.00 50.30           O  
ATOM   1031  CB  ASP A 136     -39.587  19.523 -12.701  1.00 51.17           C  
ATOM   1032  CG  ASP A 136     -38.837  20.199 -13.834  1.00 51.97           C  
ATOM   1033  OD1 ASP A 136     -39.436  20.462 -14.914  1.00 52.51           O  
ATOM   1034  OD2 ASP A 136     -37.633  20.493 -13.628  1.00 52.64           O  
ATOM   1035  N   CYS A 137     -41.600  18.513 -10.844  1.00 50.15           N  
ATOM   1036  CA  CYS A 137     -42.079  17.703  -9.732  1.00 50.24           C  
ATOM   1037  C   CYS A 137     -43.371  16.971 -10.076  1.00 49.39           C  
ATOM   1038  O   CYS A 137     -43.545  15.839  -9.685  1.00 49.18           O  
ATOM   1039  CB  CYS A 137     -42.260  18.555  -8.475  1.00 50.17           C  
ATOM   1040  SG  CYS A 137     -42.332  17.577  -6.974  1.00 53.01           S  
ATOM   1041  N   HIS A 138     -44.260  17.609 -10.829  1.00 49.26           N  
ATOM   1042  CA  HIS A 138     -45.484  16.949 -11.292  1.00 48.97           C  
ATOM   1043  C   HIS A 138     -45.191  15.776 -12.235  1.00 48.90           C  
ATOM   1044  O   HIS A 138     -45.766  14.702 -12.095  1.00 48.67           O  
ATOM   1045  CB  HIS A 138     -46.419  17.952 -11.976  1.00 48.52           C  
ATOM   1046  CG  HIS A 138     -47.698  17.347 -12.456  1.00 48.19           C  
ATOM   1047  ND1 HIS A 138     -48.734  17.030 -11.606  1.00 48.16           N  
ATOM   1048  CD2 HIS A 138     -48.109  16.998 -13.698  1.00 48.28           C  
ATOM   1049  CE1 HIS A 138     -49.731  16.514 -12.305  1.00 48.24           C  
ATOM   1050  NE2 HIS A 138     -49.376  16.483 -13.576  1.00 48.07           N  
ATOM   1051  N   LYS A 139     -44.287  16.000 -13.186  1.00 49.05           N  
ATOM   1052  CA  LYS A 139     -43.937  15.001 -14.189  1.00 49.25           C  
ATOM   1053  C   LYS A 139     -43.431  13.732 -13.512  1.00 49.29           C  
ATOM   1054  O   LYS A 139     -43.814  12.627 -13.894  1.00 49.77           O  
ATOM   1055  CB  LYS A 139     -42.904  15.550 -15.162  1.00 49.26           C  
ATOM   1056  N   GLY A 140     -42.609  13.901 -12.480  1.00 49.27           N  
ATOM   1057  CA  GLY A 140     -42.060  12.775 -11.722  1.00 49.06           C  
ATOM   1058  C   GLY A 140     -43.065  11.962 -10.913  1.00 48.72           C  
ATOM   1059  O   GLY A 140     -43.160  10.739 -11.082  1.00 48.70           O  
ATOM   1060  N   ILE A 141     -43.810  12.631 -10.033  1.00 48.20           N  
ATOM   1061  CA  ILE A 141     -44.822  11.951  -9.219  1.00 48.02           C  
ATOM   1062  C   ILE A 141     -45.772  11.159 -10.112  1.00 48.67           C  
ATOM   1063  O   ILE A 141     -46.142  10.048  -9.775  1.00 48.64           O  
ATOM   1064  CB  ILE A 141     -45.635  12.917  -8.308  1.00 47.09           C  
ATOM   1065  CG1 ILE A 141     -44.713  13.710  -7.394  1.00 46.46           C  
ATOM   1066  CG2 ILE A 141     -46.653  12.164  -7.451  1.00 46.57           C  
ATOM   1067  CD1 ILE A 141     -45.240  15.090  -7.096  1.00 45.40           C  
ATOM   1068  N   THR A 142     -46.148  11.731 -11.256  1.00 49.55           N  
ATOM   1069  CA  THR A 142     -47.072  11.073 -12.183  1.00 50.31           C  
ATOM   1070  C   THR A 142     -46.486   9.733 -12.657  1.00 50.70           C  
ATOM   1071  O   THR A 142     -47.076   8.679 -12.390  1.00 51.19           O  
ATOM   1072  CB  THR A 142     -47.509  12.030 -13.336  1.00 50.28           C  
ATOM   1073  OG1 THR A 142     -48.413  13.009 -12.812  1.00 50.60           O  
ATOM   1074  CG2 THR A 142     -48.229  11.306 -14.427  1.00 50.39           C  
ATOM   1075  N   LEU A 143     -45.322   9.770 -13.310  1.00 51.21           N  
ATOM   1076  CA  LEU A 143     -44.625   8.560 -13.758  1.00 51.36           C  
ATOM   1077  C   LEU A 143     -44.489   7.510 -12.653  1.00 51.47           C  
ATOM   1078  O   LEU A 143     -44.753   6.321 -12.873  1.00 51.72           O  
ATOM   1079  CB  LEU A 143     -43.230   8.916 -14.279  1.00 51.80           C  
ATOM   1080  CG  LEU A 143     -42.995   9.460 -15.694  1.00 52.18           C  
ATOM   1081  CD1 LEU A 143     -41.508   9.795 -15.889  1.00 52.12           C  
ATOM   1082  CD2 LEU A 143     -43.460   8.472 -16.764  1.00 52.22           C  
ATOM   1083  N   ALA A 144     -44.068   7.960 -11.473  1.00 51.36           N  
ATOM   1084  CA  ALA A 144     -43.934   7.106 -10.300  1.00 50.97           C  
ATOM   1085  C   ALA A 144     -45.265   6.475  -9.907  1.00 50.86           C  
ATOM   1086  O   ALA A 144     -45.321   5.304  -9.555  1.00 50.92           O  
ATOM   1087  CB  ALA A 144     -43.359   7.905  -9.135  1.00 50.98           C  
ATOM   1088  N   LEU A 145     -46.331   7.262  -9.968  1.00 50.65           N  
ATOM   1089  CA  LEU A 145     -47.660   6.788  -9.632  1.00 50.83           C  
ATOM   1090  C   LEU A 145     -48.155   5.769 -10.643  1.00 50.99           C  
ATOM   1091  O   LEU A 145     -48.702   4.740 -10.253  1.00 51.15           O  
ATOM   1092  CB  LEU A 145     -48.648   7.950  -9.530  1.00 50.50           C  
ATOM   1093  CG  LEU A 145     -48.538   8.869  -8.313  1.00 50.48           C  
ATOM   1094  CD1 LEU A 145     -49.507  10.023  -8.473  1.00 49.99           C  
ATOM   1095  CD2 LEU A 145     -48.806   8.114  -7.028  1.00 49.87           C  
ATOM   1096  N   ALA A 146     -47.958   6.059 -11.933  1.00 51.19           N  
ATOM   1097  CA  ALA A 146     -48.250   5.112 -13.015  1.00 51.38           C  
ATOM   1098  C   ALA A 146     -47.552   3.778 -12.774  1.00 51.39           C  
ATOM   1099  O   ALA A 146     -48.177   2.736 -12.879  1.00 51.50           O  
ATOM   1100  CB  ALA A 146     -47.837   5.685 -14.370  1.00 51.36           C  
ATOM   1101  N   ASN A 147     -46.262   3.833 -12.444  1.00 51.64           N  
ATOM   1102  CA  ASN A 147     -45.479   2.656 -12.051  1.00 51.72           C  
ATOM   1103  C   ASN A 147     -46.087   1.838 -10.913  1.00 51.88           C  
ATOM   1104  O   ASN A 147     -45.983   0.604 -10.902  1.00 51.51           O  
ATOM   1105  CB  ASN A 147     -44.054   3.063 -11.667  1.00 51.96           C  
ATOM   1106  CG  ASN A 147     -43.237   3.529 -12.854  1.00 52.25           C  
ATOM   1107  OD1 ASN A 147     -43.713   3.540 -13.991  1.00 52.71           O  
ATOM   1108  ND2 ASN A 147     -41.996   3.920 -12.596  1.00 52.52           N  
ATOM   1109  N   ALA A 148     -46.700   2.528  -9.952  1.00 51.71           N  
ATOM   1110  CA  ALA A 148     -47.357   1.856  -8.840  1.00 52.06           C  
ATOM   1111  C   ALA A 148     -48.702   1.238  -9.258  1.00 52.10           C  
ATOM   1112  O   ALA A 148     -49.209   0.336  -8.598  1.00 52.16           O  
ATOM   1113  CB  ALA A 148     -47.521   2.802  -7.667  1.00 51.33           C  
ATOM   1114  N   VAL A 149     -49.277   1.727 -10.352  1.00 52.54           N  
ATOM   1115  CA  VAL A 149     -50.547   1.199 -10.847  1.00 52.83           C  
ATOM   1116  C   VAL A 149     -50.306  -0.127 -11.564  1.00 53.18           C  
ATOM   1117  O   VAL A 149     -51.037  -1.098 -11.347  1.00 53.12           O  
ATOM   1118  CB  VAL A 149     -51.280   2.194 -11.781  1.00 52.63           C  
ATOM   1119  CG1 VAL A 149     -52.675   1.718 -12.062  1.00 52.77           C  
ATOM   1120  CG2 VAL A 149     -51.349   3.561 -11.172  1.00 52.71           C  
ATOM   1121  N   ARG A 150     -49.280  -0.150 -12.416  1.00 53.64           N  
ATOM   1122  CA  ARG A 150     -48.855  -1.358 -13.118  1.00 54.26           C  
ATOM   1123  C   ARG A 150     -48.438  -2.426 -12.123  1.00 54.23           C  
ATOM   1124  O   ARG A 150     -48.850  -3.581 -12.231  1.00 54.52           O  
ATOM   1125  CB  ARG A 150     -47.679  -1.053 -14.049  1.00 54.49           C  
ATOM   1126  CG  ARG A 150     -48.070  -0.693 -15.463  1.00 55.05           C  
ATOM   1127  CD  ARG A 150     -46.837  -0.419 -16.309  1.00 55.23           C  
ATOM   1128  NE  ARG A 150     -46.197   0.845 -15.945  1.00 55.68           N  
ATOM   1129  CZ  ARG A 150     -46.618   2.052 -16.329  1.00 55.85           C  
ATOM   1130  NH1 ARG A 150     -45.960   3.137 -15.940  1.00 55.98           N  
ATOM   1131  NH2 ARG A 150     -47.695   2.185 -17.096  1.00 56.11           N  
ATOM   1132  N   ARG A 151     -47.623  -2.016 -11.150  1.00 54.40           N  
ATOM   1133  CA  ARG A 151     -47.136  -2.884 -10.093  1.00 54.44           C  
ATOM   1134  C   ARG A 151     -48.259  -3.223  -9.093  1.00 54.34           C  
ATOM   1135  O   ARG A 151     -48.012  -3.837  -8.053  1.00 54.49           O  
ATOM   1136  CB  ARG A 151     -45.933  -2.216  -9.406  1.00 54.70           C  
ATOM   1137  CG  ARG A 151     -45.062  -3.113  -8.556  1.00 55.13           C  
ATOM   1138  CD  ARG A 151     -44.201  -4.044  -9.408  1.00 55.51           C  
ATOM   1139  NE  ARG A 151     -43.889  -5.298  -8.717  1.00 55.59           N  
ATOM   1140  CZ  ARG A 151     -44.714  -6.351  -8.657  1.00 56.02           C  
ATOM   1141  NH1 ARG A 151     -45.920  -6.300  -9.228  1.00 55.96           N  
ATOM   1142  NH2 ARG A 151     -44.342  -7.460  -8.013  1.00 55.82           N  
ATOM   1143  N   GLY A 152     -49.492  -2.837  -9.426  1.00 54.16           N  
ATOM   1144  CA  GLY A 152     -50.659  -3.164  -8.608  1.00 54.23           C  
ATOM   1145  C   GLY A 152     -50.605  -2.685  -7.169  1.00 54.55           C  
ATOM   1146  O   GLY A 152     -51.370  -3.168  -6.332  1.00 54.28           O  
ATOM   1147  N   GLN A 153     -49.701  -1.733  -6.894  1.00 54.98           N  
ATOM   1148  CA  GLN A 153     -49.546  -1.081  -5.577  1.00 55.25           C  
ATOM   1149  C   GLN A 153     -50.677  -0.119  -5.222  1.00 54.95           C  
ATOM   1150  O   GLN A 153     -51.027   0.003  -4.048  1.00 54.70           O  
ATOM   1151  CB  GLN A 153     -48.208  -0.333  -5.476  1.00 55.80           C  
ATOM   1152  CG  GLN A 153     -46.976  -1.236  -5.518  1.00 56.81           C  
ATOM   1153  CD  GLN A 153     -45.845  -0.714  -4.649  1.00 57.14           C  
ATOM   1154  OE1 GLN A 153     -44.780  -0.349  -5.152  1.00 57.68           O  
ATOM   1155  NE2 GLN A 153     -46.073  -0.664  -3.335  1.00 57.45           N  
ATOM   1156  N   LEU A 154     -51.219   0.567  -6.232  1.00 54.71           N  
ATOM   1157  CA  LEU A 154     -52.374   1.471  -6.086  1.00 54.62           C  
ATOM   1158  C   LEU A 154     -53.449   1.054  -7.069  1.00 54.57           C  
ATOM   1159  O   LEU A 154     -53.115   0.525  -8.128  1.00 54.50           O  
ATOM   1160  CB  LEU A 154     -52.004   2.935  -6.375  1.00 54.44           C  
ATOM   1161  CG  LEU A 154     -50.989   3.730  -5.551  1.00 54.56           C  
ATOM   1162  CD1 LEU A 154     -50.482   4.926  -6.348  1.00 54.07           C  
ATOM   1163  CD2 LEU A 154     -51.601   4.180  -4.241  1.00 54.48           C  
ATOM   1164  N   PRO A 155     -54.737   1.316  -6.741  1.00 54.71           N  
ATOM   1165  CA  PRO A 155     -55.873   0.951  -7.594  1.00 54.77           C  
ATOM   1166  C   PRO A 155     -55.552   1.055  -9.087  1.00 55.15           C  
ATOM   1167  O   PRO A 155     -54.970   2.051  -9.540  1.00 54.65           O  
ATOM   1168  CB  PRO A 155     -56.948   1.961  -7.198  1.00 54.82           C  
ATOM   1169  CG  PRO A 155     -56.575   2.432  -5.831  1.00 54.66           C  
ATOM   1170  CD  PRO A 155     -55.190   1.972  -5.501  1.00 54.63           C  
ATOM   1171  N   GLY A 156     -55.929   0.016  -9.830  1.00 55.28           N  
ATOM   1172  CA  GLY A 156     -55.484  -0.162 -11.213  1.00 55.85           C  
ATOM   1173  C   GLY A 156     -56.049   0.814 -12.225  1.00 56.01           C  
ATOM   1174  O   GLY A 156     -55.550   0.914 -13.348  1.00 56.14           O  
ATOM   1175  N   GLU A 157     -57.087   1.534 -11.821  1.00 56.24           N  
ATOM   1176  CA  GLU A 157     -57.790   2.455 -12.703  1.00 56.56           C  
ATOM   1177  C   GLU A 157     -57.466   3.924 -12.395  1.00 56.40           C  
ATOM   1178  O   GLU A 157     -58.035   4.829 -13.002  1.00 56.31           O  
ATOM   1179  CB  GLU A 157     -59.298   2.204 -12.594  1.00 56.95           C  
ATOM   1180  CG  GLU A 157     -59.795   2.030 -11.149  1.00 57.70           C  
ATOM   1181  CD  GLU A 157     -61.133   1.299 -11.046  1.00 58.07           C  
ATOM   1182  OE1 GLU A 157     -61.296   0.527 -10.067  1.00 58.56           O  
ATOM   1183  OE2 GLU A 157     -62.017   1.477 -11.934  1.00 58.42           O  
ATOM   1184  N   LEU A 158     -56.550   4.139 -11.452  1.00 56.25           N  
ATOM   1185  CA  LEU A 158     -56.266   5.452 -10.868  1.00 56.02           C  
ATOM   1186  C   LEU A 158     -55.961   6.517 -11.900  1.00 56.08           C  
ATOM   1187  O   LEU A 158     -55.254   6.253 -12.870  1.00 55.97           O  
ATOM   1188  CB  LEU A 158     -55.100   5.344  -9.872  1.00 56.16           C  
ATOM   1189  CG  LEU A 158     -54.606   6.551  -9.065  1.00 56.12           C  
ATOM   1190  CD1 LEU A 158     -55.729   7.150  -8.214  1.00 56.35           C  
ATOM   1191  CD2 LEU A 158     -53.424   6.149  -8.182  1.00 56.17           C  
ATOM   1192  N   ASP A 159     -56.498   7.720 -11.689  1.00 55.88           N  
ATOM   1193  CA  ASP A 159     -56.051   8.856 -12.476  1.00 55.89           C  
ATOM   1194  C   ASP A 159     -54.709   9.259 -11.913  1.00 55.60           C  
ATOM   1195  O   ASP A 159     -54.631   9.814 -10.815  1.00 56.01           O  
ATOM   1196  CB  ASP A 159     -57.023  10.030 -12.411  1.00 55.99           C  
ATOM   1197  CG  ASP A 159     -56.884  10.968 -13.604  1.00 56.24           C  
ATOM   1198  OD1 ASP A 159     -55.732  11.240 -14.033  1.00 56.13           O  
ATOM   1199  OD2 ASP A 159     -57.934  11.433 -14.109  1.00 56.03           O  
ATOM   1200  N   ALA A 160     -53.651   8.949 -12.658  1.00 55.31           N  
ATOM   1201  CA  ALA A 160     -52.295   9.261 -12.222  1.00 54.98           C  
ATOM   1202  C   ALA A 160     -52.126  10.768 -12.112  1.00 54.84           C  
ATOM   1203  O   ALA A 160     -51.533  11.263 -11.152  1.00 55.11           O  
ATOM   1204  CB  ALA A 160     -51.271   8.671 -13.179  1.00 54.74           C  
ATOM   1205  N   GLU A 161     -52.672  11.489 -13.086  1.00 54.44           N  
ATOM   1206  CA  GLU A 161     -52.554  12.935 -13.129  1.00 54.21           C  
ATOM   1207  C   GLU A 161     -53.206  13.611 -11.909  1.00 53.48           C  
ATOM   1208  O   GLU A 161     -52.535  14.305 -11.159  1.00 53.55           O  
ATOM   1209  CB  GLU A 161     -53.152  13.457 -14.421  1.00 54.86           C  
ATOM   1210  CG  GLU A 161     -52.647  14.827 -14.794  1.00 55.90           C  
ATOM   1211  CD  GLU A 161     -51.368  14.787 -15.619  1.00 56.32           C  
ATOM   1212  OE1 GLU A 161     -50.951  13.677 -16.059  1.00 56.32           O  
ATOM   1213  OE2 GLU A 161     -50.792  15.889 -15.826  1.00 56.51           O  
ATOM   1214  N   ARG A 162     -54.499  13.377 -11.693  1.00 52.45           N  
ATOM   1215  CA  ARG A 162     -55.204  14.001 -10.563  1.00 51.32           C  
ATOM   1216  C   ARG A 162     -54.701  13.558  -9.193  1.00 50.43           C  
ATOM   1217  O   ARG A 162     -54.734  14.340  -8.247  1.00 50.73           O  
ATOM   1218  CB  ARG A 162     -56.718  13.813 -10.673  1.00 51.53           C  
ATOM   1219  CG  ARG A 162     -57.318  14.587 -11.833  1.00 51.83           C  
ATOM   1220  CD  ARG A 162     -58.813  14.714 -11.714  1.00 52.14           C  
ATOM   1221  NE  ARG A 162     -59.487  13.451 -11.984  1.00 52.25           N  
ATOM   1222  CZ  ARG A 162     -59.931  12.610 -11.050  1.00 52.35           C  
ATOM   1223  NH1 ARG A 162     -59.783  12.879  -9.755  1.00 52.08           N  
ATOM   1224  NH2 ARG A 162     -60.535  11.491 -11.425  1.00 52.40           N  
ATOM   1225  N   ALA A 163     -54.242  12.311  -9.092  1.00 48.87           N  
ATOM   1226  CA  ALA A 163     -53.563  11.828  -7.896  1.00 47.09           C  
ATOM   1227  C   ALA A 163     -52.243  12.574  -7.617  1.00 46.20           C  
ATOM   1228  O   ALA A 163     -51.924  12.865  -6.463  1.00 45.28           O  
ATOM   1229  CB  ALA A 163     -53.325  10.315  -7.989  1.00 47.26           C  
ATOM   1230  N   ALA A 164     -51.477  12.879  -8.661  1.00 44.72           N  
ATOM   1231  CA  ALA A 164     -50.204  13.578  -8.475  1.00 43.83           C  
ATOM   1232  C   ALA A 164     -50.427  14.989  -7.927  1.00 43.77           C  
ATOM   1233  O   ALA A 164     -49.644  15.465  -7.089  1.00 43.61           O  
ATOM   1234  CB  ALA A 164     -49.421  13.636  -9.762  1.00 43.69           C  
ATOM   1235  N   VAL A 165     -51.490  15.636  -8.411  1.00 42.97           N  
ATOM   1236  CA  VAL A 165     -51.877  16.953  -7.974  1.00 42.95           C  
ATOM   1237  C   VAL A 165     -52.349  16.921  -6.528  1.00 43.23           C  
ATOM   1238  O   VAL A 165     -51.903  17.744  -5.744  1.00 43.74           O  
ATOM   1239  CB  VAL A 165     -52.968  17.583  -8.875  1.00 43.06           C  
ATOM   1240  CG1 VAL A 165     -53.406  18.927  -8.314  1.00 42.98           C  
ATOM   1241  CG2 VAL A 165     -52.476  17.760 -10.334  1.00 42.41           C  
ATOM   1242  N   ALA A 166     -53.232  15.985  -6.168  1.00 43.41           N  
ATOM   1243  CA  ALA A 166     -53.763  15.883  -4.796  1.00 43.36           C  
ATOM   1244  C   ALA A 166     -52.638  15.766  -3.809  1.00 43.53           C  
ATOM   1245  O   ALA A 166     -52.596  16.478  -2.803  1.00 43.95           O  
ATOM   1246  CB  ALA A 166     -54.692  14.677  -4.650  1.00 43.00           C  
ATOM   1247  N   MET A 167     -51.722  14.860  -4.136  1.00 43.86           N  
ATOM   1248  CA  MET A 167     -50.574  14.528  -3.329  1.00 43.68           C  
ATOM   1249  C   MET A 167     -49.585  15.671  -3.224  1.00 42.90           C  
ATOM   1250  O   MET A 167     -49.212  16.044  -2.100  1.00 42.78           O  
ATOM   1251  CB  MET A 167     -49.889  13.266  -3.858  1.00 45.36           C  
ATOM   1252  CG  MET A 167     -48.581  12.948  -3.176  1.00 46.63           C  
ATOM   1253  SD  MET A 167     -48.603  12.013  -1.610  1.00 50.17           S  
ATOM   1254  CE  MET A 167     -50.224  12.446  -0.955  1.00 47.73           C  
ATOM   1255  N   PHE A 168     -49.137  16.221  -4.355  1.00 41.41           N  
ATOM   1256  CA  PHE A 168     -48.303  17.434  -4.286  1.00 40.36           C  
ATOM   1257  C   PHE A 168     -48.995  18.500  -3.445  1.00 39.44           C  
ATOM   1258  O   PHE A 168     -48.382  19.120  -2.620  1.00 39.55           O  
ATOM   1259  CB  PHE A 168     -47.970  18.008  -5.662  1.00 41.31           C  
ATOM   1260  CG  PHE A 168     -47.093  19.264  -5.617  1.00 41.47           C  
ATOM   1261  CD1 PHE A 168     -45.708  19.171  -5.675  1.00 41.76           C  
ATOM   1262  CD2 PHE A 168     -47.659  20.527  -5.500  1.00 41.38           C  
ATOM   1263  CE1 PHE A 168     -44.908  20.329  -5.621  1.00 41.48           C  
ATOM   1264  CE2 PHE A 168     -46.868  21.667  -5.444  1.00 41.53           C  
ATOM   1265  CZ  PHE A 168     -45.497  21.561  -5.512  1.00 41.28           C  
ATOM   1266  N   ALA A 169     -50.285  18.703  -3.635  1.00 39.01           N  
ATOM   1267  CA  ALA A 169     -51.007  19.742  -2.895  1.00 38.62           C  
ATOM   1268  C   ALA A 169     -50.969  19.496  -1.381  1.00 37.96           C  
ATOM   1269  O   ALA A 169     -50.604  20.383  -0.624  1.00 38.73           O  
ATOM   1270  CB  ALA A 169     -52.441  19.870  -3.418  1.00 38.68           C  
ATOM   1271  N   TYR A 170     -51.292  18.279  -0.958  1.00 37.83           N  
ATOM   1272  CA  TYR A 170     -51.193  17.861   0.439  1.00 37.32           C  
ATOM   1273  C   TYR A 170     -49.790  18.013   1.093  1.00 37.39           C  
ATOM   1274  O   TYR A 170     -49.661  18.582   2.174  1.00 36.63           O  
ATOM   1275  CB  TYR A 170     -51.671  16.409   0.574  1.00 38.62           C  
ATOM   1276  CG  TYR A 170     -51.399  15.837   1.932  1.00 38.62           C  
ATOM   1277  CD1 TYR A 170     -52.191  16.192   3.024  1.00 39.01           C  
ATOM   1278  CD2 TYR A 170     -50.336  14.978   2.136  1.00 38.95           C  
ATOM   1279  CE1 TYR A 170     -51.927  15.687   4.293  1.00 39.36           C  
ATOM   1280  CE2 TYR A 170     -50.059  14.465   3.401  1.00 39.18           C  
ATOM   1281  CZ  TYR A 170     -50.864  14.826   4.474  1.00 39.16           C  
ATOM   1282  OH  TYR A 170     -50.621  14.307   5.730  1.00 39.71           O  
ATOM   1283  N   VAL A 171     -48.748  17.501   0.448  1.00 36.95           N  
ATOM   1284  CA  VAL A 171     -47.367  17.659   0.951  1.00 36.89           C  
ATOM   1285  C   VAL A 171     -46.908  19.131   1.045  1.00 37.32           C  
ATOM   1286  O   VAL A 171     -46.409  19.559   2.095  1.00 37.62           O  
ATOM   1287  CB  VAL A 171     -46.397  16.791   0.133  1.00 37.19           C  
ATOM   1288  CG1 VAL A 171     -44.936  17.133   0.448  1.00 37.07           C  
ATOM   1289  CG2 VAL A 171     -46.688  15.305   0.409  1.00 36.56           C  
ATOM   1290  N   ASP A 172     -47.109  19.904  -0.024  1.00 36.42           N  
ATOM   1291  CA  ASP A 172     -46.880  21.334  -0.019  1.00 36.80           C  
ATOM   1292  C   ASP A 172     -47.624  22.150   1.112  1.00 37.24           C  
ATOM   1293  O   ASP A 172     -47.015  23.021   1.779  1.00 35.94           O  
ATOM   1294  CB  ASP A 172     -47.237  21.871  -1.405  1.00 38.29           C  
ATOM   1295  CG  ASP A 172     -46.964  23.335  -1.552  1.00 38.83           C  
ATOM   1296  OD1 ASP A 172     -45.797  23.721  -1.382  1.00 40.27           O  
ATOM   1297  OD2 ASP A 172     -47.910  24.120  -1.857  1.00 40.61           O  
ATOM   1298  N   GLY A 173     -48.925  21.896   1.314  1.00 36.54           N  
ATOM   1299  CA  GLY A 173     -49.691  22.591   2.364  1.00 35.87           C  
ATOM   1300  C   GLY A 173     -49.201  22.237   3.745  1.00 35.56           C  
ATOM   1301  O   GLY A 173     -49.185  23.072   4.631  1.00 37.24           O  
ATOM   1302  N   LEU A 174     -48.784  20.996   3.919  1.00 35.27           N  
ATOM   1303  CA  LEU A 174     -48.274  20.498   5.172  1.00 35.50           C  
ATOM   1304  C   LEU A 174     -46.934  21.118   5.556  1.00 35.29           C  
ATOM   1305  O   LEU A 174     -46.772  21.579   6.682  1.00 35.00           O  
ATOM   1306  CB  LEU A 174     -48.135  18.966   5.119  1.00 35.42           C  
ATOM   1307  CG  LEU A 174     -48.176  18.303   6.484  1.00 34.97           C  
ATOM   1308  CD1 LEU A 174     -49.567  18.495   7.113  1.00 35.58           C  
ATOM   1309  CD2 LEU A 174     -47.863  16.832   6.326  1.00 35.28           C  
ATOM   1310  N   ILE A 175     -45.978  21.088   4.633  1.00 35.30           N  
ATOM   1311  CA  ILE A 175     -44.700  21.803   4.775  1.00 35.77           C  
ATOM   1312  C   ILE A 175     -44.924  23.284   5.146  1.00 36.72           C  
ATOM   1313  O   ILE A 175     -44.380  23.777   6.132  1.00 35.78           O  
ATOM   1314  CB  ILE A 175     -43.850  21.707   3.461  1.00 35.74           C  
ATOM   1315  CG1 ILE A 175     -43.368  20.262   3.271  1.00 35.78           C  
ATOM   1316  CG2 ILE A 175     -42.677  22.687   3.481  1.00 34.77           C  
ATOM   1317  CD1 ILE A 175     -42.782  19.963   1.918  1.00 35.86           C  
ATOM   1318  N   ARG A 176     -45.755  23.969   4.367  1.00 37.54           N  
ATOM   1319  CA  ARG A 176     -46.115  25.382   4.640  1.00 39.07           C  
ATOM   1320  C   ARG A 176     -46.749  25.630   6.017  1.00 38.31           C  
ATOM   1321  O   ARG A 176     -46.406  26.601   6.675  1.00 38.96           O  
ATOM   1322  CB  ARG A 176     -46.990  25.958   3.512  1.00 39.28           C  
ATOM   1323  CG  ARG A 176     -46.705  27.397   3.224  1.00 41.55           C  
ATOM   1324  CD  ARG A 176     -47.395  27.924   1.951  1.00 43.09           C  
ATOM   1325  NE  ARG A 176     -47.707  29.365   2.023  1.00 44.14           N  
ATOM   1326  CZ  ARG A 176     -47.580  30.249   1.017  1.00 45.72           C  
ATOM   1327  NH1 ARG A 176     -47.114  29.889  -0.200  1.00 45.28           N  
ATOM   1328  NH2 ARG A 176     -47.918  31.536   1.225  1.00 46.02           N  
ATOM   1329  N   ARG A 177     -47.668  24.760   6.426  1.00 38.92           N  
ATOM   1330  CA  ARG A 177     -48.338  24.804   7.734  1.00 39.48           C  
ATOM   1331  C   ARG A 177     -47.301  24.774   8.858  1.00 39.36           C  
ATOM   1332  O   ARG A 177     -47.362  25.558   9.799  1.00 39.55           O  
ATOM   1333  CB  ARG A 177     -49.204  23.548   7.903  1.00 40.48           C  
ATOM   1334  CG  ARG A 177     -50.606  23.681   8.525  1.00 41.53           C  
ATOM   1335  CD  ARG A 177     -50.719  24.279   9.929  1.00 41.88           C  
ATOM   1336  NE  ARG A 177     -52.141  24.508  10.166  1.00 43.36           N  
ATOM   1337  CZ  ARG A 177     -52.874  24.049  11.174  1.00 42.75           C  
ATOM   1338  NH1 ARG A 177     -52.341  23.356  12.160  1.00 43.73           N  
ATOM   1339  NH2 ARG A 177     -54.166  24.327  11.197  1.00 43.81           N  
ATOM   1340  N   TRP A 178     -46.367  23.840   8.760  1.00 39.25           N  
ATOM   1341  CA  TRP A 178     -45.346  23.640   9.787  1.00 39.42           C  
ATOM   1342  C   TRP A 178     -44.295  24.761   9.735  1.00 39.06           C  
ATOM   1343  O   TRP A 178     -43.863  25.268  10.767  1.00 39.14           O  
ATOM   1344  CB  TRP A 178     -44.713  22.245   9.635  1.00 40.21           C  
ATOM   1345  CG  TRP A 178     -43.608  22.009  10.601  1.00 40.76           C  
ATOM   1346  CD1 TRP A 178     -43.717  21.509  11.863  1.00 40.53           C  
ATOM   1347  CD2 TRP A 178     -42.212  22.291  10.396  1.00 41.18           C  
ATOM   1348  NE1 TRP A 178     -42.483  21.462  12.462  1.00 41.45           N  
ATOM   1349  CE2 TRP A 178     -41.541  21.947  11.589  1.00 40.90           C  
ATOM   1350  CE3 TRP A 178     -41.473  22.816   9.327  1.00 40.85           C  
ATOM   1351  CZ2 TRP A 178     -40.163  22.091  11.737  1.00 41.23           C  
ATOM   1352  CZ3 TRP A 178     -40.117  22.970   9.479  1.00 41.20           C  
ATOM   1353  CH2 TRP A 178     -39.466  22.601  10.668  1.00 41.33           C  
ATOM   1354  N   LEU A 179     -43.911  25.189   8.540  1.00 38.19           N  
ATOM   1355  CA  LEU A 179     -43.125  26.409   8.432  1.00 37.94           C  
ATOM   1356  C   LEU A 179     -43.795  27.582   9.171  1.00 38.33           C  
ATOM   1357  O   LEU A 179     -43.116  28.420   9.746  1.00 37.61           O  
ATOM   1358  CB  LEU A 179     -42.866  26.782   6.974  1.00 36.92           C  
ATOM   1359  CG  LEU A 179     -41.963  25.824   6.210  1.00 37.14           C  
ATOM   1360  CD1 LEU A 179     -41.914  26.238   4.771  1.00 35.68           C  
ATOM   1361  CD2 LEU A 179     -40.575  25.832   6.827  1.00 36.91           C  
ATOM   1362  N   LEU A 180     -45.129  27.633   9.132  1.00 38.70           N  
ATOM   1363  CA  LEU A 180     -45.879  28.707   9.778  1.00 39.62           C  
ATOM   1364  C   LEU A 180     -46.092  28.463  11.257  1.00 39.88           C  
ATOM   1365  O   LEU A 180     -45.824  29.339  12.060  1.00 40.94           O  
ATOM   1366  CB  LEU A 180     -47.235  28.940   9.081  1.00 38.92           C  
ATOM   1367  CG  LEU A 180     -48.069  30.177   9.456  1.00 38.26           C  
ATOM   1368  CD1 LEU A 180     -47.425  31.487   9.040  1.00 36.87           C  
ATOM   1369  CD2 LEU A 180     -49.466  30.041   8.874  1.00 37.79           C  
ATOM   1370  N   LEU A 181     -46.587  27.284  11.607  1.00 41.15           N  
ATOM   1371  CA  LEU A 181     -46.918  26.956  12.992  1.00 42.20           C  
ATOM   1372  C   LEU A 181     -46.242  25.654  13.403  1.00 43.14           C  
ATOM   1373  O   LEU A 181     -46.907  24.620  13.477  1.00 43.47           O  
ATOM   1374  CB  LEU A 181     -48.438  26.818  13.154  1.00 41.72           C  
ATOM   1375  CG  LEU A 181     -49.289  28.085  13.014  1.00 41.43           C  
ATOM   1376  CD1 LEU A 181     -50.693  27.721  12.631  1.00 41.15           C  
ATOM   1377  CD2 LEU A 181     -49.277  28.948  14.265  1.00 41.15           C  
ATOM   1378  N   PRO A 182     -44.923  25.697  13.670  1.00 44.03           N  
ATOM   1379  CA  PRO A 182     -44.145  24.483  13.841  1.00 45.06           C  
ATOM   1380  C   PRO A 182     -44.543  23.747  15.087  1.00 46.39           C  
ATOM   1381  O   PRO A 182     -44.863  22.555  15.009  1.00 47.03           O  
ATOM   1382  CB  PRO A 182     -42.712  24.990  13.971  1.00 44.71           C  
ATOM   1383  CG  PRO A 182     -42.739  26.393  13.493  1.00 44.55           C  
ATOM   1384  CD  PRO A 182     -44.091  26.896  13.836  1.00 44.28           C  
ATOM   1385  N   ASP A 183     -44.556  24.466  16.214  1.00 47.89           N  
ATOM   1386  CA  ASP A 183     -44.881  23.901  17.532  1.00 49.61           C  
ATOM   1387  C   ASP A 183     -46.317  23.403  17.612  1.00 50.20           C  
ATOM   1388  O   ASP A 183     -46.800  23.078  18.693  1.00 50.48           O  
ATOM   1389  CB  ASP A 183     -44.611  24.918  18.659  1.00 49.37           C  
ATOM   1390  CG  ASP A 183     -43.129  25.051  18.983  1.00 49.85           C  
ATOM   1391  OD1 ASP A 183     -42.558  24.069  19.515  1.00 50.24           O  
ATOM   1392  OD2 ASP A 183     -42.532  26.132  18.728  1.00 49.68           O  
ATOM   1393  N   SER A 184     -47.004  23.368  16.477  1.00 51.41           N  
ATOM   1394  CA  SER A 184     -48.320  22.761  16.436  1.00 52.96           C  
ATOM   1395  C   SER A 184     -48.151  21.315  16.023  1.00 53.53           C  
ATOM   1396  O   SER A 184     -48.434  20.404  16.804  1.00 54.07           O  
ATOM   1397  CB  SER A 184     -49.275  23.505  15.495  1.00 52.66           C  
ATOM   1398  OG  SER A 184     -49.164  23.063  14.155  1.00 53.17           O  
ATOM   1399  N   VAL A 185     -47.641  21.123  14.812  1.00 54.72           N  
ATOM   1400  CA  VAL A 185     -47.536  19.803  14.204  1.00 55.54           C  
ATOM   1401  C   VAL A 185     -46.138  19.181  14.325  1.00 55.80           C  
ATOM   1402  O   VAL A 185     -45.169  19.653  13.711  1.00 56.35           O  
ATOM   1403  CB  VAL A 185     -48.045  19.837  12.746  1.00 55.60           C  
ATOM   1404  CG1 VAL A 185     -47.401  18.740  11.899  1.00 55.40           C  
ATOM   1405  CG2 VAL A 185     -49.570  19.726  12.750  1.00 55.74           C  
ATOM   1406  N   ASP A 186     -46.055  18.121  15.126  1.00 56.16           N  
ATOM   1407  CA  ASP A 186     -44.802  17.390  15.336  1.00 56.28           C  
ATOM   1408  C   ASP A 186     -44.504  16.594  14.085  1.00 56.02           C  
ATOM   1409  O   ASP A 186     -44.983  15.471  13.909  1.00 55.97           O  
ATOM   1410  CB  ASP A 186     -44.895  16.455  16.547  1.00 56.61           C  
ATOM   1411  CG  ASP A 186     -43.556  15.768  16.881  1.00 57.14           C  
ATOM   1412  OD1 ASP A 186     -42.479  16.351  16.584  1.00 57.37           O  
ATOM   1413  OD2 ASP A 186     -43.578  14.642  17.482  1.00 57.50           O  
ATOM   1414  N   LEU A 187     -43.720  17.197  13.204  1.00 55.55           N  
ATOM   1415  CA  LEU A 187     -43.440  16.558  11.942  1.00 55.20           C  
ATOM   1416  C   LEU A 187     -42.399  15.455  12.098  1.00 54.65           C  
ATOM   1417  O   LEU A 187     -42.369  14.538  11.290  1.00 54.81           O  
ATOM   1418  CB  LEU A 187     -43.048  17.590  10.885  1.00 55.26           C  
ATOM   1419  CG  LEU A 187     -43.284  17.270   9.400  1.00 55.59           C  
ATOM   1420  CD1 LEU A 187     -44.731  16.869   9.095  1.00 55.42           C  
ATOM   1421  CD2 LEU A 187     -42.865  18.449   8.514  1.00 55.55           C  
ATOM   1422  N   LEU A 188     -41.586  15.514  13.157  1.00 54.07           N  
ATOM   1423  CA  LEU A 188     -40.476  14.555  13.340  1.00 53.36           C  
ATOM   1424  C   LEU A 188     -40.817  13.302  14.171  1.00 53.07           C  
ATOM   1425  O   LEU A 188     -40.070  12.313  14.165  1.00 53.42           O  
ATOM   1426  CB  LEU A 188     -39.239  15.275  13.900  1.00 53.55           C  
ATOM   1427  CG  LEU A 188     -37.899  14.564  14.160  1.00 53.57           C  
ATOM   1428  CD1 LEU A 188     -37.193  14.074  12.901  1.00 53.36           C  
ATOM   1429  CD2 LEU A 188     -36.989  15.471  14.952  1.00 53.69           C  
ATOM   1430  N   GLY A 189     -41.930  13.342  14.901  1.00 52.31           N  
ATOM   1431  CA  GLY A 189     -42.353  12.197  15.696  1.00 51.20           C  
ATOM   1432  C   GLY A 189     -43.387  11.360  14.979  1.00 50.83           C  
ATOM   1433  O   GLY A 189     -43.308  10.129  14.987  1.00 50.62           O  
ATOM   1434  N   ASP A 190     -44.359  12.035  14.361  1.00 50.17           N  
ATOM   1435  CA  ASP A 190     -45.460  11.369  13.657  1.00 49.68           C  
ATOM   1436  C   ASP A 190     -45.205  11.256  12.177  1.00 48.99           C  
ATOM   1437  O   ASP A 190     -46.103  10.903  11.420  1.00 49.14           O  
ATOM   1438  CB  ASP A 190     -46.776  12.115  13.877  1.00 50.15           C  
ATOM   1439  CG  ASP A 190     -47.177  12.154  15.326  1.00 50.46           C  
ATOM   1440  OD1 ASP A 190     -47.565  11.093  15.878  1.00 50.70           O  
ATOM   1441  OD2 ASP A 190     -47.090  13.251  15.917  1.00 51.07           O  
ATOM   1442  N   VAL A 191     -43.971  11.549  11.783  1.00 48.30           N  
ATOM   1443  CA  VAL A 191     -43.580  11.735  10.386  1.00 47.46           C  
ATOM   1444  C   VAL A 191     -44.129  10.653   9.462  1.00 47.23           C  
ATOM   1445  O   VAL A 191     -44.468  10.921   8.288  1.00 46.88           O  
ATOM   1446  CB  VAL A 191     -42.031  11.884  10.254  1.00 47.71           C  
ATOM   1447  CG1 VAL A 191     -41.281  10.606  10.746  1.00 47.28           C  
ATOM   1448  CG2 VAL A 191     -41.634  12.291   8.838  1.00 46.94           C  
ATOM   1449  N   GLU A 192     -44.244   9.452  10.028  1.00 46.56           N  
ATOM   1450  CA  GLU A 192     -44.806   8.271   9.363  1.00 45.74           C  
ATOM   1451  C   GLU A 192     -46.314   8.421   9.114  1.00 45.11           C  
ATOM   1452  O   GLU A 192     -46.795   8.047   8.054  1.00 44.58           O  
ATOM   1453  CB  GLU A 192     -44.469   6.987  10.162  1.00 46.02           C  
ATOM   1454  CG  GLU A 192     -43.138   7.080  10.924  1.00 46.01           C  
ATOM   1455  CD  GLU A 192     -42.421   5.745  11.110  1.00 46.86           C  
ATOM   1456  OE1 GLU A 192     -43.079   4.711  11.416  1.00 46.69           O  
ATOM   1457  OE2 GLU A 192     -41.168   5.743  10.975  1.00 47.01           O  
ATOM   1458  N   LYS A 193     -47.039   9.004  10.072  1.00 44.61           N  
ATOM   1459  CA  LYS A 193     -48.488   9.250   9.957  1.00 44.31           C  
ATOM   1460  C   LYS A 193     -48.829  10.321   8.911  1.00 44.41           C  
ATOM   1461  O   LYS A 193     -49.880  10.269   8.251  1.00 44.18           O  
ATOM   1462  CB  LYS A 193     -49.072   9.663  11.313  1.00 44.62           C  
ATOM   1463  CG  LYS A 193     -49.084   8.554  12.377  1.00 44.95           C  
ATOM   1464  CD  LYS A 193     -49.907   8.965  13.606  1.00 45.21           C  
ATOM   1465  CE  LYS A 193     -49.717   7.988  14.751  1.00 45.42           C  
ATOM   1466  NZ  LYS A 193     -50.701   8.270  15.845  1.00 46.07           N  
ATOM   1467  N   TRP A 194     -47.934  11.294   8.759  1.00 43.57           N  
ATOM   1468  CA  TRP A 194     -48.166  12.373   7.822  1.00 42.93           C  
ATOM   1469  C   TRP A 194     -47.959  11.911   6.379  1.00 43.24           C  
ATOM   1470  O   TRP A 194     -48.755  12.232   5.491  1.00 43.52           O  
ATOM   1471  CB  TRP A 194     -47.307  13.582   8.170  1.00 41.75           C  
ATOM   1472  CG  TRP A 194     -47.716  14.239   9.443  1.00 40.68           C  
ATOM   1473  CD1 TRP A 194     -46.975  14.336  10.583  1.00 40.85           C  
ATOM   1474  CD2 TRP A 194     -48.967  14.883   9.721  1.00 40.51           C  
ATOM   1475  NE1 TRP A 194     -47.675  15.012  11.550  1.00 40.43           N  
ATOM   1476  CE2 TRP A 194     -48.901  15.361  11.050  1.00 40.18           C  
ATOM   1477  CE3 TRP A 194     -50.130  15.129   8.969  1.00 40.07           C  
ATOM   1478  CZ2 TRP A 194     -49.950  16.058  11.649  1.00 39.83           C  
ATOM   1479  CZ3 TRP A 194     -51.181  15.805   9.572  1.00 39.77           C  
ATOM   1480  CH2 TRP A 194     -51.079  16.269  10.898  1.00 39.83           C  
ATOM   1481  N   VAL A 195     -46.905  11.139   6.156  1.00 43.49           N  
ATOM   1482  CA  VAL A 195     -46.603  10.645   4.825  1.00 43.78           C  
ATOM   1483  C   VAL A 195     -47.714   9.697   4.403  1.00 44.11           C  
ATOM   1484  O   VAL A 195     -48.190   9.778   3.255  1.00 44.27           O  
ATOM   1485  CB  VAL A 195     -45.230   9.937   4.775  1.00 43.49           C  
ATOM   1486  CG1 VAL A 195     -45.062   9.171   3.486  1.00 44.12           C  
ATOM   1487  CG2 VAL A 195     -44.109  10.921   4.922  1.00 43.84           C  
ATOM   1488  N   ASP A 196     -48.133   8.837   5.351  1.00 44.35           N  
ATOM   1489  CA  ASP A 196     -49.088   7.746   5.122  1.00 44.18           C  
ATOM   1490  C   ASP A 196     -50.505   8.232   4.883  1.00 44.46           C  
ATOM   1491  O   ASP A 196     -51.208   7.683   4.031  1.00 44.62           O  
ATOM   1492  CB  ASP A 196     -49.066   6.758   6.289  1.00 44.73           C  
ATOM   1493  N   THR A 197     -50.924   9.254   5.633  1.00 44.59           N  
ATOM   1494  CA  THR A 197     -52.234   9.904   5.432  1.00 44.57           C  
ATOM   1495  C   THR A 197     -52.428  10.353   4.007  1.00 44.84           C  
ATOM   1496  O   THR A 197     -53.520  10.236   3.443  1.00 44.54           O  
ATOM   1497  CB  THR A 197     -52.386  11.161   6.281  1.00 44.36           C  
ATOM   1498  OG1 THR A 197     -52.235  10.825   7.662  1.00 43.96           O  
ATOM   1499  CG2 THR A 197     -53.750  11.816   6.040  1.00 43.93           C  
ATOM   1500  N   GLY A 198     -51.354  10.884   3.438  1.00 45.20           N  
ATOM   1501  CA  GLY A 198     -51.402  11.416   2.093  1.00 46.08           C  
ATOM   1502  C   GLY A 198     -51.493  10.263   1.131  1.00 46.58           C  
ATOM   1503  O   GLY A 198     -52.348  10.267   0.247  1.00 46.81           O  
ATOM   1504  N   LEU A 199     -50.595   9.285   1.306  1.00 47.19           N  
ATOM   1505  CA  LEU A 199     -50.544   8.073   0.461  1.00 47.19           C  
ATOM   1506  C   LEU A 199     -51.846   7.268   0.486  1.00 47.51           C  
ATOM   1507  O   LEU A 199     -52.281   6.779  -0.555  1.00 47.36           O  
ATOM   1508  CB  LEU A 199     -49.356   7.186   0.836  1.00 46.96           C  
ATOM   1509  CG  LEU A 199     -47.934   7.622   0.459  1.00 46.98           C  
ATOM   1510  CD1 LEU A 199     -46.940   6.561   0.928  1.00 46.65           C  
ATOM   1511  CD2 LEU A 199     -47.787   7.859  -1.043  1.00 46.62           C  
ATOM   1512  N   ASP A 200     -52.465   7.155   1.664  1.00 48.03           N  
ATOM   1513  CA  ASP A 200     -53.824   6.581   1.803  1.00 48.77           C  
ATOM   1514  C   ASP A 200     -54.855   7.235   0.875  1.00 49.26           C  
ATOM   1515  O   ASP A 200     -55.672   6.544   0.267  1.00 49.89           O  
ATOM   1516  CB  ASP A 200     -54.344   6.730   3.236  1.00 48.53           C  
ATOM   1517  CG  ASP A 200     -53.587   5.884   4.244  1.00 48.42           C  
ATOM   1518  OD1 ASP A 200     -52.819   4.980   3.845  1.00 48.43           O  
ATOM   1519  OD2 ASP A 200     -53.771   6.135   5.454  1.00 48.12           O  
ATOM   1520  N   MET A 201     -54.824   8.566   0.784  1.00 49.73           N  
ATOM   1521  CA  MET A 201     -55.741   9.306  -0.087  1.00 49.99           C  
ATOM   1522  C   MET A 201     -55.631   8.792  -1.523  1.00 50.17           C  
ATOM   1523  O   MET A 201     -56.640   8.726  -2.233  1.00 50.23           O  
ATOM   1524  CB  MET A 201     -55.493  10.831   0.004  1.00 49.73           C  
ATOM   1525  CG  MET A 201     -56.418  11.722  -0.850  1.00 49.88           C  
ATOM   1526  SD  MET A 201     -55.966  13.493  -0.971  1.00 49.66           S  
ATOM   1527  CE  MET A 201     -54.155  13.445  -0.997  1.00 49.65           C  
ATOM   1528  N   LEU A 202     -54.416   8.409  -1.933  1.00 50.47           N  
ATOM   1529  CA  LEU A 202     -54.167   7.948  -3.301  1.00 50.67           C  
ATOM   1530  C   LEU A 202     -54.688   6.534  -3.563  1.00 51.09           C  
ATOM   1531  O   LEU A 202     -55.140   6.230  -4.670  1.00 50.63           O  
ATOM   1532  CB  LEU A 202     -52.683   8.008  -3.648  1.00 50.92           C  
ATOM   1533  CG  LEU A 202     -51.803   9.243  -3.471  1.00 50.72           C  
ATOM   1534  CD1 LEU A 202     -50.484   8.898  -4.098  1.00 51.02           C  
ATOM   1535  CD2 LEU A 202     -52.363  10.491  -4.122  1.00 50.84           C  
ATOM   1536  N   ARG A 203     -54.613   5.668  -2.558  1.00 51.73           N  
ATOM   1537  CA  ARG A 203     -55.115   4.304  -2.740  1.00 52.47           C  
ATOM   1538  C   ARG A 203     -56.595   4.112  -2.434  1.00 52.34           C  
ATOM   1539  O   ARG A 203     -57.194   3.175  -2.946  1.00 52.67           O  
ATOM   1540  CB  ARG A 203     -54.254   3.210  -2.075  1.00 52.82           C  
ATOM   1541  CG  ARG A 203     -53.330   3.598  -0.944  1.00 53.55           C  
ATOM   1542  CD  ARG A 203     -52.676   2.319  -0.393  1.00 54.60           C  
ATOM   1543  NE  ARG A 203     -52.431   2.384   1.050  1.00 55.35           N  
ATOM   1544  CZ  ARG A 203     -53.289   1.967   1.982  1.00 55.43           C  
ATOM   1545  NH1 ARG A 203     -54.458   1.440   1.631  1.00 55.80           N  
ATOM   1546  NH2 ARG A 203     -52.977   2.075   3.269  1.00 55.56           N  
ATOM   1547  N   LEU A 204     -57.189   5.003  -1.646  1.00 52.38           N  
ATOM   1548  CA  LEU A 204     -58.566   4.798  -1.210  1.00 52.51           C  
ATOM   1549  C   LEU A 204     -59.614   5.704  -1.828  1.00 52.81           C  
ATOM   1550  O   LEU A 204     -60.778   5.315  -1.928  1.00 53.47           O  
ATOM   1551  CB  LEU A 204     -58.670   4.862   0.306  1.00 52.16           C  
ATOM   1552  CG  LEU A 204     -57.985   3.727   1.060  1.00 52.20           C  
ATOM   1553  CD1 LEU A 204     -58.060   4.058   2.507  1.00 52.00           C  
ATOM   1554  CD2 LEU A 204     -58.602   2.355   0.774  1.00 51.74           C  
ATOM   1555  N   SER A 205     -59.215   6.902  -2.237  1.00 52.86           N  
ATOM   1556  CA  SER A 205     -60.153   7.887  -2.748  1.00 52.85           C  
ATOM   1557  C   SER A 205     -60.829   7.452  -4.048  1.00 52.72           C  
ATOM   1558  O   SER A 205     -60.142   7.269  -5.052  1.00 53.15           O  
ATOM   1559  CB  SER A 205     -59.461   9.232  -2.940  1.00 52.67           C  
ATOM   1560  OG  SER A 205     -60.430  10.257  -3.074  1.00 53.22           O  
ATOM   1561  N   PRO A 206     -62.176   7.292  -4.031  1.00 52.53           N  
ATOM   1562  CA  PRO A 206     -62.926   6.963  -5.233  1.00 52.48           C  
ATOM   1563  C   PRO A 206     -62.908   8.122  -6.206  1.00 52.44           C  
ATOM   1564  O   PRO A 206     -62.889   7.914  -7.419  1.00 52.43           O  
ATOM   1565  CB  PRO A 206     -64.356   6.754  -4.716  1.00 52.58           C  
ATOM   1566  CG  PRO A 206     -64.231   6.583  -3.251  1.00 52.49           C  
ATOM   1567  CD  PRO A 206     -63.070   7.418  -2.870  1.00 52.40           C  
ATOM   1568  N   ALA A 207     -62.907   9.336  -5.652  1.00 52.66           N  
ATOM   1569  CA  ALA A 207     -62.797  10.579  -6.410  1.00 52.35           C  
ATOM   1570  C   ALA A 207     -61.557  10.657  -7.308  1.00 52.42           C  
ATOM   1571  O   ALA A 207     -61.591  11.327  -8.339  1.00 52.22           O  
ATOM   1572  CB  ALA A 207     -62.853  11.758  -5.466  1.00 52.29           C  
ATOM   1573  N   LEU A 208     -60.479   9.961  -6.927  1.00 52.65           N  
ATOM   1574  CA  LEU A 208     -59.241   9.914  -7.733  1.00 53.00           C  
ATOM   1575  C   LEU A 208     -59.170   8.819  -8.798  1.00 53.39           C  
ATOM   1576  O   LEU A 208     -58.157   8.708  -9.497  1.00 53.72           O  
ATOM   1577  CB  LEU A 208     -58.005   9.824  -6.838  1.00 52.53           C  
ATOM   1578  CG  LEU A 208     -57.584  11.138  -6.162  1.00 52.54           C  
ATOM   1579  CD1 LEU A 208     -56.465  10.881  -5.190  1.00 52.02           C  
ATOM   1580  CD2 LEU A 208     -57.184  12.210  -7.172  1.00 52.19           C  
ATOM   1581  N   ARG A 209     -60.240   8.033  -8.924  1.00 53.87           N  
ATOM   1582  CA  ARG A 209     -60.275   6.889  -9.841  1.00 54.62           C  
ATOM   1583  C   ARG A 209     -60.886   7.170 -11.218  1.00 54.81           C  
ATOM   1584  O   ARG A 209     -61.668   8.106 -11.385  1.00 54.95           O  
ATOM   1585  CB  ARG A 209     -60.971   5.689  -9.183  1.00 54.69           C  
ATOM   1586  CG  ARG A 209     -60.072   4.924  -8.225  1.00 54.88           C  
ATOM   1587  CD  ARG A 209     -60.860   4.114  -7.242  1.00 55.34           C  
ATOM   1588  NE  ARG A 209     -60.013   3.630  -6.156  1.00 55.82           N  
ATOM   1589  CZ  ARG A 209     -60.443   3.398  -4.915  1.00 55.97           C  
ATOM   1590  NH1 ARG A 209     -61.716   3.614  -4.584  1.00 56.24           N  
ATOM   1591  NH2 ARG A 209     -59.596   2.952  -4.000  1.00 56.15           N  
ATOM   1592  N   LYS A 210     -60.471   6.363 -12.194  1.00 55.27           N  
ATOM   1593  CA  LYS A 210     -61.005   6.343 -13.572  1.00 55.95           C  
ATOM   1594  C   LYS A 210     -60.104   7.060 -14.596  1.00 56.06           C  
ATOM   1595  O   LYS A 210     -58.953   7.431 -14.302  1.00 56.17           O  
ATOM   1596  CB  LYS A 210     -62.473   6.830 -13.636  1.00 55.85           C  
ATOM   1597  CG  LYS A 210     -63.561   5.744 -13.488  1.00 56.07           C  
ATOM   1598  CD  LYS A 210     -63.210   4.609 -12.489  1.00 55.94           C  
ATOM   1599  CE  LYS A 210     -64.436   3.781 -12.092  1.00 56.03           C  
ATOM   1600  NZ  LYS A 210     -65.244   3.246 -13.274  1.00 55.77           N  
ATOM   1601  OXT LYS A 210     -60.490   7.270 -15.763  1.00 56.60           O  
TER    1602      LYS A 210                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
