
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  148 ( 1132),  selected  148 , name 2p19_A
# Molecule2: number of CA atoms  139 ( 1121),  selected  139 , name T0455.pdb
# PARAMETERS: 2p19_A.T0455.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      -       -           -
LGA    N     3_A      -       -           -
LGA    A     4_A      -       -           -
LGA    N     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    P     8_A      -       -           -
LGA    K     9_A      S       7          1.521
LGA    T    10_A      S       8          1.025
LGA    R    11_A      R       9          1.345
LGA    V    12_A      T      10          0.840
LGA    L    13_A      V      11          0.934
LGA    E    14_A      S      12          0.891
LGA    H    15_A      Y      13          0.905
LGA    R    16_A      F      14          0.525
LGA    L    17_A      V      15          0.387
LGA    L    18_A      A      16          0.305
LGA    A    19_A      K      17          0.642
LGA    A    20_A      P      18          1.177
LGA    S    21_A      S      19          2.079
LGA    S    22_A      S      20          2.868
LGA    A    23_A      S      21          2.582
LGA    I    24_A      E      22          1.227
LGA    A    25_A      M      23          1.310
LGA    E    26_A      E      24          1.889
LGA    K    27_A      K      25          1.388
LGA    L    28_A      L      26          0.991
LGA    G    29_A      Q      27          1.457
LGA    V    30_A      L      28          1.530
LGA    S    31_A      G      29          0.922
LGA    A    32_A      P      30          1.489
LGA    G    33_A      E      31          2.423
LGA    D    34_A      D      32          1.280
LGA    E    35_A      S      33          0.787
LGA    V    36_A      I      34          0.705
LGA    L    37_A      L      35          0.591
LGA    L    38_A      R      36          0.297
LGA    I    39_A      M      37          1.060
LGA    R    40_A      E      38          0.803
LGA    R    41_A      R      39          0.860
LGA    L    42_A      I      40          0.773
LGA    R    43_A      R      41          0.765
LGA    S    44_A      F      42          0.823
LGA    T    45_A      A      43          0.968
LGA    G    46_A      D      44          2.128
LGA    D    47_A      D      45          0.763
LGA    I    48_A      I      46          0.967
LGA    P    49_A      P      47          0.400
LGA    V    50_A      I      48          0.508
LGA    A    51_A      C      49          0.638
LGA    I    52_A      F      50          0.451
LGA    L    53_A      E      51          1.171
LGA    E    54_A      V      52          1.031
LGA    N    55_A      A      53          0.728
LGA    Y    56_A      S      54          0.572
LGA    L    57_A      I      55          0.398
LGA    P    58_A      P      56          1.029
LGA    P    59_A      Y      57          3.002
LGA    A    60_A      S      58          2.559
LGA    F    61_A      L      59          2.081
LGA    N    62_A      V      60          3.657
LGA    D    63_A      S      61          2.445
LGA    -       -      Q      62           -
LGA    V    64_A      Y      63          4.408
LGA    S    65_A      G      64          3.026
LGA    L    66_A      K      65          2.327
LGA    D    67_A      S      66          2.673
LGA    E    68_A      E      67          2.120
LGA    L    69_A      I      68          4.379
LGA    E    70_A      T      69          5.579
LGA    K    71_A      -       -           -
LGA    G    72_A      N      70          2.247
LGA    G    73_A      S      71          3.536
LGA    L    74_A      F      72          2.457
LGA    Y    75_A      Y      73          1.671
LGA    D    76_A      K      74          2.667
LGA    A    77_A      T      75          2.936
LGA    L    78_A      L      76          1.826
LGA    R    79_A      E      77          2.547
LGA    S    80_A      A      78          3.358
LGA    R    81_A      K      79          2.540
LGA    G    82_A      S      80          3.306
LGA    -       -      G      81           -
LGA    V    83_A      H      82          3.893
LGA    V    84_A      K      83          3.088
LGA    L    85_A      I      84          1.898
LGA    K    86_A      G      85          1.391
LGA    I    87_A      H      86          0.569
LGA    A    88_A      S      87          0.867
LGA    N    89_A      N      88          0.486
LGA    Q    90_A      Q      89          0.246
LGA    K    91_A      T      90          0.242
LGA    I    92_A      I      91          0.330
LGA    G    93_A      S      92          0.426
LGA    A    94_A      A      93          0.841
LGA    R    95_A      V      94          0.469
LGA    R    96_A      Q      95          0.781
LGA    A    97_A      A      96          0.783
LGA    V    98_A      S      97          0.666
LGA    G    99_A      E      98          2.799
LGA    E   100_A      Q      99          1.923
LGA    E   101_A      I     100          0.861
LGA    S   102_A      A     101          0.872
LGA    T   103_A      E     102          1.583
LGA    L   104_A      Y     103          1.065
LGA    L   105_A      L     104          0.751
LGA    D   106_A      E     105          1.040
LGA    I   107_A      I     106          0.897
LGA    E   108_A      K     107          1.262
LGA    D   109_A      R     108          1.469
LGA    G   110_A      G     109          1.317
LGA    G   111_A      D     110          0.605
LGA    P   112_A      A     111          0.721
LGA    L   113_A      I     112          0.521
LGA    L   114_A      L     113          0.403
LGA    T   115_A      R     114          0.307
LGA    V   116_A      V     115          0.338
LGA    E   117_A      R     116          0.722
LGA    R   118_A      Q     117          0.271
LGA    V   119_A      V     118          0.625
LGA    A   120_A      S     119          0.310
LGA    L   121_A      Y     120          0.770
LGA    D   122_A      F     121          1.115
LGA    N   123_A      E     122          0.706
LGA    S   124_A      N     123          0.531
LGA    G   125_A      G     124          0.656
LGA    Q   126_A      L     125          0.737
LGA    V   127_A      P     126          0.573
LGA    I   128_A      F     127          1.324
LGA    E   129_A      E     128          0.676
LGA    L   130_A      Y     129          0.711
LGA    G   131_A      V     130          0.538
LGA    S   132_A      R     131          0.570
LGA    H   133_A      T     132          0.480
LGA    C   134_A      Q     133          0.388
LGA    Y   135_A      Y     134          0.311
LGA    R   136_A      A     135          0.833
LGA    P   137_A      G     136          1.524
LGA    D   138_A      S     137          2.023
LGA    M   139_A      R     138          2.161
LGA    Y   140_A      F     139          1.829
LGA    N   141_A      E     140          1.578
LGA    F   142_A      F     141          1.658
LGA    E   143_A      Y     142          1.608
LGA    T   144_A      L     143          1.486
LGA    -       -      E     144           -
LGA    T   145_A      K     145          3.204
LGA    L   146_A      -       -           -
LGA    V   147_A      -       -           -
LGA    A   148_A      -       -           -
LGA    R   149_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  148  139    5.0    136    1.70    23.53     90.004     7.549

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.738987 * X  +   0.621647 * Y  +  -0.259720 * Z  +  70.904076
  Y_new =  -0.565500 * X  +  -0.781883 * Y  +  -0.262428 * Z  +  77.359146
  Z_new =  -0.366208 * X  +  -0.047059 * Y  +   0.929342 * Z  +  30.248873 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.050594    3.090999  [ DEG:    -2.8988    177.1012 ]
  Theta =   0.374931    2.766662  [ DEG:    21.4820    158.5181 ]
  Phi   =  -2.488411    0.653182  [ DEG:  -142.5754     37.4246 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p19_A                                        
REMARK     2: T0455.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p19_A.T0455.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  148  139   5.0  136   1.70   23.53  90.004
REMARK  ---------------------------------------------------------- 
MOLECULE 2p19_A
HEADER    TRANSCRIPTION                           02-MAR-07   2P19              
TITLE     CRYSTAL STRUCTURE OF BACTERIAL REGULATORY PROTEIN OF GNTR             
TITLE    2 FAMILY FROM CORYNEBACTERIUM GLUTAMICUM                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR;                                 
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: RESIDUES 105-253;                                          
COMPND   5 SYNONYM: BACTERIAL REGULATORY PROTEIN, GNTR FAMILY;                  
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CORYNEBACTERIUM GLUTAMICUM;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: DSM 20300, JCM 1318, LMG 3730, NCIMB 10025;                  
SOURCE   5 ATCC: 13032;                                                         
SOURCE   6 GENE: CGL0157, CG0196;                                               
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    BACTERIAL REGULATORY PROTEIN, GNTR FAMILY, MCSG, STRUCTURAL           
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,M.ZHOU,M.GU,A.JOACHIMIAK,MIDWEST CENTER FOR                   
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   22-MAY-07 2P19    0                                                
JRNL        AUTH   R.ZHANG,M.ZHOU,M.GU,A.JOACHIMIAK                             
JRNL        TITL   THE CRYSTAL STRUCTURE OF BACTERIAL REGULATORY                
JRNL        TITL 2 PROTEIN OF GNTR FAMILY FROM CORYNEBACTERIUM                  
JRNL        TITL 3 GLUTAMICUM                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2P19 A    1   149  UNP    Q8NTZ4   Q8NTZ4_CORGL   105    253             
DBREF  2P19 B    1   149  UNP    Q8NTZ4   Q8NTZ4_CORGL   105    253             
DBREF  2P19 C    1   149  UNP    Q8NTZ4   Q8NTZ4_CORGL   105    253             
SEQRES   1 A  149  LEU LYS ASN ALA ASN LEU ASP PRO LYS THR ARG VAL LEU          
SEQRES   2 A  149  GLU HIS ARG LEU LEU ALA ALA SER SER ALA ILE ALA GLU          
SEQRES   3 A  149  LYS LEU GLY VAL SER ALA GLY ASP GLU VAL LEU LEU ILE          
SEQRES   4 A  149  ARG ARG LEU ARG SER THR GLY ASP ILE PRO VAL ALA ILE          
SEQRES   5 A  149  LEU GLU ASN TYR LEU PRO PRO ALA PHE ASN ASP VAL SER          
SEQRES   6 A  149  LEU ASP GLU LEU GLU LYS GLY GLY LEU TYR ASP ALA LEU          
SEQRES   7 A  149  ARG SER ARG GLY VAL VAL LEU LYS ILE ALA ASN GLN LYS          
SEQRES   8 A  149  ILE GLY ALA ARG ARG ALA VAL GLY GLU GLU SER THR LEU          
SEQRES   9 A  149  LEU ASP ILE GLU ASP GLY GLY PRO LEU LEU THR VAL GLU          
SEQRES  10 A  149  ARG VAL ALA LEU ASP ASN SER GLY GLN VAL ILE GLU LEU          
SEQRES  11 A  149  GLY SER HIS CYS TYR ARG PRO ASP MET TYR ASN PHE GLU          
SEQRES  12 A  149  THR THR LEU VAL ALA ARG                                      
SEQRES   1 B  149  LEU LYS ASN ALA ASN LEU ASP PRO LYS THR ARG VAL LEU          
SEQRES   2 B  149  GLU HIS ARG LEU LEU ALA ALA SER SER ALA ILE ALA GLU          
SEQRES   3 B  149  LYS LEU GLY VAL SER ALA GLY ASP GLU VAL LEU LEU ILE          
SEQRES   4 B  149  ARG ARG LEU ARG SER THR GLY ASP ILE PRO VAL ALA ILE          
SEQRES   5 B  149  LEU GLU ASN TYR LEU PRO PRO ALA PHE ASN ASP VAL SER          
SEQRES   6 B  149  LEU ASP GLU LEU GLU LYS GLY GLY LEU TYR ASP ALA LEU          
SEQRES   7 B  149  ARG SER ARG GLY VAL VAL LEU LYS ILE ALA ASN GLN LYS          
SEQRES   8 B  149  ILE GLY ALA ARG ARG ALA VAL GLY GLU GLU SER THR LEU          
SEQRES   9 B  149  LEU ASP ILE GLU ASP GLY GLY PRO LEU LEU THR VAL GLU          
SEQRES  10 B  149  ARG VAL ALA LEU ASP ASN SER GLY GLN VAL ILE GLU LEU          
SEQRES  11 B  149  GLY SER HIS CYS TYR ARG PRO ASP MET TYR ASN PHE GLU          
SEQRES  12 B  149  THR THR LEU VAL ALA ARG                                      
SEQRES   1 C  149  LEU LYS ASN ALA ASN LEU ASP PRO LYS THR ARG VAL LEU          
SEQRES   2 C  149  GLU HIS ARG LEU LEU ALA ALA SER SER ALA ILE ALA GLU          
SEQRES   3 C  149  LYS LEU GLY VAL SER ALA GLY ASP GLU VAL LEU LEU ILE          
SEQRES   4 C  149  ARG ARG LEU ARG SER THR GLY ASP ILE PRO VAL ALA ILE          
SEQRES   5 C  149  LEU GLU ASN TYR LEU PRO PRO ALA PHE ASN ASP VAL SER          
SEQRES   6 C  149  LEU ASP GLU LEU GLU LYS GLY GLY LEU TYR ASP ALA LEU          
SEQRES   7 C  149  ARG SER ARG GLY VAL VAL LEU LYS ILE ALA ASN GLN LYS          
SEQRES   8 C  149  ILE GLY ALA ARG ARG ALA VAL GLY GLU GLU SER THR LEU          
SEQRES   9 C  149  LEU ASP ILE GLU ASP GLY GLY PRO LEU LEU THR VAL GLU          
SEQRES  10 C  149  ARG VAL ALA LEU ASP ASN SER GLY GLN VAL ILE GLU LEU          
SEQRES  11 C  149  GLY SER HIS CYS TYR ARG PRO ASP MET TYR ASN PHE GLU          
SEQRES  12 C  149  THR THR LEU VAL ALA ARG                                      
FORMUL   4  HOH   *506(H2 O)                                                    
CRYST1  106.418  106.418  225.950  90.00  90.00 120.00 P 61 2 2     36          
ATOM      1  N   LYS A   2      56.047  30.455  37.317  1.00 46.41           N  
ATOM      2  CA  LYS A   2      56.810  30.212  36.044  1.00 46.58           C  
ATOM      3  C   LYS A   2      57.005  28.717  35.728  1.00 44.90           C  
ATOM      4  O   LYS A   2      57.083  28.325  34.554  1.00 45.16           O  
ATOM      5  CB  LYS A   2      58.158  30.937  36.075  1.00 46.59           C  
ATOM      6  CG  LYS A   2      58.708  31.290  34.681  1.00 48.42           C  
ATOM      7  CD  LYS A   2      59.636  32.528  34.678  1.00 49.15           C  
ATOM      8  CE  LYS A   2      60.983  32.262  35.401  1.00 53.79           C  
ATOM      9  NZ  LYS A   2      62.116  33.111  34.884  1.00 54.07           N  
ATOM     10  N   ASN A   3      57.075  27.889  36.771  1.00 43.42           N  
ATOM     11  CA  ASN A   3      57.275  26.437  36.610  1.00 41.57           C  
ATOM     12  C   ASN A   3      56.132  25.774  35.822  1.00 41.23           C  
ATOM     13  O   ASN A   3      56.356  24.854  35.034  1.00 39.93           O  
ATOM     14  CB  ASN A   3      57.433  25.758  37.973  1.00 40.86           C  
ATOM     15  CG  ASN A   3      58.820  25.980  38.621  1.00 40.34           C  
ATOM     16  OD1 ASN A   3      59.068  25.509  39.745  1.00 37.88           O  
ATOM     17  ND2 ASN A   3      59.716  26.681  37.922  1.00 34.06           N  
ATOM     18  N   ALA A   4      54.913  26.270  36.043  1.00 41.22           N  
ATOM     19  CA  ALA A   4      53.693  25.723  35.441  1.00 41.50           C  
ATOM     20  C   ALA A   4      53.302  26.421  34.128  1.00 41.59           C  
ATOM     21  O   ALA A   4      52.310  26.056  33.497  1.00 40.70           O  
ATOM     22  CB  ALA A   4      52.533  25.783  36.453  1.00 41.22           C  
ATOM     23  N   ASN A   5      54.086  27.422  33.725  1.00 42.27           N  
ATOM     24  CA  ASN A   5      53.831  28.159  32.479  1.00 42.95           C  
ATOM     25  C   ASN A   5      54.166  27.325  31.262  1.00 42.41           C  
ATOM     26  O   ASN A   5      55.202  26.648  31.243  1.00 43.22           O  
ATOM     27  CB  ASN A   5      54.649  29.449  32.426  1.00 43.61           C  
ATOM     28  CG  ASN A   5      54.087  30.542  33.314  1.00 46.27           C  
ATOM     29  OD1 ASN A   5      54.773  31.537  33.578  1.00 50.40           O  
ATOM     30  ND2 ASN A   5      52.839  30.380  33.770  1.00 47.40           N  
ATOM     31  N   LEU A   6      53.289  27.367  30.255  1.00 41.12           N  
ATOM     32  CA  LEU A   6      53.539  26.709  28.971  1.00 39.90           C  
ATOM     33  C   LEU A   6      53.806  27.777  27.895  1.00 38.70           C  
ATOM     34  O   LEU A   6      52.982  28.668  27.667  1.00 38.17           O  
ATOM     35  CB  LEU A   6      52.353  25.829  28.579  1.00 40.29           C  
ATOM     36  CG  LEU A   6      51.857  24.768  29.574  1.00 41.70           C  
ATOM     37  CD1 LEU A   6      50.440  24.322  29.240  1.00 41.72           C  
ATOM     38  CD2 LEU A   6      52.815  23.589  29.598  1.00 43.39           C  
ATOM     39  N   ASP A   7      54.965  27.686  27.259  1.00 36.81           N  
ATOM     40  CA  ASP A   7      55.415  28.675  26.283  1.00 35.84           C  
ATOM     41  C   ASP A   7      54.631  28.574  24.957  1.00 33.33           C  
ATOM     42  O   ASP A   7      54.291  27.472  24.527  1.00 32.67           O  
ATOM     43  CB  ASP A   7      56.903  28.455  25.999  1.00 36.79           C  
ATOM     44  CG  ASP A   7      57.775  28.620  27.241  1.00 41.25           C  
ATOM     45  OD1 ASP A   7      57.463  29.487  28.100  1.00 44.81           O  
ATOM     46  OD2 ASP A   7      58.785  27.886  27.338  1.00 45.02           O  
ATOM     47  N   PRO A   8      54.330  29.720  24.329  1.00 31.59           N  
ATOM     48  CA  PRO A   8      53.655  29.690  23.020  1.00 30.47           C  
ATOM     49  C   PRO A   8      54.562  29.141  21.928  1.00 28.71           C  
ATOM     50  O   PRO A   8      55.759  29.410  21.918  1.00 28.85           O  
ATOM     51  CB  PRO A   8      53.299  31.152  22.754  1.00 30.08           C  
ATOM     52  CG  PRO A   8      54.192  31.947  23.641  1.00 31.97           C  
ATOM     53  CD  PRO A   8      54.551  31.094  24.817  1.00 32.06           C  
ATOM     54  N   LYS A   9      53.993  28.349  21.035  1.00 26.97           N  
ATOM     55  CA  LYS A   9      54.743  27.764  19.921  1.00 25.47           C  
ATOM     56  C   LYS A   9      54.028  28.121  18.622  1.00 24.64           C  
ATOM     57  O   LYS A   9      52.810  28.305  18.618  1.00 23.12           O  
ATOM     58  CB  LYS A   9      54.820  26.249  20.062  1.00 25.77           C  
ATOM     59  CG  LYS A   9      55.394  25.762  21.399  1.00 28.72           C  
ATOM     60  CD  LYS A   9      56.857  26.100  21.517  1.00 33.41           C  
ATOM     61  CE  LYS A   9      57.407  25.998  22.962  1.00 38.54           C  
ATOM     62  NZ  LYS A   9      58.738  26.731  22.986  1.00 40.47           N  
ATOM     63  N   THR A  10      54.791  28.245  17.538  1.00 23.10           N  
ATOM     64  CA  THR A  10      54.209  28.592  16.250  1.00 22.61           C  
ATOM     65  C   THR A  10      54.908  27.809  15.147  1.00 22.12           C  
ATOM     66  O   THR A  10      56.128  27.673  15.164  1.00 23.06           O  
ATOM     67  CB  THR A  10      54.299  30.130  15.974  1.00 22.69           C  
ATOM     68  OG1 THR A  10      53.834  30.869  17.117  1.00 22.43           O  
ATOM     69  CG2 THR A  10      53.443  30.529  14.763  1.00 21.26           C  
ATOM     70  N   ARG A  11      54.144  27.297  14.188  1.00 20.91           N  
ATOM     71  CA  ARG A  11      54.744  26.858  12.930  1.00 19.89           C  
ATOM     72  C   ARG A  11      53.923  27.355  11.741  1.00 19.74           C  
ATOM     73  O   ARG A  11      52.714  27.558  11.857  1.00 19.63           O  
ATOM     74  CB  ARG A  11      54.882  25.341  12.897  1.00 19.38           C  
ATOM     75  CG  ARG A  11      53.591  24.589  13.034  1.00 18.73           C  
ATOM     76  CD  ARG A  11      53.874  23.081  12.973  1.00 18.98           C  
ATOM     77  NE  ARG A  11      52.632  22.326  12.966  1.00 20.75           N  
ATOM     78  CZ  ARG A  11      52.005  21.879  11.879  1.00 19.83           C  
ATOM     79  NH1 ARG A  11      52.460  22.123  10.648  1.00 20.93           N  
ATOM     80  NH2 ARG A  11      50.897  21.194  12.027  1.00 18.00           N  
ATOM     81  N   VAL A  12      54.583  27.541  10.607  1.00 19.82           N  
ATOM     82  CA  VAL A  12      53.948  28.120   9.433  1.00 19.99           C  
ATOM     83  C   VAL A  12      53.335  26.998   8.598  1.00 20.83           C  
ATOM     84  O   VAL A  12      54.026  26.033   8.210  1.00 20.36           O  
ATOM     85  CB  VAL A  12      54.964  28.972   8.626  1.00 20.80           C  
ATOM     86  CG1 VAL A  12      54.391  29.409   7.260  1.00 19.81           C  
ATOM     87  CG2 VAL A  12      55.393  30.195   9.457  1.00 20.17           C  
ATOM     88  N   LEU A  13      52.039  27.116   8.338  1.00 19.81           N  
ATOM     89  CA  LEU A  13      51.357  26.150   7.485  1.00 20.68           C  
ATOM     90  C   LEU A  13      51.386  26.555   6.020  1.00 20.74           C  
ATOM     91  O   LEU A  13      51.388  25.700   5.165  1.00 21.32           O  
ATOM     92  CB  LEU A  13      49.883  26.012   7.901  1.00 21.11           C  
ATOM     93  CG  LEU A  13      49.613  25.665   9.378  1.00 21.97           C  
ATOM     94  CD1 LEU A  13      48.122  25.791   9.630  1.00 21.24           C  
ATOM     95  CD2 LEU A  13      50.111  24.260   9.650  1.00 24.48           C  
ATOM     96  N   GLU A  14      51.345  27.854   5.739  1.00 21.03           N  
ATOM     97  CA  GLU A  14      51.196  28.343   4.369  1.00 22.46           C  
ATOM     98  C   GLU A  14      51.635  29.813   4.304  1.00 21.97           C  
ATOM     99  O   GLU A  14      51.420  30.572   5.250  1.00 20.94           O  
ATOM    100  CB  GLU A  14      49.734  28.209   3.925  1.00 22.79           C  
ATOM    101  CG  GLU A  14      49.486  28.371   2.451  1.00 23.62           C  
ATOM    102  CD  GLU A  14      48.106  27.875   2.032  1.00 25.53           C  
ATOM    103  OE1 GLU A  14      47.292  27.509   2.900  1.00 28.90           O  
ATOM    104  OE2 GLU A  14      47.821  27.868   0.819  1.00 28.99           O  
ATOM    105  N   HIS A  15      52.254  30.188   3.181  1.00 21.65           N  
ATOM    106  CA  HIS A  15      52.812  31.508   2.993  1.00 22.47           C  
ATOM    107  C   HIS A  15      52.827  31.652   1.473  1.00 23.18           C  
ATOM    108  O   HIS A  15      53.685  31.079   0.795  1.00 22.60           O  
ATOM    109  CB  HIS A  15      54.231  31.563   3.589  1.00 21.86           C  
ATOM    110  CG  HIS A  15      54.971  32.843   3.327  1.00 23.50           C  
ATOM    111  ND1 HIS A  15      55.653  33.085   2.151  1.00 25.60           N  
ATOM    112  CD2 HIS A  15      55.176  33.935   4.108  1.00 23.34           C  
ATOM    113  CE1 HIS A  15      56.214  34.284   2.204  1.00 24.79           C  
ATOM    114  NE2 HIS A  15      55.948  34.817   3.383  1.00 21.76           N  
ATOM    115  N   ARG A  16      51.852  32.380   0.942  1.00 23.35           N  
ATOM    116  CA  ARG A  16      51.730  32.506  -0.505  1.00 25.27           C  
ATOM    117  C   ARG A  16      51.100  33.823  -0.920  1.00 25.12           C  
ATOM    118  O   ARG A  16      50.134  34.290  -0.309  1.00 24.31           O  
ATOM    119  CB  ARG A  16      50.922  31.350  -1.111  1.00 26.08           C  
ATOM    120  CG  ARG A  16      49.527  31.254  -0.566  1.00 27.81           C  
ATOM    121  CD  ARG A  16      48.820  30.003  -1.045  1.00 32.58           C  
ATOM    122  NE  ARG A  16      48.034  30.323  -2.208  1.00 37.97           N  
ATOM    123  CZ  ARG A  16      46.706  30.336  -2.269  1.00 36.49           C  
ATOM    124  NH1 ARG A  16      45.940  29.987  -1.241  1.00 34.70           N  
ATOM    125  NH2 ARG A  16      46.152  30.685  -3.402  1.00 36.76           N  
ATOM    126  N   LEU A  17      51.667  34.393  -1.975  1.00 25.27           N  
ATOM    127  CA  LEU A  17      51.100  35.550  -2.650  1.00 26.13           C  
ATOM    128  C   LEU A  17      49.972  35.049  -3.532  1.00 26.33           C  
ATOM    129  O   LEU A  17      50.078  33.976  -4.135  1.00 25.88           O  
ATOM    130  CB  LEU A  17      52.171  36.228  -3.509  1.00 26.70           C  
ATOM    131  CG  LEU A  17      53.394  36.766  -2.750  1.00 27.90           C  
ATOM    132  CD1 LEU A  17      54.595  36.998  -3.702  1.00 30.01           C  
ATOM    133  CD2 LEU A  17      53.032  38.046  -2.002  1.00 25.56           C  
ATOM    134  N   LEU A  18      48.883  35.811  -3.577  1.00 26.17           N  
ATOM    135  CA  LEU A  18      47.714  35.455  -4.367  1.00 26.64           C  
ATOM    136  C   LEU A  18      47.028  36.737  -4.767  1.00 26.56           C  
ATOM    137  O   LEU A  18      47.300  37.801  -4.186  1.00 26.35           O  
ATOM    138  CB  LEU A  18      46.741  34.553  -3.589  1.00 26.42           C  
ATOM    139  CG  LEU A  18      45.942  35.047  -2.373  1.00 27.34           C  
ATOM    140  CD1 LEU A  18      44.813  34.074  -2.041  1.00 27.73           C  
ATOM    141  CD2 LEU A  18      46.823  35.207  -1.161  1.00 29.43           C  
ATOM    142  N   ALA A  19      46.150  36.634  -5.763  1.00 26.66           N  
ATOM    143  CA  ALA A  19      45.354  37.768  -6.229  1.00 26.27           C  
ATOM    144  C   ALA A  19      44.253  38.045  -5.215  1.00 26.40           C  
ATOM    145  O   ALA A  19      43.575  37.112  -4.762  1.00 26.63           O  
ATOM    146  CB  ALA A  19      44.751  37.461  -7.598  1.00 26.19           C  
ATOM    147  N   ALA A  20      44.084  39.309  -4.824  1.00 25.99           N  
ATOM    148  CA  ALA A  20      43.018  39.648  -3.888  1.00 25.65           C  
ATOM    149  C   ALA A  20      41.645  39.458  -4.544  1.00 26.38           C  
ATOM    150  O   ALA A  20      41.391  39.964  -5.650  1.00 25.96           O  
ATOM    151  CB  ALA A  20      43.177  41.066  -3.366  1.00 26.04           C  
ATOM    152  N   SER A  21      40.770  38.713  -3.872  1.00 26.04           N  
ATOM    153  CA  SER A  21      39.372  38.639  -4.277  1.00 27.03           C  
ATOM    154  C   SER A  21      38.717  40.024  -4.093  1.00 27.37           C  
ATOM    155  O   SER A  21      39.284  40.908  -3.449  1.00 26.71           O  
ATOM    156  CB  SER A  21      38.640  37.594  -3.443  1.00 26.55           C  
ATOM    157  OG  SER A  21      38.528  38.036  -2.101  1.00 27.19           O  
ATOM    158  N   SER A  22      37.531  40.221  -4.663  1.00 28.32           N  
ATOM    159  CA  SER A  22      36.829  41.486  -4.475  1.00 28.79           C  
ATOM    160  C   SER A  22      36.646  41.823  -2.996  1.00 28.52           C  
ATOM    161  O   SER A  22      36.899  42.945  -2.588  1.00 28.88           O  
ATOM    162  CB  SER A  22      35.480  41.476  -5.197  1.00 29.01           C  
ATOM    163  OG  SER A  22      35.689  41.483  -6.589  1.00 30.38           O  
ATOM    164  N   ALA A  23      36.212  40.836  -2.212  1.00 28.55           N  
ATOM    165  CA  ALA A  23      35.993  40.977  -0.780  1.00 28.49           C  
ATOM    166  C   ALA A  23      37.262  41.332  -0.009  1.00 28.70           C  
ATOM    167  O   ALA A  23      37.240  42.236   0.830  1.00 28.69           O  
ATOM    168  CB  ALA A  23      35.375  39.699  -0.214  1.00 29.45           C  
ATOM    169  N   ILE A  24      38.362  40.631  -0.295  1.00 27.78           N  
ATOM    170  CA  ILE A  24      39.620  40.913   0.368  1.00 27.48           C  
ATOM    171  C   ILE A  24      40.138  42.304  -0.009  1.00 27.35           C  
ATOM    172  O   ILE A  24      40.533  43.072   0.870  1.00 26.63           O  
ATOM    173  CB  ILE A  24      40.694  39.822   0.067  1.00 28.01           C  
ATOM    174  CG1 ILE A  24      40.293  38.461   0.673  1.00 27.84           C  
ATOM    175  CG2 ILE A  24      42.080  40.265   0.548  1.00 26.78           C  
ATOM    176  CD1 ILE A  24      40.065  38.473   2.158  1.00 29.41           C  
ATOM    177  N   ALA A  25      40.127  42.616  -1.313  1.00 27.32           N  
ATOM    178  CA  ALA A  25      40.532  43.935  -1.816  1.00 27.61           C  
ATOM    179  C   ALA A  25      39.733  45.058  -1.149  1.00 27.88           C  
ATOM    180  O   ALA A  25      40.306  46.049  -0.702  1.00 27.10           O  
ATOM    181  CB  ALA A  25      40.368  44.013  -3.326  1.00 27.16           C  
ATOM    182  N   GLU A  26      38.413  44.889  -1.090  1.00 28.68           N  
ATOM    183  CA  GLU A  26      37.538  45.850  -0.402  1.00 30.64           C  
ATOM    184  C   GLU A  26      37.977  46.050   1.055  1.00 30.02           C  
ATOM    185  O   GLU A  26      38.166  47.186   1.502  1.00 29.94           O  
ATOM    186  CB  GLU A  26      36.072  45.412  -0.475  1.00 30.22           C  
ATOM    187  CG  GLU A  26      35.105  46.363   0.244  1.00 33.65           C  
ATOM    188  CD  GLU A  26      33.642  46.085  -0.079  1.00 33.57           C  
ATOM    189  OE1 GLU A  26      33.203  46.405  -1.206  1.00 37.16           O  
ATOM    190  OE2 GLU A  26      32.931  45.566   0.810  1.00 38.77           O  
ATOM    191  N   LYS A  27      38.171  44.945   1.771  1.00 29.57           N  
ATOM    192  CA  LYS A  27      38.584  45.006   3.171  1.00 29.77           C  
ATOM    193  C   LYS A  27      39.952  45.660   3.388  1.00 29.41           C  
ATOM    194  O   LYS A  27      40.165  46.308   4.407  1.00 29.17           O  
ATOM    195  CB  LYS A  27      38.579  43.611   3.787  1.00 30.42           C  
ATOM    196  CG  LYS A  27      37.184  43.038   4.024  1.00 32.99           C  
ATOM    197  CD  LYS A  27      37.275  41.571   4.453  1.00 35.80           C  
ATOM    198  CE  LYS A  27      35.892  40.961   4.669  1.00 39.12           C  
ATOM    199  NZ  LYS A  27      36.047  39.601   5.264  1.00 41.56           N  
ATOM    200  N   LEU A  28      40.877  45.487   2.439  1.00 28.45           N  
ATOM    201  CA  LEU A  28      42.219  46.064   2.562  1.00 27.89           C  
ATOM    202  C   LEU A  28      42.308  47.497   2.044  1.00 28.04           C  
ATOM    203  O   LEU A  28      43.278  48.212   2.329  1.00 28.36           O  
ATOM    204  CB  LEU A  28      43.251  45.172   1.842  1.00 27.79           C  
ATOM    205  CG  LEU A  28      43.567  43.819   2.494  1.00 26.59           C  
ATOM    206  CD1 LEU A  28      44.357  42.913   1.541  1.00 27.68           C  
ATOM    207  CD2 LEU A  28      44.313  43.982   3.836  1.00 24.53           C  
ATOM    208  N   GLY A  29      41.299  47.923   1.287  1.00 27.91           N  
ATOM    209  CA  GLY A  29      41.338  49.216   0.605  1.00 27.47           C  
ATOM    210  C   GLY A  29      42.206  49.224  -0.645  1.00 27.25           C  
ATOM    211  O   GLY A  29      42.816  50.246  -0.977  1.00 26.77           O  
ATOM    212  N   VAL A  30      42.277  48.088  -1.343  1.00 26.86           N  
ATOM    213  CA  VAL A  30      43.071  47.988  -2.580  1.00 26.51           C  
ATOM    214  C   VAL A  30      42.189  47.585  -3.780  1.00 26.30           C  
ATOM    215  O   VAL A  30      40.968  47.493  -3.653  1.00 25.37           O  
ATOM    216  CB  VAL A  30      44.323  47.058  -2.414  1.00 26.87           C  
ATOM    217  CG1 VAL A  30      45.214  47.550  -1.281  1.00 27.94           C  
ATOM    218  CG2 VAL A  30      43.926  45.583  -2.204  1.00 25.60           C  
ATOM    219  N   SER A  31      42.807  47.363  -4.943  1.00 26.08           N  
ATOM    220  CA  SER A  31      42.074  46.937  -6.142  1.00 25.91           C  
ATOM    221  C   SER A  31      41.897  45.419  -6.194  1.00 25.78           C  
ATOM    222  O   SER A  31      42.790  44.662  -5.782  1.00 25.57           O  
ATOM    223  CB  SER A  31      42.795  47.415  -7.403  1.00 26.03           C  
ATOM    224  OG  SER A  31      43.093  48.801  -7.312  1.00 26.72           O  
ATOM    225  N   ALA A  32      40.745  44.974  -6.690  1.00 25.75           N  
ATOM    226  CA  ALA A  32      40.520  43.552  -6.938  1.00 25.82           C  
ATOM    227  C   ALA A  32      41.666  43.013  -7.784  1.00 25.98           C  
ATOM    228  O   ALA A  32      42.056  43.619  -8.796  1.00 25.91           O  
ATOM    229  CB  ALA A  32      39.192  43.338  -7.635  1.00 26.05           C  
ATOM    230  N   GLY A  33      42.233  41.897  -7.340  1.00 25.76           N  
ATOM    231  CA  GLY A  33      43.344  41.273  -8.034  1.00 25.30           C  
ATOM    232  C   GLY A  33      44.730  41.718  -7.615  1.00 25.16           C  
ATOM    233  O   GLY A  33      45.711  41.170  -8.105  1.00 24.71           O  
ATOM    234  N   ASP A  34      44.839  42.711  -6.733  1.00 25.46           N  
ATOM    235  CA  ASP A  34      46.164  43.139  -6.257  1.00 26.50           C  
ATOM    236  C   ASP A  34      46.864  41.975  -5.518  1.00 26.47           C  
ATOM    237  O   ASP A  34      46.197  41.129  -4.899  1.00 26.08           O  
ATOM    238  CB  ASP A  34      46.079  44.375  -5.343  1.00 27.03           C  
ATOM    239  CG  ASP A  34      46.060  45.701  -6.113  1.00 29.71           C  
ATOM    240  OD1 ASP A  34      46.194  45.703  -7.366  1.00 31.94           O  
ATOM    241  OD2 ASP A  34      45.909  46.752  -5.454  1.00 31.54           O  
ATOM    242  N   GLU A  35      48.192  41.943  -5.600  1.00 26.06           N  
ATOM    243  CA  GLU A  35      48.987  40.884  -4.999  1.00 27.01           C  
ATOM    244  C   GLU A  35      49.101  40.990  -3.466  1.00 25.75           C  
ATOM    245  O   GLU A  35      49.879  41.789  -2.945  1.00 26.18           O  
ATOM    246  CB  GLU A  35      50.382  40.836  -5.630  1.00 27.14           C  
ATOM    247  CG  GLU A  35      51.212  39.657  -5.103  1.00 31.49           C  
ATOM    248  CD  GLU A  35      52.370  39.270  -6.040  1.00 37.16           C  
ATOM    249  OE1 GLU A  35      53.307  40.089  -6.201  1.00 38.79           O  
ATOM    250  OE2 GLU A  35      52.339  38.143  -6.596  1.00 38.56           O  
ATOM    251  N   VAL A  36      48.326  40.171  -2.767  1.00 25.40           N  
ATOM    252  CA  VAL A  36      48.317  40.142  -1.288  1.00 24.15           C  
ATOM    253  C   VAL A  36      49.039  38.898  -0.759  1.00 24.35           C  
ATOM    254  O   VAL A  36      49.207  37.919  -1.492  1.00 24.34           O  
ATOM    255  CB  VAL A  36      46.862  40.219  -0.713  1.00 24.60           C  
ATOM    256  CG1 VAL A  36      46.177  41.553  -1.125  1.00 22.18           C  
ATOM    257  CG2 VAL A  36      46.026  39.000  -1.131  1.00 23.12           C  
ATOM    258  N   LEU A  37      49.478  38.935   0.503  1.00 23.25           N  
ATOM    259  CA  LEU A  37      50.135  37.767   1.111  1.00 22.96           C  
ATOM    260  C   LEU A  37      49.200  37.075   2.100  1.00 22.38           C  
ATOM    261  O   LEU A  37      48.732  37.705   3.055  1.00 22.30           O  
ATOM    262  CB  LEU A  37      51.438  38.188   1.798  1.00 22.12           C  
ATOM    263  CG  LEU A  37      52.206  37.110   2.559  1.00 23.70           C  
ATOM    264  CD1 LEU A  37      52.649  35.961   1.627  1.00 22.14           C  
ATOM    265  CD2 LEU A  37      53.393  37.720   3.284  1.00 22.53           C  
ATOM    266  N   LEU A  38      48.920  35.798   1.850  1.00 22.60           N  
ATOM    267  CA  LEU A  38      48.232  34.930   2.795  1.00 22.66           C  
ATOM    268  C   LEU A  38      49.250  34.215   3.673  1.00 22.77           C  
ATOM    269  O   LEU A  38      50.184  33.587   3.172  1.00 22.71           O  
ATOM    270  CB  LEU A  38      47.369  33.884   2.066  1.00 22.55           C  
ATOM    271  CG  LEU A  38      46.761  32.706   2.863  1.00 23.02           C  
ATOM    272  CD1 LEU A  38      45.733  33.174   3.895  1.00 23.14           C  
ATOM    273  CD2 LEU A  38      46.126  31.646   1.919  1.00 23.86           C  
ATOM    274  N   ILE A  39      49.078  34.340   4.984  1.00 22.23           N  
ATOM    275  CA  ILE A  39      49.883  33.583   5.948  1.00 22.69           C  
ATOM    276  C   ILE A  39      48.950  32.722   6.804  1.00 22.64           C  
ATOM    277  O   ILE A  39      47.954  33.220   7.326  1.00 22.33           O  
ATOM    278  CB  ILE A  39      50.696  34.521   6.856  1.00 23.10           C  
ATOM    279  CG1 ILE A  39      51.665  35.354   6.003  1.00 22.87           C  
ATOM    280  CG2 ILE A  39      51.459  33.704   7.946  1.00 22.36           C  
ATOM    281  CD1 ILE A  39      52.133  36.648   6.682  1.00 26.40           C  
ATOM    282  N   ARG A  40      49.250  31.431   6.905  1.00 22.31           N  
ATOM    283  CA  ARG A  40      48.547  30.544   7.845  1.00 22.59           C  
ATOM    284  C   ARG A  40      49.558  29.900   8.822  1.00 22.53           C  
ATOM    285  O   ARG A  40      50.630  29.433   8.413  1.00 21.40           O  
ATOM    286  CB  ARG A  40      47.703  29.495   7.115  1.00 21.85           C  
ATOM    287  CG  ARG A  40      46.642  30.126   6.191  1.00 24.07           C  
ATOM    288  CD  ARG A  40      45.808  29.081   5.425  1.00 25.08           C  
ATOM    289  NE  ARG A  40      45.244  28.090   6.339  1.00 29.04           N  
ATOM    290  CZ  ARG A  40      45.594  26.806   6.357  1.00 31.36           C  
ATOM    291  NH1 ARG A  40      46.504  26.327   5.496  1.00 31.91           N  
ATOM    292  NH2 ARG A  40      45.027  25.998   7.235  1.00 31.20           N  
ATOM    293  N   ARG A  41      49.218  29.932  10.111  1.00 21.21           N  
ATOM    294  CA  ARG A  41      50.107  29.418  11.164  1.00 22.12           C  
ATOM    295  C   ARG A  41      49.307  28.580  12.154  1.00 21.47           C  
ATOM    296  O   ARG A  41      48.113  28.833  12.393  1.00 20.85           O  
ATOM    297  CB  ARG A  41      50.812  30.557  11.929  1.00 21.09           C  
ATOM    298  CG  ARG A  41      51.816  31.399  11.081  1.00 23.57           C  
ATOM    299  CD  ARG A  41      52.241  32.676  11.815  1.00 23.35           C  
ATOM    300  NE  ARG A  41      51.137  33.637  11.936  1.00 27.33           N  
ATOM    301  CZ  ARG A  41      51.118  34.703  12.755  1.00 28.57           C  
ATOM    302  NH1 ARG A  41      52.130  34.950  13.562  1.00 28.01           N  
ATOM    303  NH2 ARG A  41      50.071  35.531  12.768  1.00 27.98           N  
ATOM    304  N   LEU A  42      49.975  27.573  12.716  1.00 21.61           N  
ATOM    305  CA  LEU A  42      49.451  26.851  13.858  1.00 21.34           C  
ATOM    306  C   LEU A  42      50.148  27.331  15.142  1.00 20.92           C  
ATOM    307  O   LEU A  42      51.381  27.247  15.284  1.00 19.76           O  
ATOM    308  CB  LEU A  42      49.617  25.331  13.676  1.00 21.40           C  
ATOM    309  CG  LEU A  42      48.932  24.570  14.823  1.00 22.86           C  
ATOM    310  CD1 LEU A  42      47.411  24.509  14.608  1.00 22.98           C  
ATOM    311  CD2 LEU A  42      49.521  23.181  14.994  1.00 23.62           C  
ATOM    312  N   ARG A  43      49.346  27.845  16.065  1.00 20.30           N  
ATOM    313  CA  ARG A  43      49.809  28.303  17.354  1.00 20.45           C  
ATOM    314  C   ARG A  43      49.459  27.234  18.387  1.00 20.73           C  
ATOM    315  O   ARG A  43      48.330  26.725  18.400  1.00 20.31           O  
ATOM    316  CB  ARG A  43      49.098  29.619  17.727  1.00 20.84           C  
ATOM    317  CG  ARG A  43      49.196  30.040  19.203  1.00 21.38           C  
ATOM    318  CD  ARG A  43      50.629  30.446  19.633  1.00 23.10           C  
ATOM    319  NE  ARG A  43      51.364  31.163  18.582  1.00 23.75           N  
ATOM    320  CZ  ARG A  43      51.260  32.472  18.344  1.00 27.53           C  
ATOM    321  NH1 ARG A  43      50.433  33.224  19.068  1.00 27.11           N  
ATOM    322  NH2 ARG A  43      51.967  33.034  17.365  1.00 26.83           N  
ATOM    323  N   SER A  44      50.422  26.898  19.235  1.00 20.65           N  
ATOM    324  CA  SER A  44      50.225  25.928  20.301  1.00 21.40           C  
ATOM    325  C   SER A  44      50.649  26.552  21.638  1.00 22.13           C  
ATOM    326  O   SER A  44      51.341  27.573  21.669  1.00 21.03           O  
ATOM    327  CB  SER A  44      51.028  24.639  20.050  1.00 20.76           C  
ATOM    328  OG  SER A  44      50.843  24.135  18.734  1.00 22.31           O  
ATOM    329  N   THR A  45      50.207  25.926  22.732  1.00 23.04           N  
ATOM    330  CA  THR A  45      50.614  26.302  24.080  1.00 24.36           C  
ATOM    331  C   THR A  45      51.380  25.079  24.627  1.00 24.54           C  
ATOM    332  O   THR A  45      50.788  24.024  24.814  1.00 22.74           O  
ATOM    333  CB  THR A  45      49.361  26.587  24.949  1.00 24.89           C  
ATOM    334  OG1 THR A  45      48.733  27.809  24.512  1.00 26.20           O  
ATOM    335  CG2 THR A  45      49.745  26.719  26.403  1.00 25.81           C  
ATOM    336  N   GLY A  46      52.687  25.195  24.848  1.00 25.41           N  
ATOM    337  CA  GLY A  46      53.468  23.971  25.138  1.00 26.90           C  
ATOM    338  C   GLY A  46      53.317  22.990  23.964  1.00 27.84           C  
ATOM    339  O   GLY A  46      53.567  23.369  22.816  1.00 28.77           O  
ATOM    340  N   ASP A  47      52.858  21.769  24.239  1.00 27.65           N  
ATOM    341  CA  ASP A  47      52.636  20.740  23.204  1.00 28.26           C  
ATOM    342  C   ASP A  47      51.205  20.708  22.616  1.00 26.74           C  
ATOM    343  O   ASP A  47      50.913  19.892  21.745  1.00 26.06           O  
ATOM    344  CB  ASP A  47      52.936  19.346  23.793  1.00 29.00           C  
ATOM    345  CG  ASP A  47      54.409  19.174  24.214  1.00 31.49           C  
ATOM    346  OD1 ASP A  47      55.312  19.696  23.530  1.00 33.55           O  
ATOM    347  OD2 ASP A  47      54.660  18.498  25.239  1.00 35.08           O  
ATOM    348  N   ILE A  48      50.319  21.565  23.116  1.00 25.02           N  
ATOM    349  CA  ILE A  48      48.896  21.483  22.783  1.00 23.89           C  
ATOM    350  C   ILE A  48      48.539  22.544  21.741  1.00 23.12           C  
ATOM    351  O   ILE A  48      48.713  23.749  22.001  1.00 22.87           O  
ATOM    352  CB  ILE A  48      47.983  21.714  24.038  1.00 24.65           C  
ATOM    353  CG1 ILE A  48      48.384  20.751  25.175  1.00 26.17           C  
ATOM    354  CG2 ILE A  48      46.486  21.571  23.652  1.00 21.59           C  
ATOM    355  CD1 ILE A  48      48.175  21.330  26.594  1.00 28.94           C  
ATOM    356  N   PRO A  49      48.018  22.102  20.585  1.00 22.47           N  
ATOM    357  CA  PRO A  49      47.564  23.031  19.527  1.00 23.06           C  
ATOM    358  C   PRO A  49      46.446  23.920  20.062  1.00 23.68           C  
ATOM    359  O   PRO A  49      45.593  23.434  20.804  1.00 25.07           O  
ATOM    360  CB  PRO A  49      47.048  22.086  18.425  1.00 22.67           C  
ATOM    361  CG  PRO A  49      47.783  20.766  18.652  1.00 23.25           C  
ATOM    362  CD  PRO A  49      47.850  20.685  20.186  1.00 22.44           C  
ATOM    363  N   VAL A  50      46.462  25.211  19.728  1.00 23.46           N  
ATOM    364  CA  VAL A  50      45.514  26.174  20.304  1.00 23.31           C  
ATOM    365  C   VAL A  50      44.713  26.949  19.251  1.00 22.58           C  
ATOM    366  O   VAL A  50      43.524  27.180  19.426  1.00 22.48           O  
ATOM    367  CB  VAL A  50      46.246  27.164  21.263  1.00 23.33           C  
ATOM    368  CG1 VAL A  50      45.356  28.343  21.641  1.00 25.32           C  
ATOM    369  CG2 VAL A  50      46.630  26.414  22.535  1.00 25.19           C  
ATOM    370  N   ALA A  51      45.375  27.356  18.174  1.00 20.59           N  
ATOM    371  CA  ALA A  51      44.755  28.251  17.215  1.00 21.06           C  
ATOM    372  C   ALA A  51      45.324  28.056  15.832  1.00 20.47           C  
ATOM    373  O   ALA A  51      46.531  27.795  15.673  1.00 19.75           O  
ATOM    374  CB  ALA A  51      44.944  29.711  17.629  1.00 20.20           C  
ATOM    375  N   ILE A  52      44.432  28.164  14.854  1.00 19.88           N  
ATOM    376  CA  ILE A  52      44.827  28.332  13.467  1.00 20.07           C  
ATOM    377  C   ILE A  52      44.708  29.818  13.137  1.00 19.98           C  
ATOM    378  O   ILE A  52      43.619  30.399  13.157  1.00 20.37           O  
ATOM    379  CB  ILE A  52      43.981  27.474  12.497  1.00 20.24           C  
ATOM    380  CG1 ILE A  52      44.059  25.990  12.893  1.00 20.06           C  
ATOM    381  CG2 ILE A  52      44.474  27.685  11.037  1.00 20.14           C  
ATOM    382  CD1 ILE A  52      42.918  25.122  12.292  1.00 19.23           C  
ATOM    383  N   LEU A  53      45.844  30.443  12.875  1.00 19.86           N  
ATOM    384  CA  LEU A  53      45.873  31.872  12.594  1.00 19.82           C  
ATOM    385  C   LEU A  53      45.969  32.089  11.095  1.00 20.91           C  
ATOM    386  O   LEU A  53      46.800  31.470  10.436  1.00 21.73           O  
ATOM    387  CB  LEU A  53      47.083  32.531  13.295  1.00 19.65           C  
ATOM    388  CG  LEU A  53      47.248  32.271  14.803  1.00 19.22           C  
ATOM    389  CD1 LEU A  53      48.552  32.914  15.251  1.00 18.81           C  
ATOM    390  CD2 LEU A  53      46.038  32.798  15.632  1.00 19.43           C  
ATOM    391  N   GLU A  54      45.115  32.946  10.556  1.00 20.71           N  
ATOM    392  CA  GLU A  54      45.151  33.272   9.137  1.00 22.90           C  
ATOM    393  C   GLU A  54      45.178  34.778   8.979  1.00 21.99           C  
ATOM    394  O   GLU A  54      44.336  35.481   9.554  1.00 21.71           O  
ATOM    395  CB  GLU A  54      43.939  32.665   8.405  1.00 22.76           C  
ATOM    396  CG  GLU A  54      43.861  32.993   6.912  1.00 25.87           C  
ATOM    397  CD  GLU A  54      42.606  32.378   6.265  1.00 27.93           C  
ATOM    398  OE1 GLU A  54      42.568  31.128   6.117  1.00 32.93           O  
ATOM    399  OE2 GLU A  54      41.647  33.139   5.965  1.00 32.22           O  
ATOM    400  N   ASN A  55      46.158  35.270   8.222  1.00 21.46           N  
ATOM    401  CA  ASN A  55      46.292  36.706   7.965  1.00 21.70           C  
ATOM    402  C   ASN A  55      46.464  37.006   6.481  1.00 22.15           C  
ATOM    403  O   ASN A  55      47.084  36.232   5.736  1.00 21.77           O  
ATOM    404  CB  ASN A  55      47.482  37.319   8.733  1.00 20.74           C  
ATOM    405  CG  ASN A  55      47.337  37.187  10.236  1.00 22.60           C  
ATOM    406  OD1 ASN A  55      46.804  38.083  10.910  1.00 25.75           O  
ATOM    407  ND2 ASN A  55      47.794  36.071  10.771  1.00 18.75           N  
ATOM    408  N   TYR A  56      45.900  38.134   6.067  1.00 22.08           N  
ATOM    409  CA  TYR A  56      46.152  38.689   4.758  1.00 22.83           C  
ATOM    410  C   TYR A  56      46.858  40.028   4.927  1.00 22.84           C  
ATOM    411  O   TYR A  56      46.422  40.885   5.714  1.00 22.14           O  
ATOM    412  CB  TYR A  56      44.840  38.910   4.015  1.00 23.73           C  
ATOM    413  CG  TYR A  56      44.196  37.657   3.479  1.00 25.79           C  
ATOM    414  CD1 TYR A  56      44.470  37.228   2.186  1.00 27.97           C  
ATOM    415  CD2 TYR A  56      43.300  36.905   4.255  1.00 26.96           C  
ATOM    416  CE1 TYR A  56      43.875  36.091   1.660  1.00 28.20           C  
ATOM    417  CE2 TYR A  56      42.693  35.743   3.730  1.00 27.27           C  
ATOM    418  CZ  TYR A  56      42.991  35.362   2.420  1.00 27.68           C  
ATOM    419  OH  TYR A  56      42.434  34.235   1.836  1.00 30.05           O  
ATOM    420  N   LEU A  57      47.936  40.203   4.176  1.00 22.80           N  
ATOM    421  CA  LEU A  57      48.712  41.427   4.199  1.00 23.63           C  
ATOM    422  C   LEU A  57      48.569  42.110   2.852  1.00 24.38           C  
ATOM    423  O   LEU A  57      48.567  41.429   1.809  1.00 23.90           O  
ATOM    424  CB  LEU A  57      50.186  41.146   4.492  1.00 23.84           C  
ATOM    425  CG  LEU A  57      50.544  40.622   5.884  1.00 26.48           C  
ATOM    426  CD1 LEU A  57      52.032  40.641   6.017  1.00 26.93           C  
ATOM    427  CD2 LEU A  57      49.941  41.519   6.961  1.00 28.71           C  
ATOM    428  N   PRO A  58      48.436  43.455   2.861  1.00 24.33           N  
ATOM    429  CA  PRO A  58      48.245  44.186   1.617  1.00 25.00           C  
ATOM    430  C   PRO A  58      49.568  44.277   0.832  1.00 25.16           C  
ATOM    431  O   PRO A  58      50.629  43.967   1.402  1.00 24.56           O  
ATOM    432  CB  PRO A  58      47.767  45.570   2.092  1.00 24.87           C  
ATOM    433  CG  PRO A  58      48.403  45.747   3.415  1.00 24.69           C  
ATOM    434  CD  PRO A  58      48.474  44.351   4.034  1.00 24.55           C  
ATOM    435  N   PRO A  59      49.510  44.703  -0.459  1.00 25.52           N  
ATOM    436  CA  PRO A  59      50.728  44.720  -1.293  1.00 25.30           C  
ATOM    437  C   PRO A  59      51.919  45.387  -0.589  1.00 25.75           C  
ATOM    438  O   PRO A  59      53.038  44.868  -0.661  1.00 25.41           O  
ATOM    439  CB  PRO A  59      50.300  45.523  -2.527  1.00 25.95           C  
ATOM    440  CG  PRO A  59      48.815  45.254  -2.649  1.00 25.14           C  
ATOM    441  CD  PRO A  59      48.319  45.155  -1.212  1.00 25.20           C  
ATOM    442  N   ALA A  60      51.690  46.498   0.111  1.00 25.68           N  
ATOM    443  CA  ALA A  60      52.804  47.215   0.767  1.00 26.36           C  
ATOM    444  C   ALA A  60      53.636  46.345   1.717  1.00 26.61           C  
ATOM    445  O   ALA A  60      54.830  46.612   1.929  1.00 26.25           O  
ATOM    446  CB  ALA A  60      52.296  48.447   1.503  1.00 26.29           C  
ATOM    447  N   PHE A  61      52.995  45.329   2.303  1.00 26.23           N  
ATOM    448  CA  PHE A  61      53.644  44.461   3.282  1.00 27.14           C  
ATOM    449  C   PHE A  61      53.697  42.998   2.826  1.00 26.76           C  
ATOM    450  O   PHE A  61      53.868  42.100   3.645  1.00 27.46           O  
ATOM    451  CB  PHE A  61      52.944  44.585   4.663  1.00 27.23           C  
ATOM    452  CG  PHE A  61      52.716  46.019   5.092  1.00 28.59           C  
ATOM    453  CD1 PHE A  61      53.776  46.920   5.148  1.00 28.99           C  
ATOM    454  CD2 PHE A  61      51.444  46.470   5.409  1.00 29.71           C  
ATOM    455  CE1 PHE A  61      53.567  48.253   5.512  1.00 30.95           C  
ATOM    456  CE2 PHE A  61      51.224  47.808   5.780  1.00 30.85           C  
ATOM    457  CZ  PHE A  61      52.280  48.693   5.834  1.00 29.26           C  
ATOM    458  N   ASN A  62      53.551  42.751   1.530  1.00 26.10           N  
ATOM    459  CA  ASN A  62      53.419  41.368   1.060  1.00 25.86           C  
ATOM    460  C   ASN A  62      54.759  40.627   0.937  1.00 26.06           C  
ATOM    461  O   ASN A  62      54.808  39.518   0.420  1.00 25.69           O  
ATOM    462  CB  ASN A  62      52.600  41.299  -0.238  1.00 25.42           C  
ATOM    463  CG  ASN A  62      53.357  41.869  -1.466  1.00 26.09           C  
ATOM    464  OD1 ASN A  62      54.539  42.178  -1.398  1.00 25.46           O  
ATOM    465  ND2 ASN A  62      52.658  41.983  -2.588  1.00 23.18           N  
ATOM    466  N   ASP A  63      55.836  41.270   1.402  1.00 26.22           N  
ATOM    467  CA  ASP A  63      57.173  40.677   1.406  1.00 27.21           C  
ATOM    468  C   ASP A  63      57.577  40.145   2.783  1.00 26.51           C  
ATOM    469  O   ASP A  63      58.733  39.818   2.979  1.00 26.50           O  
ATOM    470  CB  ASP A  63      58.223  41.694   0.917  1.00 27.74           C  
ATOM    471  CG  ASP A  63      58.325  42.928   1.828  1.00 31.58           C  
ATOM    472  OD1 ASP A  63      57.427  43.194   2.660  1.00 34.15           O  
ATOM    473  OD2 ASP A  63      59.319  43.660   1.699  1.00 37.69           O  
ATOM    474  N   VAL A  64      56.647  40.070   3.741  1.00 25.87           N  
ATOM    475  CA  VAL A  64      56.975  39.436   5.031  1.00 25.68           C  
ATOM    476  C   VAL A  64      57.439  38.011   4.713  1.00 25.68           C  
ATOM    477  O   VAL A  64      56.746  37.282   4.028  1.00 26.10           O  
ATOM    478  CB  VAL A  64      55.810  39.492   6.054  1.00 25.50           C  
ATOM    479  CG1 VAL A  64      56.112  38.609   7.299  1.00 26.55           C  
ATOM    480  CG2 VAL A  64      55.546  40.957   6.471  1.00 25.73           C  
ATOM    481  N   SER A  65      58.627  37.644   5.180  1.00 26.01           N  
ATOM    482  CA  SER A  65      59.294  36.407   4.748  1.00 25.95           C  
ATOM    483  C   SER A  65      59.074  35.240   5.708  1.00 26.40           C  
ATOM    484  O   SER A  65      58.696  35.433   6.886  1.00 25.61           O  
ATOM    485  CB  SER A  65      60.797  36.648   4.559  1.00 25.84           C  
ATOM    486  OG  SER A  65      61.430  36.899   5.801  1.00 26.12           O  
ATOM    487  N   LEU A  66      59.308  34.029   5.199  1.00 26.36           N  
ATOM    488  CA  LEU A  66      59.348  32.833   6.039  1.00 27.53           C  
ATOM    489  C   LEU A  66      60.368  33.042   7.147  1.00 28.28           C  
ATOM    490  O   LEU A  66      60.136  32.690   8.296  1.00 29.37           O  
ATOM    491  CB  LEU A  66      59.762  31.599   5.218  1.00 27.31           C  
ATOM    492  CG  LEU A  66      58.879  31.103   4.072  1.00 27.07           C  
ATOM    493  CD1 LEU A  66      59.628  30.052   3.212  1.00 27.30           C  
ATOM    494  CD2 LEU A  66      57.581  30.542   4.628  1.00 26.35           C  
ATOM    495  N   ASP A  67      61.510  33.616   6.803  1.00 29.41           N  
ATOM    496  CA  ASP A  67      62.548  33.821   7.802  1.00 30.91           C  
ATOM    497  C   ASP A  67      62.071  34.734   8.954  1.00 30.97           C  
ATOM    498  O   ASP A  67      62.265  34.404  10.131  1.00 31.33           O  
ATOM    499  CB  ASP A  67      63.826  34.352   7.158  1.00 31.42           C  
ATOM    500  CG  ASP A  67      65.007  34.280   8.098  1.00 35.59           C  
ATOM    501  OD1 ASP A  67      65.329  33.161   8.548  1.00 40.65           O  
ATOM    502  OD2 ASP A  67      65.596  35.337   8.402  1.00 37.60           O  
ATOM    503  N   GLU A  68      61.418  35.854   8.647  1.00 30.83           N  
ATOM    504  CA  GLU A  68      60.942  36.680   9.756  1.00 31.84           C  
ATOM    505  C   GLU A  68      59.812  36.055  10.581  1.00 31.90           C  
ATOM    506  O   GLU A  68      59.727  36.304  11.769  1.00 31.24           O  
ATOM    507  CB  GLU A  68      60.693  38.150   9.384  1.00 32.46           C  
ATOM    508  CG  GLU A  68      59.995  38.393   8.132  1.00 34.04           C  
ATOM    509  CD  GLU A  68      60.296  39.769   7.534  1.00 34.14           C  
ATOM    510  OE1 GLU A  68      60.715  40.705   8.249  1.00 35.43           O  
ATOM    511  OE2 GLU A  68      60.054  39.920   6.336  1.00 33.99           O  
ATOM    512  N   LEU A  69      59.007  35.180   9.977  1.00 32.31           N  
ATOM    513  CA  LEU A  69      57.972  34.447  10.724  1.00 32.93           C  
ATOM    514  C   LEU A  69      58.564  33.348  11.625  1.00 34.35           C  
ATOM    515  O   LEU A  69      57.918  32.907  12.565  1.00 34.24           O  
ATOM    516  CB  LEU A  69      56.911  33.861   9.783  1.00 32.23           C  
ATOM    517  CG  LEU A  69      56.073  34.849   8.953  1.00 31.44           C  
ATOM    518  CD1 LEU A  69      55.359  34.094   7.842  1.00 30.84           C  
ATOM    519  CD2 LEU A  69      55.067  35.640   9.812  1.00 28.93           C  
ATOM    520  N   GLU A  70      59.781  32.900  11.316  1.00 36.18           N  
ATOM    521  CA  GLU A  70      60.526  31.987  12.186  1.00 38.60           C  
ATOM    522  C   GLU A  70      61.139  32.729  13.376  1.00 37.93           C  
ATOM    523  O   GLU A  70      61.221  32.180  14.466  1.00 37.67           O  
ATOM    524  CB  GLU A  70      61.631  31.259  11.404  1.00 38.82           C  
ATOM    525  CG  GLU A  70      61.129  30.041  10.609  1.00 42.57           C  
ATOM    526  CD  GLU A  70      61.992  29.670   9.376  1.00 43.17           C  
ATOM    527  OE1 GLU A  70      63.173  30.124   9.271  1.00 48.55           O  
ATOM    528  OE2 GLU A  70      61.472  28.906   8.514  1.00 47.24           O  
ATOM    529  N   LYS A  71      61.545  33.977  13.165  1.00 37.90           N  
ATOM    530  CA  LYS A  71      62.252  34.752  14.188  1.00 38.43           C  
ATOM    531  C   LYS A  71      61.349  35.594  15.096  1.00 37.99           C  
ATOM    532  O   LYS A  71      61.773  36.044  16.151  1.00 38.59           O  
ATOM    533  CB  LYS A  71      63.304  35.647  13.533  1.00 38.08           C  
ATOM    534  CG  LYS A  71      64.425  34.862  12.867  1.00 39.89           C  
ATOM    535  CD  LYS A  71      65.374  35.757  12.075  1.00 39.78           C  
ATOM    536  CE  LYS A  71      66.575  34.935  11.588  1.00 41.66           C  
ATOM    537  NZ  LYS A  71      67.340  35.619  10.502  1.00 42.19           N  
ATOM    538  N   GLY A  72      60.112  35.812  14.684  1.00 37.39           N  
ATOM    539  CA  GLY A  72      59.207  36.679  15.411  1.00 36.89           C  
ATOM    540  C   GLY A  72      57.821  36.511  14.845  1.00 36.26           C  
ATOM    541  O   GLY A  72      57.599  35.688  13.968  1.00 36.81           O  
ATOM    542  N   GLY A  73      56.872  37.275  15.355  1.00 35.58           N  
ATOM    543  CA  GLY A  73      55.525  37.193  14.824  1.00 34.32           C  
ATOM    544  C   GLY A  73      55.329  38.173  13.687  1.00 33.52           C  
ATOM    545  O   GLY A  73      56.282  38.794  13.188  1.00 32.73           O  
ATOM    546  N   LEU A  74      54.071  38.318  13.291  1.00 32.43           N  
ATOM    547  CA  LEU A  74      53.721  39.209  12.216  1.00 31.89           C  
ATOM    548  C   LEU A  74      53.963  40.675  12.596  1.00 31.47           C  
ATOM    549  O   LEU A  74      54.465  41.459  11.786  1.00 30.54           O  
ATOM    550  CB  LEU A  74      52.261  38.980  11.824  1.00 31.68           C  
ATOM    551  CG  LEU A  74      51.672  39.842  10.732  1.00 31.96           C  
ATOM    552  CD1 LEU A  74      52.613  39.872   9.495  1.00 30.43           C  
ATOM    553  CD2 LEU A  74      50.306  39.315  10.377  1.00 32.20           C  
ATOM    554  N   TYR A  75      53.602  41.042  13.822  1.00 31.17           N  
ATOM    555  CA  TYR A  75      53.764  42.418  14.254  1.00 31.88           C  
ATOM    556  C   TYR A  75      55.208  42.864  14.500  1.00 31.07           C  
ATOM    557  O   TYR A  75      55.516  44.035  14.320  1.00 30.35           O  
ATOM    558  CB  TYR A  75      52.859  42.721  15.437  1.00 33.71           C  
ATOM    559  CG  TYR A  75      51.457  43.029  14.973  1.00 36.30           C  
ATOM    560  CD1 TYR A  75      50.591  42.007  14.590  1.00 38.49           C  
ATOM    561  CD2 TYR A  75      51.013  44.346  14.872  1.00 38.66           C  
ATOM    562  CE1 TYR A  75      49.305  42.284  14.149  1.00 38.89           C  
ATOM    563  CE2 TYR A  75      49.728  44.638  14.436  1.00 39.13           C  
ATOM    564  CZ  TYR A  75      48.881  43.601  14.081  1.00 38.51           C  
ATOM    565  OH  TYR A  75      47.601  43.885  13.658  1.00 39.25           O  
ATOM    566  N   ASP A  76      56.078  41.934  14.898  1.00 30.68           N  
ATOM    567  CA  ASP A  76      57.528  42.162  14.874  1.00 31.31           C  
ATOM    568  C   ASP A  76      57.987  42.551  13.465  1.00 30.77           C  
ATOM    569  O   ASP A  76      58.717  43.530  13.286  1.00 30.48           O  
ATOM    570  CB  ASP A  76      58.291  40.913  15.348  1.00 31.79           C  
ATOM    571  CG  ASP A  76      58.035  40.591  16.820  1.00 34.99           C  
ATOM    572  OD1 ASP A  76      57.788  41.551  17.587  1.00 35.78           O  
ATOM    573  OD2 ASP A  76      58.072  39.386  17.205  1.00 37.18           O  
ATOM    574  N   ALA A  77      57.542  41.786  12.461  1.00 30.11           N  
ATOM    575  CA  ALA A  77      57.867  42.086  11.063  1.00 30.04           C  
ATOM    576  C   ALA A  77      57.340  43.459  10.621  1.00 30.08           C  
ATOM    577  O   ALA A  77      58.031  44.207   9.925  1.00 29.75           O  
ATOM    578  CB  ALA A  77      57.336  40.978  10.128  1.00 29.45           C  
ATOM    579  N   LEU A  78      56.108  43.776  11.003  1.00 30.12           N  
ATOM    580  CA  LEU A  78      55.517  45.061  10.637  1.00 30.96           C  
ATOM    581  C   LEU A  78      56.230  46.220  11.347  1.00 32.00           C  
ATOM    582  O   LEU A  78      56.438  47.272  10.750  1.00 31.25           O  
ATOM    583  CB  LEU A  78      53.996  45.072  10.880  1.00 30.55           C  
ATOM    584  CG  LEU A  78      53.180  44.081  10.031  1.00 30.29           C  
ATOM    585  CD1 LEU A  78      51.765  43.951  10.537  1.00 29.72           C  
ATOM    586  CD2 LEU A  78      53.168  44.479   8.535  1.00 31.01           C  
ATOM    587  N   ARG A  79      56.615  46.017  12.608  1.00 33.87           N  
ATOM    588  CA  ARG A  79      57.455  46.989  13.336  1.00 36.36           C  
ATOM    589  C   ARG A  79      58.781  47.268  12.610  1.00 36.32           C  
ATOM    590  O   ARG A  79      59.229  48.418  12.548  1.00 37.12           O  
ATOM    591  CB  ARG A  79      57.742  46.515  14.757  1.00 36.33           C  
ATOM    592  CG  ARG A  79      56.907  47.182  15.840  1.00 39.32           C  
ATOM    593  CD  ARG A  79      57.380  46.768  17.246  1.00 39.99           C  
ATOM    594  NE  ARG A  79      57.180  45.337  17.520  1.00 45.18           N  
ATOM    595  CZ  ARG A  79      56.017  44.784  17.867  1.00 46.38           C  
ATOM    596  NH1 ARG A  79      55.932  43.478  18.086  1.00 47.41           N  
ATOM    597  NH2 ARG A  79      54.929  45.530  17.985  1.00 48.95           N  
ATOM    598  N   SER A  80      59.400  46.228  12.043  1.00 36.46           N  
ATOM    599  CA  SER A  80      60.619  46.408  11.231  1.00 36.12           C  
ATOM    600  C   SER A  80      60.382  47.349  10.084  1.00 35.72           C  
ATOM    601  O   SER A  80      61.309  47.999   9.608  1.00 35.82           O  
ATOM    602  CB  SER A  80      61.118  45.079  10.665  1.00 35.85           C  
ATOM    603  OG  SER A  80      61.493  44.233  11.722  1.00 37.44           O  
ATOM    604  N   ARG A  81      59.137  47.401   9.621  1.00 35.32           N  
ATOM    605  CA  ARG A  81      58.778  48.216   8.473  1.00 34.67           C  
ATOM    606  C   ARG A  81      58.280  49.592   8.926  1.00 35.38           C  
ATOM    607  O   ARG A  81      57.782  50.366   8.115  1.00 35.31           O  
ATOM    608  CB  ARG A  81      57.742  47.488   7.603  1.00 34.53           C  
ATOM    609  CG  ARG A  81      58.326  46.303   6.832  1.00 34.03           C  
ATOM    610  CD  ARG A  81      57.272  45.288   6.364  1.00 33.04           C  
ATOM    611  NE  ARG A  81      57.891  44.213   5.577  1.00 28.84           N  
ATOM    612  CZ  ARG A  81      58.588  43.201   6.095  1.00 27.20           C  
ATOM    613  NH1 ARG A  81      58.761  43.095   7.415  1.00 25.04           N  
ATOM    614  NH2 ARG A  81      59.120  42.288   5.290  1.00 27.81           N  
ATOM    615  N   GLY A  82      58.433  49.891  10.216  1.00 35.82           N  
ATOM    616  CA  GLY A  82      57.999  51.184  10.777  1.00 36.83           C  
ATOM    617  C   GLY A  82      56.483  51.305  10.906  1.00 37.52           C  
ATOM    618  O   GLY A  82      55.943  52.407  10.999  1.00 36.82           O  
ATOM    619  N   VAL A  83      55.801  50.158  10.908  1.00 37.82           N  
ATOM    620  CA  VAL A  83      54.355  50.117  11.034  1.00 38.58           C  
ATOM    621  C   VAL A  83      53.998  49.816  12.478  1.00 39.08           C  
ATOM    622  O   VAL A  83      54.499  48.850  13.078  1.00 39.14           O  
ATOM    623  CB  VAL A  83      53.753  49.017  10.145  1.00 38.73           C  
ATOM    624  CG1 VAL A  83      52.284  48.829  10.438  1.00 39.02           C  
ATOM    625  CG2 VAL A  83      53.980  49.339   8.679  1.00 39.71           C  
ATOM    626  N   VAL A  84      53.116  50.631  13.038  1.00 39.53           N  
ATOM    627  CA  VAL A  84      52.587  50.319  14.357  1.00 40.29           C  
ATOM    628  C   VAL A  84      51.052  50.387  14.396  1.00 39.68           C  
ATOM    629  O   VAL A  84      50.420  51.290  13.834  1.00 39.73           O  
ATOM    630  CB  VAL A  84      53.299  51.153  15.481  1.00 40.50           C  
ATOM    631  CG1 VAL A  84      52.777  52.575  15.536  1.00 41.28           C  
ATOM    632  CG2 VAL A  84      53.188  50.450  16.841  1.00 41.58           C  
ATOM    633  N   LEU A  85      50.471  49.388  15.043  1.00 39.69           N  
ATOM    634  CA  LEU A  85      49.037  49.282  15.209  1.00 39.23           C  
ATOM    635  C   LEU A  85      48.443  50.479  15.976  1.00 38.67           C  
ATOM    636  O   LEU A  85      48.936  50.849  17.048  1.00 38.99           O  
ATOM    637  CB  LEU A  85      48.732  47.976  15.935  1.00 39.56           C  
ATOM    638  CG  LEU A  85      47.328  47.748  16.507  1.00 40.17           C  
ATOM    639  CD1 LEU A  85      46.402  47.226  15.419  1.00 39.02           C  
ATOM    640  CD2 LEU A  85      47.419  46.775  17.675  1.00 40.48           C  
ATOM    641  N   LYS A  86      47.402  51.081  15.406  1.00 37.68           N  
ATOM    642  CA  LYS A  86      46.617  52.098  16.098  1.00 37.17           C  
ATOM    643  C   LYS A  86      45.211  51.631  16.504  1.00 36.26           C  
ATOM    644  O   LYS A  86      44.768  51.924  17.619  1.00 36.43           O  
ATOM    645  CB  LYS A  86      46.508  53.370  15.258  1.00 37.22           C  
ATOM    646  CG  LYS A  86      45.866  54.556  15.976  1.00 38.89           C  
ATOM    647  CD  LYS A  86      46.463  54.804  17.369  1.00 39.70           C  
ATOM    648  CE  LYS A  86      45.839  56.037  17.991  1.00 41.80           C  
ATOM    649  NZ  LYS A  86      46.419  56.363  19.314  1.00 42.54           N  
ATOM    650  N   ILE A  87      44.509  50.952  15.595  1.00 34.62           N  
ATOM    651  CA  ILE A  87      43.123  50.523  15.818  1.00 33.87           C  
ATOM    652  C   ILE A  87      42.971  49.055  15.437  1.00 33.54           C  
ATOM    653  O   ILE A  87      43.467  48.638  14.388  1.00 33.19           O  
ATOM    654  CB  ILE A  87      42.125  51.343  14.972  1.00 33.95           C  
ATOM    655  CG1 ILE A  87      42.289  52.834  15.230  1.00 34.99           C  
ATOM    656  CG2 ILE A  87      40.664  50.939  15.257  1.00 33.67           C  
ATOM    657  CD1 ILE A  87      41.969  53.661  14.045  1.00 35.67           C  
ATOM    658  N   ALA A  88      42.305  48.276  16.284  1.00 32.52           N  
ATOM    659  CA  ALA A  88      41.902  46.907  15.925  1.00 32.77           C  
ATOM    660  C   ALA A  88      40.414  46.710  16.182  1.00 32.78           C  
ATOM    661  O   ALA A  88      39.950  46.837  17.330  1.00 32.79           O  
ATOM    662  CB  ALA A  88      42.727  45.863  16.674  1.00 32.43           C  
ATOM    663  N   ASN A  89      39.670  46.470  15.104  1.00 32.51           N  
ATOM    664  CA  ASN A  89      38.279  46.023  15.180  1.00 33.28           C  
ATOM    665  C   ASN A  89      38.256  44.510  15.150  1.00 32.41           C  
ATOM    666  O   ASN A  89      38.847  43.895  14.252  1.00 31.71           O  
ATOM    667  CB  ASN A  89      37.450  46.565  14.011  1.00 33.59           C  
ATOM    668  CG  ASN A  89      37.231  48.069  14.101  1.00 38.60           C  
ATOM    669  OD1 ASN A  89      36.944  48.603  15.182  1.00 43.34           O  
ATOM    670  ND2 ASN A  89      37.348  48.764  12.963  1.00 40.97           N  
ATOM    671  N   GLN A  90      37.570  43.925  16.125  1.00 31.26           N  
ATOM    672  CA  GLN A  90      37.461  42.480  16.259  1.00 31.25           C  
ATOM    673  C   GLN A  90      36.000  42.044  16.382  1.00 29.59           C  
ATOM    674  O   GLN A  90      35.199  42.684  17.074  1.00 28.78           O  
ATOM    675  CB  GLN A  90      38.290  41.969  17.444  1.00 30.69           C  
ATOM    676  CG  GLN A  90      39.809  42.043  17.180  1.00 34.11           C  
ATOM    677  CD  GLN A  90      40.654  41.294  18.204  1.00 35.18           C  
ATOM    678  OE1 GLN A  90      40.359  41.304  19.405  1.00 42.17           O  
ATOM    679  NE2 GLN A  90      41.718  40.633  17.728  1.00 38.62           N  
ATOM    680  N   LYS A  91      35.663  40.969  15.680  1.00 27.36           N  
ATOM    681  CA  LYS A  91      34.355  40.360  15.793  1.00 26.40           C  
ATOM    682  C   LYS A  91      34.557  38.920  16.266  1.00 25.03           C  
ATOM    683  O   LYS A  91      35.275  38.132  15.628  1.00 24.15           O  
ATOM    684  CB  LYS A  91      33.627  40.441  14.454  1.00 26.61           C  
ATOM    685  CG  LYS A  91      32.261  39.777  14.437  1.00 30.52           C  
ATOM    686  CD  LYS A  91      31.838  39.564  12.984  1.00 38.84           C  
ATOM    687  CE  LYS A  91      30.339  39.654  12.796  1.00 42.30           C  
ATOM    688  NZ  LYS A  91      30.008  39.417  11.344  1.00 46.23           N  
ATOM    689  N   ILE A  92      33.951  38.594  17.399  1.00 23.75           N  
ATOM    690  CA  ILE A  92      34.164  37.312  18.060  1.00 23.77           C  
ATOM    691  C   ILE A  92      32.914  36.461  17.902  1.00 23.51           C  
ATOM    692  O   ILE A  92      31.805  36.906  18.234  1.00 23.03           O  
ATOM    693  CB  ILE A  92      34.505  37.488  19.559  1.00 23.85           C  
ATOM    694  CG1 ILE A  92      35.707  38.429  19.733  1.00 25.51           C  
ATOM    695  CG2 ILE A  92      34.786  36.127  20.232  1.00 23.80           C  
ATOM    696  CD1 ILE A  92      35.871  38.912  21.169  1.00 27.49           C  
ATOM    697  N   GLY A  93      33.093  35.262  17.354  1.00 22.53           N  
ATOM    698  CA  GLY A  93      31.981  34.345  17.120  1.00 21.69           C  
ATOM    699  C   GLY A  93      32.360  32.925  17.504  1.00 21.40           C  
ATOM    700  O   GLY A  93      33.370  32.695  18.205  1.00 20.60           O  
ATOM    701  N   ALA A  94      31.544  31.971  17.054  1.00 20.67           N  
ATOM    702  CA  ALA A  94      31.798  30.544  17.299  1.00 20.00           C  
ATOM    703  C   ALA A  94      31.176  29.753  16.157  1.00 20.45           C  
ATOM    704  O   ALA A  94      30.174  30.198  15.561  1.00 18.78           O  
ATOM    705  CB  ALA A  94      31.173  30.108  18.632  1.00 19.25           C  
ATOM    706  N   ARG A  95      31.770  28.598  15.850  1.00 19.97           N  
ATOM    707  CA  ARG A  95      31.278  27.730  14.781  1.00 21.32           C  
ATOM    708  C   ARG A  95      31.862  26.338  15.004  1.00 21.66           C  
ATOM    709  O   ARG A  95      32.713  26.157  15.876  1.00 20.96           O  
ATOM    710  CB  ARG A  95      31.670  28.268  13.389  1.00 20.84           C  
ATOM    711  CG  ARG A  95      33.188  28.353  13.130  1.00 21.29           C  
ATOM    712  CD  ARG A  95      33.504  28.771  11.655  1.00 22.09           C  
ATOM    713  NE  ARG A  95      34.950  28.959  11.429  1.00 23.29           N  
ATOM    714  CZ  ARG A  95      35.827  27.980  11.196  1.00 25.61           C  
ATOM    715  NH1 ARG A  95      35.437  26.703  11.150  1.00 24.50           N  
ATOM    716  NH2 ARG A  95      37.115  28.277  11.009  1.00 25.74           N  
ATOM    717  N   ARG A  96      31.403  25.384  14.195  1.00 21.98           N  
ATOM    718  CA  ARG A  96      31.939  24.020  14.152  1.00 22.73           C  
ATOM    719  C   ARG A  96      33.255  23.908  13.368  1.00 22.63           C  
ATOM    720  O   ARG A  96      33.452  24.571  12.342  1.00 23.21           O  
ATOM    721  CB  ARG A  96      30.910  23.082  13.514  1.00 22.51           C  
ATOM    722  CG  ARG A  96      29.664  22.839  14.345  1.00 23.49           C  
ATOM    723  CD  ARG A  96      28.805  21.746  13.649  1.00 23.71           C  
ATOM    724  NE  ARG A  96      27.529  21.449  14.314  1.00 22.23           N  
ATOM    725  CZ  ARG A  96      27.365  20.508  15.241  1.00 21.83           C  
ATOM    726  NH1 ARG A  96      28.397  19.784  15.669  1.00 20.18           N  
ATOM    727  NH2 ARG A  96      26.164  20.291  15.747  1.00 21.66           N  
ATOM    728  N   ALA A  97      34.147  23.055  13.841  1.00 23.13           N  
ATOM    729  CA  ALA A  97      35.378  22.758  13.118  1.00 23.95           C  
ATOM    730  C   ALA A  97      35.012  21.967  11.867  1.00 24.82           C  
ATOM    731  O   ALA A  97      34.141  21.082  11.922  1.00 24.37           O  
ATOM    732  CB  ALA A  97      36.316  21.940  13.981  1.00 23.30           C  
ATOM    733  N   VAL A  98      35.664  22.293  10.753  1.00 25.15           N  
ATOM    734  CA  VAL A  98      35.435  21.593   9.490  1.00 26.79           C  
ATOM    735  C   VAL A  98      36.775  21.254   8.832  1.00 27.72           C  
ATOM    736  O   VAL A  98      37.793  21.885   9.140  1.00 27.15           O  
ATOM    737  CB  VAL A  98      34.575  22.437   8.503  1.00 26.98           C  
ATOM    738  CG1 VAL A  98      33.125  22.571   9.002  1.00 27.78           C  
ATOM    739  CG2 VAL A  98      35.202  23.805   8.251  1.00 27.39           C  
ATOM    740  N   GLY A  99      36.773  20.257   7.941  1.00 28.48           N  
ATOM    741  CA  GLY A  99      37.968  19.904   7.162  1.00 28.57           C  
ATOM    742  C   GLY A  99      39.093  19.429   8.056  1.00 28.25           C  
ATOM    743  O   GLY A  99      38.869  18.641   8.958  1.00 28.23           O  
ATOM    744  N   GLU A 100      40.301  19.936   7.808  1.00 28.37           N  
ATOM    745  CA  GLU A 100      41.493  19.580   8.579  1.00 28.26           C  
ATOM    746  C   GLU A 100      41.631  20.381   9.877  1.00 27.03           C  
ATOM    747  O   GLU A 100      42.606  20.205  10.606  1.00 26.09           O  
ATOM    748  CB  GLU A 100      42.776  19.779   7.746  1.00 28.87           C  
ATOM    749  CG  GLU A 100      42.917  18.890   6.496  1.00 33.92           C  
ATOM    750  CD  GLU A 100      42.674  17.385   6.729  1.00 40.65           C  
ATOM    751  OE1 GLU A 100      42.881  16.842   7.855  1.00 42.53           O  
ATOM    752  OE2 GLU A 100      42.255  16.736   5.749  1.00 45.33           O  
ATOM    753  N   GLU A 101      40.673  21.257  10.164  1.00 25.64           N  
ATOM    754  CA  GLU A 101      40.720  22.028  11.400  1.00 24.91           C  
ATOM    755  C   GLU A 101      40.782  21.130  12.635  1.00 24.79           C  
ATOM    756  O   GLU A 101      41.555  21.405  13.557  1.00 24.44           O  
ATOM    757  CB  GLU A 101      39.535  23.003  11.508  1.00 24.42           C  
ATOM    758  CG  GLU A 101      39.607  24.132  10.492  1.00 24.42           C  
ATOM    759  CD  GLU A 101      38.350  24.989  10.490  1.00 25.76           C  
ATOM    760  OE1 GLU A 101      37.306  24.559  11.021  1.00 25.69           O  
ATOM    761  OE2 GLU A 101      38.412  26.116   9.986  1.00 28.89           O  
ATOM    762  N   SER A 102      39.997  20.054  12.652  1.00 24.11           N  
ATOM    763  CA  SER A 102      39.951  19.200  13.838  1.00 24.16           C  
ATOM    764  C   SER A 102      41.248  18.417  14.029  1.00 24.28           C  
ATOM    765  O   SER A 102      41.661  18.164  15.159  1.00 24.45           O  
ATOM    766  CB  SER A 102      38.734  18.251  13.836  1.00 24.14           C  
ATOM    767  OG  SER A 102      38.745  17.384  12.693  1.00 26.40           O  
ATOM    768  N   THR A 103      41.905  18.036  12.936  1.00 24.49           N  
ATOM    769  CA  THR A 103      43.177  17.333  13.069  1.00 24.44           C  
ATOM    770  C   THR A 103      44.316  18.319  13.359  1.00 24.08           C  
ATOM    771  O   THR A 103      45.218  18.019  14.125  1.00 23.99           O  
ATOM    772  CB  THR A 103      43.484  16.458  11.847  1.00 25.14           C  
ATOM    773  OG1 THR A 103      43.499  17.277  10.663  1.00 25.52           O  
ATOM    774  CG2 THR A 103      42.415  15.337  11.689  1.00 26.12           C  
ATOM    775  N   LEU A 104      44.275  19.504  12.765  1.00 23.65           N  
ATOM    776  CA  LEU A 104      45.276  20.524  13.114  1.00 23.36           C  
ATOM    777  C   LEU A 104      45.220  20.876  14.599  1.00 23.19           C  
ATOM    778  O   LEU A 104      46.256  21.024  15.246  1.00 23.02           O  
ATOM    779  CB  LEU A 104      45.118  21.774  12.242  1.00 23.27           C  
ATOM    780  CG  LEU A 104      45.658  21.658  10.802  1.00 23.65           C  
ATOM    781  CD1 LEU A 104      45.183  22.865   9.969  1.00 22.35           C  
ATOM    782  CD2 LEU A 104      47.189  21.553  10.792  1.00 21.56           C  
ATOM    783  N   LEU A 105      44.008  20.988  15.143  1.00 22.51           N  
ATOM    784  CA  LEU A 105      43.835  21.398  16.545  1.00 23.16           C  
ATOM    785  C   LEU A 105      43.703  20.230  17.523  1.00 23.58           C  
ATOM    786  O   LEU A 105      43.618  20.440  18.703  1.00 23.63           O  
ATOM    787  CB  LEU A 105      42.624  22.338  16.685  1.00 22.01           C  
ATOM    788  CG  LEU A 105      42.848  23.706  16.023  1.00 22.55           C  
ATOM    789  CD1 LEU A 105      41.556  24.529  15.880  1.00 19.00           C  
ATOM    790  CD2 LEU A 105      43.881  24.493  16.815  1.00 20.51           C  
ATOM    791  N   ASP A 106      43.700  18.998  17.017  1.00 24.85           N  
ATOM    792  CA  ASP A 106      43.487  17.809  17.855  1.00 26.09           C  
ATOM    793  C   ASP A 106      42.171  17.885  18.663  1.00 25.93           C  
ATOM    794  O   ASP A 106      42.148  17.707  19.874  1.00 25.27           O  
ATOM    795  CB  ASP A 106      44.704  17.547  18.757  1.00 26.42           C  
ATOM    796  CG  ASP A 106      44.671  16.146  19.411  1.00 31.44           C  
ATOM    797  OD1 ASP A 106      44.187  15.185  18.766  1.00 35.00           O  
ATOM    798  OD2 ASP A 106      45.126  16.008  20.572  1.00 33.77           O  
ATOM    799  N   ILE A 107      41.076  18.170  17.966  1.00 25.96           N  
ATOM    800  CA  ILE A 107      39.758  18.216  18.591  1.00 25.49           C  
ATOM    801  C   ILE A 107      38.829  17.335  17.762  1.00 26.59           C  
ATOM    802  O   ILE A 107      39.273  16.724  16.793  1.00 26.41           O  
ATOM    803  CB  ILE A 107      39.224  19.665  18.674  1.00 25.43           C  
ATOM    804  CG1 ILE A 107      39.173  20.305  17.266  1.00 23.55           C  
ATOM    805  CG2 ILE A 107      40.072  20.495  19.661  1.00 25.94           C  
ATOM    806  CD1 ILE A 107      38.527  21.678  17.208  1.00 24.66           C  
ATOM    807  N   GLU A 108      37.548  17.283  18.143  1.00 26.94           N  
ATOM    808  CA  GLU A 108      36.546  16.505  17.426  1.00 28.06           C  
ATOM    809  C   GLU A 108      36.081  17.244  16.187  1.00 27.13           C  
ATOM    810  O   GLU A 108      35.898  18.476  16.209  1.00 26.53           O  
ATOM    811  CB  GLU A 108      35.317  16.222  18.314  1.00 27.49           C  
ATOM    812  CG  GLU A 108      35.597  15.423  19.574  1.00 30.82           C  
ATOM    813  CD  GLU A 108      34.346  15.229  20.438  1.00 32.00           C  
ATOM    814  OE1 GLU A 108      33.222  15.527  19.967  1.00 36.98           O  
ATOM    815  OE2 GLU A 108      34.484  14.777  21.598  1.00 39.98           O  
ATOM    816  N   ASP A 109      35.876  16.489  15.111  1.00 26.67           N  
ATOM    817  CA  ASP A 109      35.241  17.028  13.919  1.00 27.04           C  
ATOM    818  C   ASP A 109      33.854  17.506  14.331  1.00 26.08           C  
ATOM    819  O   ASP A 109      33.162  16.838  15.105  1.00 25.95           O  
ATOM    820  CB  ASP A 109      35.170  15.968  12.813  1.00 28.39           C  
ATOM    821  CG  ASP A 109      34.579  16.513  11.503  1.00 31.29           C  
ATOM    822  OD1 ASP A 109      34.826  17.690  11.134  1.00 34.54           O  
ATOM    823  OD2 ASP A 109      33.864  15.742  10.826  1.00 37.30           O  
ATOM    824  N   GLY A 110      33.488  18.699  13.880  1.00 25.10           N  
ATOM    825  CA  GLY A 110      32.230  19.314  14.267  1.00 24.37           C  
ATOM    826  C   GLY A 110      32.231  19.886  15.686  1.00 23.76           C  
ATOM    827  O   GLY A 110      31.213  20.407  16.146  1.00 23.85           O  
ATOM    828  N   GLY A 111      33.360  19.792  16.374  1.00 22.60           N  
ATOM    829  CA  GLY A 111      33.507  20.402  17.694  1.00 22.60           C  
ATOM    830  C   GLY A 111      33.545  21.930  17.630  1.00 22.34           C  
ATOM    831  O   GLY A 111      33.833  22.503  16.567  1.00 22.35           O  
ATOM    832  N   PRO A 112      33.263  22.605  18.771  1.00 21.61           N  
ATOM    833  CA  PRO A 112      33.126  24.058  18.732  1.00 21.06           C  
ATOM    834  C   PRO A 112      34.486  24.745  18.620  1.00 21.22           C  
ATOM    835  O   PRO A 112      35.491  24.241  19.152  1.00 21.79           O  
ATOM    836  CB  PRO A 112      32.467  24.389  20.077  1.00 21.50           C  
ATOM    837  CG  PRO A 112      32.979  23.291  21.004  1.00 21.77           C  
ATOM    838  CD  PRO A 112      33.091  22.060  20.133  1.00 21.28           C  
ATOM    839  N   LEU A 113      34.496  25.867  17.924  1.00 20.08           N  
ATOM    840  CA  LEU A 113      35.636  26.738  17.841  1.00 20.07           C  
ATOM    841  C   LEU A 113      35.208  28.153  18.179  1.00 20.06           C  
ATOM    842  O   LEU A 113      34.145  28.610  17.757  1.00 19.32           O  
ATOM    843  CB  LEU A 113      36.171  26.758  16.406  1.00 19.92           C  
ATOM    844  CG  LEU A 113      36.863  25.512  15.863  1.00 19.28           C  
ATOM    845  CD1 LEU A 113      37.105  25.692  14.374  1.00 20.56           C  
ATOM    846  CD2 LEU A 113      38.159  25.315  16.600  1.00 19.99           C  
ATOM    847  N   LEU A 114      36.062  28.856  18.895  1.00 19.96           N  
ATOM    848  CA  LEU A 114      35.928  30.290  19.067  1.00 20.84           C  
ATOM    849  C   LEU A 114      36.581  30.970  17.864  1.00 21.99           C  
ATOM    850  O   LEU A 114      37.673  30.563  17.436  1.00 21.98           O  
ATOM    851  CB  LEU A 114      36.636  30.700  20.363  1.00 21.03           C  
ATOM    852  CG  LEU A 114      36.606  32.155  20.808  1.00 21.10           C  
ATOM    853  CD1 LEU A 114      35.167  32.612  21.210  1.00 16.37           C  
ATOM    854  CD2 LEU A 114      37.607  32.281  21.960  1.00 20.61           C  
ATOM    855  N   THR A 115      35.919  31.975  17.289  1.00 21.81           N  
ATOM    856  CA  THR A 115      36.481  32.667  16.106  1.00 22.59           C  
ATOM    857  C   THR A 115      36.705  34.155  16.330  1.00 22.62           C  
ATOM    858  O   THR A 115      35.976  34.787  17.095  1.00 20.83           O  
ATOM    859  CB  THR A 115      35.607  32.468  14.829  1.00 22.71           C  
ATOM    860  OG1 THR A 115      34.304  33.076  15.010  1.00 22.81           O  
ATOM    861  CG2 THR A 115      35.453  30.960  14.541  1.00 23.15           C  
ATOM    862  N   VAL A 116      37.713  34.713  15.658  1.00 23.37           N  
ATOM    863  CA  VAL A 116      37.841  36.177  15.590  1.00 24.23           C  
ATOM    864  C   VAL A 116      38.134  36.648  14.164  1.00 24.74           C  
ATOM    865  O   VAL A 116      38.992  36.078  13.461  1.00 23.72           O  
ATOM    866  CB  VAL A 116      38.880  36.753  16.593  1.00 24.88           C  
ATOM    867  CG1 VAL A 116      40.268  36.419  16.157  1.00 26.56           C  
ATOM    868  CG2 VAL A 116      38.756  38.297  16.721  1.00 26.13           C  
ATOM    869  N   GLU A 117      37.386  37.671  13.747  1.00 24.67           N  
ATOM    870  CA  GLU A 117      37.635  38.404  12.522  1.00 26.10           C  
ATOM    871  C   GLU A 117      38.166  39.759  12.949  1.00 25.79           C  
ATOM    872  O   GLU A 117      37.540  40.461  13.742  1.00 25.36           O  
ATOM    873  CB  GLU A 117      36.334  38.613  11.749  1.00 26.31           C  
ATOM    874  CG  GLU A 117      35.739  37.343  11.177  1.00 32.33           C  
ATOM    875  CD  GLU A 117      36.586  36.802  10.055  1.00 38.63           C  
ATOM    876  OE1 GLU A 117      36.936  37.594   9.144  1.00 42.49           O  
ATOM    877  OE2 GLU A 117      36.932  35.599  10.095  1.00 42.98           O  
ATOM    878  N   ARG A 118      39.307  40.131  12.402  1.00 25.52           N  
ATOM    879  CA  ARG A 118      40.033  41.290  12.863  1.00 25.98           C  
ATOM    880  C   ARG A 118      40.454  42.129  11.670  1.00 25.87           C  
ATOM    881  O   ARG A 118      40.898  41.589  10.651  1.00 25.03           O  
ATOM    882  CB  ARG A 118      41.268  40.806  13.634  1.00 26.81           C  
ATOM    883  CG  ARG A 118      42.244  41.868  14.065  1.00 28.67           C  
ATOM    884  CD  ARG A 118      43.479  41.194  14.649  1.00 33.80           C  
ATOM    885  NE  ARG A 118      44.557  42.153  14.906  1.00 34.76           N  
ATOM    886  CZ  ARG A 118      44.800  42.717  16.086  1.00 36.32           C  
ATOM    887  NH1 ARG A 118      44.053  42.423  17.150  1.00 37.81           N  
ATOM    888  NH2 ARG A 118      45.792  43.582  16.204  1.00 35.54           N  
ATOM    889  N   VAL A 119      40.295  43.446  11.797  1.00 25.79           N  
ATOM    890  CA  VAL A 119      40.880  44.412  10.862  1.00 25.98           C  
ATOM    891  C   VAL A 119      41.739  45.357  11.699  1.00 26.18           C  
ATOM    892  O   VAL A 119      41.254  45.964  12.666  1.00 25.96           O  
ATOM    893  CB  VAL A 119      39.799  45.216  10.072  1.00 26.82           C  
ATOM    894  CG1 VAL A 119      40.449  46.209   9.074  1.00 26.33           C  
ATOM    895  CG2 VAL A 119      38.837  44.287   9.325  1.00 26.93           C  
ATOM    896  N   ALA A 120      43.017  45.454  11.348  1.00 25.49           N  
ATOM    897  CA  ALA A 120      43.959  46.318  12.049  1.00 26.28           C  
ATOM    898  C   ALA A 120      44.336  47.518  11.184  1.00 27.20           C  
ATOM    899  O   ALA A 120      44.655  47.362   9.998  1.00 27.06           O  
ATOM    900  CB  ALA A 120      45.210  45.530  12.440  1.00 26.14           C  
ATOM    901  N   LEU A 121      44.294  48.710  11.771  1.00 27.85           N  
ATOM    902  CA  LEU A 121      44.605  49.956  11.046  1.00 28.70           C  
ATOM    903  C   LEU A 121      45.726  50.705  11.736  1.00 29.62           C  
ATOM    904  O   LEU A 121      45.969  50.508  12.937  1.00 28.52           O  
ATOM    905  CB  LEU A 121      43.369  50.847  10.909  1.00 28.58           C  
ATOM    906  CG  LEU A 121      42.229  50.212  10.106  1.00 29.73           C  
ATOM    907  CD1 LEU A 121      41.290  49.420  10.993  1.00 30.74           C  
ATOM    908  CD2 LEU A 121      41.460  51.256   9.336  1.00 34.57           C  
ATOM    909  N   ASP A 122      46.450  51.515  10.964  1.00 30.87           N  
ATOM    910  CA  ASP A 122      47.502  52.361  11.526  1.00 32.91           C  
ATOM    911  C   ASP A 122      46.967  53.769  11.789  1.00 33.36           C  
ATOM    912  O   ASP A 122      45.789  54.048  11.536  1.00 32.96           O  
ATOM    913  CB  ASP A 122      48.765  52.385  10.640  1.00 33.21           C  
ATOM    914  CG  ASP A 122      48.516  52.960   9.240  1.00 36.52           C  
ATOM    915  OD1 ASP A 122      47.527  53.708   9.021  1.00 38.45           O  
ATOM    916  OD2 ASP A 122      49.345  52.662   8.342  1.00 40.17           O  
ATOM    917  N   ASN A 123      47.839  54.652  12.271  1.00 34.73           N  
ATOM    918  CA  ASN A 123      47.431  56.004  12.670  1.00 36.32           C  
ATOM    919  C   ASN A 123      46.943  56.871  11.512  1.00 36.62           C  
ATOM    920  O   ASN A 123      46.338  57.915  11.730  1.00 37.42           O  
ATOM    921  CB  ASN A 123      48.525  56.705  13.491  1.00 36.43           C  
ATOM    922  CG  ASN A 123      47.967  57.816  14.388  1.00 38.48           C  
ATOM    923  OD1 ASN A 123      47.118  57.575  15.259  1.00 39.50           O  
ATOM    924  ND2 ASN A 123      48.455  59.041  14.183  1.00 38.18           N  
ATOM    925  N   SER A 124      47.171  56.429  10.280  1.00 37.12           N  
ATOM    926  CA  SER A 124      46.640  57.151   9.123  1.00 37.57           C  
ATOM    927  C   SER A 124      45.342  56.543   8.610  1.00 37.21           C  
ATOM    928  O   SER A 124      44.825  56.954   7.569  1.00 37.55           O  
ATOM    929  CB  SER A 124      47.687  57.228   8.004  1.00 38.08           C  
ATOM    930  OG  SER A 124      48.333  55.973   7.824  1.00 40.98           O  
ATOM    931  N   GLY A 125      44.818  55.556   9.335  1.00 36.74           N  
ATOM    932  CA  GLY A 125      43.609  54.856   8.917  1.00 36.09           C  
ATOM    933  C   GLY A 125      43.827  53.867   7.781  1.00 36.06           C  
ATOM    934  O   GLY A 125      42.876  53.470   7.110  1.00 36.28           O  
ATOM    935  N   GLN A 126      45.072  53.462   7.560  1.00 35.12           N  
ATOM    936  CA  GLN A 126      45.351  52.463   6.533  1.00 35.31           C  
ATOM    937  C   GLN A 126      45.268  51.049   7.140  1.00 33.31           C  
ATOM    938  O   GLN A 126      45.860  50.793   8.184  1.00 32.81           O  
ATOM    939  CB  GLN A 126      46.705  52.749   5.872  1.00 34.84           C  
ATOM    940  CG  GLN A 126      46.735  54.150   5.193  1.00 38.17           C  
ATOM    941  CD  GLN A 126      48.110  54.579   4.672  1.00 38.29           C  
ATOM    942  OE1 GLN A 126      49.061  54.801   5.451  1.00 42.29           O  
ATOM    943  NE2 GLN A 126      48.208  54.739   3.351  1.00 42.06           N  
ATOM    944  N   VAL A 127      44.505  50.160   6.500  1.00 31.92           N  
ATOM    945  CA  VAL A 127      44.422  48.761   6.909  1.00 30.71           C  
ATOM    946  C   VAL A 127      45.800  48.110   6.780  1.00 30.57           C  
ATOM    947  O   VAL A 127      46.354  48.045   5.687  1.00 30.31           O  
ATOM    948  CB  VAL A 127      43.375  47.956   6.085  1.00 30.60           C  
ATOM    949  CG1 VAL A 127      43.412  46.469   6.473  1.00 30.09           C  
ATOM    950  CG2 VAL A 127      41.943  48.516   6.268  1.00 29.63           C  
ATOM    951  N   ILE A 128      46.341  47.633   7.896  1.00 30.23           N  
ATOM    952  CA  ILE A 128      47.660  47.007   7.925  1.00 31.03           C  
ATOM    953  C   ILE A 128      47.577  45.493   7.713  1.00 30.43           C  
ATOM    954  O   ILE A 128      48.480  44.892   7.117  1.00 29.99           O  
ATOM    955  CB  ILE A 128      48.368  47.202   9.275  1.00 31.51           C  
ATOM    956  CG1 ILE A 128      48.405  48.657   9.722  1.00 33.67           C  
ATOM    957  CG2 ILE A 128      49.803  46.711   9.197  1.00 34.23           C  
ATOM    958  CD1 ILE A 128      48.655  48.742  11.255  1.00 36.56           C  
ATOM    959  N   GLU A 129      46.495  44.880   8.206  1.00 29.20           N  
ATOM    960  CA  GLU A 129      46.422  43.430   8.323  1.00 28.69           C  
ATOM    961  C   GLU A 129      44.962  43.007   8.491  1.00 27.24           C  
ATOM    962  O   GLU A 129      44.182  43.714   9.147  1.00 25.67           O  
ATOM    963  CB  GLU A 129      47.294  43.035   9.538  1.00 29.91           C  
ATOM    964  CG  GLU A 129      47.234  41.638  10.031  1.00 34.68           C  
ATOM    965  CD  GLU A 129      46.276  41.441  11.192  1.00 38.68           C  
ATOM    966  OE1 GLU A 129      46.334  42.165  12.223  1.00 40.06           O  
ATOM    967  OE2 GLU A 129      45.461  40.514  11.074  1.00 42.68           O  
ATOM    968  N   LEU A 130      44.583  41.885   7.879  1.00 24.77           N  
ATOM    969  CA  LEU A 130      43.322  41.242   8.203  1.00 24.12           C  
ATOM    970  C   LEU A 130      43.632  39.907   8.875  1.00 23.84           C  
ATOM    971  O   LEU A 130      44.541  39.194   8.455  1.00 23.55           O  
ATOM    972  CB  LEU A 130      42.439  40.996   6.974  1.00 24.32           C  
ATOM    973  CG  LEU A 130      42.099  42.097   5.955  1.00 25.71           C  
ATOM    974  CD1 LEU A 130      41.429  41.473   4.740  1.00 24.93           C  
ATOM    975  CD2 LEU A 130      41.208  43.185   6.568  1.00 25.78           C  
ATOM    976  N   GLY A 131      42.902  39.587   9.940  1.00 22.72           N  
ATOM    977  CA  GLY A 131      43.077  38.314  10.629  1.00 22.19           C  
ATOM    978  C   GLY A 131      41.756  37.578  10.637  1.00 22.30           C  
ATOM    979  O   GLY A 131      40.675  38.189  10.720  1.00 21.82           O  
ATOM    980  N   SER A 132      41.839  36.265  10.525  1.00 22.14           N  
ATOM    981  CA  SER A 132      40.660  35.418  10.587  1.00 22.59           C  
ATOM    982  C   SER A 132      41.091  34.150  11.317  1.00 22.04           C  
ATOM    983  O   SER A 132      41.643  33.212  10.707  1.00 21.50           O  
ATOM    984  CB  SER A 132      40.174  35.093   9.173  1.00 22.85           C  
ATOM    985  OG  SER A 132      39.039  34.258   9.261  1.00 28.16           O  
ATOM    986  N   HIS A 133      40.882  34.133  12.627  1.00 21.03           N  
ATOM    987  CA  HIS A 133      41.466  33.070  13.468  1.00 21.11           C  
ATOM    988  C   HIS A 133      40.439  32.159  14.117  1.00 21.24           C  
ATOM    989  O   HIS A 133      39.293  32.561  14.329  1.00 20.42           O  
ATOM    990  CB  HIS A 133      42.341  33.709  14.544  1.00 20.71           C  
ATOM    991  CG  HIS A 133      43.316  34.702  13.996  1.00 20.98           C  
ATOM    992  ND1 HIS A 133      43.554  35.926  14.588  1.00 25.28           N  
ATOM    993  CD2 HIS A 133      44.091  34.661  12.888  1.00 19.13           C  
ATOM    994  CE1 HIS A 133      44.455  36.590  13.878  1.00 20.94           C  
ATOM    995  NE2 HIS A 133      44.795  35.844  12.841  1.00 24.82           N  
ATOM    996  N   CYS A 134      40.840  30.926  14.420  1.00 21.05           N  
ATOM    997  CA  CYS A 134      39.967  30.062  15.206  1.00 22.15           C  
ATOM    998  C   CYS A 134      40.771  29.389  16.288  1.00 22.21           C  
ATOM    999  O   CYS A 134      41.938  29.040  16.074  1.00 21.96           O  
ATOM   1000  CB  CYS A 134      39.200  29.072  14.338  1.00 21.74           C  
ATOM   1001  SG  CYS A 134      40.240  27.866  13.446  1.00 24.62           S  
ATOM   1002  N   TYR A 135      40.128  29.237  17.443  1.00 22.59           N  
ATOM   1003  CA  TYR A 135      40.740  28.743  18.677  1.00 23.12           C  
ATOM   1004  C   TYR A 135      39.933  27.608  19.259  1.00 23.59           C  
ATOM   1005  O   TYR A 135      38.704  27.667  19.275  1.00 23.69           O  
ATOM   1006  CB  TYR A 135      40.748  29.853  19.735  1.00 23.10           C  
ATOM   1007  CG  TYR A 135      41.392  31.135  19.280  1.00 23.95           C  
ATOM   1008  CD1 TYR A 135      42.708  31.429  19.632  1.00 23.52           C  
ATOM   1009  CD2 TYR A 135      40.683  32.060  18.492  1.00 24.64           C  
ATOM   1010  CE1 TYR A 135      43.316  32.613  19.204  1.00 25.26           C  
ATOM   1011  CE2 TYR A 135      41.284  33.241  18.063  1.00 23.01           C  
ATOM   1012  CZ  TYR A 135      42.587  33.497  18.428  1.00 23.49           C  
ATOM   1013  OH  TYR A 135      43.183  34.655  18.023  1.00 29.11           O  
ATOM   1014  N   ARG A 136      40.642  26.594  19.754  1.00 24.00           N  
ATOM   1015  CA  ARG A 136      40.131  25.605  20.698  1.00 24.38           C  
ATOM   1016  C   ARG A 136      39.623  26.334  21.937  1.00 23.65           C  
ATOM   1017  O   ARG A 136      40.435  26.890  22.675  1.00 22.72           O  
ATOM   1018  CB  ARG A 136      41.297  24.760  21.180  1.00 25.47           C  
ATOM   1019  CG  ARG A 136      41.411  23.501  20.528  1.00 27.48           C  
ATOM   1020  CD  ARG A 136      42.526  22.733  21.162  1.00 27.84           C  
ATOM   1021  NE  ARG A 136      42.097  22.051  22.376  1.00 26.30           N  
ATOM   1022  CZ  ARG A 136      42.590  20.879  22.765  1.00 28.77           C  
ATOM   1023  NH1 ARG A 136      43.487  20.250  22.006  1.00 30.69           N  
ATOM   1024  NH2 ARG A 136      42.169  20.316  23.879  1.00 29.51           N  
ATOM   1025  N   PRO A 137      38.297  26.326  22.181  1.00 23.45           N  
ATOM   1026  CA  PRO A 137      37.807  27.165  23.281  1.00 23.90           C  
ATOM   1027  C   PRO A 137      38.129  26.689  24.714  1.00 24.74           C  
ATOM   1028  O   PRO A 137      37.959  27.458  25.652  1.00 24.87           O  
ATOM   1029  CB  PRO A 137      36.299  27.228  23.038  1.00 23.69           C  
ATOM   1030  CG  PRO A 137      35.981  25.977  22.283  1.00 23.65           C  
ATOM   1031  CD  PRO A 137      37.202  25.649  21.457  1.00 23.41           C  
ATOM   1032  N   ASP A 138      38.608  25.459  24.892  1.00 25.30           N  
ATOM   1033  CA  ASP A 138      39.076  25.048  26.221  1.00 25.88           C  
ATOM   1034  C   ASP A 138      40.491  25.564  26.530  1.00 26.04           C  
ATOM   1035  O   ASP A 138      40.981  25.420  27.654  1.00 26.27           O  
ATOM   1036  CB  ASP A 138      38.985  23.525  26.400  1.00 26.19           C  
ATOM   1037  CG  ASP A 138      39.870  22.754  25.442  1.00 29.36           C  
ATOM   1038  OD1 ASP A 138      40.031  23.147  24.263  1.00 31.59           O  
ATOM   1039  OD2 ASP A 138      40.399  21.716  25.866  1.00 34.42           O  
ATOM   1040  N   MET A 139      41.142  26.162  25.530  1.00 25.32           N  
ATOM   1041  CA  MET A 139      42.527  26.633  25.653  1.00 25.36           C  
ATOM   1042  C   MET A 139      42.666  28.164  25.528  1.00 26.06           C  
ATOM   1043  O   MET A 139      43.758  28.704  25.700  1.00 26.65           O  
ATOM   1044  CB  MET A 139      43.417  25.965  24.576  1.00 24.55           C  
ATOM   1045  CG  MET A 139      43.645  24.442  24.755  1.00 24.62           C  
ATOM   1046  SD  MET A 139      44.342  23.927  26.363  1.00 17.52           S  
ATOM   1047  CE  MET A 139      45.991  24.586  26.216  1.00 21.13           C  
ATOM   1048  N   TYR A 140      41.577  28.858  25.209  1.00 26.23           N  
ATOM   1049  CA  TYR A 140      41.644  30.272  24.876  1.00 26.85           C  
ATOM   1050  C   TYR A 140      40.278  30.922  25.063  1.00 27.11           C  
ATOM   1051  O   TYR A 140      39.271  30.352  24.638  1.00 25.95           O  
ATOM   1052  CB  TYR A 140      42.086  30.447  23.406  1.00 27.72           C  
ATOM   1053  CG  TYR A 140      42.466  31.875  23.053  1.00 29.05           C  
ATOM   1054  CD1 TYR A 140      43.784  32.329  23.200  1.00 30.80           C  
ATOM   1055  CD2 TYR A 140      41.506  32.778  22.588  1.00 29.85           C  
ATOM   1056  CE1 TYR A 140      44.140  33.655  22.871  1.00 33.06           C  
ATOM   1057  CE2 TYR A 140      41.837  34.097  22.270  1.00 31.86           C  
ATOM   1058  CZ  TYR A 140      43.157  34.534  22.408  1.00 32.48           C  
ATOM   1059  OH  TYR A 140      43.479  35.853  22.093  1.00 32.64           O  
ATOM   1060  N   ASN A 141      40.250  32.094  25.707  1.00 27.07           N  
ATOM   1061  CA  ASN A 141      39.061  32.963  25.761  1.00 28.56           C  
ATOM   1062  C   ASN A 141      39.471  34.430  25.518  1.00 28.80           C  
ATOM   1063  O   ASN A 141      40.621  34.819  25.764  1.00 27.83           O  
ATOM   1064  CB  ASN A 141      38.325  32.861  27.117  1.00 29.04           C  
ATOM   1065  CG  ASN A 141      37.396  31.626  27.234  1.00 33.42           C  
ATOM   1066  OD1 ASN A 141      37.416  30.697  26.405  1.00 38.77           O  
ATOM   1067  ND2 ASN A 141      36.575  31.622  28.277  1.00 36.53           N  
ATOM   1068  N   PHE A 142      38.532  35.247  25.061  1.00 29.40           N  
ATOM   1069  CA  PHE A 142      38.782  36.679  24.892  1.00 31.24           C  
ATOM   1070  C   PHE A 142      38.315  37.470  26.097  1.00 31.51           C  
ATOM   1071  O   PHE A 142      37.123  37.566  26.350  1.00 31.47           O  
ATOM   1072  CB  PHE A 142      38.056  37.209  23.669  1.00 31.52           C  
ATOM   1073  CG  PHE A 142      38.696  36.844  22.405  1.00 33.04           C  
ATOM   1074  CD1 PHE A 142      39.682  37.676  21.847  1.00 33.06           C  
ATOM   1075  CD2 PHE A 142      38.325  35.668  21.742  1.00 33.32           C  
ATOM   1076  CE1 PHE A 142      40.305  37.328  20.644  1.00 36.28           C  
ATOM   1077  CE2 PHE A 142      38.932  35.310  20.521  1.00 34.76           C  
ATOM   1078  CZ  PHE A 142      39.927  36.134  19.974  1.00 35.59           C  
ATOM   1079  N   GLU A 143      39.257  38.038  26.829  1.00 32.50           N  
ATOM   1080  CA  GLU A 143      38.934  38.834  28.003  1.00 34.56           C  
ATOM   1081  C   GLU A 143      38.846  40.294  27.609  1.00 34.73           C  
ATOM   1082  O   GLU A 143      39.710  40.808  26.876  1.00 34.37           O  
ATOM   1083  CB  GLU A 143      39.976  38.613  29.095  1.00 35.51           C  
ATOM   1084  CG  GLU A 143      39.834  37.252  29.772  1.00 41.04           C  
ATOM   1085  CD  GLU A 143      41.098  36.795  30.472  1.00 48.96           C  
ATOM   1086  OE1 GLU A 143      41.686  37.605  31.234  1.00 52.18           O  
ATOM   1087  OE2 GLU A 143      41.496  35.615  30.264  1.00 52.62           O  
ATOM   1088  N   THR A 144      37.773  40.943  28.052  1.00 34.50           N  
ATOM   1089  CA  THR A 144      37.549  42.368  27.808  1.00 34.90           C  
ATOM   1090  C   THR A 144      37.167  43.098  29.094  1.00 35.41           C  
ATOM   1091  O   THR A 144      36.532  42.535  30.002  1.00 34.19           O  
ATOM   1092  CB  THR A 144      36.451  42.640  26.733  1.00 34.99           C  
ATOM   1093  OG1 THR A 144      35.153  42.333  27.258  1.00 35.09           O  
ATOM   1094  CG2 THR A 144      36.684  41.816  25.470  1.00 36.00           C  
ATOM   1095  N   THR A 145      37.585  44.356  29.170  1.00 36.37           N  
ATOM   1096  CA  THR A 145      37.183  45.245  30.244  1.00 37.55           C  
ATOM   1097  C   THR A 145      36.629  46.510  29.616  1.00 37.85           C  
ATOM   1098  O   THR A 145      37.285  47.133  28.782  1.00 38.04           O  
ATOM   1099  CB  THR A 145      38.346  45.550  31.190  1.00 37.59           C  
ATOM   1100  OG1 THR A 145      38.694  44.356  31.901  1.00 39.20           O  
ATOM   1101  CG2 THR A 145      37.949  46.605  32.206  1.00 38.42           C  
ATOM   1102  N   LEU A 146      35.400  46.849  29.978  1.00 38.10           N  
ATOM   1103  CA  LEU A 146      34.757  48.059  29.495  1.00 38.63           C  
ATOM   1104  C   LEU A 146      34.552  48.979  30.682  1.00 38.55           C  
ATOM   1105  O   LEU A 146      33.903  48.598  31.660  1.00 37.50           O  
ATOM   1106  CB  LEU A 146      33.413  47.727  28.821  1.00 39.35           C  
ATOM   1107  CG  LEU A 146      32.350  48.809  28.552  1.00 41.40           C  
ATOM   1108  CD1 LEU A 146      31.601  48.526  27.238  1.00 43.82           C  
ATOM   1109  CD2 LEU A 146      31.352  48.981  29.731  1.00 43.18           C  
ATOM   1110  N   VAL A 147      35.113  50.183  30.592  1.00 38.42           N  
ATOM   1111  CA  VAL A 147      34.978  51.184  31.644  1.00 38.72           C  
ATOM   1112  C   VAL A 147      34.051  52.312  31.178  1.00 39.39           C  
ATOM   1113  O   VAL A 147      34.350  53.007  30.189  1.00 39.60           O  
ATOM   1114  CB  VAL A 147      36.358  51.747  32.057  1.00 38.64           C  
ATOM   1115  CG1 VAL A 147      36.206  52.885  33.065  1.00 38.71           C  
ATOM   1116  CG2 VAL A 147      37.241  50.641  32.625  1.00 38.29           C  
ATOM   1117  N   ALA A 148      32.918  52.468  31.861  1.00 39.66           N  
ATOM   1118  CA  ALA A 148      32.003  53.587  31.594  1.00 40.76           C  
ATOM   1119  C   ALA A 148      32.683  54.887  32.009  1.00 41.26           C  
ATOM   1120  O   ALA A 148      33.465  54.900  32.963  1.00 41.52           O  
ATOM   1121  CB  ALA A 148      30.704  53.415  32.359  1.00 40.45           C  
ATOM   1122  N   ARG A 149      32.410  55.976  31.302  1.00 41.83           N  
ATOM   1123  CA  ARG A 149      33.021  57.255  31.676  1.00 42.72           C  
ATOM   1124  C   ARG A 149      32.121  58.100  32.567  1.00 42.50           C  
ATOM   1125  O   ARG A 149      30.938  57.803  32.713  1.00 42.60           O  
ATOM   1126  CB  ARG A 149      33.450  58.041  30.444  1.00 43.24           C  
ATOM   1127  CG  ARG A 149      32.402  58.124  29.367  1.00 44.75           C  
ATOM   1128  CD  ARG A 149      32.913  58.983  28.235  1.00 47.36           C  
ATOM   1129  NE  ARG A 149      32.545  58.437  26.933  1.00 48.55           N  
ATOM   1130  CZ  ARG A 149      33.227  58.669  25.818  1.00 50.18           C  
ATOM   1131  NH1 ARG A 149      34.323  59.422  25.848  1.00 49.66           N  
ATOM   1132  NH2 ARG A 149      32.819  58.137  24.674  1.00 51.92           N  
TER    1133      ARG A 149                                                      
END
MOLECULE T0455.pdb
ATOM    981  N   SER     7      55.366  26.966  20.854  1.00 66.80           N  
ATOM    982  CA  SER     7      55.702  26.695  19.421  1.00 66.93           C  
ATOM    983  CB  SER     7      56.100  25.225  19.176  1.00 67.14           C  
ATOM    984  OG  SER     7      57.045  25.126  18.105  1.00 67.50           O  
ATOM    985  C   SER     7      54.546  27.029  18.496  1.00 67.22           C  
ATOM    986  O   SER     7      53.366  27.033  18.892  1.00 67.58           O  
ATOM    987  N   SER     8      54.906  27.266  17.235  1.00 67.10           N  
ATOM    988  CA  SER     8      53.963  27.599  16.177  1.00 66.00           C  
ATOM    989  CB  SER     8      53.890  29.128  16.007  1.00 66.59           C  
ATOM    990  OG  SER     8      53.375  29.536  14.732  1.00 67.49           O  
ATOM    991  C   SER     8      54.435  26.946  14.895  1.00 65.24           C  
ATOM    992  O   SER     8      55.612  26.779  14.693  1.00 65.20           O  
ATOM    993  N   ARG     9      53.508  26.618  14.012  1.00 64.59           N  
ATOM    994  CA  ARG     9      53.810  25.902  12.777  1.00 63.46           C  
ATOM    995  CB  ARG     9      53.323  24.452  12.955  1.00 63.59           C  
ATOM    996  CG  ARG     9      53.608  23.502  11.797  1.00 64.77           C  
ATOM    997  CD  ARG     9      52.566  22.383  11.682  1.00 66.10           C  
ATOM    998  NE  ARG     9      52.289  22.125  10.265  1.00 69.18           N  
ATOM    999  CZ  ARG     9      51.219  21.496   9.777  1.00 70.75           C  
ATOM   1000  NH1 ARG     9      50.269  21.019  10.575  1.00 72.26           N  
ATOM   1001  NH2 ARG     9      51.092  21.339   8.461  1.00 71.12           N  
ATOM   1002  C   ARG     9      53.114  26.578  11.573  1.00 61.94           C  
ATOM   1003  O   ARG     9      51.876  26.647  11.512  1.00 62.08           O  
ATOM   1004  N   THR    10      53.888  27.073  10.614  1.00 60.07           N  
ATOM   1005  CA  THR    10      53.296  27.593   9.384  1.00 58.73           C  
ATOM   1006  CB  THR    10      54.264  28.455   8.588  1.00 58.55           C  
ATOM   1007  OG1 THR    10      54.907  29.383   9.450  1.00 58.12           O  
ATOM   1008  CG2 THR    10      53.523  29.236   7.573  1.00 59.32           C  
ATOM   1009  C   THR    10      52.835  26.470   8.477  1.00 57.08           C  
ATOM   1010  O   THR    10      53.626  25.822   7.873  1.00 57.73           O  
ATOM   1011  N   VAL    11      51.540  26.266   8.388  1.00 55.72           N  
ATOM   1012  CA  VAL    11      50.919  25.326   7.461  1.00 54.80           C  
ATOM   1013  CB  VAL    11      49.451  25.178   7.858  1.00 54.58           C  
ATOM   1014  CG1 VAL    11      48.606  24.505   6.741  1.00 53.03           C  
ATOM   1015  CG2 VAL    11      49.372  24.461   9.181  1.00 55.59           C  
ATOM   1016  C   VAL    11      50.944  25.731   5.966  1.00 54.04           C  
ATOM   1017  O   VAL    11      50.990  24.876   5.094  1.00 54.13           O  
ATOM   1018  N   SER    12      50.805  27.015   5.655  1.00 52.92           N  
ATOM   1019  CA  SER    12      51.032  27.471   4.287  1.00 51.89           C  
ATOM   1020  CB  SER    12      49.826  27.206   3.405  1.00 51.67           C  
ATOM   1021  OG  SER    12      48.768  27.971   3.862  1.00 52.50           O  
ATOM   1022  C   SER    12      51.419  28.946   4.220  1.00 49.85           C  
ATOM   1023  O   SER    12      51.261  29.690   5.178  1.00 48.66           O  
ATOM   1024  N   TYR    13      51.929  29.353   3.068  1.00 47.92           N  
ATOM   1025  CA  TYR    13      52.545  30.644   2.962  1.00 47.09           C  
ATOM   1026  CB  TYR    13      53.859  30.625   3.746  1.00 47.17           C  
ATOM   1027  CG  TYR    13      54.529  31.952   3.919  1.00 46.90           C  
ATOM   1028  CD1 TYR    13      54.225  32.765   4.984  1.00 46.52           C  
ATOM   1029  CE1 TYR    13      54.846  33.984   5.160  1.00 46.47           C  
ATOM   1030  CZ  TYR    13      55.790  34.394   4.276  1.00 47.95           C  
ATOM   1031  OH  TYR    13      56.430  35.596   4.451  1.00 48.26           O  
ATOM   1032  CE2 TYR    13      56.117  33.596   3.211  1.00 48.07           C  
ATOM   1033  CD2 TYR    13      55.473  32.383   3.040  1.00 46.54           C  
ATOM   1034  C   TYR    13      52.797  30.938   1.493  1.00 46.32           C  
ATOM   1035  O   TYR    13      53.632  30.328   0.871  1.00 46.29           O  
ATOM   1036  N   PHE    14      52.044  31.870   0.939  1.00 45.80           N  
ATOM   1037  CA  PHE    14      52.161  32.209  -0.459  1.00 45.02           C  
ATOM   1038  CB  PHE    14      51.686  31.051  -1.319  1.00 44.87           C  
ATOM   1039  CG  PHE    14      50.249  30.696  -1.134  1.00 44.59           C  
ATOM   1040  CD1 PHE    14      49.896  29.556  -0.461  1.00 44.02           C  
ATOM   1041  CE1 PHE    14      48.570  29.210  -0.313  1.00 45.96           C  
ATOM   1042  CZ  PHE    14      47.567  29.997  -0.874  1.00 44.63           C  
ATOM   1043  CE2 PHE    14      47.905  31.136  -1.549  1.00 44.54           C  
ATOM   1044  CD2 PHE    14      49.241  31.479  -1.693  1.00 45.21           C  
ATOM   1045  C   PHE    14      51.395  33.464  -0.837  1.00 44.29           C  
ATOM   1046  O   PHE    14      50.458  33.895  -0.143  1.00 44.89           O  
ATOM   1047  N   VAL    15      51.772  33.998  -1.982  1.00 43.49           N  
ATOM   1048  CA  VAL    15      51.210  35.211  -2.498  1.00 43.41           C  
ATOM   1049  CB  VAL    15      52.299  35.963  -3.246  1.00 43.05           C  
ATOM   1050  CG1 VAL    15      51.764  37.141  -3.945  1.00 42.02           C  
ATOM   1051  CG2 VAL    15      53.372  36.367  -2.278  1.00 42.40           C  
ATOM   1052  C   VAL    15      50.034  34.908  -3.419  1.00 43.85           C  
ATOM   1053  O   VAL    15      50.064  33.992  -4.228  1.00 44.16           O  
ATOM   1054  N   ALA    16      48.981  35.689  -3.297  1.00 44.56           N  
ATOM   1055  CA  ALA    16      47.768  35.460  -4.066  1.00 44.69           C  
ATOM   1056  CB  ALA    16      46.796  34.653  -3.280  1.00 43.79           C  
ATOM   1057  C   ALA    16      47.157  36.787  -4.396  1.00 45.56           C  
ATOM   1058  O   ALA    16      47.487  37.798  -3.788  1.00 46.06           O  
ATOM   1059  N   LYS    17      46.293  36.797  -5.392  1.00 46.31           N  
ATOM   1060  CA  LYS    17      45.523  37.984  -5.648  1.00 47.32           C  
ATOM   1061  CB  LYS    17      45.167  38.115  -7.151  1.00 47.08           C  
ATOM   1062  CG  LYS    17      46.452  38.029  -8.006  1.00 49.26           C  
ATOM   1063  CD  LYS    17      46.559  38.957  -9.180  1.00 49.63           C  
ATOM   1064  CE  LYS    17      45.585  38.494 -10.345  1.00 54.44           C  
ATOM   1065  NZ  LYS    17      46.079  38.686 -11.787  1.00 50.61           N  
ATOM   1066  C   LYS    17      44.361  37.841  -4.679  1.00 47.08           C  
ATOM   1067  O   LYS    17      43.964  36.750  -4.340  1.00 47.55           O  
ATOM   1068  N   PRO    18      43.857  38.939  -4.170  1.00 47.03           N  
ATOM   1069  CA  PRO    18      42.953  38.814  -3.060  1.00 47.50           C  
ATOM   1070  CB  PRO    18      42.848  40.259  -2.554  1.00 47.75           C  
ATOM   1071  CG  PRO    18      43.077  41.081  -3.791  1.00 47.83           C  
ATOM   1072  CD  PRO    18      44.073  40.330  -4.580  1.00 47.03           C  
ATOM   1073  C   PRO    18      41.580  38.326  -3.460  1.00 47.37           C  
ATOM   1074  O   PRO    18      41.135  38.614  -4.549  1.00 47.23           O  
ATOM   1075  N   SER    19      40.911  37.632  -2.551  1.00 47.79           N  
ATOM   1076  CA  SER    19      39.484  37.325  -2.670  1.00 48.25           C  
ATOM   1077  CB  SER    19      39.150  36.281  -1.617  1.00 47.61           C  
ATOM   1078  OG  SER    19      39.108  36.882  -0.326  1.00 49.49           O  
ATOM   1079  C   SER    19      38.607  38.592  -2.423  1.00 48.80           C  
ATOM   1080  O   SER    19      39.106  39.650  -2.010  1.00 48.76           O  
ATOM   1081  N   SER    20      37.301  38.484  -2.623  1.00 48.97           N  
ATOM   1082  CA  SER    20      36.422  39.623  -2.332  1.00 49.63           C  
ATOM   1083  CB  SER    20      34.972  39.229  -2.590  1.00 49.72           C  
ATOM   1084  OG  SER    20      34.907  38.531  -3.822  1.00 53.35           O  
ATOM   1085  C   SER    20      36.522  40.148  -0.900  1.00 49.91           C  
ATOM   1086  O   SER    20      36.648  41.363  -0.654  1.00 49.90           O  
ATOM   1087  N   SER    21      36.417  39.246   0.064  1.00 49.95           N  
ATOM   1088  CA  SER    21      36.420  39.712   1.429  1.00 49.61           C  
ATOM   1089  CB  SER    21      36.018  38.615   2.413  1.00 49.01           C  
ATOM   1090  OG  SER    21      37.102  37.851   2.775  1.00 49.97           O  
ATOM   1091  C   SER    21      37.807  40.311   1.701  1.00 49.66           C  
ATOM   1092  O   SER    21      37.934  41.296   2.430  1.00 49.35           O  
ATOM   1093  N   GLU    22      38.837  39.762   1.064  1.00 49.14           N  
ATOM   1094  CA  GLU    22      40.149  40.301   1.291  1.00 49.16           C  
ATOM   1095  CB  GLU    22      41.231  39.338   0.789  1.00 49.18           C  
ATOM   1096  CG  GLU    22      41.352  38.099   1.671  1.00 48.36           C  
ATOM   1097  CD  GLU    22      42.337  37.057   1.151  1.00 47.87           C  
ATOM   1098  OE1 GLU    22      42.607  37.030  -0.058  1.00 48.49           O  
ATOM   1099  OE2 GLU    22      42.841  36.256   1.961  1.00 43.16           O  
ATOM   1100  C   GLU    22      40.246  41.692   0.668  1.00 49.40           C  
ATOM   1101  O   GLU    22      40.855  42.576   1.232  1.00 49.08           O  
ATOM   1102  N   MET    23      39.637  41.897  -0.493  1.00 50.38           N  
ATOM   1103  CA  MET    23      39.667  43.215  -1.147  1.00 50.41           C  
ATOM   1104  CB  MET    23      38.957  43.155  -2.491  1.00 50.70           C  
ATOM   1105  CG  MET    23      39.736  42.378  -3.537  1.00 51.45           C  
ATOM   1106  SD  MET    23      38.879  42.251  -5.118  1.00 48.27           S  
ATOM   1107  CE  MET    23      38.583  44.004  -5.360  1.00 45.34           C  
ATOM   1108  C   MET    23      38.973  44.241  -0.259  1.00 51.76           C  
ATOM   1109  O   MET    23      39.481  45.323   0.001  1.00 51.94           O  
ATOM   1110  N   GLU    24      37.806  43.860   0.215  1.00 53.13           N  
ATOM   1111  CA  GLU    24      36.978  44.722   1.005  1.00 53.62           C  
ATOM   1112  CB  GLU    24      35.644  43.973   1.229  1.00 54.72           C  
ATOM   1113  CG  GLU    24      34.450  44.799   1.705  1.00 56.70           C  
ATOM   1114  CD  GLU    24      33.999  44.474   3.115  1.00 64.20           C  
ATOM   1115  OE1 GLU    24      34.727  43.777   3.857  1.00 69.18           O  
ATOM   1116  OE2 GLU    24      32.894  44.923   3.487  1.00 70.36           O  
ATOM   1117  C   GLU    24      37.682  45.148   2.333  1.00 53.63           C  
ATOM   1118  O   GLU    24      37.833  46.347   2.595  1.00 53.82           O  
ATOM   1119  N   LYS    25      38.136  44.175   3.128  1.00 52.64           N  
ATOM   1120  CA  LYS    25      38.749  44.447   4.431  1.00 52.19           C  
ATOM   1121  CB  LYS    25      38.972  43.161   5.229  1.00 52.35           C  
ATOM   1122  CG  LYS    25      37.796  42.253   5.370  1.00 54.27           C  
ATOM   1123  CD  LYS    25      36.775  42.727   6.383  1.00 54.98           C  
ATOM   1124  CE  LYS    25      35.645  41.721   6.435  1.00 55.23           C  
ATOM   1125  NZ  LYS    25      34.500  42.241   7.228  1.00 58.74           N  
ATOM   1126  C   LYS    25      40.126  45.101   4.337  1.00 51.74           C  
ATOM   1127  O   LYS    25      40.522  45.839   5.221  1.00 51.11           O  
ATOM   1128  N   LEU    26      40.904  44.760   3.317  1.00 51.27           N  
ATOM   1129  CA  LEU    26      42.245  45.312   3.206  1.00 50.74           C  
ATOM   1130  CB  LEU    26      43.233  44.246   2.740  1.00 50.18           C  
ATOM   1131  CG  LEU    26      43.618  43.149   3.733  1.00 47.96           C  
ATOM   1132  CD1 LEU    26      44.658  42.174   3.109  1.00 46.25           C  
ATOM   1133  CD2 LEU    26      44.156  43.767   5.006  1.00 42.03           C  
ATOM   1134  C   LEU    26      42.221  46.502   2.257  1.00 50.78           C  
ATOM   1135  O   LEU    26      43.232  47.183   2.078  1.00 50.95           O  
ATOM   1136  N   GLN    27      41.046  46.741   1.674  1.00 50.93           N  
ATOM   1137  CA  GLN    27      40.790  47.883   0.818  1.00 51.30           C  
ATOM   1138  CB  GLN    27      40.880  49.193   1.589  1.00 51.58           C  
ATOM   1139  CG  GLN    27      39.651  49.523   2.408  1.00 51.59           C  
ATOM   1140  CD  GLN    27      40.005  50.504   3.513  1.00 52.59           C  
ATOM   1141  OE1 GLN    27      40.855  51.376   3.301  1.00 57.18           O  
ATOM   1142  NE2 GLN    27      39.395  50.352   4.705  1.00 47.63           N  
ATOM   1143  C   GLN    27      41.784  47.854  -0.288  1.00 51.13           C  
ATOM   1144  O   GLN    27      42.718  48.634  -0.303  1.00 51.14           O  
ATOM   1145  N   LEU    28      41.581  46.907  -1.186  1.00 51.34           N  
ATOM   1146  CA  LEU    28      42.533  46.602  -2.222  1.00 51.53           C  
ATOM   1147  CB  LEU    28      43.388  45.390  -1.844  1.00 51.82           C  
ATOM   1148  CG  LEU    28      44.417  45.402  -0.707  1.00 52.24           C  
ATOM   1149  CD1 LEU    28      44.895  43.970  -0.469  1.00 53.58           C  
ATOM   1150  CD2 LEU    28      45.608  46.284  -1.015  1.00 51.65           C  
ATOM   1151  C   LEU    28      41.735  46.233  -3.430  1.00 51.61           C  
ATOM   1152  O   LEU    28      40.639  45.693  -3.341  1.00 51.58           O  
ATOM   1153  N   GLY    29      42.294  46.528  -4.580  1.00 52.42           N  
ATOM   1154  CA  GLY    29      41.641  46.189  -5.819  1.00 52.85           C  
ATOM   1155  C   GLY    29      41.988  44.757  -6.143  1.00 53.36           C  
ATOM   1156  O   GLY    29      42.916  44.153  -5.531  1.00 53.17           O  
ATOM   1157  N   PRO    30      41.295  44.205  -7.145  1.00 53.25           N  
ATOM   1158  CA  PRO    30      41.705  42.884  -7.543  1.00 53.02           C  
ATOM   1159  CB  PRO    30      40.734  42.547  -8.672  1.00 53.13           C  
ATOM   1160  CG  PRO    30      40.410  43.900  -9.290  1.00 52.75           C  
ATOM   1161  CD  PRO    30      40.292  44.775  -8.062  1.00 53.59           C  
ATOM   1162  C   PRO    30      43.078  43.193  -8.077  1.00 53.01           C  
ATOM   1163  O   PRO    30      43.350  44.381  -8.383  1.00 54.66           O  
ATOM   1164  N   GLU    31      43.956  42.223  -8.183  1.00 51.87           N  
ATOM   1165  CA  GLU    31      45.290  42.538  -8.729  1.00 51.91           C  
ATOM   1166  CB  GLU    31      45.234  43.438 -10.001  1.00 52.64           C  
ATOM   1167  CG  GLU    31      44.212  43.010 -11.088  1.00 54.99           C  
ATOM   1168  CD  GLU    31      44.468  41.589 -11.570  1.00 58.60           C  
ATOM   1169  OE1 GLU    31      45.587  41.387 -12.100  1.00 61.18           O  
ATOM   1170  OE2 GLU    31      43.590  40.688 -11.375  1.00 58.99           O  
ATOM   1171  C   GLU    31      46.291  43.147  -7.767  1.00 50.56           C  
ATOM   1172  O   GLU    31      47.457  43.132  -8.085  1.00 49.87           O  
ATOM   1173  N   ASP    32      45.879  43.688  -6.623  1.00 50.08           N  
ATOM   1174  CA  ASP    32      46.867  43.943  -5.552  1.00 49.96           C  
ATOM   1175  CB  ASP    32      46.415  44.986  -4.524  1.00 50.42           C  
ATOM   1176  CG  ASP    32      46.106  46.339  -5.137  1.00 52.23           C  
ATOM   1177  OD1 ASP    32      46.755  46.714  -6.137  1.00 49.25           O  
ATOM   1178  OD2 ASP    32      45.206  47.039  -4.583  1.00 56.11           O  
ATOM   1179  C   ASP    32      47.161  42.637  -4.810  1.00 49.17           C  
ATOM   1180  O   ASP    32      46.325  42.121  -4.090  1.00 49.32           O  
ATOM   1181  N   SER    33      48.361  42.112  -4.964  1.00 48.16           N  
ATOM   1182  CA  SER    33      48.732  40.910  -4.255  1.00 47.49           C  
ATOM   1183  CB  SER    33      50.137  40.523  -4.637  1.00 47.56           C  
ATOM   1184  OG  SER    33      50.154  40.261  -6.019  1.00 49.46           O  
ATOM   1185  C   SER    33      48.689  41.097  -2.767  1.00 46.69           C  
ATOM   1186  O   SER    33      48.962  42.183  -2.251  1.00 46.07           O  
ATOM   1187  N   ILE    34      48.380  39.995  -2.095  1.00 46.52           N  
ATOM   1188  CA  ILE    34      48.427  39.862  -0.650  1.00 45.49           C  
ATOM   1189  CB  ILE    34      47.045  39.603  -0.080  1.00 45.17           C  
ATOM   1190  CG1 ILE    34      46.457  38.309  -0.690  1.00 45.25           C  
ATOM   1191  CD1 ILE    34      45.695  37.367   0.276  1.00 44.50           C  
ATOM   1192  CG2 ILE    34      46.135  40.804  -0.339  1.00 42.34           C  
ATOM   1193  C   ILE    34      49.311  38.652  -0.340  1.00 45.62           C  
ATOM   1194  O   ILE    34      49.522  37.788  -1.180  1.00 45.44           O  
ATOM   1195  N   LEU    35      49.863  38.626   0.861  1.00 46.28           N  
ATOM   1196  CA  LEU    35      50.570  37.472   1.381  1.00 46.29           C  
ATOM   1197  CB  LEU    35      51.739  37.900   2.258  1.00 46.24           C  
ATOM   1198  CG  LEU    35      52.555  36.739   2.818  1.00 46.30           C  
ATOM   1199  CD1 LEU    35      53.202  35.964   1.632  1.00 43.82           C  
ATOM   1200  CD2 LEU    35      53.613  37.223   3.811  1.00 45.71           C  
ATOM   1201  C   LEU    35      49.570  36.734   2.224  1.00 46.83           C  
ATOM   1202  O   LEU    35      48.918  37.323   3.061  1.00 46.30           O  
ATOM   1203  N   ARG    36      49.422  35.449   1.998  1.00 47.99           N  
ATOM   1204  CA  ARG    36      48.435  34.723   2.731  1.00 49.43           C  
ATOM   1205  CB  ARG    36      47.475  34.086   1.784  1.00 50.62           C  
ATOM   1206  CG  ARG    36      46.181  33.772   2.453  1.00 53.89           C  
ATOM   1207  CD  ARG    36      45.692  32.395   2.149  1.00 59.18           C  
ATOM   1208  NE  ARG    36      44.273  32.418   2.300  1.00 60.92           N  
ATOM   1209  CZ  ARG    36      43.443  32.961   1.416  1.00 66.27           C  
ATOM   1210  NH1 ARG    36      43.904  33.493   0.245  1.00 67.71           N  
ATOM   1211  NH2 ARG    36      42.123  32.947   1.696  1.00 67.71           N  
ATOM   1212  C   ARG    36      49.139  33.650   3.441  1.00 49.82           C  
ATOM   1213  O   ARG    36      49.901  32.904   2.825  1.00 50.82           O  
ATOM   1214  N   MET    37      48.945  33.594   4.741  1.00 50.15           N  
ATOM   1215  CA  MET    37      49.644  32.619   5.577  1.00 50.53           C  
ATOM   1216  CB  MET    37      50.901  33.205   6.204  1.00 50.08           C  
ATOM   1217  CG  MET    37      50.757  34.217   7.314  1.00 51.20           C  
ATOM   1218  SD  MET    37      52.335  34.422   8.203  1.00 51.62           S  
ATOM   1219  CE  MET    37      52.342  32.968   9.266  1.00 49.85           C  
ATOM   1220  C   MET    37      48.714  32.010   6.607  1.00 50.57           C  
ATOM   1221  O   MET    37      47.775  32.655   7.100  1.00 49.67           O  
ATOM   1222  N   GLU    38      48.921  30.720   6.826  1.00 51.66           N  
ATOM   1223  CA  GLU    38      48.084  29.905   7.695  1.00 52.46           C  
ATOM   1224  CB  GLU    38      47.480  28.763   6.923  1.00 52.43           C  
ATOM   1225  CG  GLU    38      46.339  29.190   6.094  1.00 54.18           C  
ATOM   1226  CD  GLU    38      45.824  28.125   5.183  1.00 54.07           C  
ATOM   1227  OE1 GLU    38      46.293  26.963   5.227  1.00 55.92           O  
ATOM   1228  OE2 GLU    38      44.944  28.487   4.405  1.00 57.93           O  
ATOM   1229  C   GLU    38      48.987  29.308   8.722  1.00 53.53           C  
ATOM   1230  O   GLU    38      50.086  28.872   8.378  1.00 53.65           O  
ATOM   1231  N   ARG    39      48.515  29.216   9.952  1.00 54.36           N  
ATOM   1232  CA  ARG    39      49.404  28.937  11.052  1.00 56.22           C  
ATOM   1233  CB  ARG    39      49.977  30.287  11.452  1.00 56.60           C  
ATOM   1234  CG  ARG    39      50.997  30.297  12.521  1.00 59.42           C  
ATOM   1235  CD  ARG    39      50.693  31.391  13.599  1.00 61.15           C  
ATOM   1236  NE  ARG    39      50.895  32.768  13.118  1.00 64.98           N  
ATOM   1237  CZ  ARG    39      52.083  33.380  13.027  1.00 66.66           C  
ATOM   1238  NH1 ARG    39      53.217  32.762  13.369  1.00 63.65           N  
ATOM   1239  NH2 ARG    39      52.126  34.633  12.574  1.00 68.83           N  
ATOM   1240  C   ARG    39      48.649  28.274  12.212  1.00 55.31           C  
ATOM   1241  O   ARG    39      47.551  28.682  12.530  1.00 54.64           O  
ATOM   1242  N   ILE    40      49.226  27.219  12.786  1.00 55.53           N  
ATOM   1243  CA  ILE    40      48.746  26.595  14.045  1.00 55.67           C  
ATOM   1244  CB  ILE    40      48.675  25.052  13.921  1.00 55.53           C  
ATOM   1245  CG1 ILE    40      47.965  24.654  12.623  1.00 54.13           C  
ATOM   1246  CD1 ILE    40      47.875  23.195  12.381  1.00 53.68           C  
ATOM   1247  CG2 ILE    40      47.958  24.475  15.094  1.00 55.36           C  
ATOM   1248  C   ILE    40      49.695  26.964  15.203  1.00 55.60           C  
ATOM   1249  O   ILE    40      50.895  26.924  15.042  1.00 54.08           O  
ATOM   1250  N   ARG    41      49.137  27.350  16.345  1.00 57.05           N  
ATOM   1251  CA  ARG    41      49.902  27.583  17.594  1.00 58.60           C  
ATOM   1252  CB  ARG    41      49.682  28.995  18.158  1.00 58.57           C  
ATOM   1253  CG  ARG    41      49.935  30.085  17.095  1.00 61.65           C  
ATOM   1254  CD  ARG    41      49.835  31.558  17.607  1.00 62.04           C  
ATOM   1255  NE  ARG    41      51.139  31.967  18.140  1.00 66.00           N  
ATOM   1256  CZ  ARG    41      52.079  32.689  17.509  1.00 65.44           C  
ATOM   1257  NH1 ARG    41      51.896  33.213  16.287  1.00 64.96           N  
ATOM   1258  NH2 ARG    41      53.225  32.903  18.140  1.00 64.12           N  
ATOM   1259  C   ARG    41      49.502  26.565  18.644  1.00 58.53           C  
ATOM   1260  O   ARG    41      48.354  26.119  18.710  1.00 57.81           O  
ATOM   1261  N   PHE    42      50.486  26.228  19.466  1.00 59.74           N  
ATOM   1262  CA  PHE    42      50.416  25.142  20.452  1.00 60.45           C  
ATOM   1263  CB  PHE    42      51.484  24.072  20.118  1.00 60.37           C  
ATOM   1264  CG  PHE    42      51.318  23.453  18.750  1.00 60.19           C  
ATOM   1265  CD1 PHE    42      50.522  22.328  18.572  1.00 59.24           C  
ATOM   1266  CE1 PHE    42      50.346  21.767  17.321  1.00 59.71           C  
ATOM   1267  CZ  PHE    42      50.955  22.334  16.225  1.00 60.00           C  
ATOM   1268  CE2 PHE    42      51.753  23.466  16.386  1.00 60.33           C  
ATOM   1269  CD2 PHE    42      51.922  24.022  17.642  1.00 59.82           C  
ATOM   1270  C   PHE    42      50.722  25.709  21.819  1.00 60.81           C  
ATOM   1271  O   PHE    42      51.513  26.615  21.918  1.00 61.17           O  
ATOM   1272  N   ALA    43      50.076  25.194  22.859  1.00 61.79           N  
ATOM   1273  CA  ALA    43      50.533  25.351  24.245  1.00 62.22           C  
ATOM   1274  CB  ALA    43      49.509  26.094  25.129  1.00 61.58           C  
ATOM   1275  C   ALA    43      50.758  23.928  24.748  1.00 63.17           C  
ATOM   1276  O   ALA    43      49.905  23.034  24.556  1.00 63.19           O  
ATOM   1277  N   ASP    44      51.929  23.708  25.352  1.00 64.51           N  
ATOM   1278  CA  ASP    44      52.263  22.424  25.966  1.00 65.05           C  
ATOM   1279  CB  ASP    44      51.429  22.217  27.260  1.00 65.69           C  
ATOM   1280  CG  ASP    44      51.511  23.438  28.251  1.00 68.14           C  
ATOM   1281  OD1 ASP    44      52.666  23.772  28.637  1.00 71.73           O  
ATOM   1282  OD2 ASP    44      50.454  24.041  28.650  1.00 65.35           O  
ATOM   1283  C   ASP    44      51.977  21.358  24.900  1.00 65.21           C  
ATOM   1284  O   ASP    44      51.302  20.369  25.138  1.00 65.63           O  
ATOM   1285  N   ASP    45      52.449  21.627  23.694  1.00 65.40           N  
ATOM   1286  CA  ASP    45      52.261  20.737  22.540  1.00 65.59           C  
ATOM   1287  CB  ASP    45      53.142  19.503  22.669  1.00 66.51           C  
ATOM   1288  CG  ASP    45      54.378  19.605  21.773  1.00 71.38           C  
ATOM   1289  OD1 ASP    45      54.209  19.760  20.505  1.00 73.77           O  
ATOM   1290  OD2 ASP    45      55.511  19.566  22.353  1.00 76.92           O  
ATOM   1291  C   ASP    45      50.848  20.347  22.117  1.00 64.70           C  
ATOM   1292  O   ASP    45      50.673  19.473  21.255  1.00 64.29           O  
ATOM   1293  N   ILE    46      49.848  21.020  22.664  1.00 63.93           N  
ATOM   1294  CA  ILE    46      48.496  20.839  22.182  1.00 63.43           C  
ATOM   1295  CB  ILE    46      47.525  20.595  23.334  1.00 64.04           C  
ATOM   1296  CG1 ILE    46      48.179  19.651  24.391  1.00 64.30           C  
ATOM   1297  CD1 ILE    46      47.297  19.342  25.647  1.00 63.49           C  
ATOM   1298  CG2 ILE    46      46.167  20.104  22.784  1.00 63.48           C  
ATOM   1299  C   ILE    46      48.136  22.107  21.393  1.00 62.78           C  
ATOM   1300  O   ILE    46      48.405  23.229  21.845  1.00 62.44           O  
ATOM   1301  N   PRO    47      47.580  21.933  20.184  1.00 61.67           N  
ATOM   1302  CA  PRO    47      47.195  23.086  19.385  1.00 60.96           C  
ATOM   1303  CB  PRO    47      46.713  22.483  18.055  1.00 61.01           C  
ATOM   1304  CG  PRO    47      46.628  21.050  18.240  1.00 61.37           C  
ATOM   1305  CD  PRO    47      47.323  20.654  19.501  1.00 61.75           C  
ATOM   1306  C   PRO    47      46.063  23.861  20.027  1.00 59.95           C  
ATOM   1307  O   PRO    47      45.058  23.291  20.339  1.00 59.15           O  
ATOM   1308  N   ILE    48      46.241  25.166  20.179  1.00 59.29           N  
ATOM   1309  CA  ILE    48      45.215  26.050  20.695  1.00 58.54           C  
ATOM   1310  CB  ILE    48      45.834  27.215  21.489  1.00 58.42           C  
ATOM   1311  CG1 ILE    48      46.815  26.706  22.555  1.00 58.99           C  
ATOM   1312  CD1 ILE    48      46.200  25.695  23.593  1.00 58.08           C  
ATOM   1313  CG2 ILE    48      44.766  27.983  22.197  1.00 58.78           C  
ATOM   1314  C   ILE    48      44.408  26.645  19.542  1.00 58.31           C  
ATOM   1315  O   ILE    48      43.220  26.871  19.676  1.00 58.87           O  
ATOM   1316  N   CYS    49      45.035  26.913  18.403  1.00 57.41           N  
ATOM   1317  CA  CYS    49      44.395  27.763  17.414  1.00 56.65           C  
ATOM   1318  CB  CYS    49      44.422  29.212  17.923  1.00 56.74           C  
ATOM   1319  SG  CYS    49      46.012  30.016  17.879  1.00 59.53           S  
ATOM   1320  C   CYS    49      44.972  27.692  16.008  1.00 55.55           C  
ATOM   1321  O   CYS    49      46.112  27.347  15.771  1.00 55.76           O  
ATOM   1322  N   PHE    50      44.135  28.022  15.060  1.00 55.34           N  
ATOM   1323  CA  PHE    50      44.505  28.073  13.647  1.00 54.60           C  
ATOM   1324  CB  PHE    50      43.685  27.060  12.884  1.00 54.13           C  
ATOM   1325  CG  PHE    50      43.909  27.094  11.427  1.00 54.23           C  
ATOM   1326  CD1 PHE    50      44.902  26.337  10.862  1.00 54.72           C  
ATOM   1327  CE1 PHE    50      45.121  26.346   9.521  1.00 54.50           C  
ATOM   1328  CZ  PHE    50      44.354  27.121   8.737  1.00 54.82           C  
ATOM   1329  CE2 PHE    50      43.354  27.888   9.289  1.00 54.91           C  
ATOM   1330  CD2 PHE    50      43.124  27.865  10.617  1.00 54.51           C  
ATOM   1331  C   PHE    50      44.148  29.449  13.141  1.00 53.70           C  
ATOM   1332  O   PHE    50      43.010  29.926  13.330  1.00 54.12           O  
ATOM   1333  N   GLU    51      45.096  30.083  12.491  1.00 52.40           N  
ATOM   1334  CA  GLU    51      44.928  31.447  12.048  1.00 51.48           C  
ATOM   1335  CB  GLU    51      45.873  32.296  12.912  1.00 51.98           C  
ATOM   1336  CG  GLU    51      46.167  33.708  12.443  1.00 53.18           C  
ATOM   1337  CD  GLU    51      47.103  34.446  13.376  1.00 53.76           C  
ATOM   1338  OE1 GLU    51      46.623  34.789  14.522  1.00 60.44           O  
ATOM   1339  OE2 GLU    51      48.265  34.701  12.943  1.00 52.48           O  
ATOM   1340  C   GLU    51      45.243  31.598  10.555  1.00 49.93           C  
ATOM   1341  O   GLU    51      46.285  31.182  10.099  1.00 49.47           O  
ATOM   1342  N   VAL    52      44.350  32.218   9.813  1.00 49.02           N  
ATOM   1343  CA  VAL    52      44.660  32.667   8.461  1.00 48.32           C  
ATOM   1344  CB  VAL    52      43.472  32.436   7.472  1.00 47.93           C  
ATOM   1345  CG1 VAL    52      43.903  32.727   6.051  1.00 45.34           C  
ATOM   1346  CG2 VAL    52      43.016  31.060   7.602  1.00 46.90           C  
ATOM   1347  C   VAL    52      44.949  34.163   8.515  1.00 47.65           C  
ATOM   1348  O   VAL    52      44.144  34.941   9.011  1.00 47.93           O  
ATOM   1349  N   ALA    53      46.062  34.576   7.950  1.00 46.88           N  
ATOM   1350  CA  ALA    53      46.359  35.982   7.920  1.00 46.27           C  
ATOM   1351  CB  ALA    53      47.501  36.285   8.853  1.00 45.46           C  
ATOM   1352  C   ALA    53      46.658  36.432   6.489  1.00 45.29           C  
ATOM   1353  O   ALA    53      47.380  35.772   5.750  1.00 44.22           O  
ATOM   1354  N   SER    54      46.079  37.565   6.116  1.00 44.82           N  
ATOM   1355  CA  SER    54      46.326  38.148   4.820  1.00 45.05           C  
ATOM   1356  CB  SER    54      45.056  38.124   3.966  1.00 44.62           C  
ATOM   1357  OG  SER    54      44.801  36.823   3.452  1.00 40.96           O  
ATOM   1358  C   SER    54      46.868  39.573   4.956  1.00 45.50           C  
ATOM   1359  O   SER    54      46.253  40.408   5.572  1.00 46.84           O  
ATOM   1360  N   ILE    55      48.026  39.830   4.361  1.00 45.69           N  
ATOM   1361  CA  ILE    55      48.713  41.115   4.446  1.00 45.44           C  
ATOM   1362  CB  ILE    55      50.081  40.929   5.130  1.00 45.08           C  
ATOM   1363  CG1 ILE    55      49.873  40.333   6.514  1.00 44.34           C  
ATOM   1364  CD1 ILE    55      50.869  39.335   6.890  1.00 41.72           C  
ATOM   1365  CG2 ILE    55      50.855  42.244   5.197  1.00 44.78           C  
ATOM   1366  C   ILE    55      48.934  41.617   3.005  1.00 45.44           C  
ATOM   1367  O   ILE    55      49.293  40.848   2.150  1.00 44.57           O  
ATOM   1368  N   PRO    56      48.680  42.901   2.741  1.00 45.76           N  
ATOM   1369  CA  PRO    56      48.947  43.456   1.436  1.00 45.64           C  
ATOM   1370  CB  PRO    56      48.760  44.949   1.663  1.00 45.38           C  
ATOM   1371  CG  PRO    56      47.764  45.019   2.733  1.00 45.95           C  
ATOM   1372  CD  PRO    56      48.086  43.898   3.651  1.00 46.48           C  
ATOM   1373  C   PRO    56      50.376  43.144   1.072  1.00 45.83           C  
ATOM   1374  O   PRO    56      51.246  43.367   1.911  1.00 46.46           O  
ATOM   1375  N   TYR    57      50.633  42.596  -0.121  1.00 45.25           N  
ATOM   1376  CA  TYR    57      51.982  42.139  -0.410  1.00 45.86           C  
ATOM   1377  CB  TYR    57      52.075  41.239  -1.665  1.00 45.64           C  
ATOM   1378  CG  TYR    57      53.440  40.587  -1.840  1.00 44.64           C  
ATOM   1379  CD1 TYR    57      54.035  39.961  -0.775  1.00 43.06           C  
ATOM   1380  CE1 TYR    57      55.278  39.361  -0.870  1.00 43.55           C  
ATOM   1381  CZ  TYR    57      55.953  39.361  -2.038  1.00 44.64           C  
ATOM   1382  OH  TYR    57      57.180  38.720  -1.982  1.00 46.48           O  
ATOM   1383  CE2 TYR    57      55.400  39.976  -3.168  1.00 42.99           C  
ATOM   1384  CD2 TYR    57      54.130  40.595  -3.060  1.00 43.09           C  
ATOM   1385  C   TYR    57      52.914  43.325  -0.549  1.00 46.06           C  
ATOM   1386  O   TYR    57      54.090  43.198  -0.314  1.00 45.53           O  
ATOM   1387  N   SER    58      52.403  44.481  -0.940  1.00 47.17           N  
ATOM   1388  CA  SER    58      53.289  45.604  -1.162  1.00 48.11           C  
ATOM   1389  CB  SER    58      52.546  46.736  -1.780  1.00 47.99           C  
ATOM   1390  OG  SER    58      51.825  47.338  -0.740  1.00 50.25           O  
ATOM   1391  C   SER    58      53.900  46.119   0.131  1.00 49.09           C  
ATOM   1392  O   SER    58      54.949  46.691   0.082  1.00 49.71           O  
ATOM   1393  N   LEU    59      53.270  45.934   1.286  1.00 49.94           N  
ATOM   1394  CA  LEU    59      53.893  46.390   2.543  1.00 50.63           C  
ATOM   1395  CB  LEU    59      52.878  46.506   3.702  1.00 50.50           C  
ATOM   1396  CG  LEU    59      51.624  47.344   3.445  1.00 50.78           C  
ATOM   1397  CD1 LEU    59      50.496  46.975   4.439  1.00 48.14           C  
ATOM   1398  CD2 LEU    59      51.974  48.833   3.445  1.00 50.51           C  
ATOM   1399  C   LEU    59      54.969  45.464   3.046  1.00 51.77           C  
ATOM   1400  O   LEU    59      55.605  45.756   4.081  1.00 53.56           O  
ATOM   1401  N   VAL    60      55.161  44.331   2.387  1.00 52.04           N  
ATOM   1402  CA  VAL    60      55.871  43.229   3.035  1.00 52.07           C  
ATOM   1403  CB  VAL    60      54.772  42.272   3.638  1.00 52.60           C  
ATOM   1404  CG1 VAL    60      54.716  40.941   2.924  1.00 52.85           C  
ATOM   1405  CG2 VAL    60      54.911  42.154   5.171  1.00 51.04           C  
ATOM   1406  C   VAL    60      56.917  42.553   2.137  1.00 52.27           C  
ATOM   1407  O   VAL    60      57.747  41.784   2.635  1.00 52.19           O  
ATOM   1408  N   SER    61      56.880  42.892   0.835  1.00 52.26           N  
ATOM   1409  CA  SER    61      57.800  42.433  -0.175  1.00 52.56           C  
ATOM   1410  CB  SER    61      57.927  43.452  -1.302  1.00 52.22           C  
ATOM   1411  OG  SER    61      56.762  43.568  -2.023  1.00 50.76           O  
ATOM   1412  C   SER    61      59.193  42.334   0.339  1.00 54.01           C  
ATOM   1413  O   SER    61      59.937  41.452  -0.087  1.00 54.95           O  
ATOM   1414  N   GLN    62      59.589  43.309   1.154  1.00 54.80           N  
ATOM   1415  CA  GLN    62      60.990  43.507   1.448  1.00 55.39           C  
ATOM   1416  CB  GLN    62      61.327  44.993   1.483  1.00 55.61           C  
ATOM   1417  CG  GLN    62      60.892  45.798   0.261  1.00 57.32           C  
ATOM   1418  CD  GLN    62      61.375  45.233  -1.113  1.00 61.44           C  
ATOM   1419  OE1 GLN    62      62.586  44.979  -1.345  1.00 61.49           O  
ATOM   1420  NE2 GLN    62      60.415  45.074  -2.042  1.00 61.82           N  
ATOM   1421  C   GLN    62      61.378  42.844   2.746  1.00 55.11           C  
ATOM   1422  O   GLN    62      62.528  42.769   3.067  1.00 54.97           O  
ATOM   1423  N   TYR    63      60.432  42.331   3.490  1.00 55.62           N  
ATOM   1424  CA  TYR    63      60.788  41.624   4.715  1.00 56.61           C  
ATOM   1425  CB  TYR    63      59.704  41.790   5.806  1.00 57.30           C  
ATOM   1426  CG  TYR    63      59.279  43.248   6.011  1.00 58.09           C  
ATOM   1427  CD1 TYR    63      58.064  43.574   6.572  1.00 58.04           C  
ATOM   1428  CE1 TYR    63      57.699  44.901   6.742  1.00 59.17           C  
ATOM   1429  CZ  TYR    63      58.554  45.907   6.331  1.00 58.62           C  
ATOM   1430  OH  TYR    63      58.228  47.233   6.437  1.00 59.12           O  
ATOM   1431  CE2 TYR    63      59.743  45.605   5.784  1.00 58.72           C  
ATOM   1432  CD2 TYR    63      60.106  44.298   5.624  1.00 59.54           C  
ATOM   1433  C   TYR    63      61.008  40.192   4.340  1.00 56.32           C  
ATOM   1434  O   TYR    63      60.675  39.808   3.253  1.00 57.28           O  
ATOM   1435  N   GLY    64      61.609  39.421   5.221  1.00 56.27           N  
ATOM   1436  CA  GLY    64      61.839  38.027   4.986  1.00 56.20           C  
ATOM   1437  C   GLY    64      60.908  37.261   5.882  1.00 56.70           C  
ATOM   1438  O   GLY    64      60.444  37.767   6.892  1.00 56.87           O  
ATOM   1439  N   LYS    65      60.680  36.015   5.500  1.00 57.08           N  
ATOM   1440  CA  LYS    65      59.663  35.138   6.061  1.00 57.01           C  
ATOM   1441  CB  LYS    65      59.891  33.722   5.532  1.00 56.96           C  
ATOM   1442  CG  LYS    65      58.959  32.645   6.047  1.00 57.71           C  
ATOM   1443  CD  LYS    65      58.839  31.492   5.053  1.00 57.88           C  
ATOM   1444  CE  LYS    65      57.800  30.458   5.485  1.00 59.30           C  
ATOM   1445  NZ  LYS    65      57.469  29.549   4.343  1.00 60.81           N  
ATOM   1446  C   LYS    65      59.632  35.111   7.583  1.00 57.12           C  
ATOM   1447  O   LYS    65      58.538  35.116   8.186  1.00 56.36           O  
ATOM   1448  N   SER    66      60.822  35.052   8.184  1.00 56.97           N  
ATOM   1449  CA  SER    66      60.971  34.940   9.647  1.00 56.91           C  
ATOM   1450  CB  SER    66      62.448  34.856   9.990  1.00 56.99           C  
ATOM   1451  OG  SER    66      63.180  35.553   8.973  1.00 59.35           O  
ATOM   1452  C   SER    66      60.403  36.153  10.330  1.00 56.41           C  
ATOM   1453  O   SER    66      59.679  36.019  11.317  1.00 56.18           O  
ATOM   1454  N   GLU    67      60.774  37.333   9.818  1.00 56.50           N  
ATOM   1455  CA  GLU    67      60.273  38.615  10.305  1.00 56.88           C  
ATOM   1456  CB  GLU    67      60.755  39.796   9.461  1.00 56.55           C  
ATOM   1457  CG  GLU    67      62.205  40.138   9.614  1.00 57.12           C  
ATOM   1458  CD  GLU    67      62.722  41.072   8.519  1.00 57.60           C  
ATOM   1459  OE1 GLU    67      62.497  40.779   7.334  1.00 58.04           O  
ATOM   1460  OE2 GLU    67      63.384  42.091   8.836  1.00 59.58           O  
ATOM   1461  C   GLU    67      58.781  38.567  10.225  1.00 57.09           C  
ATOM   1462  O   GLU    67      58.098  38.769  11.217  1.00 57.13           O  
ATOM   1463  N   ILE    68      58.269  38.266   9.037  1.00 57.54           N  
ATOM   1464  CA  ILE    68      56.814  38.234   8.856  1.00 58.10           C  
ATOM   1465  CB  ILE    68      56.393  37.953   7.410  1.00 57.62           C  
ATOM   1466  CG1 ILE    68      56.836  39.140   6.535  1.00 57.78           C  
ATOM   1467  CD1 ILE    68      56.783  38.930   5.025  1.00 57.61           C  
ATOM   1468  CG2 ILE    68      54.889  37.726   7.363  1.00 56.58           C  
ATOM   1469  C   ILE    68      56.138  37.257   9.778  1.00 58.31           C  
ATOM   1470  O   ILE    68      55.095  37.568  10.307  1.00 58.35           O  
ATOM   1471  N   THR    69      56.735  36.093   9.983  1.00 59.31           N  
ATOM   1472  CA  THR    69      56.082  35.034  10.738  1.00 60.56           C  
ATOM   1473  CB  THR    69      56.573  33.624  10.343  1.00 60.50           C  
ATOM   1474  OG1 THR    69      57.922  33.690   9.870  1.00 62.21           O  
ATOM   1475  CG2 THR    69      55.714  33.060   9.218  1.00 60.20           C  
ATOM   1476  C   THR    69      56.181  35.232  12.230  1.00 61.36           C  
ATOM   1477  O   THR    69      55.188  35.041  12.915  1.00 62.44           O  
ATOM   1478  N   ASN    70      57.330  35.675  12.734  1.00 62.34           N  
ATOM   1479  CA  ASN    70      57.538  35.792  14.196  1.00 62.99           C  
ATOM   1480  CB  ASN    70      58.825  35.062  14.641  1.00 63.60           C  
ATOM   1481  CG  ASN    70      59.089  33.775  13.853  1.00 65.59           C  
ATOM   1482  OD1 ASN    70      59.995  33.727  13.000  1.00 67.25           O  
ATOM   1483  ND2 ASN    70      58.278  32.741  14.108  1.00 66.68           N  
ATOM   1484  C   ASN    70      57.610  37.229  14.759  1.00 63.58           C  
ATOM   1485  O   ASN    70      57.522  37.413  15.964  1.00 64.54           O  
ATOM   1486  N   SER    71      57.793  38.243  13.926  1.00 63.29           N  
ATOM   1487  CA  SER    71      58.109  39.576  14.444  1.00 62.82           C  
ATOM   1488  CB  SER    71      59.602  39.841  14.229  1.00 63.27           C  
ATOM   1489  OG  SER    71      60.374  38.706  14.576  1.00 64.10           O  
ATOM   1490  C   SER    71      57.308  40.621  13.703  1.00 62.07           C  
ATOM   1491  O   SER    71      57.796  41.724  13.403  1.00 61.87           O  
ATOM   1492  N   PHE    72      56.075  40.266  13.375  1.00 60.95           N  
ATOM   1493  CA  PHE    72      55.352  41.039  12.380  1.00 60.62           C  
ATOM   1494  CB  PHE    72      54.002  40.394  12.068  1.00 59.71           C  
ATOM   1495  CG  PHE    72      53.226  41.113  11.017  1.00 59.52           C  
ATOM   1496  CD1 PHE    72      53.869  41.651   9.898  1.00 57.25           C  
ATOM   1497  CE1 PHE    72      53.161  42.310   8.924  1.00 56.85           C  
ATOM   1498  CZ  PHE    72      51.795  42.433   9.043  1.00 57.63           C  
ATOM   1499  CE2 PHE    72      51.135  41.900  10.152  1.00 58.57           C  
ATOM   1500  CD2 PHE    72      51.854  41.242  11.131  1.00 58.26           C  
ATOM   1501  C   PHE    72      55.169  42.477  12.834  1.00 60.35           C  
ATOM   1502  O   PHE    72      55.526  43.423  12.124  1.00 60.09           O  
ATOM   1503  N   TYR    73      54.650  42.627  14.043  1.00 60.53           N  
ATOM   1504  CA  TYR    73      54.369  43.945  14.559  1.00 60.68           C  
ATOM   1505  CB  TYR    73      53.544  43.817  15.820  1.00 60.60           C  
ATOM   1506  CG  TYR    73      52.115  43.401  15.588  1.00 60.57           C  
ATOM   1507  CD1 TYR    73      51.488  43.600  14.351  1.00 60.33           C  
ATOM   1508  CE1 TYR    73      50.146  43.243  14.133  1.00 59.59           C  
ATOM   1509  CZ  TYR    73      49.411  42.686  15.149  1.00 61.24           C  
ATOM   1510  OH  TYR    73      48.086  42.340  14.905  1.00 60.98           O  
ATOM   1511  CE2 TYR    73      50.009  42.473  16.414  1.00 61.73           C  
ATOM   1512  CD2 TYR    73      51.359  42.840  16.622  1.00 61.38           C  
ATOM   1513  C   TYR    73      55.654  44.744  14.766  1.00 60.62           C  
ATOM   1514  O   TYR    73      55.789  45.842  14.200  1.00 59.42           O  
ATOM   1515  N   LYS    74      56.582  44.167  15.544  1.00 61.09           N  
ATOM   1516  CA  LYS    74      57.967  44.672  15.664  1.00 61.36           C  
ATOM   1517  CB  LYS    74      58.948  43.599  16.243  1.00 61.82           C  
ATOM   1518  CG  LYS    74      58.562  42.915  17.610  1.00 64.03           C  
ATOM   1519  CD  LYS    74      58.799  43.809  18.865  1.00 65.00           C  
ATOM   1520  CE  LYS    74      57.616  43.822  19.899  1.00 64.60           C  
ATOM   1521  NZ  LYS    74      57.615  42.683  20.891  1.00 64.65           N  
ATOM   1522  C   LYS    74      58.521  45.115  14.310  1.00 61.44           C  
ATOM   1523  O   LYS    74      58.907  46.270  14.108  1.00 61.82           O  
ATOM   1524  N   THR    75      58.576  44.187  13.370  1.00 61.19           N  
ATOM   1525  CA  THR    75      59.240  44.460  12.111  1.00 61.24           C  
ATOM   1526  CB  THR    75      59.231  43.219  11.204  1.00 61.50           C  
ATOM   1527  OG1 THR    75      59.816  42.122  11.934  1.00 60.59           O  
ATOM   1528  CG2 THR    75      59.983  43.472   9.865  1.00 59.89           C  
ATOM   1529  C   THR    75      58.579  45.602  11.415  1.00 61.11           C  
ATOM   1530  O   THR    75      59.240  46.425  10.828  1.00 61.07           O  
ATOM   1531  N   LEU    76      57.262  45.647  11.501  1.00 61.67           N  
ATOM   1532  CA  LEU    76      56.463  46.619  10.753  1.00 62.50           C  
ATOM   1533  CB  LEU    76      54.988  46.319  10.992  1.00 62.04           C  
ATOM   1534  CG  LEU    76      53.996  46.464   9.848  1.00 62.11           C  
ATOM   1535  CD1 LEU    76      54.586  46.209   8.487  1.00 60.53           C  
ATOM   1536  CD2 LEU    76      52.833  45.533  10.124  1.00 62.29           C  
ATOM   1537  C   LEU    76      56.789  48.044  11.183  1.00 63.29           C  
ATOM   1538  O   LEU    76      57.062  48.928  10.352  1.00 63.03           O  
ATOM   1539  N   GLU    77      56.779  48.231  12.504  1.00 64.51           N  
ATOM   1540  CA  GLU    77      57.104  49.504  13.143  1.00 65.40           C  
ATOM   1541  CB  GLU    77      56.608  49.528  14.594  1.00 66.12           C  
ATOM   1542  CG  GLU    77      55.290  50.300  14.752  1.00 67.50           C  
ATOM   1543  CD  GLU    77      54.557  49.980  16.045  1.00 68.10           C  
ATOM   1544  OE1 GLU    77      54.968  49.028  16.755  1.00 72.45           O  
ATOM   1545  OE2 GLU    77      53.547  50.668  16.341  1.00 71.93           O  
ATOM   1546  C   GLU    77      58.587  49.836  13.098  1.00 65.52           C  
ATOM   1547  O   GLU    77      58.932  50.947  12.739  1.00 66.33           O  
ATOM   1548  N   ALA    78      59.474  48.895  13.422  1.00 65.34           N  
ATOM   1549  CA  ALA    78      60.910  49.135  13.169  1.00 65.44           C  
ATOM   1550  CB  ALA    78      61.771  47.904  13.524  1.00 64.89           C  
ATOM   1551  C   ALA    78      61.223  49.604  11.729  1.00 65.37           C  
ATOM   1552  O   ALA    78      62.213  50.280  11.528  1.00 66.10           O  
ATOM   1553  N   LYS    79      60.404  49.262  10.737  1.00 65.47           N  
ATOM   1554  CA  LYS    79      60.795  49.490   9.345  1.00 65.81           C  
ATOM   1555  CB  LYS    79      60.943  48.167   8.588  1.00 65.64           C  
ATOM   1556  CG  LYS    79      61.991  47.223   9.179  1.00 66.33           C  
ATOM   1557  CD  LYS    79      62.897  46.592   8.096  1.00 65.98           C  
ATOM   1558  CE  LYS    79      63.660  45.370   8.622  1.00 65.01           C  
ATOM   1559  NZ  LYS    79      64.861  45.060   7.802  1.00 65.44           N  
ATOM   1560  C   LYS    79      59.891  50.401   8.538  1.00 66.08           C  
ATOM   1561  O   LYS    79      60.391  51.292   7.858  1.00 66.12           O  
ATOM   1562  N   SER    80      58.574  50.182   8.589  1.00 66.35           N  
ATOM   1563  CA  SER    80      57.687  50.703   7.521  1.00 66.13           C  
ATOM   1564  CB  SER    80      56.305  50.075   7.622  1.00 65.90           C  
ATOM   1565  OG  SER    80      55.872  50.120   8.952  1.00 64.81           O  
ATOM   1566  C   SER    80      57.564  52.221   7.516  1.00 66.30           C  
ATOM   1567  O   SER    80      57.103  52.811   6.510  1.00 65.64           O  
ATOM   1568  N   GLY    81      58.002  52.835   8.629  1.00 66.65           N  
ATOM   1569  CA  GLY    81      57.761  54.241   8.894  1.00 66.81           C  
ATOM   1570  C   GLY    81      56.253  54.415   8.915  1.00 67.35           C  
ATOM   1571  O   GLY    81      55.673  55.038   8.024  1.00 68.26           O  
ATOM   1572  N   HIS    82      55.617  53.773   9.883  1.00 67.09           N  
ATOM   1573  CA  HIS    82      54.189  53.900  10.133  1.00 66.75           C  
ATOM   1574  CB  HIS    82      53.341  53.027   9.220  1.00 66.86           C  
ATOM   1575  CG  HIS    82      53.173  53.542   7.831  1.00 67.50           C  
ATOM   1576  ND1 HIS    82      53.553  52.811   6.722  1.00 68.26           N  
ATOM   1577  CE1 HIS    82      53.272  53.498   5.629  1.00 68.32           C  
ATOM   1578  NE2 HIS    82      52.707  54.638   5.990  1.00 68.21           N  
ATOM   1579  CD2 HIS    82      52.630  54.688   7.362  1.00 67.56           C  
ATOM   1580  C   HIS    82      53.994  53.372  11.535  1.00 66.25           C  
ATOM   1581  O   HIS    82      54.817  52.606  12.055  1.00 65.10           O  
ATOM   1582  N   LYS    83      52.884  53.765  12.132  1.00 66.31           N  
ATOM   1583  CA  LYS    83      52.539  53.270  13.446  1.00 66.73           C  
ATOM   1584  CB  LYS    83      52.354  54.433  14.433  1.00 67.46           C  
ATOM   1585  CG  LYS    83      53.643  55.208  14.738  1.00 69.09           C  
ATOM   1586  CD  LYS    83      54.688  54.330  15.476  1.00 71.26           C  
ATOM   1587  CE  LYS    83      55.970  55.086  15.811  1.00 71.11           C  
ATOM   1588  NZ  LYS    83      56.192  54.969  17.289  1.00 73.94           N  
ATOM   1589  C   LYS    83      51.284  52.425  13.369  1.00 65.95           C  
ATOM   1590  O   LYS    83      50.337  52.740  12.641  1.00 65.91           O  
ATOM   1591  N   ILE    84      51.309  51.333  14.108  1.00 65.12           N  
ATOM   1592  CA  ILE    84      50.148  50.486  14.251  1.00 65.44           C  
ATOM   1593  CB  ILE    84      50.515  49.190  15.062  1.00 65.60           C  
ATOM   1594  CG1 ILE    84      51.538  48.359  14.250  1.00 64.73           C  
ATOM   1595  CD1 ILE    84      51.959  47.057  14.905  1.00 64.78           C  
ATOM   1596  CG2 ILE    84      49.236  48.398  15.428  1.00 64.02           C  
ATOM   1597  C   ILE    84      48.996  51.270  14.927  1.00 65.59           C  
ATOM   1598  O   ILE    84      49.115  51.653  16.082  1.00 65.54           O  
ATOM   1599  N   GLY    85      47.904  51.517  14.197  1.00 65.25           N  
ATOM   1600  CA  GLY    85      46.768  52.288  14.728  1.00 64.93           C  
ATOM   1601  C   GLY    85      45.663  51.440  15.352  1.00 64.53           C  
ATOM   1602  O   GLY    85      45.914  50.558  16.166  1.00 64.19           O  
ATOM   1603  N   HIS    86      44.428  51.695  14.949  1.00 64.41           N  
ATOM   1604  CA  HIS    86      43.296  50.974  15.518  1.00 64.33           C  
ATOM   1605  CB  HIS    86      41.995  51.706  15.174  1.00 65.12           C  
ATOM   1606  CG  HIS    86      41.898  53.057  15.823  1.00 68.01           C  
ATOM   1607  ND1 HIS    86      41.389  54.168  15.174  1.00 70.34           N  
ATOM   1608  CE1 HIS    86      41.466  55.217  15.979  1.00 70.57           C  
ATOM   1609  NE2 HIS    86      42.015  54.830  17.122  1.00 69.63           N  
ATOM   1610  CD2 HIS    86      42.294  53.485  17.052  1.00 69.08           C  
ATOM   1611  C   HIS    86      43.220  49.534  15.037  1.00 63.87           C  
ATOM   1612  O   HIS    86      43.816  49.168  14.021  1.00 64.68           O  
ATOM   1613  N   SER    87      42.481  48.707  15.761  1.00 62.43           N  
ATOM   1614  CA  SER    87      42.098  47.398  15.238  1.00 60.99           C  
ATOM   1615  CB  SER    87      43.023  46.299  15.753  1.00 60.91           C  
ATOM   1616  OG  SER    87      42.711  46.043  17.107  1.00 62.22           O  
ATOM   1617  C   SER    87      40.652  47.132  15.634  1.00 59.77           C  
ATOM   1618  O   SER    87      40.094  47.804  16.499  1.00 59.93           O  
ATOM   1619  N   ASN    88      40.015  46.197  14.950  1.00 58.14           N  
ATOM   1620  CA  ASN    88      38.681  45.797  15.334  1.00 56.49           C  
ATOM   1621  CB  ASN    88      37.644  46.733  14.701  1.00 56.62           C  
ATOM   1622  CG  ASN    88      37.519  46.561  13.233  1.00 59.15           C  
ATOM   1623  OD1 ASN    88      37.089  45.492  12.758  1.00 63.48           O  
ATOM   1624  ND2 ASN    88      37.850  47.615  12.475  1.00 60.78           N  
ATOM   1625  C   ASN    88      38.464  44.284  15.144  1.00 54.58           C  
ATOM   1626  O   ASN    88      39.161  43.619  14.395  1.00 54.18           O  
ATOM   1627  N   GLN    89      37.567  43.731  15.925  1.00 52.67           N  
ATOM   1628  CA  GLN    89      37.459  42.302  16.090  1.00 51.84           C  
ATOM   1629  CB  GLN    89      38.092  41.909  17.414  1.00 51.40           C  
ATOM   1630  CG  GLN    89      39.559  41.784  17.376  1.00 51.50           C  
ATOM   1631  CD  GLN    89      40.148  41.727  18.756  1.00 52.26           C  
ATOM   1632  OE1 GLN    89      39.634  42.399  19.668  1.00 55.51           O  
ATOM   1633  NE2 GLN    89      41.232  40.944  18.932  1.00 44.23           N  
ATOM   1634  C   GLN    89      36.000  41.920  16.128  1.00 50.38           C  
ATOM   1635  O   GLN    89      35.183  42.644  16.653  1.00 49.53           O  
ATOM   1636  N   THR    90      35.682  40.768  15.583  1.00 50.07           N  
ATOM   1637  CA  THR    90      34.317  40.271  15.572  1.00 50.31           C  
ATOM   1638  CB  THR    90      33.694  40.352  14.174  1.00 50.38           C  
ATOM   1639  OG1 THR    90      33.857  41.686  13.683  1.00 51.12           O  
ATOM   1640  CG2 THR    90      32.185  40.012  14.187  1.00 49.21           C  
ATOM   1641  C   THR    90      34.407  38.853  16.044  1.00 50.10           C  
ATOM   1642  O   THR    90      35.054  38.020  15.407  1.00 51.56           O  
ATOM   1643  N   ILE    91      33.800  38.599  17.194  1.00 49.46           N  
ATOM   1644  CA  ILE    91      33.896  37.323  17.867  1.00 49.05           C  
ATOM   1645  CB  ILE    91      34.143  37.533  19.342  1.00 49.09           C  
ATOM   1646  CG1 ILE    91      35.359  38.449  19.522  1.00 48.77           C  
ATOM   1647  CD1 ILE    91      35.589  38.748  20.945  1.00 49.36           C  
ATOM   1648  CG2 ILE    91      34.354  36.197  20.046  1.00 48.53           C  
ATOM   1649  C   ILE    91      32.621  36.535  17.691  1.00 48.72           C  
ATOM   1650  O   ILE    91      31.554  37.040  17.947  1.00 48.31           O  
ATOM   1651  N   SER    92      32.734  35.303  17.212  1.00 48.65           N  
ATOM   1652  CA  SER    92      31.569  34.441  17.071  1.00 48.92           C  
ATOM   1653  CB  SER    92      31.054  34.481  15.636  1.00 48.51           C  
ATOM   1654  OG  SER    92      32.098  34.168  14.726  1.00 48.47           O  
ATOM   1655  C   SER    92      31.965  33.038  17.430  1.00 48.69           C  
ATOM   1656  O   SER    92      33.117  32.765  17.684  1.00 48.83           O  
ATOM   1657  N   ALA    93      30.987  32.161  17.443  1.00 49.88           N  
ATOM   1658  CA  ALA    93      31.148  30.772  17.782  1.00 50.89           C  
ATOM   1659  CB  ALA    93      30.271  30.454  18.926  1.00 50.66           C  
ATOM   1660  C   ALA    93      30.746  29.924  16.570  1.00 51.92           C  
ATOM   1661  O   ALA    93      29.742  30.171  15.960  1.00 51.99           O  
ATOM   1662  N   VAL    94      31.539  28.918  16.238  1.00 53.30           N  
ATOM   1663  CA  VAL    94      31.309  28.105  15.060  1.00 54.08           C  
ATOM   1664  CB  VAL    94      32.133  28.663  13.895  1.00 54.37           C  
ATOM   1665  CG1 VAL    94      32.156  27.709  12.760  1.00 55.01           C  
ATOM   1666  CG2 VAL    94      31.514  29.974  13.435  1.00 54.26           C  
ATOM   1667  C   VAL    94      31.695  26.653  15.325  1.00 54.83           C  
ATOM   1668  O   VAL    94      32.545  26.370  16.132  1.00 54.71           O  
ATOM   1669  N   GLN    95      31.062  25.725  14.634  1.00 56.09           N  
ATOM   1670  CA  GLN    95      31.480  24.315  14.711  1.00 56.95           C  
ATOM   1671  CB  GLN    95      30.389  23.439  14.118  1.00 57.33           C  
ATOM   1672  CG  GLN    95      29.005  23.814  14.561  1.00 58.13           C  
ATOM   1673  CD  GLN    95      28.123  22.635  14.519  1.00 60.37           C  
ATOM   1674  OE1 GLN    95      27.422  22.426  13.548  1.00 61.67           O  
ATOM   1675  NE2 GLN    95      28.208  21.793  15.543  1.00 62.95           N  
ATOM   1676  C   GLN    95      32.760  24.047  13.932  1.00 57.26           C  
ATOM   1677  O   GLN    95      32.947  24.610  12.870  1.00 57.40           O  
ATOM   1678  N   ALA    96      33.618  23.165  14.424  1.00 58.08           N  
ATOM   1679  CA  ALA    96      34.857  22.818  13.699  1.00 58.74           C  
ATOM   1680  CB  ALA    96      35.737  21.976  14.556  1.00 58.50           C  
ATOM   1681  C   ALA    96      34.548  22.075  12.420  1.00 59.31           C  
ATOM   1682  O   ALA    96      33.764  21.131  12.431  1.00 59.39           O  
ATOM   1683  N   SER    97      35.133  22.525  11.312  1.00 60.42           N  
ATOM   1684  CA  SER    97      35.107  21.767  10.043  1.00 61.00           C  
ATOM   1685  CB  SER    97      35.525  22.640   8.873  1.00 60.27           C  
ATOM   1686  OG  SER    97      36.930  22.787   8.865  1.00 60.13           O  
ATOM   1687  C   SER    97      36.038  20.540  10.141  1.00 62.02           C  
ATOM   1688  O   SER    97      36.840  20.395  11.092  1.00 62.18           O  
ATOM   1689  N   GLU    98      35.921  19.644   9.168  1.00 63.43           N  
ATOM   1690  CA  GLU    98      36.724  18.429   9.189  1.00 63.96           C  
ATOM   1691  CB  GLU    98      36.449  17.617   7.939  1.00 64.18           C  
ATOM   1692  CG  GLU    98      37.235  16.294   7.807  1.00 65.28           C  
ATOM   1693  CD  GLU    98      37.186  15.778   6.340  1.00 67.67           C  
ATOM   1694  OE1 GLU    98      36.177  16.062   5.603  1.00 70.33           O  
ATOM   1695  OE2 GLU    98      38.170  15.105   5.923  1.00 73.63           O  
ATOM   1696  C   GLU    98      38.171  18.852   9.219  1.00 63.92           C  
ATOM   1697  O   GLU    98      38.965  18.389  10.034  1.00 64.26           O  
ATOM   1698  N   GLN    99      38.469  19.778   8.317  1.00 64.07           N  
ATOM   1699  CA  GLN    99      39.791  20.361   8.141  1.00 63.67           C  
ATOM   1700  CB  GLN    99      39.680  21.417   7.026  1.00 63.80           C  
ATOM   1701  CG  GLN    99      40.968  22.048   6.632  1.00 64.58           C  
ATOM   1702  CD  GLN    99      42.010  21.014   6.225  1.00 68.17           C  
ATOM   1703  OE1 GLN    99      42.632  20.319   7.085  1.00 67.56           O  
ATOM   1704  NE2 GLN    99      42.223  20.903   4.893  1.00 68.03           N  
ATOM   1705  C   GLN    99      40.368  20.979   9.425  1.00 63.32           C  
ATOM   1706  O   GLN    99      41.448  20.599   9.902  1.00 63.41           O  
ATOM   1707  N   ILE   100      39.632  21.926   9.995  1.00 62.96           N  
ATOM   1708  CA  ILE   100      40.076  22.574  11.229  1.00 62.69           C  
ATOM   1709  CB  ILE   100      39.236  23.842  11.556  1.00 62.67           C  
ATOM   1710  CG1 ILE   100      39.880  25.041  10.847  1.00 61.31           C  
ATOM   1711  CD1 ILE   100      38.927  26.034  10.434  1.00 59.86           C  
ATOM   1712  CG2 ILE   100      39.161  24.080  13.080  1.00 61.97           C  
ATOM   1713  C   ILE   100      40.116  21.592  12.380  1.00 62.13           C  
ATOM   1714  O   ILE   100      40.942  21.721  13.267  1.00 62.00           O  
ATOM   1715  N   ALA   101      39.253  20.589  12.340  1.00 61.83           N  
ATOM   1716  CA  ALA   101      39.336  19.520  13.310  1.00 62.17           C  
ATOM   1717  CB  ALA   101      38.199  18.570  13.123  1.00 61.70           C  
ATOM   1718  C   ALA   101      40.694  18.795  13.197  1.00 62.19           C  
ATOM   1719  O   ALA   101      41.392  18.630  14.221  1.00 60.67           O  
ATOM   1720  N   GLU   102      41.073  18.393  11.969  1.00 62.42           N  
ATOM   1721  CA  GLU   102      42.357  17.703  11.767  1.00 63.31           C  
ATOM   1722  CB  GLU   102      42.724  17.461  10.316  1.00 63.78           C  
ATOM   1723  CG  GLU   102      41.729  16.671   9.432  1.00 66.53           C  
ATOM   1724  CD  GLU   102      42.277  16.510   7.986  1.00 66.96           C  
ATOM   1725  OE1 GLU   102      43.521  16.232   7.884  1.00 71.08           O  
ATOM   1726  OE2 GLU   102      41.490  16.674   6.990  1.00 68.24           O  
ATOM   1727  C   GLU   102      43.454  18.554  12.320  1.00 62.80           C  
ATOM   1728  O   GLU   102      44.252  18.076  13.091  1.00 62.23           O  
ATOM   1729  N   TYR   103      43.485  19.826  11.921  1.00 62.90           N  
ATOM   1730  CA  TYR   103      44.544  20.755  12.375  1.00 62.73           C  
ATOM   1731  CB  TYR   103      44.362  22.135  11.760  1.00 62.49           C  
ATOM   1732  CG  TYR   103      44.619  22.266  10.289  1.00 62.53           C  
ATOM   1733  CD1 TYR   103      45.700  21.623   9.675  1.00 63.11           C  
ATOM   1734  CE1 TYR   103      45.945  21.768   8.313  1.00 61.14           C  
ATOM   1735  CZ  TYR   103      45.124  22.584   7.588  1.00 62.08           C  
ATOM   1736  OH  TYR   103      45.346  22.759   6.274  1.00 63.69           O  
ATOM   1737  CE2 TYR   103      44.058  23.256   8.167  1.00 62.30           C  
ATOM   1738  CD2 TYR   103      43.824  23.110   9.511  1.00 61.89           C  
ATOM   1739  C   TYR   103      44.587  20.984  13.883  1.00 62.42           C  
ATOM   1740  O   TYR   103      45.650  21.129  14.473  1.00 62.16           O  
ATOM   1741  N   LEU   104      43.430  21.100  14.504  1.00 62.63           N  
ATOM   1742  CA  LEU   104      43.413  21.403  15.924  1.00 62.76           C  
ATOM   1743  CB  LEU   104      42.288  22.384  16.223  1.00 62.29           C  
ATOM   1744  CG  LEU   104      42.546  23.812  15.738  1.00 60.70           C  
ATOM   1745  CD1 LEU   104      41.356  24.668  16.016  1.00 59.52           C  
ATOM   1746  CD2 LEU   104      43.722  24.405  16.452  1.00 61.29           C  
ATOM   1747  C   LEU   104      43.326  20.136  16.767  1.00 62.85           C  
ATOM   1748  O   LEU   104      43.361  20.191  17.973  1.00 62.42           O  
ATOM   1749  N   GLU   105      43.264  18.979  16.121  1.00 63.87           N  
ATOM   1750  CA  GLU   105      43.254  17.711  16.846  1.00 64.37           C  
ATOM   1751  CB  GLU   105      44.527  17.535  17.677  1.00 64.45           C  
ATOM   1752  CG  GLU   105      45.745  17.965  16.936  1.00 64.99           C  
ATOM   1753  CD  GLU   105      46.998  17.308  17.407  1.00 65.13           C  
ATOM   1754  OE1 GLU   105      47.370  17.383  18.595  1.00 68.92           O  
ATOM   1755  OE2 GLU   105      47.643  16.722  16.550  1.00 67.31           O  
ATOM   1756  C   GLU   105      42.054  17.693  17.757  1.00 64.54           C  
ATOM   1757  O   GLU   105      42.208  17.565  18.965  1.00 63.71           O  
ATOM   1758  N   ILE   106      40.878  17.868  17.149  1.00 64.94           N  
ATOM   1759  CA  ILE   106      39.591  17.780  17.825  1.00 65.25           C  
ATOM   1760  CB  ILE   106      39.102  19.168  18.315  1.00 65.36           C  
ATOM   1761  CG1 ILE   106      38.867  20.115  17.123  1.00 65.59           C  
ATOM   1762  CD1 ILE   106      38.648  21.547  17.524  1.00 64.73           C  
ATOM   1763  CG2 ILE   106      40.110  19.756  19.320  1.00 63.53           C  
ATOM   1764  C   ILE   106      38.675  17.175  16.783  1.00 65.80           C  
ATOM   1765  O   ILE   106      39.173  16.785  15.717  1.00 65.53           O  
ATOM   1766  N   LYS   107      37.363  17.116  17.065  1.00 66.52           N  
ATOM   1767  CA  LYS   107      36.376  16.437  16.178  1.00 66.94           C  
ATOM   1768  CB  LYS   107      35.423  15.584  17.038  1.00 67.40           C  
ATOM   1769  CG  LYS   107      36.134  14.699  18.116  1.00 69.02           C  
ATOM   1770  CD  LYS   107      35.427  13.293  18.357  1.00 69.15           C  
ATOM   1771  CE  LYS   107      36.386  12.207  18.985  1.00 69.46           C  
ATOM   1772  NZ  LYS   107      36.493  12.271  20.481  1.00 70.41           N  
ATOM   1773  C   LYS   107      35.528  17.406  15.352  1.00 66.62           C  
ATOM   1774  O   LYS   107      35.182  18.459  15.878  1.00 66.80           O  
ATOM   1775  N   ARG   108      35.166  17.049  14.101  1.00 66.31           N  
ATOM   1776  CA  ARG   108      34.150  17.805  13.317  1.00 66.14           C  
ATOM   1777  CB  ARG   108      33.649  17.064  11.990  1.00 66.38           C  
ATOM   1778  CG  ARG   108      32.615  17.840  10.965  1.00 67.02           C  
ATOM   1779  CD  ARG   108      32.940  17.842   9.325  1.00 68.03           C  
ATOM   1780  NE  ARG   108      32.397  19.042   8.542  1.00 70.42           N  
ATOM   1781  CZ  ARG   108      32.875  19.595   7.383  1.00 69.42           C  
ATOM   1782  NH1 ARG   108      33.914  19.119   6.762  1.00 71.23           N  
ATOM   1783  NH2 ARG   108      32.315  20.658   6.812  1.00 68.63           N  
ATOM   1784  C   ARG   108      33.042  18.060  14.355  1.00 65.64           C  
ATOM   1785  O   ARG   108      32.809  17.220  15.228  1.00 65.83           O  
ATOM   1786  N   GLY   109      32.446  19.250  14.335  1.00 64.45           N  
ATOM   1787  CA  GLY   109      31.366  19.562  15.229  1.00 63.52           C  
ATOM   1788  C   GLY   109      31.773  20.342  16.456  1.00 62.89           C  
ATOM   1789  O   GLY   109      30.974  21.104  16.989  1.00 63.61           O  
ATOM   1790  N   ASP   110      32.997  20.160  16.921  1.00 61.84           N  
ATOM   1791  CA  ASP   110      33.435  20.771  18.168  1.00 60.95           C  
ATOM   1792  CB  ASP   110      34.856  20.298  18.533  1.00 62.00           C  
ATOM   1793  CG  ASP   110      34.869  18.980  19.280  1.00 63.76           C  
ATOM   1794  OD1 ASP   110      33.771  18.501  19.596  1.00 67.38           O  
ATOM   1795  OD2 ASP   110      35.966  18.434  19.564  1.00 67.68           O  
ATOM   1796  C   ASP   110      33.406  22.280  18.098  1.00 59.30           C  
ATOM   1797  O   ASP   110      33.432  22.865  17.042  1.00 59.02           O  
ATOM   1798  N   ALA   111      33.379  22.893  19.261  1.00 58.06           N  
ATOM   1799  CA  ALA   111      33.066  24.306  19.406  1.00 57.38           C  
ATOM   1800  CB  ALA   111      32.536  24.554  20.818  1.00 57.21           C  
ATOM   1801  C   ALA   111      34.258  25.205  19.177  1.00 56.72           C  
ATOM   1802  O   ALA   111      35.272  25.089  19.889  1.00 57.57           O  
ATOM   1803  N   ILE   112      34.119  26.154  18.251  1.00 55.21           N  
ATOM   1804  CA  ILE   112      35.225  27.055  17.889  1.00 54.33           C  
ATOM   1805  CB  ILE   112      35.545  27.013  16.382  1.00 53.69           C  
ATOM   1806  CG1 ILE   112      36.137  25.638  15.980  1.00 52.77           C  
ATOM   1807  CD1 ILE   112      37.476  25.275  16.635  1.00 49.92           C  
ATOM   1808  CG2 ILE   112      36.436  28.152  16.043  1.00 53.76           C  
ATOM   1809  C   ILE   112      34.888  28.482  18.207  1.00 53.15           C  
ATOM   1810  O   ILE   112      33.808  28.944  17.899  1.00 51.53           O  
ATOM   1811  N   LEU   113      35.821  29.173  18.845  1.00 53.06           N  
ATOM   1812  CA  LEU   113      35.666  30.596  19.061  1.00 53.03           C  
ATOM   1813  CB  LEU   113      36.292  31.072  20.383  1.00 53.10           C  
ATOM   1814  CG  LEU   113      36.087  32.580  20.532  1.00 52.79           C  
ATOM   1815  CD1 LEU   113      34.661  32.806  21.024  1.00 54.51           C  
ATOM   1816  CD2 LEU   113      37.078  33.222  21.401  1.00 51.36           C  
ATOM   1817  C   LEU   113      36.397  31.229  17.909  1.00 53.23           C  
ATOM   1818  O   LEU   113      37.609  31.012  17.734  1.00 52.53           O  
ATOM   1819  N   ARG   114      35.667  32.020  17.138  1.00 53.46           N  
ATOM   1820  CA  ARG   114      36.223  32.610  15.948  1.00 53.18           C  
ATOM   1821  CB  ARG   114      35.293  32.455  14.780  1.00 53.98           C  
ATOM   1822  CG  ARG   114      35.992  32.861  13.486  1.00 55.81           C  
ATOM   1823  CD  ARG   114      35.286  32.347  12.284  1.00 56.37           C  
ATOM   1824  NE  ARG   114      34.281  33.310  11.980  1.00 62.18           N  
ATOM   1825  CZ  ARG   114      33.110  33.021  11.425  1.00 66.73           C  
ATOM   1826  NH1 ARG   114      32.821  31.763  11.120  1.00 69.41           N  
ATOM   1827  NH2 ARG   114      32.219  33.993  11.177  1.00 65.56           N  
ATOM   1828  C   ARG   114      36.412  34.061  16.129  1.00 51.52           C  
ATOM   1829  O   ARG   114      35.504  34.765  16.508  1.00 50.99           O  
ATOM   1830  N   VAL   115      37.595  34.520  15.806  1.00 50.91           N  
ATOM   1831  CA  VAL   115      37.861  35.942  15.832  1.00 50.00           C  
ATOM   1832  CB  VAL   115      38.953  36.307  16.861  1.00 48.85           C  
ATOM   1833  CG1 VAL   115      39.106  37.829  16.950  1.00 43.80           C  
ATOM   1834  CG2 VAL   115      38.595  35.721  18.153  1.00 46.27           C  
ATOM   1835  C   VAL   115      38.341  36.347  14.469  1.00 50.21           C  
ATOM   1836  O   VAL   115      39.296  35.795  13.969  1.00 51.89           O  
ATOM   1837  N   ARG   116      37.677  37.315  13.884  1.00 49.80           N  
ATOM   1838  CA  ARG   116      38.152  37.929  12.691  1.00 49.49           C  
ATOM   1839  CB  ARG   116      37.035  37.992  11.663  1.00 49.87           C  
ATOM   1840  CG  ARG   116      36.515  36.649  11.141  1.00 51.66           C  
ATOM   1841  CD  ARG   116      35.941  36.909   9.834  1.00 56.96           C  
ATOM   1842  NE  ARG   116      34.794  36.102   9.460  1.00 59.39           N  
ATOM   1843  CZ  ARG   116      34.878  34.960   8.799  1.00 62.41           C  
ATOM   1844  NH1 ARG   116      36.084  34.397   8.490  1.00 66.08           N  
ATOM   1845  NH2 ARG   116      33.748  34.358   8.477  1.00 60.95           N  
ATOM   1846  C   ARG   116      38.524  39.347  13.033  1.00 48.86           C  
ATOM   1847  O   ARG   116      37.747  40.070  13.642  1.00 48.25           O  
ATOM   1848  N   GLN   117      39.661  39.779  12.527  1.00 48.71           N  
ATOM   1849  CA  GLN   117      40.193  41.071  12.872  1.00 48.56           C  
ATOM   1850  CB  GLN   117      41.243  40.818  13.896  1.00 48.45           C  
ATOM   1851  CG  GLN   117      42.384  41.762  13.894  1.00 50.00           C  
ATOM   1852  CD  GLN   117      43.250  41.542  15.144  1.00 49.66           C  
ATOM   1853  OE1 GLN   117      42.762  41.248  16.252  1.00 49.02           O  
ATOM   1854  NE2 GLN   117      44.538  41.627  14.942  1.00 52.07           N  
ATOM   1855  C   GLN   117      40.811  41.792  11.679  1.00 48.14           C  
ATOM   1856  O   GLN   117      41.481  41.162  10.894  1.00 48.86           O  
ATOM   1857  N   VAL   118      40.553  43.097  11.554  1.00 47.34           N  
ATOM   1858  CA  VAL   118      41.311  43.996  10.683  1.00 46.98           C  
ATOM   1859  CB  VAL   118      40.423  44.783   9.740  1.00 45.57           C  
ATOM   1860  CG1 VAL   118      41.288  45.644   8.844  1.00 43.48           C  
ATOM   1861  CG2 VAL   118      39.588  43.858   8.940  1.00 41.77           C  
ATOM   1862  C   VAL   118      42.097  45.009  11.516  1.00 47.59           C  
ATOM   1863  O   VAL   118      41.560  45.561  12.457  1.00 48.49           O  
ATOM   1864  N   SER   119      43.345  45.264  11.152  1.00 48.06           N  
ATOM   1865  CA  SER   119      44.183  46.194  11.873  1.00 48.99           C  
ATOM   1866  CB  SER   119      45.413  45.504  12.457  1.00 49.20           C  
ATOM   1867  OG  SER   119      45.043  44.443  13.305  1.00 49.66           O  
ATOM   1868  C   SER   119      44.660  47.243  10.911  1.00 50.78           C  
ATOM   1869  O   SER   119      44.887  46.968   9.720  1.00 51.04           O  
ATOM   1870  N   TYR   120      44.848  48.447  11.436  1.00 52.36           N  
ATOM   1871  CA  TYR   120      45.118  49.599  10.596  1.00 53.81           C  
ATOM   1872  CB  TYR   120      43.912  50.539  10.637  1.00 53.34           C  
ATOM   1873  CG  TYR   120      42.625  49.910  10.233  1.00 52.23           C  
ATOM   1874  CD1 TYR   120      42.137  50.064   8.948  1.00 52.04           C  
ATOM   1875  CE1 TYR   120      40.935  49.490   8.562  1.00 51.37           C  
ATOM   1876  CZ  TYR   120      40.232  48.745   9.477  1.00 51.73           C  
ATOM   1877  OH  TYR   120      39.055  48.157   9.111  1.00 53.17           O  
ATOM   1878  CE2 TYR   120      40.706  48.574  10.755  1.00 52.14           C  
ATOM   1879  CD2 TYR   120      41.895  49.167  11.130  1.00 51.06           C  
ATOM   1880  C   TYR   120      46.343  50.379  11.045  1.00 54.45           C  
ATOM   1881  O   TYR   120      46.699  50.382  12.221  1.00 54.84           O  
ATOM   1882  N   PHE   121      46.964  51.098  10.121  1.00 55.53           N  
ATOM   1883  CA  PHE   121      47.946  52.079  10.542  1.00 56.46           C  
ATOM   1884  CB  PHE   121      48.870  52.473   9.379  1.00 56.48           C  
ATOM   1885  CG  PHE   121      49.843  51.393   9.001  1.00 55.95           C  
ATOM   1886  CD1 PHE   121      50.465  50.608   9.984  1.00 57.46           C  
ATOM   1887  CE1 PHE   121      51.393  49.607   9.640  1.00 56.87           C  
ATOM   1888  CZ  PHE   121      51.688  49.388   8.304  1.00 56.73           C  
ATOM   1889  CE2 PHE   121      51.059  50.155   7.326  1.00 56.28           C  
ATOM   1890  CD2 PHE   121      50.147  51.150   7.680  1.00 55.91           C  
ATOM   1891  C   PHE   121      47.251  53.314  11.147  1.00 57.56           C  
ATOM   1892  O   PHE   121      46.077  53.622  10.832  1.00 58.10           O  
ATOM   1893  N   GLU   122      47.989  54.032  11.993  1.00 57.96           N  
ATOM   1894  CA  GLU   122      47.539  55.339  12.459  1.00 58.02           C  
ATOM   1895  CB  GLU   122      48.619  56.062  13.267  1.00 57.75           C  
ATOM   1896  CG  GLU   122      48.876  55.329  14.583  1.00 58.73           C  
ATOM   1897  CD  GLU   122      49.683  56.115  15.601  1.00 59.40           C  
ATOM   1898  OE1 GLU   122      50.450  57.012  15.171  1.00 63.62           O  
ATOM   1899  OE2 GLU   122      49.566  55.809  16.818  1.00 57.35           O  
ATOM   1900  C   GLU   122      47.053  56.189  11.307  1.00 58.16           C  
ATOM   1901  O   GLU   122      46.253  57.060  11.527  1.00 58.29           O  
ATOM   1902  N   ASN   123      47.483  55.940  10.072  1.00 58.65           N  
ATOM   1903  CA  ASN   123      46.956  56.745   8.991  1.00 58.77           C  
ATOM   1904  CB  ASN   123      48.049  57.058   7.975  1.00 59.77           C  
ATOM   1905  CG  ASN   123      48.489  55.842   7.158  1.00 62.70           C  
ATOM   1906  OD1 ASN   123      47.692  54.953   6.816  1.00 63.41           O  
ATOM   1907  ND2 ASN   123      49.777  55.825   6.809  1.00 66.38           N  
ATOM   1908  C   ASN   123      45.719  56.175   8.318  1.00 58.63           C  
ATOM   1909  O   ASN   123      45.349  56.630   7.223  1.00 58.28           O  
ATOM   1910  N   GLY   124      45.087  55.175   8.942  1.00 58.27           N  
ATOM   1911  CA  GLY   124      43.851  54.572   8.377  1.00 57.96           C  
ATOM   1912  C   GLY   124      43.988  53.406   7.394  1.00 57.60           C  
ATOM   1913  O   GLY   124      43.000  52.794   7.035  1.00 57.60           O  
ATOM   1914  N   LEU   125      45.209  53.091   6.958  1.00 57.62           N  
ATOM   1915  CA  LEU   125      45.474  52.003   5.971  1.00 56.79           C  
ATOM   1916  CB  LEU   125      46.863  52.172   5.354  1.00 56.99           C  
ATOM   1917  CG  LEU   125      47.313  51.209   4.238  1.00 57.32           C  
ATOM   1918  CD1 LEU   125      46.559  51.492   2.962  1.00 51.24           C  
ATOM   1919  CD2 LEU   125      48.879  51.262   4.034  1.00 56.37           C  
ATOM   1920  C   LEU   125      45.439  50.619   6.641  1.00 56.59           C  
ATOM   1921  O   LEU   125      46.185  50.381   7.602  1.00 56.51           O  
ATOM   1922  N   PRO   126      44.569  49.713   6.150  1.00 55.20           N  
ATOM   1923  CA  PRO   126      44.594  48.317   6.590  1.00 54.19           C  
ATOM   1924  CB  PRO   126      43.546  47.649   5.714  1.00 54.04           C  
ATOM   1925  CG  PRO   126      42.677  48.766   5.184  1.00 55.27           C  
ATOM   1926  CD  PRO   126      43.500  49.995   5.175  1.00 55.35           C  
ATOM   1927  C   PRO   126      45.931  47.648   6.331  1.00 52.47           C  
ATOM   1928  O   PRO   126      46.533  47.848   5.270  1.00 52.28           O  
ATOM   1929  N   PHE   127      46.389  46.837   7.270  1.00 50.79           N  
ATOM   1930  CA  PHE   127      47.560  46.065   7.000  1.00 49.66           C  
ATOM   1931  CB  PHE   127      48.770  46.716   7.670  1.00 49.45           C  
ATOM   1932  CG  PHE   127      48.796  46.579   9.145  1.00 49.09           C  
ATOM   1933  CD1 PHE   127      49.357  45.457   9.733  1.00 49.51           C  
ATOM   1934  CE1 PHE   127      49.395  45.324  11.118  1.00 50.25           C  
ATOM   1935  CZ  PHE   127      48.868  46.326  11.933  1.00 49.75           C  
ATOM   1936  CE2 PHE   127      48.322  47.460  11.335  1.00 49.82           C  
ATOM   1937  CD2 PHE   127      48.293  47.583   9.962  1.00 48.80           C  
ATOM   1938  C   PHE   127      47.426  44.594   7.350  1.00 49.26           C  
ATOM   1939  O   PHE   127      48.370  43.844   7.193  1.00 50.61           O  
ATOM   1940  N   GLU   128      46.257  44.151   7.752  1.00 48.37           N  
ATOM   1941  CA  GLU   128      46.129  42.822   8.282  1.00 48.59           C  
ATOM   1942  CB  GLU   128      46.561  42.888   9.728  1.00 48.53           C  
ATOM   1943  CG  GLU   128      47.258  41.717  10.178  1.00 50.32           C  
ATOM   1944  CD  GLU   128      47.613  41.718  11.695  1.00 50.97           C  
ATOM   1945  OE1 GLU   128      46.903  42.361  12.563  1.00 48.10           O  
ATOM   1946  OE2 GLU   128      48.606  40.977  11.980  1.00 55.33           O  
ATOM   1947  C   GLU   128      44.661  42.419   8.224  1.00 48.49           C  
ATOM   1948  O   GLU   128      43.790  43.206   8.620  1.00 48.17           O  
ATOM   1949  N   TYR   129      44.360  41.220   7.741  1.00 47.88           N  
ATOM   1950  CA  TYR   129      43.021  40.662   7.924  1.00 47.72           C  
ATOM   1951  CB  TYR   129      42.290  40.605   6.589  1.00 47.75           C  
ATOM   1952  CG  TYR   129      40.957  39.924   6.655  1.00 47.52           C  
ATOM   1953  CD1 TYR   129      40.152  40.056   7.758  1.00 46.95           C  
ATOM   1954  CE1 TYR   129      38.919  39.449   7.823  1.00 46.77           C  
ATOM   1955  CZ  TYR   129      38.460  38.721   6.777  1.00 47.90           C  
ATOM   1956  OH  TYR   129      37.231  38.120   6.883  1.00 49.08           O  
ATOM   1957  CE2 TYR   129      39.221  38.586   5.643  1.00 46.54           C  
ATOM   1958  CD2 TYR   129      40.482  39.180   5.593  1.00 46.25           C  
ATOM   1959  C   TYR   129      43.222  39.275   8.479  1.00 47.18           C  
ATOM   1960  O   TYR   129      43.747  38.406   7.826  1.00 47.44           O  
ATOM   1961  N   VAL   130      42.856  39.068   9.713  1.00 47.14           N  
ATOM   1962  CA  VAL   130      43.312  37.876  10.421  1.00 46.73           C  
ATOM   1963  CB  VAL   130      44.313  38.235  11.580  1.00 46.73           C  
ATOM   1964  CG1 VAL   130      44.880  36.978  12.232  1.00 42.42           C  
ATOM   1965  CG2 VAL   130      45.438  39.132  11.030  1.00 43.30           C  
ATOM   1966  C   VAL   130      42.100  37.144  10.923  1.00 47.65           C  
ATOM   1967  O   VAL   130      41.148  37.755  11.424  1.00 48.37           O  
ATOM   1968  N   ARG   131      42.085  35.841  10.720  1.00 48.01           N  
ATOM   1969  CA  ARG   131      40.872  35.081  10.995  1.00 48.71           C  
ATOM   1970  CB  ARG   131      40.191  34.689   9.703  1.00 48.30           C  
ATOM   1971  CG  ARG   131      39.837  35.900   8.836  1.00 50.13           C  
ATOM   1972  CD  ARG   131      39.993  35.617   7.365  1.00 49.77           C  
ATOM   1973  NE  ARG   131      41.290  36.030   6.895  1.00 50.32           N  
ATOM   1974  CZ  ARG   131      41.718  35.851   5.647  1.00 49.41           C  
ATOM   1975  NH1 ARG   131      41.000  35.229   4.746  1.00 49.10           N  
ATOM   1976  NH2 ARG   131      42.903  36.268   5.305  1.00 51.37           N  
ATOM   1977  C   ARG   131      41.352  33.869  11.746  1.00 48.75           C  
ATOM   1978  O   ARG   131      42.088  33.018  11.192  1.00 48.68           O  
ATOM   1979  N   THR   132      40.990  33.838  13.018  1.00 48.37           N  
ATOM   1980  CA  THR   132      41.508  32.864  13.900  1.00 48.79           C  
ATOM   1981  CB  THR   132      42.200  33.530  15.005  1.00 48.55           C  
ATOM   1982  OG1 THR   132      43.272  34.284  14.466  1.00 47.19           O  
ATOM   1983  CG2 THR   132      42.718  32.499  15.962  1.00 49.57           C  
ATOM   1984  C   THR   132      40.408  31.999  14.456  1.00 49.47           C  
ATOM   1985  O   THR   132      39.333  32.469  14.781  1.00 49.43           O  
ATOM   1986  N   GLN   133      40.726  30.729  14.580  1.00 50.15           N  
ATOM   1987  CA  GLN   133      39.804  29.751  15.042  1.00 51.36           C  
ATOM   1988  CB  GLN   133      39.566  28.845  13.853  1.00 51.63           C  
ATOM   1989  CG  GLN   133      38.130  28.484  13.637  1.00 53.97           C  
ATOM   1990  CD  GLN   133      37.756  28.356  12.227  1.00 53.78           C  
ATOM   1991  OE1 GLN   133      38.175  29.153  11.397  1.00 59.44           O  
ATOM   1992  NE2 GLN   133      36.938  27.369  11.928  1.00 52.86           N  
ATOM   1993  C   GLN   133      40.454  29.011  16.245  1.00 52.27           C  
ATOM   1994  O   GLN   133      41.479  28.275  16.099  1.00 52.37           O  
ATOM   1995  N   TYR   134      39.922  29.265  17.440  1.00 52.39           N  
ATOM   1996  CA  TYR   134      40.437  28.675  18.702  1.00 51.75           C  
ATOM   1997  CB  TYR   134      40.318  29.669  19.851  1.00 51.18           C  
ATOM   1998  CG  TYR   134      41.065  30.944  19.651  1.00 50.26           C  
ATOM   1999  CD1 TYR   134      42.380  31.067  20.050  1.00 49.80           C  
ATOM   2000  CE1 TYR   134      43.059  32.248  19.880  1.00 49.75           C  
ATOM   2001  CZ  TYR   134      42.413  33.300  19.314  1.00 50.69           C  
ATOM   2002  OH  TYR   134      43.058  34.481  19.081  1.00 49.39           O  
ATOM   2003  CE2 TYR   134      41.095  33.189  18.947  1.00 49.62           C  
ATOM   2004  CD2 TYR   134      40.439  32.040  19.126  1.00 47.46           C  
ATOM   2005  C   TYR   134      39.574  27.481  19.102  1.00 52.15           C  
ATOM   2006  O   TYR   134      38.337  27.544  19.009  1.00 52.17           O  
ATOM   2007  N   ALA   135      40.212  26.400  19.538  1.00 52.83           N  
ATOM   2008  CA  ALA   135      39.516  25.304  20.223  1.00 53.80           C  
ATOM   2009  CB  ALA   135      40.500  24.240  20.621  1.00 54.12           C  
ATOM   2010  C   ALA   135      38.835  25.828  21.475  1.00 54.42           C  
ATOM   2011  O   ALA   135      39.522  26.263  22.380  1.00 54.82           O  
ATOM   2012  N   GLY   136      37.505  25.748  21.527  1.00 55.21           N  
ATOM   2013  CA  GLY   136      36.714  26.373  22.573  1.00 56.35           C  
ATOM   2014  C   GLY   136      37.160  25.950  23.957  1.00 57.46           C  
ATOM   2015  O   GLY   136      37.420  26.786  24.822  1.00 57.55           O  
ATOM   2016  N   SER   137      37.309  24.637  24.100  1.00 58.04           N  
ATOM   2017  CA  SER   137      37.584  23.991  25.357  1.00 58.40           C  
ATOM   2018  CB  SER   137      37.448  22.498  25.147  1.00 58.31           C  
ATOM   2019  OG  SER   137      38.656  22.013  24.582  1.00 60.24           O  
ATOM   2020  C   SER   137      39.002  24.293  25.866  1.00 58.94           C  
ATOM   2021  O   SER   137      39.258  24.267  27.052  1.00 58.77           O  
ATOM   2022  N   ARG   138      39.888  24.640  24.958  1.00 59.42           N  
ATOM   2023  CA  ARG   138      41.243  24.926  25.327  1.00 59.55           C  
ATOM   2024  CB  ARG   138      42.198  24.290  24.337  1.00 59.46           C  
ATOM   2025  CG  ARG   138      42.003  22.826  24.159  1.00 60.00           C  
ATOM   2026  CD  ARG   138      43.098  22.241  23.330  1.00 62.14           C  
ATOM   2027  NE  ARG   138      42.694  20.985  22.724  1.00 63.97           N  
ATOM   2028  CZ  ARG   138      43.002  20.627  21.491  1.00 67.45           C  
ATOM   2029  NH1 ARG   138      43.725  21.426  20.738  1.00 69.16           N  
ATOM   2030  NH2 ARG   138      42.587  19.474  21.013  1.00 68.58           N  
ATOM   2031  C   ARG   138      41.529  26.394  25.390  1.00 59.70           C  
ATOM   2032  O   ARG   138      42.649  26.771  25.597  1.00 60.22           O  
ATOM   2033  N   PHE   139      40.535  27.240  25.215  1.00 20.00           N  
ATOM   2034  CA  PHE   139      40.825  28.657  25.130  1.00 20.00           C  
ATOM   2035  C   PHE   139      39.807  29.563  25.785  1.00 20.00           C  
ATOM   2036  CB  PHE   139      40.981  29.036  23.668  1.00 20.00           C  
ATOM   2037  CG  PHE   139      41.372  30.443  23.451  1.00 20.00           C  
ATOM   2038  CD1 PHE   139      42.629  30.856  23.709  1.00 20.00           C  
ATOM   2039  CD2 PHE   139      40.481  31.348  22.985  1.00 20.00           C  
ATOM   2040  CE1 PHE   139      42.978  32.133  23.514  1.00 20.00           C  
ATOM   2041  CE2 PHE   139      40.844  32.628  22.788  1.00 20.00           C  
ATOM   2042  CZ  PHE   139      42.087  33.017  23.052  1.00 20.00           C  
ATOM   2043  O   PHE   139      38.661  29.235  25.870  1.00 59.96           O  
ATOM   2044  N   GLU   140      40.271  30.708  26.243  1.00 57.79           N  
ATOM   2045  CA  GLU   140      39.471  31.798  26.743  1.00 57.81           C  
ATOM   2046  CB  GLU   140      39.561  31.827  28.276  1.00 58.32           C  
ATOM   2047  CG  GLU   140      38.980  30.633  29.001  1.00 59.77           C  
ATOM   2048  CD  GLU   140      37.468  30.477  28.805  1.00 62.71           C  
ATOM   2049  OE1 GLU   140      36.724  31.478  28.868  1.00 64.64           O  
ATOM   2050  OE2 GLU   140      37.023  29.333  28.599  1.00 65.28           O  
ATOM   2051  C   GLU   140      39.985  33.135  26.259  1.00 56.94           C  
ATOM   2052  O   GLU   140      41.120  33.419  26.418  1.00 56.93           O  
ATOM   2053  N   PHE   141      39.147  34.003  25.747  1.00 56.96           N  
ATOM   2054  CA  PHE   141      39.609  35.288  25.253  1.00 57.82           C  
ATOM   2055  CB  PHE   141      38.846  35.543  23.966  1.00 56.48           C  
ATOM   2056  CG  PHE   141      39.082  36.868  23.306  1.00 55.72           C  
ATOM   2057  CD1 PHE   141      38.557  38.039  23.831  1.00 55.21           C  
ATOM   2058  CE1 PHE   141      38.704  39.257  23.167  1.00 55.83           C  
ATOM   2059  CZ  PHE   141      39.379  39.299  21.966  1.00 56.64           C  
ATOM   2060  CE2 PHE   141      39.896  38.125  21.431  1.00 54.39           C  
ATOM   2061  CD2 PHE   141      39.704  36.928  22.074  1.00 53.44           C  
ATOM   2062  C   PHE   141      39.343  36.299  26.354  1.00 58.49           C  
ATOM   2063  O   PHE   141      38.231  36.429  26.837  1.00 59.23           O  
ATOM   2064  N   TYR   142      40.370  37.007  26.775  1.00 60.30           N  
ATOM   2065  CA  TYR   142      40.255  37.923  27.890  1.00 61.99           C  
ATOM   2066  CB  TYR   142      41.538  37.901  28.744  1.00 62.52           C  
ATOM   2067  CG  TYR   142      41.817  36.495  29.283  1.00 63.41           C  
ATOM   2068  CD1 TYR   142      41.325  36.080  30.531  1.00 64.00           C  
ATOM   2069  CE1 TYR   142      41.540  34.760  31.004  1.00 63.03           C  
ATOM   2070  CZ  TYR   142      42.240  33.858  30.210  1.00 64.94           C  
ATOM   2071  OH  TYR   142      42.453  32.567  30.644  1.00 65.69           O  
ATOM   2072  CE2 TYR   142      42.756  34.242  28.967  1.00 64.21           C  
ATOM   2073  CD2 TYR   142      42.525  35.556  28.512  1.00 65.36           C  
ATOM   2074  C   TYR   142      39.890  39.321  27.423  1.00 63.29           C  
ATOM   2075  O   TYR   142      40.614  39.943  26.715  1.00 62.80           O  
ATOM   2076  N   LEU   143      38.725  39.812  27.804  1.00 65.62           N  
ATOM   2077  CA  LEU   143      38.378  41.174  27.496  1.00 67.74           C  
ATOM   2078  CB  LEU   143      36.963  41.468  27.958  1.00 67.89           C  
ATOM   2079  CG  LEU   143      35.934  41.088  26.905  1.00 69.11           C  
ATOM   2080  CD1 LEU   143      34.698  41.872  27.213  1.00 70.90           C  
ATOM   2081  CD2 LEU   143      35.654  39.584  26.883  1.00 70.43           C  
ATOM   2082  C   LEU   143      39.336  42.175  28.113  1.00 69.39           C  
ATOM   2083  O   LEU   143      39.666  42.069  29.251  1.00 69.58           O  
ATOM   2084  N   GLU   144      39.739  43.172  27.338  1.00 72.54           N  
ATOM   2085  CA  GLU   144      40.716  44.181  27.750  1.00 74.25           C  
ATOM   2086  CB  GLU   144      41.140  45.025  26.535  1.00 75.01           C  
ATOM   2087  CG  GLU   144      42.668  45.196  26.372  1.00 78.53           C  
ATOM   2088  CD  GLU   144      43.312  44.291  25.286  1.00 81.51           C  
ATOM   2089  OE1 GLU   144      42.961  44.465  24.090  1.00 82.90           O  
ATOM   2090  OE2 GLU   144      44.194  43.440  25.625  1.00 81.58           O  
ATOM   2091  C   GLU   144      40.084  45.065  28.820  1.00 75.75           C  
ATOM   2092  O   GLU   144      38.998  45.599  28.614  1.00 75.96           O  
ATOM   2093  N   LYS   145      40.769  45.217  29.962  1.00 77.85           N  
ATOM   2094  CA  LYS   145      40.187  45.886  31.153  1.00 78.63           C  
ATOM   2095  CB  LYS   145      41.158  45.909  32.361  1.00 79.83           C  
ATOM   2096  CG  LYS   145      41.775  44.560  32.815  1.00 81.50           C  
ATOM   2097  CD  LYS   145      40.796  43.534  33.467  1.00 83.50           C  
ATOM   2098  CE  LYS   145      41.629  42.298  34.002  1.00 84.23           C  
ATOM   2099  NZ  LYS   145      40.927  40.996  34.381  1.00 83.07           N  
ATOM   2100  C   LYS   145      39.779  47.327  30.817  1.00 79.77           C  
ATOM   2101  O   LYS   145      40.647  48.168  30.548  1.00 80.23           O  
END
