
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  142 ( 1137),  selected  142 , name 2pkh_E
# Molecule2: number of CA atoms  139 ( 1121),  selected  139 , name T0455.pdb
# PARAMETERS: 2pkh_E.T0455.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   108_E      -       -           -
LGA    R   109_E      -       -           -
LGA    H   110_E      -       -           -
LGA    T   111_E      S       7          0.881
LGA    C   112_E      S       8          0.791
LGA    K   113_E      R       9          0.847
LGA    V   114_E      T      10          1.382
LGA    X   115_E      V      11          1.531
LGA    V   116_E      S      12          1.445
LGA    L   117_E      Y      13          1.759
LGA    K   118_E      F      14          1.239
LGA    E   119_E      V      15          0.943
LGA    E   120_E      A      16          0.945
LGA    A   121_E      K      17          0.827
LGA    A   122_E      P      18          0.738
LGA    G   123_E      S      19          2.301
LGA    S   124_E      S      20          1.890
LGA    E   125_E      S      21          2.292
LGA    R   126_E      E      22          0.785
LGA    A   127_E      M      23          0.806
LGA    L   128_E      E      24          1.608
LGA    A   129_E      K      25          1.810
LGA    L   130_E      L      26          0.856
LGA    D   131_E      Q      27          1.155
LGA    X   132_E      L      28          0.840
LGA    R   133_E      G      29          1.232
LGA    E   134_E      P      30          2.131
LGA    G   135_E      E      31          2.048
LGA    Q   136_E      D      32          1.454
LGA    R   137_E      S      33          0.383
LGA    V   138_E      I      34          0.350
LGA    F   139_E      L      35          0.568
LGA    H   140_E      R      36          1.235
LGA    S   141_E      M      37          1.642
LGA    L   142_E      E      38          1.422
LGA    I   143_E      R      39          1.540
LGA    V   144_E      I      40          0.909
LGA    H   145_E      R      41          0.494
LGA    F   146_E      F      42          0.386
LGA    E   147_E      A      43          0.612
LGA    N   148_E      D      44          0.962
LGA    D   149_E      D      45          0.769
LGA    I   150_E      I      46          0.550
LGA    P   151_E      P      47          0.436
LGA    V   152_E      I      48          0.225
LGA    Q   153_E      C      49          1.255
LGA    I   154_E      F      50          1.321
LGA    E   155_E      E      51          2.050
LGA    D   156_E      V      52          1.169
LGA    R   157_E      A      53          0.613
LGA    F   158_E      S      54          0.462
LGA    V   159_E      I      55          0.304
LGA    N   160_E      P      56          0.628
LGA    A   161_E      Y      57          0.905
LGA    Q   162_E      S      58          1.159
LGA    V   163_E      L      59          1.640
LGA    A   164_E      V      60          1.959
LGA    P   165_E      S      61          1.748
LGA    D   166_E      Q      62          2.638
LGA    Y   167_E      Y      63          4.247
LGA    L   168_E      G      64          4.794
LGA    K   169_E      K      65          3.123
LGA    Q   170_E      S      66          2.473
LGA    D   171_E      E      67          5.004
LGA    F   172_E      I      68          5.469
LGA    T   173_E      T      69           #
LGA    L   174_E      N      70          4.413
LGA    Q   175_E      -       -           -
LGA    T   176_E      S      71          3.870
LGA    P   177_E      F      72          2.955
LGA    Y   178_E      Y      73          3.497
LGA    A   179_E      K      74          3.498
LGA    Y   180_E      T      75          2.951
LGA    L   181_E      L      76          2.931
LGA    S   182_E      E      77          3.671
LGA    Q   183_E      A      78          3.145
LGA    V   184_E      K      79          3.667
LGA    A   185_E      S      80          3.507
LGA    -       -      G      81           -
LGA    P   186_E      H      82          2.439
LGA    L   187_E      K      83          3.760
LGA    -       -      I      84           -
LGA    T   188_E      G      85          1.378
LGA    E   189_E      H      86          1.433
LGA    G   190_E      S      87          0.914
LGA    E   191_E      N      88          0.972
LGA    H   192_E      Q      89          1.063
LGA    V   193_E      T      90          1.028
LGA    V   194_E      I      91          0.996
LGA    E   195_E      S      92          0.918
LGA    A   196_E      A      93          1.002
LGA    I   197_E      V      94          1.372
LGA    L   198_E      Q      95          2.054
LGA    A   199_E      A      96          3.648
LGA    E   200_E      S      97          3.587
LGA    A   201_E      E      98          2.958
LGA    D   202_E      Q      99          1.875
LGA    E   203_E      I     100          2.014
LGA    C   204_E      A     101          1.991
LGA    K   205_E      E     102          1.423
LGA    L   206_E      Y     103          0.860
LGA    L   207_E      L     104          0.888
LGA    Q   208_E      E     105          1.079
LGA    I   209_E      I     106          1.432
LGA    D   210_E      K     107          0.908
LGA    A   211_E      R     108          1.316
LGA    G   212_E      G     109          0.725
LGA    E   213_E      D     110          0.888
LGA    P   214_E      A     111          1.063
LGA    C   215_E      I     112          0.781
LGA    L   216_E      L     113          0.882
LGA    L   217_E      R     114          1.079
LGA    I   218_E      V     115          1.314
LGA    R   219_E      R     116          0.958
LGA    R   220_E      Q     117          1.225
LGA    R   221_E      V     118          0.869
LGA    T   222_E      S     119          0.974
LGA    W   223_E      Y     120          1.182
LGA    S   224_E      F     121          1.544
LGA    -       -      E     122           -
LGA    G   225_E      N     123          1.076
LGA    R   226_E      G     124          2.020
LGA    Q   227_E      L     125          1.331
LGA    P   228_E      P     126          0.929
LGA    V   229_E      F     127          0.988
LGA    T   230_E      E     128          1.043
LGA    A   231_E      Y     129          0.654
LGA    A   232_E      V     130          0.435
LGA    R   233_E      R     131          0.739
LGA    L   234_E      T     132          1.608
LGA    I   235_E      Q     133          1.111
LGA    H   236_E      Y     134          0.429
LGA    P   237_E      A     135          0.261
LGA    G   238_E      G     136          0.319
LGA    S   239_E      S     137          0.351
LGA    R   240_E      R     138          0.446
LGA    H   241_E      F     139          0.558
LGA    R   242_E      E     140          0.331
LGA    L   243_E      F     141          1.349
LGA    E   244_E      Y     142          2.374
LGA    G   245_E      L     143          4.227
LGA    -       -      E     144           -
LGA    R   246_E      K     145          4.346
LGA    F   247_E      -       -           -
LGA    T   248_E      -       -           -
LGA    K   249_E      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  142  139    5.0    134    1.95    17.16     87.030     6.549

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.364042 * X  +   0.094309 * Y  +  -0.926596 * Z  +   4.121435
  Y_new =  -0.829992 * X  +   0.484246 * Y  +  -0.276802 * Z  +  44.639675
  Z_new =   0.422595 * X  +   0.869834 * Y  +   0.254562 * Z  + -101.432205 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.286091   -1.855501  [ DEG:    73.6876   -106.3124 ]
  Theta =  -0.436307   -2.705286  [ DEG:   -24.9985   -155.0014 ]
  Phi   =  -1.157455    1.984137  [ DEG:   -66.3173    113.6827 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pkh_E                                        
REMARK     2: T0455.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pkh_E.T0455.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  142  139   5.0  134   1.95   17.16  87.030
REMARK  ---------------------------------------------------------- 
MOLECULE 2pkh_E
HEADER    DNA BINDING PROTEIN                     17-APR-07   2PKH              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF THE C-                  
TITLE    2 TERMINAL DOMAIN OF HISTIDINE UTILIZATION REPRESSOR FROM              
TITLE    3 PSEUDOMONAS SYRINGAE PV. TOMATO STR. DC3000                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTIDINE UTILIZATION REPRESSOR;                           
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 FRAGMENT: RESIDUES 105-249;                                          
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS SYRINGAE PV. TOMATO STR.            
SOURCE   3 DC3000;                                                              
SOURCE   4 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   5 STRAIN: DC3000;                                                      
SOURCE   6 GENE: HUTC, PSPTO5172;                                               
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG19                                   
KEYWDS    APC84836, HISTIDINE UTILIZATION REPRESSOR, PSEUDOMONAS                
KEYWDS   2 SYRINGAE PV. TOMATO STR. DC3000, STRUCTURAL GENOMICS, PSI-2,         
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   4 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,M.ZHOU,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR                 
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   15-MAY-07 2PKH    0                                                
JRNL        AUTH   K.TAN,M.ZHOU,S.CLANCY,A.JOACHIMIAK                           
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE C-TERMINAL DOMAIN OF            
JRNL        TITL 2 HISTIDINE UTILIZATION REPRESSOR FROM PSEUDOMONAS             
JRNL        TITL 3 SYRINGAE PV. TOMATO STR. DC3000.                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2PKH A  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
DBREF  2PKH B  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
DBREF  2PKH C  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
DBREF  2PKH D  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
DBREF  2PKH E  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
DBREF  2PKH F  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
DBREF  2PKH G  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
DBREF  2PKH H  105   249  UNP    Q87UX0   Q87UX0_PSESM   105    249             
SEQRES   1 A  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 A  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 A  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 A  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 A  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 A  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 A  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 A  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 A  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 A  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 A  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 A  148  GLY ARG PHE THR LYS                                          
SEQRES   1 B  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 B  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 B  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 B  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 B  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 B  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 B  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 B  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 B  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 B  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 B  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 B  148  GLY ARG PHE THR LYS                                          
SEQRES   1 C  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 C  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 C  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 C  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 C  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 C  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 C  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 C  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 C  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 C  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 C  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 C  148  GLY ARG PHE THR LYS                                          
SEQRES   1 D  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 D  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 D  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 D  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 D  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 D  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 D  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 D  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 D  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 D  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 D  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 D  148  GLY ARG PHE THR LYS                                          
SEQRES   1 E  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 E  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 E  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 E  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 E  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 E  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 E  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 E  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 E  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 E  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 E  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 E  148  GLY ARG PHE THR LYS                                          
SEQRES   1 F  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 F  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 F  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 F  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 F  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 F  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 F  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 F  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 F  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 F  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 F  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 F  148  GLY ARG PHE THR LYS                                          
SEQRES   1 G  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 G  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 G  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 G  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 G  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 G  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 G  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 G  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 G  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 G  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 G  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 G  148  GLY ARG PHE THR LYS                                          
SEQRES   1 H  148  SER ASN ALA ALA ARG GLY HIS ARG HIS THR CYS LYS VAL          
SEQRES   2 H  148  MSE VAL LEU LYS GLU GLU ALA ALA GLY SER GLU ARG ALA          
SEQRES   3 H  148  LEU ALA LEU ASP MSE ARG GLU GLY GLN ARG VAL PHE HIS          
SEQRES   4 H  148  SER LEU ILE VAL HIS PHE GLU ASN ASP ILE PRO VAL GLN          
SEQRES   5 H  148  ILE GLU ASP ARG PHE VAL ASN ALA GLN VAL ALA PRO ASP          
SEQRES   6 H  148  TYR LEU LYS GLN ASP PHE THR LEU GLN THR PRO TYR ALA          
SEQRES   7 H  148  TYR LEU SER GLN VAL ALA PRO LEU THR GLU GLY GLU HIS          
SEQRES   8 H  148  VAL VAL GLU ALA ILE LEU ALA GLU ALA ASP GLU CYS LYS          
SEQRES   9 H  148  LEU LEU GLN ILE ASP ALA GLY GLU PRO CYS LEU LEU ILE          
SEQRES  10 H  148  ARG ARG ARG THR TRP SER GLY ARG GLN PRO VAL THR ALA          
SEQRES  11 H  148  ALA ARG LEU ILE HIS PRO GLY SER ARG HIS ARG LEU GLU          
SEQRES  12 H  148  GLY ARG PHE THR LYS                                          
HET    MSE  A 115       8                                                       
HET    MSE  A 132       8                                                       
HET    MSE  B 115       8                                                       
HET    MSE  B 132       8                                                       
HET    MSE  C 115       8                                                       
HET    MSE  C 132       8                                                       
HET    MSE  D 115       8                                                       
HET    MSE  D 132       8                                                       
HET    MSE  E 115       8                                                       
HET    MSE  E 132       8                                                       
HET    MSE  F 115       8                                                       
HET    MSE  F 132       8                                                       
HET    MSE  G 115       8                                                       
HET    MSE  G 132       8                                                       
HET    MSE  H 115       8                                                       
HET    MSE  H 132       8                                                       
HET    EDO   1001       4                                                       
HET    EDO   1002       4                                                       
HET    EDO   1003       4                                                       
HET    EDO   1004       4                                                       
HET    EDO   1005       4                                                       
HET    EDO   1006       4                                                       
HET    EDO   1007       4                                                       
HET    EDO   1008       4                                                       
HET    EDO   1009       4                                                       
HET    EDO   1010       4                                                       
HET    EDO   1011       4                                                       
HET    EDO   1012       4                                                       
HET    EDO   1013       4                                                       
HET    EDO   1014       4                                                       
HET    EDO   1015       4                                                       
HET    EDO   1016       4                                                       
HET    EDO   1017       4                                                       
HET    EDO   1018       4                                                       
HET    EDO   1019       4                                                       
HET    EDO   1020       4                                                       
HET    EDO   1021       4                                                       
HET    EDO   1022       4                                                       
HET    EDO   1023       4                                                       
HET    EDO   1024       4                                                       
HET    EDO   1025       4                                                       
HET    EDO   1026       4                                                       
HET    EDO   1027       4                                                       
HET    EDO   1028       4                                                       
HET    EDO   1029       4                                                       
HET    EDO   1030       4                                                       
HET    EDO   1031       4                                                       
HET    EDO   1032       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   9  EDO    32(C2 H6 O2)                                                 
FORMUL  41  HOH   *931(H2 O)                                                    
CRYST1  100.845  100.955  130.187  90.00  90.00  90.00 P 21 21 21   32          
ATOM   4533  N   HIS E 108      53.154  26.793  30.629  1.00 60.75           N  
ATOM   4534  CA  HIS E 108      52.876  26.237  29.268  1.00 61.02           C  
ATOM   4535  C   HIS E 108      54.174  26.231  28.442  1.00 59.89           C  
ATOM   4536  O   HIS E 108      54.873  27.252  28.399  1.00 60.63           O  
ATOM   4537  CB  HIS E 108      51.834  27.098  28.519  1.00 61.70           C  
ATOM   4538  CG  HIS E 108      50.595  27.429  29.308  1.00 65.00           C  
ATOM   4539  ND1 HIS E 108      49.338  26.991  28.938  1.00 68.41           N  
ATOM   4540  CD2 HIS E 108      50.412  28.190  30.417  1.00 67.74           C  
ATOM   4541  CE1 HIS E 108      48.441  27.442  29.799  1.00 68.75           C  
ATOM   4542  NE2 HIS E 108      49.065  28.172  30.708  1.00 69.33           N  
ATOM   4543  N   ARG E 109      54.515  25.114  27.793  1.00 57.77           N  
ATOM   4544  CA  ARG E 109      55.561  25.161  26.753  1.00 56.03           C  
ATOM   4545  C   ARG E 109      54.959  25.596  25.388  1.00 54.47           C  
ATOM   4546  O   ARG E 109      54.354  24.788  24.675  1.00 54.39           O  
ATOM   4547  CB  ARG E 109      56.328  23.830  26.638  1.00 56.09           C  
ATOM   4548  CG  ARG E 109      57.263  23.504  27.828  1.00 56.81           C  
ATOM   4549  CD  ARG E 109      57.678  22.024  27.906  1.00 56.70           C  
ATOM   4550  NE  ARG E 109      56.521  21.162  27.704  1.00 58.84           N  
ATOM   4551  CZ  ARG E 109      56.174  20.612  26.541  1.00 60.08           C  
ATOM   4552  NH1 ARG E 109      56.919  20.798  25.451  1.00 60.83           N  
ATOM   4553  NH2 ARG E 109      55.082  19.860  26.469  1.00 60.15           N  
ATOM   4554  N   HIS E 110      55.123  26.875  25.050  1.00 52.01           N  
ATOM   4555  CA  HIS E 110      54.560  27.451  23.819  1.00 50.39           C  
ATOM   4556  C   HIS E 110      55.448  27.209  22.603  1.00 47.49           C  
ATOM   4557  O   HIS E 110      56.649  27.499  22.637  1.00 47.39           O  
ATOM   4558  CB  HIS E 110      54.318  28.955  23.977  1.00 51.59           C  
ATOM   4559  CG  HIS E 110      53.268  29.304  24.992  1.00 56.06           C  
ATOM   4560  ND1 HIS E 110      52.061  29.887  24.648  1.00 59.54           N  
ATOM   4561  CD2 HIS E 110      53.247  29.166  26.346  1.00 59.68           C  
ATOM   4562  CE1 HIS E 110      51.342  30.084  25.742  1.00 61.01           C  
ATOM   4563  NE2 HIS E 110      52.034  29.652  26.785  1.00 60.35           N  
ATOM   4564  N   THR E 111      54.853  26.668  21.536  1.00 43.66           N  
ATOM   4565  CA  THR E 111      55.532  26.459  20.253  1.00 39.49           C  
ATOM   4566  C   THR E 111      54.589  26.731  19.071  1.00 37.08           C  
ATOM   4567  O   THR E 111      53.359  26.704  19.222  1.00 34.30           O  
ATOM   4568  CB  THR E 111      56.015  25.008  20.090  1.00 39.70           C  
ATOM   4569  OG1 THR E 111      54.891  24.122  20.181  1.00 38.21           O  
ATOM   4570  CG2 THR E 111      57.075  24.640  21.173  1.00 39.68           C  
ATOM   4571  N   CYS E 112      55.188  26.927  17.899  1.00 34.91           N  
ATOM   4572  CA  CYS E 112      54.424  27.210  16.687  1.00 33.79           C  
ATOM   4573  C   CYS E 112      55.036  26.602  15.415  1.00 32.51           C  
ATOM   4574  O   CYS E 112      56.194  26.208  15.396  1.00 31.47           O  
ATOM   4575  CB  CYS E 112      54.163  28.715  16.536  1.00 34.33           C  
ATOM   4576  SG  CYS E 112      55.554  29.703  15.887  1.00 37.19           S  
ATOM   4577  N   LYS E 113      54.209  26.483  14.387  1.00 30.64           N  
ATOM   4578  CA  LYS E 113      54.591  25.936  13.102  1.00 31.44           C  
ATOM   4579  C   LYS E 113      53.964  26.846  12.058  1.00 28.05           C  
ATOM   4580  O   LYS E 113      52.762  27.102  12.120  1.00 27.06           O  
ATOM   4581  CB  LYS E 113      54.020  24.533  12.948  1.00 32.80           C  
ATOM   4582  CG  LYS E 113      54.825  23.616  11.996  1.00 36.36           C  
ATOM   4583  CD  LYS E 113      54.444  22.129  12.149  1.00 35.49           C  
ATOM   4584  CE  LYS E 113      55.350  21.246  11.242  1.00 37.29           C  
ATOM   4585  NZ  LYS E 113      54.633  20.014  10.744  1.00 39.29           N  
ATOM   4586  N   VAL E 114      54.789  27.381  11.172  1.00 26.43           N  
ATOM   4587  CA  VAL E 114      54.346  28.195  10.051  1.00 24.74           C  
ATOM   4588  C   VAL E 114      53.942  27.241   8.920  1.00 25.19           C  
ATOM   4589  O   VAL E 114      54.808  26.596   8.278  1.00 23.98           O  
ATOM   4590  CB  VAL E 114      55.498  29.117   9.509  1.00 24.72           C  
ATOM   4591  CG1 VAL E 114      55.034  29.992   8.341  1.00 21.05           C  
ATOM   4592  CG2 VAL E 114      56.013  30.054  10.579  1.00 27.48           C  
HETATM 4593  N   MSE E 115      52.659  27.167   8.621  1.00 23.65           N  
HETATM 4594  CA  MSE E 115      52.205  26.133   7.655  1.00 23.79           C  
HETATM 4595  C   MSE E 115      52.168  26.748   6.253  1.00 24.99           C  
HETATM 4596  O   MSE E 115      52.199  26.010   5.268  1.00 24.25           O  
HETATM 4597  CB  MSE E 115      50.788  25.633   7.959  1.00 23.98           C  
HETATM 4598  CG  MSE E 115      50.505  25.065   9.306  1.00 30.35           C  
HETATM 4599 SE   MSE E 115      51.444  23.388   9.437  0.80 41.73          SE  
HETATM 4600  CE  MSE E 115      52.912  24.260  10.219  1.00 43.73           C  
ATOM   4601  N   VAL E 116      51.941  28.063   6.156  1.00 21.09           N  
ATOM   4602  CA  VAL E 116      51.717  28.635   4.800  1.00 22.86           C  
ATOM   4603  C   VAL E 116      52.469  29.941   4.862  1.00 22.32           C  
ATOM   4604  O   VAL E 116      52.429  30.627   5.847  1.00 20.95           O  
ATOM   4605  CB  VAL E 116      50.233  28.866   4.519  1.00 23.42           C  
ATOM   4606  CG1 VAL E 116      50.010  29.680   3.191  1.00 23.90           C  
ATOM   4607  CG2 VAL E 116      49.401  27.567   4.587  1.00 22.28           C  
ATOM   4608  N   LEU E 117      53.243  30.263   3.844  1.00 22.89           N  
ATOM   4609  CA  LEU E 117      53.754  31.615   3.793  1.00 22.16           C  
ATOM   4610  C   LEU E 117      53.918  31.847   2.299  1.00 22.52           C  
ATOM   4611  O   LEU E 117      54.943  31.470   1.718  1.00 20.48           O  
ATOM   4612  CB  LEU E 117      55.092  31.758   4.543  1.00 22.59           C  
ATOM   4613  CG  LEU E 117      55.932  33.045   4.523  1.00 22.91           C  
ATOM   4614  CD1 LEU E 117      55.088  34.199   5.058  1.00 23.24           C  
ATOM   4615  CD2 LEU E 117      57.247  32.952   5.367  1.00 22.92           C  
ATOM   4616  N   LYS E 118      52.951  32.521   1.676  1.00 20.64           N  
ATOM   4617  CA  LYS E 118      53.086  32.659   0.232  1.00 21.66           C  
ATOM   4618  C   LYS E 118      52.408  33.927  -0.268  1.00 22.13           C  
ATOM   4619  O   LYS E 118      51.531  34.531   0.439  1.00 18.88           O  
ATOM   4620  CB  LYS E 118      52.442  31.424  -0.420  1.00 21.63           C  
ATOM   4621  CG  LYS E 118      50.875  31.259  -0.289  1.00 21.73           C  
ATOM   4622  CD  LYS E 118      50.516  29.900  -0.725  1.00 24.15           C  
ATOM   4623  CE  LYS E 118      49.032  29.638  -0.725  1.00 31.82           C  
ATOM   4624  NZ  LYS E 118      48.175  30.585  -1.520  1.00 27.19           N  
ATOM   4625  N   GLU E 119      52.800  34.303  -1.488  1.00 20.09           N  
ATOM   4626  CA  GLU E 119      52.088  35.363  -2.189  1.00 21.15           C  
ATOM   4627  C   GLU E 119      50.887  34.815  -2.975  1.00 21.94           C  
ATOM   4628  O   GLU E 119      50.970  33.711  -3.547  1.00 21.59           O  
ATOM   4629  CB  GLU E 119      53.019  36.021  -3.180  1.00 20.56           C  
ATOM   4630  CG  GLU E 119      52.385  37.253  -3.897  1.00 21.18           C  
ATOM   4631  CD  GLU E 119      53.353  37.908  -4.870  1.00 24.63           C  
ATOM   4632  OE1 GLU E 119      54.591  37.788  -4.705  1.00 25.27           O  
ATOM   4633  OE2 GLU E 119      52.865  38.512  -5.838  1.00 23.11           O  
ATOM   4634  N   GLU E 120      49.804  35.576  -3.067  1.00 21.70           N  
ATOM   4635  CA  GLU E 120      48.627  35.133  -3.845  1.00 24.47           C  
ATOM   4636  C   GLU E 120      47.746  36.321  -4.230  1.00 22.94           C  
ATOM   4637  O   GLU E 120      48.036  37.405  -3.772  1.00 22.61           O  
ATOM   4638  CB  GLU E 120      47.847  34.153  -2.975  1.00 24.83           C  
ATOM   4639  CG  GLU E 120      47.374  34.714  -1.678  1.00 28.17           C  
ATOM   4640  CD  GLU E 120      46.711  33.655  -0.787  1.00 26.70           C  
ATOM   4641  OE1 GLU E 120      47.317  32.608  -0.525  1.00 29.68           O  
ATOM   4642  OE2 GLU E 120      45.623  33.920  -0.282  1.00 23.87           O  
ATOM   4643  N   ALA E 121      46.746  36.137  -5.113  1.00 23.99           N  
ATOM   4644  CA  ALA E 121      45.811  37.229  -5.472  1.00 23.71           C  
ATOM   4645  C   ALA E 121      44.959  37.547  -4.267  1.00 23.66           C  
ATOM   4646  O   ALA E 121      44.592  36.637  -3.519  1.00 23.15           O  
ATOM   4647  CB  ALA E 121      44.875  36.828  -6.581  1.00 23.41           C  
ATOM   4648  N   ALA E 122      44.564  38.825  -4.097  1.00 22.27           N  
ATOM   4649  CA  ALA E 122      43.626  39.115  -3.029  1.00 21.10           C  
ATOM   4650  C   ALA E 122      42.341  38.280  -3.253  1.00 22.72           C  
ATOM   4651  O   ALA E 122      41.826  37.655  -2.298  1.00 23.62           O  
ATOM   4652  CB  ALA E 122      43.306  40.613  -3.006  1.00 21.75           C  
ATOM   4653  N   GLY E 123      41.810  38.229  -4.487  1.00 23.65           N  
ATOM   4654  CA  GLY E 123      40.535  37.541  -4.705  1.00 23.10           C  
ATOM   4655  C   GLY E 123      39.395  38.251  -4.000  1.00 22.73           C  
ATOM   4656  O   GLY E 123      39.573  39.388  -3.490  1.00 19.96           O  
ATOM   4657  N   SER E 124      38.198  37.640  -3.986  1.00 21.22           N  
ATOM   4658  CA  SER E 124      37.024  38.350  -3.592  1.00 21.93           C  
ATOM   4659  C   SER E 124      36.948  38.665  -2.069  1.00 22.13           C  
ATOM   4660  O   SER E 124      36.456  39.710  -1.676  1.00 22.54           O  
ATOM   4661  CB  SER E 124      35.769  37.565  -4.088  1.00 22.75           C  
ATOM   4662  OG  SER E 124      35.857  36.245  -3.531  1.00 25.57           O  
ATOM   4663  N   GLU E 125      37.427  37.773  -1.212  1.00 22.43           N  
ATOM   4664  CA  GLU E 125      37.326  37.988   0.221  1.00 23.52           C  
ATOM   4665  C   GLU E 125      38.315  39.027   0.713  1.00 22.56           C  
ATOM   4666  O   GLU E 125      37.951  39.843   1.499  1.00 21.99           O  
ATOM   4667  CB  GLU E 125      37.532  36.674   1.050  1.00 23.57           C  
ATOM   4668  CG  GLU E 125      37.124  36.941   2.565  1.00 27.23           C  
ATOM   4669  CD  GLU E 125      37.118  35.654   3.402  1.00 28.33           C  
ATOM   4670  OE1 GLU E 125      36.833  34.636   2.836  1.00 31.00           O  
ATOM   4671  OE2 GLU E 125      37.479  35.683   4.614  1.00 40.21           O  
ATOM   4672  N   ARG E 126      39.583  38.950   0.309  1.00 21.24           N  
ATOM   4673  CA  ARG E 126      40.586  39.942   0.747  1.00 22.16           C  
ATOM   4674  C   ARG E 126      40.373  41.276   0.181  1.00 23.65           C  
ATOM   4675  O   ARG E 126      40.768  42.256   0.808  1.00 24.26           O  
ATOM   4676  CB  ARG E 126      42.014  39.520   0.367  1.00 22.33           C  
ATOM   4677  CG  ARG E 126      42.716  38.908   1.572  1.00 26.97           C  
ATOM   4678  CD  ARG E 126      42.622  37.445   1.324  1.00 39.78           C  
ATOM   4679  NE  ARG E 126      41.624  36.804   2.082  1.00 38.49           N  
ATOM   4680  CZ  ARG E 126      41.217  35.572   1.848  1.00 39.72           C  
ATOM   4681  NH1 ARG E 126      40.290  35.076   2.653  1.00 37.10           N  
ATOM   4682  NH2 ARG E 126      41.661  34.861   0.822  1.00 38.13           N  
ATOM   4683  N   ALA E 127      39.800  41.336  -1.023  1.00 23.31           N  
ATOM   4684  CA  ALA E 127      39.338  42.608  -1.564  1.00 25.18           C  
ATOM   4685  C   ALA E 127      38.371  43.329  -0.624  1.00 25.95           C  
ATOM   4686  O   ALA E 127      38.489  44.538  -0.369  1.00 26.13           O  
ATOM   4687  CB  ALA E 127      38.689  42.398  -2.909  1.00 23.71           C  
ATOM   4688  N   LEU E 128      37.397  42.603  -0.104  1.00 26.84           N  
ATOM   4689  CA  LEU E 128      36.493  43.195   0.877  1.00 28.44           C  
ATOM   4690  C   LEU E 128      37.177  43.541   2.216  1.00 28.25           C  
ATOM   4691  O   LEU E 128      37.021  44.628   2.754  1.00 29.51           O  
ATOM   4692  CB  LEU E 128      35.357  42.179   1.139  1.00 30.02           C  
ATOM   4693  CG  LEU E 128      34.294  41.994   0.058  1.00 32.10           C  
ATOM   4694  CD1 LEU E 128      33.044  41.215   0.578  1.00 31.69           C  
ATOM   4695  CD2 LEU E 128      33.864  43.352  -0.414  1.00 33.61           C  
ATOM   4696  N   ALA E 129      37.936  42.592   2.733  1.00 27.73           N  
ATOM   4697  CA  ALA E 129      38.615  42.692   4.009  1.00 28.41           C  
ATOM   4698  C   ALA E 129      39.624  43.845   4.037  1.00 28.20           C  
ATOM   4699  O   ALA E 129      39.663  44.594   5.024  1.00 28.12           O  
ATOM   4700  CB  ALA E 129      39.292  41.312   4.340  1.00 28.10           C  
ATOM   4701  N   LEU E 130      40.377  44.063   2.945  1.00 26.15           N  
ATOM   4702  CA  LEU E 130      41.472  45.039   2.959  1.00 25.72           C  
ATOM   4703  C   LEU E 130      41.300  46.211   1.975  1.00 26.06           C  
ATOM   4704  O   LEU E 130      42.242  46.893   1.651  1.00 24.89           O  
ATOM   4705  CB  LEU E 130      42.790  44.328   2.702  1.00 26.07           C  
ATOM   4706  CG  LEU E 130      43.209  43.253   3.729  1.00 27.04           C  
ATOM   4707  CD1 LEU E 130      44.361  42.453   3.155  1.00 25.67           C  
ATOM   4708  CD2 LEU E 130      43.668  43.927   5.000  1.00 28.93           C  
ATOM   4709  N   ASP E 131      40.079  46.397   1.492  1.00 27.51           N  
ATOM   4710  CA  ASP E 131      39.753  47.469   0.523  1.00 28.02           C  
ATOM   4711  C   ASP E 131      40.719  47.498  -0.649  1.00 28.45           C  
ATOM   4712  O   ASP E 131      41.299  48.540  -0.981  1.00 29.32           O  
ATOM   4713  CB  ASP E 131      39.674  48.834   1.214  1.00 29.80           C  
ATOM   4714  CG  ASP E 131      38.996  49.918   0.315  1.00 34.35           C  
ATOM   4715  OD1 ASP E 131      37.994  49.606  -0.383  1.00 40.64           O  
ATOM   4716  OD2 ASP E 131      39.458  51.067   0.328  1.00 36.62           O  
HETATM 4717  N   MSE E 132      40.876  46.346  -1.282  1.00 26.20           N  
HETATM 4718  CA  MSE E 132      41.812  46.193  -2.358  1.00 27.60           C  
HETATM 4719  C   MSE E 132      41.010  45.747  -3.564  1.00 24.73           C  
HETATM 4720  O   MSE E 132      39.868  45.333  -3.403  1.00 24.05           O  
HETATM 4721  CB  MSE E 132      42.808  45.061  -2.004  1.00 26.32           C  
HETATM 4722  CG  MSE E 132      43.635  45.354  -0.772  1.00 30.94           C  
HETATM 4723 SE   MSE E 132      44.921  43.917  -0.347  0.95 37.15          SE  
HETATM 4724  CE  MSE E 132      43.990  42.595  -1.367  1.00 40.87           C  
ATOM   4725  N   ARG E 133      41.644  45.737  -4.730  1.00 23.93           N  
ATOM   4726  CA  ARG E 133      41.065  45.104  -5.921  1.00 23.19           C  
ATOM   4727  C   ARG E 133      41.429  43.600  -5.904  1.00 22.00           C  
ATOM   4728  O   ARG E 133      42.476  43.224  -5.373  1.00 20.06           O  
ATOM   4729  CB  ARG E 133      41.628  45.723  -7.162  1.00 22.82           C  
ATOM   4730  CG  ARG E 133      41.157  47.234  -7.244  1.00 27.21           C  
ATOM   4731  CD  ARG E 133      41.847  48.021  -8.206  1.00 31.38           C  
ATOM   4732  NE  ARG E 133      41.744  49.424  -7.831  1.00 35.07           N  
ATOM   4733  CZ  ARG E 133      42.655  50.096  -7.116  1.00 40.85           C  
ATOM   4734  NH1 ARG E 133      43.778  49.514  -6.680  1.00 40.30           N  
ATOM   4735  NH2 ARG E 133      42.459  51.375  -6.866  1.00 41.27           N  
ATOM   4736  N   GLU E 134      40.578  42.791  -6.536  1.00 19.40           N  
ATOM   4737  CA  GLU E 134      40.716  41.347  -6.447  1.00 20.59           C  
ATOM   4738  C   GLU E 134      42.040  40.815  -7.066  1.00 19.93           C  
ATOM   4739  O   GLU E 134      42.543  39.786  -6.641  1.00 18.44           O  
ATOM   4740  CB  GLU E 134      39.473  40.665  -7.080  1.00 19.72           C  
ATOM   4741  CG  GLU E 134      38.149  41.195  -6.459  1.00 21.59           C  
ATOM   4742  CD  GLU E 134      36.905  40.362  -6.772  1.00 22.71           C  
ATOM   4743  OE1 GLU E 134      37.037  39.372  -7.533  1.00 24.10           O  
ATOM   4744  OE2 GLU E 134      35.806  40.694  -6.264  1.00 22.09           O  
ATOM   4745  N   GLY E 135      42.611  41.531  -8.038  1.00 19.55           N  
ATOM   4746  CA  GLY E 135      43.857  41.075  -8.692  1.00 21.13           C  
ATOM   4747  C   GLY E 135      45.124  41.648  -8.059  1.00 21.34           C  
ATOM   4748  O   GLY E 135      46.261  41.297  -8.442  1.00 20.59           O  
ATOM   4749  N   GLN E 136      44.961  42.457  -7.031  1.00 22.25           N  
ATOM   4750  CA  GLN E 136      46.154  42.923  -6.305  1.00 26.00           C  
ATOM   4751  C   GLN E 136      46.762  41.748  -5.496  1.00 24.92           C  
ATOM   4752  O   GLN E 136      46.052  40.814  -5.149  1.00 24.33           O  
ATOM   4753  CB  GLN E 136      45.841  44.118  -5.385  1.00 26.71           C  
ATOM   4754  CG  GLN E 136      45.654  45.393  -6.243  1.00 30.28           C  
ATOM   4755  CD  GLN E 136      45.283  46.628  -5.454  1.00 30.47           C  
ATOM   4756  OE1 GLN E 136      44.565  46.555  -4.447  1.00 30.52           O  
ATOM   4757  NE2 GLN E 136      45.758  47.808  -5.939  1.00 35.73           N  
ATOM   4758  N   ARG E 137      48.061  41.799  -5.243  1.00 22.91           N  
ATOM   4759  CA  ARG E 137      48.750  40.677  -4.558  1.00 23.10           C  
ATOM   4760  C   ARG E 137      48.711  40.862  -3.071  1.00 21.99           C  
ATOM   4761  O   ARG E 137      48.808  42.012  -2.578  1.00 22.25           O  
ATOM   4762  CB  ARG E 137      50.212  40.572  -5.047  1.00 22.95           C  
ATOM   4763  CG  ARG E 137      50.325  40.637  -6.611  1.00 24.29           C  
ATOM   4764  CD  ARG E 137      49.577  39.494  -7.327  1.00 21.61           C  
ATOM   4765  NE  ARG E 137      50.251  38.251  -7.048  1.00 24.91           N  
ATOM   4766  CZ  ARG E 137      49.749  37.059  -7.347  1.00 25.85           C  
ATOM   4767  NH1 ARG E 137      48.575  36.999  -7.939  1.00 25.10           N  
ATOM   4768  NH2 ARG E 137      50.426  35.954  -7.051  1.00 20.62           N  
ATOM   4769  N   VAL E 138      48.529  39.758  -2.345  1.00 21.21           N  
ATOM   4770  CA  VAL E 138      48.641  39.820  -0.923  1.00 21.89           C  
ATOM   4771  C   VAL E 138      49.690  38.814  -0.471  1.00 22.86           C  
ATOM   4772  O   VAL E 138      50.061  37.892  -1.255  1.00 22.22           O  
ATOM   4773  CB  VAL E 138      47.298  39.474  -0.179  1.00 22.73           C  
ATOM   4774  CG1 VAL E 138      46.329  40.582  -0.336  1.00 25.89           C  
ATOM   4775  CG2 VAL E 138      46.731  38.182  -0.689  1.00 21.64           C  
ATOM   4776  N   PHE E 139      50.190  38.970   0.763  1.00 22.45           N  
ATOM   4777  CA  PHE E 139      50.985  37.859   1.363  1.00 23.07           C  
ATOM   4778  C   PHE E 139      50.103  37.170   2.378  1.00 23.49           C  
ATOM   4779  O   PHE E 139      49.209  37.792   2.972  1.00 24.60           O  
ATOM   4780  CB  PHE E 139      52.277  38.358   1.992  1.00 23.31           C  
ATOM   4781  CG  PHE E 139      53.230  38.989   1.012  1.00 25.38           C  
ATOM   4782  CD1 PHE E 139      53.478  38.405  -0.228  1.00 24.81           C  
ATOM   4783  CD2 PHE E 139      53.913  40.148   1.356  1.00 27.66           C  
ATOM   4784  CE1 PHE E 139      54.403  39.016  -1.124  1.00 29.69           C  
ATOM   4785  CE2 PHE E 139      54.805  40.761   0.493  1.00 26.99           C  
ATOM   4786  CZ  PHE E 139      55.061  40.178  -0.758  1.00 26.94           C  
ATOM   4787  N   HIS E 140      50.301  35.881   2.543  1.00 23.19           N  
ATOM   4788  CA  HIS E 140      49.439  35.061   3.364  1.00 23.25           C  
ATOM   4789  C   HIS E 140      50.344  34.176   4.218  1.00 24.31           C  
ATOM   4790  O   HIS E 140      51.184  33.420   3.685  1.00 25.49           O  
ATOM   4791  CB  HIS E 140      48.636  34.190   2.434  1.00 22.97           C  
ATOM   4792  CG  HIS E 140      47.660  33.275   3.109  1.00 22.89           C  
ATOM   4793  ND1 HIS E 140      47.043  32.240   2.432  1.00 24.03           N  
ATOM   4794  CD2 HIS E 140      47.192  33.226   4.386  1.00 23.89           C  
ATOM   4795  CE1 HIS E 140      46.271  31.561   3.264  1.00 24.90           C  
ATOM   4796  NE2 HIS E 140      46.303  32.173   4.446  1.00 25.16           N  
ATOM   4797  N   SER E 141      50.149  34.271   5.537  1.00 25.46           N  
ATOM   4798  CA  SER E 141      50.784  33.376   6.485  1.00 24.95           C  
ATOM   4799  C   SER E 141      49.721  32.580   7.256  1.00 25.79           C  
ATOM   4800  O   SER E 141      48.637  33.067   7.563  1.00 24.73           O  
ATOM   4801  CB  SER E 141      51.755  34.155   7.375  1.00 26.26           C  
ATOM   4802  OG  SER E 141      51.138  35.212   8.060  1.00 27.48           O  
ATOM   4803  N   LEU E 142      49.990  31.317   7.540  1.00 23.72           N  
ATOM   4804  CA  LEU E 142      49.062  30.645   8.415  1.00 23.49           C  
ATOM   4805  C   LEU E 142      49.916  29.946   9.428  1.00 22.87           C  
ATOM   4806  O   LEU E 142      50.762  29.191   9.049  1.00 21.40           O  
ATOM   4807  CB  LEU E 142      48.278  29.600   7.598  1.00 24.68           C  
ATOM   4808  CG  LEU E 142      47.078  28.950   8.335  1.00 26.91           C  
ATOM   4809  CD1 LEU E 142      46.128  28.461   7.274  1.00 27.13           C  
ATOM   4810  CD2 LEU E 142      47.561  27.789   9.145  1.00 27.87           C  
ATOM   4811  N   ILE E 143      49.674  30.167  10.710  1.00 23.89           N  
ATOM   4812  CA  ILE E 143      50.590  29.676  11.701  1.00 23.67           C  
ATOM   4813  C   ILE E 143      49.705  28.962  12.642  1.00 24.37           C  
ATOM   4814  O   ILE E 143      48.635  29.498  13.012  1.00 24.19           O  
ATOM   4815  CB  ILE E 143      51.354  30.815  12.447  1.00 24.07           C  
ATOM   4816  CG1 ILE E 143      52.267  31.613  11.517  1.00 23.70           C  
ATOM   4817  CG2 ILE E 143      52.271  30.218  13.582  1.00 22.12           C  
ATOM   4818  CD1 ILE E 143      52.862  32.858  12.215  1.00 27.75           C  
ATOM   4819  N   VAL E 144      50.181  27.812  13.104  1.00 22.90           N  
ATOM   4820  CA  VAL E 144      49.527  27.037  14.187  1.00 24.38           C  
ATOM   4821  C   VAL E 144      50.354  27.168  15.480  1.00 25.93           C  
ATOM   4822  O   VAL E 144      51.598  26.968  15.470  1.00 26.96           O  
ATOM   4823  CB  VAL E 144      49.347  25.600  13.840  1.00 24.27           C  
ATOM   4824  CG1 VAL E 144      48.633  24.817  15.047  1.00 22.70           C  
ATOM   4825  CG2 VAL E 144      48.460  25.493  12.583  1.00 27.69           C  
ATOM   4826  N   HIS E 145      49.676  27.510  16.569  1.00 25.25           N  
ATOM   4827  CA  HIS E 145      50.304  27.639  17.876  1.00 27.11           C  
ATOM   4828  C   HIS E 145      49.857  26.493  18.755  1.00 27.19           C  
ATOM   4829  O   HIS E 145      48.691  26.150  18.741  1.00 25.95           O  
ATOM   4830  CB  HIS E 145      49.882  28.959  18.549  1.00 26.50           C  
ATOM   4831  CG  HIS E 145      50.371  30.183  17.821  1.00 32.04           C  
ATOM   4832  ND1 HIS E 145      51.653  30.673  17.973  1.00 35.52           N  
ATOM   4833  CD2 HIS E 145      49.763  30.988  16.910  1.00 31.45           C  
ATOM   4834  CE1 HIS E 145      51.802  31.743  17.207  1.00 37.11           C  
ATOM   4835  NE2 HIS E 145      50.668  31.963  16.563  1.00 31.38           N  
ATOM   4836  N   PHE E 146      50.810  25.953  19.527  1.00 27.33           N  
ATOM   4837  CA  PHE E 146      50.644  24.832  20.425  1.00 28.17           C  
ATOM   4838  C   PHE E 146      50.997  25.235  21.865  1.00 29.12           C  
ATOM   4839  O   PHE E 146      51.924  26.053  22.073  1.00 27.35           O  
ATOM   4840  CB  PHE E 146      51.648  23.752  20.005  1.00 25.72           C  
ATOM   4841  CG  PHE E 146      51.479  23.278  18.592  1.00 27.42           C  
ATOM   4842  CD1 PHE E 146      50.682  22.167  18.302  1.00 29.36           C  
ATOM   4843  CD2 PHE E 146      52.129  23.900  17.545  1.00 23.58           C  
ATOM   4844  CE1 PHE E 146      50.511  21.731  16.999  1.00 28.22           C  
ATOM   4845  CE2 PHE E 146      51.955  23.444  16.212  1.00 27.38           C  
ATOM   4846  CZ  PHE E 146      51.166  22.385  15.942  1.00 25.39           C  
ATOM   4847  N   GLU E 147      50.267  24.674  22.840  1.00 31.38           N  
ATOM   4848  CA  GLU E 147      50.646  24.750  24.247  1.00 35.48           C  
ATOM   4849  C   GLU E 147      50.797  23.298  24.707  1.00 35.35           C  
ATOM   4850  O   GLU E 147      49.875  22.491  24.530  1.00 35.79           O  
ATOM   4851  CB  GLU E 147      49.628  25.493  25.089  1.00 35.15           C  
ATOM   4852  CG  GLU E 147      49.565  27.008  24.831  1.00 39.79           C  
ATOM   4853  CD  GLU E 147      48.340  27.679  25.494  1.00 41.32           C  
ATOM   4854  OE1 GLU E 147      47.730  27.051  26.408  1.00 48.95           O  
ATOM   4855  OE2 GLU E 147      47.987  28.833  25.106  1.00 47.07           O  
ATOM   4856  N   ASN E 148      51.966  22.964  25.260  1.00 36.23           N  
ATOM   4857  CA  ASN E 148      52.352  21.559  25.555  1.00 36.74           C  
ATOM   4858  C   ASN E 148      51.961  20.644  24.381  1.00 36.05           C  
ATOM   4859  O   ASN E 148      51.325  19.597  24.581  1.00 36.01           O  
ATOM   4860  CB  ASN E 148      51.754  21.027  26.896  1.00 37.47           C  
ATOM   4861  CG  ASN E 148      51.980  21.983  28.078  1.00 40.89           C  
ATOM   4862  OD1 ASN E 148      53.125  22.396  28.355  1.00 43.94           O  
ATOM   4863  ND2 ASN E 148      50.887  22.344  28.773  1.00 40.02           N  
ATOM   4864  N   ASP E 149      52.295  21.072  23.155  1.00 34.63           N  
ATOM   4865  CA  ASP E 149      52.125  20.262  21.951  1.00 33.35           C  
ATOM   4866  C   ASP E 149      50.692  20.039  21.467  1.00 31.01           C  
ATOM   4867  O   ASP E 149      50.464  19.229  20.556  1.00 29.91           O  
ATOM   4868  CB  ASP E 149      52.801  18.915  22.141  1.00 34.86           C  
ATOM   4869  CG  ASP E 149      54.222  18.900  21.613  1.00 41.93           C  
ATOM   4870  OD1 ASP E 149      54.996  19.870  21.908  1.00 47.90           O  
ATOM   4871  OD2 ASP E 149      54.563  17.908  20.899  1.00 45.97           O  
ATOM   4872  N   ILE E 150      49.745  20.788  22.037  1.00 27.69           N  
ATOM   4873  CA  ILE E 150      48.346  20.713  21.668  1.00 25.52           C  
ATOM   4874  C   ILE E 150      47.928  21.989  20.930  1.00 23.32           C  
ATOM   4875  O   ILE E 150      48.126  23.053  21.448  1.00 21.06           O  
ATOM   4876  CB  ILE E 150      47.553  20.576  22.942  1.00 24.76           C  
ATOM   4877  CG1 ILE E 150      47.837  19.197  23.531  1.00 26.88           C  
ATOM   4878  CG2 ILE E 150      46.098  20.777  22.703  1.00 26.22           C  
ATOM   4879  CD1 ILE E 150      47.131  19.034  24.834  1.00 30.10           C  
ATOM   4880  N   PRO E 151      47.389  21.883  19.699  1.00 24.23           N  
ATOM   4881  CA  PRO E 151      47.072  23.127  18.969  1.00 24.61           C  
ATOM   4882  C   PRO E 151      46.072  23.986  19.738  1.00 24.50           C  
ATOM   4883  O   PRO E 151      45.024  23.457  20.130  1.00 22.84           O  
ATOM   4884  CB  PRO E 151      46.440  22.629  17.679  1.00 24.39           C  
ATOM   4885  CG  PRO E 151      46.966  21.247  17.515  1.00 25.47           C  
ATOM   4886  CD  PRO E 151      47.044  20.690  18.904  1.00 24.99           C  
ATOM   4887  N   VAL E 152      46.376  25.285  19.962  1.00 23.63           N  
ATOM   4888  CA  VAL E 152      45.386  26.162  20.601  1.00 23.35           C  
ATOM   4889  C   VAL E 152      44.934  27.347  19.760  1.00 23.54           C  
ATOM   4890  O   VAL E 152      44.049  28.062  20.187  1.00 23.86           O  
ATOM   4891  CB  VAL E 152      45.900  26.754  21.990  1.00 23.36           C  
ATOM   4892  CG1 VAL E 152      46.162  25.603  23.039  1.00 22.08           C  
ATOM   4893  CG2 VAL E 152      47.261  27.596  21.736  1.00 22.55           C  
ATOM   4894  N   GLN E 153      45.562  27.611  18.617  1.00 21.54           N  
ATOM   4895  CA  GLN E 153      45.141  28.711  17.762  1.00 22.88           C  
ATOM   4896  C   GLN E 153      45.601  28.470  16.327  1.00 23.86           C  
ATOM   4897  O   GLN E 153      46.806  28.094  16.093  1.00 22.85           O  
ATOM   4898  CB  GLN E 153      45.797  30.035  18.237  1.00 21.62           C  
ATOM   4899  CG  GLN E 153      45.183  31.339  17.585  1.00 24.09           C  
ATOM   4900  CD  GLN E 153      45.954  32.608  17.926  1.00 27.12           C  
ATOM   4901  OE1 GLN E 153      45.551  33.420  18.825  1.00 29.37           O  
ATOM   4902  NE2 GLN E 153      47.076  32.784  17.258  1.00 25.65           N  
ATOM   4903  N   ILE E 154      44.733  28.763  15.358  1.00 23.43           N  
ATOM   4904  CA  ILE E 154      45.255  29.092  14.026  1.00 23.80           C  
ATOM   4905  C   ILE E 154      45.279  30.592  13.829  1.00 22.79           C  
ATOM   4906  O   ILE E 154      44.313  31.229  14.185  1.00 20.99           O  
ATOM   4907  CB  ILE E 154      44.326  28.504  12.930  1.00 25.38           C  
ATOM   4908  CG1 ILE E 154      44.513  27.000  12.870  1.00 23.93           C  
ATOM   4909  CG2 ILE E 154      44.636  29.109  11.533  1.00 25.40           C  
ATOM   4910  CD1 ILE E 154      43.334  26.285  12.163  1.00 28.99           C  
ATOM   4911  N   GLU E 155      46.400  31.180  13.367  1.00 22.41           N  
ATOM   4912  CA  GLU E 155      46.383  32.579  12.944  1.00 22.57           C  
ATOM   4913  C   GLU E 155      46.540  32.574  11.425  1.00 23.12           C  
ATOM   4914  O   GLU E 155      47.563  32.194  10.900  1.00 22.37           O  
ATOM   4915  CB  GLU E 155      47.586  33.277  13.570  1.00 24.32           C  
ATOM   4916  CG  GLU E 155      47.830  34.761  13.088  1.00 26.98           C  
ATOM   4917  CD  GLU E 155      49.273  35.253  13.346  1.00 29.64           C  
ATOM   4918  OE1 GLU E 155      50.091  34.527  13.978  1.00 35.26           O  
ATOM   4919  OE2 GLU E 155      49.572  36.393  12.946  1.00 38.64           O  
ATOM   4920  N   ASP E 156      45.504  32.952  10.714  1.00 24.00           N  
ATOM   4921  CA  ASP E 156      45.500  32.898   9.240  1.00 23.87           C  
ATOM   4922  C   ASP E 156      45.420  34.350   8.825  1.00 23.55           C  
ATOM   4923  O   ASP E 156      44.395  35.003   9.042  1.00 22.62           O  
ATOM   4924  CB  ASP E 156      44.250  32.122   8.836  1.00 24.90           C  
ATOM   4925  CG  ASP E 156      44.214  31.724   7.326  1.00 31.19           C  
ATOM   4926  OD1 ASP E 156      45.143  31.955   6.555  1.00 36.15           O  
ATOM   4927  OD2 ASP E 156      43.209  31.144   6.916  1.00 36.28           O  
ATOM   4928  N   ARG E 157      46.544  34.879   8.335  1.00 22.61           N  
ATOM   4929  CA  ARG E 157      46.749  36.334   8.237  1.00 23.51           C  
ATOM   4930  C   ARG E 157      47.015  36.666   6.818  1.00 23.89           C  
ATOM   4931  O   ARG E 157      47.790  35.958   6.196  1.00 23.28           O  
ATOM   4932  CB  ARG E 157      47.986  36.766   9.065  1.00 25.83           C  
ATOM   4933  CG  ARG E 157      48.279  38.305   9.026  1.00 23.87           C  
ATOM   4934  CD  ARG E 157      49.348  38.797   9.982  1.00 24.31           C  
ATOM   4935  NE  ARG E 157      48.869  38.715  11.366  1.00 25.75           N  
ATOM   4936  CZ  ARG E 157      48.097  39.573  12.015  1.00 26.37           C  
ATOM   4937  NH1 ARG E 157      47.663  40.736  11.487  1.00 22.22           N  
ATOM   4938  NH2 ARG E 157      47.747  39.269  13.274  1.00 31.58           N  
ATOM   4939  N   PHE E 158      46.449  37.793   6.359  1.00 23.83           N  
ATOM   4940  CA  PHE E 158      46.686  38.315   5.056  1.00 23.93           C  
ATOM   4941  C   PHE E 158      47.210  39.746   5.146  1.00 23.80           C  
ATOM   4942  O   PHE E 158      46.730  40.567   5.964  1.00 23.96           O  
ATOM   4943  CB  PHE E 158      45.379  38.276   4.257  1.00 22.73           C  
ATOM   4944  CG  PHE E 158      44.843  36.895   4.037  1.00 27.28           C  
ATOM   4945  CD1 PHE E 158      45.139  36.189   2.883  1.00 29.62           C  
ATOM   4946  CD2 PHE E 158      44.043  36.265   5.001  1.00 29.39           C  
ATOM   4947  CE1 PHE E 158      44.595  34.901   2.686  1.00 30.36           C  
ATOM   4948  CE2 PHE E 158      43.526  34.982   4.768  1.00 28.25           C  
ATOM   4949  CZ  PHE E 158      43.766  34.351   3.629  1.00 26.10           C  
ATOM   4950  N   VAL E 159      48.175  40.064   4.301  1.00 22.68           N  
ATOM   4951  CA  VAL E 159      48.837  41.358   4.312  1.00 23.97           C  
ATOM   4952  C   VAL E 159      48.843  41.989   2.924  1.00 24.15           C  
ATOM   4953  O   VAL E 159      49.189  41.293   1.964  1.00 23.84           O  
ATOM   4954  CB  VAL E 159      50.304  41.181   4.743  1.00 24.50           C  
ATOM   4955  CG1 VAL E 159      50.982  42.570   4.877  1.00 25.14           C  
ATOM   4956  CG2 VAL E 159      50.336  40.481   6.176  1.00 26.45           C  
ATOM   4957  N   ASN E 160      48.476  43.273   2.801  1.00 22.38           N  
ATOM   4958  CA  ASN E 160      48.717  44.036   1.515  1.00 23.62           C  
ATOM   4959  C   ASN E 160      50.195  43.986   1.120  1.00 23.61           C  
ATOM   4960  O   ASN E 160      51.049  44.510   1.846  1.00 23.08           O  
ATOM   4961  CB  ASN E 160      48.227  45.488   1.668  1.00 23.38           C  
ATOM   4962  CG  ASN E 160      48.269  46.269   0.342  1.00 27.33           C  
ATOM   4963  OD1 ASN E 160      49.183  46.092  -0.449  1.00 29.54           O  
ATOM   4964  ND2 ASN E 160      47.263  47.119   0.096  1.00 29.97           N  
ATOM   4965  N   ALA E 161      50.537  43.313   0.007  1.00 25.39           N  
ATOM   4966  CA  ALA E 161      51.965  43.035  -0.288  1.00 25.41           C  
ATOM   4967  C   ALA E 161      52.785  44.288  -0.518  1.00 27.65           C  
ATOM   4968  O   ALA E 161      54.004  44.280  -0.248  1.00 27.87           O  
ATOM   4969  CB  ALA E 161      52.157  42.056  -1.444  1.00 25.16           C  
ATOM   4970  N   GLN E 162      52.139  45.352  -1.009  1.00 27.83           N  
ATOM   4971  CA  GLN E 162      52.795  46.651  -1.225  1.00 29.22           C  
ATOM   4972  C   GLN E 162      53.265  47.294   0.099  1.00 29.01           C  
ATOM   4973  O   GLN E 162      54.305  47.957   0.140  1.00 26.77           O  
ATOM   4974  CB  GLN E 162      51.863  47.636  -1.995  1.00 30.58           C  
ATOM   4975  CG  GLN E 162      51.722  47.429  -3.524  1.00 33.10           C  
ATOM   4976  CD  GLN E 162      50.747  48.460  -4.166  1.00 34.20           C  
ATOM   4977  OE1 GLN E 162      49.537  48.453  -3.898  1.00 39.13           O  
ATOM   4978  NE2 GLN E 162      51.287  49.351  -4.999  1.00 37.15           N  
ATOM   4979  N   VAL E 163      52.528  47.037   1.193  1.00 27.97           N  
ATOM   4980  CA  VAL E 163      52.818  47.626   2.481  1.00 27.95           C  
ATOM   4981  C   VAL E 163      54.001  46.982   3.170  1.00 27.07           C  
ATOM   4982  O   VAL E 163      54.761  47.648   3.861  1.00 27.45           O  
ATOM   4983  CB  VAL E 163      51.585  47.519   3.427  1.00 29.01           C  
ATOM   4984  CG1 VAL E 163      51.919  48.071   4.812  1.00 29.36           C  
ATOM   4985  CG2 VAL E 163      50.455  48.323   2.834  1.00 31.20           C  
ATOM   4986  N   ALA E 164      54.145  45.676   3.017  1.00 26.93           N  
ATOM   4987  CA  ALA E 164      55.203  44.947   3.699  1.00 26.29           C  
ATOM   4988  C   ALA E 164      55.901  44.059   2.677  1.00 26.63           C  
ATOM   4989  O   ALA E 164      55.772  42.840   2.720  1.00 25.55           O  
ATOM   4990  CB  ALA E 164      54.593  44.084   4.854  1.00 27.30           C  
ATOM   4991  N   PRO E 165      56.708  44.667   1.772  1.00 27.45           N  
ATOM   4992  CA  PRO E 165      57.297  43.893   0.644  1.00 27.25           C  
ATOM   4993  C   PRO E 165      58.218  42.692   1.023  1.00 27.21           C  
ATOM   4994  O   PRO E 165      58.354  41.759   0.230  1.00 28.63           O  
ATOM   4995  CB  PRO E 165      58.031  44.959  -0.192  1.00 26.15           C  
ATOM   4996  CG  PRO E 165      58.295  46.117   0.806  1.00 29.11           C  
ATOM   4997  CD  PRO E 165      57.143  46.084   1.792  1.00 28.16           C  
ATOM   4998  N   ASP E 166      58.765  42.671   2.233  1.00 28.34           N  
ATOM   4999  CA  ASP E 166      59.675  41.580   2.681  1.00 27.64           C  
ATOM   5000  C   ASP E 166      59.050  40.621   3.671  1.00 27.21           C  
ATOM   5001  O   ASP E 166      59.757  39.843   4.389  1.00 27.04           O  
ATOM   5002  CB  ASP E 166      60.977  42.164   3.269  1.00 29.33           C  
ATOM   5003  CG  ASP E 166      61.782  42.990   2.249  1.00 33.09           C  
ATOM   5004  OD1 ASP E 166      61.663  42.800   1.010  1.00 32.63           O  
ATOM   5005  OD2 ASP E 166      62.527  43.854   2.723  1.00 38.09           O  
ATOM   5006  N   TYR E 167      57.714  40.640   3.719  1.00 26.60           N  
ATOM   5007  CA  TYR E 167      56.975  39.755   4.655  1.00 26.08           C  
ATOM   5008  C   TYR E 167      57.337  38.258   4.469  1.00 26.30           C  
ATOM   5009  O   TYR E 167      57.628  37.587   5.457  1.00 25.93           O  
ATOM   5010  CB  TYR E 167      55.502  40.016   4.512  1.00 24.47           C  
ATOM   5011  CG  TYR E 167      54.578  39.320   5.483  1.00 27.19           C  
ATOM   5012  CD1 TYR E 167      54.297  39.917   6.723  1.00 24.41           C  
ATOM   5013  CD2 TYR E 167      53.898  38.121   5.134  1.00 20.72           C  
ATOM   5014  CE1 TYR E 167      53.433  39.328   7.594  1.00 22.69           C  
ATOM   5015  CE2 TYR E 167      53.037  37.509   6.022  1.00 26.47           C  
ATOM   5016  CZ  TYR E 167      52.808  38.119   7.248  1.00 23.39           C  
ATOM   5017  OH  TYR E 167      51.922  37.639   8.125  1.00 27.98           O  
ATOM   5018  N   LEU E 168      57.415  37.778   3.211  1.00 26.07           N  
ATOM   5019  CA  LEU E 168      57.829  36.370   2.947  1.00 27.41           C  
ATOM   5020  C   LEU E 168      59.297  35.989   3.346  1.00 27.80           C  
ATOM   5021  O   LEU E 168      59.663  34.801   3.334  1.00 29.10           O  
ATOM   5022  CB  LEU E 168      57.571  35.960   1.483  1.00 27.31           C  
ATOM   5023  CG  LEU E 168      56.198  36.306   0.873  1.00 27.74           C  
ATOM   5024  CD1 LEU E 168      56.178  35.912  -0.611  1.00 25.25           C  
ATOM   5025  CD2 LEU E 168      55.080  35.680   1.653  1.00 22.15           C  
ATOM   5026  N   LYS E 169      60.128  36.958   3.719  1.00 27.23           N  
ATOM   5027  CA  LYS E 169      61.505  36.640   4.036  1.00 27.65           C  
ATOM   5028  C   LYS E 169      61.726  36.432   5.524  1.00 26.38           C  
ATOM   5029  O   LYS E 169      62.841  36.190   6.005  1.00 25.59           O  
ATOM   5030  CB  LYS E 169      62.416  37.767   3.510  1.00 28.33           C  
ATOM   5031  CG  LYS E 169      62.363  37.955   1.968  1.00 30.35           C  
ATOM   5032  CD  LYS E 169      63.358  39.036   1.504  1.00 31.79           C  
ATOM   5033  CE  LYS E 169      62.822  39.857   0.315  1.00 39.68           C  
ATOM   5034  NZ  LYS E 169      62.777  39.072  -0.983  1.00 44.92           N  
ATOM   5035  N   GLN E 170      60.664  36.524   6.293  1.00 25.22           N  
ATOM   5036  CA  GLN E 170      60.820  36.483   7.720  1.00 24.96           C  
ATOM   5037  C   GLN E 170      60.637  35.067   8.264  1.00 25.77           C  
ATOM   5038  O   GLN E 170      59.899  34.226   7.696  1.00 24.27           O  
ATOM   5039  CB  GLN E 170      59.787  37.409   8.357  1.00 25.62           C  
ATOM   5040  CG  GLN E 170      59.767  38.821   7.725  1.00 22.44           C  
ATOM   5041  CD  GLN E 170      61.070  39.508   7.891  1.00 26.33           C  
ATOM   5042  OE1 GLN E 170      61.675  39.444   8.954  1.00 26.27           O  
ATOM   5043  NE2 GLN E 170      61.503  40.218   6.859  1.00 24.81           N  
ATOM   5044  N   ASP E 171      61.263  34.864   9.436  1.00 26.11           N  
ATOM   5045  CA  ASP E 171      61.065  33.674  10.298  1.00 26.26           C  
ATOM   5046  C   ASP E 171      60.056  34.001  11.448  1.00 28.16           C  
ATOM   5047  O   ASP E 171      60.410  34.612  12.490  1.00 28.29           O  
ATOM   5048  CB  ASP E 171      62.460  33.152  10.749  1.00 26.10           C  
ATOM   5049  CG  ASP E 171      62.390  31.829  11.476  1.00 24.97           C  
ATOM   5050  OD1 ASP E 171      61.299  31.330  11.682  1.00 22.09           O  
ATOM   5051  OD2 ASP E 171      63.406  31.283  11.886  1.00 27.65           O  
ATOM   5052  N   PHE E 172      58.787  33.601  11.247  1.00 27.76           N  
ATOM   5053  CA  PHE E 172      57.672  33.957  12.155  1.00 27.63           C  
ATOM   5054  C   PHE E 172      57.577  33.019  13.354  1.00 29.18           C  
ATOM   5055  O   PHE E 172      56.647  33.078  14.207  1.00 28.82           O  
ATOM   5056  CB  PHE E 172      56.353  34.068  11.362  1.00 26.63           C  
ATOM   5057  CG  PHE E 172      56.325  35.254  10.440  1.00 27.92           C  
ATOM   5058  CD1 PHE E 172      56.681  36.512  10.912  1.00 24.39           C  
ATOM   5059  CD2 PHE E 172      55.952  35.133   9.120  1.00 24.69           C  
ATOM   5060  CE1 PHE E 172      56.627  37.649  10.069  1.00 25.01           C  
ATOM   5061  CE2 PHE E 172      55.900  36.254   8.281  1.00 24.14           C  
ATOM   5062  CZ  PHE E 172      56.265  37.502   8.752  1.00 22.37           C  
ATOM   5063  N   THR E 173      58.605  32.182  13.410  1.00 30.25           N  
ATOM   5064  CA  THR E 173      58.899  31.320  14.527  1.00 31.25           C  
ATOM   5065  C   THR E 173      59.718  32.143  15.589  1.00 31.89           C  
ATOM   5066  O   THR E 173      59.730  31.833  16.789  1.00 32.53           O  
ATOM   5067  CB  THR E 173      59.632  30.129  13.887  1.00 32.28           C  
ATOM   5068  OG1 THR E 173      58.801  28.973  13.864  1.00 33.46           O  
ATOM   5069  CG2 THR E 173      60.982  29.859  14.472  1.00 30.57           C  
ATOM   5070  N   LEU E 174      60.348  33.221  15.133  1.00 31.77           N  
ATOM   5071  CA  LEU E 174      61.206  34.073  15.947  1.00 32.75           C  
ATOM   5072  C   LEU E 174      60.612  35.459  16.289  1.00 33.05           C  
ATOM   5073  O   LEU E 174      61.088  36.126  17.226  1.00 32.93           O  
ATOM   5074  CB  LEU E 174      62.526  34.286  15.215  1.00 33.28           C  
ATOM   5075  CG  LEU E 174      63.316  33.050  14.839  1.00 34.17           C  
ATOM   5076  CD1 LEU E 174      64.746  33.494  14.535  1.00 38.23           C  
ATOM   5077  CD2 LEU E 174      63.316  32.084  15.992  1.00 37.17           C  
ATOM   5078  N   GLN E 175      59.608  35.898  15.524  1.00 31.15           N  
ATOM   5079  CA  GLN E 175      58.959  37.168  15.773  1.00 30.26           C  
ATOM   5080  C   GLN E 175      57.536  37.026  15.298  1.00 29.24           C  
ATOM   5081  O   GLN E 175      57.379  36.514  14.228  1.00 29.24           O  
ATOM   5082  CB  GLN E 175      59.625  38.259  14.919  1.00 28.88           C  
ATOM   5083  CG  GLN E 175      58.955  39.606  15.086  1.00 29.26           C  
ATOM   5084  CD  GLN E 175      59.747  40.837  14.634  1.00 31.71           C  
ATOM   5085  OE1 GLN E 175      60.186  40.962  13.476  1.00 26.49           O  
ATOM   5086  NE2 GLN E 175      59.852  41.803  15.545  1.00 33.39           N  
ATOM   5087  N   THR E 176      56.504  37.474  16.032  1.00 29.25           N  
ATOM   5088  CA  THR E 176      55.111  37.341  15.441  1.00 29.38           C  
ATOM   5089  C   THR E 176      54.948  38.138  14.139  1.00 28.24           C  
ATOM   5090  O   THR E 176      55.625  39.131  13.951  1.00 29.75           O  
ATOM   5091  CB  THR E 176      53.953  37.756  16.378  1.00 29.90           C  
ATOM   5092  OG1 THR E 176      54.052  39.158  16.666  1.00 31.67           O  
ATOM   5093  CG2 THR E 176      53.933  36.922  17.665  1.00 32.56           C  
ATOM   5094  N   PRO E 177      54.082  37.680  13.203  1.00 27.00           N  
ATOM   5095  CA  PRO E 177      53.716  38.594  12.103  1.00 26.65           C  
ATOM   5096  C   PRO E 177      53.271  39.999  12.533  1.00 26.43           C  
ATOM   5097  O   PRO E 177      53.721  40.971  11.962  1.00 25.73           O  
ATOM   5098  CB  PRO E 177      52.613  37.834  11.377  1.00 26.73           C  
ATOM   5099  CG  PRO E 177      53.023  36.360  11.592  1.00 24.82           C  
ATOM   5100  CD  PRO E 177      53.536  36.315  13.005  1.00 25.80           C  
ATOM   5101  N   TYR E 178      52.449  40.113  13.570  1.00 26.69           N  
ATOM   5102  CA  TYR E 178      52.004  41.435  13.978  1.00 27.55           C  
ATOM   5103  C   TYR E 178      53.188  42.316  14.475  1.00 25.79           C  
ATOM   5104  O   TYR E 178      53.299  43.487  14.089  1.00 24.99           O  
ATOM   5105  CB  TYR E 178      50.856  41.343  15.009  1.00 29.87           C  
ATOM   5106  CG  TYR E 178      50.376  42.718  15.448  1.00 34.68           C  
ATOM   5107  CD1 TYR E 178      49.407  43.433  14.701  1.00 33.10           C  
ATOM   5108  CD2 TYR E 178      50.953  43.336  16.574  1.00 39.18           C  
ATOM   5109  CE1 TYR E 178      49.008  44.692  15.097  1.00 37.28           C  
ATOM   5110  CE2 TYR E 178      50.553  44.610  16.975  1.00 40.52           C  
ATOM   5111  CZ  TYR E 178      49.567  45.267  16.245  1.00 37.66           C  
ATOM   5112  OH  TYR E 178      49.184  46.521  16.679  1.00 40.23           O  
ATOM   5113  N   ALA E 179      54.047  41.754  15.314  1.00 24.28           N  
ATOM   5114  CA  ALA E 179      55.312  42.395  15.733  1.00 24.89           C  
ATOM   5115  C   ALA E 179      56.148  42.892  14.563  1.00 23.81           C  
ATOM   5116  O   ALA E 179      56.607  44.041  14.543  1.00 21.74           O  
ATOM   5117  CB  ALA E 179      56.157  41.403  16.583  1.00 26.10           C  
ATOM   5118  N   TYR E 180      56.375  42.017  13.582  1.00 23.63           N  
ATOM   5119  CA  TYR E 180      57.144  42.400  12.380  1.00 24.57           C  
ATOM   5120  C   TYR E 180      56.463  43.558  11.649  1.00 23.71           C  
ATOM   5121  O   TYR E 180      57.062  44.529  11.364  1.00 23.69           O  
ATOM   5122  CB  TYR E 180      57.253  41.197  11.410  1.00 23.04           C  
ATOM   5123  CG  TYR E 180      57.823  41.604  10.087  1.00 25.01           C  
ATOM   5124  CD1 TYR E 180      59.168  41.946   9.977  1.00 22.67           C  
ATOM   5125  CD2 TYR E 180      57.005  41.674   8.922  1.00 23.82           C  
ATOM   5126  CE1 TYR E 180      59.670  42.364   8.782  1.00 24.73           C  
ATOM   5127  CE2 TYR E 180      57.515  42.098   7.679  1.00 21.74           C  
ATOM   5128  CZ  TYR E 180      58.842  42.455   7.629  1.00 22.64           C  
ATOM   5129  OH  TYR E 180      59.425  42.880   6.462  1.00 22.75           O  
ATOM   5130  N   LEU E 181      55.180  43.430  11.358  1.00 24.71           N  
ATOM   5131  CA  LEU E 181      54.441  44.499  10.678  1.00 25.16           C  
ATOM   5132  C   LEU E 181      54.450  45.815  11.424  1.00 27.29           C  
ATOM   5133  O   LEU E 181      54.470  46.865  10.784  1.00 28.76           O  
ATOM   5134  CB  LEU E 181      52.987  44.059  10.472  1.00 25.10           C  
ATOM   5135  CG  LEU E 181      52.786  42.907   9.480  1.00 23.01           C  
ATOM   5136  CD1 LEU E 181      51.271  42.529   9.568  1.00 21.27           C  
ATOM   5137  CD2 LEU E 181      53.177  43.368   8.105  1.00 26.22           C  
ATOM   5138  N   SER E 182      54.320  45.746  12.756  1.00 28.45           N  
ATOM   5139  CA  SER E 182      54.612  46.860  13.661  1.00 30.01           C  
ATOM   5140  C   SER E 182      55.840  47.648  13.383  1.00 29.10           C  
ATOM   5141  O   SER E 182      55.820  48.840  13.603  1.00 31.21           O  
ATOM   5142  CB  SER E 182      54.763  46.365  15.078  1.00 29.53           C  
ATOM   5143  OG  SER E 182      53.488  46.038  15.427  1.00 31.30           O  
ATOM   5144  N   GLN E 183      56.916  47.012  12.956  1.00 28.75           N  
ATOM   5145  CA  GLN E 183      58.122  47.774  12.652  1.00 30.57           C  
ATOM   5146  C   GLN E 183      58.157  48.314  11.241  1.00 30.69           C  
ATOM   5147  O   GLN E 183      58.873  49.260  10.981  1.00 31.31           O  
ATOM   5148  CB  GLN E 183      59.401  46.935  12.812  1.00 31.24           C  
ATOM   5149  CG  GLN E 183      59.640  46.368  14.162  1.00 34.70           C  
ATOM   5150  CD  GLN E 183      60.638  45.208  14.067  1.00 39.93           C  
ATOM   5151  OE1 GLN E 183      60.793  44.444  14.995  1.00 41.39           O  
ATOM   5152  NE2 GLN E 183      61.283  45.062  12.909  1.00 42.66           N  
ATOM   5153  N   VAL E 184      57.414  47.681  10.332  1.00 29.81           N  
ATOM   5154  CA  VAL E 184      57.475  47.996   8.906  1.00 29.78           C  
ATOM   5155  C   VAL E 184      56.596  49.196   8.573  1.00 29.29           C  
ATOM   5156  O   VAL E 184      56.901  49.967   7.678  1.00 28.43           O  
ATOM   5157  CB  VAL E 184      57.007  46.772   8.058  1.00 29.73           C  
ATOM   5158  CG1 VAL E 184      56.858  47.157   6.564  1.00 30.70           C  
ATOM   5159  CG2 VAL E 184      58.024  45.709   8.170  1.00 33.57           C  
ATOM   5160  N   ALA E 185      55.489  49.325   9.293  1.00 29.70           N  
ATOM   5161  CA  ALA E 185      54.553  50.388   9.064  1.00 29.56           C  
ATOM   5162  C   ALA E 185      53.988  50.821  10.407  1.00 29.11           C  
ATOM   5163  O   ALA E 185      53.783  50.018  11.280  1.00 26.92           O  
ATOM   5164  CB  ALA E 185      53.405  49.842   8.164  1.00 30.58           C  
ATOM   5165  N   PRO E 186      53.654  52.100  10.549  1.00 29.68           N  
ATOM   5166  CA  PRO E 186      53.063  52.524  11.802  1.00 29.24           C  
ATOM   5167  C   PRO E 186      51.576  52.085  11.869  1.00 28.13           C  
ATOM   5168  O   PRO E 186      50.768  52.544  11.099  1.00 29.33           O  
ATOM   5169  CB  PRO E 186      53.231  54.020  11.740  1.00 29.37           C  
ATOM   5170  CG  PRO E 186      53.125  54.341  10.314  1.00 31.19           C  
ATOM   5171  CD  PRO E 186      53.750  53.198   9.578  1.00 30.50           C  
ATOM   5172  N   LEU E 187      51.231  51.203  12.771  1.00 26.31           N  
ATOM   5173  CA  LEU E 187      49.835  50.726  12.847  1.00 27.67           C  
ATOM   5174  C   LEU E 187      49.048  51.593  13.865  1.00 28.05           C  
ATOM   5175  O   LEU E 187      49.448  51.737  15.011  1.00 29.53           O  
ATOM   5176  CB  LEU E 187      49.802  49.226  13.181  1.00 27.64           C  
ATOM   5177  CG  LEU E 187      50.699  48.339  12.292  1.00 25.11           C  
ATOM   5178  CD1 LEU E 187      50.811  46.974  12.861  1.00 25.93           C  
ATOM   5179  CD2 LEU E 187      50.201  48.203  10.913  1.00 21.34           C  
ATOM   5180  N   THR E 188      47.961  52.211  13.420  1.00 26.73           N  
ATOM   5181  CA  THR E 188      47.404  53.368  14.155  1.00 25.97           C  
ATOM   5182  C   THR E 188      46.037  52.996  14.677  1.00 24.85           C  
ATOM   5183  O   THR E 188      45.472  53.672  15.525  1.00 23.76           O  
ATOM   5184  CB  THR E 188      47.304  54.594  13.239  1.00 26.89           C  
ATOM   5185  OG1 THR E 188      46.711  54.196  11.983  1.00 26.25           O  
ATOM   5186  CG2 THR E 188      48.677  55.176  12.978  1.00 27.02           C  
ATOM   5187  N   GLU E 189      45.509  51.887  14.187  1.00 23.01           N  
ATOM   5188  CA  GLU E 189      44.108  51.524  14.474  1.00 23.91           C  
ATOM   5189  C   GLU E 189      43.849  50.039  14.288  1.00 22.84           C  
ATOM   5190  O   GLU E 189      44.476  49.393  13.404  1.00 21.29           O  
ATOM   5191  CB  GLU E 189      43.207  52.346  13.567  1.00 24.81           C  
ATOM   5192  CG  GLU E 189      41.701  52.174  13.730  1.00 31.95           C  
ATOM   5193  CD  GLU E 189      40.983  53.219  12.876  1.00 38.04           C  
ATOM   5194  OE1 GLU E 189      41.660  54.138  12.398  1.00 34.24           O  
ATOM   5195  OE2 GLU E 189      39.766  53.093  12.665  1.00 41.36           O  
ATOM   5196  N   GLY E 190      42.967  49.474  15.121  1.00 23.23           N  
ATOM   5197  CA  GLY E 190      42.701  48.052  15.027  1.00 23.09           C  
ATOM   5198  C   GLY E 190      41.246  47.764  15.217  1.00 24.69           C  
ATOM   5199  O   GLY E 190      40.533  48.547  15.838  1.00 23.23           O  
ATOM   5200  N   GLU E 191      40.793  46.629  14.691  1.00 24.00           N  
ATOM   5201  CA  GLU E 191      39.404  46.235  14.853  1.00 24.67           C  
ATOM   5202  C   GLU E 191      39.457  44.789  15.271  1.00 24.85           C  
ATOM   5203  O   GLU E 191      40.308  44.044  14.759  1.00 24.64           O  
ATOM   5204  CB  GLU E 191      38.681  46.402  13.498  1.00 24.66           C  
ATOM   5205  CG  GLU E 191      37.285  45.816  13.408  1.00 26.71           C  
ATOM   5206  CD  GLU E 191      36.789  45.820  12.019  1.00 35.52           C  
ATOM   5207  OE1 GLU E 191      36.337  46.900  11.537  1.00 36.10           O  
ATOM   5208  OE2 GLU E 191      36.878  44.749  11.395  1.00 32.87           O  
ATOM   5209  N   HIS E 192      38.496  44.364  16.083  1.00 25.36           N  
ATOM   5210  CA  HIS E 192      38.282  42.926  16.340  1.00 25.91           C  
ATOM   5211  C   HIS E 192      36.792  42.601  16.317  1.00 26.14           C  
ATOM   5212  O   HIS E 192      35.952  43.483  16.602  1.00 27.19           O  
ATOM   5213  CB  HIS E 192      38.896  42.525  17.671  1.00 28.91           C  
ATOM   5214  CG  HIS E 192      38.368  43.295  18.850  1.00 32.38           C  
ATOM   5215  ND1 HIS E 192      37.069  43.149  19.325  1.00 40.07           N  
ATOM   5216  CD2 HIS E 192      38.974  44.157  19.687  1.00 38.47           C  
ATOM   5217  CE1 HIS E 192      36.903  43.900  20.401  1.00 38.21           C  
ATOM   5218  NE2 HIS E 192      38.039  44.534  20.631  1.00 42.74           N  
ATOM   5219  N   VAL E 193      36.445  41.393  15.884  1.00 23.92           N  
ATOM   5220  CA  VAL E 193      35.077  40.888  15.884  1.00 24.30           C  
ATOM   5221  C   VAL E 193      35.262  39.485  16.441  1.00 24.55           C  
ATOM   5222  O   VAL E 193      36.086  38.760  15.934  1.00 26.35           O  
ATOM   5223  CB  VAL E 193      34.485  40.791  14.481  1.00 23.87           C  
ATOM   5224  CG1 VAL E 193      33.184  40.122  14.555  1.00 24.26           C  
ATOM   5225  CG2 VAL E 193      34.304  42.196  13.867  1.00 29.08           C  
ATOM   5226  N   VAL E 194      34.575  39.153  17.537  1.00 24.92           N  
ATOM   5227  CA  VAL E 194      34.646  37.861  18.242  1.00 24.80           C  
ATOM   5228  C   VAL E 194      33.318  37.149  18.001  1.00 23.68           C  
ATOM   5229  O   VAL E 194      32.244  37.715  18.255  1.00 23.12           O  
ATOM   5230  CB  VAL E 194      34.879  38.073  19.800  1.00 25.52           C  
ATOM   5231  CG1 VAL E 194      35.049  36.683  20.573  1.00 26.63           C  
ATOM   5232  CG2 VAL E 194      36.062  38.990  20.040  1.00 27.99           C  
ATOM   5233  N   GLU E 195      33.394  35.911  17.490  1.00 23.33           N  
ATOM   5234  CA  GLU E 195      32.224  35.067  17.222  1.00 22.51           C  
ATOM   5235  C   GLU E 195      32.498  33.682  17.699  1.00 22.24           C  
ATOM   5236  O   GLU E 195      33.657  33.294  17.795  1.00 22.34           O  
ATOM   5237  CB  GLU E 195      31.943  34.996  15.713  1.00 21.67           C  
ATOM   5238  CG  GLU E 195      31.392  36.329  15.218  1.00 22.64           C  
ATOM   5239  CD  GLU E 195      31.000  36.301  13.718  1.00 26.51           C  
ATOM   5240  OE1 GLU E 195      30.536  35.257  13.232  1.00 30.02           O  
ATOM   5241  OE2 GLU E 195      31.127  37.341  13.049  1.00 31.60           O  
ATOM   5242  N   ALA E 196      31.434  32.959  18.026  1.00 23.26           N  
ATOM   5243  CA  ALA E 196      31.521  31.516  18.340  1.00 24.18           C  
ATOM   5244  C   ALA E 196      31.136  30.794  17.058  1.00 23.80           C  
ATOM   5245  O   ALA E 196      29.953  30.960  16.585  1.00 24.71           O  
ATOM   5246  CB  ALA E 196      30.558  31.132  19.473  1.00 23.82           C  
ATOM   5247  N   ILE E 197      32.076  30.008  16.483  1.00 24.00           N  
ATOM   5248  CA  ILE E 197      31.816  29.377  15.145  1.00 24.08           C  
ATOM   5249  C   ILE E 197      32.124  27.892  15.155  1.00 25.90           C  
ATOM   5250  O   ILE E 197      32.661  27.391  16.128  1.00 26.86           O  
ATOM   5251  CB  ILE E 197      32.621  30.036  14.000  1.00 25.05           C  
ATOM   5252  CG1 ILE E 197      34.153  29.843  14.176  1.00 22.80           C  
ATOM   5253  CG2 ILE E 197      32.293  31.536  13.893  1.00 22.48           C  
ATOM   5254  CD1 ILE E 197      35.026  30.106  12.882  1.00 26.88           C  
ATOM   5255  N   LEU E 198      31.737  27.206  14.079  1.00 25.60           N  
ATOM   5256  CA  LEU E 198      32.314  25.915  13.729  1.00 25.64           C  
ATOM   5257  C   LEU E 198      33.365  26.236  12.697  1.00 24.75           C  
ATOM   5258  O   LEU E 198      33.149  27.131  11.827  1.00 24.03           O  
ATOM   5259  CB  LEU E 198      31.221  25.014  13.157  1.00 24.58           C  
ATOM   5260  CG  LEU E 198      30.165  24.606  14.201  1.00 23.27           C  
ATOM   5261  CD1 LEU E 198      29.263  23.564  13.539  1.00 24.74           C  
ATOM   5262  CD2 LEU E 198      30.748  24.012  15.507  1.00 26.97           C  
ATOM   5263  N   ALA E 199      34.529  25.606  12.815  1.00 24.87           N  
ATOM   5264  CA  ALA E 199      35.648  25.910  11.933  1.00 26.23           C  
ATOM   5265  C   ALA E 199      35.509  25.093  10.633  1.00 27.69           C  
ATOM   5266  O   ALA E 199      34.720  24.128  10.605  1.00 27.54           O  
ATOM   5267  CB  ALA E 199      36.966  25.584  12.623  1.00 27.14           C  
ATOM   5268  N   GLU E 200      36.236  25.487   9.572  1.00 26.89           N  
ATOM   5269  CA  GLU E 200      36.245  24.714   8.343  1.00 28.61           C  
ATOM   5270  C   GLU E 200      36.934  23.367   8.573  1.00 29.18           C  
ATOM   5271  O   GLU E 200      37.731  23.249   9.493  1.00 26.65           O  
ATOM   5272  CB  GLU E 200      36.923  25.448   7.186  1.00 28.22           C  
ATOM   5273  CG  GLU E 200      36.179  26.749   6.789  1.00 33.69           C  
ATOM   5274  CD  GLU E 200      34.699  26.505   6.553  1.00 39.47           C  
ATOM   5275  OE1 GLU E 200      34.381  25.804   5.570  1.00 43.61           O  
ATOM   5276  OE2 GLU E 200      33.858  26.950   7.361  1.00 39.85           O  
ATOM   5277  N   ALA E 201      36.642  22.387   7.692  1.00 30.20           N  
ATOM   5278  CA  ALA E 201      37.137  21.030   7.843  1.00 31.28           C  
ATOM   5279  C   ALA E 201      38.630  20.982   8.037  1.00 31.46           C  
ATOM   5280  O   ALA E 201      39.097  20.306   8.929  1.00 32.95           O  
ATOM   5281  CB  ALA E 201      36.743  20.137   6.635  1.00 31.60           C  
ATOM   5282  N   ASP E 202      39.374  21.683   7.192  1.00 32.09           N  
ATOM   5283  CA  ASP E 202      40.837  21.621   7.228  1.00 32.30           C  
ATOM   5284  C   ASP E 202      41.354  22.316   8.466  1.00 30.14           C  
ATOM   5285  O   ASP E 202      42.356  21.912   9.008  1.00 29.72           O  
ATOM   5286  CB  ASP E 202      41.435  22.306   5.996  1.00 33.76           C  
ATOM   5287  CG  ASP E 202      41.065  21.609   4.697  1.00 42.31           C  
ATOM   5288  OD1 ASP E 202      41.312  20.363   4.577  1.00 47.38           O  
ATOM   5289  OD2 ASP E 202      40.536  22.323   3.777  1.00 51.10           O  
ATOM   5290  N   GLU E 203      40.664  23.371   8.906  1.00 29.09           N  
ATOM   5291  CA  GLU E 203      40.999  24.041  10.202  1.00 27.55           C  
ATOM   5292  C   GLU E 203      40.892  23.086  11.399  1.00 27.79           C  
ATOM   5293  O   GLU E 203      41.844  22.922  12.153  1.00 26.21           O  
ATOM   5294  CB  GLU E 203      40.156  25.298  10.378  1.00 27.76           C  
ATOM   5295  CG  GLU E 203      40.560  26.385   9.314  1.00 25.86           C  
ATOM   5296  CD  GLU E 203      39.557  27.542   9.208  1.00 29.41           C  
ATOM   5297  OE1 GLU E 203      38.443  27.470   9.790  1.00 29.88           O  
ATOM   5298  OE2 GLU E 203      39.920  28.520   8.493  1.00 31.64           O  
ATOM   5299  N   CYS E 204      39.739  22.408  11.522  1.00 28.21           N  
ATOM   5300  CA  CYS E 204      39.532  21.320  12.483  1.00 26.87           C  
ATOM   5301  C   CYS E 204      40.646  20.305  12.428  1.00 28.17           C  
ATOM   5302  O   CYS E 204      41.134  19.843  13.454  1.00 27.84           O  
ATOM   5303  CB  CYS E 204      38.172  20.627  12.195  1.00 25.75           C  
ATOM   5304  SG  CYS E 204      36.768  21.767  12.488  1.00 27.96           S  
ATOM   5305  N   LYS E 205      40.987  19.870  11.209  1.00 28.73           N  
ATOM   5306  CA  LYS E 205      42.051  18.883  11.033  1.00 29.57           C  
ATOM   5307  C   LYS E 205      43.344  19.378  11.694  1.00 28.64           C  
ATOM   5308  O   LYS E 205      43.942  18.682  12.514  1.00 28.16           O  
ATOM   5309  CB  LYS E 205      42.210  18.507   9.528  1.00 29.92           C  
ATOM   5310  CG  LYS E 205      41.076  17.547   9.064  1.00 32.32           C  
ATOM   5311  CD  LYS E 205      41.053  17.237   7.556  1.00 32.99           C  
ATOM   5312  CE  LYS E 205      39.861  16.326   7.192  1.00 35.02           C  
ATOM   5313  NZ  LYS E 205      40.005  15.663   5.817  1.00 36.20           N  
ATOM   5314  N   LEU E 206      43.691  20.621  11.391  1.00 29.06           N  
ATOM   5315  CA  LEU E 206      44.926  21.314  11.845  1.00 28.34           C  
ATOM   5316  C   LEU E 206      44.909  21.513  13.379  1.00 28.26           C  
ATOM   5317  O   LEU E 206      45.925  21.315  14.079  1.00 29.27           O  
ATOM   5318  CB  LEU E 206      45.044  22.681  11.147  1.00 28.10           C  
ATOM   5319  CG  LEU E 206      45.800  22.850   9.833  1.00 31.96           C  
ATOM   5320  CD1 LEU E 206      45.802  24.361   9.526  1.00 31.90           C  
ATOM   5321  CD2 LEU E 206      47.266  22.268   9.979  1.00 32.40           C  
ATOM   5322  N   LEU E 207      43.750  21.848  13.903  1.00 25.75           N  
ATOM   5323  CA  LEU E 207      43.581  22.048  15.337  1.00 26.61           C  
ATOM   5324  C   LEU E 207      43.321  20.756  16.120  1.00 26.22           C  
ATOM   5325  O   LEU E 207      43.208  20.790  17.331  1.00 26.90           O  
ATOM   5326  CB  LEU E 207      42.434  23.018  15.609  1.00 26.04           C  
ATOM   5327  CG  LEU E 207      42.664  24.486  15.269  1.00 26.57           C  
ATOM   5328  CD1 LEU E 207      41.370  25.246  15.365  1.00 22.25           C  
ATOM   5329  CD2 LEU E 207      43.641  25.102  16.225  1.00 26.87           C  
ATOM   5330  N   GLN E 208      43.176  19.638  15.417  1.00 26.14           N  
ATOM   5331  CA  GLN E 208      42.887  18.342  16.051  1.00 27.51           C  
ATOM   5332  C   GLN E 208      41.633  18.367  16.915  1.00 26.97           C  
ATOM   5333  O   GLN E 208      41.661  18.037  18.120  1.00 29.23           O  
ATOM   5334  CB  GLN E 208      44.114  17.889  16.827  1.00 27.35           C  
ATOM   5335  CG  GLN E 208      45.291  17.706  15.918  1.00 28.18           C  
ATOM   5336  CD  GLN E 208      46.460  17.158  16.660  1.00 32.18           C  
ATOM   5337  OE1 GLN E 208      46.328  16.132  17.336  1.00 32.65           O  
ATOM   5338  NE2 GLN E 208      47.635  17.821  16.535  1.00 28.45           N  
ATOM   5339  N   ILE E 209      40.532  18.824  16.316  1.00 27.60           N  
ATOM   5340  CA  ILE E 209      39.246  18.887  16.986  1.00 26.39           C  
ATOM   5341  C   ILE E 209      38.250  18.247  16.074  1.00 26.62           C  
ATOM   5342  O   ILE E 209      38.481  18.191  14.859  1.00 25.96           O  
ATOM   5343  CB  ILE E 209      38.725  20.360  17.303  1.00 27.98           C  
ATOM   5344  CG1 ILE E 209      38.751  21.263  16.042  1.00 24.09           C  
ATOM   5345  CG2 ILE E 209      39.458  20.954  18.509  1.00 28.86           C  
ATOM   5346  CD1 ILE E 209      38.053  22.695  16.222  1.00 25.93           C  
ATOM   5347  N   ASP E 210      37.145  17.755  16.668  1.00 28.07           N  
ATOM   5348  CA  ASP E 210      36.049  17.225  15.866  1.00 29.16           C  
ATOM   5349  C   ASP E 210      35.370  18.453  15.238  1.00 29.28           C  
ATOM   5350  O   ASP E 210      35.564  19.661  15.660  1.00 28.33           O  
ATOM   5351  CB  ASP E 210      35.013  16.394  16.672  1.00 29.78           C  
ATOM   5352  CG  ASP E 210      35.487  14.975  17.043  1.00 32.95           C  
ATOM   5353  OD1 ASP E 210      36.270  14.279  16.335  1.00 39.70           O  
ATOM   5354  OD2 ASP E 210      35.007  14.504  18.079  1.00 42.71           O  
ATOM   5355  N   ALA E 211      34.595  18.136  14.213  1.00 28.51           N  
ATOM   5356  CA  ALA E 211      34.005  19.113  13.338  1.00 27.87           C  
ATOM   5357  C   ALA E 211      32.986  19.948  14.079  1.00 27.18           C  
ATOM   5358  O   ALA E 211      32.727  21.071  13.710  1.00 27.60           O  
ATOM   5359  CB  ALA E 211      33.380  18.424  12.195  1.00 28.74           C  
ATOM   5360  N   GLY E 212      32.427  19.394  15.123  1.00 25.25           N  
ATOM   5361  CA  GLY E 212      31.335  20.012  15.796  1.00 26.37           C  
ATOM   5362  C   GLY E 212      31.807  20.778  16.988  1.00 26.29           C  
ATOM   5363  O   GLY E 212      30.944  21.254  17.744  1.00 28.39           O  
ATOM   5364  N   GLU E 213      33.144  20.897  17.177  1.00 26.31           N  
ATOM   5365  CA  GLU E 213      33.694  21.598  18.362  1.00 26.39           C  
ATOM   5366  C   GLU E 213      33.608  23.108  18.213  1.00 24.61           C  
ATOM   5367  O   GLU E 213      34.150  23.659  17.266  1.00 24.34           O  
ATOM   5368  CB  GLU E 213      35.110  21.200  18.807  1.00 26.38           C  
ATOM   5369  CG  GLU E 213      35.390  21.930  20.131  1.00 31.68           C  
ATOM   5370  CD  GLU E 213      36.683  21.607  20.891  1.00 32.04           C  
ATOM   5371  OE1 GLU E 213      37.317  22.604  21.401  1.00 30.65           O  
ATOM   5372  OE2 GLU E 213      37.000  20.394  20.999  1.00 32.52           O  
ATOM   5373  N   PRO E 214      32.862  23.770  19.126  1.00 25.31           N  
ATOM   5374  CA  PRO E 214      32.750  25.226  18.978  1.00 24.00           C  
ATOM   5375  C   PRO E 214      34.110  25.870  19.146  1.00 25.66           C  
ATOM   5376  O   PRO E 214      34.934  25.369  19.929  1.00 24.57           O  
ATOM   5377  CB  PRO E 214      31.807  25.642  20.044  1.00 24.04           C  
ATOM   5378  CG  PRO E 214      31.043  24.469  20.369  1.00 26.93           C  
ATOM   5379  CD  PRO E 214      32.010  23.264  20.229  1.00 23.50           C  
ATOM   5380  N   CYS E 215      34.356  26.915  18.332  1.00 24.48           N  
ATOM   5381  CA  CYS E 215      35.622  27.624  18.248  1.00 24.20           C  
ATOM   5382  C   CYS E 215      35.355  29.114  18.510  1.00 24.96           C  
ATOM   5383  O   CYS E 215      34.268  29.632  18.267  1.00 23.56           O  
ATOM   5384  CB  CYS E 215      36.263  27.392  16.835  1.00 25.89           C  
ATOM   5385  SG  CYS E 215      37.066  25.744  16.705  1.00 28.34           S  
ATOM   5386  N   LEU E 216      36.342  29.773  19.124  1.00 24.22           N  
ATOM   5387  CA  LEU E 216      36.268  31.169  19.356  1.00 25.14           C  
ATOM   5388  C   LEU E 216      37.051  31.766  18.210  1.00 24.90           C  
ATOM   5389  O   LEU E 216      38.277  31.572  18.154  1.00 26.14           O  
ATOM   5390  CB  LEU E 216      36.949  31.487  20.711  1.00 23.90           C  
ATOM   5391  CG  LEU E 216      36.659  32.785  21.373  1.00 29.80           C  
ATOM   5392  CD1 LEU E 216      35.137  32.788  21.701  1.00 30.04           C  
ATOM   5393  CD2 LEU E 216      37.554  32.776  22.655  1.00 31.96           C  
ATOM   5394  N   LEU E 217      36.372  32.563  17.369  1.00 23.81           N  
ATOM   5395  CA  LEU E 217      36.992  33.293  16.275  1.00 23.69           C  
ATOM   5396  C   LEU E 217      37.258  34.749  16.687  1.00 23.82           C  
ATOM   5397  O   LEU E 217      36.423  35.393  17.207  1.00 21.05           O  
ATOM   5398  CB  LEU E 217      36.022  33.255  15.040  1.00 24.59           C  
ATOM   5399  CG  LEU E 217      36.363  34.212  13.884  1.00 24.53           C  
ATOM   5400  CD1 LEU E 217      37.578  33.692  13.126  1.00 25.11           C  
ATOM   5401  CD2 LEU E 217      35.239  34.407  12.992  1.00 23.72           C  
ATOM   5402  N   ILE E 218      38.452  35.254  16.444  1.00 22.34           N  
ATOM   5403  CA  ILE E 218      38.670  36.679  16.559  1.00 24.23           C  
ATOM   5404  C   ILE E 218      39.160  37.094  15.170  1.00 23.83           C  
ATOM   5405  O   ILE E 218      40.243  36.647  14.700  1.00 21.92           O  
ATOM   5406  CB  ILE E 218      39.747  37.047  17.589  1.00 21.57           C  
ATOM   5407  CG1 ILE E 218      39.432  36.444  19.028  1.00 22.49           C  
ATOM   5408  CG2 ILE E 218      39.894  38.606  17.598  1.00 22.54           C  
ATOM   5409  CD1 ILE E 218      40.814  36.454  19.802  1.00 22.68           C  
ATOM   5410  N   ARG E 219      38.341  37.873  14.500  1.00 24.72           N  
ATOM   5411  CA  ARG E 219      38.727  38.453  13.251  1.00 25.91           C  
ATOM   5412  C   ARG E 219      39.340  39.789  13.557  1.00 27.75           C  
ATOM   5413  O   ARG E 219      38.695  40.612  14.237  1.00 26.74           O  
ATOM   5414  CB  ARG E 219      37.498  38.728  12.416  1.00 28.82           C  
ATOM   5415  CG  ARG E 219      36.859  37.542  11.807  1.00 29.19           C  
ATOM   5416  CD  ARG E 219      36.330  37.949  10.368  1.00 31.79           C  
ATOM   5417  NE  ARG E 219      35.340  39.040  10.356  1.00 30.17           N  
ATOM   5418  CZ  ARG E 219      34.042  38.862  10.667  1.00 32.64           C  
ATOM   5419  NH1 ARG E 219      33.592  37.666  11.100  1.00 28.38           N  
ATOM   5420  NH2 ARG E 219      33.203  39.878  10.608  1.00 32.47           N  
ATOM   5421  N   ARG E 220      40.544  40.034  13.019  1.00 27.22           N  
ATOM   5422  CA  ARG E 220      41.322  41.242  13.315  1.00 27.59           C  
ATOM   5423  C   ARG E 220      41.651  41.980  12.033  1.00 28.11           C  
ATOM   5424  O   ARG E 220      41.879  41.359  10.982  1.00 27.23           O  
ATOM   5425  CB  ARG E 220      42.621  40.929  14.042  1.00 28.97           C  
ATOM   5426  CG  ARG E 220      42.446  40.270  15.457  1.00 30.88           C  
ATOM   5427  CD  ARG E 220      43.502  40.726  16.503  1.00 39.54           C  
ATOM   5428  NE  ARG E 220      43.016  40.481  17.880  1.00 39.91           N  
ATOM   5429  CZ  ARG E 220      42.616  41.422  18.760  1.00 44.79           C  
ATOM   5430  NH1 ARG E 220      42.645  42.734  18.478  1.00 43.14           N  
ATOM   5431  NH2 ARG E 220      42.164  41.041  19.965  1.00 45.02           N  
ATOM   5432  N   ARG E 221      41.596  43.298  12.088  1.00 26.12           N  
ATOM   5433  CA  ARG E 221      42.113  44.090  11.004  1.00 26.39           C  
ATOM   5434  C   ARG E 221      42.860  45.248  11.587  1.00 25.48           C  
ATOM   5435  O   ARG E 221      42.473  45.777  12.639  1.00 23.80           O  
ATOM   5436  CB  ARG E 221      40.974  44.656  10.140  1.00 27.17           C  
ATOM   5437  CG  ARG E 221      40.220  43.621   9.369  1.00 31.14           C  
ATOM   5438  CD  ARG E 221      39.411  44.311   8.237  1.00 36.10           C  
ATOM   5439  NE  ARG E 221      38.353  45.207   8.745  1.00 34.76           N  
ATOM   5440  CZ  ARG E 221      37.581  45.972   7.984  1.00 37.82           C  
ATOM   5441  NH1 ARG E 221      37.734  45.957   6.670  1.00 39.08           N  
ATOM   5442  NH2 ARG E 221      36.645  46.755   8.526  1.00 33.35           N  
ATOM   5443  N   THR E 222      43.932  45.624  10.910  1.00 24.89           N  
ATOM   5444  CA  THR E 222      44.789  46.747  11.347  1.00 24.23           C  
ATOM   5445  C   THR E 222      45.047  47.740  10.179  1.00 24.23           C  
ATOM   5446  O   THR E 222      45.250  47.316   8.988  1.00 23.17           O  
ATOM   5447  CB  THR E 222      46.118  46.156  11.901  1.00 26.49           C  
ATOM   5448  OG1 THR E 222      45.816  45.105  12.863  1.00 21.92           O  
ATOM   5449  CG2 THR E 222      46.924  47.266  12.527  1.00 23.65           C  
ATOM   5450  N   TRP E 223      45.014  49.041  10.508  1.00 23.74           N  
ATOM   5451  CA  TRP E 223      45.229  50.112   9.537  1.00 25.54           C  
ATOM   5452  C   TRP E 223      46.510  50.843   9.880  1.00 26.35           C  
ATOM   5453  O   TRP E 223      46.907  50.899  11.042  1.00 25.08           O  
ATOM   5454  CB  TRP E 223      44.096  51.152   9.623  1.00 25.06           C  
ATOM   5455  CG  TRP E 223      42.749  50.672   9.096  1.00 26.55           C  
ATOM   5456  CD1 TRP E 223      42.176  50.943   7.849  1.00 28.17           C  
ATOM   5457  CD2 TRP E 223      41.810  49.841   9.781  1.00 26.32           C  
ATOM   5458  NE1 TRP E 223      40.952  50.314   7.742  1.00 26.05           N  
ATOM   5459  CE2 TRP E 223      40.704  49.640   8.914  1.00 25.68           C  
ATOM   5460  CE3 TRP E 223      41.807  49.224  11.025  1.00 27.10           C  
ATOM   5461  CZ2 TRP E 223      39.622  48.836   9.262  1.00 27.86           C  
ATOM   5462  CZ3 TRP E 223      40.725  48.447  11.373  1.00 28.19           C  
ATOM   5463  CH2 TRP E 223      39.641  48.269  10.507  1.00 28.38           C  
ATOM   5464  N   SER E 224      47.130  51.440   8.862  1.00 26.67           N  
ATOM   5465  CA  SER E 224      48.200  52.362   9.046  1.00 26.88           C  
ATOM   5466  C   SER E 224      47.672  53.668   8.437  1.00 27.52           C  
ATOM   5467  O   SER E 224      47.523  53.781   7.225  1.00 27.23           O  
ATOM   5468  CB  SER E 224      49.452  51.906   8.337  1.00 28.14           C  
ATOM   5469  OG  SER E 224      50.500  52.841   8.610  1.00 30.06           O  
ATOM   5470  N   GLY E 225      47.282  54.594   9.299  1.00 27.31           N  
ATOM   5471  CA  GLY E 225      46.516  55.771   8.869  1.00 29.25           C  
ATOM   5472  C   GLY E 225      45.223  55.228   8.311  1.00 29.47           C  
ATOM   5473  O   GLY E 225      44.528  54.465   9.012  1.00 30.11           O  
ATOM   5474  N   ARG E 226      44.922  55.563   7.047  1.00 29.52           N  
ATOM   5475  CA  ARG E 226      43.640  55.195   6.467  1.00 30.11           C  
ATOM   5476  C   ARG E 226      43.755  53.865   5.748  1.00 29.22           C  
ATOM   5477  O   ARG E 226      42.784  53.281   5.380  1.00 28.97           O  
ATOM   5478  CB  ARG E 226      43.103  56.288   5.509  1.00 29.24           C  
ATOM   5479  CG  ARG E 226      42.418  57.423   6.214  1.00 30.09           C  
ATOM   5480  CD  ARG E 226      42.347  58.705   5.278  1.00 33.29           C  
ATOM   5481  NE  ARG E 226      42.489  60.027   5.938  1.00 36.29           N  
ATOM   5482  CZ  ARG E 226      41.594  60.536   6.792  1.00 39.37           C  
ATOM   5483  NH1 ARG E 226      40.507  59.835   7.107  1.00 43.44           N  
ATOM   5484  NH2 ARG E 226      41.778  61.721   7.350  1.00 40.28           N  
ATOM   5485  N   GLN E 227      44.943  53.370   5.542  1.00 29.00           N  
ATOM   5486  CA  GLN E 227      44.968  52.170   4.751  1.00 29.99           C  
ATOM   5487  C   GLN E 227      45.002  50.876   5.560  1.00 29.75           C  
ATOM   5488  O   GLN E 227      45.756  50.776   6.522  1.00 26.24           O  
ATOM   5489  CB  GLN E 227      46.094  52.292   3.786  1.00 32.55           C  
ATOM   5490  CG  GLN E 227      47.190  51.284   3.808  1.00 35.54           C  
ATOM   5491  CD  GLN E 227      47.560  51.041   2.435  1.00 39.48           C  
ATOM   5492  OE1 GLN E 227      48.556  51.554   1.972  1.00 45.32           O  
ATOM   5493  NE2 GLN E 227      46.730  50.304   1.725  1.00 40.10           N  
ATOM   5494  N   PRO E 228      44.149  49.910   5.204  1.00 29.73           N  
ATOM   5495  CA  PRO E 228      44.216  48.556   5.776  1.00 30.61           C  
ATOM   5496  C   PRO E 228      45.539  47.874   5.438  1.00 30.41           C  
ATOM   5497  O   PRO E 228      46.001  47.879   4.284  1.00 33.22           O  
ATOM   5498  CB  PRO E 228      43.057  47.805   5.104  1.00 32.22           C  
ATOM   5499  CG  PRO E 228      42.118  48.908   4.514  1.00 30.32           C  
ATOM   5500  CD  PRO E 228      43.035  50.098   4.256  1.00 31.54           C  
ATOM   5501  N   VAL E 229      46.165  47.300   6.428  1.00 28.36           N  
ATOM   5502  CA  VAL E 229      47.488  46.710   6.256  1.00 27.54           C  
ATOM   5503  C   VAL E 229      47.293  45.236   6.228  1.00 26.19           C  
ATOM   5504  O   VAL E 229      47.910  44.536   5.398  1.00 25.96           O  
ATOM   5505  CB  VAL E 229      48.444  47.108   7.442  1.00 27.69           C  
ATOM   5506  CG1 VAL E 229      49.754  46.232   7.527  1.00 27.36           C  
ATOM   5507  CG2 VAL E 229      48.850  48.596   7.299  1.00 29.14           C  
ATOM   5508  N   THR E 230      46.458  44.730   7.135  1.00 25.01           N  
ATOM   5509  CA  THR E 230      46.438  43.292   7.403  1.00 22.12           C  
ATOM   5510  C   THR E 230      45.101  42.902   7.962  1.00 22.48           C  
ATOM   5511  O   THR E 230      44.425  43.727   8.620  1.00 21.46           O  
ATOM   5512  CB  THR E 230      47.654  42.930   8.291  1.00 24.35           C  
ATOM   5513  OG1 THR E 230      47.737  41.541   8.562  1.00 20.71           O  
ATOM   5514  CG2 THR E 230      47.751  43.744   9.672  1.00 21.41           C  
ATOM   5515  N   ALA E 231      44.666  41.695   7.651  1.00 21.72           N  
ATOM   5516  CA  ALA E 231      43.413  41.116   8.185  1.00 22.96           C  
ATOM   5517  C   ALA E 231      43.826  39.709   8.663  1.00 23.50           C  
ATOM   5518  O   ALA E 231      44.568  39.059   7.940  1.00 24.14           O  
ATOM   5519  CB  ALA E 231      42.423  40.954   7.101  1.00 22.98           C  
ATOM   5520  N   ALA E 232      43.335  39.238   9.799  1.00 22.56           N  
ATOM   5521  CA  ALA E 232      43.725  37.900  10.286  1.00 23.10           C  
ATOM   5522  C   ALA E 232      42.497  37.296  10.909  1.00 24.34           C  
ATOM   5523  O   ALA E 232      41.642  38.046  11.481  1.00 25.77           O  
ATOM   5524  CB  ALA E 232      44.809  38.006  11.334  1.00 21.87           C  
ATOM   5525  N   ARG E 233      42.410  35.958  10.811  1.00 24.66           N  
ATOM   5526  CA  ARG E 233      41.380  35.187  11.522  1.00 23.33           C  
ATOM   5527  C   ARG E 233      42.159  34.304  12.483  1.00 24.16           C  
ATOM   5528  O   ARG E 233      43.032  33.539  12.066  1.00 22.63           O  
ATOM   5529  CB  ARG E 233      40.568  34.328  10.579  1.00 24.60           C  
ATOM   5530  CG  ARG E 233      39.827  35.155   9.521  1.00 26.25           C  
ATOM   5531  CD  ARG E 233      39.270  34.191   8.408  1.00 34.27           C  
ATOM   5532  NE  ARG E 233      38.402  33.181   8.991  1.00 30.33           N  
ATOM   5533  CZ  ARG E 233      37.164  33.445   9.385  1.00 29.31           C  
ATOM   5534  NH1 ARG E 233      36.436  32.485   9.927  1.00 27.34           N  
ATOM   5535  NH2 ARG E 233      36.677  34.669   9.205  1.00 29.26           N  
ATOM   5536  N   LEU E 234      41.870  34.497  13.773  1.00 24.26           N  
ATOM   5537  CA  LEU E 234      42.448  33.707  14.895  1.00 24.39           C  
ATOM   5538  C   LEU E 234      41.363  32.740  15.337  1.00 24.86           C  
ATOM   5539  O   LEU E 234      40.316  33.148  15.825  1.00 23.40           O  
ATOM   5540  CB  LEU E 234      42.757  34.633  16.035  1.00 24.42           C  
ATOM   5541  CG  LEU E 234      43.996  35.487  16.079  1.00 26.05           C  
ATOM   5542  CD1 LEU E 234      44.522  35.783  14.720  1.00 27.82           C  
ATOM   5543  CD2 LEU E 234      43.780  36.752  16.830  1.00 34.56           C  
ATOM   5544  N   ILE E 235      41.622  31.463  15.191  1.00 25.28           N  
ATOM   5545  CA  ILE E 235      40.579  30.434  15.451  1.00 26.67           C  
ATOM   5546  C   ILE E 235      41.112  29.558  16.601  1.00 25.64           C  
ATOM   5547  O   ILE E 235      42.246  29.074  16.525  1.00 24.33           O  
ATOM   5548  CB  ILE E 235      40.298  29.584  14.169  1.00 27.23           C  
ATOM   5549  CG1 ILE E 235      39.828  30.478  13.009  1.00 31.89           C  
ATOM   5550  CG2 ILE E 235      39.256  28.541  14.472  1.00 29.80           C  
ATOM   5551  CD1 ILE E 235      40.181  30.007  11.542  1.00 29.62           C  
ATOM   5552  N   HIS E 236      40.337  29.415  17.690  1.00 23.80           N  
ATOM   5553  CA  HIS E 236      40.837  28.679  18.857  1.00 23.08           C  
ATOM   5554  C   HIS E 236      39.821  27.612  19.218  1.00 23.11           C  
ATOM   5555  O   HIS E 236      38.696  27.905  19.283  1.00 25.55           O  
ATOM   5556  CB  HIS E 236      40.850  29.550  20.049  1.00 21.35           C  
ATOM   5557  CG  HIS E 236      41.536  30.871  19.889  1.00 21.88           C  
ATOM   5558  ND1 HIS E 236      40.974  31.954  19.224  1.00 27.91           N  
ATOM   5559  CD2 HIS E 236      42.719  31.310  20.384  1.00 22.49           C  
ATOM   5560  CE1 HIS E 236      41.774  33.007  19.333  1.00 23.98           C  
ATOM   5561  NE2 HIS E 236      42.864  32.627  19.982  1.00 25.83           N  
ATOM   5562  N   PRO E 237      40.231  26.377  19.474  1.00 25.20           N  
ATOM   5563  CA  PRO E 237      39.335  25.464  20.125  1.00 25.03           C  
ATOM   5564  C   PRO E 237      38.667  26.070  21.291  1.00 25.25           C  
ATOM   5565  O   PRO E 237      39.354  26.492  22.226  1.00 26.32           O  
ATOM   5566  CB  PRO E 237      40.289  24.384  20.610  1.00 24.79           C  
ATOM   5567  CG  PRO E 237      41.228  24.235  19.475  1.00 25.93           C  
ATOM   5568  CD  PRO E 237      41.519  25.710  19.145  1.00 24.99           C  
ATOM   5569  N   GLY E 238      37.323  26.044  21.308  1.00 26.29           N  
ATOM   5570  CA  GLY E 238      36.582  26.616  22.414  1.00 26.46           C  
ATOM   5571  C   GLY E 238      36.940  26.013  23.759  1.00 28.09           C  
ATOM   5572  O   GLY E 238      36.878  26.677  24.789  1.00 29.02           O  
ATOM   5573  N   SER E 239      37.274  24.732  23.775  1.00 26.52           N  
ATOM   5574  CA  SER E 239      37.641  24.058  25.017  1.00 28.38           C  
ATOM   5575  C   SER E 239      39.058  24.298  25.473  1.00 28.61           C  
ATOM   5576  O   SER E 239      39.405  23.855  26.573  1.00 29.18           O  
ATOM   5577  CB  SER E 239      37.433  22.533  24.888  1.00 28.00           C  
ATOM   5578  OG  SER E 239      38.353  22.068  23.952  1.00 25.29           O  
ATOM   5579  N   ARG E 240      39.867  24.981  24.651  1.00 28.73           N  
ATOM   5580  CA  ARG E 240      41.287  25.179  24.962  1.00 30.40           C  
ATOM   5581  C   ARG E 240      41.738  26.632  25.161  1.00 31.37           C  
ATOM   5582  O   ARG E 240      42.936  26.873  25.313  1.00 31.84           O  
ATOM   5583  CB  ARG E 240      42.187  24.552  23.873  1.00 29.47           C  
ATOM   5584  CG  ARG E 240      41.902  23.070  23.623  1.00 30.34           C  
ATOM   5585  CD  ARG E 240      42.855  22.412  22.647  1.00 29.41           C  
ATOM   5586  NE  ARG E 240      42.248  21.134  22.207  1.00 27.02           N  
ATOM   5587  CZ  ARG E 240      42.411  20.636  20.988  1.00 27.96           C  
ATOM   5588  NH1 ARG E 240      43.188  21.265  20.111  1.00 23.65           N  
ATOM   5589  NH2 ARG E 240      41.797  19.512  20.628  1.00 26.68           N  
ATOM   5590  N   HIS E 241      40.826  27.603  25.047  1.00 31.30           N  
ATOM   5591  CA  HIS E 241      41.246  29.021  25.090  1.00 32.62           C  
ATOM   5592  C   HIS E 241      40.032  29.842  25.427  1.00 32.10           C  
ATOM   5593  O   HIS E 241      38.954  29.589  24.849  1.00 31.75           O  
ATOM   5594  CB  HIS E 241      41.846  29.537  23.741  1.00 33.52           C  
ATOM   5595  CG  HIS E 241      42.365  30.955  23.804  1.00 36.35           C  
ATOM   5596  ND1 HIS E 241      43.458  31.320  24.570  1.00 42.22           N  
ATOM   5597  CD2 HIS E 241      41.890  32.110  23.271  1.00 40.41           C  
ATOM   5598  CE1 HIS E 241      43.659  32.624  24.470  1.00 42.18           C  
ATOM   5599  NE2 HIS E 241      42.725  33.128  23.685  1.00 41.72           N  
ATOM   5600  N   ARG E 242      40.203  30.779  26.363  1.00 29.50           N  
ATOM   5601  CA  ARG E 242      39.149  31.741  26.693  1.00 29.48           C  
ATOM   5602  C   ARG E 242      39.740  33.135  26.666  1.00 27.65           C  
ATOM   5603  O   ARG E 242      40.973  33.275  26.800  1.00 27.75           O  
ATOM   5604  CB  ARG E 242      38.517  31.434  28.061  1.00 30.67           C  
ATOM   5605  CG  ARG E 242      39.532  31.295  29.251  1.00 30.94           C  
ATOM   5606  CD  ARG E 242      38.869  30.990  30.610  1.00 33.57           C  
ATOM   5607  NE  ARG E 242      37.958  29.837  30.580  1.00 46.57           N  
ATOM   5608  CZ  ARG E 242      37.507  29.169  31.652  1.00 50.38           C  
ATOM   5609  NH1 ARG E 242      37.831  29.506  32.921  1.00 54.00           N  
ATOM   5610  NH2 ARG E 242      36.686  28.154  31.450  1.00 56.39           N  
ATOM   5611  N   LEU E 243      38.911  34.150  26.446  1.00 26.03           N  
ATOM   5612  CA  LEU E 243      39.368  35.548  26.555  1.00 26.59           C  
ATOM   5613  C   LEU E 243      39.032  35.992  27.972  1.00 26.60           C  
ATOM   5614  O   LEU E 243      37.933  35.687  28.461  1.00 25.84           O  
ATOM   5615  CB  LEU E 243      38.627  36.474  25.583  1.00 27.55           C  
ATOM   5616  CG  LEU E 243      38.778  36.132  24.089  1.00 30.40           C  
ATOM   5617  CD1 LEU E 243      37.950  37.160  23.240  1.00 33.00           C  
ATOM   5618  CD2 LEU E 243      40.203  36.131  23.589  1.00 31.14           C  
ATOM   5619  N   GLU E 244      39.944  36.694  28.626  1.00 26.30           N  
ATOM   5620  CA  GLU E 244      39.735  37.020  30.023  1.00 28.10           C  
ATOM   5621  C   GLU E 244      40.193  38.448  30.251  1.00 26.32           C  
ATOM   5622  O   GLU E 244      41.256  38.830  29.711  1.00 25.56           O  
ATOM   5623  CB  GLU E 244      40.574  36.070  30.921  1.00 28.16           C  
ATOM   5624  CG  GLU E 244      39.871  34.766  31.309  1.00 33.27           C  
ATOM   5625  CD  GLU E 244      40.756  33.786  32.119  1.00 35.20           C  
ATOM   5626  OE1 GLU E 244      41.582  34.210  32.954  1.00 42.01           O  
ATOM   5627  OE2 GLU E 244      40.613  32.564  31.905  1.00 44.07           O  
ATOM   5628  N   GLY E 245      39.447  39.205  31.051  1.00 24.95           N  
ATOM   5629  CA  GLY E 245      39.887  40.567  31.397  1.00 25.38           C  
ATOM   5630  C   GLY E 245      39.135  41.179  32.557  1.00 26.08           C  
ATOM   5631  O   GLY E 245      38.054  40.688  32.951  1.00 23.63           O  
ATOM   5632  N   ARG E 246      39.724  42.251  33.116  1.00 26.03           N  
ATOM   5633  CA  ARG E 246      39.143  42.992  34.223  1.00 27.17           C  
ATOM   5634  C   ARG E 246      39.383  44.464  33.866  1.00 26.91           C  
ATOM   5635  O   ARG E 246      40.472  44.824  33.379  1.00 25.66           O  
ATOM   5636  CB  ARG E 246      39.852  42.599  35.528  1.00 26.76           C  
ATOM   5637  CG  ARG E 246      39.327  43.234  36.820  1.00 30.26           C  
ATOM   5638  CD  ARG E 246      40.221  42.814  38.027  1.00 32.70           C  
ATOM   5639  NE  ARG E 246      41.542  42.541  37.472  1.00 42.51           N  
ATOM   5640  CZ  ARG E 246      42.734  42.816  38.018  1.00 44.66           C  
ATOM   5641  NH1 ARG E 246      43.835  42.514  37.319  1.00 36.23           N  
ATOM   5642  NH2 ARG E 246      42.834  43.370  39.232  1.00 46.24           N  
ATOM   5643  N   PHE E 247      38.367  45.289  34.097  1.00 26.21           N  
ATOM   5644  CA  PHE E 247      38.345  46.713  33.699  1.00 27.63           C  
ATOM   5645  C   PHE E 247      37.660  47.528  34.784  1.00 27.37           C  
ATOM   5646  O   PHE E 247      36.631  47.111  35.352  1.00 27.62           O  
ATOM   5647  CB  PHE E 247      37.558  46.850  32.380  1.00 28.40           C  
ATOM   5648  CG  PHE E 247      36.227  46.126  32.398  1.00 35.07           C  
ATOM   5649  CD1 PHE E 247      35.036  46.796  32.802  1.00 39.27           C  
ATOM   5650  CD2 PHE E 247      36.140  44.753  32.063  1.00 38.22           C  
ATOM   5651  CE1 PHE E 247      33.796  46.128  32.825  1.00 37.56           C  
ATOM   5652  CE2 PHE E 247      34.870  44.055  32.113  1.00 38.72           C  
ATOM   5653  CZ  PHE E 247      33.717  44.747  32.476  1.00 38.75           C  
ATOM   5654  N   THR E 248      38.213  48.678  35.124  1.00 26.81           N  
ATOM   5655  CA  THR E 248      37.484  49.577  35.994  1.00 27.45           C  
ATOM   5656  C   THR E 248      36.359  50.257  35.197  1.00 29.39           C  
ATOM   5657  O   THR E 248      36.369  50.263  33.947  1.00 28.46           O  
ATOM   5658  CB  THR E 248      38.372  50.619  36.667  1.00 27.53           C  
ATOM   5659  OG1 THR E 248      39.275  51.165  35.693  1.00 25.86           O  
ATOM   5660  CG2 THR E 248      39.144  50.000  37.805  1.00 28.17           C  
ATOM   5661  N   LYS E 249      35.400  50.812  35.932  1.00 30.38           N  
ATOM   5662  CA  LYS E 249      34.166  51.325  35.366  1.00 32.55           C  
ATOM   5663  C   LYS E 249      34.051  52.840  35.585  1.00 33.86           C  
ATOM   5664  O   LYS E 249      35.059  53.540  35.733  1.00 34.82           O  
ATOM   5665  CB  LYS E 249      32.979  50.641  36.034  1.00 32.30           C  
ATOM   5666  CG  LYS E 249      32.483  49.469  35.288  1.00 30.82           C  
ATOM   5667  CD  LYS E 249      31.565  48.680  36.120  1.00 35.70           C  
ATOM   5668  CE  LYS E 249      31.729  47.237  35.726  1.00 36.17           C  
ATOM   5669  NZ  LYS E 249      31.180  46.987  34.368  1.00 39.53           N  
TER    5670      LYS E 249                                                      
END
MOLECULE T0455.pdb
ATOM    981  N   SER     7      55.366  26.966  20.854  1.00 66.80           N  
ATOM    982  CA  SER     7      55.702  26.695  19.421  1.00 66.93           C  
ATOM    983  CB  SER     7      56.100  25.225  19.176  1.00 67.14           C  
ATOM    984  OG  SER     7      57.045  25.126  18.105  1.00 67.50           O  
ATOM    985  C   SER     7      54.546  27.029  18.496  1.00 67.22           C  
ATOM    986  O   SER     7      53.366  27.033  18.892  1.00 67.58           O  
ATOM    987  N   SER     8      54.906  27.266  17.235  1.00 67.10           N  
ATOM    988  CA  SER     8      53.963  27.599  16.177  1.00 66.00           C  
ATOM    989  CB  SER     8      53.890  29.128  16.007  1.00 66.59           C  
ATOM    990  OG  SER     8      53.375  29.536  14.732  1.00 67.49           O  
ATOM    991  C   SER     8      54.435  26.946  14.895  1.00 65.24           C  
ATOM    992  O   SER     8      55.612  26.779  14.693  1.00 65.20           O  
ATOM    993  N   ARG     9      53.508  26.618  14.012  1.00 64.59           N  
ATOM    994  CA  ARG     9      53.810  25.902  12.777  1.00 63.46           C  
ATOM    995  CB  ARG     9      53.323  24.452  12.955  1.00 63.59           C  
ATOM    996  CG  ARG     9      53.608  23.502  11.797  1.00 64.77           C  
ATOM    997  CD  ARG     9      52.566  22.383  11.682  1.00 66.10           C  
ATOM    998  NE  ARG     9      52.289  22.125  10.265  1.00 69.18           N  
ATOM    999  CZ  ARG     9      51.219  21.496   9.777  1.00 70.75           C  
ATOM   1000  NH1 ARG     9      50.269  21.019  10.575  1.00 72.26           N  
ATOM   1001  NH2 ARG     9      51.092  21.339   8.461  1.00 71.12           N  
ATOM   1002  C   ARG     9      53.114  26.578  11.573  1.00 61.94           C  
ATOM   1003  O   ARG     9      51.876  26.647  11.512  1.00 62.08           O  
ATOM   1004  N   THR    10      53.888  27.073  10.614  1.00 60.07           N  
ATOM   1005  CA  THR    10      53.296  27.593   9.384  1.00 58.73           C  
ATOM   1006  CB  THR    10      54.264  28.455   8.588  1.00 58.55           C  
ATOM   1007  OG1 THR    10      54.907  29.383   9.450  1.00 58.12           O  
ATOM   1008  CG2 THR    10      53.523  29.236   7.573  1.00 59.32           C  
ATOM   1009  C   THR    10      52.835  26.470   8.477  1.00 57.08           C  
ATOM   1010  O   THR    10      53.626  25.822   7.873  1.00 57.73           O  
ATOM   1011  N   VAL    11      51.540  26.266   8.388  1.00 55.72           N  
ATOM   1012  CA  VAL    11      50.919  25.326   7.461  1.00 54.80           C  
ATOM   1013  CB  VAL    11      49.451  25.178   7.858  1.00 54.58           C  
ATOM   1014  CG1 VAL    11      48.606  24.505   6.741  1.00 53.03           C  
ATOM   1015  CG2 VAL    11      49.372  24.461   9.181  1.00 55.59           C  
ATOM   1016  C   VAL    11      50.944  25.731   5.966  1.00 54.04           C  
ATOM   1017  O   VAL    11      50.990  24.876   5.094  1.00 54.13           O  
ATOM   1018  N   SER    12      50.805  27.015   5.655  1.00 52.92           N  
ATOM   1019  CA  SER    12      51.032  27.471   4.287  1.00 51.89           C  
ATOM   1020  CB  SER    12      49.826  27.206   3.405  1.00 51.67           C  
ATOM   1021  OG  SER    12      48.768  27.971   3.862  1.00 52.50           O  
ATOM   1022  C   SER    12      51.419  28.946   4.220  1.00 49.85           C  
ATOM   1023  O   SER    12      51.261  29.690   5.178  1.00 48.66           O  
ATOM   1024  N   TYR    13      51.929  29.353   3.068  1.00 47.92           N  
ATOM   1025  CA  TYR    13      52.545  30.644   2.962  1.00 47.09           C  
ATOM   1026  CB  TYR    13      53.859  30.625   3.746  1.00 47.17           C  
ATOM   1027  CG  TYR    13      54.529  31.952   3.919  1.00 46.90           C  
ATOM   1028  CD1 TYR    13      54.225  32.765   4.984  1.00 46.52           C  
ATOM   1029  CE1 TYR    13      54.846  33.984   5.160  1.00 46.47           C  
ATOM   1030  CZ  TYR    13      55.790  34.394   4.276  1.00 47.95           C  
ATOM   1031  OH  TYR    13      56.430  35.596   4.451  1.00 48.26           O  
ATOM   1032  CE2 TYR    13      56.117  33.596   3.211  1.00 48.07           C  
ATOM   1033  CD2 TYR    13      55.473  32.383   3.040  1.00 46.54           C  
ATOM   1034  C   TYR    13      52.797  30.938   1.493  1.00 46.32           C  
ATOM   1035  O   TYR    13      53.632  30.328   0.871  1.00 46.29           O  
ATOM   1036  N   PHE    14      52.044  31.870   0.939  1.00 45.80           N  
ATOM   1037  CA  PHE    14      52.161  32.209  -0.459  1.00 45.02           C  
ATOM   1038  CB  PHE    14      51.686  31.051  -1.319  1.00 44.87           C  
ATOM   1039  CG  PHE    14      50.249  30.696  -1.134  1.00 44.59           C  
ATOM   1040  CD1 PHE    14      49.896  29.556  -0.461  1.00 44.02           C  
ATOM   1041  CE1 PHE    14      48.570  29.210  -0.313  1.00 45.96           C  
ATOM   1042  CZ  PHE    14      47.567  29.997  -0.874  1.00 44.63           C  
ATOM   1043  CE2 PHE    14      47.905  31.136  -1.549  1.00 44.54           C  
ATOM   1044  CD2 PHE    14      49.241  31.479  -1.693  1.00 45.21           C  
ATOM   1045  C   PHE    14      51.395  33.464  -0.837  1.00 44.29           C  
ATOM   1046  O   PHE    14      50.458  33.895  -0.143  1.00 44.89           O  
ATOM   1047  N   VAL    15      51.772  33.998  -1.982  1.00 43.49           N  
ATOM   1048  CA  VAL    15      51.210  35.211  -2.498  1.00 43.41           C  
ATOM   1049  CB  VAL    15      52.299  35.963  -3.246  1.00 43.05           C  
ATOM   1050  CG1 VAL    15      51.764  37.141  -3.945  1.00 42.02           C  
ATOM   1051  CG2 VAL    15      53.372  36.367  -2.278  1.00 42.40           C  
ATOM   1052  C   VAL    15      50.034  34.908  -3.419  1.00 43.85           C  
ATOM   1053  O   VAL    15      50.064  33.992  -4.228  1.00 44.16           O  
ATOM   1054  N   ALA    16      48.981  35.689  -3.297  1.00 44.56           N  
ATOM   1055  CA  ALA    16      47.768  35.460  -4.066  1.00 44.69           C  
ATOM   1056  CB  ALA    16      46.796  34.653  -3.280  1.00 43.79           C  
ATOM   1057  C   ALA    16      47.157  36.787  -4.396  1.00 45.56           C  
ATOM   1058  O   ALA    16      47.487  37.798  -3.788  1.00 46.06           O  
ATOM   1059  N   LYS    17      46.293  36.797  -5.392  1.00 46.31           N  
ATOM   1060  CA  LYS    17      45.523  37.984  -5.648  1.00 47.32           C  
ATOM   1061  CB  LYS    17      45.167  38.115  -7.151  1.00 47.08           C  
ATOM   1062  CG  LYS    17      46.452  38.029  -8.006  1.00 49.26           C  
ATOM   1063  CD  LYS    17      46.559  38.957  -9.180  1.00 49.63           C  
ATOM   1064  CE  LYS    17      45.585  38.494 -10.345  1.00 54.44           C  
ATOM   1065  NZ  LYS    17      46.079  38.686 -11.787  1.00 50.61           N  
ATOM   1066  C   LYS    17      44.361  37.841  -4.679  1.00 47.08           C  
ATOM   1067  O   LYS    17      43.964  36.750  -4.340  1.00 47.55           O  
ATOM   1068  N   PRO    18      43.857  38.939  -4.170  1.00 47.03           N  
ATOM   1069  CA  PRO    18      42.953  38.814  -3.060  1.00 47.50           C  
ATOM   1070  CB  PRO    18      42.848  40.259  -2.554  1.00 47.75           C  
ATOM   1071  CG  PRO    18      43.077  41.081  -3.791  1.00 47.83           C  
ATOM   1072  CD  PRO    18      44.073  40.330  -4.580  1.00 47.03           C  
ATOM   1073  C   PRO    18      41.580  38.326  -3.460  1.00 47.37           C  
ATOM   1074  O   PRO    18      41.135  38.614  -4.549  1.00 47.23           O  
ATOM   1075  N   SER    19      40.911  37.632  -2.551  1.00 47.79           N  
ATOM   1076  CA  SER    19      39.484  37.325  -2.670  1.00 48.25           C  
ATOM   1077  CB  SER    19      39.150  36.281  -1.617  1.00 47.61           C  
ATOM   1078  OG  SER    19      39.108  36.882  -0.326  1.00 49.49           O  
ATOM   1079  C   SER    19      38.607  38.592  -2.423  1.00 48.80           C  
ATOM   1080  O   SER    19      39.106  39.650  -2.010  1.00 48.76           O  
ATOM   1081  N   SER    20      37.301  38.484  -2.623  1.00 48.97           N  
ATOM   1082  CA  SER    20      36.422  39.623  -2.332  1.00 49.63           C  
ATOM   1083  CB  SER    20      34.972  39.229  -2.590  1.00 49.72           C  
ATOM   1084  OG  SER    20      34.907  38.531  -3.822  1.00 53.35           O  
ATOM   1085  C   SER    20      36.522  40.148  -0.900  1.00 49.91           C  
ATOM   1086  O   SER    20      36.648  41.363  -0.654  1.00 49.90           O  
ATOM   1087  N   SER    21      36.417  39.246   0.064  1.00 49.95           N  
ATOM   1088  CA  SER    21      36.420  39.712   1.429  1.00 49.61           C  
ATOM   1089  CB  SER    21      36.018  38.615   2.413  1.00 49.01           C  
ATOM   1090  OG  SER    21      37.102  37.851   2.775  1.00 49.97           O  
ATOM   1091  C   SER    21      37.807  40.311   1.701  1.00 49.66           C  
ATOM   1092  O   SER    21      37.934  41.296   2.430  1.00 49.35           O  
ATOM   1093  N   GLU    22      38.837  39.762   1.064  1.00 49.14           N  
ATOM   1094  CA  GLU    22      40.149  40.301   1.291  1.00 49.16           C  
ATOM   1095  CB  GLU    22      41.231  39.338   0.789  1.00 49.18           C  
ATOM   1096  CG  GLU    22      41.352  38.099   1.671  1.00 48.36           C  
ATOM   1097  CD  GLU    22      42.337  37.057   1.151  1.00 47.87           C  
ATOM   1098  OE1 GLU    22      42.607  37.030  -0.058  1.00 48.49           O  
ATOM   1099  OE2 GLU    22      42.841  36.256   1.961  1.00 43.16           O  
ATOM   1100  C   GLU    22      40.246  41.692   0.668  1.00 49.40           C  
ATOM   1101  O   GLU    22      40.855  42.576   1.232  1.00 49.08           O  
ATOM   1102  N   MET    23      39.637  41.897  -0.493  1.00 50.38           N  
ATOM   1103  CA  MET    23      39.667  43.215  -1.147  1.00 50.41           C  
ATOM   1104  CB  MET    23      38.957  43.155  -2.491  1.00 50.70           C  
ATOM   1105  CG  MET    23      39.736  42.378  -3.537  1.00 51.45           C  
ATOM   1106  SD  MET    23      38.879  42.251  -5.118  1.00 48.27           S  
ATOM   1107  CE  MET    23      38.583  44.004  -5.360  1.00 45.34           C  
ATOM   1108  C   MET    23      38.973  44.241  -0.259  1.00 51.76           C  
ATOM   1109  O   MET    23      39.481  45.323   0.001  1.00 51.94           O  
ATOM   1110  N   GLU    24      37.806  43.860   0.215  1.00 53.13           N  
ATOM   1111  CA  GLU    24      36.978  44.722   1.005  1.00 53.62           C  
ATOM   1112  CB  GLU    24      35.644  43.973   1.229  1.00 54.72           C  
ATOM   1113  CG  GLU    24      34.450  44.799   1.705  1.00 56.70           C  
ATOM   1114  CD  GLU    24      33.999  44.474   3.115  1.00 64.20           C  
ATOM   1115  OE1 GLU    24      34.727  43.777   3.857  1.00 69.18           O  
ATOM   1116  OE2 GLU    24      32.894  44.923   3.487  1.00 70.36           O  
ATOM   1117  C   GLU    24      37.682  45.148   2.333  1.00 53.63           C  
ATOM   1118  O   GLU    24      37.833  46.347   2.595  1.00 53.82           O  
ATOM   1119  N   LYS    25      38.136  44.175   3.128  1.00 52.64           N  
ATOM   1120  CA  LYS    25      38.749  44.447   4.431  1.00 52.19           C  
ATOM   1121  CB  LYS    25      38.972  43.161   5.229  1.00 52.35           C  
ATOM   1122  CG  LYS    25      37.796  42.253   5.370  1.00 54.27           C  
ATOM   1123  CD  LYS    25      36.775  42.727   6.383  1.00 54.98           C  
ATOM   1124  CE  LYS    25      35.645  41.721   6.435  1.00 55.23           C  
ATOM   1125  NZ  LYS    25      34.500  42.241   7.228  1.00 58.74           N  
ATOM   1126  C   LYS    25      40.126  45.101   4.337  1.00 51.74           C  
ATOM   1127  O   LYS    25      40.522  45.839   5.221  1.00 51.11           O  
ATOM   1128  N   LEU    26      40.904  44.760   3.317  1.00 51.27           N  
ATOM   1129  CA  LEU    26      42.245  45.312   3.206  1.00 50.74           C  
ATOM   1130  CB  LEU    26      43.233  44.246   2.740  1.00 50.18           C  
ATOM   1131  CG  LEU    26      43.618  43.149   3.733  1.00 47.96           C  
ATOM   1132  CD1 LEU    26      44.658  42.174   3.109  1.00 46.25           C  
ATOM   1133  CD2 LEU    26      44.156  43.767   5.006  1.00 42.03           C  
ATOM   1134  C   LEU    26      42.221  46.502   2.257  1.00 50.78           C  
ATOM   1135  O   LEU    26      43.232  47.183   2.078  1.00 50.95           O  
ATOM   1136  N   GLN    27      41.046  46.741   1.674  1.00 50.93           N  
ATOM   1137  CA  GLN    27      40.790  47.883   0.818  1.00 51.30           C  
ATOM   1138  CB  GLN    27      40.880  49.193   1.589  1.00 51.58           C  
ATOM   1139  CG  GLN    27      39.651  49.523   2.408  1.00 51.59           C  
ATOM   1140  CD  GLN    27      40.005  50.504   3.513  1.00 52.59           C  
ATOM   1141  OE1 GLN    27      40.855  51.376   3.301  1.00 57.18           O  
ATOM   1142  NE2 GLN    27      39.395  50.352   4.705  1.00 47.63           N  
ATOM   1143  C   GLN    27      41.784  47.854  -0.288  1.00 51.13           C  
ATOM   1144  O   GLN    27      42.718  48.634  -0.303  1.00 51.14           O  
ATOM   1145  N   LEU    28      41.581  46.907  -1.186  1.00 51.34           N  
ATOM   1146  CA  LEU    28      42.533  46.602  -2.222  1.00 51.53           C  
ATOM   1147  CB  LEU    28      43.388  45.390  -1.844  1.00 51.82           C  
ATOM   1148  CG  LEU    28      44.417  45.402  -0.707  1.00 52.24           C  
ATOM   1149  CD1 LEU    28      44.895  43.970  -0.469  1.00 53.58           C  
ATOM   1150  CD2 LEU    28      45.608  46.284  -1.015  1.00 51.65           C  
ATOM   1151  C   LEU    28      41.735  46.233  -3.430  1.00 51.61           C  
ATOM   1152  O   LEU    28      40.639  45.693  -3.341  1.00 51.58           O  
ATOM   1153  N   GLY    29      42.294  46.528  -4.580  1.00 52.42           N  
ATOM   1154  CA  GLY    29      41.641  46.189  -5.819  1.00 52.85           C  
ATOM   1155  C   GLY    29      41.988  44.757  -6.143  1.00 53.36           C  
ATOM   1156  O   GLY    29      42.916  44.153  -5.531  1.00 53.17           O  
ATOM   1157  N   PRO    30      41.295  44.205  -7.145  1.00 53.25           N  
ATOM   1158  CA  PRO    30      41.705  42.884  -7.543  1.00 53.02           C  
ATOM   1159  CB  PRO    30      40.734  42.547  -8.672  1.00 53.13           C  
ATOM   1160  CG  PRO    30      40.410  43.900  -9.290  1.00 52.75           C  
ATOM   1161  CD  PRO    30      40.292  44.775  -8.062  1.00 53.59           C  
ATOM   1162  C   PRO    30      43.078  43.193  -8.077  1.00 53.01           C  
ATOM   1163  O   PRO    30      43.350  44.381  -8.383  1.00 54.66           O  
ATOM   1164  N   GLU    31      43.956  42.223  -8.183  1.00 51.87           N  
ATOM   1165  CA  GLU    31      45.290  42.538  -8.729  1.00 51.91           C  
ATOM   1166  CB  GLU    31      45.234  43.438 -10.001  1.00 52.64           C  
ATOM   1167  CG  GLU    31      44.212  43.010 -11.088  1.00 54.99           C  
ATOM   1168  CD  GLU    31      44.468  41.589 -11.570  1.00 58.60           C  
ATOM   1169  OE1 GLU    31      45.587  41.387 -12.100  1.00 61.18           O  
ATOM   1170  OE2 GLU    31      43.590  40.688 -11.375  1.00 58.99           O  
ATOM   1171  C   GLU    31      46.291  43.147  -7.767  1.00 50.56           C  
ATOM   1172  O   GLU    31      47.457  43.132  -8.085  1.00 49.87           O  
ATOM   1173  N   ASP    32      45.879  43.688  -6.623  1.00 50.08           N  
ATOM   1174  CA  ASP    32      46.867  43.943  -5.552  1.00 49.96           C  
ATOM   1175  CB  ASP    32      46.415  44.986  -4.524  1.00 50.42           C  
ATOM   1176  CG  ASP    32      46.106  46.339  -5.137  1.00 52.23           C  
ATOM   1177  OD1 ASP    32      46.755  46.714  -6.137  1.00 49.25           O  
ATOM   1178  OD2 ASP    32      45.206  47.039  -4.583  1.00 56.11           O  
ATOM   1179  C   ASP    32      47.161  42.637  -4.810  1.00 49.17           C  
ATOM   1180  O   ASP    32      46.325  42.121  -4.090  1.00 49.32           O  
ATOM   1181  N   SER    33      48.361  42.112  -4.964  1.00 48.16           N  
ATOM   1182  CA  SER    33      48.732  40.910  -4.255  1.00 47.49           C  
ATOM   1183  CB  SER    33      50.137  40.523  -4.637  1.00 47.56           C  
ATOM   1184  OG  SER    33      50.154  40.261  -6.019  1.00 49.46           O  
ATOM   1185  C   SER    33      48.689  41.097  -2.767  1.00 46.69           C  
ATOM   1186  O   SER    33      48.962  42.183  -2.251  1.00 46.07           O  
ATOM   1187  N   ILE    34      48.380  39.995  -2.095  1.00 46.52           N  
ATOM   1188  CA  ILE    34      48.427  39.862  -0.650  1.00 45.49           C  
ATOM   1189  CB  ILE    34      47.045  39.603  -0.080  1.00 45.17           C  
ATOM   1190  CG1 ILE    34      46.457  38.309  -0.690  1.00 45.25           C  
ATOM   1191  CD1 ILE    34      45.695  37.367   0.276  1.00 44.50           C  
ATOM   1192  CG2 ILE    34      46.135  40.804  -0.339  1.00 42.34           C  
ATOM   1193  C   ILE    34      49.311  38.652  -0.340  1.00 45.62           C  
ATOM   1194  O   ILE    34      49.522  37.788  -1.180  1.00 45.44           O  
ATOM   1195  N   LEU    35      49.863  38.626   0.861  1.00 46.28           N  
ATOM   1196  CA  LEU    35      50.570  37.472   1.381  1.00 46.29           C  
ATOM   1197  CB  LEU    35      51.739  37.900   2.258  1.00 46.24           C  
ATOM   1198  CG  LEU    35      52.555  36.739   2.818  1.00 46.30           C  
ATOM   1199  CD1 LEU    35      53.202  35.964   1.632  1.00 43.82           C  
ATOM   1200  CD2 LEU    35      53.613  37.223   3.811  1.00 45.71           C  
ATOM   1201  C   LEU    35      49.570  36.734   2.224  1.00 46.83           C  
ATOM   1202  O   LEU    35      48.918  37.323   3.061  1.00 46.30           O  
ATOM   1203  N   ARG    36      49.422  35.449   1.998  1.00 47.99           N  
ATOM   1204  CA  ARG    36      48.435  34.723   2.731  1.00 49.43           C  
ATOM   1205  CB  ARG    36      47.475  34.086   1.784  1.00 50.62           C  
ATOM   1206  CG  ARG    36      46.181  33.772   2.453  1.00 53.89           C  
ATOM   1207  CD  ARG    36      45.692  32.395   2.149  1.00 59.18           C  
ATOM   1208  NE  ARG    36      44.273  32.418   2.300  1.00 60.92           N  
ATOM   1209  CZ  ARG    36      43.443  32.961   1.416  1.00 66.27           C  
ATOM   1210  NH1 ARG    36      43.904  33.493   0.245  1.00 67.71           N  
ATOM   1211  NH2 ARG    36      42.123  32.947   1.696  1.00 67.71           N  
ATOM   1212  C   ARG    36      49.139  33.650   3.441  1.00 49.82           C  
ATOM   1213  O   ARG    36      49.901  32.904   2.825  1.00 50.82           O  
ATOM   1214  N   MET    37      48.945  33.594   4.741  1.00 50.15           N  
ATOM   1215  CA  MET    37      49.644  32.619   5.577  1.00 50.53           C  
ATOM   1216  CB  MET    37      50.901  33.205   6.204  1.00 50.08           C  
ATOM   1217  CG  MET    37      50.757  34.217   7.314  1.00 51.20           C  
ATOM   1218  SD  MET    37      52.335  34.422   8.203  1.00 51.62           S  
ATOM   1219  CE  MET    37      52.342  32.968   9.266  1.00 49.85           C  
ATOM   1220  C   MET    37      48.714  32.010   6.607  1.00 50.57           C  
ATOM   1221  O   MET    37      47.775  32.655   7.100  1.00 49.67           O  
ATOM   1222  N   GLU    38      48.921  30.720   6.826  1.00 51.66           N  
ATOM   1223  CA  GLU    38      48.084  29.905   7.695  1.00 52.46           C  
ATOM   1224  CB  GLU    38      47.480  28.763   6.923  1.00 52.43           C  
ATOM   1225  CG  GLU    38      46.339  29.190   6.094  1.00 54.18           C  
ATOM   1226  CD  GLU    38      45.824  28.125   5.183  1.00 54.07           C  
ATOM   1227  OE1 GLU    38      46.293  26.963   5.227  1.00 55.92           O  
ATOM   1228  OE2 GLU    38      44.944  28.487   4.405  1.00 57.93           O  
ATOM   1229  C   GLU    38      48.987  29.308   8.722  1.00 53.53           C  
ATOM   1230  O   GLU    38      50.086  28.872   8.378  1.00 53.65           O  
ATOM   1231  N   ARG    39      48.515  29.216   9.952  1.00 54.36           N  
ATOM   1232  CA  ARG    39      49.404  28.937  11.052  1.00 56.22           C  
ATOM   1233  CB  ARG    39      49.977  30.287  11.452  1.00 56.60           C  
ATOM   1234  CG  ARG    39      50.997  30.297  12.521  1.00 59.42           C  
ATOM   1235  CD  ARG    39      50.693  31.391  13.599  1.00 61.15           C  
ATOM   1236  NE  ARG    39      50.895  32.768  13.118  1.00 64.98           N  
ATOM   1237  CZ  ARG    39      52.083  33.380  13.027  1.00 66.66           C  
ATOM   1238  NH1 ARG    39      53.217  32.762  13.369  1.00 63.65           N  
ATOM   1239  NH2 ARG    39      52.126  34.633  12.574  1.00 68.83           N  
ATOM   1240  C   ARG    39      48.649  28.274  12.212  1.00 55.31           C  
ATOM   1241  O   ARG    39      47.551  28.682  12.530  1.00 54.64           O  
ATOM   1242  N   ILE    40      49.226  27.219  12.786  1.00 55.53           N  
ATOM   1243  CA  ILE    40      48.746  26.595  14.045  1.00 55.67           C  
ATOM   1244  CB  ILE    40      48.675  25.052  13.921  1.00 55.53           C  
ATOM   1245  CG1 ILE    40      47.965  24.654  12.623  1.00 54.13           C  
ATOM   1246  CD1 ILE    40      47.875  23.195  12.381  1.00 53.68           C  
ATOM   1247  CG2 ILE    40      47.958  24.475  15.094  1.00 55.36           C  
ATOM   1248  C   ILE    40      49.695  26.964  15.203  1.00 55.60           C  
ATOM   1249  O   ILE    40      50.895  26.924  15.042  1.00 54.08           O  
ATOM   1250  N   ARG    41      49.137  27.350  16.345  1.00 57.05           N  
ATOM   1251  CA  ARG    41      49.902  27.583  17.594  1.00 58.60           C  
ATOM   1252  CB  ARG    41      49.682  28.995  18.158  1.00 58.57           C  
ATOM   1253  CG  ARG    41      49.935  30.085  17.095  1.00 61.65           C  
ATOM   1254  CD  ARG    41      49.835  31.558  17.607  1.00 62.04           C  
ATOM   1255  NE  ARG    41      51.139  31.967  18.140  1.00 66.00           N  
ATOM   1256  CZ  ARG    41      52.079  32.689  17.509  1.00 65.44           C  
ATOM   1257  NH1 ARG    41      51.896  33.213  16.287  1.00 64.96           N  
ATOM   1258  NH2 ARG    41      53.225  32.903  18.140  1.00 64.12           N  
ATOM   1259  C   ARG    41      49.502  26.565  18.644  1.00 58.53           C  
ATOM   1260  O   ARG    41      48.354  26.119  18.710  1.00 57.81           O  
ATOM   1261  N   PHE    42      50.486  26.228  19.466  1.00 59.74           N  
ATOM   1262  CA  PHE    42      50.416  25.142  20.452  1.00 60.45           C  
ATOM   1263  CB  PHE    42      51.484  24.072  20.118  1.00 60.37           C  
ATOM   1264  CG  PHE    42      51.318  23.453  18.750  1.00 60.19           C  
ATOM   1265  CD1 PHE    42      50.522  22.328  18.572  1.00 59.24           C  
ATOM   1266  CE1 PHE    42      50.346  21.767  17.321  1.00 59.71           C  
ATOM   1267  CZ  PHE    42      50.955  22.334  16.225  1.00 60.00           C  
ATOM   1268  CE2 PHE    42      51.753  23.466  16.386  1.00 60.33           C  
ATOM   1269  CD2 PHE    42      51.922  24.022  17.642  1.00 59.82           C  
ATOM   1270  C   PHE    42      50.722  25.709  21.819  1.00 60.81           C  
ATOM   1271  O   PHE    42      51.513  26.615  21.918  1.00 61.17           O  
ATOM   1272  N   ALA    43      50.076  25.194  22.859  1.00 61.79           N  
ATOM   1273  CA  ALA    43      50.533  25.351  24.245  1.00 62.22           C  
ATOM   1274  CB  ALA    43      49.509  26.094  25.129  1.00 61.58           C  
ATOM   1275  C   ALA    43      50.758  23.928  24.748  1.00 63.17           C  
ATOM   1276  O   ALA    43      49.905  23.034  24.556  1.00 63.19           O  
ATOM   1277  N   ASP    44      51.929  23.708  25.352  1.00 64.51           N  
ATOM   1278  CA  ASP    44      52.263  22.424  25.966  1.00 65.05           C  
ATOM   1279  CB  ASP    44      51.429  22.217  27.260  1.00 65.69           C  
ATOM   1280  CG  ASP    44      51.511  23.438  28.251  1.00 68.14           C  
ATOM   1281  OD1 ASP    44      52.666  23.772  28.637  1.00 71.73           O  
ATOM   1282  OD2 ASP    44      50.454  24.041  28.650  1.00 65.35           O  
ATOM   1283  C   ASP    44      51.977  21.358  24.900  1.00 65.21           C  
ATOM   1284  O   ASP    44      51.302  20.369  25.138  1.00 65.63           O  
ATOM   1285  N   ASP    45      52.449  21.627  23.694  1.00 65.40           N  
ATOM   1286  CA  ASP    45      52.261  20.737  22.540  1.00 65.59           C  
ATOM   1287  CB  ASP    45      53.142  19.503  22.669  1.00 66.51           C  
ATOM   1288  CG  ASP    45      54.378  19.605  21.773  1.00 71.38           C  
ATOM   1289  OD1 ASP    45      54.209  19.760  20.505  1.00 73.77           O  
ATOM   1290  OD2 ASP    45      55.511  19.566  22.353  1.00 76.92           O  
ATOM   1291  C   ASP    45      50.848  20.347  22.117  1.00 64.70           C  
ATOM   1292  O   ASP    45      50.673  19.473  21.255  1.00 64.29           O  
ATOM   1293  N   ILE    46      49.848  21.020  22.664  1.00 63.93           N  
ATOM   1294  CA  ILE    46      48.496  20.839  22.182  1.00 63.43           C  
ATOM   1295  CB  ILE    46      47.525  20.595  23.334  1.00 64.04           C  
ATOM   1296  CG1 ILE    46      48.179  19.651  24.391  1.00 64.30           C  
ATOM   1297  CD1 ILE    46      47.297  19.342  25.647  1.00 63.49           C  
ATOM   1298  CG2 ILE    46      46.167  20.104  22.784  1.00 63.48           C  
ATOM   1299  C   ILE    46      48.136  22.107  21.393  1.00 62.78           C  
ATOM   1300  O   ILE    46      48.405  23.229  21.845  1.00 62.44           O  
ATOM   1301  N   PRO    47      47.580  21.933  20.184  1.00 61.67           N  
ATOM   1302  CA  PRO    47      47.195  23.086  19.385  1.00 60.96           C  
ATOM   1303  CB  PRO    47      46.713  22.483  18.055  1.00 61.01           C  
ATOM   1304  CG  PRO    47      46.628  21.050  18.240  1.00 61.37           C  
ATOM   1305  CD  PRO    47      47.323  20.654  19.501  1.00 61.75           C  
ATOM   1306  C   PRO    47      46.063  23.861  20.027  1.00 59.95           C  
ATOM   1307  O   PRO    47      45.058  23.291  20.339  1.00 59.15           O  
ATOM   1308  N   ILE    48      46.241  25.166  20.179  1.00 59.29           N  
ATOM   1309  CA  ILE    48      45.215  26.050  20.695  1.00 58.54           C  
ATOM   1310  CB  ILE    48      45.834  27.215  21.489  1.00 58.42           C  
ATOM   1311  CG1 ILE    48      46.815  26.706  22.555  1.00 58.99           C  
ATOM   1312  CD1 ILE    48      46.200  25.695  23.593  1.00 58.08           C  
ATOM   1313  CG2 ILE    48      44.766  27.983  22.197  1.00 58.78           C  
ATOM   1314  C   ILE    48      44.408  26.645  19.542  1.00 58.31           C  
ATOM   1315  O   ILE    48      43.220  26.871  19.676  1.00 58.87           O  
ATOM   1316  N   CYS    49      45.035  26.913  18.403  1.00 57.41           N  
ATOM   1317  CA  CYS    49      44.395  27.763  17.414  1.00 56.65           C  
ATOM   1318  CB  CYS    49      44.422  29.212  17.923  1.00 56.74           C  
ATOM   1319  SG  CYS    49      46.012  30.016  17.879  1.00 59.53           S  
ATOM   1320  C   CYS    49      44.972  27.692  16.008  1.00 55.55           C  
ATOM   1321  O   CYS    49      46.112  27.347  15.771  1.00 55.76           O  
ATOM   1322  N   PHE    50      44.135  28.022  15.060  1.00 55.34           N  
ATOM   1323  CA  PHE    50      44.505  28.073  13.647  1.00 54.60           C  
ATOM   1324  CB  PHE    50      43.685  27.060  12.884  1.00 54.13           C  
ATOM   1325  CG  PHE    50      43.909  27.094  11.427  1.00 54.23           C  
ATOM   1326  CD1 PHE    50      44.902  26.337  10.862  1.00 54.72           C  
ATOM   1327  CE1 PHE    50      45.121  26.346   9.521  1.00 54.50           C  
ATOM   1328  CZ  PHE    50      44.354  27.121   8.737  1.00 54.82           C  
ATOM   1329  CE2 PHE    50      43.354  27.888   9.289  1.00 54.91           C  
ATOM   1330  CD2 PHE    50      43.124  27.865  10.617  1.00 54.51           C  
ATOM   1331  C   PHE    50      44.148  29.449  13.141  1.00 53.70           C  
ATOM   1332  O   PHE    50      43.010  29.926  13.330  1.00 54.12           O  
ATOM   1333  N   GLU    51      45.096  30.083  12.491  1.00 52.40           N  
ATOM   1334  CA  GLU    51      44.928  31.447  12.048  1.00 51.48           C  
ATOM   1335  CB  GLU    51      45.873  32.296  12.912  1.00 51.98           C  
ATOM   1336  CG  GLU    51      46.167  33.708  12.443  1.00 53.18           C  
ATOM   1337  CD  GLU    51      47.103  34.446  13.376  1.00 53.76           C  
ATOM   1338  OE1 GLU    51      46.623  34.789  14.522  1.00 60.44           O  
ATOM   1339  OE2 GLU    51      48.265  34.701  12.943  1.00 52.48           O  
ATOM   1340  C   GLU    51      45.243  31.598  10.555  1.00 49.93           C  
ATOM   1341  O   GLU    51      46.285  31.182  10.099  1.00 49.47           O  
ATOM   1342  N   VAL    52      44.350  32.218   9.813  1.00 49.02           N  
ATOM   1343  CA  VAL    52      44.660  32.667   8.461  1.00 48.32           C  
ATOM   1344  CB  VAL    52      43.472  32.436   7.472  1.00 47.93           C  
ATOM   1345  CG1 VAL    52      43.903  32.727   6.051  1.00 45.34           C  
ATOM   1346  CG2 VAL    52      43.016  31.060   7.602  1.00 46.90           C  
ATOM   1347  C   VAL    52      44.949  34.163   8.515  1.00 47.65           C  
ATOM   1348  O   VAL    52      44.144  34.941   9.011  1.00 47.93           O  
ATOM   1349  N   ALA    53      46.062  34.576   7.950  1.00 46.88           N  
ATOM   1350  CA  ALA    53      46.359  35.982   7.920  1.00 46.27           C  
ATOM   1351  CB  ALA    53      47.501  36.285   8.853  1.00 45.46           C  
ATOM   1352  C   ALA    53      46.658  36.432   6.489  1.00 45.29           C  
ATOM   1353  O   ALA    53      47.380  35.772   5.750  1.00 44.22           O  
ATOM   1354  N   SER    54      46.079  37.565   6.116  1.00 44.82           N  
ATOM   1355  CA  SER    54      46.326  38.148   4.820  1.00 45.05           C  
ATOM   1356  CB  SER    54      45.056  38.124   3.966  1.00 44.62           C  
ATOM   1357  OG  SER    54      44.801  36.823   3.452  1.00 40.96           O  
ATOM   1358  C   SER    54      46.868  39.573   4.956  1.00 45.50           C  
ATOM   1359  O   SER    54      46.253  40.408   5.572  1.00 46.84           O  
ATOM   1360  N   ILE    55      48.026  39.830   4.361  1.00 45.69           N  
ATOM   1361  CA  ILE    55      48.713  41.115   4.446  1.00 45.44           C  
ATOM   1362  CB  ILE    55      50.081  40.929   5.130  1.00 45.08           C  
ATOM   1363  CG1 ILE    55      49.873  40.333   6.514  1.00 44.34           C  
ATOM   1364  CD1 ILE    55      50.869  39.335   6.890  1.00 41.72           C  
ATOM   1365  CG2 ILE    55      50.855  42.244   5.197  1.00 44.78           C  
ATOM   1366  C   ILE    55      48.934  41.617   3.005  1.00 45.44           C  
ATOM   1367  O   ILE    55      49.293  40.848   2.150  1.00 44.57           O  
ATOM   1368  N   PRO    56      48.680  42.901   2.741  1.00 45.76           N  
ATOM   1369  CA  PRO    56      48.947  43.456   1.436  1.00 45.64           C  
ATOM   1370  CB  PRO    56      48.760  44.949   1.663  1.00 45.38           C  
ATOM   1371  CG  PRO    56      47.764  45.019   2.733  1.00 45.95           C  
ATOM   1372  CD  PRO    56      48.086  43.898   3.651  1.00 46.48           C  
ATOM   1373  C   PRO    56      50.376  43.144   1.072  1.00 45.83           C  
ATOM   1374  O   PRO    56      51.246  43.367   1.911  1.00 46.46           O  
ATOM   1375  N   TYR    57      50.633  42.596  -0.121  1.00 45.25           N  
ATOM   1376  CA  TYR    57      51.982  42.139  -0.410  1.00 45.86           C  
ATOM   1377  CB  TYR    57      52.075  41.239  -1.665  1.00 45.64           C  
ATOM   1378  CG  TYR    57      53.440  40.587  -1.840  1.00 44.64           C  
ATOM   1379  CD1 TYR    57      54.035  39.961  -0.775  1.00 43.06           C  
ATOM   1380  CE1 TYR    57      55.278  39.361  -0.870  1.00 43.55           C  
ATOM   1381  CZ  TYR    57      55.953  39.361  -2.038  1.00 44.64           C  
ATOM   1382  OH  TYR    57      57.180  38.720  -1.982  1.00 46.48           O  
ATOM   1383  CE2 TYR    57      55.400  39.976  -3.168  1.00 42.99           C  
ATOM   1384  CD2 TYR    57      54.130  40.595  -3.060  1.00 43.09           C  
ATOM   1385  C   TYR    57      52.914  43.325  -0.549  1.00 46.06           C  
ATOM   1386  O   TYR    57      54.090  43.198  -0.314  1.00 45.53           O  
ATOM   1387  N   SER    58      52.403  44.481  -0.940  1.00 47.17           N  
ATOM   1388  CA  SER    58      53.289  45.604  -1.162  1.00 48.11           C  
ATOM   1389  CB  SER    58      52.546  46.736  -1.780  1.00 47.99           C  
ATOM   1390  OG  SER    58      51.825  47.338  -0.740  1.00 50.25           O  
ATOM   1391  C   SER    58      53.900  46.119   0.131  1.00 49.09           C  
ATOM   1392  O   SER    58      54.949  46.691   0.082  1.00 49.71           O  
ATOM   1393  N   LEU    59      53.270  45.934   1.286  1.00 49.94           N  
ATOM   1394  CA  LEU    59      53.893  46.390   2.543  1.00 50.63           C  
ATOM   1395  CB  LEU    59      52.878  46.506   3.702  1.00 50.50           C  
ATOM   1396  CG  LEU    59      51.624  47.344   3.445  1.00 50.78           C  
ATOM   1397  CD1 LEU    59      50.496  46.975   4.439  1.00 48.14           C  
ATOM   1398  CD2 LEU    59      51.974  48.833   3.445  1.00 50.51           C  
ATOM   1399  C   LEU    59      54.969  45.464   3.046  1.00 51.77           C  
ATOM   1400  O   LEU    59      55.605  45.756   4.081  1.00 53.56           O  
ATOM   1401  N   VAL    60      55.161  44.331   2.387  1.00 52.04           N  
ATOM   1402  CA  VAL    60      55.871  43.229   3.035  1.00 52.07           C  
ATOM   1403  CB  VAL    60      54.772  42.272   3.638  1.00 52.60           C  
ATOM   1404  CG1 VAL    60      54.716  40.941   2.924  1.00 52.85           C  
ATOM   1405  CG2 VAL    60      54.911  42.154   5.171  1.00 51.04           C  
ATOM   1406  C   VAL    60      56.917  42.553   2.137  1.00 52.27           C  
ATOM   1407  O   VAL    60      57.747  41.784   2.635  1.00 52.19           O  
ATOM   1408  N   SER    61      56.880  42.892   0.835  1.00 52.26           N  
ATOM   1409  CA  SER    61      57.800  42.433  -0.175  1.00 52.56           C  
ATOM   1410  CB  SER    61      57.927  43.452  -1.302  1.00 52.22           C  
ATOM   1411  OG  SER    61      56.762  43.568  -2.023  1.00 50.76           O  
ATOM   1412  C   SER    61      59.193  42.334   0.339  1.00 54.01           C  
ATOM   1413  O   SER    61      59.937  41.452  -0.087  1.00 54.95           O  
ATOM   1414  N   GLN    62      59.589  43.309   1.154  1.00 54.80           N  
ATOM   1415  CA  GLN    62      60.990  43.507   1.448  1.00 55.39           C  
ATOM   1416  CB  GLN    62      61.327  44.993   1.483  1.00 55.61           C  
ATOM   1417  CG  GLN    62      60.892  45.798   0.261  1.00 57.32           C  
ATOM   1418  CD  GLN    62      61.375  45.233  -1.113  1.00 61.44           C  
ATOM   1419  OE1 GLN    62      62.586  44.979  -1.345  1.00 61.49           O  
ATOM   1420  NE2 GLN    62      60.415  45.074  -2.042  1.00 61.82           N  
ATOM   1421  C   GLN    62      61.378  42.844   2.746  1.00 55.11           C  
ATOM   1422  O   GLN    62      62.528  42.769   3.067  1.00 54.97           O  
ATOM   1423  N   TYR    63      60.432  42.331   3.490  1.00 55.62           N  
ATOM   1424  CA  TYR    63      60.788  41.624   4.715  1.00 56.61           C  
ATOM   1425  CB  TYR    63      59.704  41.790   5.806  1.00 57.30           C  
ATOM   1426  CG  TYR    63      59.279  43.248   6.011  1.00 58.09           C  
ATOM   1427  CD1 TYR    63      58.064  43.574   6.572  1.00 58.04           C  
ATOM   1428  CE1 TYR    63      57.699  44.901   6.742  1.00 59.17           C  
ATOM   1429  CZ  TYR    63      58.554  45.907   6.331  1.00 58.62           C  
ATOM   1430  OH  TYR    63      58.228  47.233   6.437  1.00 59.12           O  
ATOM   1431  CE2 TYR    63      59.743  45.605   5.784  1.00 58.72           C  
ATOM   1432  CD2 TYR    63      60.106  44.298   5.624  1.00 59.54           C  
ATOM   1433  C   TYR    63      61.008  40.192   4.340  1.00 56.32           C  
ATOM   1434  O   TYR    63      60.675  39.808   3.253  1.00 57.28           O  
ATOM   1435  N   GLY    64      61.609  39.421   5.221  1.00 56.27           N  
ATOM   1436  CA  GLY    64      61.839  38.027   4.986  1.00 56.20           C  
ATOM   1437  C   GLY    64      60.908  37.261   5.882  1.00 56.70           C  
ATOM   1438  O   GLY    64      60.444  37.767   6.892  1.00 56.87           O  
ATOM   1439  N   LYS    65      60.680  36.015   5.500  1.00 57.08           N  
ATOM   1440  CA  LYS    65      59.663  35.138   6.061  1.00 57.01           C  
ATOM   1441  CB  LYS    65      59.891  33.722   5.532  1.00 56.96           C  
ATOM   1442  CG  LYS    65      58.959  32.645   6.047  1.00 57.71           C  
ATOM   1443  CD  LYS    65      58.839  31.492   5.053  1.00 57.88           C  
ATOM   1444  CE  LYS    65      57.800  30.458   5.485  1.00 59.30           C  
ATOM   1445  NZ  LYS    65      57.469  29.549   4.343  1.00 60.81           N  
ATOM   1446  C   LYS    65      59.632  35.111   7.583  1.00 57.12           C  
ATOM   1447  O   LYS    65      58.538  35.116   8.186  1.00 56.36           O  
ATOM   1448  N   SER    66      60.822  35.052   8.184  1.00 56.97           N  
ATOM   1449  CA  SER    66      60.971  34.940   9.647  1.00 56.91           C  
ATOM   1450  CB  SER    66      62.448  34.856   9.990  1.00 56.99           C  
ATOM   1451  OG  SER    66      63.180  35.553   8.973  1.00 59.35           O  
ATOM   1452  C   SER    66      60.403  36.153  10.330  1.00 56.41           C  
ATOM   1453  O   SER    66      59.679  36.019  11.317  1.00 56.18           O  
ATOM   1454  N   GLU    67      60.774  37.333   9.818  1.00 56.50           N  
ATOM   1455  CA  GLU    67      60.273  38.615  10.305  1.00 56.88           C  
ATOM   1456  CB  GLU    67      60.755  39.796   9.461  1.00 56.55           C  
ATOM   1457  CG  GLU    67      62.205  40.138   9.614  1.00 57.12           C  
ATOM   1458  CD  GLU    67      62.722  41.072   8.519  1.00 57.60           C  
ATOM   1459  OE1 GLU    67      62.497  40.779   7.334  1.00 58.04           O  
ATOM   1460  OE2 GLU    67      63.384  42.091   8.836  1.00 59.58           O  
ATOM   1461  C   GLU    67      58.781  38.567  10.225  1.00 57.09           C  
ATOM   1462  O   GLU    67      58.098  38.769  11.217  1.00 57.13           O  
ATOM   1463  N   ILE    68      58.269  38.266   9.037  1.00 57.54           N  
ATOM   1464  CA  ILE    68      56.814  38.234   8.856  1.00 58.10           C  
ATOM   1465  CB  ILE    68      56.393  37.953   7.410  1.00 57.62           C  
ATOM   1466  CG1 ILE    68      56.836  39.140   6.535  1.00 57.78           C  
ATOM   1467  CD1 ILE    68      56.783  38.930   5.025  1.00 57.61           C  
ATOM   1468  CG2 ILE    68      54.889  37.726   7.363  1.00 56.58           C  
ATOM   1469  C   ILE    68      56.138  37.257   9.778  1.00 58.31           C  
ATOM   1470  O   ILE    68      55.095  37.568  10.307  1.00 58.35           O  
ATOM   1471  N   THR    69      56.735  36.093   9.983  1.00 59.31           N  
ATOM   1472  CA  THR    69      56.082  35.034  10.738  1.00 60.56           C  
ATOM   1473  CB  THR    69      56.573  33.624  10.343  1.00 60.50           C  
ATOM   1474  OG1 THR    69      57.922  33.690   9.870  1.00 62.21           O  
ATOM   1475  CG2 THR    69      55.714  33.060   9.218  1.00 60.20           C  
ATOM   1476  C   THR    69      56.181  35.232  12.230  1.00 61.36           C  
ATOM   1477  O   THR    69      55.188  35.041  12.915  1.00 62.44           O  
ATOM   1478  N   ASN    70      57.330  35.675  12.734  1.00 62.34           N  
ATOM   1479  CA  ASN    70      57.538  35.792  14.196  1.00 62.99           C  
ATOM   1480  CB  ASN    70      58.825  35.062  14.641  1.00 63.60           C  
ATOM   1481  CG  ASN    70      59.089  33.775  13.853  1.00 65.59           C  
ATOM   1482  OD1 ASN    70      59.995  33.727  13.000  1.00 67.25           O  
ATOM   1483  ND2 ASN    70      58.278  32.741  14.108  1.00 66.68           N  
ATOM   1484  C   ASN    70      57.610  37.229  14.759  1.00 63.58           C  
ATOM   1485  O   ASN    70      57.522  37.413  15.964  1.00 64.54           O  
ATOM   1486  N   SER    71      57.793  38.243  13.926  1.00 63.29           N  
ATOM   1487  CA  SER    71      58.109  39.576  14.444  1.00 62.82           C  
ATOM   1488  CB  SER    71      59.602  39.841  14.229  1.00 63.27           C  
ATOM   1489  OG  SER    71      60.374  38.706  14.576  1.00 64.10           O  
ATOM   1490  C   SER    71      57.308  40.621  13.703  1.00 62.07           C  
ATOM   1491  O   SER    71      57.796  41.724  13.403  1.00 61.87           O  
ATOM   1492  N   PHE    72      56.075  40.266  13.375  1.00 60.95           N  
ATOM   1493  CA  PHE    72      55.352  41.039  12.380  1.00 60.62           C  
ATOM   1494  CB  PHE    72      54.002  40.394  12.068  1.00 59.71           C  
ATOM   1495  CG  PHE    72      53.226  41.113  11.017  1.00 59.52           C  
ATOM   1496  CD1 PHE    72      53.869  41.651   9.898  1.00 57.25           C  
ATOM   1497  CE1 PHE    72      53.161  42.310   8.924  1.00 56.85           C  
ATOM   1498  CZ  PHE    72      51.795  42.433   9.043  1.00 57.63           C  
ATOM   1499  CE2 PHE    72      51.135  41.900  10.152  1.00 58.57           C  
ATOM   1500  CD2 PHE    72      51.854  41.242  11.131  1.00 58.26           C  
ATOM   1501  C   PHE    72      55.169  42.477  12.834  1.00 60.35           C  
ATOM   1502  O   PHE    72      55.526  43.423  12.124  1.00 60.09           O  
ATOM   1503  N   TYR    73      54.650  42.627  14.043  1.00 60.53           N  
ATOM   1504  CA  TYR    73      54.369  43.945  14.559  1.00 60.68           C  
ATOM   1505  CB  TYR    73      53.544  43.817  15.820  1.00 60.60           C  
ATOM   1506  CG  TYR    73      52.115  43.401  15.588  1.00 60.57           C  
ATOM   1507  CD1 TYR    73      51.488  43.600  14.351  1.00 60.33           C  
ATOM   1508  CE1 TYR    73      50.146  43.243  14.133  1.00 59.59           C  
ATOM   1509  CZ  TYR    73      49.411  42.686  15.149  1.00 61.24           C  
ATOM   1510  OH  TYR    73      48.086  42.340  14.905  1.00 60.98           O  
ATOM   1511  CE2 TYR    73      50.009  42.473  16.414  1.00 61.73           C  
ATOM   1512  CD2 TYR    73      51.359  42.840  16.622  1.00 61.38           C  
ATOM   1513  C   TYR    73      55.654  44.744  14.766  1.00 60.62           C  
ATOM   1514  O   TYR    73      55.789  45.842  14.200  1.00 59.42           O  
ATOM   1515  N   LYS    74      56.582  44.167  15.544  1.00 61.09           N  
ATOM   1516  CA  LYS    74      57.967  44.672  15.664  1.00 61.36           C  
ATOM   1517  CB  LYS    74      58.948  43.599  16.243  1.00 61.82           C  
ATOM   1518  CG  LYS    74      58.562  42.915  17.610  1.00 64.03           C  
ATOM   1519  CD  LYS    74      58.799  43.809  18.865  1.00 65.00           C  
ATOM   1520  CE  LYS    74      57.616  43.822  19.899  1.00 64.60           C  
ATOM   1521  NZ  LYS    74      57.615  42.683  20.891  1.00 64.65           N  
ATOM   1522  C   LYS    74      58.521  45.115  14.310  1.00 61.44           C  
ATOM   1523  O   LYS    74      58.907  46.270  14.108  1.00 61.82           O  
ATOM   1524  N   THR    75      58.576  44.187  13.370  1.00 61.19           N  
ATOM   1525  CA  THR    75      59.240  44.460  12.111  1.00 61.24           C  
ATOM   1526  CB  THR    75      59.231  43.219  11.204  1.00 61.50           C  
ATOM   1527  OG1 THR    75      59.816  42.122  11.934  1.00 60.59           O  
ATOM   1528  CG2 THR    75      59.983  43.472   9.865  1.00 59.89           C  
ATOM   1529  C   THR    75      58.579  45.602  11.415  1.00 61.11           C  
ATOM   1530  O   THR    75      59.240  46.425  10.828  1.00 61.07           O  
ATOM   1531  N   LEU    76      57.262  45.647  11.501  1.00 61.67           N  
ATOM   1532  CA  LEU    76      56.463  46.619  10.753  1.00 62.50           C  
ATOM   1533  CB  LEU    76      54.988  46.319  10.992  1.00 62.04           C  
ATOM   1534  CG  LEU    76      53.996  46.464   9.848  1.00 62.11           C  
ATOM   1535  CD1 LEU    76      54.586  46.209   8.487  1.00 60.53           C  
ATOM   1536  CD2 LEU    76      52.833  45.533  10.124  1.00 62.29           C  
ATOM   1537  C   LEU    76      56.789  48.044  11.183  1.00 63.29           C  
ATOM   1538  O   LEU    76      57.062  48.928  10.352  1.00 63.03           O  
ATOM   1539  N   GLU    77      56.779  48.231  12.504  1.00 64.51           N  
ATOM   1540  CA  GLU    77      57.104  49.504  13.143  1.00 65.40           C  
ATOM   1541  CB  GLU    77      56.608  49.528  14.594  1.00 66.12           C  
ATOM   1542  CG  GLU    77      55.290  50.300  14.752  1.00 67.50           C  
ATOM   1543  CD  GLU    77      54.557  49.980  16.045  1.00 68.10           C  
ATOM   1544  OE1 GLU    77      54.968  49.028  16.755  1.00 72.45           O  
ATOM   1545  OE2 GLU    77      53.547  50.668  16.341  1.00 71.93           O  
ATOM   1546  C   GLU    77      58.587  49.836  13.098  1.00 65.52           C  
ATOM   1547  O   GLU    77      58.932  50.947  12.739  1.00 66.33           O  
ATOM   1548  N   ALA    78      59.474  48.895  13.422  1.00 65.34           N  
ATOM   1549  CA  ALA    78      60.910  49.135  13.169  1.00 65.44           C  
ATOM   1550  CB  ALA    78      61.771  47.904  13.524  1.00 64.89           C  
ATOM   1551  C   ALA    78      61.223  49.604  11.729  1.00 65.37           C  
ATOM   1552  O   ALA    78      62.213  50.280  11.528  1.00 66.10           O  
ATOM   1553  N   LYS    79      60.404  49.262  10.737  1.00 65.47           N  
ATOM   1554  CA  LYS    79      60.795  49.490   9.345  1.00 65.81           C  
ATOM   1555  CB  LYS    79      60.943  48.167   8.588  1.00 65.64           C  
ATOM   1556  CG  LYS    79      61.991  47.223   9.179  1.00 66.33           C  
ATOM   1557  CD  LYS    79      62.897  46.592   8.096  1.00 65.98           C  
ATOM   1558  CE  LYS    79      63.660  45.370   8.622  1.00 65.01           C  
ATOM   1559  NZ  LYS    79      64.861  45.060   7.802  1.00 65.44           N  
ATOM   1560  C   LYS    79      59.891  50.401   8.538  1.00 66.08           C  
ATOM   1561  O   LYS    79      60.391  51.292   7.858  1.00 66.12           O  
ATOM   1562  N   SER    80      58.574  50.182   8.589  1.00 66.35           N  
ATOM   1563  CA  SER    80      57.687  50.703   7.521  1.00 66.13           C  
ATOM   1564  CB  SER    80      56.305  50.075   7.622  1.00 65.90           C  
ATOM   1565  OG  SER    80      55.872  50.120   8.952  1.00 64.81           O  
ATOM   1566  C   SER    80      57.564  52.221   7.516  1.00 66.30           C  
ATOM   1567  O   SER    80      57.103  52.811   6.510  1.00 65.64           O  
ATOM   1568  N   GLY    81      58.002  52.835   8.629  1.00 66.65           N  
ATOM   1569  CA  GLY    81      57.761  54.241   8.894  1.00 66.81           C  
ATOM   1570  C   GLY    81      56.253  54.415   8.915  1.00 67.35           C  
ATOM   1571  O   GLY    81      55.673  55.038   8.024  1.00 68.26           O  
ATOM   1572  N   HIS    82      55.617  53.773   9.883  1.00 67.09           N  
ATOM   1573  CA  HIS    82      54.189  53.900  10.133  1.00 66.75           C  
ATOM   1574  CB  HIS    82      53.341  53.027   9.220  1.00 66.86           C  
ATOM   1575  CG  HIS    82      53.173  53.542   7.831  1.00 67.50           C  
ATOM   1576  ND1 HIS    82      53.553  52.811   6.722  1.00 68.26           N  
ATOM   1577  CE1 HIS    82      53.272  53.498   5.629  1.00 68.32           C  
ATOM   1578  NE2 HIS    82      52.707  54.638   5.990  1.00 68.21           N  
ATOM   1579  CD2 HIS    82      52.630  54.688   7.362  1.00 67.56           C  
ATOM   1580  C   HIS    82      53.994  53.372  11.535  1.00 66.25           C  
ATOM   1581  O   HIS    82      54.817  52.606  12.055  1.00 65.10           O  
ATOM   1582  N   LYS    83      52.884  53.765  12.132  1.00 66.31           N  
ATOM   1583  CA  LYS    83      52.539  53.270  13.446  1.00 66.73           C  
ATOM   1584  CB  LYS    83      52.354  54.433  14.433  1.00 67.46           C  
ATOM   1585  CG  LYS    83      53.643  55.208  14.738  1.00 69.09           C  
ATOM   1586  CD  LYS    83      54.688  54.330  15.476  1.00 71.26           C  
ATOM   1587  CE  LYS    83      55.970  55.086  15.811  1.00 71.11           C  
ATOM   1588  NZ  LYS    83      56.192  54.969  17.289  1.00 73.94           N  
ATOM   1589  C   LYS    83      51.284  52.425  13.369  1.00 65.95           C  
ATOM   1590  O   LYS    83      50.337  52.740  12.641  1.00 65.91           O  
ATOM   1591  N   ILE    84      51.309  51.333  14.108  1.00 65.12           N  
ATOM   1592  CA  ILE    84      50.148  50.486  14.251  1.00 65.44           C  
ATOM   1593  CB  ILE    84      50.515  49.190  15.062  1.00 65.60           C  
ATOM   1594  CG1 ILE    84      51.538  48.359  14.250  1.00 64.73           C  
ATOM   1595  CD1 ILE    84      51.959  47.057  14.905  1.00 64.78           C  
ATOM   1596  CG2 ILE    84      49.236  48.398  15.428  1.00 64.02           C  
ATOM   1597  C   ILE    84      48.996  51.270  14.927  1.00 65.59           C  
ATOM   1598  O   ILE    84      49.115  51.653  16.082  1.00 65.54           O  
ATOM   1599  N   GLY    85      47.904  51.517  14.197  1.00 65.25           N  
ATOM   1600  CA  GLY    85      46.768  52.288  14.728  1.00 64.93           C  
ATOM   1601  C   GLY    85      45.663  51.440  15.352  1.00 64.53           C  
ATOM   1602  O   GLY    85      45.914  50.558  16.166  1.00 64.19           O  
ATOM   1603  N   HIS    86      44.428  51.695  14.949  1.00 64.41           N  
ATOM   1604  CA  HIS    86      43.296  50.974  15.518  1.00 64.33           C  
ATOM   1605  CB  HIS    86      41.995  51.706  15.174  1.00 65.12           C  
ATOM   1606  CG  HIS    86      41.898  53.057  15.823  1.00 68.01           C  
ATOM   1607  ND1 HIS    86      41.389  54.168  15.174  1.00 70.34           N  
ATOM   1608  CE1 HIS    86      41.466  55.217  15.979  1.00 70.57           C  
ATOM   1609  NE2 HIS    86      42.015  54.830  17.122  1.00 69.63           N  
ATOM   1610  CD2 HIS    86      42.294  53.485  17.052  1.00 69.08           C  
ATOM   1611  C   HIS    86      43.220  49.534  15.037  1.00 63.87           C  
ATOM   1612  O   HIS    86      43.816  49.168  14.021  1.00 64.68           O  
ATOM   1613  N   SER    87      42.481  48.707  15.761  1.00 62.43           N  
ATOM   1614  CA  SER    87      42.098  47.398  15.238  1.00 60.99           C  
ATOM   1615  CB  SER    87      43.023  46.299  15.753  1.00 60.91           C  
ATOM   1616  OG  SER    87      42.711  46.043  17.107  1.00 62.22           O  
ATOM   1617  C   SER    87      40.652  47.132  15.634  1.00 59.77           C  
ATOM   1618  O   SER    87      40.094  47.804  16.499  1.00 59.93           O  
ATOM   1619  N   ASN    88      40.015  46.197  14.950  1.00 58.14           N  
ATOM   1620  CA  ASN    88      38.681  45.797  15.334  1.00 56.49           C  
ATOM   1621  CB  ASN    88      37.644  46.733  14.701  1.00 56.62           C  
ATOM   1622  CG  ASN    88      37.519  46.561  13.233  1.00 59.15           C  
ATOM   1623  OD1 ASN    88      37.089  45.492  12.758  1.00 63.48           O  
ATOM   1624  ND2 ASN    88      37.850  47.615  12.475  1.00 60.78           N  
ATOM   1625  C   ASN    88      38.464  44.284  15.144  1.00 54.58           C  
ATOM   1626  O   ASN    88      39.161  43.619  14.395  1.00 54.18           O  
ATOM   1627  N   GLN    89      37.567  43.731  15.925  1.00 52.67           N  
ATOM   1628  CA  GLN    89      37.459  42.302  16.090  1.00 51.84           C  
ATOM   1629  CB  GLN    89      38.092  41.909  17.414  1.00 51.40           C  
ATOM   1630  CG  GLN    89      39.559  41.784  17.376  1.00 51.50           C  
ATOM   1631  CD  GLN    89      40.148  41.727  18.756  1.00 52.26           C  
ATOM   1632  OE1 GLN    89      39.634  42.399  19.668  1.00 55.51           O  
ATOM   1633  NE2 GLN    89      41.232  40.944  18.932  1.00 44.23           N  
ATOM   1634  C   GLN    89      36.000  41.920  16.128  1.00 50.38           C  
ATOM   1635  O   GLN    89      35.183  42.644  16.653  1.00 49.53           O  
ATOM   1636  N   THR    90      35.682  40.768  15.583  1.00 50.07           N  
ATOM   1637  CA  THR    90      34.317  40.271  15.572  1.00 50.31           C  
ATOM   1638  CB  THR    90      33.694  40.352  14.174  1.00 50.38           C  
ATOM   1639  OG1 THR    90      33.857  41.686  13.683  1.00 51.12           O  
ATOM   1640  CG2 THR    90      32.185  40.012  14.187  1.00 49.21           C  
ATOM   1641  C   THR    90      34.407  38.853  16.044  1.00 50.10           C  
ATOM   1642  O   THR    90      35.054  38.020  15.407  1.00 51.56           O  
ATOM   1643  N   ILE    91      33.800  38.599  17.194  1.00 49.46           N  
ATOM   1644  CA  ILE    91      33.896  37.323  17.867  1.00 49.05           C  
ATOM   1645  CB  ILE    91      34.143  37.533  19.342  1.00 49.09           C  
ATOM   1646  CG1 ILE    91      35.359  38.449  19.522  1.00 48.77           C  
ATOM   1647  CD1 ILE    91      35.589  38.748  20.945  1.00 49.36           C  
ATOM   1648  CG2 ILE    91      34.354  36.197  20.046  1.00 48.53           C  
ATOM   1649  C   ILE    91      32.621  36.535  17.691  1.00 48.72           C  
ATOM   1650  O   ILE    91      31.554  37.040  17.947  1.00 48.31           O  
ATOM   1651  N   SER    92      32.734  35.303  17.212  1.00 48.65           N  
ATOM   1652  CA  SER    92      31.569  34.441  17.071  1.00 48.92           C  
ATOM   1653  CB  SER    92      31.054  34.481  15.636  1.00 48.51           C  
ATOM   1654  OG  SER    92      32.098  34.168  14.726  1.00 48.47           O  
ATOM   1655  C   SER    92      31.965  33.038  17.430  1.00 48.69           C  
ATOM   1656  O   SER    92      33.117  32.765  17.684  1.00 48.83           O  
ATOM   1657  N   ALA    93      30.987  32.161  17.443  1.00 49.88           N  
ATOM   1658  CA  ALA    93      31.148  30.772  17.782  1.00 50.89           C  
ATOM   1659  CB  ALA    93      30.271  30.454  18.926  1.00 50.66           C  
ATOM   1660  C   ALA    93      30.746  29.924  16.570  1.00 51.92           C  
ATOM   1661  O   ALA    93      29.742  30.171  15.960  1.00 51.99           O  
ATOM   1662  N   VAL    94      31.539  28.918  16.238  1.00 53.30           N  
ATOM   1663  CA  VAL    94      31.309  28.105  15.060  1.00 54.08           C  
ATOM   1664  CB  VAL    94      32.133  28.663  13.895  1.00 54.37           C  
ATOM   1665  CG1 VAL    94      32.156  27.709  12.760  1.00 55.01           C  
ATOM   1666  CG2 VAL    94      31.514  29.974  13.435  1.00 54.26           C  
ATOM   1667  C   VAL    94      31.695  26.653  15.325  1.00 54.83           C  
ATOM   1668  O   VAL    94      32.545  26.370  16.132  1.00 54.71           O  
ATOM   1669  N   GLN    95      31.062  25.725  14.634  1.00 56.09           N  
ATOM   1670  CA  GLN    95      31.480  24.315  14.711  1.00 56.95           C  
ATOM   1671  CB  GLN    95      30.389  23.439  14.118  1.00 57.33           C  
ATOM   1672  CG  GLN    95      29.005  23.814  14.561  1.00 58.13           C  
ATOM   1673  CD  GLN    95      28.123  22.635  14.519  1.00 60.37           C  
ATOM   1674  OE1 GLN    95      27.422  22.426  13.548  1.00 61.67           O  
ATOM   1675  NE2 GLN    95      28.208  21.793  15.543  1.00 62.95           N  
ATOM   1676  C   GLN    95      32.760  24.047  13.932  1.00 57.26           C  
ATOM   1677  O   GLN    95      32.947  24.610  12.870  1.00 57.40           O  
ATOM   1678  N   ALA    96      33.618  23.165  14.424  1.00 58.08           N  
ATOM   1679  CA  ALA    96      34.857  22.818  13.699  1.00 58.74           C  
ATOM   1680  CB  ALA    96      35.737  21.976  14.556  1.00 58.50           C  
ATOM   1681  C   ALA    96      34.548  22.075  12.420  1.00 59.31           C  
ATOM   1682  O   ALA    96      33.764  21.131  12.431  1.00 59.39           O  
ATOM   1683  N   SER    97      35.133  22.525  11.312  1.00 60.42           N  
ATOM   1684  CA  SER    97      35.107  21.767  10.043  1.00 61.00           C  
ATOM   1685  CB  SER    97      35.525  22.640   8.873  1.00 60.27           C  
ATOM   1686  OG  SER    97      36.930  22.787   8.865  1.00 60.13           O  
ATOM   1687  C   SER    97      36.038  20.540  10.141  1.00 62.02           C  
ATOM   1688  O   SER    97      36.840  20.395  11.092  1.00 62.18           O  
ATOM   1689  N   GLU    98      35.921  19.644   9.168  1.00 63.43           N  
ATOM   1690  CA  GLU    98      36.724  18.429   9.189  1.00 63.96           C  
ATOM   1691  CB  GLU    98      36.449  17.617   7.939  1.00 64.18           C  
ATOM   1692  CG  GLU    98      37.235  16.294   7.807  1.00 65.28           C  
ATOM   1693  CD  GLU    98      37.186  15.778   6.340  1.00 67.67           C  
ATOM   1694  OE1 GLU    98      36.177  16.062   5.603  1.00 70.33           O  
ATOM   1695  OE2 GLU    98      38.170  15.105   5.923  1.00 73.63           O  
ATOM   1696  C   GLU    98      38.171  18.852   9.219  1.00 63.92           C  
ATOM   1697  O   GLU    98      38.965  18.389  10.034  1.00 64.26           O  
ATOM   1698  N   GLN    99      38.469  19.778   8.317  1.00 64.07           N  
ATOM   1699  CA  GLN    99      39.791  20.361   8.141  1.00 63.67           C  
ATOM   1700  CB  GLN    99      39.680  21.417   7.026  1.00 63.80           C  
ATOM   1701  CG  GLN    99      40.968  22.048   6.632  1.00 64.58           C  
ATOM   1702  CD  GLN    99      42.010  21.014   6.225  1.00 68.17           C  
ATOM   1703  OE1 GLN    99      42.632  20.319   7.085  1.00 67.56           O  
ATOM   1704  NE2 GLN    99      42.223  20.903   4.893  1.00 68.03           N  
ATOM   1705  C   GLN    99      40.368  20.979   9.425  1.00 63.32           C  
ATOM   1706  O   GLN    99      41.448  20.599   9.902  1.00 63.41           O  
ATOM   1707  N   ILE   100      39.632  21.926   9.995  1.00 62.96           N  
ATOM   1708  CA  ILE   100      40.076  22.574  11.229  1.00 62.69           C  
ATOM   1709  CB  ILE   100      39.236  23.842  11.556  1.00 62.67           C  
ATOM   1710  CG1 ILE   100      39.880  25.041  10.847  1.00 61.31           C  
ATOM   1711  CD1 ILE   100      38.927  26.034  10.434  1.00 59.86           C  
ATOM   1712  CG2 ILE   100      39.161  24.080  13.080  1.00 61.97           C  
ATOM   1713  C   ILE   100      40.116  21.592  12.380  1.00 62.13           C  
ATOM   1714  O   ILE   100      40.942  21.721  13.267  1.00 62.00           O  
ATOM   1715  N   ALA   101      39.253  20.589  12.340  1.00 61.83           N  
ATOM   1716  CA  ALA   101      39.336  19.520  13.310  1.00 62.17           C  
ATOM   1717  CB  ALA   101      38.199  18.570  13.123  1.00 61.70           C  
ATOM   1718  C   ALA   101      40.694  18.795  13.197  1.00 62.19           C  
ATOM   1719  O   ALA   101      41.392  18.630  14.221  1.00 60.67           O  
ATOM   1720  N   GLU   102      41.073  18.393  11.969  1.00 62.42           N  
ATOM   1721  CA  GLU   102      42.357  17.703  11.767  1.00 63.31           C  
ATOM   1722  CB  GLU   102      42.724  17.461  10.316  1.00 63.78           C  
ATOM   1723  CG  GLU   102      41.729  16.671   9.432  1.00 66.53           C  
ATOM   1724  CD  GLU   102      42.277  16.510   7.986  1.00 66.96           C  
ATOM   1725  OE1 GLU   102      43.521  16.232   7.884  1.00 71.08           O  
ATOM   1726  OE2 GLU   102      41.490  16.674   6.990  1.00 68.24           O  
ATOM   1727  C   GLU   102      43.454  18.554  12.320  1.00 62.80           C  
ATOM   1728  O   GLU   102      44.252  18.076  13.091  1.00 62.23           O  
ATOM   1729  N   TYR   103      43.485  19.826  11.921  1.00 62.90           N  
ATOM   1730  CA  TYR   103      44.544  20.755  12.375  1.00 62.73           C  
ATOM   1731  CB  TYR   103      44.362  22.135  11.760  1.00 62.49           C  
ATOM   1732  CG  TYR   103      44.619  22.266  10.289  1.00 62.53           C  
ATOM   1733  CD1 TYR   103      45.700  21.623   9.675  1.00 63.11           C  
ATOM   1734  CE1 TYR   103      45.945  21.768   8.313  1.00 61.14           C  
ATOM   1735  CZ  TYR   103      45.124  22.584   7.588  1.00 62.08           C  
ATOM   1736  OH  TYR   103      45.346  22.759   6.274  1.00 63.69           O  
ATOM   1737  CE2 TYR   103      44.058  23.256   8.167  1.00 62.30           C  
ATOM   1738  CD2 TYR   103      43.824  23.110   9.511  1.00 61.89           C  
ATOM   1739  C   TYR   103      44.587  20.984  13.883  1.00 62.42           C  
ATOM   1740  O   TYR   103      45.650  21.129  14.473  1.00 62.16           O  
ATOM   1741  N   LEU   104      43.430  21.100  14.504  1.00 62.63           N  
ATOM   1742  CA  LEU   104      43.413  21.403  15.924  1.00 62.76           C  
ATOM   1743  CB  LEU   104      42.288  22.384  16.223  1.00 62.29           C  
ATOM   1744  CG  LEU   104      42.546  23.812  15.738  1.00 60.70           C  
ATOM   1745  CD1 LEU   104      41.356  24.668  16.016  1.00 59.52           C  
ATOM   1746  CD2 LEU   104      43.722  24.405  16.452  1.00 61.29           C  
ATOM   1747  C   LEU   104      43.326  20.136  16.767  1.00 62.85           C  
ATOM   1748  O   LEU   104      43.361  20.191  17.973  1.00 62.42           O  
ATOM   1749  N   GLU   105      43.264  18.979  16.121  1.00 63.87           N  
ATOM   1750  CA  GLU   105      43.254  17.711  16.846  1.00 64.37           C  
ATOM   1751  CB  GLU   105      44.527  17.535  17.677  1.00 64.45           C  
ATOM   1752  CG  GLU   105      45.745  17.965  16.936  1.00 64.99           C  
ATOM   1753  CD  GLU   105      46.998  17.308  17.407  1.00 65.13           C  
ATOM   1754  OE1 GLU   105      47.370  17.383  18.595  1.00 68.92           O  
ATOM   1755  OE2 GLU   105      47.643  16.722  16.550  1.00 67.31           O  
ATOM   1756  C   GLU   105      42.054  17.693  17.757  1.00 64.54           C  
ATOM   1757  O   GLU   105      42.208  17.565  18.965  1.00 63.71           O  
ATOM   1758  N   ILE   106      40.878  17.868  17.149  1.00 64.94           N  
ATOM   1759  CA  ILE   106      39.591  17.780  17.825  1.00 65.25           C  
ATOM   1760  CB  ILE   106      39.102  19.168  18.315  1.00 65.36           C  
ATOM   1761  CG1 ILE   106      38.867  20.115  17.123  1.00 65.59           C  
ATOM   1762  CD1 ILE   106      38.648  21.547  17.524  1.00 64.73           C  
ATOM   1763  CG2 ILE   106      40.110  19.756  19.320  1.00 63.53           C  
ATOM   1764  C   ILE   106      38.675  17.175  16.783  1.00 65.80           C  
ATOM   1765  O   ILE   106      39.173  16.785  15.717  1.00 65.53           O  
ATOM   1766  N   LYS   107      37.363  17.116  17.065  1.00 66.52           N  
ATOM   1767  CA  LYS   107      36.376  16.437  16.178  1.00 66.94           C  
ATOM   1768  CB  LYS   107      35.423  15.584  17.038  1.00 67.40           C  
ATOM   1769  CG  LYS   107      36.134  14.699  18.116  1.00 69.02           C  
ATOM   1770  CD  LYS   107      35.427  13.293  18.357  1.00 69.15           C  
ATOM   1771  CE  LYS   107      36.386  12.207  18.985  1.00 69.46           C  
ATOM   1772  NZ  LYS   107      36.493  12.271  20.481  1.00 70.41           N  
ATOM   1773  C   LYS   107      35.528  17.406  15.352  1.00 66.62           C  
ATOM   1774  O   LYS   107      35.182  18.459  15.878  1.00 66.80           O  
ATOM   1775  N   ARG   108      35.166  17.049  14.101  1.00 66.31           N  
ATOM   1776  CA  ARG   108      34.150  17.805  13.317  1.00 66.14           C  
ATOM   1777  CB  ARG   108      33.649  17.064  11.990  1.00 66.38           C  
ATOM   1778  CG  ARG   108      32.615  17.840  10.965  1.00 67.02           C  
ATOM   1779  CD  ARG   108      32.940  17.842   9.325  1.00 68.03           C  
ATOM   1780  NE  ARG   108      32.397  19.042   8.542  1.00 70.42           N  
ATOM   1781  CZ  ARG   108      32.875  19.595   7.383  1.00 69.42           C  
ATOM   1782  NH1 ARG   108      33.914  19.119   6.762  1.00 71.23           N  
ATOM   1783  NH2 ARG   108      32.315  20.658   6.812  1.00 68.63           N  
ATOM   1784  C   ARG   108      33.042  18.060  14.355  1.00 65.64           C  
ATOM   1785  O   ARG   108      32.809  17.220  15.228  1.00 65.83           O  
ATOM   1786  N   GLY   109      32.446  19.250  14.335  1.00 64.45           N  
ATOM   1787  CA  GLY   109      31.366  19.562  15.229  1.00 63.52           C  
ATOM   1788  C   GLY   109      31.773  20.342  16.456  1.00 62.89           C  
ATOM   1789  O   GLY   109      30.974  21.104  16.989  1.00 63.61           O  
ATOM   1790  N   ASP   110      32.997  20.160  16.921  1.00 61.84           N  
ATOM   1791  CA  ASP   110      33.435  20.771  18.168  1.00 60.95           C  
ATOM   1792  CB  ASP   110      34.856  20.298  18.533  1.00 62.00           C  
ATOM   1793  CG  ASP   110      34.869  18.980  19.280  1.00 63.76           C  
ATOM   1794  OD1 ASP   110      33.771  18.501  19.596  1.00 67.38           O  
ATOM   1795  OD2 ASP   110      35.966  18.434  19.564  1.00 67.68           O  
ATOM   1796  C   ASP   110      33.406  22.280  18.098  1.00 59.30           C  
ATOM   1797  O   ASP   110      33.432  22.865  17.042  1.00 59.02           O  
ATOM   1798  N   ALA   111      33.379  22.893  19.261  1.00 58.06           N  
ATOM   1799  CA  ALA   111      33.066  24.306  19.406  1.00 57.38           C  
ATOM   1800  CB  ALA   111      32.536  24.554  20.818  1.00 57.21           C  
ATOM   1801  C   ALA   111      34.258  25.205  19.177  1.00 56.72           C  
ATOM   1802  O   ALA   111      35.272  25.089  19.889  1.00 57.57           O  
ATOM   1803  N   ILE   112      34.119  26.154  18.251  1.00 55.21           N  
ATOM   1804  CA  ILE   112      35.225  27.055  17.889  1.00 54.33           C  
ATOM   1805  CB  ILE   112      35.545  27.013  16.382  1.00 53.69           C  
ATOM   1806  CG1 ILE   112      36.137  25.638  15.980  1.00 52.77           C  
ATOM   1807  CD1 ILE   112      37.476  25.275  16.635  1.00 49.92           C  
ATOM   1808  CG2 ILE   112      36.436  28.152  16.043  1.00 53.76           C  
ATOM   1809  C   ILE   112      34.888  28.482  18.207  1.00 53.15           C  
ATOM   1810  O   ILE   112      33.808  28.944  17.899  1.00 51.53           O  
ATOM   1811  N   LEU   113      35.821  29.173  18.845  1.00 53.06           N  
ATOM   1812  CA  LEU   113      35.666  30.596  19.061  1.00 53.03           C  
ATOM   1813  CB  LEU   113      36.292  31.072  20.383  1.00 53.10           C  
ATOM   1814  CG  LEU   113      36.087  32.580  20.532  1.00 52.79           C  
ATOM   1815  CD1 LEU   113      34.661  32.806  21.024  1.00 54.51           C  
ATOM   1816  CD2 LEU   113      37.078  33.222  21.401  1.00 51.36           C  
ATOM   1817  C   LEU   113      36.397  31.229  17.909  1.00 53.23           C  
ATOM   1818  O   LEU   113      37.609  31.012  17.734  1.00 52.53           O  
ATOM   1819  N   ARG   114      35.667  32.020  17.138  1.00 53.46           N  
ATOM   1820  CA  ARG   114      36.223  32.610  15.948  1.00 53.18           C  
ATOM   1821  CB  ARG   114      35.293  32.455  14.780  1.00 53.98           C  
ATOM   1822  CG  ARG   114      35.992  32.861  13.486  1.00 55.81           C  
ATOM   1823  CD  ARG   114      35.286  32.347  12.284  1.00 56.37           C  
ATOM   1824  NE  ARG   114      34.281  33.310  11.980  1.00 62.18           N  
ATOM   1825  CZ  ARG   114      33.110  33.021  11.425  1.00 66.73           C  
ATOM   1826  NH1 ARG   114      32.821  31.763  11.120  1.00 69.41           N  
ATOM   1827  NH2 ARG   114      32.219  33.993  11.177  1.00 65.56           N  
ATOM   1828  C   ARG   114      36.412  34.061  16.129  1.00 51.52           C  
ATOM   1829  O   ARG   114      35.504  34.765  16.508  1.00 50.99           O  
ATOM   1830  N   VAL   115      37.595  34.520  15.806  1.00 50.91           N  
ATOM   1831  CA  VAL   115      37.861  35.942  15.832  1.00 50.00           C  
ATOM   1832  CB  VAL   115      38.953  36.307  16.861  1.00 48.85           C  
ATOM   1833  CG1 VAL   115      39.106  37.829  16.950  1.00 43.80           C  
ATOM   1834  CG2 VAL   115      38.595  35.721  18.153  1.00 46.27           C  
ATOM   1835  C   VAL   115      38.341  36.347  14.469  1.00 50.21           C  
ATOM   1836  O   VAL   115      39.296  35.795  13.969  1.00 51.89           O  
ATOM   1837  N   ARG   116      37.677  37.315  13.884  1.00 49.80           N  
ATOM   1838  CA  ARG   116      38.152  37.929  12.691  1.00 49.49           C  
ATOM   1839  CB  ARG   116      37.035  37.992  11.663  1.00 49.87           C  
ATOM   1840  CG  ARG   116      36.515  36.649  11.141  1.00 51.66           C  
ATOM   1841  CD  ARG   116      35.941  36.909   9.834  1.00 56.96           C  
ATOM   1842  NE  ARG   116      34.794  36.102   9.460  1.00 59.39           N  
ATOM   1843  CZ  ARG   116      34.878  34.960   8.799  1.00 62.41           C  
ATOM   1844  NH1 ARG   116      36.084  34.397   8.490  1.00 66.08           N  
ATOM   1845  NH2 ARG   116      33.748  34.358   8.477  1.00 60.95           N  
ATOM   1846  C   ARG   116      38.524  39.347  13.033  1.00 48.86           C  
ATOM   1847  O   ARG   116      37.747  40.070  13.642  1.00 48.25           O  
ATOM   1848  N   GLN   117      39.661  39.779  12.527  1.00 48.71           N  
ATOM   1849  CA  GLN   117      40.193  41.071  12.872  1.00 48.56           C  
ATOM   1850  CB  GLN   117      41.243  40.818  13.896  1.00 48.45           C  
ATOM   1851  CG  GLN   117      42.384  41.762  13.894  1.00 50.00           C  
ATOM   1852  CD  GLN   117      43.250  41.542  15.144  1.00 49.66           C  
ATOM   1853  OE1 GLN   117      42.762  41.248  16.252  1.00 49.02           O  
ATOM   1854  NE2 GLN   117      44.538  41.627  14.942  1.00 52.07           N  
ATOM   1855  C   GLN   117      40.811  41.792  11.679  1.00 48.14           C  
ATOM   1856  O   GLN   117      41.481  41.162  10.894  1.00 48.86           O  
ATOM   1857  N   VAL   118      40.553  43.097  11.554  1.00 47.34           N  
ATOM   1858  CA  VAL   118      41.311  43.996  10.683  1.00 46.98           C  
ATOM   1859  CB  VAL   118      40.423  44.783   9.740  1.00 45.57           C  
ATOM   1860  CG1 VAL   118      41.288  45.644   8.844  1.00 43.48           C  
ATOM   1861  CG2 VAL   118      39.588  43.858   8.940  1.00 41.77           C  
ATOM   1862  C   VAL   118      42.097  45.009  11.516  1.00 47.59           C  
ATOM   1863  O   VAL   118      41.560  45.561  12.457  1.00 48.49           O  
ATOM   1864  N   SER   119      43.345  45.264  11.152  1.00 48.06           N  
ATOM   1865  CA  SER   119      44.183  46.194  11.873  1.00 48.99           C  
ATOM   1866  CB  SER   119      45.413  45.504  12.457  1.00 49.20           C  
ATOM   1867  OG  SER   119      45.043  44.443  13.305  1.00 49.66           O  
ATOM   1868  C   SER   119      44.660  47.243  10.911  1.00 50.78           C  
ATOM   1869  O   SER   119      44.887  46.968   9.720  1.00 51.04           O  
ATOM   1870  N   TYR   120      44.848  48.447  11.436  1.00 52.36           N  
ATOM   1871  CA  TYR   120      45.118  49.599  10.596  1.00 53.81           C  
ATOM   1872  CB  TYR   120      43.912  50.539  10.637  1.00 53.34           C  
ATOM   1873  CG  TYR   120      42.625  49.910  10.233  1.00 52.23           C  
ATOM   1874  CD1 TYR   120      42.137  50.064   8.948  1.00 52.04           C  
ATOM   1875  CE1 TYR   120      40.935  49.490   8.562  1.00 51.37           C  
ATOM   1876  CZ  TYR   120      40.232  48.745   9.477  1.00 51.73           C  
ATOM   1877  OH  TYR   120      39.055  48.157   9.111  1.00 53.17           O  
ATOM   1878  CE2 TYR   120      40.706  48.574  10.755  1.00 52.14           C  
ATOM   1879  CD2 TYR   120      41.895  49.167  11.130  1.00 51.06           C  
ATOM   1880  C   TYR   120      46.343  50.379  11.045  1.00 54.45           C  
ATOM   1881  O   TYR   120      46.699  50.382  12.221  1.00 54.84           O  
ATOM   1882  N   PHE   121      46.964  51.098  10.121  1.00 55.53           N  
ATOM   1883  CA  PHE   121      47.946  52.079  10.542  1.00 56.46           C  
ATOM   1884  CB  PHE   121      48.870  52.473   9.379  1.00 56.48           C  
ATOM   1885  CG  PHE   121      49.843  51.393   9.001  1.00 55.95           C  
ATOM   1886  CD1 PHE   121      50.465  50.608   9.984  1.00 57.46           C  
ATOM   1887  CE1 PHE   121      51.393  49.607   9.640  1.00 56.87           C  
ATOM   1888  CZ  PHE   121      51.688  49.388   8.304  1.00 56.73           C  
ATOM   1889  CE2 PHE   121      51.059  50.155   7.326  1.00 56.28           C  
ATOM   1890  CD2 PHE   121      50.147  51.150   7.680  1.00 55.91           C  
ATOM   1891  C   PHE   121      47.251  53.314  11.147  1.00 57.56           C  
ATOM   1892  O   PHE   121      46.077  53.622  10.832  1.00 58.10           O  
ATOM   1893  N   GLU   122      47.989  54.032  11.993  1.00 57.96           N  
ATOM   1894  CA  GLU   122      47.539  55.339  12.459  1.00 58.02           C  
ATOM   1895  CB  GLU   122      48.619  56.062  13.267  1.00 57.75           C  
ATOM   1896  CG  GLU   122      48.876  55.329  14.583  1.00 58.73           C  
ATOM   1897  CD  GLU   122      49.683  56.115  15.601  1.00 59.40           C  
ATOM   1898  OE1 GLU   122      50.450  57.012  15.171  1.00 63.62           O  
ATOM   1899  OE2 GLU   122      49.566  55.809  16.818  1.00 57.35           O  
ATOM   1900  C   GLU   122      47.053  56.189  11.307  1.00 58.16           C  
ATOM   1901  O   GLU   122      46.253  57.060  11.527  1.00 58.29           O  
ATOM   1902  N   ASN   123      47.483  55.940  10.072  1.00 58.65           N  
ATOM   1903  CA  ASN   123      46.956  56.745   8.991  1.00 58.77           C  
ATOM   1904  CB  ASN   123      48.049  57.058   7.975  1.00 59.77           C  
ATOM   1905  CG  ASN   123      48.489  55.842   7.158  1.00 62.70           C  
ATOM   1906  OD1 ASN   123      47.692  54.953   6.816  1.00 63.41           O  
ATOM   1907  ND2 ASN   123      49.777  55.825   6.809  1.00 66.38           N  
ATOM   1908  C   ASN   123      45.719  56.175   8.318  1.00 58.63           C  
ATOM   1909  O   ASN   123      45.349  56.630   7.223  1.00 58.28           O  
ATOM   1910  N   GLY   124      45.087  55.175   8.942  1.00 58.27           N  
ATOM   1911  CA  GLY   124      43.851  54.572   8.377  1.00 57.96           C  
ATOM   1912  C   GLY   124      43.988  53.406   7.394  1.00 57.60           C  
ATOM   1913  O   GLY   124      43.000  52.794   7.035  1.00 57.60           O  
ATOM   1914  N   LEU   125      45.209  53.091   6.958  1.00 57.62           N  
ATOM   1915  CA  LEU   125      45.474  52.003   5.971  1.00 56.79           C  
ATOM   1916  CB  LEU   125      46.863  52.172   5.354  1.00 56.99           C  
ATOM   1917  CG  LEU   125      47.313  51.209   4.238  1.00 57.32           C  
ATOM   1918  CD1 LEU   125      46.559  51.492   2.962  1.00 51.24           C  
ATOM   1919  CD2 LEU   125      48.879  51.262   4.034  1.00 56.37           C  
ATOM   1920  C   LEU   125      45.439  50.619   6.641  1.00 56.59           C  
ATOM   1921  O   LEU   125      46.185  50.381   7.602  1.00 56.51           O  
ATOM   1922  N   PRO   126      44.569  49.713   6.150  1.00 55.20           N  
ATOM   1923  CA  PRO   126      44.594  48.317   6.590  1.00 54.19           C  
ATOM   1924  CB  PRO   126      43.546  47.649   5.714  1.00 54.04           C  
ATOM   1925  CG  PRO   126      42.677  48.766   5.184  1.00 55.27           C  
ATOM   1926  CD  PRO   126      43.500  49.995   5.175  1.00 55.35           C  
ATOM   1927  C   PRO   126      45.931  47.648   6.331  1.00 52.47           C  
ATOM   1928  O   PRO   126      46.533  47.848   5.270  1.00 52.28           O  
ATOM   1929  N   PHE   127      46.389  46.837   7.270  1.00 50.79           N  
ATOM   1930  CA  PHE   127      47.560  46.065   7.000  1.00 49.66           C  
ATOM   1931  CB  PHE   127      48.770  46.716   7.670  1.00 49.45           C  
ATOM   1932  CG  PHE   127      48.796  46.579   9.145  1.00 49.09           C  
ATOM   1933  CD1 PHE   127      49.357  45.457   9.733  1.00 49.51           C  
ATOM   1934  CE1 PHE   127      49.395  45.324  11.118  1.00 50.25           C  
ATOM   1935  CZ  PHE   127      48.868  46.326  11.933  1.00 49.75           C  
ATOM   1936  CE2 PHE   127      48.322  47.460  11.335  1.00 49.82           C  
ATOM   1937  CD2 PHE   127      48.293  47.583   9.962  1.00 48.80           C  
ATOM   1938  C   PHE   127      47.426  44.594   7.350  1.00 49.26           C  
ATOM   1939  O   PHE   127      48.370  43.844   7.193  1.00 50.61           O  
ATOM   1940  N   GLU   128      46.257  44.151   7.752  1.00 48.37           N  
ATOM   1941  CA  GLU   128      46.129  42.822   8.282  1.00 48.59           C  
ATOM   1942  CB  GLU   128      46.561  42.888   9.728  1.00 48.53           C  
ATOM   1943  CG  GLU   128      47.258  41.717  10.178  1.00 50.32           C  
ATOM   1944  CD  GLU   128      47.613  41.718  11.695  1.00 50.97           C  
ATOM   1945  OE1 GLU   128      46.903  42.361  12.563  1.00 48.10           O  
ATOM   1946  OE2 GLU   128      48.606  40.977  11.980  1.00 55.33           O  
ATOM   1947  C   GLU   128      44.661  42.419   8.224  1.00 48.49           C  
ATOM   1948  O   GLU   128      43.790  43.206   8.620  1.00 48.17           O  
ATOM   1949  N   TYR   129      44.360  41.220   7.741  1.00 47.88           N  
ATOM   1950  CA  TYR   129      43.021  40.662   7.924  1.00 47.72           C  
ATOM   1951  CB  TYR   129      42.290  40.605   6.589  1.00 47.75           C  
ATOM   1952  CG  TYR   129      40.957  39.924   6.655  1.00 47.52           C  
ATOM   1953  CD1 TYR   129      40.152  40.056   7.758  1.00 46.95           C  
ATOM   1954  CE1 TYR   129      38.919  39.449   7.823  1.00 46.77           C  
ATOM   1955  CZ  TYR   129      38.460  38.721   6.777  1.00 47.90           C  
ATOM   1956  OH  TYR   129      37.231  38.120   6.883  1.00 49.08           O  
ATOM   1957  CE2 TYR   129      39.221  38.586   5.643  1.00 46.54           C  
ATOM   1958  CD2 TYR   129      40.482  39.180   5.593  1.00 46.25           C  
ATOM   1959  C   TYR   129      43.222  39.275   8.479  1.00 47.18           C  
ATOM   1960  O   TYR   129      43.747  38.406   7.826  1.00 47.44           O  
ATOM   1961  N   VAL   130      42.856  39.068   9.713  1.00 47.14           N  
ATOM   1962  CA  VAL   130      43.312  37.876  10.421  1.00 46.73           C  
ATOM   1963  CB  VAL   130      44.313  38.235  11.580  1.00 46.73           C  
ATOM   1964  CG1 VAL   130      44.880  36.978  12.232  1.00 42.42           C  
ATOM   1965  CG2 VAL   130      45.438  39.132  11.030  1.00 43.30           C  
ATOM   1966  C   VAL   130      42.100  37.144  10.923  1.00 47.65           C  
ATOM   1967  O   VAL   130      41.148  37.755  11.424  1.00 48.37           O  
ATOM   1968  N   ARG   131      42.085  35.841  10.720  1.00 48.01           N  
ATOM   1969  CA  ARG   131      40.872  35.081  10.995  1.00 48.71           C  
ATOM   1970  CB  ARG   131      40.191  34.689   9.703  1.00 48.30           C  
ATOM   1971  CG  ARG   131      39.837  35.900   8.836  1.00 50.13           C  
ATOM   1972  CD  ARG   131      39.993  35.617   7.365  1.00 49.77           C  
ATOM   1973  NE  ARG   131      41.290  36.030   6.895  1.00 50.32           N  
ATOM   1974  CZ  ARG   131      41.718  35.851   5.647  1.00 49.41           C  
ATOM   1975  NH1 ARG   131      41.000  35.229   4.746  1.00 49.10           N  
ATOM   1976  NH2 ARG   131      42.903  36.268   5.305  1.00 51.37           N  
ATOM   1977  C   ARG   131      41.352  33.869  11.746  1.00 48.75           C  
ATOM   1978  O   ARG   131      42.088  33.018  11.192  1.00 48.68           O  
ATOM   1979  N   THR   132      40.990  33.838  13.018  1.00 48.37           N  
ATOM   1980  CA  THR   132      41.508  32.864  13.900  1.00 48.79           C  
ATOM   1981  CB  THR   132      42.200  33.530  15.005  1.00 48.55           C  
ATOM   1982  OG1 THR   132      43.272  34.284  14.466  1.00 47.19           O  
ATOM   1983  CG2 THR   132      42.718  32.499  15.962  1.00 49.57           C  
ATOM   1984  C   THR   132      40.408  31.999  14.456  1.00 49.47           C  
ATOM   1985  O   THR   132      39.333  32.469  14.781  1.00 49.43           O  
ATOM   1986  N   GLN   133      40.726  30.729  14.580  1.00 50.15           N  
ATOM   1987  CA  GLN   133      39.804  29.751  15.042  1.00 51.36           C  
ATOM   1988  CB  GLN   133      39.566  28.845  13.853  1.00 51.63           C  
ATOM   1989  CG  GLN   133      38.130  28.484  13.637  1.00 53.97           C  
ATOM   1990  CD  GLN   133      37.756  28.356  12.227  1.00 53.78           C  
ATOM   1991  OE1 GLN   133      38.175  29.153  11.397  1.00 59.44           O  
ATOM   1992  NE2 GLN   133      36.938  27.369  11.928  1.00 52.86           N  
ATOM   1993  C   GLN   133      40.454  29.011  16.245  1.00 52.27           C  
ATOM   1994  O   GLN   133      41.479  28.275  16.099  1.00 52.37           O  
ATOM   1995  N   TYR   134      39.922  29.265  17.440  1.00 52.39           N  
ATOM   1996  CA  TYR   134      40.437  28.675  18.702  1.00 51.75           C  
ATOM   1997  CB  TYR   134      40.318  29.669  19.851  1.00 51.18           C  
ATOM   1998  CG  TYR   134      41.065  30.944  19.651  1.00 50.26           C  
ATOM   1999  CD1 TYR   134      42.380  31.067  20.050  1.00 49.80           C  
ATOM   2000  CE1 TYR   134      43.059  32.248  19.880  1.00 49.75           C  
ATOM   2001  CZ  TYR   134      42.413  33.300  19.314  1.00 50.69           C  
ATOM   2002  OH  TYR   134      43.058  34.481  19.081  1.00 49.39           O  
ATOM   2003  CE2 TYR   134      41.095  33.189  18.947  1.00 49.62           C  
ATOM   2004  CD2 TYR   134      40.439  32.040  19.126  1.00 47.46           C  
ATOM   2005  C   TYR   134      39.574  27.481  19.102  1.00 52.15           C  
ATOM   2006  O   TYR   134      38.337  27.544  19.009  1.00 52.17           O  
ATOM   2007  N   ALA   135      40.212  26.400  19.538  1.00 52.83           N  
ATOM   2008  CA  ALA   135      39.516  25.304  20.223  1.00 53.80           C  
ATOM   2009  CB  ALA   135      40.500  24.240  20.621  1.00 54.12           C  
ATOM   2010  C   ALA   135      38.835  25.828  21.475  1.00 54.42           C  
ATOM   2011  O   ALA   135      39.522  26.263  22.380  1.00 54.82           O  
ATOM   2012  N   GLY   136      37.505  25.748  21.527  1.00 55.21           N  
ATOM   2013  CA  GLY   136      36.714  26.373  22.573  1.00 56.35           C  
ATOM   2014  C   GLY   136      37.160  25.950  23.957  1.00 57.46           C  
ATOM   2015  O   GLY   136      37.420  26.786  24.822  1.00 57.55           O  
ATOM   2016  N   SER   137      37.309  24.637  24.100  1.00 58.04           N  
ATOM   2017  CA  SER   137      37.584  23.991  25.357  1.00 58.40           C  
ATOM   2018  CB  SER   137      37.448  22.498  25.147  1.00 58.31           C  
ATOM   2019  OG  SER   137      38.656  22.013  24.582  1.00 60.24           O  
ATOM   2020  C   SER   137      39.002  24.293  25.866  1.00 58.94           C  
ATOM   2021  O   SER   137      39.258  24.267  27.052  1.00 58.77           O  
ATOM   2022  N   ARG   138      39.888  24.640  24.958  1.00 59.42           N  
ATOM   2023  CA  ARG   138      41.243  24.926  25.327  1.00 59.55           C  
ATOM   2024  CB  ARG   138      42.198  24.290  24.337  1.00 59.46           C  
ATOM   2025  CG  ARG   138      42.003  22.826  24.159  1.00 60.00           C  
ATOM   2026  CD  ARG   138      43.098  22.241  23.330  1.00 62.14           C  
ATOM   2027  NE  ARG   138      42.694  20.985  22.724  1.00 63.97           N  
ATOM   2028  CZ  ARG   138      43.002  20.627  21.491  1.00 67.45           C  
ATOM   2029  NH1 ARG   138      43.725  21.426  20.738  1.00 69.16           N  
ATOM   2030  NH2 ARG   138      42.587  19.474  21.013  1.00 68.58           N  
ATOM   2031  C   ARG   138      41.529  26.394  25.390  1.00 59.70           C  
ATOM   2032  O   ARG   138      42.649  26.771  25.597  1.00 60.22           O  
ATOM   2033  N   PHE   139      40.535  27.240  25.215  1.00 20.00           N  
ATOM   2034  CA  PHE   139      40.825  28.657  25.130  1.00 20.00           C  
ATOM   2035  C   PHE   139      39.807  29.563  25.785  1.00 20.00           C  
ATOM   2036  CB  PHE   139      40.981  29.036  23.668  1.00 20.00           C  
ATOM   2037  CG  PHE   139      41.372  30.443  23.451  1.00 20.00           C  
ATOM   2038  CD1 PHE   139      42.629  30.856  23.709  1.00 20.00           C  
ATOM   2039  CD2 PHE   139      40.481  31.348  22.985  1.00 20.00           C  
ATOM   2040  CE1 PHE   139      42.978  32.133  23.514  1.00 20.00           C  
ATOM   2041  CE2 PHE   139      40.844  32.628  22.788  1.00 20.00           C  
ATOM   2042  CZ  PHE   139      42.087  33.017  23.052  1.00 20.00           C  
ATOM   2043  O   PHE   139      38.661  29.235  25.870  1.00 59.96           O  
ATOM   2044  N   GLU   140      40.271  30.708  26.243  1.00 57.79           N  
ATOM   2045  CA  GLU   140      39.471  31.798  26.743  1.00 57.81           C  
ATOM   2046  CB  GLU   140      39.561  31.827  28.276  1.00 58.32           C  
ATOM   2047  CG  GLU   140      38.980  30.633  29.001  1.00 59.77           C  
ATOM   2048  CD  GLU   140      37.468  30.477  28.805  1.00 62.71           C  
ATOM   2049  OE1 GLU   140      36.724  31.478  28.868  1.00 64.64           O  
ATOM   2050  OE2 GLU   140      37.023  29.333  28.599  1.00 65.28           O  
ATOM   2051  C   GLU   140      39.985  33.135  26.259  1.00 56.94           C  
ATOM   2052  O   GLU   140      41.120  33.419  26.418  1.00 56.93           O  
ATOM   2053  N   PHE   141      39.147  34.003  25.747  1.00 56.96           N  
ATOM   2054  CA  PHE   141      39.609  35.288  25.253  1.00 57.82           C  
ATOM   2055  CB  PHE   141      38.846  35.543  23.966  1.00 56.48           C  
ATOM   2056  CG  PHE   141      39.082  36.868  23.306  1.00 55.72           C  
ATOM   2057  CD1 PHE   141      38.557  38.039  23.831  1.00 55.21           C  
ATOM   2058  CE1 PHE   141      38.704  39.257  23.167  1.00 55.83           C  
ATOM   2059  CZ  PHE   141      39.379  39.299  21.966  1.00 56.64           C  
ATOM   2060  CE2 PHE   141      39.896  38.125  21.431  1.00 54.39           C  
ATOM   2061  CD2 PHE   141      39.704  36.928  22.074  1.00 53.44           C  
ATOM   2062  C   PHE   141      39.343  36.299  26.354  1.00 58.49           C  
ATOM   2063  O   PHE   141      38.231  36.429  26.837  1.00 59.23           O  
ATOM   2064  N   TYR   142      40.370  37.007  26.775  1.00 60.30           N  
ATOM   2065  CA  TYR   142      40.255  37.923  27.890  1.00 61.99           C  
ATOM   2066  CB  TYR   142      41.538  37.901  28.744  1.00 62.52           C  
ATOM   2067  CG  TYR   142      41.817  36.495  29.283  1.00 63.41           C  
ATOM   2068  CD1 TYR   142      41.325  36.080  30.531  1.00 64.00           C  
ATOM   2069  CE1 TYR   142      41.540  34.760  31.004  1.00 63.03           C  
ATOM   2070  CZ  TYR   142      42.240  33.858  30.210  1.00 64.94           C  
ATOM   2071  OH  TYR   142      42.453  32.567  30.644  1.00 65.69           O  
ATOM   2072  CE2 TYR   142      42.756  34.242  28.967  1.00 64.21           C  
ATOM   2073  CD2 TYR   142      42.525  35.556  28.512  1.00 65.36           C  
ATOM   2074  C   TYR   142      39.890  39.321  27.423  1.00 63.29           C  
ATOM   2075  O   TYR   142      40.614  39.943  26.715  1.00 62.80           O  
ATOM   2076  N   LEU   143      38.725  39.812  27.804  1.00 65.62           N  
ATOM   2077  CA  LEU   143      38.378  41.174  27.496  1.00 67.74           C  
ATOM   2078  CB  LEU   143      36.963  41.468  27.958  1.00 67.89           C  
ATOM   2079  CG  LEU   143      35.934  41.088  26.905  1.00 69.11           C  
ATOM   2080  CD1 LEU   143      34.698  41.872  27.213  1.00 70.90           C  
ATOM   2081  CD2 LEU   143      35.654  39.584  26.883  1.00 70.43           C  
ATOM   2082  C   LEU   143      39.336  42.175  28.113  1.00 69.39           C  
ATOM   2083  O   LEU   143      39.666  42.069  29.251  1.00 69.58           O  
ATOM   2084  N   GLU   144      39.739  43.172  27.338  1.00 72.54           N  
ATOM   2085  CA  GLU   144      40.716  44.181  27.750  1.00 74.25           C  
ATOM   2086  CB  GLU   144      41.140  45.025  26.535  1.00 75.01           C  
ATOM   2087  CG  GLU   144      42.668  45.196  26.372  1.00 78.53           C  
ATOM   2088  CD  GLU   144      43.312  44.291  25.286  1.00 81.51           C  
ATOM   2089  OE1 GLU   144      42.961  44.465  24.090  1.00 82.90           O  
ATOM   2090  OE2 GLU   144      44.194  43.440  25.625  1.00 81.58           O  
ATOM   2091  C   GLU   144      40.084  45.065  28.820  1.00 75.75           C  
ATOM   2092  O   GLU   144      38.998  45.599  28.614  1.00 75.96           O  
ATOM   2093  N   LYS   145      40.769  45.217  29.962  1.00 77.85           N  
ATOM   2094  CA  LYS   145      40.187  45.886  31.153  1.00 78.63           C  
ATOM   2095  CB  LYS   145      41.158  45.909  32.361  1.00 79.83           C  
ATOM   2096  CG  LYS   145      41.775  44.560  32.815  1.00 81.50           C  
ATOM   2097  CD  LYS   145      40.796  43.534  33.467  1.00 83.50           C  
ATOM   2098  CE  LYS   145      41.629  42.298  34.002  1.00 84.23           C  
ATOM   2099  NZ  LYS   145      40.927  40.996  34.381  1.00 83.07           N  
ATOM   2100  C   LYS   145      39.779  47.327  30.817  1.00 79.77           C  
ATOM   2101  O   LYS   145      40.647  48.168  30.548  1.00 80.23           O  
END
