
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  146 ( 1183),  selected  146 , name 2ikk_A
# Molecule2: number of CA atoms  139 ( 1121),  selected  139 , name T0455.pdb
# PARAMETERS: 2ikk_A.T0455.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    83_A      S       7           -
LGA    T    84_A      -       -           -
LGA    E    85_A      -       -           -
LGA    N    86_A      -       -           -
LGA    L    87_A      -       -           -
LGA    Y    88_A      -       -           -
LGA    F    89_A      -       -           -
LGA    Q    90_A      -       -           -
LGA    H   101_A      S       8          2.283
LGA    H   102_A      R       9          2.301
LGA    V   103_A      T      10          1.973
LGA    L   104_A      V      11          2.103
LGA    S   105_A      S      12          1.861
LGA    H   106_A      Y      13          0.717
LGA    D   107_A      F      14          0.942
LGA    I   108_A      V      15          0.738
LGA    I   109_A      A      16          1.162
LGA    P   110_A      K      17          1.511
LGA    A   111_A      P      18          0.651
LGA    S   112_A      S      19          0.645
LGA    K   113_A      S      20          0.377
LGA    P   114_A      S      21          0.493
LGA    I   115_A      E      22          0.971
LGA    A   116_A      M      23          0.897
LGA    E   117_A      E      24          0.360
LGA    K   118_A      K      25          0.251
LGA    L   119_A      L      26          0.299
LGA    Q   120_A      Q      27          0.475
LGA    I   121_A      L      28          0.496
LGA    Q   122_A      G      29          0.236
LGA    P   123_A      P      30          2.183
LGA    E   124_A      E      31          4.371
LGA    S   125_A      D      32          2.523
LGA    P   126_A      S      33          1.170
LGA    V   127_A      I      34          0.869
LGA    V   128_A      L      35          0.605
LGA    E   129_A      R      36          0.738
LGA    L   130_A      M      37          1.269
LGA    K   131_A      E      38          1.285
LGA    R   132_A      R      39          1.479
LGA    I   133_A      I      40          1.474
LGA    L   134_A      R      41          1.307
LGA    Y   135_A      F      42          0.670
LGA    N   136_A      A      43          1.168
LGA    D   137_A      D      44          0.858
LGA    D   138_A      D      45          1.027
LGA    Q   139_A      I      46          0.891
LGA    P   140_A      P      47          0.484
LGA    L   141_A      I      48          0.710
LGA    T   142_A      C      49          1.569
LGA    F   143_A      F      50          0.962
LGA    E   144_A      E      51          1.176
LGA    V   145_A      V      52          0.923
LGA    T   146_A      A      53          0.646
LGA    H   147_A      S      54          0.464
LGA    Y   148_A      I      55          0.607
LGA    P   149_A      P      56          0.522
LGA    L   150_A      Y      57          0.941
LGA    D   151_A      S      58          2.512
LGA    L   152_A      L      59          3.113
LGA    F   153_A      V      60          2.830
LGA    P   154_A      S      61          2.586
LGA    G   155_A      Q      62          3.827
LGA    I   156_A      Y      63          4.140
LGA    D   157_A      -       -           -
LGA    T   158_A      -       -           -
LGA    F   159_A      G      64          1.545
LGA    I   160_A      K      65          1.636
LGA    A   161_A      S      66          3.079
LGA    D   162_A      E      67           -
LGA    G   163_A      I      68           -
LGA    V   164_A      T      69          4.561
LGA    S   165_A      N      70          2.856
LGA    -       -      S      71           -
LGA    X   166_A      F      72          1.147
LGA    H   167_A      Y      73          1.175
LGA    D   168_A      K      74          2.088
LGA    I   169_A      T      75          2.243
LGA    L   170_A      L      76          1.349
LGA    K   171_A      E      77          2.118
LGA    Q   172_A      A      78          2.857
LGA    Q   173_A      K      79          3.457
LGA    Y   174_A      S      80          2.084
LGA    K   175_A      G      81          2.775
LGA    V   176_A      H      82          3.338
LGA    V   177_A      K      83          3.102
LGA    P   178_A      I      84          1.219
LGA    T   179_A      G      85          1.652
LGA    H   180_A      H      86          1.689
LGA    N   181_A      S      87          0.419
LGA    T   182_A      N      88          0.339
LGA    K   183_A      Q      89          0.499
LGA    L   184_A      T      90          0.475
LGA    L   185_A      I      91          0.176
LGA    N   186_A      S      92          0.631
LGA    V   187_A      A      93          1.144
LGA    V   188_A      V      94          1.939
LGA    Y   189_A      Q      95          2.254
LGA    A   190_A      A      96          1.909
LGA    Q   191_A      S      97          1.849
LGA    Q   192_A      E      98          3.002
LGA    E   193_A      Q      99          2.562
LGA    E   194_A      I     100          0.998
LGA    S   195_A      A     101          1.322
LGA    K   196_A      E     102          1.843
LGA    Y   197_A      Y     103          1.504
LGA    L   198_A      L     104          0.744
LGA    D   199_A      E     105          0.829
LGA    C   200_A      I     106          1.110
LGA    D   201_A      K     107          1.279
LGA    I   202_A      R     108          1.804
LGA    G   203_A      G     109          2.521
LGA    D   204_A      D     110          1.885
LGA    A   205_A      A     111          2.052
LGA    L   206_A      I     112          0.623
LGA    F   207_A      L     113          0.717
LGA    E   208_A      R     114          0.657
LGA    I   209_A      V     115          0.499
LGA    D   210_A      R     116          0.475
LGA    K   211_A      Q     117          0.702
LGA    T   212_A      V     118          0.502
LGA    A   213_A      S     119          0.670
LGA    F   214_A      Y     120          0.556
LGA    T   215_A      F     121          0.714
LGA    S   216_A      E     122          1.767
LGA    N   217_A      N     123          2.060
LGA    D   218_A      G     124          1.622
LGA    Q   219_A      L     125          1.419
LGA    P   220_A      P     126          0.896
LGA    I   221_A      F     127          0.941
LGA    Y   222_A      E     128          0.960
LGA    C   223_A      Y     129          1.120
LGA    S   224_A      V     130          0.522
LGA    L   225_A      R     131          0.677
LGA    F   226_A      T     132          1.091
LGA    L   227_A      Q     133          0.631
LGA    X   228_A      Y     134          0.346
LGA    H   229_A      A     135          1.159
LGA    T   230_A      G     136          1.180
LGA    N   231_A      S     137          1.186
LGA    R   232_A      R     138          1.284
LGA    V   233_A      F     139          1.411
LGA    T   234_A      E     140          1.997
LGA    F   235_A      F     141          2.273
LGA    T   236_A      Y     142          2.361
LGA    I   237_A      L     143          1.786
LGA    -       -      E     144           -
LGA    N   238_A      K     145          2.775

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  146  139    5.0    134    1.71    23.13     87.312     7.411

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.260989 * X  +  -0.920505 * Y  +   0.290784 * Z  +  40.838055
  Y_new =   0.646017 * X  +   0.390375 * Y  +   0.655949 * Z  +  24.033766
  Z_new =  -0.717319 * X  +   0.016656 * Y  +   0.696545 * Z  +  22.437048 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.023907   -3.117685  [ DEG:     1.3698   -178.6302 ]
  Theta =   0.799947    2.341645  [ DEG:    45.8336    134.1664 ]
  Phi   =   1.186849   -1.954744  [ DEG:    68.0014   -111.9986 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ikk_A                                        
REMARK     2: T0455.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ikk_A.T0455.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  146  139   5.0  134   1.71   23.13  87.312
REMARK  ---------------------------------------------------------- 
MOLECULE 2ikk_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   02-OCT-06   2IKK              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF THE C-                  
TITLE    2 TERMINAL DOMAIN OF YURK FROM BACILLUS SUBTILIS SUBSP.                
TITLE    3 SUBTILIS STR. 168                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL TRANSCRIPTIONAL REGULATOR YURK;               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: C-TERMINAL DOMAIN;                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    APC85442, YURK, BACILLUS SUBTILIS SUBSP. SUBTILIS STR. 168,           
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER FOR             
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   31-OCT-06 2IKK    0                                                
JRNL        AUTH   K.TAN,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK                       
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE C-TERMINAL DOMAIN OF            
JRNL        TITL 2 YURK FROM BACILLUS SUBTILIS SUBSP. SUBTILIS STR.             
JRNL        TITL 3 168                                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2IKK A   94   242  UNP    O32152   YURK_BACSU      94    242             
DBREF  2IKK B   94   242  UNP    O32152   YURK_BACSU      94    242             
SEQRES   1 A  173  MSE HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  173  GLY THR GLU ASN LEU TYR PHE GLN SER ASN ALA SER THR          
SEQRES   3 A  173  GLY LYS LYS PRO LYS HIS HIS VAL LEU SER HIS ASP ILE          
SEQRES   4 A  173  ILE PRO ALA SER LYS PRO ILE ALA GLU LYS LEU GLN ILE          
SEQRES   5 A  173  GLN PRO GLU SER PRO VAL VAL GLU LEU LYS ARG ILE LEU          
SEQRES   6 A  173  TYR ASN ASP ASP GLN PRO LEU THR PHE GLU VAL THR HIS          
SEQRES   7 A  173  TYR PRO LEU ASP LEU PHE PRO GLY ILE ASP THR PHE ILE          
SEQRES   8 A  173  ALA ASP GLY VAL SER MSE HIS ASP ILE LEU LYS GLN GLN          
SEQRES   9 A  173  TYR LYS VAL VAL PRO THR HIS ASN THR LYS LEU LEU ASN          
SEQRES  10 A  173  VAL VAL TYR ALA GLN GLN GLU GLU SER LYS TYR LEU ASP          
SEQRES  11 A  173  CYS ASP ILE GLY ASP ALA LEU PHE GLU ILE ASP LYS THR          
SEQRES  12 A  173  ALA PHE THR SER ASN ASP GLN PRO ILE TYR CYS SER LEU          
SEQRES  13 A  173  PHE LEU MSE HIS THR ASN ARG VAL THR PHE THR ILE ASN          
SEQRES  14 A  173  SER PRO TYR THR                                              
SEQRES   1 B  173  MSE HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  173  GLY THR GLU ASN LEU TYR PHE GLN SER ASN ALA SER THR          
SEQRES   3 B  173  GLY LYS LYS PRO LYS HIS HIS VAL LEU SER HIS ASP ILE          
SEQRES   4 B  173  ILE PRO ALA SER LYS PRO ILE ALA GLU LYS LEU GLN ILE          
SEQRES   5 B  173  GLN PRO GLU SER PRO VAL VAL GLU LEU LYS ARG ILE LEU          
SEQRES   6 B  173  TYR ASN ASP ASP GLN PRO LEU THR PHE GLU VAL THR HIS          
SEQRES   7 B  173  TYR PRO LEU ASP LEU PHE PRO GLY ILE ASP THR PHE ILE          
SEQRES   8 B  173  ALA ASP GLY VAL SER MSE HIS ASP ILE LEU LYS GLN GLN          
SEQRES   9 B  173  TYR LYS VAL VAL PRO THR HIS ASN THR LYS LEU LEU ASN          
SEQRES  10 B  173  VAL VAL TYR ALA GLN GLN GLU GLU SER LYS TYR LEU ASP          
SEQRES  11 B  173  CYS ASP ILE GLY ASP ALA LEU PHE GLU ILE ASP LYS THR          
SEQRES  12 B  173  ALA PHE THR SER ASN ASP GLN PRO ILE TYR CYS SER LEU          
SEQRES  13 B  173  PHE LEU MSE HIS THR ASN ARG VAL THR PHE THR ILE ASN          
SEQRES  14 B  173  SER PRO TYR THR                                              
HET    MSE  A 166       8                                                       
HET    MSE  A 228       8                                                       
HET    MSE  B 166       8                                                       
HET    MSE  B 228       8                                                       
HET    SO4    201       5                                                       
HET    SO4    202       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3  SO4    2(O4 S 2-)                                                   
FORMUL   5  HOH   *179(H2 O)                                                    
CRYST1   40.509  104.704   40.538  90.00 118.58  90.00 P 1 21 1      4          
ATOM      1  N   GLY A  83      38.171  29.103  34.441  1.00 68.94           N  
ATOM      2  CA  GLY A  83      37.953  28.888  32.980  1.00 69.10           C  
ATOM      3  C   GLY A  83      38.764  27.746  32.377  1.00 69.21           C  
ATOM      4  O   GLY A  83      38.589  26.575  32.743  1.00 69.22           O  
ATOM      5  N   THR A  84      39.635  28.077  31.425  1.00 69.24           N  
ATOM      6  CA  THR A  84      40.489  27.068  30.783  1.00 69.26           C  
ATOM      7  C   THR A  84      41.923  27.570  30.517  1.00 68.75           C  
ATOM      8  O   THR A  84      42.763  27.512  31.425  1.00 69.60           O  
ATOM      9  CB  THR A  84      39.788  26.403  29.555  1.00 69.73           C  
ATOM     10  OG1 THR A  84      40.697  26.323  28.447  1.00 70.55           O  
ATOM     11  CG2 THR A  84      38.516  27.165  29.144  1.00 69.90           C  
ATOM     12  N   GLU A  85      42.214  28.007  29.287  1.00 67.31           N  
ATOM     13  CA  GLU A  85      43.323  28.935  29.017  1.00 65.45           C  
ATOM     14  C   GLU A  85      42.714  30.290  28.619  1.00 64.51           C  
ATOM     15  O   GLU A  85      41.665  30.375  27.969  1.00 62.19           O  
ATOM     16  CB  GLU A  85      44.291  28.425  27.939  1.00 65.49           C  
ATOM     17  CG  GLU A  85      44.774  26.983  28.122  1.00 65.32           C  
ATOM     18  CD  GLU A  85      44.183  26.023  27.074  1.00 65.94           C  
ATOM     19  OE1 GLU A  85      43.490  25.037  27.431  1.00 63.55           O  
ATOM     20  OE2 GLU A  85      44.407  26.266  25.873  1.00 67.48           O  
ATOM     21  N   ASN A  86      43.421  31.343  28.991  1.00 64.59           N  
ATOM     22  CA  ASN A  86      42.854  32.668  29.116  1.00 64.39           C  
ATOM     23  C   ASN A  86      43.367  33.655  28.057  1.00 64.48           C  
ATOM     24  O   ASN A  86      44.469  34.187  28.179  1.00 64.51           O  
ATOM     25  CB  ASN A  86      43.217  33.163  30.510  1.00 64.79           C  
ATOM     26  CG  ASN A  86      42.043  33.731  31.250  1.00 65.78           C  
ATOM     27  OD1 ASN A  86      41.303  34.560  30.718  1.00 67.02           O  
ATOM     28  ND2 ASN A  86      41.869  33.299  32.502  1.00 65.76           N  
ATOM     29  N   LEU A  87      42.581  33.880  27.012  1.00 64.38           N  
ATOM     30  CA  LEU A  87      42.882  34.911  26.030  1.00 64.42           C  
ATOM     31  C   LEU A  87      42.264  36.235  26.474  1.00 65.06           C  
ATOM     32  O   LEU A  87      41.066  36.368  26.614  1.00 63.10           O  
ATOM     33  CB  LEU A  87      42.353  34.532  24.644  1.00 64.61           C  
ATOM     34  CG  LEU A  87      43.224  33.921  23.535  1.00 65.21           C  
ATOM     35  CD1 LEU A  87      44.300  34.900  23.035  1.00 65.99           C  
ATOM     36  CD2 LEU A  87      43.827  32.559  23.907  1.00 64.80           C  
ATOM     37  N   TYR A  88      43.107  37.221  26.701  1.00 66.56           N  
ATOM     38  CA  TYR A  88      42.643  38.503  27.158  1.00 68.40           C  
ATOM     39  C   TYR A  88      42.279  39.304  25.937  1.00 69.15           C  
ATOM     40  O   TYR A  88      43.086  39.449  25.030  1.00 69.46           O  
ATOM     41  CB  TYR A  88      43.753  39.178  27.966  1.00 69.32           C  
ATOM     42  CG  TYR A  88      44.498  38.183  28.851  1.00 71.17           C  
ATOM     43  CD1 TYR A  88      45.724  37.629  28.437  1.00 72.88           C  
ATOM     44  CD2 TYR A  88      43.957  37.758  30.080  1.00 72.02           C  
ATOM     45  CE1 TYR A  88      46.404  36.697  29.241  1.00 73.70           C  
ATOM     46  CE2 TYR A  88      44.630  36.822  30.890  1.00 72.81           C  
ATOM     47  CZ  TYR A  88      45.849  36.300  30.462  1.00 72.12           C  
ATOM     48  OH  TYR A  88      46.515  35.382  31.242  1.00 72.27           O  
ATOM     49  N   PHE A  89      41.050  39.789  25.881  1.00 70.15           N  
ATOM     50  CA  PHE A  89      40.700  40.749  24.859  1.00 71.54           C  
ATOM     51  C   PHE A  89      40.932  42.179  25.311  1.00 72.24           C  
ATOM     52  O   PHE A  89      40.893  42.471  26.515  1.00 72.41           O  
ATOM     53  CB  PHE A  89      39.264  40.590  24.438  1.00 71.93           C  
ATOM     54  CG  PHE A  89      39.063  39.544  23.426  1.00 72.81           C  
ATOM     55  CD1 PHE A  89      37.917  38.757  23.451  1.00 73.53           C  
ATOM     56  CD2 PHE A  89      40.018  39.337  22.435  1.00 74.03           C  
ATOM     57  CE1 PHE A  89      37.709  37.791  22.492  1.00 73.96           C  
ATOM     58  CE2 PHE A  89      39.833  38.370  21.474  1.00 74.93           C  
ATOM     59  CZ  PHE A  89      38.672  37.589  21.505  1.00 75.19           C  
ATOM     60  N   GLN A  90      41.136  43.052  24.317  1.00 72.94           N  
ATOM     61  CA  GLN A  90      41.529  44.463  24.492  1.00 73.82           C  
ATOM     62  C   GLN A  90      42.978  44.588  24.983  1.00 73.83           C  
ATOM     63  O   GLN A  90      43.851  43.789  24.620  1.00 73.82           O  
ATOM     64  CB  GLN A  90      40.567  45.243  25.417  1.00 73.90           C  
ATOM     65  CG  GLN A  90      39.083  45.259  24.985  1.00 74.36           C  
ATOM     66  CD  GLN A  90      38.211  46.209  25.816  1.00 74.73           C  
ATOM     67  OE1 GLN A  90      36.976  46.181  25.732  1.00 76.02           O  
ATOM     68  NE2 GLN A  90      38.852  47.060  26.611  1.00 74.44           N  
ATOM     69  N   HIS A 101      54.477  29.164  18.433  1.00 46.41           N  
ATOM     70  CA  HIS A 101      54.190  29.678  17.093  1.00 45.91           C  
ATOM     71  C   HIS A 101      55.013  29.005  16.000  1.00 44.24           C  
ATOM     72  O   HIS A 101      56.195  29.292  15.848  1.00 45.81           O  
ATOM     73  CB  HIS A 101      54.447  31.178  17.032  1.00 46.77           C  
ATOM     74  CG  HIS A 101      53.228  32.018  16.788  1.00 49.46           C  
ATOM     75  ND1 HIS A 101      53.180  33.359  17.120  1.00 52.12           N  
ATOM     76  CD2 HIS A 101      52.030  31.730  16.219  1.00 51.56           C  
ATOM     77  CE1 HIS A 101      51.999  33.853  16.784  1.00 52.59           C  
ATOM     78  NE2 HIS A 101      51.284  32.885  16.234  1.00 52.29           N  
ATOM     79  N   HIS A 102      54.347  28.169  15.215  1.00 40.81           N  
ATOM     80  CA  HIS A 102      54.907  27.405  14.131  1.00 38.04           C  
ATOM     81  C   HIS A 102      54.308  27.911  12.816  1.00 35.37           C  
ATOM     82  O   HIS A 102      53.111  28.141  12.761  1.00 33.51           O  
ATOM     83  CB  HIS A 102      54.494  25.958  14.371  1.00 38.88           C  
ATOM     84  CG  HIS A 102      54.744  25.040  13.217  1.00 42.71           C  
ATOM     85  ND1 HIS A 102      55.962  24.956  12.566  1.00 44.29           N  
ATOM     86  CD2 HIS A 102      53.929  24.145  12.609  1.00 44.10           C  
ATOM     87  CE1 HIS A 102      55.881  24.065  11.597  1.00 46.92           C  
ATOM     88  NE2 HIS A 102      54.663  23.547  11.608  1.00 48.31           N  
ATOM     89  N   VAL A 103      55.128  28.097  11.775  1.00 31.83           N  
ATOM     90  CA  VAL A 103      54.609  28.573  10.484  1.00 31.68           C  
ATOM     91  C   VAL A 103      54.250  27.388   9.673  1.00 31.17           C  
ATOM     92  O   VAL A 103      55.088  26.470   9.404  1.00 32.14           O  
ATOM     93  CB  VAL A 103      55.589  29.459   9.653  1.00 30.34           C  
ATOM     94  CG1 VAL A 103      54.999  29.731   8.314  1.00 31.02           C  
ATOM     95  CG2 VAL A 103      55.852  30.686  10.359  1.00 30.71           C  
ATOM     96  N   LEU A 104      52.981  27.336   9.325  1.00 31.19           N  
ATOM     97  CA  LEU A 104      52.472  26.218   8.563  1.00 31.85           C  
ATOM     98  C   LEU A 104      52.801  26.432   7.112  1.00 32.13           C  
ATOM     99  O   LEU A 104      53.357  25.534   6.471  1.00 32.16           O  
ATOM    100  CB  LEU A 104      50.941  26.130   8.685  1.00 33.56           C  
ATOM    101  CG  LEU A 104      50.353  25.467   9.895  1.00 36.00           C  
ATOM    102  CD1 LEU A 104      50.801  26.178  11.089  1.00 37.18           C  
ATOM    103  CD2 LEU A 104      48.807  25.547   9.817  1.00 34.37           C  
ATOM    104  N   SER A 105      52.434  27.605   6.573  1.00 28.26           N  
ATOM    105  CA  SER A 105      52.590  27.950   5.186  1.00 28.67           C  
ATOM    106  C   SER A 105      52.455  29.438   4.989  1.00 27.81           C  
ATOM    107  O   SER A 105      51.950  30.165   5.839  1.00 27.10           O  
ATOM    108  CB  SER A 105      51.590  27.243   4.264  1.00 29.66           C  
ATOM    109  OG  SER A 105      50.252  27.594   4.579  1.00 32.52           O  
ATOM    110  N   HIS A 106      52.969  29.863   3.854  1.00 27.85           N  
ATOM    111  CA  HIS A 106      52.808  31.176   3.365  1.00 28.38           C  
ATOM    112  C   HIS A 106      52.816  30.957   1.878  1.00 30.30           C  
ATOM    113  O   HIS A 106      53.632  30.132   1.333  1.00 31.82           O  
ATOM    114  CB  HIS A 106      53.852  32.153   3.908  1.00 27.90           C  
ATOM    115  CG  HIS A 106      55.249  31.923   3.414  1.00 33.61           C  
ATOM    116  ND1 HIS A 106      56.179  31.189   4.123  1.00 37.59           N  
ATOM    117  CD2 HIS A 106      55.890  32.372   2.309  1.00 36.64           C  
ATOM    118  CE1 HIS A 106      57.320  31.157   3.454  1.00 39.38           C  
ATOM    119  NE2 HIS A 106      57.180  31.894   2.367  1.00 40.62           N  
ATOM    120  N   ASP A 107      51.818  31.541   1.251  1.00 29.89           N  
ATOM    121  CA  ASP A 107      51.632  31.483  -0.174  1.00 29.09           C  
ATOM    122  C   ASP A 107      51.232  32.871  -0.561  1.00 27.50           C  
ATOM    123  O   ASP A 107      50.573  33.531   0.239  1.00 27.73           O  
ATOM    124  CB  ASP A 107      50.474  30.573  -0.535  1.00 30.17           C  
ATOM    125  CG  ASP A 107      50.931  29.317  -1.128  1.00 37.32           C  
ATOM    126  OD1 ASP A 107      51.289  28.428  -0.337  1.00 39.53           O  
ATOM    127  OD2 ASP A 107      50.984  29.244  -2.381  1.00 46.18           O  
ATOM    128  N   ILE A 108      51.604  33.256  -1.777  1.00 27.24           N  
ATOM    129  CA  ILE A 108      51.097  34.489  -2.390  1.00 26.70           C  
ATOM    130  C   ILE A 108      49.896  34.139  -3.211  1.00 27.51           C  
ATOM    131  O   ILE A 108      49.951  33.262  -4.144  1.00 25.36           O  
ATOM    132  CB  ILE A 108      52.171  35.205  -3.193  1.00 27.76           C  
ATOM    133  CG1 ILE A 108      53.230  35.680  -2.238  1.00 27.86           C  
ATOM    134  CG2 ILE A 108      51.537  36.409  -3.911  1.00 28.61           C  
ATOM    135  CD1 ILE A 108      54.546  36.113  -2.952  1.00 31.68           C  
ATOM    136  N   ILE A 109      48.762  34.750  -2.883  1.00 25.35           N  
ATOM    137  CA  ILE A 109      47.519  34.432  -3.586  1.00 25.31           C  
ATOM    138  C   ILE A 109      46.741  35.691  -3.946  1.00 26.07           C  
ATOM    139  O   ILE A 109      46.949  36.741  -3.312  1.00 24.06           O  
ATOM    140  CB  ILE A 109      46.566  33.519  -2.719  1.00 25.29           C  
ATOM    141  CG1 ILE A 109      46.035  34.295  -1.482  1.00 27.30           C  
ATOM    142  CG2 ILE A 109      47.295  32.199  -2.263  1.00 28.56           C  
ATOM    143  CD1 ILE A 109      44.931  33.549  -0.638  1.00 25.82           C  
ATOM    144  N   PRO A 110      45.793  35.579  -4.897  1.00 26.58           N  
ATOM    145  CA  PRO A 110      44.900  36.709  -5.131  1.00 26.45           C  
ATOM    146  C   PRO A 110      43.946  36.939  -3.929  1.00 27.15           C  
ATOM    147  O   PRO A 110      43.414  35.971  -3.373  1.00 23.64           O  
ATOM    148  CB  PRO A 110      44.117  36.335  -6.418  1.00 25.70           C  
ATOM    149  CG  PRO A 110      44.815  35.065  -6.987  1.00 29.46           C  
ATOM    150  CD  PRO A 110      45.508  34.421  -5.790  1.00 27.72           C  
ATOM    151  N   ALA A 111      43.736  38.203  -3.552  1.00 25.24           N  
ATOM    152  CA  ALA A 111      42.755  38.543  -2.502  1.00 25.62           C  
ATOM    153  C   ALA A 111      41.317  38.166  -2.863  1.00 26.27           C  
ATOM    154  O   ALA A 111      40.831  38.508  -3.941  1.00 25.41           O  
ATOM    155  CB  ALA A 111      42.884  40.085  -2.095  1.00 25.20           C  
ATOM    156  N   SER A 112      40.669  37.422  -1.975  1.00 24.44           N  
ATOM    157  CA  SER A 112      39.236  37.146  -2.102  1.00 26.44           C  
ATOM    158  C   SER A 112      38.437  38.416  -1.921  1.00 27.88           C  
ATOM    159  O   SER A 112      39.000  39.459  -1.476  1.00 26.11           O  
ATOM    160  CB  SER A 112      38.822  36.131  -1.040  1.00 27.31           C  
ATOM    161  OG  SER A 112      38.993  36.648   0.284  1.00 29.06           O  
ATOM    162  N   LYS A 113      37.124  38.354  -2.214  1.00 28.86           N  
ATOM    163  CA  LYS A 113      36.266  39.545  -1.998  1.00 29.37           C  
ATOM    164  C   LYS A 113      36.291  40.049  -0.561  1.00 27.12           C  
ATOM    165  O   LYS A 113      36.520  41.250  -0.335  1.00 26.06           O  
ATOM    166  CB  LYS A 113      34.825  39.360  -2.517  1.00 31.01           C  
ATOM    167  CG  LYS A 113      34.749  39.281  -4.070  1.00 34.48           C  
ATOM    168  CD  LYS A 113      33.334  39.217  -4.617  1.00 33.69           C  
ATOM    169  CE  LYS A 113      33.296  39.465  -6.170  1.00 37.74           C  
ATOM    170  NZ  LYS A 113      31.875  39.248  -6.760  1.00 42.64           N  
ATOM    171  N   PRO A 114      36.040  39.164   0.421  1.00 24.68           N  
ATOM    172  CA  PRO A 114      36.102  39.634   1.797  1.00 24.65           C  
ATOM    173  C   PRO A 114      37.456  40.131   2.231  1.00 23.49           C  
ATOM    174  O   PRO A 114      37.558  41.088   3.017  1.00 25.05           O  
ATOM    175  CB  PRO A 114      35.751  38.378   2.637  1.00 25.67           C  
ATOM    176  CG  PRO A 114      35.605  37.279   1.724  1.00 24.91           C  
ATOM    177  CD  PRO A 114      35.621  37.745   0.317  1.00 25.13           C  
ATOM    178  N   ILE A 115      38.507  39.495   1.771  1.00 21.89           N  
ATOM    179  CA  ILE A 115      39.864  39.972   2.158  1.00 22.20           C  
ATOM    180  C   ILE A 115      40.116  41.337   1.465  1.00 22.93           C  
ATOM    181  O   ILE A 115      40.638  42.280   2.106  1.00 21.93           O  
ATOM    182  CB  ILE A 115      40.939  38.961   1.765  1.00 23.34           C  
ATOM    183  CG1 ILE A 115      40.835  37.679   2.636  1.00 23.95           C  
ATOM    184  CG2 ILE A 115      42.433  39.572   1.867  1.00 19.94           C  
ATOM    185  CD1 ILE A 115      40.771  37.939   4.133  1.00 33.64           C  
ATOM    186  N   ALA A 116      39.812  41.443   0.176  1.00 20.57           N  
ATOM    187  CA  ALA A 116      40.018  42.765  -0.455  1.00 23.19           C  
ATOM    188  C   ALA A 116      39.171  43.893   0.156  1.00 23.94           C  
ATOM    189  O   ALA A 116      39.627  45.057   0.262  1.00 25.16           O  
ATOM    190  CB  ALA A 116      39.832  42.708  -2.012  1.00 21.86           C  
ATOM    191  N   GLU A 117      37.971  43.559   0.604  1.00 25.79           N  
ATOM    192  CA  GLU A 117      37.082  44.507   1.274  1.00 28.83           C  
ATOM    193  C   GLU A 117      37.657  44.975   2.605  1.00 26.68           C  
ATOM    194  O   GLU A 117      37.724  46.192   2.857  1.00 28.30           O  
ATOM    195  CB  GLU A 117      35.666  43.926   1.474  1.00 30.07           C  
ATOM    196  CG  GLU A 117      34.779  44.173   0.251  1.00 35.69           C  
ATOM    197  CD  GLU A 117      33.279  43.775   0.437  1.00 37.64           C  
ATOM    198  OE1 GLU A 117      32.782  43.874   1.609  1.00 47.66           O  
ATOM    199  OE2 GLU A 117      32.633  43.384  -0.595  1.00 46.55           O  
ATOM    200  N   LYS A 118      38.151  44.037   3.402  1.00 24.11           N  
ATOM    201  CA  LYS A 118      38.785  44.379   4.670  1.00 24.55           C  
ATOM    202  C   LYS A 118      40.052  45.256   4.485  1.00 24.02           C  
ATOM    203  O   LYS A 118      40.306  46.204   5.303  1.00 23.03           O  
ATOM    204  CB  LYS A 118      39.234  43.089   5.416  1.00 26.97           C  
ATOM    205  CG  LYS A 118      38.448  42.831   6.691  1.00 31.72           C  
ATOM    206  CD  LYS A 118      37.975  41.413   6.839  1.00 36.95           C  
ATOM    207  CE  LYS A 118      39.071  40.401   7.008  1.00 40.26           C  
ATOM    208  NZ  LYS A 118      39.710  40.514   8.390  1.00 43.91           N  
ATOM    209  N   LEU A 119      40.846  44.899   3.489  1.00 19.07           N  
ATOM    210  CA  LEU A 119      42.156  45.579   3.306  1.00 21.46           C  
ATOM    211  C   LEU A 119      42.058  46.861   2.453  1.00 21.31           C  
ATOM    212  O   LEU A 119      43.084  47.568   2.270  1.00 21.76           O  
ATOM    213  CB  LEU A 119      43.234  44.634   2.709  1.00 21.15           C  
ATOM    214  CG  LEU A 119      43.568  43.456   3.664  1.00 23.32           C  
ATOM    215  CD1 LEU A 119      44.536  42.406   2.933  1.00 27.23           C  
ATOM    216  CD2 LEU A 119      44.195  44.043   4.967  1.00 27.95           C  
ATOM    217  N   GLN A 120      40.876  47.090   1.906  1.00 19.31           N  
ATOM    218  CA  GLN A 120      40.528  48.218   1.030  1.00 20.63           C  
ATOM    219  C   GLN A 120      41.558  48.292  -0.154  1.00 20.84           C  
ATOM    220  O   GLN A 120      42.230  49.341  -0.392  1.00 21.13           O  
ATOM    221  CB  GLN A 120      40.592  49.535   1.813  1.00 21.46           C  
ATOM    222  CG  GLN A 120      39.513  49.684   2.918  1.00 26.11           C  
ATOM    223  CD  GLN A 120      38.148  50.193   2.442  1.00 33.10           C  
ATOM    224  OE1 GLN A 120      37.869  50.225   1.222  1.00 29.96           O  
ATOM    225  NE2 GLN A 120      37.299  50.684   3.413  1.00 33.42           N  
ATOM    226  N   ILE A 121      41.681  47.171  -0.841  1.00 19.38           N  
ATOM    227  CA  ILE A 121      42.537  47.051  -2.011  1.00 19.81           C  
ATOM    228  C   ILE A 121      41.724  46.539  -3.190  1.00 19.45           C  
ATOM    229  O   ILE A 121      40.615  46.104  -3.032  1.00 19.97           O  
ATOM    230  CB  ILE A 121      43.725  46.180  -1.761  1.00 18.67           C  
ATOM    231  CG1 ILE A 121      43.306  44.731  -1.458  1.00 18.96           C  
ATOM    232  CG2 ILE A 121      44.613  46.810  -0.700  1.00 19.61           C  
ATOM    233  CD1 ILE A 121      44.391  43.814  -0.763  1.00 20.94           C  
ATOM    234  N   GLN A 122      42.324  46.589  -4.368  1.00 20.34           N  
ATOM    235  CA  GLN A 122      41.660  46.088  -5.606  1.00 21.78           C  
ATOM    236  C   GLN A 122      41.266  44.609  -5.572  1.00 22.58           C  
ATOM    237  O   GLN A 122      41.937  43.794  -4.885  1.00 22.80           O  
ATOM    238  CB  GLN A 122      42.643  46.224  -6.770  1.00 23.42           C  
ATOM    239  CG  GLN A 122      43.156  47.680  -7.011  1.00 22.13           C  
ATOM    240  CD  GLN A 122      43.967  47.773  -8.292  1.00 22.38           C  
ATOM    241  OE1 GLN A 122      44.222  46.756  -8.938  1.00 22.94           O  
ATOM    242  NE2 GLN A 122      44.408  48.998  -8.664  1.00 19.59           N  
ATOM    243  N   PRO A 123      40.172  44.255  -6.308  1.00 23.45           N  
ATOM    244  CA  PRO A 123      39.896  42.813  -6.323  1.00 23.84           C  
ATOM    245  C   PRO A 123      41.133  42.072  -6.817  1.00 23.13           C  
ATOM    246  O   PRO A 123      41.908  42.606  -7.638  1.00 24.99           O  
ATOM    247  CB  PRO A 123      38.774  42.682  -7.368  1.00 24.82           C  
ATOM    248  CG  PRO A 123      37.993  43.956  -7.296  1.00 26.11           C  
ATOM    249  CD  PRO A 123      39.173  45.026  -7.101  1.00 24.37           C  
ATOM    250  N   GLU A 124      41.323  40.844  -6.324  1.00 23.96           N  
ATOM    251  CA  GLU A 124      42.405  39.932  -6.730  1.00 24.90           C  
ATOM    252  C   GLU A 124      43.823  40.469  -6.529  1.00 25.11           C  
ATOM    253  O   GLU A 124      44.800  39.950  -7.126  1.00 23.65           O  
ATOM    254  CB  GLU A 124      42.302  39.436  -8.199  1.00 26.85           C  
ATOM    255  CG  GLU A 124      41.006  39.486  -8.923  1.00 33.73           C  
ATOM    256  CD  GLU A 124      39.886  38.803  -8.213  1.00 44.02           C  
ATOM    257  OE1 GLU A 124      40.138  37.928  -7.343  1.00 48.89           O  
ATOM    258  OE2 GLU A 124      38.720  39.158  -8.548  1.00 48.83           O  
ATOM    259  N   SER A 125      43.961  41.477  -5.676  1.00 22.15           N  
ATOM    260  CA  SER A 125      45.315  41.963  -5.358  1.00 22.02           C  
ATOM    261  C   SER A 125      46.101  40.872  -4.703  1.00 21.73           C  
ATOM    262  O   SER A 125      45.535  40.102  -3.907  1.00 21.75           O  
ATOM    263  CB  SER A 125      45.268  43.145  -4.351  1.00 21.79           C  
ATOM    264  OG  SER A 125      44.449  44.164  -4.905  1.00 23.80           O  
ATOM    265  N   PRO A 126      47.421  40.835  -4.974  1.00 21.58           N  
ATOM    266  CA  PRO A 126      48.301  39.826  -4.342  1.00 21.26           C  
ATOM    267  C   PRO A 126      48.400  40.020  -2.846  1.00 21.80           C  
ATOM    268  O   PRO A 126      48.762  41.098  -2.347  1.00 20.20           O  
ATOM    269  CB  PRO A 126      49.665  40.059  -5.009  1.00 22.41           C  
ATOM    270  CG  PRO A 126      49.639  41.606  -5.348  1.00 21.17           C  
ATOM    271  CD  PRO A 126      48.170  41.684  -5.921  1.00 23.43           C  
ATOM    272  N   VAL A 127      48.138  38.937  -2.117  1.00 20.59           N  
ATOM    273  CA  VAL A 127      48.325  39.000  -0.687  1.00 20.39           C  
ATOM    274  C   VAL A 127      49.155  37.838  -0.211  1.00 21.39           C  
ATOM    275  O   VAL A 127      49.176  36.811  -0.882  1.00 23.60           O  
ATOM    276  CB  VAL A 127      46.945  39.046   0.086  1.00 21.21           C  
ATOM    277  CG1 VAL A 127      46.152  40.327  -0.217  1.00 20.78           C  
ATOM    278  CG2 VAL A 127      46.169  37.801  -0.198  1.00 21.03           C  
ATOM    279  N   VAL A 128      49.887  38.006   0.872  1.00 18.54           N  
ATOM    280  CA  VAL A 128      50.598  36.870   1.431  1.00 22.99           C  
ATOM    281  C   VAL A 128      49.634  36.229   2.447  1.00 22.35           C  
ATOM    282  O   VAL A 128      49.164  36.924   3.344  1.00 22.99           O  
ATOM    283  CB  VAL A 128      51.884  37.335   2.163  1.00 23.13           C  
ATOM    284  CG1 VAL A 128      52.519  36.206   2.879  1.00 26.52           C  
ATOM    285  CG2 VAL A 128      52.833  37.929   1.136  1.00 24.64           C  
ATOM    286  N   GLU A 129      49.326  34.930   2.284  1.00 23.19           N  
ATOM    287  CA  GLU A 129      48.448  34.193   3.245  1.00 22.17           C  
ATOM    288  C   GLU A 129      49.312  33.416   4.205  1.00 24.36           C  
ATOM    289  O   GLU A 129      49.931  32.430   3.817  1.00 25.89           O  
ATOM    290  CB  GLU A 129      47.473  33.296   2.472  1.00 24.00           C  
ATOM    291  CG  GLU A 129      46.476  32.551   3.410  1.00 25.88           C  
ATOM    292  CD  GLU A 129      45.383  31.865   2.629  1.00 30.36           C  
ATOM    293  OE1 GLU A 129      45.737  30.821   2.081  1.00 32.77           O  
ATOM    294  OE2 GLU A 129      44.249  32.402   2.474  1.00 32.66           O  
ATOM    295  N   LEU A 130      49.458  33.921   5.422  1.00 22.52           N  
ATOM    296  CA  LEU A 130      50.351  33.337   6.349  1.00 22.90           C  
ATOM    297  C   LEU A 130      49.484  32.502   7.275  1.00 21.62           C  
ATOM    298  O   LEU A 130      48.586  33.021   7.935  1.00 22.06           O  
ATOM    299  CB  LEU A 130      51.059  34.433   7.139  1.00 22.22           C  
ATOM    300  CG  LEU A 130      51.761  33.989   8.428  1.00 24.22           C  
ATOM    301  CD1 LEU A 130      52.903  33.101   8.041  1.00 23.32           C  
ATOM    302  CD2 LEU A 130      52.255  35.101   9.338  1.00 25.21           C  
ATOM    303  N   LYS A 131      49.804  31.221   7.360  1.00 23.08           N  
ATOM    304  CA  LYS A 131      49.135  30.291   8.324  1.00 23.85           C  
ATOM    305  C   LYS A 131      50.096  29.847   9.447  1.00 24.46           C  
ATOM    306  O   LYS A 131      51.244  29.412   9.220  1.00 24.22           O  
ATOM    307  CB  LYS A 131      48.551  29.082   7.600  1.00 22.28           C  
ATOM    308  CG  LYS A 131      47.541  29.498   6.564  1.00 26.58           C  
ATOM    309  CD  LYS A 131      46.884  28.274   5.902  1.00 27.40           C  
ATOM    310  CE  LYS A 131      45.669  28.678   5.067  1.00 32.81           C  
ATOM    311  NZ  LYS A 131      45.348  27.502   4.184  1.00 38.78           N  
ATOM    312  N   ARG A 132      49.651  30.048  10.677  1.00 22.22           N  
ATOM    313  CA  ARG A 132      50.449  29.664  11.804  1.00 24.70           C  
ATOM    314  C   ARG A 132      49.617  28.959  12.866  1.00 25.85           C  
ATOM    315  O   ARG A 132      48.455  29.224  12.987  1.00 24.58           O  
ATOM    316  CB  ARG A 132      51.084  30.882  12.424  1.00 23.77           C  
ATOM    317  CG  ARG A 132      52.081  31.639  11.436  1.00 27.26           C  
ATOM    318  CD  ARG A 132      52.945  32.755  12.137  1.00 28.58           C  
ATOM    319  NE  ARG A 132      52.114  33.811  12.722  1.00 34.82           N  
ATOM    320  CZ  ARG A 132      52.566  34.904  13.370  1.00 36.19           C  
ATOM    321  NH1 ARG A 132      53.878  35.154  13.525  1.00 34.44           N  
ATOM    322  NH2 ARG A 132      51.689  35.794  13.869  1.00 38.38           N  
ATOM    323  N   ILE A 133      50.270  28.140  13.675  1.00 27.04           N  
ATOM    324  CA  ILE A 133      49.582  27.519  14.833  1.00 28.56           C  
ATOM    325  C   ILE A 133      50.287  27.974  16.053  1.00 28.49           C  
ATOM    326  O   ILE A 133      51.521  27.980  16.089  1.00 29.98           O  
ATOM    327  CB  ILE A 133      49.582  25.970  14.746  1.00 29.63           C  
ATOM    328  CG1 ILE A 133      48.926  25.553  13.444  1.00 30.44           C  
ATOM    329  CG2 ILE A 133      48.658  25.327  15.854  1.00 28.55           C  
ATOM    330  CD1 ILE A 133      49.008  24.029  13.132  1.00 32.14           C  
ATOM    331  N   LEU A 134      49.523  28.393  17.060  1.00 30.29           N  
ATOM    332  CA  LEU A 134      50.087  28.621  18.367  1.00 33.03           C  
ATOM    333  C   LEU A 134      49.668  27.474  19.306  1.00 33.91           C  
ATOM    334  O   LEU A 134      48.495  27.138  19.387  1.00 31.07           O  
ATOM    335  CB  LEU A 134      49.655  30.017  18.823  1.00 33.23           C  
ATOM    336  CG  LEU A 134      50.006  30.595  20.201  1.00 39.17           C  
ATOM    337  CD1 LEU A 134      51.519  30.588  20.467  1.00 43.52           C  
ATOM    338  CD2 LEU A 134      49.432  32.075  20.324  1.00 36.36           C  
ATOM    339  N   TYR A 135      50.631  26.890  20.018  1.00 37.06           N  
ATOM    340  CA  TYR A 135      50.400  25.697  20.827  1.00 41.78           C  
ATOM    341  C   TYR A 135      50.371  26.091  22.338  1.00 44.71           C  
ATOM    342  O   TYR A 135      51.117  26.970  22.777  1.00 45.83           O  
ATOM    343  CB  TYR A 135      51.459  24.592  20.544  1.00 41.19           C  
ATOM    344  CG  TYR A 135      51.306  23.852  19.239  1.00 42.62           C  
ATOM    345  CD1 TYR A 135      50.546  22.683  19.141  1.00 43.90           C  
ATOM    346  CD2 TYR A 135      51.950  24.313  18.070  1.00 42.01           C  
ATOM    347  CE1 TYR A 135      50.381  22.014  17.881  1.00 42.37           C  
ATOM    348  CE2 TYR A 135      51.800  23.672  16.842  1.00 42.99           C  
ATOM    349  CZ  TYR A 135      51.019  22.534  16.742  1.00 44.46           C  
ATOM    350  OH  TYR A 135      50.900  21.917  15.508  1.00 45.60           O  
ATOM    351  N   ASN A 136      49.497  25.466  23.116  1.00 47.48           N  
ATOM    352  CA  ASN A 136      49.469  25.713  24.563  1.00 50.44           C  
ATOM    353  C   ASN A 136      50.670  24.950  25.123  1.00 51.80           C  
ATOM    354  O   ASN A 136      51.748  25.551  25.357  1.00 53.07           O  
ATOM    355  CB  ASN A 136      48.088  25.344  25.148  1.00 50.19           C  
ATOM    356  CG  ASN A 136      48.123  24.962  26.608  1.00 52.70           C  
ATOM    357  OD1 ASN A 136      49.149  25.072  27.286  1.00 58.84           O  
ATOM    358  ND2 ASN A 136      46.991  24.470  27.101  1.00 54.09           N  
ATOM    359  N   ASP A 137      50.543  23.634  25.276  1.00 52.59           N  
ATOM    360  CA  ASP A 137      51.761  22.846  25.413  1.00 52.36           C  
ATOM    361  C   ASP A 137      52.032  22.114  24.110  1.00 51.73           C  
ATOM    362  O   ASP A 137      52.732  22.631  23.229  1.00 51.75           O  
ATOM    363  CB  ASP A 137      51.716  21.894  26.604  1.00 53.21           C  
ATOM    364  CG  ASP A 137      50.403  21.169  26.724  1.00 54.66           C  
ATOM    365  OD1 ASP A 137      50.227  20.157  25.997  1.00 54.99           O  
ATOM    366  OD2 ASP A 137      49.570  21.611  27.574  1.00 56.40           O  
ATOM    367  N   ASP A 138      51.480  20.914  24.004  1.00 49.92           N  
ATOM    368  CA  ASP A 138      51.444  20.163  22.778  1.00 48.76           C  
ATOM    369  C   ASP A 138      50.031  20.289  22.214  1.00 45.96           C  
ATOM    370  O   ASP A 138      49.715  19.720  21.182  1.00 45.69           O  
ATOM    371  CB  ASP A 138      51.760  18.694  23.091  1.00 50.41           C  
ATOM    372  CG  ASP A 138      53.189  18.492  23.596  1.00 54.37           C  
ATOM    373  OD1 ASP A 138      54.121  18.711  22.793  1.00 57.57           O  
ATOM    374  OD2 ASP A 138      53.371  18.099  24.782  1.00 60.05           O  
ATOM    375  N   GLN A 139      49.194  21.048  22.921  1.00 43.13           N  
ATOM    376  CA  GLN A 139      47.809  21.285  22.532  1.00 38.80           C  
ATOM    377  C   GLN A 139      47.697  22.511  21.604  1.00 36.58           C  
ATOM    378  O   GLN A 139      48.165  23.586  21.971  1.00 33.98           O  
ATOM    379  CB  GLN A 139      46.963  21.517  23.782  1.00 39.43           C  
ATOM    380  CG  GLN A 139      45.569  22.023  23.454  1.00 40.74           C  
ATOM    381  CD  GLN A 139      44.688  22.189  24.676  1.00 43.75           C  
ATOM    382  OE1 GLN A 139      43.899  21.300  25.013  1.00 41.89           O  
ATOM    383  NE2 GLN A 139      44.802  23.331  25.328  1.00 42.99           N  
ATOM    384  N   PRO A 140      47.101  22.334  20.402  1.00 35.38           N  
ATOM    385  CA  PRO A 140      46.926  23.477  19.479  1.00 34.39           C  
ATOM    386  C   PRO A 140      45.980  24.444  20.115  1.00 33.16           C  
ATOM    387  O   PRO A 140      44.858  24.037  20.489  1.00 33.83           O  
ATOM    388  CB  PRO A 140      46.244  22.841  18.250  1.00 34.90           C  
ATOM    389  CG  PRO A 140      46.594  21.383  18.310  1.00 34.87           C  
ATOM    390  CD  PRO A 140      46.644  21.067  19.779  1.00 36.66           C  
ATOM    391  N   LEU A 141      46.389  25.702  20.270  1.00 29.55           N  
ATOM    392  CA  LEU A 141      45.491  26.652  20.948  1.00 29.64           C  
ATOM    393  C   LEU A 141      44.872  27.663  19.962  1.00 29.04           C  
ATOM    394  O   LEU A 141      43.707  28.046  20.099  1.00 27.72           O  
ATOM    395  CB  LEU A 141      46.217  27.336  22.124  1.00 30.87           C  
ATOM    396  CG  LEU A 141      45.703  28.678  22.625  1.00 33.93           C  
ATOM    397  CD1 LEU A 141      45.645  28.736  24.132  1.00 41.25           C  
ATOM    398  CD2 LEU A 141      46.680  29.807  22.060  1.00 39.12           C  
ATOM    399  N   THR A 142      45.670  28.090  18.963  1.00 27.99           N  
ATOM    400  CA  THR A 142      45.126  29.036  17.967  1.00 27.53           C  
ATOM    401  C   THR A 142      45.681  28.699  16.632  1.00 27.10           C  
ATOM    402  O   THR A 142      46.912  28.547  16.484  1.00 29.05           O  
ATOM    403  CB  THR A 142      45.540  30.474  18.246  1.00 28.16           C  
ATOM    404  OG1 THR A 142      45.204  30.801  19.592  1.00 32.69           O  
ATOM    405  CG2 THR A 142      44.816  31.425  17.322  1.00 23.40           C  
ATOM    406  N   PHE A 143      44.774  28.577  15.662  1.00 25.26           N  
ATOM    407  CA  PHE A 143      45.132  28.460  14.265  1.00 22.93           C  
ATOM    408  C   PHE A 143      44.846  29.848  13.621  1.00 23.58           C  
ATOM    409  O   PHE A 143      43.737  30.367  13.685  1.00 21.44           O  
ATOM    410  CB  PHE A 143      44.381  27.270  13.599  1.00 24.89           C  
ATOM    411  CG  PHE A 143      44.418  27.272  12.121  1.00 23.85           C  
ATOM    412  CD1 PHE A 143      45.609  27.395  11.421  1.00 27.77           C  
ATOM    413  CD2 PHE A 143      43.211  27.132  11.387  1.00 27.55           C  
ATOM    414  CE1 PHE A 143      45.582  27.378  10.000  1.00 30.82           C  
ATOM    415  CE2 PHE A 143      43.173  27.184   9.986  1.00 28.65           C  
ATOM    416  CZ  PHE A 143      44.390  27.276   9.292  1.00 29.83           C  
ATOM    417  N   GLU A 144      45.916  30.456  13.115  1.00 22.26           N  
ATOM    418  CA  GLU A 144      45.848  31.855  12.657  1.00 23.48           C  
ATOM    419  C   GLU A 144      45.983  31.846  11.123  1.00 21.80           C  
ATOM    420  O   GLU A 144      46.855  31.139  10.506  1.00 22.05           O  
ATOM    421  CB  GLU A 144      46.967  32.662  13.290  1.00 24.47           C  
ATOM    422  CG  GLU A 144      47.105  34.116  12.752  1.00 22.12           C  
ATOM    423  CD  GLU A 144      48.422  34.788  13.130  1.00 30.56           C  
ATOM    424  OE1 GLU A 144      49.076  34.389  14.121  1.00 34.67           O  
ATOM    425  OE2 GLU A 144      48.791  35.757  12.432  1.00 29.43           O  
ATOM    426  N   VAL A 145      45.146  32.621  10.447  1.00 20.73           N  
ATOM    427  CA  VAL A 145      45.395  32.804   9.002  1.00 19.72           C  
ATOM    428  C   VAL A 145      45.392  34.358   8.874  1.00 20.04           C  
ATOM    429  O   VAL A 145      44.370  34.946   9.140  1.00 18.00           O  
ATOM    430  CB  VAL A 145      44.300  32.236   8.111  1.00 21.11           C  
ATOM    431  CG1 VAL A 145      44.575  32.534   6.617  1.00 23.05           C  
ATOM    432  CG2 VAL A 145      44.135  30.680   8.375  1.00 21.45           C  
ATOM    433  N   THR A 146      46.524  34.949   8.468  1.00 20.00           N  
ATOM    434  CA  THR A 146      46.617  36.423   8.316  1.00 21.54           C  
ATOM    435  C   THR A 146      47.002  36.779   6.874  1.00 20.55           C  
ATOM    436  O   THR A 146      47.813  36.029   6.248  1.00 22.78           O  
ATOM    437  CB  THR A 146      47.643  36.876   9.325  1.00 23.72           C  
ATOM    438  OG1 THR A 146      47.128  36.622  10.665  1.00 26.22           O  
ATOM    439  CG2 THR A 146      48.100  38.351   9.155  1.00 24.63           C  
ATOM    440  N   HIS A 147      46.463  37.892   6.377  1.00 18.81           N  
ATOM    441  CA  HIS A 147      46.745  38.276   4.974  1.00 21.69           C  
ATOM    442  C   HIS A 147      47.382  39.649   5.023  1.00 20.38           C  
ATOM    443  O   HIS A 147      46.890  40.521   5.713  1.00 18.57           O  
ATOM    444  CB  HIS A 147      45.460  38.392   4.142  1.00 21.77           C  
ATOM    445  CG  HIS A 147      44.792  37.059   3.925  1.00 25.28           C  
ATOM    446  ND1 HIS A 147      44.000  36.473   4.890  1.00 26.43           N  
ATOM    447  CD2 HIS A 147      44.885  36.161   2.914  1.00 28.06           C  
ATOM    448  CE1 HIS A 147      43.573  35.286   4.460  1.00 25.59           C  
ATOM    449  NE2 HIS A 147      44.079  35.079   3.249  1.00 24.48           N  
ATOM    450  N   TYR A 148      48.489  39.768   4.285  1.00 21.56           N  
ATOM    451  CA  TYR A 148      49.246  41.017   4.173  1.00 22.74           C  
ATOM    452  C   TYR A 148      49.208  41.433   2.719  1.00 21.47           C  
ATOM    453  O   TYR A 148      49.548  40.676   1.877  1.00 21.34           O  
ATOM    454  CB  TYR A 148      50.749  40.823   4.573  1.00 22.56           C  
ATOM    455  CG  TYR A 148      50.952  40.408   5.989  1.00 23.58           C  
ATOM    456  CD1 TYR A 148      50.936  41.327   7.038  1.00 21.94           C  
ATOM    457  CD2 TYR A 148      51.095  39.036   6.298  1.00 23.78           C  
ATOM    458  CE1 TYR A 148      51.163  40.890   8.378  1.00 24.84           C  
ATOM    459  CE2 TYR A 148      51.298  38.611   7.594  1.00 24.72           C  
ATOM    460  CZ  TYR A 148      51.275  39.533   8.619  1.00 23.29           C  
ATOM    461  OH  TYR A 148      51.448  39.101   9.897  1.00 26.72           O  
ATOM    462  N   PRO A 149      48.843  42.666   2.455  1.00 22.20           N  
ATOM    463  CA  PRO A 149      48.813  43.109   1.070  1.00 23.42           C  
ATOM    464  C   PRO A 149      50.242  43.371   0.568  1.00 22.83           C  
ATOM    465  O   PRO A 149      50.923  44.192   1.117  1.00 21.85           O  
ATOM    466  CB  PRO A 149      48.028  44.377   1.123  1.00 22.02           C  
ATOM    467  CG  PRO A 149      48.100  44.846   2.600  1.00 26.01           C  
ATOM    468  CD  PRO A 149      48.373  43.637   3.426  1.00 21.07           C  
ATOM    469  N   LEU A 150      50.605  42.718  -0.529  1.00 22.92           N  
ATOM    470  CA  LEU A 150      51.959  42.821  -1.059  1.00 24.03           C  
ATOM    471  C   LEU A 150      52.226  44.197  -1.677  1.00 24.03           C  
ATOM    472  O   LEU A 150      53.376  44.658  -1.745  1.00 24.10           O  
ATOM    473  CB  LEU A 150      52.199  41.785  -2.137  1.00 23.71           C  
ATOM    474  CG  LEU A 150      53.024  40.508  -1.926  1.00 31.37           C  
ATOM    475  CD1 LEU A 150      54.203  40.559  -0.855  1.00 22.54           C  
ATOM    476  CD2 LEU A 150      52.109  39.236  -1.799  1.00 35.50           C  
ATOM    477  N   ASP A 151      51.167  44.868  -2.057  1.00 23.71           N  
ATOM    478  CA  ASP A 151      51.333  46.209  -2.616  1.00 25.60           C  
ATOM    479  C   ASP A 151      51.776  47.235  -1.556  1.00 26.13           C  
ATOM    480  O   ASP A 151      52.377  48.274  -1.894  1.00 27.09           O  
ATOM    481  CB  ASP A 151      50.045  46.607  -3.333  1.00 24.66           C  
ATOM    482  CG  ASP A 151      49.899  45.878  -4.730  1.00 23.90           C  
ATOM    483  OD1 ASP A 151      50.881  45.893  -5.522  1.00 25.35           O  
ATOM    484  OD2 ASP A 151      48.864  45.227  -5.049  1.00 26.46           O  
ATOM    485  N   LEU A 152      51.435  47.001  -0.283  1.00 22.54           N  
ATOM    486  CA  LEU A 152      51.844  47.914   0.763  1.00 25.46           C  
ATOM    487  C   LEU A 152      53.177  47.479   1.353  1.00 25.27           C  
ATOM    488  O   LEU A 152      53.979  48.332   1.826  1.00 24.36           O  
ATOM    489  CB  LEU A 152      50.804  47.928   1.876  1.00 25.94           C  
ATOM    490  CG  LEU A 152      49.671  48.960   1.903  1.00 33.19           C  
ATOM    491  CD1 LEU A 152      48.728  48.495   0.818  1.00 28.25           C  
ATOM    492  CD2 LEU A 152      49.032  48.926   3.348  1.00 30.72           C  
ATOM    493  N   PHE A 153      53.380  46.153   1.384  1.00 24.53           N  
ATOM    494  CA  PHE A 153      54.522  45.498   2.015  1.00 25.31           C  
ATOM    495  C   PHE A 153      55.267  44.648   1.009  1.00 25.19           C  
ATOM    496  O   PHE A 153      55.362  43.417   1.115  1.00 25.55           O  
ATOM    497  CB  PHE A 153      54.071  44.710   3.276  1.00 25.11           C  
ATOM    498  CG  PHE A 153      53.240  45.544   4.238  1.00 26.51           C  
ATOM    499  CD1 PHE A 153      53.834  46.542   4.933  1.00 28.89           C  
ATOM    500  CD2 PHE A 153      51.868  45.303   4.447  1.00 24.01           C  
ATOM    501  CE1 PHE A 153      53.108  47.381   5.821  1.00 31.90           C  
ATOM    502  CE2 PHE A 153      51.138  46.091   5.292  1.00 23.28           C  
ATOM    503  CZ  PHE A 153      51.760  47.167   5.996  1.00 26.80           C  
ATOM    504  N   PRO A 154      55.854  45.302  -0.007  1.00 26.49           N  
ATOM    505  CA  PRO A 154      56.456  44.466  -1.039  1.00 25.94           C  
ATOM    506  C   PRO A 154      57.584  43.515  -0.479  1.00 27.09           C  
ATOM    507  O   PRO A 154      58.359  43.918   0.382  1.00 25.61           O  
ATOM    508  CB  PRO A 154      56.981  45.507  -2.071  1.00 27.75           C  
ATOM    509  CG  PRO A 154      57.159  46.775  -1.257  1.00 27.36           C  
ATOM    510  CD  PRO A 154      56.011  46.742  -0.256  1.00 26.40           C  
ATOM    511  N   GLY A 155      57.582  42.249  -0.923  1.00 26.76           N  
ATOM    512  CA  GLY A 155      58.542  41.265  -0.455  1.00 27.54           C  
ATOM    513  C   GLY A 155      58.386  40.772   0.990  1.00 27.38           C  
ATOM    514  O   GLY A 155      59.300  40.156   1.527  1.00 27.35           O  
ATOM    515  N   ILE A 156      57.235  41.010   1.617  1.00 25.66           N  
ATOM    516  CA  ILE A 156      57.096  40.703   3.083  1.00 25.90           C  
ATOM    517  C   ILE A 156      57.149  39.176   3.322  1.00 24.75           C  
ATOM    518  O   ILE A 156      57.630  38.689   4.352  1.00 25.21           O  
ATOM    519  CB  ILE A 156      55.827  41.332   3.728  1.00 25.48           C  
ATOM    520  CG1 ILE A 156      55.862  41.145   5.277  1.00 24.87           C  
ATOM    521  CG2 ILE A 156      54.550  40.746   3.041  1.00 26.87           C  
ATOM    522  CD1 ILE A 156      54.981  42.197   6.034  1.00 27.28           C  
ATOM    523  N   ASP A 157      56.744  38.400   2.343  1.00 25.03           N  
ATOM    524  CA  ASP A 157      56.885  36.935   2.447  1.00 26.57           C  
ATOM    525  C   ASP A 157      58.324  36.437   2.700  1.00 28.58           C  
ATOM    526  O   ASP A 157      58.544  35.324   3.229  1.00 27.77           O  
ATOM    527  CB  ASP A 157      56.343  36.235   1.199  1.00 27.20           C  
ATOM    528  CG  ASP A 157      56.916  36.785  -0.086  1.00 29.24           C  
ATOM    529  OD1 ASP A 157      56.924  38.020  -0.281  1.00 29.00           O  
ATOM    530  OD2 ASP A 157      57.367  35.979  -0.916  1.00 35.37           O  
ATOM    531  N   THR A 158      59.301  37.225   2.255  1.00 29.07           N  
ATOM    532  CA  THR A 158      60.696  36.797   2.334  1.00 29.88           C  
ATOM    533  C   THR A 158      61.206  36.848   3.780  1.00 29.82           C  
ATOM    534  O   THR A 158      62.247  36.248   4.074  1.00 29.70           O  
ATOM    535  CB  THR A 158      61.609  37.606   1.348  1.00 29.92           C  
ATOM    536  OG1 THR A 158      61.744  38.944   1.851  1.00 31.49           O  
ATOM    537  CG2 THR A 158      61.012  37.648  -0.063  1.00 30.73           C  
ATOM    538  N   PHE A 159      60.479  37.543   4.674  1.00 26.64           N  
ATOM    539  CA  PHE A 159      60.839  37.616   6.089  1.00 25.66           C  
ATOM    540  C   PHE A 159      60.211  36.532   6.959  1.00 23.56           C  
ATOM    541  O   PHE A 159      60.535  36.456   8.147  1.00 24.30           O  
ATOM    542  CB  PHE A 159      60.519  39.021   6.667  1.00 23.50           C  
ATOM    543  CG  PHE A 159      61.195  40.134   5.908  1.00 27.91           C  
ATOM    544  CD1 PHE A 159      62.609  40.316   5.990  1.00 29.94           C  
ATOM    545  CD2 PHE A 159      60.465  40.948   5.059  1.00 29.96           C  
ATOM    546  CE1 PHE A 159      63.250  41.318   5.237  1.00 28.44           C  
ATOM    547  CE2 PHE A 159      61.088  41.973   4.298  1.00 32.04           C  
ATOM    548  CZ  PHE A 159      62.514  42.122   4.371  1.00 28.09           C  
ATOM    549  N   ILE A 160      59.322  35.722   6.371  1.00 25.16           N  
ATOM    550  CA  ILE A 160      58.501  34.793   7.160  1.00 24.36           C  
ATOM    551  C   ILE A 160      59.334  33.539   7.517  1.00 26.22           C  
ATOM    552  O   ILE A 160      59.859  32.861   6.626  1.00 26.10           O  
ATOM    553  CB  ILE A 160      57.216  34.415   6.412  1.00 24.77           C  
ATOM    554  CG1 ILE A 160      56.360  35.655   6.297  1.00 20.04           C  
ATOM    555  CG2 ILE A 160      56.530  33.190   7.152  1.00 23.14           C  
ATOM    556  CD1 ILE A 160      55.153  35.428   5.436  1.00 22.62           C  
ATOM    557  N   ALA A 161      59.397  33.239   8.807  1.00 27.50           N  
ATOM    558  CA  ALA A 161      60.073  32.016   9.293  1.00 28.56           C  
ATOM    559  C   ALA A 161      59.558  31.689  10.666  1.00 28.35           C  
ATOM    560  O   ALA A 161      59.051  32.544  11.357  1.00 29.94           O  
ATOM    561  CB  ALA A 161      61.587  32.270   9.357  1.00 27.41           C  
ATOM    562  N   ASP A 162      59.714  30.453  11.123  1.00 31.31           N  
ATOM    563  CA  ASP A 162      59.394  30.183  12.544  1.00 32.39           C  
ATOM    564  C   ASP A 162      60.073  31.144  13.498  1.00 32.58           C  
ATOM    565  O   ASP A 162      61.277  31.424  13.342  1.00 33.90           O  
ATOM    566  CB  ASP A 162      59.759  28.719  12.932  1.00 34.08           C  
ATOM    567  CG  ASP A 162      58.833  27.704  12.292  1.00 39.64           C  
ATOM    568  OD1 ASP A 162      57.731  28.067  11.831  1.00 43.69           O  
ATOM    569  OD2 ASP A 162      59.206  26.516  12.212  1.00 48.03           O  
ATOM    570  N   GLY A 163      59.320  31.641  14.485  1.00 31.70           N  
ATOM    571  CA  GLY A 163      59.891  32.503  15.549  1.00 31.90           C  
ATOM    572  C   GLY A 163      59.883  33.993  15.194  1.00 31.55           C  
ATOM    573  O   GLY A 163      60.172  34.854  16.049  1.00 32.62           O  
ATOM    574  N   VAL A 164      59.497  34.323  13.969  1.00 29.04           N  
ATOM    575  CA  VAL A 164      59.619  35.704  13.538  1.00 29.18           C  
ATOM    576  C   VAL A 164      58.404  36.467  14.079  1.00 29.28           C  
ATOM    577  O   VAL A 164      57.278  35.978  14.017  1.00 30.31           O  
ATOM    578  CB  VAL A 164      59.774  35.794  11.988  1.00 28.51           C  
ATOM    579  CG1 VAL A 164      59.634  37.247  11.443  1.00 29.34           C  
ATOM    580  CG2 VAL A 164      61.105  35.149  11.497  1.00 29.46           C  
ATOM    581  N   SER A 165      58.659  37.653  14.614  1.00 27.99           N  
ATOM    582  CA  SER A 165      57.614  38.529  15.009  1.00 28.54           C  
ATOM    583  C   SER A 165      57.230  39.373  13.779  1.00 27.77           C  
ATOM    584  O   SER A 165      58.031  40.191  13.291  1.00 26.54           O  
ATOM    585  CB  SER A 165      58.102  39.424  16.147  1.00 28.25           C  
ATOM    586  OG  SER A 165      57.207  40.516  16.264  1.00 31.65           O  
HETATM  587  N   MSE A 166      56.006  39.170  13.275  1.00 27.86           N  
HETATM  588  CA  MSE A 166      55.582  39.943  12.130  1.00 26.43           C  
HETATM  589  C   MSE A 166      55.443  41.430  12.500  1.00 27.60           C  
HETATM  590  O   MSE A 166      55.665  42.320  11.696  1.00 24.91           O  
HETATM  591  CB  MSE A 166      54.313  39.371  11.503  1.00 27.42           C  
HETATM  592  CG  MSE A 166      54.529  37.924  10.945  1.00 27.30           C  
HETATM  593 SE   MSE A 166      55.943  37.786   9.636  0.90 35.18          SE  
HETATM  594  CE  MSE A 166      55.076  38.687   8.069  1.00 34.34           C  
ATOM    595  N   HIS A 167      55.151  41.708  13.751  1.00 27.70           N  
ATOM    596  CA  HIS A 167      55.099  43.115  14.161  1.00 29.26           C  
ATOM    597  C   HIS A 167      56.469  43.748  14.095  1.00 29.33           C  
ATOM    598  O   HIS A 167      56.626  44.868  13.584  1.00 27.56           O  
ATOM    599  CB  HIS A 167      54.467  43.255  15.516  1.00 30.39           C  
ATOM    600  CG  HIS A 167      52.978  43.245  15.446  1.00 33.08           C  
ATOM    601  ND1 HIS A 167      52.262  42.086  15.230  1.00 40.53           N  
ATOM    602  CD2 HIS A 167      52.070  44.242  15.495  1.00 39.78           C  
ATOM    603  CE1 HIS A 167      50.974  42.368  15.163  1.00 41.73           C  
ATOM    604  NE2 HIS A 167      50.829  43.675  15.295  1.00 38.39           N  
ATOM    605  N   ASP A 168      57.484  42.980  14.488  1.00 28.87           N  
ATOM    606  CA  ASP A 168      58.884  43.403  14.283  1.00 29.85           C  
ATOM    607  C   ASP A 168      59.285  43.670  12.826  1.00 29.15           C  
ATOM    608  O   ASP A 168      59.965  44.664  12.545  1.00 30.35           O  
ATOM    609  CB  ASP A 168      59.809  42.341  14.885  1.00 31.15           C  
ATOM    610  CG  ASP A 168      60.030  42.541  16.353  1.00 36.10           C  
ATOM    611  OD1 ASP A 168      59.398  43.469  16.945  1.00 36.88           O  
ATOM    612  OD2 ASP A 168      60.851  41.771  16.911  1.00 40.99           O  
ATOM    613  N   ILE A 169      58.820  42.813  11.900  1.00 26.74           N  
ATOM    614  CA  ILE A 169      59.097  42.946  10.463  1.00 26.17           C  
ATOM    615  C   ILE A 169      58.415  44.215   9.981  1.00 25.96           C  
ATOM    616  O   ILE A 169      59.034  45.049   9.354  1.00 27.00           O  
ATOM    617  CB  ILE A 169      58.568  41.695   9.666  1.00 25.12           C  
ATOM    618  CG1 ILE A 169      59.441  40.480  10.007  1.00 25.02           C  
ATOM    619  CG2 ILE A 169      58.523  41.918   8.157  1.00 23.60           C  
ATOM    620  CD1 ILE A 169      61.012  40.736   9.995  1.00 25.13           C  
ATOM    621  N   LEU A 170      57.161  44.405  10.323  1.00 25.33           N  
ATOM    622  CA  LEU A 170      56.463  45.599   9.870  1.00 25.76           C  
ATOM    623  C   LEU A 170      57.172  46.861  10.346  1.00 26.12           C  
ATOM    624  O   LEU A 170      57.382  47.790   9.573  1.00 27.46           O  
ATOM    625  CB  LEU A 170      55.013  45.621  10.401  1.00 26.19           C  
ATOM    626  CG  LEU A 170      54.064  44.607   9.697  1.00 29.58           C  
ATOM    627  CD1 LEU A 170      52.763  44.453  10.562  1.00 33.66           C  
ATOM    628  CD2 LEU A 170      53.722  44.993   8.323  1.00 27.17           C  
ATOM    629  N   LYS A 171      57.538  46.883  11.612  1.00 28.08           N  
ATOM    630  CA  LYS A 171      58.265  48.000  12.207  1.00 28.77           C  
ATOM    631  C   LYS A 171      59.646  48.261  11.604  1.00 30.49           C  
ATOM    632  O   LYS A 171      59.928  49.393  11.119  1.00 29.81           O  
ATOM    633  CB  LYS A 171      58.330  47.826  13.698  1.00 29.79           C  
ATOM    634  CG  LYS A 171      58.896  49.057  14.394  1.00 32.67           C  
ATOM    635  CD  LYS A 171      58.241  49.217  15.702  1.00 38.27           C  
ATOM    636  CE  LYS A 171      58.893  50.351  16.468  1.00 40.50           C  
ATOM    637  NZ  LYS A 171      58.826  50.017  17.920  1.00 46.56           N  
ATOM    638  N   GLN A 172      60.511  47.241  11.602  1.00 28.99           N  
ATOM    639  CA  GLN A 172      61.871  47.478  11.049  1.00 31.18           C  
ATOM    640  C   GLN A 172      61.959  47.562   9.519  1.00 30.40           C  
ATOM    641  O   GLN A 172      62.711  48.383   8.959  1.00 29.85           O  
ATOM    642  CB  GLN A 172      62.903  46.478  11.651  1.00 30.90           C  
ATOM    643  CG  GLN A 172      63.857  47.025  12.738  1.00 35.42           C  
ATOM    644  CD  GLN A 172      63.292  48.201  13.584  1.00 41.16           C  
ATOM    645  OE1 GLN A 172      63.726  49.363  13.448  1.00 44.88           O  
ATOM    646  NE2 GLN A 172      62.325  47.903  14.430  1.00 38.18           N  
ATOM    647  N   GLN A 173      61.193  46.744   8.804  1.00 28.14           N  
ATOM    648  CA  GLN A 173      61.352  46.704   7.375  1.00 29.46           C  
ATOM    649  C   GLN A 173      60.518  47.787   6.706  1.00 30.52           C  
ATOM    650  O   GLN A 173      60.935  48.335   5.664  1.00 30.94           O  
ATOM    651  CB  GLN A 173      60.971  45.327   6.795  1.00 28.49           C  
ATOM    652  CG  GLN A 173      61.974  44.203   7.202  1.00 30.77           C  
ATOM    653  CD  GLN A 173      63.441  44.534   6.865  1.00 34.85           C  
ATOM    654  OE1 GLN A 173      64.325  44.330   7.680  1.00 37.88           O  
ATOM    655  NE2 GLN A 173      63.680  44.984   5.656  1.00 36.10           N  
ATOM    656  N   TYR A 174      59.337  48.062   7.272  1.00 28.87           N  
ATOM    657  CA  TYR A 174      58.406  48.971   6.612  1.00 28.79           C  
ATOM    658  C   TYR A 174      58.080  50.270   7.358  1.00 29.50           C  
ATOM    659  O   TYR A 174      57.320  51.099   6.836  1.00 29.37           O  
ATOM    660  CB  TYR A 174      57.119  48.211   6.251  1.00 27.60           C  
ATOM    661  CG  TYR A 174      57.412  47.011   5.404  1.00 27.60           C  
ATOM    662  CD1 TYR A 174      57.513  45.739   5.990  1.00 25.75           C  
ATOM    663  CD2 TYR A 174      57.599  47.130   4.022  1.00 25.53           C  
ATOM    664  CE1 TYR A 174      57.828  44.640   5.238  1.00 26.79           C  
ATOM    665  CE2 TYR A 174      57.901  46.043   3.269  1.00 23.54           C  
ATOM    666  CZ  TYR A 174      57.965  44.784   3.876  1.00 23.68           C  
ATOM    667  OH  TYR A 174      58.293  43.717   3.095  1.00 27.41           O  
ATOM    668  N   LYS A 175      58.674  50.461   8.540  1.00 29.48           N  
ATOM    669  CA  LYS A 175      58.388  51.594   9.440  1.00 30.78           C  
ATOM    670  C   LYS A 175      56.863  51.724   9.740  1.00 32.09           C  
ATOM    671  O   LYS A 175      56.321  52.813   9.883  1.00 31.70           O  
ATOM    672  CB  LYS A 175      58.957  52.891   8.831  1.00 32.25           C  
ATOM    673  CG  LYS A 175      60.442  52.749   8.423  1.00 35.37           C  
ATOM    674  CD  LYS A 175      61.254  52.126   9.542  1.00 43.73           C  
ATOM    675  CE  LYS A 175      62.728  51.995   9.130  1.00 45.00           C  
ATOM    676  NZ  LYS A 175      63.397  51.089  10.078  1.00 46.93           N  
ATOM    677  N   VAL A 176      56.190  50.591   9.876  1.00 30.63           N  
ATOM    678  CA  VAL A 176      54.774  50.614  10.178  1.00 30.63           C  
ATOM    679  C   VAL A 176      54.520  50.021  11.554  1.00 30.45           C  
ATOM    680  O   VAL A 176      55.041  48.938  11.927  1.00 29.97           O  
ATOM    681  CB  VAL A 176      53.942  49.880   9.030  1.00 29.73           C  
ATOM    682  CG1 VAL A 176      52.510  49.550   9.464  1.00 30.81           C  
ATOM    683  CG2 VAL A 176      53.939  50.730   7.712  1.00 33.53           C  
ATOM    684  N   VAL A 177      53.714  50.739  12.329  1.00 30.58           N  
ATOM    685  CA  VAL A 177      53.235  50.253  13.636  1.00 31.93           C  
ATOM    686  C   VAL A 177      51.703  50.379  13.666  1.00 31.50           C  
ATOM    687  O   VAL A 177      51.183  51.478  13.336  1.00 31.33           O  
ATOM    688  CB  VAL A 177      53.912  51.100  14.804  1.00 32.61           C  
ATOM    689  CG1 VAL A 177      53.279  50.851  16.069  1.00 35.08           C  
ATOM    690  CG2 VAL A 177      55.403  50.660  14.919  1.00 35.06           C  
ATOM    691  N   PRO A 178      50.964  49.288  14.068  1.00 30.33           N  
ATOM    692  CA  PRO A 178      49.524  49.439  14.213  1.00 30.04           C  
ATOM    693  C   PRO A 178      49.170  50.393  15.349  1.00 29.70           C  
ATOM    694  O   PRO A 178      49.853  50.433  16.389  1.00 32.33           O  
ATOM    695  CB  PRO A 178      48.981  47.977  14.432  1.00 29.80           C  
ATOM    696  CG  PRO A 178      50.121  47.082  14.475  1.00 31.80           C  
ATOM    697  CD  PRO A 178      51.426  47.906  14.301  1.00 30.13           C  
ATOM    698  N   THR A 179      48.136  51.182  15.147  1.00 29.10           N  
ATOM    699  CA  THR A 179      47.669  52.158  16.107  1.00 28.84           C  
ATOM    700  C   THR A 179      46.352  51.706  16.746  1.00 28.77           C  
ATOM    701  O   THR A 179      45.957  52.232  17.764  1.00 25.96           O  
ATOM    702  CB  THR A 179      47.426  53.520  15.403  1.00 29.83           C  
ATOM    703  OG1 THR A 179      46.545  53.366  14.278  1.00 28.52           O  
ATOM    704  CG2 THR A 179      48.790  54.073  14.880  1.00 31.22           C  
ATOM    705  N   HIS A 180      45.661  50.754  16.079  1.00 26.98           N  
ATOM    706  CA  HIS A 180      44.378  50.234  16.583  1.00 25.50           C  
ATOM    707  C   HIS A 180      43.924  49.069  15.717  1.00 26.02           C  
ATOM    708  O   HIS A 180      44.452  48.825  14.612  1.00 22.26           O  
ATOM    709  CB  HIS A 180      43.256  51.282  16.640  1.00 25.43           C  
ATOM    710  CG  HIS A 180      42.885  51.866  15.309  1.00 24.03           C  
ATOM    711  ND1 HIS A 180      43.690  52.746  14.641  1.00 26.10           N  
ATOM    712  CD2 HIS A 180      41.791  51.697  14.537  1.00 25.06           C  
ATOM    713  CE1 HIS A 180      43.104  53.114  13.519  1.00 27.97           C  
ATOM    714  NE2 HIS A 180      41.939  52.498  13.445  1.00 28.52           N  
ATOM    715  N   ASN A 181      42.911  48.386  16.231  1.00 26.38           N  
ATOM    716  CA  ASN A 181      42.328  47.213  15.535  1.00 28.07           C  
ATOM    717  C   ASN A 181      40.854  47.057  15.836  1.00 27.46           C  
ATOM    718  O   ASN A 181      40.343  47.603  16.837  1.00 29.87           O  
ATOM    719  CB  ASN A 181      43.135  45.930  15.765  1.00 28.18           C  
ATOM    720  CG  ASN A 181      43.113  45.451  17.192  1.00 32.27           C  
ATOM    721  OD1 ASN A 181      42.067  45.071  17.725  1.00 36.93           O  
ATOM    722  ND2 ASN A 181      44.272  45.434  17.811  1.00 32.74           N  
ATOM    723  N   THR A 182      40.149  46.373  14.947  1.00 26.55           N  
ATOM    724  CA  THR A 182      38.746  46.046  15.113  1.00 27.03           C  
ATOM    725  C   THR A 182      38.732  44.559  15.235  1.00 26.06           C  
ATOM    726  O   THR A 182      39.480  43.897  14.557  1.00 23.77           O  
ATOM    727  CB  THR A 182      37.906  46.459  13.907  1.00 27.27           C  
ATOM    728  OG1 THR A 182      36.533  46.113  14.141  1.00 38.94           O  
ATOM    729  CG2 THR A 182      38.311  45.808  12.755  1.00 23.90           C  
ATOM    730  N   LYS A 183      37.865  44.021  16.089  1.00 26.13           N  
ATOM    731  CA  LYS A 183      37.830  42.591  16.258  1.00 27.56           C  
ATOM    732  C   LYS A 183      36.366  42.164  16.312  1.00 27.67           C  
ATOM    733  O   LYS A 183      35.558  42.876  16.928  1.00 28.37           O  
ATOM    734  CB  LYS A 183      38.575  42.212  17.528  1.00 29.14           C  
ATOM    735  CG  LYS A 183      40.138  42.242  17.431  1.00 30.73           C  
ATOM    736  CD  LYS A 183      40.670  41.522  18.631  1.00 31.84           C  
ATOM    737  CE  LYS A 183      40.761  42.427  19.815  1.00 40.28           C  
ATOM    738  NZ  LYS A 183      41.360  43.806  19.592  1.00 38.09           N  
ATOM    739  N   LEU A 184      35.999  41.079  15.621  1.00 27.73           N  
ATOM    740  CA  LEU A 184      34.666  40.520  15.777  1.00 28.07           C  
ATOM    741  C   LEU A 184      34.828  39.106  16.306  1.00 27.42           C  
ATOM    742  O   LEU A 184      35.715  38.376  15.855  1.00 28.17           O  
ATOM    743  CB  LEU A 184      33.910  40.405  14.466  1.00 28.54           C  
ATOM    744  CG  LEU A 184      33.209  41.621  13.824  1.00 33.53           C  
ATOM    745  CD1 LEU A 184      33.930  42.829  14.128  1.00 35.26           C  
ATOM    746  CD2 LEU A 184      33.067  41.400  12.312  1.00 31.36           C  
ATOM    747  N   LEU A 185      33.954  38.695  17.222  1.00 24.82           N  
ATOM    748  CA  LEU A 185      34.005  37.328  17.730  1.00 22.90           C  
ATOM    749  C   LEU A 185      32.691  36.600  17.397  1.00 23.23           C  
ATOM    750  O   LEU A 185      31.597  37.098  17.668  1.00 22.95           O  
ATOM    751  CB  LEU A 185      34.289  37.358  19.229  1.00 23.52           C  
ATOM    752  CG  LEU A 185      34.113  36.062  20.007  1.00 25.55           C  
ATOM    753  CD1 LEU A 185      35.015  34.999  19.536  1.00 28.33           C  
ATOM    754  CD2 LEU A 185      34.475  36.501  21.412  1.00 33.39           C  
ATOM    755  N   ASN A 186      32.803  35.416  16.811  1.00 22.23           N  
ATOM    756  CA  ASN A 186      31.674  34.591  16.467  1.00 22.10           C  
ATOM    757  C   ASN A 186      32.071  33.156  16.805  1.00 23.03           C  
ATOM    758  O   ASN A 186      33.255  32.840  17.023  1.00 22.85           O  
ATOM    759  CB  ASN A 186      31.482  34.601  14.956  1.00 24.50           C  
ATOM    760  CG  ASN A 186      30.865  35.926  14.450  1.00 27.88           C  
ATOM    761  OD1 ASN A 186      31.553  36.775  13.859  1.00 32.00           O  
ATOM    762  ND2 ASN A 186      29.579  36.100  14.706  1.00 27.26           N  
ATOM    763  N   VAL A 187      31.081  32.288  16.753  1.00 21.27           N  
ATOM    764  CA  VAL A 187      31.320  30.834  16.653  1.00 21.19           C  
ATOM    765  C   VAL A 187      31.175  30.401  15.199  1.00 22.36           C  
ATOM    766  O   VAL A 187      30.259  30.907  14.463  1.00 20.96           O  
ATOM    767  CB  VAL A 187      30.393  30.070  17.640  1.00 22.23           C  
ATOM    768  CG1 VAL A 187      30.376  28.539  17.294  1.00 21.60           C  
ATOM    769  CG2 VAL A 187      30.805  30.336  19.163  1.00 20.02           C  
ATOM    770  N   VAL A 188      32.130  29.551  14.749  1.00 20.18           N  
ATOM    771  CA  VAL A 188      32.073  28.863  13.447  1.00 22.04           C  
ATOM    772  C   VAL A 188      32.309  27.370  13.704  1.00 20.56           C  
ATOM    773  O   VAL A 188      32.379  26.962  14.878  1.00 20.43           O  
ATOM    774  CB  VAL A 188      33.111  29.446  12.405  1.00 21.54           C  
ATOM    775  CG1 VAL A 188      32.869  30.979  12.194  1.00 24.54           C  
ATOM    776  CG2 VAL A 188      34.531  29.165  12.861  1.00 21.77           C  
ATOM    777  N   TYR A 189      32.391  26.566  12.631  1.00 19.81           N  
ATOM    778  CA  TYR A 189      32.355  25.102  12.788  1.00 20.50           C  
ATOM    779  C   TYR A 189      33.449  24.561  11.913  1.00 21.82           C  
ATOM    780  O   TYR A 189      33.529  24.954  10.730  1.00 21.23           O  
ATOM    781  CB  TYR A 189      30.956  24.540  12.465  1.00 22.08           C  
ATOM    782  CG  TYR A 189      29.978  25.043  13.504  1.00 21.06           C  
ATOM    783  CD1 TYR A 189      29.886  24.404  14.753  1.00 20.76           C  
ATOM    784  CD2 TYR A 189      29.247  26.257  13.267  1.00 20.22           C  
ATOM    785  CE1 TYR A 189      29.008  24.903  15.748  1.00 22.34           C  
ATOM    786  CE2 TYR A 189      28.395  26.783  14.277  1.00 21.55           C  
ATOM    787  CZ  TYR A 189      28.271  26.078  15.490  1.00 22.39           C  
ATOM    788  OH  TYR A 189      27.476  26.613  16.479  1.00 22.65           O  
ATOM    789  N   ALA A 190      34.323  23.781  12.552  1.00 20.85           N  
ATOM    790  CA  ALA A 190      35.537  23.163  11.949  1.00 22.33           C  
ATOM    791  C   ALA A 190      35.236  22.423  10.669  1.00 24.23           C  
ATOM    792  O   ALA A 190      34.326  21.573  10.638  1.00 25.43           O  
ATOM    793  CB  ALA A 190      36.201  22.175  12.971  1.00 23.44           C  
ATOM    794  N   GLN A 191      36.038  22.723   9.657  1.00 24.67           N  
ATOM    795  CA  GLN A 191      36.053  21.904   8.460  1.00 27.39           C  
ATOM    796  C   GLN A 191      37.350  21.122   8.419  1.00 27.96           C  
ATOM    797  O   GLN A 191      38.101  21.083   9.412  1.00 25.97           O  
ATOM    798  CB  GLN A 191      35.806  22.776   7.248  1.00 28.47           C  
ATOM    799  CG  GLN A 191      34.296  23.149   7.230  1.00 32.44           C  
ATOM    800  CD  GLN A 191      33.997  24.213   6.175  1.00 41.17           C  
ATOM    801  OE1 GLN A 191      33.130  24.027   5.336  1.00 43.80           O  
ATOM    802  NE2 GLN A 191      34.727  25.333   6.226  1.00 44.53           N  
ATOM    803  N   GLN A 192      37.593  20.413   7.313  1.00 29.84           N  
ATOM    804  CA  GLN A 192      38.760  19.516   7.270  1.00 32.25           C  
ATOM    805  C   GLN A 192      40.071  20.173   7.729  1.00 29.66           C  
ATOM    806  O   GLN A 192      40.771  19.620   8.523  1.00 28.19           O  
ATOM    807  CB  GLN A 192      38.912  19.010   5.823  1.00 32.95           C  
ATOM    808  CG  GLN A 192      39.814  17.840   5.608  1.00 37.50           C  
ATOM    809  CD  GLN A 192      39.717  17.384   4.107  1.00 37.77           C  
ATOM    810  OE1 GLN A 192      38.661  17.550   3.453  1.00 42.30           O  
ATOM    811  NE2 GLN A 192      40.831  16.855   3.567  1.00 43.52           N  
ATOM    812  N   GLU A 193      40.385  21.364   7.225  1.00 29.55           N  
ATOM    813  CA  GLU A 193      41.653  22.008   7.520  1.00 31.08           C  
ATOM    814  C   GLU A 193      41.824  22.371   9.015  1.00 28.56           C  
ATOM    815  O   GLU A 193      42.863  22.177   9.601  1.00 29.08           O  
ATOM    816  CB  GLU A 193      41.828  23.276   6.651  1.00 31.36           C  
ATOM    817  CG  GLU A 193      43.186  23.931   6.979  1.00 35.34           C  
ATOM    818  CD  GLU A 193      43.560  25.102   6.046  1.00 36.21           C  
ATOM    819  OE1 GLU A 193      42.763  26.056   5.903  1.00 43.97           O  
ATOM    820  OE2 GLU A 193      44.682  25.072   5.503  1.00 42.47           O  
ATOM    821  N   GLU A 194      40.755  22.876   9.622  1.00 29.41           N  
ATOM    822  CA  GLU A 194      40.802  23.232  11.043  1.00 30.12           C  
ATOM    823  C   GLU A 194      40.937  22.009  11.926  1.00 29.53           C  
ATOM    824  O   GLU A 194      41.639  22.030  12.951  1.00 30.76           O  
ATOM    825  CB  GLU A 194      39.539  23.995  11.445  1.00 30.48           C  
ATOM    826  CG  GLU A 194      39.458  25.328  10.793  1.00 32.15           C  
ATOM    827  CD  GLU A 194      38.776  25.322   9.474  1.00 34.50           C  
ATOM    828  OE1 GLU A 194      38.344  24.288   9.011  1.00 36.58           O  
ATOM    829  OE2 GLU A 194      38.655  26.393   8.869  1.00 40.40           O  
ATOM    830  N   SER A 195      40.192  20.980  11.559  1.00 31.04           N  
ATOM    831  CA  SER A 195      40.171  19.734  12.308  1.00 31.59           C  
ATOM    832  C   SER A 195      41.610  19.187  12.339  1.00 31.55           C  
ATOM    833  O   SER A 195      42.111  18.810  13.382  1.00 31.37           O  
ATOM    834  CB  SER A 195      39.131  18.783  11.723  1.00 32.26           C  
ATOM    835  OG  SER A 195      39.687  17.973  10.699  1.00 40.65           O  
ATOM    836  N   LYS A 196      42.314  19.220  11.214  1.00 31.22           N  
ATOM    837  CA  LYS A 196      43.726  18.816  11.234  1.00 32.67           C  
ATOM    838  C   LYS A 196      44.606  19.650  12.138  1.00 32.32           C  
ATOM    839  O   LYS A 196      45.229  19.107  12.999  1.00 32.77           O  
ATOM    840  CB  LYS A 196      44.285  18.822   9.818  1.00 33.23           C  
ATOM    841  CG  LYS A 196      45.804  18.444   9.719  1.00 37.22           C  
ATOM    842  CD  LYS A 196      46.127  18.284   8.265  1.00 42.46           C  
ATOM    843  CE  LYS A 196      47.008  17.045   8.051  1.00 47.99           C  
ATOM    844  NZ  LYS A 196      46.235  15.763   8.161  1.00 51.99           N  
ATOM    845  N   TYR A 197      44.617  20.971  11.977  1.00 30.88           N  
ATOM    846  CA  TYR A 197      45.577  21.809  12.667  1.00 31.20           C  
ATOM    847  C   TYR A 197      45.265  22.012  14.137  1.00 28.62           C  
ATOM    848  O   TYR A 197      46.167  22.178  14.923  1.00 26.54           O  
ATOM    849  CB  TYR A 197      45.719  23.154  11.961  1.00 32.23           C  
ATOM    850  CG  TYR A 197      46.346  23.012  10.594  1.00 35.68           C  
ATOM    851  CD1 TYR A 197      47.417  22.135  10.393  1.00 37.43           C  
ATOM    852  CD2 TYR A 197      45.854  23.731   9.503  1.00 37.85           C  
ATOM    853  CE1 TYR A 197      47.998  21.988   9.106  1.00 40.63           C  
ATOM    854  CE2 TYR A 197      46.415  23.601   8.227  1.00 37.66           C  
ATOM    855  CZ  TYR A 197      47.470  22.726   8.036  1.00 40.38           C  
ATOM    856  OH  TYR A 197      48.032  22.624   6.756  1.00 45.11           O  
ATOM    857  N   LEU A 198      43.962  22.004  14.470  1.00 27.36           N  
ATOM    858  CA  LEU A 198      43.507  22.138  15.860  1.00 27.52           C  
ATOM    859  C   LEU A 198      43.232  20.794  16.542  1.00 28.87           C  
ATOM    860  O   LEU A 198      42.806  20.747  17.700  1.00 28.90           O  
ATOM    861  CB  LEU A 198      42.214  22.986  15.923  1.00 27.14           C  
ATOM    862  CG  LEU A 198      42.480  24.486  15.679  1.00 26.97           C  
ATOM    863  CD1 LEU A 198      41.212  25.294  15.703  1.00 27.55           C  
ATOM    864  CD2 LEU A 198      43.515  25.100  16.607  1.00 27.65           C  
ATOM    865  N   ASP A 199      43.483  19.723  15.823  1.00 28.82           N  
ATOM    866  CA  ASP A 199      43.384  18.398  16.400  1.00 29.71           C  
ATOM    867  C   ASP A 199      42.005  18.272  17.049  1.00 27.85           C  
ATOM    868  O   ASP A 199      41.922  18.012  18.260  1.00 29.30           O  
ATOM    869  CB  ASP A 199      44.490  18.165  17.422  1.00 30.92           C  
ATOM    870  CG  ASP A 199      44.474  16.740  17.968  1.00 36.93           C  
ATOM    871  OD1 ASP A 199      43.830  15.834  17.358  1.00 38.55           O  
ATOM    872  OD2 ASP A 199      45.088  16.549  19.021  1.00 40.55           O  
ATOM    873  N   CYS A 200      40.946  18.413  16.250  1.00 25.84           N  
ATOM    874  CA  CYS A 200      39.607  18.254  16.821  1.00 27.13           C  
ATOM    875  C   CYS A 200      38.825  17.573  15.741  1.00 28.21           C  
ATOM    876  O   CYS A 200      39.402  17.192  14.730  1.00 29.61           O  
ATOM    877  CB  CYS A 200      39.026  19.628  17.243  1.00 26.59           C  
ATOM    878  SG  CYS A 200      38.831  20.756  15.789  1.00 26.39           S  
ATOM    879  N   ASP A 201      37.535  17.372  15.947  1.00 27.11           N  
ATOM    880  CA  ASP A 201      36.686  16.741  14.975  1.00 28.68           C  
ATOM    881  C   ASP A 201      36.113  17.736  13.956  1.00 27.82           C  
ATOM    882  O   ASP A 201      35.901  18.896  14.285  1.00 26.97           O  
ATOM    883  CB  ASP A 201      35.549  16.106  15.765  1.00 27.88           C  
ATOM    884  CG  ASP A 201      35.971  14.869  16.451  1.00 34.92           C  
ATOM    885  OD1 ASP A 201      36.997  14.266  16.029  1.00 38.58           O  
ATOM    886  OD2 ASP A 201      35.257  14.502  17.415  1.00 38.91           O  
ATOM    887  N   ILE A 202      35.857  17.300  12.728  1.00 26.82           N  
ATOM    888  CA  ILE A 202      35.080  18.080  11.796  1.00 27.10           C  
ATOM    889  C   ILE A 202      33.736  18.410  12.415  1.00 26.94           C  
ATOM    890  O   ILE A 202      33.079  17.555  13.065  1.00 24.84           O  
ATOM    891  CB  ILE A 202      34.904  17.322  10.440  1.00 27.88           C  
ATOM    892  CG1 ILE A 202      36.188  17.463   9.620  1.00 32.09           C  
ATOM    893  CG2 ILE A 202      33.683  17.913   9.596  1.00 29.10           C  
ATOM    894  CD1 ILE A 202      37.140  16.230   9.667  1.00 40.09           C  
ATOM    895  N   GLY A 203      33.339  19.678  12.314  1.00 24.87           N  
ATOM    896  CA  GLY A 203      32.073  20.088  12.867  1.00 24.74           C  
ATOM    897  C   GLY A 203      32.180  20.709  14.255  1.00 24.16           C  
ATOM    898  O   GLY A 203      31.198  21.302  14.717  1.00 25.35           O  
ATOM    899  N   ASP A 204      33.313  20.574  14.934  1.00 22.25           N  
ATOM    900  CA  ASP A 204      33.398  21.130  16.318  1.00 22.88           C  
ATOM    901  C   ASP A 204      33.270  22.636  16.267  1.00 21.23           C  
ATOM    902  O   ASP A 204      33.795  23.273  15.360  1.00 20.14           O  
ATOM    903  CB  ASP A 204      34.716  20.813  16.954  1.00 21.08           C  
ATOM    904  CG  ASP A 204      34.817  19.386  17.442  1.00 26.63           C  
ATOM    905  OD1 ASP A 204      33.847  18.633  17.301  1.00 28.37           O  
ATOM    906  OD2 ASP A 204      35.880  19.015  17.973  1.00 26.31           O  
ATOM    907  N   ALA A 205      32.674  23.189  17.313  1.00 17.24           N  
ATOM    908  CA  ALA A 205      32.476  24.631  17.468  1.00 20.02           C  
ATOM    909  C   ALA A 205      33.831  25.234  17.737  1.00 20.85           C  
ATOM    910  O   ALA A 205      34.563  24.754  18.610  1.00 21.72           O  
ATOM    911  CB  ALA A 205      31.536  24.923  18.718  1.00 18.59           C  
ATOM    912  N   LEU A 206      34.124  26.341  17.063  1.00 20.54           N  
ATOM    913  CA  LEU A 206      35.345  27.089  17.279  1.00 17.97           C  
ATOM    914  C   LEU A 206      34.950  28.551  17.487  1.00 18.90           C  
ATOM    915  O   LEU A 206      34.064  29.077  16.839  1.00 19.48           O  
ATOM    916  CB  LEU A 206      36.257  27.035  16.003  1.00 18.61           C  
ATOM    917  CG  LEU A 206      36.590  25.628  15.413  1.00 23.04           C  
ATOM    918  CD1 LEU A 206      37.314  25.714  14.103  1.00 21.63           C  
ATOM    919  CD2 LEU A 206      37.442  24.852  16.427  1.00 21.19           C  
ATOM    920  N   PHE A 207      35.686  29.252  18.334  1.00 18.75           N  
ATOM    921  CA  PHE A 207      35.594  30.708  18.357  1.00 17.53           C  
ATOM    922  C   PHE A 207      36.370  31.185  17.154  1.00 17.02           C  
ATOM    923  O   PHE A 207      37.477  30.695  16.858  1.00 18.36           O  
ATOM    924  CB  PHE A 207      36.323  31.263  19.593  1.00 17.50           C  
ATOM    925  CG  PHE A 207      35.605  30.990  20.895  1.00 19.73           C  
ATOM    926  CD1 PHE A 207      34.331  31.481  21.105  1.00 18.92           C  
ATOM    927  CD2 PHE A 207      36.244  30.280  21.898  1.00 19.93           C  
ATOM    928  CE1 PHE A 207      33.625  31.248  22.357  1.00 20.38           C  
ATOM    929  CE2 PHE A 207      35.595  30.074  23.153  1.00 16.37           C  
ATOM    930  CZ  PHE A 207      34.296  30.614  23.330  1.00 20.28           C  
ATOM    931  N   GLU A 208      35.835  32.195  16.500  1.00 18.43           N  
ATOM    932  CA  GLU A 208      36.572  32.858  15.450  1.00 20.75           C  
ATOM    933  C   GLU A 208      36.725  34.335  15.777  1.00 20.80           C  
ATOM    934  O   GLU A 208      35.709  35.028  15.926  1.00 21.92           O  
ATOM    935  CB  GLU A 208      35.769  32.743  14.140  1.00 19.39           C  
ATOM    936  CG  GLU A 208      36.562  33.405  12.895  1.00 22.76           C  
ATOM    937  CD  GLU A 208      35.678  33.469  11.614  1.00 27.75           C  
ATOM    938  OE1 GLU A 208      34.813  34.373  11.519  1.00 34.24           O  
ATOM    939  OE2 GLU A 208      35.848  32.624  10.708  1.00 31.33           O  
ATOM    940  N   ILE A 209      37.960  34.825  15.891  1.00 21.90           N  
ATOM    941  CA  ILE A 209      38.194  36.227  16.071  1.00 21.09           C  
ATOM    942  C   ILE A 209      38.658  36.786  14.731  1.00 22.66           C  
ATOM    943  O   ILE A 209      39.724  36.330  14.198  1.00 20.30           O  
ATOM    944  CB  ILE A 209      39.269  36.503  17.135  1.00 23.03           C  
ATOM    945  CG1 ILE A 209      38.810  36.089  18.549  1.00 25.55           C  
ATOM    946  CG2 ILE A 209      39.700  38.067  17.004  1.00 23.43           C  
ATOM    947  CD1 ILE A 209      37.645  36.954  19.051  1.00 34.72           C  
ATOM    948  N   ASP A 210      37.876  37.759  14.214  1.00 20.46           N  
ATOM    949  CA  ASP A 210      38.139  38.357  12.897  1.00 24.09           C  
ATOM    950  C   ASP A 210      38.706  39.744  13.209  1.00 22.92           C  
ATOM    951  O   ASP A 210      38.001  40.601  13.748  1.00 23.71           O  
ATOM    952  CB  ASP A 210      36.853  38.387  12.089  1.00 24.92           C  
ATOM    953  CG  ASP A 210      37.026  39.011  10.715  1.00 31.54           C  
ATOM    954  OD1 ASP A 210      38.015  39.730  10.551  1.00 33.62           O  
ATOM    955  OD2 ASP A 210      36.159  38.852   9.833  1.00 39.49           O  
ATOM    956  N   LYS A 211      40.000  39.905  12.919  1.00 22.46           N  
ATOM    957  CA  LYS A 211      40.763  41.123  13.280  1.00 22.82           C  
ATOM    958  C   LYS A 211      41.236  41.910  12.059  1.00 22.28           C  
ATOM    959  O   LYS A 211      41.826  41.340  11.144  1.00 20.55           O  
ATOM    960  CB  LYS A 211      41.935  40.790  14.196  1.00 24.82           C  
ATOM    961  CG  LYS A 211      42.923  41.973  14.419  1.00 25.43           C  
ATOM    962  CD  LYS A 211      44.020  41.678  15.496  1.00 23.90           C  
ATOM    963  CE  LYS A 211      45.382  41.455  14.966  1.00 31.06           C  
ATOM    964  NZ  LYS A 211      46.495  41.487  16.121  1.00 33.71           N  
ATOM    965  N   THR A 212      40.963  43.221  12.044  1.00 22.72           N  
ATOM    966  CA  THR A 212      41.650  44.077  11.045  1.00 21.17           C  
ATOM    967  C   THR A 212      42.533  45.072  11.862  1.00 22.04           C  
ATOM    968  O   THR A 212      42.061  45.692  12.844  1.00 22.54           O  
ATOM    969  CB  THR A 212      40.711  44.778  10.190  1.00 23.55           C  
ATOM    970  OG1 THR A 212      39.865  43.806   9.545  1.00 23.32           O  
ATOM    971  CG2 THR A 212      41.456  45.597   9.103  1.00 20.87           C  
ATOM    972  N   ALA A 213      43.808  45.159  11.466  1.00 20.52           N  
ATOM    973  CA  ALA A 213      44.761  46.051  12.180  1.00 21.58           C  
ATOM    974  C   ALA A 213      44.896  47.228  11.245  1.00 21.67           C  
ATOM    975  O   ALA A 213      44.865  47.063   9.988  1.00 20.96           O  
ATOM    976  CB  ALA A 213      46.106  45.392  12.326  1.00 21.86           C  
ATOM    977  N   PHE A 214      45.130  48.393  11.850  1.00 22.07           N  
ATOM    978  CA  PHE A 214      45.192  49.703  11.137  1.00 22.55           C  
ATOM    979  C   PHE A 214      46.395  50.483  11.648  1.00 23.64           C  
ATOM    980  O   PHE A 214      46.854  50.272  12.776  1.00 25.09           O  
ATOM    981  CB  PHE A 214      43.973  50.534  11.545  1.00 22.97           C  
ATOM    982  CG  PHE A 214      42.664  49.977  11.024  1.00 22.72           C  
ATOM    983  CD1 PHE A 214      42.173  50.359   9.759  1.00 27.74           C  
ATOM    984  CD2 PHE A 214      41.945  49.067  11.794  1.00 25.89           C  
ATOM    985  CE1 PHE A 214      40.941  49.843   9.262  1.00 26.19           C  
ATOM    986  CE2 PHE A 214      40.718  48.525  11.285  1.00 26.83           C  
ATOM    987  CZ  PHE A 214      40.211  48.917  10.051  1.00 24.81           C  
ATOM    988  N   THR A 215      46.886  51.359  10.807  1.00 25.14           N  
ATOM    989  CA  THR A 215      47.912  52.314  11.216  1.00 27.11           C  
ATOM    990  C   THR A 215      47.346  53.723  11.083  1.00 27.33           C  
ATOM    991  O   THR A 215      46.144  53.907  10.979  1.00 23.74           O  
ATOM    992  CB  THR A 215      49.279  52.033  10.479  1.00 28.61           C  
ATOM    993  OG1 THR A 215      50.384  52.720  11.161  1.00 30.25           O  
ATOM    994  CG2 THR A 215      49.190  52.407   9.036  1.00 30.13           C  
ATOM    995  N   SER A 216      48.223  54.737  11.154  1.00 29.01           N  
ATOM    996  CA  SER A 216      47.844  56.118  10.903  1.00 32.75           C  
ATOM    997  C   SER A 216      46.929  56.258   9.698  1.00 33.30           C  
ATOM    998  O   SER A 216      47.054  55.517   8.695  1.00 34.27           O  
ATOM    999  CB  SER A 216      49.100  56.962  10.694  1.00 33.16           C  
ATOM   1000  OG  SER A 216      49.985  56.701  11.754  1.00 35.63           O  
ATOM   1001  N   ASN A 217      45.992  57.178   9.862  1.00 34.57           N  
ATOM   1002  CA  ASN A 217      45.088  57.601   8.848  1.00 36.97           C  
ATOM   1003  C   ASN A 217      43.989  56.548   8.708  1.00 35.08           C  
ATOM   1004  O   ASN A 217      43.312  56.528   7.726  1.00 35.97           O  
ATOM   1005  CB  ASN A 217      45.837  57.850   7.511  1.00 38.75           C  
ATOM   1006  CG  ASN A 217      47.055  58.822   7.668  1.00 44.64           C  
ATOM   1007  OD1 ASN A 217      47.000  59.842   8.407  1.00 43.90           O  
ATOM   1008  ND2 ASN A 217      48.148  58.507   6.952  1.00 50.76           N  
ATOM   1009  N   ASP A 218      43.791  55.704   9.720  1.00 32.52           N  
ATOM   1010  CA  ASP A 218      42.807  54.612   9.617  1.00 30.67           C  
ATOM   1011  C   ASP A 218      43.100  53.685   8.420  1.00 27.98           C  
ATOM   1012  O   ASP A 218      42.197  53.135   7.802  1.00 26.11           O  
ATOM   1013  CB  ASP A 218      41.357  55.121   9.541  1.00 30.93           C  
ATOM   1014  CG  ASP A 218      40.344  54.077  10.032  1.00 31.51           C  
ATOM   1015  OD1 ASP A 218      40.694  53.246  10.882  1.00 30.29           O  
ATOM   1016  OD2 ASP A 218      39.165  54.076   9.588  1.00 35.41           O  
ATOM   1017  N   GLN A 219      44.360  53.528   8.105  1.00 26.67           N  
ATOM   1018  CA  GLN A 219      44.776  52.725   6.974  1.00 25.55           C  
ATOM   1019  C   GLN A 219      44.870  51.211   7.360  1.00 23.70           C  
ATOM   1020  O   GLN A 219      45.704  50.856   8.151  1.00 23.36           O  
ATOM   1021  CB  GLN A 219      46.141  53.210   6.517  1.00 26.50           C  
ATOM   1022  CG  GLN A 219      46.833  52.349   5.498  1.00 29.15           C  
ATOM   1023  CD  GLN A 219      45.992  52.229   4.238  1.00 35.31           C  
ATOM   1024  OE1 GLN A 219      45.537  53.256   3.636  1.00 34.42           O  
ATOM   1025  NE2 GLN A 219      45.730  50.972   3.834  1.00 27.64           N  
ATOM   1026  N   PRO A 220      44.017  50.350   6.783  1.00 24.06           N  
ATOM   1027  CA  PRO A 220      44.173  48.897   7.128  1.00 23.74           C  
ATOM   1028  C   PRO A 220      45.549  48.354   6.639  1.00 24.03           C  
ATOM   1029  O   PRO A 220      45.984  48.676   5.518  1.00 24.52           O  
ATOM   1030  CB  PRO A 220      42.960  48.216   6.413  1.00 24.75           C  
ATOM   1031  CG  PRO A 220      42.631  49.137   5.303  1.00 25.29           C  
ATOM   1032  CD  PRO A 220      42.884  50.546   5.837  1.00 24.63           C  
ATOM   1033  N   ILE A 221      46.193  47.515   7.458  1.00 22.71           N  
ATOM   1034  CA  ILE A 221      47.523  46.988   7.179  1.00 23.24           C  
ATOM   1035  C   ILE A 221      47.598  45.471   7.076  1.00 23.35           C  
ATOM   1036  O   ILE A 221      48.388  44.962   6.284  1.00 23.32           O  
ATOM   1037  CB  ILE A 221      48.611  47.466   8.124  1.00 23.38           C  
ATOM   1038  CG1 ILE A 221      48.226  47.284   9.623  1.00 23.74           C  
ATOM   1039  CG2 ILE A 221      48.928  48.994   7.782  1.00 26.20           C  
ATOM   1040  CD1 ILE A 221      49.477  47.412  10.544  1.00 24.97           C  
ATOM   1041  N   TYR A 222      46.775  44.784   7.849  1.00 21.03           N  
ATOM   1042  CA  TYR A 222      46.649  43.346   7.668  1.00 19.99           C  
ATOM   1043  C   TYR A 222      45.355  42.839   8.300  1.00 18.88           C  
ATOM   1044  O   TYR A 222      44.672  43.558   9.098  1.00 18.54           O  
ATOM   1045  CB  TYR A 222      47.859  42.630   8.229  1.00 20.28           C  
ATOM   1046  CG  TYR A 222      47.998  42.750   9.762  1.00 21.35           C  
ATOM   1047  CD1 TYR A 222      47.298  41.913  10.605  1.00 24.49           C  
ATOM   1048  CD2 TYR A 222      48.910  43.657  10.343  1.00 24.35           C  
ATOM   1049  CE1 TYR A 222      47.423  41.976  12.004  1.00 26.53           C  
ATOM   1050  CE2 TYR A 222      49.087  43.723  11.707  1.00 22.69           C  
ATOM   1051  CZ  TYR A 222      48.286  42.906  12.563  1.00 23.60           C  
ATOM   1052  OH  TYR A 222      48.357  42.942  13.931  1.00 28.64           O  
ATOM   1053  N   CYS A 223      44.939  41.618   7.934  1.00 19.85           N  
ATOM   1054  CA  CYS A 223      43.759  41.111   8.638  1.00 19.22           C  
ATOM   1055  C   CYS A 223      44.015  39.686   9.074  1.00 20.73           C  
ATOM   1056  O   CYS A 223      44.769  39.001   8.401  1.00 20.88           O  
ATOM   1057  CB  CYS A 223      42.507  41.258   7.765  1.00 20.61           C  
ATOM   1058  SG  CYS A 223      42.559  40.501   6.122  1.00 24.80           S  
ATOM   1059  N   SER A 224      43.370  39.223  10.149  1.00 19.52           N  
ATOM   1060  CA  SER A 224      43.739  37.921  10.719  1.00 21.04           C  
ATOM   1061  C   SER A 224      42.441  37.243  11.073  1.00 21.43           C  
ATOM   1062  O   SER A 224      41.461  37.891  11.432  1.00 23.72           O  
ATOM   1063  CB  SER A 224      44.620  38.137  11.980  1.00 21.73           C  
ATOM   1064  OG  SER A 224      45.997  38.673  11.829  1.00 22.26           O  
ATOM   1065  N   LEU A 225      42.417  35.925  10.990  1.00 20.94           N  
ATOM   1066  CA  LEU A 225      41.293  35.159  11.519  1.00 22.79           C  
ATOM   1067  C   LEU A 225      41.997  34.156  12.420  1.00 22.83           C  
ATOM   1068  O   LEU A 225      42.955  33.509  11.992  1.00 23.42           O  
ATOM   1069  CB  LEU A 225      40.637  34.449  10.412  1.00 24.11           C  
ATOM   1070  CG  LEU A 225      39.138  34.502  10.189  1.00 31.99           C  
ATOM   1071  CD1 LEU A 225      38.501  35.916  10.151  1.00 29.14           C  
ATOM   1072  CD2 LEU A 225      38.898  33.704   8.887  1.00 34.35           C  
ATOM   1073  N   PHE A 226      41.634  34.210  13.676  1.00 20.84           N  
ATOM   1074  CA  PHE A 226      42.131  33.277  14.694  1.00 24.10           C  
ATOM   1075  C   PHE A 226      40.996  32.320  15.037  1.00 23.35           C  
ATOM   1076  O   PHE A 226      39.865  32.772  15.312  1.00 24.16           O  
ATOM   1077  CB  PHE A 226      42.579  34.011  15.963  1.00 24.39           C  
ATOM   1078  CG  PHE A 226      43.622  35.108  15.755  1.00 27.90           C  
ATOM   1079  CD1 PHE A 226      44.985  34.804  15.769  1.00 31.63           C  
ATOM   1080  CD2 PHE A 226      43.239  36.440  15.605  1.00 31.86           C  
ATOM   1081  CE1 PHE A 226      45.935  35.810  15.615  1.00 31.76           C  
ATOM   1082  CE2 PHE A 226      44.232  37.472  15.415  1.00 26.02           C  
ATOM   1083  CZ  PHE A 226      45.541  37.134  15.462  1.00 29.93           C  
ATOM   1084  N   LEU A 227      41.281  31.010  15.021  1.00 23.60           N  
ATOM   1085  CA  LEU A 227      40.315  29.940  15.359  1.00 22.66           C  
ATOM   1086  C   LEU A 227      40.806  29.217  16.597  1.00 22.35           C  
ATOM   1087  O   LEU A 227      42.025  28.928  16.723  1.00 22.32           O  
ATOM   1088  CB  LEU A 227      40.107  28.973  14.203  1.00 22.77           C  
ATOM   1089  CG  LEU A 227      39.482  29.604  13.004  1.00 20.92           C  
ATOM   1090  CD1 LEU A 227      39.616  28.650  11.869  1.00 25.79           C  
ATOM   1091  CD2 LEU A 227      38.029  29.906  13.277  1.00 21.82           C  
HETATM 1092  N   MSE A 228      39.897  29.000  17.564  1.00 21.43           N  
HETATM 1093  CA  MSE A 228      40.278  28.391  18.820  1.00 23.19           C  
HETATM 1094  C   MSE A 228      39.133  27.475  19.225  1.00 22.76           C  
HETATM 1095  O   MSE A 228      38.029  27.901  19.199  1.00 21.83           O  
HETATM 1096  CB  MSE A 228      40.483  29.443  19.926  1.00 23.05           C  
HETATM 1097  CG  MSE A 228      41.650  30.320  19.543  1.00 27.21           C  
HETATM 1098 SE   MSE A 228      40.812  32.041  19.126  0.70 44.96          SE  
HETATM 1099  CE  MSE A 228      41.379  32.151  20.784  1.00 12.94           C  
ATOM   1100  N   HIS A 229      39.454  26.227  19.613  1.00 22.36           N  
ATOM   1101  CA  HIS A 229      38.380  25.303  19.991  1.00 19.54           C  
ATOM   1102  C   HIS A 229      37.628  25.840  21.188  1.00 19.63           C  
ATOM   1103  O   HIS A 229      38.224  26.311  22.179  1.00 21.10           O  
ATOM   1104  CB  HIS A 229      39.035  23.913  20.274  1.00 22.09           C  
ATOM   1105  CG  HIS A 229      38.046  22.785  20.360  1.00 23.74           C  
ATOM   1106  ND1 HIS A 229      37.364  22.487  21.522  1.00 25.52           N  
ATOM   1107  CD2 HIS A 229      37.595  21.905  19.420  1.00 23.70           C  
ATOM   1108  CE1 HIS A 229      36.553  21.468  21.308  1.00 21.74           C  
ATOM   1109  NE2 HIS A 229      36.679  21.076  20.045  1.00 22.26           N  
ATOM   1110  N   THR A 230      36.290  25.726  21.188  1.00 20.17           N  
ATOM   1111  CA  THR A 230      35.569  26.320  22.292  1.00 19.51           C  
ATOM   1112  C   THR A 230      35.786  25.699  23.635  1.00 20.84           C  
ATOM   1113  O   THR A 230      35.566  26.419  24.644  1.00 22.96           O  
ATOM   1114  CB  THR A 230      34.052  26.474  22.051  1.00 21.41           C  
ATOM   1115  OG1 THR A 230      33.448  25.167  22.070  1.00 21.23           O  
ATOM   1116  CG2 THR A 230      33.752  27.249  20.735  1.00 18.11           C  
ATOM   1117  N   ASN A 231      36.224  24.438  23.704  1.00 20.37           N  
ATOM   1118  CA  ASN A 231      36.456  23.820  25.035  1.00 21.07           C  
ATOM   1119  C   ASN A 231      37.776  24.345  25.609  1.00 22.53           C  
ATOM   1120  O   ASN A 231      38.071  24.123  26.753  1.00 23.58           O  
ATOM   1121  CB  ASN A 231      36.676  22.292  24.946  1.00 20.44           C  
ATOM   1122  CG  ASN A 231      35.441  21.471  24.623  1.00 21.88           C  
ATOM   1123  OD1 ASN A 231      35.613  20.291  24.320  1.00 25.27           O  
ATOM   1124  ND2 ASN A 231      34.247  22.034  24.705  1.00 17.97           N  
ATOM   1125  N   ARG A 232      38.612  24.993  24.822  1.00 22.15           N  
ATOM   1126  CA  ARG A 232      39.986  25.182  25.277  1.00 21.96           C  
ATOM   1127  C   ARG A 232      40.340  26.572  25.755  1.00 22.71           C  
ATOM   1128  O   ARG A 232      41.490  26.776  26.264  1.00 24.21           O  
ATOM   1129  CB  ARG A 232      40.955  24.851  24.145  1.00 21.66           C  
ATOM   1130  CG  ARG A 232      40.828  23.382  23.698  1.00 23.80           C  
ATOM   1131  CD  ARG A 232      41.883  22.987  22.647  1.00 21.71           C  
ATOM   1132  NE  ARG A 232      41.517  21.699  22.056  1.00 21.54           N  
ATOM   1133  CZ  ARG A 232      41.850  21.320  20.820  1.00 27.37           C  
ATOM   1134  NH1 ARG A 232      42.631  22.127  20.090  1.00 23.74           N  
ATOM   1135  NH2 ARG A 232      41.393  20.150  20.317  1.00 21.42           N  
ATOM   1136  N   VAL A 233      39.435  27.517  25.570  1.00 21.81           N  
ATOM   1137  CA  VAL A 233      39.720  28.915  25.968  1.00 24.46           C  
ATOM   1138  C   VAL A 233      38.512  29.590  26.617  1.00 25.03           C  
ATOM   1139  O   VAL A 233      37.339  29.249  26.320  1.00 23.08           O  
ATOM   1140  CB  VAL A 233      40.166  29.788  24.773  1.00 25.03           C  
ATOM   1141  CG1 VAL A 233      39.131  29.798  23.733  1.00 23.65           C  
ATOM   1142  CG2 VAL A 233      40.384  31.230  25.185  1.00 31.63           C  
ATOM   1143  N   THR A 234      38.847  30.558  27.465  1.00 24.71           N  
ATOM   1144  CA  THR A 234      37.959  31.584  28.030  1.00 26.74           C  
ATOM   1145  C   THR A 234      38.559  32.954  27.723  1.00 27.21           C  
ATOM   1146  O   THR A 234      39.787  33.129  27.827  1.00 30.49           O  
ATOM   1147  CB  THR A 234      37.908  31.475  29.560  1.00 27.25           C  
ATOM   1148  OG1 THR A 234      37.442  30.175  29.974  1.00 27.64           O  
ATOM   1149  CG2 THR A 234      36.954  32.577  30.165  1.00 30.51           C  
ATOM   1150  N   PHE A 235      37.726  33.930  27.356  1.00 25.42           N  
ATOM   1151  CA  PHE A 235      38.213  35.267  27.047  1.00 24.35           C  
ATOM   1152  C   PHE A 235      37.951  36.144  28.231  1.00 26.23           C  
ATOM   1153  O   PHE A 235      36.920  35.980  28.898  1.00 24.80           O  
ATOM   1154  CB  PHE A 235      37.471  35.825  25.841  1.00 25.03           C  
ATOM   1155  CG  PHE A 235      37.665  35.010  24.617  1.00 25.24           C  
ATOM   1156  CD1 PHE A 235      38.815  35.150  23.859  1.00 24.32           C  
ATOM   1157  CD2 PHE A 235      36.626  34.180  24.173  1.00 28.23           C  
ATOM   1158  CE1 PHE A 235      38.980  34.386  22.713  1.00 33.27           C  
ATOM   1159  CE2 PHE A 235      36.810  33.412  23.023  1.00 24.93           C  
ATOM   1160  CZ  PHE A 235      37.950  33.518  22.323  1.00 24.90           C  
ATOM   1161  N   THR A 236      38.859  37.083  28.503  1.00 28.54           N  
ATOM   1162  CA  THR A 236      38.605  38.079  29.571  1.00 32.91           C  
ATOM   1163  C   THR A 236      38.544  39.465  28.910  1.00 35.49           C  
ATOM   1164  O   THR A 236      39.291  39.790  27.956  1.00 34.67           O  
ATOM   1165  CB  THR A 236      39.614  38.084  30.707  1.00 34.02           C  
ATOM   1166  OG1 THR A 236      40.863  38.556  30.207  1.00 39.03           O  
ATOM   1167  CG2 THR A 236      39.846  36.714  31.310  1.00 34.95           C  
ATOM   1168  N   ILE A 237      37.586  40.259  29.355  1.00 38.23           N  
ATOM   1169  CA  ILE A 237      37.477  41.676  28.953  1.00 42.65           C  
ATOM   1170  C   ILE A 237      37.390  42.398  30.281  1.00 45.26           C  
ATOM   1171  O   ILE A 237      36.484  42.097  31.069  1.00 46.58           O  
ATOM   1172  CB  ILE A 237      36.158  42.012  28.227  1.00 42.21           C  
ATOM   1173  CG1 ILE A 237      35.648  40.839  27.383  1.00 44.15           C  
ATOM   1174  CG2 ILE A 237      36.300  43.340  27.462  1.00 44.93           C  
ATOM   1175  CD1 ILE A 237      36.066  40.828  25.943  1.00 47.25           C  
ATOM   1176  N   ASN A 238      38.332  43.276  30.595  1.00 48.43           N  
ATOM   1177  CA  ASN A 238      38.130  44.131  31.775  1.00 51.26           C  
ATOM   1178  C   ASN A 238      38.570  45.570  31.596  1.00 51.80           C  
ATOM   1179  O   ASN A 238      37.856  46.332  30.947  1.00 53.17           O  
ATOM   1180  CB  ASN A 238      38.625  43.510  33.098  1.00 52.40           C  
ATOM   1181  CG  ASN A 238      39.976  42.851  32.996  1.00 54.02           C  
ATOM   1182  OD1 ASN A 238      40.635  42.649  34.021  1.00 57.44           O  
ATOM   1183  ND2 ASN A 238      40.399  42.487  31.782  1.00 57.59           N  
TER    1184      ASN A 238                                                      
END
MOLECULE T0455.pdb
ATOM    981  N   SER     7      55.366  26.966  20.854  1.00 66.80           N  
ATOM    982  CA  SER     7      55.702  26.695  19.421  1.00 66.93           C  
ATOM    983  CB  SER     7      56.100  25.225  19.176  1.00 67.14           C  
ATOM    984  OG  SER     7      57.045  25.126  18.105  1.00 67.50           O  
ATOM    985  C   SER     7      54.546  27.029  18.496  1.00 67.22           C  
ATOM    986  O   SER     7      53.366  27.033  18.892  1.00 67.58           O  
ATOM    987  N   SER     8      54.906  27.266  17.235  1.00 67.10           N  
ATOM    988  CA  SER     8      53.963  27.599  16.177  1.00 66.00           C  
ATOM    989  CB  SER     8      53.890  29.128  16.007  1.00 66.59           C  
ATOM    990  OG  SER     8      53.375  29.536  14.732  1.00 67.49           O  
ATOM    991  C   SER     8      54.435  26.946  14.895  1.00 65.24           C  
ATOM    992  O   SER     8      55.612  26.779  14.693  1.00 65.20           O  
ATOM    993  N   ARG     9      53.508  26.618  14.012  1.00 64.59           N  
ATOM    994  CA  ARG     9      53.810  25.902  12.777  1.00 63.46           C  
ATOM    995  CB  ARG     9      53.323  24.452  12.955  1.00 63.59           C  
ATOM    996  CG  ARG     9      53.608  23.502  11.797  1.00 64.77           C  
ATOM    997  CD  ARG     9      52.566  22.383  11.682  1.00 66.10           C  
ATOM    998  NE  ARG     9      52.289  22.125  10.265  1.00 69.18           N  
ATOM    999  CZ  ARG     9      51.219  21.496   9.777  1.00 70.75           C  
ATOM   1000  NH1 ARG     9      50.269  21.019  10.575  1.00 72.26           N  
ATOM   1001  NH2 ARG     9      51.092  21.339   8.461  1.00 71.12           N  
ATOM   1002  C   ARG     9      53.114  26.578  11.573  1.00 61.94           C  
ATOM   1003  O   ARG     9      51.876  26.647  11.512  1.00 62.08           O  
ATOM   1004  N   THR    10      53.888  27.073  10.614  1.00 60.07           N  
ATOM   1005  CA  THR    10      53.296  27.593   9.384  1.00 58.73           C  
ATOM   1006  CB  THR    10      54.264  28.455   8.588  1.00 58.55           C  
ATOM   1007  OG1 THR    10      54.907  29.383   9.450  1.00 58.12           O  
ATOM   1008  CG2 THR    10      53.523  29.236   7.573  1.00 59.32           C  
ATOM   1009  C   THR    10      52.835  26.470   8.477  1.00 57.08           C  
ATOM   1010  O   THR    10      53.626  25.822   7.873  1.00 57.73           O  
ATOM   1011  N   VAL    11      51.540  26.266   8.388  1.00 55.72           N  
ATOM   1012  CA  VAL    11      50.919  25.326   7.461  1.00 54.80           C  
ATOM   1013  CB  VAL    11      49.451  25.178   7.858  1.00 54.58           C  
ATOM   1014  CG1 VAL    11      48.606  24.505   6.741  1.00 53.03           C  
ATOM   1015  CG2 VAL    11      49.372  24.461   9.181  1.00 55.59           C  
ATOM   1016  C   VAL    11      50.944  25.731   5.966  1.00 54.04           C  
ATOM   1017  O   VAL    11      50.990  24.876   5.094  1.00 54.13           O  
ATOM   1018  N   SER    12      50.805  27.015   5.655  1.00 52.92           N  
ATOM   1019  CA  SER    12      51.032  27.471   4.287  1.00 51.89           C  
ATOM   1020  CB  SER    12      49.826  27.206   3.405  1.00 51.67           C  
ATOM   1021  OG  SER    12      48.768  27.971   3.862  1.00 52.50           O  
ATOM   1022  C   SER    12      51.419  28.946   4.220  1.00 49.85           C  
ATOM   1023  O   SER    12      51.261  29.690   5.178  1.00 48.66           O  
ATOM   1024  N   TYR    13      51.929  29.353   3.068  1.00 47.92           N  
ATOM   1025  CA  TYR    13      52.545  30.644   2.962  1.00 47.09           C  
ATOM   1026  CB  TYR    13      53.859  30.625   3.746  1.00 47.17           C  
ATOM   1027  CG  TYR    13      54.529  31.952   3.919  1.00 46.90           C  
ATOM   1028  CD1 TYR    13      54.225  32.765   4.984  1.00 46.52           C  
ATOM   1029  CE1 TYR    13      54.846  33.984   5.160  1.00 46.47           C  
ATOM   1030  CZ  TYR    13      55.790  34.394   4.276  1.00 47.95           C  
ATOM   1031  OH  TYR    13      56.430  35.596   4.451  1.00 48.26           O  
ATOM   1032  CE2 TYR    13      56.117  33.596   3.211  1.00 48.07           C  
ATOM   1033  CD2 TYR    13      55.473  32.383   3.040  1.00 46.54           C  
ATOM   1034  C   TYR    13      52.797  30.938   1.493  1.00 46.32           C  
ATOM   1035  O   TYR    13      53.632  30.328   0.871  1.00 46.29           O  
ATOM   1036  N   PHE    14      52.044  31.870   0.939  1.00 45.80           N  
ATOM   1037  CA  PHE    14      52.161  32.209  -0.459  1.00 45.02           C  
ATOM   1038  CB  PHE    14      51.686  31.051  -1.319  1.00 44.87           C  
ATOM   1039  CG  PHE    14      50.249  30.696  -1.134  1.00 44.59           C  
ATOM   1040  CD1 PHE    14      49.896  29.556  -0.461  1.00 44.02           C  
ATOM   1041  CE1 PHE    14      48.570  29.210  -0.313  1.00 45.96           C  
ATOM   1042  CZ  PHE    14      47.567  29.997  -0.874  1.00 44.63           C  
ATOM   1043  CE2 PHE    14      47.905  31.136  -1.549  1.00 44.54           C  
ATOM   1044  CD2 PHE    14      49.241  31.479  -1.693  1.00 45.21           C  
ATOM   1045  C   PHE    14      51.395  33.464  -0.837  1.00 44.29           C  
ATOM   1046  O   PHE    14      50.458  33.895  -0.143  1.00 44.89           O  
ATOM   1047  N   VAL    15      51.772  33.998  -1.982  1.00 43.49           N  
ATOM   1048  CA  VAL    15      51.210  35.211  -2.498  1.00 43.41           C  
ATOM   1049  CB  VAL    15      52.299  35.963  -3.246  1.00 43.05           C  
ATOM   1050  CG1 VAL    15      51.764  37.141  -3.945  1.00 42.02           C  
ATOM   1051  CG2 VAL    15      53.372  36.367  -2.278  1.00 42.40           C  
ATOM   1052  C   VAL    15      50.034  34.908  -3.419  1.00 43.85           C  
ATOM   1053  O   VAL    15      50.064  33.992  -4.228  1.00 44.16           O  
ATOM   1054  N   ALA    16      48.981  35.689  -3.297  1.00 44.56           N  
ATOM   1055  CA  ALA    16      47.768  35.460  -4.066  1.00 44.69           C  
ATOM   1056  CB  ALA    16      46.796  34.653  -3.280  1.00 43.79           C  
ATOM   1057  C   ALA    16      47.157  36.787  -4.396  1.00 45.56           C  
ATOM   1058  O   ALA    16      47.487  37.798  -3.788  1.00 46.06           O  
ATOM   1059  N   LYS    17      46.293  36.797  -5.392  1.00 46.31           N  
ATOM   1060  CA  LYS    17      45.523  37.984  -5.648  1.00 47.32           C  
ATOM   1061  CB  LYS    17      45.167  38.115  -7.151  1.00 47.08           C  
ATOM   1062  CG  LYS    17      46.452  38.029  -8.006  1.00 49.26           C  
ATOM   1063  CD  LYS    17      46.559  38.957  -9.180  1.00 49.63           C  
ATOM   1064  CE  LYS    17      45.585  38.494 -10.345  1.00 54.44           C  
ATOM   1065  NZ  LYS    17      46.079  38.686 -11.787  1.00 50.61           N  
ATOM   1066  C   LYS    17      44.361  37.841  -4.679  1.00 47.08           C  
ATOM   1067  O   LYS    17      43.964  36.750  -4.340  1.00 47.55           O  
ATOM   1068  N   PRO    18      43.857  38.939  -4.170  1.00 47.03           N  
ATOM   1069  CA  PRO    18      42.953  38.814  -3.060  1.00 47.50           C  
ATOM   1070  CB  PRO    18      42.848  40.259  -2.554  1.00 47.75           C  
ATOM   1071  CG  PRO    18      43.077  41.081  -3.791  1.00 47.83           C  
ATOM   1072  CD  PRO    18      44.073  40.330  -4.580  1.00 47.03           C  
ATOM   1073  C   PRO    18      41.580  38.326  -3.460  1.00 47.37           C  
ATOM   1074  O   PRO    18      41.135  38.614  -4.549  1.00 47.23           O  
ATOM   1075  N   SER    19      40.911  37.632  -2.551  1.00 47.79           N  
ATOM   1076  CA  SER    19      39.484  37.325  -2.670  1.00 48.25           C  
ATOM   1077  CB  SER    19      39.150  36.281  -1.617  1.00 47.61           C  
ATOM   1078  OG  SER    19      39.108  36.882  -0.326  1.00 49.49           O  
ATOM   1079  C   SER    19      38.607  38.592  -2.423  1.00 48.80           C  
ATOM   1080  O   SER    19      39.106  39.650  -2.010  1.00 48.76           O  
ATOM   1081  N   SER    20      37.301  38.484  -2.623  1.00 48.97           N  
ATOM   1082  CA  SER    20      36.422  39.623  -2.332  1.00 49.63           C  
ATOM   1083  CB  SER    20      34.972  39.229  -2.590  1.00 49.72           C  
ATOM   1084  OG  SER    20      34.907  38.531  -3.822  1.00 53.35           O  
ATOM   1085  C   SER    20      36.522  40.148  -0.900  1.00 49.91           C  
ATOM   1086  O   SER    20      36.648  41.363  -0.654  1.00 49.90           O  
ATOM   1087  N   SER    21      36.417  39.246   0.064  1.00 49.95           N  
ATOM   1088  CA  SER    21      36.420  39.712   1.429  1.00 49.61           C  
ATOM   1089  CB  SER    21      36.018  38.615   2.413  1.00 49.01           C  
ATOM   1090  OG  SER    21      37.102  37.851   2.775  1.00 49.97           O  
ATOM   1091  C   SER    21      37.807  40.311   1.701  1.00 49.66           C  
ATOM   1092  O   SER    21      37.934  41.296   2.430  1.00 49.35           O  
ATOM   1093  N   GLU    22      38.837  39.762   1.064  1.00 49.14           N  
ATOM   1094  CA  GLU    22      40.149  40.301   1.291  1.00 49.16           C  
ATOM   1095  CB  GLU    22      41.231  39.338   0.789  1.00 49.18           C  
ATOM   1096  CG  GLU    22      41.352  38.099   1.671  1.00 48.36           C  
ATOM   1097  CD  GLU    22      42.337  37.057   1.151  1.00 47.87           C  
ATOM   1098  OE1 GLU    22      42.607  37.030  -0.058  1.00 48.49           O  
ATOM   1099  OE2 GLU    22      42.841  36.256   1.961  1.00 43.16           O  
ATOM   1100  C   GLU    22      40.246  41.692   0.668  1.00 49.40           C  
ATOM   1101  O   GLU    22      40.855  42.576   1.232  1.00 49.08           O  
ATOM   1102  N   MET    23      39.637  41.897  -0.493  1.00 50.38           N  
ATOM   1103  CA  MET    23      39.667  43.215  -1.147  1.00 50.41           C  
ATOM   1104  CB  MET    23      38.957  43.155  -2.491  1.00 50.70           C  
ATOM   1105  CG  MET    23      39.736  42.378  -3.537  1.00 51.45           C  
ATOM   1106  SD  MET    23      38.879  42.251  -5.118  1.00 48.27           S  
ATOM   1107  CE  MET    23      38.583  44.004  -5.360  1.00 45.34           C  
ATOM   1108  C   MET    23      38.973  44.241  -0.259  1.00 51.76           C  
ATOM   1109  O   MET    23      39.481  45.323   0.001  1.00 51.94           O  
ATOM   1110  N   GLU    24      37.806  43.860   0.215  1.00 53.13           N  
ATOM   1111  CA  GLU    24      36.978  44.722   1.005  1.00 53.62           C  
ATOM   1112  CB  GLU    24      35.644  43.973   1.229  1.00 54.72           C  
ATOM   1113  CG  GLU    24      34.450  44.799   1.705  1.00 56.70           C  
ATOM   1114  CD  GLU    24      33.999  44.474   3.115  1.00 64.20           C  
ATOM   1115  OE1 GLU    24      34.727  43.777   3.857  1.00 69.18           O  
ATOM   1116  OE2 GLU    24      32.894  44.923   3.487  1.00 70.36           O  
ATOM   1117  C   GLU    24      37.682  45.148   2.333  1.00 53.63           C  
ATOM   1118  O   GLU    24      37.833  46.347   2.595  1.00 53.82           O  
ATOM   1119  N   LYS    25      38.136  44.175   3.128  1.00 52.64           N  
ATOM   1120  CA  LYS    25      38.749  44.447   4.431  1.00 52.19           C  
ATOM   1121  CB  LYS    25      38.972  43.161   5.229  1.00 52.35           C  
ATOM   1122  CG  LYS    25      37.796  42.253   5.370  1.00 54.27           C  
ATOM   1123  CD  LYS    25      36.775  42.727   6.383  1.00 54.98           C  
ATOM   1124  CE  LYS    25      35.645  41.721   6.435  1.00 55.23           C  
ATOM   1125  NZ  LYS    25      34.500  42.241   7.228  1.00 58.74           N  
ATOM   1126  C   LYS    25      40.126  45.101   4.337  1.00 51.74           C  
ATOM   1127  O   LYS    25      40.522  45.839   5.221  1.00 51.11           O  
ATOM   1128  N   LEU    26      40.904  44.760   3.317  1.00 51.27           N  
ATOM   1129  CA  LEU    26      42.245  45.312   3.206  1.00 50.74           C  
ATOM   1130  CB  LEU    26      43.233  44.246   2.740  1.00 50.18           C  
ATOM   1131  CG  LEU    26      43.618  43.149   3.733  1.00 47.96           C  
ATOM   1132  CD1 LEU    26      44.658  42.174   3.109  1.00 46.25           C  
ATOM   1133  CD2 LEU    26      44.156  43.767   5.006  1.00 42.03           C  
ATOM   1134  C   LEU    26      42.221  46.502   2.257  1.00 50.78           C  
ATOM   1135  O   LEU    26      43.232  47.183   2.078  1.00 50.95           O  
ATOM   1136  N   GLN    27      41.046  46.741   1.674  1.00 50.93           N  
ATOM   1137  CA  GLN    27      40.790  47.883   0.818  1.00 51.30           C  
ATOM   1138  CB  GLN    27      40.880  49.193   1.589  1.00 51.58           C  
ATOM   1139  CG  GLN    27      39.651  49.523   2.408  1.00 51.59           C  
ATOM   1140  CD  GLN    27      40.005  50.504   3.513  1.00 52.59           C  
ATOM   1141  OE1 GLN    27      40.855  51.376   3.301  1.00 57.18           O  
ATOM   1142  NE2 GLN    27      39.395  50.352   4.705  1.00 47.63           N  
ATOM   1143  C   GLN    27      41.784  47.854  -0.288  1.00 51.13           C  
ATOM   1144  O   GLN    27      42.718  48.634  -0.303  1.00 51.14           O  
ATOM   1145  N   LEU    28      41.581  46.907  -1.186  1.00 51.34           N  
ATOM   1146  CA  LEU    28      42.533  46.602  -2.222  1.00 51.53           C  
ATOM   1147  CB  LEU    28      43.388  45.390  -1.844  1.00 51.82           C  
ATOM   1148  CG  LEU    28      44.417  45.402  -0.707  1.00 52.24           C  
ATOM   1149  CD1 LEU    28      44.895  43.970  -0.469  1.00 53.58           C  
ATOM   1150  CD2 LEU    28      45.608  46.284  -1.015  1.00 51.65           C  
ATOM   1151  C   LEU    28      41.735  46.233  -3.430  1.00 51.61           C  
ATOM   1152  O   LEU    28      40.639  45.693  -3.341  1.00 51.58           O  
ATOM   1153  N   GLY    29      42.294  46.528  -4.580  1.00 52.42           N  
ATOM   1154  CA  GLY    29      41.641  46.189  -5.819  1.00 52.85           C  
ATOM   1155  C   GLY    29      41.988  44.757  -6.143  1.00 53.36           C  
ATOM   1156  O   GLY    29      42.916  44.153  -5.531  1.00 53.17           O  
ATOM   1157  N   PRO    30      41.295  44.205  -7.145  1.00 53.25           N  
ATOM   1158  CA  PRO    30      41.705  42.884  -7.543  1.00 53.02           C  
ATOM   1159  CB  PRO    30      40.734  42.547  -8.672  1.00 53.13           C  
ATOM   1160  CG  PRO    30      40.410  43.900  -9.290  1.00 52.75           C  
ATOM   1161  CD  PRO    30      40.292  44.775  -8.062  1.00 53.59           C  
ATOM   1162  C   PRO    30      43.078  43.193  -8.077  1.00 53.01           C  
ATOM   1163  O   PRO    30      43.350  44.381  -8.383  1.00 54.66           O  
ATOM   1164  N   GLU    31      43.956  42.223  -8.183  1.00 51.87           N  
ATOM   1165  CA  GLU    31      45.290  42.538  -8.729  1.00 51.91           C  
ATOM   1166  CB  GLU    31      45.234  43.438 -10.001  1.00 52.64           C  
ATOM   1167  CG  GLU    31      44.212  43.010 -11.088  1.00 54.99           C  
ATOM   1168  CD  GLU    31      44.468  41.589 -11.570  1.00 58.60           C  
ATOM   1169  OE1 GLU    31      45.587  41.387 -12.100  1.00 61.18           O  
ATOM   1170  OE2 GLU    31      43.590  40.688 -11.375  1.00 58.99           O  
ATOM   1171  C   GLU    31      46.291  43.147  -7.767  1.00 50.56           C  
ATOM   1172  O   GLU    31      47.457  43.132  -8.085  1.00 49.87           O  
ATOM   1173  N   ASP    32      45.879  43.688  -6.623  1.00 50.08           N  
ATOM   1174  CA  ASP    32      46.867  43.943  -5.552  1.00 49.96           C  
ATOM   1175  CB  ASP    32      46.415  44.986  -4.524  1.00 50.42           C  
ATOM   1176  CG  ASP    32      46.106  46.339  -5.137  1.00 52.23           C  
ATOM   1177  OD1 ASP    32      46.755  46.714  -6.137  1.00 49.25           O  
ATOM   1178  OD2 ASP    32      45.206  47.039  -4.583  1.00 56.11           O  
ATOM   1179  C   ASP    32      47.161  42.637  -4.810  1.00 49.17           C  
ATOM   1180  O   ASP    32      46.325  42.121  -4.090  1.00 49.32           O  
ATOM   1181  N   SER    33      48.361  42.112  -4.964  1.00 48.16           N  
ATOM   1182  CA  SER    33      48.732  40.910  -4.255  1.00 47.49           C  
ATOM   1183  CB  SER    33      50.137  40.523  -4.637  1.00 47.56           C  
ATOM   1184  OG  SER    33      50.154  40.261  -6.019  1.00 49.46           O  
ATOM   1185  C   SER    33      48.689  41.097  -2.767  1.00 46.69           C  
ATOM   1186  O   SER    33      48.962  42.183  -2.251  1.00 46.07           O  
ATOM   1187  N   ILE    34      48.380  39.995  -2.095  1.00 46.52           N  
ATOM   1188  CA  ILE    34      48.427  39.862  -0.650  1.00 45.49           C  
ATOM   1189  CB  ILE    34      47.045  39.603  -0.080  1.00 45.17           C  
ATOM   1190  CG1 ILE    34      46.457  38.309  -0.690  1.00 45.25           C  
ATOM   1191  CD1 ILE    34      45.695  37.367   0.276  1.00 44.50           C  
ATOM   1192  CG2 ILE    34      46.135  40.804  -0.339  1.00 42.34           C  
ATOM   1193  C   ILE    34      49.311  38.652  -0.340  1.00 45.62           C  
ATOM   1194  O   ILE    34      49.522  37.788  -1.180  1.00 45.44           O  
ATOM   1195  N   LEU    35      49.863  38.626   0.861  1.00 46.28           N  
ATOM   1196  CA  LEU    35      50.570  37.472   1.381  1.00 46.29           C  
ATOM   1197  CB  LEU    35      51.739  37.900   2.258  1.00 46.24           C  
ATOM   1198  CG  LEU    35      52.555  36.739   2.818  1.00 46.30           C  
ATOM   1199  CD1 LEU    35      53.202  35.964   1.632  1.00 43.82           C  
ATOM   1200  CD2 LEU    35      53.613  37.223   3.811  1.00 45.71           C  
ATOM   1201  C   LEU    35      49.570  36.734   2.224  1.00 46.83           C  
ATOM   1202  O   LEU    35      48.918  37.323   3.061  1.00 46.30           O  
ATOM   1203  N   ARG    36      49.422  35.449   1.998  1.00 47.99           N  
ATOM   1204  CA  ARG    36      48.435  34.723   2.731  1.00 49.43           C  
ATOM   1205  CB  ARG    36      47.475  34.086   1.784  1.00 50.62           C  
ATOM   1206  CG  ARG    36      46.181  33.772   2.453  1.00 53.89           C  
ATOM   1207  CD  ARG    36      45.692  32.395   2.149  1.00 59.18           C  
ATOM   1208  NE  ARG    36      44.273  32.418   2.300  1.00 60.92           N  
ATOM   1209  CZ  ARG    36      43.443  32.961   1.416  1.00 66.27           C  
ATOM   1210  NH1 ARG    36      43.904  33.493   0.245  1.00 67.71           N  
ATOM   1211  NH2 ARG    36      42.123  32.947   1.696  1.00 67.71           N  
ATOM   1212  C   ARG    36      49.139  33.650   3.441  1.00 49.82           C  
ATOM   1213  O   ARG    36      49.901  32.904   2.825  1.00 50.82           O  
ATOM   1214  N   MET    37      48.945  33.594   4.741  1.00 50.15           N  
ATOM   1215  CA  MET    37      49.644  32.619   5.577  1.00 50.53           C  
ATOM   1216  CB  MET    37      50.901  33.205   6.204  1.00 50.08           C  
ATOM   1217  CG  MET    37      50.757  34.217   7.314  1.00 51.20           C  
ATOM   1218  SD  MET    37      52.335  34.422   8.203  1.00 51.62           S  
ATOM   1219  CE  MET    37      52.342  32.968   9.266  1.00 49.85           C  
ATOM   1220  C   MET    37      48.714  32.010   6.607  1.00 50.57           C  
ATOM   1221  O   MET    37      47.775  32.655   7.100  1.00 49.67           O  
ATOM   1222  N   GLU    38      48.921  30.720   6.826  1.00 51.66           N  
ATOM   1223  CA  GLU    38      48.084  29.905   7.695  1.00 52.46           C  
ATOM   1224  CB  GLU    38      47.480  28.763   6.923  1.00 52.43           C  
ATOM   1225  CG  GLU    38      46.339  29.190   6.094  1.00 54.18           C  
ATOM   1226  CD  GLU    38      45.824  28.125   5.183  1.00 54.07           C  
ATOM   1227  OE1 GLU    38      46.293  26.963   5.227  1.00 55.92           O  
ATOM   1228  OE2 GLU    38      44.944  28.487   4.405  1.00 57.93           O  
ATOM   1229  C   GLU    38      48.987  29.308   8.722  1.00 53.53           C  
ATOM   1230  O   GLU    38      50.086  28.872   8.378  1.00 53.65           O  
ATOM   1231  N   ARG    39      48.515  29.216   9.952  1.00 54.36           N  
ATOM   1232  CA  ARG    39      49.404  28.937  11.052  1.00 56.22           C  
ATOM   1233  CB  ARG    39      49.977  30.287  11.452  1.00 56.60           C  
ATOM   1234  CG  ARG    39      50.997  30.297  12.521  1.00 59.42           C  
ATOM   1235  CD  ARG    39      50.693  31.391  13.599  1.00 61.15           C  
ATOM   1236  NE  ARG    39      50.895  32.768  13.118  1.00 64.98           N  
ATOM   1237  CZ  ARG    39      52.083  33.380  13.027  1.00 66.66           C  
ATOM   1238  NH1 ARG    39      53.217  32.762  13.369  1.00 63.65           N  
ATOM   1239  NH2 ARG    39      52.126  34.633  12.574  1.00 68.83           N  
ATOM   1240  C   ARG    39      48.649  28.274  12.212  1.00 55.31           C  
ATOM   1241  O   ARG    39      47.551  28.682  12.530  1.00 54.64           O  
ATOM   1242  N   ILE    40      49.226  27.219  12.786  1.00 55.53           N  
ATOM   1243  CA  ILE    40      48.746  26.595  14.045  1.00 55.67           C  
ATOM   1244  CB  ILE    40      48.675  25.052  13.921  1.00 55.53           C  
ATOM   1245  CG1 ILE    40      47.965  24.654  12.623  1.00 54.13           C  
ATOM   1246  CD1 ILE    40      47.875  23.195  12.381  1.00 53.68           C  
ATOM   1247  CG2 ILE    40      47.958  24.475  15.094  1.00 55.36           C  
ATOM   1248  C   ILE    40      49.695  26.964  15.203  1.00 55.60           C  
ATOM   1249  O   ILE    40      50.895  26.924  15.042  1.00 54.08           O  
ATOM   1250  N   ARG    41      49.137  27.350  16.345  1.00 57.05           N  
ATOM   1251  CA  ARG    41      49.902  27.583  17.594  1.00 58.60           C  
ATOM   1252  CB  ARG    41      49.682  28.995  18.158  1.00 58.57           C  
ATOM   1253  CG  ARG    41      49.935  30.085  17.095  1.00 61.65           C  
ATOM   1254  CD  ARG    41      49.835  31.558  17.607  1.00 62.04           C  
ATOM   1255  NE  ARG    41      51.139  31.967  18.140  1.00 66.00           N  
ATOM   1256  CZ  ARG    41      52.079  32.689  17.509  1.00 65.44           C  
ATOM   1257  NH1 ARG    41      51.896  33.213  16.287  1.00 64.96           N  
ATOM   1258  NH2 ARG    41      53.225  32.903  18.140  1.00 64.12           N  
ATOM   1259  C   ARG    41      49.502  26.565  18.644  1.00 58.53           C  
ATOM   1260  O   ARG    41      48.354  26.119  18.710  1.00 57.81           O  
ATOM   1261  N   PHE    42      50.486  26.228  19.466  1.00 59.74           N  
ATOM   1262  CA  PHE    42      50.416  25.142  20.452  1.00 60.45           C  
ATOM   1263  CB  PHE    42      51.484  24.072  20.118  1.00 60.37           C  
ATOM   1264  CG  PHE    42      51.318  23.453  18.750  1.00 60.19           C  
ATOM   1265  CD1 PHE    42      50.522  22.328  18.572  1.00 59.24           C  
ATOM   1266  CE1 PHE    42      50.346  21.767  17.321  1.00 59.71           C  
ATOM   1267  CZ  PHE    42      50.955  22.334  16.225  1.00 60.00           C  
ATOM   1268  CE2 PHE    42      51.753  23.466  16.386  1.00 60.33           C  
ATOM   1269  CD2 PHE    42      51.922  24.022  17.642  1.00 59.82           C  
ATOM   1270  C   PHE    42      50.722  25.709  21.819  1.00 60.81           C  
ATOM   1271  O   PHE    42      51.513  26.615  21.918  1.00 61.17           O  
ATOM   1272  N   ALA    43      50.076  25.194  22.859  1.00 61.79           N  
ATOM   1273  CA  ALA    43      50.533  25.351  24.245  1.00 62.22           C  
ATOM   1274  CB  ALA    43      49.509  26.094  25.129  1.00 61.58           C  
ATOM   1275  C   ALA    43      50.758  23.928  24.748  1.00 63.17           C  
ATOM   1276  O   ALA    43      49.905  23.034  24.556  1.00 63.19           O  
ATOM   1277  N   ASP    44      51.929  23.708  25.352  1.00 64.51           N  
ATOM   1278  CA  ASP    44      52.263  22.424  25.966  1.00 65.05           C  
ATOM   1279  CB  ASP    44      51.429  22.217  27.260  1.00 65.69           C  
ATOM   1280  CG  ASP    44      51.511  23.438  28.251  1.00 68.14           C  
ATOM   1281  OD1 ASP    44      52.666  23.772  28.637  1.00 71.73           O  
ATOM   1282  OD2 ASP    44      50.454  24.041  28.650  1.00 65.35           O  
ATOM   1283  C   ASP    44      51.977  21.358  24.900  1.00 65.21           C  
ATOM   1284  O   ASP    44      51.302  20.369  25.138  1.00 65.63           O  
ATOM   1285  N   ASP    45      52.449  21.627  23.694  1.00 65.40           N  
ATOM   1286  CA  ASP    45      52.261  20.737  22.540  1.00 65.59           C  
ATOM   1287  CB  ASP    45      53.142  19.503  22.669  1.00 66.51           C  
ATOM   1288  CG  ASP    45      54.378  19.605  21.773  1.00 71.38           C  
ATOM   1289  OD1 ASP    45      54.209  19.760  20.505  1.00 73.77           O  
ATOM   1290  OD2 ASP    45      55.511  19.566  22.353  1.00 76.92           O  
ATOM   1291  C   ASP    45      50.848  20.347  22.117  1.00 64.70           C  
ATOM   1292  O   ASP    45      50.673  19.473  21.255  1.00 64.29           O  
ATOM   1293  N   ILE    46      49.848  21.020  22.664  1.00 63.93           N  
ATOM   1294  CA  ILE    46      48.496  20.839  22.182  1.00 63.43           C  
ATOM   1295  CB  ILE    46      47.525  20.595  23.334  1.00 64.04           C  
ATOM   1296  CG1 ILE    46      48.179  19.651  24.391  1.00 64.30           C  
ATOM   1297  CD1 ILE    46      47.297  19.342  25.647  1.00 63.49           C  
ATOM   1298  CG2 ILE    46      46.167  20.104  22.784  1.00 63.48           C  
ATOM   1299  C   ILE    46      48.136  22.107  21.393  1.00 62.78           C  
ATOM   1300  O   ILE    46      48.405  23.229  21.845  1.00 62.44           O  
ATOM   1301  N   PRO    47      47.580  21.933  20.184  1.00 61.67           N  
ATOM   1302  CA  PRO    47      47.195  23.086  19.385  1.00 60.96           C  
ATOM   1303  CB  PRO    47      46.713  22.483  18.055  1.00 61.01           C  
ATOM   1304  CG  PRO    47      46.628  21.050  18.240  1.00 61.37           C  
ATOM   1305  CD  PRO    47      47.323  20.654  19.501  1.00 61.75           C  
ATOM   1306  C   PRO    47      46.063  23.861  20.027  1.00 59.95           C  
ATOM   1307  O   PRO    47      45.058  23.291  20.339  1.00 59.15           O  
ATOM   1308  N   ILE    48      46.241  25.166  20.179  1.00 59.29           N  
ATOM   1309  CA  ILE    48      45.215  26.050  20.695  1.00 58.54           C  
ATOM   1310  CB  ILE    48      45.834  27.215  21.489  1.00 58.42           C  
ATOM   1311  CG1 ILE    48      46.815  26.706  22.555  1.00 58.99           C  
ATOM   1312  CD1 ILE    48      46.200  25.695  23.593  1.00 58.08           C  
ATOM   1313  CG2 ILE    48      44.766  27.983  22.197  1.00 58.78           C  
ATOM   1314  C   ILE    48      44.408  26.645  19.542  1.00 58.31           C  
ATOM   1315  O   ILE    48      43.220  26.871  19.676  1.00 58.87           O  
ATOM   1316  N   CYS    49      45.035  26.913  18.403  1.00 57.41           N  
ATOM   1317  CA  CYS    49      44.395  27.763  17.414  1.00 56.65           C  
ATOM   1318  CB  CYS    49      44.422  29.212  17.923  1.00 56.74           C  
ATOM   1319  SG  CYS    49      46.012  30.016  17.879  1.00 59.53           S  
ATOM   1320  C   CYS    49      44.972  27.692  16.008  1.00 55.55           C  
ATOM   1321  O   CYS    49      46.112  27.347  15.771  1.00 55.76           O  
ATOM   1322  N   PHE    50      44.135  28.022  15.060  1.00 55.34           N  
ATOM   1323  CA  PHE    50      44.505  28.073  13.647  1.00 54.60           C  
ATOM   1324  CB  PHE    50      43.685  27.060  12.884  1.00 54.13           C  
ATOM   1325  CG  PHE    50      43.909  27.094  11.427  1.00 54.23           C  
ATOM   1326  CD1 PHE    50      44.902  26.337  10.862  1.00 54.72           C  
ATOM   1327  CE1 PHE    50      45.121  26.346   9.521  1.00 54.50           C  
ATOM   1328  CZ  PHE    50      44.354  27.121   8.737  1.00 54.82           C  
ATOM   1329  CE2 PHE    50      43.354  27.888   9.289  1.00 54.91           C  
ATOM   1330  CD2 PHE    50      43.124  27.865  10.617  1.00 54.51           C  
ATOM   1331  C   PHE    50      44.148  29.449  13.141  1.00 53.70           C  
ATOM   1332  O   PHE    50      43.010  29.926  13.330  1.00 54.12           O  
ATOM   1333  N   GLU    51      45.096  30.083  12.491  1.00 52.40           N  
ATOM   1334  CA  GLU    51      44.928  31.447  12.048  1.00 51.48           C  
ATOM   1335  CB  GLU    51      45.873  32.296  12.912  1.00 51.98           C  
ATOM   1336  CG  GLU    51      46.167  33.708  12.443  1.00 53.18           C  
ATOM   1337  CD  GLU    51      47.103  34.446  13.376  1.00 53.76           C  
ATOM   1338  OE1 GLU    51      46.623  34.789  14.522  1.00 60.44           O  
ATOM   1339  OE2 GLU    51      48.265  34.701  12.943  1.00 52.48           O  
ATOM   1340  C   GLU    51      45.243  31.598  10.555  1.00 49.93           C  
ATOM   1341  O   GLU    51      46.285  31.182  10.099  1.00 49.47           O  
ATOM   1342  N   VAL    52      44.350  32.218   9.813  1.00 49.02           N  
ATOM   1343  CA  VAL    52      44.660  32.667   8.461  1.00 48.32           C  
ATOM   1344  CB  VAL    52      43.472  32.436   7.472  1.00 47.93           C  
ATOM   1345  CG1 VAL    52      43.903  32.727   6.051  1.00 45.34           C  
ATOM   1346  CG2 VAL    52      43.016  31.060   7.602  1.00 46.90           C  
ATOM   1347  C   VAL    52      44.949  34.163   8.515  1.00 47.65           C  
ATOM   1348  O   VAL    52      44.144  34.941   9.011  1.00 47.93           O  
ATOM   1349  N   ALA    53      46.062  34.576   7.950  1.00 46.88           N  
ATOM   1350  CA  ALA    53      46.359  35.982   7.920  1.00 46.27           C  
ATOM   1351  CB  ALA    53      47.501  36.285   8.853  1.00 45.46           C  
ATOM   1352  C   ALA    53      46.658  36.432   6.489  1.00 45.29           C  
ATOM   1353  O   ALA    53      47.380  35.772   5.750  1.00 44.22           O  
ATOM   1354  N   SER    54      46.079  37.565   6.116  1.00 44.82           N  
ATOM   1355  CA  SER    54      46.326  38.148   4.820  1.00 45.05           C  
ATOM   1356  CB  SER    54      45.056  38.124   3.966  1.00 44.62           C  
ATOM   1357  OG  SER    54      44.801  36.823   3.452  1.00 40.96           O  
ATOM   1358  C   SER    54      46.868  39.573   4.956  1.00 45.50           C  
ATOM   1359  O   SER    54      46.253  40.408   5.572  1.00 46.84           O  
ATOM   1360  N   ILE    55      48.026  39.830   4.361  1.00 45.69           N  
ATOM   1361  CA  ILE    55      48.713  41.115   4.446  1.00 45.44           C  
ATOM   1362  CB  ILE    55      50.081  40.929   5.130  1.00 45.08           C  
ATOM   1363  CG1 ILE    55      49.873  40.333   6.514  1.00 44.34           C  
ATOM   1364  CD1 ILE    55      50.869  39.335   6.890  1.00 41.72           C  
ATOM   1365  CG2 ILE    55      50.855  42.244   5.197  1.00 44.78           C  
ATOM   1366  C   ILE    55      48.934  41.617   3.005  1.00 45.44           C  
ATOM   1367  O   ILE    55      49.293  40.848   2.150  1.00 44.57           O  
ATOM   1368  N   PRO    56      48.680  42.901   2.741  1.00 45.76           N  
ATOM   1369  CA  PRO    56      48.947  43.456   1.436  1.00 45.64           C  
ATOM   1370  CB  PRO    56      48.760  44.949   1.663  1.00 45.38           C  
ATOM   1371  CG  PRO    56      47.764  45.019   2.733  1.00 45.95           C  
ATOM   1372  CD  PRO    56      48.086  43.898   3.651  1.00 46.48           C  
ATOM   1373  C   PRO    56      50.376  43.144   1.072  1.00 45.83           C  
ATOM   1374  O   PRO    56      51.246  43.367   1.911  1.00 46.46           O  
ATOM   1375  N   TYR    57      50.633  42.596  -0.121  1.00 45.25           N  
ATOM   1376  CA  TYR    57      51.982  42.139  -0.410  1.00 45.86           C  
ATOM   1377  CB  TYR    57      52.075  41.239  -1.665  1.00 45.64           C  
ATOM   1378  CG  TYR    57      53.440  40.587  -1.840  1.00 44.64           C  
ATOM   1379  CD1 TYR    57      54.035  39.961  -0.775  1.00 43.06           C  
ATOM   1380  CE1 TYR    57      55.278  39.361  -0.870  1.00 43.55           C  
ATOM   1381  CZ  TYR    57      55.953  39.361  -2.038  1.00 44.64           C  
ATOM   1382  OH  TYR    57      57.180  38.720  -1.982  1.00 46.48           O  
ATOM   1383  CE2 TYR    57      55.400  39.976  -3.168  1.00 42.99           C  
ATOM   1384  CD2 TYR    57      54.130  40.595  -3.060  1.00 43.09           C  
ATOM   1385  C   TYR    57      52.914  43.325  -0.549  1.00 46.06           C  
ATOM   1386  O   TYR    57      54.090  43.198  -0.314  1.00 45.53           O  
ATOM   1387  N   SER    58      52.403  44.481  -0.940  1.00 47.17           N  
ATOM   1388  CA  SER    58      53.289  45.604  -1.162  1.00 48.11           C  
ATOM   1389  CB  SER    58      52.546  46.736  -1.780  1.00 47.99           C  
ATOM   1390  OG  SER    58      51.825  47.338  -0.740  1.00 50.25           O  
ATOM   1391  C   SER    58      53.900  46.119   0.131  1.00 49.09           C  
ATOM   1392  O   SER    58      54.949  46.691   0.082  1.00 49.71           O  
ATOM   1393  N   LEU    59      53.270  45.934   1.286  1.00 49.94           N  
ATOM   1394  CA  LEU    59      53.893  46.390   2.543  1.00 50.63           C  
ATOM   1395  CB  LEU    59      52.878  46.506   3.702  1.00 50.50           C  
ATOM   1396  CG  LEU    59      51.624  47.344   3.445  1.00 50.78           C  
ATOM   1397  CD1 LEU    59      50.496  46.975   4.439  1.00 48.14           C  
ATOM   1398  CD2 LEU    59      51.974  48.833   3.445  1.00 50.51           C  
ATOM   1399  C   LEU    59      54.969  45.464   3.046  1.00 51.77           C  
ATOM   1400  O   LEU    59      55.605  45.756   4.081  1.00 53.56           O  
ATOM   1401  N   VAL    60      55.161  44.331   2.387  1.00 52.04           N  
ATOM   1402  CA  VAL    60      55.871  43.229   3.035  1.00 52.07           C  
ATOM   1403  CB  VAL    60      54.772  42.272   3.638  1.00 52.60           C  
ATOM   1404  CG1 VAL    60      54.716  40.941   2.924  1.00 52.85           C  
ATOM   1405  CG2 VAL    60      54.911  42.154   5.171  1.00 51.04           C  
ATOM   1406  C   VAL    60      56.917  42.553   2.137  1.00 52.27           C  
ATOM   1407  O   VAL    60      57.747  41.784   2.635  1.00 52.19           O  
ATOM   1408  N   SER    61      56.880  42.892   0.835  1.00 52.26           N  
ATOM   1409  CA  SER    61      57.800  42.433  -0.175  1.00 52.56           C  
ATOM   1410  CB  SER    61      57.927  43.452  -1.302  1.00 52.22           C  
ATOM   1411  OG  SER    61      56.762  43.568  -2.023  1.00 50.76           O  
ATOM   1412  C   SER    61      59.193  42.334   0.339  1.00 54.01           C  
ATOM   1413  O   SER    61      59.937  41.452  -0.087  1.00 54.95           O  
ATOM   1414  N   GLN    62      59.589  43.309   1.154  1.00 54.80           N  
ATOM   1415  CA  GLN    62      60.990  43.507   1.448  1.00 55.39           C  
ATOM   1416  CB  GLN    62      61.327  44.993   1.483  1.00 55.61           C  
ATOM   1417  CG  GLN    62      60.892  45.798   0.261  1.00 57.32           C  
ATOM   1418  CD  GLN    62      61.375  45.233  -1.113  1.00 61.44           C  
ATOM   1419  OE1 GLN    62      62.586  44.979  -1.345  1.00 61.49           O  
ATOM   1420  NE2 GLN    62      60.415  45.074  -2.042  1.00 61.82           N  
ATOM   1421  C   GLN    62      61.378  42.844   2.746  1.00 55.11           C  
ATOM   1422  O   GLN    62      62.528  42.769   3.067  1.00 54.97           O  
ATOM   1423  N   TYR    63      60.432  42.331   3.490  1.00 55.62           N  
ATOM   1424  CA  TYR    63      60.788  41.624   4.715  1.00 56.61           C  
ATOM   1425  CB  TYR    63      59.704  41.790   5.806  1.00 57.30           C  
ATOM   1426  CG  TYR    63      59.279  43.248   6.011  1.00 58.09           C  
ATOM   1427  CD1 TYR    63      58.064  43.574   6.572  1.00 58.04           C  
ATOM   1428  CE1 TYR    63      57.699  44.901   6.742  1.00 59.17           C  
ATOM   1429  CZ  TYR    63      58.554  45.907   6.331  1.00 58.62           C  
ATOM   1430  OH  TYR    63      58.228  47.233   6.437  1.00 59.12           O  
ATOM   1431  CE2 TYR    63      59.743  45.605   5.784  1.00 58.72           C  
ATOM   1432  CD2 TYR    63      60.106  44.298   5.624  1.00 59.54           C  
ATOM   1433  C   TYR    63      61.008  40.192   4.340  1.00 56.32           C  
ATOM   1434  O   TYR    63      60.675  39.808   3.253  1.00 57.28           O  
ATOM   1435  N   GLY    64      61.609  39.421   5.221  1.00 56.27           N  
ATOM   1436  CA  GLY    64      61.839  38.027   4.986  1.00 56.20           C  
ATOM   1437  C   GLY    64      60.908  37.261   5.882  1.00 56.70           C  
ATOM   1438  O   GLY    64      60.444  37.767   6.892  1.00 56.87           O  
ATOM   1439  N   LYS    65      60.680  36.015   5.500  1.00 57.08           N  
ATOM   1440  CA  LYS    65      59.663  35.138   6.061  1.00 57.01           C  
ATOM   1441  CB  LYS    65      59.891  33.722   5.532  1.00 56.96           C  
ATOM   1442  CG  LYS    65      58.959  32.645   6.047  1.00 57.71           C  
ATOM   1443  CD  LYS    65      58.839  31.492   5.053  1.00 57.88           C  
ATOM   1444  CE  LYS    65      57.800  30.458   5.485  1.00 59.30           C  
ATOM   1445  NZ  LYS    65      57.469  29.549   4.343  1.00 60.81           N  
ATOM   1446  C   LYS    65      59.632  35.111   7.583  1.00 57.12           C  
ATOM   1447  O   LYS    65      58.538  35.116   8.186  1.00 56.36           O  
ATOM   1448  N   SER    66      60.822  35.052   8.184  1.00 56.97           N  
ATOM   1449  CA  SER    66      60.971  34.940   9.647  1.00 56.91           C  
ATOM   1450  CB  SER    66      62.448  34.856   9.990  1.00 56.99           C  
ATOM   1451  OG  SER    66      63.180  35.553   8.973  1.00 59.35           O  
ATOM   1452  C   SER    66      60.403  36.153  10.330  1.00 56.41           C  
ATOM   1453  O   SER    66      59.679  36.019  11.317  1.00 56.18           O  
ATOM   1454  N   GLU    67      60.774  37.333   9.818  1.00 56.50           N  
ATOM   1455  CA  GLU    67      60.273  38.615  10.305  1.00 56.88           C  
ATOM   1456  CB  GLU    67      60.755  39.796   9.461  1.00 56.55           C  
ATOM   1457  CG  GLU    67      62.205  40.138   9.614  1.00 57.12           C  
ATOM   1458  CD  GLU    67      62.722  41.072   8.519  1.00 57.60           C  
ATOM   1459  OE1 GLU    67      62.497  40.779   7.334  1.00 58.04           O  
ATOM   1460  OE2 GLU    67      63.384  42.091   8.836  1.00 59.58           O  
ATOM   1461  C   GLU    67      58.781  38.567  10.225  1.00 57.09           C  
ATOM   1462  O   GLU    67      58.098  38.769  11.217  1.00 57.13           O  
ATOM   1463  N   ILE    68      58.269  38.266   9.037  1.00 57.54           N  
ATOM   1464  CA  ILE    68      56.814  38.234   8.856  1.00 58.10           C  
ATOM   1465  CB  ILE    68      56.393  37.953   7.410  1.00 57.62           C  
ATOM   1466  CG1 ILE    68      56.836  39.140   6.535  1.00 57.78           C  
ATOM   1467  CD1 ILE    68      56.783  38.930   5.025  1.00 57.61           C  
ATOM   1468  CG2 ILE    68      54.889  37.726   7.363  1.00 56.58           C  
ATOM   1469  C   ILE    68      56.138  37.257   9.778  1.00 58.31           C  
ATOM   1470  O   ILE    68      55.095  37.568  10.307  1.00 58.35           O  
ATOM   1471  N   THR    69      56.735  36.093   9.983  1.00 59.31           N  
ATOM   1472  CA  THR    69      56.082  35.034  10.738  1.00 60.56           C  
ATOM   1473  CB  THR    69      56.573  33.624  10.343  1.00 60.50           C  
ATOM   1474  OG1 THR    69      57.922  33.690   9.870  1.00 62.21           O  
ATOM   1475  CG2 THR    69      55.714  33.060   9.218  1.00 60.20           C  
ATOM   1476  C   THR    69      56.181  35.232  12.230  1.00 61.36           C  
ATOM   1477  O   THR    69      55.188  35.041  12.915  1.00 62.44           O  
ATOM   1478  N   ASN    70      57.330  35.675  12.734  1.00 62.34           N  
ATOM   1479  CA  ASN    70      57.538  35.792  14.196  1.00 62.99           C  
ATOM   1480  CB  ASN    70      58.825  35.062  14.641  1.00 63.60           C  
ATOM   1481  CG  ASN    70      59.089  33.775  13.853  1.00 65.59           C  
ATOM   1482  OD1 ASN    70      59.995  33.727  13.000  1.00 67.25           O  
ATOM   1483  ND2 ASN    70      58.278  32.741  14.108  1.00 66.68           N  
ATOM   1484  C   ASN    70      57.610  37.229  14.759  1.00 63.58           C  
ATOM   1485  O   ASN    70      57.522  37.413  15.964  1.00 64.54           O  
ATOM   1486  N   SER    71      57.793  38.243  13.926  1.00 63.29           N  
ATOM   1487  CA  SER    71      58.109  39.576  14.444  1.00 62.82           C  
ATOM   1488  CB  SER    71      59.602  39.841  14.229  1.00 63.27           C  
ATOM   1489  OG  SER    71      60.374  38.706  14.576  1.00 64.10           O  
ATOM   1490  C   SER    71      57.308  40.621  13.703  1.00 62.07           C  
ATOM   1491  O   SER    71      57.796  41.724  13.403  1.00 61.87           O  
ATOM   1492  N   PHE    72      56.075  40.266  13.375  1.00 60.95           N  
ATOM   1493  CA  PHE    72      55.352  41.039  12.380  1.00 60.62           C  
ATOM   1494  CB  PHE    72      54.002  40.394  12.068  1.00 59.71           C  
ATOM   1495  CG  PHE    72      53.226  41.113  11.017  1.00 59.52           C  
ATOM   1496  CD1 PHE    72      53.869  41.651   9.898  1.00 57.25           C  
ATOM   1497  CE1 PHE    72      53.161  42.310   8.924  1.00 56.85           C  
ATOM   1498  CZ  PHE    72      51.795  42.433   9.043  1.00 57.63           C  
ATOM   1499  CE2 PHE    72      51.135  41.900  10.152  1.00 58.57           C  
ATOM   1500  CD2 PHE    72      51.854  41.242  11.131  1.00 58.26           C  
ATOM   1501  C   PHE    72      55.169  42.477  12.834  1.00 60.35           C  
ATOM   1502  O   PHE    72      55.526  43.423  12.124  1.00 60.09           O  
ATOM   1503  N   TYR    73      54.650  42.627  14.043  1.00 60.53           N  
ATOM   1504  CA  TYR    73      54.369  43.945  14.559  1.00 60.68           C  
ATOM   1505  CB  TYR    73      53.544  43.817  15.820  1.00 60.60           C  
ATOM   1506  CG  TYR    73      52.115  43.401  15.588  1.00 60.57           C  
ATOM   1507  CD1 TYR    73      51.488  43.600  14.351  1.00 60.33           C  
ATOM   1508  CE1 TYR    73      50.146  43.243  14.133  1.00 59.59           C  
ATOM   1509  CZ  TYR    73      49.411  42.686  15.149  1.00 61.24           C  
ATOM   1510  OH  TYR    73      48.086  42.340  14.905  1.00 60.98           O  
ATOM   1511  CE2 TYR    73      50.009  42.473  16.414  1.00 61.73           C  
ATOM   1512  CD2 TYR    73      51.359  42.840  16.622  1.00 61.38           C  
ATOM   1513  C   TYR    73      55.654  44.744  14.766  1.00 60.62           C  
ATOM   1514  O   TYR    73      55.789  45.842  14.200  1.00 59.42           O  
ATOM   1515  N   LYS    74      56.582  44.167  15.544  1.00 61.09           N  
ATOM   1516  CA  LYS    74      57.967  44.672  15.664  1.00 61.36           C  
ATOM   1517  CB  LYS    74      58.948  43.599  16.243  1.00 61.82           C  
ATOM   1518  CG  LYS    74      58.562  42.915  17.610  1.00 64.03           C  
ATOM   1519  CD  LYS    74      58.799  43.809  18.865  1.00 65.00           C  
ATOM   1520  CE  LYS    74      57.616  43.822  19.899  1.00 64.60           C  
ATOM   1521  NZ  LYS    74      57.615  42.683  20.891  1.00 64.65           N  
ATOM   1522  C   LYS    74      58.521  45.115  14.310  1.00 61.44           C  
ATOM   1523  O   LYS    74      58.907  46.270  14.108  1.00 61.82           O  
ATOM   1524  N   THR    75      58.576  44.187  13.370  1.00 61.19           N  
ATOM   1525  CA  THR    75      59.240  44.460  12.111  1.00 61.24           C  
ATOM   1526  CB  THR    75      59.231  43.219  11.204  1.00 61.50           C  
ATOM   1527  OG1 THR    75      59.816  42.122  11.934  1.00 60.59           O  
ATOM   1528  CG2 THR    75      59.983  43.472   9.865  1.00 59.89           C  
ATOM   1529  C   THR    75      58.579  45.602  11.415  1.00 61.11           C  
ATOM   1530  O   THR    75      59.240  46.425  10.828  1.00 61.07           O  
ATOM   1531  N   LEU    76      57.262  45.647  11.501  1.00 61.67           N  
ATOM   1532  CA  LEU    76      56.463  46.619  10.753  1.00 62.50           C  
ATOM   1533  CB  LEU    76      54.988  46.319  10.992  1.00 62.04           C  
ATOM   1534  CG  LEU    76      53.996  46.464   9.848  1.00 62.11           C  
ATOM   1535  CD1 LEU    76      54.586  46.209   8.487  1.00 60.53           C  
ATOM   1536  CD2 LEU    76      52.833  45.533  10.124  1.00 62.29           C  
ATOM   1537  C   LEU    76      56.789  48.044  11.183  1.00 63.29           C  
ATOM   1538  O   LEU    76      57.062  48.928  10.352  1.00 63.03           O  
ATOM   1539  N   GLU    77      56.779  48.231  12.504  1.00 64.51           N  
ATOM   1540  CA  GLU    77      57.104  49.504  13.143  1.00 65.40           C  
ATOM   1541  CB  GLU    77      56.608  49.528  14.594  1.00 66.12           C  
ATOM   1542  CG  GLU    77      55.290  50.300  14.752  1.00 67.50           C  
ATOM   1543  CD  GLU    77      54.557  49.980  16.045  1.00 68.10           C  
ATOM   1544  OE1 GLU    77      54.968  49.028  16.755  1.00 72.45           O  
ATOM   1545  OE2 GLU    77      53.547  50.668  16.341  1.00 71.93           O  
ATOM   1546  C   GLU    77      58.587  49.836  13.098  1.00 65.52           C  
ATOM   1547  O   GLU    77      58.932  50.947  12.739  1.00 66.33           O  
ATOM   1548  N   ALA    78      59.474  48.895  13.422  1.00 65.34           N  
ATOM   1549  CA  ALA    78      60.910  49.135  13.169  1.00 65.44           C  
ATOM   1550  CB  ALA    78      61.771  47.904  13.524  1.00 64.89           C  
ATOM   1551  C   ALA    78      61.223  49.604  11.729  1.00 65.37           C  
ATOM   1552  O   ALA    78      62.213  50.280  11.528  1.00 66.10           O  
ATOM   1553  N   LYS    79      60.404  49.262  10.737  1.00 65.47           N  
ATOM   1554  CA  LYS    79      60.795  49.490   9.345  1.00 65.81           C  
ATOM   1555  CB  LYS    79      60.943  48.167   8.588  1.00 65.64           C  
ATOM   1556  CG  LYS    79      61.991  47.223   9.179  1.00 66.33           C  
ATOM   1557  CD  LYS    79      62.897  46.592   8.096  1.00 65.98           C  
ATOM   1558  CE  LYS    79      63.660  45.370   8.622  1.00 65.01           C  
ATOM   1559  NZ  LYS    79      64.861  45.060   7.802  1.00 65.44           N  
ATOM   1560  C   LYS    79      59.891  50.401   8.538  1.00 66.08           C  
ATOM   1561  O   LYS    79      60.391  51.292   7.858  1.00 66.12           O  
ATOM   1562  N   SER    80      58.574  50.182   8.589  1.00 66.35           N  
ATOM   1563  CA  SER    80      57.687  50.703   7.521  1.00 66.13           C  
ATOM   1564  CB  SER    80      56.305  50.075   7.622  1.00 65.90           C  
ATOM   1565  OG  SER    80      55.872  50.120   8.952  1.00 64.81           O  
ATOM   1566  C   SER    80      57.564  52.221   7.516  1.00 66.30           C  
ATOM   1567  O   SER    80      57.103  52.811   6.510  1.00 65.64           O  
ATOM   1568  N   GLY    81      58.002  52.835   8.629  1.00 66.65           N  
ATOM   1569  CA  GLY    81      57.761  54.241   8.894  1.00 66.81           C  
ATOM   1570  C   GLY    81      56.253  54.415   8.915  1.00 67.35           C  
ATOM   1571  O   GLY    81      55.673  55.038   8.024  1.00 68.26           O  
ATOM   1572  N   HIS    82      55.617  53.773   9.883  1.00 67.09           N  
ATOM   1573  CA  HIS    82      54.189  53.900  10.133  1.00 66.75           C  
ATOM   1574  CB  HIS    82      53.341  53.027   9.220  1.00 66.86           C  
ATOM   1575  CG  HIS    82      53.173  53.542   7.831  1.00 67.50           C  
ATOM   1576  ND1 HIS    82      53.553  52.811   6.722  1.00 68.26           N  
ATOM   1577  CE1 HIS    82      53.272  53.498   5.629  1.00 68.32           C  
ATOM   1578  NE2 HIS    82      52.707  54.638   5.990  1.00 68.21           N  
ATOM   1579  CD2 HIS    82      52.630  54.688   7.362  1.00 67.56           C  
ATOM   1580  C   HIS    82      53.994  53.372  11.535  1.00 66.25           C  
ATOM   1581  O   HIS    82      54.817  52.606  12.055  1.00 65.10           O  
ATOM   1582  N   LYS    83      52.884  53.765  12.132  1.00 66.31           N  
ATOM   1583  CA  LYS    83      52.539  53.270  13.446  1.00 66.73           C  
ATOM   1584  CB  LYS    83      52.354  54.433  14.433  1.00 67.46           C  
ATOM   1585  CG  LYS    83      53.643  55.208  14.738  1.00 69.09           C  
ATOM   1586  CD  LYS    83      54.688  54.330  15.476  1.00 71.26           C  
ATOM   1587  CE  LYS    83      55.970  55.086  15.811  1.00 71.11           C  
ATOM   1588  NZ  LYS    83      56.192  54.969  17.289  1.00 73.94           N  
ATOM   1589  C   LYS    83      51.284  52.425  13.369  1.00 65.95           C  
ATOM   1590  O   LYS    83      50.337  52.740  12.641  1.00 65.91           O  
ATOM   1591  N   ILE    84      51.309  51.333  14.108  1.00 65.12           N  
ATOM   1592  CA  ILE    84      50.148  50.486  14.251  1.00 65.44           C  
ATOM   1593  CB  ILE    84      50.515  49.190  15.062  1.00 65.60           C  
ATOM   1594  CG1 ILE    84      51.538  48.359  14.250  1.00 64.73           C  
ATOM   1595  CD1 ILE    84      51.959  47.057  14.905  1.00 64.78           C  
ATOM   1596  CG2 ILE    84      49.236  48.398  15.428  1.00 64.02           C  
ATOM   1597  C   ILE    84      48.996  51.270  14.927  1.00 65.59           C  
ATOM   1598  O   ILE    84      49.115  51.653  16.082  1.00 65.54           O  
ATOM   1599  N   GLY    85      47.904  51.517  14.197  1.00 65.25           N  
ATOM   1600  CA  GLY    85      46.768  52.288  14.728  1.00 64.93           C  
ATOM   1601  C   GLY    85      45.663  51.440  15.352  1.00 64.53           C  
ATOM   1602  O   GLY    85      45.914  50.558  16.166  1.00 64.19           O  
ATOM   1603  N   HIS    86      44.428  51.695  14.949  1.00 64.41           N  
ATOM   1604  CA  HIS    86      43.296  50.974  15.518  1.00 64.33           C  
ATOM   1605  CB  HIS    86      41.995  51.706  15.174  1.00 65.12           C  
ATOM   1606  CG  HIS    86      41.898  53.057  15.823  1.00 68.01           C  
ATOM   1607  ND1 HIS    86      41.389  54.168  15.174  1.00 70.34           N  
ATOM   1608  CE1 HIS    86      41.466  55.217  15.979  1.00 70.57           C  
ATOM   1609  NE2 HIS    86      42.015  54.830  17.122  1.00 69.63           N  
ATOM   1610  CD2 HIS    86      42.294  53.485  17.052  1.00 69.08           C  
ATOM   1611  C   HIS    86      43.220  49.534  15.037  1.00 63.87           C  
ATOM   1612  O   HIS    86      43.816  49.168  14.021  1.00 64.68           O  
ATOM   1613  N   SER    87      42.481  48.707  15.761  1.00 62.43           N  
ATOM   1614  CA  SER    87      42.098  47.398  15.238  1.00 60.99           C  
ATOM   1615  CB  SER    87      43.023  46.299  15.753  1.00 60.91           C  
ATOM   1616  OG  SER    87      42.711  46.043  17.107  1.00 62.22           O  
ATOM   1617  C   SER    87      40.652  47.132  15.634  1.00 59.77           C  
ATOM   1618  O   SER    87      40.094  47.804  16.499  1.00 59.93           O  
ATOM   1619  N   ASN    88      40.015  46.197  14.950  1.00 58.14           N  
ATOM   1620  CA  ASN    88      38.681  45.797  15.334  1.00 56.49           C  
ATOM   1621  CB  ASN    88      37.644  46.733  14.701  1.00 56.62           C  
ATOM   1622  CG  ASN    88      37.519  46.561  13.233  1.00 59.15           C  
ATOM   1623  OD1 ASN    88      37.089  45.492  12.758  1.00 63.48           O  
ATOM   1624  ND2 ASN    88      37.850  47.615  12.475  1.00 60.78           N  
ATOM   1625  C   ASN    88      38.464  44.284  15.144  1.00 54.58           C  
ATOM   1626  O   ASN    88      39.161  43.619  14.395  1.00 54.18           O  
ATOM   1627  N   GLN    89      37.567  43.731  15.925  1.00 52.67           N  
ATOM   1628  CA  GLN    89      37.459  42.302  16.090  1.00 51.84           C  
ATOM   1629  CB  GLN    89      38.092  41.909  17.414  1.00 51.40           C  
ATOM   1630  CG  GLN    89      39.559  41.784  17.376  1.00 51.50           C  
ATOM   1631  CD  GLN    89      40.148  41.727  18.756  1.00 52.26           C  
ATOM   1632  OE1 GLN    89      39.634  42.399  19.668  1.00 55.51           O  
ATOM   1633  NE2 GLN    89      41.232  40.944  18.932  1.00 44.23           N  
ATOM   1634  C   GLN    89      36.000  41.920  16.128  1.00 50.38           C  
ATOM   1635  O   GLN    89      35.183  42.644  16.653  1.00 49.53           O  
ATOM   1636  N   THR    90      35.682  40.768  15.583  1.00 50.07           N  
ATOM   1637  CA  THR    90      34.317  40.271  15.572  1.00 50.31           C  
ATOM   1638  CB  THR    90      33.694  40.352  14.174  1.00 50.38           C  
ATOM   1639  OG1 THR    90      33.857  41.686  13.683  1.00 51.12           O  
ATOM   1640  CG2 THR    90      32.185  40.012  14.187  1.00 49.21           C  
ATOM   1641  C   THR    90      34.407  38.853  16.044  1.00 50.10           C  
ATOM   1642  O   THR    90      35.054  38.020  15.407  1.00 51.56           O  
ATOM   1643  N   ILE    91      33.800  38.599  17.194  1.00 49.46           N  
ATOM   1644  CA  ILE    91      33.896  37.323  17.867  1.00 49.05           C  
ATOM   1645  CB  ILE    91      34.143  37.533  19.342  1.00 49.09           C  
ATOM   1646  CG1 ILE    91      35.359  38.449  19.522  1.00 48.77           C  
ATOM   1647  CD1 ILE    91      35.589  38.748  20.945  1.00 49.36           C  
ATOM   1648  CG2 ILE    91      34.354  36.197  20.046  1.00 48.53           C  
ATOM   1649  C   ILE    91      32.621  36.535  17.691  1.00 48.72           C  
ATOM   1650  O   ILE    91      31.554  37.040  17.947  1.00 48.31           O  
ATOM   1651  N   SER    92      32.734  35.303  17.212  1.00 48.65           N  
ATOM   1652  CA  SER    92      31.569  34.441  17.071  1.00 48.92           C  
ATOM   1653  CB  SER    92      31.054  34.481  15.636  1.00 48.51           C  
ATOM   1654  OG  SER    92      32.098  34.168  14.726  1.00 48.47           O  
ATOM   1655  C   SER    92      31.965  33.038  17.430  1.00 48.69           C  
ATOM   1656  O   SER    92      33.117  32.765  17.684  1.00 48.83           O  
ATOM   1657  N   ALA    93      30.987  32.161  17.443  1.00 49.88           N  
ATOM   1658  CA  ALA    93      31.148  30.772  17.782  1.00 50.89           C  
ATOM   1659  CB  ALA    93      30.271  30.454  18.926  1.00 50.66           C  
ATOM   1660  C   ALA    93      30.746  29.924  16.570  1.00 51.92           C  
ATOM   1661  O   ALA    93      29.742  30.171  15.960  1.00 51.99           O  
ATOM   1662  N   VAL    94      31.539  28.918  16.238  1.00 53.30           N  
ATOM   1663  CA  VAL    94      31.309  28.105  15.060  1.00 54.08           C  
ATOM   1664  CB  VAL    94      32.133  28.663  13.895  1.00 54.37           C  
ATOM   1665  CG1 VAL    94      32.156  27.709  12.760  1.00 55.01           C  
ATOM   1666  CG2 VAL    94      31.514  29.974  13.435  1.00 54.26           C  
ATOM   1667  C   VAL    94      31.695  26.653  15.325  1.00 54.83           C  
ATOM   1668  O   VAL    94      32.545  26.370  16.132  1.00 54.71           O  
ATOM   1669  N   GLN    95      31.062  25.725  14.634  1.00 56.09           N  
ATOM   1670  CA  GLN    95      31.480  24.315  14.711  1.00 56.95           C  
ATOM   1671  CB  GLN    95      30.389  23.439  14.118  1.00 57.33           C  
ATOM   1672  CG  GLN    95      29.005  23.814  14.561  1.00 58.13           C  
ATOM   1673  CD  GLN    95      28.123  22.635  14.519  1.00 60.37           C  
ATOM   1674  OE1 GLN    95      27.422  22.426  13.548  1.00 61.67           O  
ATOM   1675  NE2 GLN    95      28.208  21.793  15.543  1.00 62.95           N  
ATOM   1676  C   GLN    95      32.760  24.047  13.932  1.00 57.26           C  
ATOM   1677  O   GLN    95      32.947  24.610  12.870  1.00 57.40           O  
ATOM   1678  N   ALA    96      33.618  23.165  14.424  1.00 58.08           N  
ATOM   1679  CA  ALA    96      34.857  22.818  13.699  1.00 58.74           C  
ATOM   1680  CB  ALA    96      35.737  21.976  14.556  1.00 58.50           C  
ATOM   1681  C   ALA    96      34.548  22.075  12.420  1.00 59.31           C  
ATOM   1682  O   ALA    96      33.764  21.131  12.431  1.00 59.39           O  
ATOM   1683  N   SER    97      35.133  22.525  11.312  1.00 60.42           N  
ATOM   1684  CA  SER    97      35.107  21.767  10.043  1.00 61.00           C  
ATOM   1685  CB  SER    97      35.525  22.640   8.873  1.00 60.27           C  
ATOM   1686  OG  SER    97      36.930  22.787   8.865  1.00 60.13           O  
ATOM   1687  C   SER    97      36.038  20.540  10.141  1.00 62.02           C  
ATOM   1688  O   SER    97      36.840  20.395  11.092  1.00 62.18           O  
ATOM   1689  N   GLU    98      35.921  19.644   9.168  1.00 63.43           N  
ATOM   1690  CA  GLU    98      36.724  18.429   9.189  1.00 63.96           C  
ATOM   1691  CB  GLU    98      36.449  17.617   7.939  1.00 64.18           C  
ATOM   1692  CG  GLU    98      37.235  16.294   7.807  1.00 65.28           C  
ATOM   1693  CD  GLU    98      37.186  15.778   6.340  1.00 67.67           C  
ATOM   1694  OE1 GLU    98      36.177  16.062   5.603  1.00 70.33           O  
ATOM   1695  OE2 GLU    98      38.170  15.105   5.923  1.00 73.63           O  
ATOM   1696  C   GLU    98      38.171  18.852   9.219  1.00 63.92           C  
ATOM   1697  O   GLU    98      38.965  18.389  10.034  1.00 64.26           O  
ATOM   1698  N   GLN    99      38.469  19.778   8.317  1.00 64.07           N  
ATOM   1699  CA  GLN    99      39.791  20.361   8.141  1.00 63.67           C  
ATOM   1700  CB  GLN    99      39.680  21.417   7.026  1.00 63.80           C  
ATOM   1701  CG  GLN    99      40.968  22.048   6.632  1.00 64.58           C  
ATOM   1702  CD  GLN    99      42.010  21.014   6.225  1.00 68.17           C  
ATOM   1703  OE1 GLN    99      42.632  20.319   7.085  1.00 67.56           O  
ATOM   1704  NE2 GLN    99      42.223  20.903   4.893  1.00 68.03           N  
ATOM   1705  C   GLN    99      40.368  20.979   9.425  1.00 63.32           C  
ATOM   1706  O   GLN    99      41.448  20.599   9.902  1.00 63.41           O  
ATOM   1707  N   ILE   100      39.632  21.926   9.995  1.00 62.96           N  
ATOM   1708  CA  ILE   100      40.076  22.574  11.229  1.00 62.69           C  
ATOM   1709  CB  ILE   100      39.236  23.842  11.556  1.00 62.67           C  
ATOM   1710  CG1 ILE   100      39.880  25.041  10.847  1.00 61.31           C  
ATOM   1711  CD1 ILE   100      38.927  26.034  10.434  1.00 59.86           C  
ATOM   1712  CG2 ILE   100      39.161  24.080  13.080  1.00 61.97           C  
ATOM   1713  C   ILE   100      40.116  21.592  12.380  1.00 62.13           C  
ATOM   1714  O   ILE   100      40.942  21.721  13.267  1.00 62.00           O  
ATOM   1715  N   ALA   101      39.253  20.589  12.340  1.00 61.83           N  
ATOM   1716  CA  ALA   101      39.336  19.520  13.310  1.00 62.17           C  
ATOM   1717  CB  ALA   101      38.199  18.570  13.123  1.00 61.70           C  
ATOM   1718  C   ALA   101      40.694  18.795  13.197  1.00 62.19           C  
ATOM   1719  O   ALA   101      41.392  18.630  14.221  1.00 60.67           O  
ATOM   1720  N   GLU   102      41.073  18.393  11.969  1.00 62.42           N  
ATOM   1721  CA  GLU   102      42.357  17.703  11.767  1.00 63.31           C  
ATOM   1722  CB  GLU   102      42.724  17.461  10.316  1.00 63.78           C  
ATOM   1723  CG  GLU   102      41.729  16.671   9.432  1.00 66.53           C  
ATOM   1724  CD  GLU   102      42.277  16.510   7.986  1.00 66.96           C  
ATOM   1725  OE1 GLU   102      43.521  16.232   7.884  1.00 71.08           O  
ATOM   1726  OE2 GLU   102      41.490  16.674   6.990  1.00 68.24           O  
ATOM   1727  C   GLU   102      43.454  18.554  12.320  1.00 62.80           C  
ATOM   1728  O   GLU   102      44.252  18.076  13.091  1.00 62.23           O  
ATOM   1729  N   TYR   103      43.485  19.826  11.921  1.00 62.90           N  
ATOM   1730  CA  TYR   103      44.544  20.755  12.375  1.00 62.73           C  
ATOM   1731  CB  TYR   103      44.362  22.135  11.760  1.00 62.49           C  
ATOM   1732  CG  TYR   103      44.619  22.266  10.289  1.00 62.53           C  
ATOM   1733  CD1 TYR   103      45.700  21.623   9.675  1.00 63.11           C  
ATOM   1734  CE1 TYR   103      45.945  21.768   8.313  1.00 61.14           C  
ATOM   1735  CZ  TYR   103      45.124  22.584   7.588  1.00 62.08           C  
ATOM   1736  OH  TYR   103      45.346  22.759   6.274  1.00 63.69           O  
ATOM   1737  CE2 TYR   103      44.058  23.256   8.167  1.00 62.30           C  
ATOM   1738  CD2 TYR   103      43.824  23.110   9.511  1.00 61.89           C  
ATOM   1739  C   TYR   103      44.587  20.984  13.883  1.00 62.42           C  
ATOM   1740  O   TYR   103      45.650  21.129  14.473  1.00 62.16           O  
ATOM   1741  N   LEU   104      43.430  21.100  14.504  1.00 62.63           N  
ATOM   1742  CA  LEU   104      43.413  21.403  15.924  1.00 62.76           C  
ATOM   1743  CB  LEU   104      42.288  22.384  16.223  1.00 62.29           C  
ATOM   1744  CG  LEU   104      42.546  23.812  15.738  1.00 60.70           C  
ATOM   1745  CD1 LEU   104      41.356  24.668  16.016  1.00 59.52           C  
ATOM   1746  CD2 LEU   104      43.722  24.405  16.452  1.00 61.29           C  
ATOM   1747  C   LEU   104      43.326  20.136  16.767  1.00 62.85           C  
ATOM   1748  O   LEU   104      43.361  20.191  17.973  1.00 62.42           O  
ATOM   1749  N   GLU   105      43.264  18.979  16.121  1.00 63.87           N  
ATOM   1750  CA  GLU   105      43.254  17.711  16.846  1.00 64.37           C  
ATOM   1751  CB  GLU   105      44.527  17.535  17.677  1.00 64.45           C  
ATOM   1752  CG  GLU   105      45.745  17.965  16.936  1.00 64.99           C  
ATOM   1753  CD  GLU   105      46.998  17.308  17.407  1.00 65.13           C  
ATOM   1754  OE1 GLU   105      47.370  17.383  18.595  1.00 68.92           O  
ATOM   1755  OE2 GLU   105      47.643  16.722  16.550  1.00 67.31           O  
ATOM   1756  C   GLU   105      42.054  17.693  17.757  1.00 64.54           C  
ATOM   1757  O   GLU   105      42.208  17.565  18.965  1.00 63.71           O  
ATOM   1758  N   ILE   106      40.878  17.868  17.149  1.00 64.94           N  
ATOM   1759  CA  ILE   106      39.591  17.780  17.825  1.00 65.25           C  
ATOM   1760  CB  ILE   106      39.102  19.168  18.315  1.00 65.36           C  
ATOM   1761  CG1 ILE   106      38.867  20.115  17.123  1.00 65.59           C  
ATOM   1762  CD1 ILE   106      38.648  21.547  17.524  1.00 64.73           C  
ATOM   1763  CG2 ILE   106      40.110  19.756  19.320  1.00 63.53           C  
ATOM   1764  C   ILE   106      38.675  17.175  16.783  1.00 65.80           C  
ATOM   1765  O   ILE   106      39.173  16.785  15.717  1.00 65.53           O  
ATOM   1766  N   LYS   107      37.363  17.116  17.065  1.00 66.52           N  
ATOM   1767  CA  LYS   107      36.376  16.437  16.178  1.00 66.94           C  
ATOM   1768  CB  LYS   107      35.423  15.584  17.038  1.00 67.40           C  
ATOM   1769  CG  LYS   107      36.134  14.699  18.116  1.00 69.02           C  
ATOM   1770  CD  LYS   107      35.427  13.293  18.357  1.00 69.15           C  
ATOM   1771  CE  LYS   107      36.386  12.207  18.985  1.00 69.46           C  
ATOM   1772  NZ  LYS   107      36.493  12.271  20.481  1.00 70.41           N  
ATOM   1773  C   LYS   107      35.528  17.406  15.352  1.00 66.62           C  
ATOM   1774  O   LYS   107      35.182  18.459  15.878  1.00 66.80           O  
ATOM   1775  N   ARG   108      35.166  17.049  14.101  1.00 66.31           N  
ATOM   1776  CA  ARG   108      34.150  17.805  13.317  1.00 66.14           C  
ATOM   1777  CB  ARG   108      33.649  17.064  11.990  1.00 66.38           C  
ATOM   1778  CG  ARG   108      32.615  17.840  10.965  1.00 67.02           C  
ATOM   1779  CD  ARG   108      32.940  17.842   9.325  1.00 68.03           C  
ATOM   1780  NE  ARG   108      32.397  19.042   8.542  1.00 70.42           N  
ATOM   1781  CZ  ARG   108      32.875  19.595   7.383  1.00 69.42           C  
ATOM   1782  NH1 ARG   108      33.914  19.119   6.762  1.00 71.23           N  
ATOM   1783  NH2 ARG   108      32.315  20.658   6.812  1.00 68.63           N  
ATOM   1784  C   ARG   108      33.042  18.060  14.355  1.00 65.64           C  
ATOM   1785  O   ARG   108      32.809  17.220  15.228  1.00 65.83           O  
ATOM   1786  N   GLY   109      32.446  19.250  14.335  1.00 64.45           N  
ATOM   1787  CA  GLY   109      31.366  19.562  15.229  1.00 63.52           C  
ATOM   1788  C   GLY   109      31.773  20.342  16.456  1.00 62.89           C  
ATOM   1789  O   GLY   109      30.974  21.104  16.989  1.00 63.61           O  
ATOM   1790  N   ASP   110      32.997  20.160  16.921  1.00 61.84           N  
ATOM   1791  CA  ASP   110      33.435  20.771  18.168  1.00 60.95           C  
ATOM   1792  CB  ASP   110      34.856  20.298  18.533  1.00 62.00           C  
ATOM   1793  CG  ASP   110      34.869  18.980  19.280  1.00 63.76           C  
ATOM   1794  OD1 ASP   110      33.771  18.501  19.596  1.00 67.38           O  
ATOM   1795  OD2 ASP   110      35.966  18.434  19.564  1.00 67.68           O  
ATOM   1796  C   ASP   110      33.406  22.280  18.098  1.00 59.30           C  
ATOM   1797  O   ASP   110      33.432  22.865  17.042  1.00 59.02           O  
ATOM   1798  N   ALA   111      33.379  22.893  19.261  1.00 58.06           N  
ATOM   1799  CA  ALA   111      33.066  24.306  19.406  1.00 57.38           C  
ATOM   1800  CB  ALA   111      32.536  24.554  20.818  1.00 57.21           C  
ATOM   1801  C   ALA   111      34.258  25.205  19.177  1.00 56.72           C  
ATOM   1802  O   ALA   111      35.272  25.089  19.889  1.00 57.57           O  
ATOM   1803  N   ILE   112      34.119  26.154  18.251  1.00 55.21           N  
ATOM   1804  CA  ILE   112      35.225  27.055  17.889  1.00 54.33           C  
ATOM   1805  CB  ILE   112      35.545  27.013  16.382  1.00 53.69           C  
ATOM   1806  CG1 ILE   112      36.137  25.638  15.980  1.00 52.77           C  
ATOM   1807  CD1 ILE   112      37.476  25.275  16.635  1.00 49.92           C  
ATOM   1808  CG2 ILE   112      36.436  28.152  16.043  1.00 53.76           C  
ATOM   1809  C   ILE   112      34.888  28.482  18.207  1.00 53.15           C  
ATOM   1810  O   ILE   112      33.808  28.944  17.899  1.00 51.53           O  
ATOM   1811  N   LEU   113      35.821  29.173  18.845  1.00 53.06           N  
ATOM   1812  CA  LEU   113      35.666  30.596  19.061  1.00 53.03           C  
ATOM   1813  CB  LEU   113      36.292  31.072  20.383  1.00 53.10           C  
ATOM   1814  CG  LEU   113      36.087  32.580  20.532  1.00 52.79           C  
ATOM   1815  CD1 LEU   113      34.661  32.806  21.024  1.00 54.51           C  
ATOM   1816  CD2 LEU   113      37.078  33.222  21.401  1.00 51.36           C  
ATOM   1817  C   LEU   113      36.397  31.229  17.909  1.00 53.23           C  
ATOM   1818  O   LEU   113      37.609  31.012  17.734  1.00 52.53           O  
ATOM   1819  N   ARG   114      35.667  32.020  17.138  1.00 53.46           N  
ATOM   1820  CA  ARG   114      36.223  32.610  15.948  1.00 53.18           C  
ATOM   1821  CB  ARG   114      35.293  32.455  14.780  1.00 53.98           C  
ATOM   1822  CG  ARG   114      35.992  32.861  13.486  1.00 55.81           C  
ATOM   1823  CD  ARG   114      35.286  32.347  12.284  1.00 56.37           C  
ATOM   1824  NE  ARG   114      34.281  33.310  11.980  1.00 62.18           N  
ATOM   1825  CZ  ARG   114      33.110  33.021  11.425  1.00 66.73           C  
ATOM   1826  NH1 ARG   114      32.821  31.763  11.120  1.00 69.41           N  
ATOM   1827  NH2 ARG   114      32.219  33.993  11.177  1.00 65.56           N  
ATOM   1828  C   ARG   114      36.412  34.061  16.129  1.00 51.52           C  
ATOM   1829  O   ARG   114      35.504  34.765  16.508  1.00 50.99           O  
ATOM   1830  N   VAL   115      37.595  34.520  15.806  1.00 50.91           N  
ATOM   1831  CA  VAL   115      37.861  35.942  15.832  1.00 50.00           C  
ATOM   1832  CB  VAL   115      38.953  36.307  16.861  1.00 48.85           C  
ATOM   1833  CG1 VAL   115      39.106  37.829  16.950  1.00 43.80           C  
ATOM   1834  CG2 VAL   115      38.595  35.721  18.153  1.00 46.27           C  
ATOM   1835  C   VAL   115      38.341  36.347  14.469  1.00 50.21           C  
ATOM   1836  O   VAL   115      39.296  35.795  13.969  1.00 51.89           O  
ATOM   1837  N   ARG   116      37.677  37.315  13.884  1.00 49.80           N  
ATOM   1838  CA  ARG   116      38.152  37.929  12.691  1.00 49.49           C  
ATOM   1839  CB  ARG   116      37.035  37.992  11.663  1.00 49.87           C  
ATOM   1840  CG  ARG   116      36.515  36.649  11.141  1.00 51.66           C  
ATOM   1841  CD  ARG   116      35.941  36.909   9.834  1.00 56.96           C  
ATOM   1842  NE  ARG   116      34.794  36.102   9.460  1.00 59.39           N  
ATOM   1843  CZ  ARG   116      34.878  34.960   8.799  1.00 62.41           C  
ATOM   1844  NH1 ARG   116      36.084  34.397   8.490  1.00 66.08           N  
ATOM   1845  NH2 ARG   116      33.748  34.358   8.477  1.00 60.95           N  
ATOM   1846  C   ARG   116      38.524  39.347  13.033  1.00 48.86           C  
ATOM   1847  O   ARG   116      37.747  40.070  13.642  1.00 48.25           O  
ATOM   1848  N   GLN   117      39.661  39.779  12.527  1.00 48.71           N  
ATOM   1849  CA  GLN   117      40.193  41.071  12.872  1.00 48.56           C  
ATOM   1850  CB  GLN   117      41.243  40.818  13.896  1.00 48.45           C  
ATOM   1851  CG  GLN   117      42.384  41.762  13.894  1.00 50.00           C  
ATOM   1852  CD  GLN   117      43.250  41.542  15.144  1.00 49.66           C  
ATOM   1853  OE1 GLN   117      42.762  41.248  16.252  1.00 49.02           O  
ATOM   1854  NE2 GLN   117      44.538  41.627  14.942  1.00 52.07           N  
ATOM   1855  C   GLN   117      40.811  41.792  11.679  1.00 48.14           C  
ATOM   1856  O   GLN   117      41.481  41.162  10.894  1.00 48.86           O  
ATOM   1857  N   VAL   118      40.553  43.097  11.554  1.00 47.34           N  
ATOM   1858  CA  VAL   118      41.311  43.996  10.683  1.00 46.98           C  
ATOM   1859  CB  VAL   118      40.423  44.783   9.740  1.00 45.57           C  
ATOM   1860  CG1 VAL   118      41.288  45.644   8.844  1.00 43.48           C  
ATOM   1861  CG2 VAL   118      39.588  43.858   8.940  1.00 41.77           C  
ATOM   1862  C   VAL   118      42.097  45.009  11.516  1.00 47.59           C  
ATOM   1863  O   VAL   118      41.560  45.561  12.457  1.00 48.49           O  
ATOM   1864  N   SER   119      43.345  45.264  11.152  1.00 48.06           N  
ATOM   1865  CA  SER   119      44.183  46.194  11.873  1.00 48.99           C  
ATOM   1866  CB  SER   119      45.413  45.504  12.457  1.00 49.20           C  
ATOM   1867  OG  SER   119      45.043  44.443  13.305  1.00 49.66           O  
ATOM   1868  C   SER   119      44.660  47.243  10.911  1.00 50.78           C  
ATOM   1869  O   SER   119      44.887  46.968   9.720  1.00 51.04           O  
ATOM   1870  N   TYR   120      44.848  48.447  11.436  1.00 52.36           N  
ATOM   1871  CA  TYR   120      45.118  49.599  10.596  1.00 53.81           C  
ATOM   1872  CB  TYR   120      43.912  50.539  10.637  1.00 53.34           C  
ATOM   1873  CG  TYR   120      42.625  49.910  10.233  1.00 52.23           C  
ATOM   1874  CD1 TYR   120      42.137  50.064   8.948  1.00 52.04           C  
ATOM   1875  CE1 TYR   120      40.935  49.490   8.562  1.00 51.37           C  
ATOM   1876  CZ  TYR   120      40.232  48.745   9.477  1.00 51.73           C  
ATOM   1877  OH  TYR   120      39.055  48.157   9.111  1.00 53.17           O  
ATOM   1878  CE2 TYR   120      40.706  48.574  10.755  1.00 52.14           C  
ATOM   1879  CD2 TYR   120      41.895  49.167  11.130  1.00 51.06           C  
ATOM   1880  C   TYR   120      46.343  50.379  11.045  1.00 54.45           C  
ATOM   1881  O   TYR   120      46.699  50.382  12.221  1.00 54.84           O  
ATOM   1882  N   PHE   121      46.964  51.098  10.121  1.00 55.53           N  
ATOM   1883  CA  PHE   121      47.946  52.079  10.542  1.00 56.46           C  
ATOM   1884  CB  PHE   121      48.870  52.473   9.379  1.00 56.48           C  
ATOM   1885  CG  PHE   121      49.843  51.393   9.001  1.00 55.95           C  
ATOM   1886  CD1 PHE   121      50.465  50.608   9.984  1.00 57.46           C  
ATOM   1887  CE1 PHE   121      51.393  49.607   9.640  1.00 56.87           C  
ATOM   1888  CZ  PHE   121      51.688  49.388   8.304  1.00 56.73           C  
ATOM   1889  CE2 PHE   121      51.059  50.155   7.326  1.00 56.28           C  
ATOM   1890  CD2 PHE   121      50.147  51.150   7.680  1.00 55.91           C  
ATOM   1891  C   PHE   121      47.251  53.314  11.147  1.00 57.56           C  
ATOM   1892  O   PHE   121      46.077  53.622  10.832  1.00 58.10           O  
ATOM   1893  N   GLU   122      47.989  54.032  11.993  1.00 57.96           N  
ATOM   1894  CA  GLU   122      47.539  55.339  12.459  1.00 58.02           C  
ATOM   1895  CB  GLU   122      48.619  56.062  13.267  1.00 57.75           C  
ATOM   1896  CG  GLU   122      48.876  55.329  14.583  1.00 58.73           C  
ATOM   1897  CD  GLU   122      49.683  56.115  15.601  1.00 59.40           C  
ATOM   1898  OE1 GLU   122      50.450  57.012  15.171  1.00 63.62           O  
ATOM   1899  OE2 GLU   122      49.566  55.809  16.818  1.00 57.35           O  
ATOM   1900  C   GLU   122      47.053  56.189  11.307  1.00 58.16           C  
ATOM   1901  O   GLU   122      46.253  57.060  11.527  1.00 58.29           O  
ATOM   1902  N   ASN   123      47.483  55.940  10.072  1.00 58.65           N  
ATOM   1903  CA  ASN   123      46.956  56.745   8.991  1.00 58.77           C  
ATOM   1904  CB  ASN   123      48.049  57.058   7.975  1.00 59.77           C  
ATOM   1905  CG  ASN   123      48.489  55.842   7.158  1.00 62.70           C  
ATOM   1906  OD1 ASN   123      47.692  54.953   6.816  1.00 63.41           O  
ATOM   1907  ND2 ASN   123      49.777  55.825   6.809  1.00 66.38           N  
ATOM   1908  C   ASN   123      45.719  56.175   8.318  1.00 58.63           C  
ATOM   1909  O   ASN   123      45.349  56.630   7.223  1.00 58.28           O  
ATOM   1910  N   GLY   124      45.087  55.175   8.942  1.00 58.27           N  
ATOM   1911  CA  GLY   124      43.851  54.572   8.377  1.00 57.96           C  
ATOM   1912  C   GLY   124      43.988  53.406   7.394  1.00 57.60           C  
ATOM   1913  O   GLY   124      43.000  52.794   7.035  1.00 57.60           O  
ATOM   1914  N   LEU   125      45.209  53.091   6.958  1.00 57.62           N  
ATOM   1915  CA  LEU   125      45.474  52.003   5.971  1.00 56.79           C  
ATOM   1916  CB  LEU   125      46.863  52.172   5.354  1.00 56.99           C  
ATOM   1917  CG  LEU   125      47.313  51.209   4.238  1.00 57.32           C  
ATOM   1918  CD1 LEU   125      46.559  51.492   2.962  1.00 51.24           C  
ATOM   1919  CD2 LEU   125      48.879  51.262   4.034  1.00 56.37           C  
ATOM   1920  C   LEU   125      45.439  50.619   6.641  1.00 56.59           C  
ATOM   1921  O   LEU   125      46.185  50.381   7.602  1.00 56.51           O  
ATOM   1922  N   PRO   126      44.569  49.713   6.150  1.00 55.20           N  
ATOM   1923  CA  PRO   126      44.594  48.317   6.590  1.00 54.19           C  
ATOM   1924  CB  PRO   126      43.546  47.649   5.714  1.00 54.04           C  
ATOM   1925  CG  PRO   126      42.677  48.766   5.184  1.00 55.27           C  
ATOM   1926  CD  PRO   126      43.500  49.995   5.175  1.00 55.35           C  
ATOM   1927  C   PRO   126      45.931  47.648   6.331  1.00 52.47           C  
ATOM   1928  O   PRO   126      46.533  47.848   5.270  1.00 52.28           O  
ATOM   1929  N   PHE   127      46.389  46.837   7.270  1.00 50.79           N  
ATOM   1930  CA  PHE   127      47.560  46.065   7.000  1.00 49.66           C  
ATOM   1931  CB  PHE   127      48.770  46.716   7.670  1.00 49.45           C  
ATOM   1932  CG  PHE   127      48.796  46.579   9.145  1.00 49.09           C  
ATOM   1933  CD1 PHE   127      49.357  45.457   9.733  1.00 49.51           C  
ATOM   1934  CE1 PHE   127      49.395  45.324  11.118  1.00 50.25           C  
ATOM   1935  CZ  PHE   127      48.868  46.326  11.933  1.00 49.75           C  
ATOM   1936  CE2 PHE   127      48.322  47.460  11.335  1.00 49.82           C  
ATOM   1937  CD2 PHE   127      48.293  47.583   9.962  1.00 48.80           C  
ATOM   1938  C   PHE   127      47.426  44.594   7.350  1.00 49.26           C  
ATOM   1939  O   PHE   127      48.370  43.844   7.193  1.00 50.61           O  
ATOM   1940  N   GLU   128      46.257  44.151   7.752  1.00 48.37           N  
ATOM   1941  CA  GLU   128      46.129  42.822   8.282  1.00 48.59           C  
ATOM   1942  CB  GLU   128      46.561  42.888   9.728  1.00 48.53           C  
ATOM   1943  CG  GLU   128      47.258  41.717  10.178  1.00 50.32           C  
ATOM   1944  CD  GLU   128      47.613  41.718  11.695  1.00 50.97           C  
ATOM   1945  OE1 GLU   128      46.903  42.361  12.563  1.00 48.10           O  
ATOM   1946  OE2 GLU   128      48.606  40.977  11.980  1.00 55.33           O  
ATOM   1947  C   GLU   128      44.661  42.419   8.224  1.00 48.49           C  
ATOM   1948  O   GLU   128      43.790  43.206   8.620  1.00 48.17           O  
ATOM   1949  N   TYR   129      44.360  41.220   7.741  1.00 47.88           N  
ATOM   1950  CA  TYR   129      43.021  40.662   7.924  1.00 47.72           C  
ATOM   1951  CB  TYR   129      42.290  40.605   6.589  1.00 47.75           C  
ATOM   1952  CG  TYR   129      40.957  39.924   6.655  1.00 47.52           C  
ATOM   1953  CD1 TYR   129      40.152  40.056   7.758  1.00 46.95           C  
ATOM   1954  CE1 TYR   129      38.919  39.449   7.823  1.00 46.77           C  
ATOM   1955  CZ  TYR   129      38.460  38.721   6.777  1.00 47.90           C  
ATOM   1956  OH  TYR   129      37.231  38.120   6.883  1.00 49.08           O  
ATOM   1957  CE2 TYR   129      39.221  38.586   5.643  1.00 46.54           C  
ATOM   1958  CD2 TYR   129      40.482  39.180   5.593  1.00 46.25           C  
ATOM   1959  C   TYR   129      43.222  39.275   8.479  1.00 47.18           C  
ATOM   1960  O   TYR   129      43.747  38.406   7.826  1.00 47.44           O  
ATOM   1961  N   VAL   130      42.856  39.068   9.713  1.00 47.14           N  
ATOM   1962  CA  VAL   130      43.312  37.876  10.421  1.00 46.73           C  
ATOM   1963  CB  VAL   130      44.313  38.235  11.580  1.00 46.73           C  
ATOM   1964  CG1 VAL   130      44.880  36.978  12.232  1.00 42.42           C  
ATOM   1965  CG2 VAL   130      45.438  39.132  11.030  1.00 43.30           C  
ATOM   1966  C   VAL   130      42.100  37.144  10.923  1.00 47.65           C  
ATOM   1967  O   VAL   130      41.148  37.755  11.424  1.00 48.37           O  
ATOM   1968  N   ARG   131      42.085  35.841  10.720  1.00 48.01           N  
ATOM   1969  CA  ARG   131      40.872  35.081  10.995  1.00 48.71           C  
ATOM   1970  CB  ARG   131      40.191  34.689   9.703  1.00 48.30           C  
ATOM   1971  CG  ARG   131      39.837  35.900   8.836  1.00 50.13           C  
ATOM   1972  CD  ARG   131      39.993  35.617   7.365  1.00 49.77           C  
ATOM   1973  NE  ARG   131      41.290  36.030   6.895  1.00 50.32           N  
ATOM   1974  CZ  ARG   131      41.718  35.851   5.647  1.00 49.41           C  
ATOM   1975  NH1 ARG   131      41.000  35.229   4.746  1.00 49.10           N  
ATOM   1976  NH2 ARG   131      42.903  36.268   5.305  1.00 51.37           N  
ATOM   1977  C   ARG   131      41.352  33.869  11.746  1.00 48.75           C  
ATOM   1978  O   ARG   131      42.088  33.018  11.192  1.00 48.68           O  
ATOM   1979  N   THR   132      40.990  33.838  13.018  1.00 48.37           N  
ATOM   1980  CA  THR   132      41.508  32.864  13.900  1.00 48.79           C  
ATOM   1981  CB  THR   132      42.200  33.530  15.005  1.00 48.55           C  
ATOM   1982  OG1 THR   132      43.272  34.284  14.466  1.00 47.19           O  
ATOM   1983  CG2 THR   132      42.718  32.499  15.962  1.00 49.57           C  
ATOM   1984  C   THR   132      40.408  31.999  14.456  1.00 49.47           C  
ATOM   1985  O   THR   132      39.333  32.469  14.781  1.00 49.43           O  
ATOM   1986  N   GLN   133      40.726  30.729  14.580  1.00 50.15           N  
ATOM   1987  CA  GLN   133      39.804  29.751  15.042  1.00 51.36           C  
ATOM   1988  CB  GLN   133      39.566  28.845  13.853  1.00 51.63           C  
ATOM   1989  CG  GLN   133      38.130  28.484  13.637  1.00 53.97           C  
ATOM   1990  CD  GLN   133      37.756  28.356  12.227  1.00 53.78           C  
ATOM   1991  OE1 GLN   133      38.175  29.153  11.397  1.00 59.44           O  
ATOM   1992  NE2 GLN   133      36.938  27.369  11.928  1.00 52.86           N  
ATOM   1993  C   GLN   133      40.454  29.011  16.245  1.00 52.27           C  
ATOM   1994  O   GLN   133      41.479  28.275  16.099  1.00 52.37           O  
ATOM   1995  N   TYR   134      39.922  29.265  17.440  1.00 52.39           N  
ATOM   1996  CA  TYR   134      40.437  28.675  18.702  1.00 51.75           C  
ATOM   1997  CB  TYR   134      40.318  29.669  19.851  1.00 51.18           C  
ATOM   1998  CG  TYR   134      41.065  30.944  19.651  1.00 50.26           C  
ATOM   1999  CD1 TYR   134      42.380  31.067  20.050  1.00 49.80           C  
ATOM   2000  CE1 TYR   134      43.059  32.248  19.880  1.00 49.75           C  
ATOM   2001  CZ  TYR   134      42.413  33.300  19.314  1.00 50.69           C  
ATOM   2002  OH  TYR   134      43.058  34.481  19.081  1.00 49.39           O  
ATOM   2003  CE2 TYR   134      41.095  33.189  18.947  1.00 49.62           C  
ATOM   2004  CD2 TYR   134      40.439  32.040  19.126  1.00 47.46           C  
ATOM   2005  C   TYR   134      39.574  27.481  19.102  1.00 52.15           C  
ATOM   2006  O   TYR   134      38.337  27.544  19.009  1.00 52.17           O  
ATOM   2007  N   ALA   135      40.212  26.400  19.538  1.00 52.83           N  
ATOM   2008  CA  ALA   135      39.516  25.304  20.223  1.00 53.80           C  
ATOM   2009  CB  ALA   135      40.500  24.240  20.621  1.00 54.12           C  
ATOM   2010  C   ALA   135      38.835  25.828  21.475  1.00 54.42           C  
ATOM   2011  O   ALA   135      39.522  26.263  22.380  1.00 54.82           O  
ATOM   2012  N   GLY   136      37.505  25.748  21.527  1.00 55.21           N  
ATOM   2013  CA  GLY   136      36.714  26.373  22.573  1.00 56.35           C  
ATOM   2014  C   GLY   136      37.160  25.950  23.957  1.00 57.46           C  
ATOM   2015  O   GLY   136      37.420  26.786  24.822  1.00 57.55           O  
ATOM   2016  N   SER   137      37.309  24.637  24.100  1.00 58.04           N  
ATOM   2017  CA  SER   137      37.584  23.991  25.357  1.00 58.40           C  
ATOM   2018  CB  SER   137      37.448  22.498  25.147  1.00 58.31           C  
ATOM   2019  OG  SER   137      38.656  22.013  24.582  1.00 60.24           O  
ATOM   2020  C   SER   137      39.002  24.293  25.866  1.00 58.94           C  
ATOM   2021  O   SER   137      39.258  24.267  27.052  1.00 58.77           O  
ATOM   2022  N   ARG   138      39.888  24.640  24.958  1.00 59.42           N  
ATOM   2023  CA  ARG   138      41.243  24.926  25.327  1.00 59.55           C  
ATOM   2024  CB  ARG   138      42.198  24.290  24.337  1.00 59.46           C  
ATOM   2025  CG  ARG   138      42.003  22.826  24.159  1.00 60.00           C  
ATOM   2026  CD  ARG   138      43.098  22.241  23.330  1.00 62.14           C  
ATOM   2027  NE  ARG   138      42.694  20.985  22.724  1.00 63.97           N  
ATOM   2028  CZ  ARG   138      43.002  20.627  21.491  1.00 67.45           C  
ATOM   2029  NH1 ARG   138      43.725  21.426  20.738  1.00 69.16           N  
ATOM   2030  NH2 ARG   138      42.587  19.474  21.013  1.00 68.58           N  
ATOM   2031  C   ARG   138      41.529  26.394  25.390  1.00 59.70           C  
ATOM   2032  O   ARG   138      42.649  26.771  25.597  1.00 60.22           O  
ATOM   2033  N   PHE   139      40.535  27.240  25.215  1.00 20.00           N  
ATOM   2034  CA  PHE   139      40.825  28.657  25.130  1.00 20.00           C  
ATOM   2035  C   PHE   139      39.807  29.563  25.785  1.00 20.00           C  
ATOM   2036  CB  PHE   139      40.981  29.036  23.668  1.00 20.00           C  
ATOM   2037  CG  PHE   139      41.372  30.443  23.451  1.00 20.00           C  
ATOM   2038  CD1 PHE   139      42.629  30.856  23.709  1.00 20.00           C  
ATOM   2039  CD2 PHE   139      40.481  31.348  22.985  1.00 20.00           C  
ATOM   2040  CE1 PHE   139      42.978  32.133  23.514  1.00 20.00           C  
ATOM   2041  CE2 PHE   139      40.844  32.628  22.788  1.00 20.00           C  
ATOM   2042  CZ  PHE   139      42.087  33.017  23.052  1.00 20.00           C  
ATOM   2043  O   PHE   139      38.661  29.235  25.870  1.00 59.96           O  
ATOM   2044  N   GLU   140      40.271  30.708  26.243  1.00 57.79           N  
ATOM   2045  CA  GLU   140      39.471  31.798  26.743  1.00 57.81           C  
ATOM   2046  CB  GLU   140      39.561  31.827  28.276  1.00 58.32           C  
ATOM   2047  CG  GLU   140      38.980  30.633  29.001  1.00 59.77           C  
ATOM   2048  CD  GLU   140      37.468  30.477  28.805  1.00 62.71           C  
ATOM   2049  OE1 GLU   140      36.724  31.478  28.868  1.00 64.64           O  
ATOM   2050  OE2 GLU   140      37.023  29.333  28.599  1.00 65.28           O  
ATOM   2051  C   GLU   140      39.985  33.135  26.259  1.00 56.94           C  
ATOM   2052  O   GLU   140      41.120  33.419  26.418  1.00 56.93           O  
ATOM   2053  N   PHE   141      39.147  34.003  25.747  1.00 56.96           N  
ATOM   2054  CA  PHE   141      39.609  35.288  25.253  1.00 57.82           C  
ATOM   2055  CB  PHE   141      38.846  35.543  23.966  1.00 56.48           C  
ATOM   2056  CG  PHE   141      39.082  36.868  23.306  1.00 55.72           C  
ATOM   2057  CD1 PHE   141      38.557  38.039  23.831  1.00 55.21           C  
ATOM   2058  CE1 PHE   141      38.704  39.257  23.167  1.00 55.83           C  
ATOM   2059  CZ  PHE   141      39.379  39.299  21.966  1.00 56.64           C  
ATOM   2060  CE2 PHE   141      39.896  38.125  21.431  1.00 54.39           C  
ATOM   2061  CD2 PHE   141      39.704  36.928  22.074  1.00 53.44           C  
ATOM   2062  C   PHE   141      39.343  36.299  26.354  1.00 58.49           C  
ATOM   2063  O   PHE   141      38.231  36.429  26.837  1.00 59.23           O  
ATOM   2064  N   TYR   142      40.370  37.007  26.775  1.00 60.30           N  
ATOM   2065  CA  TYR   142      40.255  37.923  27.890  1.00 61.99           C  
ATOM   2066  CB  TYR   142      41.538  37.901  28.744  1.00 62.52           C  
ATOM   2067  CG  TYR   142      41.817  36.495  29.283  1.00 63.41           C  
ATOM   2068  CD1 TYR   142      41.325  36.080  30.531  1.00 64.00           C  
ATOM   2069  CE1 TYR   142      41.540  34.760  31.004  1.00 63.03           C  
ATOM   2070  CZ  TYR   142      42.240  33.858  30.210  1.00 64.94           C  
ATOM   2071  OH  TYR   142      42.453  32.567  30.644  1.00 65.69           O  
ATOM   2072  CE2 TYR   142      42.756  34.242  28.967  1.00 64.21           C  
ATOM   2073  CD2 TYR   142      42.525  35.556  28.512  1.00 65.36           C  
ATOM   2074  C   TYR   142      39.890  39.321  27.423  1.00 63.29           C  
ATOM   2075  O   TYR   142      40.614  39.943  26.715  1.00 62.80           O  
ATOM   2076  N   LEU   143      38.725  39.812  27.804  1.00 65.62           N  
ATOM   2077  CA  LEU   143      38.378  41.174  27.496  1.00 67.74           C  
ATOM   2078  CB  LEU   143      36.963  41.468  27.958  1.00 67.89           C  
ATOM   2079  CG  LEU   143      35.934  41.088  26.905  1.00 69.11           C  
ATOM   2080  CD1 LEU   143      34.698  41.872  27.213  1.00 70.90           C  
ATOM   2081  CD2 LEU   143      35.654  39.584  26.883  1.00 70.43           C  
ATOM   2082  C   LEU   143      39.336  42.175  28.113  1.00 69.39           C  
ATOM   2083  O   LEU   143      39.666  42.069  29.251  1.00 69.58           O  
ATOM   2084  N   GLU   144      39.739  43.172  27.338  1.00 72.54           N  
ATOM   2085  CA  GLU   144      40.716  44.181  27.750  1.00 74.25           C  
ATOM   2086  CB  GLU   144      41.140  45.025  26.535  1.00 75.01           C  
ATOM   2087  CG  GLU   144      42.668  45.196  26.372  1.00 78.53           C  
ATOM   2088  CD  GLU   144      43.312  44.291  25.286  1.00 81.51           C  
ATOM   2089  OE1 GLU   144      42.961  44.465  24.090  1.00 82.90           O  
ATOM   2090  OE2 GLU   144      44.194  43.440  25.625  1.00 81.58           O  
ATOM   2091  C   GLU   144      40.084  45.065  28.820  1.00 75.75           C  
ATOM   2092  O   GLU   144      38.998  45.599  28.614  1.00 75.96           O  
ATOM   2093  N   LYS   145      40.769  45.217  29.962  1.00 77.85           N  
ATOM   2094  CA  LYS   145      40.187  45.886  31.153  1.00 78.63           C  
ATOM   2095  CB  LYS   145      41.158  45.909  32.361  1.00 79.83           C  
ATOM   2096  CG  LYS   145      41.775  44.560  32.815  1.00 81.50           C  
ATOM   2097  CD  LYS   145      40.796  43.534  33.467  1.00 83.50           C  
ATOM   2098  CE  LYS   145      41.629  42.298  34.002  1.00 84.23           C  
ATOM   2099  NZ  LYS   145      40.927  40.996  34.381  1.00 83.07           N  
ATOM   2100  C   LYS   145      39.779  47.327  30.817  1.00 79.77           C  
ATOM   2101  O   LYS   145      40.647  48.168  30.548  1.00 80.23           O  
END
