
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  144 ( 1213),  selected  144 , name 2ogg_A
# Molecule2: number of CA atoms  139 ( 1121),  selected  139 , name T0455.pdb
# PARAMETERS: 2ogg_A.T0455.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T    95_A      -       -           -
LGA    K    96_A      S       7          1.353
LGA    T    97_A      S       8          0.686
LGA    T    98_A      R       9          0.494
LGA    V    99_A      T      10          0.458
LGA    H   100_A      V      11          0.789
LGA    K   101_A      S      12          0.859
LGA    F   102_A      Y      13          0.574
LGA    G   103_A      F      14          0.969
LGA    L   104_A      V      15          1.495
LGA    E   105_A      A      16          1.821
LGA    P   106_A      K      17          0.890
LGA    P   107_A      P      18          0.823
LGA    S   108_A      S      19          2.206
LGA    E   109_A      S      20          2.937
LGA    L   110_A      S      21          3.337
LGA    I   111_A      E      22          1.807
LGA    Q   112_A      M      23          2.208
LGA    K   113_A      E      24          3.221
LGA    Q   114_A      K      25          3.348
LGA    L   115_A      L      26          2.411
LGA    R   116_A      Q      27          2.677
LGA    A   117_A      L      28          2.114
LGA    N   118_A      G      29          1.456
LGA    L   119_A      P      30          0.980
LGA    D   120_A      E      31          1.507
LGA    D   121_A      D      32          0.577
LGA    D   122_A      S      33          1.264
LGA    I   123_A      I      34          0.462
LGA    W   124_A      L      35          0.804
LGA    E   125_A      R      36          0.788
LGA    V   126_A      M      37          1.131
LGA    I   127_A      E      38          0.617
LGA    R   128_A      R      39          0.436
LGA    S   129_A      I      40          0.320
LGA    R   130_A      R      41          0.806
LGA    K   131_A      F      42          1.927
LGA    I   132_A      A      43          1.658
LGA    D   133_A      D      44          2.390
LGA    G   134_A      D      45          2.316
LGA    E   135_A      I      46          1.769
LGA    H   136_A      P      47          1.981
LGA    V   137_A      I      48          2.497
LGA    I   138_A      C      49          0.447
LGA    L   139_A      F      50          0.466
LGA    D   140_A      E      51          1.530
LGA    K   141_A      V      52          1.453
LGA    D   142_A      A      53          1.249
LGA    Y   143_A      S      54          0.902
LGA    F   144_A      I      55          1.109
LGA    F   145_A      P      56          0.881
LGA    R   146_A      Y      57          1.882
LGA    K   147_A      S      58          1.928
LGA    H   148_A      L      59          2.060
LGA    V   149_A      V      60          2.269
LGA    P   150_A      S      61          2.242
LGA    H   151_A      Q      62          2.367
LGA    L   152_A      Y      63          3.506
LGA    T   153_A      G      64          3.193
LGA    K   154_A      K      65          3.304
LGA    E   155_A      S      66          2.359
LGA    I   156_A      E      67          2.934
LGA    C   157_A      I      68          4.763
LGA    E   158_A      T      69          4.686
LGA    N   159_A      N      70          2.234
LGA    S   160_A      S      71          3.254
LGA    I   161_A      F      72          2.443
LGA    Y   162_A      Y      73          2.841
LGA    E   163_A      K      74          2.657
LGA    Y   164_A      T      75          2.483
LGA    I   165_A      L      76          2.515
LGA    E   166_A      E      77          3.260
LGA    G   167_A      A      78          2.725
LGA    E   168_A      K      79          2.617
LGA    L   169_A      S      80          3.527
LGA    G   170_A      G      81           #
LGA    L   171_A      H      82          3.818
LGA    S   172_A      K      83          2.921
LGA    I   173_A      I      84          2.466
LGA    S   174_A      G      85          1.798
LGA    Y   175_A      H      86          0.814
LGA    A   176_A      S      87          0.817
LGA    Q   177_A      N      88          1.033
LGA    K   178_A      Q      89          1.582
LGA    E   179_A      T      90          1.559
LGA    I   180_A      I      91          1.395
LGA    V   181_A      S      92          1.315
LGA    A   182_A      A      93          1.037
LGA    E   183_A      V      94          1.550
LGA    P   184_A      Q      95          2.014
LGA    C   185_A      A      96          1.717
LGA    T   186_A      S      97          2.484
LGA    D   187_A      E      98          3.713
LGA    E   188_A      Q      99          3.306
LGA    D   189_A      I     100          0.901
LGA    R   190_A      A     101          2.168
LGA    E   191_A      E     102          3.122
LGA    L   192_A      Y     103          1.773
LGA    L   193_A      L     104          1.644
LGA    D   194_A      E     105          0.789
LGA    L   195_A      I     106          1.305
LGA    R   196_A      K     107          4.366
LGA    G   197_A      R     108           #
LGA    Y   198_A      G     109          5.538
LGA    D   199_A      D     110          1.591
LGA    H   200_A      A     111          2.019
LGA    X   201_A      I     112          0.652
LGA    V   202_A      L     113          0.567
LGA    V   203_A      R     114          1.045
LGA    V   204_A      V     115          1.498
LGA    R   205_A      R     116          1.654
LGA    N   206_A      Q     117          1.545
LGA    Y   207_A      V     118          0.924
LGA    V   208_A      S     119          0.917
LGA    F   209_A      Y     120          1.505
LGA    L   210_A      F     121          2.042
LGA    E   211_A      E     122          2.778
LGA    D   212_A      N     123          2.741
LGA    T   213_A      G     124          1.983
LGA    S   214_A      L     125          2.459
LGA    L   215_A      P     126          2.203
LGA    F   216_A      F     127          2.380
LGA    Q   217_A      E     128          1.430
LGA    Y   218_A      Y     129          0.933
LGA    T   219_A      V     130          1.043
LGA    E   220_A      R     131          1.157
LGA    S   221_A      T     132          1.590
LGA    R   222_A      Q     133          1.104
LGA    H   223_A      Y     134          0.317
LGA    R   224_A      A     135          0.254
LGA    L   225_A      G     136          0.404
LGA    D   226_A      S     137          1.996
LGA    K   227_A      R     138          2.587
LGA    F   228_A      F     139          2.223
LGA    R   229_A      E     140          2.185
LGA    F   230_A      F     141          2.348
LGA    V   231_A      Y     142          2.401
LGA    -       -      L     143           -
LGA    D   232_A      E     144          1.072
LGA    F   233_A      K     145          1.694
LGA    A   234_A      -       -           -
LGA    R   235_A      -       -           -
LGA    R   236_A      -       -           -
LGA    G   237_A      -       -           -
LGA    K   238_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  144  139    5.0    136    2.11    19.85     73.833     6.159

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.035454 * X  +  -0.526464 * Y  +   0.849458 * Z  +  40.908138
  Y_new =  -0.851868 * X  +  -0.460367 * Y  +  -0.249765 * Z  +  51.610416
  Z_new =   0.522555 * X  +  -0.714771 * Y  +  -0.464800 * Z  +  25.481237 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.147367    0.994226  [ DEG:  -123.0350     56.9650 ]
  Theta =  -0.549845   -2.591748  [ DEG:   -31.5038   -148.4962 ]
  Phi   =  -1.529201    1.612391  [ DEG:   -87.6168     92.3832 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ogg_A                                        
REMARK     2: T0455.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ogg_A.T0455.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  144  139   5.0  136   2.11   19.85  73.833
REMARK  ---------------------------------------------------------- 
MOLECULE 2ogg_A
HEADER    TRANSCRIPTION                           05-JAN-07   2OGG              
TITLE     STRUCTURE OF B. SUBTILIS TREHALOSE REPRESSOR (TRER)                   
TITLE    2 EFFECTOR BINDING DOMAIN                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TREHALOSE OPERON TRANSCRIPTIONAL REPRESSOR;                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: EFFECTOR BINDING DOMAIN, RESIDUES 90-238;                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: TRER;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    GENE REPRESSOR, SUGAR BINDING, STRUCTURAL GENOMICS, PSI-2,            
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG, TRANSCRIPTION                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.REZACOVA,V.KREJCIRIKOVA,D.BOREK,S.F.MOY,A.JOACHIMIAK,               
AUTHOR   2 Z.OTWINOWSKI,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   2   23-OCT-07 2OGG    1       JRNL                                     
REVDAT   1   06-FEB-07 2OGG    0                                                
JRNL        AUTH   P.REZACOVA,V.KREJCIRIKOVA,D.BOREK,S.F.MOY,                   
JRNL        AUTH 2 A.JOACHIMIAK,Z.OTWINOWSKI                                    
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE EFFECTOR-BINDING                
JRNL        TITL 2 DOMAIN OF THE TREHALOSE REPRESSOR TRER FROM                  
JRNL        TITL 3 BACILLUS SUBTILIS 168 REVEALS A UNIQUE QUARTERNARY           
JRNL        TITL 4 ASSEMBLY.                                                    
JRNL        REF    PROTEINS                      V.  69   679 2007              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2OGG A   90   238  UNP    P39796   TRER_BACSU      90    238             
SEQRES   1 A  152  SER ASN ALA THR LEU GLY LYS GLU THR LYS THR THR VAL          
SEQRES   2 A  152  HIS LYS PHE GLY LEU GLU PRO PRO SER GLU LEU ILE GLN          
SEQRES   3 A  152  LYS GLN LEU ARG ALA ASN LEU ASP ASP ASP ILE TRP GLU          
SEQRES   4 A  152  VAL ILE ARG SER ARG LYS ILE ASP GLY GLU HIS VAL ILE          
SEQRES   5 A  152  LEU ASP LYS ASP TYR PHE PHE ARG LYS HIS VAL PRO HIS          
SEQRES   6 A  152  LEU THR LYS GLU ILE CYS GLU ASN SER ILE TYR GLU TYR          
SEQRES   7 A  152  ILE GLU GLY GLU LEU GLY LEU SER ILE SER TYR ALA GLN          
SEQRES   8 A  152  LYS GLU ILE VAL ALA GLU PRO CYS THR ASP GLU ASP ARG          
SEQRES   9 A  152  GLU LEU LEU ASP LEU ARG GLY TYR ASP HIS MSE VAL VAL          
SEQRES  10 A  152  VAL ARG ASN TYR VAL PHE LEU GLU ASP THR SER LEU PHE          
SEQRES  11 A  152  GLN TYR THR GLU SER ARG HIS ARG LEU ASP LYS PHE ARG          
SEQRES  12 A  152  PHE VAL ASP PHE ALA ARG ARG GLY LYS                          
HET    MSE  A 201       8                                                       
HET     NA  A 301       1                                                       
HET    SO4  A 302       5                                                       
HET    SO4  A 303       5                                                       
HET    GOL  A 304       6                                                       
HET    GOL  A 305       6                                                       
HET    GOL  A 306       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NA SODIUM ION                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    C5 H11 N O2 SE                                               
FORMUL   2   NA    NA 1+                                                        
FORMUL   3  SO4    2(O4 S 2-)                                                   
FORMUL   5  GOL    3(C3 H8 O3)                                                  
FORMUL   8  HOH   *36(H2 O)                                                     
CRYST1   69.719   69.719  236.535  90.00  90.00  90.00 I 41 2 2     16          
ATOM      1  N   THR A  95      55.999  26.049  23.225  1.00 51.18           N  
ATOM      2  CA  THR A  95      54.737  26.154  22.434  1.00 52.96           C  
ATOM      3  C   THR A  95      55.037  26.457  20.946  1.00 51.75           C  
ATOM      4  O   THR A  95      55.166  27.619  20.551  1.00 53.21           O  
ATOM      5  CB  THR A  95      53.750  27.190  23.064  1.00 53.11           C  
ATOM      6  OG1 THR A  95      53.461  28.250  22.143  1.00 48.15           O  
ATOM      7  CG2 THR A  95      54.298  27.751  24.387  1.00 54.75           C  
ATOM      8  N   LYS A  96      55.188  25.401  20.143  1.00 49.42           N  
ATOM      9  CA  LYS A  96      55.675  25.517  18.757  1.00 48.55           C  
ATOM     10  C   LYS A  96      54.683  26.133  17.760  1.00 44.73           C  
ATOM     11  O   LYS A  96      53.488  25.896  17.833  1.00 43.66           O  
ATOM     12  CB  LYS A  96      56.161  24.154  18.245  1.00 49.04           C  
ATOM     13  CG  LYS A  96      57.141  24.220  17.075  1.00 56.62           C  
ATOM     14  CD  LYS A  96      57.572  22.826  16.615  1.00 65.00           C  
ATOM     15  CE  LYS A  96      56.546  22.210  15.662  1.00 67.27           C  
ATOM     16  NZ  LYS A  96      56.672  20.719  15.581  1.00 65.18           N  
ATOM     17  N   THR A  97      55.221  26.770  16.727  1.00 44.81           N  
ATOM     18  CA  THR A  97      54.430  27.439  15.701  1.00 41.07           C  
ATOM     19  C   THR A  97      54.792  26.852  14.335  1.00 44.58           C  
ATOM     20  O   THR A  97      55.924  26.990  13.868  1.00 46.07           O  
ATOM     21  CB  THR A  97      54.756  28.972  15.693  1.00 40.61           C  
ATOM     22  OG1 THR A  97      54.110  29.598  16.802  1.00 41.19           O  
ATOM     23  CG2 THR A  97      54.293  29.659  14.394  1.00 32.83           C  
ATOM     24  N   THR A  98      53.778  26.417  13.605  1.00 46.14           N  
ATOM     25  CA  THR A  98      53.974  25.748  12.337  1.00 44.22           C  
ATOM     26  C   THR A  98      53.317  26.546  11.233  1.00 47.15           C  
ATOM     27  O   THR A  98      52.099  26.750  11.257  1.00 51.20           O  
ATOM     28  CB  THR A  98      53.299  24.415  12.355  1.00 42.88           C  
ATOM     29  OG1 THR A  98      53.746  23.682  13.498  1.00 52.44           O  
ATOM     30  CG2 THR A  98      53.573  23.652  11.059  1.00 42.72           C  
ATOM     31  N   VAL A  99      54.093  26.858  10.195  1.00 47.26           N  
ATOM     32  CA  VAL A  99      53.608  27.614   9.049  1.00 44.19           C  
ATOM     33  C   VAL A  99      53.095  26.653   7.997  1.00 41.88           C  
ATOM     34  O   VAL A  99      53.867  25.915   7.403  1.00 39.92           O  
ATOM     35  CB  VAL A  99      54.725  28.461   8.454  1.00 42.55           C  
ATOM     36  CG1 VAL A  99      54.277  29.122   7.180  1.00 41.17           C  
ATOM     37  CG2 VAL A  99      55.173  29.492   9.473  1.00 45.27           C  
ATOM     38  N   HIS A 100      51.785  26.671   7.758  1.00 42.31           N  
ATOM     39  CA  HIS A 100      51.180  25.716   6.827  1.00 41.22           C  
ATOM     40  C   HIS A 100      51.133  26.271   5.433  1.00 39.51           C  
ATOM     41  O   HIS A 100      51.583  25.626   4.523  1.00 43.06           O  
ATOM     42  CB  HIS A 100      49.787  25.284   7.280  1.00 38.35           C  
ATOM     43  CG  HIS A 100      49.792  24.515   8.562  1.00 42.73           C  
ATOM     44  ND1 HIS A 100      50.055  23.160   8.617  1.00 46.35           N  
ATOM     45  CD2 HIS A 100      49.662  24.927   9.846  1.00 41.41           C  
ATOM     46  CE1 HIS A 100      50.057  22.769   9.879  1.00 46.74           C  
ATOM     47  NE2 HIS A 100      49.905  23.837  10.646  1.00 51.79           N  
ATOM     48  N   LYS A 101      50.527  27.438   5.252  1.00 40.38           N  
ATOM     49  CA  LYS A 101      50.584  28.123   3.954  1.00 37.86           C  
ATOM     50  C   LYS A 101      51.319  29.430   4.161  1.00 37.53           C  
ATOM     51  O   LYS A 101      51.085  30.118   5.145  1.00 40.43           O  
ATOM     52  CB  LYS A 101      49.188  28.463   3.438  1.00 35.01           C  
ATOM     53  CG  LYS A 101      48.294  27.292   3.198  1.00 37.09           C  
ATOM     54  CD  LYS A 101      47.121  27.709   2.342  1.00 50.08           C  
ATOM     55  CE  LYS A 101      46.589  26.539   1.538  1.00 57.59           C  
ATOM     56  NZ  LYS A 101      45.501  26.982   0.633  1.00 57.67           N  
ATOM     57  N   PHE A 102      51.959  29.901   3.110  1.00 35.64           N  
ATOM     58  CA  PHE A 102      52.621  31.185   3.139  1.00 33.93           C  
ATOM     59  C   PHE A 102      52.904  31.523   1.696  1.00 36.44           C  
ATOM     60  O   PHE A 102      53.366  30.667   0.916  1.00 37.34           O  
ATOM     61  CB  PHE A 102      53.910  31.079   3.934  1.00 33.36           C  
ATOM     62  CG  PHE A 102      54.848  32.230   3.746  1.00 42.89           C  
ATOM     63  CD1 PHE A 102      54.574  33.457   4.306  1.00 59.79           C  
ATOM     64  CD2 PHE A 102      56.114  32.019   3.263  1.00 54.19           C  
ATOM     65  CE1 PHE A 102      55.505  34.481   4.262  1.00 59.73           C  
ATOM     66  CE2 PHE A 102      57.050  33.040   3.253  1.00 53.70           C  
ATOM     67  CZ  PHE A 102      56.749  34.255   3.775  1.00 45.76           C  
ATOM     68  N   GLY A 103      52.493  32.714   1.285  1.00 35.98           N  
ATOM     69  CA  GLY A 103      52.541  33.043  -0.145  1.00 35.86           C  
ATOM     70  C   GLY A 103      52.078  34.443  -0.429  1.00 34.66           C  
ATOM     71  O   GLY A 103      51.691  35.152   0.500  1.00 36.59           O  
ATOM     72  N   LEU A 104      52.443  34.916  -1.620  1.00 36.05           N  
ATOM     73  CA  LEU A 104      52.168  36.278  -2.076  1.00 36.37           C  
ATOM     74  C   LEU A 104      51.421  36.139  -3.422  1.00 42.12           C  
ATOM     75  O   LEU A 104      51.991  35.711  -4.429  1.00 40.85           O  
ATOM     76  CB  LEU A 104      53.481  37.040  -2.278  1.00 31.43           C  
ATOM     77  CG  LEU A 104      53.385  38.476  -2.830  1.00 43.19           C  
ATOM     78  CD1 LEU A 104      52.653  39.383  -1.855  1.00 42.08           C  
ATOM     79  CD2 LEU A 104      54.755  39.084  -3.169  1.00 33.03           C  
ATOM     80  N   GLU A 105      50.139  36.483  -3.420  1.00 43.14           N  
ATOM     81  CA  GLU A 105      49.294  36.309  -4.580  1.00 43.23           C  
ATOM     82  C   GLU A 105      48.276  37.421  -4.569  1.00 45.09           C  
ATOM     83  O   GLU A 105      48.091  38.067  -3.536  1.00 47.16           O  
ATOM     84  CB  GLU A 105      48.556  34.977  -4.446  1.00 46.22           C  
ATOM     85  CG  GLU A 105      49.370  33.751  -4.819  1.00 47.29           C  
ATOM     86  CD  GLU A 105      48.622  32.473  -4.506  0.50 50.41           C  
ATOM     87  OE1 GLU A 105      48.247  32.298  -3.321  0.50 33.64           O  
ATOM     88  OE2 GLU A 105      48.334  31.702  -5.459  0.50 42.94           O  
ATOM     89  N   PRO A 106      47.525  37.581  -5.676  1.00 46.06           N  
ATOM     90  CA  PRO A 106      46.306  38.406  -5.621  1.00 45.17           C  
ATOM     91  C   PRO A 106      45.285  37.794  -4.622  1.00 45.83           C  
ATOM     92  O   PRO A 106      45.214  36.577  -4.475  1.00 49.30           O  
ATOM     93  CB  PRO A 106      45.747  38.304  -7.056  1.00 44.99           C  
ATOM     94  CG  PRO A 106      46.871  37.749  -7.894  1.00 42.25           C  
ATOM     95  CD  PRO A 106      47.651  36.871  -6.959  1.00 45.01           C  
ATOM     96  N   PRO A 107      44.408  38.618  -4.045  1.00 42.83           N  
ATOM     97  CA  PRO A 107      43.407  38.128  -3.091  1.00 41.07           C  
ATOM     98  C   PRO A 107      42.250  37.250  -3.646  1.00 38.79           C  
ATOM     99  O   PRO A 107      41.726  37.512  -4.733  1.00 42.04           O  
ATOM    100  CB  PRO A 107      42.862  39.414  -2.480  1.00 35.70           C  
ATOM    101  CG  PRO A 107      43.055  40.423  -3.539  1.00 44.82           C  
ATOM    102  CD  PRO A 107      44.310  40.068  -4.268  1.00 42.00           C  
ATOM    103  N   SER A 108      41.822  36.259  -2.858  1.00 35.95           N  
ATOM    104  CA  SER A 108      40.610  35.495  -3.171  1.00 38.98           C  
ATOM    105  C   SER A 108      39.435  36.444  -2.983  1.00 39.89           C  
ATOM    106  O   SER A 108      39.614  37.576  -2.508  1.00 37.28           O  
ATOM    107  CB  SER A 108      40.457  34.282  -2.239  1.00 35.32           C  
ATOM    108  OG  SER A 108      40.284  34.690  -0.890  1.00 36.84           O  
ATOM    109  N   GLU A 109      38.231  35.996  -3.316  1.00 39.16           N  
ATOM    110  CA  GLU A 109      37.107  36.898  -3.186  1.00 43.27           C  
ATOM    111  C   GLU A 109      36.757  37.199  -1.734  1.00 42.44           C  
ATOM    112  O   GLU A 109      36.293  38.296  -1.418  1.00 41.63           O  
ATOM    113  CB  GLU A 109      35.905  36.429  -3.999  1.00 44.19           C  
ATOM    114  CG  GLU A 109      36.198  36.386  -5.490  1.00 54.87           C  
ATOM    115  CD  GLU A 109      35.026  35.894  -6.318  1.00 66.23           C  
ATOM    116  OE1 GLU A 109      34.392  34.879  -5.939  1.00 68.53           O  
ATOM    117  OE2 GLU A 109      34.783  36.490  -7.388  1.00 70.07           O  
ATOM    118  N   LEU A 110      37.030  36.254  -0.840  1.00 43.12           N  
ATOM    119  CA  LEU A 110      36.801  36.509   0.573  1.00 44.62           C  
ATOM    120  C   LEU A 110      37.777  37.563   1.120  1.00 44.30           C  
ATOM    121  O   LEU A 110      37.351  38.474   1.829  1.00 45.09           O  
ATOM    122  CB  LEU A 110      36.831  35.227   1.410  1.00 45.78           C  
ATOM    123  CG  LEU A 110      36.894  35.436   2.940  1.00 56.20           C  
ATOM    124  CD1 LEU A 110      35.594  36.030   3.549  1.00 51.38           C  
ATOM    125  CD2 LEU A 110      37.311  34.156   3.678  1.00 58.83           C  
ATOM    126  N   ILE A 111      39.039  37.524   0.691  1.00 40.71           N  
ATOM    127  CA  ILE A 111      39.997  38.504   1.184  1.00 43.54           C  
ATOM    128  C   ILE A 111      39.816  39.864   0.533  1.00 44.36           C  
ATOM    129  O   ILE A 111      40.040  40.889   1.171  1.00 44.99           O  
ATOM    130  CB  ILE A 111      41.458  38.043   1.087  1.00 44.09           C  
ATOM    131  CG1 ILE A 111      41.689  36.830   1.990  1.00 50.21           C  
ATOM    132  CG2 ILE A 111      42.379  39.152   1.501  1.00 44.64           C  
ATOM    133  CD1 ILE A 111      41.130  36.990   3.414  1.00 54.04           C  
ATOM    134  N   GLN A 112      39.339  39.889  -0.706  1.00 42.93           N  
ATOM    135  CA  GLN A 112      38.879  41.155  -1.258  1.00 44.64           C  
ATOM    136  C   GLN A 112      37.862  41.858  -0.318  1.00 43.73           C  
ATOM    137  O   GLN A 112      38.030  43.027   0.021  1.00 41.24           O  
ATOM    138  CB  GLN A 112      38.325  40.975  -2.671  1.00 41.30           C  
ATOM    139  CG  GLN A 112      39.418  40.817  -3.711  1.00 43.14           C  
ATOM    140  CD  GLN A 112      38.913  40.171  -4.999  1.00 53.68           C  
ATOM    141  OE1 GLN A 112      38.055  40.720  -5.693  1.00 52.86           O  
ATOM    142  NE2 GLN A 112      39.438  38.987  -5.313  1.00 43.15           N  
ATOM    143  N   LYS A 113      36.884  41.113   0.189  1.00 43.22           N  
ATOM    144  CA  LYS A 113      35.916  41.683   1.119  1.00 44.11           C  
ATOM    145  C   LYS A 113      36.530  42.011   2.496  1.00 44.16           C  
ATOM    146  O   LYS A 113      36.427  43.144   2.960  1.00 43.80           O  
ATOM    147  CB  LYS A 113      34.661  40.804   1.241  1.00 43.96           C  
ATOM    148  CG  LYS A 113      33.831  41.099   2.502  1.00 54.73           C  
ATOM    149  CD  LYS A 113      32.343  41.341   2.208  1.00 65.98           C  
ATOM    150  CE  LYS A 113      31.492  40.114   2.503  1.00 72.57           C  
ATOM    151  NZ  LYS A 113      31.670  39.648   3.910  1.00 73.25           N  
ATOM    152  N   GLN A 114      37.278  41.070   3.071  1.00 43.85           N  
ATOM    153  CA  GLN A 114      37.832  41.227   4.423  1.00 43.79           C  
ATOM    154  C   GLN A 114      38.890  42.320   4.527  1.00 44.58           C  
ATOM    155  O   GLN A 114      38.940  43.056   5.508  1.00 47.25           O  
ATOM    156  CB  GLN A 114      38.421  39.910   4.946  1.00 41.99           C  
ATOM    157  CG  GLN A 114      37.403  38.840   5.301  1.00 44.07           C  
ATOM    158  CD  GLN A 114      36.446  39.238   6.418  1.00 46.92           C  
ATOM    159  OE1 GLN A 114      36.196  40.413   6.650  1.00 50.04           O  
ATOM    160  NE2 GLN A 114      35.822  38.247   7.035  1.00 52.95           N  
ATOM    161  N   LEU A 115      39.694  42.469   3.485  1.00 44.66           N  
ATOM    162  CA  LEU A 115      40.838  43.379   3.519  1.00 42.46           C  
ATOM    163  C   LEU A 115      40.634  44.606   2.641  1.00 41.59           C  
ATOM    164  O   LEU A 115      41.530  45.421   2.510  1.00 45.53           O  
ATOM    165  CB  LEU A 115      42.071  42.621   3.046  1.00 40.05           C  
ATOM    166  CG  LEU A 115      43.454  43.043   3.473  1.00 41.04           C  
ATOM    167  CD1 LEU A 115      43.515  43.256   4.965  1.00 38.53           C  
ATOM    168  CD2 LEU A 115      44.410  41.973   3.052  1.00 37.88           C  
ATOM    169  N   ARG A 116      39.427  44.770   2.110  1.00 43.85           N  
ATOM    170  CA  ARG A 116      39.131  45.804   1.121  1.00 43.15           C  
ATOM    171  C   ARG A 116      40.235  45.950   0.079  1.00 42.76           C  
ATOM    172  O   ARG A 116      40.715  47.048  -0.180  1.00 44.18           O  
ATOM    173  CB  ARG A 116      38.855  47.142   1.796  1.00 45.06           C  
ATOM    174  CG  ARG A 116      37.451  47.294   2.362  1.00 46.04           C  
ATOM    175  CD  ARG A 116      37.461  48.400   3.428  1.00 55.70           C  
ATOM    176  NE  ARG A 116      36.188  48.491   4.139  1.00 64.49           N  
ATOM    177  CZ  ARG A 116      36.034  49.064   5.336  1.00 63.82           C  
ATOM    178  NH1 ARG A 116      37.074  49.592   5.967  1.00 63.32           N  
ATOM    179  NH2 ARG A 116      34.841  49.086   5.908  1.00 64.99           N  
ATOM    180  N   ALA A 117      40.652  44.826  -0.491  1.00 43.89           N  
ATOM    181  CA  ALA A 117      41.691  44.792  -1.525  1.00 45.07           C  
ATOM    182  C   ALA A 117      41.091  44.563  -2.919  1.00 45.58           C  
ATOM    183  O   ALA A 117      40.136  43.791  -3.055  1.00 45.39           O  
ATOM    184  CB  ALA A 117      42.678  43.675  -1.219  1.00 40.93           C  
ATOM    185  N   ASN A 118      41.769  45.085  -3.950  1.00 45.43           N  
ATOM    186  CA  ASN A 118      41.414  44.827  -5.357  1.00 44.06           C  
ATOM    187  C   ASN A 118      42.105  43.588  -5.951  1.00 44.62           C  
ATOM    188  O   ASN A 118      43.104  43.061  -5.414  1.00 38.50           O  
ATOM    189  CB  ASN A 118      41.815  46.007  -6.253  1.00 45.51           C  
ATOM    190  CG  ASN A 118      41.325  47.344  -5.740  1.00 52.65           C  
ATOM    191  OD1 ASN A 118      40.181  47.477  -5.297  1.00 53.99           O  
ATOM    192  ND2 ASN A 118      42.135  48.377  -5.950  1.00 55.88           N  
ATOM    193  N   LEU A 119      41.677  43.279  -7.173  1.00 44.95           N  
ATOM    194  CA  LEU A 119      42.347  42.337  -8.042  1.00 45.87           C  
ATOM    195  C   LEU A 119      43.861  42.492  -8.171  1.00 47.98           C  
ATOM    196  O   LEU A 119      44.617  41.531  -8.073  1.00 51.71           O  
ATOM    197  CB  LEU A 119      41.890  40.914  -7.806  1.00 48.80           C  
ATOM    198  CG  LEU A 119      41.798  39.984  -9.009  1.00 47.99           C  
ATOM    199  CD1 LEU A 119      41.847  38.544  -8.500  1.00 54.76           C  
ATOM    200  CD2 LEU A 119      40.505  40.262  -9.777  1.00 56.65           C  
ATOM    201  N   ASP A 120      44.310  43.729  -8.319  1.00 48.25           N  
ATOM    202  CA  ASP A 120      45.702  43.985  -8.640  1.00 49.43           C  
ATOM    203  C   ASP A 120      46.488  44.472  -7.426  1.00 47.97           C  
ATOM    204  O   ASP A 120      47.259  45.432  -7.520  1.00 50.10           O  
ATOM    205  CB  ASP A 120      45.785  45.002  -9.781  1.00 53.41           C  
ATOM    206  CG  ASP A 120      44.684  46.049  -9.709  1.00 61.26           C  
ATOM    207  OD1 ASP A 120      45.011  47.227  -9.442  1.00 68.12           O  
ATOM    208  OD2 ASP A 120      43.491  45.683  -9.849  1.00 66.66           O  
ATOM    209  N   ASP A 121      46.142  43.931  -6.263  1.00 41.71           N  
ATOM    210  CA  ASP A 121      46.862  44.213  -5.042  1.00 40.06           C  
ATOM    211  C   ASP A 121      47.551  42.918  -4.661  1.00 41.33           C  
ATOM    212  O   ASP A 121      46.958  41.853  -4.765  1.00 43.03           O  
ATOM    213  CB  ASP A 121      45.888  44.595  -3.927  1.00 37.88           C  
ATOM    214  CG  ASP A 121      45.443  46.049  -4.000  1.00 41.47           C  
ATOM    215  OD1 ASP A 121      46.296  46.932  -4.292  1.00 29.02           O  
ATOM    216  OD2 ASP A 121      44.263  46.312  -3.653  1.00 42.41           O  
ATOM    217  N   ASP A 122      48.830  42.989  -4.333  1.00 40.98           N  
ATOM    218  CA  ASP A 122      49.560  41.805  -3.920  1.00 40.21           C  
ATOM    219  C   ASP A 122      49.427  41.660  -2.409  1.00 41.37           C  
ATOM    220  O   ASP A 122      49.756  42.578  -1.653  1.00 42.89           O  
ATOM    221  CB  ASP A 122      51.026  41.893  -4.355  1.00 35.27           C  
ATOM    222  CG  ASP A 122      51.232  41.451  -5.805  1.00 44.78           C  
ATOM    223  OD1 ASP A 122      50.324  40.783  -6.357  1.00 53.46           O  
ATOM    224  OD2 ASP A 122      52.340  41.682  -6.358  1.00 47.79           O  
ATOM    225  N   ILE A 123      48.921  40.512  -1.983  1.00 40.08           N  
ATOM    226  CA  ILE A 123      48.590  40.289  -0.589  1.00 42.57           C  
ATOM    227  C   ILE A 123      49.416  39.122  -0.075  1.00 42.58           C  
ATOM    228  O   ILE A 123      49.527  38.108  -0.743  1.00 43.26           O  
ATOM    229  CB  ILE A 123      47.081  39.912  -0.442  1.00 44.37           C  
ATOM    230  CG1 ILE A 123      46.194  41.081  -0.873  1.00 44.18           C  
ATOM    231  CG2 ILE A 123      46.756  39.517   0.983  1.00 37.81           C  
ATOM    232  CD1 ILE A 123      46.446  42.326  -0.077  1.00 43.74           C  
ATOM    233  N   TRP A 124      50.003  39.271   1.105  1.00 40.83           N  
ATOM    234  CA  TRP A 124      50.732  38.181   1.723  1.00 41.30           C  
ATOM    235  C   TRP A 124      49.676  37.391   2.472  1.00 45.93           C  
ATOM    236  O   TRP A 124      48.740  37.998   2.996  1.00 47.93           O  
ATOM    237  CB  TRP A 124      51.697  38.753   2.753  1.00 40.86           C  
ATOM    238  CG  TRP A 124      52.879  39.426   2.181  1.00 38.56           C  
ATOM    239  CD1 TRP A 124      53.219  40.743   2.316  1.00 41.43           C  
ATOM    240  CD2 TRP A 124      53.997  38.786   1.551  1.00 32.89           C  
ATOM    241  NE1 TRP A 124      54.487  40.968   1.796  1.00 37.46           N  
ATOM    242  CE2 TRP A 124      55.004  39.771   1.380  1.00 39.68           C  
ATOM    243  CE3 TRP A 124      54.313  37.456   1.275  1.00 37.86           C  
ATOM    244  CZ2 TRP A 124      56.253  39.472   0.865  1.00 41.41           C  
ATOM    245  CZ3 TRP A 124      55.575  37.158   0.769  1.00 39.39           C  
ATOM    246  CH2 TRP A 124      56.515  38.157   0.553  1.00 38.85           C  
ATOM    247  N   GLU A 125      49.695  36.063   2.349  1.00 44.62           N  
ATOM    248  CA  GLU A 125      48.852  35.214   3.185  1.00 43.77           C  
ATOM    249  C   GLU A 125      49.714  34.299   4.043  1.00 44.41           C  
ATOM    250  O   GLU A 125      50.617  33.644   3.534  1.00 45.52           O  
ATOM    251  CB  GLU A 125      47.930  34.365   2.329  1.00 44.20           C  
ATOM    252  CG  GLU A 125      47.513  33.053   3.003  1.00 49.38           C  
ATOM    253  CD  GLU A 125      46.423  32.287   2.235  1.00 54.83           C  
ATOM    254  OE1 GLU A 125      46.703  31.815   1.110  1.00 60.51           O  
ATOM    255  OE2 GLU A 125      45.274  32.191   2.738  1.00 42.96           O  
ATOM    256  N   VAL A 126      49.493  34.292   5.348  1.00 43.33           N  
ATOM    257  CA  VAL A 126      50.225  33.352   6.213  1.00 42.62           C  
ATOM    258  C   VAL A 126      49.226  32.569   7.061  1.00 44.93           C  
ATOM    259  O   VAL A 126      48.321  33.157   7.688  1.00 43.94           O  
ATOM    260  CB  VAL A 126      51.163  34.081   7.172  1.00 44.01           C  
ATOM    261  CG1 VAL A 126      52.041  33.072   7.941  1.00 41.79           C  
ATOM    262  CG2 VAL A 126      52.008  35.113   6.418  1.00 42.73           C  
ATOM    263  N   ILE A 127      49.273  31.247   6.950  1.00 41.85           N  
ATOM    264  CA  ILE A 127      48.411  30.424   7.763  1.00 41.03           C  
ATOM    265  C   ILE A 127      49.243  29.534   8.679  1.00 41.54           C  
ATOM    266  O   ILE A 127      50.057  28.721   8.219  1.00 45.71           O  
ATOM    267  CB  ILE A 127      47.431  29.631   6.900  1.00 40.53           C  
ATOM    268  CG1 ILE A 127      46.420  30.574   6.241  1.00 40.40           C  
ATOM    269  CG2 ILE A 127      46.710  28.564   7.709  1.00 40.45           C  
ATOM    270  CD1 ILE A 127      45.567  29.869   5.217  1.00 42.10           C  
ATOM    271  N   ARG A 128      49.025  29.677   9.977  1.00 40.27           N  
ATOM    272  CA  ARG A 128      49.833  28.975  10.982  1.00 40.71           C  
ATOM    273  C   ARG A 128      48.959  28.269  11.980  1.00 39.08           C  
ATOM    274  O   ARG A 128      47.910  28.792  12.356  1.00 44.09           O  
ATOM    275  CB  ARG A 128      50.677  29.973  11.754  1.00 34.47           C  
ATOM    276  CG  ARG A 128      51.727  30.607  10.919  1.00 47.92           C  
ATOM    277  CD  ARG A 128      52.448  31.734  11.638  1.00 36.45           C  
ATOM    278  NE  ARG A 128      51.621  32.922  11.834  1.00 43.55           N  
ATOM    279  CZ  ARG A 128      51.943  33.885  12.702  1.00 51.22           C  
ATOM    280  NH1 ARG A 128      52.974  33.705  13.537  1.00 36.95           N  
ATOM    281  NH2 ARG A 128      51.124  34.907  12.892  1.00 36.96           N  
ATOM    282  N   SER A 129      49.523  27.260  12.620  1.00 38.11           N  
ATOM    283  CA  SER A 129      48.853  26.639  13.747  1.00 42.43           C  
ATOM    284  C   SER A 129      49.786  26.726  14.927  1.00 43.87           C  
ATOM    285  O   SER A 129      50.997  26.828  14.733  1.00 45.60           O  
ATOM    286  CB  SER A 129      48.513  25.168  13.446  1.00 43.55           C  
ATOM    287  OG  SER A 129      49.626  24.319  13.628  1.00 41.05           O  
ATOM    288  N   ARG A 130      49.223  26.765  16.137  1.00 43.65           N  
ATOM    289  CA  ARG A 130      50.019  26.822  17.356  1.00 42.35           C  
ATOM    290  C   ARG A 130      49.841  25.522  18.123  1.00 42.35           C  
ATOM    291  O   ARG A 130      48.726  25.170  18.481  1.00 40.76           O  
ATOM    292  CB  ARG A 130      49.546  27.961  18.260  1.00 45.20           C  
ATOM    293  CG  ARG A 130      49.268  29.262  17.574  1.00 41.82           C  
ATOM    294  CD  ARG A 130      50.559  29.998  17.308  1.00 45.31           C  
ATOM    295  NE  ARG A 130      50.301  31.262  16.628  1.00 57.57           N  
ATOM    296  CZ  ARG A 130      51.165  32.268  16.566  1.00 57.52           C  
ATOM    297  NH1 ARG A 130      52.361  32.155  17.133  1.00 50.27           N  
ATOM    298  NH2 ARG A 130      50.832  33.388  15.940  1.00 54.61           N  
ATOM    299  N   LYS A 131      50.947  24.949  18.575  1.00 44.76           N  
ATOM    300  CA  LYS A 131      50.918  23.685  19.296  1.00 47.23           C  
ATOM    301  C   LYS A 131      51.254  23.979  20.754  1.00 50.96           C  
ATOM    302  O   LYS A 131      52.362  24.427  21.066  1.00 52.31           O  
ATOM    303  CB  LYS A 131      51.932  22.704  18.673  1.00 47.68           C  
ATOM    304  CG  LYS A 131      52.017  21.312  19.308  1.00 45.64           C  
ATOM    305  CD  LYS A 131      52.984  20.443  18.512  1.00 47.34           C  
ATOM    306  CE  LYS A 131      53.587  19.314  19.349  1.00 50.35           C  
ATOM    307  NZ  LYS A 131      54.821  18.750  18.712  1.00 43.79           N  
ATOM    308  N   ILE A 132      50.220  23.977  21.588  1.00 52.42           N  
ATOM    309  CA  ILE A 132      50.382  24.257  23.009  1.00 52.02           C  
ATOM    310  C   ILE A 132      50.429  22.920  23.705  1.00 51.56           C  
ATOM    311  O   ILE A 132      49.415  22.245  23.866  1.00 48.01           O  
ATOM    312  CB  ILE A 132      49.248  25.153  23.530  1.00 55.32           C  
ATOM    313  CG1 ILE A 132      49.242  26.465  22.714  1.00 51.68           C  
ATOM    314  CG2 ILE A 132      49.369  25.357  25.058  1.00 48.69           C  
ATOM    315  CD1 ILE A 132      48.092  27.410  22.989  1.00 54.93           C  
ATOM    316  N   ASP A 133      51.657  22.473  23.933  1.00 53.44           N  
ATOM    317  CA  ASP A 133      51.938  21.054  24.035  1.00 52.82           C  
ATOM    318  C   ASP A 133      50.910  20.243  24.820  1.00 51.44           C  
ATOM    319  O   ASP A 133      50.293  20.735  25.767  1.00 50.25           O  
ATOM    320  CB  ASP A 133      53.405  20.768  24.412  1.00 54.99           C  
ATOM    321  CG  ASP A 133      54.380  20.940  23.218  1.00 56.94           C  
ATOM    322  OD1 ASP A 133      55.343  20.133  23.118  1.00 51.89           O  
ATOM    323  OD2 ASP A 133      54.190  21.873  22.387  1.00 52.28           O  
ATOM    324  N   GLY A 134      50.548  19.115  24.222  1.00 48.71           N  
ATOM    325  CA  GLY A 134      51.156  18.743  22.949  1.00 48.38           C  
ATOM    326  C   GLY A 134      50.182  18.764  21.789  1.00 47.91           C  
ATOM    327  O   GLY A 134      50.186  17.868  20.949  1.00 45.78           O  
ATOM    328  N   GLU A 135      49.376  19.814  21.704  1.00 48.45           N  
ATOM    329  CA  GLU A 135      48.273  19.813  20.758  1.00 48.63           C  
ATOM    330  C   GLU A 135      48.248  21.048  19.908  1.00 47.48           C  
ATOM    331  O   GLU A 135      48.537  22.140  20.390  1.00 49.62           O  
ATOM    332  CB  GLU A 135      46.945  19.699  21.497  1.00 48.29           C  
ATOM    333  CG  GLU A 135      46.794  18.433  22.310  1.00 51.61           C  
ATOM    334  CD  GLU A 135      45.388  18.267  22.834  1.00 55.94           C  
ATOM    335  OE1 GLU A 135      44.926  19.153  23.580  1.00 54.27           O  
ATOM    336  OE2 GLU A 135      44.731  17.269  22.465  1.00 61.85           O  
ATOM    337  N   HIS A 136      47.802  20.880  18.667  1.00 49.03           N  
ATOM    338  CA  HIS A 136      47.544  22.004  17.762  1.00 47.28           C  
ATOM    339  C   HIS A 136      46.140  22.525  18.032  1.00 46.91           C  
ATOM    340  O   HIS A 136      45.140  21.826  17.789  1.00 46.46           O  
ATOM    341  CB  HIS A 136      47.645  21.553  16.310  1.00 49.11           C  
ATOM    342  CG  HIS A 136      49.018  21.116  15.915  1.00 52.28           C  
ATOM    343  ND1 HIS A 136      49.993  22.004  15.507  1.00 49.72           N  
ATOM    344  CD2 HIS A 136      49.595  19.891  15.913  1.00 43.88           C  
ATOM    345  CE1 HIS A 136      51.107  21.340  15.257  1.00 52.48           C  
ATOM    346  NE2 HIS A 136      50.888  20.057  15.485  1.00 52.54           N  
ATOM    347  N   VAL A 137      46.056  23.759  18.515  1.00 42.98           N  
ATOM    348  CA  VAL A 137      44.796  24.224  19.044  1.00 40.68           C  
ATOM    349  C   VAL A 137      44.306  25.575  18.555  1.00 42.05           C  
ATOM    350  O   VAL A 137      43.151  25.918  18.790  1.00 45.63           O  
ATOM    351  CB  VAL A 137      44.778  24.149  20.556  1.00 38.08           C  
ATOM    352  CG1 VAL A 137      45.032  22.729  20.992  1.00 35.27           C  
ATOM    353  CG2 VAL A 137      45.837  25.053  21.120  1.00 38.17           C  
ATOM    354  N   ILE A 138      45.203  26.378  17.977  1.00 42.05           N  
ATOM    355  CA  ILE A 138      44.828  27.654  17.398  1.00 38.58           C  
ATOM    356  C   ILE A 138      45.236  27.695  15.932  1.00 41.34           C  
ATOM    357  O   ILE A 138      46.335  27.264  15.568  1.00 43.86           O  
ATOM    358  CB  ILE A 138      45.484  28.839  18.141  1.00 40.60           C  
ATOM    359  CG1 ILE A 138      44.992  28.887  19.585  1.00 42.18           C  
ATOM    360  CG2 ILE A 138      45.106  30.171  17.460  1.00 36.90           C  
ATOM    361  CD1 ILE A 138      46.079  29.202  20.589  1.00 44.46           C  
ATOM    362  N   LEU A 139      44.385  28.262  15.090  1.00 39.15           N  
ATOM    363  CA  LEU A 139      44.776  28.448  13.703  1.00 38.15           C  
ATOM    364  C   LEU A 139      44.791  29.927  13.402  1.00 37.88           C  
ATOM    365  O   LEU A 139      43.818  30.617  13.688  1.00 43.30           O  
ATOM    366  CB  LEU A 139      43.842  27.708  12.756  1.00 34.60           C  
ATOM    367  CG  LEU A 139      44.369  27.821  11.333  1.00 39.50           C  
ATOM    368  CD1 LEU A 139      45.502  26.830  11.126  1.00 32.23           C  
ATOM    369  CD2 LEU A 139      43.259  27.707  10.269  1.00 33.99           C  
ATOM    370  N   ASP A 140      45.969  30.451  13.070  1.00 40.66           N  
ATOM    371  CA  ASP A 140      46.144  31.891  12.864  1.00 39.74           C  
ATOM    372  C   ASP A 140      46.281  32.209  11.380  1.00 39.43           C  
ATOM    373  O   ASP A 140      47.167  31.685  10.708  1.00 42.68           O  
ATOM    374  CB  ASP A 140      47.382  32.373  13.603  1.00 38.14           C  
ATOM    375  CG  ASP A 140      47.119  32.621  15.085  1.00 55.63           C  
ATOM    376  OD1 ASP A 140      46.038  33.173  15.400  1.00 63.53           O  
ATOM    377  OD2 ASP A 140      48.025  32.363  15.930  1.00 59.81           O  
ATOM    378  N   LYS A 141      45.347  32.974  10.843  1.00 37.15           N  
ATOM    379  CA  LYS A 141      45.442  33.407   9.438  1.00 38.40           C  
ATOM    380  C   LYS A 141      45.716  34.908   9.328  1.00 39.56           C  
ATOM    381  O   LYS A 141      45.009  35.710   9.935  1.00 43.25           O  
ATOM    382  CB  LYS A 141      44.165  33.012   8.697  1.00 36.12           C  
ATOM    383  CG  LYS A 141      43.914  31.503   8.761  1.00 38.19           C  
ATOM    384  CD  LYS A 141      42.476  31.100   8.449  1.00 34.76           C  
ATOM    385  CE  LYS A 141      42.186  31.258   6.961  1.00 51.64           C  
ATOM    386  NZ  LYS A 141      40.958  30.550   6.537  1.00 48.89           N  
ATOM    387  N   ASP A 142      46.876  35.279   8.806  1.00 40.09           N  
ATOM    388  CA  ASP A 142      47.139  36.698   8.582  1.00 40.33           C  
ATOM    389  C   ASP A 142      47.119  37.007   7.092  1.00 40.46           C  
ATOM    390  O   ASP A 142      47.804  36.320   6.341  1.00 42.35           O  
ATOM    391  CB  ASP A 142      48.488  37.116   9.183  1.00 37.17           C  
ATOM    392  CG  ASP A 142      48.407  37.401  10.690  1.00 57.19           C  
ATOM    393  OD1 ASP A 142      48.042  38.552  11.022  1.00 65.38           O  
ATOM    394  OD2 ASP A 142      48.757  36.514  11.538  1.00 43.25           O  
ATOM    395  N   TYR A 143      46.696  38.227   6.772  1.00 38.12           N  
ATOM    396  CA  TYR A 143      46.651  38.748   5.409  1.00 40.12           C  
ATOM    397  C   TYR A 143      46.958  40.255   5.445  1.00 41.71           C  
ATOM    398  O   TYR A 143      46.236  41.011   6.088  1.00 42.83           O  
ATOM    399  CB  TYR A 143      45.239  38.573   4.847  1.00 32.74           C  
ATOM    400  CG  TYR A 143      44.821  37.134   4.719  1.00 46.51           C  
ATOM    401  CD1 TYR A 143      45.097  36.407   3.561  1.00 42.94           C  
ATOM    402  CD2 TYR A 143      44.085  36.516   5.716  1.00 42.82           C  
ATOM    403  CE1 TYR A 143      44.714  35.100   3.445  1.00 41.11           C  
ATOM    404  CE2 TYR A 143      43.839  35.191   5.670  1.00 42.98           C  
ATOM    405  CZ  TYR A 143      44.073  34.497   4.499  1.00 49.22           C  
ATOM    406  OH  TYR A 143      43.731  33.164   4.417  1.00 41.63           O  
ATOM    407  N   PHE A 144      47.983  40.703   4.723  1.00 43.83           N  
ATOM    408  CA  PHE A 144      48.290  42.119   4.654  1.00 46.43           C  
ATOM    409  C   PHE A 144      48.957  42.492   3.340  1.00 47.02           C  
ATOM    410  O   PHE A 144      49.360  41.608   2.575  1.00 46.89           O  
ATOM    411  CB  PHE A 144      49.133  42.543   5.850  1.00 46.97           C  
ATOM    412  CG  PHE A 144      50.329  41.683   6.063  1.00 44.41           C  
ATOM    413  CD1 PHE A 144      50.223  40.510   6.754  1.00 43.58           C  
ATOM    414  CD2 PHE A 144      51.519  41.973   5.431  1.00 45.05           C  
ATOM    415  CE1 PHE A 144      51.314  39.692   6.913  1.00 46.25           C  
ATOM    416  CE2 PHE A 144      52.626  41.168   5.602  1.00 49.30           C  
ATOM    417  CZ  PHE A 144      52.532  40.040   6.368  1.00 42.40           C  
ATOM    418  N   PHE A 145      48.893  43.779   2.989  1.00 44.90           N  
ATOM    419  CA  PHE A 145      49.338  44.215   1.655  1.00 41.71           C  
ATOM    420  C   PHE A 145      50.860  44.243   1.574  1.00 43.03           C  
ATOM    421  O   PHE A 145      51.527  45.046   2.268  1.00 46.51           O  
ATOM    422  CB  PHE A 145      48.812  45.613   1.300  1.00 41.91           C  
ATOM    423  CG  PHE A 145      47.334  45.695   1.137  1.00 38.17           C  
ATOM    424  CD1 PHE A 145      46.786  45.959  -0.112  1.00 39.32           C  
ATOM    425  CD2 PHE A 145      46.505  45.766   2.250  1.00 36.31           C  
ATOM    426  CE1 PHE A 145      45.430  46.202  -0.257  1.00 35.52           C  
ATOM    427  CE2 PHE A 145      45.117  45.868   2.102  1.00 27.08           C  
ATOM    428  CZ  PHE A 145      44.592  46.169   0.854  1.00 38.18           C  
ATOM    429  N   ARG A 146      51.347  43.689   0.476  1.00 40.23           N  
ATOM    430  CA  ARG A 146      52.755  43.736   0.219  1.00 38.81           C  
ATOM    431  C   ARG A 146      53.206  45.178   0.005  1.00 38.52           C  
ATOM    432  O   ARG A 146      54.340  45.522   0.279  1.00 42.94           O  
ATOM    433  CB  ARG A 146      53.089  42.896  -0.987  1.00 34.17           C  
ATOM    434  CG  ARG A 146      54.446  43.215  -1.575  1.00 30.22           C  
ATOM    435  CD  ARG A 146      54.429  42.887  -3.032  1.00 29.14           C  
ATOM    436  NE  ARG A 146      55.562  43.484  -3.693  1.00 53.09           N  
ATOM    437  CZ  ARG A 146      55.688  44.782  -3.936  1.00 52.33           C  
ATOM    438  NH1 ARG A 146      54.665  45.611  -3.739  1.00 42.77           N  
ATOM    439  NH2 ARG A 146      56.790  45.217  -4.522  1.00 57.09           N  
ATOM    440  N   LYS A 147      52.314  46.029  -0.468  1.00 39.24           N  
ATOM    441  CA  LYS A 147      52.708  47.402  -0.779  1.00 43.40           C  
ATOM    442  C   LYS A 147      53.217  48.133   0.450  1.00 40.31           C  
ATOM    443  O   LYS A 147      54.162  48.880   0.374  1.00 40.70           O  
ATOM    444  CB  LYS A 147      51.550  48.147  -1.426  1.00 44.24           C  
ATOM    445  CG  LYS A 147      51.423  49.602  -1.031  1.00 51.26           C  
ATOM    446  CD  LYS A 147      50.083  50.122  -1.560  1.00 67.74           C  
ATOM    447  CE  LYS A 147      49.006  49.012  -1.487  1.00 60.88           C  
ATOM    448  NZ  LYS A 147      47.901  49.209  -2.466  1.00 43.19           N  
ATOM    449  N   HIS A 148      52.733  47.720   1.609  1.00 42.84           N  
ATOM    450  CA  HIS A 148      53.174  48.293   2.867  1.00 44.06           C  
ATOM    451  C   HIS A 148      54.267  47.503   3.609  1.00 42.56           C  
ATOM    452  O   HIS A 148      55.093  48.115   4.314  1.00 44.31           O  
ATOM    453  CB  HIS A 148      51.968  48.629   3.759  1.00 41.65           C  
ATOM    454  CG  HIS A 148      51.215  49.845   3.304  1.00 49.59           C  
ATOM    455  ND1 HIS A 148      49.958  49.769   2.728  1.00 32.61           N  
ATOM    456  CD2 HIS A 148      51.602  51.151   3.217  1.00 28.84           C  
ATOM    457  CE1 HIS A 148      49.602  50.976   2.317  1.00 48.48           C  
ATOM    458  NE2 HIS A 148      50.588  51.825   2.579  1.00 36.79           N  
ATOM    459  N   VAL A 149      54.356  46.200   3.304  1.00 39.60           N  
ATOM    460  CA  VAL A 149      55.334  45.259   3.895  1.00 41.51           C  
ATOM    461  C   VAL A 149      55.999  44.402   2.797  1.00 43.78           C  
ATOM    462  O   VAL A 149      55.548  43.299   2.485  1.00 45.74           O  
ATOM    463  CB  VAL A 149      54.662  44.363   4.958  1.00 40.69           C  
ATOM    464  CG1 VAL A 149      55.641  43.393   5.566  1.00 33.98           C  
ATOM    465  CG2 VAL A 149      54.055  45.248   6.037  1.00 39.70           C  
ATOM    466  N   PRO A 150      56.921  45.014   2.056  1.00 40.92           N  
ATOM    467  CA  PRO A 150      57.387  44.395   0.828  1.00 38.05           C  
ATOM    468  C   PRO A 150      58.184  43.115   1.021  1.00 39.17           C  
ATOM    469  O   PRO A 150      58.449  42.405   0.054  1.00 43.31           O  
ATOM    470  CB  PRO A 150      58.277  45.484   0.197  1.00 34.19           C  
ATOM    471  CG  PRO A 150      58.437  46.548   1.248  1.00 39.76           C  
ATOM    472  CD  PRO A 150      57.234  46.449   2.109  1.00 36.95           C  
ATOM    473  N   HIS A 151      58.656  42.877   2.228  1.00 33.84           N  
ATOM    474  CA  HIS A 151      59.635  41.833   2.431  1.00 34.99           C  
ATOM    475  C   HIS A 151      59.151  40.968   3.563  1.00 38.96           C  
ATOM    476  O   HIS A 151      58.582  41.466   4.548  1.00 40.61           O  
ATOM    477  CB  HIS A 151      60.978  42.434   2.833  1.00 36.16           C  
ATOM    478  CG  HIS A 151      61.629  43.259   1.763  1.00 41.53           C  
ATOM    479  ND1 HIS A 151      62.374  44.385   2.042  1.00 37.85           N  
ATOM    480  CD2 HIS A 151      61.599  43.156   0.412  1.00 45.82           C  
ATOM    481  CE1 HIS A 151      62.795  44.926   0.913  1.00 45.89           C  
ATOM    482  NE2 HIS A 151      62.383  44.169  -0.090  1.00 50.00           N  
ATOM    483  N   LEU A 152      59.223  39.660   3.369  1.00 40.00           N  
ATOM    484  CA  LEU A 152      58.791  38.760   4.406  1.00 38.94           C  
ATOM    485  C   LEU A 152      59.465  37.411   4.203  1.00 40.25           C  
ATOM    486  O   LEU A 152      59.862  37.067   3.084  1.00 42.72           O  
ATOM    487  CB  LEU A 152      57.279  38.644   4.364  1.00 38.06           C  
ATOM    488  CG  LEU A 152      56.590  37.932   5.536  1.00 41.27           C  
ATOM    489  CD1 LEU A 152      56.650  38.792   6.793  1.00 37.46           C  
ATOM    490  CD2 LEU A 152      55.123  37.612   5.161  1.00 38.13           C  
ATOM    491  N   THR A 153      59.577  36.641   5.277  1.00 38.12           N  
ATOM    492  CA  THR A 153      60.153  35.322   5.181  1.00 39.69           C  
ATOM    493  C   THR A 153      59.421  34.275   6.027  1.00 39.19           C  
ATOM    494  O   THR A 153      58.747  34.610   7.002  1.00 32.58           O  
ATOM    495  CB  THR A 153      61.617  35.357   5.591  1.00 41.53           C  
ATOM    496  OG1 THR A 153      61.691  35.523   7.009  1.00 42.83           O  
ATOM    497  CG2 THR A 153      62.320  36.516   4.884  1.00 34.19           C  
ATOM    498  N   LYS A 154      59.607  32.998   5.691  1.00 39.08           N  
ATOM    499  CA  LYS A 154      59.093  31.921   6.553  1.00 41.54           C  
ATOM    500  C   LYS A 154      59.610  31.984   8.013  1.00 42.70           C  
ATOM    501  O   LYS A 154      58.888  31.608   8.937  1.00 43.55           O  
ATOM    502  CB  LYS A 154      59.362  30.548   5.951  1.00 36.80           C  
ATOM    503  CG  LYS A 154      59.097  29.359   6.872  1.00 41.26           C  
ATOM    504  CD  LYS A 154      59.014  28.068   6.037  1.00 37.33           C  
ATOM    505  CE  LYS A 154      59.256  26.837   6.870  1.00 44.56           C  
ATOM    506  NZ  LYS A 154      60.652  26.760   7.326  1.00 39.32           N  
ATOM    507  N   GLU A 155      60.784  32.581   8.222  1.00 40.15           N  
ATOM    508  CA  GLU A 155      61.393  32.622   9.542  1.00 40.73           C  
ATOM    509  C   GLU A 155      60.727  33.670  10.421  1.00 42.78           C  
ATOM    510  O   GLU A 155      60.592  33.484  11.626  1.00 38.49           O  
ATOM    511  CB  GLU A 155      62.880  32.908   9.437  1.00 39.74           C  
ATOM    512  CG  GLU A 155      63.601  32.799  10.757  1.00 52.95           C  
ATOM    513  CD  GLU A 155      65.112  32.707  10.584  1.00 72.85           C  
ATOM    514  OE1 GLU A 155      65.604  31.721   9.973  1.00 74.16           O  
ATOM    515  OE2 GLU A 155      65.809  33.633  11.061  1.00 80.08           O  
ATOM    516  N   ILE A 156      60.262  34.749   9.800  1.00 41.81           N  
ATOM    517  CA  ILE A 156      59.538  35.783  10.515  1.00 42.37           C  
ATOM    518  C   ILE A 156      58.156  35.307  10.992  1.00 43.45           C  
ATOM    519  O   ILE A 156      57.812  35.512  12.158  1.00 45.15           O  
ATOM    520  CB  ILE A 156      59.463  37.072   9.677  1.00 45.99           C  
ATOM    521  CG1 ILE A 156      60.830  37.789   9.712  1.00 47.71           C  
ATOM    522  CG2 ILE A 156      58.411  38.012  10.213  1.00 41.42           C  
ATOM    523  CD1 ILE A 156      60.982  38.920   8.695  1.00 29.83           C  
ATOM    524  N   CYS A 157      57.550  34.399  10.224  1.00 40.74           N  
ATOM    525  CA  CYS A 157      56.262  33.823  10.566  1.00 42.37           C  
ATOM    526  C   CYS A 157      56.352  32.783  11.670  1.00 46.96           C  
ATOM    527  O   CYS A 157      55.373  32.527  12.380  1.00 50.33           O  
ATOM    528  CB  CYS A 157      55.638  33.182   9.336  1.00 48.87           C  
ATOM    529  SG  CYS A 157      55.439  34.344   7.986  1.00 56.42           S  
ATOM    530  N   GLU A 158      57.501  32.128  11.776  1.00 44.66           N  
ATOM    531  CA  GLU A 158      57.701  31.170  12.838  1.00 42.98           C  
ATOM    532  C   GLU A 158      58.032  31.900  14.134  1.00 41.90           C  
ATOM    533  O   GLU A 158      58.003  31.327  15.213  1.00 40.84           O  
ATOM    534  CB  GLU A 158      58.800  30.190  12.450  1.00 43.56           C  
ATOM    535  CG  GLU A 158      58.475  29.463  11.166  1.00 46.88           C  
ATOM    536  CD  GLU A 158      59.556  28.492  10.730  1.00 54.67           C  
ATOM    537  OE1 GLU A 158      60.751  28.863  10.793  1.00 55.36           O  
ATOM    538  OE2 GLU A 158      59.195  27.387  10.256  1.00 51.86           O  
ATOM    539  N   ASN A 159      58.243  33.201  14.016  1.00 42.77           N  
ATOM    540  CA  ASN A 159      58.518  34.033  15.165  1.00 44.00           C  
ATOM    541  C   ASN A 159      57.313  34.962  15.429  1.00 45.52           C  
ATOM    542  O   ASN A 159      56.205  34.472  15.614  1.00 47.99           O  
ATOM    543  CB  ASN A 159      59.876  34.725  15.001  1.00 40.66           C  
ATOM    544  CG  ASN A 159      61.052  33.724  15.120  1.00 48.03           C  
ATOM    545  OD1 ASN A 159      61.381  33.263  16.218  1.00 53.44           O  
ATOM    546  ND2 ASN A 159      61.621  33.321  13.985  1.00 44.59           N  
ATOM    547  N   SER A 160      57.440  36.263  15.241  1.00 43.95           N  
ATOM    548  CA  SER A 160      56.256  37.091  15.433  1.00 41.97           C  
ATOM    549  C   SER A 160      56.010  37.984  14.253  1.00 43.75           C  
ATOM    550  O   SER A 160      56.893  38.732  13.842  1.00 47.06           O  
ATOM    551  CB  SER A 160      56.362  37.949  16.685  1.00 41.35           C  
ATOM    552  OG  SER A 160      55.400  38.982  16.656  1.00 40.95           O  
ATOM    553  N   ILE A 161      54.827  37.871  13.670  1.00 43.36           N  
ATOM    554  CA  ILE A 161      54.452  38.778  12.603  1.00 42.22           C  
ATOM    555  C   ILE A 161      54.092  40.141  13.180  1.00 41.79           C  
ATOM    556  O   ILE A 161      54.342  41.178  12.569  1.00 45.41           O  
ATOM    557  CB  ILE A 161      53.268  38.255  11.861  1.00 38.58           C  
ATOM    558  CG1 ILE A 161      53.640  36.922  11.225  1.00 36.52           C  
ATOM    559  CG2 ILE A 161      52.788  39.299  10.840  1.00 45.40           C  
ATOM    560  CD1 ILE A 161      52.625  36.415  10.163  1.00 47.69           C  
ATOM    561  N   TYR A 162      53.540  40.145  14.383  1.00 38.39           N  
ATOM    562  CA  TYR A 162      53.193  41.400  15.019  1.00 38.85           C  
ATOM    563  C   TYR A 162      54.453  42.249  15.247  1.00 38.51           C  
ATOM    564  O   TYR A 162      54.546  43.376  14.760  1.00 40.61           O  
ATOM    565  CB  TYR A 162      52.462  41.151  16.340  1.00 32.11           C  
ATOM    566  CG  TYR A 162      52.365  42.371  17.204  1.00 33.36           C  
ATOM    567  CD1 TYR A 162      51.290  43.237  17.083  1.00 32.89           C  
ATOM    568  CD2 TYR A 162      53.273  42.592  18.242  1.00 42.12           C  
ATOM    569  CE1 TYR A 162      51.164  44.338  17.898  1.00 30.20           C  
ATOM    570  CE2 TYR A 162      53.121  43.665  19.110  1.00 36.16           C  
ATOM    571  CZ  TYR A 162      52.103  44.575  18.873  1.00 34.24           C  
ATOM    572  OH  TYR A 162      51.920  45.641  19.697  1.00 35.65           O  
ATOM    573  N   GLU A 163      55.458  41.667  15.889  1.00 35.86           N  
ATOM    574  CA  GLU A 163      56.694  42.393  16.158  1.00 34.86           C  
ATOM    575  C   GLU A 163      57.350  42.863  14.873  1.00 39.71           C  
ATOM    576  O   GLU A 163      57.731  44.031  14.752  1.00 44.20           O  
ATOM    577  CB  GLU A 163      57.649  41.553  17.015  1.00 34.61           C  
ATOM    578  CG  GLU A 163      57.189  41.437  18.454  1.00 31.81           C  
ATOM    579  CD  GLU A 163      58.065  40.526  19.276  1.00 48.07           C  
ATOM    580  OE1 GLU A 163      58.831  39.770  18.652  1.00 52.52           O  
ATOM    581  OE2 GLU A 163      58.034  40.608  20.535  1.00 35.66           O  
ATOM    582  N   TYR A 164      57.278  42.044  13.833  1.00 39.25           N  
ATOM    583  CA  TYR A 164      57.891  42.429  12.582  1.00 37.67           C  
ATOM    584  C   TYR A 164      57.220  43.627  11.974  1.00 41.52           C  
ATOM    585  O   TYR A 164      57.868  44.462  11.336  1.00 42.72           O  
ATOM    586  CB  TYR A 164      57.867  41.298  11.588  1.00 35.14           C  
ATOM    587  CG  TYR A 164      58.457  41.702  10.280  1.00 37.76           C  
ATOM    588  CD1 TYR A 164      59.832  41.889  10.137  1.00 35.36           C  
ATOM    589  CD2 TYR A 164      57.654  41.822   9.150  1.00 39.52           C  
ATOM    590  CE1 TYR A 164      60.392  42.192   8.882  1.00 44.10           C  
ATOM    591  CE2 TYR A 164      58.185  42.183   7.920  1.00 35.63           C  
ATOM    592  CZ  TYR A 164      59.542  42.391   7.794  1.00 45.86           C  
ATOM    593  OH  TYR A 164      60.035  42.733   6.561  1.00 45.62           O  
ATOM    594  N   ILE A 165      55.901  43.539  11.916  1.00 42.90           N  
ATOM    595  CA  ILE A 165      55.076  44.619  11.389  1.00 40.61           C  
ATOM    596  C   ILE A 165      55.180  45.919  12.161  1.00 40.44           C  
ATOM    597  O   ILE A 165      55.443  46.954  11.581  1.00 44.18           O  
ATOM    598  CB  ILE A 165      53.629  44.165  11.262  1.00 40.76           C  
ATOM    599  CG1 ILE A 165      53.564  43.124  10.149  1.00 38.34           C  
ATOM    600  CG2 ILE A 165      52.738  45.330  10.962  1.00 41.47           C  
ATOM    601  CD1 ILE A 165      52.198  42.793   9.694  1.00 35.01           C  
ATOM    602  N   GLU A 166      55.106  45.848  13.482  1.00 43.30           N  
ATOM    603  CA  GLU A 166      55.335  47.023  14.304  1.00 41.21           C  
ATOM    604  C   GLU A 166      56.728  47.601  14.061  1.00 41.93           C  
ATOM    605  O   GLU A 166      56.919  48.823  14.035  1.00 40.97           O  
ATOM    606  CB  GLU A 166      55.177  46.670  15.768  1.00 42.28           C  
ATOM    607  CG  GLU A 166      53.747  46.369  16.182  1.00 45.78           C  
ATOM    608  CD  GLU A 166      52.865  47.599  16.100  1.00 61.49           C  
ATOM    609  OE1 GLU A 166      53.192  48.612  16.763  1.00 56.46           O  
ATOM    610  OE2 GLU A 166      51.853  47.554  15.358  1.00 62.68           O  
ATOM    611  N   GLY A 167      57.690  46.727  13.797  1.00 37.38           N  
ATOM    612  CA  GLY A 167      59.058  47.186  13.614  1.00 38.26           C  
ATOM    613  C   GLY A 167      59.204  48.022  12.360  1.00 40.47           C  
ATOM    614  O   GLY A 167      59.976  48.990  12.345  1.00 45.17           O  
ATOM    615  N   GLU A 168      58.449  47.662  11.317  1.00 39.73           N  
ATOM    616  CA  GLU A 168      58.566  48.279   9.988  1.00 40.40           C  
ATOM    617  C   GLU A 168      57.699  49.501   9.891  1.00 40.67           C  
ATOM    618  O   GLU A 168      58.076  50.456   9.248  1.00 44.98           O  
ATOM    619  CB  GLU A 168      58.154  47.317   8.862  1.00 38.98           C  
ATOM    620  CG  GLU A 168      59.057  46.097   8.714  1.00 53.04           C  
ATOM    621  CD  GLU A 168      60.521  46.469   8.520  1.00 55.38           C  
ATOM    622  OE1 GLU A 168      60.814  47.140   7.512  1.00 51.38           O  
ATOM    623  OE2 GLU A 168      61.372  46.084   9.361  1.00 52.58           O  
ATOM    624  N   LEU A 169      56.481  49.429  10.428  1.00 41.88           N  
ATOM    625  CA  LEU A 169      55.567  50.561  10.336  1.00 42.43           C  
ATOM    626  C   LEU A 169      54.601  50.776  11.483  1.00 43.54           C  
ATOM    627  O   LEU A 169      53.604  51.460  11.301  1.00 45.15           O  
ATOM    628  CB  LEU A 169      54.843  50.612   8.994  1.00 41.57           C  
ATOM    629  CG  LEU A 169      54.186  49.360   8.436  1.00 45.36           C  
ATOM    630  CD1 LEU A 169      53.173  48.885   9.396  1.00 46.35           C  
ATOM    631  CD2 LEU A 169      53.520  49.736   7.140  1.00 52.71           C  
ATOM    632  N   GLY A 170      55.083  50.546  12.694  1.00 43.74           N  
ATOM    633  CA  GLY A 170      54.250  50.684  13.876  1.00 45.75           C  
ATOM    634  C   GLY A 170      53.769  52.101  14.142  1.00 42.21           C  
ATOM    635  O   GLY A 170      52.797  52.306  14.848  1.00 44.09           O  
ATOM    636  N   LEU A 171      54.470  53.088  13.613  1.00 43.23           N  
ATOM    637  CA  LEU A 171      54.149  54.491  13.905  1.00 39.89           C  
ATOM    638  C   LEU A 171      53.008  54.960  12.972  1.00 41.04           C  
ATOM    639  O   LEU A 171      52.351  55.961  13.231  1.00 40.27           O  
ATOM    640  CB  LEU A 171      55.403  55.312  13.649  1.00 37.58           C  
ATOM    641  CG  LEU A 171      55.886  56.497  14.482  1.00 40.63           C  
ATOM    642  CD1 LEU A 171      55.810  56.252  15.998  1.00 31.95           C  
ATOM    643  CD2 LEU A 171      57.332  56.769  14.035  1.00 27.09           C  
ATOM    644  N   SER A 172      52.734  54.182  11.926  1.00 41.99           N  
ATOM    645  CA  SER A 172      51.713  54.527  10.942  1.00 38.96           C  
ATOM    646  C   SER A 172      50.428  53.804  11.271  1.00 39.95           C  
ATOM    647  O   SER A 172      49.437  53.960  10.570  1.00 42.71           O  
ATOM    648  CB  SER A 172      52.147  54.081   9.549  1.00 40.54           C  
ATOM    649  OG  SER A 172      53.384  54.645   9.172  1.00 47.02           O  
ATOM    650  N   ILE A 173      50.522  52.810  12.142  1.00 41.44           N  
ATOM    651  CA  ILE A 173      49.336  52.064  12.539  1.00 42.48           C  
ATOM    652  C   ILE A 173      48.507  52.837  13.555  1.00 43.50           C  
ATOM    653  O   ILE A 173      49.017  53.273  14.593  1.00 47.94           O  
ATOM    654  CB  ILE A 173      49.693  50.693  13.109  1.00 43.10           C  
ATOM    655  CG1 ILE A 173      50.544  49.922  12.094  1.00 41.43           C  
ATOM    656  CG2 ILE A 173      48.402  49.921  13.446  1.00 35.97           C  
ATOM    657  CD1 ILE A 173      50.674  48.433  12.398  1.00 36.59           C  
ATOM    658  N   SER A 174      47.227  53.001  13.266  1.00 43.00           N  
ATOM    659  CA  SER A 174      46.402  53.910  14.044  1.00 43.75           C  
ATOM    660  C   SER A 174      45.499  53.212  15.051  1.00 41.99           C  
ATOM    661  O   SER A 174      45.536  53.491  16.249  1.00 42.30           O  
ATOM    662  CB  SER A 174      45.570  54.782  13.117  1.00 42.66           C  
ATOM    663  OG  SER A 174      44.881  55.750  13.881  1.00 55.37           O  
ATOM    664  N   TYR A 175      44.580  52.410  14.544  1.00 44.01           N  
ATOM    665  CA  TYR A 175      43.664  51.692  15.411  1.00 44.07           C  
ATOM    666  C   TYR A 175      43.403  50.344  14.817  1.00 42.82           C  
ATOM    667  O   TYR A 175      43.584  50.144  13.615  1.00 43.17           O  
ATOM    668  CB  TYR A 175      42.339  52.452  15.576  1.00 45.69           C  
ATOM    669  CG  TYR A 175      41.557  52.673  14.292  1.00 43.16           C  
ATOM    670  CD1 TYR A 175      41.911  53.699  13.418  1.00 55.23           C  
ATOM    671  CD2 TYR A 175      40.353  51.995  14.057  1.00 54.27           C  
ATOM    672  CE1 TYR A 175      41.127  54.009  12.289  1.00 66.70           C  
ATOM    673  CE2 TYR A 175      39.547  52.295  12.937  1.00 61.84           C  
ATOM    674  CZ  TYR A 175      39.949  53.301  12.045  1.00 67.22           C  
ATOM    675  OH  TYR A 175      39.191  53.623  10.924  1.00 58.78           O  
ATOM    676  N   ALA A 176      42.962  49.425  15.669  1.00 43.74           N  
ATOM    677  CA  ALA A 176      42.478  48.122  15.233  1.00 40.96           C  
ATOM    678  C   ALA A 176      41.056  47.918  15.728  1.00 42.41           C  
ATOM    679  O   ALA A 176      40.677  48.352  16.821  1.00 40.85           O  
ATOM    680  CB  ALA A 176      43.360  47.027  15.761  1.00 42.56           C  
ATOM    681  N   GLN A 177      40.311  47.115  14.994  1.00 41.15           N  
ATOM    682  CA  GLN A 177      38.995  46.778  15.414  1.00 37.68           C  
ATOM    683  C   GLN A 177      38.883  45.253  15.486  1.00 41.33           C  
ATOM    684  O   GLN A 177      39.204  44.546  14.528  1.00 42.69           O  
ATOM    685  CB  GLN A 177      38.006  47.350  14.443  1.00 36.42           C  
ATOM    686  CG  GLN A 177      36.617  46.830  14.701  1.00 49.94           C  
ATOM    687  CD  GLN A 177      35.603  47.500  13.823  1.00 58.73           C  
ATOM    688  OE1 GLN A 177      35.835  48.627  13.349  1.00 59.46           O  
ATOM    689  NE2 GLN A 177      34.503  46.794  13.530  1.00 41.45           N  
ATOM    690  N   LYS A 178      38.375  44.769  16.615  1.00 41.49           N  
ATOM    691  CA  LYS A 178      38.300  43.343  16.934  1.00 39.79           C  
ATOM    692  C   LYS A 178      36.842  42.871  16.947  1.00 40.40           C  
ATOM    693  O   LYS A 178      35.969  43.543  17.485  1.00 37.43           O  
ATOM    694  CB  LYS A 178      38.887  43.139  18.330  1.00 38.61           C  
ATOM    695  CG  LYS A 178      39.632  41.872  18.529  1.00 45.62           C  
ATOM    696  CD  LYS A 178      40.581  41.965  19.732  1.00 54.15           C  
ATOM    697  CE  LYS A 178      41.955  42.528  19.334  1.00 67.26           C  
ATOM    698  NZ  LYS A 178      42.850  42.823  20.514  1.00 59.38           N  
ATOM    699  N   GLU A 179      36.570  41.702  16.385  1.00 37.10           N  
ATOM    700  CA  GLU A 179      35.244  41.141  16.474  1.00 37.41           C  
ATOM    701  C   GLU A 179      35.418  39.669  16.830  1.00 40.52           C  
ATOM    702  O   GLU A 179      36.210  38.960  16.188  1.00 38.86           O  
ATOM    703  CB  GLU A 179      34.499  41.286  15.146  1.00 40.81           C  
ATOM    704  CG  GLU A 179      33.038  40.796  15.226  1.00 52.87           C  
ATOM    705  CD  GLU A 179      32.435  40.384  13.880  1.00 63.64           C  
ATOM    706  OE1 GLU A 179      33.141  39.730  13.071  1.00 67.07           O  
ATOM    707  OE2 GLU A 179      31.204  40.552  13.717  1.00 59.88           O  
ATOM    708  N   ILE A 180      34.847  39.282  17.972  1.00 39.33           N  
ATOM    709  CA  ILE A 180      34.978  37.924  18.509  1.00 36.71           C  
ATOM    710  C   ILE A 180      33.620  37.227  18.487  1.00 38.07           C  
ATOM    711  O   ILE A 180      32.669  37.684  19.117  1.00 38.93           O  
ATOM    712  CB  ILE A 180      35.455  37.948  19.980  1.00 36.20           C  
ATOM    713  CG1 ILE A 180      36.777  38.689  20.117  1.00 34.87           C  
ATOM    714  CG2 ILE A 180      35.656  36.561  20.497  1.00 30.41           C  
ATOM    715  CD1 ILE A 180      37.117  38.955  21.518  1.00 25.51           C  
ATOM    716  N   VAL A 181      33.521  36.152  17.729  1.00 37.63           N  
ATOM    717  CA  VAL A 181      32.298  35.353  17.676  1.00 41.90           C  
ATOM    718  C   VAL A 181      32.632  33.864  17.786  1.00 43.16           C  
ATOM    719  O   VAL A 181      33.794  33.489  17.987  1.00 45.51           O  
ATOM    720  CB  VAL A 181      31.557  35.551  16.336  1.00 42.14           C  
ATOM    721  CG1 VAL A 181      31.216  37.013  16.127  1.00 34.93           C  
ATOM    722  CG2 VAL A 181      32.421  35.034  15.193  1.00 37.27           C  
ATOM    723  N   ALA A 182      31.598  33.031  17.803  1.00 43.94           N  
ATOM    724  CA  ALA A 182      31.799  31.579  17.763  1.00 43.98           C  
ATOM    725  C   ALA A 182      31.261  31.022  16.456  1.00 42.32           C  
ATOM    726  O   ALA A 182      30.172  31.380  16.019  1.00 42.92           O  
ATOM    727  CB  ALA A 182      31.142  30.905  18.936  1.00 41.11           C  
ATOM    728  N   GLU A 183      32.010  30.101  15.873  1.00 42.77           N  
ATOM    729  CA  GLU A 183      31.672  29.534  14.582  1.00 42.44           C  
ATOM    730  C   GLU A 183      31.802  28.017  14.590  1.00 39.44           C  
ATOM    731  O   GLU A 183      32.571  27.461  15.363  1.00 38.39           O  
ATOM    732  CB  GLU A 183      32.585  30.139  13.498  1.00 44.65           C  
ATOM    733  CG  GLU A 183      32.503  31.665  13.399  1.00 46.76           C  
ATOM    734  CD  GLU A 183      33.183  32.235  12.162  1.00 50.54           C  
ATOM    735  OE1 GLU A 183      33.974  31.511  11.521  1.00 54.73           O  
ATOM    736  OE2 GLU A 183      32.893  33.398  11.804  1.00 48.67           O  
ATOM    737  N   PRO A 184      31.010  27.340  13.753  1.00 40.19           N  
ATOM    738  CA  PRO A 184      31.232  25.923  13.524  1.00 39.25           C  
ATOM    739  C   PRO A 184      32.643  25.709  12.998  1.00 39.81           C  
ATOM    740  O   PRO A 184      33.177  26.563  12.294  1.00 40.68           O  
ATOM    741  CB  PRO A 184      30.230  25.595  12.413  1.00 38.09           C  
ATOM    742  CG  PRO A 184      29.145  26.597  12.582  1.00 36.76           C  
ATOM    743  CD  PRO A 184      29.836  27.846  13.016  1.00 40.39           C  
ATOM    744  N   CYS A 185      33.234  24.569  13.317  1.00 42.17           N  
ATOM    745  CA  CYS A 185      34.509  24.185  12.721  1.00 45.46           C  
ATOM    746  C   CYS A 185      34.357  23.925  11.227  1.00 43.98           C  
ATOM    747  O   CYS A 185      33.362  23.349  10.785  1.00 42.58           O  
ATOM    748  CB  CYS A 185      35.052  22.926  13.395  1.00 48.54           C  
ATOM    749  SG  CYS A 185      35.734  23.222  15.038  1.00 59.45           S  
ATOM    750  N   THR A 186      35.420  24.202  10.484  1.00 42.88           N  
ATOM    751  CA  THR A 186      35.420  24.015   9.036  1.00 38.15           C  
ATOM    752  C   THR A 186      36.332  22.842   8.693  1.00 37.15           C  
ATOM    753  O   THR A 186      37.083  22.377   9.547  1.00 35.07           O  
ATOM    754  CB  THR A 186      36.030  25.254   8.386  1.00 38.61           C  
ATOM    755  OG1 THR A 186      37.346  25.404   8.901  1.00 34.17           O  
ATOM    756  CG2 THR A 186      35.210  26.510   8.719  1.00 28.25           C  
ATOM    757  N   ASP A 187      36.395  22.467   7.418  1.00 37.22           N  
ATOM    758  CA  ASP A 187      37.302  21.387   7.021  1.00 38.12           C  
ATOM    759  C   ASP A 187      38.770  21.766   7.275  1.00 38.32           C  
ATOM    760  O   ASP A 187      39.511  21.020   7.909  1.00 38.02           O  
ATOM    761  CB  ASP A 187      37.066  20.956   5.571  1.00 36.18           C  
ATOM    762  CG  ASP A 187      35.602  20.671   5.284  1.00 39.75           C  
ATOM    763  OD1 ASP A 187      34.779  21.571   5.539  1.00 41.01           O  
ATOM    764  OD2 ASP A 187      35.260  19.549   4.833  1.00 33.23           O  
ATOM    765  N   GLU A 188      39.124  23.009   6.983  1.00 38.87           N  
ATOM    766  CA  GLU A 188      40.483  23.459   7.217  1.00 40.34           C  
ATOM    767  C   GLU A 188      40.897  23.312   8.690  1.00 41.46           C  
ATOM    768  O   GLU A 188      42.008  22.863   9.001  1.00 41.75           O  
ATOM    769  CB  GLU A 188      40.640  24.895   6.744  1.00 39.66           C  
ATOM    770  CG  GLU A 188      42.039  25.430   6.908  1.00 41.01           C  
ATOM    771  CD  GLU A 188      42.097  26.907   6.621  1.00 41.17           C  
ATOM    772  OE1 GLU A 188      41.270  27.639   7.213  1.00 46.88           O  
ATOM    773  OE2 GLU A 188      42.882  27.312   5.728  1.00 35.81           O  
ATOM    774  N   ASP A 189      39.967  23.635   9.584  1.00 41.76           N  
ATOM    775  CA  ASP A 189      40.144  23.450  11.031  1.00 43.56           C  
ATOM    776  C   ASP A 189      40.427  21.981  11.442  1.00 43.45           C  
ATOM    777  O   ASP A 189      41.153  21.719  12.395  1.00 47.77           O  
ATOM    778  CB  ASP A 189      38.902  23.971  11.786  1.00 43.76           C  
ATOM    779  CG  ASP A 189      38.775  25.506  11.753  1.00 47.69           C  
ATOM    780  OD1 ASP A 189      39.749  26.182  11.350  1.00 46.49           O  
ATOM    781  OD2 ASP A 189      37.707  26.035  12.153  1.00 46.54           O  
ATOM    782  N   ARG A 190      39.800  21.023  10.785  1.00 37.53           N  
ATOM    783  CA  ARG A 190      39.939  19.649  11.232  1.00 37.65           C  
ATOM    784  C   ARG A 190      41.185  18.975  10.675  1.00 38.44           C  
ATOM    785  O   ARG A 190      41.754  18.081  11.305  1.00 36.43           O  
ATOM    786  CB  ARG A 190      38.682  18.857  10.905  1.00 35.16           C  
ATOM    787  CG  ARG A 190      37.444  19.473  11.509  1.00 34.04           C  
ATOM    788  CD  ARG A 190      36.223  18.614  11.272  1.00 30.62           C  
ATOM    789  NE  ARG A 190      35.603  18.291  12.551  1.00 29.08           N  
ATOM    790  CZ  ARG A 190      34.569  18.939  13.082  1.00 27.01           C  
ATOM    791  NH1 ARG A 190      33.922  19.864  12.376  1.00 35.99           N  
ATOM    792  NH2 ARG A 190      34.144  18.604  14.297  1.00 12.06           N  
ATOM    793  N   GLU A 191      41.643  19.442   9.519  1.00 40.03           N  
ATOM    794  CA  GLU A 191      42.880  18.929   8.944  1.00 39.64           C  
ATOM    795  C   GLU A 191      44.051  19.366   9.796  1.00 40.23           C  
ATOM    796  O   GLU A 191      44.920  18.567  10.114  1.00 40.43           O  
ATOM    797  CB  GLU A 191      43.096  19.485   7.545  1.00 38.52           C  
ATOM    798  CG  GLU A 191      42.385  18.758   6.456  1.00 47.38           C  
ATOM    799  CD  GLU A 191      43.041  19.034   5.137  1.00 59.39           C  
ATOM    800  OE1 GLU A 191      43.874  19.973   5.099  1.00 57.10           O  
ATOM    801  OE2 GLU A 191      42.842  18.233   4.193  1.00 63.48           O  
ATOM    802  N   LEU A 192      44.037  20.627  10.214  1.00 39.55           N  
ATOM    803  CA  LEU A 192      45.216  21.223  10.803  1.00 39.37           C  
ATOM    804  C   LEU A 192      45.261  21.214  12.331  1.00 40.07           C  
ATOM    805  O   LEU A 192      46.334  21.353  12.913  1.00 43.58           O  
ATOM    806  CB  LEU A 192      45.445  22.642  10.242  1.00 40.19           C  
ATOM    807  CG  LEU A 192      45.415  22.796   8.714  1.00 35.20           C  
ATOM    808  CD1 LEU A 192      45.740  24.207   8.282  1.00 30.65           C  
ATOM    809  CD2 LEU A 192      46.349  21.811   8.019  1.00 22.92           C  
ATOM    810  N   LEU A 193      44.117  21.118  12.998  1.00 38.41           N  
ATOM    811  CA  LEU A 193      44.138  21.138  14.472  1.00 38.32           C  
ATOM    812  C   LEU A 193      43.636  19.839  15.086  1.00 36.49           C  
ATOM    813  O   LEU A 193      42.915  19.080  14.449  1.00 37.77           O  
ATOM    814  CB  LEU A 193      43.342  22.321  15.042  1.00 37.28           C  
ATOM    815  CG  LEU A 193      43.562  23.714  14.449  1.00 41.29           C  
ATOM    816  CD1 LEU A 193      42.464  24.649  14.927  1.00 46.47           C  
ATOM    817  CD2 LEU A 193      44.948  24.277  14.817  1.00 38.38           C  
ATOM    818  N   ASP A 194      44.078  19.553  16.304  1.00 35.49           N  
ATOM    819  CA  ASP A 194      43.569  18.409  17.037  1.00 33.89           C  
ATOM    820  C   ASP A 194      42.245  18.811  17.695  1.00 34.63           C  
ATOM    821  O   ASP A 194      42.231  19.369  18.790  1.00 36.79           O  
ATOM    822  CB  ASP A 194      44.592  17.965  18.090  1.00 34.75           C  
ATOM    823  CG  ASP A 194      46.015  17.875  17.536  1.00 38.33           C  
ATOM    824  OD1 ASP A 194      46.203  17.294  16.449  1.00 43.28           O  
ATOM    825  OD2 ASP A 194      46.959  18.326  18.221  1.00 40.94           O  
ATOM    826  N   LEU A 195      41.129  18.545  17.025  1.00 36.27           N  
ATOM    827  CA  LEU A 195      39.840  19.023  17.517  1.00 36.54           C  
ATOM    828  C   LEU A 195      39.044  18.071  18.397  1.00 38.17           C  
ATOM    829  O   LEU A 195      37.970  18.430  18.881  1.00 40.30           O  
ATOM    830  CB  LEU A 195      38.992  19.595  16.384  1.00 35.53           C  
ATOM    831  CG  LEU A 195      39.570  20.897  15.813  1.00 37.94           C  
ATOM    832  CD1 LEU A 195      38.865  21.306  14.548  1.00 42.68           C  
ATOM    833  CD2 LEU A 195      39.533  22.061  16.828  1.00 42.64           C  
ATOM    834  N   ARG A 196      39.644  16.940  18.753  1.00 39.97           N  
ATOM    835  CA  ARG A 196      38.987  15.977  19.647  1.00 39.96           C  
ATOM    836  C   ARG A 196      37.508  15.802  19.290  1.00 38.80           C  
ATOM    837  O   ARG A 196      37.151  15.590  18.129  1.00 36.69           O  
ATOM    838  CB  ARG A 196      39.061  16.463  21.098  1.00 40.37           C  
ATOM    839  CG  ARG A 196      40.451  16.615  21.698  1.00 43.34           C  
ATOM    840  CD  ARG A 196      40.312  17.105  23.143  1.00 47.50           C  
ATOM    841  NE  ARG A 196      41.583  17.257  23.848  1.00 45.15           N  
ATOM    842  CZ  ARG A 196      41.977  16.486  24.857  1.00 44.78           C  
ATOM    843  NH1 ARG A 196      41.223  15.468  25.258  1.00 43.66           N  
ATOM    844  NH2 ARG A 196      43.132  16.726  25.460  1.00 41.78           N  
ATOM    845  N   GLY A 197      36.659  15.883  20.314  1.00 38.12           N  
ATOM    846  CA  GLY A 197      35.213  15.923  20.130  1.00 38.39           C  
ATOM    847  C   GLY A 197      34.705  17.350  20.243  1.00 38.84           C  
ATOM    848  O   GLY A 197      33.872  17.654  21.091  1.00 39.01           O  
ATOM    849  N   TYR A 198      35.348  18.260  19.522  1.00 39.60           N  
ATOM    850  CA  TYR A 198      34.913  19.650  19.481  1.00 41.50           C  
ATOM    851  C   TYR A 198      34.190  20.011  18.177  1.00 39.85           C  
ATOM    852  O   TYR A 198      34.506  19.468  17.127  1.00 40.88           O  
ATOM    853  CB  TYR A 198      36.091  20.579  19.752  1.00 42.66           C  
ATOM    854  CG  TYR A 198      36.332  20.807  21.231  1.00 48.77           C  
ATOM    855  CD1 TYR A 198      35.425  21.549  21.991  1.00 57.79           C  
ATOM    856  CD2 TYR A 198      37.439  20.252  21.879  1.00 46.50           C  
ATOM    857  CE1 TYR A 198      35.638  21.783  23.343  1.00 60.06           C  
ATOM    858  CE2 TYR A 198      37.669  20.486  23.231  1.00 52.70           C  
ATOM    859  CZ  TYR A 198      36.760  21.252  23.960  1.00 59.52           C  
ATOM    860  OH  TYR A 198      36.958  21.492  25.303  1.00 50.79           O  
ATOM    861  N   ASP A 199      33.110  20.779  18.285  1.00 39.68           N  
ATOM    862  CA  ASP A 199      32.288  21.126  17.124  1.00 38.91           C  
ATOM    863  C   ASP A 199      32.385  22.607  16.749  1.00 38.94           C  
ATOM    864  O   ASP A 199      31.960  22.981  15.655  1.00 38.66           O  
ATOM    865  CB  ASP A 199      30.822  20.779  17.381  1.00 39.32           C  
ATOM    866  CG  ASP A 199      30.551  19.281  17.324  1.00 47.12           C  
ATOM    867  OD1 ASP A 199      31.055  18.618  16.388  1.00 43.71           O  
ATOM    868  OD2 ASP A 199      29.748  18.791  18.155  1.00 39.27           O  
ATOM    869  N   HIS A 200      32.757  23.452  17.715  1.00 36.77           N  
ATOM    870  CA  HIS A 200      32.863  24.909  17.490  1.00 39.06           C  
ATOM    871  C   HIS A 200      34.217  25.496  17.841  1.00 37.98           C  
ATOM    872  O   HIS A 200      35.037  24.841  18.501  1.00 37.00           O  
ATOM    873  CB  HIS A 200      31.768  25.691  18.225  1.00 34.59           C  
ATOM    874  CG  HIS A 200      30.381  25.341  17.785  1.00 42.56           C  
ATOM    875  ND1 HIS A 200      29.719  24.214  18.231  1.00 44.68           N  
ATOM    876  CD2 HIS A 200      29.526  25.976  16.948  1.00 40.91           C  
ATOM    877  CE1 HIS A 200      28.533  24.147  17.652  1.00 44.65           C  
ATOM    878  NE2 HIS A 200      28.385  25.213  16.882  1.00 45.69           N  
HETATM  879  N   MSE A 201      34.399  26.761  17.453  1.00 39.09           N  
HETATM  880  CA  MSE A 201      35.637  27.496  17.643  1.00 38.17           C  
HETATM  881  C   MSE A 201      35.292  28.880  18.154  1.00 42.08           C  
HETATM  882  O   MSE A 201      34.212  29.403  17.877  1.00 45.68           O  
HETATM  883  CB  MSE A 201      36.327  27.696  16.302  1.00 37.99           C  
HETATM  884  CG  MSE A 201      36.556  26.439  15.504  1.00 43.67           C  
HETATM  885 SE   MSE A 201      38.290  25.589  15.768  0.50 39.93          SE  
HETATM  886  CE  MSE A 201      37.892  24.636  17.396  1.00 51.65           C  
ATOM    887  N   VAL A 202      36.219  29.496  18.878  1.00 42.89           N  
ATOM    888  CA  VAL A 202      36.129  30.912  19.147  1.00 41.03           C  
ATOM    889  C   VAL A 202      36.993  31.614  18.080  1.00 42.26           C  
ATOM    890  O   VAL A 202      38.086  31.129  17.771  1.00 40.46           O  
ATOM    891  CB  VAL A 202      36.582  31.249  20.586  1.00 41.34           C  
ATOM    892  CG1 VAL A 202      36.587  32.792  20.823  1.00 38.29           C  
ATOM    893  CG2 VAL A 202      35.666  30.604  21.567  1.00 33.55           C  
ATOM    894  N   VAL A 203      36.368  32.508  17.311  1.00 40.85           N  
ATOM    895  CA  VAL A 203      37.058  33.180  16.214  1.00 42.76           C  
ATOM    896  C   VAL A 203      37.256  34.664  16.467  1.00 44.26           C  
ATOM    897  O   VAL A 203      36.290  35.428  16.561  1.00 43.14           O  
ATOM    898  CB  VAL A 203      36.342  33.030  14.864  1.00 43.90           C  
ATOM    899  CG1 VAL A 203      37.141  33.753  13.778  1.00 41.65           C  
ATOM    900  CG2 VAL A 203      36.162  31.565  14.501  1.00 40.32           C  
ATOM    901  N   VAL A 204      38.509  35.055  16.649  1.00 45.09           N  
ATOM    902  CA  VAL A 204      38.863  36.461  16.817  1.00 43.85           C  
ATOM    903  C   VAL A 204      39.326  37.070  15.497  1.00 45.33           C  
ATOM    904  O   VAL A 204      40.268  36.581  14.853  1.00 40.56           O  
ATOM    905  CB  VAL A 204      39.974  36.640  17.863  1.00 44.02           C  
ATOM    906  CG1 VAL A 204      40.246  38.122  18.060  1.00 41.28           C  
ATOM    907  CG2 VAL A 204      39.565  35.965  19.188  1.00 40.17           C  
ATOM    908  N   ARG A 205      38.590  38.081  15.055  1.00 47.90           N  
ATOM    909  CA  ARG A 205      38.945  38.810  13.845  1.00 47.63           C  
ATOM    910  C   ARG A 205      39.379  40.211  14.180  1.00 46.82           C  
ATOM    911  O   ARG A 205      38.644  40.958  14.812  1.00 45.42           O  
ATOM    912  CB  ARG A 205      37.773  38.873  12.892  1.00 46.14           C  
ATOM    913  CG  ARG A 205      37.560  37.581  12.150  1.00 45.87           C  
ATOM    914  CD  ARG A 205      36.379  37.726  11.218  1.00 39.23           C  
ATOM    915  NE  ARG A 205      36.114  36.502  10.479  1.00 47.04           N  
ATOM    916  CZ  ARG A 205      35.234  35.579  10.847  1.00 40.86           C  
ATOM    917  NH1 ARG A 205      34.645  35.623  12.041  1.00 44.05           N  
ATOM    918  NH2 ARG A 205      35.097  34.513  10.101  1.00 36.05           N  
ATOM    919  N   ASN A 206      40.429  40.644  13.509  1.00 47.30           N  
ATOM    920  CA  ASN A 206      41.066  41.891  13.849  1.00 47.48           C  
ATOM    921  C   ASN A 206      41.459  42.633  12.571  1.00 46.63           C  
ATOM    922  O   ASN A 206      42.009  42.041  11.648  1.00 53.12           O  
ATOM    923  CB  ASN A 206      42.288  41.554  14.683  1.00 48.35           C  
ATOM    924  CG  ASN A 206      42.904  42.742  15.303  1.00 49.37           C  
ATOM    925  OD1 ASN A 206      42.224  43.696  15.647  1.00 65.77           O  
ATOM    926  ND2 ASN A 206      44.174  42.626  15.616  1.00 72.74           N  
ATOM    927  N   TYR A 207      41.011  43.870  12.455  1.00 45.55           N  
ATOM    928  CA  TYR A 207      41.265  44.697  11.284  1.00 42.94           C  
ATOM    929  C   TYR A 207      42.131  45.885  11.682  1.00 43.68           C  
ATOM    930  O   TYR A 207      41.726  46.700  12.505  1.00 45.26           O  
ATOM    931  CB  TYR A 207      39.932  45.200  10.757  1.00 40.24           C  
ATOM    932  CG  TYR A 207      38.980  44.076  10.434  1.00 40.81           C  
ATOM    933  CD1 TYR A 207      38.805  43.638   9.117  1.00 38.84           C  
ATOM    934  CD2 TYR A 207      38.228  43.464  11.436  1.00 45.23           C  
ATOM    935  CE1 TYR A 207      37.961  42.581   8.818  1.00 40.79           C  
ATOM    936  CE2 TYR A 207      37.307  42.468  11.131  1.00 39.84           C  
ATOM    937  CZ  TYR A 207      37.231  41.982   9.830  1.00 44.52           C  
ATOM    938  OH  TYR A 207      36.328  40.991   9.508  1.00 38.09           O  
ATOM    939  N   VAL A 208      43.321  45.991  11.099  1.00 43.68           N  
ATOM    940  CA  VAL A 208      44.278  47.025  11.496  1.00 40.23           C  
ATOM    941  C   VAL A 208      44.350  48.111  10.422  1.00 43.43           C  
ATOM    942  O   VAL A 208      44.259  47.802   9.239  1.00 50.38           O  
ATOM    943  CB  VAL A 208      45.647  46.393  11.705  1.00 43.12           C  
ATOM    944  CG1 VAL A 208      46.590  47.321  12.444  1.00 35.07           C  
ATOM    945  CG2 VAL A 208      45.486  45.105  12.446  1.00 34.09           C  
ATOM    946  N   PHE A 209      44.200  49.366  10.839  1.00 41.74           N  
ATOM    947  CA  PHE A 209      44.127  50.510   9.924  1.00 35.38           C  
ATOM    948  C   PHE A 209      45.356  51.429  10.104  1.00 37.89           C  
ATOM    949  O   PHE A 209      45.985  51.450  11.176  1.00 36.04           O  
ATOM    950  CB  PHE A 209      42.884  51.329  10.243  1.00 38.00           C  
ATOM    951  CG  PHE A 209      41.591  50.639   9.939  1.00 39.16           C  
ATOM    952  CD1 PHE A 209      40.869  50.970   8.784  1.00 42.19           C  
ATOM    953  CD2 PHE A 209      41.023  49.760  10.866  1.00 32.95           C  
ATOM    954  CE1 PHE A 209      39.631  50.356   8.519  1.00 40.62           C  
ATOM    955  CE2 PHE A 209      39.810  49.133  10.613  1.00 37.30           C  
ATOM    956  CZ  PHE A 209      39.088  49.458   9.451  1.00 38.93           C  
ATOM    957  N   LEU A 210      45.685  52.206   9.078  1.00 37.61           N  
ATOM    958  CA  LEU A 210      46.840  53.098   9.161  1.00 41.23           C  
ATOM    959  C   LEU A 210      46.431  54.531   9.504  1.00 42.57           C  
ATOM    960  O   LEU A 210      45.260  54.900   9.421  1.00 40.95           O  
ATOM    961  CB  LEU A 210      47.638  53.085   7.857  1.00 40.53           C  
ATOM    962  CG  LEU A 210      47.942  51.725   7.232  1.00 44.53           C  
ATOM    963  CD1 LEU A 210      48.497  51.923   5.828  1.00 46.16           C  
ATOM    964  CD2 LEU A 210      48.939  50.978   8.080  1.00 37.05           C  
ATOM    965  N   GLU A 211      47.423  55.361   9.797  1.00 45.81           N  
ATOM    966  CA  GLU A 211      47.174  56.753  10.096  1.00 45.96           C  
ATOM    967  C   GLU A 211      46.441  57.426   8.939  1.00 46.81           C  
ATOM    968  O   GLU A 211      45.567  58.260   9.158  1.00 47.83           O  
ATOM    969  CB  GLU A 211      48.481  57.464  10.407  1.00 46.00           C  
ATOM    970  CG  GLU A 211      48.387  58.386  11.614  1.00 53.88           C  
ATOM    971  CD  GLU A 211      49.546  58.180  12.582  0.50 51.80           C  
ATOM    972  OE1 GLU A 211      50.670  58.628  12.263  0.50 49.28           O  
ATOM    973  OE2 GLU A 211      49.334  57.542  13.644  0.50 43.54           O  
ATOM    974  N   ASP A 212      46.685  56.963   7.719  1.00 48.26           N  
ATOM    975  CA  ASP A 212      46.070  57.591   6.540  1.00 49.71           C  
ATOM    976  C   ASP A 212      44.629  57.113   6.297  1.00 48.23           C  
ATOM    977  O   ASP A 212      43.971  57.559   5.350  1.00 45.08           O  
ATOM    978  CB  ASP A 212      46.938  57.380   5.290  1.00 52.69           C  
ATOM    979  CG  ASP A 212      46.520  56.166   4.486  1.00 54.61           C  
ATOM    980  OD1 ASP A 212      45.370  56.152   4.010  1.00 78.72           O  
ATOM    981  OD2 ASP A 212      47.374  55.326   4.166  1.00 59.02           O  
ATOM    982  N   THR A 213      44.212  56.094   7.052  1.00 46.79           N  
ATOM    983  CA  THR A 213      42.811  55.684   7.106  1.00 44.73           C  
ATOM    984  C   THR A 213      42.499  54.355   6.437  1.00 45.37           C  
ATOM    985  O   THR A 213      41.387  53.848   6.542  1.00 46.65           O  
ATOM    986  CB  THR A 213      41.889  56.762   6.539  1.00 46.80           C  
ATOM    987  OG1 THR A 213      40.690  56.784   7.305  1.00 48.25           O  
ATOM    988  CG2 THR A 213      41.562  56.521   5.043  1.00 45.65           C  
ATOM    989  N   SER A 214      43.487  53.780   5.764  1.00 45.47           N  
ATOM    990  CA  SER A 214      43.284  52.557   5.000  1.00 44.41           C  
ATOM    991  C   SER A 214      43.387  51.272   5.834  1.00 43.75           C  
ATOM    992  O   SER A 214      44.074  51.227   6.842  1.00 41.94           O  
ATOM    993  CB  SER A 214      44.275  52.511   3.848  1.00 42.08           C  
ATOM    994  OG  SER A 214      45.537  52.950   4.313  1.00 53.84           O  
ATOM    995  N   LEU A 215      42.533  50.310   5.499  1.00 45.28           N  
ATOM    996  CA  LEU A 215      42.557  48.990   6.091  1.00 41.62           C  
ATOM    997  C   LEU A 215      43.790  48.353   5.506  1.00 42.31           C  
ATOM    998  O   LEU A 215      43.915  48.246   4.307  1.00 40.47           O  
ATOM    999  CB  LEU A 215      41.329  48.200   5.643  1.00 37.93           C  
ATOM   1000  CG  LEU A 215      41.222  46.743   6.097  1.00 41.12           C  
ATOM   1001  CD1 LEU A 215      41.684  46.565   7.518  1.00 34.02           C  
ATOM   1002  CD2 LEU A 215      39.781  46.242   5.936  1.00 46.11           C  
ATOM   1003  N   PHE A 216      44.721  47.956   6.355  1.00 42.62           N  
ATOM   1004  CA  PHE A 216      46.002  47.468   5.875  1.00 40.66           C  
ATOM   1005  C   PHE A 216      46.238  45.990   6.173  1.00 39.15           C  
ATOM   1006  O   PHE A 216      46.995  45.341   5.470  1.00 43.74           O  
ATOM   1007  CB  PHE A 216      47.096  48.321   6.507  1.00 39.46           C  
ATOM   1008  CG  PHE A 216      48.320  47.559   6.857  1.00 43.79           C  
ATOM   1009  CD1 PHE A 216      49.250  47.214   5.875  1.00 50.97           C  
ATOM   1010  CD2 PHE A 216      48.567  47.210   8.160  1.00 35.50           C  
ATOM   1011  CE1 PHE A 216      50.372  46.454   6.183  1.00 46.82           C  
ATOM   1012  CE2 PHE A 216      49.722  46.498   8.493  1.00 52.62           C  
ATOM   1013  CZ  PHE A 216      50.620  46.109   7.492  1.00 47.73           C  
ATOM   1014  N   GLN A 217      45.643  45.478   7.251  1.00 41.09           N  
ATOM   1015  CA  GLN A 217      45.829  44.073   7.656  1.00 38.51           C  
ATOM   1016  C   GLN A 217      44.561  43.390   8.166  1.00 38.35           C  
ATOM   1017  O   GLN A 217      43.716  44.012   8.807  1.00 37.84           O  
ATOM   1018  CB  GLN A 217      46.880  44.000   8.744  1.00 40.82           C  
ATOM   1019  CG  GLN A 217      46.993  42.626   9.389  1.00 39.40           C  
ATOM   1020  CD  GLN A 217      48.096  42.607  10.396  1.00 49.08           C  
ATOM   1021  OE1 GLN A 217      48.699  43.650  10.665  1.00 48.32           O  
ATOM   1022  NE2 GLN A 217      48.504  41.406  10.812  1.00 46.38           N  
ATOM   1023  N   TYR A 218      44.450  42.087   7.936  1.00 42.09           N  
ATOM   1024  CA  TYR A 218      43.332  41.346   8.477  1.00 41.73           C  
ATOM   1025  C   TYR A 218      43.800  40.028   9.079  1.00 44.64           C  
ATOM   1026  O   TYR A 218      44.516  39.274   8.437  1.00 47.15           O  
ATOM   1027  CB  TYR A 218      42.262  41.129   7.424  1.00 37.06           C  
ATOM   1028  CG  TYR A 218      41.309  39.985   7.743  1.00 43.68           C  
ATOM   1029  CD1 TYR A 218      40.201  40.165   8.564  1.00 42.84           C  
ATOM   1030  CD2 TYR A 218      41.471  38.751   7.157  1.00 36.16           C  
ATOM   1031  CE1 TYR A 218      39.380  39.092   8.913  1.00 30.26           C  
ATOM   1032  CE2 TYR A 218      40.617  37.677   7.454  1.00 40.16           C  
ATOM   1033  CZ  TYR A 218      39.591  37.842   8.343  1.00 48.63           C  
ATOM   1034  OH  TYR A 218      38.720  36.773   8.587  1.00 41.76           O  
ATOM   1035  N   THR A 219      43.407  39.771  10.328  1.00 44.94           N  
ATOM   1036  CA  THR A 219      43.797  38.564  11.036  1.00 42.70           C  
ATOM   1037  C   THR A 219      42.569  37.808  11.510  1.00 41.54           C  
ATOM   1038  O   THR A 219      41.542  38.403  11.818  1.00 45.45           O  
ATOM   1039  CB  THR A 219      44.684  38.921  12.220  1.00 41.20           C  
ATOM   1040  OG1 THR A 219      45.762  39.732  11.747  1.00 54.62           O  
ATOM   1041  CG2 THR A 219      45.277  37.674  12.874  1.00 52.08           C  
ATOM   1042  N   GLU A 220      42.623  36.499  11.377  1.00 36.88           N  
ATOM   1043  CA  GLU A 220      41.535  35.615  11.779  1.00 39.72           C  
ATOM   1044  C   GLU A 220      42.140  34.496  12.615  1.00 40.07           C  
ATOM   1045  O   GLU A 220      43.022  33.777  12.139  1.00 40.67           O  
ATOM   1046  CB  GLU A 220      40.836  35.001  10.567  1.00 35.45           C  
ATOM   1047  CG  GLU A 220      39.759  34.026  10.992  1.00 43.47           C  
ATOM   1048  CD  GLU A 220      39.116  33.275   9.843  1.00 48.12           C  
ATOM   1049  OE1 GLU A 220      38.861  33.889   8.782  1.00 46.05           O  
ATOM   1050  OE2 GLU A 220      38.712  32.111  10.068  1.00 54.75           O  
ATOM   1051  N   SER A 221      41.858  34.526  13.913  1.00 40.83           N  
ATOM   1052  CA  SER A 221      42.513  33.634  14.860  1.00 42.01           C  
ATOM   1053  C   SER A 221      41.483  32.690  15.432  1.00 40.19           C  
ATOM   1054  O   SER A 221      40.496  33.130  16.011  1.00 42.97           O  
ATOM   1055  CB  SER A 221      43.121  34.461  15.983  1.00 40.25           C  
ATOM   1056  OG  SER A 221      44.075  33.715  16.701  1.00 50.44           O  
ATOM   1057  N   ARG A 222      41.605  31.416  15.098  1.00 40.44           N  
ATOM   1058  CA  ARG A 222      40.572  30.437  15.442  1.00 37.65           C  
ATOM   1059  C   ARG A 222      41.023  29.533  16.589  1.00 39.42           C  
ATOM   1060  O   ARG A 222      42.014  28.791  16.449  1.00 38.32           O  
ATOM   1061  CB  ARG A 222      40.233  29.604  14.204  1.00 34.57           C  
ATOM   1062  CG  ARG A 222      40.004  30.470  12.977  1.00 41.99           C  
ATOM   1063  CD  ARG A 222      39.623  29.660  11.739  1.00 38.97           C  
ATOM   1064  NE  ARG A 222      38.363  28.943  11.900  1.00 40.45           N  
ATOM   1065  CZ  ARG A 222      37.167  29.430  11.568  1.00 41.95           C  
ATOM   1066  NH1 ARG A 222      37.066  30.668  11.097  1.00 36.39           N  
ATOM   1067  NH2 ARG A 222      36.071  28.681  11.717  1.00 34.98           N  
ATOM   1068  N   HIS A 223      40.317  29.610  17.723  1.00 37.73           N  
ATOM   1069  CA  HIS A 223      40.652  28.809  18.893  1.00 37.83           C  
ATOM   1070  C   HIS A 223      39.672  27.697  19.149  1.00 41.94           C  
ATOM   1071  O   HIS A 223      38.470  27.925  19.175  1.00 48.57           O  
ATOM   1072  CB  HIS A 223      40.640  29.679  20.135  1.00 40.09           C  
ATOM   1073  CG  HIS A 223      41.572  30.843  20.068  1.00 40.90           C  
ATOM   1074  ND1 HIS A 223      41.315  31.954  19.294  1.00 40.28           N  
ATOM   1075  CD2 HIS A 223      42.736  31.093  20.715  1.00 43.83           C  
ATOM   1076  CE1 HIS A 223      42.294  32.831  19.447  1.00 43.12           C  
ATOM   1077  NE2 HIS A 223      43.154  32.344  20.325  1.00 44.56           N  
ATOM   1078  N   ARG A 224      40.196  26.543  19.539  1.00 41.39           N  
ATOM   1079  CA  ARG A 224      39.409  25.534  20.205  1.00 35.89           C  
ATOM   1080  C   ARG A 224      38.848  26.097  21.524  1.00 40.19           C  
ATOM   1081  O   ARG A 224      39.534  26.825  22.248  1.00 42.24           O  
ATOM   1082  CB  ARG A 224      40.306  24.350  20.499  1.00 38.31           C  
ATOM   1083  CG  ARG A 224      39.569  23.018  20.558  1.00 28.44           C  
ATOM   1084  CD  ARG A 224      40.589  21.909  20.619  1.00 31.74           C  
ATOM   1085  NE  ARG A 224      41.184  21.770  21.949  1.00 27.94           N  
ATOM   1086  CZ  ARG A 224      41.975  20.761  22.311  1.00 33.88           C  
ATOM   1087  NH1 ARG A 224      42.287  19.801  21.437  1.00 36.49           N  
ATOM   1088  NH2 ARG A 224      42.500  20.739  23.528  1.00 30.26           N  
ATOM   1089  N   LEU A 225      37.621  25.725  21.862  1.00 41.57           N  
ATOM   1090  CA  LEU A 225      36.900  26.410  22.930  1.00 42.73           C  
ATOM   1091  C   LEU A 225      37.647  26.481  24.251  1.00 43.72           C  
ATOM   1092  O   LEU A 225      37.609  27.498  24.931  1.00 42.89           O  
ATOM   1093  CB  LEU A 225      35.520  25.794  23.142  1.00 43.80           C  
ATOM   1094  CG  LEU A 225      34.516  26.235  22.087  1.00 43.32           C  
ATOM   1095  CD1 LEU A 225      34.938  25.668  20.768  1.00 57.10           C  
ATOM   1096  CD2 LEU A 225      33.119  25.760  22.448  1.00 36.14           C  
ATOM   1097  N   ASP A 226      38.217  25.364  24.681  1.00 46.28           N  
ATOM   1098  CA  ASP A 226      38.935  25.333  25.954  1.00 46.14           C  
ATOM   1099  C   ASP A 226      40.225  26.163  25.969  1.00 44.81           C  
ATOM   1100  O   ASP A 226      40.890  26.236  26.983  1.00 46.72           O  
ATOM   1101  CB  ASP A 226      39.241  23.888  26.369  1.00 45.19           C  
ATOM   1102  CG  ASP A 226      40.223  23.201  25.424  1.00 52.22           C  
ATOM   1103  OD1 ASP A 226      40.089  23.360  24.188  1.00 54.32           O  
ATOM   1104  OD2 ASP A 226      41.151  22.526  25.923  1.00 55.31           O  
ATOM   1105  N   LYS A 227      40.652  26.668  24.816  1.00 46.84           N  
ATOM   1106  CA  LYS A 227      41.956  27.335  24.710  1.00 47.06           C  
ATOM   1107  C   LYS A 227      41.792  28.807  24.360  1.00 47.33           C  
ATOM   1108  O   LYS A 227      42.536  29.358  23.549  1.00 48.20           O  
ATOM   1109  CB  LYS A 227      42.832  26.647  23.655  1.00 45.31           C  
ATOM   1110  CG  LYS A 227      43.284  25.243  24.039  1.00 48.77           C  
ATOM   1111  CD  LYS A 227      44.099  25.268  25.317  1.00 57.03           C  
ATOM   1112  CE  LYS A 227      44.347  23.865  25.827  1.00 61.39           C  
ATOM   1113  NZ  LYS A 227      45.467  23.859  26.790  1.00 65.97           N  
ATOM   1114  N   PHE A 228      40.685  29.374  24.800  1.00 46.09           N  
ATOM   1115  CA  PHE A 228      40.414  30.749  24.500  1.00 47.61           C  
ATOM   1116  C   PHE A 228      40.247  31.504  25.796  1.00 47.26           C  
ATOM   1117  O   PHE A 228      39.595  31.004  26.708  1.00 46.23           O  
ATOM   1118  CB  PHE A 228      39.142  30.872  23.669  1.00 48.26           C  
ATOM   1119  CG  PHE A 228      38.786  32.279  23.366  1.00 43.35           C  
ATOM   1120  CD1 PHE A 228      39.580  33.012  22.517  1.00 40.74           C  
ATOM   1121  CD2 PHE A 228      37.861  32.948  24.153  1.00 46.36           C  
ATOM   1122  CE1 PHE A 228      39.352  34.382  22.334  1.00 44.87           C  
ATOM   1123  CE2 PHE A 228      37.664  34.316  24.020  1.00 44.65           C  
ATOM   1124  CZ  PHE A 228      38.397  35.030  23.102  1.00 39.06           C  
ATOM   1125  N   ARG A 229      41.012  32.580  25.953  1.00 44.54           N  
ATOM   1126  CA  ARG A 229      40.825  33.480  27.079  1.00 45.23           C  
ATOM   1127  C   ARG A 229      41.191  34.874  26.641  1.00 45.66           C  
ATOM   1128  O   ARG A 229      42.208  35.061  26.018  1.00 50.61           O  
ATOM   1129  CB  ARG A 229      41.684  33.067  28.266  1.00 44.62           C  
ATOM   1130  CG  ARG A 229      41.618  34.021  29.466  1.00 43.83           C  
ATOM   1131  CD  ARG A 229      42.358  33.429  30.672  1.00 45.24           C  
ATOM   1132  NE  ARG A 229      42.411  34.343  31.810  1.00 62.78           N  
ATOM   1133  CZ  ARG A 229      43.396  35.217  32.042  1.00 67.86           C  
ATOM   1134  NH1 ARG A 229      44.443  35.297  31.227  1.00 62.04           N  
ATOM   1135  NH2 ARG A 229      43.326  36.022  33.096  1.00 68.68           N  
ATOM   1136  N   PHE A 230      40.256  35.804  26.759  1.00 46.10           N  
ATOM   1137  CA  PHE A 230      40.498  37.169  26.341  1.00 40.67           C  
ATOM   1138  C   PHE A 230      40.277  38.115  27.504  1.00 38.35           C  
ATOM   1139  O   PHE A 230      39.255  38.010  28.199  1.00 42.62           O  
ATOM   1140  CB  PHE A 230      39.556  37.519  25.219  1.00 41.83           C  
ATOM   1141  CG  PHE A 230      39.585  38.959  24.839  1.00 54.41           C  
ATOM   1142  CD1 PHE A 230      40.292  39.375  23.718  1.00 59.49           C  
ATOM   1143  CD2 PHE A 230      38.838  39.891  25.549  1.00 52.87           C  
ATOM   1144  CE1 PHE A 230      40.284  40.703  23.335  1.00 55.94           C  
ATOM   1145  CE2 PHE A 230      38.759  41.198  25.123  1.00 55.99           C  
ATOM   1146  CZ  PHE A 230      39.520  41.619  24.038  1.00 56.20           C  
ATOM   1147  N   VAL A 231      41.312  38.882  27.833  1.00 31.08           N  
ATOM   1148  CA  VAL A 231      41.259  39.859  28.894  1.00 25.38           C  
ATOM   1149  C   VAL A 231      41.359  41.269  28.346  1.00 24.42           C  
ATOM   1150  O   VAL A 231      41.932  41.486  27.287  1.00 26.89           O  
ATOM   1151  CB  VAL A 231      42.404  39.655  29.854  1.00 25.14           C  
ATOM   1152  CG1 VAL A 231      42.223  40.549  31.091  1.00 33.83           C  
ATOM   1153  CG2 VAL A 231      42.440  38.215  30.279  1.00 25.18           C  
ATOM   1154  N   ASP A 232      40.724  42.221  29.023  1.00 24.03           N  
ATOM   1155  CA  ASP A 232      40.866  43.621  28.652  1.00 20.91           C  
ATOM   1156  C   ASP A 232      40.296  44.586  29.674  1.00 21.08           C  
ATOM   1157  O   ASP A 232      40.054  44.219  30.820  1.00 16.64           O  
ATOM   1158  CB  ASP A 232      40.247  43.893  27.283  1.00 21.58           C  
ATOM   1159  CG  ASP A 232      40.927  45.047  26.554  1.00 25.36           C  
ATOM   1160  OD1 ASP A 232      40.769  45.133  25.276  1.00 29.16           O  
ATOM   1161  OD2 ASP A 232      41.671  45.829  27.234  1.00 27.22           O  
ATOM   1162  N   PHE A 233      40.487  45.854  29.352  1.00 23.93           N  
ATOM   1163  CA  PHE A 233      39.733  46.959  29.923  1.00 26.62           C  
ATOM   1164  C   PHE A 233      39.238  47.629  28.642  1.00 29.11           C  
ATOM   1165  O   PHE A 233      39.650  47.209  27.554  1.00 32.80           O  
ATOM   1166  CB  PHE A 233      40.679  47.897  30.678  1.00 24.85           C  
ATOM   1167  CG  PHE A 233      41.754  47.187  31.440  1.00 21.01           C  
ATOM   1168  CD1 PHE A 233      42.915  46.790  30.810  1.00 27.43           C  
ATOM   1169  CD2 PHE A 233      41.661  47.038  32.806  1.00 28.07           C  
ATOM   1170  CE1 PHE A 233      43.926  46.163  31.515  1.00 37.11           C  
ATOM   1171  CE2 PHE A 233      42.664  46.411  33.530  1.00 32.29           C  
ATOM   1172  CZ  PHE A 233      43.794  45.959  32.878  1.00 40.71           C  
ATOM   1173  N   ALA A 234      38.267  48.538  28.707  1.00 31.85           N  
ATOM   1174  CA  ALA A 234      37.539  48.907  29.905  1.00 31.25           C  
ATOM   1175  C   ALA A 234      38.254  49.925  30.803  1.00 31.62           C  
ATOM   1176  O   ALA A 234      39.383  49.693  31.256  1.00 33.47           O  
ATOM   1177  CB  ALA A 234      37.079  47.671  30.673  1.00 33.17           C  
ATOM   1178  N   ARG A 235      37.748  51.151  30.729  1.00 28.72           N  
ATOM   1179  CA  ARG A 235      38.050  52.219  31.684  1.00 24.24           C  
ATOM   1180  C   ARG A 235      36.802  53.092  31.655  1.00 19.33           C  
ATOM   1181  O   ARG A 235      36.253  53.355  30.582  1.00 19.45           O  
ATOM   1182  CB  ARG A 235      39.272  53.032  31.252  1.00 25.16           C  
ATOM   1183  CG  ARG A 235      39.948  53.801  32.390  1.00 26.75           C  
ATOM   1184  CD  ARG A 235      40.858  52.884  33.210  1.00 31.11           C  
ATOM   1185  NE  ARG A 235      41.917  53.598  33.929  1.00 30.37           N  
ATOM   1186  CZ  ARG A 235      41.921  54.906  34.184  1.00 27.29           C  
ATOM   1187  NH1 ARG A 235      40.861  55.651  33.891  1.00 24.63           N  
ATOM   1188  NH2 ARG A 235      42.943  55.449  34.833  1.00 22.09           N  
ATOM   1189  N   ARG A 236      36.329  53.494  32.826  1.00 11.37           N  
ATOM   1190  CA  ARG A 236      34.990  54.049  32.959  1.00  8.50           C  
ATOM   1191  C   ARG A 236      35.010  55.497  33.468  1.00  5.10           C  
ATOM   1192  O   ARG A 236      36.080  56.068  33.663  1.00  5.87           O  
ATOM   1193  CB  ARG A 236      34.183  53.157  33.906  1.00 10.11           C  
ATOM   1194  CG  ARG A 236      34.224  51.666  33.550  1.00  8.31           C  
ATOM   1195  CD  ARG A 236      33.003  51.251  32.730  1.00 26.69           C  
ATOM   1196  NE  ARG A 236      31.769  51.287  33.525  1.00 31.54           N  
ATOM   1197  CZ  ARG A 236      31.083  50.209  33.899  1.00 31.04           C  
ATOM   1198  NH1 ARG A 236      31.420  49.014  33.432  1.00 34.59           N  
ATOM   1199  NH2 ARG A 236      29.988  50.345  34.636  1.00 29.27           N  
ATOM   1200  N   GLY A 237      33.837  56.074  33.724  1.00  2.00           N  
ATOM   1201  CA  GLY A 237      33.756  57.445  34.228  1.00  2.00           C  
ATOM   1202  C   GLY A 237      33.794  58.458  33.105  1.00  2.00           C  
ATOM   1203  O   GLY A 237      33.876  58.091  31.928  1.00  2.00           O  
ATOM   1204  N   LYS A 238      33.820  59.737  33.473  1.00  2.00           N  
ATOM   1205  CA  LYS A 238      33.688  60.833  32.502  1.00  2.00           C  
ATOM   1206  C   LYS A 238      34.772  60.793  31.413  1.00  2.00           C  
ATOM   1207  O   LYS A 238      34.423  61.223  30.101  1.00  2.00           O  
ATOM   1208  CB  LYS A 238      33.658  62.193  33.221  1.00  2.00           C  
ATOM   1209  CG  LYS A 238      32.970  63.306  32.451  1.00  2.00           C  
ATOM   1210  CD  LYS A 238      32.454  64.388  33.393  1.00  2.00           C  
ATOM   1211  CE  LYS A 238      33.492  65.468  33.682  1.00  2.00           C  
ATOM   1212  NZ  LYS A 238      33.474  66.567  32.662  1.00  2.00           N  
ATOM   1213  OXT LYS A 238      35.993  60.253  31.760  1.00  2.00           O  
TER    1214      LYS A 238                                                      
END
MOLECULE T0455.pdb
ATOM    981  N   SER     7      55.366  26.966  20.854  1.00 66.80           N  
ATOM    982  CA  SER     7      55.702  26.695  19.421  1.00 66.93           C  
ATOM    983  CB  SER     7      56.100  25.225  19.176  1.00 67.14           C  
ATOM    984  OG  SER     7      57.045  25.126  18.105  1.00 67.50           O  
ATOM    985  C   SER     7      54.546  27.029  18.496  1.00 67.22           C  
ATOM    986  O   SER     7      53.366  27.033  18.892  1.00 67.58           O  
ATOM    987  N   SER     8      54.906  27.266  17.235  1.00 67.10           N  
ATOM    988  CA  SER     8      53.963  27.599  16.177  1.00 66.00           C  
ATOM    989  CB  SER     8      53.890  29.128  16.007  1.00 66.59           C  
ATOM    990  OG  SER     8      53.375  29.536  14.732  1.00 67.49           O  
ATOM    991  C   SER     8      54.435  26.946  14.895  1.00 65.24           C  
ATOM    992  O   SER     8      55.612  26.779  14.693  1.00 65.20           O  
ATOM    993  N   ARG     9      53.508  26.618  14.012  1.00 64.59           N  
ATOM    994  CA  ARG     9      53.810  25.902  12.777  1.00 63.46           C  
ATOM    995  CB  ARG     9      53.323  24.452  12.955  1.00 63.59           C  
ATOM    996  CG  ARG     9      53.608  23.502  11.797  1.00 64.77           C  
ATOM    997  CD  ARG     9      52.566  22.383  11.682  1.00 66.10           C  
ATOM    998  NE  ARG     9      52.289  22.125  10.265  1.00 69.18           N  
ATOM    999  CZ  ARG     9      51.219  21.496   9.777  1.00 70.75           C  
ATOM   1000  NH1 ARG     9      50.269  21.019  10.575  1.00 72.26           N  
ATOM   1001  NH2 ARG     9      51.092  21.339   8.461  1.00 71.12           N  
ATOM   1002  C   ARG     9      53.114  26.578  11.573  1.00 61.94           C  
ATOM   1003  O   ARG     9      51.876  26.647  11.512  1.00 62.08           O  
ATOM   1004  N   THR    10      53.888  27.073  10.614  1.00 60.07           N  
ATOM   1005  CA  THR    10      53.296  27.593   9.384  1.00 58.73           C  
ATOM   1006  CB  THR    10      54.264  28.455   8.588  1.00 58.55           C  
ATOM   1007  OG1 THR    10      54.907  29.383   9.450  1.00 58.12           O  
ATOM   1008  CG2 THR    10      53.523  29.236   7.573  1.00 59.32           C  
ATOM   1009  C   THR    10      52.835  26.470   8.477  1.00 57.08           C  
ATOM   1010  O   THR    10      53.626  25.822   7.873  1.00 57.73           O  
ATOM   1011  N   VAL    11      51.540  26.266   8.388  1.00 55.72           N  
ATOM   1012  CA  VAL    11      50.919  25.326   7.461  1.00 54.80           C  
ATOM   1013  CB  VAL    11      49.451  25.178   7.858  1.00 54.58           C  
ATOM   1014  CG1 VAL    11      48.606  24.505   6.741  1.00 53.03           C  
ATOM   1015  CG2 VAL    11      49.372  24.461   9.181  1.00 55.59           C  
ATOM   1016  C   VAL    11      50.944  25.731   5.966  1.00 54.04           C  
ATOM   1017  O   VAL    11      50.990  24.876   5.094  1.00 54.13           O  
ATOM   1018  N   SER    12      50.805  27.015   5.655  1.00 52.92           N  
ATOM   1019  CA  SER    12      51.032  27.471   4.287  1.00 51.89           C  
ATOM   1020  CB  SER    12      49.826  27.206   3.405  1.00 51.67           C  
ATOM   1021  OG  SER    12      48.768  27.971   3.862  1.00 52.50           O  
ATOM   1022  C   SER    12      51.419  28.946   4.220  1.00 49.85           C  
ATOM   1023  O   SER    12      51.261  29.690   5.178  1.00 48.66           O  
ATOM   1024  N   TYR    13      51.929  29.353   3.068  1.00 47.92           N  
ATOM   1025  CA  TYR    13      52.545  30.644   2.962  1.00 47.09           C  
ATOM   1026  CB  TYR    13      53.859  30.625   3.746  1.00 47.17           C  
ATOM   1027  CG  TYR    13      54.529  31.952   3.919  1.00 46.90           C  
ATOM   1028  CD1 TYR    13      54.225  32.765   4.984  1.00 46.52           C  
ATOM   1029  CE1 TYR    13      54.846  33.984   5.160  1.00 46.47           C  
ATOM   1030  CZ  TYR    13      55.790  34.394   4.276  1.00 47.95           C  
ATOM   1031  OH  TYR    13      56.430  35.596   4.451  1.00 48.26           O  
ATOM   1032  CE2 TYR    13      56.117  33.596   3.211  1.00 48.07           C  
ATOM   1033  CD2 TYR    13      55.473  32.383   3.040  1.00 46.54           C  
ATOM   1034  C   TYR    13      52.797  30.938   1.493  1.00 46.32           C  
ATOM   1035  O   TYR    13      53.632  30.328   0.871  1.00 46.29           O  
ATOM   1036  N   PHE    14      52.044  31.870   0.939  1.00 45.80           N  
ATOM   1037  CA  PHE    14      52.161  32.209  -0.459  1.00 45.02           C  
ATOM   1038  CB  PHE    14      51.686  31.051  -1.319  1.00 44.87           C  
ATOM   1039  CG  PHE    14      50.249  30.696  -1.134  1.00 44.59           C  
ATOM   1040  CD1 PHE    14      49.896  29.556  -0.461  1.00 44.02           C  
ATOM   1041  CE1 PHE    14      48.570  29.210  -0.313  1.00 45.96           C  
ATOM   1042  CZ  PHE    14      47.567  29.997  -0.874  1.00 44.63           C  
ATOM   1043  CE2 PHE    14      47.905  31.136  -1.549  1.00 44.54           C  
ATOM   1044  CD2 PHE    14      49.241  31.479  -1.693  1.00 45.21           C  
ATOM   1045  C   PHE    14      51.395  33.464  -0.837  1.00 44.29           C  
ATOM   1046  O   PHE    14      50.458  33.895  -0.143  1.00 44.89           O  
ATOM   1047  N   VAL    15      51.772  33.998  -1.982  1.00 43.49           N  
ATOM   1048  CA  VAL    15      51.210  35.211  -2.498  1.00 43.41           C  
ATOM   1049  CB  VAL    15      52.299  35.963  -3.246  1.00 43.05           C  
ATOM   1050  CG1 VAL    15      51.764  37.141  -3.945  1.00 42.02           C  
ATOM   1051  CG2 VAL    15      53.372  36.367  -2.278  1.00 42.40           C  
ATOM   1052  C   VAL    15      50.034  34.908  -3.419  1.00 43.85           C  
ATOM   1053  O   VAL    15      50.064  33.992  -4.228  1.00 44.16           O  
ATOM   1054  N   ALA    16      48.981  35.689  -3.297  1.00 44.56           N  
ATOM   1055  CA  ALA    16      47.768  35.460  -4.066  1.00 44.69           C  
ATOM   1056  CB  ALA    16      46.796  34.653  -3.280  1.00 43.79           C  
ATOM   1057  C   ALA    16      47.157  36.787  -4.396  1.00 45.56           C  
ATOM   1058  O   ALA    16      47.487  37.798  -3.788  1.00 46.06           O  
ATOM   1059  N   LYS    17      46.293  36.797  -5.392  1.00 46.31           N  
ATOM   1060  CA  LYS    17      45.523  37.984  -5.648  1.00 47.32           C  
ATOM   1061  CB  LYS    17      45.167  38.115  -7.151  1.00 47.08           C  
ATOM   1062  CG  LYS    17      46.452  38.029  -8.006  1.00 49.26           C  
ATOM   1063  CD  LYS    17      46.559  38.957  -9.180  1.00 49.63           C  
ATOM   1064  CE  LYS    17      45.585  38.494 -10.345  1.00 54.44           C  
ATOM   1065  NZ  LYS    17      46.079  38.686 -11.787  1.00 50.61           N  
ATOM   1066  C   LYS    17      44.361  37.841  -4.679  1.00 47.08           C  
ATOM   1067  O   LYS    17      43.964  36.750  -4.340  1.00 47.55           O  
ATOM   1068  N   PRO    18      43.857  38.939  -4.170  1.00 47.03           N  
ATOM   1069  CA  PRO    18      42.953  38.814  -3.060  1.00 47.50           C  
ATOM   1070  CB  PRO    18      42.848  40.259  -2.554  1.00 47.75           C  
ATOM   1071  CG  PRO    18      43.077  41.081  -3.791  1.00 47.83           C  
ATOM   1072  CD  PRO    18      44.073  40.330  -4.580  1.00 47.03           C  
ATOM   1073  C   PRO    18      41.580  38.326  -3.460  1.00 47.37           C  
ATOM   1074  O   PRO    18      41.135  38.614  -4.549  1.00 47.23           O  
ATOM   1075  N   SER    19      40.911  37.632  -2.551  1.00 47.79           N  
ATOM   1076  CA  SER    19      39.484  37.325  -2.670  1.00 48.25           C  
ATOM   1077  CB  SER    19      39.150  36.281  -1.617  1.00 47.61           C  
ATOM   1078  OG  SER    19      39.108  36.882  -0.326  1.00 49.49           O  
ATOM   1079  C   SER    19      38.607  38.592  -2.423  1.00 48.80           C  
ATOM   1080  O   SER    19      39.106  39.650  -2.010  1.00 48.76           O  
ATOM   1081  N   SER    20      37.301  38.484  -2.623  1.00 48.97           N  
ATOM   1082  CA  SER    20      36.422  39.623  -2.332  1.00 49.63           C  
ATOM   1083  CB  SER    20      34.972  39.229  -2.590  1.00 49.72           C  
ATOM   1084  OG  SER    20      34.907  38.531  -3.822  1.00 53.35           O  
ATOM   1085  C   SER    20      36.522  40.148  -0.900  1.00 49.91           C  
ATOM   1086  O   SER    20      36.648  41.363  -0.654  1.00 49.90           O  
ATOM   1087  N   SER    21      36.417  39.246   0.064  1.00 49.95           N  
ATOM   1088  CA  SER    21      36.420  39.712   1.429  1.00 49.61           C  
ATOM   1089  CB  SER    21      36.018  38.615   2.413  1.00 49.01           C  
ATOM   1090  OG  SER    21      37.102  37.851   2.775  1.00 49.97           O  
ATOM   1091  C   SER    21      37.807  40.311   1.701  1.00 49.66           C  
ATOM   1092  O   SER    21      37.934  41.296   2.430  1.00 49.35           O  
ATOM   1093  N   GLU    22      38.837  39.762   1.064  1.00 49.14           N  
ATOM   1094  CA  GLU    22      40.149  40.301   1.291  1.00 49.16           C  
ATOM   1095  CB  GLU    22      41.231  39.338   0.789  1.00 49.18           C  
ATOM   1096  CG  GLU    22      41.352  38.099   1.671  1.00 48.36           C  
ATOM   1097  CD  GLU    22      42.337  37.057   1.151  1.00 47.87           C  
ATOM   1098  OE1 GLU    22      42.607  37.030  -0.058  1.00 48.49           O  
ATOM   1099  OE2 GLU    22      42.841  36.256   1.961  1.00 43.16           O  
ATOM   1100  C   GLU    22      40.246  41.692   0.668  1.00 49.40           C  
ATOM   1101  O   GLU    22      40.855  42.576   1.232  1.00 49.08           O  
ATOM   1102  N   MET    23      39.637  41.897  -0.493  1.00 50.38           N  
ATOM   1103  CA  MET    23      39.667  43.215  -1.147  1.00 50.41           C  
ATOM   1104  CB  MET    23      38.957  43.155  -2.491  1.00 50.70           C  
ATOM   1105  CG  MET    23      39.736  42.378  -3.537  1.00 51.45           C  
ATOM   1106  SD  MET    23      38.879  42.251  -5.118  1.00 48.27           S  
ATOM   1107  CE  MET    23      38.583  44.004  -5.360  1.00 45.34           C  
ATOM   1108  C   MET    23      38.973  44.241  -0.259  1.00 51.76           C  
ATOM   1109  O   MET    23      39.481  45.323   0.001  1.00 51.94           O  
ATOM   1110  N   GLU    24      37.806  43.860   0.215  1.00 53.13           N  
ATOM   1111  CA  GLU    24      36.978  44.722   1.005  1.00 53.62           C  
ATOM   1112  CB  GLU    24      35.644  43.973   1.229  1.00 54.72           C  
ATOM   1113  CG  GLU    24      34.450  44.799   1.705  1.00 56.70           C  
ATOM   1114  CD  GLU    24      33.999  44.474   3.115  1.00 64.20           C  
ATOM   1115  OE1 GLU    24      34.727  43.777   3.857  1.00 69.18           O  
ATOM   1116  OE2 GLU    24      32.894  44.923   3.487  1.00 70.36           O  
ATOM   1117  C   GLU    24      37.682  45.148   2.333  1.00 53.63           C  
ATOM   1118  O   GLU    24      37.833  46.347   2.595  1.00 53.82           O  
ATOM   1119  N   LYS    25      38.136  44.175   3.128  1.00 52.64           N  
ATOM   1120  CA  LYS    25      38.749  44.447   4.431  1.00 52.19           C  
ATOM   1121  CB  LYS    25      38.972  43.161   5.229  1.00 52.35           C  
ATOM   1122  CG  LYS    25      37.796  42.253   5.370  1.00 54.27           C  
ATOM   1123  CD  LYS    25      36.775  42.727   6.383  1.00 54.98           C  
ATOM   1124  CE  LYS    25      35.645  41.721   6.435  1.00 55.23           C  
ATOM   1125  NZ  LYS    25      34.500  42.241   7.228  1.00 58.74           N  
ATOM   1126  C   LYS    25      40.126  45.101   4.337  1.00 51.74           C  
ATOM   1127  O   LYS    25      40.522  45.839   5.221  1.00 51.11           O  
ATOM   1128  N   LEU    26      40.904  44.760   3.317  1.00 51.27           N  
ATOM   1129  CA  LEU    26      42.245  45.312   3.206  1.00 50.74           C  
ATOM   1130  CB  LEU    26      43.233  44.246   2.740  1.00 50.18           C  
ATOM   1131  CG  LEU    26      43.618  43.149   3.733  1.00 47.96           C  
ATOM   1132  CD1 LEU    26      44.658  42.174   3.109  1.00 46.25           C  
ATOM   1133  CD2 LEU    26      44.156  43.767   5.006  1.00 42.03           C  
ATOM   1134  C   LEU    26      42.221  46.502   2.257  1.00 50.78           C  
ATOM   1135  O   LEU    26      43.232  47.183   2.078  1.00 50.95           O  
ATOM   1136  N   GLN    27      41.046  46.741   1.674  1.00 50.93           N  
ATOM   1137  CA  GLN    27      40.790  47.883   0.818  1.00 51.30           C  
ATOM   1138  CB  GLN    27      40.880  49.193   1.589  1.00 51.58           C  
ATOM   1139  CG  GLN    27      39.651  49.523   2.408  1.00 51.59           C  
ATOM   1140  CD  GLN    27      40.005  50.504   3.513  1.00 52.59           C  
ATOM   1141  OE1 GLN    27      40.855  51.376   3.301  1.00 57.18           O  
ATOM   1142  NE2 GLN    27      39.395  50.352   4.705  1.00 47.63           N  
ATOM   1143  C   GLN    27      41.784  47.854  -0.288  1.00 51.13           C  
ATOM   1144  O   GLN    27      42.718  48.634  -0.303  1.00 51.14           O  
ATOM   1145  N   LEU    28      41.581  46.907  -1.186  1.00 51.34           N  
ATOM   1146  CA  LEU    28      42.533  46.602  -2.222  1.00 51.53           C  
ATOM   1147  CB  LEU    28      43.388  45.390  -1.844  1.00 51.82           C  
ATOM   1148  CG  LEU    28      44.417  45.402  -0.707  1.00 52.24           C  
ATOM   1149  CD1 LEU    28      44.895  43.970  -0.469  1.00 53.58           C  
ATOM   1150  CD2 LEU    28      45.608  46.284  -1.015  1.00 51.65           C  
ATOM   1151  C   LEU    28      41.735  46.233  -3.430  1.00 51.61           C  
ATOM   1152  O   LEU    28      40.639  45.693  -3.341  1.00 51.58           O  
ATOM   1153  N   GLY    29      42.294  46.528  -4.580  1.00 52.42           N  
ATOM   1154  CA  GLY    29      41.641  46.189  -5.819  1.00 52.85           C  
ATOM   1155  C   GLY    29      41.988  44.757  -6.143  1.00 53.36           C  
ATOM   1156  O   GLY    29      42.916  44.153  -5.531  1.00 53.17           O  
ATOM   1157  N   PRO    30      41.295  44.205  -7.145  1.00 53.25           N  
ATOM   1158  CA  PRO    30      41.705  42.884  -7.543  1.00 53.02           C  
ATOM   1159  CB  PRO    30      40.734  42.547  -8.672  1.00 53.13           C  
ATOM   1160  CG  PRO    30      40.410  43.900  -9.290  1.00 52.75           C  
ATOM   1161  CD  PRO    30      40.292  44.775  -8.062  1.00 53.59           C  
ATOM   1162  C   PRO    30      43.078  43.193  -8.077  1.00 53.01           C  
ATOM   1163  O   PRO    30      43.350  44.381  -8.383  1.00 54.66           O  
ATOM   1164  N   GLU    31      43.956  42.223  -8.183  1.00 51.87           N  
ATOM   1165  CA  GLU    31      45.290  42.538  -8.729  1.00 51.91           C  
ATOM   1166  CB  GLU    31      45.234  43.438 -10.001  1.00 52.64           C  
ATOM   1167  CG  GLU    31      44.212  43.010 -11.088  1.00 54.99           C  
ATOM   1168  CD  GLU    31      44.468  41.589 -11.570  1.00 58.60           C  
ATOM   1169  OE1 GLU    31      45.587  41.387 -12.100  1.00 61.18           O  
ATOM   1170  OE2 GLU    31      43.590  40.688 -11.375  1.00 58.99           O  
ATOM   1171  C   GLU    31      46.291  43.147  -7.767  1.00 50.56           C  
ATOM   1172  O   GLU    31      47.457  43.132  -8.085  1.00 49.87           O  
ATOM   1173  N   ASP    32      45.879  43.688  -6.623  1.00 50.08           N  
ATOM   1174  CA  ASP    32      46.867  43.943  -5.552  1.00 49.96           C  
ATOM   1175  CB  ASP    32      46.415  44.986  -4.524  1.00 50.42           C  
ATOM   1176  CG  ASP    32      46.106  46.339  -5.137  1.00 52.23           C  
ATOM   1177  OD1 ASP    32      46.755  46.714  -6.137  1.00 49.25           O  
ATOM   1178  OD2 ASP    32      45.206  47.039  -4.583  1.00 56.11           O  
ATOM   1179  C   ASP    32      47.161  42.637  -4.810  1.00 49.17           C  
ATOM   1180  O   ASP    32      46.325  42.121  -4.090  1.00 49.32           O  
ATOM   1181  N   SER    33      48.361  42.112  -4.964  1.00 48.16           N  
ATOM   1182  CA  SER    33      48.732  40.910  -4.255  1.00 47.49           C  
ATOM   1183  CB  SER    33      50.137  40.523  -4.637  1.00 47.56           C  
ATOM   1184  OG  SER    33      50.154  40.261  -6.019  1.00 49.46           O  
ATOM   1185  C   SER    33      48.689  41.097  -2.767  1.00 46.69           C  
ATOM   1186  O   SER    33      48.962  42.183  -2.251  1.00 46.07           O  
ATOM   1187  N   ILE    34      48.380  39.995  -2.095  1.00 46.52           N  
ATOM   1188  CA  ILE    34      48.427  39.862  -0.650  1.00 45.49           C  
ATOM   1189  CB  ILE    34      47.045  39.603  -0.080  1.00 45.17           C  
ATOM   1190  CG1 ILE    34      46.457  38.309  -0.690  1.00 45.25           C  
ATOM   1191  CD1 ILE    34      45.695  37.367   0.276  1.00 44.50           C  
ATOM   1192  CG2 ILE    34      46.135  40.804  -0.339  1.00 42.34           C  
ATOM   1193  C   ILE    34      49.311  38.652  -0.340  1.00 45.62           C  
ATOM   1194  O   ILE    34      49.522  37.788  -1.180  1.00 45.44           O  
ATOM   1195  N   LEU    35      49.863  38.626   0.861  1.00 46.28           N  
ATOM   1196  CA  LEU    35      50.570  37.472   1.381  1.00 46.29           C  
ATOM   1197  CB  LEU    35      51.739  37.900   2.258  1.00 46.24           C  
ATOM   1198  CG  LEU    35      52.555  36.739   2.818  1.00 46.30           C  
ATOM   1199  CD1 LEU    35      53.202  35.964   1.632  1.00 43.82           C  
ATOM   1200  CD2 LEU    35      53.613  37.223   3.811  1.00 45.71           C  
ATOM   1201  C   LEU    35      49.570  36.734   2.224  1.00 46.83           C  
ATOM   1202  O   LEU    35      48.918  37.323   3.061  1.00 46.30           O  
ATOM   1203  N   ARG    36      49.422  35.449   1.998  1.00 47.99           N  
ATOM   1204  CA  ARG    36      48.435  34.723   2.731  1.00 49.43           C  
ATOM   1205  CB  ARG    36      47.475  34.086   1.784  1.00 50.62           C  
ATOM   1206  CG  ARG    36      46.181  33.772   2.453  1.00 53.89           C  
ATOM   1207  CD  ARG    36      45.692  32.395   2.149  1.00 59.18           C  
ATOM   1208  NE  ARG    36      44.273  32.418   2.300  1.00 60.92           N  
ATOM   1209  CZ  ARG    36      43.443  32.961   1.416  1.00 66.27           C  
ATOM   1210  NH1 ARG    36      43.904  33.493   0.245  1.00 67.71           N  
ATOM   1211  NH2 ARG    36      42.123  32.947   1.696  1.00 67.71           N  
ATOM   1212  C   ARG    36      49.139  33.650   3.441  1.00 49.82           C  
ATOM   1213  O   ARG    36      49.901  32.904   2.825  1.00 50.82           O  
ATOM   1214  N   MET    37      48.945  33.594   4.741  1.00 50.15           N  
ATOM   1215  CA  MET    37      49.644  32.619   5.577  1.00 50.53           C  
ATOM   1216  CB  MET    37      50.901  33.205   6.204  1.00 50.08           C  
ATOM   1217  CG  MET    37      50.757  34.217   7.314  1.00 51.20           C  
ATOM   1218  SD  MET    37      52.335  34.422   8.203  1.00 51.62           S  
ATOM   1219  CE  MET    37      52.342  32.968   9.266  1.00 49.85           C  
ATOM   1220  C   MET    37      48.714  32.010   6.607  1.00 50.57           C  
ATOM   1221  O   MET    37      47.775  32.655   7.100  1.00 49.67           O  
ATOM   1222  N   GLU    38      48.921  30.720   6.826  1.00 51.66           N  
ATOM   1223  CA  GLU    38      48.084  29.905   7.695  1.00 52.46           C  
ATOM   1224  CB  GLU    38      47.480  28.763   6.923  1.00 52.43           C  
ATOM   1225  CG  GLU    38      46.339  29.190   6.094  1.00 54.18           C  
ATOM   1226  CD  GLU    38      45.824  28.125   5.183  1.00 54.07           C  
ATOM   1227  OE1 GLU    38      46.293  26.963   5.227  1.00 55.92           O  
ATOM   1228  OE2 GLU    38      44.944  28.487   4.405  1.00 57.93           O  
ATOM   1229  C   GLU    38      48.987  29.308   8.722  1.00 53.53           C  
ATOM   1230  O   GLU    38      50.086  28.872   8.378  1.00 53.65           O  
ATOM   1231  N   ARG    39      48.515  29.216   9.952  1.00 54.36           N  
ATOM   1232  CA  ARG    39      49.404  28.937  11.052  1.00 56.22           C  
ATOM   1233  CB  ARG    39      49.977  30.287  11.452  1.00 56.60           C  
ATOM   1234  CG  ARG    39      50.997  30.297  12.521  1.00 59.42           C  
ATOM   1235  CD  ARG    39      50.693  31.391  13.599  1.00 61.15           C  
ATOM   1236  NE  ARG    39      50.895  32.768  13.118  1.00 64.98           N  
ATOM   1237  CZ  ARG    39      52.083  33.380  13.027  1.00 66.66           C  
ATOM   1238  NH1 ARG    39      53.217  32.762  13.369  1.00 63.65           N  
ATOM   1239  NH2 ARG    39      52.126  34.633  12.574  1.00 68.83           N  
ATOM   1240  C   ARG    39      48.649  28.274  12.212  1.00 55.31           C  
ATOM   1241  O   ARG    39      47.551  28.682  12.530  1.00 54.64           O  
ATOM   1242  N   ILE    40      49.226  27.219  12.786  1.00 55.53           N  
ATOM   1243  CA  ILE    40      48.746  26.595  14.045  1.00 55.67           C  
ATOM   1244  CB  ILE    40      48.675  25.052  13.921  1.00 55.53           C  
ATOM   1245  CG1 ILE    40      47.965  24.654  12.623  1.00 54.13           C  
ATOM   1246  CD1 ILE    40      47.875  23.195  12.381  1.00 53.68           C  
ATOM   1247  CG2 ILE    40      47.958  24.475  15.094  1.00 55.36           C  
ATOM   1248  C   ILE    40      49.695  26.964  15.203  1.00 55.60           C  
ATOM   1249  O   ILE    40      50.895  26.924  15.042  1.00 54.08           O  
ATOM   1250  N   ARG    41      49.137  27.350  16.345  1.00 57.05           N  
ATOM   1251  CA  ARG    41      49.902  27.583  17.594  1.00 58.60           C  
ATOM   1252  CB  ARG    41      49.682  28.995  18.158  1.00 58.57           C  
ATOM   1253  CG  ARG    41      49.935  30.085  17.095  1.00 61.65           C  
ATOM   1254  CD  ARG    41      49.835  31.558  17.607  1.00 62.04           C  
ATOM   1255  NE  ARG    41      51.139  31.967  18.140  1.00 66.00           N  
ATOM   1256  CZ  ARG    41      52.079  32.689  17.509  1.00 65.44           C  
ATOM   1257  NH1 ARG    41      51.896  33.213  16.287  1.00 64.96           N  
ATOM   1258  NH2 ARG    41      53.225  32.903  18.140  1.00 64.12           N  
ATOM   1259  C   ARG    41      49.502  26.565  18.644  1.00 58.53           C  
ATOM   1260  O   ARG    41      48.354  26.119  18.710  1.00 57.81           O  
ATOM   1261  N   PHE    42      50.486  26.228  19.466  1.00 59.74           N  
ATOM   1262  CA  PHE    42      50.416  25.142  20.452  1.00 60.45           C  
ATOM   1263  CB  PHE    42      51.484  24.072  20.118  1.00 60.37           C  
ATOM   1264  CG  PHE    42      51.318  23.453  18.750  1.00 60.19           C  
ATOM   1265  CD1 PHE    42      50.522  22.328  18.572  1.00 59.24           C  
ATOM   1266  CE1 PHE    42      50.346  21.767  17.321  1.00 59.71           C  
ATOM   1267  CZ  PHE    42      50.955  22.334  16.225  1.00 60.00           C  
ATOM   1268  CE2 PHE    42      51.753  23.466  16.386  1.00 60.33           C  
ATOM   1269  CD2 PHE    42      51.922  24.022  17.642  1.00 59.82           C  
ATOM   1270  C   PHE    42      50.722  25.709  21.819  1.00 60.81           C  
ATOM   1271  O   PHE    42      51.513  26.615  21.918  1.00 61.17           O  
ATOM   1272  N   ALA    43      50.076  25.194  22.859  1.00 61.79           N  
ATOM   1273  CA  ALA    43      50.533  25.351  24.245  1.00 62.22           C  
ATOM   1274  CB  ALA    43      49.509  26.094  25.129  1.00 61.58           C  
ATOM   1275  C   ALA    43      50.758  23.928  24.748  1.00 63.17           C  
ATOM   1276  O   ALA    43      49.905  23.034  24.556  1.00 63.19           O  
ATOM   1277  N   ASP    44      51.929  23.708  25.352  1.00 64.51           N  
ATOM   1278  CA  ASP    44      52.263  22.424  25.966  1.00 65.05           C  
ATOM   1279  CB  ASP    44      51.429  22.217  27.260  1.00 65.69           C  
ATOM   1280  CG  ASP    44      51.511  23.438  28.251  1.00 68.14           C  
ATOM   1281  OD1 ASP    44      52.666  23.772  28.637  1.00 71.73           O  
ATOM   1282  OD2 ASP    44      50.454  24.041  28.650  1.00 65.35           O  
ATOM   1283  C   ASP    44      51.977  21.358  24.900  1.00 65.21           C  
ATOM   1284  O   ASP    44      51.302  20.369  25.138  1.00 65.63           O  
ATOM   1285  N   ASP    45      52.449  21.627  23.694  1.00 65.40           N  
ATOM   1286  CA  ASP    45      52.261  20.737  22.540  1.00 65.59           C  
ATOM   1287  CB  ASP    45      53.142  19.503  22.669  1.00 66.51           C  
ATOM   1288  CG  ASP    45      54.378  19.605  21.773  1.00 71.38           C  
ATOM   1289  OD1 ASP    45      54.209  19.760  20.505  1.00 73.77           O  
ATOM   1290  OD2 ASP    45      55.511  19.566  22.353  1.00 76.92           O  
ATOM   1291  C   ASP    45      50.848  20.347  22.117  1.00 64.70           C  
ATOM   1292  O   ASP    45      50.673  19.473  21.255  1.00 64.29           O  
ATOM   1293  N   ILE    46      49.848  21.020  22.664  1.00 63.93           N  
ATOM   1294  CA  ILE    46      48.496  20.839  22.182  1.00 63.43           C  
ATOM   1295  CB  ILE    46      47.525  20.595  23.334  1.00 64.04           C  
ATOM   1296  CG1 ILE    46      48.179  19.651  24.391  1.00 64.30           C  
ATOM   1297  CD1 ILE    46      47.297  19.342  25.647  1.00 63.49           C  
ATOM   1298  CG2 ILE    46      46.167  20.104  22.784  1.00 63.48           C  
ATOM   1299  C   ILE    46      48.136  22.107  21.393  1.00 62.78           C  
ATOM   1300  O   ILE    46      48.405  23.229  21.845  1.00 62.44           O  
ATOM   1301  N   PRO    47      47.580  21.933  20.184  1.00 61.67           N  
ATOM   1302  CA  PRO    47      47.195  23.086  19.385  1.00 60.96           C  
ATOM   1303  CB  PRO    47      46.713  22.483  18.055  1.00 61.01           C  
ATOM   1304  CG  PRO    47      46.628  21.050  18.240  1.00 61.37           C  
ATOM   1305  CD  PRO    47      47.323  20.654  19.501  1.00 61.75           C  
ATOM   1306  C   PRO    47      46.063  23.861  20.027  1.00 59.95           C  
ATOM   1307  O   PRO    47      45.058  23.291  20.339  1.00 59.15           O  
ATOM   1308  N   ILE    48      46.241  25.166  20.179  1.00 59.29           N  
ATOM   1309  CA  ILE    48      45.215  26.050  20.695  1.00 58.54           C  
ATOM   1310  CB  ILE    48      45.834  27.215  21.489  1.00 58.42           C  
ATOM   1311  CG1 ILE    48      46.815  26.706  22.555  1.00 58.99           C  
ATOM   1312  CD1 ILE    48      46.200  25.695  23.593  1.00 58.08           C  
ATOM   1313  CG2 ILE    48      44.766  27.983  22.197  1.00 58.78           C  
ATOM   1314  C   ILE    48      44.408  26.645  19.542  1.00 58.31           C  
ATOM   1315  O   ILE    48      43.220  26.871  19.676  1.00 58.87           O  
ATOM   1316  N   CYS    49      45.035  26.913  18.403  1.00 57.41           N  
ATOM   1317  CA  CYS    49      44.395  27.763  17.414  1.00 56.65           C  
ATOM   1318  CB  CYS    49      44.422  29.212  17.923  1.00 56.74           C  
ATOM   1319  SG  CYS    49      46.012  30.016  17.879  1.00 59.53           S  
ATOM   1320  C   CYS    49      44.972  27.692  16.008  1.00 55.55           C  
ATOM   1321  O   CYS    49      46.112  27.347  15.771  1.00 55.76           O  
ATOM   1322  N   PHE    50      44.135  28.022  15.060  1.00 55.34           N  
ATOM   1323  CA  PHE    50      44.505  28.073  13.647  1.00 54.60           C  
ATOM   1324  CB  PHE    50      43.685  27.060  12.884  1.00 54.13           C  
ATOM   1325  CG  PHE    50      43.909  27.094  11.427  1.00 54.23           C  
ATOM   1326  CD1 PHE    50      44.902  26.337  10.862  1.00 54.72           C  
ATOM   1327  CE1 PHE    50      45.121  26.346   9.521  1.00 54.50           C  
ATOM   1328  CZ  PHE    50      44.354  27.121   8.737  1.00 54.82           C  
ATOM   1329  CE2 PHE    50      43.354  27.888   9.289  1.00 54.91           C  
ATOM   1330  CD2 PHE    50      43.124  27.865  10.617  1.00 54.51           C  
ATOM   1331  C   PHE    50      44.148  29.449  13.141  1.00 53.70           C  
ATOM   1332  O   PHE    50      43.010  29.926  13.330  1.00 54.12           O  
ATOM   1333  N   GLU    51      45.096  30.083  12.491  1.00 52.40           N  
ATOM   1334  CA  GLU    51      44.928  31.447  12.048  1.00 51.48           C  
ATOM   1335  CB  GLU    51      45.873  32.296  12.912  1.00 51.98           C  
ATOM   1336  CG  GLU    51      46.167  33.708  12.443  1.00 53.18           C  
ATOM   1337  CD  GLU    51      47.103  34.446  13.376  1.00 53.76           C  
ATOM   1338  OE1 GLU    51      46.623  34.789  14.522  1.00 60.44           O  
ATOM   1339  OE2 GLU    51      48.265  34.701  12.943  1.00 52.48           O  
ATOM   1340  C   GLU    51      45.243  31.598  10.555  1.00 49.93           C  
ATOM   1341  O   GLU    51      46.285  31.182  10.099  1.00 49.47           O  
ATOM   1342  N   VAL    52      44.350  32.218   9.813  1.00 49.02           N  
ATOM   1343  CA  VAL    52      44.660  32.667   8.461  1.00 48.32           C  
ATOM   1344  CB  VAL    52      43.472  32.436   7.472  1.00 47.93           C  
ATOM   1345  CG1 VAL    52      43.903  32.727   6.051  1.00 45.34           C  
ATOM   1346  CG2 VAL    52      43.016  31.060   7.602  1.00 46.90           C  
ATOM   1347  C   VAL    52      44.949  34.163   8.515  1.00 47.65           C  
ATOM   1348  O   VAL    52      44.144  34.941   9.011  1.00 47.93           O  
ATOM   1349  N   ALA    53      46.062  34.576   7.950  1.00 46.88           N  
ATOM   1350  CA  ALA    53      46.359  35.982   7.920  1.00 46.27           C  
ATOM   1351  CB  ALA    53      47.501  36.285   8.853  1.00 45.46           C  
ATOM   1352  C   ALA    53      46.658  36.432   6.489  1.00 45.29           C  
ATOM   1353  O   ALA    53      47.380  35.772   5.750  1.00 44.22           O  
ATOM   1354  N   SER    54      46.079  37.565   6.116  1.00 44.82           N  
ATOM   1355  CA  SER    54      46.326  38.148   4.820  1.00 45.05           C  
ATOM   1356  CB  SER    54      45.056  38.124   3.966  1.00 44.62           C  
ATOM   1357  OG  SER    54      44.801  36.823   3.452  1.00 40.96           O  
ATOM   1358  C   SER    54      46.868  39.573   4.956  1.00 45.50           C  
ATOM   1359  O   SER    54      46.253  40.408   5.572  1.00 46.84           O  
ATOM   1360  N   ILE    55      48.026  39.830   4.361  1.00 45.69           N  
ATOM   1361  CA  ILE    55      48.713  41.115   4.446  1.00 45.44           C  
ATOM   1362  CB  ILE    55      50.081  40.929   5.130  1.00 45.08           C  
ATOM   1363  CG1 ILE    55      49.873  40.333   6.514  1.00 44.34           C  
ATOM   1364  CD1 ILE    55      50.869  39.335   6.890  1.00 41.72           C  
ATOM   1365  CG2 ILE    55      50.855  42.244   5.197  1.00 44.78           C  
ATOM   1366  C   ILE    55      48.934  41.617   3.005  1.00 45.44           C  
ATOM   1367  O   ILE    55      49.293  40.848   2.150  1.00 44.57           O  
ATOM   1368  N   PRO    56      48.680  42.901   2.741  1.00 45.76           N  
ATOM   1369  CA  PRO    56      48.947  43.456   1.436  1.00 45.64           C  
ATOM   1370  CB  PRO    56      48.760  44.949   1.663  1.00 45.38           C  
ATOM   1371  CG  PRO    56      47.764  45.019   2.733  1.00 45.95           C  
ATOM   1372  CD  PRO    56      48.086  43.898   3.651  1.00 46.48           C  
ATOM   1373  C   PRO    56      50.376  43.144   1.072  1.00 45.83           C  
ATOM   1374  O   PRO    56      51.246  43.367   1.911  1.00 46.46           O  
ATOM   1375  N   TYR    57      50.633  42.596  -0.121  1.00 45.25           N  
ATOM   1376  CA  TYR    57      51.982  42.139  -0.410  1.00 45.86           C  
ATOM   1377  CB  TYR    57      52.075  41.239  -1.665  1.00 45.64           C  
ATOM   1378  CG  TYR    57      53.440  40.587  -1.840  1.00 44.64           C  
ATOM   1379  CD1 TYR    57      54.035  39.961  -0.775  1.00 43.06           C  
ATOM   1380  CE1 TYR    57      55.278  39.361  -0.870  1.00 43.55           C  
ATOM   1381  CZ  TYR    57      55.953  39.361  -2.038  1.00 44.64           C  
ATOM   1382  OH  TYR    57      57.180  38.720  -1.982  1.00 46.48           O  
ATOM   1383  CE2 TYR    57      55.400  39.976  -3.168  1.00 42.99           C  
ATOM   1384  CD2 TYR    57      54.130  40.595  -3.060  1.00 43.09           C  
ATOM   1385  C   TYR    57      52.914  43.325  -0.549  1.00 46.06           C  
ATOM   1386  O   TYR    57      54.090  43.198  -0.314  1.00 45.53           O  
ATOM   1387  N   SER    58      52.403  44.481  -0.940  1.00 47.17           N  
ATOM   1388  CA  SER    58      53.289  45.604  -1.162  1.00 48.11           C  
ATOM   1389  CB  SER    58      52.546  46.736  -1.780  1.00 47.99           C  
ATOM   1390  OG  SER    58      51.825  47.338  -0.740  1.00 50.25           O  
ATOM   1391  C   SER    58      53.900  46.119   0.131  1.00 49.09           C  
ATOM   1392  O   SER    58      54.949  46.691   0.082  1.00 49.71           O  
ATOM   1393  N   LEU    59      53.270  45.934   1.286  1.00 49.94           N  
ATOM   1394  CA  LEU    59      53.893  46.390   2.543  1.00 50.63           C  
ATOM   1395  CB  LEU    59      52.878  46.506   3.702  1.00 50.50           C  
ATOM   1396  CG  LEU    59      51.624  47.344   3.445  1.00 50.78           C  
ATOM   1397  CD1 LEU    59      50.496  46.975   4.439  1.00 48.14           C  
ATOM   1398  CD2 LEU    59      51.974  48.833   3.445  1.00 50.51           C  
ATOM   1399  C   LEU    59      54.969  45.464   3.046  1.00 51.77           C  
ATOM   1400  O   LEU    59      55.605  45.756   4.081  1.00 53.56           O  
ATOM   1401  N   VAL    60      55.161  44.331   2.387  1.00 52.04           N  
ATOM   1402  CA  VAL    60      55.871  43.229   3.035  1.00 52.07           C  
ATOM   1403  CB  VAL    60      54.772  42.272   3.638  1.00 52.60           C  
ATOM   1404  CG1 VAL    60      54.716  40.941   2.924  1.00 52.85           C  
ATOM   1405  CG2 VAL    60      54.911  42.154   5.171  1.00 51.04           C  
ATOM   1406  C   VAL    60      56.917  42.553   2.137  1.00 52.27           C  
ATOM   1407  O   VAL    60      57.747  41.784   2.635  1.00 52.19           O  
ATOM   1408  N   SER    61      56.880  42.892   0.835  1.00 52.26           N  
ATOM   1409  CA  SER    61      57.800  42.433  -0.175  1.00 52.56           C  
ATOM   1410  CB  SER    61      57.927  43.452  -1.302  1.00 52.22           C  
ATOM   1411  OG  SER    61      56.762  43.568  -2.023  1.00 50.76           O  
ATOM   1412  C   SER    61      59.193  42.334   0.339  1.00 54.01           C  
ATOM   1413  O   SER    61      59.937  41.452  -0.087  1.00 54.95           O  
ATOM   1414  N   GLN    62      59.589  43.309   1.154  1.00 54.80           N  
ATOM   1415  CA  GLN    62      60.990  43.507   1.448  1.00 55.39           C  
ATOM   1416  CB  GLN    62      61.327  44.993   1.483  1.00 55.61           C  
ATOM   1417  CG  GLN    62      60.892  45.798   0.261  1.00 57.32           C  
ATOM   1418  CD  GLN    62      61.375  45.233  -1.113  1.00 61.44           C  
ATOM   1419  OE1 GLN    62      62.586  44.979  -1.345  1.00 61.49           O  
ATOM   1420  NE2 GLN    62      60.415  45.074  -2.042  1.00 61.82           N  
ATOM   1421  C   GLN    62      61.378  42.844   2.746  1.00 55.11           C  
ATOM   1422  O   GLN    62      62.528  42.769   3.067  1.00 54.97           O  
ATOM   1423  N   TYR    63      60.432  42.331   3.490  1.00 55.62           N  
ATOM   1424  CA  TYR    63      60.788  41.624   4.715  1.00 56.61           C  
ATOM   1425  CB  TYR    63      59.704  41.790   5.806  1.00 57.30           C  
ATOM   1426  CG  TYR    63      59.279  43.248   6.011  1.00 58.09           C  
ATOM   1427  CD1 TYR    63      58.064  43.574   6.572  1.00 58.04           C  
ATOM   1428  CE1 TYR    63      57.699  44.901   6.742  1.00 59.17           C  
ATOM   1429  CZ  TYR    63      58.554  45.907   6.331  1.00 58.62           C  
ATOM   1430  OH  TYR    63      58.228  47.233   6.437  1.00 59.12           O  
ATOM   1431  CE2 TYR    63      59.743  45.605   5.784  1.00 58.72           C  
ATOM   1432  CD2 TYR    63      60.106  44.298   5.624  1.00 59.54           C  
ATOM   1433  C   TYR    63      61.008  40.192   4.340  1.00 56.32           C  
ATOM   1434  O   TYR    63      60.675  39.808   3.253  1.00 57.28           O  
ATOM   1435  N   GLY    64      61.609  39.421   5.221  1.00 56.27           N  
ATOM   1436  CA  GLY    64      61.839  38.027   4.986  1.00 56.20           C  
ATOM   1437  C   GLY    64      60.908  37.261   5.882  1.00 56.70           C  
ATOM   1438  O   GLY    64      60.444  37.767   6.892  1.00 56.87           O  
ATOM   1439  N   LYS    65      60.680  36.015   5.500  1.00 57.08           N  
ATOM   1440  CA  LYS    65      59.663  35.138   6.061  1.00 57.01           C  
ATOM   1441  CB  LYS    65      59.891  33.722   5.532  1.00 56.96           C  
ATOM   1442  CG  LYS    65      58.959  32.645   6.047  1.00 57.71           C  
ATOM   1443  CD  LYS    65      58.839  31.492   5.053  1.00 57.88           C  
ATOM   1444  CE  LYS    65      57.800  30.458   5.485  1.00 59.30           C  
ATOM   1445  NZ  LYS    65      57.469  29.549   4.343  1.00 60.81           N  
ATOM   1446  C   LYS    65      59.632  35.111   7.583  1.00 57.12           C  
ATOM   1447  O   LYS    65      58.538  35.116   8.186  1.00 56.36           O  
ATOM   1448  N   SER    66      60.822  35.052   8.184  1.00 56.97           N  
ATOM   1449  CA  SER    66      60.971  34.940   9.647  1.00 56.91           C  
ATOM   1450  CB  SER    66      62.448  34.856   9.990  1.00 56.99           C  
ATOM   1451  OG  SER    66      63.180  35.553   8.973  1.00 59.35           O  
ATOM   1452  C   SER    66      60.403  36.153  10.330  1.00 56.41           C  
ATOM   1453  O   SER    66      59.679  36.019  11.317  1.00 56.18           O  
ATOM   1454  N   GLU    67      60.774  37.333   9.818  1.00 56.50           N  
ATOM   1455  CA  GLU    67      60.273  38.615  10.305  1.00 56.88           C  
ATOM   1456  CB  GLU    67      60.755  39.796   9.461  1.00 56.55           C  
ATOM   1457  CG  GLU    67      62.205  40.138   9.614  1.00 57.12           C  
ATOM   1458  CD  GLU    67      62.722  41.072   8.519  1.00 57.60           C  
ATOM   1459  OE1 GLU    67      62.497  40.779   7.334  1.00 58.04           O  
ATOM   1460  OE2 GLU    67      63.384  42.091   8.836  1.00 59.58           O  
ATOM   1461  C   GLU    67      58.781  38.567  10.225  1.00 57.09           C  
ATOM   1462  O   GLU    67      58.098  38.769  11.217  1.00 57.13           O  
ATOM   1463  N   ILE    68      58.269  38.266   9.037  1.00 57.54           N  
ATOM   1464  CA  ILE    68      56.814  38.234   8.856  1.00 58.10           C  
ATOM   1465  CB  ILE    68      56.393  37.953   7.410  1.00 57.62           C  
ATOM   1466  CG1 ILE    68      56.836  39.140   6.535  1.00 57.78           C  
ATOM   1467  CD1 ILE    68      56.783  38.930   5.025  1.00 57.61           C  
ATOM   1468  CG2 ILE    68      54.889  37.726   7.363  1.00 56.58           C  
ATOM   1469  C   ILE    68      56.138  37.257   9.778  1.00 58.31           C  
ATOM   1470  O   ILE    68      55.095  37.568  10.307  1.00 58.35           O  
ATOM   1471  N   THR    69      56.735  36.093   9.983  1.00 59.31           N  
ATOM   1472  CA  THR    69      56.082  35.034  10.738  1.00 60.56           C  
ATOM   1473  CB  THR    69      56.573  33.624  10.343  1.00 60.50           C  
ATOM   1474  OG1 THR    69      57.922  33.690   9.870  1.00 62.21           O  
ATOM   1475  CG2 THR    69      55.714  33.060   9.218  1.00 60.20           C  
ATOM   1476  C   THR    69      56.181  35.232  12.230  1.00 61.36           C  
ATOM   1477  O   THR    69      55.188  35.041  12.915  1.00 62.44           O  
ATOM   1478  N   ASN    70      57.330  35.675  12.734  1.00 62.34           N  
ATOM   1479  CA  ASN    70      57.538  35.792  14.196  1.00 62.99           C  
ATOM   1480  CB  ASN    70      58.825  35.062  14.641  1.00 63.60           C  
ATOM   1481  CG  ASN    70      59.089  33.775  13.853  1.00 65.59           C  
ATOM   1482  OD1 ASN    70      59.995  33.727  13.000  1.00 67.25           O  
ATOM   1483  ND2 ASN    70      58.278  32.741  14.108  1.00 66.68           N  
ATOM   1484  C   ASN    70      57.610  37.229  14.759  1.00 63.58           C  
ATOM   1485  O   ASN    70      57.522  37.413  15.964  1.00 64.54           O  
ATOM   1486  N   SER    71      57.793  38.243  13.926  1.00 63.29           N  
ATOM   1487  CA  SER    71      58.109  39.576  14.444  1.00 62.82           C  
ATOM   1488  CB  SER    71      59.602  39.841  14.229  1.00 63.27           C  
ATOM   1489  OG  SER    71      60.374  38.706  14.576  1.00 64.10           O  
ATOM   1490  C   SER    71      57.308  40.621  13.703  1.00 62.07           C  
ATOM   1491  O   SER    71      57.796  41.724  13.403  1.00 61.87           O  
ATOM   1492  N   PHE    72      56.075  40.266  13.375  1.00 60.95           N  
ATOM   1493  CA  PHE    72      55.352  41.039  12.380  1.00 60.62           C  
ATOM   1494  CB  PHE    72      54.002  40.394  12.068  1.00 59.71           C  
ATOM   1495  CG  PHE    72      53.226  41.113  11.017  1.00 59.52           C  
ATOM   1496  CD1 PHE    72      53.869  41.651   9.898  1.00 57.25           C  
ATOM   1497  CE1 PHE    72      53.161  42.310   8.924  1.00 56.85           C  
ATOM   1498  CZ  PHE    72      51.795  42.433   9.043  1.00 57.63           C  
ATOM   1499  CE2 PHE    72      51.135  41.900  10.152  1.00 58.57           C  
ATOM   1500  CD2 PHE    72      51.854  41.242  11.131  1.00 58.26           C  
ATOM   1501  C   PHE    72      55.169  42.477  12.834  1.00 60.35           C  
ATOM   1502  O   PHE    72      55.526  43.423  12.124  1.00 60.09           O  
ATOM   1503  N   TYR    73      54.650  42.627  14.043  1.00 60.53           N  
ATOM   1504  CA  TYR    73      54.369  43.945  14.559  1.00 60.68           C  
ATOM   1505  CB  TYR    73      53.544  43.817  15.820  1.00 60.60           C  
ATOM   1506  CG  TYR    73      52.115  43.401  15.588  1.00 60.57           C  
ATOM   1507  CD1 TYR    73      51.488  43.600  14.351  1.00 60.33           C  
ATOM   1508  CE1 TYR    73      50.146  43.243  14.133  1.00 59.59           C  
ATOM   1509  CZ  TYR    73      49.411  42.686  15.149  1.00 61.24           C  
ATOM   1510  OH  TYR    73      48.086  42.340  14.905  1.00 60.98           O  
ATOM   1511  CE2 TYR    73      50.009  42.473  16.414  1.00 61.73           C  
ATOM   1512  CD2 TYR    73      51.359  42.840  16.622  1.00 61.38           C  
ATOM   1513  C   TYR    73      55.654  44.744  14.766  1.00 60.62           C  
ATOM   1514  O   TYR    73      55.789  45.842  14.200  1.00 59.42           O  
ATOM   1515  N   LYS    74      56.582  44.167  15.544  1.00 61.09           N  
ATOM   1516  CA  LYS    74      57.967  44.672  15.664  1.00 61.36           C  
ATOM   1517  CB  LYS    74      58.948  43.599  16.243  1.00 61.82           C  
ATOM   1518  CG  LYS    74      58.562  42.915  17.610  1.00 64.03           C  
ATOM   1519  CD  LYS    74      58.799  43.809  18.865  1.00 65.00           C  
ATOM   1520  CE  LYS    74      57.616  43.822  19.899  1.00 64.60           C  
ATOM   1521  NZ  LYS    74      57.615  42.683  20.891  1.00 64.65           N  
ATOM   1522  C   LYS    74      58.521  45.115  14.310  1.00 61.44           C  
ATOM   1523  O   LYS    74      58.907  46.270  14.108  1.00 61.82           O  
ATOM   1524  N   THR    75      58.576  44.187  13.370  1.00 61.19           N  
ATOM   1525  CA  THR    75      59.240  44.460  12.111  1.00 61.24           C  
ATOM   1526  CB  THR    75      59.231  43.219  11.204  1.00 61.50           C  
ATOM   1527  OG1 THR    75      59.816  42.122  11.934  1.00 60.59           O  
ATOM   1528  CG2 THR    75      59.983  43.472   9.865  1.00 59.89           C  
ATOM   1529  C   THR    75      58.579  45.602  11.415  1.00 61.11           C  
ATOM   1530  O   THR    75      59.240  46.425  10.828  1.00 61.07           O  
ATOM   1531  N   LEU    76      57.262  45.647  11.501  1.00 61.67           N  
ATOM   1532  CA  LEU    76      56.463  46.619  10.753  1.00 62.50           C  
ATOM   1533  CB  LEU    76      54.988  46.319  10.992  1.00 62.04           C  
ATOM   1534  CG  LEU    76      53.996  46.464   9.848  1.00 62.11           C  
ATOM   1535  CD1 LEU    76      54.586  46.209   8.487  1.00 60.53           C  
ATOM   1536  CD2 LEU    76      52.833  45.533  10.124  1.00 62.29           C  
ATOM   1537  C   LEU    76      56.789  48.044  11.183  1.00 63.29           C  
ATOM   1538  O   LEU    76      57.062  48.928  10.352  1.00 63.03           O  
ATOM   1539  N   GLU    77      56.779  48.231  12.504  1.00 64.51           N  
ATOM   1540  CA  GLU    77      57.104  49.504  13.143  1.00 65.40           C  
ATOM   1541  CB  GLU    77      56.608  49.528  14.594  1.00 66.12           C  
ATOM   1542  CG  GLU    77      55.290  50.300  14.752  1.00 67.50           C  
ATOM   1543  CD  GLU    77      54.557  49.980  16.045  1.00 68.10           C  
ATOM   1544  OE1 GLU    77      54.968  49.028  16.755  1.00 72.45           O  
ATOM   1545  OE2 GLU    77      53.547  50.668  16.341  1.00 71.93           O  
ATOM   1546  C   GLU    77      58.587  49.836  13.098  1.00 65.52           C  
ATOM   1547  O   GLU    77      58.932  50.947  12.739  1.00 66.33           O  
ATOM   1548  N   ALA    78      59.474  48.895  13.422  1.00 65.34           N  
ATOM   1549  CA  ALA    78      60.910  49.135  13.169  1.00 65.44           C  
ATOM   1550  CB  ALA    78      61.771  47.904  13.524  1.00 64.89           C  
ATOM   1551  C   ALA    78      61.223  49.604  11.729  1.00 65.37           C  
ATOM   1552  O   ALA    78      62.213  50.280  11.528  1.00 66.10           O  
ATOM   1553  N   LYS    79      60.404  49.262  10.737  1.00 65.47           N  
ATOM   1554  CA  LYS    79      60.795  49.490   9.345  1.00 65.81           C  
ATOM   1555  CB  LYS    79      60.943  48.167   8.588  1.00 65.64           C  
ATOM   1556  CG  LYS    79      61.991  47.223   9.179  1.00 66.33           C  
ATOM   1557  CD  LYS    79      62.897  46.592   8.096  1.00 65.98           C  
ATOM   1558  CE  LYS    79      63.660  45.370   8.622  1.00 65.01           C  
ATOM   1559  NZ  LYS    79      64.861  45.060   7.802  1.00 65.44           N  
ATOM   1560  C   LYS    79      59.891  50.401   8.538  1.00 66.08           C  
ATOM   1561  O   LYS    79      60.391  51.292   7.858  1.00 66.12           O  
ATOM   1562  N   SER    80      58.574  50.182   8.589  1.00 66.35           N  
ATOM   1563  CA  SER    80      57.687  50.703   7.521  1.00 66.13           C  
ATOM   1564  CB  SER    80      56.305  50.075   7.622  1.00 65.90           C  
ATOM   1565  OG  SER    80      55.872  50.120   8.952  1.00 64.81           O  
ATOM   1566  C   SER    80      57.564  52.221   7.516  1.00 66.30           C  
ATOM   1567  O   SER    80      57.103  52.811   6.510  1.00 65.64           O  
ATOM   1568  N   GLY    81      58.002  52.835   8.629  1.00 66.65           N  
ATOM   1569  CA  GLY    81      57.761  54.241   8.894  1.00 66.81           C  
ATOM   1570  C   GLY    81      56.253  54.415   8.915  1.00 67.35           C  
ATOM   1571  O   GLY    81      55.673  55.038   8.024  1.00 68.26           O  
ATOM   1572  N   HIS    82      55.617  53.773   9.883  1.00 67.09           N  
ATOM   1573  CA  HIS    82      54.189  53.900  10.133  1.00 66.75           C  
ATOM   1574  CB  HIS    82      53.341  53.027   9.220  1.00 66.86           C  
ATOM   1575  CG  HIS    82      53.173  53.542   7.831  1.00 67.50           C  
ATOM   1576  ND1 HIS    82      53.553  52.811   6.722  1.00 68.26           N  
ATOM   1577  CE1 HIS    82      53.272  53.498   5.629  1.00 68.32           C  
ATOM   1578  NE2 HIS    82      52.707  54.638   5.990  1.00 68.21           N  
ATOM   1579  CD2 HIS    82      52.630  54.688   7.362  1.00 67.56           C  
ATOM   1580  C   HIS    82      53.994  53.372  11.535  1.00 66.25           C  
ATOM   1581  O   HIS    82      54.817  52.606  12.055  1.00 65.10           O  
ATOM   1582  N   LYS    83      52.884  53.765  12.132  1.00 66.31           N  
ATOM   1583  CA  LYS    83      52.539  53.270  13.446  1.00 66.73           C  
ATOM   1584  CB  LYS    83      52.354  54.433  14.433  1.00 67.46           C  
ATOM   1585  CG  LYS    83      53.643  55.208  14.738  1.00 69.09           C  
ATOM   1586  CD  LYS    83      54.688  54.330  15.476  1.00 71.26           C  
ATOM   1587  CE  LYS    83      55.970  55.086  15.811  1.00 71.11           C  
ATOM   1588  NZ  LYS    83      56.192  54.969  17.289  1.00 73.94           N  
ATOM   1589  C   LYS    83      51.284  52.425  13.369  1.00 65.95           C  
ATOM   1590  O   LYS    83      50.337  52.740  12.641  1.00 65.91           O  
ATOM   1591  N   ILE    84      51.309  51.333  14.108  1.00 65.12           N  
ATOM   1592  CA  ILE    84      50.148  50.486  14.251  1.00 65.44           C  
ATOM   1593  CB  ILE    84      50.515  49.190  15.062  1.00 65.60           C  
ATOM   1594  CG1 ILE    84      51.538  48.359  14.250  1.00 64.73           C  
ATOM   1595  CD1 ILE    84      51.959  47.057  14.905  1.00 64.78           C  
ATOM   1596  CG2 ILE    84      49.236  48.398  15.428  1.00 64.02           C  
ATOM   1597  C   ILE    84      48.996  51.270  14.927  1.00 65.59           C  
ATOM   1598  O   ILE    84      49.115  51.653  16.082  1.00 65.54           O  
ATOM   1599  N   GLY    85      47.904  51.517  14.197  1.00 65.25           N  
ATOM   1600  CA  GLY    85      46.768  52.288  14.728  1.00 64.93           C  
ATOM   1601  C   GLY    85      45.663  51.440  15.352  1.00 64.53           C  
ATOM   1602  O   GLY    85      45.914  50.558  16.166  1.00 64.19           O  
ATOM   1603  N   HIS    86      44.428  51.695  14.949  1.00 64.41           N  
ATOM   1604  CA  HIS    86      43.296  50.974  15.518  1.00 64.33           C  
ATOM   1605  CB  HIS    86      41.995  51.706  15.174  1.00 65.12           C  
ATOM   1606  CG  HIS    86      41.898  53.057  15.823  1.00 68.01           C  
ATOM   1607  ND1 HIS    86      41.389  54.168  15.174  1.00 70.34           N  
ATOM   1608  CE1 HIS    86      41.466  55.217  15.979  1.00 70.57           C  
ATOM   1609  NE2 HIS    86      42.015  54.830  17.122  1.00 69.63           N  
ATOM   1610  CD2 HIS    86      42.294  53.485  17.052  1.00 69.08           C  
ATOM   1611  C   HIS    86      43.220  49.534  15.037  1.00 63.87           C  
ATOM   1612  O   HIS    86      43.816  49.168  14.021  1.00 64.68           O  
ATOM   1613  N   SER    87      42.481  48.707  15.761  1.00 62.43           N  
ATOM   1614  CA  SER    87      42.098  47.398  15.238  1.00 60.99           C  
ATOM   1615  CB  SER    87      43.023  46.299  15.753  1.00 60.91           C  
ATOM   1616  OG  SER    87      42.711  46.043  17.107  1.00 62.22           O  
ATOM   1617  C   SER    87      40.652  47.132  15.634  1.00 59.77           C  
ATOM   1618  O   SER    87      40.094  47.804  16.499  1.00 59.93           O  
ATOM   1619  N   ASN    88      40.015  46.197  14.950  1.00 58.14           N  
ATOM   1620  CA  ASN    88      38.681  45.797  15.334  1.00 56.49           C  
ATOM   1621  CB  ASN    88      37.644  46.733  14.701  1.00 56.62           C  
ATOM   1622  CG  ASN    88      37.519  46.561  13.233  1.00 59.15           C  
ATOM   1623  OD1 ASN    88      37.089  45.492  12.758  1.00 63.48           O  
ATOM   1624  ND2 ASN    88      37.850  47.615  12.475  1.00 60.78           N  
ATOM   1625  C   ASN    88      38.464  44.284  15.144  1.00 54.58           C  
ATOM   1626  O   ASN    88      39.161  43.619  14.395  1.00 54.18           O  
ATOM   1627  N   GLN    89      37.567  43.731  15.925  1.00 52.67           N  
ATOM   1628  CA  GLN    89      37.459  42.302  16.090  1.00 51.84           C  
ATOM   1629  CB  GLN    89      38.092  41.909  17.414  1.00 51.40           C  
ATOM   1630  CG  GLN    89      39.559  41.784  17.376  1.00 51.50           C  
ATOM   1631  CD  GLN    89      40.148  41.727  18.756  1.00 52.26           C  
ATOM   1632  OE1 GLN    89      39.634  42.399  19.668  1.00 55.51           O  
ATOM   1633  NE2 GLN    89      41.232  40.944  18.932  1.00 44.23           N  
ATOM   1634  C   GLN    89      36.000  41.920  16.128  1.00 50.38           C  
ATOM   1635  O   GLN    89      35.183  42.644  16.653  1.00 49.53           O  
ATOM   1636  N   THR    90      35.682  40.768  15.583  1.00 50.07           N  
ATOM   1637  CA  THR    90      34.317  40.271  15.572  1.00 50.31           C  
ATOM   1638  CB  THR    90      33.694  40.352  14.174  1.00 50.38           C  
ATOM   1639  OG1 THR    90      33.857  41.686  13.683  1.00 51.12           O  
ATOM   1640  CG2 THR    90      32.185  40.012  14.187  1.00 49.21           C  
ATOM   1641  C   THR    90      34.407  38.853  16.044  1.00 50.10           C  
ATOM   1642  O   THR    90      35.054  38.020  15.407  1.00 51.56           O  
ATOM   1643  N   ILE    91      33.800  38.599  17.194  1.00 49.46           N  
ATOM   1644  CA  ILE    91      33.896  37.323  17.867  1.00 49.05           C  
ATOM   1645  CB  ILE    91      34.143  37.533  19.342  1.00 49.09           C  
ATOM   1646  CG1 ILE    91      35.359  38.449  19.522  1.00 48.77           C  
ATOM   1647  CD1 ILE    91      35.589  38.748  20.945  1.00 49.36           C  
ATOM   1648  CG2 ILE    91      34.354  36.197  20.046  1.00 48.53           C  
ATOM   1649  C   ILE    91      32.621  36.535  17.691  1.00 48.72           C  
ATOM   1650  O   ILE    91      31.554  37.040  17.947  1.00 48.31           O  
ATOM   1651  N   SER    92      32.734  35.303  17.212  1.00 48.65           N  
ATOM   1652  CA  SER    92      31.569  34.441  17.071  1.00 48.92           C  
ATOM   1653  CB  SER    92      31.054  34.481  15.636  1.00 48.51           C  
ATOM   1654  OG  SER    92      32.098  34.168  14.726  1.00 48.47           O  
ATOM   1655  C   SER    92      31.965  33.038  17.430  1.00 48.69           C  
ATOM   1656  O   SER    92      33.117  32.765  17.684  1.00 48.83           O  
ATOM   1657  N   ALA    93      30.987  32.161  17.443  1.00 49.88           N  
ATOM   1658  CA  ALA    93      31.148  30.772  17.782  1.00 50.89           C  
ATOM   1659  CB  ALA    93      30.271  30.454  18.926  1.00 50.66           C  
ATOM   1660  C   ALA    93      30.746  29.924  16.570  1.00 51.92           C  
ATOM   1661  O   ALA    93      29.742  30.171  15.960  1.00 51.99           O  
ATOM   1662  N   VAL    94      31.539  28.918  16.238  1.00 53.30           N  
ATOM   1663  CA  VAL    94      31.309  28.105  15.060  1.00 54.08           C  
ATOM   1664  CB  VAL    94      32.133  28.663  13.895  1.00 54.37           C  
ATOM   1665  CG1 VAL    94      32.156  27.709  12.760  1.00 55.01           C  
ATOM   1666  CG2 VAL    94      31.514  29.974  13.435  1.00 54.26           C  
ATOM   1667  C   VAL    94      31.695  26.653  15.325  1.00 54.83           C  
ATOM   1668  O   VAL    94      32.545  26.370  16.132  1.00 54.71           O  
ATOM   1669  N   GLN    95      31.062  25.725  14.634  1.00 56.09           N  
ATOM   1670  CA  GLN    95      31.480  24.315  14.711  1.00 56.95           C  
ATOM   1671  CB  GLN    95      30.389  23.439  14.118  1.00 57.33           C  
ATOM   1672  CG  GLN    95      29.005  23.814  14.561  1.00 58.13           C  
ATOM   1673  CD  GLN    95      28.123  22.635  14.519  1.00 60.37           C  
ATOM   1674  OE1 GLN    95      27.422  22.426  13.548  1.00 61.67           O  
ATOM   1675  NE2 GLN    95      28.208  21.793  15.543  1.00 62.95           N  
ATOM   1676  C   GLN    95      32.760  24.047  13.932  1.00 57.26           C  
ATOM   1677  O   GLN    95      32.947  24.610  12.870  1.00 57.40           O  
ATOM   1678  N   ALA    96      33.618  23.165  14.424  1.00 58.08           N  
ATOM   1679  CA  ALA    96      34.857  22.818  13.699  1.00 58.74           C  
ATOM   1680  CB  ALA    96      35.737  21.976  14.556  1.00 58.50           C  
ATOM   1681  C   ALA    96      34.548  22.075  12.420  1.00 59.31           C  
ATOM   1682  O   ALA    96      33.764  21.131  12.431  1.00 59.39           O  
ATOM   1683  N   SER    97      35.133  22.525  11.312  1.00 60.42           N  
ATOM   1684  CA  SER    97      35.107  21.767  10.043  1.00 61.00           C  
ATOM   1685  CB  SER    97      35.525  22.640   8.873  1.00 60.27           C  
ATOM   1686  OG  SER    97      36.930  22.787   8.865  1.00 60.13           O  
ATOM   1687  C   SER    97      36.038  20.540  10.141  1.00 62.02           C  
ATOM   1688  O   SER    97      36.840  20.395  11.092  1.00 62.18           O  
ATOM   1689  N   GLU    98      35.921  19.644   9.168  1.00 63.43           N  
ATOM   1690  CA  GLU    98      36.724  18.429   9.189  1.00 63.96           C  
ATOM   1691  CB  GLU    98      36.449  17.617   7.939  1.00 64.18           C  
ATOM   1692  CG  GLU    98      37.235  16.294   7.807  1.00 65.28           C  
ATOM   1693  CD  GLU    98      37.186  15.778   6.340  1.00 67.67           C  
ATOM   1694  OE1 GLU    98      36.177  16.062   5.603  1.00 70.33           O  
ATOM   1695  OE2 GLU    98      38.170  15.105   5.923  1.00 73.63           O  
ATOM   1696  C   GLU    98      38.171  18.852   9.219  1.00 63.92           C  
ATOM   1697  O   GLU    98      38.965  18.389  10.034  1.00 64.26           O  
ATOM   1698  N   GLN    99      38.469  19.778   8.317  1.00 64.07           N  
ATOM   1699  CA  GLN    99      39.791  20.361   8.141  1.00 63.67           C  
ATOM   1700  CB  GLN    99      39.680  21.417   7.026  1.00 63.80           C  
ATOM   1701  CG  GLN    99      40.968  22.048   6.632  1.00 64.58           C  
ATOM   1702  CD  GLN    99      42.010  21.014   6.225  1.00 68.17           C  
ATOM   1703  OE1 GLN    99      42.632  20.319   7.085  1.00 67.56           O  
ATOM   1704  NE2 GLN    99      42.223  20.903   4.893  1.00 68.03           N  
ATOM   1705  C   GLN    99      40.368  20.979   9.425  1.00 63.32           C  
ATOM   1706  O   GLN    99      41.448  20.599   9.902  1.00 63.41           O  
ATOM   1707  N   ILE   100      39.632  21.926   9.995  1.00 62.96           N  
ATOM   1708  CA  ILE   100      40.076  22.574  11.229  1.00 62.69           C  
ATOM   1709  CB  ILE   100      39.236  23.842  11.556  1.00 62.67           C  
ATOM   1710  CG1 ILE   100      39.880  25.041  10.847  1.00 61.31           C  
ATOM   1711  CD1 ILE   100      38.927  26.034  10.434  1.00 59.86           C  
ATOM   1712  CG2 ILE   100      39.161  24.080  13.080  1.00 61.97           C  
ATOM   1713  C   ILE   100      40.116  21.592  12.380  1.00 62.13           C  
ATOM   1714  O   ILE   100      40.942  21.721  13.267  1.00 62.00           O  
ATOM   1715  N   ALA   101      39.253  20.589  12.340  1.00 61.83           N  
ATOM   1716  CA  ALA   101      39.336  19.520  13.310  1.00 62.17           C  
ATOM   1717  CB  ALA   101      38.199  18.570  13.123  1.00 61.70           C  
ATOM   1718  C   ALA   101      40.694  18.795  13.197  1.00 62.19           C  
ATOM   1719  O   ALA   101      41.392  18.630  14.221  1.00 60.67           O  
ATOM   1720  N   GLU   102      41.073  18.393  11.969  1.00 62.42           N  
ATOM   1721  CA  GLU   102      42.357  17.703  11.767  1.00 63.31           C  
ATOM   1722  CB  GLU   102      42.724  17.461  10.316  1.00 63.78           C  
ATOM   1723  CG  GLU   102      41.729  16.671   9.432  1.00 66.53           C  
ATOM   1724  CD  GLU   102      42.277  16.510   7.986  1.00 66.96           C  
ATOM   1725  OE1 GLU   102      43.521  16.232   7.884  1.00 71.08           O  
ATOM   1726  OE2 GLU   102      41.490  16.674   6.990  1.00 68.24           O  
ATOM   1727  C   GLU   102      43.454  18.554  12.320  1.00 62.80           C  
ATOM   1728  O   GLU   102      44.252  18.076  13.091  1.00 62.23           O  
ATOM   1729  N   TYR   103      43.485  19.826  11.921  1.00 62.90           N  
ATOM   1730  CA  TYR   103      44.544  20.755  12.375  1.00 62.73           C  
ATOM   1731  CB  TYR   103      44.362  22.135  11.760  1.00 62.49           C  
ATOM   1732  CG  TYR   103      44.619  22.266  10.289  1.00 62.53           C  
ATOM   1733  CD1 TYR   103      45.700  21.623   9.675  1.00 63.11           C  
ATOM   1734  CE1 TYR   103      45.945  21.768   8.313  1.00 61.14           C  
ATOM   1735  CZ  TYR   103      45.124  22.584   7.588  1.00 62.08           C  
ATOM   1736  OH  TYR   103      45.346  22.759   6.274  1.00 63.69           O  
ATOM   1737  CE2 TYR   103      44.058  23.256   8.167  1.00 62.30           C  
ATOM   1738  CD2 TYR   103      43.824  23.110   9.511  1.00 61.89           C  
ATOM   1739  C   TYR   103      44.587  20.984  13.883  1.00 62.42           C  
ATOM   1740  O   TYR   103      45.650  21.129  14.473  1.00 62.16           O  
ATOM   1741  N   LEU   104      43.430  21.100  14.504  1.00 62.63           N  
ATOM   1742  CA  LEU   104      43.413  21.403  15.924  1.00 62.76           C  
ATOM   1743  CB  LEU   104      42.288  22.384  16.223  1.00 62.29           C  
ATOM   1744  CG  LEU   104      42.546  23.812  15.738  1.00 60.70           C  
ATOM   1745  CD1 LEU   104      41.356  24.668  16.016  1.00 59.52           C  
ATOM   1746  CD2 LEU   104      43.722  24.405  16.452  1.00 61.29           C  
ATOM   1747  C   LEU   104      43.326  20.136  16.767  1.00 62.85           C  
ATOM   1748  O   LEU   104      43.361  20.191  17.973  1.00 62.42           O  
ATOM   1749  N   GLU   105      43.264  18.979  16.121  1.00 63.87           N  
ATOM   1750  CA  GLU   105      43.254  17.711  16.846  1.00 64.37           C  
ATOM   1751  CB  GLU   105      44.527  17.535  17.677  1.00 64.45           C  
ATOM   1752  CG  GLU   105      45.745  17.965  16.936  1.00 64.99           C  
ATOM   1753  CD  GLU   105      46.998  17.308  17.407  1.00 65.13           C  
ATOM   1754  OE1 GLU   105      47.370  17.383  18.595  1.00 68.92           O  
ATOM   1755  OE2 GLU   105      47.643  16.722  16.550  1.00 67.31           O  
ATOM   1756  C   GLU   105      42.054  17.693  17.757  1.00 64.54           C  
ATOM   1757  O   GLU   105      42.208  17.565  18.965  1.00 63.71           O  
ATOM   1758  N   ILE   106      40.878  17.868  17.149  1.00 64.94           N  
ATOM   1759  CA  ILE   106      39.591  17.780  17.825  1.00 65.25           C  
ATOM   1760  CB  ILE   106      39.102  19.168  18.315  1.00 65.36           C  
ATOM   1761  CG1 ILE   106      38.867  20.115  17.123  1.00 65.59           C  
ATOM   1762  CD1 ILE   106      38.648  21.547  17.524  1.00 64.73           C  
ATOM   1763  CG2 ILE   106      40.110  19.756  19.320  1.00 63.53           C  
ATOM   1764  C   ILE   106      38.675  17.175  16.783  1.00 65.80           C  
ATOM   1765  O   ILE   106      39.173  16.785  15.717  1.00 65.53           O  
ATOM   1766  N   LYS   107      37.363  17.116  17.065  1.00 66.52           N  
ATOM   1767  CA  LYS   107      36.376  16.437  16.178  1.00 66.94           C  
ATOM   1768  CB  LYS   107      35.423  15.584  17.038  1.00 67.40           C  
ATOM   1769  CG  LYS   107      36.134  14.699  18.116  1.00 69.02           C  
ATOM   1770  CD  LYS   107      35.427  13.293  18.357  1.00 69.15           C  
ATOM   1771  CE  LYS   107      36.386  12.207  18.985  1.00 69.46           C  
ATOM   1772  NZ  LYS   107      36.493  12.271  20.481  1.00 70.41           N  
ATOM   1773  C   LYS   107      35.528  17.406  15.352  1.00 66.62           C  
ATOM   1774  O   LYS   107      35.182  18.459  15.878  1.00 66.80           O  
ATOM   1775  N   ARG   108      35.166  17.049  14.101  1.00 66.31           N  
ATOM   1776  CA  ARG   108      34.150  17.805  13.317  1.00 66.14           C  
ATOM   1777  CB  ARG   108      33.649  17.064  11.990  1.00 66.38           C  
ATOM   1778  CG  ARG   108      32.615  17.840  10.965  1.00 67.02           C  
ATOM   1779  CD  ARG   108      32.940  17.842   9.325  1.00 68.03           C  
ATOM   1780  NE  ARG   108      32.397  19.042   8.542  1.00 70.42           N  
ATOM   1781  CZ  ARG   108      32.875  19.595   7.383  1.00 69.42           C  
ATOM   1782  NH1 ARG   108      33.914  19.119   6.762  1.00 71.23           N  
ATOM   1783  NH2 ARG   108      32.315  20.658   6.812  1.00 68.63           N  
ATOM   1784  C   ARG   108      33.042  18.060  14.355  1.00 65.64           C  
ATOM   1785  O   ARG   108      32.809  17.220  15.228  1.00 65.83           O  
ATOM   1786  N   GLY   109      32.446  19.250  14.335  1.00 64.45           N  
ATOM   1787  CA  GLY   109      31.366  19.562  15.229  1.00 63.52           C  
ATOM   1788  C   GLY   109      31.773  20.342  16.456  1.00 62.89           C  
ATOM   1789  O   GLY   109      30.974  21.104  16.989  1.00 63.61           O  
ATOM   1790  N   ASP   110      32.997  20.160  16.921  1.00 61.84           N  
ATOM   1791  CA  ASP   110      33.435  20.771  18.168  1.00 60.95           C  
ATOM   1792  CB  ASP   110      34.856  20.298  18.533  1.00 62.00           C  
ATOM   1793  CG  ASP   110      34.869  18.980  19.280  1.00 63.76           C  
ATOM   1794  OD1 ASP   110      33.771  18.501  19.596  1.00 67.38           O  
ATOM   1795  OD2 ASP   110      35.966  18.434  19.564  1.00 67.68           O  
ATOM   1796  C   ASP   110      33.406  22.280  18.098  1.00 59.30           C  
ATOM   1797  O   ASP   110      33.432  22.865  17.042  1.00 59.02           O  
ATOM   1798  N   ALA   111      33.379  22.893  19.261  1.00 58.06           N  
ATOM   1799  CA  ALA   111      33.066  24.306  19.406  1.00 57.38           C  
ATOM   1800  CB  ALA   111      32.536  24.554  20.818  1.00 57.21           C  
ATOM   1801  C   ALA   111      34.258  25.205  19.177  1.00 56.72           C  
ATOM   1802  O   ALA   111      35.272  25.089  19.889  1.00 57.57           O  
ATOM   1803  N   ILE   112      34.119  26.154  18.251  1.00 55.21           N  
ATOM   1804  CA  ILE   112      35.225  27.055  17.889  1.00 54.33           C  
ATOM   1805  CB  ILE   112      35.545  27.013  16.382  1.00 53.69           C  
ATOM   1806  CG1 ILE   112      36.137  25.638  15.980  1.00 52.77           C  
ATOM   1807  CD1 ILE   112      37.476  25.275  16.635  1.00 49.92           C  
ATOM   1808  CG2 ILE   112      36.436  28.152  16.043  1.00 53.76           C  
ATOM   1809  C   ILE   112      34.888  28.482  18.207  1.00 53.15           C  
ATOM   1810  O   ILE   112      33.808  28.944  17.899  1.00 51.53           O  
ATOM   1811  N   LEU   113      35.821  29.173  18.845  1.00 53.06           N  
ATOM   1812  CA  LEU   113      35.666  30.596  19.061  1.00 53.03           C  
ATOM   1813  CB  LEU   113      36.292  31.072  20.383  1.00 53.10           C  
ATOM   1814  CG  LEU   113      36.087  32.580  20.532  1.00 52.79           C  
ATOM   1815  CD1 LEU   113      34.661  32.806  21.024  1.00 54.51           C  
ATOM   1816  CD2 LEU   113      37.078  33.222  21.401  1.00 51.36           C  
ATOM   1817  C   LEU   113      36.397  31.229  17.909  1.00 53.23           C  
ATOM   1818  O   LEU   113      37.609  31.012  17.734  1.00 52.53           O  
ATOM   1819  N   ARG   114      35.667  32.020  17.138  1.00 53.46           N  
ATOM   1820  CA  ARG   114      36.223  32.610  15.948  1.00 53.18           C  
ATOM   1821  CB  ARG   114      35.293  32.455  14.780  1.00 53.98           C  
ATOM   1822  CG  ARG   114      35.992  32.861  13.486  1.00 55.81           C  
ATOM   1823  CD  ARG   114      35.286  32.347  12.284  1.00 56.37           C  
ATOM   1824  NE  ARG   114      34.281  33.310  11.980  1.00 62.18           N  
ATOM   1825  CZ  ARG   114      33.110  33.021  11.425  1.00 66.73           C  
ATOM   1826  NH1 ARG   114      32.821  31.763  11.120  1.00 69.41           N  
ATOM   1827  NH2 ARG   114      32.219  33.993  11.177  1.00 65.56           N  
ATOM   1828  C   ARG   114      36.412  34.061  16.129  1.00 51.52           C  
ATOM   1829  O   ARG   114      35.504  34.765  16.508  1.00 50.99           O  
ATOM   1830  N   VAL   115      37.595  34.520  15.806  1.00 50.91           N  
ATOM   1831  CA  VAL   115      37.861  35.942  15.832  1.00 50.00           C  
ATOM   1832  CB  VAL   115      38.953  36.307  16.861  1.00 48.85           C  
ATOM   1833  CG1 VAL   115      39.106  37.829  16.950  1.00 43.80           C  
ATOM   1834  CG2 VAL   115      38.595  35.721  18.153  1.00 46.27           C  
ATOM   1835  C   VAL   115      38.341  36.347  14.469  1.00 50.21           C  
ATOM   1836  O   VAL   115      39.296  35.795  13.969  1.00 51.89           O  
ATOM   1837  N   ARG   116      37.677  37.315  13.884  1.00 49.80           N  
ATOM   1838  CA  ARG   116      38.152  37.929  12.691  1.00 49.49           C  
ATOM   1839  CB  ARG   116      37.035  37.992  11.663  1.00 49.87           C  
ATOM   1840  CG  ARG   116      36.515  36.649  11.141  1.00 51.66           C  
ATOM   1841  CD  ARG   116      35.941  36.909   9.834  1.00 56.96           C  
ATOM   1842  NE  ARG   116      34.794  36.102   9.460  1.00 59.39           N  
ATOM   1843  CZ  ARG   116      34.878  34.960   8.799  1.00 62.41           C  
ATOM   1844  NH1 ARG   116      36.084  34.397   8.490  1.00 66.08           N  
ATOM   1845  NH2 ARG   116      33.748  34.358   8.477  1.00 60.95           N  
ATOM   1846  C   ARG   116      38.524  39.347  13.033  1.00 48.86           C  
ATOM   1847  O   ARG   116      37.747  40.070  13.642  1.00 48.25           O  
ATOM   1848  N   GLN   117      39.661  39.779  12.527  1.00 48.71           N  
ATOM   1849  CA  GLN   117      40.193  41.071  12.872  1.00 48.56           C  
ATOM   1850  CB  GLN   117      41.243  40.818  13.896  1.00 48.45           C  
ATOM   1851  CG  GLN   117      42.384  41.762  13.894  1.00 50.00           C  
ATOM   1852  CD  GLN   117      43.250  41.542  15.144  1.00 49.66           C  
ATOM   1853  OE1 GLN   117      42.762  41.248  16.252  1.00 49.02           O  
ATOM   1854  NE2 GLN   117      44.538  41.627  14.942  1.00 52.07           N  
ATOM   1855  C   GLN   117      40.811  41.792  11.679  1.00 48.14           C  
ATOM   1856  O   GLN   117      41.481  41.162  10.894  1.00 48.86           O  
ATOM   1857  N   VAL   118      40.553  43.097  11.554  1.00 47.34           N  
ATOM   1858  CA  VAL   118      41.311  43.996  10.683  1.00 46.98           C  
ATOM   1859  CB  VAL   118      40.423  44.783   9.740  1.00 45.57           C  
ATOM   1860  CG1 VAL   118      41.288  45.644   8.844  1.00 43.48           C  
ATOM   1861  CG2 VAL   118      39.588  43.858   8.940  1.00 41.77           C  
ATOM   1862  C   VAL   118      42.097  45.009  11.516  1.00 47.59           C  
ATOM   1863  O   VAL   118      41.560  45.561  12.457  1.00 48.49           O  
ATOM   1864  N   SER   119      43.345  45.264  11.152  1.00 48.06           N  
ATOM   1865  CA  SER   119      44.183  46.194  11.873  1.00 48.99           C  
ATOM   1866  CB  SER   119      45.413  45.504  12.457  1.00 49.20           C  
ATOM   1867  OG  SER   119      45.043  44.443  13.305  1.00 49.66           O  
ATOM   1868  C   SER   119      44.660  47.243  10.911  1.00 50.78           C  
ATOM   1869  O   SER   119      44.887  46.968   9.720  1.00 51.04           O  
ATOM   1870  N   TYR   120      44.848  48.447  11.436  1.00 52.36           N  
ATOM   1871  CA  TYR   120      45.118  49.599  10.596  1.00 53.81           C  
ATOM   1872  CB  TYR   120      43.912  50.539  10.637  1.00 53.34           C  
ATOM   1873  CG  TYR   120      42.625  49.910  10.233  1.00 52.23           C  
ATOM   1874  CD1 TYR   120      42.137  50.064   8.948  1.00 52.04           C  
ATOM   1875  CE1 TYR   120      40.935  49.490   8.562  1.00 51.37           C  
ATOM   1876  CZ  TYR   120      40.232  48.745   9.477  1.00 51.73           C  
ATOM   1877  OH  TYR   120      39.055  48.157   9.111  1.00 53.17           O  
ATOM   1878  CE2 TYR   120      40.706  48.574  10.755  1.00 52.14           C  
ATOM   1879  CD2 TYR   120      41.895  49.167  11.130  1.00 51.06           C  
ATOM   1880  C   TYR   120      46.343  50.379  11.045  1.00 54.45           C  
ATOM   1881  O   TYR   120      46.699  50.382  12.221  1.00 54.84           O  
ATOM   1882  N   PHE   121      46.964  51.098  10.121  1.00 55.53           N  
ATOM   1883  CA  PHE   121      47.946  52.079  10.542  1.00 56.46           C  
ATOM   1884  CB  PHE   121      48.870  52.473   9.379  1.00 56.48           C  
ATOM   1885  CG  PHE   121      49.843  51.393   9.001  1.00 55.95           C  
ATOM   1886  CD1 PHE   121      50.465  50.608   9.984  1.00 57.46           C  
ATOM   1887  CE1 PHE   121      51.393  49.607   9.640  1.00 56.87           C  
ATOM   1888  CZ  PHE   121      51.688  49.388   8.304  1.00 56.73           C  
ATOM   1889  CE2 PHE   121      51.059  50.155   7.326  1.00 56.28           C  
ATOM   1890  CD2 PHE   121      50.147  51.150   7.680  1.00 55.91           C  
ATOM   1891  C   PHE   121      47.251  53.314  11.147  1.00 57.56           C  
ATOM   1892  O   PHE   121      46.077  53.622  10.832  1.00 58.10           O  
ATOM   1893  N   GLU   122      47.989  54.032  11.993  1.00 57.96           N  
ATOM   1894  CA  GLU   122      47.539  55.339  12.459  1.00 58.02           C  
ATOM   1895  CB  GLU   122      48.619  56.062  13.267  1.00 57.75           C  
ATOM   1896  CG  GLU   122      48.876  55.329  14.583  1.00 58.73           C  
ATOM   1897  CD  GLU   122      49.683  56.115  15.601  1.00 59.40           C  
ATOM   1898  OE1 GLU   122      50.450  57.012  15.171  1.00 63.62           O  
ATOM   1899  OE2 GLU   122      49.566  55.809  16.818  1.00 57.35           O  
ATOM   1900  C   GLU   122      47.053  56.189  11.307  1.00 58.16           C  
ATOM   1901  O   GLU   122      46.253  57.060  11.527  1.00 58.29           O  
ATOM   1902  N   ASN   123      47.483  55.940  10.072  1.00 58.65           N  
ATOM   1903  CA  ASN   123      46.956  56.745   8.991  1.00 58.77           C  
ATOM   1904  CB  ASN   123      48.049  57.058   7.975  1.00 59.77           C  
ATOM   1905  CG  ASN   123      48.489  55.842   7.158  1.00 62.70           C  
ATOM   1906  OD1 ASN   123      47.692  54.953   6.816  1.00 63.41           O  
ATOM   1907  ND2 ASN   123      49.777  55.825   6.809  1.00 66.38           N  
ATOM   1908  C   ASN   123      45.719  56.175   8.318  1.00 58.63           C  
ATOM   1909  O   ASN   123      45.349  56.630   7.223  1.00 58.28           O  
ATOM   1910  N   GLY   124      45.087  55.175   8.942  1.00 58.27           N  
ATOM   1911  CA  GLY   124      43.851  54.572   8.377  1.00 57.96           C  
ATOM   1912  C   GLY   124      43.988  53.406   7.394  1.00 57.60           C  
ATOM   1913  O   GLY   124      43.000  52.794   7.035  1.00 57.60           O  
ATOM   1914  N   LEU   125      45.209  53.091   6.958  1.00 57.62           N  
ATOM   1915  CA  LEU   125      45.474  52.003   5.971  1.00 56.79           C  
ATOM   1916  CB  LEU   125      46.863  52.172   5.354  1.00 56.99           C  
ATOM   1917  CG  LEU   125      47.313  51.209   4.238  1.00 57.32           C  
ATOM   1918  CD1 LEU   125      46.559  51.492   2.962  1.00 51.24           C  
ATOM   1919  CD2 LEU   125      48.879  51.262   4.034  1.00 56.37           C  
ATOM   1920  C   LEU   125      45.439  50.619   6.641  1.00 56.59           C  
ATOM   1921  O   LEU   125      46.185  50.381   7.602  1.00 56.51           O  
ATOM   1922  N   PRO   126      44.569  49.713   6.150  1.00 55.20           N  
ATOM   1923  CA  PRO   126      44.594  48.317   6.590  1.00 54.19           C  
ATOM   1924  CB  PRO   126      43.546  47.649   5.714  1.00 54.04           C  
ATOM   1925  CG  PRO   126      42.677  48.766   5.184  1.00 55.27           C  
ATOM   1926  CD  PRO   126      43.500  49.995   5.175  1.00 55.35           C  
ATOM   1927  C   PRO   126      45.931  47.648   6.331  1.00 52.47           C  
ATOM   1928  O   PRO   126      46.533  47.848   5.270  1.00 52.28           O  
ATOM   1929  N   PHE   127      46.389  46.837   7.270  1.00 50.79           N  
ATOM   1930  CA  PHE   127      47.560  46.065   7.000  1.00 49.66           C  
ATOM   1931  CB  PHE   127      48.770  46.716   7.670  1.00 49.45           C  
ATOM   1932  CG  PHE   127      48.796  46.579   9.145  1.00 49.09           C  
ATOM   1933  CD1 PHE   127      49.357  45.457   9.733  1.00 49.51           C  
ATOM   1934  CE1 PHE   127      49.395  45.324  11.118  1.00 50.25           C  
ATOM   1935  CZ  PHE   127      48.868  46.326  11.933  1.00 49.75           C  
ATOM   1936  CE2 PHE   127      48.322  47.460  11.335  1.00 49.82           C  
ATOM   1937  CD2 PHE   127      48.293  47.583   9.962  1.00 48.80           C  
ATOM   1938  C   PHE   127      47.426  44.594   7.350  1.00 49.26           C  
ATOM   1939  O   PHE   127      48.370  43.844   7.193  1.00 50.61           O  
ATOM   1940  N   GLU   128      46.257  44.151   7.752  1.00 48.37           N  
ATOM   1941  CA  GLU   128      46.129  42.822   8.282  1.00 48.59           C  
ATOM   1942  CB  GLU   128      46.561  42.888   9.728  1.00 48.53           C  
ATOM   1943  CG  GLU   128      47.258  41.717  10.178  1.00 50.32           C  
ATOM   1944  CD  GLU   128      47.613  41.718  11.695  1.00 50.97           C  
ATOM   1945  OE1 GLU   128      46.903  42.361  12.563  1.00 48.10           O  
ATOM   1946  OE2 GLU   128      48.606  40.977  11.980  1.00 55.33           O  
ATOM   1947  C   GLU   128      44.661  42.419   8.224  1.00 48.49           C  
ATOM   1948  O   GLU   128      43.790  43.206   8.620  1.00 48.17           O  
ATOM   1949  N   TYR   129      44.360  41.220   7.741  1.00 47.88           N  
ATOM   1950  CA  TYR   129      43.021  40.662   7.924  1.00 47.72           C  
ATOM   1951  CB  TYR   129      42.290  40.605   6.589  1.00 47.75           C  
ATOM   1952  CG  TYR   129      40.957  39.924   6.655  1.00 47.52           C  
ATOM   1953  CD1 TYR   129      40.152  40.056   7.758  1.00 46.95           C  
ATOM   1954  CE1 TYR   129      38.919  39.449   7.823  1.00 46.77           C  
ATOM   1955  CZ  TYR   129      38.460  38.721   6.777  1.00 47.90           C  
ATOM   1956  OH  TYR   129      37.231  38.120   6.883  1.00 49.08           O  
ATOM   1957  CE2 TYR   129      39.221  38.586   5.643  1.00 46.54           C  
ATOM   1958  CD2 TYR   129      40.482  39.180   5.593  1.00 46.25           C  
ATOM   1959  C   TYR   129      43.222  39.275   8.479  1.00 47.18           C  
ATOM   1960  O   TYR   129      43.747  38.406   7.826  1.00 47.44           O  
ATOM   1961  N   VAL   130      42.856  39.068   9.713  1.00 47.14           N  
ATOM   1962  CA  VAL   130      43.312  37.876  10.421  1.00 46.73           C  
ATOM   1963  CB  VAL   130      44.313  38.235  11.580  1.00 46.73           C  
ATOM   1964  CG1 VAL   130      44.880  36.978  12.232  1.00 42.42           C  
ATOM   1965  CG2 VAL   130      45.438  39.132  11.030  1.00 43.30           C  
ATOM   1966  C   VAL   130      42.100  37.144  10.923  1.00 47.65           C  
ATOM   1967  O   VAL   130      41.148  37.755  11.424  1.00 48.37           O  
ATOM   1968  N   ARG   131      42.085  35.841  10.720  1.00 48.01           N  
ATOM   1969  CA  ARG   131      40.872  35.081  10.995  1.00 48.71           C  
ATOM   1970  CB  ARG   131      40.191  34.689   9.703  1.00 48.30           C  
ATOM   1971  CG  ARG   131      39.837  35.900   8.836  1.00 50.13           C  
ATOM   1972  CD  ARG   131      39.993  35.617   7.365  1.00 49.77           C  
ATOM   1973  NE  ARG   131      41.290  36.030   6.895  1.00 50.32           N  
ATOM   1974  CZ  ARG   131      41.718  35.851   5.647  1.00 49.41           C  
ATOM   1975  NH1 ARG   131      41.000  35.229   4.746  1.00 49.10           N  
ATOM   1976  NH2 ARG   131      42.903  36.268   5.305  1.00 51.37           N  
ATOM   1977  C   ARG   131      41.352  33.869  11.746  1.00 48.75           C  
ATOM   1978  O   ARG   131      42.088  33.018  11.192  1.00 48.68           O  
ATOM   1979  N   THR   132      40.990  33.838  13.018  1.00 48.37           N  
ATOM   1980  CA  THR   132      41.508  32.864  13.900  1.00 48.79           C  
ATOM   1981  CB  THR   132      42.200  33.530  15.005  1.00 48.55           C  
ATOM   1982  OG1 THR   132      43.272  34.284  14.466  1.00 47.19           O  
ATOM   1983  CG2 THR   132      42.718  32.499  15.962  1.00 49.57           C  
ATOM   1984  C   THR   132      40.408  31.999  14.456  1.00 49.47           C  
ATOM   1985  O   THR   132      39.333  32.469  14.781  1.00 49.43           O  
ATOM   1986  N   GLN   133      40.726  30.729  14.580  1.00 50.15           N  
ATOM   1987  CA  GLN   133      39.804  29.751  15.042  1.00 51.36           C  
ATOM   1988  CB  GLN   133      39.566  28.845  13.853  1.00 51.63           C  
ATOM   1989  CG  GLN   133      38.130  28.484  13.637  1.00 53.97           C  
ATOM   1990  CD  GLN   133      37.756  28.356  12.227  1.00 53.78           C  
ATOM   1991  OE1 GLN   133      38.175  29.153  11.397  1.00 59.44           O  
ATOM   1992  NE2 GLN   133      36.938  27.369  11.928  1.00 52.86           N  
ATOM   1993  C   GLN   133      40.454  29.011  16.245  1.00 52.27           C  
ATOM   1994  O   GLN   133      41.479  28.275  16.099  1.00 52.37           O  
ATOM   1995  N   TYR   134      39.922  29.265  17.440  1.00 52.39           N  
ATOM   1996  CA  TYR   134      40.437  28.675  18.702  1.00 51.75           C  
ATOM   1997  CB  TYR   134      40.318  29.669  19.851  1.00 51.18           C  
ATOM   1998  CG  TYR   134      41.065  30.944  19.651  1.00 50.26           C  
ATOM   1999  CD1 TYR   134      42.380  31.067  20.050  1.00 49.80           C  
ATOM   2000  CE1 TYR   134      43.059  32.248  19.880  1.00 49.75           C  
ATOM   2001  CZ  TYR   134      42.413  33.300  19.314  1.00 50.69           C  
ATOM   2002  OH  TYR   134      43.058  34.481  19.081  1.00 49.39           O  
ATOM   2003  CE2 TYR   134      41.095  33.189  18.947  1.00 49.62           C  
ATOM   2004  CD2 TYR   134      40.439  32.040  19.126  1.00 47.46           C  
ATOM   2005  C   TYR   134      39.574  27.481  19.102  1.00 52.15           C  
ATOM   2006  O   TYR   134      38.337  27.544  19.009  1.00 52.17           O  
ATOM   2007  N   ALA   135      40.212  26.400  19.538  1.00 52.83           N  
ATOM   2008  CA  ALA   135      39.516  25.304  20.223  1.00 53.80           C  
ATOM   2009  CB  ALA   135      40.500  24.240  20.621  1.00 54.12           C  
ATOM   2010  C   ALA   135      38.835  25.828  21.475  1.00 54.42           C  
ATOM   2011  O   ALA   135      39.522  26.263  22.380  1.00 54.82           O  
ATOM   2012  N   GLY   136      37.505  25.748  21.527  1.00 55.21           N  
ATOM   2013  CA  GLY   136      36.714  26.373  22.573  1.00 56.35           C  
ATOM   2014  C   GLY   136      37.160  25.950  23.957  1.00 57.46           C  
ATOM   2015  O   GLY   136      37.420  26.786  24.822  1.00 57.55           O  
ATOM   2016  N   SER   137      37.309  24.637  24.100  1.00 58.04           N  
ATOM   2017  CA  SER   137      37.584  23.991  25.357  1.00 58.40           C  
ATOM   2018  CB  SER   137      37.448  22.498  25.147  1.00 58.31           C  
ATOM   2019  OG  SER   137      38.656  22.013  24.582  1.00 60.24           O  
ATOM   2020  C   SER   137      39.002  24.293  25.866  1.00 58.94           C  
ATOM   2021  O   SER   137      39.258  24.267  27.052  1.00 58.77           O  
ATOM   2022  N   ARG   138      39.888  24.640  24.958  1.00 59.42           N  
ATOM   2023  CA  ARG   138      41.243  24.926  25.327  1.00 59.55           C  
ATOM   2024  CB  ARG   138      42.198  24.290  24.337  1.00 59.46           C  
ATOM   2025  CG  ARG   138      42.003  22.826  24.159  1.00 60.00           C  
ATOM   2026  CD  ARG   138      43.098  22.241  23.330  1.00 62.14           C  
ATOM   2027  NE  ARG   138      42.694  20.985  22.724  1.00 63.97           N  
ATOM   2028  CZ  ARG   138      43.002  20.627  21.491  1.00 67.45           C  
ATOM   2029  NH1 ARG   138      43.725  21.426  20.738  1.00 69.16           N  
ATOM   2030  NH2 ARG   138      42.587  19.474  21.013  1.00 68.58           N  
ATOM   2031  C   ARG   138      41.529  26.394  25.390  1.00 59.70           C  
ATOM   2032  O   ARG   138      42.649  26.771  25.597  1.00 60.22           O  
ATOM   2033  N   PHE   139      40.535  27.240  25.215  1.00 20.00           N  
ATOM   2034  CA  PHE   139      40.825  28.657  25.130  1.00 20.00           C  
ATOM   2035  C   PHE   139      39.807  29.563  25.785  1.00 20.00           C  
ATOM   2036  CB  PHE   139      40.981  29.036  23.668  1.00 20.00           C  
ATOM   2037  CG  PHE   139      41.372  30.443  23.451  1.00 20.00           C  
ATOM   2038  CD1 PHE   139      42.629  30.856  23.709  1.00 20.00           C  
ATOM   2039  CD2 PHE   139      40.481  31.348  22.985  1.00 20.00           C  
ATOM   2040  CE1 PHE   139      42.978  32.133  23.514  1.00 20.00           C  
ATOM   2041  CE2 PHE   139      40.844  32.628  22.788  1.00 20.00           C  
ATOM   2042  CZ  PHE   139      42.087  33.017  23.052  1.00 20.00           C  
ATOM   2043  O   PHE   139      38.661  29.235  25.870  1.00 59.96           O  
ATOM   2044  N   GLU   140      40.271  30.708  26.243  1.00 57.79           N  
ATOM   2045  CA  GLU   140      39.471  31.798  26.743  1.00 57.81           C  
ATOM   2046  CB  GLU   140      39.561  31.827  28.276  1.00 58.32           C  
ATOM   2047  CG  GLU   140      38.980  30.633  29.001  1.00 59.77           C  
ATOM   2048  CD  GLU   140      37.468  30.477  28.805  1.00 62.71           C  
ATOM   2049  OE1 GLU   140      36.724  31.478  28.868  1.00 64.64           O  
ATOM   2050  OE2 GLU   140      37.023  29.333  28.599  1.00 65.28           O  
ATOM   2051  C   GLU   140      39.985  33.135  26.259  1.00 56.94           C  
ATOM   2052  O   GLU   140      41.120  33.419  26.418  1.00 56.93           O  
ATOM   2053  N   PHE   141      39.147  34.003  25.747  1.00 56.96           N  
ATOM   2054  CA  PHE   141      39.609  35.288  25.253  1.00 57.82           C  
ATOM   2055  CB  PHE   141      38.846  35.543  23.966  1.00 56.48           C  
ATOM   2056  CG  PHE   141      39.082  36.868  23.306  1.00 55.72           C  
ATOM   2057  CD1 PHE   141      38.557  38.039  23.831  1.00 55.21           C  
ATOM   2058  CE1 PHE   141      38.704  39.257  23.167  1.00 55.83           C  
ATOM   2059  CZ  PHE   141      39.379  39.299  21.966  1.00 56.64           C  
ATOM   2060  CE2 PHE   141      39.896  38.125  21.431  1.00 54.39           C  
ATOM   2061  CD2 PHE   141      39.704  36.928  22.074  1.00 53.44           C  
ATOM   2062  C   PHE   141      39.343  36.299  26.354  1.00 58.49           C  
ATOM   2063  O   PHE   141      38.231  36.429  26.837  1.00 59.23           O  
ATOM   2064  N   TYR   142      40.370  37.007  26.775  1.00 60.30           N  
ATOM   2065  CA  TYR   142      40.255  37.923  27.890  1.00 61.99           C  
ATOM   2066  CB  TYR   142      41.538  37.901  28.744  1.00 62.52           C  
ATOM   2067  CG  TYR   142      41.817  36.495  29.283  1.00 63.41           C  
ATOM   2068  CD1 TYR   142      41.325  36.080  30.531  1.00 64.00           C  
ATOM   2069  CE1 TYR   142      41.540  34.760  31.004  1.00 63.03           C  
ATOM   2070  CZ  TYR   142      42.240  33.858  30.210  1.00 64.94           C  
ATOM   2071  OH  TYR   142      42.453  32.567  30.644  1.00 65.69           O  
ATOM   2072  CE2 TYR   142      42.756  34.242  28.967  1.00 64.21           C  
ATOM   2073  CD2 TYR   142      42.525  35.556  28.512  1.00 65.36           C  
ATOM   2074  C   TYR   142      39.890  39.321  27.423  1.00 63.29           C  
ATOM   2075  O   TYR   142      40.614  39.943  26.715  1.00 62.80           O  
ATOM   2076  N   LEU   143      38.725  39.812  27.804  1.00 65.62           N  
ATOM   2077  CA  LEU   143      38.378  41.174  27.496  1.00 67.74           C  
ATOM   2078  CB  LEU   143      36.963  41.468  27.958  1.00 67.89           C  
ATOM   2079  CG  LEU   143      35.934  41.088  26.905  1.00 69.11           C  
ATOM   2080  CD1 LEU   143      34.698  41.872  27.213  1.00 70.90           C  
ATOM   2081  CD2 LEU   143      35.654  39.584  26.883  1.00 70.43           C  
ATOM   2082  C   LEU   143      39.336  42.175  28.113  1.00 69.39           C  
ATOM   2083  O   LEU   143      39.666  42.069  29.251  1.00 69.58           O  
ATOM   2084  N   GLU   144      39.739  43.172  27.338  1.00 72.54           N  
ATOM   2085  CA  GLU   144      40.716  44.181  27.750  1.00 74.25           C  
ATOM   2086  CB  GLU   144      41.140  45.025  26.535  1.00 75.01           C  
ATOM   2087  CG  GLU   144      42.668  45.196  26.372  1.00 78.53           C  
ATOM   2088  CD  GLU   144      43.312  44.291  25.286  1.00 81.51           C  
ATOM   2089  OE1 GLU   144      42.961  44.465  24.090  1.00 82.90           O  
ATOM   2090  OE2 GLU   144      44.194  43.440  25.625  1.00 81.58           O  
ATOM   2091  C   GLU   144      40.084  45.065  28.820  1.00 75.75           C  
ATOM   2092  O   GLU   144      38.998  45.599  28.614  1.00 75.96           O  
ATOM   2093  N   LYS   145      40.769  45.217  29.962  1.00 77.85           N  
ATOM   2094  CA  LYS   145      40.187  45.886  31.153  1.00 78.63           C  
ATOM   2095  CB  LYS   145      41.158  45.909  32.361  1.00 79.83           C  
ATOM   2096  CG  LYS   145      41.775  44.560  32.815  1.00 81.50           C  
ATOM   2097  CD  LYS   145      40.796  43.534  33.467  1.00 83.50           C  
ATOM   2098  CE  LYS   145      41.629  42.298  34.002  1.00 84.23           C  
ATOM   2099  NZ  LYS   145      40.927  40.996  34.381  1.00 83.07           N  
ATOM   2100  C   LYS   145      39.779  47.327  30.817  1.00 79.77           C  
ATOM   2101  O   LYS   145      40.647  48.168  30.548  1.00 80.23           O  
END
