
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   87 (  696),  selected   87 , name 2fa8_B
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2fa8_B.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     4_B      -       -           -
LGA    K     5_B      T      12          1.856
LGA    P     6_B      H      13          1.324
LGA    R     7_B      R      14          0.781
LGA    I     8_B      V      15          0.368
LGA    A     9_B      Q      16          0.503
LGA    I    10_B      I      17          0.209
LGA    R    11_B      E      18          0.321
LGA    Y    12_B      Y      19          0.337
LGA    C    13_B      C      20          0.488
LGA    T    14_B      T      21          0.596
LGA    Q    15_B      Q      22          0.911
LGA    C    16_B      C      23          0.103
LGA    N    17_B      R      24          0.950
LGA    W    18_B      W      25          0.442
LGA    L    19_B      L      26          0.319
LGA    L    20_B      P      27          0.481
LGA    R    21_B      R      28          0.420
LGA    A    22_B      A      29          0.229
LGA    G    23_B      A      30          0.159
LGA    W    24_B      W      31          0.271
LGA    X    25_B      L      32          0.315
LGA    A    26_B      A      33          0.317
LGA    Q    27_B      Q      34          0.266
LGA    E    28_B      E      35          0.322
LGA    I    29_B      L      36          0.477
LGA    L    30_B      L      37          0.596
LGA    Q    31_B      T      38          0.532
LGA    T    32_B      T      39          0.628
LGA    F    33_B      F      40          0.870
LGA    A    34_B      E      41          0.966
LGA    S    35_B      T      42          1.469
LGA    D    36_B      E      43          0.759
LGA    I    37_B      L      44          0.445
LGA    G    38_B      T      45          0.969
LGA    E    39_B      E      46          0.657
LGA    V    40_B      L      47          0.527
LGA    S    41_B      A      48          0.226
LGA    L    42_B      L      49          0.311
LGA    I    43_B      K      50          0.359
LGA    P    44_B      P      51          0.532
LGA    S    45_B      G      52          0.793
LGA    T    46_B      T      53          1.021
LGA    G    47_B      G      54          1.253
LGA    G    48_B      G      55          1.014
LGA    L    49_B      V      56          0.742
LGA    F    50_B      F      57          0.506
LGA    E    51_B      V      58          0.588
LGA    I    52_B      V      59          0.490
LGA    T    53_B      R      60          0.333
LGA    V    54_B      V      61          0.207
LGA    D    55_B      D      62          0.618
LGA    G    56_B      D      63          0.858
LGA    T    57_B      E      64          0.742
LGA    I    58_B      V      65          0.685
LGA    I    59_B      V      66          0.660
LGA    W    60_B      W      67          0.476
LGA    E    61_B      D      68          0.489
LGA    R    62_B      R      69          0.803
LGA    K    63_B      R      70          0.941
LGA    R    64_B      E      71          1.491
LGA    D    65_B      Q      72          1.151
LGA    G    66_B      G      73          2.739
LGA    G    67_B      -       -           -
LGA    F    68_B      F      74          1.253
LGA    P    69_B      P      75          1.335
LGA    G    70_B      E      76          1.041
LGA    P    71_B      P      77          0.870
LGA    K    72_B      T      78          0.690
LGA    E    73_B      A      79          0.886
LGA    L    74_B      V      80          1.398
LGA    K    75_B      K      81          1.041
LGA    Q    76_B      R      82          0.625
LGA    R    77_B      L      83          0.679
LGA    I    78_B      V      84          0.576
LGA    R    79_B      R      85          0.465
LGA    D    80_B      D      86          0.859
LGA    L    81_B      R      87          1.241
LGA    I    82_B      V      88          0.950
LGA    D    83_B      -       -           -
LGA    P    84_B      -       -           -
LGA    E    85_B      -       -           -
LGA    R    86_B      -       -           -
LGA    D    87_B      -       -           -
LGA    L    88_B      -       -           -
LGA    G    89_B      -       -           -
LGA    H    90_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   87   77    5.0     77    0.83    46.75     98.473     8.240

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.404403 * X  +   0.914554 * Y  +  -0.007047 * Z  +  -4.562479
  Y_new =  -0.874977 * X  +  -0.384636 * Y  +   0.294058 * Z  + 124.390671
  Z_new =   0.266221 * X  +   0.125084 * Y  +   0.955762 * Z  + -63.907944 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.130134   -3.011459  [ DEG:     7.4561   -172.5439 ]
  Theta =  -0.269470   -2.872122  [ DEG:   -15.4395   -164.5605 ]
  Phi   =  -2.003738    1.137854  [ DEG:  -114.8057     65.1943 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fa8_B                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fa8_B.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   87   77   5.0   77   0.83   46.75  98.473
REMARK  ---------------------------------------------------------- 
MOLECULE 2fa8_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   07-DEC-05   2FA8              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE SELENOPROTEIN W-RELATED             
TITLE    2 FAMILY PROTEIN FROM AGROBACTERIUM TUMEFACIENS                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN ATU0228;                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 GENE: ATU0228;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPH-BETA STRUCTURE, 4 HELIX BUNDLE, STRUCTURAL GENOMICS,             
KEYWDS   2 PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, MCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,A.JOACHIMIAK,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   24-JAN-06 2FA8    0                                                
JRNL        AUTH   Y.KIM,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                    
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE SELENOPROTEIN              
JRNL        TITL 2 W-RELATED FAMILY PROTEIN FROM AGROBACTERIUM                  
JRNL        TITL 3 TUMEFACIENS                                                  
JRNL        REF    TO BE PUBLISHED                            2006              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2FA8 A    1   101  GB     17934144 NP_530934        1    101             
DBREF  2FA8 B    1   101  GB     17934144 NP_530934        1    101             
DBREF  2FA8 C    1   101  GB     17934144 NP_530934        1    101             
DBREF  2FA8 D    1   101  GB     17934144 NP_530934        1    101             
SEQRES   1 A  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 A  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 A  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 A  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 A  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 A  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 A  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 A  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 A  105  SER                                                          
SEQRES   1 B  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 B  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 B  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 B  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 B  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 B  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 B  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 B  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 B  105  SER                                                          
SEQRES   1 C  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 C  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 C  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 C  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 C  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 C  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 C  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 C  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 C  105  SER                                                          
SEQRES   1 D  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 D  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 D  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 D  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 D  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 D  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 D  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 D  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 D  105  SER                                                          
HET    MSE  A  25       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  C  25       8                                                       
HET    MSE  D  25       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   5  HOH   *198(H2 O)                                                    
CRYST1   53.078   69.306   95.578  90.00  90.00  90.00 P 21 21 21   16          
ATOM    697  N   THR B   4      37.791 107.506 -21.799  1.00 41.51           N  
ATOM    698  CA  THR B   4      36.682 108.513 -21.976  1.00 41.23           C  
ATOM    699  C   THR B   4      35.898 108.695 -20.669  1.00 39.80           C  
ATOM    700  O   THR B   4      35.461 107.704 -20.072  1.00 40.41           O  
ATOM    701  CB  THR B   4      35.744 108.159 -23.174  1.00 41.47           C  
ATOM    702  OG1 THR B   4      34.600 109.025 -23.177  1.00 42.48           O  
ATOM    703  CG2 THR B   4      35.257 106.719 -23.096  1.00 43.38           C  
ATOM    704  N   LYS B   5      35.766 109.951 -20.221  1.00 37.59           N  
ATOM    705  CA  LYS B   5      35.058 110.291 -18.980  1.00 35.44           C  
ATOM    706  C   LYS B   5      33.569 109.959 -19.074  1.00 34.01           C  
ATOM    707  O   LYS B   5      32.876 110.471 -19.945  1.00 32.97           O  
ATOM    708  CB  LYS B   5      35.211 111.770 -18.619  1.00 35.70           C  
ATOM    709  CG  LYS B   5      36.639 112.220 -18.322  1.00 35.20           C  
ATOM    710  CD  LYS B   5      36.643 113.704 -18.141  1.00 34.84           C  
ATOM    711  CE  LYS B   5      38.015 114.227 -17.751  1.00 38.58           C  
ATOM    712  NZ  LYS B   5      37.884 115.703 -17.586  1.00 39.30           N  
ATOM    713  N   PRO B   6      33.091 109.091 -18.172  1.00 32.57           N  
ATOM    714  CA  PRO B   6      31.717 108.600 -18.216  1.00 31.20           C  
ATOM    715  C   PRO B   6      30.685 109.646 -17.850  1.00 29.46           C  
ATOM    716  O   PRO B   6      30.965 110.537 -17.050  1.00 28.15           O  
ATOM    717  CB  PRO B   6      31.711 107.518 -17.144  1.00 31.07           C  
ATOM    718  CG  PRO B   6      32.783 107.940 -16.170  1.00 33.66           C  
ATOM    719  CD  PRO B   6      33.859 108.483 -17.068  1.00 33.12           C  
ATOM    720  N   ARG B   7      29.492 109.493 -18.426  1.00 27.98           N  
ATOM    721  CA  ARG B   7      28.295 110.203 -17.991  1.00 26.38           C  
ATOM    722  C   ARG B   7      27.566 109.341 -16.954  1.00 24.98           C  
ATOM    723  O   ARG B   7      27.239 108.177 -17.225  1.00 24.23           O  
ATOM    724  CB  ARG B   7      27.354 110.425 -19.171  1.00 26.40           C  
ATOM    725  CG  ARG B   7      27.874 111.384 -20.199  1.00 28.55           C  
ATOM    726  CD  ARG B   7      26.833 111.474 -21.322  1.00 33.66           C  
ATOM    727  NE  ARG B   7      27.412 112.000 -22.551  1.00 38.08           N  
ATOM    728  CZ  ARG B   7      27.456 113.292 -22.852  1.00 39.57           C  
ATOM    729  NH1 ARG B   7      26.938 114.181 -22.009  1.00 41.19           N  
ATOM    730  NH2 ARG B   7      28.006 113.687 -23.998  1.00 40.05           N  
ATOM    731  N   ILE B   8      27.286 109.893 -15.774  1.00 21.32           N  
ATOM    732  CA  ILE B   8      26.520 109.146 -14.799  1.00 20.89           C  
ATOM    733  C   ILE B   8      25.064 109.673 -14.766  1.00 20.92           C  
ATOM    734  O   ILE B   8      24.850 110.877 -14.835  1.00 21.62           O  
ATOM    735  CB  ILE B   8      27.248 109.178 -13.403  1.00 20.60           C  
ATOM    736  CG1 ILE B   8      28.553 108.359 -13.506  1.00 22.69           C  
ATOM    737  CG2 ILE B   8      26.358 108.591 -12.296  1.00 19.67           C  
ATOM    738  CD1 ILE B   8      29.475 108.480 -12.303  1.00 21.74           C  
ATOM    739  N   ALA B   9      24.066 108.794 -14.682  1.00 20.55           N  
ATOM    740  CA  ALA B   9      22.676 109.251 -14.564  1.00 19.93           C  
ATOM    741  C   ALA B   9      22.020 108.649 -13.336  1.00 18.78           C  
ATOM    742  O   ALA B   9      22.125 107.429 -13.085  1.00 20.14           O  
ATOM    743  CB  ALA B   9      21.892 108.895 -15.807  1.00 19.14           C  
ATOM    744  N   ILE B  10      21.340 109.485 -12.561  1.00 17.24           N  
ATOM    745  CA  ILE B  10      20.566 108.997 -11.431  1.00 17.35           C  
ATOM    746  C   ILE B  10      19.102 109.306 -11.737  1.00 18.27           C  
ATOM    747  O   ILE B  10      18.719 110.492 -11.771  1.00 17.15           O  
ATOM    748  CB  ILE B  10      20.976 109.665 -10.072  1.00 17.40           C  
ATOM    749  CG1 ILE B  10      22.483 109.480  -9.817  1.00 19.30           C  
ATOM    750  CG2 ILE B  10      20.120 109.089  -8.882  1.00 15.93           C  
ATOM    751  CD1 ILE B  10      23.057 110.361  -8.648  1.00 17.93           C  
ATOM    752  N   ARG B  11      18.326 108.253 -12.003  1.00 17.68           N  
ATOM    753  CA  ARG B  11      16.850 108.358 -12.180  1.00 18.47           C  
ATOM    754  C   ARG B  11      16.186 108.110 -10.844  1.00 17.11           C  
ATOM    755  O   ARG B  11      16.477 107.110 -10.192  1.00 16.87           O  
ATOM    756  CB  ARG B  11      16.383 107.324 -13.203  1.00 17.80           C  
ATOM    757  CG  ARG B  11      16.843 107.666 -14.604  1.00 20.17           C  
ATOM    758  CD  ARG B  11      16.484 106.577 -15.626  1.00 24.95           C  
ATOM    759  NE  ARG B  11      16.635 107.117 -16.982  1.00 27.74           N  
ATOM    760  CZ  ARG B  11      17.790 107.149 -17.636  1.00 30.29           C  
ATOM    761  NH1 ARG B  11      18.885 106.643 -17.067  1.00 30.11           N  
ATOM    762  NH2 ARG B  11      17.844 107.667 -18.869  1.00 30.29           N  
ATOM    763  N   TYR B  12      15.332 109.020 -10.391  1.00 16.54           N  
ATOM    764  CA  TYR B  12      14.791 108.929  -9.048  1.00 16.93           C  
ATOM    765  C   TYR B  12      13.303 109.343  -9.127  1.00 17.99           C  
ATOM    766  O   TYR B  12      12.935 110.253  -9.876  1.00 18.31           O  
ATOM    767  CB  TYR B  12      15.556 109.854  -8.042  1.00 17.32           C  
ATOM    768  CG  TYR B  12      15.296 111.319  -8.313  1.00 18.19           C  
ATOM    769  CD1 TYR B  12      14.274 112.001  -7.643  1.00 17.40           C  
ATOM    770  CD2 TYR B  12      15.999 112.001  -9.321  1.00 16.16           C  
ATOM    771  CE1 TYR B  12      13.956 113.312  -7.969  1.00 16.15           C  
ATOM    772  CE2 TYR B  12      15.704 113.344  -9.639  1.00 18.08           C  
ATOM    773  CZ  TYR B  12      14.688 113.973  -8.968  1.00 17.07           C  
ATOM    774  OH  TYR B  12      14.383 115.254  -9.290  1.00 19.86           O  
ATOM    775  N   CYS B  13      12.477 108.671  -8.356  1.00 18.92           N  
ATOM    776  CA  CYS B  13      11.045 108.969  -8.308  1.00 20.36           C  
ATOM    777  C   CYS B  13      10.744 110.301  -7.588  1.00 20.64           C  
ATOM    778  O   CYS B  13      11.066 110.481  -6.431  1.00 20.81           O  
ATOM    779  CB  CYS B  13      10.337 107.811  -7.636  1.00 20.49           C  
ATOM    780  SG  CYS B  13       8.570 108.053  -7.547  1.00 24.04           S  
ATOM    781  N   THR B  14      10.140 111.235  -8.300  1.00 22.00           N  
ATOM    782  CA  THR B  14       9.921 112.566  -7.772  1.00 24.65           C  
ATOM    783  C   THR B  14       8.953 112.509  -6.605  1.00 24.37           C  
ATOM    784  O   THR B  14       9.221 113.089  -5.535  1.00 24.11           O  
ATOM    785  CB  THR B  14       9.406 113.521  -8.870  1.00 25.92           C  
ATOM    786  OG1 THR B  14      10.438 113.692  -9.835  1.00 29.94           O  
ATOM    787  CG2 THR B  14       9.089 114.859  -8.307  1.00 28.75           C  
ATOM    788  N   GLN B  15       7.859 111.769  -6.788  1.00 23.30           N  
ATOM    789  CA  GLN B  15       6.783 111.788  -5.815  1.00 24.30           C  
ATOM    790  C   GLN B  15       7.057 110.924  -4.591  1.00 24.52           C  
ATOM    791  O   GLN B  15       6.384 111.047  -3.566  1.00 24.66           O  
ATOM    792  CB  GLN B  15       5.425 111.502  -6.478  1.00 24.64           C  
ATOM    793  CG  GLN B  15       5.025 112.626  -7.458  1.00 28.67           C  
ATOM    794  CD  GLN B  15       5.140 114.003  -6.813  1.00 35.20           C  
ATOM    795  OE1 GLN B  15       4.362 114.342  -5.936  1.00 35.63           O  
ATOM    796  NE2 GLN B  15       6.146 114.789  -7.232  1.00 36.49           N  
ATOM    797  N   CYS B  16       8.109 110.101  -4.683  1.00 23.85           N  
ATOM    798  CA  CYS B  16       8.551 109.303  -3.554  1.00 25.12           C  
ATOM    799  C   CYS B  16       9.422 110.096  -2.579  1.00 25.05           C  
ATOM    800  O   CYS B  16       9.865 109.546  -1.580  1.00 25.68           O  
ATOM    801  CB  CYS B  16       9.325 108.079  -4.056  1.00 23.48           C  
ATOM    802  SG  CYS B  16       8.292 106.866  -4.915  1.00 32.24           S  
ATOM    803  N   ASN B  17       9.680 111.363  -2.869  0.50 24.48           N  
ATOM    805  CA  ASN B  17      10.531 112.164  -1.988  0.50 25.06           C  
ATOM    807  C   ASN B  17      11.977 111.642  -2.044  0.50 23.84           C  
ATOM    809  O   ASN B  17      12.645 111.558  -1.019  0.50 24.00           O  
ATOM    811  CB  ASN B  17       9.998 112.097  -0.543  0.50 25.11           C  
ATOM    813  CG  ASN B  17      10.674 113.080   0.384  0.50 26.52           C  
ATOM    815  OD1 ASN B  17      11.092 114.164  -0.030  0.50 28.44           O  
ATOM    817  ND2 ASN B  17      10.762 112.715   1.670  0.50 27.80           N  
ATOM    819  N   TRP B  18      12.438 111.254  -3.233  1.00 23.33           N  
ATOM    820  CA  TRP B  18      13.805 110.711  -3.354  1.00 22.22           C  
ATOM    821  C   TRP B  18      14.796 111.714  -3.973  1.00 20.89           C  
ATOM    822  O   TRP B  18      15.934 111.359  -4.263  1.00 21.83           O  
ATOM    823  CB  TRP B  18      13.806 109.379  -4.118  1.00 21.44           C  
ATOM    824  CG  TRP B  18      13.067 108.224  -3.397  1.00 21.64           C  
ATOM    825  CD1 TRP B  18      12.703 108.168  -2.066  1.00 20.65           C  
ATOM    826  CD2 TRP B  18      12.645 106.989  -3.975  1.00 20.75           C  
ATOM    827  NE1 TRP B  18      12.073 106.979  -1.795  1.00 19.97           N  
ATOM    828  CE2 TRP B  18      12.015 106.235  -2.945  1.00 22.92           C  
ATOM    829  CE3 TRP B  18      12.735 106.438  -5.261  1.00 20.85           C  
ATOM    830  CZ2 TRP B  18      11.480 104.954  -3.162  1.00 21.87           C  
ATOM    831  CZ3 TRP B  18      12.181 105.163  -5.484  1.00 21.57           C  
ATOM    832  CH2 TRP B  18      11.552 104.438  -4.422  1.00 20.57           C  
ATOM    833  N   LEU B  19      14.371 112.963  -4.180  1.00 20.25           N  
ATOM    834  CA  LEU B  19      15.285 114.019  -4.682  1.00 18.81           C  
ATOM    835  C   LEU B  19      16.485 114.212  -3.756  1.00 18.79           C  
ATOM    836  O   LEU B  19      17.621 114.325  -4.209  1.00 16.80           O  
ATOM    837  CB  LEU B  19      14.556 115.384  -4.843  1.00 19.68           C  
ATOM    838  CG  LEU B  19      15.453 116.599  -5.150  1.00 19.02           C  
ATOM    839  CD1 LEU B  19      16.306 116.379  -6.328  1.00 15.05           C  
ATOM    840  CD2 LEU B  19      14.632 117.902  -5.340  1.00 18.70           C  
ATOM    841  N   LEU B  20      16.224 114.255  -2.455  1.00 19.27           N  
ATOM    842  CA  LEU B  20      17.247 114.579  -1.465  1.00 21.07           C  
ATOM    843  C   LEU B  20      18.412 113.556  -1.532  1.00 20.02           C  
ATOM    844  O   LEU B  20      19.601 113.929  -1.586  1.00 19.06           O  
ATOM    845  CB  LEU B  20      16.601 114.514  -0.078  1.00 21.01           C  
ATOM    846  CG  LEU B  20      16.669 115.691   0.875  1.00 27.43           C  
ATOM    847  CD1 LEU B  20      16.548 117.057   0.171  1.00 27.01           C  
ATOM    848  CD2 LEU B  20      15.588 115.510   1.974  1.00 23.90           C  
ATOM    849  N   ARG B  21      18.050 112.281  -1.548  1.00 19.23           N  
ATOM    850  CA  ARG B  21      19.036 111.206  -1.614  1.00 19.48           C  
ATOM    851  C   ARG B  21      19.750 111.123  -2.958  1.00 17.82           C  
ATOM    852  O   ARG B  21      20.929 110.780  -2.984  1.00 15.56           O  
ATOM    853  CB  ARG B  21      18.426 109.861  -1.192  1.00 19.10           C  
ATOM    854  CG  ARG B  21      17.585 109.124  -2.267  1.00 19.18           C  
ATOM    855  CD  ARG B  21      16.780 107.936  -1.678  1.00 23.08           C  
ATOM    856  NE  ARG B  21      15.864 108.298  -0.580  1.00 23.30           N  
ATOM    857  CZ  ARG B  21      15.167 107.425   0.143  1.00 25.34           C  
ATOM    858  NH1 ARG B  21      15.271 106.119  -0.075  1.00 21.87           N  
ATOM    859  NH2 ARG B  21      14.354 107.845   1.089  1.00 25.88           N  
ATOM    860  N   ALA B  22      19.028 111.412  -4.052  1.00 16.54           N  
ATOM    861  CA  ALA B  22      19.612 111.473  -5.389  1.00 17.72           C  
ATOM    862  C   ALA B  22      20.636 112.591  -5.453  1.00 16.97           C  
ATOM    863  O   ALA B  22      21.742 112.385  -5.939  1.00 17.23           O  
ATOM    864  CB  ALA B  22      18.532 111.707  -6.451  1.00 17.03           C  
ATOM    865  N   GLY B  23      20.256 113.773  -4.955  1.00 16.55           N  
ATOM    866  CA  GLY B  23      21.170 114.939  -4.925  1.00 17.25           C  
ATOM    867  C   GLY B  23      22.412 114.663  -4.070  1.00 17.41           C  
ATOM    868  O   GLY B  23      23.543 115.039  -4.438  1.00 16.78           O  
ATOM    869  N   TRP B  24      22.219 114.036  -2.911  1.00 16.56           N  
ATOM    870  CA  TRP B  24      23.339 113.660  -2.050  1.00 17.39           C  
ATOM    871  C   TRP B  24      24.312 112.703  -2.764  1.00 17.44           C  
ATOM    872  O   TRP B  24      25.530 112.896  -2.737  1.00 17.10           O  
ATOM    873  CB  TRP B  24      22.824 112.968  -0.786  1.00 18.44           C  
ATOM    874  CG  TRP B  24      23.895 112.216  -0.059  1.00 19.77           C  
ATOM    875  CD1 TRP B  24      25.080 112.712   0.421  1.00 21.54           C  
ATOM    876  CD2 TRP B  24      23.867 110.836   0.281  1.00 22.61           C  
ATOM    877  NE1 TRP B  24      25.799 111.708   1.036  1.00 22.50           N  
ATOM    878  CE2 TRP B  24      25.082 110.546   0.964  1.00 24.64           C  
ATOM    879  CE3 TRP B  24      22.938 109.800   0.069  1.00 23.44           C  
ATOM    880  CZ2 TRP B  24      25.386 109.258   1.440  1.00 23.52           C  
ATOM    881  CZ3 TRP B  24      23.249 108.513   0.519  1.00 22.59           C  
ATOM    882  CH2 TRP B  24      24.455 108.262   1.212  1.00 24.41           C  
HETATM  883  N   MSE B  25      23.773 111.701  -3.430  1.00 17.77           N  
HETATM  884  CA  MSE B  25      24.618 110.737  -4.133  1.00 20.84           C  
HETATM  885  C   MSE B  25      25.391 111.394  -5.254  1.00 18.36           C  
HETATM  886  O   MSE B  25      26.531 111.058  -5.453  1.00 17.33           O  
HETATM  887  CB  MSE B  25      23.786 109.594  -4.688  1.00 20.38           C  
HETATM  888  CG  MSE B  25      23.317 108.668  -3.572  1.00 23.61           C  
HETATM  889 SE   MSE B  25      22.183 107.272  -4.224  0.65 31.12          SE  
HETATM  890  CE  MSE B  25      21.240 106.917  -2.587  1.00 25.80           C  
ATOM    891  N   ALA B  26      24.737 112.284  -6.016  1.00 17.36           N  
ATOM    892  CA  ALA B  26      25.412 113.093  -7.026  1.00 17.30           C  
ATOM    893  C   ALA B  26      26.628 113.821  -6.459  1.00 17.26           C  
ATOM    894  O   ALA B  26      27.714 113.832  -7.083  1.00 17.25           O  
ATOM    895  CB  ALA B  26      24.454 114.080  -7.675  1.00 17.25           C  
ATOM    896  N   GLN B  27      26.438 114.436  -5.297  1.00 15.78           N  
ATOM    897  CA  GLN B  27      27.532 115.137  -4.610  1.00 17.34           C  
ATOM    898  C   GLN B  27      28.637 114.222  -4.100  1.00 16.38           C  
ATOM    899  O   GLN B  27      29.811 114.545  -4.257  1.00 15.89           O  
ATOM    900  CB  GLN B  27      26.972 116.029  -3.519  1.00 18.33           C  
ATOM    901  CG  GLN B  27      26.409 117.311  -4.199  1.00 21.57           C  
ATOM    902  CD  GLN B  27      25.663 118.149  -3.232  1.00 28.36           C  
ATOM    903  OE1 GLN B  27      26.138 119.207  -2.836  1.00 32.63           O  
ATOM    904  NE2 GLN B  27      24.480 117.694  -2.842  1.00 29.32           N  
ATOM    905  N   GLU B  28      28.270 113.072  -3.538  1.00 17.09           N  
ATOM    906  CA  GLU B  28      29.263 112.084  -3.132  1.00 17.59           C  
ATOM    907  C   GLU B  28      30.110 111.629  -4.317  1.00 18.64           C  
ATOM    908  O   GLU B  28      31.370 111.560  -4.232  1.00 18.91           O  
ATOM    909  CB  GLU B  28      28.580 110.867  -2.506  1.00 18.57           C  
ATOM    910  CG  GLU B  28      27.952 111.149  -1.154  1.00 19.38           C  
ATOM    911  CD  GLU B  28      28.979 111.275  -0.017  1.00 24.29           C  
ATOM    912  OE1 GLU B  28      30.203 111.129  -0.238  1.00 25.83           O  
ATOM    913  OE2 GLU B  28      28.552 111.550   1.104  1.00 25.67           O  
ATOM    914  N   ILE B  29      29.435 111.361  -5.436  1.00 17.68           N  
ATOM    915  CA  ILE B  29      30.118 110.973  -6.672  1.00 18.15           C  
ATOM    916  C   ILE B  29      31.072 112.059  -7.199  1.00 18.84           C  
ATOM    917  O   ILE B  29      32.271 111.805  -7.442  1.00 18.03           O  
ATOM    918  CB  ILE B  29      29.103 110.565  -7.783  1.00 18.37           C  
ATOM    919  CG1 ILE B  29      28.372 109.279  -7.387  1.00 18.56           C  
ATOM    920  CG2 ILE B  29      29.832 110.364  -9.117  1.00 18.04           C  
ATOM    921  CD1 ILE B  29      27.103 109.002  -8.275  1.00 20.22           C  
ATOM    922  N   LEU B  30      30.549 113.275  -7.354  1.00 17.36           N  
ATOM    923  CA  LEU B  30      31.389 114.366  -7.848  1.00 19.76           C  
ATOM    924  C   LEU B  30      32.548 114.780  -6.926  1.00 20.88           C  
ATOM    925  O   LEU B  30      33.604 115.249  -7.418  1.00 21.41           O  
ATOM    926  CB  LEU B  30      30.523 115.564  -8.211  1.00 17.46           C  
ATOM    927  CG  LEU B  30      29.615 115.300  -9.439  1.00 19.34           C  
ATOM    928  CD1 LEU B  30      28.477 116.291  -9.531  1.00 18.17           C  
ATOM    929  CD2 LEU B  30      30.411 115.297 -10.719  1.00 21.70           C  
ATOM    930  N   GLN B  31      32.335 114.651  -5.618  1.00 21.77           N  
ATOM    931  CA  GLN B  31      33.344 114.949  -4.631  1.00 25.27           C  
ATOM    932  C   GLN B  31      34.504 113.950  -4.792  1.00 25.87           C  
ATOM    933  O   GLN B  31      35.658 114.351  -4.850  1.00 26.08           O  
ATOM    934  CB  GLN B  31      32.771 114.897  -3.218  1.00 24.66           C  
ATOM    935  CG  GLN B  31      33.796 115.295  -2.119  1.00 30.04           C  
ATOM    936  CD  GLN B  31      33.251 115.120  -0.699  1.00 31.38           C  
ATOM    937  OE1 GLN B  31      32.500 115.963  -0.197  1.00 39.01           O  
ATOM    938  NE2 GLN B  31      33.615 114.010  -0.058  1.00 40.06           N  
ATOM    939  N   THR B  32      34.190 112.671  -4.927  1.00 24.36           N  
ATOM    940  CA  THR B  32      35.224 111.651  -5.076  1.00 26.70           C  
ATOM    941  C   THR B  32      35.920 111.659  -6.428  1.00 27.12           C  
ATOM    942  O   THR B  32      37.145 111.626  -6.490  1.00 28.50           O  
ATOM    943  CB  THR B  32      34.635 110.268  -4.797  1.00 26.42           C  
ATOM    944  OG1 THR B  32      34.103 110.280  -3.473  1.00 28.72           O  
ATOM    945  CG2 THR B  32      35.701 109.158  -4.883  1.00 28.51           C  
ATOM    946  N   PHE B  33      35.135 111.679  -7.497  1.00 26.76           N  
ATOM    947  CA  PHE B  33      35.642 111.544  -8.847  1.00 28.60           C  
ATOM    948  C   PHE B  33      35.579 112.861  -9.628  1.00 30.77           C  
ATOM    949  O   PHE B  33      35.387 112.833 -10.858  1.00 34.10           O  
ATOM    950  CB  PHE B  33      34.803 110.525  -9.614  1.00 26.62           C  
ATOM    951  CG  PHE B  33      34.738 109.147  -8.987  1.00 26.78           C  
ATOM    952  CD1 PHE B  33      35.763 108.213  -9.201  1.00 26.97           C  
ATOM    953  CD2 PHE B  33      33.633 108.767  -8.229  1.00 26.22           C  
ATOM    954  CE1 PHE B  33      35.704 106.926  -8.645  1.00 23.41           C  
ATOM    955  CE2 PHE B  33      33.541 107.474  -7.670  1.00 25.84           C  
ATOM    956  CZ  PHE B  33      34.593 106.544  -7.883  1.00 24.13           C  
ATOM    957  N   ALA B  34      35.657 114.000  -8.938  1.00 31.09           N  
ATOM    958  CA  ALA B  34      35.726 115.327  -9.586  1.00 33.25           C  
ATOM    959  C   ALA B  34      36.097 115.317 -11.085  1.00 34.37           C  
ATOM    960  O   ALA B  34      35.220 115.233 -11.952  1.00 36.30           O  
ATOM    961  CB  ALA B  34      36.692 116.236  -8.792  1.00 32.63           C  
ATOM    962  N   SER B  35      37.398 115.323 -11.382  1.00 35.46           N  
ATOM    963  CA  SER B  35      37.902 115.413 -12.765  1.00 36.49           C  
ATOM    964  C   SER B  35      37.415 114.281 -13.668  1.00 35.98           C  
ATOM    965  O   SER B  35      37.013 114.547 -14.833  1.00 37.31           O  
ATOM    966  CB  SER B  35      39.451 115.443 -12.813  1.00 36.80           C  
ATOM    967  OG  SER B  35      40.035 115.522 -11.520  1.00 39.71           O  
ATOM    968  N   ASP B  36      37.429 113.057 -13.125  1.00 33.48           N  
ATOM    969  CA  ASP B  36      37.250 111.804 -13.873  1.00 33.30           C  
ATOM    970  C   ASP B  36      35.870 111.522 -14.450  1.00 32.00           C  
ATOM    971  O   ASP B  36      35.710 110.576 -15.237  1.00 31.46           O  
ATOM    972  CB  ASP B  36      37.646 110.596 -13.003  1.00 33.90           C  
ATOM    973  CG  ASP B  36      38.922 110.823 -12.227  1.00 38.72           C  
ATOM    974  OD1 ASP B  36      39.884 111.342 -12.807  1.00 40.93           O  
ATOM    975  OD2 ASP B  36      38.958 110.486 -11.021  1.00 45.11           O  
ATOM    976  N   ILE B  37      34.888 112.322 -14.026  1.00 30.47           N  
ATOM    977  CA  ILE B  37      33.474 112.167 -14.391  1.00 29.14           C  
ATOM    978  C   ILE B  37      33.133 113.254 -15.400  1.00 27.32           C  
ATOM    979  O   ILE B  37      33.473 114.426 -15.179  1.00 27.54           O  
ATOM    980  CB  ILE B  37      32.549 112.306 -13.096  1.00 28.09           C  
ATOM    981  CG1 ILE B  37      32.795 111.153 -12.117  1.00 32.23           C  
ATOM    982  CG2 ILE B  37      31.074 112.292 -13.431  1.00 29.62           C  
ATOM    983  CD1 ILE B  37      32.970 109.768 -12.797  1.00 32.50           C  
ATOM    984  N   GLY B  38      32.451 112.893 -16.481  1.00 25.11           N  
ATOM    985  CA  GLY B  38      31.981 113.895 -17.452  1.00 24.25           C  
ATOM    986  C   GLY B  38      30.866 114.775 -16.881  1.00 23.70           C  
ATOM    987  O   GLY B  38      30.931 116.016 -16.949  1.00 22.84           O  
ATOM    988  N   GLU B  39      29.860 114.109 -16.303  1.00 23.28           N  
ATOM    989  CA  GLU B  39      28.697 114.748 -15.682  1.00 23.08           C  
ATOM    990  C   GLU B  39      27.942 113.723 -14.859  1.00 22.14           C  
ATOM    991  O   GLU B  39      28.089 112.484 -15.067  1.00 21.97           O  
ATOM    992  CB  GLU B  39      27.749 115.330 -16.754  1.00 24.02           C  
ATOM    993  CG  GLU B  39      27.130 114.274 -17.609  1.00 28.31           C  
ATOM    994  CD  GLU B  39      26.144 114.806 -18.595  1.00 33.98           C  
ATOM    995  OE1 GLU B  39      26.258 115.983 -19.000  1.00 38.40           O  
ATOM    996  OE2 GLU B  39      25.249 114.025 -18.980  1.00 40.07           O  
ATOM    997  N   VAL B  40      27.131 114.221 -13.922  1.00 21.45           N  
ATOM    998  CA  VAL B  40      26.152 113.401 -13.237  1.00 20.21           C  
ATOM    999  C   VAL B  40      24.834 114.123 -13.528  1.00 20.86           C  
ATOM   1000  O   VAL B  40      24.727 115.330 -13.266  1.00 20.43           O  
ATOM   1001  CB  VAL B  40      26.412 113.280 -11.686  1.00 20.42           C  
ATOM   1002  CG1 VAL B  40      25.338 112.448 -10.989  1.00 20.30           C  
ATOM   1003  CG2 VAL B  40      27.793 112.675 -11.399  1.00 19.14           C  
ATOM   1004  N   SER B  41      23.875 113.395 -14.094  1.00 19.99           N  
ATOM   1005  CA  SER B  41      22.555 113.956 -14.408  1.00 21.09           C  
ATOM   1006  C   SER B  41      21.559 113.407 -13.418  1.00 20.18           C  
ATOM   1007  O   SER B  41      21.576 112.199 -13.141  1.00 20.00           O  
ATOM   1008  CB  SER B  41      22.100 113.589 -15.814  1.00 21.14           C  
ATOM   1009  OG  SER B  41      23.028 114.134 -16.731  1.00 26.49           O  
ATOM   1010  N   LEU B  42      20.718 114.298 -12.888  1.00 18.88           N  
ATOM   1011  CA  LEU B  42      19.589 113.901 -12.039  1.00 18.25           C  
ATOM   1012  C   LEU B  42      18.334 113.965 -12.925  1.00 18.40           C  
ATOM   1013  O   LEU B  42      18.030 115.023 -13.527  1.00 17.37           O  
ATOM   1014  CB  LEU B  42      19.449 114.858 -10.863  1.00 19.35           C  
ATOM   1015  CG  LEU B  42      20.649 114.886  -9.911  1.00 19.56           C  
ATOM   1016  CD1 LEU B  42      20.621 116.158  -9.037  1.00 22.69           C  
ATOM   1017  CD2 LEU B  42      20.552 113.630  -9.053  1.00 21.13           C  
ATOM   1018  N   ILE B  43      17.637 112.837 -13.002  1.00 17.12           N  
ATOM   1019  CA  ILE B  43      16.556 112.635 -13.983  1.00 18.69           C  
ATOM   1020  C   ILE B  43      15.268 112.319 -13.244  1.00 18.33           C  
ATOM   1021  O   ILE B  43      15.056 111.202 -12.734  1.00 17.85           O  
ATOM   1022  CB  ILE B  43      16.848 111.535 -15.051  1.00 18.55           C  
ATOM   1023  CG1 ILE B  43      18.176 111.814 -15.798  1.00 18.92           C  
ATOM   1024  CG2 ILE B  43      15.590 111.329 -15.996  1.00 17.76           C  
ATOM   1025  CD1 ILE B  43      18.469 110.803 -16.939  1.00 20.29           C  
ATOM   1026  N   PRO B  44      14.414 113.332 -13.119  1.00 19.67           N  
ATOM   1027  CA  PRO B  44      13.173 113.056 -12.374  1.00 20.11           C  
ATOM   1028  C   PRO B  44      12.358 111.954 -13.070  1.00 20.67           C  
ATOM   1029  O   PRO B  44      12.221 111.959 -14.314  1.00 20.93           O  
ATOM   1030  CB  PRO B  44      12.439 114.403 -12.379  1.00 20.60           C  
ATOM   1031  CG  PRO B  44      13.291 115.373 -13.061  1.00 20.24           C  
ATOM   1032  CD  PRO B  44      14.542 114.734 -13.567  1.00 18.67           C  
ATOM   1033  N   SER B  45      11.851 111.009 -12.279  1.00 20.79           N  
ATOM   1034  CA  SER B  45      11.216 109.819 -12.821  1.00 22.47           C  
ATOM   1035  C   SER B  45       9.941 109.540 -12.002  1.00 22.84           C  
ATOM   1036  O   SER B  45       9.595 110.304 -11.082  1.00 22.60           O  
ATOM   1037  CB  SER B  45      12.184 108.620 -12.796  1.00 22.10           C  
ATOM   1038  OG  SER B  45      13.395 108.888 -13.528  1.00 22.65           O  
ATOM   1039  N   THR B  46       9.245 108.461 -12.332  1.00 23.63           N  
ATOM   1040  CA  THR B  46       7.982 108.141 -11.671  1.00 24.28           C  
ATOM   1041  C   THR B  46       7.952 106.668 -11.249  1.00 24.35           C  
ATOM   1042  O   THR B  46       8.862 105.881 -11.570  1.00 24.35           O  
ATOM   1043  CB  THR B  46       6.770 108.433 -12.592  1.00 25.23           C  
ATOM   1044  OG1 THR B  46       6.786 107.530 -13.714  1.00 26.20           O  
ATOM   1045  CG2 THR B  46       6.804 109.869 -13.095  1.00 26.44           C  
ATOM   1046  N   GLY B  47       6.908 106.299 -10.503  1.00 24.03           N  
ATOM   1047  CA  GLY B  47       6.614 104.896 -10.266  1.00 23.51           C  
ATOM   1048  C   GLY B  47       7.692 104.129  -9.533  1.00 23.59           C  
ATOM   1049  O   GLY B  47       7.974 102.970  -9.873  1.00 23.17           O  
ATOM   1050  N   GLY B  48       8.292 104.760  -8.521  1.00 21.96           N  
ATOM   1051  CA  GLY B  48       9.217 104.036  -7.633  1.00 21.51           C  
ATOM   1052  C   GLY B  48      10.577 103.714  -8.247  1.00 20.55           C  
ATOM   1053  O   GLY B  48      11.309 102.917  -7.715  1.00 21.54           O  
ATOM   1054  N   LEU B  49      10.892 104.301  -9.386  1.00 20.65           N  
ATOM   1055  CA  LEU B  49      12.209 104.076 -10.035  1.00 20.98           C  
ATOM   1056  C   LEU B  49      13.358 104.703  -9.201  1.00 20.35           C  
ATOM   1057  O   LEU B  49      13.304 105.885  -8.850  1.00 21.11           O  
ATOM   1058  CB  LEU B  49      12.195 104.650 -11.462  1.00 20.46           C  
ATOM   1059  CG  LEU B  49      13.469 104.399 -12.298  1.00 21.76           C  
ATOM   1060  CD1 LEU B  49      13.640 102.894 -12.475  1.00 21.09           C  
ATOM   1061  CD2 LEU B  49      13.395 105.102 -13.621  1.00 21.68           C  
ATOM   1062  N   PHE B  50      14.384 103.923  -8.865  1.00 19.89           N  
ATOM   1063  CA  PHE B  50      15.669 104.525  -8.472  1.00 20.42           C  
ATOM   1064  C   PHE B  50      16.750 103.716  -9.175  1.00 20.50           C  
ATOM   1065  O   PHE B  50      16.940 102.535  -8.871  1.00 20.91           O  
ATOM   1066  CB  PHE B  50      15.862 104.560  -6.930  1.00 20.39           C  
ATOM   1067  CG  PHE B  50      16.971 105.487  -6.481  1.00 21.76           C  
ATOM   1068  CD1 PHE B  50      16.689 106.836  -6.151  1.00 23.09           C  
ATOM   1069  CD2 PHE B  50      18.280 105.048  -6.421  1.00 21.76           C  
ATOM   1070  CE1 PHE B  50      17.715 107.721  -5.769  1.00 24.02           C  
ATOM   1071  CE2 PHE B  50      19.316 105.911  -6.026  1.00 23.66           C  
ATOM   1072  CZ  PHE B  50      19.034 107.261  -5.717  1.00 24.36           C  
ATOM   1073  N   GLU B  51      17.457 104.345 -10.101  1.00 19.42           N  
ATOM   1074  CA  GLU B  51      18.430 103.638 -10.896  1.00 19.93           C  
ATOM   1075  C   GLU B  51      19.627 104.515 -11.226  1.00 18.53           C  
ATOM   1076  O   GLU B  51      19.488 105.688 -11.613  1.00 18.31           O  
ATOM   1077  CB  GLU B  51      17.778 103.129 -12.185  1.00 20.08           C  
ATOM   1078  CG  GLU B  51      18.758 102.640 -13.234  1.00 24.04           C  
ATOM   1079  CD  GLU B  51      18.085 102.556 -14.588  1.00 30.57           C  
ATOM   1080  OE1 GLU B  51      18.296 103.468 -15.417  1.00 32.59           O  
ATOM   1081  OE2 GLU B  51      17.291 101.612 -14.778  1.00 34.10           O  
ATOM   1082  N   ILE B  52      20.809 103.941 -11.079  1.00 17.56           N  
ATOM   1083  CA  ILE B  52      22.017 104.674 -11.391  1.00 16.88           C  
ATOM   1084  C   ILE B  52      22.759 103.937 -12.487  1.00 17.54           C  
ATOM   1085  O   ILE B  52      22.977 102.720 -12.386  1.00 19.45           O  
ATOM   1086  CB  ILE B  52      22.924 104.833 -10.156  1.00 17.73           C  
ATOM   1087  CG1 ILE B  52      22.171 105.530  -9.007  1.00 16.74           C  
ATOM   1088  CG2 ILE B  52      24.213 105.564 -10.552  1.00 12.64           C  
ATOM   1089  CD1 ILE B  52      22.897 105.416  -7.671  1.00 21.55           C  
ATOM   1090  N   THR B  53      23.101 104.666 -13.527  1.00 18.63           N  
ATOM   1091  CA  THR B  53      23.825 104.128 -14.689  1.00 20.54           C  
ATOM   1092  C   THR B  53      25.125 104.895 -14.948  1.00 20.47           C  
ATOM   1093  O   THR B  53      25.229 106.110 -14.688  1.00 20.21           O  
ATOM   1094  CB  THR B  53      22.969 104.230 -15.977  1.00 20.51           C  
ATOM   1095  OG1 THR B  53      22.466 105.565 -16.103  1.00 25.59           O  
ATOM   1096  CG2 THR B  53      21.779 103.305 -15.940  1.00 20.90           C  
ATOM   1097  N   VAL B  54      26.123 104.179 -15.466  1.00 21.05           N  
ATOM   1098  CA  VAL B  54      27.383 104.774 -15.879  1.00 21.08           C  
ATOM   1099  C   VAL B  54      27.516 104.479 -17.385  1.00 22.92           C  
ATOM   1100  O   VAL B  54      27.630 103.293 -17.778  1.00 21.50           O  
ATOM   1101  CB  VAL B  54      28.584 104.146 -15.124  1.00 21.38           C  
ATOM   1102  CG1 VAL B  54      29.874 104.762 -15.619  1.00 20.32           C  
ATOM   1103  CG2 VAL B  54      28.468 104.336 -13.594  1.00 20.42           C  
ATOM   1104  N   ASP B  55      27.514 105.536 -18.193  1.00 23.52           N  
ATOM   1105  CA  ASP B  55      27.369 105.422 -19.657  1.00 27.10           C  
ATOM   1106  C   ASP B  55      26.360 104.361 -20.089  1.00 27.81           C  
ATOM   1107  O   ASP B  55      26.673 103.507 -20.952  1.00 28.52           O  
ATOM   1108  CB  ASP B  55      28.712 105.126 -20.321  1.00 27.15           C  
ATOM   1109  CG  ASP B  55      29.672 106.270 -20.195  1.00 29.46           C  
ATOM   1110  OD1 ASP B  55      29.254 107.431 -20.382  1.00 28.15           O  
ATOM   1111  OD2 ASP B  55      30.860 105.997 -19.902  1.00 36.40           O  
ATOM   1112  N   GLY B  56      25.177 104.398 -19.481  1.00 27.24           N  
ATOM   1113  CA  GLY B  56      24.112 103.457 -19.814  1.00 28.31           C  
ATOM   1114  C   GLY B  56      24.141 102.097 -19.154  1.00 27.44           C  
ATOM   1115  O   GLY B  56      23.165 101.364 -19.214  1.00 29.26           O  
ATOM   1116  N   THR B  57      25.251 101.746 -18.523  1.00 26.73           N  
ATOM   1117  CA  THR B  57      25.346 100.506 -17.795  1.00 26.51           C  
ATOM   1118  C   THR B  57      24.822 100.687 -16.377  1.00 26.00           C  
ATOM   1119  O   THR B  57      25.311 101.545 -15.640  1.00 23.76           O  
ATOM   1120  CB  THR B  57      26.805 100.002 -17.769  1.00 27.96           C  
ATOM   1121  OG1 THR B  57      27.239  99.806 -19.126  1.00 28.33           O  
ATOM   1122  CG2 THR B  57      26.911  98.726 -16.980  1.00 26.75           C  
ATOM   1123  N   ILE B  58      23.826  99.864 -16.023  1.00 25.35           N  
ATOM   1124  CA  ILE B  58      23.177  99.897 -14.697  1.00 25.62           C  
ATOM   1125  C   ILE B  58      24.108  99.388 -13.605  1.00 25.09           C  
ATOM   1126  O   ILE B  58      24.535  98.233 -13.643  1.00 24.51           O  
ATOM   1127  CB  ILE B  58      21.865  99.059 -14.677  1.00 25.17           C  
ATOM   1128  CG1 ILE B  58      20.821  99.663 -15.633  1.00 26.04           C  
ATOM   1129  CG2 ILE B  58      21.278  98.954 -13.244  1.00 27.22           C  
ATOM   1130  CD1 ILE B  58      19.636  98.723 -15.875  1.00 26.49           C  
ATOM   1131  N   ILE B  59      24.422 100.251 -12.637  1.00 23.37           N  
ATOM   1132  CA  ILE B  59      25.219  99.846 -11.462  1.00 23.43           C  
ATOM   1133  C   ILE B  59      24.400  99.765 -10.172  1.00 22.31           C  
ATOM   1134  O   ILE B  59      24.826  99.168  -9.183  1.00 22.02           O  
ATOM   1135  CB  ILE B  59      26.510 100.718 -11.262  1.00 23.11           C  
ATOM   1136  CG1 ILE B  59      26.140 102.155 -10.891  1.00 24.49           C  
ATOM   1137  CG2 ILE B  59      27.416 100.647 -12.514  1.00 24.34           C  
ATOM   1138  CD1 ILE B  59      27.225 102.937 -10.188  1.00 26.54           C  
ATOM   1139  N   TRP B  60      23.205 100.352 -10.179  1.00 21.41           N  
ATOM   1140  CA  TRP B  60      22.317 100.165  -9.049  1.00 22.24           C  
ATOM   1141  C   TRP B  60      20.913 100.283  -9.540  1.00 21.98           C  
ATOM   1142  O   TRP B  60      20.612 101.162 -10.336  1.00 21.44           O  
ATOM   1143  CB  TRP B  60      22.563 101.214  -7.938  1.00 21.91           C  
ATOM   1144  CG  TRP B  60      21.835 100.840  -6.686  1.00 21.84           C  
ATOM   1145  CD1 TRP B  60      20.520 101.113  -6.366  1.00 21.35           C  
ATOM   1146  CD2 TRP B  60      22.363 100.080  -5.607  1.00 21.68           C  
ATOM   1147  NE1 TRP B  60      20.216 100.569  -5.132  1.00 22.02           N  
ATOM   1148  CE2 TRP B  60      21.334  99.947  -4.640  1.00 23.05           C  
ATOM   1149  CE3 TRP B  60      23.623  99.509  -5.351  1.00 22.77           C  
ATOM   1150  CZ2 TRP B  60      21.520  99.248  -3.430  1.00 22.55           C  
ATOM   1151  CZ3 TRP B  60      23.813  98.817  -4.146  1.00 23.39           C  
ATOM   1152  CH2 TRP B  60      22.757  98.700  -3.196  1.00 23.69           C  
ATOM   1153  N   GLU B  61      20.046  99.423  -9.040  1.00 22.81           N  
ATOM   1154  CA  GLU B  61      18.612  99.597  -9.288  1.00 24.49           C  
ATOM   1155  C   GLU B  61      17.896  99.067  -8.075  1.00 25.26           C  
ATOM   1156  O   GLU B  61      18.230  97.967  -7.577  1.00 25.88           O  
ATOM   1157  CB  GLU B  61      18.165  98.938 -10.612  1.00 24.72           C  
ATOM   1158  CG  GLU B  61      16.664  99.159 -10.952  1.00 27.43           C  
ATOM   1159  CD  GLU B  61      15.743  98.253 -10.172  1.00 32.10           C  
ATOM   1160  OE1 GLU B  61      16.089  97.049 -10.025  1.00 33.33           O  
ATOM   1161  OE2 GLU B  61      14.679  98.728  -9.699  1.00 34.42           O  
ATOM   1162  N   ARG B  62      16.963  99.876  -7.563  1.00 24.99           N  
ATOM   1163  CA  ARG B  62      16.349  99.657  -6.248  1.00 26.68           C  
ATOM   1164  C   ARG B  62      15.860  98.208  -6.031  1.00 27.12           C  
ATOM   1165  O   ARG B  62      16.142  97.606  -5.006  1.00 26.07           O  
ATOM   1166  CB  ARG B  62      15.159 100.610  -6.058  1.00 26.88           C  
ATOM   1167  CG  ARG B  62      14.531 100.556  -4.664  1.00 26.93           C  
ATOM   1168  CD  ARG B  62      13.382 101.538  -4.555  1.00 30.03           C  
ATOM   1169  NE  ARG B  62      12.365 101.352  -5.586  1.00 30.07           N  
ATOM   1170  CZ  ARG B  62      11.299 100.558  -5.469  1.00 35.39           C  
ATOM   1171  NH1 ARG B  62      11.113  99.821  -4.373  1.00 34.73           N  
ATOM   1172  NH2 ARG B  62      10.429 100.476  -6.468  1.00 33.14           N  
ATOM   1173  N   LYS B  63      15.108  97.689  -6.991  1.00 28.69           N  
ATOM   1174  CA  LYS B  63      14.490  96.348  -6.849  1.00 30.99           C  
ATOM   1175  C   LYS B  63      15.567  95.248  -6.916  1.00 31.32           C  
ATOM   1176  O   LYS B  63      15.694  94.448  -5.988  1.00 33.19           O  
ATOM   1177  CB  LYS B  63      13.383  96.140  -7.895  1.00 30.76           C  
ATOM   1178  CG  LYS B  63      12.225  97.162  -7.817  1.00 32.18           C  
ATOM   1179  CD  LYS B  63      11.139  96.954  -8.898  1.00 32.24           C  
ATOM   1180  CE  LYS B  63      11.705  96.906 -10.344  1.00 36.44           C  
ATOM   1181  NZ  LYS B  63      12.164  98.223 -10.914  1.00 35.66           N  
ATOM   1182  N   ARG B  64      16.347  95.251  -8.000  1.00 31.78           N  
ATOM   1183  CA  ARG B  64      17.507  94.364  -8.216  1.00 31.61           C  
ATOM   1184  C   ARG B  64      18.434  94.306  -6.987  1.00 31.51           C  
ATOM   1185  O   ARG B  64      18.752  93.228  -6.481  1.00 30.81           O  
ATOM   1186  CB  ARG B  64      18.277  94.860  -9.455  1.00 31.47           C  
ATOM   1187  CG  ARG B  64      19.478  94.036  -9.919  1.00 33.34           C  
ATOM   1188  CD  ARG B  64      20.220  94.754 -11.097  1.00 34.36           C  
ATOM   1189  NE  ARG B  64      21.254  95.681 -10.600  1.00 35.34           N  
ATOM   1190  CZ  ARG B  64      22.353  96.044 -11.257  1.00 36.38           C  
ATOM   1191  NH1 ARG B  64      23.201  96.863 -10.676  1.00 32.54           N  
ATOM   1192  NH2 ARG B  64      22.634  95.561 -12.472  1.00 37.57           N  
ATOM   1193  N   ASP B  65      18.843  95.471  -6.493  1.00 30.20           N  
ATOM   1194  CA  ASP B  65      19.902  95.557  -5.486  1.00 29.90           C  
ATOM   1195  C   ASP B  65      19.392  95.690  -4.046  1.00 29.93           C  
ATOM   1196  O   ASP B  65      20.183  95.810  -3.102  1.00 29.91           O  
ATOM   1197  CB  ASP B  65      20.879  96.675  -5.874  1.00 29.14           C  
ATOM   1198  CG  ASP B  65      21.578  96.382  -7.182  1.00 30.75           C  
ATOM   1199  OD1 ASP B  65      22.319  95.382  -7.202  1.00 34.67           O  
ATOM   1200  OD2 ASP B  65      21.374  97.086  -8.205  1.00 23.66           O  
ATOM   1201  N   GLY B  66      18.073  95.678  -3.890  1.00 29.34           N  
ATOM   1202  CA  GLY B  66      17.448  95.606  -2.565  1.00 29.88           C  
ATOM   1203  C   GLY B  66      17.386  96.876  -1.730  1.00 29.69           C  
ATOM   1204  O   GLY B  66      17.425  96.806  -0.499  1.00 30.58           O  
ATOM   1205  N   GLY B  67      17.260  98.041  -2.363  1.00 28.01           N  
ATOM   1206  CA  GLY B  67      17.200  99.274  -1.606  1.00 27.25           C  
ATOM   1207  C   GLY B  67      18.036 100.372  -2.233  1.00 25.74           C  
ATOM   1208  O   GLY B  67      18.060 100.534  -3.448  1.00 24.97           O  
ATOM   1209  N   PHE B  68      18.720 101.118  -1.375  1.00 24.60           N  
ATOM   1210  CA  PHE B  68      19.525 102.260  -1.783  1.00 23.82           C  
ATOM   1211  C   PHE B  68      20.967 102.042  -1.385  1.00 23.83           C  
ATOM   1212  O   PHE B  68      21.207 101.428  -0.350  1.00 22.81           O  
ATOM   1213  CB  PHE B  68      18.926 103.529  -1.199  1.00 23.39           C  
ATOM   1214  CG  PHE B  68      17.511 103.741  -1.637  1.00 23.95           C  
ATOM   1215  CD1 PHE B  68      17.242 104.517  -2.754  1.00 24.20           C  
ATOM   1216  CD2 PHE B  68      16.456 103.100  -0.988  1.00 24.73           C  
ATOM   1217  CE1 PHE B  68      15.954 104.696  -3.185  1.00 24.01           C  
ATOM   1218  CE2 PHE B  68      15.139 103.270  -1.429  1.00 25.34           C  
ATOM   1219  CZ  PHE B  68      14.903 104.082  -2.524  1.00 25.70           C  
ATOM   1220  N   PRO B  69      21.919 102.513  -2.230  1.00 23.92           N  
ATOM   1221  CA  PRO B  69      23.332 102.259  -1.949  1.00 24.20           C  
ATOM   1222  C   PRO B  69      23.883 103.160  -0.853  1.00 23.89           C  
ATOM   1223  O   PRO B  69      23.441 104.303  -0.693  1.00 24.61           O  
ATOM   1224  CB  PRO B  69      24.020 102.565  -3.282  1.00 23.41           C  
ATOM   1225  CG  PRO B  69      23.196 103.648  -3.885  1.00 24.06           C  
ATOM   1226  CD  PRO B  69      21.746 103.275  -3.483  1.00 24.30           C  
ATOM   1227  N   GLY B  70      24.816 102.603  -0.086  1.00 24.78           N  
ATOM   1228  CA  GLY B  70      25.665 103.380   0.799  1.00 25.03           C  
ATOM   1229  C   GLY B  70      26.733 104.046  -0.047  1.00 24.82           C  
ATOM   1230  O   GLY B  70      26.971 103.641  -1.183  1.00 24.19           O  
ATOM   1231  N   PRO B  71      27.386 105.079   0.499  1.00 26.21           N  
ATOM   1232  CA  PRO B  71      28.351 105.819  -0.296  1.00 26.24           C  
ATOM   1233  C   PRO B  71      29.587 104.991  -0.649  1.00 26.17           C  
ATOM   1234  O   PRO B  71      30.141 105.171  -1.723  1.00 25.82           O  
ATOM   1235  CB  PRO B  71      28.707 107.024   0.597  1.00 27.12           C  
ATOM   1236  CG  PRO B  71      28.418 106.548   1.974  1.00 27.01           C  
ATOM   1237  CD  PRO B  71      27.247 105.617   1.867  1.00 26.00           C  
ATOM   1238  N   LYS B  72      29.995 104.063   0.221  1.00 26.64           N  
ATOM   1239  CA  LYS B  72      31.166 103.233  -0.093  1.00 27.06           C  
ATOM   1240  C   LYS B  72      30.870 102.366  -1.315  1.00 26.16           C  
ATOM   1241  O   LYS B  72      31.616 102.392  -2.300  1.00 25.03           O  
ATOM   1242  CB  LYS B  72      31.571 102.344   1.092  1.00 26.96           C  
ATOM   1243  CG  LYS B  72      32.793 101.451   0.820  1.00 28.38           C  
ATOM   1244  CD  LYS B  72      33.088 100.580   2.038  1.00 30.53           C  
ATOM   1245  CE  LYS B  72      34.279  99.641   1.808  1.00 36.74           C  
ATOM   1246  NZ  LYS B  72      34.431  98.715   2.985  1.00 39.85           N  
ATOM   1247  N   GLU B  73      29.777 101.613  -1.249  1.00 26.76           N  
ATOM   1248  CA  GLU B  73      29.448 100.695  -2.333  1.00 27.13           C  
ATOM   1249  C   GLU B  73      29.192 101.448  -3.623  1.00 26.33           C  
ATOM   1250  O   GLU B  73      29.631 101.013  -4.690  1.00 25.55           O  
ATOM   1251  CB  GLU B  73      28.306  99.754  -1.968  1.00 28.21           C  
ATOM   1252  CG  GLU B  73      27.062 100.442  -1.490  1.00 32.65           C  
ATOM   1253  CD  GLU B  73      26.072  99.487  -0.887  1.00 37.78           C  
ATOM   1254  OE1 GLU B  73      25.335  99.908   0.040  1.00 37.24           O  
ATOM   1255  OE2 GLU B  73      26.046  98.309  -1.344  1.00 41.00           O  
ATOM   1256  N   LEU B  74      28.529 102.603  -3.532  1.00 26.03           N  
ATOM   1257  CA  LEU B  74      28.336 103.454  -4.723  1.00 25.66           C  
ATOM   1258  C   LEU B  74      29.684 103.811  -5.390  1.00 24.12           C  
ATOM   1259  O   LEU B  74      29.879 103.613  -6.598  1.00 23.69           O  
ATOM   1260  CB  LEU B  74      27.583 104.736  -4.345  1.00 25.73           C  
ATOM   1261  CG  LEU B  74      27.241 105.694  -5.486  1.00 27.36           C  
ATOM   1262  CD1 LEU B  74      26.449 104.976  -6.582  1.00 29.04           C  
ATOM   1263  CD2 LEU B  74      26.523 106.916  -4.942  1.00 26.89           C  
ATOM   1264  N   LYS B  75      30.599 104.358  -4.599  1.00 23.49           N  
ATOM   1265  CA  LYS B  75      31.901 104.778  -5.111  1.00 23.93           C  
ATOM   1266  C   LYS B  75      32.659 103.591  -5.695  1.00 23.41           C  
ATOM   1267  O   LYS B  75      33.212 103.697  -6.779  1.00 22.74           O  
ATOM   1268  CB  LYS B  75      32.725 105.441  -4.006  1.00 24.59           C  
ATOM   1269  CG  LYS B  75      32.215 106.847  -3.595  1.00 24.44           C  
ATOM   1270  CD  LYS B  75      32.976 107.347  -2.329  1.00 26.82           C  
ATOM   1271  CE  LYS B  75      32.117 108.377  -1.528  1.00 31.24           C  
ATOM   1272  NZ  LYS B  75      32.830 108.701  -0.236  1.00 33.46           N  
ATOM   1273  N   GLN B  76      32.651 102.452  -4.997  1.00 23.76           N  
ATOM   1274  CA  GLN B  76      33.388 101.279  -5.502  1.00 24.96           C  
ATOM   1275  C   GLN B  76      32.805 100.735  -6.804  1.00 24.69           C  
ATOM   1276  O   GLN B  76      33.564 100.364  -7.732  1.00 24.81           O  
ATOM   1277  CB  GLN B  76      33.462 100.183  -4.431  1.00 24.99           C  
ATOM   1278  CG  GLN B  76      34.285 100.603  -3.182  1.00 26.10           C  
ATOM   1279  CD  GLN B  76      34.468  99.453  -2.160  1.00 28.50           C  
ATOM   1280  OE1 GLN B  76      33.577  98.629  -1.976  1.00 33.98           O  
ATOM   1281  NE2 GLN B  76      35.611  99.428  -1.485  1.00 29.31           N  
ATOM   1282  N   ARG B  77      31.468 100.739  -6.915  1.00 24.40           N  
ATOM   1283  CA  ARG B  77      30.848 100.278  -8.158  1.00 24.62           C  
ATOM   1284  C   ARG B  77      31.250 101.141  -9.335  1.00 24.84           C  
ATOM   1285  O   ARG B  77      31.535 100.636 -10.423  1.00 25.09           O  
ATOM   1286  CB  ARG B  77      29.329 100.154  -8.029  1.00 24.37           C  
ATOM   1287  CG  ARG B  77      28.906  99.009  -7.131  1.00 26.01           C  
ATOM   1288  CD  ARG B  77      27.421  98.761  -7.204  1.00 28.34           C  
ATOM   1289  NE  ARG B  77      27.064  97.669  -6.300  1.00 30.21           N  
ATOM   1290  CZ  ARG B  77      26.031  96.847  -6.454  1.00 31.36           C  
ATOM   1291  NH1 ARG B  77      25.199  96.978  -7.477  1.00 31.92           N  
ATOM   1292  NH2 ARG B  77      25.838  95.882  -5.568  1.00 29.78           N  
ATOM   1293  N   ILE B  78      31.287 102.455  -9.121  1.00 24.36           N  
ATOM   1294  CA  ILE B  78      31.680 103.359 -10.187  1.00 24.69           C  
ATOM   1295  C   ILE B  78      33.144 103.154 -10.536  1.00 26.01           C  
ATOM   1296  O   ILE B  78      33.497 103.038 -11.724  1.00 25.17           O  
ATOM   1297  CB  ILE B  78      31.427 104.823  -9.798  1.00 24.38           C  
ATOM   1298  CG1 ILE B  78      29.916 105.078  -9.814  1.00 21.86           C  
ATOM   1299  CG2 ILE B  78      32.125 105.759 -10.756  1.00 24.02           C  
ATOM   1300  CD1 ILE B  78      29.485 106.252  -8.945  1.00 23.68           C  
ATOM   1301  N   ARG B  79      33.982 103.112  -9.501  1.00 26.83           N  
ATOM   1302  CA  ARG B  79      35.416 102.883  -9.703  1.00 28.57           C  
ATOM   1303  C   ARG B  79      35.621 101.581 -10.498  1.00 29.64           C  
ATOM   1304  O   ARG B  79      36.382 101.569 -11.460  1.00 29.57           O  
ATOM   1305  CB  ARG B  79      36.156 102.861  -8.364  1.00 28.28           C  
ATOM   1306  CG  ARG B  79      37.694 102.657  -8.485  1.00 28.76           C  
ATOM   1307  CD  ARG B  79      38.059 101.136  -8.532  1.00 29.43           C  
ATOM   1308  NE  ARG B  79      37.391 100.418  -7.453  1.00 28.03           N  
ATOM   1309  CZ  ARG B  79      37.772 100.453  -6.189  1.00 28.39           C  
ATOM   1310  NH1 ARG B  79      38.837 101.168  -5.838  1.00 32.22           N  
ATOM   1311  NH2 ARG B  79      37.082  99.788  -5.278  1.00 28.13           N  
ATOM   1312  N   ASP B  80      34.907 100.515 -10.116  1.00 31.82           N  
ATOM   1313  CA  ASP B  80      35.109  99.196 -10.749  1.00 33.48           C  
ATOM   1314  C   ASP B  80      34.800  99.257 -12.219  1.00 34.94           C  
ATOM   1315  O   ASP B  80      35.496  98.652 -13.033  1.00 35.42           O  
ATOM   1316  CB  ASP B  80      34.314  98.091 -10.057  1.00 33.44           C  
ATOM   1317  CG  ASP B  80      34.884  97.738  -8.700  1.00 33.73           C  
ATOM   1318  OD1 ASP B  80      36.061  98.087  -8.455  1.00 35.43           O  
ATOM   1319  OD2 ASP B  80      34.174  97.118  -7.875  1.00 35.41           O  
ATOM   1320  N   LEU B  81      33.760 100.006 -12.564  1.00 35.95           N  
ATOM   1321  CA  LEU B  81      33.400 100.158 -13.951  1.00 37.24           C  
ATOM   1322  C   LEU B  81      34.380 101.033 -14.725  1.00 37.64           C  
ATOM   1323  O   LEU B  81      34.594 100.777 -15.906  1.00 38.42           O  
ATOM   1324  CB  LEU B  81      31.955 100.631 -14.094  1.00 37.07           C  
ATOM   1325  CG  LEU B  81      31.202 100.352 -15.395  1.00 38.33           C  
ATOM   1326  CD1 LEU B  81      31.412  98.945 -15.930  1.00 38.05           C  
ATOM   1327  CD2 LEU B  81      29.743 100.589 -15.141  1.00 37.46           C  
ATOM   1328  N   ILE B  82      34.975 102.050 -14.093  1.00 38.09           N  
ATOM   1329  CA  ILE B  82      35.895 102.935 -14.843  1.00 38.92           C  
ATOM   1330  C   ILE B  82      37.369 102.505 -14.835  1.00 39.16           C  
ATOM   1331  O   ILE B  82      38.002 102.489 -15.885  1.00 39.40           O  
ATOM   1332  CB  ILE B  82      35.710 104.457 -14.566  1.00 38.84           C  
ATOM   1333  CG1 ILE B  82      36.081 104.850 -13.135  1.00 40.84           C  
ATOM   1334  CG2 ILE B  82      34.258 104.882 -14.872  1.00 39.26           C  
ATOM   1335  CD1 ILE B  82      35.581 106.291 -12.739  1.00 39.48           C  
ATOM   1336  N   ASP B  83      37.918 102.154 -13.673  1.00 38.57           N  
ATOM   1337  CA  ASP B  83      39.214 101.462 -13.658  1.00 38.26           C  
ATOM   1338  C   ASP B  83      39.376 100.718 -12.358  1.00 36.71           C  
ATOM   1339  O   ASP B  83      39.736 101.311 -11.356  1.00 35.47           O  
ATOM   1340  CB  ASP B  83      40.403 102.409 -13.922  1.00 39.16           C  
ATOM   1341  CG  ASP B  83      41.733 101.661 -14.040  1.00 41.68           C  
ATOM   1342  OD1 ASP B  83      41.727 100.403 -14.195  1.00 42.90           O  
ATOM   1343  OD2 ASP B  83      42.791 102.337 -13.965  1.00 46.51           O  
ATOM   1344  N   PRO B  84      39.102  99.403 -12.378  1.00 36.54           N  
ATOM   1345  CA  PRO B  84      39.167  98.591 -11.157  1.00 37.20           C  
ATOM   1346  C   PRO B  84      40.549  98.609 -10.467  1.00 37.40           C  
ATOM   1347  O   PRO B  84      40.638  98.259  -9.294  1.00 36.64           O  
ATOM   1348  CB  PRO B  84      38.773  97.181 -11.641  1.00 36.93           C  
ATOM   1349  CG  PRO B  84      38.955  97.214 -13.116  1.00 37.29           C  
ATOM   1350  CD  PRO B  84      38.713  98.605 -13.553  1.00 36.63           C  
ATOM   1351  N   GLU B  85      41.589  99.032 -11.187  0.50 37.70           N  
ATOM   1353  CA  GLU B  85      42.940  99.110 -10.628  0.50 38.27           C  
ATOM   1355  C   GLU B  85      43.213 100.439  -9.927  0.50 39.26           C  
ATOM   1357  O   GLU B  85      44.254 100.601  -9.286  0.50 38.97           O  
ATOM   1359  CB  GLU B  85      43.996  98.867 -11.706  0.50 38.16           C  
ATOM   1361  CG  GLU B  85      43.975  97.472 -12.302  0.50 36.93           C  
ATOM   1363  CD  GLU B  85      45.204  97.173 -13.138  0.50 36.05           C  
ATOM   1365  OE1 GLU B  85      46.282  97.698 -12.821  0.50 35.73           O  
ATOM   1367  OE2 GLU B  85      45.096  96.403 -14.105  0.50 35.42           O  
ATOM   1369  N   ARG B  86      42.281 101.385 -10.050  1.00 39.94           N  
ATOM   1370  CA  ARG B  86      42.406 102.676  -9.373  1.00 42.07           C  
ATOM   1371  C   ARG B  86      42.096 102.531  -7.888  1.00 42.72           C  
ATOM   1372  O   ARG B  86      41.012 102.087  -7.532  1.00 43.18           O  
ATOM   1373  CB  ARG B  86      41.494 103.732 -10.022  1.00 42.28           C  
ATOM   1374  CG  ARG B  86      41.371 105.024  -9.207  1.00 44.19           C  
ATOM   1375  CD  ARG B  86      39.987 105.624  -9.320  1.00 46.69           C  
ATOM   1376  NE  ARG B  86      39.893 106.891  -8.593  1.00 49.47           N  
ATOM   1377  CZ  ARG B  86      39.783 108.084  -9.174  1.00 50.22           C  
ATOM   1378  NH1 ARG B  86      39.747 108.175 -10.499  1.00 49.72           N  
ATOM   1379  NH2 ARG B  86      39.711 109.186  -8.432  1.00 50.20           N  
ATOM   1380  N   ASP B  87      43.051 102.889  -7.031  1.00 44.19           N  
ATOM   1381  CA  ASP B  87      42.858 102.834  -5.582  1.00 45.83           C  
ATOM   1382  C   ASP B  87      42.093 104.065  -5.095  1.00 46.56           C  
ATOM   1383  O   ASP B  87      42.283 105.157  -5.628  1.00 47.04           O  
ATOM   1384  CB  ASP B  87      44.204 102.726  -4.862  1.00 46.29           C  
ATOM   1385  CG  ASP B  87      44.048 102.469  -3.378  1.00 49.00           C  
ATOM   1386  OD1 ASP B  87      43.698 103.403  -2.631  1.00 50.95           O  
ATOM   1387  OD2 ASP B  87      44.278 101.323  -2.950  1.00 53.34           O  
ATOM   1388  N   LEU B  88      41.234 103.888  -4.090  1.00 46.91           N  
ATOM   1389  CA  LEU B  88      40.421 104.989  -3.575  1.00 47.58           C  
ATOM   1390  C   LEU B  88      40.793 105.403  -2.143  1.00 48.35           C  
ATOM   1391  O   LEU B  88      40.101 106.227  -1.539  1.00 47.78           O  
ATOM   1392  CB  LEU B  88      38.915 104.649  -3.645  1.00 47.37           C  
ATOM   1393  CG  LEU B  88      38.130 104.524  -4.960  1.00 46.65           C  
ATOM   1394  CD1 LEU B  88      36.652 104.259  -4.650  1.00 44.69           C  
ATOM   1395  CD2 LEU B  88      38.282 105.745  -5.886  1.00 45.84           C  
ATOM   1396  N   GLY B  89      41.886 104.844  -1.612  1.00 49.44           N  
ATOM   1397  CA  GLY B  89      42.324 105.113  -0.230  1.00 50.81           C  
ATOM   1398  C   GLY B  89      41.241 104.743   0.761  1.00 51.74           C  
ATOM   1399  O   GLY B  89      41.019 103.565   1.028  1.00 51.69           O  
ATOM   1400  N   HIS B  90      40.595 105.771   1.317  1.00 53.22           N  
ATOM   1401  CA  HIS B  90      39.226 105.715   1.914  1.00 54.21           C  
ATOM   1402  C   HIS B  90      38.990 104.861   3.175  1.00 54.35           C  
ATOM   1403  O   HIS B  90      39.342 103.686   3.240  1.00 54.68           O  
ATOM   1404  CB  HIS B  90      38.148 105.442   0.832  1.00 54.46           C  
ATOM   1405  CG  HIS B  90      37.682 104.020   0.765  1.00 55.66           C  
ATOM   1406  ND1 HIS B  90      36.373 103.660   0.995  1.00 56.86           N  
ATOM   1407  CD2 HIS B  90      38.348 102.871   0.497  1.00 56.36           C  
ATOM   1408  CE1 HIS B  90      36.254 102.348   0.883  1.00 57.16           C  
ATOM   1409  NE2 HIS B  90      37.437 101.845   0.581  1.00 58.39           N  
TER    1410      HIS B  90                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
