
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  748),  selected  103 , name 2o7k_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2o7k_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      -       -           -
LGA    I     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    K     5_A      -       -           -
LGA    V     6_A      -       -           -
LGA    T     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    D    10_A      -       -           -
LGA    F    11_A      -       -           -
LGA    D    12_A      -       -           -
LGA    S    13_A      -       -           -
LGA    K    14_A      -       -           -
LGA    V    15_A      -       -           -
LGA    E    16_A      -       -           -
LGA    S    17_A      -       -           -
LGA    G    18_A      T      12          3.304
LGA    V    19_A      H      13          1.936
LGA    Q    20_A      R      14          1.500
LGA    L    21_A      V      15          1.335
LGA    V    22_A      Q      16          0.522
LGA    D    23_A      I      17          0.954
LGA    F    24_A      E      18          1.207
LGA    W    25_A      Y      19          2.347
LGA    A    26_A      C      20          4.236
LGA    T    27_A      T      21          3.113
LGA    W    28_A      Q      22          1.798
LGA    C    29_A      C      23          2.300
LGA    G    30_A      R      24          3.489
LGA    P    31_A      W      25          4.208
LGA    C    32_A      L      26          4.538
LGA    K    33_A      P      27          2.929
LGA    M    34_A      R      28          2.619
LGA    I    35_A      A      29          3.859
LGA    A    36_A      A      30          2.429
LGA    P    37_A      W      31          1.264
LGA    V    38_A      L      32          2.637
LGA    L    39_A      A      33          2.021
LGA    E    40_A      Q      34          1.114
LGA    E    41_A      E      35          2.341
LGA    L    42_A      L      36          1.828
LGA    A    43_A      L      37          0.815
LGA    A    44_A      T      38          1.499
LGA    D    45_A      T      39          1.538
LGA    Y    46_A      F      40          1.151
LGA    E    47_A      E      41          0.943
LGA    G    48_A      T      42          1.904
LGA    K    49_A      E      43          0.731
LGA    A    50_A      L      44          1.702
LGA    -       -      T      45           -
LGA    D    51_A      E      46          2.677
LGA    I    52_A      L      47          1.424
LGA    L    53_A      A      48          0.951
LGA    K    54_A      L      49          1.014
LGA    L    55_A      K      50          1.542
LGA    D    56_A      P      51          2.069
LGA    V    57_A      G      52          3.353
LGA    D    58_A      T      53           #
LGA    E    59_A      -       -           -
LGA    N    60_A      -       -           -
LGA    P    61_A      -       -           -
LGA    S    62_A      -       -           -
LGA    T    63_A      -       -           -
LGA    A    64_A      -       -           -
LGA    A    65_A      -       -           -
LGA    K    66_A      -       -           -
LGA    Y    67_A      -       -           -
LGA    E    68_A      -       -           -
LGA    V    69_A      -       -           -
LGA    M    70_A      -       -           -
LGA    S    71_A      G      54          5.202
LGA    -       -      G      55           -
LGA    I    72_A      V      56          1.028
LGA    P    73_A      F      57          1.115
LGA    T    74_A      V      58          1.445
LGA    L    75_A      V      59          1.451
LGA    I    76_A      R      60          1.316
LGA    V    77_A      V      61          1.294
LGA    F    78_A      D      62          0.872
LGA    K    79_A      -       -           -
LGA    D    80_A      -       -           -
LGA    G    81_A      -       -           -
LGA    Q    82_A      -       -           -
LGA    P    83_A      D      63          2.428
LGA    V    84_A      E      64          2.757
LGA    D    85_A      V      65          3.054
LGA    K    86_A      V      66          3.035
LGA    V    87_A      W      67          1.043
LGA    V    88_A      D      68          1.532
LGA    G    89_A      R      69          2.115
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    F    90_A      F      74          2.539
LGA    Q    91_A      P      75          0.499
LGA    P    92_A      E      76          1.379
LGA    K    93_A      P      77          1.227
LGA    E    94_A      T      78          0.652
LGA    N    95_A      A      79          1.522
LGA    L    96_A      V      80          1.747
LGA    A    97_A      K      81          1.077
LGA    E    98_A      R      82          0.753
LGA    V    99_A      L      83          1.327
LGA    L   100_A      V      84          1.296
LGA    D   101_A      R      85          0.998
LGA    K   102_A      D      86          0.775
LGA    H   103_A      R      87          1.124
LGA    L   104_A      V      88          0.914

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103   77    5.0     70    2.13    11.43     71.212     3.135

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.619488 * X  +   0.148603 * Y  +   0.770812 * Z  +  20.393785
  Y_new =  -0.764033 * X  +  -0.339594 * Y  +  -0.548570 * Z  + 129.754959
  Z_new =   0.180244 * X  +  -0.928759 * Y  +   0.323912 * Z  +  -8.000564 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.235228    1.906364  [ DEG:   -70.7734    109.2266 ]
  Theta =  -0.181235   -2.960358  [ DEG:   -10.3840   -169.6160 ]
  Phi   =  -2.252096    0.889497  [ DEG:  -129.0356     50.9644 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o7k_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o7k_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103   77   5.0   70   2.13   11.43  71.212
REMARK  ---------------------------------------------------------- 
MOLECULE 2o7k_A
HEADER    ELECTRON TRANSPORT                      11-DEC-06   2O7K              
TITLE     S. AUREUS THIOREDOXIN                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: TRX;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: TRXA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-14B                                   
KEYWDS    THIOREDOXIN, REDOX ENZYMOLOGY, OXIDOREDUCTASE                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    G.ROOS,A.GARCIA-PINO,K.VAN BELLE,E.BROSENS,K.WAHNI,                   
AUTHOR   2 G.VANDENBUSSCHE,L.WYNS,R.LORIS,J.MESSENS                             
REVDAT   1   24-JUL-07 2O7K    0                                                
JRNL        AUTH   G.ROOS,A.GARCIA-PINO,K.VAN BELLE,E.BROSENS,K.WAHNI,          
JRNL        AUTH 2 G.VANDENBUSSCHE,L.WYNS,R.LORIS,J.MESSENS                     
JRNL        TITL   THE CONSERVED ACTIVE SITE PROLINE DETERMINES THE             
JRNL        TITL 2 REDUCING POWER OF STAPHYLOCOCCUS AUREUS THIOREDOXIN          
JRNL        REF    J.MOL.BIOL.                   V. 368   800 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2O7K A    1   104  UNP    P0A0K6   THIO_STAAU       1    104             
SEQRES   1 A  107  GLY SER HIS MET ALA ILE VAL LYS VAL THR ASP ALA ASP          
SEQRES   2 A  107  PHE ASP SER LYS VAL GLU SER GLY VAL GLN LEU VAL ASP          
SEQRES   3 A  107  PHE TRP ALA THR TRP CYS GLY PRO CYS LYS MET ILE ALA          
SEQRES   4 A  107  PRO VAL LEU GLU GLU LEU ALA ALA ASP TYR GLU GLY LYS          
SEQRES   5 A  107  ALA ASP ILE LEU LYS LEU ASP VAL ASP GLU ASN PRO SER          
SEQRES   6 A  107  THR ALA ALA LYS TYR GLU VAL MET SER ILE PRO THR LEU          
SEQRES   7 A  107  ILE VAL PHE LYS ASP GLY GLN PRO VAL ASP LYS VAL VAL          
SEQRES   8 A  107  GLY PHE GLN PRO LYS GLU ASN LEU ALA GLU VAL LEU ASP          
SEQRES   9 A  107  LYS HIS LEU                                                  
FORMUL   2  HOH   *22(H2 O)                                                     
CRYST1   41.032   49.695   54.473  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   ALA A   2      29.115 119.702  -8.576  1.00 73.20           N  
ATOM      2  CA  ALA A   2      27.692 119.924  -8.804  1.00 70.95           C  
ATOM      3  C   ALA A   2      27.117 118.919  -9.806  1.00 67.42           C  
ATOM      4  O   ALA A   2      27.838 118.362 -10.639  1.00 63.82           O  
ATOM      5  CB  ALA A   2      27.457 121.356  -9.297  1.00 71.04           C  
ATOM      6  N   ILE A   3      25.810 118.692  -9.717  1.00 63.04           N  
ATOM      7  CA  ILE A   3      25.136 117.757 -10.604  1.00 57.91           C  
ATOM      8  C   ILE A   3      24.386 118.492 -11.704  1.00 57.32           C  
ATOM      9  O   ILE A   3      23.441 119.234 -11.433  1.00 61.54           O  
ATOM     10  CB  ILE A   3      24.133 116.891  -9.829  1.00 56.56           C  
ATOM     11  CG1 ILE A   3      24.856 116.151  -8.703  1.00 58.61           C  
ATOM     12  CG2 ILE A   3      23.460 115.906 -10.773  1.00 57.96           C  
ATOM     13  CD1 ILE A   3      23.947 115.294  -7.849  1.00 70.62           C  
ATOM     14  N   VAL A   4      24.807 118.285 -12.948  1.00 48.49           N  
ATOM     15  CA  VAL A   4      24.150 118.928 -14.073  1.00 46.93           C  
ATOM     16  C   VAL A   4      22.870 118.181 -14.461  1.00 46.10           C  
ATOM     17  O   VAL A   4      22.820 116.947 -14.448  1.00 41.76           O  
ATOM     18  CB  VAL A   4      25.103 119.014 -15.293  1.00 51.43           C  
ATOM     19  CG1 VAL A   4      25.697 117.663 -15.578  1.00 52.99           C  
ATOM     20  CG2 VAL A   4      24.351 119.517 -16.523  1.00 52.96           C  
ATOM     21  N   LYS A   5      21.830 118.942 -14.785  1.00 42.09           N  
ATOM     22  CA  LYS A   5      20.560 118.366 -15.196  1.00 39.24           C  
ATOM     23  C   LYS A   5      20.661 118.024 -16.675  1.00 37.07           C  
ATOM     24  O   LYS A   5      21.396 118.673 -17.417  1.00 45.28           O  
ATOM     25  CB  LYS A   5      19.424 119.369 -14.987  1.00 39.11           C  
ATOM     26  N   VAL A   6      19.944 116.990 -17.094  1.00 31.83           N  
ATOM     27  CA  VAL A   6      19.932 116.575 -18.492  1.00 29.56           C  
ATOM     28  C   VAL A   6      18.465 116.311 -18.845  1.00 32.33           C  
ATOM     29  O   VAL A   6      17.662 116.000 -17.962  1.00 30.93           O  
ATOM     30  CB  VAL A   6      20.805 115.299 -18.709  1.00 33.77           C  
ATOM     31  CG1 VAL A   6      20.256 114.120 -17.899  1.00 31.76           C  
ATOM     32  CG2 VAL A   6      20.861 114.956 -20.182  1.00 44.73           C  
ATOM     33  N   THR A   7      18.110 116.459 -20.118  1.00 33.55           N  
ATOM     34  CA  THR A   7      16.728 116.260 -20.570  1.00 34.30           C  
ATOM     35  C   THR A   7      16.689 115.408 -21.843  1.00 32.04           C  
ATOM     36  O   THR A   7      17.738 115.041 -22.386  1.00 30.64           O  
ATOM     37  CB  THR A   7      16.044 117.622 -20.881  1.00 30.28           C  
ATOM     38  OG1 THR A   7      16.724 118.262 -21.970  1.00 36.32           O  
ATOM     39  CG2 THR A   7      16.113 118.548 -19.676  1.00 38.13           C  
ATOM     40  N   ASP A   8      15.488 115.080 -22.318  1.00 29.54           N  
ATOM     41  CA  ASP A   8      15.382 114.296 -23.549  1.00 35.12           C  
ATOM     42  C   ASP A   8      16.044 115.037 -24.710  1.00 35.04           C  
ATOM     43  O   ASP A   8      16.596 114.422 -25.625  1.00 37.90           O  
ATOM     44  CB  ASP A   8      13.919 114.036 -23.941  1.00 34.56           C  
ATOM     45  CG  ASP A   8      13.216 113.077 -23.006  1.00 34.24           C  
ATOM     46  OD1 ASP A   8      13.878 112.146 -22.500  1.00 41.09           O  
ATOM     47  OD2 ASP A   8      11.991 113.231 -22.808  1.00 34.41           O  
ATOM     48  N   ALA A   9      15.982 116.364 -24.669  1.00 35.01           N  
ATOM     49  CA  ALA A   9      16.529 117.184 -25.740  1.00 37.78           C  
ATOM     50  C   ALA A   9      18.040 117.146 -25.906  1.00 37.89           C  
ATOM     51  O   ALA A   9      18.537 117.257 -27.025  1.00 37.56           O  
ATOM     52  CB  ALA A   9      16.066 118.643 -25.570  1.00 34.56           C  
ATOM     53  N   ASP A  10      18.775 116.983 -24.810  1.00 35.04           N  
ATOM     54  CA  ASP A  10      20.232 116.989 -24.897  1.00 34.05           C  
ATOM     55  C   ASP A  10      20.922 115.772 -24.300  1.00 36.03           C  
ATOM     56  O   ASP A  10      22.136 115.780 -24.111  1.00 39.49           O  
ATOM     57  CB  ASP A  10      20.768 118.261 -24.232  1.00 27.66           C  
ATOM     58  CG  ASP A  10      20.460 118.323 -22.739  1.00 37.51           C  
ATOM     59  OD1 ASP A  10      19.363 117.900 -22.320  1.00 43.06           O  
ATOM     60  OD2 ASP A  10      21.304 118.827 -21.979  1.00 37.49           O  
ATOM     61  N   PHE A  11      20.158 114.724 -24.013  1.00 34.63           N  
ATOM     62  CA  PHE A  11      20.739 113.531 -23.417  1.00 32.02           C  
ATOM     63  C   PHE A  11      21.875 112.952 -24.257  1.00 36.07           C  
ATOM     64  O   PHE A  11      22.979 112.722 -23.750  1.00 35.64           O  
ATOM     65  CB  PHE A  11      19.689 112.451 -23.238  1.00 30.95           C  
ATOM     66  CG  PHE A  11      20.128 111.329 -22.345  1.00 29.35           C  
ATOM     67  CD1 PHE A  11      20.049 111.458 -20.963  1.00 28.62           C  
ATOM     68  CD2 PHE A  11      20.618 110.146 -22.879  1.00 37.35           C  
ATOM     69  CE1 PHE A  11      20.445 110.419 -20.127  1.00 45.53           C  
ATOM     70  CE2 PHE A  11      21.022 109.096 -22.050  1.00 39.51           C  
ATOM     71  CZ  PHE A  11      20.931 109.234 -20.675  1.00 39.07           C  
ATOM     72  N   ASP A  12      21.595 112.709 -25.535  1.00 33.02           N  
ATOM     73  CA  ASP A  12      22.576 112.130 -26.454  1.00 38.74           C  
ATOM     74  C   ASP A  12      23.861 112.931 -26.599  1.00 42.26           C  
ATOM     75  O   ASP A  12      24.912 112.355 -26.882  1.00 49.59           O  
ATOM     76  CB  ASP A  12      21.949 111.917 -27.837  1.00 39.35           C  
ATOM     77  CG  ASP A  12      20.773 110.951 -27.804  1.00 34.53           C  
ATOM     78  N   SER A  13      23.800 114.249 -26.408  1.00 43.25           N  
ATOM     79  CA  SER A  13      25.013 115.054 -26.528  1.00 43.48           C  
ATOM     80  C   SER A  13      25.795 115.077 -25.208  1.00 42.90           C  
ATOM     81  O   SER A  13      27.024 115.135 -25.214  1.00 44.58           O  
ATOM     82  CB  SER A  13      24.694 116.490 -26.996  1.00 46.06           C  
ATOM     83  OG  SER A  13      24.041 117.259 -26.004  1.00 56.74           O  
ATOM     84  N   LYS A  14      25.096 115.020 -24.078  1.00 38.99           N  
ATOM     85  CA  LYS A  14      25.775 115.009 -22.786  1.00 40.88           C  
ATOM     86  C   LYS A  14      26.364 113.636 -22.412  1.00 39.00           C  
ATOM     87  O   LYS A  14      27.365 113.555 -21.698  1.00 36.31           O  
ATOM     88  CB  LYS A  14      24.823 115.467 -21.663  1.00 41.02           C  
ATOM     89  CG  LYS A  14      24.793 116.984 -21.359  1.00 46.37           C  
ATOM     90  CD  LYS A  14      24.244 117.842 -22.491  1.00 58.45           C  
ATOM     91  CE  LYS A  14      24.208 119.330 -22.102  1.00 31.83           C  
ATOM     92  N   VAL A  15      25.780 112.553 -22.918  0.50 39.12           N  
ATOM     94  CA  VAL A  15      26.267 111.215 -22.572  0.50 44.28           C  
ATOM     96  C   VAL A  15      27.360 110.617 -23.471  0.50 47.17           C  
ATOM     98  O   VAL A  15      28.143 109.779 -23.023  0.50 48.56           O  
ATOM    100  CB  VAL A  15      25.088 110.213 -22.485  0.50 43.27           C  
ATOM    102  CG1 VAL A  15      25.604 108.833 -22.123  0.50 49.46           C  
ATOM    104  CG2 VAL A  15      24.087 110.685 -21.436  0.50 44.65           C  
ATOM    106  N   GLU A  16      27.430 111.054 -24.726  0.50 53.21           N  
ATOM    108  CA  GLU A  16      28.430 110.543 -25.664  0.50 54.91           C  
ATOM    110  C   GLU A  16      29.857 110.492 -25.107  0.50 57.69           C  
ATOM    112  O   GLU A  16      30.682 109.710 -25.579  0.50 56.57           O  
ATOM    114  CB  GLU A  16      28.421 111.390 -26.939  0.50 55.06           C  
ATOM    116  N   SER A  17      30.127 111.320 -24.102  0.50 59.98           N  
ATOM    118  CA  SER A  17      31.446 111.430 -23.476  0.50 60.59           C  
ATOM    120  C   SER A  17      32.092 110.142 -22.963  0.50 58.91           C  
ATOM    122  O   SER A  17      32.085 109.111 -23.636  0.50 60.62           O  
ATOM    124  CB  SER A  17      31.381 112.444 -22.332  0.50 65.27           C  
ATOM    126  OG  SER A  17      30.960 113.712 -22.805  0.50 74.91           O  
ATOM    128  N   GLY A  18      32.668 110.226 -21.765  0.50 55.51           N  
ATOM    130  CA  GLY A  18      33.328 109.081 -21.158  0.50 53.05           C  
ATOM    132  C   GLY A  18      32.429 108.331 -20.193  0.50 52.14           C  
ATOM    134  O   GLY A  18      31.444 107.724 -20.610  0.50 49.14           O  
ATOM    136  N   VAL A  19      32.766 108.359 -18.904  1.00 48.32           N  
ATOM    137  CA  VAL A  19      31.948 107.673 -17.909  1.00 49.67           C  
ATOM    138  C   VAL A  19      30.995 108.654 -17.242  1.00 48.34           C  
ATOM    139  O   VAL A  19      31.407 109.719 -16.774  1.00 43.61           O  
ATOM    140  CB  VAL A  19      32.809 107.027 -16.809  1.00 47.99           C  
ATOM    141  CG1 VAL A  19      31.909 106.437 -15.725  1.00 51.07           C  
ATOM    142  CG2 VAL A  19      33.687 105.944 -17.409  1.00 56.06           C  
ATOM    143  N   GLN A  20      29.721 108.291 -17.191  1.00 46.03           N  
ATOM    144  CA  GLN A  20      28.731 109.161 -16.579  1.00 43.64           C  
ATOM    145  C   GLN A  20      27.670 108.389 -15.827  1.00 42.30           C  
ATOM    146  O   GLN A  20      27.210 107.340 -16.275  1.00 36.57           O  
ATOM    147  CB  GLN A  20      28.106 110.036 -17.656  1.00 40.93           C  
ATOM    148  CG  GLN A  20      29.169 110.893 -18.314  1.00 55.12           C  
ATOM    149  CD  GLN A  20      28.923 111.106 -19.768  1.00 45.98           C  
ATOM    150  OE1 GLN A  20      28.661 110.157 -20.505  1.00 44.59           O  
ATOM    151  NE2 GLN A  20      29.029 112.352 -20.211  1.00 64.61           N  
ATOM    152  N   LEU A  21      27.309 108.912 -14.661  1.00 36.62           N  
ATOM    153  CA  LEU A  21      26.289 108.302 -13.832  1.00 35.35           C  
ATOM    154  C   LEU A  21      25.037 109.140 -13.994  1.00 30.66           C  
ATOM    155  O   LEU A  21      25.053 110.344 -13.724  1.00 33.63           O  
ATOM    156  CB  LEU A  21      26.720 108.297 -12.363  1.00 37.68           C  
ATOM    157  CG  LEU A  21      25.782 107.595 -11.375  1.00 39.89           C  
ATOM    158  CD1 LEU A  21      25.668 106.121 -11.747  1.00 44.98           C  
ATOM    159  CD2 LEU A  21      26.332 107.728  -9.950  1.00 34.42           C  
ATOM    160  N   VAL A  22      23.959 108.513 -14.450  1.00 25.54           N  
ATOM    161  CA  VAL A  22      22.706 109.232 -14.635  1.00 30.09           C  
ATOM    162  C   VAL A  22      21.678 108.845 -13.587  1.00 24.47           C  
ATOM    163  O   VAL A  22      21.301 107.681 -13.465  1.00 22.62           O  
ATOM    164  CB  VAL A  22      22.094 108.978 -16.023  1.00 24.78           C  
ATOM    165  CG1 VAL A  22      20.786 109.751 -16.155  1.00 27.01           C  
ATOM    166  CG2 VAL A  22      23.073 109.390 -17.108  1.00 26.79           C  
ATOM    167  N   ASP A  23      21.223 109.840 -12.840  1.00 25.69           N  
ATOM    168  CA  ASP A  23      20.230 109.632 -11.798  1.00 25.70           C  
ATOM    169  C   ASP A  23      18.821 109.922 -12.328  1.00 25.63           C  
ATOM    170  O   ASP A  23      18.508 111.060 -12.681  1.00 23.72           O  
ATOM    171  CB  ASP A  23      20.559 110.534 -10.598  1.00 23.62           C  
ATOM    172  CG  ASP A  23      19.515 110.458  -9.483  1.00 26.48           C  
ATOM    173  OD1 ASP A  23      19.076 109.354  -9.153  1.00 27.06           O  
ATOM    174  OD2 ASP A  23      19.156 111.506  -8.916  1.00 28.58           O  
ATOM    175  N   PHE A  24      17.998 108.879 -12.426  1.00 21.59           N  
ATOM    176  CA  PHE A  24      16.609 109.025 -12.878  1.00 24.42           C  
ATOM    177  C   PHE A  24      15.783 109.208 -11.617  1.00 24.71           C  
ATOM    178  O   PHE A  24      15.636 108.285 -10.809  1.00 29.35           O  
ATOM    179  CB  PHE A  24      16.117 107.782 -13.633  1.00 26.75           C  
ATOM    180  CG  PHE A  24      16.819 107.545 -14.942  1.00 31.80           C  
ATOM    181  CD1 PHE A  24      18.131 107.092 -14.974  1.00 32.82           C  
ATOM    182  CD2 PHE A  24      16.175 107.810 -16.144  1.00 31.09           C  
ATOM    183  CE1 PHE A  24      18.790 106.907 -16.183  1.00 24.83           C  
ATOM    184  CE2 PHE A  24      16.828 107.630 -17.357  1.00 27.18           C  
ATOM    185  CZ  PHE A  24      18.140 107.177 -17.374  1.00 29.27           C  
ATOM    186  N   TRP A  25      15.248 110.406 -11.443  1.00 29.61           N  
ATOM    187  CA  TRP A  25      14.482 110.703 -10.253  1.00 29.67           C  
ATOM    188  C   TRP A  25      13.179 111.427 -10.585  1.00 30.38           C  
ATOM    189  O   TRP A  25      12.836 111.626 -11.747  1.00 28.84           O  
ATOM    190  CB  TRP A  25      15.326 111.570  -9.312  1.00 33.77           C  
ATOM    191  CG  TRP A  25      15.507 112.949  -9.834  1.00 28.66           C  
ATOM    192  CD1 TRP A  25      16.197 113.325 -10.957  1.00 37.23           C  
ATOM    193  CD2 TRP A  25      14.879 114.134  -9.334  1.00 33.00           C  
ATOM    194  NE1 TRP A  25      16.029 114.672 -11.188  1.00 34.23           N  
ATOM    195  CE2 TRP A  25      15.223 115.193 -10.207  1.00 42.00           C  
ATOM    196  CE3 TRP A  25      14.053 114.403  -8.233  1.00 30.75           C  
ATOM    197  CZ2 TRP A  25      14.770 116.505 -10.011  1.00 40.74           C  
ATOM    198  CZ3 TRP A  25      13.598 115.710  -8.038  1.00 34.80           C  
ATOM    199  CH2 TRP A  25      13.958 116.743  -8.924  1.00 37.36           C  
ATOM    200  N   ALA A  26      12.468 111.815  -9.538  1.00 22.38           N  
ATOM    201  CA  ALA A  26      11.201 112.519  -9.651  1.00 29.64           C  
ATOM    202  C   ALA A  26      10.930 113.154  -8.296  1.00 30.50           C  
ATOM    203  O   ALA A  26      11.348 112.628  -7.259  1.00 30.36           O  
ATOM    204  CB  ALA A  26      10.084 111.550 -10.008  1.00 23.22           C  
ATOM    205  N   THR A  27      10.231 114.282  -8.309  1.00 34.49           N  
ATOM    206  CA  THR A  27       9.909 115.009  -7.088  1.00 36.66           C  
ATOM    207  C   THR A  27       9.098 114.216  -6.064  1.00 34.84           C  
ATOM    208  O   THR A  27       9.256 114.411  -4.861  1.00 36.47           O  
ATOM    209  CB  THR A  27       9.166 116.319  -7.421  1.00 34.84           C  
ATOM    210  OG1 THR A  27       8.017 116.032  -8.225  1.00 37.31           O  
ATOM    211  CG2 THR A  27      10.085 117.253  -8.192  1.00 35.74           C  
ATOM    212  N   TRP A  28       8.240 113.317  -6.531  1.00 35.18           N  
ATOM    213  CA  TRP A  28       7.415 112.511  -5.627  1.00 35.75           C  
ATOM    214  C   TRP A  28       8.134 111.281  -5.059  1.00 41.27           C  
ATOM    215  O   TRP A  28       7.565 110.528  -4.264  1.00 37.17           O  
ATOM    216  CB  TRP A  28       6.150 112.049  -6.354  1.00 32.48           C  
ATOM    217  CG  TRP A  28       6.426 111.533  -7.742  1.00 32.55           C  
ATOM    218  CD1 TRP A  28       6.377 112.247  -8.902  1.00 33.27           C  
ATOM    219  CD2 TRP A  28       6.881 110.223  -8.099  1.00 28.93           C  
ATOM    220  NE1 TRP A  28       6.776 111.464  -9.964  1.00 37.99           N  
ATOM    221  CE2 TRP A  28       7.091 110.217  -9.497  1.00 36.84           C  
ATOM    222  CE3 TRP A  28       7.134 109.054  -7.375  1.00 39.47           C  
ATOM    223  CZ2 TRP A  28       7.544 109.089 -10.184  1.00 35.15           C  
ATOM    224  CZ3 TRP A  28       7.588 107.928  -8.062  1.00 34.85           C  
ATOM    225  CH2 TRP A  28       7.786 107.957  -9.450  1.00 33.83           C  
ATOM    226  N   CYS A  29       9.385 111.088  -5.460  1.00 39.19           N  
ATOM    227  CA  CYS A  29      10.179 109.939  -5.027  1.00 38.03           C  
ATOM    228  C   CYS A  29      10.891 110.149  -3.683  1.00 33.89           C  
ATOM    229  O   CYS A  29      11.832 110.932  -3.586  1.00 36.47           O  
ATOM    230  CB  CYS A  29      11.214 109.622  -6.112  1.00 35.61           C  
ATOM    231  SG  CYS A  29      12.352 108.250  -5.749  1.00 35.41           S  
ATOM    232  N   GLY A  30      10.450 109.431  -2.654  1.00 33.44           N  
ATOM    233  CA  GLY A  30      11.064 109.556  -1.340  1.00 31.71           C  
ATOM    234  C   GLY A  30      12.500 109.055  -1.262  1.00 31.47           C  
ATOM    235  O   GLY A  30      13.373 109.766  -0.763  1.00 38.08           O  
ATOM    236  N   PRO A  31      12.783 107.832  -1.736  1.00 28.48           N  
ATOM    237  CA  PRO A  31      14.147 107.292  -1.693  1.00 29.19           C  
ATOM    238  C   PRO A  31      15.134 108.134  -2.500  1.00 33.32           C  
ATOM    239  O   PRO A  31      16.334 108.127  -2.221  1.00 31.61           O  
ATOM    240  CB  PRO A  31      13.975 105.887  -2.276  1.00 25.94           C  
ATOM    241  CG  PRO A  31      12.529 105.552  -1.908  1.00 35.89           C  
ATOM    242  CD  PRO A  31      11.871 106.845  -2.337  1.00 26.20           C  
ATOM    243  N   CYS A  32      14.621 108.842  -3.509  1.00 29.48           N  
ATOM    244  CA  CYS A  32      15.451 109.696  -4.345  1.00 30.91           C  
ATOM    245  C   CYS A  32      15.937 110.891  -3.530  1.00 35.03           C  
ATOM    246  O   CYS A  32      17.077 111.335  -3.674  1.00 32.59           O  
ATOM    247  CB  CYS A  32      14.674 110.198  -5.574  1.00 28.79           C  
ATOM    248  SG  CYS A  32      14.053 108.885  -6.670  1.00 32.48           S  
ATOM    249  N   LYS A  33      15.066 111.406  -2.674  1.00 33.34           N  
ATOM    250  CA  LYS A  33      15.413 112.539  -1.831  1.00 38.29           C  
ATOM    251  C   LYS A  33      16.524 112.124  -0.871  1.00 37.44           C  
ATOM    252  O   LYS A  33      17.388 112.921  -0.514  1.00 40.16           O  
ATOM    253  CB  LYS A  33      14.186 112.997  -1.040  1.00 37.72           C  
ATOM    254  N   MET A  34      16.507 110.856  -0.482  1.00 37.11           N  
ATOM    255  CA  MET A  34      17.500 110.326   0.441  1.00 37.24           C  
ATOM    256  C   MET A  34      18.879 110.166  -0.206  1.00 35.05           C  
ATOM    257  O   MET A  34      19.892 110.456   0.423  1.00 36.45           O  
ATOM    258  CB  MET A  34      17.025 108.975   0.976  1.00 42.23           C  
ATOM    259  CG  MET A  34      17.219 108.801   2.460  1.00 60.21           C  
ATOM    260  SD  MET A  34      16.228 109.967   3.433  1.00 58.18           S  
ATOM    261  CE  MET A  34      16.737 109.451   5.046  1.00 73.36           C  
ATOM    262  N   ILE A  35      18.928 109.712  -1.458  1.00 30.73           N  
ATOM    263  CA  ILE A  35      20.220 109.531  -2.122  1.00 34.85           C  
ATOM    264  C   ILE A  35      20.789 110.817  -2.708  1.00 33.41           C  
ATOM    265  O   ILE A  35      21.971 110.867  -3.047  1.00 36.84           O  
ATOM    266  CB  ILE A  35      20.162 108.522  -3.290  1.00 40.09           C  
ATOM    267  CG1 ILE A  35      19.394 109.123  -4.464  1.00 36.91           C  
ATOM    268  CG2 ILE A  35      19.497 107.244  -2.847  1.00 55.33           C  
ATOM    269  CD1 ILE A  35      19.397 108.247  -5.686  1.00 51.44           C  
ATOM    270  N   ALA A  36      19.956 111.848  -2.838  1.00 29.84           N  
ATOM    271  CA  ALA A  36      20.405 113.118  -3.410  1.00 35.82           C  
ATOM    272  C   ALA A  36      21.716 113.643  -2.812  1.00 36.89           C  
ATOM    273  O   ALA A  36      22.660 113.945  -3.543  1.00 36.72           O  
ATOM    274  CB  ALA A  36      19.307 114.169  -3.275  1.00 37.81           C  
ATOM    275  N   PRO A  37      21.780 113.794  -1.478  1.00 37.23           N  
ATOM    276  CA  PRO A  37      23.000 114.288  -0.831  1.00 39.46           C  
ATOM    277  C   PRO A  37      24.199 113.364  -1.057  1.00 37.54           C  
ATOM    278  O   PRO A  37      25.337 113.817  -1.153  1.00 38.96           O  
ATOM    279  CB  PRO A  37      22.582 114.379   0.638  1.00 38.78           C  
ATOM    280  CG  PRO A  37      21.572 113.256   0.749  1.00 47.38           C  
ATOM    281  CD  PRO A  37      20.735 113.577  -0.463  1.00 38.32           C  
ATOM    282  N   VAL A  38      23.939 112.068  -1.154  1.00 37.42           N  
ATOM    283  CA  VAL A  38      25.008 111.098  -1.376  1.00 37.32           C  
ATOM    284  C   VAL A  38      25.633 111.285  -2.756  1.00 41.63           C  
ATOM    285  O   VAL A  38      26.836 111.094  -2.930  1.00 39.39           O  
ATOM    286  CB  VAL A  38      24.484 109.657  -1.267  1.00 41.89           C  
ATOM    287  CG1 VAL A  38      25.602 108.675  -1.564  1.00 38.93           C  
ATOM    288  CG2 VAL A  38      23.895 109.421   0.125  1.00 32.71           C  
ATOM    289  N   LEU A  39      24.812 111.657  -3.735  1.00 41.55           N  
ATOM    290  CA  LEU A  39      25.295 111.873  -5.094  1.00 40.51           C  
ATOM    291  C   LEU A  39      26.111 113.151  -5.173  1.00 38.73           C  
ATOM    292  O   LEU A  39      27.115 113.206  -5.880  1.00 34.17           O  
ATOM    293  CB  LEU A  39      24.125 111.939  -6.088  1.00 27.57           C  
ATOM    294  CG  LEU A  39      23.374 110.620  -6.302  1.00 36.02           C  
ATOM    295  CD1 LEU A  39      22.171 110.836  -7.194  1.00 39.21           C  
ATOM    296  CD2 LEU A  39      24.312 109.600  -6.911  1.00 35.00           C  
ATOM    297  N   GLU A  40      25.678 114.176  -4.446  1.00 38.65           N  
ATOM    298  CA  GLU A  40      26.395 115.446  -4.440  1.00 46.12           C  
ATOM    299  C   GLU A  40      27.812 115.256  -3.925  1.00 43.60           C  
ATOM    300  O   GLU A  40      28.751 115.872  -4.433  1.00 47.59           O  
ATOM    301  CB  GLU A  40      25.654 116.468  -3.584  1.00 40.39           C  
ATOM    302  CG  GLU A  40      24.356 116.932  -4.222  1.00 58.19           C  
ATOM    303  CD  GLU A  40      23.546 117.834  -3.313  1.00 68.07           C  
ATOM    304  OE1 GLU A  40      22.533 118.392  -3.783  1.00 73.98           O  
ATOM    305  OE2 GLU A  40      23.913 117.976  -2.127  1.00 74.21           O  
ATOM    306  N   GLU A  41      27.962 114.394  -2.923  1.00 44.51           N  
ATOM    307  CA  GLU A  41      29.269 114.108  -2.345  1.00 49.23           C  
ATOM    308  C   GLU A  41      30.084 113.282  -3.338  1.00 52.47           C  
ATOM    309  O   GLU A  41      31.246 113.581  -3.609  1.00 53.34           O  
ATOM    310  CB  GLU A  41      29.114 113.331  -1.031  1.00 40.71           C  
ATOM    311  N   LEU A  42      29.457 112.243  -3.879  1.00 51.47           N  
ATOM    312  CA  LEU A  42      30.103 111.366  -4.848  1.00 49.60           C  
ATOM    313  C   LEU A  42      30.629 112.181  -6.034  1.00 45.93           C  
ATOM    314  O   LEU A  42      31.727 111.936  -6.537  1.00 40.32           O  
ATOM    315  CB  LEU A  42      29.101 110.323  -5.348  1.00 50.04           C  
ATOM    316  CG  LEU A  42      29.651 109.248  -6.277  1.00 51.05           C  
ATOM    317  CD1 LEU A  42      30.679 108.422  -5.519  1.00 51.86           C  
ATOM    318  CD2 LEU A  42      28.517 108.361  -6.774  1.00 55.36           C  
ATOM    319  N   ALA A  43      29.830 113.150  -6.476  1.00 44.57           N  
ATOM    320  CA  ALA A  43      30.198 114.008  -7.593  1.00 42.51           C  
ATOM    321  C   ALA A  43      31.540 114.675  -7.319  1.00 52.09           C  
ATOM    322  O   ALA A  43      32.423 114.687  -8.174  1.00 59.50           O  
ATOM    323  CB  ALA A  43      29.119 115.060  -7.820  1.00 32.08           C  
ATOM    324  N   ALA A  44      31.690 115.221  -6.114  1.00 53.78           N  
ATOM    325  CA  ALA A  44      32.923 115.887  -5.719  1.00 54.46           C  
ATOM    326  C   ALA A  44      34.099 114.914  -5.706  1.00 57.37           C  
ATOM    327  O   ALA A  44      35.191 115.251  -6.161  1.00 60.26           O  
ATOM    328  CB  ALA A  44      32.753 116.521  -4.347  1.00 60.38           C  
ATOM    329  N   ASP A  45      33.876 113.711  -5.188  1.00 54.99           N  
ATOM    330  CA  ASP A  45      34.931 112.702  -5.123  1.00 59.22           C  
ATOM    331  C   ASP A  45      35.415 112.251  -6.497  1.00 62.22           C  
ATOM    332  O   ASP A  45      36.473 111.626  -6.609  1.00 62.68           O  
ATOM    333  CB  ASP A  45      34.467 111.463  -4.355  1.00 62.18           C  
ATOM    334  CG  ASP A  45      34.059 111.778  -2.931  1.00 68.48           C  
ATOM    335  OD1 ASP A  45      34.843 112.431  -2.219  1.00 72.16           O  
ATOM    336  OD2 ASP A  45      32.956 111.356  -2.519  1.00 75.68           O  
ATOM    337  N   TYR A  46      34.641 112.545  -7.537  1.00 60.39           N  
ATOM    338  CA  TYR A  46      35.034 112.142  -8.877  1.00 57.42           C  
ATOM    339  C   TYR A  46      35.156 113.256  -9.897  1.00 58.91           C  
ATOM    340  O   TYR A  46      35.133 112.990 -11.100  1.00 59.47           O  
ATOM    341  CB  TYR A  46      34.082 111.075  -9.421  1.00 54.41           C  
ATOM    342  CG  TYR A  46      34.220 109.752  -8.728  1.00 40.93           C  
ATOM    343  CD1 TYR A  46      33.770 109.574  -7.423  1.00 42.08           C  
ATOM    344  CD2 TYR A  46      34.841 108.680  -9.362  1.00 46.98           C  
ATOM    345  CE1 TYR A  46      33.935 108.355  -6.767  1.00 38.75           C  
ATOM    346  CE2 TYR A  46      35.013 107.461  -8.716  1.00 42.17           C  
ATOM    347  CZ  TYR A  46      34.556 107.306  -7.419  1.00 39.90           C  
ATOM    348  OH  TYR A  46      34.718 106.098  -6.777  1.00 47.88           O  
ATOM    349  N   GLU A  47      35.280 114.493  -9.429  1.00 59.96           N  
ATOM    350  CA  GLU A  47      35.432 115.615 -10.349  1.00 64.17           C  
ATOM    351  C   GLU A  47      36.598 115.276 -11.282  1.00 65.21           C  
ATOM    352  O   GLU A  47      37.677 114.884 -10.826  1.00 66.12           O  
ATOM    353  CB  GLU A  47      35.750 116.901  -9.578  1.00 60.13           C  
ATOM    354  N   GLY A  48      36.367 115.392 -12.585  1.00 65.50           N  
ATOM    355  CA  GLY A  48      37.420 115.096 -13.540  1.00 63.40           C  
ATOM    356  C   GLY A  48      37.527 113.627 -13.894  1.00 63.14           C  
ATOM    357  O   GLY A  48      38.244 113.260 -14.826  1.00 64.76           O  
ATOM    358  N   LYS A  49      36.830 112.780 -13.142  1.00 60.79           N  
ATOM    359  CA  LYS A  49      36.844 111.350 -13.399  1.00 57.75           C  
ATOM    360  C   LYS A  49      35.514 110.917 -14.023  1.00 57.33           C  
ATOM    361  O   LYS A  49      35.492 110.238 -15.048  1.00 59.94           O  
ATOM    362  CB  LYS A  49      37.086 110.582 -12.100  1.00 56.91           C  
ATOM    363  N   ALA A  50      34.400 111.309 -13.413  1.00 55.36           N  
ATOM    364  CA  ALA A  50      33.089 110.943 -13.940  1.00 48.72           C  
ATOM    365  C   ALA A  50      32.104 112.091 -13.781  1.00 46.59           C  
ATOM    366  O   ALA A  50      32.250 112.938 -12.900  1.00 49.87           O  
ATOM    367  CB  ALA A  50      32.566 109.691 -13.228  1.00 39.72           C  
ATOM    368  N   ASP A  51      31.101 112.124 -14.649  1.00 48.08           N  
ATOM    369  CA  ASP A  51      30.072 113.156 -14.592  1.00 45.46           C  
ATOM    370  C   ASP A  51      28.824 112.537 -13.974  1.00 43.50           C  
ATOM    371  O   ASP A  51      28.498 111.382 -14.239  1.00 47.21           O  
ATOM    372  CB  ASP A  51      29.727 113.652 -15.998  1.00 56.54           C  
ATOM    373  CG  ASP A  51      30.929 114.180 -16.746  1.00 61.40           C  
ATOM    374  OD1 ASP A  51      30.789 114.507 -17.944  1.00 66.18           O  
ATOM    375  OD2 ASP A  51      32.014 114.270 -16.137  1.00 73.40           O  
ATOM    376  N   ILE A  52      28.132 113.295 -13.139  1.00 39.14           N  
ATOM    377  CA  ILE A  52      26.905 112.803 -12.542  1.00 38.15           C  
ATOM    378  C   ILE A  52      25.793 113.701 -13.060  1.00 38.21           C  
ATOM    379  O   ILE A  52      25.841 114.922 -12.895  1.00 35.03           O  
ATOM    380  CB  ILE A  52      26.967 112.828 -11.002  1.00 35.14           C  
ATOM    381  CG1 ILE A  52      28.076 111.886 -10.532  1.00 41.47           C  
ATOM    382  CG2 ILE A  52      25.627 112.388 -10.413  1.00 36.66           C  
ATOM    383  CD1 ILE A  52      28.208 111.785  -9.037  1.00 51.03           C  
ATOM    384  N   LEU A  53      24.812 113.091 -13.721  1.00 33.07           N  
ATOM    385  CA  LEU A  53      23.702 113.843 -14.292  1.00 36.11           C  
ATOM    386  C   LEU A  53      22.407 113.442 -13.611  1.00 33.19           C  
ATOM    387  O   LEU A  53      22.297 112.346 -13.064  1.00 34.31           O  
ATOM    388  CB  LEU A  53      23.577 113.559 -15.799  1.00 29.80           C  
ATOM    389  CG  LEU A  53      24.862 113.501 -16.638  1.00 35.50           C  
ATOM    390  CD1 LEU A  53      24.519 113.253 -18.094  1.00 33.22           C  
ATOM    391  CD2 LEU A  53      25.631 114.774 -16.497  1.00 38.04           C  
ATOM    392  N   LYS A  54      21.432 114.344 -13.644  1.00 33.93           N  
ATOM    393  CA  LYS A  54      20.118 114.093 -13.070  1.00 32.09           C  
ATOM    394  C   LYS A  54      19.078 114.242 -14.166  1.00 32.87           C  
ATOM    395  O   LYS A  54      19.129 115.189 -14.944  1.00 27.34           O  
ATOM    396  CB  LYS A  54      19.803 115.088 -11.960  1.00 31.09           C  
ATOM    397  CG  LYS A  54      19.977 114.544 -10.558  1.00 48.55           C  
ATOM    398  CD  LYS A  54      19.623 115.606  -9.537  1.00 50.93           C  
ATOM    399  CE  LYS A  54      19.603 115.045  -8.126  1.00 58.59           C  
ATOM    400  NZ  LYS A  54      18.548 114.012  -7.958  1.00 65.00           N  
ATOM    401  N   LEU A  55      18.152 113.297 -14.240  1.00 29.19           N  
ATOM    402  CA  LEU A  55      17.088 113.359 -15.238  1.00 31.87           C  
ATOM    403  C   LEU A  55      15.729 113.093 -14.590  1.00 29.31           C  
ATOM    404  O   LEU A  55      15.447 111.983 -14.143  1.00 26.94           O  
ATOM    405  CB  LEU A  55      17.337 112.360 -16.377  1.00 28.21           C  
ATOM    406  CG  LEU A  55      16.204 112.392 -17.418  1.00 39.51           C  
ATOM    407  CD1 LEU A  55      16.754 112.472 -18.811  1.00 30.19           C  
ATOM    408  CD2 LEU A  55      15.296 111.186 -17.233  1.00 29.86           C  
ATOM    409  N   ASP A  56      14.910 114.137 -14.512  1.00 28.93           N  
ATOM    410  CA  ASP A  56      13.571 114.041 -13.936  1.00 27.20           C  
ATOM    411  C   ASP A  56      12.718 113.184 -14.887  1.00 33.16           C  
ATOM    412  O   ASP A  56      12.460 113.593 -16.018  1.00 32.83           O  
ATOM    413  CB  ASP A  56      12.974 115.445 -13.790  1.00 29.26           C  
ATOM    414  CG  ASP A  56      11.577 115.428 -13.203  1.00 32.80           C  
ATOM    415  OD1 ASP A  56      10.679 114.812 -13.808  1.00 43.02           O  
ATOM    416  OD2 ASP A  56      11.374 116.026 -12.133  1.00 46.69           O  
ATOM    417  N   VAL A  57      12.278 112.004 -14.440  1.00 32.51           N  
ATOM    418  CA  VAL A  57      11.497 111.136 -15.324  1.00 32.10           C  
ATOM    419  C   VAL A  57      10.122 111.672 -15.708  1.00 32.63           C  
ATOM    420  O   VAL A  57       9.596 111.285 -16.748  1.00 32.50           O  
ATOM    421  CB  VAL A  57      11.338 109.682 -14.760  1.00 30.18           C  
ATOM    422  CG1 VAL A  57      12.708 109.107 -14.435  1.00 31.02           C  
ATOM    423  CG2 VAL A  57      10.414 109.658 -13.536  1.00 19.38           C  
ATOM    424  N   ASP A  58       9.539 112.555 -14.898  1.00 31.17           N  
ATOM    425  CA  ASP A  58       8.230 113.114 -15.242  1.00 35.53           C  
ATOM    426  C   ASP A  58       8.313 114.063 -16.433  1.00 34.97           C  
ATOM    427  O   ASP A  58       7.465 114.024 -17.315  1.00 39.61           O  
ATOM    428  CB  ASP A  58       7.583 113.872 -14.067  1.00 33.33           C  
ATOM    429  CG  ASP A  58       7.119 112.953 -12.959  1.00 33.22           C  
ATOM    430  OD1 ASP A  58       6.615 111.856 -13.264  1.00 40.24           O  
ATOM    431  OD2 ASP A  58       7.237 113.339 -11.783  1.00 41.36           O  
ATOM    432  N   GLU A  59       9.331 114.916 -16.455  1.00 37.54           N  
ATOM    433  CA  GLU A  59       9.485 115.869 -17.550  1.00 36.94           C  
ATOM    434  C   GLU A  59      10.236 115.298 -18.748  1.00 36.15           C  
ATOM    435  O   GLU A  59      10.301 115.942 -19.795  1.00 36.97           O  
ATOM    436  CB  GLU A  59      10.196 117.139 -17.061  1.00 39.31           C  
ATOM    437  CG  GLU A  59       9.419 117.939 -16.029  1.00 43.46           C  
ATOM    438  N   ASN A  60      10.784 114.087 -18.602  1.00 30.97           N  
ATOM    439  CA  ASN A  60      11.545 113.443 -19.677  1.00 35.71           C  
ATOM    440  C   ASN A  60      11.237 111.946 -19.795  1.00 38.13           C  
ATOM    441  O   ASN A  60      12.130 111.114 -19.666  1.00 34.38           O  
ATOM    442  CB  ASN A  60      13.044 113.629 -19.427  1.00 27.33           C  
ATOM    443  CG  ASN A  60      13.440 115.089 -19.350  1.00 34.55           C  
ATOM    444  OD1 ASN A  60      13.472 115.789 -20.362  1.00 37.57           O  
ATOM    445  ND2 ASN A  60      13.720 115.562 -18.141  1.00 32.70           N  
ATOM    446  N   PRO A  61       9.970 111.589 -20.062  1.00 44.80           N  
ATOM    447  CA  PRO A  61       9.565 110.185 -20.190  1.00 39.16           C  
ATOM    448  C   PRO A  61      10.252 109.398 -21.312  1.00 36.79           C  
ATOM    449  O   PRO A  61      10.476 108.197 -21.177  1.00 38.16           O  
ATOM    450  CB  PRO A  61       8.051 110.295 -20.386  1.00 39.08           C  
ATOM    451  CG  PRO A  61       7.926 111.590 -21.142  1.00 44.19           C  
ATOM    452  CD  PRO A  61       8.800 112.463 -20.258  1.00 47.13           C  
ATOM    453  N   SER A  62      10.593 110.067 -22.407  1.00 33.98           N  
ATOM    454  CA  SER A  62      11.235 109.391 -23.526  1.00 40.09           C  
ATOM    455  C   SER A  62      12.519 108.685 -23.133  1.00 40.18           C  
ATOM    456  O   SER A  62      12.676 107.497 -23.391  1.00 39.71           O  
ATOM    457  CB  SER A  62      11.533 110.375 -24.662  1.00 35.06           C  
ATOM    458  OG  SER A  62      10.332 110.891 -25.201  1.00 58.55           O  
ATOM    459  N   THR A  63      13.441 109.413 -22.514  1.00 37.09           N  
ATOM    460  CA  THR A  63      14.697 108.811 -22.112  1.00 33.96           C  
ATOM    461  C   THR A  63      14.471 107.716 -21.075  1.00 28.87           C  
ATOM    462  O   THR A  63      15.161 106.696 -21.088  1.00 30.08           O  
ATOM    463  CB  THR A  63      15.660 109.869 -21.562  1.00 39.62           C  
ATOM    464  OG1 THR A  63      15.889 110.850 -22.576  1.00 38.38           O  
ATOM    465  CG2 THR A  63      16.993 109.240 -21.177  1.00 31.44           C  
ATOM    466  N   ALA A  64      13.496 107.912 -20.190  1.00 26.82           N  
ATOM    467  CA  ALA A  64      13.209 106.905 -19.167  1.00 31.92           C  
ATOM    468  C   ALA A  64      12.698 105.628 -19.816  1.00 34.71           C  
ATOM    469  O   ALA A  64      13.028 104.513 -19.382  1.00 30.64           O  
ATOM    470  CB  ALA A  64      12.183 107.422 -18.179  1.00 29.38           C  
ATOM    471  N   ALA A  65      11.885 105.796 -20.857  1.00 35.87           N  
ATOM    472  CA  ALA A  65      11.309 104.665 -21.573  1.00 34.91           C  
ATOM    473  C   ALA A  65      12.401 103.942 -22.339  1.00 33.47           C  
ATOM    474  O   ALA A  65      12.480 102.724 -22.310  1.00 36.65           O  
ATOM    475  CB  ALA A  65      10.228 105.149 -22.533  1.00 36.73           C  
ATOM    476  N   LYS A  66      13.251 104.704 -23.016  1.00 35.31           N  
ATOM    477  CA  LYS A  66      14.333 104.130 -23.801  1.00 36.10           C  
ATOM    478  C   LYS A  66      15.234 103.173 -23.012  1.00 41.97           C  
ATOM    479  O   LYS A  66      15.611 102.115 -23.524  1.00 37.98           O  
ATOM    480  CB  LYS A  66      15.183 105.244 -24.410  1.00 31.67           C  
ATOM    481  CG  LYS A  66      16.360 104.733 -25.229  1.00 44.50           C  
ATOM    482  CD  LYS A  66      17.184 105.865 -25.816  1.00 40.57           C  
ATOM    483  CE  LYS A  66      18.368 105.321 -26.593  1.00 45.58           C  
ATOM    484  NZ  LYS A  66      19.174 106.403 -27.225  1.00 58.70           N  
ATOM    485  N   TYR A  67      15.581 103.537 -21.777  1.00 36.44           N  
ATOM    486  CA  TYR A  67      16.446 102.688 -20.968  1.00 34.90           C  
ATOM    487  C   TYR A  67      15.711 101.828 -19.963  1.00 34.47           C  
ATOM    488  O   TYR A  67      16.274 101.425 -18.941  1.00 41.72           O  
ATOM    489  CB  TYR A  67      17.533 103.512 -20.262  1.00 23.53           C  
ATOM    490  CG  TYR A  67      18.441 104.207 -21.236  1.00 32.70           C  
ATOM    491  CD1 TYR A  67      18.174 105.504 -21.662  1.00 34.73           C  
ATOM    492  CD2 TYR A  67      19.518 103.532 -21.810  1.00 27.04           C  
ATOM    493  CE1 TYR A  67      18.951 106.112 -22.643  1.00 37.77           C  
ATOM    494  CE2 TYR A  67      20.299 104.129 -22.791  1.00 37.91           C  
ATOM    495  CZ  TYR A  67      20.006 105.419 -23.203  1.00 31.19           C  
ATOM    496  OH  TYR A  67      20.757 106.012 -24.181  1.00 38.70           O  
ATOM    497  N   GLU A  68      14.447 101.552 -20.260  1.00 35.90           N  
ATOM    498  CA  GLU A  68      13.622 100.691 -19.425  1.00 44.86           C  
ATOM    499  C   GLU A  68      13.613 101.046 -17.938  1.00 44.91           C  
ATOM    500  O   GLU A  68      13.640 100.154 -17.086  1.00 46.27           O  
ATOM    501  CB  GLU A  68      14.088  99.237 -19.567  1.00 44.33           C  
ATOM    502  CG  GLU A  68      14.140  98.675 -20.984  1.00 60.78           C  
ATOM    503  CD  GLU A  68      12.787  98.619 -21.661  1.00 69.10           C  
ATOM    504  OE1 GLU A  68      11.811  98.199 -21.003  1.00 74.07           O  
ATOM    505  OE2 GLU A  68      12.705  98.970 -22.858  1.00 77.85           O  
ATOM    506  N   VAL A  69      13.583 102.332 -17.615  1.00 43.15           N  
ATOM    507  CA  VAL A  69      13.545 102.730 -16.215  1.00 44.57           C  
ATOM    508  C   VAL A  69      12.113 102.561 -15.718  1.00 47.39           C  
ATOM    509  O   VAL A  69      11.237 103.359 -16.042  1.00 48.13           O  
ATOM    510  CB  VAL A  69      13.991 104.194 -16.034  1.00 41.40           C  
ATOM    511  CG1 VAL A  69      13.820 104.619 -14.578  1.00 33.33           C  
ATOM    512  CG2 VAL A  69      15.441 104.337 -16.450  1.00 38.66           C  
ATOM    513  N   MET A  70      11.880 101.511 -14.939  1.00 49.28           N  
ATOM    514  CA  MET A  70      10.545 101.232 -14.417  1.00 56.69           C  
ATOM    515  C   MET A  70      10.340 101.821 -13.032  1.00 52.94           C  
ATOM    516  O   MET A  70       9.380 102.544 -12.794  1.00 56.05           O  
ATOM    517  CB  MET A  70      10.306  99.721 -14.365  1.00 62.90           C  
ATOM    518  CG  MET A  70      10.466  99.034 -15.707  1.00 74.29           C  
ATOM    519  SD  MET A  70       9.413  99.769 -16.981  1.00 83.22           S  
ATOM    520  CE  MET A  70       7.785  99.562 -16.242  1.00 79.64           C  
ATOM    521  N   SER A  71      11.246 101.498 -12.119  1.00 48.71           N  
ATOM    522  CA  SER A  71      11.169 101.989 -10.757  1.00 41.25           C  
ATOM    523  C   SER A  71      12.305 102.972 -10.494  1.00 40.63           C  
ATOM    524  O   SER A  71      13.348 102.912 -11.140  1.00 40.61           O  
ATOM    525  CB  SER A  71      11.265 100.818  -9.776  1.00 38.91           C  
ATOM    526  N   ILE A  72      12.092 103.884  -9.554  1.00 32.07           N  
ATOM    527  CA  ILE A  72      13.113 104.850  -9.201  1.00 32.62           C  
ATOM    528  C   ILE A  72      13.200 104.907  -7.688  1.00 32.56           C  
ATOM    529  O   ILE A  72      12.225 104.640  -6.997  1.00 34.05           O  
ATOM    530  CB  ILE A  72      12.807 106.268  -9.760  1.00 37.18           C  
ATOM    531  CG1 ILE A  72      11.470 106.781  -9.226  1.00 39.06           C  
ATOM    532  CG2 ILE A  72      12.792 106.228 -11.288  1.00 40.94           C  
ATOM    533  CD1 ILE A  72      11.138 108.172  -9.693  1.00 33.56           C  
ATOM    534  N   PRO A  73      14.366 105.287  -7.156  1.00 32.83           N  
ATOM    535  CA  PRO A  73      15.545 105.659  -7.941  1.00 33.27           C  
ATOM    536  C   PRO A  73      16.230 104.553  -8.753  1.00 34.65           C  
ATOM    537  O   PRO A  73      16.305 103.400  -8.338  1.00 31.40           O  
ATOM    538  CB  PRO A  73      16.475 106.227  -6.878  1.00 37.15           C  
ATOM    539  CG  PRO A  73      16.166 105.328  -5.701  1.00 32.63           C  
ATOM    540  CD  PRO A  73      14.656 105.435  -5.718  1.00 38.03           C  
ATOM    541  N   THR A  74      16.702 104.925  -9.934  1.00 31.03           N  
ATOM    542  CA  THR A  74      17.462 104.019 -10.777  1.00 29.15           C  
ATOM    543  C   THR A  74      18.643 104.851 -11.203  1.00 29.42           C  
ATOM    544  O   THR A  74      18.496 106.035 -11.524  1.00 33.05           O  
ATOM    545  CB  THR A  74      16.701 103.538 -12.035  1.00 26.67           C  
ATOM    546  OG1 THR A  74      15.692 102.602 -11.653  1.00 25.22           O  
ATOM    547  CG2 THR A  74      17.656 102.856 -13.006  1.00 31.22           C  
ATOM    548  N   LEU A  75      19.819 104.243 -11.166  1.00 24.63           N  
ATOM    549  CA  LEU A  75      21.042 104.922 -11.556  1.00 26.98           C  
ATOM    550  C   LEU A  75      21.673 104.059 -12.639  1.00 27.68           C  
ATOM    551  O   LEU A  75      21.818 102.848 -12.471  1.00 24.32           O  
ATOM    552  CB  LEU A  75      21.987 105.024 -10.355  1.00 31.10           C  
ATOM    553  CG  LEU A  75      21.462 105.736  -9.102  1.00 34.64           C  
ATOM    554  CD1 LEU A  75      22.366 105.458  -7.920  1.00 49.88           C  
ATOM    555  CD2 LEU A  75      21.381 107.220  -9.363  1.00 34.50           C  
ATOM    556  N   ILE A  76      22.025 104.671 -13.760  1.00 26.52           N  
ATOM    557  CA  ILE A  76      22.655 103.918 -14.832  1.00 24.98           C  
ATOM    558  C   ILE A  76      24.026 104.505 -15.142  1.00 28.09           C  
ATOM    559  O   ILE A  76      24.178 105.721 -15.282  1.00 30.40           O  
ATOM    560  CB  ILE A  76      21.799 103.933 -16.115  1.00 23.88           C  
ATOM    561  CG1 ILE A  76      20.441 103.281 -15.829  1.00 23.23           C  
ATOM    562  CG2 ILE A  76      22.537 103.207 -17.251  1.00 21.31           C  
ATOM    563  CD1 ILE A  76      19.540 103.156 -17.044  1.00 33.36           C  
ATOM    564  N   VAL A  77      25.027 103.636 -15.235  1.00 25.72           N  
ATOM    565  CA  VAL A  77      26.372 104.081 -15.547  1.00 26.23           C  
ATOM    566  C   VAL A  77      26.566 103.985 -17.053  1.00 32.90           C  
ATOM    567  O   VAL A  77      26.385 102.915 -17.635  1.00 30.98           O  
ATOM    568  CB  VAL A  77      27.436 103.206 -14.844  1.00 27.26           C  
ATOM    569  CG1 VAL A  77      28.844 103.680 -15.224  1.00 29.02           C  
ATOM    570  CG2 VAL A  77      27.252 103.277 -13.333  1.00 30.14           C  
ATOM    571  N   PHE A  78      26.892 105.111 -17.682  1.00 34.72           N  
ATOM    572  CA  PHE A  78      27.141 105.144 -19.119  1.00 31.87           C  
ATOM    573  C   PHE A  78      28.641 105.216 -19.382  1.00 39.98           C  
ATOM    574  O   PHE A  78      29.382 105.885 -18.659  1.00 35.33           O  
ATOM    575  CB  PHE A  78      26.446 106.336 -19.791  1.00 24.99           C  
ATOM    576  CG  PHE A  78      24.950 106.183 -19.914  1.00 31.98           C  
ATOM    577  CD1 PHE A  78      24.114 106.401 -18.822  1.00 29.94           C  
ATOM    578  CD2 PHE A  78      24.381 105.775 -21.121  1.00 28.68           C  
ATOM    579  CE1 PHE A  78      22.734 106.219 -18.932  1.00 38.37           C  
ATOM    580  CE2 PHE A  78      22.998 105.587 -21.243  1.00 31.26           C  
ATOM    581  CZ  PHE A  78      22.175 105.809 -20.147  1.00 31.17           C  
ATOM    582  N   LYS A  79      29.075 104.515 -20.423  1.00 42.09           N  
ATOM    583  CA  LYS A  79      30.480 104.459 -20.810  1.00 42.98           C  
ATOM    584  C   LYS A  79      30.492 104.752 -22.310  1.00 42.03           C  
ATOM    585  O   LYS A  79      30.029 103.941 -23.109  1.00 42.68           O  
ATOM    586  CB  LYS A  79      31.011 103.051 -20.532  1.00 46.87           C  
ATOM    587  CG  LYS A  79      32.393 102.962 -19.904  1.00 48.83           C  
ATOM    588  CD  LYS A  79      33.484 103.472 -20.801  1.00 46.09           C  
ATOM    589  CE  LYS A  79      34.848 103.185 -20.179  1.00 53.03           C  
ATOM    590  N   ASP A  80      31.003 105.918 -22.683  1.00 43.48           N  
ATOM    591  CA  ASP A  80      31.053 106.336 -24.081  1.00 42.81           C  
ATOM    592  C   ASP A  80      29.726 106.139 -24.796  1.00 41.95           C  
ATOM    593  O   ASP A  80      29.646 105.460 -25.821  1.00 42.13           O  
ATOM    594  CB  ASP A  80      32.169 105.602 -24.828  1.00 42.95           C  
ATOM    595  CG  ASP A  80      33.550 105.977 -24.316  1.00 54.59           C  
ATOM    596  OD1 ASP A  80      33.849 107.192 -24.249  1.00 54.75           O  
ATOM    597  OD2 ASP A  80      34.335 105.062 -23.987  1.00 61.39           O  
ATOM    598  N   GLY A  81      28.683 106.731 -24.228  1.00 39.01           N  
ATOM    599  CA  GLY A  81      27.362 106.650 -24.813  1.00 34.96           C  
ATOM    600  C   GLY A  81      26.608 105.353 -24.633  1.00 32.66           C  
ATOM    601  O   GLY A  81      25.464 105.259 -25.061  1.00 41.25           O  
ATOM    602  N   GLN A  82      27.220 104.352 -24.008  1.00 38.54           N  
ATOM    603  CA  GLN A  82      26.539 103.068 -23.815  1.00 36.91           C  
ATOM    604  C   GLN A  82      26.312 102.711 -22.347  1.00 35.05           C  
ATOM    605  O   GLN A  82      27.203 102.884 -21.512  1.00 32.93           O  
ATOM    606  CB  GLN A  82      27.345 101.940 -24.479  1.00 38.65           C  
ATOM    607  CG  GLN A  82      27.393 101.983 -26.007  1.00 39.56           C  
ATOM    608  CD  GLN A  82      26.035 101.716 -26.628  1.00 46.20           C  
ATOM    609  OE1 GLN A  82      25.420 100.677 -26.377  1.00 41.32           O  
ATOM    610  NE2 GLN A  82      25.561 102.647 -27.444  1.00 41.10           N  
ATOM    611  N   PRO A  83      25.105 102.229 -22.006  1.00 34.47           N  
ATOM    612  CA  PRO A  83      24.817 101.851 -20.617  1.00 33.12           C  
ATOM    613  C   PRO A  83      25.599 100.567 -20.281  1.00 37.33           C  
ATOM    614  O   PRO A  83      25.501  99.565 -21.004  1.00 30.44           O  
ATOM    615  CB  PRO A  83      23.304 101.632 -20.640  1.00 29.47           C  
ATOM    616  CG  PRO A  83      23.101 101.044 -22.038  1.00 33.52           C  
ATOM    617  CD  PRO A  83      23.904 102.056 -22.846  1.00 30.64           C  
ATOM    618  N   VAL A  84      26.381 100.595 -19.203  1.00 32.75           N  
ATOM    619  CA  VAL A  84      27.180  99.428 -18.825  1.00 40.39           C  
ATOM    620  C   VAL A  84      26.814  98.845 -17.466  1.00 45.94           C  
ATOM    621  O   VAL A  84      27.174  97.707 -17.162  1.00 50.40           O  
ATOM    622  CB  VAL A  84      28.703  99.747 -18.819  1.00 33.28           C  
ATOM    623  CG1 VAL A  84      29.156 100.182 -20.201  1.00 36.68           C  
ATOM    624  CG2 VAL A  84      29.005 100.821 -17.803  1.00 32.90           C  
ATOM    625  N   ASP A  85      26.111  99.620 -16.645  1.00 44.95           N  
ATOM    626  CA  ASP A  85      25.700  99.140 -15.327  1.00 39.64           C  
ATOM    627  C   ASP A  85      24.421  99.817 -14.843  1.00 37.00           C  
ATOM    628  O   ASP A  85      24.075 100.911 -15.293  1.00 34.37           O  
ATOM    629  CB  ASP A  85      26.809  99.357 -14.300  1.00 39.32           C  
ATOM    630  CG  ASP A  85      27.199  98.071 -13.593  1.00 47.16           C  
ATOM    631  OD1 ASP A  85      26.289  97.319 -13.178  1.00 40.39           O  
ATOM    632  OD2 ASP A  85      28.413  97.820 -13.441  1.00 46.31           O  
ATOM    633  N   LYS A  86      23.730  99.165 -13.914  1.00 38.90           N  
ATOM    634  CA  LYS A  86      22.478  99.685 -13.376  1.00 39.11           C  
ATOM    635  C   LYS A  86      22.362  99.391 -11.884  1.00 41.31           C  
ATOM    636  O   LYS A  86      22.651  98.282 -11.439  1.00 43.59           O  
ATOM    637  CB  LYS A  86      21.309  99.047 -14.126  1.00 41.71           C  
ATOM    638  CG  LYS A  86      19.924  99.525 -13.723  1.00 54.64           C  
ATOM    639  CD  LYS A  86      18.858  98.862 -14.596  1.00 58.09           C  
ATOM    640  CE  LYS A  86      17.453  99.303 -14.211  1.00 65.89           C  
ATOM    641  N   VAL A  87      21.942 100.390 -11.118  1.00 41.75           N  
ATOM    642  CA  VAL A  87      21.771 100.246  -9.675  1.00 40.85           C  
ATOM    643  C   VAL A  87      20.376 100.747  -9.333  1.00 40.36           C  
ATOM    644  O   VAL A  87      19.975 101.822  -9.784  1.00 36.94           O  
ATOM    645  CB  VAL A  87      22.816 101.083  -8.901  1.00 41.46           C  
ATOM    646  CG1 VAL A  87      22.619 100.919  -7.422  1.00 46.12           C  
ATOM    647  CG2 VAL A  87      24.211 100.650  -9.284  1.00 45.18           C  
ATOM    648  N   VAL A  88      19.638  99.976  -8.539  1.00 37.85           N  
ATOM    649  CA  VAL A  88      18.278 100.358  -8.167  1.00 42.49           C  
ATOM    650  C   VAL A  88      18.102 100.575  -6.664  1.00 42.15           C  
ATOM    651  O   VAL A  88      18.763  99.925  -5.858  1.00 45.65           O  
ATOM    652  CB  VAL A  88      17.274  99.288  -8.640  1.00 45.38           C  
ATOM    653  CG1 VAL A  88      15.858  99.692  -8.271  1.00 58.19           C  
ATOM    654  CG2 VAL A  88      17.392  99.110 -10.146  1.00 48.87           C  
ATOM    655  N   GLY A  89      17.216 101.501  -6.299  1.00 38.81           N  
ATOM    656  CA  GLY A  89      16.956 101.788  -4.897  1.00 34.10           C  
ATOM    657  C   GLY A  89      18.059 102.553  -4.189  1.00 36.55           C  
ATOM    658  O   GLY A  89      19.104 102.825  -4.776  1.00 36.19           O  
ATOM    659  N   PHE A  90      17.830 102.901  -2.923  1.00 37.44           N  
ATOM    660  CA  PHE A  90      18.818 103.629  -2.141  1.00 34.11           C  
ATOM    661  C   PHE A  90      20.141 102.861  -2.051  1.00 35.78           C  
ATOM    662  O   PHE A  90      20.152 101.639  -1.894  1.00 36.53           O  
ATOM    663  CB  PHE A  90      18.316 103.878  -0.716  1.00 32.32           C  
ATOM    664  CG  PHE A  90      19.315 104.610   0.145  1.00 42.57           C  
ATOM    665  CD1 PHE A  90      19.509 105.982  -0.002  1.00 33.71           C  
ATOM    666  CD2 PHE A  90      20.134 103.909   1.031  1.00 37.56           C  
ATOM    667  CE1 PHE A  90      20.504 106.647   0.711  1.00 32.81           C  
ATOM    668  CE2 PHE A  90      21.133 104.563   1.748  1.00 33.02           C  
ATOM    669  CZ  PHE A  90      21.319 105.936   1.587  1.00 39.28           C  
ATOM    670  N   GLN A  91      21.253 103.581  -2.136  1.00 37.75           N  
ATOM    671  CA  GLN A  91      22.573 102.960  -2.044  1.00 43.40           C  
ATOM    672  C   GLN A  91      23.535 103.890  -1.318  1.00 41.45           C  
ATOM    673  O   GLN A  91      23.489 105.108  -1.506  1.00 41.34           O  
ATOM    674  CB  GLN A  91      23.147 102.673  -3.436  1.00 46.15           C  
ATOM    675  CG  GLN A  91      22.371 101.697  -4.304  1.00 52.93           C  
ATOM    676  CD  GLN A  91      22.385 100.280  -3.770  1.00 56.29           C  
ATOM    677  OE1 GLN A  91      23.431  99.767  -3.384  1.00 60.54           O  
ATOM    678  NE2 GLN A  91      21.227  99.630  -3.773  1.00 56.90           N  
ATOM    679  N   PRO A  92      24.415 103.328  -0.469  1.00 44.28           N  
ATOM    680  CA  PRO A  92      25.410 104.091   0.290  1.00 42.20           C  
ATOM    681  C   PRO A  92      26.498 104.566  -0.684  1.00 43.65           C  
ATOM    682  O   PRO A  92      26.732 103.929  -1.714  1.00 43.82           O  
ATOM    683  CB  PRO A  92      25.961 103.048   1.263  1.00 41.85           C  
ATOM    684  CG  PRO A  92      24.853 102.014   1.332  1.00 48.85           C  
ATOM    685  CD  PRO A  92      24.521 101.906  -0.120  1.00 47.73           C  
ATOM    686  N   LYS A  93      27.166 105.666  -0.355  1.00 41.06           N  
ATOM    687  CA  LYS A  93      28.221 106.206  -1.212  1.00 49.70           C  
ATOM    688  C   LYS A  93      29.277 105.154  -1.563  1.00 51.97           C  
ATOM    689  O   LYS A  93      29.769 105.115  -2.689  1.00 51.96           O  
ATOM    690  CB  LYS A  93      28.896 107.402  -0.530  1.00 43.60           C  
ATOM    691  CG  LYS A  93      29.919 108.125  -1.398  1.00 39.14           C  
ATOM    692  N   GLU A  94      29.614 104.304  -0.597  1.00 55.09           N  
ATOM    693  CA  GLU A  94      30.614 103.258  -0.796  1.00 56.23           C  
ATOM    694  C   GLU A  94      30.246 102.331  -1.944  1.00 55.77           C  
ATOM    695  O   GLU A  94      31.100 101.956  -2.747  1.00 57.46           O  
ATOM    696  CB  GLU A  94      30.786 102.431   0.484  1.00 54.44           C  
ATOM    697  N   ASN A  95      28.972 101.959  -2.014  1.00 58.97           N  
ATOM    698  CA  ASN A  95      28.489 101.072  -3.066  1.00 56.58           C  
ATOM    699  C   ASN A  95      28.441 101.731  -4.441  1.00 57.07           C  
ATOM    700  O   ASN A  95      28.639 101.064  -5.458  1.00 58.66           O  
ATOM    701  CB  ASN A  95      27.104 100.532  -2.705  1.00 61.79           C  
ATOM    702  CG  ASN A  95      27.152  99.532  -1.568  1.00 70.32           C  
ATOM    703  OD1 ASN A  95      27.719  98.449  -1.704  1.00 74.35           O  
ATOM    704  ND2 ASN A  95      26.565  99.895  -0.434  1.00 76.99           N  
ATOM    705  N   LEU A  96      28.184 103.035  -4.483  1.00 48.91           N  
ATOM    706  CA  LEU A  96      28.126 103.727  -5.763  1.00 46.71           C  
ATOM    707  C   LEU A  96      29.529 103.946  -6.313  1.00 50.59           C  
ATOM    708  O   LEU A  96      29.769 103.775  -7.514  1.00 46.33           O  
ATOM    709  CB  LEU A  96      27.396 105.067  -5.622  1.00 39.13           C  
ATOM    710  CG  LEU A  96      25.916 104.964  -5.233  1.00 44.36           C  
ATOM    711  CD1 LEU A  96      25.312 106.356  -5.109  1.00 38.33           C  
ATOM    712  CD2 LEU A  96      25.170 104.140  -6.278  1.00 33.45           C  
ATOM    713  N   ALA A  97      30.453 104.316  -5.430  1.00 48.68           N  
ATOM    714  CA  ALA A  97      31.834 104.551  -5.830  1.00 50.12           C  
ATOM    715  C   ALA A  97      32.415 103.264  -6.403  1.00 49.68           C  
ATOM    716  O   ALA A  97      33.142 103.287  -7.397  1.00 56.91           O  
ATOM    717  CB  ALA A  97      32.658 105.016  -4.641  1.00 46.34           C  
ATOM    718  N   GLU A  98      32.089 102.140  -5.783  1.00 38.36           N  
ATOM    719  CA  GLU A  98      32.588 100.866  -6.275  1.00 50.57           C  
ATOM    720  C   GLU A  98      32.143 100.658  -7.715  1.00 54.10           C  
ATOM    721  O   GLU A  98      32.962 100.359  -8.581  1.00 62.51           O  
ATOM    722  CB  GLU A  98      32.079  99.708  -5.413  1.00 40.06           C  
ATOM    723  N   VAL A  99      30.848 100.816  -7.974  1.00 52.85           N  
ATOM    724  CA  VAL A  99      30.320 100.630  -9.321  1.00 46.15           C  
ATOM    725  C   VAL A  99      31.022 101.512 -10.349  1.00 47.30           C  
ATOM    726  O   VAL A  99      31.237 101.090 -11.486  1.00 49.05           O  
ATOM    727  CB  VAL A  99      28.794 100.898  -9.380  1.00 47.23           C  
ATOM    728  CG1 VAL A  99      28.305 100.814 -10.817  1.00 39.35           C  
ATOM    729  CG2 VAL A  99      28.058  99.870  -8.533  1.00 39.27           C  
ATOM    730  N   LEU A 100      31.382 102.734  -9.966  1.00 40.39           N  
ATOM    731  CA  LEU A 100      32.065 103.620 -10.897  1.00 48.50           C  
ATOM    732  C   LEU A 100      33.494 103.149 -11.156  1.00 54.68           C  
ATOM    733  O   LEU A 100      33.928 103.059 -12.310  1.00 55.09           O  
ATOM    734  CB  LEU A 100      32.086 105.063 -10.374  1.00 49.60           C  
ATOM    735  CG  LEU A 100      30.799 105.881 -10.535  1.00 51.98           C  
ATOM    736  CD1 LEU A 100      30.976 107.254  -9.925  1.00 43.52           C  
ATOM    737  CD2 LEU A 100      30.463 106.019 -12.020  1.00 45.48           C  
ATOM    738  N   ASP A 101      34.220 102.837 -10.083  1.00 54.17           N  
ATOM    739  CA  ASP A 101      35.604 102.394 -10.219  1.00 56.80           C  
ATOM    740  C   ASP A 101      35.710 101.190 -11.144  1.00 54.38           C  
ATOM    741  O   ASP A 101      36.712 101.011 -11.837  1.00 52.53           O  
ATOM    742  CB  ASP A 101      36.208 102.041  -8.852  1.00 54.85           C  
ATOM    743  CG  ASP A 101      36.167 103.200  -7.872  1.00 59.86           C  
ATOM    744  OD1 ASP A 101      36.423 104.351  -8.285  1.00 53.91           O  
ATOM    745  OD2 ASP A 101      35.898 102.955  -6.676  1.00 73.43           O  
ATOM    746  N   LYS A 102      34.670 100.365 -11.151  1.00 50.39           N  
ATOM    747  CA  LYS A 102      34.646  99.176 -11.985  1.00 51.00           C  
ATOM    748  C   LYS A 102      34.596  99.520 -13.473  1.00 55.04           C  
ATOM    749  O   LYS A 102      34.734  98.635 -14.318  1.00 62.59           O  
ATOM    750  CB  LYS A 102      33.438  98.313 -11.614  1.00 43.99           C  
ATOM    751  CG  LYS A 102      33.248  97.084 -12.471  1.00 48.35           C  
ATOM    752  N   HIS A 103      34.414 100.798 -13.798  1.00 49.40           N  
ATOM    753  CA  HIS A 103      34.318 101.209 -15.196  1.00 50.98           C  
ATOM    754  C   HIS A 103      35.264 102.330 -15.577  1.00 47.40           C  
ATOM    755  O   HIS A 103      35.238 102.806 -16.704  1.00 46.64           O  
ATOM    756  CB  HIS A 103      32.876 101.626 -15.519  1.00 52.21           C  
ATOM    757  CG  HIS A 103      31.883 100.524 -15.328  1.00 41.87           C  
ATOM    758  ND1 HIS A 103      31.833  99.420 -16.149  1.00 52.82           N  
ATOM    759  CD2 HIS A 103      30.944 100.327 -14.374  1.00 48.47           C  
ATOM    760  CE1 HIS A 103      30.907  98.587 -15.710  1.00 54.67           C  
ATOM    761  NE2 HIS A 103      30.352  99.114 -14.631  1.00 54.75           N  
ATOM    762  N   LEU A 104      36.089 102.762 -14.633  1.00 54.44           N  
ATOM    763  CA  LEU A 104      37.059 103.817 -14.908  1.00 62.04           C  
ATOM    764  C   LEU A 104      38.415 103.201 -15.255  1.00 68.27           C  
ATOM    765  O   LEU A 104      38.490 101.951 -15.336  1.00 71.74           O  
ATOM    766  CB  LEU A 104      37.193 104.752 -13.704  1.00 52.03           C  
ATOM    767  CG  LEU A 104      35.989 105.664 -13.461  1.00 57.27           C  
ATOM    768  CD1 LEU A 104      36.166 106.452 -12.175  1.00 56.83           C  
ATOM    769  CD2 LEU A 104      35.836 106.605 -14.648  1.00 56.84           C  
ATOM    770  OXT LEU A 104      39.380 103.970 -15.457  1.00 77.06           O  
TER     771      LEU A 104                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
