
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  785),  selected  103 , name 2bto_T
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2bto_T.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    I    23_T      -       -           -
LGA    I    24_T      -       -           -
LGA    H    25_T      -       -           -
LGA    L    26_T      -       -           -
LGA    T    27_T      -       -           -
LGA    D    28_T      -       -           -
LGA    D    29_T      -       -           -
LGA    S    30_T      -       -           -
LGA    F    31_T      -       -           -
LGA    D    32_T      -       -           -
LGA    T    33_T      -       -           -
LGA    D    34_T      -       -           -
LGA    V    35_T      -       -           -
LGA    L    36_T      -       -           -
LGA    K    37_T      -       -           -
LGA    A    38_T      -       -           -
LGA    D    39_T      -       -           -
LGA    G    40_T      T      12          1.872
LGA    A    41_T      H      13          1.324
LGA    I    42_T      R      14          0.864
LGA    L    43_T      V      15          0.969
LGA    V    44_T      Q      16          0.861
LGA    D    45_T      I      17          1.212
LGA    F    46_T      E      18          1.506
LGA    W    47_T      Y      19          2.177
LGA    A    48_T      C      20          3.666
LGA    E    49_T      T      21          3.079
LGA    W    50_T      Q      22          1.837
LGA    C    51_T      C      23          1.740
LGA    G    52_T      R      24          4.333
LGA    P    53_T      W      25          4.571
LGA    C    54_T      L      26          4.825
LGA    K    55_T      P      27          3.119
LGA    M    56_T      R      28          2.541
LGA    I    57_T      A      29          3.553
LGA    A    58_T      A      30          2.048
LGA    P    59_T      W      31          1.359
LGA    I    60_T      L      32          2.446
LGA    L    61_T      A      33          1.627
LGA    D    62_T      Q      34          0.845
LGA    E    63_T      E      35          2.241
LGA    I    64_T      L      36          1.511
LGA    A    65_T      L      37          1.083
LGA    D    66_T      T      38          1.903
LGA    E    67_T      T      39          1.922
LGA    Y    68_T      F      40          0.831
LGA    Q    69_T      E      41          1.382
LGA    G    70_T      T      42          2.608
LGA    K    71_T      E      43          0.445
LGA    L    72_T      L      44          1.499
LGA    -       -      T      45           -
LGA    T    73_T      E      46          2.282
LGA    V    74_T      L      47          0.995
LGA    A    75_T      A      48          0.725
LGA    K    76_T      L      49          1.086
LGA    L    77_T      K      50          1.593
LGA    N    78_T      P      51          1.883
LGA    I    79_T      G      52          3.498
LGA    D    80_T      T      53           #
LGA    Q    81_T      -       -           -
LGA    N    82_T      -       -           -
LGA    P    83_T      -       -           -
LGA    G    84_T      -       -           -
LGA    T    85_T      -       -           -
LGA    A    86_T      -       -           -
LGA    P    87_T      -       -           -
LGA    K    88_T      -       -           -
LGA    Y    89_T      -       -           -
LGA    G    90_T      -       -           -
LGA    I    91_T      -       -           -
LGA    R    92_T      -       -           -
LGA    G    93_T      G      54          5.488
LGA    -       -      G      55           -
LGA    I    94_T      V      56          1.119
LGA    P    95_T      F      57          1.211
LGA    T    96_T      V      58          1.491
LGA    L    97_T      V      59          1.249
LGA    L    98_T      R      60          1.304
LGA    L    99_T      V      61          1.145
LGA    F   100_T      D      62          0.996
LGA    K   101_T      -       -           -
LGA    N   102_T      -       -           -
LGA    G   103_T      -       -           -
LGA    E   104_T      -       -           -
LGA    V   105_T      D      63          2.368
LGA    A   106_T      E      64          2.965
LGA    A   107_T      V      65          3.341
LGA    T   108_T      V      66          2.866
LGA    K   109_T      W      67          1.167
LGA    V   110_T      D      68          1.242
LGA    G   111_T      R      69          1.950
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    A   112_T      F      74          3.253
LGA    L   113_T      P      75          1.042
LGA    S   114_T      E      76          1.035
LGA    K   115_T      P      77          0.953
LGA    G   116_T      T      78          0.650
LGA    Q   117_T      A      79          0.926
LGA    L   118_T      V      80          1.200
LGA    K   119_T      K      81          0.766
LGA    E   120_T      R      82          0.999
LGA    F   121_T      L      83          0.905
LGA    L   122_T      V      84          0.887
LGA    D   123_T      R      85          1.673
LGA    A   124_T      D      86          1.468
LGA    N   125_T      R      87          1.431
LGA    -       -      V      88           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103   77    5.0     69    2.13    10.14     71.512     3.089

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.094981 * X  +  -0.138467 * Y  +   0.985802 * Z  +   4.837039
  Y_new =  -0.995479 * X  +  -0.013181 * Y  +   0.094062 * Z  + 175.028458
  Z_new =  -0.000031 * X  +  -0.990279 * Y  +  -0.139093 * Z  + -31.625044 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.710342    1.431251  [ DEG:   -97.9954     82.0046 ]
  Theta =   0.000031    3.141562  [ DEG:     0.0018    179.9982 ]
  Phi   =  -1.475672    1.665921  [ DEG:   -84.5498     95.4502 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bto_T                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bto_T.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103   77   5.0   69   2.13   10.14  71.512
REMARK  ---------------------------------------------------------- 
MOLECULE 2bto_T
HEADER    CYTOSKELETAL PROTEIN                    03-JUN-05   2BTO              
TITLE     STRUCTURE OF BTUBA FROM PROSTHECOBACTER DEJONGEII                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TUBULIN BTUBA;                                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: THIOREDOXIN 1;                                             
COMPND   7 CHAIN: T;                                                            
COMPND   8 SYNONYM: TRX1, TRX;                                                  
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PROSTHECOBACTER DEJONGEII;                      
SOURCE   3 ATCC: 27091;                                                         
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: C41(DE3);                                  
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET32(APDA10);                            
SOURCE   7 OTHER_DETAILS: GERMAN COLLECTION OF MICROORGANISMS (DSM              
SOURCE   8 12251);                                                              
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  11 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    BACTERIAL TUBULIN, POLYMERIZATION, CYTOSKELETON, PROTEIN              
KEYWDS   2 COMPLEX, CYTOSKELETAL PROTEIN                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.SCHLIEPER,J.LOWE                                                    
REVDAT   2   06-JUL-05 2BTO    1       JRNL                                     
REVDAT   1   23-JUN-05 2BTO    0                                                
JRNL        AUTH   D.SCHLIEPER,M.A.OLIVA,J.M.ANDREU,J.LOWE                      
JRNL        TITL   STRUCTURE OF BACTERIAL TUBULIN BTUBA/B: EVIDENCE             
JRNL        TITL 2 FOR HORIZONTAL GENE TRANSFER.                                
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 102  9170 2005              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2BTO A    1   473  UNP    Q8GCC5   Q8GCC5_9BACT     1    473             
DBREF  2BTO B    1   473  UNP    Q8GCC5   Q8GCC5_9BACT     1    473             
DBREF  2BTO T   20   127  UNP    P0AA25   THIO_ECOLI       1    108             
SEQRES   1 A  473  MET LYS VAL ASN ASN THR ILE VAL VAL SER ILE GLY GLN          
SEQRES   2 A  473  ALA GLY ASN GLN ILE ALA ALA SER PHE TRP LYS THR VAL          
SEQRES   3 A  473  CYS LEU GLU HIS GLY ILE ASP PRO LEU THR GLY GLN THR          
SEQRES   4 A  473  ALA PRO GLY VAL ALA PRO ARG GLY ASN TRP SER SER PHE          
SEQRES   5 A  473  PHE SER LYS LEU GLY GLU SER SER SER GLY SER TYR VAL          
SEQRES   6 A  473  PRO ARG ALA ILE MET VAL ASP LEU GLU PRO SER VAL ILE          
SEQRES   7 A  473  ASP ASN VAL LYS ALA THR SER GLY SER LEU PHE ASN PRO          
SEQRES   8 A  473  ALA ASN LEU ILE SER ARG THR GLU GLY ALA GLY GLY ASN          
SEQRES   9 A  473  PHE ALA VAL GLY TYR LEU GLY ALA GLY ARG GLU VAL LEU          
SEQRES  10 A  473  PRO GLU VAL MET SER ARG LEU ASP TYR GLU ILE ASP LYS          
SEQRES  11 A  473  CYS ASP ASN VAL GLY GLY ILE ILE VAL LEU HIS ALA ILE          
SEQRES  12 A  473  GLY GLY GLY THR GLY SER GLY PHE GLY ALA LEU LEU ILE          
SEQRES  13 A  473  GLU SER LEU LYS GLU LYS TYR GLY GLU ILE PRO VAL LEU          
SEQRES  14 A  473  SER CYS ALA VAL LEU PRO SER PRO GLN VAL SER SER VAL          
SEQRES  15 A  473  VAL THR GLU PRO TYR ASN THR VAL PHE ALA LEU ASN THR          
SEQRES  16 A  473  LEU ARG ARG SER ALA ASP ALA CYS LEU ILE PHE ASP ASN          
SEQRES  17 A  473  GLU ALA LEU PHE ASP LEU ALA HIS ARG LYS TRP ASN ILE          
SEQRES  18 A  473  GLU SER PRO THR VAL ASP ASP LEU ASN LEU LEU ILE THR          
SEQRES  19 A  473  GLU ALA LEU ALA GLY ILE THR ALA SER MET ARG PHE SER          
SEQRES  20 A  473  GLY PHE LEU THR VAL GLU ILE SER LEU ARG GLU LEU LEU          
SEQRES  21 A  473  THR ASN LEU VAL PRO GLN PRO SER LEU HIS PHE LEU MET          
SEQRES  22 A  473  CYS ALA PHE ALA PRO LEU THR PRO PRO ASP ARG SER LYS          
SEQRES  23 A  473  PHE GLU GLU LEU GLY ILE GLU GLU MET ILE LYS SER LEU          
SEQRES  24 A  473  PHE ASP ASN GLY SER VAL PHE ALA ALA CYS SER PRO MET          
SEQRES  25 A  473  GLU GLY ARG PHE LEU SER THR ALA VAL LEU TYR ARG GLY          
SEQRES  26 A  473  ILE MET GLU ASP LYS PRO LEU ALA ASP ALA ALA LEU ALA          
SEQRES  27 A  473  ALA MET ARG GLU LYS LEU PRO LEU THR TYR TRP ILE PRO          
SEQRES  28 A  473  THR ALA PHE LYS ILE GLY TYR VAL GLU GLN PRO GLY ILE          
SEQRES  29 A  473  SER HIS ARG LYS SER MET VAL LEU LEU ALA ASN ASN THR          
SEQRES  30 A  473  GLU ILE ALA ARG VAL LEU ASP ARG ILE CYS HIS ASN PHE          
SEQRES  31 A  473  ASP LYS LEU TRP GLN ARG LYS ALA PHE ALA ASN TRP TYR          
SEQRES  32 A  473  LEU ASN GLU GLY MET SER GLU GLU GLN ILE ASN VAL LEU          
SEQRES  33 A  473  ARG ALA SER ALA GLN GLU LEU VAL GLN SER TYR GLN VAL          
SEQRES  34 A  473  ALA GLU GLU SER GLY ALA LYS ALA LYS VAL GLN ASP SER          
SEQRES  35 A  473  ALA GLY ASP THR GLY MET ARG ALA ALA ALA ALA GLY VAL          
SEQRES  36 A  473  SER ASP ASP ALA ARG GLY SER MET SER LEU ARG ASP LEU          
SEQRES  37 A  473  VAL ASP ARG ARG ARG                                          
SEQRES   1 B  473  MET LYS VAL ASN ASN THR ILE VAL VAL SER ILE GLY GLN          
SEQRES   2 B  473  ALA GLY ASN GLN ILE ALA ALA SER PHE TRP LYS THR VAL          
SEQRES   3 B  473  CYS LEU GLU HIS GLY ILE ASP PRO LEU THR GLY GLN THR          
SEQRES   4 B  473  ALA PRO GLY VAL ALA PRO ARG GLY ASN TRP SER SER PHE          
SEQRES   5 B  473  PHE SER LYS LEU GLY GLU SER SER SER GLY SER TYR VAL          
SEQRES   6 B  473  PRO ARG ALA ILE MET VAL ASP LEU GLU PRO SER VAL ILE          
SEQRES   7 B  473  ASP ASN VAL LYS ALA THR SER GLY SER LEU PHE ASN PRO          
SEQRES   8 B  473  ALA ASN LEU ILE SER ARG THR GLU GLY ALA GLY GLY ASN          
SEQRES   9 B  473  PHE ALA VAL GLY TYR LEU GLY ALA GLY ARG GLU VAL LEU          
SEQRES  10 B  473  PRO GLU VAL MET SER ARG LEU ASP TYR GLU ILE ASP LYS          
SEQRES  11 B  473  CYS ASP ASN VAL GLY GLY ILE ILE VAL LEU HIS ALA ILE          
SEQRES  12 B  473  GLY GLY GLY THR GLY SER GLY PHE GLY ALA LEU LEU ILE          
SEQRES  13 B  473  GLU SER LEU LYS GLU LYS TYR GLY GLU ILE PRO VAL LEU          
SEQRES  14 B  473  SER CYS ALA VAL LEU PRO SER PRO GLN VAL SER SER VAL          
SEQRES  15 B  473  VAL THR GLU PRO TYR ASN THR VAL PHE ALA LEU ASN THR          
SEQRES  16 B  473  LEU ARG ARG SER ALA ASP ALA CYS LEU ILE PHE ASP ASN          
SEQRES  17 B  473  GLU ALA LEU PHE ASP LEU ALA HIS ARG LYS TRP ASN ILE          
SEQRES  18 B  473  GLU SER PRO THR VAL ASP ASP LEU ASN LEU LEU ILE THR          
SEQRES  19 B  473  GLU ALA LEU ALA GLY ILE THR ALA SER MET ARG PHE SER          
SEQRES  20 B  473  GLY PHE LEU THR VAL GLU ILE SER LEU ARG GLU LEU LEU          
SEQRES  21 B  473  THR ASN LEU VAL PRO GLN PRO SER LEU HIS PHE LEU MET          
SEQRES  22 B  473  CYS ALA PHE ALA PRO LEU THR PRO PRO ASP ARG SER LYS          
SEQRES  23 B  473  PHE GLU GLU LEU GLY ILE GLU GLU MET ILE LYS SER LEU          
SEQRES  24 B  473  PHE ASP ASN GLY SER VAL PHE ALA ALA CYS SER PRO MET          
SEQRES  25 B  473  GLU GLY ARG PHE LEU SER THR ALA VAL LEU TYR ARG GLY          
SEQRES  26 B  473  ILE MET GLU ASP LYS PRO LEU ALA ASP ALA ALA LEU ALA          
SEQRES  27 B  473  ALA MET ARG GLU LYS LEU PRO LEU THR TYR TRP ILE PRO          
SEQRES  28 B  473  THR ALA PHE LYS ILE GLY TYR VAL GLU GLN PRO GLY ILE          
SEQRES  29 B  473  SER HIS ARG LYS SER MET VAL LEU LEU ALA ASN ASN THR          
SEQRES  30 B  473  GLU ILE ALA ARG VAL LEU ASP ARG ILE CYS HIS ASN PHE          
SEQRES  31 B  473  ASP LYS LEU TRP GLN ARG LYS ALA PHE ALA ASN TRP TYR          
SEQRES  32 B  473  LEU ASN GLU GLY MET SER GLU GLU GLN ILE ASN VAL LEU          
SEQRES  33 B  473  ARG ALA SER ALA GLN GLU LEU VAL GLN SER TYR GLN VAL          
SEQRES  34 B  473  ALA GLU GLU SER GLY ALA LYS ALA LYS VAL GLN ASP SER          
SEQRES  35 B  473  ALA GLY ASP THR GLY MET ARG ALA ALA ALA ALA GLY VAL          
SEQRES  36 B  473  SER ASP ASP ALA ARG GLY SER MET SER LEU ARG ASP LEU          
SEQRES  37 B  473  VAL ASP ARG ARG ARG                                          
SEQRES   1 T  108  SER ASP LYS ILE ILE HIS LEU THR ASP ASP SER PHE ASP          
SEQRES   2 T  108  THR ASP VAL LEU LYS ALA ASP GLY ALA ILE LEU VAL ASP          
SEQRES   3 T  108  PHE TRP ALA GLU TRP CYS GLY PRO CYS LYS MET ILE ALA          
SEQRES   4 T  108  PRO ILE LEU ASP GLU ILE ALA ASP GLU TYR GLN GLY LYS          
SEQRES   5 T  108  LEU THR VAL ALA LYS LEU ASN ILE ASP GLN ASN PRO GLY          
SEQRES   6 T  108  THR ALA PRO LYS TYR GLY ILE ARG GLY ILE PRO THR LEU          
SEQRES   7 T  108  LEU LEU PHE LYS ASN GLY GLU VAL ALA ALA THR LYS VAL          
SEQRES   8 T  108  GLY ALA LEU SER LYS GLY GLN LEU LYS GLU PHE LEU ASP          
SEQRES   9 T  108  ALA ASN LEU ALA                                              
HET    GTP  A1433      32                                                       
HET    GTP  B1433      32                                                       
HETNAM     GTP GUANOSINE-5'-TRIPHOSPHATE                                        
FORMUL   4  GTP    2(C10 H16 N5 O14 P3)                                         
FORMUL   6  HOH   *216(H2 O)                                                    
CRYST1  180.539  180.539   84.229  90.00  90.00 120.00 P 3 2 1      12          
ATOM   6389  N   ILE T  23      26.127 119.850 -10.750  1.00 77.92           N  
ATOM   6390  CA  ILE T  23      24.806 119.152 -10.875  1.00 77.87           C  
ATOM   6391  C   ILE T  23      24.206 119.415 -12.260  1.00 77.61           C  
ATOM   6392  O   ILE T  23      23.859 120.552 -12.585  1.00 77.66           O  
ATOM   6393  CB  ILE T  23      23.827 119.564  -9.710  1.00 77.99           C  
ATOM   6394  CG1 ILE T  23      22.452 118.881  -9.859  1.00 77.99           C  
ATOM   6395  CG2 ILE T  23      23.736 121.112  -9.560  1.00 77.87           C  
ATOM   6396  CD1 ILE T  23      21.569 118.983  -8.604  1.00 78.02           C  
ATOM   6397  N   ILE T  24      24.107 118.370 -13.081  1.00 77.40           N  
ATOM   6398  CA  ILE T  24      23.575 118.531 -14.445  1.00 77.17           C  
ATOM   6399  C   ILE T  24      22.124 118.056 -14.571  1.00 76.84           C  
ATOM   6400  O   ILE T  24      21.831 116.866 -14.396  1.00 76.98           O  
ATOM   6401  CB  ILE T  24      24.465 117.838 -15.529  1.00 77.24           C  
ATOM   6402  CG1 ILE T  24      25.862 118.469 -15.575  1.00 77.35           C  
ATOM   6403  CG2 ILE T  24      23.804 117.916 -16.914  1.00 77.19           C  
ATOM   6404  CD1 ILE T  24      26.813 117.821 -16.583  1.00 77.23           C  
ATOM   6405  N   HIS T  25      21.225 118.996 -14.867  1.00 76.18           N  
ATOM   6406  CA  HIS T  25      19.833 118.668 -15.164  1.00 75.60           C  
ATOM   6407  C   HIS T  25      19.670 118.405 -16.649  1.00 75.07           C  
ATOM   6408  O   HIS T  25      20.341 119.021 -17.476  1.00 75.04           O  
ATOM   6409  CB  HIS T  25      18.882 119.771 -14.692  1.00 75.72           C  
ATOM   6410  CG  HIS T  25      18.510 119.664 -13.244  1.00 76.20           C  
ATOM   6411  ND1 HIS T  25      19.294 120.177 -12.231  1.00 76.51           N  
ATOM   6412  CD2 HIS T  25      17.440 119.095 -12.637  1.00 76.52           C  
ATOM   6413  CE1 HIS T  25      18.724 119.932 -11.065  1.00 76.57           C  
ATOM   6414  NE2 HIS T  25      17.597 119.277 -11.282  1.00 76.48           N  
ATOM   6415  N   LEU T  26      18.785 117.472 -16.979  1.00 74.38           N  
ATOM   6416  CA  LEU T  26      18.572 117.072 -18.360  1.00 73.81           C  
ATOM   6417  C   LEU T  26      17.106 117.209 -18.743  1.00 73.53           C  
ATOM   6418  O   LEU T  26      16.227 117.191 -17.882  1.00 73.43           O  
ATOM   6419  CB  LEU T  26      19.009 115.617 -18.569  1.00 73.75           C  
ATOM   6420  CG  LEU T  26      20.336 115.099 -18.008  1.00 73.60           C  
ATOM   6421  CD1 LEU T  26      20.317 113.582 -17.967  1.00 73.80           C  
ATOM   6422  CD2 LEU T  26      21.527 115.595 -18.803  1.00 73.65           C  
ATOM   6423  N   THR T  27      16.855 117.361 -20.038  1.00 73.13           N  
ATOM   6424  CA  THR T  27      15.519 117.190 -20.600  1.00 72.83           C  
ATOM   6425  C   THR T  27      15.587 116.014 -21.578  1.00 72.73           C  
ATOM   6426  O   THR T  27      16.655 115.429 -21.765  1.00 72.56           O  
ATOM   6427  CB  THR T  27      15.002 118.475 -21.324  1.00 72.86           C  
ATOM   6428  OG1 THR T  27      15.782 118.728 -22.500  1.00 72.44           O  
ATOM   6429  CG2 THR T  27      15.047 119.695 -20.398  1.00 72.75           C  
ATOM   6430  N   ASP T  28      14.458 115.660 -22.188  1.00 72.68           N  
ATOM   6431  CA  ASP T  28      14.449 114.671 -23.271  1.00 72.72           C  
ATOM   6432  C   ASP T  28      15.194 115.207 -24.491  1.00 72.52           C  
ATOM   6433  O   ASP T  28      15.866 114.453 -25.200  1.00 72.31           O  
ATOM   6434  CB  ASP T  28      13.015 114.306 -23.671  1.00 73.08           C  
ATOM   6435  CG  ASP T  28      12.239 113.649 -22.546  1.00 73.53           C  
ATOM   6436  OD1 ASP T  28      11.144 114.149 -22.215  1.00 74.06           O  
ATOM   6437  OD2 ASP T  28      12.717 112.634 -21.992  1.00 73.91           O  
ATOM   6438  N   ASP T  29      15.066 116.513 -24.719  1.00 72.27           N  
ATOM   6439  CA  ASP T  29      15.702 117.191 -25.843  1.00 72.02           C  
ATOM   6440  C   ASP T  29      17.218 117.258 -25.688  1.00 71.66           C  
ATOM   6441  O   ASP T  29      17.944 117.181 -26.673  1.00 71.69           O  
ATOM   6442  CB  ASP T  29      15.128 118.604 -26.015  1.00 72.33           C  
ATOM   6443  CG  ASP T  29      13.607 118.614 -26.141  1.00 72.71           C  
ATOM   6444  OD1 ASP T  29      13.057 119.669 -26.530  1.00 72.74           O  
ATOM   6445  OD2 ASP T  29      12.963 117.577 -25.850  1.00 73.24           O  
ATOM   6446  N   SER T  30      17.693 117.391 -24.453  1.00 71.20           N  
ATOM   6447  CA  SER T  30      19.126 117.550 -24.205  1.00 70.77           C  
ATOM   6448  C   SER T  30      19.879 116.235 -23.965  1.00 70.45           C  
ATOM   6449  O   SER T  30      21.112 116.217 -23.979  1.00 70.24           O  
ATOM   6450  CB  SER T  30      19.372 118.540 -23.062  1.00 70.78           C  
ATOM   6451  OG  SER T  30      18.618 118.200 -21.915  1.00 70.94           O  
ATOM   6452  N   PHE T  31      19.143 115.143 -23.771  1.00 70.16           N  
ATOM   6453  CA  PHE T  31      19.747 113.842 -23.472  1.00 70.00           C  
ATOM   6454  C   PHE T  31      20.796 113.431 -24.499  1.00 70.11           C  
ATOM   6455  O   PHE T  31      21.907 113.050 -24.135  1.00 70.05           O  
ATOM   6456  CB  PHE T  31      18.680 112.747 -23.341  1.00 69.76           C  
ATOM   6457  CG  PHE T  31      19.131 111.550 -22.538  1.00 69.37           C  
ATOM   6458  CD1 PHE T  31      18.970 111.524 -21.154  1.00 69.20           C  
ATOM   6459  CD2 PHE T  31      19.725 110.454 -23.161  1.00 68.89           C  
ATOM   6460  CE1 PHE T  31      19.384 110.421 -20.397  1.00 68.55           C  
ATOM   6461  CE2 PHE T  31      20.146 109.351 -22.419  1.00 69.24           C  
ATOM   6462  CZ  PHE T  31      19.972 109.338 -21.024  1.00 69.03           C  
ATOM   6463  N   ASP T  32      20.439 113.518 -25.776  1.00 70.46           N  
ATOM   6464  CA  ASP T  32      21.336 113.144 -26.866  1.00 70.76           C  
ATOM   6465  C   ASP T  32      22.723 113.783 -26.722  1.00 70.86           C  
ATOM   6466  O   ASP T  32      23.717 113.070 -26.583  1.00 70.93           O  
ATOM   6467  CB  ASP T  32      20.713 113.502 -28.218  1.00 70.85           C  
ATOM   6468  CG  ASP T  32      21.217 112.626 -29.351  1.00 71.10           C  
ATOM   6469  OD1 ASP T  32      21.258 113.116 -30.503  1.00 71.58           O  
ATOM   6470  OD2 ASP T  32      21.558 111.450 -29.102  1.00 70.86           O  
ATOM   6471  N   THR T  33      22.780 115.115 -26.724  1.00 70.85           N  
ATOM   6472  CA  THR T  33      24.053 115.840 -26.632  1.00 70.89           C  
ATOM   6473  C   THR T  33      24.727 115.638 -25.277  1.00 70.94           C  
ATOM   6474  O   THR T  33      25.903 115.274 -25.216  1.00 71.01           O  
ATOM   6475  CB  THR T  33      23.890 117.358 -26.919  1.00 70.86           C  
ATOM   6476  OG1 THR T  33      23.237 117.546 -28.181  1.00 70.81           O  
ATOM   6477  CG2 THR T  33      25.250 118.060 -26.956  1.00 70.91           C  
ATOM   6478  N   ASP T  34      23.975 115.859 -24.199  1.00 70.96           N  
ATOM   6479  CA  ASP T  34      24.525 115.818 -22.841  1.00 71.02           C  
ATOM   6480  C   ASP T  34      25.000 114.431 -22.419  1.00 71.04           C  
ATOM   6481  O   ASP T  34      26.056 114.306 -21.804  1.00 71.27           O  
ATOM   6482  CB  ASP T  34      23.515 116.358 -21.827  1.00 71.04           C  
ATOM   6483  CG  ASP T  34      23.169 117.821 -22.059  1.00 71.21           C  
ATOM   6484  OD1 ASP T  34      22.321 118.352 -21.314  1.00 71.40           O  
ATOM   6485  OD2 ASP T  34      23.735 118.444 -22.983  1.00 71.55           O  
ATOM   6486  N   VAL T  35      24.233 113.397 -22.754  1.00 70.90           N  
ATOM   6487  CA  VAL T  35      24.573 112.035 -22.343  1.00 70.75           C  
ATOM   6488  C   VAL T  35      25.247 111.191 -23.440  1.00 70.69           C  
ATOM   6489  O   VAL T  35      26.331 110.644 -23.218  1.00 71.04           O  
ATOM   6490  CB  VAL T  35      23.345 111.275 -21.767  1.00 70.75           C  
ATOM   6491  CG1 VAL T  35      23.749 109.884 -21.307  1.00 70.56           C  
ATOM   6492  CG2 VAL T  35      22.718 112.049 -20.614  1.00 70.61           C  
ATOM   6493  N   LEU T  36      24.612 111.086 -24.607  1.00 70.28           N  
ATOM   6494  CA  LEU T  36      25.032 110.116 -25.632  1.00 69.94           C  
ATOM   6495  C   LEU T  36      26.231 110.552 -26.477  1.00 69.89           C  
ATOM   6496  O   LEU T  36      27.080 109.730 -26.827  1.00 69.81           O  
ATOM   6497  CB  LEU T  36      23.853 109.728 -26.538  1.00 69.72           C  
ATOM   6498  CG  LEU T  36      22.596 109.174 -25.855  1.00 69.44           C  
ATOM   6499  CD1 LEU T  36      21.488 108.918 -26.869  1.00 68.79           C  
ATOM   6500  CD2 LEU T  36      22.904 107.907 -25.041  1.00 69.04           C  
ATOM   6501  N   LYS T  37      26.294 111.839 -26.804  1.00 69.81           N  
ATOM   6502  CA  LYS T  37      27.396 112.382 -27.599  1.00 69.83           C  
ATOM   6503  C   LYS T  37      28.571 112.773 -26.698  1.00 69.69           C  
ATOM   6504  O   LYS T  37      29.596 113.267 -27.176  1.00 69.69           O  
ATOM   6505  CB  LYS T  37      26.929 113.594 -28.420  1.00 69.91           C  
ATOM   6506  CG  LYS T  37      25.604 113.409 -29.167  1.00 70.06           C  
ATOM   6507  CD  LYS T  37      25.786 113.084 -30.643  1.00 70.13           C  
ATOM   6508  CE  LYS T  37      24.481 113.333 -31.407  1.00 70.23           C  
ATOM   6509  NZ  LYS T  37      24.656 113.421 -32.886  1.00 70.12           N  
ATOM   6510  N   ALA T  38      28.414 112.536 -25.396  1.00 69.57           N  
ATOM   6511  CA  ALA T  38      29.389 112.963 -24.397  1.00 69.44           C  
ATOM   6512  C   ALA T  38      30.675 112.154 -24.436  1.00 69.32           C  
ATOM   6513  O   ALA T  38      30.661 110.937 -24.618  1.00 69.25           O  
ATOM   6514  CB  ALA T  38      28.784 112.909 -23.002  1.00 69.47           C  
ATOM   6515  N   ASP T  39      31.786 112.859 -24.274  1.00 69.23           N  
ATOM   6516  CA  ASP T  39      33.077 112.230 -24.076  1.00 69.10           C  
ATOM   6517  C   ASP T  39      33.188 111.888 -22.588  1.00 69.01           C  
ATOM   6518  O   ASP T  39      32.686 112.627 -21.737  1.00 68.96           O  
ATOM   6519  CB  ASP T  39      34.190 113.191 -24.504  1.00 68.99           C  
ATOM   6520  CG  ASP T  39      35.433 112.471 -25.002  1.00 68.93           C  
ATOM   6521  OD1 ASP T  39      35.956 112.868 -26.066  1.00 68.57           O  
ATOM   6522  OD2 ASP T  39      35.890 111.517 -24.334  1.00 68.88           O  
ATOM   6523  N   GLY T  40      33.817 110.756 -22.279  1.00 68.87           N  
ATOM   6524  CA  GLY T  40      34.014 110.345 -20.890  1.00 68.76           C  
ATOM   6525  C   GLY T  40      32.758 109.794 -20.233  1.00 68.76           C  
ATOM   6526  O   GLY T  40      31.648 109.964 -20.746  1.00 68.86           O  
ATOM   6527  N   ALA T  41      32.945 109.147 -19.083  1.00 68.57           N  
ATOM   6528  CA  ALA T  41      31.870 108.449 -18.368  1.00 68.46           C  
ATOM   6529  C   ALA T  41      30.858 109.386 -17.698  1.00 68.42           C  
ATOM   6530  O   ALA T  41      31.219 110.468 -17.223  1.00 68.33           O  
ATOM   6531  CB  ALA T  41      32.462 107.477 -17.350  1.00 68.34           C  
ATOM   6532  N   ILE T  42      29.597 108.952 -17.651  1.00 68.41           N  
ATOM   6533  CA  ILE T  42      28.509 109.764 -17.090  1.00 68.48           C  
ATOM   6534  C   ILE T  42      27.439 108.938 -16.356  1.00 68.40           C  
ATOM   6535  O   ILE T  42      26.998 107.896 -16.845  1.00 68.39           O  
ATOM   6536  CB  ILE T  42      27.900 110.730 -18.157  1.00 68.53           C  
ATOM   6537  CG1 ILE T  42      26.671 111.473 -17.617  1.00 68.49           C  
ATOM   6538  CG2 ILE T  42      27.602 109.995 -19.458  1.00 68.87           C  
ATOM   6539  CD1 ILE T  42      26.423 112.816 -18.308  1.00 68.83           C  
ATOM   6540  N   LEU T  43      27.045 109.414 -15.175  1.00 68.42           N  
ATOM   6541  CA  LEU T  43      26.067 108.723 -14.338  1.00 68.47           C  
ATOM   6542  C   LEU T  43      24.755 109.489 -14.287  1.00 68.49           C  
ATOM   6543  O   LEU T  43      24.720 110.641 -13.852  1.00 68.58           O  
ATOM   6544  CB  LEU T  43      26.615 108.511 -12.919  1.00 68.41           C  
ATOM   6545  CG  LEU T  43      25.760 107.695 -11.940  1.00 68.41           C  
ATOM   6546  CD1 LEU T  43      25.666 106.230 -12.363  1.00 68.54           C  
ATOM   6547  CD2 LEU T  43      26.305 107.805 -10.529  1.00 68.38           C  
ATOM   6548  N   VAL T  44      23.682 108.843 -14.728  1.00 68.48           N  
ATOM   6549  CA  VAL T  44      22.378 109.489 -14.801  1.00 68.71           C  
ATOM   6550  C   VAL T  44      21.423 108.972 -13.727  1.00 68.87           C  
ATOM   6551  O   VAL T  44      21.216 107.762 -13.583  1.00 69.11           O  
ATOM   6552  CB  VAL T  44      21.753 109.356 -16.213  1.00 68.81           C  
ATOM   6553  CG1 VAL T  44      20.409 110.076 -16.294  1.00 68.81           C  
ATOM   6554  CG2 VAL T  44      22.701 109.917 -17.263  1.00 69.00           C  
ATOM   6555  N   ASP T  45      20.847 109.910 -12.983  1.00 68.85           N  
ATOM   6556  CA  ASP T  45      19.896 109.601 -11.930  1.00 68.98           C  
ATOM   6557  C   ASP T  45      18.481 109.925 -12.398  1.00 68.96           C  
ATOM   6558  O   ASP T  45      18.080 111.090 -12.417  1.00 68.86           O  
ATOM   6559  CB  ASP T  45      20.258 110.385 -10.658  1.00 69.08           C  
ATOM   6560  CG  ASP T  45      19.359 110.052  -9.466  1.00 69.49           C  
ATOM   6561  OD1 ASP T  45      19.235 110.911  -8.570  1.00 70.41           O  
ATOM   6562  OD2 ASP T  45      18.785 108.946  -9.401  1.00 69.82           O  
ATOM   6563  N   PHE T  46      17.744 108.889 -12.800  1.00 69.06           N  
ATOM   6564  CA  PHE T  46      16.319 109.017 -13.103  1.00 69.28           C  
ATOM   6565  C   PHE T  46      15.574 109.035 -11.786  1.00 69.44           C  
ATOM   6566  O   PHE T  46      15.721 108.105 -10.986  1.00 69.53           O  
ATOM   6567  CB  PHE T  46      15.817 107.834 -13.929  1.00 69.36           C  
ATOM   6568  CG  PHE T  46      16.459 107.709 -15.280  1.00 69.70           C  
ATOM   6569  CD1 PHE T  46      15.915 108.357 -16.384  1.00 69.69           C  
ATOM   6570  CD2 PHE T  46      17.594 106.926 -15.456  1.00 69.80           C  
ATOM   6571  CE1 PHE T  46      16.502 108.238 -17.643  1.00 69.68           C  
ATOM   6572  CE2 PHE T  46      18.185 106.802 -16.714  1.00 70.19           C  
ATOM   6573  CZ  PHE T  46      17.640 107.456 -17.806  1.00 69.50           C  
ATOM   6574  N   TRP T  47      14.765 110.069 -11.572  1.00 69.60           N  
ATOM   6575  CA  TRP T  47      14.182 110.328 -10.254  1.00 70.03           C  
ATOM   6576  C   TRP T  47      12.874 111.125 -10.295  1.00 70.30           C  
ATOM   6577  O   TRP T  47      12.451 111.598 -11.355  1.00 70.45           O  
ATOM   6578  CB  TRP T  47      15.210 111.063  -9.383  1.00 70.06           C  
ATOM   6579  CG  TRP T  47      15.390 112.529  -9.738  1.00 70.19           C  
ATOM   6580  CD1 TRP T  47      15.933 113.043 -10.887  1.00 70.11           C  
ATOM   6581  CD2 TRP T  47      15.029 113.653  -8.928  1.00 70.10           C  
ATOM   6582  NE1 TRP T  47      15.924 114.414 -10.841  1.00 70.17           N  
ATOM   6583  CE2 TRP T  47      15.379 114.816  -9.649  1.00 70.15           C  
ATOM   6584  CE3 TRP T  47      14.446 113.791  -7.658  1.00 70.43           C  
ATOM   6585  CZ2 TRP T  47      15.161 116.103  -9.145  1.00 70.07           C  
ATOM   6586  CZ3 TRP T  47      14.232 115.069  -7.156  1.00 70.28           C  
ATOM   6587  CH2 TRP T  47      14.587 116.209  -7.903  1.00 70.31           C  
ATOM   6588  N   ALA T  48      12.247 111.268  -9.127  1.00 70.72           N  
ATOM   6589  CA  ALA T  48      11.066 112.123  -8.953  1.00 71.16           C  
ATOM   6590  C   ALA T  48      10.988 112.717  -7.541  1.00 71.43           C  
ATOM   6591  O   ALA T  48      11.668 112.253  -6.622  1.00 71.35           O  
ATOM   6592  CB  ALA T  48       9.796 111.353  -9.283  1.00 71.18           C  
ATOM   6593  N   GLU T  49      10.161 113.748  -7.383  1.00 71.88           N  
ATOM   6594  CA  GLU T  49       9.967 114.403  -6.090  1.00 72.29           C  
ATOM   6595  C   GLU T  49       9.148 113.529  -5.130  1.00 72.55           C  
ATOM   6596  O   GLU T  49       9.385 113.527  -3.918  1.00 72.47           O  
ATOM   6597  CB  GLU T  49       9.301 115.772  -6.282  1.00 72.44           C  
ATOM   6598  CG  GLU T  49       9.164 116.617  -4.999  1.00 72.55           C  
ATOM   6599  CD  GLU T  49      10.404 117.450  -4.669  1.00 72.88           C  
ATOM   6600  OE1 GLU T  49      11.500 117.161  -5.199  1.00 72.76           O  
ATOM   6601  OE2 GLU T  49      10.276 118.408  -3.865  1.00 73.54           O  
ATOM   6602  N   TRP T  50       8.198 112.781  -5.687  1.00 72.84           N  
ATOM   6603  CA  TRP T  50       7.300 111.926  -4.908  1.00 73.04           C  
ATOM   6604  C   TRP T  50       7.901 110.553  -4.579  1.00 73.08           C  
ATOM   6605  O   TRP T  50       7.204 109.661  -4.087  1.00 73.01           O  
ATOM   6606  CB  TRP T  50       5.974 111.760  -5.653  1.00 73.18           C  
ATOM   6607  CG  TRP T  50       6.145 111.346  -7.078  1.00 73.31           C  
ATOM   6608  CD1 TRP T  50       6.124 112.161  -8.169  1.00 73.46           C  
ATOM   6609  CD2 TRP T  50       6.380 110.019  -7.572  1.00 73.39           C  
ATOM   6610  NE1 TRP T  50       6.324 111.427  -9.315  1.00 73.57           N  
ATOM   6611  CE2 TRP T  50       6.485 110.111  -8.977  1.00 73.52           C  
ATOM   6612  CE3 TRP T  50       6.506 108.764  -6.965  1.00 73.33           C  
ATOM   6613  CZ2 TRP T  50       6.715 108.994  -9.787  1.00 73.33           C  
ATOM   6614  CZ3 TRP T  50       6.736 107.655  -7.768  1.00 73.30           C  
ATOM   6615  CH2 TRP T  50       6.836 107.779  -9.166  1.00 73.41           C  
ATOM   6616  N   CYS T  51       9.192 110.394  -4.863  1.00 73.25           N  
ATOM   6617  CA  CYS T  51       9.933 109.172  -4.562  1.00 73.17           C  
ATOM   6618  C   CYS T  51      10.784 109.376  -3.321  1.00 73.08           C  
ATOM   6619  O   CYS T  51      11.760 110.131  -3.346  1.00 73.09           O  
ATOM   6620  CB  CYS T  51      10.808 108.793  -5.756  1.00 73.52           C  
ATOM   6621  SG  CYS T  51      12.261 107.707  -5.475  1.00 73.96           S  
ATOM   6622  N   GLY T  52      10.397 108.708  -2.234  1.00 72.85           N  
ATOM   6623  CA  GLY T  52      11.127 108.786  -0.968  1.00 72.57           C  
ATOM   6624  C   GLY T  52      12.615 108.529  -1.148  1.00 72.37           C  
ATOM   6625  O   GLY T  52      13.428 109.424  -0.919  1.00 72.33           O  
ATOM   6626  N   PRO T  53      12.976 107.303  -1.572  1.00 72.17           N  
ATOM   6627  CA  PRO T  53      14.356 106.880  -1.810  1.00 72.20           C  
ATOM   6628  C   PRO T  53      15.194 107.757  -2.739  1.00 72.45           C  
ATOM   6629  O   PRO T  53      16.419 107.739  -2.630  1.00 72.39           O  
ATOM   6630  CB  PRO T  53      14.187 105.497  -2.428  1.00 72.09           C  
ATOM   6631  CG  PRO T  53      12.912 105.003  -1.867  1.00 72.15           C  
ATOM   6632  CD  PRO T  53      12.027 106.201  -1.813  1.00 72.03           C  
ATOM   6633  N   CYS T  54      14.556 108.496  -3.647  1.00 72.92           N  
ATOM   6634  CA  CYS T  54      15.280 109.377  -4.573  1.00 73.47           C  
ATOM   6635  C   CYS T  54      15.872 110.572  -3.843  1.00 73.83           C  
ATOM   6636  O   CYS T  54      17.004 110.972  -4.117  1.00 74.23           O  
ATOM   6637  CB  CYS T  54      14.383 109.857  -5.716  1.00 73.54           C  
ATOM   6638  SG  CYS T  54      13.677 108.524  -6.724  1.00 74.36           S  
ATOM   6639  N   LYS T  55      15.100 111.136  -2.916  1.00 73.92           N  
ATOM   6640  CA  LYS T  55      15.553 112.245  -2.084  1.00 74.15           C  
ATOM   6641  C   LYS T  55      16.699 111.811  -1.170  1.00 74.13           C  
ATOM   6642  O   LYS T  55      17.593 112.603  -0.862  1.00 74.03           O  
ATOM   6643  CB  LYS T  55      14.394 112.792  -1.243  1.00 74.24           C  
ATOM   6644  CG  LYS T  55      13.399 113.671  -2.000  1.00 74.45           C  
ATOM   6645  CD  LYS T  55      12.437 114.353  -1.027  1.00 74.38           C  
ATOM   6646  CE  LYS T  55      11.727 115.539  -1.671  1.00 74.66           C  
ATOM   6647  NZ  LYS T  55      11.292 116.555  -0.652  1.00 74.93           N  
ATOM   6648  N   MET T  56      16.652 110.546  -0.753  1.00 74.20           N  
ATOM   6649  CA  MET T  56      17.646 109.927   0.128  1.00 74.29           C  
ATOM   6650  C   MET T  56      19.077 110.022  -0.423  1.00 74.18           C  
ATOM   6651  O   MET T  56      20.030 110.218   0.337  1.00 74.05           O  
ATOM   6652  CB  MET T  56      17.249 108.460   0.392  1.00 74.38           C  
ATOM   6653  CG  MET T  56      18.096 107.703   1.414  1.00 74.46           C  
ATOM   6654  SD  MET T  56      17.128 106.552   2.422  1.00 74.95           S  
ATOM   6655  CE  MET T  56      17.227 105.003   1.519  1.00 74.46           C  
ATOM   6656  N   ILE T  57      19.216 109.901  -1.742  1.00 74.19           N  
ATOM   6657  CA  ILE T  57      20.535 109.858  -2.388  1.00 74.10           C  
ATOM   6658  C   ILE T  57      20.970 111.175  -3.046  1.00 73.96           C  
ATOM   6659  O   ILE T  57      22.110 111.297  -3.510  1.00 73.92           O  
ATOM   6660  CB  ILE T  57      20.645 108.685  -3.406  1.00 74.14           C  
ATOM   6661  CG1 ILE T  57      19.502 108.732  -4.423  1.00 73.90           C  
ATOM   6662  CG2 ILE T  57      20.684 107.347  -2.668  1.00 74.29           C  
ATOM   6663  CD1 ILE T  57      19.768 107.927  -5.665  1.00 74.43           C  
ATOM   6664  N   ALA T  58      20.069 112.154  -3.082  1.00 73.80           N  
ATOM   6665  CA  ALA T  58      20.397 113.488  -3.589  1.00 73.68           C  
ATOM   6666  C   ALA T  58      21.633 114.099  -2.897  1.00 73.51           C  
ATOM   6667  O   ALA T  58      22.533 114.589  -3.582  1.00 73.75           O  
ATOM   6668  CB  ALA T  58      19.186 114.427  -3.499  1.00 73.64           C  
ATOM   6669  N   PRO T  59      21.696 114.063  -1.547  1.00 73.20           N  
ATOM   6670  CA  PRO T  59      22.929 114.552  -0.924  1.00 73.10           C  
ATOM   6671  C   PRO T  59      24.143 113.646  -1.161  1.00 72.80           C  
ATOM   6672  O   PRO T  59      25.277 114.132  -1.141  1.00 72.88           O  
ATOM   6673  CB  PRO T  59      22.584 114.601   0.577  1.00 73.15           C  
ATOM   6674  CG  PRO T  59      21.096 114.452   0.655  1.00 73.26           C  
ATOM   6675  CD  PRO T  59      20.715 113.636  -0.535  1.00 73.16           C  
ATOM   6676  N   ILE T  60      23.907 112.351  -1.376  1.00 72.30           N  
ATOM   6677  CA  ILE T  60      24.986 111.395  -1.646  1.00 71.98           C  
ATOM   6678  C   ILE T  60      25.630 111.666  -3.011  1.00 71.87           C  
ATOM   6679  O   ILE T  60      26.854 111.642  -3.137  1.00 71.73           O  
ATOM   6680  CB  ILE T  60      24.495 109.909  -1.589  1.00 72.00           C  
ATOM   6681  CG1 ILE T  60      23.813 109.580  -0.245  1.00 72.01           C  
ATOM   6682  CG2 ILE T  60      25.641 108.938  -1.910  1.00 71.85           C  
ATOM   6683  CD1 ILE T  60      24.741 109.091   0.871  1.00 71.83           C  
ATOM   6684  N   LEU T  61      24.802 111.931  -4.021  1.00 71.70           N  
ATOM   6685  CA  LEU T  61      25.283 112.137  -5.390  1.00 71.67           C  
ATOM   6686  C   LEU T  61      26.193 113.365  -5.533  1.00 71.81           C  
ATOM   6687  O   LEU T  61      27.069 113.399  -6.399  1.00 71.85           O  
ATOM   6688  CB  LEU T  61      24.104 112.211  -6.368  1.00 71.55           C  
ATOM   6689  CG  LEU T  61      23.345 110.915  -6.690  1.00 71.41           C  
ATOM   6690  CD1 LEU T  61      21.875 111.187  -6.972  1.00 70.95           C  
ATOM   6691  CD2 LEU T  61      23.985 110.152  -7.844  1.00 71.14           C  
ATOM   6692  N   ASP T  62      25.989 114.358  -4.669  1.00 71.89           N  
ATOM   6693  CA  ASP T  62      26.821 115.560  -4.649  1.00 72.02           C  
ATOM   6694  C   ASP T  62      28.278 115.268  -4.277  1.00 71.98           C  
ATOM   6695  O   ASP T  62      29.189 115.891  -4.830  1.00 72.06           O  
ATOM   6696  CB  ASP T  62      26.239 116.612  -3.695  1.00 72.13           C  
ATOM   6697  CG  ASP T  62      24.869 117.109  -4.130  1.00 72.35           C  
ATOM   6698  OD1 ASP T  62      23.984 117.231  -3.259  1.00 72.35           O  
ATOM   6699  OD2 ASP T  62      24.673 117.372  -5.339  1.00 72.65           O  
ATOM   6700  N   GLU T  63      28.490 114.335  -3.343  1.00 71.76           N  
ATOM   6701  CA  GLU T  63      29.840 113.968  -2.880  1.00 71.68           C  
ATOM   6702  C   GLU T  63      30.662 113.320  -3.990  1.00 71.56           C  
ATOM   6703  O   GLU T  63      31.868 113.561  -4.106  1.00 71.66           O  
ATOM   6704  CB  GLU T  63      29.788 113.031  -1.665  1.00 71.61           C  
ATOM   6705  CG  GLU T  63      29.448 113.701  -0.337  1.00 71.60           C  
ATOM   6706  CD  GLU T  63      29.629 112.761   0.864  1.00 71.65           C  
ATOM   6707  OE1 GLU T  63      30.769 112.244   1.081  1.00 71.47           O  
ATOM   6708  OE2 GLU T  63      28.629 112.551   1.603  1.00 71.66           O  
ATOM   6709  N   ILE T  64      29.993 112.497  -4.795  1.00 71.38           N  
ATOM   6710  CA  ILE T  64      30.614 111.791  -5.916  1.00 71.23           C  
ATOM   6711  C   ILE T  64      30.969 112.765  -7.043  1.00 71.15           C  
ATOM   6712  O   ILE T  64      31.976 112.586  -7.734  1.00 71.03           O  
ATOM   6713  CB  ILE T  64      29.712 110.620  -6.410  1.00 71.15           C  
ATOM   6714  CG1 ILE T  64      29.848 109.414  -5.479  1.00 71.20           C  
ATOM   6715  CG2 ILE T  64      30.064 110.182  -7.821  1.00 71.03           C  
ATOM   6716  CD1 ILE T  64      28.993 109.484  -4.233  1.00 71.21           C  
ATOM   6717  N   ALA T  65      30.150 113.803  -7.202  1.00 71.12           N  
ATOM   6718  CA  ALA T  65      30.423 114.876  -8.157  1.00 71.29           C  
ATOM   6719  C   ALA T  65      31.726 115.623  -7.836  1.00 71.28           C  
ATOM   6720  O   ALA T  65      32.315 116.257  -8.713  1.00 71.34           O  
ATOM   6721  CB  ALA T  65      29.246 115.844  -8.221  1.00 71.29           C  
ATOM   6722  N   ASP T  66      32.172 115.533  -6.584  1.00 71.30           N  
ATOM   6723  CA  ASP T  66      33.439 116.128  -6.160  1.00 71.49           C  
ATOM   6724  C   ASP T  66      34.599 115.149  -6.336  1.00 71.40           C  
ATOM   6725  O   ASP T  66      35.574 115.448  -7.032  1.00 71.41           O  
ATOM   6726  CB  ASP T  66      33.368 116.580  -4.691  1.00 71.62           C  
ATOM   6727  CG  ASP T  66      32.241 117.566  -4.427  1.00 71.82           C  
ATOM   6728  OD1 ASP T  66      31.329 117.693  -5.275  1.00 72.29           O  
ATOM   6729  OD2 ASP T  66      32.264 118.208  -3.355  1.00 71.83           O  
ATOM   6730  N   GLU T  67      34.468 113.981  -5.705  1.00 71.23           N  
ATOM   6731  CA  GLU T  67      35.541 112.984  -5.621  1.00 70.99           C  
ATOM   6732  C   GLU T  67      35.882 112.283  -6.938  1.00 70.86           C  
ATOM   6733  O   GLU T  67      36.918 111.624  -7.039  1.00 70.97           O  
ATOM   6734  CB  GLU T  67      35.215 111.948  -4.540  1.00 70.92           C  
ATOM   6735  CG  GLU T  67      35.520 112.428  -3.124  1.00 70.89           C  
ATOM   6736  CD  GLU T  67      34.722 111.695  -2.061  1.00 70.59           C  
ATOM   6737  OE1 GLU T  67      33.992 112.405  -1.201  1.00 70.95           O  
ATOM   6738  OE2 GLU T  67      34.630 110.294  -2.078  1.00 70.18           O  
ATOM   6739  N   TYR T  68      35.018 112.423  -7.940  1.00 70.48           N  
ATOM   6740  CA  TYR T  68      35.269 111.828  -9.251  1.00 70.24           C  
ATOM   6741  C   TYR T  68      35.376 112.901 -10.347  1.00 70.12           C  
ATOM   6742  O   TYR T  68      34.897 112.718 -11.468  1.00 70.09           O  
ATOM   6743  CB  TYR T  68      34.206 110.765  -9.574  1.00 70.13           C  
ATOM   6744  CG  TYR T  68      34.274 109.536  -8.679  1.00 70.02           C  
ATOM   6745  CD1 TYR T  68      33.662 109.524  -7.424  1.00 69.82           C  
ATOM   6746  CD2 TYR T  68      34.951 108.386  -9.090  1.00 69.90           C  
ATOM   6747  CE1 TYR T  68      33.725 108.401  -6.602  1.00 69.82           C  
ATOM   6748  CE2 TYR T  68      35.019 107.258  -8.276  1.00 69.68           C  
ATOM   6749  CZ  TYR T  68      34.405 107.274  -7.033  1.00 69.84           C  
ATOM   6750  OH  TYR T  68      34.469 106.163  -6.221  1.00 69.71           O  
ATOM   6751  N   GLN T  69      36.022 114.013 -10.001  1.00 70.00           N  
ATOM   6752  CA  GLN T  69      36.242 115.133 -10.914  1.00 69.92           C  
ATOM   6753  C   GLN T  69      37.094 114.690 -12.102  1.00 69.78           C  
ATOM   6754  O   GLN T  69      38.153 114.084 -11.922  1.00 69.74           O  
ATOM   6755  CB  GLN T  69      36.938 116.276 -10.171  1.00 69.98           C  
ATOM   6756  CG  GLN T  69      36.616 117.672 -10.692  1.00 70.18           C  
ATOM   6757  CD  GLN T  69      35.585 118.398  -9.840  1.00 70.24           C  
ATOM   6758  OE1 GLN T  69      35.856 119.481  -9.312  1.00 70.02           O  
ATOM   6759  NE2 GLN T  69      34.400 117.807  -9.699  1.00 69.96           N  
ATOM   6760  N   GLY T  70      36.623 114.979 -13.312  1.00 69.65           N  
ATOM   6761  CA  GLY T  70      37.303 114.537 -14.529  1.00 69.50           C  
ATOM   6762  C   GLY T  70      37.026 113.079 -14.860  1.00 69.47           C  
ATOM   6763  O   GLY T  70      36.825 112.735 -16.027  1.00 69.55           O  
ATOM   6764  N   LYS T  71      37.012 112.228 -13.830  1.00 69.33           N  
ATOM   6765  CA  LYS T  71      36.747 110.784 -13.972  1.00 69.11           C  
ATOM   6766  C   LYS T  71      35.278 110.462 -14.272  1.00 68.89           C  
ATOM   6767  O   LYS T  71      34.972 109.426 -14.871  1.00 68.75           O  
ATOM   6768  CB  LYS T  71      37.219 110.006 -12.729  1.00 69.10           C  
ATOM   6769  CG  LYS T  71      38.719 110.135 -12.440  1.00 69.25           C  
ATOM   6770  CD  LYS T  71      39.245 109.028 -11.527  1.00 69.16           C  
ATOM   6771  CE  LYS T  71      40.746 109.195 -11.286  1.00 68.88           C  
ATOM   6772  NZ  LYS T  71      41.369 107.992 -10.671  1.00 68.44           N  
ATOM   6773  N   LEU T  72      34.381 111.356 -13.859  1.00 68.67           N  
ATOM   6774  CA  LEU T  72      32.941 111.166 -14.029  1.00 68.45           C  
ATOM   6775  C   LEU T  72      32.180 112.490 -14.012  1.00 68.26           C  
ATOM   6776  O   LEU T  72      32.561 113.434 -13.318  1.00 68.14           O  
ATOM   6777  CB  LEU T  72      32.401 110.247 -12.922  1.00 68.57           C  
ATOM   6778  CG  LEU T  72      30.916 109.871 -12.852  1.00 68.60           C  
ATOM   6779  CD1 LEU T  72      30.553 108.879 -13.946  1.00 68.75           C  
ATOM   6780  CD2 LEU T  72      30.577 109.295 -11.484  1.00 68.59           C  
ATOM   6781  N   THR T  73      31.102 112.546 -14.786  1.00 68.06           N  
ATOM   6782  CA  THR T  73      30.142 113.643 -14.703  1.00 67.91           C  
ATOM   6783  C   THR T  73      28.775 113.087 -14.270  1.00 67.84           C  
ATOM   6784  O   THR T  73      28.356 112.028 -14.740  1.00 67.75           O  
ATOM   6785  CB  THR T  73      30.079 114.474 -16.026  1.00 67.85           C  
ATOM   6786  OG1 THR T  73      28.841 115.190 -16.099  1.00 67.68           O  
ATOM   6787  CG2 THR T  73      30.223 113.585 -17.258  1.00 67.81           C  
ATOM   6788  N   VAL T  74      28.102 113.792 -13.360  1.00 67.76           N  
ATOM   6789  CA  VAL T  74      26.861 113.302 -12.742  1.00 67.69           C  
ATOM   6790  C   VAL T  74      25.625 114.089 -13.197  1.00 67.64           C  
ATOM   6791  O   VAL T  74      25.529 115.296 -12.972  1.00 67.75           O  
ATOM   6792  CB  VAL T  74      26.964 113.306 -11.187  1.00 67.75           C  
ATOM   6793  CG1 VAL T  74      25.648 112.875 -10.544  1.00 67.65           C  
ATOM   6794  CG2 VAL T  74      28.105 112.409 -10.720  1.00 67.63           C  
ATOM   6795  N   ALA T  75      24.682 113.390 -13.823  1.00 67.59           N  
ATOM   6796  CA  ALA T  75      23.495 114.027 -14.396  1.00 67.67           C  
ATOM   6797  C   ALA T  75      22.181 113.513 -13.809  1.00 67.66           C  
ATOM   6798  O   ALA T  75      22.096 112.378 -13.349  1.00 67.42           O  
ATOM   6799  CB  ALA T  75      23.499 113.877 -15.912  1.00 67.73           C  
ATOM   6800  N   LYS T  76      21.157 114.363 -13.841  1.00 67.82           N  
ATOM   6801  CA  LYS T  76      19.845 114.038 -13.285  1.00 67.96           C  
ATOM   6802  C   LYS T  76      18.740 114.329 -14.291  1.00 67.94           C  
ATOM   6803  O   LYS T  76      18.758 115.356 -14.976  1.00 67.72           O  
ATOM   6804  CB  LYS T  76      19.582 114.842 -12.005  1.00 68.05           C  
ATOM   6805  CG  LYS T  76      20.313 114.347 -10.770  1.00 68.21           C  
ATOM   6806  CD  LYS T  76      19.942 115.171  -9.548  1.00 68.30           C  
ATOM   6807  CE  LYS T  76      20.288 114.431  -8.268  1.00 68.80           C  
ATOM   6808  NZ  LYS T  76      20.200 115.306  -7.056  1.00 69.05           N  
ATOM   6809  N   LEU T  77      17.766 113.426 -14.341  1.00 68.03           N  
ATOM   6810  CA  LEU T  77      16.616 113.551 -15.220  1.00 68.17           C  
ATOM   6811  C   LEU T  77      15.340 113.265 -14.430  1.00 68.31           C  
ATOM   6812  O   LEU T  77      15.141 112.158 -13.936  1.00 68.27           O  
ATOM   6813  CB  LEU T  77      16.757 112.583 -16.398  1.00 68.27           C  
ATOM   6814  CG  LEU T  77      15.724 112.592 -17.526  1.00 68.41           C  
ATOM   6815  CD1 LEU T  77      16.403 112.226 -18.816  1.00 68.33           C  
ATOM   6816  CD2 LEU T  77      14.562 111.642 -17.250  1.00 68.56           C  
ATOM   6817  N   ASN T  78      14.483 114.273 -14.312  1.00 68.73           N  
ATOM   6818  CA  ASN T  78      13.238 114.146 -13.557  1.00 69.03           C  
ATOM   6819  C   ASN T  78      12.135 113.564 -14.438  1.00 69.03           C  
ATOM   6820  O   ASN T  78      11.622 114.249 -15.331  1.00 69.29           O  
ATOM   6821  CB  ASN T  78      12.830 115.506 -12.979  1.00 68.99           C  
ATOM   6822  CG  ASN T  78      11.653 115.413 -12.024  1.00 69.14           C  
ATOM   6823  OD1 ASN T  78      11.795 115.661 -10.827  1.00 69.85           O  
ATOM   6824  ND2 ASN T  78      10.482 115.062 -12.550  1.00 68.93           N  
ATOM   6825  N   ILE T  79      11.756 112.317 -14.164  1.00 68.88           N  
ATOM   6826  CA  ILE T  79      10.894 111.549 -15.074  1.00 68.99           C  
ATOM   6827  C   ILE T  79       9.459 112.063 -15.268  1.00 69.21           C  
ATOM   6828  O   ILE T  79       8.798 111.693 -16.240  1.00 69.17           O  
ATOM   6829  CB  ILE T  79      10.872 110.026 -14.750  1.00 68.97           C  
ATOM   6830  CG1 ILE T  79      10.330 109.762 -13.341  1.00 68.44           C  
ATOM   6831  CG2 ILE T  79      12.256 109.399 -14.979  1.00 68.99           C  
ATOM   6832  CD1 ILE T  79       9.754 108.363 -13.166  1.00 67.58           C  
ATOM   6833  N   ASP T  80       8.987 112.901 -14.348  1.00 69.47           N  
ATOM   6834  CA  ASP T  80       7.664 113.513 -14.472  1.00 69.92           C  
ATOM   6835  C   ASP T  80       7.631 114.527 -15.607  1.00 70.19           C  
ATOM   6836  O   ASP T  80       6.776 114.448 -16.490  1.00 70.42           O  
ATOM   6837  CB  ASP T  80       7.245 114.205 -13.174  1.00 69.82           C  
ATOM   6838  CG  ASP T  80       6.880 113.229 -12.077  1.00 69.95           C  
ATOM   6839  OD1 ASP T  80       6.487 112.082 -12.380  1.00 69.68           O  
ATOM   6840  OD2 ASP T  80       6.975 113.627 -10.899  1.00 70.23           O  
ATOM   6841  N   GLN T  81       8.569 115.472 -15.573  1.00 70.41           N  
ATOM   6842  CA  GLN T  81       8.626 116.558 -16.554  1.00 70.42           C  
ATOM   6843  C   GLN T  81       9.339 116.172 -17.852  1.00 70.69           C  
ATOM   6844  O   GLN T  81       9.373 116.961 -18.805  1.00 70.95           O  
ATOM   6845  CB  GLN T  81       9.250 117.817 -15.940  1.00 70.54           C  
ATOM   6846  CG  GLN T  81      10.513 117.585 -15.117  1.00 70.25           C  
ATOM   6847  CD  GLN T  81      11.023 118.857 -14.476  1.00 69.89           C  
ATOM   6848  OE1 GLN T  81      11.158 119.885 -15.137  1.00 69.82           O  
ATOM   6849  NE2 GLN T  81      11.311 118.796 -13.185  1.00 69.34           N  
ATOM   6850  N   ASN T  82       9.898 114.960 -17.874  1.00 70.63           N  
ATOM   6851  CA  ASN T  82      10.526 114.390 -19.065  1.00 70.71           C  
ATOM   6852  C   ASN T  82      10.201 112.896 -19.213  1.00 70.71           C  
ATOM   6853  O   ASN T  82      11.084 112.053 -19.039  1.00 70.90           O  
ATOM   6854  CB  ASN T  82      12.046 114.588 -19.018  1.00 70.78           C  
ATOM   6855  CG  ASN T  82      12.457 116.045 -19.067  1.00 70.69           C  
ATOM   6856  OD1 ASN T  82      12.116 116.772 -19.999  1.00 71.15           O  
ATOM   6857  ND2 ASN T  82      13.212 116.475 -18.064  1.00 70.47           N  
ATOM   6858  N   PRO T  83       8.934 112.559 -19.540  1.00 70.60           N  
ATOM   6859  CA  PRO T  83       8.490 111.159 -19.519  1.00 70.45           C  
ATOM   6860  C   PRO T  83       9.028 110.296 -20.663  1.00 70.38           C  
ATOM   6861  O   PRO T  83       8.832 109.074 -20.659  1.00 70.38           O  
ATOM   6862  CB  PRO T  83       6.965 111.277 -19.611  1.00 70.43           C  
ATOM   6863  CG  PRO T  83       6.734 112.536 -20.338  1.00 70.52           C  
ATOM   6864  CD  PRO T  83       7.844 113.468 -19.940  1.00 70.56           C  
ATOM   6865  N   GLY T  84       9.719 110.921 -21.613  1.00 70.26           N  
ATOM   6866  CA  GLY T  84      10.150 110.250 -22.840  1.00 70.08           C  
ATOM   6867  C   GLY T  84      11.374 109.348 -22.792  1.00 69.70           C  
ATOM   6868  O   GLY T  84      11.487 108.429 -23.600  1.00 70.23           O  
ATOM   6869  N   THR T  85      12.291 109.593 -21.860  1.00 69.25           N  
ATOM   6870  CA  THR T  85      13.593 108.910 -21.881  1.00 68.93           C  
ATOM   6871  C   THR T  85      13.653 107.547 -21.174  1.00 68.91           C  
ATOM   6872  O   THR T  85      14.167 106.588 -21.741  1.00 69.04           O  
ATOM   6873  CB  THR T  85      14.730 109.831 -21.390  1.00 68.78           C  
ATOM   6874  OG1 THR T  85      14.672 111.069 -22.105  1.00 69.00           O  
ATOM   6875  CG2 THR T  85      16.088 109.193 -21.629  1.00 68.37           C  
ATOM   6876  N   ALA T  86      13.131 107.462 -19.952  1.00 68.79           N  
ATOM   6877  CA  ALA T  86      13.221 106.233 -19.166  1.00 68.89           C  
ATOM   6878  C   ALA T  86      12.692 104.964 -19.869  1.00 69.11           C  
ATOM   6879  O   ALA T  86      13.359 103.928 -19.840  1.00 68.98           O  
ATOM   6880  CB  ALA T  86      12.576 106.415 -17.807  1.00 68.49           C  
ATOM   6881  N   PRO T  87      11.497 105.034 -20.487  1.00 69.36           N  
ATOM   6882  CA  PRO T  87      10.969 103.880 -21.225  1.00 69.52           C  
ATOM   6883  C   PRO T  87      11.924 103.321 -22.292  1.00 69.77           C  
ATOM   6884  O   PRO T  87      11.894 102.116 -22.571  1.00 70.09           O  
ATOM   6885  CB  PRO T  87       9.716 104.441 -21.897  1.00 69.47           C  
ATOM   6886  CG  PRO T  87       9.299 105.551 -21.017  1.00 69.77           C  
ATOM   6887  CD  PRO T  87      10.554 106.169 -20.516  1.00 69.37           C  
ATOM   6888  N   LYS T  88      12.757 104.180 -22.877  1.00 69.76           N  
ATOM   6889  CA  LYS T  88      13.733 103.752 -23.886  1.00 69.69           C  
ATOM   6890  C   LYS T  88      14.830 102.862 -23.307  1.00 69.62           C  
ATOM   6891  O   LYS T  88      15.438 102.072 -24.033  1.00 70.02           O  
ATOM   6892  CB  LYS T  88      14.354 104.958 -24.598  1.00 69.81           C  
ATOM   6893  CG  LYS T  88      13.398 105.673 -25.541  1.00 70.09           C  
ATOM   6894  CD  LYS T  88      13.885 107.068 -25.914  1.00 70.61           C  
ATOM   6895  CE  LYS T  88      13.009 107.670 -27.012  1.00 70.53           C  
ATOM   6896  NZ  LYS T  88      13.150 109.142 -27.087  1.00 70.65           N  
ATOM   6897  N   TYR T  89      15.071 102.978 -22.004  1.00 69.30           N  
ATOM   6898  CA  TYR T  89      16.162 102.255 -21.357  1.00 69.13           C  
ATOM   6899  C   TYR T  89      15.714 101.082 -20.475  1.00 68.95           C  
ATOM   6900  O   TYR T  89      16.540 100.451 -19.815  1.00 68.82           O  
ATOM   6901  CB  TYR T  89      17.092 103.234 -20.612  1.00 69.36           C  
ATOM   6902  CG  TYR T  89      17.874 104.083 -21.584  1.00 69.72           C  
ATOM   6903  CD1 TYR T  89      17.429 105.347 -21.945  1.00 69.91           C  
ATOM   6904  CD2 TYR T  89      19.032 103.593 -22.193  1.00 70.09           C  
ATOM   6905  CE1 TYR T  89      18.124 106.113 -22.868  1.00 70.25           C  
ATOM   6906  CE2 TYR T  89      19.741 104.351 -23.116  1.00 69.79           C  
ATOM   6907  CZ  TYR T  89      19.283 105.609 -23.451  1.00 70.29           C  
ATOM   6908  OH  TYR T  89      19.975 106.372 -24.375  1.00 70.49           O  
ATOM   6909  N   GLY T  90      14.417 100.774 -20.501  1.00 68.79           N  
ATOM   6910  CA  GLY T  90      13.849  99.673 -19.712  1.00 68.79           C  
ATOM   6911  C   GLY T  90      13.951  99.862 -18.201  1.00 68.90           C  
ATOM   6912  O   GLY T  90      14.276  98.916 -17.474  1.00 68.78           O  
ATOM   6913  N   ILE T  91      13.686 101.084 -17.741  1.00 68.89           N  
ATOM   6914  CA  ILE T  91      13.692 101.432 -16.323  1.00 69.20           C  
ATOM   6915  C   ILE T  91      12.486 100.805 -15.617  1.00 69.19           C  
ATOM   6916  O   ILE T  91      11.352 100.944 -16.071  1.00 69.54           O  
ATOM   6917  CB  ILE T  91      13.740 102.983 -16.136  1.00 69.69           C  
ATOM   6918  CG1 ILE T  91      15.186 103.447 -15.971  1.00 70.24           C  
ATOM   6919  CG2 ILE T  91      12.911 103.470 -14.943  1.00 69.16           C  
ATOM   6920  CD1 ILE T  91      15.787 104.003 -17.231  1.00 71.64           C  
ATOM   6921  N   ARG T  92      12.752 100.113 -14.514  1.00 68.96           N  
ATOM   6922  CA  ARG T  92      11.738  99.356 -13.781  1.00 69.17           C  
ATOM   6923  C   ARG T  92      11.198 100.130 -12.575  1.00 69.05           C  
ATOM   6924  O   ARG T  92      10.238  99.698 -11.919  1.00 69.15           O  
ATOM   6925  CB  ARG T  92      12.349  98.055 -13.271  1.00 69.60           C  
ATOM   6926  CG  ARG T  92      13.279  97.404 -14.250  1.00 70.77           C  
ATOM   6927  CD  ARG T  92      13.859  96.130 -13.697  1.00 72.31           C  
ATOM   6928  NE  ARG T  92      14.385  95.318 -14.793  1.00 73.47           N  
ATOM   6929  CZ  ARG T  92      13.726  94.311 -15.356  1.00 73.31           C  
ATOM   6930  NH1 ARG T  92      14.287  93.631 -16.355  1.00 72.41           N  
ATOM   6931  NH2 ARG T  92      12.515  93.978 -14.902  1.00 72.68           N  
ATOM   6932  N   GLY T  93      11.835 101.260 -12.281  1.00 68.19           N  
ATOM   6933  CA  GLY T  93      11.463 102.071 -11.147  1.00 67.77           C  
ATOM   6934  C   GLY T  93      12.524 103.101 -10.828  1.00 67.39           C  
ATOM   6935  O   GLY T  93      13.498 103.249 -11.565  1.00 67.39           O  
ATOM   6936  N   ILE T  94      12.328 103.810  -9.726  1.00 66.88           N  
ATOM   6937  CA  ILE T  94      13.222 104.893  -9.346  1.00 66.69           C  
ATOM   6938  C   ILE T  94      13.577 104.801  -7.871  1.00 66.37           C  
ATOM   6939  O   ILE T  94      12.800 104.252  -7.090  1.00 66.09           O  
ATOM   6940  CB  ILE T  94      12.663 106.298  -9.743  1.00 66.76           C  
ATOM   6941  CG1 ILE T  94      11.140 106.350  -9.634  1.00 66.78           C  
ATOM   6942  CG2 ILE T  94      13.012 106.610 -11.185  1.00 66.92           C  
ATOM   6943  CD1 ILE T  94      10.625 107.247  -8.587  1.00 66.24           C  
ATOM   6944  N   PRO T  95      14.780 105.285  -7.492  1.00 66.29           N  
ATOM   6945  CA  PRO T  95      15.797 105.842  -8.388  1.00 66.31           C  
ATOM   6946  C   PRO T  95      16.542 104.783  -9.207  1.00 66.43           C  
ATOM   6947  O   PRO T  95      16.766 103.670  -8.734  1.00 66.39           O  
ATOM   6948  CB  PRO T  95      16.756 106.539  -7.429  1.00 66.23           C  
ATOM   6949  CG  PRO T  95      16.641 105.772  -6.168  1.00 66.21           C  
ATOM   6950  CD  PRO T  95      15.222 105.311  -6.086  1.00 66.26           C  
ATOM   6951  N   THR T  96      16.897 105.134 -10.439  1.00 66.61           N  
ATOM   6952  CA  THR T  96      17.757 104.292 -11.260  1.00 66.73           C  
ATOM   6953  C   THR T  96      19.006 105.073 -11.686  1.00 66.92           C  
ATOM   6954  O   THR T  96      18.916 106.137 -12.321  1.00 66.64           O  
ATOM   6955  CB  THR T  96      17.011 103.695 -12.489  1.00 66.60           C  
ATOM   6956  OG1 THR T  96      16.150 102.637 -12.063  1.00 66.72           O  
ATOM   6957  CG2 THR T  96      17.982 103.104 -13.474  1.00 66.79           C  
ATOM   6958  N   LEU T  97      20.165 104.546 -11.306  1.00 66.87           N  
ATOM   6959  CA  LEU T  97      21.425 105.115 -11.734  1.00 67.35           C  
ATOM   6960  C   LEU T  97      21.895 104.367 -12.960  1.00 67.55           C  
ATOM   6961  O   LEU T  97      21.990 103.139 -12.939  1.00 67.50           O  
ATOM   6962  CB  LEU T  97      22.472 105.033 -10.625  1.00 67.46           C  
ATOM   6963  CG  LEU T  97      22.130 105.725  -9.305  1.00 67.49           C  
ATOM   6964  CD1 LEU T  97      23.235 105.487  -8.321  1.00 67.57           C  
ATOM   6965  CD2 LEU T  97      21.915 107.215  -9.515  1.00 67.57           C  
ATOM   6966  N   LEU T  98      22.159 105.111 -14.033  1.00 67.66           N  
ATOM   6967  CA  LEU T  98      22.717 104.542 -15.246  1.00 67.76           C  
ATOM   6968  C   LEU T  98      24.102 105.116 -15.535  1.00 68.23           C  
ATOM   6969  O   LEU T  98      24.288 106.340 -15.554  1.00 68.20           O  
ATOM   6970  CB  LEU T  98      21.763 104.747 -16.429  1.00 67.57           C  
ATOM   6971  CG  LEU T  98      20.947 103.555 -16.956  1.00 67.37           C  
ATOM   6972  CD1 LEU T  98      20.439 102.633 -15.874  1.00 67.64           C  
ATOM   6973  CD2 LEU T  98      19.787 104.007 -17.807  1.00 67.33           C  
ATOM   6974  N   LEU T  99      25.073 104.225 -15.731  1.00 68.66           N  
ATOM   6975  CA  LEU T  99      26.415 104.631 -16.131  1.00 69.28           C  
ATOM   6976  C   LEU T  99      26.549 104.544 -17.642  1.00 69.83           C  
ATOM   6977  O   LEU T  99      26.363 103.473 -18.220  1.00 70.05           O  
ATOM   6978  CB  LEU T  99      27.477 103.754 -15.466  1.00 69.30           C  
ATOM   6979  CG  LEU T  99      28.930 104.236 -15.588  1.00 69.22           C  
ATOM   6980  CD1 LEU T  99      29.196 105.432 -14.684  1.00 68.78           C  
ATOM   6981  CD2 LEU T  99      29.899 103.114 -15.276  1.00 69.09           C  
ATOM   6982  N   PHE T 100      26.855 105.680 -18.268  1.00 70.39           N  
ATOM   6983  CA  PHE T 100      27.088 105.762 -19.713  1.00 70.80           C  
ATOM   6984  C   PHE T 100      28.565 106.030 -19.983  1.00 71.22           C  
ATOM   6985  O   PHE T 100      29.218 106.724 -19.202  1.00 71.38           O  
ATOM   6986  CB  PHE T 100      26.278 106.905 -20.322  1.00 70.73           C  
ATOM   6987  CG  PHE T 100      24.800 106.654 -20.388  1.00 70.78           C  
ATOM   6988  CD1 PHE T 100      24.219 106.183 -21.554  1.00 70.53           C  
ATOM   6989  CD2 PHE T 100      23.980 106.925 -19.294  1.00 71.10           C  
ATOM   6990  CE1 PHE T 100      22.849 105.966 -21.633  1.00 70.67           C  
ATOM   6991  CE2 PHE T 100      22.604 106.709 -19.364  1.00 70.88           C  
ATOM   6992  CZ  PHE T 100      22.041 106.226 -20.537  1.00 70.68           C  
ATOM   6993  N   LYS T 101      29.091 105.500 -21.087  1.00 71.66           N  
ATOM   6994  CA  LYS T 101      30.486 105.764 -21.459  1.00 72.37           C  
ATOM   6995  C   LYS T 101      30.557 106.579 -22.759  1.00 72.72           C  
ATOM   6996  O   LYS T 101      30.876 107.779 -22.759  1.00 72.78           O  
ATOM   6997  CB  LYS T 101      31.300 104.459 -21.522  1.00 72.32           C  
ATOM   6998  CG  LYS T 101      31.364 103.718 -20.166  1.00 72.84           C  
ATOM   6999  CD  LYS T 101      32.243 102.464 -20.174  1.00 72.94           C  
ATOM   7000  CE  LYS T 101      33.655 102.760 -19.663  1.00 73.61           C  
ATOM   7001  NZ  LYS T 101      34.371 101.536 -19.183  1.00 73.83           N  
ATOM   7002  N   ASN T 102      30.258 105.925 -23.870  1.00 73.03           N  
ATOM   7003  CA  ASN T 102      29.956 106.641 -25.096  1.00 73.17           C  
ATOM   7004  C   ASN T 102      28.455 106.902 -25.062  1.00 73.15           C  
ATOM   7005  O   ASN T 102      27.961 107.554 -24.129  1.00 73.11           O  
ATOM   7006  CB  ASN T 102      30.384 105.836 -26.331  1.00 73.20           C  
ATOM   7007  CG  ASN T 102      30.718 104.380 -26.008  1.00 73.73           C  
ATOM   7008  OD1 ASN T 102      30.224 103.794 -25.027  1.00 73.71           O  
ATOM   7009  ND2 ASN T 102      31.569 103.788 -26.838  1.00 73.80           N  
ATOM   7010  N   GLY T 103      27.732 106.373 -26.046  1.00 72.98           N  
ATOM   7011  CA  GLY T 103      26.275 106.402 -26.019  1.00 72.83           C  
ATOM   7012  C   GLY T 103      25.709 105.098 -25.492  1.00 72.59           C  
ATOM   7013  O   GLY T 103      24.635 104.667 -25.918  1.00 72.77           O  
ATOM   7014  N   GLU T 104      26.428 104.471 -24.561  1.00 72.24           N  
ATOM   7015  CA  GLU T 104      26.083 103.125 -24.103  1.00 72.04           C  
ATOM   7016  C   GLU T 104      26.010 102.982 -22.577  1.00 71.75           C  
ATOM   7017  O   GLU T 104      26.844 103.526 -21.847  1.00 71.39           O  
ATOM   7018  CB  GLU T 104      27.070 102.094 -24.674  1.00 72.33           C  
ATOM   7019  CG  GLU T 104      27.158 102.034 -26.207  1.00 72.70           C  
ATOM   7020  CD  GLU T 104      26.045 101.229 -26.875  1.00 73.02           C  
ATOM   7021  OE1 GLU T 104      25.003 100.955 -26.239  1.00 73.29           O  
ATOM   7022  OE2 GLU T 104      26.216 100.874 -28.060  1.00 73.15           O  
ATOM   7023  N   VAL T 105      25.007 102.233 -22.122  1.00 71.40           N  
ATOM   7024  CA  VAL T 105      24.804 101.930 -20.707  1.00 71.24           C  
ATOM   7025  C   VAL T 105      25.825 100.893 -20.223  1.00 71.10           C  
ATOM   7026  O   VAL T 105      25.745  99.727 -20.590  1.00 71.09           O  
ATOM   7027  CB  VAL T 105      23.370 101.400 -20.446  1.00 71.16           C  
ATOM   7028  CG1 VAL T 105      23.182 101.014 -18.971  1.00 71.26           C  
ATOM   7029  CG2 VAL T 105      22.336 102.430 -20.870  1.00 71.03           C  
ATOM   7030  N   ALA T 106      26.772 101.330 -19.397  1.00 70.91           N  
ATOM   7031  CA  ALA T 106      27.823 100.461 -18.873  1.00 71.00           C  
ATOM   7032  C   ALA T 106      27.293  99.577 -17.749  1.00 71.14           C  
ATOM   7033  O   ALA T 106      27.438  98.354 -17.785  1.00 71.08           O  
ATOM   7034  CB  ALA T 106      28.994 101.288 -18.391  1.00 70.79           C  
ATOM   7035  N   ALA T 107      26.669 100.205 -16.759  1.00 71.23           N  
ATOM   7036  CA  ALA T 107      26.091  99.482 -15.643  1.00 71.40           C  
ATOM   7037  C   ALA T 107      24.842 100.174 -15.119  1.00 71.50           C  
ATOM   7038  O   ALA T 107      24.537 101.305 -15.505  1.00 71.67           O  
ATOM   7039  CB  ALA T 107      27.122  99.305 -14.534  1.00 71.39           C  
ATOM   7040  N   THR T 108      24.134  99.480 -14.228  1.00 71.72           N  
ATOM   7041  CA  THR T 108      22.851  99.920 -13.707  1.00 71.89           C  
ATOM   7042  C   THR T 108      22.761  99.675 -12.202  1.00 72.02           C  
ATOM   7043  O   THR T 108      23.091  98.591 -11.722  1.00 71.78           O  
ATOM   7044  CB  THR T 108      21.702  99.178 -14.423  1.00 72.03           C  
ATOM   7045  OG1 THR T 108      21.768  99.447 -15.831  1.00 72.90           O  
ATOM   7046  CG2 THR T 108      20.328  99.610 -13.897  1.00 71.96           C  
ATOM   7047  N   LYS T 109      22.324 100.696 -11.470  1.00 72.37           N  
ATOM   7048  CA  LYS T 109      21.996 100.564 -10.054  1.00 72.96           C  
ATOM   7049  C   LYS T 109      20.560 101.032  -9.817  1.00 73.08           C  
ATOM   7050  O   LYS T 109      20.202 102.175 -10.115  1.00 73.15           O  
ATOM   7051  CB  LYS T 109      22.961 101.372  -9.177  1.00 73.07           C  
ATOM   7052  CG  LYS T 109      23.354 100.709  -7.853  1.00 73.61           C  
ATOM   7053  CD  LYS T 109      22.185  99.972  -7.158  1.00 74.74           C  
ATOM   7054  CE  LYS T 109      22.512  99.498  -5.727  1.00 74.26           C  
ATOM   7055  NZ  LYS T 109      23.834  98.815  -5.588  1.00 74.88           N  
ATOM   7056  N   VAL T 110      19.744 100.131  -9.286  1.00 73.36           N  
ATOM   7057  CA  VAL T 110      18.365 100.436  -8.941  1.00 73.55           C  
ATOM   7058  C   VAL T 110      18.247 100.571  -7.424  1.00 73.75           C  
ATOM   7059  O   VAL T 110      18.744  99.722  -6.679  1.00 73.80           O  
ATOM   7060  CB  VAL T 110      17.393  99.333  -9.442  1.00 73.45           C  
ATOM   7061  CG1 VAL T 110      15.958  99.823  -9.385  1.00 73.31           C  
ATOM   7062  CG2 VAL T 110      17.739  98.900 -10.859  1.00 73.51           C  
ATOM   7063  N   GLY T 111      17.602 101.642  -6.975  1.00 74.06           N  
ATOM   7064  CA  GLY T 111      17.307 101.821  -5.557  1.00 74.58           C  
ATOM   7065  C   GLY T 111      18.355 102.616  -4.808  1.00 75.04           C  
ATOM   7066  O   GLY T 111      19.505 102.736  -5.248  1.00 74.81           O  
ATOM   7067  N   ALA T 112      17.948 103.158  -3.665  1.00 75.39           N  
ATOM   7068  CA  ALA T 112      18.822 103.994  -2.859  1.00 76.02           C  
ATOM   7069  C   ALA T 112      19.859 103.134  -2.157  1.00 76.31           C  
ATOM   7070  O   ALA T 112      19.583 101.998  -1.777  1.00 76.65           O  
ATOM   7071  CB  ALA T 112      18.015 104.794  -1.858  1.00 76.01           C  
ATOM   7072  N   LEU T 113      21.055 103.683  -1.992  1.00 76.63           N  
ATOM   7073  CA  LEU T 113      22.178 102.908  -1.497  1.00 76.95           C  
ATOM   7074  C   LEU T 113      23.148 103.762  -0.681  1.00 77.17           C  
ATOM   7075  O   LEU T 113      23.059 104.997  -0.680  1.00 77.28           O  
ATOM   7076  CB  LEU T 113      22.900 102.235  -2.671  1.00 76.79           C  
ATOM   7077  CG  LEU T 113      23.856 103.065  -3.540  1.00 76.90           C  
ATOM   7078  CD1 LEU T 113      24.572 102.142  -4.505  1.00 77.17           C  
ATOM   7079  CD2 LEU T 113      23.167 104.207  -4.304  1.00 77.30           C  
ATOM   7080  N   SER T 114      24.065 103.088   0.010  1.00 77.22           N  
ATOM   7081  CA  SER T 114      25.143 103.743   0.752  1.00 77.40           C  
ATOM   7082  C   SER T 114      26.089 104.504  -0.179  1.00 77.39           C  
ATOM   7083  O   SER T 114      26.197 104.182  -1.370  1.00 77.19           O  
ATOM   7084  CB  SER T 114      25.931 102.701   1.545  1.00 77.48           C  
ATOM   7085  OG  SER T 114      26.333 101.625   0.716  1.00 77.65           O  
ATOM   7086  N   LYS T 115      26.777 105.508   0.364  1.00 77.26           N  
ATOM   7087  CA  LYS T 115      27.793 106.220  -0.405  1.00 77.31           C  
ATOM   7088  C   LYS T 115      29.008 105.328  -0.666  1.00 77.33           C  
ATOM   7089  O   LYS T 115      29.827 105.628  -1.531  1.00 77.53           O  
ATOM   7090  CB  LYS T 115      28.199 107.541   0.262  1.00 77.24           C  
ATOM   7091  CG  LYS T 115      29.060 107.416   1.511  1.00 77.35           C  
ATOM   7092  CD  LYS T 115      28.231 107.498   2.789  1.00 77.20           C  
ATOM   7093  CE  LYS T 115      29.110 107.374   4.024  1.00 77.03           C  
ATOM   7094  NZ  LYS T 115      30.230 108.358   4.029  1.00 76.96           N  
ATOM   7095  N   GLY T 116      29.094 104.225   0.076  1.00 77.40           N  
ATOM   7096  CA  GLY T 116      30.187 103.262  -0.045  1.00 77.55           C  
ATOM   7097  C   GLY T 116      29.954 102.177  -1.081  1.00 77.64           C  
ATOM   7098  O   GLY T 116      30.856 101.853  -1.854  1.00 77.54           O  
ATOM   7099  N   GLN T 117      28.749 101.603  -1.089  1.00 77.81           N  
ATOM   7100  CA  GLN T 117      28.359 100.636  -2.128  1.00 78.10           C  
ATOM   7101  C   GLN T 117      28.327 101.282  -3.514  1.00 77.81           C  
ATOM   7102  O   GLN T 117      28.629 100.628  -4.516  1.00 77.77           O  
ATOM   7103  CB  GLN T 117      27.008  99.981  -1.809  1.00 78.38           C  
ATOM   7104  CG  GLN T 117      26.711  98.710  -2.612  1.00 78.77           C  
ATOM   7105  CD  GLN T 117      26.121  97.590  -1.750  1.00 79.19           C  
ATOM   7106  OE1 GLN T 117      25.066  97.031  -2.072  1.00 79.43           O  
ATOM   7107  NE2 GLN T 117      26.803  97.257  -0.655  1.00 78.48           N  
ATOM   7108  N   LEU T 118      27.977 102.569  -3.555  1.00 77.59           N  
ATOM   7109  CA  LEU T 118      27.990 103.348  -4.793  1.00 77.33           C  
ATOM   7110  C   LEU T 118      29.401 103.453  -5.352  1.00 77.15           C  
ATOM   7111  O   LEU T 118      29.597 103.358  -6.562  1.00 77.16           O  
ATOM   7112  CB  LEU T 118      27.393 104.743  -4.568  1.00 77.27           C  
ATOM   7113  CG  LEU T 118      27.228 105.715  -5.747  1.00 77.37           C  
ATOM   7114  CD1 LEU T 118      26.659 105.052  -7.005  1.00 77.05           C  
ATOM   7115  CD2 LEU T 118      26.355 106.886  -5.331  1.00 77.28           C  
ATOM   7116  N   LYS T 119      30.376 103.635  -4.464  1.00 76.89           N  
ATOM   7117  CA  LYS T 119      31.766 103.773  -4.876  1.00 76.78           C  
ATOM   7118  C   LYS T 119      32.329 102.475  -5.432  1.00 76.76           C  
ATOM   7119  O   LYS T 119      32.965 102.479  -6.482  1.00 76.69           O  
ATOM   7120  CB  LYS T 119      32.634 104.269  -3.719  1.00 76.90           C  
ATOM   7121  CG  LYS T 119      32.391 105.715  -3.338  1.00 76.77           C  
ATOM   7122  CD  LYS T 119      33.410 106.187  -2.328  1.00 76.68           C  
ATOM   7123  CE  LYS T 119      34.560 106.946  -2.985  1.00 76.71           C  
ATOM   7124  NZ  LYS T 119      35.474 107.553  -1.940  1.00 76.18           N  
ATOM   7125  N   GLU T 120      32.090 101.370  -4.728  1.00 76.90           N  
ATOM   7126  CA  GLU T 120      32.564 100.051  -5.155  1.00 77.06           C  
ATOM   7127  C   GLU T 120      31.968  99.720  -6.529  1.00 77.13           C  
ATOM   7128  O   GLU T 120      32.616  99.094  -7.371  1.00 77.16           O  
ATOM   7129  CB  GLU T 120      32.208  98.984  -4.106  1.00 77.02           C  
ATOM   7130  CG  GLU T 120      33.234  97.846  -3.968  1.00 77.02           C  
ATOM   7131  CD  GLU T 120      33.080  97.037  -2.673  1.00 77.10           C  
ATOM   7132  OE1 GLU T 120      31.941  96.638  -2.336  1.00 76.66           O  
ATOM   7133  OE2 GLU T 120      34.108  96.793  -1.996  1.00 76.95           O  
ATOM   7134  N   PHE T 121      30.735 100.173  -6.746  1.00 77.15           N  
ATOM   7135  CA  PHE T 121      30.072 100.081  -8.041  1.00 77.24           C  
ATOM   7136  C   PHE T 121      30.789 100.926  -9.113  1.00 77.13           C  
ATOM   7137  O   PHE T 121      30.952 100.485 -10.251  1.00 77.42           O  
ATOM   7138  CB  PHE T 121      28.600 100.484  -7.886  1.00 77.36           C  
ATOM   7139  CG  PHE T 121      27.893 100.769  -9.183  1.00 77.69           C  
ATOM   7140  CD1 PHE T 121      27.650 102.084  -9.580  1.00 77.83           C  
ATOM   7141  CD2 PHE T 121      27.447  99.731  -9.995  1.00 77.76           C  
ATOM   7142  CE1 PHE T 121      26.983 102.361 -10.773  1.00 77.67           C  
ATOM   7143  CE2 PHE T 121      26.782 100.000 -11.187  1.00 78.00           C  
ATOM   7144  CZ  PHE T 121      26.549 101.318 -11.577  1.00 77.69           C  
ATOM   7145  N   LEU T 122      31.224 102.126  -8.740  1.00 76.71           N  
ATOM   7146  CA  LEU T 122      31.928 103.016  -9.665  1.00 76.24           C  
ATOM   7147  C   LEU T 122      33.377 102.598  -9.899  1.00 76.09           C  
ATOM   7148  O   LEU T 122      33.909 102.783 -10.992  1.00 76.06           O  
ATOM   7149  CB  LEU T 122      31.870 104.458  -9.162  1.00 76.15           C  
ATOM   7150  CG  LEU T 122      30.501 105.135  -9.233  1.00 76.12           C  
ATOM   7151  CD1 LEU T 122      30.405 106.257  -8.219  1.00 76.10           C  
ATOM   7152  CD2 LEU T 122      30.212 105.648 -10.644  1.00 76.46           C  
ATOM   7153  N   ASP T 123      34.007 102.041  -8.867  1.00 75.96           N  
ATOM   7154  CA  ASP T 123      35.400 101.590  -8.933  1.00 75.76           C  
ATOM   7155  C   ASP T 123      35.617 100.477  -9.956  1.00 75.69           C  
ATOM   7156  O   ASP T 123      36.600 100.494 -10.702  1.00 75.73           O  
ATOM   7157  CB  ASP T 123      35.880 101.119  -7.554  1.00 75.69           C  
ATOM   7158  CG  ASP T 123      36.487 102.239  -6.722  1.00 75.66           C  
ATOM   7159  OD1 ASP T 123      37.433 101.952  -5.954  1.00 75.60           O  
ATOM   7160  OD2 ASP T 123      36.027 103.399  -6.829  1.00 75.41           O  
ATOM   7161  N   ALA T 124      34.688  99.524  -9.984  1.00 75.58           N  
ATOM   7162  CA  ALA T 124      34.801  98.333 -10.827  1.00 75.32           C  
ATOM   7163  C   ALA T 124      34.487  98.584 -12.304  1.00 75.07           C  
ATOM   7164  O   ALA T 124      34.954  97.837 -13.166  1.00 75.02           O  
ATOM   7165  CB  ALA T 124      33.929  97.208 -10.278  1.00 75.27           C  
ATOM   7166  N   ASN T 125      33.704  99.623 -12.595  1.00 74.78           N  
ATOM   7167  CA  ASN T 125      33.324  99.933 -13.985  1.00 74.69           C  
ATOM   7168  C   ASN T 125      33.812 101.297 -14.463  1.00 74.34           C  
ATOM   7169  O   ASN T 125      35.006 101.497 -14.680  1.00 74.25           O  
ATOM   7170  CB  ASN T 125      31.803  99.822 -14.177  1.00 74.64           C  
ATOM   7171  CG  ASN T 125      31.200  98.616 -13.460  1.00 74.52           C  
ATOM   7172  OD1 ASN T 125      31.751  97.510 -13.481  1.00 74.21           O  
ATOM   7173  ND2 ASN T 125      30.060  98.833 -12.817  1.00 74.37           N  
TER    7174      ASN T 125                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
