
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   81 (  645),  selected   81 , name 2fa8_D
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2fa8_D.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_D      -       -           -
LGA    E     3_D      -       -           -
LGA    T     4_D      -       -           -
LGA    K     5_D      T      12          1.330
LGA    P     6_D      H      13          1.206
LGA    R     7_D      R      14          0.670
LGA    I     8_D      V      15          0.277
LGA    A     9_D      Q      16          0.365
LGA    I    10_D      I      17          0.208
LGA    R    11_D      E      18          0.307
LGA    Y    12_D      Y      19          0.396
LGA    C    13_D      C      20          0.354
LGA    T    14_D      T      21          0.515
LGA    Q    15_D      Q      22          0.821
LGA    C    16_D      C      23          0.398
LGA    N    17_D      R      24          0.737
LGA    W    18_D      W      25          0.417
LGA    L    19_D      L      26          0.301
LGA    L    20_D      P      27          0.466
LGA    R    21_D      R      28          0.438
LGA    A    22_D      A      29          0.335
LGA    G    23_D      A      30          0.341
LGA    W    24_D      W      31          0.353
LGA    X    25_D      L      32          0.397
LGA    A    26_D      A      33          0.387
LGA    Q    27_D      Q      34          0.400
LGA    E    28_D      E      35          0.453
LGA    I    29_D      L      36          0.594
LGA    L    30_D      L      37          0.749
LGA    Q    31_D      T      38          0.744
LGA    T    32_D      T      39          0.949
LGA    F    33_D      F      40          1.238
LGA    A    34_D      E      41          0.935
LGA    S    35_D      T      42          2.453
LGA    D    36_D      E      43          1.178
LGA    I    37_D      L      44          0.582
LGA    G    38_D      T      45          0.953
LGA    E    39_D      E      46          0.791
LGA    V    40_D      L      47          0.556
LGA    S    41_D      A      48          0.281
LGA    L    42_D      L      49          0.271
LGA    I    43_D      K      50          0.340
LGA    P    44_D      P      51          0.519
LGA    S    45_D      G      52          0.760
LGA    T    46_D      T      53          0.891
LGA    G    47_D      G      54          1.149
LGA    G    48_D      G      55          0.920
LGA    L    49_D      V      56          0.580
LGA    F    50_D      F      57          0.497
LGA    E    51_D      V      58          0.691
LGA    I    52_D      V      59          0.493
LGA    T    53_D      R      60          0.384
LGA    V    54_D      V      61          0.318
LGA    D    55_D      D      62          0.647
LGA    G    56_D      D      63          0.809
LGA    T    57_D      E      64          0.648
LGA    I    58_D      V      65          0.658
LGA    I    59_D      V      66          0.577
LGA    W    60_D      W      67          0.466
LGA    E    61_D      D      68          0.517
LGA    R    62_D      R      69          0.826
LGA    K    63_D      R      70          0.735
LGA    R    64_D      E      71          1.030
LGA    D    65_D      Q      72          0.872
LGA    G    66_D      G      73          2.466
LGA    G    67_D      F      74          3.128
LGA    F    68_D      -       -           -
LGA    P    69_D      P      75          1.301
LGA    G    70_D      E      76          1.206
LGA    P    71_D      P      77          1.033
LGA    K    72_D      T      78          0.778
LGA    E    73_D      A      79          0.995
LGA    L    74_D      V      80          1.344
LGA    K    75_D      K      81          0.998
LGA    Q    76_D      R      82          0.609
LGA    R    77_D      L      83          0.462
LGA    I    78_D      V      84          0.687
LGA    R    79_D      R      85          0.632
LGA    D    80_D      D      86          0.757
LGA    L    81_D      R      87          1.088
LGA    I    82_D      V      88          0.581

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   81   77    5.0     77    0.89    45.45     98.285     7.752

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.411229 * X  +   0.910867 * Y  +   0.034830 * Z  +  -6.738108
  Y_new =   0.864009 * X  +   0.401681 * Y  +  -0.303546 * Z  + 113.597466
  Z_new =  -0.290481 * X  +  -0.094734 * Y  +  -0.952180 * Z  +  62.481655 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.042428    0.099165  [ DEG:  -174.3183      5.6817 ]
  Theta =   0.294729    2.846864  [ DEG:    16.8867    163.1133 ]
  Phi   =   2.015023   -1.126570  [ DEG:   115.4523    -64.5477 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fa8_D                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fa8_D.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   81   77   5.0   77   0.89   45.45  98.285
REMARK  ---------------------------------------------------------- 
MOLECULE 2fa8_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   07-DEC-05   2FA8              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE SELENOPROTEIN W-RELATED             
TITLE    2 FAMILY PROTEIN FROM AGROBACTERIUM TUMEFACIENS                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN ATU0228;                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 GENE: ATU0228;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPH-BETA STRUCTURE, 4 HELIX BUNDLE, STRUCTURAL GENOMICS,             
KEYWDS   2 PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, MCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,A.JOACHIMIAK,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   24-JAN-06 2FA8    0                                                
JRNL        AUTH   Y.KIM,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                    
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE SELENOPROTEIN              
JRNL        TITL 2 W-RELATED FAMILY PROTEIN FROM AGROBACTERIUM                  
JRNL        TITL 3 TUMEFACIENS                                                  
JRNL        REF    TO BE PUBLISHED                            2006              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2FA8 A    1   101  GB     17934144 NP_530934        1    101             
DBREF  2FA8 B    1   101  GB     17934144 NP_530934        1    101             
DBREF  2FA8 C    1   101  GB     17934144 NP_530934        1    101             
DBREF  2FA8 D    1   101  GB     17934144 NP_530934        1    101             
SEQRES   1 A  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 A  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 A  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 A  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 A  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 A  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 A  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 A  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 A  105  SER                                                          
SEQRES   1 B  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 B  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 B  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 B  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 B  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 B  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 B  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 B  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 B  105  SER                                                          
SEQRES   1 C  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 C  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 C  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 C  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 C  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 C  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 C  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 C  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 C  105  SER                                                          
SEQRES   1 D  105  GLY HIS MSE THR GLU THR LYS PRO ARG ILE ALA ILE ARG          
SEQRES   2 D  105  TYR CYS THR GLN CYS ASN TRP LEU LEU ARG ALA GLY TRP          
SEQRES   3 D  105  MSE ALA GLN GLU ILE LEU GLN THR PHE ALA SER ASP ILE          
SEQRES   4 D  105  GLY GLU VAL SER LEU ILE PRO SER THR GLY GLY LEU PHE          
SEQRES   5 D  105  GLU ILE THR VAL ASP GLY THR ILE ILE TRP GLU ARG LYS          
SEQRES   6 D  105  ARG ASP GLY GLY PHE PRO GLY PRO LYS GLU LEU LYS GLN          
SEQRES   7 D  105  ARG ILE ARG ASP LEU ILE ASP PRO GLU ARG ASP LEU GLY          
SEQRES   8 D  105  HIS VAL ASP ARG THR LYS HIS GLU GLY LEU ASP THR GLY          
SEQRES   9 D  105  SER                                                          
HET    MSE  A  25       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  C  25       8                                                       
HET    MSE  D  25       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   5  HOH   *198(H2 O)                                                    
CRYST1   53.078   69.306   95.578  90.00  90.00  90.00 P 21 21 21   16          
ATOM   2118  N   THR D   2      35.467 102.428 -23.329  1.00 47.14           N  
ATOM   2119  CA  THR D   2      34.950 103.817 -23.493  1.00 47.07           C  
ATOM   2120  C   THR D   2      36.079 104.810 -23.286  1.00 46.69           C  
ATOM   2121  O   THR D   2      36.841 104.681 -22.323  1.00 47.53           O  
ATOM   2122  CB  THR D   2      33.802 104.082 -22.505  1.00 47.43           C  
ATOM   2123  N   GLU D   3      36.189 105.794 -24.185  1.00 45.57           N  
ATOM   2124  CA  GLU D   3      37.291 106.777 -24.133  1.00 44.38           C  
ATOM   2125  C   GLU D   3      36.874 108.211 -23.757  1.00 43.68           C  
ATOM   2126  O   GLU D   3      37.726 109.098 -23.632  1.00 43.98           O  
ATOM   2127  CB  GLU D   3      38.053 106.793 -25.453  1.00 44.12           C  
ATOM   2128  CG  GLU D   3      39.027 105.640 -25.603  1.00 43.42           C  
ATOM   2129  CD  GLU D   3      39.417 105.410 -27.045  1.00 41.83           C  
ATOM   2130  OE1 GLU D   3      39.454 106.395 -27.819  1.00 41.75           O  
ATOM   2131  OE2 GLU D   3      39.679 104.250 -27.398  1.00 38.86           O  
ATOM   2132  N   THR D   4      35.572 108.436 -23.610  1.00 42.03           N  
ATOM   2133  CA  THR D   4      35.061 109.703 -23.080  1.00 40.34           C  
ATOM   2134  C   THR D   4      34.953 109.576 -21.562  1.00 38.40           C  
ATOM   2135  O   THR D   4      34.932 108.467 -21.033  1.00 37.50           O  
ATOM   2136  CB  THR D   4      33.670 110.041 -23.666  1.00 40.63           C  
ATOM   2137  OG1 THR D   4      32.818 108.890 -23.566  1.00 41.22           O  
ATOM   2138  CG2 THR D   4      33.776 110.467 -25.141  1.00 40.68           C  
ATOM   2139  N   LYS D   5      34.879 110.710 -20.868  1.00 36.94           N  
ATOM   2140  CA  LYS D   5      34.706 110.709 -19.411  1.00 35.94           C  
ATOM   2141  C   LYS D   5      33.327 110.142 -19.095  1.00 34.11           C  
ATOM   2142  O   LYS D   5      32.383 110.449 -19.803  1.00 34.50           O  
ATOM   2143  CB  LYS D   5      34.820 112.133 -18.881  1.00 35.82           C  
ATOM   2144  CG  LYS D   5      36.028 112.866 -19.424  1.00 38.33           C  
ATOM   2145  CD  LYS D   5      37.120 112.983 -18.396  1.00 40.86           C  
ATOM   2146  CE  LYS D   5      37.306 114.461 -18.043  1.00 41.86           C  
ATOM   2147  NZ  LYS D   5      38.640 114.698 -17.406  1.00 42.10           N  
ATOM   2148  N   PRO D   6      33.211 109.297 -18.057  1.00 33.48           N  
ATOM   2149  CA  PRO D   6      31.930 108.647 -17.763  1.00 32.07           C  
ATOM   2150  C   PRO D   6      30.781 109.628 -17.553  1.00 31.31           C  
ATOM   2151  O   PRO D   6      30.964 110.703 -16.959  1.00 30.16           O  
ATOM   2152  CB  PRO D   6      32.218 107.852 -16.487  1.00 32.25           C  
ATOM   2153  CG  PRO D   6      33.441 108.486 -15.909  1.00 33.73           C  
ATOM   2154  CD  PRO D   6      34.253 108.875 -17.110  1.00 33.10           C  
ATOM   2155  N   ARG D   7      29.618 109.263 -18.095  1.00 29.61           N  
ATOM   2156  CA  ARG D   7      28.384 110.007 -17.897  1.00 28.90           C  
ATOM   2157  C   ARG D   7      27.599 109.189 -16.893  1.00 27.67           C  
ATOM   2158  O   ARG D   7      27.275 108.024 -17.141  1.00 27.12           O  
ATOM   2159  CB  ARG D   7      27.597 110.126 -19.215  1.00 28.68           C  
ATOM   2160  CG  ARG D   7      28.281 110.969 -20.299  1.00 31.83           C  
ATOM   2161  CD  ARG D   7      27.689 110.750 -21.716  1.00 31.22           C  
ATOM   2162  NE  ARG D   7      28.013 109.438 -22.282  1.00 38.79           N  
ATOM   2163  CZ  ARG D   7      27.162 108.417 -22.390  1.00 39.70           C  
ATOM   2164  NH1 ARG D   7      25.907 108.530 -21.968  1.00 43.91           N  
ATOM   2165  NH2 ARG D   7      27.564 107.280 -22.922  1.00 41.49           N  
ATOM   2166  N   ILE D   8      27.321 109.787 -15.738  1.00 26.25           N  
ATOM   2167  CA  ILE D   8      26.591 109.112 -14.692  1.00 25.00           C  
ATOM   2168  C   ILE D   8      25.162 109.674 -14.594  1.00 23.90           C  
ATOM   2169  O   ILE D   8      24.948 110.886 -14.728  1.00 23.64           O  
ATOM   2170  CB  ILE D   8      27.377 109.108 -13.334  1.00 26.12           C  
ATOM   2171  CG1 ILE D   8      28.694 108.351 -13.536  1.00 26.50           C  
ATOM   2172  CG2 ILE D   8      26.540 108.440 -12.226  1.00 24.73           C  
ATOM   2173  CD1 ILE D   8      29.677 108.492 -12.436  1.00 32.39           C  
ATOM   2174  N   ALA D   9      24.179 108.789 -14.417  1.00 23.43           N  
ATOM   2175  CA  ALA D   9      22.780 109.228 -14.367  1.00 22.72           C  
ATOM   2176  C   ALA D   9      22.032 108.574 -13.226  1.00 22.28           C  
ATOM   2177  O   ALA D   9      22.127 107.345 -13.022  1.00 23.17           O  
ATOM   2178  CB  ALA D   9      22.066 108.943 -15.703  1.00 22.82           C  
ATOM   2179  N   ILE D  10      21.292 109.400 -12.492  1.00 21.04           N  
ATOM   2180  CA  ILE D  10      20.558 108.942 -11.332  1.00 21.54           C  
ATOM   2181  C   ILE D  10      19.085 109.239 -11.651  1.00 21.85           C  
ATOM   2182  O   ILE D  10      18.666 110.397 -11.674  1.00 21.50           O  
ATOM   2183  CB  ILE D  10      21.006 109.616 -10.010  1.00 21.07           C  
ATOM   2184  CG1 ILE D  10      22.520 109.459  -9.806  1.00 22.19           C  
ATOM   2185  CG2 ILE D  10      20.195 109.021  -8.814  1.00 21.75           C  
ATOM   2186  CD1 ILE D  10      23.062 110.059  -8.498  1.00 22.16           C  
ATOM   2187  N   ARG D  11      18.340 108.188 -11.971  1.00 22.59           N  
ATOM   2188  CA  ARG D  11      16.906 108.330 -12.203  1.00 24.35           C  
ATOM   2189  C   ARG D  11      16.182 108.073 -10.893  1.00 23.91           C  
ATOM   2190  O   ARG D  11      16.343 107.018 -10.301  1.00 25.81           O  
ATOM   2191  CB  ARG D  11      16.441 107.333 -13.256  1.00 25.09           C  
ATOM   2192  CG  ARG D  11      16.878 107.667 -14.645  1.00 28.14           C  
ATOM   2193  CD  ARG D  11      16.446 106.556 -15.628  1.00 36.63           C  
ATOM   2194  NE  ARG D  11      16.650 106.993 -17.012  1.00 42.13           N  
ATOM   2195  CZ  ARG D  11      17.843 107.100 -17.606  1.00 45.98           C  
ATOM   2196  NH1 ARG D  11      18.969 106.797 -16.949  1.00 46.97           N  
ATOM   2197  NH2 ARG D  11      17.917 107.523 -18.864  1.00 47.25           N  
ATOM   2198  N   TYR D  12      15.363 109.010 -10.450  1.00 24.13           N  
ATOM   2199  CA  TYR D  12      14.760 108.910  -9.096  1.00 24.82           C  
ATOM   2200  C   TYR D  12      13.258 109.230  -9.119  1.00 26.43           C  
ATOM   2201  O   TYR D  12      12.808 110.121  -9.830  1.00 26.09           O  
ATOM   2202  CB  TYR D  12      15.503 109.848  -8.105  1.00 23.19           C  
ATOM   2203  CG  TYR D  12      15.236 111.298  -8.409  1.00 24.33           C  
ATOM   2204  CD1 TYR D  12      14.222 111.991  -7.745  1.00 24.05           C  
ATOM   2205  CD2 TYR D  12      15.950 111.964  -9.407  1.00 23.06           C  
ATOM   2206  CE1 TYR D  12      13.944 113.298  -8.052  1.00 23.18           C  
ATOM   2207  CE2 TYR D  12      15.685 113.282  -9.707  1.00 24.51           C  
ATOM   2208  CZ  TYR D  12      14.676 113.939  -9.019  1.00 22.82           C  
ATOM   2209  OH  TYR D  12      14.380 115.228  -9.332  1.00 24.93           O  
ATOM   2210  N   CYS D  13      12.481 108.525  -8.314  1.00 30.11           N  
ATOM   2211  CA  CYS D  13      11.044 108.825  -8.243  1.00 31.43           C  
ATOM   2212  C   CYS D  13      10.779 110.193  -7.589  1.00 31.80           C  
ATOM   2213  O   CYS D  13      11.086 110.395  -6.404  1.00 31.56           O  
ATOM   2214  CB  CYS D  13      10.316 107.703  -7.512  1.00 31.99           C  
ATOM   2215  SG  CYS D  13       8.576 108.088  -7.221  1.00 35.41           S  
ATOM   2216  N   THR D  14      10.228 111.129  -8.359  1.00 32.66           N  
ATOM   2217  CA  THR D  14      10.003 112.503  -7.853  1.00 34.59           C  
ATOM   2218  C   THR D  14       8.907 112.628  -6.793  1.00 34.50           C  
ATOM   2219  O   THR D  14       9.068 113.365  -5.811  1.00 34.31           O  
ATOM   2220  CB  THR D  14       9.786 113.539  -8.971  1.00 34.24           C  
ATOM   2221  OG1 THR D  14       8.577 113.259  -9.682  1.00 37.66           O  
ATOM   2222  CG2 THR D  14      10.908 113.479  -9.924  1.00 36.98           C  
ATOM   2223  N   GLN D  15       7.817 111.890  -6.982  0.50 34.88           N  
ATOM   2225  CA  GLN D  15       6.703 111.833  -6.019  0.50 35.39           C  
ATOM   2227  C   GLN D  15       7.021 111.087  -4.715  0.50 35.38           C  
ATOM   2229  O   GLN D  15       6.252 111.162  -3.757  0.50 35.68           O  
ATOM   2231  CB  GLN D  15       5.434 111.252  -6.672  0.50 35.55           C  
ATOM   2233  CG  GLN D  15       5.661 110.092  -7.649  0.50 36.64           C  
ATOM   2235  CD  GLN D  15       6.316 110.529  -8.959  0.50 37.62           C  
ATOM   2237  OE1 GLN D  15       7.324 109.970  -9.368  0.50 38.36           O  
ATOM   2239  NE2 GLN D  15       5.751 111.547  -9.604  0.50 39.20           N  
ATOM   2241  N   CYS D  16       8.132 110.351  -4.694  1.00 35.29           N  
ATOM   2242  CA  CYS D  16       8.603 109.650  -3.481  1.00 35.64           C  
ATOM   2243  C   CYS D  16       9.521 110.468  -2.584  1.00 34.44           C  
ATOM   2244  O   CYS D  16       9.993 109.961  -1.575  1.00 34.67           O  
ATOM   2245  CB  CYS D  16       9.341 108.366  -3.836  1.00 35.49           C  
ATOM   2246  SG  CYS D  16       8.365 107.178  -4.739  1.00 40.86           S  
ATOM   2247  N   ASN D  17       9.767 111.720  -2.949  1.00 33.89           N  
ATOM   2248  CA  ASN D  17      10.701 112.568  -2.234  1.00 34.09           C  
ATOM   2249  C   ASN D  17      12.100 111.918  -2.156  1.00 32.67           C  
ATOM   2250  O   ASN D  17      12.725 111.872  -1.086  1.00 33.43           O  
ATOM   2251  CB  ASN D  17      10.162 112.980  -0.846  1.00 35.38           C  
ATOM   2252  CG  ASN D  17       9.454 114.356  -0.857  1.00 39.76           C  
ATOM   2253  OD1 ASN D  17       9.518 115.100   0.126  1.00 47.36           O  
ATOM   2254  ND2 ASN D  17       8.785 114.691  -1.956  1.00 43.29           N  
ATOM   2255  N   TRP D  18      12.568 111.408  -3.298  1.00 29.66           N  
ATOM   2256  CA  TRP D  18      13.917 110.844  -3.396  1.00 28.17           C  
ATOM   2257  C   TRP D  18      14.928 111.824  -3.995  1.00 26.85           C  
ATOM   2258  O   TRP D  18      16.092 111.467  -4.213  1.00 26.42           O  
ATOM   2259  CB  TRP D  18      13.912 109.512  -4.156  1.00 28.10           C  
ATOM   2260  CG  TRP D  18      13.189 108.420  -3.396  1.00 27.52           C  
ATOM   2261  CD1 TRP D  18      12.858 108.426  -2.068  1.00 27.99           C  
ATOM   2262  CD2 TRP D  18      12.741 107.161  -3.917  1.00 28.01           C  
ATOM   2263  NE1 TRP D  18      12.205 107.252  -1.733  1.00 29.86           N  
ATOM   2264  CE2 TRP D  18      12.117 106.462  -2.851  1.00 28.78           C  
ATOM   2265  CE3 TRP D  18      12.778 106.569  -5.184  1.00 26.84           C  
ATOM   2266  CZ2 TRP D  18      11.549 105.189  -3.013  1.00 29.36           C  
ATOM   2267  CZ3 TRP D  18      12.203 105.311  -5.349  1.00 29.11           C  
ATOM   2268  CH2 TRP D  18      11.605 104.631  -4.267  1.00 28.38           C  
ATOM   2269  N   LEU D  19      14.483 113.046  -4.255  1.00 25.14           N  
ATOM   2270  CA  LEU D  19      15.382 114.090  -4.751  1.00 24.38           C  
ATOM   2271  C   LEU D  19      16.562 114.297  -3.799  1.00 23.08           C  
ATOM   2272  O   LEU D  19      17.708 114.366  -4.245  1.00 21.82           O  
ATOM   2273  CB  LEU D  19      14.659 115.433  -4.965  1.00 24.36           C  
ATOM   2274  CG  LEU D  19      15.589 116.598  -5.346  1.00 23.40           C  
ATOM   2275  CD1 LEU D  19      16.335 116.342  -6.682  1.00 22.17           C  
ATOM   2276  CD2 LEU D  19      14.790 117.916  -5.398  1.00 25.39           C  
ATOM   2277  N   LEU D  20      16.267 114.431  -2.504  1.00 22.35           N  
ATOM   2278  CA  LEU D  20      17.317 114.621  -1.487  1.00 23.21           C  
ATOM   2279  C   LEU D  20      18.447 113.589  -1.613  1.00 21.98           C  
ATOM   2280  O   LEU D  20      19.631 113.954  -1.700  1.00 20.23           O  
ATOM   2281  CB  LEU D  20      16.736 114.596  -0.053  1.00 23.68           C  
ATOM   2282  CG  LEU D  20      16.730 115.876   0.784  1.00 28.29           C  
ATOM   2283  CD1 LEU D  20      16.272 117.085   0.003  1.00 30.29           C  
ATOM   2284  CD2 LEU D  20      15.895 115.706   2.047  1.00 24.51           C  
ATOM   2285  N   ARG D  21      18.084 112.305  -1.602  1.00 21.03           N  
ATOM   2286  CA  ARG D  21      19.079 111.234  -1.625  1.00 20.86           C  
ATOM   2287  C   ARG D  21      19.799 111.138  -2.980  1.00 20.85           C  
ATOM   2288  O   ARG D  21      20.978 110.791  -3.016  1.00 19.83           O  
ATOM   2289  CB  ARG D  21      18.480 109.881  -1.208  1.00 20.96           C  
ATOM   2290  CG  ARG D  21      17.626 109.205  -2.315  1.00 20.87           C  
ATOM   2291  CD  ARG D  21      16.738 108.090  -1.738  1.00 23.48           C  
ATOM   2292  NE  ARG D  21      15.890 108.508  -0.619  1.00 26.83           N  
ATOM   2293  CZ  ARG D  21      15.213 107.650   0.166  1.00 26.57           C  
ATOM   2294  NH1 ARG D  21      15.307 106.340  -0.014  1.00 27.83           N  
ATOM   2295  NH2 ARG D  21      14.476 108.092   1.161  1.00 26.12           N  
ATOM   2296  N   ALA D  22      19.111 111.510  -4.067  1.00 20.17           N  
ATOM   2297  CA  ALA D  22      19.755 111.524  -5.399  1.00 19.67           C  
ATOM   2298  C   ALA D  22      20.819 112.652  -5.521  1.00 19.69           C  
ATOM   2299  O   ALA D  22      21.958 112.448  -6.009  1.00 18.66           O  
ATOM   2300  CB  ALA D  22      18.682 111.631  -6.478  1.00 18.41           C  
ATOM   2301  N   GLY D  23      20.439 113.832  -5.044  1.00 19.09           N  
ATOM   2302  CA  GLY D  23      21.323 115.011  -5.045  1.00 19.50           C  
ATOM   2303  C   GLY D  23      22.531 114.749  -4.159  1.00 19.23           C  
ATOM   2304  O   GLY D  23      23.666 115.078  -4.535  1.00 19.87           O  
ATOM   2305  N   TRP D  24      22.301 114.139  -2.995  1.00 19.09           N  
ATOM   2306  CA  TRP D  24      23.394 113.694  -2.108  1.00 19.94           C  
ATOM   2307  C   TRP D  24      24.372 112.719  -2.783  1.00 19.99           C  
ATOM   2308  O   TRP D  24      25.594 112.898  -2.735  1.00 18.42           O  
ATOM   2309  CB  TRP D  24      22.835 113.027  -0.840  1.00 21.00           C  
ATOM   2310  CG  TRP D  24      23.900 112.282  -0.106  1.00 20.86           C  
ATOM   2311  CD1 TRP D  24      25.068 112.818   0.412  1.00 23.13           C  
ATOM   2312  CD2 TRP D  24      23.924 110.893   0.207  1.00 24.87           C  
ATOM   2313  NE1 TRP D  24      25.805 111.843   1.009  1.00 23.66           N  
ATOM   2314  CE2 TRP D  24      25.131 110.648   0.908  1.00 25.49           C  
ATOM   2315  CE3 TRP D  24      23.041 109.817  -0.038  1.00 25.21           C  
ATOM   2316  CZ2 TRP D  24      25.490 109.378   1.373  1.00 24.66           C  
ATOM   2317  CZ3 TRP D  24      23.399 108.542   0.428  1.00 25.18           C  
ATOM   2318  CH2 TRP D  24      24.613 108.341   1.137  1.00 26.32           C  
HETATM 2319  N   MSE D  25      23.853 111.672  -3.418  1.00 20.21           N  
HETATM 2320  CA  MSE D  25      24.745 110.731  -4.110  1.00 22.86           C  
HETATM 2321  C   MSE D  25      25.535 111.402  -5.246  1.00 21.91           C  
HETATM 2322  O   MSE D  25      26.735 111.129  -5.414  1.00 22.51           O  
HETATM 2323  CB  MSE D  25      23.958 109.531  -4.620  1.00 22.70           C  
HETATM 2324  CG  MSE D  25      23.454 108.664  -3.523  1.00 23.86           C  
HETATM 2325 SE   MSE D  25      22.235 107.374  -4.265  0.60 31.17          SE  
HETATM 2326  CE  MSE D  25      21.228 106.943  -2.635  1.00 27.97           C  
ATOM   2327  N   ALA D  26      24.867 112.258  -6.025  1.00 21.90           N  
ATOM   2328  CA  ALA D  26      25.528 113.100  -7.029  1.00 21.33           C  
ATOM   2329  C   ALA D  26      26.712 113.871  -6.455  1.00 21.88           C  
ATOM   2330  O   ALA D  26      27.826 113.812  -7.000  1.00 20.19           O  
ATOM   2331  CB  ALA D  26      24.550 114.045  -7.662  1.00 21.44           C  
ATOM   2332  N   GLN D  27      26.485 114.580  -5.353  1.00 20.35           N  
ATOM   2333  CA  GLN D  27      27.591 115.259  -4.675  1.00 22.33           C  
ATOM   2334  C   GLN D  27      28.687 114.314  -4.149  1.00 21.25           C  
ATOM   2335  O   GLN D  27      29.892 114.626  -4.282  1.00 21.95           O  
ATOM   2336  CB  GLN D  27      27.066 116.221  -3.602  1.00 21.86           C  
ATOM   2337  CG  GLN D  27      26.345 117.382  -4.249  1.00 27.27           C  
ATOM   2338  CD  GLN D  27      25.551 118.201  -3.275  1.00 33.17           C  
ATOM   2339  OE1 GLN D  27      24.426 117.858  -2.903  1.00 37.43           O  
ATOM   2340  NE2 GLN D  27      26.120 119.306  -2.877  1.00 34.87           N  
ATOM   2341  N   GLU D  28      28.317 113.164  -3.571  1.00 21.82           N  
ATOM   2342  CA  GLU D  28      29.348 112.201  -3.117  1.00 21.73           C  
ATOM   2343  C   GLU D  28      30.241 111.795  -4.295  1.00 22.67           C  
ATOM   2344  O   GLU D  28      31.487 111.728  -4.185  1.00 22.16           O  
ATOM   2345  CB  GLU D  28      28.738 110.939  -2.501  1.00 22.55           C  
ATOM   2346  CG  GLU D  28      28.133 111.086  -1.117  1.00 22.20           C  
ATOM   2347  CD  GLU D  28      29.159 111.169   0.014  1.00 25.59           C  
ATOM   2348  OE1 GLU D  28      30.372 110.939  -0.206  1.00 23.52           O  
ATOM   2349  OE2 GLU D  28      28.733 111.416   1.154  1.00 24.06           O  
ATOM   2350  N   ILE D  29      29.593 111.514  -5.425  1.00 22.58           N  
ATOM   2351  CA  ILE D  29      30.292 111.021  -6.611  1.00 22.77           C  
ATOM   2352  C   ILE D  29      31.246 112.094  -7.109  1.00 22.53           C  
ATOM   2353  O   ILE D  29      32.428 111.818  -7.310  1.00 22.45           O  
ATOM   2354  CB  ILE D  29      29.304 110.571  -7.741  1.00 22.64           C  
ATOM   2355  CG1 ILE D  29      28.567 109.285  -7.365  1.00 22.61           C  
ATOM   2356  CG2 ILE D  29      30.043 110.333  -9.069  1.00 24.66           C  
ATOM   2357  CD1 ILE D  29      27.316 109.024  -8.251  1.00 22.37           C  
ATOM   2358  N   LEU D  30      30.745 113.324  -7.232  1.00 21.94           N  
ATOM   2359  CA  LEU D  30      31.533 114.419  -7.778  1.00 23.23           C  
ATOM   2360  C   LEU D  30      32.635 114.903  -6.854  1.00 25.11           C  
ATOM   2361  O   LEU D  30      33.683 115.346  -7.325  1.00 25.59           O  
ATOM   2362  CB  LEU D  30      30.640 115.594  -8.191  1.00 22.91           C  
ATOM   2363  CG  LEU D  30      29.869 115.206  -9.475  1.00 23.67           C  
ATOM   2364  CD1 LEU D  30      28.678 116.085  -9.662  1.00 22.84           C  
ATOM   2365  CD2 LEU D  30      30.783 115.193 -10.751  1.00 24.18           C  
ATOM   2366  N   GLN D  31      32.394 114.824  -5.549  1.00 25.98           N  
ATOM   2367  CA  GLN D  31      33.418 115.174  -4.574  1.00 28.51           C  
ATOM   2368  C   GLN D  31      34.591 114.192  -4.693  1.00 29.15           C  
ATOM   2369  O   GLN D  31      35.741 114.613  -4.752  1.00 30.54           O  
ATOM   2370  CB  GLN D  31      32.835 115.158  -3.162  1.00 28.37           C  
ATOM   2371  CG  GLN D  31      33.883 115.196  -2.032  1.00 32.54           C  
ATOM   2372  CD  GLN D  31      33.297 115.762  -0.764  1.00 38.39           C  
ATOM   2373  OE1 GLN D  31      32.840 116.909  -0.741  1.00 39.59           O  
ATOM   2374  NE2 GLN D  31      33.268 114.954   0.292  1.00 40.49           N  
ATOM   2375  N   THR D  32      34.296 112.902  -4.780  1.00 29.58           N  
ATOM   2376  CA  THR D  32      35.327 111.881  -4.869  1.00 30.88           C  
ATOM   2377  C   THR D  32      36.059 111.920  -6.217  1.00 30.60           C  
ATOM   2378  O   THR D  32      37.277 112.037  -6.246  1.00 31.00           O  
ATOM   2379  CB  THR D  32      34.740 110.497  -4.607  1.00 31.21           C  
ATOM   2380  OG1 THR D  32      34.209 110.463  -3.277  1.00 34.00           O  
ATOM   2381  CG2 THR D  32      35.791 109.392  -4.765  1.00 32.68           C  
ATOM   2382  N   PHE D  33      35.317 111.870  -7.324  1.00 29.64           N  
ATOM   2383  CA  PHE D  33      35.933 111.675  -8.642  1.00 29.67           C  
ATOM   2384  C   PHE D  33      36.251 112.949  -9.357  1.00 29.23           C  
ATOM   2385  O   PHE D  33      37.146 112.981 -10.209  1.00 29.18           O  
ATOM   2386  CB  PHE D  33      35.061 110.779  -9.527  1.00 28.89           C  
ATOM   2387  CG  PHE D  33      34.936 109.374  -9.013  1.00 31.11           C  
ATOM   2388  CD1 PHE D  33      35.922 108.425  -9.289  1.00 31.56           C  
ATOM   2389  CD2 PHE D  33      33.854 109.002  -8.226  1.00 27.92           C  
ATOM   2390  CE1 PHE D  33      35.810 107.136  -8.818  1.00 33.21           C  
ATOM   2391  CE2 PHE D  33      33.736 107.719  -7.732  1.00 31.39           C  
ATOM   2392  CZ  PHE D  33      34.721 106.771  -8.027  1.00 33.40           C  
ATOM   2393  N   ALA D  34      35.495 114.002  -9.042  1.00 29.47           N  
ATOM   2394  CA  ALA D  34      35.710 115.324  -9.622  1.00 28.93           C  
ATOM   2395  C   ALA D  34      35.814 115.244 -11.155  1.00 29.70           C  
ATOM   2396  O   ALA D  34      34.961 114.599 -11.802  1.00 29.06           O  
ATOM   2397  CB  ALA D  34      36.942 115.990  -9.005  1.00 28.73           C  
ATOM   2398  N   SER D  35      36.853 115.867 -11.725  1.00 29.05           N  
ATOM   2399  CA  SER D  35      37.004 115.938 -13.185  1.00 30.04           C  
ATOM   2400  C   SER D  35      37.242 114.595 -13.913  1.00 29.97           C  
ATOM   2401  O   SER D  35      37.183 114.558 -15.148  1.00 30.96           O  
ATOM   2402  CB  SER D  35      38.061 116.993 -13.596  1.00 30.52           C  
ATOM   2403  OG  SER D  35      39.345 116.668 -13.068  1.00 32.10           O  
ATOM   2404  N   ASP D  36      37.480 113.504 -13.180  1.00 29.26           N  
ATOM   2405  CA  ASP D  36      37.460 112.156 -13.778  1.00 29.91           C  
ATOM   2406  C   ASP D  36      36.044 111.698 -14.211  1.00 30.06           C  
ATOM   2407  O   ASP D  36      35.913 110.691 -14.894  1.00 30.32           O  
ATOM   2408  CB  ASP D  36      38.104 111.108 -12.867  1.00 30.21           C  
ATOM   2409  CG  ASP D  36      39.621 111.269 -12.770  1.00 32.09           C  
ATOM   2410  OD1 ASP D  36      40.204 112.013 -13.596  1.00 32.00           O  
ATOM   2411  OD2 ASP D  36      40.221 110.657 -11.856  1.00 35.58           O  
ATOM   2412  N   ILE D  37      35.011 112.447 -13.799  1.00 29.85           N  
ATOM   2413  CA  ILE D  37      33.614 112.227 -14.251  1.00 29.27           C  
ATOM   2414  C   ILE D  37      33.302 113.291 -15.284  1.00 28.01           C  
ATOM   2415  O   ILE D  37      33.626 114.471 -15.077  1.00 28.92           O  
ATOM   2416  CB  ILE D  37      32.589 112.323 -13.045  1.00 29.45           C  
ATOM   2417  CG1 ILE D  37      32.800 111.186 -12.046  1.00 30.02           C  
ATOM   2418  CG2 ILE D  37      31.115 112.359 -13.518  1.00 29.71           C  
ATOM   2419  CD1 ILE D  37      33.133 109.835 -12.695  1.00 32.52           C  
ATOM   2420  N   GLY D  38      32.646 112.903 -16.374  1.00 26.54           N  
ATOM   2421  CA  GLY D  38      32.147 113.870 -17.348  1.00 25.47           C  
ATOM   2422  C   GLY D  38      30.938 114.647 -16.804  1.00 25.36           C  
ATOM   2423  O   GLY D  38      30.882 115.861 -16.875  1.00 23.79           O  
ATOM   2424  N   GLU D  39      29.956 113.926 -16.277  1.00 25.53           N  
ATOM   2425  CA  GLU D  39      28.759 114.562 -15.702  1.00 26.43           C  
ATOM   2426  C   GLU D  39      28.020 113.604 -14.812  1.00 25.12           C  
ATOM   2427  O   GLU D  39      28.165 112.385 -14.943  1.00 25.33           O  
ATOM   2428  CB  GLU D  39      27.796 115.040 -16.800  1.00 27.53           C  
ATOM   2429  CG  GLU D  39      27.258 113.901 -17.632  1.00 31.64           C  
ATOM   2430  CD  GLU D  39      26.197 114.343 -18.630  1.00 38.43           C  
ATOM   2431  OE1 GLU D  39      26.073 115.561 -18.860  1.00 39.46           O  
ATOM   2432  OE2 GLU D  39      25.501 113.460 -19.195  1.00 41.89           O  
ATOM   2433  N   VAL D  40      27.240 114.159 -13.886  1.00 24.73           N  
ATOM   2434  CA  VAL D  40      26.226 113.389 -13.152  1.00 23.09           C  
ATOM   2435  C   VAL D  40      24.890 114.084 -13.451  1.00 22.64           C  
ATOM   2436  O   VAL D  40      24.754 115.304 -13.247  1.00 21.43           O  
ATOM   2437  CB  VAL D  40      26.466 113.326 -11.619  1.00 23.04           C  
ATOM   2438  CG1 VAL D  40      25.385 112.482 -10.929  1.00 22.05           C  
ATOM   2439  CG2 VAL D  40      27.846 112.790 -11.289  1.00 24.07           C  
ATOM   2440  N   SER D  41      23.949 113.304 -13.993  1.00 22.42           N  
ATOM   2441  CA  SER D  41      22.630 113.774 -14.412  1.00 23.84           C  
ATOM   2442  C   SER D  41      21.588 113.291 -13.417  1.00 23.69           C  
ATOM   2443  O   SER D  41      21.580 112.100 -13.036  1.00 23.98           O  
ATOM   2444  CB  SER D  41      22.282 113.225 -15.798  1.00 23.79           C  
ATOM   2445  OG  SER D  41      23.027 113.938 -16.784  1.00 31.44           O  
ATOM   2446  N   LEU D  42      20.747 114.212 -12.960  1.00 23.31           N  
ATOM   2447  CA  LEU D  42      19.652 113.871 -12.067  1.00 22.99           C  
ATOM   2448  C   LEU D  42      18.367 113.892 -12.909  1.00 23.20           C  
ATOM   2449  O   LEU D  42      18.043 114.899 -13.489  1.00 22.81           O  
ATOM   2450  CB  LEU D  42      19.546 114.894 -10.923  1.00 24.07           C  
ATOM   2451  CG  LEU D  42      20.717 114.940  -9.913  1.00 24.27           C  
ATOM   2452  CD1 LEU D  42      20.640 116.198  -8.982  1.00 25.97           C  
ATOM   2453  CD2 LEU D  42      20.714 113.680  -9.084  1.00 23.66           C  
ATOM   2454  N   ILE D  43      17.658 112.771 -12.951  1.00 23.78           N  
ATOM   2455  CA  ILE D  43      16.583 112.583 -13.945  1.00 24.56           C  
ATOM   2456  C   ILE D  43      15.264 112.262 -13.234  1.00 25.01           C  
ATOM   2457  O   ILE D  43      15.094 111.165 -12.721  1.00 24.24           O  
ATOM   2458  CB  ILE D  43      16.949 111.499 -14.989  1.00 23.99           C  
ATOM   2459  CG1 ILE D  43      18.287 111.851 -15.662  1.00 24.80           C  
ATOM   2460  CG2 ILE D  43      15.788 111.303 -16.018  1.00 25.78           C  
ATOM   2461  CD1 ILE D  43      18.831 110.778 -16.530  1.00 25.51           C  
ATOM   2462  N   PRO D  44      14.364 113.255 -13.164  1.00 26.79           N  
ATOM   2463  CA  PRO D  44      13.067 113.061 -12.533  1.00 28.95           C  
ATOM   2464  C   PRO D  44      12.337 111.903 -13.197  1.00 30.49           C  
ATOM   2465  O   PRO D  44      12.197 111.867 -14.426  1.00 30.46           O  
ATOM   2466  CB  PRO D  44      12.336 114.380 -12.775  1.00 28.99           C  
ATOM   2467  CG  PRO D  44      13.353 115.349 -13.096  1.00 28.49           C  
ATOM   2468  CD  PRO D  44      14.549 114.638 -13.633  1.00 26.65           C  
ATOM   2469  N   SER D  45      11.907 110.957 -12.374  1.00 33.29           N  
ATOM   2470  CA  SER D  45      11.228 109.772 -12.866  1.00 36.29           C  
ATOM   2471  C   SER D  45       9.936 109.515 -12.105  1.00 38.15           C  
ATOM   2472  O   SER D  45       9.576 110.238 -11.159  1.00 38.69           O  
ATOM   2473  CB  SER D  45      12.165 108.565 -12.795  1.00 35.93           C  
ATOM   2474  OG  SER D  45      13.410 108.881 -13.418  1.00 37.97           O  
ATOM   2475  N   THR D  46       9.231 108.476 -12.524  1.00 40.26           N  
ATOM   2476  CA  THR D  46       7.970 108.137 -11.893  1.00 42.21           C  
ATOM   2477  C   THR D  46       7.995 106.683 -11.480  1.00 42.57           C  
ATOM   2478  O   THR D  46       8.855 105.914 -11.936  1.00 43.57           O  
ATOM   2479  CB  THR D  46       6.759 108.414 -12.827  1.00 42.76           C  
ATOM   2480  OG1 THR D  46       6.898 107.660 -14.046  1.00 44.08           O  
ATOM   2481  CG2 THR D  46       6.640 109.916 -13.143  1.00 43.56           C  
ATOM   2482  N   GLY D  47       7.071 106.330 -10.591  1.00 42.37           N  
ATOM   2483  CA  GLY D  47       6.783 104.945 -10.270  1.00 41.49           C  
ATOM   2484  C   GLY D  47       7.848 104.161  -9.538  1.00 40.52           C  
ATOM   2485  O   GLY D  47       8.208 103.056  -9.968  1.00 41.11           O  
ATOM   2486  N   GLY D  48       8.336 104.726  -8.438  1.00 38.99           N  
ATOM   2487  CA  GLY D  48       9.223 104.032  -7.515  1.00 37.68           C  
ATOM   2488  C   GLY D  48      10.573 103.659  -8.104  1.00 36.48           C  
ATOM   2489  O   GLY D  48      11.266 102.805  -7.562  1.00 36.91           O  
ATOM   2490  N   LEU D  49      10.941 104.296  -9.209  1.00 35.25           N  
ATOM   2491  CA  LEU D  49      12.211 104.013  -9.855  1.00 34.71           C  
ATOM   2492  C   LEU D  49      13.361 104.673  -9.089  1.00 33.42           C  
ATOM   2493  O   LEU D  49      13.266 105.835  -8.680  1.00 32.77           O  
ATOM   2494  CB  LEU D  49      12.197 104.484 -11.322  1.00 35.08           C  
ATOM   2495  CG  LEU D  49      13.339 104.119 -12.279  1.00 36.15           C  
ATOM   2496  CD1 LEU D  49      13.555 102.610 -12.393  1.00 36.09           C  
ATOM   2497  CD2 LEU D  49      13.067 104.709 -13.685  1.00 36.73           C  
ATOM   2498  N   PHE D  50      14.428 103.911  -8.877  1.00 31.47           N  
ATOM   2499  CA  PHE D  50      15.692 104.475  -8.455  1.00 30.38           C  
ATOM   2500  C   PHE D  50      16.779 103.685  -9.125  1.00 29.37           C  
ATOM   2501  O   PHE D  50      17.001 102.521  -8.810  1.00 30.13           O  
ATOM   2502  CB  PHE D  50      15.875 104.513  -6.943  1.00 30.51           C  
ATOM   2503  CG  PHE D  50      16.944 105.483  -6.504  1.00 31.09           C  
ATOM   2504  CD1 PHE D  50      16.623 106.811  -6.239  1.00 32.58           C  
ATOM   2505  CD2 PHE D  50      18.277 105.075  -6.387  1.00 32.45           C  
ATOM   2506  CE1 PHE D  50      17.614 107.725  -5.844  1.00 33.09           C  
ATOM   2507  CE2 PHE D  50      19.265 105.974  -5.996  1.00 32.56           C  
ATOM   2508  CZ  PHE D  50      18.930 107.301  -5.726  1.00 32.53           C  
ATOM   2509  N   GLU D  51      17.404 104.321 -10.098  1.00 27.43           N  
ATOM   2510  CA  GLU D  51      18.339 103.653 -10.952  1.00 27.30           C  
ATOM   2511  C   GLU D  51      19.571 104.513 -11.222  1.00 25.76           C  
ATOM   2512  O   GLU D  51      19.457 105.699 -11.579  1.00 25.57           O  
ATOM   2513  CB  GLU D  51      17.649 103.322 -12.268  1.00 27.21           C  
ATOM   2514  CG  GLU D  51      18.588 102.738 -13.300  1.00 31.43           C  
ATOM   2515  CD  GLU D  51      17.928 102.646 -14.648  1.00 37.91           C  
ATOM   2516  OE1 GLU D  51      18.302 103.423 -15.564  1.00 39.87           O  
ATOM   2517  OE2 GLU D  51      17.008 101.809 -14.765  1.00 39.90           O  
ATOM   2518  N   ILE D  52      20.741 103.898 -11.077  1.00 24.69           N  
ATOM   2519  CA  ILE D  52      22.013 104.573 -11.373  1.00 23.76           C  
ATOM   2520  C   ILE D  52      22.752 103.850 -12.484  1.00 23.71           C  
ATOM   2521  O   ILE D  52      23.029 102.648 -12.376  1.00 24.05           O  
ATOM   2522  CB  ILE D  52      22.955 104.716 -10.146  1.00 23.44           C  
ATOM   2523  CG1 ILE D  52      22.243 105.455  -8.998  1.00 24.97           C  
ATOM   2524  CG2 ILE D  52      24.264 105.451 -10.564  1.00 21.43           C  
ATOM   2525  CD1 ILE D  52      22.981 105.357  -7.623  1.00 24.16           C  
ATOM   2526  N   THR D  53      23.050 104.587 -13.540  1.00 23.51           N  
ATOM   2527  CA  THR D  53      23.784 104.080 -14.695  1.00 25.66           C  
ATOM   2528  C   THR D  53      25.113 104.817 -14.885  1.00 25.90           C  
ATOM   2529  O   THR D  53      25.261 105.984 -14.486  1.00 25.77           O  
ATOM   2530  CB  THR D  53      22.936 104.181 -16.028  1.00 25.57           C  
ATOM   2531  OG1 THR D  53      22.588 105.551 -16.302  1.00 28.96           O  
ATOM   2532  CG2 THR D  53      21.680 103.352 -15.934  1.00 25.99           C  
ATOM   2533  N   VAL D  54      26.067 104.127 -15.499  1.00 26.38           N  
ATOM   2534  CA  VAL D  54      27.310 104.714 -15.963  1.00 26.98           C  
ATOM   2535  C   VAL D  54      27.399 104.443 -17.487  1.00 28.07           C  
ATOM   2536  O   VAL D  54      27.452 103.282 -17.919  1.00 26.69           O  
ATOM   2537  CB  VAL D  54      28.551 104.132 -15.264  1.00 27.79           C  
ATOM   2538  CG1 VAL D  54      29.829 104.772 -15.821  1.00 28.32           C  
ATOM   2539  CG2 VAL D  54      28.470 104.296 -13.704  1.00 27.51           C  
ATOM   2540  N   ASP D  55      27.383 105.522 -18.272  1.00 28.29           N  
ATOM   2541  CA  ASP D  55      27.371 105.428 -19.732  1.00 30.31           C  
ATOM   2542  C   ASP D  55      26.281 104.447 -20.194  1.00 31.15           C  
ATOM   2543  O   ASP D  55      26.466 103.711 -21.168  1.00 31.57           O  
ATOM   2544  CB  ASP D  55      28.753 105.006 -20.254  1.00 30.15           C  
ATOM   2545  CG  ASP D  55      29.800 106.062 -20.041  1.00 30.61           C  
ATOM   2546  OD1 ASP D  55      29.459 107.257 -19.992  1.00 30.54           O  
ATOM   2547  OD2 ASP D  55      30.988 105.697 -19.924  1.00 35.56           O  
ATOM   2548  N   GLY D  56      25.157 104.433 -19.477  1.00 30.95           N  
ATOM   2549  CA  GLY D  56      24.032 103.553 -19.806  1.00 31.85           C  
ATOM   2550  C   GLY D  56      24.037 102.153 -19.212  1.00 31.20           C  
ATOM   2551  O   GLY D  56      23.071 101.419 -19.371  1.00 31.33           O  
ATOM   2552  N   THR D  57      25.125 101.761 -18.555  1.00 31.39           N  
ATOM   2553  CA  THR D  57      25.169 100.480 -17.861  1.00 30.88           C  
ATOM   2554  C   THR D  57      24.685 100.641 -16.420  1.00 30.77           C  
ATOM   2555  O   THR D  57      25.248 101.445 -15.654  1.00 28.70           O  
ATOM   2556  CB  THR D  57      26.585  99.877 -17.868  1.00 31.85           C  
ATOM   2557  OG1 THR D  57      26.958  99.569 -19.219  1.00 34.27           O  
ATOM   2558  CG2 THR D  57      26.655  98.608 -17.009  1.00 31.04           C  
ATOM   2559  N   ILE D  58      23.664  99.860 -16.055  1.00 30.49           N  
ATOM   2560  CA  ILE D  58      23.098  99.897 -14.698  1.00 31.11           C  
ATOM   2561  C   ILE D  58      24.125  99.406 -13.693  1.00 30.68           C  
ATOM   2562  O   ILE D  58      24.677  98.298 -13.840  1.00 30.65           O  
ATOM   2563  CB  ILE D  58      21.800  99.023 -14.576  1.00 31.56           C  
ATOM   2564  CG1 ILE D  58      20.705  99.552 -15.510  1.00 33.05           C  
ATOM   2565  CG2 ILE D  58      21.276  98.983 -13.119  1.00 31.29           C  
ATOM   2566  CD1 ILE D  58      19.551  98.552 -15.777  1.00 32.67           C  
ATOM   2567  N   ILE D  59      24.400 100.223 -12.685  1.00 29.37           N  
ATOM   2568  CA  ILE D  59      25.214  99.778 -11.550  1.00 28.96           C  
ATOM   2569  C   ILE D  59      24.382  99.740 -10.255  1.00 29.31           C  
ATOM   2570  O   ILE D  59      24.811  99.180  -9.257  1.00 29.78           O  
ATOM   2571  CB  ILE D  59      26.515 100.625 -11.341  1.00 29.62           C  
ATOM   2572  CG1 ILE D  59      26.158 102.061 -10.909  1.00 26.99           C  
ATOM   2573  CG2 ILE D  59      27.447 100.560 -12.595  1.00 28.10           C  
ATOM   2574  CD1 ILE D  59      27.316 102.879 -10.353  1.00 29.53           C  
ATOM   2575  N   TRP D  60      23.188 100.322 -10.278  1.00 29.23           N  
ATOM   2576  CA  TRP D  60      22.292 100.187  -9.143  1.00 30.06           C  
ATOM   2577  C   TRP D  60      20.847 100.317  -9.578  1.00 30.29           C  
ATOM   2578  O   TRP D  60      20.524 101.160 -10.414  1.00 29.49           O  
ATOM   2579  CB  TRP D  60      22.588 101.224  -8.051  1.00 30.08           C  
ATOM   2580  CG  TRP D  60      21.881 100.888  -6.764  1.00 30.77           C  
ATOM   2581  CD1 TRP D  60      20.593 101.200  -6.427  1.00 30.52           C  
ATOM   2582  CD2 TRP D  60      22.417 100.143  -5.666  1.00 30.15           C  
ATOM   2583  NE1 TRP D  60      20.303 100.702  -5.182  1.00 30.94           N  
ATOM   2584  CE2 TRP D  60      21.405 100.051  -4.690  1.00 31.70           C  
ATOM   2585  CE3 TRP D  60      23.657  99.541  -5.415  1.00 30.44           C  
ATOM   2586  CZ2 TRP D  60      21.596  99.391  -3.467  1.00 31.28           C  
ATOM   2587  CZ3 TRP D  60      23.856  98.894  -4.202  1.00 31.58           C  
ATOM   2588  CH2 TRP D  60      22.827  98.821  -3.241  1.00 31.10           C  
ATOM   2589  N   GLU D  61      19.992  99.468  -9.017  1.00 31.12           N  
ATOM   2590  CA  GLU D  61      18.541  99.567  -9.215  1.00 32.37           C  
ATOM   2591  C   GLU D  61      17.866  99.088  -7.928  1.00 32.99           C  
ATOM   2592  O   GLU D  61      18.278  98.084  -7.336  1.00 33.55           O  
ATOM   2593  CB  GLU D  61      18.103  98.771 -10.454  1.00 32.47           C  
ATOM   2594  CG  GLU D  61      16.639  98.957 -10.876  1.00 34.26           C  
ATOM   2595  CD  GLU D  61      15.681  98.137 -10.028  1.00 36.46           C  
ATOM   2596  OE1 GLU D  61      15.964  96.939  -9.791  1.00 36.59           O  
ATOM   2597  OE2 GLU D  61      14.653  98.689  -9.578  1.00 37.24           O  
ATOM   2598  N   ARG D  62      16.861  99.841  -7.491  1.00 33.70           N  
ATOM   2599  CA  ARG D  62      16.262  99.719  -6.158  1.00 34.62           C  
ATOM   2600  C   ARG D  62      15.787  98.284  -5.845  1.00 35.42           C  
ATOM   2601  O   ARG D  62      16.151  97.718  -4.816  1.00 35.54           O  
ATOM   2602  CB  ARG D  62      15.106 100.717  -6.012  1.00 34.24           C  
ATOM   2603  CG  ARG D  62      14.406 100.683  -4.642  1.00 34.76           C  
ATOM   2604  CD  ARG D  62      13.245 101.671  -4.560  1.00 34.37           C  
ATOM   2605  NE  ARG D  62      12.176 101.371  -5.505  1.00 34.98           N  
ATOM   2606  CZ  ARG D  62      11.289 100.395  -5.335  1.00 35.46           C  
ATOM   2607  NH1 ARG D  62      11.329  99.639  -4.244  1.00 30.73           N  
ATOM   2608  NH2 ARG D  62      10.363 100.179  -6.257  1.00 36.88           N  
ATOM   2609  N   LYS D  63      15.010  97.707  -6.756  0.50 35.90           N  
ATOM   2611  CA  LYS D  63      14.392  96.398  -6.532  0.50 36.46           C  
ATOM   2613  C   LYS D  63      15.343  95.207  -6.638  0.50 37.15           C  
ATOM   2615  O   LYS D  63      15.138  94.203  -5.966  0.50 37.70           O  
ATOM   2617  CB  LYS D  63      13.178  96.215  -7.445  0.50 36.13           C  
ATOM   2619  CG  LYS D  63      11.875  96.698  -6.817  0.50 35.14           C  
ATOM   2621  CD  LYS D  63      10.793  97.041  -7.841  0.50 33.12           C  
ATOM   2623  CE  LYS D  63      10.342  95.842  -8.646  0.50 33.27           C  
ATOM   2625  NZ  LYS D  63       8.982  96.074  -9.216  0.50 33.15           N  
ATOM   2627  N   ARG D  64      16.380  95.313  -7.464  0.50 37.62           N  
ATOM   2629  CA  ARG D  64      17.302  94.193  -7.643  0.50 38.34           C  
ATOM   2631  C   ARG D  64      18.511  94.259  -6.699  0.50 38.43           C  
ATOM   2633  O   ARG D  64      19.188  93.252  -6.471  0.50 38.85           O  
ATOM   2635  CB  ARG D  64      17.742  94.084  -9.109  0.50 38.28           C  
ATOM   2637  CG  ARG D  64      19.057  94.769  -9.447  0.50 38.75           C  
ATOM   2639  CD  ARG D  64      19.344  94.706 -10.929  0.50 39.13           C  
ATOM   2641  NE  ARG D  64      18.340  95.434 -11.703  0.50 40.74           N  
ATOM   2643  CZ  ARG D  64      18.537  95.900 -12.929  0.50 41.60           C  
ATOM   2645  NH1 ARG D  64      17.561  96.554 -13.556  0.50 41.74           N  
ATOM   2647  NH2 ARG D  64      19.713  95.721 -13.526  0.50 41.45           N  
ATOM   2649  N   ASP D  65      18.774  95.447  -6.157  1.00 38.53           N  
ATOM   2650  CA  ASP D  65      19.853  95.644  -5.189  1.00 38.06           C  
ATOM   2651  C   ASP D  65      19.360  95.873  -3.768  1.00 37.75           C  
ATOM   2652  O   ASP D  65      20.162  96.038  -2.850  1.00 38.01           O  
ATOM   2653  CB  ASP D  65      20.798  96.750  -5.657  1.00 38.43           C  
ATOM   2654  CG  ASP D  65      21.481  96.399  -6.965  1.00 38.78           C  
ATOM   2655  OD1 ASP D  65      22.185  95.368  -7.005  1.00 39.71           O  
ATOM   2656  OD2 ASP D  65      21.299  97.135  -7.954  1.00 37.62           O  
ATOM   2657  N   GLY D  66      18.044  95.864  -3.586  1.00 37.88           N  
ATOM   2658  CA  GLY D  66      17.451  95.849  -2.246  1.00 37.79           C  
ATOM   2659  C   GLY D  66      17.426  97.177  -1.511  1.00 37.85           C  
ATOM   2660  O   GLY D  66      17.571  97.222  -0.277  1.00 38.70           O  
ATOM   2661  N   GLY D  67      17.246  98.263  -2.257  1.00 36.50           N  
ATOM   2662  CA  GLY D  67      17.106  99.575  -1.652  1.00 35.14           C  
ATOM   2663  C   GLY D  67      18.025 100.594  -2.296  1.00 34.38           C  
ATOM   2664  O   GLY D  67      18.037 100.735  -3.511  1.00 34.42           O  
ATOM   2665  N   PHE D  68      18.796 101.286  -1.466  1.00 33.59           N  
ATOM   2666  CA  PHE D  68      19.584 102.442  -1.902  1.00 33.11           C  
ATOM   2667  C   PHE D  68      21.016 102.263  -1.439  1.00 32.70           C  
ATOM   2668  O   PHE D  68      21.241 101.722  -0.365  1.00 32.95           O  
ATOM   2669  CB  PHE D  68      18.962 103.721  -1.326  1.00 32.70           C  
ATOM   2670  CG  PHE D  68      17.486 103.847  -1.628  1.00 33.50           C  
ATOM   2671  CD1 PHE D  68      17.056 104.566  -2.736  1.00 31.16           C  
ATOM   2672  CD2 PHE D  68      16.533 103.215  -0.822  1.00 33.90           C  
ATOM   2673  CE1 PHE D  68      15.699 104.678  -3.039  1.00 33.49           C  
ATOM   2674  CE2 PHE D  68      15.170 103.310  -1.125  1.00 33.47           C  
ATOM   2675  CZ  PHE D  68      14.761 104.047  -2.235  1.00 33.57           C  
ATOM   2676  N   PRO D  69      21.992 102.689  -2.261  1.00 32.62           N  
ATOM   2677  CA  PRO D  69      23.392 102.428  -1.920  1.00 32.84           C  
ATOM   2678  C   PRO D  69      23.938 103.339  -0.824  1.00 33.14           C  
ATOM   2679  O   PRO D  69      23.510 104.489  -0.682  1.00 33.05           O  
ATOM   2680  CB  PRO D  69      24.138 102.684  -3.238  1.00 32.01           C  
ATOM   2681  CG  PRO D  69      23.324 103.752  -3.928  1.00 32.02           C  
ATOM   2682  CD  PRO D  69      21.856 103.426  -3.535  1.00 32.88           C  
ATOM   2683  N   GLY D  70      24.874 102.795  -0.054  1.00 33.98           N  
ATOM   2684  CA  GLY D  70      25.702 103.575   0.857  1.00 34.07           C  
ATOM   2685  C   GLY D  70      26.814 104.189   0.028  1.00 34.75           C  
ATOM   2686  O   GLY D  70      27.067 103.753  -1.102  1.00 34.19           O  
ATOM   2687  N   PRO D  71      27.481 105.232   0.554  1.00 35.27           N  
ATOM   2688  CA  PRO D  71      28.502 105.891  -0.268  1.00 35.35           C  
ATOM   2689  C   PRO D  71      29.666 104.958  -0.649  1.00 35.36           C  
ATOM   2690  O   PRO D  71      30.155 105.014  -1.771  1.00 34.29           O  
ATOM   2691  CB  PRO D  71      28.981 107.034   0.637  1.00 35.70           C  
ATOM   2692  CG  PRO D  71      28.645 106.580   2.001  1.00 35.30           C  
ATOM   2693  CD  PRO D  71      27.353 105.871   1.870  1.00 35.28           C  
ATOM   2694  N   LYS D  72      30.071 104.076   0.259  1.00 36.59           N  
ATOM   2695  CA  LYS D  72      31.243 103.231  -0.005  1.00 37.96           C  
ATOM   2696  C   LYS D  72      31.007 102.332  -1.230  1.00 37.58           C  
ATOM   2697  O   LYS D  72      31.797 102.330  -2.169  1.00 37.09           O  
ATOM   2698  CB  LYS D  72      31.649 102.432   1.239  1.00 38.24           C  
ATOM   2699  CG  LYS D  72      33.000 101.764   1.097  1.00 41.94           C  
ATOM   2700  CD  LYS D  72      33.655 101.501   2.450  1.00 46.72           C  
ATOM   2701  CE  LYS D  72      34.674 100.363   2.349  1.00 51.33           C  
ATOM   2702  NZ  LYS D  72      35.724 100.641   1.309  1.00 54.39           N  
ATOM   2703  N   GLU D  73      29.889 101.618  -1.236  1.00 38.47           N  
ATOM   2704  CA  GLU D  73      29.575 100.737  -2.358  1.00 39.60           C  
ATOM   2705  C   GLU D  73      29.265 101.450  -3.681  1.00 38.67           C  
ATOM   2706  O   GLU D  73      29.637 100.964  -4.747  1.00 38.55           O  
ATOM   2707  CB  GLU D  73      28.478  99.747  -1.985  1.00 39.18           C  
ATOM   2708  CG  GLU D  73      27.165 100.338  -1.515  1.00 42.49           C  
ATOM   2709  CD  GLU D  73      26.198  99.259  -1.032  1.00 43.15           C  
ATOM   2710  OE1 GLU D  73      25.209  99.600  -0.335  1.00 46.30           O  
ATOM   2711  OE2 GLU D  73      26.441  98.058  -1.350  1.00 48.30           O  
ATOM   2712  N   LEU D  74      28.601 102.603  -3.605  1.00 37.90           N  
ATOM   2713  CA  LEU D  74      28.315 103.415  -4.785  1.00 37.35           C  
ATOM   2714  C   LEU D  74      29.605 103.743  -5.553  1.00 37.14           C  
ATOM   2715  O   LEU D  74      29.715 103.482  -6.758  1.00 36.13           O  
ATOM   2716  CB  LEU D  74      27.575 104.710  -4.372  1.00 37.63           C  
ATOM   2717  CG  LEU D  74      27.350 105.858  -5.364  1.00 37.77           C  
ATOM   2718  CD1 LEU D  74      26.614 105.363  -6.614  1.00 39.24           C  
ATOM   2719  CD2 LEU D  74      26.619 107.066  -4.683  1.00 37.79           C  
ATOM   2720  N   LYS D  75      30.574 104.292  -4.826  0.50 36.88           N  
ATOM   2722  CA  LYS D  75      31.839 104.742  -5.399  0.50 37.27           C  
ATOM   2724  C   LYS D  75      32.641 103.593  -6.003  0.50 37.84           C  
ATOM   2726  O   LYS D  75      33.255 103.753  -7.062  0.50 37.83           O  
ATOM   2728  CB  LYS D  75      32.665 105.468  -4.342  0.50 36.95           C  
ATOM   2730  CG  LYS D  75      31.970 106.684  -3.738  0.50 35.98           C  
ATOM   2732  CD  LYS D  75      32.845 107.357  -2.708  0.50 35.03           C  
ATOM   2734  CE  LYS D  75      32.023 108.219  -1.780  0.50 35.06           C  
ATOM   2736  NZ  LYS D  75      32.888 108.922  -0.814  0.50 36.00           N  
ATOM   2738  N   GLN D  76      32.618 102.444  -5.331  1.00 38.53           N  
ATOM   2739  CA  GLN D  76      33.381 101.264  -5.758  1.00 40.31           C  
ATOM   2740  C   GLN D  76      32.855 100.688  -7.065  1.00 40.84           C  
ATOM   2741  O   GLN D  76      33.641 100.356  -7.955  1.00 40.76           O  
ATOM   2742  CB  GLN D  76      33.426 100.170  -4.682  1.00 40.74           C  
ATOM   2743  CG  GLN D  76      34.594 100.281  -3.664  1.00 43.74           C  
ATOM   2744  CD  GLN D  76      36.024 100.435  -4.259  1.00 46.44           C  
ATOM   2745  OE1 GLN D  76      36.309 100.103  -5.417  1.00 46.78           O  
ATOM   2746  NE2 GLN D  76      36.927 100.941  -3.431  1.00 48.20           N  
ATOM   2747  N   ARG D  77      31.534 100.581  -7.175  1.00 41.56           N  
ATOM   2748  CA  ARG D  77      30.892 100.128  -8.419  1.00 42.29           C  
ATOM   2749  C   ARG D  77      31.215 101.028  -9.609  1.00 43.04           C  
ATOM   2750  O   ARG D  77      31.319 100.555 -10.751  1.00 43.30           O  
ATOM   2751  CB  ARG D  77      29.383 100.024  -8.244  1.00 42.05           C  
ATOM   2752  CG  ARG D  77      28.978  99.080  -7.164  1.00 42.36           C  
ATOM   2753  CD  ARG D  77      27.529  98.704  -7.271  1.00 42.85           C  
ATOM   2754  NE  ARG D  77      27.147  97.692  -6.295  1.00 42.69           N  
ATOM   2755  CZ  ARG D  77      26.067  96.912  -6.396  1.00 42.69           C  
ATOM   2756  NH1 ARG D  77      25.252  97.021  -7.440  1.00 42.45           N  
ATOM   2757  NH2 ARG D  77      25.806  96.011  -5.451  1.00 42.89           N  
ATOM   2758  N   ILE D  78      31.379 102.322  -9.339  1.00 43.44           N  
ATOM   2759  CA  ILE D  78      31.789 103.279 -10.351  1.00 44.01           C  
ATOM   2760  C   ILE D  78      33.270 103.050 -10.685  1.00 45.11           C  
ATOM   2761  O   ILE D  78      33.653 102.939 -11.855  1.00 44.82           O  
ATOM   2762  CB  ILE D  78      31.538 104.732  -9.883  1.00 43.26           C  
ATOM   2763  CG1 ILE D  78      30.033 105.009  -9.811  1.00 42.10           C  
ATOM   2764  CG2 ILE D  78      32.225 105.722 -10.808  1.00 43.17           C  
ATOM   2765  CD1 ILE D  78      29.662 106.294  -9.109  1.00 40.08           C  
ATOM   2766  N   ARG D  79      34.082 102.960  -9.636  1.00 46.58           N  
ATOM   2767  CA  ARG D  79      35.504 102.662  -9.755  1.00 48.40           C  
ATOM   2768  C   ARG D  79      35.739 101.382 -10.567  1.00 49.47           C  
ATOM   2769  O   ARG D  79      36.544 101.380 -11.499  1.00 49.88           O  
ATOM   2770  CB  ARG D  79      36.132 102.555  -8.363  1.00 47.94           C  
ATOM   2771  CG  ARG D  79      37.574 102.996  -8.312  1.00 48.33           C  
ATOM   2772  CD  ARG D  79      38.051 103.209  -6.878  1.00 47.39           C  
ATOM   2773  NE  ARG D  79      37.643 104.503  -6.329  1.00 46.79           N  
ATOM   2774  CZ  ARG D  79      36.884 104.663  -5.242  1.00 46.76           C  
ATOM   2775  NH1 ARG D  79      36.582 105.885  -4.813  1.00 46.90           N  
ATOM   2776  NH2 ARG D  79      36.433 103.610  -4.571  1.00 45.59           N  
ATOM   2777  N   ASP D  80      35.011 100.318 -10.238  1.00 50.98           N  
ATOM   2778  CA  ASP D  80      35.083  99.056 -10.985  1.00 52.76           C  
ATOM   2779  C   ASP D  80      35.030  99.268 -12.506  1.00 54.28           C  
ATOM   2780  O   ASP D  80      35.942  98.836 -13.225  1.00 54.78           O  
ATOM   2781  CB  ASP D  80      33.986  98.072 -10.536  1.00 52.62           C  
ATOM   2782  CG  ASP D  80      34.267  97.440  -9.158  1.00 52.41           C  
ATOM   2783  OD1 ASP D  80      35.398  97.569  -8.633  1.00 51.84           O  
ATOM   2784  OD2 ASP D  80      33.342  96.814  -8.601  1.00 52.01           O  
ATOM   2785  N   LEU D  81      33.983  99.948 -12.983  1.00 55.48           N  
ATOM   2786  CA  LEU D  81      33.828 100.256 -14.409  1.00 56.59           C  
ATOM   2787  C   LEU D  81      34.909 101.183 -14.965  1.00 57.62           C  
ATOM   2788  O   LEU D  81      35.476 100.910 -16.024  1.00 58.30           O  
ATOM   2789  CB  LEU D  81      32.442 100.840 -14.697  1.00 56.27           C  
ATOM   2790  CG  LEU D  81      31.232  99.901 -14.713  1.00 56.06           C  
ATOM   2791  CD1 LEU D  81      29.970 100.706 -14.900  1.00 53.41           C  
ATOM   2792  CD2 LEU D  81      31.339  98.847 -15.817  1.00 55.87           C  
ATOM   2793  N   ILE D  82      35.201 102.270 -14.255  1.00 58.63           N  
ATOM   2794  CA  ILE D  82      36.180 103.252 -14.728  1.00 59.42           C  
ATOM   2795  C   ILE D  82      37.599 102.792 -14.406  1.00 59.89           C  
ATOM   2796  O   ILE D  82      38.478 102.814 -15.272  1.00 60.69           O  
ATOM   2797  CB  ILE D  82      35.963 104.669 -14.122  1.00 59.40           C  
ATOM   2798  CG1 ILE D  82      34.482 104.962 -13.857  1.00 59.60           C  
ATOM   2799  CG2 ILE D  82      36.575 105.728 -15.021  1.00 60.29           C  
ATOM   2800  CD1 ILE D  82      33.555 104.789 -15.058  1.00 60.23           C  
TER    2801      ILE D  82                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
