
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  839),  selected  103 , name 2fsw_B
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 2fsw_B.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     2_B      -       -           -
LGA    R     3_B      -       -           -
LGA    K     4_B      -       -           -
LGA    I     5_B      S       1          6.279
LGA    S     6_B      N       2          2.950
LGA    D     7_B      A       3           #
LGA    E     8_B      M       4           -
LGA    E     9_B      L       5           -
LGA    -       -      R       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      D       9           -
LGA    -       -      T      10           -
LGA    -       -      E      11           -
LGA    -       -      I      12           -
LGA    C    10_B      C      13          3.701
LGA    P    11_B      I      14          2.586
LGA    V    12_B      D      15          6.275
LGA    R    13_B      P      16          2.925
LGA    -       -      S      17           -
LGA    -       -      E      18           -
LGA    K    14_B      S      19          1.643
LGA    S    15_B      V      20          3.234
LGA    X    16_B      L      21          1.341
LGA    Q    17_B      H      22          2.496
LGA    I    18_B      L      23          2.661
LGA    F    19_B      L      24          0.788
LGA    A    20_B      G      25          2.041
LGA    G    21_B      K      26          1.085
LGA    K    22_B      K      27          0.504
LGA    W    23_B      Y      28          1.419
LGA    T    24_B      T      29          1.146
LGA    L    25_B      M      30          1.088
LGA    L    26_B      L      31          0.691
LGA    I    27_B      I      32          0.326
LGA    I    28_B      I      33          0.464
LGA    F    29_B      S      34          0.313
LGA    Q    30_B      V      35          0.280
LGA    I    31_B      L      36          0.438
LGA    N    32_B      G      37          0.895
LGA    R    33_B      N      38          5.659
LGA    -       -      G      39           -
LGA    R    34_B      S      40          4.376
LGA    I    35_B      T      41          3.332
LGA    I    36_B      R      42          3.602
LGA    -       -      Q      43           -
LGA    R    37_B      N      44          1.576
LGA    Y    38_B      F      45          1.203
LGA    G    39_B      N      46          0.983
LGA    E    40_B      D      47          0.790
LGA    L    41_B      I      48          0.535
LGA    K    42_B      R      49          0.661
LGA    R    43_B      S      50          0.257
LGA    A    44_B      S      51          0.159
LGA    I    45_B      I      52          0.607
LGA    P    46_B      P      53          1.941
LGA    G    47_B      G      54          0.620
LGA    I    48_B      I      55          0.719
LGA    S    49_B      S      56          0.750
LGA    E    50_B      S      57          0.961
LGA    K    51_B      T      58          0.614
LGA    X    52_B      I      59          0.645
LGA    L    53_B      L      60          0.837
LGA    I    54_B      S      61          0.724
LGA    D    55_B      R      62          1.059
LGA    E    56_B      R      63          0.999
LGA    L    57_B      I      64          1.055
LGA    K    58_B      K      65          1.099
LGA    F    59_B      D      66          1.103
LGA    L    60_B      L      67          0.777
LGA    C    61_B      I      68          0.932
LGA    G    62_B      D      69          1.099
LGA    K    63_B      S      70          1.038
LGA    G    64_B      G      71          1.035
LGA    L    65_B      L      72          0.523
LGA    I    66_B      V      73          0.746
LGA    K    67_B      E      74          1.197
LGA    K    68_B      R      75          0.835
LGA    K    69_B      R      76          1.018
LGA    Q    70_B      S      77          0.844
LGA    Y    71_B      G      78          2.181
LGA    P    72_B      Q      79          3.777
LGA    E    73_B      -       -           -
LGA    V    74_B      -       -           -
LGA    P    75_B      -       -           -
LGA    P    76_B      -       -           -
LGA    R    77_B      I      80          2.489
LGA    V    78_B      T      81          1.339
LGA    E    79_B      T      82          0.784
LGA    Y    80_B      Y      83          0.736
LGA    S    81_B      A      84          0.809
LGA    L    82_B      L      85          0.711
LGA    T    83_B      T      86          0.418
LGA    P    84_B      E      87          0.361
LGA    L    85_B      K      88          0.701
LGA    G    86_B      G      89          0.493
LGA    E    87_B      M      90          0.850
LGA    K    88_B      N      91          1.132
LGA    V    89_B      V      92          0.513
LGA    L    90_B      R      93          1.356
LGA    P    91_B      N      94          2.863
LGA    I    92_B      S      95          2.925
LGA    I    93_B      L      96          1.541
LGA    D    94_B      M      97          1.240
LGA    E    95_B      P      98          2.489
LGA    I    96_B      L      99          2.107
LGA    A    97_B      L     100          1.507
LGA    K    98_B      Q     101          2.325
LGA    F    99_B      Y     102          2.096
LGA    G   100_B      I     103          1.297
LGA    X   101_B      S     104          2.555
LGA    E   102_B      V     105          2.352
LGA    N   103_B      L     106          1.441
LGA    L   104_B      D     107          1.542
LGA    -       -      R     108           -
LGA    -       -      N     109           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103  109    5.0     93    1.96    22.58     77.881     4.506

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.823614 * X  +   0.469367 * Y  +   0.318363 * Z  + -62.054993
  Y_new =  -0.480812 * X  +   0.875564 * Y  +  -0.046982 * Z  + -10.345113
  Z_new =  -0.300799 * X  +  -0.114378 * Y  +   0.946804 * Z  + -95.379425 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.120221    3.021371  [ DEG:    -6.8882    173.1118 ]
  Theta =   0.305530    2.836063  [ DEG:    17.5056    162.4944 ]
  Phi   =  -0.528410    2.613182  [ DEG:   -30.2757    149.7243 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fsw_B                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fsw_B.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103  109   5.0   93   1.96   22.58  77.881
REMARK  ---------------------------------------------------------- 
MOLECULE 2fsw_B
HEADER    TRANSCRIPTION                           23-JAN-06   2FSW              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE TRANSCRIPTIONAL                     
TITLE    2 REGUALATOR, MARR FAMILY FROM PORPHYROMONAS GINGIVALIS W83            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PG_0823 PROTEIN;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PORPHYROMONAS GINGIVALIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: W83;                                                         
SOURCE   5 GENE: PG_0823;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPHA-BETA STRUCTURE, HELIX-TURN-HELIX, WINGED-HELIX-TURN-            
KEYWDS   2 HEIX, STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE                    
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,P.QUARTEY,J.BUELT,S.MOY,A.JOACHIMIAK,MIDWEST CENTER             
AUTHOR   2 FOR STRUCTURAL GENOMICS (MCSG)                                       
REVDAT   1   07-MAR-06 2FSW    0                                                
JRNL        AUTH   Y.KIM,P.QUARTEY,J.BUELT,S.MOY,A.JOACHIMIAK                   
JRNL        TITL   TRANSCRIPTIONAL REGUALATOR, MARR FAMILY FROM                 
JRNL        TITL 2 PORPHYROMONAS GINGIVALIS W83                                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.16 ANGSTROMS.                                          
DBREF  2FSW A    1   104  UNP    Q7M7B7   Q7M7B7_PORGI     1    104             
DBREF  2FSW B    1   104  UNP    Q7M7B7   Q7M7B7_PORGI     1    104             
SEQRES   1 A  107  SER ASN ALA MSE GLU ARG LYS ILE SER ASP GLU GLU CYS          
SEQRES   2 A  107  PRO VAL ARG LYS SER MSE GLN ILE PHE ALA GLY LYS TRP          
SEQRES   3 A  107  THR LEU LEU ILE ILE PHE GLN ILE ASN ARG ARG ILE ILE          
SEQRES   4 A  107  ARG TYR GLY GLU LEU LYS ARG ALA ILE PRO GLY ILE SER          
SEQRES   5 A  107  GLU LYS MSE LEU ILE ASP GLU LEU LYS PHE LEU CYS GLY          
SEQRES   6 A  107  LYS GLY LEU ILE LYS LYS LYS GLN TYR PRO GLU VAL PRO          
SEQRES   7 A  107  PRO ARG VAL GLU TYR SER LEU THR PRO LEU GLY GLU LYS          
SEQRES   8 A  107  VAL LEU PRO ILE ILE ASP GLU ILE ALA LYS PHE GLY MSE          
SEQRES   9 A  107  GLU ASN LEU                                                  
SEQRES   1 B  107  SER ASN ALA MSE GLU ARG LYS ILE SER ASP GLU GLU CYS          
SEQRES   2 B  107  PRO VAL ARG LYS SER MSE GLN ILE PHE ALA GLY LYS TRP          
SEQRES   3 B  107  THR LEU LEU ILE ILE PHE GLN ILE ASN ARG ARG ILE ILE          
SEQRES   4 B  107  ARG TYR GLY GLU LEU LYS ARG ALA ILE PRO GLY ILE SER          
SEQRES   5 B  107  GLU LYS MSE LEU ILE ASP GLU LEU LYS PHE LEU CYS GLY          
SEQRES   6 B  107  LYS GLY LEU ILE LYS LYS LYS GLN TYR PRO GLU VAL PRO          
SEQRES   7 B  107  PRO ARG VAL GLU TYR SER LEU THR PRO LEU GLY GLU LYS          
SEQRES   8 B  107  VAL LEU PRO ILE ILE ASP GLU ILE ALA LYS PHE GLY MSE          
SEQRES   9 B  107  GLU ASN LEU                                                  
HET    MSE  A  16       8                                                       
HET    MSE  A  52       8                                                       
HET    MSE  A 101      16                                                       
HET    MSE  B  16       8                                                       
HET    MSE  B  52      16                                                       
HET    MSE  B 101       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *165(H2 O)                                                    
CRYST1   35.971   82.241  116.601  90.00  90.00  90.00 P 21 21 21    8          
ATOM    935  N   GLU B   2       3.112  30.870  23.720  1.00 76.86           N  
ATOM    936  CA  GLU B   2       1.661  30.541  23.821  1.00 76.76           C  
ATOM    937  C   GLU B   2       0.837  31.212  22.712  1.00 76.19           C  
ATOM    938  O   GLU B   2       0.671  32.438  22.693  1.00 76.62           O  
ATOM    939  CB  GLU B   2       1.132  30.933  25.199  1.00 76.80           C  
ATOM    940  CG  GLU B   2      -0.191  30.285  25.588  1.00 77.58           C  
ATOM    941  CD  GLU B   2      -0.523  30.497  27.063  1.00 77.88           C  
ATOM    942  OE1 GLU B   2      -1.687  30.261  27.459  1.00 79.10           O  
ATOM    943  OE2 GLU B   2       0.383  30.899  27.833  1.00 79.19           O  
ATOM    944  N   ARG B   3       0.329  30.395  21.793  1.00 74.95           N  
ATOM    945  CA  ARG B   3      -0.473  30.872  20.675  1.00 73.73           C  
ATOM    946  C   ARG B   3      -1.718  30.001  20.587  1.00 73.86           C  
ATOM    947  O   ARG B   3      -1.714  28.876  21.081  1.00 73.74           O  
ATOM    948  CB  ARG B   3       0.332  30.787  19.361  1.00 73.76           C  
ATOM    949  CG  ARG B   3       1.749  31.426  19.411  1.00 72.71           C  
ATOM    950  CD  ARG B   3       2.469  31.385  18.048  1.00 72.20           C  
ATOM    951  NE  ARG B   3       1.683  32.025  16.987  1.00 68.55           N  
ATOM    952  CZ  ARG B   3       1.744  33.321  16.681  1.00 67.06           C  
ATOM    953  NH1 ARG B   3       2.568  34.131  17.341  1.00 66.51           N  
ATOM    954  NH2 ARG B   3       0.984  33.809  15.709  1.00 66.92           N  
ATOM    955  N   LYS B   4      -2.777  30.515  19.963  1.00 73.77           N  
ATOM    956  CA  LYS B   4      -3.987  29.724  19.698  1.00 74.04           C  
ATOM    957  C   LYS B   4      -3.649  28.424  18.970  1.00 73.66           C  
ATOM    958  O   LYS B   4      -2.820  28.429  18.063  1.00 73.51           O  
ATOM    959  CB  LYS B   4      -4.956  30.521  18.825  1.00 74.33           C  
ATOM    960  CG  LYS B   4      -5.967  31.380  19.571  1.00 74.46           C  
ATOM    961  CD  LYS B   4      -6.921  32.046  18.577  1.00 74.84           C  
ATOM    962  CE  LYS B   4      -7.788  31.018  17.820  1.00 76.59           C  
ATOM    963  NZ  LYS B   4      -7.926  31.322  16.354  1.00 76.94           N  
ATOM    964  N   ILE B   5      -4.298  27.321  19.347  1.00 73.01           N  
ATOM    965  CA  ILE B   5      -4.043  26.038  18.684  1.00 72.52           C  
ATOM    966  C   ILE B   5      -4.798  25.920  17.361  1.00 72.28           C  
ATOM    967  O   ILE B   5      -5.777  26.630  17.127  1.00 72.18           O  
ATOM    968  CB  ILE B   5      -4.324  24.796  19.588  1.00 72.42           C  
ATOM    969  CG1 ILE B   5      -5.824  24.618  19.844  1.00 72.88           C  
ATOM    970  CG2 ILE B   5      -3.509  24.868  20.895  1.00 72.65           C  
ATOM    971  CD1 ILE B   5      -6.223  23.201  20.214  1.00 72.93           C  
ATOM    972  N   SER B   6      -4.330  25.013  16.507  1.00 71.98           N  
ATOM    973  CA  SER B   6      -4.962  24.757  15.219  1.00 71.86           C  
ATOM    974  C   SER B   6      -5.876  23.536  15.266  1.00 71.91           C  
ATOM    975  O   SER B   6      -5.564  22.478  14.711  1.00 71.62           O  
ATOM    976  CB  SER B   6      -3.912  24.627  14.105  1.00 71.68           C  
ATOM    977  OG  SER B   6      -3.296  25.877  13.842  1.00 71.44           O  
ATOM    978  N   ASP B   7      -7.011  23.695  15.941  1.00 72.13           N  
ATOM    979  CA  ASP B   7      -8.053  22.671  15.954  1.00 72.43           C  
ATOM    980  C   ASP B   7      -8.837  22.708  14.643  1.00 72.39           C  
ATOM    981  O   ASP B   7      -8.361  23.261  13.644  1.00 72.56           O  
ATOM    982  CB  ASP B   7      -8.987  22.862  17.157  1.00 72.63           C  
ATOM    983  CG  ASP B   7      -9.433  24.309  17.340  1.00 73.41           C  
ATOM    984  OD1 ASP B   7      -9.535  25.060  16.336  1.00 74.74           O  
ATOM    985  OD2 ASP B   7      -9.687  24.692  18.504  1.00 74.10           O  
ATOM    986  N   GLU B   8     -10.040  22.138  14.638  1.00 72.17           N  
ATOM    987  CA  GLU B   8     -10.852  22.139  13.424  1.00 72.07           C  
ATOM    988  C   GLU B   8     -11.522  23.499  13.159  1.00 71.19           C  
ATOM    989  O   GLU B   8     -12.168  23.692  12.128  1.00 71.69           O  
ATOM    990  CB  GLU B   8     -11.859  20.980  13.407  1.00 71.96           C  
ATOM    991  CG  GLU B   8     -12.128  20.487  11.981  1.00 72.77           C  
ATOM    992  CD  GLU B   8     -12.814  19.128  11.900  1.00 73.36           C  
ATOM    993  OE1 GLU B   8     -12.893  18.591  10.766  1.00 75.19           O  
ATOM    994  OE2 GLU B   8     -13.275  18.600  12.944  1.00 74.63           O  
ATOM    995  N   GLU B   9     -11.341  24.440  14.078  1.00 70.15           N  
ATOM    996  CA  GLU B   9     -11.818  25.806  13.883  1.00 69.16           C  
ATOM    997  C   GLU B   9     -10.769  26.775  13.309  1.00 68.33           C  
ATOM    998  O   GLU B   9     -11.126  27.852  12.817  1.00 68.39           O  
ATOM    999  CB  GLU B   9     -12.333  26.350  15.198  1.00 69.36           C  
ATOM   1000  CG  GLU B   9     -13.624  25.675  15.644  1.00 71.10           C  
ATOM   1001  CD  GLU B   9     -14.479  26.610  16.433  1.00 72.48           C  
ATOM   1002  OE1 GLU B   9     -14.030  27.030  17.524  1.00 74.03           O  
ATOM   1003  OE2 GLU B   9     -15.582  26.934  15.950  1.00 73.82           O  
ATOM   1004  N   CYS B  10      -9.490  26.404  13.386  1.00 66.21           N  
ATOM   1005  CA  CYS B  10      -8.415  27.289  12.951  1.00 65.21           C  
ATOM   1006  C   CYS B  10      -8.578  27.693  11.471  1.00 63.60           C  
ATOM   1007  O   CYS B  10      -8.757  26.832  10.601  1.00 62.94           O  
ATOM   1008  CB  CYS B  10      -7.037  26.674  13.235  1.00 65.29           C  
ATOM   1009  SG  CYS B  10      -5.654  27.468  12.376  1.00 65.84           S  
ATOM   1010  N   PRO B  11      -8.529  29.012  11.198  1.00 62.54           N  
ATOM   1011  CA  PRO B  11      -8.768  29.547   9.854  1.00 62.02           C  
ATOM   1012  C   PRO B  11      -7.737  29.021   8.844  1.00 61.36           C  
ATOM   1013  O   PRO B  11      -8.052  28.858   7.663  1.00 61.62           O  
ATOM   1014  CB  PRO B  11      -8.650  31.070  10.051  1.00 62.32           C  
ATOM   1015  CG  PRO B  11      -7.849  31.244  11.300  1.00 61.92           C  
ATOM   1016  CD  PRO B  11      -8.201  30.076  12.172  1.00 62.14           C  
ATOM   1017  N   VAL B  12      -6.533  28.718   9.323  1.00 60.19           N  
ATOM   1018  CA  VAL B  12      -5.473  28.181   8.476  1.00 59.49           C  
ATOM   1019  C   VAL B  12      -5.744  26.703   8.175  1.00 59.24           C  
ATOM   1020  O   VAL B  12      -5.647  26.268   7.026  1.00 58.37           O  
ATOM   1021  CB  VAL B  12      -4.066  28.400   9.119  1.00 59.07           C  
ATOM   1022  CG1 VAL B  12      -2.958  27.779   8.267  1.00 59.11           C  
ATOM   1023  CG2 VAL B  12      -3.819  29.876   9.320  1.00 57.79           C  
ATOM   1024  N   ARG B  13      -6.110  25.955   9.218  1.00 59.20           N  
ATOM   1025  CA  ARG B  13      -6.506  24.550   9.088  1.00 59.31           C  
ATOM   1026  C   ARG B  13      -7.761  24.343   8.232  1.00 59.24           C  
ATOM   1027  O   ARG B  13      -7.841  23.372   7.465  1.00 58.95           O  
ATOM   1028  CB  ARG B  13      -6.681  23.914  10.476  1.00 59.46           C  
ATOM   1029  CG  ARG B  13      -6.960  22.424  10.434  1.00 60.47           C  
ATOM   1030  CD  ARG B  13      -6.341  21.711  11.614  1.00 61.23           C  
ATOM   1031  NE  ARG B  13      -6.507  20.263  11.509  1.00 62.40           N  
ATOM   1032  CZ  ARG B  13      -6.259  19.402  12.494  1.00 62.43           C  
ATOM   1033  NH1 ARG B  13      -5.835  19.829  13.682  1.00 61.33           N  
ATOM   1034  NH2 ARG B  13      -6.432  18.107  12.287  1.00 61.44           N  
ATOM   1035  N   LYS B  14      -8.741  25.238   8.365  1.00 59.40           N  
ATOM   1036  CA  LYS B  14      -9.908  25.202   7.482  1.00 59.91           C  
ATOM   1037  C   LYS B  14      -9.449  25.350   6.029  1.00 59.85           C  
ATOM   1038  O   LYS B  14      -9.851  24.574   5.157  1.00 59.49           O  
ATOM   1039  CB  LYS B  14     -10.921  26.309   7.816  1.00 60.13           C  
ATOM   1040  CG  LYS B  14     -11.674  26.165   9.139  1.00 61.45           C  
ATOM   1041  CD  LYS B  14     -13.017  26.892   9.054  1.00 64.71           C  
ATOM   1042  CE  LYS B  14     -13.214  27.922  10.174  1.00 66.90           C  
ATOM   1043  NZ  LYS B  14     -12.424  29.185   9.908  1.00 68.03           N  
ATOM   1044  N   SER B  15      -8.575  26.330   5.784  1.00 59.77           N  
ATOM   1045  CA  SER B  15      -8.146  26.656   4.413  1.00 59.36           C  
ATOM   1046  C   SER B  15      -7.378  25.528   3.752  1.00 59.49           C  
ATOM   1047  O   SER B  15      -7.583  25.248   2.567  1.00 58.52           O  
ATOM   1048  CB  SER B  15      -7.341  27.941   4.391  1.00 58.59           C  
ATOM   1049  OG  SER B  15      -8.195  29.034   4.624  1.00 58.98           O  
HETATM 1050  N   MSE B  16      -6.504  24.882   4.533  1.00 60.24           N  
HETATM 1051  CA  MSE B  16      -5.703  23.760   4.047  1.00 60.99           C  
HETATM 1052  C   MSE B  16      -6.522  22.527   3.632  1.00 61.91           C  
HETATM 1053  O   MSE B  16      -6.041  21.714   2.843  1.00 62.53           O  
HETATM 1054  CB  MSE B  16      -4.590  23.390   5.038  1.00 60.98           C  
HETATM 1055  CG  MSE B  16      -3.503  24.463   5.216  1.00 60.35           C  
HETATM 1056 SE   MSE B  16      -3.010  25.492   3.605  0.70 60.17          SE  
HETATM 1057  CE  MSE B  16      -2.525  24.075   2.380  1.00 57.53           C  
ATOM   1058  N   GLN B  17      -7.758  22.405   4.113  1.00 62.76           N  
ATOM   1059  CA  GLN B  17      -8.674  21.370   3.597  1.00 63.83           C  
ATOM   1060  C   GLN B  17      -8.874  21.518   2.085  1.00 63.85           C  
ATOM   1061  O   GLN B  17      -8.856  20.534   1.340  1.00 64.16           O  
ATOM   1062  CB  GLN B  17     -10.035  21.442   4.291  1.00 64.26           C  
ATOM   1063  CG  GLN B  17     -10.011  21.263   5.800  1.00 66.23           C  
ATOM   1064  CD  GLN B  17      -9.735  19.837   6.222  1.00 68.44           C  
ATOM   1065  OE1 GLN B  17      -8.855  19.582   7.048  1.00 69.47           O  
ATOM   1066  NE2 GLN B  17     -10.486  18.894   5.653  1.00 69.83           N  
ATOM   1067  N   ILE B  18      -9.060  22.759   1.641  1.00 63.86           N  
ATOM   1068  CA  ILE B  18      -9.223  23.076   0.222  1.00 63.61           C  
ATOM   1069  C   ILE B  18      -7.892  23.042  -0.541  1.00 62.96           C  
ATOM   1070  O   ILE B  18      -7.797  22.405  -1.595  1.00 62.61           O  
ATOM   1071  CB  ILE B  18      -9.864  24.471   0.043  1.00 63.57           C  
ATOM   1072  CG1 ILE B  18     -11.196  24.557   0.799  1.00 64.68           C  
ATOM   1073  CG2 ILE B  18     -10.032  24.795  -1.429  1.00 64.16           C  
ATOM   1074  CD1 ILE B  18     -11.913  25.912   0.691  1.00 64.63           C  
ATOM   1075  N   PHE B  19      -6.874  23.703   0.020  1.00 62.41           N  
ATOM   1076  CA  PHE B  19      -5.652  24.072  -0.708  1.00 62.06           C  
ATOM   1077  C   PHE B  19      -4.518  23.063  -0.623  1.00 62.08           C  
ATOM   1078  O   PHE B  19      -3.497  23.238  -1.294  1.00 61.73           O  
ATOM   1079  CB  PHE B  19      -5.090  25.421  -0.210  1.00 61.44           C  
ATOM   1080  CG  PHE B  19      -6.030  26.583  -0.349  1.00 60.81           C  
ATOM   1081  CD1 PHE B  19      -6.068  27.575   0.640  1.00 59.62           C  
ATOM   1082  CD2 PHE B  19      -6.852  26.724  -1.471  1.00 60.35           C  
ATOM   1083  CE1 PHE B  19      -6.930  28.663   0.531  1.00 57.29           C  
ATOM   1084  CE2 PHE B  19      -7.736  27.821  -1.581  1.00 59.71           C  
ATOM   1085  CZ  PHE B  19      -7.764  28.789  -0.571  1.00 58.52           C  
ATOM   1086  N   ALA B  20      -4.687  22.025   0.197  1.00 62.64           N  
ATOM   1087  CA  ALA B  20      -3.611  21.057   0.463  1.00 62.74           C  
ATOM   1088  C   ALA B  20      -3.147  20.257  -0.755  1.00 62.76           C  
ATOM   1089  O   ALA B  20      -2.059  19.709  -0.752  1.00 63.08           O  
ATOM   1090  CB  ALA B  20      -3.994  20.114   1.599  1.00 62.89           C  
ATOM   1091  N   GLY B  21      -3.948  20.189  -1.803  1.00 62.72           N  
ATOM   1092  CA  GLY B  21      -3.546  19.414  -2.973  1.00 63.12           C  
ATOM   1093  C   GLY B  21      -2.204  19.814  -3.551  1.00 63.09           C  
ATOM   1094  O   GLY B  21      -1.735  20.939  -3.326  1.00 63.82           O  
ATOM   1095  N   LYS B  22      -1.548  18.915  -4.283  0.50 62.61           N  
ATOM   1097  CA  LYS B  22      -0.345  19.332  -5.017  0.50 61.90           C  
ATOM   1099  C   LYS B  22      -0.700  20.132  -6.283  0.50 61.38           C  
ATOM   1101  O   LYS B  22       0.162  20.785  -6.879  0.50 61.26           O  
ATOM   1103  CB  LYS B  22       0.587  18.155  -5.329  0.50 62.03           C  
ATOM   1105  CG  LYS B  22       0.109  17.185  -6.399  0.50 62.10           C  
ATOM   1107  CD  LYS B  22       1.076  16.009  -6.576  0.50 61.82           C  
ATOM   1109  CE  LYS B  22       2.412  16.434  -7.192  0.50 61.34           C  
ATOM   1111  NZ  LYS B  22       3.443  15.352  -7.067  0.50 60.68           N  
ATOM   1113  N   TRP B  23      -1.974  20.100  -6.672  1.00 60.68           N  
ATOM   1114  CA  TRP B  23      -2.404  20.779  -7.896  1.00 59.50           C  
ATOM   1115  C   TRP B  23      -3.386  21.922  -7.706  1.00 58.38           C  
ATOM   1116  O   TRP B  23      -3.512  22.772  -8.587  1.00 58.47           O  
ATOM   1117  CB  TRP B  23      -3.003  19.762  -8.883  1.00 59.74           C  
ATOM   1118  CG  TRP B  23      -2.131  18.577  -9.158  1.00 59.62           C  
ATOM   1119  CD1 TRP B  23      -2.389  17.280  -8.812  1.00 60.13           C  
ATOM   1120  CD2 TRP B  23      -0.868  18.565  -9.850  1.00 59.71           C  
ATOM   1121  NE1 TRP B  23      -1.373  16.459  -9.253  1.00 60.17           N  
ATOM   1122  CE2 TRP B  23      -0.430  17.218  -9.895  1.00 60.07           C  
ATOM   1123  CE3 TRP B  23      -0.080  19.553 -10.455  1.00 59.73           C  
ATOM   1124  CZ2 TRP B  23       0.769  16.838 -10.506  1.00 59.64           C  
ATOM   1125  CZ3 TRP B  23       1.107  19.179 -11.057  1.00 59.74           C  
ATOM   1126  CH2 TRP B  23       1.525  17.831 -11.079  1.00 60.12           C  
ATOM   1127  N   THR B  24      -4.088  21.936  -6.576  1.00 57.28           N  
ATOM   1128  CA  THR B  24      -5.152  22.924  -6.320  1.00 56.64           C  
ATOM   1129  C   THR B  24      -4.768  24.383  -6.617  1.00 56.05           C  
ATOM   1130  O   THR B  24      -5.407  25.033  -7.434  1.00 55.44           O  
ATOM   1131  CB  THR B  24      -5.696  22.819  -4.872  1.00 56.57           C  
ATOM   1132  OG1 THR B  24      -6.070  21.461  -4.602  1.00 56.83           O  
ATOM   1133  CG2 THR B  24      -6.914  23.699  -4.695  1.00 55.28           C  
ATOM   1134  N   LEU B  25      -3.734  24.878  -5.937  1.00 55.29           N  
ATOM   1135  CA  LEU B  25      -3.326  26.272  -6.059  1.00 55.08           C  
ATOM   1136  C   LEU B  25      -2.716  26.599  -7.413  1.00 55.19           C  
ATOM   1137  O   LEU B  25      -2.856  27.726  -7.898  1.00 54.39           O  
ATOM   1138  CB  LEU B  25      -2.364  26.658  -4.925  1.00 54.56           C  
ATOM   1139  CG  LEU B  25      -3.051  26.739  -3.564  1.00 52.70           C  
ATOM   1140  CD1 LEU B  25      -2.031  26.833  -2.427  1.00 51.43           C  
ATOM   1141  CD2 LEU B  25      -4.035  27.925  -3.557  1.00 50.68           C  
ATOM   1142  N   LEU B  26      -2.035  25.615  -8.006  1.00 55.10           N  
ATOM   1143  CA  LEU B  26      -1.444  25.773  -9.343  1.00 55.53           C  
ATOM   1144  C   LEU B  26      -2.506  25.926 -10.432  1.00 55.30           C  
ATOM   1145  O   LEU B  26      -2.349  26.713 -11.364  1.00 55.48           O  
ATOM   1146  CB  LEU B  26      -0.548  24.570  -9.691  1.00 56.38           C  
ATOM   1147  CG  LEU B  26       0.946  24.671  -9.337  1.00 57.83           C  
ATOM   1148  CD1 LEU B  26       1.611  23.323  -9.551  1.00 57.63           C  
ATOM   1149  CD2 LEU B  26       1.660  25.770 -10.162  1.00 57.62           C  
ATOM   1150  N   ILE B  27      -3.572  25.148 -10.324  1.00 54.98           N  
ATOM   1151  CA  ILE B  27      -4.713  25.285 -11.218  1.00 55.32           C  
ATOM   1152  C   ILE B  27      -5.303  26.699 -11.131  1.00 55.28           C  
ATOM   1153  O   ILE B  27      -5.513  27.352 -12.162  1.00 55.28           O  
ATOM   1154  CB  ILE B  27      -5.769  24.166 -10.962  1.00 55.25           C  
ATOM   1155  CG1 ILE B  27      -5.223  22.836 -11.503  1.00 55.81           C  
ATOM   1156  CG2 ILE B  27      -7.088  24.522 -11.622  1.00 55.52           C  
ATOM   1157  CD1 ILE B  27      -5.826  21.569 -10.910  1.00 56.39           C  
ATOM   1158  N   ILE B  28      -5.526  27.170  -9.900  1.00 55.00           N  
ATOM   1159  CA  ILE B  28      -6.080  28.496  -9.662  1.00 54.31           C  
ATOM   1160  C   ILE B  28      -5.115  29.549 -10.220  1.00 54.55           C  
ATOM   1161  O   ILE B  28      -5.550  30.475 -10.906  1.00 53.91           O  
ATOM   1162  CB  ILE B  28      -6.435  28.732  -8.146  1.00 54.39           C  
ATOM   1163  CG1 ILE B  28      -7.564  27.775  -7.720  1.00 54.28           C  
ATOM   1164  CG2 ILE B  28      -6.861  30.175  -7.896  1.00 52.37           C  
ATOM   1165  CD1 ILE B  28      -7.873  27.756  -6.226  1.00 53.90           C  
ATOM   1166  N   PHE B  29      -3.815  29.366  -9.967  1.00 54.30           N  
ATOM   1167  CA  PHE B  29      -2.766  30.206 -10.566  1.00 54.11           C  
ATOM   1168  C   PHE B  29      -2.889  30.294 -12.091  1.00 54.52           C  
ATOM   1169  O   PHE B  29      -2.869  31.388 -12.663  1.00 54.68           O  
ATOM   1170  CB  PHE B  29      -1.359  29.722 -10.150  1.00 53.14           C  
ATOM   1171  CG  PHE B  29      -0.217  30.530 -10.751  1.00 52.26           C  
ATOM   1172  CD1 PHE B  29      -0.128  31.916 -10.544  1.00 51.37           C  
ATOM   1173  CD2 PHE B  29       0.783  29.902 -11.489  1.00 49.54           C  
ATOM   1174  CE1 PHE B  29       0.925  32.666 -11.073  1.00 49.38           C  
ATOM   1175  CE2 PHE B  29       1.847  30.639 -12.027  1.00 50.00           C  
ATOM   1176  CZ  PHE B  29       1.917  32.023 -11.825  1.00 51.05           C  
ATOM   1177  N   GLN B  30      -3.048  29.145 -12.743  1.00 55.27           N  
ATOM   1178  CA  GLN B  30      -3.128  29.098 -14.204  1.00 55.55           C  
ATOM   1179  C   GLN B  30      -4.414  29.707 -14.782  1.00 56.17           C  
ATOM   1180  O   GLN B  30      -4.358  30.493 -15.734  1.00 55.59           O  
ATOM   1181  CB  GLN B  30      -2.846  27.683 -14.748  1.00 55.52           C  
ATOM   1182  CG  GLN B  30      -1.354  27.343 -14.770  1.00 54.92           C  
ATOM   1183  CD  GLN B  30      -0.533  28.330 -15.610  1.00 56.18           C  
ATOM   1184  OE1 GLN B  30      -1.046  28.956 -16.548  1.00 57.08           O  
ATOM   1185  NE2 GLN B  30       0.736  28.475 -15.271  1.00 55.14           N  
ATOM   1186  N   ILE B  31      -5.559  29.365 -14.199  1.00 56.77           N  
ATOM   1187  CA  ILE B  31      -6.804  30.034 -14.583  1.00 57.90           C  
ATOM   1188  C   ILE B  31      -6.661  31.560 -14.431  1.00 58.49           C  
ATOM   1189  O   ILE B  31      -6.852  32.299 -15.404  1.00 58.59           O  
ATOM   1190  CB  ILE B  31      -8.031  29.508 -13.804  1.00 57.65           C  
ATOM   1191  CG1 ILE B  31      -8.250  28.009 -14.082  1.00 58.10           C  
ATOM   1192  CG2 ILE B  31      -9.278  30.297 -14.195  1.00 57.63           C  
ATOM   1193  CD1 ILE B  31      -9.181  27.320 -13.056  1.00 58.02           C  
ATOM   1194  N   ASN B  32      -6.300  32.018 -13.228  1.00 59.07           N  
ATOM   1195  CA  ASN B  32      -6.068  33.435 -12.964  1.00 60.36           C  
ATOM   1196  C   ASN B  32      -7.327  34.260 -13.306  1.00 60.93           C  
ATOM   1197  O   ASN B  32      -8.438  33.904 -12.911  1.00 60.02           O  
ATOM   1198  CB  ASN B  32      -4.821  33.930 -13.729  1.00 60.58           C  
ATOM   1199  CG  ASN B  32      -3.906  34.816 -12.876  1.00 62.86           C  
ATOM   1200  OD1 ASN B  32      -2.916  34.339 -12.282  1.00 64.93           O  
ATOM   1201  ND2 ASN B  32      -4.221  36.108 -12.820  1.00 61.29           N  
ATOM   1202  N   ARG B  33      -7.144  35.334 -14.067  1.00 62.46           N  
ATOM   1203  CA  ARG B  33      -8.205  36.297 -14.341  1.00 63.83           C  
ATOM   1204  C   ARG B  33      -8.705  36.208 -15.767  1.00 64.13           C  
ATOM   1205  O   ARG B  33      -9.170  37.195 -16.337  1.00 64.84           O  
ATOM   1206  CB  ARG B  33      -7.710  37.708 -14.063  1.00 64.29           C  
ATOM   1207  CG  ARG B  33      -7.431  37.956 -12.612  1.00 66.84           C  
ATOM   1208  CD  ARG B  33      -6.846  39.334 -12.408  1.00 70.81           C  
ATOM   1209  NE  ARG B  33      -6.080  39.348 -11.173  1.00 74.52           N  
ATOM   1210  CZ  ARG B  33      -6.597  39.592  -9.976  1.00 75.61           C  
ATOM   1211  NH1 ARG B  33      -7.896  39.865  -9.857  1.00 75.39           N  
ATOM   1212  NH2 ARG B  33      -5.811  39.560  -8.905  1.00 75.74           N  
ATOM   1213  N   ARG B  34      -8.604  35.020 -16.339  1.00 64.15           N  
ATOM   1214  CA  ARG B  34      -9.013  34.808 -17.707  1.00 64.06           C  
ATOM   1215  C   ARG B  34      -9.850  33.546 -17.849  1.00 63.90           C  
ATOM   1216  O   ARG B  34     -10.117  32.846 -16.874  1.00 63.33           O  
ATOM   1217  CB  ARG B  34      -7.797  34.808 -18.654  1.00 64.18           C  
ATOM   1218  CG  ARG B  34      -6.602  33.979 -18.230  1.00 63.48           C  
ATOM   1219  CD  ARG B  34      -6.754  32.513 -18.568  1.00 63.83           C  
ATOM   1220  NE  ARG B  34      -5.612  31.753 -18.057  1.00 64.95           N  
ATOM   1221  CZ  ARG B  34      -4.534  31.432 -18.775  1.00 65.84           C  
ATOM   1222  NH1 ARG B  34      -4.442  31.785 -20.051  1.00 65.39           N  
ATOM   1223  NH2 ARG B  34      -3.542  30.748 -18.217  1.00 66.52           N  
ATOM   1224  N   ILE B  35     -10.289  33.300 -19.075  1.00 64.39           N  
ATOM   1225  CA  ILE B  35     -11.040  32.112 -19.431  1.00 64.60           C  
ATOM   1226  C   ILE B  35     -10.065  31.161 -20.096  1.00 64.61           C  
ATOM   1227  O   ILE B  35      -9.344  31.534 -21.035  1.00 64.70           O  
ATOM   1228  CB  ILE B  35     -12.170  32.436 -20.436  1.00 65.04           C  
ATOM   1229  CG1 ILE B  35     -12.918  33.730 -20.051  1.00 65.03           C  
ATOM   1230  CG2 ILE B  35     -13.088  31.227 -20.639  1.00 64.39           C  
ATOM   1231  CD1 ILE B  35     -13.862  33.621 -18.862  1.00 65.38           C  
ATOM   1232  N   ILE B  36     -10.047  29.927 -19.613  1.00 64.71           N  
ATOM   1233  CA  ILE B  36      -9.130  28.934 -20.140  1.00 64.49           C  
ATOM   1234  C   ILE B  36      -9.857  27.634 -20.454  1.00 64.62           C  
ATOM   1235  O   ILE B  36     -10.627  27.114 -19.628  1.00 64.65           O  
ATOM   1236  CB  ILE B  36      -7.904  28.725 -19.195  1.00 64.37           C  
ATOM   1237  CG1 ILE B  36      -6.834  27.841 -19.857  1.00 64.62           C  
ATOM   1238  CG2 ILE B  36      -8.342  28.194 -17.818  1.00 63.53           C  
ATOM   1239  CD1 ILE B  36      -5.449  27.936 -19.201  1.00 64.79           C  
ATOM   1240  N   ARG B  37      -9.633  27.138 -21.672  0.50 64.45           N  
ATOM   1242  CA  ARG B  37     -10.108  25.825 -22.098  0.50 64.17           C  
ATOM   1244  C   ARG B  37      -9.390  24.738 -21.316  0.50 64.25           C  
ATOM   1246  O   ARG B  37      -8.221  24.898 -20.971  0.50 64.38           O  
ATOM   1248  CB  ARG B  37      -9.848  25.616 -23.592  0.50 63.81           C  
ATOM   1250  CG  ARG B  37     -11.078  25.739 -24.486  0.50 63.06           C  
ATOM   1252  CD  ARG B  37     -11.018  24.746 -25.654  0.50 60.49           C  
ATOM   1254  NE  ARG B  37     -11.003  23.353 -25.189  0.50 58.31           N  
ATOM   1256  CZ  ARG B  37      -9.935  22.564 -25.186  0.50 56.11           C  
ATOM   1258  NH1 ARG B  37      -8.770  23.003 -25.645  0.50 55.81           N  
ATOM   1260  NH2 ARG B  37     -10.035  21.327 -24.725  0.50 54.79           N  
ATOM   1262  N   TYR B  38     -10.090  23.641 -21.044  1.00 64.39           N  
ATOM   1263  CA  TYR B  38      -9.499  22.463 -20.398  1.00 64.83           C  
ATOM   1264  C   TYR B  38      -8.124  22.080 -20.960  1.00 64.93           C  
ATOM   1265  O   TYR B  38      -7.184  21.853 -20.207  1.00 65.00           O  
ATOM   1266  CB  TYR B  38     -10.436  21.255 -20.549  1.00 65.43           C  
ATOM   1267  CG  TYR B  38      -9.826  19.971 -20.059  1.00 65.03           C  
ATOM   1268  CD1 TYR B  38      -9.972  19.577 -18.732  1.00 65.51           C  
ATOM   1269  CD2 TYR B  38      -9.075  19.162 -20.910  1.00 65.31           C  
ATOM   1270  CE1 TYR B  38      -9.398  18.404 -18.265  1.00 65.47           C  
ATOM   1271  CE2 TYR B  38      -8.494  17.990 -20.455  1.00 64.91           C  
ATOM   1272  CZ  TYR B  38      -8.663  17.620 -19.131  1.00 65.23           C  
ATOM   1273  OH  TYR B  38      -8.098  16.463 -18.663  1.00 66.47           O  
ATOM   1274  N   GLY B  39      -8.032  21.988 -22.287  1.00 65.22           N  
ATOM   1275  CA  GLY B  39      -6.811  21.554 -22.965  1.00 65.02           C  
ATOM   1276  C   GLY B  39      -5.645  22.503 -22.769  1.00 65.05           C  
ATOM   1277  O   GLY B  39      -4.514  22.061 -22.600  1.00 64.72           O  
ATOM   1278  N   GLU B  40      -5.922  23.809 -22.815  1.00 65.26           N  
ATOM   1279  CA  GLU B  40      -4.912  24.829 -22.530  1.00 65.99           C  
ATOM   1280  C   GLU B  40      -4.430  24.713 -21.079  1.00 65.62           C  
ATOM   1281  O   GLU B  40      -3.228  24.821 -20.811  1.00 65.42           O  
ATOM   1282  CB  GLU B  40      -5.469  26.233 -22.780  1.00 65.88           C  
ATOM   1283  CG  GLU B  40      -5.447  26.694 -24.224  1.00 67.21           C  
ATOM   1284  CD  GLU B  40      -6.206  28.006 -24.444  1.00 67.61           C  
ATOM   1285  OE1 GLU B  40      -6.784  28.569 -23.476  1.00 69.25           O  
ATOM   1286  OE2 GLU B  40      -6.234  28.472 -25.607  1.00 70.16           O  
ATOM   1287  N   LEU B  41      -5.376  24.473 -20.166  1.00 65.66           N  
ATOM   1288  CA  LEU B  41      -5.101  24.351 -18.729  1.00 65.77           C  
ATOM   1289  C   LEU B  41      -4.168  23.169 -18.493  1.00 65.91           C  
ATOM   1290  O   LEU B  41      -3.145  23.305 -17.826  1.00 65.50           O  
ATOM   1291  CB  LEU B  41      -6.406  24.173 -17.936  1.00 65.44           C  
ATOM   1292  CG  LEU B  41      -6.612  24.788 -16.535  1.00 66.44           C  
ATOM   1293  CD1 LEU B  41      -7.650  23.982 -15.744  1.00 64.93           C  
ATOM   1294  CD2 LEU B  41      -5.327  24.957 -15.716  1.00 64.66           C  
ATOM   1295  N   LYS B  42      -4.503  22.020 -19.079  1.00 66.38           N  
ATOM   1296  CA  LYS B  42      -3.659  20.827 -18.964  1.00 66.68           C  
ATOM   1297  C   LYS B  42      -2.247  21.058 -19.499  1.00 66.77           C  
ATOM   1298  O   LYS B  42      -1.270  20.607 -18.892  1.00 67.13           O  
ATOM   1299  CB  LYS B  42      -4.294  19.619 -19.658  1.00 66.67           C  
ATOM   1300  CG  LYS B  42      -3.718  18.310 -19.157  1.00 67.08           C  
ATOM   1301  CD  LYS B  42      -4.169  17.136 -19.977  1.00 68.04           C  
ATOM   1302  CE  LYS B  42      -3.137  16.029 -19.906  1.00 68.42           C  
ATOM   1303  NZ  LYS B  42      -3.307  15.088 -21.039  1.00 71.10           N  
ATOM   1304  N   ARG B  43      -2.144  21.764 -20.625  1.00 66.66           N  
ATOM   1305  CA  ARG B  43      -0.838  22.116 -21.190  1.00 66.72           C  
ATOM   1306  C   ARG B  43      -0.100  23.196 -20.392  1.00 66.25           C  
ATOM   1307  O   ARG B  43       1.126  23.287 -20.468  1.00 66.02           O  
ATOM   1308  CB  ARG B  43      -0.962  22.508 -22.663  1.00 66.61           C  
ATOM   1309  CG  ARG B  43      -0.928  21.307 -23.614  1.00 67.63           C  
ATOM   1310  CD  ARG B  43      -0.965  21.732 -25.071  1.00 67.76           C  
ATOM   1311  NE  ARG B  43      -2.122  22.578 -25.364  1.00 70.65           N  
ATOM   1312  CZ  ARG B  43      -3.298  22.141 -25.814  1.00 71.09           C  
ATOM   1313  NH1 ARG B  43      -3.505  20.847 -26.034  1.00 70.64           N  
ATOM   1314  NH2 ARG B  43      -4.279  23.011 -26.037  1.00 71.20           N  
ATOM   1315  N   ALA B  44      -0.843  23.996 -19.620  1.00 66.03           N  
ATOM   1316  CA  ALA B  44      -0.255  25.008 -18.738  1.00 65.54           C  
ATOM   1317  C   ALA B  44       0.368  24.408 -17.462  1.00 65.62           C  
ATOM   1318  O   ALA B  44       1.126  25.083 -16.756  1.00 65.73           O  
ATOM   1319  CB  ALA B  44      -1.281  26.080 -18.400  1.00 65.51           C  
ATOM   1320  N   ILE B  45       0.052  23.143 -17.176  1.00 65.47           N  
ATOM   1321  CA  ILE B  45       0.633  22.402 -16.046  1.00 65.28           C  
ATOM   1322  C   ILE B  45       1.137  21.022 -16.520  1.00 65.65           C  
ATOM   1323  O   ILE B  45       0.500  19.995 -16.245  1.00 65.88           O  
ATOM   1324  CB  ILE B  45      -0.378  22.239 -14.864  1.00 65.27           C  
ATOM   1325  CG1 ILE B  45      -1.132  23.559 -14.601  1.00 65.04           C  
ATOM   1326  CG2 ILE B  45       0.344  21.774 -13.599  1.00 65.42           C  
ATOM   1327  CD1 ILE B  45      -2.339  23.455 -13.696  1.00 64.76           C  
ATOM   1328  N   PRO B  46       2.278  20.988 -17.238  1.00 65.56           N  
ATOM   1329  CA  PRO B  46       2.745  19.706 -17.778  1.00 65.96           C  
ATOM   1330  C   PRO B  46       3.198  18.745 -16.681  1.00 65.97           C  
ATOM   1331  O   PRO B  46       3.941  19.134 -15.770  1.00 66.20           O  
ATOM   1332  CB  PRO B  46       3.917  20.109 -18.683  1.00 65.87           C  
ATOM   1333  CG  PRO B  46       4.393  21.402 -18.105  1.00 66.15           C  
ATOM   1334  CD  PRO B  46       3.180  22.098 -17.592  1.00 65.57           C  
ATOM   1335  N   GLY B  47       2.729  17.504 -16.770  1.00 65.81           N  
ATOM   1336  CA  GLY B  47       3.057  16.474 -15.790  1.00 65.71           C  
ATOM   1337  C   GLY B  47       1.851  16.029 -14.985  1.00 65.58           C  
ATOM   1338  O   GLY B  47       1.853  14.939 -14.413  1.00 65.62           O  
ATOM   1339  N   ILE B  48       0.830  16.884 -14.914  1.00 65.37           N  
ATOM   1340  CA  ILE B  48      -0.440  16.509 -14.286  1.00 65.03           C  
ATOM   1341  C   ILE B  48      -1.200  15.528 -15.193  1.00 64.99           C  
ATOM   1342  O   ILE B  48      -1.430  15.811 -16.371  1.00 64.96           O  
ATOM   1343  CB  ILE B  48      -1.313  17.746 -13.918  1.00 64.57           C  
ATOM   1344  CG1 ILE B  48      -2.432  17.341 -12.959  1.00 64.92           C  
ATOM   1345  CG2 ILE B  48      -1.885  18.444 -15.164  1.00 64.29           C  
ATOM   1346  CD1 ILE B  48      -3.231  18.522 -12.382  1.00 64.93           C  
ATOM   1347  N   SER B  49      -1.576  14.377 -14.641  1.00 65.03           N  
ATOM   1348  CA  SER B  49      -2.341  13.381 -15.397  1.00 65.36           C  
ATOM   1349  C   SER B  49      -3.770  13.851 -15.640  1.00 65.40           C  
ATOM   1350  O   SER B  49      -4.252  14.772 -14.968  1.00 65.07           O  
ATOM   1351  CB  SER B  49      -2.349  12.026 -14.673  1.00 65.39           C  
ATOM   1352  OG  SER B  49      -3.269  12.024 -13.592  1.00 65.44           O  
ATOM   1353  N   GLU B  50      -4.440  13.212 -16.596  0.50 65.59           N  
ATOM   1355  CA  GLU B  50      -5.832  13.508 -16.919  0.50 65.90           C  
ATOM   1357  C   GLU B  50      -6.730  13.328 -15.693  0.50 65.78           C  
ATOM   1359  O   GLU B  50      -7.544  14.201 -15.384  0.50 65.75           O  
ATOM   1361  CB  GLU B  50      -6.313  12.624 -18.076  0.50 66.10           C  
ATOM   1363  CG  GLU B  50      -7.495  13.196 -18.862  0.50 67.36           C  
ATOM   1365  CD  GLU B  50      -7.081  14.159 -19.973  0.50 68.46           C  
ATOM   1367  OE1 GLU B  50      -7.977  14.766 -20.594  0.50 68.56           O  
ATOM   1369  OE2 GLU B  50      -5.870  14.315 -20.234  0.50 69.05           O  
ATOM   1371  N   LYS B  51      -6.561  12.208 -14.988  1.00 65.74           N  
ATOM   1372  CA  LYS B  51      -7.330  11.931 -13.771  1.00 66.08           C  
ATOM   1373  C   LYS B  51      -7.109  12.969 -12.665  1.00 65.90           C  
ATOM   1374  O   LYS B  51      -8.077  13.456 -12.069  1.00 65.60           O  
ATOM   1375  CB  LYS B  51      -7.061  10.526 -13.237  1.00 66.36           C  
ATOM   1376  CG  LYS B  51      -8.271   9.941 -12.526  1.00 67.77           C  
ATOM   1377  CD  LYS B  51      -7.923   9.401 -11.144  1.00 69.33           C  
ATOM   1378  CE  LYS B  51      -9.149   8.748 -10.512  1.00 70.15           C  
ATOM   1379  NZ  LYS B  51      -9.040   8.667  -9.029  1.00 70.94           N  
HETATM 1380  N   MSE B  52      -5.843  13.296 -12.404  0.50 65.62           N  
HETATM 1382  CA  MSE B  52      -5.486  14.346 -11.445  0.50 65.55           C  
HETATM 1384  C   MSE B  52      -6.265  15.622 -11.749  0.50 65.46           C  
HETATM 1386  O   MSE B  52      -6.958  16.149 -10.881  0.50 65.37           O  
HETATM 1388  CB  MSE B  52      -3.979  14.630 -11.470  0.50 65.49           C  
HETATM 1390  CG  MSE B  52      -3.103  13.544 -10.859  0.50 65.48           C  
HETATM 1392 SE   MSE B  52      -1.225  13.739 -11.376  0.34 65.44          SE  
HETATM 1394  CE  MSE B  52      -0.583  11.959 -10.865  0.50 65.24           C  
ATOM   1396  N   LEU B  53      -6.184  16.074 -13.000  1.00 65.66           N  
ATOM   1397  CA  LEU B  53      -6.824  17.325 -13.443  1.00 65.43           C  
ATOM   1398  C   LEU B  53      -8.338  17.390 -13.215  1.00 65.36           C  
ATOM   1399  O   LEU B  53      -8.831  18.380 -12.678  1.00 65.29           O  
ATOM   1400  CB  LEU B  53      -6.514  17.643 -14.914  1.00 65.16           C  
ATOM   1401  CG  LEU B  53      -6.146  19.081 -15.345  1.00 65.78           C  
ATOM   1402  CD1 LEU B  53      -6.712  19.425 -16.714  1.00 64.34           C  
ATOM   1403  CD2 LEU B  53      -6.522  20.200 -14.336  1.00 65.41           C  
ATOM   1404  N   ILE B  54      -9.069  16.346 -13.605  1.00 65.64           N  
ATOM   1405  CA  ILE B  54     -10.541  16.412 -13.568  1.00 65.60           C  
ATOM   1406  C   ILE B  54     -11.155  16.171 -12.186  1.00 65.17           C  
ATOM   1407  O   ILE B  54     -12.250  16.661 -11.902  1.00 65.14           O  
ATOM   1408  CB  ILE B  54     -11.245  15.531 -14.654  1.00 65.71           C  
ATOM   1409  CG1 ILE B  54     -11.715  14.170 -14.108  1.00 66.18           C  
ATOM   1410  CG2 ILE B  54     -10.408  15.417 -15.924  1.00 66.76           C  
ATOM   1411  CD1 ILE B  54     -10.628  13.161 -13.821  1.00 67.58           C  
ATOM   1412  N   ASP B  55     -10.465  15.404 -11.344  1.00 64.83           N  
ATOM   1413  CA  ASP B  55     -10.879  15.256  -9.952  1.00 64.49           C  
ATOM   1414  C   ASP B  55     -10.670  16.598  -9.244  1.00 63.89           C  
ATOM   1415  O   ASP B  55     -11.521  17.050  -8.476  1.00 63.53           O  
ATOM   1416  CB  ASP B  55     -10.097  14.140  -9.255  1.00 64.44           C  
ATOM   1417  CG  ASP B  55     -10.396  12.760  -9.827  1.00 65.92           C  
ATOM   1418  OD1 ASP B  55      -9.579  11.849  -9.569  1.00 67.13           O  
ATOM   1419  OD2 ASP B  55     -11.430  12.568 -10.521  1.00 65.57           O  
ATOM   1420  N   GLU B  56      -9.547  17.240  -9.544  1.00 63.58           N  
ATOM   1421  CA  GLU B  56      -9.227  18.558  -8.989  1.00 63.43           C  
ATOM   1422  C   GLU B  56     -10.169  19.642  -9.531  1.00 62.75           C  
ATOM   1423  O   GLU B  56     -10.687  20.453  -8.772  1.00 62.39           O  
ATOM   1424  CB  GLU B  56      -7.757  18.897  -9.244  1.00 63.46           C  
ATOM   1425  CG  GLU B  56      -7.206  20.003  -8.368  1.00 65.34           C  
ATOM   1426  CD  GLU B  56      -7.039  19.591  -6.924  1.00 66.59           C  
ATOM   1427  OE1 GLU B  56      -6.275  18.635  -6.652  1.00 66.83           O  
ATOM   1428  OE2 GLU B  56      -7.667  20.240  -6.062  1.00 67.48           O  
ATOM   1429  N   LEU B  57     -10.418  19.632 -10.838  1.00 62.72           N  
ATOM   1430  CA  LEU B  57     -11.424  20.520 -11.434  1.00 62.55           C  
ATOM   1431  C   LEU B  57     -12.814  20.326 -10.817  1.00 62.51           C  
ATOM   1432  O   LEU B  57     -13.515  21.305 -10.571  1.00 62.74           O  
ATOM   1433  CB  LEU B  57     -11.478  20.373 -12.962  1.00 62.22           C  
ATOM   1434  CG  LEU B  57     -10.314  20.987 -13.761  1.00 62.11           C  
ATOM   1435  CD1 LEU B  57     -10.360  20.566 -15.237  1.00 60.83           C  
ATOM   1436  CD2 LEU B  57     -10.223  22.518 -13.622  1.00 59.44           C  
ATOM   1437  N   LYS B  58     -13.194  19.076 -10.549  1.00 62.46           N  
ATOM   1438  CA  LYS B  58     -14.473  18.776  -9.891  1.00 62.80           C  
ATOM   1439  C   LYS B  58     -14.503  19.302  -8.459  1.00 62.41           C  
ATOM   1440  O   LYS B  58     -15.459  19.957  -8.047  1.00 62.41           O  
ATOM   1441  CB  LYS B  58     -14.775  17.272  -9.885  1.00 62.63           C  
ATOM   1442  CG  LYS B  58     -16.141  16.954  -9.275  1.00 63.59           C  
ATOM   1443  CD  LYS B  58     -16.294  15.514  -8.767  1.00 63.95           C  
ATOM   1444  CE  LYS B  58     -15.576  15.239  -7.423  1.00 66.62           C  
ATOM   1445  NZ  LYS B  58     -15.172  16.428  -6.568  1.00 66.20           N  
ATOM   1446  N   PHE B  59     -13.450  18.998  -7.708  1.00 62.40           N  
ATOM   1447  CA  PHE B  59     -13.277  19.490  -6.339  1.00 62.23           C  
ATOM   1448  C   PHE B  59     -13.468  21.013  -6.264  1.00 61.95           C  
ATOM   1449  O   PHE B  59     -14.301  21.498  -5.500  1.00 61.83           O  
ATOM   1450  CB  PHE B  59     -11.906  19.043  -5.815  1.00 62.07           C  
ATOM   1451  CG  PHE B  59     -11.578  19.532  -4.434  1.00 62.38           C  
ATOM   1452  CD1 PHE B  59     -12.133  18.916  -3.309  1.00 62.07           C  
ATOM   1453  CD2 PHE B  59     -10.675  20.585  -4.253  1.00 61.94           C  
ATOM   1454  CE1 PHE B  59     -11.810  19.360  -2.022  1.00 61.22           C  
ATOM   1455  CE2 PHE B  59     -10.351  21.036  -2.975  1.00 60.55           C  
ATOM   1456  CZ  PHE B  59     -10.919  20.420  -1.858  1.00 61.05           C  
ATOM   1457  N   LEU B  60     -12.726  21.747  -7.092  1.00 62.19           N  
ATOM   1458  CA  LEU B  60     -12.771  23.216  -7.104  1.00 62.49           C  
ATOM   1459  C   LEU B  60     -14.124  23.809  -7.509  1.00 62.75           C  
ATOM   1460  O   LEU B  60     -14.518  24.865  -7.000  1.00 62.20           O  
ATOM   1461  CB  LEU B  60     -11.668  23.780  -7.998  1.00 62.41           C  
ATOM   1462  CG  LEU B  60     -10.203  23.566  -7.596  1.00 62.64           C  
ATOM   1463  CD1 LEU B  60      -9.317  23.926  -8.767  1.00 61.74           C  
ATOM   1464  CD2 LEU B  60      -9.842  24.385  -6.346  1.00 62.33           C  
ATOM   1465  N   CYS B  61     -14.821  23.151  -8.440  1.00 63.54           N  
ATOM   1466  CA  CYS B  61     -16.202  23.528  -8.782  1.00 63.96           C  
ATOM   1467  C   CYS B  61     -17.121  23.331  -7.573  1.00 63.90           C  
ATOM   1468  O   CYS B  61     -17.943  24.196  -7.263  1.00 63.87           O  
ATOM   1469  CB  CYS B  61     -16.722  22.710  -9.968  1.00 64.34           C  
ATOM   1470  SG  CYS B  61     -16.174  23.293 -11.587  1.00 66.66           S  
ATOM   1471  N   GLY B  62     -16.958  22.194  -6.894  1.00 63.94           N  
ATOM   1472  CA  GLY B  62     -17.739  21.853  -5.704  1.00 64.01           C  
ATOM   1473  C   GLY B  62     -17.529  22.805  -4.540  1.00 64.29           C  
ATOM   1474  O   GLY B  62     -18.436  23.004  -3.732  1.00 64.41           O  
ATOM   1475  N   LYS B  63     -16.333  23.393  -4.461  1.00 64.17           N  
ATOM   1476  CA  LYS B  63     -16.008  24.390  -3.433  1.00 64.37           C  
ATOM   1477  C   LYS B  63     -16.389  25.819  -3.849  1.00 64.52           C  
ATOM   1478  O   LYS B  63     -16.259  26.763  -3.062  1.00 64.77           O  
ATOM   1479  CB  LYS B  63     -14.513  24.324  -3.066  1.00 64.30           C  
ATOM   1480  CG  LYS B  63     -14.060  22.993  -2.463  1.00 63.73           C  
ATOM   1481  CD  LYS B  63     -14.612  22.804  -1.070  1.00 63.65           C  
ATOM   1482  CE  LYS B  63     -14.267  21.439  -0.540  1.00 65.26           C  
ATOM   1483  NZ  LYS B  63     -14.259  21.431   0.950  1.00 66.87           N  
ATOM   1484  N   GLY B  64     -16.860  25.970  -5.082  1.00 64.53           N  
ATOM   1485  CA  GLY B  64     -17.338  27.257  -5.578  1.00 64.51           C  
ATOM   1486  C   GLY B  64     -16.203  28.214  -5.875  1.00 64.28           C  
ATOM   1487  O   GLY B  64     -16.375  29.436  -5.821  1.00 63.95           O  
ATOM   1488  N   LEU B  65     -15.046  27.648  -6.210  1.00 64.28           N  
ATOM   1489  CA  LEU B  65     -13.836  28.436  -6.448  1.00 64.29           C  
ATOM   1490  C   LEU B  65     -13.625  28.731  -7.933  1.00 64.83           C  
ATOM   1491  O   LEU B  65     -13.055  29.760  -8.297  1.00 64.84           O  
ATOM   1492  CB  LEU B  65     -12.615  27.718  -5.859  1.00 64.08           C  
ATOM   1493  CG  LEU B  65     -12.497  27.710  -4.325  1.00 63.14           C  
ATOM   1494  CD1 LEU B  65     -11.200  27.036  -3.889  1.00 63.18           C  
ATOM   1495  CD2 LEU B  65     -12.576  29.108  -3.772  1.00 59.90           C  
ATOM   1496  N   ILE B  66     -14.082  27.817  -8.779  1.00 64.88           N  
ATOM   1497  CA  ILE B  66     -14.018  27.991 -10.224  1.00 65.72           C  
ATOM   1498  C   ILE B  66     -15.423  27.749 -10.809  1.00 66.65           C  
ATOM   1499  O   ILE B  66     -16.240  27.052 -10.197  1.00 66.15           O  
ATOM   1500  CB  ILE B  66     -12.954  27.050 -10.891  1.00 65.61           C  
ATOM   1501  CG1 ILE B  66     -13.484  25.615 -11.032  1.00 64.84           C  
ATOM   1502  CG2 ILE B  66     -11.614  27.073 -10.115  1.00 64.87           C  
ATOM   1503  CD1 ILE B  66     -12.496  24.631 -11.598  1.00 65.14           C  
ATOM   1504  N   LYS B  67     -15.710  28.343 -11.964  1.00 68.16           N  
ATOM   1505  CA  LYS B  67     -16.960  28.031 -12.682  1.00 70.05           C  
ATOM   1506  C   LYS B  67     -16.722  27.374 -14.045  1.00 70.41           C  
ATOM   1507  O   LYS B  67     -15.715  27.635 -14.703  1.00 70.98           O  
ATOM   1508  CB  LYS B  67     -17.911  29.240 -12.769  1.00 70.09           C  
ATOM   1509  CG  LYS B  67     -17.304  30.547 -13.287  1.00 71.20           C  
ATOM   1510  CD  LYS B  67     -18.368  31.656 -13.383  1.00 71.39           C  
ATOM   1511  CE  LYS B  67     -18.246  32.692 -12.264  1.00 74.29           C  
ATOM   1512  NZ  LYS B  67     -17.223  33.718 -12.611  1.00 75.64           N  
ATOM   1513  N   LYS B  68     -17.654  26.515 -14.446  1.00 70.99           N  
ATOM   1514  CA  LYS B  68     -17.534  25.704 -15.663  1.00 71.59           C  
ATOM   1515  C   LYS B  68     -18.566  26.108 -16.718  1.00 71.77           C  
ATOM   1516  O   LYS B  68     -19.765  26.086 -16.442  1.00 71.68           O  
ATOM   1517  CB  LYS B  68     -17.704  24.224 -15.298  1.00 71.47           C  
ATOM   1518  CG  LYS B  68     -17.663  23.243 -16.452  1.00 71.52           C  
ATOM   1519  CD  LYS B  68     -17.833  21.810 -15.956  1.00 71.64           C  
ATOM   1520  CE  LYS B  68     -19.240  21.550 -15.432  1.00 72.47           C  
ATOM   1521  NZ  LYS B  68     -19.488  20.111 -15.125  1.00 72.74           N  
ATOM   1522  N   LYS B  69     -18.089  26.489 -17.906  1.00 72.35           N  
ATOM   1523  CA  LYS B  69     -18.960  26.791 -19.059  1.00 73.31           C  
ATOM   1524  C   LYS B  69     -18.948  25.630 -20.046  1.00 73.13           C  
ATOM   1525  O   LYS B  69     -17.905  25.272 -20.583  1.00 72.99           O  
ATOM   1526  CB  LYS B  69     -18.529  28.065 -19.798  1.00 73.29           C  
ATOM   1527  CG  LYS B  69     -18.600  29.345 -18.991  1.00 75.60           C  
ATOM   1528  CD  LYS B  69     -17.424  30.249 -19.330  1.00 76.46           C  
ATOM   1529  CE  LYS B  69     -16.763  30.723 -18.063  1.00 76.73           C  
ATOM   1530  NZ  LYS B  69     -15.322  30.342 -18.041  1.00 76.13           N  
ATOM   1531  N   GLN B  70     -20.125  25.065 -20.284  1.00 73.78           N  
ATOM   1532  CA  GLN B  70     -20.317  23.973 -21.243  1.00 74.29           C  
ATOM   1533  C   GLN B  70     -20.613  24.524 -22.644  1.00 74.25           C  
ATOM   1534  O   GLN B  70     -21.423  25.440 -22.796  1.00 74.05           O  
ATOM   1535  CB  GLN B  70     -21.494  23.110 -20.786  1.00 74.39           C  
ATOM   1536  CG  GLN B  70     -21.288  21.621 -20.899  1.00 75.87           C  
ATOM   1537  CD  GLN B  70     -20.470  21.048 -19.758  1.00 77.19           C  
ATOM   1538  OE1 GLN B  70     -19.489  20.340 -19.982  1.00 78.55           O  
ATOM   1539  NE2 GLN B  70     -20.876  21.339 -18.529  1.00 76.98           N  
ATOM   1540  N   TYR B  71     -19.942  23.973 -23.654  1.00 74.63           N  
ATOM   1541  CA  TYR B  71     -20.270  24.237 -25.063  1.00 74.87           C  
ATOM   1542  C   TYR B  71     -20.513  22.904 -25.797  1.00 74.81           C  
ATOM   1543  O   TYR B  71     -19.562  22.242 -26.231  1.00 74.34           O  
ATOM   1544  CB  TYR B  71     -19.165  25.048 -25.761  1.00 75.10           C  
ATOM   1545  CG  TYR B  71     -18.965  26.456 -25.232  1.00 75.49           C  
ATOM   1546  CD1 TYR B  71     -18.050  26.716 -24.213  1.00 75.33           C  
ATOM   1547  CD2 TYR B  71     -19.674  27.530 -25.768  1.00 75.66           C  
ATOM   1548  CE1 TYR B  71     -17.858  28.012 -23.725  1.00 76.08           C  
ATOM   1549  CE2 TYR B  71     -19.489  28.828 -25.291  1.00 75.89           C  
ATOM   1550  CZ  TYR B  71     -18.580  29.062 -24.270  1.00 76.15           C  
ATOM   1551  OH  TYR B  71     -18.399  30.348 -23.794  1.00 75.66           O  
ATOM   1552  N   PRO B  72     -21.792  22.498 -25.913  1.00 74.97           N  
ATOM   1553  CA  PRO B  72     -22.170  21.240 -26.567  1.00 75.16           C  
ATOM   1554  C   PRO B  72     -22.274  21.366 -28.101  1.00 75.09           C  
ATOM   1555  O   PRO B  72     -23.277  20.967 -28.689  1.00 75.32           O  
ATOM   1556  CB  PRO B  72     -23.538  20.944 -25.948  1.00 75.18           C  
ATOM   1557  CG  PRO B  72     -24.133  22.305 -25.726  1.00 75.07           C  
ATOM   1558  CD  PRO B  72     -22.972  23.226 -25.401  1.00 75.10           C  
ATOM   1559  N   GLU B  73     -21.234  21.919 -28.724  1.00 75.03           N  
ATOM   1560  CA  GLU B  73     -21.204  22.170 -30.161  1.00 75.09           C  
ATOM   1561  C   GLU B  73     -20.187  21.252 -30.815  1.00 74.63           C  
ATOM   1562  O   GLU B  73     -19.665  20.343 -30.168  1.00 74.97           O  
ATOM   1563  CB  GLU B  73     -20.872  23.642 -30.455  1.00 75.14           C  
ATOM   1564  CG  GLU B  73     -19.461  24.073 -30.032  1.00 76.18           C  
ATOM   1565  CD  GLU B  73     -19.268  25.584 -29.994  1.00 76.17           C  
ATOM   1566  OE1 GLU B  73     -20.087  26.294 -29.359  1.00 76.64           O  
ATOM   1567  OE2 GLU B  73     -18.272  26.059 -30.586  1.00 78.16           O  
ATOM   1568  N   VAL B  74     -19.927  21.478 -32.101  1.00 73.87           N  
ATOM   1569  CA  VAL B  74     -18.939  20.708 -32.840  1.00 72.82           C  
ATOM   1570  C   VAL B  74     -17.754  21.606 -33.231  1.00 72.38           C  
ATOM   1571  O   VAL B  74     -17.951  22.635 -33.872  1.00 72.44           O  
ATOM   1572  CB  VAL B  74     -19.577  20.052 -34.097  1.00 72.82           C  
ATOM   1573  CG1 VAL B  74     -18.521  19.450 -34.994  1.00 72.70           C  
ATOM   1574  CG2 VAL B  74     -20.597  18.998 -33.692  1.00 72.24           C  
ATOM   1575  N   PRO B  75     -16.530  21.264 -32.784  1.00 71.94           N  
ATOM   1576  CA  PRO B  75     -16.233  20.319 -31.706  1.00 71.64           C  
ATOM   1577  C   PRO B  75     -16.540  20.939 -30.335  1.00 71.00           C  
ATOM   1578  O   PRO B  75     -16.521  22.165 -30.200  1.00 70.95           O  
ATOM   1579  CB  PRO B  75     -14.729  20.060 -31.863  1.00 71.79           C  
ATOM   1580  CG  PRO B  75     -14.199  21.264 -32.536  1.00 72.13           C  
ATOM   1581  CD  PRO B  75     -15.304  21.800 -33.404  1.00 71.95           C  
ATOM   1582  N   PRO B  76     -16.829  20.099 -29.323  1.00 70.46           N  
ATOM   1583  CA  PRO B  76     -17.273  20.623 -28.034  1.00 69.85           C  
ATOM   1584  C   PRO B  76     -16.104  21.069 -27.140  1.00 69.16           C  
ATOM   1585  O   PRO B  76     -14.957  20.660 -27.359  1.00 68.68           O  
ATOM   1586  CB  PRO B  76     -18.014  19.433 -27.419  1.00 69.64           C  
ATOM   1587  CG  PRO B  76     -17.287  18.239 -27.950  1.00 70.58           C  
ATOM   1588  CD  PRO B  76     -16.749  18.623 -29.318  1.00 70.59           C  
ATOM   1589  N   ARG B  77     -16.401  21.905 -26.149  1.00 68.45           N  
ATOM   1590  CA  ARG B  77     -15.363  22.407 -25.243  1.00 68.16           C  
ATOM   1591  C   ARG B  77     -15.893  22.797 -23.856  1.00 67.55           C  
ATOM   1592  O   ARG B  77     -17.057  23.201 -23.719  1.00 67.22           O  
ATOM   1593  CB  ARG B  77     -14.619  23.588 -25.888  1.00 68.40           C  
ATOM   1594  CG  ARG B  77     -15.433  24.868 -25.984  1.00 69.97           C  
ATOM   1595  CD  ARG B  77     -14.553  26.078 -26.237  1.00 72.62           C  
ATOM   1596  NE  ARG B  77     -14.517  26.407 -27.656  1.00 74.73           N  
ATOM   1597  CZ  ARG B  77     -15.329  27.290 -28.236  1.00 76.37           C  
ATOM   1598  NH1 ARG B  77     -16.235  27.948 -27.512  1.00 76.23           N  
ATOM   1599  NH2 ARG B  77     -15.235  27.520 -29.544  1.00 76.63           N  
ATOM   1600  N   VAL B  78     -15.037  22.646 -22.839  1.00 67.01           N  
ATOM   1601  CA  VAL B  78     -15.263  23.231 -21.512  1.00 66.65           C  
ATOM   1602  C   VAL B  78     -14.338  24.419 -21.274  1.00 66.08           C  
ATOM   1603  O   VAL B  78     -13.141  24.351 -21.556  1.00 66.18           O  
ATOM   1604  CB  VAL B  78     -15.048  22.240 -20.323  1.00 66.96           C  
ATOM   1605  CG1 VAL B  78     -16.377  21.708 -19.800  1.00 67.44           C  
ATOM   1606  CG2 VAL B  78     -14.053  21.120 -20.668  1.00 66.38           C  
ATOM   1607  N   GLU B  79     -14.905  25.501 -20.757  1.00 65.07           N  
ATOM   1608  CA  GLU B  79     -14.123  26.658 -20.349  1.00 64.31           C  
ATOM   1609  C   GLU B  79     -14.266  26.851 -18.852  1.00 63.59           C  
ATOM   1610  O   GLU B  79     -15.353  26.653 -18.300  1.00 63.08           O  
ATOM   1611  CB  GLU B  79     -14.564  27.913 -21.103  1.00 64.14           C  
ATOM   1612  CG  GLU B  79     -13.930  28.008 -22.475  1.00 65.16           C  
ATOM   1613  CD  GLU B  79     -14.435  29.157 -23.333  1.00 64.81           C  
ATOM   1614  OE1 GLU B  79     -15.199  30.020 -22.842  1.00 66.00           O  
ATOM   1615  OE2 GLU B  79     -14.045  29.188 -24.522  1.00 66.82           O  
ATOM   1616  N   TYR B  80     -13.152  27.209 -18.210  1.00 62.72           N  
ATOM   1617  CA  TYR B  80     -13.120  27.491 -16.780  1.00 61.99           C  
ATOM   1618  C   TYR B  80     -12.663  28.917 -16.490  1.00 61.36           C  
ATOM   1619  O   TYR B  80     -11.785  29.456 -17.166  1.00 61.15           O  
ATOM   1620  CB  TYR B  80     -12.207  26.495 -16.053  1.00 61.68           C  
ATOM   1621  CG  TYR B  80     -12.733  25.079 -16.043  1.00 61.37           C  
ATOM   1622  CD1 TYR B  80     -13.628  24.656 -15.060  1.00 60.86           C  
ATOM   1623  CD2 TYR B  80     -12.332  24.151 -17.018  1.00 60.27           C  
ATOM   1624  CE1 TYR B  80     -14.115  23.348 -15.046  1.00 61.15           C  
ATOM   1625  CE2 TYR B  80     -12.812  22.854 -17.013  1.00 60.26           C  
ATOM   1626  CZ  TYR B  80     -13.702  22.451 -16.022  1.00 61.10           C  
ATOM   1627  OH  TYR B  80     -14.188  21.147 -16.010  1.00 61.67           O  
ATOM   1628  N   SER B  81     -13.278  29.520 -15.480  1.00 60.95           N  
ATOM   1629  CA  SER B  81     -12.840  30.816 -14.953  1.00 60.38           C  
ATOM   1630  C   SER B  81     -12.998  30.821 -13.447  1.00 59.67           C  
ATOM   1631  O   SER B  81     -13.663  29.944 -12.888  1.00 59.14           O  
ATOM   1632  CB  SER B  81     -13.645  31.959 -15.563  1.00 60.48           C  
ATOM   1633  OG  SER B  81     -15.030  31.743 -15.379  1.00 61.86           O  
ATOM   1634  N   LEU B  82     -12.391  31.802 -12.790  1.00 59.00           N  
ATOM   1635  CA  LEU B  82     -12.522  31.905 -11.347  1.00 59.20           C  
ATOM   1636  C   LEU B  82     -13.826  32.600 -10.990  1.00 59.37           C  
ATOM   1637  O   LEU B  82     -14.224  33.568 -11.654  1.00 59.26           O  
ATOM   1638  CB  LEU B  82     -11.327  32.658 -10.705  1.00 58.61           C  
ATOM   1639  CG  LEU B  82      -9.911  32.047 -10.761  1.00 59.05           C  
ATOM   1640  CD1 LEU B  82      -8.939  32.819  -9.863  1.00 58.00           C  
ATOM   1641  CD2 LEU B  82      -9.874  30.541 -10.424  1.00 57.56           C  
ATOM   1642  N   THR B  83     -14.475  32.100  -9.937  1.00 59.60           N  
ATOM   1643  CA  THR B  83     -15.543  32.823  -9.248  1.00 59.38           C  
ATOM   1644  C   THR B  83     -14.969  33.993  -8.429  1.00 59.54           C  
ATOM   1645  O   THR B  83     -13.750  34.096  -8.264  1.00 59.71           O  
ATOM   1646  CB  THR B  83     -16.357  31.882  -8.322  1.00 59.74           C  
ATOM   1647  OG1 THR B  83     -15.505  31.315  -7.317  1.00 58.36           O  
ATOM   1648  CG2 THR B  83     -17.029  30.762  -9.122  1.00 59.45           C  
ATOM   1649  N   PRO B  84     -15.836  34.916  -7.958  1.00 59.32           N  
ATOM   1650  CA  PRO B  84     -15.361  35.943  -7.026  1.00 59.42           C  
ATOM   1651  C   PRO B  84     -14.696  35.367  -5.766  1.00 59.39           C  
ATOM   1652  O   PRO B  84     -13.738  35.958  -5.255  1.00 58.93           O  
ATOM   1653  CB  PRO B  84     -16.637  36.735  -6.691  1.00 59.13           C  
ATOM   1654  CG  PRO B  84     -17.513  36.547  -7.939  1.00 58.97           C  
ATOM   1655  CD  PRO B  84     -17.258  35.117  -8.322  1.00 59.23           C  
ATOM   1656  N   LEU B  85     -15.182  34.220  -5.288  1.00 59.45           N  
ATOM   1657  CA  LEU B  85     -14.515  33.509  -4.188  1.00 59.35           C  
ATOM   1658  C   LEU B  85     -13.113  33.030  -4.598  1.00 58.84           C  
ATOM   1659  O   LEU B  85     -12.136  33.280  -3.890  1.00 58.70           O  
ATOM   1660  CB  LEU B  85     -15.369  32.327  -3.698  1.00 59.55           C  
ATOM   1661  CG  LEU B  85     -14.824  31.561  -2.474  1.00 59.42           C  
ATOM   1662  CD1 LEU B  85     -14.716  32.443  -1.243  1.00 56.51           C  
ATOM   1663  CD2 LEU B  85     -15.737  30.356  -2.196  1.00 59.82           C  
ATOM   1664  N   GLY B  86     -13.023  32.363  -5.750  1.00 58.33           N  
ATOM   1665  CA  GLY B  86     -11.750  31.862  -6.267  1.00 57.63           C  
ATOM   1666  C   GLY B  86     -10.766  32.991  -6.492  1.00 57.53           C  
ATOM   1667  O   GLY B  86      -9.548  32.819  -6.332  1.00 57.06           O  
ATOM   1668  N   GLU B  87     -11.290  34.158  -6.854  1.00 56.93           N  
ATOM   1669  CA  GLU B  87     -10.436  35.323  -7.036  1.00 57.13           C  
ATOM   1670  C   GLU B  87      -9.780  35.754  -5.708  1.00 56.27           C  
ATOM   1671  O   GLU B  87      -8.703  36.342  -5.726  1.00 56.10           O  
ATOM   1672  CB  GLU B  87     -11.192  36.478  -7.721  1.00 56.99           C  
ATOM   1673  CG  GLU B  87     -11.391  36.322  -9.254  1.00 57.89           C  
ATOM   1674  CD  GLU B  87     -12.289  37.417  -9.878  1.00 59.54           C  
ATOM   1675  OE1 GLU B  87     -13.154  37.090 -10.725  1.00 64.55           O  
ATOM   1676  OE2 GLU B  87     -12.145  38.612  -9.534  1.00 62.58           O  
ATOM   1677  N   LYS B  88     -10.423  35.453  -4.571  1.00 55.59           N  
ATOM   1678  CA  LYS B  88      -9.857  35.751  -3.239  1.00 55.25           C  
ATOM   1679  C   LYS B  88      -8.652  34.879  -2.859  1.00 53.84           C  
ATOM   1680  O   LYS B  88      -7.986  35.137  -1.833  1.00 53.04           O  
ATOM   1681  CB  LYS B  88     -10.908  35.632  -2.125  1.00 55.43           C  
ATOM   1682  CG  LYS B  88     -12.165  36.461  -2.324  1.00 59.11           C  
ATOM   1683  CD  LYS B  88     -11.902  37.903  -2.003  1.00 63.73           C  
ATOM   1684  CE  LYS B  88     -13.189  38.680  -1.954  1.00 67.53           C  
ATOM   1685  NZ  LYS B  88     -13.937  38.328  -0.719  1.00 71.98           N  
ATOM   1686  N   VAL B  89      -8.409  33.837  -3.647  1.00 52.60           N  
ATOM   1687  CA  VAL B  89      -7.217  32.974  -3.477  1.00 52.50           C  
ATOM   1688  C   VAL B  89      -5.960  33.572  -4.130  1.00 51.99           C  
ATOM   1689  O   VAL B  89      -4.849  33.289  -3.704  1.00 52.46           O  
ATOM   1690  CB  VAL B  89      -7.484  31.546  -4.042  1.00 52.37           C  
ATOM   1691  CG1 VAL B  89      -6.311  30.611  -3.787  1.00 51.85           C  
ATOM   1692  CG2 VAL B  89      -8.748  30.991  -3.443  1.00 51.86           C  
ATOM   1693  N   LEU B  90      -6.135  34.418  -5.143  1.00 51.83           N  
ATOM   1694  CA  LEU B  90      -4.985  35.025  -5.838  1.00 51.56           C  
ATOM   1695  C   LEU B  90      -3.972  35.771  -4.955  1.00 51.27           C  
ATOM   1696  O   LEU B  90      -2.783  35.683  -5.223  1.00 52.56           O  
ATOM   1697  CB  LEU B  90      -5.436  35.882  -7.040  1.00 51.49           C  
ATOM   1698  CG  LEU B  90      -6.127  35.073  -8.164  1.00 52.72           C  
ATOM   1699  CD1 LEU B  90      -6.729  36.020  -9.224  1.00 53.12           C  
ATOM   1700  CD2 LEU B  90      -5.225  34.016  -8.830  1.00 52.22           C  
ATOM   1701  N   PRO B  91      -4.417  36.515  -3.912  1.00 50.78           N  
ATOM   1702  CA  PRO B  91      -3.423  37.082  -2.978  1.00 50.07           C  
ATOM   1703  C   PRO B  91      -2.518  36.063  -2.267  1.00 49.30           C  
ATOM   1704  O   PRO B  91      -1.362  36.377  -1.964  1.00 49.67           O  
ATOM   1705  CB  PRO B  91      -4.296  37.840  -1.956  1.00 49.78           C  
ATOM   1706  CG  PRO B  91      -5.537  38.138  -2.684  1.00 50.55           C  
ATOM   1707  CD  PRO B  91      -5.781  36.934  -3.542  1.00 50.68           C  
ATOM   1708  N   ILE B  92      -3.029  34.867  -1.994  1.00 49.01           N  
ATOM   1709  CA  ILE B  92      -2.211  33.797  -1.413  1.00 49.40           C  
ATOM   1710  C   ILE B  92      -1.138  33.387  -2.420  1.00 49.81           C  
ATOM   1711  O   ILE B  92       0.021  33.205  -2.067  1.00 50.34           O  
ATOM   1712  CB  ILE B  92      -3.062  32.520  -1.042  1.00 50.47           C  
ATOM   1713  CG1 ILE B  92      -4.141  32.855   0.010  1.00 48.58           C  
ATOM   1714  CG2 ILE B  92      -2.124  31.333  -0.575  1.00 49.22           C  
ATOM   1715  CD1 ILE B  92      -5.334  31.912  -0.012  1.00 49.09           C  
ATOM   1716  N   ILE B  93      -1.561  33.253  -3.674  1.00 49.81           N  
ATOM   1717  CA  ILE B  93      -0.727  32.804  -4.759  1.00 50.27           C  
ATOM   1718  C   ILE B  93       0.360  33.822  -5.129  1.00 50.58           C  
ATOM   1719  O   ILE B  93       1.498  33.430  -5.400  1.00 52.06           O  
ATOM   1720  CB  ILE B  93      -1.608  32.392  -5.952  1.00 51.05           C  
ATOM   1721  CG1 ILE B  93      -2.360  31.090  -5.581  1.00 49.39           C  
ATOM   1722  CG2 ILE B  93      -0.758  32.204  -7.235  1.00 50.06           C  
ATOM   1723  CD1 ILE B  93      -3.485  30.707  -6.606  1.00 50.10           C  
ATOM   1724  N   ASP B  94       0.019  35.108  -5.135  1.00 50.04           N  
ATOM   1725  CA  ASP B  94       1.009  36.182  -5.260  1.00 50.26           C  
ATOM   1726  C   ASP B  94       2.142  36.016  -4.253  1.00 49.39           C  
ATOM   1727  O   ASP B  94       3.329  36.141  -4.600  1.00 48.63           O  
ATOM   1728  CB  ASP B  94       0.366  37.552  -4.997  1.00 50.80           C  
ATOM   1729  CG  ASP B  94      -0.522  38.018  -6.131  1.00 53.36           C  
ATOM   1730  OD1 ASP B  94      -0.427  37.470  -7.242  1.00 52.85           O  
ATOM   1731  OD2 ASP B  94      -1.292  38.979  -5.910  1.00 57.69           O  
ATOM   1732  N   GLU B  95       1.774  35.739  -3.002  1.00 48.55           N  
ATOM   1733  CA  GLU B  95       2.774  35.538  -1.978  1.00 48.39           C  
ATOM   1734  C   GLU B  95       3.620  34.260  -2.197  1.00 48.51           C  
ATOM   1735  O   GLU B  95       4.810  34.250  -1.868  1.00 48.39           O  
ATOM   1736  CB  GLU B  95       2.157  35.565  -0.563  1.00 48.06           C  
ATOM   1737  CG  GLU B  95       1.682  36.925  -0.055  1.00 49.09           C  
ATOM   1738  CD  GLU B  95       2.738  38.053  -0.100  1.00 54.66           C  
ATOM   1739  OE1 GLU B  95       3.944  37.864   0.203  1.00 51.96           O  
ATOM   1740  OE2 GLU B  95       2.335  39.183  -0.429  1.00 59.26           O  
ATOM   1741  N   ILE B  96       2.993  33.190  -2.699  1.00 49.17           N  
ATOM   1742  CA  ILE B  96       3.706  31.957  -3.022  1.00 50.01           C  
ATOM   1743  C   ILE B  96       4.689  32.166  -4.170  1.00 49.98           C  
ATOM   1744  O   ILE B  96       5.841  31.682  -4.114  1.00 50.33           O  
ATOM   1745  CB  ILE B  96       2.719  30.773  -3.302  1.00 50.74           C  
ATOM   1746  CG1 ILE B  96       1.926  30.429  -2.029  1.00 49.47           C  
ATOM   1747  CG2 ILE B  96       3.468  29.532  -3.789  1.00 50.10           C  
ATOM   1748  CD1 ILE B  96       0.698  29.492  -2.256  1.00 49.30           C  
ATOM   1749  N   ALA B  97       4.254  32.909  -5.190  1.00 49.30           N  
ATOM   1750  CA  ALA B  97       5.115  33.247  -6.322  1.00 48.73           C  
ATOM   1751  C   ALA B  97       6.327  34.047  -5.860  1.00 49.56           C  
ATOM   1752  O   ALA B  97       7.472  33.759  -6.259  1.00 49.47           O  
ATOM   1753  CB  ALA B  97       4.330  34.043  -7.376  1.00 48.13           C  
ATOM   1754  N   LYS B  98       6.070  35.057  -5.027  1.00 48.85           N  
ATOM   1755  CA  LYS B  98       7.122  35.873  -4.449  1.00 49.32           C  
ATOM   1756  C   LYS B  98       8.139  35.012  -3.673  1.00 49.20           C  
ATOM   1757  O   LYS B  98       9.340  35.206  -3.812  1.00 47.26           O  
ATOM   1758  CB  LYS B  98       6.507  36.947  -3.540  1.00 49.01           C  
ATOM   1759  CG  LYS B  98       7.509  37.813  -2.788  1.00 50.59           C  
ATOM   1760  CD  LYS B  98       6.791  38.902  -2.015  1.00 52.76           C  
ATOM   1761  CE  LYS B  98       7.762  39.641  -1.140  1.00 56.30           C  
ATOM   1762  NZ  LYS B  98       7.135  40.830  -0.475  1.00 56.45           N  
ATOM   1763  N   PHE B  99       7.641  34.079  -2.858  1.00 49.09           N  
ATOM   1764  CA  PHE B  99       8.532  33.195  -2.102  1.00 49.74           C  
ATOM   1765  C   PHE B  99       9.457  32.413  -3.053  1.00 50.32           C  
ATOM   1766  O   PHE B  99      10.687  32.388  -2.888  1.00 50.48           O  
ATOM   1767  CB  PHE B  99       7.728  32.231  -1.189  1.00 48.48           C  
ATOM   1768  CG  PHE B  99       8.609  31.277  -0.417  1.00 47.92           C  
ATOM   1769  CD1 PHE B  99       9.113  31.633   0.817  1.00 46.20           C  
ATOM   1770  CD2 PHE B  99       9.029  30.055  -0.997  1.00 48.24           C  
ATOM   1771  CE1 PHE B  99       9.994  30.764   1.509  1.00 47.83           C  
ATOM   1772  CE2 PHE B  99       9.881  29.198  -0.329  1.00 48.50           C  
ATOM   1773  CZ  PHE B  99      10.364  29.546   0.934  1.00 48.96           C  
ATOM   1774  N   GLY B 100       8.850  31.773  -4.044  1.00 50.82           N  
ATOM   1775  CA  GLY B 100       9.587  31.039  -5.031  1.00 52.39           C  
ATOM   1776  C   GLY B 100      10.669  31.839  -5.755  1.00 53.70           C  
ATOM   1777  O   GLY B 100      11.804  31.361  -5.889  1.00 52.36           O  
HETATM 1778  N   MSE B 101      10.319  33.041  -6.215  1.00 55.14           N  
HETATM 1779  CA  MSE B 101      11.217  33.882  -7.015  1.00 58.50           C  
HETATM 1780  C   MSE B 101      12.361  34.415  -6.185  1.00 56.64           C  
HETATM 1781  O   MSE B 101      13.453  34.616  -6.696  1.00 57.45           O  
HETATM 1782  CB  MSE B 101      10.487  35.090  -7.613  1.00 58.23           C  
HETATM 1783  CG  MSE B 101       9.443  34.777  -8.664  1.00 61.56           C  
HETATM 1784 SE   MSE B 101       8.667  36.441  -9.426  0.70 67.46          SE  
HETATM 1785  CE  MSE B 101       6.821  36.113  -8.911  1.00 61.46           C  
ATOM   1786  N   GLU B 102      12.103  34.666  -4.910  1.00 55.25           N  
ATOM   1787  CA  GLU B 102      13.123  35.233  -4.069  1.00 54.77           C  
ATOM   1788  C   GLU B 102      14.027  34.165  -3.471  1.00 53.75           C  
ATOM   1789  O   GLU B 102      15.194  34.431  -3.206  1.00 53.87           O  
ATOM   1790  CB  GLU B 102      12.496  36.102  -2.964  1.00 54.63           C  
ATOM   1791  CG  GLU B 102      11.816  37.389  -3.476  1.00 55.72           C  
ATOM   1792  CD  GLU B 102      11.404  38.354  -2.347  1.00 55.83           C  
ATOM   1793  OE1 GLU B 102      11.519  37.991  -1.157  1.00 56.18           O  
ATOM   1794  OE2 GLU B 102      10.982  39.490  -2.663  1.00 57.89           O  
ATOM   1795  N   ASN B 103      13.487  32.960  -3.251  1.00 52.85           N  
ATOM   1796  CA  ASN B 103      14.169  31.965  -2.405  1.00 51.52           C  
ATOM   1797  C   ASN B 103      14.492  30.639  -3.071  1.00 51.01           C  
ATOM   1798  O   ASN B 103      15.361  29.900  -2.601  1.00 51.73           O  
ATOM   1799  CB  ASN B 103      13.380  31.693  -1.126  1.00 51.20           C  
ATOM   1800  CG  ASN B 103      13.089  32.947  -0.345  1.00 51.64           C  
ATOM   1801  OD1 ASN B 103      11.946  33.427  -0.308  1.00 52.69           O  
ATOM   1802  ND2 ASN B 103      14.109  33.495   0.278  1.00 50.24           N  
ATOM   1803  N   LEU B 104      13.773  30.314  -4.124  1.00 49.73           N  
ATOM   1804  CA  LEU B 104      14.040  29.084  -4.844  1.00 49.84           C  
ATOM   1805  C   LEU B 104      14.664  29.425  -6.191  1.00 48.97           C  
ATOM   1806  O   LEU B 104      15.233  28.561  -6.810  1.00 49.06           O  
ATOM   1807  CB  LEU B 104      12.754  28.271  -5.024  1.00 49.73           C  
ATOM   1808  CG  LEU B 104      12.173  27.428  -3.858  1.00 51.68           C  
ATOM   1809  CD1 LEU B 104      12.842  27.569  -2.498  1.00 50.59           C  
ATOM   1810  CD2 LEU B 104      10.702  27.614  -3.712  1.00 48.25           C  
TER    1811      LEU B 104                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
