
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  139 ( 1109),  selected  139 , name 3bja_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 3bja_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      S       1           -
LGA    X     1_A      N       2           -
LGA    N     2_A      A       3           -
LGA    N     3_A      M       4           -
LGA    R     4_A      L       5           -
LGA    E     5_A      R       6           -
LGA    L     6_A      Y       7           -
LGA    Y     7_A      G       8           -
LGA    G     8_A      D       9           -
LGA    N     9_A      T      10           -
LGA    I    10_A      E      11           -
LGA    R    11_A      I      12           -
LGA    D    12_A      C      13           -
LGA    V    13_A      -       -           -
LGA    Y    14_A      -       -           -
LGA    H    15_A      -       -           -
LGA    L    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    Q    18_A      -       -           -
LGA    K    19_A      -       -           -
LGA    N    20_A      -       -           -
LGA    L    21_A      -       -           -
LGA    D    22_A      -       -           -
LGA    K    23_A      -       -           -
LGA    A    24_A      -       -           -
LGA    I    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    Q    27_A      I      14           #
LGA    -       -      D      15           -
LGA    -       -      P      16           -
LGA    -       -      S      17           -
LGA    -       -      E      18           -
LGA    -       -      S      19           -
LGA    -       -      V      20           -
LGA    Y    28_A      L      21          4.347
LGA    D    29_A      H      22          3.940
LGA    -       -      L      23           -
LGA    I    30_A      L      24          1.326
LGA    S    31_A      G      25          3.338
LGA    Y    32_A      K      26           #
LGA    -       -      K      27           -
LGA    V    33_A      Y      28          0.611
LGA    Q    34_A      T      29          1.175
LGA    F    35_A      M      30          1.370
LGA    G    36_A      L      31          1.434
LGA    V    37_A      I      32          1.293
LGA    I    38_A      I      33          1.527
LGA    Q    39_A      S      34          1.790
LGA    V    40_A      V      35          1.391
LGA    L    41_A      L      36          1.126
LGA    A    42_A      G      37          0.644
LGA    K    43_A      N      38          0.961
LGA    S    44_A      G      39          2.418
LGA    -       -      S      40           -
LGA    G    45_A      T      41          2.779
LGA    K    46_A      R      42          0.977
LGA    V    47_A      Q      43          1.317
LGA    S    48_A      N      44          1.369
LGA    X    49_A      F      45          1.782
LGA    S    50_A      N      46          2.460
LGA    K    51_A      D      47          2.077
LGA    L    52_A      I      48          1.805
LGA    I    53_A      R      49          2.232
LGA    E    54_A      S      50          2.562
LGA    N    55_A      S      51          2.576
LGA    X    56_A      I      52          2.643
LGA    G    57_A      P      53          2.195
LGA    C    58_A      G      54          2.038
LGA    V    59_A      I      55          2.235
LGA    P    60_A      S      56          2.098
LGA    S    61_A      S      57          4.549
LGA    N    62_A      T      58          1.407
LGA    -       -      I      59           -
LGA    X    63_A      L      60          2.281
LGA    T    64_A      S      61          2.001
LGA    T    65_A      R      62          2.225
LGA    X    66_A      R      63          1.918
LGA    I    67_A      I      64          0.694
LGA    Q    68_A      K      65          0.699
LGA    R    69_A      D      66          0.652
LGA    X    70_A      L      67          0.727
LGA    K    71_A      I      68          0.438
LGA    R    72_A      D      69          0.685
LGA    D    73_A      S      70          1.247
LGA    G    74_A      G      71          1.532
LGA    Y    75_A      L      72          1.471
LGA    V    76_A      V      73          0.726
LGA    X    77_A      E      74          0.530
LGA    T    78_A      R      75          0.453
LGA    E    79_A      R      76          1.545
LGA    K    80_A      S      77          0.465
LGA    N    81_A      G      78          1.243
LGA    P    82_A      -       -           -
LGA    N    83_A      -       -           -
LGA    D    84_A      Q      79          2.205
LGA    Q    85_A      -       -           -
LGA    R    86_A      -       -           -
LGA    E    87_A      I      80          3.575
LGA    T    88_A      T      81          1.728
LGA    L    89_A      T      82          1.147
LGA    V    90_A      Y      83          0.501
LGA    Y    91_A      A      84          0.478
LGA    L    92_A      L      85          0.773
LGA    T    93_A      T      86          0.737
LGA    K    94_A      E      87          0.810
LGA    K    95_A      K      88          0.950
LGA    G    96_A      G      89          1.025
LGA    E    97_A      M      90          0.765
LGA    E    98_A      N      91          0.852
LGA    T    99_A      V      92          0.582
LGA    K   100_A      R      93          1.030
LGA    K   101_A      N      94          1.312
LGA    Q   102_A      S      95          0.827
LGA    V   103_A      L      96          1.293
LGA    D   104_A      M      97          1.539
LGA    V   105_A      P      98          2.163
LGA    Q   106_A      L      99          1.807
LGA    Y   107_A      L     100          1.732
LGA    S   108_A      Q     101          2.524
LGA    D   109_A      Y     102          2.630
LGA    F   110_A      I     103          1.926
LGA    L   111_A      S     104          2.543
LGA    K   112_A      V     105          2.903
LGA    E   113_A      L     106          3.231
LGA    N   114_A      D     107          3.624
LGA    C   115_A      R     108          1.933
LGA    G   116_A      N     109          2.569
LGA    C   117_A      -       -           -
LGA    F   118_A      -       -           -
LGA    T   119_A      -       -           -
LGA    K   120_A      -       -           -
LGA    E   121_A      -       -           -
LGA    E   122_A      -       -           -
LGA    E   123_A      -       -           -
LGA    G   124_A      -       -           -
LGA    I   125_A      -       -           -
LGA    L   126_A      -       -           -
LGA    E   127_A      -       -           -
LGA    D   128_A      -       -           -
LGA    L   129_A      -       -           -
LGA    L   130_A      -       -           -
LGA    L   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    W   133_A      -       -           -
LGA    K   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    H   136_A      -       -           -
LGA    L   137_A      -       -           -
LGA    N   138_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  139  109    5.0     84    1.92    14.29     69.765     4.159

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.854313 * X  +  -0.404175 * Y  +   0.326791 * Z  +  30.615522
  Y_new =   0.257470 * X  +  -0.875258 * Y  +  -0.409428 * Z  +  28.073009
  Z_new =   0.451507 * X  +  -0.265641 * Y  +   0.851808 * Z  + -15.391167 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.302298    2.839295  [ DEG:   -17.3204    162.6796 ]
  Theta =  -0.468454   -2.673139  [ DEG:   -26.8404   -153.1596 ]
  Phi   =   2.848873   -0.292720  [ DEG:   163.2284    -16.7716 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bja_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bja_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  139  109   5.0   84   1.92   14.29  69.765
REMARK  ---------------------------------------------------------- 
MOLECULE 3bja_A
HEADER    TRANSCRIPTION REGULATOR                 03-DEC-07   3BJA              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE MARR-LIKE TRANSCRIPTION                 
TITLE    2 REGULATOR (NP_978771.1) FROM BACILLUS CEREUS ATCC 10987 AT           
TITLE    3 2.38 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR, MARR FAMILY, PUTATIVE;          
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS CEREUS ATCC 10987;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_978771.1, BCE_2462;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_978771.1, PUTATIVE MARR-LIKE TRANSCRIPTION REGULATOR,              
KEYWDS   2 MARR FAMILY, STRUCTURAL GENOMICS, JOINT CENTER FOR                   
KEYWDS   3 STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE,             
KEYWDS   4 PSI-2, DNA-BINDING, TRANSCRIPTION REGULATION                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   11-DEC-07 3BJA    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE MARR-LIKE                      
JRNL        TITL 2 TRANSCRIPTION REGULATOR (NP_978771.1) FROM                   
JRNL        TITL 3 BACILLUS CEREUS ATCC 10987 AT 2.38 A RESOLUTION              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.38 ANGSTROMS.                                          
DBREF  3BJA A    1   138  UNP    Q738D3   Q738D3_BACC1     1    138             
SEQRES   1 A  139  GLY MSE ASN ASN ARG GLU LEU TYR GLY ASN ILE ARG ASP          
SEQRES   2 A  139  VAL TYR HIS LEU LEU GLN LYS ASN LEU ASP LYS ALA ILE          
SEQRES   3 A  139  GLU GLN TYR ASP ILE SER TYR VAL GLN PHE GLY VAL ILE          
SEQRES   4 A  139  GLN VAL LEU ALA LYS SER GLY LYS VAL SER MSE SER LYS          
SEQRES   5 A  139  LEU ILE GLU ASN MSE GLY CYS VAL PRO SER ASN MSE THR          
SEQRES   6 A  139  THR MSE ILE GLN ARG MSE LYS ARG ASP GLY TYR VAL MSE          
SEQRES   7 A  139  THR GLU LYS ASN PRO ASN ASP GLN ARG GLU THR LEU VAL          
SEQRES   8 A  139  TYR LEU THR LYS LYS GLY GLU GLU THR LYS LYS GLN VAL          
SEQRES   9 A  139  ASP VAL GLN TYR SER ASP PHE LEU LYS GLU ASN CYS GLY          
SEQRES  10 A  139  CYS PHE THR LYS GLU GLU GLU GLY ILE LEU GLU ASP LEU          
SEQRES  11 A  139  LEU LEU LYS TRP LYS LYS HIS LEU ASN                          
HET    MSE  A   1       8                                                       
HET    MSE  A  49       8                                                       
HET    MSE  A  56       8                                                       
HET    MSE  A  63       8                                                       
HET    MSE  A  66       8                                                       
HET    MSE  A  70       8                                                       
HET    MSE  A  77       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    7(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *13(H2 O)                                                     
CRYST1   71.321   71.321   65.720  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   GLY A   0      26.240   7.669 -20.127  1.00101.89           N  
ATOM      2  CA  GLY A   0      26.845   6.762 -19.107  1.00100.68           C  
ATOM      3  C   GLY A   0      26.450   7.198 -17.713  1.00 99.17           C  
ATOM      4  O   GLY A   0      25.360   7.741 -17.531  1.00100.17           O  
HETATM    5  N   MSE A   1      27.337   6.972 -16.739  1.00 97.82           N  
HETATM    6  CA  MSE A   1      27.101   7.356 -15.324  1.00 94.85           C  
HETATM    7  C   MSE A   1      27.043   8.878 -15.136  1.00 92.28           C  
HETATM    8  O   MSE A   1      26.355   9.342 -14.252  1.00 91.89           O  
HETATM    9  CB  MSE A   1      28.166   6.726 -14.393  1.00 98.34           C  
HETATM   10  CG  MSE A   1      27.874   6.759 -12.867  1.00100.19           C  
HETATM   11 SE   MSE A   1      26.181   5.904 -12.298  0.75113.87          SE  
HETATM   12  CE  MSE A   1      26.233   4.268 -13.333  1.00107.40           C  
ATOM     13  N   ASN A   2      27.790   9.630 -15.951  1.00 90.09           N  
ATOM     14  CA  ASN A   2      27.731  11.116 -15.991  1.00 87.50           C  
ATOM     15  C   ASN A   2      26.349  11.651 -16.426  1.00 84.17           C  
ATOM     16  O   ASN A   2      25.847  12.614 -15.840  1.00 83.50           O  
ATOM     17  CB  ASN A   2      28.835  11.719 -16.908  1.00 88.10           C  
ATOM     18  CG  ASN A   2      28.829  11.137 -18.377  1.00 93.96           C  
ATOM     19  OD1 ASN A   2      28.379  10.003 -18.627  1.00 94.53           O  
ATOM     20  ND2 ASN A   2      29.361  11.913 -19.323  1.00 94.37           N  
ATOM     21  N   ASN A   3      25.760  11.021 -17.449  1.00 80.59           N  
ATOM     22  CA  ASN A   3      24.432  11.376 -17.986  1.00 80.28           C  
ATOM     23  C   ASN A   3      23.342  11.012 -16.994  1.00 77.31           C  
ATOM     24  O   ASN A   3      22.418  11.773 -16.754  1.00 77.29           O  
ATOM     25  CB  ASN A   3      24.142  10.623 -19.287  1.00 79.82           C  
ATOM     26  CG  ASN A   3      25.104  10.965 -20.415  1.00 80.82           C  
ATOM     27  OD1 ASN A   3      25.841  11.939 -20.356  1.00 91.63           O  
ATOM     28  ND2 ASN A   3      25.074  10.169 -21.457  1.00 78.06           N  
ATOM     29  N   ARG A   4      23.487   9.836 -16.411  1.00 75.88           N  
ATOM     30  CA  ARG A   4      22.577   9.318 -15.411  1.00 75.13           C  
ATOM     31  C   ARG A   4      22.614  10.166 -14.137  1.00 73.95           C  
ATOM     32  O   ARG A   4      21.557  10.500 -13.595  1.00 74.53           O  
ATOM     33  CB  ARG A   4      22.942   7.861 -15.157  1.00 76.22           C  
ATOM     34  CG  ARG A   4      22.011   7.081 -14.293  1.00 77.69           C  
ATOM     35  CD  ARG A   4      22.479   5.655 -14.240  1.00 75.46           C  
ATOM     36  NE  ARG A   4      22.172   4.893 -15.450  1.00 77.96           N  
ATOM     37  CZ  ARG A   4      21.171   4.018 -15.608  1.00 73.72           C  
ATOM     38  NH1 ARG A   4      20.295   3.742 -14.630  1.00 72.27           N  
ATOM     39  NH2 ARG A   4      21.056   3.384 -16.778  1.00 70.16           N  
ATOM     40  N   GLU A   5      23.814  10.531 -13.681  1.00 73.98           N  
ATOM     41  CA  GLU A   5      23.990  11.438 -12.509  1.00 75.17           C  
ATOM     42  C   GLU A   5      23.371  12.835 -12.724  1.00 74.79           C  
ATOM     43  O   GLU A   5      22.909  13.461 -11.777  1.00 76.17           O  
ATOM     44  CB  GLU A   5      25.472  11.603 -12.150  1.00 76.44           C  
ATOM     45  CG  GLU A   5      26.146  10.375 -11.463  1.00 86.82           C  
ATOM     46  CD  GLU A   5      26.135  10.381  -9.929  1.00101.24           C  
ATOM     47  OE1 GLU A   5      25.649  11.355  -9.285  1.00106.84           O  
ATOM     48  OE2 GLU A   5      26.656   9.389  -9.367  1.00102.97           O  
ATOM     49  N   LEU A   6      23.404  13.320 -13.962  1.00 73.92           N  
ATOM     50  CA  LEU A   6      22.831  14.618 -14.340  1.00 73.01           C  
ATOM     51  C   LEU A   6      21.294  14.567 -14.354  1.00 71.47           C  
ATOM     52  O   LEU A   6      20.648  15.492 -13.868  1.00 71.09           O  
ATOM     53  CB  LEU A   6      23.361  15.039 -15.714  1.00 72.26           C  
ATOM     54  CG  LEU A   6      22.940  16.377 -16.313  1.00 75.43           C  
ATOM     55  CD1 LEU A   6      23.357  17.517 -15.409  1.00 76.64           C  
ATOM     56  CD2 LEU A   6      23.547  16.518 -17.725  1.00 74.58           C  
ATOM     57  N   TYR A   7      20.720  13.505 -14.920  1.00 72.97           N  
ATOM     58  CA  TYR A   7      19.255  13.313 -14.930  1.00 74.11           C  
ATOM     59  C   TYR A   7      18.751  13.310 -13.492  1.00 74.16           C  
ATOM     60  O   TYR A   7      17.850  14.084 -13.154  1.00 75.03           O  
ATOM     61  CB  TYR A   7      18.876  12.022 -15.634  1.00 76.77           C  
ATOM     62  CG  TYR A   7      17.382  11.737 -15.700  1.00 76.82           C  
ATOM     63  CD1 TYR A   7      16.518  12.632 -16.310  1.00 75.30           C  
ATOM     64  CD2 TYR A   7      16.849  10.535 -15.206  1.00 78.32           C  
ATOM     65  CE1 TYR A   7      15.152  12.371 -16.397  1.00 80.70           C  
ATOM     66  CE2 TYR A   7      15.481  10.254 -15.302  1.00 82.05           C  
ATOM     67  CZ  TYR A   7      14.635  11.183 -15.900  1.00 84.42           C  
ATOM     68  OH  TYR A   7      13.274  10.940 -15.994  1.00 86.23           O  
ATOM     69  N   GLY A   8      19.404  12.512 -12.648  1.00 73.10           N  
ATOM     70  CA  GLY A   8      19.114  12.439 -11.219  1.00 73.15           C  
ATOM     71  C   GLY A   8      19.212  13.756 -10.470  1.00 73.07           C  
ATOM     72  O   GLY A   8      18.360  14.049  -9.643  1.00 74.68           O  
ATOM     73  N   ASN A   9      20.225  14.560 -10.761  1.00 72.69           N  
ATOM     74  CA  ASN A   9      20.375  15.846 -10.077  1.00 75.63           C  
ATOM     75  C   ASN A   9      19.284  16.831 -10.446  1.00 75.35           C  
ATOM     76  O   ASN A   9      18.793  17.537  -9.559  1.00 73.25           O  
ATOM     77  CB  ASN A   9      21.756  16.479 -10.298  1.00 76.45           C  
ATOM     78  CG  ASN A   9      22.881  15.689  -9.626  1.00 84.22           C  
ATOM     79  OD1 ASN A   9      22.676  15.031  -8.585  1.00 80.41           O  
ATOM     80  ND2 ASN A   9      24.085  15.743 -10.228  1.00 82.88           N  
ATOM     81  N   ILE A  10      18.900  16.865 -11.728  1.00 75.43           N  
ATOM     82  CA  ILE A  10      17.850  17.765 -12.163  1.00 76.88           C  
ATOM     83  C   ILE A  10      16.491  17.350 -11.559  1.00 75.51           C  
ATOM     84  O   ILE A  10      15.759  18.242 -11.114  1.00 74.36           O  
ATOM     85  CB  ILE A  10      17.832  18.042 -13.698  1.00 75.11           C  
ATOM     86  CG1 ILE A  10      17.123  19.381 -13.948  1.00 81.44           C  
ATOM     87  CG2 ILE A  10      17.219  16.924 -14.455  1.00 78.65           C  
ATOM     88  CD1 ILE A  10      17.112  19.833 -15.350  1.00 81.16           C  
ATOM     89  N   ARG A  11      16.188  16.039 -11.498  1.00 76.30           N  
ATOM     90  CA  ARG A  11      14.933  15.588 -10.885  0.50 76.92           C  
ATOM     92  C   ARG A  11      14.898  15.926  -9.394  1.00 77.16           C  
ATOM     93  O   ARG A  11      13.892  16.417  -8.917  1.00 78.39           O  
ATOM     94  CB  ARG A  11      14.682  14.085 -11.030  0.50 76.46           C  
ATOM     96  CG  ARG A  11      14.603  13.549 -12.444  0.50 76.77           C  
ATOM     98  CD  ARG A  11      13.729  12.279 -12.518  0.50 81.42           C  
ATOM    100  NE  ARG A  11      12.357  12.571 -12.955  0.50 86.93           N  
ATOM    102  CZ  ARG A  11      11.303  11.758 -12.821  0.50 88.54           C  
ATOM    104  NH1 ARG A  11      11.391  10.568 -12.206  0.50 89.07           N  
ATOM    106  NH2 ARG A  11      10.117  12.156 -13.293  0.50 88.65           N  
ATOM    108  N   ASP A  12      15.993  15.634  -8.678  1.00 76.57           N  
ATOM    109  CA  ASP A  12      16.100  15.893  -7.240  1.00 75.83           C  
ATOM    110  C   ASP A  12      15.868  17.361  -6.910  1.00 77.25           C  
ATOM    111  O   ASP A  12      15.100  17.665  -5.996  1.00 81.03           O  
ATOM    112  CB  ASP A  12      17.444  15.409  -6.673  1.00 74.93           C  
ATOM    113  CG  ASP A  12      17.595  13.880  -6.691  1.00 76.44           C  
ATOM    114  OD1 ASP A  12      16.635  13.130  -7.026  1.00 78.58           O  
ATOM    115  OD2 ASP A  12      18.704  13.413  -6.357  1.00 79.06           O  
ATOM    116  N   VAL A  13      16.481  18.266  -7.665  1.00 75.50           N  
ATOM    117  CA  VAL A  13      16.261  19.696  -7.438  1.00 76.60           C  
ATOM    118  C   VAL A  13      14.788  20.089  -7.698  1.00 78.11           C  
ATOM    119  O   VAL A  13      14.204  20.843  -6.913  1.00 78.65           O  
ATOM    120  CB  VAL A  13      17.232  20.577  -8.260  1.00 76.38           C  
ATOM    121  CG1 VAL A  13      16.825  22.056  -8.185  1.00 66.28           C  
ATOM    122  CG2 VAL A  13      18.648  20.384  -7.742  1.00 76.24           C  
ATOM    123  N   TYR A  14      14.207  19.562  -8.777  1.00 79.18           N  
ATOM    124  CA  TYR A  14      12.808  19.825  -9.114  1.00 79.92           C  
ATOM    125  C   TYR A  14      11.878  19.322  -8.015  1.00 77.38           C  
ATOM    126  O   TYR A  14      10.977  20.045  -7.614  1.00 78.55           O  
ATOM    127  CB  TYR A  14      12.463  19.204 -10.450  1.00 82.33           C  
ATOM    128  CG  TYR A  14      11.024  19.349 -10.908  1.00 88.71           C  
ATOM    129  CD1 TYR A  14      10.606  20.450 -11.676  1.00 92.56           C  
ATOM    130  CD2 TYR A  14      10.084  18.357 -10.618  1.00 87.73           C  
ATOM    131  CE1 TYR A  14       9.267  20.557 -12.130  1.00 91.97           C  
ATOM    132  CE2 TYR A  14       8.759  18.461 -11.037  1.00 88.13           C  
ATOM    133  CZ  TYR A  14       8.357  19.542 -11.810  1.00 93.18           C  
ATOM    134  OH  TYR A  14       7.050  19.579 -12.234  1.00 97.43           O  
ATOM    135  N   HIS A  15      12.113  18.112  -7.520  1.00 76.37           N  
ATOM    136  CA  HIS A  15      11.290  17.545  -6.450  1.00 76.10           C  
ATOM    137  C   HIS A  15      11.411  18.323  -5.125  1.00 76.83           C  
ATOM    138  O   HIS A  15      10.399  18.554  -4.465  1.00 78.37           O  
ATOM    139  CB  HIS A  15      11.532  16.051  -6.266  1.00 76.91           C  
ATOM    140  CG  HIS A  15      11.094  15.219  -7.435  1.00 81.63           C  
ATOM    141  ND1 HIS A  15      11.710  14.034  -7.780  1.00 88.52           N  
ATOM    142  CD2 HIS A  15      10.123  15.420  -8.358  1.00 89.36           C  
ATOM    143  CE1 HIS A  15      11.121  13.531  -8.850  1.00 88.18           C  
ATOM    144  NE2 HIS A  15      10.161  14.359  -9.227  1.00 87.10           N  
ATOM    145  N   LEU A  16      12.617  18.758  -4.761  1.00 76.03           N  
ATOM    146  CA  LEU A  16      12.810  19.616  -3.574  1.00 74.01           C  
ATOM    147  C   LEU A  16      12.059  20.955  -3.712  1.00 72.51           C  
ATOM    148  O   LEU A  16      11.516  21.464  -2.735  1.00 72.25           O  
ATOM    149  CB  LEU A  16      14.293  19.872  -3.290  1.00 72.63           C  
ATOM    150  CG  LEU A  16      15.104  18.670  -2.790  1.00 72.34           C  
ATOM    151  CD1 LEU A  16      16.610  18.942  -2.921  1.00 75.71           C  
ATOM    152  CD2 LEU A  16      14.742  18.323  -1.356  1.00 61.91           C  
ATOM    153  N   LEU A  17      12.034  21.507  -4.919  1.00 73.25           N  
ATOM    154  CA  LEU A  17      11.284  22.735  -5.207  1.00 74.16           C  
ATOM    155  C   LEU A  17       9.760  22.536  -5.049  1.00 74.72           C  
ATOM    156  O   LEU A  17       9.116  23.456  -4.551  1.00 78.71           O  
ATOM    157  CB  LEU A  17      11.626  23.326  -6.593  1.00 72.99           C  
ATOM    158  CG  LEU A  17      13.002  23.961  -6.833  1.00 72.23           C  
ATOM    159  CD1 LEU A  17      13.298  24.166  -8.338  1.00 71.84           C  
ATOM    160  CD2 LEU A  17      13.119  25.257  -6.087  1.00 59.70           C  
ATOM    161  N   GLN A  18       9.182  21.401  -5.480  1.00 74.25           N  
ATOM    162  CA  GLN A  18       7.744  21.213  -5.287  0.50 75.17           C  
ATOM    164  C   GLN A  18       7.462  21.018  -3.782  1.00 76.25           C  
ATOM    165  O   GLN A  18       6.555  21.688  -3.246  1.00 75.51           O  
ATOM    166  CB  GLN A  18       7.160  20.130  -6.198  0.50 75.40           C  
ATOM    168  CG  GLN A  18       7.392  20.393  -7.714  0.50 78.61           C  
ATOM    170  CD  GLN A  18       6.836  21.735  -8.234  0.50 80.37           C  
ATOM    172  OE1 GLN A  18       5.616  21.919  -8.390  0.50 75.73           O  
ATOM    174  NE2 GLN A  18       7.742  22.662  -8.534  0.50 75.03           N  
ATOM    176  N   LYS A  19       8.249  20.171  -3.108  1.00 75.37           N  
ATOM    177  CA  LYS A  19       8.146  19.964  -1.657  1.00 76.54           C  
ATOM    178  C   LYS A  19       8.128  21.294  -0.886  1.00 74.76           C  
ATOM    179  O   LYS A  19       7.234  21.531  -0.087  1.00 77.05           O  
ATOM    180  CB  LYS A  19       9.324  19.109  -1.189  1.00 78.14           C  
ATOM    181  CG  LYS A  19       9.482  18.857   0.334  1.00 80.13           C  
ATOM    182  CD  LYS A  19      10.732  17.985   0.573  1.00 83.59           C  
ATOM    183  CE  LYS A  19      11.242  17.998   2.017  1.00 93.37           C  
ATOM    184  NZ  LYS A  19      12.659  17.466   2.100  1.00 93.64           N  
ATOM    185  N   ASN A  20       9.105  22.150  -1.169  1.00 72.49           N  
ATOM    186  CA  ASN A  20       9.241  23.456  -0.514  1.00 70.52           C  
ATOM    187  C   ASN A  20       8.145  24.474  -0.865  1.00 70.52           C  
ATOM    188  O   ASN A  20       7.833  25.329  -0.023  1.00 71.20           O  
ATOM    189  CB  ASN A  20      10.624  24.069  -0.797  1.00 69.96           C  
ATOM    190  CG  ASN A  20      11.774  23.320  -0.115  1.00 69.06           C  
ATOM    191  OD1 ASN A  20      11.582  22.339   0.598  1.00 59.28           O  
ATOM    192  ND2 ASN A  20      12.994  23.805  -0.342  1.00 66.40           N  
ATOM    193  N   LEU A  21       7.615  24.413  -2.096  1.00 68.07           N  
ATOM    194  CA  LEU A  21       6.480  25.258  -2.528  1.00 67.34           C  
ATOM    195  C   LEU A  21       5.194  24.863  -1.794  1.00 67.91           C  
ATOM    196  O   LEU A  21       4.444  25.754  -1.354  1.00 69.81           O  
ATOM    197  CB  LEU A  21       6.242  25.165  -4.037  1.00 66.75           C  
ATOM    198  CG  LEU A  21       5.081  25.945  -4.673  1.00 67.71           C  
ATOM    199  CD1 LEU A  21       5.147  27.439  -4.387  1.00 65.17           C  
ATOM    200  CD2 LEU A  21       5.075  25.698  -6.159  1.00 68.35           C  
ATOM    201  N   ASP A  22       4.944  23.547  -1.697  1.00 65.52           N  
ATOM    202  CA  ASP A  22       3.794  22.984  -0.985  1.00 65.75           C  
ATOM    203  C   ASP A  22       3.782  23.382   0.475  1.00 66.08           C  
ATOM    204  O   ASP A  22       2.702  23.630   1.030  1.00 62.97           O  
ATOM    205  CB  ASP A  22       3.753  21.440  -1.067  1.00 65.12           C  
ATOM    206  CG  ASP A  22       3.167  20.910  -2.378  1.00 71.24           C  
ATOM    207  OD1 ASP A  22       2.816  21.709  -3.295  1.00 77.93           O  
ATOM    208  OD2 ASP A  22       3.048  19.657  -2.484  1.00 79.40           O  
ATOM    209  N   LYS A  23       4.979  23.418   1.078  1.00 66.70           N  
ATOM    210  CA  LYS A  23       5.165  23.851   2.466  1.00 67.24           C  
ATOM    211  C   LYS A  23       4.786  25.328   2.541  1.00 68.12           C  
ATOM    212  O   LYS A  23       4.017  25.720   3.416  1.00 70.14           O  
ATOM    213  CB  LYS A  23       6.618  23.625   2.928  1.00 67.51           C  
ATOM    214  CG  LYS A  23       6.831  23.419   4.436  1.00 73.39           C  
ATOM    215  CD  LYS A  23       6.775  24.685   5.279  1.00 79.03           C  
ATOM    216  CE  LYS A  23       6.985  24.377   6.763  1.00 78.47           C  
ATOM    217  NZ  LYS A  23       5.848  23.603   7.343  1.00 80.64           N  
ATOM    218  N   ALA A  24       5.296  26.112   1.586  1.00 68.79           N  
ATOM    219  CA  ALA A  24       5.061  27.560   1.494  1.00 68.03           C  
ATOM    220  C   ALA A  24       3.600  27.988   1.292  1.00 68.01           C  
ATOM    221  O   ALA A  24       3.175  28.990   1.891  1.00 69.34           O  
ATOM    222  CB  ALA A  24       5.929  28.158   0.395  1.00 66.13           C  
ATOM    223  N   ILE A  25       2.848  27.256   0.457  1.00 68.19           N  
ATOM    224  CA  ILE A  25       1.413  27.568   0.182  1.00 67.97           C  
ATOM    225  C   ILE A  25       0.395  26.769   1.035  1.00 67.50           C  
ATOM    226  O   ILE A  25      -0.824  26.915   0.847  1.00 63.75           O  
ATOM    227  CB  ILE A  25       1.074  27.458  -1.352  1.00 68.24           C  
ATOM    228  CG1 ILE A  25       1.039  25.997  -1.861  1.00 70.69           C  
ATOM    229  CG2 ILE A  25       2.043  28.298  -2.157  1.00 62.64           C  
ATOM    230  CD1 ILE A  25       0.648  25.859  -3.324  1.00 67.56           C  
ATOM    231  N   GLU A  26       0.920  25.961   1.969  1.00 69.55           N  
ATOM    232  CA  GLU A  26       0.167  25.051   2.876  1.00 69.63           C  
ATOM    233  C   GLU A  26      -1.038  25.691   3.550  1.00 67.93           C  
ATOM    234  O   GLU A  26      -2.131  25.114   3.573  1.00 68.68           O  
ATOM    235  CB  GLU A  26       1.133  24.523   3.963  1.00 69.56           C  
ATOM    236  CG  GLU A  26       0.612  23.463   4.929  1.00 72.06           C  
ATOM    237  CD  GLU A  26       1.595  23.138   6.066  1.00 74.84           C  
ATOM    238  OE1 GLU A  26       2.801  23.477   5.946  1.00 79.57           O  
ATOM    239  OE2 GLU A  26       1.150  22.538   7.092  1.00 82.34           O  
ATOM    240  N   GLN A  27      -0.809  26.878   4.103  1.00 66.24           N  
ATOM    241  CA  GLN A  27      -1.832  27.672   4.804  1.00 66.29           C  
ATOM    242  C   GLN A  27      -3.110  27.970   4.007  1.00 63.32           C  
ATOM    243  O   GLN A  27      -4.150  28.156   4.613  1.00 63.24           O  
ATOM    244  CB  GLN A  27      -1.231  28.992   5.321  1.00 66.81           C  
ATOM    245  CG  GLN A  27      -0.741  29.969   4.222  1.00 73.49           C  
ATOM    246  CD  GLN A  27      -0.161  31.253   4.802  1.00 72.98           C  
ATOM    247  OE1 GLN A  27       1.033  31.321   5.109  1.00 81.18           O  
ATOM    248  NE2 GLN A  27      -1.006  32.292   4.922  1.00 74.61           N  
ATOM    249  N   TYR A  28      -3.023  28.010   2.675  1.00 61.34           N  
ATOM    250  CA  TYR A  28      -4.180  28.274   1.798  1.00 61.22           C  
ATOM    251  C   TYR A  28      -4.974  27.030   1.389  1.00 60.93           C  
ATOM    252  O   TYR A  28      -5.829  27.122   0.502  1.00 62.06           O  
ATOM    253  CB  TYR A  28      -3.728  29.027   0.535  1.00 61.23           C  
ATOM    254  CG  TYR A  28      -3.041  30.320   0.850  1.00 61.81           C  
ATOM    255  CD1 TYR A  28      -3.786  31.446   1.173  1.00 62.82           C  
ATOM    256  CD2 TYR A  28      -1.642  30.423   0.850  1.00 61.88           C  
ATOM    257  CE1 TYR A  28      -3.173  32.650   1.496  1.00 64.95           C  
ATOM    258  CE2 TYR A  28      -1.013  31.628   1.172  1.00 63.89           C  
ATOM    259  CZ  TYR A  28      -1.798  32.742   1.490  1.00 63.24           C  
ATOM    260  OH  TYR A  28      -1.246  33.947   1.810  1.00 64.90           O  
ATOM    261  N   ASP A  29      -4.715  25.877   2.013  1.00 60.48           N  
ATOM    262  CA  ASP A  29      -5.417  24.622   1.687  1.00 60.81           C  
ATOM    263  C   ASP A  29      -5.382  24.223   0.195  1.00 61.56           C  
ATOM    264  O   ASP A  29      -6.394  23.808  -0.384  1.00 64.01           O  
ATOM    265  CB  ASP A  29      -6.848  24.677   2.236  1.00 59.00           C  
ATOM    266  CG  ASP A  29      -6.869  24.872   3.722  1.00 58.42           C  
ATOM    267  OD1 ASP A  29      -6.191  24.091   4.409  1.00 46.00           O  
ATOM    268  OD2 ASP A  29      -7.570  25.779   4.212  1.00 65.06           O  
ATOM    269  N   ILE A  30      -4.210  24.396  -0.408  1.00 62.37           N  
ATOM    270  CA  ILE A  30      -3.943  24.033  -1.805  1.00 63.76           C  
ATOM    271  C   ILE A  30      -2.538  23.458  -1.910  1.00 64.74           C  
ATOM    272  O   ILE A  30      -1.694  23.713  -1.046  1.00 64.60           O  
ATOM    273  CB  ILE A  30      -4.096  25.242  -2.797  1.00 63.60           C  
ATOM    274  CG1 ILE A  30      -3.143  26.408  -2.489  1.00 64.87           C  
ATOM    275  CG2 ILE A  30      -5.535  25.755  -2.804  1.00 63.96           C  
ATOM    276  CD1 ILE A  30      -3.033  27.434  -3.629  1.00 63.83           C  
ATOM    277  N   SER A  31      -2.298  22.682  -2.960  1.00 69.15           N  
ATOM    278  CA  SER A  31      -0.961  22.125  -3.264  1.00 72.68           C  
ATOM    279  C   SER A  31      -0.514  22.728  -4.584  1.00 72.84           C  
ATOM    280  O   SER A  31      -1.271  23.509  -5.191  1.00 71.94           O  
ATOM    281  CB  SER A  31      -1.030  20.609  -3.376  1.00 73.50           C  
ATOM    282  OG  SER A  31      -1.719  20.236  -4.559  1.00 80.23           O  
ATOM    283  N   TYR A  32       0.684  22.352  -5.045  1.00 75.04           N  
ATOM    284  CA  TYR A  32       1.228  22.878  -6.317  1.00 77.87           C  
ATOM    285  C   TYR A  32       0.247  22.680  -7.496  1.00 75.77           C  
ATOM    286  O   TYR A  32       0.087  23.587  -8.315  1.00 75.20           O  
ATOM    287  CB  TYR A  32       2.656  22.324  -6.649  1.00 82.69           C  
ATOM    288  CG  TYR A  32       2.731  20.837  -7.017  1.00 86.64           C  
ATOM    289  CD1 TYR A  32       2.892  19.852  -6.027  1.00 95.58           C  
ATOM    290  CD2 TYR A  32       2.630  20.409  -8.362  1.00 90.07           C  
ATOM    291  CE1 TYR A  32       2.948  18.467  -6.347  1.00 96.34           C  
ATOM    292  CE2 TYR A  32       2.680  19.030  -8.697  1.00 92.45           C  
ATOM    293  CZ  TYR A  32       2.848  18.058  -7.680  1.00 95.44           C  
ATOM    294  OH  TYR A  32       2.902  16.692  -7.964  1.00 94.93           O  
ATOM    295  N   VAL A  33      -0.432  21.525  -7.544  1.00 76.25           N  
ATOM    296  CA  VAL A  33      -1.377  21.225  -8.647  1.00 76.18           C  
ATOM    297  C   VAL A  33      -2.552  22.241  -8.699  1.00 74.16           C  
ATOM    298  O   VAL A  33      -2.823  22.798  -9.766  1.00 73.59           O  
ATOM    299  CB  VAL A  33      -1.796  19.710  -8.719  1.00 76.60           C  
ATOM    300  CG1 VAL A  33      -2.430  19.231  -7.440  1.00 82.88           C  
ATOM    301  CG2 VAL A  33      -2.731  19.451  -9.906  1.00 75.72           C  
ATOM    302  N   GLN A  34      -3.156  22.564  -7.557  1.00 73.44           N  
ATOM    303  CA  GLN A  34      -4.269  23.555  -7.522  1.00 73.43           C  
ATOM    304  C   GLN A  34      -3.750  24.973  -7.798  1.00 70.18           C  
ATOM    305  O   GLN A  34      -4.377  25.746  -8.525  1.00 68.18           O  
ATOM    306  CB  GLN A  34      -5.067  23.521  -6.215  1.00 72.23           C  
ATOM    307  CG  GLN A  34      -5.850  22.235  -5.986  1.00 73.85           C  
ATOM    308  CD  GLN A  34      -4.999  21.067  -5.537  1.00 73.63           C  
ATOM    309  OE1 GLN A  34      -4.017  21.247  -4.829  1.00 73.88           O  
ATOM    310  NE2 GLN A  34      -5.377  19.857  -5.944  1.00 79.14           N  
ATOM    311  N   PHE A  35      -2.606  25.290  -7.205  1.00 68.73           N  
ATOM    312  CA  PHE A  35      -1.913  26.557  -7.448  1.00 70.19           C  
ATOM    313  C   PHE A  35      -1.670  26.758  -8.951  1.00 69.93           C  
ATOM    314  O   PHE A  35      -2.030  27.799  -9.487  1.00 68.26           O  
ATOM    315  CB  PHE A  35      -0.604  26.591  -6.644  1.00 72.87           C  
ATOM    316  CG  PHE A  35       0.222  27.817  -6.863  1.00 73.05           C  
ATOM    317  CD1 PHE A  35      -0.147  29.027  -6.280  1.00 79.83           C  
ATOM    318  CD2 PHE A  35       1.393  27.758  -7.628  1.00 82.17           C  
ATOM    319  CE1 PHE A  35       0.623  30.182  -6.470  1.00 78.78           C  
ATOM    320  CE2 PHE A  35       2.183  28.921  -7.826  1.00 84.20           C  
ATOM    321  CZ  PHE A  35       1.796  30.118  -7.239  1.00 75.37           C  
ATOM    322  N   GLY A  36      -1.124  25.728  -9.616  1.00 68.96           N  
ATOM    323  CA  GLY A  36      -0.891  25.739 -11.060  1.00 69.38           C  
ATOM    324  C   GLY A  36      -2.111  26.112 -11.887  1.00 70.68           C  
ATOM    325  O   GLY A  36      -2.028  27.006 -12.747  1.00 73.36           O  
ATOM    326  N   VAL A  37      -3.239  25.454 -11.586  1.00 70.12           N  
ATOM    327  CA  VAL A  37      -4.544  25.715 -12.238  1.00 69.29           C  
ATOM    328  C   VAL A  37      -4.974  27.153 -12.061  1.00 70.10           C  
ATOM    329  O   VAL A  37      -5.436  27.778 -13.015  1.00 72.68           O  
ATOM    330  CB  VAL A  37      -5.692  24.790 -11.680  1.00 70.39           C  
ATOM    331  CG1 VAL A  37      -7.104  25.257 -12.143  1.00 66.67           C  
ATOM    332  CG2 VAL A  37      -5.445  23.358 -12.054  1.00 59.67           C  
ATOM    333  N   ILE A  38      -4.842  27.665 -10.837  1.00 71.56           N  
ATOM    334  CA  ILE A  38      -5.182  29.080 -10.519  1.00 71.87           C  
ATOM    335  C   ILE A  38      -4.319  30.065 -11.344  1.00 69.87           C  
ATOM    336  O   ILE A  38      -4.845  31.029 -11.893  1.00 68.80           O  
ATOM    337  CB  ILE A  38      -5.097  29.354  -8.976  1.00 72.40           C  
ATOM    338  CG1 ILE A  38      -6.269  28.654  -8.270  1.00 71.93           C  
ATOM    339  CG2 ILE A  38      -5.096  30.843  -8.663  1.00 70.95           C  
ATOM    340  CD1 ILE A  38      -6.168  28.647  -6.762  1.00 70.55           C  
ATOM    341  N   GLN A  39      -3.020  29.790 -11.434  1.00 70.61           N  
ATOM    342  CA  GLN A  39      -2.087  30.597 -12.243  1.00 72.91           C  
ATOM    343  C   GLN A  39      -2.505  30.534 -13.721  1.00 72.97           C  
ATOM    344  O   GLN A  39      -2.700  31.582 -14.345  1.00 74.58           O  
ATOM    345  CB  GLN A  39      -0.611  30.154 -12.059  1.00 73.33           C  
ATOM    346  CG  GLN A  39      -0.051  30.342 -10.629  1.00 81.35           C  
ATOM    347  CD  GLN A  39      -0.084  31.800 -10.138  1.00 97.36           C  
ATOM    348  OE1 GLN A  39       0.018  32.739 -10.931  1.00112.93           O  
ATOM    349  NE2 GLN A  39      -0.214  31.989  -8.826  1.00100.94           N  
ATOM    350  N   VAL A  40      -2.697  29.316 -14.251  1.00 73.37           N  
ATOM    351  CA  VAL A  40      -3.139  29.141 -15.651  1.00 72.75           C  
ATOM    352  C   VAL A  40      -4.454  29.888 -15.930  1.00 72.87           C  
ATOM    353  O   VAL A  40      -4.519  30.665 -16.886  1.00 74.77           O  
ATOM    354  CB  VAL A  40      -3.298  27.655 -16.041  1.00 73.62           C  
ATOM    355  CG1 VAL A  40      -4.084  27.502 -17.377  1.00 72.06           C  
ATOM    356  CG2 VAL A  40      -1.926  26.965 -16.090  1.00 73.56           C  
ATOM    357  N   LEU A  41      -5.465  29.682 -15.076  1.00 72.62           N  
ATOM    358  CA  LEU A  41      -6.791  30.324 -15.250  1.00 72.27           C  
ATOM    359  C   LEU A  41      -6.849  31.835 -15.012  1.00 72.64           C  
ATOM    360  O   LEU A  41      -7.840  32.464 -15.395  1.00 73.35           O  
ATOM    361  CB  LEU A  41      -7.865  29.633 -14.388  1.00 72.17           C  
ATOM    362  CG  LEU A  41      -8.313  28.209 -14.738  1.00 73.75           C  
ATOM    363  CD1 LEU A  41      -9.306  27.755 -13.682  1.00 72.47           C  
ATOM    364  CD2 LEU A  41      -8.932  28.094 -16.136  1.00 72.90           C  
ATOM    365  N   ALA A  42      -5.857  32.412 -14.331  1.00 73.35           N  
ATOM    366  CA  ALA A  42      -5.825  33.872 -14.138  1.00 74.45           C  
ATOM    367  C   ALA A  42      -5.339  34.543 -15.427  1.00 73.70           C  
ATOM    368  O   ALA A  42      -5.974  35.513 -15.875  1.00 67.73           O  
ATOM    369  CB  ALA A  42      -4.941  34.247 -12.986  1.00 75.77           C  
ATOM    370  N   LYS A  43      -4.239  34.005 -16.007  1.00 74.85           N  
ATOM    371  CA  LYS A  43      -3.609  34.525 -17.263  1.00 77.56           C  
ATOM    372  C   LYS A  43      -4.577  34.443 -18.438  1.00 80.55           C  
ATOM    373  O   LYS A  43      -4.881  35.456 -19.073  1.00 83.37           O  
ATOM    374  CB  LYS A  43      -2.318  33.775 -17.631  1.00 78.49           C  
ATOM    375  CG  LYS A  43      -1.162  33.911 -16.638  1.00 81.41           C  
ATOM    376  N   SER A  44      -5.064  33.237 -18.715  1.00 81.68           N  
ATOM    377  CA  SER A  44      -6.079  33.034 -19.755  1.00 82.40           C  
ATOM    378  C   SER A  44      -7.442  33.342 -19.143  1.00 81.60           C  
ATOM    379  O   SER A  44      -7.591  33.354 -17.926  1.00 82.77           O  
ATOM    380  CB  SER A  44      -6.066  31.582 -20.240  1.00 84.42           C  
ATOM    381  OG  SER A  44      -6.500  30.671 -19.225  1.00 86.51           O  
ATOM    382  N   GLY A  45      -8.449  33.567 -19.964  1.00 79.44           N  
ATOM    383  CA  GLY A  45      -9.784  33.804 -19.432  1.00 79.48           C  
ATOM    384  C   GLY A  45     -10.500  32.473 -19.235  1.00 80.31           C  
ATOM    385  O   GLY A  45      -9.925  31.478 -18.761  1.00 79.09           O  
ATOM    386  N   LYS A  46     -11.768  32.469 -19.629  1.00 79.96           N  
ATOM    387  CA  LYS A  46     -12.606  31.294 -19.607  1.00 80.14           C  
ATOM    388  C   LYS A  46     -12.104  30.406 -20.757  1.00 81.35           C  
ATOM    389  O   LYS A  46     -12.350  30.709 -21.926  1.00 83.58           O  
ATOM    390  CB  LYS A  46     -14.070  31.724 -19.784  1.00 79.43           C  
ATOM    391  CG  LYS A  46     -15.120  30.641 -19.731  1.00 78.38           C  
ATOM    392  CD  LYS A  46     -16.513  31.191 -20.066  1.00 80.80           C  
ATOM    393  CE  LYS A  46     -17.088  32.123 -18.995  1.00 82.72           C  
ATOM    394  NZ  LYS A  46     -18.394  32.731 -19.383  1.00 81.78           N  
ATOM    395  N   VAL A  47     -11.336  29.369 -20.418  1.00 80.93           N  
ATOM    396  CA  VAL A  47     -10.817  28.390 -21.403  1.00 80.52           C  
ATOM    397  C   VAL A  47     -11.584  27.059 -21.303  1.00 80.53           C  
ATOM    398  O   VAL A  47     -12.430  26.874 -20.416  1.00 80.52           O  
ATOM    399  CB  VAL A  47      -9.284  28.147 -21.261  1.00 80.27           C  
ATOM    400  CG1 VAL A  47      -8.500  29.423 -21.616  1.00 78.55           C  
ATOM    401  CG2 VAL A  47      -8.919  27.636 -19.868  1.00 80.37           C  
ATOM    402  N   SER A  48     -11.310  26.164 -22.249  1.00 78.74           N  
ATOM    403  CA  SER A  48     -11.907  24.834 -22.257  1.00 78.12           C  
ATOM    404  C   SER A  48     -11.106  23.910 -21.342  1.00 78.61           C  
ATOM    405  O   SER A  48      -9.939  24.183 -21.023  1.00 78.05           O  
ATOM    406  CB  SER A  48     -11.935  24.244 -23.678  1.00 77.99           C  
ATOM    407  OG  SER A  48     -10.627  23.936 -24.154  1.00 71.84           O  
HETATM  408  N   MSE A  49     -11.746  22.816 -20.936  1.00 79.30           N  
HETATM  409  CA  MSE A  49     -11.083  21.760 -20.167  1.00 81.03           C  
HETATM  410  C   MSE A  49      -9.846  21.235 -20.887  1.00 82.41           C  
HETATM  411  O   MSE A  49      -8.820  21.007 -20.244  1.00 82.35           O  
HETATM  412  CB  MSE A  49     -12.042  20.589 -19.861  1.00 81.23           C  
HETATM  413  CG  MSE A  49     -12.734  20.742 -18.531  1.00 84.36           C  
HETATM  414 SE   MSE A  49     -11.432  20.313 -17.156  0.75 78.26          SE  
HETATM  415  CE  MSE A  49     -11.664  18.369 -17.233  1.00 78.71           C  
ATOM    416  N   SER A  50      -9.956  21.065 -22.209  1.00 83.52           N  
ATOM    417  CA  SER A  50      -8.844  20.612 -23.045  1.00 84.59           C  
ATOM    418  C   SER A  50      -7.732  21.656 -23.029  1.00 84.78           C  
ATOM    419  O   SER A  50      -6.600  21.308 -22.722  1.00 83.69           O  
ATOM    420  CB  SER A  50      -9.303  20.295 -24.479  1.00 84.40           C  
ATOM    421  OG  SER A  50     -10.259  19.249 -24.485  1.00 77.94           O  
ATOM    422  N   LYS A  51      -8.066  22.925 -23.306  1.00 87.79           N  
ATOM    423  CA  LYS A  51      -7.074  24.037 -23.222  1.00 89.44           C  
ATOM    424  C   LYS A  51      -6.341  24.097 -21.890  1.00 89.48           C  
ATOM    425  O   LYS A  51      -5.143  24.356 -21.874  1.00 89.52           O  
ATOM    426  CB  LYS A  51      -7.663  25.439 -23.537  1.00 92.55           C  
ATOM    427  CG  LYS A  51      -7.253  26.015 -24.892  1.00 98.75           C  
ATOM    428  CD  LYS A  51      -5.773  26.456 -24.860  1.00102.31           C  
ATOM    429  CE  LYS A  51      -5.290  26.933 -26.218  1.00104.16           C  
ATOM    430  NZ  LYS A  51      -3.827  27.216 -26.203  1.00106.50           N  
ATOM    431  N   LEU A  52      -7.071  23.865 -20.797  1.00 89.36           N  
ATOM    432  CA  LEU A  52      -6.490  23.830 -19.452  1.00 89.21           C  
ATOM    433  C   LEU A  52      -5.531  22.654 -19.341  1.00 88.60           C  
ATOM    434  O   LEU A  52      -4.420  22.835 -18.879  1.00 89.02           O  
ATOM    435  CB  LEU A  52      -7.578  23.776 -18.360  1.00 89.42           C  
ATOM    436  CG  LEU A  52      -7.145  23.680 -16.891  1.00 87.20           C  
ATOM    437  CD1 LEU A  52      -6.253  24.865 -16.515  1.00 72.95           C  
ATOM    438  CD2 LEU A  52      -8.358  23.584 -15.994  1.00 84.76           C  
ATOM    439  N   ILE A  53      -5.944  21.468 -19.789  1.00 91.34           N  
ATOM    440  CA  ILE A  53      -5.066  20.263 -19.767  1.00 93.19           C  
ATOM    441  C   ILE A  53      -3.764  20.509 -20.573  1.00 96.02           C  
ATOM    442  O   ILE A  53      -2.671  20.168 -20.120  1.00 96.06           O  
ATOM    443  CB  ILE A  53      -5.808  18.990 -20.268  1.00 91.74           C  
ATOM    444  CG1 ILE A  53      -6.911  18.580 -19.281  1.00 93.02           C  
ATOM    445  CG2 ILE A  53      -4.844  17.819 -20.409  1.00 90.23           C  
ATOM    446  CD1 ILE A  53      -8.021  17.722 -19.890  1.00 88.67           C  
ATOM    447  N   GLU A  54      -3.904  21.141 -21.738  1.00 99.39           N  
ATOM    448  CA  GLU A  54      -2.765  21.497 -22.612  1.00101.61           C  
ATOM    449  C   GLU A  54      -1.840  22.534 -21.936  1.00103.94           C  
ATOM    450  O   GLU A  54      -0.617  22.320 -21.852  1.00103.41           O  
ATOM    451  CB  GLU A  54      -3.274  21.980 -23.989  1.00101.88           C  
ATOM    452  CG  GLU A  54      -3.958  20.840 -24.794  1.00102.47           C  
ATOM    453  CD  GLU A  54      -4.803  21.288 -25.997  1.00102.83           C  
ATOM    454  OE1 GLU A  54      -5.086  22.504 -26.183  1.00101.03           O  
ATOM    455  OE2 GLU A  54      -5.208  20.377 -26.756  1.00 98.23           O  
ATOM    456  N   ASN A  55      -2.446  23.614 -21.415  1.00105.44           N  
ATOM    457  CA  ASN A  55      -1.726  24.670 -20.688  1.00106.05           C  
ATOM    458  C   ASN A  55      -1.129  24.232 -19.348  1.00107.41           C  
ATOM    459  O   ASN A  55      -0.319  24.978 -18.791  1.00107.76           O  
ATOM    460  CB  ASN A  55      -2.603  25.914 -20.470  1.00106.39           C  
ATOM    461  CG  ASN A  55      -2.983  26.613 -21.769  1.00106.70           C  
ATOM    462  OD1 ASN A  55      -2.839  26.058 -22.862  1.00110.33           O  
ATOM    463  ND2 ASN A  55      -3.506  27.827 -21.647  1.00103.14           N  
HETATM  464  N   MSE A  56      -1.550  23.082 -18.803  1.00110.07           N  
HETATM  465  CA  MSE A  56      -0.907  22.519 -17.605  1.00112.64           C  
HETATM  466  C   MSE A  56       0.440  21.995 -18.080  1.00115.01           C  
HETATM  467  O   MSE A  56       0.475  21.142 -18.986  1.00117.76           O  
HETATM  468  CB  MSE A  56      -1.705  21.367 -16.939  1.00113.30           C  
HETATM  469  CG  MSE A  56      -2.928  21.765 -16.074  1.00114.85           C  
HETATM  470 SE   MSE A  56      -2.504  22.992 -14.600  0.75118.63          SE  
HETATM  471  CE  MSE A  56      -1.435  21.836 -13.442  1.00121.89           C  
ATOM    472  N   GLY A  57       1.529  22.532 -17.511  1.00116.21           N  
ATOM    473  CA  GLY A  57       2.912  22.100 -17.822  1.00117.41           C  
ATOM    474  C   GLY A  57       3.098  20.603 -17.576  1.00120.16           C  
ATOM    475  O   GLY A  57       3.775  19.905 -18.358  1.00120.21           O  
ATOM    476  N   CYS A  58       2.486  20.143 -16.478  1.00121.82           N  
ATOM    477  CA  CYS A  58       2.394  18.743 -16.096  1.00121.51           C  
ATOM    478  C   CYS A  58       0.919  18.459 -15.724  1.00121.24           C  
ATOM    479  O   CYS A  58       0.379  19.103 -14.817  1.00120.72           O  
ATOM    480  CB  CYS A  58       3.313  18.486 -14.913  1.00122.13           C  
ATOM    481  SG  CYS A  58       3.366  16.782 -14.400  1.00124.23           S  
ATOM    482  N   VAL A  59       0.285  17.519 -16.438  1.00120.90           N  
ATOM    483  CA  VAL A  59      -1.128  17.139 -16.226  1.00119.97           C  
ATOM    484  C   VAL A  59      -1.240  15.955 -15.248  1.00119.67           C  
ATOM    485  O   VAL A  59      -0.597  14.923 -15.488  1.00118.90           O  
ATOM    486  CB  VAL A  59      -1.803  16.696 -17.560  1.00120.10           C  
ATOM    487  CG1 VAL A  59      -3.293  16.386 -17.352  1.00116.65           C  
ATOM    488  CG2 VAL A  59      -1.626  17.758 -18.626  1.00119.49           C  
ATOM    489  N   PRO A  60      -2.065  16.076 -14.170  1.00118.72           N  
ATOM    490  CA  PRO A  60      -2.227  14.933 -13.246  1.00117.61           C  
ATOM    491  C   PRO A  60      -3.078  13.809 -13.838  1.00115.58           C  
ATOM    492  O   PRO A  60      -3.681  13.975 -14.908  1.00116.41           O  
ATOM    493  CB  PRO A  60      -2.936  15.553 -12.031  1.00117.30           C  
ATOM    494  CG  PRO A  60      -3.716  16.663 -12.591  1.00118.52           C  
ATOM    495  CD  PRO A  60      -2.880  17.227 -13.728  1.00118.80           C  
ATOM    496  N   SER A  61      -3.145  12.689 -13.117  1.00113.14           N  
ATOM    497  CA  SER A  61      -3.937  11.515 -13.527  1.00110.39           C  
ATOM    498  C   SER A  61      -5.397  11.539 -13.022  1.00109.17           C  
ATOM    499  O   SER A  61      -6.021  10.477 -12.915  1.00110.50           O  
ATOM    500  CB  SER A  61      -3.239  10.227 -13.056  1.00110.84           C  
ATOM    501  N   ASN A  62      -5.941  12.728 -12.737  1.00107.24           N  
ATOM    502  CA  ASN A  62      -7.322  12.900 -12.237  1.00105.70           C  
ATOM    503  C   ASN A  62      -7.888  14.346 -12.369  1.00103.35           C  
ATOM    504  O   ASN A  62      -8.579  14.829 -11.463  1.00103.91           O  
ATOM    505  CB  ASN A  62      -7.458  12.353 -10.780  1.00106.98           C  
ATOM    506  CG  ASN A  62      -6.590  13.107  -9.722  1.00110.10           C  
ATOM    507  OD1 ASN A  62      -6.778  12.884  -8.525  1.00112.82           O  
ATOM    508  ND2 ASN A  62      -5.661  13.974 -10.153  1.00114.38           N  
HETATM  509  N   MSE A  63      -7.607  15.003 -13.505  1.00 99.57           N  
HETATM  510  CA  MSE A  63      -8.044  16.398 -13.787  1.00 97.42           C  
HETATM  511  C   MSE A  63      -9.502  16.711 -13.516  1.00 92.45           C  
HETATM  512  O   MSE A  63      -9.804  17.691 -12.829  1.00 93.28           O  
HETATM  513  CB  MSE A  63      -7.742  16.822 -15.239  1.00 96.08           C  
HETATM  514  CG  MSE A  63      -6.406  17.490 -15.418  1.00 98.46           C  
HETATM  515 SE   MSE A  63      -6.345  19.287 -14.681  0.75 99.45          SE  
HETATM  516  CE  MSE A  63      -7.681  20.171 -15.779  1.00106.72           C  
ATOM    517  N   THR A  64     -10.386  15.890 -14.072  1.00 87.13           N  
ATOM    518  CA  THR A  64     -11.828  16.077 -13.918  1.00 84.08           C  
ATOM    519  C   THR A  64     -12.277  15.978 -12.449  1.00 82.08           C  
ATOM    520  O   THR A  64     -13.134  16.760 -12.004  1.00 80.60           O  
ATOM    521  CB  THR A  64     -12.614  15.100 -14.825  1.00 83.44           C  
ATOM    522  OG1 THR A  64     -12.187  15.291 -16.179  1.00 80.20           O  
ATOM    523  CG2 THR A  64     -14.121  15.342 -14.735  1.00 80.54           C  
ATOM    524  N   THR A  65     -11.685  15.035 -11.713  1.00 79.96           N  
ATOM    525  CA  THR A  65     -11.975  14.850 -10.285  1.00 79.33           C  
ATOM    526  C   THR A  65     -11.406  16.029  -9.492  1.00 76.96           C  
ATOM    527  O   THR A  65     -12.081  16.612  -8.636  1.00 77.02           O  
ATOM    528  CB  THR A  65     -11.356  13.535  -9.729  1.00 80.25           C  
ATOM    529  OG1 THR A  65     -11.598  12.451 -10.639  1.00 83.51           O  
ATOM    530  CG2 THR A  65     -11.946  13.197  -8.346  1.00 79.95           C  
HETATM  531  N   MSE A  66     -10.163  16.365  -9.814  1.00 74.57           N  
HETATM  532  CA  MSE A  66      -9.415  17.453  -9.179  1.00 72.71           C  
HETATM  533  C   MSE A  66     -10.074  18.843  -9.386  1.00 70.97           C  
HETATM  534  O   MSE A  66     -10.054  19.668  -8.471  1.00 70.06           O  
HETATM  535  CB  MSE A  66      -7.939  17.373  -9.649  1.00 73.31           C  
HETATM  536  CG  MSE A  66      -6.953  18.197  -8.880  1.00 71.96           C  
HETATM  537 SE   MSE A  66      -6.858  19.945  -9.613  0.75 71.65          SE  
HETATM  538  CE  MSE A  66      -5.808  19.582 -11.202  1.00 87.96           C  
ATOM    539  N   ILE A  67     -10.648  19.085 -10.570  1.00 69.23           N  
ATOM    540  CA  ILE A  67     -11.401  20.333 -10.863  1.00 69.84           C  
ATOM    541  C   ILE A  67     -12.730  20.370 -10.113  1.00 69.07           C  
ATOM    542  O   ILE A  67     -13.129  21.422  -9.636  1.00 69.30           O  
ATOM    543  CB  ILE A  67     -11.584  20.595 -12.411  1.00 71.06           C  
ATOM    544  CG1 ILE A  67     -10.400  21.420 -12.959  1.00 73.30           C  
ATOM    545  CG2 ILE A  67     -12.834  21.403 -12.726  1.00 65.59           C  
ATOM    546  CD1 ILE A  67      -9.057  20.770 -12.781  1.00 81.51           C  
ATOM    547  N   GLN A  68     -13.425  19.237 -10.037  1.00 69.70           N  
ATOM    548  CA  GLN A  68     -14.669  19.127  -9.239  1.00 69.27           C  
ATOM    549  C   GLN A  68     -14.474  19.482  -7.761  1.00 67.69           C  
ATOM    550  O   GLN A  68     -15.338  20.118  -7.153  1.00 66.00           O  
ATOM    551  CB  GLN A  68     -15.307  17.727  -9.370  1.00 69.75           C  
ATOM    552  CG  GLN A  68     -16.489  17.710 -10.319  1.00 75.76           C  
ATOM    553  CD  GLN A  68     -17.738  18.380  -9.715  1.00 79.09           C  
ATOM    554  OE1 GLN A  68     -18.110  18.116  -8.571  1.00 80.40           O  
ATOM    555  NE2 GLN A  68     -18.389  19.235 -10.498  1.00 82.96           N  
ATOM    556  N   ARG A  69     -13.336  19.061  -7.215  1.00 68.30           N  
ATOM    557  CA  ARG A  69     -12.924  19.371  -5.847  1.00 67.86           C  
ATOM    558  C   ARG A  69     -12.752  20.888  -5.711  1.00 66.63           C  
ATOM    559  O   ARG A  69     -13.258  21.488  -4.765  1.00 68.24           O  
ATOM    560  CB  ARG A  69     -11.612  18.628  -5.530  1.00 69.55           C  
ATOM    561  CG  ARG A  69     -11.071  18.699  -4.108  1.00 73.26           C  
ATOM    562  CD  ARG A  69     -12.109  18.276  -3.124  1.00 90.40           C  
ATOM    563  NE  ARG A  69     -11.564  17.717  -1.881  1.00 97.63           N  
ATOM    564  CZ  ARG A  69     -11.591  16.423  -1.506  1.00102.79           C  
ATOM    565  NH1 ARG A  69     -12.165  15.453  -2.247  1.00101.81           N  
ATOM    566  NH2 ARG A  69     -11.047  16.084  -0.330  1.00104.61           N  
HETATM  567  N   MSE A  70     -12.063  21.500  -6.679  1.00 64.65           N  
HETATM  568  CA  MSE A  70     -11.899  22.963  -6.738  1.00 61.47           C  
HETATM  569  C   MSE A  70     -13.240  23.680  -6.977  1.00 63.09           C  
HETATM  570  O   MSE A  70     -13.402  24.827  -6.578  1.00 61.48           O  
HETATM  571  CB  MSE A  70     -10.877  23.373  -7.822  1.00 59.75           C  
HETATM  572  CG  MSE A  70      -9.458  22.903  -7.550  1.00 58.31           C  
HETATM  573 SE   MSE A  70      -8.139  23.513  -8.898  0.75 52.81          SE  
HETATM  574  CE  MSE A  70      -7.862  25.374  -8.318  1.00 59.45           C  
ATOM    575  N   LYS A  71     -14.178  23.008  -7.646  1.00 66.06           N  
ATOM    576  CA  LYS A  71     -15.503  23.560  -7.908  1.00 69.52           C  
ATOM    577  C   LYS A  71     -16.310  23.677  -6.599  1.00 70.93           C  
ATOM    578  O   LYS A  71     -16.879  24.743  -6.336  1.00 69.77           O  
ATOM    579  CB  LYS A  71     -16.266  22.736  -8.966  1.00 68.78           C  
ATOM    580  CG  LYS A  71     -17.451  23.467  -9.598  1.00 68.60           C  
ATOM    581  CD  LYS A  71     -18.306  22.526 -10.439  1.00 70.76           C  
ATOM    582  CE  LYS A  71     -19.451  23.252 -11.161  1.00 70.68           C  
ATOM    583  NZ  LYS A  71     -20.288  24.037 -10.252  1.00 75.25           N  
ATOM    584  N   ARG A  72     -16.331  22.603  -5.790  1.00 72.84           N  
ATOM    585  CA  ARG A  72     -17.062  22.594  -4.502  1.00 74.25           C  
ATOM    586  C   ARG A  72     -16.356  23.539  -3.498  1.00 74.17           C  
ATOM    587  O   ARG A  72     -17.037  24.237  -2.739  1.00 74.76           O  
ATOM    588  CB  ARG A  72     -17.266  21.164  -3.918  1.00 75.74           C  
ATOM    589  CG  ARG A  72     -16.146  20.678  -2.988  1.00 79.75           C  
ATOM    590  CD  ARG A  72     -16.273  19.273  -2.399  1.00 79.89           C  
ATOM    591  NE  ARG A  72     -15.396  18.892  -1.248  1.00 85.13           N  
ATOM    592  CZ  ARG A  72     -14.259  19.465  -0.779  1.00 86.04           C  
ATOM    593  NH1 ARG A  72     -13.646  20.521  -1.321  1.00 84.37           N  
ATOM    594  NH2 ARG A  72     -13.661  18.917   0.295  1.00 84.82           N  
ATOM    595  N   ASP A  73     -15.011  23.529  -3.486  1.00 73.24           N  
ATOM    596  CA  ASP A  73     -14.199  24.467  -2.681  1.00 73.26           C  
ATOM    597  C   ASP A  73     -14.444  25.934  -3.011  1.00 72.24           C  
ATOM    598  O   ASP A  73     -14.081  26.798  -2.218  1.00 72.87           O  
ATOM    599  CB  ASP A  73     -12.675  24.217  -2.834  1.00 74.89           C  
ATOM    600  CG  ASP A  73     -12.145  23.143  -1.914  1.00 78.81           C  
ATOM    601  OD1 ASP A  73     -12.625  23.048  -0.762  1.00 87.02           O  
ATOM    602  OD2 ASP A  73     -11.226  22.396  -2.315  1.00 85.43           O  
ATOM    603  N   GLY A  74     -14.977  26.212  -4.202  1.00 71.18           N  
ATOM    604  CA  GLY A  74     -15.354  27.557  -4.609  1.00 70.52           C  
ATOM    605  C   GLY A  74     -14.289  28.372  -5.299  1.00 68.77           C  
ATOM    606  O   GLY A  74     -14.469  29.567  -5.453  1.00 67.64           O  
ATOM    607  N   TYR A  75     -13.206  27.732  -5.738  1.00 69.54           N  
ATOM    608  CA  TYR A  75     -12.128  28.411  -6.450  1.00 69.63           C  
ATOM    609  C   TYR A  75     -12.465  28.603  -7.930  1.00 69.39           C  
ATOM    610  O   TYR A  75     -12.239  29.681  -8.471  1.00 69.32           O  
ATOM    611  CB  TYR A  75     -10.819  27.638  -6.343  1.00 71.56           C  
ATOM    612  CG  TYR A  75     -10.315  27.377  -4.936  1.00 74.45           C  
ATOM    613  CD1 TYR A  75      -9.974  28.432  -4.076  1.00 74.50           C  
ATOM    614  CD2 TYR A  75     -10.115  26.065  -4.478  1.00 78.87           C  
ATOM    615  CE1 TYR A  75      -9.484  28.182  -2.769  1.00 74.78           C  
ATOM    616  CE2 TYR A  75      -9.617  25.806  -3.182  1.00 79.22           C  
ATOM    617  CZ  TYR A  75      -9.308  26.864  -2.336  1.00 76.28           C  
ATOM    618  OH  TYR A  75      -8.827  26.577  -1.083  1.00 74.75           O  
ATOM    619  N   VAL A  76     -12.973  27.548  -8.579  1.00 70.43           N  
ATOM    620  CA  VAL A  76     -13.320  27.555 -10.017  1.00 68.91           C  
ATOM    621  C   VAL A  76     -14.794  27.249 -10.261  1.00 69.12           C  
ATOM    622  O   VAL A  76     -15.467  26.669  -9.406  1.00 69.42           O  
ATOM    623  CB  VAL A  76     -12.482  26.526 -10.830  1.00 69.18           C  
ATOM    624  CG1 VAL A  76     -10.984  26.741 -10.599  1.00 66.28           C  
ATOM    625  CG2 VAL A  76     -12.880  25.078 -10.495  1.00 63.31           C  
HETATM  626  N   MSE A  77     -15.267  27.645 -11.446  1.00 70.16           N  
HETATM  627  CA  MSE A  77     -16.643  27.417 -11.916  1.00 69.50           C  
HETATM  628  C   MSE A  77     -16.598  26.814 -13.324  1.00 69.84           C  
HETATM  629  O   MSE A  77     -15.856  27.304 -14.181  1.00 70.53           O  
HETATM  630  CB  MSE A  77     -17.409  28.735 -11.942  1.00 69.15           C  
HETATM  631  CG  MSE A  77     -18.859  28.648 -12.402  1.00 70.33           C  
HETATM  632 SE   MSE A  77     -19.903  27.317 -11.427  0.75 70.63          SE  
HETATM  633  CE  MSE A  77     -19.881  28.131  -9.634  1.00 69.00           C  
ATOM    634  N   THR A  78     -17.380  25.757 -13.544  1.00 69.35           N  
ATOM    635  CA  THR A  78     -17.461  25.060 -14.834  1.00 69.14           C  
ATOM    636  C   THR A  78     -18.877  25.158 -15.428  1.00 71.10           C  
ATOM    637  O   THR A  78     -19.881  25.177 -14.694  1.00 68.01           O  
ATOM    638  CB  THR A  78     -17.002  23.576 -14.737  1.00 68.66           C  
ATOM    639  OG1 THR A  78     -17.928  22.807 -13.965  1.00 61.87           O  
ATOM    640  CG2 THR A  78     -15.594  23.478 -14.109  1.00 66.21           C  
ATOM    641  N   GLU A  79     -18.929  25.219 -16.759  1.00 74.24           N  
ATOM    642  CA  GLU A  79     -20.180  25.317 -17.510  1.00 77.43           C  
ATOM    643  C   GLU A  79     -20.029  24.743 -18.926  1.00 79.02           C  
ATOM    644  O   GLU A  79     -18.948  24.822 -19.517  1.00 79.15           O  
ATOM    645  CB  GLU A  79     -20.636  26.783 -17.573  1.00 76.95           C  
ATOM    646  CG  GLU A  79     -19.693  27.729 -18.354  1.00 79.52           C  
ATOM    647  CD  GLU A  79     -20.073  29.217 -18.278  1.00 80.07           C  
ATOM    648  OE1 GLU A  79     -20.939  29.622 -17.456  1.00 78.16           O  
ATOM    649  OE2 GLU A  79     -19.467  29.989 -19.056  1.00 83.21           O  
ATOM    650  N   LYS A  80     -21.117  24.181 -19.458  1.00 81.31           N  
ATOM    651  CA  LYS A  80     -21.130  23.639 -20.818  1.00 83.80           C  
ATOM    652  C   LYS A  80     -21.143  24.800 -21.816  1.00 85.25           C  
ATOM    653  O   LYS A  80     -21.879  25.774 -21.620  1.00 84.39           O  
ATOM    654  CB  LYS A  80     -22.350  22.734 -21.043  1.00 82.28           C  
ATOM    655  N   ASN A  81     -20.310  24.703 -22.859  1.00 88.45           N  
ATOM    656  CA  ASN A  81     -20.248  25.713 -23.928  1.00 90.81           C  
ATOM    657  C   ASN A  81     -21.566  25.656 -24.726  1.00 93.06           C  
ATOM    658  O   ASN A  81     -21.879  24.585 -25.274  1.00 93.66           O  
ATOM    659  CB  ASN A  81     -19.055  25.437 -24.862  1.00 90.90           C  
ATOM    660  CG  ASN A  81     -18.925  26.453 -26.008  1.00 90.95           C  
ATOM    661  OD1 ASN A  81     -19.465  27.564 -25.960  1.00 97.72           O  
ATOM    662  ND2 ASN A  81     -18.179  26.069 -27.040  1.00 92.08           N  
ATOM    663  N   PRO A  82     -22.346  26.781 -24.785  1.00 94.50           N  
ATOM    664  CA  PRO A  82     -23.615  26.772 -25.572  1.00 94.51           C  
ATOM    665  C   PRO A  82     -23.486  26.420 -27.079  1.00 95.38           C  
ATOM    666  O   PRO A  82     -24.486  26.029 -27.696  1.00 94.79           O  
ATOM    667  CB  PRO A  82     -24.170  28.190 -25.376  1.00 94.93           C  
ATOM    668  CG  PRO A  82     -23.519  28.685 -24.127  1.00 95.60           C  
ATOM    669  CD  PRO A  82     -22.150  28.088 -24.124  1.00 94.20           C  
ATOM    670  N   ASN A  83     -22.276  26.575 -27.642  1.00 95.71           N  
ATOM    671  CA  ASN A  83     -21.969  26.187 -29.028  1.00 95.11           C  
ATOM    672  C   ASN A  83     -21.822  24.650 -29.132  1.00 94.93           C  
ATOM    673  O   ASN A  83     -22.678  23.995 -29.744  1.00 95.33           O  
ATOM    674  CB  ASN A  83     -20.699  26.903 -29.550  1.00 95.47           C  
ATOM    675  CG  ASN A  83     -20.812  28.436 -29.519  1.00 96.19           C  
ATOM    676  OD1 ASN A  83     -21.829  29.002 -29.103  1.00 93.94           O  
ATOM    677  ND2 ASN A  83     -19.752  29.107 -29.955  1.00 95.32           N  
ATOM    678  N   ASP A  84     -20.768  24.099 -28.504  1.00 93.10           N  
ATOM    679  CA  ASP A  84     -20.454  22.650 -28.497  1.00 92.19           C  
ATOM    680  C   ASP A  84     -20.811  22.034 -27.126  1.00 91.37           C  
ATOM    681  O   ASP A  84     -20.078  22.219 -26.154  1.00 91.64           O  
ATOM    682  CB  ASP A  84     -18.961  22.440 -28.832  1.00 91.70           C  
ATOM    683  CG  ASP A  84     -18.535  20.949 -28.886  1.00 91.87           C  
ATOM    684  OD1 ASP A  84     -19.376  20.037 -29.073  1.00 89.44           O  
ATOM    685  OD2 ASP A  84     -17.319  20.693 -28.761  1.00 83.65           O  
ATOM    686  N   GLN A  85     -21.916  21.284 -27.075  1.00 90.61           N  
ATOM    687  CA  GLN A  85     -22.419  20.634 -25.839  1.00 89.77           C  
ATOM    688  C   GLN A  85     -21.491  19.590 -25.195  1.00 88.66           C  
ATOM    689  O   GLN A  85     -21.581  19.354 -23.990  1.00 88.80           O  
ATOM    690  CB  GLN A  85     -23.792  19.985 -26.089  1.00 90.91           C  
ATOM    691  N   ARG A  86     -20.595  18.993 -25.982  1.00 87.54           N  
ATOM    692  CA  ARG A  86     -19.633  17.991 -25.485  1.00 86.27           C  
ATOM    693  C   ARG A  86     -18.315  18.645 -24.952  1.00 85.52           C  
ATOM    694  O   ARG A  86     -17.318  17.936 -24.727  1.00 85.07           O  
ATOM    695  CB  ARG A  86     -19.372  16.957 -26.611  1.00 87.67           C  
ATOM    696  CG  ARG A  86     -18.855  15.561 -26.183  1.00 87.60           C  
ATOM    697  CD  ARG A  86     -18.955  14.550 -27.332  1.00 84.33           C  
ATOM    698  N   GLU A  87     -18.335  19.976 -24.733  1.00 84.42           N  
ATOM    699  CA  GLU A  87     -17.194  20.788 -24.249  1.00 81.94           C  
ATOM    700  C   GLU A  87     -17.554  21.537 -22.950  1.00 78.28           C  
ATOM    701  O   GLU A  87     -18.640  22.119 -22.852  1.00 76.55           O  
ATOM    702  CB  GLU A  87     -16.812  21.825 -25.315  1.00 82.29           C  
ATOM    703  CG  GLU A  87     -15.487  22.549 -25.067  1.00 84.65           C  
ATOM    704  CD  GLU A  87     -15.193  23.608 -26.113  1.00 85.57           C  
ATOM    705  OE1 GLU A  87     -16.045  24.512 -26.304  1.00 93.83           O  
ATOM    706  OE2 GLU A  87     -14.091  23.554 -26.716  1.00 91.08           O  
ATOM    707  N   THR A  88     -16.617  21.550 -21.998  1.00 75.51           N  
ATOM    708  CA  THR A  88     -16.768  22.207 -20.698  1.00 74.20           C  
ATOM    709  C   THR A  88     -15.809  23.394 -20.613  1.00 72.26           C  
ATOM    710  O   THR A  88     -14.605  23.224 -20.813  1.00 70.63           O  
ATOM    711  CB  THR A  88     -16.443  21.233 -19.546  1.00 72.56           C  
ATOM    712  OG1 THR A  88     -17.271  20.082 -19.656  1.00 72.55           O  
ATOM    713  CG2 THR A  88     -16.691  21.874 -18.186  1.00 69.86           C  
ATOM    714  N   LEU A  89     -16.351  24.580 -20.322  1.00 71.14           N  
ATOM    715  CA  LEU A  89     -15.556  25.810 -20.132  1.00 70.79           C  
ATOM    716  C   LEU A  89     -15.293  25.961 -18.640  1.00 69.07           C  
ATOM    717  O   LEU A  89     -16.195  25.692 -17.842  1.00 67.22           O  
ATOM    718  CB  LEU A  89     -16.312  27.040 -20.638  1.00 71.29           C  
ATOM    719  CG  LEU A  89     -16.663  27.074 -22.129  1.00 74.21           C  
ATOM    720  CD1 LEU A  89     -17.694  28.166 -22.444  1.00 72.34           C  
ATOM    721  CD2 LEU A  89     -15.394  27.216 -22.978  1.00 74.91           C  
ATOM    722  N   VAL A  90     -14.081  26.395 -18.275  1.00 67.61           N  
ATOM    723  CA  VAL A  90     -13.662  26.563 -16.868  1.00 67.34           C  
ATOM    724  C   VAL A  90     -13.090  27.972 -16.630  1.00 67.48           C  
ATOM    725  O   VAL A  90     -12.437  28.547 -17.503  1.00 66.33           O  
ATOM    726  CB  VAL A  90     -12.571  25.533 -16.471  1.00 67.24           C  
ATOM    727  CG1 VAL A  90     -12.388  25.501 -14.955  1.00 64.07           C  
ATOM    728  CG2 VAL A  90     -12.925  24.141 -16.966  1.00 69.67           C  
ATOM    729  N   TYR A  91     -13.323  28.516 -15.440  1.00 68.61           N  
ATOM    730  CA  TYR A  91     -12.840  29.858 -15.085  1.00 68.44           C  
ATOM    731  C   TYR A  91     -12.797  30.082 -13.580  1.00 69.18           C  
ATOM    732  O   TYR A  91     -13.458  29.362 -12.822  1.00 68.63           O  
ATOM    733  CB  TYR A  91     -13.682  30.952 -15.783  1.00 66.38           C  
ATOM    734  CG  TYR A  91     -15.166  30.951 -15.483  1.00 65.84           C  
ATOM    735  CD1 TYR A  91     -16.026  30.028 -16.100  1.00 67.24           C  
ATOM    736  CD2 TYR A  91     -15.736  31.908 -14.624  1.00 62.48           C  
ATOM    737  CE1 TYR A  91     -17.419  30.022 -15.836  1.00 63.03           C  
ATOM    738  CE2 TYR A  91     -17.131  31.921 -14.361  1.00 61.56           C  
ATOM    739  CZ  TYR A  91     -17.964  30.974 -14.970  1.00 66.08           C  
ATOM    740  OH  TYR A  91     -19.327  30.969 -14.727  1.00 66.49           O  
ATOM    741  N   LEU A  92     -11.994  31.066 -13.163  1.00 69.67           N  
ATOM    742  CA  LEU A  92     -11.891  31.445 -11.749  1.00 67.96           C  
ATOM    743  C   LEU A  92     -13.136  32.177 -11.276  1.00 67.08           C  
ATOM    744  O   LEU A  92     -13.718  32.962 -12.019  1.00 65.77           O  
ATOM    745  CB  LEU A  92     -10.680  32.357 -11.481  1.00 68.01           C  
ATOM    746  CG  LEU A  92      -9.283  31.743 -11.505  1.00 67.96           C  
ATOM    747  CD1 LEU A  92      -8.257  32.831 -11.227  1.00 67.13           C  
ATOM    748  CD2 LEU A  92      -9.144  30.617 -10.489  1.00 60.12           C  
ATOM    749  N   THR A  93     -13.521  31.903 -10.030  1.00 67.35           N  
ATOM    750  CA  THR A  93     -14.606  32.601  -9.354  1.00 68.07           C  
ATOM    751  C   THR A  93     -13.949  33.805  -8.658  1.00 69.39           C  
ATOM    752  O   THR A  93     -12.706  33.946  -8.682  1.00 67.73           O  
ATOM    753  CB  THR A  93     -15.272  31.724  -8.274  1.00 67.92           C  
ATOM    754  OG1 THR A  93     -14.314  31.410  -7.251  1.00 68.78           O  
ATOM    755  CG2 THR A  93     -15.833  30.430  -8.880  1.00 68.92           C  
ATOM    756  N   LYS A  94     -14.777  34.649  -8.024  1.00 69.76           N  
ATOM    757  CA  LYS A  94     -14.281  35.813  -7.272  1.00 69.49           C  
ATOM    758  C   LYS A  94     -13.320  35.354  -6.154  1.00 69.44           C  
ATOM    759  O   LYS A  94     -12.223  35.918  -6.014  1.00 68.06           O  
ATOM    760  CB  LYS A  94     -15.437  36.650  -6.724  1.00 68.97           C  
ATOM    761  CG  LYS A  94     -15.014  38.013  -6.170  1.00 70.68           C  
ATOM    762  CD  LYS A  94     -16.244  38.905  -5.917  1.00 70.75           C  
ATOM    763  CE  LYS A  94     -15.882  40.220  -5.245  1.00 71.72           C  
ATOM    764  NZ  LYS A  94     -17.107  41.030  -4.908  1.00 71.91           N  
ATOM    765  N   LYS A  95     -13.721  34.305  -5.418  1.00 69.32           N  
ATOM    766  CA  LYS A  95     -12.899  33.676  -4.359  1.00 69.12           C  
ATOM    767  C   LYS A  95     -11.540  33.184  -4.887  1.00 70.49           C  
ATOM    768  O   LYS A  95     -10.518  33.371  -4.235  1.00 71.40           O  
ATOM    769  CB  LYS A  95     -13.654  32.491  -3.720  1.00 68.79           C  
ATOM    770  CG  LYS A  95     -12.881  31.757  -2.604  1.00 68.80           C  
ATOM    771  CD  LYS A  95     -13.568  30.507  -2.093  1.00 66.79           C  
ATOM    772  CE  LYS A  95     -12.684  29.842  -1.047  1.00 64.46           C  
ATOM    773  NZ  LYS A  95     -13.246  28.616  -0.444  1.00 63.53           N  
ATOM    774  N   GLY A  96     -11.547  32.510  -6.032  1.00 71.33           N  
ATOM    775  CA  GLY A  96     -10.301  32.023  -6.650  1.00 72.94           C  
ATOM    776  C   GLY A  96      -9.394  33.149  -7.138  1.00 73.11           C  
ATOM    777  O   GLY A  96      -8.161  33.020  -7.133  1.00 71.47           O  
ATOM    778  N   GLU A  97     -10.024  34.241  -7.573  1.00 72.98           N  
ATOM    779  CA  GLU A  97      -9.320  35.434  -8.027  1.00 73.61           C  
ATOM    780  C   GLU A  97      -8.590  36.060  -6.811  1.00 72.26           C  
ATOM    781  O   GLU A  97      -7.428  36.466  -6.902  1.00 71.35           O  
ATOM    782  CB  GLU A  97     -10.315  36.446  -8.619  1.00 75.03           C  
ATOM    783  CG  GLU A  97      -9.735  37.338  -9.712  1.00 83.78           C  
ATOM    784  CD  GLU A  97     -10.204  36.940 -11.102  1.00 92.64           C  
ATOM    785  OE1 GLU A  97     -11.370  37.308 -11.421  1.00 92.60           O  
ATOM    786  OE2 GLU A  97      -9.415  36.306 -11.859  1.00 93.82           O  
ATOM    787  N   GLU A  98      -9.317  36.125  -5.689  1.00 72.08           N  
ATOM    788  CA  GLU A  98      -8.828  36.615  -4.397  1.00 71.81           C  
ATOM    789  C   GLU A  98      -7.764  35.672  -3.815  1.00 69.96           C  
ATOM    790  O   GLU A  98      -6.768  36.137  -3.265  1.00 70.83           O  
ATOM    791  CB  GLU A  98     -10.009  36.841  -3.409  1.00 70.97           C  
ATOM    792  CG  GLU A  98     -10.941  38.041  -3.799  1.00 71.12           C  
ATOM    793  CD  GLU A  98     -12.322  38.095  -3.047  1.00 76.68           C  
ATOM    794  OE1 GLU A  98     -12.707  37.113  -2.351  1.00 82.04           O  
ATOM    795  OE2 GLU A  98     -13.036  39.139  -3.162  1.00 78.84           O  
ATOM    796  N   THR A  99      -7.975  34.360  -3.940  1.00 69.50           N  
ATOM    797  CA  THR A  99      -6.996  33.342  -3.484  1.00 69.99           C  
ATOM    798  C   THR A  99      -5.638  33.502  -4.190  1.00 68.98           C  
ATOM    799  O   THR A  99      -4.601  33.362  -3.539  1.00 66.75           O  
ATOM    800  CB  THR A  99      -7.529  31.887  -3.660  1.00 69.08           C  
ATOM    801  OG1 THR A  99      -8.719  31.731  -2.885  1.00 65.11           O  
ATOM    802  CG2 THR A  99      -6.505  30.841  -3.204  1.00 68.38           C  
ATOM    803  N   LYS A 100      -5.656  33.813  -5.494  1.00 70.13           N  
ATOM    804  CA  LYS A 100      -4.422  34.059  -6.255  1.00 71.58           C  
ATOM    805  C   LYS A 100      -3.621  35.227  -5.662  1.00 70.78           C  
ATOM    806  O   LYS A 100      -2.410  35.103  -5.478  1.00 70.13           O  
ATOM    807  CB  LYS A 100      -4.702  34.375  -7.716  1.00 72.31           C  
ATOM    808  CG  LYS A 100      -3.412  34.451  -8.557  1.00 74.27           C  
ATOM    809  CD  LYS A 100      -3.654  35.104  -9.889  1.00 78.76           C  
ATOM    810  CE  LYS A 100      -2.345  35.279 -10.664  1.00 87.01           C  
ATOM    811  NZ  LYS A 100      -1.455  36.339 -10.093  1.00 85.71           N  
ATOM    812  N   LYS A 101      -4.312  36.341  -5.396  1.00 69.33           N  
ATOM    813  CA  LYS A 101      -3.718  37.546  -4.808  1.00 68.49           C  
ATOM    814  C   LYS A 101      -2.975  37.222  -3.512  1.00 68.75           C  
ATOM    815  O   LYS A 101      -1.801  37.603  -3.346  1.00 68.20           O  
ATOM    816  CB  LYS A 101      -4.795  38.613  -4.545  1.00 65.77           C  
ATOM    817  N   GLN A 102      -3.655  36.498  -2.621  1.00 68.18           N  
ATOM    818  CA  GLN A 102      -3.084  36.112  -1.332  1.00 69.25           C  
ATOM    819  C   GLN A 102      -1.906  35.126  -1.440  1.00 70.33           C  
ATOM    820  O   GLN A 102      -0.937  35.262  -0.691  1.00 71.60           O  
ATOM    821  CB  GLN A 102      -4.173  35.583  -0.385  1.00 68.92           C  
ATOM    822  CG  GLN A 102      -5.167  36.667   0.072  1.00 68.73           C  
ATOM    823  CD  GLN A 102      -6.425  36.137   0.771  1.00 70.61           C  
ATOM    824  OE1 GLN A 102      -6.676  34.933   0.845  1.00 77.22           O  
ATOM    825  NE2 GLN A 102      -7.236  37.059   1.267  1.00 72.73           N  
ATOM    826  N   VAL A 103      -1.973  34.174  -2.375  1.00 69.96           N  
ATOM    827  CA  VAL A 103      -0.898  33.174  -2.561  1.00 71.56           C  
ATOM    828  C   VAL A 103       0.366  33.757  -3.253  1.00 73.20           C  
ATOM    829  O   VAL A 103       1.481  33.300  -2.974  1.00 72.95           O  
ATOM    830  CB  VAL A 103      -1.388  31.896  -3.316  1.00 69.68           C  
ATOM    831  CG1 VAL A 103      -0.327  30.853  -3.299  1.00 74.83           C  
ATOM    832  CG2 VAL A 103      -2.578  31.296  -2.645  1.00 72.31           C  
ATOM    833  N   ASP A 104       0.187  34.748  -4.142  1.00 73.93           N  
ATOM    834  CA  ASP A 104       1.304  35.429  -4.846  1.00 73.33           C  
ATOM    835  C   ASP A 104       2.344  36.019  -3.889  1.00 73.27           C  
ATOM    836  O   ASP A 104       3.517  36.084  -4.237  1.00 73.21           O  
ATOM    837  CB  ASP A 104       0.790  36.545  -5.791  1.00 74.77           C  
ATOM    838  CG  ASP A 104       0.145  36.013  -7.102  1.00 78.40           C  
ATOM    839  OD1 ASP A 104       0.366  34.855  -7.523  1.00 78.17           O  
ATOM    840  OD2 ASP A 104      -0.584  36.803  -7.737  1.00 83.90           O  
ATOM    841  N   VAL A 105       1.901  36.434  -2.698  1.00 72.48           N  
ATOM    842  CA  VAL A 105       2.779  36.954  -1.644  1.00 71.20           C  
ATOM    843  C   VAL A 105       3.697  35.835  -1.129  1.00 72.64           C  
ATOM    844  O   VAL A 105       4.904  36.051  -1.011  1.00 73.86           O  
ATOM    845  CB  VAL A 105       1.977  37.591  -0.472  1.00 71.07           C  
ATOM    846  CG1 VAL A 105       2.920  38.153   0.589  1.00 70.74           C  
ATOM    847  CG2 VAL A 105       1.066  38.692  -0.988  1.00 63.39           C  
ATOM    848  N   GLN A 106       3.137  34.649  -0.846  1.00 72.95           N  
ATOM    849  CA  GLN A 106       3.946  33.485  -0.396  1.00 72.60           C  
ATOM    850  C   GLN A 106       4.831  32.920  -1.509  1.00 72.02           C  
ATOM    851  O   GLN A 106       5.917  32.440  -1.222  1.00 71.60           O  
ATOM    852  CB  GLN A 106       3.108  32.347   0.224  1.00 72.88           C  
ATOM    853  CG  GLN A 106       2.928  32.419   1.760  1.00 76.67           C  
ATOM    854  CD  GLN A 106       2.059  33.563   2.266  1.00 74.61           C  
ATOM    855  OE1 GLN A 106       2.229  34.015   3.395  1.00 87.65           O  
ATOM    856  NE2 GLN A 106       1.137  34.033   1.448  1.00 68.30           N  
ATOM    857  N   TYR A 107       4.337  32.953  -2.751  1.00 73.62           N  
ATOM    858  CA  TYR A 107       5.069  32.491  -3.942  1.00 73.82           C  
ATOM    859  C   TYR A 107       6.309  33.350  -4.194  1.00 74.86           C  
ATOM    860  O   TYR A 107       7.380  32.823  -4.473  1.00 73.33           O  
ATOM    861  CB  TYR A 107       4.163  32.538  -5.165  1.00 74.97           C  
ATOM    862  CG  TYR A 107       4.749  31.913  -6.419  1.00 75.07           C  
ATOM    863  CD1 TYR A 107       5.129  30.564  -6.436  1.00 80.95           C  
ATOM    864  CD2 TYR A 107       4.835  32.632  -7.605  1.00 70.23           C  
ATOM    865  CE1 TYR A 107       5.639  29.960  -7.602  1.00 82.82           C  
ATOM    866  CE2 TYR A 107       5.344  32.040  -8.778  1.00 78.93           C  
ATOM    867  CZ  TYR A 107       5.734  30.710  -8.767  1.00 82.50           C  
ATOM    868  OH  TYR A 107       6.221  30.142  -9.911  1.00 87.20           O  
ATOM    869  N   SER A 108       6.141  34.667  -4.086  1.00 76.23           N  
ATOM    870  CA  SER A 108       7.243  35.628  -4.211  1.00 77.41           C  
ATOM    871  C   SER A 108       8.335  35.314  -3.178  1.00 77.30           C  
ATOM    872  O   SER A 108       9.514  35.273  -3.520  1.00 78.44           O  
ATOM    873  CB  SER A 108       6.730  37.054  -4.047  1.00 75.99           C  
ATOM    874  OG  SER A 108       7.775  38.002  -4.176  1.00 85.49           O  
ATOM    875  N   ASP A 109       7.929  35.064  -1.933  1.00 77.57           N  
ATOM    876  CA  ASP A 109       8.861  34.664  -0.875  1.00 77.43           C  
ATOM    877  C   ASP A 109       9.484  33.303  -1.167  1.00 75.56           C  
ATOM    878  O   ASP A 109      10.637  33.104  -0.848  1.00 74.28           O  
ATOM    879  CB  ASP A 109       8.176  34.608   0.494  1.00 78.25           C  
ATOM    880  CG  ASP A 109       7.743  35.975   1.012  1.00 85.61           C  
ATOM    881  OD1 ASP A 109       8.389  37.005   0.692  1.00 89.43           O  
ATOM    882  OD2 ASP A 109       6.751  36.003   1.780  1.00 89.42           O  
ATOM    883  N   PHE A 110       8.714  32.373  -1.745  1.00 76.82           N  
ATOM    884  CA  PHE A 110       9.223  31.029  -2.111  1.00 77.56           C  
ATOM    885  C   PHE A 110      10.392  31.121  -3.089  1.00 78.82           C  
ATOM    886  O   PHE A 110      11.447  30.542  -2.832  1.00 79.35           O  
ATOM    887  CB  PHE A 110       8.114  30.098  -2.651  1.00 77.27           C  
ATOM    888  CG  PHE A 110       8.636  28.917  -3.468  1.00 74.91           C  
ATOM    889  CD1 PHE A 110       9.182  27.798  -2.837  1.00 69.50           C  
ATOM    890  CD2 PHE A 110       8.577  28.941  -4.864  1.00 62.49           C  
ATOM    891  CE1 PHE A 110       9.663  26.711  -3.580  1.00 73.63           C  
ATOM    892  CE2 PHE A 110       9.060  27.854  -5.624  1.00 74.63           C  
ATOM    893  CZ  PHE A 110       9.607  26.740  -4.976  1.00 72.89           C  
ATOM    894  N   LEU A 111      10.192  31.875  -4.173  1.00 79.93           N  
ATOM    895  CA  LEU A 111      11.219  32.091  -5.208  1.00 80.25           C  
ATOM    896  C   LEU A 111      12.501  32.708  -4.641  1.00 79.52           C  
ATOM    897  O   LEU A 111      13.582  32.264  -4.985  1.00 79.12           O  
ATOM    898  CB  LEU A 111      10.682  32.950  -6.357  1.00 79.34           C  
ATOM    899  CG  LEU A 111       9.538  32.358  -7.193  1.00 78.05           C  
ATOM    900  CD1 LEU A 111       8.949  33.453  -8.102  1.00 75.71           C  
ATOM    901  CD2 LEU A 111       9.964  31.123  -7.974  1.00 72.25           C  
ATOM    902  N   LYS A 112      12.380  33.689  -3.753  1.00 79.99           N  
ATOM    903  CA  LYS A 112      13.557  34.320  -3.132  1.00 81.10           C  
ATOM    904  C   LYS A 112      14.306  33.344  -2.207  1.00 82.50           C  
ATOM    905  O   LYS A 112      15.511  33.104  -2.378  1.00 83.06           O  
ATOM    906  CB  LYS A 112      13.158  35.582  -2.376  1.00 81.00           C  
ATOM    907  CG  LYS A 112      12.599  36.678  -3.281  1.00 85.78           C  
ATOM    908  N   GLU A 113      13.563  32.723  -1.290  1.00 83.38           N  
ATOM    909  CA  GLU A 113      14.122  31.785  -0.295  1.00 82.05           C  
ATOM    910  C   GLU A 113      14.678  30.485  -0.859  1.00 81.62           C  
ATOM    911  O   GLU A 113      15.528  29.864  -0.201  1.00 82.77           O  
ATOM    912  CB  GLU A 113      13.087  31.489   0.806  1.00 82.06           C  
ATOM    913  CG  GLU A 113      12.734  32.751   1.648  1.00 85.70           C  
ATOM    914  CD  GLU A 113      11.439  32.635   2.474  1.00 86.87           C  
ATOM    915  OE1 GLU A 113      11.031  31.513   2.858  1.00 95.47           O  
ATOM    916  OE2 GLU A 113      10.834  33.698   2.758  1.00 98.74           O  
ATOM    917  N   ASN A 114      14.222  30.090  -2.059  1.00 79.13           N  
ATOM    918  CA  ASN A 114      14.621  28.835  -2.706  1.00 77.38           C  
ATOM    919  C   ASN A 114      15.418  28.949  -4.021  1.00 77.27           C  
ATOM    920  O   ASN A 114      16.169  28.019  -4.332  1.00 75.41           O  
ATOM    921  CB  ASN A 114      13.397  27.944  -2.949  1.00 75.10           C  
ATOM    922  CG  ASN A 114      12.750  27.460  -1.660  1.00 76.70           C  
ATOM    923  OD1 ASN A 114      12.925  26.300  -1.280  1.00 72.44           O  
ATOM    924  ND2 ASN A 114      12.011  28.343  -0.977  1.00 67.85           N  
ATOM    925  N   CYS A 115      15.226  30.029  -4.795  1.00 76.45           N  
ATOM    926  CA  CYS A 115      15.958  30.265  -6.060  1.00 76.39           C  
ATOM    927  C   CYS A 115      16.916  31.457  -5.993  1.00 77.85           C  
ATOM    928  O   CYS A 115      17.240  32.050  -7.030  1.00 81.77           O  
ATOM    929  CB  CYS A 115      14.974  30.443  -7.220  1.00 75.50           C  
ATOM    930  SG  CYS A 115      13.872  29.046  -7.471  1.00 80.92           S  
ATOM    931  N   GLY A 116      17.376  31.809  -4.791  1.00 77.03           N  
ATOM    932  CA  GLY A 116      18.258  32.962  -4.601  1.00 77.49           C  
ATOM    933  C   GLY A 116      19.624  32.616  -4.054  1.00 78.09           C  
ATOM    934  O   GLY A 116      20.329  33.512  -3.637  1.00 80.11           O  
ATOM    935  N   CYS A 117      20.014  31.338  -4.098  1.00 77.17           N  
ATOM    936  CA  CYS A 117      21.273  30.874  -3.508  1.00 76.43           C  
ATOM    937  C   CYS A 117      22.534  31.088  -4.336  1.00 76.59           C  
ATOM    938  O   CYS A 117      23.633  30.958  -3.789  1.00 76.81           O  
ATOM    939  CB  CYS A 117      21.167  29.389  -3.176  1.00 74.48           C  
ATOM    940  SG  CYS A 117      20.625  28.396  -4.564  1.00 79.52           S  
ATOM    941  N   PHE A 118      22.389  31.414  -5.624  1.00 75.27           N  
ATOM    942  CA  PHE A 118      23.533  31.599  -6.516  1.00 73.81           C  
ATOM    943  C   PHE A 118      24.021  33.045  -6.542  1.00 73.59           C  
ATOM    944  O   PHE A 118      23.274  33.976  -6.246  1.00 74.43           O  
ATOM    945  CB  PHE A 118      23.171  31.156  -7.938  1.00 72.31           C  
ATOM    946  CG  PHE A 118      22.765  29.726  -8.023  1.00 73.52           C  
ATOM    947  CD1 PHE A 118      23.723  28.716  -7.863  1.00 76.67           C  
ATOM    948  CD2 PHE A 118      21.434  29.367  -8.247  1.00 68.59           C  
ATOM    949  CE1 PHE A 118      23.364  27.363  -7.906  1.00 73.56           C  
ATOM    950  CE2 PHE A 118      21.059  28.007  -8.304  1.00 74.90           C  
ATOM    951  CZ  PHE A 118      22.024  27.006  -8.136  1.00 74.88           C  
ATOM    952  N   THR A 119      25.279  33.230  -6.929  1.00 72.70           N  
ATOM    953  CA  THR A 119      25.818  34.580  -7.123  1.00 72.53           C  
ATOM    954  C   THR A 119      25.295  35.057  -8.494  1.00 72.48           C  
ATOM    955  O   THR A 119      24.817  34.255  -9.298  1.00 75.00           O  
ATOM    956  CB  THR A 119      27.375  34.631  -7.066  1.00 69.11           C  
ATOM    957  OG1 THR A 119      27.924  33.976  -8.199  1.00 73.80           O  
ATOM    958  CG2 THR A 119      27.930  33.978  -5.809  1.00 62.97           C  
ATOM    959  N   LYS A 120      25.370  36.355  -8.750  1.00 74.06           N  
ATOM    960  CA  LYS A 120      24.963  36.914 -10.052  1.00 74.72           C  
ATOM    961  C   LYS A 120      25.736  36.281 -11.207  1.00 74.12           C  
ATOM    962  O   LYS A 120      25.152  36.042 -12.265  1.00 76.87           O  
ATOM    963  CB  LYS A 120      25.144  38.437 -10.100  1.00 75.37           C  
ATOM    964  CG  LYS A 120      24.266  39.248  -9.151  1.00 79.64           C  
ATOM    965  CD  LYS A 120      22.819  39.203  -9.566  1.00 86.41           C  
ATOM    966  CE  LYS A 120      21.913  39.974  -8.628  1.00 91.24           C  
ATOM    967  NZ  LYS A 120      20.499  39.472  -8.808  1.00 97.99           N  
ATOM    968  N   GLU A 121      27.025  35.993 -10.996  1.00 72.16           N  
ATOM    969  CA  GLU A 121      27.849  35.341 -12.016  1.00 70.97           C  
ATOM    970  C   GLU A 121      27.326  33.931 -12.324  1.00 70.08           C  
ATOM    971  O   GLU A 121      27.156  33.582 -13.493  1.00 69.51           O  
ATOM    972  CB  GLU A 121      29.326  35.287 -11.618  1.00 68.82           C  
ATOM    973  CG  GLU A 121      30.204  34.853 -12.793  1.00 69.67           C  
ATOM    974  CD  GLU A 121      31.692  34.924 -12.555  1.00 71.73           C  
ATOM    975  OE1 GLU A 121      32.159  35.546 -11.569  1.00 76.99           O  
ATOM    976  OE2 GLU A 121      32.404  34.363 -13.408  1.00 72.65           O  
ATOM    977  N   GLU A 122      27.081  33.158 -11.267  1.00 70.37           N  
ATOM    978  CA  GLU A 122      26.545  31.803 -11.356  1.00 73.14           C  
ATOM    979  C   GLU A 122      25.169  31.743 -12.032  1.00 74.83           C  
ATOM    980  O   GLU A 122      24.916  30.814 -12.811  1.00 77.67           O  
ATOM    981  CB  GLU A 122      26.474  31.159  -9.966  1.00 73.42           C  
ATOM    982  CG  GLU A 122      27.838  30.892  -9.321  1.00 70.46           C  
ATOM    983  CD  GLU A 122      27.735  30.321  -7.912  1.00 73.12           C  
ATOM    984  OE1 GLU A 122      26.803  30.674  -7.161  1.00 70.30           O  
ATOM    985  OE2 GLU A 122      28.606  29.504  -7.544  1.00 75.06           O  
ATOM    986  N   GLU A 123      24.288  32.701 -11.710  1.00 75.60           N  
ATOM    987  CA  GLU A 123      22.946  32.823 -12.347  1.00 75.60           C  
ATOM    988  C   GLU A 123      23.052  32.877 -13.875  1.00 74.74           C  
ATOM    989  O   GLU A 123      22.324  32.176 -14.570  1.00 72.20           O  
ATOM    990  CB  GLU A 123      22.191  34.076 -11.849  1.00 76.39           C  
ATOM    991  CG  GLU A 123      21.475  33.899 -10.499  1.00 76.37           C  
ATOM    992  CD  GLU A 123      20.942  35.214  -9.885  1.00 78.57           C  
ATOM    993  OE1 GLU A 123      21.123  36.334 -10.454  1.00 80.37           O  
ATOM    994  OE2 GLU A 123      20.361  35.117  -8.780  1.00 84.74           O  
ATOM    995  N   GLY A 124      23.960  33.725 -14.373  1.00 75.71           N  
ATOM    996  CA  GLY A 124      24.241  33.854 -15.821  1.00 74.43           C  
ATOM    997  C   GLY A 124      24.743  32.561 -16.460  1.00 73.20           C  
ATOM    998  O   GLY A 124      24.350  32.228 -17.588  1.00 74.70           O  
ATOM    999  N   ILE A 125      25.591  31.829 -15.729  1.00 68.69           N  
ATOM   1000  CA  ILE A 125      26.160  30.564 -16.206  1.00 68.02           C  
ATOM   1001  C   ILE A 125      25.055  29.511 -16.241  1.00 68.53           C  
ATOM   1002  O   ILE A 125      24.870  28.845 -17.252  1.00 67.59           O  
ATOM   1003  CB  ILE A 125      27.384  30.111 -15.339  1.00 66.54           C  
ATOM   1004  CG1 ILE A 125      28.536  31.098 -15.505  1.00 65.37           C  
ATOM   1005  CG2 ILE A 125      27.892  28.735 -15.747  1.00 64.98           C  
ATOM   1006  CD1 ILE A 125      29.669  30.892 -14.515  1.00 70.08           C  
ATOM   1007  N   LEU A 126      24.321  29.397 -15.137  1.00 69.77           N  
ATOM   1008  CA  LEU A 126      23.178  28.473 -15.017  1.00 73.00           C  
ATOM   1009  C   LEU A 126      22.088  28.732 -16.085  1.00 73.39           C  
ATOM   1010  O   LEU A 126      21.581  27.786 -16.690  1.00 75.31           O  
ATOM   1011  CB  LEU A 126      22.600  28.541 -13.582  1.00 72.04           C  
ATOM   1012  CG  LEU A 126      21.604  27.485 -13.106  1.00 69.92           C  
ATOM   1013  CD1 LEU A 126      22.055  26.067 -13.344  1.00 65.47           C  
ATOM   1014  CD2 LEU A 126      21.379  27.725 -11.636  1.00 73.99           C  
ATOM   1015  N   GLU A 127      21.766  30.002 -16.327  1.00 73.93           N  
ATOM   1016  CA  GLU A 127      20.800  30.396 -17.355  1.00 75.84           C  
ATOM   1017  C   GLU A 127      21.234  29.876 -18.723  1.00 75.55           C  
ATOM   1018  O   GLU A 127      20.444  29.212 -19.392  1.00 78.11           O  
ATOM   1019  CB  GLU A 127      20.638  31.931 -17.427  1.00 76.88           C  
ATOM   1020  CG  GLU A 127      19.438  32.398 -18.278  1.00 78.72           C  
ATOM   1021  CD  GLU A 127      19.515  33.847 -18.757  1.00 83.23           C  
ATOM   1022  OE1 GLU A 127      20.387  34.638 -18.315  1.00 95.74           O  
ATOM   1023  OE2 GLU A 127      18.679  34.193 -19.620  1.00103.08           O  
ATOM   1024  N   ASP A 128      22.478  30.175 -19.122  1.00 75.85           N  
ATOM   1025  CA  ASP A 128      23.054  29.704 -20.403  1.00 74.90           C  
ATOM   1026  C   ASP A 128      22.945  28.178 -20.574  1.00 74.27           C  
ATOM   1027  O   ASP A 128      22.476  27.689 -21.612  1.00 73.59           O  
ATOM   1028  CB  ASP A 128      24.545  30.073 -20.523  1.00 76.53           C  
ATOM   1029  CG  ASP A 128      24.807  31.572 -20.799  1.00 79.74           C  
ATOM   1030  OD1 ASP A 128      23.871  32.362 -21.066  1.00 79.88           O  
ATOM   1031  OD2 ASP A 128      26.007  31.947 -20.768  1.00 78.39           O  
ATOM   1032  N   LEU A 129      23.388  27.447 -19.547  1.00 72.46           N  
ATOM   1033  CA  LEU A 129      23.395  25.990 -19.560  1.00 72.15           C  
ATOM   1034  C   LEU A 129      21.988  25.399 -19.670  1.00 73.92           C  
ATOM   1035  O   LEU A 129      21.772  24.474 -20.475  1.00 73.16           O  
ATOM   1036  CB  LEU A 129      24.121  25.426 -18.324  1.00 72.79           C  
ATOM   1037  CG  LEU A 129      25.651  25.590 -18.280  1.00 71.81           C  
ATOM   1038  CD1 LEU A 129      26.213  25.353 -16.868  1.00 67.55           C  
ATOM   1039  CD2 LEU A 129      26.311  24.673 -19.314  1.00 64.32           C  
ATOM   1040  N   LEU A 130      21.043  25.928 -18.878  1.00 73.62           N  
ATOM   1041  CA  LEU A 130      19.644  25.445 -18.915  1.00 71.75           C  
ATOM   1042  C   LEU A 130      18.953  25.767 -20.258  1.00 70.85           C  
ATOM   1043  O   LEU A 130      18.171  24.964 -20.731  1.00 70.68           O  
ATOM   1044  CB  LEU A 130      18.830  25.972 -17.735  1.00 70.56           C  
ATOM   1045  CG  LEU A 130      19.178  25.518 -16.312  1.00 68.64           C  
ATOM   1046  CD1 LEU A 130      18.172  26.108 -15.336  1.00 63.40           C  
ATOM   1047  CD2 LEU A 130      19.182  24.047 -16.160  1.00 63.21           C  
ATOM   1048  N   LEU A 131      19.249  26.914 -20.870  1.00 71.90           N  
ATOM   1049  CA  LEU A 131      18.674  27.266 -22.195  1.00 73.60           C  
ATOM   1050  C   LEU A 131      19.255  26.376 -23.297  1.00 72.73           C  
ATOM   1051  O   LEU A 131      18.541  25.982 -24.223  1.00 75.06           O  
ATOM   1052  CB  LEU A 131      18.823  28.766 -22.533  1.00 74.46           C  
ATOM   1053  CG  LEU A 131      17.738  29.716 -21.987  1.00 79.34           C  
ATOM   1054  CD1 LEU A 131      17.341  29.436 -20.528  1.00 83.46           C  
ATOM   1055  CD2 LEU A 131      18.163  31.201 -22.172  1.00 78.60           C  
ATOM   1056  N   LYS A 132      20.548  26.074 -23.193  1.00 71.77           N  
ATOM   1057  CA  LYS A 132      21.215  25.127 -24.096  1.00 71.16           C  
ATOM   1058  C   LYS A 132      20.527  23.772 -24.004  1.00 69.64           C  
ATOM   1059  O   LYS A 132      20.325  23.114 -25.029  1.00 70.70           O  
ATOM   1060  CB  LYS A 132      22.709  24.975 -23.748  1.00 70.80           C  
ATOM   1061  CG  LYS A 132      23.476  23.943 -24.563  1.00 70.05           C  
ATOM   1062  CD  LYS A 132      24.924  23.884 -24.143  1.00 71.79           C  
ATOM   1063  CE  LYS A 132      25.704  22.973 -25.079  1.00 72.66           C  
ATOM   1064  NZ  LYS A 132      27.156  23.038 -24.849  1.00 71.70           N  
ATOM   1065  N   TRP A 133      20.164  23.373 -22.784  1.00 68.78           N  
ATOM   1066  CA  TRP A 133      19.496  22.086 -22.563  1.00 69.65           C  
ATOM   1067  C   TRP A 133      18.085  22.079 -23.193  1.00 71.92           C  
ATOM   1068  O   TRP A 133      17.694  21.074 -23.794  1.00 71.04           O  
ATOM   1069  CB  TRP A 133      19.381  21.760 -21.082  1.00 66.54           C  
ATOM   1070  CG  TRP A 133      19.458  20.301 -20.734  1.00 62.65           C  
ATOM   1071  CD1 TRP A 133      19.318  19.217 -21.564  1.00 65.25           C  
ATOM   1072  CD2 TRP A 133      19.587  19.776 -19.419  1.00 58.08           C  
ATOM   1073  NE1 TRP A 133      19.441  18.058 -20.845  1.00 63.92           N  
ATOM   1074  CE2 TRP A 133      19.593  18.379 -19.521  1.00 63.62           C  
ATOM   1075  CE3 TRP A 133      19.751  20.361 -18.156  1.00 65.67           C  
ATOM   1076  CZ2 TRP A 133      19.730  17.553 -18.410  1.00 64.44           C  
ATOM   1077  CZ3 TRP A 133      19.895  19.528 -17.054  1.00 61.51           C  
ATOM   1078  CH2 TRP A 133      19.868  18.153 -17.190  1.00 62.03           C  
ATOM   1079  N   LYS A 134      17.343  23.195 -23.057  1.00 73.25           N  
ATOM   1080  CA  LYS A 134      16.005  23.321 -23.663  1.00 75.04           C  
ATOM   1081  C   LYS A 134      16.077  23.150 -25.168  1.00 74.47           C  
ATOM   1082  O   LYS A 134      15.394  22.258 -25.696  1.00 74.70           O  
ATOM   1083  CB  LYS A 134      15.292  24.629 -23.313  1.00 75.38           C  
ATOM   1084  CG  LYS A 134      14.748  24.670 -21.913  1.00 80.28           C  
ATOM   1085  CD  LYS A 134      14.216  26.070 -21.505  1.00 84.42           C  
ATOM   1086  CE  LYS A 134      13.002  26.542 -22.344  1.00 93.07           C  
ATOM   1087  NZ  LYS A 134      12.340  27.726 -21.686  1.00 89.91           N  
ATOM   1088  N   LYS A 135      16.935  23.936 -25.840  1.00 74.19           N  
ATOM   1089  CA  LYS A 135      17.099  23.816 -27.312  1.00 76.12           C  
ATOM   1090  C   LYS A 135      17.375  22.379 -27.783  1.00 75.07           C  
ATOM   1091  O   LYS A 135      16.876  21.957 -28.829  1.00 75.96           O  
ATOM   1092  CB  LYS A 135      18.193  24.728 -27.902  1.00 76.13           C  
ATOM   1093  CG  LYS A 135      17.989  26.252 -27.724  1.00 81.38           C  
ATOM   1094  CD  LYS A 135      18.234  27.064 -29.041  1.00 80.37           C  
ATOM   1095  CE  LYS A 135      19.620  26.859 -29.716  1.00 89.77           C  
ATOM   1096  NZ  LYS A 135      19.634  27.348 -31.145  1.00 84.21           N  
ATOM   1097  N   HIS A 136      18.164  21.647 -27.003  1.00 74.36           N  
ATOM   1098  CA  HIS A 136      18.503  20.264 -27.320  1.00 73.95           C  
ATOM   1099  C   HIS A 136      17.296  19.331 -27.224  1.00 74.27           C  
ATOM   1100  O   HIS A 136      17.074  18.529 -28.129  1.00 73.19           O  
ATOM   1101  CB  HIS A 136      19.631  19.782 -26.397  1.00 72.53           C  
ATOM   1102  CG  HIS A 136      20.082  18.385 -26.669  1.00 67.13           C  
ATOM   1103  ND1 HIS A 136      20.726  18.028 -27.831  1.00 60.37           N  
ATOM   1104  CD2 HIS A 136      20.006  17.261 -25.917  1.00 65.43           C  
ATOM   1105  CE1 HIS A 136      21.019  16.739 -27.790  1.00 63.36           C  
ATOM   1106  NE2 HIS A 136      20.602  16.251 -26.636  1.00 67.20           N  
ATOM   1107  N   LEU A 137      16.519  19.476 -26.145  1.00 75.50           N  
ATOM   1108  CA  LEU A 137      15.367  18.593 -25.850  1.00 76.76           C  
ATOM   1109  C   LEU A 137      14.089  18.795 -26.682  1.00 78.52           C  
ATOM   1110  O   LEU A 137      13.331  17.833 -26.861  1.00 79.75           O  
ATOM   1111  CB  LEU A 137      14.991  18.685 -24.363  1.00 75.92           C  
ATOM   1112  CG  LEU A 137      16.018  18.223 -23.351  1.00 74.78           C  
ATOM   1113  CD1 LEU A 137      15.629  18.686 -21.962  1.00 67.07           C  
ATOM   1114  CD2 LEU A 137      16.190  16.705 -23.440  1.00 74.89           C  
ATOM   1115  N   ASN A 138      13.829  20.017 -27.149  1.00 79.71           N  
ATOM   1116  CA  ASN A 138      12.634  20.291 -27.974  1.00 80.90           C  
ATOM   1117  C   ASN A 138      12.957  20.212 -29.467  1.00 82.96           C  
ATOM   1118  O   ASN A 138      12.318  20.824 -30.332  1.00 83.84           O  
ATOM   1119  CB  ASN A 138      11.896  21.583 -27.540  1.00 83.40           C  
ATOM   1120  CG  ASN A 138      12.790  22.817 -27.469  1.00 85.97           C  
ATOM   1121  OD1 ASN A 138      13.677  23.030 -28.308  1.00 88.75           O  
ATOM   1122  ND2 ASN A 138      12.539  23.652 -26.461  1.00 82.37           N  
ATOM   1123  OXT ASN A 138      13.879  19.472 -29.847  1.00 84.17           O  
TER    1124      ASN A 138                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
