
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  114 (  910),  selected  114 , name 1yyv_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 1yyv_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q     9_A      S       1           -
LGA    L    10_A      N       2           -
LGA    R    11_A      A       3           -
LGA    E    12_A      M       4           -
LGA    -       -      L       5           -
LGA    -       -      R       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      D       9           -
LGA    -       -      T      10           -
LGA    -       -      E      11           -
LGA    G    13_A      I      12           #
LGA    N    14_A      C      13          3.561
LGA    L    15_A      I      14          2.420
LGA    F    16_A      D      15          4.786
LGA    A    17_A      -       -           -
LGA    E    18_A      P      16          5.155
LGA    Q    19_A      S      17          2.345
LGA    C    20_A      E      18          2.572
LGA    P    21_A      -       -           -
LGA    S    22_A      S      19          1.155
LGA    R    23_A      -       -           -
LGA    E    24_A      -       -           -
LGA    V    25_A      V      20          1.097
LGA    L    26_A      L      21          1.098
LGA    K    27_A      H      22          2.456
LGA    H    28_A      L      23          1.850
LGA    V    29_A      L      24          2.176
LGA    T    30_A      G      25          3.121
LGA    S    31_A      K      26          2.403
LGA    R    32_A      K      27          2.583
LGA    W    33_A      Y      28          1.725
LGA    G    34_A      T      29          1.060
LGA    V    35_A      M      30          1.188
LGA    L    36_A      L      31          1.348
LGA    I    37_A      I      32          1.104
LGA    L    38_A      I      33          0.794
LGA    V    39_A      S      34          0.765
LGA    A    40_A      V      35          0.707
LGA    L    41_A      L      36          1.418
LGA    R    42_A      G      37          1.380
LGA    D    43_A      N      38          1.869
LGA    -       -      G      39           -
LGA    -       -      S      40           -
LGA    G    44_A      T      41          4.506
LGA    T    45_A      R      42          1.781
LGA    H    46_A      Q      43          1.005
LGA    R    47_A      N      44          0.626
LGA    F    48_A      F      45          0.588
LGA    S    49_A      N      46          0.835
LGA    D    50_A      D      47          0.209
LGA    L    51_A      I      48          0.569
LGA    R    52_A      R      49          1.033
LGA    R    53_A      S      50          0.846
LGA    X    54_A      S      51          1.041
LGA    X    55_A      I      52          1.368
LGA    G    56_A      P      53          2.008
LGA    G    57_A      G      54          1.169
LGA    V    58_A      I      55          1.335
LGA    S    59_A      S      56          1.279
LGA    E    60_A      S      57          1.082
LGA    X    61_A      T      58          1.083
LGA    X    62_A      I      59          0.825
LGA    L    63_A      L      60          0.478
LGA    A    64_A      S      61          0.437
LGA    Q    65_A      R      62          0.389
LGA    S    66_A      R      63          0.438
LGA    L    67_A      I      64          0.483
LGA    Q    68_A      K      65          0.680
LGA    A    69_A      D      66          0.567
LGA    L    70_A      L      67          0.662
LGA    E    71_A      I      68          0.893
LGA    Q    72_A      D      69          1.059
LGA    D    73_A      S      70          0.745
LGA    G    74_A      G      71          0.763
LGA    F    75_A      L      72          0.850
LGA    L    76_A      V      73          1.106
LGA    N    77_A      E      74          1.909
LGA    R    78_A      R      75          0.779
LGA    V    79_A      R      76          0.368
LGA    S    80_A      S      77          1.018
LGA    Y    81_A      G      78          2.679
LGA    P    82_A      Q      79          4.973
LGA    V    83_A      -       -           -
LGA    V    84_A      -       -           -
LGA    P    85_A      -       -           -
LGA    P    86_A      -       -           -
LGA    H    87_A      I      80          3.475
LGA    V    88_A      T      81          1.743
LGA    E    89_A      T      82          0.429
LGA    Y    90_A      Y      83          0.569
LGA    S    91_A      A      84          0.693
LGA    L    92_A      L      85          0.994
LGA    T    93_A      T      86          1.006
LGA    P    94_A      E      87          0.979
LGA    L    95_A      K      88          0.858
LGA    G    96_A      G      89          0.799
LGA    E    97_A      M      90          0.609
LGA    Q    98_A      N      91          0.513
LGA    V    99_A      V      92          0.511
LGA    S   100_A      R      93          0.908
LGA    D   101_A      N      94          1.266
LGA    X   102_A      S      95          1.621
LGA    V   103_A      L      96          1.869
LGA    A   104_A      M      97          1.880
LGA    A   105_A      P      98          1.620
LGA    L   106_A      L      99          1.006
LGA    A   107_A      L     100          1.139
LGA    D   108_A      Q     101          1.158
LGA    W   109_A      Y     102          0.911
LGA    I   110_A      I     103          0.397
LGA    E   111_A      S     104          0.235
LGA    L   112_A      V     105          1.638
LGA    N   113_A      L     106          2.602
LGA    L   114_A      D     107          2.326
LGA    P   115_A      R     108          3.024
LGA    Q   116_A      N     109          3.148
LGA    V   117_A      -       -           -
LGA    L   118_A      -       -           -
LGA    A   119_A      -       -           -
LGA    Q   120_A      -       -           -
LGA    R   121_A      -       -           -
LGA    E   122_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  114  109    5.0     95    1.78    24.21     80.533     5.061

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.851355 * X  +  -0.482210 * Y  +  -0.206563 * Z  +  26.563694
  Y_new =  -0.114628 * X  +  -0.213244 * Y  +   0.970251 * Z  +  -0.374315
  Z_new =  -0.511913 * X  +   0.849706 * Y  +   0.126271 * Z  + -28.901632 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.423270   -1.718323  [ DEG:    81.5474    -98.4526 ]
  Theta =   0.537411    2.604182  [ DEG:    30.7914    149.2086 ]
  Phi   =  -3.007755    0.133838  [ DEG:  -172.3317      7.6683 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yyv_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yyv_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  114  109   5.0   95   1.78   24.21  80.533
REMARK  ---------------------------------------------------------- 
MOLECULE 1yyv_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-FEB-05   1YYV              
TITLE     PUTATIVE TRANSCRIPTIONAL REGULATOR YTFH FROM SALMONELLA               
TITLE    2 TYPHIMURIUM                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE TRANSCRIPTIONAL REGULATOR;                        
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SALMONELLA TYPHIMURIUM;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: LT2;                                                         
SOURCE   5 GENE: YTFH;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    PUTATIVE TRANSCRIPTIONAL REGULATOR, REDUCTIVE METHYLATION,            
KEYWDS   2 DIMETHYL LYSINE, STRUCTURAL GENOMICS, PSI, PROTEIN                   
KEYWDS   3 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   4 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.OSIPIUK,P.QUARTEY,L.LEZONDRA,S.MOY,F.COLLART,A.JOACHIMIAK,          
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   05-APR-05 1YYV    0                                                
JRNL        AUTH   J.OSIPIUK,P.QUARTEY,L.LEZONDRA,S.MOY,F.COLLART,              
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   X-RAY CRYSTAL STRUCTURE OF PUTATIVE                          
JRNL        TITL 2 TRANSCRIPTIONAL REGULATOR YTFH FROM SALMONELLA               
JRNL        TITL 3 TYPHIMURIUM.                                                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.35 ANGSTROMS.                                          
DBREF  1YYV A    1   128  UNP    Q7CP90   Q7CP90_SALTY     1    128             
DBREF  1YYV B    1   128  UNP    Q7CP90   Q7CP90_SALTY     1    128             
SEQRES   1 A  131  SER ASN ALA MSE ARG ALA HIS THR LEU SER ARG GLN LEU          
SEQRES   2 A  131  ARG GLU GLY ASN LEU PHE ALA GLU GLN CYS PRO SER ARG          
SEQRES   3 A  131  GLU VAL LEU LYS HIS VAL THR SER ARG TRP GLY VAL LEU          
SEQRES   4 A  131  ILE LEU VAL ALA LEU ARG ASP GLY THR HIS ARG PHE SER          
SEQRES   5 A  131  ASP LEU ARG ARG MLY MSE GLY GLY VAL SER GLU MLY MSE          
SEQRES   6 A  131  LEU ALA GLN SER LEU GLN ALA LEU GLU GLN ASP GLY PHE          
SEQRES   7 A  131  LEU ASN ARG VAL SER TYR PRO VAL VAL PRO PRO HIS VAL          
SEQRES   8 A  131  GLU TYR SER LEU THR PRO LEU GLY GLU GLN VAL SER ASP          
SEQRES   9 A  131  MLY VAL ALA ALA LEU ALA ASP TRP ILE GLU LEU ASN LEU          
SEQRES  10 A  131  PRO GLN VAL LEU ALA GLN ARG GLU ARG LEU SER ASP GLY          
SEQRES  11 A  131  GLY                                                          
SEQRES   1 B  131  SER ASN ALA MSE ARG ALA HIS THR LEU SER ARG GLN LEU          
SEQRES   2 B  131  ARG GLU GLY ASN LEU PHE ALA GLU GLN CYS PRO SER ARG          
SEQRES   3 B  131  GLU VAL LEU LYS HIS VAL THR SER ARG TRP GLY VAL LEU          
SEQRES   4 B  131  ILE LEU VAL ALA LEU ARG ASP GLY THR HIS ARG PHE SER          
SEQRES   5 B  131  ASP LEU ARG ARG MLY MSE GLY GLY VAL SER GLU MLY MSE          
SEQRES   6 B  131  LEU ALA GLN SER LEU GLN ALA LEU GLU GLN ASP GLY PHE          
SEQRES   7 B  131  LEU ASN ARG VAL SER TYR PRO VAL VAL PRO PRO HIS VAL          
SEQRES   8 B  131  GLU TYR SER LEU THR PRO LEU GLY GLU GLN VAL SER ASP          
SEQRES   9 B  131  MLY VAL ALA ALA LEU ALA ASP TRP ILE GLU LEU ASN LEU          
SEQRES  10 B  131  PRO GLN VAL LEU ALA GLN ARG GLU ARG LEU SER ASP GLY          
SEQRES  11 B  131  GLY                                                          
HET    MLY  A  54      11                                                       
HET    MSE  A  55       8                                                       
HET    MLY  A  61      11                                                       
HET    MSE  A  62       8                                                       
HET    MLY  A 102      11                                                       
HET    MLY  B  54      11                                                       
HET    MSE  B  55       8                                                       
HET    MLY  B  61      11                                                       
HET    MSE  B  62       8                                                       
HET    MLY  B 102      11                                                       
HET     CL    201       1                                                       
HET     CL    202       1                                                       
HETNAM     MLY N-DIMETHYL-LYSINE                                                
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MLY    6(C8 H18 N2 O2)                                              
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   CL    2(CL 1-)                                                     
FORMUL   5  HOH   *74(H2 O)                                                     
CRYST1   79.285   79.285  105.115  90.00  90.00  90.00 P 43 21 2    16          
ATOM      1  N   GLN A   9     -21.818  24.865   9.826  1.00 62.24           N  
ATOM      2  CA  GLN A   9     -21.136  25.689  10.876  1.00 62.52           C  
ATOM      3  C   GLN A   9     -20.617  26.991  10.256  1.00 61.51           C  
ATOM      4  O   GLN A   9     -19.569  26.982   9.610  1.00 61.52           O  
ATOM      5  CB  GLN A   9     -19.965  24.903  11.501  1.00 62.92           C  
ATOM      6  CG  GLN A   9     -19.154  24.087  10.459  1.00 65.70           C  
ATOM      7  CD  GLN A   9     -17.648  23.982  10.765  1.00 71.02           C  
ATOM      8  OE1 GLN A   9     -17.161  22.897  11.146  1.00 72.67           O  
ATOM      9  NE2 GLN A   9     -16.897  25.105  10.584  1.00 68.47           N  
ATOM     10  N   LEU A  10     -21.318  28.113  10.452  1.00 60.18           N  
ATOM     11  CA  LEU A  10     -20.825  29.380   9.858  1.00 58.27           C  
ATOM     12  C   LEU A  10     -19.840  30.197  10.743  1.00 56.06           C  
ATOM     13  O   LEU A  10     -19.972  31.405  11.011  1.00 56.14           O  
ATOM     14  CB  LEU A  10     -21.926  30.191   9.175  1.00 58.59           C  
ATOM     15  CG  LEU A  10     -22.459  29.411   7.941  1.00 60.18           C  
ATOM     16  CD1 LEU A  10     -23.279  30.295   6.954  1.00 59.66           C  
ATOM     17  CD2 LEU A  10     -21.370  28.611   7.174  1.00 60.09           C  
ATOM     18  N   ARG A  11     -18.818  29.476  11.165  1.00 52.31           N  
ATOM     19  CA  ARG A  11     -17.751  30.027  11.936  1.00 49.13           C  
ATOM     20  C   ARG A  11     -16.588  30.380  11.007  1.00 45.67           C  
ATOM     21  O   ARG A  11     -16.498  29.898   9.857  1.00 43.64           O  
ATOM     22  CB  ARG A  11     -17.324  28.987  12.956  1.00 49.39           C  
ATOM     23  CG  ARG A  11     -18.478  28.547  13.791  1.00 54.02           C  
ATOM     24  CD  ARG A  11     -18.255  27.138  14.289  1.00 61.74           C  
ATOM     25  NE  ARG A  11     -17.798  27.134  15.679  1.00 64.99           N  
ATOM     26  CZ  ARG A  11     -18.587  26.904  16.727  1.00 65.37           C  
ATOM     27  NH1 ARG A  11     -19.894  26.640  16.568  1.00 64.58           N  
ATOM     28  NH2 ARG A  11     -18.054  26.927  17.940  1.00 65.31           N  
ATOM     29  N   GLU A  12     -15.719  31.239  11.519  1.00 41.82           N  
ATOM     30  CA  GLU A  12     -14.404  31.425  10.922  1.00 40.34           C  
ATOM     31  C   GLU A  12     -13.551  30.236  11.304  1.00 38.76           C  
ATOM     32  O   GLU A  12     -13.748  29.631  12.363  1.00 38.83           O  
ATOM     33  CB  GLU A  12     -13.794  32.767  11.345  1.00 39.98           C  
ATOM     34  CG  GLU A  12     -14.573  33.954  10.674  1.00 40.42           C  
ATOM     35  CD  GLU A  12     -14.029  35.360  11.005  1.00 40.97           C  
ATOM     36  OE1 GLU A  12     -12.803  35.543  11.207  1.00 41.18           O  
ATOM     37  OE2 GLU A  12     -14.855  36.299  11.051  1.00 43.14           O  
ATOM     38  N   GLY A  13     -12.651  29.844  10.412  1.00 37.59           N  
ATOM     39  CA  GLY A  13     -11.874  28.661  10.649  1.00 35.92           C  
ATOM     40  C   GLY A  13     -10.760  28.822  11.657  1.00 36.14           C  
ATOM     41  O   GLY A  13     -10.281  29.950  11.983  1.00 34.48           O  
ATOM     42  N   ASN A  14     -10.322  27.663  12.131  1.00 35.12           N  
ATOM     43  CA  ASN A  14      -9.120  27.578  12.902  1.00 34.31           C  
ATOM     44  C   ASN A  14      -8.227  26.411  12.394  1.00 34.95           C  
ATOM     45  O   ASN A  14      -8.461  25.259  12.725  1.00 35.28           O  
ATOM     46  CB  ASN A  14      -9.493  27.456  14.366  1.00 33.33           C  
ATOM     47  CG  ASN A  14      -8.282  27.345  15.270  1.00 32.68           C  
ATOM     48  OD1 ASN A  14      -7.149  27.533  14.852  1.00 31.23           O  
ATOM     49  ND2 ASN A  14      -8.523  27.018  16.500  1.00 29.41           N  
ATOM     50  N   LEU A  15      -7.213  26.725  11.580  1.00 34.58           N  
ATOM     51  CA  LEU A  15      -6.295  25.716  11.057  1.00 33.74           C  
ATOM     52  C   LEU A  15      -5.575  24.864  12.119  1.00 33.59           C  
ATOM     53  O   LEU A  15      -5.163  23.738  11.818  1.00 34.52           O  
ATOM     54  CB  LEU A  15      -5.288  26.366  10.117  1.00 33.04           C  
ATOM     55  CG  LEU A  15      -5.956  26.785   8.815  1.00 34.19           C  
ATOM     56  CD1 LEU A  15      -5.131  27.926   8.129  1.00 35.42           C  
ATOM     57  CD2 LEU A  15      -6.148  25.594   7.875  1.00 29.15           C  
ATOM     58  N   PHE A  16      -5.425  25.395  13.332  1.00 32.94           N  
ATOM     59  CA  PHE A  16      -4.812  24.678  14.447  1.00 33.59           C  
ATOM     60  C   PHE A  16      -5.769  23.613  15.038  1.00 34.11           C  
ATOM     61  O   PHE A  16      -5.325  22.735  15.779  1.00 34.29           O  
ATOM     62  CB  PHE A  16      -4.326  25.669  15.551  1.00 33.88           C  
ATOM     63  CG  PHE A  16      -3.111  26.531  15.136  1.00 34.37           C  
ATOM     64  CD1 PHE A  16      -1.791  26.081  15.376  1.00 32.12           C  
ATOM     65  CD2 PHE A  16      -3.290  27.764  14.497  1.00 35.78           C  
ATOM     66  CE1 PHE A  16      -0.670  26.836  14.978  1.00 35.27           C  
ATOM     67  CE2 PHE A  16      -2.178  28.547  14.096  1.00 35.87           C  
ATOM     68  CZ  PHE A  16      -0.849  28.070  14.340  1.00 35.27           C  
ATOM     69  N   ALA A  17      -7.059  23.664  14.690  1.00 34.61           N  
ATOM     70  CA  ALA A  17      -8.023  22.709  15.224  1.00 37.16           C  
ATOM     71  C   ALA A  17      -8.115  21.463  14.354  1.00 38.53           C  
ATOM     72  O   ALA A  17      -8.367  21.507  13.135  1.00 38.84           O  
ATOM     73  CB  ALA A  17      -9.419  23.344  15.447  1.00 35.75           C  
ATOM     74  N   GLU A  18      -7.859  20.347  14.993  1.00 40.24           N  
ATOM     75  CA  GLU A  18      -8.061  19.040  14.384  1.00 43.80           C  
ATOM     76  C   GLU A  18      -9.465  19.000  13.749  1.00 43.49           C  
ATOM     77  O   GLU A  18     -10.452  19.331  14.378  1.00 43.85           O  
ATOM     78  CB  GLU A  18      -7.850  17.969  15.480  1.00 42.77           C  
ATOM     79  CG  GLU A  18      -8.074  16.519  15.045  1.00 46.64           C  
ATOM     80  CD  GLU A  18      -7.373  15.539  16.028  1.00 47.08           C  
ATOM     81  OE1 GLU A  18      -7.084  15.915  17.194  1.00 52.91           O  
ATOM     82  OE2 GLU A  18      -7.067  14.401  15.615  1.00 50.26           O  
ATOM     83  N   GLN A  19      -9.523  18.675  12.477  1.00 44.74           N  
ATOM     84  CA  GLN A  19     -10.789  18.588  11.724  1.00 46.07           C  
ATOM     85  C   GLN A  19     -11.639  19.864  11.455  1.00 45.00           C  
ATOM     86  O   GLN A  19     -12.834  19.747  11.148  1.00 44.85           O  
ATOM     87  CB  GLN A  19     -11.669  17.419  12.225  1.00 47.74           C  
ATOM     88  CG  GLN A  19     -12.500  17.693  13.462  1.00 52.07           C  
ATOM     89  CD  GLN A  19     -12.847  16.408  14.171  1.00 58.81           C  
ATOM     90  OE1 GLN A  19     -11.952  15.619  14.506  1.00 62.78           O  
ATOM     91  NE2 GLN A  19     -14.150  16.172  14.392  1.00 59.48           N  
ATOM     92  N   CYS A  20     -11.034  21.057  11.528  1.00 42.64           N  
ATOM     93  CA  CYS A  20     -11.683  22.234  10.978  1.00 41.28           C  
ATOM     94  C   CYS A  20     -11.654  22.100   9.446  1.00 40.09           C  
ATOM     95  O   CYS A  20     -10.627  21.777   8.881  1.00 40.78           O  
ATOM     96  CB  CYS A  20     -11.000  23.543  11.445  1.00 40.84           C  
ATOM     97  SG  CYS A  20     -11.721  25.042  10.649  1.00 40.16           S  
ATOM     98  N   PRO A  21     -12.773  22.362   8.761  1.00 39.33           N  
ATOM     99  CA  PRO A  21     -12.741  22.259   7.280  1.00 38.63           C  
ATOM    100  C   PRO A  21     -11.795  23.247   6.544  1.00 38.53           C  
ATOM    101  O   PRO A  21     -11.584  23.122   5.325  1.00 39.20           O  
ATOM    102  CB  PRO A  21     -14.210  22.509   6.873  1.00 38.73           C  
ATOM    103  CG  PRO A  21     -15.025  22.302   8.139  1.00 38.82           C  
ATOM    104  CD  PRO A  21     -14.107  22.754   9.262  1.00 39.28           C  
ATOM    105  N   SER A  22     -11.238  24.228   7.245  1.00 37.10           N  
ATOM    106  CA  SER A  22     -10.273  25.131   6.603  1.00 36.59           C  
ATOM    107  C   SER A  22      -9.024  24.371   6.155  1.00 36.36           C  
ATOM    108  O   SER A  22      -8.333  24.789   5.208  1.00 35.39           O  
ATOM    109  CB  SER A  22      -9.886  26.290   7.547  1.00 36.01           C  
ATOM    110  OG  SER A  22      -9.420  25.783   8.792  1.00 35.76           O  
ATOM    111  N   ARG A  23      -8.721  23.273   6.859  1.00 36.85           N  
ATOM    112  CA  ARG A  23      -7.593  22.386   6.501  1.00 36.89           C  
ATOM    113  C   ARG A  23      -7.785  21.736   5.115  1.00 37.52           C  
ATOM    114  O   ARG A  23      -6.849  21.590   4.355  1.00 37.97           O  
ATOM    115  CB  ARG A  23      -7.426  21.330   7.556  1.00 36.91           C  
ATOM    116  CG  ARG A  23      -6.763  21.853   8.799  1.00 35.75           C  
ATOM    117  CD  ARG A  23      -6.622  20.757   9.849  1.00 32.84           C  
ATOM    118  NE  ARG A  23      -5.889  21.283  11.003  1.00 34.25           N  
ATOM    119  CZ  ARG A  23      -5.353  20.532  11.957  1.00 33.93           C  
ATOM    120  NH1 ARG A  23      -5.461  19.210  11.905  1.00 28.74           N  
ATOM    121  NH2 ARG A  23      -4.719  21.103  12.971  1.00 32.58           N  
ATOM    122  N   GLU A  24      -9.020  21.415   4.791  1.00 37.52           N  
ATOM    123  CA  GLU A  24      -9.364  20.883   3.493  1.00 39.98           C  
ATOM    124  C   GLU A  24      -9.277  21.923   2.383  1.00 38.09           C  
ATOM    125  O   GLU A  24      -8.687  21.676   1.345  1.00 38.98           O  
ATOM    126  CB  GLU A  24     -10.783  20.309   3.553  1.00 40.67           C  
ATOM    127  CG  GLU A  24     -10.816  18.982   4.189  1.00 48.06           C  
ATOM    128  CD  GLU A  24      -9.992  17.980   3.388  1.00 59.77           C  
ATOM    129  OE1 GLU A  24      -9.204  17.218   4.012  1.00 64.34           O  
ATOM    130  OE2 GLU A  24     -10.122  17.965   2.127  1.00 64.87           O  
ATOM    131  N   VAL A  25      -9.873  23.084   2.607  1.00 37.32           N  
ATOM    132  CA  VAL A  25      -9.688  24.232   1.710  1.00 36.48           C  
ATOM    133  C   VAL A  25      -8.214  24.535   1.505  1.00 35.98           C  
ATOM    134  O   VAL A  25      -7.782  24.740   0.399  1.00 37.48           O  
ATOM    135  CB  VAL A  25     -10.405  25.477   2.241  1.00 36.36           C  
ATOM    136  CG1 VAL A  25     -10.183  26.705   1.294  1.00 34.40           C  
ATOM    137  CG2 VAL A  25     -11.901  25.141   2.544  1.00 33.59           C  
ATOM    138  N   LEU A  26      -7.432  24.531   2.564  1.00 36.68           N  
ATOM    139  CA  LEU A  26      -5.990  24.772   2.437  1.00 37.13           C  
ATOM    140  C   LEU A  26      -5.296  23.727   1.545  1.00 37.62           C  
ATOM    141  O   LEU A  26      -4.537  24.086   0.689  1.00 35.92           O  
ATOM    142  CB  LEU A  26      -5.343  24.883   3.815  1.00 37.08           C  
ATOM    143  CG  LEU A  26      -3.827  24.806   3.815  1.00 38.01           C  
ATOM    144  CD1 LEU A  26      -3.238  26.158   3.457  1.00 37.84           C  
ATOM    145  CD2 LEU A  26      -3.301  24.266   5.151  1.00 39.26           C  
ATOM    146  N   LYS A  27      -5.601  22.448   1.755  1.00 39.54           N  
ATOM    147  CA  LYS A  27      -5.151  21.373   0.896  1.00 42.34           C  
ATOM    148  C   LYS A  27      -5.555  21.591  -0.595  1.00 42.58           C  
ATOM    149  O   LYS A  27      -4.717  21.492  -1.520  1.00 42.90           O  
ATOM    150  CB  LYS A  27      -5.704  20.022   1.405  1.00 41.65           C  
ATOM    151  CG  LYS A  27      -5.158  18.849   0.584  1.00 45.99           C  
ATOM    152  CD  LYS A  27      -5.704  17.434   0.939  1.00 45.63           C  
ATOM    153  CE  LYS A  27      -4.585  16.551   1.551  1.00 53.44           C  
ATOM    154  NZ  LYS A  27      -4.621  15.018   1.294  1.00 52.44           N  
ATOM    155  N   HIS A  28      -6.825  21.881  -0.845  1.00 41.83           N  
ATOM    156  CA  HIS A  28      -7.241  22.094  -2.240  1.00 41.99           C  
ATOM    157  C   HIS A  28      -6.478  23.208  -2.936  1.00 41.49           C  
ATOM    158  O   HIS A  28      -6.123  23.061  -4.102  1.00 41.05           O  
ATOM    159  CB  HIS A  28      -8.754  22.318  -2.362  1.00 40.88           C  
ATOM    160  CG  HIS A  28      -9.562  21.183  -1.801  1.00 43.16           C  
ATOM    161  ND1 HIS A  28     -10.878  21.321  -1.388  1.00 42.50           N  
ATOM    162  CD2 HIS A  28      -9.228  19.888  -1.575  1.00 40.69           C  
ATOM    163  CE1 HIS A  28     -11.319  20.152  -0.957  1.00 42.55           C  
ATOM    164  NE2 HIS A  28     -10.334  19.276  -1.037  1.00 43.75           N  
ATOM    165  N   VAL A  29      -6.214  24.313  -2.235  1.00 41.37           N  
ATOM    166  CA  VAL A  29      -5.688  25.507  -2.939  1.00 41.22           C  
ATOM    167  C   VAL A  29      -4.166  25.492  -3.006  1.00 42.03           C  
ATOM    168  O   VAL A  29      -3.533  26.304  -3.697  1.00 41.99           O  
ATOM    169  CB  VAL A  29      -6.295  26.881  -2.403  1.00 41.10           C  
ATOM    170  CG1 VAL A  29      -7.812  26.802  -2.298  1.00 37.15           C  
ATOM    171  CG2 VAL A  29      -5.679  27.324  -1.047  1.00 40.44           C  
ATOM    172  N   THR A  30      -3.559  24.573  -2.269  1.00 42.86           N  
ATOM    173  CA  THR A  30      -2.113  24.535  -2.269  1.00 44.42           C  
ATOM    174  C   THR A  30      -1.515  23.191  -2.690  1.00 45.47           C  
ATOM    175  O   THR A  30      -0.282  23.032  -2.641  1.00 44.91           O  
ATOM    176  CB  THR A  30      -1.536  24.984  -0.922  1.00 44.75           C  
ATOM    177  OG1 THR A  30      -2.076  24.167   0.107  1.00 45.34           O  
ATOM    178  CG2 THR A  30      -1.813  26.478  -0.646  1.00 44.98           C  
ATOM    179  N   SER A  31      -2.386  22.243  -3.071  1.00 45.94           N  
ATOM    180  CA  SER A  31      -1.965  21.035  -3.729  1.00 48.12           C  
ATOM    181  C   SER A  31      -1.242  21.478  -4.968  1.00 48.48           C  
ATOM    182  O   SER A  31      -1.399  22.591  -5.425  1.00 48.84           O  
ATOM    183  CB  SER A  31      -3.136  20.113  -4.109  1.00 47.18           C  
ATOM    184  OG  SER A  31      -3.879  20.677  -5.184  1.00 52.08           O  
ATOM    185  N   ARG A  32      -0.434  20.595  -5.507  1.00 49.91           N  
ATOM    186  CA  ARG A  32       0.416  20.953  -6.621  1.00 51.21           C  
ATOM    187  C   ARG A  32      -0.387  21.280  -7.893  1.00 50.58           C  
ATOM    188  O   ARG A  32       0.025  22.113  -8.673  1.00 51.20           O  
ATOM    189  CB  ARG A  32       1.426  19.826  -6.789  1.00 51.44           C  
ATOM    190  CG  ARG A  32       1.889  19.459  -8.151  1.00 54.95           C  
ATOM    191  CD  ARG A  32       2.807  18.323  -7.897  1.00 60.58           C  
ATOM    192  NE  ARG A  32       3.308  17.711  -9.108  1.00 66.88           N  
ATOM    193  CZ  ARG A  32       4.150  16.690  -9.108  1.00 68.30           C  
ATOM    194  NH1 ARG A  32       4.575  16.207  -7.938  1.00 69.59           N  
ATOM    195  NH2 ARG A  32       4.565  16.165 -10.264  1.00 67.99           N  
ATOM    196  N   TRP A  33      -1.545  20.656  -8.080  1.00 50.02           N  
ATOM    197  CA  TRP A  33      -2.399  21.019  -9.206  1.00 49.04           C  
ATOM    198  C   TRP A  33      -3.324  22.189  -8.893  1.00 48.18           C  
ATOM    199  O   TRP A  33      -3.578  23.008  -9.771  1.00 48.01           O  
ATOM    200  CB  TRP A  33      -3.147  19.801  -9.766  1.00 49.51           C  
ATOM    201  CG  TRP A  33      -2.207  18.599  -9.974  1.00 50.40           C  
ATOM    202  CD1 TRP A  33      -2.351  17.337  -9.447  1.00 48.94           C  
ATOM    203  CD2 TRP A  33      -0.974  18.579 -10.730  1.00 49.88           C  
ATOM    204  NE1 TRP A  33      -1.305  16.546  -9.838  1.00 49.77           N  
ATOM    205  CE2 TRP A  33      -0.444  17.275 -10.622  1.00 50.64           C  
ATOM    206  CE3 TRP A  33      -0.276  19.534 -11.497  1.00 50.51           C  
ATOM    207  CZ2 TRP A  33       0.764  16.893 -11.250  1.00 49.81           C  
ATOM    208  CZ3 TRP A  33       0.917  19.156 -12.127  1.00 49.36           C  
ATOM    209  CH2 TRP A  33       1.426  17.848 -11.987  1.00 49.36           C  
ATOM    210  N   GLY A  34      -3.770  22.320  -7.639  1.00 46.77           N  
ATOM    211  CA  GLY A  34      -4.629  23.460  -7.263  1.00 44.62           C  
ATOM    212  C   GLY A  34      -3.954  24.804  -7.435  1.00 43.89           C  
ATOM    213  O   GLY A  34      -4.580  25.765  -7.899  1.00 43.68           O  
ATOM    214  N   VAL A  35      -2.675  24.881  -7.069  1.00 43.36           N  
ATOM    215  CA  VAL A  35      -1.903  26.109  -7.207  1.00 43.89           C  
ATOM    216  C   VAL A  35      -1.798  26.522  -8.691  1.00 44.11           C  
ATOM    217  O   VAL A  35      -1.913  27.684  -9.036  1.00 45.27           O  
ATOM    218  CB  VAL A  35      -0.437  25.970  -6.659  1.00 44.57           C  
ATOM    219  CG1 VAL A  35       0.374  27.252  -6.955  1.00 44.35           C  
ATOM    220  CG2 VAL A  35      -0.396  25.699  -5.155  1.00 43.44           C  
ATOM    221  N   LEU A  36      -1.533  25.557  -9.550  1.00 43.71           N  
ATOM    222  CA  LEU A  36      -1.270  25.805 -10.941  1.00 43.45           C  
ATOM    223  C   LEU A  36      -2.553  26.216 -11.617  1.00 42.92           C  
ATOM    224  O   LEU A  36      -2.551  27.155 -12.392  1.00 43.22           O  
ATOM    225  CB  LEU A  36      -0.689  24.545 -11.606  1.00 44.02           C  
ATOM    226  CG  LEU A  36       0.652  24.049 -11.056  1.00 43.62           C  
ATOM    227  CD1 LEU A  36       1.198  22.915 -11.935  1.00 44.34           C  
ATOM    228  CD2 LEU A  36       1.631  25.225 -10.978  1.00 44.43           C  
ATOM    229  N   ILE A  37      -3.651  25.526 -11.306  1.00 42.74           N  
ATOM    230  CA  ILE A  37      -4.970  25.959 -11.757  1.00 42.81           C  
ATOM    231  C   ILE A  37      -5.270  27.392 -11.350  1.00 42.94           C  
ATOM    232  O   ILE A  37      -5.669  28.202 -12.181  1.00 45.26           O  
ATOM    233  CB  ILE A  37      -6.104  25.043 -11.246  1.00 43.08           C  
ATOM    234  CG1 ILE A  37      -5.950  23.633 -11.818  1.00 41.03           C  
ATOM    235  CG2 ILE A  37      -7.492  25.712 -11.527  1.00 39.10           C  
ATOM    236  CD1 ILE A  37      -6.716  22.599 -11.068  1.00 38.73           C  
ATOM    237  N   LEU A  38      -5.064  27.717 -10.088  1.00 42.85           N  
ATOM    238  CA  LEU A  38      -5.383  29.050  -9.591  1.00 42.59           C  
ATOM    239  C   LEU A  38      -4.501  30.155 -10.150  1.00 42.93           C  
ATOM    240  O   LEU A  38      -4.949  31.302 -10.284  1.00 43.15           O  
ATOM    241  CB  LEU A  38      -5.354  29.077  -8.055  1.00 41.83           C  
ATOM    242  CG  LEU A  38      -6.515  28.365  -7.375  1.00 40.72           C  
ATOM    243  CD1 LEU A  38      -6.294  28.353  -5.891  1.00 39.09           C  
ATOM    244  CD2 LEU A  38      -7.930  28.970  -7.708  1.00 37.92           C  
ATOM    245  N   VAL A  39      -3.250  29.835 -10.472  1.00 43.56           N  
ATOM    246  CA  VAL A  39      -2.342  30.836 -11.038  1.00 44.40           C  
ATOM    247  C   VAL A  39      -2.680  31.014 -12.510  1.00 44.79           C  
ATOM    248  O   VAL A  39      -2.814  32.156 -12.972  1.00 45.33           O  
ATOM    249  CB  VAL A  39      -0.842  30.462 -10.863  1.00 45.66           C  
ATOM    250  CG1 VAL A  39       0.047  31.304 -11.811  1.00 46.23           C  
ATOM    251  CG2 VAL A  39      -0.390  30.614  -9.407  1.00 44.42           C  
ATOM    252  N   ALA A  40      -2.893  29.901 -13.225  1.00 43.99           N  
ATOM    253  CA  ALA A  40      -3.255  29.956 -14.646  1.00 44.83           C  
ATOM    254  C   ALA A  40      -4.557  30.741 -14.968  1.00 45.23           C  
ATOM    255  O   ALA A  40      -4.593  31.518 -15.895  1.00 45.03           O  
ATOM    256  CB  ALA A  40      -3.307  28.537 -15.251  1.00 44.43           C  
ATOM    257  N   LEU A  41      -5.624  30.530 -14.205  1.00 46.01           N  
ATOM    258  CA  LEU A  41      -6.882  31.224 -14.482  1.00 46.04           C  
ATOM    259  C   LEU A  41      -6.877  32.753 -14.253  1.00 47.31           C  
ATOM    260  O   LEU A  41      -7.847  33.454 -14.621  1.00 48.06           O  
ATOM    261  CB  LEU A  41      -8.010  30.566 -13.706  1.00 44.83           C  
ATOM    262  CG  LEU A  41      -8.226  29.115 -14.106  1.00 45.08           C  
ATOM    263  CD1 LEU A  41      -9.284  28.491 -13.208  1.00 43.96           C  
ATOM    264  CD2 LEU A  41      -8.592  28.980 -15.611  1.00 41.13           C  
ATOM    265  N   ARG A  42      -5.793  33.266 -13.674  1.00 48.98           N  
ATOM    266  CA  ARG A  42      -5.629  34.693 -13.451  1.00 50.09           C  
ATOM    267  C   ARG A  42      -5.510  35.372 -14.799  1.00 51.11           C  
ATOM    268  O   ARG A  42      -5.853  36.557 -14.937  1.00 51.13           O  
ATOM    269  CB  ARG A  42      -4.418  35.002 -12.561  1.00 50.01           C  
ATOM    270  CG  ARG A  42      -4.526  34.383 -11.159  1.00 50.87           C  
ATOM    271  CD  ARG A  42      -3.426  34.825 -10.157  1.00 50.47           C  
ATOM    272  NE  ARG A  42      -3.827  36.015  -9.392  1.00 50.52           N  
ATOM    273  CZ  ARG A  42      -3.100  37.117  -9.368  1.00 52.95           C  
ATOM    274  NH1 ARG A  42      -1.947  37.120 -10.018  1.00 55.57           N  
ATOM    275  NH2 ARG A  42      -3.491  38.201  -8.705  1.00 52.21           N  
ATOM    276  N   ASP A  43      -5.065  34.601 -15.789  1.00 52.03           N  
ATOM    277  CA  ASP A  43      -5.012  35.066 -17.176  1.00 53.88           C  
ATOM    278  C   ASP A  43      -6.351  35.080 -17.904  1.00 53.15           C  
ATOM    279  O   ASP A  43      -6.462  35.709 -18.942  1.00 54.23           O  
ATOM    280  CB  ASP A  43      -4.014  34.241 -17.984  1.00 54.65           C  
ATOM    281  CG  ASP A  43      -2.641  34.201 -17.343  1.00 59.18           C  
ATOM    282  OD1 ASP A  43      -2.131  35.279 -16.928  1.00 63.44           O  
ATOM    283  OD2 ASP A  43      -2.065  33.090 -17.267  1.00 63.29           O  
ATOM    284  N   GLY A  44      -7.349  34.386 -17.377  1.00 52.53           N  
ATOM    285  CA  GLY A  44      -8.670  34.332 -17.998  1.00 51.68           C  
ATOM    286  C   GLY A  44      -9.170  32.909 -18.119  1.00 51.45           C  
ATOM    287  O   GLY A  44      -8.530  31.960 -17.633  1.00 51.15           O  
ATOM    288  N   THR A  45     -10.321  32.760 -18.763  1.00 50.97           N  
ATOM    289  CA  THR A  45     -10.912  31.450 -19.043  1.00 50.99           C  
ATOM    290  C   THR A  45      -9.943  30.493 -19.758  1.00 50.76           C  
ATOM    291  O   THR A  45      -9.221  30.915 -20.657  1.00 51.61           O  
ATOM    292  CB  THR A  45     -12.203  31.614 -19.837  1.00 50.68           C  
ATOM    293  OG1 THR A  45     -13.061  32.495 -19.117  1.00 51.77           O  
ATOM    294  CG2 THR A  45     -12.920  30.291 -19.998  1.00 50.64           C  
ATOM    295  N   HIS A  46      -9.900  29.238 -19.296  1.00 49.81           N  
ATOM    296  CA  HIS A  46      -9.174  28.133 -19.920  1.00 48.17           C  
ATOM    297  C   HIS A  46     -10.143  27.000 -20.040  1.00 48.16           C  
ATOM    298  O   HIS A  46     -10.993  26.823 -19.153  1.00 47.86           O  
ATOM    299  CB  HIS A  46      -8.067  27.640 -19.004  1.00 48.34           C  
ATOM    300  CG  HIS A  46      -6.902  28.568 -18.909  1.00 48.35           C  
ATOM    301  ND1 HIS A  46      -7.010  29.854 -18.417  1.00 49.07           N  
ATOM    302  CD2 HIS A  46      -5.600  28.396 -19.231  1.00 47.57           C  
ATOM    303  CE1 HIS A  46      -5.826  30.440 -18.466  1.00 48.88           C  
ATOM    304  NE2 HIS A  46      -4.958  29.581 -18.969  1.00 48.09           N  
ATOM    305  N   ARG A  47     -10.014  26.234 -21.132  1.00 48.18           N  
ATOM    306  CA  ARG A  47     -10.693  24.954 -21.314  1.00 47.47           C  
ATOM    307  C   ARG A  47      -9.882  23.926 -20.569  1.00 48.35           C  
ATOM    308  O   ARG A  47      -8.695  24.154 -20.259  1.00 48.58           O  
ATOM    309  CB  ARG A  47     -10.822  24.613 -22.805  0.51 47.99           C  
ATOM    311  CG  ARG A  47     -11.342  25.796 -23.622  0.51 46.72           C  
ATOM    313  CD  ARG A  47     -11.912  25.430 -24.965  0.51 44.66           C  
ATOM    315  NE  ARG A  47     -10.901  25.519 -26.010  0.51 43.05           N  
ATOM    317  CZ  ARG A  47     -11.130  25.842 -27.279  0.51 39.38           C  
ATOM    319  NH1 ARG A  47     -12.350  26.143 -27.707  0.51 37.80           N  
ATOM    321  NH2 ARG A  47     -10.114  25.866 -28.120  0.51 38.15           N  
ATOM    323  N   PHE A  48     -10.511  22.790 -20.253  1.00 48.37           N  
ATOM    324  CA  PHE A  48      -9.800  21.674 -19.640  1.00 48.12           C  
ATOM    325  C   PHE A  48      -8.486  21.372 -20.342  1.00 48.23           C  
ATOM    326  O   PHE A  48      -7.492  21.116 -19.675  1.00 49.36           O  
ATOM    327  CB  PHE A  48     -10.682  20.425 -19.604  1.00 47.75           C  
ATOM    328  CG  PHE A  48     -10.116  19.293 -18.774  1.00 48.26           C  
ATOM    329  CD1 PHE A  48     -10.517  19.122 -17.450  1.00 47.76           C  
ATOM    330  CD2 PHE A  48      -9.187  18.395 -19.314  1.00 47.28           C  
ATOM    331  CE1 PHE A  48     -10.025  18.072 -16.675  1.00 47.89           C  
ATOM    332  CE2 PHE A  48      -8.683  17.341 -18.543  1.00 48.49           C  
ATOM    333  CZ  PHE A  48      -9.101  17.182 -17.216  1.00 47.88           C  
ATOM    334  N   SER A  49      -8.480  21.397 -21.678  1.00 48.88           N  
ATOM    335  CA  SER A  49      -7.302  21.035 -22.501  1.00 49.03           C  
ATOM    336  C   SER A  49      -6.181  22.059 -22.417  1.00 48.90           C  
ATOM    337  O   SER A  49      -5.029  21.714 -22.573  1.00 48.63           O  
ATOM    338  CB  SER A  49      -7.688  20.776 -23.991  1.00 49.52           C  
ATOM    339  OG  SER A  49      -8.121  21.974 -24.660  1.00 50.33           O  
ATOM    340  N   ASP A  50      -6.531  23.317 -22.178  1.00 50.09           N  
ATOM    341  CA  ASP A  50      -5.569  24.395 -21.945  1.00 51.57           C  
ATOM    342  C   ASP A  50      -4.822  24.258 -20.586  1.00 52.85           C  
ATOM    343  O   ASP A  50      -3.597  24.445 -20.520  1.00 53.41           O  
ATOM    344  CB  ASP A  50      -6.288  25.748 -22.012  1.00 51.58           C  
ATOM    345  CG  ASP A  50      -6.877  26.047 -23.386  1.00 53.45           C  
ATOM    346  OD1 ASP A  50      -6.580  25.302 -24.364  1.00 53.79           O  
ATOM    347  OD2 ASP A  50      -7.638  27.047 -23.488  1.00 55.16           O  
ATOM    348  N   LEU A  51      -5.553  23.940 -19.512  1.00 53.30           N  
ATOM    349  CA  LEU A  51      -4.922  23.657 -18.204  1.00 54.20           C  
ATOM    350  C   LEU A  51      -4.011  22.455 -18.316  1.00 55.36           C  
ATOM    351  O   LEU A  51      -2.843  22.522 -17.956  1.00 54.94           O  
ATOM    352  CB  LEU A  51      -5.966  23.402 -17.114  1.00 52.65           C  
ATOM    353  CG  LEU A  51      -6.875  24.600 -16.842  1.00 52.43           C  
ATOM    354  CD1 LEU A  51      -8.087  24.197 -16.024  1.00 50.80           C  
ATOM    355  CD2 LEU A  51      -6.093  25.758 -16.196  1.00 48.29           C  
ATOM    356  N   ARG A  52      -4.569  21.360 -18.834  1.00 57.19           N  
ATOM    357  CA  ARG A  52      -3.852  20.104 -19.003  1.00 58.84           C  
ATOM    358  C   ARG A  52      -2.544  20.304 -19.791  1.00 59.67           C  
ATOM    359  O   ARG A  52      -1.583  19.575 -19.594  1.00 59.66           O  
ATOM    360  CB  ARG A  52      -4.784  19.120 -19.704  1.00 59.14           C  
ATOM    361  CG  ARG A  52      -4.186  17.793 -20.140  1.00 62.14           C  
ATOM    362  CD  ARG A  52      -3.853  16.939 -18.954  1.00 66.98           C  
ATOM    363  NE  ARG A  52      -3.904  15.507 -19.256  1.00 72.53           N  
ATOM    364  CZ  ARG A  52      -2.925  14.818 -19.844  1.00 75.81           C  
ATOM    365  NH1 ARG A  52      -1.800  15.420 -20.236  1.00 76.72           N  
ATOM    366  NH2 ARG A  52      -3.075  13.515 -20.049  1.00 77.10           N  
ATOM    367  N   ARG A  53      -2.526  21.318 -20.655  1.00 60.90           N  
ATOM    368  CA  ARG A  53      -1.392  21.650 -21.512  1.00 62.28           C  
ATOM    369  C   ARG A  53      -0.270  22.385 -20.791  1.00 62.60           C  
ATOM    370  O   ARG A  53       0.900  22.045 -20.977  1.00 62.76           O  
ATOM    371  CB  ARG A  53      -1.878  22.524 -22.674  1.00 62.90           C  
ATOM    372  CG  ARG A  53      -0.843  22.803 -23.745  1.00 65.06           C  
ATOM    373  CD  ARG A  53      -1.144  21.991 -24.979  1.00 69.73           C  
ATOM    374  NE  ARG A  53      -2.526  22.207 -25.411  1.00 71.83           N  
ATOM    375  CZ  ARG A  53      -3.125  21.522 -26.380  1.00 73.13           C  
ATOM    376  NH1 ARG A  53      -2.467  20.569 -27.037  1.00 73.05           N  
ATOM    377  NH2 ARG A  53      -4.391  21.792 -26.688  1.00 74.30           N  
HETATM  378  N   MLY A  54      -0.632  23.405 -20.006  1.00 62.99           N  
HETATM  379  CA  MLY A  54       0.325  24.214 -19.242  1.00 63.68           C  
HETATM  380  CB  MLY A  54      -0.367  25.422 -18.596  1.00 63.79           C  
HETATM  381  CG  MLY A  54      -0.037  26.775 -19.233  1.00 64.97           C  
HETATM  382  CD  MLY A  54      -1.090  27.844 -18.892  1.00 65.35           C  
HETATM  383  CE  MLY A  54      -1.290  28.922 -19.980  1.00 64.31           C  
HETATM  384  NZ  MLY A  54      -2.223  30.003 -19.563  1.00 62.94           N  
HETATM  385  CH1 MLY A  54      -2.451  30.974 -20.639  1.00 62.78           C  
HETATM  386  CH2 MLY A  54      -1.719  30.753 -18.402  1.00 61.92           C  
HETATM  387  C   MLY A  54       0.974  23.412 -18.142  1.00 63.95           C  
HETATM  388  O   MLY A  54       2.121  23.678 -17.764  1.00 63.46           O  
HETATM  389  N   MSE A  55       0.238  22.427 -17.624  1.00 64.31           N  
HETATM  390  CA  MSE A  55       0.646  21.674 -16.430  1.00 65.73           C  
HETATM  391  C   MSE A  55       1.201  20.343 -16.840  1.00 65.03           C  
HETATM  392  O   MSE A  55       0.498  19.333 -16.801  1.00 65.09           O  
HETATM  393  CB  MSE A  55      -0.525  21.446 -15.482  1.00 64.77           C  
HETATM  394  CG  MSE A  55      -1.104  22.713 -14.959  1.00 65.99           C  
HETATM  395 SE   MSE A  55      -2.937  22.503 -14.352  0.88 69.50          SE  
HETATM  396  CE  MSE A  55      -3.401  24.334 -14.567  1.00 65.46           C  
ATOM    397  N   GLY A  56       2.467  20.356 -17.245  1.00 65.29           N  
ATOM    398  CA  GLY A  56       3.157  19.140 -17.675  1.00 65.16           C  
ATOM    399  C   GLY A  56       3.250  18.218 -16.474  1.00 64.78           C  
ATOM    400  O   GLY A  56       3.672  18.641 -15.373  1.00 64.44           O  
ATOM    401  N   GLY A  57       2.814  16.973 -16.681  1.00 64.32           N  
ATOM    402  CA  GLY A  57       2.866  15.950 -15.634  1.00 63.26           C  
ATOM    403  C   GLY A  57       1.554  15.593 -14.949  1.00 62.51           C  
ATOM    404  O   GLY A  57       1.524  14.628 -14.174  1.00 63.46           O  
ATOM    405  N   VAL A  58       0.485  16.363 -15.189  1.00 60.87           N  
ATOM    406  CA  VAL A  58      -0.817  16.066 -14.581  1.00 58.95           C  
ATOM    407  C   VAL A  58      -1.611  15.088 -15.458  1.00 58.62           C  
ATOM    408  O   VAL A  58      -1.701  15.257 -16.693  1.00 58.40           O  
ATOM    409  CB  VAL A  58      -1.637  17.365 -14.220  1.00 58.85           C  
ATOM    410  CG1 VAL A  58      -2.225  18.083 -15.478  1.00 58.18           C  
ATOM    411  CG2 VAL A  58      -2.736  17.053 -13.216  1.00 57.18           C  
ATOM    412  N   SER A  59      -2.166  14.052 -14.836  1.00 57.60           N  
ATOM    413  CA  SER A  59      -3.102  13.193 -15.554  1.00 57.49           C  
ATOM    414  C   SER A  59      -4.485  13.883 -15.702  1.00 57.45           C  
ATOM    415  O   SER A  59      -4.780  14.851 -14.988  1.00 57.44           O  
ATOM    416  CB  SER A  59      -3.251  11.861 -14.845  1.00 57.11           C  
ATOM    417  OG  SER A  59      -3.989  12.008 -13.652  1.00 58.01           O  
ATOM    418  N   GLU A  60      -5.306  13.394 -16.633  1.00 56.68           N  
ATOM    419  CA  GLU A  60      -6.711  13.793 -16.730  1.00 56.54           C  
ATOM    420  C   GLU A  60      -7.431  13.666 -15.386  1.00 55.94           C  
ATOM    421  O   GLU A  60      -8.100  14.599 -14.939  1.00 56.23           O  
ATOM    422  CB  GLU A  60      -7.460  12.941 -17.757  1.00 55.92           C  
ATOM    423  CG  GLU A  60      -7.549  13.502 -19.154  1.00 56.73           C  
ATOM    424  CD  GLU A  60      -8.497  12.676 -20.068  1.00 57.99           C  
ATOM    425  OE1 GLU A  60      -9.171  11.724 -19.578  1.00 59.01           O  
ATOM    426  OE2 GLU A  60      -8.580  12.984 -21.284  1.00 58.92           O  
HETATM  427  N   MLY A  61      -7.297  12.507 -14.757  1.00 54.98           N  
HETATM  428  CA  MLY A  61      -8.059  12.198 -13.561  1.00 55.03           C  
HETATM  429  CB  MLY A  61      -7.824  10.749 -13.133  1.00 55.21           C  
HETATM  430  CG  MLY A  61      -9.093  10.209 -12.478  1.00 57.87           C  
HETATM  431  CD  MLY A  61      -9.060   8.704 -12.217  1.00 62.21           C  
HETATM  432  CE  MLY A  61      -9.442   8.392 -10.758  1.00 65.31           C  
HETATM  433  NZ  MLY A  61     -10.523   7.376 -10.641  1.00 67.32           N  
HETATM  434  CH1 MLY A  61     -10.056   6.015 -10.977  1.00 65.34           C  
HETATM  435  CH2 MLY A  61     -11.675   7.724 -11.511  1.00 69.01           C  
HETATM  436  C   MLY A  61      -7.792  13.143 -12.410  1.00 54.00           C  
HETATM  437  O   MLY A  61      -8.734  13.585 -11.744  1.00 53.54           O  
HETATM  438  N   MSE A  62      -6.517  13.462 -12.191  1.00 52.65           N  
HETATM  439  CA  MSE A  62      -6.103  14.284 -11.065  1.00 51.90           C  
HETATM  440  C   MSE A  62      -6.450  15.733 -11.303  1.00 49.93           C  
HETATM  441  O   MSE A  62      -6.787  16.464 -10.358  1.00 48.49           O  
HETATM  442  CB  MSE A  62      -4.602  14.119 -10.781  1.00 52.74           C  
HETATM  443  CG  MSE A  62      -4.247  12.796 -10.071  1.00 56.32           C  
HETATM  444 SE   MSE A  62      -5.009  12.650  -8.252  0.70 66.50          SE  
HETATM  445  CE  MSE A  62      -6.713  11.595  -8.790  1.00 59.30           C  
ATOM    446  N   LEU A  63      -6.379  16.132 -12.574  1.00 47.69           N  
ATOM    447  CA  LEU A  63      -6.833  17.464 -12.968  1.00 46.18           C  
ATOM    448  C   LEU A  63      -8.362  17.586 -12.758  1.00 44.09           C  
ATOM    449  O   LEU A  63      -8.831  18.510 -12.122  1.00 43.54           O  
ATOM    450  CB  LEU A  63      -6.385  17.803 -14.394  1.00 45.97           C  
ATOM    451  CG  LEU A  63      -6.873  19.150 -14.937  1.00 47.38           C  
ATOM    452  CD1 LEU A  63      -6.424  20.325 -14.072  1.00 46.25           C  
ATOM    453  CD2 LEU A  63      -6.457  19.342 -16.397  1.00 45.08           C  
ATOM    454  N   ALA A  64      -9.113  16.608 -13.223  1.00 42.43           N  
ATOM    455  CA  ALA A  64     -10.548  16.596 -13.009  1.00 41.86           C  
ATOM    456  C   ALA A  64     -10.852  16.684 -11.509  1.00 41.09           C  
ATOM    457  O   ALA A  64     -11.792  17.378 -11.087  1.00 40.96           O  
ATOM    458  CB  ALA A  64     -11.204  15.345 -13.654  1.00 40.10           C  
ATOM    459  N   GLN A  65     -10.020  16.027 -10.712  1.00 40.62           N  
ATOM    460  CA  GLN A  65     -10.257  15.947  -9.295  1.00 41.11           C  
ATOM    461  C   GLN A  65      -9.979  17.282  -8.566  1.00 40.68           C  
ATOM    462  O   GLN A  65     -10.812  17.707  -7.765  1.00 40.55           O  
ATOM    463  CB  GLN A  65      -9.530  14.756  -8.689  1.00 42.26           C  
ATOM    464  CG  GLN A  65      -9.497  14.861  -7.141  1.00 48.52           C  
ATOM    465  CD  GLN A  65      -8.746  13.739  -6.476  1.00 54.34           C  
ATOM    466  OE1 GLN A  65      -9.019  12.551  -6.718  1.00 55.32           O  
ATOM    467  NE2 GLN A  65      -7.802  14.108  -5.602  1.00 58.38           N  
ATOM    468  N   SER A  66      -8.869  17.961  -8.879  1.00 40.14           N  
ATOM    469  CA  SER A  66      -8.636  19.346  -8.403  1.00 40.82           C  
ATOM    470  C   SER A  66      -9.688  20.326  -8.878  1.00 40.42           C  
ATOM    471  O   SER A  66     -10.199  21.128  -8.092  1.00 40.55           O  
ATOM    472  CB  SER A  66      -7.244  19.908  -8.772  1.00 40.44           C  
ATOM    473  OG  SER A  66      -6.268  18.887  -8.794  1.00 44.69           O  
ATOM    474  N   LEU A  67     -10.034  20.261 -10.160  1.00 40.14           N  
ATOM    475  CA  LEU A  67     -10.987  21.213 -10.722  1.00 38.69           C  
ATOM    476  C   LEU A  67     -12.297  21.091 -10.002  1.00 39.44           C  
ATOM    477  O   LEU A  67     -12.950  22.096  -9.710  1.00 40.33           O  
ATOM    478  CB  LEU A  67     -11.179  20.986 -12.241  1.00 38.47           C  
ATOM    479  CG  LEU A  67     -10.095  21.614 -13.128  1.00 35.08           C  
ATOM    480  CD1 LEU A  67     -10.133  21.015 -14.490  1.00 31.62           C  
ATOM    481  CD2 LEU A  67     -10.266  23.152 -13.180  1.00 31.19           C  
ATOM    482  N   GLN A  68     -12.690  19.855  -9.728  1.00 40.17           N  
ATOM    483  CA  GLN A  68     -13.900  19.597  -8.968  1.00 41.58           C  
ATOM    484  C   GLN A  68     -13.897  20.090  -7.490  1.00 40.98           C  
ATOM    485  O   GLN A  68     -14.889  20.660  -7.035  1.00 40.31           O  
ATOM    486  CB  GLN A  68     -14.246  18.108  -8.996  1.00 41.94           C  
ATOM    487  CG  GLN A  68     -15.454  17.812  -8.102  1.00 47.17           C  
ATOM    488  CD  GLN A  68     -16.335  16.768  -8.689  1.00 56.35           C  
ATOM    489  OE1 GLN A  68     -16.203  15.574  -8.367  1.00 58.70           O  
ATOM    490  NE2 GLN A  68     -17.239  17.190  -9.597  1.00 59.25           N  
ATOM    491  N   ALA A  69     -12.814  19.834  -6.758  1.00 40.70           N  
ATOM    492  CA  ALA A  69     -12.677  20.332  -5.383  1.00 41.28           C  
ATOM    493  C   ALA A  69     -12.698  21.869  -5.341  1.00 41.89           C  
ATOM    494  O   ALA A  69     -13.309  22.459  -4.461  1.00 42.43           O  
ATOM    495  CB  ALA A  69     -11.415  19.762  -4.695  1.00 40.68           C  
ATOM    496  N   LEU A  70     -12.070  22.510  -6.318  1.00 42.83           N  
ATOM    497  CA  LEU A  70     -12.052  23.967  -6.389  1.00 43.00           C  
ATOM    498  C   LEU A  70     -13.389  24.566  -6.775  1.00 44.42           C  
ATOM    499  O   LEU A  70     -13.730  25.654  -6.299  1.00 44.44           O  
ATOM    500  CB  LEU A  70     -10.939  24.464  -7.327  1.00 42.06           C  
ATOM    501  CG  LEU A  70      -9.473  24.200  -6.911  1.00 40.80           C  
ATOM    502  CD1 LEU A  70      -8.454  24.580  -8.025  1.00 37.97           C  
ATOM    503  CD2 LEU A  70      -9.124  24.940  -5.623  1.00 38.97           C  
ATOM    504  N   GLU A  71     -14.152  23.870  -7.617  1.00 45.77           N  
ATOM    505  CA  GLU A  71     -15.485  24.347  -8.004  1.00 47.84           C  
ATOM    506  C   GLU A  71     -16.483  24.258  -6.854  1.00 48.10           C  
ATOM    507  O   GLU A  71     -17.247  25.215  -6.604  1.00 47.97           O  
ATOM    508  CB  GLU A  71     -16.037  23.613  -9.237  1.00 47.78           C  
ATOM    509  CG  GLU A  71     -17.464  24.081  -9.607  1.00 49.83           C  
ATOM    510  CD  GLU A  71     -18.146  23.276 -10.711  1.00 51.40           C  
ATOM    511  OE1 GLU A  71     -17.669  22.153 -11.067  1.00 55.26           O  
ATOM    512  OE2 GLU A  71     -19.192  23.780 -11.208  1.00 55.45           O  
ATOM    513  N   GLN A  72     -16.472  23.134  -6.133  1.00 49.17           N  
ATOM    514  CA  GLN A  72     -17.411  22.997  -5.024  1.00 51.03           C  
ATOM    515  C   GLN A  72     -17.054  23.855  -3.822  1.00 50.26           C  
ATOM    516  O   GLN A  72     -17.940  24.139  -3.010  1.00 50.94           O  
ATOM    517  CB  GLN A  72     -17.795  21.540  -4.666  1.00 51.35           C  
ATOM    518  CG  GLN A  72     -16.657  20.580  -4.434  1.00 54.22           C  
ATOM    519  CD  GLN A  72     -17.027  19.121  -4.775  1.00 54.17           C  
ATOM    520  OE1 GLN A  72     -17.866  18.862  -5.645  1.00 55.30           O  
ATOM    521  NE2 GLN A  72     -16.356  18.167  -4.114  1.00 57.63           N  
ATOM    522  N   ASP A  73     -15.790  24.304  -3.746  1.00 48.98           N  
ATOM    523  CA  ASP A  73     -15.368  25.304  -2.767  1.00 47.97           C  
ATOM    524  C   ASP A  73     -15.880  26.697  -3.152  1.00 46.79           C  
ATOM    525  O   ASP A  73     -16.055  27.544  -2.307  1.00 46.95           O  
ATOM    526  CB  ASP A  73     -13.842  25.311  -2.612  1.00 48.13           C  
ATOM    527  CG  ASP A  73     -13.319  24.132  -1.749  1.00 51.16           C  
ATOM    528  OD1 ASP A  73     -14.144  23.408  -1.146  1.00 52.90           O  
ATOM    529  OD2 ASP A  73     -12.076  23.913  -1.680  1.00 52.92           O  
ATOM    530  N   GLY A  74     -16.148  26.927  -4.434  1.00 45.45           N  
ATOM    531  CA  GLY A  74     -16.741  28.191  -4.858  1.00 43.07           C  
ATOM    532  C   GLY A  74     -15.759  29.104  -5.567  1.00 42.23           C  
ATOM    533  O   GLY A  74     -16.018  30.322  -5.701  1.00 41.63           O  
ATOM    534  N   PHE A  75     -14.643  28.525  -6.029  1.00 40.64           N  
ATOM    535  CA  PHE A  75     -13.570  29.308  -6.602  1.00 40.47           C  
ATOM    536  C   PHE A  75     -13.632  29.341  -8.133  1.00 42.09           C  
ATOM    537  O   PHE A  75     -12.987  30.198  -8.763  1.00 42.91           O  
ATOM    538  CB  PHE A  75     -12.194  28.783  -6.147  1.00 39.57           C  
ATOM    539  CG  PHE A  75     -12.009  28.732  -4.638  1.00 38.60           C  
ATOM    540  CD1 PHE A  75     -12.419  29.799  -3.817  1.00 39.11           C  
ATOM    541  CD2 PHE A  75     -11.401  27.638  -4.047  1.00 36.82           C  
ATOM    542  CE1 PHE A  75     -12.230  29.763  -2.448  1.00 37.62           C  
ATOM    543  CE2 PHE A  75     -11.199  27.593  -2.676  1.00 35.49           C  
ATOM    544  CZ  PHE A  75     -11.620  28.648  -1.872  1.00 37.61           C  
ATOM    545  N   LEU A  76     -14.357  28.399  -8.740  1.00 42.49           N  
ATOM    546  CA  LEU A  76     -14.404  28.336 -10.205  1.00 43.92           C  
ATOM    547  C   LEU A  76     -15.810  28.325 -10.753  1.00 44.33           C  
ATOM    548  O   LEU A  76     -16.729  27.760 -10.155  1.00 43.29           O  
ATOM    549  CB  LEU A  76     -13.666  27.118 -10.789  1.00 43.67           C  
ATOM    550  CG  LEU A  76     -12.326  26.705 -10.224  1.00 43.91           C  
ATOM    551  CD1 LEU A  76     -11.930  25.411 -10.845  1.00 41.26           C  
ATOM    552  CD2 LEU A  76     -11.235  27.787 -10.395  1.00 45.72           C  
ATOM    553  N   ASN A  77     -15.946  28.990 -11.891  1.00 45.66           N  
ATOM    554  CA  ASN A  77     -17.073  28.761 -12.804  1.00 47.95           C  
ATOM    555  C   ASN A  77     -16.731  27.674 -13.815  1.00 48.51           C  
ATOM    556  O   ASN A  77     -15.656  27.683 -14.414  1.00 47.94           O  
ATOM    557  CB  ASN A  77     -17.498  30.063 -13.469  1.00 47.10           C  
ATOM    558  CG  ASN A  77     -18.115  31.009 -12.471  1.00 49.63           C  
ATOM    559  OD1 ASN A  77     -17.723  32.177 -12.383  1.00 52.95           O  
ATOM    560  ND2 ASN A  77     -19.067  30.493 -11.661  1.00 47.29           N  
ATOM    561  N   ARG A  78     -17.625  26.700 -13.934  1.00 50.39           N  
ATOM    562  CA  ARG A  78     -17.482  25.690 -14.958  1.00 52.75           C  
ATOM    563  C   ARG A  78     -18.629  25.715 -15.981  1.00 53.99           C  
ATOM    564  O   ARG A  78     -19.799  25.478 -15.644  1.00 54.21           O  
ATOM    565  CB  ARG A  78     -17.327  24.304 -14.343  1.00 52.85           C  
ATOM    566  CG  ARG A  78     -17.240  23.213 -15.410  1.00 54.96           C  
ATOM    567  CD  ARG A  78     -17.518  21.880 -14.811  1.00 59.13           C  
ATOM    568  NE  ARG A  78     -18.870  21.860 -14.275  1.00 65.68           N  
ATOM    569  CZ  ARG A  78     -19.494  20.766 -13.842  1.00 70.74           C  
ATOM    570  NH1 ARG A  78     -18.887  19.566 -13.878  1.00 71.15           N  
ATOM    571  NH2 ARG A  78     -20.737  20.873 -13.375  1.00 71.16           N  
ATOM    572  N   VAL A  79     -18.288  26.004 -17.232  1.00 55.42           N  
ATOM    573  CA  VAL A  79     -19.296  26.070 -18.305  1.00 56.70           C  
ATOM    574  C   VAL A  79     -19.069  24.989 -19.358  1.00 57.17           C  
ATOM    575  O   VAL A  79     -17.994  24.911 -19.952  1.00 56.33           O  
ATOM    576  CB  VAL A  79     -19.338  27.458 -18.984  1.00 56.86           C  
ATOM    577  CG1 VAL A  79     -20.532  27.558 -19.943  1.00 57.86           C  
ATOM    578  CG2 VAL A  79     -19.411  28.566 -17.938  1.00 58.55           C  
ATOM    579  N   SER A  80     -20.090  24.153 -19.568  1.00 58.61           N  
ATOM    580  CA  SER A  80     -20.059  23.127 -20.624  1.00 59.93           C  
ATOM    581  C   SER A  80     -20.393  23.680 -21.988  1.00 59.94           C  
ATOM    582  O   SER A  80     -21.269  24.535 -22.139  1.00 60.13           O  
ATOM    583  CB  SER A  80     -21.023  21.971 -20.337  1.00 60.06           C  
ATOM    584  OG  SER A  80     -20.374  20.948 -19.608  1.00 61.59           O  
ATOM    585  N   TYR A  81     -19.686  23.174 -22.988  1.00 60.46           N  
ATOM    586  CA  TYR A  81     -20.126  23.337 -24.373  1.00 60.34           C  
ATOM    587  C   TYR A  81     -20.222  21.955 -25.042  1.00 60.04           C  
ATOM    588  O   TYR A  81     -19.223  21.423 -25.546  1.00 60.10           O  
ATOM    589  CB  TYR A  81     -19.241  24.320 -25.135  1.00 60.68           C  
ATOM    590  CG  TYR A  81     -19.193  25.726 -24.551  1.00 61.21           C  
ATOM    591  CD1 TYR A  81     -20.035  26.743 -25.025  1.00 61.96           C  
ATOM    592  CD2 TYR A  81     -18.284  26.045 -23.543  1.00 61.62           C  
ATOM    593  CE1 TYR A  81     -19.972  28.048 -24.493  1.00 61.58           C  
ATOM    594  CE2 TYR A  81     -18.211  27.318 -23.014  1.00 61.28           C  
ATOM    595  CZ  TYR A  81     -19.047  28.319 -23.487  1.00 62.16           C  
ATOM    596  OH  TYR A  81     -18.939  29.576 -22.923  1.00 62.14           O  
ATOM    597  N   PRO A  82     -21.430  21.352 -25.002  1.00 59.80           N  
ATOM    598  CA  PRO A  82     -21.749  20.053 -25.628  1.00 59.34           C  
ATOM    599  C   PRO A  82     -21.594  20.013 -27.175  1.00 58.62           C  
ATOM    600  O   PRO A  82     -21.600  18.931 -27.775  1.00 58.66           O  
ATOM    601  CB  PRO A  82     -23.221  19.825 -25.228  1.00 59.60           C  
ATOM    602  CG  PRO A  82     -23.772  21.224 -24.943  1.00 60.32           C  
ATOM    603  CD  PRO A  82     -22.601  21.925 -24.298  1.00 60.01           C  
ATOM    604  N   VAL A  83     -21.459  21.183 -27.791  1.00 57.71           N  
ATOM    605  CA  VAL A  83     -21.292  21.343 -29.234  1.00 56.81           C  
ATOM    606  C   VAL A  83     -19.960  20.726 -29.678  1.00 55.10           C  
ATOM    607  O   VAL A  83     -19.059  20.598 -28.864  1.00 56.09           O  
ATOM    608  CB  VAL A  83     -21.350  22.850 -29.582  1.00 57.31           C  
ATOM    609  CG1 VAL A  83     -19.992  23.520 -29.314  1.00 58.85           C  
ATOM    610  CG2 VAL A  83     -21.830  23.072 -31.019  1.00 58.30           C  
ATOM    611  N   VAL A  84     -19.834  20.354 -30.953  1.00 52.47           N  
ATOM    612  CA  VAL A  84     -18.673  19.599 -31.472  1.00 49.68           C  
ATOM    613  C   VAL A  84     -17.488  20.449 -32.013  1.00 47.63           C  
ATOM    614  O   VAL A  84     -17.672  21.296 -32.847  1.00 47.77           O  
ATOM    615  CB  VAL A  84     -19.160  18.563 -32.538  1.00 49.67           C  
ATOM    616  CG1 VAL A  84     -17.990  17.893 -33.252  1.00 48.67           C  
ATOM    617  CG2 VAL A  84     -20.052  17.522 -31.869  1.00 49.78           C  
ATOM    618  N   PRO A  85     -16.259  20.215 -31.533  1.00 46.56           N  
ATOM    619  CA  PRO A  85     -15.859  19.322 -30.424  1.00 45.89           C  
ATOM    620  C   PRO A  85     -16.270  19.916 -29.063  1.00 45.51           C  
ATOM    621  O   PRO A  85     -16.191  21.132 -28.889  1.00 43.39           O  
ATOM    622  CB  PRO A  85     -14.335  19.263 -30.529  1.00 45.63           C  
ATOM    623  CG  PRO A  85     -13.956  20.547 -31.236  1.00 46.38           C  
ATOM    624  CD  PRO A  85     -15.106  20.896 -32.153  1.00 46.15           C  
ATOM    625  N   PRO A  86     -16.715  19.045 -28.121  1.00 45.82           N  
ATOM    626  CA  PRO A  86     -17.158  19.527 -26.802  1.00 45.60           C  
ATOM    627  C   PRO A  86     -15.981  20.033 -26.012  1.00 45.43           C  
ATOM    628  O   PRO A  86     -14.870  19.506 -26.105  1.00 45.80           O  
ATOM    629  CB  PRO A  86     -17.746  18.276 -26.129  1.00 45.64           C  
ATOM    630  CG  PRO A  86     -17.055  17.101 -26.825  1.00 45.99           C  
ATOM    631  CD  PRO A  86     -16.773  17.564 -28.236  1.00 45.22           C  
ATOM    632  N   HIS A  87     -16.222  21.073 -25.245  1.00 45.40           N  
ATOM    633  CA  HIS A  87     -15.229  21.525 -24.300  1.00 44.94           C  
ATOM    634  C   HIS A  87     -15.916  21.910 -23.006  1.00 45.14           C  
ATOM    635  O   HIS A  87     -17.133  22.091 -22.946  1.00 45.12           O  
ATOM    636  CB  HIS A  87     -14.460  22.744 -24.838  0.54 44.50           C  
ATOM    638  CG  HIS A  87     -13.383  22.415 -25.830  0.54 42.57           C  
ATOM    640  ND1 HIS A  87     -12.353  21.539 -25.555  0.54 40.03           N  
ATOM    642  CD2 HIS A  87     -13.160  22.881 -27.085  0.54 40.82           C  
ATOM    644  CE1 HIS A  87     -11.550  21.471 -26.602  0.54 41.54           C  
ATOM    646  NE2 HIS A  87     -12.018  22.277 -27.544  0.54 40.10           N  
ATOM    648  N   VAL A  88     -15.119  21.989 -21.956  1.00 45.28           N  
ATOM    649  CA  VAL A  88     -15.569  22.579 -20.724  1.00 45.20           C  
ATOM    650  C   VAL A  88     -14.572  23.680 -20.426  1.00 45.16           C  
ATOM    651  O   VAL A  88     -13.367  23.474 -20.539  1.00 45.33           O  
ATOM    652  CB  VAL A  88     -15.678  21.525 -19.592  1.00 45.08           C  
ATOM    653  CG1 VAL A  88     -14.353  20.836 -19.355  1.00 44.39           C  
ATOM    654  CG2 VAL A  88     -16.218  22.149 -18.355  1.00 44.13           C  
ATOM    655  N   GLU A  89     -15.089  24.851 -20.086  1.00 44.72           N  
ATOM    656  CA  GLU A  89     -14.278  26.005 -19.728  1.00 44.74           C  
ATOM    657  C   GLU A  89     -14.403  26.391 -18.265  1.00 43.67           C  
ATOM    658  O   GLU A  89     -15.492  26.283 -17.677  1.00 43.36           O  
ATOM    659  CB  GLU A  89     -14.661  27.207 -20.603  1.00 45.49           C  
ATOM    660  CG  GLU A  89     -13.773  27.318 -21.810  1.00 47.15           C  
ATOM    661  CD  GLU A  89     -14.434  28.012 -22.936  1.00 50.11           C  
ATOM    662  OE1 GLU A  89     -14.985  29.089 -22.675  1.00 49.28           O  
ATOM    663  OE2 GLU A  89     -14.411  27.474 -24.092  1.00 55.74           O  
ATOM    664  N   TYR A  90     -13.275  26.875 -17.726  1.00 42.85           N  
ATOM    665  CA  TYR A  90     -13.078  27.253 -16.313  1.00 41.31           C  
ATOM    666  C   TYR A  90     -12.610  28.681 -16.192  1.00 41.19           C  
ATOM    667  O   TYR A  90     -11.702  29.104 -16.886  1.00 40.83           O  
ATOM    668  CB  TYR A  90     -12.010  26.337 -15.649  1.00 41.08           C  
ATOM    669  CG  TYR A  90     -12.427  24.892 -15.659  1.00 39.59           C  
ATOM    670  CD1 TYR A  90     -13.299  24.402 -14.690  1.00 42.18           C  
ATOM    671  CD2 TYR A  90     -12.029  24.043 -16.674  1.00 39.08           C  
ATOM    672  CE1 TYR A  90     -13.737  23.084 -14.723  1.00 41.75           C  
ATOM    673  CE2 TYR A  90     -12.455  22.719 -16.716  1.00 40.26           C  
ATOM    674  CZ  TYR A  90     -13.309  22.251 -15.734  1.00 40.94           C  
ATOM    675  OH  TYR A  90     -13.743  20.948 -15.733  1.00 39.87           O  
ATOM    676  N   SER A  91     -13.212  29.418 -15.270  1.00 41.83           N  
ATOM    677  CA  SER A  91     -12.673  30.695 -14.840  1.00 42.80           C  
ATOM    678  C   SER A  91     -12.881  30.845 -13.326  1.00 43.35           C  
ATOM    679  O   SER A  91     -13.613  30.052 -12.705  1.00 43.32           O  
ATOM    680  CB  SER A  91     -13.358  31.850 -15.578  1.00 43.04           C  
ATOM    681  OG  SER A  91     -14.770  31.752 -15.435  1.00 43.22           O  
ATOM    682  N   LEU A  92     -12.264  31.885 -12.765  1.00 43.03           N  
ATOM    683  CA  LEU A  92     -12.392  32.225 -11.357  1.00 43.46           C  
ATOM    684  C   LEU A  92     -13.651  33.032 -11.053  1.00 43.66           C  
ATOM    685  O   LEU A  92     -14.010  33.954 -11.783  1.00 43.50           O  
ATOM    686  CB  LEU A  92     -11.186  33.047 -10.872  1.00 43.00           C  
ATOM    687  CG  LEU A  92      -9.800  32.452 -11.011  1.00 42.15           C  
ATOM    688  CD1 LEU A  92      -8.817  33.558 -10.923  1.00 41.83           C  
ATOM    689  CD2 LEU A  92      -9.537  31.374  -9.956  1.00 41.09           C  
ATOM    690  N   THR A  93     -14.293  32.670  -9.956  1.00 44.14           N  
ATOM    691  CA  THR A  93     -15.323  33.476  -9.363  1.00 44.96           C  
ATOM    692  C   THR A  93     -14.641  34.661  -8.649  1.00 46.17           C  
ATOM    693  O   THR A  93     -13.401  34.664  -8.494  1.00 47.08           O  
ATOM    694  CB  THR A  93     -16.136  32.622  -8.383  1.00 44.73           C  
ATOM    695  OG1 THR A  93     -15.281  32.214  -7.303  1.00 44.59           O  
ATOM    696  CG2 THR A  93     -16.714  31.379  -9.102  1.00 43.33           C  
ATOM    697  N   PRO A  94     -15.418  35.691  -8.245  1.00 46.34           N  
ATOM    698  CA  PRO A  94     -14.839  36.720  -7.336  1.00 46.31           C  
ATOM    699  C   PRO A  94     -14.175  36.156  -6.085  1.00 45.68           C  
ATOM    700  O   PRO A  94     -13.088  36.599  -5.715  1.00 46.52           O  
ATOM    701  CB  PRO A  94     -16.052  37.589  -6.959  1.00 46.10           C  
ATOM    702  CG  PRO A  94     -16.945  37.462  -8.178  1.00 46.14           C  
ATOM    703  CD  PRO A  94     -16.814  36.005  -8.607  1.00 46.02           C  
ATOM    704  N   LEU A  95     -14.810  35.185  -5.429  1.00 44.97           N  
ATOM    705  CA  LEU A  95     -14.176  34.484  -4.300  1.00 43.00           C  
ATOM    706  C   LEU A  95     -12.865  33.789  -4.712  1.00 42.65           C  
ATOM    707  O   LEU A  95     -11.859  33.791  -3.972  1.00 43.31           O  
ATOM    708  CB  LEU A  95     -15.160  33.482  -3.656  1.00 42.93           C  
ATOM    709  CG  LEU A  95     -14.762  32.946  -2.271  1.00 42.09           C  
ATOM    710  CD1 LEU A  95     -14.860  34.060  -1.197  1.00 38.44           C  
ATOM    711  CD2 LEU A  95     -15.589  31.719  -1.873  1.00 41.37           C  
ATOM    712  N   GLY A  96     -12.874  33.187  -5.887  1.00 42.38           N  
ATOM    713  CA  GLY A  96     -11.699  32.512  -6.417  1.00 42.85           C  
ATOM    714  C   GLY A  96     -10.561  33.430  -6.801  1.00 43.58           C  
ATOM    715  O   GLY A  96      -9.407  33.031  -6.725  1.00 44.04           O  
ATOM    716  N   GLU A  97     -10.887  34.639  -7.251  1.00 44.61           N  
ATOM    717  CA  GLU A  97      -9.903  35.718  -7.493  1.00 46.80           C  
ATOM    718  C   GLU A  97      -9.140  36.110  -6.214  1.00 46.74           C  
ATOM    719  O   GLU A  97      -7.926  36.350  -6.254  1.00 47.23           O  
ATOM    720  CB  GLU A  97     -10.594  36.959  -8.082  1.00 45.62           C  
ATOM    721  CG  GLU A  97     -11.140  36.752  -9.502  1.00 49.16           C  
ATOM    722  CD  GLU A  97     -11.899  37.964 -10.077  1.00 50.15           C  
ATOM    723  OE1 GLU A  97     -11.941  39.030  -9.426  1.00 54.43           O  
ATOM    724  OE2 GLU A  97     -12.474  37.846 -11.188  1.00 52.76           O  
ATOM    725  N   GLN A  98      -9.848  36.179  -5.087  1.00 46.65           N  
ATOM    726  CA  GLN A  98      -9.230  36.526  -3.804  1.00 46.40           C  
ATOM    727  C   GLN A  98      -8.184  35.512  -3.354  1.00 45.69           C  
ATOM    728  O   GLN A  98      -7.026  35.864  -3.131  1.00 46.02           O  
ATOM    729  CB  GLN A  98     -10.301  36.720  -2.730  1.00 46.53           C  
ATOM    730  CG  GLN A  98     -11.283  37.902  -3.010  1.00 47.07           C  
ATOM    731  CD  GLN A  98     -12.362  38.026  -1.927  1.00 49.54           C  
ATOM    732  OE1 GLN A  98     -12.105  37.818  -0.724  1.00 52.74           O  
ATOM    733  NE2 GLN A  98     -13.583  38.357  -2.351  1.00 55.20           N  
ATOM    734  N   VAL A  99      -8.572  34.243  -3.259  1.00 45.02           N  
ATOM    735  CA  VAL A  99      -7.646  33.195  -2.825  1.00 43.12           C  
ATOM    736  C   VAL A  99      -6.477  33.039  -3.785  1.00 43.09           C  
ATOM    737  O   VAL A  99      -5.357  32.760  -3.364  1.00 42.42           O  
ATOM    738  CB  VAL A  99      -8.356  31.835  -2.634  1.00 43.05           C  
ATOM    739  CG1 VAL A  99      -8.708  31.197  -3.956  1.00 41.59           C  
ATOM    740  CG2 VAL A  99      -7.505  30.888  -1.774  1.00 42.39           C  
ATOM    741  N   SER A 100      -6.756  33.212  -5.073  1.00 42.60           N  
ATOM    742  CA  SER A 100      -5.754  33.105  -6.112  1.00 42.90           C  
ATOM    743  C   SER A 100      -4.665  34.196  -5.954  1.00 42.18           C  
ATOM    744  O   SER A 100      -3.477  33.921  -6.142  1.00 41.72           O  
ATOM    745  CB  SER A 100      -6.432  33.191  -7.493  1.00 43.31           C  
ATOM    746  OG  SER A 100      -5.441  33.305  -8.518  1.00 46.11           O  
ATOM    747  N   ASP A 101      -5.073  35.412  -5.588  1.00 42.50           N  
ATOM    748  CA  ASP A 101      -4.126  36.491  -5.263  1.00 43.65           C  
ATOM    749  C   ASP A 101      -3.173  36.038  -4.104  1.00 43.60           C  
ATOM    750  O   ASP A 101      -1.981  36.339  -4.127  1.00 43.62           O  
ATOM    751  CB  ASP A 101      -4.869  37.762  -4.819  1.00 44.10           C  
ATOM    752  CG  ASP A 101      -5.640  38.476  -5.949  1.00 48.32           C  
ATOM    753  OD1 ASP A 101      -5.688  38.019  -7.123  1.00 51.70           O  
ATOM    754  OD2 ASP A 101      -6.246  39.534  -5.639  1.00 52.55           O  
HETATM  755  N   MLY A 102      -3.720  35.325  -3.110  1.00 42.38           N  
HETATM  756  CA  MLY A 102      -2.947  34.840  -1.958  1.00 42.28           C  
HETATM  757  CB  MLY A 102      -3.838  34.353  -0.805  1.00 41.76           C  
HETATM  758  CG  MLY A 102      -4.834  35.403  -0.256  1.00 41.68           C  
HETATM  759  CD  MLY A 102      -4.126  36.697   0.114  1.00 41.72           C  
HETATM  760  CE  MLY A 102      -5.019  37.608   0.937  1.00 45.20           C  
HETATM  761  NZ  MLY A 102      -4.763  39.027   0.634  1.00 53.33           N  
HETATM  762  CH1 MLY A 102      -3.608  39.575   1.411  1.00 49.68           C  
HETATM  763  CH2 MLY A 102      -5.985  39.842   0.907  1.00 53.89           C  
HETATM  764  C   MLY A 102      -2.012  33.717  -2.342  1.00 42.30           C  
HETATM  765  O   MLY A 102      -0.888  33.656  -1.855  1.00 41.88           O  
ATOM    766  N   VAL A 103      -2.474  32.824  -3.225  1.00 42.16           N  
ATOM    767  CA  VAL A 103      -1.689  31.692  -3.658  1.00 42.50           C  
ATOM    768  C   VAL A 103      -0.559  32.157  -4.549  1.00 42.83           C  
ATOM    769  O   VAL A 103       0.581  31.721  -4.363  1.00 42.62           O  
ATOM    770  CB  VAL A 103      -2.574  30.572  -4.311  1.00 43.64           C  
ATOM    771  CG1 VAL A 103      -1.708  29.505  -4.949  1.00 40.68           C  
ATOM    772  CG2 VAL A 103      -3.467  29.935  -3.241  1.00 42.97           C  
ATOM    773  N   ALA A 104      -0.873  33.085  -5.470  1.00 42.98           N  
ATOM    774  CA  ALA A 104       0.115  33.685  -6.381  1.00 43.02           C  
ATOM    775  C   ALA A 104       1.201  34.557  -5.755  1.00 42.38           C  
ATOM    776  O   ALA A 104       2.343  34.528  -6.189  1.00 43.09           O  
ATOM    777  CB  ALA A 104      -0.587  34.443  -7.540  1.00 42.89           C  
ATOM    778  N   ALA A 105       0.850  35.378  -4.783  1.00 42.66           N  
ATOM    779  CA  ALA A 105       1.863  36.086  -4.004  1.00 42.17           C  
ATOM    780  C   ALA A 105       2.874  35.091  -3.420  1.00 41.80           C  
ATOM    781  O   ALA A 105       4.080  35.296  -3.526  1.00 41.99           O  
ATOM    782  CB  ALA A 105       1.224  36.953  -2.892  1.00 41.32           C  
ATOM    783  N   LEU A 106       2.379  34.001  -2.843  1.00 41.60           N  
ATOM    784  CA  LEU A 106       3.251  32.960  -2.255  1.00 42.33           C  
ATOM    785  C   LEU A 106       4.102  32.213  -3.292  1.00 42.79           C  
ATOM    786  O   LEU A 106       5.310  32.041  -3.092  1.00 42.99           O  
ATOM    787  CB  LEU A 106       2.441  31.963  -1.406  1.00 41.83           C  
ATOM    788  CG  LEU A 106       3.136  30.781  -0.719  1.00 41.96           C  
ATOM    789  CD1 LEU A 106       4.078  31.234   0.376  1.00 38.84           C  
ATOM    790  CD2 LEU A 106       2.073  29.857  -0.184  1.00 43.37           C  
ATOM    791  N   ALA A 107       3.468  31.756  -4.370  1.00 43.19           N  
ATOM    792  CA  ALA A 107       4.157  31.110  -5.492  1.00 43.64           C  
ATOM    793  C   ALA A 107       5.250  32.021  -6.107  1.00 44.64           C  
ATOM    794  O   ALA A 107       6.394  31.586  -6.316  1.00 43.85           O  
ATOM    795  CB  ALA A 107       3.151  30.722  -6.558  1.00 43.03           C  
ATOM    796  N   ASP A 108       4.877  33.268  -6.406  1.00 44.51           N  
ATOM    797  CA  ASP A 108       5.844  34.272  -6.819  1.00 45.66           C  
ATOM    798  C   ASP A 108       6.985  34.480  -5.851  1.00 44.44           C  
ATOM    799  O   ASP A 108       8.126  34.591  -6.277  1.00 45.15           O  
ATOM    800  CB  ASP A 108       5.168  35.615  -7.122  1.00 46.45           C  
ATOM    801  CG  ASP A 108       4.376  35.575  -8.412  1.00 52.45           C  
ATOM    802  OD1 ASP A 108       4.278  34.462  -9.018  1.00 56.13           O  
ATOM    803  OD2 ASP A 108       3.846  36.653  -8.821  1.00 57.42           O  
ATOM    804  N   TRP A 109       6.695  34.560  -4.560  1.00 43.76           N  
ATOM    805  CA  TRP A 109       7.766  34.783  -3.577  1.00 43.55           C  
ATOM    806  C   TRP A 109       8.775  33.646  -3.636  1.00 42.95           C  
ATOM    807  O   TRP A 109       9.995  33.847  -3.497  1.00 41.66           O  
ATOM    808  CB  TRP A 109       7.214  34.903  -2.145  1.00 42.73           C  
ATOM    809  CG  TRP A 109       8.284  35.244  -1.134  1.00 42.75           C  
ATOM    810  CD1 TRP A 109       8.603  36.487  -0.667  1.00 41.86           C  
ATOM    811  CD2 TRP A 109       9.195  34.333  -0.488  1.00 42.60           C  
ATOM    812  NE1 TRP A 109       9.631  36.399   0.242  1.00 41.75           N  
ATOM    813  CE2 TRP A 109      10.013  35.094   0.364  1.00 40.81           C  
ATOM    814  CE3 TRP A 109       9.397  32.944  -0.552  1.00 41.16           C  
ATOM    815  CZ2 TRP A 109      11.017  34.520   1.146  1.00 43.09           C  
ATOM    816  CZ3 TRP A 109      10.407  32.387   0.211  1.00 42.33           C  
ATOM    817  CH2 TRP A 109      11.177  33.163   1.070  1.00 42.23           C  
ATOM    818  N   ILE A 110       8.240  32.449  -3.814  1.00 43.68           N  
ATOM    819  CA  ILE A 110       9.055  31.245  -3.820  1.00 45.99           C  
ATOM    820  C   ILE A 110       9.902  31.177  -5.101  1.00 47.19           C  
ATOM    821  O   ILE A 110      11.095  30.952  -5.016  1.00 47.80           O  
ATOM    822  CB  ILE A 110       8.213  29.979  -3.612  1.00 45.34           C  
ATOM    823  CG1 ILE A 110       7.618  29.972  -2.208  1.00 46.50           C  
ATOM    824  CG2 ILE A 110       9.050  28.740  -3.814  1.00 45.94           C  
ATOM    825  CD1 ILE A 110       6.767  28.769  -1.901  1.00 46.08           C  
ATOM    826  N   GLU A 111       9.298  31.419  -6.264  1.00 48.79           N  
ATOM    827  CA  GLU A 111      10.031  31.427  -7.531  1.00 51.43           C  
ATOM    828  C   GLU A 111      11.183  32.459  -7.496  1.00 51.21           C  
ATOM    829  O   GLU A 111      12.290  32.192  -7.922  1.00 52.06           O  
ATOM    830  CB  GLU A 111       9.063  31.680  -8.685  1.00 51.72           C  
ATOM    831  CG  GLU A 111       7.933  30.630  -8.815  1.00 53.57           C  
ATOM    832  CD  GLU A 111       6.861  31.018  -9.862  1.00 55.48           C  
ATOM    833  OE1 GLU A 111       6.435  32.212  -9.892  1.00 61.02           O  
ATOM    834  OE2 GLU A 111       6.419  30.130 -10.645  1.00 59.42           O  
ATOM    835  N   LEU A 112      10.914  33.613  -6.901  1.00 51.31           N  
ATOM    836  CA  LEU A 112      11.860  34.714  -6.753  1.00 50.16           C  
ATOM    837  C   LEU A 112      12.979  34.489  -5.727  1.00 49.66           C  
ATOM    838  O   LEU A 112      14.095  34.970  -5.921  1.00 49.55           O  
ATOM    839  CB  LEU A 112      11.030  35.944  -6.373  1.00 50.48           C  
ATOM    840  CG  LEU A 112      11.413  37.412  -6.165  1.00 51.69           C  
ATOM    841  CD1 LEU A 112      12.824  37.826  -6.613  1.00 53.64           C  
ATOM    842  CD2 LEU A 112      10.351  38.202  -6.931  1.00 52.03           C  
ATOM    843  N   ASN A 113      12.696  33.789  -4.622  1.00 48.89           N  
ATOM    844  CA  ASN A 113      13.701  33.613  -3.561  1.00 48.11           C  
ATOM    845  C   ASN A 113      14.310  32.219  -3.532  1.00 47.71           C  
ATOM    846  O   ASN A 113      15.026  31.853  -2.588  1.00 47.45           O  
ATOM    847  CB  ASN A 113      13.143  33.993  -2.177  1.00 47.83           C  
ATOM    848  CG  ASN A 113      12.927  35.495  -2.023  1.00 47.64           C  
ATOM    849  OD1 ASN A 113      13.741  36.196  -1.423  1.00 47.59           O  
ATOM    850  ND2 ASN A 113      11.833  35.987  -2.567  1.00 44.28           N  
ATOM    851  N   LEU A 114      14.009  31.448  -4.568  1.00 47.23           N  
ATOM    852  CA  LEU A 114      14.523  30.089  -4.719  1.00 47.43           C  
ATOM    853  C   LEU A 114      16.060  29.977  -4.602  1.00 47.72           C  
ATOM    854  O   LEU A 114      16.555  29.142  -3.841  1.00 47.32           O  
ATOM    855  CB  LEU A 114      13.986  29.459  -6.015  1.00 47.18           C  
ATOM    856  CG  LEU A 114      14.349  28.001  -6.315  1.00 48.01           C  
ATOM    857  CD1 LEU A 114      13.696  27.074  -5.281  1.00 47.87           C  
ATOM    858  CD2 LEU A 114      13.960  27.604  -7.750  1.00 46.16           C  
ATOM    859  N   PRO A 115      16.823  30.810  -5.349  1.00 48.02           N  
ATOM    860  CA  PRO A 115      18.289  30.690  -5.256  1.00 48.66           C  
ATOM    861  C   PRO A 115      18.879  30.793  -3.837  1.00 49.40           C  
ATOM    862  O   PRO A 115      19.818  30.068  -3.526  1.00 49.45           O  
ATOM    863  CB  PRO A 115      18.797  31.819  -6.163  1.00 48.23           C  
ATOM    864  CG  PRO A 115      17.701  31.954  -7.189  1.00 49.00           C  
ATOM    865  CD  PRO A 115      16.438  31.819  -6.350  1.00 48.29           C  
ATOM    866  N   GLN A 116      18.346  31.680  -3.001  1.00 50.05           N  
ATOM    867  CA  GLN A 116      18.778  31.768  -1.612  1.00 51.44           C  
ATOM    868  C   GLN A 116      18.381  30.514  -0.817  1.00 51.54           C  
ATOM    869  O   GLN A 116      19.139  30.064   0.047  1.00 51.67           O  
ATOM    870  CB  GLN A 116      18.226  33.025  -0.946  1.00 51.13           C  
ATOM    871  CG  GLN A 116      18.926  33.377   0.370  1.00 52.36           C  
ATOM    872  CD  GLN A 116      18.339  34.629   1.022  1.00 53.04           C  
ATOM    873  OE1 GLN A 116      17.633  35.419   0.358  1.00 53.93           O  
ATOM    874  NE2 GLN A 116      18.594  34.801   2.334  1.00 51.59           N  
ATOM    875  N   VAL A 117      17.215  29.942  -1.125  1.00 51.63           N  
ATOM    876  CA  VAL A 117      16.785  28.674  -0.512  1.00 52.24           C  
ATOM    877  C   VAL A 117      17.666  27.505  -0.948  1.00 52.74           C  
ATOM    878  O   VAL A 117      18.144  26.751  -0.123  1.00 53.10           O  
ATOM    879  CB  VAL A 117      15.278  28.339  -0.786  1.00 52.45           C  
ATOM    880  CG1 VAL A 117      14.952  26.874  -0.384  1.00 51.37           C  
ATOM    881  CG2 VAL A 117      14.365  29.345  -0.080  1.00 51.12           C  
ATOM    882  N   LEU A 118      17.869  27.365  -2.244  1.00 54.29           N  
ATOM    883  CA  LEU A 118      18.810  26.373  -2.787  1.00 56.35           C  
ATOM    884  C   LEU A 118      20.245  26.551  -2.275  1.00 57.14           C  
ATOM    885  O   LEU A 118      20.922  25.571  -2.007  1.00 57.23           O  
ATOM    886  CB  LEU A 118      18.798  26.379  -4.320  1.00 55.78           C  
ATOM    887  CG  LEU A 118      17.472  25.939  -4.927  1.00 56.32           C  
ATOM    888  CD1 LEU A 118      17.657  25.682  -6.430  1.00 56.26           C  
ATOM    889  CD2 LEU A 118      16.914  24.717  -4.204  1.00 54.74           C  
ATOM    890  N   ALA A 119      20.696  27.793  -2.134  1.00 58.99           N  
ATOM    891  CA  ALA A 119      22.034  28.066  -1.589  1.00 61.31           C  
ATOM    892  C   ALA A 119      22.113  27.676  -0.114  1.00 62.67           C  
ATOM    893  O   ALA A 119      23.194  27.608   0.464  1.00 62.94           O  
ATOM    894  CB  ALA A 119      22.412  29.533  -1.779  1.00 60.76           C  
ATOM    895  N   GLN A 120      20.956  27.420   0.483  1.00 64.81           N  
ATOM    896  CA  GLN A 120      20.861  27.067   1.907  1.00 66.84           C  
ATOM    897  C   GLN A 120      20.949  25.559   2.109  1.00 67.79           C  
ATOM    898  O   GLN A 120      21.608  25.090   3.035  1.00 67.95           O  
ATOM    899  CB  GLN A 120      19.553  27.589   2.501  1.00 66.65           C  
ATOM    900  CG  GLN A 120      19.567  27.629   3.999  1.00 68.52           C  
ATOM    901  CD  GLN A 120      20.335  28.815   4.528  1.00 71.20           C  
ATOM    902  OE1 GLN A 120      20.927  28.754   5.610  1.00 72.88           O  
ATOM    903  NE2 GLN A 120      20.327  29.913   3.770  1.00 72.05           N  
ATOM    904  N   ARG A 121      20.272  24.821   1.230  1.00 69.24           N  
ATOM    905  CA  ARG A 121      20.300  23.365   1.202  1.00 70.74           C  
ATOM    906  C   ARG A 121      21.672  22.890   0.687  1.00 71.60           C  
ATOM    907  O   ARG A 121      22.012  23.096  -0.474  1.00 72.00           O  
ATOM    908  CB  ARG A 121      19.128  22.837   0.345  1.00 70.35           C  
ATOM    909  CG  ARG A 121      17.766  23.467   0.725  1.00 70.65           C  
ATOM    910  CD  ARG A 121      16.538  22.937  -0.039  1.00 71.21           C  
ATOM    911  NE  ARG A 121      16.408  21.480   0.015  1.00 73.96           N  
ATOM    912  CZ  ARG A 121      15.753  20.781   0.949  1.00 74.27           C  
ATOM    913  NH1 ARG A 121      15.117  21.375   1.955  1.00 72.96           N  
ATOM    914  NH2 ARG A 121      15.740  19.457   0.872  1.00 74.74           N  
ATOM    915  N   GLU A 122      22.479  22.299   1.569  1.00 72.98           N  
ATOM    916  CA  GLU A 122      23.822  21.788   1.185  1.00 74.12           C  
ATOM    917  C   GLU A 122      24.281  20.574   1.994  1.00 74.42           C  
ATOM    918  O   GLU A 122      24.820  20.711   3.091  1.00 75.11           O  
ATOM    919  CB  GLU A 122      24.910  22.888   1.183  1.00 74.17           C  
ATOM    920  CG  GLU A 122      24.497  24.269   1.707  1.00 75.52           C  
ATOM    921  CD  GLU A 122      24.748  24.481   3.199  1.00 77.62           C  
ATOM    922  OE1 GLU A 122      24.748  23.497   3.979  1.00 79.15           O  
ATOM    923  OE2 GLU A 122      24.937  25.656   3.592  1.00 77.42           O  
TER     924      GLU A 122                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
