
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  151 ( 1212),  selected  151 , name 1wwr_D
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 1wwr_D.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    -       -      M      23           -
LGA    M     1_D      E      24          3.722
LGA    G     2_D      E      25          2.654
LGA    K     3_D      T      26          2.034
LGA    E     4_D      E      27          1.724
LGA    Y     5_D      K      28          1.320
LGA    F     6_D      W      29          0.946
LGA    L     7_D      M      30          0.951
LGA    K     8_D      E      31          0.842
LGA    V     9_D      E      32          0.747
LGA    A    10_D      A      33          0.681
LGA    L    11_D      M      34          0.990
LGA    R    12_D      H      35          1.370
LGA    E    13_D      M      36          1.273
LGA    A    14_D      A      37          0.829
LGA    K    15_D      K      38          1.071
LGA    R    16_D      E      39          1.191
LGA    A    17_D      A      40          0.736
LGA    F    18_D      L      41          0.848
LGA    E    19_D      E      42          1.317
LGA    K    20_D      N      43          0.866
LGA    G    21_D      T      44          0.861
LGA    E    22_D      E      45          0.519
LGA    V    23_D      V      46          0.744
LGA    P    24_D      P      47          0.632
LGA    V    25_D      V      48          0.586
LGA    G    26_D      G      49          0.586
LGA    A    27_D      C      50          0.896
LGA    I    28_D      L      51          0.802
LGA    I    29_D      M      52          0.471
LGA    V    30_D      V      53          0.772
LGA    K    31_D      Y      54          1.203
LGA    E    32_D      N      55          2.509
LGA    G    33_D      N      56          2.502
LGA    E    34_D      E      57          1.812
LGA    I    35_D      V      58          1.249
LGA    I    36_D      V      59          1.016
LGA    S    37_D      G      60          1.127
LGA    K    38_D      K      61          0.814
LGA    A    39_D      G      62          0.674
LGA    H    40_D      R      63          0.156
LGA    N    41_D      N      64          0.373
LGA    S    42_D      E      65          0.397
LGA    V    43_D      V      66          0.129
LGA    E    44_D      N      67          0.145
LGA    E    45_D      Q      68          0.290
LGA    L    46_D      T      69          0.358
LGA    K    47_D      K      70          0.508
LGA    D    48_D      N      71          0.409
LGA    P    49_D      A      72          0.175
LGA    T    50_D      T      73          0.160
LGA    A    51_D      R      74          0.332
LGA    H    52_D      H      75          0.171
LGA    A    53_D      A      76          0.219
LGA    E    54_D      E      77          0.346
LGA    M    55_D      M      78          0.707
LGA    L    56_D      V      79          0.772
LGA    A    57_D      A      80          0.481
LGA    I    58_D      I      81          0.949
LGA    K    59_D      D      82          1.218
LGA    E    60_D      Q      83          0.705
LGA    A    61_D      V      84          0.717
LGA    C    62_D      L      85          1.533
LGA    R    63_D      D      86          1.456
LGA    R    64_D      W      87          0.399
LGA    L    65_D      C      88          2.018
LGA    N    66_D      R      89          3.086
LGA    -       -      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    T    67_D      S      94          3.584
LGA    K    68_D      P      95          3.529
LGA    Y    69_D      S      96          2.884
LGA    -       -      E      97           -
LGA    -       -      V      98           -
LGA    L    70_D      F      99          0.702
LGA    E    71_D      E     100          1.279
LGA    G    72_D      H     101          0.336
LGA    C    73_D      T     102          0.205
LGA    E    74_D      V     103          0.581
LGA    L    75_D      L     104          0.507
LGA    Y    76_D      Y     105          0.609
LGA    V    77_D      V     106          0.617
LGA    T    78_D      T     107          0.210
LGA    L    79_D      V     108          0.167
LGA    E    80_D      E     109          0.229
LGA    P    81_D      P     110          0.274
LGA    C    82_D      C     111          0.252
LGA    I    83_D      I     112          0.266
LGA    M    84_D      M     113          0.276
LGA    C    85_D      C     114          0.245
LGA    S    86_D      A     115          0.257
LGA    Y    87_D      A     116          0.728
LGA    A    88_D      A     117          0.617
LGA    L    89_D      L     118          0.368
LGA    V    90_D      R     119          0.747
LGA    L    91_D      L     120          1.070
LGA    S    92_D      M     121          0.856
LGA    R    93_D      K     122          1.032
LGA    I    94_D      I     123          0.584
LGA    E    95_D      P     124          1.462
LGA    K    96_D      L     125          0.575
LGA    V    97_D      V     126          0.591
LGA    I    98_D      V     127          0.829
LGA    F    99_D      Y     128          0.704
LGA    S   100_D      G     129          0.330
LGA    A   101_D      C     130          0.524
LGA    L   102_D      Q     131          0.064
LGA    D   103_D      N     132          0.768
LGA    K   104_D      E     133          1.456
LGA    K   105_D      R     134          1.381
LGA    H   106_D      F     135          0.142
LGA    G   107_D      G     136          0.059
LGA    G   108_D      G     137          0.370
LGA    V   109_D      C     138          0.508
LGA    V   110_D      G     139          1.094
LGA    S   111_D      S     140          0.636
LGA    V   112_D      V     141          0.685
LGA    F   113_D      L     142          0.627
LGA    N   114_D      N     143          0.663
LGA    I   115_D      I     144          0.261
LGA    L   116_D      A     145          1.224
LGA    D   117_D      S     146          1.031
LGA    E   118_D      A     147          1.282
LGA    P   119_D      D     148          1.216
LGA    T   120_D      L     149          1.372
LGA    L   121_D      P     150          3.976
LGA    N   122_D      N     151          4.859
LGA    -       -      T     152           -
LGA    -       -      G     153           -
LGA    H   123_D      R     154          1.497
LGA    R   124_D      P     155          2.136
LGA    V   125_D      F     156          1.470
LGA    K   126_D      Q     157          1.435
LGA    W   127_D      C     158          1.321
LGA    E   128_D      I     159          1.270
LGA    Y   129_D      P     160          0.584
LGA    Y   130_D      G     161          2.660
LGA    P   131_D      Y     162          3.229
LGA    L   132_D      R     163          0.777
LGA    -       -      A     164           -
LGA    E   133_D      E     165          1.820
LGA    E   134_D      E     166          1.755
LGA    A   135_D      A     167          1.153
LGA    S   136_D      V     168          1.391
LGA    E   137_D      E     169          1.468
LGA    L   138_D      M     170          1.119
LGA    L   139_D      L     171          0.845
LGA    S   140_D      K     172          1.466
LGA    E   141_D      T     173          1.521
LGA    F   142_D      F     174          0.987
LGA    F   143_D      Y     175          1.782
LGA    K   144_D      K     176          2.658
LGA    K   145_D      -       -           -
LGA    L   146_D      Q     177          0.861
LGA    R   147_D      -       -           -
LGA    N   148_D      -       -           -
LGA    N   149_D      -       -           -
LGA    I   150_D      -       -           -
LGA    I   151_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  151  162    5.0    145    1.34    37.24     84.950    10.052

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.905043 * X  +   0.202289 * Y  +  -0.374135 * Z  +  17.388309
  Y_new =  -0.352607 * X  +  -0.135036 * Y  +  -0.925977 * Z  +  46.139355
  Z_new =  -0.237837 * X  +   0.969971 * Y  +  -0.050885 * Z  +  -4.898839 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.623208   -1.518384  [ DEG:    93.0030    -86.9970 ]
  Theta =   0.240138    2.901455  [ DEG:    13.7589    166.2411 ]
  Phi   =  -0.371511    2.770082  [ DEG:   -21.2860    158.7140 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wwr_D                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wwr_D.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  151  162   5.0  145   1.34   37.24  84.950
REMARK  ---------------------------------------------------------- 
MOLECULE 1wwr_D
HEADER    HYDROLASE                               12-JAN-05   1WWR              
TITLE     CRYSTAL STRUCTURE OF TRNA ADENOSINE DEAMINASE TADA FROM               
TITLE    2 AQUIFEX AEOLICUS                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRNA ADENOSINE DEAMINASE TADA;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: HYPOTHETICAL PROTEIN AQ_903;                                
COMPND   5 EC: 3.5.4.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3) CODONPLUS;                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28                                     
KEYWDS    HOMODIMER, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   2 RSGI, STRUCTURAL GENOMICS                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.KURATANI,R.ISHII,Y.BESSHO,R.FUKUNAGA,T.SENGOKU,S.SEKINE,            
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   2   26-APR-05 1WWR    1       JRNL                                     
REVDAT   1   01-FEB-05 1WWR    0                                                
JRNL        AUTH   M.KURATANI,R.ISHII,Y.BESSHO,R.FUKUNAGA,T.SENGOKU,            
JRNL        AUTH 2 M.SHIROUZU,S.SEKINE,S.YOKOYAMA                               
JRNL        TITL   CRYSTAL STRUCTURE OF TRNA ADENOSINE DEAMINASE                
JRNL        TITL 2 (TADA) FROM AQUIFEX AEOLICUS                                 
JRNL        REF    J.BIOL.CHEM.                  V. 280 16002 2005              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1WWR A    1   151  UNP    O67050   TADA_AQUAE       1    151             
DBREF  1WWR B    1   151  UNP    O67050   TADA_AQUAE       1    151             
DBREF  1WWR C    1   151  UNP    O67050   TADA_AQUAE       1    151             
DBREF  1WWR D    1   151  UNP    O67050   TADA_AQUAE       1    151             
SEQRES   1 A  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 A  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 A  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 A  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 A  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 A  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 A  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 A  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 A  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 A  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 A  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 A  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 A  171  ILE ILE                                                      
SEQRES   1 B  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 B  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 B  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 B  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 B  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 B  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 B  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 B  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 B  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 B  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 B  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 B  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 B  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 B  171  ILE ILE                                                      
SEQRES   1 C  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 C  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 C  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 C  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 C  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 C  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 C  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 C  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 C  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 C  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 C  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 C  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 C  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 C  171  ILE ILE                                                      
SEQRES   1 D  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 D  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 D  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 D  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 D  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 D  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 D  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 D  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 D  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 D  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 D  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 D  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 D  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 D  171  ILE ILE                                                      
HET     ZN  A 201       1                                                       
HET     ZN  B 202       1                                                       
HET     ZN  C 203       1                                                       
HET     ZN  D 204       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   5   ZN    4(ZN 2+)                                                     
FORMUL   9  HOH   *520(H2 O)                                                    
CRYST1   43.176  151.953   54.133  90.00 113.42  90.00 P 1 21 1      8          
ATOM   3763  N   MET D   1       8.796  28.976  49.219  1.00 46.58           N  
ATOM   3764  CA  MET D   1       9.127  28.556  47.827  1.00 46.71           C  
ATOM   3765  C   MET D   1       8.352  27.294  47.472  1.00 46.04           C  
ATOM   3766  O   MET D   1       8.825  26.176  47.696  1.00 47.40           O  
ATOM   3767  CB  MET D   1      10.627  28.294  47.701  1.00 49.09           C  
ATOM   3768  CG  MET D   1      11.489  29.452  48.171  1.00 52.63           C  
ATOM   3769  SD  MET D   1      13.227  29.004  48.264  1.00 59.42           S  
ATOM   3770  CE  MET D   1      13.964  30.210  47.170  1.00 57.72           C  
ATOM   3771  N   GLY D   2       7.157  27.483  46.922  1.00 42.53           N  
ATOM   3772  CA  GLY D   2       6.329  26.356  46.550  1.00 37.26           C  
ATOM   3773  C   GLY D   2       6.596  25.837  45.153  1.00 33.02           C  
ATOM   3774  O   GLY D   2       7.644  26.098  44.556  1.00 30.81           O  
ATOM   3775  N   LYS D   3       5.624  25.098  44.634  1.00 30.82           N  
ATOM   3776  CA  LYS D   3       5.713  24.511  43.304  1.00 29.85           C  
ATOM   3777  C   LYS D   3       5.811  25.615  42.264  1.00 29.06           C  
ATOM   3778  O   LYS D   3       6.557  25.516  41.291  1.00 23.78           O  
ATOM   3779  CB  LYS D   3       4.466  23.668  43.038  1.00 32.71           C  
ATOM   3780  CG  LYS D   3       4.100  22.737  44.187  1.00 35.86           C  
ATOM   3781  CD  LYS D   3       2.722  22.115  43.973  1.00 38.15           C  
ATOM   3782  CE  LYS D   3       2.300  21.255  45.158  1.00 40.36           C  
ATOM   3783  NZ  LYS D   3       3.248  20.140  45.414  1.00 40.67           N  
ATOM   3784  N   GLU D   4       5.057  26.684  42.480  1.00 27.70           N  
ATOM   3785  CA  GLU D   4       5.063  27.774  41.531  1.00 28.48           C  
ATOM   3786  C   GLU D   4       6.451  28.381  41.411  1.00 24.68           C  
ATOM   3787  O   GLU D   4       6.902  28.690  40.314  1.00 24.76           O  
ATOM   3788  CB  GLU D   4       4.042  28.829  41.942  1.00 30.46           C  
ATOM   3789  CG  GLU D   4       3.605  29.712  40.801  1.00 37.20           C  
ATOM   3790  CD  GLU D   4       2.349  30.484  41.130  1.00 38.95           C  
ATOM   3791  OE1 GLU D   4       1.356  29.842  41.529  1.00 40.03           O  
ATOM   3792  OE2 GLU D   4       2.356  31.724  40.984  1.00 42.69           O  
ATOM   3793  N   TYR D   5       7.140  28.526  42.537  1.00 24.84           N  
ATOM   3794  CA  TYR D   5       8.477  29.097  42.530  1.00 23.73           C  
ATOM   3795  C   TYR D   5       9.454  28.281  41.680  1.00 23.04           C  
ATOM   3796  O   TYR D   5      10.169  28.815  40.829  1.00 19.81           O  
ATOM   3797  CB  TYR D   5       9.018  29.205  43.961  1.00 27.48           C  
ATOM   3798  CG  TYR D   5      10.471  29.606  44.007  1.00 30.26           C  
ATOM   3799  CD1 TYR D   5      11.481  28.647  44.124  1.00 28.46           C  
ATOM   3800  CD2 TYR D   5      10.843  30.941  43.849  1.00 34.27           C  
ATOM   3801  CE1 TYR D   5      12.820  29.013  44.078  1.00 30.78           C  
ATOM   3802  CE2 TYR D   5      12.176  31.314  43.798  1.00 35.10           C  
ATOM   3803  CZ  TYR D   5      13.157  30.351  43.911  1.00 34.65           C  
ATOM   3804  OH  TYR D   5      14.472  30.734  43.834  1.00 39.73           O  
ATOM   3805  N   PHE D   6       9.495  26.980  41.927  1.00 19.46           N  
ATOM   3806  CA  PHE D   6      10.394  26.124  41.178  1.00 17.78           C  
ATOM   3807  C   PHE D   6      10.008  26.034  39.707  1.00 17.64           C  
ATOM   3808  O   PHE D   6      10.884  25.951  38.845  1.00 16.94           O  
ATOM   3809  CB  PHE D   6      10.455  24.742  41.836  1.00 17.31           C  
ATOM   3810  CG  PHE D   6      11.158  24.750  43.173  1.00 20.20           C  
ATOM   3811  CD1 PHE D   6      12.469  25.211  43.281  1.00 21.42           C  
ATOM   3812  CD2 PHE D   6      10.518  24.278  44.315  1.00 23.32           C  
ATOM   3813  CE1 PHE D   6      13.140  25.198  44.513  1.00 21.39           C  
ATOM   3814  CE2 PHE D   6      11.182  24.263  45.550  1.00 22.93           C  
ATOM   3815  CZ  PHE D   6      12.495  24.724  45.642  1.00 19.58           C  
ATOM   3816  N   LEU D   7       8.712  26.054  39.404  1.00 16.11           N  
ATOM   3817  CA  LEU D   7       8.304  26.012  38.005  1.00 17.57           C  
ATOM   3818  C   LEU D   7       8.787  27.292  37.317  1.00 18.73           C  
ATOM   3819  O   LEU D   7       9.162  27.262  36.149  1.00 15.19           O  
ATOM   3820  CB  LEU D   7       6.777  25.876  37.867  1.00 18.06           C  
ATOM   3821  CG  LEU D   7       6.210  24.494  38.217  1.00 20.37           C  
ATOM   3822  CD1 LEU D   7       4.689  24.522  38.226  1.00 19.21           C  
ATOM   3823  CD2 LEU D   7       6.721  23.476  37.205  1.00 19.82           C  
ATOM   3824  N   LYS D   8       8.795  28.403  38.053  1.00 18.47           N  
ATOM   3825  CA  LYS D   8       9.246  29.694  37.529  1.00 21.33           C  
ATOM   3826  C   LYS D   8      10.732  29.651  37.225  1.00 19.85           C  
ATOM   3827  O   LYS D   8      11.200  30.241  36.252  1.00 19.15           O  
ATOM   3828  CB  LYS D   8       8.982  30.806  38.543  1.00 26.49           C  
ATOM   3829  CG  LYS D   8       8.138  31.927  37.999  1.00 36.39           C  
ATOM   3830  CD  LYS D   8       6.765  31.432  37.613  1.00 36.97           C  
ATOM   3831  CE  LYS D   8       5.973  31.043  38.837  1.00 42.03           C  
ATOM   3832  NZ  LYS D   8       5.844  32.197  39.757  1.00 44.56           N  
ATOM   3833  N   VAL D   9      11.477  28.959  38.075  1.00 17.54           N  
ATOM   3834  CA  VAL D   9      12.908  28.805  37.871  1.00 17.08           C  
ATOM   3835  C   VAL D   9      13.096  27.975  36.596  1.00 15.03           C  
ATOM   3836  O   VAL D   9      13.944  28.280  35.762  1.00 16.66           O  
ATOM   3837  CB  VAL D   9      13.562  28.080  39.077  1.00 15.21           C  
ATOM   3838  CG1 VAL D   9      15.033  27.813  38.800  1.00 17.42           C  
ATOM   3839  CG2 VAL D   9      13.417  28.949  40.347  1.00 21.66           C  
ATOM   3840  N   ALA D  10      12.295  26.924  36.452  1.00 16.64           N  
ATOM   3841  CA  ALA D  10      12.381  26.069  35.273  1.00 16.14           C  
ATOM   3842  C   ALA D  10      12.008  26.859  34.021  1.00 15.89           C  
ATOM   3843  O   ALA D  10      12.575  26.640  32.947  1.00 14.74           O  
ATOM   3844  CB  ALA D  10      11.470  24.864  35.433  1.00 11.35           C  
ATOM   3845  N   LEU D  11      11.057  27.779  34.153  1.00 14.11           N  
ATOM   3846  CA  LEU D  11      10.649  28.602  33.012  1.00 15.76           C  
ATOM   3847  C   LEU D  11      11.769  29.541  32.544  1.00 15.26           C  
ATOM   3848  O   LEU D  11      11.760  29.987  31.392  1.00 14.41           O  
ATOM   3849  CB  LEU D  11       9.388  29.416  33.353  1.00 13.10           C  
ATOM   3850  CG  LEU D  11       8.000  28.776  33.161  1.00 17.18           C  
ATOM   3851  CD1 LEU D  11       7.792  28.387  31.693  1.00 16.40           C  
ATOM   3852  CD2 LEU D  11       7.846  27.564  34.029  1.00 30.19           C  
ATOM   3853  N   ARG D  12      12.725  29.857  33.420  1.00 15.78           N  
ATOM   3854  CA  ARG D  12      13.841  30.716  33.004  1.00 16.65           C  
ATOM   3855  C   ARG D  12      14.761  29.892  32.101  1.00 15.10           C  
ATOM   3856  O   ARG D  12      15.407  30.429  31.208  1.00 15.15           O  
ATOM   3857  CB  ARG D  12      14.656  31.239  34.202  1.00 17.47           C  
ATOM   3858  CG  ARG D  12      13.849  31.963  35.278  1.00 21.71           C  
ATOM   3859  CD  ARG D  12      12.990  33.082  34.730  1.00 28.74           C  
ATOM   3860  NE  ARG D  12      13.770  34.147  34.100  1.00 30.73           N  
ATOM   3861  CZ  ARG D  12      13.293  35.366  33.863  1.00 33.69           C  
ATOM   3862  NH1 ARG D  12      12.048  35.662  34.211  1.00 33.18           N  
ATOM   3863  NH2 ARG D  12      14.051  36.283  33.273  1.00 27.77           N  
ATOM   3864  N   GLU D  13      14.831  28.585  32.353  1.00 13.20           N  
ATOM   3865  CA  GLU D  13      15.653  27.698  31.539  1.00 13.94           C  
ATOM   3866  C   GLU D  13      14.975  27.517  30.188  1.00 12.21           C  
ATOM   3867  O   GLU D  13      15.633  27.391  29.159  1.00 13.05           O  
ATOM   3868  CB  GLU D  13      15.830  26.338  32.230  1.00 15.83           C  
ATOM   3869  CG  GLU D  13      16.883  26.360  33.329  1.00 23.09           C  
ATOM   3870  CD  GLU D  13      18.271  26.664  32.788  1.00 28.98           C  
ATOM   3871  OE1 GLU D  13      18.757  25.915  31.909  1.00 33.29           O  
ATOM   3872  OE2 GLU D  13      18.880  27.652  33.242  1.00 32.00           O  
ATOM   3873  N   ALA D  14      13.650  27.499  30.202  1.00 11.24           N  
ATOM   3874  CA  ALA D  14      12.882  27.374  28.967  1.00 12.77           C  
ATOM   3875  C   ALA D  14      13.126  28.641  28.151  1.00 12.41           C  
ATOM   3876  O   ALA D  14      13.288  28.590  26.933  1.00 14.08           O  
ATOM   3877  CB  ALA D  14      11.404  27.235  29.277  1.00  9.64           C  
ATOM   3878  N   LYS D  15      13.144  29.778  28.845  1.00 12.87           N  
ATOM   3879  CA  LYS D  15      13.388  31.081  28.209  1.00 14.23           C  
ATOM   3880  C   LYS D  15      14.767  31.071  27.551  1.00 15.74           C  
ATOM   3881  O   LYS D  15      14.928  31.530  26.425  1.00 15.75           O  
ATOM   3882  CB  LYS D  15      13.289  32.201  29.262  1.00 14.36           C  
ATOM   3883  CG  LYS D  15      13.691  33.605  28.778  1.00 13.25           C  
ATOM   3884  CD  LYS D  15      13.380  34.648  29.862  1.00 16.49           C  
ATOM   3885  CE  LYS D  15      13.831  36.066  29.490  1.00 13.40           C  
ATOM   3886  NZ  LYS D  15      15.320  36.162  29.323  1.00 14.56           N  
ATOM   3887  N   ARG D  16      15.760  30.538  28.261  1.00 15.22           N  
ATOM   3888  CA  ARG D  16      17.112  30.452  27.740  1.00 17.86           C  
ATOM   3889  C   ARG D  16      17.106  29.590  26.484  1.00 18.45           C  
ATOM   3890  O   ARG D  16      17.770  29.909  25.497  1.00 15.00           O  
ATOM   3891  CB  ARG D  16      18.037  29.825  28.783  1.00 19.97           C  
ATOM   3892  CG  ARG D  16      19.509  29.958  28.463  1.00 28.09           C  
ATOM   3893  CD  ARG D  16      20.346  29.270  29.524  1.00 32.23           C  
ATOM   3894  NE  ARG D  16      19.885  29.598  30.868  1.00 28.19           N  
ATOM   3895  CZ  ARG D  16      20.308  30.635  31.576  1.00 30.25           C  
ATOM   3896  NH1 ARG D  16      21.216  31.467  31.073  1.00 30.83           N  
ATOM   3897  NH2 ARG D  16      19.820  30.838  32.792  1.00 30.80           N  
ATOM   3898  N   ALA D  17      16.352  28.493  26.524  1.00 15.55           N  
ATOM   3899  CA  ALA D  17      16.276  27.597  25.377  1.00 15.12           C  
ATOM   3900  C   ALA D  17      15.705  28.351  24.188  1.00 15.62           C  
ATOM   3901  O   ALA D  17      16.206  28.241  23.077  1.00 13.65           O  
ATOM   3902  CB  ALA D  17      15.392  26.382  25.708  1.00 15.26           C  
ATOM   3903  N   PHE D  18      14.644  29.111  24.434  1.00 14.43           N  
ATOM   3904  CA  PHE D  18      13.988  29.894  23.386  1.00 17.58           C  
ATOM   3905  C   PHE D  18      14.989  30.855  22.733  1.00 16.61           C  
ATOM   3906  O   PHE D  18      15.043  30.983  21.509  1.00 14.21           O  
ATOM   3907  CB  PHE D  18      12.836  30.699  23.986  1.00 16.67           C  
ATOM   3908  CG  PHE D  18      11.915  31.295  22.962  1.00 19.87           C  
ATOM   3909  CD1 PHE D  18      10.790  30.597  22.529  1.00 24.69           C  
ATOM   3910  CD2 PHE D  18      12.167  32.551  22.427  1.00 23.05           C  
ATOM   3911  CE1 PHE D  18       9.924  31.146  21.574  1.00 24.33           C  
ATOM   3912  CE2 PHE D  18      11.308  33.108  21.473  1.00 22.84           C  
ATOM   3913  CZ  PHE D  18      10.187  32.403  21.049  1.00 23.47           C  
ATOM   3914  N   GLU D  19      15.778  31.522  23.568  1.00 15.86           N  
ATOM   3915  CA  GLU D  19      16.789  32.478  23.097  1.00 17.51           C  
ATOM   3916  C   GLU D  19      17.900  31.803  22.293  1.00 17.94           C  
ATOM   3917  O   GLU D  19      18.509  32.420  21.411  1.00 18.31           O  
ATOM   3918  CB  GLU D  19      17.381  33.231  24.298  1.00 14.90           C  
ATOM   3919  CG  GLU D  19      16.358  34.156  24.958  1.00 17.29           C  
ATOM   3920  CD  GLU D  19      16.784  34.703  26.313  1.00 17.66           C  
ATOM   3921  OE1 GLU D  19      15.901  35.259  27.008  1.00 18.63           O  
ATOM   3922  OE2 GLU D  19      17.979  34.586  26.688  1.00 15.76           O  
ATOM   3923  N   LYS D  20      18.149  30.526  22.573  1.00 15.86           N  
ATOM   3924  CA  LYS D  20      19.198  29.801  21.862  1.00 17.99           C  
ATOM   3925  C   LYS D  20      18.715  29.031  20.634  1.00 18.01           C  
ATOM   3926  O   LYS D  20      19.474  28.255  20.062  1.00 19.05           O  
ATOM   3927  CB  LYS D  20      19.923  28.839  22.819  1.00 20.33           C  
ATOM   3928  CG  LYS D  20      20.788  29.533  23.879  1.00 26.03           C  
ATOM   3929  CD  LYS D  20      21.265  28.545  24.945  1.00 26.22           C  
ATOM   3930  CE  LYS D  20      22.075  29.241  26.031  1.00 33.89           C  
ATOM   3931  NZ  LYS D  20      23.319  29.862  25.491  1.00 36.44           N  
ATOM   3932  N   GLY D  21      17.460  29.245  20.240  1.00 16.85           N  
ATOM   3933  CA  GLY D  21      16.915  28.571  19.069  1.00 19.05           C  
ATOM   3934  C   GLY D  21      16.452  27.134  19.285  1.00 21.02           C  
ATOM   3935  O   GLY D  21      16.301  26.366  18.324  1.00 19.00           O  
ATOM   3936  N   GLU D  22      16.221  26.781  20.548  1.00 17.11           N  
ATOM   3937  CA  GLU D  22      15.774  25.438  20.938  1.00 18.22           C  
ATOM   3938  C   GLU D  22      14.276  25.392  21.218  1.00 18.19           C  
ATOM   3939  O   GLU D  22      13.639  26.433  21.362  1.00 15.87           O  
ATOM   3940  CB  GLU D  22      16.504  25.023  22.224  1.00 13.64           C  
ATOM   3941  CG  GLU D  22      18.024  25.122  22.140  1.00 14.16           C  
ATOM   3942  CD  GLU D  22      18.675  23.919  21.460  1.00 15.05           C  
ATOM   3943  OE1 GLU D  22      17.948  23.063  20.920  1.00 17.01           O  
ATOM   3944  OE2 GLU D  22      19.926  23.841  21.469  1.00 18.35           O  
ATOM   3945  N   VAL D  23      13.709  24.184  21.282  1.00 14.95           N  
ATOM   3946  CA  VAL D  23      12.302  24.036  21.661  1.00 16.10           C  
ATOM   3947  C   VAL D  23      12.400  24.577  23.092  1.00 14.85           C  
ATOM   3948  O   VAL D  23      13.271  24.147  23.848  1.00 17.13           O  
ATOM   3949  CB  VAL D  23      11.882  22.556  21.684  1.00 17.93           C  
ATOM   3950  CG1 VAL D  23      10.462  22.438  22.178  1.00 15.66           C  
ATOM   3951  CG2 VAL D  23      12.003  21.962  20.280  1.00 19.37           C  
ATOM   3952  N   PRO D  24      11.507  25.501  23.488  1.00 15.31           N  
ATOM   3953  CA  PRO D  24      11.561  26.092  24.831  1.00 14.45           C  
ATOM   3954  C   PRO D  24      11.083  25.303  26.030  1.00 14.07           C  
ATOM   3955  O   PRO D  24      10.009  25.572  26.567  1.00 12.49           O  
ATOM   3956  CB  PRO D  24      10.789  27.391  24.654  1.00 14.48           C  
ATOM   3957  CG  PRO D  24       9.687  26.964  23.734  1.00 16.54           C  
ATOM   3958  CD  PRO D  24      10.429  26.117  22.693  1.00 14.63           C  
ATOM   3959  N   VAL D  25      11.889  24.340  26.456  1.00 12.15           N  
ATOM   3960  CA  VAL D  25      11.534  23.536  27.627  1.00 12.21           C  
ATOM   3961  C   VAL D  25      12.670  23.600  28.638  1.00 11.89           C  
ATOM   3962  O   VAL D  25      13.846  23.467  28.286  1.00 12.41           O  
ATOM   3963  CB  VAL D  25      11.288  22.065  27.262  1.00 11.85           C  
ATOM   3964  CG1 VAL D  25      10.900  21.286  28.508  1.00 12.44           C  
ATOM   3965  CG2 VAL D  25      10.190  21.958  26.213  1.00 16.56           C  
ATOM   3966  N   GLY D  26      12.301  23.818  29.896  1.00 11.66           N  
ATOM   3967  CA  GLY D  26      13.277  23.890  30.967  1.00 10.02           C  
ATOM   3968  C   GLY D  26      12.935  22.896  32.073  1.00 10.33           C  
ATOM   3969  O   GLY D  26      11.774  22.532  32.261  1.00 10.52           O  
ATOM   3970  N   ALA D  27      13.950  22.457  32.809  1.00 11.02           N  
ATOM   3971  CA  ALA D  27      13.740  21.513  33.899  1.00 13.17           C  
ATOM   3972  C   ALA D  27      14.767  21.710  34.996  1.00 12.28           C  
ATOM   3973  O   ALA D  27      15.893  22.114  34.724  1.00 12.62           O  
ATOM   3974  CB  ALA D  27      13.832  20.092  33.377  1.00 13.24           C  
ATOM   3975  N   ILE D  28      14.365  21.448  36.239  1.00 12.79           N  
ATOM   3976  CA  ILE D  28      15.287  21.533  37.364  1.00 11.27           C  
ATOM   3977  C   ILE D  28      14.962  20.368  38.289  1.00 10.74           C  
ATOM   3978  O   ILE D  28      13.844  19.861  38.294  1.00 10.54           O  
ATOM   3979  CB  ILE D  28      15.178  22.878  38.169  1.00 13.28           C  
ATOM   3980  CG1 ILE D  28      13.850  22.974  38.924  1.00 14.97           C  
ATOM   3981  CG2 ILE D  28      15.352  24.066  37.232  1.00 15.35           C  
ATOM   3982  CD1 ILE D  28      13.792  24.184  39.892  1.00 13.73           C  
ATOM   3983  N   ILE D  29      15.958  19.899  39.028  1.00 12.56           N  
ATOM   3984  CA  ILE D  29      15.740  18.808  39.974  1.00 11.64           C  
ATOM   3985  C   ILE D  29      15.961  19.453  41.340  1.00 13.72           C  
ATOM   3986  O   ILE D  29      16.937  20.177  41.540  1.00 13.51           O  
ATOM   3987  CB  ILE D  29      16.761  17.658  39.781  1.00 14.33           C  
ATOM   3988  CG1 ILE D  29      16.561  16.996  38.407  1.00 18.35           C  
ATOM   3989  CG2 ILE D  29      16.606  16.624  40.910  1.00 16.75           C  
ATOM   3990  CD1 ILE D  29      15.487  15.946  38.378  1.00 22.65           C  
ATOM   3991  N   VAL D  30      15.047  19.198  42.262  1.00 13.41           N  
ATOM   3992  CA  VAL D  30      15.127  19.772  43.592  1.00 17.67           C  
ATOM   3993  C   VAL D  30      15.144  18.659  44.627  1.00 15.72           C  
ATOM   3994  O   VAL D  30      14.519  17.620  44.456  1.00 14.54           O  
ATOM   3995  CB  VAL D  30      13.914  20.704  43.862  1.00 20.32           C  
ATOM   3996  CG1 VAL D  30      14.022  21.323  45.250  1.00 23.79           C  
ATOM   3997  CG2 VAL D  30      13.849  21.801  42.805  1.00 18.74           C  
ATOM   3998  N   LYS D  31      15.910  18.862  45.688  1.00 16.54           N  
ATOM   3999  CA  LYS D  31      15.970  17.887  46.751  1.00 18.08           C  
ATOM   4000  C   LYS D  31      15.916  18.649  48.062  1.00 18.11           C  
ATOM   4001  O   LYS D  31      16.801  19.448  48.357  1.00 16.20           O  
ATOM   4002  CB  LYS D  31      17.261  17.077  46.704  1.00 18.32           C  
ATOM   4003  CG  LYS D  31      17.251  15.957  47.734  1.00 18.65           C  
ATOM   4004  CD  LYS D  31      18.551  15.194  47.777  1.00 21.31           C  
ATOM   4005  CE  LYS D  31      18.423  14.014  48.724  1.00 26.42           C  
ATOM   4006  NZ  LYS D  31      19.713  13.296  48.889  1.00 30.57           N  
ATOM   4007  N   GLU D  32      14.862  18.399  48.828  1.00 19.29           N  
ATOM   4008  CA  GLU D  32      14.672  19.034  50.122  1.00 22.40           C  
ATOM   4009  C   GLU D  32      14.883  20.542  50.078  1.00 22.76           C  
ATOM   4010  O   GLU D  32      15.675  21.093  50.844  1.00 22.85           O  
ATOM   4011  CB  GLU D  32      15.598  18.380  51.147  1.00 23.76           C  
ATOM   4012  CG  GLU D  32      15.498  16.867  51.113  1.00 29.15           C  
ATOM   4013  CD  GLU D  32      16.217  16.184  52.254  1.00 30.83           C  
ATOM   4014  OE1 GLU D  32      17.329  16.618  52.618  1.00 31.23           O  
ATOM   4015  OE2 GLU D  32      15.666  15.195  52.776  1.00 36.38           O  
ATOM   4016  N   GLY D  33      14.165  21.187  49.159  1.00 21.91           N  
ATOM   4017  CA  GLY D  33      14.208  22.629  49.007  1.00 20.82           C  
ATOM   4018  C   GLY D  33      15.407  23.203  48.298  1.00 21.72           C  
ATOM   4019  O   GLY D  33      15.461  24.407  48.043  1.00 22.99           O  
ATOM   4020  N   GLU D  34      16.362  22.345  47.962  1.00 20.08           N  
ATOM   4021  CA  GLU D  34      17.577  22.789  47.303  1.00 18.86           C  
ATOM   4022  C   GLU D  34      17.579  22.456  45.818  1.00 17.85           C  
ATOM   4023  O   GLU D  34      17.248  21.337  45.434  1.00 15.10           O  
ATOM   4024  CB  GLU D  34      18.762  22.106  47.969  1.00 22.60           C  
ATOM   4025  CG  GLU D  34      20.062  22.846  47.894  1.00 32.05           C  
ATOM   4026  CD  GLU D  34      21.095  22.214  48.804  1.00 37.27           C  
ATOM   4027  OE1 GLU D  34      21.555  21.094  48.489  1.00 38.27           O  
ATOM   4028  OE2 GLU D  34      21.427  22.830  49.841  1.00 37.79           O  
ATOM   4029  N   ILE D  35      17.950  23.420  44.984  1.00 17.97           N  
ATOM   4030  CA  ILE D  35      18.011  23.143  43.555  1.00 18.17           C  
ATOM   4031  C   ILE D  35      19.324  22.400  43.284  1.00 17.13           C  
ATOM   4032  O   ILE D  35      20.418  22.905  43.543  1.00 20.22           O  
ATOM   4033  CB  ILE D  35      17.910  24.439  42.736  1.00 18.37           C  
ATOM   4034  CG1 ILE D  35      16.546  25.097  42.978  1.00 19.12           C  
ATOM   4035  CG2 ILE D  35      18.048  24.124  41.249  1.00 19.97           C  
ATOM   4036  CD1 ILE D  35      16.408  26.474  42.335  1.00 20.33           C  
ATOM   4037  N   ILE D  36      19.205  21.175  42.785  1.00 17.27           N  
ATOM   4038  CA  ILE D  36      20.365  20.336  42.506  1.00 15.83           C  
ATOM   4039  C   ILE D  36      20.927  20.536  41.098  1.00 19.75           C  
ATOM   4040  O   ILE D  36      22.150  20.616  40.911  1.00 16.69           O  
ATOM   4041  CB  ILE D  36      20.003  18.854  42.709  1.00 14.27           C  
ATOM   4042  CG1 ILE D  36      19.432  18.659  44.116  1.00 16.46           C  
ATOM   4043  CG2 ILE D  36      21.244  17.975  42.515  1.00 19.77           C  
ATOM   4044  CD1 ILE D  36      20.383  19.132  45.234  1.00 19.14           C  
ATOM   4045  N   SER D  37      20.035  20.615  40.113  1.00 13.27           N  
ATOM   4046  CA  SER D  37      20.456  20.832  38.735  1.00 14.01           C  
ATOM   4047  C   SER D  37      19.412  21.632  37.962  1.00 11.94           C  
ATOM   4048  O   SER D  37      18.247  21.697  38.351  1.00 12.01           O  
ATOM   4049  CB  SER D  37      20.676  19.491  38.022  1.00 16.21           C  
ATOM   4050  OG  SER D  37      19.446  18.793  37.863  1.00 15.45           O  
ATOM   4051  N   LYS D  38      19.848  22.244  36.870  1.00 12.52           N  
ATOM   4052  CA  LYS D  38      18.964  23.010  36.004  1.00 13.16           C  
ATOM   4053  C   LYS D  38      19.435  22.699  34.597  1.00 12.81           C  
ATOM   4054  O   LYS D  38      20.626  22.513  34.360  1.00 13.63           O  
ATOM   4055  CB  LYS D  38      19.097  24.521  36.247  1.00 14.11           C  
ATOM   4056  CG  LYS D  38      18.909  24.960  37.681  1.00 17.17           C  
ATOM   4057  CD  LYS D  38      18.690  26.477  37.765  1.00 22.35           C  
ATOM   4058  CE  LYS D  38      19.706  27.242  36.924  1.00 26.80           C  
ATOM   4059  NZ  LYS D  38      21.114  26.770  37.126  1.00 32.57           N  
ATOM   4060  N   ALA D  39      18.511  22.618  33.659  1.00 11.05           N  
ATOM   4061  CA  ALA D  39      18.897  22.334  32.282  1.00 10.87           C  
ATOM   4062  C   ALA D  39      17.785  22.751  31.338  1.00 11.60           C  
ATOM   4063  O   ALA D  39      16.668  23.037  31.774  1.00 13.21           O  
ATOM   4064  CB  ALA D  39      19.176  20.836  32.119  1.00  9.06           C  
ATOM   4065  N   HIS D  40      18.097  22.790  30.048  1.00 13.01           N  
ATOM   4066  CA  HIS D  40      17.094  23.121  29.042  1.00 14.18           C  
ATOM   4067  C   HIS D  40      17.309  22.241  27.819  1.00 11.62           C  
ATOM   4068  O   HIS D  40      18.379  21.650  27.627  1.00 15.28           O  
ATOM   4069  CB  HIS D  40      17.167  24.606  28.656  1.00 16.55           C  
ATOM   4070  CG  HIS D  40      18.455  25.000  28.005  1.00 17.71           C  
ATOM   4071  ND1 HIS D  40      18.696  24.829  26.657  1.00 19.82           N  
ATOM   4072  CD2 HIS D  40      19.587  25.528  28.526  1.00 17.20           C  
ATOM   4073  CE1 HIS D  40      19.922  25.237  26.378  1.00 16.88           C  
ATOM   4074  NE2 HIS D  40      20.483  25.665  27.495  1.00 22.31           N  
ATOM   4075  N   ASN D  41      16.267  22.124  27.004  1.00 13.44           N  
ATOM   4076  CA  ASN D  41      16.336  21.330  25.787  1.00 12.50           C  
ATOM   4077  C   ASN D  41      17.490  21.883  24.946  1.00 15.68           C  
ATOM   4078  O   ASN D  41      17.501  23.070  24.588  1.00 15.74           O  
ATOM   4079  CB  ASN D  41      14.999  21.449  25.029  1.00 14.76           C  
ATOM   4080  CG  ASN D  41      14.910  20.500  23.839  1.00 16.07           C  
ATOM   4081  OD1 ASN D  41      13.918  19.771  23.675  1.00 22.75           O  
ATOM   4082  ND2 ASN D  41      15.925  20.522  22.996  1.00 16.13           N  
ATOM   4083  N   SER D  42      18.455  21.026  24.625  1.00 13.29           N  
ATOM   4084  CA  SER D  42      19.623  21.455  23.868  1.00 13.19           C  
ATOM   4085  C   SER D  42      19.884  20.580  22.641  1.00 13.13           C  
ATOM   4086  O   SER D  42      21.030  20.389  22.233  1.00 15.69           O  
ATOM   4087  CB  SER D  42      20.839  21.443  24.796  1.00 14.55           C  
ATOM   4088  OG  SER D  42      20.565  22.130  26.014  1.00 15.34           O  
ATOM   4089  N   VAL D  43      18.815  20.058  22.054  1.00 13.30           N  
ATOM   4090  CA  VAL D  43      18.927  19.194  20.879  1.00 13.21           C  
ATOM   4091  C   VAL D  43      19.697  19.854  19.734  1.00 15.89           C  
ATOM   4092  O   VAL D  43      20.573  19.233  19.129  1.00 17.20           O  
ATOM   4093  CB  VAL D  43      17.534  18.739  20.393  1.00 13.48           C  
ATOM   4094  CG1 VAL D  43      17.656  17.966  19.067  1.00 14.39           C  
ATOM   4095  CG2 VAL D  43      16.898  17.832  21.460  1.00 13.89           C  
ATOM   4096  N   GLU D  44      19.395  21.114  19.443  1.00 16.95           N  
ATOM   4097  CA  GLU D  44      20.103  21.791  18.363  1.00 19.20           C  
ATOM   4098  C   GLU D  44      21.576  22.064  18.670  1.00 20.07           C  
ATOM   4099  O   GLU D  44      22.456  21.796  17.849  1.00 20.46           O  
ATOM   4100  CB  GLU D  44      19.392  23.103  18.005  1.00 20.86           C  
ATOM   4101  CG  GLU D  44      17.944  22.890  17.589  1.00 23.07           C  
ATOM   4102  CD  GLU D  44      17.806  21.939  16.407  1.00 25.92           C  
ATOM   4103  OE1 GLU D  44      16.829  21.166  16.385  1.00 22.93           O  
ATOM   4104  OE2 GLU D  44      18.665  21.970  15.498  1.00 25.11           O  
ATOM   4105  N   GLU D  45      21.849  22.607  19.848  1.00 18.27           N  
ATOM   4106  CA  GLU D  45      23.216  22.922  20.230  1.00 20.39           C  
ATOM   4107  C   GLU D  45      24.131  21.696  20.212  1.00 22.38           C  
ATOM   4108  O   GLU D  45      25.243  21.733  19.671  1.00 19.55           O  
ATOM   4109  CB  GLU D  45      23.237  23.546  21.627  1.00 22.14           C  
ATOM   4110  CG  GLU D  45      24.598  24.063  22.043  1.00 28.59           C  
ATOM   4111  CD  GLU D  45      24.610  24.597  23.454  1.00 31.72           C  
ATOM   4112  OE1 GLU D  45      23.652  25.301  23.831  1.00 36.17           O  
ATOM   4113  OE2 GLU D  45      25.583  24.322  24.186  1.00 34.42           O  
ATOM   4114  N   LEU D  46      23.651  20.603  20.790  1.00 19.73           N  
ATOM   4115  CA  LEU D  46      24.443  19.386  20.874  1.00 19.78           C  
ATOM   4116  C   LEU D  46      24.238  18.408  19.717  1.00 18.85           C  
ATOM   4117  O   LEU D  46      24.924  17.400  19.663  1.00 21.22           O  
ATOM   4118  CB  LEU D  46      24.132  18.662  22.193  1.00 18.03           C  
ATOM   4119  CG  LEU D  46      24.336  19.455  23.492  1.00 22.25           C  
ATOM   4120  CD1 LEU D  46      23.800  18.658  24.675  1.00 18.58           C  
ATOM   4121  CD2 LEU D  46      25.825  19.762  23.673  1.00 20.12           C  
ATOM   4122  N   LYS D  47      23.319  18.711  18.802  1.00 19.50           N  
ATOM   4123  CA  LYS D  47      23.006  17.814  17.678  1.00 23.21           C  
ATOM   4124  C   LYS D  47      22.759  16.424  18.250  1.00 24.16           C  
ATOM   4125  O   LYS D  47      23.328  15.429  17.792  1.00 25.09           O  
ATOM   4126  CB  LYS D  47      24.160  17.760  16.667  1.00 26.53           C  
ATOM   4127  CG  LYS D  47      24.362  19.039  15.894  1.00 29.92           C  
ATOM   4128  CD  LYS D  47      25.280  18.817  14.702  1.00 35.56           C  
ATOM   4129  CE  LYS D  47      25.642  20.134  14.040  1.00 37.82           C  
ATOM   4130  NZ  LYS D  47      26.437  20.998  14.957  1.00 40.84           N  
ATOM   4131  N   ASP D  48      21.898  16.378  19.260  1.00 21.63           N  
ATOM   4132  CA  ASP D  48      21.568  15.152  19.980  1.00 20.00           C  
ATOM   4133  C   ASP D  48      20.057  15.157  20.202  1.00 18.83           C  
ATOM   4134  O   ASP D  48      19.544  15.925  21.012  1.00 17.12           O  
ATOM   4135  CB  ASP D  48      22.320  15.166  21.314  1.00 21.92           C  
ATOM   4136  CG  ASP D  48      22.079  13.924  22.163  1.00 21.20           C  
ATOM   4137  OD1 ASP D  48      22.753  13.809  23.214  1.00 17.72           O  
ATOM   4138  OD2 ASP D  48      21.233  13.077  21.797  1.00 19.40           O  
ATOM   4139  N   PRO D  49      19.326  14.287  19.492  1.00 18.75           N  
ATOM   4140  CA  PRO D  49      17.869  14.239  19.643  1.00 14.90           C  
ATOM   4141  C   PRO D  49      17.399  13.797  21.032  1.00 15.43           C  
ATOM   4142  O   PRO D  49      16.224  13.925  21.355  1.00 18.36           O  
ATOM   4143  CB  PRO D  49      17.452  13.260  18.537  1.00 14.14           C  
ATOM   4144  CG  PRO D  49      18.562  12.247  18.595  1.00 15.75           C  
ATOM   4145  CD  PRO D  49      19.799  13.166  18.652  1.00 17.93           C  
ATOM   4146  N   THR D  50      18.306  13.287  21.862  1.00 17.97           N  
ATOM   4147  CA  THR D  50      17.912  12.842  23.196  1.00 14.37           C  
ATOM   4148  C   THR D  50      18.240  13.889  24.251  1.00 14.22           C  
ATOM   4149  O   THR D  50      17.966  13.689  25.431  1.00 15.48           O  
ATOM   4150  CB  THR D  50      18.622  11.526  23.607  1.00 18.24           C  
ATOM   4151  OG1 THR D  50      20.024  11.774  23.820  1.00 17.84           O  
ATOM   4152  CG2 THR D  50      18.452  10.464  22.532  1.00 18.79           C  
ATOM   4153  N   ALA D  51      18.825  15.002  23.821  1.00 15.75           N  
ATOM   4154  CA  ALA D  51      19.222  16.056  24.750  1.00 15.48           C  
ATOM   4155  C   ALA D  51      18.054  16.901  25.253  1.00 15.55           C  
ATOM   4156  O   ALA D  51      18.097  18.129  25.178  1.00 14.40           O  
ATOM   4157  CB  ALA D  51      20.287  16.949  24.098  1.00 14.25           C  
ATOM   4158  N   HIS D  52      17.007  16.241  25.751  1.00 13.15           N  
ATOM   4159  CA  HIS D  52      15.858  16.952  26.290  1.00 11.92           C  
ATOM   4160  C   HIS D  52      16.243  17.505  27.665  1.00 11.17           C  
ATOM   4161  O   HIS D  52      17.157  17.003  28.309  1.00 10.26           O  
ATOM   4162  CB  HIS D  52      14.629  16.037  26.408  1.00 12.42           C  
ATOM   4163  CG  HIS D  52      14.010  15.691  25.090  1.00 11.61           C  
ATOM   4164  ND1 HIS D  52      12.844  14.968  24.988  1.00 12.63           N  
ATOM   4165  CD2 HIS D  52      14.407  15.940  23.821  1.00 14.21           C  
ATOM   4166  CE1 HIS D  52      12.549  14.783  23.714  1.00 14.31           C  
ATOM   4167  NE2 HIS D  52      13.482  15.362  22.985  1.00 11.43           N  
ATOM   4168  N   ALA D  53      15.542  18.542  28.108  1.00  9.53           N  
ATOM   4169  CA  ALA D  53      15.856  19.168  29.392  1.00 11.78           C  
ATOM   4170  C   ALA D  53      15.925  18.189  30.547  1.00 10.55           C  
ATOM   4171  O   ALA D  53      16.874  18.225  31.351  1.00  9.95           O  
ATOM   4172  CB  ALA D  53      14.829  20.258  29.704  1.00 10.14           C  
ATOM   4173  N   GLU D  54      14.914  17.330  30.644  1.00 10.77           N  
ATOM   4174  CA  GLU D  54      14.835  16.355  31.731  1.00  9.55           C  
ATOM   4175  C   GLU D  54      16.046  15.419  31.744  1.00 10.50           C  
ATOM   4176  O   GLU D  54      16.617  15.149  32.800  1.00 11.14           O  
ATOM   4177  CB  GLU D  54      13.562  15.503  31.622  1.00  8.55           C  
ATOM   4178  CG  GLU D  54      12.233  16.270  31.565  1.00 10.59           C  
ATOM   4179  CD  GLU D  54      11.827  16.591  30.138  1.00 11.17           C  
ATOM   4180  OE1 GLU D  54      10.699  16.217  29.758  1.00 14.96           O  
ATOM   4181  OE2 GLU D  54      12.630  17.214  29.396  1.00 12.09           O  
ATOM   4182  N   MET D  55      16.424  14.928  30.569  1.00 12.57           N  
ATOM   4183  CA  MET D  55      17.568  14.021  30.463  1.00 13.33           C  
ATOM   4184  C   MET D  55      18.837  14.711  30.970  1.00 15.14           C  
ATOM   4185  O   MET D  55      19.618  14.119  31.735  1.00 15.06           O  
ATOM   4186  CB  MET D  55      17.757  13.571  29.006  1.00 13.30           C  
ATOM   4187  CG  MET D  55      16.534  12.871  28.418  1.00 13.72           C  
ATOM   4188  SD  MET D  55      16.195  11.269  29.220  1.00 17.99           S  
ATOM   4189  CE  MET D  55      17.275  10.216  28.262  1.00 21.50           C  
ATOM   4190  N   LEU D  56      19.046  15.958  30.552  1.00 12.16           N  
ATOM   4191  CA  LEU D  56      20.220  16.701  30.997  1.00 12.42           C  
ATOM   4192  C   LEU D  56      20.162  16.991  32.498  1.00 13.28           C  
ATOM   4193  O   LEU D  56      21.173  16.854  33.195  1.00 13.97           O  
ATOM   4194  CB  LEU D  56      20.364  18.008  30.202  1.00  8.82           C  
ATOM   4195  CG  LEU D  56      20.628  17.817  28.696  1.00 13.12           C  
ATOM   4196  CD1 LEU D  56      20.670  19.170  27.984  1.00 16.25           C  
ATOM   4197  CD2 LEU D  56      21.930  17.079  28.506  1.00 19.48           C  
ATOM   4198  N   ALA D  57      18.989  17.386  32.996  1.00 11.34           N  
ATOM   4199  CA  ALA D  57      18.822  17.665  34.432  1.00 12.53           C  
ATOM   4200  C   ALA D  57      19.120  16.403  35.251  1.00 12.81           C  
ATOM   4201  O   ALA D  57      19.836  16.453  36.270  1.00 10.64           O  
ATOM   4202  CB  ALA D  57      17.407  18.159  34.718  1.00 15.44           C  
ATOM   4203  N   ILE D  58      18.590  15.267  34.799  1.00 12.31           N  
ATOM   4204  CA  ILE D  58      18.841  14.006  35.497  1.00 12.62           C  
ATOM   4205  C   ILE D  58      20.341  13.696  35.504  1.00 14.25           C  
ATOM   4206  O   ILE D  58      20.934  13.392  36.550  1.00 12.67           O  
ATOM   4207  CB  ILE D  58      18.051  12.829  34.827  1.00 13.85           C  
ATOM   4208  CG1 ILE D  58      16.548  13.027  35.050  1.00 15.31           C  
ATOM   4209  CG2 ILE D  58      18.479  11.483  35.435  1.00 17.02           C  
ATOM   4210  CD1 ILE D  58      15.676  11.984  34.381  1.00 17.04           C  
ATOM   4211  N   LYS D  59      20.963  13.794  34.339  1.00 12.54           N  
ATOM   4212  CA  LYS D  59      22.386  13.518  34.227  1.00 16.51           C  
ATOM   4213  C   LYS D  59      23.222  14.372  35.179  1.00 16.95           C  
ATOM   4214  O   LYS D  59      24.101  13.851  35.882  1.00 13.35           O  
ATOM   4215  CB  LYS D  59      22.835  13.729  32.777  1.00 16.82           C  
ATOM   4216  CG  LYS D  59      24.305  13.441  32.487  1.00 28.53           C  
ATOM   4217  CD  LYS D  59      24.527  13.212  30.976  1.00 29.57           C  
ATOM   4218  CE  LYS D  59      25.991  12.924  30.652  1.00 33.70           C  
ATOM   4219  NZ  LYS D  59      26.148  12.427  29.252  1.00 35.90           N  
ATOM   4220  N   GLU D  60      22.925  15.670  35.229  1.00 14.44           N  
ATOM   4221  CA  GLU D  60      23.676  16.587  36.084  1.00 15.47           C  
ATOM   4222  C   GLU D  60      23.411  16.386  37.578  1.00 14.17           C  
ATOM   4223  O   GLU D  60      24.331  16.520  38.397  1.00 13.48           O  
ATOM   4224  CB  GLU D  60      23.394  18.040  35.673  1.00 16.88           C  
ATOM   4225  CG  GLU D  60      24.072  19.096  36.552  1.00 20.33           C  
ATOM   4226  CD  GLU D  60      25.596  19.087  36.474  1.00 26.23           C  
ATOM   4227  OE1 GLU D  60      26.221  19.814  37.280  1.00 28.00           O  
ATOM   4228  OE2 GLU D  60      26.172  18.376  35.617  1.00 24.47           O  
ATOM   4229  N   ALA D  61      22.170  16.063  37.938  1.00 10.58           N  
ATOM   4230  CA  ALA D  61      21.837  15.828  39.342  1.00 13.49           C  
ATOM   4231  C   ALA D  61      22.555  14.565  39.821  1.00 13.80           C  
ATOM   4232  O   ALA D  61      23.076  14.516  40.938  1.00 16.02           O  
ATOM   4233  CB  ALA D  61      20.318  15.665  39.518  1.00 13.65           C  
ATOM   4234  N   CYS D  62      22.585  13.549  38.962  1.00 16.54           N  
ATOM   4235  CA  CYS D  62      23.238  12.285  39.285  1.00 18.42           C  
ATOM   4236  C   CYS D  62      24.733  12.498  39.487  1.00 20.47           C  
ATOM   4237  O   CYS D  62      25.349  11.863  40.349  1.00 20.79           O  
ATOM   4238  CB  CYS D  62      23.001  11.260  38.164  1.00 17.60           C  
ATOM   4239  SG  CYS D  62      21.337  10.576  38.131  1.00 15.21           S  
ATOM   4240  N   ARG D  63      25.311  13.390  38.688  1.00 19.19           N  
ATOM   4241  CA  ARG D  63      26.724  13.709  38.793  1.00 21.80           C  
ATOM   4242  C   ARG D  63      26.970  14.467  40.094  1.00 23.70           C  
ATOM   4243  O   ARG D  63      27.901  14.156  40.840  1.00 22.36           O  
ATOM   4244  CB  ARG D  63      27.170  14.570  37.608  1.00 25.25           C  
ATOM   4245  CG  ARG D  63      28.673  14.806  37.551  1.00 28.80           C  
ATOM   4246  CD  ARG D  63      29.023  15.821  36.478  1.00 29.42           C  
ATOM   4247  NE  ARG D  63      28.592  17.165  36.847  1.00 34.14           N  
ATOM   4248  CZ  ARG D  63      29.120  17.875  37.840  1.00 35.77           C  
ATOM   4249  NH1 ARG D  63      30.110  17.374  38.572  1.00 38.94           N  
ATOM   4250  NH2 ARG D  63      28.659  19.089  38.102  1.00 33.82           N  
ATOM   4251  N   ARG D  64      26.130  15.455  40.382  1.00 22.96           N  
ATOM   4252  CA  ARG D  64      26.306  16.235  41.602  1.00 25.20           C  
ATOM   4253  C   ARG D  64      26.055  15.453  42.899  1.00 24.93           C  
ATOM   4254  O   ARG D  64      26.775  15.644  43.879  1.00 24.64           O  
ATOM   4255  CB  ARG D  64      25.433  17.491  41.560  1.00 26.43           C  
ATOM   4256  CG  ARG D  64      25.927  18.542  40.558  1.00 31.35           C  
ATOM   4257  CD  ARG D  64      25.299  19.903  40.833  1.00 39.24           C  
ATOM   4258  NE  ARG D  64      25.885  20.971  40.026  1.00 45.48           N  
ATOM   4259  CZ  ARG D  64      25.582  22.262  40.155  1.00 49.01           C  
ATOM   4260  NH1 ARG D  64      24.692  22.652  41.061  1.00 50.17           N  
ATOM   4261  NH2 ARG D  64      26.179  23.168  39.388  1.00 49.03           N  
ATOM   4262  N   LEU D  65      25.057  14.571  42.909  1.00 20.82           N  
ATOM   4263  CA  LEU D  65      24.757  13.783  44.104  1.00 22.93           C  
ATOM   4264  C   LEU D  65      25.551  12.473  44.119  1.00 22.66           C  
ATOM   4265  O   LEU D  65      25.415  11.655  45.038  1.00 22.37           O  
ATOM   4266  CB  LEU D  65      23.252  13.495  44.195  1.00 21.23           C  
ATOM   4267  CG  LEU D  65      22.375  14.747  44.320  1.00 22.94           C  
ATOM   4268  CD1 LEU D  65      20.905  14.364  44.194  1.00 24.10           C  
ATOM   4269  CD2 LEU D  65      22.641  15.447  45.651  1.00 27.47           C  
ATOM   4270  N   ASN D  66      26.369  12.287  43.088  1.00 19.90           N  
ATOM   4271  CA  ASN D  66      27.222  11.104  42.952  1.00 23.67           C  
ATOM   4272  C   ASN D  66      26.440   9.802  43.137  1.00 23.14           C  
ATOM   4273  O   ASN D  66      26.858   8.908  43.876  1.00 23.25           O  
ATOM   4274  CB  ASN D  66      28.367  11.199  43.977  1.00 21.25           C  
ATOM   4275  CG  ASN D  66      29.565  10.327  43.621  1.00 24.22           C  
ATOM   4276  OD1 ASN D  66      29.739   9.908  42.476  1.00 21.65           O  
ATOM   4277  ND2 ASN D  66      30.413  10.073  44.610  1.00 24.47           N  
ATOM   4278  N   THR D  67      25.314   9.690  42.440  1.00 21.00           N  
ATOM   4279  CA  THR D  67      24.460   8.513  42.543  1.00 21.44           C  
ATOM   4280  C   THR D  67      23.698   8.288  41.239  1.00 20.36           C  
ATOM   4281  O   THR D  67      23.478   9.223  40.482  1.00 18.14           O  
ATOM   4282  CB  THR D  67      23.441   8.708  43.680  1.00 21.95           C  
ATOM   4283  OG1 THR D  67      22.505   7.625  43.689  1.00 25.43           O  
ATOM   4284  CG2 THR D  67      22.693  10.017  43.485  1.00 25.44           C  
ATOM   4285  N   LYS D  68      23.294   7.053  40.975  1.00 19.05           N  
ATOM   4286  CA  LYS D  68      22.543   6.794  39.752  1.00 19.22           C  
ATOM   4287  C   LYS D  68      21.054   6.930  40.022  1.00 18.69           C  
ATOM   4288  O   LYS D  68      20.253   6.996  39.090  1.00 19.19           O  
ATOM   4289  CB  LYS D  68      22.841   5.395  39.208  1.00 21.70           C  
ATOM   4290  CG  LYS D  68      22.485   4.278  40.159  1.00 28.87           C  
ATOM   4291  CD  LYS D  68      22.413   2.940  39.430  1.00 29.14           C  
ATOM   4292  CE  LYS D  68      22.157   1.812  40.423  1.00 30.89           C  
ATOM   4293  NZ  LYS D  68      21.689   0.565  39.763  1.00 33.13           N  
ATOM   4294  N   TYR D  69      20.691   6.978  41.305  1.00 19.73           N  
ATOM   4295  CA  TYR D  69      19.300   7.100  41.727  1.00 19.47           C  
ATOM   4296  C   TYR D  69      19.041   8.431  42.422  1.00 20.06           C  
ATOM   4297  O   TYR D  69      19.798   8.850  43.302  1.00 21.08           O  
ATOM   4298  CB  TYR D  69      18.918   5.971  42.685  1.00 23.43           C  
ATOM   4299  CG  TYR D  69      18.921   4.596  42.073  1.00 24.48           C  
ATOM   4300  CD1 TYR D  69      18.401   4.379  40.803  1.00 25.78           C  
ATOM   4301  CD2 TYR D  69      19.379   3.491  42.797  1.00 27.68           C  
ATOM   4302  CE1 TYR D  69      18.321   3.097  40.264  1.00 28.79           C  
ATOM   4303  CE2 TYR D  69      19.305   2.201  42.267  1.00 29.83           C  
ATOM   4304  CZ  TYR D  69      18.769   2.012  41.001  1.00 30.84           C  
ATOM   4305  OH  TYR D  69      18.631   0.738  40.485  1.00 30.58           O  
ATOM   4306  N   LEU D  70      17.955   9.084  42.035  1.00 15.29           N  
ATOM   4307  CA  LEU D  70      17.618  10.374  42.610  1.00 17.06           C  
ATOM   4308  C   LEU D  70      16.477  10.241  43.607  1.00 19.40           C  
ATOM   4309  O   LEU D  70      15.469  10.940  43.521  1.00 13.05           O  
ATOM   4310  CB  LEU D  70      17.253  11.349  41.490  1.00 16.17           C  
ATOM   4311  CG  LEU D  70      18.408  11.639  40.523  1.00 14.11           C  
ATOM   4312  CD1 LEU D  70      17.919  12.500  39.356  1.00 14.52           C  
ATOM   4313  CD2 LEU D  70      19.528  12.337  41.270  1.00 14.26           C  
ATOM   4314  N   GLU D  71      16.651   9.329  44.562  1.00 20.82           N  
ATOM   4315  CA  GLU D  71      15.652   9.104  45.599  1.00 23.62           C  
ATOM   4316  C   GLU D  71      15.374  10.419  46.329  1.00 21.82           C  
ATOM   4317  O   GLU D  71      16.293  11.180  46.597  1.00 23.14           O  
ATOM   4318  CB  GLU D  71      16.178   8.091  46.621  1.00 29.00           C  
ATOM   4319  CG  GLU D  71      16.844   6.864  46.034  1.00 39.22           C  
ATOM   4320  CD  GLU D  71      15.859   5.904  45.410  1.00 43.20           C  
ATOM   4321  OE1 GLU D  71      16.195   4.702  45.298  1.00 47.49           O  
ATOM   4322  OE2 GLU D  71      14.756   6.350  45.025  1.00 48.75           O  
ATOM   4323  N   GLY D  72      14.105  10.686  46.638  1.00 18.99           N  
ATOM   4324  CA  GLY D  72      13.752  11.895  47.364  1.00 19.59           C  
ATOM   4325  C   GLY D  72      13.899  13.207  46.617  1.00 19.27           C  
ATOM   4326  O   GLY D  72      13.852  14.275  47.227  1.00 22.07           O  
ATOM   4327  N   CYS D  73      14.098  13.133  45.304  1.00 14.17           N  
ATOM   4328  CA  CYS D  73      14.244  14.330  44.485  1.00 14.42           C  
ATOM   4329  C   CYS D  73      12.981  14.524  43.677  1.00 13.68           C  
ATOM   4330  O   CYS D  73      12.298  13.551  43.347  1.00 13.94           O  
ATOM   4331  CB  CYS D  73      15.405  14.197  43.495  1.00 14.71           C  
ATOM   4332  SG  CYS D  73      17.060  14.148  44.192  1.00 16.67           S  
ATOM   4333  N   GLU D  74      12.698  15.779  43.341  1.00 14.33           N  
ATOM   4334  CA  GLU D  74      11.534  16.133  42.531  1.00 13.94           C  
ATOM   4335  C   GLU D  74      12.013  16.819  41.269  1.00 12.57           C  
ATOM   4336  O   GLU D  74      12.985  17.568  41.293  1.00 14.48           O  
ATOM   4337  CB  GLU D  74      10.623  17.114  43.255  1.00 18.21           C  
ATOM   4338  CG  GLU D  74      10.031  16.608  44.547  1.00 26.82           C  
ATOM   4339  CD  GLU D  74       9.037  17.601  45.105  1.00 32.19           C  
ATOM   4340  OE1 GLU D  74       7.820  17.359  44.971  1.00 39.60           O  
ATOM   4341  OE2 GLU D  74       9.476  18.632  45.658  1.00 40.30           O  
ATOM   4342  N   LEU D  75      11.337  16.557  40.158  1.00 13.12           N  
ATOM   4343  CA  LEU D  75      11.711  17.203  38.914  1.00 13.28           C  
ATOM   4344  C   LEU D  75      10.605  18.165  38.523  1.00 13.31           C  
ATOM   4345  O   LEU D  75       9.431  17.788  38.486  1.00 11.99           O  
ATOM   4346  CB  LEU D  75      11.932  16.159  37.818  1.00 15.16           C  
ATOM   4347  CG  LEU D  75      12.346  16.563  36.395  1.00 19.66           C  
ATOM   4348  CD1 LEU D  75      11.130  16.914  35.575  1.00 20.43           C  
ATOM   4349  CD2 LEU D  75      13.325  17.706  36.425  1.00 22.80           C  
ATOM   4350  N   TYR D  76      10.987  19.412  38.261  1.00 12.92           N  
ATOM   4351  CA  TYR D  76      10.041  20.426  37.824  1.00 14.37           C  
ATOM   4352  C   TYR D  76      10.379  20.663  36.355  1.00 13.96           C  
ATOM   4353  O   TYR D  76      11.533  20.933  36.028  1.00 14.95           O  
ATOM   4354  CB  TYR D  76      10.215  21.716  38.628  1.00 15.24           C  
ATOM   4355  CG  TYR D  76       9.733  21.601  40.063  1.00 16.93           C  
ATOM   4356  CD1 TYR D  76      10.558  21.085  41.065  1.00 15.50           C  
ATOM   4357  CD2 TYR D  76       8.426  21.941  40.399  1.00 17.91           C  
ATOM   4358  CE1 TYR D  76      10.086  20.908  42.370  1.00 18.19           C  
ATOM   4359  CE2 TYR D  76       7.943  21.764  41.686  1.00 15.99           C  
ATOM   4360  CZ  TYR D  76       8.774  21.250  42.667  1.00 20.51           C  
ATOM   4361  OH  TYR D  76       8.283  21.073  43.937  1.00 22.71           O  
ATOM   4362  N   VAL D  77       9.386  20.549  35.474  1.00 12.27           N  
ATOM   4363  CA  VAL D  77       9.629  20.740  34.039  1.00 11.37           C  
ATOM   4364  C   VAL D  77       8.472  21.543  33.440  1.00 10.99           C  
ATOM   4365  O   VAL D  77       7.315  21.371  33.820  1.00 12.99           O  
ATOM   4366  CB  VAL D  77       9.815  19.359  33.341  1.00 11.73           C  
ATOM   4367  CG1 VAL D  77       8.563  18.501  33.519  1.00 13.02           C  
ATOM   4368  CG2 VAL D  77      10.167  19.542  31.872  1.00 12.74           C  
ATOM   4369  N   THR D  78       8.789  22.425  32.504  1.00 10.86           N  
ATOM   4370  CA  THR D  78       7.782  23.305  31.923  1.00 13.00           C  
ATOM   4371  C   THR D  78       6.736  22.652  31.020  1.00 14.20           C  
ATOM   4372  O   THR D  78       5.649  23.196  30.833  1.00 16.85           O  
ATOM   4373  CB  THR D  78       8.478  24.478  31.185  1.00 14.76           C  
ATOM   4374  OG1 THR D  78       9.237  23.990  30.071  1.00 13.07           O  
ATOM   4375  CG2 THR D  78       9.428  25.200  32.141  1.00 16.10           C  
ATOM   4376  N   LEU D  79       7.053  21.479  30.481  1.00 10.40           N  
ATOM   4377  CA  LEU D  79       6.143  20.757  29.606  1.00 11.60           C  
ATOM   4378  C   LEU D  79       6.096  19.295  30.039  1.00 11.22           C  
ATOM   4379  O   LEU D  79       7.110  18.740  30.463  1.00 12.19           O  
ATOM   4380  CB  LEU D  79       6.630  20.838  28.152  1.00 11.96           C  
ATOM   4381  CG  LEU D  79       5.881  20.010  27.101  1.00 10.90           C  
ATOM   4382  CD1 LEU D  79       4.438  20.468  27.000  1.00 15.39           C  
ATOM   4383  CD2 LEU D  79       6.579  20.159  25.759  1.00 14.74           C  
ATOM   4384  N   GLU D  80       4.913  18.692  29.939  1.00  9.48           N  
ATOM   4385  CA  GLU D  80       4.733  17.276  30.274  1.00 11.59           C  
ATOM   4386  C   GLU D  80       5.861  16.489  29.604  1.00 11.00           C  
ATOM   4387  O   GLU D  80       6.056  16.588  28.402  1.00 12.12           O  
ATOM   4388  CB  GLU D  80       3.389  16.780  29.721  1.00 15.77           C  
ATOM   4389  CG  GLU D  80       3.137  15.293  29.950  1.00 16.50           C  
ATOM   4390  CD  GLU D  80       1.950  14.763  29.161  1.00 16.18           C  
ATOM   4391  OE1 GLU D  80       1.644  13.566  29.297  1.00 13.25           O  
ATOM   4392  OE2 GLU D  80       1.337  15.536  28.395  1.00 18.52           O  
ATOM   4393  N   PRO D  81       6.620  15.689  30.377  1.00 13.97           N  
ATOM   4394  CA  PRO D  81       7.713  14.912  29.778  1.00 10.70           C  
ATOM   4395  C   PRO D  81       7.272  13.929  28.683  1.00 12.08           C  
ATOM   4396  O   PRO D  81       6.197  13.321  28.766  1.00 11.33           O  
ATOM   4397  CB  PRO D  81       8.348  14.208  30.981  1.00 14.34           C  
ATOM   4398  CG  PRO D  81       7.283  14.199  32.012  1.00 17.72           C  
ATOM   4399  CD  PRO D  81       6.602  15.537  31.842  1.00 11.54           C  
ATOM   4400  N   CYS D  82       8.107  13.779  27.660  1.00 11.46           N  
ATOM   4401  CA  CYS D  82       7.791  12.885  26.556  1.00 13.35           C  
ATOM   4402  C   CYS D  82       7.934  11.445  27.024  1.00 14.14           C  
ATOM   4403  O   CYS D  82       8.301  11.185  28.164  1.00 14.89           O  
ATOM   4404  CB  CYS D  82       8.715  13.142  25.367  1.00 12.25           C  
ATOM   4405  SG  CYS D  82      10.425  12.533  25.537  1.00 14.78           S  
ATOM   4406  N   ILE D  83       7.636  10.503  26.141  1.00 12.68           N  
ATOM   4407  CA  ILE D  83       7.718   9.106  26.494  1.00 13.55           C  
ATOM   4408  C   ILE D  83       9.115   8.709  26.964  1.00 14.37           C  
ATOM   4409  O   ILE D  83       9.256   8.040  27.988  1.00 16.01           O  
ATOM   4410  CB  ILE D  83       7.263   8.254  25.292  1.00 16.28           C  
ATOM   4411  CG1 ILE D  83       5.770   8.494  25.086  1.00 15.41           C  
ATOM   4412  CG2 ILE D  83       7.593   6.785  25.515  1.00 14.38           C  
ATOM   4413  CD1 ILE D  83       5.241   8.073  23.754  1.00 18.72           C  
ATOM   4414  N   MET D  84      10.140   9.140  26.236  1.00 14.05           N  
ATOM   4415  CA  MET D  84      11.523   8.827  26.612  1.00 13.18           C  
ATOM   4416  C   MET D  84      11.858   9.374  28.003  1.00 15.54           C  
ATOM   4417  O   MET D  84      12.368   8.645  28.865  1.00 13.07           O  
ATOM   4418  CB  MET D  84      12.505   9.413  25.590  1.00 12.75           C  
ATOM   4419  CG  MET D  84      13.995   9.266  25.967  1.00 15.44           C  
ATOM   4420  SD  MET D  84      15.116  10.126  24.833  1.00 14.75           S  
ATOM   4421  CE  MET D  84      14.721  11.858  25.204  1.00 18.37           C  
ATOM   4422  N   CYS D  85      11.554  10.651  28.230  1.00 11.64           N  
ATOM   4423  CA  CYS D  85      11.869  11.267  29.512  1.00 12.71           C  
ATOM   4424  C   CYS D  85      11.035  10.711  30.652  1.00 12.76           C  
ATOM   4425  O   CYS D  85      11.516  10.624  31.775  1.00 11.81           O  
ATOM   4426  CB  CYS D  85      11.718  12.796  29.423  1.00  9.47           C  
ATOM   4427  SG  CYS D  85      12.997  13.531  28.371  1.00 13.83           S  
ATOM   4428  N   SER D  86       9.795  10.326  30.366  1.00  9.21           N  
ATOM   4429  CA  SER D  86       8.943   9.774  31.400  1.00 11.24           C  
ATOM   4430  C   SER D  86       9.544   8.482  31.962  1.00 11.12           C  
ATOM   4431  O   SER D  86       9.543   8.276  33.171  1.00 13.36           O  
ATOM   4432  CB  SER D  86       7.533   9.494  30.854  1.00 12.83           C  
ATOM   4433  OG  SER D  86       6.866  10.696  30.513  1.00 13.46           O  
ATOM   4434  N   TYR D  87      10.065   7.620  31.090  1.00 12.03           N  
ATOM   4435  CA  TYR D  87      10.646   6.372  31.575  1.00 14.01           C  
ATOM   4436  C   TYR D  87      11.984   6.625  32.254  1.00 12.30           C  
ATOM   4437  O   TYR D  87      12.379   5.896  33.170  1.00 12.69           O  
ATOM   4438  CB  TYR D  87      10.804   5.349  30.447  1.00 14.19           C  
ATOM   4439  CG  TYR D  87      10.996   3.957  31.022  1.00 16.46           C  
ATOM   4440  CD1 TYR D  87       9.997   3.369  31.803  1.00 17.41           C  
ATOM   4441  CD2 TYR D  87      12.189   3.257  30.836  1.00 16.96           C  
ATOM   4442  CE1 TYR D  87      10.179   2.121  32.387  1.00 19.65           C  
ATOM   4443  CE2 TYR D  87      12.382   2.001  31.416  1.00 19.01           C  
ATOM   4444  CZ  TYR D  87      11.371   1.443  32.192  1.00 20.70           C  
ATOM   4445  OH  TYR D  87      11.549   0.208  32.780  1.00 23.10           O  
ATOM   4446  N   ALA D  88      12.696   7.649  31.799  1.00 11.59           N  
ATOM   4447  CA  ALA D  88      13.965   8.012  32.427  1.00 11.90           C  
ATOM   4448  C   ALA D  88      13.698   8.382  33.892  1.00 13.53           C  
ATOM   4449  O   ALA D  88      14.546   8.152  34.759  1.00 12.71           O  
ATOM   4450  CB  ALA D  88      14.601   9.187  31.693  1.00 11.46           C  
ATOM   4451  N   LEU D  89      12.532   8.980  34.166  1.00 11.30           N  
ATOM   4452  CA  LEU D  89      12.158   9.344  35.540  1.00 13.05           C  
ATOM   4453  C   LEU D  89      12.048   8.053  36.362  1.00 14.97           C  
ATOM   4454  O   LEU D  89      12.459   7.995  37.533  1.00 13.16           O  
ATOM   4455  CB  LEU D  89      10.791  10.045  35.575  1.00 13.71           C  
ATOM   4456  CG  LEU D  89      10.605  11.320  34.749  1.00 13.72           C  
ATOM   4457  CD1 LEU D  89       9.201  11.874  34.994  1.00 15.25           C  
ATOM   4458  CD2 LEU D  89      11.663  12.349  35.150  1.00 18.85           C  
ATOM   4459  N   VAL D  90      11.464   7.034  35.741  1.00 13.90           N  
ATOM   4460  CA  VAL D  90      11.293   5.735  36.386  1.00 14.62           C  
ATOM   4461  C   VAL D  90      12.665   5.124  36.662  1.00 15.14           C  
ATOM   4462  O   VAL D  90      12.935   4.693  37.776  1.00 14.64           O  
ATOM   4463  CB  VAL D  90      10.486   4.760  35.504  1.00 16.13           C  
ATOM   4464  CG1 VAL D  90      10.451   3.360  36.158  1.00 16.64           C  
ATOM   4465  CG2 VAL D  90       9.060   5.297  35.300  1.00 16.35           C  
ATOM   4466  N   LEU D  91      13.521   5.091  35.640  1.00 14.83           N  
ATOM   4467  CA  LEU D  91      14.869   4.539  35.766  1.00 16.31           C  
ATOM   4468  C   LEU D  91      15.674   5.270  36.846  1.00 16.13           C  
ATOM   4469  O   LEU D  91      16.483   4.662  37.554  1.00 15.76           O  
ATOM   4470  CB  LEU D  91      15.609   4.642  34.422  1.00 16.87           C  
ATOM   4471  CG  LEU D  91      15.781   3.427  33.492  1.00 23.16           C  
ATOM   4472  CD1 LEU D  91      14.855   2.304  33.870  1.00 18.98           C  
ATOM   4473  CD2 LEU D  91      15.597   3.857  32.051  1.00 14.27           C  
ATOM   4474  N   SER D  92      15.437   6.574  36.973  1.00 16.91           N  
ATOM   4475  CA  SER D  92      16.143   7.412  37.951  1.00 20.12           C  
ATOM   4476  C   SER D  92      15.570   7.350  39.371  1.00 15.79           C  
ATOM   4477  O   SER D  92      16.170   7.861  40.317  1.00 16.27           O  
ATOM   4478  CB  SER D  92      16.116   8.875  37.488  1.00 18.79           C  
ATOM   4479  OG  SER D  92      16.856   9.039  36.294  1.00 33.76           O  
ATOM   4480  N   ARG D  93      14.407   6.737  39.511  1.00 16.65           N  
ATOM   4481  CA  ARG D  93      13.743   6.641  40.809  1.00 16.27           C  
ATOM   4482  C   ARG D  93      13.381   8.005  41.406  1.00 15.16           C  
ATOM   4483  O   ARG D  93      13.358   8.181  42.629  1.00 15.21           O  
ATOM   4484  CB  ARG D  93      14.600   5.836  41.798  1.00 18.82           C  
ATOM   4485  CG  ARG D  93      14.675   4.375  41.460  1.00 21.71           C  
ATOM   4486  CD  ARG D  93      15.450   3.626  42.520  1.00 29.35           C  
ATOM   4487  NE  ARG D  93      15.495   2.196  42.251  1.00 33.55           N  
ATOM   4488  CZ  ARG D  93      16.073   1.308  43.054  1.00 35.29           C  
ATOM   4489  NH1 ARG D  93      16.662   1.708  44.177  1.00 35.24           N  
ATOM   4490  NH2 ARG D  93      16.050   0.019  42.742  1.00 34.25           N  
ATOM   4491  N   ILE D  94      13.096   8.963  40.524  1.00 14.29           N  
ATOM   4492  CA  ILE D  94      12.670  10.306  40.908  1.00 15.51           C  
ATOM   4493  C   ILE D  94      11.389  10.110  41.729  1.00 13.52           C  
ATOM   4494  O   ILE D  94      10.587   9.233  41.417  1.00 15.18           O  
ATOM   4495  CB  ILE D  94      12.353  11.162  39.628  1.00 16.84           C  
ATOM   4496  CG1 ILE D  94      13.656  11.686  39.003  1.00 18.13           C  
ATOM   4497  CG2 ILE D  94      11.404  12.319  39.969  1.00 20.30           C  
ATOM   4498  CD1 ILE D  94      14.266  12.859  39.740  1.00 20.01           C  
ATOM   4499  N   GLU D  95      11.196  10.923  42.761  1.00 14.32           N  
ATOM   4500  CA  GLU D  95      10.025  10.809  43.624  1.00 16.66           C  
ATOM   4501  C   GLU D  95       8.746  11.362  43.004  1.00 16.68           C  
ATOM   4502  O   GLU D  95       7.693  10.737  43.078  1.00 11.00           O  
ATOM   4503  CB  GLU D  95      10.290  11.529  44.952  1.00 22.43           C  
ATOM   4504  CG  GLU D  95       9.140  11.485  45.945  1.00 28.98           C  
ATOM   4505  CD  GLU D  95       8.773  10.069  46.344  1.00 36.73           C  
ATOM   4506  OE1 GLU D  95       9.684   9.215  46.411  1.00 37.22           O  
ATOM   4507  OE2 GLU D  95       7.575   9.813  46.602  1.00 40.85           O  
ATOM   4508  N   LYS D  96       8.849  12.533  42.382  1.00 16.51           N  
ATOM   4509  CA  LYS D  96       7.685  13.172  41.786  1.00 14.87           C  
ATOM   4510  C   LYS D  96       8.085  14.136  40.678  1.00 15.47           C  
ATOM   4511  O   LYS D  96       9.161  14.721  40.736  1.00 14.54           O  
ATOM   4512  CB  LYS D  96       6.930  13.952  42.872  1.00 17.25           C  
ATOM   4513  CG  LYS D  96       5.705  14.699  42.375  1.00 18.59           C  
ATOM   4514  CD  LYS D  96       4.967  15.388  43.515  1.00 20.61           C  
ATOM   4515  CE  LYS D  96       3.620  15.900  43.040  1.00 27.02           C  
ATOM   4516  NZ  LYS D  96       2.796  16.487  44.134  1.00 26.73           N  
ATOM   4517  N   VAL D  97       7.230  14.274  39.663  1.00 13.56           N  
ATOM   4518  CA  VAL D  97       7.486  15.217  38.586  1.00 11.65           C  
ATOM   4519  C   VAL D  97       6.301  16.170  38.548  1.00 13.04           C  
ATOM   4520  O   VAL D  97       5.138  15.749  38.666  1.00 11.79           O  
ATOM   4521  CB  VAL D  97       7.680  14.509  37.207  1.00 10.34           C  
ATOM   4522  CG1 VAL D  97       6.468  13.638  36.859  1.00 13.07           C  
ATOM   4523  CG2 VAL D  97       7.882  15.552  36.116  1.00 10.69           C  
ATOM   4524  N   ILE D  98       6.610  17.457  38.432  1.00 12.74           N  
ATOM   4525  CA  ILE D  98       5.599  18.508  38.374  1.00 15.11           C  
ATOM   4526  C   ILE D  98       5.813  19.249  37.057  1.00 14.28           C  
ATOM   4527  O   ILE D  98       6.919  19.725  36.789  1.00 14.58           O  
ATOM   4528  CB  ILE D  98       5.752  19.494  39.563  1.00 15.30           C  
ATOM   4529  CG1 ILE D  98       5.720  18.729  40.892  1.00 17.93           C  
ATOM   4530  CG2 ILE D  98       4.637  20.539  39.534  1.00 18.53           C  
ATOM   4531  CD1 ILE D  98       7.075  18.162  41.316  1.00 20.22           C  
ATOM   4532  N   PHE D  99       4.767  19.331  36.235  1.00 13.25           N  
ATOM   4533  CA  PHE D  99       4.865  19.980  34.925  1.00 14.72           C  
ATOM   4534  C   PHE D  99       3.753  21.000  34.702  1.00 16.09           C  
ATOM   4535  O   PHE D  99       2.637  20.822  35.185  1.00 16.49           O  
ATOM   4536  CB  PHE D  99       4.887  18.922  33.815  1.00 15.61           C  
ATOM   4537  CG  PHE D  99       3.749  17.938  33.878  1.00 17.94           C  
ATOM   4538  CD1 PHE D  99       2.612  18.118  33.090  1.00 19.22           C  
ATOM   4539  CD2 PHE D  99       3.817  16.822  34.711  1.00 17.53           C  
ATOM   4540  CE1 PHE D  99       1.564  17.192  33.134  1.00 14.03           C  
ATOM   4541  CE2 PHE D  99       2.772  15.893  34.761  1.00 18.02           C  
ATOM   4542  CZ  PHE D  99       1.641  16.084  33.964  1.00 14.49           C  
ATOM   4543  N   SER D 100       4.070  22.064  33.962  1.00 17.31           N  
ATOM   4544  CA  SER D 100       3.138  23.179  33.757  1.00 19.64           C  
ATOM   4545  C   SER D 100       2.366  23.317  32.434  1.00 18.82           C  
ATOM   4546  O   SER D 100       1.653  24.301  32.225  1.00 21.02           O  
ATOM   4547  CB  SER D 100       3.882  24.482  34.064  1.00 19.45           C  
ATOM   4548  OG  SER D 100       5.090  24.576  33.311  1.00 21.22           O  
ATOM   4549  N   ALA D 101       2.496  22.336  31.554  1.00 16.96           N  
ATOM   4550  CA  ALA D 101       1.780  22.344  30.284  1.00 16.94           C  
ATOM   4551  C   ALA D 101       1.674  20.915  29.805  1.00 17.85           C  
ATOM   4552  O   ALA D 101       2.497  20.071  30.154  1.00 18.37           O  
ATOM   4553  CB  ALA D 101       2.518  23.197  29.248  1.00 18.80           C  
ATOM   4554  N   LEU D 102       0.663  20.639  28.996  1.00 16.38           N  
ATOM   4555  CA  LEU D 102       0.461  19.299  28.472  1.00 18.60           C  
ATOM   4556  C   LEU D 102       1.017  19.149  27.057  1.00 19.37           C  
ATOM   4557  O   LEU D 102       1.042  20.113  26.291  1.00 18.78           O  
ATOM   4558  CB  LEU D 102      -1.037  18.992  28.446  1.00 19.67           C  
ATOM   4559  CG  LEU D 102      -1.819  19.261  29.735  1.00 23.20           C  
ATOM   4560  CD1 LEU D 102      -3.297  19.234  29.428  1.00 24.54           C  
ATOM   4561  CD2 LEU D 102      -1.462  18.223  30.793  1.00 25.94           C  
ATOM   4562  N   ASP D 103       1.473  17.947  26.725  1.00 19.61           N  
ATOM   4563  CA  ASP D 103       1.974  17.647  25.388  1.00 21.13           C  
ATOM   4564  C   ASP D 103       1.139  16.495  24.819  1.00 23.32           C  
ATOM   4565  O   ASP D 103       1.492  15.319  24.968  1.00 21.93           O  
ATOM   4566  CB  ASP D 103       3.437  17.211  25.413  1.00 17.79           C  
ATOM   4567  CG  ASP D 103       4.001  17.046  24.020  1.00 22.16           C  
ATOM   4568  OD1 ASP D 103       3.198  16.818  23.087  1.00 24.02           O  
ATOM   4569  OD2 ASP D 103       5.236  17.133  23.853  1.00 21.41           O  
ATOM   4570  N   LYS D 104       0.058  16.838  24.128  1.00 25.82           N  
ATOM   4571  CA  LYS D 104      -0.836  15.825  23.577  1.00 29.28           C  
ATOM   4572  C   LYS D 104      -0.246  14.917  22.496  1.00 29.14           C  
ATOM   4573  O   LYS D 104      -0.808  13.858  22.210  1.00 28.22           O  
ATOM   4574  CB  LYS D 104      -2.118  16.494  23.063  1.00 33.51           C  
ATOM   4575  CG  LYS D 104      -3.240  15.511  22.716  1.00 40.86           C  
ATOM   4576  CD  LYS D 104      -4.637  16.152  22.830  1.00 42.39           C  
ATOM   4577  CE  LYS D 104      -5.000  16.430  24.288  1.00 44.99           C  
ATOM   4578  NZ  LYS D 104      -6.343  17.059  24.453  1.00 44.43           N  
ATOM   4579  N   LYS D 105       0.892  15.305  21.921  1.00 25.72           N  
ATOM   4580  CA  LYS D 105       1.525  14.519  20.863  1.00 26.63           C  
ATOM   4581  C   LYS D 105       2.668  13.597  21.288  1.00 26.83           C  
ATOM   4582  O   LYS D 105       2.924  12.571  20.642  1.00 23.94           O  
ATOM   4583  CB  LYS D 105       2.047  15.460  19.775  1.00 31.61           C  
ATOM   4584  CG  LYS D 105       0.982  16.289  19.078  1.00 35.06           C  
ATOM   4585  CD  LYS D 105       0.106  15.433  18.181  1.00 38.76           C  
ATOM   4586  CE  LYS D 105      -0.922  14.644  18.975  1.00 46.50           C  
ATOM   4587  NZ  LYS D 105      -1.836  15.542  19.738  1.00 46.07           N  
ATOM   4588  N   HIS D 106       3.360  13.958  22.363  1.00 21.70           N  
ATOM   4589  CA  HIS D 106       4.488  13.161  22.821  1.00 23.20           C  
ATOM   4590  C   HIS D 106       4.453  12.868  24.321  1.00 21.06           C  
ATOM   4591  O   HIS D 106       5.283  12.104  24.815  1.00 22.55           O  
ATOM   4592  CB  HIS D 106       5.805  13.877  22.499  1.00 19.71           C  
ATOM   4593  CG  HIS D 106       5.835  14.524  21.149  1.00 24.13           C  
ATOM   4594  ND1 HIS D 106       5.409  15.817  20.936  1.00 25.29           N  
ATOM   4595  CD2 HIS D 106       6.246  14.059  19.944  1.00 27.04           C  
ATOM   4596  CE1 HIS D 106       5.558  16.123  19.657  1.00 26.34           C  
ATOM   4597  NE2 HIS D 106       6.064  15.073  19.034  1.00 26.04           N  
ATOM   4598  N   GLY D 107       3.507  13.479  25.024  1.00 20.67           N  
ATOM   4599  CA  GLY D 107       3.390  13.297  26.468  1.00 21.12           C  
ATOM   4600  C   GLY D 107       3.262  11.871  26.968  1.00 23.10           C  
ATOM   4601  O   GLY D 107       2.370  11.136  26.548  1.00 26.64           O  
ATOM   4602  N   GLY D 108       4.151  11.477  27.879  1.00 20.22           N  
ATOM   4603  CA  GLY D 108       4.106  10.130  28.409  1.00 20.52           C  
ATOM   4604  C   GLY D 108       3.601  10.029  29.836  1.00 19.39           C  
ATOM   4605  O   GLY D 108       3.853   9.029  30.508  1.00 22.17           O  
ATOM   4606  N   VAL D 109       2.903  11.057  30.313  1.00 15.53           N  
ATOM   4607  CA  VAL D 109       2.375  11.031  31.672  1.00 16.28           C  
ATOM   4608  C   VAL D 109       0.848  10.983  31.653  1.00 21.27           C  
ATOM   4609  O   VAL D 109       0.241  10.104  32.267  1.00 19.30           O  
ATOM   4610  CB  VAL D 109       2.837  12.271  32.505  1.00 13.92           C  
ATOM   4611  CG1 VAL D 109       2.259  12.200  33.917  1.00 16.01           C  
ATOM   4612  CG2 VAL D 109       4.376  12.319  32.575  1.00  9.45           C  
ATOM   4613  N   VAL D 110       0.226  11.911  30.931  1.00 18.93           N  
ATOM   4614  CA  VAL D 110      -1.232  11.946  30.868  1.00 24.68           C  
ATOM   4615  C   VAL D 110      -1.815  11.915  29.464  1.00 23.19           C  
ATOM   4616  O   VAL D 110      -2.989  11.598  29.289  1.00 21.40           O  
ATOM   4617  CB  VAL D 110      -1.782  13.195  31.569  1.00 28.40           C  
ATOM   4618  CG1 VAL D 110      -1.331  13.210  32.998  1.00 33.53           C  
ATOM   4619  CG2 VAL D 110      -1.298  14.455  30.863  1.00 33.03           C  
ATOM   4620  N   SER D 111      -0.994  12.230  28.468  1.00 25.63           N  
ATOM   4621  CA  SER D 111      -1.460  12.284  27.086  1.00 26.75           C  
ATOM   4622  C   SER D 111      -1.423  10.990  26.269  1.00 30.99           C  
ATOM   4623  O   SER D 111      -2.385  10.217  26.283  1.00 33.56           O  
ATOM   4624  CB  SER D 111      -0.699  13.388  26.348  1.00 27.68           C  
ATOM   4625  OG  SER D 111      -0.898  14.638  26.991  1.00 23.52           O  
ATOM   4626  N   VAL D 112      -0.326  10.753  25.555  1.00 31.01           N  
ATOM   4627  CA  VAL D 112      -0.205   9.567  24.714  1.00 30.95           C  
ATOM   4628  C   VAL D 112      -0.116   8.265  25.497  1.00 33.29           C  
ATOM   4629  O   VAL D 112      -0.702   7.260  25.102  1.00 33.19           O  
ATOM   4630  CB  VAL D 112       1.025   9.662  23.787  1.00 32.14           C  
ATOM   4631  CG1 VAL D 112       1.055   8.473  22.823  1.00 32.02           C  
ATOM   4632  CG2 VAL D 112       0.992  10.975  23.022  1.00 31.26           C  
ATOM   4633  N   PHE D 113       0.627   8.280  26.596  1.00 31.83           N  
ATOM   4634  CA  PHE D 113       0.778   7.096  27.428  1.00 31.57           C  
ATOM   4635  C   PHE D 113       0.851   7.495  28.891  1.00 28.77           C  
ATOM   4636  O   PHE D 113       1.236   8.615  29.218  1.00 32.20           O  
ATOM   4637  CB  PHE D 113       2.062   6.351  27.071  1.00 33.81           C  
ATOM   4638  CG  PHE D 113       1.981   5.556  25.806  1.00 37.44           C  
ATOM   4639  CD1 PHE D 113       1.176   4.422  25.732  1.00 37.43           C  
ATOM   4640  CD2 PHE D 113       2.748   5.910  24.701  1.00 37.12           C  
ATOM   4641  CE1 PHE D 113       1.143   3.648  24.575  1.00 39.06           C  
ATOM   4642  CE2 PHE D 113       2.722   5.143  23.540  1.00 38.16           C  
ATOM   4643  CZ  PHE D 113       1.918   4.008  23.477  1.00 38.21           C  
ATOM   4644  N   ASN D 114       0.471   6.575  29.769  1.00 27.44           N  
ATOM   4645  CA  ASN D 114       0.546   6.818  31.201  1.00 26.21           C  
ATOM   4646  C   ASN D 114       1.700   5.954  31.686  1.00 24.51           C  
ATOM   4647  O   ASN D 114       1.507   5.010  32.455  1.00 22.53           O  
ATOM   4648  CB  ASN D 114      -0.748   6.401  31.899  1.00 30.71           C  
ATOM   4649  CG  ASN D 114      -1.928   7.252  31.485  1.00 36.67           C  
ATOM   4650  OD1 ASN D 114      -1.941   8.463  31.706  1.00 38.72           O  
ATOM   4651  ND2 ASN D 114      -2.930   6.624  30.880  1.00 38.54           N  
ATOM   4652  N   ILE D 115       2.899   6.285  31.211  1.00 19.94           N  
ATOM   4653  CA  ILE D 115       4.107   5.549  31.555  1.00 20.61           C  
ATOM   4654  C   ILE D 115       4.357   5.454  33.056  1.00 22.04           C  
ATOM   4655  O   ILE D 115       4.765   4.406  33.559  1.00 22.99           O  
ATOM   4656  CB  ILE D 115       5.349   6.186  30.894  1.00 20.20           C  
ATOM   4657  CG1 ILE D 115       5.171   6.222  29.371  1.00 23.72           C  
ATOM   4658  CG2 ILE D 115       6.601   5.395  31.251  1.00 20.87           C  
ATOM   4659  CD1 ILE D 115       5.132   4.853  28.716  1.00 26.40           C  
ATOM   4660  N   LEU D 116       4.117   6.543  33.774  1.00 20.10           N  
ATOM   4661  CA  LEU D 116       4.354   6.548  35.211  1.00 20.05           C  
ATOM   4662  C   LEU D 116       3.400   5.671  36.015  1.00 22.54           C  
ATOM   4663  O   LEU D 116       3.729   5.247  37.123  1.00 23.63           O  
ATOM   4664  CB  LEU D 116       4.304   7.988  35.741  1.00 18.29           C  
ATOM   4665  CG  LEU D 116       5.633   8.761  35.804  1.00 24.67           C  
ATOM   4666  CD1 LEU D 116       6.598   8.302  34.732  1.00 20.96           C  
ATOM   4667  CD2 LEU D 116       5.361  10.256  35.715  1.00 14.74           C  
ATOM   4668  N   ASP D 117       2.234   5.386  35.450  1.00 22.98           N  
ATOM   4669  CA  ASP D 117       1.234   4.591  36.151  1.00 27.28           C  
ATOM   4670  C   ASP D 117       1.111   3.145  35.679  1.00 28.49           C  
ATOM   4671  O   ASP D 117       0.062   2.523  35.843  1.00 28.94           O  
ATOM   4672  CB  ASP D 117      -0.124   5.290  36.065  1.00 24.91           C  
ATOM   4673  CG  ASP D 117      -0.092   6.689  36.658  1.00 25.73           C  
ATOM   4674  OD1 ASP D 117      -0.296   7.669  35.903  1.00 26.22           O  
ATOM   4675  OD2 ASP D 117       0.138   6.813  37.882  1.00 20.64           O  
ATOM   4676  N   GLU D 118       2.180   2.609  35.100  1.00 33.48           N  
ATOM   4677  CA  GLU D 118       2.180   1.222  34.640  1.00 38.02           C  
ATOM   4678  C   GLU D 118       2.467   0.303  35.831  1.00 40.94           C  
ATOM   4679  O   GLU D 118       3.520   0.402  36.460  1.00 39.38           O  
ATOM   4680  CB  GLU D 118       3.249   1.018  33.564  1.00 40.78           C  
ATOM   4681  CG  GLU D 118       3.600  -0.443  33.318  1.00 45.11           C  
ATOM   4682  CD  GLU D 118       2.448  -1.233  32.741  1.00 46.23           C  
ATOM   4683  OE1 GLU D 118       2.554  -2.475  32.683  1.00 44.95           O  
ATOM   4684  OE2 GLU D 118       1.440  -0.610  32.339  1.00 48.69           O  
ATOM   4685  N   PRO D 119       1.538  -0.615  36.144  1.00 44.60           N  
ATOM   4686  CA  PRO D 119       1.678  -1.559  37.260  1.00 46.14           C  
ATOM   4687  C   PRO D 119       2.984  -2.353  37.280  1.00 48.14           C  
ATOM   4688  O   PRO D 119       3.555  -2.593  38.347  1.00 47.05           O  
ATOM   4689  CB  PRO D 119       0.447  -2.456  37.111  1.00 47.82           C  
ATOM   4690  CG  PRO D 119       0.167  -2.412  35.635  1.00 48.38           C  
ATOM   4691  CD  PRO D 119       0.357  -0.946  35.326  1.00 46.87           C  
ATOM   4692  N   THR D 120       3.449  -2.764  36.103  1.00 49.86           N  
ATOM   4693  CA  THR D 120       4.694  -3.520  35.977  1.00 51.32           C  
ATOM   4694  C   THR D 120       5.820  -2.880  36.790  1.00 52.30           C  
ATOM   4695  O   THR D 120       6.550  -3.562  37.517  1.00 51.17           O  
ATOM   4696  CB  THR D 120       5.154  -3.593  34.500  1.00 52.09           C  
ATOM   4697  OG1 THR D 120       4.253  -4.418  33.757  1.00 54.47           O  
ATOM   4698  CG2 THR D 120       6.565  -4.165  34.403  1.00 54.05           C  
ATOM   4699  N   LEU D 121       5.953  -1.565  36.645  1.00 52.21           N  
ATOM   4700  CA  LEU D 121       6.980  -0.786  37.333  1.00 51.67           C  
ATOM   4701  C   LEU D 121       7.061  -1.043  38.839  1.00 50.96           C  
ATOM   4702  O   LEU D 121       6.041  -1.073  39.529  1.00 49.96           O  
ATOM   4703  CB  LEU D 121       6.739   0.709  37.093  1.00 52.21           C  
ATOM   4704  CG  LEU D 121       7.065   1.315  35.722  1.00 52.50           C  
ATOM   4705  CD1 LEU D 121       6.495   0.469  34.599  1.00 52.17           C  
ATOM   4706  CD2 LEU D 121       6.505   2.732  35.674  1.00 50.75           C  
ATOM   4707  N   ASN D 122       8.284  -1.216  39.339  1.00 49.73           N  
ATOM   4708  CA  ASN D 122       8.515  -1.451  40.761  1.00 50.06           C  
ATOM   4709  C   ASN D 122       8.539  -0.111  41.499  1.00 47.39           C  
ATOM   4710  O   ASN D 122       8.013   0.010  42.606  1.00 47.55           O  
ATOM   4711  CB  ASN D 122       9.838  -2.197  40.974  1.00 53.19           C  
ATOM   4712  CG  ASN D 122      11.041  -1.411  40.486  1.00 55.02           C  
ATOM   4713  OD1 ASN D 122      11.126  -1.046  39.312  1.00 56.63           O  
ATOM   4714  ND2 ASN D 122      11.984  -1.153  41.388  1.00 55.28           N  
ATOM   4715  N   HIS D 123       9.158   0.891  40.881  1.00 44.31           N  
ATOM   4716  CA  HIS D 123       9.209   2.223  41.469  1.00 39.61           C  
ATOM   4717  C   HIS D 123       8.081   3.050  40.878  1.00 34.45           C  
ATOM   4718  O   HIS D 123       7.919   3.102  39.656  1.00 32.78           O  
ATOM   4719  CB  HIS D 123      10.531   2.925  41.160  1.00 40.55           C  
ATOM   4720  CG  HIS D 123      10.565   4.351  41.622  1.00 41.73           C  
ATOM   4721  ND1 HIS D 123      10.622   4.699  42.956  1.00 40.70           N  
ATOM   4722  CD2 HIS D 123      10.488   5.515  40.933  1.00 40.08           C  
ATOM   4723  CE1 HIS D 123      10.576   6.015  43.067  1.00 40.05           C  
ATOM   4724  NE2 HIS D 123      10.494   6.534  41.856  1.00 38.10           N  
ATOM   4725  N   ARG D 124       7.298   3.699  41.731  1.00 31.29           N  
ATOM   4726  CA  ARG D 124       6.209   4.516  41.221  1.00 26.56           C  
ATOM   4727  C   ARG D 124       6.505   5.992  41.377  1.00 23.80           C  
ATOM   4728  O   ARG D 124       6.603   6.513  42.490  1.00 22.16           O  
ATOM   4729  CB  ARG D 124       4.884   4.187  41.912  1.00 29.73           C  
ATOM   4730  CG  ARG D 124       3.714   4.912  41.257  1.00 33.45           C  
ATOM   4731  CD  ARG D 124       2.375   4.242  41.493  1.00 38.83           C  
ATOM   4732  NE  ARG D 124       1.335   4.862  40.671  1.00 42.21           N  
ATOM   4733  CZ  ARG D 124       0.128   4.341  40.461  1.00 43.81           C  
ATOM   4734  NH1 ARG D 124      -0.205   3.182  41.016  1.00 44.34           N  
ATOM   4735  NH2 ARG D 124      -0.744   4.970  39.687  1.00 39.02           N  
ATOM   4736  N   VAL D 125       6.667   6.653  40.240  1.00 19.68           N  
ATOM   4737  CA  VAL D 125       6.932   8.083  40.207  1.00 15.68           C  
ATOM   4738  C   VAL D 125       5.581   8.781  40.293  1.00 16.30           C  
ATOM   4739  O   VAL D 125       4.687   8.530  39.470  1.00 15.73           O  
ATOM   4740  CB  VAL D 125       7.615   8.498  38.877  1.00 15.78           C  
ATOM   4741  CG1 VAL D 125       7.888  10.001  38.869  1.00 16.74           C  
ATOM   4742  CG2 VAL D 125       8.910   7.715  38.676  1.00 15.35           C  
ATOM   4743  N   LYS D 126       5.428   9.635  41.302  1.00 17.01           N  
ATOM   4744  CA  LYS D 126       4.209  10.404  41.476  1.00 15.93           C  
ATOM   4745  C   LYS D 126       4.289  11.610  40.539  1.00 16.40           C  
ATOM   4746  O   LYS D 126       5.372  12.015  40.129  1.00 15.06           O  
ATOM   4747  CB  LYS D 126       4.097  10.883  42.924  1.00 20.25           C  
ATOM   4748  CG  LYS D 126       4.073   9.751  43.954  1.00 21.34           C  
ATOM   4749  CD  LYS D 126       3.960  10.312  45.364  1.00 28.33           C  
ATOM   4750  CE  LYS D 126       3.978   9.201  46.423  1.00 30.57           C  
ATOM   4751  NZ  LYS D 126       5.325   8.561  46.577  1.00 30.32           N  
ATOM   4752  N   TRP D 127       3.152  12.193  40.185  1.00 15.12           N  
ATOM   4753  CA  TRP D 127       3.198  13.351  39.302  1.00 14.26           C  
ATOM   4754  C   TRP D 127       2.089  14.336  39.583  1.00 15.52           C  
ATOM   4755  O   TRP D 127       1.102  14.017  40.259  1.00 15.62           O  
ATOM   4756  CB  TRP D 127       3.149  12.923  37.830  1.00 17.34           C  
ATOM   4757  CG  TRP D 127       1.956  12.098  37.457  1.00 15.94           C  
ATOM   4758  CD1 TRP D 127       1.842  10.734  37.518  1.00 19.22           C  
ATOM   4759  CD2 TRP D 127       0.710  12.583  36.953  1.00 17.23           C  
ATOM   4760  NE1 TRP D 127       0.602  10.342  37.074  1.00 17.68           N  
ATOM   4761  CE2 TRP D 127      -0.114  11.456  36.722  1.00 20.32           C  
ATOM   4762  CE3 TRP D 127       0.208  13.860  36.673  1.00 18.81           C  
ATOM   4763  CZ2 TRP D 127      -1.417  11.571  36.223  1.00 23.16           C  
ATOM   4764  CZ3 TRP D 127      -1.088  13.975  36.177  1.00 23.16           C  
ATOM   4765  CH2 TRP D 127      -1.884  12.834  35.958  1.00 21.25           C  
ATOM   4766  N   GLU D 128       2.265  15.546  39.080  1.00 14.73           N  
ATOM   4767  CA  GLU D 128       1.276  16.585  39.273  1.00 15.03           C  
ATOM   4768  C   GLU D 128       1.297  17.553  38.111  1.00 14.87           C  
ATOM   4769  O   GLU D 128       2.352  18.051  37.737  1.00 13.92           O  
ATOM   4770  CB  GLU D 128       1.556  17.379  40.546  1.00 19.47           C  
ATOM   4771  CG  GLU D 128       0.433  18.358  40.879  1.00 23.59           C  
ATOM   4772  CD  GLU D 128       0.746  19.252  42.053  1.00 25.39           C  
ATOM   4773  OE1 GLU D 128       1.561  18.860  42.915  1.00 25.00           O  
ATOM   4774  OE2 GLU D 128       0.158  20.350  42.123  1.00 27.02           O  
ATOM   4775  N   TYR D 129       0.125  17.799  37.539  1.00 12.63           N  
ATOM   4776  CA  TYR D 129      -0.010  18.770  36.459  1.00 16.10           C  
ATOM   4777  C   TYR D 129      -0.433  20.042  37.182  1.00 16.85           C  
ATOM   4778  O   TYR D 129      -1.478  20.075  37.844  1.00 19.27           O  
ATOM   4779  CB  TYR D 129      -1.085  18.328  35.465  1.00 15.51           C  
ATOM   4780  CG  TYR D 129      -1.464  19.392  34.445  1.00 19.41           C  
ATOM   4781  CD1 TYR D 129      -0.488  20.118  33.758  1.00 20.60           C  
ATOM   4782  CD2 TYR D 129      -2.807  19.662  34.160  1.00 20.90           C  
ATOM   4783  CE1 TYR D 129      -0.842  21.087  32.809  1.00 22.13           C  
ATOM   4784  CE2 TYR D 129      -3.168  20.622  33.216  1.00 19.25           C  
ATOM   4785  CZ  TYR D 129      -2.186  21.328  32.545  1.00 22.64           C  
ATOM   4786  OH  TYR D 129      -2.550  22.261  31.604  1.00 23.77           O  
ATOM   4787  N   TYR D 130       0.395  21.071  37.057  1.00 16.43           N  
ATOM   4788  CA  TYR D 130       0.193  22.370  37.689  1.00 17.51           C  
ATOM   4789  C   TYR D 130       0.322  23.379  36.549  1.00 18.54           C  
ATOM   4790  O   TYR D 130       1.379  23.949  36.332  1.00 19.35           O  
ATOM   4791  CB  TYR D 130       1.293  22.591  38.731  1.00 20.15           C  
ATOM   4792  CG  TYR D 130       1.096  23.786  39.635  1.00 24.83           C  
ATOM   4793  CD1 TYR D 130       1.261  25.087  39.156  1.00 26.08           C  
ATOM   4794  CD2 TYR D 130       0.749  23.614  40.972  1.00 24.44           C  
ATOM   4795  CE1 TYR D 130       1.084  26.182  39.987  1.00 28.49           C  
ATOM   4796  CE2 TYR D 130       0.567  24.704  41.811  1.00 28.50           C  
ATOM   4797  CZ  TYR D 130       0.738  25.982  41.314  1.00 29.01           C  
ATOM   4798  OH  TYR D 130       0.581  27.059  42.148  1.00 31.44           O  
ATOM   4799  N   PRO D 131      -0.764  23.601  35.802  1.00 22.69           N  
ATOM   4800  CA  PRO D 131      -0.754  24.537  34.674  1.00 20.91           C  
ATOM   4801  C   PRO D 131      -0.361  25.992  34.945  1.00 22.79           C  
ATOM   4802  O   PRO D 131      -0.727  26.577  35.967  1.00 23.16           O  
ATOM   4803  CB  PRO D 131      -2.175  24.412  34.110  1.00 22.81           C  
ATOM   4804  CG  PRO D 131      -2.992  24.076  35.307  1.00 23.28           C  
ATOM   4805  CD  PRO D 131      -2.121  23.064  36.025  1.00 24.38           C  
ATOM   4806  N   LEU D 132       0.422  26.547  34.019  1.00 21.58           N  
ATOM   4807  CA  LEU D 132       0.861  27.943  34.063  1.00 23.86           C  
ATOM   4808  C   LEU D 132       0.793  28.405  32.612  1.00 24.41           C  
ATOM   4809  O   LEU D 132       1.485  27.862  31.750  1.00 25.26           O  
ATOM   4810  CB  LEU D 132       2.300  28.082  34.584  1.00 20.18           C  
ATOM   4811  CG  LEU D 132       2.591  27.695  36.031  1.00 17.25           C  
ATOM   4812  CD1 LEU D 132       4.066  27.950  36.351  1.00 18.25           C  
ATOM   4813  CD2 LEU D 132       1.688  28.499  36.973  1.00 23.10           C  
ATOM   4814  N   GLU D 133      -0.050  29.392  32.333  1.00 29.32           N  
ATOM   4815  CA  GLU D 133      -0.190  29.878  30.964  1.00 31.12           C  
ATOM   4816  C   GLU D 133       1.127  30.308  30.337  1.00 30.32           C  
ATOM   4817  O   GLU D 133       1.313  30.181  29.127  1.00 31.42           O  
ATOM   4818  CB  GLU D 133      -1.199  31.026  30.898  1.00 34.70           C  
ATOM   4819  CG  GLU D 133      -2.644  30.582  31.124  1.00 43.92           C  
ATOM   4820  CD  GLU D 133      -2.996  29.297  30.377  1.00 47.34           C  
ATOM   4821  OE1 GLU D 133      -2.740  29.218  29.152  1.00 49.79           O  
ATOM   4822  OE2 GLU D 133      -3.533  28.364  31.016  1.00 49.88           O  
ATOM   4823  N   GLU D 134       2.040  30.812  31.161  1.00 30.72           N  
ATOM   4824  CA  GLU D 134       3.345  31.252  30.682  1.00 29.56           C  
ATOM   4825  C   GLU D 134       4.016  30.121  29.916  1.00 27.55           C  
ATOM   4826  O   GLU D 134       4.608  30.345  28.860  1.00 22.97           O  
ATOM   4827  CB  GLU D 134       4.238  31.666  31.856  1.00 33.21           C  
ATOM   4828  CG  GLU D 134       3.591  32.642  32.823  1.00 42.09           C  
ATOM   4829  CD  GLU D 134       2.412  32.032  33.567  1.00 46.49           C  
ATOM   4830  OE1 GLU D 134       2.625  31.063  34.324  1.00 50.04           O  
ATOM   4831  OE2 GLU D 134       1.274  32.517  33.392  1.00 51.15           O  
ATOM   4832  N   ALA D 135       3.916  28.902  30.446  1.00 25.29           N  
ATOM   4833  CA  ALA D 135       4.531  27.733  29.812  1.00 25.65           C  
ATOM   4834  C   ALA D 135       3.923  27.389  28.454  1.00 26.14           C  
ATOM   4835  O   ALA D 135       4.635  26.992  27.530  1.00 23.88           O  
ATOM   4836  CB  ALA D 135       4.444  26.520  30.745  1.00 26.92           C  
ATOM   4837  N   SER D 136       2.607  27.519  28.333  1.00 27.19           N  
ATOM   4838  CA  SER D 136       1.946  27.227  27.062  1.00 28.55           C  
ATOM   4839  C   SER D 136       2.261  28.326  26.051  1.00 27.25           C  
ATOM   4840  O   SER D 136       2.421  28.063  24.858  1.00 27.16           O  
ATOM   4841  CB  SER D 136       0.434  27.122  27.264  1.00 29.46           C  
ATOM   4842  OG  SER D 136       0.129  26.071  28.161  1.00 36.54           O  
ATOM   4843  N   GLU D 137       2.355  29.556  26.544  1.00 28.24           N  
ATOM   4844  CA  GLU D 137       2.658  30.704  25.699  1.00 30.33           C  
ATOM   4845  C   GLU D 137       4.039  30.574  25.059  1.00 28.03           C  
ATOM   4846  O   GLU D 137       4.203  30.876  23.876  1.00 26.38           O  
ATOM   4847  CB  GLU D 137       2.554  32.006  26.514  1.00 30.31           C  
ATOM   4848  CG  GLU D 137       1.124  32.317  26.964  1.00 38.56           C  
ATOM   4849  CD  GLU D 137       1.006  33.575  27.825  1.00 43.92           C  
ATOM   4850  OE1 GLU D 137      -0.129  33.908  28.229  1.00 47.18           O  
ATOM   4851  OE2 GLU D 137       2.036  34.231  28.101  1.00 47.23           O  
ATOM   4852  N   LEU D 138       5.030  30.120  25.828  1.00 25.17           N  
ATOM   4853  CA  LEU D 138       6.382  29.940  25.294  1.00 23.60           C  
ATOM   4854  C   LEU D 138       6.370  28.992  24.098  1.00 21.86           C  
ATOM   4855  O   LEU D 138       6.963  29.275  23.056  1.00 23.26           O  
ATOM   4856  CB  LEU D 138       7.317  29.367  26.361  1.00 21.10           C  
ATOM   4857  CG  LEU D 138       8.419  30.249  26.924  1.00 28.11           C  
ATOM   4858  CD1 LEU D 138       9.220  29.451  27.941  1.00 29.19           C  
ATOM   4859  CD2 LEU D 138       9.326  30.743  25.804  1.00 27.92           C  
ATOM   4860  N   LEU D 139       5.713  27.850  24.257  1.00 23.10           N  
ATOM   4861  CA  LEU D 139       5.637  26.884  23.167  1.00 23.47           C  
ATOM   4862  C   LEU D 139       4.906  27.458  21.952  1.00 22.73           C  
ATOM   4863  O   LEU D 139       5.368  27.311  20.821  1.00 23.24           O  
ATOM   4864  CB  LEU D 139       4.923  25.610  23.621  1.00 25.99           C  
ATOM   4865  CG  LEU D 139       5.778  24.435  24.085  1.00 28.65           C  
ATOM   4866  CD1 LEU D 139       6.442  24.756  25.413  1.00 28.47           C  
ATOM   4867  CD2 LEU D 139       4.878  23.207  24.225  1.00 29.38           C  
ATOM   4868  N   SER D 140       3.767  28.105  22.188  1.00 24.52           N  
ATOM   4869  CA  SER D 140       2.995  28.682  21.089  1.00 27.77           C  
ATOM   4870  C   SER D 140       3.814  29.710  20.317  1.00 24.96           C  
ATOM   4871  O   SER D 140       3.725  29.782  19.093  1.00 25.24           O  
ATOM   4872  CB  SER D 140       1.694  29.316  21.603  1.00 31.81           C  
ATOM   4873  OG  SER D 140       1.937  30.346  22.543  1.00 39.83           O  
ATOM   4874  N   GLU D 141       4.619  30.495  21.028  1.00 25.69           N  
ATOM   4875  CA  GLU D 141       5.467  31.499  20.390  1.00 22.67           C  
ATOM   4876  C   GLU D 141       6.539  30.807  19.573  1.00 22.57           C  
ATOM   4877  O   GLU D 141       6.928  31.281  18.504  1.00 22.22           O  
ATOM   4878  CB  GLU D 141       6.134  32.398  21.440  1.00 23.43           C  
ATOM   4879  CG  GLU D 141       5.212  33.423  22.085  1.00 25.75           C  
ATOM   4880  CD  GLU D 141       4.702  34.454  21.090  1.00 28.77           C  
ATOM   4881  OE1 GLU D 141       5.527  35.014  20.332  1.00 32.21           O  
ATOM   4882  OE2 GLU D 141       3.479  34.710  21.070  1.00 28.62           O  
ATOM   4883  N   PHE D 142       7.030  29.684  20.088  1.00 22.68           N  
ATOM   4884  CA  PHE D 142       8.050  28.926  19.392  1.00 22.70           C  
ATOM   4885  C   PHE D 142       7.499  28.408  18.062  1.00 24.65           C  
ATOM   4886  O   PHE D 142       8.171  28.484  17.031  1.00 23.30           O  
ATOM   4887  CB  PHE D 142       8.536  27.750  20.255  1.00 23.05           C  
ATOM   4888  CG  PHE D 142       9.484  26.833  19.539  1.00 22.58           C  
ATOM   4889  CD1 PHE D 142       9.043  25.622  19.015  1.00 24.61           C  
ATOM   4890  CD2 PHE D 142      10.807  27.209  19.328  1.00 22.76           C  
ATOM   4891  CE1 PHE D 142       9.903  24.804  18.288  1.00 21.75           C  
ATOM   4892  CE2 PHE D 142      11.673  26.393  18.601  1.00 22.73           C  
ATOM   4893  CZ  PHE D 142      11.215  25.191  18.081  1.00 22.91           C  
ATOM   4894  N   PHE D 143       6.273  27.897  18.099  1.00 25.08           N  
ATOM   4895  CA  PHE D 143       5.603  27.360  16.916  1.00 30.87           C  
ATOM   4896  C   PHE D 143       5.390  28.424  15.830  1.00 29.83           C  
ATOM   4897  O   PHE D 143       5.360  28.112  14.640  1.00 28.35           O  
ATOM   4898  CB  PHE D 143       4.254  26.747  17.321  1.00 35.04           C  
ATOM   4899  CG  PHE D 143       4.370  25.551  18.249  1.00 40.81           C  
ATOM   4900  CD1 PHE D 143       3.273  25.134  19.006  1.00 43.61           C  
ATOM   4901  CD2 PHE D 143       5.562  24.834  18.354  1.00 42.84           C  
ATOM   4902  CE1 PHE D 143       3.359  24.026  19.852  1.00 43.83           C  
ATOM   4903  CE2 PHE D 143       5.661  23.721  19.199  1.00 42.41           C  
ATOM   4904  CZ  PHE D 143       4.559  23.319  19.947  1.00 43.71           C  
ATOM   4905  N   LYS D 144       5.239  29.677  16.245  1.00 31.54           N  
ATOM   4906  CA  LYS D 144       5.053  30.777  15.303  1.00 31.93           C  
ATOM   4907  C   LYS D 144       6.393  31.116  14.680  1.00 32.78           C  
ATOM   4908  O   LYS D 144       6.474  31.442  13.499  1.00 33.55           O  
ATOM   4909  CB  LYS D 144       4.503  32.011  16.012  1.00 34.52           C  
ATOM   4910  CG  LYS D 144       3.114  31.834  16.580  1.00 35.62           C  
ATOM   4911  CD  LYS D 144       2.640  33.110  17.253  1.00 38.41           C  
ATOM   4912  CE  LYS D 144       1.277  32.919  17.905  1.00 41.65           C  
ATOM   4913  NZ  LYS D 144       0.830  34.139  18.644  1.00 43.78           N  
ATOM   4914  N   LYS D 145       7.447  31.037  15.483  1.00 31.57           N  
ATOM   4915  CA  LYS D 145       8.790  31.327  15.008  1.00 33.54           C  
ATOM   4916  C   LYS D 145       9.238  30.253  14.017  1.00 34.08           C  
ATOM   4917  O   LYS D 145       9.941  30.538  13.047  1.00 34.50           O  
ATOM   4918  CB  LYS D 145       9.765  31.391  16.192  1.00 34.10           C  
ATOM   4919  CG  LYS D 145      11.205  31.694  15.806  1.00 37.22           C  
ATOM   4920  CD  LYS D 145      12.036  32.146  17.011  1.00 37.95           C  
ATOM   4921  CE  LYS D 145      12.177  31.049  18.063  1.00 37.84           C  
ATOM   4922  NZ  LYS D 145      12.925  29.860  17.557  1.00 35.88           N  
ATOM   4923  N   LEU D 146       8.810  29.020  14.257  1.00 33.75           N  
ATOM   4924  CA  LEU D 146       9.176  27.904  13.393  1.00 35.79           C  
ATOM   4925  C   LEU D 146       8.615  28.071  11.978  1.00 37.05           C  
ATOM   4926  O   LEU D 146       9.348  27.960  10.988  1.00 33.58           O  
ATOM   4927  CB  LEU D 146       8.666  26.594  14.002  1.00 38.78           C  
ATOM   4928  CG  LEU D 146       9.128  25.276  13.377  1.00 40.56           C  
ATOM   4929  CD1 LEU D 146      10.623  25.101  13.596  1.00 41.85           C  
ATOM   4930  CD2 LEU D 146       8.358  24.120  14.006  1.00 41.69           C  
ATOM   4931  N   ARG D 147       7.318  28.344  11.882  1.00 36.08           N  
ATOM   4932  CA  ARG D 147       6.694  28.496  10.580  1.00 41.40           C  
ATOM   4933  C   ARG D 147       7.212  29.729   9.834  1.00 41.97           C  
ATOM   4934  O   ARG D 147       7.344  29.714   8.609  1.00 40.91           O  
ATOM   4935  CB  ARG D 147       5.168  28.538  10.734  1.00 45.28           C  
ATOM   4936  CG  ARG D 147       4.609  29.798  11.352  1.00 51.32           C  
ATOM   4937  CD  ARG D 147       4.245  30.798  10.272  1.00 56.29           C  
ATOM   4938  NE  ARG D 147       3.371  30.196   9.267  1.00 60.22           N  
ATOM   4939  CZ  ARG D 147       2.786  30.867   8.279  1.00 61.21           C  
ATOM   4940  NH1 ARG D 147       2.975  32.174   8.151  1.00 62.22           N  
ATOM   4941  NH2 ARG D 147       2.006  30.228   7.417  1.00 62.94           N  
ATOM   4942  N   ASN D 148       7.525  30.786  10.576  1.00 40.41           N  
ATOM   4943  CA  ASN D 148       8.037  32.005   9.973  1.00 41.55           C  
ATOM   4944  C   ASN D 148       9.413  31.771   9.343  1.00 44.88           C  
ATOM   4945  O   ASN D 148       9.859  32.550   8.497  1.00 43.59           O  
ATOM   4946  CB  ASN D 148       8.137  33.112  11.031  1.00 44.13           C  
ATOM   4947  CG  ASN D 148       6.777  33.607  11.495  1.00 42.12           C  
ATOM   4948  OD1 ASN D 148       6.667  34.269  12.521  1.00 44.92           O  
ATOM   4949  ND2 ASN D 148       5.738  33.295  10.733  1.00 42.42           N  
ATOM   4950  N   ASN D 149      10.076  30.691   9.747  1.00 44.85           N  
ATOM   4951  CA  ASN D 149      11.407  30.380   9.229  1.00 48.66           C  
ATOM   4952  C   ASN D 149      11.449  29.260   8.185  1.00 49.60           C  
ATOM   4953  O   ASN D 149      12.530  28.780   7.840  1.00 49.05           O  
ATOM   4954  CB  ASN D 149      12.339  30.014  10.386  1.00 49.46           C  
ATOM   4955  CG  ASN D 149      12.438  31.110  11.431  1.00 52.68           C  
ATOM   4956  OD1 ASN D 149      13.104  30.945  12.454  1.00 55.71           O  
ATOM   4957  ND2 ASN D 149      11.778  32.236  11.182  1.00 51.72           N  
ATOM   4958  N   ILE D 150      10.289  28.847   7.681  1.00 50.99           N  
ATOM   4959  CA  ILE D 150      10.247  27.775   6.687  1.00 53.95           C  
ATOM   4960  C   ILE D 150       9.385  28.103   5.460  1.00 54.92           C  
ATOM   4961  O   ILE D 150       8.223  28.499   5.590  1.00 54.50           O  
ATOM   4962  CB  ILE D 150       9.728  26.456   7.315  1.00 55.13           C  
ATOM   4963  CG1 ILE D 150       9.913  25.299   6.330  1.00 55.76           C  
ATOM   4964  CG2 ILE D 150       8.258  26.587   7.684  1.00 56.75           C  
ATOM   4965  CD1 ILE D 150      11.361  25.006   6.000  1.00 55.52           C  
ATOM   4966  N   ILE D 151       9.971  27.943   4.273  1.00 55.41           N  
ATOM   4967  CA  ILE D 151       9.282  28.198   3.007  1.00 56.19           C  
ATOM   4968  C   ILE D 151       9.889  27.390   1.871  1.00 56.46           C  
ATOM   4969  O   ILE D 151       9.116  26.757   1.124  1.00 58.37           O  
ATOM   4970  CB  ILE D 151       9.332  29.684   2.586  1.00 55.52           C  
ATOM   4971  CG1 ILE D 151      10.781  30.174   2.541  1.00 54.81           C  
ATOM   4972  CG2 ILE D 151       8.481  30.507   3.513  1.00 58.28           C  
ATOM   4973  CD1 ILE D 151      10.939  31.566   1.964  1.00 54.33           C  
ATOM   4974  OXT ILE D 151      11.129  27.410   1.727  1.00 58.36           O  
TER    4975      ILE D 151                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
