
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   75 ( 1197),  selected   75 , name 2h3j_A
# Molecule2: number of CA atoms   74 ( 1189),  selected   74 , name T0462_1_74.pdb
# PARAMETERS: 2h3j_A.T0462_1_74.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      M       1           -
LGA    S     2_A      K       2           -
LGA    A     3_A      L       3           -
LGA    L     4_A      S       4           -
LGA    Q     5_A      R       5           -
LGA    -       -      L       6           -
LGA    -       -      V       7           -
LGA    P     6_A      P       8          5.855
LGA    S     7_A      G       9          2.685
LGA    R     8_A      V      10          0.527
LGA    S     9_A      P      11          0.866
LGA    Y    10_A      A      12          1.703
LGA    R    11_A      R      13          1.627
LGA    I    12_A      I      14          1.102
LGA    T    13_A      K      15          0.793
LGA    G    14_A      R      16          0.870
LGA    Y    15_A      L      17          0.696
LGA    S    16_A      E      18          1.814
LGA    P    17_A      -       -           -
LGA    A    18_A      -       -           -
LGA    I    19_A      V      19          1.751
LGA    S    20_A      S      20          4.609
LGA    N    21_A      -       -           -
LGA    G    22_A      G      21          0.972
LGA    Y    23_A      E      22          3.739
LGA    -       -      L      23           -
LGA    R    24_A      H      24          2.388
LGA    Q    25_A      E      25          2.843
LGA    R    26_A      K      26          3.095
LGA    L    27_A      L      27          2.227
LGA    F    28_A      V      28          2.326
LGA    S    29_A      G      29          2.726
LGA    M    30_A      M      30          2.873
LGA    G    31_A      G      31          2.323
LGA    L    32_A      F      32          1.366
LGA    L    33_A      V      33          0.924
LGA    P    34_A      P      34          0.574
LGA    G    35_A      G      35          0.467
LGA    A    36_A      E      36          0.513
LGA    A    37_A      E      37          1.521
LGA    L    38_A      I      38          1.343
LGA    R    39_A      E      39          1.538
LGA    V    40_A      I      40          1.774
LGA    V    41_A      V      41          0.848
LGA    R    42_A      Q      42          1.465
LGA    I    43_A      V      43          1.329
LGA    A    44_A      A      44          1.816
LGA    P    45_A      P      45          3.162
LGA    L    46_A      L      46          1.001
LGA    G    47_A      G      47          1.639
LGA    D    48_A      D      48          1.038
LGA    P    49_A      P      49          1.356
LGA    I    50_A      I      50          1.415
LGA    Q    51_A      V      51          1.249
LGA    V    52_A      C      52          1.743
LGA    E    53_A      K      53          2.179
LGA    T    54_A      I      54          3.034
LGA    R    55_A      G      55          4.636
LGA    Q    56_A      N      56          3.186
LGA    T    57_A      R      57          2.290
LGA    S    58_A      N      58          1.722
LGA    L    59_A      I      59          1.814
LGA    A    60_A      T      60          1.440
LGA    L    61_A      L      61          0.890
LGA    R    62_A      R      62          0.573
LGA    R    63_A      K      63          0.658
LGA    K    64_A      R      64          1.276
LGA    D    65_A      E      65          1.602
LGA    L    66_A      A      66          1.164
LGA    A    67_A      D      67          2.406
LGA    L    68_A      L      68          2.582
LGA    L    69_A      I      69          1.468
LGA    T    70_A      E      70          1.299
LGA    L    71_A      V      71          1.552
LGA    V    72_A      E      72          1.478
LGA    P    73_A      V      73          1.636
LGA    L    74_A      V      74          1.465
LGA    D    75_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   75   74    5.0     66    2.08    31.82     78.181     3.031

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.915451 * X  +   0.090046 * Y  +  -0.392226 * Z  +  12.120875
  Y_new =   0.385835 * X  +  -0.080604 * Y  +  -0.919040 * Z  +  -2.526614
  Z_new =  -0.114371 * X  +  -0.992670 * Y  +   0.039046 * Z  +  -2.301819 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.531482    1.610111  [ DEG:   -87.7475     92.2525 ]
  Theta =   0.114622    3.026971  [ DEG:     6.5673    173.4327 ]
  Phi   =   2.742716   -0.398877  [ DEG:   157.1460    -22.8540 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2h3j_A                                        
REMARK     2: T0462_1_74.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2h3j_A.T0462_1_74.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   75   74   5.0   66   2.08   31.82  78.181
REMARK  ---------------------------------------------------------- 
MOLECULE 2h3j_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   22-MAY-06   2H3J              
TITLE     SOLUTION NMR STRUCTURE OF PROTEIN PA4359 FROM PSEUDOMONAS             
TITLE    2 AERUGINOSA: NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
TITLE    3 TARGET PAT89                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA4359;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 GENE: PA4359;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    NESG, GFT NMR, STRUCTURAL GENOMICS, PAT89, STRUCTURAL                 
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST             
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM                                       
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    Q.ZHANG,G.LIU,A.YEE,C.ARROWSMITH,T.SZYPERSKI,NORTHEAST                
AUTHOR   2 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   20-JUN-06 2H3J    0                                                
JRNL        AUTH   Q.ZHANG,G.LIU,A.YEE,C.ARROWSMITH,T.SZYPERSKI                 
JRNL        TITL   SOLUTION STRUCTURE OF HYPOTHETICAL PROTEIN PA4359:           
JRNL        TITL 2 NORTHEST STRUCTURAL GENOMICS TARGET PAT89                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2H3J A    1    75  UNP    Q9HW42   Q9HW42_PSEAE     1     75             
SEQRES   1 A   75  MET SER ALA LEU GLN PRO SER ARG SER TYR ARG ILE THR          
SEQRES   2 A   75  GLY TYR SER PRO ALA ILE SER ASN GLY TYR ARG GLN ARG          
SEQRES   3 A   75  LEU PHE SER MET GLY LEU LEU PRO GLY ALA ALA LEU ARG          
SEQRES   4 A   75  VAL VAL ARG ILE ALA PRO LEU GLY ASP PRO ILE GLN VAL          
SEQRES   5 A   75  GLU THR ARG GLN THR SER LEU ALA LEU ARG ARG LYS ASP          
SEQRES   6 A   75  LEU ALA LEU LEU THR LEU VAL PRO LEU ASP                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      16.726  18.141   3.262  1.00  0.00           N  
ATOM      2  CA  MET A   1      15.352  17.639   3.466  1.00  0.00           C  
ATOM      3  C   MET A   1      15.357  16.438   4.400  1.00  0.00           C  
ATOM      4  O   MET A   1      16.251  15.597   4.332  1.00  0.00           O  
ATOM      5  CB  MET A   1      14.713  17.248   2.127  1.00  0.00           C  
ATOM      6  CG  MET A   1      15.434  16.122   1.397  1.00  0.00           C  
ATOM      7  SD  MET A   1      14.575  15.592  -0.103  1.00  0.00           S  
ATOM      8  CE  MET A   1      13.013  15.039   0.571  1.00  0.00           C  
ATOM      9  HA  MET A   1      14.767  18.428   3.917  1.00  0.00           H  
ATOM     10  HB2 MET A   1      13.697  16.933   2.310  1.00  0.00           H  
ATOM     11  HB3 MET A   1      14.700  18.114   1.482  1.00  0.00           H  
ATOM     12  HG2 MET A   1      16.426  16.462   1.129  1.00  0.00           H  
ATOM     13  HG3 MET A   1      15.518  15.278   2.066  1.00  0.00           H  
ATOM     14  HE1 MET A   1      12.367  14.722  -0.236  1.00  0.00           H  
ATOM     15  HE2 MET A   1      12.545  15.848   1.110  1.00  0.00           H  
ATOM     16  HE3 MET A   1      13.182  14.210   1.242  1.00  0.00           H  
ATOM     17  N   SER A   2      14.365  16.358   5.268  1.00  0.00           N  
ATOM     18  CA  SER A   2      14.205  15.212   6.139  1.00  0.00           C  
ATOM     19  C   SER A   2      12.892  14.518   5.797  1.00  0.00           C  
ATOM     20  O   SER A   2      11.868  14.756   6.440  1.00  0.00           O  
ATOM     21  CB  SER A   2      14.225  15.656   7.602  1.00  0.00           C  
ATOM     22  OG  SER A   2      15.296  16.559   7.839  1.00  0.00           O  
ATOM     23  H   SER A   2      13.710  17.097   5.322  1.00  0.00           H  
ATOM     24  HA  SER A   2      15.023  14.531   5.957  1.00  0.00           H  
ATOM     25  HB2 SER A   2      13.293  16.147   7.842  1.00  0.00           H  
ATOM     26  HB3 SER A   2      14.351  14.792   8.237  1.00  0.00           H  
ATOM     27  HG  SER A   2      15.984  16.118   8.353  1.00  0.00           H  
ATOM     28  N   ALA A   3      12.931  13.698   4.743  1.00  0.00           N  
ATOM     29  CA  ALA A   3      11.728  13.101   4.157  1.00  0.00           C  
ATOM     30  C   ALA A   3      10.836  14.189   3.556  1.00  0.00           C  
ATOM     31  O   ALA A   3      11.148  15.377   3.639  1.00  0.00           O  
ATOM     32  CB  ALA A   3      10.958  12.269   5.183  1.00  0.00           C  
ATOM     33  H   ALA A   3      13.800  13.490   4.344  1.00  0.00           H  
ATOM     34  HA  ALA A   3      12.045  12.441   3.361  1.00  0.00           H  
ATOM     35  HB1 ALA A   3      10.569  12.920   5.952  1.00  0.00           H  
ATOM     36  HB2 ALA A   3      11.623  11.543   5.629  1.00  0.00           H  
ATOM     37  HB3 ALA A   3      10.143  11.758   4.694  1.00  0.00           H  
ATOM     38  N   LEU A   4       9.740  13.790   2.933  1.00  0.00           N  
ATOM     39  CA  LEU A   4       8.827  14.748   2.332  1.00  0.00           C  
ATOM     40  C   LEU A   4       7.393  14.257   2.437  1.00  0.00           C  
ATOM     41  O   LEU A   4       6.959  13.419   1.649  1.00  0.00           O  
ATOM     42  CB  LEU A   4       9.196  14.994   0.870  1.00  0.00           C  
ATOM     43  CG  LEU A   4       8.319  16.011   0.137  1.00  0.00           C  
ATOM     44  CD1 LEU A   4       8.449  17.387   0.771  1.00  0.00           C  
ATOM     45  CD2 LEU A   4       8.686  16.067  -1.338  1.00  0.00           C  
ATOM     46  H   LEU A   4       9.536  12.834   2.876  1.00  0.00           H  
ATOM     47  HA  LEU A   4       8.916  15.675   2.877  1.00  0.00           H  
ATOM     48  HB2 LEU A   4      10.219  15.340   0.835  1.00  0.00           H  
ATOM     49  HB3 LEU A   4       9.132  14.054   0.344  1.00  0.00           H  
ATOM     50  HG  LEU A   4       7.286  15.705   0.213  1.00  0.00           H  
ATOM     51 HD11 LEU A   4       7.810  18.085   0.254  1.00  0.00           H  
ATOM     52 HD12 LEU A   4       9.475  17.718   0.701  1.00  0.00           H  
ATOM     53 HD13 LEU A   4       8.159  17.333   1.811  1.00  0.00           H  
ATOM     54 HD21 LEU A   4       9.718  16.368  -1.440  1.00  0.00           H  
ATOM     55 HD22 LEU A   4       8.052  16.781  -1.842  1.00  0.00           H  
ATOM     56 HD23 LEU A   4       8.553  15.090  -1.781  1.00  0.00           H  
ATOM     57  N   GLN A   5       6.683  14.778   3.436  1.00  0.00           N  
ATOM     58  CA  GLN A   5       5.278  14.445   3.664  1.00  0.00           C  
ATOM     59  C   GLN A   5       5.074  12.930   3.751  1.00  0.00           C  
ATOM     60  O   GLN A   5       4.519  12.315   2.839  1.00  0.00           O  
ATOM     61  CB  GLN A   5       4.397  15.044   2.560  1.00  0.00           C  
ATOM     62  CG  GLN A   5       4.422  16.565   2.518  1.00  0.00           C  
ATOM     63  CD  GLN A   5       3.701  17.130   1.309  1.00  0.00           C  
ATOM     64  OE1 GLN A   5       2.756  16.533   0.791  1.00  0.00           O  
ATOM     65  NE2 GLN A   5       4.131  18.299   0.860  1.00  0.00           N  
ATOM     66  H   GLN A   5       7.125  15.407   4.048  1.00  0.00           H  
ATOM     67  HA  GLN A   5       4.990  14.885   4.609  1.00  0.00           H  
ATOM     68  HB2 GLN A   5       4.734  14.674   1.605  1.00  0.00           H  
ATOM     69  HB3 GLN A   5       3.375  14.729   2.719  1.00  0.00           H  
ATOM     70  HG2 GLN A   5       3.947  16.948   3.409  1.00  0.00           H  
ATOM     71  HG3 GLN A   5       5.451  16.895   2.491  1.00  0.00           H  
ATOM     72 HE21 GLN A   5       4.880  18.734   1.331  1.00  0.00           H  
ATOM     73 HE22 GLN A   5       3.685  18.684   0.074  1.00  0.00           H  
ATOM     74  N   PRO A   6       5.516  12.306   4.851  1.00  0.00           N  
ATOM     75  CA  PRO A   6       5.416  10.861   5.023  1.00  0.00           C  
ATOM     76  C   PRO A   6       3.994  10.421   5.353  1.00  0.00           C  
ATOM     77  O   PRO A   6       3.436  10.797   6.383  1.00  0.00           O  
ATOM     78  CB  PRO A   6       6.349  10.556   6.204  1.00  0.00           C  
ATOM     79  CG  PRO A   6       7.004  11.852   6.568  1.00  0.00           C  
ATOM     80  CD  PRO A   6       6.137  12.946   6.014  1.00  0.00           C  
ATOM     81  HA  PRO A   6       5.759  10.336   4.143  1.00  0.00           H  
ATOM     82  HB2 PRO A   6       5.763  10.169   7.023  1.00  0.00           H  
ATOM     83  HB3 PRO A   6       7.079   9.819   5.902  1.00  0.00           H  
ATOM     84  HG2 PRO A   6       7.069  11.938   7.642  1.00  0.00           H  
ATOM     85  HG3 PRO A   6       7.990  11.898   6.129  1.00  0.00           H  
ATOM     86  HD2 PRO A   6       5.390  13.243   6.737  1.00  0.00           H  
ATOM     87  HD3 PRO A   6       6.736  13.792   5.715  1.00  0.00           H  
ATOM     88  N   SER A   7       3.414   9.629   4.471  1.00  0.00           N  
ATOM     89  CA  SER A   7       2.067   9.120   4.669  1.00  0.00           C  
ATOM     90  C   SER A   7       2.124   7.745   5.327  1.00  0.00           C  
ATOM     91  O   SER A   7       1.440   7.482   6.312  1.00  0.00           O  
ATOM     92  CB  SER A   7       1.332   9.050   3.325  1.00  0.00           C  
ATOM     93  OG  SER A   7      -0.008   8.617   3.484  1.00  0.00           O  
ATOM     94  H   SER A   7       3.905   9.383   3.661  1.00  0.00           H  
ATOM     95  HA  SER A   7       1.542   9.802   5.324  1.00  0.00           H  
ATOM     96  HB2 SER A   7       1.327  10.031   2.873  1.00  0.00           H  
ATOM     97  HB3 SER A   7       1.843   8.357   2.674  1.00  0.00           H  
ATOM     98  HG  SER A   7      -0.219   8.550   4.427  1.00  0.00           H  
ATOM     99  N   ARG A   8       2.956   6.876   4.777  1.00  0.00           N  
ATOM    100  CA  ARG A   8       3.120   5.525   5.287  1.00  0.00           C  
ATOM    101  C   ARG A   8       4.556   5.065   5.117  1.00  0.00           C  
ATOM    102  O   ARG A   8       5.303   5.608   4.301  1.00  0.00           O  
ATOM    103  CB  ARG A   8       2.195   4.558   4.547  1.00  0.00           C  
ATOM    104  CG  ARG A   8       0.776   4.503   5.085  1.00  0.00           C  
ATOM    105  CD  ARG A   8      -0.120   3.681   4.173  1.00  0.00           C  
ATOM    106  NE  ARG A   8      -1.407   3.364   4.786  1.00  0.00           N  
ATOM    107  CZ  ARG A   8      -2.563   3.376   4.128  1.00  0.00           C  
ATOM    108  NH1 ARG A   8      -2.618   3.832   2.882  1.00  0.00           N  
ATOM    109  NH2 ARG A   8      -3.671   2.953   4.718  1.00  0.00           N  
ATOM    110  H   ARG A   8       3.483   7.149   4.000  1.00  0.00           H  
ATOM    111  HA  ARG A   8       2.868   5.527   6.335  1.00  0.00           H  
ATOM    112  HB2 ARG A   8       2.147   4.854   3.510  1.00  0.00           H  
ATOM    113  HB3 ARG A   8       2.616   3.564   4.605  1.00  0.00           H  
ATOM    114  HG2 ARG A   8       0.788   4.053   6.067  1.00  0.00           H  
ATOM    115  HG3 ARG A   8       0.386   5.508   5.153  1.00  0.00           H  
ATOM    116  HD2 ARG A   8      -0.295   4.242   3.267  1.00  0.00           H  
ATOM    117  HD3 ARG A   8       0.390   2.760   3.930  1.00  0.00           H  
ATOM    118  HE  ARG A   8      -1.399   3.087   5.737  1.00  0.00           H  
ATOM    119 HH11 ARG A   8      -1.792   4.171   2.432  1.00  0.00           H  
ATOM    120 HH12 ARG A   8      -3.494   3.839   2.388  1.00  0.00           H  
ATOM    121 HH21 ARG A   8      -3.645   2.620   5.668  1.00  0.00           H  
ATOM    122 HH22 ARG A   8      -4.539   2.951   4.212  1.00  0.00           H  
ATOM    123  N   SER A   9       4.935   4.067   5.887  1.00  0.00           N  
ATOM    124  CA  SER A   9       6.235   3.443   5.739  1.00  0.00           C  
ATOM    125  C   SER A   9       6.063   1.961   5.432  1.00  0.00           C  
ATOM    126  O   SER A   9       5.253   1.271   6.060  1.00  0.00           O  
ATOM    127  CB  SER A   9       7.078   3.648   6.998  1.00  0.00           C  
ATOM    128  OG  SER A   9       7.319   5.026   7.227  1.00  0.00           O  
ATOM    129  H   SER A   9       4.324   3.737   6.577  1.00  0.00           H  
ATOM    130  HA  SER A   9       6.731   3.912   4.903  1.00  0.00           H  
ATOM    131  HB2 SER A   9       6.554   3.238   7.851  1.00  0.00           H  
ATOM    132  HB3 SER A   9       8.028   3.145   6.879  1.00  0.00           H  
ATOM    133  HG  SER A   9       6.902   5.294   8.060  1.00  0.00           H  
ATOM    134  N   TYR A  10       6.804   1.484   4.449  1.00  0.00           N  
ATOM    135  CA  TYR A  10       6.704   0.102   4.013  1.00  0.00           C  
ATOM    136  C   TYR A  10       8.009  -0.625   4.311  1.00  0.00           C  
ATOM    137  O   TYR A  10       9.083  -0.139   3.960  1.00  0.00           O  
ATOM    138  CB  TYR A  10       6.418   0.032   2.507  1.00  0.00           C  
ATOM    139  CG  TYR A  10       5.150   0.739   2.066  1.00  0.00           C  
ATOM    140  CD1 TYR A  10       5.113   2.122   1.905  1.00  0.00           C  
ATOM    141  CD2 TYR A  10       3.991   0.022   1.802  1.00  0.00           C  
ATOM    142  CE1 TYR A  10       3.960   2.763   1.493  1.00  0.00           C  
ATOM    143  CE2 TYR A  10       2.834   0.657   1.391  1.00  0.00           C  
ATOM    144  CZ  TYR A  10       2.823   2.027   1.238  1.00  0.00           C  
ATOM    145  OH  TYR A  10       1.675   2.663   0.820  1.00  0.00           O  
ATOM    146  H   TYR A  10       7.455   2.081   4.009  1.00  0.00           H  
ATOM    147  HA  TYR A  10       5.895  -0.367   4.561  1.00  0.00           H  
ATOM    148  HB2 TYR A  10       7.241   0.479   1.974  1.00  0.00           H  
ATOM    149  HB3 TYR A  10       6.333  -1.006   2.215  1.00  0.00           H  
ATOM    150  HD1 TYR A  10       6.004   2.697   2.105  1.00  0.00           H  
ATOM    151  HD2 TYR A  10       4.000  -1.053   1.924  1.00  0.00           H  
ATOM    152  HE1 TYR A  10       3.951   3.837   1.375  1.00  0.00           H  
ATOM    153  HE2 TYR A  10       1.943   0.078   1.192  1.00  0.00           H  
ATOM    154  HH  TYR A  10       0.901   2.225   1.208  1.00  0.00           H  
ATOM    155  N   ARG A  11       7.921  -1.772   4.960  1.00  0.00           N  
ATOM    156  CA  ARG A  11       9.110  -2.554   5.270  1.00  0.00           C  
ATOM    157  C   ARG A  11       9.382  -3.572   4.175  1.00  0.00           C  
ATOM    158  O   ARG A  11       8.483  -3.958   3.432  1.00  0.00           O  
ATOM    159  CB  ARG A  11       8.953  -3.302   6.592  1.00  0.00           C  
ATOM    160  CG  ARG A  11       8.761  -2.409   7.800  1.00  0.00           C  
ATOM    161  CD  ARG A  11       8.727  -3.237   9.071  1.00  0.00           C  
ATOM    162  NE  ARG A  11       8.424  -2.435  10.250  1.00  0.00           N  
ATOM    163  CZ  ARG A  11       7.770  -2.907  11.306  1.00  0.00           C  
ATOM    164  NH1 ARG A  11       7.379  -4.176  11.337  1.00  0.00           N  
ATOM    165  NH2 ARG A  11       7.513  -2.115  12.335  1.00  0.00           N  
ATOM    166  H   ARG A  11       7.037  -2.113   5.225  1.00  0.00           H  
ATOM    167  HA  ARG A  11       9.947  -1.878   5.341  1.00  0.00           H  
ATOM    168  HB2 ARG A  11       8.098  -3.956   6.519  1.00  0.00           H  
ATOM    169  HB3 ARG A  11       9.837  -3.903   6.752  1.00  0.00           H  
ATOM    170  HG2 ARG A  11       9.580  -1.707   7.859  1.00  0.00           H  
ATOM    171  HG3 ARG A  11       7.828  -1.874   7.703  1.00  0.00           H  
ATOM    172  HD2 ARG A  11       7.973  -4.004   8.967  1.00  0.00           H  
ATOM    173  HD3 ARG A  11       9.692  -3.701   9.205  1.00  0.00           H  
ATOM    174  HE  ARG A  11       8.723  -1.493  10.251  1.00  0.00           H  
ATOM    175 HH11 ARG A  11       7.576  -4.786  10.565  1.00  0.00           H  
ATOM    176 HH12 ARG A  11       6.876  -4.531  12.137  1.00  0.00           H  
ATOM    177 HH21 ARG A  11       7.810  -1.154  12.321  1.00  0.00           H  
ATOM    178 HH22 ARG A  11       7.022  -2.469  13.138  1.00  0.00           H  
ATOM    179  N   ILE A  12      10.621  -4.014   4.092  1.00  0.00           N  
ATOM    180  CA  ILE A  12      10.986  -5.080   3.181  1.00  0.00           C  
ATOM    181  C   ILE A  12      10.970  -6.399   3.937  1.00  0.00           C  
ATOM    182  O   ILE A  12      11.869  -6.675   4.730  1.00  0.00           O  
ATOM    183  CB  ILE A  12      12.385  -4.851   2.571  1.00  0.00           C  
ATOM    184  CG1 ILE A  12      12.477  -3.452   1.952  1.00  0.00           C  
ATOM    185  CG2 ILE A  12      12.686  -5.916   1.526  1.00  0.00           C  
ATOM    186  CD1 ILE A  12      13.847  -3.114   1.399  1.00  0.00           C  
ATOM    187  H   ILE A  12      11.312  -3.617   4.672  1.00  0.00           H  
ATOM    188  HA  ILE A  12      10.252  -5.116   2.384  1.00  0.00           H  
ATOM    189  HB  ILE A  12      13.116  -4.938   3.361  1.00  0.00           H  
ATOM    190 HG12 ILE A  12      11.768  -3.380   1.141  1.00  0.00           H  
ATOM    191 HG13 ILE A  12      12.233  -2.719   2.704  1.00  0.00           H  
ATOM    192 HG21 ILE A  12      13.676  -5.756   1.127  1.00  0.00           H  
ATOM    193 HG22 ILE A  12      11.961  -5.848   0.730  1.00  0.00           H  
ATOM    194 HG23 ILE A  12      12.632  -6.894   1.982  1.00  0.00           H  
ATOM    195 HD11 ILE A  12      13.835  -2.113   0.994  1.00  0.00           H  
ATOM    196 HD12 ILE A  12      14.102  -3.815   0.618  1.00  0.00           H  
ATOM    197 HD13 ILE A  12      14.580  -3.174   2.190  1.00  0.00           H  
ATOM    198  N   THR A  13       9.944  -7.203   3.708  1.00  0.00           N  
ATOM    199  CA  THR A  13       9.785  -8.443   4.448  1.00  0.00           C  
ATOM    200  C   THR A  13      10.649  -9.542   3.839  1.00  0.00           C  
ATOM    201  O   THR A  13      10.884 -10.582   4.455  1.00  0.00           O  
ATOM    202  CB  THR A  13       8.303  -8.892   4.499  1.00  0.00           C  
ATOM    203  OG1 THR A  13       8.099  -9.796   5.595  1.00  0.00           O  
ATOM    204  CG2 THR A  13       7.876  -9.561   3.196  1.00  0.00           C  
ATOM    205  H   THR A  13       9.283  -6.962   3.023  1.00  0.00           H  
ATOM    206  HA  THR A  13      10.115  -8.262   5.462  1.00  0.00           H  
ATOM    207  HB  THR A  13       7.687  -8.016   4.650  1.00  0.00           H  
ATOM    208  HG1 THR A  13       7.629 -10.589   5.281  1.00  0.00           H  
ATOM    209 HG21 THR A  13       8.513 -10.411   3.002  1.00  0.00           H  
ATOM    210 HG22 THR A  13       7.958  -8.854   2.382  1.00  0.00           H  
ATOM    211 HG23 THR A  13       6.851  -9.893   3.281  1.00  0.00           H  
ATOM    212  N   GLY A  14      11.131  -9.298   2.628  1.00  0.00           N  
ATOM    213  CA  GLY A  14      11.973 -10.258   1.959  1.00  0.00           C  
ATOM    214  C   GLY A  14      11.974 -10.065   0.466  1.00  0.00           C  
ATOM    215  O   GLY A  14      11.556  -9.019  -0.031  1.00  0.00           O  
ATOM    216  H   GLY A  14      10.899  -8.457   2.177  1.00  0.00           H  
ATOM    217  HA2 GLY A  14      12.984 -10.157   2.328  1.00  0.00           H  
ATOM    218  HA3 GLY A  14      11.617 -11.254   2.182  1.00  0.00           H  
ATOM    219  N   TYR A  15      12.431 -11.072  -0.249  1.00  0.00           N  
ATOM    220  CA  TYR A  15      12.487 -11.014  -1.697  1.00  0.00           C  
ATOM    221  C   TYR A  15      11.274 -11.712  -2.293  1.00  0.00           C  
ATOM    222  O   TYR A  15      10.692 -12.600  -1.666  1.00  0.00           O  
ATOM    223  CB  TYR A  15      13.776 -11.663  -2.207  1.00  0.00           C  
ATOM    224  CG  TYR A  15      15.030 -11.080  -1.586  1.00  0.00           C  
ATOM    225  CD1 TYR A  15      15.646  -9.965  -2.137  1.00  0.00           C  
ATOM    226  CD2 TYR A  15      15.591 -11.640  -0.443  1.00  0.00           C  
ATOM    227  CE1 TYR A  15      16.784  -9.424  -1.569  1.00  0.00           C  
ATOM    228  CE2 TYR A  15      16.727 -11.101   0.130  1.00  0.00           C  
ATOM    229  CZ  TYR A  15      17.318  -9.994  -0.436  1.00  0.00           C  
ATOM    230  OH  TYR A  15      18.448  -9.455   0.131  1.00  0.00           O  
ATOM    231  H   TYR A  15      12.737 -11.885   0.211  1.00  0.00           H  
ATOM    232  HA  TYR A  15      12.473  -9.975  -1.989  1.00  0.00           H  
ATOM    233  HB2 TYR A  15      13.750 -12.719  -1.984  1.00  0.00           H  
ATOM    234  HB3 TYR A  15      13.838 -11.527  -3.276  1.00  0.00           H  
ATOM    235  HD1 TYR A  15      15.225  -9.519  -3.026  1.00  0.00           H  
ATOM    236  HD2 TYR A  15      15.125 -12.510   0.000  1.00  0.00           H  
ATOM    237  HE1 TYR A  15      17.247  -8.556  -2.013  1.00  0.00           H  
ATOM    238  HE2 TYR A  15      17.147 -11.552   1.020  1.00  0.00           H  
ATOM    239  HH  TYR A  15      18.436  -8.492   0.019  1.00  0.00           H  
ATOM    240  N   SER A  16      10.888 -11.303  -3.487  1.00  0.00           N  
ATOM    241  CA  SER A  16       9.744 -11.878  -4.163  1.00  0.00           C  
ATOM    242  C   SER A  16      10.073 -13.268  -4.704  1.00  0.00           C  
ATOM    243  O   SER A  16      11.242 -13.632  -4.823  1.00  0.00           O  
ATOM    244  CB  SER A  16       9.331 -10.956  -5.304  1.00  0.00           C  
ATOM    245  OG  SER A  16      10.372 -10.837  -6.255  1.00  0.00           O  
ATOM    246  H   SER A  16      11.388 -10.587  -3.937  1.00  0.00           H  
ATOM    247  HA  SER A  16       8.932 -11.953  -3.455  1.00  0.00           H  
ATOM    248  HB2 SER A  16       8.464 -11.358  -5.787  1.00  0.00           H  
ATOM    249  HB3 SER A  16       9.104  -9.975  -4.911  1.00  0.00           H  
ATOM    250  HG  SER A  16      10.156 -10.132  -6.883  1.00  0.00           H  
ATOM    251  N   PRO A  17       9.051 -14.074  -5.024  1.00  0.00           N  
ATOM    252  CA  PRO A  17       9.246 -15.381  -5.657  1.00  0.00           C  
ATOM    253  C   PRO A  17       9.696 -15.254  -7.113  1.00  0.00           C  
ATOM    254  O   PRO A  17      10.136 -16.225  -7.728  1.00  0.00           O  
ATOM    255  CB  PRO A  17       7.859 -16.040  -5.584  1.00  0.00           C  
ATOM    256  CG  PRO A  17       7.054 -15.186  -4.661  1.00  0.00           C  
ATOM    257  CD  PRO A  17       7.631 -13.806  -4.762  1.00  0.00           C  
ATOM    258  HA  PRO A  17       9.961 -15.979  -5.112  1.00  0.00           H  
ATOM    259  HB2 PRO A  17       7.423 -16.072  -6.573  1.00  0.00           H  
ATOM    260  HB3 PRO A  17       7.959 -17.046  -5.202  1.00  0.00           H  
ATOM    261  HG2 PRO A  17       6.017 -15.184  -4.970  1.00  0.00           H  
ATOM    262  HG3 PRO A  17       7.143 -15.555  -3.650  1.00  0.00           H  
ATOM    263  HD2 PRO A  17       7.179 -13.262  -5.580  1.00  0.00           H  
ATOM    264  HD3 PRO A  17       7.504 -13.271  -3.833  1.00  0.00           H  
ATOM    265  N   ALA A  18       9.591 -14.046  -7.654  1.00  0.00           N  
ATOM    266  CA  ALA A  18       9.946 -13.795  -9.046  1.00  0.00           C  
ATOM    267  C   ALA A  18      11.419 -13.428  -9.195  1.00  0.00           C  
ATOM    268  O   ALA A  18      11.900 -13.202 -10.307  1.00  0.00           O  
ATOM    269  CB  ALA A  18       9.073 -12.695  -9.623  1.00  0.00           C  
ATOM    270  H   ALA A  18       9.260 -13.304  -7.104  1.00  0.00           H  
ATOM    271  HA  ALA A  18       9.756 -14.700  -9.604  1.00  0.00           H  
ATOM    272  HB1 ALA A  18       9.292 -11.764  -9.124  1.00  0.00           H  
ATOM    273  HB2 ALA A  18       8.034 -12.948  -9.476  1.00  0.00           H  
ATOM    274  HB3 ALA A  18       9.275 -12.596 -10.679  1.00  0.00           H  
ATOM    275  N   ILE A  19      12.132 -13.371  -8.077  1.00  0.00           N  
ATOM    276  CA  ILE A  19      13.549 -13.038  -8.100  1.00  0.00           C  
ATOM    277  C   ILE A  19      14.333 -14.136  -8.824  1.00  0.00           C  
ATOM    278  O   ILE A  19      14.232 -15.316  -8.484  1.00  0.00           O  
ATOM    279  CB  ILE A  19      14.103 -12.809  -6.673  1.00  0.00           C  
ATOM    280  CG1 ILE A  19      15.528 -12.265  -6.731  1.00  0.00           C  
ATOM    281  CG2 ILE A  19      14.053 -14.089  -5.845  1.00  0.00           C  
ATOM    282  CD1 ILE A  19      16.071 -11.873  -5.375  1.00  0.00           C  
ATOM    283  H   ILE A  19      11.699 -13.563  -7.219  1.00  0.00           H  
ATOM    284  HA  ILE A  19      13.659 -12.115  -8.656  1.00  0.00           H  
ATOM    285  HB  ILE A  19      13.471 -12.079  -6.185  1.00  0.00           H  
ATOM    286 HG12 ILE A  19      16.180 -13.019  -7.143  1.00  0.00           H  
ATOM    287 HG13 ILE A  19      15.545 -11.390  -7.364  1.00  0.00           H  
ATOM    288 HG21 ILE A  19      13.026 -14.396  -5.718  1.00  0.00           H  
ATOM    289 HG22 ILE A  19      14.498 -13.910  -4.877  1.00  0.00           H  
ATOM    290 HG23 ILE A  19      14.600 -14.868  -6.355  1.00  0.00           H  
ATOM    291 HD11 ILE A  19      15.449 -11.102  -4.946  1.00  0.00           H  
ATOM    292 HD12 ILE A  19      17.078 -11.501  -5.486  1.00  0.00           H  
ATOM    293 HD13 ILE A  19      16.077 -12.737  -4.726  1.00  0.00           H  
ATOM    294  N   SER A  20      15.088 -13.751  -9.841  1.00  0.00           N  
ATOM    295  CA  SER A  20      15.749 -14.730 -10.694  1.00  0.00           C  
ATOM    296  C   SER A  20      17.173 -14.309 -11.047  1.00  0.00           C  
ATOM    297  O   SER A  20      17.532 -13.138 -10.921  1.00  0.00           O  
ATOM    298  CB  SER A  20      14.936 -14.921 -11.980  1.00  0.00           C  
ATOM    299  OG  SER A  20      13.565 -15.144 -11.685  1.00  0.00           O  
ATOM    300  H   SER A  20      15.209 -12.796 -10.022  1.00  0.00           H  
ATOM    301  HA  SER A  20      15.783 -15.667 -10.161  1.00  0.00           H  
ATOM    302  HB2 SER A  20      15.020 -14.038 -12.595  1.00  0.00           H  
ATOM    303  HB3 SER A  20      15.319 -15.774 -12.521  1.00  0.00           H  
ATOM    304  HG  SER A  20      13.207 -14.379 -11.215  1.00  0.00           H  
ATOM    305  N   ASN A  21      17.983 -15.292 -11.442  1.00  0.00           N  
ATOM    306  CA  ASN A  21      19.300 -15.061 -12.052  1.00  0.00           C  
ATOM    307  C   ASN A  21      20.253 -14.299 -11.126  1.00  0.00           C  
ATOM    308  O   ASN A  21      20.993 -13.416 -11.568  1.00  0.00           O  
ATOM    309  CB  ASN A  21      19.136 -14.315 -13.389  1.00  0.00           C  
ATOM    310  CG  ASN A  21      20.383 -14.386 -14.255  1.00  0.00           C  
ATOM    311  OD1 ASN A  21      21.137 -15.357 -14.199  1.00  0.00           O  
ATOM    312  ND2 ASN A  21      20.605 -13.364 -15.065  1.00  0.00           N  
ATOM    313  H   ASN A  21      17.690 -16.217 -11.307  1.00  0.00           H  
ATOM    314  HA  ASN A  21      19.731 -16.028 -12.255  1.00  0.00           H  
ATOM    315  HB2 ASN A  21      18.318 -14.752 -13.939  1.00  0.00           H  
ATOM    316  HB3 ASN A  21      18.915 -13.276 -13.188  1.00  0.00           H  
ATOM    317 HD21 ASN A  21      19.956 -12.617 -15.065  1.00  0.00           H  
ATOM    318 HD22 ASN A  21      21.404 -13.387 -15.632  1.00  0.00           H  
ATOM    319  N   GLY A  22      20.247 -14.646  -9.841  1.00  0.00           N  
ATOM    320  CA  GLY A  22      21.196 -14.057  -8.913  1.00  0.00           C  
ATOM    321  C   GLY A  22      20.916 -12.596  -8.630  1.00  0.00           C  
ATOM    322  O   GLY A  22      21.807 -11.863  -8.196  1.00  0.00           O  
ATOM    323  H   GLY A  22      19.593 -15.311  -9.519  1.00  0.00           H  
ATOM    324  HA2 GLY A  22      21.165 -14.599  -7.981  1.00  0.00           H  
ATOM    325  HA3 GLY A  22      22.187 -14.145  -9.333  1.00  0.00           H  
ATOM    326  N   TYR A  23      19.678 -12.169  -8.855  1.00  0.00           N  
ATOM    327  CA  TYR A  23      19.296 -10.786  -8.614  1.00  0.00           C  
ATOM    328  C   TYR A  23      19.365 -10.442  -7.130  1.00  0.00           C  
ATOM    329  O   TYR A  23      19.519  -9.279  -6.772  1.00  0.00           O  
ATOM    330  CB  TYR A  23      17.900 -10.501  -9.160  1.00  0.00           C  
ATOM    331  CG  TYR A  23      17.912  -9.732 -10.463  1.00  0.00           C  
ATOM    332  CD1 TYR A  23      18.517  -8.483 -10.544  1.00  0.00           C  
ATOM    333  CD2 TYR A  23      17.316 -10.246 -11.609  1.00  0.00           C  
ATOM    334  CE1 TYR A  23      18.527  -7.770 -11.727  1.00  0.00           C  
ATOM    335  CE2 TYR A  23      17.324  -9.539 -12.796  1.00  0.00           C  
ATOM    336  CZ  TYR A  23      17.929  -8.302 -12.850  1.00  0.00           C  
ATOM    337  OH  TYR A  23      17.931  -7.593 -14.030  1.00  0.00           O  
ATOM    338  H   TYR A  23      19.010 -12.793  -9.214  1.00  0.00           H  
ATOM    339  HA  TYR A  23      20.005 -10.160  -9.139  1.00  0.00           H  
ATOM    340  HB2 TYR A  23      17.392 -11.437  -9.332  1.00  0.00           H  
ATOM    341  HB3 TYR A  23      17.349  -9.925  -8.435  1.00  0.00           H  
ATOM    342  HD1 TYR A  23      18.983  -8.068  -9.664  1.00  0.00           H  
ATOM    343  HD2 TYR A  23      16.840 -11.216 -11.564  1.00  0.00           H  
ATOM    344  HE1 TYR A  23      19.004  -6.803 -11.770  1.00  0.00           H  
ATOM    345  HE2 TYR A  23      16.858  -9.956 -13.676  1.00  0.00           H  
ATOM    346  HH  TYR A  23      18.797  -7.181 -14.151  1.00  0.00           H  
ATOM    347  N   ARG A  24      19.275 -11.455  -6.271  1.00  0.00           N  
ATOM    348  CA  ARG A  24      19.399 -11.241  -4.835  1.00  0.00           C  
ATOM    349  C   ARG A  24      20.757 -10.633  -4.528  1.00  0.00           C  
ATOM    350  O   ARG A  24      20.894  -9.784  -3.651  1.00  0.00           O  
ATOM    351  CB  ARG A  24      19.253 -12.553  -4.063  1.00  0.00           C  
ATOM    352  CG  ARG A  24      18.989 -12.337  -2.583  1.00  0.00           C  
ATOM    353  CD  ARG A  24      19.634 -13.404  -1.713  1.00  0.00           C  
ATOM    354  NE  ARG A  24      19.259 -14.761  -2.106  1.00  0.00           N  
ATOM    355  CZ  ARG A  24      18.544 -15.588  -1.345  1.00  0.00           C  
ATOM    356  NH1 ARG A  24      18.065 -15.171  -0.178  1.00  0.00           N  
ATOM    357  NH2 ARG A  24      18.310 -16.830  -1.746  1.00  0.00           N  
ATOM    358  H   ARG A  24      19.118 -12.360  -6.610  1.00  0.00           H  
ATOM    359  HA  ARG A  24      18.626 -10.552  -4.527  1.00  0.00           H  
ATOM    360  HB2 ARG A  24      18.431 -13.115  -4.480  1.00  0.00           H  
ATOM    361  HB3 ARG A  24      20.163 -13.126  -4.167  1.00  0.00           H  
ATOM    362  HG2 ARG A  24      19.384 -11.374  -2.301  1.00  0.00           H  
ATOM    363  HG3 ARG A  24      17.921 -12.348  -2.418  1.00  0.00           H  
ATOM    364  HD2 ARG A  24      20.707 -13.307  -1.782  1.00  0.00           H  
ATOM    365  HD3 ARG A  24      19.327 -13.241  -0.690  1.00  0.00           H  
ATOM    366  HE  ARG A  24      19.597 -15.087  -2.977  1.00  0.00           H  
ATOM    367 HH11 ARG A  24      18.241 -14.237   0.133  1.00  0.00           H  
ATOM    368 HH12 ARG A  24      17.519 -15.794   0.400  1.00  0.00           H  
ATOM    369 HH21 ARG A  24      18.673 -17.158  -2.628  1.00  0.00           H  
ATOM    370 HH22 ARG A  24      17.774 -17.462  -1.166  1.00  0.00           H  
ATOM    371  N   GLN A  25      21.754 -11.072  -5.281  1.00  0.00           N  
ATOM    372  CA  GLN A  25      23.109 -10.595  -5.131  1.00  0.00           C  
ATOM    373  C   GLN A  25      23.226  -9.147  -5.583  1.00  0.00           C  
ATOM    374  O   GLN A  25      23.953  -8.358  -4.984  1.00  0.00           O  
ATOM    375  CB  GLN A  25      24.041 -11.496  -5.931  1.00  0.00           C  
ATOM    376  CG  GLN A  25      24.181 -12.893  -5.342  1.00  0.00           C  
ATOM    377  CD  GLN A  25      24.890 -13.858  -6.274  1.00  0.00           C  
ATOM    378  OE1 GLN A  25      25.586 -14.772  -5.828  1.00  0.00           O  
ATOM    379  NE2 GLN A  25      24.705 -13.675  -7.572  1.00  0.00           N  
ATOM    380  H   GLN A  25      21.569 -11.741  -5.973  1.00  0.00           H  
ATOM    381  HA  GLN A  25      23.369 -10.653  -4.089  1.00  0.00           H  
ATOM    382  HB2 GLN A  25      23.654 -11.589  -6.934  1.00  0.00           H  
ATOM    383  HB3 GLN A  25      25.011 -11.048  -5.973  1.00  0.00           H  
ATOM    384  HG2 GLN A  25      24.745 -12.826  -4.423  1.00  0.00           H  
ATOM    385  HG3 GLN A  25      23.194 -13.281  -5.126  1.00  0.00           H  
ATOM    386 HE21 GLN A  25      24.130 -12.935  -7.859  1.00  0.00           H  
ATOM    387 HE22 GLN A  25      25.149 -14.295  -8.197  1.00  0.00           H  
ATOM    388  N   ARG A  26      22.486  -8.798  -6.629  1.00  0.00           N  
ATOM    389  CA  ARG A  26      22.447  -7.424  -7.107  1.00  0.00           C  
ATOM    390  C   ARG A  26      21.772  -6.540  -6.067  1.00  0.00           C  
ATOM    391  O   ARG A  26      22.233  -5.438  -5.774  1.00  0.00           O  
ATOM    392  CB  ARG A  26      21.686  -7.339  -8.435  1.00  0.00           C  
ATOM    393  CG  ARG A  26      21.699  -5.953  -9.065  1.00  0.00           C  
ATOM    394  CD  ARG A  26      23.086  -5.579  -9.574  1.00  0.00           C  
ATOM    395  NE  ARG A  26      23.502  -6.432 -10.688  1.00  0.00           N  
ATOM    396  CZ  ARG A  26      24.686  -6.359 -11.296  1.00  0.00           C  
ATOM    397  NH1 ARG A  26      25.603  -5.489 -10.892  1.00  0.00           N  
ATOM    398  NH2 ARG A  26      24.950  -7.164 -12.316  1.00  0.00           N  
ATOM    399  H   ARG A  26      21.948  -9.481  -7.084  1.00  0.00           H  
ATOM    400  HA  ARG A  26      23.463  -7.089  -7.252  1.00  0.00           H  
ATOM    401  HB2 ARG A  26      22.127  -8.033  -9.131  1.00  0.00           H  
ATOM    402  HB3 ARG A  26      20.657  -7.623  -8.263  1.00  0.00           H  
ATOM    403  HG2 ARG A  26      21.007  -5.938  -9.892  1.00  0.00           H  
ATOM    404  HG3 ARG A  26      21.392  -5.230  -8.324  1.00  0.00           H  
ATOM    405  HD2 ARG A  26      23.070  -4.552  -9.907  1.00  0.00           H  
ATOM    406  HD3 ARG A  26      23.794  -5.686  -8.764  1.00  0.00           H  
ATOM    407  HE  ARG A  26      22.849  -7.094 -11.012  1.00  0.00           H  
ATOM    408 HH11 ARG A  26      25.416  -4.874 -10.119  1.00  0.00           H  
ATOM    409 HH12 ARG A  26      26.499  -5.443 -11.360  1.00  0.00           H  
ATOM    410 HH21 ARG A  26      24.255  -7.825 -12.627  1.00  0.00           H  
ATOM    411 HH22 ARG A  26      25.838  -7.116 -12.792  1.00  0.00           H  
ATOM    412  N   LEU A  27      20.692  -7.057  -5.498  1.00  0.00           N  
ATOM    413  CA  LEU A  27      19.930  -6.336  -4.485  1.00  0.00           C  
ATOM    414  C   LEU A  27      20.766  -6.159  -3.224  1.00  0.00           C  
ATOM    415  O   LEU A  27      20.794  -5.080  -2.637  1.00  0.00           O  
ATOM    416  CB  LEU A  27      18.638  -7.090  -4.153  1.00  0.00           C  
ATOM    417  CG  LEU A  27      17.687  -7.309  -5.331  1.00  0.00           C  
ATOM    418  CD1 LEU A  27      16.515  -8.179  -4.914  1.00  0.00           C  
ATOM    419  CD2 LEU A  27      17.189  -5.981  -5.875  1.00  0.00           C  
ATOM    420  H   LEU A  27      20.397  -7.955  -5.769  1.00  0.00           H  
ATOM    421  HA  LEU A  27      19.683  -5.361  -4.879  1.00  0.00           H  
ATOM    422  HB2 LEU A  27      18.904  -8.056  -3.751  1.00  0.00           H  
ATOM    423  HB3 LEU A  27      18.109  -6.535  -3.391  1.00  0.00           H  
ATOM    424  HG  LEU A  27      18.214  -7.818  -6.123  1.00  0.00           H  
ATOM    425 HD11 LEU A  27      15.985  -7.705  -4.103  1.00  0.00           H  
ATOM    426 HD12 LEU A  27      16.883  -9.141  -4.588  1.00  0.00           H  
ATOM    427 HD13 LEU A  27      15.848  -8.315  -5.752  1.00  0.00           H  
ATOM    428 HD21 LEU A  27      18.031  -5.395  -6.215  1.00  0.00           H  
ATOM    429 HD22 LEU A  27      16.667  -5.445  -5.097  1.00  0.00           H  
ATOM    430 HD23 LEU A  27      16.519  -6.160  -6.702  1.00  0.00           H  
ATOM    431  N   PHE A  28      21.462  -7.216  -2.831  1.00  0.00           N  
ATOM    432  CA  PHE A  28      22.329  -7.181  -1.659  1.00  0.00           C  
ATOM    433  C   PHE A  28      23.435  -6.156  -1.852  1.00  0.00           C  
ATOM    434  O   PHE A  28      23.782  -5.412  -0.934  1.00  0.00           O  
ATOM    435  CB  PHE A  28      22.938  -8.560  -1.422  1.00  0.00           C  
ATOM    436  CG  PHE A  28      23.580  -8.712  -0.072  1.00  0.00           C  
ATOM    437  CD1 PHE A  28      22.803  -8.816   1.074  1.00  0.00           C  
ATOM    438  CD2 PHE A  28      24.959  -8.752   0.052  1.00  0.00           C  
ATOM    439  CE1 PHE A  28      23.392  -8.957   2.315  1.00  0.00           C  
ATOM    440  CE2 PHE A  28      25.552  -8.893   1.292  1.00  0.00           C  
ATOM    441  CZ  PHE A  28      24.768  -8.993   2.426  1.00  0.00           C  
ATOM    442  H   PHE A  28      21.382  -8.055  -3.340  1.00  0.00           H  
ATOM    443  HA  PHE A  28      21.734  -6.904  -0.800  1.00  0.00           H  
ATOM    444  HB2 PHE A  28      22.165  -9.299  -1.512  1.00  0.00           H  
ATOM    445  HB3 PHE A  28      23.693  -8.744  -2.171  1.00  0.00           H  
ATOM    446  HD1 PHE A  28      21.727  -8.785   0.989  1.00  0.00           H  
ATOM    447  HD2 PHE A  28      25.576  -8.675  -0.832  1.00  0.00           H  
ATOM    448  HE1 PHE A  28      22.776  -9.036   3.199  1.00  0.00           H  
ATOM    449  HE2 PHE A  28      26.629  -8.920   1.377  1.00  0.00           H  
ATOM    450  HZ  PHE A  28      25.230  -9.102   3.395  1.00  0.00           H  
ATOM    451  N   SER A  29      23.977  -6.129  -3.060  1.00  0.00           N  
ATOM    452  CA  SER A  29      24.984  -5.148  -3.433  1.00  0.00           C  
ATOM    453  C   SER A  29      24.431  -3.730  -3.313  1.00  0.00           C  
ATOM    454  O   SER A  29      25.145  -2.809  -2.919  1.00  0.00           O  
ATOM    455  CB  SER A  29      25.459  -5.399  -4.864  1.00  0.00           C  
ATOM    456  OG  SER A  29      26.053  -6.681  -4.993  1.00  0.00           O  
ATOM    457  H   SER A  29      23.698  -6.801  -3.718  1.00  0.00           H  
ATOM    458  HA  SER A  29      25.818  -5.256  -2.760  1.00  0.00           H  
ATOM    459  HB2 SER A  29      24.613  -5.339  -5.535  1.00  0.00           H  
ATOM    460  HB3 SER A  29      26.183  -4.647  -5.137  1.00  0.00           H  
ATOM    461  HG  SER A  29      25.378  -7.364  -4.861  1.00  0.00           H  
ATOM    462  N   MET A  30      23.151  -3.572  -3.632  1.00  0.00           N  
ATOM    463  CA  MET A  30      22.510  -2.263  -3.602  1.00  0.00           C  
ATOM    464  C   MET A  30      22.021  -1.908  -2.198  1.00  0.00           C  
ATOM    465  O   MET A  30      21.643  -0.764  -1.934  1.00  0.00           O  
ATOM    466  CB  MET A  30      21.346  -2.219  -4.595  1.00  0.00           C  
ATOM    467  CG  MET A  30      21.793  -2.188  -6.048  1.00  0.00           C  
ATOM    468  SD  MET A  30      20.432  -1.902  -7.198  1.00  0.00           S  
ATOM    469  CE  MET A  30      19.391  -3.320  -6.862  1.00  0.00           C  
ATOM    470  H   MET A  30      22.625  -4.359  -3.899  1.00  0.00           H  
ATOM    471  HA  MET A  30      23.247  -1.535  -3.904  1.00  0.00           H  
ATOM    472  HB2 MET A  30      20.734  -3.098  -4.449  1.00  0.00           H  
ATOM    473  HB3 MET A  30      20.753  -1.344  -4.399  1.00  0.00           H  
ATOM    474  HG2 MET A  30      22.517  -1.395  -6.168  1.00  0.00           H  
ATOM    475  HG3 MET A  30      22.256  -3.135  -6.286  1.00  0.00           H  
ATOM    476  HE1 MET A  30      19.958  -4.224  -7.017  1.00  0.00           H  
ATOM    477  HE2 MET A  30      18.541  -3.308  -7.530  1.00  0.00           H  
ATOM    478  HE3 MET A  30      19.047  -3.280  -5.838  1.00  0.00           H  
ATOM    479  N   GLY A  31      22.026  -2.887  -1.307  1.00  0.00           N  
ATOM    480  CA  GLY A  31      21.625  -2.647   0.068  1.00  0.00           C  
ATOM    481  C   GLY A  31      20.157  -2.942   0.308  1.00  0.00           C  
ATOM    482  O   GLY A  31      19.535  -2.351   1.189  1.00  0.00           O  
ATOM    483  H   GLY A  31      22.307  -3.785  -1.582  1.00  0.00           H  
ATOM    484  HA2 GLY A  31      22.220  -3.272   0.719  1.00  0.00           H  
ATOM    485  HA3 GLY A  31      21.815  -1.612   0.311  1.00  0.00           H  
ATOM    486  N   LEU A  32      19.603  -3.853  -0.478  1.00  0.00           N  
ATOM    487  CA  LEU A  32      18.207  -4.243  -0.329  1.00  0.00           C  
ATOM    488  C   LEU A  32      18.100  -5.621   0.314  1.00  0.00           C  
ATOM    489  O   LEU A  32      18.337  -6.644  -0.331  1.00  0.00           O  
ATOM    490  CB  LEU A  32      17.505  -4.234  -1.690  1.00  0.00           C  
ATOM    491  CG  LEU A  32      17.473  -2.876  -2.397  1.00  0.00           C  
ATOM    492  CD1 LEU A  32      16.824  -3.005  -3.766  1.00  0.00           C  
ATOM    493  CD2 LEU A  32      16.729  -1.853  -1.552  1.00  0.00           C  
ATOM    494  H   LEU A  32      20.143  -4.279  -1.178  1.00  0.00           H  
ATOM    495  HA  LEU A  32      17.729  -3.521   0.319  1.00  0.00           H  
ATOM    496  HB2 LEU A  32      18.008  -4.943  -2.334  1.00  0.00           H  
ATOM    497  HB3 LEU A  32      16.486  -4.565  -1.549  1.00  0.00           H  
ATOM    498  HG  LEU A  32      18.486  -2.524  -2.539  1.00  0.00           H  
ATOM    499 HD11 LEU A  32      15.813  -3.370  -3.652  1.00  0.00           H  
ATOM    500 HD12 LEU A  32      17.390  -3.697  -4.371  1.00  0.00           H  
ATOM    501 HD13 LEU A  32      16.804  -2.039  -4.248  1.00  0.00           H  
ATOM    502 HD21 LEU A  32      16.726  -0.900  -2.059  1.00  0.00           H  
ATOM    503 HD22 LEU A  32      17.221  -1.752  -0.596  1.00  0.00           H  
ATOM    504 HD23 LEU A  32      15.712  -2.185  -1.400  1.00  0.00           H  
ATOM    505  N   LEU A  33      17.772  -5.639   1.597  1.00  0.00           N  
ATOM    506  CA  LEU A  33      17.648  -6.876   2.339  1.00  0.00           C  
ATOM    507  C   LEU A  33      16.422  -6.826   3.248  1.00  0.00           C  
ATOM    508  O   LEU A  33      15.935  -5.742   3.584  1.00  0.00           O  
ATOM    509  CB  LEU A  33      18.913  -7.130   3.172  1.00  0.00           C  
ATOM    510  CG  LEU A  33      19.238  -6.084   4.246  1.00  0.00           C  
ATOM    511  CD1 LEU A  33      20.176  -6.677   5.282  1.00  0.00           C  
ATOM    512  CD2 LEU A  33      19.874  -4.846   3.632  1.00  0.00           C  
ATOM    513  H   LEU A  33      17.618  -4.795   2.066  1.00  0.00           H  
ATOM    514  HA  LEU A  33      17.527  -7.679   1.628  1.00  0.00           H  
ATOM    515  HB2 LEU A  33      18.800  -8.083   3.658  1.00  0.00           H  
ATOM    516  HB3 LEU A  33      19.752  -7.189   2.496  1.00  0.00           H  
ATOM    517  HG  LEU A  33      18.327  -5.788   4.743  1.00  0.00           H  
ATOM    518 HD11 LEU A  33      21.089  -6.993   4.799  1.00  0.00           H  
ATOM    519 HD12 LEU A  33      19.704  -7.527   5.750  1.00  0.00           H  
ATOM    520 HD13 LEU A  33      20.404  -5.933   6.032  1.00  0.00           H  
ATOM    521 HD21 LEU A  33      20.041  -4.105   4.402  1.00  0.00           H  
ATOM    522 HD22 LEU A  33      19.217  -4.442   2.877  1.00  0.00           H  
ATOM    523 HD23 LEU A  33      20.819  -5.112   3.181  1.00  0.00           H  
ATOM    524  N   PRO A  34      15.890  -7.996   3.635  1.00  0.00           N  
ATOM    525  CA  PRO A  34      14.740  -8.079   4.539  1.00  0.00           C  
ATOM    526  C   PRO A  34      15.045  -7.478   5.906  1.00  0.00           C  
ATOM    527  O   PRO A  34      16.122  -7.699   6.466  1.00  0.00           O  
ATOM    528  CB  PRO A  34      14.482  -9.585   4.671  1.00  0.00           C  
ATOM    529  CG  PRO A  34      15.179 -10.203   3.509  1.00  0.00           C  
ATOM    530  CD  PRO A  34      16.364  -9.327   3.229  1.00  0.00           C  
ATOM    531  HA  PRO A  34      13.868  -7.596   4.120  1.00  0.00           H  
ATOM    532  HB2 PRO A  34      14.884  -9.938   5.608  1.00  0.00           H  
ATOM    533  HB3 PRO A  34      13.418  -9.773   4.638  1.00  0.00           H  
ATOM    534  HG2 PRO A  34      15.502 -11.201   3.763  1.00  0.00           H  
ATOM    535  HG3 PRO A  34      14.522 -10.226   2.652  1.00  0.00           H  
ATOM    536  HD2 PRO A  34      17.213  -9.636   3.824  1.00  0.00           H  
ATOM    537  HD3 PRO A  34      16.609  -9.345   2.178  1.00  0.00           H  
ATOM    538  N   GLY A  35      14.103  -6.713   6.431  1.00  0.00           N  
ATOM    539  CA  GLY A  35      14.293  -6.097   7.727  1.00  0.00           C  
ATOM    540  C   GLY A  35      14.354  -4.587   7.642  1.00  0.00           C  
ATOM    541  O   GLY A  35      14.180  -3.899   8.648  1.00  0.00           O  
ATOM    542  H   GLY A  35      13.264  -6.568   5.934  1.00  0.00           H  
ATOM    543  HA2 GLY A  35      13.473  -6.378   8.372  1.00  0.00           H  
ATOM    544  HA3 GLY A  35      15.215  -6.461   8.157  1.00  0.00           H  
ATOM    545  N   ALA A  36      14.596  -4.069   6.443  1.00  0.00           N  
ATOM    546  CA  ALA A  36      14.678  -2.644   6.237  1.00  0.00           C  
ATOM    547  C   ALA A  36      13.295  -2.068   5.996  1.00  0.00           C  
ATOM    548  O   ALA A  36      12.306  -2.802   5.909  1.00  0.00           O  
ATOM    549  CB  ALA A  36      15.606  -2.323   5.073  1.00  0.00           C  
ATOM    550  H   ALA A  36      14.710  -4.656   5.679  1.00  0.00           H  
ATOM    551  HA  ALA A  36      15.091  -2.198   7.130  1.00  0.00           H  
ATOM    552  HB1 ALA A  36      15.700  -1.252   4.972  1.00  0.00           H  
ATOM    553  HB2 ALA A  36      15.197  -2.734   4.161  1.00  0.00           H  
ATOM    554  HB3 ALA A  36      16.578  -2.755   5.257  1.00  0.00           H  
ATOM    555  N   ALA A  37      13.237  -0.766   5.877  1.00  0.00           N  
ATOM    556  CA  ALA A  37      11.976  -0.060   5.703  1.00  0.00           C  
ATOM    557  C   ALA A  37      12.164   1.197   4.862  1.00  0.00           C  
ATOM    558  O   ALA A  37      13.222   1.826   4.893  1.00  0.00           O  
ATOM    559  CB  ALA A  37      11.378   0.296   7.058  1.00  0.00           C  
ATOM    560  H   ALA A  37      14.074  -0.261   5.897  1.00  0.00           H  
ATOM    561  HA  ALA A  37      11.291  -0.721   5.195  1.00  0.00           H  
ATOM    562  HB1 ALA A  37      10.417   0.772   6.916  1.00  0.00           H  
ATOM    563  HB2 ALA A  37      12.040   0.968   7.582  1.00  0.00           H  
ATOM    564  HB3 ALA A  37      11.247  -0.605   7.641  1.00  0.00           H  
ATOM    565  N   LEU A  38      11.136   1.551   4.106  1.00  0.00           N  
ATOM    566  CA  LEU A  38      11.167   2.741   3.275  1.00  0.00           C  
ATOM    567  C   LEU A  38      10.013   3.666   3.642  1.00  0.00           C  
ATOM    568  O   LEU A  38       8.861   3.236   3.733  1.00  0.00           O  
ATOM    569  CB  LEU A  38      11.068   2.368   1.796  1.00  0.00           C  
ATOM    570  CG  LEU A  38      12.076   1.325   1.306  1.00  0.00           C  
ATOM    571  CD1 LEU A  38      11.784   0.947  -0.138  1.00  0.00           C  
ATOM    572  CD2 LEU A  38      13.497   1.852   1.439  1.00  0.00           C  
ATOM    573  H   LEU A  38      10.329   0.987   4.100  1.00  0.00           H  
ATOM    574  HA  LEU A  38      12.101   3.254   3.452  1.00  0.00           H  
ATOM    575  HB2 LEU A  38      10.075   1.997   1.613  1.00  0.00           H  
ATOM    576  HB3 LEU A  38      11.207   3.266   1.214  1.00  0.00           H  
ATOM    577  HG  LEU A  38      11.991   0.432   1.910  1.00  0.00           H  
ATOM    578 HD11 LEU A  38      12.476   0.181  -0.460  1.00  0.00           H  
ATOM    579 HD12 LEU A  38      11.897   1.818  -0.768  1.00  0.00           H  
ATOM    580 HD13 LEU A  38      10.773   0.575  -0.217  1.00  0.00           H  
ATOM    581 HD21 LEU A  38      13.704   2.069   2.476  1.00  0.00           H  
ATOM    582 HD22 LEU A  38      13.600   2.755   0.856  1.00  0.00           H  
ATOM    583 HD23 LEU A  38      14.193   1.111   1.079  1.00  0.00           H  
ATOM    584  N   ARG A  39      10.333   4.923   3.856  1.00  0.00           N  
ATOM    585  CA  ARG A  39       9.334   5.932   4.184  1.00  0.00           C  
ATOM    586  C   ARG A  39       8.961   6.703   2.925  1.00  0.00           C  
ATOM    587  O   ARG A  39       9.817   7.327   2.304  1.00  0.00           O  
ATOM    588  CB  ARG A  39       9.894   6.874   5.253  1.00  0.00           C  
ATOM    589  CG  ARG A  39       8.920   7.944   5.711  1.00  0.00           C  
ATOM    590  CD  ARG A  39       9.476   8.722   6.894  1.00  0.00           C  
ATOM    591  NE  ARG A  39       9.719   7.855   8.046  1.00  0.00           N  
ATOM    592  CZ  ARG A  39       9.378   8.159   9.296  1.00  0.00           C  
ATOM    593  NH1 ARG A  39       8.869   9.353   9.582  1.00  0.00           N  
ATOM    594  NH2 ARG A  39       9.586   7.278  10.266  1.00  0.00           N  
ATOM    595  H   ARG A  39      11.277   5.188   3.788  1.00  0.00           H  
ATOM    596  HA  ARG A  39       8.458   5.429   4.568  1.00  0.00           H  
ATOM    597  HB2 ARG A  39      10.181   6.291   6.115  1.00  0.00           H  
ATOM    598  HB3 ARG A  39      10.772   7.365   4.855  1.00  0.00           H  
ATOM    599  HG2 ARG A  39       8.739   8.628   4.896  1.00  0.00           H  
ATOM    600  HG3 ARG A  39       7.995   7.472   6.005  1.00  0.00           H  
ATOM    601  HD2 ARG A  39      10.406   9.185   6.601  1.00  0.00           H  
ATOM    602  HD3 ARG A  39       8.765   9.486   7.173  1.00  0.00           H  
ATOM    603  HE  ARG A  39      10.152   6.979   7.868  1.00  0.00           H  
ATOM    604 HH11 ARG A  39       8.743  10.034   8.856  1.00  0.00           H  
ATOM    605 HH12 ARG A  39       8.607   9.579  10.530  1.00  0.00           H  
ATOM    606 HH21 ARG A  39      10.000   6.390  10.058  1.00  0.00           H  
ATOM    607 HH22 ARG A  39       9.321   7.493  11.216  1.00  0.00           H  
ATOM    608  N   VAL A  40       7.692   6.652   2.548  1.00  0.00           N  
ATOM    609  CA  VAL A  40       7.247   7.201   1.270  1.00  0.00           C  
ATOM    610  C   VAL A  40       7.497   8.707   1.152  1.00  0.00           C  
ATOM    611  O   VAL A  40       7.142   9.488   2.040  1.00  0.00           O  
ATOM    612  CB  VAL A  40       5.747   6.908   1.013  1.00  0.00           C  
ATOM    613  CG1 VAL A  40       4.860   7.617   2.025  1.00  0.00           C  
ATOM    614  CG2 VAL A  40       5.358   7.295  -0.405  1.00  0.00           C  
ATOM    615  H   VAL A  40       7.032   6.240   3.147  1.00  0.00           H  
ATOM    616  HA  VAL A  40       7.815   6.708   0.494  1.00  0.00           H  
ATOM    617  HB  VAL A  40       5.587   5.847   1.125  1.00  0.00           H  
ATOM    618 HG11 VAL A  40       5.039   8.681   1.978  1.00  0.00           H  
ATOM    619 HG12 VAL A  40       5.089   7.256   3.018  1.00  0.00           H  
ATOM    620 HG13 VAL A  40       3.824   7.417   1.800  1.00  0.00           H  
ATOM    621 HG21 VAL A  40       5.532   8.352  -0.548  1.00  0.00           H  
ATOM    622 HG22 VAL A  40       4.313   7.076  -0.564  1.00  0.00           H  
ATOM    623 HG23 VAL A  40       5.955   6.734  -1.108  1.00  0.00           H  
ATOM    624  N   VAL A  41       8.161   9.093   0.067  1.00  0.00           N  
ATOM    625  CA  VAL A  41       8.215  10.482  -0.345  1.00  0.00           C  
ATOM    626  C   VAL A  41       7.170  10.712  -1.429  1.00  0.00           C  
ATOM    627  O   VAL A  41       6.311  11.581  -1.293  1.00  0.00           O  
ATOM    628  CB  VAL A  41       9.617  10.879  -0.862  1.00  0.00           C  
ATOM    629  CG1 VAL A  41       9.610  12.292  -1.420  1.00  0.00           C  
ATOM    630  CG2 VAL A  41      10.652  10.750   0.247  1.00  0.00           C  
ATOM    631  H   VAL A  41       8.648   8.420  -0.466  1.00  0.00           H  
ATOM    632  HA  VAL A  41       7.975  11.095   0.513  1.00  0.00           H  
ATOM    633  HB  VAL A  41       9.889  10.205  -1.661  1.00  0.00           H  
ATOM    634 HG11 VAL A  41      10.598  12.538  -1.778  1.00  0.00           H  
ATOM    635 HG12 VAL A  41       9.326  12.985  -0.643  1.00  0.00           H  
ATOM    636 HG13 VAL A  41       8.906  12.356  -2.236  1.00  0.00           H  
ATOM    637 HG21 VAL A  41      10.367  11.378   1.077  1.00  0.00           H  
ATOM    638 HG22 VAL A  41      11.617  11.062  -0.125  1.00  0.00           H  
ATOM    639 HG23 VAL A  41      10.705   9.723   0.572  1.00  0.00           H  
ATOM    640  N   ARG A  42       7.240   9.901  -2.495  1.00  0.00           N  
ATOM    641  CA  ARG A  42       6.236   9.923  -3.569  1.00  0.00           C  
ATOM    642  C   ARG A  42       6.631   9.024  -4.740  1.00  0.00           C  
ATOM    643  O   ARG A  42       7.808   8.727  -4.951  1.00  0.00           O  
ATOM    644  CB  ARG A  42       5.992  11.343  -4.102  1.00  0.00           C  
ATOM    645  CG  ARG A  42       7.205  11.994  -4.750  1.00  0.00           C  
ATOM    646  CD  ARG A  42       6.829  13.304  -5.421  1.00  0.00           C  
ATOM    647  NE  ARG A  42       7.974  13.962  -6.044  1.00  0.00           N  
ATOM    648  CZ  ARG A  42       8.011  14.343  -7.321  1.00  0.00           C  
ATOM    649  NH1 ARG A  42       6.988  14.080  -8.128  1.00  0.00           N  
ATOM    650  NH2 ARG A  42       9.080  14.976  -7.790  1.00  0.00           N  
ATOM    651  H   ARG A  42       7.985   9.260  -2.553  1.00  0.00           H  
ATOM    652  HA  ARG A  42       5.313   9.550  -3.151  1.00  0.00           H  
ATOM    653  HB2 ARG A  42       5.203  11.305  -4.837  1.00  0.00           H  
ATOM    654  HB3 ARG A  42       5.672  11.970  -3.281  1.00  0.00           H  
ATOM    655  HG2 ARG A  42       7.947  12.188  -3.988  1.00  0.00           H  
ATOM    656  HG3 ARG A  42       7.611  11.321  -5.489  1.00  0.00           H  
ATOM    657  HD2 ARG A  42       6.092  13.102  -6.182  1.00  0.00           H  
ATOM    658  HD3 ARG A  42       6.407  13.965  -4.679  1.00  0.00           H  
ATOM    659  HE  ARG A  42       8.751  14.150  -5.472  1.00  0.00           H  
ATOM    660 HH11 ARG A  42       6.177  13.592  -7.781  1.00  0.00           H  
ATOM    661 HH12 ARG A  42       7.019  14.367  -9.096  1.00  0.00           H  
ATOM    662 HH21 ARG A  42       9.862  15.166  -7.185  1.00  0.00           H  
ATOM    663 HH22 ARG A  42       9.112  15.276  -8.751  1.00  0.00           H  
ATOM    664  N   ILE A  43       5.623   8.595  -5.493  1.00  0.00           N  
ATOM    665  CA  ILE A  43       5.825   7.908  -6.765  1.00  0.00           C  
ATOM    666  C   ILE A  43       5.189   8.753  -7.869  1.00  0.00           C  
ATOM    667  O   ILE A  43       4.146   9.374  -7.650  1.00  0.00           O  
ATOM    668  CB  ILE A  43       5.186   6.495  -6.774  1.00  0.00           C  
ATOM    669  CG1 ILE A  43       5.844   5.617  -5.704  1.00  0.00           C  
ATOM    670  CG2 ILE A  43       5.305   5.844  -8.159  1.00  0.00           C  
ATOM    671  CD1 ILE A  43       5.218   4.247  -5.566  1.00  0.00           C  
ATOM    672  H   ILE A  43       4.705   8.749  -5.188  1.00  0.00           H  
ATOM    673  HA  ILE A  43       6.895   7.811  -6.936  1.00  0.00           H  
ATOM    674  HB  ILE A  43       4.137   6.600  -6.543  1.00  0.00           H  
ATOM    675 HG12 ILE A  43       6.885   5.479  -5.951  1.00  0.00           H  
ATOM    676 HG13 ILE A  43       5.770   6.116  -4.747  1.00  0.00           H  
ATOM    677 HG21 ILE A  43       4.798   6.455  -8.895  1.00  0.00           H  
ATOM    678 HG22 ILE A  43       4.853   4.863  -8.141  1.00  0.00           H  
ATOM    679 HG23 ILE A  43       6.347   5.752  -8.430  1.00  0.00           H  
ATOM    680 HD11 ILE A  43       5.739   3.688  -4.801  1.00  0.00           H  
ATOM    681 HD12 ILE A  43       5.290   3.721  -6.506  1.00  0.00           H  
ATOM    682 HD13 ILE A  43       4.179   4.352  -5.289  1.00  0.00           H  
ATOM    683  N   ALA A  44       5.818   8.812  -9.032  1.00  0.00           N  
ATOM    684  CA  ALA A  44       5.251   9.537 -10.164  1.00  0.00           C  
ATOM    685  C   ALA A  44       4.096   8.749 -10.781  1.00  0.00           C  
ATOM    686  O   ALA A  44       4.215   7.545 -11.018  1.00  0.00           O  
ATOM    687  CB  ALA A  44       6.318   9.821 -11.211  1.00  0.00           C  
ATOM    688  H   ALA A  44       6.681   8.363  -9.132  1.00  0.00           H  
ATOM    689  HA  ALA A  44       4.874  10.481  -9.799  1.00  0.00           H  
ATOM    690  HB1 ALA A  44       7.120  10.393 -10.765  1.00  0.00           H  
ATOM    691  HB2 ALA A  44       5.885  10.382 -12.026  1.00  0.00           H  
ATOM    692  HB3 ALA A  44       6.708   8.886 -11.584  1.00  0.00           H  
ATOM    693  N   PRO A  45       2.970   9.429 -11.064  1.00  0.00           N  
ATOM    694  CA  PRO A  45       1.739   8.786 -11.557  1.00  0.00           C  
ATOM    695  C   PRO A  45       1.895   8.194 -12.956  1.00  0.00           C  
ATOM    696  O   PRO A  45       1.109   7.334 -13.363  1.00  0.00           O  
ATOM    697  CB  PRO A  45       0.725   9.931 -11.576  1.00  0.00           C  
ATOM    698  CG  PRO A  45       1.550  11.161 -11.702  1.00  0.00           C  
ATOM    699  CD  PRO A  45       2.803  10.888 -10.922  1.00  0.00           C  
ATOM    700  HA  PRO A  45       1.403   8.016 -10.881  1.00  0.00           H  
ATOM    701  HB2 PRO A  45       0.059   9.810 -12.418  1.00  0.00           H  
ATOM    702  HB3 PRO A  45       0.157   9.927 -10.656  1.00  0.00           H  
ATOM    703  HG2 PRO A  45       1.785  11.344 -12.741  1.00  0.00           H  
ATOM    704  HG3 PRO A  45       1.024  12.005 -11.280  1.00  0.00           H  
ATOM    705  HD2 PRO A  45       3.639  11.419 -11.352  1.00  0.00           H  
ATOM    706  HD3 PRO A  45       2.670  11.159  -9.887  1.00  0.00           H  
ATOM    707  N   LEU A  46       2.907   8.672 -13.680  1.00  0.00           N  
ATOM    708  CA  LEU A  46       3.238   8.157 -15.011  1.00  0.00           C  
ATOM    709  C   LEU A  46       3.369   6.651 -14.980  1.00  0.00           C  
ATOM    710  O   LEU A  46       2.848   5.941 -15.839  1.00  0.00           O  
ATOM    711  CB  LEU A  46       4.561   8.751 -15.501  1.00  0.00           C  
ATOM    712  CG  LEU A  46       4.444  10.046 -16.313  1.00  0.00           C  
ATOM    713  CD1 LEU A  46       3.594   9.820 -17.560  1.00  0.00           C  
ATOM    714  CD2 LEU A  46       3.864  11.166 -15.459  1.00  0.00           C  
ATOM    715  H   LEU A  46       3.447   9.394 -13.306  1.00  0.00           H  
ATOM    716  HA  LEU A  46       2.447   8.434 -15.690  1.00  0.00           H  
ATOM    717  HB2 LEU A  46       5.181   8.948 -14.635  1.00  0.00           H  
ATOM    718  HB3 LEU A  46       5.062   8.009 -16.107  1.00  0.00           H  
ATOM    719  HG  LEU A  46       5.430  10.348 -16.636  1.00  0.00           H  
ATOM    720 HD11 LEU A  46       3.547  10.734 -18.136  1.00  0.00           H  
ATOM    721 HD12 LEU A  46       2.594   9.529 -17.268  1.00  0.00           H  
ATOM    722 HD13 LEU A  46       4.034   9.038 -18.162  1.00  0.00           H  
ATOM    723 HD21 LEU A  46       2.887  10.878 -15.101  1.00  0.00           H  
ATOM    724 HD22 LEU A  46       3.779  12.066 -16.051  1.00  0.00           H  
ATOM    725 HD23 LEU A  46       4.515  11.350 -14.617  1.00  0.00           H  
ATOM    726  N   GLY A  47       4.060   6.185 -13.966  1.00  0.00           N  
ATOM    727  CA  GLY A  47       4.316   4.785 -13.811  1.00  0.00           C  
ATOM    728  C   GLY A  47       5.014   4.526 -12.518  1.00  0.00           C  
ATOM    729  O   GLY A  47       4.395   4.058 -11.558  1.00  0.00           O  
ATOM    730  H   GLY A  47       4.397   6.811 -13.294  1.00  0.00           H  
ATOM    731  HA2 GLY A  47       3.381   4.242 -13.833  1.00  0.00           H  
ATOM    732  HA3 GLY A  47       4.942   4.448 -14.612  1.00  0.00           H  
ATOM    733  N   ASP A  48       6.295   4.872 -12.471  1.00  0.00           N  
ATOM    734  CA  ASP A  48       7.069   4.647 -11.276  1.00  0.00           C  
ATOM    735  C   ASP A  48       8.499   5.137 -11.356  1.00  0.00           C  
ATOM    736  O   ASP A  48       9.219   4.894 -12.315  1.00  0.00           O  
ATOM    737  CB  ASP A  48       7.142   3.150 -11.011  1.00  0.00           C  
ATOM    738  CG  ASP A  48       7.865   2.412 -12.129  1.00  0.00           C  
ATOM    739  OD1 ASP A  48       7.234   2.145 -13.172  1.00  0.00           O  
ATOM    740  OD2 ASP A  48       9.074   2.105 -11.975  1.00  0.00           O  
ATOM    741  H   ASP A  48       6.722   5.268 -13.251  1.00  0.00           H  
ATOM    742  HA  ASP A  48       6.579   5.121 -10.445  1.00  0.00           H  
ATOM    743  HB2 ASP A  48       7.679   2.992 -10.102  1.00  0.00           H  
ATOM    744  HB3 ASP A  48       6.142   2.749 -10.919  1.00  0.00           H  
ATOM    745  N   PRO A  49       8.864   5.934 -10.375  1.00  0.00           N  
ATOM    746  CA  PRO A  49      10.045   5.760  -9.587  1.00  0.00           C  
ATOM    747  C   PRO A  49       9.581   5.454  -8.174  1.00  0.00           C  
ATOM    748  O   PRO A  49       8.391   5.209  -7.959  1.00  0.00           O  
ATOM    749  CB  PRO A  49      10.678   7.145  -9.663  1.00  0.00           C  
ATOM    750  CG  PRO A  49       9.511   8.086  -9.839  1.00  0.00           C  
ATOM    751  CD  PRO A  49       8.278   7.229 -10.067  1.00  0.00           C  
ATOM    752  HA  PRO A  49      10.701   4.982  -9.960  1.00  0.00           H  
ATOM    753  HB2 PRO A  49      11.217   7.345  -8.749  1.00  0.00           H  
ATOM    754  HB3 PRO A  49      11.350   7.188 -10.503  1.00  0.00           H  
ATOM    755  HG2 PRO A  49       9.387   8.685  -8.949  1.00  0.00           H  
ATOM    756  HG3 PRO A  49       9.685   8.722 -10.694  1.00  0.00           H  
ATOM    757  HD2 PRO A  49       7.677   7.183  -9.172  1.00  0.00           H  
ATOM    758  HD3 PRO A  49       7.701   7.603 -10.899  1.00  0.00           H  
ATOM    759  N   ILE A  50      10.464   5.483  -7.214  1.00  0.00           N  
ATOM    760  CA  ILE A  50      10.034   5.395  -5.833  1.00  0.00           C  
ATOM    761  C   ILE A  50      10.934   6.248  -4.971  1.00  0.00           C  
ATOM    762  O   ILE A  50      12.048   5.849  -4.652  1.00  0.00           O  
ATOM    763  CB  ILE A  50      10.028   3.942  -5.286  1.00  0.00           C  
ATOM    764  CG1 ILE A  50       9.041   3.067  -6.065  1.00  0.00           C  
ATOM    765  CG2 ILE A  50       9.678   3.936  -3.802  1.00  0.00           C  
ATOM    766  CD1 ILE A  50       8.957   1.645  -5.561  1.00  0.00           C  
ATOM    767  H   ILE A  50      11.415   5.572  -7.428  1.00  0.00           H  
ATOM    768  HA  ILE A  50       9.019   5.791  -5.780  1.00  0.00           H  
ATOM    769  HB  ILE A  50      11.022   3.536  -5.395  1.00  0.00           H  
ATOM    770 HG12 ILE A  50       8.054   3.498  -5.990  1.00  0.00           H  
ATOM    771 HG13 ILE A  50       9.340   3.039  -7.104  1.00  0.00           H  
ATOM    772 HG21 ILE A  50       8.688   4.343  -3.667  1.00  0.00           H  
ATOM    773 HG22 ILE A  50      10.391   4.544  -3.262  1.00  0.00           H  
ATOM    774 HG23 ILE A  50       9.708   2.924  -3.426  1.00  0.00           H  
ATOM    775 HD11 ILE A  50       8.277   1.083  -6.182  1.00  0.00           H  
ATOM    776 HD12 ILE A  50       8.597   1.644  -4.542  1.00  0.00           H  
ATOM    777 HD13 ILE A  50       9.936   1.193  -5.596  1.00  0.00           H  
ATOM    778  N   GLN A  51      10.468   7.435  -4.637  1.00  0.00           N  
ATOM    779  CA  GLN A  51      11.186   8.288  -3.721  1.00  0.00           C  
ATOM    780  C   GLN A  51      10.800   7.940  -2.301  1.00  0.00           C  
ATOM    781  O   GLN A  51       9.622   7.984  -1.942  1.00  0.00           O  
ATOM    782  CB  GLN A  51      10.895   9.758  -4.006  1.00  0.00           C  
ATOM    783  CG  GLN A  51      11.593  10.299  -5.242  1.00  0.00           C  
ATOM    784  CD  GLN A  51      13.104  10.386  -5.093  1.00  0.00           C  
ATOM    785  OE1 GLN A  51      13.727   9.608  -4.370  1.00  0.00           O  
ATOM    786  NE2 GLN A  51      13.704  11.352  -5.774  1.00  0.00           N  
ATOM    787  H   GLN A  51       9.614   7.748  -5.012  1.00  0.00           H  
ATOM    788  HA  GLN A  51      12.242   8.104  -3.852  1.00  0.00           H  
ATOM    789  HB2 GLN A  51       9.830   9.885  -4.140  1.00  0.00           H  
ATOM    790  HB3 GLN A  51      11.209  10.340  -3.158  1.00  0.00           H  
ATOM    791  HG2 GLN A  51      11.369   9.653  -6.075  1.00  0.00           H  
ATOM    792  HG3 GLN A  51      11.213  11.284  -5.438  1.00  0.00           H  
ATOM    793 HE21 GLN A  51      13.148  11.947  -6.323  1.00  0.00           H  
ATOM    794 HE22 GLN A  51      14.678  11.429  -5.705  1.00  0.00           H  
ATOM    795  N   VAL A  52      11.783   7.570  -1.508  1.00  0.00           N  
ATOM    796  CA  VAL A  52      11.551   7.188  -0.125  1.00  0.00           C  
ATOM    797  C   VAL A  52      12.673   7.683   0.769  1.00  0.00           C  
ATOM    798  O   VAL A  52      13.672   8.211   0.292  1.00  0.00           O  
ATOM    799  CB  VAL A  52      11.420   5.656   0.048  1.00  0.00           C  
ATOM    800  CG1 VAL A  52      10.097   5.151  -0.502  1.00  0.00           C  
ATOM    801  CG2 VAL A  52      12.588   4.938  -0.611  1.00  0.00           C  
ATOM    802  H   VAL A  52      12.703   7.559  -1.868  1.00  0.00           H  
ATOM    803  HA  VAL A  52      10.625   7.643   0.196  1.00  0.00           H  
ATOM    804  HB  VAL A  52      11.448   5.438   1.105  1.00  0.00           H  
ATOM    805 HG11 VAL A  52      10.028   5.382  -1.557  1.00  0.00           H  
ATOM    806 HG12 VAL A  52       9.287   5.628   0.024  1.00  0.00           H  
ATOM    807 HG13 VAL A  52      10.036   4.083  -0.363  1.00  0.00           H  
ATOM    808 HG21 VAL A  52      12.479   3.873  -0.469  1.00  0.00           H  
ATOM    809 HG22 VAL A  52      13.511   5.269  -0.162  1.00  0.00           H  
ATOM    810 HG23 VAL A  52      12.601   5.161  -1.670  1.00  0.00           H  
ATOM    811  N   GLU A  53      12.488   7.520   2.064  1.00  0.00           N  
ATOM    812  CA  GLU A  53      13.489   7.882   3.048  1.00  0.00           C  
ATOM    813  C   GLU A  53      13.824   6.636   3.860  1.00  0.00           C  
ATOM    814  O   GLU A  53      12.981   5.749   4.007  1.00  0.00           O  
ATOM    815  CB  GLU A  53      12.944   9.011   3.938  1.00  0.00           C  
ATOM    816  CG  GLU A  53      13.995  10.019   4.387  1.00  0.00           C  
ATOM    817  CD  GLU A  53      14.921   9.479   5.452  1.00  0.00           C  
ATOM    818  OE1 GLU A  53      14.581   9.596   6.645  1.00  0.00           O  
ATOM    819  OE2 GLU A  53      15.984   8.927   5.098  1.00  0.00           O  
ATOM    820  H   GLU A  53      11.638   7.138   2.376  1.00  0.00           H  
ATOM    821  HA  GLU A  53      14.371   8.222   2.525  1.00  0.00           H  
ATOM    822  HB2 GLU A  53      12.180   9.544   3.392  1.00  0.00           H  
ATOM    823  HB3 GLU A  53      12.502   8.570   4.819  1.00  0.00           H  
ATOM    824  HG2 GLU A  53      14.589  10.305   3.533  1.00  0.00           H  
ATOM    825  HG3 GLU A  53      13.492  10.894   4.778  1.00  0.00           H  
ATOM    826  N   THR A  54      15.042   6.551   4.363  1.00  0.00           N  
ATOM    827  CA  THR A  54      15.503   5.346   5.037  1.00  0.00           C  
ATOM    828  C   THR A  54      15.904   5.620   6.487  1.00  0.00           C  
ATOM    829  O   THR A  54      15.761   4.753   7.356  1.00  0.00           O  
ATOM    830  CB  THR A  54      16.701   4.728   4.286  1.00  0.00           C  
ATOM    831  OG1 THR A  54      17.702   5.729   4.052  1.00  0.00           O  
ATOM    832  CG2 THR A  54      16.258   4.118   2.961  1.00  0.00           C  
ATOM    833  H   THR A  54      15.643   7.331   4.302  1.00  0.00           H  
ATOM    834  HA  THR A  54      14.695   4.631   5.028  1.00  0.00           H  
ATOM    835  HB  THR A  54      17.122   3.945   4.900  1.00  0.00           H  
ATOM    836  HG1 THR A  54      17.360   6.393   3.436  1.00  0.00           H  
ATOM    837 HG21 THR A  54      17.108   3.670   2.467  1.00  0.00           H  
ATOM    838 HG22 THR A  54      15.843   4.892   2.331  1.00  0.00           H  
ATOM    839 HG23 THR A  54      15.509   3.363   3.144  1.00  0.00           H  
ATOM    840  N   ARG A  55      16.380   6.836   6.737  1.00  0.00           N  
ATOM    841  CA  ARG A  55      16.890   7.230   8.046  1.00  0.00           C  
ATOM    842  C   ARG A  55      17.391   8.669   7.995  1.00  0.00           C  
ATOM    843  O   ARG A  55      16.975   9.515   8.788  1.00  0.00           O  
ATOM    844  CB  ARG A  55      18.027   6.297   8.497  1.00  0.00           C  
ATOM    845  CG  ARG A  55      18.700   6.727   9.793  1.00  0.00           C  
ATOM    846  CD  ARG A  55      17.741   6.702  10.977  1.00  0.00           C  
ATOM    847  NE  ARG A  55      18.340   7.288  12.172  1.00  0.00           N  
ATOM    848  CZ  ARG A  55      17.721   7.393  13.348  1.00  0.00           C  
ATOM    849  NH1 ARG A  55      16.522   6.853  13.524  1.00  0.00           N  
ATOM    850  NH2 ARG A  55      18.319   8.009  14.355  1.00  0.00           N  
ATOM    851  H   ARG A  55      16.363   7.512   6.017  1.00  0.00           H  
ATOM    852  HA  ARG A  55      16.077   7.167   8.756  1.00  0.00           H  
ATOM    853  HB2 ARG A  55      17.627   5.305   8.641  1.00  0.00           H  
ATOM    854  HB3 ARG A  55      18.778   6.266   7.720  1.00  0.00           H  
ATOM    855  HG2 ARG A  55      19.524   6.060   9.999  1.00  0.00           H  
ATOM    856  HG3 ARG A  55      19.076   7.733   9.670  1.00  0.00           H  
ATOM    857  HD2 ARG A  55      16.855   7.261  10.719  1.00  0.00           H  
ATOM    858  HD3 ARG A  55      17.472   5.677  11.186  1.00  0.00           H  
ATOM    859  HE  ARG A  55      19.256   7.645  12.085  1.00  0.00           H  
ATOM    860 HH11 ARG A  55      16.078   6.356  12.777  1.00  0.00           H  
ATOM    861 HH12 ARG A  55      16.049   6.941  14.411  1.00  0.00           H  
ATOM    862 HH21 ARG A  55      19.245   8.395  14.233  1.00  0.00           H  
ATOM    863 HH22 ARG A  55      17.860   8.100  15.241  1.00  0.00           H  
ATOM    864  N   GLN A  56      18.293   8.932   7.059  1.00  0.00           N  
ATOM    865  CA  GLN A  56      18.880  10.261   6.898  1.00  0.00           C  
ATOM    866  C   GLN A  56      19.123  10.592   5.428  1.00  0.00           C  
ATOM    867  O   GLN A  56      19.691  11.632   5.101  1.00  0.00           O  
ATOM    868  CB  GLN A  56      20.206  10.343   7.649  1.00  0.00           C  
ATOM    869  CG  GLN A  56      20.067  10.507   9.154  1.00  0.00           C  
ATOM    870  CD  GLN A  56      19.483  11.853   9.548  1.00  0.00           C  
ATOM    871  OE1 GLN A  56      20.213  12.822   9.756  1.00  0.00           O  
ATOM    872  NE2 GLN A  56      18.165  11.924   9.649  1.00  0.00           N  
ATOM    873  H   GLN A  56      18.577   8.213   6.456  1.00  0.00           H  
ATOM    874  HA  GLN A  56      18.193  10.981   7.316  1.00  0.00           H  
ATOM    875  HB2 GLN A  56      20.766   9.439   7.462  1.00  0.00           H  
ATOM    876  HB3 GLN A  56      20.759  11.180   7.261  1.00  0.00           H  
ATOM    877  HG2 GLN A  56      19.418   9.728   9.529  1.00  0.00           H  
ATOM    878  HG3 GLN A  56      21.044  10.408   9.605  1.00  0.00           H  
ATOM    879 HE21 GLN A  56      17.639  11.114   9.460  1.00  0.00           H  
ATOM    880 HE22 GLN A  56      17.766  12.782   9.910  1.00  0.00           H  
ATOM    881  N   THR A  57      18.693   9.710   4.548  1.00  0.00           N  
ATOM    882  CA  THR A  57      18.946   9.871   3.125  1.00  0.00           C  
ATOM    883  C   THR A  57      17.826   9.244   2.294  1.00  0.00           C  
ATOM    884  O   THR A  57      17.323   8.159   2.610  1.00  0.00           O  
ATOM    885  CB  THR A  57      20.317   9.270   2.724  1.00  0.00           C  
ATOM    886  OG1 THR A  57      20.579   9.504   1.334  1.00  0.00           O  
ATOM    887  CG2 THR A  57      20.375   7.775   3.010  1.00  0.00           C  
ATOM    888  H   THR A  57      18.174   8.945   4.860  1.00  0.00           H  
ATOM    889  HA  THR A  57      18.973  10.934   2.918  1.00  0.00           H  
ATOM    890  HB  THR A  57      21.083   9.758   3.307  1.00  0.00           H  
ATOM    891  HG1 THR A  57      20.978   8.719   0.947  1.00  0.00           H  
ATOM    892 HG21 THR A  57      20.200   7.602   4.063  1.00  0.00           H  
ATOM    893 HG22 THR A  57      21.350   7.394   2.742  1.00  0.00           H  
ATOM    894 HG23 THR A  57      19.618   7.267   2.432  1.00  0.00           H  
ATOM    895  N   SER A  58      17.436   9.943   1.236  1.00  0.00           N  
ATOM    896  CA  SER A  58      16.360   9.494   0.367  1.00  0.00           C  
ATOM    897  C   SER A  58      16.848   8.440  -0.625  1.00  0.00           C  
ATOM    898  O   SER A  58      18.004   8.460  -1.051  1.00  0.00           O  
ATOM    899  CB  SER A  58      15.772  10.693  -0.375  1.00  0.00           C  
ATOM    900  OG  SER A  58      16.800  11.484  -0.952  1.00  0.00           O  
ATOM    901  H   SER A  58      17.891  10.785   1.027  1.00  0.00           H  
ATOM    902  HA  SER A  58      15.594   9.057   0.987  1.00  0.00           H  
ATOM    903  HB2 SER A  58      15.117  10.346  -1.159  1.00  0.00           H  
ATOM    904  HB3 SER A  58      15.213  11.301   0.319  1.00  0.00           H  
ATOM    905  HG  SER A  58      17.525  10.913  -1.228  1.00  0.00           H  
ATOM    906  N   LEU A  59      15.960   7.530  -0.995  1.00  0.00           N  
ATOM    907  CA  LEU A  59      16.297   6.451  -1.903  1.00  0.00           C  
ATOM    908  C   LEU A  59      15.273   6.382  -3.030  1.00  0.00           C  
ATOM    909  O   LEU A  59      14.112   6.730  -2.836  1.00  0.00           O  
ATOM    910  CB  LEU A  59      16.359   5.134  -1.114  1.00  0.00           C  
ATOM    911  CG  LEU A  59      17.071   3.943  -1.779  1.00  0.00           C  
ATOM    912  CD1 LEU A  59      16.170   3.231  -2.772  1.00  0.00           C  
ATOM    913  CD2 LEU A  59      18.363   4.391  -2.447  1.00  0.00           C  
ATOM    914  H   LEU A  59      15.043   7.589  -0.649  1.00  0.00           H  
ATOM    915  HA  LEU A  59      17.264   6.661  -2.320  1.00  0.00           H  
ATOM    916  HB2 LEU A  59      16.862   5.334  -0.185  1.00  0.00           H  
ATOM    917  HB3 LEU A  59      15.346   4.831  -0.889  1.00  0.00           H  
ATOM    918  HG  LEU A  59      17.331   3.232  -1.012  1.00  0.00           H  
ATOM    919 HD11 LEU A  59      15.858   3.923  -3.540  1.00  0.00           H  
ATOM    920 HD12 LEU A  59      15.300   2.846  -2.259  1.00  0.00           H  
ATOM    921 HD13 LEU A  59      16.711   2.412  -3.224  1.00  0.00           H  
ATOM    922 HD21 LEU A  59      18.146   5.151  -3.183  1.00  0.00           H  
ATOM    923 HD22 LEU A  59      18.830   3.546  -2.931  1.00  0.00           H  
ATOM    924 HD23 LEU A  59      19.035   4.793  -1.702  1.00  0.00           H  
ATOM    925  N   ALA A  60      15.719   5.957  -4.206  1.00  0.00           N  
ATOM    926  CA  ALA A  60      14.852   5.844  -5.377  1.00  0.00           C  
ATOM    927  C   ALA A  60      15.164   4.576  -6.167  1.00  0.00           C  
ATOM    928  O   ALA A  60      16.315   4.137  -6.209  1.00  0.00           O  
ATOM    929  CB  ALA A  60      15.005   7.067  -6.266  1.00  0.00           C  
ATOM    930  H   ALA A  60      16.661   5.700  -4.285  1.00  0.00           H  
ATOM    931  HA  ALA A  60      13.827   5.802  -5.035  1.00  0.00           H  
ATOM    932  HB1 ALA A  60      14.808   7.958  -5.691  1.00  0.00           H  
ATOM    933  HB2 ALA A  60      14.304   7.006  -7.088  1.00  0.00           H  
ATOM    934  HB3 ALA A  60      16.011   7.105  -6.656  1.00  0.00           H  
ATOM    935  N   LEU A  61      14.142   3.999  -6.802  1.00  0.00           N  
ATOM    936  CA  LEU A  61      14.299   2.771  -7.576  1.00  0.00           C  
ATOM    937  C   LEU A  61      13.102   2.596  -8.504  1.00  0.00           C  
ATOM    938  O   LEU A  61      12.215   3.452  -8.528  1.00  0.00           O  
ATOM    939  CB  LEU A  61      14.481   1.552  -6.648  1.00  0.00           C  
ATOM    940  CG  LEU A  61      13.421   1.362  -5.561  1.00  0.00           C  
ATOM    941  CD1 LEU A  61      12.231   0.574  -6.084  1.00  0.00           C  
ATOM    942  CD2 LEU A  61      14.022   0.673  -4.345  1.00  0.00           C  
ATOM    943  H   LEU A  61      13.253   4.422  -6.767  1.00  0.00           H  
ATOM    944  HA  LEU A  61      15.185   2.882  -8.184  1.00  0.00           H  
ATOM    945  HB2 LEU A  61      14.486   0.667  -7.260  1.00  0.00           H  
ATOM    946  HB3 LEU A  61      15.444   1.638  -6.167  1.00  0.00           H  
ATOM    947  HG  LEU A  61      13.066   2.330  -5.254  1.00  0.00           H  
ATOM    948 HD11 LEU A  61      11.796   1.097  -6.924  1.00  0.00           H  
ATOM    949 HD12 LEU A  61      11.493   0.476  -5.301  1.00  0.00           H  
ATOM    950 HD13 LEU A  61      12.557  -0.406  -6.400  1.00  0.00           H  
ATOM    951 HD21 LEU A  61      14.389  -0.303  -4.628  1.00  0.00           H  
ATOM    952 HD22 LEU A  61      13.267   0.565  -3.578  1.00  0.00           H  
ATOM    953 HD23 LEU A  61      14.838   1.267  -3.964  1.00  0.00           H  
ATOM    954  N   ARG A  62      13.073   1.514  -9.275  1.00  0.00           N  
ATOM    955  CA  ARG A  62      11.988   1.308 -10.229  1.00  0.00           C  
ATOM    956  C   ARG A  62      11.084   0.166  -9.831  1.00  0.00           C  
ATOM    957  O   ARG A  62      11.389  -0.627  -8.944  1.00  0.00           O  
ATOM    958  CB  ARG A  62      12.513   1.022 -11.629  1.00  0.00           C  
ATOM    959  CG  ARG A  62      13.405   2.104 -12.167  1.00  0.00           C  
ATOM    960  CD  ARG A  62      12.724   3.462 -12.198  1.00  0.00           C  
ATOM    961  NE  ARG A  62      11.526   3.477 -13.034  1.00  0.00           N  
ATOM    962  CZ  ARG A  62      11.450   4.098 -14.210  1.00  0.00           C  
ATOM    963  NH1 ARG A  62      12.541   4.625 -14.763  1.00  0.00           N  
ATOM    964  NH2 ARG A  62      10.286   4.180 -14.839  1.00  0.00           N  
ATOM    965  H   ARG A  62      13.783   0.842  -9.198  1.00  0.00           H  
ATOM    966  HA  ARG A  62      11.404   2.213 -10.260  1.00  0.00           H  
ATOM    967  HB2 ARG A  62      13.072   0.099 -11.613  1.00  0.00           H  
ATOM    968  HB3 ARG A  62      11.672   0.911 -12.300  1.00  0.00           H  
ATOM    969  HG2 ARG A  62      14.261   2.166 -11.529  1.00  0.00           H  
ATOM    970  HG3 ARG A  62      13.709   1.838 -13.164  1.00  0.00           H  
ATOM    971  HD2 ARG A  62      12.447   3.735 -11.191  1.00  0.00           H  
ATOM    972  HD3 ARG A  62      13.424   4.189 -12.583  1.00  0.00           H  
ATOM    973  HE  ARG A  62      10.711   3.046 -12.669  1.00  0.00           H  
ATOM    974 HH11 ARG A  62      13.426   4.554 -14.300  1.00  0.00           H  
ATOM    975 HH12 ARG A  62      12.483   5.098 -15.649  1.00  0.00           H  
ATOM    976 HH21 ARG A  62       9.466   3.775 -14.429  1.00  0.00           H  
ATOM    977 HH22 ARG A  62      10.216   4.674 -15.714  1.00  0.00           H  
ATOM    978  N   ARG A  63       9.986   0.084 -10.550  1.00  0.00           N  
ATOM    979  CA  ARG A  63       8.975  -0.957 -10.325  1.00  0.00           C  
ATOM    980  C   ARG A  63       9.542  -2.350 -10.583  1.00  0.00           C  
ATOM    981  O   ARG A  63       9.167  -3.311  -9.919  1.00  0.00           O  
ATOM    982  CB  ARG A  63       7.745  -0.744 -11.215  1.00  0.00           C  
ATOM    983  CG  ARG A  63       7.986  -0.997 -12.698  1.00  0.00           C  
ATOM    984  CD  ARG A  63       6.728  -0.755 -13.513  1.00  0.00           C  
ATOM    985  NE  ARG A  63       6.930  -1.022 -14.940  1.00  0.00           N  
ATOM    986  CZ  ARG A  63       6.894  -0.081 -15.890  1.00  0.00           C  
ATOM    987  NH1 ARG A  63       6.798   1.204 -15.562  1.00  0.00           N  
ATOM    988  NH2 ARG A  63       6.988  -0.425 -17.171  1.00  0.00           N  
ATOM    989  H   ARG A  63       9.837   0.780 -11.249  1.00  0.00           H  
ATOM    990  HA  ARG A  63       8.671  -0.899  -9.292  1.00  0.00           H  
ATOM    991  HB2 ARG A  63       6.963  -1.408 -10.884  1.00  0.00           H  
ATOM    992  HB3 ARG A  63       7.410   0.274 -11.098  1.00  0.00           H  
ATOM    993  HG2 ARG A  63       8.760  -0.331 -13.045  1.00  0.00           H  
ATOM    994  HG3 ARG A  63       8.301  -2.023 -12.833  1.00  0.00           H  
ATOM    995  HD2 ARG A  63       5.945  -1.399 -13.142  1.00  0.00           H  
ATOM    996  HD3 ARG A  63       6.430   0.277 -13.391  1.00  0.00           H  
ATOM    997  HE  ARG A  63       7.066  -1.967 -15.205  1.00  0.00           H  
ATOM    998 HH11 ARG A  63       6.761   1.481 -14.585  1.00  0.00           H  
ATOM    999 HH12 ARG A  63       6.739   1.911 -16.281  1.00  0.00           H  
ATOM   1000 HH21 ARG A  63       7.077  -1.393 -17.432  1.00  0.00           H  
ATOM   1001 HH22 ARG A  63       6.983   0.285 -17.890  1.00  0.00           H  
ATOM   1002  N   LYS A  64      10.429  -2.453 -11.561  1.00  0.00           N  
ATOM   1003  CA  LYS A  64      11.020  -3.735 -11.921  1.00  0.00           C  
ATOM   1004  C   LYS A  64      11.995  -4.206 -10.852  1.00  0.00           C  
ATOM   1005  O   LYS A  64      12.117  -5.401 -10.593  1.00  0.00           O  
ATOM   1006  CB  LYS A  64      11.722  -3.623 -13.270  1.00  0.00           C  
ATOM   1007  CG  LYS A  64      10.788  -3.226 -14.398  1.00  0.00           C  
ATOM   1008  CD  LYS A  64      11.487  -3.255 -15.747  1.00  0.00           C  
ATOM   1009  CE  LYS A  64      10.527  -2.912 -16.871  1.00  0.00           C  
ATOM   1010  NZ  LYS A  64      11.147  -3.082 -18.211  1.00  0.00           N  
ATOM   1011  H   LYS A  64      10.679  -1.652 -12.062  1.00  0.00           H  
ATOM   1012  HA  LYS A  64      10.221  -4.453 -12.004  1.00  0.00           H  
ATOM   1013  HB2 LYS A  64      12.504  -2.883 -13.195  1.00  0.00           H  
ATOM   1014  HB3 LYS A  64      12.162  -4.576 -13.513  1.00  0.00           H  
ATOM   1015  HG2 LYS A  64       9.957  -3.913 -14.423  1.00  0.00           H  
ATOM   1016  HG3 LYS A  64      10.424  -2.225 -14.214  1.00  0.00           H  
ATOM   1017  HD2 LYS A  64      12.291  -2.534 -15.740  1.00  0.00           H  
ATOM   1018  HD3 LYS A  64      11.887  -4.244 -15.912  1.00  0.00           H  
ATOM   1019  HE2 LYS A  64       9.667  -3.562 -16.802  1.00  0.00           H  
ATOM   1020  HE3 LYS A  64      10.210  -1.887 -16.757  1.00  0.00           H  
ATOM   1021  HZ1 LYS A  64      11.411  -4.078 -18.360  1.00  0.00           H  
ATOM   1022  HZ2 LYS A  64      12.004  -2.491 -18.294  1.00  0.00           H  
ATOM   1023  HZ3 LYS A  64      10.470  -2.799 -18.956  1.00  0.00           H  
ATOM   1024  N   ASP A  65      12.675  -3.259 -10.231  1.00  0.00           N  
ATOM   1025  CA  ASP A  65      13.590  -3.561  -9.139  1.00  0.00           C  
ATOM   1026  C   ASP A  65      12.794  -3.873  -7.880  1.00  0.00           C  
ATOM   1027  O   ASP A  65      13.147  -4.755  -7.103  1.00  0.00           O  
ATOM   1028  CB  ASP A  65      14.532  -2.374  -8.917  1.00  0.00           C  
ATOM   1029  CG  ASP A  65      15.623  -2.652  -7.900  1.00  0.00           C  
ATOM   1030  OD1 ASP A  65      16.392  -3.614  -8.097  1.00  0.00           O  
ATOM   1031  OD2 ASP A  65      15.729  -1.883  -6.921  1.00  0.00           O  
ATOM   1032  H   ASP A  65      12.562  -2.330 -10.511  1.00  0.00           H  
ATOM   1033  HA  ASP A  65      14.165  -4.433  -9.411  1.00  0.00           H  
ATOM   1034  HB2 ASP A  65      15.003  -2.121  -9.855  1.00  0.00           H  
ATOM   1035  HB3 ASP A  65      13.953  -1.529  -8.574  1.00  0.00           H  
ATOM   1036  N   LEU A  66      11.692  -3.156  -7.709  1.00  0.00           N  
ATOM   1037  CA  LEU A  66      10.771  -3.411  -6.610  1.00  0.00           C  
ATOM   1038  C   LEU A  66      10.140  -4.790  -6.744  1.00  0.00           C  
ATOM   1039  O   LEU A  66       9.807  -5.437  -5.754  1.00  0.00           O  
ATOM   1040  CB  LEU A  66       9.668  -2.356  -6.588  1.00  0.00           C  
ATOM   1041  CG  LEU A  66       8.697  -2.461  -5.412  1.00  0.00           C  
ATOM   1042  CD1 LEU A  66       9.406  -2.101  -4.116  1.00  0.00           C  
ATOM   1043  CD2 LEU A  66       7.485  -1.572  -5.640  1.00  0.00           C  
ATOM   1044  H   LEU A  66      11.503  -2.418  -8.328  1.00  0.00           H  
ATOM   1045  HA  LEU A  66      11.326  -3.365  -5.687  1.00  0.00           H  
ATOM   1046  HB2 LEU A  66      10.134  -1.384  -6.561  1.00  0.00           H  
ATOM   1047  HB3 LEU A  66       9.101  -2.440  -7.501  1.00  0.00           H  
ATOM   1048  HG  LEU A  66       8.355  -3.482  -5.329  1.00  0.00           H  
ATOM   1049 HD11 LEU A  66      10.230  -2.780  -3.957  1.00  0.00           H  
ATOM   1050 HD12 LEU A  66       8.711  -2.179  -3.292  1.00  0.00           H  
ATOM   1051 HD13 LEU A  66       9.779  -1.090  -4.178  1.00  0.00           H  
ATOM   1052 HD21 LEU A  66       6.956  -1.906  -6.520  1.00  0.00           H  
ATOM   1053 HD22 LEU A  66       7.807  -0.551  -5.778  1.00  0.00           H  
ATOM   1054 HD23 LEU A  66       6.829  -1.630  -4.783  1.00  0.00           H  
ATOM   1055  N   ALA A  67       9.984  -5.235  -7.984  1.00  0.00           N  
ATOM   1056  CA  ALA A  67       9.366  -6.523  -8.272  1.00  0.00           C  
ATOM   1057  C   ALA A  67      10.240  -7.681  -7.805  1.00  0.00           C  
ATOM   1058  O   ALA A  67       9.807  -8.831  -7.817  1.00  0.00           O  
ATOM   1059  CB  ALA A  67       9.072  -6.647  -9.758  1.00  0.00           C  
ATOM   1060  H   ALA A  67      10.284  -4.672  -8.727  1.00  0.00           H  
ATOM   1061  HA  ALA A  67       8.426  -6.561  -7.742  1.00  0.00           H  
ATOM   1062  HB1 ALA A  67       8.469  -5.811 -10.074  1.00  0.00           H  
ATOM   1063  HB2 ALA A  67       8.537  -7.567  -9.944  1.00  0.00           H  
ATOM   1064  HB3 ALA A  67      10.001  -6.652 -10.308  1.00  0.00           H  
ATOM   1065  N   LEU A  68      11.472  -7.380  -7.411  1.00  0.00           N  
ATOM   1066  CA  LEU A  68      12.366  -8.390  -6.862  1.00  0.00           C  
ATOM   1067  C   LEU A  68      12.238  -8.449  -5.340  1.00  0.00           C  
ATOM   1068  O   LEU A  68      12.817  -9.319  -4.687  1.00  0.00           O  
ATOM   1069  CB  LEU A  68      13.808  -8.080  -7.260  1.00  0.00           C  
ATOM   1070  CG  LEU A  68      14.059  -7.979  -8.766  1.00  0.00           C  
ATOM   1071  CD1 LEU A  68      15.465  -7.470  -9.034  1.00  0.00           C  
ATOM   1072  CD2 LEU A  68      13.848  -9.328  -9.435  1.00  0.00           C  
ATOM   1073  H   LEU A  68      11.796  -6.452  -7.506  1.00  0.00           H  
ATOM   1074  HA  LEU A  68      12.083  -9.349  -7.269  1.00  0.00           H  
ATOM   1075  HB2 LEU A  68      14.090  -7.143  -6.804  1.00  0.00           H  
ATOM   1076  HB3 LEU A  68      14.444  -8.857  -6.865  1.00  0.00           H  
ATOM   1077  HG  LEU A  68      13.361  -7.276  -9.197  1.00  0.00           H  
ATOM   1078 HD11 LEU A  68      16.181  -8.147  -8.589  1.00  0.00           H  
ATOM   1079 HD12 LEU A  68      15.582  -6.488  -8.601  1.00  0.00           H  
ATOM   1080 HD13 LEU A  68      15.633  -7.419 -10.099  1.00  0.00           H  
ATOM   1081 HD21 LEU A  68      14.535 -10.049  -9.013  1.00  0.00           H  
ATOM   1082 HD22 LEU A  68      14.030  -9.237 -10.496  1.00  0.00           H  
ATOM   1083 HD23 LEU A  68      12.834  -9.659  -9.270  1.00  0.00           H  
ATOM   1084  N   LEU A  69      11.456  -7.533  -4.786  1.00  0.00           N  
ATOM   1085  CA  LEU A  69      11.268  -7.454  -3.348  1.00  0.00           C  
ATOM   1086  C   LEU A  69       9.803  -7.643  -2.979  1.00  0.00           C  
ATOM   1087  O   LEU A  69       8.906  -7.381  -3.780  1.00  0.00           O  
ATOM   1088  CB  LEU A  69      11.747  -6.094  -2.822  1.00  0.00           C  
ATOM   1089  CG  LEU A  69      13.237  -5.798  -3.009  1.00  0.00           C  
ATOM   1090  CD1 LEU A  69      13.551  -4.376  -2.574  1.00  0.00           C  
ATOM   1091  CD2 LEU A  69      14.086  -6.794  -2.227  1.00  0.00           C  
ATOM   1092  H   LEU A  69      10.981  -6.896  -5.365  1.00  0.00           H  
ATOM   1093  HA  LEU A  69      11.852  -8.236  -2.888  1.00  0.00           H  
ATOM   1094  HB2 LEU A  69      11.185  -5.322  -3.327  1.00  0.00           H  
ATOM   1095  HB3 LEU A  69      11.523  -6.044  -1.767  1.00  0.00           H  
ATOM   1096  HG  LEU A  69      13.488  -5.891  -4.055  1.00  0.00           H  
ATOM   1097 HD11 LEU A  69      14.603  -4.181  -2.713  1.00  0.00           H  
ATOM   1098 HD12 LEU A  69      13.296  -4.252  -1.531  1.00  0.00           H  
ATOM   1099 HD13 LEU A  69      12.975  -3.681  -3.170  1.00  0.00           H  
ATOM   1100 HD21 LEU A  69      13.870  -6.703  -1.171  1.00  0.00           H  
ATOM   1101 HD22 LEU A  69      15.131  -6.588  -2.398  1.00  0.00           H  
ATOM   1102 HD23 LEU A  69      13.858  -7.797  -2.555  1.00  0.00           H  
ATOM   1103  N   THR A  70       9.568  -8.119  -1.773  1.00  0.00           N  
ATOM   1104  CA  THR A  70       8.226  -8.166  -1.220  1.00  0.00           C  
ATOM   1105  C   THR A  70       8.126  -7.205  -0.037  1.00  0.00           C  
ATOM   1106  O   THR A  70       8.879  -7.325   0.937  1.00  0.00           O  
ATOM   1107  CB  THR A  70       7.852  -9.586  -0.765  1.00  0.00           C  
ATOM   1108  OG1 THR A  70       8.167 -10.531  -1.797  1.00  0.00           O  
ATOM   1109  CG2 THR A  70       6.369  -9.679  -0.425  1.00  0.00           C  
ATOM   1110  H   THR A  70      10.321  -8.459  -1.238  1.00  0.00           H  
ATOM   1111  HA  THR A  70       7.533  -7.858  -1.987  1.00  0.00           H  
ATOM   1112  HB  THR A  70       8.421  -9.818   0.118  1.00  0.00           H  
ATOM   1113  HG1 THR A  70       8.785 -11.188  -1.454  1.00  0.00           H  
ATOM   1114 HG21 THR A  70       5.783  -9.420  -1.296  1.00  0.00           H  
ATOM   1115 HG22 THR A  70       6.140  -8.997   0.379  1.00  0.00           H  
ATOM   1116 HG23 THR A  70       6.131 -10.689  -0.119  1.00  0.00           H  
ATOM   1117  N   LEU A  71       7.215  -6.251  -0.130  1.00  0.00           N  
ATOM   1118  CA  LEU A  71       7.081  -5.220   0.892  1.00  0.00           C  
ATOM   1119  C   LEU A  71       5.886  -5.479   1.794  1.00  0.00           C  
ATOM   1120  O   LEU A  71       4.858  -5.999   1.359  1.00  0.00           O  
ATOM   1121  CB  LEU A  71       6.935  -3.832   0.259  1.00  0.00           C  
ATOM   1122  CG  LEU A  71       8.109  -3.359  -0.597  1.00  0.00           C  
ATOM   1123  CD1 LEU A  71       7.880  -1.930  -1.057  1.00  0.00           C  
ATOM   1124  CD2 LEU A  71       9.421  -3.475   0.163  1.00  0.00           C  
ATOM   1125  H   LEU A  71       6.601  -6.246  -0.901  1.00  0.00           H  
ATOM   1126  HA  LEU A  71       7.979  -5.234   1.493  1.00  0.00           H  
ATOM   1127  HB2 LEU A  71       6.053  -3.839  -0.363  1.00  0.00           H  
ATOM   1128  HB3 LEU A  71       6.786  -3.112   1.053  1.00  0.00           H  
ATOM   1129  HG  LEU A  71       8.175  -3.983  -1.475  1.00  0.00           H  
ATOM   1130 HD11 LEU A  71       7.791  -1.281  -0.197  1.00  0.00           H  
ATOM   1131 HD12 LEU A  71       6.972  -1.884  -1.639  1.00  0.00           H  
ATOM   1132 HD13 LEU A  71       8.714  -1.611  -1.664  1.00  0.00           H  
ATOM   1133 HD21 LEU A  71      10.227  -3.123  -0.461  1.00  0.00           H  
ATOM   1134 HD22 LEU A  71       9.592  -4.507   0.426  1.00  0.00           H  
ATOM   1135 HD23 LEU A  71       9.372  -2.878   1.062  1.00  0.00           H  
ATOM   1136  N   VAL A  72       6.037  -5.106   3.052  1.00  0.00           N  
ATOM   1137  CA  VAL A  72       4.947  -5.153   4.013  1.00  0.00           C  
ATOM   1138  C   VAL A  72       4.834  -3.810   4.727  1.00  0.00           C  
ATOM   1139  O   VAL A  72       5.769  -3.366   5.392  1.00  0.00           O  
ATOM   1140  CB  VAL A  72       5.127  -6.282   5.055  1.00  0.00           C  
ATOM   1141  CG1 VAL A  72       4.901  -7.647   4.420  1.00  0.00           C  
ATOM   1142  CG2 VAL A  72       6.507  -6.219   5.697  1.00  0.00           C  
ATOM   1143  H   VAL A  72       6.916  -4.774   3.345  1.00  0.00           H  
ATOM   1144  HA  VAL A  72       4.032  -5.335   3.467  1.00  0.00           H  
ATOM   1145  HB  VAL A  72       4.389  -6.146   5.832  1.00  0.00           H  
ATOM   1146 HG11 VAL A  72       5.616  -7.794   3.623  1.00  0.00           H  
ATOM   1147 HG12 VAL A  72       3.900  -7.697   4.018  1.00  0.00           H  
ATOM   1148 HG13 VAL A  72       5.029  -8.418   5.166  1.00  0.00           H  
ATOM   1149 HG21 VAL A  72       7.263  -6.312   4.931  1.00  0.00           H  
ATOM   1150 HG22 VAL A  72       6.612  -7.027   6.406  1.00  0.00           H  
ATOM   1151 HG23 VAL A  72       6.625  -5.274   6.207  1.00  0.00           H  
ATOM   1152  N   PRO A  73       3.699  -3.122   4.576  1.00  0.00           N  
ATOM   1153  CA  PRO A  73       3.502  -1.812   5.188  1.00  0.00           C  
ATOM   1154  C   PRO A  73       3.349  -1.913   6.700  1.00  0.00           C  
ATOM   1155  O   PRO A  73       3.095  -2.996   7.236  1.00  0.00           O  
ATOM   1156  CB  PRO A  73       2.194  -1.303   4.561  1.00  0.00           C  
ATOM   1157  CG  PRO A  73       1.855  -2.266   3.465  1.00  0.00           C  
ATOM   1158  CD  PRO A  73       2.524  -3.560   3.815  1.00  0.00           C  
ATOM   1159  HA  PRO A  73       4.308  -1.134   4.951  1.00  0.00           H  
ATOM   1160  HB2 PRO A  73       1.419  -1.283   5.314  1.00  0.00           H  
ATOM   1161  HB3 PRO A  73       2.344  -0.306   4.173  1.00  0.00           H  
ATOM   1162  HG2 PRO A  73       0.785  -2.400   3.415  1.00  0.00           H  
ATOM   1163  HG3 PRO A  73       2.230  -1.892   2.525  1.00  0.00           H  
ATOM   1164  HD2 PRO A  73       1.872  -4.171   4.424  1.00  0.00           H  
ATOM   1165  HD3 PRO A  73       2.816  -4.091   2.921  1.00  0.00           H  
ATOM   1166  N   LEU A  74       3.514  -0.788   7.384  1.00  0.00           N  
ATOM   1167  CA  LEU A  74       3.245  -0.720   8.812  1.00  0.00           C  
ATOM   1168  C   LEU A  74       1.797  -1.113   9.079  1.00  0.00           C  
ATOM   1169  O   LEU A  74       1.514  -1.937   9.952  1.00  0.00           O  
ATOM   1170  CB  LEU A  74       3.511   0.688   9.339  1.00  0.00           C  
ATOM   1171  CG  LEU A  74       4.964   1.157   9.250  1.00  0.00           C  
ATOM   1172  CD1 LEU A  74       5.098   2.566   9.801  1.00  0.00           C  
ATOM   1173  CD2 LEU A  74       5.882   0.201   9.997  1.00  0.00           C  
ATOM   1174  H   LEU A  74       3.850   0.012   6.922  1.00  0.00           H  
ATOM   1175  HA  LEU A  74       3.899  -1.418   9.311  1.00  0.00           H  
ATOM   1176  HB2 LEU A  74       2.900   1.381   8.779  1.00  0.00           H  
ATOM   1177  HB3 LEU A  74       3.209   0.721  10.369  1.00  0.00           H  
ATOM   1178  HG  LEU A  74       5.266   1.172   8.213  1.00  0.00           H  
ATOM   1179 HD11 LEU A  74       6.131   2.875   9.753  1.00  0.00           H  
ATOM   1180 HD12 LEU A  74       4.763   2.585  10.829  1.00  0.00           H  
ATOM   1181 HD13 LEU A  74       4.493   3.240   9.213  1.00  0.00           H  
ATOM   1182 HD21 LEU A  74       6.898   0.568   9.947  1.00  0.00           H  
ATOM   1183 HD22 LEU A  74       5.831  -0.776   9.543  1.00  0.00           H  
ATOM   1184 HD23 LEU A  74       5.574   0.136  11.029  1.00  0.00           H  
ATOM   1185  N   ASP A  75       0.897  -0.522   8.305  1.00  0.00           N  
ATOM   1186  CA  ASP A  75      -0.517  -0.863   8.346  1.00  0.00           C  
ATOM   1187  C   ASP A  75      -1.077  -0.900   6.933  1.00  0.00           C  
ATOM   1188  O   ASP A  75      -0.988  -1.966   6.288  1.00  0.00           O  
ATOM   1189  CB  ASP A  75      -1.302   0.136   9.203  1.00  0.00           C  
ATOM   1190  CG  ASP A  75      -1.218  -0.173  10.681  1.00  0.00           C  
ATOM   1191  OD1 ASP A  75      -0.274   0.302  11.346  1.00  0.00           O  
ATOM   1192  OD2 ASP A  75      -2.093  -0.906  11.185  1.00  0.00           O  
ATOM   1193  OXT ASP A  75      -1.579   0.144   6.461  1.00  0.00           O  
ATOM   1194  H   ASP A  75       1.194   0.169   7.679  1.00  0.00           H  
ATOM   1195  HA  ASP A  75      -0.607  -1.847   8.782  1.00  0.00           H  
ATOM   1196  HB2 ASP A  75      -0.907   1.127   9.041  1.00  0.00           H  
ATOM   1197  HB3 ASP A  75      -2.340   0.114   8.908  1.00  0.00           H  
TER    1198      ASP A  75                                                      
END
MOLECULE T0462_1_74.pdb
ATOM      1  C   MET     1       3.518  -5.525  -1.015  1.00 72.54           C 
ATOM      2  O   MET     1       4.514  -5.922  -0.421  1.00 61.43           O 
ATOM      3  N   MET     1       1.797  -7.249  -0.416  1.00 62.03           N 
ATOM      4  CA  MET     1       2.106  -5.791  -0.468  1.00  1.42           C 
ATOM      5  CB  MET     1       1.945  -5.166   0.931  1.00  3.15           C 
ATOM      6  CG  MET     1       2.652  -3.826   1.103  1.00 20.23           C 
ATOM      7  SD  MET     1       2.005  -2.537   0.021  1.00  4.24           S 
ATOM      8  CE  MET     1       0.587  -1.980   0.962  1.00 12.22           C 
ATOM      9 1H   MET     1       2.447  -7.731   0.242  1.00 36.29           H 
ATOM     10 2H   MET     1       1.909  -7.674  -1.357  1.00 36.29           H 
ATOM     11 3H   MET     1       0.818  -7.396  -0.095  1.00 36.29           H 
ATOM     12  HA  MET     1       1.390  -5.330  -1.136  1.00  4.22           H 
ATOM     13 3HB  MET     1       2.337  -5.854   1.668  1.00 36.29           H 
ATOM     14 2HB  MET     1       0.892  -5.015   1.123  1.00 36.29           H 
ATOM     15 3HG  MET     1       3.702  -3.962   0.888  1.00 36.29           H 
ATOM     16 2HG  MET     1       2.538  -3.502   2.127  1.00 36.29           H 
ATOM     17 1HE  MET     1      -0.112  -2.794   1.079  1.00 36.29           H 
ATOM     18 2HE  MET     1       0.108  -1.165   0.439  1.00 36.29           H 
ATOM     19 3HE  MET     1       0.911  -1.640   1.935  1.00 36.29           H 
ATOM     20  N   LYS     2       3.591  -4.846  -2.158  1.00  4.01           N 
ATOM     21  CA  LYS     2       4.874  -4.436  -2.746  1.00 14.04           C 
ATOM     22  C   LYS     2       5.042  -2.911  -2.669  1.00 71.54           C 
ATOM     23  O   LYS     2       4.069  -2.166  -2.787  1.00  5.03           O 
ATOM     24  CB  LYS     2       4.982  -4.912  -4.207  1.00 41.30           C 
ATOM     25  CG  LYS     2       5.651  -6.277  -4.378  1.00 35.55           C 
ATOM     26  CD  LYS     2       4.888  -7.412  -3.703  1.00 24.21           C 
ATOM     27  CE  LYS     2       5.601  -8.746  -3.913  1.00 54.20           C 
ATOM     28  NZ  LYS     2       4.888  -9.880  -3.264  1.00 23.11           N 
ATOM     29  H   LYS     2       2.763  -4.602  -2.617  1.00 36.29           H 
ATOM     30  HA  LYS     2       5.666  -4.897  -2.168  1.00 52.45           H 
ATOM     31 3HB  LYS     2       5.556  -4.188  -4.770  1.00 36.29           H 
ATOM     32 2HB  LYS     2       3.989  -4.969  -4.631  1.00 36.29           H 
ATOM     33 3HG  LYS     2       6.647  -6.227  -3.957  1.00 36.29           H 
ATOM     34 2HG  LYS     2       5.724  -6.494  -5.433  1.00 36.29           H 
ATOM     35 3HD  LYS     2       3.895  -7.473  -4.126  1.00 36.29           H 
ATOM     36 2HD  LYS     2       4.822  -7.212  -2.644  1.00 36.29           H 
ATOM     37 3HE  LYS     2       6.597  -8.675  -3.499  1.00 36.29           H 
ATOM     38 2HE  LYS     2       5.669  -8.940  -4.973  1.00 36.29           H 
ATOM     39 1HZ  LYS     2       4.773  -9.696  -2.246  1.00 36.29           H 
ATOM     40 2HZ  LYS     2       5.434 -10.759  -3.385  1.00 36.29           H 
ATOM     41 3HZ  LYS     2       3.951 -10.007  -3.690  1.00 36.29           H 
ATOM     42  N   LEU     3       6.279  -2.445  -2.492  1.00 54.05           N 
ATOM     43  CA  LEU     3       6.551  -1.006  -2.322  1.00 12.34           C 
ATOM     44  C   LEU     3       6.221  -0.190  -3.591  1.00 75.43           C 
ATOM     45  O   LEU     3       6.193   1.039  -3.556  1.00 30.52           O 
ATOM     46  CB  LEU     3       8.016  -0.794  -1.890  1.00 44.12           C 
ATOM     47  CG  LEU     3       9.093  -1.161  -2.934  1.00 51.02           C 
ATOM     48  CD1 LEU     3       9.466   0.048  -3.795  1.00 31.15           C 
ATOM     49  CD2 LEU     3      10.332  -1.742  -2.258  1.00 12.10           C 
ATOM     50  H   LEU     3       7.028  -3.081  -2.468  1.00 36.29           H 
ATOM     51  HA  LEU     3       5.909  -0.654  -1.524  1.00 75.20           H 
ATOM     52 3HB  LEU     3       8.188  -1.389  -1.004  1.00 36.29           H 
ATOM     53 2HB  LEU     3       8.140   0.246  -1.624  1.00 36.29           H 
ATOM     54  HG  LEU     3       8.695  -1.919  -3.597  1.00 53.15           H 
ATOM     55 1HD1 LEU     3       9.859   0.832  -3.164  1.00 36.29           H 
ATOM     56 2HD1 LEU     3       8.590   0.408  -4.313  1.00 36.29           H 
ATOM     57 3HD1 LEU     3      10.216  -0.241  -4.517  1.00 36.29           H 
ATOM     58 1HD2 LEU     3      11.058  -2.020  -3.009  1.00 36.29           H 
ATOM     59 2HD2 LEU     3      10.056  -2.616  -1.686  1.00 36.29           H 
ATOM     60 3HD2 LEU     3      10.765  -1.004  -1.598  1.00 36.29           H 
ATOM     61  N   SER     4       5.945  -0.883  -4.701  1.00  4.23           N 
ATOM     62  CA  SER     4       5.589  -0.227  -5.974  1.00 32.21           C 
ATOM     63  C   SER     4       4.229   0.480  -5.900  1.00 20.35           C 
ATOM     64  O   SER     4       3.854   1.213  -6.814  1.00 13.44           O 
ATOM     65  CB  SER     4       5.543  -1.258  -7.115  1.00 23.31           C 
ATOM     66  OG  SER     4       4.601  -2.291  -6.849  1.00 33.45           O 
ATOM     67  H   SER     4       5.981  -1.860  -4.667  1.00 36.29           H 
ATOM     68  HA  SER     4       6.351   0.505  -6.197  1.00  2.13           H 
ATOM     69 3HB  SER     4       6.518  -1.702  -7.235  1.00 36.29           H 
ATOM     70 2HB  SER     4       5.263  -0.764  -8.033  1.00 36.29           H 
ATOM     71  HG  SER     4       4.753  -3.024  -7.464  1.00 23.50           H 
ATOM     72  N   ARG     5       3.493   0.245  -4.816  1.00 74.24           N 
ATOM     73  CA  ARG     5       2.136   0.783  -4.660  1.00 65.23           C 
ATOM     74  C   ARG     5       1.911   1.351  -3.250  1.00 50.53           C 
ATOM     75  O   ARG     5       0.779   1.617  -2.853  1.00  3.14           O 
ATOM     76  CB  ARG     5       1.136  -0.345  -4.937  1.00 32.44           C 
ATOM     77  CG  ARG     5       1.216  -1.485  -3.918  1.00 60.24           C 
ATOM     78  CD  ARG     5       0.735  -2.805  -4.499  1.00 44.11           C 
ATOM     79  NE  ARG     5       1.633  -3.289  -5.550  1.00 13.55           N 
ATOM     80  CZ  ARG     5       1.739  -4.539  -5.905  1.00 12.44           C 
ATOM     81  NH1 ARG     5       0.990  -5.444  -5.364  1.00 63.34           N 
ATOM     82  NH2 ARG     5       2.586  -4.888  -6.812  1.00 21.53           N 
ATOM     83  H   ARG     5       3.864  -0.317  -4.107  1.00 36.29           H 
ATOM     84  HA  ARG     5       1.992   1.572  -5.386  1.00 64.21           H 
ATOM     85 3HB  ARG     5       1.332  -0.751  -5.919  1.00 36.29           H 
ATOM     86 2HB  ARG     5       0.133   0.062  -4.919  1.00 36.29           H 
ATOM     87 3HG  ARG     5       0.606  -1.234  -3.062  1.00 36.29           H 
ATOM     88 2HG  ARG     5       2.244  -1.601  -3.602  1.00 36.29           H 
ATOM     89 3HD  ARG     5      -0.252  -2.667  -4.916  1.00 36.29           H 
ATOM     90 2HD  ARG     5       0.692  -3.538  -3.704  1.00 36.29           H 
ATOM     91  HE  ARG     5       2.201  -2.632  -5.999  1.00 75.30           H 
ATOM     92 1HH1 ARG     5       0.323  -5.193  -4.674  1.00 36.29           H 
ATOM     93 2HH1 ARG     5       1.098  -6.403  -5.639  1.00 36.29           H 
ATOM     94 1HH2 ARG     5       3.168  -4.207  -7.248  1.00 36.29           H 
ATOM     95 2HH2 ARG     5       2.657  -5.850  -7.075  1.00 36.29           H 
ATOM     96  N   LEU     6       2.994   1.542  -2.504  1.00 24.41           N 
ATOM     97  CA  LEU     6       2.903   1.977  -1.106  1.00 73.40           C 
ATOM     98  C   LEU     6       2.620   3.487  -1.005  1.00 51.45           C 
ATOM     99  O   LEU     6       3.285   4.299  -1.650  1.00 72.11           O 
ATOM    100  CB  LEU     6       4.204   1.628  -0.365  1.00 50.13           C 
ATOM    101  CG  LEU     6       4.178   1.842   1.158  1.00 51.54           C 
ATOM    102  CD1 LEU     6       3.193   0.885   1.826  1.00 34.05           C 
ATOM    103  CD2 LEU     6       5.578   1.679   1.747  1.00 44.04           C 
ATOM    104  H   LEU     6       3.878   1.408  -2.906  1.00 36.29           H 
ATOM    105  HA  LEU     6       2.084   1.437  -0.646  1.00 14.43           H 
ATOM    106 3HB  LEU     6       5.001   2.232  -0.778  1.00 36.29           H 
ATOM    107 2HB  LEU     6       4.434   0.589  -0.557  1.00 36.29           H 
ATOM    108  HG  LEU     6       3.846   2.847   1.364  1.00 12.14           H 
ATOM    109 1HD1 LEU     6       3.477  -0.136   1.615  1.00 36.29           H 
ATOM    110 2HD1 LEU     6       2.198   1.068   1.446  1.00 36.29           H 
ATOM    111 3HD1 LEU     6       3.202   1.047   2.895  1.00 36.29           H 
ATOM    112 1HD2 LEU     6       6.248   2.391   1.286  1.00 36.29           H 
ATOM    113 2HD2 LEU     6       5.935   0.676   1.561  1.00 36.29           H 
ATOM    114 3HD2 LEU     6       5.545   1.855   2.812  1.00 36.29           H 
ATOM    115  N   VAL     7       1.629   3.852  -0.188  1.00 44.11           N 
ATOM    116  CA  VAL     7       1.229   5.255  -0.013  1.00 52.30           C 
ATOM    117  C   VAL     7       2.399   6.130   0.495  1.00 41.41           C 
ATOM    118  O   VAL     7       2.938   5.888   1.576  1.00 15.11           O 
ATOM    119  CB  VAL     7       0.034   5.378   0.975  1.00 14.11           C 
ATOM    120  CG1 VAL     7      -0.397   6.838   1.141  1.00 51.14           C 
ATOM    121  CG2 VAL     7      -1.143   4.512   0.514  1.00 52.40           C 
ATOM    122  H   VAL     7       1.148   3.158   0.308  1.00 36.29           H 
ATOM    123  HA  VAL     7       0.906   5.628  -0.977  1.00 34.04           H 
ATOM    124  HB  VAL     7       0.357   5.016   1.940  1.00 41.14           H 
ATOM    125 1HG1 VAL     7       0.428   7.416   1.532  1.00 36.29           H 
ATOM    126 2HG1 VAL     7      -1.230   6.895   1.828  1.00 36.29           H 
ATOM    127 3HG1 VAL     7      -0.695   7.239   0.183  1.00 36.29           H 
ATOM    128 1HG2 VAL     7      -1.458   4.821  -0.472  1.00 36.29           H 
ATOM    129 2HG2 VAL     7      -1.969   4.620   1.205  1.00 36.29           H 
ATOM    130 3HG2 VAL     7      -0.837   3.475   0.483  1.00 36.29           H 
ATOM    131  N   PRO     8       2.802   7.162  -0.282  1.00 23.31           N 
ATOM    132  CA  PRO     8       3.902   8.073   0.102  1.00 61.14           C 
ATOM    133  C   PRO     8       3.752   8.648   1.526  1.00 24.12           C 
ATOM    134  O   PRO     8       2.852   9.448   1.798  1.00 15.04           O 
ATOM    135  CB  PRO     8       3.814   9.190  -0.945  1.00 34.35           C 
ATOM    136  CG  PRO     8       3.204   8.534  -2.139  1.00 22.30           C 
ATOM    137  CD  PRO     8       2.231   7.517  -1.600  1.00  0.40           C 
ATOM    138  HA  PRO     8       4.861   7.578   0.020  1.00 12.00           H 
ATOM    139 3HB  PRO     8       4.805   9.565  -1.163  1.00 36.29           H 
ATOM    140 2HB  PRO     8       3.192   9.995  -0.574  1.00 36.29           H 
ATOM    141 3HG  PRO     8       3.972   8.047  -2.723  1.00 36.29           H 
ATOM    142 2HG  PRO     8       2.688   9.271  -2.741  1.00 36.29           H 
ATOM    143 3HD  PRO     8       2.188   6.653  -2.248  1.00 36.29           H 
ATOM    144 2HD  PRO     8       1.247   7.955  -1.487  1.00 36.29           H 
ATOM    145  N   GLY     9       4.646   8.240   2.428  1.00 12.24           N 
ATOM    146  CA  GLY     9       4.576   8.671   3.823  1.00 71.12           C 
ATOM    147  C   GLY     9       4.364   7.512   4.795  1.00 14.14           C 
ATOM    148  O   GLY     9       4.726   7.604   5.970  1.00 53.41           O 
ATOM    149  H   GLY     9       5.370   7.646   2.142  1.00 36.29           H 
ATOM    150 3HA  GLY     9       3.761   9.374   3.939  1.00 36.29           H 
ATOM    151 2HA  GLY     9       5.501   9.170   4.077  1.00 36.29           H 
ATOM    152  N   VAL    10       3.778   6.423   4.305  1.00 64.52           N 
ATOM    153  CA  VAL    10       3.529   5.234   5.129  1.00 45.04           C 
ATOM    154  C   VAL    10       4.758   4.303   5.157  1.00 22.22           C 
ATOM    155  O   VAL    10       5.238   3.867   4.110  1.00 13.40           O 
ATOM    156  CB  VAL    10       2.297   4.444   4.613  1.00 32.21           C 
ATOM    157  CG1 VAL    10       2.049   3.193   5.455  1.00 62.22           C 
ATOM    158  CG2 VAL    10       1.055   5.336   4.592  1.00 12.32           C 
ATOM    159  H   VAL    10       3.505   6.412   3.362  1.00 36.29           H 
ATOM    160  HA  VAL    10       3.317   5.568   6.137  1.00 21.15           H 
ATOM    161  HB  VAL    10       2.500   4.129   3.598  1.00 63.25           H 
ATOM    162 1HG1 VAL    10       2.906   2.536   5.390  1.00 36.29           H 
ATOM    163 2HG1 VAL    10       1.175   2.678   5.086  1.00 36.29           H 
ATOM    164 3HG1 VAL    10       1.891   3.477   6.486  1.00 36.29           H 
ATOM    165 1HG2 VAL    10       1.226   6.180   3.939  1.00 36.29           H 
ATOM    166 2HG2 VAL    10       0.848   5.693   5.591  1.00 36.29           H 
ATOM    167 3HG2 VAL    10       0.208   4.769   4.231  1.00 36.29           H 
ATOM    168  N   PRO    11       5.292   3.994   6.358  1.00 14.03           N 
ATOM    169  CA  PRO    11       6.452   3.097   6.503  1.00  4.53           C 
ATOM    170  C   PRO    11       6.083   1.603   6.412  1.00 14.25           C 
ATOM    171  O   PRO    11       5.083   1.156   6.985  1.00  4.44           O 
ATOM    172  CB  PRO    11       6.970   3.443   7.903  1.00  4.12           C 
ATOM    173  CG  PRO    11       5.750   3.846   8.664  1.00 24.22           C 
ATOM    174  CD  PRO    11       4.824   4.503   7.666  1.00 63.44           C 
ATOM    175  HA  PRO    11       7.216   3.321   5.770  1.00 72.10           H 
ATOM    176 3HB  PRO    11       7.681   4.255   7.839  1.00 36.29           H 
ATOM    177 2HB  PRO    11       7.448   2.577   8.344  1.00 36.29           H 
ATOM    178 3HG  PRO    11       6.016   4.544   9.446  1.00 36.29           H 
ATOM    179 2HG  PRO    11       5.278   2.971   9.091  1.00 36.29           H 
ATOM    180 3HD  PRO    11       4.918   5.580   7.713  1.00 36.29           H 
ATOM    181 2HD  PRO    11       3.801   4.208   7.848  1.00 36.29           H 
ATOM    182  N   ALA    12       6.901   0.833   5.695  1.00 41.23           N 
ATOM    183  CA  ALA    12       6.690  -0.613   5.558  1.00 13.34           C 
ATOM    184  C   ALA    12       7.997  -1.397   5.764  1.00  4.20           C 
ATOM    185  O   ALA    12       9.063  -0.956   5.350  1.00 53.40           O 
ATOM    186  CB  ALA    12       6.088  -0.931   4.194  1.00 41.20           C 
ATOM    187  H   ALA    12       7.663   1.249   5.235  1.00 36.29           H 
ATOM    188  HA  ALA    12       5.982  -0.919   6.316  1.00 70.54           H 
ATOM    189 1HB  ALA    12       5.158  -0.392   4.074  1.00 36.29           H 
ATOM    190 2HB  ALA    12       5.896  -1.992   4.123  1.00 36.29           H 
ATOM    191 3HB  ALA    12       6.777  -0.637   3.414  1.00 36.29           H 
ATOM    192  N   ARG    13       7.913  -2.563   6.401  1.00 12.42           N 
ATOM    193  CA  ARG    13       9.106  -3.379   6.672  1.00 30.40           C 
ATOM    194  C   ARG    13       9.311  -4.451   5.585  1.00 42.44           C 
ATOM    195  O   ARG    13       8.356  -5.085   5.137  1.00 71.15           O 
ATOM    196  CB  ARG    13       8.995  -4.049   8.052  1.00 72.24           C 
ATOM    197  CG  ARG    13      10.269  -4.777   8.486  1.00 32.23           C 
ATOM    198  CD  ARG    13      10.105  -5.477   9.834  1.00 34.44           C 
ATOM    199  NE  ARG    13       9.133  -6.570   9.779  1.00  2.45           N 
ATOM    200  CZ  ARG    13       9.006  -7.486  10.701  1.00 54.22           C 
ATOM    201  NH1 ARG    13       9.728  -7.455  11.775  1.00 63.05           N 
ATOM    202  NH2 ARG    13       8.138  -8.429  10.548  1.00 72.55           N 
ATOM    203  H   ARG    13       7.037  -2.881   6.699  1.00 36.29           H 
ATOM    204  HA  ARG    13       9.964  -2.722   6.673  1.00 11.40           H 
ATOM    205 3HB  ARG    13       8.186  -4.765   8.031  1.00 36.29           H 
ATOM    206 2HB  ARG    13       8.770  -3.290   8.790  1.00 36.29           H 
ATOM    207 3HG  ARG    13      11.071  -4.056   8.562  1.00 36.29           H 
ATOM    208 2HG  ARG    13      10.522  -5.516   7.739  1.00 36.29           H 
ATOM    209 3HD  ARG    13       9.774  -4.752  10.565  1.00 36.29           H 
ATOM    210 2HD  ARG    13      11.064  -5.876  10.137  1.00 36.29           H 
ATOM    211  HE  ARG    13       8.548  -6.622   8.997  1.00 22.44           H 
ATOM    212 1HH1 ARG    13      10.393  -6.725  11.911  1.00 36.29           H 
ATOM    213 2HH1 ARG    13       9.621  -8.166  12.464  1.00 36.29           H 
ATOM    214 1HH2 ARG    13       7.567  -8.450   9.727  1.00 36.29           H 
ATOM    215 2HH2 ARG    13       8.039  -9.133  11.247  1.00 36.29           H 
ATOM    216  N   ILE    14      10.561  -4.637   5.169  1.00  2.55           N 
ATOM    217  CA  ILE    14      10.908  -5.622   4.137  1.00 71.42           C 
ATOM    218  C   ILE    14      10.714  -7.064   4.644  1.00 32.34           C 
ATOM    219  O   ILE    14      11.498  -7.544   5.470  1.00 73.21           O 
ATOM    220  CB  ILE    14      12.389  -5.463   3.688  1.00  2.42           C 
ATOM    221  CG1 ILE    14      12.711  -4.005   3.309  1.00  2.21           C 
ATOM    222  CG2 ILE    14      12.702  -6.398   2.519  1.00 12.31           C 
ATOM    223  CD1 ILE    14      11.972  -3.496   2.095  1.00 64.15           C 
ATOM    224  H   ILE    14      11.275  -4.094   5.564  1.00 36.29           H 
ATOM    225  HA  ILE    14      10.269  -5.456   3.280  1.00 32.01           H 
ATOM    226  HB  ILE    14      13.020  -5.753   4.517  1.00 63.30           H 
ATOM    227 3HG1 ILE    14      13.770  -3.920   3.110  1.00 36.29           H 
ATOM    228 2HG1 ILE    14      12.456  -3.363   4.137  1.00 36.29           H 
ATOM    229 1HG2 ILE    14      13.728  -6.259   2.211  1.00 36.29           H 
ATOM    230 2HG2 ILE    14      12.045  -6.174   1.692  1.00 36.29           H 
ATOM    231 3HG2 ILE    14      12.555  -7.422   2.829  1.00 36.29           H 
ATOM    232 1HD1 ILE    14      12.188  -4.129   1.247  1.00 36.29           H 
ATOM    233 2HD1 ILE    14      12.290  -2.487   1.880  1.00 36.29           H 
ATOM    234 3HD1 ILE    14      10.910  -3.504   2.288  1.00 36.29           H 
ATOM    235  N   LYS    15       9.680  -7.754   4.151  1.00 65.45           N 
ATOM    236  CA  LYS    15       9.479  -9.174   4.480  1.00  5.15           C 
ATOM    237  C   LYS    15      10.547 -10.041   3.798  1.00  4.03           C 
ATOM    238  O   LYS    15      11.325 -10.733   4.452  1.00 71.41           O 
ATOM    239  CB  LYS    15       8.097  -9.690   4.028  1.00  1.11           C 
ATOM    240  CG  LYS    15       6.882  -9.032   4.682  1.00 65.44           C 
ATOM    241  CD  LYS    15       5.621  -9.866   4.421  1.00 23.12           C 
ATOM    242  CE  LYS    15       4.339  -9.190   4.899  1.00 73.24           C 
ATOM    243  NZ  LYS    15       3.909  -8.093   3.990  1.00 33.12           N 
ATOM    244  H   LYS    15       9.045  -7.304   3.555  1.00 36.29           H 
ATOM    245  HA  LYS    15       9.566  -9.286   5.552  1.00 63.34           H 
ATOM    246 3HB  LYS    15       8.050 -10.753   4.233  1.00 36.29           H 
ATOM    247 2HB  LYS    15       8.012  -9.547   2.960  1.00 36.29           H 
ATOM    248 3HG  LYS    15       6.747  -8.043   4.265  1.00 36.29           H 
ATOM    249 2HG  LYS    15       7.047  -8.962   5.748  1.00 36.29           H 
ATOM    250 3HD  LYS    15       5.723 -10.815   4.931  1.00 36.29           H 
ATOM    251 2HD  LYS    15       5.537 -10.042   3.359  1.00 36.29           H 
ATOM    252 3HE  LYS    15       4.506  -8.783   5.886  1.00 36.29           H 
ATOM    253 2HE  LYS    15       3.552  -9.928   4.946  1.00 36.29           H 
ATOM    254 1HZ  LYS    15       3.748  -8.461   3.031  1.00 36.29           H 
ATOM    255 2HZ  LYS    15       4.635  -7.356   3.943  1.00 36.29           H 
ATOM    256 3HZ  LYS    15       3.022  -7.670   4.334  1.00 36.29           H 
ATOM    257  N   ARG    16      10.573  -9.985   2.465  1.00 53.12           N 
ATOM    258  CA  ARG    16      11.427 -10.869   1.666  1.00 72.13           C 
ATOM    259  C   ARG    16      11.640 -10.326   0.242  1.00 25.20           C 
ATOM    260  O   ARG    16      10.906  -9.449  -0.219  1.00 32.24           O 
ATOM    261  CB  ARG    16      10.792 -12.264   1.587  1.00 52.01           C 
ATOM    262  CG  ARG    16       9.361 -12.243   1.052  1.00 71.01           C 
ATOM    263  CD  ARG    16       8.743 -13.634   1.005  1.00 61.23           C 
ATOM    264  NE  ARG    16       9.381 -14.498   0.011  1.00 72.42           N 
ATOM    265  CZ  ARG    16       8.831 -15.579  -0.473  1.00 20.34           C 
ATOM    266  NH1 ARG    16       7.664 -15.966  -0.065  1.00 12.04           N 
ATOM    267  NH2 ARG    16       9.452 -16.283  -1.360  1.00 11.42           N 
ATOM    268  H   ARG    16      10.005  -9.329   2.006  1.00 36.29           H 
ATOM    269  HA  ARG    16      12.385 -10.946   2.160  1.00 73.44           H 
ATOM    270 3HB  ARG    16      10.778 -12.699   2.577  1.00 36.29           H 
ATOM    271 2HB  ARG    16      11.392 -12.887   0.939  1.00 36.29           H 
ATOM    272 3HG  ARG    16       9.370 -11.828   0.052  1.00 36.29           H 
ATOM    273 2HG  ARG    16       8.758 -11.615   1.693  1.00 36.29           H 
ATOM    274 3HD  ARG    16       7.693 -13.536   0.763  1.00 36.29           H 
ATOM    275 2HD  ARG    16       8.843 -14.092   1.980  1.00 36.29           H 
ATOM    276  HE  ARG    16      10.269 -14.246  -0.311  1.00 74.05           H 
ATOM    277 1HH1 ARG    16       7.174 -15.436   0.626  1.00 36.29           H 
ATOM    278 2HH1 ARG    16       7.254 -16.795  -0.444  1.00 36.29           H 
ATOM    279 1HH2 ARG    16      10.355 -16.000  -1.677  1.00 36.29           H 
ATOM    280 2HH2 ARG    16       9.024 -17.104  -1.728  1.00 36.29           H 
ATOM    281  N   LEU    17      12.645 -10.863  -0.450  1.00  0.31           N 
ATOM    282  CA  LEU    17      12.922 -10.490  -1.843  1.00 62.33           C 
ATOM    283  C   LEU    17      12.686 -11.688  -2.778  1.00  3.55           C 
ATOM    284  O   LEU    17      13.438 -12.664  -2.747  1.00  4.43           O 
ATOM    285  CB  LEU    17      14.372  -9.988  -2.007  1.00 34.31           C 
ATOM    286  CG  LEU    17      14.729  -8.668  -1.289  1.00 73.12           C 
ATOM    287  CD1 LEU    17      14.759  -8.844   0.228  1.00 51.21           C 
ATOM    288  CD2 LEU    17      16.067  -8.128  -1.792  1.00 23.23           C 
ATOM    289  H   LEU    17      13.215 -11.534  -0.014  1.00 36.29           H 
ATOM    290  HA  LEU    17      12.243  -9.694  -2.117  1.00  3.45           H 
ATOM    291 3HB  LEU    17      14.560  -9.853  -3.064  1.00 36.29           H 
ATOM    292 2HB  LEU    17      15.036 -10.759  -1.642  1.00 36.29           H 
ATOM    293  HG  LEU    17      13.972  -7.931  -1.516  1.00 55.30           H 
ATOM    294 1HD1 LEU    17      13.784  -9.152   0.573  1.00 36.29           H 
ATOM    295 2HD1 LEU    17      15.023  -7.906   0.694  1.00 36.29           H 
ATOM    296 3HD1 LEU    17      15.490  -9.595   0.493  1.00 36.29           H 
ATOM    297 1HD2 LEU    17      15.995  -7.910  -2.847  1.00 36.29           H 
ATOM    298 2HD2 LEU    17      16.842  -8.865  -1.630  1.00 36.29           H 
ATOM    299 3HD2 LEU    17      16.315  -7.223  -1.255  1.00 36.29           H 
ATOM    300  N   GLU    18      11.650 -11.616  -3.609  1.00 65.14           N 
ATOM    301  CA  GLU    18      11.313 -12.710  -4.532  1.00 61.25           C 
ATOM    302  C   GLU    18      12.190 -12.680  -5.802  1.00 13.35           C 
ATOM    303  O   GLU    18      11.698 -12.836  -6.922  1.00 54.12           O 
ATOM    304  CB  GLU    18       9.818 -12.641  -4.893  1.00 64.31           C 
ATOM    305  CG  GLU    18       8.890 -12.730  -3.680  1.00 30.41           C 
ATOM    306  CD  GLU    18       7.420 -12.882  -4.059  1.00 44.25           C 
ATOM    307  OE1 GLU    18       7.032 -13.991  -4.487  1.00 73.44           O 
ATOM    308  OE2 GLU    18       6.650 -11.903  -3.923  1.00 72.23           O 
ATOM    309  H   GLU    18      11.091 -10.812  -3.602  1.00 36.29           H 
ATOM    310  HA  GLU    18      11.498 -13.643  -4.015  1.00  3.23           H 
ATOM    311 3HB  GLU    18       9.582 -13.460  -5.560  1.00 36.29           H 
ATOM    312 2HB  GLU    18       9.624 -11.706  -5.400  1.00 36.29           H 
ATOM    313 3HG  GLU    18       9.008 -11.830  -3.089  1.00 36.29           H 
ATOM    314 2HG  GLU    18       9.181 -13.584  -3.085  1.00 36.29           H 
ATOM    315  N   VAL    19      13.500 -12.511  -5.610  1.00 61.33           N 
ATOM    316  CA  VAL    19      14.461 -12.464  -6.720  1.00 64.02           C 
ATOM    317  C   VAL    19      15.892 -12.796  -6.248  1.00 51.43           C 
ATOM    318  O   VAL    19      16.281 -12.473  -5.124  1.00 60.45           O 
ATOM    319  CB  VAL    19      14.460 -11.070  -7.404  1.00 21.12           C 
ATOM    320  CG1 VAL    19      14.876  -9.976  -6.420  1.00 20.32           C 
ATOM    321  CG2 VAL    19      15.362 -11.064  -8.642  1.00 35.12           C 
ATOM    322  H   VAL    19      13.833 -12.421  -4.695  1.00 36.29           H 
ATOM    323  HA  VAL    19      14.157 -13.200  -7.452  1.00 71.45           H 
ATOM    324  HB  VAL    19      13.449 -10.857  -7.727  1.00 20.42           H 
ATOM    325 1HG1 VAL    19      14.197  -9.969  -5.579  1.00 36.29           H 
ATOM    326 2HG1 VAL    19      14.844  -9.014  -6.915  1.00 36.29           H 
ATOM    327 3HG1 VAL    19      15.879 -10.166  -6.070  1.00 36.29           H 
ATOM    328 1HG2 VAL    19      15.338 -10.086  -9.102  1.00 36.29           H 
ATOM    329 2HG2 VAL    19      15.010 -11.800  -9.350  1.00 36.29           H 
ATOM    330 3HG2 VAL    19      16.376 -11.300  -8.352  1.00 36.29           H 
ATOM    331  N   SER    20      16.668 -13.440  -7.120  1.00 30.03           N 
ATOM    332  CA  SER    20      18.064 -13.797  -6.819  1.00 25.34           C 
ATOM    333  C   SER    20      18.943 -13.724  -8.080  1.00 44.25           C 
ATOM    334  O   SER    20      18.525 -14.140  -9.162  1.00  1.44           O 
ATOM    335  CB  SER    20      18.143 -15.212  -6.222  1.00 54.34           C 
ATOM    336  OG  SER    20      17.658 -16.194  -7.132  1.00 62.52           O 
ATOM    337  H   SER    20      16.293 -13.691  -7.990  1.00 36.29           H 
ATOM    338  HA  SER    20      18.439 -13.088  -6.092  1.00 21.44           H 
ATOM    339 3HB  SER    20      17.550 -15.253  -5.320  1.00 36.29           H 
ATOM    340 2HB  SER    20      19.173 -15.443  -5.983  1.00 36.29           H 
ATOM    341  HG  SER    20      17.701 -15.848  -8.034  1.00 34.34           H 
ATOM    342  N   GLY    21      20.162 -13.203  -7.936  1.00 43.32           N 
ATOM    343  CA  GLY    21      21.082 -13.104  -9.070  1.00 23.41           C 
ATOM    344  C   GLY    21      20.997 -11.768  -9.811  1.00  2.22           C 
ATOM    345  O   GLY    21      19.912 -11.349 -10.222  1.00 65.42           O 
ATOM    346  H   GLY    21      20.447 -12.890  -7.050  1.00 36.29           H 
ATOM    347 3HA  GLY    21      20.866 -13.902  -9.767  1.00 36.29           H 
ATOM    348 2HA  GLY    21      22.090 -13.233  -8.705  1.00 36.29           H 
ATOM    349  N   GLU    22      22.147 -11.100  -9.970  1.00 25.21           N 
ATOM    350  CA  GLU    22      22.243  -9.823 -10.704  1.00 35.14           C 
ATOM    351  C   GLU    22      21.469  -8.681 -10.015  1.00 50.11           C 
ATOM    352  O   GLU    22      22.065  -7.758  -9.459  1.00 14.41           O 
ATOM    353  CB  GLU    22      21.769  -9.991 -12.160  1.00 34.40           C 
ATOM    354  CG  GLU    22      22.683 -10.870 -13.010  1.00 62.03           C 
ATOM    355  CD  GLU    22      22.176 -11.049 -14.434  1.00 22.45           C 
ATOM    356  OE1 GLU    22      21.874 -12.194 -14.830  1.00 61.44           O 
ATOM    357  OE2 GLU    22      22.061 -10.042 -15.164  1.00 72.20           O 
ATOM    358  H   GLU    22      22.963 -11.474  -9.575  1.00 36.29           H 
ATOM    359  HA  GLU    22      23.290  -9.551 -10.720  1.00 42.54           H 
ATOM    360 3HB  GLU    22      21.711  -9.016 -12.624  1.00 36.29           H 
ATOM    361 2HB  GLU    22      20.782 -10.433 -12.156  1.00 36.29           H 
ATOM    362 3HG  GLU    22      22.762 -11.841 -12.543  1.00 36.29           H 
ATOM    363 2HG  GLU    22      23.663 -10.413 -13.050  1.00 36.29           H 
ATOM    364  N   LEU    23      20.141  -8.738 -10.056  1.00 52.11           N 
ATOM    365  CA  LEU    23      19.307  -7.690  -9.456  1.00 42.43           C 
ATOM    366  C   LEU    23      19.362  -7.725  -7.917  1.00 54.40           C 
ATOM    367  O   LEU    23      19.346  -6.683  -7.260  1.00 31.34           O 
ATOM    368  CB  LEU    23      17.853  -7.829  -9.935  1.00 25.13           C 
ATOM    369  CG  LEU    23      16.890  -6.751  -9.414  1.00 34.53           C 
ATOM    370  CD1 LEU    23      17.379  -5.358  -9.802  1.00 51.22           C 
ATOM    371  CD2 LEU    23      15.476  -6.993  -9.938  1.00  1.54           C 
ATOM    372  H   LEU    23      19.710  -9.498 -10.502  1.00 36.29           H 
ATOM    373  HA  LEU    23      19.692  -6.735  -9.792  1.00 63.41           H 
ATOM    374 3HB  LEU    23      17.483  -8.794  -9.618  1.00 36.29           H 
ATOM    375 2HB  LEU    23      17.848  -7.799 -11.016  1.00 36.29           H 
ATOM    376  HG  LEU    23      16.857  -6.800  -8.334  1.00 11.35           H 
ATOM    377 1HD1 LEU    23      18.367  -5.196  -9.393  1.00 36.29           H 
ATOM    378 2HD1 LEU    23      16.703  -4.616  -9.406  1.00 36.29           H 
ATOM    379 3HD1 LEU    23      17.416  -5.274 -10.879  1.00 36.29           H 
ATOM    380 1HD2 LEU    23      15.480  -6.962 -11.019  1.00 36.29           H 
ATOM    381 2HD2 LEU    23      14.813  -6.227  -9.559  1.00 36.29           H 
ATOM    382 3HD2 LEU    23      15.128  -7.961  -9.606  1.00 36.29           H 
ATOM    383  N   HIS    24      19.440  -8.927  -7.347  1.00  5.44           N 
ATOM    384  CA  HIS    24      19.451  -9.098  -5.887  1.00 21.23           C 
ATOM    385  C   HIS    24      20.626  -8.346  -5.232  1.00 15.23           C 
ATOM    386  O   HIS    24      20.454  -7.677  -4.212  1.00 20.14           O 
ATOM    387  CB  HIS    24      19.509 -10.589  -5.534  1.00 22.14           C 
ATOM    388  CG  HIS    24      19.431 -10.874  -4.061  1.00 74.40           C 
ATOM    389  ND1 HIS    24      20.541 -11.011  -3.257  1.00 22.52           N 
ATOM    390  CD2 HIS    24      18.364 -11.068  -3.253  1.00 72.20           C 
ATOM    391  CE1 HIS    24      20.161 -11.276  -2.025  1.00 11.43           C 
ATOM    392  NE2 HIS    24      18.844 -11.316  -1.993  1.00 72.11           N 
ATOM    393  H   HIS    24      19.496  -9.719  -7.922  1.00 36.29           H 
ATOM    394  HA  HIS    24      18.527  -8.689  -5.504  1.00 73.12           H 
ATOM    395 3HB  HIS    24      20.435 -11.007  -5.904  1.00 36.29           H 
ATOM    396 2HB  HIS    24      18.680 -11.095  -6.008  1.00 36.29           H 
ATOM    397  HD1 HIS    24      21.476 -10.931  -3.549  1.00 43.04           H 
ATOM    398  HD2 HIS    24      17.323 -11.033  -3.547  1.00 22.55           H 
ATOM    399  HE1 HIS    24      20.817 -11.438  -1.182  1.00 34.02           H 
ATOM    400  HE2 HIS    24      18.323 -11.726  -1.267  1.00 36.29           H 
ATOM    401  N   GLU    25      21.814  -8.462  -5.821  1.00  1.01           N 
ATOM    402  CA  GLU    25      23.002  -7.760  -5.313  1.00 20.24           C 
ATOM    403  C   GLU    25      22.894  -6.237  -5.504  1.00 14.42           C 
ATOM    404  O   GLU    25      23.382  -5.464  -4.678  1.00 51.00           O 
ATOM    405  CB  GLU    25      24.270  -8.315  -5.975  1.00 74.25           C 
ATOM    406  CG  GLU    25      24.226  -8.330  -7.499  1.00 60.44           C 
ATOM    407  CD  GLU    25      25.174  -9.357  -8.097  1.00 13.20           C 
ATOM    408  OE1 GLU    25      26.222  -8.969  -8.652  1.00 23.14           O 
ATOM    409  OE2 GLU    25      24.871 -10.565  -8.005  1.00 30.12           O 
ATOM    410  H   GLU    25      21.902  -9.043  -6.607  1.00 36.29           H 
ATOM    411  HA  GLU    25      23.058  -7.960  -4.251  1.00 31.22           H 
ATOM    412 3HB  GLU    25      24.419  -9.330  -5.631  1.00 36.29           H 
ATOM    413 2HB  GLU    25      25.115  -7.716  -5.666  1.00 36.29           H 
ATOM    414 3HG  GLU    25      24.497  -7.348  -7.866  1.00 36.29           H 
ATOM    415 2HG  GLU    25      23.220  -8.565  -7.816  1.00 36.29           H 
ATOM    416  N   LYS    26      22.248  -5.809  -6.587  1.00 33.11           N 
ATOM    417  CA  LYS    26      21.936  -4.388  -6.789  1.00  2.13           C 
ATOM    418  C   LYS    26      21.045  -3.868  -5.647  1.00  1.22           C 
ATOM    419  O   LYS    26      21.283  -2.795  -5.085  1.00 54.51           O 
ATOM    420  CB  LYS    26      21.227  -4.181  -8.138  1.00 23.05           C 
ATOM    421  CG  LYS    26      20.755  -2.747  -8.376  1.00 73.40           C 
ATOM    422  CD  LYS    26      19.990  -2.602  -9.691  1.00 51.53           C 
ATOM    423  CE  LYS    26      19.479  -1.178  -9.894  1.00 32.13           C 
ATOM    424  NZ  LYS    26      20.585  -0.182  -9.921  1.00 65.41           N 
ATOM    425  H   LYS    26      21.984  -6.460  -7.272  1.00 36.29           H 
ATOM    426  HA  LYS    26      22.867  -3.837  -6.788  1.00 21.01           H 
ATOM    427 3HB  LYS    26      20.365  -4.833  -8.184  1.00 36.29           H 
ATOM    428 2HB  LYS    26      21.909  -4.448  -8.933  1.00 36.29           H 
ATOM    429 3HG  LYS    26      21.617  -2.094  -8.398  1.00 36.29           H 
ATOM    430 2HG  LYS    26      20.104  -2.454  -7.564  1.00 36.29           H 
ATOM    431 3HD  LYS    26      19.147  -3.278  -9.682  1.00 36.29           H 
ATOM    432 2HD  LYS    26      20.647  -2.857 -10.511  1.00 36.29           H 
ATOM    433 3HE  LYS    26      18.805  -0.931  -9.085  1.00 36.29           H 
ATOM    434 2HE  LYS    26      18.945  -1.132 -10.832  1.00 36.29           H 
ATOM    435 1HZ  LYS    26      21.194  -0.296  -9.087  1.00 36.29           H 
ATOM    436 2HZ  LYS    26      20.197   0.783  -9.915  1.00 36.29           H 
ATOM    437 3HZ  LYS    26      21.162  -0.304 -10.778  1.00 36.29           H 
ATOM    438  N   LEU    27      20.024  -4.650  -5.307  1.00  4.41           N 
ATOM    439  CA  LEU    27      19.083  -4.291  -4.242  1.00 50.20           C 
ATOM    440  C   LEU    27      19.781  -4.169  -2.873  1.00 51.10           C 
ATOM    441  O   LEU    27      19.699  -3.127  -2.217  1.00  3.54           O 
ATOM    442  CB  LEU    27      17.956  -5.332  -4.174  1.00 34.50           C 
ATOM    443  CG  LEU    27      17.071  -5.423  -5.432  1.00 22.13           C 
ATOM    444  CD1 LEU    27      16.069  -6.569  -5.311  1.00 62.11           C 
ATOM    445  CD2 LEU    27      16.352  -4.096  -5.685  1.00 60.43           C 
ATOM    446  H   LEU    27      19.895  -5.494  -5.790  1.00 36.29           H 
ATOM    447  HA  LEU    27      18.653  -3.331  -4.494  1.00 23.24           H 
ATOM    448 3HB  LEU    27      17.321  -5.093  -3.332  1.00 36.29           H 
ATOM    449 2HB  LEU    27      18.402  -6.302  -4.001  1.00 36.29           H 
ATOM    450  HG  LEU    27      17.700  -5.626  -6.287  1.00 31.34           H 
ATOM    451 1HD1 LEU    27      16.601  -7.500  -5.172  1.00 36.29           H 
ATOM    452 2HD1 LEU    27      15.478  -6.626  -6.213  1.00 36.29           H 
ATOM    453 3HD1 LEU    27      15.419  -6.396  -4.465  1.00 36.29           H 
ATOM    454 1HD2 LEU    27      15.744  -4.180  -6.575  1.00 36.29           H 
ATOM    455 2HD2 LEU    27      17.080  -3.310  -5.821  1.00 36.29           H 
ATOM    456 3HD2 LEU    27      15.720  -3.858  -4.841  1.00 36.29           H 
ATOM    457  N   VAL    28      20.473  -5.227  -2.449  1.00 41.14           N 
ATOM    458  CA  VAL    28      21.202  -5.206  -1.172  1.00 31.54           C 
ATOM    459  C   VAL    28      22.322  -4.151  -1.187  1.00  2.43           C 
ATOM    460  O   VAL    28      22.674  -3.585  -0.151  1.00 42.45           O 
ATOM    461  CB  VAL    28      21.796  -6.596  -0.812  1.00 35.24           C 
ATOM    462  CG1 VAL    28      20.698  -7.656  -0.773  1.00 43.52           C 
ATOM    463  CG2 VAL    28      22.904  -6.994  -1.786  1.00 23.41           C 
ATOM    464  H   VAL    28      20.488  -6.041  -2.998  1.00 36.29           H 
ATOM    465  HA  VAL    28      20.492  -4.937  -0.399  1.00 15.12           H 
ATOM    466  HB  VAL    28      22.227  -6.529   0.179  1.00 34.11           H 
ATOM    467 1HG1 VAL    28      20.237  -7.735  -1.748  1.00 36.29           H 
ATOM    468 2HG1 VAL    28      19.951  -7.378  -0.044  1.00 36.29           H 
ATOM    469 3HG1 VAL    28      21.127  -8.611  -0.500  1.00 36.29           H 
ATOM    470 1HG2 VAL    28      23.708  -6.275  -1.733  1.00 36.29           H 
ATOM    471 2HG2 VAL    28      22.510  -7.017  -2.791  1.00 36.29           H 
ATOM    472 3HG2 VAL    28      23.281  -7.974  -1.525  1.00 36.29           H 
ATOM    473  N   GLY    29      22.883  -3.897  -2.371  1.00 31.42           N 
ATOM    474  CA  GLY    29      23.868  -2.831  -2.532  1.00 51.22           C 
ATOM    475  C   GLY    29      23.289  -1.447  -2.241  1.00 63.34           C 
ATOM    476  O   GLY    29      23.980  -0.569  -1.718  1.00 30.35           O 
ATOM    477  H   GLY    29      22.633  -4.446  -3.146  1.00 36.29           H 
ATOM    478 3HA  GLY    29      24.236  -2.848  -3.549  1.00 36.29           H 
ATOM    479 2HA  GLY    29      24.695  -3.013  -1.860  1.00 36.29           H 
ATOM    480  N   MET    30      22.015  -1.257  -2.582  1.00  3.32           N 
ATOM    481  CA  MET    30      21.309  -0.001  -2.299  1.00  5.23           C 
ATOM    482  C   MET    30      20.713   0.005  -0.878  1.00 22.33           C 
ATOM    483  O   MET    30      20.421   1.066  -0.324  1.00 35.41           O 
ATOM    484  CB  MET    30      20.211   0.242  -3.345  1.00 11.22           C 
ATOM    485  CG  MET    30      20.754   0.455  -4.752  1.00  1.14           C 
ATOM    486  SD  MET    30      19.457   0.812  -5.956  1.00 22.01           S 
ATOM    487  CE  MET    30      18.502  -0.703  -5.889  1.00 63.52           C 
ATOM    488  H   MET    30      21.537  -1.980  -3.043  1.00 36.29           H 
ATOM    489  HA  MET    30      22.032   0.801  -2.367  1.00 44.01           H 
ATOM    490 3HB  MET    30      19.647   1.118  -3.063  1.00 36.29           H 
ATOM    491 2HB  MET    30      19.548  -0.612  -3.363  1.00 36.29           H 
ATOM    492 3HG  MET    30      21.277  -0.440  -5.061  1.00 36.29           H 
ATOM    493 2HG  MET    30      21.444   1.285  -4.736  1.00 36.29           H 
ATOM    494 1HE  MET    30      19.128  -1.537  -6.171  1.00 36.29           H 
ATOM    495 2HE  MET    30      17.667  -0.634  -6.571  1.00 36.29           H 
ATOM    496 3HE  MET    30      18.134  -0.854  -4.885  1.00 36.29           H 
ATOM    497  N   GLY    31      20.529  -1.182  -0.288  1.00 64.43           N 
ATOM    498  CA  GLY    31      20.067  -1.268   1.102  1.00 12.31           C 
ATOM    499  C   GLY    31      18.915  -2.247   1.329  1.00 42.44           C 
ATOM    500  O   GLY    31      18.568  -2.545   2.477  1.00 43.15           O 
ATOM    501  H   GLY    31      20.716  -2.001  -0.793  1.00 36.29           H 
ATOM    502 3HA  GLY    31      19.749  -0.286   1.424  1.00 36.29           H 
ATOM    503 2HA  GLY    31      20.899  -1.575   1.719  1.00 36.29           H 
ATOM    504  N   PHE    32      18.317  -2.750   0.250  1.00 21.02           N 
ATOM    505  CA  PHE    32      17.173  -3.669   0.355  1.00 73.14           C 
ATOM    506  C   PHE    32      17.560  -5.002   1.023  1.00 52.01           C 
ATOM    507  O   PHE    32      18.043  -5.923   0.362  1.00 42.21           O 
ATOM    508  CB  PHE    32      16.568  -3.944  -1.032  1.00 25.00           C 
ATOM    509  CG  PHE    32      15.960  -2.734  -1.696  1.00 31.13           C 
ATOM    510  CD1 PHE    32      16.760  -1.803  -2.344  1.00 24.34           C 
ATOM    511  CD2 PHE    32      14.586  -2.530  -1.675  1.00  5.14           C 
ATOM    512  CE1 PHE    32      16.205  -0.696  -2.953  1.00 73.05           C 
ATOM    513  CE2 PHE    32      14.028  -1.423  -2.283  1.00 61.32           C 
ATOM    514  CZ  PHE    32      14.837  -0.505  -2.923  1.00 40.43           C 
ATOM    515  H   PHE    32      18.647  -2.498  -0.637  1.00 36.29           H 
ATOM    516  HA  PHE    32      16.424  -3.186   0.966  1.00 23.32           H 
ATOM    517 3HB  PHE    32      15.794  -4.695  -0.935  1.00 36.29           H 
ATOM    518 2HB  PHE    32      17.342  -4.323  -1.683  1.00 36.29           H 
ATOM    519  HD1 PHE    32      17.830  -1.950  -2.368  1.00 53.21           H 
ATOM    520  HD2 PHE    32      13.951  -3.248  -1.177  1.00 60.02           H 
ATOM    521  HE1 PHE    32      16.840   0.020  -3.453  1.00 65.40           H 
ATOM    522  HE2 PHE    32      12.957  -1.275  -2.260  1.00 30.52           H 
ATOM    523  HZ  PHE    32      14.403   0.361  -3.398  1.00 72.35           H 
ATOM    524  N   VAL    33      17.362  -5.087   2.339  1.00 62.13           N 
ATOM    525  CA  VAL    33      17.590  -6.332   3.085  1.00 63.03           C 
ATOM    526  C   VAL    33      16.395  -6.650   4.007  1.00 51.44           C 
ATOM    527  O   VAL    33      15.780  -5.740   4.579  1.00 32.15           O 
ATOM    528  CB  VAL    33      18.901  -6.275   3.926  1.00 62.10           C 
ATOM    529  CG1 VAL    33      20.117  -6.065   3.025  1.00 55.24           C 
ATOM    530  CG2 VAL    33      18.826  -5.183   4.994  1.00 52.51           C 
ATOM    531  H   VAL    33      17.064  -4.289   2.823  1.00 36.29           H 
ATOM    532  HA  VAL    33      17.690  -7.135   2.365  1.00 61.15           H 
ATOM    533  HB  VAL    33      19.021  -7.227   4.427  1.00 30.32           H 
ATOM    534 1HG1 VAL    33      21.018  -6.064   3.624  1.00 36.29           H 
ATOM    535 2HG1 VAL    33      20.028  -5.119   2.511  1.00 36.29           H 
ATOM    536 3HG1 VAL    33      20.170  -6.863   2.298  1.00 36.29           H 
ATOM    537 1HG2 VAL    33      18.020  -5.403   5.680  1.00 36.29           H 
ATOM    538 2HG2 VAL    33      18.646  -4.229   4.522  1.00 36.29           H 
ATOM    539 3HG2 VAL    33      19.760  -5.145   5.538  1.00 36.29           H 
ATOM    540  N   PRO    34      16.038  -7.946   4.155  1.00  1.04           N 
ATOM    541  CA  PRO    34      14.906  -8.368   5.006  1.00  2.21           C 
ATOM    542  C   PRO    34      15.015  -7.834   6.446  1.00 34.35           C 
ATOM    543  O   PRO    34      15.907  -8.230   7.205  1.00 23.53           O 
ATOM    544  CB  PRO    34      14.993  -9.901   4.981  1.00 13.00           C 
ATOM    545  CG  PRO    34      15.710 -10.218   3.713  1.00 72.54           C 
ATOM    546  CD  PRO    34      16.696  -9.098   3.506  1.00 32.51           C 
ATOM    547  HA  PRO    34      13.959  -8.052   4.580  1.00 72.01           H 
ATOM    548 3HB  PRO    34      13.997 -10.323   4.988  1.00 36.29           H 
ATOM    549 2HB  PRO    34      15.543 -10.251   5.845  1.00 36.29           H 
ATOM    550 3HG  PRO    34      15.008 -10.258   2.891  1.00 36.29           H 
ATOM    551 2HG  PRO    34      16.228 -11.163   3.808  1.00 36.29           H 
ATOM    552 3HD  PRO    34      16.845  -8.915   2.451  1.00 36.29           H 
ATOM    553 2HD  PRO    34      17.638  -9.326   3.987  1.00 36.29           H 
ATOM    554  N   GLY    35      14.099  -6.939   6.813  1.00 51.52           N 
ATOM    555  CA  GLY    35      14.148  -6.295   8.124  1.00 62.41           C 
ATOM    556  C   GLY    35      14.120  -4.769   8.046  1.00 64.23           C 
ATOM    557  O   GLY    35      13.655  -4.106   8.975  1.00 51.22           O 
ATOM    558  H   GLY    35      13.365  -6.727   6.195  1.00 36.29           H 
ATOM    559 3HA  GLY    35      15.054  -6.599   8.634  1.00 36.29           H 
ATOM    560 2HA  GLY    35      13.300  -6.629   8.702  1.00 36.29           H 
ATOM    561  N   GLU    36      14.620  -4.214   6.940  1.00 53.21           N 
ATOM    562  CA  GLU    36      14.636  -2.756   6.736  1.00 11.03           C 
ATOM    563  C   GLU    36      13.231  -2.144   6.757  1.00 23.31           C 
ATOM    564  O   GLU    36      12.258  -2.761   6.326  1.00 61.20           O 
ATOM    565  CB  GLU    36      15.317  -2.400   5.402  1.00 32.34           C 
ATOM    566  CG  GLU    36      16.838  -2.339   5.469  1.00 13.14           C 
ATOM    567  CD  GLU    36      17.339  -1.243   6.399  1.00 44.42           C 
ATOM    568  OE1 GLU    36      16.727  -0.158   6.436  1.00 42.33           O 
ATOM    569  OE2 GLU    36      18.361  -1.458   7.084  1.00 62.32           O 
ATOM    570  H   GLU    36      14.995  -4.795   6.244  1.00 36.29           H 
ATOM    571  HA  GLU    36      15.209  -2.321   7.542  1.00 60.34           H 
ATOM    572 3HB  GLU    36      14.957  -1.433   5.074  1.00 36.29           H 
ATOM    573 2HB  GLU    36      15.042  -3.139   4.664  1.00 36.29           H 
ATOM    574 3HG  GLU    36      17.220  -2.148   4.475  1.00 36.29           H 
ATOM    575 2HG  GLU    36      17.210  -3.291   5.818  1.00 36.29           H 
ATOM    576  N   GLU    37      13.139  -0.920   7.263  1.00 62.22           N 
ATOM    577  CA  GLU    37      11.895  -0.154   7.219  1.00 65.14           C 
ATOM    578  C   GLU    37      11.964   0.899   6.111  1.00 35.44           C 
ATOM    579  O   GLU    37      12.697   1.881   6.211  1.00 53.53           O 
ATOM    580  CB  GLU    37      11.621   0.500   8.577  1.00 71.21           C 
ATOM    581  CG  GLU    37      11.387  -0.513   9.690  1.00 23.14           C 
ATOM    582  CD  GLU    37      11.247   0.135  11.057  1.00 20.24           C 
ATOM    583  OE1 GLU    37      12.279   0.377  11.714  1.00 53.54           O 
ATOM    584  OE2 GLU    37      10.105   0.406  11.479  1.00 64.04           O 
ATOM    585  H   GLU    37      13.931  -0.519   7.679  1.00 36.29           H 
ATOM    586  HA  GLU    37      11.089  -0.842   6.992  1.00 21.02           H 
ATOM    587 3HB  GLU    37      10.743   1.124   8.497  1.00 36.29           H 
ATOM    588 2HB  GLU    37      12.467   1.118   8.848  1.00 36.29           H 
ATOM    589 3HG  GLU    37      12.221  -1.200   9.713  1.00 36.29           H 
ATOM    590 2HG  GLU    37      10.481  -1.063   9.476  1.00 36.29           H 
ATOM    591  N   ILE    38      11.210   0.671   5.048  1.00 11.41           N 
ATOM    592  CA  ILE    38      11.230   1.539   3.870  1.00 13.12           C 
ATOM    593  C   ILE    38       9.952   2.391   3.775  1.00  2.14           C 
ATOM    594  O   ILE    38       8.836   1.879   3.862  1.00 52.15           O 
ATOM    595  CB  ILE    38      11.396   0.704   2.571  1.00 71.30           C 
ATOM    596  CG1 ILE    38      11.418   1.618   1.333  1.00 34.11           C 
ATOM    597  CG2 ILE    38      10.289  -0.346   2.454  1.00 72.01           C 
ATOM    598  CD1 ILE    38      11.584   0.869   0.025  1.00 73.03           C 
ATOM    599  H   ILE    38      10.618  -0.107   5.055  1.00 36.29           H 
ATOM    600  HA  ILE    38      12.085   2.199   3.957  1.00 43.24           H 
ATOM    601  HB  ILE    38      12.341   0.178   2.634  1.00 61.23           H 
ATOM    602 3HG1 ILE    38      12.240   2.315   1.421  1.00 36.29           H 
ATOM    603 2HG1 ILE    38      10.490   2.169   1.281  1.00 36.29           H 
ATOM    604 1HG2 ILE    38       9.328   0.146   2.379  1.00 36.29           H 
ATOM    605 2HG2 ILE    38      10.298  -0.979   3.330  1.00 36.29           H 
ATOM    606 3HG2 ILE    38      10.452  -0.952   1.575  1.00 36.29           H 
ATOM    607 1HD1 ILE    38      12.510   0.313   0.042  1.00 36.29           H 
ATOM    608 2HD1 ILE    38      11.603   1.573  -0.792  1.00 36.29           H 
ATOM    609 3HD1 ILE    38      10.757   0.186  -0.108  1.00 36.29           H 
ATOM    610  N   GLU    39      10.127   3.698   3.613  1.00 24.21           N 
ATOM    611  CA  GLU    39       8.998   4.623   3.451  1.00  0.11           C 
ATOM    612  C   GLU    39       9.097   5.378   2.114  1.00 74.24           C 
ATOM    613  O   GLU    39      10.150   5.922   1.766  1.00 61.24           O 
ATOM    614  CB  GLU    39       8.943   5.611   4.633  1.00 73.20           C 
ATOM    615  CG  GLU    39      10.230   6.403   4.838  1.00 54.35           C 
ATOM    616  CD  GLU    39      10.175   7.341   6.036  1.00  1.04           C 
ATOM    617  OE1 GLU    39      10.249   6.858   7.187  1.00 44.23           O 
ATOM    618  OE2 GLU    39      10.080   8.569   5.834  1.00 60.15           O 
ATOM    619  H   GLU    39      11.041   4.056   3.605  1.00 36.29           H 
ATOM    620  HA  GLU    39       8.089   4.037   3.445  1.00 25.43           H 
ATOM    621 3HB  GLU    39       8.739   5.056   5.539  1.00 36.29           H 
ATOM    622 2HB  GLU    39       8.135   6.312   4.466  1.00 36.29           H 
ATOM    623 3HG  GLU    39      10.420   6.988   3.948  1.00 36.29           H 
ATOM    624 2HG  GLU    39      11.043   5.708   4.984  1.00 36.29           H 
ATOM    625  N   ILE    40       8.003   5.384   1.354  1.00  4.05           N 
ATOM    626  CA  ILE    40       7.955   6.098   0.075  1.00 72.44           C 
ATOM    627  C   ILE    40       7.859   7.614   0.300  1.00 72.04           C 
ATOM    628  O   ILE    40       7.019   8.085   1.068  1.00 42.01           O 
ATOM    629  CB  ILE    40       6.757   5.631  -0.793  1.00 63.41           C 
ATOM    630  CG1 ILE    40       6.827   4.114  -1.055  1.00 70.43           C 
ATOM    631  CG2 ILE    40       6.713   6.402  -2.114  1.00 72.33           C 
ATOM    632  CD1 ILE    40       8.056   3.674  -1.828  1.00 40.12           C 
ATOM    633  H   ILE    40       7.211   4.896   1.659  1.00 36.29           H 
ATOM    634  HA  ILE    40       8.869   5.881  -0.463  1.00 32.24           H 
ATOM    635  HB  ILE    40       5.847   5.851  -0.252  1.00 54.33           H 
ATOM    636 3HG1 ILE    40       5.954   3.815  -1.622  1.00 36.29           H 
ATOM    637 2HG1 ILE    40       6.829   3.590  -0.111  1.00 36.29           H 
ATOM    638 1HG2 ILE    40       7.632   6.238  -2.658  1.00 36.29           H 
ATOM    639 2HG2 ILE    40       6.600   7.458  -1.914  1.00 36.29           H 
ATOM    640 3HG2 ILE    40       5.877   6.058  -2.706  1.00 36.29           H 
ATOM    641 1HD1 ILE    40       8.946   3.954  -1.282  1.00 36.29           H 
ATOM    642 2HD1 ILE    40       8.064   4.151  -2.796  1.00 36.29           H 
ATOM    643 3HD1 ILE    40       8.036   2.601  -1.956  1.00 36.29           H 
ATOM    644  N   VAL    41       8.728   8.373  -0.362  1.00 65.02           N 
ATOM    645  CA  VAL    41       8.744   9.831  -0.218  1.00 74.12           C 
ATOM    646  C   VAL    41       7.885  10.512  -1.294  1.00 43.23           C 
ATOM    647  O   VAL    41       6.977  11.286  -0.986  1.00 22.33           O 
ATOM    648  CB  VAL    41      10.189  10.386  -0.289  1.00 75.20           C 
ATOM    649  CG1 VAL    41      10.220  11.878   0.039  1.00 21.45           C 
ATOM    650  CG2 VAL    41      11.103   9.604   0.644  1.00 53.13           C 
ATOM    651  H   VAL    41       9.377   7.943  -0.958  1.00 36.29           H 
ATOM    652  HA  VAL    41       8.339  10.071   0.758  1.00 23.52           H 
ATOM    653  HB  VAL    41      10.554  10.257  -1.299  1.00 32.15           H 
ATOM    654 1HG1 VAL    41       9.805  12.038   1.024  1.00 36.29           H 
ATOM    655 2HG1 VAL    41       9.636  12.422  -0.690  1.00 36.29           H 
ATOM    656 3HG1 VAL    41      11.240  12.232   0.018  1.00 36.29           H 
ATOM    657 1HG2 VAL    41      11.114   8.563   0.353  1.00 36.29           H 
ATOM    658 2HG2 VAL    41      10.742   9.689   1.660  1.00 36.29           H 
ATOM    659 3HG2 VAL    41      12.105  10.003   0.587  1.00 36.29           H 
ATOM    660  N   GLN    42       8.182  10.219  -2.561  1.00  3.43           N 
ATOM    661  CA  GLN    42       7.421  10.776  -3.685  1.00 74.24           C 
ATOM    662  C   GLN    42       7.518   9.872  -4.929  1.00 64.11           C 
ATOM    663  O   GLN    42       8.488   9.130  -5.103  1.00 31.14           O 
ATOM    664  CB  GLN    42       7.899  12.213  -3.993  1.00  3.35           C 
ATOM    665  CG  GLN    42       9.315  12.327  -4.573  1.00 33.42           C 
ATOM    666  CD  GLN    42       9.342  12.283  -6.095  1.00 64.51           C 
ATOM    667  OE1 GLN    42       8.383  12.672  -6.753  1.00 10.20           O 
ATOM    668  NE2 GLN    42      10.442  11.846  -6.667  1.00 24.44           N 
ATOM    669  H   GLN    42       8.928   9.611  -2.747  1.00 36.29           H 
ATOM    670  HA  GLN    42       6.383  10.818  -3.383  1.00 54.33           H 
ATOM    671 3HB  GLN    42       7.866  12.785  -3.076  1.00 36.29           H 
ATOM    672 2HB  GLN    42       7.214  12.658  -4.699  1.00 36.29           H 
ATOM    673 3HG  GLN    42       9.912  11.509  -4.194  1.00 36.29           H 
ATOM    674 2HG  GLN    42       9.749  13.263  -4.251  1.00 36.29           H 
ATOM    675 1HE2 GLN    42      11.184  11.571  -6.094  1.00 36.29           H 
ATOM    676 2HE2 GLN    42      10.472  11.823  -7.648  1.00 36.29           H 
ATOM    677  N   VAL    43       6.501   9.937  -5.786  1.00 12.10           N 
ATOM    678  CA  VAL    43       6.417   9.079  -6.978  1.00 22.13           C 
ATOM    679  C   VAL    43       6.363   9.914  -8.265  1.00 21.24           C 
ATOM    680  O   VAL    43       5.746  10.981  -8.297  1.00 40.02           O 
ATOM    681  CB  VAL    43       5.156   8.173  -6.916  1.00 73.42           C 
ATOM    682  CG1 VAL    43       5.002   7.343  -8.195  1.00  5.04           C 
ATOM    683  CG2 VAL    43       5.200   7.273  -5.679  1.00 51.45           C 
ATOM    684  H   VAL    43       5.785  10.585  -5.620  1.00 36.29           H 
ATOM    685  HA  VAL    43       7.292   8.444  -7.006  1.00 12.31           H 
ATOM    686  HB  VAL    43       4.287   8.812  -6.832  1.00 13.50           H 
ATOM    687 1HG1 VAL    43       5.882   6.735  -8.342  1.00 36.29           H 
ATOM    688 2HG1 VAL    43       4.876   8.003  -9.042  1.00 36.29           H 
ATOM    689 3HG1 VAL    43       4.135   6.703  -8.110  1.00 36.29           H 
ATOM    690 1HG2 VAL    43       4.327   6.636  -5.661  1.00 36.29           H 
ATOM    691 2HG2 VAL    43       5.213   7.886  -4.789  1.00 36.29           H 
ATOM    692 3HG2 VAL    43       6.091   6.662  -5.706  1.00 36.29           H 
ATOM    693  N   ALA    44       7.014   9.428  -9.322  1.00 45.22           N 
ATOM    694  CA  ALA    44       6.922  10.066 -10.637  1.00 21.02           C 
ATOM    695  C   ALA    44       5.464  10.070 -11.132  1.00 53.33           C 
ATOM    696  O   ALA    44       4.819   9.021 -11.170  1.00 63.02           O 
ATOM    697  CB  ALA    44       7.823   9.351 -11.638  1.00 30.32           C 
ATOM    698  H   ALA    44       7.566   8.623  -9.217  1.00 36.29           H 
ATOM    699  HA  ALA    44       7.267  11.087 -10.537  1.00 12.11           H 
ATOM    700 1HB  ALA    44       8.840   9.355 -11.271  1.00 36.29           H 
ATOM    701 2HB  ALA    44       7.783   9.861 -12.590  1.00 36.29           H 
ATOM    702 3HB  ALA    44       7.489   8.331 -11.762  1.00 36.29           H 
ATOM    703  N   PRO    45       4.928  11.242 -11.526  1.00 61.12           N 
ATOM    704  CA  PRO    45       3.504  11.387 -11.901  1.00 65.23           C 
ATOM    705  C   PRO    45       3.058  10.429 -13.025  1.00 34.04           C 
ATOM    706  O   PRO    45       1.872  10.125 -13.156  1.00  5.14           O 
ATOM    707  CB  PRO    45       3.394  12.856 -12.354  1.00 52.21           C 
ATOM    708  CG  PRO    45       4.799  13.303 -12.595  1.00 51.52           C 
ATOM    709  CD  PRO    45       5.653  12.521 -11.640  1.00 21.40           C 
ATOM    710  HA  PRO    45       2.865  11.231 -11.043  1.00 60.22           H 
ATOM    711 3HB  PRO    45       2.925  13.438 -11.574  1.00 36.29           H 
ATOM    712 2HB  PRO    45       2.801  12.918 -13.256  1.00 36.29           H 
ATOM    713 3HG  PRO    45       4.886  14.363 -12.396  1.00 36.29           H 
ATOM    714 2HG  PRO    45       5.084  13.091 -13.616  1.00 36.29           H 
ATOM    715 3HD  PRO    45       5.710  13.018 -10.681  1.00 36.29           H 
ATOM    716 2HD  PRO    45       6.643  12.372 -12.050  1.00 36.29           H 
ATOM    717  N   LEU    46       4.012   9.949 -13.821  1.00 24.01           N 
ATOM    718  CA  LEU    46       3.708   9.037 -14.931  1.00 20.22           C 
ATOM    719  C   LEU    46       3.609   7.571 -14.463  1.00 62.34           C 
ATOM    720  O   LEU    46       3.128   6.709 -15.200  1.00  5.34           O 
ATOM    721  CB  LEU    46       4.764   9.166 -16.043  1.00 72.21           C 
ATOM    722  CG  LEU    46       4.808  10.523 -16.775  1.00 55.13           C 
ATOM    723  CD1 LEU    46       5.375  11.624 -15.881  1.00 50.34           C 
ATOM    724  CD2 LEU    46       5.611  10.409 -18.069  1.00 71.50           C 
ATOM    725  H   LEU    46       4.941  10.214 -13.661  1.00 36.29           H 
ATOM    726  HA  LEU    46       2.747   9.325 -15.336  1.00 23.32           H 
ATOM    727 3HB  LEU    46       4.573   8.395 -16.777  1.00 36.29           H 
ATOM    728 2HB  LEU    46       5.737   8.984 -15.607  1.00 36.29           H 
ATOM    729  HG  LEU    46       3.799  10.809 -17.038  1.00 33.23           H 
ATOM    730 1HD1 LEU    46       5.394  12.559 -16.424  1.00 36.29           H 
ATOM    731 2HD1 LEU    46       6.380  11.364 -15.578  1.00 36.29           H 
ATOM    732 3HD1 LEU    46       4.752  11.732 -15.005  1.00 36.29           H 
ATOM    733 1HD2 LEU    46       6.630  10.127 -17.842  1.00 36.29           H 
ATOM    734 2HD2 LEU    46       5.608  11.361 -18.583  1.00 36.29           H 
ATOM    735 3HD2 LEU    46       5.164   9.659 -18.704  1.00 36.29           H 
ATOM    736  N   GLY    47       4.064   7.296 -13.240  1.00 13.15           N 
ATOM    737  CA  GLY    47       3.998   5.941 -12.693  1.00 32.42           C 
ATOM    738  C   GLY    47       5.232   5.558 -11.879  1.00  3.32           C 
ATOM    739  O   GLY    47       5.126   5.220 -10.702  1.00 22.12           O 
ATOM    740  H   GLY    47       4.436   8.020 -12.697  1.00 36.29           H 
ATOM    741 3HA  GLY    47       3.890   5.239 -13.507  1.00 36.29           H 
ATOM    742 2HA  GLY    47       3.128   5.869 -12.057  1.00 36.29           H 
ATOM    743  N   ASP    48       6.401   5.592 -12.514  1.00 13.23           N 
ATOM    744  CA  ASP    48       7.667   5.279 -11.842  1.00 64.04           C 
ATOM    745  C   ASP    48       8.847   5.914 -12.615  1.00 61.24           C 
ATOM    746  O   ASP    48       8.654   6.395 -13.737  1.00 51.03           O 
ATOM    747  CB  ASP    48       7.820   3.754 -11.703  1.00 13.35           C 
ATOM    748  CG  ASP    48       8.158   3.054 -13.008  1.00  0.30           C 
ATOM    749  OD1 ASP    48       7.298   3.021 -13.911  1.00 41.50           O 
ATOM    750  OD2 ASP    48       9.275   2.505 -13.126  1.00 33.25           O 
ATOM    751  H   ASP    48       6.416   5.834 -13.464  1.00 36.29           H 
ATOM    752  HA  ASP    48       7.631   5.721 -10.852  1.00 40.21           H 
ATOM    753 3HB  ASP    48       6.890   3.349 -11.333  1.00 36.29           H 
ATOM    754 2HB  ASP    48       8.599   3.540 -10.988  1.00 36.29           H 
ATOM    755  N   PRO    49      10.088   5.935 -12.063  1.00 61.44           N 
ATOM    756  CA  PRO    49      10.463   5.282 -10.785  1.00 44.01           C 
ATOM    757  C   PRO    49       9.884   5.955  -9.525  1.00 75.40           C 
ATOM    758  O   PRO    49       9.372   7.076  -9.571  1.00 60.01           O 
ATOM    759  CB  PRO    49      11.994   5.387 -10.788  1.00  3.11           C 
ATOM    760  CG  PRO    49      12.279   6.611 -11.586  1.00 14.11           C 
ATOM    761  CD  PRO    49      11.239   6.634 -12.672  1.00 25.10           C 
ATOM    762  HA  PRO    49      10.185   4.239 -10.784  1.00 21.21           H 
ATOM    763 3HB  PRO    49      12.418   4.507 -11.251  1.00 36.29           H 
ATOM    764 2HB  PRO    49      12.361   5.478  -9.774  1.00 36.29           H 
ATOM    765 3HG  PRO    49      13.269   6.553 -12.014  1.00 36.29           H 
ATOM    766 2HG  PRO    49      12.191   7.489 -10.960  1.00 36.29           H 
ATOM    767 3HD  PRO    49      11.592   6.103 -13.547  1.00 36.29           H 
ATOM    768 2HD  PRO    49      10.981   7.652 -12.929  1.00 36.29           H 
ATOM    769  N   ILE    50       9.973   5.244  -8.399  1.00 53.23           N 
ATOM    770  CA  ILE    50       9.529   5.766  -7.102  1.00 62.13           C 
ATOM    771  C   ILE    50      10.734   6.058  -6.192  1.00  4.11           C 
ATOM    772  O   ILE    50      11.699   5.290  -6.156  1.00  2.10           O 
ATOM    773  CB  ILE    50       8.555   4.794  -6.364  1.00 22.25           C 
ATOM    774  CG1 ILE    50       9.205   3.418  -6.074  1.00 73.23           C 
ATOM    775  CG2 ILE    50       7.265   4.617  -7.163  1.00 33.53           C 
ATOM    776  CD1 ILE    50       9.099   2.411  -7.206  1.00 22.32           C 
ATOM    777  H   ILE    50      10.362   4.346  -8.438  1.00 36.29           H 
ATOM    778  HA  ILE    50       9.002   6.697  -7.282  1.00 12.14           H 
ATOM    779  HB  ILE    50       8.289   5.255  -5.421  1.00 55.52           H 
ATOM    780 3HG1 ILE    50       8.731   2.983  -5.204  1.00 36.29           H 
ATOM    781 2HG1 ILE    50      10.255   3.559  -5.864  1.00 36.29           H 
ATOM    782 1HG2 ILE    50       6.756   5.566  -7.239  1.00 36.29           H 
ATOM    783 2HG2 ILE    50       6.625   3.906  -6.663  1.00 36.29           H 
ATOM    784 3HG2 ILE    50       7.499   4.255  -8.155  1.00 36.29           H 
ATOM    785 1HD1 ILE    50       9.542   2.820  -8.101  1.00 36.29           H 
ATOM    786 2HD1 ILE    50       8.059   2.183  -7.391  1.00 36.29           H 
ATOM    787 3HD1 ILE    50       9.619   1.506  -6.930  1.00 36.29           H 
ATOM    788  N   VAL    51      10.682   7.174  -5.466  1.00 71.23           N 
ATOM    789  CA  VAL    51      11.762   7.545  -4.543  1.00 73.25           C 
ATOM    790  C   VAL    51      11.393   7.193  -3.096  1.00  4.52           C 
ATOM    791  O   VAL    51      10.426   7.720  -2.537  1.00 42.01           O 
ATOM    792  CB  VAL    51      12.102   9.054  -4.642  1.00  0.44           C 
ATOM    793  CG1 VAL    51      13.223   9.428  -3.670  1.00 61.10           C 
ATOM    794  CG2 VAL    51      12.486   9.422  -6.075  1.00 12.43           C 
ATOM    795  H   VAL    51       9.901   7.762  -5.548  1.00 36.29           H 
ATOM    796  HA  VAL    51      12.645   6.982  -4.822  1.00 23.14           H 
ATOM    797  HB  VAL    51      11.219   9.620  -4.372  1.00  3.15           H 
ATOM    798 1HG1 VAL    51      12.908   9.223  -2.658  1.00 36.29           H 
ATOM    799 2HG1 VAL    51      13.450  10.480  -3.768  1.00 36.29           H 
ATOM    800 3HG1 VAL    51      14.107   8.847  -3.896  1.00 36.29           H 
ATOM    801 1HG2 VAL    51      12.706  10.477  -6.130  1.00 36.29           H 
ATOM    802 2HG2 VAL    51      11.665   9.191  -6.739  1.00 36.29           H 
ATOM    803 3HG2 VAL    51      13.358   8.855  -6.374  1.00 36.29           H 
ATOM    804  N   CYS    52      12.177   6.304  -2.496  1.00 70.13           N 
ATOM    805  CA  CYS    52      11.915   5.816  -1.136  1.00  4.10           C 
ATOM    806  C   CYS    52      13.096   6.095  -0.198  1.00 50.25           C 
ATOM    807  O   CYS    52      14.147   6.562  -0.630  1.00 43.52           O 
ATOM    808  CB  CYS    52      11.640   4.312  -1.175  1.00 50.52           C 
ATOM    809  SG  CYS    52      12.998   3.330  -1.850  1.00 41.54           S 
ATOM    810  H   CYS    52      12.962   5.964  -2.978  1.00 36.29           H 
ATOM    811  HA  CYS    52      11.039   6.324  -0.755  1.00 31.21           H 
ATOM    812 3HB  CYS    52      10.768   4.126  -1.784  1.00 36.29           H 
ATOM    813 2HB  CYS    52      11.452   3.961  -0.169  1.00 36.29           H 
ATOM    814  HG  CYS    52      13.315   3.821  -3.042  1.00 52.01           H 
ATOM    815  N   LYS    53      12.911   5.811   1.090  1.00 72.54           N 
ATOM    816  CA  LYS    53      13.973   5.985   2.092  1.00 44.35           C 
ATOM    817  C   LYS    53      14.402   4.645   2.705  1.00 65.12           C 
ATOM    818  O   LYS    53      13.600   3.947   3.329  1.00 32.25           O 
ATOM    819  CB  LYS    53      13.507   6.929   3.210  1.00 52.32           C 
ATOM    820  CG  LYS    53      13.434   8.396   2.797  1.00 14.52           C 
ATOM    821  CD  LYS    53      12.721   9.250   3.847  1.00 75.52           C 
ATOM    822  CE  LYS    53      13.407   9.167   5.208  1.00 21.32           C 
ATOM    823  NZ  LYS    53      12.598   9.794   6.286  1.00 20.35           N 
ATOM    824  H   LYS    53      12.035   5.480   1.379  1.00 36.29           H 
ATOM    825  HA  LYS    53      14.828   6.428   1.599  1.00 12.25           H 
ATOM    826 3HB  LYS    53      14.192   6.849   4.043  1.00 36.29           H 
ATOM    827 2HB  LYS    53      12.524   6.620   3.537  1.00 36.29           H 
ATOM    828 3HG  LYS    53      12.898   8.470   1.863  1.00 36.29           H 
ATOM    829 2HG  LYS    53      14.439   8.773   2.665  1.00 36.29           H 
ATOM    830 3HD  LYS    53      11.700   8.903   3.945  1.00 36.29           H 
ATOM    831 2HD  LYS    53      12.719  10.279   3.516  1.00 36.29           H 
ATOM    832 3HE  LYS    53      14.361   9.671   5.148  1.00 36.29           H 
ATOM    833 2HE  LYS    53      13.569   8.127   5.454  1.00 36.29           H 
ATOM    834 1HZ  LYS    53      12.489  10.812   6.116  1.00 36.29           H 
ATOM    835 2HZ  LYS    53      13.065   9.656   7.207  1.00 36.29           H 
ATOM    836 3HZ  LYS    53      11.653   9.357   6.325  1.00 36.29           H 
ATOM    837  N   ILE    54      15.672   4.297   2.514  1.00 51.25           N 
ATOM    838  CA  ILE    54      16.270   3.111   3.134  1.00 23.41           C 
ATOM    839  C   ILE    54      17.572   3.492   3.847  1.00 53.31           C 
ATOM    840  O   ILE    54      18.478   4.059   3.236  1.00 31.01           O 
ATOM    841  CB  ILE    54      16.563   2.000   2.093  1.00 43.32           C 
ATOM    842  CG1 ILE    54      15.263   1.574   1.392  1.00  2.52           C 
ATOM    843  CG2 ILE    54      17.241   0.798   2.756  1.00 24.40           C 
ATOM    844  CD1 ILE    54      15.453   0.476   0.368  1.00 41.13           C 
ATOM    845  H   ILE    54      16.232   4.858   1.933  1.00 36.29           H 
ATOM    846  HA  ILE    54      15.572   2.721   3.864  1.00 73.43           H 
ATOM    847  HB  ILE    54      17.245   2.400   1.355  1.00 72.43           H 
ATOM    848 3HG1 ILE    54      14.840   2.430   0.885  1.00 36.29           H 
ATOM    849 2HG1 ILE    54      14.560   1.218   2.132  1.00 36.29           H 
ATOM    850 1HG2 ILE    54      18.154   1.118   3.239  1.00 36.29           H 
ATOM    851 2HG2 ILE    54      17.476   0.055   2.007  1.00 36.29           H 
ATOM    852 3HG2 ILE    54      16.578   0.367   3.493  1.00 36.29           H 
ATOM    853 1HD1 ILE    54      16.145   0.806  -0.391  1.00 36.29           H 
ATOM    854 2HD1 ILE    54      14.502   0.247  -0.089  1.00 36.29           H 
ATOM    855 3HD1 ILE    54      15.843  -0.408   0.852  1.00 36.29           H 
ATOM    856  N   GLY    55      17.662   3.191   5.137  1.00 43.33           N 
ATOM    857  CA  GLY    55      18.825   3.595   5.916  1.00  4.11           C 
ATOM    858  C   GLY    55      19.059   5.101   5.884  1.00 44.34           C 
ATOM    859  O   GLY    55      20.193   5.558   5.713  1.00 62.45           O 
ATOM    860  H   GLY    55      16.943   2.680   5.562  1.00 36.29           H 
ATOM    861 3HA  GLY    55      19.698   3.098   5.523  1.00 36.29           H 
ATOM    862 2HA  GLY    55      18.681   3.289   6.941  1.00 36.29           H 
ATOM    863  N   ASN    56      17.966   5.859   6.020  1.00 23.43           N 
ATOM    864  CA  ASN    56      17.985   7.332   6.019  1.00 24.01           C 
ATOM    865  C   ASN    56      18.160   7.926   4.601  1.00 44.12           C 
ATOM    866  O   ASN    56      17.672   9.022   4.322  1.00 43.12           O 
ATOM    867  CB  ASN    56      19.075   7.872   6.964  1.00  5.22           C 
ATOM    868  CG  ASN    56      18.955   9.369   7.204  1.00 31.32           C 
ATOM    869  OD1 ASN    56      19.509  10.179   6.468  1.00 62.00           O 
ATOM    870  ND2 ASN    56      18.236   9.752   8.240  1.00  4.13           N 
ATOM    871  H   ASN    56      17.103   5.407   6.132  1.00 36.29           H 
ATOM    872  HA  ASN    56      17.023   7.654   6.395  1.00 23.35           H 
ATOM    873 3HB  ASN    56      20.046   7.671   6.533  1.00 36.29           H 
ATOM    874 2HB  ASN    56      19.000   7.366   7.916  1.00 36.29           H 
ATOM    875 1HD2 ASN    56      17.820   9.061   8.797  1.00 36.29           H 
ATOM    876 2HD2 ASN    56      18.152  10.712   8.415  1.00 36.29           H 
ATOM    877  N   ARG    57      18.831   7.200   3.704  1.00  2.33           N 
ATOM    878  CA  ARG    57      19.129   7.721   2.360  1.00 43.52           C 
ATOM    879  C   ARG    57      17.997   7.417   1.360  1.00 52.21           C 
ATOM    880  O   ARG    57      17.310   6.399   1.466  1.00 63.30           O 
ATOM    881  CB  ARG    57      20.461   7.143   1.852  1.00 74.32           C 
ATOM    882  CG  ARG    57      20.467   5.624   1.703  1.00 64.12           C 
ATOM    883  CD  ARG    57      21.866   5.082   1.432  1.00 25.23           C 
ATOM    884  NE  ARG    57      21.877   3.625   1.305  1.00 41.34           N 
ATOM    885  CZ  ARG    57      21.857   2.794   2.312  1.00  0.11           C 
ATOM    886  NH1 ARG    57      21.805   3.224   3.536  1.00 43.11           N 
ATOM    887  NH2 ARG    57      21.892   1.524   2.089  1.00  4.44           N 
ATOM    888  H   ARG    57      19.122   6.295   3.940  1.00 36.29           H 
ATOM    889  HA  ARG    57      19.231   8.794   2.441  1.00 55.54           H 
ATOM    890 3HB  ARG    57      21.242   7.417   2.547  1.00 36.29           H 
ATOM    891 2HB  ARG    57      20.686   7.579   0.888  1.00 36.29           H 
ATOM    892 3HG  ARG    57      19.818   5.348   0.883  1.00 36.29           H 
ATOM    893 2HG  ARG    57      20.095   5.182   2.617  1.00 36.29           H 
ATOM    894 3HD  ARG    57      22.517   5.369   2.245  1.00 36.29           H 
ATOM    895 2HD  ARG    57      22.232   5.513   0.511  1.00 36.29           H 
ATOM    896  HE  ARG    57      21.916   3.251   0.399  1.00 43.20           H 
ATOM    897 1HH1 ARG    57      21.780   4.201   3.720  1.00 36.29           H 
ATOM    898 2HH1 ARG    57      21.789   2.571   4.291  1.00 36.29           H 
ATOM    899 1HH2 ARG    57      21.937   1.188   1.149  1.00 36.29           H 
ATOM    900 2HH2 ARG    57      21.876   0.883   2.852  1.00 36.29           H 
ATOM    901  N   ASN    58      17.806   8.314   0.392  1.00  2.41           N 
ATOM    902  CA  ASN    58      16.763   8.148  -0.629  1.00  2.41           C 
ATOM    903  C   ASN    58      17.240   7.279  -1.803  1.00  2.33           C 
ATOM    904  O   ASN    58      18.232   7.601  -2.464  1.00 63.11           O 
ATOM    905  CB  ASN    58      16.314   9.515  -1.150  1.00 41.10           C 
ATOM    906  CG  ASN    58      15.650  10.352  -0.075  1.00 13.22           C 
ATOM    907  OD1 ASN    58      16.304  11.093   0.645  1.00 44.15           O 
ATOM    908  ND2 ASN    58      14.343  10.240   0.041  1.00 24.54           N 
ATOM    909  H   ASN    58      18.373   9.114   0.368  1.00 36.29           H 
ATOM    910  HA  ASN    58      15.918   7.660  -0.161  1.00 24.10           H 
ATOM    911 3HB  ASN    58      15.611   9.375  -1.960  1.00 36.29           H 
ATOM    912 2HB  ASN    58      17.174  10.055  -1.521  1.00 36.29           H 
ATOM    913 1HD2 ASN    58      13.876   9.632  -0.565  1.00 36.29           H 
ATOM    914 2HD2 ASN    58      13.897  10.779   0.725  1.00 36.29           H 
ATOM    915  N   ILE    59      16.520   6.190  -2.068  1.00 34.32           N 
ATOM    916  CA  ILE    59      16.845   5.283  -3.179  1.00 73.51           C 
ATOM    917  C   ILE    59      15.782   5.354  -4.293  1.00 70.25           C 
ATOM    918  O   ILE    59      14.581   5.247  -4.028  1.00 22.13           O 
ATOM    919  CB  ILE    59      16.965   3.815  -2.690  1.00 23.45           C 
ATOM    920  CG1 ILE    59      18.032   3.695  -1.584  1.00 74.33           C 
ATOM    921  CG2 ILE    59      17.285   2.875  -3.856  1.00 15.02           C 
ATOM    922  CD1 ILE    59      19.432   4.079  -2.022  1.00 13.53           C 
ATOM    923  H   ILE    59      15.749   5.984  -1.499  1.00 36.29           H 
ATOM    924  HA  ILE    59      17.801   5.584  -3.588  1.00  1.30           H 
ATOM    925  HB  ILE    59      16.007   3.519  -2.283  1.00 64.41           H 
ATOM    926 3HG1 ILE    59      18.065   2.674  -1.232  1.00 36.29           H 
ATOM    927 2HG1 ILE    59      17.758   4.341  -0.763  1.00 36.29           H 
ATOM    928 1HG2 ILE    59      18.205   3.188  -4.332  1.00 36.29           H 
ATOM    929 2HG2 ILE    59      16.479   2.907  -4.577  1.00 36.29           H 
ATOM    930 3HG2 ILE    59      17.397   1.866  -3.488  1.00 36.29           H 
ATOM    931 1HD1 ILE    59      19.444   5.115  -2.326  1.00 36.29           H 
ATOM    932 2HD1 ILE    59      19.737   3.456  -2.851  1.00 36.29           H 
ATOM    933 3HD1 ILE    59      20.116   3.939  -1.198  1.00 36.29           H 
ATOM    934  N   THR    60      16.233   5.539  -5.535  1.00 43.10           N 
ATOM    935  CA  THR    60      15.336   5.545  -6.700  1.00 34.12           C 
ATOM    936  C   THR    60      15.132   4.123  -7.238  1.00 54.15           C 
ATOM    937  O   THR    60      16.057   3.511  -7.776  1.00 51.13           O 
ATOM    938  CB  THR    60      15.885   6.435  -7.843  1.00 74.34           C 
ATOM    939  OG1 THR    60      16.092   7.782  -7.384  1.00 72.30           O 
ATOM    940  CG2 THR    60      14.931   6.456  -9.033  1.00 65.10           C 
ATOM    941  H   THR    60      17.195   5.672  -5.675  1.00 36.29           H 
ATOM    942  HA  THR    60      14.381   5.945  -6.386  1.00 51.21           H 
ATOM    943  HB  THR    60      16.833   6.027  -8.171  1.00 73.51           H 
ATOM    944  HG1 THR    60      16.320   7.772  -6.444  1.00 72.44           H 
ATOM    945 1HG2 THR    60      14.822   5.455  -9.430  1.00 36.29           H 
ATOM    946 2HG2 THR    60      15.328   7.103  -9.801  1.00 36.29           H 
ATOM    947 3HG2 THR    60      13.967   6.826  -8.716  1.00 36.29           H 
ATOM    948  N   LEU    61      13.915   3.606  -7.108  1.00 63.14           N 
ATOM    949  CA  LEU    61      13.625   2.206  -7.443  1.00 44.53           C 
ATOM    950  C   LEU    61      12.578   2.113  -8.578  1.00 20.35           C 
ATOM    951  O   LEU    61      11.699   2.967  -8.695  1.00 64.34           O 
ATOM    952  CB  LEU    61      13.140   1.497  -6.161  1.00 44.33           C 
ATOM    953  CG  LEU    61      13.415  -0.016  -6.057  1.00 34.51           C 
ATOM    954  CD1 LEU    61      12.478  -0.813  -6.944  1.00 22.52           C 
ATOM    955  CD2 LEU    61      14.871  -0.328  -6.396  1.00 62.10           C 
ATOM    956  H   LEU    61      13.189   4.176  -6.775  1.00 36.29           H 
ATOM    957  HA  LEU    61      14.543   1.742  -7.778  1.00 54.23           H 
ATOM    958 3HB  LEU    61      12.072   1.651  -6.075  1.00 36.29           H 
ATOM    959 2HB  LEU    61      13.614   1.977  -5.314  1.00 36.29           H 
ATOM    960  HG  LEU    61      13.241  -0.331  -5.035  1.00 61.22           H 
ATOM    961 1HD1 LEU    61      12.664  -0.570  -7.980  1.00 36.29           H 
ATOM    962 2HD1 LEU    61      11.454  -0.571  -6.697  1.00 36.29           H 
ATOM    963 3HD1 LEU    61      12.644  -1.869  -6.787  1.00 36.29           H 
ATOM    964 1HD2 LEU    61      15.048  -1.387  -6.287  1.00 36.29           H 
ATOM    965 2HD2 LEU    61      15.523   0.215  -5.725  1.00 36.29           H 
ATOM    966 3HD2 LEU    61      15.078  -0.032  -7.415  1.00 36.29           H 
ATOM    967  N   ARG    62      12.687   1.084  -9.426  1.00  5.25           N 
ATOM    968  CA  ARG    62      11.758   0.904 -10.564  1.00  0.12           C 
ATOM    969  C   ARG    62      10.657  -0.116 -10.205  1.00 14.25           C 
ATOM    970  O   ARG    62      10.910  -1.052  -9.452  1.00 12.44           O 
ATOM    971  CB  ARG    62      12.532   0.418 -11.809  1.00 14.05           C 
ATOM    972  CG  ARG    62      13.974   0.922 -11.884  1.00  0.13           C 
ATOM    973  CD  ARG    62      14.068   2.445 -11.941  1.00 64.11           C 
ATOM    974  NE  ARG    62      15.370   2.916 -11.472  1.00 64.20           N 
ATOM    975  CZ  ARG    62      15.885   4.079 -11.755  1.00 11.14           C 
ATOM    976  NH1 ARG    62      15.305   4.866 -12.604  1.00 64.40           N 
ATOM    977  NH2 ARG    62      17.003   4.441 -11.208  1.00  5.21           N 
ATOM    978  H   ARG    62      13.403   0.422  -9.283  1.00 36.29           H 
ATOM    979  HA  ARG    62      11.298   1.859 -10.781  1.00 55.31           H 
ATOM    980 3HB  ARG    62      12.012   0.753 -12.697  1.00 36.29           H 
ATOM    981 2HB  ARG    62      12.555  -0.664 -11.808  1.00 36.29           H 
ATOM    982 3HG  ARG    62      14.442   0.507 -12.768  1.00 36.29           H 
ATOM    983 2HG  ARG    62      14.505   0.577 -11.007  1.00 36.29           H 
ATOM    984 3HD  ARG    62      13.295   2.869 -11.315  1.00 36.29           H 
ATOM    985 2HD  ARG    62      13.922   2.767 -12.962  1.00 36.29           H 
ATOM    986  HE  ARG    62      15.872   2.323 -10.873  1.00 11.33           H 
ATOM    987 1HH1 ARG    62      14.461   4.583 -13.052  1.00 36.29           H 
ATOM    988 2HH1 ARG    62      15.709   5.756 -12.810  1.00 36.29           H 
ATOM    989 1HH2 ARG    62      17.467   3.827 -10.572  1.00 36.29           H 
ATOM    990 2HH2 ARG    62      17.398   5.335 -11.418  1.00 36.29           H 
ATOM    991  N   LYS    63       9.444   0.040 -10.757  1.00 50.11           N 
ATOM    992  CA  LYS    63       8.329  -0.874 -10.418  1.00 15.24           C 
ATOM    993  C   LYS    63       8.701  -2.345 -10.655  1.00  2.52           C 
ATOM    994  O   LYS    63       8.415  -3.199  -9.816  1.00  5.44           O 
ATOM    995  CB  LYS    63       7.044  -0.544 -11.199  1.00 12.43           C 
ATOM    996  CG  LYS    63       6.342   0.734 -10.740  1.00 21.11           C 
ATOM    997  CD  LYS    63       4.849   0.729 -11.083  1.00 33.00           C 
ATOM    998  CE  LYS    63       4.593   0.579 -12.581  1.00 42.00           C 
ATOM    999  NZ  LYS    63       4.997   1.787 -13.349  1.00 30.20           N 
ATOM   1000  H   LYS    63       9.297   0.764 -11.402  1.00 36.29           H 
ATOM   1001  HA  LYS    63       8.127  -0.747  -9.363  1.00 14.34           H 
ATOM   1002 3HB  LYS    63       6.350  -1.367 -11.091  1.00 36.29           H 
ATOM   1003 2HB  LYS    63       7.292  -0.435 -12.246  1.00 36.29           H 
ATOM   1004 3HG  LYS    63       6.808   1.576 -11.224  1.00 36.29           H 
ATOM   1005 2HG  LYS    63       6.450   0.831  -9.669  1.00 36.29           H 
ATOM   1006 3HD  LYS    63       4.413   1.658 -10.746  1.00 36.29           H 
ATOM   1007 2HD  LYS    63       4.377  -0.094 -10.567  1.00 36.29           H 
ATOM   1008 3HE  LYS    63       3.537   0.405 -12.736  1.00 36.29           H 
ATOM   1009 2HE  LYS    63       5.150  -0.269 -12.949  1.00 36.29           H 
ATOM   1010 1HZ  LYS    63       5.989   2.028 -13.153  1.00 36.29           H 
ATOM   1011 2HZ  LYS    63       4.396   2.594 -13.092  1.00 36.29           H 
ATOM   1012 3HZ  LYS    63       4.895   1.610 -14.369  1.00 36.29           H 
ATOM   1013  N   ARG    64       9.357  -2.628 -11.783  1.00  1.34           N 
ATOM   1014  CA  ARG    64       9.785  -3.998 -12.110  1.00 73.25           C 
ATOM   1015  C   ARG    64      10.526  -4.656 -10.924  1.00 60.40           C 
ATOM   1016  O   ARG    64      10.294  -5.819 -10.597  1.00 45.22           O 
ATOM   1017  CB  ARG    64      10.710  -3.987 -13.337  1.00  4.23           C 
ATOM   1018  CG  ARG    64      12.009  -3.221 -13.102  1.00 64.14           C 
ATOM   1019  CD  ARG    64      13.114  -3.634 -14.063  1.00 24.41           C 
ATOM   1020  NE  ARG    64      14.441  -3.279 -13.558  1.00 43.52           N 
ATOM   1021  CZ  ARG    64      15.548  -3.868 -13.929  1.00 14.12           C 
ATOM   1022  NH1 ARG    64      15.524  -4.827 -14.799  1.00 23.40           N 
ATOM   1023  NH2 ARG    64      16.678  -3.515 -13.404  1.00 63.42           N 
ATOM   1024  H   ARG    64       9.545  -1.903 -12.419  1.00 36.29           H 
ATOM   1025  HA  ARG    64       8.901  -4.578 -12.339  1.00  4.42           H 
ATOM   1026 3HB  ARG    64      10.189  -3.529 -14.167  1.00 36.29           H 
ATOM   1027 2HB  ARG    64      10.956  -5.008 -13.598  1.00 36.29           H 
ATOM   1028 3HG  ARG    64      12.337  -3.408 -12.093  1.00 36.29           H 
ATOM   1029 2HG  ARG    64      11.819  -2.164 -13.222  1.00 36.29           H 
ATOM   1030 3HD  ARG    64      12.954  -3.136 -15.010  1.00 36.29           H 
ATOM   1031 2HD  ARG    64      13.069  -4.704 -14.209  1.00 36.29           H 
ATOM   1032  HE  ARG    64      14.499  -2.571 -12.887  1.00 41.34           H 
ATOM   1033 1HH1 ARG    64      14.658  -5.123 -15.190  1.00 36.29           H 
ATOM   1034 2HH1 ARG    64      16.374  -5.269 -15.073  1.00 36.29           H 
ATOM   1035 1HH2 ARG    64      16.702  -2.795 -12.705  1.00 36.29           H 
ATOM   1036 2HH2 ARG    64      17.520  -3.961 -13.693  1.00 36.29           H 
ATOM   1037  N   GLU    65      11.404  -3.880 -10.285  1.00 61.05           N 
ATOM   1038  CA  GLU    65      12.196  -4.349  -9.145  1.00 55.32           C 
ATOM   1039  C   GLU    65      11.343  -4.329  -7.870  1.00  3.51           C 
ATOM   1040  O   GLU    65      11.424  -5.222  -7.029  1.00 44.33           O 
ATOM   1041  CB  GLU    65      13.432  -3.442  -8.974  1.00  1.13           C 
ATOM   1042  CG  GLU    65      14.341  -3.388 -10.209  1.00 41.14           C 
ATOM   1043  CD  GLU    65      15.236  -2.153 -10.271  1.00 41.31           C 
ATOM   1044  OE1 GLU    65      16.203  -2.161 -11.068  1.00  4.52           O 
ATOM   1045  OE2 GLU    65      14.960  -1.162  -9.560  1.00 15.04           O 
ATOM   1046  H   GLU    65      11.512  -2.954 -10.578  1.00 36.29           H 
ATOM   1047  HA  GLU    65      12.518  -5.362  -9.343  1.00  5.33           H 
ATOM   1048 3HB  GLU    65      14.017  -3.802  -8.139  1.00 36.29           H 
ATOM   1049 2HB  GLU    65      13.096  -2.438  -8.757  1.00 36.29           H 
ATOM   1050 3HG  GLU    65      13.725  -3.403 -11.093  1.00 36.29           H 
ATOM   1051 2HG  GLU    65      14.972  -4.264 -10.208  1.00 36.29           H 
ATOM   1052  N   ALA    66      10.501  -3.306  -7.759  1.00 74.01           N 
ATOM   1053  CA  ALA    66       9.648  -3.105  -6.586  1.00 54.13           C 
ATOM   1054  C   ALA    66       8.618  -4.233  -6.402  1.00 62.01           C 
ATOM   1055  O   ALA    66       8.259  -4.570  -5.274  1.00 65.11           O 
ATOM   1056  CB  ALA    66       8.948  -1.759  -6.691  1.00 33.23           C 
ATOM   1057  H   ALA    66      10.452  -2.660  -8.493  1.00 36.29           H 
ATOM   1058  HA  ALA    66      10.289  -3.077  -5.714  1.00  4.22           H 
ATOM   1059 1HB  ALA    66       8.336  -1.741  -7.582  1.00 36.29           H 
ATOM   1060 2HB  ALA    66       9.685  -0.971  -6.747  1.00 36.29           H 
ATOM   1061 3HB  ALA    66       8.324  -1.606  -5.823  1.00 36.29           H 
ATOM   1062  N   ASP    67       8.148  -4.812  -7.509  1.00 12.11           N 
ATOM   1063  CA  ASP    67       7.185  -5.920  -7.452  1.00  0.15           C 
ATOM   1064  C   ASP    67       7.825  -7.206  -6.901  1.00  3.24           C 
ATOM   1065  O   ASP    67       7.137  -8.193  -6.647  1.00 33.51           O 
ATOM   1066  CB  ASP    67       6.581  -6.186  -8.836  1.00  4.12           C 
ATOM   1067  CG  ASP    67       5.732  -5.032  -9.343  1.00 11.24           C 
ATOM   1068  OD1 ASP    67       5.988  -4.550 -10.467  1.00 73.02           O 
ATOM   1069  OD2 ASP    67       4.789  -4.615  -8.630  1.00 34.24           O 
ATOM   1070  H   ASP    67       8.452  -4.485  -8.384  1.00 36.29           H 
ATOM   1071  HA  ASP    67       6.391  -5.623  -6.780  1.00 33.35           H 
ATOM   1072 3HB  ASP    67       5.960  -7.071  -8.786  1.00 36.29           H 
ATOM   1073 2HB  ASP    67       7.382  -6.358  -9.541  1.00 36.29           H 
ATOM   1074  N   LEU    68       9.144  -7.192  -6.731  1.00 24.35           N 
ATOM   1075  CA  LEU    68       9.874  -8.339  -6.185  1.00 61.32           C 
ATOM   1076  C   LEU    68      10.061  -8.228  -4.664  1.00  1.11           C 
ATOM   1077  O   LEU    68      10.298  -9.226  -3.985  1.00 74.44           O 
ATOM   1078  CB  LEU    68      11.237  -8.455  -6.881  1.00 72.30           C 
ATOM   1079  CG  LEU    68      11.162  -8.742  -8.387  1.00 74.11           C 
ATOM   1080  CD1 LEU    68      12.512  -8.513  -9.052  1.00 61.03           C 
ATOM   1081  CD2 LEU    68      10.673 -10.168  -8.626  1.00 22.12           C 
ATOM   1082  H   LEU    68       9.645  -6.389  -6.989  1.00 36.29           H 
ATOM   1083  HA  LEU    68       9.299  -9.232  -6.397  1.00 54.21           H 
ATOM   1084 3HB  LEU    68      11.796  -9.254  -6.412  1.00 36.29           H 
ATOM   1085 2HB  LEU    68      11.774  -7.529  -6.733  1.00 36.29           H 
ATOM   1086  HG  LEU    68      10.451  -8.066  -8.840  1.00 51.12           H 
ATOM   1087 1HD1 LEU    68      12.827  -7.491  -8.889  1.00 36.29           H 
ATOM   1088 2HD1 LEU    68      12.427  -8.695 -10.113  1.00 36.29           H 
ATOM   1089 3HD1 LEU    68      13.245  -9.185  -8.630  1.00 36.29           H 
ATOM   1090 1HD2 LEU    68       9.688 -10.288  -8.197  1.00 36.29           H 
ATOM   1091 2HD2 LEU    68      11.353 -10.868  -8.161  1.00 36.29           H 
ATOM   1092 3HD2 LEU    68      10.627 -10.361  -9.687  1.00 36.29           H 
ATOM   1093  N   ILE    69       9.953  -7.016  -4.126  1.00 32.41           N 
ATOM   1094  CA  ILE    69      10.132  -6.802  -2.685  1.00 63.31           C 
ATOM   1095  C   ILE    69       8.779  -6.750  -1.955  1.00 63.13           C 
ATOM   1096  O   ILE    69       8.015  -5.790  -2.086  1.00 64.30           O 
ATOM   1097  CB  ILE    69      10.945  -5.510  -2.371  1.00 24.51           C 
ATOM   1098  CG1 ILE    69      12.412  -5.639  -2.835  1.00 14.50           C 
ATOM   1099  CG2 ILE    69      10.899  -5.195  -0.876  1.00 21.25           C 
ATOM   1100  CD1 ILE    69      12.599  -5.655  -4.336  1.00  2.34           C 
ATOM   1101  H   ILE    69       9.739  -6.251  -4.703  1.00 36.29           H 
ATOM   1102  HA  ILE    69      10.693  -7.646  -2.300  1.00 72.51           H 
ATOM   1103  HB  ILE    69      10.482  -4.687  -2.898  1.00 43.31           H 
ATOM   1104 3HG1 ILE    69      12.827  -6.556  -2.440  1.00 36.29           H 
ATOM   1105 2HG1 ILE    69      12.979  -4.804  -2.449  1.00 36.29           H 
ATOM   1106 1HG2 ILE    69      11.498  -4.318  -0.674  1.00 36.29           H 
ATOM   1107 2HG2 ILE    69      11.290  -6.033  -0.317  1.00 36.29           H 
ATOM   1108 3HG2 ILE    69       9.878  -5.008  -0.578  1.00 36.29           H 
ATOM   1109 1HD1 ILE    69      12.101  -6.517  -4.753  1.00 36.29           H 
ATOM   1110 2HD1 ILE    69      13.653  -5.703  -4.566  1.00 36.29           H 
ATOM   1111 3HD1 ILE    69      12.179  -4.756  -4.762  1.00 36.29           H 
ATOM   1112  N   GLU    70       8.493  -7.803  -1.192  1.00 51.00           N 
ATOM   1113  CA  GLU    70       7.270  -7.889  -0.385  1.00 21.43           C 
ATOM   1114  C   GLU    70       7.465  -7.194   0.973  1.00  1.31           C 
ATOM   1115  O   GLU    70       8.252  -7.642   1.806  1.00  1.33           O 
ATOM   1116  CB  GLU    70       6.887  -9.371  -0.196  1.00 12.20           C 
ATOM   1117  CG  GLU    70       5.743  -9.638   0.787  1.00 34.43           C 
ATOM   1118  CD  GLU    70       4.419  -8.995   0.395  1.00 23.32           C 
ATOM   1119  OE1 GLU    70       3.749  -8.420   1.280  1.00 75.23           O 
ATOM   1120  OE2 GLU    70       4.032  -9.066  -0.790  1.00 11.32           O 
ATOM   1121  H   GLU    70       9.129  -8.550  -1.169  1.00 36.29           H 
ATOM   1122  HA  GLU    70       6.479  -7.388  -0.924  1.00 40.21           H 
ATOM   1123 3HB  GLU    70       7.760  -9.908   0.153  1.00 36.29           H 
ATOM   1124 2HB  GLU    70       6.597  -9.775  -1.156  1.00 36.29           H 
ATOM   1125 3HG  GLU    70       6.035  -9.264   1.760  1.00 36.29           H 
ATOM   1126 2HG  GLU    70       5.591 -10.705   0.853  1.00 36.29           H 
ATOM   1127  N   VAL    71       6.751  -6.087   1.181  1.00 21.13           N 
ATOM   1128  CA  VAL    71       6.847  -5.305   2.424  1.00  4.42           C 
ATOM   1129  C   VAL    71       5.549  -5.384   3.248  1.00 51.21           C 
ATOM   1130  O   VAL    71       4.533  -5.888   2.774  1.00 71.21           O 
ATOM   1131  CB  VAL    71       7.179  -3.817   2.132  1.00 72.43           C 
ATOM   1132  CG1 VAL    71       8.526  -3.696   1.429  1.00 43.24           C 
ATOM   1133  CG2 VAL    71       6.079  -3.153   1.303  1.00 63.42           C 
ATOM   1134  H   VAL    71       6.138  -5.787   0.480  1.00 36.29           H 
ATOM   1135  HA  VAL    71       7.655  -5.719   3.016  1.00 44.22           H 
ATOM   1136  HB  VAL    71       7.249  -3.296   3.078  1.00 15.34           H 
ATOM   1137 1HG1 VAL    71       8.475  -4.172   0.461  1.00 36.29           H 
ATOM   1138 2HG1 VAL    71       9.287  -4.178   2.027  1.00 36.29           H 
ATOM   1139 3HG1 VAL    71       8.776  -2.652   1.304  1.00 36.29           H 
ATOM   1140 1HG2 VAL    71       5.952  -3.688   0.372  1.00 36.29           H 
ATOM   1141 2HG2 VAL    71       6.351  -2.128   1.094  1.00 36.29           H 
ATOM   1142 3HG2 VAL    71       5.151  -3.169   1.855  1.00 36.29           H 
ATOM   1143  N   GLU    72       5.591  -4.909   4.494  1.00 13.21           N 
ATOM   1144  CA  GLU    72       4.400  -4.901   5.363  1.00 65.30           C 
ATOM   1145  C   GLU    72       4.184  -3.529   6.021  1.00 61.31           C 
ATOM   1146  O   GLU    72       5.122  -2.926   6.542  1.00 33.12           O 
ATOM   1147  CB  GLU    72       4.518  -5.986   6.443  1.00 42.04           C 
ATOM   1148  CG  GLU    72       5.703  -5.806   7.386  1.00 60.42           C 
ATOM   1149  CD  GLU    72       5.798  -6.915   8.420  1.00 64.32           C 
ATOM   1150  OE1 GLU    72       4.933  -6.973   9.319  1.00 14.44           O 
ATOM   1151  OE2 GLU    72       6.733  -7.738   8.334  1.00 13.42           O 
ATOM   1152  H   GLU    72       6.440  -4.563   4.844  1.00 36.29           H 
ATOM   1153  HA  GLU    72       3.541  -5.122   4.744  1.00 12.44           H 
ATOM   1154 3HB  GLU    72       4.616  -6.946   5.957  1.00 36.29           H 
ATOM   1155 2HB  GLU    72       3.613  -5.988   7.036  1.00 36.29           H 
ATOM   1156 3HG  GLU    72       5.599  -4.860   7.901  1.00 36.29           H 
ATOM   1157 2HG  GLU    72       6.613  -5.795   6.800  1.00 36.29           H 
ATOM   1158  N   VAL    73       2.943  -3.048   6.001  1.00 73.32           N 
ATOM   1159  CA  VAL    73       2.608  -1.733   6.556  1.00 54.30           C 
ATOM   1160  C   VAL    73       2.806  -1.678   8.083  1.00  2.11           C 
ATOM   1161  O   VAL    73       2.025  -2.247   8.849  1.00 23.41           O 
ATOM   1162  CB  VAL    73       1.148  -1.340   6.212  1.00 71.11           C 
ATOM   1163  CG1 VAL    73       0.792   0.029   6.795  1.00 61.40           C 
ATOM   1164  CG2 VAL    73       0.931  -1.360   4.699  1.00  2.40           C 
ATOM   1165  H   VAL    73       2.230  -3.593   5.602  1.00 36.29           H 
ATOM   1166  HA  VAL    73       3.266  -1.006   6.097  1.00 74.10           H 
ATOM   1167  HB  VAL    73       0.488  -2.074   6.654  1.00 30.21           H 
ATOM   1168 1HG1 VAL    73       1.472   0.775   6.409  1.00 36.29           H 
ATOM   1169 2HG1 VAL    73       0.870  -0.005   7.873  1.00 36.29           H 
ATOM   1170 3HG1 VAL    73      -0.221   0.288   6.517  1.00 36.29           H 
ATOM   1171 1HG2 VAL    73      -0.095  -1.102   4.478  1.00 36.29           H 
ATOM   1172 2HG2 VAL    73       1.143  -2.348   4.317  1.00 36.29           H 
ATOM   1173 3HG2 VAL    73       1.590  -0.644   4.228  1.00 36.29           H 
ATOM   1174  N   VAL    74       3.851  -0.968   8.515  1.00 21.41           N 
ATOM   1175  CA  VAL    74       4.168  -0.824   9.945  1.00 24.21           C 
ATOM   1176  C   VAL    74       3.105   0.028  10.673  1.00 65.34           C 
ATOM   1177  O   VAL    74       3.011   0.016  11.901  1.00 40.43           O 
ATOM   1178  CB  VAL    74       5.574  -0.184  10.142  1.00 31.32           C 
ATOM   1179  CG1 VAL    74       5.956  -0.116  11.621  1.00  5.25           C 
ATOM   1180  CG2 VAL    74       6.631  -0.953   9.348  1.00 53.13           C 
ATOM   1181  H   VAL    74       4.428  -0.528   7.853  1.00 36.29           H 
ATOM   1182  HA  VAL    74       4.180  -1.813  10.383  1.00 43.12           H 
ATOM   1183  HB  VAL    74       5.538   0.828   9.759  1.00 60.52           H 
ATOM   1184 1HG1 VAL    74       6.930   0.343  11.724  1.00 36.29           H 
ATOM   1185 2HG1 VAL    74       5.985  -1.114  12.034  1.00 36.29           H 
ATOM   1186 3HG1 VAL    74       5.225   0.471  12.157  1.00 36.29           H 
ATOM   1187 1HG2 VAL    74       6.384  -0.926   8.296  1.00 36.29           H 
ATOM   1188 2HG2 VAL    74       6.661  -1.979   9.684  1.00 36.29           H 
ATOM   1189 3HG2 VAL    74       7.601  -0.498   9.500  1.00 36.29           H 
END
