
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   75 ( 1197),  selected   75 , name 2h3j_A
# Molecule2: number of CA atoms   67 ( 1113),  selected   67 , name T0462_77_143.pdb
# PARAMETERS: 2h3j_A.T0462_77_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      E      77           -
LGA    S     2_A      L      78           -
LGA    A     3_A      P      79           -
LGA    L     4_A      L      80           -
LGA    Q     5_A      I      81           -
LGA    P     6_A      L      82           -
LGA    -       -      A      83           -
LGA    -       -      D      84           -
LGA    S     7_A      D      85          5.027
LGA    R     8_A      G      86          1.600
LGA    S     9_A      T      87          0.988
LGA    Y    10_A      Y      88          1.342
LGA    R    11_A      E      89          1.114
LGA    I    12_A      I      90          0.564
LGA    T    13_A      T      91          0.639
LGA    G    14_A      K      92          1.545
LGA    Y    15_A      L      93          1.089
LGA    S    16_A      N      94          2.391
LGA    P    17_A      -       -           -
LGA    A    18_A      -       -           -
LGA    I    19_A      G      95          0.626
LGA    S    20_A      G      96          2.309
LGA    N    21_A      R      97          5.077
LGA    G    22_A      R      98          2.865
LGA    Y    23_A      F      99          1.327
LGA    R    24_A      L     100          1.105
LGA    Q    25_A      F     101          1.805
LGA    R    26_A      R     102          2.225
LGA    L    27_A      M     103          1.556
LGA    F    28_A      K     104          1.189
LGA    S    29_A      N     105          1.986
LGA    M    30_A      L     106          1.923
LGA    G    31_A      G     107          2.014
LGA    L    32_A      I     108          1.684
LGA    L    33_A      E     109          1.002
LGA    P    34_A      S     110          1.605
LGA    G    35_A      G     111          0.753
LGA    A    36_A      K     112          0.386
LGA    A    37_A      K     113          1.257
LGA    L    38_A      I     114          1.139
LGA    R    39_A      Q     115          2.110
LGA    V    40_A      V     116          2.779
LGA    V    41_A      S     117          3.215
LGA    R    42_A      -       -           -
LGA    I    43_A      G     118          1.310
LGA    A    44_A      -       -           -
LGA    P    45_A      -       -           -
LGA    L    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    D    48_A      -       -           -
LGA    P    49_A      R     119          1.853
LGA    I    50_A      R     120          1.662
LGA    Q    51_A      Y     121          4.151
LGA    V    52_A      Y     122          2.980
LGA    E    53_A      -       -           -
LGA    T    54_A      I     123          3.271
LGA    R    55_A      E     124          3.069
LGA    Q    56_A      -       -           -
LGA    T    57_A      G     125          1.879
LGA    S    58_A      R     126          4.126
LGA    L    59_A      E     127          1.273
LGA    A    60_A      I     128          3.472
LGA    L    61_A      D     129          2.321
LGA    R    62_A      L     130          1.988
LGA    R    63_A      G     131          3.782
LGA    -       -      Y     132           -
LGA    K    64_A      G     133          2.774
LGA    D    65_A      E     134          2.944
LGA    L    66_A      A     135          2.105
LGA    A    67_A      T     136          3.137
LGA    L    68_A      K     137          3.264
LGA    L    69_A      I     138          1.696
LGA    T    70_A      W     139          1.285
LGA    L    71_A      V     140          1.235
LGA    V    72_A      R     141          1.279
LGA    P    73_A      R     142          1.418
LGA    L    74_A      V     143          1.672
LGA    D    75_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   75   67    5.0     58    2.30    12.07     65.235     2.417

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.814608 * X  +   0.061979 * Y  +   0.576691 * Z  + -13.884022
  Y_new =  -0.485158 * X  +   0.617699 * Y  +   0.618926 * Z  +  -0.066712
  Z_new =  -0.317861 * X  +  -0.783969 * Y  +   0.533252 * Z  +   1.823876 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.973486    2.168107  [ DEG:   -55.7766    124.2234 ]
  Theta =   0.323472    2.818120  [ DEG:    18.5336    161.4664 ]
  Phi   =  -0.537158    2.604435  [ DEG:   -30.7769    149.2231 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2h3j_A                                        
REMARK     2: T0462_77_143.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2h3j_A.T0462_77_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   75   67   5.0   58   2.30   12.07  65.235
REMARK  ---------------------------------------------------------- 
MOLECULE 2h3j_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   22-MAY-06   2H3J              
TITLE     SOLUTION NMR STRUCTURE OF PROTEIN PA4359 FROM PSEUDOMONAS             
TITLE    2 AERUGINOSA: NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
TITLE    3 TARGET PAT89                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA4359;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 GENE: PA4359;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    NESG, GFT NMR, STRUCTURAL GENOMICS, PAT89, STRUCTURAL                 
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST             
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM                                       
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    Q.ZHANG,G.LIU,A.YEE,C.ARROWSMITH,T.SZYPERSKI,NORTHEAST                
AUTHOR   2 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   20-JUN-06 2H3J    0                                                
JRNL        AUTH   Q.ZHANG,G.LIU,A.YEE,C.ARROWSMITH,T.SZYPERSKI                 
JRNL        TITL   SOLUTION STRUCTURE OF HYPOTHETICAL PROTEIN PA4359:           
JRNL        TITL 2 NORTHEST STRUCTURAL GENOMICS TARGET PAT89                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2H3J A    1    75  UNP    Q9HW42   Q9HW42_PSEAE     1     75             
SEQRES   1 A   75  MET SER ALA LEU GLN PRO SER ARG SER TYR ARG ILE THR          
SEQRES   2 A   75  GLY TYR SER PRO ALA ILE SER ASN GLY TYR ARG GLN ARG          
SEQRES   3 A   75  LEU PHE SER MET GLY LEU LEU PRO GLY ALA ALA LEU ARG          
SEQRES   4 A   75  VAL VAL ARG ILE ALA PRO LEU GLY ASP PRO ILE GLN VAL          
SEQRES   5 A   75  GLU THR ARG GLN THR SER LEU ALA LEU ARG ARG LYS ASP          
SEQRES   6 A   75  LEU ALA LEU LEU THR LEU VAL PRO LEU ASP                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1     -23.631 -18.506  -4.834  1.00  0.00           N  
ATOM      2  CA  MET A   1     -22.219 -18.563  -4.403  1.00  0.00           C  
ATOM      3  C   MET A   1     -22.083 -18.092  -2.963  1.00  0.00           C  
ATOM      4  O   MET A   1     -22.752 -17.148  -2.547  1.00  0.00           O  
ATOM      5  CB  MET A   1     -21.339 -17.698  -5.314  1.00  0.00           C  
ATOM      6  CG  MET A   1     -21.690 -16.216  -5.297  1.00  0.00           C  
ATOM      7  SD  MET A   1     -20.544 -15.209  -6.268  1.00  0.00           S  
ATOM      8  CE  MET A   1     -19.002 -15.524  -5.419  1.00  0.00           C  
ATOM      9  HA  MET A   1     -21.888 -19.589  -4.466  1.00  0.00           H  
ATOM     10  HB2 MET A   1     -20.311 -17.803  -4.999  1.00  0.00           H  
ATOM     11  HB3 MET A   1     -21.432 -18.055  -6.328  1.00  0.00           H  
ATOM     12  HG2 MET A   1     -22.688 -16.092  -5.696  1.00  0.00           H  
ATOM     13  HG3 MET A   1     -21.674 -15.871  -4.273  1.00  0.00           H  
ATOM     14  HE1 MET A   1     -18.202 -15.004  -5.926  1.00  0.00           H  
ATOM     15  HE2 MET A   1     -18.800 -16.584  -5.418  1.00  0.00           H  
ATOM     16  HE3 MET A   1     -19.071 -15.171  -4.401  1.00  0.00           H  
ATOM     17  N   SER A   2     -21.221 -18.746  -2.205  1.00  0.00           N  
ATOM     18  CA  SER A   2     -20.928 -18.328  -0.849  1.00  0.00           C  
ATOM     19  C   SER A   2     -19.462 -17.924  -0.768  1.00  0.00           C  
ATOM     20  O   SER A   2     -18.609 -18.722  -0.373  1.00  0.00           O  
ATOM     21  CB  SER A   2     -21.239 -19.461   0.129  1.00  0.00           C  
ATOM     22  OG  SER A   2     -22.504 -20.041  -0.157  1.00  0.00           O  
ATOM     23  H   SER A   2     -20.758 -19.538  -2.573  1.00  0.00           H  
ATOM     24  HA  SER A   2     -21.545 -17.472  -0.618  1.00  0.00           H  
ATOM     25  HB2 SER A   2     -20.478 -20.224   0.050  1.00  0.00           H  
ATOM     26  HB3 SER A   2     -21.255 -19.072   1.136  1.00  0.00           H  
ATOM     27  HG  SER A   2     -23.140 -19.782   0.523  1.00  0.00           H  
ATOM     28  N   ALA A   3     -19.179 -16.691  -1.198  1.00  0.00           N  
ATOM     29  CA  ALA A   3     -17.807 -16.207  -1.372  1.00  0.00           C  
ATOM     30  C   ALA A   3     -17.105 -16.991  -2.482  1.00  0.00           C  
ATOM     31  O   ALA A   3     -17.681 -17.913  -3.063  1.00  0.00           O  
ATOM     32  CB  ALA A   3     -17.015 -16.281  -0.067  1.00  0.00           C  
ATOM     33  H   ALA A   3     -19.920 -16.087  -1.407  1.00  0.00           H  
ATOM     34  HA  ALA A   3     -17.862 -15.169  -1.671  1.00  0.00           H  
ATOM     35  HB1 ALA A   3     -16.884 -17.316   0.213  1.00  0.00           H  
ATOM     36  HB2 ALA A   3     -17.557 -15.764   0.712  1.00  0.00           H  
ATOM     37  HB3 ALA A   3     -16.050 -15.818  -0.204  1.00  0.00           H  
ATOM     38  N   LEU A   4     -15.876 -16.619  -2.796  1.00  0.00           N  
ATOM     39  CA  LEU A   4     -15.126 -17.305  -3.835  1.00  0.00           C  
ATOM     40  C   LEU A   4     -13.645 -17.334  -3.493  1.00  0.00           C  
ATOM     41  O   LEU A   4     -12.937 -16.350  -3.696  1.00  0.00           O  
ATOM     42  CB  LEU A   4     -15.343 -16.629  -5.188  1.00  0.00           C  
ATOM     43  CG  LEU A   4     -14.623 -17.282  -6.369  1.00  0.00           C  
ATOM     44  CD1 LEU A   4     -15.137 -18.696  -6.593  1.00  0.00           C  
ATOM     45  CD2 LEU A   4     -14.796 -16.446  -7.627  1.00  0.00           C  
ATOM     46  H   LEU A   4     -15.460 -15.871  -2.321  1.00  0.00           H  
ATOM     47  HA  LEU A   4     -15.489 -18.320  -3.888  1.00  0.00           H  
ATOM     48  HB2 LEU A   4     -16.404 -16.626  -5.396  1.00  0.00           H  
ATOM     49  HB3 LEU A   4     -15.005 -15.607  -5.111  1.00  0.00           H  
ATOM     50  HG  LEU A   4     -13.568 -17.342  -6.149  1.00  0.00           H  
ATOM     51 HD11 LEU A   4     -14.605 -19.147  -7.416  1.00  0.00           H  
ATOM     52 HD12 LEU A   4     -16.191 -18.662  -6.822  1.00  0.00           H  
ATOM     53 HD13 LEU A   4     -14.982 -19.282  -5.698  1.00  0.00           H  
ATOM     54 HD21 LEU A   4     -15.846 -16.369  -7.866  1.00  0.00           H  
ATOM     55 HD22 LEU A   4     -14.273 -16.915  -8.448  1.00  0.00           H  
ATOM     56 HD23 LEU A   4     -14.393 -15.457  -7.462  1.00  0.00           H  
ATOM     57  N   GLN A   5     -13.206 -18.470  -2.954  1.00  0.00           N  
ATOM     58  CA  GLN A   5     -11.806 -18.684  -2.596  1.00  0.00           C  
ATOM     59  C   GLN A   5     -11.285 -17.562  -1.693  1.00  0.00           C  
ATOM     60  O   GLN A   5     -10.493 -16.723  -2.123  1.00  0.00           O  
ATOM     61  CB  GLN A   5     -10.941 -18.804  -3.857  1.00  0.00           C  
ATOM     62  CG  GLN A   5     -11.295 -20.001  -4.727  1.00  0.00           C  
ATOM     63  CD  GLN A   5     -10.563 -19.996  -6.056  1.00  0.00           C  
ATOM     64  OE1 GLN A   5      -9.450 -19.482  -6.171  1.00  0.00           O  
ATOM     65  NE2 GLN A   5     -11.177 -20.588  -7.068  1.00  0.00           N  
ATOM     66  H   GLN A   5     -13.853 -19.189  -2.782  1.00  0.00           H  
ATOM     67  HA  GLN A   5     -11.750 -19.616  -2.051  1.00  0.00           H  
ATOM     68  HB2 GLN A   5     -11.058 -17.910  -4.447  1.00  0.00           H  
ATOM     69  HB3 GLN A   5      -9.904 -18.897  -3.563  1.00  0.00           H  
ATOM     70  HG2 GLN A   5     -11.038 -20.907  -4.199  1.00  0.00           H  
ATOM     71  HG3 GLN A   5     -12.359 -19.988  -4.920  1.00  0.00           H  
ATOM     72 HE21 GLN A   5     -12.060 -20.998  -6.906  1.00  0.00           H  
ATOM     73 HE22 GLN A   5     -10.727 -20.594  -7.942  1.00  0.00           H  
ATOM     74  N   PRO A   6     -11.721 -17.533  -0.426  1.00  0.00           N  
ATOM     75  CA  PRO A   6     -11.327 -16.486   0.511  1.00  0.00           C  
ATOM     76  C   PRO A   6      -9.900 -16.672   1.012  1.00  0.00           C  
ATOM     77  O   PRO A   6      -9.580 -17.668   1.660  1.00  0.00           O  
ATOM     78  CB  PRO A   6     -12.317 -16.630   1.676  1.00  0.00           C  
ATOM     79  CG  PRO A   6     -13.285 -17.699   1.275  1.00  0.00           C  
ATOM     80  CD  PRO A   6     -12.615 -18.509   0.201  1.00  0.00           C  
ATOM     81  HA  PRO A   6     -11.426 -15.505   0.068  1.00  0.00           H  
ATOM     82  HB2 PRO A   6     -11.775 -16.905   2.566  1.00  0.00           H  
ATOM     83  HB3 PRO A   6     -12.820 -15.688   1.837  1.00  0.00           H  
ATOM     84  HG2 PRO A   6     -13.509 -18.326   2.126  1.00  0.00           H  
ATOM     85  HG3 PRO A   6     -14.190 -17.250   0.894  1.00  0.00           H  
ATOM     86  HD2 PRO A   6     -12.055 -19.326   0.634  1.00  0.00           H  
ATOM     87  HD3 PRO A   6     -13.341 -18.877  -0.507  1.00  0.00           H  
ATOM     88  N   SER A   7      -9.048 -15.713   0.704  1.00  0.00           N  
ATOM     89  CA  SER A   7      -7.660 -15.754   1.134  1.00  0.00           C  
ATOM     90  C   SER A   7      -7.499 -14.983   2.440  1.00  0.00           C  
ATOM     91  O   SER A   7      -6.910 -15.472   3.400  1.00  0.00           O  
ATOM     92  CB  SER A   7      -6.757 -15.170   0.041  1.00  0.00           C  
ATOM     93  OG  SER A   7      -5.387 -15.250   0.398  1.00  0.00           O  
ATOM     94  H   SER A   7      -9.361 -14.956   0.168  1.00  0.00           H  
ATOM     95  HA  SER A   7      -7.390 -16.788   1.301  1.00  0.00           H  
ATOM     96  HB2 SER A   7      -6.908 -15.721  -0.875  1.00  0.00           H  
ATOM     97  HB3 SER A   7      -7.012 -14.133  -0.116  1.00  0.00           H  
ATOM     98  HG  SER A   7      -5.293 -15.754   1.220  1.00  0.00           H  
ATOM     99  N   ARG A   8      -8.038 -13.775   2.468  1.00  0.00           N  
ATOM    100  CA  ARG A   8      -7.966 -12.917   3.638  1.00  0.00           C  
ATOM    101  C   ARG A   8      -9.230 -12.086   3.765  1.00  0.00           C  
ATOM    102  O   ARG A   8      -9.963 -11.896   2.793  1.00  0.00           O  
ATOM    103  CB  ARG A   8      -6.761 -11.980   3.540  1.00  0.00           C  
ATOM    104  CG  ARG A   8      -5.449 -12.588   4.005  1.00  0.00           C  
ATOM    105  CD  ARG A   8      -4.281 -11.669   3.684  1.00  0.00           C  
ATOM    106  NE  ARG A   8      -3.049 -12.072   4.356  1.00  0.00           N  
ATOM    107  CZ  ARG A   8      -1.847 -12.027   3.787  1.00  0.00           C  
ATOM    108  NH1 ARG A   8      -1.730 -11.745   2.495  1.00  0.00           N  
ATOM    109  NH2 ARG A   8      -0.761 -12.286   4.499  1.00  0.00           N  
ATOM    110  H   ARG A   8      -8.505 -13.445   1.674  1.00  0.00           H  
ATOM    111  HA  ARG A   8      -7.862 -13.542   4.510  1.00  0.00           H  
ATOM    112  HB2 ARG A   8      -6.642 -11.678   2.511  1.00  0.00           H  
ATOM    113  HB3 ARG A   8      -6.956 -11.102   4.140  1.00  0.00           H  
ATOM    114  HG2 ARG A   8      -5.491 -12.746   5.072  1.00  0.00           H  
ATOM    115  HG3 ARG A   8      -5.302 -13.534   3.504  1.00  0.00           H  
ATOM    116  HD2 ARG A   8      -4.115 -11.683   2.617  1.00  0.00           H  
ATOM    117  HD3 ARG A   8      -4.538 -10.666   3.993  1.00  0.00           H  
ATOM    118  HE  ARG A   8      -3.121 -12.353   5.303  1.00  0.00           H  
ATOM    119 HH11 ARG A   8      -2.544 -11.565   1.942  1.00  0.00           H  
ATOM    120 HH12 ARG A   8      -0.820 -11.712   2.068  1.00  0.00           H  
ATOM    121 HH21 ARG A   8      -0.838 -12.518   5.477  1.00  0.00           H  
ATOM    122 HH22 ARG A   8       0.146 -12.237   4.068  1.00  0.00           H  
ATOM    123  N   SER A   9      -9.477 -11.595   4.961  1.00  0.00           N  
ATOM    124  CA  SER A   9     -10.577 -10.680   5.194  1.00  0.00           C  
ATOM    125  C   SER A   9     -10.042  -9.366   5.750  1.00  0.00           C  
ATOM    126  O   SER A   9      -9.191  -9.353   6.645  1.00  0.00           O  
ATOM    127  CB  SER A   9     -11.603 -11.300   6.143  1.00  0.00           C  
ATOM    128  OG  SER A   9     -12.170 -12.471   5.580  1.00  0.00           O  
ATOM    129  H   SER A   9      -8.906 -11.855   5.712  1.00  0.00           H  
ATOM    130  HA  SER A   9     -11.049 -10.484   4.244  1.00  0.00           H  
ATOM    131  HB2 SER A   9     -11.119 -11.559   7.075  1.00  0.00           H  
ATOM    132  HB3 SER A   9     -12.394 -10.587   6.330  1.00  0.00           H  
ATOM    133  HG  SER A   9     -11.936 -13.238   6.124  1.00  0.00           H  
ATOM    134  N   TYR A  10     -10.523  -8.267   5.199  1.00  0.00           N  
ATOM    135  CA  TYR A  10     -10.064  -6.946   5.593  1.00  0.00           C  
ATOM    136  C   TYR A  10     -11.204  -6.184   6.257  1.00  0.00           C  
ATOM    137  O   TYR A  10     -12.303  -6.112   5.709  1.00  0.00           O  
ATOM    138  CB  TYR A  10      -9.573  -6.160   4.371  1.00  0.00           C  
ATOM    139  CG  TYR A  10      -8.446  -6.820   3.600  1.00  0.00           C  
ATOM    140  CD1 TYR A  10      -8.694  -7.858   2.705  1.00  0.00           C  
ATOM    141  CD2 TYR A  10      -7.133  -6.399   3.760  1.00  0.00           C  
ATOM    142  CE1 TYR A  10      -7.666  -8.451   1.995  1.00  0.00           C  
ATOM    143  CE2 TYR A  10      -6.100  -6.989   3.055  1.00  0.00           C  
ATOM    144  CZ  TYR A  10      -6.372  -8.014   2.174  1.00  0.00           C  
ATOM    145  OH  TYR A  10      -5.347  -8.598   1.463  1.00  0.00           O  
ATOM    146  H   TYR A  10     -11.226  -8.345   4.512  1.00  0.00           H  
ATOM    147  HA  TYR A  10      -9.251  -7.068   6.300  1.00  0.00           H  
ATOM    148  HB2 TYR A  10     -10.397  -6.024   3.689  1.00  0.00           H  
ATOM    149  HB3 TYR A  10      -9.223  -5.189   4.696  1.00  0.00           H  
ATOM    150  HD1 TYR A  10      -9.708  -8.198   2.566  1.00  0.00           H  
ATOM    151  HD2 TYR A  10      -6.920  -5.596   4.453  1.00  0.00           H  
ATOM    152  HE1 TYR A  10      -7.879  -9.255   1.306  1.00  0.00           H  
ATOM    153  HE2 TYR A  10      -5.085  -6.645   3.197  1.00  0.00           H  
ATOM    154  HH  TYR A  10      -4.554  -8.651   2.019  1.00  0.00           H  
ATOM    155  N   ARG A  11     -10.952  -5.629   7.429  1.00  0.00           N  
ATOM    156  CA  ARG A  11     -11.969  -4.858   8.130  1.00  0.00           C  
ATOM    157  C   ARG A  11     -11.863  -3.384   7.779  1.00  0.00           C  
ATOM    158  O   ARG A  11     -10.811  -2.907   7.360  1.00  0.00           O  
ATOM    159  CB  ARG A  11     -11.827  -5.001   9.644  1.00  0.00           C  
ATOM    160  CG  ARG A  11     -11.998  -6.415  10.161  1.00  0.00           C  
ATOM    161  CD  ARG A  11     -11.951  -6.434  11.677  1.00  0.00           C  
ATOM    162  NE  ARG A  11     -11.991  -7.787  12.218  1.00  0.00           N  
ATOM    163  CZ  ARG A  11     -11.394  -8.139  13.352  1.00  0.00           C  
ATOM    164  NH1 ARG A  11     -10.740  -7.233  14.071  1.00  0.00           N  
ATOM    165  NH2 ARG A  11     -11.457  -9.392  13.774  1.00  0.00           N  
ATOM    166  H   ARG A  11     -10.057  -5.722   7.828  1.00  0.00           H  
ATOM    167  HA  ARG A  11     -12.937  -5.226   7.828  1.00  0.00           H  
ATOM    168  HB2 ARG A  11     -10.847  -4.655   9.933  1.00  0.00           H  
ATOM    169  HB3 ARG A  11     -12.570  -4.375  10.118  1.00  0.00           H  
ATOM    170  HG2 ARG A  11     -12.953  -6.801   9.833  1.00  0.00           H  
ATOM    171  HG3 ARG A  11     -11.202  -7.033   9.776  1.00  0.00           H  
ATOM    172  HD2 ARG A  11     -11.039  -5.954  12.004  1.00  0.00           H  
ATOM    173  HD3 ARG A  11     -12.799  -5.883  12.054  1.00  0.00           H  
ATOM    174  HE  ARG A  11     -12.488  -8.470  11.704  1.00  0.00           H  
ATOM    175 HH11 ARG A  11     -10.695  -6.279  13.763  1.00  0.00           H  
ATOM    176 HH12 ARG A  11     -10.282  -7.503  14.929  1.00  0.00           H  
ATOM    177 HH21 ARG A  11     -11.954 -10.083  13.237  1.00  0.00           H  
ATOM    178 HH22 ARG A  11     -11.010  -9.661  14.633  1.00  0.00           H  
ATOM    179  N   ILE A  12     -12.951  -2.665   7.966  1.00  0.00           N  
ATOM    180  CA  ILE A  12     -12.948  -1.226   7.795  1.00  0.00           C  
ATOM    181  C   ILE A  12     -12.742  -0.571   9.151  1.00  0.00           C  
ATOM    182  O   ILE A  12     -13.654  -0.541   9.975  1.00  0.00           O  
ATOM    183  CB  ILE A  12     -14.270  -0.725   7.175  1.00  0.00           C  
ATOM    184  CG1 ILE A  12     -14.586  -1.499   5.890  1.00  0.00           C  
ATOM    185  CG2 ILE A  12     -14.188   0.767   6.891  1.00  0.00           C  
ATOM    186  CD1 ILE A  12     -15.912  -1.125   5.258  1.00  0.00           C  
ATOM    187  H   ILE A  12     -13.783  -3.117   8.240  1.00  0.00           H  
ATOM    188  HA  ILE A  12     -12.126  -0.960   7.140  1.00  0.00           H  
ATOM    189  HB  ILE A  12     -15.062  -0.889   7.891  1.00  0.00           H  
ATOM    190 HG12 ILE A  12     -13.810  -1.307   5.165  1.00  0.00           H  
ATOM    191 HG13 ILE A  12     -14.611  -2.554   6.113  1.00  0.00           H  
ATOM    192 HG21 ILE A  12     -15.127   1.106   6.480  1.00  0.00           H  
ATOM    193 HG22 ILE A  12     -13.397   0.952   6.180  1.00  0.00           H  
ATOM    194 HG23 ILE A  12     -13.981   1.298   7.808  1.00  0.00           H  
ATOM    195 HD11 ILE A  12     -16.068  -1.718   4.369  1.00  0.00           H  
ATOM    196 HD12 ILE A  12     -15.900  -0.077   4.993  1.00  0.00           H  
ATOM    197 HD13 ILE A  12     -16.711  -1.309   5.960  1.00  0.00           H  
ATOM    198  N   THR A  13     -11.543  -0.064   9.390  1.00  0.00           N  
ATOM    199  CA  THR A  13     -11.213   0.499  10.688  1.00  0.00           C  
ATOM    200  C   THR A  13     -11.726   1.932  10.792  1.00  0.00           C  
ATOM    201  O   THR A  13     -11.804   2.501  11.881  1.00  0.00           O  
ATOM    202  CB  THR A  13      -9.689   0.453  10.961  1.00  0.00           C  
ATOM    203  OG1 THR A  13      -9.437   0.544  12.370  1.00  0.00           O  
ATOM    204  CG2 THR A  13      -8.956   1.578  10.235  1.00  0.00           C  
ATOM    205  H   THR A  13     -10.866  -0.063   8.678  1.00  0.00           H  
ATOM    206  HA  THR A  13     -11.706  -0.102  11.439  1.00  0.00           H  
ATOM    207  HB  THR A  13      -9.306  -0.492  10.599  1.00  0.00           H  
ATOM    208  HG1 THR A  13      -8.767   1.230  12.538  1.00  0.00           H  
ATOM    209 HG21 THR A  13      -9.359   2.530  10.547  1.00  0.00           H  
ATOM    210 HG22 THR A  13      -9.084   1.463   9.167  1.00  0.00           H  
ATOM    211 HG23 THR A  13      -7.903   1.536  10.477  1.00  0.00           H  
ATOM    212  N   GLY A  14     -12.084   2.505   9.652  1.00  0.00           N  
ATOM    213  CA  GLY A  14     -12.598   3.852   9.631  1.00  0.00           C  
ATOM    214  C   GLY A  14     -12.444   4.494   8.277  1.00  0.00           C  
ATOM    215  O   GLY A  14     -12.206   3.808   7.283  1.00  0.00           O  
ATOM    216  H   GLY A  14     -11.987   2.008   8.811  1.00  0.00           H  
ATOM    217  HA2 GLY A  14     -13.646   3.834   9.895  1.00  0.00           H  
ATOM    218  HA3 GLY A  14     -12.064   4.444  10.360  1.00  0.00           H  
ATOM    219  N   TYR A  15     -12.569   5.804   8.238  1.00  0.00           N  
ATOM    220  CA  TYR A  15     -12.445   6.544   6.997  1.00  0.00           C  
ATOM    221  C   TYR A  15     -11.040   7.112   6.870  1.00  0.00           C  
ATOM    222  O   TYR A  15     -10.364   7.344   7.875  1.00  0.00           O  
ATOM    223  CB  TYR A  15     -13.480   7.670   6.943  1.00  0.00           C  
ATOM    224  CG  TYR A  15     -14.902   7.191   7.155  1.00  0.00           C  
ATOM    225  CD1 TYR A  15     -15.671   6.745   6.089  1.00  0.00           C  
ATOM    226  CD2 TYR A  15     -15.471   7.177   8.423  1.00  0.00           C  
ATOM    227  CE1 TYR A  15     -16.965   6.299   6.279  1.00  0.00           C  
ATOM    228  CE2 TYR A  15     -16.764   6.729   8.619  1.00  0.00           C  
ATOM    229  CZ  TYR A  15     -17.505   6.291   7.544  1.00  0.00           C  
ATOM    230  OH  TYR A  15     -18.791   5.844   7.735  1.00  0.00           O  
ATOM    231  H   TYR A  15     -12.746   6.292   9.073  1.00  0.00           H  
ATOM    232  HA  TYR A  15     -12.622   5.859   6.182  1.00  0.00           H  
ATOM    233  HB2 TYR A  15     -13.250   8.396   7.709  1.00  0.00           H  
ATOM    234  HB3 TYR A  15     -13.428   8.147   5.975  1.00  0.00           H  
ATOM    235  HD1 TYR A  15     -15.245   6.752   5.096  1.00  0.00           H  
ATOM    236  HD2 TYR A  15     -14.888   7.522   9.267  1.00  0.00           H  
ATOM    237  HE1 TYR A  15     -17.545   5.955   5.436  1.00  0.00           H  
ATOM    238  HE2 TYR A  15     -17.188   6.725   9.615  1.00  0.00           H  
ATOM    239  HH  TYR A  15     -18.977   5.125   7.111  1.00  0.00           H  
ATOM    240  N   SER A  16     -10.599   7.321   5.643  1.00  0.00           N  
ATOM    241  CA  SER A  16      -9.277   7.850   5.381  1.00  0.00           C  
ATOM    242  C   SER A  16      -9.217   9.344   5.697  1.00  0.00           C  
ATOM    243  O   SER A  16     -10.251  10.001   5.810  1.00  0.00           O  
ATOM    244  CB  SER A  16      -8.931   7.610   3.917  1.00  0.00           C  
ATOM    245  OG  SER A  16      -9.837   8.289   3.068  1.00  0.00           O  
ATOM    246  H   SER A  16     -11.181   7.112   4.879  1.00  0.00           H  
ATOM    247  HA  SER A  16      -8.570   7.325   6.005  1.00  0.00           H  
ATOM    248  HB2 SER A  16      -7.940   7.969   3.725  1.00  0.00           H  
ATOM    249  HB3 SER A  16      -8.980   6.552   3.703  1.00  0.00           H  
ATOM    250  HG  SER A  16      -9.702   8.001   2.154  1.00  0.00           H  
ATOM    251  N   PRO A  17      -8.010   9.902   5.860  1.00  0.00           N  
ATOM    252  CA  PRO A  17      -7.826  11.342   6.052  1.00  0.00           C  
ATOM    253  C   PRO A  17      -8.096  12.132   4.772  1.00  0.00           C  
ATOM    254  O   PRO A  17      -8.226  13.357   4.796  1.00  0.00           O  
ATOM    255  CB  PRO A  17      -6.349  11.479   6.460  1.00  0.00           C  
ATOM    256  CG  PRO A  17      -5.882  10.091   6.753  1.00  0.00           C  
ATOM    257  CD  PRO A  17      -6.731   9.181   5.916  1.00  0.00           C  
ATOM    258  HA  PRO A  17      -8.457  11.717   6.845  1.00  0.00           H  
ATOM    259  HB2 PRO A  17      -5.790  11.920   5.646  1.00  0.00           H  
ATOM    260  HB3 PRO A  17      -6.274  12.110   7.333  1.00  0.00           H  
ATOM    261  HG2 PRO A  17      -4.840   9.987   6.482  1.00  0.00           H  
ATOM    262  HG3 PRO A  17      -6.021   9.871   7.801  1.00  0.00           H  
ATOM    263  HD2 PRO A  17      -6.306   9.063   4.930  1.00  0.00           H  
ATOM    264  HD3 PRO A  17      -6.849   8.222   6.398  1.00  0.00           H  
ATOM    265  N   ALA A  18      -8.189  11.421   3.654  1.00  0.00           N  
ATOM    266  CA  ALA A  18      -8.404  12.053   2.358  1.00  0.00           C  
ATOM    267  C   ALA A  18      -9.889  12.215   2.048  1.00  0.00           C  
ATOM    268  O   ALA A  18     -10.256  12.749   1.000  1.00  0.00           O  
ATOM    269  CB  ALA A  18      -7.727  11.250   1.261  1.00  0.00           C  
ATOM    270  H   ALA A  18      -8.106  10.444   3.702  1.00  0.00           H  
ATOM    271  HA  ALA A  18      -7.947  13.031   2.387  1.00  0.00           H  
ATOM    272  HB1 ALA A  18      -8.210  10.290   1.169  1.00  0.00           H  
ATOM    273  HB2 ALA A  18      -6.686  11.109   1.511  1.00  0.00           H  
ATOM    274  HB3 ALA A  18      -7.805  11.785   0.327  1.00  0.00           H  
ATOM    275  N   ILE A  19     -10.739  11.755   2.958  1.00  0.00           N  
ATOM    276  CA  ILE A  19     -12.178  11.864   2.772  1.00  0.00           C  
ATOM    277  C   ILE A  19     -12.597  13.336   2.780  1.00  0.00           C  
ATOM    278  O   ILE A  19     -12.284  14.080   3.711  1.00  0.00           O  
ATOM    279  CB  ILE A  19     -12.952  11.060   3.845  1.00  0.00           C  
ATOM    280  CG1 ILE A  19     -14.442  11.019   3.514  1.00  0.00           C  
ATOM    281  CG2 ILE A  19     -12.731  11.637   5.240  1.00  0.00           C  
ATOM    282  CD1 ILE A  19     -15.233  10.119   4.437  1.00  0.00           C  
ATOM    283  H   ILE A  19     -10.391  11.341   3.776  1.00  0.00           H  
ATOM    284  HA  ILE A  19     -12.414  11.445   1.802  1.00  0.00           H  
ATOM    285  HB  ILE A  19     -12.568  10.049   3.845  1.00  0.00           H  
ATOM    286 HG12 ILE A  19     -14.851  12.014   3.591  1.00  0.00           H  
ATOM    287 HG13 ILE A  19     -14.567  10.656   2.504  1.00  0.00           H  
ATOM    288 HG21 ILE A  19     -11.687  11.552   5.503  1.00  0.00           H  
ATOM    289 HG22 ILE A  19     -13.329  11.091   5.955  1.00  0.00           H  
ATOM    290 HG23 ILE A  19     -13.021  12.677   5.248  1.00  0.00           H  
ATOM    291 HD11 ILE A  19     -14.858   9.110   4.365  1.00  0.00           H  
ATOM    292 HD12 ILE A  19     -16.273  10.138   4.151  1.00  0.00           H  
ATOM    293 HD13 ILE A  19     -15.134  10.471   5.454  1.00  0.00           H  
ATOM    294  N   SER A  20     -13.278  13.763   1.727  1.00  0.00           N  
ATOM    295  CA  SER A  20     -13.587  15.177   1.560  1.00  0.00           C  
ATOM    296  C   SER A  20     -15.010  15.392   1.049  1.00  0.00           C  
ATOM    297  O   SER A  20     -15.632  14.473   0.515  1.00  0.00           O  
ATOM    298  CB  SER A  20     -12.589  15.808   0.581  1.00  0.00           C  
ATOM    299  OG  SER A  20     -11.255  15.477   0.935  1.00  0.00           O  
ATOM    300  H   SER A  20     -13.581  13.120   1.053  1.00  0.00           H  
ATOM    301  HA  SER A  20     -13.485  15.656   2.520  1.00  0.00           H  
ATOM    302  HB2 SER A  20     -12.785  15.446  -0.417  1.00  0.00           H  
ATOM    303  HB3 SER A  20     -12.700  16.882   0.603  1.00  0.00           H  
ATOM    304  HG  SER A  20     -11.140  14.519   0.903  1.00  0.00           H  
ATOM    305  N   ASN A  21     -15.524  16.603   1.269  1.00  0.00           N  
ATOM    306  CA  ASN A  21     -16.766  17.080   0.648  1.00  0.00           C  
ATOM    307  C   ASN A  21     -17.978  16.218   1.013  1.00  0.00           C  
ATOM    308  O   ASN A  21     -18.830  15.932   0.167  1.00  0.00           O  
ATOM    309  CB  ASN A  21     -16.595  17.151  -0.881  1.00  0.00           C  
ATOM    310  CG  ASN A  21     -17.671  17.990  -1.552  1.00  0.00           C  
ATOM    311  OD1 ASN A  21     -18.193  18.937  -0.963  1.00  0.00           O  
ATOM    312  ND2 ASN A  21     -18.004  17.656  -2.787  1.00  0.00           N  
ATOM    313  H   ASN A  21     -15.054  17.201   1.887  1.00  0.00           H  
ATOM    314  HA  ASN A  21     -16.943  18.079   1.014  1.00  0.00           H  
ATOM    315  HB2 ASN A  21     -15.636  17.586  -1.110  1.00  0.00           H  
ATOM    316  HB3 ASN A  21     -16.638  16.149  -1.287  1.00  0.00           H  
ATOM    317 HD21 ASN A  21     -17.541  16.887  -3.205  1.00  0.00           H  
ATOM    318 HD22 ASN A  21     -18.696  18.182  -3.240  1.00  0.00           H  
ATOM    319  N   GLY A  22     -18.066  15.810   2.276  1.00  0.00           N  
ATOM    320  CA  GLY A  22     -19.235  15.083   2.739  1.00  0.00           C  
ATOM    321  C   GLY A  22     -19.325  13.683   2.170  1.00  0.00           C  
ATOM    322  O   GLY A  22     -20.404  13.090   2.139  1.00  0.00           O  
ATOM    323  H   GLY A  22     -17.330  16.006   2.904  1.00  0.00           H  
ATOM    324  HA2 GLY A  22     -19.209  15.016   3.815  1.00  0.00           H  
ATOM    325  HA3 GLY A  22     -20.118  15.634   2.448  1.00  0.00           H  
ATOM    326  N   TYR A  23     -18.192  13.142   1.733  1.00  0.00           N  
ATOM    327  CA  TYR A  23     -18.160  11.800   1.170  1.00  0.00           C  
ATOM    328  C   TYR A  23     -18.500  10.750   2.222  1.00  0.00           C  
ATOM    329  O   TYR A  23     -18.953   9.661   1.883  1.00  0.00           O  
ATOM    330  CB  TYR A  23     -16.802  11.503   0.542  1.00  0.00           C  
ATOM    331  CG  TYR A  23     -16.811  11.582  -0.970  1.00  0.00           C  
ATOM    332  CD1 TYR A  23     -17.661  10.775  -1.716  1.00  0.00           C  
ATOM    333  CD2 TYR A  23     -15.971  12.454  -1.651  1.00  0.00           C  
ATOM    334  CE1 TYR A  23     -17.671  10.833  -3.097  1.00  0.00           C  
ATOM    335  CE2 TYR A  23     -15.978  12.520  -3.031  1.00  0.00           C  
ATOM    336  CZ  TYR A  23     -16.828  11.707  -3.749  1.00  0.00           C  
ATOM    337  OH  TYR A  23     -16.830  11.766  -5.125  1.00  0.00           O  
ATOM    338  H   TYR A  23     -17.362  13.664   1.769  1.00  0.00           H  
ATOM    339  HA  TYR A  23     -18.915  11.758   0.396  1.00  0.00           H  
ATOM    340  HB2 TYR A  23     -16.082  12.218   0.907  1.00  0.00           H  
ATOM    341  HB3 TYR A  23     -16.493  10.510   0.825  1.00  0.00           H  
ATOM    342  HD1 TYR A  23     -18.319  10.090  -1.204  1.00  0.00           H  
ATOM    343  HD2 TYR A  23     -15.302  13.089  -1.086  1.00  0.00           H  
ATOM    344  HE1 TYR A  23     -18.340  10.199  -3.658  1.00  0.00           H  
ATOM    345  HE2 TYR A  23     -15.318  13.206  -3.542  1.00  0.00           H  
ATOM    346  HH  TYR A  23     -17.742  11.721  -5.443  1.00  0.00           H  
ATOM    347  N   ARG A  24     -18.302  11.084   3.495  1.00  0.00           N  
ATOM    348  CA  ARG A  24     -18.659  10.177   4.578  1.00  0.00           C  
ATOM    349  C   ARG A  24     -20.146   9.873   4.516  1.00  0.00           C  
ATOM    350  O   ARG A  24     -20.582   8.755   4.784  1.00  0.00           O  
ATOM    351  CB  ARG A  24     -18.330  10.786   5.942  1.00  0.00           C  
ATOM    352  CG  ARG A  24     -18.319   9.753   7.057  1.00  0.00           C  
ATOM    353  CD  ARG A  24     -18.821  10.315   8.378  1.00  0.00           C  
ATOM    354  NE  ARG A  24     -18.108  11.522   8.791  1.00  0.00           N  
ATOM    355  CZ  ARG A  24     -17.335  11.598   9.873  1.00  0.00           C  
ATOM    356  NH1 ARG A  24     -17.118  10.516  10.613  1.00  0.00           N  
ATOM    357  NH2 ARG A  24     -16.781  12.753  10.218  1.00  0.00           N  
ATOM    358  H   ARG A  24     -17.906  11.954   3.708  1.00  0.00           H  
ATOM    359  HA  ARG A  24     -18.105   9.259   4.448  1.00  0.00           H  
ATOM    360  HB2 ARG A  24     -17.357  11.249   5.894  1.00  0.00           H  
ATOM    361  HB3 ARG A  24     -19.069  11.536   6.181  1.00  0.00           H  
ATOM    362  HG2 ARG A  24     -18.951   8.928   6.768  1.00  0.00           H  
ATOM    363  HG3 ARG A  24     -17.306   9.400   7.190  1.00  0.00           H  
ATOM    364  HD2 ARG A  24     -19.871  10.549   8.279  1.00  0.00           H  
ATOM    365  HD3 ARG A  24     -18.696   9.559   9.140  1.00  0.00           H  
ATOM    366  HE  ARG A  24     -18.247  12.336   8.246  1.00  0.00           H  
ATOM    367 HH11 ARG A  24     -17.535   9.643  10.362  1.00  0.00           H  
ATOM    368 HH12 ARG A  24     -16.530  10.570  11.433  1.00  0.00           H  
ATOM    369 HH21 ARG A  24     -16.943  13.581   9.665  1.00  0.00           H  
ATOM    370 HH22 ARG A  24     -16.201  12.815  11.044  1.00  0.00           H  
ATOM    371  N   GLN A  25     -20.913  10.885   4.139  1.00  0.00           N  
ATOM    372  CA  GLN A  25     -22.348  10.768   4.018  1.00  0.00           C  
ATOM    373  C   GLN A  25     -22.720   9.873   2.846  1.00  0.00           C  
ATOM    374  O   GLN A  25     -23.676   9.104   2.921  1.00  0.00           O  
ATOM    375  CB  GLN A  25     -22.944  12.161   3.855  1.00  0.00           C  
ATOM    376  CG  GLN A  25     -22.848  13.007   5.116  1.00  0.00           C  
ATOM    377  CD  GLN A  25     -23.197  14.465   4.876  1.00  0.00           C  
ATOM    378  OE1 GLN A  25     -23.727  15.143   5.759  1.00  0.00           O  
ATOM    379  NE2 GLN A  25     -22.888  14.962   3.689  1.00  0.00           N  
ATOM    380  H   GLN A  25     -20.496  11.745   3.927  1.00  0.00           H  
ATOM    381  HA  GLN A  25     -22.724  10.326   4.923  1.00  0.00           H  
ATOM    382  HB2 GLN A  25     -22.417  12.671   3.064  1.00  0.00           H  
ATOM    383  HB3 GLN A  25     -23.974  12.071   3.584  1.00  0.00           H  
ATOM    384  HG2 GLN A  25     -23.530  12.609   5.853  1.00  0.00           H  
ATOM    385  HG3 GLN A  25     -21.838  12.951   5.499  1.00  0.00           H  
ATOM    386 HE21 GLN A  25     -22.457  14.372   3.036  1.00  0.00           H  
ATOM    387 HE22 GLN A  25     -23.098  15.910   3.512  1.00  0.00           H  
ATOM    388  N   ARG A  26     -21.945   9.959   1.772  1.00  0.00           N  
ATOM    389  CA  ARG A  26     -22.147   9.097   0.617  1.00  0.00           C  
ATOM    390  C   ARG A  26     -21.827   7.656   0.992  1.00  0.00           C  
ATOM    391  O   ARG A  26     -22.554   6.731   0.637  1.00  0.00           O  
ATOM    392  CB  ARG A  26     -21.255   9.542  -0.547  1.00  0.00           C  
ATOM    393  CG  ARG A  26     -21.490   8.764  -1.835  1.00  0.00           C  
ATOM    394  CD  ARG A  26     -22.845   9.091  -2.450  1.00  0.00           C  
ATOM    395  NE  ARG A  26     -22.912  10.480  -2.907  1.00  0.00           N  
ATOM    396  CZ  ARG A  26     -23.992  11.049  -3.443  1.00  0.00           C  
ATOM    397  NH1 ARG A  26     -25.123  10.368  -3.573  1.00  0.00           N  
ATOM    398  NH2 ARG A  26     -23.934  12.310  -3.850  1.00  0.00           N  
ATOM    399  H   ARG A  26     -21.213  10.614   1.760  1.00  0.00           H  
ATOM    400  HA  ARG A  26     -23.183   9.165   0.323  1.00  0.00           H  
ATOM    401  HB2 ARG A  26     -21.435  10.585  -0.743  1.00  0.00           H  
ATOM    402  HB3 ARG A  26     -20.220   9.414  -0.260  1.00  0.00           H  
ATOM    403  HG2 ARG A  26     -20.715   9.015  -2.543  1.00  0.00           H  
ATOM    404  HG3 ARG A  26     -21.450   7.707  -1.618  1.00  0.00           H  
ATOM    405  HD2 ARG A  26     -23.012   8.437  -3.294  1.00  0.00           H  
ATOM    406  HD3 ARG A  26     -23.613   8.927  -1.707  1.00  0.00           H  
ATOM    407  HE  ARG A  26     -22.092  11.018  -2.822  1.00  0.00           H  
ATOM    408 HH11 ARG A  26     -25.181   9.412  -3.267  1.00  0.00           H  
ATOM    409 HH12 ARG A  26     -25.938  10.812  -3.979  1.00  0.00           H  
ATOM    410 HH21 ARG A  26     -23.076  12.830  -3.753  1.00  0.00           H  
ATOM    411 HH22 ARG A  26     -24.740  12.753  -4.263  1.00  0.00           H  
ATOM    412  N   LEU A  27     -20.744   7.492   1.740  1.00  0.00           N  
ATOM    413  CA  LEU A  27     -20.301   6.174   2.182  1.00  0.00           C  
ATOM    414  C   LEU A  27     -21.315   5.574   3.146  1.00  0.00           C  
ATOM    415  O   LEU A  27     -21.658   4.399   3.044  1.00  0.00           O  
ATOM    416  CB  LEU A  27     -18.930   6.273   2.859  1.00  0.00           C  
ATOM    417  CG  LEU A  27     -17.807   6.834   1.984  1.00  0.00           C  
ATOM    418  CD1 LEU A  27     -16.538   7.011   2.797  1.00  0.00           C  
ATOM    419  CD2 LEU A  27     -17.547   5.926   0.794  1.00  0.00           C  
ATOM    420  H   LEU A  27     -20.225   8.285   2.003  1.00  0.00           H  
ATOM    421  HA  LEU A  27     -20.225   5.535   1.313  1.00  0.00           H  
ATOM    422  HB2 LEU A  27     -19.027   6.905   3.728  1.00  0.00           H  
ATOM    423  HB3 LEU A  27     -18.642   5.284   3.184  1.00  0.00           H  
ATOM    424  HG  LEU A  27     -18.100   7.802   1.608  1.00  0.00           H  
ATOM    425 HD11 LEU A  27     -16.237   6.060   3.208  1.00  0.00           H  
ATOM    426 HD12 LEU A  27     -16.724   7.707   3.603  1.00  0.00           H  
ATOM    427 HD13 LEU A  27     -15.753   7.396   2.164  1.00  0.00           H  
ATOM    428 HD21 LEU A  27     -18.445   5.851   0.197  1.00  0.00           H  
ATOM    429 HD22 LEU A  27     -17.264   4.944   1.144  1.00  0.00           H  
ATOM    430 HD23 LEU A  27     -16.751   6.339   0.194  1.00  0.00           H  
ATOM    431  N   PHE A  28     -21.806   6.395   4.064  1.00  0.00           N  
ATOM    432  CA  PHE A  28     -22.807   5.965   5.034  1.00  0.00           C  
ATOM    433  C   PHE A  28     -24.076   5.525   4.321  1.00  0.00           C  
ATOM    434  O   PHE A  28     -24.697   4.525   4.683  1.00  0.00           O  
ATOM    435  CB  PHE A  28     -23.122   7.105   5.996  1.00  0.00           C  
ATOM    436  CG  PHE A  28     -23.887   6.673   7.214  1.00  0.00           C  
ATOM    437  CD1 PHE A  28     -23.265   5.946   8.220  1.00  0.00           C  
ATOM    438  CD2 PHE A  28     -25.227   6.993   7.356  1.00  0.00           C  
ATOM    439  CE1 PHE A  28     -23.967   5.548   9.341  1.00  0.00           C  
ATOM    440  CE2 PHE A  28     -25.933   6.598   8.476  1.00  0.00           C  
ATOM    441  CZ  PHE A  28     -25.303   5.872   9.469  1.00  0.00           C  
ATOM    442  H   PHE A  28     -21.476   7.322   4.099  1.00  0.00           H  
ATOM    443  HA  PHE A  28     -22.406   5.130   5.592  1.00  0.00           H  
ATOM    444  HB2 PHE A  28     -22.200   7.550   6.318  1.00  0.00           H  
ATOM    445  HB3 PHE A  28     -23.712   7.847   5.480  1.00  0.00           H  
ATOM    446  HD1 PHE A  28     -22.221   5.689   8.120  1.00  0.00           H  
ATOM    447  HD2 PHE A  28     -25.724   7.562   6.582  1.00  0.00           H  
ATOM    448  HE1 PHE A  28     -23.471   4.982  10.116  1.00  0.00           H  
ATOM    449  HE2 PHE A  28     -26.979   6.851   8.573  1.00  0.00           H  
ATOM    450  HZ  PHE A  28     -25.853   5.561  10.344  1.00  0.00           H  
ATOM    451  N   SER A  29     -24.446   6.288   3.303  1.00  0.00           N  
ATOM    452  CA  SER A  29     -25.586   5.956   2.464  1.00  0.00           C  
ATOM    453  C   SER A  29     -25.381   4.606   1.779  1.00  0.00           C  
ATOM    454  O   SER A  29     -26.326   3.837   1.610  1.00  0.00           O  
ATOM    455  CB  SER A  29     -25.800   7.042   1.411  1.00  0.00           C  
ATOM    456  OG  SER A  29     -26.074   8.298   2.015  1.00  0.00           O  
ATOM    457  H   SER A  29     -23.941   7.108   3.119  1.00  0.00           H  
ATOM    458  HA  SER A  29     -26.458   5.897   3.095  1.00  0.00           H  
ATOM    459  HB2 SER A  29     -24.907   7.135   0.809  1.00  0.00           H  
ATOM    460  HB3 SER A  29     -26.630   6.769   0.779  1.00  0.00           H  
ATOM    461  HG  SER A  29     -25.289   8.604   2.493  1.00  0.00           H  
ATOM    462  N   MET A  30     -24.137   4.320   1.411  1.00  0.00           N  
ATOM    463  CA  MET A  30     -23.810   3.084   0.709  1.00  0.00           C  
ATOM    464  C   MET A  30     -23.601   1.924   1.681  1.00  0.00           C  
ATOM    465  O   MET A  30     -23.523   0.764   1.270  1.00  0.00           O  
ATOM    466  CB  MET A  30     -22.564   3.279  -0.157  1.00  0.00           C  
ATOM    467  CG  MET A  30     -22.810   4.145  -1.383  1.00  0.00           C  
ATOM    468  SD  MET A  30     -21.407   4.178  -2.516  1.00  0.00           S  
ATOM    469  CE  MET A  30     -20.131   4.874  -1.467  1.00  0.00           C  
ATOM    470  H   MET A  30     -23.419   4.962   1.615  1.00  0.00           H  
ATOM    471  HA  MET A  30     -24.643   2.848   0.066  1.00  0.00           H  
ATOM    472  HB2 MET A  30     -21.798   3.753   0.441  1.00  0.00           H  
ATOM    473  HB3 MET A  30     -22.210   2.317  -0.481  1.00  0.00           H  
ATOM    474  HG2 MET A  30     -23.669   3.756  -1.911  1.00  0.00           H  
ATOM    475  HG3 MET A  30     -23.017   5.154  -1.057  1.00  0.00           H  
ATOM    476  HE1 MET A  30     -20.459   5.831  -1.094  1.00  0.00           H  
ATOM    477  HE2 MET A  30     -19.225   5.002  -2.042  1.00  0.00           H  
ATOM    478  HE3 MET A  30     -19.943   4.207  -0.638  1.00  0.00           H  
ATOM    479  N   GLY A  31     -23.508   2.239   2.965  1.00  0.00           N  
ATOM    480  CA  GLY A  31     -23.355   1.208   3.976  1.00  0.00           C  
ATOM    481  C   GLY A  31     -21.903   0.941   4.323  1.00  0.00           C  
ATOM    482  O   GLY A  31     -21.549  -0.165   4.727  1.00  0.00           O  
ATOM    483  H   GLY A  31     -23.545   3.181   3.231  1.00  0.00           H  
ATOM    484  HA2 GLY A  31     -23.878   1.518   4.870  1.00  0.00           H  
ATOM    485  HA3 GLY A  31     -23.799   0.293   3.613  1.00  0.00           H  
ATOM    486  N   LEU A  32     -21.063   1.952   4.161  1.00  0.00           N  
ATOM    487  CA  LEU A  32     -19.647   1.828   4.483  1.00  0.00           C  
ATOM    488  C   LEU A  32     -19.325   2.568   5.777  1.00  0.00           C  
ATOM    489  O   LEU A  32     -19.243   3.797   5.803  1.00  0.00           O  
ATOM    490  CB  LEU A  32     -18.791   2.366   3.334  1.00  0.00           C  
ATOM    491  CG  LEU A  32     -18.966   1.641   1.996  1.00  0.00           C  
ATOM    492  CD1 LEU A  32     -18.130   2.309   0.916  1.00  0.00           C  
ATOM    493  CD2 LEU A  32     -18.584   0.175   2.132  1.00  0.00           C  
ATOM    494  H   LEU A  32     -21.398   2.808   3.816  1.00  0.00           H  
ATOM    495  HA  LEU A  32     -19.430   0.778   4.623  1.00  0.00           H  
ATOM    496  HB2 LEU A  32     -19.036   3.410   3.191  1.00  0.00           H  
ATOM    497  HB3 LEU A  32     -17.752   2.296   3.622  1.00  0.00           H  
ATOM    498  HG  LEU A  32     -20.004   1.694   1.696  1.00  0.00           H  
ATOM    499 HD11 LEU A  32     -17.087   2.282   1.201  1.00  0.00           H  
ATOM    500 HD12 LEU A  32     -18.444   3.335   0.798  1.00  0.00           H  
ATOM    501 HD13 LEU A  32     -18.260   1.782  -0.017  1.00  0.00           H  
ATOM    502 HD21 LEU A  32     -18.725  -0.323   1.184  1.00  0.00           H  
ATOM    503 HD22 LEU A  32     -19.209  -0.291   2.881  1.00  0.00           H  
ATOM    504 HD23 LEU A  32     -17.549   0.100   2.430  1.00  0.00           H  
ATOM    505  N   LEU A  33     -19.173   1.813   6.855  1.00  0.00           N  
ATOM    506  CA  LEU A  33     -18.879   2.382   8.153  1.00  0.00           C  
ATOM    507  C   LEU A  33     -17.825   1.542   8.871  1.00  0.00           C  
ATOM    508  O   LEU A  33     -17.639   0.365   8.551  1.00  0.00           O  
ATOM    509  CB  LEU A  33     -20.155   2.468   9.002  1.00  0.00           C  
ATOM    510  CG  LEU A  33     -20.842   1.135   9.328  1.00  0.00           C  
ATOM    511  CD1 LEU A  33     -21.755   1.302  10.530  1.00  0.00           C  
ATOM    512  CD2 LEU A  33     -21.649   0.629   8.142  1.00  0.00           C  
ATOM    513  H   LEU A  33     -19.273   0.843   6.781  1.00  0.00           H  
ATOM    514  HA  LEU A  33     -18.490   3.377   7.999  1.00  0.00           H  
ATOM    515  HB2 LEU A  33     -19.900   2.947   9.931  1.00  0.00           H  
ATOM    516  HB3 LEU A  33     -20.864   3.092   8.480  1.00  0.00           H  
ATOM    517  HG  LEU A  33     -20.092   0.397   9.571  1.00  0.00           H  
ATOM    518 HD11 LEU A  33     -22.503   2.049  10.311  1.00  0.00           H  
ATOM    519 HD12 LEU A  33     -21.172   1.616  11.384  1.00  0.00           H  
ATOM    520 HD13 LEU A  33     -22.238   0.361  10.751  1.00  0.00           H  
ATOM    521 HD21 LEU A  33     -22.075  -0.336   8.380  1.00  0.00           H  
ATOM    522 HD22 LEU A  33     -21.003   0.537   7.283  1.00  0.00           H  
ATOM    523 HD23 LEU A  33     -22.443   1.327   7.923  1.00  0.00           H  
ATOM    524  N   PRO A  34     -17.104   2.142   9.831  1.00  0.00           N  
ATOM    525  CA  PRO A  34     -16.093   1.431  10.619  1.00  0.00           C  
ATOM    526  C   PRO A  34     -16.702   0.296  11.434  1.00  0.00           C  
ATOM    527  O   PRO A  34     -17.767   0.452  12.036  1.00  0.00           O  
ATOM    528  CB  PRO A  34     -15.529   2.507  11.554  1.00  0.00           C  
ATOM    529  CG  PRO A  34     -15.913   3.805  10.931  1.00  0.00           C  
ATOM    530  CD  PRO A  34     -17.215   3.553  10.229  1.00  0.00           C  
ATOM    531  HA  PRO A  34     -15.303   1.041   9.994  1.00  0.00           H  
ATOM    532  HB2 PRO A  34     -15.964   2.395  12.536  1.00  0.00           H  
ATOM    533  HB3 PRO A  34     -14.455   2.403  11.618  1.00  0.00           H  
ATOM    534  HG2 PRO A  34     -16.039   4.556  11.696  1.00  0.00           H  
ATOM    535  HG3 PRO A  34     -15.159   4.111  10.221  1.00  0.00           H  
ATOM    536  HD2 PRO A  34     -18.045   3.703  10.905  1.00  0.00           H  
ATOM    537  HD3 PRO A  34     -17.309   4.191   9.364  1.00  0.00           H  
ATOM    538  N   GLY A  35     -16.030  -0.843  11.442  1.00  0.00           N  
ATOM    539  CA  GLY A  35     -16.521  -1.982  12.188  1.00  0.00           C  
ATOM    540  C   GLY A  35     -16.902  -3.138  11.289  1.00  0.00           C  
ATOM    541  O   GLY A  35     -17.018  -4.274  11.749  1.00  0.00           O  
ATOM    542  H   GLY A  35     -15.186  -0.911  10.938  1.00  0.00           H  
ATOM    543  HA2 GLY A  35     -15.752  -2.310  12.872  1.00  0.00           H  
ATOM    544  HA3 GLY A  35     -17.388  -1.681  12.758  1.00  0.00           H  
ATOM    545  N   ALA A  36     -17.091  -2.854  10.005  1.00  0.00           N  
ATOM    546  CA  ALA A  36     -17.458  -3.871   9.051  1.00  0.00           C  
ATOM    547  C   ALA A  36     -16.217  -4.561   8.517  1.00  0.00           C  
ATOM    548  O   ALA A  36     -15.088  -4.178   8.837  1.00  0.00           O  
ATOM    549  CB  ALA A  36     -18.271  -3.270   7.912  1.00  0.00           C  
ATOM    550  H   ALA A  36     -16.971  -1.943   9.690  1.00  0.00           H  
ATOM    551  HA  ALA A  36     -18.074  -4.601   9.556  1.00  0.00           H  
ATOM    552  HB1 ALA A  36     -18.586  -4.054   7.240  1.00  0.00           H  
ATOM    553  HB2 ALA A  36     -17.665  -2.558   7.371  1.00  0.00           H  
ATOM    554  HB3 ALA A  36     -19.140  -2.770   8.314  1.00  0.00           H  
ATOM    555  N   ALA A  37     -16.433  -5.562   7.701  1.00  0.00           N  
ATOM    556  CA  ALA A  37     -15.347  -6.363   7.154  1.00  0.00           C  
ATOM    557  C   ALA A  37     -15.694  -6.878   5.763  1.00  0.00           C  
ATOM    558  O   ALA A  37     -16.860  -7.129   5.455  1.00  0.00           O  
ATOM    559  CB  ALA A  37     -15.026  -7.526   8.084  1.00  0.00           C  
ATOM    560  H   ALA A  37     -17.355  -5.764   7.450  1.00  0.00           H  
ATOM    561  HA  ALA A  37     -14.471  -5.734   7.085  1.00  0.00           H  
ATOM    562  HB1 ALA A  37     -14.184  -8.080   7.693  1.00  0.00           H  
ATOM    563  HB2 ALA A  37     -15.883  -8.176   8.159  1.00  0.00           H  
ATOM    564  HB3 ALA A  37     -14.778  -7.144   9.064  1.00  0.00           H  
ATOM    565  N   LEU A  38     -14.679  -7.024   4.925  1.00  0.00           N  
ATOM    566  CA  LEU A  38     -14.862  -7.531   3.577  1.00  0.00           C  
ATOM    567  C   LEU A  38     -13.999  -8.769   3.363  1.00  0.00           C  
ATOM    568  O   LEU A  38     -12.804  -8.768   3.662  1.00  0.00           O  
ATOM    569  CB  LEU A  38     -14.488  -6.467   2.546  1.00  0.00           C  
ATOM    570  CG  LEU A  38     -15.168  -5.106   2.721  1.00  0.00           C  
ATOM    571  CD1 LEU A  38     -14.611  -4.107   1.719  1.00  0.00           C  
ATOM    572  CD2 LEU A  38     -16.675  -5.237   2.558  1.00  0.00           C  
ATOM    573  H   LEU A  38     -13.774  -6.774   5.221  1.00  0.00           H  
ATOM    574  HA  LEU A  38     -15.901  -7.799   3.454  1.00  0.00           H  
ATOM    575  HB2 LEU A  38     -13.423  -6.326   2.586  1.00  0.00           H  
ATOM    576  HB3 LEU A  38     -14.744  -6.845   1.567  1.00  0.00           H  
ATOM    577  HG  LEU A  38     -14.968  -4.731   3.715  1.00  0.00           H  
ATOM    578 HD11 LEU A  38     -15.068  -3.140   1.879  1.00  0.00           H  
ATOM    579 HD12 LEU A  38     -14.829  -4.443   0.715  1.00  0.00           H  
ATOM    580 HD13 LEU A  38     -13.541  -4.024   1.846  1.00  0.00           H  
ATOM    581 HD21 LEU A  38     -17.060  -5.912   3.308  1.00  0.00           H  
ATOM    582 HD22 LEU A  38     -16.896  -5.627   1.576  1.00  0.00           H  
ATOM    583 HD23 LEU A  38     -17.136  -4.269   2.673  1.00  0.00           H  
ATOM    584  N   ARG A  39     -14.614  -9.815   2.854  1.00  0.00           N  
ATOM    585  CA  ARG A  39     -13.915 -11.059   2.562  1.00  0.00           C  
ATOM    586  C   ARG A  39     -13.558 -11.105   1.083  1.00  0.00           C  
ATOM    587  O   ARG A  39     -14.441 -11.056   0.231  1.00  0.00           O  
ATOM    588  CB  ARG A  39     -14.805 -12.245   2.944  1.00  0.00           C  
ATOM    589  CG  ARG A  39     -14.161 -13.602   2.727  1.00  0.00           C  
ATOM    590  CD  ARG A  39     -15.026 -14.716   3.295  1.00  0.00           C  
ATOM    591  NE  ARG A  39     -15.222 -14.570   4.736  1.00  0.00           N  
ATOM    592  CZ  ARG A  39     -15.125 -15.570   5.610  1.00  0.00           C  
ATOM    593  NH1 ARG A  39     -14.934 -16.815   5.187  1.00  0.00           N  
ATOM    594  NH2 ARG A  39     -15.260 -15.324   6.906  1.00  0.00           N  
ATOM    595  H   ARG A  39     -15.576  -9.749   2.662  1.00  0.00           H  
ATOM    596  HA  ARG A  39     -13.008 -11.084   3.150  1.00  0.00           H  
ATOM    597  HB2 ARG A  39     -15.068 -12.160   3.988  1.00  0.00           H  
ATOM    598  HB3 ARG A  39     -15.709 -12.202   2.352  1.00  0.00           H  
ATOM    599  HG2 ARG A  39     -14.029 -13.765   1.669  1.00  0.00           H  
ATOM    600  HG3 ARG A  39     -13.201 -13.615   3.222  1.00  0.00           H  
ATOM    601  HD2 ARG A  39     -15.988 -14.694   2.806  1.00  0.00           H  
ATOM    602  HD3 ARG A  39     -14.545 -15.664   3.100  1.00  0.00           H  
ATOM    603  HE  ARG A  39     -15.424 -13.658   5.074  1.00  0.00           H  
ATOM    604 HH11 ARG A  39     -14.867 -17.009   4.205  1.00  0.00           H  
ATOM    605 HH12 ARG A  39     -14.856 -17.570   5.852  1.00  0.00           H  
ATOM    606 HH21 ARG A  39     -15.436 -14.391   7.226  1.00  0.00           H  
ATOM    607 HH22 ARG A  39     -15.176 -16.071   7.579  1.00  0.00           H  
ATOM    608  N   VAL A  40     -12.271 -11.188   0.782  1.00  0.00           N  
ATOM    609  CA  VAL A  40     -11.794 -11.063  -0.592  1.00  0.00           C  
ATOM    610  C   VAL A  40     -12.352 -12.150  -1.516  1.00  0.00           C  
ATOM    611  O   VAL A  40     -12.298 -13.345  -1.207  1.00  0.00           O  
ATOM    612  CB  VAL A  40     -10.245 -11.076  -0.663  1.00  0.00           C  
ATOM    613  CG1 VAL A  40      -9.678 -12.415  -0.217  1.00  0.00           C  
ATOM    614  CG2 VAL A  40      -9.767 -10.732  -2.065  1.00  0.00           C  
ATOM    615  H   VAL A  40     -11.621 -11.346   1.501  1.00  0.00           H  
ATOM    616  HA  VAL A  40     -12.131 -10.106  -0.964  1.00  0.00           H  
ATOM    617  HB  VAL A  40      -9.871 -10.321   0.012  1.00  0.00           H  
ATOM    618 HG11 VAL A  40     -10.079 -13.201  -0.839  1.00  0.00           H  
ATOM    619 HG12 VAL A  40      -9.951 -12.595   0.813  1.00  0.00           H  
ATOM    620 HG13 VAL A  40      -8.603 -12.400  -0.307  1.00  0.00           H  
ATOM    621 HG21 VAL A  40     -10.149 -11.462  -2.763  1.00  0.00           H  
ATOM    622 HG22 VAL A  40      -8.688 -10.738  -2.089  1.00  0.00           H  
ATOM    623 HG23 VAL A  40     -10.127  -9.751  -2.337  1.00  0.00           H  
ATOM    624  N   VAL A  41     -12.935 -11.711  -2.626  1.00  0.00           N  
ATOM    625  CA  VAL A  41     -13.239 -12.597  -3.734  1.00  0.00           C  
ATOM    626  C   VAL A  41     -12.136 -12.473  -4.778  1.00  0.00           C  
ATOM    627  O   VAL A  41     -11.517 -13.466  -5.151  1.00  0.00           O  
ATOM    628  CB  VAL A  41     -14.613 -12.281  -4.369  1.00  0.00           C  
ATOM    629  CG1 VAL A  41     -14.845 -13.123  -5.611  1.00  0.00           C  
ATOM    630  CG2 VAL A  41     -15.731 -12.503  -3.359  1.00  0.00           C  
ATOM    631  H   VAL A  41     -13.186 -10.759  -2.697  1.00  0.00           H  
ATOM    632  HA  VAL A  41     -13.256 -13.610  -3.357  1.00  0.00           H  
ATOM    633  HB  VAL A  41     -14.622 -11.241  -4.663  1.00  0.00           H  
ATOM    634 HG11 VAL A  41     -15.806 -12.876  -6.034  1.00  0.00           H  
ATOM    635 HG12 VAL A  41     -14.826 -14.170  -5.346  1.00  0.00           H  
ATOM    636 HG13 VAL A  41     -14.070 -12.920  -6.336  1.00  0.00           H  
ATOM    637 HG21 VAL A  41     -15.704 -13.525  -3.014  1.00  0.00           H  
ATOM    638 HG22 VAL A  41     -16.684 -12.308  -3.830  1.00  0.00           H  
ATOM    639 HG23 VAL A  41     -15.599 -11.835  -2.522  1.00  0.00           H  
ATOM    640  N   ARG A  42     -11.885 -11.232  -5.222  1.00  0.00           N  
ATOM    641  CA  ARG A  42     -10.777 -10.935  -6.142  1.00  0.00           C  
ATOM    642  C   ARG A  42     -10.806  -9.485  -6.622  1.00  0.00           C  
ATOM    643  O   ARG A  42     -11.850  -8.830  -6.621  1.00  0.00           O  
ATOM    644  CB  ARG A  42     -10.784 -11.858  -7.370  1.00  0.00           C  
ATOM    645  CG  ARG A  42     -12.014 -11.725  -8.256  1.00  0.00           C  
ATOM    646  CD  ARG A  42     -11.852 -12.519  -9.541  1.00  0.00           C  
ATOM    647  NE  ARG A  42     -13.021 -12.422 -10.409  1.00  0.00           N  
ATOM    648  CZ  ARG A  42     -12.972 -12.038 -11.686  1.00  0.00           C  
ATOM    649  NH1 ARG A  42     -11.818 -11.659 -12.227  1.00  0.00           N  
ATOM    650  NH2 ARG A  42     -14.082 -12.024 -12.413  1.00  0.00           N  
ATOM    651  H   ARG A  42     -12.455 -10.493  -4.910  1.00  0.00           H  
ATOM    652  HA  ARG A  42      -9.858 -11.094  -5.599  1.00  0.00           H  
ATOM    653  HB2 ARG A  42      -9.916 -11.637  -7.973  1.00  0.00           H  
ATOM    654  HB3 ARG A  42     -10.722 -12.883  -7.033  1.00  0.00           H  
ATOM    655  HG2 ARG A  42     -12.875 -12.097  -7.718  1.00  0.00           H  
ATOM    656  HG3 ARG A  42     -12.161 -10.683  -8.499  1.00  0.00           H  
ATOM    657  HD2 ARG A  42     -10.994 -12.140 -10.074  1.00  0.00           H  
ATOM    658  HD3 ARG A  42     -11.687 -13.556  -9.289  1.00  0.00           H  
ATOM    659  HE  ARG A  42     -13.889 -12.680 -10.027  1.00  0.00           H  
ATOM    660 HH11 ARG A  42     -10.973 -11.659 -11.678  1.00  0.00           H  
ATOM    661 HH12 ARG A  42     -11.784 -11.366 -13.193  1.00  0.00           H  
ATOM    662 HH21 ARG A  42     -14.960 -12.299 -12.004  1.00  0.00           H  
ATOM    663 HH22 ARG A  42     -14.053 -11.745 -13.381  1.00  0.00           H  
ATOM    664  N   ILE A  43      -9.638  -8.996  -7.026  1.00  0.00           N  
ATOM    665  CA  ILE A  43      -9.513  -7.712  -7.709  1.00  0.00           C  
ATOM    666  C   ILE A  43      -8.939  -7.967  -9.103  1.00  0.00           C  
ATOM    667  O   ILE A  43      -8.097  -8.852  -9.274  1.00  0.00           O  
ATOM    668  CB  ILE A  43      -8.582  -6.733  -6.948  1.00  0.00           C  
ATOM    669  CG1 ILE A  43      -9.166  -6.426  -5.564  1.00  0.00           C  
ATOM    670  CG2 ILE A  43      -8.371  -5.438  -7.746  1.00  0.00           C  
ATOM    671  CD1 ILE A  43      -8.277  -5.557  -4.703  1.00  0.00           C  
ATOM    672  H   ILE A  43      -8.824  -9.519  -6.867  1.00  0.00           H  
ATOM    673  HA  ILE A  43     -10.503  -7.268  -7.787  1.00  0.00           H  
ATOM    674  HB  ILE A  43      -7.623  -7.210  -6.825  1.00  0.00           H  
ATOM    675 HG12 ILE A  43     -10.109  -5.916  -5.683  1.00  0.00           H  
ATOM    676 HG13 ILE A  43      -9.331  -7.358  -5.039  1.00  0.00           H  
ATOM    677 HG21 ILE A  43      -7.919  -5.668  -8.703  1.00  0.00           H  
ATOM    678 HG22 ILE A  43      -7.720  -4.774  -7.196  1.00  0.00           H  
ATOM    679 HG23 ILE A  43      -9.321  -4.952  -7.910  1.00  0.00           H  
ATOM    680 HD11 ILE A  43      -8.758  -5.381  -3.751  1.00  0.00           H  
ATOM    681 HD12 ILE A  43      -8.106  -4.614  -5.199  1.00  0.00           H  
ATOM    682 HD13 ILE A  43      -7.332  -6.056  -4.541  1.00  0.00           H  
ATOM    683  N   ALA A  44      -9.406  -7.232 -10.100  1.00  0.00           N  
ATOM    684  CA  ALA A  44      -8.868  -7.358 -11.451  1.00  0.00           C  
ATOM    685  C   ALA A  44      -7.497  -6.691 -11.546  1.00  0.00           C  
ATOM    686  O   ALA A  44      -7.315  -5.564 -11.082  1.00  0.00           O  
ATOM    687  CB  ALA A  44      -9.824  -6.755 -12.469  1.00  0.00           C  
ATOM    688  H   ALA A  44     -10.127  -6.596  -9.927  1.00  0.00           H  
ATOM    689  HA  ALA A  44      -8.760  -8.411 -11.669  1.00  0.00           H  
ATOM    690  HB1 ALA A  44     -10.784  -7.247 -12.402  1.00  0.00           H  
ATOM    691  HB2 ALA A  44      -9.422  -6.883 -13.463  1.00  0.00           H  
ATOM    692  HB3 ALA A  44      -9.945  -5.702 -12.263  1.00  0.00           H  
ATOM    693  N   PRO A  45      -6.522  -7.378 -12.169  1.00  0.00           N  
ATOM    694  CA  PRO A  45      -5.125  -6.912 -12.241  1.00  0.00           C  
ATOM    695  C   PRO A  45      -4.960  -5.649 -13.083  1.00  0.00           C  
ATOM    696  O   PRO A  45      -3.957  -4.941 -12.959  1.00  0.00           O  
ATOM    697  CB  PRO A  45      -4.395  -8.086 -12.898  1.00  0.00           C  
ATOM    698  CG  PRO A  45      -5.447  -8.797 -13.669  1.00  0.00           C  
ATOM    699  CD  PRO A  45      -6.700  -8.672 -12.854  1.00  0.00           C  
ATOM    700  HA  PRO A  45      -4.720  -6.739 -11.256  1.00  0.00           H  
ATOM    701  HB2 PRO A  45      -3.614  -7.710 -13.543  1.00  0.00           H  
ATOM    702  HB3 PRO A  45      -3.967  -8.719 -12.133  1.00  0.00           H  
ATOM    703  HG2 PRO A  45      -5.577  -8.330 -14.635  1.00  0.00           H  
ATOM    704  HG3 PRO A  45      -5.181  -9.838 -13.787  1.00  0.00           H  
ATOM    705  HD2 PRO A  45      -7.569  -8.655 -13.495  1.00  0.00           H  
ATOM    706  HD3 PRO A  45      -6.769  -9.477 -12.139  1.00  0.00           H  
ATOM    707  N   LEU A  46      -5.948  -5.388 -13.938  1.00  0.00           N  
ATOM    708  CA  LEU A  46      -5.978  -4.178 -14.764  1.00  0.00           C  
ATOM    709  C   LEU A  46      -5.776  -2.948 -13.909  1.00  0.00           C  
ATOM    710  O   LEU A  46      -5.003  -2.051 -14.242  1.00  0.00           O  
ATOM    711  CB  LEU A  46      -7.323  -4.055 -15.486  1.00  0.00           C  
ATOM    712  CG  LEU A  46      -7.389  -4.695 -16.877  1.00  0.00           C  
ATOM    713  CD1 LEU A  46      -6.352  -4.067 -17.803  1.00  0.00           C  
ATOM    714  CD2 LEU A  46      -7.187  -6.202 -16.785  1.00  0.00           C  
ATOM    715  H   LEU A  46      -6.679  -6.030 -14.017  1.00  0.00           H  
ATOM    716  HA  LEU A  46      -5.185  -4.243 -15.492  1.00  0.00           H  
ATOM    717  HB2 LEU A  46      -8.080  -4.516 -14.863  1.00  0.00           H  
ATOM    718  HB3 LEU A  46      -7.563  -3.005 -15.578  1.00  0.00           H  
ATOM    719  HG  LEU A  46      -8.365  -4.513 -17.301  1.00  0.00           H  
ATOM    720 HD11 LEU A  46      -6.432  -4.508 -18.787  1.00  0.00           H  
ATOM    721 HD12 LEU A  46      -5.360  -4.245 -17.411  1.00  0.00           H  
ATOM    722 HD13 LEU A  46      -6.525  -3.002 -17.872  1.00  0.00           H  
ATOM    723 HD21 LEU A  46      -6.227  -6.413 -16.338  1.00  0.00           H  
ATOM    724 HD22 LEU A  46      -7.226  -6.634 -17.775  1.00  0.00           H  
ATOM    725 HD23 LEU A  46      -7.969  -6.632 -16.176  1.00  0.00           H  
ATOM    726  N   GLY A  47      -6.475  -2.935 -12.799  1.00  0.00           N  
ATOM    727  CA  GLY A  47      -6.434  -1.824 -11.897  1.00  0.00           C  
ATOM    728  C   GLY A  47      -7.222  -2.126 -10.666  1.00  0.00           C  
ATOM    729  O   GLY A  47      -6.648  -2.420  -9.614  1.00  0.00           O  
ATOM    730  H   GLY A  47      -7.028  -3.712 -12.577  1.00  0.00           H  
ATOM    731  HA2 GLY A  47      -5.408  -1.615 -11.627  1.00  0.00           H  
ATOM    732  HA3 GLY A  47      -6.859  -0.964 -12.373  1.00  0.00           H  
ATOM    733  N   ASP A  48      -8.543  -2.100 -10.803  1.00  0.00           N  
ATOM    734  CA  ASP A  48      -9.399  -2.358  -9.672  1.00  0.00           C  
ATOM    735  C   ASP A  48     -10.879  -2.342  -9.992  1.00  0.00           C  
ATOM    736  O   ASP A  48     -11.394  -1.450 -10.652  1.00  0.00           O  
ATOM    737  CB  ASP A  48      -9.174  -1.273  -8.627  1.00  0.00           C  
ATOM    738  CG  ASP A  48      -9.563   0.103  -9.147  1.00  0.00           C  
ATOM    739  OD1 ASP A  48      -8.756   0.713  -9.879  1.00  0.00           O  
ATOM    740  OD2 ASP A  48     -10.683   0.579  -8.837  1.00  0.00           O  
ATOM    741  H   ASP A  48      -8.940  -1.893 -11.668  1.00  0.00           H  
ATOM    742  HA  ASP A  48      -9.140  -3.309  -9.244  1.00  0.00           H  
ATOM    743  HB2 ASP A  48      -9.778  -1.494  -7.775  1.00  0.00           H  
ATOM    744  HB3 ASP A  48      -8.132  -1.257  -8.341  1.00  0.00           H  
ATOM    745  N   PRO A  49     -11.537  -3.414  -9.607  1.00  0.00           N  
ATOM    746  CA  PRO A  49     -12.744  -3.391  -8.839  1.00  0.00           C  
ATOM    747  C   PRO A  49     -12.414  -4.017  -7.495  1.00  0.00           C  
ATOM    748  O   PRO A  49     -11.239  -4.240  -7.195  1.00  0.00           O  
ATOM    749  CB  PRO A  49     -13.651  -4.303  -9.657  1.00  0.00           C  
ATOM    750  CG  PRO A  49     -12.708  -5.268 -10.334  1.00  0.00           C  
ATOM    751  CD  PRO A  49     -11.297  -4.773 -10.068  1.00  0.00           C  
ATOM    752  HA  PRO A  49     -13.157  -2.396  -8.716  1.00  0.00           H  
ATOM    753  HB2 PRO A  49     -14.337  -4.814  -8.997  1.00  0.00           H  
ATOM    754  HB3 PRO A  49     -14.199  -3.717 -10.375  1.00  0.00           H  
ATOM    755  HG2 PRO A  49     -12.838  -6.257  -9.921  1.00  0.00           H  
ATOM    756  HG3 PRO A  49     -12.903  -5.279 -11.396  1.00  0.00           H  
ATOM    757  HD2 PRO A  49     -10.825  -5.367  -9.301  1.00  0.00           H  
ATOM    758  HD3 PRO A  49     -10.712  -4.778 -10.975  1.00  0.00           H  
ATOM    759  N   ILE A  50     -13.401  -4.326  -6.700  1.00  0.00           N  
ATOM    760  CA  ILE A  50     -13.149  -5.103  -5.503  1.00  0.00           C  
ATOM    761  C   ILE A  50     -14.321  -6.018  -5.242  1.00  0.00           C  
ATOM    762  O   ILE A  50     -15.352  -5.581  -4.743  1.00  0.00           O  
ATOM    763  CB  ILE A  50     -12.895  -4.225  -4.247  1.00  0.00           C  
ATOM    764  CG1 ILE A  50     -11.645  -3.358  -4.428  1.00  0.00           C  
ATOM    765  CG2 ILE A  50     -12.752  -5.102  -3.008  1.00  0.00           C  
ATOM    766  CD1 ILE A  50     -11.316  -2.503  -3.227  1.00  0.00           C  
ATOM    767  H   ILE A  50     -14.312  -4.039  -6.916  1.00  0.00           H  
ATOM    768  HA  ILE A  50     -12.262  -5.710  -5.687  1.00  0.00           H  
ATOM    769  HB  ILE A  50     -13.751  -3.584  -4.104  1.00  0.00           H  
ATOM    770 HG12 ILE A  50     -10.797  -3.999  -4.613  1.00  0.00           H  
ATOM    771 HG13 ILE A  50     -11.791  -2.704  -5.278  1.00  0.00           H  
ATOM    772 HG21 ILE A  50     -11.902  -5.756  -3.130  1.00  0.00           H  
ATOM    773 HG22 ILE A  50     -13.646  -5.696  -2.883  1.00  0.00           H  
ATOM    774 HG23 ILE A  50     -12.606  -4.480  -2.138  1.00  0.00           H  
ATOM    775 HD11 ILE A  50     -10.453  -1.893  -3.444  1.00  0.00           H  
ATOM    776 HD12 ILE A  50     -11.103  -3.138  -2.379  1.00  0.00           H  
ATOM    777 HD13 ILE A  50     -12.158  -1.868  -2.996  1.00  0.00           H  
ATOM    778  N   GLN A  51     -14.176  -7.273  -5.620  1.00  0.00           N  
ATOM    779  CA  GLN A  51     -15.180  -8.264  -5.315  1.00  0.00           C  
ATOM    780  C   GLN A  51     -14.917  -8.841  -3.942  1.00  0.00           C  
ATOM    781  O   GLN A  51     -13.836  -9.370  -3.680  1.00  0.00           O  
ATOM    782  CB  GLN A  51     -15.185  -9.372  -6.364  1.00  0.00           C  
ATOM    783  CG  GLN A  51     -15.816  -8.969  -7.686  1.00  0.00           C  
ATOM    784  CD  GLN A  51     -17.315  -8.730  -7.592  1.00  0.00           C  
ATOM    785  OE1 GLN A  51     -17.841  -8.328  -6.555  1.00  0.00           O  
ATOM    786  NE2 GLN A  51     -18.017  -8.990  -8.686  1.00  0.00           N  
ATOM    787  H   GLN A  51     -13.371  -7.544  -6.114  1.00  0.00           H  
ATOM    788  HA  GLN A  51     -16.142  -7.775  -5.312  1.00  0.00           H  
ATOM    789  HB2 GLN A  51     -14.167  -9.676  -6.558  1.00  0.00           H  
ATOM    790  HB3 GLN A  51     -15.729 -10.212  -5.973  1.00  0.00           H  
ATOM    791  HG2 GLN A  51     -15.347  -8.061  -8.030  1.00  0.00           H  
ATOM    792  HG3 GLN A  51     -15.640  -9.756  -8.396  1.00  0.00           H  
ATOM    793 HE21 GLN A  51     -17.539  -9.320  -9.478  1.00  0.00           H  
ATOM    794 HE22 GLN A  51     -18.985  -8.839  -8.660  1.00  0.00           H  
ATOM    795  N   VAL A  52     -15.891  -8.713  -3.065  1.00  0.00           N  
ATOM    796  CA  VAL A  52     -15.765  -9.203  -1.703  1.00  0.00           C  
ATOM    797  C   VAL A  52     -17.077  -9.791  -1.215  1.00  0.00           C  
ATOM    798  O   VAL A  52     -18.096  -9.704  -1.892  1.00  0.00           O  
ATOM    799  CB  VAL A  52     -15.323  -8.094  -0.718  1.00  0.00           C  
ATOM    800  CG1 VAL A  52     -13.861  -7.734  -0.914  1.00  0.00           C  
ATOM    801  CG2 VAL A  52     -16.206  -6.863  -0.860  1.00  0.00           C  
ATOM    802  H   VAL A  52     -16.729  -8.275  -3.349  1.00  0.00           H  
ATOM    803  HA  VAL A  52     -15.013  -9.978  -1.695  1.00  0.00           H  
ATOM    804  HB  VAL A  52     -15.441  -8.475   0.285  1.00  0.00           H  
ATOM    805 HG11 VAL A  52     -13.706  -7.375  -1.924  1.00  0.00           H  
ATOM    806 HG12 VAL A  52     -13.252  -8.607  -0.746  1.00  0.00           H  
ATOM    807 HG13 VAL A  52     -13.584  -6.963  -0.212  1.00  0.00           H  
ATOM    808 HG21 VAL A  52     -15.884  -6.109  -0.158  1.00  0.00           H  
ATOM    809 HG22 VAL A  52     -17.231  -7.132  -0.657  1.00  0.00           H  
ATOM    810 HG23 VAL A  52     -16.128  -6.475  -1.867  1.00  0.00           H  
ATOM    811  N   GLU A  53     -17.033 -10.398  -0.046  1.00  0.00           N  
ATOM    812  CA  GLU A  53     -18.210 -10.957   0.588  1.00  0.00           C  
ATOM    813  C   GLU A  53     -18.367 -10.299   1.956  1.00  0.00           C  
ATOM    814  O   GLU A  53     -17.376  -9.880   2.556  1.00  0.00           O  
ATOM    815  CB  GLU A  53     -18.051 -12.481   0.706  1.00  0.00           C  
ATOM    816  CG  GLU A  53     -19.348 -13.263   0.538  1.00  0.00           C  
ATOM    817  CD  GLU A  53     -20.264 -13.158   1.736  1.00  0.00           C  
ATOM    818  OE1 GLU A  53     -20.119 -13.976   2.664  1.00  0.00           O  
ATOM    819  OE2 GLU A  53     -21.123 -12.251   1.755  1.00  0.00           O  
ATOM    820  H   GLU A  53     -16.169 -10.474   0.415  1.00  0.00           H  
ATOM    821  HA  GLU A  53     -19.069 -10.725  -0.026  1.00  0.00           H  
ATOM    822  HB2 GLU A  53     -17.357 -12.816  -0.052  1.00  0.00           H  
ATOM    823  HB3 GLU A  53     -17.643 -12.710   1.679  1.00  0.00           H  
ATOM    824  HG2 GLU A  53     -19.872 -12.885  -0.325  1.00  0.00           H  
ATOM    825  HG3 GLU A  53     -19.107 -14.305   0.379  1.00  0.00           H  
ATOM    826  N   THR A  54     -19.591 -10.187   2.436  1.00  0.00           N  
ATOM    827  CA  THR A  54     -19.860  -9.456   3.667  1.00  0.00           C  
ATOM    828  C   THR A  54     -20.499 -10.348   4.731  1.00  0.00           C  
ATOM    829  O   THR A  54     -20.285 -10.150   5.932  1.00  0.00           O  
ATOM    830  CB  THR A  54     -20.781  -8.250   3.392  1.00  0.00           C  
ATOM    831  OG1 THR A  54     -21.939  -8.674   2.658  1.00  0.00           O  
ATOM    832  CG2 THR A  54     -20.044  -7.166   2.615  1.00  0.00           C  
ATOM    833  H   THR A  54     -20.336 -10.628   1.963  1.00  0.00           H  
ATOM    834  HA  THR A  54     -18.920  -9.083   4.043  1.00  0.00           H  
ATOM    835  HB  THR A  54     -21.097  -7.838   4.340  1.00  0.00           H  
ATOM    836  HG1 THR A  54     -21.674  -8.969   1.775  1.00  0.00           H  
ATOM    837 HG21 THR A  54     -20.701  -6.322   2.458  1.00  0.00           H  
ATOM    838 HG22 THR A  54     -19.731  -7.560   1.659  1.00  0.00           H  
ATOM    839 HG23 THR A  54     -19.178  -6.848   3.175  1.00  0.00           H  
ATOM    840  N   ARG A  55     -21.261 -11.339   4.278  1.00  0.00           N  
ATOM    841  CA  ARG A  55     -22.013 -12.223   5.161  1.00  0.00           C  
ATOM    842  C   ARG A  55     -22.809 -13.227   4.333  1.00  0.00           C  
ATOM    843  O   ARG A  55     -22.698 -14.439   4.525  1.00  0.00           O  
ATOM    844  CB  ARG A  55     -22.966 -11.420   6.063  1.00  0.00           C  
ATOM    845  CG  ARG A  55     -23.883 -12.286   6.917  1.00  0.00           C  
ATOM    846  CD  ARG A  55     -23.107 -13.143   7.909  1.00  0.00           C  
ATOM    847  NE  ARG A  55     -23.973 -14.099   8.592  1.00  0.00           N  
ATOM    848  CZ  ARG A  55     -23.553 -14.970   9.509  1.00  0.00           C  
ATOM    849  NH1 ARG A  55     -22.299 -14.937   9.940  1.00  0.00           N  
ATOM    850  NH2 ARG A  55     -24.400 -15.850  10.019  1.00  0.00           N  
ATOM    851  H   ARG A  55     -21.299 -11.504   3.305  1.00  0.00           H  
ATOM    852  HA  ARG A  55     -21.308 -12.761   5.779  1.00  0.00           H  
ATOM    853  HB2 ARG A  55     -22.379 -10.801   6.723  1.00  0.00           H  
ATOM    854  HB3 ARG A  55     -23.582 -10.788   5.440  1.00  0.00           H  
ATOM    855  HG2 ARG A  55     -24.559 -11.646   7.464  1.00  0.00           H  
ATOM    856  HG3 ARG A  55     -24.452 -12.934   6.265  1.00  0.00           H  
ATOM    857  HD2 ARG A  55     -22.340 -13.684   7.376  1.00  0.00           H  
ATOM    858  HD3 ARG A  55     -22.648 -12.498   8.643  1.00  0.00           H  
ATOM    859  HE  ARG A  55     -24.926 -14.105   8.333  1.00  0.00           H  
ATOM    860 HH11 ARG A  55     -21.662 -14.252   9.584  1.00  0.00           H  
ATOM    861 HH12 ARG A  55     -21.979 -15.603  10.628  1.00  0.00           H  
ATOM    862 HH21 ARG A  55     -25.364 -15.858   9.715  1.00  0.00           H  
ATOM    863 HH22 ARG A  55     -24.094 -16.514  10.704  1.00  0.00           H  
ATOM    864  N   GLN A  56     -23.615 -12.708   3.417  1.00  0.00           N  
ATOM    865  CA  GLN A  56     -24.454 -13.542   2.558  1.00  0.00           C  
ATOM    866  C   GLN A  56     -24.568 -12.962   1.151  1.00  0.00           C  
ATOM    867  O   GLN A  56     -25.303 -13.480   0.312  1.00  0.00           O  
ATOM    868  CB  GLN A  56     -25.852 -13.668   3.155  1.00  0.00           C  
ATOM    869  CG  GLN A  56     -25.954 -14.639   4.321  1.00  0.00           C  
ATOM    870  CD  GLN A  56     -25.738 -16.083   3.904  1.00  0.00           C  
ATOM    871  OE1 GLN A  56     -26.685 -16.788   3.553  1.00  0.00           O  
ATOM    872  NE2 GLN A  56     -24.493 -16.534   3.934  1.00  0.00           N  
ATOM    873  H   GLN A  56     -23.650 -11.734   3.311  1.00  0.00           H  
ATOM    874  HA  GLN A  56     -24.004 -14.522   2.504  1.00  0.00           H  
ATOM    875  HB2 GLN A  56     -26.169 -12.696   3.502  1.00  0.00           H  
ATOM    876  HB3 GLN A  56     -26.521 -13.994   2.378  1.00  0.00           H  
ATOM    877  HG2 GLN A  56     -25.204 -14.378   5.055  1.00  0.00           H  
ATOM    878  HG3 GLN A  56     -26.935 -14.549   4.764  1.00  0.00           H  
ATOM    879 HE21 GLN A  56     -23.781 -15.915   4.216  1.00  0.00           H  
ATOM    880 HE22 GLN A  56     -24.332 -17.467   3.676  1.00  0.00           H  
ATOM    881  N   THR A  57     -23.841 -11.892   0.896  1.00  0.00           N  
ATOM    882  CA  THR A  57     -23.933 -11.198  -0.379  1.00  0.00           C  
ATOM    883  C   THR A  57     -22.602 -10.537  -0.741  1.00  0.00           C  
ATOM    884  O   THR A  57     -21.918  -9.961   0.114  1.00  0.00           O  
ATOM    885  CB  THR A  57     -25.072 -10.148  -0.368  1.00  0.00           C  
ATOM    886  OG1 THR A  57     -25.193  -9.527  -1.655  1.00  0.00           O  
ATOM    887  CG2 THR A  57     -24.836  -9.081   0.693  1.00  0.00           C  
ATOM    888  H   THR A  57     -23.211 -11.576   1.571  1.00  0.00           H  
ATOM    889  HA  THR A  57     -24.166 -11.937  -1.135  1.00  0.00           H  
ATOM    890  HB  THR A  57     -25.997 -10.655  -0.140  1.00  0.00           H  
ATOM    891  HG1 THR A  57     -25.354  -8.585  -1.542  1.00  0.00           H  
ATOM    892 HG21 THR A  57     -24.768  -9.548   1.666  1.00  0.00           H  
ATOM    893 HG22 THR A  57     -25.658  -8.379   0.689  1.00  0.00           H  
ATOM    894 HG23 THR A  57     -23.916  -8.557   0.480  1.00  0.00           H  
ATOM    895  N   SER A  58     -22.240 -10.636  -2.014  1.00  0.00           N  
ATOM    896  CA  SER A  58     -20.986 -10.087  -2.505  1.00  0.00           C  
ATOM    897  C   SER A  58     -21.094  -8.583  -2.748  1.00  0.00           C  
ATOM    898  O   SER A  58     -22.159  -8.075  -3.103  1.00  0.00           O  
ATOM    899  CB  SER A  58     -20.584 -10.809  -3.790  1.00  0.00           C  
ATOM    900  OG  SER A  58     -21.676 -10.874  -4.695  1.00  0.00           O  
ATOM    901  H   SER A  58     -22.838 -11.086  -2.645  1.00  0.00           H  
ATOM    902  HA  SER A  58     -20.231 -10.263  -1.755  1.00  0.00           H  
ATOM    903  HB2 SER A  58     -19.771 -10.279  -4.262  1.00  0.00           H  
ATOM    904  HB3 SER A  58     -20.270 -11.812  -3.550  1.00  0.00           H  
ATOM    905  HG  SER A  58     -22.214 -10.080  -4.603  1.00  0.00           H  
ATOM    906  N   LEU A  59     -19.986  -7.881  -2.568  1.00  0.00           N  
ATOM    907  CA  LEU A  59     -19.954  -6.440  -2.730  1.00  0.00           C  
ATOM    908  C   LEU A  59     -18.800  -6.046  -3.645  1.00  0.00           C  
ATOM    909  O   LEU A  59     -17.780  -6.729  -3.686  1.00  0.00           O  
ATOM    910  CB  LEU A  59     -19.827  -5.784  -1.346  1.00  0.00           C  
ATOM    911  CG  LEU A  59     -20.164  -4.287  -1.239  1.00  0.00           C  
ATOM    912  CD1 LEU A  59     -19.005  -3.415  -1.687  1.00  0.00           C  
ATOM    913  CD2 LEU A  59     -21.424  -3.959  -2.029  1.00  0.00           C  
ATOM    914  H   LEU A  59     -19.158  -8.349  -2.321  1.00  0.00           H  
ATOM    915  HA  LEU A  59     -20.879  -6.139  -3.183  1.00  0.00           H  
ATOM    916  HB2 LEU A  59     -20.480  -6.312  -0.674  1.00  0.00           H  
ATOM    917  HB3 LEU A  59     -18.811  -5.921  -1.003  1.00  0.00           H  
ATOM    918  HG  LEU A  59     -20.360  -4.056  -0.205  1.00  0.00           H  
ATOM    919 HD11 LEU A  59     -18.755  -3.643  -2.713  1.00  0.00           H  
ATOM    920 HD12 LEU A  59     -18.147  -3.602  -1.057  1.00  0.00           H  
ATOM    921 HD13 LEU A  59     -19.288  -2.374  -1.609  1.00  0.00           H  
ATOM    922 HD21 LEU A  59     -21.285  -4.235  -3.063  1.00  0.00           H  
ATOM    923 HD22 LEU A  59     -21.624  -2.900  -1.963  1.00  0.00           H  
ATOM    924 HD23 LEU A  59     -22.260  -4.508  -1.619  1.00  0.00           H  
ATOM    925  N   ALA A  60     -18.982  -4.962  -4.388  1.00  0.00           N  
ATOM    926  CA  ALA A  60     -17.964  -4.469  -5.314  1.00  0.00           C  
ATOM    927  C   ALA A  60     -17.881  -2.946  -5.274  1.00  0.00           C  
ATOM    928  O   ALA A  60     -18.892  -2.274  -5.055  1.00  0.00           O  
ATOM    929  CB  ALA A  60     -18.264  -4.941  -6.728  1.00  0.00           C  
ATOM    930  H   ALA A  60     -19.825  -4.471  -4.303  1.00  0.00           H  
ATOM    931  HA  ALA A  60     -17.010  -4.881  -5.017  1.00  0.00           H  
ATOM    932  HB1 ALA A  60     -18.347  -6.016  -6.739  1.00  0.00           H  
ATOM    933  HB2 ALA A  60     -17.465  -4.634  -7.388  1.00  0.00           H  
ATOM    934  HB3 ALA A  60     -19.194  -4.505  -7.063  1.00  0.00           H  
ATOM    935  N   LEU A  61     -16.683  -2.405  -5.499  1.00  0.00           N  
ATOM    936  CA  LEU A  61     -16.461  -0.962  -5.469  1.00  0.00           C  
ATOM    937  C   LEU A  61     -15.143  -0.634  -6.161  1.00  0.00           C  
ATOM    938  O   LEU A  61     -14.471  -1.539  -6.662  1.00  0.00           O  
ATOM    939  CB  LEU A  61     -16.491  -0.428  -4.022  1.00  0.00           C  
ATOM    940  CG  LEU A  61     -15.568  -1.127  -3.021  1.00  0.00           C  
ATOM    941  CD1 LEU A  61     -14.175  -0.520  -3.038  1.00  0.00           C  
ATOM    942  CD2 LEU A  61     -16.157  -1.067  -1.620  1.00  0.00           C  
ATOM    943  H   LEU A  61     -15.922  -2.993  -5.712  1.00  0.00           H  
ATOM    944  HA  LEU A  61     -17.261  -0.499  -6.028  1.00  0.00           H  
ATOM    945  HB2 LEU A  61     -16.219   0.613  -4.046  1.00  0.00           H  
ATOM    946  HB3 LEU A  61     -17.503  -0.507  -3.656  1.00  0.00           H  
ATOM    947  HG  LEU A  61     -15.479  -2.162  -3.300  1.00  0.00           H  
ATOM    948 HD11 LEU A  61     -13.759  -0.604  -4.032  1.00  0.00           H  
ATOM    949 HD12 LEU A  61     -13.544  -1.047  -2.339  1.00  0.00           H  
ATOM    950 HD13 LEU A  61     -14.232   0.523  -2.760  1.00  0.00           H  
ATOM    951 HD21 LEU A  61     -16.259  -0.035  -1.316  1.00  0.00           H  
ATOM    952 HD22 LEU A  61     -15.505  -1.583  -0.929  1.00  0.00           H  
ATOM    953 HD23 LEU A  61     -17.128  -1.538  -1.619  1.00  0.00           H  
ATOM    954  N   ARG A  62     -14.774   0.642  -6.211  1.00  0.00           N  
ATOM    955  CA  ARG A  62     -13.554   1.038  -6.907  1.00  0.00           C  
ATOM    956  C   ARG A  62     -12.481   1.514  -5.958  1.00  0.00           C  
ATOM    957  O   ARG A  62     -12.718   1.758  -4.777  1.00  0.00           O  
ATOM    958  CB  ARG A  62     -13.813   2.151  -7.913  1.00  0.00           C  
ATOM    959  CG  ARG A  62     -14.844   1.795  -8.948  1.00  0.00           C  
ATOM    960  CD  ARG A  62     -14.481   0.542  -9.727  1.00  0.00           C  
ATOM    961  NE  ARG A  62     -13.216   0.669 -10.447  1.00  0.00           N  
ATOM    962  CZ  ARG A  62     -13.124   0.776 -11.772  1.00  0.00           C  
ATOM    963  NH1 ARG A  62     -14.221   0.927 -12.511  1.00  0.00           N  
ATOM    964  NH2 ARG A  62     -11.934   0.746 -12.356  1.00  0.00           N  
ATOM    965  H   ARG A  62     -15.322   1.325  -5.770  1.00  0.00           H  
ATOM    966  HA  ARG A  62     -13.186   0.175  -7.437  1.00  0.00           H  
ATOM    967  HB2 ARG A  62     -14.152   3.030  -7.387  1.00  0.00           H  
ATOM    968  HB3 ARG A  62     -12.887   2.382  -8.422  1.00  0.00           H  
ATOM    969  HG2 ARG A  62     -15.768   1.625  -8.439  1.00  0.00           H  
ATOM    970  HG3 ARG A  62     -14.946   2.620  -9.631  1.00  0.00           H  
ATOM    971  HD2 ARG A  62     -14.406  -0.286  -9.040  1.00  0.00           H  
ATOM    972  HD3 ARG A  62     -15.267   0.342 -10.441  1.00  0.00           H  
ATOM    973  HE  ARG A  62     -12.381   0.612  -9.915  1.00  0.00           H  
ATOM    974 HH11 ARG A  62     -15.122   0.964 -12.076  1.00  0.00           H  
ATOM    975 HH12 ARG A  62     -14.152   1.003 -13.512  1.00  0.00           H  
ATOM    976 HH21 ARG A  62     -11.106   0.643 -11.799  1.00  0.00           H  
ATOM    977 HH22 ARG A  62     -11.860   0.797 -13.359  1.00  0.00           H  
ATOM    978  N   ARG A  63     -11.307   1.681  -6.525  1.00  0.00           N  
ATOM    979  CA  ARG A  63     -10.130   2.141  -5.777  1.00  0.00           C  
ATOM    980  C   ARG A  63     -10.336   3.546  -5.220  1.00  0.00           C  
ATOM    981  O   ARG A  63      -9.849   3.870  -4.142  1.00  0.00           O  
ATOM    982  CB  ARG A  63      -8.871   2.128  -6.651  1.00  0.00           C  
ATOM    983  CG  ARG A  63      -8.851   3.184  -7.748  1.00  0.00           C  
ATOM    984  CD  ARG A  63      -7.582   3.101  -8.577  1.00  0.00           C  
ATOM    985  NE  ARG A  63      -7.529   4.130  -9.619  1.00  0.00           N  
ATOM    986  CZ  ARG A  63      -7.576   3.869 -10.931  1.00  0.00           C  
ATOM    987  NH1 ARG A  63      -7.810   2.634 -11.363  1.00  0.00           N  
ATOM    988  NH2 ARG A  63      -7.423   4.854 -11.811  1.00  0.00           N  
ATOM    989  H   ARG A  63     -11.224   1.455  -7.493  1.00  0.00           H  
ATOM    990  HA  ARG A  63      -9.985   1.464  -4.949  1.00  0.00           H  
ATOM    991  HB2 ARG A  63      -8.012   2.285  -6.019  1.00  0.00           H  
ATOM    992  HB3 ARG A  63      -8.787   1.159  -7.117  1.00  0.00           H  
ATOM    993  HG2 ARG A  63      -9.701   3.032  -8.395  1.00  0.00           H  
ATOM    994  HG3 ARG A  63      -8.912   4.164  -7.293  1.00  0.00           H  
ATOM    995  HD2 ARG A  63      -6.732   3.221  -7.921  1.00  0.00           H  
ATOM    996  HD3 ARG A  63      -7.537   2.128  -9.044  1.00  0.00           H  
ATOM    997  HE  ARG A  63      -7.417   5.067  -9.319  1.00  0.00           H  
ATOM    998 HH11 ARG A  63      -7.965   1.880 -10.699  1.00  0.00           H  
ATOM    999 HH12 ARG A  63      -7.815   2.432 -12.353  1.00  0.00           H  
ATOM   1000 HH21 ARG A  63      -7.260   5.796 -11.495  1.00  0.00           H  
ATOM   1001 HH22 ARG A  63      -7.479   4.664 -12.801  1.00  0.00           H  
ATOM   1002  N   LYS A  64     -11.042   4.379  -5.971  1.00  0.00           N  
ATOM   1003  CA  LYS A  64     -11.282   5.756  -5.560  1.00  0.00           C  
ATOM   1004  C   LYS A  64     -12.262   5.816  -4.398  1.00  0.00           C  
ATOM   1005  O   LYS A  64     -12.150   6.672  -3.524  1.00  0.00           O  
ATOM   1006  CB  LYS A  64     -11.807   6.566  -6.740  1.00  0.00           C  
ATOM   1007  CG  LYS A  64     -10.843   6.608  -7.912  1.00  0.00           C  
ATOM   1008  CD  LYS A  64     -11.334   7.530  -9.015  1.00  0.00           C  
ATOM   1009  CE  LYS A  64     -10.333   7.607 -10.153  1.00  0.00           C  
ATOM   1010  NZ  LYS A  64     -10.717   8.618 -11.173  1.00  0.00           N  
ATOM   1011  H   LYS A  64     -11.393   4.065  -6.826  1.00  0.00           H  
ATOM   1012  HA  LYS A  64     -10.340   6.173  -5.244  1.00  0.00           H  
ATOM   1013  HB2 LYS A  64     -12.735   6.131  -7.077  1.00  0.00           H  
ATOM   1014  HB3 LYS A  64     -11.989   7.577  -6.415  1.00  0.00           H  
ATOM   1015  HG2 LYS A  64      -9.885   6.961  -7.564  1.00  0.00           H  
ATOM   1016  HG3 LYS A  64     -10.737   5.610  -8.313  1.00  0.00           H  
ATOM   1017  HD2 LYS A  64     -12.271   7.153  -9.397  1.00  0.00           H  
ATOM   1018  HD3 LYS A  64     -11.480   8.519  -8.605  1.00  0.00           H  
ATOM   1019  HE2 LYS A  64      -9.368   7.873  -9.748  1.00  0.00           H  
ATOM   1020  HE3 LYS A  64     -10.268   6.639 -10.626  1.00  0.00           H  
ATOM   1021  HZ1 LYS A  64     -10.733   9.568 -10.747  1.00  0.00           H  
ATOM   1022  HZ2 LYS A  64     -11.665   8.407 -11.557  1.00  0.00           H  
ATOM   1023  HZ3 LYS A  64     -10.027   8.614 -11.957  1.00  0.00           H  
ATOM   1024  N   ASP A  65     -13.210   4.896  -4.392  1.00  0.00           N  
ATOM   1025  CA  ASP A  65     -14.172   4.792  -3.303  1.00  0.00           C  
ATOM   1026  C   ASP A  65     -13.501   4.167  -2.089  1.00  0.00           C  
ATOM   1027  O   ASP A  65     -13.749   4.554  -0.951  1.00  0.00           O  
ATOM   1028  CB  ASP A  65     -15.373   3.960  -3.759  1.00  0.00           C  
ATOM   1029  CG  ASP A  65     -16.501   3.921  -2.745  1.00  0.00           C  
ATOM   1030  OD1 ASP A  65     -17.006   4.999  -2.372  1.00  0.00           O  
ATOM   1031  OD2 ASP A  65     -16.903   2.806  -2.348  1.00  0.00           O  
ATOM   1032  H   ASP A  65     -13.268   4.268  -5.137  1.00  0.00           H  
ATOM   1033  HA  ASP A  65     -14.499   5.788  -3.044  1.00  0.00           H  
ATOM   1034  HB2 ASP A  65     -15.760   4.377  -4.677  1.00  0.00           H  
ATOM   1035  HB3 ASP A  65     -15.045   2.947  -3.943  1.00  0.00           H  
ATOM   1036  N   LEU A  66     -12.616   3.215  -2.353  1.00  0.00           N  
ATOM   1037  CA  LEU A  66     -11.815   2.597  -1.304  1.00  0.00           C  
ATOM   1038  C   LEU A  66     -10.883   3.618  -0.666  1.00  0.00           C  
ATOM   1039  O   LEU A  66     -10.550   3.525   0.513  1.00  0.00           O  
ATOM   1040  CB  LEU A  66     -10.985   1.452  -1.878  1.00  0.00           C  
ATOM   1041  CG  LEU A  66     -10.179   0.660  -0.849  1.00  0.00           C  
ATOM   1042  CD1 LEU A  66     -11.115  -0.139   0.044  1.00  0.00           C  
ATOM   1043  CD2 LEU A  66      -9.173  -0.246  -1.541  1.00  0.00           C  
ATOM   1044  H   LEU A  66     -12.514   2.902  -3.278  1.00  0.00           H  
ATOM   1045  HA  LEU A  66     -12.484   2.211  -0.552  1.00  0.00           H  
ATOM   1046  HB2 LEU A  66     -11.653   0.774  -2.384  1.00  0.00           H  
ATOM   1047  HB3 LEU A  66     -10.298   1.862  -2.601  1.00  0.00           H  
ATOM   1048  HG  LEU A  66      -9.634   1.351  -0.222  1.00  0.00           H  
ATOM   1049 HD11 LEU A  66     -11.782   0.535   0.560  1.00  0.00           H  
ATOM   1050 HD12 LEU A  66     -10.535  -0.695   0.767  1.00  0.00           H  
ATOM   1051 HD13 LEU A  66     -11.690  -0.825  -0.560  1.00  0.00           H  
ATOM   1052 HD21 LEU A  66      -8.472   0.356  -2.099  1.00  0.00           H  
ATOM   1053 HD22 LEU A  66      -9.692  -0.913  -2.214  1.00  0.00           H  
ATOM   1054 HD23 LEU A  66      -8.640  -0.825  -0.801  1.00  0.00           H  
ATOM   1055  N   ALA A  67     -10.471   4.598  -1.459  1.00  0.00           N  
ATOM   1056  CA  ALA A  67      -9.551   5.630  -0.998  1.00  0.00           C  
ATOM   1057  C   ALA A  67     -10.201   6.539   0.038  1.00  0.00           C  
ATOM   1058  O   ALA A  67      -9.528   7.360   0.655  1.00  0.00           O  
ATOM   1059  CB  ALA A  67      -9.043   6.448  -2.175  1.00  0.00           C  
ATOM   1060  H   ALA A  67     -10.786   4.618  -2.386  1.00  0.00           H  
ATOM   1061  HA  ALA A  67      -8.704   5.137  -0.545  1.00  0.00           H  
ATOM   1062  HB1 ALA A  67      -8.603   5.787  -2.905  1.00  0.00           H  
ATOM   1063  HB2 ALA A  67      -8.298   7.151  -1.831  1.00  0.00           H  
ATOM   1064  HB3 ALA A  67      -9.867   6.984  -2.621  1.00  0.00           H  
ATOM   1065  N   LEU A  68     -11.510   6.404   0.215  1.00  0.00           N  
ATOM   1066  CA  LEU A  68     -12.224   7.154   1.240  1.00  0.00           C  
ATOM   1067  C   LEU A  68     -12.289   6.357   2.541  1.00  0.00           C  
ATOM   1068  O   LEU A  68     -12.742   6.858   3.571  1.00  0.00           O  
ATOM   1069  CB  LEU A  68     -13.633   7.487   0.753  1.00  0.00           C  
ATOM   1070  CG  LEU A  68     -13.700   8.274  -0.559  1.00  0.00           C  
ATOM   1071  CD1 LEU A  68     -15.135   8.368  -1.045  1.00  0.00           C  
ATOM   1072  CD2 LEU A  68     -13.109   9.664  -0.378  1.00  0.00           C  
ATOM   1073  H   LEU A  68     -12.016   5.789  -0.370  1.00  0.00           H  
ATOM   1074  HA  LEU A  68     -11.686   8.071   1.423  1.00  0.00           H  
ATOM   1075  HB2 LEU A  68     -14.173   6.561   0.621  1.00  0.00           H  
ATOM   1076  HB3 LEU A  68     -14.128   8.066   1.517  1.00  0.00           H  
ATOM   1077  HG  LEU A  68     -13.123   7.757  -1.313  1.00  0.00           H  
ATOM   1078 HD11 LEU A  68     -15.736   8.860  -0.295  1.00  0.00           H  
ATOM   1079 HD12 LEU A  68     -15.522   7.375  -1.223  1.00  0.00           H  
ATOM   1080 HD13 LEU A  68     -15.168   8.938  -1.962  1.00  0.00           H  
ATOM   1081 HD21 LEU A  68     -13.670  10.196   0.378  1.00  0.00           H  
ATOM   1082 HD22 LEU A  68     -13.165  10.203  -1.313  1.00  0.00           H  
ATOM   1083 HD23 LEU A  68     -12.078   9.581  -0.070  1.00  0.00           H  
ATOM   1084  N   LEU A  69     -11.808   5.122   2.492  1.00  0.00           N  
ATOM   1085  CA  LEU A  69     -11.834   4.243   3.648  1.00  0.00           C  
ATOM   1086  C   LEU A  69     -10.426   3.822   4.044  1.00  0.00           C  
ATOM   1087  O   LEU A  69      -9.511   3.808   3.221  1.00  0.00           O  
ATOM   1088  CB  LEU A  69     -12.667   2.989   3.346  1.00  0.00           C  
ATOM   1089  CG  LEU A  69     -14.147   3.233   3.043  1.00  0.00           C  
ATOM   1090  CD1 LEU A  69     -14.822   1.936   2.629  1.00  0.00           C  
ATOM   1091  CD2 LEU A  69     -14.851   3.837   4.253  1.00  0.00           C  
ATOM   1092  H   LEU A  69     -11.413   4.795   1.653  1.00  0.00           H  
ATOM   1093  HA  LEU A  69     -12.287   4.778   4.469  1.00  0.00           H  
ATOM   1094  HB2 LEU A  69     -12.227   2.492   2.493  1.00  0.00           H  
ATOM   1095  HB3 LEU A  69     -12.601   2.329   4.197  1.00  0.00           H  
ATOM   1096  HG  LEU A  69     -14.231   3.931   2.223  1.00  0.00           H  
ATOM   1097 HD11 LEU A  69     -15.863   2.124   2.418  1.00  0.00           H  
ATOM   1098 HD12 LEU A  69     -14.741   1.215   3.429  1.00  0.00           H  
ATOM   1099 HD13 LEU A  69     -14.340   1.546   1.742  1.00  0.00           H  
ATOM   1100 HD21 LEU A  69     -14.802   3.145   5.083  1.00  0.00           H  
ATOM   1101 HD22 LEU A  69     -15.884   4.031   4.009  1.00  0.00           H  
ATOM   1102 HD23 LEU A  69     -14.366   4.762   4.528  1.00  0.00           H  
ATOM   1103  N   THR A  70     -10.252   3.502   5.310  1.00  0.00           N  
ATOM   1104  CA  THR A  70      -9.018   2.900   5.783  1.00  0.00           C  
ATOM   1105  C   THR A  70      -9.290   1.468   6.242  1.00  0.00           C  
ATOM   1106  O   THR A  70     -10.120   1.239   7.130  1.00  0.00           O  
ATOM   1107  CB  THR A  70      -8.404   3.705   6.939  1.00  0.00           C  
ATOM   1108  OG1 THR A  70      -8.364   5.098   6.600  1.00  0.00           O  
ATOM   1109  CG2 THR A  70      -6.995   3.218   7.257  1.00  0.00           C  
ATOM   1110  H   THR A  70     -10.976   3.684   5.953  1.00  0.00           H  
ATOM   1111  HA  THR A  70      -8.315   2.882   4.965  1.00  0.00           H  
ATOM   1112  HB  THR A  70      -9.019   3.567   7.811  1.00  0.00           H  
ATOM   1113  HG1 THR A  70      -8.861   5.603   7.255  1.00  0.00           H  
ATOM   1114 HG21 THR A  70      -6.372   3.322   6.381  1.00  0.00           H  
ATOM   1115 HG22 THR A  70      -7.031   2.180   7.552  1.00  0.00           H  
ATOM   1116 HG23 THR A  70      -6.582   3.806   8.065  1.00  0.00           H  
ATOM   1117  N   LEU A  71      -8.608   0.515   5.629  1.00  0.00           N  
ATOM   1118  CA  LEU A  71      -8.842  -0.895   5.916  1.00  0.00           C  
ATOM   1119  C   LEU A  71      -7.749  -1.475   6.798  1.00  0.00           C  
ATOM   1120  O   LEU A  71      -6.583  -1.088   6.709  1.00  0.00           O  
ATOM   1121  CB  LEU A  71      -8.923  -1.714   4.623  1.00  0.00           C  
ATOM   1122  CG  LEU A  71     -10.049  -1.337   3.661  1.00  0.00           C  
ATOM   1123  CD1 LEU A  71     -10.082  -2.301   2.489  1.00  0.00           C  
ATOM   1124  CD2 LEU A  71     -11.391  -1.311   4.374  1.00  0.00           C  
ATOM   1125  H   LEU A  71      -7.914   0.764   4.976  1.00  0.00           H  
ATOM   1126  HA  LEU A  71      -9.786  -0.974   6.436  1.00  0.00           H  
ATOM   1127  HB2 LEU A  71      -7.987  -1.603   4.096  1.00  0.00           H  
ATOM   1128  HB3 LEU A  71      -9.043  -2.756   4.888  1.00  0.00           H  
ATOM   1129  HG  LEU A  71      -9.858  -0.348   3.271  1.00  0.00           H  
ATOM   1130 HD11 LEU A  71     -10.253  -3.306   2.849  1.00  0.00           H  
ATOM   1131 HD12 LEU A  71      -9.137  -2.261   1.966  1.00  0.00           H  
ATOM   1132 HD13 LEU A  71     -10.878  -2.020   1.816  1.00  0.00           H  
ATOM   1133 HD21 LEU A  71     -12.166  -1.055   3.668  1.00  0.00           H  
ATOM   1134 HD22 LEU A  71     -11.363  -0.576   5.163  1.00  0.00           H  
ATOM   1135 HD23 LEU A  71     -11.595  -2.285   4.796  1.00  0.00           H  
ATOM   1136  N   VAL A  72      -8.143  -2.408   7.646  1.00  0.00           N  
ATOM   1137  CA  VAL A  72      -7.206  -3.163   8.462  1.00  0.00           C  
ATOM   1138  C   VAL A  72      -7.488  -4.655   8.319  1.00  0.00           C  
ATOM   1139  O   VAL A  72      -8.578  -5.128   8.641  1.00  0.00           O  
ATOM   1140  CB  VAL A  72      -7.269  -2.763   9.955  1.00  0.00           C  
ATOM   1141  CG1 VAL A  72      -6.666  -1.383  10.172  1.00  0.00           C  
ATOM   1142  CG2 VAL A  72      -8.701  -2.802  10.472  1.00  0.00           C  
ATOM   1143  H   VAL A  72      -9.104  -2.606   7.718  1.00  0.00           H  
ATOM   1144  HA  VAL A  72      -6.210  -2.961   8.096  1.00  0.00           H  
ATOM   1145  HB  VAL A  72      -6.689  -3.477  10.522  1.00  0.00           H  
ATOM   1146 HG11 VAL A  72      -7.218  -0.655   9.595  1.00  0.00           H  
ATOM   1147 HG12 VAL A  72      -5.634  -1.385   9.852  1.00  0.00           H  
ATOM   1148 HG13 VAL A  72      -6.718  -1.126  11.221  1.00  0.00           H  
ATOM   1149 HG21 VAL A  72      -9.310  -2.123   9.892  1.00  0.00           H  
ATOM   1150 HG22 VAL A  72      -8.718  -2.502  11.509  1.00  0.00           H  
ATOM   1151 HG23 VAL A  72      -9.091  -3.805  10.380  1.00  0.00           H  
ATOM   1152  N   PRO A  73      -6.524  -5.421   7.802  1.00  0.00           N  
ATOM   1153  CA  PRO A  73      -6.703  -6.854   7.592  1.00  0.00           C  
ATOM   1154  C   PRO A  73      -6.733  -7.618   8.908  1.00  0.00           C  
ATOM   1155  O   PRO A  73      -6.319  -7.097   9.948  1.00  0.00           O  
ATOM   1156  CB  PRO A  73      -5.468  -7.265   6.773  1.00  0.00           C  
ATOM   1157  CG  PRO A  73      -4.783  -5.992   6.383  1.00  0.00           C  
ATOM   1158  CD  PRO A  73      -5.191  -4.964   7.394  1.00  0.00           C  
ATOM   1159  HA  PRO A  73      -7.600  -7.066   7.030  1.00  0.00           H  
ATOM   1160  HB2 PRO A  73      -4.823  -7.883   7.382  1.00  0.00           H  
ATOM   1161  HB3 PRO A  73      -5.782  -7.823   5.903  1.00  0.00           H  
ATOM   1162  HG2 PRO A  73      -3.713  -6.132   6.403  1.00  0.00           H  
ATOM   1163  HG3 PRO A  73      -5.104  -5.695   5.396  1.00  0.00           H  
ATOM   1164  HD2 PRO A  73      -4.507  -4.964   8.232  1.00  0.00           H  
ATOM   1165  HD3 PRO A  73      -5.238  -3.984   6.942  1.00  0.00           H  
ATOM   1166  N   LEU A  74      -7.231  -8.847   8.863  1.00  0.00           N  
ATOM   1167  CA  LEU A  74      -7.175  -9.733  10.016  1.00  0.00           C  
ATOM   1168  C   LEU A  74      -5.723  -9.931  10.439  1.00  0.00           C  
ATOM   1169  O   LEU A  74      -5.384  -9.806  11.618  1.00  0.00           O  
ATOM   1170  CB  LEU A  74      -7.812 -11.081   9.685  1.00  0.00           C  
ATOM   1171  CG  LEU A  74      -9.308 -11.038   9.370  1.00  0.00           C  
ATOM   1172  CD1 LEU A  74      -9.821 -12.432   9.057  1.00  0.00           C  
ATOM   1173  CD2 LEU A  74     -10.083 -10.430  10.529  1.00  0.00           C  
ATOM   1174  H   LEU A  74      -7.671  -9.159   8.042  1.00  0.00           H  
ATOM   1175  HA  LEU A  74      -7.719  -9.269  10.823  1.00  0.00           H  
ATOM   1176  HB2 LEU A  74      -7.300 -11.497   8.830  1.00  0.00           H  
ATOM   1177  HB3 LEU A  74      -7.664 -11.734  10.524  1.00  0.00           H  
ATOM   1178  HG  LEU A  74      -9.466 -10.419   8.498  1.00  0.00           H  
ATOM   1179 HD11 LEU A  74     -10.881 -12.390   8.859  1.00  0.00           H  
ATOM   1180 HD12 LEU A  74      -9.638 -13.082   9.902  1.00  0.00           H  
ATOM   1181 HD13 LEU A  74      -9.307 -12.817   8.189  1.00  0.00           H  
ATOM   1182 HD21 LEU A  74     -11.139 -10.437  10.298  1.00  0.00           H  
ATOM   1183 HD22 LEU A  74      -9.757  -9.413  10.686  1.00  0.00           H  
ATOM   1184 HD23 LEU A  74      -9.907 -11.007  11.423  1.00  0.00           H  
ATOM   1185  N   ASP A  75      -4.882 -10.225   9.457  1.00  0.00           N  
ATOM   1186  CA  ASP A  75      -3.446 -10.336   9.663  1.00  0.00           C  
ATOM   1187  C   ASP A  75      -2.710  -9.697   8.496  1.00  0.00           C  
ATOM   1188  O   ASP A  75      -2.476  -8.470   8.544  1.00  0.00           O  
ATOM   1189  CB  ASP A  75      -3.021 -11.800   9.821  1.00  0.00           C  
ATOM   1190  CG  ASP A  75      -3.230 -12.317  11.226  1.00  0.00           C  
ATOM   1191  OD1 ASP A  75      -4.335 -12.813  11.532  1.00  0.00           O  
ATOM   1192  OD2 ASP A  75      -2.289 -12.222  12.041  1.00  0.00           O  
ATOM   1193  OXT ASP A  75      -2.393 -10.415   7.523  1.00  0.00           O  
ATOM   1194  H   ASP A  75      -5.239 -10.372   8.558  1.00  0.00           H  
ATOM   1195  HA  ASP A  75      -3.200  -9.799  10.566  1.00  0.00           H  
ATOM   1196  HB2 ASP A  75      -3.600 -12.410   9.145  1.00  0.00           H  
ATOM   1197  HB3 ASP A  75      -1.974 -11.892   9.575  1.00  0.00           H  
TER    1198      ASP A  75                                                      
END
MOLECULE T0462_77_143.pdb
ATOM   1204  N   GLU    77      -2.454  -0.642   9.985  1.00 11.51           N 
ATOM   1205  CA  GLU    77      -3.612  -0.786   9.094  1.00 13.44           C 
ATOM   1206  C   GLU    77      -3.312  -0.215   7.697  1.00  2.42           C 
ATOM   1207  O   GLU    77      -2.423   0.626   7.539  1.00 25.04           O 
ATOM   1208  CB  GLU    77      -4.862  -0.141   9.730  1.00 44.40           C 
ATOM   1209  CG  GLU    77      -4.619   1.193  10.448  1.00 34.41           C 
ATOM   1210  CD  GLU    77      -4.730   2.413   9.544  1.00 50.11           C 
ATOM   1211  OE1 GLU    77      -3.899   3.342   9.674  1.00 42.31           O 
ATOM   1212  OE2 GLU    77      -5.670   2.469   8.730  1.00 32.01           O 
ATOM   1213  H   GLU    77      -1.869   0.136   9.876  1.00 36.29           H 
ATOM   1214  HA  GLU    77      -3.795  -1.847   8.981  1.00 15.42           H 
ATOM   1215 3HB  GLU    77      -5.272  -0.837  10.449  1.00 36.29           H 
ATOM   1216 2HB  GLU    77      -5.600   0.023   8.957  1.00 36.29           H 
ATOM   1217 3HG  GLU    77      -3.628   1.173  10.883  1.00 36.29           H 
ATOM   1218 2HG  GLU    77      -5.349   1.296  11.240  1.00 36.29           H 
ATOM   1219  N   LEU    78      -4.045  -0.688   6.685  1.00 42.42           N 
ATOM   1220  CA  LEU    78      -3.726  -0.377   5.282  1.00 60.21           C 
ATOM   1221  C   LEU    78      -4.996  -0.222   4.419  1.00 62.54           C 
ATOM   1222  O   LEU    78      -6.044  -0.782   4.736  1.00  4.41           O 
ATOM   1223  CB  LEU    78      -2.814  -1.473   4.686  1.00 61.43           C 
ATOM   1224  CG  LEU    78      -3.447  -2.870   4.491  1.00 11.44           C 
ATOM   1225  CD1 LEU    78      -2.505  -3.774   3.701  1.00 12.40           C 
ATOM   1226  CD2 LEU    78      -3.799  -3.519   5.833  1.00 74.53           C 
ATOM   1227  H   LEU    78      -4.830  -1.244   6.884  1.00 36.29           H 
ATOM   1228  HA  LEU    78      -3.189   0.561   5.269  1.00 44.34           H 
ATOM   1229 3HB  LEU    78      -1.956  -1.581   5.336  1.00 36.29           H 
ATOM   1230 2HB  LEU    78      -2.465  -1.127   3.723  1.00 36.29           H 
ATOM   1231  HG  LEU    78      -4.358  -2.767   3.919  1.00 65.12           H 
ATOM   1232 1HD1 LEU    78      -2.985  -4.725   3.521  1.00 36.29           H 
ATOM   1233 2HD1 LEU    78      -1.595  -3.932   4.264  1.00 36.29           H 
ATOM   1234 3HD1 LEU    78      -2.265  -3.308   2.756  1.00 36.29           H 
ATOM   1235 1HD2 LEU    78      -4.537  -2.918   6.341  1.00 36.29           H 
ATOM   1236 2HD2 LEU    78      -2.912  -3.593   6.445  1.00 36.29           H 
ATOM   1237 3HD2 LEU    78      -4.200  -4.508   5.661  1.00 36.29           H 
ATOM   1238  N   PRO    79      -4.915   0.544   3.306  1.00 33.21           N 
ATOM   1239  CA  PRO    79      -6.069   0.774   2.413  1.00  3.41           C 
ATOM   1240  C   PRO    79      -6.473  -0.476   1.601  1.00 53.44           C 
ATOM   1241  O   PRO    79      -5.633  -1.315   1.265  1.00 30.11           O 
ATOM   1242  CB  PRO    79      -5.572   1.889   1.482  1.00 60.14           C 
ATOM   1243  CG  PRO    79      -4.091   1.726   1.458  1.00  3.44           C 
ATOM   1244  CD  PRO    79      -3.705   1.251   2.834  1.00 21.25           C 
ATOM   1245  HA  PRO    79      -6.926   1.127   2.970  1.00 32.11           H 
ATOM   1246 3HB  PRO    79      -5.852   2.854   1.884  1.00 36.29           H 
ATOM   1247 2HB  PRO    79      -6.001   1.766   0.497  1.00 36.29           H 
ATOM   1248 3HG  PRO    79      -3.618   2.673   1.241  1.00 36.29           H 
ATOM   1249 2HG  PRO    79      -3.814   0.990   0.716  1.00 36.29           H 
ATOM   1250 3HD  PRO    79      -3.475   2.091   3.474  1.00 36.29           H 
ATOM   1251 2HD  PRO    79      -2.861   0.577   2.779  1.00 36.29           H 
ATOM   1252  N   LEU    80      -7.765  -0.571   1.270  1.00 10.14           N 
ATOM   1253  CA  LEU    80      -8.322  -1.726   0.538  1.00 12.24           C 
ATOM   1254  C   LEU    80      -7.531  -2.084  -0.732  1.00 71.04           C 
ATOM   1255  O   LEU    80      -7.179  -3.245  -0.943  1.00 34.43           O 
ATOM   1256  CB  LEU    80      -9.787  -1.452   0.162  1.00 13.14           C 
ATOM   1257  CG  LEU    80     -10.808  -1.614   1.299  1.00 54.21           C 
ATOM   1258  CD1 LEU    80     -12.201  -1.194   0.838  1.00 12.24           C 
ATOM   1259  CD2 LEU    80     -10.824  -3.057   1.801  1.00 34.31           C 
ATOM   1260  H   LEU    80      -8.371   0.157   1.533  1.00 36.29           H 
ATOM   1261  HA  LEU    80      -8.296  -2.574   1.206  1.00 73.22           H 
ATOM   1262 3HB  LEU    80     -10.066  -2.124  -0.639  1.00 36.29           H 
ATOM   1263 2HB  LEU    80      -9.855  -0.438  -0.210  1.00 36.29           H 
ATOM   1264  HG  LEU    80     -10.523  -0.976   2.125  1.00 14.14           H 
ATOM   1265 1HD1 LEU    80     -12.900  -1.307   1.654  1.00 36.29           H 
ATOM   1266 2HD1 LEU    80     -12.514  -1.813   0.008  1.00 36.29           H 
ATOM   1267 3HD1 LEU    80     -12.181  -0.159   0.526  1.00 36.29           H 
ATOM   1268 1HD2 LEU    80     -11.535  -3.148   2.610  1.00 36.29           H 
ATOM   1269 2HD2 LEU    80      -9.841  -3.325   2.157  1.00 36.29           H 
ATOM   1270 3HD2 LEU    80     -11.109  -3.720   0.996  1.00 36.29           H 
ATOM   1271  N   ILE    81      -7.255  -1.088  -1.570  1.00 44.14           N 
ATOM   1272  CA  ILE    81      -6.604  -1.322  -2.871  1.00 50.44           C 
ATOM   1273  C   ILE    81      -5.189  -1.920  -2.721  1.00 33.22           C 
ATOM   1274  O   ILE    81      -4.653  -2.514  -3.657  1.00 43.13           O 
ATOM   1275  CB  ILE    81      -6.528  -0.010  -3.698  1.00 35.34           C 
ATOM   1276  CG1 ILE    81      -6.096  -0.294  -5.148  1.00 45.22           C 
ATOM   1277  CG2 ILE    81      -5.576   0.987  -3.044  1.00 11.34           C 
ATOM   1278  CD1 ILE    81      -7.036  -1.214  -5.900  1.00  2.11           C 
ATOM   1279  H   ILE    81      -7.502  -0.174  -1.317  1.00 36.29           H 
ATOM   1280  HA  ILE    81      -7.218  -2.025  -3.417  1.00  3.54           H 
ATOM   1281  HB  ILE    81      -7.513   0.435  -3.708  1.00 64.25           H 
ATOM   1282 3HG1 ILE    81      -5.116  -0.753  -5.144  1.00 36.29           H 
ATOM   1283 2HG1 ILE    81      -6.047   0.637  -5.692  1.00 36.29           H 
ATOM   1284 1HG2 ILE    81      -5.915   1.203  -2.040  1.00 36.29           H 
ATOM   1285 2HG2 ILE    81      -5.556   1.901  -3.620  1.00 36.29           H 
ATOM   1286 3HG2 ILE    81      -4.583   0.565  -3.003  1.00 36.29           H 
ATOM   1287 1HD1 ILE    81      -7.069  -2.176  -5.410  1.00 36.29           H 
ATOM   1288 2HD1 ILE    81      -6.681  -1.338  -6.912  1.00 36.29           H 
ATOM   1289 3HD1 ILE    81      -8.027  -0.784  -5.915  1.00 36.29           H 
ATOM   1290  N   LEU    82      -4.590  -1.765  -1.542  1.00 13.21           N 
ATOM   1291  CA  LEU    82      -3.229  -2.263  -1.295  1.00 75.44           C 
ATOM   1292  C   LEU    82      -3.235  -3.478  -0.352  1.00 14.20           C 
ATOM   1293  O   LEU    82      -2.176  -3.964   0.063  1.00 74.13           O 
ATOM   1294  CB  LEU    82      -2.366  -1.146  -0.695  1.00 53.44           C 
ATOM   1295  CG  LEU    82      -2.352   0.178  -1.474  1.00 23.25           C 
ATOM   1296  CD1 LEU    82      -1.386   1.167  -0.831  1.00 12.00           C 
ATOM   1297  CD2 LEU    82      -2.003  -0.053  -2.944  1.00 23.35           C 
ATOM   1298  H   LEU    82      -5.070  -1.312  -0.819  1.00 36.29           H 
ATOM   1299  HA  LEU    82      -2.804  -2.562  -2.243  1.00 41.41           H 
ATOM   1300 3HB  LEU    82      -1.349  -1.508  -0.628  1.00 36.29           H 
ATOM   1301 2HB  LEU    82      -2.723  -0.944   0.306  1.00 36.29           H 
ATOM   1302  HG  LEU    82      -3.341   0.615  -1.434  1.00 42.03           H 
ATOM   1303 1HD1 LEU    82      -1.403   2.098  -1.381  1.00 36.29           H 
ATOM   1304 2HD1 LEU    82      -0.385   0.760  -0.844  1.00 36.29           H 
ATOM   1305 3HD1 LEU    82      -1.686   1.348   0.191  1.00 36.29           H 
ATOM   1306 1HD2 LEU    82      -1.038  -0.530  -3.018  1.00 36.29           H 
ATOM   1307 2HD2 LEU    82      -1.974   0.897  -3.460  1.00 36.29           H 
ATOM   1308 3HD2 LEU    82      -2.754  -0.683  -3.398  1.00 36.29           H 
ATOM   1309  N   ALA    83      -4.428  -3.973  -0.032  1.00 32.45           N 
ATOM   1310  CA  ALA    83      -4.592  -5.071   0.925  1.00 15.43           C 
ATOM   1311  C   ALA    83      -4.014  -6.403   0.410  1.00 54.30           C 
ATOM   1312  O   ALA    83      -3.799  -6.591  -0.789  1.00 23.30           O 
ATOM   1313  CB  ALA    83      -6.067  -5.236   1.279  1.00 62.03           C 
ATOM   1314  H   ALA    83      -5.227  -3.589  -0.453  1.00 36.29           H 
ATOM   1315  HA  ALA    83      -4.066  -4.796   1.829  1.00  1.41           H 
ATOM   1316 1HB  ALA    83      -6.462  -4.293   1.627  1.00 36.29           H 
ATOM   1317 2HB  ALA    83      -6.170  -5.977   2.061  1.00 36.29           H 
ATOM   1318 3HB  ALA    83      -6.616  -5.558   0.406  1.00 36.29           H 
ATOM   1319  N   ASP    84      -3.760  -7.320   1.339  1.00 24.33           N 
ATOM   1320  CA  ASP    84      -3.272  -8.663   1.014  1.00 10.43           C 
ATOM   1321  C   ASP    84      -4.400  -9.512   0.385  1.00 31.22           C 
ATOM   1322  O   ASP    84      -4.529  -9.582  -0.842  1.00  1.44           O 
ATOM   1323  CB  ASP    84      -2.725  -9.313   2.296  1.00 12.14           C 
ATOM   1324  CG  ASP    84      -2.271 -10.747   2.104  1.00 72.45           C 
ATOM   1325  OD1 ASP    84      -3.012 -11.668   2.515  1.00 44.41           O 
ATOM   1326  OD2 ASP    84      -1.169 -10.955   1.558  1.00 25.23           O 
ATOM   1327  H   ASP    84      -3.901  -7.087   2.281  1.00 36.29           H 
ATOM   1328  HA  ASP    84      -2.469  -8.563   0.297  1.00 73.24           H 
ATOM   1329 3HB  ASP    84      -3.498  -9.296   3.051  1.00 36.29           H 
ATOM   1330 2HB  ASP    84      -1.883  -8.736   2.646  1.00 36.29           H 
ATOM   1331  N   ASP    85      -5.236 -10.120   1.232  1.00 43.24           N 
ATOM   1332  CA  ASP    85      -6.389 -10.904   0.774  1.00 10.24           C 
ATOM   1333  C   ASP    85      -7.229 -11.390   1.973  1.00  1.54           C 
ATOM   1334  O   ASP    85      -6.831 -11.223   3.127  1.00  0.32           O 
ATOM   1335  CB  ASP    85      -5.918 -12.100  -0.067  1.00 10.35           C 
ATOM   1336  CG  ASP    85      -7.046 -12.723  -0.867  1.00 21.21           C 
ATOM   1337  OD1 ASP    85      -7.689 -13.662  -0.366  1.00 45.32           O 
ATOM   1338  OD2 ASP    85      -7.309 -12.253  -1.993  1.00 50.25           O 
ATOM   1339  H   ASP    85      -5.066 -10.052   2.195  1.00 36.29           H 
ATOM   1340  HA  ASP    85      -7.004 -10.260   0.160  1.00  3.02           H 
ATOM   1341 3HB  ASP    85      -5.500 -12.853   0.587  1.00 36.29           H 
ATOM   1342 2HB  ASP    85      -5.153 -11.769  -0.756  1.00 36.29           H 
ATOM   1343  N   GLY    86      -8.394 -11.971   1.690  1.00 44.14           N 
ATOM   1344  CA  GLY    86      -9.235 -12.538   2.741  1.00 21.12           C 
ATOM   1345  C   GLY    86     -10.194 -11.536   3.378  1.00 41.53           C 
ATOM   1346  O   GLY    86     -10.603 -10.553   2.752  1.00 64.33           O 
ATOM   1347  H   GLY    86      -8.685 -12.028   0.756  1.00 36.29           H 
ATOM   1348 3HA  GLY    86      -8.598 -12.948   3.513  1.00 36.29           H 
ATOM   1349 2HA  GLY    86      -9.816 -13.343   2.314  1.00 36.29           H 
ATOM   1350  N   THR    87     -10.558 -11.795   4.635  1.00 35.13           N 
ATOM   1351  CA  THR    87     -11.509 -10.952   5.372  1.00 72.12           C 
ATOM   1352  C   THR    87     -10.799  -9.812   6.129  1.00 24.21           C 
ATOM   1353  O   THR    87      -9.826 -10.043   6.858  1.00 41.52           O 
ATOM   1354  CB  THR    87     -12.318 -11.785   6.400  1.00  0.32           C 
ATOM   1355  OG1 THR    87     -12.695 -13.054   5.838  1.00 42.15           O 
ATOM   1356  CG2 THR    87     -13.571 -11.036   6.845  1.00 42.41           C 
ATOM   1357  H   THR    87     -10.189 -12.586   5.077  1.00 36.29           H 
ATOM   1358  HA  THR    87     -12.203 -10.525   4.660  1.00 32.51           H 
ATOM   1359  HB  THR    87     -11.696 -11.961   7.268  1.00  2.24           H 
ATOM   1360  HG1 THR    87     -13.011 -12.935   4.931  1.00 64.23           H 
ATOM   1361 1HG2 THR    87     -14.114 -11.637   7.560  1.00 36.29           H 
ATOM   1362 2HG2 THR    87     -14.199 -10.838   5.989  1.00 36.29           H 
ATOM   1363 3HG2 THR    87     -13.288 -10.100   7.309  1.00 36.29           H 
ATOM   1364  N   TYR    88     -11.299  -8.585   5.964  1.00  4.25           N 
ATOM   1365  CA  TYR    88     -10.751  -7.403   6.652  1.00 21.51           C 
ATOM   1366  C   TYR    88     -11.807  -6.696   7.502  1.00 53.21           C 
ATOM   1367  O   TYR    88     -12.994  -6.942   7.359  1.00 53.41           O 
ATOM   1368  CB  TYR    88     -10.188  -6.406   5.634  1.00 52.03           C 
ATOM   1369  CG  TYR    88      -8.939  -6.890   4.940  1.00 31.22           C 
ATOM   1370  CD1 TYR    88      -9.013  -7.749   3.853  1.00 74.10           C 
ATOM   1371  CD2 TYR    88      -7.682  -6.496   5.382  1.00 54.22           C 
ATOM   1372  CE1 TYR    88      -7.874  -8.199   3.229  1.00 43.52           C 
ATOM   1373  CE2 TYR    88      -6.538  -6.941   4.759  1.00 42.24           C 
ATOM   1374  CZ  TYR    88      -6.642  -7.794   3.687  1.00 14.22           C 
ATOM   1375  OH  TYR    88      -5.509  -8.243   3.067  1.00 72.21           O 
ATOM   1376  H   TYR    88     -12.058  -8.465   5.355  1.00 36.29           H 
ATOM   1377  HA  TYR    88      -9.949  -7.733   7.299  1.00 13.41           H 
ATOM   1378 3HB  TYR    88      -9.950  -5.480   6.142  1.00 36.29           H 
ATOM   1379 2HB  TYR    88     -10.936  -6.210   4.877  1.00 36.29           H 
ATOM   1380  HD1 TYR    88      -9.983  -8.066   3.498  1.00 20.13           H 
ATOM   1381  HD2 TYR    88      -7.608  -5.825   6.225  1.00 62.02           H 
ATOM   1382  HE1 TYR    88      -7.950  -8.866   2.384  1.00 32.42           H 
ATOM   1383  HE2 TYR    88      -5.568  -6.625   5.117  1.00  4.31           H 
ATOM   1384  HH  TYR    88      -5.635  -8.200   2.112  1.00 71.22           H 
ATOM   1385  N   GLU    89     -11.354  -5.812   8.384  1.00 22.34           N 
ATOM   1386  CA  GLU    89     -12.251  -4.984   9.201  1.00 23.21           C 
ATOM   1387  C   GLU    89     -11.974  -3.490   8.965  1.00 54.21           C 
ATOM   1388  O   GLU    89     -10.836  -3.037   9.092  1.00 64.32           O 
ATOM   1389  CB  GLU    89     -12.069  -5.321  10.687  1.00 22.21           C 
ATOM   1390  CG  GLU    89     -12.930  -4.480  11.626  1.00 63.13           C 
ATOM   1391  CD  GLU    89     -12.663  -4.780  13.092  1.00 60.50           C 
ATOM   1392  OE1 GLU    89     -13.470  -5.499  13.719  1.00 25.53           O 
ATOM   1393  OE2 GLU    89     -11.647  -4.290  13.623  1.00 33.14           O 
ATOM   1394  H   GLU    89     -10.386  -5.716   8.500  1.00 36.29           H 
ATOM   1395  HA  GLU    89     -13.270  -5.201   8.910  1.00 11.21           H 
ATOM   1396 3HB  GLU    89     -11.032  -5.172  10.954  1.00 36.29           H 
ATOM   1397 2HB  GLU    89     -12.321  -6.362  10.840  1.00 36.29           H 
ATOM   1398 3HG  GLU    89     -13.972  -4.676  11.413  1.00 36.29           H 
ATOM   1399 2HG  GLU    89     -12.720  -3.435  11.445  1.00 36.29           H 
ATOM   1400  N   ILE    90     -13.009  -2.728   8.613  1.00 11.51           N 
ATOM   1401  CA  ILE    90     -12.846  -1.290   8.346  1.00 53.30           C 
ATOM   1402  C   ILE    90     -12.498  -0.498   9.622  1.00 34.11           C 
ATOM   1403  O   ILE    90     -13.180  -0.604  10.649  1.00 11.23           O 
ATOM   1404  CB  ILE    90     -14.111  -0.683   7.683  1.00 24.24           C 
ATOM   1405  CG1 ILE    90     -13.926   0.830   7.453  1.00 14.23           C 
ATOM   1406  CG2 ILE    90     -15.355  -0.960   8.528  1.00 25.01           C 
ATOM   1407  CD1 ILE    90     -15.115   1.501   6.804  1.00 35.11           C 
ATOM   1408  H   ILE    90     -13.898  -3.139   8.523  1.00 36.29           H 
ATOM   1409  HA  ILE    90     -12.026  -1.185   7.649  1.00 63.25           H 
ATOM   1410  HB  ILE    90     -14.249  -1.167   6.726  1.00 75.34           H 
ATOM   1411 3HG1 ILE    90     -13.066   0.990   6.816  1.00 36.29           H 
ATOM   1412 2HG1 ILE    90     -13.757   1.313   8.403  1.00 36.29           H 
ATOM   1413 1HG2 ILE    90     -15.247  -0.488   9.495  1.00 36.29           H 
ATOM   1414 2HG2 ILE    90     -15.472  -2.026   8.660  1.00 36.29           H 
ATOM   1415 3HG2 ILE    90     -16.228  -0.562   8.031  1.00 36.29           H 
ATOM   1416 1HD1 ILE    90     -15.985   1.378   7.431  1.00 36.29           H 
ATOM   1417 2HD1 ILE    90     -15.298   1.054   5.839  1.00 36.29           H 
ATOM   1418 3HD1 ILE    90     -14.910   2.554   6.679  1.00 36.29           H 
ATOM   1419  N   THR    91     -11.430   0.300   9.546  1.00 65.23           N 
ATOM   1420  CA  THR    91     -10.965   1.088  10.698  1.00 35.41           C 
ATOM   1421  C   THR    91     -11.241   2.593  10.535  1.00 43.23           C 
ATOM   1422  O   THR    91     -11.580   3.267  11.506  1.00 23.55           O 
ATOM   1423  CB  THR    91      -9.454   0.868  10.974  1.00 14.21           C 
ATOM   1424  OG1 THR    91      -9.022   1.680  12.077  1.00 73.21           O 
ATOM   1425  CG2 THR    91      -8.603   1.180   9.745  1.00 34.25           C 
ATOM   1426  H   THR    91     -10.940   0.357   8.697  1.00 36.29           H 
ATOM   1427  HA  THR    91     -11.507   0.740  11.569  1.00 61.54           H 
ATOM   1428  HB  THR    91      -9.305  -0.173  11.233  1.00 33.24           H 
ATOM   1429  HG1 THR    91      -9.720   1.708  12.747  1.00 14.23           H 
ATOM   1430 1HG2 THR    91      -8.722   2.219   9.474  1.00 36.29           H 
ATOM   1431 2HG2 THR    91      -8.916   0.555   8.920  1.00 36.29           H 
ATOM   1432 3HG2 THR    91      -7.564   0.984   9.968  1.00 36.29           H 
ATOM   1433  N   LYS    92     -11.100   3.122   9.313  1.00 42.31           N 
ATOM   1434  CA  LYS    92     -11.345   4.557   9.064  1.00 54.15           C 
ATOM   1435  C   LYS    92     -11.465   4.899   7.568  1.00 44.42           C 
ATOM   1436  O   LYS    92     -10.929   4.201   6.701  1.00 33.13           O 
ATOM   1437  CB  LYS    92     -10.233   5.419   9.682  1.00 65.22           C 
ATOM   1438  CG  LYS    92      -8.822   5.024   9.253  1.00 10.13           C 
ATOM   1439  CD  LYS    92      -7.794   6.078   9.659  1.00 64.52           C 
ATOM   1440  CE  LYS    92      -6.370   5.532   9.646  1.00  4.34           C 
ATOM   1441  NZ  LYS    92      -5.966   4.989   8.322  1.00 72.11           N 
ATOM   1442  H   LYS    92     -10.830   2.546   8.566  1.00 36.29           H 
ATOM   1443  HA  LYS    92     -12.281   4.811   9.543  1.00 11.11           H 
ATOM   1444 3HB  LYS    92     -10.293   5.338  10.759  1.00 36.29           H 
ATOM   1445 2HB  LYS    92     -10.396   6.451   9.402  1.00 36.29           H 
ATOM   1446 3HG  LYS    92      -8.801   4.907   8.176  1.00 36.29           H 
ATOM   1447 2HG  LYS    92      -8.565   4.084   9.720  1.00 36.29           H 
ATOM   1448 3HD  LYS    92      -8.024   6.427  10.656  1.00 36.29           H 
ATOM   1449 2HD  LYS    92      -7.852   6.907   8.967  1.00 36.29           H 
ATOM   1450 3HE  LYS    92      -6.301   4.743  10.378  1.00 36.29           H 
ATOM   1451 2HE  LYS    92      -5.692   6.326   9.915  1.00 36.29           H 
ATOM   1452 1HZ  LYS    92      -5.967   5.739   7.606  1.00 36.29           H 
ATOM   1453 2HZ  LYS    92      -6.620   4.235   8.030  1.00 36.29           H 
ATOM   1454 3HZ  LYS    92      -5.008   4.579   8.385  1.00 36.29           H 
ATOM   1455  N   LEU    93     -12.170   5.999   7.283  1.00 72.14           N 
ATOM   1456  CA  LEU    93     -12.288   6.540   5.919  1.00 12.31           C 
ATOM   1457  C   LEU    93     -11.469   7.838   5.779  1.00 10.13           C 
ATOM   1458  O   LEU    93     -11.050   8.430   6.777  1.00 42.13           O 
ATOM   1459  CB  LEU    93     -13.758   6.838   5.567  1.00  2.12           C 
ATOM   1460  CG  LEU    93     -14.729   5.640   5.568  1.00 63.13           C 
ATOM   1461  CD1 LEU    93     -14.168   4.482   4.754  1.00 23.14           C 
ATOM   1462  CD2 LEU    93     -15.068   5.202   6.993  1.00 50.42           C 
ATOM   1463  H   LEU    93     -12.626   6.467   8.016  1.00 36.29           H 
ATOM   1464  HA  LEU    93     -11.897   5.805   5.228  1.00 20.21           H 
ATOM   1465 3HB  LEU    93     -13.781   7.284   4.582  1.00 36.29           H 
ATOM   1466 2HB  LEU    93     -14.129   7.569   6.272  1.00 36.29           H 
ATOM   1467  HG  LEU    93     -15.652   5.949   5.093  1.00 22.03           H 
ATOM   1468 1HD1 LEU    93     -13.251   4.130   5.204  1.00 36.29           H 
ATOM   1469 2HD1 LEU    93     -13.968   4.815   3.745  1.00 36.29           H 
ATOM   1470 3HD1 LEU    93     -14.888   3.677   4.728  1.00 36.29           H 
ATOM   1471 1HD2 LEU    93     -15.746   4.363   6.959  1.00 36.29           H 
ATOM   1472 2HD2 LEU    93     -15.539   6.021   7.519  1.00 36.29           H 
ATOM   1473 3HD2 LEU    93     -14.165   4.913   7.510  1.00 36.29           H 
ATOM   1474  N   ASN    94     -11.246   8.277   4.540  1.00 74.35           N 
ATOM   1475  CA  ASN    94     -10.546   9.545   4.271  1.00 71.52           C 
ATOM   1476  C   ASN    94     -11.230  10.336   3.139  1.00 71.43           C 
ATOM   1477  O   ASN    94     -11.226   9.910   1.981  1.00 31.43           O 
ATOM   1478  CB  ASN    94      -9.078   9.279   3.908  1.00 32.31           C 
ATOM   1479  CG  ASN    94      -8.243   8.874   5.111  1.00 15.34           C 
ATOM   1480  OD1 ASN    94      -7.668   9.714   5.790  1.00  0.13           O 
ATOM   1481  ND2 ASN    94      -8.166   7.589   5.389  1.00 63.03           N 
ATOM   1482  H   ASN    94     -11.553   7.736   3.782  1.00 36.29           H 
ATOM   1483  HA  ASN    94     -10.579  10.141   5.175  1.00 70.10           H 
ATOM   1484 3HB  ASN    94      -8.649  10.176   3.483  1.00 36.29           H 
ATOM   1485 2HB  ASN    94      -9.031   8.485   3.177  1.00 36.29           H 
ATOM   1486 1HD2 ASN    94      -8.646   6.957   4.816  1.00 36.29           H 
ATOM   1487 2HD2 ASN    94      -7.625   7.321   6.157  1.00 36.29           H 
ATOM   1488  N   GLY    95     -11.820  11.485   3.478  1.00 54.24           N 
ATOM   1489  CA  GLY    95     -12.478  12.324   2.472  1.00 52.34           C 
ATOM   1490  C   GLY    95     -13.424  13.363   3.078  1.00 12.22           C 
ATOM   1491  O   GLY    95     -13.213  13.825   4.199  1.00 53.41           O 
ATOM   1492  H   GLY    95     -11.815  11.767   4.419  1.00 36.29           H 
ATOM   1493 3HA  GLY    95     -13.044  11.689   1.803  1.00 36.29           H 
ATOM   1494 2HA  GLY    95     -11.721  12.841   1.901  1.00 36.29           H 
ATOM   1495  N   GLY    96     -14.465  13.735   2.330  1.00 32.53           N 
ATOM   1496  CA  GLY    96     -15.456  14.691   2.826  1.00 24.42           C 
ATOM   1497  C   GLY    96     -16.753  14.021   3.281  1.00 74.23           C 
ATOM   1498  O   GLY    96     -16.880  12.797   3.213  1.00 22.41           O 
ATOM   1499  H   GLY    96     -14.565  13.355   1.434  1.00 36.29           H 
ATOM   1500 3HA  GLY    96     -15.685  15.392   2.035  1.00 36.29           H 
ATOM   1501 2HA  GLY    96     -15.036  15.236   3.660  1.00 36.29           H 
ATOM   1502  N   ARG    97     -17.730  14.818   3.722  1.00 73.32           N 
ATOM   1503  CA  ARG    97     -18.994  14.277   4.247  1.00  2.04           C 
ATOM   1504  C   ARG    97     -19.796  13.532   3.167  1.00  2.23           C 
ATOM   1505  O   ARG    97     -20.404  12.500   3.447  1.00 53.11           O 
ATOM   1506  CB  ARG    97     -19.858  15.386   4.873  1.00 45.22           C 
ATOM   1507  CG  ARG    97     -21.094  14.854   5.602  1.00  2.20           C 
ATOM   1508  CD  ARG    97     -21.859  15.957   6.332  1.00 61.12           C 
ATOM   1509  NE  ARG    97     -22.452  16.926   5.413  1.00 32.33           N 
ATOM   1510  CZ  ARG    97     -23.273  17.873   5.779  1.00 32.33           C 
ATOM   1511  NH1 ARG    97     -23.609  18.015   7.020  1.00  3.21           N 
ATOM   1512  NH2 ARG    97     -23.765  18.679   4.900  1.00 11.43           N 
ATOM   1513  H   ARG    97     -17.601  15.792   3.692  1.00 36.29           H 
ATOM   1514  HA  ARG    97     -18.737  13.568   5.022  1.00 11.03           H 
ATOM   1515 3HB  ARG    97     -20.185  16.059   4.092  1.00 36.29           H 
ATOM   1516 2HB  ARG    97     -19.256  15.939   5.582  1.00 36.29           H 
ATOM   1517 3HG  ARG    97     -20.782  14.109   6.321  1.00 36.29           H 
ATOM   1518 2HG  ARG    97     -21.754  14.397   4.878  1.00 36.29           H 
ATOM   1519 3HD  ARG    97     -21.177  16.472   6.995  1.00 36.29           H 
ATOM   1520 2HD  ARG    97     -22.648  15.503   6.916  1.00 36.29           H 
ATOM   1521  HE  ARG    97     -22.222  16.856   4.465  1.00 42.04           H 
ATOM   1522 1HH1 ARG    97     -23.243  17.397   7.712  1.00 36.29           H 
ATOM   1523 2HH1 ARG    97     -24.232  18.749   7.284  1.00 36.29           H 
ATOM   1524 1HH2 ARG    97     -23.519  18.578   3.938  1.00 36.29           H 
ATOM   1525 2HH2 ARG    97     -24.400  19.396   5.185  1.00 36.29           H 
ATOM   1526  N   ARG    98     -19.806  14.050   1.935  1.00 62.12           N 
ATOM   1527  CA  ARG    98     -20.482  13.349   0.830  1.00 55.01           C 
ATOM   1528  C   ARG    98     -19.751  12.044   0.482  1.00  3.21           C 
ATOM   1529  O   ARG    98     -20.380  11.035   0.162  1.00 61.24           O 
ATOM   1530  CB  ARG    98     -20.625  14.236  -0.421  1.00 33.50           C 
ATOM   1531  CG  ARG    98     -21.639  15.373  -0.262  1.00 43.41           C 
ATOM   1532  CD  ARG    98     -21.034  16.611   0.389  1.00 13.11           C 
ATOM   1533  NE  ARG    98     -20.195  17.358  -0.542  1.00 50.33           N 
ATOM   1534  CZ  ARG    98     -19.689  18.532  -0.290  1.00 64.24           C 
ATOM   1535  NH1 ARG    98     -19.838  19.083   0.871  1.00  3.54           N 
ATOM   1536  NH2 ARG    98     -19.019  19.154  -1.203  1.00 71.21           N 
ATOM   1537  H   ARG    98     -19.350  14.902   1.768  1.00 36.29           H 
ATOM   1538  HA  ARG    98     -21.473  13.091   1.181  1.00 32.24           H 
ATOM   1539 3HB  ARG    98     -20.939  13.618  -1.252  1.00 36.29           H 
ATOM   1540 2HB  ARG    98     -19.662  14.668  -0.655  1.00 36.29           H 
ATOM   1541 3HG  ARG    98     -22.461  15.023   0.349  1.00 36.29           H 
ATOM   1542 2HG  ARG    98     -22.012  15.645  -1.238  1.00 36.29           H 
ATOM   1543 3HD  ARG    98     -20.434  16.305   1.235  1.00 36.29           H 
ATOM   1544 2HD  ARG    98     -21.834  17.252   0.731  1.00 36.29           H 
ATOM   1545  HE  ARG    98     -20.026  16.961  -1.422  1.00 13.21           H 
ATOM   1546 1HH1 ARG    98     -20.345  18.610   1.587  1.00 36.29           H 
ATOM   1547 2HH1 ARG    98     -19.436  19.980   1.050  1.00 36.29           H 
ATOM   1548 1HH2 ARG    98     -18.895  18.737  -2.100  1.00 36.29           H 
ATOM   1549 2HH2 ARG    98     -18.633  20.053  -1.007  1.00 36.29           H 
ATOM   1550  N   PHE    99     -18.419  12.069   0.562  1.00  1.52           N 
ATOM   1551  CA  PHE    99     -17.618  10.848   0.421  1.00 14.23           C 
ATOM   1552  C   PHE    99     -18.048   9.806   1.468  1.00  3.12           C 
ATOM   1553  O   PHE    99     -18.276   8.636   1.148  1.00 43.23           O 
ATOM   1554  CB  PHE    99     -16.122  11.175   0.572  1.00 22.30           C 
ATOM   1555  CG  PHE    99     -15.220   9.964   0.535  1.00 62.53           C 
ATOM   1556  CD1 PHE    99     -14.787   9.438  -0.674  1.00 42.43           C 
ATOM   1557  CD2 PHE    99     -14.806   9.350   1.711  1.00 75.53           C 
ATOM   1558  CE1 PHE    99     -13.964   8.330  -0.711  1.00 72.43           C 
ATOM   1559  CE2 PHE    99     -13.982   8.242   1.679  1.00 20.21           C 
ATOM   1560  CZ  PHE    99     -13.562   7.731   0.467  1.00 72.42           C 
ATOM   1561  H   PHE    99     -17.965  12.923   0.714  1.00 36.29           H 
ATOM   1562  HA  PHE    99     -17.796  10.446  -0.568  1.00 12.34           H 
ATOM   1563 3HB  PHE    99     -15.966  11.678   1.516  1.00 36.29           H 
ATOM   1564 2HB  PHE    99     -15.823  11.835  -0.231  1.00 36.29           H 
ATOM   1565  HD1 PHE    99     -15.099   9.905  -1.597  1.00 15.13           H 
ATOM   1566  HD2 PHE    99     -15.135   9.749   2.661  1.00 32.43           H 
ATOM   1567  HE1 PHE    99     -13.636   7.931  -1.661  1.00  0.33           H 
ATOM   1568  HE2 PHE    99     -13.669   7.775   2.601  1.00 65.04           H 
ATOM   1569  HZ  PHE    99     -12.918   6.864   0.441  1.00 12.14           H 
ATOM   1570  N   LEU   100     -18.162  10.248   2.723  1.00 42.30           N 
ATOM   1571  CA  LEU   100     -18.650   9.387   3.806  1.00  4.13           C 
ATOM   1572  C   LEU   100     -20.083   8.916   3.529  1.00 51.22           C 
ATOM   1573  O   LEU   100     -20.413   7.754   3.746  1.00  4.33           O 
ATOM   1574  CB  LEU   100     -18.603  10.130   5.151  1.00 24.23           C 
ATOM   1575  CG  LEU   100     -17.214  10.620   5.591  1.00 21.10           C 
ATOM   1576  CD1 LEU   100     -17.297  11.336   6.937  1.00 11.20           C 
ATOM   1577  CD2 LEU   100     -16.222   9.459   5.656  1.00 32.53           C 
ATOM   1578  H   LEU   100     -17.907  11.174   2.928  1.00 36.29           H 
ATOM   1579  HA  LEU   100     -18.001   8.523   3.859  1.00  2.21           H 
ATOM   1580 3HB  LEU   100     -18.987   9.470   5.917  1.00 36.29           H 
ATOM   1581 2HB  LEU   100     -19.259  10.989   5.082  1.00 36.29           H 
ATOM   1582  HG  LEU   100     -16.846  11.330   4.864  1.00 45.44           H 
ATOM   1583 1HD1 LEU   100     -17.651  10.649   7.693  1.00 36.29           H 
ATOM   1584 2HD1 LEU   100     -17.979  12.171   6.861  1.00 36.29           H 
ATOM   1585 3HD1 LEU   100     -16.316  11.698   7.212  1.00 36.29           H 
ATOM   1586 1HD2 LEU   100     -15.255   9.828   5.969  1.00 36.29           H 
ATOM   1587 2HD2 LEU   100     -16.132   9.004   4.680  1.00 36.29           H 
ATOM   1588 3HD2 LEU   100     -16.572   8.721   6.364  1.00 36.29           H 
ATOM   1589  N   PHE   101     -20.920   9.825   3.030  1.00 25.05           N 
ATOM   1590  CA  PHE   101     -22.321   9.517   2.717  1.00 22.40           C 
ATOM   1591  C   PHE   101     -22.424   8.284   1.810  1.00 32.10           C 
ATOM   1592  O   PHE   101     -23.216   7.374   2.069  1.00 63.25           O 
ATOM   1593  CB  PHE   101     -22.979  10.728   2.043  1.00 62.32           C 
ATOM   1594  CG  PHE   101     -24.419  10.516   1.638  1.00 44.44           C 
ATOM   1595  CD1 PHE   101     -24.744  10.119   0.345  1.00 11.13           C 
ATOM   1596  CD2 PHE   101     -25.447  10.716   2.547  1.00  3.51           C 
ATOM   1597  CE1 PHE   101     -26.062   9.928  -0.027  1.00 71.41           C 
ATOM   1598  CE2 PHE   101     -26.766  10.527   2.179  1.00 53.41           C 
ATOM   1599  CZ  PHE   101     -27.075  10.131   0.891  1.00 10.35           C 
ATOM   1600  H   PHE   101     -20.586  10.731   2.866  1.00 36.29           H 
ATOM   1601  HA  PHE   101     -22.830   9.310   3.648  1.00 74.20           H 
ATOM   1602 3HB  PHE   101     -22.417  10.980   1.154  1.00 36.29           H 
ATOM   1603 2HB  PHE   101     -22.947  11.566   2.724  1.00 36.29           H 
ATOM   1604  HD1 PHE   101     -23.954   9.957  -0.374  1.00  1.30           H 
ATOM   1605  HD2 PHE   101     -25.212  11.026   3.556  1.00 41.52           H 
ATOM   1606  HE1 PHE   101     -26.301   9.619  -1.036  1.00 14.35           H 
ATOM   1607  HE2 PHE   101     -27.556  10.687   2.900  1.00 15.01           H 
ATOM   1608  HZ  PHE   101     -28.106   9.983   0.604  1.00 60.20           H 
ATOM   1609  N   ARG   102     -21.614   8.258   0.753  1.00 23.35           N 
ATOM   1610  CA  ARG   102     -21.536   7.094  -0.134  1.00 23.31           C 
ATOM   1611  C   ARG   102     -21.221   5.817   0.657  1.00 61.20           C 
ATOM   1612  O   ARG   102     -21.913   4.811   0.529  1.00  4.51           O 
ATOM   1613  CB  ARG   102     -20.459   7.310  -1.207  1.00 65.14           C 
ATOM   1614  CG  ARG   102     -20.798   8.403  -2.213  1.00 73.23           C 
ATOM   1615  CD  ARG   102     -22.003   8.029  -3.071  1.00  0.12           C 
ATOM   1616  NE  ARG   102     -22.336   9.077  -4.032  1.00 33.22           N 
ATOM   1617  CZ  ARG   102     -22.683   8.860  -5.272  1.00 43.40           C 
ATOM   1618  NH1 ARG   102     -22.703   7.655  -5.753  1.00  1.11           N 
ATOM   1619  NH2 ARG   102     -22.993   9.855  -6.034  1.00 44.44           N 
ATOM   1620  H   ARG   102     -21.055   9.043   0.563  1.00 36.29           H 
ATOM   1621  HA  ARG   102     -22.497   6.979  -0.618  1.00 14.34           H 
ATOM   1622 3HB  ARG   102     -20.315   6.384  -1.750  1.00 36.29           H 
ATOM   1623 2HB  ARG   102     -19.533   7.576  -0.719  1.00 36.29           H 
ATOM   1624 3HG  ARG   102     -19.945   8.563  -2.859  1.00 36.29           H 
ATOM   1625 2HG  ARG   102     -21.019   9.316  -1.679  1.00 36.29           H 
ATOM   1626 3HD  ARG   102     -22.854   7.865  -2.423  1.00 36.29           H 
ATOM   1627 2HD  ARG   102     -21.780   7.116  -3.605  1.00 36.29           H 
ATOM   1628  HE  ARG   102     -22.307  10.004  -3.716  1.00 40.12           H 
ATOM   1629 1HH1 ARG   102     -22.449   6.881  -5.177  1.00 36.29           H 
ATOM   1630 2HH1 ARG   102     -22.973   7.501  -6.702  1.00 36.29           H 
ATOM   1631 1HH2 ARG   102     -22.969  10.786  -5.671  1.00 36.29           H 
ATOM   1632 2HH2 ARG   102     -23.254   9.695  -6.984  1.00 36.29           H 
ATOM   1633  N   MET   103     -20.186   5.883   1.488  1.00 12.52           N 
ATOM   1634  CA  MET   103     -19.735   4.728   2.273  1.00 72.25           C 
ATOM   1635  C   MET   103     -20.818   4.229   3.246  1.00  2.14           C 
ATOM   1636  O   MET   103     -21.065   3.023   3.350  1.00 24.21           O 
ATOM   1637  CB  MET   103     -18.454   5.093   3.030  1.00 24.22           C 
ATOM   1638  CG  MET   103     -17.340   5.557   2.103  1.00 44.15           C 
ATOM   1639  SD  MET   103     -17.028   4.377   0.772  1.00 62.20           S 
ATOM   1640  CE  MET   103     -16.022   5.358  -0.338  1.00 74.41           C 
ATOM   1641  H   MET   103     -19.708   6.735   1.580  1.00 36.29           H 
ATOM   1642  HA  MET   103     -19.509   3.931   1.578  1.00  4.15           H 
ATOM   1643 3HB  MET   103     -18.106   4.228   3.575  1.00 36.29           H 
ATOM   1644 2HB  MET   103     -18.673   5.889   3.730  1.00 36.29           H 
ATOM   1645 3HG  MET   103     -16.432   5.681   2.679  1.00 36.29           H 
ATOM   1646 2HG  MET   103     -17.621   6.505   1.667  1.00 36.29           H 
ATOM   1647 1HE  MET   103     -15.753   4.765  -1.199  1.00 36.29           H 
ATOM   1648 2HE  MET   103     -15.127   5.675   0.174  1.00 36.29           H 
ATOM   1649 3HE  MET   103     -16.579   6.226  -0.659  1.00 36.29           H 
ATOM   1650  N   LYS   104     -21.477   5.159   3.936  1.00 52.44           N 
ATOM   1651  CA  LYS   104     -22.549   4.815   4.877  1.00 31.44           C 
ATOM   1652  C   LYS   104     -23.705   4.105   4.153  1.00 43.24           C 
ATOM   1653  O   LYS   104     -24.244   3.104   4.634  1.00 41.13           O 
ATOM   1654  CB  LYS   104     -23.070   6.081   5.579  1.00 61.35           C 
ATOM   1655  CG  LYS   104     -21.973   6.933   6.218  1.00 50.22           C 
ATOM   1656  CD  LYS   104     -22.539   8.142   6.969  1.00 61.35           C 
ATOM   1657  CE  LYS   104     -22.892   7.817   8.420  1.00 53.34           C 
ATOM   1658  NZ  LYS   104     -23.861   6.695   8.543  1.00 30.53           N 
ATOM   1659  H   LYS   104     -21.233   6.099   3.812  1.00 36.29           H 
ATOM   1660  HA  LYS   104     -22.137   4.144   5.619  1.00 41.12           H 
ATOM   1661 3HB  LYS   104     -23.764   5.787   6.354  1.00 36.29           H 
ATOM   1662 2HB  LYS   104     -23.593   6.691   4.855  1.00 36.29           H 
ATOM   1663 3HG  LYS   104     -21.309   7.283   5.442  1.00 36.29           H 
ATOM   1664 2HG  LYS   104     -21.415   6.319   6.912  1.00 36.29           H 
ATOM   1665 3HD  LYS   104     -23.431   8.483   6.461  1.00 36.29           H 
ATOM   1666 2HD  LYS   104     -21.802   8.934   6.964  1.00 36.29           H 
ATOM   1667 3HE  LYS   104     -23.319   8.698   8.877  1.00 36.29           H 
ATOM   1668 2HE  LYS   104     -21.987   7.549   8.944  1.00 36.29           H 
ATOM   1669 1HZ  LYS   104     -23.460   5.824   8.137  1.00 36.29           H 
ATOM   1670 2HZ  LYS   104     -24.742   6.924   8.043  1.00 36.29           H 
ATOM   1671 3HZ  LYS   104     -24.080   6.523   9.545  1.00 36.29           H 
ATOM   1672  N   ASN   105     -24.075   4.625   2.986  1.00 31.44           N 
ATOM   1673  CA  ASN   105     -25.150   4.039   2.179  1.00 20.54           C 
ATOM   1674  C   ASN   105     -24.684   2.767   1.446  1.00 62.14           C 
ATOM   1675  O   ASN   105     -25.498   1.920   1.088  1.00 23.42           O 
ATOM   1676  CB  ASN   105     -25.686   5.077   1.183  1.00 52.13           C 
ATOM   1677  CG  ASN   105     -26.582   6.111   1.848  1.00 71.04           C 
ATOM   1678  OD1 ASN   105     -27.800   5.955   1.901  1.00  2.24           O 
ATOM   1679  ND2 ASN   105     -25.995   7.167   2.371  1.00 13.41           N 
ATOM   1680  H   ASN   105     -23.611   5.424   2.654  1.00 36.29           H 
ATOM   1681  HA  ASN   105     -25.950   3.764   2.854  1.00 51.30           H 
ATOM   1682 3HB  ASN   105     -26.259   4.573   0.415  1.00 36.29           H 
ATOM   1683 2HB  ASN   105     -24.854   5.590   0.725  1.00 36.29           H 
ATOM   1684 1HD2 ASN   105     -25.024   7.236   2.304  1.00 36.29           H 
ATOM   1685 2HD2 ASN   105     -26.558   7.835   2.813  1.00 36.29           H 
ATOM   1686  N   LEU   106     -23.375   2.636   1.222  1.00 21.42           N 
ATOM   1687  CA  LEU   106     -22.816   1.444   0.563  1.00 42.00           C 
ATOM   1688  C   LEU   106     -22.699   0.252   1.528  1.00 44.44           C 
ATOM   1689  O   LEU   106     -22.835  -0.898   1.110  1.00 43.31           O 
ATOM   1690  CB  LEU   106     -21.445   1.755  -0.071  1.00 52.23           C 
ATOM   1691  CG  LEU   106     -21.443   1.918  -1.603  1.00 73.13           C 
ATOM   1692  CD1 LEU   106     -21.900   0.628  -2.282  1.00 25.24           C 
ATOM   1693  CD2 LEU   106     -22.324   3.088  -2.033  1.00  3.23           C 
ATOM   1694  H   LEU   106     -22.770   3.358   1.496  1.00 36.29           H 
ATOM   1695  HA  LEU   106     -23.502   1.167  -0.226  1.00 11.44           H 
ATOM   1696 3HB  LEU   106     -20.760   0.956   0.180  1.00 36.29           H 
ATOM   1697 2HB  LEU   106     -21.070   2.671   0.366  1.00 36.29           H 
ATOM   1698  HG  LEU   106     -20.432   2.124  -1.933  1.00 24.21           H 
ATOM   1699 1HD1 LEU   106     -21.863   0.753  -3.355  1.00 36.29           H 
ATOM   1700 2HD1 LEU   106     -22.914   0.401  -1.983  1.00 36.29           H 
ATOM   1701 3HD1 LEU   106     -21.250  -0.184  -1.992  1.00 36.29           H 
ATOM   1702 1HD2 LEU   106     -22.302   3.179  -3.108  1.00 36.29           H 
ATOM   1703 2HD2 LEU   106     -21.955   4.002  -1.588  1.00 36.29           H 
ATOM   1704 3HD2 LEU   106     -23.341   2.915  -1.706  1.00 36.29           H 
ATOM   1705  N   GLY   107     -22.443   0.524   2.808  1.00  4.41           N 
ATOM   1706  CA  GLY   107     -22.387  -0.549   3.803  1.00 75.00           C 
ATOM   1707  C   GLY   107     -21.149  -0.519   4.700  1.00 52.23           C 
ATOM   1708  O   GLY   107     -21.050  -1.299   5.650  1.00 74.33           O 
ATOM   1709  H   GLY   107     -22.303   1.456   3.083  1.00 36.29           H 
ATOM   1710 3HA  GLY   107     -22.415  -1.503   3.292  1.00 36.29           H 
ATOM   1711 2HA  GLY   107     -23.262  -0.474   4.431  1.00 36.29           H 
ATOM   1712  N   ILE   108     -20.204   0.376   4.419  1.00 20.43           N 
ATOM   1713  CA  ILE   108     -18.974   0.469   5.217  1.00 25.42           C 
ATOM   1714  C   ILE   108     -19.059   1.595   6.264  1.00 11.24           C 
ATOM   1715  O   ILE   108     -18.589   2.710   6.045  1.00  1.10           O 
ATOM   1716  CB  ILE   108     -17.688   0.643   4.345  1.00 45.21           C 
ATOM   1717  CG1 ILE   108     -17.897   1.640   3.187  1.00 21.42           C 
ATOM   1718  CG2 ILE   108     -17.203  -0.706   3.815  1.00 34.33           C 
ATOM   1719  CD1 ILE   108     -18.544   1.050   1.944  1.00  2.54           C 
ATOM   1720  H   ILE   108     -20.345   1.003   3.682  1.00 36.29           H 
ATOM   1721  HA  ILE   108     -18.876  -0.468   5.753  1.00 13.33           H 
ATOM   1722  HB  ILE   108     -16.911   1.029   4.991  1.00 72.34           H 
ATOM   1723 3HG1 ILE   108     -16.937   2.045   2.896  1.00 36.29           H 
ATOM   1724 2HG1 ILE   108     -18.527   2.450   3.527  1.00 36.29           H 
ATOM   1725 1HG2 ILE   108     -16.975  -1.359   4.646  1.00 36.29           H 
ATOM   1726 2HG2 ILE   108     -16.312  -0.561   3.220  1.00 36.29           H 
ATOM   1727 3HG2 ILE   108     -17.973  -1.156   3.206  1.00 36.29           H 
ATOM   1728 1HD1 ILE   108     -19.481   0.582   2.206  1.00 36.29           H 
ATOM   1729 2HD1 ILE   108     -17.883   0.316   1.509  1.00 36.29           H 
ATOM   1730 3HD1 ILE   108     -18.726   1.838   1.228  1.00 36.29           H 
ATOM   1731  N   GLU   109     -19.687   1.289   7.400  1.00 14.42           N 
ATOM   1732  CA  GLU   109     -19.801   2.238   8.518  1.00 50.05           C 
ATOM   1733  C   GLU   109     -18.596   2.127   9.468  1.00  1.42           C 
ATOM   1734  O   GLU   109     -17.716   2.992   9.483  1.00  4.22           O 
ATOM   1735  CB  GLU   109     -21.106   1.977   9.291  1.00  3.31           C 
ATOM   1736  CG  GLU   109     -22.377   2.245   8.484  1.00 43.33           C 
ATOM   1737  CD  GLU   109     -22.791   3.711   8.481  1.00  3.32           C 
ATOM   1738  OE1 GLU   109     -21.915   4.593   8.387  1.00 72.11           O 
ATOM   1739  OE2 GLU   109     -24.007   3.992   8.566  1.00  1.44           O 
ATOM   1740  H   GLU   109     -20.100   0.406   7.486  1.00 36.29           H 
ATOM   1741  HA  GLU   109     -19.831   3.239   8.107  1.00 55.04           H 
ATOM   1742 3HB  GLU   109     -21.124   2.609  10.170  1.00 36.29           H 
ATOM   1743 2HB  GLU   109     -21.119   0.946   9.605  1.00 36.29           H 
ATOM   1744 3HG  GLU   109     -23.181   1.659   8.909  1.00 36.29           H 
ATOM   1745 2HG  GLU   109     -22.213   1.933   7.463  1.00 36.29           H 
ATOM   1746  N   SER   110     -18.565   1.053  10.262  1.00 74.22           N 
ATOM   1747  CA  SER   110     -17.453   0.801  11.195  1.00  3.13           C 
ATOM   1748  C   SER   110     -17.450  -0.658  11.674  1.00  5.11           C 
ATOM   1749  O   SER   110     -18.506  -1.248  11.904  1.00 60.41           O 
ATOM   1750  CB  SER   110     -17.540   1.734  12.410  1.00 63.23           C 
ATOM   1751  OG  SER   110     -18.701   1.469  13.185  1.00 53.02           O 
ATOM   1752  H   SER   110     -19.312   0.418  10.232  1.00 36.29           H 
ATOM   1753  HA  SER   110     -16.529   0.997  10.666  1.00 72.12           H 
ATOM   1754 3HB  SER   110     -17.577   2.760  12.072  1.00 36.29           H 
ATOM   1755 2HB  SER   110     -16.669   1.595  13.035  1.00 36.29           H 
ATOM   1756  HG  SER   110     -18.448   1.331  14.105  1.00  0.43           H 
ATOM   1757  N   GLY   111     -16.258  -1.245  11.800  1.00  4.32           N 
ATOM   1758  CA  GLY   111     -16.133  -2.618  12.298  1.00 61.43           C 
ATOM   1759  C   GLY   111     -16.562  -3.693  11.296  1.00 32.32           C 
ATOM   1760  O   GLY   111     -16.359  -4.884  11.537  1.00 51.22           O 
ATOM   1761  H   GLY   111     -15.451  -0.741  11.562  1.00 36.29           H 
ATOM   1762 3HA  GLY   111     -16.736  -2.717  13.191  1.00 36.29           H 
ATOM   1763 2HA  GLY   111     -15.101  -2.790  12.563  1.00 36.29           H 
ATOM   1764  N   LYS   112     -17.154  -3.275  10.176  1.00  3.11           N 
ATOM   1765  CA  LYS   112     -17.630  -4.205   9.140  1.00 34.24           C 
ATOM   1766  C   LYS   112     -16.499  -5.083   8.579  1.00 41.42           C 
ATOM   1767  O   LYS   112     -15.406  -4.595   8.279  1.00  3.25           O 
ATOM   1768  CB  LYS   112     -18.284  -3.424   7.988  1.00 61.22           C 
ATOM   1769  CG  LYS   112     -19.630  -2.792   8.335  1.00 31.01           C 
ATOM   1770  CD  LYS   112     -20.692  -3.852   8.620  1.00 72.52           C 
ATOM   1771  CE  LYS   112     -22.077  -3.237   8.779  1.00 40.15           C 
ATOM   1772  NZ  LYS   112     -23.106  -4.266   9.079  1.00 34.21           N 
ATOM   1773  H   LYS   112     -17.277  -2.317  10.042  1.00 36.29           H 
ATOM   1774  HA  LYS   112     -18.374  -4.844   9.592  1.00 34.15           H 
ATOM   1775 3HB  LYS   112     -18.433  -4.096   7.154  1.00 36.29           H 
ATOM   1776 2HB  LYS   112     -17.612  -2.634   7.680  1.00 36.29           H 
ATOM   1777 3HG  LYS   112     -19.955  -2.184   7.501  1.00 36.29           H 
ATOM   1778 2HG  LYS   112     -19.509  -2.169   9.210  1.00 36.29           H 
ATOM   1779 3HD  LYS   112     -20.434  -4.374   9.532  1.00 36.29           H 
ATOM   1780 2HD  LYS   112     -20.717  -4.554   7.800  1.00 36.29           H 
ATOM   1781 3HE  LYS   112     -22.342  -2.732   7.860  1.00 36.29           H 
ATOM   1782 2HE  LYS   112     -22.051  -2.523   9.587  1.00 36.29           H 
ATOM   1783 1HZ  LYS   112     -22.943  -4.671  10.025  1.00 36.29           H 
ATOM   1784 2HZ  LYS   112     -23.065  -5.032   8.376  1.00 36.29           H 
ATOM   1785 3HZ  LYS   112     -24.052  -3.841   9.057  1.00 36.29           H 
ATOM   1786  N   LYS   113     -16.779  -6.379   8.432  1.00 22.32           N 
ATOM   1787  CA  LYS   113     -15.829  -7.313   7.820  1.00 63.22           C 
ATOM   1788  C   LYS   113     -15.988  -7.337   6.293  1.00 23.13           C 
ATOM   1789  O   LYS   113     -16.949  -7.896   5.759  1.00 61.52           O 
ATOM   1790  CB  LYS   113     -15.994  -8.726   8.407  1.00  2.21           C 
ATOM   1791  CG  LYS   113     -15.299  -8.923   9.757  1.00 33.44           C 
ATOM   1792  CD  LYS   113     -15.792  -7.940  10.821  1.00 54.34           C 
ATOM   1793  CE  LYS   113     -15.025  -8.083  12.130  1.00  4.32           C 
ATOM   1794  NZ  LYS   113     -15.512  -7.131  13.161  1.00 54.11           N 
ATOM   1795  H   LYS   113     -17.644  -6.720   8.747  1.00 36.29           H 
ATOM   1796  HA  LYS   113     -14.834  -6.959   8.052  1.00 65.00           H 
ATOM   1797 3HB  LYS   113     -15.582  -9.444   7.711  1.00 36.29           H 
ATOM   1798 2HB  LYS   113     -17.047  -8.932   8.535  1.00 36.29           H 
ATOM   1799 3HG  LYS   113     -14.234  -8.788   9.621  1.00 36.29           H 
ATOM   1800 2HG  LYS   113     -15.489  -9.930  10.101  1.00 36.29           H 
ATOM   1801 3HD  LYS   113     -16.841  -8.123  11.006  1.00 36.29           H 
ATOM   1802 2HD  LYS   113     -15.663  -6.932  10.453  1.00 36.29           H 
ATOM   1803 3HE  LYS   113     -13.977  -7.892  11.945  1.00 36.29           H 
ATOM   1804 2HE  LYS   113     -15.146  -9.090  12.499  1.00 36.29           H 
ATOM   1805 1HZ  LYS   113     -15.522  -6.165  12.778  1.00 36.29           H 
ATOM   1806 2HZ  LYS   113     -14.886  -7.154  13.991  1.00 36.29           H 
ATOM   1807 3HZ  LYS   113     -16.475  -7.385  13.461  1.00 36.29           H 
ATOM   1808  N   ILE   114     -15.030  -6.725   5.601  1.00 74.14           N 
ATOM   1809  CA  ILE   114     -15.084  -6.570   4.145  1.00  2.33           C 
ATOM   1810  C   ILE   114     -14.092  -7.515   3.433  1.00 44.51           C 
ATOM   1811  O   ILE   114     -12.929  -7.631   3.823  1.00 10.11           O 
ATOM   1812  CB  ILE   114     -14.806  -5.094   3.754  1.00 75.45           C 
ATOM   1813  CG1 ILE   114     -15.044  -4.862   2.251  1.00 52.12           C 
ATOM   1814  CG2 ILE   114     -13.387  -4.676   4.149  1.00 50.24           C 
ATOM   1815  CD1 ILE   114     -15.046  -3.397   1.856  1.00 54.51           C 
ATOM   1816  H   ILE   114     -14.261  -6.363   6.088  1.00 36.29           H 
ATOM   1817  HA  ILE   114     -16.087  -6.818   3.823  1.00 40.45           H 
ATOM   1818  HB  ILE   114     -15.493  -4.473   4.313  1.00  4.51           H 
ATOM   1819 3HG1 ILE   114     -16.002  -5.278   1.977  1.00 36.29           H 
ATOM   1820 2HG1 ILE   114     -14.268  -5.357   1.685  1.00 36.29           H 
ATOM   1821 1HG2 ILE   114     -13.260  -4.793   5.216  1.00 36.29           H 
ATOM   1822 2HG2 ILE   114     -13.224  -3.642   3.880  1.00 36.29           H 
ATOM   1823 3HG2 ILE   114     -12.670  -5.299   3.633  1.00 36.29           H 
ATOM   1824 1HD1 ILE   114     -14.090  -2.956   2.098  1.00 36.29           H 
ATOM   1825 2HD1 ILE   114     -15.828  -2.878   2.392  1.00 36.29           H 
ATOM   1826 3HD1 ILE   114     -15.222  -3.312   0.794  1.00 36.29           H 
ATOM   1827  N   GLN   115     -14.574  -8.211   2.405  1.00  1.25           N 
ATOM   1828  CA  GLN   115     -13.751  -9.165   1.648  1.00 51.53           C 
ATOM   1829  C   GLN   115     -13.154  -8.520   0.389  1.00 75.21           C 
ATOM   1830  O   GLN   115     -13.791  -7.684  -0.255  1.00 13.35           O 
ATOM   1831  CB  GLN   115     -14.577 -10.397   1.244  1.00 52.33           C 
ATOM   1832  CG  GLN   115     -15.051 -11.264   2.410  1.00 22.45           C 
ATOM   1833  CD  GLN   115     -16.130 -10.612   3.259  1.00 10.23           C 
ATOM   1834  OE1 GLN   115     -17.318 -10.739   2.985  1.00 63.13           O 
ATOM   1835  NE2 GLN   115     -15.733  -9.933   4.312  1.00 14.31           N 
ATOM   1836  H   GLN   115     -15.512  -8.084   2.150  1.00 36.29           H 
ATOM   1837  HA  GLN   115     -12.940  -9.484   2.291  1.00 73.32           H 
ATOM   1838 3HB  GLN   115     -13.976 -11.016   0.591  1.00 36.29           H 
ATOM   1839 2HB  GLN   115     -15.449 -10.065   0.699  1.00 36.29           H 
ATOM   1840 3HG  GLN   115     -14.202 -11.486   3.042  1.00 36.29           H 
ATOM   1841 2HG  GLN   115     -15.444 -12.189   2.013  1.00 36.29           H 
ATOM   1842 1HE2 GLN   115     -14.776  -9.884   4.493  1.00 36.29           H 
ATOM   1843 2HE2 GLN   115     -16.416  -9.501   4.866  1.00 36.29           H 
ATOM   1844  N   VAL   116     -11.934  -8.924   0.035  1.00  5.30           N 
ATOM   1845  CA  VAL   116     -11.244  -8.398  -1.153  1.00 24.20           C 
ATOM   1846  C   VAL   116     -11.268  -9.405  -2.321  1.00 21.53           C 
ATOM   1847  O   VAL   116     -10.779 -10.529  -2.193  1.00 13.22           O 
ATOM   1848  CB  VAL   116      -9.771  -8.041  -0.822  1.00 43.21           C 
ATOM   1849  CG1 VAL   116      -9.035  -7.525  -2.059  1.00 45.14           C 
ATOM   1850  CG2 VAL   116      -9.703  -7.018   0.312  1.00 43.24           C 
ATOM   1851  H   VAL   116     -11.477  -9.594   0.590  1.00 36.29           H 
ATOM   1852  HA  VAL   116     -11.751  -7.491  -1.463  1.00 33.34           H 
ATOM   1853  HB  VAL   116      -9.273  -8.943  -0.491  1.00 74.23           H 
ATOM   1854 1HG1 VAL   116      -9.523  -6.632  -2.425  1.00 36.29           H 
ATOM   1855 2HG1 VAL   116      -9.048  -8.282  -2.830  1.00 36.29           H 
ATOM   1856 3HG1 VAL   116      -8.013  -7.293  -1.801  1.00 36.29           H 
ATOM   1857 1HG2 VAL   116     -10.200  -7.414   1.186  1.00 36.29           H 
ATOM   1858 2HG2 VAL   116     -10.191  -6.104   0.005  1.00 36.29           H 
ATOM   1859 3HG2 VAL   116      -8.669  -6.809   0.551  1.00 36.29           H 
ATOM   1860  N   SER   117     -11.834  -8.991  -3.459  1.00 32.24           N 
ATOM   1861  CA  SER   117     -11.877  -9.838  -4.666  1.00 71.32           C 
ATOM   1862  C   SER   117     -11.781  -8.999  -5.949  1.00 31.01           C 
ATOM   1863  O   SER   117     -12.653  -8.179  -6.231  1.00 51.43           O 
ATOM   1864  CB  SER   117     -13.166 -10.671  -4.702  1.00 71.42           C 
ATOM   1865  OG  SER   117     -13.264 -11.424  -5.904  1.00 75.11           O 
ATOM   1866  H   SER   117     -12.243  -8.099  -3.491  1.00 36.29           H 
ATOM   1867  HA  SER   117     -11.028 -10.510  -4.630  1.00 41.04           H 
ATOM   1868 3HB  SER   117     -14.019 -10.012  -4.635  1.00 36.29           H 
ATOM   1869 2HB  SER   117     -13.173 -11.353  -3.867  1.00 36.29           H 
ATOM   1870  HG  SER   117     -14.120 -11.872  -5.932  1.00 73.31           H 
ATOM   1871  N   GLY   118     -10.717  -9.213  -6.719  1.00 33.21           N 
ATOM   1872  CA  GLY   118     -10.530  -8.493  -7.977  1.00 12.42           C 
ATOM   1873  C   GLY   118     -10.578  -6.971  -7.828  1.00 74.20           C 
ATOM   1874  O   GLY   118      -9.735  -6.377  -7.158  1.00 20.33           O 
ATOM   1875  H   GLY   118     -10.053  -9.876  -6.438  1.00 36.29           H 
ATOM   1876 3HA  GLY   118     -11.303  -8.800  -8.669  1.00 36.29           H 
ATOM   1877 2HA  GLY   118      -9.571  -8.769  -8.390  1.00 36.29           H 
ATOM   1878  N   ARG   119     -11.570  -6.342  -8.460  1.00 25.32           N 
ATOM   1879  CA  ARG   119     -11.739  -4.883  -8.395  1.00 34.22           C 
ATOM   1880  C   ARG   119     -13.046  -4.488  -7.683  1.00  2.21           C 
ATOM   1881  O   ARG   119     -13.582  -3.404  -7.913  1.00 13.21           O 
ATOM   1882  CB  ARG   119     -11.711  -4.285  -9.810  1.00 42.40           C 
ATOM   1883  CG  ARG   119     -10.351  -4.386 -10.497  1.00 71.15           C 
ATOM   1884  CD  ARG   119      -9.283  -3.580  -9.762  1.00 32.30           C 
ATOM   1885  NE  ARG   119      -7.979  -3.672 -10.415  1.00 24.14           N 
ATOM   1886  CZ  ARG   119      -6.876  -3.167  -9.934  1.00 45.15           C 
ATOM   1887  NH1 ARG   119      -6.883  -2.491  -8.831  1.00 23.21           N 
ATOM   1888  NH2 ARG   119      -5.766  -3.322 -10.573  1.00 61.32           N 
ATOM   1889  H   ARG   119     -12.206  -6.872  -8.987  1.00 36.29           H 
ATOM   1890  HA  ARG   119     -10.909  -4.478  -7.832  1.00 21.42           H 
ATOM   1891 3HB  ARG   119     -11.984  -3.241  -9.755  1.00 36.29           H 
ATOM   1892 2HB  ARG   119     -12.437  -4.803 -10.422  1.00 36.29           H 
ATOM   1893 3HG  ARG   119     -10.439  -4.013 -11.507  1.00 36.29           H 
ATOM   1894 2HG  ARG   119     -10.047  -5.424 -10.522  1.00 36.29           H 
ATOM   1895 3HD  ARG   119      -9.198  -3.958  -8.751  1.00 36.29           H 
ATOM   1896 2HD  ARG   119      -9.590  -2.545  -9.734  1.00 36.29           H 
ATOM   1897  HE  ARG   119      -7.934  -4.155 -11.265  1.00 73.21           H 
ATOM   1898 1HH1 ARG   119      -7.737  -2.351  -8.338  1.00 36.29           H 
ATOM   1899 2HH1 ARG   119      -6.030  -2.114  -8.478  1.00 36.29           H 
ATOM   1900 1HH2 ARG   119      -5.751  -3.827 -11.434  1.00 36.29           H 
ATOM   1901 2HH2 ARG   119      -4.922  -2.939 -10.202  1.00 36.29           H 
ATOM   1902  N   ARG   120     -13.549  -5.366  -6.814  1.00 13.33           N 
ATOM   1903  CA  ARG   120     -14.733  -5.051  -6.004  1.00 42.34           C 
ATOM   1904  C   ARG   120     -14.646  -5.711  -4.618  1.00  2.33           C 
ATOM   1905  O   ARG   120     -14.144  -6.826  -4.471  1.00 12.04           O 
ATOM   1906  CB  ARG   120     -16.037  -5.467  -6.719  1.00  1.04           C 
ATOM   1907  CG  ARG   120     -16.304  -6.973  -6.772  1.00 73.22           C 
ATOM   1908  CD  ARG   120     -15.361  -7.713  -7.714  1.00 13.13           C 
ATOM   1909  NE  ARG   120     -15.606  -9.153  -7.688  1.00 42.00           N 
ATOM   1910  CZ  ARG   120     -15.171  -9.996  -8.582  1.00  4.14           C 
ATOM   1911  NH1 ARG   120     -14.451  -9.599  -9.583  1.00 52.34           N 
ATOM   1912  NH2 ARG   120     -15.455 -11.249  -8.463  1.00 14.03           N 
ATOM   1913  H   ARG   120     -13.113  -6.240  -6.707  1.00 36.29           H 
ATOM   1914  HA  ARG   120     -14.746  -3.977  -5.863  1.00 23.42           H 
ATOM   1915 3HB  ARG   120     -16.001  -5.097  -7.736  1.00 36.29           H 
ATOM   1916 2HB  ARG   120     -16.870  -5.000  -6.213  1.00 36.29           H 
ATOM   1917 3HG  ARG   120     -17.322  -7.130  -7.106  1.00 36.29           H 
ATOM   1918 2HG  ARG   120     -16.190  -7.382  -5.779  1.00 36.29           H 
ATOM   1919 3HD  ARG   120     -14.340  -7.525  -7.412  1.00 36.29           H 
ATOM   1920 2HD  ARG   120     -15.514  -7.346  -8.720  1.00 36.29           H 
ATOM   1921  HE  ARG   120     -16.141  -9.504  -6.947  1.00 73.14           H 
ATOM   1922 1HH1 ARG   120     -14.218  -8.637  -9.681  1.00 36.29           H 
ATOM   1923 2HH1 ARG   120     -14.127 -10.264 -10.254  1.00 36.29           H 
ATOM   1924 1HH2 ARG   120     -15.997 -11.567  -7.686  1.00 36.29           H 
ATOM   1925 2HH2 ARG   120     -15.140 -11.897  -9.151  1.00 36.29           H 
ATOM   1926  N   TYR   121     -15.137  -5.016  -3.602  1.00 61.44           N 
ATOM   1927  CA  TYR   121     -15.057  -5.499  -2.222  1.00 32.34           C 
ATOM   1928  C   TYR   121     -16.448  -5.885  -1.695  1.00  1.31           C 
ATOM   1929  O   TYR   121     -17.450  -5.283  -2.075  1.00 44.54           O 
ATOM   1930  CB  TYR   121     -14.417  -4.424  -1.344  1.00 31.21           C 
ATOM   1931  CG  TYR   121     -13.079  -3.945  -1.877  1.00 42.15           C 
ATOM   1932  CD1 TYR   121     -12.994  -2.810  -2.676  1.00 22.22           C 
ATOM   1933  CD2 TYR   121     -11.906  -4.634  -1.594  1.00 22.31           C 
ATOM   1934  CE1 TYR   121     -11.781  -2.375  -3.174  1.00 31.53           C 
ATOM   1935  CE2 TYR   121     -10.689  -4.204  -2.089  1.00 43.00           C 
ATOM   1936  CZ  TYR   121     -10.632  -3.074  -2.881  1.00  2.42           C 
ATOM   1937  OH  TYR   121      -9.422  -2.638  -3.372  1.00 23.02           O 
ATOM   1938  H   TYR   121     -15.566  -4.155  -3.780  1.00 36.29           H 
ATOM   1939  HA  TYR   121     -14.427  -6.380  -2.211  1.00 55.21           H 
ATOM   1940 3HB  TYR   121     -14.258  -4.820  -0.351  1.00 36.29           H 
ATOM   1941 2HB  TYR   121     -15.080  -3.571  -1.285  1.00 36.29           H 
ATOM   1942  HD1 TYR   121     -13.895  -2.262  -2.907  1.00 60.30           H 
ATOM   1943  HD2 TYR   121     -11.951  -5.517  -0.975  1.00 15.43           H 
ATOM   1944  HE1 TYR   121     -11.738  -1.491  -3.792  1.00 70.53           H 
ATOM   1945  HE2 TYR   121      -9.787  -4.756  -1.858  1.00  2.23           H 
ATOM   1946  HH  TYR   121      -8.912  -3.391  -3.682  1.00 11.12           H 
ATOM   1947  N   TYR   122     -16.508  -6.891  -0.824  1.00 71.12           N 
ATOM   1948  CA  TYR   122     -17.792  -7.460  -0.385  1.00  4.51           C 
ATOM   1949  C   TYR   122     -18.089  -7.192   1.101  1.00 13.21           C 
ATOM   1950  O   TYR   122     -17.336  -7.607   1.982  1.00  0.03           O 
ATOM   1951  CB  TYR   122     -17.802  -8.974  -0.641  1.00 41.43           C 
ATOM   1952  CG  TYR   122     -17.747  -9.356  -2.112  1.00 23.53           C 
ATOM   1953  CD1 TYR   122     -16.604  -9.120  -2.870  1.00 42.45           C 
ATOM   1954  CD2 TYR   122     -18.835  -9.954  -2.740  1.00 52.10           C 
ATOM   1955  CE1 TYR   122     -16.549  -9.467  -4.203  1.00 23.30           C 
ATOM   1956  CE2 TYR   122     -18.784 -10.306  -4.077  1.00  0.13           C 
ATOM   1957  CZ  TYR   122     -17.638 -10.058  -4.803  1.00 42.13           C 
ATOM   1958  OH  TYR   122     -17.582 -10.400  -6.136  1.00 14.43           O 
ATOM   1959  H   TYR   122     -15.673  -7.263  -0.471  1.00 36.29           H 
ATOM   1960  HA  TYR   122     -18.576  -7.007  -0.979  1.00 54.24           H 
ATOM   1961 3HB  TYR   122     -18.702  -9.398  -0.219  1.00 36.29           H 
ATOM   1962 2HB  TYR   122     -16.943  -9.417  -0.153  1.00 36.29           H 
ATOM   1963  HD1 TYR   122     -15.750  -8.654  -2.400  1.00 52.42           H 
ATOM   1964  HD2 TYR   122     -19.731 -10.145  -2.169  1.00 51.21           H 
ATOM   1965  HE1 TYR   122     -15.651  -9.273  -4.773  1.00 34.31           H 
ATOM   1966  HE2 TYR   122     -19.640 -10.769  -4.546  1.00  1.05           H 
ATOM   1967  HH  TYR   122     -18.382 -10.089  -6.579  1.00 70.22           H 
ATOM   1968  N   ILE   123     -19.191  -6.496   1.363  1.00 61.04           N 
ATOM   1969  CA  ILE   123     -19.716  -6.327   2.724  1.00 61.25           C 
ATOM   1970  C   ILE   123     -20.884  -7.296   2.976  1.00 63.30           C 
ATOM   1971  O   ILE   123     -22.014  -7.048   2.550  1.00 15.23           O 
ATOM   1972  CB  ILE   123     -20.194  -4.867   2.978  1.00 74.12           C 
ATOM   1973  CG1 ILE   123     -18.997  -3.905   3.017  1.00 54.22           C 
ATOM   1974  CG2 ILE   123     -21.003  -4.765   4.277  1.00  1.41           C 
ATOM   1975  CD1 ILE   123     -18.094  -4.109   4.215  1.00 71.10           C 
ATOM   1976  H   ILE   123     -19.665  -6.070   0.620  1.00 36.29           H 
ATOM   1977  HA  ILE   123     -18.918  -6.552   3.422  1.00 35.31           H 
ATOM   1978  HB  ILE   123     -20.843  -4.582   2.160  1.00 71.41           H 
ATOM   1979 3HG1 ILE   123     -19.358  -2.886   3.042  1.00 36.29           H 
ATOM   1980 2HG1 ILE   123     -18.398  -4.045   2.128  1.00 36.29           H 
ATOM   1981 1HG2 ILE   123     -21.283  -3.735   4.449  1.00 36.29           H 
ATOM   1982 2HG2 ILE   123     -20.406  -5.118   5.105  1.00 36.29           H 
ATOM   1983 3HG2 ILE   123     -21.897  -5.370   4.197  1.00 36.29           H 
ATOM   1984 1HD1 ILE   123     -17.717  -5.122   4.218  1.00 36.29           H 
ATOM   1985 2HD1 ILE   123     -18.652  -3.930   5.122  1.00 36.29           H 
ATOM   1986 3HD1 ILE   123     -17.265  -3.418   4.162  1.00 36.29           H 
ATOM   1987  N   GLU   124     -20.594  -8.415   3.642  1.00 50.43           N 
ATOM   1988  CA  GLU   124     -21.624  -9.406   4.008  1.00 72.50           C 
ATOM   1989  C   GLU   124     -22.407  -9.922   2.781  1.00  0.51           C 
ATOM   1990  O   GLU   124     -23.582 -10.275   2.885  1.00  2.31           O 
ATOM   1991  CB  GLU   124     -22.587  -8.789   5.036  1.00  5.20           C 
ATOM   1992  CG  GLU   124     -21.883  -8.290   6.295  1.00 51.14           C 
ATOM   1993  CD  GLU   124     -22.824  -7.630   7.286  1.00 72.34           C 
ATOM   1994  OE1 GLU   124     -23.029  -6.398   7.200  1.00 62.23           O 
ATOM   1995  OE2 GLU   124     -23.355  -8.339   8.163  1.00  1.41           O 
ATOM   1996  H   GLU   124     -19.663  -8.580   3.904  1.00 36.29           H 
ATOM   1997  HA  GLU   124     -21.120 -10.243   4.466  1.00 14.23           H 
ATOM   1998 3HB  GLU   124     -23.315  -9.534   5.324  1.00 36.29           H 
ATOM   1999 2HB  GLU   124     -23.100  -7.953   4.578  1.00 36.29           H 
ATOM   2000 3HG  GLU   124     -21.125  -7.576   6.007  1.00 36.29           H 
ATOM   2001 2HG  GLU   124     -21.410  -9.132   6.782  1.00 36.29           H 
ATOM   2002  N   GLY   125     -21.740  -9.994   1.628  1.00 34.43           N 
ATOM   2003  CA  GLY   125     -22.396 -10.443   0.395  1.00 11.53           C 
ATOM   2004  C   GLY   125     -22.812  -9.294  -0.524  1.00 42.35           C 
ATOM   2005  O   GLY   125     -23.328  -9.521  -1.623  1.00 42.41           O 
ATOM   2006  H   GLY   125     -20.786  -9.770   1.615  1.00 36.29           H 
ATOM   2007 3HA  GLY   125     -23.275 -11.017   0.655  1.00 36.29           H 
ATOM   2008 2HA  GLY   125     -21.713 -11.083  -0.142  1.00 36.29           H 
ATOM   2009  N   ARG   126     -22.592  -8.063  -0.075  1.00 45.25           N 
ATOM   2010  CA  ARG   126     -22.955  -6.864  -0.843  1.00 31.22           C 
ATOM   2011  C   ARG   126     -21.713  -6.201  -1.471  1.00 73.32           C 
ATOM   2012  O   ARG   126     -20.830  -5.721  -0.762  1.00 30.15           O 
ATOM   2013  CB  ARG   126     -23.690  -5.882   0.082  1.00 13.45           C 
ATOM   2014  CG  ARG   126     -23.968  -4.510  -0.524  1.00  1.50           C 
ATOM   2015  CD  ARG   126     -24.833  -3.664   0.403  1.00 43.53           C 
ATOM   2016  NE  ARG   126     -24.871  -2.260   0.000  1.00 73.00           N 
ATOM   2017  CZ  ARG   126     -25.952  -1.533  -0.026  1.00 54.42           C 
ATOM   2018  NH1 ARG   126     -27.111  -2.060   0.202  1.00 32.24           N 
ATOM   2019  NH2 ARG   126     -25.872  -0.275  -0.293  1.00 23.22           N 
ATOM   2020  H   ARG   126     -22.182  -7.951   0.808  1.00 36.29           H 
ATOM   2021  HA  ARG   126     -23.626  -7.166  -1.634  1.00  5.14           H 
ATOM   2022 3HB  ARG   126     -23.094  -5.741   0.974  1.00 36.29           H 
ATOM   2023 2HB  ARG   126     -24.636  -6.320   0.364  1.00 36.29           H 
ATOM   2024 3HG  ARG   126     -24.482  -4.637  -1.467  1.00 36.29           H 
ATOM   2025 2HG  ARG   126     -23.029  -4.001  -0.689  1.00 36.29           H 
ATOM   2026 3HD  ARG   126     -24.433  -3.726   1.407  1.00 36.29           H 
ATOM   2027 2HD  ARG   126     -25.839  -4.059   0.396  1.00 36.29           H 
ATOM   2028  HE  ARG   126     -24.020  -1.834  -0.220  1.00 22.03           H 
ATOM   2029 1HH1 ARG   126     -27.187  -3.034   0.399  1.00 36.29           H 
ATOM   2030 2HH1 ARG   126     -27.931  -1.491   0.180  1.00 36.29           H 
ATOM   2031 1HH2 ARG   126     -24.990   0.139  -0.486  1.00 36.29           H 
ATOM   2032 2HH2 ARG   126     -26.697   0.289  -0.284  1.00 36.29           H 
ATOM   2033  N   GLU   127     -21.651  -6.181  -2.805  1.00  3.43           N 
ATOM   2034  CA  GLU   127     -20.499  -5.610  -3.526  1.00 23.43           C 
ATOM   2035  C   GLU   127     -20.452  -4.075  -3.422  1.00 73.44           C 
ATOM   2036  O   GLU   127     -21.470  -3.395  -3.578  1.00 75.52           O 
ATOM   2037  CB  GLU   127     -20.531  -6.031  -5.005  1.00 34.52           C 
ATOM   2038  CG  GLU   127     -20.492  -7.542  -5.217  1.00 23.15           C 
ATOM   2039  CD  GLU   127     -20.491  -7.936  -6.690  1.00 21.12           C 
ATOM   2040  OE1 GLU   127     -21.513  -7.698  -7.369  1.00 32.20           O 
ATOM   2041  OE2 GLU   127     -19.483  -8.500  -7.169  1.00 20.22           O 
ATOM   2042  H   GLU   127     -22.393  -6.564  -3.321  1.00 36.29           H 
ATOM   2043  HA  GLU   127     -19.601  -6.012  -3.075  1.00 63.25           H 
ATOM   2044 3HB  GLU   127     -19.680  -5.597  -5.510  1.00 36.29           H 
ATOM   2045 2HB  GLU   127     -21.437  -5.648  -5.457  1.00 36.29           H 
ATOM   2046 3HG  GLU   127     -21.360  -7.980  -4.743  1.00 36.29           H 
ATOM   2047 2HG  GLU   127     -19.598  -7.934  -4.749  1.00 36.29           H 
ATOM   2048  N   ILE   128     -19.256  -3.544  -3.166  1.00  2.14           N 
ATOM   2049  CA  ILE   128     -19.042  -2.099  -3.017  1.00 13.41           C 
ATOM   2050  C   ILE   128     -18.389  -1.498  -4.276  1.00 60.24           C 
ATOM   2051  O   ILE   128     -17.491  -2.103  -4.868  1.00 23.33           O 
ATOM   2052  CB  ILE   128     -18.137  -1.794  -1.793  1.00 44.41           C 
ATOM   2053  CG1 ILE   128     -18.641  -2.537  -0.542  1.00 63.42           C 
ATOM   2054  CG2 ILE   128     -18.069  -0.288  -1.534  1.00 71.34           C 
ATOM   2055  CD1 ILE   128     -20.042  -2.154  -0.116  1.00 51.12           C 
ATOM   2056  H   ILE   128     -18.488  -4.144  -3.072  1.00 36.29           H 
ATOM   2057  HA  ILE   128     -20.004  -1.626  -2.858  1.00  4.01           H 
ATOM   2058  HB  ILE   128     -17.136  -2.137  -2.021  1.00 64.42           H 
ATOM   2059 3HG1 ILE   128     -17.976  -2.331   0.284  1.00 36.29           H 
ATOM   2060 2HG1 ILE   128     -18.639  -3.601  -0.738  1.00 36.29           H 
ATOM   2061 1HG2 ILE   128     -17.653   0.207  -2.400  1.00 36.29           H 
ATOM   2062 2HG2 ILE   128     -17.442  -0.095  -0.675  1.00 36.29           H 
ATOM   2063 3HG2 ILE   128     -19.063   0.093  -1.346  1.00 36.29           H 
ATOM   2064 1HD1 ILE   128     -20.324  -2.735   0.748  1.00 36.29           H 
ATOM   2065 2HD1 ILE   128     -20.732  -2.351  -0.923  1.00 36.29           H 
ATOM   2066 3HD1 ILE   128     -20.069  -1.103   0.134  1.00 36.29           H 
ATOM   2067  N   ASP   129     -18.830  -0.303  -4.667  1.00 10.23           N 
ATOM   2068  CA  ASP   129     -18.320   0.368  -5.871  1.00 53.10           C 
ATOM   2069  C   ASP   129     -16.919   0.983  -5.656  1.00 64.35           C 
ATOM   2070  O   ASP   129     -16.748   2.206  -5.689  1.00  1.51           O 
ATOM   2071  CB  ASP   129     -19.308   1.456  -6.304  1.00  2.33           C 
ATOM   2072  CG  ASP   129     -20.702   0.910  -6.541  1.00 40.11           C 
ATOM   2073  OD1 ASP   129     -21.429   0.674  -5.552  1.00 24.23           O 
ATOM   2074  OD2 ASP   129     -21.082   0.722  -7.714  1.00 21.40           O 
ATOM   2075  H   ASP   129     -19.529   0.139  -4.141  1.00 36.29           H 
ATOM   2076  HA  ASP   129     -18.255  -0.371  -6.657  1.00 22.45           H 
ATOM   2077 3HB  ASP   129     -18.956   1.911  -7.219  1.00 36.29           H 
ATOM   2078 2HB  ASP   129     -19.364   2.210  -5.531  1.00 36.29           H 
ATOM   2079  N   LEU   130     -15.920   0.130  -5.439  1.00  3.51           N 
ATOM   2080  CA  LEU   130     -14.531   0.578  -5.238  1.00 61.03           C 
ATOM   2081  C   LEU   130     -13.562  -0.220  -6.127  1.00 74.21           C 
ATOM   2082  O   LEU   130     -13.376  -1.421  -5.928  1.00 53.25           O 
ATOM   2083  CB  LEU   130     -14.124   0.427  -3.761  1.00 74.02           C 
ATOM   2084  CG  LEU   130     -14.939   1.257  -2.750  1.00 72.05           C 
ATOM   2085  CD1 LEU   130     -14.503   0.942  -1.319  1.00 35.30           C 
ATOM   2086  CD2 LEU   130     -14.803   2.753  -3.038  1.00 43.21           C 
ATOM   2087  H   LEU   130     -16.116  -0.831  -5.421  1.00 36.29           H 
ATOM   2088  HA  LEU   130     -14.471   1.622  -5.514  1.00 44.34           H 
ATOM   2089 3HB  LEU   130     -13.083   0.710  -3.666  1.00 36.29           H 
ATOM   2090 2HB  LEU   130     -14.217  -0.616  -3.494  1.00 36.29           H 
ATOM   2091  HG  LEU   130     -15.985   0.994  -2.841  1.00 12.31           H 
ATOM   2092 1HD1 LEU   130     -15.095   1.524  -0.625  1.00 36.29           H 
ATOM   2093 2HD1 LEU   130     -13.459   1.188  -1.195  1.00 36.29           H 
ATOM   2094 3HD1 LEU   130     -14.649  -0.110  -1.119  1.00 36.29           H 
ATOM   2095 1HD2 LEU   130     -15.174   2.967  -4.030  1.00 36.29           H 
ATOM   2096 2HD2 LEU   130     -13.763   3.042  -2.973  1.00 36.29           H 
ATOM   2097 3HD2 LEU   130     -15.376   3.313  -2.312  1.00 36.29           H 
ATOM   2098  N   GLY   131     -12.948   0.452  -7.101  1.00 45.24           N 
ATOM   2099  CA  GLY   131     -12.041  -0.222  -8.029  1.00 14.03           C 
ATOM   2100  C   GLY   131     -10.564   0.103  -7.802  1.00 62.02           C 
ATOM   2101  O   GLY   131      -9.718  -0.795  -7.819  1.00  1.13           O 
ATOM   2102  H   GLY   131     -13.122   1.412  -7.203  1.00 36.29           H 
ATOM   2103 3HA  GLY   131     -12.304   0.069  -9.036  1.00 36.29           H 
ATOM   2104 2HA  GLY   131     -12.175  -1.291  -7.937  1.00 36.29           H 
ATOM   2105  N   TYR   132     -10.244   1.385  -7.598  1.00 45.14           N 
ATOM   2106  CA  TYR   132      -8.845   1.811  -7.437  1.00  1.23           C 
ATOM   2107  C   TYR   132      -8.724   3.175  -6.724  1.00 64.11           C 
ATOM   2108  O   TYR   132      -8.341   3.239  -5.553  1.00 23.12           O 
ATOM   2109  CB  TYR   132      -8.156   1.872  -8.812  1.00 71.04           C 
ATOM   2110  CG  TYR   132      -6.671   2.197  -8.754  1.00  1.22           C 
ATOM   2111  CD1 TYR   132      -6.208   3.502  -8.918  1.00 24.34           C 
ATOM   2112  CD2 TYR   132      -5.730   1.194  -8.540  1.00 40.31           C 
ATOM   2113  CE1 TYR   132      -4.858   3.792  -8.869  1.00  2.13           C 
ATOM   2114  CE2 TYR   132      -4.380   1.479  -8.489  1.00 42.44           C 
ATOM   2115  CZ  TYR   132      -3.948   2.778  -8.655  1.00  3.14           C 
ATOM   2116  OH  TYR   132      -2.601   3.065  -8.606  1.00 52.01           O 
ATOM   2117  H   TYR   132     -10.961   2.053  -7.549  1.00 36.29           H 
ATOM   2118  HA  TYR   132      -8.344   1.065  -6.834  1.00 63.41           H 
ATOM   2119 3HB  TYR   132      -8.641   2.630  -9.412  1.00 36.29           H 
ATOM   2120 2HB  TYR   132      -8.266   0.914  -9.303  1.00 36.29           H 
ATOM   2121  HD1 TYR   132      -6.922   4.295  -9.085  1.00 64.32           H 
ATOM   2122  HD2 TYR   132      -6.069   0.176  -8.409  1.00 13.42           H 
ATOM   2123  HE1 TYR   132      -4.519   4.810  -8.997  1.00 20.44           H 
ATOM   2124  HE2 TYR   132      -3.666   0.684  -8.323  1.00 11.35           H 
ATOM   2125  HH  TYR   132      -2.450   3.807  -8.015  1.00  3.43           H 
ATOM   2126  N   GLY   133      -9.071   4.255  -7.436  1.00 51.33           N 
ATOM   2127  CA  GLY   133      -8.870   5.614  -6.924  1.00 13.10           C 
ATOM   2128  C   GLY   133      -9.509   5.864  -5.560  1.00 40.20           C 
ATOM   2129  O   GLY   133      -8.873   6.404  -4.657  1.00 13.21           O 
ATOM   2130  H   GLY   133      -9.477   4.130  -8.322  1.00 36.29           H 
ATOM   2131 3HA  GLY   133      -9.290   6.313  -7.635  1.00 36.29           H 
ATOM   2132 2HA  GLY   133      -7.808   5.801  -6.848  1.00 36.29           H 
ATOM   2133  N   GLU   134     -10.769   5.477  -5.411  1.00 14.42           N 
ATOM   2134  CA  GLU   134     -11.477   5.632  -4.139  1.00 14.32           C 
ATOM   2135  C   GLU   134     -11.047   4.559  -3.127  1.00 52.13           C 
ATOM   2136  O   GLU   134     -11.004   4.806  -1.924  1.00 35.42           O 
ATOM   2137  CB  GLU   134     -12.994   5.561  -4.367  1.00 42.30           C 
ATOM   2138  CG  GLU   134     -13.506   6.514  -5.445  1.00 54.42           C 
ATOM   2139  CD  GLU   134     -13.287   7.985  -5.110  1.00 32.14           C 
ATOM   2140  OE1 GLU   134     -12.181   8.506  -5.365  1.00 10.42           O 
ATOM   2141  OE2 GLU   134     -14.229   8.633  -4.613  1.00  3.31           O 
ATOM   2142  H   GLU   134     -11.236   5.078  -6.174  1.00 36.29           H 
ATOM   2143  HA  GLU   134     -11.229   6.606  -3.738  1.00 11.20           H 
ATOM   2144 3HB  GLU   134     -13.499   5.797  -3.440  1.00 36.29           H 
ATOM   2145 2HB  GLU   134     -13.256   4.553  -4.656  1.00 36.29           H 
ATOM   2146 3HG  GLU   134     -14.565   6.343  -5.580  1.00 36.29           H 
ATOM   2147 2HG  GLU   134     -12.991   6.294  -6.371  1.00 36.29           H 
ATOM   2148  N   ALA   135     -10.703   3.373  -3.630  1.00 32.24           N 
ATOM   2149  CA  ALA   135     -10.360   2.223  -2.778  1.00 13.22           C 
ATOM   2150  C   ALA   135      -9.159   2.502  -1.854  1.00 64.43           C 
ATOM   2151  O   ALA   135      -9.058   1.931  -0.768  1.00 72.22           O 
ATOM   2152  CB  ALA   135     -10.092   0.994  -3.640  1.00  0.25           C 
ATOM   2153  H   ALA   135     -10.672   3.267  -4.603  1.00 36.29           H 
ATOM   2154  HA  ALA   135     -11.223   2.006  -2.160  1.00 21.24           H 
ATOM   2155 1HB  ALA   135      -9.200   1.152  -4.231  1.00 36.29           H 
ATOM   2156 2HB  ALA   135     -10.932   0.825  -4.300  1.00 36.29           H 
ATOM   2157 3HB  ALA   135      -9.956   0.128  -3.007  1.00 36.29           H 
ATOM   2158  N   THR   136      -8.253   3.382  -2.283  1.00  1.31           N 
ATOM   2159  CA  THR   136      -7.082   3.750  -1.460  1.00 43.53           C 
ATOM   2160  C   THR   136      -7.462   4.690  -0.303  1.00 35.52           C 
ATOM   2161  O   THR   136      -6.651   4.957   0.586  1.00  1.42           O 
ATOM   2162  CB  THR   136      -5.969   4.427  -2.303  1.00  2.12           C 
ATOM   2163  OG1 THR   136      -4.807   4.668  -1.493  1.00 12.44           O 
ATOM   2164  CG2 THR   136      -6.450   5.744  -2.903  1.00 50.10           C 
ATOM   2165  H   THR   136      -8.361   3.783  -3.175  1.00 36.29           H 
ATOM   2166  HA  THR   136      -6.676   2.838  -1.042  1.00 73.22           H 
ATOM   2167  HB  THR   136      -5.698   3.759  -3.110  1.00 11.11           H 
ATOM   2168  HG1 THR   136      -5.076   5.022  -0.638  1.00 72.40           H 
ATOM   2169 1HG2 THR   136      -7.315   5.565  -3.525  1.00 36.29           H 
ATOM   2170 2HG2 THR   136      -5.662   6.178  -3.501  1.00 36.29           H 
ATOM   2171 3HG2 THR   136      -6.715   6.429  -2.109  1.00 36.29           H 
ATOM   2172  N   LYS   137      -8.693   5.194  -0.325  1.00  0.45           N 
ATOM   2173  CA  LYS   137      -9.171   6.133   0.698  1.00 32.52           C 
ATOM   2174  C   LYS   137      -9.853   5.400   1.868  1.00  3.21           C 
ATOM   2175  O   LYS   137     -10.067   5.980   2.938  1.00  4.43           O 
ATOM   2176  CB  LYS   137     -10.137   7.139   0.054  1.00 72.22           C 
ATOM   2177  CG  LYS   137      -9.533   7.870  -1.145  1.00 73.34           C 
ATOM   2178  CD  LYS   137     -10.552   8.761  -1.852  1.00 23.35           C 
ATOM   2179  CE  LYS   137      -9.944   9.465  -3.064  1.00 30.11           C 
ATOM   2180  NZ  LYS   137     -10.926  10.344  -3.752  1.00 45.11           N 
ATOM   2181  H   LYS   137      -9.299   4.933  -1.050  1.00 36.29           H 
ATOM   2182  HA  LYS   137      -8.316   6.671   1.084  1.00 52.10           H 
ATOM   2183 3HB  LYS   137     -10.423   7.874   0.792  1.00 36.29           H 
ATOM   2184 2HB  LYS   137     -11.022   6.611  -0.278  1.00 36.29           H 
ATOM   2185 3HG  LYS   137      -9.162   7.136  -1.848  1.00 36.29           H 
ATOM   2186 2HG  LYS   137      -8.712   8.485  -0.804  1.00 36.29           H 
ATOM   2187 3HD  LYS   137     -10.909   9.506  -1.155  1.00 36.29           H 
ATOM   2188 2HD  LYS   137     -11.381   8.150  -2.182  1.00 36.29           H 
ATOM   2189 3HE  LYS   137      -9.595   8.717  -3.761  1.00 36.29           H 
ATOM   2190 2HE  LYS   137      -9.108  10.067  -2.736  1.00 36.29           H 
ATOM   2191 1HZ  LYS   137     -10.459  10.867  -4.522  1.00 36.29           H 
ATOM   2192 2HZ  LYS   137     -11.333  11.027  -3.081  1.00 36.29           H 
ATOM   2193 3HZ  LYS   137     -11.695   9.771  -4.159  1.00 36.29           H 
ATOM   2194  N   ILE   138     -10.192   4.126   1.658  1.00 60.30           N 
ATOM   2195  CA  ILE   138     -10.785   3.292   2.714  1.00 62.30           C 
ATOM   2196  C   ILE   138      -9.712   2.400   3.357  1.00 50.30           C 
ATOM   2197  O   ILE   138      -9.086   1.582   2.678  1.00 52.20           O 
ATOM   2198  CB  ILE   138     -11.935   2.386   2.180  1.00 71.20           C 
ATOM   2199  CG1 ILE   138     -13.093   3.223   1.601  1.00  0.22           C 
ATOM   2200  CG2 ILE   138     -12.456   1.467   3.290  1.00 55.43           C 
ATOM   2201  CD1 ILE   138     -12.779   3.906   0.287  1.00 51.44           C 
ATOM   2202  H   ILE   138     -10.031   3.732   0.775  1.00 36.29           H 
ATOM   2203  HA  ILE   138     -11.193   3.950   3.471  1.00 42.11           H 
ATOM   2204  HB  ILE   138     -11.530   1.759   1.397  1.00 72.45           H 
ATOM   2205 3HG1 ILE   138     -13.364   3.990   2.315  1.00 36.29           H 
ATOM   2206 2HG1 ILE   138     -13.947   2.581   1.438  1.00 36.29           H 
ATOM   2207 1HG2 ILE   138     -13.269   0.864   2.909  1.00 36.29           H 
ATOM   2208 2HG2 ILE   138     -12.808   2.063   4.118  1.00 36.29           H 
ATOM   2209 3HG2 ILE   138     -11.659   0.819   3.628  1.00 36.29           H 
ATOM   2210 1HD1 ILE   138     -12.508   3.166  -0.450  1.00 36.29           H 
ATOM   2211 2HD1 ILE   138     -11.957   4.594   0.425  1.00 36.29           H 
ATOM   2212 3HD1 ILE   138     -13.648   4.450  -0.053  1.00 36.29           H 
ATOM   2213  N   TRP   139      -9.507   2.557   4.663  1.00 34.04           N 
ATOM   2214  CA  TRP   139      -8.464   1.812   5.381  1.00 62.21           C 
ATOM   2215  C   TRP   139      -9.060   0.686   6.244  1.00 73.43           C 
ATOM   2216  O   TRP   139     -10.042   0.886   6.972  1.00 54.32           O 
ATOM   2217  CB  TRP   139      -7.639   2.774   6.242  1.00 72.31           C 
ATOM   2218  CG  TRP   139      -6.849   3.766   5.435  1.00 12.05           C 
ATOM   2219  CD1 TRP   139      -7.347   4.748   4.628  1.00 14.33           C 
ATOM   2220  CD2 TRP   139      -5.420   3.875   5.361  1.00 24.53           C 
ATOM   2221  NE1 TRP   139      -6.319   5.453   4.052  1.00 52.22           N 
ATOM   2222  CE2 TRP   139      -5.129   4.938   4.487  1.00 34.30           C 
ATOM   2223  CE3 TRP   139      -4.360   3.175   5.944  1.00 50.24           C 
ATOM   2224  CZ2 TRP   139      -3.822   5.321   4.189  1.00 25.22           C 
ATOM   2225  CZ3 TRP   139      -3.064   3.555   5.648  1.00 32.41           C 
ATOM   2226  CH2 TRP   139      -2.805   4.618   4.775  1.00 30.23           C 
ATOM   2227  H   TRP   139     -10.074   3.183   5.164  1.00 36.29           H 
ATOM   2228  HA  TRP   139      -7.812   1.366   4.641  1.00 33.35           H 
ATOM   2229 3HB  TRP   139      -6.944   2.207   6.846  1.00 36.29           H 
ATOM   2230 2HB  TRP   139      -8.303   3.327   6.891  1.00 36.29           H 
ATOM   2231  HD1 TRP   139      -8.399   4.928   4.470  1.00 44.54           H 
ATOM   2232  HE1 TRP   139      -6.424   6.204   3.431  1.00 35.00           H 
ATOM   2233  HE3 TRP   139      -4.540   2.349   6.620  1.00 21.20           H 
ATOM   2234  HZ2 TRP   139      -3.605   6.140   3.518  1.00 53.50           H 
ATOM   2235  HZ3 TRP   139      -2.234   3.026   6.092  1.00 34.22           H 
ATOM   2236  HH2 TRP   139      -1.777   4.881   4.571  1.00 14.23           H 
ATOM   2237  N   VAL   140      -8.449  -0.496   6.161  1.00  0.54           N 
ATOM   2238  CA  VAL   140      -8.938  -1.696   6.851  1.00 32.24           C 
ATOM   2239  C   VAL   140      -7.802  -2.448   7.571  1.00 64.04           C 
ATOM   2240  O   VAL   140      -6.622  -2.139   7.395  1.00 32.00           O 
ATOM   2241  CB  VAL   140      -9.619  -2.665   5.851  1.00 10.53           C 
ATOM   2242  CG1 VAL   140     -10.863  -2.025   5.239  1.00 65.31           C 
ATOM   2243  CG2 VAL   140      -8.634  -3.094   4.760  1.00 12.24           C 
ATOM   2244  H   VAL   140      -7.634  -0.566   5.620  1.00 36.29           H 
ATOM   2245  HA  VAL   140      -9.673  -1.391   7.585  1.00 32.01           H 
ATOM   2246  HB  VAL   140      -9.930  -3.549   6.392  1.00  4.45           H 
ATOM   2247 1HG1 VAL   140     -10.581  -1.133   4.698  1.00 36.29           H 
ATOM   2248 2HG1 VAL   140     -11.558  -1.767   6.022  1.00 36.29           H 
ATOM   2249 3HG1 VAL   140     -11.332  -2.722   4.560  1.00 36.29           H 
ATOM   2250 1HG2 VAL   140      -9.113  -3.802   4.097  1.00 36.29           H 
ATOM   2251 2HG2 VAL   140      -7.769  -3.557   5.215  1.00 36.29           H 
ATOM   2252 3HG2 VAL   140      -8.322  -2.229   4.194  1.00 36.29           H 
ATOM   2253  N   ARG   141      -8.170  -3.442   8.383  1.00 63.11           N 
ATOM   2254  CA  ARG   141      -7.185  -4.279   9.087  1.00 51.13           C 
ATOM   2255  C   ARG   141      -7.414  -5.772   8.793  1.00 12.45           C 
ATOM   2256  O   ARG   141      -8.551  -6.218   8.640  1.00 24.20           O 
ATOM   2257  CB  ARG   141      -7.246  -4.032  10.602  1.00  0.25           C 
ATOM   2258  CG  ARG   141      -7.161  -2.558  10.991  1.00  0.14           C 
ATOM   2259  CD  ARG   141      -6.786  -2.374  12.455  1.00 54.21           C 
ATOM   2260  NE  ARG   141      -5.429  -2.848  12.727  1.00 53.01           N 
ATOM   2261  CZ  ARG   141      -4.869  -2.849  13.904  1.00 10.01           C 
ATOM   2262  NH1 ARG   141      -5.511  -2.417  14.941  1.00 24.05           N 
ATOM   2263  NH2 ARG   141      -3.659  -3.286  14.042  1.00 32.42           N 
ATOM   2264  H   ARG   141      -9.125  -3.617   8.517  1.00 36.29           H 
ATOM   2265  HA  ARG   141      -6.202  -4.006   8.728  1.00 31.52           H 
ATOM   2266 3HB  ARG   141      -6.424  -4.555  11.071  1.00 36.29           H 
ATOM   2267 2HB  ARG   141      -8.176  -4.430  10.984  1.00 36.29           H 
ATOM   2268 3HG  ARG   141      -8.121  -2.093  10.813  1.00 36.29           H 
ATOM   2269 2HG  ARG   141      -6.411  -2.078  10.380  1.00 36.29           H 
ATOM   2270 3HD  ARG   141      -7.483  -2.930  13.066  1.00 36.29           H 
ATOM   2271 2HD  ARG   141      -6.849  -1.324  12.703  1.00 36.29           H 
ATOM   2272  HE  ARG   141      -4.909  -3.187  11.973  1.00 25.03           H 
ATOM   2273 1HH1 ARG   141      -6.443  -2.080  14.848  1.00 36.29           H 
ATOM   2274 2HH1 ARG   141      -5.073  -2.433  15.838  1.00 36.29           H 
ATOM   2275 1HH2 ARG   141      -3.157  -3.623  13.247  1.00 36.29           H 
ATOM   2276 2HH2 ARG   141      -3.229  -3.293  14.942  1.00 36.29           H 
ATOM   2277  N   ARG   142      -6.328  -6.540   8.717  1.00 31.12           N 
ATOM   2278  CA  ARG   142      -6.410  -7.976   8.407  1.00 50.41           C 
ATOM   2279  C   ARG   142      -6.858  -8.784   9.639  1.00 14.23           C 
ATOM   2280  O   ARG   142      -6.099  -8.953  10.593  1.00 51.22           O 
ATOM   2281  CB  ARG   142      -5.036  -8.463   7.909  1.00  3.44           C 
ATOM   2282  CG  ARG   142      -4.971  -9.932   7.482  1.00 71.22           C 
ATOM   2283  CD  ARG   142      -5.908 -10.249   6.313  1.00 43.30           C 
ATOM   2284  NE  ARG   142      -5.277 -11.114   5.314  1.00  4.21           N 
ATOM   2285  CZ  ARG   142      -5.064 -12.395   5.460  1.00 43.14           C 
ATOM   2286  NH1 ARG   142      -5.406 -12.998   6.554  1.00 73.50           N 
ATOM   2287  NH2 ARG   142      -4.502 -13.067   4.507  1.00 15.44           N 
ATOM   2288  H   ARG   142      -5.449  -6.137   8.876  1.00 36.29           H 
ATOM   2289  HA  ARG   142      -7.136  -8.106   7.617  1.00 11.02           H 
ATOM   2290 3HB  ARG   142      -4.314  -8.313   8.699  1.00 36.29           H 
ATOM   2291 2HB  ARG   142      -4.746  -7.861   7.062  1.00 36.29           H 
ATOM   2292 3HG  ARG   142      -5.242 -10.551   8.327  1.00 36.29           H 
ATOM   2293 2HG  ARG   142      -3.957 -10.159   7.187  1.00 36.29           H 
ATOM   2294 3HD  ARG   142      -6.198  -9.323   5.835  1.00 36.29           H 
ATOM   2295 2HD  ARG   142      -6.790 -10.742   6.697  1.00 36.29           H 
ATOM   2296  HE  ARG   142      -5.003 -10.702   4.473  1.00 13.45           H 
ATOM   2297 1HH1 ARG   142      -5.836 -12.489   7.285  1.00 36.29           H 
ATOM   2298 2HH1 ARG   142      -5.224 -13.976   6.661  1.00 36.29           H 
ATOM   2299 1HH2 ARG   142      -4.233 -12.602   3.661  1.00 36.29           H 
ATOM   2300 2HH2 ARG   142      -4.336 -14.043   4.613  1.00 36.29           H 
ATOM   2301  N   VAL   143      -8.093  -9.288   9.607  1.00 22.51           N 
ATOM   2302  CA  VAL   143      -8.649 -10.049  10.739  1.00 13.35           C 
ATOM   2303  C   VAL   143      -8.612 -11.568  10.496  1.00 21.13           C 
ATOM   2304  O   VAL   143      -8.180 -12.329  11.365  1.00 62.05           O 
ATOM   2305  CB  VAL   143     -10.104  -9.615  11.064  1.00 33.44           C 
ATOM   2306  CG1 VAL   143     -10.136  -8.189  11.600  1.00  3.53           C 
ATOM   2307  CG2 VAL   143     -11.010  -9.743   9.841  1.00 65.43           C 
ATOM   2308  H   VAL   143      -8.652  -9.131   8.816  1.00 36.29           H 
ATOM   2309  HA  VAL   143      -8.039  -9.831  11.608  1.00 35.11           H 
ATOM   2310  HB  VAL   143     -10.487 -10.271  11.836  1.00 21.23           H 
ATOM   2311 1HG1 VAL   143      -9.552  -8.129  12.505  1.00 36.29           H 
ATOM   2312 2HG1 VAL   143     -11.158  -7.908  11.812  1.00 36.29           H 
ATOM   2313 3HG1 VAL   143      -9.726  -7.516  10.859  1.00 36.29           H 
ATOM   2314 1HG2 VAL   143     -10.646  -9.098   9.053  1.00 36.29           H 
ATOM   2315 2HG2 VAL   143     -12.017  -9.455  10.104  1.00 36.29           H 
ATOM   2316 3HG2 VAL   143     -11.011 -10.768   9.497  1.00 36.29           H 
END
