
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   64 ( 1024),  selected   64 , name 2juf_A
# Molecule2: number of CA atoms   67 ( 1113),  selected   67 , name T0462_77_143.pdb
# PARAMETERS: 2juf_A.T0462_77_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E      77           -
LGA    Y    14_A      L      78          4.049
LGA    G    15_A      P      79          3.355
LGA    E    16_A      L      80           -
LGA    Y    17_A      I      81           -
LGA    V    18_A      -       -           -
LGA    Q    19_A      L      82          0.824
LGA    Q    20_A      A      83          5.530
LGA    T    21_A      D      84          2.692
LGA    L    22_A      -       -           -
LGA    Q    23_A      D      85          2.334
LGA    P    24_A      -       -           -
LGA    G    25_A      -       -           -
LGA    M    26_A      G      86          0.125
LGA    R    27_A      T      87          0.420
LGA    V    28_A      Y      88          1.739
LGA    R    29_A      E      89          2.112
LGA    M    30_A      I      90          2.270
LGA    L    31_A      T      91          2.642
LGA    D    32_A      K      92          3.782
LGA    -       -      L      93           -
LGA    -       -      N      94           -
LGA    -       -      G      95           -
LGA    -       -      G      96           -
LGA    -       -      R      97           -
LGA    -       -      R      98           -
LGA    -       -      F      99           -
LGA    D    33_A      L     100          5.131
LGA    Y    34_A      F     101           #
LGA    E    35_A      R     102          2.432
LGA    -       -      M     103           -
LGA    -       -      K     104           -
LGA    -       -      N     105           -
LGA    E    36_A      L     106          1.977
LGA    I    37_A      G     107          1.390
LGA    S    38_A      I     108          3.466
LGA    -       -      E     109           -
LGA    A    39_A      S     110          1.970
LGA    G    40_A      G     111          1.779
LGA    D    41_A      K     112          1.179
LGA    E    42_A      K     113          1.288
LGA    G    43_A      I     114          1.700
LGA    E    44_A      Q     115          1.119
LGA    F    45_A      V     116          1.033
LGA    R    46_A      S     117          1.523
LGA    Q    47_A      G     118          1.129
LGA    S    48_A      R     119          2.810
LGA    N    49_A      -       -           -
LGA    N    50_A      -       -           -
LGA    G    51_A      -       -           -
LGA    I    52_A      -       -           -
LGA    P    53_A      -       -           -
LGA    P    54_A      -       -           -
LGA    V    55_A      -       -           -
LGA    Q    56_A      R     120          1.146
LGA    V    57_A      Y     121          0.957
LGA    F    58_A      Y     122          0.976
LGA    W    59_A      I     123          0.198
LGA    Q    60_A      E     124          1.514
LGA    S    61_A      -       -           -
LGA    T    62_A      -       -           -
LGA    G    63_A      G     125          3.751
LGA    R    64_A      R     126          1.013
LGA    T    65_A      E     127          0.926
LGA    Y    66_A      I     128          0.631
LGA    W    67_A      D     129          2.349
LGA    V    68_A      L     130          3.522
LGA    -       -      G     131           -
LGA    -       -      Y     132           -
LGA    -       -      G     133           -
LGA    -       -      E     134           -
LGA    H    69_A      A     135          1.463
LGA    W    70_A      T     136          2.621
LGA    H    71_A      K     137          3.600
LGA    M    72_A      I     138          1.297
LGA    L    73_A      W     139          3.204
LGA    E    74_A      V     140          0.780
LGA    I    75_A      R     141          2.418
LGA    L    76_A      R     142          3.030
LGA    G    77_A      V     143          1.653

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   64   67    5.0     48    2.39     6.25     52.877     1.926

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.476728 * X  +   0.668360 * Y  +  -0.570987 * Z  + -12.683739
  Y_new =  -0.775090 * X  +  -0.626020 * Y  +  -0.085641 * Z  +  -3.247726
  Z_new =  -0.414688 * X  +   0.401739 * Y  +   0.816480 * Z  +   0.963845 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.457257   -2.684335  [ DEG:    26.1989   -153.8011 ]
  Theta =   0.427600    2.713992  [ DEG:    24.4997    155.5003 ]
  Phi   =  -2.122216    1.019376  [ DEG:  -121.5940     58.4059 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2juf_A                                        
REMARK     2: T0462_77_143.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2juf_A.T0462_77_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   64   67   5.0   48   2.39    6.25  52.877
REMARK  ---------------------------------------------------------- 
MOLECULE 2juf_A
HEADER    GENE REGULATION                         23-AUG-07   2JUF              
TITLE     NMR SOLUTION STRUCTURE OF PARC CPH DOMAIN. NESG TARGET                
TITLE    2 HR3443B/SGC-TORONTO                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P53-ASSOCIATED PARKIN-LIKE CYTOPLASMIC PROTEIN;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CPH DOMAIN: RESIDUES 366-466;                              
COMPND   5 SYNONYM: UBCH7-ASSOCIATED PROTEIN 1;                                 
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PARC, H7AP1, KIAA0708;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    CPH DOMAIN, STRUCTURAL GENOMICS CONSORTIUM, SGC, NORTHEAST            
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, NESG, ALTERNATIVE SPLICING,          
KEYWDS   3 ATP-BINDING, COILED COIL, CYTOPLASM, METAL-BINDING,                  
KEYWDS   4 NUCLEOTIDE-BINDING, UBL CONJUGATION, UBL CONJUGATION                 
KEYWDS   5 PATHWAY, ZINC, ZINC-FINGER, PSI-2, PROTEIN STRUCTURE                 
KEYWDS   6 INITIATIVE, GENE REGULATION                                          
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    L.KAUSTOV,J.C.C.LIAO,S.LEMAK,S.DUAN,R.MUHANDIRAM,M.KARRA,             
AUTHOR   2 S.H.SRISAILAM,M.SUNDSTROM,J.WEIGELT,A.M.EDWARDS,S.DHE-               
AUTHOR   3 PAGANON,C.H.ARROWSMITH,STRUCTURAL GENOMICS CONSORTIUM (SGC),         
AUTHOR   4 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   1   16-OCT-07 2JUF    0                                                
JRNL        AUTH   L.KAUSTOV,J.C.C.LIAO,S.LEMAK,S.DUAN,R.MUHANDIRAM,            
JRNL        AUTH 2 M.KARRA,S.H.SRISAILAM,M.SUNDSTROM,J.WEIGELT,                 
JRNL        AUTH 3 A.M.EDWARDS,S.DHE-PAGANON,C.H.ARROWSMITH                     
JRNL        TITL   NMR SOLUTION STRUCTURE OF PARC CPH DOMAIN.                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JUF A    5   105  UNP    Q8IWT3   PARC_HUMAN     366    466             
SEQRES   1 A  105  GLY SER HIS MET ARG SER GLU PHE SER SER ARG GLY GLY          
SEQRES   2 A  105  TYR GLY GLU TYR VAL GLN GLN THR LEU GLN PRO GLY MET          
SEQRES   3 A  105  ARG VAL ARG MET LEU ASP ASP TYR GLU GLU ILE SER ALA          
SEQRES   4 A  105  GLY ASP GLU GLY GLU PHE ARG GLN SER ASN ASN GLY ILE          
SEQRES   5 A  105  PRO PRO VAL GLN VAL PHE TRP GLN SER THR GLY ARG THR          
SEQRES   6 A  105  TYR TRP VAL HIS TRP HIS MET LEU GLU ILE LEU GLY PRO          
SEQRES   7 A  105  GLU GLU ALA THR GLU ASP LYS ALA SER ALA ALA VAL GLU          
SEQRES   8 A  105  LYS GLY ALA GLY ALA THR VAL LEU GLY THR ALA PHE PRO          
SEQRES   9 A  105  SER                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   TYR A  14      -1.119   4.315   4.051  1.00  0.00           N  
ATOM      2  CA  TYR A  14      -1.693   3.045   4.538  1.00  0.00           C  
ATOM      3  C   TYR A  14      -2.341   2.266   3.373  1.00  0.00           C  
ATOM      4  O   TYR A  14      -2.358   1.026   3.369  1.00  0.00           O  
ATOM      5  CB  TYR A  14      -2.735   3.335   5.654  1.00  0.00           C  
ATOM      6  CG  TYR A  14      -3.414   2.075   6.222  1.00  0.00           C  
ATOM      7  CD1 TYR A  14      -2.697   1.176   7.017  1.00  0.00           C  
ATOM      8  CD2 TYR A  14      -4.754   1.765   5.938  1.00  0.00           C  
ATOM      9  CE1 TYR A  14      -3.278   0.024   7.497  1.00  0.00           C  
ATOM     10  CE2 TYR A  14      -5.341   0.612   6.428  1.00  0.00           C  
ATOM     11  CZ  TYR A  14      -4.595  -0.256   7.206  1.00  0.00           C  
ATOM     12  OH  TYR A  14      -5.158  -1.418   7.681  1.00  0.00           O  
ATOM     13  H   TYR A  14      -1.546   5.149   4.325  1.00  0.00           H  
ATOM     14  HA  TYR A  14      -0.882   2.451   4.954  1.00  0.00           H  
ATOM     15  HB2 TYR A  14      -2.237   3.843   6.473  1.00  0.00           H  
ATOM     16  HB3 TYR A  14      -3.503   3.994   5.257  1.00  0.00           H  
ATOM     17  HD1 TYR A  14      -1.661   1.391   7.255  1.00  0.00           H  
ATOM     18  HD2 TYR A  14      -5.336   2.445   5.326  1.00  0.00           H  
ATOM     19  HE1 TYR A  14      -2.698  -0.656   8.109  1.00  0.00           H  
ATOM     20  HE2 TYR A  14      -6.379   0.391   6.199  1.00  0.00           H  
ATOM     21  HH  TYR A  14      -4.981  -1.498   8.626  1.00  0.00           H  
ATOM     22  N   GLY A  15      -2.852   3.031   2.389  1.00  0.00           N  
ATOM     23  CA  GLY A  15      -3.452   2.474   1.181  1.00  0.00           C  
ATOM     24  C   GLY A  15      -2.469   1.672   0.348  1.00  0.00           C  
ATOM     25  O   GLY A  15      -2.855   0.695  -0.297  1.00  0.00           O  
ATOM     26  H   GLY A  15      -2.808   4.003   2.487  1.00  0.00           H  
ATOM     27  HA2 GLY A  15      -4.285   1.839   1.461  1.00  0.00           H  
ATOM     28  HA3 GLY A  15      -3.829   3.288   0.579  1.00  0.00           H  
ATOM     29  N   GLU A  16      -1.195   2.094   0.372  1.00  0.00           N  
ATOM     30  CA  GLU A  16      -0.095   1.362  -0.269  1.00  0.00           C  
ATOM     31  C   GLU A  16       0.076  -0.016   0.380  1.00  0.00           C  
ATOM     32  O   GLU A  16       0.098  -1.028  -0.321  1.00  0.00           O  
ATOM     33  CB  GLU A  16       1.216   2.166  -0.143  1.00  0.00           C  
ATOM     34  CG  GLU A  16       2.454   1.515  -0.793  1.00  0.00           C  
ATOM     35  CD  GLU A  16       3.741   2.328  -0.564  1.00  0.00           C  
ATOM     36  OE1 GLU A  16       4.386   2.157   0.497  1.00  0.00           O  
ATOM     37  OE2 GLU A  16       4.108   3.150  -1.432  1.00  0.00           O  
ATOM     38  H   GLU A  16      -0.989   2.933   0.837  1.00  0.00           H  
ATOM     39  HA  GLU A  16      -0.336   1.241  -1.323  1.00  0.00           H  
ATOM     40  HB2 GLU A  16       1.060   3.134  -0.606  1.00  0.00           H  
ATOM     41  HB3 GLU A  16       1.426   2.325   0.914  1.00  0.00           H  
ATOM     42  HG2 GLU A  16       2.588   0.519  -0.375  1.00  0.00           H  
ATOM     43  HG3 GLU A  16       2.278   1.421  -1.862  1.00  0.00           H  
ATOM     44  N   TYR A  17       0.128  -0.031   1.738  1.00  0.00           N  
ATOM     45  CA  TYR A  17       0.361  -1.260   2.524  1.00  0.00           C  
ATOM     46  C   TYR A  17      -0.701  -2.322   2.206  1.00  0.00           C  
ATOM     47  O   TYR A  17      -0.356  -3.465   1.874  1.00  0.00           O  
ATOM     48  CB  TYR A  17       0.367  -0.940   4.060  1.00  0.00           C  
ATOM     49  CG  TYR A  17       0.046  -2.153   4.968  1.00  0.00           C  
ATOM     50  CD1 TYR A  17       0.928  -3.231   5.088  1.00  0.00           C  
ATOM     51  CD2 TYR A  17      -1.173  -2.236   5.655  1.00  0.00           C  
ATOM     52  CE1 TYR A  17       0.609  -4.333   5.862  1.00  0.00           C  
ATOM     53  CE2 TYR A  17      -1.497  -3.340   6.419  1.00  0.00           C  
ATOM     54  CZ  TYR A  17      -0.603  -4.384   6.520  1.00  0.00           C  
ATOM     55  OH  TYR A  17      -0.929  -5.494   7.267  1.00  0.00           O  
ATOM     56  H   TYR A  17      -0.006   0.812   2.219  1.00  0.00           H  
ATOM     57  HA  TYR A  17       1.336  -1.648   2.247  1.00  0.00           H  
ATOM     58  HB2 TYR A  17       1.343  -0.568   4.343  1.00  0.00           H  
ATOM     59  HB3 TYR A  17      -0.367  -0.167   4.261  1.00  0.00           H  
ATOM     60  HD1 TYR A  17       1.878  -3.197   4.572  1.00  0.00           H  
ATOM     61  HD2 TYR A  17      -1.877  -1.415   5.580  1.00  0.00           H  
ATOM     62  HE1 TYR A  17       1.309  -5.152   5.941  1.00  0.00           H  
ATOM     63  HE2 TYR A  17      -2.450  -3.376   6.938  1.00  0.00           H  
ATOM     64  HH  TYR A  17      -1.828  -5.768   7.053  1.00  0.00           H  
ATOM     65  N   VAL A  18      -1.984  -1.921   2.265  1.00  0.00           N  
ATOM     66  CA  VAL A  18      -3.096  -2.850   2.046  1.00  0.00           C  
ATOM     67  C   VAL A  18      -3.126  -3.325   0.584  1.00  0.00           C  
ATOM     68  O   VAL A  18      -3.327  -4.506   0.329  1.00  0.00           O  
ATOM     69  CB  VAL A  18      -4.488  -2.269   2.497  1.00  0.00           C  
ATOM     70  CG1 VAL A  18      -4.534  -2.063   4.027  1.00  0.00           C  
ATOM     71  CG2 VAL A  18      -4.835  -0.972   1.752  1.00  0.00           C  
ATOM     72  H   VAL A  18      -2.180  -0.976   2.460  1.00  0.00           H  
ATOM     73  HA  VAL A  18      -2.895  -3.725   2.668  1.00  0.00           H  
ATOM     74  HB  VAL A  18      -5.252  -3.007   2.250  1.00  0.00           H  
ATOM     75 HG11 VAL A  18      -3.770  -1.351   4.324  1.00  0.00           H  
ATOM     76 HG12 VAL A  18      -4.357  -3.005   4.532  1.00  0.00           H  
ATOM     77 HG13 VAL A  18      -5.506  -1.683   4.318  1.00  0.00           H  
ATOM     78 HG21 VAL A  18      -5.802  -0.605   2.077  1.00  0.00           H  
ATOM     79 HG22 VAL A  18      -4.867  -1.158   0.684  1.00  0.00           H  
ATOM     80 HG23 VAL A  18      -4.082  -0.220   1.957  1.00  0.00           H  
ATOM     81  N   GLN A  19      -2.838  -2.409  -0.362  1.00  0.00           N  
ATOM     82  CA  GLN A  19      -2.777  -2.728  -1.804  1.00  0.00           C  
ATOM     83  C   GLN A  19      -1.761  -3.857  -2.098  1.00  0.00           C  
ATOM     84  O   GLN A  19      -1.952  -4.659  -3.026  1.00  0.00           O  
ATOM     85  CB  GLN A  19      -2.422  -1.456  -2.619  1.00  0.00           C  
ATOM     86  CG  GLN A  19      -2.406  -1.663  -4.147  1.00  0.00           C  
ATOM     87  CD  GLN A  19      -1.937  -0.444  -4.945  1.00  0.00           C  
ATOM     88  OE1 GLN A  19      -2.166   0.706  -4.560  1.00  0.00           O  
ATOM     89  NE2 GLN A  19      -1.258  -0.694  -6.056  1.00  0.00           N  
ATOM     90  H   GLN A  19      -2.660  -1.485  -0.082  1.00  0.00           H  
ATOM     91  HA  GLN A  19      -3.767  -3.067  -2.103  1.00  0.00           H  
ATOM     92  HB2 GLN A  19      -3.152  -0.683  -2.390  1.00  0.00           H  
ATOM     93  HB3 GLN A  19      -1.441  -1.102  -2.310  1.00  0.00           H  
ATOM     94  HG2 GLN A  19      -1.748  -2.494  -4.373  1.00  0.00           H  
ATOM     95  HG3 GLN A  19      -3.410  -1.916  -4.470  1.00  0.00           H  
ATOM     96 HE21 GLN A  19      -1.092  -1.635  -6.297  1.00  0.00           H  
ATOM     97 HE22 GLN A  19      -0.947   0.067  -6.587  1.00  0.00           H  
ATOM     98  N   GLN A  20      -0.692  -3.925  -1.280  1.00  0.00           N  
ATOM     99  CA  GLN A  20       0.391  -4.904  -1.468  1.00  0.00           C  
ATOM    100  C   GLN A  20       0.013  -6.277  -0.871  1.00  0.00           C  
ATOM    101  O   GLN A  20       0.309  -7.319  -1.465  1.00  0.00           O  
ATOM    102  CB  GLN A  20       1.715  -4.407  -0.817  1.00  0.00           C  
ATOM    103  CG  GLN A  20       2.247  -3.047  -1.321  1.00  0.00           C  
ATOM    104  CD  GLN A  20       2.327  -2.934  -2.844  1.00  0.00           C  
ATOM    105  OE1 GLN A  20       3.331  -3.301  -3.453  1.00  0.00           O  
ATOM    106  NE2 GLN A  20       1.277  -2.406  -3.469  1.00  0.00           N  
ATOM    107  H   GLN A  20      -0.650  -3.314  -0.511  1.00  0.00           H  
ATOM    108  HA  GLN A  20       0.553  -5.017  -2.541  1.00  0.00           H  
ATOM    109  HB2 GLN A  20       1.561  -4.324   0.254  1.00  0.00           H  
ATOM    110  HB3 GLN A  20       2.487  -5.152  -0.990  1.00  0.00           H  
ATOM    111  HG2 GLN A  20       1.600  -2.262  -0.952  1.00  0.00           H  
ATOM    112  HG3 GLN A  20       3.239  -2.890  -0.912  1.00  0.00           H  
ATOM    113 HE21 GLN A  20       0.513  -2.119  -2.926  1.00  0.00           H  
ATOM    114 HE22 GLN A  20       1.309  -2.327  -4.448  1.00  0.00           H  
ATOM    115  N   THR A  21      -0.635  -6.266   0.313  1.00  0.00           N  
ATOM    116  CA  THR A  21      -0.852  -7.489   1.128  1.00  0.00           C  
ATOM    117  C   THR A  21      -2.279  -8.082   0.983  1.00  0.00           C  
ATOM    118  O   THR A  21      -2.550  -9.161   1.524  1.00  0.00           O  
ATOM    119  CB  THR A  21      -0.529  -7.193   2.635  1.00  0.00           C  
ATOM    120  OG1 THR A  21      -0.604  -8.394   3.427  1.00  0.00           O  
ATOM    121  CG2 THR A  21      -1.466  -6.130   3.226  1.00  0.00           C  
ATOM    122  H   THR A  21      -0.967  -5.407   0.659  1.00  0.00           H  
ATOM    123  HA  THR A  21      -0.143  -8.245   0.792  1.00  0.00           H  
ATOM    124  HB  THR A  21       0.489  -6.817   2.697  1.00  0.00           H  
ATOM    125  HG1 THR A  21      -1.472  -8.798   3.323  1.00  0.00           H  
ATOM    126 HG21 THR A  21      -2.490  -6.479   3.182  1.00  0.00           H  
ATOM    127 HG22 THR A  21      -1.378  -5.210   2.665  1.00  0.00           H  
ATOM    128 HG23 THR A  21      -1.201  -5.941   4.260  1.00  0.00           H  
ATOM    129  N   LEU A  22      -3.187  -7.389   0.265  1.00  0.00           N  
ATOM    130  CA  LEU A  22      -4.582  -7.865   0.075  1.00  0.00           C  
ATOM    131  C   LEU A  22      -4.612  -9.111  -0.841  1.00  0.00           C  
ATOM    132  O   LEU A  22      -4.390  -9.014  -2.053  1.00  0.00           O  
ATOM    133  CB  LEU A  22      -5.518  -6.722  -0.471  1.00  0.00           C  
ATOM    134  CG  LEU A  22      -6.563  -6.142   0.542  1.00  0.00           C  
ATOM    135  CD1 LEU A  22      -7.554  -7.211   1.014  1.00  0.00           C  
ATOM    136  CD2 LEU A  22      -5.880  -5.485   1.747  1.00  0.00           C  
ATOM    137  H   LEU A  22      -2.916  -6.546  -0.152  1.00  0.00           H  
ATOM    138  HA  LEU A  22      -4.946  -8.161   1.060  1.00  0.00           H  
ATOM    139  HB2 LEU A  22      -4.893  -5.901  -0.813  1.00  0.00           H  
ATOM    140  HB3 LEU A  22      -6.067  -7.090  -1.333  1.00  0.00           H  
ATOM    141  HG  LEU A  22      -7.142  -5.373   0.042  1.00  0.00           H  
ATOM    142 HD11 LEU A  22      -8.290  -6.762   1.664  1.00  0.00           H  
ATOM    143 HD12 LEU A  22      -7.032  -7.991   1.554  1.00  0.00           H  
ATOM    144 HD13 LEU A  22      -8.054  -7.647   0.162  1.00  0.00           H  
ATOM    145 HD21 LEU A  22      -6.628  -5.086   2.420  1.00  0.00           H  
ATOM    146 HD22 LEU A  22      -5.252  -4.678   1.403  1.00  0.00           H  
ATOM    147 HD23 LEU A  22      -5.273  -6.210   2.275  1.00  0.00           H  
ATOM    148  N   GLN A  23      -4.886 -10.274  -0.227  1.00  0.00           N  
ATOM    149  CA  GLN A  23      -4.918 -11.579  -0.908  1.00  0.00           C  
ATOM    150  C   GLN A  23      -6.319 -11.848  -1.495  1.00  0.00           C  
ATOM    151  O   GLN A  23      -7.317 -11.463  -0.873  1.00  0.00           O  
ATOM    152  CB  GLN A  23      -4.545 -12.712   0.083  1.00  0.00           C  
ATOM    153  CG  GLN A  23      -3.145 -12.587   0.707  1.00  0.00           C  
ATOM    154  CD  GLN A  23      -2.809 -13.761   1.627  1.00  0.00           C  
ATOM    155  OE1 GLN A  23      -3.091 -13.731   2.822  1.00  0.00           O  
ATOM    156  NE2 GLN A  23      -2.221 -14.805   1.070  1.00  0.00           N  
ATOM    157  H   GLN A  23      -5.083 -10.249   0.729  1.00  0.00           H  
ATOM    158  HA  GLN A  23      -4.189 -11.560  -1.714  1.00  0.00           H  
ATOM    159  HB2 GLN A  23      -5.273 -12.717   0.892  1.00  0.00           H  
ATOM    160  HB3 GLN A  23      -4.603 -13.664  -0.440  1.00  0.00           H  
ATOM    161  HG2 GLN A  23      -2.404 -12.534  -0.083  1.00  0.00           H  
ATOM    162  HG3 GLN A  23      -3.105 -11.669   1.287  1.00  0.00           H  
ATOM    163 HE21 GLN A  23      -2.034 -14.772   0.110  1.00  0.00           H  
ATOM    164 HE22 GLN A  23      -1.991 -15.568   1.640  1.00  0.00           H  
ATOM    165  N   PRO A  24      -6.402 -12.484  -2.713  1.00  0.00           N  
ATOM    166  CA  PRO A  24      -7.688 -12.868  -3.352  1.00  0.00           C  
ATOM    167  C   PRO A  24      -8.550 -13.842  -2.504  1.00  0.00           C  
ATOM    168  O   PRO A  24      -8.539 -15.053  -2.735  1.00  0.00           O  
ATOM    169  CB  PRO A  24      -7.247 -13.496  -4.711  1.00  0.00           C  
ATOM    170  CG  PRO A  24      -5.881 -12.937  -4.957  1.00  0.00           C  
ATOM    171  CD  PRO A  24      -5.247 -12.829  -3.593  1.00  0.00           C  
ATOM    172  HA  PRO A  24      -8.280 -11.988  -3.554  1.00  0.00           H  
ATOM    173  HB2 PRO A  24      -7.227 -14.582  -4.641  1.00  0.00           H  
ATOM    174  HB3 PRO A  24      -7.939 -13.205  -5.494  1.00  0.00           H  
ATOM    175  HG2 PRO A  24      -5.312 -13.604  -5.596  1.00  0.00           H  
ATOM    176  HG3 PRO A  24      -5.955 -11.956  -5.418  1.00  0.00           H  
ATOM    177  HD2 PRO A  24      -4.798 -13.773  -3.293  1.00  0.00           H  
ATOM    178  HD3 PRO A  24      -4.499 -12.042  -3.585  1.00  0.00           H  
ATOM    179  N   GLY A  25      -9.264 -13.300  -1.491  1.00  0.00           N  
ATOM    180  CA  GLY A  25     -10.228 -14.075  -0.703  1.00  0.00           C  
ATOM    181  C   GLY A  25     -10.049 -13.899   0.797  1.00  0.00           C  
ATOM    182  O   GLY A  25     -10.529 -14.735   1.570  1.00  0.00           O  
ATOM    183  H   GLY A  25      -9.114 -12.359  -1.250  1.00  0.00           H  
ATOM    184  HA2 GLY A  25     -11.225 -13.747  -0.968  1.00  0.00           H  
ATOM    185  HA3 GLY A  25     -10.140 -15.135  -0.942  1.00  0.00           H  
ATOM    186  N   MET A  26      -9.363 -12.816   1.224  1.00  0.00           N  
ATOM    187  CA  MET A  26      -9.135 -12.545   2.666  1.00  0.00           C  
ATOM    188  C   MET A  26     -10.221 -11.611   3.227  1.00  0.00           C  
ATOM    189  O   MET A  26     -11.038 -11.072   2.486  1.00  0.00           O  
ATOM    190  CB  MET A  26      -7.720 -11.950   2.946  1.00  0.00           C  
ATOM    191  CG  MET A  26      -7.448 -10.569   2.329  1.00  0.00           C  
ATOM    192  SD  MET A  26      -6.269  -9.580   3.289  1.00  0.00           S  
ATOM    193  CE  MET A  26      -4.862 -10.675   3.475  1.00  0.00           C  
ATOM    194  H   MET A  26      -9.023 -12.180   0.565  1.00  0.00           H  
ATOM    195  HA  MET A  26      -9.213 -13.493   3.195  1.00  0.00           H  
ATOM    196  HB2 MET A  26      -7.590 -11.866   4.020  1.00  0.00           H  
ATOM    197  HB3 MET A  26      -6.969 -12.643   2.572  1.00  0.00           H  
ATOM    198  HG2 MET A  26      -7.053 -10.699   1.330  1.00  0.00           H  
ATOM    199  HG3 MET A  26      -8.379 -10.014   2.268  1.00  0.00           H  
ATOM    200  HE1 MET A  26      -4.093 -10.178   4.045  1.00  0.00           H  
ATOM    201  HE2 MET A  26      -4.477 -10.932   2.499  1.00  0.00           H  
ATOM    202  HE3 MET A  26      -5.165 -11.577   3.991  1.00  0.00           H  
ATOM    203  N   ARG A  27     -10.165 -11.397   4.543  1.00  0.00           N  
ATOM    204  CA  ARG A  27     -11.189 -10.685   5.320  1.00  0.00           C  
ATOM    205  C   ARG A  27     -10.755  -9.225   5.501  1.00  0.00           C  
ATOM    206  O   ARG A  27      -9.640  -8.954   5.970  1.00  0.00           O  
ATOM    207  CB  ARG A  27     -11.358 -11.398   6.687  1.00  0.00           C  
ATOM    208  CG  ARG A  27     -12.352 -10.764   7.690  1.00  0.00           C  
ATOM    209  CD  ARG A  27     -13.816 -10.820   7.222  1.00  0.00           C  
ATOM    210  NE  ARG A  27     -14.752 -10.544   8.327  1.00  0.00           N  
ATOM    211  CZ  ARG A  27     -16.082 -10.701   8.282  1.00  0.00           C  
ATOM    212  NH1 ARG A  27     -16.693 -11.079   7.167  1.00  0.00           N  
ATOM    213  NH2 ARG A  27     -16.796 -10.460   9.372  1.00  0.00           N  
ATOM    214  H   ARG A  27      -9.370 -11.698   5.012  1.00  0.00           H  
ATOM    215  HA  ARG A  27     -12.132 -10.724   4.778  1.00  0.00           H  
ATOM    216  HB2 ARG A  27     -11.683 -12.416   6.499  1.00  0.00           H  
ATOM    217  HB3 ARG A  27     -10.389 -11.445   7.165  1.00  0.00           H  
ATOM    218  HG2 ARG A  27     -12.273 -11.290   8.635  1.00  0.00           H  
ATOM    219  HG3 ARG A  27     -12.074  -9.727   7.846  1.00  0.00           H  
ATOM    220  HD2 ARG A  27     -13.961 -10.080   6.444  1.00  0.00           H  
ATOM    221  HD3 ARG A  27     -14.025 -11.806   6.821  1.00  0.00           H  
ATOM    222  HE  ARG A  27     -14.355 -10.225   9.165  1.00  0.00           H  
ATOM    223 HH11 ARG A  27     -16.160 -11.248   6.332  1.00  0.00           H  
ATOM    224 HH12 ARG A  27     -17.690 -11.195   7.152  1.00  0.00           H  
ATOM    225 HH21 ARG A  27     -16.344 -10.161  10.215  1.00  0.00           H  
ATOM    226 HH22 ARG A  27     -17.796 -10.557   9.352  1.00  0.00           H  
ATOM    227  N   VAL A  28     -11.647  -8.294   5.131  1.00  0.00           N  
ATOM    228  CA  VAL A  28     -11.363  -6.850   5.121  1.00  0.00           C  
ATOM    229  C   VAL A  28     -12.268  -6.128   6.141  1.00  0.00           C  
ATOM    230  O   VAL A  28     -13.169  -6.735   6.723  1.00  0.00           O  
ATOM    231  CB  VAL A  28     -11.537  -6.226   3.680  1.00  0.00           C  
ATOM    232  CG1 VAL A  28     -10.775  -7.047   2.613  1.00  0.00           C  
ATOM    233  CG2 VAL A  28     -13.024  -6.049   3.284  1.00  0.00           C  
ATOM    234  H   VAL A  28     -12.540  -8.590   4.858  1.00  0.00           H  
ATOM    235  HA  VAL A  28     -10.326  -6.708   5.430  1.00  0.00           H  
ATOM    236  HB  VAL A  28     -11.085  -5.229   3.702  1.00  0.00           H  
ATOM    237 HG11 VAL A  28     -10.884  -6.582   1.638  1.00  0.00           H  
ATOM    238 HG12 VAL A  28     -11.173  -8.053   2.572  1.00  0.00           H  
ATOM    239 HG13 VAL A  28      -9.722  -7.091   2.867  1.00  0.00           H  
ATOM    240 HG21 VAL A  28     -13.096  -5.580   2.310  1.00  0.00           H  
ATOM    241 HG22 VAL A  28     -13.528  -5.423   4.015  1.00  0.00           H  
ATOM    242 HG23 VAL A  28     -13.509  -7.012   3.252  1.00  0.00           H  
ATOM    243  N   ARG A  29     -11.998  -4.841   6.342  1.00  0.00           N  
ATOM    244  CA  ARG A  29     -12.621  -3.996   7.371  1.00  0.00           C  
ATOM    245  C   ARG A  29     -12.788  -2.577   6.797  1.00  0.00           C  
ATOM    246  O   ARG A  29     -11.924  -2.095   6.066  1.00  0.00           O  
ATOM    247  CB  ARG A  29     -11.713  -3.964   8.634  1.00  0.00           C  
ATOM    248  CG  ARG A  29     -12.237  -3.114   9.817  1.00  0.00           C  
ATOM    249  CD  ARG A  29     -13.469  -3.718  10.511  1.00  0.00           C  
ATOM    250  NE  ARG A  29     -13.793  -3.025  11.781  1.00  0.00           N  
ATOM    251  CZ  ARG A  29     -14.403  -3.588  12.846  1.00  0.00           C  
ATOM    252  NH1 ARG A  29     -14.754  -4.871  12.839  1.00  0.00           N  
ATOM    253  NH2 ARG A  29     -14.667  -2.855  13.921  1.00  0.00           N  
ATOM    254  H   ARG A  29     -11.350  -4.418   5.751  1.00  0.00           H  
ATOM    255  HA  ARG A  29     -13.597  -4.405   7.627  1.00  0.00           H  
ATOM    256  HB2 ARG A  29     -11.573  -4.983   8.985  1.00  0.00           H  
ATOM    257  HB3 ARG A  29     -10.738  -3.575   8.346  1.00  0.00           H  
ATOM    258  HG2 ARG A  29     -11.444  -3.019  10.551  1.00  0.00           H  
ATOM    259  HG3 ARG A  29     -12.490  -2.123   9.450  1.00  0.00           H  
ATOM    260  HD2 ARG A  29     -14.321  -3.637   9.844  1.00  0.00           H  
ATOM    261  HD3 ARG A  29     -13.278  -4.766  10.718  1.00  0.00           H  
ATOM    262  HE  ARG A  29     -13.539  -2.076  11.837  1.00  0.00           H  
ATOM    263 HH11 ARG A  29     -14.564  -5.446  12.041  1.00  0.00           H  
ATOM    264 HH12 ARG A  29     -15.208  -5.270  13.638  1.00  0.00           H  
ATOM    265 HH21 ARG A  29     -14.406  -1.887  13.952  1.00  0.00           H  
ATOM    266 HH22 ARG A  29     -15.132  -3.267  14.711  1.00  0.00           H  
ATOM    267  N   MET A  30     -13.910  -1.935   7.111  1.00  0.00           N  
ATOM    268  CA  MET A  30     -14.207  -0.563   6.680  1.00  0.00           C  
ATOM    269  C   MET A  30     -13.878   0.394   7.841  1.00  0.00           C  
ATOM    270  O   MET A  30     -14.535   0.339   8.882  1.00  0.00           O  
ATOM    271  CB  MET A  30     -15.706  -0.468   6.261  1.00  0.00           C  
ATOM    272  CG  MET A  30     -16.091   0.742   5.390  1.00  0.00           C  
ATOM    273  SD  MET A  30     -15.816   0.510   3.607  1.00  0.00           S  
ATOM    274  CE  MET A  30     -14.042   0.706   3.407  1.00  0.00           C  
ATOM    275  H   MET A  30     -14.563  -2.393   7.670  1.00  0.00           H  
ATOM    276  HA  MET A  30     -13.581  -0.319   5.824  1.00  0.00           H  
ATOM    277  HB2 MET A  30     -15.961  -1.357   5.697  1.00  0.00           H  
ATOM    278  HB3 MET A  30     -16.321  -0.456   7.159  1.00  0.00           H  
ATOM    279  HG2 MET A  30     -17.145   0.952   5.534  1.00  0.00           H  
ATOM    280  HG3 MET A  30     -15.522   1.605   5.718  1.00  0.00           H  
ATOM    281  HE1 MET A  30     -13.781   0.581   2.366  1.00  0.00           H  
ATOM    282  HE2 MET A  30     -13.526  -0.040   3.995  1.00  0.00           H  
ATOM    283  HE3 MET A  30     -13.746   1.692   3.735  1.00  0.00           H  
ATOM    284  N   LEU A  31     -12.837   1.243   7.688  1.00  0.00           N  
ATOM    285  CA  LEU A  31     -12.404   2.173   8.766  1.00  0.00           C  
ATOM    286  C   LEU A  31     -13.135   3.531   8.687  1.00  0.00           C  
ATOM    287  O   LEU A  31     -12.939   4.393   9.555  1.00  0.00           O  
ATOM    288  CB  LEU A  31     -10.845   2.340   8.769  1.00  0.00           C  
ATOM    289  CG  LEU A  31     -10.165   2.968   7.495  1.00  0.00           C  
ATOM    290  CD1 LEU A  31     -10.210   4.517   7.478  1.00  0.00           C  
ATOM    291  CD2 LEU A  31      -8.713   2.467   7.316  1.00  0.00           C  
ATOM    292  H   LEU A  31     -12.344   1.242   6.837  1.00  0.00           H  
ATOM    293  HA  LEU A  31     -12.684   1.719   9.711  1.00  0.00           H  
ATOM    294  HB2 LEU A  31     -10.571   2.946   9.630  1.00  0.00           H  
ATOM    295  HB3 LEU A  31     -10.420   1.353   8.924  1.00  0.00           H  
ATOM    296  HG  LEU A  31     -10.716   2.637   6.626  1.00  0.00           H  
ATOM    297 HD11 LEU A  31     -11.238   4.848   7.490  1.00  0.00           H  
ATOM    298 HD12 LEU A  31      -9.732   4.886   6.579  1.00  0.00           H  
ATOM    299 HD13 LEU A  31      -9.694   4.910   8.346  1.00  0.00           H  
ATOM    300 HD21 LEU A  31      -8.114   2.759   8.171  1.00  0.00           H  
ATOM    301 HD22 LEU A  31      -8.286   2.896   6.418  1.00  0.00           H  
ATOM    302 HD23 LEU A  31      -8.710   1.391   7.227  1.00  0.00           H  
ATOM    303  N   ASP A  32     -13.970   3.715   7.654  1.00  0.00           N  
ATOM    304  CA  ASP A  32     -14.737   4.963   7.441  1.00  0.00           C  
ATOM    305  C   ASP A  32     -16.138   4.600   6.942  1.00  0.00           C  
ATOM    306  O   ASP A  32     -16.313   3.550   6.343  1.00  0.00           O  
ATOM    307  CB  ASP A  32     -14.008   5.867   6.411  1.00  0.00           C  
ATOM    308  CG  ASP A  32     -14.477   7.331   6.448  1.00  0.00           C  
ATOM    309  OD1 ASP A  32     -15.521   7.653   5.848  1.00  0.00           O  
ATOM    310  OD2 ASP A  32     -13.805   8.167   7.096  1.00  0.00           O  
ATOM    311  H   ASP A  32     -14.091   2.985   7.011  1.00  0.00           H  
ATOM    312  HA  ASP A  32     -14.825   5.485   8.391  1.00  0.00           H  
ATOM    313  HB2 ASP A  32     -12.942   5.837   6.608  1.00  0.00           H  
ATOM    314  HB3 ASP A  32     -14.178   5.478   5.412  1.00  0.00           H  
ATOM    315  N   ASP A  33     -17.133   5.466   7.184  1.00  0.00           N  
ATOM    316  CA  ASP A  33     -18.523   5.193   6.759  1.00  0.00           C  
ATOM    317  C   ASP A  33     -18.666   5.413   5.245  1.00  0.00           C  
ATOM    318  O   ASP A  33     -18.283   6.461   4.710  1.00  0.00           O  
ATOM    319  CB  ASP A  33     -19.552   6.039   7.559  1.00  0.00           C  
ATOM    320  CG  ASP A  33     -19.336   7.557   7.462  1.00  0.00           C  
ATOM    321  OD1 ASP A  33     -18.446   8.079   8.167  1.00  0.00           O  
ATOM    322  OD2 ASP A  33     -20.048   8.235   6.684  1.00  0.00           O  
ATOM    323  H   ASP A  33     -16.922   6.321   7.615  1.00  0.00           H  
ATOM    324  HA  ASP A  33     -18.717   4.140   6.973  1.00  0.00           H  
ATOM    325  HB2 ASP A  33     -20.555   5.805   7.206  1.00  0.00           H  
ATOM    326  HB3 ASP A  33     -19.491   5.755   8.604  1.00  0.00           H  
ATOM    327  N   TYR A  34     -19.194   4.392   4.565  1.00  0.00           N  
ATOM    328  CA  TYR A  34     -19.382   4.393   3.105  1.00  0.00           C  
ATOM    329  C   TYR A  34     -20.866   4.545   2.743  1.00  0.00           C  
ATOM    330  O   TYR A  34     -21.743   4.523   3.614  1.00  0.00           O  
ATOM    331  CB  TYR A  34     -18.743   3.117   2.453  1.00  0.00           C  
ATOM    332  CG  TYR A  34     -17.487   3.422   1.644  1.00  0.00           C  
ATOM    333  CD1 TYR A  34     -16.273   3.697   2.279  1.00  0.00           C  
ATOM    334  CD2 TYR A  34     -17.521   3.469   0.246  1.00  0.00           C  
ATOM    335  CE1 TYR A  34     -15.147   4.000   1.551  1.00  0.00           C  
ATOM    336  CE2 TYR A  34     -16.393   3.767  -0.482  1.00  0.00           C  
ATOM    337  CZ  TYR A  34     -15.212   4.037   0.173  1.00  0.00           C  
ATOM    338  OH  TYR A  34     -14.090   4.344  -0.555  1.00  0.00           O  
ATOM    339  H   TYR A  34     -19.479   3.599   5.071  1.00  0.00           H  
ATOM    340  HA  TYR A  34     -18.872   5.277   2.711  1.00  0.00           H  
ATOM    341  HB2 TYR A  34     -18.466   2.408   3.228  1.00  0.00           H  
ATOM    342  HB3 TYR A  34     -19.459   2.630   1.792  1.00  0.00           H  
ATOM    343  HD1 TYR A  34     -16.221   3.671   3.363  1.00  0.00           H  
ATOM    344  HD2 TYR A  34     -18.452   3.258  -0.269  1.00  0.00           H  
ATOM    345  HE1 TYR A  34     -14.215   4.211   2.061  1.00  0.00           H  
ATOM    346  HE2 TYR A  34     -16.440   3.796  -1.562  1.00  0.00           H  
ATOM    347  HH  TYR A  34     -14.328   4.962  -1.253  1.00  0.00           H  
ATOM    348  N   GLU A  35     -21.096   4.709   1.429  1.00  0.00           N  
ATOM    349  CA  GLU A  35     -22.412   5.030   0.809  1.00  0.00           C  
ATOM    350  C   GLU A  35     -23.557   4.097   1.285  1.00  0.00           C  
ATOM    351  O   GLU A  35     -24.702   4.532   1.445  1.00  0.00           O  
ATOM    352  CB  GLU A  35     -22.260   4.945  -0.741  1.00  0.00           C  
ATOM    353  CG  GLU A  35     -21.025   5.690  -1.325  1.00  0.00           C  
ATOM    354  CD  GLU A  35     -21.069   7.222  -1.167  1.00  0.00           C  
ATOM    355  OE1 GLU A  35     -20.649   7.747  -0.111  1.00  0.00           O  
ATOM    356  OE2 GLU A  35     -21.516   7.913  -2.110  1.00  0.00           O  
ATOM    357  H   GLU A  35     -20.323   4.619   0.831  1.00  0.00           H  
ATOM    358  HA  GLU A  35     -22.662   6.054   1.074  1.00  0.00           H  
ATOM    359  HB2 GLU A  35     -22.176   3.897  -1.025  1.00  0.00           H  
ATOM    360  HB3 GLU A  35     -23.154   5.354  -1.207  1.00  0.00           H  
ATOM    361  HG2 GLU A  35     -20.134   5.318  -0.825  1.00  0.00           H  
ATOM    362  HG3 GLU A  35     -20.946   5.445  -2.382  1.00  0.00           H  
ATOM    363  N   GLU A  36     -23.221   2.816   1.509  1.00  0.00           N  
ATOM    364  CA  GLU A  36     -24.183   1.773   1.952  1.00  0.00           C  
ATOM    365  C   GLU A  36     -23.562   0.863   3.025  1.00  0.00           C  
ATOM    366  O   GLU A  36     -24.181  -0.111   3.470  1.00  0.00           O  
ATOM    367  CB  GLU A  36     -24.616   0.938   0.724  1.00  0.00           C  
ATOM    368  CG  GLU A  36     -23.441   0.363  -0.101  1.00  0.00           C  
ATOM    369  CD  GLU A  36     -23.896  -0.318  -1.396  1.00  0.00           C  
ATOM    370  OE1 GLU A  36     -24.579   0.344  -2.208  1.00  0.00           O  
ATOM    371  OE2 GLU A  36     -23.571  -1.502  -1.616  1.00  0.00           O  
ATOM    372  H   GLU A  36     -22.290   2.553   1.368  1.00  0.00           H  
ATOM    373  HA  GLU A  36     -25.055   2.262   2.379  1.00  0.00           H  
ATOM    374  HB2 GLU A  36     -25.243   0.112   1.054  1.00  0.00           H  
ATOM    375  HB3 GLU A  36     -25.202   1.567   0.074  1.00  0.00           H  
ATOM    376  HG2 GLU A  36     -22.766   1.172  -0.362  1.00  0.00           H  
ATOM    377  HG3 GLU A  36     -22.903  -0.353   0.516  1.00  0.00           H  
ATOM    378  N   ILE A  37     -22.329   1.196   3.425  1.00  0.00           N  
ATOM    379  CA  ILE A  37     -21.497   0.382   4.326  1.00  0.00           C  
ATOM    380  C   ILE A  37     -21.202   1.202   5.591  1.00  0.00           C  
ATOM    381  O   ILE A  37     -21.039   2.421   5.514  1.00  0.00           O  
ATOM    382  CB  ILE A  37     -20.160   0.003   3.594  1.00  0.00           C  
ATOM    383  CG1 ILE A  37     -20.453  -0.690   2.213  1.00  0.00           C  
ATOM    384  CG2 ILE A  37     -19.240  -0.878   4.470  1.00  0.00           C  
ATOM    385  CD1 ILE A  37     -19.475  -0.337   1.114  1.00  0.00           C  
ATOM    386  H   ILE A  37     -21.964   2.053   3.124  1.00  0.00           H  
ATOM    387  HA  ILE A  37     -22.033  -0.530   4.592  1.00  0.00           H  
ATOM    388  HB  ILE A  37     -19.627   0.927   3.411  1.00  0.00           H  
ATOM    389 HG12 ILE A  37     -20.419  -1.766   2.329  1.00  0.00           H  
ATOM    390 HG13 ILE A  37     -21.442  -0.413   1.859  1.00  0.00           H  
ATOM    391 HG21 ILE A  37     -18.991  -0.356   5.388  1.00  0.00           H  
ATOM    392 HG22 ILE A  37     -18.326  -1.098   3.931  1.00  0.00           H  
ATOM    393 HG23 ILE A  37     -19.741  -1.807   4.711  1.00  0.00           H  
ATOM    394 HD11 ILE A  37     -19.758  -0.862   0.214  1.00  0.00           H  
ATOM    395 HD12 ILE A  37     -18.475  -0.632   1.400  1.00  0.00           H  
ATOM    396 HD13 ILE A  37     -19.504   0.728   0.927  1.00  0.00           H  
ATOM    397  N   SER A  38     -21.147   0.542   6.745  1.00  0.00           N  
ATOM    398  CA  SER A  38     -20.864   1.201   8.029  1.00  0.00           C  
ATOM    399  C   SER A  38     -19.358   1.185   8.333  1.00  0.00           C  
ATOM    400  O   SER A  38     -18.627   0.305   7.858  1.00  0.00           O  
ATOM    401  CB  SER A  38     -21.635   0.473   9.145  1.00  0.00           C  
ATOM    402  OG  SER A  38     -23.033   0.469   8.884  1.00  0.00           O  
ATOM    403  H   SER A  38     -21.289  -0.427   6.739  1.00  0.00           H  
ATOM    404  HA  SER A  38     -21.209   2.233   7.975  1.00  0.00           H  
ATOM    405  HB2 SER A  38     -21.295  -0.551   9.204  1.00  0.00           H  
ATOM    406  HB3 SER A  38     -21.463   0.966  10.095  1.00  0.00           H  
ATOM    407  HG  SER A  38     -23.198   0.855   8.010  1.00  0.00           H  
ATOM    408  N   ALA A  39     -18.902   2.169   9.126  1.00  0.00           N  
ATOM    409  CA  ALA A  39     -17.575   2.131   9.746  1.00  0.00           C  
ATOM    410  C   ALA A  39     -17.606   1.075  10.863  1.00  0.00           C  
ATOM    411  O   ALA A  39     -18.362   1.209  11.835  1.00  0.00           O  
ATOM    412  CB  ALA A  39     -17.196   3.511  10.298  1.00  0.00           C  
ATOM    413  H   ALA A  39     -19.480   2.942   9.298  1.00  0.00           H  
ATOM    414  HA  ALA A  39     -16.843   1.846   8.988  1.00  0.00           H  
ATOM    415  HB1 ALA A  39     -17.193   4.234   9.492  1.00  0.00           H  
ATOM    416  HB2 ALA A  39     -16.212   3.471  10.744  1.00  0.00           H  
ATOM    417  HB3 ALA A  39     -17.917   3.820  11.048  1.00  0.00           H  
ATOM    418  N   GLY A  40     -16.801   0.023  10.690  1.00  0.00           N  
ATOM    419  CA  GLY A  40     -16.819  -1.146  11.570  1.00  0.00           C  
ATOM    420  C   GLY A  40     -17.372  -2.387  10.877  1.00  0.00           C  
ATOM    421  O   GLY A  40     -17.346  -3.479  11.454  1.00  0.00           O  
ATOM    422  H   GLY A  40     -16.181   0.035   9.938  1.00  0.00           H  
ATOM    423  HA2 GLY A  40     -15.805  -1.352  11.883  1.00  0.00           H  
ATOM    424  HA3 GLY A  40     -17.418  -0.944  12.452  1.00  0.00           H  
ATOM    425  N   ASP A  41     -17.868  -2.220   9.630  1.00  0.00           N  
ATOM    426  CA  ASP A  41     -18.366  -3.345   8.810  1.00  0.00           C  
ATOM    427  C   ASP A  41     -17.189  -4.099   8.178  1.00  0.00           C  
ATOM    428  O   ASP A  41     -16.107  -3.536   8.011  1.00  0.00           O  
ATOM    429  CB  ASP A  41     -19.344  -2.841   7.714  1.00  0.00           C  
ATOM    430  CG  ASP A  41     -20.030  -3.981   6.929  1.00  0.00           C  
ATOM    431  OD1 ASP A  41     -20.469  -4.959   7.566  1.00  0.00           O  
ATOM    432  OD2 ASP A  41     -20.169  -3.891   5.694  1.00  0.00           O  
ATOM    433  H   ASP A  41     -17.895  -1.318   9.249  1.00  0.00           H  
ATOM    434  HA  ASP A  41     -18.900  -4.024   9.468  1.00  0.00           H  
ATOM    435  HB2 ASP A  41     -20.116  -2.238   8.180  1.00  0.00           H  
ATOM    436  HB3 ASP A  41     -18.794  -2.214   7.015  1.00  0.00           H  
ATOM    437  N   GLU A  42     -17.406  -5.379   7.831  1.00  0.00           N  
ATOM    438  CA  GLU A  42     -16.355  -6.259   7.298  1.00  0.00           C  
ATOM    439  C   GLU A  42     -16.818  -6.957   6.013  1.00  0.00           C  
ATOM    440  O   GLU A  42     -18.020  -7.080   5.747  1.00  0.00           O  
ATOM    441  CB  GLU A  42     -15.929  -7.280   8.373  1.00  0.00           C  
ATOM    442  CG  GLU A  42     -15.196  -6.651   9.573  1.00  0.00           C  
ATOM    443  CD  GLU A  42     -14.745  -7.669  10.620  1.00  0.00           C  
ATOM    444  OE1 GLU A  42     -13.862  -8.487  10.310  1.00  0.00           O  
ATOM    445  OE2 GLU A  42     -15.261  -7.649  11.757  1.00  0.00           O  
ATOM    446  H   GLU A  42     -18.314  -5.740   7.918  1.00  0.00           H  
ATOM    447  HA  GLU A  42     -15.488  -5.644   7.044  1.00  0.00           H  
ATOM    448  HB2 GLU A  42     -16.812  -7.798   8.741  1.00  0.00           H  
ATOM    449  HB3 GLU A  42     -15.264  -8.014   7.921  1.00  0.00           H  
ATOM    450  HG2 GLU A  42     -14.315  -6.131   9.202  1.00  0.00           H  
ATOM    451  HG3 GLU A  42     -15.854  -5.918  10.038  1.00  0.00           H  
ATOM    452  N   GLY A  43     -15.829  -7.397   5.223  1.00  0.00           N  
ATOM    453  CA  GLY A  43     -16.061  -7.937   3.888  1.00  0.00           C  
ATOM    454  C   GLY A  43     -15.042  -8.987   3.504  1.00  0.00           C  
ATOM    455  O   GLY A  43     -14.288  -9.462   4.351  1.00  0.00           O  
ATOM    456  H   GLY A  43     -14.915  -7.360   5.562  1.00  0.00           H  
ATOM    457  HA2 GLY A  43     -17.040  -8.371   3.817  1.00  0.00           H  
ATOM    458  HA3 GLY A  43     -15.999  -7.123   3.177  1.00  0.00           H  
ATOM    459  N   GLU A  44     -15.014  -9.335   2.209  1.00  0.00           N  
ATOM    460  CA  GLU A  44     -14.013 -10.253   1.642  1.00  0.00           C  
ATOM    461  C   GLU A  44     -13.498  -9.680   0.326  1.00  0.00           C  
ATOM    462  O   GLU A  44     -14.293  -9.162  -0.466  1.00  0.00           O  
ATOM    463  CB  GLU A  44     -14.607 -11.663   1.393  1.00  0.00           C  
ATOM    464  CG  GLU A  44     -13.604 -12.672   0.791  1.00  0.00           C  
ATOM    465  CD  GLU A  44     -14.229 -14.030   0.446  1.00  0.00           C  
ATOM    466  OE1 GLU A  44     -14.865 -14.144  -0.627  1.00  0.00           O  
ATOM    467  OE2 GLU A  44     -14.084 -14.986   1.236  1.00  0.00           O  
ATOM    468  H   GLU A  44     -15.684  -8.952   1.604  1.00  0.00           H  
ATOM    469  HA  GLU A  44     -13.181 -10.334   2.345  1.00  0.00           H  
ATOM    470  HB2 GLU A  44     -14.968 -12.060   2.335  1.00  0.00           H  
ATOM    471  HB3 GLU A  44     -15.454 -11.575   0.713  1.00  0.00           H  
ATOM    472  HG2 GLU A  44     -13.187 -12.244  -0.117  1.00  0.00           H  
ATOM    473  HG3 GLU A  44     -12.794 -12.820   1.503  1.00  0.00           H  
ATOM    474  N   PHE A  45     -12.180  -9.793   0.093  1.00  0.00           N  
ATOM    475  CA  PHE A  45     -11.551  -9.384  -1.166  1.00  0.00           C  
ATOM    476  C   PHE A  45     -11.992 -10.340  -2.281  1.00  0.00           C  
ATOM    477  O   PHE A  45     -11.739 -11.544  -2.211  1.00  0.00           O  
ATOM    478  CB  PHE A  45     -10.009  -9.371  -1.005  1.00  0.00           C  
ATOM    479  CG  PHE A  45      -9.226  -8.847  -2.221  1.00  0.00           C  
ATOM    480  CD1 PHE A  45      -8.953  -9.670  -3.305  1.00  0.00           C  
ATOM    481  CD2 PHE A  45      -8.726  -7.552  -2.256  1.00  0.00           C  
ATOM    482  CE1 PHE A  45      -8.214  -9.227  -4.377  1.00  0.00           C  
ATOM    483  CE2 PHE A  45      -7.991  -7.104  -3.331  1.00  0.00           C  
ATOM    484  CZ  PHE A  45      -7.731  -7.945  -4.388  1.00  0.00           C  
ATOM    485  H   PHE A  45     -11.615 -10.172   0.794  1.00  0.00           H  
ATOM    486  HA  PHE A  45     -11.888  -8.379  -1.399  1.00  0.00           H  
ATOM    487  HB2 PHE A  45      -9.755  -8.747  -0.152  1.00  0.00           H  
ATOM    488  HB3 PHE A  45      -9.666 -10.380  -0.796  1.00  0.00           H  
ATOM    489  HD1 PHE A  45      -9.334 -10.679  -3.304  1.00  0.00           H  
ATOM    490  HD2 PHE A  45      -8.926  -6.883  -1.431  1.00  0.00           H  
ATOM    491  HE1 PHE A  45      -8.015  -9.888  -5.210  1.00  0.00           H  
ATOM    492  HE2 PHE A  45      -7.609  -6.090  -3.341  1.00  0.00           H  
ATOM    493  HZ  PHE A  45      -7.150  -7.594  -5.228  1.00  0.00           H  
ATOM    494  N   ARG A  46     -12.651  -9.782  -3.304  1.00  0.00           N  
ATOM    495  CA  ARG A  46     -13.203 -10.550  -4.432  1.00  0.00           C  
ATOM    496  C   ARG A  46     -12.292 -10.367  -5.651  1.00  0.00           C  
ATOM    497  O   ARG A  46     -11.931 -11.335  -6.322  1.00  0.00           O  
ATOM    498  CB  ARG A  46     -14.642 -10.048  -4.732  1.00  0.00           C  
ATOM    499  CG  ARG A  46     -15.522  -9.849  -3.479  1.00  0.00           C  
ATOM    500  CD  ARG A  46     -15.863 -11.160  -2.751  1.00  0.00           C  
ATOM    501  NE  ARG A  46     -16.905 -11.911  -3.472  1.00  0.00           N  
ATOM    502  CZ  ARG A  46     -17.643 -12.915  -2.972  1.00  0.00           C  
ATOM    503  NH1 ARG A  46     -17.382 -13.428  -1.782  1.00  0.00           N  
ATOM    504  NH2 ARG A  46     -18.636 -13.418  -3.690  1.00  0.00           N  
ATOM    505  H   ARG A  46     -12.773  -8.811  -3.303  1.00  0.00           H  
ATOM    506  HA  ARG A  46     -13.236 -11.604  -4.165  1.00  0.00           H  
ATOM    507  HB2 ARG A  46     -14.577  -9.093  -5.243  1.00  0.00           H  
ATOM    508  HB3 ARG A  46     -15.135 -10.757  -5.390  1.00  0.00           H  
ATOM    509  HG2 ARG A  46     -14.996  -9.193  -2.786  1.00  0.00           H  
ATOM    510  HG3 ARG A  46     -16.447  -9.363  -3.777  1.00  0.00           H  
ATOM    511  HD2 ARG A  46     -14.971 -11.770  -2.666  1.00  0.00           H  
ATOM    512  HD3 ARG A  46     -16.221 -10.914  -1.754  1.00  0.00           H  
ATOM    513  HE  ARG A  46     -17.093 -11.619  -4.390  1.00  0.00           H  
ATOM    514 HH11 ARG A  46     -16.611 -13.086  -1.239  1.00  0.00           H  
ATOM    515 HH12 ARG A  46     -17.947 -14.174  -1.417  1.00  0.00           H  
ATOM    516 HH21 ARG A  46     -18.830 -13.060  -4.608  1.00  0.00           H  
ATOM    517 HH22 ARG A  46     -19.193 -14.168  -3.321  1.00  0.00           H  
ATOM    518  N   GLN A  47     -11.936  -9.093  -5.902  1.00  0.00           N  
ATOM    519  CA  GLN A  47     -11.008  -8.674  -6.970  1.00  0.00           C  
ATOM    520  C   GLN A  47     -10.707  -7.173  -6.808  1.00  0.00           C  
ATOM    521  O   GLN A  47     -11.510  -6.428  -6.221  1.00  0.00           O  
ATOM    522  CB  GLN A  47     -11.577  -8.945  -8.408  1.00  0.00           C  
ATOM    523  CG  GLN A  47     -12.787  -8.064  -8.840  1.00  0.00           C  
ATOM    524  CD  GLN A  47     -14.072  -8.330  -8.046  1.00  0.00           C  
ATOM    525  OE1 GLN A  47     -14.903  -9.147  -8.438  1.00  0.00           O  
ATOM    526  NE2 GLN A  47     -14.216  -7.675  -6.899  1.00  0.00           N  
ATOM    527  H   GLN A  47     -12.324  -8.390  -5.337  1.00  0.00           H  
ATOM    528  HA  GLN A  47     -10.083  -9.230  -6.837  1.00  0.00           H  
ATOM    529  HB2 GLN A  47     -10.777  -8.792  -9.130  1.00  0.00           H  
ATOM    530  HB3 GLN A  47     -11.881  -9.985  -8.463  1.00  0.00           H  
ATOM    531  HG2 GLN A  47     -12.520  -7.021  -8.720  1.00  0.00           H  
ATOM    532  HG3 GLN A  47     -12.991  -8.246  -9.893  1.00  0.00           H  
ATOM    533 HE21 GLN A  47     -13.501  -7.060  -6.616  1.00  0.00           H  
ATOM    534 HE22 GLN A  47     -15.032  -7.824  -6.376  1.00  0.00           H  
ATOM    535  N   SER A  48      -9.570  -6.735  -7.351  1.00  0.00           N  
ATOM    536  CA  SER A  48      -9.165  -5.321  -7.357  1.00  0.00           C  
ATOM    537  C   SER A  48      -8.821  -4.874  -8.773  1.00  0.00           C  
ATOM    538  O   SER A  48      -8.876  -5.660  -9.730  1.00  0.00           O  
ATOM    539  CB  SER A  48      -7.945  -5.123  -6.437  1.00  0.00           C  
ATOM    540  OG  SER A  48      -6.852  -5.942  -6.833  1.00  0.00           O  
ATOM    541  H   SER A  48      -8.966  -7.386  -7.767  1.00  0.00           H  
ATOM    542  HA  SER A  48      -9.990  -4.713  -6.991  1.00  0.00           H  
ATOM    543  HB2 SER A  48      -7.628  -4.088  -6.459  1.00  0.00           H  
ATOM    544  HB3 SER A  48      -8.216  -5.383  -5.421  1.00  0.00           H  
ATOM    545  HG  SER A  48      -6.045  -5.419  -6.837  1.00  0.00           H  
ATOM    546  N   ASN A  49      -8.476  -3.589  -8.890  1.00  0.00           N  
ATOM    547  CA  ASN A  49      -7.910  -3.011 -10.111  1.00  0.00           C  
ATOM    548  C   ASN A  49      -6.505  -2.488  -9.768  1.00  0.00           C  
ATOM    549  O   ASN A  49      -6.319  -1.878  -8.706  1.00  0.00           O  
ATOM    550  CB  ASN A  49      -8.815  -1.877 -10.647  1.00  0.00           C  
ATOM    551  CG  ASN A  49     -10.264  -2.314 -10.892  1.00  0.00           C  
ATOM    552  OD1 ASN A  49     -10.602  -2.809 -11.962  1.00  0.00           O  
ATOM    553  ND2 ASN A  49     -11.129  -2.122  -9.901  1.00  0.00           N  
ATOM    554  H   ASN A  49      -8.601  -2.997  -8.114  1.00  0.00           H  
ATOM    555  HA  ASN A  49      -7.824  -3.793 -10.869  1.00  0.00           H  
ATOM    556  HB2 ASN A  49      -8.824  -1.059  -9.935  1.00  0.00           H  
ATOM    557  HB3 ASN A  49      -8.407  -1.512 -11.584  1.00  0.00           H  
ATOM    558 HD21 ASN A  49     -10.799  -1.713  -9.070  1.00  0.00           H  
ATOM    559 HD22 ASN A  49     -12.061  -2.395 -10.036  1.00  0.00           H  
ATOM    560  N   ASN A  50      -5.524  -2.753 -10.650  1.00  0.00           N  
ATOM    561  CA  ASN A  50      -4.101  -2.402 -10.413  1.00  0.00           C  
ATOM    562  C   ASN A  50      -3.904  -0.878 -10.421  1.00  0.00           C  
ATOM    563  O   ASN A  50      -3.339  -0.304  -9.481  1.00  0.00           O  
ATOM    564  CB  ASN A  50      -3.178  -3.054 -11.481  1.00  0.00           C  
ATOM    565  CG  ASN A  50      -3.188  -4.584 -11.449  1.00  0.00           C  
ATOM    566  OD1 ASN A  50      -2.418  -5.207 -10.717  1.00  0.00           O  
ATOM    567  ND2 ASN A  50      -4.049  -5.195 -12.248  1.00  0.00           N  
ATOM    568  H   ASN A  50      -5.760  -3.195 -11.490  1.00  0.00           H  
ATOM    569  HA  ASN A  50      -3.825  -2.781  -9.439  1.00  0.00           H  
ATOM    570  HB2 ASN A  50      -3.495  -2.731 -12.468  1.00  0.00           H  
ATOM    571  HB3 ASN A  50      -2.157  -2.719 -11.324  1.00  0.00           H  
ATOM    572 HD21 ASN A  50      -4.630  -4.645 -12.811  1.00  0.00           H  
ATOM    573 HD22 ASN A  50      -4.065  -6.175 -12.246  1.00  0.00           H  
ATOM    574  N   GLY A  51      -4.385  -0.246 -11.501  1.00  0.00           N  
ATOM    575  CA  GLY A  51      -4.233   1.191 -11.712  1.00  0.00           C  
ATOM    576  C   GLY A  51      -5.381   2.009 -11.136  1.00  0.00           C  
ATOM    577  O   GLY A  51      -5.218   3.201 -10.872  1.00  0.00           O  
ATOM    578  H   GLY A  51      -4.862  -0.776 -12.172  1.00  0.00           H  
ATOM    579  HA2 GLY A  51      -3.302   1.529 -11.264  1.00  0.00           H  
ATOM    580  HA3 GLY A  51      -4.182   1.372 -12.775  1.00  0.00           H  
ATOM    581  N   ILE A  52      -6.556   1.378 -10.964  1.00  0.00           N  
ATOM    582  CA  ILE A  52      -7.768   2.065 -10.470  1.00  0.00           C  
ATOM    583  C   ILE A  52      -7.947   1.714  -8.971  1.00  0.00           C  
ATOM    584  O   ILE A  52      -8.170   0.545  -8.647  1.00  0.00           O  
ATOM    585  CB  ILE A  52      -9.063   1.645 -11.281  1.00  0.00           C  
ATOM    586  CG1 ILE A  52      -8.770   1.440 -12.807  1.00  0.00           C  
ATOM    587  CG2 ILE A  52     -10.201   2.677 -11.098  1.00  0.00           C  
ATOM    588  CD1 ILE A  52      -8.289   2.677 -13.559  1.00  0.00           C  
ATOM    589  H   ILE A  52      -6.611   0.421 -11.162  1.00  0.00           H  
ATOM    590  HA  ILE A  52      -7.625   3.140 -10.579  1.00  0.00           H  
ATOM    591  HB  ILE A  52      -9.412   0.703 -10.866  1.00  0.00           H  
ATOM    592 HG12 ILE A  52      -8.004   0.683 -12.918  1.00  0.00           H  
ATOM    593 HG13 ILE A  52      -9.670   1.090 -13.297  1.00  0.00           H  
ATOM    594 HG21 ILE A  52      -9.875   3.648 -11.451  1.00  0.00           H  
ATOM    595 HG22 ILE A  52     -10.463   2.750 -10.055  1.00  0.00           H  
ATOM    596 HG23 ILE A  52     -11.072   2.367 -11.662  1.00  0.00           H  
ATOM    597 HD11 ILE A  52      -8.126   2.422 -14.596  1.00  0.00           H  
ATOM    598 HD12 ILE A  52      -7.361   3.029 -13.127  1.00  0.00           H  
ATOM    599 HD13 ILE A  52      -9.034   3.456 -13.495  1.00  0.00           H  
ATOM    600  N   PRO A  53      -7.823   2.705  -8.032  1.00  0.00           N  
ATOM    601  CA  PRO A  53      -7.870   2.433  -6.570  1.00  0.00           C  
ATOM    602  C   PRO A  53      -9.170   1.768  -5.973  1.00  0.00           C  
ATOM    603  O   PRO A  53      -9.032   1.034  -4.983  1.00  0.00           O  
ATOM    604  CB  PRO A  53      -7.579   3.818  -5.922  1.00  0.00           C  
ATOM    605  CG  PRO A  53      -7.873   4.826  -6.994  1.00  0.00           C  
ATOM    606  CD  PRO A  53      -7.537   4.143  -8.303  1.00  0.00           C  
ATOM    607  HA  PRO A  53      -7.054   1.766  -6.333  1.00  0.00           H  
ATOM    608  HB2 PRO A  53      -8.211   3.969  -5.050  1.00  0.00           H  
ATOM    609  HB3 PRO A  53      -6.539   3.864  -5.613  1.00  0.00           H  
ATOM    610  HG2 PRO A  53      -8.929   5.099  -6.967  1.00  0.00           H  
ATOM    611  HG3 PRO A  53      -7.259   5.710  -6.857  1.00  0.00           H  
ATOM    612  HD2 PRO A  53      -8.166   4.524  -9.103  1.00  0.00           H  
ATOM    613  HD3 PRO A  53      -6.491   4.284  -8.552  1.00  0.00           H  
ATOM    614  N   PRO A  54     -10.439   2.010  -6.469  1.00  0.00           N  
ATOM    615  CA  PRO A  54     -11.623   1.290  -5.940  1.00  0.00           C  
ATOM    616  C   PRO A  54     -11.532  -0.244  -6.159  1.00  0.00           C  
ATOM    617  O   PRO A  54     -11.580  -0.737  -7.294  1.00  0.00           O  
ATOM    618  CB  PRO A  54     -12.824   1.930  -6.687  1.00  0.00           C  
ATOM    619  CG  PRO A  54     -12.219   2.550  -7.903  1.00  0.00           C  
ATOM    620  CD  PRO A  54     -10.852   3.018  -7.471  1.00  0.00           C  
ATOM    621  HA  PRO A  54     -11.729   1.481  -4.873  1.00  0.00           H  
ATOM    622  HB2 PRO A  54     -13.566   1.180  -6.943  1.00  0.00           H  
ATOM    623  HB3 PRO A  54     -13.288   2.684  -6.055  1.00  0.00           H  
ATOM    624  HG2 PRO A  54     -12.136   1.810  -8.695  1.00  0.00           H  
ATOM    625  HG3 PRO A  54     -12.817   3.388  -8.240  1.00  0.00           H  
ATOM    626  HD2 PRO A  54     -10.166   3.034  -8.309  1.00  0.00           H  
ATOM    627  HD3 PRO A  54     -10.893   4.000  -7.014  1.00  0.00           H  
ATOM    628  N   VAL A  55     -11.301  -0.966  -5.052  1.00  0.00           N  
ATOM    629  CA  VAL A  55     -11.397  -2.437  -4.984  1.00  0.00           C  
ATOM    630  C   VAL A  55     -12.840  -2.842  -4.619  1.00  0.00           C  
ATOM    631  O   VAL A  55     -13.471  -2.219  -3.756  1.00  0.00           O  
ATOM    632  CB  VAL A  55     -10.366  -3.050  -3.947  1.00  0.00           C  
ATOM    633  CG1 VAL A  55     -10.372  -2.280  -2.601  1.00  0.00           C  
ATOM    634  CG2 VAL A  55     -10.612  -4.568  -3.710  1.00  0.00           C  
ATOM    635  H   VAL A  55     -11.041  -0.481  -4.239  1.00  0.00           H  
ATOM    636  HA  VAL A  55     -11.161  -2.833  -5.970  1.00  0.00           H  
ATOM    637  HB  VAL A  55      -9.370  -2.942  -4.379  1.00  0.00           H  
ATOM    638 HG11 VAL A  55     -10.122  -1.240  -2.780  1.00  0.00           H  
ATOM    639 HG12 VAL A  55      -9.642  -2.708  -1.926  1.00  0.00           H  
ATOM    640 HG13 VAL A  55     -11.356  -2.338  -2.153  1.00  0.00           H  
ATOM    641 HG21 VAL A  55     -10.614  -5.096  -4.662  1.00  0.00           H  
ATOM    642 HG22 VAL A  55     -11.572  -4.711  -3.229  1.00  0.00           H  
ATOM    643 HG23 VAL A  55      -9.832  -4.976  -3.081  1.00  0.00           H  
ATOM    644  N   GLN A  56     -13.362  -3.866  -5.317  1.00  0.00           N  
ATOM    645  CA  GLN A  56     -14.698  -4.410  -5.054  1.00  0.00           C  
ATOM    646  C   GLN A  56     -14.575  -5.547  -4.013  1.00  0.00           C  
ATOM    647  O   GLN A  56     -13.840  -6.527  -4.218  1.00  0.00           O  
ATOM    648  CB  GLN A  56     -15.383  -4.915  -6.358  1.00  0.00           C  
ATOM    649  CG  GLN A  56     -15.715  -3.858  -7.433  1.00  0.00           C  
ATOM    650  CD  GLN A  56     -14.482  -3.175  -8.050  1.00  0.00           C  
ATOM    651  OE1 GLN A  56     -13.902  -3.659  -9.018  1.00  0.00           O  
ATOM    652  NE2 GLN A  56     -14.074  -2.052  -7.489  1.00  0.00           N  
ATOM    653  H   GLN A  56     -12.817  -4.278  -6.020  1.00  0.00           H  
ATOM    654  HA  GLN A  56     -15.309  -3.609  -4.637  1.00  0.00           H  
ATOM    655  HB2 GLN A  56     -14.748  -5.658  -6.814  1.00  0.00           H  
ATOM    656  HB3 GLN A  56     -16.313  -5.407  -6.083  1.00  0.00           H  
ATOM    657  HG2 GLN A  56     -16.264  -4.343  -8.234  1.00  0.00           H  
ATOM    658  HG3 GLN A  56     -16.353  -3.100  -6.989  1.00  0.00           H  
ATOM    659 HE21 GLN A  56     -14.568  -1.714  -6.712  1.00  0.00           H  
ATOM    660 HE22 GLN A  56     -13.303  -1.594  -7.880  1.00  0.00           H  
ATOM    661  N   VAL A  57     -15.313  -5.393  -2.908  1.00  0.00           N  
ATOM    662  CA  VAL A  57     -15.279  -6.291  -1.733  1.00  0.00           C  
ATOM    663  C   VAL A  57     -16.713  -6.537  -1.268  1.00  0.00           C  
ATOM    664  O   VAL A  57     -17.513  -5.604  -1.241  1.00  0.00           O  
ATOM    665  CB  VAL A  57     -14.415  -5.674  -0.550  1.00  0.00           C  
ATOM    666  CG1 VAL A  57     -12.968  -6.188  -0.579  1.00  0.00           C  
ATOM    667  CG2 VAL A  57     -14.426  -4.133  -0.595  1.00  0.00           C  
ATOM    668  H   VAL A  57     -15.935  -4.631  -2.877  1.00  0.00           H  
ATOM    669  HA  VAL A  57     -14.844  -7.250  -2.035  1.00  0.00           H  
ATOM    670  HB  VAL A  57     -14.848  -5.982   0.402  1.00  0.00           H  
ATOM    671 HG11 VAL A  57     -12.971  -7.254  -0.374  1.00  0.00           H  
ATOM    672 HG12 VAL A  57     -12.384  -5.688   0.182  1.00  0.00           H  
ATOM    673 HG13 VAL A  57     -12.530  -6.011  -1.554  1.00  0.00           H  
ATOM    674 HG21 VAL A  57     -13.884  -3.735   0.260  1.00  0.00           H  
ATOM    675 HG22 VAL A  57     -15.449  -3.776  -0.555  1.00  0.00           H  
ATOM    676 HG23 VAL A  57     -13.963  -3.781  -1.508  1.00  0.00           H  
ATOM    677  N   PHE A  58     -17.035  -7.800  -0.937  1.00  0.00           N  
ATOM    678  CA  PHE A  58     -18.402  -8.202  -0.560  1.00  0.00           C  
ATOM    679  C   PHE A  58     -18.638  -7.879   0.920  1.00  0.00           C  
ATOM    680  O   PHE A  58     -18.144  -8.591   1.795  1.00  0.00           O  
ATOM    681  CB  PHE A  58     -18.595  -9.716  -0.844  1.00  0.00           C  
ATOM    682  CG  PHE A  58     -20.025 -10.233  -0.680  1.00  0.00           C  
ATOM    683  CD1 PHE A  58     -20.916 -10.217  -1.751  1.00  0.00           C  
ATOM    684  CD2 PHE A  58     -20.475 -10.745   0.540  1.00  0.00           C  
ATOM    685  CE1 PHE A  58     -22.203 -10.692  -1.608  1.00  0.00           C  
ATOM    686  CE2 PHE A  58     -21.762 -11.221   0.681  1.00  0.00           C  
ATOM    687  CZ  PHE A  58     -22.626 -11.194  -0.395  1.00  0.00           C  
ATOM    688  H   PHE A  58     -16.330  -8.478  -0.939  1.00  0.00           H  
ATOM    689  HA  PHE A  58     -19.107  -7.637  -1.172  1.00  0.00           H  
ATOM    690  HB2 PHE A  58     -18.289  -9.923  -1.865  1.00  0.00           H  
ATOM    691  HB3 PHE A  58     -17.954 -10.289  -0.180  1.00  0.00           H  
ATOM    692  HD1 PHE A  58     -20.595  -9.823  -2.706  1.00  0.00           H  
ATOM    693  HD2 PHE A  58     -19.798 -10.766   1.388  1.00  0.00           H  
ATOM    694  HE1 PHE A  58     -22.882 -10.671  -2.451  1.00  0.00           H  
ATOM    695  HE2 PHE A  58     -22.093 -11.614   1.634  1.00  0.00           H  
ATOM    696  HZ  PHE A  58     -23.634 -11.568  -0.285  1.00  0.00           H  
ATOM    697  N   TRP A  59     -19.417  -6.821   1.174  1.00  0.00           N  
ATOM    698  CA  TRP A  59     -19.705  -6.313   2.527  1.00  0.00           C  
ATOM    699  C   TRP A  59     -20.950  -6.985   3.094  1.00  0.00           C  
ATOM    700  O   TRP A  59     -21.984  -7.041   2.420  1.00  0.00           O  
ATOM    701  CB  TRP A  59     -19.889  -4.785   2.481  1.00  0.00           C  
ATOM    702  CG  TRP A  59     -18.655  -4.066   2.022  1.00  0.00           C  
ATOM    703  CD1 TRP A  59     -18.405  -3.565   0.780  1.00  0.00           C  
ATOM    704  CD2 TRP A  59     -17.486  -3.809   2.804  1.00  0.00           C  
ATOM    705  NE1 TRP A  59     -17.170  -2.987   0.751  1.00  0.00           N  
ATOM    706  CE2 TRP A  59     -16.581  -3.130   1.986  1.00  0.00           C  
ATOM    707  CE3 TRP A  59     -17.127  -4.083   4.123  1.00  0.00           C  
ATOM    708  CZ2 TRP A  59     -15.329  -2.723   2.444  1.00  0.00           C  
ATOM    709  CZ3 TRP A  59     -15.891  -3.683   4.575  1.00  0.00           C  
ATOM    710  CH2 TRP A  59     -15.002  -3.009   3.737  1.00  0.00           C  
ATOM    711  H   TRP A  59     -19.814  -6.353   0.415  1.00  0.00           H  
ATOM    712  HA  TRP A  59     -18.854  -6.540   3.169  1.00  0.00           H  
ATOM    713  HB2 TRP A  59     -20.698  -4.538   1.805  1.00  0.00           H  
ATOM    714  HB3 TRP A  59     -20.139  -4.418   3.472  1.00  0.00           H  
ATOM    715  HD1 TRP A  59     -19.099  -3.611  -0.049  1.00  0.00           H  
ATOM    716  HE1 TRP A  59     -16.769  -2.553  -0.030  1.00  0.00           H  
ATOM    717  HE3 TRP A  59     -17.806  -4.605   4.789  1.00  0.00           H  
ATOM    718  HZ2 TRP A  59     -14.630  -2.198   1.804  1.00  0.00           H  
ATOM    719  HZ3 TRP A  59     -15.600  -3.897   5.595  1.00  0.00           H  
ATOM    720  HH2 TRP A  59     -14.037  -2.713   4.135  1.00  0.00           H  
ATOM    721  N   GLN A  60     -20.836  -7.489   4.333  1.00  0.00           N  
ATOM    722  CA  GLN A  60     -21.896  -8.276   4.979  1.00  0.00           C  
ATOM    723  C   GLN A  60     -23.129  -7.422   5.357  1.00  0.00           C  
ATOM    724  O   GLN A  60     -24.249  -7.940   5.351  1.00  0.00           O  
ATOM    725  CB  GLN A  60     -21.342  -9.037   6.218  1.00  0.00           C  
ATOM    726  CG  GLN A  60     -20.741  -8.141   7.313  1.00  0.00           C  
ATOM    727  CD  GLN A  60     -20.411  -8.889   8.596  1.00  0.00           C  
ATOM    728  OE1 GLN A  60     -19.310  -9.405   8.775  1.00  0.00           O  
ATOM    729  NE2 GLN A  60     -21.379  -8.968   9.490  1.00  0.00           N  
ATOM    730  H   GLN A  60     -20.010  -7.314   4.835  1.00  0.00           H  
ATOM    731  HA  GLN A  60     -22.223  -9.018   4.255  1.00  0.00           H  
ATOM    732  HB2 GLN A  60     -22.146  -9.621   6.656  1.00  0.00           H  
ATOM    733  HB3 GLN A  60     -20.569  -9.722   5.883  1.00  0.00           H  
ATOM    734  HG2 GLN A  60     -19.831  -7.691   6.934  1.00  0.00           H  
ATOM    735  HG3 GLN A  60     -21.444  -7.347   7.546  1.00  0.00           H  
ATOM    736 HE21 GLN A  60     -22.240  -8.554   9.269  1.00  0.00           H  
ATOM    737 HE22 GLN A  60     -21.195  -9.417  10.335  1.00  0.00           H  
ATOM    738  N   SER A  61     -22.925  -6.122   5.686  1.00  0.00           N  
ATOM    739  CA  SER A  61     -24.033  -5.236   6.118  1.00  0.00           C  
ATOM    740  C   SER A  61     -24.985  -4.909   4.950  1.00  0.00           C  
ATOM    741  O   SER A  61     -26.212  -4.993   5.095  1.00  0.00           O  
ATOM    742  CB  SER A  61     -23.486  -3.930   6.731  1.00  0.00           C  
ATOM    743  OG  SER A  61     -24.525  -3.089   7.200  1.00  0.00           O  
ATOM    744  H   SER A  61     -22.008  -5.758   5.656  1.00  0.00           H  
ATOM    745  HA  SER A  61     -24.591  -5.767   6.889  1.00  0.00           H  
ATOM    746  HB2 SER A  61     -22.842  -4.168   7.563  1.00  0.00           H  
ATOM    747  HB3 SER A  61     -22.912  -3.393   5.987  1.00  0.00           H  
ATOM    748  HG  SER A  61     -24.388  -2.909   8.139  1.00  0.00           H  
ATOM    749  N   THR A  62     -24.406  -4.553   3.787  1.00  0.00           N  
ATOM    750  CA  THR A  62     -25.182  -4.229   2.575  1.00  0.00           C  
ATOM    751  C   THR A  62     -25.499  -5.515   1.768  1.00  0.00           C  
ATOM    752  O   THR A  62     -26.412  -5.525   0.928  1.00  0.00           O  
ATOM    753  CB  THR A  62     -24.443  -3.169   1.687  1.00  0.00           C  
ATOM    754  OG1 THR A  62     -25.260  -2.807   0.565  1.00  0.00           O  
ATOM    755  CG2 THR A  62     -23.073  -3.659   1.188  1.00  0.00           C  
ATOM    756  H   THR A  62     -23.429  -4.508   3.743  1.00  0.00           H  
ATOM    757  HA  THR A  62     -26.126  -3.786   2.890  1.00  0.00           H  
ATOM    758  HB  THR A  62     -24.286  -2.275   2.287  1.00  0.00           H  
ATOM    759  HG1 THR A  62     -24.695  -2.562  -0.175  1.00  0.00           H  
ATOM    760 HG21 THR A  62     -23.201  -4.553   0.589  1.00  0.00           H  
ATOM    761 HG22 THR A  62     -22.437  -3.886   2.034  1.00  0.00           H  
ATOM    762 HG23 THR A  62     -22.603  -2.891   0.586  1.00  0.00           H  
ATOM    763  N   GLY A  63     -24.742  -6.598   2.048  1.00  0.00           N  
ATOM    764  CA  GLY A  63     -24.964  -7.910   1.424  1.00  0.00           C  
ATOM    765  C   GLY A  63     -24.477  -8.009  -0.016  1.00  0.00           C  
ATOM    766  O   GLY A  63     -24.919  -8.902  -0.754  1.00  0.00           O  
ATOM    767  H   GLY A  63     -24.019  -6.504   2.703  1.00  0.00           H  
ATOM    768  HA2 GLY A  63     -24.452  -8.660   2.010  1.00  0.00           H  
ATOM    769  HA3 GLY A  63     -26.027  -8.127   1.443  1.00  0.00           H  
ATOM    770  N   ARG A  64     -23.568  -7.102  -0.425  1.00  0.00           N  
ATOM    771  CA  ARG A  64     -23.122  -7.004  -1.832  1.00  0.00           C  
ATOM    772  C   ARG A  64     -21.705  -6.429  -1.953  1.00  0.00           C  
ATOM    773  O   ARG A  64     -21.171  -5.833  -1.011  1.00  0.00           O  
ATOM    774  CB  ARG A  64     -24.145  -6.164  -2.640  1.00  0.00           C  
ATOM    775  CG  ARG A  64     -24.323  -4.731  -2.115  1.00  0.00           C  
ATOM    776  CD  ARG A  64     -25.481  -3.986  -2.787  1.00  0.00           C  
ATOM    777  NE  ARG A  64     -25.317  -3.887  -4.255  1.00  0.00           N  
ATOM    778  CZ  ARG A  64     -25.149  -2.751  -4.952  1.00  0.00           C  
ATOM    779  NH1 ARG A  64     -25.005  -1.581  -4.341  1.00  0.00           N  
ATOM    780  NH2 ARG A  64     -25.097  -2.805  -6.273  1.00  0.00           N  
ATOM    781  H   ARG A  64     -23.177  -6.492   0.236  1.00  0.00           H  
ATOM    782  HA  ARG A  64     -23.091  -8.011  -2.247  1.00  0.00           H  
ATOM    783  HB2 ARG A  64     -23.826  -6.113  -3.680  1.00  0.00           H  
ATOM    784  HB3 ARG A  64     -25.107  -6.665  -2.601  1.00  0.00           H  
ATOM    785  HG2 ARG A  64     -24.513  -4.768  -1.045  1.00  0.00           H  
ATOM    786  HG3 ARG A  64     -23.403  -4.175  -2.287  1.00  0.00           H  
ATOM    787  HD2 ARG A  64     -26.403  -4.520  -2.575  1.00  0.00           H  
ATOM    788  HD3 ARG A  64     -25.547  -2.989  -2.359  1.00  0.00           H  
ATOM    789  HE  ARG A  64     -25.366  -4.730  -4.759  1.00  0.00           H  
ATOM    790 HH11 ARG A  64     -25.014  -1.530  -3.332  1.00  0.00           H  
ATOM    791 HH12 ARG A  64     -24.890  -0.742  -4.872  1.00  0.00           H  
ATOM    792 HH21 ARG A  64     -25.182  -3.688  -6.744  1.00  0.00           H  
ATOM    793 HH22 ARG A  64     -24.989  -1.965  -6.811  1.00  0.00           H  
ATOM    794  N   THR A  65     -21.132  -6.608  -3.151  1.00  0.00           N  
ATOM    795  CA  THR A  65     -19.778  -6.190  -3.488  1.00  0.00           C  
ATOM    796  C   THR A  65     -19.785  -4.731  -3.973  1.00  0.00           C  
ATOM    797  O   THR A  65     -20.471  -4.407  -4.950  1.00  0.00           O  
ATOM    798  CB  THR A  65     -19.219  -7.136  -4.607  1.00  0.00           C  
ATOM    799  OG1 THR A  65     -19.664  -8.483  -4.372  1.00  0.00           O  
ATOM    800  CG2 THR A  65     -17.707  -7.138  -4.629  1.00  0.00           C  
ATOM    801  H   THR A  65     -21.640  -7.069  -3.843  1.00  0.00           H  
ATOM    802  HA  THR A  65     -19.150  -6.281  -2.601  1.00  0.00           H  
ATOM    803  HB  THR A  65     -19.576  -6.805  -5.579  1.00  0.00           H  
ATOM    804  HG1 THR A  65     -19.599  -8.989  -5.190  1.00  0.00           H  
ATOM    805 HG21 THR A  65     -17.342  -7.516  -3.686  1.00  0.00           H  
ATOM    806 HG22 THR A  65     -17.341  -6.130  -4.772  1.00  0.00           H  
ATOM    807 HG23 THR A  65     -17.350  -7.766  -5.430  1.00  0.00           H  
ATOM    808  N   TYR A  66     -19.026  -3.853  -3.293  1.00  0.00           N  
ATOM    809  CA  TYR A  66     -19.048  -2.405  -3.568  1.00  0.00           C  
ATOM    810  C   TYR A  66     -17.622  -1.845  -3.729  1.00  0.00           C  
ATOM    811  O   TYR A  66     -16.652  -2.417  -3.216  1.00  0.00           O  
ATOM    812  CB  TYR A  66     -19.798  -1.676  -2.422  1.00  0.00           C  
ATOM    813  CG  TYR A  66     -20.269  -0.255  -2.777  1.00  0.00           C  
ATOM    814  CD1 TYR A  66     -21.327  -0.070  -3.669  1.00  0.00           C  
ATOM    815  CD2 TYR A  66     -19.673   0.890  -2.233  1.00  0.00           C  
ATOM    816  CE1 TYR A  66     -21.770   1.191  -4.003  1.00  0.00           C  
ATOM    817  CE2 TYR A  66     -20.119   2.152  -2.566  1.00  0.00           C  
ATOM    818  CZ  TYR A  66     -21.169   2.297  -3.450  1.00  0.00           C  
ATOM    819  OH  TYR A  66     -21.607   3.555  -3.799  1.00  0.00           O  
ATOM    820  H   TYR A  66     -18.448  -4.186  -2.573  1.00  0.00           H  
ATOM    821  HA  TYR A  66     -19.585  -2.238  -4.505  1.00  0.00           H  
ATOM    822  HB2 TYR A  66     -20.675  -2.252  -2.149  1.00  0.00           H  
ATOM    823  HB3 TYR A  66     -19.146  -1.612  -1.554  1.00  0.00           H  
ATOM    824  HD1 TYR A  66     -21.807  -0.939  -4.106  1.00  0.00           H  
ATOM    825  HD2 TYR A  66     -18.845   0.777  -1.541  1.00  0.00           H  
ATOM    826  HE1 TYR A  66     -22.593   1.306  -4.695  1.00  0.00           H  
ATOM    827  HE2 TYR A  66     -19.646   3.024  -2.130  1.00  0.00           H  
ATOM    828  HH  TYR A  66     -22.572   3.577  -3.775  1.00  0.00           H  
ATOM    829  N   TRP A  67     -17.542  -0.702  -4.434  1.00  0.00           N  
ATOM    830  CA  TRP A  67     -16.290   0.002  -4.747  1.00  0.00           C  
ATOM    831  C   TRP A  67     -15.815   0.812  -3.525  1.00  0.00           C  
ATOM    832  O   TRP A  67     -16.503   1.752  -3.108  1.00  0.00           O  
ATOM    833  CB  TRP A  67     -16.520   0.964  -5.953  1.00  0.00           C  
ATOM    834  CG  TRP A  67     -17.124   0.316  -7.179  1.00  0.00           C  
ATOM    835  CD1 TRP A  67     -16.453  -0.255  -8.215  1.00  0.00           C  
ATOM    836  CD2 TRP A  67     -18.521   0.204  -7.504  1.00  0.00           C  
ATOM    837  NE1 TRP A  67     -17.333  -0.745  -9.136  1.00  0.00           N  
ATOM    838  CE2 TRP A  67     -18.607  -0.474  -8.731  1.00  0.00           C  
ATOM    839  CE3 TRP A  67     -19.701   0.597  -6.870  1.00  0.00           C  
ATOM    840  CZ2 TRP A  67     -19.825  -0.764  -9.340  1.00  0.00           C  
ATOM    841  CZ3 TRP A  67     -20.912   0.317  -7.475  1.00  0.00           C  
ATOM    842  CH2 TRP A  67     -20.968  -0.363  -8.698  1.00  0.00           C  
ATOM    843  H   TRP A  67     -18.374  -0.306  -4.755  1.00  0.00           H  
ATOM    844  HA  TRP A  67     -15.539  -0.734  -5.014  1.00  0.00           H  
ATOM    845  HB2 TRP A  67     -17.188   1.761  -5.652  1.00  0.00           H  
ATOM    846  HB3 TRP A  67     -15.570   1.402  -6.244  1.00  0.00           H  
ATOM    847  HD1 TRP A  67     -15.376  -0.327  -8.276  1.00  0.00           H  
ATOM    848  HE1 TRP A  67     -17.084  -1.210  -9.959  1.00  0.00           H  
ATOM    849  HE3 TRP A  67     -19.676   1.124  -5.924  1.00  0.00           H  
ATOM    850  HZ2 TRP A  67     -19.881  -1.293 -10.284  1.00  0.00           H  
ATOM    851  HZ3 TRP A  67     -21.835   0.621  -6.996  1.00  0.00           H  
ATOM    852  HH2 TRP A  67     -21.937  -0.563  -9.137  1.00  0.00           H  
ATOM    853  N   VAL A  68     -14.659   0.432  -2.940  1.00  0.00           N  
ATOM    854  CA  VAL A  68     -14.056   1.164  -1.798  1.00  0.00           C  
ATOM    855  C   VAL A  68     -12.578   1.483  -2.077  1.00  0.00           C  
ATOM    856  O   VAL A  68     -11.913   0.778  -2.837  1.00  0.00           O  
ATOM    857  CB  VAL A  68     -14.191   0.385  -0.429  1.00  0.00           C  
ATOM    858  CG1 VAL A  68     -15.658  -0.034  -0.147  1.00  0.00           C  
ATOM    859  CG2 VAL A  68     -13.232  -0.822  -0.364  1.00  0.00           C  
ATOM    860  H   VAL A  68     -14.194  -0.357  -3.283  1.00  0.00           H  
ATOM    861  HA  VAL A  68     -14.585   2.112  -1.692  1.00  0.00           H  
ATOM    862  HB  VAL A  68     -13.900   1.075   0.369  1.00  0.00           H  
ATOM    863 HG11 VAL A  68     -16.294   0.843  -0.130  1.00  0.00           H  
ATOM    864 HG12 VAL A  68     -15.722  -0.534   0.813  1.00  0.00           H  
ATOM    865 HG13 VAL A  68     -16.001  -0.709  -0.922  1.00  0.00           H  
ATOM    866 HG21 VAL A  68     -13.362  -1.350   0.574  1.00  0.00           H  
ATOM    867 HG22 VAL A  68     -12.206  -0.477  -0.437  1.00  0.00           H  
ATOM    868 HG23 VAL A  68     -13.437  -1.497  -1.185  1.00  0.00           H  
ATOM    869  N   HIS A  69     -12.072   2.532  -1.417  1.00  0.00           N  
ATOM    870  CA  HIS A  69     -10.702   3.042  -1.615  1.00  0.00           C  
ATOM    871  C   HIS A  69      -9.730   2.334  -0.660  1.00  0.00           C  
ATOM    872  O   HIS A  69     -10.104   2.024   0.478  1.00  0.00           O  
ATOM    873  CB  HIS A  69     -10.686   4.572  -1.368  1.00  0.00           C  
ATOM    874  CG  HIS A  69      -9.415   5.261  -1.788  1.00  0.00           C  
ATOM    875  ND1 HIS A  69      -8.495   5.771  -0.898  1.00  0.00           N  
ATOM    876  CD2 HIS A  69      -8.934   5.546  -3.019  1.00  0.00           C  
ATOM    877  CE1 HIS A  69      -7.510   6.342  -1.565  1.00  0.00           C  
ATOM    878  NE2 HIS A  69      -7.752   6.220  -2.849  1.00  0.00           N  
ATOM    879  H   HIS A  69     -12.643   2.979  -0.762  1.00  0.00           H  
ATOM    880  HA  HIS A  69     -10.406   2.843  -2.644  1.00  0.00           H  
ATOM    881  HB2 HIS A  69     -11.498   5.028  -1.923  1.00  0.00           H  
ATOM    882  HB3 HIS A  69     -10.842   4.770  -0.311  1.00  0.00           H  
ATOM    883  HD1 HIS A  69      -8.573   5.756   0.078  1.00  0.00           H  
ATOM    884  HD2 HIS A  69      -9.397   5.290  -3.964  1.00  0.00           H  
ATOM    885  HE1 HIS A  69      -6.645   6.826  -1.126  1.00  0.00           H  
ATOM    886  HE2 HIS A  69      -7.246   6.666  -3.562  1.00  0.00           H  
ATOM    887  N   TRP A  70      -8.472   2.137  -1.115  1.00  0.00           N  
ATOM    888  CA  TRP A  70      -7.436   1.399  -0.356  1.00  0.00           C  
ATOM    889  C   TRP A  70      -7.132   2.044   1.011  1.00  0.00           C  
ATOM    890  O   TRP A  70      -6.995   1.338   2.003  1.00  0.00           O  
ATOM    891  CB  TRP A  70      -6.123   1.281  -1.164  1.00  0.00           C  
ATOM    892  CG  TRP A  70      -6.233   0.470  -2.431  1.00  0.00           C  
ATOM    893  CD1 TRP A  70      -6.226   0.940  -3.711  1.00  0.00           C  
ATOM    894  CD2 TRP A  70      -6.355  -0.960  -2.531  1.00  0.00           C  
ATOM    895  NE1 TRP A  70      -6.345  -0.093  -4.599  1.00  0.00           N  
ATOM    896  CE2 TRP A  70      -6.420  -1.271  -3.901  1.00  0.00           C  
ATOM    897  CE3 TRP A  70      -6.413  -2.005  -1.596  1.00  0.00           C  
ATOM    898  CZ2 TRP A  70      -6.541  -2.575  -4.359  1.00  0.00           C  
ATOM    899  CZ3 TRP A  70      -6.536  -3.304  -2.056  1.00  0.00           C  
ATOM    900  CH2 TRP A  70      -6.595  -3.578  -3.426  1.00  0.00           C  
ATOM    901  H   TRP A  70      -8.239   2.486  -2.000  1.00  0.00           H  
ATOM    902  HA  TRP A  70      -7.821   0.397  -0.183  1.00  0.00           H  
ATOM    903  HB2 TRP A  70      -5.778   2.273  -1.427  1.00  0.00           H  
ATOM    904  HB3 TRP A  70      -5.365   0.809  -0.542  1.00  0.00           H  
ATOM    905  HD1 TRP A  70      -6.152   1.987  -3.976  1.00  0.00           H  
ATOM    906  HE1 TRP A  70      -6.375   0.003  -5.577  1.00  0.00           H  
ATOM    907  HE3 TRP A  70      -6.365  -1.810  -0.533  1.00  0.00           H  
ATOM    908  HZ2 TRP A  70      -6.590  -2.806  -5.415  1.00  0.00           H  
ATOM    909  HZ3 TRP A  70      -6.584  -4.124  -1.350  1.00  0.00           H  
ATOM    910  HH2 TRP A  70      -6.694  -4.612  -3.744  1.00  0.00           H  
ATOM    911  N   HIS A  71      -7.032   3.390   1.061  1.00  0.00           N  
ATOM    912  CA  HIS A  71      -6.669   4.108   2.309  1.00  0.00           C  
ATOM    913  C   HIS A  71      -7.777   3.971   3.382  1.00  0.00           C  
ATOM    914  O   HIS A  71      -7.505   4.077   4.578  1.00  0.00           O  
ATOM    915  CB  HIS A  71      -6.358   5.602   2.023  1.00  0.00           C  
ATOM    916  CG  HIS A  71      -5.586   6.318   3.113  1.00  0.00           C  
ATOM    917  ND1 HIS A  71      -5.288   7.662   3.056  1.00  0.00           N  
ATOM    918  CD2 HIS A  71      -4.990   5.860   4.244  1.00  0.00           C  
ATOM    919  CE1 HIS A  71      -4.542   7.989   4.095  1.00  0.00           C  
ATOM    920  NE2 HIS A  71      -4.348   6.917   4.827  1.00  0.00           N  
ATOM    921  H   HIS A  71      -7.188   3.905   0.243  1.00  0.00           H  
ATOM    922  HA  HIS A  71      -5.767   3.638   2.697  1.00  0.00           H  
ATOM    923  HB2 HIS A  71      -5.767   5.673   1.119  1.00  0.00           H  
ATOM    924  HB3 HIS A  71      -7.284   6.138   1.869  1.00  0.00           H  
ATOM    925  HD1 HIS A  71      -5.594   8.291   2.368  1.00  0.00           H  
ATOM    926  HD2 HIS A  71      -5.011   4.840   4.611  1.00  0.00           H  
ATOM    927  HE1 HIS A  71      -4.134   8.967   4.298  1.00  0.00           H  
ATOM    928  HE2 HIS A  71      -3.951   6.916   5.726  1.00  0.00           H  
ATOM    929  N   MET A  72      -9.025   3.733   2.932  1.00  0.00           N  
ATOM    930  CA  MET A  72     -10.168   3.491   3.838  1.00  0.00           C  
ATOM    931  C   MET A  72     -10.483   1.989   3.966  1.00  0.00           C  
ATOM    932  O   MET A  72     -11.366   1.602   4.741  1.00  0.00           O  
ATOM    933  CB  MET A  72     -11.400   4.315   3.382  1.00  0.00           C  
ATOM    934  CG  MET A  72     -11.240   5.828   3.617  1.00  0.00           C  
ATOM    935  SD  MET A  72     -12.656   6.799   3.056  1.00  0.00           S  
ATOM    936  CE  MET A  72     -12.611   6.533   1.284  1.00  0.00           C  
ATOM    937  H   MET A  72      -9.181   3.698   1.967  1.00  0.00           H  
ATOM    938  HA  MET A  72      -9.879   3.836   4.830  1.00  0.00           H  
ATOM    939  HB2 MET A  72     -11.569   4.148   2.323  1.00  0.00           H  
ATOM    940  HB3 MET A  72     -12.280   3.981   3.929  1.00  0.00           H  
ATOM    941  HG2 MET A  72     -11.113   6.003   4.677  1.00  0.00           H  
ATOM    942  HG3 MET A  72     -10.354   6.173   3.095  1.00  0.00           H  
ATOM    943  HE1 MET A  72     -11.661   6.860   0.890  1.00  0.00           H  
ATOM    944  HE2 MET A  72     -13.408   7.091   0.819  1.00  0.00           H  
ATOM    945  HE3 MET A  72     -12.745   5.476   1.072  1.00  0.00           H  
ATOM    946  N   LEU A  73      -9.729   1.154   3.237  1.00  0.00           N  
ATOM    947  CA  LEU A  73      -9.782  -0.304   3.368  1.00  0.00           C  
ATOM    948  C   LEU A  73      -8.701  -0.726   4.385  1.00  0.00           C  
ATOM    949  O   LEU A  73      -7.515  -0.446   4.206  1.00  0.00           O  
ATOM    950  CB  LEU A  73      -9.579  -0.976   1.965  1.00  0.00           C  
ATOM    951  CG  LEU A  73      -9.981  -2.488   1.803  1.00  0.00           C  
ATOM    952  CD1 LEU A  73      -8.982  -3.454   2.472  1.00  0.00           C  
ATOM    953  CD2 LEU A  73     -11.419  -2.735   2.308  1.00  0.00           C  
ATOM    954  H   LEU A  73      -9.101   1.534   2.594  1.00  0.00           H  
ATOM    955  HA  LEU A  73     -10.763  -0.579   3.756  1.00  0.00           H  
ATOM    956  HB2 LEU A  73     -10.157  -0.409   1.246  1.00  0.00           H  
ATOM    957  HB3 LEU A  73      -8.533  -0.877   1.688  1.00  0.00           H  
ATOM    958  HG  LEU A  73      -9.974  -2.727   0.745  1.00  0.00           H  
ATOM    959 HD11 LEU A  73      -9.271  -4.477   2.267  1.00  0.00           H  
ATOM    960 HD12 LEU A  73      -8.973  -3.291   3.543  1.00  0.00           H  
ATOM    961 HD13 LEU A  73      -7.992  -3.277   2.075  1.00  0.00           H  
ATOM    962 HD21 LEU A  73     -11.481  -2.529   3.371  1.00  0.00           H  
ATOM    963 HD22 LEU A  73     -11.697  -3.766   2.129  1.00  0.00           H  
ATOM    964 HD23 LEU A  73     -12.104  -2.090   1.780  1.00  0.00           H  
ATOM    965  N   GLU A  74      -9.144  -1.385   5.451  1.00  0.00           N  
ATOM    966  CA  GLU A  74      -8.287  -1.953   6.506  1.00  0.00           C  
ATOM    967  C   GLU A  74      -8.443  -3.479   6.490  1.00  0.00           C  
ATOM    968  O   GLU A  74      -9.465  -3.979   6.038  1.00  0.00           O  
ATOM    969  CB  GLU A  74      -8.712  -1.357   7.885  1.00  0.00           C  
ATOM    970  CG  GLU A  74      -7.990  -1.942   9.118  1.00  0.00           C  
ATOM    971  CD  GLU A  74      -8.347  -1.221  10.430  1.00  0.00           C  
ATOM    972  OE1 GLU A  74      -9.514  -1.301  10.866  1.00  0.00           O  
ATOM    973  OE2 GLU A  74      -7.467  -0.554  11.022  1.00  0.00           O  
ATOM    974  H   GLU A  74     -10.103  -1.513   5.535  1.00  0.00           H  
ATOM    975  HA  GLU A  74      -7.253  -1.694   6.303  1.00  0.00           H  
ATOM    976  HB2 GLU A  74      -8.522  -0.289   7.865  1.00  0.00           H  
ATOM    977  HB3 GLU A  74      -9.783  -1.506   8.015  1.00  0.00           H  
ATOM    978  HG2 GLU A  74      -8.261  -2.992   9.214  1.00  0.00           H  
ATOM    979  HG3 GLU A  74      -6.918  -1.879   8.953  1.00  0.00           H  
ATOM    980  N   ILE A  75      -7.413  -4.230   6.904  1.00  0.00           N  
ATOM    981  CA  ILE A  75      -7.539  -5.686   7.152  1.00  0.00           C  
ATOM    982  C   ILE A  75      -7.344  -6.003   8.644  1.00  0.00           C  
ATOM    983  O   ILE A  75      -6.321  -5.649   9.238  1.00  0.00           O  
ATOM    984  CB  ILE A  75      -6.561  -6.540   6.260  1.00  0.00           C  
ATOM    985  CG1 ILE A  75      -5.107  -5.962   6.285  1.00  0.00           C  
ATOM    986  CG2 ILE A  75      -7.115  -6.633   4.823  1.00  0.00           C  
ATOM    987  CD1 ILE A  75      -4.094  -6.739   5.465  1.00  0.00           C  
ATOM    988  H   ILE A  75      -6.548  -3.795   7.069  1.00  0.00           H  
ATOM    989  HA  ILE A  75      -8.562  -5.980   6.888  1.00  0.00           H  
ATOM    990  HB  ILE A  75      -6.543  -7.554   6.658  1.00  0.00           H  
ATOM    991 HG12 ILE A  75      -5.117  -4.949   5.902  1.00  0.00           H  
ATOM    992 HG13 ILE A  75      -4.753  -5.942   7.308  1.00  0.00           H  
ATOM    993 HG21 ILE A  75      -6.461  -7.244   4.209  1.00  0.00           H  
ATOM    994 HG22 ILE A  75      -7.180  -5.641   4.392  1.00  0.00           H  
ATOM    995 HG23 ILE A  75      -8.104  -7.077   4.839  1.00  0.00           H  
ATOM    996 HD11 ILE A  75      -3.122  -6.282   5.578  1.00  0.00           H  
ATOM    997 HD12 ILE A  75      -4.378  -6.720   4.419  1.00  0.00           H  
ATOM    998 HD13 ILE A  75      -4.054  -7.763   5.810  1.00  0.00           H  
ATOM    999  N   LEU A  76      -8.355  -6.655   9.241  1.00  0.00           N  
ATOM   1000  CA  LEU A  76      -8.305  -7.166  10.628  1.00  0.00           C  
ATOM   1001  C   LEU A  76      -8.548  -8.692  10.634  1.00  0.00           C  
ATOM   1002  O   LEU A  76      -8.637  -9.305  11.699  1.00  0.00           O  
ATOM   1003  CB  LEU A  76      -9.356  -6.444  11.526  1.00  0.00           C  
ATOM   1004  CG  LEU A  76      -9.181  -4.899  11.717  1.00  0.00           C  
ATOM   1005  CD1 LEU A  76     -10.261  -4.327  12.661  1.00  0.00           C  
ATOM   1006  CD2 LEU A  76      -7.765  -4.539  12.220  1.00  0.00           C  
ATOM   1007  H   LEU A  76      -9.172  -6.817   8.721  1.00  0.00           H  
ATOM   1008  HA  LEU A  76      -7.312  -6.984  11.029  1.00  0.00           H  
ATOM   1009  HB2 LEU A  76     -10.338  -6.618  11.096  1.00  0.00           H  
ATOM   1010  HB3 LEU A  76      -9.338  -6.909  12.510  1.00  0.00           H  
ATOM   1011  HG  LEU A  76      -9.313  -4.416  10.753  1.00  0.00           H  
ATOM   1012 HD11 LEU A  76     -10.137  -3.254  12.746  1.00  0.00           H  
ATOM   1013 HD12 LEU A  76     -10.175  -4.774  13.645  1.00  0.00           H  
ATOM   1014 HD13 LEU A  76     -11.244  -4.537  12.259  1.00  0.00           H  
ATOM   1015 HD21 LEU A  76      -7.031  -4.869  11.497  1.00  0.00           H  
ATOM   1016 HD22 LEU A  76      -7.575  -5.021  13.172  1.00  0.00           H  
ATOM   1017 HD23 LEU A  76      -7.682  -3.465  12.338  1.00  0.00           H  
ATOM   1018  N   GLY A  77      -8.676  -9.275   9.420  1.00  0.00           N  
ATOM   1019  CA  GLY A  77      -8.841 -10.719   9.240  1.00  0.00           C  
ATOM   1020  C   GLY A  77      -7.584 -11.516   9.585  1.00  0.00           C  
ATOM   1021  O   GLY A  77      -7.640 -12.415  10.439  1.00  0.00           O  
ATOM   1022  H   GLY A  77      -8.661  -8.704   8.628  1.00  0.00           H  
ATOM   1023  HA2 GLY A  77      -9.664 -11.059   9.852  1.00  0.00           H  
ATOM   1024  HA3 GLY A  77      -9.090 -10.902   8.205  1.00  0.00           H  
TER    1025      GLY A  77                                                      
END
MOLECULE T0462_77_143.pdb
ATOM   1204  N   GLU    77      -2.454  -0.642   9.985  1.00 11.51           N 
ATOM   1205  CA  GLU    77      -3.612  -0.786   9.094  1.00 13.44           C 
ATOM   1206  C   GLU    77      -3.312  -0.215   7.697  1.00  2.42           C 
ATOM   1207  O   GLU    77      -2.423   0.626   7.539  1.00 25.04           O 
ATOM   1208  CB  GLU    77      -4.862  -0.141   9.730  1.00 44.40           C 
ATOM   1209  CG  GLU    77      -4.619   1.193  10.448  1.00 34.41           C 
ATOM   1210  CD  GLU    77      -4.730   2.413   9.544  1.00 50.11           C 
ATOM   1211  OE1 GLU    77      -3.899   3.342   9.674  1.00 42.31           O 
ATOM   1212  OE2 GLU    77      -5.670   2.469   8.730  1.00 32.01           O 
ATOM   1213  H   GLU    77      -1.869   0.136   9.876  1.00 36.29           H 
ATOM   1214  HA  GLU    77      -3.795  -1.847   8.981  1.00 15.42           H 
ATOM   1215 3HB  GLU    77      -5.272  -0.837  10.449  1.00 36.29           H 
ATOM   1216 2HB  GLU    77      -5.600   0.023   8.957  1.00 36.29           H 
ATOM   1217 3HG  GLU    77      -3.628   1.173  10.883  1.00 36.29           H 
ATOM   1218 2HG  GLU    77      -5.349   1.296  11.240  1.00 36.29           H 
ATOM   1219  N   LEU    78      -4.045  -0.688   6.685  1.00 42.42           N 
ATOM   1220  CA  LEU    78      -3.726  -0.377   5.282  1.00 60.21           C 
ATOM   1221  C   LEU    78      -4.996  -0.222   4.419  1.00 62.54           C 
ATOM   1222  O   LEU    78      -6.044  -0.782   4.736  1.00  4.41           O 
ATOM   1223  CB  LEU    78      -2.814  -1.473   4.686  1.00 61.43           C 
ATOM   1224  CG  LEU    78      -3.447  -2.870   4.491  1.00 11.44           C 
ATOM   1225  CD1 LEU    78      -2.505  -3.774   3.701  1.00 12.40           C 
ATOM   1226  CD2 LEU    78      -3.799  -3.519   5.833  1.00 74.53           C 
ATOM   1227  H   LEU    78      -4.830  -1.244   6.884  1.00 36.29           H 
ATOM   1228  HA  LEU    78      -3.189   0.561   5.269  1.00 44.34           H 
ATOM   1229 3HB  LEU    78      -1.956  -1.581   5.336  1.00 36.29           H 
ATOM   1230 2HB  LEU    78      -2.465  -1.127   3.723  1.00 36.29           H 
ATOM   1231  HG  LEU    78      -4.358  -2.767   3.919  1.00 65.12           H 
ATOM   1232 1HD1 LEU    78      -2.985  -4.725   3.521  1.00 36.29           H 
ATOM   1233 2HD1 LEU    78      -1.595  -3.932   4.264  1.00 36.29           H 
ATOM   1234 3HD1 LEU    78      -2.265  -3.308   2.756  1.00 36.29           H 
ATOM   1235 1HD2 LEU    78      -4.537  -2.918   6.341  1.00 36.29           H 
ATOM   1236 2HD2 LEU    78      -2.912  -3.593   6.445  1.00 36.29           H 
ATOM   1237 3HD2 LEU    78      -4.200  -4.508   5.661  1.00 36.29           H 
ATOM   1238  N   PRO    79      -4.915   0.544   3.306  1.00 33.21           N 
ATOM   1239  CA  PRO    79      -6.069   0.774   2.413  1.00  3.41           C 
ATOM   1240  C   PRO    79      -6.473  -0.476   1.601  1.00 53.44           C 
ATOM   1241  O   PRO    79      -5.633  -1.315   1.265  1.00 30.11           O 
ATOM   1242  CB  PRO    79      -5.572   1.889   1.482  1.00 60.14           C 
ATOM   1243  CG  PRO    79      -4.091   1.726   1.458  1.00  3.44           C 
ATOM   1244  CD  PRO    79      -3.705   1.251   2.834  1.00 21.25           C 
ATOM   1245  HA  PRO    79      -6.926   1.127   2.970  1.00 32.11           H 
ATOM   1246 3HB  PRO    79      -5.852   2.854   1.884  1.00 36.29           H 
ATOM   1247 2HB  PRO    79      -6.001   1.766   0.497  1.00 36.29           H 
ATOM   1248 3HG  PRO    79      -3.618   2.673   1.241  1.00 36.29           H 
ATOM   1249 2HG  PRO    79      -3.814   0.990   0.716  1.00 36.29           H 
ATOM   1250 3HD  PRO    79      -3.475   2.091   3.474  1.00 36.29           H 
ATOM   1251 2HD  PRO    79      -2.861   0.577   2.779  1.00 36.29           H 
ATOM   1252  N   LEU    80      -7.765  -0.571   1.270  1.00 10.14           N 
ATOM   1253  CA  LEU    80      -8.322  -1.726   0.538  1.00 12.24           C 
ATOM   1254  C   LEU    80      -7.531  -2.084  -0.732  1.00 71.04           C 
ATOM   1255  O   LEU    80      -7.179  -3.245  -0.943  1.00 34.43           O 
ATOM   1256  CB  LEU    80      -9.787  -1.452   0.162  1.00 13.14           C 
ATOM   1257  CG  LEU    80     -10.808  -1.614   1.299  1.00 54.21           C 
ATOM   1258  CD1 LEU    80     -12.201  -1.194   0.838  1.00 12.24           C 
ATOM   1259  CD2 LEU    80     -10.824  -3.057   1.801  1.00 34.31           C 
ATOM   1260  H   LEU    80      -8.371   0.157   1.533  1.00 36.29           H 
ATOM   1261  HA  LEU    80      -8.296  -2.574   1.206  1.00 73.22           H 
ATOM   1262 3HB  LEU    80     -10.066  -2.124  -0.639  1.00 36.29           H 
ATOM   1263 2HB  LEU    80      -9.855  -0.438  -0.210  1.00 36.29           H 
ATOM   1264  HG  LEU    80     -10.523  -0.976   2.125  1.00 14.14           H 
ATOM   1265 1HD1 LEU    80     -12.900  -1.307   1.654  1.00 36.29           H 
ATOM   1266 2HD1 LEU    80     -12.514  -1.813   0.008  1.00 36.29           H 
ATOM   1267 3HD1 LEU    80     -12.181  -0.159   0.526  1.00 36.29           H 
ATOM   1268 1HD2 LEU    80     -11.535  -3.148   2.610  1.00 36.29           H 
ATOM   1269 2HD2 LEU    80      -9.841  -3.325   2.157  1.00 36.29           H 
ATOM   1270 3HD2 LEU    80     -11.109  -3.720   0.996  1.00 36.29           H 
ATOM   1271  N   ILE    81      -7.255  -1.088  -1.570  1.00 44.14           N 
ATOM   1272  CA  ILE    81      -6.604  -1.322  -2.871  1.00 50.44           C 
ATOM   1273  C   ILE    81      -5.189  -1.920  -2.721  1.00 33.22           C 
ATOM   1274  O   ILE    81      -4.653  -2.514  -3.657  1.00 43.13           O 
ATOM   1275  CB  ILE    81      -6.528  -0.010  -3.698  1.00 35.34           C 
ATOM   1276  CG1 ILE    81      -6.096  -0.294  -5.148  1.00 45.22           C 
ATOM   1277  CG2 ILE    81      -5.576   0.987  -3.044  1.00 11.34           C 
ATOM   1278  CD1 ILE    81      -7.036  -1.214  -5.900  1.00  2.11           C 
ATOM   1279  H   ILE    81      -7.502  -0.174  -1.317  1.00 36.29           H 
ATOM   1280  HA  ILE    81      -7.218  -2.025  -3.417  1.00  3.54           H 
ATOM   1281  HB  ILE    81      -7.513   0.435  -3.708  1.00 64.25           H 
ATOM   1282 3HG1 ILE    81      -5.116  -0.753  -5.144  1.00 36.29           H 
ATOM   1283 2HG1 ILE    81      -6.047   0.637  -5.692  1.00 36.29           H 
ATOM   1284 1HG2 ILE    81      -5.915   1.203  -2.040  1.00 36.29           H 
ATOM   1285 2HG2 ILE    81      -5.556   1.901  -3.620  1.00 36.29           H 
ATOM   1286 3HG2 ILE    81      -4.583   0.565  -3.003  1.00 36.29           H 
ATOM   1287 1HD1 ILE    81      -7.069  -2.176  -5.410  1.00 36.29           H 
ATOM   1288 2HD1 ILE    81      -6.681  -1.338  -6.912  1.00 36.29           H 
ATOM   1289 3HD1 ILE    81      -8.027  -0.784  -5.915  1.00 36.29           H 
ATOM   1290  N   LEU    82      -4.590  -1.765  -1.542  1.00 13.21           N 
ATOM   1291  CA  LEU    82      -3.229  -2.263  -1.295  1.00 75.44           C 
ATOM   1292  C   LEU    82      -3.235  -3.478  -0.352  1.00 14.20           C 
ATOM   1293  O   LEU    82      -2.176  -3.964   0.063  1.00 74.13           O 
ATOM   1294  CB  LEU    82      -2.366  -1.146  -0.695  1.00 53.44           C 
ATOM   1295  CG  LEU    82      -2.352   0.178  -1.474  1.00 23.25           C 
ATOM   1296  CD1 LEU    82      -1.386   1.167  -0.831  1.00 12.00           C 
ATOM   1297  CD2 LEU    82      -2.003  -0.053  -2.944  1.00 23.35           C 
ATOM   1298  H   LEU    82      -5.070  -1.312  -0.819  1.00 36.29           H 
ATOM   1299  HA  LEU    82      -2.804  -2.562  -2.243  1.00 41.41           H 
ATOM   1300 3HB  LEU    82      -1.349  -1.508  -0.628  1.00 36.29           H 
ATOM   1301 2HB  LEU    82      -2.723  -0.944   0.306  1.00 36.29           H 
ATOM   1302  HG  LEU    82      -3.341   0.615  -1.434  1.00 42.03           H 
ATOM   1303 1HD1 LEU    82      -1.403   2.098  -1.381  1.00 36.29           H 
ATOM   1304 2HD1 LEU    82      -0.385   0.760  -0.844  1.00 36.29           H 
ATOM   1305 3HD1 LEU    82      -1.686   1.348   0.191  1.00 36.29           H 
ATOM   1306 1HD2 LEU    82      -1.038  -0.530  -3.018  1.00 36.29           H 
ATOM   1307 2HD2 LEU    82      -1.974   0.897  -3.460  1.00 36.29           H 
ATOM   1308 3HD2 LEU    82      -2.754  -0.683  -3.398  1.00 36.29           H 
ATOM   1309  N   ALA    83      -4.428  -3.973  -0.032  1.00 32.45           N 
ATOM   1310  CA  ALA    83      -4.592  -5.071   0.925  1.00 15.43           C 
ATOM   1311  C   ALA    83      -4.014  -6.403   0.410  1.00 54.30           C 
ATOM   1312  O   ALA    83      -3.799  -6.591  -0.789  1.00 23.30           O 
ATOM   1313  CB  ALA    83      -6.067  -5.236   1.279  1.00 62.03           C 
ATOM   1314  H   ALA    83      -5.227  -3.589  -0.453  1.00 36.29           H 
ATOM   1315  HA  ALA    83      -4.066  -4.796   1.829  1.00  1.41           H 
ATOM   1316 1HB  ALA    83      -6.462  -4.293   1.627  1.00 36.29           H 
ATOM   1317 2HB  ALA    83      -6.170  -5.977   2.061  1.00 36.29           H 
ATOM   1318 3HB  ALA    83      -6.616  -5.558   0.406  1.00 36.29           H 
ATOM   1319  N   ASP    84      -3.760  -7.320   1.339  1.00 24.33           N 
ATOM   1320  CA  ASP    84      -3.272  -8.663   1.014  1.00 10.43           C 
ATOM   1321  C   ASP    84      -4.400  -9.512   0.385  1.00 31.22           C 
ATOM   1322  O   ASP    84      -4.529  -9.582  -0.842  1.00  1.44           O 
ATOM   1323  CB  ASP    84      -2.725  -9.313   2.296  1.00 12.14           C 
ATOM   1324  CG  ASP    84      -2.271 -10.747   2.104  1.00 72.45           C 
ATOM   1325  OD1 ASP    84      -3.012 -11.668   2.515  1.00 44.41           O 
ATOM   1326  OD2 ASP    84      -1.169 -10.955   1.558  1.00 25.23           O 
ATOM   1327  H   ASP    84      -3.901  -7.087   2.281  1.00 36.29           H 
ATOM   1328  HA  ASP    84      -2.469  -8.563   0.297  1.00 73.24           H 
ATOM   1329 3HB  ASP    84      -3.498  -9.296   3.051  1.00 36.29           H 
ATOM   1330 2HB  ASP    84      -1.883  -8.736   2.646  1.00 36.29           H 
ATOM   1331  N   ASP    85      -5.236 -10.120   1.232  1.00 43.24           N 
ATOM   1332  CA  ASP    85      -6.389 -10.904   0.774  1.00 10.24           C 
ATOM   1333  C   ASP    85      -7.229 -11.390   1.973  1.00  1.54           C 
ATOM   1334  O   ASP    85      -6.831 -11.223   3.127  1.00  0.32           O 
ATOM   1335  CB  ASP    85      -5.918 -12.100  -0.067  1.00 10.35           C 
ATOM   1336  CG  ASP    85      -7.046 -12.723  -0.867  1.00 21.21           C 
ATOM   1337  OD1 ASP    85      -7.689 -13.662  -0.366  1.00 45.32           O 
ATOM   1338  OD2 ASP    85      -7.309 -12.253  -1.993  1.00 50.25           O 
ATOM   1339  H   ASP    85      -5.066 -10.052   2.195  1.00 36.29           H 
ATOM   1340  HA  ASP    85      -7.004 -10.260   0.160  1.00  3.02           H 
ATOM   1341 3HB  ASP    85      -5.500 -12.853   0.587  1.00 36.29           H 
ATOM   1342 2HB  ASP    85      -5.153 -11.769  -0.756  1.00 36.29           H 
ATOM   1343  N   GLY    86      -8.394 -11.971   1.690  1.00 44.14           N 
ATOM   1344  CA  GLY    86      -9.235 -12.538   2.741  1.00 21.12           C 
ATOM   1345  C   GLY    86     -10.194 -11.536   3.378  1.00 41.53           C 
ATOM   1346  O   GLY    86     -10.603 -10.553   2.752  1.00 64.33           O 
ATOM   1347  H   GLY    86      -8.685 -12.028   0.756  1.00 36.29           H 
ATOM   1348 3HA  GLY    86      -8.598 -12.948   3.513  1.00 36.29           H 
ATOM   1349 2HA  GLY    86      -9.816 -13.343   2.314  1.00 36.29           H 
ATOM   1350  N   THR    87     -10.558 -11.795   4.635  1.00 35.13           N 
ATOM   1351  CA  THR    87     -11.509 -10.952   5.372  1.00 72.12           C 
ATOM   1352  C   THR    87     -10.799  -9.812   6.129  1.00 24.21           C 
ATOM   1353  O   THR    87      -9.826 -10.043   6.858  1.00 41.52           O 
ATOM   1354  CB  THR    87     -12.318 -11.785   6.400  1.00  0.32           C 
ATOM   1355  OG1 THR    87     -12.695 -13.054   5.838  1.00 42.15           O 
ATOM   1356  CG2 THR    87     -13.571 -11.036   6.845  1.00 42.41           C 
ATOM   1357  H   THR    87     -10.189 -12.586   5.077  1.00 36.29           H 
ATOM   1358  HA  THR    87     -12.203 -10.525   4.660  1.00 32.51           H 
ATOM   1359  HB  THR    87     -11.696 -11.961   7.268  1.00  2.24           H 
ATOM   1360  HG1 THR    87     -13.011 -12.935   4.931  1.00 64.23           H 
ATOM   1361 1HG2 THR    87     -14.114 -11.637   7.560  1.00 36.29           H 
ATOM   1362 2HG2 THR    87     -14.199 -10.838   5.989  1.00 36.29           H 
ATOM   1363 3HG2 THR    87     -13.288 -10.100   7.309  1.00 36.29           H 
ATOM   1364  N   TYR    88     -11.299  -8.585   5.964  1.00  4.25           N 
ATOM   1365  CA  TYR    88     -10.751  -7.403   6.652  1.00 21.51           C 
ATOM   1366  C   TYR    88     -11.807  -6.696   7.502  1.00 53.21           C 
ATOM   1367  O   TYR    88     -12.994  -6.942   7.359  1.00 53.41           O 
ATOM   1368  CB  TYR    88     -10.188  -6.406   5.634  1.00 52.03           C 
ATOM   1369  CG  TYR    88      -8.939  -6.890   4.940  1.00 31.22           C 
ATOM   1370  CD1 TYR    88      -9.013  -7.749   3.853  1.00 74.10           C 
ATOM   1371  CD2 TYR    88      -7.682  -6.496   5.382  1.00 54.22           C 
ATOM   1372  CE1 TYR    88      -7.874  -8.199   3.229  1.00 43.52           C 
ATOM   1373  CE2 TYR    88      -6.538  -6.941   4.759  1.00 42.24           C 
ATOM   1374  CZ  TYR    88      -6.642  -7.794   3.687  1.00 14.22           C 
ATOM   1375  OH  TYR    88      -5.509  -8.243   3.067  1.00 72.21           O 
ATOM   1376  H   TYR    88     -12.058  -8.465   5.355  1.00 36.29           H 
ATOM   1377  HA  TYR    88      -9.949  -7.733   7.299  1.00 13.41           H 
ATOM   1378 3HB  TYR    88      -9.950  -5.480   6.142  1.00 36.29           H 
ATOM   1379 2HB  TYR    88     -10.936  -6.210   4.877  1.00 36.29           H 
ATOM   1380  HD1 TYR    88      -9.983  -8.066   3.498  1.00 20.13           H 
ATOM   1381  HD2 TYR    88      -7.608  -5.825   6.225  1.00 62.02           H 
ATOM   1382  HE1 TYR    88      -7.950  -8.866   2.384  1.00 32.42           H 
ATOM   1383  HE2 TYR    88      -5.568  -6.625   5.117  1.00  4.31           H 
ATOM   1384  HH  TYR    88      -5.635  -8.200   2.112  1.00 71.22           H 
ATOM   1385  N   GLU    89     -11.354  -5.812   8.384  1.00 22.34           N 
ATOM   1386  CA  GLU    89     -12.251  -4.984   9.201  1.00 23.21           C 
ATOM   1387  C   GLU    89     -11.974  -3.490   8.965  1.00 54.21           C 
ATOM   1388  O   GLU    89     -10.836  -3.037   9.092  1.00 64.32           O 
ATOM   1389  CB  GLU    89     -12.069  -5.321  10.687  1.00 22.21           C 
ATOM   1390  CG  GLU    89     -12.930  -4.480  11.626  1.00 63.13           C 
ATOM   1391  CD  GLU    89     -12.663  -4.780  13.092  1.00 60.50           C 
ATOM   1392  OE1 GLU    89     -13.470  -5.499  13.719  1.00 25.53           O 
ATOM   1393  OE2 GLU    89     -11.647  -4.290  13.623  1.00 33.14           O 
ATOM   1394  H   GLU    89     -10.386  -5.716   8.500  1.00 36.29           H 
ATOM   1395  HA  GLU    89     -13.270  -5.201   8.910  1.00 11.21           H 
ATOM   1396 3HB  GLU    89     -11.032  -5.172  10.954  1.00 36.29           H 
ATOM   1397 2HB  GLU    89     -12.321  -6.362  10.840  1.00 36.29           H 
ATOM   1398 3HG  GLU    89     -13.972  -4.676  11.413  1.00 36.29           H 
ATOM   1399 2HG  GLU    89     -12.720  -3.435  11.445  1.00 36.29           H 
ATOM   1400  N   ILE    90     -13.009  -2.728   8.613  1.00 11.51           N 
ATOM   1401  CA  ILE    90     -12.846  -1.290   8.346  1.00 53.30           C 
ATOM   1402  C   ILE    90     -12.498  -0.498   9.622  1.00 34.11           C 
ATOM   1403  O   ILE    90     -13.180  -0.604  10.649  1.00 11.23           O 
ATOM   1404  CB  ILE    90     -14.111  -0.683   7.683  1.00 24.24           C 
ATOM   1405  CG1 ILE    90     -13.926   0.830   7.453  1.00 14.23           C 
ATOM   1406  CG2 ILE    90     -15.355  -0.960   8.528  1.00 25.01           C 
ATOM   1407  CD1 ILE    90     -15.115   1.501   6.804  1.00 35.11           C 
ATOM   1408  H   ILE    90     -13.898  -3.139   8.523  1.00 36.29           H 
ATOM   1409  HA  ILE    90     -12.026  -1.185   7.649  1.00 63.25           H 
ATOM   1410  HB  ILE    90     -14.249  -1.167   6.726  1.00 75.34           H 
ATOM   1411 3HG1 ILE    90     -13.066   0.990   6.816  1.00 36.29           H 
ATOM   1412 2HG1 ILE    90     -13.757   1.313   8.403  1.00 36.29           H 
ATOM   1413 1HG2 ILE    90     -15.247  -0.488   9.495  1.00 36.29           H 
ATOM   1414 2HG2 ILE    90     -15.472  -2.026   8.660  1.00 36.29           H 
ATOM   1415 3HG2 ILE    90     -16.228  -0.562   8.031  1.00 36.29           H 
ATOM   1416 1HD1 ILE    90     -15.985   1.378   7.431  1.00 36.29           H 
ATOM   1417 2HD1 ILE    90     -15.298   1.054   5.839  1.00 36.29           H 
ATOM   1418 3HD1 ILE    90     -14.910   2.554   6.679  1.00 36.29           H 
ATOM   1419  N   THR    91     -11.430   0.300   9.546  1.00 65.23           N 
ATOM   1420  CA  THR    91     -10.965   1.088  10.698  1.00 35.41           C 
ATOM   1421  C   THR    91     -11.241   2.593  10.535  1.00 43.23           C 
ATOM   1422  O   THR    91     -11.580   3.267  11.506  1.00 23.55           O 
ATOM   1423  CB  THR    91      -9.454   0.868  10.974  1.00 14.21           C 
ATOM   1424  OG1 THR    91      -9.022   1.680  12.077  1.00 73.21           O 
ATOM   1425  CG2 THR    91      -8.603   1.180   9.745  1.00 34.25           C 
ATOM   1426  H   THR    91     -10.940   0.357   8.697  1.00 36.29           H 
ATOM   1427  HA  THR    91     -11.507   0.740  11.569  1.00 61.54           H 
ATOM   1428  HB  THR    91      -9.305  -0.173  11.233  1.00 33.24           H 
ATOM   1429  HG1 THR    91      -9.720   1.708  12.747  1.00 14.23           H 
ATOM   1430 1HG2 THR    91      -8.722   2.219   9.474  1.00 36.29           H 
ATOM   1431 2HG2 THR    91      -8.916   0.555   8.920  1.00 36.29           H 
ATOM   1432 3HG2 THR    91      -7.564   0.984   9.968  1.00 36.29           H 
ATOM   1433  N   LYS    92     -11.100   3.122   9.313  1.00 42.31           N 
ATOM   1434  CA  LYS    92     -11.345   4.557   9.064  1.00 54.15           C 
ATOM   1435  C   LYS    92     -11.465   4.899   7.568  1.00 44.42           C 
ATOM   1436  O   LYS    92     -10.929   4.201   6.701  1.00 33.13           O 
ATOM   1437  CB  LYS    92     -10.233   5.419   9.682  1.00 65.22           C 
ATOM   1438  CG  LYS    92      -8.822   5.024   9.253  1.00 10.13           C 
ATOM   1439  CD  LYS    92      -7.794   6.078   9.659  1.00 64.52           C 
ATOM   1440  CE  LYS    92      -6.370   5.532   9.646  1.00  4.34           C 
ATOM   1441  NZ  LYS    92      -5.966   4.989   8.322  1.00 72.11           N 
ATOM   1442  H   LYS    92     -10.830   2.546   8.566  1.00 36.29           H 
ATOM   1443  HA  LYS    92     -12.281   4.811   9.543  1.00 11.11           H 
ATOM   1444 3HB  LYS    92     -10.293   5.338  10.759  1.00 36.29           H 
ATOM   1445 2HB  LYS    92     -10.396   6.451   9.402  1.00 36.29           H 
ATOM   1446 3HG  LYS    92      -8.801   4.907   8.176  1.00 36.29           H 
ATOM   1447 2HG  LYS    92      -8.565   4.084   9.720  1.00 36.29           H 
ATOM   1448 3HD  LYS    92      -8.024   6.427  10.656  1.00 36.29           H 
ATOM   1449 2HD  LYS    92      -7.852   6.907   8.967  1.00 36.29           H 
ATOM   1450 3HE  LYS    92      -6.301   4.743  10.378  1.00 36.29           H 
ATOM   1451 2HE  LYS    92      -5.692   6.326   9.915  1.00 36.29           H 
ATOM   1452 1HZ  LYS    92      -5.967   5.739   7.606  1.00 36.29           H 
ATOM   1453 2HZ  LYS    92      -6.620   4.235   8.030  1.00 36.29           H 
ATOM   1454 3HZ  LYS    92      -5.008   4.579   8.385  1.00 36.29           H 
ATOM   1455  N   LEU    93     -12.170   5.999   7.283  1.00 72.14           N 
ATOM   1456  CA  LEU    93     -12.288   6.540   5.919  1.00 12.31           C 
ATOM   1457  C   LEU    93     -11.469   7.838   5.779  1.00 10.13           C 
ATOM   1458  O   LEU    93     -11.050   8.430   6.777  1.00 42.13           O 
ATOM   1459  CB  LEU    93     -13.758   6.838   5.567  1.00  2.12           C 
ATOM   1460  CG  LEU    93     -14.729   5.640   5.568  1.00 63.13           C 
ATOM   1461  CD1 LEU    93     -14.168   4.482   4.754  1.00 23.14           C 
ATOM   1462  CD2 LEU    93     -15.068   5.202   6.993  1.00 50.42           C 
ATOM   1463  H   LEU    93     -12.626   6.467   8.016  1.00 36.29           H 
ATOM   1464  HA  LEU    93     -11.897   5.805   5.228  1.00 20.21           H 
ATOM   1465 3HB  LEU    93     -13.781   7.284   4.582  1.00 36.29           H 
ATOM   1466 2HB  LEU    93     -14.129   7.569   6.272  1.00 36.29           H 
ATOM   1467  HG  LEU    93     -15.652   5.949   5.093  1.00 22.03           H 
ATOM   1468 1HD1 LEU    93     -13.251   4.130   5.204  1.00 36.29           H 
ATOM   1469 2HD1 LEU    93     -13.968   4.815   3.745  1.00 36.29           H 
ATOM   1470 3HD1 LEU    93     -14.888   3.677   4.728  1.00 36.29           H 
ATOM   1471 1HD2 LEU    93     -15.746   4.363   6.959  1.00 36.29           H 
ATOM   1472 2HD2 LEU    93     -15.539   6.021   7.519  1.00 36.29           H 
ATOM   1473 3HD2 LEU    93     -14.165   4.913   7.510  1.00 36.29           H 
ATOM   1474  N   ASN    94     -11.246   8.277   4.540  1.00 74.35           N 
ATOM   1475  CA  ASN    94     -10.546   9.545   4.271  1.00 71.52           C 
ATOM   1476  C   ASN    94     -11.230  10.336   3.139  1.00 71.43           C 
ATOM   1477  O   ASN    94     -11.226   9.910   1.981  1.00 31.43           O 
ATOM   1478  CB  ASN    94      -9.078   9.279   3.908  1.00 32.31           C 
ATOM   1479  CG  ASN    94      -8.243   8.874   5.111  1.00 15.34           C 
ATOM   1480  OD1 ASN    94      -7.668   9.714   5.790  1.00  0.13           O 
ATOM   1481  ND2 ASN    94      -8.166   7.589   5.389  1.00 63.03           N 
ATOM   1482  H   ASN    94     -11.553   7.736   3.782  1.00 36.29           H 
ATOM   1483  HA  ASN    94     -10.579  10.141   5.175  1.00 70.10           H 
ATOM   1484 3HB  ASN    94      -8.649  10.176   3.483  1.00 36.29           H 
ATOM   1485 2HB  ASN    94      -9.031   8.485   3.177  1.00 36.29           H 
ATOM   1486 1HD2 ASN    94      -8.646   6.957   4.816  1.00 36.29           H 
ATOM   1487 2HD2 ASN    94      -7.625   7.321   6.157  1.00 36.29           H 
ATOM   1488  N   GLY    95     -11.820  11.485   3.478  1.00 54.24           N 
ATOM   1489  CA  GLY    95     -12.478  12.324   2.472  1.00 52.34           C 
ATOM   1490  C   GLY    95     -13.424  13.363   3.078  1.00 12.22           C 
ATOM   1491  O   GLY    95     -13.213  13.825   4.199  1.00 53.41           O 
ATOM   1492  H   GLY    95     -11.815  11.767   4.419  1.00 36.29           H 
ATOM   1493 3HA  GLY    95     -13.044  11.689   1.803  1.00 36.29           H 
ATOM   1494 2HA  GLY    95     -11.721  12.841   1.901  1.00 36.29           H 
ATOM   1495  N   GLY    96     -14.465  13.735   2.330  1.00 32.53           N 
ATOM   1496  CA  GLY    96     -15.456  14.691   2.826  1.00 24.42           C 
ATOM   1497  C   GLY    96     -16.753  14.021   3.281  1.00 74.23           C 
ATOM   1498  O   GLY    96     -16.880  12.797   3.213  1.00 22.41           O 
ATOM   1499  H   GLY    96     -14.565  13.355   1.434  1.00 36.29           H 
ATOM   1500 3HA  GLY    96     -15.685  15.392   2.035  1.00 36.29           H 
ATOM   1501 2HA  GLY    96     -15.036  15.236   3.660  1.00 36.29           H 
ATOM   1502  N   ARG    97     -17.730  14.818   3.722  1.00 73.32           N 
ATOM   1503  CA  ARG    97     -18.994  14.277   4.247  1.00  2.04           C 
ATOM   1504  C   ARG    97     -19.796  13.532   3.167  1.00  2.23           C 
ATOM   1505  O   ARG    97     -20.404  12.500   3.447  1.00 53.11           O 
ATOM   1506  CB  ARG    97     -19.858  15.386   4.873  1.00 45.22           C 
ATOM   1507  CG  ARG    97     -21.094  14.854   5.602  1.00  2.20           C 
ATOM   1508  CD  ARG    97     -21.859  15.957   6.332  1.00 61.12           C 
ATOM   1509  NE  ARG    97     -22.452  16.926   5.413  1.00 32.33           N 
ATOM   1510  CZ  ARG    97     -23.273  17.873   5.779  1.00 32.33           C 
ATOM   1511  NH1 ARG    97     -23.609  18.015   7.020  1.00  3.21           N 
ATOM   1512  NH2 ARG    97     -23.765  18.679   4.900  1.00 11.43           N 
ATOM   1513  H   ARG    97     -17.601  15.792   3.692  1.00 36.29           H 
ATOM   1514  HA  ARG    97     -18.737  13.568   5.022  1.00 11.03           H 
ATOM   1515 3HB  ARG    97     -20.185  16.059   4.092  1.00 36.29           H 
ATOM   1516 2HB  ARG    97     -19.256  15.939   5.582  1.00 36.29           H 
ATOM   1517 3HG  ARG    97     -20.782  14.109   6.321  1.00 36.29           H 
ATOM   1518 2HG  ARG    97     -21.754  14.397   4.878  1.00 36.29           H 
ATOM   1519 3HD  ARG    97     -21.177  16.472   6.995  1.00 36.29           H 
ATOM   1520 2HD  ARG    97     -22.648  15.503   6.916  1.00 36.29           H 
ATOM   1521  HE  ARG    97     -22.222  16.856   4.465  1.00 42.04           H 
ATOM   1522 1HH1 ARG    97     -23.243  17.397   7.712  1.00 36.29           H 
ATOM   1523 2HH1 ARG    97     -24.232  18.749   7.284  1.00 36.29           H 
ATOM   1524 1HH2 ARG    97     -23.519  18.578   3.938  1.00 36.29           H 
ATOM   1525 2HH2 ARG    97     -24.400  19.396   5.185  1.00 36.29           H 
ATOM   1526  N   ARG    98     -19.806  14.050   1.935  1.00 62.12           N 
ATOM   1527  CA  ARG    98     -20.482  13.349   0.830  1.00 55.01           C 
ATOM   1528  C   ARG    98     -19.751  12.044   0.482  1.00  3.21           C 
ATOM   1529  O   ARG    98     -20.380  11.035   0.162  1.00 61.24           O 
ATOM   1530  CB  ARG    98     -20.625  14.236  -0.421  1.00 33.50           C 
ATOM   1531  CG  ARG    98     -21.639  15.373  -0.262  1.00 43.41           C 
ATOM   1532  CD  ARG    98     -21.034  16.611   0.389  1.00 13.11           C 
ATOM   1533  NE  ARG    98     -20.195  17.358  -0.542  1.00 50.33           N 
ATOM   1534  CZ  ARG    98     -19.689  18.532  -0.290  1.00 64.24           C 
ATOM   1535  NH1 ARG    98     -19.838  19.083   0.871  1.00  3.54           N 
ATOM   1536  NH2 ARG    98     -19.019  19.154  -1.203  1.00 71.21           N 
ATOM   1537  H   ARG    98     -19.350  14.902   1.768  1.00 36.29           H 
ATOM   1538  HA  ARG    98     -21.473  13.091   1.181  1.00 32.24           H 
ATOM   1539 3HB  ARG    98     -20.939  13.618  -1.252  1.00 36.29           H 
ATOM   1540 2HB  ARG    98     -19.662  14.668  -0.655  1.00 36.29           H 
ATOM   1541 3HG  ARG    98     -22.461  15.023   0.349  1.00 36.29           H 
ATOM   1542 2HG  ARG    98     -22.012  15.645  -1.238  1.00 36.29           H 
ATOM   1543 3HD  ARG    98     -20.434  16.305   1.235  1.00 36.29           H 
ATOM   1544 2HD  ARG    98     -21.834  17.252   0.731  1.00 36.29           H 
ATOM   1545  HE  ARG    98     -20.026  16.961  -1.422  1.00 13.21           H 
ATOM   1546 1HH1 ARG    98     -20.345  18.610   1.587  1.00 36.29           H 
ATOM   1547 2HH1 ARG    98     -19.436  19.980   1.050  1.00 36.29           H 
ATOM   1548 1HH2 ARG    98     -18.895  18.737  -2.100  1.00 36.29           H 
ATOM   1549 2HH2 ARG    98     -18.633  20.053  -1.007  1.00 36.29           H 
ATOM   1550  N   PHE    99     -18.419  12.069   0.562  1.00  1.52           N 
ATOM   1551  CA  PHE    99     -17.618  10.848   0.421  1.00 14.23           C 
ATOM   1552  C   PHE    99     -18.048   9.806   1.468  1.00  3.12           C 
ATOM   1553  O   PHE    99     -18.276   8.636   1.148  1.00 43.23           O 
ATOM   1554  CB  PHE    99     -16.122  11.175   0.572  1.00 22.30           C 
ATOM   1555  CG  PHE    99     -15.220   9.964   0.535  1.00 62.53           C 
ATOM   1556  CD1 PHE    99     -14.787   9.438  -0.674  1.00 42.43           C 
ATOM   1557  CD2 PHE    99     -14.806   9.350   1.711  1.00 75.53           C 
ATOM   1558  CE1 PHE    99     -13.964   8.330  -0.711  1.00 72.43           C 
ATOM   1559  CE2 PHE    99     -13.982   8.242   1.679  1.00 20.21           C 
ATOM   1560  CZ  PHE    99     -13.562   7.731   0.467  1.00 72.42           C 
ATOM   1561  H   PHE    99     -17.965  12.923   0.714  1.00 36.29           H 
ATOM   1562  HA  PHE    99     -17.796  10.446  -0.568  1.00 12.34           H 
ATOM   1563 3HB  PHE    99     -15.966  11.678   1.516  1.00 36.29           H 
ATOM   1564 2HB  PHE    99     -15.823  11.835  -0.231  1.00 36.29           H 
ATOM   1565  HD1 PHE    99     -15.099   9.905  -1.597  1.00 15.13           H 
ATOM   1566  HD2 PHE    99     -15.135   9.749   2.661  1.00 32.43           H 
ATOM   1567  HE1 PHE    99     -13.636   7.931  -1.661  1.00  0.33           H 
ATOM   1568  HE2 PHE    99     -13.669   7.775   2.601  1.00 65.04           H 
ATOM   1569  HZ  PHE    99     -12.918   6.864   0.441  1.00 12.14           H 
ATOM   1570  N   LEU   100     -18.162  10.248   2.723  1.00 42.30           N 
ATOM   1571  CA  LEU   100     -18.650   9.387   3.806  1.00  4.13           C 
ATOM   1572  C   LEU   100     -20.083   8.916   3.529  1.00 51.22           C 
ATOM   1573  O   LEU   100     -20.413   7.754   3.746  1.00  4.33           O 
ATOM   1574  CB  LEU   100     -18.603  10.130   5.151  1.00 24.23           C 
ATOM   1575  CG  LEU   100     -17.214  10.620   5.591  1.00 21.10           C 
ATOM   1576  CD1 LEU   100     -17.297  11.336   6.937  1.00 11.20           C 
ATOM   1577  CD2 LEU   100     -16.222   9.459   5.656  1.00 32.53           C 
ATOM   1578  H   LEU   100     -17.907  11.174   2.928  1.00 36.29           H 
ATOM   1579  HA  LEU   100     -18.001   8.523   3.859  1.00  2.21           H 
ATOM   1580 3HB  LEU   100     -18.987   9.470   5.917  1.00 36.29           H 
ATOM   1581 2HB  LEU   100     -19.259  10.989   5.082  1.00 36.29           H 
ATOM   1582  HG  LEU   100     -16.846  11.330   4.864  1.00 45.44           H 
ATOM   1583 1HD1 LEU   100     -17.651  10.649   7.693  1.00 36.29           H 
ATOM   1584 2HD1 LEU   100     -17.979  12.171   6.861  1.00 36.29           H 
ATOM   1585 3HD1 LEU   100     -16.316  11.698   7.212  1.00 36.29           H 
ATOM   1586 1HD2 LEU   100     -15.255   9.828   5.969  1.00 36.29           H 
ATOM   1587 2HD2 LEU   100     -16.132   9.004   4.680  1.00 36.29           H 
ATOM   1588 3HD2 LEU   100     -16.572   8.721   6.364  1.00 36.29           H 
ATOM   1589  N   PHE   101     -20.920   9.825   3.030  1.00 25.05           N 
ATOM   1590  CA  PHE   101     -22.321   9.517   2.717  1.00 22.40           C 
ATOM   1591  C   PHE   101     -22.424   8.284   1.810  1.00 32.10           C 
ATOM   1592  O   PHE   101     -23.216   7.374   2.069  1.00 63.25           O 
ATOM   1593  CB  PHE   101     -22.979  10.728   2.043  1.00 62.32           C 
ATOM   1594  CG  PHE   101     -24.419  10.516   1.638  1.00 44.44           C 
ATOM   1595  CD1 PHE   101     -24.744  10.119   0.345  1.00 11.13           C 
ATOM   1596  CD2 PHE   101     -25.447  10.716   2.547  1.00  3.51           C 
ATOM   1597  CE1 PHE   101     -26.062   9.928  -0.027  1.00 71.41           C 
ATOM   1598  CE2 PHE   101     -26.766  10.527   2.179  1.00 53.41           C 
ATOM   1599  CZ  PHE   101     -27.075  10.131   0.891  1.00 10.35           C 
ATOM   1600  H   PHE   101     -20.586  10.731   2.866  1.00 36.29           H 
ATOM   1601  HA  PHE   101     -22.830   9.310   3.648  1.00 74.20           H 
ATOM   1602 3HB  PHE   101     -22.417  10.980   1.154  1.00 36.29           H 
ATOM   1603 2HB  PHE   101     -22.947  11.566   2.724  1.00 36.29           H 
ATOM   1604  HD1 PHE   101     -23.954   9.957  -0.374  1.00  1.30           H 
ATOM   1605  HD2 PHE   101     -25.212  11.026   3.556  1.00 41.52           H 
ATOM   1606  HE1 PHE   101     -26.301   9.619  -1.036  1.00 14.35           H 
ATOM   1607  HE2 PHE   101     -27.556  10.687   2.900  1.00 15.01           H 
ATOM   1608  HZ  PHE   101     -28.106   9.983   0.604  1.00 60.20           H 
ATOM   1609  N   ARG   102     -21.614   8.258   0.753  1.00 23.35           N 
ATOM   1610  CA  ARG   102     -21.536   7.094  -0.134  1.00 23.31           C 
ATOM   1611  C   ARG   102     -21.221   5.817   0.657  1.00 61.20           C 
ATOM   1612  O   ARG   102     -21.913   4.811   0.529  1.00  4.51           O 
ATOM   1613  CB  ARG   102     -20.459   7.310  -1.207  1.00 65.14           C 
ATOM   1614  CG  ARG   102     -20.798   8.403  -2.213  1.00 73.23           C 
ATOM   1615  CD  ARG   102     -22.003   8.029  -3.071  1.00  0.12           C 
ATOM   1616  NE  ARG   102     -22.336   9.077  -4.032  1.00 33.22           N 
ATOM   1617  CZ  ARG   102     -22.683   8.860  -5.272  1.00 43.40           C 
ATOM   1618  NH1 ARG   102     -22.703   7.655  -5.753  1.00  1.11           N 
ATOM   1619  NH2 ARG   102     -22.993   9.855  -6.034  1.00 44.44           N 
ATOM   1620  H   ARG   102     -21.055   9.043   0.563  1.00 36.29           H 
ATOM   1621  HA  ARG   102     -22.497   6.979  -0.618  1.00 14.34           H 
ATOM   1622 3HB  ARG   102     -20.315   6.384  -1.750  1.00 36.29           H 
ATOM   1623 2HB  ARG   102     -19.533   7.576  -0.719  1.00 36.29           H 
ATOM   1624 3HG  ARG   102     -19.945   8.563  -2.859  1.00 36.29           H 
ATOM   1625 2HG  ARG   102     -21.019   9.316  -1.679  1.00 36.29           H 
ATOM   1626 3HD  ARG   102     -22.854   7.865  -2.423  1.00 36.29           H 
ATOM   1627 2HD  ARG   102     -21.780   7.116  -3.605  1.00 36.29           H 
ATOM   1628  HE  ARG   102     -22.307  10.004  -3.716  1.00 40.12           H 
ATOM   1629 1HH1 ARG   102     -22.449   6.881  -5.177  1.00 36.29           H 
ATOM   1630 2HH1 ARG   102     -22.973   7.501  -6.702  1.00 36.29           H 
ATOM   1631 1HH2 ARG   102     -22.969  10.786  -5.671  1.00 36.29           H 
ATOM   1632 2HH2 ARG   102     -23.254   9.695  -6.984  1.00 36.29           H 
ATOM   1633  N   MET   103     -20.186   5.883   1.488  1.00 12.52           N 
ATOM   1634  CA  MET   103     -19.735   4.728   2.273  1.00 72.25           C 
ATOM   1635  C   MET   103     -20.818   4.229   3.246  1.00  2.14           C 
ATOM   1636  O   MET   103     -21.065   3.023   3.350  1.00 24.21           O 
ATOM   1637  CB  MET   103     -18.454   5.093   3.030  1.00 24.22           C 
ATOM   1638  CG  MET   103     -17.340   5.557   2.103  1.00 44.15           C 
ATOM   1639  SD  MET   103     -17.028   4.377   0.772  1.00 62.20           S 
ATOM   1640  CE  MET   103     -16.022   5.358  -0.338  1.00 74.41           C 
ATOM   1641  H   MET   103     -19.708   6.735   1.580  1.00 36.29           H 
ATOM   1642  HA  MET   103     -19.509   3.931   1.578  1.00  4.15           H 
ATOM   1643 3HB  MET   103     -18.106   4.228   3.575  1.00 36.29           H 
ATOM   1644 2HB  MET   103     -18.673   5.889   3.730  1.00 36.29           H 
ATOM   1645 3HG  MET   103     -16.432   5.681   2.679  1.00 36.29           H 
ATOM   1646 2HG  MET   103     -17.621   6.505   1.667  1.00 36.29           H 
ATOM   1647 1HE  MET   103     -15.753   4.765  -1.199  1.00 36.29           H 
ATOM   1648 2HE  MET   103     -15.127   5.675   0.174  1.00 36.29           H 
ATOM   1649 3HE  MET   103     -16.579   6.226  -0.659  1.00 36.29           H 
ATOM   1650  N   LYS   104     -21.477   5.159   3.936  1.00 52.44           N 
ATOM   1651  CA  LYS   104     -22.549   4.815   4.877  1.00 31.44           C 
ATOM   1652  C   LYS   104     -23.705   4.105   4.153  1.00 43.24           C 
ATOM   1653  O   LYS   104     -24.244   3.104   4.634  1.00 41.13           O 
ATOM   1654  CB  LYS   104     -23.070   6.081   5.579  1.00 61.35           C 
ATOM   1655  CG  LYS   104     -21.973   6.933   6.218  1.00 50.22           C 
ATOM   1656  CD  LYS   104     -22.539   8.142   6.969  1.00 61.35           C 
ATOM   1657  CE  LYS   104     -22.892   7.817   8.420  1.00 53.34           C 
ATOM   1658  NZ  LYS   104     -23.861   6.695   8.543  1.00 30.53           N 
ATOM   1659  H   LYS   104     -21.233   6.099   3.812  1.00 36.29           H 
ATOM   1660  HA  LYS   104     -22.137   4.144   5.619  1.00 41.12           H 
ATOM   1661 3HB  LYS   104     -23.764   5.787   6.354  1.00 36.29           H 
ATOM   1662 2HB  LYS   104     -23.593   6.691   4.855  1.00 36.29           H 
ATOM   1663 3HG  LYS   104     -21.309   7.283   5.442  1.00 36.29           H 
ATOM   1664 2HG  LYS   104     -21.415   6.319   6.912  1.00 36.29           H 
ATOM   1665 3HD  LYS   104     -23.431   8.483   6.461  1.00 36.29           H 
ATOM   1666 2HD  LYS   104     -21.802   8.934   6.964  1.00 36.29           H 
ATOM   1667 3HE  LYS   104     -23.319   8.698   8.877  1.00 36.29           H 
ATOM   1668 2HE  LYS   104     -21.987   7.549   8.944  1.00 36.29           H 
ATOM   1669 1HZ  LYS   104     -23.460   5.824   8.137  1.00 36.29           H 
ATOM   1670 2HZ  LYS   104     -24.742   6.924   8.043  1.00 36.29           H 
ATOM   1671 3HZ  LYS   104     -24.080   6.523   9.545  1.00 36.29           H 
ATOM   1672  N   ASN   105     -24.075   4.625   2.986  1.00 31.44           N 
ATOM   1673  CA  ASN   105     -25.150   4.039   2.179  1.00 20.54           C 
ATOM   1674  C   ASN   105     -24.684   2.767   1.446  1.00 62.14           C 
ATOM   1675  O   ASN   105     -25.498   1.920   1.088  1.00 23.42           O 
ATOM   1676  CB  ASN   105     -25.686   5.077   1.183  1.00 52.13           C 
ATOM   1677  CG  ASN   105     -26.582   6.111   1.848  1.00 71.04           C 
ATOM   1678  OD1 ASN   105     -27.800   5.955   1.901  1.00  2.24           O 
ATOM   1679  ND2 ASN   105     -25.995   7.167   2.371  1.00 13.41           N 
ATOM   1680  H   ASN   105     -23.611   5.424   2.654  1.00 36.29           H 
ATOM   1681  HA  ASN   105     -25.950   3.764   2.854  1.00 51.30           H 
ATOM   1682 3HB  ASN   105     -26.259   4.573   0.415  1.00 36.29           H 
ATOM   1683 2HB  ASN   105     -24.854   5.590   0.725  1.00 36.29           H 
ATOM   1684 1HD2 ASN   105     -25.024   7.236   2.304  1.00 36.29           H 
ATOM   1685 2HD2 ASN   105     -26.558   7.835   2.813  1.00 36.29           H 
ATOM   1686  N   LEU   106     -23.375   2.636   1.222  1.00 21.42           N 
ATOM   1687  CA  LEU   106     -22.816   1.444   0.563  1.00 42.00           C 
ATOM   1688  C   LEU   106     -22.699   0.252   1.528  1.00 44.44           C 
ATOM   1689  O   LEU   106     -22.835  -0.898   1.110  1.00 43.31           O 
ATOM   1690  CB  LEU   106     -21.445   1.755  -0.071  1.00 52.23           C 
ATOM   1691  CG  LEU   106     -21.443   1.918  -1.603  1.00 73.13           C 
ATOM   1692  CD1 LEU   106     -21.900   0.628  -2.282  1.00 25.24           C 
ATOM   1693  CD2 LEU   106     -22.324   3.088  -2.033  1.00  3.23           C 
ATOM   1694  H   LEU   106     -22.770   3.358   1.496  1.00 36.29           H 
ATOM   1695  HA  LEU   106     -23.502   1.167  -0.226  1.00 11.44           H 
ATOM   1696 3HB  LEU   106     -20.760   0.956   0.180  1.00 36.29           H 
ATOM   1697 2HB  LEU   106     -21.070   2.671   0.366  1.00 36.29           H 
ATOM   1698  HG  LEU   106     -20.432   2.124  -1.933  1.00 24.21           H 
ATOM   1699 1HD1 LEU   106     -21.863   0.753  -3.355  1.00 36.29           H 
ATOM   1700 2HD1 LEU   106     -22.914   0.401  -1.983  1.00 36.29           H 
ATOM   1701 3HD1 LEU   106     -21.250  -0.184  -1.992  1.00 36.29           H 
ATOM   1702 1HD2 LEU   106     -22.302   3.179  -3.108  1.00 36.29           H 
ATOM   1703 2HD2 LEU   106     -21.955   4.002  -1.588  1.00 36.29           H 
ATOM   1704 3HD2 LEU   106     -23.341   2.915  -1.706  1.00 36.29           H 
ATOM   1705  N   GLY   107     -22.443   0.524   2.808  1.00  4.41           N 
ATOM   1706  CA  GLY   107     -22.387  -0.549   3.803  1.00 75.00           C 
ATOM   1707  C   GLY   107     -21.149  -0.519   4.700  1.00 52.23           C 
ATOM   1708  O   GLY   107     -21.050  -1.299   5.650  1.00 74.33           O 
ATOM   1709  H   GLY   107     -22.303   1.456   3.083  1.00 36.29           H 
ATOM   1710 3HA  GLY   107     -22.415  -1.503   3.292  1.00 36.29           H 
ATOM   1711 2HA  GLY   107     -23.262  -0.474   4.431  1.00 36.29           H 
ATOM   1712  N   ILE   108     -20.204   0.376   4.419  1.00 20.43           N 
ATOM   1713  CA  ILE   108     -18.974   0.469   5.217  1.00 25.42           C 
ATOM   1714  C   ILE   108     -19.059   1.595   6.264  1.00 11.24           C 
ATOM   1715  O   ILE   108     -18.589   2.710   6.045  1.00  1.10           O 
ATOM   1716  CB  ILE   108     -17.688   0.643   4.345  1.00 45.21           C 
ATOM   1717  CG1 ILE   108     -17.897   1.640   3.187  1.00 21.42           C 
ATOM   1718  CG2 ILE   108     -17.203  -0.706   3.815  1.00 34.33           C 
ATOM   1719  CD1 ILE   108     -18.544   1.050   1.944  1.00  2.54           C 
ATOM   1720  H   ILE   108     -20.345   1.003   3.682  1.00 36.29           H 
ATOM   1721  HA  ILE   108     -18.876  -0.468   5.753  1.00 13.33           H 
ATOM   1722  HB  ILE   108     -16.911   1.029   4.991  1.00 72.34           H 
ATOM   1723 3HG1 ILE   108     -16.937   2.045   2.896  1.00 36.29           H 
ATOM   1724 2HG1 ILE   108     -18.527   2.450   3.527  1.00 36.29           H 
ATOM   1725 1HG2 ILE   108     -16.975  -1.359   4.646  1.00 36.29           H 
ATOM   1726 2HG2 ILE   108     -16.312  -0.561   3.220  1.00 36.29           H 
ATOM   1727 3HG2 ILE   108     -17.973  -1.156   3.206  1.00 36.29           H 
ATOM   1728 1HD1 ILE   108     -19.481   0.582   2.206  1.00 36.29           H 
ATOM   1729 2HD1 ILE   108     -17.883   0.316   1.509  1.00 36.29           H 
ATOM   1730 3HD1 ILE   108     -18.726   1.838   1.228  1.00 36.29           H 
ATOM   1731  N   GLU   109     -19.687   1.289   7.400  1.00 14.42           N 
ATOM   1732  CA  GLU   109     -19.801   2.238   8.518  1.00 50.05           C 
ATOM   1733  C   GLU   109     -18.596   2.127   9.468  1.00  1.42           C 
ATOM   1734  O   GLU   109     -17.716   2.992   9.483  1.00  4.22           O 
ATOM   1735  CB  GLU   109     -21.106   1.977   9.291  1.00  3.31           C 
ATOM   1736  CG  GLU   109     -22.377   2.245   8.484  1.00 43.33           C 
ATOM   1737  CD  GLU   109     -22.791   3.711   8.481  1.00  3.32           C 
ATOM   1738  OE1 GLU   109     -21.915   4.593   8.387  1.00 72.11           O 
ATOM   1739  OE2 GLU   109     -24.007   3.992   8.566  1.00  1.44           O 
ATOM   1740  H   GLU   109     -20.100   0.406   7.486  1.00 36.29           H 
ATOM   1741  HA  GLU   109     -19.831   3.239   8.107  1.00 55.04           H 
ATOM   1742 3HB  GLU   109     -21.124   2.609  10.170  1.00 36.29           H 
ATOM   1743 2HB  GLU   109     -21.119   0.946   9.605  1.00 36.29           H 
ATOM   1744 3HG  GLU   109     -23.181   1.659   8.909  1.00 36.29           H 
ATOM   1745 2HG  GLU   109     -22.213   1.933   7.463  1.00 36.29           H 
ATOM   1746  N   SER   110     -18.565   1.053  10.262  1.00 74.22           N 
ATOM   1747  CA  SER   110     -17.453   0.801  11.195  1.00  3.13           C 
ATOM   1748  C   SER   110     -17.450  -0.658  11.674  1.00  5.11           C 
ATOM   1749  O   SER   110     -18.506  -1.248  11.904  1.00 60.41           O 
ATOM   1750  CB  SER   110     -17.540   1.734  12.410  1.00 63.23           C 
ATOM   1751  OG  SER   110     -18.701   1.469  13.185  1.00 53.02           O 
ATOM   1752  H   SER   110     -19.312   0.418  10.232  1.00 36.29           H 
ATOM   1753  HA  SER   110     -16.529   0.997  10.666  1.00 72.12           H 
ATOM   1754 3HB  SER   110     -17.577   2.760  12.072  1.00 36.29           H 
ATOM   1755 2HB  SER   110     -16.669   1.595  13.035  1.00 36.29           H 
ATOM   1756  HG  SER   110     -18.448   1.331  14.105  1.00  0.43           H 
ATOM   1757  N   GLY   111     -16.258  -1.245  11.800  1.00  4.32           N 
ATOM   1758  CA  GLY   111     -16.133  -2.618  12.298  1.00 61.43           C 
ATOM   1759  C   GLY   111     -16.562  -3.693  11.296  1.00 32.32           C 
ATOM   1760  O   GLY   111     -16.359  -4.884  11.537  1.00 51.22           O 
ATOM   1761  H   GLY   111     -15.451  -0.741  11.562  1.00 36.29           H 
ATOM   1762 3HA  GLY   111     -16.736  -2.717  13.191  1.00 36.29           H 
ATOM   1763 2HA  GLY   111     -15.101  -2.790  12.563  1.00 36.29           H 
ATOM   1764  N   LYS   112     -17.154  -3.275  10.176  1.00  3.11           N 
ATOM   1765  CA  LYS   112     -17.630  -4.205   9.140  1.00 34.24           C 
ATOM   1766  C   LYS   112     -16.499  -5.083   8.579  1.00 41.42           C 
ATOM   1767  O   LYS   112     -15.406  -4.595   8.279  1.00  3.25           O 
ATOM   1768  CB  LYS   112     -18.284  -3.424   7.988  1.00 61.22           C 
ATOM   1769  CG  LYS   112     -19.630  -2.792   8.335  1.00 31.01           C 
ATOM   1770  CD  LYS   112     -20.692  -3.852   8.620  1.00 72.52           C 
ATOM   1771  CE  LYS   112     -22.077  -3.237   8.779  1.00 40.15           C 
ATOM   1772  NZ  LYS   112     -23.106  -4.266   9.079  1.00 34.21           N 
ATOM   1773  H   LYS   112     -17.277  -2.317  10.042  1.00 36.29           H 
ATOM   1774  HA  LYS   112     -18.374  -4.844   9.592  1.00 34.15           H 
ATOM   1775 3HB  LYS   112     -18.433  -4.096   7.154  1.00 36.29           H 
ATOM   1776 2HB  LYS   112     -17.612  -2.634   7.680  1.00 36.29           H 
ATOM   1777 3HG  LYS   112     -19.955  -2.184   7.501  1.00 36.29           H 
ATOM   1778 2HG  LYS   112     -19.509  -2.169   9.210  1.00 36.29           H 
ATOM   1779 3HD  LYS   112     -20.434  -4.374   9.532  1.00 36.29           H 
ATOM   1780 2HD  LYS   112     -20.717  -4.554   7.800  1.00 36.29           H 
ATOM   1781 3HE  LYS   112     -22.342  -2.732   7.860  1.00 36.29           H 
ATOM   1782 2HE  LYS   112     -22.051  -2.523   9.587  1.00 36.29           H 
ATOM   1783 1HZ  LYS   112     -22.943  -4.671  10.025  1.00 36.29           H 
ATOM   1784 2HZ  LYS   112     -23.065  -5.032   8.376  1.00 36.29           H 
ATOM   1785 3HZ  LYS   112     -24.052  -3.841   9.057  1.00 36.29           H 
ATOM   1786  N   LYS   113     -16.779  -6.379   8.432  1.00 22.32           N 
ATOM   1787  CA  LYS   113     -15.829  -7.313   7.820  1.00 63.22           C 
ATOM   1788  C   LYS   113     -15.988  -7.337   6.293  1.00 23.13           C 
ATOM   1789  O   LYS   113     -16.949  -7.896   5.759  1.00 61.52           O 
ATOM   1790  CB  LYS   113     -15.994  -8.726   8.407  1.00  2.21           C 
ATOM   1791  CG  LYS   113     -15.299  -8.923   9.757  1.00 33.44           C 
ATOM   1792  CD  LYS   113     -15.792  -7.940  10.821  1.00 54.34           C 
ATOM   1793  CE  LYS   113     -15.025  -8.083  12.130  1.00  4.32           C 
ATOM   1794  NZ  LYS   113     -15.512  -7.131  13.161  1.00 54.11           N 
ATOM   1795  H   LYS   113     -17.644  -6.720   8.747  1.00 36.29           H 
ATOM   1796  HA  LYS   113     -14.834  -6.959   8.052  1.00 65.00           H 
ATOM   1797 3HB  LYS   113     -15.582  -9.444   7.711  1.00 36.29           H 
ATOM   1798 2HB  LYS   113     -17.047  -8.932   8.535  1.00 36.29           H 
ATOM   1799 3HG  LYS   113     -14.234  -8.788   9.621  1.00 36.29           H 
ATOM   1800 2HG  LYS   113     -15.489  -9.930  10.101  1.00 36.29           H 
ATOM   1801 3HD  LYS   113     -16.841  -8.123  11.006  1.00 36.29           H 
ATOM   1802 2HD  LYS   113     -15.663  -6.932  10.453  1.00 36.29           H 
ATOM   1803 3HE  LYS   113     -13.977  -7.892  11.945  1.00 36.29           H 
ATOM   1804 2HE  LYS   113     -15.146  -9.090  12.499  1.00 36.29           H 
ATOM   1805 1HZ  LYS   113     -15.522  -6.165  12.778  1.00 36.29           H 
ATOM   1806 2HZ  LYS   113     -14.886  -7.154  13.991  1.00 36.29           H 
ATOM   1807 3HZ  LYS   113     -16.475  -7.385  13.461  1.00 36.29           H 
ATOM   1808  N   ILE   114     -15.030  -6.725   5.601  1.00 74.14           N 
ATOM   1809  CA  ILE   114     -15.084  -6.570   4.145  1.00  2.33           C 
ATOM   1810  C   ILE   114     -14.092  -7.515   3.433  1.00 44.51           C 
ATOM   1811  O   ILE   114     -12.929  -7.631   3.823  1.00 10.11           O 
ATOM   1812  CB  ILE   114     -14.806  -5.094   3.754  1.00 75.45           C 
ATOM   1813  CG1 ILE   114     -15.044  -4.862   2.251  1.00 52.12           C 
ATOM   1814  CG2 ILE   114     -13.387  -4.676   4.149  1.00 50.24           C 
ATOM   1815  CD1 ILE   114     -15.046  -3.397   1.856  1.00 54.51           C 
ATOM   1816  H   ILE   114     -14.261  -6.363   6.088  1.00 36.29           H 
ATOM   1817  HA  ILE   114     -16.087  -6.818   3.823  1.00 40.45           H 
ATOM   1818  HB  ILE   114     -15.493  -4.473   4.313  1.00  4.51           H 
ATOM   1819 3HG1 ILE   114     -16.002  -5.278   1.977  1.00 36.29           H 
ATOM   1820 2HG1 ILE   114     -14.268  -5.357   1.685  1.00 36.29           H 
ATOM   1821 1HG2 ILE   114     -13.260  -4.793   5.216  1.00 36.29           H 
ATOM   1822 2HG2 ILE   114     -13.224  -3.642   3.880  1.00 36.29           H 
ATOM   1823 3HG2 ILE   114     -12.670  -5.299   3.633  1.00 36.29           H 
ATOM   1824 1HD1 ILE   114     -14.090  -2.956   2.098  1.00 36.29           H 
ATOM   1825 2HD1 ILE   114     -15.828  -2.878   2.392  1.00 36.29           H 
ATOM   1826 3HD1 ILE   114     -15.222  -3.312   0.794  1.00 36.29           H 
ATOM   1827  N   GLN   115     -14.574  -8.211   2.405  1.00  1.25           N 
ATOM   1828  CA  GLN   115     -13.751  -9.165   1.648  1.00 51.53           C 
ATOM   1829  C   GLN   115     -13.154  -8.520   0.389  1.00 75.21           C 
ATOM   1830  O   GLN   115     -13.791  -7.684  -0.255  1.00 13.35           O 
ATOM   1831  CB  GLN   115     -14.577 -10.397   1.244  1.00 52.33           C 
ATOM   1832  CG  GLN   115     -15.051 -11.264   2.410  1.00 22.45           C 
ATOM   1833  CD  GLN   115     -16.130 -10.612   3.259  1.00 10.23           C 
ATOM   1834  OE1 GLN   115     -17.318 -10.739   2.985  1.00 63.13           O 
ATOM   1835  NE2 GLN   115     -15.733  -9.933   4.312  1.00 14.31           N 
ATOM   1836  H   GLN   115     -15.512  -8.084   2.150  1.00 36.29           H 
ATOM   1837  HA  GLN   115     -12.940  -9.484   2.291  1.00 73.32           H 
ATOM   1838 3HB  GLN   115     -13.976 -11.016   0.591  1.00 36.29           H 
ATOM   1839 2HB  GLN   115     -15.449 -10.065   0.699  1.00 36.29           H 
ATOM   1840 3HG  GLN   115     -14.202 -11.486   3.042  1.00 36.29           H 
ATOM   1841 2HG  GLN   115     -15.444 -12.189   2.013  1.00 36.29           H 
ATOM   1842 1HE2 GLN   115     -14.776  -9.884   4.493  1.00 36.29           H 
ATOM   1843 2HE2 GLN   115     -16.416  -9.501   4.866  1.00 36.29           H 
ATOM   1844  N   VAL   116     -11.934  -8.924   0.035  1.00  5.30           N 
ATOM   1845  CA  VAL   116     -11.244  -8.398  -1.153  1.00 24.20           C 
ATOM   1846  C   VAL   116     -11.268  -9.405  -2.321  1.00 21.53           C 
ATOM   1847  O   VAL   116     -10.779 -10.529  -2.193  1.00 13.22           O 
ATOM   1848  CB  VAL   116      -9.771  -8.041  -0.822  1.00 43.21           C 
ATOM   1849  CG1 VAL   116      -9.035  -7.525  -2.059  1.00 45.14           C 
ATOM   1850  CG2 VAL   116      -9.703  -7.018   0.312  1.00 43.24           C 
ATOM   1851  H   VAL   116     -11.477  -9.594   0.590  1.00 36.29           H 
ATOM   1852  HA  VAL   116     -11.751  -7.491  -1.463  1.00 33.34           H 
ATOM   1853  HB  VAL   116      -9.273  -8.943  -0.491  1.00 74.23           H 
ATOM   1854 1HG1 VAL   116      -9.523  -6.632  -2.425  1.00 36.29           H 
ATOM   1855 2HG1 VAL   116      -9.048  -8.282  -2.830  1.00 36.29           H 
ATOM   1856 3HG1 VAL   116      -8.013  -7.293  -1.801  1.00 36.29           H 
ATOM   1857 1HG2 VAL   116     -10.200  -7.414   1.186  1.00 36.29           H 
ATOM   1858 2HG2 VAL   116     -10.191  -6.104   0.005  1.00 36.29           H 
ATOM   1859 3HG2 VAL   116      -8.669  -6.809   0.551  1.00 36.29           H 
ATOM   1860  N   SER   117     -11.834  -8.991  -3.459  1.00 32.24           N 
ATOM   1861  CA  SER   117     -11.877  -9.838  -4.666  1.00 71.32           C 
ATOM   1862  C   SER   117     -11.781  -8.999  -5.949  1.00 31.01           C 
ATOM   1863  O   SER   117     -12.653  -8.179  -6.231  1.00 51.43           O 
ATOM   1864  CB  SER   117     -13.166 -10.671  -4.702  1.00 71.42           C 
ATOM   1865  OG  SER   117     -13.264 -11.424  -5.904  1.00 75.11           O 
ATOM   1866  H   SER   117     -12.243  -8.099  -3.491  1.00 36.29           H 
ATOM   1867  HA  SER   117     -11.028 -10.510  -4.630  1.00 41.04           H 
ATOM   1868 3HB  SER   117     -14.019 -10.012  -4.635  1.00 36.29           H 
ATOM   1869 2HB  SER   117     -13.173 -11.353  -3.867  1.00 36.29           H 
ATOM   1870  HG  SER   117     -14.120 -11.872  -5.932  1.00 73.31           H 
ATOM   1871  N   GLY   118     -10.717  -9.213  -6.719  1.00 33.21           N 
ATOM   1872  CA  GLY   118     -10.530  -8.493  -7.977  1.00 12.42           C 
ATOM   1873  C   GLY   118     -10.578  -6.971  -7.828  1.00 74.20           C 
ATOM   1874  O   GLY   118      -9.735  -6.377  -7.158  1.00 20.33           O 
ATOM   1875  H   GLY   118     -10.053  -9.876  -6.438  1.00 36.29           H 
ATOM   1876 3HA  GLY   118     -11.303  -8.800  -8.669  1.00 36.29           H 
ATOM   1877 2HA  GLY   118      -9.571  -8.769  -8.390  1.00 36.29           H 
ATOM   1878  N   ARG   119     -11.570  -6.342  -8.460  1.00 25.32           N 
ATOM   1879  CA  ARG   119     -11.739  -4.883  -8.395  1.00 34.22           C 
ATOM   1880  C   ARG   119     -13.046  -4.488  -7.683  1.00  2.21           C 
ATOM   1881  O   ARG   119     -13.582  -3.404  -7.913  1.00 13.21           O 
ATOM   1882  CB  ARG   119     -11.711  -4.285  -9.810  1.00 42.40           C 
ATOM   1883  CG  ARG   119     -10.351  -4.386 -10.497  1.00 71.15           C 
ATOM   1884  CD  ARG   119      -9.283  -3.580  -9.762  1.00 32.30           C 
ATOM   1885  NE  ARG   119      -7.979  -3.672 -10.415  1.00 24.14           N 
ATOM   1886  CZ  ARG   119      -6.876  -3.167  -9.934  1.00 45.15           C 
ATOM   1887  NH1 ARG   119      -6.883  -2.491  -8.831  1.00 23.21           N 
ATOM   1888  NH2 ARG   119      -5.766  -3.322 -10.573  1.00 61.32           N 
ATOM   1889  H   ARG   119     -12.206  -6.872  -8.987  1.00 36.29           H 
ATOM   1890  HA  ARG   119     -10.909  -4.478  -7.832  1.00 21.42           H 
ATOM   1891 3HB  ARG   119     -11.984  -3.241  -9.755  1.00 36.29           H 
ATOM   1892 2HB  ARG   119     -12.437  -4.803 -10.422  1.00 36.29           H 
ATOM   1893 3HG  ARG   119     -10.439  -4.013 -11.507  1.00 36.29           H 
ATOM   1894 2HG  ARG   119     -10.047  -5.424 -10.522  1.00 36.29           H 
ATOM   1895 3HD  ARG   119      -9.198  -3.958  -8.751  1.00 36.29           H 
ATOM   1896 2HD  ARG   119      -9.590  -2.545  -9.734  1.00 36.29           H 
ATOM   1897  HE  ARG   119      -7.934  -4.155 -11.265  1.00 73.21           H 
ATOM   1898 1HH1 ARG   119      -7.737  -2.351  -8.338  1.00 36.29           H 
ATOM   1899 2HH1 ARG   119      -6.030  -2.114  -8.478  1.00 36.29           H 
ATOM   1900 1HH2 ARG   119      -5.751  -3.827 -11.434  1.00 36.29           H 
ATOM   1901 2HH2 ARG   119      -4.922  -2.939 -10.202  1.00 36.29           H 
ATOM   1902  N   ARG   120     -13.549  -5.366  -6.814  1.00 13.33           N 
ATOM   1903  CA  ARG   120     -14.733  -5.051  -6.004  1.00 42.34           C 
ATOM   1904  C   ARG   120     -14.646  -5.711  -4.618  1.00  2.33           C 
ATOM   1905  O   ARG   120     -14.144  -6.826  -4.471  1.00 12.04           O 
ATOM   1906  CB  ARG   120     -16.037  -5.467  -6.719  1.00  1.04           C 
ATOM   1907  CG  ARG   120     -16.304  -6.973  -6.772  1.00 73.22           C 
ATOM   1908  CD  ARG   120     -15.361  -7.713  -7.714  1.00 13.13           C 
ATOM   1909  NE  ARG   120     -15.606  -9.153  -7.688  1.00 42.00           N 
ATOM   1910  CZ  ARG   120     -15.171  -9.996  -8.582  1.00  4.14           C 
ATOM   1911  NH1 ARG   120     -14.451  -9.599  -9.583  1.00 52.34           N 
ATOM   1912  NH2 ARG   120     -15.455 -11.249  -8.463  1.00 14.03           N 
ATOM   1913  H   ARG   120     -13.113  -6.240  -6.707  1.00 36.29           H 
ATOM   1914  HA  ARG   120     -14.746  -3.977  -5.863  1.00 23.42           H 
ATOM   1915 3HB  ARG   120     -16.001  -5.097  -7.736  1.00 36.29           H 
ATOM   1916 2HB  ARG   120     -16.870  -5.000  -6.213  1.00 36.29           H 
ATOM   1917 3HG  ARG   120     -17.322  -7.130  -7.106  1.00 36.29           H 
ATOM   1918 2HG  ARG   120     -16.190  -7.382  -5.779  1.00 36.29           H 
ATOM   1919 3HD  ARG   120     -14.340  -7.525  -7.412  1.00 36.29           H 
ATOM   1920 2HD  ARG   120     -15.514  -7.346  -8.720  1.00 36.29           H 
ATOM   1921  HE  ARG   120     -16.141  -9.504  -6.947  1.00 73.14           H 
ATOM   1922 1HH1 ARG   120     -14.218  -8.637  -9.681  1.00 36.29           H 
ATOM   1923 2HH1 ARG   120     -14.127 -10.264 -10.254  1.00 36.29           H 
ATOM   1924 1HH2 ARG   120     -15.997 -11.567  -7.686  1.00 36.29           H 
ATOM   1925 2HH2 ARG   120     -15.140 -11.897  -9.151  1.00 36.29           H 
ATOM   1926  N   TYR   121     -15.137  -5.016  -3.602  1.00 61.44           N 
ATOM   1927  CA  TYR   121     -15.057  -5.499  -2.222  1.00 32.34           C 
ATOM   1928  C   TYR   121     -16.448  -5.885  -1.695  1.00  1.31           C 
ATOM   1929  O   TYR   121     -17.450  -5.283  -2.075  1.00 44.54           O 
ATOM   1930  CB  TYR   121     -14.417  -4.424  -1.344  1.00 31.21           C 
ATOM   1931  CG  TYR   121     -13.079  -3.945  -1.877  1.00 42.15           C 
ATOM   1932  CD1 TYR   121     -12.994  -2.810  -2.676  1.00 22.22           C 
ATOM   1933  CD2 TYR   121     -11.906  -4.634  -1.594  1.00 22.31           C 
ATOM   1934  CE1 TYR   121     -11.781  -2.375  -3.174  1.00 31.53           C 
ATOM   1935  CE2 TYR   121     -10.689  -4.204  -2.089  1.00 43.00           C 
ATOM   1936  CZ  TYR   121     -10.632  -3.074  -2.881  1.00  2.42           C 
ATOM   1937  OH  TYR   121      -9.422  -2.638  -3.372  1.00 23.02           O 
ATOM   1938  H   TYR   121     -15.566  -4.155  -3.780  1.00 36.29           H 
ATOM   1939  HA  TYR   121     -14.427  -6.380  -2.211  1.00 55.21           H 
ATOM   1940 3HB  TYR   121     -14.258  -4.820  -0.351  1.00 36.29           H 
ATOM   1941 2HB  TYR   121     -15.080  -3.571  -1.285  1.00 36.29           H 
ATOM   1942  HD1 TYR   121     -13.895  -2.262  -2.907  1.00 60.30           H 
ATOM   1943  HD2 TYR   121     -11.951  -5.517  -0.975  1.00 15.43           H 
ATOM   1944  HE1 TYR   121     -11.738  -1.491  -3.792  1.00 70.53           H 
ATOM   1945  HE2 TYR   121      -9.787  -4.756  -1.858  1.00  2.23           H 
ATOM   1946  HH  TYR   121      -8.912  -3.391  -3.682  1.00 11.12           H 
ATOM   1947  N   TYR   122     -16.508  -6.891  -0.824  1.00 71.12           N 
ATOM   1948  CA  TYR   122     -17.792  -7.460  -0.385  1.00  4.51           C 
ATOM   1949  C   TYR   122     -18.089  -7.192   1.101  1.00 13.21           C 
ATOM   1950  O   TYR   122     -17.336  -7.607   1.982  1.00  0.03           O 
ATOM   1951  CB  TYR   122     -17.802  -8.974  -0.641  1.00 41.43           C 
ATOM   1952  CG  TYR   122     -17.747  -9.356  -2.112  1.00 23.53           C 
ATOM   1953  CD1 TYR   122     -16.604  -9.120  -2.870  1.00 42.45           C 
ATOM   1954  CD2 TYR   122     -18.835  -9.954  -2.740  1.00 52.10           C 
ATOM   1955  CE1 TYR   122     -16.549  -9.467  -4.203  1.00 23.30           C 
ATOM   1956  CE2 TYR   122     -18.784 -10.306  -4.077  1.00  0.13           C 
ATOM   1957  CZ  TYR   122     -17.638 -10.058  -4.803  1.00 42.13           C 
ATOM   1958  OH  TYR   122     -17.582 -10.400  -6.136  1.00 14.43           O 
ATOM   1959  H   TYR   122     -15.673  -7.263  -0.471  1.00 36.29           H 
ATOM   1960  HA  TYR   122     -18.576  -7.007  -0.979  1.00 54.24           H 
ATOM   1961 3HB  TYR   122     -18.702  -9.398  -0.219  1.00 36.29           H 
ATOM   1962 2HB  TYR   122     -16.943  -9.417  -0.153  1.00 36.29           H 
ATOM   1963  HD1 TYR   122     -15.750  -8.654  -2.400  1.00 52.42           H 
ATOM   1964  HD2 TYR   122     -19.731 -10.145  -2.169  1.00 51.21           H 
ATOM   1965  HE1 TYR   122     -15.651  -9.273  -4.773  1.00 34.31           H 
ATOM   1966  HE2 TYR   122     -19.640 -10.769  -4.546  1.00  1.05           H 
ATOM   1967  HH  TYR   122     -18.382 -10.089  -6.579  1.00 70.22           H 
ATOM   1968  N   ILE   123     -19.191  -6.496   1.363  1.00 61.04           N 
ATOM   1969  CA  ILE   123     -19.716  -6.327   2.724  1.00 61.25           C 
ATOM   1970  C   ILE   123     -20.884  -7.296   2.976  1.00 63.30           C 
ATOM   1971  O   ILE   123     -22.014  -7.048   2.550  1.00 15.23           O 
ATOM   1972  CB  ILE   123     -20.194  -4.867   2.978  1.00 74.12           C 
ATOM   1973  CG1 ILE   123     -18.997  -3.905   3.017  1.00 54.22           C 
ATOM   1974  CG2 ILE   123     -21.003  -4.765   4.277  1.00  1.41           C 
ATOM   1975  CD1 ILE   123     -18.094  -4.109   4.215  1.00 71.10           C 
ATOM   1976  H   ILE   123     -19.665  -6.070   0.620  1.00 36.29           H 
ATOM   1977  HA  ILE   123     -18.918  -6.552   3.422  1.00 35.31           H 
ATOM   1978  HB  ILE   123     -20.843  -4.582   2.160  1.00 71.41           H 
ATOM   1979 3HG1 ILE   123     -19.358  -2.886   3.042  1.00 36.29           H 
ATOM   1980 2HG1 ILE   123     -18.398  -4.045   2.128  1.00 36.29           H 
ATOM   1981 1HG2 ILE   123     -21.283  -3.735   4.449  1.00 36.29           H 
ATOM   1982 2HG2 ILE   123     -20.406  -5.118   5.105  1.00 36.29           H 
ATOM   1983 3HG2 ILE   123     -21.897  -5.370   4.197  1.00 36.29           H 
ATOM   1984 1HD1 ILE   123     -17.717  -5.122   4.218  1.00 36.29           H 
ATOM   1985 2HD1 ILE   123     -18.652  -3.930   5.122  1.00 36.29           H 
ATOM   1986 3HD1 ILE   123     -17.265  -3.418   4.162  1.00 36.29           H 
ATOM   1987  N   GLU   124     -20.594  -8.415   3.642  1.00 50.43           N 
ATOM   1988  CA  GLU   124     -21.624  -9.406   4.008  1.00 72.50           C 
ATOM   1989  C   GLU   124     -22.407  -9.922   2.781  1.00  0.51           C 
ATOM   1990  O   GLU   124     -23.582 -10.275   2.885  1.00  2.31           O 
ATOM   1991  CB  GLU   124     -22.587  -8.789   5.036  1.00  5.20           C 
ATOM   1992  CG  GLU   124     -21.883  -8.290   6.295  1.00 51.14           C 
ATOM   1993  CD  GLU   124     -22.824  -7.630   7.286  1.00 72.34           C 
ATOM   1994  OE1 GLU   124     -23.029  -6.398   7.200  1.00 62.23           O 
ATOM   1995  OE2 GLU   124     -23.355  -8.339   8.163  1.00  1.41           O 
ATOM   1996  H   GLU   124     -19.663  -8.580   3.904  1.00 36.29           H 
ATOM   1997  HA  GLU   124     -21.120 -10.243   4.466  1.00 14.23           H 
ATOM   1998 3HB  GLU   124     -23.315  -9.534   5.324  1.00 36.29           H 
ATOM   1999 2HB  GLU   124     -23.100  -7.953   4.578  1.00 36.29           H 
ATOM   2000 3HG  GLU   124     -21.125  -7.576   6.007  1.00 36.29           H 
ATOM   2001 2HG  GLU   124     -21.410  -9.132   6.782  1.00 36.29           H 
ATOM   2002  N   GLY   125     -21.740  -9.994   1.628  1.00 34.43           N 
ATOM   2003  CA  GLY   125     -22.396 -10.443   0.395  1.00 11.53           C 
ATOM   2004  C   GLY   125     -22.812  -9.294  -0.524  1.00 42.35           C 
ATOM   2005  O   GLY   125     -23.328  -9.521  -1.623  1.00 42.41           O 
ATOM   2006  H   GLY   125     -20.786  -9.770   1.615  1.00 36.29           H 
ATOM   2007 3HA  GLY   125     -23.275 -11.017   0.655  1.00 36.29           H 
ATOM   2008 2HA  GLY   125     -21.713 -11.083  -0.142  1.00 36.29           H 
ATOM   2009  N   ARG   126     -22.592  -8.063  -0.075  1.00 45.25           N 
ATOM   2010  CA  ARG   126     -22.955  -6.864  -0.843  1.00 31.22           C 
ATOM   2011  C   ARG   126     -21.713  -6.201  -1.471  1.00 73.32           C 
ATOM   2012  O   ARG   126     -20.830  -5.721  -0.762  1.00 30.15           O 
ATOM   2013  CB  ARG   126     -23.690  -5.882   0.082  1.00 13.45           C 
ATOM   2014  CG  ARG   126     -23.968  -4.510  -0.524  1.00  1.50           C 
ATOM   2015  CD  ARG   126     -24.833  -3.664   0.403  1.00 43.53           C 
ATOM   2016  NE  ARG   126     -24.871  -2.260   0.000  1.00 73.00           N 
ATOM   2017  CZ  ARG   126     -25.952  -1.533  -0.026  1.00 54.42           C 
ATOM   2018  NH1 ARG   126     -27.111  -2.060   0.202  1.00 32.24           N 
ATOM   2019  NH2 ARG   126     -25.872  -0.275  -0.293  1.00 23.22           N 
ATOM   2020  H   ARG   126     -22.182  -7.951   0.808  1.00 36.29           H 
ATOM   2021  HA  ARG   126     -23.626  -7.166  -1.634  1.00  5.14           H 
ATOM   2022 3HB  ARG   126     -23.094  -5.741   0.974  1.00 36.29           H 
ATOM   2023 2HB  ARG   126     -24.636  -6.320   0.364  1.00 36.29           H 
ATOM   2024 3HG  ARG   126     -24.482  -4.637  -1.467  1.00 36.29           H 
ATOM   2025 2HG  ARG   126     -23.029  -4.001  -0.689  1.00 36.29           H 
ATOM   2026 3HD  ARG   126     -24.433  -3.726   1.407  1.00 36.29           H 
ATOM   2027 2HD  ARG   126     -25.839  -4.059   0.396  1.00 36.29           H 
ATOM   2028  HE  ARG   126     -24.020  -1.834  -0.220  1.00 22.03           H 
ATOM   2029 1HH1 ARG   126     -27.187  -3.034   0.399  1.00 36.29           H 
ATOM   2030 2HH1 ARG   126     -27.931  -1.491   0.180  1.00 36.29           H 
ATOM   2031 1HH2 ARG   126     -24.990   0.139  -0.486  1.00 36.29           H 
ATOM   2032 2HH2 ARG   126     -26.697   0.289  -0.284  1.00 36.29           H 
ATOM   2033  N   GLU   127     -21.651  -6.181  -2.805  1.00  3.43           N 
ATOM   2034  CA  GLU   127     -20.499  -5.610  -3.526  1.00 23.43           C 
ATOM   2035  C   GLU   127     -20.452  -4.075  -3.422  1.00 73.44           C 
ATOM   2036  O   GLU   127     -21.470  -3.395  -3.578  1.00 75.52           O 
ATOM   2037  CB  GLU   127     -20.531  -6.031  -5.005  1.00 34.52           C 
ATOM   2038  CG  GLU   127     -20.492  -7.542  -5.217  1.00 23.15           C 
ATOM   2039  CD  GLU   127     -20.491  -7.936  -6.690  1.00 21.12           C 
ATOM   2040  OE1 GLU   127     -21.513  -7.698  -7.369  1.00 32.20           O 
ATOM   2041  OE2 GLU   127     -19.483  -8.500  -7.169  1.00 20.22           O 
ATOM   2042  H   GLU   127     -22.393  -6.564  -3.321  1.00 36.29           H 
ATOM   2043  HA  GLU   127     -19.601  -6.012  -3.075  1.00 63.25           H 
ATOM   2044 3HB  GLU   127     -19.680  -5.597  -5.510  1.00 36.29           H 
ATOM   2045 2HB  GLU   127     -21.437  -5.648  -5.457  1.00 36.29           H 
ATOM   2046 3HG  GLU   127     -21.360  -7.980  -4.743  1.00 36.29           H 
ATOM   2047 2HG  GLU   127     -19.598  -7.934  -4.749  1.00 36.29           H 
ATOM   2048  N   ILE   128     -19.256  -3.544  -3.166  1.00  2.14           N 
ATOM   2049  CA  ILE   128     -19.042  -2.099  -3.017  1.00 13.41           C 
ATOM   2050  C   ILE   128     -18.389  -1.498  -4.276  1.00 60.24           C 
ATOM   2051  O   ILE   128     -17.491  -2.103  -4.868  1.00 23.33           O 
ATOM   2052  CB  ILE   128     -18.137  -1.794  -1.793  1.00 44.41           C 
ATOM   2053  CG1 ILE   128     -18.641  -2.537  -0.542  1.00 63.42           C 
ATOM   2054  CG2 ILE   128     -18.069  -0.288  -1.534  1.00 71.34           C 
ATOM   2055  CD1 ILE   128     -20.042  -2.154  -0.116  1.00 51.12           C 
ATOM   2056  H   ILE   128     -18.488  -4.144  -3.072  1.00 36.29           H 
ATOM   2057  HA  ILE   128     -20.004  -1.626  -2.858  1.00  4.01           H 
ATOM   2058  HB  ILE   128     -17.136  -2.137  -2.021  1.00 64.42           H 
ATOM   2059 3HG1 ILE   128     -17.976  -2.331   0.284  1.00 36.29           H 
ATOM   2060 2HG1 ILE   128     -18.639  -3.601  -0.738  1.00 36.29           H 
ATOM   2061 1HG2 ILE   128     -17.653   0.207  -2.400  1.00 36.29           H 
ATOM   2062 2HG2 ILE   128     -17.442  -0.095  -0.675  1.00 36.29           H 
ATOM   2063 3HG2 ILE   128     -19.063   0.093  -1.346  1.00 36.29           H 
ATOM   2064 1HD1 ILE   128     -20.324  -2.735   0.748  1.00 36.29           H 
ATOM   2065 2HD1 ILE   128     -20.732  -2.351  -0.923  1.00 36.29           H 
ATOM   2066 3HD1 ILE   128     -20.069  -1.103   0.134  1.00 36.29           H 
ATOM   2067  N   ASP   129     -18.830  -0.303  -4.667  1.00 10.23           N 
ATOM   2068  CA  ASP   129     -18.320   0.368  -5.871  1.00 53.10           C 
ATOM   2069  C   ASP   129     -16.919   0.983  -5.656  1.00 64.35           C 
ATOM   2070  O   ASP   129     -16.748   2.206  -5.689  1.00  1.51           O 
ATOM   2071  CB  ASP   129     -19.308   1.456  -6.304  1.00  2.33           C 
ATOM   2072  CG  ASP   129     -20.702   0.910  -6.541  1.00 40.11           C 
ATOM   2073  OD1 ASP   129     -21.429   0.674  -5.552  1.00 24.23           O 
ATOM   2074  OD2 ASP   129     -21.082   0.722  -7.714  1.00 21.40           O 
ATOM   2075  H   ASP   129     -19.529   0.139  -4.141  1.00 36.29           H 
ATOM   2076  HA  ASP   129     -18.255  -0.371  -6.657  1.00 22.45           H 
ATOM   2077 3HB  ASP   129     -18.956   1.911  -7.219  1.00 36.29           H 
ATOM   2078 2HB  ASP   129     -19.364   2.210  -5.531  1.00 36.29           H 
ATOM   2079  N   LEU   130     -15.920   0.130  -5.439  1.00  3.51           N 
ATOM   2080  CA  LEU   130     -14.531   0.578  -5.238  1.00 61.03           C 
ATOM   2081  C   LEU   130     -13.562  -0.220  -6.127  1.00 74.21           C 
ATOM   2082  O   LEU   130     -13.376  -1.421  -5.928  1.00 53.25           O 
ATOM   2083  CB  LEU   130     -14.124   0.427  -3.761  1.00 74.02           C 
ATOM   2084  CG  LEU   130     -14.939   1.257  -2.750  1.00 72.05           C 
ATOM   2085  CD1 LEU   130     -14.503   0.942  -1.319  1.00 35.30           C 
ATOM   2086  CD2 LEU   130     -14.803   2.753  -3.038  1.00 43.21           C 
ATOM   2087  H   LEU   130     -16.116  -0.831  -5.421  1.00 36.29           H 
ATOM   2088  HA  LEU   130     -14.471   1.622  -5.514  1.00 44.34           H 
ATOM   2089 3HB  LEU   130     -13.083   0.710  -3.666  1.00 36.29           H 
ATOM   2090 2HB  LEU   130     -14.217  -0.616  -3.494  1.00 36.29           H 
ATOM   2091  HG  LEU   130     -15.985   0.994  -2.841  1.00 12.31           H 
ATOM   2092 1HD1 LEU   130     -15.095   1.524  -0.625  1.00 36.29           H 
ATOM   2093 2HD1 LEU   130     -13.459   1.188  -1.195  1.00 36.29           H 
ATOM   2094 3HD1 LEU   130     -14.649  -0.110  -1.119  1.00 36.29           H 
ATOM   2095 1HD2 LEU   130     -15.174   2.967  -4.030  1.00 36.29           H 
ATOM   2096 2HD2 LEU   130     -13.763   3.042  -2.973  1.00 36.29           H 
ATOM   2097 3HD2 LEU   130     -15.376   3.313  -2.312  1.00 36.29           H 
ATOM   2098  N   GLY   131     -12.948   0.452  -7.101  1.00 45.24           N 
ATOM   2099  CA  GLY   131     -12.041  -0.222  -8.029  1.00 14.03           C 
ATOM   2100  C   GLY   131     -10.564   0.103  -7.802  1.00 62.02           C 
ATOM   2101  O   GLY   131      -9.718  -0.795  -7.819  1.00  1.13           O 
ATOM   2102  H   GLY   131     -13.122   1.412  -7.203  1.00 36.29           H 
ATOM   2103 3HA  GLY   131     -12.304   0.069  -9.036  1.00 36.29           H 
ATOM   2104 2HA  GLY   131     -12.175  -1.291  -7.937  1.00 36.29           H 
ATOM   2105  N   TYR   132     -10.244   1.385  -7.598  1.00 45.14           N 
ATOM   2106  CA  TYR   132      -8.845   1.811  -7.437  1.00  1.23           C 
ATOM   2107  C   TYR   132      -8.724   3.175  -6.724  1.00 64.11           C 
ATOM   2108  O   TYR   132      -8.341   3.239  -5.553  1.00 23.12           O 
ATOM   2109  CB  TYR   132      -8.156   1.872  -8.812  1.00 71.04           C 
ATOM   2110  CG  TYR   132      -6.671   2.197  -8.754  1.00  1.22           C 
ATOM   2111  CD1 TYR   132      -6.208   3.502  -8.918  1.00 24.34           C 
ATOM   2112  CD2 TYR   132      -5.730   1.194  -8.540  1.00 40.31           C 
ATOM   2113  CE1 TYR   132      -4.858   3.792  -8.869  1.00  2.13           C 
ATOM   2114  CE2 TYR   132      -4.380   1.479  -8.489  1.00 42.44           C 
ATOM   2115  CZ  TYR   132      -3.948   2.778  -8.655  1.00  3.14           C 
ATOM   2116  OH  TYR   132      -2.601   3.065  -8.606  1.00 52.01           O 
ATOM   2117  H   TYR   132     -10.961   2.053  -7.549  1.00 36.29           H 
ATOM   2118  HA  TYR   132      -8.344   1.065  -6.834  1.00 63.41           H 
ATOM   2119 3HB  TYR   132      -8.641   2.630  -9.412  1.00 36.29           H 
ATOM   2120 2HB  TYR   132      -8.266   0.914  -9.303  1.00 36.29           H 
ATOM   2121  HD1 TYR   132      -6.922   4.295  -9.085  1.00 64.32           H 
ATOM   2122  HD2 TYR   132      -6.069   0.176  -8.409  1.00 13.42           H 
ATOM   2123  HE1 TYR   132      -4.519   4.810  -8.997  1.00 20.44           H 
ATOM   2124  HE2 TYR   132      -3.666   0.684  -8.323  1.00 11.35           H 
ATOM   2125  HH  TYR   132      -2.450   3.807  -8.015  1.00  3.43           H 
ATOM   2126  N   GLY   133      -9.071   4.255  -7.436  1.00 51.33           N 
ATOM   2127  CA  GLY   133      -8.870   5.614  -6.924  1.00 13.10           C 
ATOM   2128  C   GLY   133      -9.509   5.864  -5.560  1.00 40.20           C 
ATOM   2129  O   GLY   133      -8.873   6.404  -4.657  1.00 13.21           O 
ATOM   2130  H   GLY   133      -9.477   4.130  -8.322  1.00 36.29           H 
ATOM   2131 3HA  GLY   133      -9.290   6.313  -7.635  1.00 36.29           H 
ATOM   2132 2HA  GLY   133      -7.808   5.801  -6.848  1.00 36.29           H 
ATOM   2133  N   GLU   134     -10.769   5.477  -5.411  1.00 14.42           N 
ATOM   2134  CA  GLU   134     -11.477   5.632  -4.139  1.00 14.32           C 
ATOM   2135  C   GLU   134     -11.047   4.559  -3.127  1.00 52.13           C 
ATOM   2136  O   GLU   134     -11.004   4.806  -1.924  1.00 35.42           O 
ATOM   2137  CB  GLU   134     -12.994   5.561  -4.367  1.00 42.30           C 
ATOM   2138  CG  GLU   134     -13.506   6.514  -5.445  1.00 54.42           C 
ATOM   2139  CD  GLU   134     -13.287   7.985  -5.110  1.00 32.14           C 
ATOM   2140  OE1 GLU   134     -12.181   8.506  -5.365  1.00 10.42           O 
ATOM   2141  OE2 GLU   134     -14.229   8.633  -4.613  1.00  3.31           O 
ATOM   2142  H   GLU   134     -11.236   5.078  -6.174  1.00 36.29           H 
ATOM   2143  HA  GLU   134     -11.229   6.606  -3.738  1.00 11.20           H 
ATOM   2144 3HB  GLU   134     -13.499   5.797  -3.440  1.00 36.29           H 
ATOM   2145 2HB  GLU   134     -13.256   4.553  -4.656  1.00 36.29           H 
ATOM   2146 3HG  GLU   134     -14.565   6.343  -5.580  1.00 36.29           H 
ATOM   2147 2HG  GLU   134     -12.991   6.294  -6.371  1.00 36.29           H 
ATOM   2148  N   ALA   135     -10.703   3.373  -3.630  1.00 32.24           N 
ATOM   2149  CA  ALA   135     -10.360   2.223  -2.778  1.00 13.22           C 
ATOM   2150  C   ALA   135      -9.159   2.502  -1.854  1.00 64.43           C 
ATOM   2151  O   ALA   135      -9.058   1.931  -0.768  1.00 72.22           O 
ATOM   2152  CB  ALA   135     -10.092   0.994  -3.640  1.00  0.25           C 
ATOM   2153  H   ALA   135     -10.672   3.267  -4.603  1.00 36.29           H 
ATOM   2154  HA  ALA   135     -11.223   2.006  -2.160  1.00 21.24           H 
ATOM   2155 1HB  ALA   135      -9.200   1.152  -4.231  1.00 36.29           H 
ATOM   2156 2HB  ALA   135     -10.932   0.825  -4.300  1.00 36.29           H 
ATOM   2157 3HB  ALA   135      -9.956   0.128  -3.007  1.00 36.29           H 
ATOM   2158  N   THR   136      -8.253   3.382  -2.283  1.00  1.31           N 
ATOM   2159  CA  THR   136      -7.082   3.750  -1.460  1.00 43.53           C 
ATOM   2160  C   THR   136      -7.462   4.690  -0.303  1.00 35.52           C 
ATOM   2161  O   THR   136      -6.651   4.957   0.586  1.00  1.42           O 
ATOM   2162  CB  THR   136      -5.969   4.427  -2.303  1.00  2.12           C 
ATOM   2163  OG1 THR   136      -4.807   4.668  -1.493  1.00 12.44           O 
ATOM   2164  CG2 THR   136      -6.450   5.744  -2.903  1.00 50.10           C 
ATOM   2165  H   THR   136      -8.361   3.783  -3.175  1.00 36.29           H 
ATOM   2166  HA  THR   136      -6.676   2.838  -1.042  1.00 73.22           H 
ATOM   2167  HB  THR   136      -5.698   3.759  -3.110  1.00 11.11           H 
ATOM   2168  HG1 THR   136      -5.076   5.022  -0.638  1.00 72.40           H 
ATOM   2169 1HG2 THR   136      -7.315   5.565  -3.525  1.00 36.29           H 
ATOM   2170 2HG2 THR   136      -5.662   6.178  -3.501  1.00 36.29           H 
ATOM   2171 3HG2 THR   136      -6.715   6.429  -2.109  1.00 36.29           H 
ATOM   2172  N   LYS   137      -8.693   5.194  -0.325  1.00  0.45           N 
ATOM   2173  CA  LYS   137      -9.171   6.133   0.698  1.00 32.52           C 
ATOM   2174  C   LYS   137      -9.853   5.400   1.868  1.00  3.21           C 
ATOM   2175  O   LYS   137     -10.067   5.980   2.938  1.00  4.43           O 
ATOM   2176  CB  LYS   137     -10.137   7.139   0.054  1.00 72.22           C 
ATOM   2177  CG  LYS   137      -9.533   7.870  -1.145  1.00 73.34           C 
ATOM   2178  CD  LYS   137     -10.552   8.761  -1.852  1.00 23.35           C 
ATOM   2179  CE  LYS   137      -9.944   9.465  -3.064  1.00 30.11           C 
ATOM   2180  NZ  LYS   137     -10.926  10.344  -3.752  1.00 45.11           N 
ATOM   2181  H   LYS   137      -9.299   4.933  -1.050  1.00 36.29           H 
ATOM   2182  HA  LYS   137      -8.316   6.671   1.084  1.00 52.10           H 
ATOM   2183 3HB  LYS   137     -10.423   7.874   0.792  1.00 36.29           H 
ATOM   2184 2HB  LYS   137     -11.022   6.611  -0.278  1.00 36.29           H 
ATOM   2185 3HG  LYS   137      -9.162   7.136  -1.848  1.00 36.29           H 
ATOM   2186 2HG  LYS   137      -8.712   8.485  -0.804  1.00 36.29           H 
ATOM   2187 3HD  LYS   137     -10.909   9.506  -1.155  1.00 36.29           H 
ATOM   2188 2HD  LYS   137     -11.381   8.150  -2.182  1.00 36.29           H 
ATOM   2189 3HE  LYS   137      -9.595   8.717  -3.761  1.00 36.29           H 
ATOM   2190 2HE  LYS   137      -9.108  10.067  -2.736  1.00 36.29           H 
ATOM   2191 1HZ  LYS   137     -10.459  10.867  -4.522  1.00 36.29           H 
ATOM   2192 2HZ  LYS   137     -11.333  11.027  -3.081  1.00 36.29           H 
ATOM   2193 3HZ  LYS   137     -11.695   9.771  -4.159  1.00 36.29           H 
ATOM   2194  N   ILE   138     -10.192   4.126   1.658  1.00 60.30           N 
ATOM   2195  CA  ILE   138     -10.785   3.292   2.714  1.00 62.30           C 
ATOM   2196  C   ILE   138      -9.712   2.400   3.357  1.00 50.30           C 
ATOM   2197  O   ILE   138      -9.086   1.582   2.678  1.00 52.20           O 
ATOM   2198  CB  ILE   138     -11.935   2.386   2.180  1.00 71.20           C 
ATOM   2199  CG1 ILE   138     -13.093   3.223   1.601  1.00  0.22           C 
ATOM   2200  CG2 ILE   138     -12.456   1.467   3.290  1.00 55.43           C 
ATOM   2201  CD1 ILE   138     -12.779   3.906   0.287  1.00 51.44           C 
ATOM   2202  H   ILE   138     -10.031   3.732   0.775  1.00 36.29           H 
ATOM   2203  HA  ILE   138     -11.193   3.950   3.471  1.00 42.11           H 
ATOM   2204  HB  ILE   138     -11.530   1.759   1.397  1.00 72.45           H 
ATOM   2205 3HG1 ILE   138     -13.364   3.990   2.315  1.00 36.29           H 
ATOM   2206 2HG1 ILE   138     -13.947   2.581   1.438  1.00 36.29           H 
ATOM   2207 1HG2 ILE   138     -13.269   0.864   2.909  1.00 36.29           H 
ATOM   2208 2HG2 ILE   138     -12.808   2.063   4.118  1.00 36.29           H 
ATOM   2209 3HG2 ILE   138     -11.659   0.819   3.628  1.00 36.29           H 
ATOM   2210 1HD1 ILE   138     -12.508   3.166  -0.450  1.00 36.29           H 
ATOM   2211 2HD1 ILE   138     -11.957   4.594   0.425  1.00 36.29           H 
ATOM   2212 3HD1 ILE   138     -13.648   4.450  -0.053  1.00 36.29           H 
ATOM   2213  N   TRP   139      -9.507   2.557   4.663  1.00 34.04           N 
ATOM   2214  CA  TRP   139      -8.464   1.812   5.381  1.00 62.21           C 
ATOM   2215  C   TRP   139      -9.060   0.686   6.244  1.00 73.43           C 
ATOM   2216  O   TRP   139     -10.042   0.886   6.972  1.00 54.32           O 
ATOM   2217  CB  TRP   139      -7.639   2.774   6.242  1.00 72.31           C 
ATOM   2218  CG  TRP   139      -6.849   3.766   5.435  1.00 12.05           C 
ATOM   2219  CD1 TRP   139      -7.347   4.748   4.628  1.00 14.33           C 
ATOM   2220  CD2 TRP   139      -5.420   3.875   5.361  1.00 24.53           C 
ATOM   2221  NE1 TRP   139      -6.319   5.453   4.052  1.00 52.22           N 
ATOM   2222  CE2 TRP   139      -5.129   4.938   4.487  1.00 34.30           C 
ATOM   2223  CE3 TRP   139      -4.360   3.175   5.944  1.00 50.24           C 
ATOM   2224  CZ2 TRP   139      -3.822   5.321   4.189  1.00 25.22           C 
ATOM   2225  CZ3 TRP   139      -3.064   3.555   5.648  1.00 32.41           C 
ATOM   2226  CH2 TRP   139      -2.805   4.618   4.775  1.00 30.23           C 
ATOM   2227  H   TRP   139     -10.074   3.183   5.164  1.00 36.29           H 
ATOM   2228  HA  TRP   139      -7.812   1.366   4.641  1.00 33.35           H 
ATOM   2229 3HB  TRP   139      -6.944   2.207   6.846  1.00 36.29           H 
ATOM   2230 2HB  TRP   139      -8.303   3.327   6.891  1.00 36.29           H 
ATOM   2231  HD1 TRP   139      -8.399   4.928   4.470  1.00 44.54           H 
ATOM   2232  HE1 TRP   139      -6.424   6.204   3.431  1.00 35.00           H 
ATOM   2233  HE3 TRP   139      -4.540   2.349   6.620  1.00 21.20           H 
ATOM   2234  HZ2 TRP   139      -3.605   6.140   3.518  1.00 53.50           H 
ATOM   2235  HZ3 TRP   139      -2.234   3.026   6.092  1.00 34.22           H 
ATOM   2236  HH2 TRP   139      -1.777   4.881   4.571  1.00 14.23           H 
ATOM   2237  N   VAL   140      -8.449  -0.496   6.161  1.00  0.54           N 
ATOM   2238  CA  VAL   140      -8.938  -1.696   6.851  1.00 32.24           C 
ATOM   2239  C   VAL   140      -7.802  -2.448   7.571  1.00 64.04           C 
ATOM   2240  O   VAL   140      -6.622  -2.139   7.395  1.00 32.00           O 
ATOM   2241  CB  VAL   140      -9.619  -2.665   5.851  1.00 10.53           C 
ATOM   2242  CG1 VAL   140     -10.863  -2.025   5.239  1.00 65.31           C 
ATOM   2243  CG2 VAL   140      -8.634  -3.094   4.760  1.00 12.24           C 
ATOM   2244  H   VAL   140      -7.634  -0.566   5.620  1.00 36.29           H 
ATOM   2245  HA  VAL   140      -9.673  -1.391   7.585  1.00 32.01           H 
ATOM   2246  HB  VAL   140      -9.930  -3.549   6.392  1.00  4.45           H 
ATOM   2247 1HG1 VAL   140     -10.581  -1.133   4.698  1.00 36.29           H 
ATOM   2248 2HG1 VAL   140     -11.558  -1.767   6.022  1.00 36.29           H 
ATOM   2249 3HG1 VAL   140     -11.332  -2.722   4.560  1.00 36.29           H 
ATOM   2250 1HG2 VAL   140      -9.113  -3.802   4.097  1.00 36.29           H 
ATOM   2251 2HG2 VAL   140      -7.769  -3.557   5.215  1.00 36.29           H 
ATOM   2252 3HG2 VAL   140      -8.322  -2.229   4.194  1.00 36.29           H 
ATOM   2253  N   ARG   141      -8.170  -3.442   8.383  1.00 63.11           N 
ATOM   2254  CA  ARG   141      -7.185  -4.279   9.087  1.00 51.13           C 
ATOM   2255  C   ARG   141      -7.414  -5.772   8.793  1.00 12.45           C 
ATOM   2256  O   ARG   141      -8.551  -6.218   8.640  1.00 24.20           O 
ATOM   2257  CB  ARG   141      -7.246  -4.032  10.602  1.00  0.25           C 
ATOM   2258  CG  ARG   141      -7.161  -2.558  10.991  1.00  0.14           C 
ATOM   2259  CD  ARG   141      -6.786  -2.374  12.455  1.00 54.21           C 
ATOM   2260  NE  ARG   141      -5.429  -2.848  12.727  1.00 53.01           N 
ATOM   2261  CZ  ARG   141      -4.869  -2.849  13.904  1.00 10.01           C 
ATOM   2262  NH1 ARG   141      -5.511  -2.417  14.941  1.00 24.05           N 
ATOM   2263  NH2 ARG   141      -3.659  -3.286  14.042  1.00 32.42           N 
ATOM   2264  H   ARG   141      -9.125  -3.617   8.517  1.00 36.29           H 
ATOM   2265  HA  ARG   141      -6.202  -4.006   8.728  1.00 31.52           H 
ATOM   2266 3HB  ARG   141      -6.424  -4.555  11.071  1.00 36.29           H 
ATOM   2267 2HB  ARG   141      -8.176  -4.430  10.984  1.00 36.29           H 
ATOM   2268 3HG  ARG   141      -8.121  -2.093  10.813  1.00 36.29           H 
ATOM   2269 2HG  ARG   141      -6.411  -2.078  10.380  1.00 36.29           H 
ATOM   2270 3HD  ARG   141      -7.483  -2.930  13.066  1.00 36.29           H 
ATOM   2271 2HD  ARG   141      -6.849  -1.324  12.703  1.00 36.29           H 
ATOM   2272  HE  ARG   141      -4.909  -3.187  11.973  1.00 25.03           H 
ATOM   2273 1HH1 ARG   141      -6.443  -2.080  14.848  1.00 36.29           H 
ATOM   2274 2HH1 ARG   141      -5.073  -2.433  15.838  1.00 36.29           H 
ATOM   2275 1HH2 ARG   141      -3.157  -3.623  13.247  1.00 36.29           H 
ATOM   2276 2HH2 ARG   141      -3.229  -3.293  14.942  1.00 36.29           H 
ATOM   2277  N   ARG   142      -6.328  -6.540   8.717  1.00 31.12           N 
ATOM   2278  CA  ARG   142      -6.410  -7.976   8.407  1.00 50.41           C 
ATOM   2279  C   ARG   142      -6.858  -8.784   9.639  1.00 14.23           C 
ATOM   2280  O   ARG   142      -6.099  -8.953  10.593  1.00 51.22           O 
ATOM   2281  CB  ARG   142      -5.036  -8.463   7.909  1.00  3.44           C 
ATOM   2282  CG  ARG   142      -4.971  -9.932   7.482  1.00 71.22           C 
ATOM   2283  CD  ARG   142      -5.908 -10.249   6.313  1.00 43.30           C 
ATOM   2284  NE  ARG   142      -5.277 -11.114   5.314  1.00  4.21           N 
ATOM   2285  CZ  ARG   142      -5.064 -12.395   5.460  1.00 43.14           C 
ATOM   2286  NH1 ARG   142      -5.406 -12.998   6.554  1.00 73.50           N 
ATOM   2287  NH2 ARG   142      -4.502 -13.067   4.507  1.00 15.44           N 
ATOM   2288  H   ARG   142      -5.449  -6.137   8.876  1.00 36.29           H 
ATOM   2289  HA  ARG   142      -7.136  -8.106   7.617  1.00 11.02           H 
ATOM   2290 3HB  ARG   142      -4.314  -8.313   8.699  1.00 36.29           H 
ATOM   2291 2HB  ARG   142      -4.746  -7.861   7.062  1.00 36.29           H 
ATOM   2292 3HG  ARG   142      -5.242 -10.551   8.327  1.00 36.29           H 
ATOM   2293 2HG  ARG   142      -3.957 -10.159   7.187  1.00 36.29           H 
ATOM   2294 3HD  ARG   142      -6.198  -9.323   5.835  1.00 36.29           H 
ATOM   2295 2HD  ARG   142      -6.790 -10.742   6.697  1.00 36.29           H 
ATOM   2296  HE  ARG   142      -5.003 -10.702   4.473  1.00 13.45           H 
ATOM   2297 1HH1 ARG   142      -5.836 -12.489   7.285  1.00 36.29           H 
ATOM   2298 2HH1 ARG   142      -5.224 -13.976   6.661  1.00 36.29           H 
ATOM   2299 1HH2 ARG   142      -4.233 -12.602   3.661  1.00 36.29           H 
ATOM   2300 2HH2 ARG   142      -4.336 -14.043   4.613  1.00 36.29           H 
ATOM   2301  N   VAL   143      -8.093  -9.288   9.607  1.00 22.51           N 
ATOM   2302  CA  VAL   143      -8.649 -10.049  10.739  1.00 13.35           C 
ATOM   2303  C   VAL   143      -8.612 -11.568  10.496  1.00 21.13           C 
ATOM   2304  O   VAL   143      -8.180 -12.329  11.365  1.00 62.05           O 
ATOM   2305  CB  VAL   143     -10.104  -9.615  11.064  1.00 33.44           C 
ATOM   2306  CG1 VAL   143     -10.136  -8.189  11.600  1.00  3.53           C 
ATOM   2307  CG2 VAL   143     -11.010  -9.743   9.841  1.00 65.43           C 
ATOM   2308  H   VAL   143      -8.652  -9.131   8.816  1.00 36.29           H 
ATOM   2309  HA  VAL   143      -8.039  -9.831  11.608  1.00 35.11           H 
ATOM   2310  HB  VAL   143     -10.487 -10.271  11.836  1.00 21.23           H 
ATOM   2311 1HG1 VAL   143      -9.552  -8.129  12.505  1.00 36.29           H 
ATOM   2312 2HG1 VAL   143     -11.158  -7.908  11.812  1.00 36.29           H 
ATOM   2313 3HG1 VAL   143      -9.726  -7.516  10.859  1.00 36.29           H 
ATOM   2314 1HG2 VAL   143     -10.646  -9.098   9.053  1.00 36.29           H 
ATOM   2315 2HG2 VAL   143     -12.017  -9.455  10.104  1.00 36.29           H 
ATOM   2316 3HG2 VAL   143     -11.011 -10.768   9.497  1.00 36.29           H 
END
