
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   64 ( 1024),  selected   64 , name 2juf_A
# Molecule2: number of CA atoms   74 ( 1189),  selected   74 , name T0462_1_74.pdb
# PARAMETERS: 2juf_A.T0462_1_74.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y    14_A      M       1           -
LGA    G    15_A      -       -           -
LGA    E    16_A      -       -           -
LGA    Y    17_A      K       2           #
LGA    V    18_A      L       3          5.078
LGA    Q    19_A      S       4          3.976
LGA    Q    20_A      -       -           -
LGA    T    21_A      R       5          4.043
LGA    L    22_A      L       6          1.611
LGA    Q    23_A      V       7          0.830
LGA    P    24_A      P       8          1.741
LGA    G    25_A      G       9          0.956
LGA    M    26_A      V      10          1.453
LGA    R    27_A      P      11          2.140
LGA    V    28_A      A      12          3.569
LGA    -       -      R      13           -
LGA    R    29_A      I      14          3.060
LGA    -       -      K      15           -
LGA    M    30_A      R      16           #
LGA    L    31_A      L      17          2.607
LGA    -       -      E      18           -
LGA    -       -      V      19           -
LGA    -       -      S      20           -
LGA    -       -      G      21           -
LGA    -       -      E      22           -
LGA    -       -      L      23           -
LGA    D    32_A      H      24          3.954
LGA    D    33_A      E      25          4.019
LGA    Y    34_A      K      26          3.281
LGA    -       -      L      27           -
LGA    -       -      V      28           -
LGA    E    35_A      G      29          3.646
LGA    E    36_A      M      30          2.462
LGA    I    37_A      G      31          1.273
LGA    S    38_A      F      32          3.432
LGA    A    39_A      V      33          2.964
LGA    G    40_A      P      34          1.834
LGA    -       -      G      35           -
LGA    D    41_A      E      36          3.097
LGA    E    42_A      E      37          2.939
LGA    G    43_A      I      38          1.177
LGA    E    44_A      E      39          0.580
LGA    F    45_A      I      40          0.878
LGA    R    46_A      V      41          0.662
LGA    Q    47_A      Q      42          0.658
LGA    S    48_A      V      43          0.878
LGA    N    49_A      A      44          0.854
LGA    N    50_A      P      45          3.040
LGA    G    51_A      L      46          2.112
LGA    I    52_A      G      47          5.086
LGA    P    53_A      D      48          2.202
LGA    P    54_A      P      49          1.855
LGA    V    55_A      I      50          0.812
LGA    Q    56_A      V      51          0.777
LGA    V    57_A      C      52          0.593
LGA    F    58_A      K      53          0.774
LGA    W    59_A      I      54          0.316
LGA    Q    60_A      G      55          1.943
LGA    S    61_A      -       -           -
LGA    T    62_A      -       -           -
LGA    G    63_A      N      56          2.571
LGA    R    64_A      R      57          0.417
LGA    T    65_A      N      58          0.696
LGA    Y    66_A      I      59          0.962
LGA    W    67_A      T      60          0.401
LGA    V    68_A      L      61          1.035
LGA    H    69_A      R      62          1.831
LGA    W    70_A      K      63          2.205
LGA    H    71_A      R      64          3.448
LGA    M    72_A      E      65          2.809
LGA    L    73_A      A      66          2.554
LGA    -       -      D      67           -
LGA    -       -      L      68           -
LGA    -       -      I      69           -
LGA    E    74_A      E      70          3.264
LGA    I    75_A      V      71          2.497
LGA    L    76_A      E      72          1.368
LGA    G    77_A      V      73          1.990
LGA    -       -      V      74           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   64   74    5.0     56    2.43    17.86     55.034     2.209

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.117608 * X  +  -0.865942 * Y  +   0.486119 * Z  +  11.012749
  Y_new =   0.852633 * X  +  -0.162904 * Y  +  -0.496467 * Z  +   1.408528
  Z_new =   0.509103 * X  +   0.472870 * Y  +   0.719172 * Z  +  -2.223414 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.581643   -2.559949  [ DEG:    33.3257   -146.6743 ]
  Theta =  -0.534142   -2.607451  [ DEG:   -30.6041   -149.3959 ]
  Phi   =   1.433726   -1.707867  [ DEG:    82.1464    -97.8536 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2juf_A                                        
REMARK     2: T0462_1_74.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2juf_A.T0462_1_74.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   64   74   5.0   56   2.43   17.86  55.034
REMARK  ---------------------------------------------------------- 
MOLECULE 2juf_A
HEADER    GENE REGULATION                         23-AUG-07   2JUF              
TITLE     NMR SOLUTION STRUCTURE OF PARC CPH DOMAIN. NESG TARGET                
TITLE    2 HR3443B/SGC-TORONTO                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P53-ASSOCIATED PARKIN-LIKE CYTOPLASMIC PROTEIN;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CPH DOMAIN: RESIDUES 366-466;                              
COMPND   5 SYNONYM: UBCH7-ASSOCIATED PROTEIN 1;                                 
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PARC, H7AP1, KIAA0708;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    CPH DOMAIN, STRUCTURAL GENOMICS CONSORTIUM, SGC, NORTHEAST            
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, NESG, ALTERNATIVE SPLICING,          
KEYWDS   3 ATP-BINDING, COILED COIL, CYTOPLASM, METAL-BINDING,                  
KEYWDS   4 NUCLEOTIDE-BINDING, UBL CONJUGATION, UBL CONJUGATION                 
KEYWDS   5 PATHWAY, ZINC, ZINC-FINGER, PSI-2, PROTEIN STRUCTURE                 
KEYWDS   6 INITIATIVE, GENE REGULATION                                          
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    L.KAUSTOV,J.C.C.LIAO,S.LEMAK,S.DUAN,R.MUHANDIRAM,M.KARRA,             
AUTHOR   2 S.H.SRISAILAM,M.SUNDSTROM,J.WEIGELT,A.M.EDWARDS,S.DHE-               
AUTHOR   3 PAGANON,C.H.ARROWSMITH,STRUCTURAL GENOMICS CONSORTIUM (SGC),         
AUTHOR   4 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   1   16-OCT-07 2JUF    0                                                
JRNL        AUTH   L.KAUSTOV,J.C.C.LIAO,S.LEMAK,S.DUAN,R.MUHANDIRAM,            
JRNL        AUTH 2 M.KARRA,S.H.SRISAILAM,M.SUNDSTROM,J.WEIGELT,                 
JRNL        AUTH 3 A.M.EDWARDS,S.DHE-PAGANON,C.H.ARROWSMITH                     
JRNL        TITL   NMR SOLUTION STRUCTURE OF PARC CPH DOMAIN.                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JUF A    5   105  UNP    Q8IWT3   PARC_HUMAN     366    466             
SEQRES   1 A  105  GLY SER HIS MET ARG SER GLU PHE SER SER ARG GLY GLY          
SEQRES   2 A  105  TYR GLY GLU TYR VAL GLN GLN THR LEU GLN PRO GLY MET          
SEQRES   3 A  105  ARG VAL ARG MET LEU ASP ASP TYR GLU GLU ILE SER ALA          
SEQRES   4 A  105  GLY ASP GLU GLY GLU PHE ARG GLN SER ASN ASN GLY ILE          
SEQRES   5 A  105  PRO PRO VAL GLN VAL PHE TRP GLN SER THR GLY ARG THR          
SEQRES   6 A  105  TYR TRP VAL HIS TRP HIS MET LEU GLU ILE LEU GLY PRO          
SEQRES   7 A  105  GLU GLU ALA THR GLU ASP LYS ALA SER ALA ALA VAL GLU          
SEQRES   8 A  105  LYS GLY ALA GLY ALA THR VAL LEU GLY THR ALA PHE PRO          
SEQRES   9 A  105  SER                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   TYR A  14       3.558  -7.723 -10.065  1.00  0.00           N  
ATOM      2  CA  TYR A  14       3.562  -7.336  -8.641  1.00  0.00           C  
ATOM      3  C   TYR A  14       3.833  -5.822  -8.496  1.00  0.00           C  
ATOM      4  O   TYR A  14       3.342  -5.175  -7.559  1.00  0.00           O  
ATOM      5  CB  TYR A  14       4.631  -8.164  -7.876  1.00  0.00           C  
ATOM      6  CG  TYR A  14       4.735  -7.824  -6.377  1.00  0.00           C  
ATOM      7  CD1 TYR A  14       3.713  -8.181  -5.493  1.00  0.00           C  
ATOM      8  CD2 TYR A  14       5.831  -7.119  -5.853  1.00  0.00           C  
ATOM      9  CE1 TYR A  14       3.772  -7.848  -4.158  1.00  0.00           C  
ATOM     10  CE2 TYR A  14       5.894  -6.792  -4.510  1.00  0.00           C  
ATOM     11  CZ  TYR A  14       4.859  -7.158  -3.669  1.00  0.00           C  
ATOM     12  OH  TYR A  14       4.897  -6.819  -2.335  1.00  0.00           O  
ATOM     13  H   TYR A  14       4.288  -8.281 -10.394  1.00  0.00           H  
ATOM     14  HA  TYR A  14       2.579  -7.560  -8.232  1.00  0.00           H  
ATOM     15  HB2 TYR A  14       4.385  -9.217  -7.963  1.00  0.00           H  
ATOM     16  HB3 TYR A  14       5.602  -7.999  -8.337  1.00  0.00           H  
ATOM     17  HD1 TYR A  14       2.855  -8.729  -5.870  1.00  0.00           H  
ATOM     18  HD2 TYR A  14       6.640  -6.831  -6.514  1.00  0.00           H  
ATOM     19  HE1 TYR A  14       2.964  -8.135  -3.497  1.00  0.00           H  
ATOM     20  HE2 TYR A  14       6.751  -6.248  -4.124  1.00  0.00           H  
ATOM     21  HH  TYR A  14       4.703  -7.598  -1.801  1.00  0.00           H  
ATOM     22  N   GLY A  15       4.613  -5.288  -9.456  1.00  0.00           N  
ATOM     23  CA  GLY A  15       4.932  -3.866  -9.519  1.00  0.00           C  
ATOM     24  C   GLY A  15       3.706  -2.992  -9.718  1.00  0.00           C  
ATOM     25  O   GLY A  15       3.659  -1.867  -9.218  1.00  0.00           O  
ATOM     26  H   GLY A  15       4.971  -5.881 -10.147  1.00  0.00           H  
ATOM     27  HA2 GLY A  15       5.432  -3.576  -8.601  1.00  0.00           H  
ATOM     28  HA3 GLY A  15       5.609  -3.702 -10.344  1.00  0.00           H  
ATOM     29  N   GLU A  16       2.716  -3.526 -10.452  1.00  0.00           N  
ATOM     30  CA  GLU A  16       1.413  -2.874 -10.635  1.00  0.00           C  
ATOM     31  C   GLU A  16       0.693  -2.738  -9.288  1.00  0.00           C  
ATOM     32  O   GLU A  16       0.259  -1.642  -8.931  1.00  0.00           O  
ATOM     33  CB  GLU A  16       0.547  -3.697 -11.610  1.00  0.00           C  
ATOM     34  CG  GLU A  16      -0.850  -3.113 -11.907  1.00  0.00           C  
ATOM     35  CD  GLU A  16      -1.691  -4.019 -12.822  1.00  0.00           C  
ATOM     36  OE1 GLU A  16      -2.350  -4.955 -12.311  1.00  0.00           O  
ATOM     37  OE2 GLU A  16      -1.690  -3.813 -14.056  1.00  0.00           O  
ATOM     38  H   GLU A  16       2.873  -4.390 -10.889  1.00  0.00           H  
ATOM     39  HA  GLU A  16       1.583  -1.887 -11.059  1.00  0.00           H  
ATOM     40  HB2 GLU A  16       1.085  -3.779 -12.548  1.00  0.00           H  
ATOM     41  HB3 GLU A  16       0.420  -4.700 -11.202  1.00  0.00           H  
ATOM     42  HG2 GLU A  16      -1.380  -2.974 -10.966  1.00  0.00           H  
ATOM     43  HG3 GLU A  16      -0.728  -2.142 -12.382  1.00  0.00           H  
ATOM     44  N   TYR A  17       0.640  -3.861  -8.526  1.00  0.00           N  
ATOM     45  CA  TYR A  17      -0.075  -3.929  -7.236  1.00  0.00           C  
ATOM     46  C   TYR A  17       0.459  -2.872  -6.258  1.00  0.00           C  
ATOM     47  O   TYR A  17      -0.324  -2.088  -5.703  1.00  0.00           O  
ATOM     48  CB  TYR A  17       0.051  -5.362  -6.608  1.00  0.00           C  
ATOM     49  CG  TYR A  17      -0.152  -5.409  -5.074  1.00  0.00           C  
ATOM     50  CD1 TYR A  17      -1.399  -5.156  -4.492  1.00  0.00           C  
ATOM     51  CD2 TYR A  17       0.926  -5.650  -4.212  1.00  0.00           C  
ATOM     52  CE1 TYR A  17      -1.559  -5.151  -3.118  1.00  0.00           C  
ATOM     53  CE2 TYR A  17       0.769  -5.635  -2.840  1.00  0.00           C  
ATOM     54  CZ  TYR A  17      -0.474  -5.387  -2.298  1.00  0.00           C  
ATOM     55  OH  TYR A  17      -0.630  -5.354  -0.931  1.00  0.00           O  
ATOM     56  H   TYR A  17       1.108  -4.662  -8.843  1.00  0.00           H  
ATOM     57  HA  TYR A  17      -1.124  -3.726  -7.430  1.00  0.00           H  
ATOM     58  HB2 TYR A  17      -0.687  -6.013  -7.057  1.00  0.00           H  
ATOM     59  HB3 TYR A  17       1.037  -5.757  -6.829  1.00  0.00           H  
ATOM     60  HD1 TYR A  17      -2.251  -4.968  -5.131  1.00  0.00           H  
ATOM     61  HD2 TYR A  17       1.904  -5.849  -4.635  1.00  0.00           H  
ATOM     62  HE1 TYR A  17      -2.533  -4.956  -2.694  1.00  0.00           H  
ATOM     63  HE2 TYR A  17       1.624  -5.823  -2.198  1.00  0.00           H  
ATOM     64  HH  TYR A  17       0.078  -4.827  -0.542  1.00  0.00           H  
ATOM     65  N   VAL A  18       1.794  -2.830  -6.094  1.00  0.00           N  
ATOM     66  CA  VAL A  18       2.428  -1.912  -5.144  1.00  0.00           C  
ATOM     67  C   VAL A  18       2.260  -0.455  -5.604  1.00  0.00           C  
ATOM     68  O   VAL A  18       1.960   0.412  -4.792  1.00  0.00           O  
ATOM     69  CB  VAL A  18       3.936  -2.261  -4.856  1.00  0.00           C  
ATOM     70  CG1 VAL A  18       4.062  -3.618  -4.130  1.00  0.00           C  
ATOM     71  CG2 VAL A  18       4.783  -2.237  -6.137  1.00  0.00           C  
ATOM     72  H   VAL A  18       2.359  -3.433  -6.629  1.00  0.00           H  
ATOM     73  HA  VAL A  18       1.886  -2.019  -4.201  1.00  0.00           H  
ATOM     74  HB  VAL A  18       4.331  -1.499  -4.183  1.00  0.00           H  
ATOM     75 HG11 VAL A  18       3.657  -4.408  -4.755  1.00  0.00           H  
ATOM     76 HG12 VAL A  18       3.515  -3.590  -3.195  1.00  0.00           H  
ATOM     77 HG13 VAL A  18       5.105  -3.828  -3.923  1.00  0.00           H  
ATOM     78 HG21 VAL A  18       5.816  -2.470  -5.903  1.00  0.00           H  
ATOM     79 HG22 VAL A  18       4.736  -1.252  -6.590  1.00  0.00           H  
ATOM     80 HG23 VAL A  18       4.405  -2.968  -6.840  1.00  0.00           H  
ATOM     81  N   GLN A  19       2.372  -0.215  -6.926  1.00  0.00           N  
ATOM     82  CA  GLN A  19       2.186   1.125  -7.523  1.00  0.00           C  
ATOM     83  C   GLN A  19       0.796   1.715  -7.183  1.00  0.00           C  
ATOM     84  O   GLN A  19       0.642   2.938  -7.041  1.00  0.00           O  
ATOM     85  CB  GLN A  19       2.383   1.058  -9.061  1.00  0.00           C  
ATOM     86  CG  GLN A  19       2.283   2.420  -9.775  1.00  0.00           C  
ATOM     87  CD  GLN A  19       2.354   2.340 -11.302  1.00  0.00           C  
ATOM     88  OE1 GLN A  19       3.034   1.482 -11.872  1.00  0.00           O  
ATOM     89  NE2 GLN A  19       1.631   3.228 -11.971  1.00  0.00           N  
ATOM     90  H   GLN A  19       2.588  -0.964  -7.522  1.00  0.00           H  
ATOM     91  HA  GLN A  19       2.950   1.776  -7.103  1.00  0.00           H  
ATOM     92  HB2 GLN A  19       3.364   0.639  -9.266  1.00  0.00           H  
ATOM     93  HB3 GLN A  19       1.632   0.393  -9.482  1.00  0.00           H  
ATOM     94  HG2 GLN A  19       1.342   2.884  -9.500  1.00  0.00           H  
ATOM     95  HG3 GLN A  19       3.096   3.050  -9.429  1.00  0.00           H  
ATOM     96 HE21 GLN A  19       1.095   3.874 -11.456  1.00  0.00           H  
ATOM     97 HE22 GLN A  19       1.659   3.201 -12.950  1.00  0.00           H  
ATOM     98  N   GLN A  20      -0.206   0.828  -7.029  1.00  0.00           N  
ATOM     99  CA  GLN A  20      -1.595   1.237  -6.764  1.00  0.00           C  
ATOM    100  C   GLN A  20      -1.812   1.541  -5.266  1.00  0.00           C  
ATOM    101  O   GLN A  20      -2.509   2.500  -4.918  1.00  0.00           O  
ATOM    102  CB  GLN A  20      -2.600   0.137  -7.216  1.00  0.00           C  
ATOM    103  CG  GLN A  20      -2.528  -0.274  -8.704  1.00  0.00           C  
ATOM    104  CD  GLN A  20      -2.555   0.905  -9.678  1.00  0.00           C  
ATOM    105  OE1 GLN A  20      -3.622   1.364 -10.085  1.00  0.00           O  
ATOM    106  NE2 GLN A  20      -1.382   1.392 -10.074  1.00  0.00           N  
ATOM    107  H   GLN A  20       0.005  -0.132  -7.068  1.00  0.00           H  
ATOM    108  HA  GLN A  20      -1.790   2.142  -7.341  1.00  0.00           H  
ATOM    109  HB2 GLN A  20      -2.425  -0.753  -6.620  1.00  0.00           H  
ATOM    110  HB3 GLN A  20      -3.609   0.485  -7.014  1.00  0.00           H  
ATOM    111  HG2 GLN A  20      -1.617  -0.833  -8.867  1.00  0.00           H  
ATOM    112  HG3 GLN A  20      -3.370  -0.922  -8.925  1.00  0.00           H  
ATOM    113 HE21 GLN A  20      -0.567   0.972  -9.726  1.00  0.00           H  
ATOM    114 HE22 GLN A  20      -1.379   2.150 -10.699  1.00  0.00           H  
ATOM    115  N   THR A  21      -1.216   0.710  -4.386  1.00  0.00           N  
ATOM    116  CA  THR A  21      -1.519   0.720  -2.931  1.00  0.00           C  
ATOM    117  C   THR A  21      -0.459   1.476  -2.085  1.00  0.00           C  
ATOM    118  O   THR A  21      -0.653   1.650  -0.876  1.00  0.00           O  
ATOM    119  CB  THR A  21      -1.692  -0.751  -2.410  1.00  0.00           C  
ATOM    120  OG1 THR A  21      -2.114  -0.766  -1.032  1.00  0.00           O  
ATOM    121  CG2 THR A  21      -0.402  -1.569  -2.558  1.00  0.00           C  
ATOM    122  H   THR A  21      -0.561   0.058  -4.724  1.00  0.00           H  
ATOM    123  HA  THR A  21      -2.475   1.223  -2.792  1.00  0.00           H  
ATOM    124  HB  THR A  21      -2.467  -1.231  -3.001  1.00  0.00           H  
ATOM    125  HG1 THR A  21      -1.488  -0.270  -0.494  1.00  0.00           H  
ATOM    126 HG21 THR A  21       0.390  -1.115  -1.976  1.00  0.00           H  
ATOM    127 HG22 THR A  21      -0.105  -1.602  -3.597  1.00  0.00           H  
ATOM    128 HG23 THR A  21      -0.566  -2.580  -2.205  1.00  0.00           H  
ATOM    129  N   LEU A  22       0.653   1.921  -2.707  1.00  0.00           N  
ATOM    130  CA  LEU A  22       1.731   2.647  -1.986  1.00  0.00           C  
ATOM    131  C   LEU A  22       1.248   4.052  -1.557  1.00  0.00           C  
ATOM    132  O   LEU A  22       1.085   4.950  -2.391  1.00  0.00           O  
ATOM    133  CB  LEU A  22       3.052   2.724  -2.839  1.00  0.00           C  
ATOM    134  CG  LEU A  22       4.244   1.831  -2.350  1.00  0.00           C  
ATOM    135  CD1 LEU A  22       4.710   2.225  -0.944  1.00  0.00           C  
ATOM    136  CD2 LEU A  22       3.890   0.341  -2.392  1.00  0.00           C  
ATOM    137  H   LEU A  22       0.750   1.767  -3.668  1.00  0.00           H  
ATOM    138  HA  LEU A  22       1.942   2.073  -1.083  1.00  0.00           H  
ATOM    139  HB2 LEU A  22       2.818   2.437  -3.861  1.00  0.00           H  
ATOM    140  HB3 LEU A  22       3.402   3.752  -2.866  1.00  0.00           H  
ATOM    141  HG  LEU A  22       5.086   1.981  -3.016  1.00  0.00           H  
ATOM    142 HD11 LEU A  22       5.566   1.627  -0.665  1.00  0.00           H  
ATOM    143 HD12 LEU A  22       3.915   2.060  -0.228  1.00  0.00           H  
ATOM    144 HD13 LEU A  22       4.988   3.268  -0.930  1.00  0.00           H  
ATOM    145 HD21 LEU A  22       4.736  -0.247  -2.059  1.00  0.00           H  
ATOM    146 HD22 LEU A  22       3.647   0.062  -3.405  1.00  0.00           H  
ATOM    147 HD23 LEU A  22       3.039   0.138  -1.753  1.00  0.00           H  
ATOM    148  N   GLN A  23       1.022   4.210  -0.243  1.00  0.00           N  
ATOM    149  CA  GLN A  23       0.517   5.452   0.364  1.00  0.00           C  
ATOM    150  C   GLN A  23       1.685   6.400   0.707  1.00  0.00           C  
ATOM    151  O   GLN A  23       2.753   5.921   1.106  1.00  0.00           O  
ATOM    152  CB  GLN A  23      -0.287   5.135   1.652  1.00  0.00           C  
ATOM    153  CG  GLN A  23      -1.513   4.231   1.439  1.00  0.00           C  
ATOM    154  CD  GLN A  23      -2.300   4.001   2.729  1.00  0.00           C  
ATOM    155  OE1 GLN A  23      -2.030   3.066   3.479  1.00  0.00           O  
ATOM    156  NE2 GLN A  23      -3.264   4.863   3.001  1.00  0.00           N  
ATOM    157  H   GLN A  23       1.212   3.454   0.346  1.00  0.00           H  
ATOM    158  HA  GLN A  23      -0.140   5.939  -0.352  1.00  0.00           H  
ATOM    159  HB2 GLN A  23       0.376   4.639   2.360  1.00  0.00           H  
ATOM    160  HB3 GLN A  23      -0.624   6.070   2.092  1.00  0.00           H  
ATOM    161  HG2 GLN A  23      -2.168   4.683   0.702  1.00  0.00           H  
ATOM    162  HG3 GLN A  23      -1.174   3.270   1.064  1.00  0.00           H  
ATOM    163 HE21 GLN A  23      -3.421   5.594   2.370  1.00  0.00           H  
ATOM    164 HE22 GLN A  23      -3.786   4.733   3.820  1.00  0.00           H  
ATOM    165  N   PRO A  24       1.500   7.752   0.524  1.00  0.00           N  
ATOM    166  CA  PRO A  24       2.515   8.776   0.885  1.00  0.00           C  
ATOM    167  C   PRO A  24       2.904   8.780   2.388  1.00  0.00           C  
ATOM    168  O   PRO A  24       2.398   9.593   3.164  1.00  0.00           O  
ATOM    169  CB  PRO A  24       1.857  10.118   0.439  1.00  0.00           C  
ATOM    170  CG  PRO A  24       0.838   9.715  -0.581  1.00  0.00           C  
ATOM    171  CD  PRO A  24       0.305   8.388  -0.104  1.00  0.00           C  
ATOM    172  HA  PRO A  24       3.416   8.625   0.309  1.00  0.00           H  
ATOM    173  HB2 PRO A  24       1.393  10.616   1.290  1.00  0.00           H  
ATOM    174  HB3 PRO A  24       2.607  10.774   0.011  1.00  0.00           H  
ATOM    175  HG2 PRO A  24       0.046  10.454  -0.633  1.00  0.00           H  
ATOM    176  HG3 PRO A  24       1.307   9.606  -1.555  1.00  0.00           H  
ATOM    177  HD2 PRO A  24      -0.491   8.524   0.624  1.00  0.00           H  
ATOM    178  HD3 PRO A  24      -0.055   7.802  -0.944  1.00  0.00           H  
ATOM    179  N   GLY A  25       3.778   7.830   2.795  1.00  0.00           N  
ATOM    180  CA  GLY A  25       4.340   7.804   4.149  1.00  0.00           C  
ATOM    181  C   GLY A  25       4.249   6.436   4.805  1.00  0.00           C  
ATOM    182  O   GLY A  25       4.345   6.341   6.034  1.00  0.00           O  
ATOM    183  H   GLY A  25       4.026   7.110   2.173  1.00  0.00           H  
ATOM    184  HA2 GLY A  25       5.384   8.084   4.089  1.00  0.00           H  
ATOM    185  HA3 GLY A  25       3.826   8.528   4.782  1.00  0.00           H  
ATOM    186  N   MET A  26       4.067   5.364   4.001  1.00  0.00           N  
ATOM    187  CA  MET A  26       3.970   3.983   4.537  1.00  0.00           C  
ATOM    188  C   MET A  26       5.343   3.290   4.518  1.00  0.00           C  
ATOM    189  O   MET A  26       6.309   3.813   3.969  1.00  0.00           O  
ATOM    190  CB  MET A  26       2.922   3.117   3.770  1.00  0.00           C  
ATOM    191  CG  MET A  26       3.239   2.850   2.291  1.00  0.00           C  
ATOM    192  SD  MET A  26       2.568   1.274   1.693  1.00  0.00           S  
ATOM    193  CE  MET A  26       0.837   1.360   2.147  1.00  0.00           C  
ATOM    194  H   MET A  26       4.017   5.501   3.035  1.00  0.00           H  
ATOM    195  HA  MET A  26       3.653   4.055   5.575  1.00  0.00           H  
ATOM    196  HB2 MET A  26       2.839   2.158   4.271  1.00  0.00           H  
ATOM    197  HB3 MET A  26       1.954   3.609   3.827  1.00  0.00           H  
ATOM    198  HG2 MET A  26       2.826   3.648   1.689  1.00  0.00           H  
ATOM    199  HG3 MET A  26       4.316   2.830   2.153  1.00  0.00           H  
ATOM    200  HE1 MET A  26       0.339   0.455   1.836  1.00  0.00           H  
ATOM    201  HE2 MET A  26       0.381   2.208   1.658  1.00  0.00           H  
ATOM    202  HE3 MET A  26       0.744   1.470   3.220  1.00  0.00           H  
ATOM    203  N   ARG A  27       5.380   2.082   5.083  1.00  0.00           N  
ATOM    204  CA  ARG A  27       6.606   1.312   5.333  1.00  0.00           C  
ATOM    205  C   ARG A  27       6.807   0.308   4.191  1.00  0.00           C  
ATOM    206  O   ARG A  27       5.901  -0.477   3.876  1.00  0.00           O  
ATOM    207  CB  ARG A  27       6.469   0.592   6.700  1.00  0.00           C  
ATOM    208  CG  ARG A  27       7.636  -0.332   7.126  1.00  0.00           C  
ATOM    209  CD  ARG A  27       8.948   0.422   7.397  1.00  0.00           C  
ATOM    210  NE  ARG A  27       9.916  -0.414   8.131  1.00  0.00           N  
ATOM    211  CZ  ARG A  27      11.064   0.012   8.672  1.00  0.00           C  
ATOM    212  NH1 ARG A  27      11.467   1.268   8.531  1.00  0.00           N  
ATOM    213  NH2 ARG A  27      11.815  -0.845   9.348  1.00  0.00           N  
ATOM    214  H   ARG A  27       4.532   1.666   5.307  1.00  0.00           H  
ATOM    215  HA  ARG A  27       7.450   1.997   5.373  1.00  0.00           H  
ATOM    216  HB2 ARG A  27       6.348   1.348   7.469  1.00  0.00           H  
ATOM    217  HB3 ARG A  27       5.565  -0.003   6.679  1.00  0.00           H  
ATOM    218  HG2 ARG A  27       7.348  -0.858   8.030  1.00  0.00           H  
ATOM    219  HG3 ARG A  27       7.806  -1.061   6.340  1.00  0.00           H  
ATOM    220  HD2 ARG A  27       9.383   0.715   6.449  1.00  0.00           H  
ATOM    221  HD3 ARG A  27       8.734   1.310   7.982  1.00  0.00           H  
ATOM    222  HE  ARG A  27       9.684  -1.362   8.231  1.00  0.00           H  
ATOM    223 HH11 ARG A  27      10.911   1.920   8.006  1.00  0.00           H  
ATOM    224 HH12 ARG A  27      12.329   1.572   8.945  1.00  0.00           H  
ATOM    225 HH21 ARG A  27      11.525  -1.799   9.448  1.00  0.00           H  
ATOM    226 HH22 ARG A  27      12.687  -0.547   9.747  1.00  0.00           H  
ATOM    227  N   VAL A  28       8.003   0.338   3.582  1.00  0.00           N  
ATOM    228  CA  VAL A  28       8.334  -0.464   2.394  1.00  0.00           C  
ATOM    229  C   VAL A  28       9.455  -1.469   2.733  1.00  0.00           C  
ATOM    230  O   VAL A  28      10.030  -1.426   3.823  1.00  0.00           O  
ATOM    231  CB  VAL A  28       8.748   0.441   1.167  1.00  0.00           C  
ATOM    232  CG1 VAL A  28       7.716   1.568   0.924  1.00  0.00           C  
ATOM    233  CG2 VAL A  28      10.178   1.021   1.312  1.00  0.00           C  
ATOM    234  H   VAL A  28       8.696   0.923   3.951  1.00  0.00           H  
ATOM    235  HA  VAL A  28       7.447  -1.033   2.112  1.00  0.00           H  
ATOM    236  HB  VAL A  28       8.743  -0.196   0.277  1.00  0.00           H  
ATOM    237 HG11 VAL A  28       8.006   2.157   0.060  1.00  0.00           H  
ATOM    238 HG12 VAL A  28       7.668   2.214   1.792  1.00  0.00           H  
ATOM    239 HG13 VAL A  28       6.738   1.138   0.746  1.00  0.00           H  
ATOM    240 HG21 VAL A  28      10.435   1.599   0.432  1.00  0.00           H  
ATOM    241 HG22 VAL A  28      10.893   0.212   1.424  1.00  0.00           H  
ATOM    242 HG23 VAL A  28      10.226   1.657   2.182  1.00  0.00           H  
ATOM    243  N   ARG A  29       9.737  -2.361   1.788  1.00  0.00           N  
ATOM    244  CA  ARG A  29      10.651  -3.502   1.945  1.00  0.00           C  
ATOM    245  C   ARG A  29      11.384  -3.722   0.609  1.00  0.00           C  
ATOM    246  O   ARG A  29      10.792  -3.568  -0.459  1.00  0.00           O  
ATOM    247  CB  ARG A  29       9.835  -4.769   2.330  1.00  0.00           C  
ATOM    248  CG  ARG A  29      10.662  -6.063   2.537  1.00  0.00           C  
ATOM    249  CD  ARG A  29      11.539  -6.037   3.800  1.00  0.00           C  
ATOM    250  NE  ARG A  29      12.118  -7.367   4.106  1.00  0.00           N  
ATOM    251  CZ  ARG A  29      12.445  -7.812   5.338  1.00  0.00           C  
ATOM    252  NH1 ARG A  29      12.241  -7.063   6.418  1.00  0.00           N  
ATOM    253  NH2 ARG A  29      12.986  -9.016   5.484  1.00  0.00           N  
ATOM    254  H   ARG A  29       9.318  -2.243   0.916  1.00  0.00           H  
ATOM    255  HA  ARG A  29      11.374  -3.275   2.727  1.00  0.00           H  
ATOM    256  HB2 ARG A  29       9.291  -4.566   3.248  1.00  0.00           H  
ATOM    257  HB3 ARG A  29       9.106  -4.959   1.546  1.00  0.00           H  
ATOM    258  HG2 ARG A  29       9.977  -6.900   2.613  1.00  0.00           H  
ATOM    259  HG3 ARG A  29      11.298  -6.213   1.669  1.00  0.00           H  
ATOM    260  HD2 ARG A  29      12.350  -5.331   3.649  1.00  0.00           H  
ATOM    261  HD3 ARG A  29      10.936  -5.711   4.640  1.00  0.00           H  
ATOM    262  HE  ARG A  29      12.276  -7.962   3.338  1.00  0.00           H  
ATOM    263 HH11 ARG A  29      11.832  -6.152   6.334  1.00  0.00           H  
ATOM    264 HH12 ARG A  29      12.491  -7.410   7.324  1.00  0.00           H  
ATOM    265 HH21 ARG A  29      13.144  -9.602   4.685  1.00  0.00           H  
ATOM    266 HH22 ARG A  29      13.242  -9.347   6.399  1.00  0.00           H  
ATOM    267  N   MET A  30      12.671  -4.053   0.682  1.00  0.00           N  
ATOM    268  CA  MET A  30      13.503  -4.337  -0.493  1.00  0.00           C  
ATOM    269  C   MET A  30      13.595  -5.864  -0.667  1.00  0.00           C  
ATOM    270  O   MET A  30      14.171  -6.542   0.185  1.00  0.00           O  
ATOM    271  CB  MET A  30      14.910  -3.693  -0.296  1.00  0.00           C  
ATOM    272  CG  MET A  30      15.756  -3.511  -1.570  1.00  0.00           C  
ATOM    273  SD  MET A  30      15.409  -1.985  -2.498  1.00  0.00           S  
ATOM    274  CE  MET A  30      13.871  -2.332  -3.356  1.00  0.00           C  
ATOM    275  H   MET A  30      13.079  -4.126   1.563  1.00  0.00           H  
ATOM    276  HA  MET A  30      13.032  -3.903  -1.373  1.00  0.00           H  
ATOM    277  HB2 MET A  30      14.778  -2.710   0.139  1.00  0.00           H  
ATOM    278  HB3 MET A  30      15.476  -4.297   0.410  1.00  0.00           H  
ATOM    279  HG2 MET A  30      16.803  -3.493  -1.291  1.00  0.00           H  
ATOM    280  HG3 MET A  30      15.590  -4.358  -2.226  1.00  0.00           H  
ATOM    281  HE1 MET A  30      13.582  -1.470  -3.939  1.00  0.00           H  
ATOM    282  HE2 MET A  30      13.095  -2.552  -2.637  1.00  0.00           H  
ATOM    283  HE3 MET A  30      14.004  -3.181  -4.013  1.00  0.00           H  
ATOM    284  N   LEU A  31      12.992  -6.418  -1.743  1.00  0.00           N  
ATOM    285  CA  LEU A  31      12.978  -7.887  -1.979  1.00  0.00           C  
ATOM    286  C   LEU A  31      14.201  -8.354  -2.799  1.00  0.00           C  
ATOM    287  O   LEU A  31      14.375  -9.560  -3.021  1.00  0.00           O  
ATOM    288  CB  LEU A  31      11.624  -8.337  -2.629  1.00  0.00           C  
ATOM    289  CG  LEU A  31      11.260  -7.769  -4.052  1.00  0.00           C  
ATOM    290  CD1 LEU A  31      11.935  -8.545  -5.211  1.00  0.00           C  
ATOM    291  CD2 LEU A  31       9.731  -7.700  -4.266  1.00  0.00           C  
ATOM    292  H   LEU A  31      12.542  -5.830  -2.390  1.00  0.00           H  
ATOM    293  HA  LEU A  31      13.048  -8.367  -1.008  1.00  0.00           H  
ATOM    294  HB2 LEU A  31      11.623  -9.424  -2.690  1.00  0.00           H  
ATOM    295  HB3 LEU A  31      10.832  -8.054  -1.942  1.00  0.00           H  
ATOM    296  HG  LEU A  31      11.628  -6.754  -4.108  1.00  0.00           H  
ATOM    297 HD11 LEU A  31      13.009  -8.487  -5.106  1.00  0.00           H  
ATOM    298 HD12 LEU A  31      11.650  -8.105  -6.159  1.00  0.00           H  
ATOM    299 HD13 LEU A  31      11.626  -9.582  -5.189  1.00  0.00           H  
ATOM    300 HD21 LEU A  31       9.303  -8.694  -4.203  1.00  0.00           H  
ATOM    301 HD22 LEU A  31       9.517  -7.280  -5.241  1.00  0.00           H  
ATOM    302 HD23 LEU A  31       9.288  -7.072  -3.508  1.00  0.00           H  
ATOM    303  N   ASP A  32      15.038  -7.404  -3.240  1.00  0.00           N  
ATOM    304  CA  ASP A  32      16.248  -7.695  -4.040  1.00  0.00           C  
ATOM    305  C   ASP A  32      17.378  -6.771  -3.578  1.00  0.00           C  
ATOM    306  O   ASP A  32      17.108  -5.694  -3.068  1.00  0.00           O  
ATOM    307  CB  ASP A  32      15.953  -7.481  -5.550  1.00  0.00           C  
ATOM    308  CG  ASP A  32      16.981  -8.160  -6.472  1.00  0.00           C  
ATOM    309  OD1 ASP A  32      18.064  -7.589  -6.702  1.00  0.00           O  
ATOM    310  OD2 ASP A  32      16.710  -9.281  -6.960  1.00  0.00           O  
ATOM    311  H   ASP A  32      14.849  -6.469  -3.014  1.00  0.00           H  
ATOM    312  HA  ASP A  32      16.543  -8.727  -3.866  1.00  0.00           H  
ATOM    313  HB2 ASP A  32      14.968  -7.876  -5.775  1.00  0.00           H  
ATOM    314  HB3 ASP A  32      15.949  -6.418  -5.765  1.00  0.00           H  
ATOM    315  N   ASP A  33      18.641  -7.187  -3.756  1.00  0.00           N  
ATOM    316  CA  ASP A  33      19.797  -6.374  -3.323  1.00  0.00           C  
ATOM    317  C   ASP A  33      20.017  -5.206  -4.297  1.00  0.00           C  
ATOM    318  O   ASP A  33      20.096  -5.394  -5.517  1.00  0.00           O  
ATOM    319  CB  ASP A  33      21.082  -7.231  -3.160  1.00  0.00           C  
ATOM    320  CG  ASP A  33      21.506  -7.985  -4.428  1.00  0.00           C  
ATOM    321  OD1 ASP A  33      20.908  -9.042  -4.723  1.00  0.00           O  
ATOM    322  OD2 ASP A  33      22.433  -7.529  -5.139  1.00  0.00           O  
ATOM    323  H   ASP A  33      18.798  -8.032  -4.227  1.00  0.00           H  
ATOM    324  HA  ASP A  33      19.543  -5.961  -2.344  1.00  0.00           H  
ATOM    325  HB2 ASP A  33      21.901  -6.587  -2.845  1.00  0.00           H  
ATOM    326  HB3 ASP A  33      20.910  -7.960  -2.375  1.00  0.00           H  
ATOM    327  N   TYR A  34      20.080  -3.995  -3.736  1.00  0.00           N  
ATOM    328  CA  TYR A  34      20.252  -2.749  -4.499  1.00  0.00           C  
ATOM    329  C   TYR A  34      21.668  -2.185  -4.318  1.00  0.00           C  
ATOM    330  O   TYR A  34      22.460  -2.688  -3.513  1.00  0.00           O  
ATOM    331  CB  TYR A  34      19.147  -1.701  -4.124  1.00  0.00           C  
ATOM    332  CG  TYR A  34      18.126  -1.483  -5.236  1.00  0.00           C  
ATOM    333  CD1 TYR A  34      17.131  -2.430  -5.492  1.00  0.00           C  
ATOM    334  CD2 TYR A  34      18.175  -0.346  -6.050  1.00  0.00           C  
ATOM    335  CE1 TYR A  34      16.227  -2.247  -6.512  1.00  0.00           C  
ATOM    336  CE2 TYR A  34      17.268  -0.162  -7.067  1.00  0.00           C  
ATOM    337  CZ  TYR A  34      16.301  -1.115  -7.298  1.00  0.00           C  
ATOM    338  OH  TYR A  34      15.403  -0.933  -8.319  1.00  0.00           O  
ATOM    339  H   TYR A  34      20.016  -3.937  -2.757  1.00  0.00           H  
ATOM    340  HA  TYR A  34      20.148  -2.999  -5.559  1.00  0.00           H  
ATOM    341  HB2 TYR A  34      18.604  -2.038  -3.246  1.00  0.00           H  
ATOM    342  HB3 TYR A  34      19.601  -0.738  -3.890  1.00  0.00           H  
ATOM    343  HD1 TYR A  34      17.073  -3.321  -4.877  1.00  0.00           H  
ATOM    344  HD2 TYR A  34      18.938   0.403  -5.869  1.00  0.00           H  
ATOM    345  HE1 TYR A  34      15.463  -2.992  -6.697  1.00  0.00           H  
ATOM    346  HE2 TYR A  34      17.322   0.725  -7.685  1.00  0.00           H  
ATOM    347  HH  TYR A  34      15.873  -0.622  -9.099  1.00  0.00           H  
ATOM    348  N   GLU A  35      21.945  -1.133  -5.108  1.00  0.00           N  
ATOM    349  CA  GLU A  35      23.277  -0.482  -5.257  1.00  0.00           C  
ATOM    350  C   GLU A  35      23.940  -0.127  -3.898  1.00  0.00           C  
ATOM    351  O   GLU A  35      25.163  -0.219  -3.750  1.00  0.00           O  
ATOM    352  CB  GLU A  35      23.103   0.804  -6.121  1.00  0.00           C  
ATOM    353  CG  GLU A  35      22.281   0.614  -7.429  1.00  0.00           C  
ATOM    354  CD  GLU A  35      22.949  -0.297  -8.477  1.00  0.00           C  
ATOM    355  OE1 GLU A  35      22.780  -1.536  -8.415  1.00  0.00           O  
ATOM    356  OE2 GLU A  35      23.639   0.228  -9.379  1.00  0.00           O  
ATOM    357  H   GLU A  35      21.203  -0.772  -5.639  1.00  0.00           H  
ATOM    358  HA  GLU A  35      23.924  -1.172  -5.793  1.00  0.00           H  
ATOM    359  HB2 GLU A  35      22.597   1.560  -5.522  1.00  0.00           H  
ATOM    360  HB3 GLU A  35      24.086   1.185  -6.391  1.00  0.00           H  
ATOM    361  HG2 GLU A  35      21.316   0.187  -7.166  1.00  0.00           H  
ATOM    362  HG3 GLU A  35      22.109   1.594  -7.869  1.00  0.00           H  
ATOM    363  N   GLU A  36      23.109   0.271  -2.922  1.00  0.00           N  
ATOM    364  CA  GLU A  36      23.560   0.668  -1.562  1.00  0.00           C  
ATOM    365  C   GLU A  36      22.621   0.109  -0.480  1.00  0.00           C  
ATOM    366  O   GLU A  36      22.788   0.389   0.714  1.00  0.00           O  
ATOM    367  CB  GLU A  36      23.613   2.212  -1.483  1.00  0.00           C  
ATOM    368  CG  GLU A  36      22.306   2.916  -1.914  1.00  0.00           C  
ATOM    369  CD  GLU A  36      22.442   4.441  -1.981  1.00  0.00           C  
ATOM    370  OE1 GLU A  36      23.335   4.927  -2.708  1.00  0.00           O  
ATOM    371  OE2 GLU A  36      21.660   5.158  -1.324  1.00  0.00           O  
ATOM    372  H   GLU A  36      22.151   0.308  -3.118  1.00  0.00           H  
ATOM    373  HA  GLU A  36      24.555   0.265  -1.395  1.00  0.00           H  
ATOM    374  HB2 GLU A  36      23.847   2.512  -0.463  1.00  0.00           H  
ATOM    375  HB3 GLU A  36      24.405   2.559  -2.126  1.00  0.00           H  
ATOM    376  HG2 GLU A  36      22.021   2.557  -2.897  1.00  0.00           H  
ATOM    377  HG3 GLU A  36      21.521   2.653  -1.208  1.00  0.00           H  
ATOM    378  N   ILE A  37      21.633  -0.679  -0.920  1.00  0.00           N  
ATOM    379  CA  ILE A  37      20.541  -1.194  -0.078  1.00  0.00           C  
ATOM    380  C   ILE A  37      20.607  -2.729  -0.078  1.00  0.00           C  
ATOM    381  O   ILE A  37      20.957  -3.332  -1.094  1.00  0.00           O  
ATOM    382  CB  ILE A  37      19.165  -0.705  -0.658  1.00  0.00           C  
ATOM    383  CG1 ILE A  37      19.149   0.859  -0.820  1.00  0.00           C  
ATOM    384  CG2 ILE A  37      17.965  -1.185   0.190  1.00  0.00           C  
ATOM    385  CD1 ILE A  37      18.401   1.356  -2.037  1.00  0.00           C  
ATOM    386  H   ILE A  37      21.650  -0.958  -1.857  1.00  0.00           H  
ATOM    387  HA  ILE A  37      20.657  -0.818   0.939  1.00  0.00           H  
ATOM    388  HB  ILE A  37      19.057  -1.154  -1.636  1.00  0.00           H  
ATOM    389 HG12 ILE A  37      18.677   1.311   0.044  1.00  0.00           H  
ATOM    390 HG13 ILE A  37      20.164   1.238  -0.895  1.00  0.00           H  
ATOM    391 HG21 ILE A  37      17.952  -2.269   0.233  1.00  0.00           H  
ATOM    392 HG22 ILE A  37      17.041  -0.839  -0.258  1.00  0.00           H  
ATOM    393 HG23 ILE A  37      18.042  -0.788   1.195  1.00  0.00           H  
ATOM    394 HD11 ILE A  37      18.444   2.435  -2.056  1.00  0.00           H  
ATOM    395 HD12 ILE A  37      17.368   1.041  -1.991  1.00  0.00           H  
ATOM    396 HD13 ILE A  37      18.863   0.967  -2.934  1.00  0.00           H  
ATOM    397  N   SER A  38      20.287  -3.352   1.053  1.00  0.00           N  
ATOM    398  CA  SER A  38      20.299  -4.816   1.188  1.00  0.00           C  
ATOM    399  C   SER A  38      18.918  -5.408   0.865  1.00  0.00           C  
ATOM    400  O   SER A  38      17.891  -4.731   1.011  1.00  0.00           O  
ATOM    401  CB  SER A  38      20.705  -5.181   2.628  1.00  0.00           C  
ATOM    402  OG  SER A  38      21.979  -4.640   2.955  1.00  0.00           O  
ATOM    403  H   SER A  38      20.020  -2.814   1.826  1.00  0.00           H  
ATOM    404  HA  SER A  38      21.036  -5.224   0.498  1.00  0.00           H  
ATOM    405  HB2 SER A  38      19.975  -4.780   3.317  1.00  0.00           H  
ATOM    406  HB3 SER A  38      20.750  -6.259   2.737  1.00  0.00           H  
ATOM    407  HG  SER A  38      22.287  -4.081   2.225  1.00  0.00           H  
ATOM    408  N   ALA A  39      18.906  -6.676   0.419  1.00  0.00           N  
ATOM    409  CA  ALA A  39      17.679  -7.475   0.352  1.00  0.00           C  
ATOM    410  C   ALA A  39      17.276  -7.843   1.789  1.00  0.00           C  
ATOM    411  O   ALA A  39      18.021  -8.539   2.493  1.00  0.00           O  
ATOM    412  CB  ALA A  39      17.899  -8.730  -0.502  1.00  0.00           C  
ATOM    413  H   ALA A  39      19.749  -7.082   0.130  1.00  0.00           H  
ATOM    414  HA  ALA A  39      16.894  -6.872  -0.110  1.00  0.00           H  
ATOM    415  HB1 ALA A  39      18.191  -8.440  -1.503  1.00  0.00           H  
ATOM    416  HB2 ALA A  39      16.984  -9.305  -0.551  1.00  0.00           H  
ATOM    417  HB3 ALA A  39      18.683  -9.340  -0.067  1.00  0.00           H  
ATOM    418  N   GLY A  40      16.111  -7.343   2.211  1.00  0.00           N  
ATOM    419  CA  GLY A  40      15.648  -7.462   3.594  1.00  0.00           C  
ATOM    420  C   GLY A  40      15.645  -6.121   4.322  1.00  0.00           C  
ATOM    421  O   GLY A  40      15.175  -6.039   5.461  1.00  0.00           O  
ATOM    422  H   GLY A  40      15.549  -6.874   1.567  1.00  0.00           H  
ATOM    423  HA2 GLY A  40      14.639  -7.848   3.584  1.00  0.00           H  
ATOM    424  HA3 GLY A  40      16.278  -8.154   4.143  1.00  0.00           H  
ATOM    425  N   ASP A  41      16.166  -5.064   3.657  1.00  0.00           N  
ATOM    426  CA  ASP A  41      16.160  -3.691   4.208  1.00  0.00           C  
ATOM    427  C   ASP A  41      14.776  -3.054   4.020  1.00  0.00           C  
ATOM    428  O   ASP A  41      14.019  -3.458   3.137  1.00  0.00           O  
ATOM    429  CB  ASP A  41      17.258  -2.822   3.539  1.00  0.00           C  
ATOM    430  CG  ASP A  41      17.417  -1.427   4.183  1.00  0.00           C  
ATOM    431  OD1 ASP A  41      17.417  -1.345   5.426  1.00  0.00           O  
ATOM    432  OD2 ASP A  41      17.580  -0.423   3.462  1.00  0.00           O  
ATOM    433  H   ASP A  41      16.559  -5.210   2.773  1.00  0.00           H  
ATOM    434  HA  ASP A  41      16.368  -3.759   5.271  1.00  0.00           H  
ATOM    435  HB2 ASP A  41      18.209  -3.338   3.609  1.00  0.00           H  
ATOM    436  HB3 ASP A  41      17.012  -2.697   2.485  1.00  0.00           H  
ATOM    437  N   GLU A  42      14.451  -2.058   4.860  1.00  0.00           N  
ATOM    438  CA  GLU A  42      13.132  -1.407   4.866  1.00  0.00           C  
ATOM    439  C   GLU A  42      13.268   0.120   4.819  1.00  0.00           C  
ATOM    440  O   GLU A  42      14.315   0.682   5.167  1.00  0.00           O  
ATOM    441  CB  GLU A  42      12.325  -1.865   6.098  1.00  0.00           C  
ATOM    442  CG  GLU A  42      11.914  -3.349   6.057  1.00  0.00           C  
ATOM    443  CD  GLU A  42      11.087  -3.791   7.263  1.00  0.00           C  
ATOM    444  OE1 GLU A  42       9.946  -3.317   7.405  1.00  0.00           O  
ATOM    445  OE2 GLU A  42      11.565  -4.619   8.066  1.00  0.00           O  
ATOM    446  H   GLU A  42      15.131  -1.732   5.487  1.00  0.00           H  
ATOM    447  HA  GLU A  42      12.592  -1.716   3.967  1.00  0.00           H  
ATOM    448  HB2 GLU A  42      12.919  -1.696   6.994  1.00  0.00           H  
ATOM    449  HB3 GLU A  42      11.418  -1.268   6.170  1.00  0.00           H  
ATOM    450  HG2 GLU A  42      11.323  -3.516   5.159  1.00  0.00           H  
ATOM    451  HG3 GLU A  42      12.815  -3.958   5.991  1.00  0.00           H  
ATOM    452  N   GLY A  43      12.186   0.769   4.369  1.00  0.00           N  
ATOM    453  CA  GLY A  43      12.175   2.203   4.098  1.00  0.00           C  
ATOM    454  C   GLY A  43      10.816   2.826   4.327  1.00  0.00           C  
ATOM    455  O   GLY A  43       9.934   2.197   4.910  1.00  0.00           O  
ATOM    456  H   GLY A  43      11.367   0.259   4.225  1.00  0.00           H  
ATOM    457  HA2 GLY A  43      12.891   2.712   4.715  1.00  0.00           H  
ATOM    458  HA3 GLY A  43      12.452   2.353   3.062  1.00  0.00           H  
ATOM    459  N   GLU A  44      10.647   4.066   3.846  1.00  0.00           N  
ATOM    460  CA  GLU A  44       9.359   4.775   3.878  1.00  0.00           C  
ATOM    461  C   GLU A  44       9.123   5.444   2.528  1.00  0.00           C  
ATOM    462  O   GLU A  44      10.059   6.014   1.959  1.00  0.00           O  
ATOM    463  CB  GLU A  44       9.323   5.847   4.998  1.00  0.00           C  
ATOM    464  CG  GLU A  44       7.995   6.631   5.078  1.00  0.00           C  
ATOM    465  CD  GLU A  44       8.009   7.762   6.115  1.00  0.00           C  
ATOM    466  OE1 GLU A  44       8.543   8.852   5.808  1.00  0.00           O  
ATOM    467  OE2 GLU A  44       7.486   7.570   7.233  1.00  0.00           O  
ATOM    468  H   GLU A  44      11.415   4.522   3.441  1.00  0.00           H  
ATOM    469  HA  GLU A  44       8.566   4.045   4.056  1.00  0.00           H  
ATOM    470  HB2 GLU A  44       9.490   5.359   5.952  1.00  0.00           H  
ATOM    471  HB3 GLU A  44      10.132   6.558   4.833  1.00  0.00           H  
ATOM    472  HG2 GLU A  44       7.789   7.062   4.101  1.00  0.00           H  
ATOM    473  HG3 GLU A  44       7.196   5.932   5.319  1.00  0.00           H  
ATOM    474  N   PHE A  45       7.873   5.389   2.038  1.00  0.00           N  
ATOM    475  CA  PHE A  45       7.467   6.070   0.805  1.00  0.00           C  
ATOM    476  C   PHE A  45       7.478   7.585   1.042  1.00  0.00           C  
ATOM    477  O   PHE A  45       6.754   8.090   1.901  1.00  0.00           O  
ATOM    478  CB  PHE A  45       6.066   5.573   0.366  1.00  0.00           C  
ATOM    479  CG  PHE A  45       5.565   6.123  -0.980  1.00  0.00           C  
ATOM    480  CD1 PHE A  45       4.979   7.379  -1.067  1.00  0.00           C  
ATOM    481  CD2 PHE A  45       5.639   5.368  -2.143  1.00  0.00           C  
ATOM    482  CE1 PHE A  45       4.486   7.862  -2.257  1.00  0.00           C  
ATOM    483  CE2 PHE A  45       5.152   5.852  -3.337  1.00  0.00           C  
ATOM    484  CZ  PHE A  45       4.570   7.097  -3.390  1.00  0.00           C  
ATOM    485  H   PHE A  45       7.203   4.876   2.529  1.00  0.00           H  
ATOM    486  HA  PHE A  45       8.186   5.821   0.030  1.00  0.00           H  
ATOM    487  HB2 PHE A  45       6.089   4.489   0.293  1.00  0.00           H  
ATOM    488  HB3 PHE A  45       5.340   5.842   1.128  1.00  0.00           H  
ATOM    489  HD1 PHE A  45       4.914   7.988  -0.179  1.00  0.00           H  
ATOM    490  HD2 PHE A  45       6.096   4.388  -2.112  1.00  0.00           H  
ATOM    491  HE1 PHE A  45       4.034   8.845  -2.298  1.00  0.00           H  
ATOM    492  HE2 PHE A  45       5.218   5.248  -4.234  1.00  0.00           H  
ATOM    493  HZ  PHE A  45       4.183   7.474  -4.326  1.00  0.00           H  
ATOM    494  N   ARG A  46       8.307   8.294   0.265  1.00  0.00           N  
ATOM    495  CA  ARG A  46       8.496   9.748   0.390  1.00  0.00           C  
ATOM    496  C   ARG A  46       7.740  10.448  -0.744  1.00  0.00           C  
ATOM    497  O   ARG A  46       7.014  11.416  -0.518  1.00  0.00           O  
ATOM    498  CB  ARG A  46      10.015  10.069   0.328  1.00  0.00           C  
ATOM    499  CG  ARG A  46      10.899   9.138   1.184  1.00  0.00           C  
ATOM    500  CD  ARG A  46      10.674   9.294   2.698  1.00  0.00           C  
ATOM    501  NE  ARG A  46      11.317  10.518   3.207  1.00  0.00           N  
ATOM    502  CZ  ARG A  46      11.580  10.795   4.493  1.00  0.00           C  
ATOM    503  NH1 ARG A  46      11.131  10.018   5.464  1.00  0.00           N  
ATOM    504  NH2 ARG A  46      12.280  11.876   4.800  1.00  0.00           N  
ATOM    505  H   ARG A  46       8.816   7.819  -0.423  1.00  0.00           H  
ATOM    506  HA  ARG A  46       8.095  10.080   1.345  1.00  0.00           H  
ATOM    507  HB2 ARG A  46      10.346   9.983  -0.701  1.00  0.00           H  
ATOM    508  HB3 ARG A  46      10.174  11.093   0.656  1.00  0.00           H  
ATOM    509  HG2 ARG A  46      10.688   8.106   0.907  1.00  0.00           H  
ATOM    510  HG3 ARG A  46      11.942   9.347   0.963  1.00  0.00           H  
ATOM    511  HD2 ARG A  46       9.611   9.332   2.904  1.00  0.00           H  
ATOM    512  HD3 ARG A  46      11.102   8.429   3.198  1.00  0.00           H  
ATOM    513  HE  ARG A  46      11.608  11.168   2.530  1.00  0.00           H  
ATOM    514 HH11 ARG A  46      10.568   9.215   5.254  1.00  0.00           H  
ATOM    515 HH12 ARG A  46      11.342  10.233   6.423  1.00  0.00           H  
ATOM    516 HH21 ARG A  46      12.603  12.493   4.077  1.00  0.00           H  
ATOM    517 HH22 ARG A  46      12.481  12.089   5.761  1.00  0.00           H  
ATOM    518  N   GLN A  47       7.936   9.913  -1.965  1.00  0.00           N  
ATOM    519  CA  GLN A  47       7.261  10.362  -3.198  1.00  0.00           C  
ATOM    520  C   GLN A  47       7.601   9.384  -4.337  1.00  0.00           C  
ATOM    521  O   GLN A  47       8.638   8.702  -4.294  1.00  0.00           O  
ATOM    522  CB  GLN A  47       7.669  11.820  -3.616  1.00  0.00           C  
ATOM    523  CG  GLN A  47       9.133  12.001  -4.115  1.00  0.00           C  
ATOM    524  CD  GLN A  47      10.197  11.782  -3.033  1.00  0.00           C  
ATOM    525  OE1 GLN A  47      10.620  12.720  -2.359  1.00  0.00           O  
ATOM    526  NE2 GLN A  47      10.596  10.532  -2.827  1.00  0.00           N  
ATOM    527  H   GLN A  47       8.579   9.174  -2.043  1.00  0.00           H  
ATOM    528  HA  GLN A  47       6.190  10.326  -3.016  1.00  0.00           H  
ATOM    529  HB2 GLN A  47       7.001  12.150  -4.409  1.00  0.00           H  
ATOM    530  HB3 GLN A  47       7.520  12.472  -2.762  1.00  0.00           H  
ATOM    531  HG2 GLN A  47       9.317  11.302  -4.922  1.00  0.00           H  
ATOM    532  HG3 GLN A  47       9.245  13.011  -4.505  1.00  0.00           H  
ATOM    533 HE21 GLN A  47      10.196   9.816  -3.371  1.00  0.00           H  
ATOM    534 HE22 GLN A  47      11.280  10.367  -2.144  1.00  0.00           H  
ATOM    535  N   SER A  48       6.742   9.342  -5.357  1.00  0.00           N  
ATOM    536  CA  SER A  48       6.952   8.522  -6.560  1.00  0.00           C  
ATOM    537  C   SER A  48       6.821   9.380  -7.814  1.00  0.00           C  
ATOM    538  O   SER A  48       6.548  10.587  -7.746  1.00  0.00           O  
ATOM    539  CB  SER A  48       5.920   7.380  -6.600  1.00  0.00           C  
ATOM    540  OG  SER A  48       4.587   7.875  -6.577  1.00  0.00           O  
ATOM    541  H   SER A  48       5.925   9.881  -5.306  1.00  0.00           H  
ATOM    542  HA  SER A  48       7.953   8.098  -6.533  1.00  0.00           H  
ATOM    543  HB2 SER A  48       6.054   6.789  -7.499  1.00  0.00           H  
ATOM    544  HB3 SER A  48       6.061   6.739  -5.738  1.00  0.00           H  
ATOM    545  HG  SER A  48       4.064   7.421  -7.245  1.00  0.00           H  
ATOM    546  N   ASN A  49       7.032   8.733  -8.964  1.00  0.00           N  
ATOM    547  CA  ASN A  49       6.751   9.309 -10.281  1.00  0.00           C  
ATOM    548  C   ASN A  49       5.683   8.430 -10.953  1.00  0.00           C  
ATOM    549  O   ASN A  49       5.763   7.197 -10.874  1.00  0.00           O  
ATOM    550  CB  ASN A  49       8.041   9.376 -11.132  1.00  0.00           C  
ATOM    551  CG  ASN A  49       9.184  10.139 -10.453  1.00  0.00           C  
ATOM    552  OD1 ASN A  49       9.289  11.354 -10.573  1.00  0.00           O  
ATOM    553  ND2 ASN A  49      10.052   9.424  -9.744  1.00  0.00           N  
ATOM    554  H   ASN A  49       7.388   7.816  -8.927  1.00  0.00           H  
ATOM    555  HA  ASN A  49       6.353  10.318 -10.150  1.00  0.00           H  
ATOM    556  HB2 ASN A  49       8.384   8.368 -11.341  1.00  0.00           H  
ATOM    557  HB3 ASN A  49       7.818   9.865 -12.074  1.00  0.00           H  
ATOM    558 HD21 ASN A  49       9.919   8.451  -9.693  1.00  0.00           H  
ATOM    559 HD22 ASN A  49      10.791   9.892  -9.301  1.00  0.00           H  
ATOM    560  N   ASN A  50       4.680   9.067 -11.585  1.00  0.00           N  
ATOM    561  CA  ASN A  50       3.526   8.361 -12.194  1.00  0.00           C  
ATOM    562  C   ASN A  50       3.969   7.534 -13.411  1.00  0.00           C  
ATOM    563  O   ASN A  50       3.689   6.332 -13.502  1.00  0.00           O  
ATOM    564  CB  ASN A  50       2.416   9.364 -12.620  1.00  0.00           C  
ATOM    565  CG  ASN A  50       1.799  10.129 -11.447  1.00  0.00           C  
ATOM    566  OD1 ASN A  50       0.842   9.670 -10.824  1.00  0.00           O  
ATOM    567  ND2 ASN A  50       2.334  11.304 -11.150  1.00  0.00           N  
ATOM    568  H   ASN A  50       4.714  10.043 -11.648  1.00  0.00           H  
ATOM    569  HA  ASN A  50       3.118   7.689 -11.451  1.00  0.00           H  
ATOM    570  HB2 ASN A  50       2.837  10.084 -13.314  1.00  0.00           H  
ATOM    571  HB3 ASN A  50       1.621   8.824 -13.128  1.00  0.00           H  
ATOM    572 HD21 ASN A  50       3.090  11.619 -11.686  1.00  0.00           H  
ATOM    573 HD22 ASN A  50       1.948  11.811 -10.406  1.00  0.00           H  
ATOM    574  N   GLY A  51       4.666   8.210 -14.336  1.00  0.00           N  
ATOM    575  CA  GLY A  51       5.116   7.606 -15.588  1.00  0.00           C  
ATOM    576  C   GLY A  51       6.499   6.976 -15.490  1.00  0.00           C  
ATOM    577  O   GLY A  51       6.837   6.105 -16.292  1.00  0.00           O  
ATOM    578  H   GLY A  51       4.885   9.148 -14.156  1.00  0.00           H  
ATOM    579  HA2 GLY A  51       4.405   6.847 -15.902  1.00  0.00           H  
ATOM    580  HA3 GLY A  51       5.143   8.378 -16.343  1.00  0.00           H  
ATOM    581  N   ILE A  52       7.312   7.432 -14.521  1.00  0.00           N  
ATOM    582  CA  ILE A  52       8.700   6.951 -14.350  1.00  0.00           C  
ATOM    583  C   ILE A  52       8.720   5.938 -13.177  1.00  0.00           C  
ATOM    584  O   ILE A  52       8.444   6.326 -12.039  1.00  0.00           O  
ATOM    585  CB  ILE A  52       9.709   8.136 -14.056  1.00  0.00           C  
ATOM    586  CG1 ILE A  52       9.357   9.433 -14.865  1.00  0.00           C  
ATOM    587  CG2 ILE A  52      11.169   7.717 -14.345  1.00  0.00           C  
ATOM    588  CD1 ILE A  52       9.424   9.302 -16.383  1.00  0.00           C  
ATOM    589  H   ILE A  52       6.970   8.102 -13.895  1.00  0.00           H  
ATOM    590  HA  ILE A  52       9.009   6.453 -15.268  1.00  0.00           H  
ATOM    591  HB  ILE A  52       9.642   8.362 -12.995  1.00  0.00           H  
ATOM    592 HG12 ILE A  52       8.348   9.738 -14.616  1.00  0.00           H  
ATOM    593 HG13 ILE A  52      10.035  10.226 -14.575  1.00  0.00           H  
ATOM    594 HG21 ILE A  52      11.269   7.432 -15.385  1.00  0.00           H  
ATOM    595 HG22 ILE A  52      11.439   6.880 -13.721  1.00  0.00           H  
ATOM    596 HG23 ILE A  52      11.837   8.544 -14.138  1.00  0.00           H  
ATOM    597 HD11 ILE A  52       9.171  10.251 -16.833  1.00  0.00           H  
ATOM    598 HD12 ILE A  52       8.722   8.550 -16.716  1.00  0.00           H  
ATOM    599 HD13 ILE A  52      10.423   9.020 -16.681  1.00  0.00           H  
ATOM    600  N   PRO A  53       9.012   4.623 -13.433  1.00  0.00           N  
ATOM    601  CA  PRO A  53       8.944   3.569 -12.385  1.00  0.00           C  
ATOM    602  C   PRO A  53       9.858   3.723 -11.108  1.00  0.00           C  
ATOM    603  O   PRO A  53       9.432   3.253 -10.042  1.00  0.00           O  
ATOM    604  CB  PRO A  53       9.246   2.253 -13.158  1.00  0.00           C  
ATOM    605  CG  PRO A  53       9.926   2.685 -14.424  1.00  0.00           C  
ATOM    606  CD  PRO A  53       9.340   4.038 -14.764  1.00  0.00           C  
ATOM    607  HA  PRO A  53       7.926   3.530 -12.024  1.00  0.00           H  
ATOM    608  HB2 PRO A  53       9.884   1.602 -12.564  1.00  0.00           H  
ATOM    609  HB3 PRO A  53       8.315   1.734 -13.368  1.00  0.00           H  
ATOM    610  HG2 PRO A  53      11.001   2.766 -14.258  1.00  0.00           H  
ATOM    611  HG3 PRO A  53       9.728   1.972 -15.218  1.00  0.00           H  
ATOM    612  HD2 PRO A  53      10.069   4.647 -15.292  1.00  0.00           H  
ATOM    613  HD3 PRO A  53       8.443   3.928 -15.364  1.00  0.00           H  
ATOM    614  N   PRO A  54      11.115   4.301 -11.143  1.00  0.00           N  
ATOM    615  CA  PRO A  54      11.900   4.511  -9.902  1.00  0.00           C  
ATOM    616  C   PRO A  54      11.190   5.462  -8.902  1.00  0.00           C  
ATOM    617  O   PRO A  54      11.031   6.664  -9.159  1.00  0.00           O  
ATOM    618  CB  PRO A  54      13.258   5.074 -10.402  1.00  0.00           C  
ATOM    619  CG  PRO A  54      12.960   5.617 -11.760  1.00  0.00           C  
ATOM    620  CD  PRO A  54      11.904   4.702 -12.329  1.00  0.00           C  
ATOM    621  HA  PRO A  54      12.076   3.557  -9.407  1.00  0.00           H  
ATOM    622  HB2 PRO A  54      13.628   5.845  -9.732  1.00  0.00           H  
ATOM    623  HB3 PRO A  54      13.990   4.272 -10.455  1.00  0.00           H  
ATOM    624  HG2 PRO A  54      12.581   6.632 -11.680  1.00  0.00           H  
ATOM    625  HG3 PRO A  54      13.847   5.600 -12.379  1.00  0.00           H  
ATOM    626  HD2 PRO A  54      11.284   5.225 -13.047  1.00  0.00           H  
ATOM    627  HD3 PRO A  54      12.343   3.828 -12.795  1.00  0.00           H  
ATOM    628  N   VAL A  55      10.683   4.869  -7.812  1.00  0.00           N  
ATOM    629  CA  VAL A  55      10.169   5.595  -6.634  1.00  0.00           C  
ATOM    630  C   VAL A  55      11.320   5.838  -5.636  1.00  0.00           C  
ATOM    631  O   VAL A  55      12.151   4.950  -5.403  1.00  0.00           O  
ATOM    632  CB  VAL A  55       8.978   4.817  -5.934  1.00  0.00           C  
ATOM    633  CG1 VAL A  55       9.299   3.312  -5.749  1.00  0.00           C  
ATOM    634  CG2 VAL A  55       8.581   5.463  -4.575  1.00  0.00           C  
ATOM    635  H   VAL A  55      10.646   3.888  -7.804  1.00  0.00           H  
ATOM    636  HA  VAL A  55       9.791   6.557  -6.973  1.00  0.00           H  
ATOM    637  HB  VAL A  55       8.113   4.887  -6.596  1.00  0.00           H  
ATOM    638 HG11 VAL A  55       9.497   2.864  -6.717  1.00  0.00           H  
ATOM    639 HG12 VAL A  55       8.458   2.807  -5.292  1.00  0.00           H  
ATOM    640 HG13 VAL A  55      10.173   3.200  -5.120  1.00  0.00           H  
ATOM    641 HG21 VAL A  55       8.367   6.521  -4.716  1.00  0.00           H  
ATOM    642 HG22 VAL A  55       9.398   5.363  -3.871  1.00  0.00           H  
ATOM    643 HG23 VAL A  55       7.702   4.975  -4.175  1.00  0.00           H  
ATOM    644  N   GLN A  56      11.376   7.063  -5.085  1.00  0.00           N  
ATOM    645  CA  GLN A  56      12.373   7.437  -4.076  1.00  0.00           C  
ATOM    646  C   GLN A  56      11.796   7.138  -2.673  1.00  0.00           C  
ATOM    647  O   GLN A  56      10.724   7.642  -2.300  1.00  0.00           O  
ATOM    648  CB  GLN A  56      12.792   8.932  -4.203  1.00  0.00           C  
ATOM    649  CG  GLN A  56      13.526   9.349  -5.495  1.00  0.00           C  
ATOM    650  CD  GLN A  56      12.681   9.219  -6.774  1.00  0.00           C  
ATOM    651  OE1 GLN A  56      11.954  10.132  -7.153  1.00  0.00           O  
ATOM    652  NE2 GLN A  56      12.769   8.082  -7.439  1.00  0.00           N  
ATOM    653  H   GLN A  56      10.711   7.729  -5.357  1.00  0.00           H  
ATOM    654  HA  GLN A  56      13.259   6.821  -4.237  1.00  0.00           H  
ATOM    655  HB2 GLN A  56      11.907   9.544  -4.117  1.00  0.00           H  
ATOM    656  HB3 GLN A  56      13.439   9.174  -3.364  1.00  0.00           H  
ATOM    657  HG2 GLN A  56      13.828  10.387  -5.398  1.00  0.00           H  
ATOM    658  HG3 GLN A  56      14.419   8.740  -5.599  1.00  0.00           H  
ATOM    659 HE21 GLN A  56      13.358   7.381  -7.086  1.00  0.00           H  
ATOM    660 HE22 GLN A  56      12.252   7.989  -8.264  1.00  0.00           H  
ATOM    661  N   VAL A  57      12.533   6.318  -1.914  1.00  0.00           N  
ATOM    662  CA  VAL A  57      12.135   5.804  -0.585  1.00  0.00           C  
ATOM    663  C   VAL A  57      13.342   5.881   0.347  1.00  0.00           C  
ATOM    664  O   VAL A  57      14.454   5.563  -0.070  1.00  0.00           O  
ATOM    665  CB  VAL A  57      11.598   4.311  -0.671  1.00  0.00           C  
ATOM    666  CG1 VAL A  57      10.068   4.265  -0.790  1.00  0.00           C  
ATOM    667  CG2 VAL A  57      12.240   3.555  -1.852  1.00  0.00           C  
ATOM    668  H   VAL A  57      13.412   6.043  -2.260  1.00  0.00           H  
ATOM    669  HA  VAL A  57      11.345   6.448  -0.181  1.00  0.00           H  
ATOM    670  HB  VAL A  57      11.868   3.786   0.245  1.00  0.00           H  
ATOM    671 HG11 VAL A  57       9.634   4.647   0.130  1.00  0.00           H  
ATOM    672 HG12 VAL A  57       9.740   3.244  -0.931  1.00  0.00           H  
ATOM    673 HG13 VAL A  57       9.741   4.876  -1.622  1.00  0.00           H  
ATOM    674 HG21 VAL A  57      11.908   2.519  -1.851  1.00  0.00           H  
ATOM    675 HG22 VAL A  57      13.319   3.575  -1.753  1.00  0.00           H  
ATOM    676 HG23 VAL A  57      11.961   4.018  -2.790  1.00  0.00           H  
ATOM    677  N   PHE A  58      13.119   6.335   1.592  1.00  0.00           N  
ATOM    678  CA  PHE A  58      14.202   6.549   2.569  1.00  0.00           C  
ATOM    679  C   PHE A  58      14.550   5.216   3.244  1.00  0.00           C  
ATOM    680  O   PHE A  58      13.807   4.749   4.108  1.00  0.00           O  
ATOM    681  CB  PHE A  58      13.758   7.610   3.613  1.00  0.00           C  
ATOM    682  CG  PHE A  58      14.851   8.073   4.577  1.00  0.00           C  
ATOM    683  CD1 PHE A  58      15.671   9.154   4.259  1.00  0.00           C  
ATOM    684  CD2 PHE A  58      15.053   7.436   5.804  1.00  0.00           C  
ATOM    685  CE1 PHE A  58      16.650   9.580   5.132  1.00  0.00           C  
ATOM    686  CE2 PHE A  58      16.032   7.864   6.676  1.00  0.00           C  
ATOM    687  CZ  PHE A  58      16.831   8.937   6.338  1.00  0.00           C  
ATOM    688  H   PHE A  58      12.198   6.523   1.863  1.00  0.00           H  
ATOM    689  HA  PHE A  58      15.076   6.925   2.036  1.00  0.00           H  
ATOM    690  HB2 PHE A  58      13.394   8.487   3.087  1.00  0.00           H  
ATOM    691  HB3 PHE A  58      12.939   7.209   4.203  1.00  0.00           H  
ATOM    692  HD1 PHE A  58      15.539   9.664   3.314  1.00  0.00           H  
ATOM    693  HD2 PHE A  58      14.427   6.591   6.071  1.00  0.00           H  
ATOM    694  HE1 PHE A  58      17.279  10.422   4.868  1.00  0.00           H  
ATOM    695  HE2 PHE A  58      16.173   7.358   7.623  1.00  0.00           H  
ATOM    696  HZ  PHE A  58      17.598   9.274   7.021  1.00  0.00           H  
ATOM    697  N   TRP A  59      15.694   4.642   2.855  1.00  0.00           N  
ATOM    698  CA  TRP A  59      16.165   3.331   3.335  1.00  0.00           C  
ATOM    699  C   TRP A  59      17.025   3.499   4.582  1.00  0.00           C  
ATOM    700  O   TRP A  59      17.947   4.324   4.591  1.00  0.00           O  
ATOM    701  CB  TRP A  59      16.958   2.622   2.222  1.00  0.00           C  
ATOM    702  CG  TRP A  59      16.127   2.343   1.005  1.00  0.00           C  
ATOM    703  CD1 TRP A  59      16.103   3.051  -0.159  1.00  0.00           C  
ATOM    704  CD2 TRP A  59      15.165   1.295   0.860  1.00  0.00           C  
ATOM    705  NE1 TRP A  59      15.212   2.490  -1.027  1.00  0.00           N  
ATOM    706  CE2 TRP A  59      14.617   1.409  -0.419  1.00  0.00           C  
ATOM    707  CE3 TRP A  59      14.726   0.266   1.692  1.00  0.00           C  
ATOM    708  CZ2 TRP A  59      13.642   0.531  -0.888  1.00  0.00           C  
ATOM    709  CZ3 TRP A  59      13.761  -0.600   1.230  1.00  0.00           C  
ATOM    710  CH2 TRP A  59      13.227  -0.464  -0.051  1.00  0.00           C  
ATOM    711  H   TRP A  59      16.247   5.117   2.206  1.00  0.00           H  
ATOM    712  HA  TRP A  59      15.295   2.722   3.582  1.00  0.00           H  
ATOM    713  HB2 TRP A  59      17.797   3.240   1.926  1.00  0.00           H  
ATOM    714  HB3 TRP A  59      17.337   1.674   2.591  1.00  0.00           H  
ATOM    715  HD1 TRP A  59      16.717   3.919  -0.360  1.00  0.00           H  
ATOM    716  HE1 TRP A  59      15.025   2.816  -1.931  1.00  0.00           H  
ATOM    717  HE3 TRP A  59      15.132   0.144   2.691  1.00  0.00           H  
ATOM    718  HZ2 TRP A  59      13.218   0.625  -1.881  1.00  0.00           H  
ATOM    719  HZ3 TRP A  59      13.409  -1.398   1.870  1.00  0.00           H  
ATOM    720  HH2 TRP A  59      12.467  -1.168  -0.374  1.00  0.00           H  
ATOM    721  N   GLN A  60      16.716   2.712   5.624  1.00  0.00           N  
ATOM    722  CA  GLN A  60      17.361   2.831   6.939  1.00  0.00           C  
ATOM    723  C   GLN A  60      18.835   2.364   6.926  1.00  0.00           C  
ATOM    724  O   GLN A  60      19.645   2.897   7.690  1.00  0.00           O  
ATOM    725  CB  GLN A  60      16.545   2.074   8.026  1.00  0.00           C  
ATOM    726  CG  GLN A  60      16.362   0.570   7.769  1.00  0.00           C  
ATOM    727  CD  GLN A  60      15.756  -0.179   8.946  1.00  0.00           C  
ATOM    728  OE1 GLN A  60      14.540  -0.315   9.064  1.00  0.00           O  
ATOM    729  NE2 GLN A  60      16.607  -0.650   9.838  1.00  0.00           N  
ATOM    730  H   GLN A  60      16.034   2.016   5.497  1.00  0.00           H  
ATOM    731  HA  GLN A  60      17.355   3.887   7.197  1.00  0.00           H  
ATOM    732  HB2 GLN A  60      17.039   2.201   8.984  1.00  0.00           H  
ATOM    733  HB3 GLN A  60      15.559   2.525   8.091  1.00  0.00           H  
ATOM    734  HG2 GLN A  60      15.717   0.439   6.909  1.00  0.00           H  
ATOM    735  HG3 GLN A  60      17.329   0.130   7.541  1.00  0.00           H  
ATOM    736 HE21 GLN A  60      17.562  -0.482   9.693  1.00  0.00           H  
ATOM    737 HE22 GLN A  60      16.256  -1.158  10.592  1.00  0.00           H  
ATOM    738  N   SER A  61      19.181   1.375   6.066  1.00  0.00           N  
ATOM    739  CA  SER A  61      20.555   0.818   6.018  1.00  0.00           C  
ATOM    740  C   SER A  61      21.557   1.832   5.432  1.00  0.00           C  
ATOM    741  O   SER A  61      22.642   2.041   5.991  1.00  0.00           O  
ATOM    742  CB  SER A  61      20.591  -0.489   5.198  1.00  0.00           C  
ATOM    743  OG  SER A  61      21.883  -1.069   5.181  1.00  0.00           O  
ATOM    744  H   SER A  61      18.494   0.999   5.466  1.00  0.00           H  
ATOM    745  HA  SER A  61      20.848   0.586   7.042  1.00  0.00           H  
ATOM    746  HB2 SER A  61      19.906  -1.201   5.630  1.00  0.00           H  
ATOM    747  HB3 SER A  61      20.287  -0.286   4.179  1.00  0.00           H  
ATOM    748  HG  SER A  61      21.832  -1.967   5.531  1.00  0.00           H  
ATOM    749  N   THR A  62      21.174   2.473   4.310  1.00  0.00           N  
ATOM    750  CA  THR A  62      22.015   3.485   3.642  1.00  0.00           C  
ATOM    751  C   THR A  62      21.778   4.889   4.260  1.00  0.00           C  
ATOM    752  O   THR A  62      22.606   5.797   4.100  1.00  0.00           O  
ATOM    753  CB  THR A  62      21.774   3.498   2.093  1.00  0.00           C  
ATOM    754  OG1 THR A  62      22.668   4.425   1.461  1.00  0.00           O  
ATOM    755  CG2 THR A  62      20.324   3.845   1.718  1.00  0.00           C  
ATOM    756  H   THR A  62      20.301   2.260   3.922  1.00  0.00           H  
ATOM    757  HA  THR A  62      23.058   3.216   3.806  1.00  0.00           H  
ATOM    758  HB  THR A  62      21.997   2.506   1.708  1.00  0.00           H  
ATOM    759  HG1 THR A  62      22.253   4.778   0.668  1.00  0.00           H  
ATOM    760 HG21 THR A  62      20.075   4.830   2.094  1.00  0.00           H  
ATOM    761 HG22 THR A  62      19.651   3.117   2.153  1.00  0.00           H  
ATOM    762 HG23 THR A  62      20.209   3.836   0.640  1.00  0.00           H  
ATOM    763  N   GLY A  63      20.643   5.041   4.978  1.00  0.00           N  
ATOM    764  CA  GLY A  63      20.309   6.284   5.686  1.00  0.00           C  
ATOM    765  C   GLY A  63      19.824   7.409   4.782  1.00  0.00           C  
ATOM    766  O   GLY A  63      19.861   8.581   5.185  1.00  0.00           O  
ATOM    767  H   GLY A  63      20.023   4.285   5.034  1.00  0.00           H  
ATOM    768  HA2 GLY A  63      19.535   6.069   6.409  1.00  0.00           H  
ATOM    769  HA3 GLY A  63      21.190   6.627   6.219  1.00  0.00           H  
ATOM    770  N   ARG A  64      19.366   7.067   3.561  1.00  0.00           N  
ATOM    771  CA  ARG A  64      18.998   8.073   2.540  1.00  0.00           C  
ATOM    772  C   ARG A  64      17.941   7.548   1.561  1.00  0.00           C  
ATOM    773  O   ARG A  64      17.698   6.340   1.466  1.00  0.00           O  
ATOM    774  CB  ARG A  64      20.275   8.543   1.796  1.00  0.00           C  
ATOM    775  CG  ARG A  64      21.025   7.411   1.075  1.00  0.00           C  
ATOM    776  CD  ARG A  64      22.386   7.849   0.525  1.00  0.00           C  
ATOM    777  NE  ARG A  64      22.276   8.970  -0.436  1.00  0.00           N  
ATOM    778  CZ  ARG A  64      22.588   8.919  -1.741  1.00  0.00           C  
ATOM    779  NH1 ARG A  64      22.935   7.778  -2.324  1.00  0.00           N  
ATOM    780  NH2 ARG A  64      22.518  10.025  -2.466  1.00  0.00           N  
ATOM    781  H   ARG A  64      19.259   6.117   3.344  1.00  0.00           H  
ATOM    782  HA  ARG A  64      18.558   8.928   3.053  1.00  0.00           H  
ATOM    783  HB2 ARG A  64      20.005   9.300   1.062  1.00  0.00           H  
ATOM    784  HB3 ARG A  64      20.948   8.993   2.520  1.00  0.00           H  
ATOM    785  HG2 ARG A  64      21.182   6.593   1.773  1.00  0.00           H  
ATOM    786  HG3 ARG A  64      20.413   7.053   0.250  1.00  0.00           H  
ATOM    787  HD2 ARG A  64      23.008   8.164   1.358  1.00  0.00           H  
ATOM    788  HD3 ARG A  64      22.854   6.997   0.040  1.00  0.00           H  
ATOM    789  HE  ARG A  64      21.976   9.832  -0.070  1.00  0.00           H  
ATOM    790 HH11 ARG A  64      22.965   6.922  -1.788  1.00  0.00           H  
ATOM    791 HH12 ARG A  64      23.174   7.756  -3.295  1.00  0.00           H  
ATOM    792 HH21 ARG A  64      22.234  10.888  -2.039  1.00  0.00           H  
ATOM    793 HH22 ARG A  64      22.763  10.009  -3.439  1.00  0.00           H  
ATOM    794  N   THR A  65      17.344   8.494   0.824  1.00  0.00           N  
ATOM    795  CA  THR A  65      16.280   8.243  -0.137  1.00  0.00           C  
ATOM    796  C   THR A  65      16.884   7.891  -1.507  1.00  0.00           C  
ATOM    797  O   THR A  65      17.642   8.689  -2.072  1.00  0.00           O  
ATOM    798  CB  THR A  65      15.383   9.524  -0.248  1.00  0.00           C  
ATOM    799  OG1 THR A  65      15.237  10.129   1.048  1.00  0.00           O  
ATOM    800  CG2 THR A  65      14.002   9.192  -0.769  1.00  0.00           C  
ATOM    801  H   THR A  65      17.619   9.421   0.951  1.00  0.00           H  
ATOM    802  HA  THR A  65      15.670   7.413   0.221  1.00  0.00           H  
ATOM    803  HB  THR A  65      15.843  10.237  -0.926  1.00  0.00           H  
ATOM    804  HG1 THR A  65      14.971  11.049   0.944  1.00  0.00           H  
ATOM    805 HG21 THR A  65      13.514   8.526  -0.073  1.00  0.00           H  
ATOM    806 HG22 THR A  65      14.081   8.705  -1.731  1.00  0.00           H  
ATOM    807 HG23 THR A  65      13.419  10.094  -0.870  1.00  0.00           H  
ATOM    808  N   TYR A  66      16.551   6.701  -2.038  1.00  0.00           N  
ATOM    809  CA  TYR A  66      17.163   6.185  -3.276  1.00  0.00           C  
ATOM    810  C   TYR A  66      16.091   5.698  -4.269  1.00  0.00           C  
ATOM    811  O   TYR A  66      14.972   5.345  -3.876  1.00  0.00           O  
ATOM    812  CB  TYR A  66      18.146   5.037  -2.923  1.00  0.00           C  
ATOM    813  CG  TYR A  66      19.157   4.706  -4.034  1.00  0.00           C  
ATOM    814  CD1 TYR A  66      20.198   5.591  -4.321  1.00  0.00           C  
ATOM    815  CD2 TYR A  66      19.083   3.529  -4.788  1.00  0.00           C  
ATOM    816  CE1 TYR A  66      21.119   5.318  -5.309  1.00  0.00           C  
ATOM    817  CE2 TYR A  66      20.006   3.254  -5.775  1.00  0.00           C  
ATOM    818  CZ  TYR A  66      21.022   4.152  -6.031  1.00  0.00           C  
ATOM    819  OH  TYR A  66      21.938   3.891  -7.027  1.00  0.00           O  
ATOM    820  H   TYR A  66      15.887   6.145  -1.575  1.00  0.00           H  
ATOM    821  HA  TYR A  66      17.722   6.996  -3.751  1.00  0.00           H  
ATOM    822  HB2 TYR A  66      18.711   5.314  -2.039  1.00  0.00           H  
ATOM    823  HB3 TYR A  66      17.578   4.138  -2.700  1.00  0.00           H  
ATOM    824  HD1 TYR A  66      20.281   6.511  -3.753  1.00  0.00           H  
ATOM    825  HD2 TYR A  66      18.281   2.824  -4.591  1.00  0.00           H  
ATOM    826  HE1 TYR A  66      21.916   6.020  -5.509  1.00  0.00           H  
ATOM    827  HE2 TYR A  66      19.931   2.335  -6.344  1.00  0.00           H  
ATOM    828  HH  TYR A  66      22.827   4.084  -6.705  1.00  0.00           H  
ATOM    829  N   TRP A  67      16.486   5.670  -5.555  1.00  0.00           N  
ATOM    830  CA  TRP A  67      15.632   5.274  -6.684  1.00  0.00           C  
ATOM    831  C   TRP A  67      15.531   3.739  -6.762  1.00  0.00           C  
ATOM    832  O   TRP A  67      16.542   3.069  -7.001  1.00  0.00           O  
ATOM    833  CB  TRP A  67      16.235   5.826  -8.013  1.00  0.00           C  
ATOM    834  CG  TRP A  67      16.521   7.310  -8.016  1.00  0.00           C  
ATOM    835  CD1 TRP A  67      15.674   8.304  -8.398  1.00  0.00           C  
ATOM    836  CD2 TRP A  67      17.749   7.961  -7.644  1.00  0.00           C  
ATOM    837  NE1 TRP A  67      16.276   9.520  -8.254  1.00  0.00           N  
ATOM    838  CE2 TRP A  67      17.550   9.342  -7.800  1.00  0.00           C  
ATOM    839  CE3 TRP A  67      18.987   7.509  -7.183  1.00  0.00           C  
ATOM    840  CZ2 TRP A  67      18.542  10.276  -7.515  1.00  0.00           C  
ATOM    841  CZ3 TRP A  67      19.977   8.432  -6.906  1.00  0.00           C  
ATOM    842  CH2 TRP A  67      19.749   9.805  -7.068  1.00  0.00           C  
ATOM    843  H   TRP A  67      17.407   5.923  -5.754  1.00  0.00           H  
ATOM    844  HA  TRP A  67      14.645   5.701  -6.535  1.00  0.00           H  
ATOM    845  HB2 TRP A  67      17.171   5.321  -8.217  1.00  0.00           H  
ATOM    846  HB3 TRP A  67      15.548   5.619  -8.827  1.00  0.00           H  
ATOM    847  HD1 TRP A  67      14.663   8.142  -8.742  1.00  0.00           H  
ATOM    848  HE1 TRP A  67      15.859  10.381  -8.455  1.00  0.00           H  
ATOM    849  HE3 TRP A  67      19.180   6.451  -7.052  1.00  0.00           H  
ATOM    850  HZ2 TRP A  67      18.377  11.340  -7.633  1.00  0.00           H  
ATOM    851  HZ3 TRP A  67      20.944   8.095  -6.552  1.00  0.00           H  
ATOM    852  HH2 TRP A  67      20.551  10.495  -6.840  1.00  0.00           H  
ATOM    853  N   VAL A  68      14.320   3.184  -6.535  1.00  0.00           N  
ATOM    854  CA  VAL A  68      14.070   1.725  -6.642  1.00  0.00           C  
ATOM    855  C   VAL A  68      12.852   1.448  -7.538  1.00  0.00           C  
ATOM    856  O   VAL A  68      11.956   2.284  -7.663  1.00  0.00           O  
ATOM    857  CB  VAL A  68      13.874   1.030  -5.236  1.00  0.00           C  
ATOM    858  CG1 VAL A  68      15.041   1.354  -4.267  1.00  0.00           C  
ATOM    859  CG2 VAL A  68      12.505   1.378  -4.615  1.00  0.00           C  
ATOM    860  H   VAL A  68      13.573   3.768  -6.292  1.00  0.00           H  
ATOM    861  HA  VAL A  68      14.940   1.271  -7.117  1.00  0.00           H  
ATOM    862  HB  VAL A  68      13.891  -0.051  -5.402  1.00  0.00           H  
ATOM    863 HG11 VAL A  68      15.981   1.035  -4.702  1.00  0.00           H  
ATOM    864 HG12 VAL A  68      14.895   0.836  -3.326  1.00  0.00           H  
ATOM    865 HG13 VAL A  68      15.078   2.422  -4.081  1.00  0.00           H  
ATOM    866 HG21 VAL A  68      12.409   0.907  -3.642  1.00  0.00           H  
ATOM    867 HG22 VAL A  68      11.710   1.021  -5.262  1.00  0.00           H  
ATOM    868 HG23 VAL A  68      12.416   2.450  -4.503  1.00  0.00           H  
ATOM    869  N   HIS A  69      12.820   0.245  -8.125  1.00  0.00           N  
ATOM    870  CA  HIS A  69      11.778  -0.172  -9.083  1.00  0.00           C  
ATOM    871  C   HIS A  69      10.602  -0.820  -8.337  1.00  0.00           C  
ATOM    872  O   HIS A  69      10.817  -1.511  -7.334  1.00  0.00           O  
ATOM    873  CB  HIS A  69      12.390  -1.170 -10.099  1.00  0.00           C  
ATOM    874  CG  HIS A  69      11.513  -1.474 -11.284  1.00  0.00           C  
ATOM    875  ND1 HIS A  69      10.882  -2.685 -11.474  1.00  0.00           N  
ATOM    876  CD2 HIS A  69      11.190  -0.718 -12.357  1.00  0.00           C  
ATOM    877  CE1 HIS A  69      10.216  -2.659 -12.613  1.00  0.00           C  
ATOM    878  NE2 HIS A  69      10.388  -1.480 -13.167  1.00  0.00           N  
ATOM    879  H   HIS A  69      13.523  -0.393  -7.898  1.00  0.00           H  
ATOM    880  HA  HIS A  69      11.427   0.710  -9.615  1.00  0.00           H  
ATOM    881  HB2 HIS A  69      13.317  -0.759 -10.482  1.00  0.00           H  
ATOM    882  HB3 HIS A  69      12.613  -2.108  -9.597  1.00  0.00           H  
ATOM    883  HD1 HIS A  69      10.947  -3.463 -10.884  1.00  0.00           H  
ATOM    884  HD2 HIS A  69      11.508   0.300 -12.544  1.00  0.00           H  
ATOM    885  HE1 HIS A  69       9.626  -3.470 -13.021  1.00  0.00           H  
ATOM    886  HE2 HIS A  69      10.108  -1.240 -14.076  1.00  0.00           H  
ATOM    887  N   TRP A  70       9.374  -0.635  -8.871  1.00  0.00           N  
ATOM    888  CA  TRP A  70       8.127  -1.120  -8.236  1.00  0.00           C  
ATOM    889  C   TRP A  70       8.113  -2.650  -8.050  1.00  0.00           C  
ATOM    890  O   TRP A  70       7.700  -3.135  -7.003  1.00  0.00           O  
ATOM    891  CB  TRP A  70       6.880  -0.698  -9.047  1.00  0.00           C  
ATOM    892  CG  TRP A  70       6.648   0.791  -9.117  1.00  0.00           C  
ATOM    893  CD1 TRP A  70       6.834   1.603 -10.198  1.00  0.00           C  
ATOM    894  CD2 TRP A  70       6.175   1.641  -8.057  1.00  0.00           C  
ATOM    895  NE1 TRP A  70       6.519   2.896  -9.883  1.00  0.00           N  
ATOM    896  CE2 TRP A  70       6.105   2.946  -8.577  1.00  0.00           C  
ATOM    897  CE3 TRP A  70       5.799   1.423  -6.722  1.00  0.00           C  
ATOM    898  CZ2 TRP A  70       5.682   4.025  -7.814  1.00  0.00           C  
ATOM    899  CZ3 TRP A  70       5.380   2.501  -5.964  1.00  0.00           C  
ATOM    900  CH2 TRP A  70       5.321   3.786  -6.513  1.00  0.00           C  
ATOM    901  H   TRP A  70       9.303  -0.139  -9.713  1.00  0.00           H  
ATOM    902  HA  TRP A  70       8.067  -0.656  -7.254  1.00  0.00           H  
ATOM    903  HB2 TRP A  70       6.971  -1.073 -10.059  1.00  0.00           H  
ATOM    904  HB3 TRP A  70       5.995  -1.142  -8.596  1.00  0.00           H  
ATOM    905  HD1 TRP A  70       7.195   1.263 -11.160  1.00  0.00           H  
ATOM    906  HE1 TRP A  70       6.585   3.659 -10.499  1.00  0.00           H  
ATOM    907  HE3 TRP A  70       5.836   0.435  -6.283  1.00  0.00           H  
ATOM    908  HZ2 TRP A  70       5.631   5.026  -8.222  1.00  0.00           H  
ATOM    909  HZ3 TRP A  70       5.088   2.354  -4.931  1.00  0.00           H  
ATOM    910  HH2 TRP A  70       4.988   4.605  -5.882  1.00  0.00           H  
ATOM    911  N   HIS A  71       8.573  -3.409  -9.067  1.00  0.00           N  
ATOM    912  CA  HIS A  71       8.536  -4.894  -9.024  1.00  0.00           C  
ATOM    913  C   HIS A  71       9.491  -5.450  -7.940  1.00  0.00           C  
ATOM    914  O   HIS A  71       9.287  -6.554  -7.434  1.00  0.00           O  
ATOM    915  CB  HIS A  71       8.864  -5.501 -10.414  1.00  0.00           C  
ATOM    916  CG  HIS A  71       8.453  -6.948 -10.596  1.00  0.00           C  
ATOM    917  ND1 HIS A  71       8.731  -7.664 -11.740  1.00  0.00           N  
ATOM    918  CD2 HIS A  71       7.722  -7.782  -9.813  1.00  0.00           C  
ATOM    919  CE1 HIS A  71       8.184  -8.862 -11.650  1.00  0.00           C  
ATOM    920  NE2 HIS A  71       7.569  -8.957 -10.494  1.00  0.00           N  
ATOM    921  H   HIS A  71       8.926  -2.965  -9.865  1.00  0.00           H  
ATOM    922  HA  HIS A  71       7.520  -5.180  -8.755  1.00  0.00           H  
ATOM    923  HB2 HIS A  71       8.353  -4.929 -11.179  1.00  0.00           H  
ATOM    924  HB3 HIS A  71       9.928  -5.436 -10.592  1.00  0.00           H  
ATOM    925  HD1 HIS A  71       9.267  -7.351 -12.499  1.00  0.00           H  
ATOM    926  HD2 HIS A  71       7.324  -7.553  -8.831  1.00  0.00           H  
ATOM    927  HE1 HIS A  71       8.213  -9.630 -12.408  1.00  0.00           H  
ATOM    928  HE2 HIS A  71       7.206  -9.790 -10.119  1.00  0.00           H  
ATOM    929  N   MET A  72      10.532  -4.667  -7.594  1.00  0.00           N  
ATOM    930  CA  MET A  72      11.477  -5.023  -6.514  1.00  0.00           C  
ATOM    931  C   MET A  72      11.149  -4.281  -5.205  1.00  0.00           C  
ATOM    932  O   MET A  72      11.797  -4.514  -4.178  1.00  0.00           O  
ATOM    933  CB  MET A  72      12.938  -4.787  -6.976  1.00  0.00           C  
ATOM    934  CG  MET A  72      13.411  -5.800  -8.035  1.00  0.00           C  
ATOM    935  SD  MET A  72      15.101  -5.510  -8.606  1.00  0.00           S  
ATOM    936  CE  MET A  72      14.950  -3.922  -9.424  1.00  0.00           C  
ATOM    937  H   MET A  72      10.660  -3.818  -8.062  1.00  0.00           H  
ATOM    938  HA  MET A  72      11.354  -6.087  -6.310  1.00  0.00           H  
ATOM    939  HB2 MET A  72      13.023  -3.789  -7.393  1.00  0.00           H  
ATOM    940  HB3 MET A  72      13.603  -4.862  -6.119  1.00  0.00           H  
ATOM    941  HG2 MET A  72      13.367  -6.794  -7.610  1.00  0.00           H  
ATOM    942  HG3 MET A  72      12.743  -5.753  -8.889  1.00  0.00           H  
ATOM    943  HE1 MET A  72      14.217  -3.987 -10.213  1.00  0.00           H  
ATOM    944  HE2 MET A  72      15.906  -3.643  -9.838  1.00  0.00           H  
ATOM    945  HE3 MET A  72      14.640  -3.171  -8.704  1.00  0.00           H  
ATOM    946  N   LEU A  73      10.120  -3.423  -5.245  1.00  0.00           N  
ATOM    947  CA  LEU A  73       9.570  -2.766  -4.055  1.00  0.00           C  
ATOM    948  C   LEU A  73       8.412  -3.637  -3.527  1.00  0.00           C  
ATOM    949  O   LEU A  73       7.445  -3.909  -4.239  1.00  0.00           O  
ATOM    950  CB  LEU A  73       9.110  -1.310  -4.413  1.00  0.00           C  
ATOM    951  CG  LEU A  73       8.858  -0.302  -3.231  1.00  0.00           C  
ATOM    952  CD1 LEU A  73       7.551  -0.586  -2.463  1.00  0.00           C  
ATOM    953  CD2 LEU A  73      10.070  -0.258  -2.275  1.00  0.00           C  
ATOM    954  H   LEU A  73       9.702  -3.235  -6.106  1.00  0.00           H  
ATOM    955  HA  LEU A  73      10.353  -2.716  -3.298  1.00  0.00           H  
ATOM    956  HB2 LEU A  73       9.869  -0.876  -5.052  1.00  0.00           H  
ATOM    957  HB3 LEU A  73       8.196  -1.375  -4.997  1.00  0.00           H  
ATOM    958  HG  LEU A  73       8.754   0.691  -3.653  1.00  0.00           H  
ATOM    959 HD11 LEU A  73       7.396   0.177  -1.712  1.00  0.00           H  
ATOM    960 HD12 LEU A  73       7.610  -1.556  -1.982  1.00  0.00           H  
ATOM    961 HD13 LEU A  73       6.720  -0.581  -3.155  1.00  0.00           H  
ATOM    962 HD21 LEU A  73      10.210  -1.226  -1.807  1.00  0.00           H  
ATOM    963 HD22 LEU A  73       9.900   0.487  -1.507  1.00  0.00           H  
ATOM    964 HD23 LEU A  73      10.958   0.004  -2.828  1.00  0.00           H  
ATOM    965  N   GLU A  74       8.546  -4.073  -2.278  1.00  0.00           N  
ATOM    966  CA  GLU A  74       7.533  -4.849  -1.543  1.00  0.00           C  
ATOM    967  C   GLU A  74       7.050  -4.011  -0.352  1.00  0.00           C  
ATOM    968  O   GLU A  74       7.779  -3.143   0.113  1.00  0.00           O  
ATOM    969  CB  GLU A  74       8.165  -6.194  -1.068  1.00  0.00           C  
ATOM    970  CG  GLU A  74       7.266  -7.076  -0.173  1.00  0.00           C  
ATOM    971  CD  GLU A  74       7.887  -8.447   0.148  1.00  0.00           C  
ATOM    972  OE1 GLU A  74       8.920  -8.494   0.848  1.00  0.00           O  
ATOM    973  OE2 GLU A  74       7.358  -9.484  -0.316  1.00  0.00           O  
ATOM    974  H   GLU A  74       9.370  -3.853  -1.811  1.00  0.00           H  
ATOM    975  HA  GLU A  74       6.695  -5.054  -2.202  1.00  0.00           H  
ATOM    976  HB2 GLU A  74       8.428  -6.773  -1.946  1.00  0.00           H  
ATOM    977  HB3 GLU A  74       9.081  -5.977  -0.521  1.00  0.00           H  
ATOM    978  HG2 GLU A  74       7.084  -6.551   0.763  1.00  0.00           H  
ATOM    979  HG3 GLU A  74       6.315  -7.222  -0.676  1.00  0.00           H  
ATOM    980  N   ILE A  75       5.803  -4.204   0.100  1.00  0.00           N  
ATOM    981  CA  ILE A  75       5.322  -3.627   1.378  1.00  0.00           C  
ATOM    982  C   ILE A  75       5.015  -4.738   2.395  1.00  0.00           C  
ATOM    983  O   ILE A  75       4.226  -5.648   2.120  1.00  0.00           O  
ATOM    984  CB  ILE A  75       4.080  -2.677   1.186  1.00  0.00           C  
ATOM    985  CG1 ILE A  75       2.990  -3.334   0.275  1.00  0.00           C  
ATOM    986  CG2 ILE A  75       4.547  -1.316   0.629  1.00  0.00           C  
ATOM    987  CD1 ILE A  75       1.748  -2.491   0.054  1.00  0.00           C  
ATOM    988  H   ILE A  75       5.192  -4.765  -0.426  1.00  0.00           H  
ATOM    989  HA  ILE A  75       6.136  -3.020   1.795  1.00  0.00           H  
ATOM    990  HB  ILE A  75       3.649  -2.486   2.168  1.00  0.00           H  
ATOM    991 HG12 ILE A  75       3.414  -3.538  -0.701  1.00  0.00           H  
ATOM    992 HG13 ILE A  75       2.675  -4.269   0.719  1.00  0.00           H  
ATOM    993 HG21 ILE A  75       3.701  -0.646   0.521  1.00  0.00           H  
ATOM    994 HG22 ILE A  75       5.013  -1.458  -0.338  1.00  0.00           H  
ATOM    995 HG23 ILE A  75       5.268  -0.871   1.306  1.00  0.00           H  
ATOM    996 HD11 ILE A  75       1.047  -3.045  -0.555  1.00  0.00           H  
ATOM    997 HD12 ILE A  75       2.014  -1.573  -0.457  1.00  0.00           H  
ATOM    998 HD13 ILE A  75       1.292  -2.256   1.005  1.00  0.00           H  
ATOM    999  N   LEU A  76       5.671  -4.659   3.564  1.00  0.00           N  
ATOM   1000  CA  LEU A  76       5.416  -5.550   4.717  1.00  0.00           C  
ATOM   1001  C   LEU A  76       5.013  -4.711   5.950  1.00  0.00           C  
ATOM   1002  O   LEU A  76       4.843  -5.252   7.045  1.00  0.00           O  
ATOM   1003  CB  LEU A  76       6.671  -6.420   5.037  1.00  0.00           C  
ATOM   1004  CG  LEU A  76       7.143  -7.415   3.924  1.00  0.00           C  
ATOM   1005  CD1 LEU A  76       8.364  -8.239   4.393  1.00  0.00           C  
ATOM   1006  CD2 LEU A  76       5.999  -8.344   3.460  1.00  0.00           C  
ATOM   1007  H   LEU A  76       6.350  -3.957   3.668  1.00  0.00           H  
ATOM   1008  HA  LEU A  76       4.585  -6.206   4.473  1.00  0.00           H  
ATOM   1009  HB2 LEU A  76       7.496  -5.747   5.256  1.00  0.00           H  
ATOM   1010  HB3 LEU A  76       6.464  -6.995   5.938  1.00  0.00           H  
ATOM   1011  HG  LEU A  76       7.461  -6.840   3.059  1.00  0.00           H  
ATOM   1012 HD11 LEU A  76       8.690  -8.891   3.591  1.00  0.00           H  
ATOM   1013 HD12 LEU A  76       8.102  -8.839   5.256  1.00  0.00           H  
ATOM   1014 HD13 LEU A  76       9.175  -7.571   4.655  1.00  0.00           H  
ATOM   1015 HD21 LEU A  76       5.194  -7.748   3.052  1.00  0.00           H  
ATOM   1016 HD22 LEU A  76       5.629  -8.925   4.297  1.00  0.00           H  
ATOM   1017 HD23 LEU A  76       6.364  -9.016   2.691  1.00  0.00           H  
ATOM   1018  N   GLY A  77       4.891  -3.380   5.745  1.00  0.00           N  
ATOM   1019  CA  GLY A  77       4.451  -2.447   6.785  1.00  0.00           C  
ATOM   1020  C   GLY A  77       2.978  -2.611   7.156  1.00  0.00           C  
ATOM   1021  O   GLY A  77       2.660  -2.838   8.335  1.00  0.00           O  
ATOM   1022  H   GLY A  77       5.111  -3.025   4.863  1.00  0.00           H  
ATOM   1023  HA2 GLY A  77       5.063  -2.586   7.665  1.00  0.00           H  
ATOM   1024  HA3 GLY A  77       4.603  -1.442   6.421  1.00  0.00           H  
TER    1025      GLY A  77                                                      
END
MOLECULE T0462_1_74.pdb
ATOM      1  C   MET     1       3.518  -5.525  -1.015  1.00 72.54           C 
ATOM      2  O   MET     1       4.514  -5.922  -0.421  1.00 61.43           O 
ATOM      3  N   MET     1       1.797  -7.249  -0.416  1.00 62.03           N 
ATOM      4  CA  MET     1       2.106  -5.791  -0.468  1.00  1.42           C 
ATOM      5  CB  MET     1       1.945  -5.166   0.931  1.00  3.15           C 
ATOM      6  CG  MET     1       2.652  -3.826   1.103  1.00 20.23           C 
ATOM      7  SD  MET     1       2.005  -2.537   0.021  1.00  4.24           S 
ATOM      8  CE  MET     1       0.587  -1.980   0.962  1.00 12.22           C 
ATOM      9 1H   MET     1       2.447  -7.731   0.242  1.00 36.29           H 
ATOM     10 2H   MET     1       1.909  -7.674  -1.357  1.00 36.29           H 
ATOM     11 3H   MET     1       0.818  -7.396  -0.095  1.00 36.29           H 
ATOM     12  HA  MET     1       1.390  -5.330  -1.136  1.00  4.22           H 
ATOM     13 3HB  MET     1       2.337  -5.854   1.668  1.00 36.29           H 
ATOM     14 2HB  MET     1       0.892  -5.015   1.123  1.00 36.29           H 
ATOM     15 3HG  MET     1       3.702  -3.962   0.888  1.00 36.29           H 
ATOM     16 2HG  MET     1       2.538  -3.502   2.127  1.00 36.29           H 
ATOM     17 1HE  MET     1      -0.112  -2.794   1.079  1.00 36.29           H 
ATOM     18 2HE  MET     1       0.108  -1.165   0.439  1.00 36.29           H 
ATOM     19 3HE  MET     1       0.911  -1.640   1.935  1.00 36.29           H 
ATOM     20  N   LYS     2       3.591  -4.846  -2.158  1.00  4.01           N 
ATOM     21  CA  LYS     2       4.874  -4.436  -2.746  1.00 14.04           C 
ATOM     22  C   LYS     2       5.042  -2.911  -2.669  1.00 71.54           C 
ATOM     23  O   LYS     2       4.069  -2.166  -2.787  1.00  5.03           O 
ATOM     24  CB  LYS     2       4.982  -4.912  -4.207  1.00 41.30           C 
ATOM     25  CG  LYS     2       5.651  -6.277  -4.378  1.00 35.55           C 
ATOM     26  CD  LYS     2       4.888  -7.412  -3.703  1.00 24.21           C 
ATOM     27  CE  LYS     2       5.601  -8.746  -3.913  1.00 54.20           C 
ATOM     28  NZ  LYS     2       4.888  -9.880  -3.264  1.00 23.11           N 
ATOM     29  H   LYS     2       2.763  -4.602  -2.617  1.00 36.29           H 
ATOM     30  HA  LYS     2       5.666  -4.897  -2.168  1.00 52.45           H 
ATOM     31 3HB  LYS     2       5.556  -4.188  -4.770  1.00 36.29           H 
ATOM     32 2HB  LYS     2       3.989  -4.969  -4.631  1.00 36.29           H 
ATOM     33 3HG  LYS     2       6.647  -6.227  -3.957  1.00 36.29           H 
ATOM     34 2HG  LYS     2       5.724  -6.494  -5.433  1.00 36.29           H 
ATOM     35 3HD  LYS     2       3.895  -7.473  -4.126  1.00 36.29           H 
ATOM     36 2HD  LYS     2       4.822  -7.212  -2.644  1.00 36.29           H 
ATOM     37 3HE  LYS     2       6.597  -8.675  -3.499  1.00 36.29           H 
ATOM     38 2HE  LYS     2       5.669  -8.940  -4.973  1.00 36.29           H 
ATOM     39 1HZ  LYS     2       4.773  -9.696  -2.246  1.00 36.29           H 
ATOM     40 2HZ  LYS     2       5.434 -10.759  -3.385  1.00 36.29           H 
ATOM     41 3HZ  LYS     2       3.951 -10.007  -3.690  1.00 36.29           H 
ATOM     42  N   LEU     3       6.279  -2.445  -2.492  1.00 54.05           N 
ATOM     43  CA  LEU     3       6.551  -1.006  -2.322  1.00 12.34           C 
ATOM     44  C   LEU     3       6.221  -0.190  -3.591  1.00 75.43           C 
ATOM     45  O   LEU     3       6.193   1.039  -3.556  1.00 30.52           O 
ATOM     46  CB  LEU     3       8.016  -0.794  -1.890  1.00 44.12           C 
ATOM     47  CG  LEU     3       9.093  -1.161  -2.934  1.00 51.02           C 
ATOM     48  CD1 LEU     3       9.466   0.048  -3.795  1.00 31.15           C 
ATOM     49  CD2 LEU     3      10.332  -1.742  -2.258  1.00 12.10           C 
ATOM     50  H   LEU     3       7.028  -3.081  -2.468  1.00 36.29           H 
ATOM     51  HA  LEU     3       5.909  -0.654  -1.524  1.00 75.20           H 
ATOM     52 3HB  LEU     3       8.188  -1.389  -1.004  1.00 36.29           H 
ATOM     53 2HB  LEU     3       8.140   0.246  -1.624  1.00 36.29           H 
ATOM     54  HG  LEU     3       8.695  -1.919  -3.597  1.00 53.15           H 
ATOM     55 1HD1 LEU     3       9.859   0.832  -3.164  1.00 36.29           H 
ATOM     56 2HD1 LEU     3       8.590   0.408  -4.313  1.00 36.29           H 
ATOM     57 3HD1 LEU     3      10.216  -0.241  -4.517  1.00 36.29           H 
ATOM     58 1HD2 LEU     3      11.058  -2.020  -3.009  1.00 36.29           H 
ATOM     59 2HD2 LEU     3      10.056  -2.616  -1.686  1.00 36.29           H 
ATOM     60 3HD2 LEU     3      10.765  -1.004  -1.598  1.00 36.29           H 
ATOM     61  N   SER     4       5.945  -0.883  -4.701  1.00  4.23           N 
ATOM     62  CA  SER     4       5.589  -0.227  -5.974  1.00 32.21           C 
ATOM     63  C   SER     4       4.229   0.480  -5.900  1.00 20.35           C 
ATOM     64  O   SER     4       3.854   1.213  -6.814  1.00 13.44           O 
ATOM     65  CB  SER     4       5.543  -1.258  -7.115  1.00 23.31           C 
ATOM     66  OG  SER     4       4.601  -2.291  -6.849  1.00 33.45           O 
ATOM     67  H   SER     4       5.981  -1.860  -4.667  1.00 36.29           H 
ATOM     68  HA  SER     4       6.351   0.505  -6.197  1.00  2.13           H 
ATOM     69 3HB  SER     4       6.518  -1.702  -7.235  1.00 36.29           H 
ATOM     70 2HB  SER     4       5.263  -0.764  -8.033  1.00 36.29           H 
ATOM     71  HG  SER     4       4.753  -3.024  -7.464  1.00 23.50           H 
ATOM     72  N   ARG     5       3.493   0.245  -4.816  1.00 74.24           N 
ATOM     73  CA  ARG     5       2.136   0.783  -4.660  1.00 65.23           C 
ATOM     74  C   ARG     5       1.911   1.351  -3.250  1.00 50.53           C 
ATOM     75  O   ARG     5       0.779   1.617  -2.853  1.00  3.14           O 
ATOM     76  CB  ARG     5       1.136  -0.345  -4.937  1.00 32.44           C 
ATOM     77  CG  ARG     5       1.216  -1.485  -3.918  1.00 60.24           C 
ATOM     78  CD  ARG     5       0.735  -2.805  -4.499  1.00 44.11           C 
ATOM     79  NE  ARG     5       1.633  -3.289  -5.550  1.00 13.55           N 
ATOM     80  CZ  ARG     5       1.739  -4.539  -5.905  1.00 12.44           C 
ATOM     81  NH1 ARG     5       0.990  -5.444  -5.364  1.00 63.34           N 
ATOM     82  NH2 ARG     5       2.586  -4.888  -6.812  1.00 21.53           N 
ATOM     83  H   ARG     5       3.864  -0.317  -4.107  1.00 36.29           H 
ATOM     84  HA  ARG     5       1.992   1.572  -5.386  1.00 64.21           H 
ATOM     85 3HB  ARG     5       1.332  -0.751  -5.919  1.00 36.29           H 
ATOM     86 2HB  ARG     5       0.133   0.062  -4.919  1.00 36.29           H 
ATOM     87 3HG  ARG     5       0.606  -1.234  -3.062  1.00 36.29           H 
ATOM     88 2HG  ARG     5       2.244  -1.601  -3.602  1.00 36.29           H 
ATOM     89 3HD  ARG     5      -0.252  -2.667  -4.916  1.00 36.29           H 
ATOM     90 2HD  ARG     5       0.692  -3.538  -3.704  1.00 36.29           H 
ATOM     91  HE  ARG     5       2.201  -2.632  -5.999  1.00 75.30           H 
ATOM     92 1HH1 ARG     5       0.323  -5.193  -4.674  1.00 36.29           H 
ATOM     93 2HH1 ARG     5       1.098  -6.403  -5.639  1.00 36.29           H 
ATOM     94 1HH2 ARG     5       3.168  -4.207  -7.248  1.00 36.29           H 
ATOM     95 2HH2 ARG     5       2.657  -5.850  -7.075  1.00 36.29           H 
ATOM     96  N   LEU     6       2.994   1.542  -2.504  1.00 24.41           N 
ATOM     97  CA  LEU     6       2.903   1.977  -1.106  1.00 73.40           C 
ATOM     98  C   LEU     6       2.620   3.487  -1.005  1.00 51.45           C 
ATOM     99  O   LEU     6       3.285   4.299  -1.650  1.00 72.11           O 
ATOM    100  CB  LEU     6       4.204   1.628  -0.365  1.00 50.13           C 
ATOM    101  CG  LEU     6       4.178   1.842   1.158  1.00 51.54           C 
ATOM    102  CD1 LEU     6       3.193   0.885   1.826  1.00 34.05           C 
ATOM    103  CD2 LEU     6       5.578   1.679   1.747  1.00 44.04           C 
ATOM    104  H   LEU     6       3.878   1.408  -2.906  1.00 36.29           H 
ATOM    105  HA  LEU     6       2.084   1.437  -0.646  1.00 14.43           H 
ATOM    106 3HB  LEU     6       5.001   2.232  -0.778  1.00 36.29           H 
ATOM    107 2HB  LEU     6       4.434   0.589  -0.557  1.00 36.29           H 
ATOM    108  HG  LEU     6       3.846   2.847   1.364  1.00 12.14           H 
ATOM    109 1HD1 LEU     6       3.477  -0.136   1.615  1.00 36.29           H 
ATOM    110 2HD1 LEU     6       2.198   1.068   1.446  1.00 36.29           H 
ATOM    111 3HD1 LEU     6       3.202   1.047   2.895  1.00 36.29           H 
ATOM    112 1HD2 LEU     6       6.248   2.391   1.286  1.00 36.29           H 
ATOM    113 2HD2 LEU     6       5.935   0.676   1.561  1.00 36.29           H 
ATOM    114 3HD2 LEU     6       5.545   1.855   2.812  1.00 36.29           H 
ATOM    115  N   VAL     7       1.629   3.852  -0.188  1.00 44.11           N 
ATOM    116  CA  VAL     7       1.229   5.255  -0.013  1.00 52.30           C 
ATOM    117  C   VAL     7       2.399   6.130   0.495  1.00 41.41           C 
ATOM    118  O   VAL     7       2.938   5.888   1.576  1.00 15.11           O 
ATOM    119  CB  VAL     7       0.034   5.378   0.975  1.00 14.11           C 
ATOM    120  CG1 VAL     7      -0.397   6.838   1.141  1.00 51.14           C 
ATOM    121  CG2 VAL     7      -1.143   4.512   0.514  1.00 52.40           C 
ATOM    122  H   VAL     7       1.148   3.158   0.308  1.00 36.29           H 
ATOM    123  HA  VAL     7       0.906   5.628  -0.977  1.00 34.04           H 
ATOM    124  HB  VAL     7       0.357   5.016   1.940  1.00 41.14           H 
ATOM    125 1HG1 VAL     7       0.428   7.416   1.532  1.00 36.29           H 
ATOM    126 2HG1 VAL     7      -1.230   6.895   1.828  1.00 36.29           H 
ATOM    127 3HG1 VAL     7      -0.695   7.239   0.183  1.00 36.29           H 
ATOM    128 1HG2 VAL     7      -1.458   4.821  -0.472  1.00 36.29           H 
ATOM    129 2HG2 VAL     7      -1.969   4.620   1.205  1.00 36.29           H 
ATOM    130 3HG2 VAL     7      -0.837   3.475   0.483  1.00 36.29           H 
ATOM    131  N   PRO     8       2.802   7.162  -0.282  1.00 23.31           N 
ATOM    132  CA  PRO     8       3.902   8.073   0.102  1.00 61.14           C 
ATOM    133  C   PRO     8       3.752   8.648   1.526  1.00 24.12           C 
ATOM    134  O   PRO     8       2.852   9.448   1.798  1.00 15.04           O 
ATOM    135  CB  PRO     8       3.814   9.190  -0.945  1.00 34.35           C 
ATOM    136  CG  PRO     8       3.204   8.534  -2.139  1.00 22.30           C 
ATOM    137  CD  PRO     8       2.231   7.517  -1.600  1.00  0.40           C 
ATOM    138  HA  PRO     8       4.861   7.578   0.020  1.00 12.00           H 
ATOM    139 3HB  PRO     8       4.805   9.565  -1.163  1.00 36.29           H 
ATOM    140 2HB  PRO     8       3.192   9.995  -0.574  1.00 36.29           H 
ATOM    141 3HG  PRO     8       3.972   8.047  -2.723  1.00 36.29           H 
ATOM    142 2HG  PRO     8       2.688   9.271  -2.741  1.00 36.29           H 
ATOM    143 3HD  PRO     8       2.188   6.653  -2.248  1.00 36.29           H 
ATOM    144 2HD  PRO     8       1.247   7.955  -1.487  1.00 36.29           H 
ATOM    145  N   GLY     9       4.646   8.240   2.428  1.00 12.24           N 
ATOM    146  CA  GLY     9       4.576   8.671   3.823  1.00 71.12           C 
ATOM    147  C   GLY     9       4.364   7.512   4.795  1.00 14.14           C 
ATOM    148  O   GLY     9       4.726   7.604   5.970  1.00 53.41           O 
ATOM    149  H   GLY     9       5.370   7.646   2.142  1.00 36.29           H 
ATOM    150 3HA  GLY     9       3.761   9.374   3.939  1.00 36.29           H 
ATOM    151 2HA  GLY     9       5.501   9.170   4.077  1.00 36.29           H 
ATOM    152  N   VAL    10       3.778   6.423   4.305  1.00 64.52           N 
ATOM    153  CA  VAL    10       3.529   5.234   5.129  1.00 45.04           C 
ATOM    154  C   VAL    10       4.758   4.303   5.157  1.00 22.22           C 
ATOM    155  O   VAL    10       5.238   3.867   4.110  1.00 13.40           O 
ATOM    156  CB  VAL    10       2.297   4.444   4.613  1.00 32.21           C 
ATOM    157  CG1 VAL    10       2.049   3.193   5.455  1.00 62.22           C 
ATOM    158  CG2 VAL    10       1.055   5.336   4.592  1.00 12.32           C 
ATOM    159  H   VAL    10       3.505   6.412   3.362  1.00 36.29           H 
ATOM    160  HA  VAL    10       3.317   5.568   6.137  1.00 21.15           H 
ATOM    161  HB  VAL    10       2.500   4.129   3.598  1.00 63.25           H 
ATOM    162 1HG1 VAL    10       2.906   2.536   5.390  1.00 36.29           H 
ATOM    163 2HG1 VAL    10       1.175   2.678   5.086  1.00 36.29           H 
ATOM    164 3HG1 VAL    10       1.891   3.477   6.486  1.00 36.29           H 
ATOM    165 1HG2 VAL    10       1.226   6.180   3.939  1.00 36.29           H 
ATOM    166 2HG2 VAL    10       0.848   5.693   5.591  1.00 36.29           H 
ATOM    167 3HG2 VAL    10       0.208   4.769   4.231  1.00 36.29           H 
ATOM    168  N   PRO    11       5.292   3.994   6.358  1.00 14.03           N 
ATOM    169  CA  PRO    11       6.452   3.097   6.503  1.00  4.53           C 
ATOM    170  C   PRO    11       6.083   1.603   6.412  1.00 14.25           C 
ATOM    171  O   PRO    11       5.083   1.156   6.985  1.00  4.44           O 
ATOM    172  CB  PRO    11       6.970   3.443   7.903  1.00  4.12           C 
ATOM    173  CG  PRO    11       5.750   3.846   8.664  1.00 24.22           C 
ATOM    174  CD  PRO    11       4.824   4.503   7.666  1.00 63.44           C 
ATOM    175  HA  PRO    11       7.216   3.321   5.770  1.00 72.10           H 
ATOM    176 3HB  PRO    11       7.681   4.255   7.839  1.00 36.29           H 
ATOM    177 2HB  PRO    11       7.448   2.577   8.344  1.00 36.29           H 
ATOM    178 3HG  PRO    11       6.016   4.544   9.446  1.00 36.29           H 
ATOM    179 2HG  PRO    11       5.278   2.971   9.091  1.00 36.29           H 
ATOM    180 3HD  PRO    11       4.918   5.580   7.713  1.00 36.29           H 
ATOM    181 2HD  PRO    11       3.801   4.208   7.848  1.00 36.29           H 
ATOM    182  N   ALA    12       6.901   0.833   5.695  1.00 41.23           N 
ATOM    183  CA  ALA    12       6.690  -0.613   5.558  1.00 13.34           C 
ATOM    184  C   ALA    12       7.997  -1.397   5.764  1.00  4.20           C 
ATOM    185  O   ALA    12       9.063  -0.956   5.350  1.00 53.40           O 
ATOM    186  CB  ALA    12       6.088  -0.931   4.194  1.00 41.20           C 
ATOM    187  H   ALA    12       7.663   1.249   5.235  1.00 36.29           H 
ATOM    188  HA  ALA    12       5.982  -0.919   6.316  1.00 70.54           H 
ATOM    189 1HB  ALA    12       5.158  -0.392   4.074  1.00 36.29           H 
ATOM    190 2HB  ALA    12       5.896  -1.992   4.123  1.00 36.29           H 
ATOM    191 3HB  ALA    12       6.777  -0.637   3.414  1.00 36.29           H 
ATOM    192  N   ARG    13       7.913  -2.563   6.401  1.00 12.42           N 
ATOM    193  CA  ARG    13       9.106  -3.379   6.672  1.00 30.40           C 
ATOM    194  C   ARG    13       9.311  -4.451   5.585  1.00 42.44           C 
ATOM    195  O   ARG    13       8.356  -5.085   5.137  1.00 71.15           O 
ATOM    196  CB  ARG    13       8.995  -4.049   8.052  1.00 72.24           C 
ATOM    197  CG  ARG    13      10.269  -4.777   8.486  1.00 32.23           C 
ATOM    198  CD  ARG    13      10.105  -5.477   9.834  1.00 34.44           C 
ATOM    199  NE  ARG    13       9.133  -6.570   9.779  1.00  2.45           N 
ATOM    200  CZ  ARG    13       9.006  -7.486  10.701  1.00 54.22           C 
ATOM    201  NH1 ARG    13       9.728  -7.455  11.775  1.00 63.05           N 
ATOM    202  NH2 ARG    13       8.138  -8.429  10.548  1.00 72.55           N 
ATOM    203  H   ARG    13       7.037  -2.881   6.699  1.00 36.29           H 
ATOM    204  HA  ARG    13       9.964  -2.722   6.673  1.00 11.40           H 
ATOM    205 3HB  ARG    13       8.186  -4.765   8.031  1.00 36.29           H 
ATOM    206 2HB  ARG    13       8.770  -3.290   8.790  1.00 36.29           H 
ATOM    207 3HG  ARG    13      11.071  -4.056   8.562  1.00 36.29           H 
ATOM    208 2HG  ARG    13      10.522  -5.516   7.739  1.00 36.29           H 
ATOM    209 3HD  ARG    13       9.774  -4.752  10.565  1.00 36.29           H 
ATOM    210 2HD  ARG    13      11.064  -5.876  10.137  1.00 36.29           H 
ATOM    211  HE  ARG    13       8.548  -6.622   8.997  1.00 22.44           H 
ATOM    212 1HH1 ARG    13      10.393  -6.725  11.911  1.00 36.29           H 
ATOM    213 2HH1 ARG    13       9.621  -8.166  12.464  1.00 36.29           H 
ATOM    214 1HH2 ARG    13       7.567  -8.450   9.727  1.00 36.29           H 
ATOM    215 2HH2 ARG    13       8.039  -9.133  11.247  1.00 36.29           H 
ATOM    216  N   ILE    14      10.561  -4.637   5.169  1.00  2.55           N 
ATOM    217  CA  ILE    14      10.908  -5.622   4.137  1.00 71.42           C 
ATOM    218  C   ILE    14      10.714  -7.064   4.644  1.00 32.34           C 
ATOM    219  O   ILE    14      11.498  -7.544   5.470  1.00 73.21           O 
ATOM    220  CB  ILE    14      12.389  -5.463   3.688  1.00  2.42           C 
ATOM    221  CG1 ILE    14      12.711  -4.005   3.309  1.00  2.21           C 
ATOM    222  CG2 ILE    14      12.702  -6.398   2.519  1.00 12.31           C 
ATOM    223  CD1 ILE    14      11.972  -3.496   2.095  1.00 64.15           C 
ATOM    224  H   ILE    14      11.275  -4.094   5.564  1.00 36.29           H 
ATOM    225  HA  ILE    14      10.269  -5.456   3.280  1.00 32.01           H 
ATOM    226  HB  ILE    14      13.020  -5.753   4.517  1.00 63.30           H 
ATOM    227 3HG1 ILE    14      13.770  -3.920   3.110  1.00 36.29           H 
ATOM    228 2HG1 ILE    14      12.456  -3.363   4.137  1.00 36.29           H 
ATOM    229 1HG2 ILE    14      13.728  -6.259   2.211  1.00 36.29           H 
ATOM    230 2HG2 ILE    14      12.045  -6.174   1.692  1.00 36.29           H 
ATOM    231 3HG2 ILE    14      12.555  -7.422   2.829  1.00 36.29           H 
ATOM    232 1HD1 ILE    14      12.188  -4.129   1.247  1.00 36.29           H 
ATOM    233 2HD1 ILE    14      12.290  -2.487   1.880  1.00 36.29           H 
ATOM    234 3HD1 ILE    14      10.910  -3.504   2.288  1.00 36.29           H 
ATOM    235  N   LYS    15       9.680  -7.754   4.151  1.00 65.45           N 
ATOM    236  CA  LYS    15       9.479  -9.174   4.480  1.00  5.15           C 
ATOM    237  C   LYS    15      10.547 -10.041   3.798  1.00  4.03           C 
ATOM    238  O   LYS    15      11.325 -10.733   4.452  1.00 71.41           O 
ATOM    239  CB  LYS    15       8.097  -9.690   4.028  1.00  1.11           C 
ATOM    240  CG  LYS    15       6.882  -9.032   4.682  1.00 65.44           C 
ATOM    241  CD  LYS    15       5.621  -9.866   4.421  1.00 23.12           C 
ATOM    242  CE  LYS    15       4.339  -9.190   4.899  1.00 73.24           C 
ATOM    243  NZ  LYS    15       3.909  -8.093   3.990  1.00 33.12           N 
ATOM    244  H   LYS    15       9.045  -7.304   3.555  1.00 36.29           H 
ATOM    245  HA  LYS    15       9.566  -9.286   5.552  1.00 63.34           H 
ATOM    246 3HB  LYS    15       8.050 -10.753   4.233  1.00 36.29           H 
ATOM    247 2HB  LYS    15       8.012  -9.547   2.960  1.00 36.29           H 
ATOM    248 3HG  LYS    15       6.747  -8.043   4.265  1.00 36.29           H 
ATOM    249 2HG  LYS    15       7.047  -8.962   5.748  1.00 36.29           H 
ATOM    250 3HD  LYS    15       5.723 -10.815   4.931  1.00 36.29           H 
ATOM    251 2HD  LYS    15       5.537 -10.042   3.359  1.00 36.29           H 
ATOM    252 3HE  LYS    15       4.506  -8.783   5.886  1.00 36.29           H 
ATOM    253 2HE  LYS    15       3.552  -9.928   4.946  1.00 36.29           H 
ATOM    254 1HZ  LYS    15       3.748  -8.461   3.031  1.00 36.29           H 
ATOM    255 2HZ  LYS    15       4.635  -7.356   3.943  1.00 36.29           H 
ATOM    256 3HZ  LYS    15       3.022  -7.670   4.334  1.00 36.29           H 
ATOM    257  N   ARG    16      10.573  -9.985   2.465  1.00 53.12           N 
ATOM    258  CA  ARG    16      11.427 -10.869   1.666  1.00 72.13           C 
ATOM    259  C   ARG    16      11.640 -10.326   0.242  1.00 25.20           C 
ATOM    260  O   ARG    16      10.906  -9.449  -0.219  1.00 32.24           O 
ATOM    261  CB  ARG    16      10.792 -12.264   1.587  1.00 52.01           C 
ATOM    262  CG  ARG    16       9.361 -12.243   1.052  1.00 71.01           C 
ATOM    263  CD  ARG    16       8.743 -13.634   1.005  1.00 61.23           C 
ATOM    264  NE  ARG    16       9.381 -14.498   0.011  1.00 72.42           N 
ATOM    265  CZ  ARG    16       8.831 -15.579  -0.473  1.00 20.34           C 
ATOM    266  NH1 ARG    16       7.664 -15.966  -0.065  1.00 12.04           N 
ATOM    267  NH2 ARG    16       9.452 -16.283  -1.360  1.00 11.42           N 
ATOM    268  H   ARG    16      10.005  -9.329   2.006  1.00 36.29           H 
ATOM    269  HA  ARG    16      12.385 -10.946   2.160  1.00 73.44           H 
ATOM    270 3HB  ARG    16      10.778 -12.699   2.577  1.00 36.29           H 
ATOM    271 2HB  ARG    16      11.392 -12.887   0.939  1.00 36.29           H 
ATOM    272 3HG  ARG    16       9.370 -11.828   0.052  1.00 36.29           H 
ATOM    273 2HG  ARG    16       8.758 -11.615   1.693  1.00 36.29           H 
ATOM    274 3HD  ARG    16       7.693 -13.536   0.763  1.00 36.29           H 
ATOM    275 2HD  ARG    16       8.843 -14.092   1.980  1.00 36.29           H 
ATOM    276  HE  ARG    16      10.269 -14.246  -0.311  1.00 74.05           H 
ATOM    277 1HH1 ARG    16       7.174 -15.436   0.626  1.00 36.29           H 
ATOM    278 2HH1 ARG    16       7.254 -16.795  -0.444  1.00 36.29           H 
ATOM    279 1HH2 ARG    16      10.355 -16.000  -1.677  1.00 36.29           H 
ATOM    280 2HH2 ARG    16       9.024 -17.104  -1.728  1.00 36.29           H 
ATOM    281  N   LEU    17      12.645 -10.863  -0.450  1.00  0.31           N 
ATOM    282  CA  LEU    17      12.922 -10.490  -1.843  1.00 62.33           C 
ATOM    283  C   LEU    17      12.686 -11.688  -2.778  1.00  3.55           C 
ATOM    284  O   LEU    17      13.438 -12.664  -2.747  1.00  4.43           O 
ATOM    285  CB  LEU    17      14.372  -9.988  -2.007  1.00 34.31           C 
ATOM    286  CG  LEU    17      14.729  -8.668  -1.289  1.00 73.12           C 
ATOM    287  CD1 LEU    17      14.759  -8.844   0.228  1.00 51.21           C 
ATOM    288  CD2 LEU    17      16.067  -8.128  -1.792  1.00 23.23           C 
ATOM    289  H   LEU    17      13.215 -11.534  -0.014  1.00 36.29           H 
ATOM    290  HA  LEU    17      12.243  -9.694  -2.117  1.00  3.45           H 
ATOM    291 3HB  LEU    17      14.560  -9.853  -3.064  1.00 36.29           H 
ATOM    292 2HB  LEU    17      15.036 -10.759  -1.642  1.00 36.29           H 
ATOM    293  HG  LEU    17      13.972  -7.931  -1.516  1.00 55.30           H 
ATOM    294 1HD1 LEU    17      13.784  -9.152   0.573  1.00 36.29           H 
ATOM    295 2HD1 LEU    17      15.023  -7.906   0.694  1.00 36.29           H 
ATOM    296 3HD1 LEU    17      15.490  -9.595   0.493  1.00 36.29           H 
ATOM    297 1HD2 LEU    17      15.995  -7.910  -2.847  1.00 36.29           H 
ATOM    298 2HD2 LEU    17      16.842  -8.865  -1.630  1.00 36.29           H 
ATOM    299 3HD2 LEU    17      16.315  -7.223  -1.255  1.00 36.29           H 
ATOM    300  N   GLU    18      11.650 -11.616  -3.609  1.00 65.14           N 
ATOM    301  CA  GLU    18      11.313 -12.710  -4.532  1.00 61.25           C 
ATOM    302  C   GLU    18      12.190 -12.680  -5.802  1.00 13.35           C 
ATOM    303  O   GLU    18      11.698 -12.836  -6.922  1.00 54.12           O 
ATOM    304  CB  GLU    18       9.818 -12.641  -4.893  1.00 64.31           C 
ATOM    305  CG  GLU    18       8.890 -12.730  -3.680  1.00 30.41           C 
ATOM    306  CD  GLU    18       7.420 -12.882  -4.059  1.00 44.25           C 
ATOM    307  OE1 GLU    18       7.032 -13.991  -4.487  1.00 73.44           O 
ATOM    308  OE2 GLU    18       6.650 -11.903  -3.923  1.00 72.23           O 
ATOM    309  H   GLU    18      11.091 -10.812  -3.602  1.00 36.29           H 
ATOM    310  HA  GLU    18      11.498 -13.643  -4.015  1.00  3.23           H 
ATOM    311 3HB  GLU    18       9.582 -13.460  -5.560  1.00 36.29           H 
ATOM    312 2HB  GLU    18       9.624 -11.706  -5.400  1.00 36.29           H 
ATOM    313 3HG  GLU    18       9.008 -11.830  -3.089  1.00 36.29           H 
ATOM    314 2HG  GLU    18       9.181 -13.584  -3.085  1.00 36.29           H 
ATOM    315  N   VAL    19      13.500 -12.511  -5.610  1.00 61.33           N 
ATOM    316  CA  VAL    19      14.461 -12.464  -6.720  1.00 64.02           C 
ATOM    317  C   VAL    19      15.892 -12.796  -6.248  1.00 51.43           C 
ATOM    318  O   VAL    19      16.281 -12.473  -5.124  1.00 60.45           O 
ATOM    319  CB  VAL    19      14.460 -11.070  -7.404  1.00 21.12           C 
ATOM    320  CG1 VAL    19      14.876  -9.976  -6.420  1.00 20.32           C 
ATOM    321  CG2 VAL    19      15.362 -11.064  -8.642  1.00 35.12           C 
ATOM    322  H   VAL    19      13.833 -12.421  -4.695  1.00 36.29           H 
ATOM    323  HA  VAL    19      14.157 -13.200  -7.452  1.00 71.45           H 
ATOM    324  HB  VAL    19      13.449 -10.857  -7.727  1.00 20.42           H 
ATOM    325 1HG1 VAL    19      14.197  -9.969  -5.579  1.00 36.29           H 
ATOM    326 2HG1 VAL    19      14.844  -9.014  -6.915  1.00 36.29           H 
ATOM    327 3HG1 VAL    19      15.879 -10.166  -6.070  1.00 36.29           H 
ATOM    328 1HG2 VAL    19      15.338 -10.086  -9.102  1.00 36.29           H 
ATOM    329 2HG2 VAL    19      15.010 -11.800  -9.350  1.00 36.29           H 
ATOM    330 3HG2 VAL    19      16.376 -11.300  -8.352  1.00 36.29           H 
ATOM    331  N   SER    20      16.668 -13.440  -7.120  1.00 30.03           N 
ATOM    332  CA  SER    20      18.064 -13.797  -6.819  1.00 25.34           C 
ATOM    333  C   SER    20      18.943 -13.724  -8.080  1.00 44.25           C 
ATOM    334  O   SER    20      18.525 -14.140  -9.162  1.00  1.44           O 
ATOM    335  CB  SER    20      18.143 -15.212  -6.222  1.00 54.34           C 
ATOM    336  OG  SER    20      17.658 -16.194  -7.132  1.00 62.52           O 
ATOM    337  H   SER    20      16.293 -13.691  -7.990  1.00 36.29           H 
ATOM    338  HA  SER    20      18.439 -13.088  -6.092  1.00 21.44           H 
ATOM    339 3HB  SER    20      17.550 -15.253  -5.320  1.00 36.29           H 
ATOM    340 2HB  SER    20      19.173 -15.443  -5.983  1.00 36.29           H 
ATOM    341  HG  SER    20      17.701 -15.848  -8.034  1.00 34.34           H 
ATOM    342  N   GLY    21      20.162 -13.203  -7.936  1.00 43.32           N 
ATOM    343  CA  GLY    21      21.082 -13.104  -9.070  1.00 23.41           C 
ATOM    344  C   GLY    21      20.997 -11.768  -9.811  1.00  2.22           C 
ATOM    345  O   GLY    21      19.912 -11.349 -10.222  1.00 65.42           O 
ATOM    346  H   GLY    21      20.447 -12.890  -7.050  1.00 36.29           H 
ATOM    347 3HA  GLY    21      20.866 -13.902  -9.767  1.00 36.29           H 
ATOM    348 2HA  GLY    21      22.090 -13.233  -8.705  1.00 36.29           H 
ATOM    349  N   GLU    22      22.147 -11.100  -9.970  1.00 25.21           N 
ATOM    350  CA  GLU    22      22.243  -9.823 -10.704  1.00 35.14           C 
ATOM    351  C   GLU    22      21.469  -8.681 -10.015  1.00 50.11           C 
ATOM    352  O   GLU    22      22.065  -7.758  -9.459  1.00 14.41           O 
ATOM    353  CB  GLU    22      21.769  -9.991 -12.160  1.00 34.40           C 
ATOM    354  CG  GLU    22      22.683 -10.870 -13.010  1.00 62.03           C 
ATOM    355  CD  GLU    22      22.176 -11.049 -14.434  1.00 22.45           C 
ATOM    356  OE1 GLU    22      21.874 -12.194 -14.830  1.00 61.44           O 
ATOM    357  OE2 GLU    22      22.061 -10.042 -15.164  1.00 72.20           O 
ATOM    358  H   GLU    22      22.963 -11.474  -9.575  1.00 36.29           H 
ATOM    359  HA  GLU    22      23.290  -9.551 -10.720  1.00 42.54           H 
ATOM    360 3HB  GLU    22      21.711  -9.016 -12.624  1.00 36.29           H 
ATOM    361 2HB  GLU    22      20.782 -10.433 -12.156  1.00 36.29           H 
ATOM    362 3HG  GLU    22      22.762 -11.841 -12.543  1.00 36.29           H 
ATOM    363 2HG  GLU    22      23.663 -10.413 -13.050  1.00 36.29           H 
ATOM    364  N   LEU    23      20.141  -8.738 -10.056  1.00 52.11           N 
ATOM    365  CA  LEU    23      19.307  -7.690  -9.456  1.00 42.43           C 
ATOM    366  C   LEU    23      19.362  -7.725  -7.917  1.00 54.40           C 
ATOM    367  O   LEU    23      19.346  -6.683  -7.260  1.00 31.34           O 
ATOM    368  CB  LEU    23      17.853  -7.829  -9.935  1.00 25.13           C 
ATOM    369  CG  LEU    23      16.890  -6.751  -9.414  1.00 34.53           C 
ATOM    370  CD1 LEU    23      17.379  -5.358  -9.802  1.00 51.22           C 
ATOM    371  CD2 LEU    23      15.476  -6.993  -9.938  1.00  1.54           C 
ATOM    372  H   LEU    23      19.710  -9.498 -10.502  1.00 36.29           H 
ATOM    373  HA  LEU    23      19.692  -6.735  -9.792  1.00 63.41           H 
ATOM    374 3HB  LEU    23      17.483  -8.794  -9.618  1.00 36.29           H 
ATOM    375 2HB  LEU    23      17.848  -7.799 -11.016  1.00 36.29           H 
ATOM    376  HG  LEU    23      16.857  -6.800  -8.334  1.00 11.35           H 
ATOM    377 1HD1 LEU    23      18.367  -5.196  -9.393  1.00 36.29           H 
ATOM    378 2HD1 LEU    23      16.703  -4.616  -9.406  1.00 36.29           H 
ATOM    379 3HD1 LEU    23      17.416  -5.274 -10.879  1.00 36.29           H 
ATOM    380 1HD2 LEU    23      15.480  -6.962 -11.019  1.00 36.29           H 
ATOM    381 2HD2 LEU    23      14.813  -6.227  -9.559  1.00 36.29           H 
ATOM    382 3HD2 LEU    23      15.128  -7.961  -9.606  1.00 36.29           H 
ATOM    383  N   HIS    24      19.440  -8.927  -7.347  1.00  5.44           N 
ATOM    384  CA  HIS    24      19.451  -9.098  -5.887  1.00 21.23           C 
ATOM    385  C   HIS    24      20.626  -8.346  -5.232  1.00 15.23           C 
ATOM    386  O   HIS    24      20.454  -7.677  -4.212  1.00 20.14           O 
ATOM    387  CB  HIS    24      19.509 -10.589  -5.534  1.00 22.14           C 
ATOM    388  CG  HIS    24      19.431 -10.874  -4.061  1.00 74.40           C 
ATOM    389  ND1 HIS    24      20.541 -11.011  -3.257  1.00 22.52           N 
ATOM    390  CD2 HIS    24      18.364 -11.068  -3.253  1.00 72.20           C 
ATOM    391  CE1 HIS    24      20.161 -11.276  -2.025  1.00 11.43           C 
ATOM    392  NE2 HIS    24      18.844 -11.316  -1.993  1.00 72.11           N 
ATOM    393  H   HIS    24      19.496  -9.719  -7.922  1.00 36.29           H 
ATOM    394  HA  HIS    24      18.527  -8.689  -5.504  1.00 73.12           H 
ATOM    395 3HB  HIS    24      20.435 -11.007  -5.904  1.00 36.29           H 
ATOM    396 2HB  HIS    24      18.680 -11.095  -6.008  1.00 36.29           H 
ATOM    397  HD1 HIS    24      21.476 -10.931  -3.549  1.00 43.04           H 
ATOM    398  HD2 HIS    24      17.323 -11.033  -3.547  1.00 22.55           H 
ATOM    399  HE1 HIS    24      20.817 -11.438  -1.182  1.00 34.02           H 
ATOM    400  HE2 HIS    24      18.323 -11.726  -1.267  1.00 36.29           H 
ATOM    401  N   GLU    25      21.814  -8.462  -5.821  1.00  1.01           N 
ATOM    402  CA  GLU    25      23.002  -7.760  -5.313  1.00 20.24           C 
ATOM    403  C   GLU    25      22.894  -6.237  -5.504  1.00 14.42           C 
ATOM    404  O   GLU    25      23.382  -5.464  -4.678  1.00 51.00           O 
ATOM    405  CB  GLU    25      24.270  -8.315  -5.975  1.00 74.25           C 
ATOM    406  CG  GLU    25      24.226  -8.330  -7.499  1.00 60.44           C 
ATOM    407  CD  GLU    25      25.174  -9.357  -8.097  1.00 13.20           C 
ATOM    408  OE1 GLU    25      26.222  -8.969  -8.652  1.00 23.14           O 
ATOM    409  OE2 GLU    25      24.871 -10.565  -8.005  1.00 30.12           O 
ATOM    410  H   GLU    25      21.902  -9.043  -6.607  1.00 36.29           H 
ATOM    411  HA  GLU    25      23.058  -7.960  -4.251  1.00 31.22           H 
ATOM    412 3HB  GLU    25      24.419  -9.330  -5.631  1.00 36.29           H 
ATOM    413 2HB  GLU    25      25.115  -7.716  -5.666  1.00 36.29           H 
ATOM    414 3HG  GLU    25      24.497  -7.348  -7.866  1.00 36.29           H 
ATOM    415 2HG  GLU    25      23.220  -8.565  -7.816  1.00 36.29           H 
ATOM    416  N   LYS    26      22.248  -5.809  -6.587  1.00 33.11           N 
ATOM    417  CA  LYS    26      21.936  -4.388  -6.789  1.00  2.13           C 
ATOM    418  C   LYS    26      21.045  -3.868  -5.647  1.00  1.22           C 
ATOM    419  O   LYS    26      21.283  -2.795  -5.085  1.00 54.51           O 
ATOM    420  CB  LYS    26      21.227  -4.181  -8.138  1.00 23.05           C 
ATOM    421  CG  LYS    26      20.755  -2.747  -8.376  1.00 73.40           C 
ATOM    422  CD  LYS    26      19.990  -2.602  -9.691  1.00 51.53           C 
ATOM    423  CE  LYS    26      19.479  -1.178  -9.894  1.00 32.13           C 
ATOM    424  NZ  LYS    26      20.585  -0.182  -9.921  1.00 65.41           N 
ATOM    425  H   LYS    26      21.984  -6.460  -7.272  1.00 36.29           H 
ATOM    426  HA  LYS    26      22.867  -3.837  -6.788  1.00 21.01           H 
ATOM    427 3HB  LYS    26      20.365  -4.833  -8.184  1.00 36.29           H 
ATOM    428 2HB  LYS    26      21.909  -4.448  -8.933  1.00 36.29           H 
ATOM    429 3HG  LYS    26      21.617  -2.094  -8.398  1.00 36.29           H 
ATOM    430 2HG  LYS    26      20.104  -2.454  -7.564  1.00 36.29           H 
ATOM    431 3HD  LYS    26      19.147  -3.278  -9.682  1.00 36.29           H 
ATOM    432 2HD  LYS    26      20.647  -2.857 -10.511  1.00 36.29           H 
ATOM    433 3HE  LYS    26      18.805  -0.931  -9.085  1.00 36.29           H 
ATOM    434 2HE  LYS    26      18.945  -1.132 -10.832  1.00 36.29           H 
ATOM    435 1HZ  LYS    26      21.194  -0.296  -9.087  1.00 36.29           H 
ATOM    436 2HZ  LYS    26      20.197   0.783  -9.915  1.00 36.29           H 
ATOM    437 3HZ  LYS    26      21.162  -0.304 -10.778  1.00 36.29           H 
ATOM    438  N   LEU    27      20.024  -4.650  -5.307  1.00  4.41           N 
ATOM    439  CA  LEU    27      19.083  -4.291  -4.242  1.00 50.20           C 
ATOM    440  C   LEU    27      19.781  -4.169  -2.873  1.00 51.10           C 
ATOM    441  O   LEU    27      19.699  -3.127  -2.217  1.00  3.54           O 
ATOM    442  CB  LEU    27      17.956  -5.332  -4.174  1.00 34.50           C 
ATOM    443  CG  LEU    27      17.071  -5.423  -5.432  1.00 22.13           C 
ATOM    444  CD1 LEU    27      16.069  -6.569  -5.311  1.00 62.11           C 
ATOM    445  CD2 LEU    27      16.352  -4.096  -5.685  1.00 60.43           C 
ATOM    446  H   LEU    27      19.895  -5.494  -5.790  1.00 36.29           H 
ATOM    447  HA  LEU    27      18.653  -3.331  -4.494  1.00 23.24           H 
ATOM    448 3HB  LEU    27      17.321  -5.093  -3.332  1.00 36.29           H 
ATOM    449 2HB  LEU    27      18.402  -6.302  -4.001  1.00 36.29           H 
ATOM    450  HG  LEU    27      17.700  -5.626  -6.287  1.00 31.34           H 
ATOM    451 1HD1 LEU    27      16.601  -7.500  -5.172  1.00 36.29           H 
ATOM    452 2HD1 LEU    27      15.478  -6.626  -6.213  1.00 36.29           H 
ATOM    453 3HD1 LEU    27      15.419  -6.396  -4.465  1.00 36.29           H 
ATOM    454 1HD2 LEU    27      15.744  -4.180  -6.575  1.00 36.29           H 
ATOM    455 2HD2 LEU    27      17.080  -3.310  -5.821  1.00 36.29           H 
ATOM    456 3HD2 LEU    27      15.720  -3.858  -4.841  1.00 36.29           H 
ATOM    457  N   VAL    28      20.473  -5.227  -2.449  1.00 41.14           N 
ATOM    458  CA  VAL    28      21.202  -5.206  -1.172  1.00 31.54           C 
ATOM    459  C   VAL    28      22.322  -4.151  -1.187  1.00  2.43           C 
ATOM    460  O   VAL    28      22.674  -3.585  -0.151  1.00 42.45           O 
ATOM    461  CB  VAL    28      21.796  -6.596  -0.812  1.00 35.24           C 
ATOM    462  CG1 VAL    28      20.698  -7.656  -0.773  1.00 43.52           C 
ATOM    463  CG2 VAL    28      22.904  -6.994  -1.786  1.00 23.41           C 
ATOM    464  H   VAL    28      20.488  -6.041  -2.998  1.00 36.29           H 
ATOM    465  HA  VAL    28      20.492  -4.937  -0.399  1.00 15.12           H 
ATOM    466  HB  VAL    28      22.227  -6.529   0.179  1.00 34.11           H 
ATOM    467 1HG1 VAL    28      20.237  -7.735  -1.748  1.00 36.29           H 
ATOM    468 2HG1 VAL    28      19.951  -7.378  -0.044  1.00 36.29           H 
ATOM    469 3HG1 VAL    28      21.127  -8.611  -0.500  1.00 36.29           H 
ATOM    470 1HG2 VAL    28      23.708  -6.275  -1.733  1.00 36.29           H 
ATOM    471 2HG2 VAL    28      22.510  -7.017  -2.791  1.00 36.29           H 
ATOM    472 3HG2 VAL    28      23.281  -7.974  -1.525  1.00 36.29           H 
ATOM    473  N   GLY    29      22.883  -3.897  -2.371  1.00 31.42           N 
ATOM    474  CA  GLY    29      23.868  -2.831  -2.532  1.00 51.22           C 
ATOM    475  C   GLY    29      23.289  -1.447  -2.241  1.00 63.34           C 
ATOM    476  O   GLY    29      23.980  -0.569  -1.718  1.00 30.35           O 
ATOM    477  H   GLY    29      22.633  -4.446  -3.146  1.00 36.29           H 
ATOM    478 3HA  GLY    29      24.236  -2.848  -3.549  1.00 36.29           H 
ATOM    479 2HA  GLY    29      24.695  -3.013  -1.860  1.00 36.29           H 
ATOM    480  N   MET    30      22.015  -1.257  -2.582  1.00  3.32           N 
ATOM    481  CA  MET    30      21.309  -0.001  -2.299  1.00  5.23           C 
ATOM    482  C   MET    30      20.713   0.005  -0.878  1.00 22.33           C 
ATOM    483  O   MET    30      20.421   1.066  -0.324  1.00 35.41           O 
ATOM    484  CB  MET    30      20.211   0.242  -3.345  1.00 11.22           C 
ATOM    485  CG  MET    30      20.754   0.455  -4.752  1.00  1.14           C 
ATOM    486  SD  MET    30      19.457   0.812  -5.956  1.00 22.01           S 
ATOM    487  CE  MET    30      18.502  -0.703  -5.889  1.00 63.52           C 
ATOM    488  H   MET    30      21.537  -1.980  -3.043  1.00 36.29           H 
ATOM    489  HA  MET    30      22.032   0.801  -2.367  1.00 44.01           H 
ATOM    490 3HB  MET    30      19.647   1.118  -3.063  1.00 36.29           H 
ATOM    491 2HB  MET    30      19.548  -0.612  -3.363  1.00 36.29           H 
ATOM    492 3HG  MET    30      21.277  -0.440  -5.061  1.00 36.29           H 
ATOM    493 2HG  MET    30      21.444   1.285  -4.736  1.00 36.29           H 
ATOM    494 1HE  MET    30      19.128  -1.537  -6.171  1.00 36.29           H 
ATOM    495 2HE  MET    30      17.667  -0.634  -6.571  1.00 36.29           H 
ATOM    496 3HE  MET    30      18.134  -0.854  -4.885  1.00 36.29           H 
ATOM    497  N   GLY    31      20.529  -1.182  -0.288  1.00 64.43           N 
ATOM    498  CA  GLY    31      20.067  -1.268   1.102  1.00 12.31           C 
ATOM    499  C   GLY    31      18.915  -2.247   1.329  1.00 42.44           C 
ATOM    500  O   GLY    31      18.568  -2.545   2.477  1.00 43.15           O 
ATOM    501  H   GLY    31      20.716  -2.001  -0.793  1.00 36.29           H 
ATOM    502 3HA  GLY    31      19.749  -0.286   1.424  1.00 36.29           H 
ATOM    503 2HA  GLY    31      20.899  -1.575   1.719  1.00 36.29           H 
ATOM    504  N   PHE    32      18.317  -2.750   0.250  1.00 21.02           N 
ATOM    505  CA  PHE    32      17.173  -3.669   0.355  1.00 73.14           C 
ATOM    506  C   PHE    32      17.560  -5.002   1.023  1.00 52.01           C 
ATOM    507  O   PHE    32      18.043  -5.923   0.362  1.00 42.21           O 
ATOM    508  CB  PHE    32      16.568  -3.944  -1.032  1.00 25.00           C 
ATOM    509  CG  PHE    32      15.960  -2.734  -1.696  1.00 31.13           C 
ATOM    510  CD1 PHE    32      16.760  -1.803  -2.344  1.00 24.34           C 
ATOM    511  CD2 PHE    32      14.586  -2.530  -1.675  1.00  5.14           C 
ATOM    512  CE1 PHE    32      16.205  -0.696  -2.953  1.00 73.05           C 
ATOM    513  CE2 PHE    32      14.028  -1.423  -2.283  1.00 61.32           C 
ATOM    514  CZ  PHE    32      14.837  -0.505  -2.923  1.00 40.43           C 
ATOM    515  H   PHE    32      18.647  -2.498  -0.637  1.00 36.29           H 
ATOM    516  HA  PHE    32      16.424  -3.186   0.966  1.00 23.32           H 
ATOM    517 3HB  PHE    32      15.794  -4.695  -0.935  1.00 36.29           H 
ATOM    518 2HB  PHE    32      17.342  -4.323  -1.683  1.00 36.29           H 
ATOM    519  HD1 PHE    32      17.830  -1.950  -2.368  1.00 53.21           H 
ATOM    520  HD2 PHE    32      13.951  -3.248  -1.177  1.00 60.02           H 
ATOM    521  HE1 PHE    32      16.840   0.020  -3.453  1.00 65.40           H 
ATOM    522  HE2 PHE    32      12.957  -1.275  -2.260  1.00 30.52           H 
ATOM    523  HZ  PHE    32      14.403   0.361  -3.398  1.00 72.35           H 
ATOM    524  N   VAL    33      17.362  -5.087   2.339  1.00 62.13           N 
ATOM    525  CA  VAL    33      17.590  -6.332   3.085  1.00 63.03           C 
ATOM    526  C   VAL    33      16.395  -6.650   4.007  1.00 51.44           C 
ATOM    527  O   VAL    33      15.780  -5.740   4.579  1.00 32.15           O 
ATOM    528  CB  VAL    33      18.901  -6.275   3.926  1.00 62.10           C 
ATOM    529  CG1 VAL    33      20.117  -6.065   3.025  1.00 55.24           C 
ATOM    530  CG2 VAL    33      18.826  -5.183   4.994  1.00 52.51           C 
ATOM    531  H   VAL    33      17.064  -4.289   2.823  1.00 36.29           H 
ATOM    532  HA  VAL    33      17.690  -7.135   2.365  1.00 61.15           H 
ATOM    533  HB  VAL    33      19.021  -7.227   4.427  1.00 30.32           H 
ATOM    534 1HG1 VAL    33      21.018  -6.064   3.624  1.00 36.29           H 
ATOM    535 2HG1 VAL    33      20.028  -5.119   2.511  1.00 36.29           H 
ATOM    536 3HG1 VAL    33      20.170  -6.863   2.298  1.00 36.29           H 
ATOM    537 1HG2 VAL    33      18.020  -5.403   5.680  1.00 36.29           H 
ATOM    538 2HG2 VAL    33      18.646  -4.229   4.522  1.00 36.29           H 
ATOM    539 3HG2 VAL    33      19.760  -5.145   5.538  1.00 36.29           H 
ATOM    540  N   PRO    34      16.038  -7.946   4.155  1.00  1.04           N 
ATOM    541  CA  PRO    34      14.906  -8.368   5.006  1.00  2.21           C 
ATOM    542  C   PRO    34      15.015  -7.834   6.446  1.00 34.35           C 
ATOM    543  O   PRO    34      15.907  -8.230   7.205  1.00 23.53           O 
ATOM    544  CB  PRO    34      14.993  -9.901   4.981  1.00 13.00           C 
ATOM    545  CG  PRO    34      15.710 -10.218   3.713  1.00 72.54           C 
ATOM    546  CD  PRO    34      16.696  -9.098   3.506  1.00 32.51           C 
ATOM    547  HA  PRO    34      13.959  -8.052   4.580  1.00 72.01           H 
ATOM    548 3HB  PRO    34      13.997 -10.323   4.988  1.00 36.29           H 
ATOM    549 2HB  PRO    34      15.543 -10.251   5.845  1.00 36.29           H 
ATOM    550 3HG  PRO    34      15.008 -10.258   2.891  1.00 36.29           H 
ATOM    551 2HG  PRO    34      16.228 -11.163   3.808  1.00 36.29           H 
ATOM    552 3HD  PRO    34      16.845  -8.915   2.451  1.00 36.29           H 
ATOM    553 2HD  PRO    34      17.638  -9.326   3.987  1.00 36.29           H 
ATOM    554  N   GLY    35      14.099  -6.939   6.813  1.00 51.52           N 
ATOM    555  CA  GLY    35      14.148  -6.295   8.124  1.00 62.41           C 
ATOM    556  C   GLY    35      14.120  -4.769   8.046  1.00 64.23           C 
ATOM    557  O   GLY    35      13.655  -4.106   8.975  1.00 51.22           O 
ATOM    558  H   GLY    35      13.365  -6.727   6.195  1.00 36.29           H 
ATOM    559 3HA  GLY    35      15.054  -6.599   8.634  1.00 36.29           H 
ATOM    560 2HA  GLY    35      13.300  -6.629   8.702  1.00 36.29           H 
ATOM    561  N   GLU    36      14.620  -4.214   6.940  1.00 53.21           N 
ATOM    562  CA  GLU    36      14.636  -2.756   6.736  1.00 11.03           C 
ATOM    563  C   GLU    36      13.231  -2.144   6.757  1.00 23.31           C 
ATOM    564  O   GLU    36      12.258  -2.761   6.326  1.00 61.20           O 
ATOM    565  CB  GLU    36      15.317  -2.400   5.402  1.00 32.34           C 
ATOM    566  CG  GLU    36      16.838  -2.339   5.469  1.00 13.14           C 
ATOM    567  CD  GLU    36      17.339  -1.243   6.399  1.00 44.42           C 
ATOM    568  OE1 GLU    36      16.727  -0.158   6.436  1.00 42.33           O 
ATOM    569  OE2 GLU    36      18.361  -1.458   7.084  1.00 62.32           O 
ATOM    570  H   GLU    36      14.995  -4.795   6.244  1.00 36.29           H 
ATOM    571  HA  GLU    36      15.209  -2.321   7.542  1.00 60.34           H 
ATOM    572 3HB  GLU    36      14.957  -1.433   5.074  1.00 36.29           H 
ATOM    573 2HB  GLU    36      15.042  -3.139   4.664  1.00 36.29           H 
ATOM    574 3HG  GLU    36      17.220  -2.148   4.475  1.00 36.29           H 
ATOM    575 2HG  GLU    36      17.210  -3.291   5.818  1.00 36.29           H 
ATOM    576  N   GLU    37      13.139  -0.920   7.263  1.00 62.22           N 
ATOM    577  CA  GLU    37      11.895  -0.154   7.219  1.00 65.14           C 
ATOM    578  C   GLU    37      11.964   0.899   6.111  1.00 35.44           C 
ATOM    579  O   GLU    37      12.697   1.881   6.211  1.00 53.53           O 
ATOM    580  CB  GLU    37      11.621   0.500   8.577  1.00 71.21           C 
ATOM    581  CG  GLU    37      11.387  -0.513   9.690  1.00 23.14           C 
ATOM    582  CD  GLU    37      11.247   0.135  11.057  1.00 20.24           C 
ATOM    583  OE1 GLU    37      12.279   0.377  11.714  1.00 53.54           O 
ATOM    584  OE2 GLU    37      10.105   0.406  11.479  1.00 64.04           O 
ATOM    585  H   GLU    37      13.931  -0.519   7.679  1.00 36.29           H 
ATOM    586  HA  GLU    37      11.089  -0.842   6.992  1.00 21.02           H 
ATOM    587 3HB  GLU    37      10.743   1.124   8.497  1.00 36.29           H 
ATOM    588 2HB  GLU    37      12.467   1.118   8.848  1.00 36.29           H 
ATOM    589 3HG  GLU    37      12.221  -1.200   9.713  1.00 36.29           H 
ATOM    590 2HG  GLU    37      10.481  -1.063   9.476  1.00 36.29           H 
ATOM    591  N   ILE    38      11.210   0.671   5.048  1.00 11.41           N 
ATOM    592  CA  ILE    38      11.230   1.539   3.870  1.00 13.12           C 
ATOM    593  C   ILE    38       9.952   2.391   3.775  1.00  2.14           C 
ATOM    594  O   ILE    38       8.836   1.879   3.862  1.00 52.15           O 
ATOM    595  CB  ILE    38      11.396   0.704   2.571  1.00 71.30           C 
ATOM    596  CG1 ILE    38      11.418   1.618   1.333  1.00 34.11           C 
ATOM    597  CG2 ILE    38      10.289  -0.346   2.454  1.00 72.01           C 
ATOM    598  CD1 ILE    38      11.584   0.869   0.025  1.00 73.03           C 
ATOM    599  H   ILE    38      10.618  -0.107   5.055  1.00 36.29           H 
ATOM    600  HA  ILE    38      12.085   2.199   3.957  1.00 43.24           H 
ATOM    601  HB  ILE    38      12.341   0.178   2.634  1.00 61.23           H 
ATOM    602 3HG1 ILE    38      12.240   2.315   1.421  1.00 36.29           H 
ATOM    603 2HG1 ILE    38      10.490   2.169   1.281  1.00 36.29           H 
ATOM    604 1HG2 ILE    38       9.328   0.146   2.379  1.00 36.29           H 
ATOM    605 2HG2 ILE    38      10.298  -0.979   3.330  1.00 36.29           H 
ATOM    606 3HG2 ILE    38      10.452  -0.952   1.575  1.00 36.29           H 
ATOM    607 1HD1 ILE    38      12.510   0.313   0.042  1.00 36.29           H 
ATOM    608 2HD1 ILE    38      11.603   1.573  -0.792  1.00 36.29           H 
ATOM    609 3HD1 ILE    38      10.757   0.186  -0.108  1.00 36.29           H 
ATOM    610  N   GLU    39      10.127   3.698   3.613  1.00 24.21           N 
ATOM    611  CA  GLU    39       8.998   4.623   3.451  1.00  0.11           C 
ATOM    612  C   GLU    39       9.097   5.378   2.114  1.00 74.24           C 
ATOM    613  O   GLU    39      10.150   5.922   1.766  1.00 61.24           O 
ATOM    614  CB  GLU    39       8.943   5.611   4.633  1.00 73.20           C 
ATOM    615  CG  GLU    39      10.230   6.403   4.838  1.00 54.35           C 
ATOM    616  CD  GLU    39      10.175   7.341   6.036  1.00  1.04           C 
ATOM    617  OE1 GLU    39      10.249   6.858   7.187  1.00 44.23           O 
ATOM    618  OE2 GLU    39      10.080   8.569   5.834  1.00 60.15           O 
ATOM    619  H   GLU    39      11.041   4.056   3.605  1.00 36.29           H 
ATOM    620  HA  GLU    39       8.089   4.037   3.445  1.00 25.43           H 
ATOM    621 3HB  GLU    39       8.739   5.056   5.539  1.00 36.29           H 
ATOM    622 2HB  GLU    39       8.135   6.312   4.466  1.00 36.29           H 
ATOM    623 3HG  GLU    39      10.420   6.988   3.948  1.00 36.29           H 
ATOM    624 2HG  GLU    39      11.043   5.708   4.984  1.00 36.29           H 
ATOM    625  N   ILE    40       8.003   5.384   1.354  1.00  4.05           N 
ATOM    626  CA  ILE    40       7.955   6.098   0.075  1.00 72.44           C 
ATOM    627  C   ILE    40       7.859   7.614   0.300  1.00 72.04           C 
ATOM    628  O   ILE    40       7.019   8.085   1.068  1.00 42.01           O 
ATOM    629  CB  ILE    40       6.757   5.631  -0.793  1.00 63.41           C 
ATOM    630  CG1 ILE    40       6.827   4.114  -1.055  1.00 70.43           C 
ATOM    631  CG2 ILE    40       6.713   6.402  -2.114  1.00 72.33           C 
ATOM    632  CD1 ILE    40       8.056   3.674  -1.828  1.00 40.12           C 
ATOM    633  H   ILE    40       7.211   4.896   1.659  1.00 36.29           H 
ATOM    634  HA  ILE    40       8.869   5.881  -0.463  1.00 32.24           H 
ATOM    635  HB  ILE    40       5.847   5.851  -0.252  1.00 54.33           H 
ATOM    636 3HG1 ILE    40       5.954   3.815  -1.622  1.00 36.29           H 
ATOM    637 2HG1 ILE    40       6.829   3.590  -0.111  1.00 36.29           H 
ATOM    638 1HG2 ILE    40       7.632   6.238  -2.658  1.00 36.29           H 
ATOM    639 2HG2 ILE    40       6.600   7.458  -1.914  1.00 36.29           H 
ATOM    640 3HG2 ILE    40       5.877   6.058  -2.706  1.00 36.29           H 
ATOM    641 1HD1 ILE    40       8.946   3.954  -1.282  1.00 36.29           H 
ATOM    642 2HD1 ILE    40       8.064   4.151  -2.796  1.00 36.29           H 
ATOM    643 3HD1 ILE    40       8.036   2.601  -1.956  1.00 36.29           H 
ATOM    644  N   VAL    41       8.728   8.373  -0.362  1.00 65.02           N 
ATOM    645  CA  VAL    41       8.744   9.831  -0.218  1.00 74.12           C 
ATOM    646  C   VAL    41       7.885  10.512  -1.294  1.00 43.23           C 
ATOM    647  O   VAL    41       6.977  11.286  -0.986  1.00 22.33           O 
ATOM    648  CB  VAL    41      10.189  10.386  -0.289  1.00 75.20           C 
ATOM    649  CG1 VAL    41      10.220  11.878   0.039  1.00 21.45           C 
ATOM    650  CG2 VAL    41      11.103   9.604   0.644  1.00 53.13           C 
ATOM    651  H   VAL    41       9.377   7.943  -0.958  1.00 36.29           H 
ATOM    652  HA  VAL    41       8.339  10.071   0.758  1.00 23.52           H 
ATOM    653  HB  VAL    41      10.554  10.257  -1.299  1.00 32.15           H 
ATOM    654 1HG1 VAL    41       9.805  12.038   1.024  1.00 36.29           H 
ATOM    655 2HG1 VAL    41       9.636  12.422  -0.690  1.00 36.29           H 
ATOM    656 3HG1 VAL    41      11.240  12.232   0.018  1.00 36.29           H 
ATOM    657 1HG2 VAL    41      11.114   8.563   0.353  1.00 36.29           H 
ATOM    658 2HG2 VAL    41      10.742   9.689   1.660  1.00 36.29           H 
ATOM    659 3HG2 VAL    41      12.105  10.003   0.587  1.00 36.29           H 
ATOM    660  N   GLN    42       8.182  10.219  -2.561  1.00  3.43           N 
ATOM    661  CA  GLN    42       7.421  10.776  -3.685  1.00 74.24           C 
ATOM    662  C   GLN    42       7.518   9.872  -4.929  1.00 64.11           C 
ATOM    663  O   GLN    42       8.488   9.130  -5.103  1.00 31.14           O 
ATOM    664  CB  GLN    42       7.899  12.213  -3.993  1.00  3.35           C 
ATOM    665  CG  GLN    42       9.315  12.327  -4.573  1.00 33.42           C 
ATOM    666  CD  GLN    42       9.342  12.283  -6.095  1.00 64.51           C 
ATOM    667  OE1 GLN    42       8.383  12.672  -6.753  1.00 10.20           O 
ATOM    668  NE2 GLN    42      10.442  11.846  -6.667  1.00 24.44           N 
ATOM    669  H   GLN    42       8.928   9.611  -2.747  1.00 36.29           H 
ATOM    670  HA  GLN    42       6.383  10.818  -3.383  1.00 54.33           H 
ATOM    671 3HB  GLN    42       7.866  12.785  -3.076  1.00 36.29           H 
ATOM    672 2HB  GLN    42       7.214  12.658  -4.699  1.00 36.29           H 
ATOM    673 3HG  GLN    42       9.912  11.509  -4.194  1.00 36.29           H 
ATOM    674 2HG  GLN    42       9.749  13.263  -4.251  1.00 36.29           H 
ATOM    675 1HE2 GLN    42      11.184  11.571  -6.094  1.00 36.29           H 
ATOM    676 2HE2 GLN    42      10.472  11.823  -7.648  1.00 36.29           H 
ATOM    677  N   VAL    43       6.501   9.937  -5.786  1.00 12.10           N 
ATOM    678  CA  VAL    43       6.417   9.079  -6.978  1.00 22.13           C 
ATOM    679  C   VAL    43       6.363   9.914  -8.265  1.00 21.24           C 
ATOM    680  O   VAL    43       5.746  10.981  -8.297  1.00 40.02           O 
ATOM    681  CB  VAL    43       5.156   8.173  -6.916  1.00 73.42           C 
ATOM    682  CG1 VAL    43       5.002   7.343  -8.195  1.00  5.04           C 
ATOM    683  CG2 VAL    43       5.200   7.273  -5.679  1.00 51.45           C 
ATOM    684  H   VAL    43       5.785  10.585  -5.620  1.00 36.29           H 
ATOM    685  HA  VAL    43       7.292   8.444  -7.006  1.00 12.31           H 
ATOM    686  HB  VAL    43       4.287   8.812  -6.832  1.00 13.50           H 
ATOM    687 1HG1 VAL    43       5.882   6.735  -8.342  1.00 36.29           H 
ATOM    688 2HG1 VAL    43       4.876   8.003  -9.042  1.00 36.29           H 
ATOM    689 3HG1 VAL    43       4.135   6.703  -8.110  1.00 36.29           H 
ATOM    690 1HG2 VAL    43       4.327   6.636  -5.661  1.00 36.29           H 
ATOM    691 2HG2 VAL    43       5.213   7.886  -4.789  1.00 36.29           H 
ATOM    692 3HG2 VAL    43       6.091   6.662  -5.706  1.00 36.29           H 
ATOM    693  N   ALA    44       7.014   9.428  -9.322  1.00 45.22           N 
ATOM    694  CA  ALA    44       6.922  10.066 -10.637  1.00 21.02           C 
ATOM    695  C   ALA    44       5.464  10.070 -11.132  1.00 53.33           C 
ATOM    696  O   ALA    44       4.819   9.021 -11.170  1.00 63.02           O 
ATOM    697  CB  ALA    44       7.823   9.351 -11.638  1.00 30.32           C 
ATOM    698  H   ALA    44       7.566   8.623  -9.217  1.00 36.29           H 
ATOM    699  HA  ALA    44       7.267  11.087 -10.537  1.00 12.11           H 
ATOM    700 1HB  ALA    44       8.840   9.355 -11.271  1.00 36.29           H 
ATOM    701 2HB  ALA    44       7.783   9.861 -12.590  1.00 36.29           H 
ATOM    702 3HB  ALA    44       7.489   8.331 -11.762  1.00 36.29           H 
ATOM    703  N   PRO    45       4.928  11.242 -11.526  1.00 61.12           N 
ATOM    704  CA  PRO    45       3.504  11.387 -11.901  1.00 65.23           C 
ATOM    705  C   PRO    45       3.058  10.429 -13.025  1.00 34.04           C 
ATOM    706  O   PRO    45       1.872  10.125 -13.156  1.00  5.14           O 
ATOM    707  CB  PRO    45       3.394  12.856 -12.354  1.00 52.21           C 
ATOM    708  CG  PRO    45       4.799  13.303 -12.595  1.00 51.52           C 
ATOM    709  CD  PRO    45       5.653  12.521 -11.640  1.00 21.40           C 
ATOM    710  HA  PRO    45       2.865  11.231 -11.043  1.00 60.22           H 
ATOM    711 3HB  PRO    45       2.925  13.438 -11.574  1.00 36.29           H 
ATOM    712 2HB  PRO    45       2.801  12.918 -13.256  1.00 36.29           H 
ATOM    713 3HG  PRO    45       4.886  14.363 -12.396  1.00 36.29           H 
ATOM    714 2HG  PRO    45       5.084  13.091 -13.616  1.00 36.29           H 
ATOM    715 3HD  PRO    45       5.710  13.018 -10.681  1.00 36.29           H 
ATOM    716 2HD  PRO    45       6.643  12.372 -12.050  1.00 36.29           H 
ATOM    717  N   LEU    46       4.012   9.949 -13.821  1.00 24.01           N 
ATOM    718  CA  LEU    46       3.708   9.037 -14.931  1.00 20.22           C 
ATOM    719  C   LEU    46       3.609   7.571 -14.463  1.00 62.34           C 
ATOM    720  O   LEU    46       3.128   6.709 -15.200  1.00  5.34           O 
ATOM    721  CB  LEU    46       4.764   9.166 -16.043  1.00 72.21           C 
ATOM    722  CG  LEU    46       4.808  10.523 -16.775  1.00 55.13           C 
ATOM    723  CD1 LEU    46       5.375  11.624 -15.881  1.00 50.34           C 
ATOM    724  CD2 LEU    46       5.611  10.409 -18.069  1.00 71.50           C 
ATOM    725  H   LEU    46       4.941  10.214 -13.661  1.00 36.29           H 
ATOM    726  HA  LEU    46       2.747   9.325 -15.336  1.00 23.32           H 
ATOM    727 3HB  LEU    46       4.573   8.395 -16.777  1.00 36.29           H 
ATOM    728 2HB  LEU    46       5.737   8.984 -15.607  1.00 36.29           H 
ATOM    729  HG  LEU    46       3.799  10.809 -17.038  1.00 33.23           H 
ATOM    730 1HD1 LEU    46       5.394  12.559 -16.424  1.00 36.29           H 
ATOM    731 2HD1 LEU    46       6.380  11.364 -15.578  1.00 36.29           H 
ATOM    732 3HD1 LEU    46       4.752  11.732 -15.005  1.00 36.29           H 
ATOM    733 1HD2 LEU    46       6.630  10.127 -17.842  1.00 36.29           H 
ATOM    734 2HD2 LEU    46       5.608  11.361 -18.583  1.00 36.29           H 
ATOM    735 3HD2 LEU    46       5.164   9.659 -18.704  1.00 36.29           H 
ATOM    736  N   GLY    47       4.064   7.296 -13.240  1.00 13.15           N 
ATOM    737  CA  GLY    47       3.998   5.941 -12.693  1.00 32.42           C 
ATOM    738  C   GLY    47       5.232   5.558 -11.879  1.00  3.32           C 
ATOM    739  O   GLY    47       5.126   5.220 -10.702  1.00 22.12           O 
ATOM    740  H   GLY    47       4.436   8.020 -12.697  1.00 36.29           H 
ATOM    741 3HA  GLY    47       3.890   5.239 -13.507  1.00 36.29           H 
ATOM    742 2HA  GLY    47       3.128   5.869 -12.057  1.00 36.29           H 
ATOM    743  N   ASP    48       6.401   5.592 -12.514  1.00 13.23           N 
ATOM    744  CA  ASP    48       7.667   5.279 -11.842  1.00 64.04           C 
ATOM    745  C   ASP    48       8.847   5.914 -12.615  1.00 61.24           C 
ATOM    746  O   ASP    48       8.654   6.395 -13.737  1.00 51.03           O 
ATOM    747  CB  ASP    48       7.820   3.754 -11.703  1.00 13.35           C 
ATOM    748  CG  ASP    48       8.158   3.054 -13.008  1.00  0.30           C 
ATOM    749  OD1 ASP    48       7.298   3.021 -13.911  1.00 41.50           O 
ATOM    750  OD2 ASP    48       9.275   2.505 -13.126  1.00 33.25           O 
ATOM    751  H   ASP    48       6.416   5.834 -13.464  1.00 36.29           H 
ATOM    752  HA  ASP    48       7.631   5.721 -10.852  1.00 40.21           H 
ATOM    753 3HB  ASP    48       6.890   3.349 -11.333  1.00 36.29           H 
ATOM    754 2HB  ASP    48       8.599   3.540 -10.988  1.00 36.29           H 
ATOM    755  N   PRO    49      10.088   5.935 -12.063  1.00 61.44           N 
ATOM    756  CA  PRO    49      10.463   5.282 -10.785  1.00 44.01           C 
ATOM    757  C   PRO    49       9.884   5.955  -9.525  1.00 75.40           C 
ATOM    758  O   PRO    49       9.372   7.076  -9.571  1.00 60.01           O 
ATOM    759  CB  PRO    49      11.994   5.387 -10.788  1.00  3.11           C 
ATOM    760  CG  PRO    49      12.279   6.611 -11.586  1.00 14.11           C 
ATOM    761  CD  PRO    49      11.239   6.634 -12.672  1.00 25.10           C 
ATOM    762  HA  PRO    49      10.185   4.239 -10.784  1.00 21.21           H 
ATOM    763 3HB  PRO    49      12.418   4.507 -11.251  1.00 36.29           H 
ATOM    764 2HB  PRO    49      12.361   5.478  -9.774  1.00 36.29           H 
ATOM    765 3HG  PRO    49      13.269   6.553 -12.014  1.00 36.29           H 
ATOM    766 2HG  PRO    49      12.191   7.489 -10.960  1.00 36.29           H 
ATOM    767 3HD  PRO    49      11.592   6.103 -13.547  1.00 36.29           H 
ATOM    768 2HD  PRO    49      10.981   7.652 -12.929  1.00 36.29           H 
ATOM    769  N   ILE    50       9.973   5.244  -8.399  1.00 53.23           N 
ATOM    770  CA  ILE    50       9.529   5.766  -7.102  1.00 62.13           C 
ATOM    771  C   ILE    50      10.734   6.058  -6.192  1.00  4.11           C 
ATOM    772  O   ILE    50      11.699   5.290  -6.156  1.00  2.10           O 
ATOM    773  CB  ILE    50       8.555   4.794  -6.364  1.00 22.25           C 
ATOM    774  CG1 ILE    50       9.205   3.418  -6.074  1.00 73.23           C 
ATOM    775  CG2 ILE    50       7.265   4.617  -7.163  1.00 33.53           C 
ATOM    776  CD1 ILE    50       9.099   2.411  -7.206  1.00 22.32           C 
ATOM    777  H   ILE    50      10.362   4.346  -8.438  1.00 36.29           H 
ATOM    778  HA  ILE    50       9.002   6.697  -7.282  1.00 12.14           H 
ATOM    779  HB  ILE    50       8.289   5.255  -5.421  1.00 55.52           H 
ATOM    780 3HG1 ILE    50       8.731   2.983  -5.204  1.00 36.29           H 
ATOM    781 2HG1 ILE    50      10.255   3.559  -5.864  1.00 36.29           H 
ATOM    782 1HG2 ILE    50       6.756   5.566  -7.239  1.00 36.29           H 
ATOM    783 2HG2 ILE    50       6.625   3.906  -6.663  1.00 36.29           H 
ATOM    784 3HG2 ILE    50       7.499   4.255  -8.155  1.00 36.29           H 
ATOM    785 1HD1 ILE    50       9.542   2.820  -8.101  1.00 36.29           H 
ATOM    786 2HD1 ILE    50       8.059   2.183  -7.391  1.00 36.29           H 
ATOM    787 3HD1 ILE    50       9.619   1.506  -6.930  1.00 36.29           H 
ATOM    788  N   VAL    51      10.682   7.174  -5.466  1.00 71.23           N 
ATOM    789  CA  VAL    51      11.762   7.545  -4.543  1.00 73.25           C 
ATOM    790  C   VAL    51      11.393   7.193  -3.096  1.00  4.52           C 
ATOM    791  O   VAL    51      10.426   7.720  -2.537  1.00 42.01           O 
ATOM    792  CB  VAL    51      12.102   9.054  -4.642  1.00  0.44           C 
ATOM    793  CG1 VAL    51      13.223   9.428  -3.670  1.00 61.10           C 
ATOM    794  CG2 VAL    51      12.486   9.422  -6.075  1.00 12.43           C 
ATOM    795  H   VAL    51       9.901   7.762  -5.548  1.00 36.29           H 
ATOM    796  HA  VAL    51      12.645   6.982  -4.822  1.00 23.14           H 
ATOM    797  HB  VAL    51      11.219   9.620  -4.372  1.00  3.15           H 
ATOM    798 1HG1 VAL    51      12.908   9.223  -2.658  1.00 36.29           H 
ATOM    799 2HG1 VAL    51      13.450  10.480  -3.768  1.00 36.29           H 
ATOM    800 3HG1 VAL    51      14.107   8.847  -3.896  1.00 36.29           H 
ATOM    801 1HG2 VAL    51      12.706  10.477  -6.130  1.00 36.29           H 
ATOM    802 2HG2 VAL    51      11.665   9.191  -6.739  1.00 36.29           H 
ATOM    803 3HG2 VAL    51      13.358   8.855  -6.374  1.00 36.29           H 
ATOM    804  N   CYS    52      12.177   6.304  -2.496  1.00 70.13           N 
ATOM    805  CA  CYS    52      11.915   5.816  -1.136  1.00  4.10           C 
ATOM    806  C   CYS    52      13.096   6.095  -0.198  1.00 50.25           C 
ATOM    807  O   CYS    52      14.147   6.562  -0.630  1.00 43.52           O 
ATOM    808  CB  CYS    52      11.640   4.312  -1.175  1.00 50.52           C 
ATOM    809  SG  CYS    52      12.998   3.330  -1.850  1.00 41.54           S 
ATOM    810  H   CYS    52      12.962   5.964  -2.978  1.00 36.29           H 
ATOM    811  HA  CYS    52      11.039   6.324  -0.755  1.00 31.21           H 
ATOM    812 3HB  CYS    52      10.768   4.126  -1.784  1.00 36.29           H 
ATOM    813 2HB  CYS    52      11.452   3.961  -0.169  1.00 36.29           H 
ATOM    814  HG  CYS    52      13.315   3.821  -3.042  1.00 52.01           H 
ATOM    815  N   LYS    53      12.911   5.811   1.090  1.00 72.54           N 
ATOM    816  CA  LYS    53      13.973   5.985   2.092  1.00 44.35           C 
ATOM    817  C   LYS    53      14.402   4.645   2.705  1.00 65.12           C 
ATOM    818  O   LYS    53      13.600   3.947   3.329  1.00 32.25           O 
ATOM    819  CB  LYS    53      13.507   6.929   3.210  1.00 52.32           C 
ATOM    820  CG  LYS    53      13.434   8.396   2.797  1.00 14.52           C 
ATOM    821  CD  LYS    53      12.721   9.250   3.847  1.00 75.52           C 
ATOM    822  CE  LYS    53      13.407   9.167   5.208  1.00 21.32           C 
ATOM    823  NZ  LYS    53      12.598   9.794   6.286  1.00 20.35           N 
ATOM    824  H   LYS    53      12.035   5.480   1.379  1.00 36.29           H 
ATOM    825  HA  LYS    53      14.828   6.428   1.599  1.00 12.25           H 
ATOM    826 3HB  LYS    53      14.192   6.849   4.043  1.00 36.29           H 
ATOM    827 2HB  LYS    53      12.524   6.620   3.537  1.00 36.29           H 
ATOM    828 3HG  LYS    53      12.898   8.470   1.863  1.00 36.29           H 
ATOM    829 2HG  LYS    53      14.439   8.773   2.665  1.00 36.29           H 
ATOM    830 3HD  LYS    53      11.700   8.903   3.945  1.00 36.29           H 
ATOM    831 2HD  LYS    53      12.719  10.279   3.516  1.00 36.29           H 
ATOM    832 3HE  LYS    53      14.361   9.671   5.148  1.00 36.29           H 
ATOM    833 2HE  LYS    53      13.569   8.127   5.454  1.00 36.29           H 
ATOM    834 1HZ  LYS    53      12.489  10.812   6.116  1.00 36.29           H 
ATOM    835 2HZ  LYS    53      13.065   9.656   7.207  1.00 36.29           H 
ATOM    836 3HZ  LYS    53      11.653   9.357   6.325  1.00 36.29           H 
ATOM    837  N   ILE    54      15.672   4.297   2.514  1.00 51.25           N 
ATOM    838  CA  ILE    54      16.270   3.111   3.134  1.00 23.41           C 
ATOM    839  C   ILE    54      17.572   3.492   3.847  1.00 53.31           C 
ATOM    840  O   ILE    54      18.478   4.059   3.236  1.00 31.01           O 
ATOM    841  CB  ILE    54      16.563   2.000   2.093  1.00 43.32           C 
ATOM    842  CG1 ILE    54      15.263   1.574   1.392  1.00  2.52           C 
ATOM    843  CG2 ILE    54      17.241   0.798   2.756  1.00 24.40           C 
ATOM    844  CD1 ILE    54      15.453   0.476   0.368  1.00 41.13           C 
ATOM    845  H   ILE    54      16.232   4.858   1.933  1.00 36.29           H 
ATOM    846  HA  ILE    54      15.572   2.721   3.864  1.00 73.43           H 
ATOM    847  HB  ILE    54      17.245   2.400   1.355  1.00 72.43           H 
ATOM    848 3HG1 ILE    54      14.840   2.430   0.885  1.00 36.29           H 
ATOM    849 2HG1 ILE    54      14.560   1.218   2.132  1.00 36.29           H 
ATOM    850 1HG2 ILE    54      18.154   1.118   3.239  1.00 36.29           H 
ATOM    851 2HG2 ILE    54      17.476   0.055   2.007  1.00 36.29           H 
ATOM    852 3HG2 ILE    54      16.578   0.367   3.493  1.00 36.29           H 
ATOM    853 1HD1 ILE    54      16.145   0.806  -0.391  1.00 36.29           H 
ATOM    854 2HD1 ILE    54      14.502   0.247  -0.089  1.00 36.29           H 
ATOM    855 3HD1 ILE    54      15.843  -0.408   0.852  1.00 36.29           H 
ATOM    856  N   GLY    55      17.662   3.191   5.137  1.00 43.33           N 
ATOM    857  CA  GLY    55      18.825   3.595   5.916  1.00  4.11           C 
ATOM    858  C   GLY    55      19.059   5.101   5.884  1.00 44.34           C 
ATOM    859  O   GLY    55      20.193   5.558   5.713  1.00 62.45           O 
ATOM    860  H   GLY    55      16.943   2.680   5.562  1.00 36.29           H 
ATOM    861 3HA  GLY    55      19.698   3.098   5.523  1.00 36.29           H 
ATOM    862 2HA  GLY    55      18.681   3.289   6.941  1.00 36.29           H 
ATOM    863  N   ASN    56      17.966   5.859   6.020  1.00 23.43           N 
ATOM    864  CA  ASN    56      17.985   7.332   6.019  1.00 24.01           C 
ATOM    865  C   ASN    56      18.160   7.926   4.601  1.00 44.12           C 
ATOM    866  O   ASN    56      17.672   9.022   4.322  1.00 43.12           O 
ATOM    867  CB  ASN    56      19.075   7.872   6.964  1.00  5.22           C 
ATOM    868  CG  ASN    56      18.955   9.369   7.204  1.00 31.32           C 
ATOM    869  OD1 ASN    56      19.509  10.179   6.468  1.00 62.00           O 
ATOM    870  ND2 ASN    56      18.236   9.752   8.240  1.00  4.13           N 
ATOM    871  H   ASN    56      17.103   5.407   6.132  1.00 36.29           H 
ATOM    872  HA  ASN    56      17.023   7.654   6.395  1.00 23.35           H 
ATOM    873 3HB  ASN    56      20.046   7.671   6.533  1.00 36.29           H 
ATOM    874 2HB  ASN    56      19.000   7.366   7.916  1.00 36.29           H 
ATOM    875 1HD2 ASN    56      17.820   9.061   8.797  1.00 36.29           H 
ATOM    876 2HD2 ASN    56      18.152  10.712   8.415  1.00 36.29           H 
ATOM    877  N   ARG    57      18.831   7.200   3.704  1.00  2.33           N 
ATOM    878  CA  ARG    57      19.129   7.721   2.360  1.00 43.52           C 
ATOM    879  C   ARG    57      17.997   7.417   1.360  1.00 52.21           C 
ATOM    880  O   ARG    57      17.310   6.399   1.466  1.00 63.30           O 
ATOM    881  CB  ARG    57      20.461   7.143   1.852  1.00 74.32           C 
ATOM    882  CG  ARG    57      20.467   5.624   1.703  1.00 64.12           C 
ATOM    883  CD  ARG    57      21.866   5.082   1.432  1.00 25.23           C 
ATOM    884  NE  ARG    57      21.877   3.625   1.305  1.00 41.34           N 
ATOM    885  CZ  ARG    57      21.857   2.794   2.312  1.00  0.11           C 
ATOM    886  NH1 ARG    57      21.805   3.224   3.536  1.00 43.11           N 
ATOM    887  NH2 ARG    57      21.892   1.524   2.089  1.00  4.44           N 
ATOM    888  H   ARG    57      19.122   6.295   3.940  1.00 36.29           H 
ATOM    889  HA  ARG    57      19.231   8.794   2.441  1.00 55.54           H 
ATOM    890 3HB  ARG    57      21.242   7.417   2.547  1.00 36.29           H 
ATOM    891 2HB  ARG    57      20.686   7.579   0.888  1.00 36.29           H 
ATOM    892 3HG  ARG    57      19.818   5.348   0.883  1.00 36.29           H 
ATOM    893 2HG  ARG    57      20.095   5.182   2.617  1.00 36.29           H 
ATOM    894 3HD  ARG    57      22.517   5.369   2.245  1.00 36.29           H 
ATOM    895 2HD  ARG    57      22.232   5.513   0.511  1.00 36.29           H 
ATOM    896  HE  ARG    57      21.916   3.251   0.399  1.00 43.20           H 
ATOM    897 1HH1 ARG    57      21.780   4.201   3.720  1.00 36.29           H 
ATOM    898 2HH1 ARG    57      21.789   2.571   4.291  1.00 36.29           H 
ATOM    899 1HH2 ARG    57      21.937   1.188   1.149  1.00 36.29           H 
ATOM    900 2HH2 ARG    57      21.876   0.883   2.852  1.00 36.29           H 
ATOM    901  N   ASN    58      17.806   8.314   0.392  1.00  2.41           N 
ATOM    902  CA  ASN    58      16.763   8.148  -0.629  1.00  2.41           C 
ATOM    903  C   ASN    58      17.240   7.279  -1.803  1.00  2.33           C 
ATOM    904  O   ASN    58      18.232   7.601  -2.464  1.00 63.11           O 
ATOM    905  CB  ASN    58      16.314   9.515  -1.150  1.00 41.10           C 
ATOM    906  CG  ASN    58      15.650  10.352  -0.075  1.00 13.22           C 
ATOM    907  OD1 ASN    58      16.304  11.093   0.645  1.00 44.15           O 
ATOM    908  ND2 ASN    58      14.343  10.240   0.041  1.00 24.54           N 
ATOM    909  H   ASN    58      18.373   9.114   0.368  1.00 36.29           H 
ATOM    910  HA  ASN    58      15.918   7.660  -0.161  1.00 24.10           H 
ATOM    911 3HB  ASN    58      15.611   9.375  -1.960  1.00 36.29           H 
ATOM    912 2HB  ASN    58      17.174  10.055  -1.521  1.00 36.29           H 
ATOM    913 1HD2 ASN    58      13.876   9.632  -0.565  1.00 36.29           H 
ATOM    914 2HD2 ASN    58      13.897  10.779   0.725  1.00 36.29           H 
ATOM    915  N   ILE    59      16.520   6.190  -2.068  1.00 34.32           N 
ATOM    916  CA  ILE    59      16.845   5.283  -3.179  1.00 73.51           C 
ATOM    917  C   ILE    59      15.782   5.354  -4.293  1.00 70.25           C 
ATOM    918  O   ILE    59      14.581   5.247  -4.028  1.00 22.13           O 
ATOM    919  CB  ILE    59      16.965   3.815  -2.690  1.00 23.45           C 
ATOM    920  CG1 ILE    59      18.032   3.695  -1.584  1.00 74.33           C 
ATOM    921  CG2 ILE    59      17.285   2.875  -3.856  1.00 15.02           C 
ATOM    922  CD1 ILE    59      19.432   4.079  -2.022  1.00 13.53           C 
ATOM    923  H   ILE    59      15.749   5.984  -1.499  1.00 36.29           H 
ATOM    924  HA  ILE    59      17.801   5.584  -3.588  1.00  1.30           H 
ATOM    925  HB  ILE    59      16.007   3.519  -2.283  1.00 64.41           H 
ATOM    926 3HG1 ILE    59      18.065   2.674  -1.232  1.00 36.29           H 
ATOM    927 2HG1 ILE    59      17.758   4.341  -0.763  1.00 36.29           H 
ATOM    928 1HG2 ILE    59      18.205   3.188  -4.332  1.00 36.29           H 
ATOM    929 2HG2 ILE    59      16.479   2.907  -4.577  1.00 36.29           H 
ATOM    930 3HG2 ILE    59      17.397   1.866  -3.488  1.00 36.29           H 
ATOM    931 1HD1 ILE    59      19.444   5.115  -2.326  1.00 36.29           H 
ATOM    932 2HD1 ILE    59      19.737   3.456  -2.851  1.00 36.29           H 
ATOM    933 3HD1 ILE    59      20.116   3.939  -1.198  1.00 36.29           H 
ATOM    934  N   THR    60      16.233   5.539  -5.535  1.00 43.10           N 
ATOM    935  CA  THR    60      15.336   5.545  -6.700  1.00 34.12           C 
ATOM    936  C   THR    60      15.132   4.123  -7.238  1.00 54.15           C 
ATOM    937  O   THR    60      16.057   3.511  -7.776  1.00 51.13           O 
ATOM    938  CB  THR    60      15.885   6.435  -7.843  1.00 74.34           C 
ATOM    939  OG1 THR    60      16.092   7.782  -7.384  1.00 72.30           O 
ATOM    940  CG2 THR    60      14.931   6.456  -9.033  1.00 65.10           C 
ATOM    941  H   THR    60      17.195   5.672  -5.675  1.00 36.29           H 
ATOM    942  HA  THR    60      14.381   5.945  -6.386  1.00 51.21           H 
ATOM    943  HB  THR    60      16.833   6.027  -8.171  1.00 73.51           H 
ATOM    944  HG1 THR    60      16.320   7.772  -6.444  1.00 72.44           H 
ATOM    945 1HG2 THR    60      14.822   5.455  -9.430  1.00 36.29           H 
ATOM    946 2HG2 THR    60      15.328   7.103  -9.801  1.00 36.29           H 
ATOM    947 3HG2 THR    60      13.967   6.826  -8.716  1.00 36.29           H 
ATOM    948  N   LEU    61      13.915   3.606  -7.108  1.00 63.14           N 
ATOM    949  CA  LEU    61      13.625   2.206  -7.443  1.00 44.53           C 
ATOM    950  C   LEU    61      12.578   2.113  -8.578  1.00 20.35           C 
ATOM    951  O   LEU    61      11.699   2.967  -8.695  1.00 64.34           O 
ATOM    952  CB  LEU    61      13.140   1.497  -6.161  1.00 44.33           C 
ATOM    953  CG  LEU    61      13.415  -0.016  -6.057  1.00 34.51           C 
ATOM    954  CD1 LEU    61      12.478  -0.813  -6.944  1.00 22.52           C 
ATOM    955  CD2 LEU    61      14.871  -0.328  -6.396  1.00 62.10           C 
ATOM    956  H   LEU    61      13.189   4.176  -6.775  1.00 36.29           H 
ATOM    957  HA  LEU    61      14.543   1.742  -7.778  1.00 54.23           H 
ATOM    958 3HB  LEU    61      12.072   1.651  -6.075  1.00 36.29           H 
ATOM    959 2HB  LEU    61      13.614   1.977  -5.314  1.00 36.29           H 
ATOM    960  HG  LEU    61      13.241  -0.331  -5.035  1.00 61.22           H 
ATOM    961 1HD1 LEU    61      12.664  -0.570  -7.980  1.00 36.29           H 
ATOM    962 2HD1 LEU    61      11.454  -0.571  -6.697  1.00 36.29           H 
ATOM    963 3HD1 LEU    61      12.644  -1.869  -6.787  1.00 36.29           H 
ATOM    964 1HD2 LEU    61      15.048  -1.387  -6.287  1.00 36.29           H 
ATOM    965 2HD2 LEU    61      15.523   0.215  -5.725  1.00 36.29           H 
ATOM    966 3HD2 LEU    61      15.078  -0.032  -7.415  1.00 36.29           H 
ATOM    967  N   ARG    62      12.687   1.084  -9.426  1.00  5.25           N 
ATOM    968  CA  ARG    62      11.758   0.904 -10.564  1.00  0.12           C 
ATOM    969  C   ARG    62      10.657  -0.116 -10.205  1.00 14.25           C 
ATOM    970  O   ARG    62      10.910  -1.052  -9.452  1.00 12.44           O 
ATOM    971  CB  ARG    62      12.532   0.418 -11.809  1.00 14.05           C 
ATOM    972  CG  ARG    62      13.974   0.922 -11.884  1.00  0.13           C 
ATOM    973  CD  ARG    62      14.068   2.445 -11.941  1.00 64.11           C 
ATOM    974  NE  ARG    62      15.370   2.916 -11.472  1.00 64.20           N 
ATOM    975  CZ  ARG    62      15.885   4.079 -11.755  1.00 11.14           C 
ATOM    976  NH1 ARG    62      15.305   4.866 -12.604  1.00 64.40           N 
ATOM    977  NH2 ARG    62      17.003   4.441 -11.208  1.00  5.21           N 
ATOM    978  H   ARG    62      13.403   0.422  -9.283  1.00 36.29           H 
ATOM    979  HA  ARG    62      11.298   1.859 -10.781  1.00 55.31           H 
ATOM    980 3HB  ARG    62      12.012   0.753 -12.697  1.00 36.29           H 
ATOM    981 2HB  ARG    62      12.555  -0.664 -11.808  1.00 36.29           H 
ATOM    982 3HG  ARG    62      14.442   0.507 -12.768  1.00 36.29           H 
ATOM    983 2HG  ARG    62      14.505   0.577 -11.007  1.00 36.29           H 
ATOM    984 3HD  ARG    62      13.295   2.869 -11.315  1.00 36.29           H 
ATOM    985 2HD  ARG    62      13.922   2.767 -12.962  1.00 36.29           H 
ATOM    986  HE  ARG    62      15.872   2.323 -10.873  1.00 11.33           H 
ATOM    987 1HH1 ARG    62      14.461   4.583 -13.052  1.00 36.29           H 
ATOM    988 2HH1 ARG    62      15.709   5.756 -12.810  1.00 36.29           H 
ATOM    989 1HH2 ARG    62      17.467   3.827 -10.572  1.00 36.29           H 
ATOM    990 2HH2 ARG    62      17.398   5.335 -11.418  1.00 36.29           H 
ATOM    991  N   LYS    63       9.444   0.040 -10.757  1.00 50.11           N 
ATOM    992  CA  LYS    63       8.329  -0.874 -10.418  1.00 15.24           C 
ATOM    993  C   LYS    63       8.701  -2.345 -10.655  1.00  2.52           C 
ATOM    994  O   LYS    63       8.415  -3.199  -9.816  1.00  5.44           O 
ATOM    995  CB  LYS    63       7.044  -0.544 -11.199  1.00 12.43           C 
ATOM    996  CG  LYS    63       6.342   0.734 -10.740  1.00 21.11           C 
ATOM    997  CD  LYS    63       4.849   0.729 -11.083  1.00 33.00           C 
ATOM    998  CE  LYS    63       4.593   0.579 -12.581  1.00 42.00           C 
ATOM    999  NZ  LYS    63       4.997   1.787 -13.349  1.00 30.20           N 
ATOM   1000  H   LYS    63       9.297   0.764 -11.402  1.00 36.29           H 
ATOM   1001  HA  LYS    63       8.127  -0.747  -9.363  1.00 14.34           H 
ATOM   1002 3HB  LYS    63       6.350  -1.367 -11.091  1.00 36.29           H 
ATOM   1003 2HB  LYS    63       7.292  -0.435 -12.246  1.00 36.29           H 
ATOM   1004 3HG  LYS    63       6.808   1.576 -11.224  1.00 36.29           H 
ATOM   1005 2HG  LYS    63       6.450   0.831  -9.669  1.00 36.29           H 
ATOM   1006 3HD  LYS    63       4.413   1.658 -10.746  1.00 36.29           H 
ATOM   1007 2HD  LYS    63       4.377  -0.094 -10.567  1.00 36.29           H 
ATOM   1008 3HE  LYS    63       3.537   0.405 -12.736  1.00 36.29           H 
ATOM   1009 2HE  LYS    63       5.150  -0.269 -12.949  1.00 36.29           H 
ATOM   1010 1HZ  LYS    63       5.989   2.028 -13.153  1.00 36.29           H 
ATOM   1011 2HZ  LYS    63       4.396   2.594 -13.092  1.00 36.29           H 
ATOM   1012 3HZ  LYS    63       4.895   1.610 -14.369  1.00 36.29           H 
ATOM   1013  N   ARG    64       9.357  -2.628 -11.783  1.00  1.34           N 
ATOM   1014  CA  ARG    64       9.785  -3.998 -12.110  1.00 73.25           C 
ATOM   1015  C   ARG    64      10.526  -4.656 -10.924  1.00 60.40           C 
ATOM   1016  O   ARG    64      10.294  -5.819 -10.597  1.00 45.22           O 
ATOM   1017  CB  ARG    64      10.710  -3.987 -13.337  1.00  4.23           C 
ATOM   1018  CG  ARG    64      12.009  -3.221 -13.102  1.00 64.14           C 
ATOM   1019  CD  ARG    64      13.114  -3.634 -14.063  1.00 24.41           C 
ATOM   1020  NE  ARG    64      14.441  -3.279 -13.558  1.00 43.52           N 
ATOM   1021  CZ  ARG    64      15.548  -3.868 -13.929  1.00 14.12           C 
ATOM   1022  NH1 ARG    64      15.524  -4.827 -14.799  1.00 23.40           N 
ATOM   1023  NH2 ARG    64      16.678  -3.515 -13.404  1.00 63.42           N 
ATOM   1024  H   ARG    64       9.545  -1.903 -12.419  1.00 36.29           H 
ATOM   1025  HA  ARG    64       8.901  -4.578 -12.339  1.00  4.42           H 
ATOM   1026 3HB  ARG    64      10.189  -3.529 -14.167  1.00 36.29           H 
ATOM   1027 2HB  ARG    64      10.956  -5.008 -13.598  1.00 36.29           H 
ATOM   1028 3HG  ARG    64      12.337  -3.408 -12.093  1.00 36.29           H 
ATOM   1029 2HG  ARG    64      11.819  -2.164 -13.222  1.00 36.29           H 
ATOM   1030 3HD  ARG    64      12.954  -3.136 -15.010  1.00 36.29           H 
ATOM   1031 2HD  ARG    64      13.069  -4.704 -14.209  1.00 36.29           H 
ATOM   1032  HE  ARG    64      14.499  -2.571 -12.887  1.00 41.34           H 
ATOM   1033 1HH1 ARG    64      14.658  -5.123 -15.190  1.00 36.29           H 
ATOM   1034 2HH1 ARG    64      16.374  -5.269 -15.073  1.00 36.29           H 
ATOM   1035 1HH2 ARG    64      16.702  -2.795 -12.705  1.00 36.29           H 
ATOM   1036 2HH2 ARG    64      17.520  -3.961 -13.693  1.00 36.29           H 
ATOM   1037  N   GLU    65      11.404  -3.880 -10.285  1.00 61.05           N 
ATOM   1038  CA  GLU    65      12.196  -4.349  -9.145  1.00 55.32           C 
ATOM   1039  C   GLU    65      11.343  -4.329  -7.870  1.00  3.51           C 
ATOM   1040  O   GLU    65      11.424  -5.222  -7.029  1.00 44.33           O 
ATOM   1041  CB  GLU    65      13.432  -3.442  -8.974  1.00  1.13           C 
ATOM   1042  CG  GLU    65      14.341  -3.388 -10.209  1.00 41.14           C 
ATOM   1043  CD  GLU    65      15.236  -2.153 -10.271  1.00 41.31           C 
ATOM   1044  OE1 GLU    65      16.203  -2.161 -11.068  1.00  4.52           O 
ATOM   1045  OE2 GLU    65      14.960  -1.162  -9.560  1.00 15.04           O 
ATOM   1046  H   GLU    65      11.512  -2.954 -10.578  1.00 36.29           H 
ATOM   1047  HA  GLU    65      12.518  -5.362  -9.343  1.00  5.33           H 
ATOM   1048 3HB  GLU    65      14.017  -3.802  -8.139  1.00 36.29           H 
ATOM   1049 2HB  GLU    65      13.096  -2.438  -8.757  1.00 36.29           H 
ATOM   1050 3HG  GLU    65      13.725  -3.403 -11.093  1.00 36.29           H 
ATOM   1051 2HG  GLU    65      14.972  -4.264 -10.208  1.00 36.29           H 
ATOM   1052  N   ALA    66      10.501  -3.306  -7.759  1.00 74.01           N 
ATOM   1053  CA  ALA    66       9.648  -3.105  -6.586  1.00 54.13           C 
ATOM   1054  C   ALA    66       8.618  -4.233  -6.402  1.00 62.01           C 
ATOM   1055  O   ALA    66       8.259  -4.570  -5.274  1.00 65.11           O 
ATOM   1056  CB  ALA    66       8.948  -1.759  -6.691  1.00 33.23           C 
ATOM   1057  H   ALA    66      10.452  -2.660  -8.493  1.00 36.29           H 
ATOM   1058  HA  ALA    66      10.289  -3.077  -5.714  1.00  4.22           H 
ATOM   1059 1HB  ALA    66       8.336  -1.741  -7.582  1.00 36.29           H 
ATOM   1060 2HB  ALA    66       9.685  -0.971  -6.747  1.00 36.29           H 
ATOM   1061 3HB  ALA    66       8.324  -1.606  -5.823  1.00 36.29           H 
ATOM   1062  N   ASP    67       8.148  -4.812  -7.509  1.00 12.11           N 
ATOM   1063  CA  ASP    67       7.185  -5.920  -7.452  1.00  0.15           C 
ATOM   1064  C   ASP    67       7.825  -7.206  -6.901  1.00  3.24           C 
ATOM   1065  O   ASP    67       7.137  -8.193  -6.647  1.00 33.51           O 
ATOM   1066  CB  ASP    67       6.581  -6.186  -8.836  1.00  4.12           C 
ATOM   1067  CG  ASP    67       5.732  -5.032  -9.343  1.00 11.24           C 
ATOM   1068  OD1 ASP    67       5.988  -4.550 -10.467  1.00 73.02           O 
ATOM   1069  OD2 ASP    67       4.789  -4.615  -8.630  1.00 34.24           O 
ATOM   1070  H   ASP    67       8.452  -4.485  -8.384  1.00 36.29           H 
ATOM   1071  HA  ASP    67       6.391  -5.623  -6.780  1.00 33.35           H 
ATOM   1072 3HB  ASP    67       5.960  -7.071  -8.786  1.00 36.29           H 
ATOM   1073 2HB  ASP    67       7.382  -6.358  -9.541  1.00 36.29           H 
ATOM   1074  N   LEU    68       9.144  -7.192  -6.731  1.00 24.35           N 
ATOM   1075  CA  LEU    68       9.874  -8.339  -6.185  1.00 61.32           C 
ATOM   1076  C   LEU    68      10.061  -8.228  -4.664  1.00  1.11           C 
ATOM   1077  O   LEU    68      10.298  -9.226  -3.985  1.00 74.44           O 
ATOM   1078  CB  LEU    68      11.237  -8.455  -6.881  1.00 72.30           C 
ATOM   1079  CG  LEU    68      11.162  -8.742  -8.387  1.00 74.11           C 
ATOM   1080  CD1 LEU    68      12.512  -8.513  -9.052  1.00 61.03           C 
ATOM   1081  CD2 LEU    68      10.673 -10.168  -8.626  1.00 22.12           C 
ATOM   1082  H   LEU    68       9.645  -6.389  -6.989  1.00 36.29           H 
ATOM   1083  HA  LEU    68       9.299  -9.232  -6.397  1.00 54.21           H 
ATOM   1084 3HB  LEU    68      11.796  -9.254  -6.412  1.00 36.29           H 
ATOM   1085 2HB  LEU    68      11.774  -7.529  -6.733  1.00 36.29           H 
ATOM   1086  HG  LEU    68      10.451  -8.066  -8.840  1.00 51.12           H 
ATOM   1087 1HD1 LEU    68      12.827  -7.491  -8.889  1.00 36.29           H 
ATOM   1088 2HD1 LEU    68      12.427  -8.695 -10.113  1.00 36.29           H 
ATOM   1089 3HD1 LEU    68      13.245  -9.185  -8.630  1.00 36.29           H 
ATOM   1090 1HD2 LEU    68       9.688 -10.288  -8.197  1.00 36.29           H 
ATOM   1091 2HD2 LEU    68      11.353 -10.868  -8.161  1.00 36.29           H 
ATOM   1092 3HD2 LEU    68      10.627 -10.361  -9.687  1.00 36.29           H 
ATOM   1093  N   ILE    69       9.953  -7.016  -4.126  1.00 32.41           N 
ATOM   1094  CA  ILE    69      10.132  -6.802  -2.685  1.00 63.31           C 
ATOM   1095  C   ILE    69       8.779  -6.750  -1.955  1.00 63.13           C 
ATOM   1096  O   ILE    69       8.015  -5.790  -2.086  1.00 64.30           O 
ATOM   1097  CB  ILE    69      10.945  -5.510  -2.371  1.00 24.51           C 
ATOM   1098  CG1 ILE    69      12.412  -5.639  -2.835  1.00 14.50           C 
ATOM   1099  CG2 ILE    69      10.899  -5.195  -0.876  1.00 21.25           C 
ATOM   1100  CD1 ILE    69      12.599  -5.655  -4.336  1.00  2.34           C 
ATOM   1101  H   ILE    69       9.739  -6.251  -4.703  1.00 36.29           H 
ATOM   1102  HA  ILE    69      10.693  -7.646  -2.300  1.00 72.51           H 
ATOM   1103  HB  ILE    69      10.482  -4.687  -2.898  1.00 43.31           H 
ATOM   1104 3HG1 ILE    69      12.827  -6.556  -2.440  1.00 36.29           H 
ATOM   1105 2HG1 ILE    69      12.979  -4.804  -2.449  1.00 36.29           H 
ATOM   1106 1HG2 ILE    69      11.498  -4.318  -0.674  1.00 36.29           H 
ATOM   1107 2HG2 ILE    69      11.290  -6.033  -0.317  1.00 36.29           H 
ATOM   1108 3HG2 ILE    69       9.878  -5.008  -0.578  1.00 36.29           H 
ATOM   1109 1HD1 ILE    69      12.101  -6.517  -4.753  1.00 36.29           H 
ATOM   1110 2HD1 ILE    69      13.653  -5.703  -4.566  1.00 36.29           H 
ATOM   1111 3HD1 ILE    69      12.179  -4.756  -4.762  1.00 36.29           H 
ATOM   1112  N   GLU    70       8.493  -7.803  -1.192  1.00 51.00           N 
ATOM   1113  CA  GLU    70       7.270  -7.889  -0.385  1.00 21.43           C 
ATOM   1114  C   GLU    70       7.465  -7.194   0.973  1.00  1.31           C 
ATOM   1115  O   GLU    70       8.252  -7.642   1.806  1.00  1.33           O 
ATOM   1116  CB  GLU    70       6.887  -9.371  -0.196  1.00 12.20           C 
ATOM   1117  CG  GLU    70       5.743  -9.638   0.787  1.00 34.43           C 
ATOM   1118  CD  GLU    70       4.419  -8.995   0.395  1.00 23.32           C 
ATOM   1119  OE1 GLU    70       3.749  -8.420   1.280  1.00 75.23           O 
ATOM   1120  OE2 GLU    70       4.032  -9.066  -0.790  1.00 11.32           O 
ATOM   1121  H   GLU    70       9.129  -8.550  -1.169  1.00 36.29           H 
ATOM   1122  HA  GLU    70       6.479  -7.388  -0.924  1.00 40.21           H 
ATOM   1123 3HB  GLU    70       7.760  -9.908   0.153  1.00 36.29           H 
ATOM   1124 2HB  GLU    70       6.597  -9.775  -1.156  1.00 36.29           H 
ATOM   1125 3HG  GLU    70       6.035  -9.264   1.760  1.00 36.29           H 
ATOM   1126 2HG  GLU    70       5.591 -10.705   0.853  1.00 36.29           H 
ATOM   1127  N   VAL    71       6.751  -6.087   1.181  1.00 21.13           N 
ATOM   1128  CA  VAL    71       6.847  -5.305   2.424  1.00  4.42           C 
ATOM   1129  C   VAL    71       5.549  -5.384   3.248  1.00 51.21           C 
ATOM   1130  O   VAL    71       4.533  -5.888   2.774  1.00 71.21           O 
ATOM   1131  CB  VAL    71       7.179  -3.817   2.132  1.00 72.43           C 
ATOM   1132  CG1 VAL    71       8.526  -3.696   1.429  1.00 43.24           C 
ATOM   1133  CG2 VAL    71       6.079  -3.153   1.303  1.00 63.42           C 
ATOM   1134  H   VAL    71       6.138  -5.787   0.480  1.00 36.29           H 
ATOM   1135  HA  VAL    71       7.655  -5.719   3.016  1.00 44.22           H 
ATOM   1136  HB  VAL    71       7.249  -3.296   3.078  1.00 15.34           H 
ATOM   1137 1HG1 VAL    71       8.475  -4.172   0.461  1.00 36.29           H 
ATOM   1138 2HG1 VAL    71       9.287  -4.178   2.027  1.00 36.29           H 
ATOM   1139 3HG1 VAL    71       8.776  -2.652   1.304  1.00 36.29           H 
ATOM   1140 1HG2 VAL    71       5.952  -3.688   0.372  1.00 36.29           H 
ATOM   1141 2HG2 VAL    71       6.351  -2.128   1.094  1.00 36.29           H 
ATOM   1142 3HG2 VAL    71       5.151  -3.169   1.855  1.00 36.29           H 
ATOM   1143  N   GLU    72       5.591  -4.909   4.494  1.00 13.21           N 
ATOM   1144  CA  GLU    72       4.400  -4.901   5.363  1.00 65.30           C 
ATOM   1145  C   GLU    72       4.184  -3.529   6.021  1.00 61.31           C 
ATOM   1146  O   GLU    72       5.122  -2.926   6.542  1.00 33.12           O 
ATOM   1147  CB  GLU    72       4.518  -5.986   6.443  1.00 42.04           C 
ATOM   1148  CG  GLU    72       5.703  -5.806   7.386  1.00 60.42           C 
ATOM   1149  CD  GLU    72       5.798  -6.915   8.420  1.00 64.32           C 
ATOM   1150  OE1 GLU    72       4.933  -6.973   9.319  1.00 14.44           O 
ATOM   1151  OE2 GLU    72       6.733  -7.738   8.334  1.00 13.42           O 
ATOM   1152  H   GLU    72       6.440  -4.563   4.844  1.00 36.29           H 
ATOM   1153  HA  GLU    72       3.541  -5.122   4.744  1.00 12.44           H 
ATOM   1154 3HB  GLU    72       4.616  -6.946   5.957  1.00 36.29           H 
ATOM   1155 2HB  GLU    72       3.613  -5.988   7.036  1.00 36.29           H 
ATOM   1156 3HG  GLU    72       5.599  -4.860   7.901  1.00 36.29           H 
ATOM   1157 2HG  GLU    72       6.613  -5.795   6.800  1.00 36.29           H 
ATOM   1158  N   VAL    73       2.943  -3.048   6.001  1.00 73.32           N 
ATOM   1159  CA  VAL    73       2.608  -1.733   6.556  1.00 54.30           C 
ATOM   1160  C   VAL    73       2.806  -1.678   8.083  1.00  2.11           C 
ATOM   1161  O   VAL    73       2.025  -2.247   8.849  1.00 23.41           O 
ATOM   1162  CB  VAL    73       1.148  -1.340   6.212  1.00 71.11           C 
ATOM   1163  CG1 VAL    73       0.792   0.029   6.795  1.00 61.40           C 
ATOM   1164  CG2 VAL    73       0.931  -1.360   4.699  1.00  2.40           C 
ATOM   1165  H   VAL    73       2.230  -3.593   5.602  1.00 36.29           H 
ATOM   1166  HA  VAL    73       3.266  -1.006   6.097  1.00 74.10           H 
ATOM   1167  HB  VAL    73       0.488  -2.074   6.654  1.00 30.21           H 
ATOM   1168 1HG1 VAL    73       1.472   0.775   6.409  1.00 36.29           H 
ATOM   1169 2HG1 VAL    73       0.870  -0.005   7.873  1.00 36.29           H 
ATOM   1170 3HG1 VAL    73      -0.221   0.288   6.517  1.00 36.29           H 
ATOM   1171 1HG2 VAL    73      -0.095  -1.102   4.478  1.00 36.29           H 
ATOM   1172 2HG2 VAL    73       1.143  -2.348   4.317  1.00 36.29           H 
ATOM   1173 3HG2 VAL    73       1.590  -0.644   4.228  1.00 36.29           H 
ATOM   1174  N   VAL    74       3.851  -0.968   8.515  1.00 21.41           N 
ATOM   1175  CA  VAL    74       4.168  -0.824   9.945  1.00 24.21           C 
ATOM   1176  C   VAL    74       3.105   0.028  10.673  1.00 65.34           C 
ATOM   1177  O   VAL    74       3.011   0.016  11.901  1.00 40.43           O 
ATOM   1178  CB  VAL    74       5.574  -0.184  10.142  1.00 31.32           C 
ATOM   1179  CG1 VAL    74       5.956  -0.116  11.621  1.00  5.25           C 
ATOM   1180  CG2 VAL    74       6.631  -0.953   9.348  1.00 53.13           C 
ATOM   1181  H   VAL    74       4.428  -0.528   7.853  1.00 36.29           H 
ATOM   1182  HA  VAL    74       4.180  -1.813  10.383  1.00 43.12           H 
ATOM   1183  HB  VAL    74       5.538   0.828   9.759  1.00 60.52           H 
ATOM   1184 1HG1 VAL    74       6.930   0.343  11.724  1.00 36.29           H 
ATOM   1185 2HG1 VAL    74       5.985  -1.114  12.034  1.00 36.29           H 
ATOM   1186 3HG1 VAL    74       5.225   0.471  12.157  1.00 36.29           H 
ATOM   1187 1HG2 VAL    74       6.384  -0.926   8.296  1.00 36.29           H 
ATOM   1188 2HG2 VAL    74       6.661  -1.979   9.684  1.00 36.29           H 
ATOM   1189 3HG2 VAL    74       7.601  -0.498   9.500  1.00 36.29           H 
END
