
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  114 ( 1769),  selected  114 , name 2da0_A
# Molecule2: number of CA atoms   69 ( 1087),  selected   69 , name T0464.pdb
# PARAMETERS: 2da0_A.T0464.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L      18           -
LGA    -       -      S      19           -
LGA    -       -      L      20           -
LGA    -       -      L      21           -
LGA    G     1_A      E      22          4.978
LGA    S     2_A      S      23           #
LGA    S     3_A      K      24           #
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      G      25           #
LGA    -       -      L      26           -
LGA    -       -      E      27           -
LGA    Y     8_A      A      28           #
LGA    G     9_A      L      29           -
LGA    S    10_A      N      30          5.202
LGA    E    11_A      K      31          3.789
LGA    K    12_A      A      32          3.234
LGA    -       -      I      33           -
LGA    -       -      V      34           -
LGA    -       -      S      35           -
LGA    K    13_A      G      36          1.307
LGA    G    14_A      T      37          1.821
LGA    Y    15_A      V      38          3.488
LGA    L    16_A      Q      39          1.350
LGA    L    17_A      R      40          1.897
LGA    K    18_A      A      41          3.388
LGA    K    19_A      -       -           -
LGA    S    20_A      -       -           -
LGA    D    21_A      -       -           -
LGA    G    22_A      -       -           -
LGA    I    23_A      -       -           -
LGA    R    24_A      -       -           -
LGA    K    25_A      -       -           -
LGA    V    26_A      -       -           -
LGA    W    27_A      -       -           -
LGA    Q    28_A      D      42          1.956
LGA    R    29_A      G      43          0.773
LGA    R    30_A      S      44          0.742
LGA    K    31_A      I      45          1.458
LGA    C    32_A      Q      46          1.510
LGA    S    33_A      N      47          2.020
LGA    V    34_A      -       -           -
LGA    K    35_A      -       -           -
LGA    N    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    I    38_A      Q      48          4.218
LGA    L    39_A      S      49          2.794
LGA    T    40_A      -       -           -
LGA    I    41_A      -       -           -
LGA    S    42_A      -       -           -
LGA    H    43_A      -       -           -
LGA    A    44_A      -       -           -
LGA    T    45_A      -       -           -
LGA    S    46_A      -       -           -
LGA    N    47_A      -       -           -
LGA    R    48_A      -       -           -
LGA    Q    49_A      -       -           -
LGA    P    50_A      -       -           -
LGA    A    51_A      -       -           -
LGA    K    52_A      -       -           -
LGA    L    53_A      -       -           -
LGA    N    54_A      -       -           -
LGA    L    55_A      L      50          2.851
LGA    L    56_A      H      51          3.552
LGA    T    57_A      -       -           -
LGA    C    58_A      -       -           -
LGA    Q    59_A      E      52          2.241
LGA    V    60_A      A      53          1.290
LGA    K    61_A      L      54          1.403
LGA    P    62_A      I      55          1.548
LGA    N    63_A      T      56          1.322
LGA    A    64_A      R      57          0.766
LGA    E    65_A      D      58          0.873
LGA    D    66_A      R      59          4.617
LGA    K    67_A      K      60          1.799
LGA    K    68_A      -       -           -
LGA    S    69_A      Q      61          0.737
LGA    F    70_A      V      62          0.626
LGA    D    71_A      F      63          1.262
LGA    L    72_A      R      64          1.402
LGA    I    73_A      I      65          1.701
LGA    S    74_A      E      66          1.267
LGA    H    75_A      D      67          1.482
LGA    N    76_A      S      68           #
LGA    R    77_A      I      69          4.020
LGA    T    78_A      P      70          3.725
LGA    Y    79_A      V      71          2.992
LGA    -       -      L      72           -
LGA    -       -      L      73           -
LGA    -       -      P      74           -
LGA    -       -      E      75           -
LGA    H    80_A      E      76          3.307
LGA    F    81_A      A      77          1.227
LGA    Q    82_A      I      78          2.018
LGA    A    83_A      A      79          1.829
LGA    E    84_A      T      80           #
LGA    D    85_A      I      81          2.048
LGA    E    86_A      Q      82           #
LGA    Q    87_A      I      83          5.121
LGA    D    88_A      A      84          3.524
LGA    Y    89_A      N      85           #
LGA    V    90_A      F      86          3.437
LGA    A    91_A      -       -           -
LGA    W    92_A      -       -           -
LGA    I    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    V    95_A      -       -           -
LGA    L    96_A      -       -           -
LGA    T    97_A      -       -           -
LGA    N    98_A      -       -           -
LGA    S    99_A      -       -           -
LGA    K   100_A      -       -           -
LGA    E   101_A      -       -           -
LGA    E   102_A      -       -           -
LGA    A   103_A      -       -           -
LGA    L   104_A      -       -           -
LGA    T   105_A      -       -           -
LGA    M   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    F   108_A      -       -           -
LGA    S   109_A      -       -           -
LGA    G   110_A      -       -           -
LGA    P   111_A      -       -           -
LGA    S   112_A      -       -           -
LGA    S   113_A      -       -           -
LGA    G   114_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  114   69    5.0     47    2.67     8.51     45.061     1.700

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.783288 * X  +   0.470363 * Y  +   0.406471 * Z  +   4.165712
  Y_new =   0.404990 * X  +  -0.109965 * Y  +   0.907684 * Z  +   1.374259
  Z_new =   0.471639 * X  +   0.875595 * Y  +  -0.104359 * Z  +   8.706134 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.689423   -1.452170  [ DEG:    96.7968    -83.2032 ]
  Theta =  -0.491148   -2.650444  [ DEG:   -28.1407   -151.8593 ]
  Phi   =   2.664407   -0.477186  [ DEG:   152.6593    -27.3407 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2da0_A                                        
REMARK     2: T0464.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2da0_A.T0464.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  114   69   5.0   47   2.67    8.51  45.061
REMARK  ---------------------------------------------------------- 
MOLECULE 2da0_A
HEADER    SIGNALING PROTEIN                       13-DEC-05   2DA0              
TITLE     SOLUTION STRUCTURE OF THE PH DOMAIN OF PIP2-DEPENDENT ARF1            
TITLE    2 GTPASE-ACTIVATING PROTEIN FROM HUMAN                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 130-KDA PHOSPHATIDYLINOSITOL 4,5-BIPHOSPHATE-              
COMPND   3 DEPENDENT ARF1 GTPASE-ACTIVATING PROTEIN;                            
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: PH DOMAIN;                                                 
COMPND   6 SYNONYM: PIP2-DEPENDENT ARF1 GAP, ADP-RIBOSYLATION FACTOR-           
COMPND   7 DIRECTED GTPASE-ACTIVATING PROTEIN 1, ARF GTPASE-                    
COMPND   8 ACTIVATING PROTEIN 1, DEVELOPMENT AND DIFFERENTIATION-               
COMPND   9 ENHANCING FACTOR 1;                                                  
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: ASAP1;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050801-06;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PH DOMAIN, ARF GTPASE-ACTIVATING PROTEIN 1, STRUCTURAL                
KEYWDS   2 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   3 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN           
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   13-JUN-06 2DA0    0                                                
JRNL        AUTH   H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,                  
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE PH DOMAIN OF                       
JRNL        TITL 2 PIP2-DEPENDENT ARF1 GTPASE-ACTIVATING PROTEIN FROM           
JRNL        TITL 3 HUMAN                                                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DA0 A    8   108  UNP    Q9ULH1   DDEF1_HUMAN    150    250             
SEQRES   1 A  114  GLY SER SER GLY SER SER GLY TYR GLY SER GLU LYS LYS          
SEQRES   2 A  114  GLY TYR LEU LEU LYS LYS SER ASP GLY ILE ARG LYS VAL          
SEQRES   3 A  114  TRP GLN ARG ARG LYS CYS SER VAL LYS ASN GLY ILE LEU          
SEQRES   4 A  114  THR ILE SER HIS ALA THR SER ASN ARG GLN PRO ALA LYS          
SEQRES   5 A  114  LEU ASN LEU LEU THR CYS GLN VAL LYS PRO ASN ALA GLU          
SEQRES   6 A  114  ASP LYS LYS SER PHE ASP LEU ILE SER HIS ASN ARG THR          
SEQRES   7 A  114  TYR HIS PHE GLN ALA GLU ASP GLU GLN ASP TYR VAL ALA          
SEQRES   8 A  114  TRP ILE SER VAL LEU THR ASN SER LYS GLU GLU ALA LEU          
SEQRES   9 A  114  THR MET ALA PHE SER GLY PRO SER SER GLY                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       7.309 -13.152   0.747  1.00  0.00           N  
ATOM      2  CA  GLY A   1       7.631 -11.745   0.595  1.00  0.00           C  
ATOM      3  C   GLY A   1       8.609 -11.493  -0.535  1.00  0.00           C  
ATOM      4  O   GLY A   1       8.665 -12.258  -1.499  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       6.722 -11.197   0.400  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       8.066 -11.385   1.517  1.00  0.00           H  
ATOM      7  H1  GLY A   1       7.764 -13.820   0.194  1.00  0.00           H  
ATOM      8  N   SER A   2       9.380 -10.417  -0.420  1.00  0.00           N  
ATOM      9  CA  SER A   2      10.356 -10.063  -1.444  1.00  0.00           C  
ATOM     10  C   SER A   2      11.697 -10.739  -1.174  1.00  0.00           C  
ATOM     11  O   SER A   2      12.417 -10.366  -0.248  1.00  0.00           O  
ATOM     12  CB  SER A   2      10.540  -8.546  -1.500  1.00  0.00           C  
ATOM     13  OG  SER A   2       9.494  -7.932  -2.232  1.00  0.00           O  
ATOM     14  H   SER A   2       9.289  -9.846   0.372  1.00  0.00           H  
ATOM     15  HA  SER A   2       9.978 -10.407  -2.395  1.00  0.00           H  
ATOM     16  HB2 SER A   2      10.542  -8.148  -0.497  1.00  0.00           H  
ATOM     17  HB3 SER A   2      11.481  -8.317  -1.980  1.00  0.00           H  
ATOM     18  HG  SER A   2       9.148  -8.552  -2.878  1.00  0.00           H  
ATOM     19  N   SER A   3      12.025 -11.737  -1.989  1.00  0.00           N  
ATOM     20  CA  SER A   3      13.277 -12.469  -1.836  1.00  0.00           C  
ATOM     21  C   SER A   3      14.457 -11.635  -2.325  1.00  0.00           C  
ATOM     22  O   SER A   3      14.281 -10.531  -2.838  1.00  0.00           O  
ATOM     23  CB  SER A   3      13.217 -13.790  -2.606  1.00  0.00           C  
ATOM     24  OG  SER A   3      14.144 -14.726  -2.085  1.00  0.00           O  
ATOM     25  H   SER A   3      11.408 -11.988  -2.708  1.00  0.00           H  
ATOM     26  HA  SER A   3      13.411 -12.680  -0.786  1.00  0.00           H  
ATOM     27  HB2 SER A   3      12.223 -14.204  -2.527  1.00  0.00           H  
ATOM     28  HB3 SER A   3      13.450 -13.608  -3.645  1.00  0.00           H  
ATOM     29  HG  SER A   3      14.183 -15.493  -2.662  1.00  0.00           H  
ATOM     30  N   GLY A   4      15.662 -12.174  -2.163  1.00  0.00           N  
ATOM     31  CA  GLY A   4      16.854 -11.467  -2.594  1.00  0.00           C  
ATOM     32  C   GLY A   4      17.105 -10.209  -1.786  1.00  0.00           C  
ATOM     33  O   GLY A   4      16.523 -10.022  -0.718  1.00  0.00           O  
ATOM     34  H   GLY A   4      15.742 -13.058  -1.748  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      17.705 -12.124  -2.492  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      16.743 -11.197  -3.633  1.00  0.00           H  
ATOM     37  N   SER A   5      17.974  -9.343  -2.297  1.00  0.00           N  
ATOM     38  CA  SER A   5      18.306  -8.099  -1.613  1.00  0.00           C  
ATOM     39  C   SER A   5      17.214  -7.054  -1.829  1.00  0.00           C  
ATOM     40  O   SER A   5      16.965  -6.624  -2.954  1.00  0.00           O  
ATOM     41  CB  SER A   5      19.649  -7.560  -2.112  1.00  0.00           C  
ATOM     42  OG  SER A   5      19.585  -7.228  -3.488  1.00  0.00           O  
ATOM     43  H   SER A   5      18.406  -9.549  -3.153  1.00  0.00           H  
ATOM     44  HA  SER A   5      18.381  -8.311  -0.557  1.00  0.00           H  
ATOM     45  HB2 SER A   5      19.909  -6.675  -1.551  1.00  0.00           H  
ATOM     46  HB3 SER A   5      20.410  -8.313  -1.969  1.00  0.00           H  
ATOM     47  HG  SER A   5      19.130  -7.925  -3.966  1.00  0.00           H  
ATOM     48  N   SER A   6      16.567  -6.650  -0.740  1.00  0.00           N  
ATOM     49  CA  SER A   6      15.500  -5.659  -0.808  1.00  0.00           C  
ATOM     50  C   SER A   6      15.866  -4.412  -0.009  1.00  0.00           C  
ATOM     51  O   SER A   6      15.505  -4.283   1.160  1.00  0.00           O  
ATOM     52  CB  SER A   6      14.191  -6.251  -0.282  1.00  0.00           C  
ATOM     53  OG  SER A   6      13.070  -5.597  -0.853  1.00  0.00           O  
ATOM     54  H   SER A   6      16.813  -7.030   0.130  1.00  0.00           H  
ATOM     55  HA  SER A   6      15.371  -5.383  -1.844  1.00  0.00           H  
ATOM     56  HB2 SER A   6      14.147  -7.300  -0.533  1.00  0.00           H  
ATOM     57  HB3 SER A   6      14.153  -6.134   0.791  1.00  0.00           H  
ATOM     58  HG  SER A   6      12.469  -5.326  -0.156  1.00  0.00           H  
ATOM     59  N   GLY A   7      16.585  -3.495  -0.650  1.00  0.00           N  
ATOM     60  CA  GLY A   7      16.988  -2.270   0.016  1.00  0.00           C  
ATOM     61  C   GLY A   7      16.363  -1.038  -0.609  1.00  0.00           C  
ATOM     62  O   GLY A   7      17.063  -0.195  -1.171  1.00  0.00           O  
ATOM     63  H   GLY A   7      16.844  -3.652  -1.582  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      16.694  -2.323   1.054  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      18.063  -2.180  -0.040  1.00  0.00           H  
ATOM     66  N   TYR A   8      15.042  -0.934  -0.513  1.00  0.00           N  
ATOM     67  CA  TYR A   8      14.322   0.202  -1.078  1.00  0.00           C  
ATOM     68  C   TYR A   8      14.469   1.435  -0.191  1.00  0.00           C  
ATOM     69  O   TYR A   8      14.938   2.481  -0.636  1.00  0.00           O  
ATOM     70  CB  TYR A   8      12.841  -0.142  -1.252  1.00  0.00           C  
ATOM     71  CG  TYR A   8      12.574  -1.113  -2.380  1.00  0.00           C  
ATOM     72  CD1 TYR A   8      13.160  -2.373  -2.392  1.00  0.00           C  
ATOM     73  CD2 TYR A   8      11.734  -0.771  -3.433  1.00  0.00           C  
ATOM     74  CE1 TYR A   8      12.919  -3.262  -3.420  1.00  0.00           C  
ATOM     75  CE2 TYR A   8      11.485  -1.655  -4.464  1.00  0.00           C  
ATOM     76  CZ  TYR A   8      12.081  -2.899  -4.455  1.00  0.00           C  
ATOM     77  OH  TYR A   8      11.837  -3.783  -5.480  1.00  0.00           O  
ATOM     78  H   TYR A   8      14.538  -1.638  -0.055  1.00  0.00           H  
ATOM     79  HA  TYR A   8      14.749   0.416  -2.047  1.00  0.00           H  
ATOM     80  HB2 TYR A   8      12.472  -0.584  -0.340  1.00  0.00           H  
ATOM     81  HB3 TYR A   8      12.290   0.764  -1.457  1.00  0.00           H  
ATOM     82  HD1 TYR A   8      13.816  -2.655  -1.581  1.00  0.00           H  
ATOM     83  HD2 TYR A   8      11.269   0.205  -3.437  1.00  0.00           H  
ATOM     84  HE1 TYR A   8      13.384  -4.237  -3.413  1.00  0.00           H  
ATOM     85  HE2 TYR A   8      10.829  -1.371  -5.274  1.00  0.00           H  
ATOM     86  HH  TYR A   8      12.192  -3.429  -6.299  1.00  0.00           H  
ATOM     87  N   GLY A   9      14.064   1.301   1.068  1.00  0.00           N  
ATOM     88  CA  GLY A   9      14.157   2.411   1.999  1.00  0.00           C  
ATOM     89  C   GLY A   9      12.862   2.652   2.747  1.00  0.00           C  
ATOM     90  O   GLY A   9      11.782   2.327   2.252  1.00  0.00           O  
ATOM     91  H   GLY A   9      13.698   0.443   1.368  1.00  0.00           H  
ATOM     92  HA2 GLY A   9      14.940   2.202   2.714  1.00  0.00           H  
ATOM     93  HA3 GLY A   9      14.415   3.305   1.450  1.00  0.00           H  
ATOM     94  N   SER A  10      12.968   3.223   3.942  1.00  0.00           N  
ATOM     95  CA  SER A  10      11.795   3.502   4.763  1.00  0.00           C  
ATOM     96  C   SER A  10      11.274   4.913   4.504  1.00  0.00           C  
ATOM     97  O   SER A  10      10.820   5.595   5.421  1.00  0.00           O  
ATOM     98  CB  SER A  10      12.132   3.336   6.246  1.00  0.00           C  
ATOM     99  OG  SER A  10      13.374   3.941   6.558  1.00  0.00           O  
ATOM    100  H   SER A  10      13.856   3.459   4.282  1.00  0.00           H  
ATOM    101  HA  SER A  10      11.027   2.793   4.495  1.00  0.00           H  
ATOM    102  HB2 SER A  10      11.360   3.798   6.842  1.00  0.00           H  
ATOM    103  HB3 SER A  10      12.188   2.282   6.483  1.00  0.00           H  
ATOM    104  HG  SER A  10      13.244   4.879   6.710  1.00  0.00           H  
ATOM    105  N   GLU A  11      11.345   5.341   3.246  1.00  0.00           N  
ATOM    106  CA  GLU A  11      10.881   6.670   2.866  1.00  0.00           C  
ATOM    107  C   GLU A  11      10.438   6.695   1.407  1.00  0.00           C  
ATOM    108  O   GLU A  11      11.152   6.224   0.520  1.00  0.00           O  
ATOM    109  CB  GLU A  11      11.986   7.704   3.092  1.00  0.00           C  
ATOM    110  CG  GLU A  11      12.288   7.962   4.559  1.00  0.00           C  
ATOM    111  CD  GLU A  11      13.278   6.967   5.135  1.00  0.00           C  
ATOM    112  OE1 GLU A  11      14.046   6.373   4.350  1.00  0.00           O  
ATOM    113  OE2 GLU A  11      13.284   6.782   6.370  1.00  0.00           O  
ATOM    114  H   GLU A  11      11.717   4.750   2.560  1.00  0.00           H  
ATOM    115  HA  GLU A  11      10.036   6.918   3.491  1.00  0.00           H  
ATOM    116  HB2 GLU A  11      12.892   7.356   2.616  1.00  0.00           H  
ATOM    117  HB3 GLU A  11      11.688   8.637   2.639  1.00  0.00           H  
ATOM    118  HG2 GLU A  11      12.700   8.955   4.660  1.00  0.00           H  
ATOM    119  HG3 GLU A  11      11.368   7.897   5.120  1.00  0.00           H  
ATOM    120  N   LYS A  12       9.254   7.247   1.163  1.00  0.00           N  
ATOM    121  CA  LYS A  12       8.713   7.335  -0.188  1.00  0.00           C  
ATOM    122  C   LYS A  12       7.590   8.364  -0.259  1.00  0.00           C  
ATOM    123  O   LYS A  12       6.718   8.408   0.609  1.00  0.00           O  
ATOM    124  CB  LYS A  12       8.196   5.967  -0.643  1.00  0.00           C  
ATOM    125  CG  LYS A  12       7.540   5.991  -2.012  1.00  0.00           C  
ATOM    126  CD  LYS A  12       7.147   4.594  -2.465  1.00  0.00           C  
ATOM    127  CE  LYS A  12       6.359   4.631  -3.766  1.00  0.00           C  
ATOM    128  NZ  LYS A  12       7.242   4.863  -4.942  1.00  0.00           N  
ATOM    129  H   LYS A  12       8.731   7.605   1.912  1.00  0.00           H  
ATOM    130  HA  LYS A  12       9.512   7.644  -0.845  1.00  0.00           H  
ATOM    131  HB2 LYS A  12       9.025   5.275  -0.675  1.00  0.00           H  
ATOM    132  HB3 LYS A  12       7.471   5.614   0.076  1.00  0.00           H  
ATOM    133  HG2 LYS A  12       6.652   6.605  -1.966  1.00  0.00           H  
ATOM    134  HG3 LYS A  12       8.234   6.409  -2.727  1.00  0.00           H  
ATOM    135  HD2 LYS A  12       8.042   4.008  -2.616  1.00  0.00           H  
ATOM    136  HD3 LYS A  12       6.539   4.135  -1.699  1.00  0.00           H  
ATOM    137  HE2 LYS A  12       5.848   3.689  -3.889  1.00  0.00           H  
ATOM    138  HE3 LYS A  12       5.632   5.429  -3.708  1.00  0.00           H  
ATOM    139  HZ1 LYS A  12       6.790   5.529  -5.601  1.00  0.00           H  
ATOM    140  HZ2 LYS A  12       7.417   3.966  -5.439  1.00  0.00           H  
ATOM    141  HZ3 LYS A  12       8.152   5.259  -4.634  1.00  0.00           H  
ATOM    142  N   LYS A  13       7.616   9.190  -1.299  1.00  0.00           N  
ATOM    143  CA  LYS A  13       6.599  10.218  -1.486  1.00  0.00           C  
ATOM    144  C   LYS A  13       6.035  10.175  -2.903  1.00  0.00           C  
ATOM    145  O   LYS A  13       6.776  10.272  -3.879  1.00  0.00           O  
ATOM    146  CB  LYS A  13       7.185  11.603  -1.201  1.00  0.00           C  
ATOM    147  CG  LYS A  13       6.134  12.688  -1.043  1.00  0.00           C  
ATOM    148  CD  LYS A  13       6.715  13.939  -0.407  1.00  0.00           C  
ATOM    149  CE  LYS A  13       6.921  13.760   1.089  1.00  0.00           C  
ATOM    150  NZ  LYS A  13       5.693  14.091   1.863  1.00  0.00           N  
ATOM    151  H   LYS A  13       8.337   9.106  -1.959  1.00  0.00           H  
ATOM    152  HA  LYS A  13       5.799  10.024  -0.787  1.00  0.00           H  
ATOM    153  HB2 LYS A  13       7.763  11.555  -0.289  1.00  0.00           H  
ATOM    154  HB3 LYS A  13       7.838  11.879  -2.016  1.00  0.00           H  
ATOM    155  HG2 LYS A  13       5.742  12.941  -2.017  1.00  0.00           H  
ATOM    156  HG3 LYS A  13       5.336  12.315  -0.418  1.00  0.00           H  
ATOM    157  HD2 LYS A  13       7.668  14.158  -0.866  1.00  0.00           H  
ATOM    158  HD3 LYS A  13       6.036  14.765  -0.572  1.00  0.00           H  
ATOM    159  HE2 LYS A  13       7.191  12.732   1.282  1.00  0.00           H  
ATOM    160  HE3 LYS A  13       7.724  14.408   1.409  1.00  0.00           H  
ATOM    161  HZ1 LYS A  13       5.715  15.088   2.157  1.00  0.00           H  
ATOM    162  HZ2 LYS A  13       5.631  13.493   2.710  1.00  0.00           H  
ATOM    163  HZ3 LYS A  13       4.847  13.932   1.277  1.00  0.00           H  
ATOM    164  N   GLY A  14       4.718  10.031  -3.007  1.00  0.00           N  
ATOM    165  CA  GLY A  14       4.078   9.978  -4.307  1.00  0.00           C  
ATOM    166  C   GLY A  14       2.568  10.089  -4.216  1.00  0.00           C  
ATOM    167  O   GLY A  14       2.043  10.892  -3.443  1.00  0.00           O  
ATOM    168  H   GLY A  14       4.176   9.958  -2.193  1.00  0.00           H  
ATOM    169  HA2 GLY A  14       4.452  10.790  -4.913  1.00  0.00           H  
ATOM    170  HA3 GLY A  14       4.330   9.042  -4.783  1.00  0.00           H  
ATOM    171  N   TYR A  15       1.868   9.283  -5.007  1.00  0.00           N  
ATOM    172  CA  TYR A  15       0.411   9.296  -5.015  1.00  0.00           C  
ATOM    173  C   TYR A  15      -0.147   7.877  -5.056  1.00  0.00           C  
ATOM    174  O   TYR A  15       0.439   6.985  -5.672  1.00  0.00           O  
ATOM    175  CB  TYR A  15      -0.106  10.095  -6.212  1.00  0.00           C  
ATOM    176  CG  TYR A  15      -0.088  11.591  -5.995  1.00  0.00           C  
ATOM    177  CD1 TYR A  15       1.099  12.308  -6.066  1.00  0.00           C  
ATOM    178  CD2 TYR A  15      -1.259  12.287  -5.720  1.00  0.00           C  
ATOM    179  CE1 TYR A  15       1.120  13.676  -5.868  1.00  0.00           C  
ATOM    180  CE2 TYR A  15      -1.248  13.654  -5.522  1.00  0.00           C  
ATOM    181  CZ  TYR A  15      -0.055  14.344  -5.597  1.00  0.00           C  
ATOM    182  OH  TYR A  15      -0.039  15.705  -5.399  1.00  0.00           O  
ATOM    183  H   TYR A  15       2.344   8.665  -5.601  1.00  0.00           H  
ATOM    184  HA  TYR A  15       0.079   9.775  -4.106  1.00  0.00           H  
ATOM    185  HB2 TYR A  15       0.508   9.877  -7.073  1.00  0.00           H  
ATOM    186  HB3 TYR A  15      -1.125   9.801  -6.419  1.00  0.00           H  
ATOM    187  HD1 TYR A  15       2.019  11.783  -6.278  1.00  0.00           H  
ATOM    188  HD2 TYR A  15      -2.191  11.744  -5.662  1.00  0.00           H  
ATOM    189  HE1 TYR A  15       2.054  14.217  -5.927  1.00  0.00           H  
ATOM    190  HE2 TYR A  15      -2.168  14.178  -5.309  1.00  0.00           H  
ATOM    191  HH  TYR A  15       0.199  16.146  -6.219  1.00  0.00           H  
ATOM    192  N   LEU A  16      -1.283   7.675  -4.399  1.00  0.00           N  
ATOM    193  CA  LEU A  16      -1.923   6.365  -4.361  1.00  0.00           C  
ATOM    194  C   LEU A  16      -3.441   6.497  -4.443  1.00  0.00           C  
ATOM    195  O   LEU A  16      -3.981   7.603  -4.407  1.00  0.00           O  
ATOM    196  CB  LEU A  16      -1.533   5.623  -3.082  1.00  0.00           C  
ATOM    197  CG  LEU A  16      -0.273   4.759  -3.163  1.00  0.00           C  
ATOM    198  CD1 LEU A  16       0.061   4.173  -1.801  1.00  0.00           C  
ATOM    199  CD2 LEU A  16      -0.452   3.653  -4.193  1.00  0.00           C  
ATOM    200  H   LEU A  16      -1.703   8.425  -3.928  1.00  0.00           H  
ATOM    201  HA  LEU A  16      -1.576   5.802  -5.214  1.00  0.00           H  
ATOM    202  HB2 LEU A  16      -1.380   6.358  -2.307  1.00  0.00           H  
ATOM    203  HB3 LEU A  16      -2.358   4.980  -2.808  1.00  0.00           H  
ATOM    204  HG  LEU A  16       0.558   5.377  -3.474  1.00  0.00           H  
ATOM    205 HD11 LEU A  16       0.100   4.964  -1.068  1.00  0.00           H  
ATOM    206 HD12 LEU A  16       1.021   3.679  -1.848  1.00  0.00           H  
ATOM    207 HD13 LEU A  16      -0.698   3.457  -1.520  1.00  0.00           H  
ATOM    208 HD21 LEU A  16      -1.367   3.817  -4.742  1.00  0.00           H  
ATOM    209 HD22 LEU A  16      -0.500   2.698  -3.690  1.00  0.00           H  
ATOM    210 HD23 LEU A  16       0.385   3.660  -4.876  1.00  0.00           H  
ATOM    211  N   LEU A  17      -4.123   5.362  -4.551  1.00  0.00           N  
ATOM    212  CA  LEU A  17      -5.579   5.350  -4.636  1.00  0.00           C  
ATOM    213  C   LEU A  17      -6.194   4.764  -3.370  1.00  0.00           C  
ATOM    214  O   LEU A  17      -5.641   3.843  -2.767  1.00  0.00           O  
ATOM    215  CB  LEU A  17      -6.032   4.546  -5.856  1.00  0.00           C  
ATOM    216  CG  LEU A  17      -5.375   4.917  -7.186  1.00  0.00           C  
ATOM    217  CD1 LEU A  17      -5.317   3.709  -8.108  1.00  0.00           C  
ATOM    218  CD2 LEU A  17      -6.125   6.062  -7.851  1.00  0.00           C  
ATOM    219  H   LEU A  17      -3.637   4.513  -4.575  1.00  0.00           H  
ATOM    220  HA  LEU A  17      -5.913   6.372  -4.744  1.00  0.00           H  
ATOM    221  HB2 LEU A  17      -5.822   3.505  -5.662  1.00  0.00           H  
ATOM    222  HB3 LEU A  17      -7.099   4.682  -5.964  1.00  0.00           H  
ATOM    223  HG  LEU A  17      -4.360   5.243  -7.001  1.00  0.00           H  
ATOM    224 HD11 LEU A  17      -4.983   2.846  -7.551  1.00  0.00           H  
ATOM    225 HD12 LEU A  17      -4.627   3.905  -8.915  1.00  0.00           H  
ATOM    226 HD13 LEU A  17      -6.299   3.519  -8.514  1.00  0.00           H  
ATOM    227 HD21 LEU A  17      -6.180   5.886  -8.915  1.00  0.00           H  
ATOM    228 HD22 LEU A  17      -5.602   6.989  -7.666  1.00  0.00           H  
ATOM    229 HD23 LEU A  17      -7.123   6.124  -7.443  1.00  0.00           H  
ATOM    230  N   LYS A  18      -7.341   5.301  -2.971  1.00  0.00           N  
ATOM    231  CA  LYS A  18      -8.035   4.829  -1.778  1.00  0.00           C  
ATOM    232  C   LYS A  18      -9.542   4.783  -2.007  1.00  0.00           C  
ATOM    233  O   LYS A  18     -10.132   5.731  -2.527  1.00  0.00           O  
ATOM    234  CB  LYS A  18      -7.717   5.736  -0.587  1.00  0.00           C  
ATOM    235  CG  LYS A  18      -7.766   5.021   0.752  1.00  0.00           C  
ATOM    236  CD  LYS A  18      -7.458   5.966   1.901  1.00  0.00           C  
ATOM    237  CE  LYS A  18      -8.720   6.629   2.430  1.00  0.00           C  
ATOM    238  NZ  LYS A  18      -9.674   5.635   2.995  1.00  0.00           N  
ATOM    239  H   LYS A  18      -7.733   6.033  -3.494  1.00  0.00           H  
ATOM    240  HA  LYS A  18      -7.684   3.831  -1.564  1.00  0.00           H  
ATOM    241  HB2 LYS A  18      -6.727   6.147  -0.717  1.00  0.00           H  
ATOM    242  HB3 LYS A  18      -8.433   6.545  -0.565  1.00  0.00           H  
ATOM    243  HG2 LYS A  18      -8.753   4.608   0.894  1.00  0.00           H  
ATOM    244  HG3 LYS A  18      -7.036   4.222   0.749  1.00  0.00           H  
ATOM    245  HD2 LYS A  18      -6.996   5.408   2.702  1.00  0.00           H  
ATOM    246  HD3 LYS A  18      -6.778   6.732   1.554  1.00  0.00           H  
ATOM    247  HE2 LYS A  18      -8.446   7.331   3.202  1.00  0.00           H  
ATOM    248  HE3 LYS A  18      -9.201   7.156   1.619  1.00  0.00           H  
ATOM    249  HZ1 LYS A  18     -10.524   5.575   2.398  1.00  0.00           H  
ATOM    250  HZ2 LYS A  18      -9.958   5.918   3.955  1.00  0.00           H  
ATOM    251  HZ3 LYS A  18      -9.228   4.697   3.039  1.00  0.00           H  
ATOM    252  N   LYS A  19     -10.161   3.675  -1.615  1.00  0.00           N  
ATOM    253  CA  LYS A  19     -11.600   3.505  -1.775  1.00  0.00           C  
ATOM    254  C   LYS A  19     -12.362   4.630  -1.079  1.00  0.00           C  
ATOM    255  O   LYS A  19     -12.036   5.010   0.045  1.00  0.00           O  
ATOM    256  CB  LYS A  19     -12.041   2.152  -1.211  1.00  0.00           C  
ATOM    257  CG  LYS A  19     -13.340   1.638  -1.809  1.00  0.00           C  
ATOM    258  CD  LYS A  19     -13.087   0.789  -3.044  1.00  0.00           C  
ATOM    259  CE  LYS A  19     -12.732  -0.643  -2.673  1.00  0.00           C  
ATOM    260  NZ  LYS A  19     -13.757  -1.256  -1.784  1.00  0.00           N  
ATOM    261  H   LYS A  19      -9.638   2.953  -1.207  1.00  0.00           H  
ATOM    262  HA  LYS A  19     -11.823   3.536  -2.831  1.00  0.00           H  
ATOM    263  HB2 LYS A  19     -11.266   1.425  -1.407  1.00  0.00           H  
ATOM    264  HB3 LYS A  19     -12.174   2.247  -0.143  1.00  0.00           H  
ATOM    265  HG2 LYS A  19     -13.852   1.037  -1.071  1.00  0.00           H  
ATOM    266  HG3 LYS A  19     -13.957   2.481  -2.083  1.00  0.00           H  
ATOM    267  HD2 LYS A  19     -13.979   0.780  -3.652  1.00  0.00           H  
ATOM    268  HD3 LYS A  19     -12.270   1.220  -3.606  1.00  0.00           H  
ATOM    269  HE2 LYS A  19     -12.656  -1.227  -3.576  1.00  0.00           H  
ATOM    270  HE3 LYS A  19     -11.780  -0.643  -2.164  1.00  0.00           H  
ATOM    271  HZ1 LYS A  19     -14.691  -0.841  -1.978  1.00  0.00           H  
ATOM    272  HZ2 LYS A  19     -13.514  -1.085  -0.787  1.00  0.00           H  
ATOM    273  HZ3 LYS A  19     -13.804  -2.282  -1.947  1.00  0.00           H  
ATOM    274  N   SER A  20     -13.378   5.156  -1.754  1.00  0.00           N  
ATOM    275  CA  SER A  20     -14.184   6.238  -1.202  1.00  0.00           C  
ATOM    276  C   SER A  20     -14.556   5.952   0.250  1.00  0.00           C  
ATOM    277  O   SER A  20     -14.363   4.841   0.744  1.00  0.00           O  
ATOM    278  CB  SER A  20     -15.452   6.435  -2.035  1.00  0.00           C  
ATOM    279  OG  SER A  20     -16.163   7.587  -1.618  1.00  0.00           O  
ATOM    280  H   SER A  20     -13.589   4.810  -2.647  1.00  0.00           H  
ATOM    281  HA  SER A  20     -13.595   7.142  -1.240  1.00  0.00           H  
ATOM    282  HB2 SER A  20     -15.184   6.550  -3.074  1.00  0.00           H  
ATOM    283  HB3 SER A  20     -16.092   5.572  -1.921  1.00  0.00           H  
ATOM    284  HG  SER A  20     -16.618   7.973  -2.370  1.00  0.00           H  
ATOM    285  N   ASP A  21     -15.088   6.963   0.927  1.00  0.00           N  
ATOM    286  CA  ASP A  21     -15.488   6.822   2.323  1.00  0.00           C  
ATOM    287  C   ASP A  21     -16.071   5.436   2.583  1.00  0.00           C  
ATOM    288  O   ASP A  21     -15.586   4.699   3.442  1.00  0.00           O  
ATOM    289  CB  ASP A  21     -16.511   7.897   2.694  1.00  0.00           C  
ATOM    290  CG  ASP A  21     -17.733   7.866   1.798  1.00  0.00           C  
ATOM    291  OD1 ASP A  21     -17.589   8.138   0.588  1.00  0.00           O  
ATOM    292  OD2 ASP A  21     -18.834   7.569   2.306  1.00  0.00           O  
ATOM    293  H   ASP A  21     -15.217   7.825   0.479  1.00  0.00           H  
ATOM    294  HA  ASP A  21     -14.608   6.950   2.935  1.00  0.00           H  
ATOM    295  HB2 ASP A  21     -16.831   7.742   3.714  1.00  0.00           H  
ATOM    296  HB3 ASP A  21     -16.048   8.868   2.610  1.00  0.00           H  
ATOM    297  N   GLY A  22     -17.114   5.088   1.837  1.00  0.00           N  
ATOM    298  CA  GLY A  22     -17.746   3.793   2.004  1.00  0.00           C  
ATOM    299  C   GLY A  22     -18.932   3.602   1.079  1.00  0.00           C  
ATOM    300  O   GLY A  22     -19.017   2.601   0.366  1.00  0.00           O  
ATOM    301  H   GLY A  22     -17.458   5.717   1.169  1.00  0.00           H  
ATOM    302  HA2 GLY A  22     -17.018   3.020   1.803  1.00  0.00           H  
ATOM    303  HA3 GLY A  22     -18.084   3.698   3.026  1.00  0.00           H  
ATOM    304  N   ILE A  23     -19.849   4.563   1.090  1.00  0.00           N  
ATOM    305  CA  ILE A  23     -21.035   4.496   0.245  1.00  0.00           C  
ATOM    306  C   ILE A  23     -20.698   3.937  -1.133  1.00  0.00           C  
ATOM    307  O   ILE A  23     -21.420   3.093  -1.666  1.00  0.00           O  
ATOM    308  CB  ILE A  23     -21.687   5.882   0.079  1.00  0.00           C  
ATOM    309  CG1 ILE A  23     -22.889   5.794  -0.864  1.00  0.00           C  
ATOM    310  CG2 ILE A  23     -20.671   6.887  -0.442  1.00  0.00           C  
ATOM    311  CD1 ILE A  23     -23.851   6.952  -0.726  1.00  0.00           C  
ATOM    312  H   ILE A  23     -19.725   5.335   1.679  1.00  0.00           H  
ATOM    313  HA  ILE A  23     -21.747   3.840   0.724  1.00  0.00           H  
ATOM    314  HB  ILE A  23     -22.023   6.215   1.049  1.00  0.00           H  
ATOM    315 HG12 ILE A  23     -22.539   5.775  -1.884  1.00  0.00           H  
ATOM    316 HG13 ILE A  23     -23.433   4.883  -0.658  1.00  0.00           H  
ATOM    317 HG21 ILE A  23     -21.134   7.859  -0.522  1.00  0.00           H  
ATOM    318 HG22 ILE A  23     -19.837   6.941   0.242  1.00  0.00           H  
ATOM    319 HG23 ILE A  23     -20.320   6.574  -1.414  1.00  0.00           H  
ATOM    320 HD11 ILE A  23     -24.051   7.374  -1.699  1.00  0.00           H  
ATOM    321 HD12 ILE A  23     -24.774   6.605  -0.286  1.00  0.00           H  
ATOM    322 HD13 ILE A  23     -23.414   7.710  -0.090  1.00  0.00           H  
ATOM    323  N   ARG A  24     -19.596   4.412  -1.705  1.00  0.00           N  
ATOM    324  CA  ARG A  24     -19.161   3.959  -3.020  1.00  0.00           C  
ATOM    325  C   ARG A  24     -17.826   3.228  -2.931  1.00  0.00           C  
ATOM    326  O   ARG A  24     -17.063   3.419  -1.983  1.00  0.00           O  
ATOM    327  CB  ARG A  24     -19.043   5.145  -3.978  1.00  0.00           C  
ATOM    328  CG  ARG A  24     -20.379   5.635  -4.510  1.00  0.00           C  
ATOM    329  CD  ARG A  24     -20.197   6.724  -5.557  1.00  0.00           C  
ATOM    330  NE  ARG A  24     -19.482   7.880  -5.023  1.00  0.00           N  
ATOM    331  CZ  ARG A  24     -18.858   8.774  -5.783  1.00  0.00           C  
ATOM    332  NH1 ARG A  24     -18.862   8.644  -7.103  1.00  0.00           N  
ATOM    333  NH2 ARG A  24     -18.231   9.800  -5.224  1.00  0.00           N  
ATOM    334  H   ARG A  24     -19.061   5.083  -1.230  1.00  0.00           H  
ATOM    335  HA  ARG A  24     -19.907   3.276  -3.399  1.00  0.00           H  
ATOM    336  HB2 ARG A  24     -18.564   5.964  -3.460  1.00  0.00           H  
ATOM    337  HB3 ARG A  24     -18.430   4.855  -4.817  1.00  0.00           H  
ATOM    338  HG2 ARG A  24     -20.903   4.805  -4.960  1.00  0.00           H  
ATOM    339  HG3 ARG A  24     -20.961   6.028  -3.691  1.00  0.00           H  
ATOM    340  HD2 ARG A  24     -19.637   6.318  -6.386  1.00  0.00           H  
ATOM    341  HD3 ARG A  24     -21.171   7.041  -5.899  1.00  0.00           H  
ATOM    342  HE  ARG A  24     -19.467   7.997  -4.050  1.00  0.00           H  
ATOM    343 HH11 ARG A  24     -19.335   7.871  -7.527  1.00  0.00           H  
ATOM    344 HH12 ARG A  24     -18.392   9.317  -7.673  1.00  0.00           H  
ATOM    345 HH21 ARG A  24     -18.226   9.901  -4.229  1.00  0.00           H  
ATOM    346 HH22 ARG A  24     -17.761  10.471  -5.796  1.00  0.00           H  
ATOM    347  N   LYS A  25     -17.549   2.388  -3.923  1.00  0.00           N  
ATOM    348  CA  LYS A  25     -16.305   1.628  -3.958  1.00  0.00           C  
ATOM    349  C   LYS A  25     -15.406   2.107  -5.093  1.00  0.00           C  
ATOM    350  O   LYS A  25     -14.689   1.316  -5.707  1.00  0.00           O  
ATOM    351  CB  LYS A  25     -16.599   0.136  -4.121  1.00  0.00           C  
ATOM    352  CG  LYS A  25     -17.402  -0.194  -5.367  1.00  0.00           C  
ATOM    353  CD  LYS A  25     -18.209  -1.469  -5.191  1.00  0.00           C  
ATOM    354  CE  LYS A  25     -18.486  -2.142  -6.527  1.00  0.00           C  
ATOM    355  NZ  LYS A  25     -17.274  -2.819  -7.068  1.00  0.00           N  
ATOM    356  H   LYS A  25     -18.197   2.278  -4.650  1.00  0.00           H  
ATOM    357  HA  LYS A  25     -15.793   1.785  -3.019  1.00  0.00           H  
ATOM    358  HB2 LYS A  25     -15.663  -0.401  -4.168  1.00  0.00           H  
ATOM    359  HB3 LYS A  25     -17.157  -0.205  -3.260  1.00  0.00           H  
ATOM    360  HG2 LYS A  25     -18.078   0.622  -5.576  1.00  0.00           H  
ATOM    361  HG3 LYS A  25     -16.722  -0.320  -6.199  1.00  0.00           H  
ATOM    362  HD2 LYS A  25     -17.655  -2.152  -4.565  1.00  0.00           H  
ATOM    363  HD3 LYS A  25     -19.150  -1.226  -4.719  1.00  0.00           H  
ATOM    364  HE2 LYS A  25     -19.266  -2.875  -6.391  1.00  0.00           H  
ATOM    365  HE3 LYS A  25     -18.814  -1.393  -7.232  1.00  0.00           H  
ATOM    366  HZ1 LYS A  25     -17.441  -3.118  -8.050  1.00  0.00           H  
ATOM    367  HZ2 LYS A  25     -17.049  -3.659  -6.497  1.00  0.00           H  
ATOM    368  HZ3 LYS A  25     -16.463  -2.171  -7.046  1.00  0.00           H  
ATOM    369  N   VAL A  26     -15.449   3.407  -5.368  1.00  0.00           N  
ATOM    370  CA  VAL A  26     -14.637   3.991  -6.429  1.00  0.00           C  
ATOM    371  C   VAL A  26     -13.238   4.329  -5.927  1.00  0.00           C  
ATOM    372  O   VAL A  26     -13.059   4.722  -4.774  1.00  0.00           O  
ATOM    373  CB  VAL A  26     -15.289   5.265  -6.997  1.00  0.00           C  
ATOM    374  CG1 VAL A  26     -16.626   4.939  -7.646  1.00  0.00           C  
ATOM    375  CG2 VAL A  26     -15.458   6.310  -5.904  1.00  0.00           C  
ATOM    376  H   VAL A  26     -16.041   3.987  -4.845  1.00  0.00           H  
ATOM    377  HA  VAL A  26     -14.557   3.266  -7.226  1.00  0.00           H  
ATOM    378  HB  VAL A  26     -14.636   5.671  -7.756  1.00  0.00           H  
ATOM    379 HG11 VAL A  26     -16.973   5.795  -8.203  1.00  0.00           H  
ATOM    380 HG12 VAL A  26     -16.506   4.097  -8.311  1.00  0.00           H  
ATOM    381 HG13 VAL A  26     -17.345   4.693  -6.879  1.00  0.00           H  
ATOM    382 HG21 VAL A  26     -14.693   7.065  -6.006  1.00  0.00           H  
ATOM    383 HG22 VAL A  26     -16.431   6.770  -5.993  1.00  0.00           H  
ATOM    384 HG23 VAL A  26     -15.372   5.837  -4.937  1.00  0.00           H  
ATOM    385  N   TRP A  27     -12.249   4.175  -6.799  1.00  0.00           N  
ATOM    386  CA  TRP A  27     -10.864   4.465  -6.444  1.00  0.00           C  
ATOM    387  C   TRP A  27     -10.489   5.890  -6.835  1.00  0.00           C  
ATOM    388  O   TRP A  27     -10.520   6.249  -8.011  1.00  0.00           O  
ATOM    389  CB  TRP A  27      -9.922   3.471  -7.126  1.00  0.00           C  
ATOM    390  CG  TRP A  27     -10.122   2.057  -6.674  1.00  0.00           C  
ATOM    391  CD1 TRP A  27     -10.885   1.101  -7.282  1.00  0.00           C  
ATOM    392  CD2 TRP A  27      -9.550   1.439  -5.516  1.00  0.00           C  
ATOM    393  NE1 TRP A  27     -10.823  -0.073  -6.571  1.00  0.00           N  
ATOM    394  CE2 TRP A  27     -10.009   0.107  -5.484  1.00  0.00           C  
ATOM    395  CE3 TRP A  27      -8.693   1.880  -4.505  1.00  0.00           C  
ATOM    396  CZ2 TRP A  27      -9.641  -0.783  -4.479  1.00  0.00           C  
ATOM    397  CZ3 TRP A  27      -8.328   0.994  -3.507  1.00  0.00           C  
ATOM    398  CH2 TRP A  27      -8.801  -0.325  -3.501  1.00  0.00           C  
ATOM    399  H   TRP A  27     -12.454   3.858  -7.704  1.00  0.00           H  
ATOM    400  HA  TRP A  27     -10.768   4.360  -5.374  1.00  0.00           H  
ATOM    401  HB2 TRP A  27     -10.085   3.506  -8.194  1.00  0.00           H  
ATOM    402  HB3 TRP A  27      -8.901   3.750  -6.912  1.00  0.00           H  
ATOM    403  HD1 TRP A  27     -11.452   1.261  -8.187  1.00  0.00           H  
ATOM    404  HE1 TRP A  27     -11.285  -0.905  -6.807  1.00  0.00           H  
ATOM    405  HE3 TRP A  27      -8.318   2.893  -4.492  1.00  0.00           H  
ATOM    406  HZ2 TRP A  27      -9.995  -1.803  -4.462  1.00  0.00           H  
ATOM    407  HZ3 TRP A  27      -7.667   1.318  -2.717  1.00  0.00           H  
ATOM    408  HH2 TRP A  27      -8.490  -0.981  -2.704  1.00  0.00           H  
ATOM    409  N   GLN A  28     -10.134   6.697  -5.840  1.00  0.00           N  
ATOM    410  CA  GLN A  28      -9.754   8.084  -6.081  1.00  0.00           C  
ATOM    411  C   GLN A  28      -8.266   8.293  -5.820  1.00  0.00           C  
ATOM    412  O   GLN A  28      -7.702   7.717  -4.890  1.00  0.00           O  
ATOM    413  CB  GLN A  28     -10.577   9.022  -5.196  1.00  0.00           C  
ATOM    414  CG  GLN A  28     -12.076   8.910  -5.419  1.00  0.00           C  
ATOM    415  CD  GLN A  28     -12.522   9.553  -6.717  1.00  0.00           C  
ATOM    416  OE1 GLN A  28     -12.507  10.776  -6.853  1.00  0.00           O  
ATOM    417  NE2 GLN A  28     -12.924   8.730  -7.678  1.00  0.00           N  
ATOM    418  H   GLN A  28     -10.129   6.353  -4.923  1.00  0.00           H  
ATOM    419  HA  GLN A  28      -9.960   8.309  -7.117  1.00  0.00           H  
ATOM    420  HB2 GLN A  28     -10.370   8.795  -4.161  1.00  0.00           H  
ATOM    421  HB3 GLN A  28     -10.280  10.041  -5.398  1.00  0.00           H  
ATOM    422  HG2 GLN A  28     -12.346   7.864  -5.442  1.00  0.00           H  
ATOM    423  HG3 GLN A  28     -12.586   9.394  -4.599  1.00  0.00           H  
ATOM    424 HE21 GLN A  28     -12.911   7.767  -7.497  1.00  0.00           H  
ATOM    425 HE22 GLN A  28     -13.219   9.119  -8.527  1.00  0.00           H  
ATOM    426  N   ARG A  29      -7.635   9.122  -6.646  1.00  0.00           N  
ATOM    427  CA  ARG A  29      -6.212   9.407  -6.504  1.00  0.00           C  
ATOM    428  C   ARG A  29      -5.971  10.447  -5.414  1.00  0.00           C  
ATOM    429  O   ARG A  29      -6.635  11.482  -5.372  1.00  0.00           O  
ATOM    430  CB  ARG A  29      -5.636   9.900  -7.833  1.00  0.00           C  
ATOM    431  CG  ARG A  29      -4.159  10.255  -7.760  1.00  0.00           C  
ATOM    432  CD  ARG A  29      -3.773  11.256  -8.838  1.00  0.00           C  
ATOM    433  NE  ARG A  29      -2.325  11.397  -8.961  1.00  0.00           N  
ATOM    434  CZ  ARG A  29      -1.738  12.281  -9.760  1.00  0.00           C  
ATOM    435  NH1 ARG A  29      -2.472  13.099 -10.502  1.00  0.00           N  
ATOM    436  NH2 ARG A  29      -0.414  12.348  -9.817  1.00  0.00           N  
ATOM    437  H   ARG A  29      -8.140   9.553  -7.368  1.00  0.00           H  
ATOM    438  HA  ARG A  29      -5.718   8.489  -6.226  1.00  0.00           H  
ATOM    439  HB2 ARG A  29      -5.762   9.128  -8.577  1.00  0.00           H  
ATOM    440  HB3 ARG A  29      -6.180  10.781  -8.142  1.00  0.00           H  
ATOM    441  HG2 ARG A  29      -3.948  10.686  -6.792  1.00  0.00           H  
ATOM    442  HG3 ARG A  29      -3.576   9.356  -7.890  1.00  0.00           H  
ATOM    443  HD2 ARG A  29      -4.175  10.920  -9.782  1.00  0.00           H  
ATOM    444  HD3 ARG A  29      -4.199  12.217  -8.587  1.00  0.00           H  
ATOM    445  HE  ARG A  29      -1.764  10.803  -8.422  1.00  0.00           H  
ATOM    446 HH11 ARG A  29      -3.470  13.051 -10.460  1.00  0.00           H  
ATOM    447 HH12 ARG A  29      -2.027  13.764 -11.102  1.00  0.00           H  
ATOM    448 HH21 ARG A  29       0.143  11.733  -9.260  1.00  0.00           H  
ATOM    449 HH22 ARG A  29       0.027  13.013 -10.419  1.00  0.00           H  
ATOM    450  N   ARG A  30      -5.019  10.162  -4.533  1.00  0.00           N  
ATOM    451  CA  ARG A  30      -4.691  11.072  -3.442  1.00  0.00           C  
ATOM    452  C   ARG A  30      -3.189  11.077  -3.171  1.00  0.00           C  
ATOM    453  O   ARG A  30      -2.520  10.053  -3.302  1.00  0.00           O  
ATOM    454  CB  ARG A  30      -5.447  10.672  -2.173  1.00  0.00           C  
ATOM    455  CG  ARG A  30      -5.767  11.845  -1.260  1.00  0.00           C  
ATOM    456  CD  ARG A  30      -6.477  12.959  -2.014  1.00  0.00           C  
ATOM    457  NE  ARG A  30      -5.537  13.920  -2.584  1.00  0.00           N  
ATOM    458  CZ  ARG A  30      -5.816  14.687  -3.633  1.00  0.00           C  
ATOM    459  NH1 ARG A  30      -7.001  14.604  -4.222  1.00  0.00           N  
ATOM    460  NH2 ARG A  30      -4.907  15.537  -4.094  1.00  0.00           N  
ATOM    461  H   ARG A  30      -4.524   9.320  -4.619  1.00  0.00           H  
ATOM    462  HA  ARG A  30      -4.996  12.065  -3.735  1.00  0.00           H  
ATOM    463  HB2 ARG A  30      -6.377  10.200  -2.455  1.00  0.00           H  
ATOM    464  HB3 ARG A  30      -4.847   9.966  -1.618  1.00  0.00           H  
ATOM    465  HG2 ARG A  30      -6.406  11.503  -0.460  1.00  0.00           H  
ATOM    466  HG3 ARG A  30      -4.846  12.230  -0.849  1.00  0.00           H  
ATOM    467  HD2 ARG A  30      -7.059  12.522  -2.811  1.00  0.00           H  
ATOM    468  HD3 ARG A  30      -7.135  13.475  -1.329  1.00  0.00           H  
ATOM    469  HE  ARG A  30      -4.656  13.997  -2.164  1.00  0.00           H  
ATOM    470 HH11 ARG A  30      -7.687  13.965  -3.876  1.00  0.00           H  
ATOM    471 HH12 ARG A  30      -7.207  15.183  -5.012  1.00  0.00           H  
ATOM    472 HH21 ARG A  30      -4.013  15.601  -3.653  1.00  0.00           H  
ATOM    473 HH22 ARG A  30      -5.117  16.113  -4.883  1.00  0.00           H  
ATOM    474  N   LYS A  31      -2.666  12.239  -2.793  1.00  0.00           N  
ATOM    475  CA  LYS A  31      -1.244  12.380  -2.503  1.00  0.00           C  
ATOM    476  C   LYS A  31      -0.884  11.683  -1.195  1.00  0.00           C  
ATOM    477  O   LYS A  31      -1.342  12.080  -0.123  1.00  0.00           O  
ATOM    478  CB  LYS A  31      -0.862  13.860  -2.427  1.00  0.00           C  
ATOM    479  CG  LYS A  31       0.621  14.117  -2.627  1.00  0.00           C  
ATOM    480  CD  LYS A  31       1.381  14.050  -1.314  1.00  0.00           C  
ATOM    481  CE  LYS A  31       2.605  14.953  -1.330  1.00  0.00           C  
ATOM    482  NZ  LYS A  31       3.517  14.630  -2.463  1.00  0.00           N  
ATOM    483  H   LYS A  31      -3.251  13.021  -2.706  1.00  0.00           H  
ATOM    484  HA  LYS A  31      -0.694  11.916  -3.307  1.00  0.00           H  
ATOM    485  HB2 LYS A  31      -1.406  14.399  -3.189  1.00  0.00           H  
ATOM    486  HB3 LYS A  31      -1.144  14.243  -1.456  1.00  0.00           H  
ATOM    487  HG2 LYS A  31       1.019  13.371  -3.299  1.00  0.00           H  
ATOM    488  HG3 LYS A  31       0.752  15.099  -3.058  1.00  0.00           H  
ATOM    489  HD2 LYS A  31       0.728  14.363  -0.512  1.00  0.00           H  
ATOM    490  HD3 LYS A  31       1.698  13.030  -1.143  1.00  0.00           H  
ATOM    491  HE2 LYS A  31       2.279  15.977  -1.423  1.00  0.00           H  
ATOM    492  HE3 LYS A  31       3.140  14.829  -0.401  1.00  0.00           H  
ATOM    493  HZ1 LYS A  31       4.381  15.206  -2.400  1.00  0.00           H  
ATOM    494  HZ2 LYS A  31       3.047  14.829  -3.368  1.00  0.00           H  
ATOM    495  HZ3 LYS A  31       3.780  13.624  -2.434  1.00  0.00           H  
ATOM    496  N   CYS A  32      -0.060  10.646  -1.290  1.00  0.00           N  
ATOM    497  CA  CYS A  32       0.362   9.895  -0.113  1.00  0.00           C  
ATOM    498  C   CYS A  32       1.794  10.247   0.272  1.00  0.00           C  
ATOM    499  O   CYS A  32       2.541  10.812  -0.527  1.00  0.00           O  
ATOM    500  CB  CYS A  32       0.246   8.392  -0.373  1.00  0.00           C  
ATOM    501  SG  CYS A  32      -1.402   7.714  -0.066  1.00  0.00           S  
ATOM    502  H   CYS A  32       0.271  10.377  -2.172  1.00  0.00           H  
ATOM    503  HA  CYS A  32      -0.293  10.161   0.702  1.00  0.00           H  
ATOM    504  HB2 CYS A  32       0.496   8.192  -1.405  1.00  0.00           H  
ATOM    505  HB3 CYS A  32       0.943   7.869   0.265  1.00  0.00           H  
ATOM    506  HG  CYS A  32      -2.291   8.569  -0.547  1.00  0.00           H  
ATOM    507  N   SER A  33       2.171   9.912   1.502  1.00  0.00           N  
ATOM    508  CA  SER A  33       3.513  10.199   1.996  1.00  0.00           C  
ATOM    509  C   SER A  33       3.874   9.275   3.155  1.00  0.00           C  
ATOM    510  O   SER A  33       3.062   9.034   4.048  1.00  0.00           O  
ATOM    511  CB  SER A  33       3.615  11.659   2.441  1.00  0.00           C  
ATOM    512  OG  SER A  33       2.704  11.936   3.491  1.00  0.00           O  
ATOM    513  H   SER A  33       1.529   9.463   2.093  1.00  0.00           H  
ATOM    514  HA  SER A  33       4.207  10.029   1.186  1.00  0.00           H  
ATOM    515  HB2 SER A  33       4.617  11.858   2.788  1.00  0.00           H  
ATOM    516  HB3 SER A  33       3.388  12.304   1.604  1.00  0.00           H  
ATOM    517  HG  SER A  33       2.930  11.407   4.260  1.00  0.00           H  
ATOM    518  N   VAL A  34       5.100   8.761   3.134  1.00  0.00           N  
ATOM    519  CA  VAL A  34       5.571   7.864   4.183  1.00  0.00           C  
ATOM    520  C   VAL A  34       6.920   8.319   4.730  1.00  0.00           C  
ATOM    521  O   VAL A  34       7.897   8.428   3.989  1.00  0.00           O  
ATOM    522  CB  VAL A  34       5.697   6.418   3.671  1.00  0.00           C  
ATOM    523  CG1 VAL A  34       6.650   5.622   4.548  1.00  0.00           C  
ATOM    524  CG2 VAL A  34       4.330   5.752   3.613  1.00  0.00           C  
ATOM    525  H   VAL A  34       5.702   8.990   2.396  1.00  0.00           H  
ATOM    526  HA  VAL A  34       4.846   7.878   4.984  1.00  0.00           H  
ATOM    527  HB  VAL A  34       6.103   6.446   2.670  1.00  0.00           H  
ATOM    528 HG11 VAL A  34       6.630   6.017   5.553  1.00  0.00           H  
ATOM    529 HG12 VAL A  34       6.348   4.585   4.561  1.00  0.00           H  
ATOM    530 HG13 VAL A  34       7.653   5.700   4.153  1.00  0.00           H  
ATOM    531 HG21 VAL A  34       3.852   5.829   4.579  1.00  0.00           H  
ATOM    532 HG22 VAL A  34       3.721   6.244   2.870  1.00  0.00           H  
ATOM    533 HG23 VAL A  34       4.447   4.711   3.350  1.00  0.00           H  
ATOM    534  N   LYS A  35       6.967   8.581   6.031  1.00  0.00           N  
ATOM    535  CA  LYS A  35       8.197   9.022   6.679  1.00  0.00           C  
ATOM    536  C   LYS A  35       8.153   8.740   8.178  1.00  0.00           C  
ATOM    537  O   LYS A  35       7.130   8.947   8.828  1.00  0.00           O  
ATOM    538  CB  LYS A  35       8.417  10.517   6.436  1.00  0.00           C  
ATOM    539  CG  LYS A  35       9.635  11.076   7.153  1.00  0.00           C  
ATOM    540  CD  LYS A  35       9.446  12.539   7.515  1.00  0.00           C  
ATOM    541  CE  LYS A  35       9.911  13.455   6.393  1.00  0.00           C  
ATOM    542  NZ  LYS A  35       9.860  14.890   6.791  1.00  0.00           N  
ATOM    543  H   LYS A  35       6.154   8.476   6.570  1.00  0.00           H  
ATOM    544  HA  LYS A  35       9.016   8.470   6.245  1.00  0.00           H  
ATOM    545  HB2 LYS A  35       8.541  10.683   5.376  1.00  0.00           H  
ATOM    546  HB3 LYS A  35       7.546  11.057   6.777  1.00  0.00           H  
ATOM    547  HG2 LYS A  35       9.799  10.510   8.058  1.00  0.00           H  
ATOM    548  HG3 LYS A  35      10.496  10.982   6.506  1.00  0.00           H  
ATOM    549  HD2 LYS A  35       8.398  12.723   7.702  1.00  0.00           H  
ATOM    550  HD3 LYS A  35      10.017  12.758   8.407  1.00  0.00           H  
ATOM    551  HE2 LYS A  35      10.927  13.198   6.134  1.00  0.00           H  
ATOM    552  HE3 LYS A  35       9.273  13.305   5.535  1.00  0.00           H  
ATOM    553  HZ1 LYS A  35      10.005  15.496   5.958  1.00  0.00           H  
ATOM    554  HZ2 LYS A  35      10.604  15.094   7.489  1.00  0.00           H  
ATOM    555  HZ3 LYS A  35       8.935  15.111   7.212  1.00  0.00           H  
ATOM    556  N   ASN A  36       9.271   8.269   8.720  1.00  0.00           N  
ATOM    557  CA  ASN A  36       9.360   7.960  10.142  1.00  0.00           C  
ATOM    558  C   ASN A  36       8.382   6.851  10.520  1.00  0.00           C  
ATOM    559  O   ASN A  36       7.959   6.748  11.671  1.00  0.00           O  
ATOM    560  CB  ASN A  36       9.077   9.211  10.975  1.00  0.00           C  
ATOM    561  CG  ASN A  36      10.178  10.248  10.854  1.00  0.00           C  
ATOM    562  OD1 ASN A  36      11.360   9.931  10.981  1.00  0.00           O  
ATOM    563  ND2 ASN A  36       9.791  11.494  10.608  1.00  0.00           N  
ATOM    564  H   ASN A  36      10.055   8.124   8.149  1.00  0.00           H  
ATOM    565  HA  ASN A  36      10.365   7.622  10.345  1.00  0.00           H  
ATOM    566  HB2 ASN A  36       8.151   9.657  10.642  1.00  0.00           H  
ATOM    567  HB3 ASN A  36       8.984   8.932  12.014  1.00  0.00           H  
ATOM    568 HD21 ASN A  36       8.832  11.673  10.519  1.00  0.00           H  
ATOM    569 HD22 ASN A  36      10.483  12.184  10.524  1.00  0.00           H  
ATOM    570  N   GLY A  37       8.027   6.023   9.542  1.00  0.00           N  
ATOM    571  CA  GLY A  37       7.102   4.934   9.792  1.00  0.00           C  
ATOM    572  C   GLY A  37       5.669   5.408   9.927  1.00  0.00           C  
ATOM    573  O   GLY A  37       4.855   4.767  10.593  1.00  0.00           O  
ATOM    574  H   GLY A  37       8.396   6.155   8.643  1.00  0.00           H  
ATOM    575  HA2 GLY A  37       7.162   4.230   8.976  1.00  0.00           H  
ATOM    576  HA3 GLY A  37       7.390   4.435  10.706  1.00  0.00           H  
ATOM    577  N   ILE A  38       5.359   6.535   9.295  1.00  0.00           N  
ATOM    578  CA  ILE A  38       4.014   7.096   9.347  1.00  0.00           C  
ATOM    579  C   ILE A  38       3.492   7.406   7.949  1.00  0.00           C  
ATOM    580  O   ILE A  38       4.228   7.905   7.096  1.00  0.00           O  
ATOM    581  CB  ILE A  38       3.973   8.381  10.196  1.00  0.00           C  
ATOM    582  CG1 ILE A  38       4.417   8.086  11.630  1.00  0.00           C  
ATOM    583  CG2 ILE A  38       2.574   8.980  10.180  1.00  0.00           C  
ATOM    584  CD1 ILE A  38       3.511   7.116  12.355  1.00  0.00           C  
ATOM    585  H   ILE A  38       6.050   7.000   8.780  1.00  0.00           H  
ATOM    586  HA  ILE A  38       3.367   6.364   9.808  1.00  0.00           H  
ATOM    587  HB  ILE A  38       4.650   9.097   9.756  1.00  0.00           H  
ATOM    588 HG12 ILE A  38       5.409   7.664  11.612  1.00  0.00           H  
ATOM    589 HG13 ILE A  38       4.432   9.010  12.190  1.00  0.00           H  
ATOM    590 HG21 ILE A  38       2.346   9.336   9.186  1.00  0.00           H  
ATOM    591 HG22 ILE A  38       1.857   8.226  10.465  1.00  0.00           H  
ATOM    592 HG23 ILE A  38       2.528   9.804  10.878  1.00  0.00           H  
ATOM    593 HD11 ILE A  38       3.686   6.115  11.987  1.00  0.00           H  
ATOM    594 HD12 ILE A  38       3.718   7.152  13.414  1.00  0.00           H  
ATOM    595 HD13 ILE A  38       2.479   7.387  12.181  1.00  0.00           H  
ATOM    596  N   LEU A  39       2.218   7.108   7.719  1.00  0.00           N  
ATOM    597  CA  LEU A  39       1.595   7.357   6.424  1.00  0.00           C  
ATOM    598  C   LEU A  39       0.545   8.457   6.527  1.00  0.00           C  
ATOM    599  O   LEU A  39      -0.464   8.305   7.218  1.00  0.00           O  
ATOM    600  CB  LEU A  39       0.957   6.074   5.888  1.00  0.00           C  
ATOM    601  CG  LEU A  39      -0.050   6.250   4.751  1.00  0.00           C  
ATOM    602  CD1 LEU A  39       0.667   6.566   3.448  1.00  0.00           C  
ATOM    603  CD2 LEU A  39      -0.908   5.002   4.601  1.00  0.00           C  
ATOM    604  H   LEU A  39       1.683   6.712   8.438  1.00  0.00           H  
ATOM    605  HA  LEU A  39       2.368   7.677   5.741  1.00  0.00           H  
ATOM    606  HB2 LEU A  39       1.749   5.434   5.531  1.00  0.00           H  
ATOM    607  HB3 LEU A  39       0.448   5.591   6.710  1.00  0.00           H  
ATOM    608  HG  LEU A  39      -0.703   7.080   4.982  1.00  0.00           H  
ATOM    609 HD11 LEU A  39       1.484   7.244   3.642  1.00  0.00           H  
ATOM    610 HD12 LEU A  39      -0.026   7.026   2.758  1.00  0.00           H  
ATOM    611 HD13 LEU A  39       1.050   5.653   3.016  1.00  0.00           H  
ATOM    612 HD21 LEU A  39      -1.276   4.939   3.587  1.00  0.00           H  
ATOM    613 HD22 LEU A  39      -1.743   5.056   5.285  1.00  0.00           H  
ATOM    614 HD23 LEU A  39      -0.315   4.129   4.824  1.00  0.00           H  
ATOM    615  N   THR A  40       0.786   9.566   5.833  1.00  0.00           N  
ATOM    616  CA  THR A  40      -0.141  10.691   5.845  1.00  0.00           C  
ATOM    617  C   THR A  40      -0.984  10.723   4.577  1.00  0.00           C  
ATOM    618  O   THR A  40      -0.505  10.384   3.493  1.00  0.00           O  
ATOM    619  CB  THR A  40       0.607  12.031   5.987  1.00  0.00           C  
ATOM    620  OG1 THR A  40       1.570  11.947   7.043  1.00  0.00           O  
ATOM    621  CG2 THR A  40      -0.367  13.166   6.271  1.00  0.00           C  
ATOM    622  H   THR A  40       1.606   9.626   5.302  1.00  0.00           H  
ATOM    623  HA  THR A  40      -0.794  10.576   6.698  1.00  0.00           H  
ATOM    624  HB  THR A  40       1.119  12.240   5.058  1.00  0.00           H  
ATOM    625  HG1 THR A  40       2.449  12.097   6.687  1.00  0.00           H  
ATOM    626 HG21 THR A  40      -0.289  13.455   7.308  1.00  0.00           H  
ATOM    627 HG22 THR A  40      -1.373  12.837   6.062  1.00  0.00           H  
ATOM    628 HG23 THR A  40      -0.127  14.011   5.643  1.00  0.00           H  
ATOM    629  N   ILE A  41      -2.239  11.135   4.716  1.00  0.00           N  
ATOM    630  CA  ILE A  41      -3.148  11.213   3.579  1.00  0.00           C  
ATOM    631  C   ILE A  41      -3.811  12.584   3.498  1.00  0.00           C  
ATOM    632  O   ILE A  41      -4.597  12.957   4.369  1.00  0.00           O  
ATOM    633  CB  ILE A  41      -4.241  10.131   3.656  1.00  0.00           C  
ATOM    634  CG1 ILE A  41      -3.607   8.740   3.734  1.00  0.00           C  
ATOM    635  CG2 ILE A  41      -5.169  10.228   2.455  1.00  0.00           C  
ATOM    636  CD1 ILE A  41      -4.543   7.678   4.267  1.00  0.00           C  
ATOM    637  H   ILE A  41      -2.562  11.393   5.604  1.00  0.00           H  
ATOM    638  HA  ILE A  41      -2.570  11.051   2.680  1.00  0.00           H  
ATOM    639  HB  ILE A  41      -4.824  10.303   4.547  1.00  0.00           H  
ATOM    640 HG12 ILE A  41      -3.292   8.439   2.747  1.00  0.00           H  
ATOM    641 HG13 ILE A  41      -2.746   8.782   4.386  1.00  0.00           H  
ATOM    642 HG21 ILE A  41      -4.585  10.391   1.561  1.00  0.00           H  
ATOM    643 HG22 ILE A  41      -5.727   9.309   2.356  1.00  0.00           H  
ATOM    644 HG23 ILE A  41      -5.852  11.053   2.593  1.00  0.00           H  
ATOM    645 HD11 ILE A  41      -5.132   8.089   5.074  1.00  0.00           H  
ATOM    646 HD12 ILE A  41      -5.197   7.344   3.476  1.00  0.00           H  
ATOM    647 HD13 ILE A  41      -3.967   6.842   4.635  1.00  0.00           H  
ATOM    648  N   SER A  42      -3.490  13.330   2.446  1.00  0.00           N  
ATOM    649  CA  SER A  42      -4.053  14.661   2.252  1.00  0.00           C  
ATOM    650  C   SER A  42      -5.527  14.577   1.870  1.00  0.00           C  
ATOM    651  O   SER A  42      -5.979  13.579   1.305  1.00  0.00           O  
ATOM    652  CB  SER A  42      -3.276  15.414   1.171  1.00  0.00           C  
ATOM    653  OG  SER A  42      -3.324  16.813   1.389  1.00  0.00           O  
ATOM    654  H   SER A  42      -2.857  12.977   1.786  1.00  0.00           H  
ATOM    655  HA  SER A  42      -3.966  15.197   3.186  1.00  0.00           H  
ATOM    656  HB2 SER A  42      -2.245  15.096   1.185  1.00  0.00           H  
ATOM    657  HB3 SER A  42      -3.707  15.197   0.205  1.00  0.00           H  
ATOM    658  HG  SER A  42      -4.237  17.089   1.499  1.00  0.00           H  
ATOM    659  N   HIS A  43      -6.275  15.631   2.180  1.00  0.00           N  
ATOM    660  CA  HIS A  43      -7.698  15.678   1.869  1.00  0.00           C  
ATOM    661  C   HIS A  43      -7.939  16.359   0.525  1.00  0.00           C  
ATOM    662  O   HIS A  43      -7.076  17.076   0.019  1.00  0.00           O  
ATOM    663  CB  HIS A  43      -8.460  16.416   2.970  1.00  0.00           C  
ATOM    664  CG  HIS A  43      -8.911  15.525   4.087  1.00  0.00           C  
ATOM    665  ND1 HIS A  43      -9.360  14.237   3.887  1.00  0.00           N  
ATOM    666  CD2 HIS A  43      -8.978  15.742   5.421  1.00  0.00           C  
ATOM    667  CE1 HIS A  43      -9.687  13.701   5.049  1.00  0.00           C  
ATOM    668  NE2 HIS A  43      -9.464  14.594   5.997  1.00  0.00           N  
ATOM    669  H   HIS A  43      -5.858  16.396   2.629  1.00  0.00           H  
ATOM    670  HA  HIS A  43      -8.059  14.662   1.813  1.00  0.00           H  
ATOM    671  HB2 HIS A  43      -7.820  17.177   3.392  1.00  0.00           H  
ATOM    672  HB3 HIS A  43      -9.336  16.884   2.543  1.00  0.00           H  
ATOM    673  HD1 HIS A  43      -9.430  13.783   3.022  1.00  0.00           H  
ATOM    674  HD2 HIS A  43      -8.702  16.651   5.938  1.00  0.00           H  
ATOM    675  HE1 HIS A  43     -10.069  12.703   5.200  1.00  0.00           H  
ATOM    676  HE2 HIS A  43      -9.700  14.486   6.942  1.00  0.00           H  
ATOM    677  N   ALA A  44      -9.115  16.128  -0.049  1.00  0.00           N  
ATOM    678  CA  ALA A  44      -9.469  16.720  -1.333  1.00  0.00           C  
ATOM    679  C   ALA A  44     -10.815  17.432  -1.257  1.00  0.00           C  
ATOM    680  O   ALA A  44     -11.046  18.424  -1.950  1.00  0.00           O  
ATOM    681  CB  ALA A  44      -9.494  15.653  -2.416  1.00  0.00           C  
ATOM    682  H   ALA A  44      -9.762  15.548   0.404  1.00  0.00           H  
ATOM    683  HA  ALA A  44      -8.706  17.441  -1.588  1.00  0.00           H  
ATOM    684  HB1 ALA A  44      -9.764  16.106  -3.360  1.00  0.00           H  
ATOM    685  HB2 ALA A  44      -8.517  15.203  -2.501  1.00  0.00           H  
ATOM    686  HB3 ALA A  44     -10.219  14.896  -2.160  1.00  0.00           H  
ATOM    687  N   THR A  45     -11.704  16.921  -0.411  1.00  0.00           N  
ATOM    688  CA  THR A  45     -13.028  17.506  -0.246  1.00  0.00           C  
ATOM    689  C   THR A  45     -13.012  18.619   0.796  1.00  0.00           C  
ATOM    690  O   THR A  45     -13.827  19.540   0.746  1.00  0.00           O  
ATOM    691  CB  THR A  45     -14.064  16.444   0.170  1.00  0.00           C  
ATOM    692  OG1 THR A  45     -13.470  15.510   1.079  1.00  0.00           O  
ATOM    693  CG2 THR A  45     -14.600  15.705  -1.047  1.00  0.00           C  
ATOM    694  H   THR A  45     -11.462  16.129   0.114  1.00  0.00           H  
ATOM    695  HA  THR A  45     -13.331  17.920  -1.197  1.00  0.00           H  
ATOM    696  HB  THR A  45     -14.888  16.941   0.663  1.00  0.00           H  
ATOM    697  HG1 THR A  45     -12.809  15.958   1.611  1.00  0.00           H  
ATOM    698 HG21 THR A  45     -14.719  16.399  -1.865  1.00  0.00           H  
ATOM    699 HG22 THR A  45     -15.556  15.263  -0.807  1.00  0.00           H  
ATOM    700 HG23 THR A  45     -13.906  14.930  -1.331  1.00  0.00           H  
ATOM    701  N   SER A  46     -12.078  18.528   1.737  1.00  0.00           N  
ATOM    702  CA  SER A  46     -11.958  19.527   2.793  1.00  0.00           C  
ATOM    703  C   SER A  46     -10.492  19.792   3.125  1.00  0.00           C  
ATOM    704  O   SER A  46      -9.826  18.966   3.748  1.00  0.00           O  
ATOM    705  CB  SER A  46     -12.701  19.065   4.048  1.00  0.00           C  
ATOM    706  OG  SER A  46     -12.233  17.799   4.481  1.00  0.00           O  
ATOM    707  H   SER A  46     -11.457  17.769   1.722  1.00  0.00           H  
ATOM    708  HA  SER A  46     -12.405  20.442   2.436  1.00  0.00           H  
ATOM    709  HB2 SER A  46     -12.547  19.782   4.839  1.00  0.00           H  
ATOM    710  HB3 SER A  46     -13.756  18.990   3.831  1.00  0.00           H  
ATOM    711  HG  SER A  46     -12.502  17.653   5.392  1.00  0.00           H  
ATOM    712  N   ASN A  47      -9.997  20.951   2.702  1.00  0.00           N  
ATOM    713  CA  ASN A  47      -8.611  21.326   2.954  1.00  0.00           C  
ATOM    714  C   ASN A  47      -8.437  21.846   4.379  1.00  0.00           C  
ATOM    715  O   ASN A  47      -8.200  23.035   4.592  1.00  0.00           O  
ATOM    716  CB  ASN A  47      -8.159  22.391   1.952  1.00  0.00           C  
ATOM    717  CG  ASN A  47      -6.653  22.416   1.775  1.00  0.00           C  
ATOM    718  OD1 ASN A  47      -5.909  21.920   2.620  1.00  0.00           O  
ATOM    719  ND2 ASN A  47      -6.197  22.996   0.671  1.00  0.00           N  
ATOM    720  H   ASN A  47     -10.578  21.568   2.210  1.00  0.00           H  
ATOM    721  HA  ASN A  47      -8.000  20.444   2.828  1.00  0.00           H  
ATOM    722  HB2 ASN A  47      -8.612  22.188   0.992  1.00  0.00           H  
ATOM    723  HB3 ASN A  47      -8.478  23.362   2.299  1.00  0.00           H  
ATOM    724 HD21 ASN A  47      -6.849  23.371   0.041  1.00  0.00           H  
ATOM    725 HD22 ASN A  47      -5.229  23.026   0.530  1.00  0.00           H  
ATOM    726  N   ARG A  48      -8.556  20.947   5.349  1.00  0.00           N  
ATOM    727  CA  ARG A  48      -8.412  21.314   6.752  1.00  0.00           C  
ATOM    728  C   ARG A  48      -7.147  20.704   7.348  1.00  0.00           C  
ATOM    729  O   ARG A  48      -6.248  21.422   7.785  1.00  0.00           O  
ATOM    730  CB  ARG A  48      -9.636  20.855   7.549  1.00  0.00           C  
ATOM    731  CG  ARG A  48      -9.604  21.275   9.009  1.00  0.00           C  
ATOM    732  CD  ARG A  48     -10.884  20.882   9.730  1.00  0.00           C  
ATOM    733  NE  ARG A  48     -11.071  19.434   9.766  1.00  0.00           N  
ATOM    734  CZ  ARG A  48     -12.185  18.847  10.189  1.00  0.00           C  
ATOM    735  NH1 ARG A  48     -13.206  19.580  10.610  1.00  0.00           N  
ATOM    736  NH2 ARG A  48     -12.278  17.523  10.191  1.00  0.00           N  
ATOM    737  H   ARG A  48      -8.745  20.013   5.116  1.00  0.00           H  
ATOM    738  HA  ARG A  48      -8.341  22.389   6.809  1.00  0.00           H  
ATOM    739  HB2 ARG A  48     -10.524  21.272   7.096  1.00  0.00           H  
ATOM    740  HB3 ARG A  48      -9.693  19.778   7.509  1.00  0.00           H  
ATOM    741  HG2 ARG A  48      -8.769  20.793   9.496  1.00  0.00           H  
ATOM    742  HG3 ARG A  48      -9.485  22.346   9.063  1.00  0.00           H  
ATOM    743  HD2 ARG A  48     -10.841  21.255  10.742  1.00  0.00           H  
ATOM    744  HD3 ARG A  48     -11.722  21.332   9.216  1.00  0.00           H  
ATOM    745  HE  ARG A  48     -10.328  18.874   9.459  1.00  0.00           H  
ATOM    746 HH11 ARG A  48     -13.139  20.577  10.608  1.00  0.00           H  
ATOM    747 HH12 ARG A  48     -14.044  19.135  10.927  1.00  0.00           H  
ATOM    748 HH21 ARG A  48     -11.511  16.968   9.874  1.00  0.00           H  
ATOM    749 HH22 ARG A  48     -13.116  17.082  10.510  1.00  0.00           H  
ATOM    750  N   GLN A  49      -7.084  19.377   7.360  1.00  0.00           N  
ATOM    751  CA  GLN A  49      -5.929  18.671   7.902  1.00  0.00           C  
ATOM    752  C   GLN A  49      -5.841  17.256   7.340  1.00  0.00           C  
ATOM    753  O   GLN A  49      -6.850  16.585   7.122  1.00  0.00           O  
ATOM    754  CB  GLN A  49      -6.007  18.622   9.429  1.00  0.00           C  
ATOM    755  CG  GLN A  49      -5.518  19.893  10.105  1.00  0.00           C  
ATOM    756  CD  GLN A  49      -4.126  20.293   9.659  1.00  0.00           C  
ATOM    757  OE1 GLN A  49      -3.961  21.164   8.804  1.00  0.00           O  
ATOM    758  NE2 GLN A  49      -3.113  19.658  10.237  1.00  0.00           N  
ATOM    759  H   GLN A  49      -7.833  18.859   6.996  1.00  0.00           H  
ATOM    760  HA  GLN A  49      -5.043  19.215   7.613  1.00  0.00           H  
ATOM    761  HB2 GLN A  49      -7.033  18.456   9.721  1.00  0.00           H  
ATOM    762  HB3 GLN A  49      -5.403  17.799   9.782  1.00  0.00           H  
ATOM    763  HG2 GLN A  49      -6.200  20.696   9.867  1.00  0.00           H  
ATOM    764  HG3 GLN A  49      -5.507  19.737  11.173  1.00  0.00           H  
ATOM    765 HE21 GLN A  49      -3.319  18.974  10.909  1.00  0.00           H  
ATOM    766 HE22 GLN A  49      -2.203  19.895   9.967  1.00  0.00           H  
ATOM    767  N   PRO A  50      -4.608  16.791   7.097  1.00  0.00           N  
ATOM    768  CA  PRO A  50      -4.359  15.451   6.556  1.00  0.00           C  
ATOM    769  C   PRO A  50      -4.682  14.351   7.562  1.00  0.00           C  
ATOM    770  O   PRO A  50      -5.165  14.624   8.660  1.00  0.00           O  
ATOM    771  CB  PRO A  50      -2.860  15.467   6.244  1.00  0.00           C  
ATOM    772  CG  PRO A  50      -2.292  16.490   7.166  1.00  0.00           C  
ATOM    773  CD  PRO A  50      -3.360  17.537   7.332  1.00  0.00           C  
ATOM    774  HA  PRO A  50      -4.916  15.280   5.648  1.00  0.00           H  
ATOM    775  HB2 PRO A  50      -2.440  14.489   6.432  1.00  0.00           H  
ATOM    776  HB3 PRO A  50      -2.707  15.738   5.211  1.00  0.00           H  
ATOM    777  HG2 PRO A  50      -2.060  16.038   8.119  1.00  0.00           H  
ATOM    778  HG3 PRO A  50      -1.406  16.925   6.730  1.00  0.00           H  
ATOM    779  HD2 PRO A  50      -3.337  17.945   8.332  1.00  0.00           H  
ATOM    780  HD3 PRO A  50      -3.236  18.320   6.600  1.00  0.00           H  
ATOM    781  N   ALA A  51      -4.412  13.107   7.179  1.00  0.00           N  
ATOM    782  CA  ALA A  51      -4.672  11.967   8.048  1.00  0.00           C  
ATOM    783  C   ALA A  51      -3.448  11.062   8.147  1.00  0.00           C  
ATOM    784  O   ALA A  51      -3.069  10.406   7.177  1.00  0.00           O  
ATOM    785  CB  ALA A  51      -5.873  11.180   7.544  1.00  0.00           C  
ATOM    786  H   ALA A  51      -4.028  12.953   6.291  1.00  0.00           H  
ATOM    787  HA  ALA A  51      -4.909  12.345   9.033  1.00  0.00           H  
ATOM    788  HB1 ALA A  51      -6.734  11.408   8.155  1.00  0.00           H  
ATOM    789  HB2 ALA A  51      -6.076  11.454   6.519  1.00  0.00           H  
ATOM    790  HB3 ALA A  51      -5.660  10.123   7.599  1.00  0.00           H  
ATOM    791  N   LYS A  52      -2.834  11.032   9.325  1.00  0.00           N  
ATOM    792  CA  LYS A  52      -1.654  10.206   9.552  1.00  0.00           C  
ATOM    793  C   LYS A  52      -2.047   8.814  10.035  1.00  0.00           C  
ATOM    794  O   LYS A  52      -3.009   8.656  10.789  1.00  0.00           O  
ATOM    795  CB  LYS A  52      -0.731  10.872  10.576  1.00  0.00           C  
ATOM    796  CG  LYS A  52       0.218  11.890   9.968  1.00  0.00           C  
ATOM    797  CD  LYS A  52       1.305  12.295  10.950  1.00  0.00           C  
ATOM    798  CE  LYS A  52       0.879  13.489  11.792  1.00  0.00           C  
ATOM    799  NZ  LYS A  52       1.840  13.758  12.897  1.00  0.00           N  
ATOM    800  H   LYS A  52      -3.185  11.577  10.061  1.00  0.00           H  
ATOM    801  HA  LYS A  52      -1.128  10.114   8.614  1.00  0.00           H  
ATOM    802  HB2 LYS A  52      -1.336  11.372  11.317  1.00  0.00           H  
ATOM    803  HB3 LYS A  52      -0.141  10.107  11.061  1.00  0.00           H  
ATOM    804  HG2 LYS A  52       0.680  11.460   9.093  1.00  0.00           H  
ATOM    805  HG3 LYS A  52      -0.345  12.769   9.686  1.00  0.00           H  
ATOM    806  HD2 LYS A  52       1.514  11.463  11.606  1.00  0.00           H  
ATOM    807  HD3 LYS A  52       2.197  12.554  10.399  1.00  0.00           H  
ATOM    808  HE2 LYS A  52       0.822  14.359  11.156  1.00  0.00           H  
ATOM    809  HE3 LYS A  52      -0.094  13.286  12.213  1.00  0.00           H  
ATOM    810  HZ1 LYS A  52       2.720  13.225  12.744  1.00  0.00           H  
ATOM    811  HZ2 LYS A  52       1.427  13.469  13.807  1.00  0.00           H  
ATOM    812  HZ3 LYS A  52       2.064  14.773  12.937  1.00  0.00           H  
ATOM    813  N   LEU A  53      -1.298   7.808   9.598  1.00  0.00           N  
ATOM    814  CA  LEU A  53      -1.567   6.428   9.988  1.00  0.00           C  
ATOM    815  C   LEU A  53      -0.286   5.725  10.423  1.00  0.00           C  
ATOM    816  O   LEU A  53       0.615   5.501   9.616  1.00  0.00           O  
ATOM    817  CB  LEU A  53      -2.212   5.667   8.828  1.00  0.00           C  
ATOM    818  CG  LEU A  53      -3.723   5.838   8.670  1.00  0.00           C  
ATOM    819  CD1 LEU A  53      -4.138   5.615   7.224  1.00  0.00           C  
ATOM    820  CD2 LEU A  53      -4.467   4.884   9.593  1.00  0.00           C  
ATOM    821  H   LEU A  53      -0.546   7.996   9.000  1.00  0.00           H  
ATOM    822  HA  LEU A  53      -2.254   6.448  10.821  1.00  0.00           H  
ATOM    823  HB2 LEU A  53      -1.744   6.000   7.914  1.00  0.00           H  
ATOM    824  HB3 LEU A  53      -2.010   4.615   8.971  1.00  0.00           H  
ATOM    825  HG  LEU A  53      -3.995   6.848   8.943  1.00  0.00           H  
ATOM    826 HD11 LEU A  53      -5.145   5.976   7.079  1.00  0.00           H  
ATOM    827 HD12 LEU A  53      -4.095   4.561   6.997  1.00  0.00           H  
ATOM    828 HD13 LEU A  53      -3.466   6.151   6.570  1.00  0.00           H  
ATOM    829 HD21 LEU A  53      -4.536   3.912   9.126  1.00  0.00           H  
ATOM    830 HD22 LEU A  53      -5.461   5.264   9.779  1.00  0.00           H  
ATOM    831 HD23 LEU A  53      -3.933   4.799  10.528  1.00  0.00           H  
ATOM    832  N   ASN A  54      -0.213   5.378  11.704  1.00  0.00           N  
ATOM    833  CA  ASN A  54       0.957   4.698  12.246  1.00  0.00           C  
ATOM    834  C   ASN A  54       1.100   3.301  11.650  1.00  0.00           C  
ATOM    835  O   ASN A  54       0.223   2.452  11.813  1.00  0.00           O  
ATOM    836  CB  ASN A  54       0.860   4.606  13.771  1.00  0.00           C  
ATOM    837  CG  ASN A  54       1.483   5.802  14.463  1.00  0.00           C  
ATOM    838  OD1 ASN A  54       0.921   6.898  14.461  1.00  0.00           O  
ATOM    839  ND2 ASN A  54       2.651   5.597  15.061  1.00  0.00           N  
ATOM    840  H   ASN A  54      -0.965   5.584  12.299  1.00  0.00           H  
ATOM    841  HA  ASN A  54       1.828   5.279  11.985  1.00  0.00           H  
ATOM    842  HB2 ASN A  54      -0.182   4.552  14.055  1.00  0.00           H  
ATOM    843  HB3 ASN A  54       1.366   3.714  14.105  1.00  0.00           H  
ATOM    844 HD21 ASN A  54       3.039   4.698  15.021  1.00  0.00           H  
ATOM    845 HD22 ASN A  54       3.076   6.353  15.517  1.00  0.00           H  
ATOM    846  N   LEU A  55       2.211   3.069  10.958  1.00  0.00           N  
ATOM    847  CA  LEU A  55       2.470   1.776  10.338  1.00  0.00           C  
ATOM    848  C   LEU A  55       2.891   0.745  11.380  1.00  0.00           C  
ATOM    849  O   LEU A  55       2.779  -0.460  11.159  1.00  0.00           O  
ATOM    850  CB  LEU A  55       3.556   1.909   9.268  1.00  0.00           C  
ATOM    851  CG  LEU A  55       3.133   2.580   7.961  1.00  0.00           C  
ATOM    852  CD1 LEU A  55       2.205   3.753   8.240  1.00  0.00           C  
ATOM    853  CD2 LEU A  55       4.353   3.037   7.176  1.00  0.00           C  
ATOM    854  H   LEU A  55       2.873   3.785  10.863  1.00  0.00           H  
ATOM    855  HA  LEU A  55       1.555   1.443   9.871  1.00  0.00           H  
ATOM    856  HB2 LEU A  55       4.365   2.487   9.689  1.00  0.00           H  
ATOM    857  HB3 LEU A  55       3.911   0.916   9.032  1.00  0.00           H  
ATOM    858  HG  LEU A  55       2.593   1.865   7.356  1.00  0.00           H  
ATOM    859 HD11 LEU A  55       1.272   3.387   8.640  1.00  0.00           H  
ATOM    860 HD12 LEU A  55       2.018   4.289   7.320  1.00  0.00           H  
ATOM    861 HD13 LEU A  55       2.670   4.417   8.954  1.00  0.00           H  
ATOM    862 HD21 LEU A  55       4.895   3.774   7.750  1.00  0.00           H  
ATOM    863 HD22 LEU A  55       4.037   3.472   6.239  1.00  0.00           H  
ATOM    864 HD23 LEU A  55       4.994   2.189   6.982  1.00  0.00           H  
ATOM    865  N   LEU A  56       3.375   1.228  12.520  1.00  0.00           N  
ATOM    866  CA  LEU A  56       3.811   0.350  13.599  1.00  0.00           C  
ATOM    867  C   LEU A  56       2.641  -0.459  14.149  1.00  0.00           C  
ATOM    868  O   LEU A  56       2.801  -1.615  14.545  1.00  0.00           O  
ATOM    869  CB  LEU A  56       4.452   1.168  14.722  1.00  0.00           C  
ATOM    870  CG  LEU A  56       5.300   2.363  14.282  1.00  0.00           C  
ATOM    871  CD1 LEU A  56       6.123   2.890  15.447  1.00  0.00           C  
ATOM    872  CD2 LEU A  56       6.202   1.977  13.119  1.00  0.00           C  
ATOM    873  H   LEU A  56       3.440   2.199  12.638  1.00  0.00           H  
ATOM    874  HA  LEU A  56       4.546  -0.330  13.197  1.00  0.00           H  
ATOM    875  HB2 LEU A  56       3.659   1.540  15.354  1.00  0.00           H  
ATOM    876  HB3 LEU A  56       5.084   0.504  15.294  1.00  0.00           H  
ATOM    877  HG  LEU A  56       4.646   3.157  13.950  1.00  0.00           H  
ATOM    878 HD11 LEU A  56       7.037   3.326  15.073  1.00  0.00           H  
ATOM    879 HD12 LEU A  56       6.360   2.078  16.118  1.00  0.00           H  
ATOM    880 HD13 LEU A  56       5.556   3.640  15.978  1.00  0.00           H  
ATOM    881 HD21 LEU A  56       6.617   2.869  12.675  1.00  0.00           H  
ATOM    882 HD22 LEU A  56       5.626   1.440  12.379  1.00  0.00           H  
ATOM    883 HD23 LEU A  56       7.003   1.347  13.480  1.00  0.00           H  
ATOM    884  N   THR A  57       1.461   0.154  14.170  1.00  0.00           N  
ATOM    885  CA  THR A  57       0.263  -0.510  14.669  1.00  0.00           C  
ATOM    886  C   THR A  57      -0.569  -1.077  13.525  1.00  0.00           C  
ATOM    887  O   THR A  57      -1.286  -2.063  13.696  1.00  0.00           O  
ATOM    888  CB  THR A  57      -0.609   0.453  15.495  1.00  0.00           C  
ATOM    889  OG1 THR A  57      -1.439   1.232  14.625  1.00  0.00           O  
ATOM    890  CG2 THR A  57       0.255   1.378  16.340  1.00  0.00           C  
ATOM    891  H   THR A  57       1.397   1.075  13.841  1.00  0.00           H  
ATOM    892  HA  THR A  57       0.575  -1.321  15.311  1.00  0.00           H  
ATOM    893  HB  THR A  57      -1.237  -0.129  16.154  1.00  0.00           H  
ATOM    894  HG1 THR A  57      -0.925   1.522  13.868  1.00  0.00           H  
ATOM    895 HG21 THR A  57       1.047   0.807  16.803  1.00  0.00           H  
ATOM    896 HG22 THR A  57      -0.351   1.839  17.105  1.00  0.00           H  
ATOM    897 HG23 THR A  57       0.686   2.143  15.711  1.00  0.00           H  
ATOM    898  N   CYS A  58      -0.469  -0.448  12.359  1.00  0.00           N  
ATOM    899  CA  CYS A  58      -1.214  -0.890  11.186  1.00  0.00           C  
ATOM    900  C   CYS A  58      -0.602  -2.159  10.600  1.00  0.00           C  
ATOM    901  O   CYS A  58       0.551  -2.487  10.874  1.00  0.00           O  
ATOM    902  CB  CYS A  58      -1.240   0.213  10.127  1.00  0.00           C  
ATOM    903  SG  CYS A  58      -2.636   1.351  10.281  1.00  0.00           S  
ATOM    904  H   CYS A  58       0.119   0.333  12.285  1.00  0.00           H  
ATOM    905  HA  CYS A  58      -2.225  -1.104  11.497  1.00  0.00           H  
ATOM    906  HB2 CYS A  58      -0.333   0.794  10.201  1.00  0.00           H  
ATOM    907  HB3 CYS A  58      -1.290  -0.239   9.148  1.00  0.00           H  
ATOM    908  HG  CYS A  58      -2.380   2.179  11.283  1.00  0.00           H  
ATOM    909  N   GLN A  59      -1.385  -2.870   9.795  1.00  0.00           N  
ATOM    910  CA  GLN A  59      -0.921  -4.104   9.172  1.00  0.00           C  
ATOM    911  C   GLN A  59      -1.086  -4.047   7.658  1.00  0.00           C  
ATOM    912  O   GLN A  59      -2.204  -3.979   7.147  1.00  0.00           O  
ATOM    913  CB  GLN A  59      -1.686  -5.303   9.736  1.00  0.00           C  
ATOM    914  CG  GLN A  59      -0.924  -6.615   9.630  1.00  0.00           C  
ATOM    915  CD  GLN A  59      -1.276  -7.584  10.741  1.00  0.00           C  
ATOM    916  OE1 GLN A  59      -0.460  -7.858  11.623  1.00  0.00           O  
ATOM    917  NE2 GLN A  59      -2.494  -8.111  10.704  1.00  0.00           N  
ATOM    918  H   GLN A  59      -2.295  -2.557   9.614  1.00  0.00           H  
ATOM    919  HA  GLN A  59       0.128  -4.217   9.403  1.00  0.00           H  
ATOM    920  HB2 GLN A  59      -1.901  -5.120  10.778  1.00  0.00           H  
ATOM    921  HB3 GLN A  59      -2.616  -5.407   9.197  1.00  0.00           H  
ATOM    922  HG2 GLN A  59      -1.160  -7.077   8.683  1.00  0.00           H  
ATOM    923  HG3 GLN A  59       0.134  -6.406   9.675  1.00  0.00           H  
ATOM    924 HE21 GLN A  59      -3.091  -7.847   9.972  1.00  0.00           H  
ATOM    925 HE22 GLN A  59      -2.748  -8.741  11.410  1.00  0.00           H  
ATOM    926  N   VAL A  60       0.034  -4.073   6.943  1.00  0.00           N  
ATOM    927  CA  VAL A  60       0.014  -4.025   5.486  1.00  0.00           C  
ATOM    928  C   VAL A  60      -0.234  -5.407   4.894  1.00  0.00           C  
ATOM    929  O   VAL A  60       0.631  -6.282   4.948  1.00  0.00           O  
ATOM    930  CB  VAL A  60       1.334  -3.466   4.924  1.00  0.00           C  
ATOM    931  CG1 VAL A  60       1.279  -3.392   3.405  1.00  0.00           C  
ATOM    932  CG2 VAL A  60       1.631  -2.099   5.522  1.00  0.00           C  
ATOM    933  H   VAL A  60       0.895  -4.127   7.407  1.00  0.00           H  
ATOM    934  HA  VAL A  60      -0.789  -3.366   5.186  1.00  0.00           H  
ATOM    935  HB  VAL A  60       2.132  -4.138   5.200  1.00  0.00           H  
ATOM    936 HG11 VAL A  60       0.427  -3.952   3.049  1.00  0.00           H  
ATOM    937 HG12 VAL A  60       1.187  -2.360   3.099  1.00  0.00           H  
ATOM    938 HG13 VAL A  60       2.184  -3.811   2.992  1.00  0.00           H  
ATOM    939 HG21 VAL A  60       0.740  -1.711   5.994  1.00  0.00           H  
ATOM    940 HG22 VAL A  60       2.417  -2.191   6.259  1.00  0.00           H  
ATOM    941 HG23 VAL A  60       1.949  -1.425   4.741  1.00  0.00           H  
ATOM    942  N   LYS A  61      -1.420  -5.598   4.326  1.00  0.00           N  
ATOM    943  CA  LYS A  61      -1.782  -6.875   3.721  1.00  0.00           C  
ATOM    944  C   LYS A  61      -1.758  -6.781   2.199  1.00  0.00           C  
ATOM    945  O   LYS A  61      -2.759  -6.467   1.556  1.00  0.00           O  
ATOM    946  CB  LYS A  61      -3.171  -7.310   4.193  1.00  0.00           C  
ATOM    947  CG  LYS A  61      -3.311  -7.365   5.704  1.00  0.00           C  
ATOM    948  CD  LYS A  61      -2.165  -8.133   6.343  1.00  0.00           C  
ATOM    949  CE  LYS A  61      -2.602  -8.821   7.627  1.00  0.00           C  
ATOM    950  NZ  LYS A  61      -3.201 -10.158   7.364  1.00  0.00           N  
ATOM    951  H   LYS A  61      -2.067  -4.862   4.314  1.00  0.00           H  
ATOM    952  HA  LYS A  61      -1.058  -7.609   4.036  1.00  0.00           H  
ATOM    953  HB2 LYS A  61      -3.903  -6.614   3.810  1.00  0.00           H  
ATOM    954  HB3 LYS A  61      -3.381  -8.294   3.797  1.00  0.00           H  
ATOM    955  HG2 LYS A  61      -3.315  -6.358   6.094  1.00  0.00           H  
ATOM    956  HG3 LYS A  61      -4.242  -7.854   5.953  1.00  0.00           H  
ATOM    957  HD2 LYS A  61      -1.814  -8.882   5.649  1.00  0.00           H  
ATOM    958  HD3 LYS A  61      -1.363  -7.444   6.568  1.00  0.00           H  
ATOM    959  HE2 LYS A  61      -1.740  -8.941   8.266  1.00  0.00           H  
ATOM    960  HE3 LYS A  61      -3.333  -8.199   8.122  1.00  0.00           H  
ATOM    961  HZ1 LYS A  61      -3.560 -10.568   8.250  1.00  0.00           H  
ATOM    962  HZ2 LYS A  61      -2.485 -10.798   6.964  1.00  0.00           H  
ATOM    963  HZ3 LYS A  61      -3.988 -10.072   6.690  1.00  0.00           H  
ATOM    964  N   PRO A  62      -0.587  -7.062   1.607  1.00  0.00           N  
ATOM    965  CA  PRO A  62      -0.404  -7.017   0.153  1.00  0.00           C  
ATOM    966  C   PRO A  62      -1.146  -8.144  -0.559  1.00  0.00           C  
ATOM    967  O   PRO A  62      -1.017  -9.312  -0.194  1.00  0.00           O  
ATOM    968  CB  PRO A  62       1.108  -7.180  -0.020  1.00  0.00           C  
ATOM    969  CG  PRO A  62       1.553  -7.907   1.203  1.00  0.00           C  
ATOM    970  CD  PRO A  62       0.648  -7.443   2.311  1.00  0.00           C  
ATOM    971  HA  PRO A  62      -0.716  -6.068  -0.257  1.00  0.00           H  
ATOM    972  HB2 PRO A  62       1.311  -7.751  -0.915  1.00  0.00           H  
ATOM    973  HB3 PRO A  62       1.572  -6.209  -0.092  1.00  0.00           H  
ATOM    974  HG2 PRO A  62       1.451  -8.971   1.055  1.00  0.00           H  
ATOM    975  HG3 PRO A  62       2.578  -7.654   1.427  1.00  0.00           H  
ATOM    976  HD2 PRO A  62       0.462  -8.248   3.007  1.00  0.00           H  
ATOM    977  HD3 PRO A  62       1.080  -6.594   2.820  1.00  0.00           H  
ATOM    978  N   ASN A  63      -1.923  -7.786  -1.576  1.00  0.00           N  
ATOM    979  CA  ASN A  63      -2.685  -8.767  -2.339  1.00  0.00           C  
ATOM    980  C   ASN A  63      -1.876 -10.044  -2.544  1.00  0.00           C  
ATOM    981  O   ASN A  63      -0.648 -10.031  -2.470  1.00  0.00           O  
ATOM    982  CB  ASN A  63      -3.095  -8.185  -3.692  1.00  0.00           C  
ATOM    983  CG  ASN A  63      -1.903  -7.914  -4.590  1.00  0.00           C  
ATOM    984  OD1 ASN A  63      -1.577  -6.762  -4.876  1.00  0.00           O  
ATOM    985  ND2 ASN A  63      -1.247  -8.977  -5.039  1.00  0.00           N  
ATOM    986  H   ASN A  63      -1.985  -6.838  -1.819  1.00  0.00           H  
ATOM    987  HA  ASN A  63      -3.575  -9.006  -1.775  1.00  0.00           H  
ATOM    988  HB2 ASN A  63      -3.749  -8.884  -4.195  1.00  0.00           H  
ATOM    989  HB3 ASN A  63      -3.622  -7.256  -3.534  1.00  0.00           H  
ATOM    990 HD21 ASN A  63      -1.564  -9.866  -4.770  1.00  0.00           H  
ATOM    991 HD22 ASN A  63      -0.472  -8.832  -5.621  1.00  0.00           H  
ATOM    992  N   ALA A  64      -2.574 -11.144  -2.805  1.00  0.00           N  
ATOM    993  CA  ALA A  64      -1.920 -12.429  -3.025  1.00  0.00           C  
ATOM    994  C   ALA A  64      -1.679 -12.674  -4.510  1.00  0.00           C  
ATOM    995  O   ALA A  64      -0.614 -13.150  -4.905  1.00  0.00           O  
ATOM    996  CB  ALA A  64      -2.754 -13.554  -2.430  1.00  0.00           C  
ATOM    997  H   ALA A  64      -3.551 -11.091  -2.851  1.00  0.00           H  
ATOM    998  HA  ALA A  64      -0.967 -12.411  -2.514  1.00  0.00           H  
ATOM    999  HB1 ALA A  64      -3.714 -13.166  -2.124  1.00  0.00           H  
ATOM   1000  HB2 ALA A  64      -2.897 -14.326  -3.172  1.00  0.00           H  
ATOM   1001  HB3 ALA A  64      -2.242 -13.967  -1.575  1.00  0.00           H  
ATOM   1002  N   GLU A  65      -2.673 -12.348  -5.329  1.00  0.00           N  
ATOM   1003  CA  GLU A  65      -2.568 -12.536  -6.772  1.00  0.00           C  
ATOM   1004  C   GLU A  65      -2.774 -11.215  -7.508  1.00  0.00           C  
ATOM   1005  O   GLU A  65      -1.923 -10.787  -8.287  1.00  0.00           O  
ATOM   1006  CB  GLU A  65      -3.594 -13.565  -7.250  1.00  0.00           C  
ATOM   1007  CG  GLU A  65      -3.344 -14.966  -6.717  1.00  0.00           C  
ATOM   1008  CD  GLU A  65      -2.365 -15.749  -7.570  1.00  0.00           C  
ATOM   1009  OE1 GLU A  65      -1.143 -15.607  -7.350  1.00  0.00           O  
ATOM   1010  OE2 GLU A  65      -2.818 -16.502  -8.456  1.00  0.00           O  
ATOM   1011  H   GLU A  65      -3.498 -11.974  -4.955  1.00  0.00           H  
ATOM   1012  HA  GLU A  65      -1.576 -12.903  -6.986  1.00  0.00           H  
ATOM   1013  HB2 GLU A  65      -4.577 -13.251  -6.933  1.00  0.00           H  
ATOM   1014  HB3 GLU A  65      -3.569 -13.604  -8.329  1.00  0.00           H  
ATOM   1015  HG2 GLU A  65      -2.946 -14.892  -5.717  1.00  0.00           H  
ATOM   1016  HG3 GLU A  65      -4.283 -15.500  -6.692  1.00  0.00           H  
ATOM   1017  N   ASP A  66      -3.911 -10.576  -7.255  1.00  0.00           N  
ATOM   1018  CA  ASP A  66      -4.230  -9.303  -7.894  1.00  0.00           C  
ATOM   1019  C   ASP A  66      -3.136  -8.274  -7.632  1.00  0.00           C  
ATOM   1020  O   ASP A  66      -3.241  -7.459  -6.716  1.00  0.00           O  
ATOM   1021  CB  ASP A  66      -5.574  -8.778  -7.387  1.00  0.00           C  
ATOM   1022  CG  ASP A  66      -6.661  -9.834  -7.426  1.00  0.00           C  
ATOM   1023  OD1 ASP A  66      -6.784 -10.519  -8.462  1.00  0.00           O  
ATOM   1024  OD2 ASP A  66      -7.388  -9.974  -6.421  1.00  0.00           O  
ATOM   1025  H   ASP A  66      -4.550 -10.967  -6.625  1.00  0.00           H  
ATOM   1026  HA  ASP A  66      -4.299  -9.474  -8.958  1.00  0.00           H  
ATOM   1027  HB2 ASP A  66      -5.461  -8.442  -6.366  1.00  0.00           H  
ATOM   1028  HB3 ASP A  66      -5.883  -7.945  -8.003  1.00  0.00           H  
ATOM   1029  N   LYS A  67      -2.083  -8.318  -8.442  1.00  0.00           N  
ATOM   1030  CA  LYS A  67      -0.969  -7.390  -8.299  1.00  0.00           C  
ATOM   1031  C   LYS A  67      -1.465  -5.948  -8.236  1.00  0.00           C  
ATOM   1032  O   LYS A  67      -2.581  -5.647  -8.658  1.00  0.00           O  
ATOM   1033  CB  LYS A  67       0.011  -7.552  -9.464  1.00  0.00           C  
ATOM   1034  CG  LYS A  67       1.447  -7.219  -9.103  1.00  0.00           C  
ATOM   1035  CD  LYS A  67       2.099  -8.340  -8.311  1.00  0.00           C  
ATOM   1036  CE  LYS A  67       3.572  -8.059  -8.054  1.00  0.00           C  
ATOM   1037  NZ  LYS A  67       4.102  -8.870  -6.923  1.00  0.00           N  
ATOM   1038  H   LYS A  67      -2.056  -8.990  -9.155  1.00  0.00           H  
ATOM   1039  HA  LYS A  67      -0.458  -7.622  -7.376  1.00  0.00           H  
ATOM   1040  HB2 LYS A  67      -0.024  -8.577  -9.807  1.00  0.00           H  
ATOM   1041  HB3 LYS A  67      -0.296  -6.902 -10.270  1.00  0.00           H  
ATOM   1042  HG2 LYS A  67       2.010  -7.061 -10.010  1.00  0.00           H  
ATOM   1043  HG3 LYS A  67       1.459  -6.316  -8.508  1.00  0.00           H  
ATOM   1044  HD2 LYS A  67       1.593  -8.441  -7.362  1.00  0.00           H  
ATOM   1045  HD3 LYS A  67       2.008  -9.262  -8.868  1.00  0.00           H  
ATOM   1046  HE2 LYS A  67       4.130  -8.294  -8.948  1.00  0.00           H  
ATOM   1047  HE3 LYS A  67       3.689  -7.012  -7.821  1.00  0.00           H  
ATOM   1048  HZ1 LYS A  67       4.275  -8.262  -6.098  1.00  0.00           H  
ATOM   1049  HZ2 LYS A  67       4.996  -9.324  -7.198  1.00  0.00           H  
ATOM   1050  HZ3 LYS A  67       3.417  -9.607  -6.660  1.00  0.00           H  
ATOM   1051  N   LYS A  68      -0.626  -5.061  -7.710  1.00  0.00           N  
ATOM   1052  CA  LYS A  68      -0.978  -3.651  -7.594  1.00  0.00           C  
ATOM   1053  C   LYS A  68      -2.172  -3.462  -6.663  1.00  0.00           C  
ATOM   1054  O   LYS A  68      -3.141  -2.789  -7.010  1.00  0.00           O  
ATOM   1055  CB  LYS A  68      -1.297  -3.070  -8.973  1.00  0.00           C  
ATOM   1056  CG  LYS A  68      -0.083  -2.503  -9.689  1.00  0.00           C  
ATOM   1057  CD  LYS A  68      -0.367  -2.264 -11.163  1.00  0.00           C  
ATOM   1058  CE  LYS A  68      -1.369  -1.136 -11.362  1.00  0.00           C  
ATOM   1059  NZ  LYS A  68      -2.774  -1.617 -11.255  1.00  0.00           N  
ATOM   1060  H   LYS A  68       0.251  -5.363  -7.391  1.00  0.00           H  
ATOM   1061  HA  LYS A  68      -0.128  -3.130  -7.180  1.00  0.00           H  
ATOM   1062  HB2 LYS A  68      -1.723  -3.847  -9.589  1.00  0.00           H  
ATOM   1063  HB3 LYS A  68      -2.022  -2.276  -8.857  1.00  0.00           H  
ATOM   1064  HG2 LYS A  68       0.189  -1.565  -9.230  1.00  0.00           H  
ATOM   1065  HG3 LYS A  68       0.736  -3.202  -9.599  1.00  0.00           H  
ATOM   1066  HD2 LYS A  68       0.555  -2.003 -11.660  1.00  0.00           H  
ATOM   1067  HD3 LYS A  68      -0.768  -3.171 -11.595  1.00  0.00           H  
ATOM   1068  HE2 LYS A  68      -1.197  -0.383 -10.609  1.00  0.00           H  
ATOM   1069  HE3 LYS A  68      -1.217  -0.708 -12.342  1.00  0.00           H  
ATOM   1070  HZ1 LYS A  68      -3.383  -0.861 -10.882  1.00  0.00           H  
ATOM   1071  HZ2 LYS A  68      -2.824  -2.435 -10.614  1.00  0.00           H  
ATOM   1072  HZ3 LYS A  68      -3.127  -1.903 -12.191  1.00  0.00           H  
ATOM   1073  N   SER A  69      -2.092  -4.060  -5.478  1.00  0.00           N  
ATOM   1074  CA  SER A  69      -3.167  -3.959  -4.498  1.00  0.00           C  
ATOM   1075  C   SER A  69      -2.656  -4.282  -3.097  1.00  0.00           C  
ATOM   1076  O   SER A  69      -1.850  -5.193  -2.912  1.00  0.00           O  
ATOM   1077  CB  SER A  69      -4.311  -4.905  -4.865  1.00  0.00           C  
ATOM   1078  OG  SER A  69      -5.127  -4.348  -5.882  1.00  0.00           O  
ATOM   1079  H   SER A  69      -1.292  -4.584  -5.259  1.00  0.00           H  
ATOM   1080  HA  SER A  69      -3.532  -2.943  -4.510  1.00  0.00           H  
ATOM   1081  HB2 SER A  69      -3.903  -5.839  -5.220  1.00  0.00           H  
ATOM   1082  HB3 SER A  69      -4.920  -5.086  -3.991  1.00  0.00           H  
ATOM   1083  HG  SER A  69      -4.615  -3.717  -6.393  1.00  0.00           H  
ATOM   1084  N   PHE A  70      -3.131  -3.525  -2.112  1.00  0.00           N  
ATOM   1085  CA  PHE A  70      -2.722  -3.728  -0.727  1.00  0.00           C  
ATOM   1086  C   PHE A  70      -3.737  -3.115   0.234  1.00  0.00           C  
ATOM   1087  O   PHE A  70      -4.252  -2.023  -0.003  1.00  0.00           O  
ATOM   1088  CB  PHE A  70      -1.340  -3.119  -0.486  1.00  0.00           C  
ATOM   1089  CG  PHE A  70      -1.366  -1.627  -0.312  1.00  0.00           C  
ATOM   1090  CD1 PHE A  70      -1.664  -1.064   0.918  1.00  0.00           C  
ATOM   1091  CD2 PHE A  70      -1.091  -0.787  -1.380  1.00  0.00           C  
ATOM   1092  CE1 PHE A  70      -1.688   0.308   1.081  1.00  0.00           C  
ATOM   1093  CE2 PHE A  70      -1.113   0.586  -1.223  1.00  0.00           C  
ATOM   1094  CZ  PHE A  70      -1.412   1.135   0.009  1.00  0.00           C  
ATOM   1095  H   PHE A  70      -3.771  -2.813  -2.322  1.00  0.00           H  
ATOM   1096  HA  PHE A  70      -2.674  -4.792  -0.549  1.00  0.00           H  
ATOM   1097  HB2 PHE A  70      -0.916  -3.549   0.409  1.00  0.00           H  
ATOM   1098  HB3 PHE A  70      -0.703  -3.346  -1.327  1.00  0.00           H  
ATOM   1099  HD1 PHE A  70      -1.879  -1.709   1.758  1.00  0.00           H  
ATOM   1100  HD2 PHE A  70      -0.857  -1.214  -2.344  1.00  0.00           H  
ATOM   1101  HE1 PHE A  70      -1.922   0.734   2.044  1.00  0.00           H  
ATOM   1102  HE2 PHE A  70      -0.896   1.230  -2.064  1.00  0.00           H  
ATOM   1103  HZ  PHE A  70      -1.430   2.207   0.132  1.00  0.00           H  
ATOM   1104  N   ASP A  71      -4.019  -3.827   1.320  1.00  0.00           N  
ATOM   1105  CA  ASP A  71      -4.970  -3.353   2.319  1.00  0.00           C  
ATOM   1106  C   ASP A  71      -4.252  -2.936   3.598  1.00  0.00           C  
ATOM   1107  O   ASP A  71      -3.385  -3.653   4.098  1.00  0.00           O  
ATOM   1108  CB  ASP A  71      -6.000  -4.441   2.629  1.00  0.00           C  
ATOM   1109  CG  ASP A  71      -7.121  -4.484   1.610  1.00  0.00           C  
ATOM   1110  OD1 ASP A  71      -7.388  -3.442   0.977  1.00  0.00           O  
ATOM   1111  OD2 ASP A  71      -7.732  -5.562   1.444  1.00  0.00           O  
ATOM   1112  H   ASP A  71      -3.575  -4.691   1.454  1.00  0.00           H  
ATOM   1113  HA  ASP A  71      -5.480  -2.495   1.910  1.00  0.00           H  
ATOM   1114  HB2 ASP A  71      -5.507  -5.403   2.636  1.00  0.00           H  
ATOM   1115  HB3 ASP A  71      -6.429  -4.255   3.603  1.00  0.00           H  
ATOM   1116  N   LEU A  72      -4.618  -1.771   4.123  1.00  0.00           N  
ATOM   1117  CA  LEU A  72      -4.009  -1.257   5.344  1.00  0.00           C  
ATOM   1118  C   LEU A  72      -4.949  -1.421   6.534  1.00  0.00           C  
ATOM   1119  O   LEU A  72      -5.944  -0.706   6.655  1.00  0.00           O  
ATOM   1120  CB  LEU A  72      -3.642   0.218   5.172  1.00  0.00           C  
ATOM   1121  CG  LEU A  72      -2.567   0.757   6.117  1.00  0.00           C  
ATOM   1122  CD1 LEU A  72      -1.275  -0.029   5.962  1.00  0.00           C  
ATOM   1123  CD2 LEU A  72      -2.327   2.239   5.863  1.00  0.00           C  
ATOM   1124  H   LEU A  72      -5.315  -1.244   3.679  1.00  0.00           H  
ATOM   1125  HA  LEU A  72      -3.109  -1.824   5.530  1.00  0.00           H  
ATOM   1126  HB2 LEU A  72      -3.290   0.355   4.160  1.00  0.00           H  
ATOM   1127  HB3 LEU A  72      -4.538   0.802   5.320  1.00  0.00           H  
ATOM   1128  HG  LEU A  72      -2.906   0.644   7.138  1.00  0.00           H  
ATOM   1129 HD11 LEU A  72      -0.469   0.648   5.720  1.00  0.00           H  
ATOM   1130 HD12 LEU A  72      -1.387  -0.753   5.169  1.00  0.00           H  
ATOM   1131 HD13 LEU A  72      -1.051  -0.540   6.887  1.00  0.00           H  
ATOM   1132 HD21 LEU A  72      -3.145   2.811   6.276  1.00  0.00           H  
ATOM   1133 HD22 LEU A  72      -2.265   2.415   4.799  1.00  0.00           H  
ATOM   1134 HD23 LEU A  72      -1.404   2.539   6.334  1.00  0.00           H  
ATOM   1135  N   ILE A  73      -4.627  -2.368   7.409  1.00  0.00           N  
ATOM   1136  CA  ILE A  73      -5.442  -2.625   8.590  1.00  0.00           C  
ATOM   1137  C   ILE A  73      -5.027  -1.726   9.750  1.00  0.00           C  
ATOM   1138  O   ILE A  73      -3.899  -1.806  10.239  1.00  0.00           O  
ATOM   1139  CB  ILE A  73      -5.341  -4.096   9.035  1.00  0.00           C  
ATOM   1140  CG1 ILE A  73      -5.904  -5.018   7.952  1.00  0.00           C  
ATOM   1141  CG2 ILE A  73      -6.076  -4.303  10.350  1.00  0.00           C  
ATOM   1142  CD1 ILE A  73      -5.262  -6.388   7.930  1.00  0.00           C  
ATOM   1143  H   ILE A  73      -3.823  -2.906   7.257  1.00  0.00           H  
ATOM   1144  HA  ILE A  73      -6.471  -2.416   8.336  1.00  0.00           H  
ATOM   1145  HB  ILE A  73      -4.299  -4.331   9.192  1.00  0.00           H  
ATOM   1146 HG12 ILE A  73      -6.962  -5.152   8.115  1.00  0.00           H  
ATOM   1147 HG13 ILE A  73      -5.747  -4.563   6.985  1.00  0.00           H  
ATOM   1148 HG21 ILE A  73      -5.408  -4.755  11.069  1.00  0.00           H  
ATOM   1149 HG22 ILE A  73      -6.417  -3.351  10.725  1.00  0.00           H  
ATOM   1150 HG23 ILE A  73      -6.924  -4.952  10.190  1.00  0.00           H  
ATOM   1151 HD11 ILE A  73      -5.613  -6.938   7.070  1.00  0.00           H  
ATOM   1152 HD12 ILE A  73      -4.189  -6.283   7.879  1.00  0.00           H  
ATOM   1153 HD13 ILE A  73      -5.527  -6.924   8.832  1.00  0.00           H  
ATOM   1154  N   SER A  74      -5.946  -0.871  10.186  1.00  0.00           N  
ATOM   1155  CA  SER A  74      -5.675   0.046  11.288  1.00  0.00           C  
ATOM   1156  C   SER A  74      -6.396  -0.402  12.556  1.00  0.00           C  
ATOM   1157  O   SER A  74      -7.234  -1.303  12.523  1.00  0.00           O  
ATOM   1158  CB  SER A  74      -6.108   1.465  10.915  1.00  0.00           C  
ATOM   1159  OG  SER A  74      -5.431   2.428  11.705  1.00  0.00           O  
ATOM   1160  H   SER A  74      -6.826  -0.854   9.756  1.00  0.00           H  
ATOM   1161  HA  SER A  74      -4.611   0.039  11.471  1.00  0.00           H  
ATOM   1162  HB2 SER A  74      -5.883   1.647   9.876  1.00  0.00           H  
ATOM   1163  HB3 SER A  74      -7.172   1.568  11.077  1.00  0.00           H  
ATOM   1164  HG  SER A  74      -4.615   2.051  12.040  1.00  0.00           H  
ATOM   1165  N   HIS A  75      -6.062   0.235  13.675  1.00  0.00           N  
ATOM   1166  CA  HIS A  75      -6.677  -0.096  14.955  1.00  0.00           C  
ATOM   1167  C   HIS A  75      -8.192  -0.202  14.819  1.00  0.00           C  
ATOM   1168  O   HIS A  75      -8.883   0.803  14.662  1.00  0.00           O  
ATOM   1169  CB  HIS A  75      -6.320   0.957  16.003  1.00  0.00           C  
ATOM   1170  CG  HIS A  75      -6.262   0.418  17.399  1.00  0.00           C  
ATOM   1171  ND1 HIS A  75      -5.110  -0.080  17.967  1.00  0.00           N  
ATOM   1172  CD2 HIS A  75      -7.225   0.302  18.344  1.00  0.00           C  
ATOM   1173  CE1 HIS A  75      -5.365  -0.481  19.199  1.00  0.00           C  
ATOM   1174  NE2 HIS A  75      -6.642  -0.259  19.453  1.00  0.00           N  
ATOM   1175  H   HIS A  75      -5.387   0.944  13.637  1.00  0.00           H  
ATOM   1176  HA  HIS A  75      -6.288  -1.052  15.271  1.00  0.00           H  
ATOM   1177  HB2 HIS A  75      -5.351   1.375  15.769  1.00  0.00           H  
ATOM   1178  HB3 HIS A  75      -7.060   1.745  15.981  1.00  0.00           H  
ATOM   1179  HD1 HIS A  75      -4.233  -0.134  17.531  1.00  0.00           H  
ATOM   1180  HD2 HIS A  75      -8.261   0.597  18.244  1.00  0.00           H  
ATOM   1181  HE1 HIS A  75      -4.651  -0.916  19.884  1.00  0.00           H  
ATOM   1182  HE2 HIS A  75      -7.114  -0.542  20.264  1.00  0.00           H  
ATOM   1183  N   ASN A  76      -8.703  -1.429  14.879  1.00  0.00           N  
ATOM   1184  CA  ASN A  76     -10.137  -1.666  14.762  1.00  0.00           C  
ATOM   1185  C   ASN A  76     -10.704  -0.969  13.529  1.00  0.00           C  
ATOM   1186  O   ASN A  76     -11.819  -0.447  13.555  1.00  0.00           O  
ATOM   1187  CB  ASN A  76     -10.861  -1.175  16.016  1.00  0.00           C  
ATOM   1188  CG  ASN A  76     -10.681  -2.116  17.192  1.00  0.00           C  
ATOM   1189  OD1 ASN A  76     -10.064  -3.174  17.066  1.00  0.00           O  
ATOM   1190  ND2 ASN A  76     -11.220  -1.733  18.344  1.00  0.00           N  
ATOM   1191  H   ASN A  76      -8.101  -2.192  15.005  1.00  0.00           H  
ATOM   1192  HA  ASN A  76     -10.289  -2.730  14.661  1.00  0.00           H  
ATOM   1193  HB2 ASN A  76     -10.473  -0.205  16.293  1.00  0.00           H  
ATOM   1194  HB3 ASN A  76     -11.917  -1.089  15.806  1.00  0.00           H  
ATOM   1195 HD21 ASN A  76     -11.698  -0.877  18.370  1.00  0.00           H  
ATOM   1196 HD22 ASN A  76     -11.118  -2.322  19.121  1.00  0.00           H  
ATOM   1197  N   ARG A  77      -9.928  -0.964  12.449  1.00  0.00           N  
ATOM   1198  CA  ARG A  77     -10.353  -0.331  11.206  1.00  0.00           C  
ATOM   1199  C   ARG A  77      -9.632  -0.944  10.009  1.00  0.00           C  
ATOM   1200  O   ARG A  77      -8.508  -1.433  10.132  1.00  0.00           O  
ATOM   1201  CB  ARG A  77     -10.088   1.175  11.259  1.00  0.00           C  
ATOM   1202  CG  ARG A  77     -11.194   1.964  11.940  1.00  0.00           C  
ATOM   1203  CD  ARG A  77     -10.932   3.461  11.873  1.00  0.00           C  
ATOM   1204  NE  ARG A  77     -12.141   4.240  12.130  1.00  0.00           N  
ATOM   1205  CZ  ARG A  77     -12.146   5.561  12.273  1.00  0.00           C  
ATOM   1206  NH1 ARG A  77     -11.015   6.245  12.185  1.00  0.00           N  
ATOM   1207  NH2 ARG A  77     -13.286   6.199  12.504  1.00  0.00           N  
ATOM   1208  H   ARG A  77      -9.050  -1.396  12.489  1.00  0.00           H  
ATOM   1209  HA  ARG A  77     -11.415  -0.496  11.095  1.00  0.00           H  
ATOM   1210  HB2 ARG A  77      -9.168   1.347  11.799  1.00  0.00           H  
ATOM   1211  HB3 ARG A  77      -9.979   1.545  10.251  1.00  0.00           H  
ATOM   1212  HG2 ARG A  77     -12.132   1.753  11.446  1.00  0.00           H  
ATOM   1213  HG3 ARG A  77     -11.255   1.663  12.975  1.00  0.00           H  
ATOM   1214  HD2 ARG A  77     -10.188   3.716  12.613  1.00  0.00           H  
ATOM   1215  HD3 ARG A  77     -10.559   3.704  10.890  1.00  0.00           H  
ATOM   1216  HE  ARG A  77     -12.988   3.754  12.198  1.00  0.00           H  
ATOM   1217 HH11 ARG A  77     -10.154   5.767  12.011  1.00  0.00           H  
ATOM   1218 HH12 ARG A  77     -11.023   7.241  12.292  1.00  0.00           H  
ATOM   1219 HH21 ARG A  77     -14.142   5.686  12.570  1.00  0.00           H  
ATOM   1220 HH22 ARG A  77     -13.290   7.192  12.611  1.00  0.00           H  
ATOM   1221  N   THR A  78     -10.284  -0.912   8.851  1.00  0.00           N  
ATOM   1222  CA  THR A  78      -9.706  -1.466   7.633  1.00  0.00           C  
ATOM   1223  C   THR A  78      -9.781  -0.466   6.486  1.00  0.00           C  
ATOM   1224  O   THR A  78     -10.841   0.098   6.209  1.00  0.00           O  
ATOM   1225  CB  THR A  78     -10.417  -2.766   7.214  1.00  0.00           C  
ATOM   1226  OG1 THR A  78     -10.599  -3.615   8.353  1.00  0.00           O  
ATOM   1227  CG2 THR A  78      -9.618  -3.501   6.149  1.00  0.00           C  
ATOM   1228  H   THR A  78     -11.176  -0.508   8.817  1.00  0.00           H  
ATOM   1229  HA  THR A  78      -8.669  -1.695   7.830  1.00  0.00           H  
ATOM   1230  HB  THR A  78     -11.385  -2.513   6.806  1.00  0.00           H  
ATOM   1231  HG1 THR A  78      -9.743  -3.823   8.737  1.00  0.00           H  
ATOM   1232 HG21 THR A  78      -9.248  -4.431   6.555  1.00  0.00           H  
ATOM   1233 HG22 THR A  78      -8.786  -2.888   5.836  1.00  0.00           H  
ATOM   1234 HG23 THR A  78     -10.253  -3.707   5.302  1.00  0.00           H  
ATOM   1235  N   TYR A  79      -8.653  -0.249   5.821  1.00  0.00           N  
ATOM   1236  CA  TYR A  79      -8.591   0.685   4.703  1.00  0.00           C  
ATOM   1237  C   TYR A  79      -8.334  -0.050   3.392  1.00  0.00           C  
ATOM   1238  O   TYR A  79      -7.915  -1.209   3.387  1.00  0.00           O  
ATOM   1239  CB  TYR A  79      -7.496   1.726   4.941  1.00  0.00           C  
ATOM   1240  CG  TYR A  79      -7.864   2.767   5.974  1.00  0.00           C  
ATOM   1241  CD1 TYR A  79      -8.065   2.414   7.303  1.00  0.00           C  
ATOM   1242  CD2 TYR A  79      -8.010   4.102   5.620  1.00  0.00           C  
ATOM   1243  CE1 TYR A  79      -8.402   3.362   8.249  1.00  0.00           C  
ATOM   1244  CE2 TYR A  79      -8.346   5.057   6.561  1.00  0.00           C  
ATOM   1245  CZ  TYR A  79      -8.540   4.682   7.875  1.00  0.00           C  
ATOM   1246  OH  TYR A  79      -8.876   5.629   8.815  1.00  0.00           O  
ATOM   1247  H   TYR A  79      -7.840  -0.728   6.088  1.00  0.00           H  
ATOM   1248  HA  TYR A  79      -9.544   1.188   4.638  1.00  0.00           H  
ATOM   1249  HB2 TYR A  79      -6.601   1.226   5.278  1.00  0.00           H  
ATOM   1250  HB3 TYR A  79      -7.288   2.238   4.012  1.00  0.00           H  
ATOM   1251  HD1 TYR A  79      -7.956   1.380   7.593  1.00  0.00           H  
ATOM   1252  HD2 TYR A  79      -7.858   4.394   4.592  1.00  0.00           H  
ATOM   1253  HE1 TYR A  79      -8.554   3.069   9.278  1.00  0.00           H  
ATOM   1254  HE2 TYR A  79      -8.455   6.091   6.268  1.00  0.00           H  
ATOM   1255  HH  TYR A  79      -8.119   6.196   8.982  1.00  0.00           H  
ATOM   1256  N   HIS A  80      -8.585   0.632   2.278  1.00  0.00           N  
ATOM   1257  CA  HIS A  80      -8.380   0.044   0.959  1.00  0.00           C  
ATOM   1258  C   HIS A  80      -7.511   0.950   0.090  1.00  0.00           C  
ATOM   1259  O   HIS A  80      -7.881   2.088  -0.199  1.00  0.00           O  
ATOM   1260  CB  HIS A  80      -9.723  -0.204   0.273  1.00  0.00           C  
ATOM   1261  CG  HIS A  80     -10.612  -1.151   1.020  1.00  0.00           C  
ATOM   1262  ND1 HIS A  80     -10.211  -2.414   1.404  1.00  0.00           N  
ATOM   1263  CD2 HIS A  80     -11.886  -1.013   1.455  1.00  0.00           C  
ATOM   1264  CE1 HIS A  80     -11.201  -3.012   2.042  1.00  0.00           C  
ATOM   1265  NE2 HIS A  80     -12.229  -2.183   2.087  1.00  0.00           N  
ATOM   1266  H   HIS A  80      -8.917   1.550   2.346  1.00  0.00           H  
ATOM   1267  HA  HIS A  80      -7.873  -0.900   1.091  1.00  0.00           H  
ATOM   1268  HB2 HIS A  80     -10.249   0.734   0.175  1.00  0.00           H  
ATOM   1269  HB3 HIS A  80      -9.548  -0.618  -0.710  1.00  0.00           H  
ATOM   1270  HD1 HIS A  80      -9.333  -2.812   1.233  1.00  0.00           H  
ATOM   1271  HD2 HIS A  80     -12.515  -0.144   1.330  1.00  0.00           H  
ATOM   1272  HE1 HIS A  80     -11.175  -4.008   2.457  1.00  0.00           H  
ATOM   1273  HE2 HIS A  80     -13.119  -2.407   2.427  1.00  0.00           H  
ATOM   1274  N   PHE A  81      -6.357   0.438  -0.322  1.00  0.00           N  
ATOM   1275  CA  PHE A  81      -5.435   1.201  -1.155  1.00  0.00           C  
ATOM   1276  C   PHE A  81      -5.125   0.452  -2.448  1.00  0.00           C  
ATOM   1277  O   PHE A  81      -5.279  -0.766  -2.524  1.00  0.00           O  
ATOM   1278  CB  PHE A  81      -4.140   1.484  -0.392  1.00  0.00           C  
ATOM   1279  CG  PHE A  81      -4.298   2.498   0.704  1.00  0.00           C  
ATOM   1280  CD1 PHE A  81      -4.398   3.849   0.408  1.00  0.00           C  
ATOM   1281  CD2 PHE A  81      -4.349   2.102   2.031  1.00  0.00           C  
ATOM   1282  CE1 PHE A  81      -4.544   4.783   1.415  1.00  0.00           C  
ATOM   1283  CE2 PHE A  81      -4.496   3.033   3.042  1.00  0.00           C  
ATOM   1284  CZ  PHE A  81      -4.594   4.376   2.733  1.00  0.00           C  
ATOM   1285  H   PHE A  81      -6.118  -0.476  -0.057  1.00  0.00           H  
ATOM   1286  HA  PHE A  81      -5.911   2.138  -1.401  1.00  0.00           H  
ATOM   1287  HB2 PHE A  81      -3.785   0.567   0.054  1.00  0.00           H  
ATOM   1288  HB3 PHE A  81      -3.397   1.854  -1.084  1.00  0.00           H  
ATOM   1289  HD1 PHE A  81      -4.360   4.169  -0.623  1.00  0.00           H  
ATOM   1290  HD2 PHE A  81      -4.273   1.051   2.273  1.00  0.00           H  
ATOM   1291  HE1 PHE A  81      -4.621   5.833   1.171  1.00  0.00           H  
ATOM   1292  HE2 PHE A  81      -4.534   2.710   4.072  1.00  0.00           H  
ATOM   1293  HZ  PHE A  81      -4.708   5.104   3.522  1.00  0.00           H  
ATOM   1294  N   GLN A  82      -4.685   1.191  -3.462  1.00  0.00           N  
ATOM   1295  CA  GLN A  82      -4.354   0.598  -4.752  1.00  0.00           C  
ATOM   1296  C   GLN A  82      -3.285   1.417  -5.469  1.00  0.00           C  
ATOM   1297  O   GLN A  82      -3.385   2.639  -5.560  1.00  0.00           O  
ATOM   1298  CB  GLN A  82      -5.606   0.494  -5.625  1.00  0.00           C  
ATOM   1299  CG  GLN A  82      -5.467  -0.496  -6.771  1.00  0.00           C  
ATOM   1300  CD  GLN A  82      -6.572  -0.356  -7.799  1.00  0.00           C  
ATOM   1301  OE1 GLN A  82      -6.355   0.162  -8.894  1.00  0.00           O  
ATOM   1302  NE2 GLN A  82      -7.767  -0.821  -7.451  1.00  0.00           N  
ATOM   1303  H   GLN A  82      -4.583   2.158  -3.339  1.00  0.00           H  
ATOM   1304  HA  GLN A  82      -3.969  -0.394  -4.571  1.00  0.00           H  
ATOM   1305  HB2 GLN A  82      -6.436   0.184  -5.008  1.00  0.00           H  
ATOM   1306  HB3 GLN A  82      -5.820   1.467  -6.043  1.00  0.00           H  
ATOM   1307  HG2 GLN A  82      -4.519  -0.330  -7.260  1.00  0.00           H  
ATOM   1308  HG3 GLN A  82      -5.494  -1.498  -6.369  1.00  0.00           H  
ATOM   1309 HE21 GLN A  82      -7.866  -1.221  -6.561  1.00  0.00           H  
ATOM   1310 HE22 GLN A  82      -8.499  -0.744  -8.096  1.00  0.00           H  
ATOM   1311  N   ALA A  83      -2.265   0.733  -5.975  1.00  0.00           N  
ATOM   1312  CA  ALA A  83      -1.179   1.396  -6.685  1.00  0.00           C  
ATOM   1313  C   ALA A  83      -1.608   1.801  -8.092  1.00  0.00           C  
ATOM   1314  O   ALA A  83      -2.676   1.408  -8.561  1.00  0.00           O  
ATOM   1315  CB  ALA A  83       0.044   0.492  -6.745  1.00  0.00           C  
ATOM   1316  H   ALA A  83      -2.242  -0.242  -5.870  1.00  0.00           H  
ATOM   1317  HA  ALA A  83      -0.912   2.285  -6.132  1.00  0.00           H  
ATOM   1318  HB1 ALA A  83       0.861   1.023  -7.211  1.00  0.00           H  
ATOM   1319  HB2 ALA A  83       0.326   0.203  -5.743  1.00  0.00           H  
ATOM   1320  HB3 ALA A  83      -0.189  -0.390  -7.322  1.00  0.00           H  
ATOM   1321  N   GLU A  84      -0.770   2.588  -8.758  1.00  0.00           N  
ATOM   1322  CA  GLU A  84      -1.066   3.046 -10.111  1.00  0.00           C  
ATOM   1323  C   GLU A  84      -0.418   2.134 -11.148  1.00  0.00           C  
ATOM   1324  O   GLU A  84      -1.001   1.856 -12.197  1.00  0.00           O  
ATOM   1325  CB  GLU A  84      -0.578   4.484 -10.305  1.00  0.00           C  
ATOM   1326  CG  GLU A  84      -1.596   5.533  -9.887  1.00  0.00           C  
ATOM   1327  CD  GLU A  84      -2.847   5.504 -10.743  1.00  0.00           C  
ATOM   1328  OE1 GLU A  84      -2.814   4.878 -11.823  1.00  0.00           O  
ATOM   1329  OE2 GLU A  84      -3.860   6.109 -10.332  1.00  0.00           O  
ATOM   1330  H   GLU A  84       0.066   2.868  -8.331  1.00  0.00           H  
ATOM   1331  HA  GLU A  84      -2.137   3.018 -10.244  1.00  0.00           H  
ATOM   1332  HB2 GLU A  84       0.318   4.629  -9.721  1.00  0.00           H  
ATOM   1333  HB3 GLU A  84      -0.345   4.634 -11.349  1.00  0.00           H  
ATOM   1334  HG2 GLU A  84      -1.877   5.355  -8.860  1.00  0.00           H  
ATOM   1335  HG3 GLU A  84      -1.142   6.509  -9.971  1.00  0.00           H  
ATOM   1336  N   ASP A  85       0.790   1.671 -10.848  1.00  0.00           N  
ATOM   1337  CA  ASP A  85       1.519   0.789 -11.753  1.00  0.00           C  
ATOM   1338  C   ASP A  85       2.156  -0.367 -10.989  1.00  0.00           C  
ATOM   1339  O   ASP A  85       2.134  -0.397  -9.759  1.00  0.00           O  
ATOM   1340  CB  ASP A  85       2.594   1.574 -12.507  1.00  0.00           C  
ATOM   1341  CG  ASP A  85       3.215   0.769 -13.632  1.00  0.00           C  
ATOM   1342  OD1 ASP A  85       2.504  -0.070 -14.224  1.00  0.00           O  
ATOM   1343  OD2 ASP A  85       4.412   0.977 -13.920  1.00  0.00           O  
ATOM   1344  H   ASP A  85       1.202   1.928  -9.996  1.00  0.00           H  
ATOM   1345  HA  ASP A  85       0.813   0.389 -12.465  1.00  0.00           H  
ATOM   1346  HB2 ASP A  85       2.152   2.465 -12.928  1.00  0.00           H  
ATOM   1347  HB3 ASP A  85       3.375   1.855 -11.816  1.00  0.00           H  
ATOM   1348  N   GLU A  86       2.722  -1.317 -11.728  1.00  0.00           N  
ATOM   1349  CA  GLU A  86       3.363  -2.477 -11.119  1.00  0.00           C  
ATOM   1350  C   GLU A  86       4.626  -2.067 -10.368  1.00  0.00           C  
ATOM   1351  O   GLU A  86       4.902  -2.570  -9.278  1.00  0.00           O  
ATOM   1352  CB  GLU A  86       3.707  -3.516 -12.188  1.00  0.00           C  
ATOM   1353  CG  GLU A  86       3.730  -4.942 -11.664  1.00  0.00           C  
ATOM   1354  CD  GLU A  86       4.535  -5.875 -12.548  1.00  0.00           C  
ATOM   1355  OE1 GLU A  86       5.761  -5.980 -12.337  1.00  0.00           O  
ATOM   1356  OE2 GLU A  86       3.939  -6.500 -13.450  1.00  0.00           O  
ATOM   1357  H   GLU A  86       2.707  -1.236 -12.705  1.00  0.00           H  
ATOM   1358  HA  GLU A  86       2.666  -2.911 -10.419  1.00  0.00           H  
ATOM   1359  HB2 GLU A  86       2.974  -3.457 -12.980  1.00  0.00           H  
ATOM   1360  HB3 GLU A  86       4.681  -3.289 -12.594  1.00  0.00           H  
ATOM   1361  HG2 GLU A  86       4.166  -4.943 -10.676  1.00  0.00           H  
ATOM   1362  HG3 GLU A  86       2.715  -5.309 -11.609  1.00  0.00           H  
ATOM   1363  N   GLN A  87       5.389  -1.152 -10.958  1.00  0.00           N  
ATOM   1364  CA  GLN A  87       6.623  -0.677 -10.344  1.00  0.00           C  
ATOM   1365  C   GLN A  87       6.331   0.110  -9.071  1.00  0.00           C  
ATOM   1366  O   GLN A  87       7.036  -0.023  -8.071  1.00  0.00           O  
ATOM   1367  CB  GLN A  87       7.404   0.195 -11.329  1.00  0.00           C  
ATOM   1368  CG  GLN A  87       8.071  -0.594 -12.443  1.00  0.00           C  
ATOM   1369  CD  GLN A  87       8.630   0.297 -13.536  1.00  0.00           C  
ATOM   1370  OE1 GLN A  87       9.692   0.899 -13.379  1.00  0.00           O  
ATOM   1371  NE2 GLN A  87       7.914   0.386 -14.651  1.00  0.00           N  
ATOM   1372  H   GLN A  87       5.116  -0.790 -11.825  1.00  0.00           H  
ATOM   1373  HA  GLN A  87       7.221  -1.539 -10.090  1.00  0.00           H  
ATOM   1374  HB2 GLN A  87       6.726   0.907 -11.776  1.00  0.00           H  
ATOM   1375  HB3 GLN A  87       8.171   0.730 -10.788  1.00  0.00           H  
ATOM   1376  HG2 GLN A  87       8.881  -1.172 -12.023  1.00  0.00           H  
ATOM   1377  HG3 GLN A  87       7.343  -1.261 -12.881  1.00  0.00           H  
ATOM   1378 HE21 GLN A  87       7.076  -0.121 -14.705  1.00  0.00           H  
ATOM   1379 HE22 GLN A  87       8.251   0.956 -15.373  1.00  0.00           H  
ATOM   1380  N   ASP A  88       5.287   0.930  -9.115  1.00  0.00           N  
ATOM   1381  CA  ASP A  88       4.900   1.739  -7.965  1.00  0.00           C  
ATOM   1382  C   ASP A  88       4.488   0.854  -6.793  1.00  0.00           C  
ATOM   1383  O   ASP A  88       4.874   1.101  -5.650  1.00  0.00           O  
ATOM   1384  CB  ASP A  88       3.753   2.679  -8.339  1.00  0.00           C  
ATOM   1385  CG  ASP A  88       3.678   3.890  -7.429  1.00  0.00           C  
ATOM   1386  OD1 ASP A  88       4.745   4.427  -7.068  1.00  0.00           O  
ATOM   1387  OD2 ASP A  88       2.551   4.300  -7.078  1.00  0.00           O  
ATOM   1388  H   ASP A  88       4.763   0.993  -9.942  1.00  0.00           H  
ATOM   1389  HA  ASP A  88       5.755   2.328  -7.672  1.00  0.00           H  
ATOM   1390  HB2 ASP A  88       3.892   3.022  -9.353  1.00  0.00           H  
ATOM   1391  HB3 ASP A  88       2.818   2.141  -8.269  1.00  0.00           H  
ATOM   1392  N   TYR A  89       3.701  -0.176  -7.084  1.00  0.00           N  
ATOM   1393  CA  TYR A  89       3.234  -1.096  -6.053  1.00  0.00           C  
ATOM   1394  C   TYR A  89       4.407  -1.811  -5.388  1.00  0.00           C  
ATOM   1395  O   TYR A  89       4.656  -1.639  -4.195  1.00  0.00           O  
ATOM   1396  CB  TYR A  89       2.271  -2.123  -6.654  1.00  0.00           C  
ATOM   1397  CG  TYR A  89       2.001  -3.302  -5.748  1.00  0.00           C  
ATOM   1398  CD1 TYR A  89       1.078  -3.211  -4.714  1.00  0.00           C  
ATOM   1399  CD2 TYR A  89       2.670  -4.508  -5.925  1.00  0.00           C  
ATOM   1400  CE1 TYR A  89       0.827  -4.286  -3.883  1.00  0.00           C  
ATOM   1401  CE2 TYR A  89       2.424  -5.587  -5.100  1.00  0.00           C  
ATOM   1402  CZ  TYR A  89       1.503  -5.472  -4.081  1.00  0.00           C  
ATOM   1403  OH  TYR A  89       1.257  -6.546  -3.256  1.00  0.00           O  
ATOM   1404  H   TYR A  89       3.428  -0.321  -8.013  1.00  0.00           H  
ATOM   1405  HA  TYR A  89       2.708  -0.518  -5.307  1.00  0.00           H  
ATOM   1406  HB2 TYR A  89       1.329  -1.642  -6.864  1.00  0.00           H  
ATOM   1407  HB3 TYR A  89       2.690  -2.501  -7.577  1.00  0.00           H  
ATOM   1408  HD1 TYR A  89       0.550  -2.280  -4.563  1.00  0.00           H  
ATOM   1409  HD2 TYR A  89       3.391  -4.594  -6.724  1.00  0.00           H  
ATOM   1410  HE1 TYR A  89       0.105  -4.196  -3.085  1.00  0.00           H  
ATOM   1411  HE2 TYR A  89       2.954  -6.517  -5.254  1.00  0.00           H  
ATOM   1412  HH  TYR A  89       0.313  -6.617  -3.096  1.00  0.00           H  
ATOM   1413  N   VAL A  90       5.123  -2.611  -6.169  1.00  0.00           N  
ATOM   1414  CA  VAL A  90       6.271  -3.352  -5.659  1.00  0.00           C  
ATOM   1415  C   VAL A  90       7.031  -2.537  -4.617  1.00  0.00           C  
ATOM   1416  O   VAL A  90       7.291  -3.012  -3.512  1.00  0.00           O  
ATOM   1417  CB  VAL A  90       7.237  -3.743  -6.792  1.00  0.00           C  
ATOM   1418  CG1 VAL A  90       8.533  -4.298  -6.222  1.00  0.00           C  
ATOM   1419  CG2 VAL A  90       6.582  -4.749  -7.727  1.00  0.00           C  
ATOM   1420  H   VAL A  90       4.875  -2.707  -7.113  1.00  0.00           H  
ATOM   1421  HA  VAL A  90       5.906  -4.257  -5.196  1.00  0.00           H  
ATOM   1422  HB  VAL A  90       7.471  -2.855  -7.362  1.00  0.00           H  
ATOM   1423 HG11 VAL A  90       8.307  -5.061  -5.492  1.00  0.00           H  
ATOM   1424 HG12 VAL A  90       9.124  -4.724  -7.020  1.00  0.00           H  
ATOM   1425 HG13 VAL A  90       9.088  -3.501  -5.750  1.00  0.00           H  
ATOM   1426 HG21 VAL A  90       6.320  -4.260  -8.653  1.00  0.00           H  
ATOM   1427 HG22 VAL A  90       7.271  -5.556  -7.928  1.00  0.00           H  
ATOM   1428 HG23 VAL A  90       5.690  -5.143  -7.263  1.00  0.00           H  
ATOM   1429  N   ALA A  91       7.383  -1.307  -4.978  1.00  0.00           N  
ATOM   1430  CA  ALA A  91       8.110  -0.425  -4.074  1.00  0.00           C  
ATOM   1431  C   ALA A  91       7.278  -0.099  -2.838  1.00  0.00           C  
ATOM   1432  O   ALA A  91       7.684  -0.389  -1.712  1.00  0.00           O  
ATOM   1433  CB  ALA A  91       8.513   0.853  -4.794  1.00  0.00           C  
ATOM   1434  H   ALA A  91       7.146  -0.985  -5.873  1.00  0.00           H  
ATOM   1435  HA  ALA A  91       9.012  -0.934  -3.764  1.00  0.00           H  
ATOM   1436  HB1 ALA A  91       7.998   1.693  -4.349  1.00  0.00           H  
ATOM   1437  HB2 ALA A  91       9.579   0.996  -4.706  1.00  0.00           H  
ATOM   1438  HB3 ALA A  91       8.243   0.778  -5.837  1.00  0.00           H  
ATOM   1439  N   TRP A  92       6.116   0.505  -3.055  1.00  0.00           N  
ATOM   1440  CA  TRP A  92       5.228   0.871  -1.957  1.00  0.00           C  
ATOM   1441  C   TRP A  92       5.222  -0.208  -0.879  1.00  0.00           C  
ATOM   1442  O   TRP A  92       5.555   0.057   0.276  1.00  0.00           O  
ATOM   1443  CB  TRP A  92       3.807   1.097  -2.477  1.00  0.00           C  
ATOM   1444  CG  TRP A  92       3.544   2.514  -2.889  1.00  0.00           C  
ATOM   1445  CD1 TRP A  92       3.171   2.952  -4.128  1.00  0.00           C  
ATOM   1446  CD2 TRP A  92       3.637   3.678  -2.061  1.00  0.00           C  
ATOM   1447  NE1 TRP A  92       3.026   4.318  -4.120  1.00  0.00           N  
ATOM   1448  CE2 TRP A  92       3.305   4.788  -2.863  1.00  0.00           C  
ATOM   1449  CE3 TRP A  92       3.965   3.891  -0.719  1.00  0.00           C  
ATOM   1450  CZ2 TRP A  92       3.293   6.088  -2.367  1.00  0.00           C  
ATOM   1451  CZ3 TRP A  92       3.955   5.183  -0.228  1.00  0.00           C  
ATOM   1452  CH2 TRP A  92       3.620   6.268  -1.050  1.00  0.00           C  
ATOM   1453  H   TRP A  92       5.848   0.710  -3.976  1.00  0.00           H  
ATOM   1454  HA  TRP A  92       5.596   1.791  -1.528  1.00  0.00           H  
ATOM   1455  HB2 TRP A  92       3.640   0.464  -3.336  1.00  0.00           H  
ATOM   1456  HB3 TRP A  92       3.102   0.839  -1.700  1.00  0.00           H  
ATOM   1457  HD1 TRP A  92       3.018   2.308  -4.980  1.00  0.00           H  
ATOM   1458  HE1 TRP A  92       2.763   4.867  -4.888  1.00  0.00           H  
ATOM   1459  HE3 TRP A  92       4.225   3.068  -0.070  1.00  0.00           H  
ATOM   1460  HZ2 TRP A  92       3.038   6.935  -2.986  1.00  0.00           H  
ATOM   1461  HZ3 TRP A  92       4.207   5.368   0.805  1.00  0.00           H  
ATOM   1462  HH2 TRP A  92       3.625   7.260  -0.624  1.00  0.00           H  
ATOM   1463  N   ILE A  93       4.844  -1.421  -1.265  1.00  0.00           N  
ATOM   1464  CA  ILE A  93       4.797  -2.539  -0.330  1.00  0.00           C  
ATOM   1465  C   ILE A  93       6.128  -2.704   0.397  1.00  0.00           C  
ATOM   1466  O   ILE A  93       6.163  -2.882   1.614  1.00  0.00           O  
ATOM   1467  CB  ILE A  93       4.448  -3.857  -1.045  1.00  0.00           C  
ATOM   1468  CG1 ILE A  93       3.065  -3.762  -1.690  1.00  0.00           C  
ATOM   1469  CG2 ILE A  93       4.506  -5.021  -0.069  1.00  0.00           C  
ATOM   1470  CD1 ILE A  93       1.939  -3.629  -0.687  1.00  0.00           C  
ATOM   1471  H   ILE A  93       4.592  -1.569  -2.200  1.00  0.00           H  
ATOM   1472  HA  ILE A  93       4.025  -2.332   0.397  1.00  0.00           H  
ATOM   1473  HB  ILE A  93       5.185  -4.028  -1.816  1.00  0.00           H  
ATOM   1474 HG12 ILE A  93       3.033  -2.902  -2.339  1.00  0.00           H  
ATOM   1475 HG13 ILE A  93       2.885  -4.655  -2.273  1.00  0.00           H  
ATOM   1476 HG21 ILE A  93       3.524  -5.462   0.024  1.00  0.00           H  
ATOM   1477 HG22 ILE A  93       5.200  -5.764  -0.433  1.00  0.00           H  
ATOM   1478 HG23 ILE A  93       4.833  -4.666   0.897  1.00  0.00           H  
ATOM   1479 HD11 ILE A  93       1.204  -4.399  -0.867  1.00  0.00           H  
ATOM   1480 HD12 ILE A  93       2.333  -3.730   0.313  1.00  0.00           H  
ATOM   1481 HD13 ILE A  93       1.476  -2.658  -0.795  1.00  0.00           H  
ATOM   1482  N   SER A  94       7.219  -2.641  -0.358  1.00  0.00           N  
ATOM   1483  CA  SER A  94       8.553  -2.786   0.213  1.00  0.00           C  
ATOM   1484  C   SER A  94       8.811  -1.713   1.267  1.00  0.00           C  
ATOM   1485  O   SER A  94       9.412  -1.982   2.308  1.00  0.00           O  
ATOM   1486  CB  SER A  94       9.614  -2.703  -0.886  1.00  0.00           C  
ATOM   1487  OG  SER A  94      10.811  -3.349  -0.489  1.00  0.00           O  
ATOM   1488  H   SER A  94       7.125  -2.497  -1.323  1.00  0.00           H  
ATOM   1489  HA  SER A  94       8.609  -3.757   0.683  1.00  0.00           H  
ATOM   1490  HB2 SER A  94       9.241  -3.180  -1.779  1.00  0.00           H  
ATOM   1491  HB3 SER A  94       9.831  -1.666  -1.096  1.00  0.00           H  
ATOM   1492  HG  SER A  94      10.651  -4.290  -0.394  1.00  0.00           H  
ATOM   1493  N   VAL A  95       8.355  -0.497   0.988  1.00  0.00           N  
ATOM   1494  CA  VAL A  95       8.535   0.618   1.912  1.00  0.00           C  
ATOM   1495  C   VAL A  95       7.638   0.468   3.135  1.00  0.00           C  
ATOM   1496  O   VAL A  95       8.115   0.208   4.241  1.00  0.00           O  
ATOM   1497  CB  VAL A  95       8.234   1.966   1.230  1.00  0.00           C  
ATOM   1498  CG1 VAL A  95       9.104   3.067   1.815  1.00  0.00           C  
ATOM   1499  CG2 VAL A  95       8.436   1.858  -0.274  1.00  0.00           C  
ATOM   1500  H   VAL A  95       7.885  -0.345   0.143  1.00  0.00           H  
ATOM   1501  HA  VAL A  95       9.566   0.623   2.232  1.00  0.00           H  
ATOM   1502  HB  VAL A  95       7.200   2.217   1.416  1.00  0.00           H  
ATOM   1503 HG11 VAL A  95       9.822   3.390   1.075  1.00  0.00           H  
ATOM   1504 HG12 VAL A  95       8.484   3.902   2.105  1.00  0.00           H  
ATOM   1505 HG13 VAL A  95       9.628   2.689   2.681  1.00  0.00           H  
ATOM   1506 HG21 VAL A  95       9.165   1.091  -0.485  1.00  0.00           H  
ATOM   1507 HG22 VAL A  95       7.498   1.602  -0.747  1.00  0.00           H  
ATOM   1508 HG23 VAL A  95       8.786   2.804  -0.660  1.00  0.00           H  
ATOM   1509  N   LEU A  96       6.335   0.634   2.931  1.00  0.00           N  
ATOM   1510  CA  LEU A  96       5.370   0.516   4.018  1.00  0.00           C  
ATOM   1511  C   LEU A  96       5.820  -0.528   5.035  1.00  0.00           C  
ATOM   1512  O   LEU A  96       5.910  -0.247   6.232  1.00  0.00           O  
ATOM   1513  CB  LEU A  96       3.992   0.148   3.465  1.00  0.00           C  
ATOM   1514  CG  LEU A  96       3.367   1.151   2.496  1.00  0.00           C  
ATOM   1515  CD1 LEU A  96       2.341   0.466   1.606  1.00  0.00           C  
ATOM   1516  CD2 LEU A  96       2.729   2.302   3.259  1.00  0.00           C  
ATOM   1517  H   LEU A  96       6.015   0.839   2.029  1.00  0.00           H  
ATOM   1518  HA  LEU A  96       5.306   1.476   4.509  1.00  0.00           H  
ATOM   1519  HB2 LEU A  96       4.085  -0.796   2.949  1.00  0.00           H  
ATOM   1520  HB3 LEU A  96       3.321   0.032   4.303  1.00  0.00           H  
ATOM   1521  HG  LEU A  96       4.140   1.558   1.859  1.00  0.00           H  
ATOM   1522 HD11 LEU A  96       1.833  -0.303   2.169  1.00  0.00           H  
ATOM   1523 HD12 LEU A  96       2.840   0.021   0.758  1.00  0.00           H  
ATOM   1524 HD13 LEU A  96       1.622   1.194   1.259  1.00  0.00           H  
ATOM   1525 HD21 LEU A  96       3.499   2.869   3.764  1.00  0.00           H  
ATOM   1526 HD22 LEU A  96       2.033   1.911   3.987  1.00  0.00           H  
ATOM   1527 HD23 LEU A  96       2.204   2.945   2.568  1.00  0.00           H  
ATOM   1528  N   THR A  97       6.101  -1.734   4.552  1.00  0.00           N  
ATOM   1529  CA  THR A  97       6.541  -2.820   5.418  1.00  0.00           C  
ATOM   1530  C   THR A  97       7.891  -2.504   6.053  1.00  0.00           C  
ATOM   1531  O   THR A  97       8.066  -2.640   7.262  1.00  0.00           O  
ATOM   1532  CB  THR A  97       6.649  -4.148   4.645  1.00  0.00           C  
ATOM   1533  OG1 THR A  97       5.579  -4.250   3.698  1.00  0.00           O  
ATOM   1534  CG2 THR A  97       6.606  -5.334   5.597  1.00  0.00           C  
ATOM   1535  H   THR A  97       6.009  -1.896   3.590  1.00  0.00           H  
ATOM   1536  HA  THR A  97       5.807  -2.942   6.201  1.00  0.00           H  
ATOM   1537  HB  THR A  97       7.591  -4.163   4.116  1.00  0.00           H  
ATOM   1538  HG1 THR A  97       5.942  -4.381   2.818  1.00  0.00           H  
ATOM   1539 HG21 THR A  97       5.684  -5.876   5.454  1.00  0.00           H  
ATOM   1540 HG22 THR A  97       6.662  -4.979   6.615  1.00  0.00           H  
ATOM   1541 HG23 THR A  97       7.443  -5.986   5.396  1.00  0.00           H  
ATOM   1542  N   ASN A  98       8.843  -2.080   5.228  1.00  0.00           N  
ATOM   1543  CA  ASN A  98      10.178  -1.744   5.709  1.00  0.00           C  
ATOM   1544  C   ASN A  98      10.110  -0.703   6.821  1.00  0.00           C  
ATOM   1545  O   ASN A  98      10.490  -0.972   7.962  1.00  0.00           O  
ATOM   1546  CB  ASN A  98      11.042  -1.221   4.559  1.00  0.00           C  
ATOM   1547  CG  ASN A  98      11.545  -2.335   3.661  1.00  0.00           C  
ATOM   1548  OD1 ASN A  98      11.492  -3.510   4.022  1.00  0.00           O  
ATOM   1549  ND2 ASN A  98      12.037  -1.968   2.483  1.00  0.00           N  
ATOM   1550  H   ASN A  98       8.643  -1.991   4.273  1.00  0.00           H  
ATOM   1551  HA  ASN A  98      10.625  -2.645   6.102  1.00  0.00           H  
ATOM   1552  HB2 ASN A  98      10.456  -0.539   3.959  1.00  0.00           H  
ATOM   1553  HB3 ASN A  98      11.893  -0.698   4.964  1.00  0.00           H  
ATOM   1554 HD21 ASN A  98      12.048  -1.013   2.263  1.00  0.00           H  
ATOM   1555 HD22 ASN A  98      12.369  -2.668   1.883  1.00  0.00           H  
ATOM   1556  N   SER A  99       9.622   0.485   6.483  1.00  0.00           N  
ATOM   1557  CA  SER A  99       9.506   1.569   7.453  1.00  0.00           C  
ATOM   1558  C   SER A  99       8.977   1.050   8.786  1.00  0.00           C  
ATOM   1559  O   SER A  99       9.442   1.454   9.853  1.00  0.00           O  
ATOM   1560  CB  SER A  99       8.583   2.665   6.917  1.00  0.00           C  
ATOM   1561  OG  SER A  99       8.860   3.912   7.531  1.00  0.00           O  
ATOM   1562  H   SER A  99       9.335   0.639   5.558  1.00  0.00           H  
ATOM   1563  HA  SER A  99      10.491   1.983   7.606  1.00  0.00           H  
ATOM   1564  HB2 SER A  99       8.724   2.762   5.851  1.00  0.00           H  
ATOM   1565  HB3 SER A  99       7.555   2.397   7.120  1.00  0.00           H  
ATOM   1566  HG  SER A  99       8.922   4.593   6.858  1.00  0.00           H  
ATOM   1567  N   LYS A 100       8.000   0.151   8.719  1.00  0.00           N  
ATOM   1568  CA  LYS A 100       7.406  -0.425   9.919  1.00  0.00           C  
ATOM   1569  C   LYS A 100       8.448  -1.193  10.727  1.00  0.00           C  
ATOM   1570  O   LYS A 100       8.695  -0.883  11.892  1.00  0.00           O  
ATOM   1571  CB  LYS A 100       6.250  -1.356   9.545  1.00  0.00           C  
ATOM   1572  CG  LYS A 100       5.632  -2.067  10.735  1.00  0.00           C  
ATOM   1573  CD  LYS A 100       4.786  -3.251  10.300  1.00  0.00           C  
ATOM   1574  CE  LYS A 100       4.324  -4.075  11.492  1.00  0.00           C  
ATOM   1575  NZ  LYS A 100       5.341  -5.086  11.896  1.00  0.00           N  
ATOM   1576  H   LYS A 100       7.671  -0.131   7.839  1.00  0.00           H  
ATOM   1577  HA  LYS A 100       7.025   0.384  10.522  1.00  0.00           H  
ATOM   1578  HB2 LYS A 100       5.480  -0.776   9.058  1.00  0.00           H  
ATOM   1579  HB3 LYS A 100       6.615  -2.104   8.855  1.00  0.00           H  
ATOM   1580  HG2 LYS A 100       6.421  -2.421  11.382  1.00  0.00           H  
ATOM   1581  HG3 LYS A 100       5.008  -1.369  11.275  1.00  0.00           H  
ATOM   1582  HD2 LYS A 100       3.918  -2.887   9.770  1.00  0.00           H  
ATOM   1583  HD3 LYS A 100       5.372  -3.880   9.645  1.00  0.00           H  
ATOM   1584  HE2 LYS A 100       4.139  -3.411  12.322  1.00  0.00           H  
ATOM   1585  HE3 LYS A 100       3.408  -4.584  11.228  1.00  0.00           H  
ATOM   1586  HZ1 LYS A 100       5.224  -5.328  12.900  1.00  0.00           H  
ATOM   1587  HZ2 LYS A 100       6.298  -4.706  11.752  1.00  0.00           H  
ATOM   1588  HZ3 LYS A 100       5.233  -5.949  11.326  1.00  0.00           H  
ATOM   1589  N   GLU A 101       9.059  -2.193  10.098  1.00  0.00           N  
ATOM   1590  CA  GLU A 101      10.076  -3.003  10.761  1.00  0.00           C  
ATOM   1591  C   GLU A 101      11.265  -2.145  11.182  1.00  0.00           C  
ATOM   1592  O   GLU A 101      11.590  -2.056  12.366  1.00  0.00           O  
ATOM   1593  CB  GLU A 101      10.546  -4.126   9.835  1.00  0.00           C  
ATOM   1594  CG  GLU A 101       9.426  -5.041   9.370  1.00  0.00           C  
ATOM   1595  CD  GLU A 101       8.586  -5.565  10.518  1.00  0.00           C  
ATOM   1596  OE1 GLU A 101       9.151  -5.814  11.603  1.00  0.00           O  
ATOM   1597  OE2 GLU A 101       7.361  -5.728  10.331  1.00  0.00           O  
ATOM   1598  H   GLU A 101       8.820  -2.391   9.170  1.00  0.00           H  
ATOM   1599  HA  GLU A 101       9.630  -3.438  11.642  1.00  0.00           H  
ATOM   1600  HB2 GLU A 101      11.010  -3.688   8.964  1.00  0.00           H  
ATOM   1601  HB3 GLU A 101      11.277  -4.725  10.359  1.00  0.00           H  
ATOM   1602  HG2 GLU A 101       8.785  -4.492   8.697  1.00  0.00           H  
ATOM   1603  HG3 GLU A 101       9.858  -5.882   8.846  1.00  0.00           H  
ATOM   1604  N   GLU A 102      11.910  -1.516  10.205  1.00  0.00           N  
ATOM   1605  CA  GLU A 102      13.064  -0.666  10.475  1.00  0.00           C  
ATOM   1606  C   GLU A 102      12.819   0.210  11.701  1.00  0.00           C  
ATOM   1607  O   GLU A 102      13.761   0.667  12.348  1.00  0.00           O  
ATOM   1608  CB  GLU A 102      13.375   0.211   9.261  1.00  0.00           C  
ATOM   1609  CG  GLU A 102      14.164  -0.505   8.178  1.00  0.00           C  
ATOM   1610  CD  GLU A 102      15.494  -1.034   8.680  1.00  0.00           C  
ATOM   1611  OE1 GLU A 102      16.284  -0.233   9.221  1.00  0.00           O  
ATOM   1612  OE2 GLU A 102      15.744  -2.249   8.530  1.00  0.00           O  
ATOM   1613  H   GLU A 102      11.602  -1.626   9.281  1.00  0.00           H  
ATOM   1614  HA  GLU A 102      13.909  -1.308  10.670  1.00  0.00           H  
ATOM   1615  HB2 GLU A 102      12.445   0.555   8.833  1.00  0.00           H  
ATOM   1616  HB3 GLU A 102      13.948   1.067   9.588  1.00  0.00           H  
ATOM   1617  HG2 GLU A 102      13.578  -1.336   7.814  1.00  0.00           H  
ATOM   1618  HG3 GLU A 102      14.350   0.186   7.369  1.00  0.00           H  
ATOM   1619  N   ALA A 103      11.548   0.442  12.012  1.00  0.00           N  
ATOM   1620  CA  ALA A 103      11.178   1.261  13.158  1.00  0.00           C  
ATOM   1621  C   ALA A 103      10.969   0.403  14.402  1.00  0.00           C  
ATOM   1622  O   ALA A 103      11.232   0.841  15.522  1.00  0.00           O  
ATOM   1623  CB  ALA A 103       9.924   2.064  12.851  1.00  0.00           C  
ATOM   1624  H   ALA A 103      10.841   0.050  11.457  1.00  0.00           H  
ATOM   1625  HA  ALA A 103      11.985   1.956  13.345  1.00  0.00           H  
ATOM   1626  HB1 ALA A 103       9.738   2.763  13.654  1.00  0.00           H  
ATOM   1627  HB2 ALA A 103      10.060   2.606  11.927  1.00  0.00           H  
ATOM   1628  HB3 ALA A 103       9.082   1.394  12.756  1.00  0.00           H  
ATOM   1629  N   LEU A 104      10.493  -0.820  14.197  1.00  0.00           N  
ATOM   1630  CA  LEU A 104      10.247  -1.740  15.302  1.00  0.00           C  
ATOM   1631  C   LEU A 104      11.555  -2.320  15.829  1.00  0.00           C  
ATOM   1632  O   LEU A 104      11.774  -2.388  17.039  1.00  0.00           O  
ATOM   1633  CB  LEU A 104       9.319  -2.871  14.853  1.00  0.00           C  
ATOM   1634  CG  LEU A 104       7.822  -2.559  14.876  1.00  0.00           C  
ATOM   1635  CD1 LEU A 104       7.036  -3.667  14.193  1.00  0.00           C  
ATOM   1636  CD2 LEU A 104       7.340  -2.364  16.306  1.00  0.00           C  
ATOM   1637  H   LEU A 104      10.302  -1.112  13.281  1.00  0.00           H  
ATOM   1638  HA  LEU A 104       9.768  -1.185  16.095  1.00  0.00           H  
ATOM   1639  HB2 LEU A 104       9.586  -3.135  13.842  1.00  0.00           H  
ATOM   1640  HB3 LEU A 104       9.492  -3.716  15.503  1.00  0.00           H  
ATOM   1641  HG  LEU A 104       7.644  -1.640  14.334  1.00  0.00           H  
ATOM   1642 HD11 LEU A 104       7.672  -4.176  13.485  1.00  0.00           H  
ATOM   1643 HD12 LEU A 104       6.190  -3.241  13.675  1.00  0.00           H  
ATOM   1644 HD13 LEU A 104       6.686  -4.370  14.935  1.00  0.00           H  
ATOM   1645 HD21 LEU A 104       7.439  -3.293  16.849  1.00  0.00           H  
ATOM   1646 HD22 LEU A 104       6.303  -2.061  16.298  1.00  0.00           H  
ATOM   1647 HD23 LEU A 104       7.934  -1.601  16.786  1.00  0.00           H  
ATOM   1648  N   THR A 105      12.424  -2.736  14.914  1.00  0.00           N  
ATOM   1649  CA  THR A 105      13.712  -3.309  15.285  1.00  0.00           C  
ATOM   1650  C   THR A 105      14.491  -2.367  16.196  1.00  0.00           C  
ATOM   1651  O   THR A 105      15.225  -2.809  17.079  1.00  0.00           O  
ATOM   1652  CB  THR A 105      14.566  -3.626  14.043  1.00  0.00           C  
ATOM   1653  OG1 THR A 105      15.742  -4.347  14.428  1.00  0.00           O  
ATOM   1654  CG2 THR A 105      14.962  -2.348  13.318  1.00  0.00           C  
ATOM   1655  H   THR A 105      12.192  -2.656  13.965  1.00  0.00           H  
ATOM   1656  HA  THR A 105      13.525  -4.233  15.813  1.00  0.00           H  
ATOM   1657  HB  THR A 105      13.982  -4.238  13.370  1.00  0.00           H  
ATOM   1658  HG1 THR A 105      16.261  -4.552  13.647  1.00  0.00           H  
ATOM   1659 HG21 THR A 105      14.086  -1.899  12.877  1.00  0.00           H  
ATOM   1660 HG22 THR A 105      15.677  -2.582  12.544  1.00  0.00           H  
ATOM   1661 HG23 THR A 105      15.405  -1.659  14.021  1.00  0.00           H  
ATOM   1662  N   MET A 106      14.324  -1.066  15.976  1.00  0.00           N  
ATOM   1663  CA  MET A 106      15.010  -0.062  16.780  1.00  0.00           C  
ATOM   1664  C   MET A 106      14.163   0.345  17.982  1.00  0.00           C  
ATOM   1665  O   MET A 106      14.588   1.154  18.806  1.00  0.00           O  
ATOM   1666  CB  MET A 106      15.335   1.168  15.930  1.00  0.00           C  
ATOM   1667  CG  MET A 106      14.111   1.992  15.562  1.00  0.00           C  
ATOM   1668  SD  MET A 106      14.536   3.645  14.981  1.00  0.00           S  
ATOM   1669  CE  MET A 106      15.492   3.253  13.518  1.00  0.00           C  
ATOM   1670  H   MET A 106      13.724  -0.776  15.258  1.00  0.00           H  
ATOM   1671  HA  MET A 106      15.933  -0.496  17.135  1.00  0.00           H  
ATOM   1672  HB2 MET A 106      16.016   1.801  16.478  1.00  0.00           H  
ATOM   1673  HB3 MET A 106      15.810   0.845  15.016  1.00  0.00           H  
ATOM   1674  HG2 MET A 106      13.569   1.480  14.782  1.00  0.00           H  
ATOM   1675  HG3 MET A 106      13.481   2.083  16.435  1.00  0.00           H  
ATOM   1676  HE1 MET A 106      14.876   3.382  12.640  1.00  0.00           H  
ATOM   1677  HE2 MET A 106      16.345   3.912  13.459  1.00  0.00           H  
ATOM   1678  HE3 MET A 106      15.830   2.228  13.573  1.00  0.00           H  
ATOM   1679  N   ALA A 107      12.965  -0.222  18.074  1.00  0.00           N  
ATOM   1680  CA  ALA A 107      12.059   0.081  19.175  1.00  0.00           C  
ATOM   1681  C   ALA A 107      12.102  -1.012  20.238  1.00  0.00           C  
ATOM   1682  O   ALA A 107      12.652  -2.090  20.011  1.00  0.00           O  
ATOM   1683  CB  ALA A 107      10.641   0.263  18.658  1.00  0.00           C  
ATOM   1684  H   ALA A 107      12.682  -0.859  17.385  1.00  0.00           H  
ATOM   1685  HA  ALA A 107      12.376   1.014  19.622  1.00  0.00           H  
ATOM   1686  HB1 ALA A 107       9.997   0.565  19.472  1.00  0.00           H  
ATOM   1687  HB2 ALA A 107      10.632   1.023  17.892  1.00  0.00           H  
ATOM   1688  HB3 ALA A 107      10.286  -0.670  18.245  1.00  0.00           H  
ATOM   1689  N   PHE A 108      11.518  -0.729  21.397  1.00  0.00           N  
ATOM   1690  CA  PHE A 108      11.489  -1.688  22.494  1.00  0.00           C  
ATOM   1691  C   PHE A 108      10.481  -2.800  22.219  1.00  0.00           C  
ATOM   1692  O   PHE A 108       9.400  -2.554  21.685  1.00  0.00           O  
ATOM   1693  CB  PHE A 108      11.143  -0.984  23.808  1.00  0.00           C  
ATOM   1694  CG  PHE A 108      11.845   0.333  23.983  1.00  0.00           C  
ATOM   1695  CD1 PHE A 108      11.309   1.494  23.450  1.00  0.00           C  
ATOM   1696  CD2 PHE A 108      13.037   0.410  24.684  1.00  0.00           C  
ATOM   1697  CE1 PHE A 108      11.953   2.707  23.610  1.00  0.00           C  
ATOM   1698  CE2 PHE A 108      13.685   1.620  24.848  1.00  0.00           C  
ATOM   1699  CZ  PHE A 108      13.141   2.770  24.311  1.00  0.00           C  
ATOM   1700  H   PHE A 108      11.095   0.148  21.517  1.00  0.00           H  
ATOM   1701  HA  PHE A 108      12.474  -2.124  22.577  1.00  0.00           H  
ATOM   1702  HB2 PHE A 108      10.080  -0.800  23.840  1.00  0.00           H  
ATOM   1703  HB3 PHE A 108      11.420  -1.622  24.633  1.00  0.00           H  
ATOM   1704  HD1 PHE A 108      10.379   1.447  22.903  1.00  0.00           H  
ATOM   1705  HD2 PHE A 108      13.464  -0.490  25.105  1.00  0.00           H  
ATOM   1706  HE1 PHE A 108      11.525   3.605  23.190  1.00  0.00           H  
ATOM   1707  HE2 PHE A 108      14.613   1.665  25.396  1.00  0.00           H  
ATOM   1708  HZ  PHE A 108      13.646   3.716  24.437  1.00  0.00           H  
ATOM   1709  N   SER A 109      10.844  -4.025  22.588  1.00  0.00           N  
ATOM   1710  CA  SER A 109       9.973  -5.175  22.378  1.00  0.00           C  
ATOM   1711  C   SER A 109       9.012  -5.351  23.550  1.00  0.00           C  
ATOM   1712  O   SER A 109       7.807  -5.515  23.360  1.00  0.00           O  
ATOM   1713  CB  SER A 109      10.807  -6.445  22.193  1.00  0.00           C  
ATOM   1714  OG  SER A 109      11.231  -6.584  20.848  1.00  0.00           O  
ATOM   1715  H   SER A 109      11.719  -4.157  23.010  1.00  0.00           H  
ATOM   1716  HA  SER A 109       9.400  -4.998  21.480  1.00  0.00           H  
ATOM   1717  HB2 SER A 109      11.678  -6.397  22.829  1.00  0.00           H  
ATOM   1718  HB3 SER A 109      10.211  -7.306  22.461  1.00  0.00           H  
ATOM   1719  HG  SER A 109      10.469  -6.739  20.285  1.00  0.00           H  
ATOM   1720  N   GLY A 110       9.555  -5.315  24.763  1.00  0.00           N  
ATOM   1721  CA  GLY A 110       8.732  -5.471  25.949  1.00  0.00           C  
ATOM   1722  C   GLY A 110       9.201  -4.602  27.098  1.00  0.00           C  
ATOM   1723  O   GLY A 110      10.396  -4.366  27.279  1.00  0.00           O  
ATOM   1724  H   GLY A 110      10.522  -5.181  24.853  1.00  0.00           H  
ATOM   1725  HA2 GLY A 110       7.714  -5.209  25.704  1.00  0.00           H  
ATOM   1726  HA3 GLY A 110       8.762  -6.506  26.259  1.00  0.00           H  
ATOM   1727  N   PRO A 111       8.246  -4.108  27.899  1.00  0.00           N  
ATOM   1728  CA  PRO A 111       8.543  -3.251  29.050  1.00  0.00           C  
ATOM   1729  C   PRO A 111       9.231  -4.012  30.178  1.00  0.00           C  
ATOM   1730  O   PRO A 111       8.949  -5.188  30.409  1.00  0.00           O  
ATOM   1731  CB  PRO A 111       7.162  -2.766  29.498  1.00  0.00           C  
ATOM   1732  CG  PRO A 111       6.220  -3.818  29.024  1.00  0.00           C  
ATOM   1733  CD  PRO A 111       6.801  -4.348  27.743  1.00  0.00           C  
ATOM   1734  HA  PRO A 111       9.150  -2.403  28.767  1.00  0.00           H  
ATOM   1735  HB2 PRO A 111       7.142  -2.673  30.575  1.00  0.00           H  
ATOM   1736  HB3 PRO A 111       6.947  -1.810  29.044  1.00  0.00           H  
ATOM   1737  HG2 PRO A 111       6.148  -4.606  29.758  1.00  0.00           H  
ATOM   1738  HG3 PRO A 111       5.247  -3.384  28.842  1.00  0.00           H  
ATOM   1739  HD2 PRO A 111       6.595  -5.403  27.643  1.00  0.00           H  
ATOM   1740  HD3 PRO A 111       6.409  -3.803  26.896  1.00  0.00           H  
ATOM   1741  N   SER A 112      10.136  -3.335  30.877  1.00  0.00           N  
ATOM   1742  CA  SER A 112      10.867  -3.949  31.979  1.00  0.00           C  
ATOM   1743  C   SER A 112      11.223  -2.913  33.041  1.00  0.00           C  
ATOM   1744  O   SER A 112      12.089  -2.064  32.830  1.00  0.00           O  
ATOM   1745  CB  SER A 112      12.140  -4.623  31.462  1.00  0.00           C  
ATOM   1746  OG  SER A 112      12.578  -5.637  32.350  1.00  0.00           O  
ATOM   1747  H   SER A 112      10.317  -2.400  30.645  1.00  0.00           H  
ATOM   1748  HA  SER A 112      10.229  -4.699  32.424  1.00  0.00           H  
ATOM   1749  HB2 SER A 112      11.943  -5.066  30.498  1.00  0.00           H  
ATOM   1750  HB3 SER A 112      12.921  -3.883  31.364  1.00  0.00           H  
ATOM   1751  HG  SER A 112      13.374  -5.345  32.801  1.00  0.00           H  
ATOM   1752  N   SER A 113      10.546  -2.988  34.183  1.00  0.00           N  
ATOM   1753  CA  SER A 113      10.786  -2.055  35.276  1.00  0.00           C  
ATOM   1754  C   SER A 113      12.282  -1.826  35.477  1.00  0.00           C  
ATOM   1755  O   SER A 113      13.016  -2.742  35.847  1.00  0.00           O  
ATOM   1756  CB  SER A 113      10.161  -2.580  36.570  1.00  0.00           C  
ATOM   1757  OG  SER A 113       8.755  -2.399  36.566  1.00  0.00           O  
ATOM   1758  H   SER A 113       9.867  -3.687  34.291  1.00  0.00           H  
ATOM   1759  HA  SER A 113      10.323  -1.114  35.018  1.00  0.00           H  
ATOM   1760  HB2 SER A 113      10.376  -3.633  36.669  1.00  0.00           H  
ATOM   1761  HB3 SER A 113      10.579  -2.047  37.412  1.00  0.00           H  
ATOM   1762  HG  SER A 113       8.385  -2.751  37.380  1.00  0.00           H  
ATOM   1763  N   GLY A 114      12.725  -0.598  35.230  1.00  0.00           N  
ATOM   1764  CA  GLY A 114      14.130  -0.270  35.389  1.00  0.00           C  
ATOM   1765  C   GLY A 114      15.042  -1.335  34.813  1.00  0.00           C  
ATOM   1766  O   GLY A 114      15.965  -1.799  35.482  1.00  0.00           O  
ATOM   1767  H   GLY A 114      12.092   0.092  34.938  1.00  0.00           H  
ATOM   1768  HA2 GLY A 114      14.328   0.667  34.891  1.00  0.00           H  
ATOM   1769  HA3 GLY A 114      14.345  -0.159  36.442  1.00  0.00           H  
TER    1770      GLY A 114                                                      
END
MOLECULE T0464.pdb
ATOM    289  N   LEU    18      -7.017 -12.593  -0.236  1.00 13.35           N 
ATOM    290  CA  LEU    18      -6.481 -11.452   0.518  1.00 23.42           C 
ATOM    291  C   LEU    18      -5.708 -11.929   1.763  1.00 62.24           C 
ATOM    292  O   LEU    18      -6.197 -12.763   2.529  1.00 14.32           O 
ATOM    293  CB  LEU    18      -7.649 -10.515   0.900  1.00 62.52           C 
ATOM    294  CG  LEU    18      -7.287  -9.117   1.464  1.00 41.20           C 
ATOM    295  CD1 LEU    18      -6.932  -9.176   2.950  1.00 70.34           C 
ATOM    296  CD2 LEU    18      -6.151  -8.484   0.661  1.00 64.45           C 
ATOM    297  H   LEU    18      -7.830 -13.038   0.092  1.00 37.77           H 
ATOM    298  HA  LEU    18      -5.800 -10.915  -0.131  1.00 64.31           H 
ATOM    299 3HB  LEU    18      -8.259 -11.025   1.634  1.00 37.77           H 
ATOM    300 2HB  LEU    18      -8.254 -10.364   0.016  1.00 37.77           H 
ATOM    301  HG  LEU    18      -8.151  -8.475   1.369  1.00 30.20           H 
ATOM    302 1HD1 LEU    18      -6.772  -8.173   3.322  1.00 37.77           H 
ATOM    303 2HD1 LEU    18      -6.033  -9.760   3.088  1.00 37.77           H 
ATOM    304 3HD1 LEU    18      -7.745  -9.636   3.498  1.00 37.77           H 
ATOM    305 1HD2 LEU    18      -6.441  -8.406  -0.376  1.00 37.77           H 
ATOM    306 2HD2 LEU    18      -5.262  -9.095   0.741  1.00 37.77           H 
ATOM    307 3HD2 LEU    18      -5.943  -7.497   1.048  1.00 37.77           H 
ATOM    308  N   SER    19      -4.497 -11.402   1.951  1.00 34.02           N 
ATOM    309  CA  SER    19      -3.650 -11.792   3.091  1.00 44.31           C 
ATOM    310  C   SER    19      -2.920 -10.590   3.700  1.00 41.31           C 
ATOM    311  O   SER    19      -3.014  -9.473   3.197  1.00 63.13           O 
ATOM    312  CB  SER    19      -2.614 -12.841   2.656  1.00 31.41           C 
ATOM    313  OG  SER    19      -3.236 -14.032   2.200  1.00  3.31           O 
ATOM    314  H   SER    19      -4.159 -10.743   1.307  1.00 37.77           H 
ATOM    315  HA  SER    19      -4.287 -12.227   3.848  1.00  2.32           H 
ATOM    316 3HB  SER    19      -1.976 -13.085   3.496  1.00 37.77           H 
ATOM    317 2HB  SER    19      -2.010 -12.439   1.856  1.00 37.77           H 
ATOM    318  HG  SER    19      -3.978 -14.247   2.776  1.00 63.25           H 
ATOM    319  N   LEU    20      -2.196 -10.829   4.792  1.00 41.43           N 
ATOM    320  CA  LEU    20      -1.401  -9.783   5.442  1.00 44.25           C 
ATOM    321  C   LEU    20      -0.137  -9.491   4.611  1.00 21.35           C 
ATOM    322  O   LEU    20       0.539 -10.412   4.145  1.00 54.01           O 
ATOM    323  CB  LEU    20      -1.022 -10.224   6.872  1.00 34.34           C 
ATOM    324  CG  LEU    20      -0.823  -9.097   7.907  1.00 45.24           C 
ATOM    325  CD1 LEU    20       0.321  -8.160   7.520  1.00 33.22           C 
ATOM    326  CD2 LEU    20      -2.120  -8.315   8.103  1.00 51.23           C 
ATOM    327  H   LEU    20      -2.201 -11.733   5.179  1.00 37.77           H 
ATOM    328  HA  LEU    20      -2.005  -8.888   5.494  1.00 43.02           H 
ATOM    329 3HB  LEU    20      -0.106 -10.796   6.816  1.00 37.77           H 
ATOM    330 2HB  LEU    20      -1.804 -10.877   7.239  1.00 37.77           H 
ATOM    331  HG  LEU    20      -0.565  -9.543   8.859  1.00 25.34           H 
ATOM    332 1HD1 LEU    20       1.237  -8.727   7.430  1.00 37.77           H 
ATOM    333 2HD1 LEU    20       0.443  -7.405   8.283  1.00 37.77           H 
ATOM    334 3HD1 LEU    20       0.096  -7.683   6.576  1.00 37.77           H 
ATOM    335 1HD2 LEU    20      -2.408  -7.851   7.170  1.00 37.77           H 
ATOM    336 2HD2 LEU    20      -1.974  -7.551   8.851  1.00 37.77           H 
ATOM    337 3HD2 LEU    20      -2.901  -8.988   8.424  1.00 37.77           H 
ATOM    338  N   LEU    21       0.177  -8.210   4.424  1.00 33.43           N 
ATOM    339  CA  LEU    21       1.339  -7.804   3.621  1.00  2.15           C 
ATOM    340  C   LEU    21       2.670  -8.232   4.267  1.00 50.31           C 
ATOM    341  O   LEU    21       2.969  -7.876   5.409  1.00  3.31           O 
ATOM    342  CB  LEU    21       1.315  -6.284   3.392  1.00  2.24           C 
ATOM    343  CG  LEU    21       2.482  -5.710   2.563  1.00 74.00           C 
ATOM    344  CD1 LEU    21       2.597  -6.409   1.209  1.00 75.40           C 
ATOM    345  CD2 LEU    21       2.312  -4.203   2.375  1.00 24.42           C 
ATOM    346  H   LEU    21      -0.381  -7.518   4.838  1.00 37.77           H 
ATOM    347  HA  LEU    21       1.253  -8.298   2.662  1.00 31.23           H 
ATOM    348 3HB  LEU    21       1.318  -5.799   4.358  1.00 37.77           H 
ATOM    349 2HB  LEU    21       0.390  -6.035   2.889  1.00 37.77           H 
ATOM    350  HG  LEU    21       3.407  -5.875   3.099  1.00 73.23           H 
ATOM    351 1HD1 LEU    21       3.442  -6.009   0.667  1.00 37.77           H 
ATOM    352 2HD1 LEU    21       1.695  -6.246   0.638  1.00 37.77           H 
ATOM    353 3HD1 LEU    21       2.737  -7.470   1.362  1.00 37.77           H 
ATOM    354 1HD2 LEU    21       3.130  -3.819   1.781  1.00 37.77           H 
ATOM    355 2HD2 LEU    21       2.311  -3.717   3.338  1.00 37.77           H 
ATOM    356 3HD2 LEU    21       1.377  -4.003   1.870  1.00 37.77           H 
ATOM    357  N   GLU    22       3.453  -9.009   3.520  1.00 23.44           N 
ATOM    358  CA  GLU    22       4.776  -9.459   3.972  1.00 42.51           C 
ATOM    359  C   GLU    22       5.773  -8.288   4.081  1.00 75.03           C 
ATOM    360  O   GLU    22       5.609  -7.256   3.423  1.00 24.24           O 
ATOM    361  CB  GLU    22       5.319 -10.531   3.012  1.00 22.41           C 
ATOM    362  CG  GLU    22       5.319 -10.106   1.544  1.00 34.41           C 
ATOM    363  CD  GLU    22       5.932 -11.151   0.623  1.00 45.23           C 
ATOM    364  OE1 GLU    22       6.842 -10.807  -0.160  1.00 42.22           O 
ATOM    365  OE2 GLU    22       5.513 -12.326   0.679  1.00 33.24           O 
ATOM    366  H   GLU    22       3.130  -9.299   2.644  1.00 37.77           H 
ATOM    367  HA  GLU    22       4.653  -9.901   4.952  1.00 32.12           H 
ATOM    368 3HB  GLU    22       4.715 -11.422   3.108  1.00 37.77           H 
ATOM    369 2HB  GLU    22       6.337 -10.768   3.297  1.00 37.77           H 
ATOM    370 3HG  GLU    22       5.879  -9.186   1.450  1.00 37.77           H 
ATOM    371 2HG  GLU    22       4.297  -9.933   1.234  1.00 37.77           H 
ATOM    372  N   SER    23       6.816  -8.470   4.893  1.00  1.21           N 
ATOM    373  CA  SER    23       7.819  -7.413   5.143  1.00 41.34           C 
ATOM    374  C   SER    23       8.411  -6.862   3.838  1.00 42.04           C 
ATOM    375  O   SER    23       8.589  -5.652   3.690  1.00  1.45           O 
ATOM    376  CB  SER    23       8.956  -7.941   6.030  1.00 11.21           C 
ATOM    377  OG  SER    23       9.718  -8.931   5.353  1.00 25.34           O 
ATOM    378  H   SER    23       6.916  -9.336   5.345  1.00 37.77           H 
ATOM    379  HA  SER    23       7.319  -6.607   5.663  1.00 22.33           H 
ATOM    380 3HB  SER    23       8.538  -8.375   6.926  1.00 37.77           H 
ATOM    381 2HB  SER    23       9.610  -7.125   6.298  1.00 37.77           H 
ATOM    382  HG  SER    23      10.641  -8.639   5.304  1.00 52.15           H 
ATOM    383  N   LYS    24       8.686  -7.760   2.889  1.00 62.33           N 
ATOM    384  CA  LYS    24       9.241  -7.387   1.576  1.00 41.22           C 
ATOM    385  C   LYS    24       8.396  -6.294   0.895  1.00 30.13           C 
ATOM    386  O   LYS    24       8.932  -5.311   0.377  1.00  1.41           O 
ATOM    387  CB  LYS    24       9.318  -8.637   0.681  1.00  2.54           C 
ATOM    388  CG  LYS    24       9.650  -8.355  -0.787  1.00 53.52           C 
ATOM    389  CD  LYS    24      11.029  -7.726  -0.967  1.00 44.52           C 
ATOM    390  CE  LYS    24      12.153  -8.653  -0.519  1.00 54.15           C 
ATOM    391  NZ  LYS    24      13.489  -8.078  -0.820  1.00 43.01           N 
ATOM    392  H   LYS    24       8.524  -8.707   3.081  1.00 37.77           H 
ATOM    393  HA  LYS    24      10.239  -7.006   1.736  1.00 24.35           H 
ATOM    394 3HB  LYS    24       8.366  -9.150   0.717  1.00 37.77           H 
ATOM    395 2HB  LYS    24      10.077  -9.297   1.074  1.00 37.77           H 
ATOM    396 3HG  LYS    24       8.902  -7.682  -1.186  1.00 37.77           H 
ATOM    397 2HG  LYS    24       9.619  -9.285  -1.334  1.00 37.77           H 
ATOM    398 3HD  LYS    24      11.076  -6.816  -0.384  1.00 37.77           H 
ATOM    399 2HD  LYS    24      11.172  -7.489  -2.010  1.00 37.77           H 
ATOM    400 3HE  LYS    24      12.053  -9.598  -1.033  1.00 37.77           H 
ATOM    401 2HE  LYS    24      12.072  -8.815   0.546  1.00 37.77           H 
ATOM    402 1HZ  LYS    24      13.588  -7.918  -1.843  1.00 37.77           H 
ATOM    403 2HZ  LYS    24      14.236  -8.724  -0.507  1.00 37.77           H 
ATOM    404 3HZ  LYS    24      13.607  -7.169  -0.327  1.00 37.77           H 
ATOM    405  N   GLY    25       7.080  -6.478   0.898  1.00 21.50           N 
ATOM    406  CA  GLY    25       6.184  -5.464   0.354  1.00 53.33           C 
ATOM    407  C   GLY    25       6.023  -4.263   1.284  1.00 14.32           C 
ATOM    408  O   GLY    25       6.089  -3.114   0.846  1.00 34.34           O 
ATOM    409  H   GLY    25       6.711  -7.304   1.274  1.00 37.77           H 
ATOM    410 3HA  GLY    25       5.213  -5.908   0.196  1.00 37.77           H 
ATOM    411 2HA  GLY    25       6.573  -5.123  -0.596  1.00 37.77           H 
ATOM    412  N   LEU    26       5.836  -4.538   2.573  1.00  3.24           N 
ATOM    413  CA  LEU    26       5.585  -3.494   3.577  1.00  1.01           C 
ATOM    414  C   LEU    26       6.667  -2.402   3.547  1.00 22.24           C 
ATOM    415  O   LEU    26       6.354  -1.205   3.538  1.00 53.41           O 
ATOM    416  CB  LEU    26       5.506  -4.118   4.977  1.00 50.14           C 
ATOM    417  CG  LEU    26       5.115  -3.151   6.112  1.00 62.53           C 
ATOM    418  CD1 LEU    26       3.724  -2.563   5.878  1.00 44.03           C 
ATOM    419  CD2 LEU    26       5.180  -3.857   7.466  1.00  1.11           C 
ATOM    420  H   LEU    26       5.869  -5.475   2.862  1.00 37.77           H 
ATOM    421  HA  LEU    26       4.634  -3.041   3.343  1.00 45.24           H 
ATOM    422 3HB  LEU    26       6.474  -4.541   5.212  1.00 37.77           H 
ATOM    423 2HB  LEU    26       4.782  -4.920   4.946  1.00 37.77           H 
ATOM    424  HG  LEU    26       5.820  -2.330   6.131  1.00 64.41           H 
ATOM    425 1HD1 LEU    26       3.002  -3.363   5.786  1.00 37.77           H 
ATOM    426 2HD1 LEU    26       3.724  -1.978   4.972  1.00 37.77           H 
ATOM    427 3HD1 LEU    26       3.454  -1.932   6.713  1.00 37.77           H 
ATOM    428 1HD2 LEU    26       4.472  -4.672   7.482  1.00 37.77           H 
ATOM    429 2HD2 LEU    26       4.940  -3.154   8.249  1.00 37.77           H 
ATOM    430 3HD2 LEU    26       6.176  -4.243   7.624  1.00 37.77           H 
ATOM    431  N   GLU    27       7.935  -2.810   3.517  1.00 40.23           N 
ATOM    432  CA  GLU    27       9.045  -1.856   3.430  1.00 72.40           C 
ATOM    433  C   GLU    27       8.974  -1.038   2.128  1.00 11.24           C 
ATOM    434  O   GLU    27       9.292   0.147   2.115  1.00 50.43           O 
ATOM    435  CB  GLU    27      10.399  -2.576   3.531  1.00  1.33           C 
ATOM    436  CG  GLU    27      10.608  -3.654   2.472  1.00 13.53           C 
ATOM    437  CD  GLU    27      11.993  -4.278   2.526  1.00 53.45           C 
ATOM    438  OE1 GLU    27      12.790  -4.047   1.591  1.00 62.44           O 
ATOM    439  OE2 GLU    27      12.298  -4.996   3.504  1.00 12.24           O 
ATOM    440  H   GLU    27       8.132  -3.772   3.551  1.00 37.77           H 
ATOM    441  HA  GLU    27       8.953  -1.173   4.265  1.00 43.30           H 
ATOM    442 3HB  GLU    27      10.473  -3.041   4.504  1.00 37.77           H 
ATOM    443 2HB  GLU    27      11.191  -1.848   3.431  1.00 37.77           H 
ATOM    444 3HG  GLU    27      10.464  -3.211   1.496  1.00 37.77           H 
ATOM    445 2HG  GLU    27       9.872  -4.433   2.619  1.00 37.77           H 
ATOM    446  N   ALA    28       8.520  -1.675   1.044  1.00 12.15           N 
ATOM    447  CA  ALA    28       8.411  -1.006  -0.259  1.00 20.21           C 
ATOM    448  C   ALA    28       7.339   0.092  -0.235  1.00 51.42           C 
ATOM    449  O   ALA    28       7.537   1.183  -0.777  1.00 61.01           O 
ATOM    450  CB  ALA    28       8.112  -2.021  -1.355  1.00 41.51           C 
ATOM    451  H   ALA    28       8.241  -2.613   1.124  1.00 37.77           H 
ATOM    452  HA  ALA    28       9.368  -0.551  -0.477  1.00 21.11           H 
ATOM    453 1HB  ALA    28       8.873  -2.788  -1.355  1.00 37.77           H 
ATOM    454 2HB  ALA    28       8.102  -1.525  -2.315  1.00 37.77           H 
ATOM    455 3HB  ALA    28       7.147  -2.475  -1.176  1.00 37.77           H 
ATOM    456  N   LEU    29       6.203  -0.204   0.401  1.00 50.24           N 
ATOM    457  CA  LEU    29       5.144   0.792   0.592  1.00 12.45           C 
ATOM    458  C   LEU    29       5.663   1.999   1.392  1.00 12.24           C 
ATOM    459  O   LEU    29       5.548   3.138   0.951  1.00 73.53           O 
ATOM    460  CB  LEU    29       3.928   0.168   1.304  1.00  4.23           C 
ATOM    461  CG  LEU    29       2.934  -0.593   0.402  1.00 14.24           C 
ATOM    462  CD1 LEU    29       2.252   0.356  -0.580  1.00  2.02           C 
ATOM    463  CD2 LEU    29       3.621  -1.735  -0.343  1.00 61.11           C 
ATOM    464  H   LEU    29       6.073  -1.115   0.744  1.00 37.77           H 
ATOM    465  HA  LEU    29       4.840   1.134  -0.388  1.00 75.11           H 
ATOM    466 3HB  LEU    29       3.385   0.960   1.802  1.00 37.77           H 
ATOM    467 2HB  LEU    29       4.291  -0.516   2.056  1.00 37.77           H 
ATOM    468  HG  LEU    29       2.162  -1.026   1.027  1.00 33.41           H 
ATOM    469 1HD1 LEU    29       1.551  -0.196  -1.191  1.00 37.77           H 
ATOM    470 2HD1 LEU    29       2.996   0.815  -1.214  1.00 37.77           H 
ATOM    471 3HD1 LEU    29       1.724   1.124  -0.031  1.00 37.77           H 
ATOM    472 1HD2 LEU    29       4.033  -2.435   0.368  1.00 37.77           H 
ATOM    473 2HD2 LEU    29       4.417  -1.339  -0.959  1.00 37.77           H 
ATOM    474 3HD2 LEU    29       2.902  -2.243  -0.969  1.00 37.77           H 
ATOM    475  N   ASN    30       6.258   1.733   2.559  1.00 22.22           N 
ATOM    476  CA  ASN    30       6.824   2.795   3.405  1.00 32.52           C 
ATOM    477  C   ASN    30       7.909   3.606   2.666  1.00 62.34           C 
ATOM    478  O   ASN    30       8.005   4.823   2.835  1.00 41.01           O 
ATOM    479  CB  ASN    30       7.387   2.202   4.705  1.00 35.41           C 
ATOM    480  CG  ASN    30       6.291   1.839   5.693  1.00  3.03           C 
ATOM    481  OD1 ASN    30       5.924   2.633   6.550  1.00 71.15           O 
ATOM    482  ND2 ASN    30       5.748   0.643   5.582  1.00 33.21           N 
ATOM    483  H   ASN    30       6.312   0.802   2.861  1.00 37.77           H 
ATOM    484  HA  ASN    30       6.016   3.470   3.656  1.00 31.31           H 
ATOM    485 3HB  ASN    30       8.040   2.927   5.172  1.00 37.77           H 
ATOM    486 2HB  ASN    30       7.951   1.311   4.475  1.00 37.77           H 
ATOM    487 1HD2 ASN    30       6.072   0.051   4.877  1.00 37.77           H 
ATOM    488 2HD2 ASN    30       5.037   0.403   6.215  1.00 37.77           H 
ATOM    489  N   LYS    31       8.722   2.932   1.852  1.00 11.24           N 
ATOM    490  CA  LYS    31       9.680   3.617   0.970  1.00  4.24           C 
ATOM    491  C   LYS    31       8.956   4.594   0.033  1.00  1.52           C 
ATOM    492  O   LYS    31       9.306   5.773  -0.065  1.00 14.24           O 
ATOM    493  CB  LYS    31      10.467   2.593   0.134  1.00 74.32           C 
ATOM    494  CG  LYS    31      11.504   1.793   0.917  1.00 32.24           C 
ATOM    495  CD  LYS    31      12.075   0.646   0.082  1.00 52.20           C 
ATOM    496  CE  LYS    31      13.200  -0.086   0.806  1.00 73.43           C 
ATOM    497  NZ  LYS    31      14.415   0.761   0.937  1.00 73.10           N 
ATOM    498  H   LYS    31       8.682   1.953   1.844  1.00 37.77           H 
ATOM    499  HA  LYS    31      10.370   4.173   1.589  1.00 64.32           H 
ATOM    500 3HB  LYS    31      10.977   3.115  -0.666  1.00 37.77           H 
ATOM    501 2HB  LYS    31       9.765   1.895  -0.300  1.00 37.77           H 
ATOM    502 3HG  LYS    31      11.037   1.386   1.804  1.00 37.77           H 
ATOM    503 2HG  LYS    31      12.312   2.452   1.204  1.00 37.77           H 
ATOM    504 3HD  LYS    31      12.457   1.047  -0.846  1.00 37.77           H 
ATOM    505 2HD  LYS    31      11.283  -0.059  -0.131  1.00 37.77           H 
ATOM    506 3HE  LYS    31      13.450  -0.975   0.248  1.00 37.77           H 
ATOM    507 2HE  LYS    31      12.859  -0.365   1.792  1.00 37.77           H 
ATOM    508 1HZ  LYS    31      14.182   1.655   1.410  1.00 37.77           H 
ATOM    509 2HZ  LYS    31      14.809   0.974  -0.003  1.00 37.77           H 
ATOM    510 3HZ  LYS    31      15.138   0.265   1.495  1.00 37.77           H 
ATOM    511  N   ALA    32       7.925   4.088  -0.640  1.00 20.01           N 
ATOM    512  CA  ALA    32       7.148   4.879  -1.595  1.00 32.51           C 
ATOM    513  C   ALA    32       6.358   6.009  -0.909  1.00 11.23           C 
ATOM    514  O   ALA    32       6.135   7.067  -1.505  1.00  2.53           O 
ATOM    515  CB  ALA    32       6.212   3.961  -2.369  1.00 31.32           C 
ATOM    516  H   ALA    32       7.676   3.150  -0.488  1.00 37.77           H 
ATOM    517  HA  ALA    32       7.842   5.318  -2.302  1.00 62.34           H 
ATOM    518 1HB  ALA    32       5.506   3.507  -1.689  1.00 37.77           H 
ATOM    519 2HB  ALA    32       6.786   3.188  -2.857  1.00 37.77           H 
ATOM    520 3HB  ALA    32       5.675   4.531  -3.114  1.00 37.77           H 
ATOM    521  N   ILE    33       5.929   5.777   0.331  1.00 22.44           N 
ATOM    522  CA  ILE    33       5.201   6.788   1.108  1.00 62.10           C 
ATOM    523  C   ILE    33       6.112   7.976   1.463  1.00 73.41           C 
ATOM    524  O   ILE    33       5.753   9.131   1.238  1.00 54.24           O 
ATOM    525  CB  ILE    33       4.599   6.180   2.406  1.00 64.04           C 
ATOM    526  CG1 ILE    33       3.531   5.128   2.060  1.00  3.33           C 
ATOM    527  CG2 ILE    33       4.002   7.273   3.294  1.00 30.34           C 
ATOM    528  CD1 ILE    33       2.952   4.412   3.263  1.00 55.55           C 
ATOM    529  H   ILE    33       6.102   4.901   0.735  1.00 37.77           H 
ATOM    530  HA  ILE    33       4.384   7.148   0.494  1.00 10.10           H 
ATOM    531  HB  ILE    33       5.399   5.701   2.955  1.00 22.00           H 
ATOM    532 3HG1 ILE    33       3.966   4.382   1.408  1.00 37.77           H 
ATOM    533 2HG1 ILE    33       2.715   5.610   1.544  1.00 37.77           H 
ATOM    534 1HG2 ILE    33       3.215   7.788   2.759  1.00 37.77           H 
ATOM    535 2HG2 ILE    33       4.773   7.984   3.563  1.00 37.77           H 
ATOM    536 3HG2 ILE    33       3.597   6.830   4.192  1.00 37.77           H 
ATOM    537 1HD1 ILE    33       3.743   3.903   3.795  1.00 37.77           H 
ATOM    538 2HD1 ILE    33       2.217   3.692   2.934  1.00 37.77           H 
ATOM    539 3HD1 ILE    33       2.481   5.131   3.919  1.00 37.77           H 
ATOM    540  N   VAL    34       7.302   7.684   1.995  1.00 52.01           N 
ATOM    541  CA  VAL    34       8.286   8.730   2.296  1.00 31.35           C 
ATOM    542  C   VAL    34       8.704   9.461   1.010  1.00 64.01           C 
ATOM    543  O   VAL    34       9.001  10.656   1.014  1.00 15.40           O 
ATOM    544  CB  VAL    34       9.540   8.138   2.992  1.00  1.50           C 
ATOM    545  CG1 VAL    34      10.582   9.224   3.266  1.00  0.14           C 
ATOM    546  CG2 VAL    34       9.149   7.427   4.288  1.00 14.41           C 
ATOM    547  H   VAL    34       7.524   6.747   2.181  1.00 37.77           H 
ATOM    548  HA  VAL    34       7.822   9.441   2.969  1.00 22.01           H 
ATOM    549  HB  VAL    34       9.984   7.409   2.329  1.00 15.22           H 
ATOM    550 1HG1 VAL    34      11.434   8.790   3.770  1.00 37.77           H 
ATOM    551 2HG1 VAL    34      10.150   9.994   3.889  1.00 37.77           H 
ATOM    552 3HG1 VAL    34      10.904   9.661   2.330  1.00 37.77           H 
ATOM    553 1HG2 VAL    34       8.448   6.638   4.067  1.00 37.77           H 
ATOM    554 2HG2 VAL    34       8.692   8.134   4.967  1.00 37.77           H 
ATOM    555 3HG2 VAL    34      10.030   7.006   4.749  1.00 37.77           H 
ATOM    556  N   SER    35       8.714   8.719  -0.096  1.00 35.22           N 
ATOM    557  CA  SER    35       8.977   9.296  -1.422  1.00 21.31           C 
ATOM    558  C   SER    35       7.790  10.132  -1.920  1.00 63.04           C 
ATOM    559  O   SER    35       7.960  11.063  -2.709  1.00 31.00           O 
ATOM    560  CB  SER    35       9.279   8.189  -2.435  1.00 52.15           C 
ATOM    561  OG  SER    35       9.487   8.724  -3.733  1.00 71.55           O 
ATOM    562  H   SER    35       8.553   7.754  -0.018  1.00 37.77           H 
ATOM    563  HA  SER    35       9.843   9.940  -1.338  1.00 61.42           H 
ATOM    564 3HB  SER    35       8.449   7.498  -2.474  1.00 37.77           H 
ATOM    565 2HB  SER    35      10.169   7.658  -2.129  1.00 37.77           H 
ATOM    566  HG  SER    35      10.194   8.235  -4.172  1.00 53.32           H 
ATOM    567  N   GLY    36       6.589   9.791  -1.462  1.00 61.21           N 
ATOM    568  CA  GLY    36       5.385  10.510  -1.874  1.00 41.15           C 
ATOM    569  C   GLY    36       4.904  10.142  -3.276  1.00 32.33           C 
ATOM    570  O   GLY    36       4.314  10.966  -3.976  1.00 53.32           O 
ATOM    571  H   GLY    36       6.515   9.053  -0.821  1.00 37.77           H 
ATOM    572 3HA  GLY    36       5.589  11.571  -1.845  1.00 37.77           H 
ATOM    573 2HA  GLY    36       4.595  10.293  -1.170  1.00 37.77           H 
ATOM    574  N   THR    37       5.151   8.902  -3.695  1.00  1.41           N 
ATOM    575  CA  THR    37       4.718   8.434  -5.028  1.00 23.43           C 
ATOM    576  C   THR    37       3.472   7.539  -4.941  1.00 42.33           C 
ATOM    577  O   THR    37       2.971   7.055  -5.957  1.00  2.43           O 
ATOM    578  CB  THR    37       5.850   7.667  -5.761  1.00 52.23           C 
ATOM    579  OG1 THR    37       5.422   7.254  -7.073  1.00 63.45           O 
ATOM    580  CG2 THR    37       6.301   6.446  -4.963  1.00 22.13           C 
ATOM    581  H   THR    37       5.641   8.289  -3.105  1.00 37.77           H 
ATOM    582  HA  THR    37       4.469   9.307  -5.621  1.00 41.55           H 
ATOM    583  HB  THR    37       6.696   8.332  -5.868  1.00 11.50           H 
ATOM    584  HG1 THR    37       4.634   6.699  -7.000  1.00 12.23           H 
ATOM    585 1HG2 THR    37       7.086   5.932  -5.501  1.00 37.77           H 
ATOM    586 2HG2 THR    37       5.464   5.778  -4.820  1.00 37.77           H 
ATOM    587 3HG2 THR    37       6.677   6.763  -3.998  1.00 37.77           H 
ATOM    588  N   VAL    38       2.969   7.329  -3.727  1.00  0.22           N 
ATOM    589  CA  VAL    38       1.796   6.471  -3.509  1.00 33.42           C 
ATOM    590  C   VAL    38       0.486   7.239  -3.733  1.00 75.42           C 
ATOM    591  O   VAL    38       0.149   8.146  -2.969  1.00 62.21           O 
ATOM    592  CB  VAL    38       1.771   5.881  -2.078  1.00 55.21           C 
ATOM    593  CG1 VAL    38       0.601   4.915  -1.909  1.00  2.32           C 
ATOM    594  CG2 VAL    38       3.089   5.192  -1.750  1.00  5.34           C 
ATOM    595  H   VAL    38       3.388   7.764  -2.957  1.00 37.77           H 
ATOM    596  HA  VAL    38       1.845   5.650  -4.212  1.00 15.41           H 
ATOM    597  HB  VAL    38       1.636   6.696  -1.379  1.00  4.23           H 
ATOM    598 1HG1 VAL    38      -0.329   5.440  -2.077  1.00 37.77           H 
ATOM    599 2HG1 VAL    38       0.606   4.510  -0.908  1.00 37.77           H 
ATOM    600 3HG1 VAL    38       0.690   4.106  -2.622  1.00 37.77           H 
ATOM    601 1HG2 VAL    38       3.896   5.909  -1.810  1.00 37.77           H 
ATOM    602 2HG2 VAL    38       3.267   4.392  -2.454  1.00 37.77           H 
ATOM    603 3HG2 VAL    38       3.044   4.785  -0.748  1.00 37.77           H 
ATOM    604  N   GLN    39      -0.250   6.869  -4.779  1.00 32.42           N 
ATOM    605  CA  GLN    39      -1.560   7.466  -5.053  1.00 13.34           C 
ATOM    606  C   GLN    39      -2.697   6.512  -4.658  1.00 24.11           C 
ATOM    607  O   GLN    39      -2.919   5.493  -5.313  1.00 61.13           O 
ATOM    608  CB  GLN    39      -1.699   7.834  -6.539  1.00 62.20           C 
ATOM    609  CG  GLN    39      -0.705   8.886  -7.019  1.00 22.54           C 
ATOM    610  CD  GLN    39      -0.977   9.347  -8.444  1.00 32.40           C 
ATOM    611  OE1 GLN    39      -1.486   8.596  -9.272  1.00 13.23           O 
ATOM    612  NE2 GLN    39      -0.639  10.585  -8.741  1.00 61.13           N 
ATOM    613  H   GLN    39       0.094   6.176  -5.378  1.00 37.77           H 
ATOM    614  HA  GLN    39      -1.644   8.369  -4.463  1.00 65.15           H 
ATOM    615 3HB  GLN    39      -2.700   8.209  -6.711  1.00 37.77           H 
ATOM    616 2HB  GLN    39      -1.557   6.940  -7.133  1.00 37.77           H 
ATOM    617 3HG  GLN    39       0.291   8.471  -6.977  1.00 37.77           H 
ATOM    618 2HG  GLN    39      -0.763   9.743  -6.365  1.00 37.77           H 
ATOM    619 1HE2 GLN    39      -0.235  11.137  -8.043  1.00 37.77           H 
ATOM    620 2HE2 GLN    39      -0.812  10.903  -9.652  1.00 37.77           H 
ATOM    621  N   ARG    40      -3.409   6.840  -3.580  1.00 42.25           N 
ATOM    622  CA  ARG    40      -4.592   6.065  -3.183  1.00  1.55           C 
ATOM    623  C   ARG    40      -5.710   6.214  -4.231  1.00 43.23           C 
ATOM    624  O   ARG    40      -5.623   7.067  -5.115  1.00 61.32           O 
ATOM    625  CB  ARG    40      -5.084   6.504  -1.794  1.00 71.14           C 
ATOM    626  CG  ARG    40      -5.356   8.005  -1.669  1.00 32.01           C 
ATOM    627  CD  ARG    40      -5.893   8.365  -0.284  1.00  2.15           C 
ATOM    628  NE  ARG    40      -7.180   7.727  -0.023  1.00  2.43           N 
ATOM    629  CZ  ARG    40      -7.677   7.504   1.162  1.00 60.21           C 
ATOM    630  NH1 ARG    40      -7.050   7.857   2.235  1.00 62.13           N 
ATOM    631  NH2 ARG    40      -8.827   6.931   1.267  1.00 45.23           N 
ATOM    632  H   ARG    40      -3.135   7.615  -3.045  1.00 37.77           H 
ATOM    633  HA  ARG    40      -4.299   5.023  -3.139  1.00 42.44           H 
ATOM    634 3HB  ARG    40      -4.338   6.233  -1.061  1.00 37.77           H 
ATOM    635 2HB  ARG    40      -6.000   5.977  -1.568  1.00 37.77           H 
ATOM    636 3HG  ARG    40      -6.085   8.293  -2.415  1.00 37.77           H 
ATOM    637 2HG  ARG    40      -4.435   8.543  -1.839  1.00 37.77           H 
ATOM    638 3HD  ARG    40      -6.014   9.439  -0.223  1.00 37.77           H 
ATOM    639 2HD  ARG    40      -5.181   8.041   0.463  1.00 37.77           H 
ATOM    640  HE  ARG    40      -7.709   7.444  -0.796  1.00 53.45           H 
ATOM    641 1HH1 ARG    40      -6.170   8.312   2.172  1.00 37.77           H 
ATOM    642 2HH1 ARG    40      -7.453   7.654   3.126  1.00 37.77           H 
ATOM    643 1HH2 ARG    40      -9.324   6.668   0.444  1.00 37.77           H 
ATOM    644 2HH2 ARG    40      -9.214   6.742   2.170  1.00 37.77           H 
ATOM    645  N   ALA    41      -6.759   5.392  -4.127  1.00 45.45           N 
ATOM    646  CA  ALA    41      -7.856   5.381  -5.116  1.00 33.12           C 
ATOM    647  C   ALA    41      -8.412   6.788  -5.422  1.00 62.33           C 
ATOM    648  O   ALA    41      -8.803   7.080  -6.552  1.00 44.42           O 
ATOM    649  CB  ALA    41      -8.978   4.466  -4.638  1.00 64.21           C 
ATOM    650  H   ALA    41      -6.794   4.763  -3.373  1.00 37.77           H 
ATOM    651  HA  ALA    41      -7.460   4.964  -6.032  1.00 30.21           H 
ATOM    652 1HB  ALA    41      -9.437   4.891  -3.760  1.00 37.77           H 
ATOM    653 2HB  ALA    41      -8.576   3.492  -4.399  1.00 37.77           H 
ATOM    654 3HB  ALA    41      -9.720   4.366  -5.417  1.00 37.77           H 
ATOM    655  N   ASP    42      -8.433   7.658  -4.415  1.00 72.23           N 
ATOM    656  CA  ASP    42      -8.941   9.030  -4.574  1.00 54.15           C 
ATOM    657  C   ASP    42      -8.041   9.898  -5.482  1.00  3.35           C 
ATOM    658  O   ASP    42      -8.375  11.046  -5.785  1.00 22.51           O 
ATOM    659  CB  ASP    42      -9.068   9.688  -3.199  1.00 63.02           C 
ATOM    660  CG  ASP    42      -9.870   8.837  -2.237  1.00 53.11           C 
ATOM    661  OD1 ASP    42      -9.316   7.849  -1.723  1.00 64.32           O 
ATOM    662  OD2 ASP    42     -11.053   9.149  -1.993  1.00 15.20           O 
ATOM    663  H   ASP    42      -8.122   7.367  -3.533  1.00 37.77           H 
ATOM    664  HA  ASP    42      -9.925   8.966  -5.019  1.00  1.24           H 
ATOM    665 3HB  ASP    42      -9.557  10.646  -3.305  1.00 37.77           H 
ATOM    666 2HB  ASP    42      -8.080   9.837  -2.782  1.00 37.77           H 
ATOM    667  N   GLY    43      -6.908   9.347  -5.911  1.00 32.33           N 
ATOM    668  CA  GLY    43      -5.950  10.102  -6.717  1.00 53.41           C 
ATOM    669  C   GLY    43      -5.069  11.030  -5.880  1.00 50.23           C 
ATOM    670  O   GLY    43      -4.466  11.966  -6.403  1.00 11.54           O 
ATOM    671  H   GLY    43      -6.723   8.412  -5.694  1.00 37.77           H 
ATOM    672 3HA  GLY    43      -6.490  10.693  -7.443  1.00 37.77           H 
ATOM    673 2HA  GLY    43      -5.313   9.406  -7.243  1.00 37.77           H 
ATOM    674  N   SER    44      -4.993  10.763  -4.577  1.00 10.42           N 
ATOM    675  CA  SER    44      -4.214  11.601  -3.649  1.00  4.34           C 
ATOM    676  C   SER    44      -2.972  10.865  -3.127  1.00  4.33           C 
ATOM    677  O   SER    44      -2.886   9.639  -3.213  1.00 34.41           O 
ATOM    678  CB  SER    44      -5.086  12.041  -2.471  1.00 72.21           C 
ATOM    679  OG  SER    44      -4.354  12.841  -1.558  1.00 15.51           O 
ATOM    680  H   SER    44      -5.463   9.980  -4.227  1.00 37.77           H 
ATOM    681  HA  SER    44      -3.890  12.483  -4.187  1.00 14.43           H 
ATOM    682 3HB  SER    44      -5.452  11.169  -1.948  1.00 37.77           H 
ATOM    683 2HB  SER    44      -5.924  12.616  -2.839  1.00 37.77           H 
ATOM    684  HG  SER    44      -4.930  13.105  -0.831  1.00 32.44           H 
ATOM    685  N   ILE    45      -2.031  11.619  -2.560  1.00 21.25           N 
ATOM    686  CA  ILE    45      -0.742  11.068  -2.116  1.00 63.21           C 
ATOM    687  C   ILE    45      -0.748  10.723  -0.618  1.00 50.21           C 
ATOM    688  O   ILE    45      -1.248  11.489   0.205  1.00 14.21           O 
ATOM    689  CB  ILE    45       0.409  12.071  -2.395  1.00  4.41           C 
ATOM    690  CG1 ILE    45       0.511  12.364  -3.901  1.00 40.44           C 
ATOM    691  CG2 ILE    45       1.740  11.541  -1.855  1.00 32.25           C 
ATOM    692  CD1 ILE    45       0.836  11.147  -4.745  1.00 31.01           C 
ATOM    693  H   ILE    45      -2.212  12.573  -2.417  1.00 37.77           H 
ATOM    694  HA  ILE    45      -0.548  10.167  -2.681  1.00 20.32           H 
ATOM    695  HB  ILE    45       0.184  12.990  -1.875  1.00 74.41           H 
ATOM    696 3HG1 ILE    45       1.284  13.101  -4.068  1.00 37.77           H 
ATOM    697 2HG1 ILE    45      -0.433  12.761  -4.249  1.00 37.77           H 
ATOM    698 1HG2 ILE    45       1.674  11.420  -0.783  1.00 37.77           H 
ATOM    699 2HG2 ILE    45       2.529  12.242  -2.087  1.00 37.77           H 
ATOM    700 3HG2 ILE    45       1.964  10.588  -2.313  1.00 37.77           H 
ATOM    701 1HD1 ILE    45       0.824  11.420  -5.791  1.00 37.77           H 
ATOM    702 2HD1 ILE    45       0.101  10.376  -4.565  1.00 37.77           H 
ATOM    703 3HD1 ILE    45       1.818  10.778  -4.481  1.00 37.77           H 
ATOM    704  N   GLN    46      -0.189   9.563  -0.272  1.00 72.53           N 
ATOM    705  CA  GLN    46      -0.065   9.156   1.133  1.00 74.45           C 
ATOM    706  C   GLN    46       1.277   9.592   1.739  1.00 40.35           C 
ATOM    707  O   GLN    46       2.343   9.243   1.233  1.00  2.54           O 
ATOM    708  CB  GLN    46      -0.215   7.636   1.279  1.00 70.25           C 
ATOM    709  CG  GLN    46      -1.603   7.113   0.939  1.00  5.24           C 
ATOM    710  CD  GLN    46      -1.742   5.621   1.196  1.00  2.45           C 
ATOM    711  OE1 GLN    46      -1.477   4.809   0.328  1.00 54.02           O 
ATOM    712  NE2 GLN    46      -2.153   5.250   2.393  1.00 15.23           N 
ATOM    713  H   GLN    46       0.147   8.967  -0.976  1.00 37.77           H 
ATOM    714  HA  GLN    46      -0.862   9.636   1.685  1.00  1.21           H 
ATOM    715 3HB  GLN    46       0.005   7.361   2.302  1.00 37.77           H 
ATOM    716 2HB  GLN    46       0.497   7.152   0.627  1.00 37.77           H 
ATOM    717 3HG  GLN    46      -1.799   7.300  -0.109  1.00 37.77           H 
ATOM    718 2HG  GLN    46      -2.332   7.636   1.539  1.00 37.77           H 
ATOM    719 1HE2 GLN    46      -2.352   5.945   3.052  1.00 37.77           H 
ATOM    720 2HE2 GLN    46      -2.240   4.293   2.568  1.00 37.77           H 
ATOM    721  N   ASN    47       1.209  10.358   2.826  1.00 72.43           N 
ATOM    722  CA  ASN    47       2.401  10.748   3.590  1.00 61.21           C 
ATOM    723  C   ASN    47       2.430  10.031   4.951  1.00 10.34           C 
ATOM    724  O   ASN    47       3.380  10.164   5.724  1.00 60.34           O 
ATOM    725  CB  ASN    47       2.426  12.268   3.797  1.00 24.03           C 
ATOM    726  CG  ASN    47       2.453  13.030   2.484  1.00 70.21           C 
ATOM    727  OD1 ASN    47       1.416  13.361   1.922  1.00 21.42           O 
ATOM    728  ND2 ASN    47       3.638  13.313   1.984  1.00 22.22           N 
ATOM    729  H   ASN    47       0.334  10.685   3.117  1.00 37.77           H 
ATOM    730  HA  ASN    47       3.275  10.455   3.026  1.00 42.15           H 
ATOM    731 3HB  ASN    47       3.304  12.537   4.367  1.00 37.77           H 
ATOM    732 2HB  ASN    47       1.542  12.566   4.344  1.00 37.77           H 
ATOM    733 1HD2 ASN    47       4.430  13.023   2.475  1.00 37.77           H 
ATOM    734 2HD2 ASN    47       3.673  13.801   1.134  1.00 37.77           H 
ATOM    735  N   GLN    48       1.377   9.266   5.233  1.00  1.14           N 
ATOM    736  CA  GLN    48       1.258   8.524   6.492  1.00  3.50           C 
ATOM    737  C   GLN    48       1.853   7.110   6.359  1.00 22.11           C 
ATOM    738  O   GLN    48       1.254   6.229   5.734  1.00 33.42           O 
ATOM    739  CB  GLN    48      -0.222   8.442   6.900  1.00 72.14           C 
ATOM    740  CG  GLN    48      -0.897   9.808   7.019  1.00 42.12           C 
ATOM    741  CD  GLN    48      -2.390   9.714   7.289  1.00 71.35           C 
ATOM    742  OE1 GLN    48      -2.864   8.772   7.916  1.00 65.53           O 
ATOM    743  NE2 GLN    48      -3.142  10.689   6.823  1.00 72.14           N 
ATOM    744  H   GLN    48       0.657   9.194   4.573  1.00 37.77           H 
ATOM    745  HA  GLN    48       1.803   9.064   7.255  1.00 61.31           H 
ATOM    746 3HB  GLN    48      -0.291   7.945   7.857  1.00 37.77           H 
ATOM    747 2HB  GLN    48      -0.757   7.860   6.162  1.00 37.77           H 
ATOM    748 3HG  GLN    48      -0.745  10.351   6.096  1.00 37.77           H 
ATOM    749 2HG  GLN    48      -0.435  10.353   7.830  1.00 37.77           H 
ATOM    750 1HE2 GLN    48      -2.708  11.418   6.335  1.00 37.77           H 
ATOM    751 2HE2 GLN    48      -4.108  10.643   6.980  1.00 37.77           H 
ATOM    752  N   SER    49       3.040   6.902   6.929  1.00 51.53           N 
ATOM    753  CA  SER    49       3.725   5.601   6.857  1.00  5.42           C 
ATOM    754  C   SER    49       3.041   4.546   7.738  1.00 33.42           C 
ATOM    755  O   SER    49       3.308   4.451   8.940  1.00 33.04           O 
ATOM    756  CB  SER    49       5.204   5.736   7.262  1.00 31.21           C 
ATOM    757  OG  SER    49       5.922   6.557   6.350  1.00 21.44           O 
ATOM    758  H   SER    49       3.468   7.639   7.409  1.00 37.77           H 
ATOM    759  HA  SER    49       3.680   5.268   5.829  1.00  5.01           H 
ATOM    760 3HB  SER    49       5.660   4.756   7.279  1.00 37.77           H 
ATOM    761 2HB  SER    49       5.268   6.176   8.245  1.00 37.77           H 
ATOM    762  HG  SER    49       6.524   6.007   5.834  1.00 53.22           H 
ATOM    763  N   LEU    50       2.149   3.760   7.132  1.00 33.22           N 
ATOM    764  CA  LEU    50       1.419   2.710   7.858  1.00 31.11           C 
ATOM    765  C   LEU    50       2.353   1.590   8.357  1.00 10.45           C 
ATOM    766  O   LEU    50       3.299   1.188   7.672  1.00 11.54           O 
ATOM    767  CB  LEU    50       0.272   2.142   6.989  1.00 32.13           C 
ATOM    768  CG  LEU    50       0.601   1.847   5.506  1.00 62.21           C 
ATOM    769  CD1 LEU    50       1.494   0.614   5.351  1.00 61.10           C 
ATOM    770  CD2 LEU    50      -0.684   1.683   4.696  1.00  3.51           C 
ATOM    771  H   LEU    50       1.973   3.891   6.179  1.00 37.77           H 
ATOM    772  HA  LEU    50       0.978   3.184   8.727  1.00 53.54           H 
ATOM    773 3HB  LEU    50      -0.544   2.855   7.011  1.00 37.77           H 
ATOM    774 2HB  LEU    50      -0.074   1.226   7.445  1.00 37.77           H 
ATOM    775  HG  LEU    50       1.140   2.690   5.098  1.00 43.31           H 
ATOM    776 1HD1 LEU    50       1.682   0.436   4.303  1.00 37.77           H 
ATOM    777 2HD1 LEU    50       1.000  -0.247   5.779  1.00 37.77           H 
ATOM    778 3HD1 LEU    50       2.431   0.780   5.861  1.00 37.77           H 
ATOM    779 1HD2 LEU    50      -0.437   1.506   3.659  1.00 37.77           H 
ATOM    780 2HD2 LEU    50      -1.278   2.582   4.775  1.00 37.77           H 
ATOM    781 3HD2 LEU    50      -1.250   0.844   5.078  1.00 37.77           H 
ATOM    782  N   HIS    51       2.089   1.098   9.566  1.00 51.22           N 
ATOM    783  CA  HIS    51       2.910   0.048  10.177  1.00 12.44           C 
ATOM    784  C   HIS    51       2.525  -1.350   9.666  1.00 74.33           C 
ATOM    785  O   HIS    51       3.315  -2.290   9.750  1.00 65.14           O 
ATOM    786  CB  HIS    51       2.775   0.097  11.705  1.00 50.21           C 
ATOM    787  CG  HIS    51       3.696  -0.843  12.425  1.00 12.54           C 
ATOM    788  ND1 HIS    51       3.330  -2.116  12.805  1.00 43.33           N 
ATOM    789  CD2 HIS    51       4.977  -0.688  12.831  1.00 65.34           C 
ATOM    790  CE1 HIS    51       4.342  -2.699  13.414  1.00  3.11           C 
ATOM    791  NE2 HIS    51       5.353  -1.857  13.445  1.00 22.32           N 
ATOM    792  H   HIS    51       1.329   1.466  10.069  1.00 37.77           H 
ATOM    793  HA  HIS    51       3.942   0.240   9.912  1.00 65.23           H 
ATOM    794 3HB  HIS    51       1.762  -0.157  11.979  1.00 37.77           H 
ATOM    795 2HB  HIS    51       2.993   1.097  12.048  1.00 37.77           H 
ATOM    796  HD1 HIS    51       2.450  -2.532  12.658  1.00 23.42           H 
ATOM    797  HD2 HIS    51       5.589   0.191  12.696  1.00 21.10           H 
ATOM    798  HE1 HIS    51       4.344  -3.702  13.814  1.00 42.44           H 
ATOM    799  HE2 HIS    51       6.144  -1.959  14.019  1.00 37.77           H 
ATOM    800  N   GLU    52       1.311  -1.487   9.145  1.00 73.04           N 
ATOM    801  CA  GLU    52       0.818  -2.784   8.667  1.00 51.21           C 
ATOM    802  C   GLU    52      -0.183  -2.595   7.512  1.00 44.33           C 
ATOM    803  O   GLU    52      -0.827  -1.549   7.402  1.00 22.22           O 
ATOM    804  CB  GLU    52       0.174  -3.553   9.836  1.00 53.44           C 
ATOM    805  CG  GLU    52      -0.211  -4.993   9.511  1.00 14.42           C 
ATOM    806  CD  GLU    52      -0.748  -5.750  10.720  1.00 34.12           C 
ATOM    807  OE1 GLU    52      -1.827  -5.383  11.235  1.00 73.13           O 
ATOM    808  OE2 GLU    52      -0.097  -6.722  11.159  1.00 63.02           O 
ATOM    809  H   GLU    52       0.729  -0.701   9.075  1.00 37.77           H 
ATOM    810  HA  GLU    52       1.667  -3.345   8.300  1.00 10.40           H 
ATOM    811 3HB  GLU    52      -0.719  -3.026  10.149  1.00 37.77           H 
ATOM    812 2HB  GLU    52       0.870  -3.572  10.663  1.00 37.77           H 
ATOM    813 3HG  GLU    52       0.662  -5.509   9.134  1.00 37.77           H 
ATOM    814 2HG  GLU    52      -0.972  -4.981   8.745  1.00 37.77           H 
ATOM    815  N   ALA    53      -0.300  -3.603   6.646  1.00 35.13           N 
ATOM    816  CA  ALA    53      -1.173  -3.519   5.469  1.00 22.14           C 
ATOM    817  C   ALA    53      -1.585  -4.910   4.961  1.00  3.41           C 
ATOM    818  O   ALA    53      -1.136  -5.935   5.480  1.00 62.51           O 
ATOM    819  CB  ALA    53      -0.481  -2.729   4.360  1.00 65.13           C 
ATOM    820  H   ALA    53       0.203  -4.428   6.805  1.00 37.77           H 
ATOM    821  HA  ALA    53      -2.068  -2.981   5.755  1.00 55.12           H 
ATOM    822 1HB  ALA    53      -1.154  -2.615   3.522  1.00 37.77           H 
ATOM    823 2HB  ALA    53       0.407  -3.254   4.039  1.00 37.77           H 
ATOM    824 3HB  ALA    53      -0.203  -1.752   4.731  1.00 37.77           H 
ATOM    825  N   LEU    54      -2.445  -4.933   3.947  1.00 75.43           N 
ATOM    826  CA  LEU    54      -2.945  -6.182   3.350  1.00 50.40           C 
ATOM    827  C   LEU    54      -2.504  -6.307   1.885  1.00 63.45           C 
ATOM    828  O   LEU    54      -2.476  -5.323   1.152  1.00  4.02           O 
ATOM    829  CB  LEU    54      -4.475  -6.210   3.422  1.00 55.02           C 
ATOM    830  CG  LEU    54      -5.069  -6.142   4.835  1.00 71.02           C 
ATOM    831  CD1 LEU    54      -6.563  -5.837   4.776  1.00  1.45           C 
ATOM    832  CD2 LEU    54      -4.813  -7.444   5.591  1.00 64.21           C 
ATOM    833  H   LEU    54      -2.759  -4.080   3.583  1.00 37.77           H 
ATOM    834  HA  LEU    54      -2.547  -7.015   3.912  1.00 40.54           H 
ATOM    835 3HB  LEU    54      -4.822  -7.122   2.956  1.00 37.77           H 
ATOM    836 2HB  LEU    54      -4.853  -5.374   2.851  1.00 37.77           H 
ATOM    837  HG  LEU    54      -4.591  -5.340   5.382  1.00 55.31           H 
ATOM    838 1HD1 LEU    54      -6.718  -4.891   4.278  1.00 37.77           H 
ATOM    839 2HD1 LEU    54      -6.961  -5.782   5.776  1.00 37.77           H 
ATOM    840 3HD1 LEU    54      -7.071  -6.618   4.227  1.00 37.77           H 
ATOM    841 1HD2 LEU    54      -5.258  -8.270   5.054  1.00 37.77           H 
ATOM    842 2HD2 LEU    54      -5.248  -7.381   6.576  1.00 37.77           H 
ATOM    843 3HD2 LEU    54      -3.748  -7.607   5.680  1.00 37.77           H 
ATOM    844  N   ILE    55      -2.181  -7.524   1.459  1.00 35.50           N 
ATOM    845  CA  ILE    55      -1.754  -7.771   0.078  1.00 11.33           C 
ATOM    846  C   ILE    55      -2.630  -8.828  -0.609  1.00  0.21           C 
ATOM    847  O   ILE    55      -2.935  -9.879  -0.039  1.00 24.22           O 
ATOM    848  CB  ILE    55      -0.266  -8.222   0.023  1.00 15.23           C 
ATOM    849  CG1 ILE    55       0.211  -8.385  -1.434  1.00 74.31           C 
ATOM    850  CG2 ILE    55      -0.061  -9.523   0.799  1.00 51.42           C 
ATOM    851  CD1 ILE    55       0.165  -7.107  -2.249  1.00 21.24           C 
ATOM    852  H   ILE    55      -2.230  -8.274   2.084  1.00 37.77           H 
ATOM    853  HA  ILE    55      -1.842  -6.842  -0.468  1.00 23.34           H 
ATOM    854  HB  ILE    55       0.327  -7.458   0.500  1.00 34.23           H 
ATOM    855 3HG1 ILE    55      -0.411  -9.118  -1.932  1.00 37.77           H 
ATOM    856 2HG1 ILE    55       1.233  -8.733  -1.434  1.00 37.77           H 
ATOM    857 1HG2 ILE    55       0.984  -9.797   0.776  1.00 37.77           H 
ATOM    858 2HG2 ILE    55      -0.648 -10.310   0.348  1.00 37.77           H 
ATOM    859 3HG2 ILE    55      -0.374  -9.386   1.825  1.00 37.77           H 
ATOM    860 1HD1 ILE    55      -0.848  -6.735  -2.281  1.00 37.77           H 
ATOM    861 2HD1 ILE    55       0.505  -7.309  -3.253  1.00 37.77           H 
ATOM    862 3HD1 ILE    55       0.807  -6.367  -1.795  1.00 37.77           H 
ATOM    863  N   THR    56      -3.063  -8.525  -1.828  1.00 64.31           N 
ATOM    864  CA  THR    56      -3.711  -9.526  -2.682  1.00 44.40           C 
ATOM    865  C   THR    56      -2.696 -10.592  -3.116  1.00 73.44           C 
ATOM    866  O   THR    56      -1.557 -10.270  -3.435  1.00 61.53           O 
ATOM    867  CB  THR    56      -4.324  -8.879  -3.948  1.00  2.03           C 
ATOM    868  OG1 THR    56      -3.313  -8.139  -4.663  1.00  5.31           O 
ATOM    869  CG2 THR    56      -5.482  -7.953  -3.588  1.00 41.14           C 
ATOM    870  H   THR    56      -2.963  -7.605  -2.153  1.00 37.77           H 
ATOM    871  HA  THR    56      -4.504  -9.996  -2.114  1.00 53.24           H 
ATOM    872  HB  THR    56      -4.699  -9.666  -4.589  1.00 52.34           H 
ATOM    873  HG1 THR    56      -2.514  -8.096  -4.121  1.00 43.14           H 
ATOM    874 1HG2 THR    56      -5.136  -7.183  -2.912  1.00 37.77           H 
ATOM    875 2HG2 THR    56      -6.265  -8.525  -3.107  1.00 37.77           H 
ATOM    876 3HG2 THR    56      -5.872  -7.494  -4.485  1.00 37.77           H 
ATOM    877  N   ARG    57      -3.112 -11.855  -3.137  1.00 10.23           N 
ATOM    878  CA  ARG    57      -2.212 -12.965  -3.487  1.00 41.23           C 
ATOM    879  C   ARG    57      -1.654 -12.825  -4.915  1.00 43.24           C 
ATOM    880  O   ARG    57      -0.513 -13.205  -5.190  1.00 75.13           O 
ATOM    881  CB  ARG    57      -2.946 -14.298  -3.330  1.00 14.31           C 
ATOM    882  CG  ARG    57      -2.060 -15.531  -3.503  1.00 33.52           C 
ATOM    883  CD  ARG    57      -2.796 -16.805  -3.101  1.00 71.21           C 
ATOM    884  NE  ARG    57      -3.312 -16.724  -1.736  1.00 20.22           N 
ATOM    885  CZ  ARG    57      -3.952 -17.683  -1.130  1.00 13.44           C 
ATOM    886  NH1 ARG    57      -4.121 -18.827  -1.704  1.00 34.13           N 
ATOM    887  NH2 ARG    57      -4.428 -17.490   0.057  1.00 53.40           N 
ATOM    888  H   ARG    57      -4.042 -12.051  -2.899  1.00 37.77           H 
ATOM    889  HA  ARG    57      -1.385 -12.942  -2.790  1.00 10.23           H 
ATOM    890 3HB  ARG    57      -3.740 -14.344  -4.063  1.00 37.77           H 
ATOM    891 2HB  ARG    57      -3.384 -14.335  -2.342  1.00 37.77           H 
ATOM    892 3HG  ARG    57      -1.181 -15.424  -2.884  1.00 37.77           H 
ATOM    893 2HG  ARG    57      -1.764 -15.609  -4.540  1.00 37.77           H 
ATOM    894 3HD  ARG    57      -2.111 -17.641  -3.170  1.00 37.77           H 
ATOM    895 2HD  ARG    57      -3.621 -16.962  -3.781  1.00 37.77           H 
ATOM    896  HE  ARG    57      -3.176 -15.883  -1.252  1.00 23.15           H 
ATOM    897 1HH1 ARG    57      -3.760 -18.985  -2.616  1.00 37.77           H 
ATOM    898 2HH1 ARG    57      -4.618 -19.552  -1.231  1.00 37.77           H 
ATOM    899 1HH2 ARG    57      -4.308 -16.603   0.504  1.00 37.77           H 
ATOM    900 2HH2 ARG    57      -4.911 -18.225   0.524  1.00 37.77           H 
ATOM    901  N   ASP    58      -2.467 -12.279  -5.820  1.00 50.40           N 
ATOM    902  CA  ASP    58      -2.031 -11.992  -7.193  1.00 30.15           C 
ATOM    903  C   ASP    58      -1.084 -10.769  -7.216  1.00  3.04           C 
ATOM    904  O   ASP    58      -0.454 -10.465  -8.230  1.00 22.40           O 
ATOM    905  CB  ASP    58      -3.262 -11.749  -8.078  1.00 73.13           C 
ATOM    906  CG  ASP    58      -2.930 -11.771  -9.560  1.00 13.24           C 
ATOM    907  OD1 ASP    58      -2.923 -10.696 -10.190  1.00 32.45           O 
ATOM    908  OD2 ASP    58      -2.673 -12.870 -10.093  1.00 31.14           O 
ATOM    909  H   ASP    58      -3.389 -12.076  -5.561  1.00 37.77           H 
ATOM    910  HA  ASP    58      -1.493 -12.855  -7.560  1.00 45.54           H 
ATOM    911 3HB  ASP    58      -3.691 -10.786  -7.831  1.00 37.77           H 
ATOM    912 2HB  ASP    58      -3.996 -12.521  -7.881  1.00 37.77           H 
ATOM    913  N   ARG    59      -1.001 -10.095  -6.066  1.00  5.01           N 
ATOM    914  CA  ARG    59      -0.108  -8.948  -5.845  1.00 35.32           C 
ATOM    915  C   ARG    59      -0.333  -7.804  -6.850  1.00 64.34           C 
ATOM    916  O   ARG    59       0.522  -7.495  -7.680  1.00  4.52           O 
ATOM    917  CB  ARG    59       1.363  -9.406  -5.803  1.00  2.13           C 
ATOM    918  CG  ARG    59       1.608 -10.462  -4.725  1.00 22.13           C 
ATOM    919  CD  ARG    59       3.083 -10.804  -4.541  1.00 54.44           C 
ATOM    920  NE  ARG    59       3.254 -11.840  -3.521  1.00 15.32           N 
ATOM    921  CZ  ARG    59       4.131 -11.811  -2.555  1.00 72.21           C 
ATOM    922  NH1 ARG    59       5.002 -10.854  -2.466  1.00 32.04           N 
ATOM    923  NH2 ARG    59       4.142 -12.762  -1.679  1.00 73.51           N 
ATOM    924  H   ARG    59      -1.563 -10.388  -5.323  1.00 37.77           H 
ATOM    925  HA  ARG    59      -0.357  -8.561  -4.864  1.00 13.52           H 
ATOM    926 3HB  ARG    59       1.994  -8.552  -5.593  1.00 37.77           H 
ATOM    927 2HB  ARG    59       1.636  -9.822  -6.762  1.00 37.77           H 
ATOM    928 3HG  ARG    59       1.073 -11.361  -4.995  1.00 37.77           H 
ATOM    929 2HG  ARG    59       1.225 -10.091  -3.786  1.00 37.77           H 
ATOM    930 3HD  ARG    59       3.614  -9.912  -4.237  1.00 37.77           H 
ATOM    931 2HD  ARG    59       3.480 -11.160  -5.480  1.00 37.77           H 
ATOM    932  HE  ARG    59       2.646 -12.606  -3.559  1.00 61.20           H 
ATOM    933 1HH1 ARG    59       5.010 -10.123  -3.142  1.00 37.77           H 
ATOM    934 2HH1 ARG    59       5.668 -10.855  -1.721  1.00 37.77           H 
ATOM    935 1HH2 ARG    59       3.484 -13.510  -1.755  1.00 37.77           H 
ATOM    936 2HH2 ARG    59       4.793 -12.737  -0.923  1.00 37.77           H 
ATOM    937  N   LYS    60      -1.512  -7.179  -6.756  1.00 61.24           N 
ATOM    938  CA  LYS    60      -1.836  -5.995  -7.564  1.00 23.05           C 
ATOM    939  C   LYS    60      -2.514  -4.893  -6.724  1.00 63.52           C 
ATOM    940  O   LYS    60      -2.481  -3.715  -7.087  1.00 45.32           O 
ATOM    941  CB  LYS    60      -2.722  -6.386  -8.758  1.00 42.53           C 
ATOM    942  CG  LYS    60      -4.073  -6.997  -8.381  1.00 43.24           C 
ATOM    943  CD  LYS    60      -4.783  -7.573  -9.608  1.00 44.00           C 
ATOM    944  CE  LYS    60      -6.131  -8.201  -9.265  1.00 74.42           C 
ATOM    945  NZ  LYS    60      -7.168  -7.180  -8.942  1.00 11.23           N 
ATOM    946  H   LYS    60      -2.186  -7.537  -6.141  1.00 37.77           H 
ATOM    947  HA  LYS    60      -0.903  -5.598  -7.944  1.00 61.41           H 
ATOM    948 3HB  LYS    60      -2.186  -7.106  -9.362  1.00 37.77           H 
ATOM    949 2HB  LYS    60      -2.908  -5.505  -9.357  1.00 37.77           H 
ATOM    950 3HG  LYS    60      -4.696  -6.228  -7.943  1.00 37.77           H 
ATOM    951 2HG  LYS    60      -3.916  -7.788  -7.663  1.00 37.77           H 
ATOM    952 3HD  LYS    60      -4.148  -8.329 -10.053  1.00 37.77           H 
ATOM    953 2HD  LYS    60      -4.945  -6.779 -10.323  1.00 37.77           H 
ATOM    954 3HE  LYS    60      -6.004  -8.851  -8.412  1.00 37.77           H 
ATOM    955 2HE  LYS    60      -6.469  -8.783 -10.109  1.00 37.77           H 
ATOM    956 1HZ  LYS    60      -8.102  -7.637  -8.848  1.00 37.77           H 
ATOM    957 2HZ  LYS    60      -7.217  -6.470  -9.704  1.00 37.77           H 
ATOM    958 3HZ  LYS    60      -6.937  -6.699  -8.055  1.00 37.77           H 
ATOM    959  N   GLN    61      -3.127  -5.278  -5.603  1.00  5.24           N 
ATOM    960  CA  GLN    61      -3.779  -4.317  -4.697  1.00 32.22           C 
ATOM    961  C   GLN    61      -3.264  -4.465  -3.255  1.00 13.03           C 
ATOM    962  O   GLN    61      -3.025  -5.579  -2.779  1.00 24.21           O 
ATOM    963  CB  GLN    61      -5.303  -4.508  -4.721  1.00 64.10           C 
ATOM    964  CG  GLN    61      -5.949  -4.204  -6.067  1.00 61.43           C 
ATOM    965  CD  GLN    61      -6.006  -2.714  -6.369  1.00 21.34           C 
ATOM    966  OE1 GLN    61      -6.975  -2.044  -6.045  1.00 61.43           O 
ATOM    967  NE2 GLN    61      -4.964  -2.184  -6.978  1.00 34.32           N 
ATOM    968  H   GLN    61      -3.149  -6.230  -5.372  1.00 37.77           H 
ATOM    969  HA  GLN    61      -3.546  -3.319  -5.047  1.00 32.43           H 
ATOM    970 3HB  GLN    61      -5.748  -3.858  -3.979  1.00 37.77           H 
ATOM    971 2HB  GLN    61      -5.530  -5.533  -4.466  1.00 37.77           H 
ATOM    972 3HG  GLN    61      -6.958  -4.593  -6.064  1.00 37.77           H 
ATOM    973 2HG  GLN    61      -5.381  -4.692  -6.846  1.00 37.77           H 
ATOM    974 1HE2 GLN    61      -4.212  -2.766  -7.205  1.00 37.77           H 
ATOM    975 2HE2 GLN    61      -4.991  -1.228  -7.178  1.00 37.77           H 
ATOM    976  N   VAL    62      -3.086  -3.329  -2.582  1.00  1.55           N 
ATOM    977  CA  VAL    62      -2.670  -3.293  -1.174  1.00  4.03           C 
ATOM    978  C   VAL    62      -3.664  -2.470  -0.336  1.00 53.30           C 
ATOM    979  O   VAL    62      -3.902  -1.299  -0.622  1.00  4.54           O 
ATOM    980  CB  VAL    62      -1.253  -2.674  -1.021  1.00  5.14           C 
ATOM    981  CG1 VAL    62      -0.833  -2.622   0.448  1.00  3.31           C 
ATOM    982  CG2 VAL    62      -0.222  -3.444  -1.849  1.00 42.44           C 
ATOM    983  H   VAL    62      -3.235  -2.478  -3.047  1.00 37.77           H 
ATOM    984  HA  VAL    62      -2.644  -4.308  -0.796  1.00 31.03           H 
ATOM    985  HB  VAL    62      -1.288  -1.657  -1.392  1.00  0.44           H 
ATOM    986 1HG1 VAL    62       0.137  -2.152   0.530  1.00 37.77           H 
ATOM    987 2HG1 VAL    62      -0.780  -3.625   0.845  1.00 37.77           H 
ATOM    988 3HG1 VAL    62      -1.559  -2.051   1.011  1.00 37.77           H 
ATOM    989 1HG2 VAL    62       0.755  -3.002  -1.710  1.00 37.77           H 
ATOM    990 2HG2 VAL    62      -0.490  -3.398  -2.894  1.00 37.77           H 
ATOM    991 3HG2 VAL    62      -0.198  -4.476  -1.528  1.00 37.77           H 
ATOM    992  N   PHE    63      -4.242  -3.076   0.697  1.00 42.25           N 
ATOM    993  CA  PHE    63      -5.208  -2.377   1.556  1.00 71.33           C 
ATOM    994  C   PHE    63      -4.551  -1.885   2.854  1.00  4.11           C 
ATOM    995  O   PHE    63      -3.566  -2.454   3.326  1.00 42.33           O 
ATOM    996  CB  PHE    63      -6.407  -3.283   1.872  1.00 53.13           C 
ATOM    997  CG  PHE    63      -7.217  -3.655   0.656  1.00 51.20           C 
ATOM    998  CD1 PHE    63      -8.323  -2.898   0.284  1.00 44.31           C 
ATOM    999  CD2 PHE    63      -6.877  -4.758  -0.115  1.00 43.12           C 
ATOM   1000  CE1 PHE    63      -9.068  -3.236  -0.830  1.00 43.11           C 
ATOM   1001  CE2 PHE    63      -7.619  -5.099  -1.230  1.00 45.12           C 
ATOM   1002  CZ  PHE    63      -8.716  -4.336  -1.588  1.00 41.44           C 
ATOM   1003  H   PHE    63      -4.012  -4.008   0.890  1.00 37.77           H 
ATOM   1004  HA  PHE    63      -5.566  -1.513   1.012  1.00 25.10           H 
ATOM   1005 3HB  PHE    63      -7.061  -2.775   2.567  1.00 37.77           H 
ATOM   1006 2HB  PHE    63      -6.051  -4.195   2.324  1.00 37.77           H 
ATOM   1007  HD1 PHE    63      -8.598  -2.034   0.873  1.00 44.25           H 
ATOM   1008  HD2 PHE    63      -6.019  -5.356   0.162  1.00 73.41           H 
ATOM   1009  HE1 PHE    63      -9.925  -2.641  -1.108  1.00 60.40           H 
ATOM   1010  HE2 PHE    63      -7.343  -5.961  -1.822  1.00 21.40           H 
ATOM   1011  HZ  PHE    63      -9.299  -4.603  -2.456  1.00 53.20           H 
ATOM   1012  N   ARG    64      -5.108  -0.822   3.424  1.00 11.24           N 
ATOM   1013  CA  ARG    64      -4.545  -0.182   4.620  1.00 42.15           C 
ATOM   1014  C   ARG    64      -4.949  -0.913   5.915  1.00 63.23           C 
ATOM   1015  O   ARG    64      -5.977  -1.587   5.973  1.00 11.13           O 
ATOM   1016  CB  ARG    64      -5.019   1.280   4.674  1.00 32.21           C 
ATOM   1017  CG  ARG    64      -4.460   2.091   5.842  1.00  0.31           C 
ATOM   1018  CD  ARG    64      -5.049   3.496   5.865  1.00 62.24           C 
ATOM   1019  NE  ARG    64      -4.447   4.343   6.889  1.00 11.41           N 
ATOM   1020  CZ  ARG    64      -4.594   5.640   6.935  1.00 41.21           C 
ATOM   1021  NH1 ARG    64      -5.328   6.255   6.055  1.00 73.44           N 
ATOM   1022  NH2 ARG    64      -4.016   6.316   7.871  1.00  0.32           N 
ATOM   1023  H   ARG    64      -5.924  -0.451   3.027  1.00 37.77           H 
ATOM   1024  HA  ARG    64      -3.468  -0.195   4.531  1.00 73.15           H 
ATOM   1025 3HB  ARG    64      -6.098   1.291   4.742  1.00 37.77           H 
ATOM   1026 2HB  ARG    64      -4.727   1.770   3.757  1.00 37.77           H 
ATOM   1027 3HG  ARG    64      -3.385   2.162   5.739  1.00 37.77           H 
ATOM   1028 2HG  ARG    64      -4.703   1.592   6.769  1.00 37.77           H 
ATOM   1029 3HD  ARG    64      -6.113   3.421   6.055  1.00 37.77           H 
ATOM   1030 2HD  ARG    64      -4.892   3.954   4.899  1.00 37.77           H 
ATOM   1031  HE  ARG    64      -3.900   3.912   7.578  1.00 41.03           H 
ATOM   1032 1HH1 ARG    64      -5.788   5.731   5.333  1.00 37.77           H 
ATOM   1033 2HH1 ARG    64      -5.431   7.244   6.097  1.00 37.77           H 
ATOM   1034 1HH2 ARG    64      -3.460   5.843   8.552  1.00 37.77           H 
ATOM   1035 2HH2 ARG    64      -4.125   7.306   7.914  1.00 37.77           H 
ATOM   1036  N   ILE    65      -4.116  -0.786   6.948  1.00 50.24           N 
ATOM   1037  CA  ILE    65      -4.452  -1.274   8.290  1.00 61.35           C 
ATOM   1038  C   ILE    65      -4.097  -0.224   9.354  1.00 74.43           C 
ATOM   1039  O   ILE    65      -3.009   0.352   9.329  1.00  4.34           O 
ATOM   1040  CB  ILE    65      -3.725  -2.604   8.631  1.00 64.04           C 
ATOM   1041  CG1 ILE    65      -4.199  -3.731   7.702  1.00 13.51           C 
ATOM   1042  CG2 ILE    65      -3.945  -2.984  10.099  1.00 44.23           C 
ATOM   1043  CD1 ILE    65      -3.644  -5.093   8.054  1.00 44.14           C 
ATOM   1044  H   ILE    65      -3.244  -0.362   6.806  1.00 37.77           H 
ATOM   1045  HA  ILE    65      -5.521  -1.452   8.325  1.00 63.23           H 
ATOM   1046  HB  ILE    65      -2.664  -2.451   8.485  1.00 55.23           H 
ATOM   1047 3HG1 ILE    65      -3.897  -3.501   6.689  1.00 37.77           H 
ATOM   1048 2HG1 ILE    65      -5.274  -3.793   7.741  1.00 37.77           H 
ATOM   1049 1HG2 ILE    65      -5.000  -3.149  10.276  1.00 37.77           H 
ATOM   1050 2HG2 ILE    65      -3.593  -2.186  10.737  1.00 37.77           H 
ATOM   1051 3HG2 ILE    65      -3.398  -3.888  10.322  1.00 37.77           H 
ATOM   1052 1HD1 ILE    65      -2.573  -5.092   7.916  1.00 37.77           H 
ATOM   1053 2HD1 ILE    65      -4.089  -5.839   7.413  1.00 37.77           H 
ATOM   1054 3HD1 ILE    65      -3.873  -5.325   9.084  1.00 37.77           H 
ATOM   1055  N   GLU    66      -5.026   0.021  10.275  1.00  3.24           N 
ATOM   1056  CA  GLU    66      -4.794   0.951  11.389  1.00 35.14           C 
ATOM   1057  C   GLU    66      -5.454   0.432  12.677  1.00 71.53           C 
ATOM   1058  O   GLU    66      -6.574  -0.093  12.642  1.00 21.31           O 
ATOM   1059  CB  GLU    66      -5.310   2.358  11.038  1.00 72.02           C 
ATOM   1060  CG  GLU    66      -6.800   2.420  10.720  1.00 62.13           C 
ATOM   1061  CD  GLU    66      -7.292   3.842  10.499  1.00 52.13           C 
ATOM   1062  OE1 GLU    66      -7.626   4.521  11.497  1.00 61.41           O 
ATOM   1063  OE2 GLU    66      -7.356   4.289   9.334  1.00 73.42           O 
ATOM   1064  H   GLU    66      -5.892  -0.435  10.209  1.00 37.77           H 
ATOM   1065  HA  GLU    66      -3.725   1.004  11.553  1.00 15.33           H 
ATOM   1066 3HB  GLU    66      -4.768   2.719  10.174  1.00 37.77           H 
ATOM   1067 2HB  GLU    66      -5.115   3.018  11.870  1.00 37.77           H 
ATOM   1068 3HG  GLU    66      -7.350   1.986  11.544  1.00 37.77           H 
ATOM   1069 2HG  GLU    66      -6.989   1.843   9.825  1.00 37.77           H 
ATOM   1070  N   ASP    67      -4.747   0.561  13.806  1.00 10.10           N 
ATOM   1071  CA  ASP    67      -5.206   0.025  15.098  1.00 44.44           C 
ATOM   1072  C   ASP    67      -5.361  -1.512  15.009  1.00 71.22           C 
ATOM   1073  O   ASP    67      -6.180  -2.126  15.697  1.00 61.33           O 
ATOM   1074  CB  ASP    67      -6.520   0.707  15.523  1.00 62.33           C 
ATOM   1075  CG  ASP    67      -6.935   0.365  16.946  1.00 22.33           C 
ATOM   1076  OD1 ASP    67      -6.167   0.659  17.885  1.00 62.32           O 
ATOM   1077  OD2 ASP    67      -8.038  -0.183  17.138  1.00 71.12           O 
ATOM   1078  H   ASP    67      -3.882   1.026  13.769  1.00 37.77           H 
ATOM   1079  HA  ASP    67      -4.440   0.247  15.831  1.00 53.03           H 
ATOM   1080 3HB  ASP    67      -7.308   0.401  14.849  1.00 37.77           H 
ATOM   1081 2HB  ASP    67      -6.396   1.780  15.456  1.00 37.77           H 
ATOM   1082  N   SER    68      -4.538  -2.118  14.143  1.00 52.34           N 
ATOM   1083  CA  SER    68      -4.540  -3.573  13.891  1.00 70.01           C 
ATOM   1084  C   SER    68      -5.834  -4.039  13.198  1.00 10.10           C 
ATOM   1085  O   SER    68      -6.096  -5.240  13.085  1.00  4.21           O 
ATOM   1086  CB  SER    68      -4.324  -4.359  15.195  1.00 24.13           C 
ATOM   1087  OG  SER    68      -4.150  -5.749  14.939  1.00 12.33           O 
ATOM   1088  H   SER    68      -3.889  -1.563  13.657  1.00 37.77           H 
ATOM   1089  HA  SER    68      -3.713  -3.781  13.224  1.00  5.34           H 
ATOM   1090 3HB  SER    68      -5.181  -4.230  15.839  1.00 37.77           H 
ATOM   1091 2HB  SER    68      -3.439  -3.988  15.696  1.00 37.77           H 
ATOM   1092  HG  SER    68      -5.010  -6.156  14.780  1.00 51.41           H 
ATOM   1093  N   ILE    69      -6.628  -3.085  12.711  1.00 71.43           N 
ATOM   1094  CA  ILE    69      -7.881  -3.395  12.015  1.00 71.30           C 
ATOM   1095  C   ILE    69      -7.687  -3.400  10.487  1.00 24.04           C 
ATOM   1096  O   ILE    69      -7.264  -2.397   9.908  1.00  4.10           O 
ATOM   1097  CB  ILE    69      -8.992  -2.376  12.388  1.00 31.21           C 
ATOM   1098  CG1 ILE    69      -9.216  -2.360  13.910  1.00 75.43           C 
ATOM   1099  CG2 ILE    69     -10.293  -2.691  11.647  1.00 54.22           C 
ATOM   1100  CD1 ILE    69      -9.649  -3.693  14.485  1.00 23.51           C 
ATOM   1101  H   ILE    69      -6.365  -2.148  12.819  1.00 37.77           H 
ATOM   1102  HA  ILE    69      -8.207  -4.377  12.333  1.00 62.42           H 
ATOM   1103  HB  ILE    69      -8.662  -1.395  12.073  1.00 72.12           H 
ATOM   1104 3HG1 ILE    69      -9.981  -1.634  14.147  1.00 37.77           H 
ATOM   1105 2HG1 ILE    69      -8.297  -2.074  14.400  1.00 37.77           H 
ATOM   1106 1HG2 ILE    69     -10.126  -2.636  10.581  1.00 37.77           H 
ATOM   1107 2HG2 ILE    69     -11.052  -1.975  11.929  1.00 37.77           H 
ATOM   1108 3HG2 ILE    69     -10.624  -3.687  11.908  1.00 37.77           H 
ATOM   1109 1HD1 ILE    69      -8.899  -4.442  14.271  1.00 37.77           H 
ATOM   1110 2HD1 ILE    69     -10.588  -3.991  14.042  1.00 37.77           H 
ATOM   1111 3HD1 ILE    69      -9.769  -3.601  15.554  1.00 37.77           H 
ATOM   1112  N   PRO    70      -7.979  -4.536   9.818  1.00 33.43           N 
ATOM   1113  CA  PRO    70      -7.892  -4.639   8.350  1.00  2.23           C 
ATOM   1114  C   PRO    70      -8.915  -3.738   7.639  1.00 62.42           C 
ATOM   1115  O   PRO    70     -10.122  -3.969   7.728  1.00 65.13           O 
ATOM   1116  CB  PRO    70      -8.191  -6.127   8.069  1.00 14.13           C 
ATOM   1117  CG  PRO    70      -8.006  -6.817   9.379  1.00 61.01           C 
ATOM   1118  CD  PRO    70      -8.397  -5.810  10.426  1.00 20.12           C 
ATOM   1119  HA  PRO    70      -6.901  -4.396   8.000  1.00 12.11           H 
ATOM   1120 3HB  PRO    70      -7.503  -6.501   7.325  1.00 37.77           H 
ATOM   1121 2HB  PRO    70      -9.205  -6.234   7.707  1.00 37.77           H 
ATOM   1122 3HG  PRO    70      -6.970  -7.105   9.504  1.00 37.77           H 
ATOM   1123 2HG  PRO    70      -8.647  -7.687   9.430  1.00 37.77           H 
ATOM   1124 3HD  PRO    70      -7.864  -5.993  11.348  1.00 37.77           H 
ATOM   1125 2HD  PRO    70      -9.464  -5.830  10.592  1.00 37.77           H 
ATOM   1126  N   VAL    71      -8.435  -2.708   6.944  1.00 14.33           N 
ATOM   1127  CA  VAL    71      -9.318  -1.778   6.237  1.00 72.31           C 
ATOM   1128  C   VAL    71      -9.582  -2.244   4.789  1.00 33.31           C 
ATOM   1129  O   VAL    71      -8.839  -1.908   3.864  1.00 14.01           O 
ATOM   1130  CB  VAL    71      -8.727  -0.337   6.233  1.00 20.55           C 
ATOM   1131  CG1 VAL    71      -9.682   0.650   5.565  1.00 33.24           C 
ATOM   1132  CG2 VAL    71      -8.384   0.110   7.661  1.00  2.45           C 
ATOM   1133  H   VAL    71      -7.463  -2.568   6.904  1.00 37.77           H 
ATOM   1134  HA  VAL    71     -10.262  -1.751   6.767  1.00 71.43           H 
ATOM   1135  HB  VAL    71      -7.809  -0.352   5.661  1.00 55.33           H 
ATOM   1136 1HG1 VAL    71     -10.623   0.659   6.098  1.00 37.77           H 
ATOM   1137 2HG1 VAL    71      -9.852   0.350   4.541  1.00 37.77           H 
ATOM   1138 3HG1 VAL    71      -9.250   1.640   5.583  1.00 37.77           H 
ATOM   1139 1HG2 VAL    71      -7.640  -0.551   8.081  1.00 37.77           H 
ATOM   1140 2HG2 VAL    71      -9.273   0.082   8.273  1.00 37.77           H 
ATOM   1141 3HG2 VAL    71      -7.995   1.119   7.642  1.00 37.77           H 
ATOM   1142  N   LEU    72     -10.640  -3.037   4.608  1.00 51.13           N 
ATOM   1143  CA  LEU    72     -11.040  -3.533   3.282  1.00 44.22           C 
ATOM   1144  C   LEU    72     -11.863  -2.486   2.502  1.00 70.13           C 
ATOM   1145  O   LEU    72     -12.726  -2.836   1.690  1.00 13.44           O 
ATOM   1146  CB  LEU    72     -11.865  -4.823   3.446  1.00 60.34           C 
ATOM   1147  CG  LEU    72     -11.180  -5.952   4.236  1.00 44.14           C 
ATOM   1148  CD1 LEU    72     -12.108  -7.158   4.372  1.00 55.21           C 
ATOM   1149  CD2 LEU    72      -9.863  -6.353   3.575  1.00  0.43           C 
ATOM   1150  H   LEU    72     -11.158  -3.321   5.392  1.00 37.77           H 
ATOM   1151  HA  LEU    72     -10.142  -3.759   2.723  1.00 52.41           H 
ATOM   1152 3HB  LEU    72     -12.103  -5.198   2.460  1.00 37.77           H 
ATOM   1153 2HB  LEU    72     -12.788  -4.571   3.948  1.00 37.77           H 
ATOM   1154  HG  LEU    72     -10.956  -5.596   5.233  1.00 52.30           H 
ATOM   1155 1HD1 LEU    72     -11.611  -7.936   4.936  1.00 37.77           H 
ATOM   1156 2HD1 LEU    72     -12.366  -7.531   3.391  1.00 37.77           H 
ATOM   1157 3HD1 LEU    72     -13.008  -6.862   4.892  1.00 37.77           H 
ATOM   1158 1HD2 LEU    72      -9.211  -5.492   3.519  1.00 37.77           H 
ATOM   1159 2HD2 LEU    72     -10.053  -6.724   2.578  1.00 37.77           H 
ATOM   1160 3HD2 LEU    72      -9.385  -7.126   4.162  1.00 37.77           H 
ATOM   1161  N   LEU    73     -11.583  -1.205   2.733  1.00 42.34           N 
ATOM   1162  CA  LEU    73     -12.299  -0.115   2.062  1.00 63.31           C 
ATOM   1163  C   LEU    73     -11.632   0.246   0.722  1.00 14.10           C 
ATOM   1164  O   LEU    73     -10.407   0.283   0.622  1.00 53.44           O 
ATOM   1165  CB  LEU    73     -12.357   1.114   2.976  1.00 22.14           C 
ATOM   1166  CG  LEU    73     -13.118   0.913   4.298  1.00  2.32           C 
ATOM   1167  CD1 LEU    73     -13.094   2.187   5.137  1.00 14.20           C 
ATOM   1168  CD2 LEU    73     -14.558   0.471   4.031  1.00 22.41           C 
ATOM   1169  H   LEU    73     -10.866  -0.983   3.361  1.00 37.77           H 
ATOM   1170  HA  LEU    73     -13.309  -0.453   1.869  1.00 23.32           H 
ATOM   1171 3HB  LEU    73     -12.827   1.922   2.435  1.00 37.77           H 
ATOM   1172 2HB  LEU    73     -11.341   1.408   3.212  1.00 37.77           H 
ATOM   1173  HG  LEU    73     -12.632   0.132   4.868  1.00  0.41           H 
ATOM   1174 1HD1 LEU    73     -12.071   2.443   5.372  1.00 37.77           H 
ATOM   1175 2HD1 LEU    73     -13.643   2.025   6.052  1.00 37.77           H 
ATOM   1176 3HD1 LEU    73     -13.549   2.995   4.582  1.00 37.77           H 
ATOM   1177 1HD2 LEU    73     -15.067   0.317   4.970  1.00 37.77           H 
ATOM   1178 2HD2 LEU    73     -14.555  -0.453   3.468  1.00 37.77           H 
ATOM   1179 3HD2 LEU    73     -15.072   1.235   3.465  1.00 37.77           H 
ATOM   1180  N   PRO    74     -12.437   0.539  -0.321  1.00 45.13           N 
ATOM   1181  CA  PRO    74     -11.922   0.757  -1.691  1.00 55.51           C 
ATOM   1182  C   PRO    74     -11.028   2.001  -1.838  1.00 61.22           C 
ATOM   1183  O   PRO    74     -10.082   2.000  -2.625  1.00 11.30           O 
ATOM   1184  CB  PRO    74     -13.202   0.916  -2.526  1.00 13.31           C 
ATOM   1185  CG  PRO    74     -14.240   1.367  -1.553  1.00 34.00           C 
ATOM   1186  CD  PRO    74     -13.906   0.685  -0.257  1.00 25.53           C 
ATOM   1187  HA  PRO    74     -11.376  -0.108  -2.040  1.00  4.41           H 
ATOM   1188 3HB  PRO    74     -13.464  -0.036  -2.971  1.00 37.77           H 
ATOM   1189 2HB  PRO    74     -13.043   1.647  -3.307  1.00 37.77           H 
ATOM   1190 3HG  PRO    74     -15.222   1.069  -1.893  1.00 37.77           H 
ATOM   1191 2HG  PRO    74     -14.196   2.442  -1.438  1.00 37.77           H 
ATOM   1192 3HD  PRO    74     -14.387  -0.280  -0.199  1.00 37.77           H 
ATOM   1193 2HD  PRO    74     -14.197   1.303   0.583  1.00 37.77           H 
ATOM   1194  N   GLU    75     -11.320   3.063  -1.087  1.00  3.03           N 
ATOM   1195  CA  GLU    75     -10.571   4.319  -1.226  1.00 71.11           C 
ATOM   1196  C   GLU    75      -9.237   4.306  -0.451  1.00 10.34           C 
ATOM   1197  O   GLU    75      -8.301   5.025  -0.807  1.00 12.22           O 
ATOM   1198  CB  GLU    75     -11.440   5.538  -0.849  1.00 20.24           C 
ATOM   1199  CG  GLU    75     -12.403   5.324   0.316  1.00 24.44           C 
ATOM   1200  CD  GLU    75     -11.707   5.134   1.647  1.00 52.51           C 
ATOM   1201  OE1 GLU    75     -11.283   6.144   2.253  1.00 42.42           O 
ATOM   1202  OE2 GLU    75     -11.607   3.984   2.103  1.00 33.11           O 
ATOM   1203  H   GLU    75     -12.042   3.000  -0.426  1.00 37.77           H 
ATOM   1204  HA  GLU    75     -10.323   4.408  -2.276  1.00 73.12           H 
ATOM   1205 3HB  GLU    75     -12.022   5.824  -1.714  1.00 37.77           H 
ATOM   1206 2HB  GLU    75     -10.787   6.361  -0.591  1.00 37.77           H 
ATOM   1207 3HG  GLU    75     -13.001   4.446   0.110  1.00 37.77           H 
ATOM   1208 2HG  GLU    75     -13.054   6.183   0.390  1.00 37.77           H 
ATOM   1209  N   GLU    76      -9.146   3.491   0.603  1.00 63.43           N 
ATOM   1210  CA  GLU    76      -7.869   3.292   1.320  1.00  4.41           C 
ATOM   1211  C   GLU    76      -6.981   2.247   0.615  1.00 44.32           C 
ATOM   1212  O   GLU    76      -5.985   1.789   1.180  1.00 31.13           O 
ATOM   1213  CB  GLU    76      -8.119   2.843   2.773  1.00 65.03           C 
ATOM   1214  CG  GLU    76      -8.795   3.887   3.663  1.00 54.24           C 
ATOM   1215  CD  GLU    76      -7.981   5.164   3.841  1.00 14.12           C 
ATOM   1216  OE1 GLU    76      -6.736   5.094   3.887  1.00  3.42           O 
ATOM   1217  OE2 GLU    76      -8.589   6.249   3.963  1.00 42.50           O 
ATOM   1218  H   GLU    76      -9.951   3.029   0.921  1.00 37.77           H 
ATOM   1219  HA  GLU    76      -7.345   4.237   1.334  1.00 64.50           H 
ATOM   1220 3HB  GLU    76      -7.168   2.585   3.221  1.00 37.77           H 
ATOM   1221 2HB  GLU    76      -8.744   1.961   2.760  1.00 37.77           H 
ATOM   1222 3HG  GLU    76      -8.961   3.449   4.638  1.00 37.77           H 
ATOM   1223 2HG  GLU    76      -9.747   4.145   3.224  1.00 37.77           H 
ATOM   1224  N   ALA    77      -7.340   1.878  -0.618  1.00 12.30           N 
ATOM   1225  CA  ALA    77      -6.594   0.865  -1.380  1.00 42.20           C 
ATOM   1226  C   ALA    77      -5.492   1.489  -2.259  1.00 65.14           C 
ATOM   1227  O   ALA    77      -5.654   2.586  -2.805  1.00 10.33           O 
ATOM   1228  CB  ALA    77      -7.552   0.042  -2.236  1.00 12.44           C 
ATOM   1229  H   ALA    77      -8.123   2.293  -1.029  1.00 37.77           H 
ATOM   1230  HA  ALA    77      -6.126   0.194  -0.668  1.00 54.43           H 
ATOM   1231 1HB  ALA    77      -7.969   0.669  -3.011  1.00 37.77           H 
ATOM   1232 2HB  ALA    77      -8.351  -0.342  -1.619  1.00 37.77           H 
ATOM   1233 3HB  ALA    77      -7.019  -0.782  -2.688  1.00 37.77           H 
ATOM   1234  N   ILE    78      -4.373   0.771  -2.383  1.00  5.01           N 
ATOM   1235  CA  ILE    78      -3.228   1.207  -3.192  1.00 44.14           C 
ATOM   1236  C   ILE    78      -2.954   0.218  -4.342  1.00 22.13           C 
ATOM   1237  O   ILE    78      -3.028  -1.000  -4.157  1.00  0.24           O 
ATOM   1238  CB  ILE    78      -1.930   1.325  -2.335  1.00 34.02           C 
ATOM   1239  CG1 ILE    78      -2.106   2.309  -1.161  1.00 55.34           C 
ATOM   1240  CG2 ILE    78      -0.741   1.743  -3.204  1.00 24.14           C 
ATOM   1241  CD1 ILE    78      -2.879   1.752   0.021  1.00  2.44           C 
ATOM   1242  H   ILE    78      -4.314  -0.080  -1.908  1.00 37.77           H 
ATOM   1243  HA  ILE    78      -3.451   2.180  -3.609  1.00 75.11           H 
ATOM   1244  HB  ILE    78      -1.714   0.341  -1.936  1.00 55.21           H 
ATOM   1245 3HG1 ILE    78      -2.627   3.190  -1.510  1.00 37.77           H 
ATOM   1246 2HG1 ILE    78      -1.131   2.601  -0.795  1.00 37.77           H 
ATOM   1247 1HG2 ILE    78       0.144   1.830  -2.588  1.00 37.77           H 
ATOM   1248 2HG2 ILE    78      -0.949   2.693  -3.671  1.00 37.77           H 
ATOM   1249 3HG2 ILE    78      -0.572   0.996  -3.969  1.00 37.77           H 
ATOM   1250 1HD1 ILE    78      -2.382   0.869   0.394  1.00 37.77           H 
ATOM   1251 2HD1 ILE    78      -3.881   1.496  -0.291  1.00 37.77           H 
ATOM   1252 3HD1 ILE    78      -2.928   2.496   0.802  1.00 37.77           H 
ATOM   1253  N   ALA    79      -2.639   0.738  -5.526  1.00 15.14           N 
ATOM   1254  CA  ALA    79      -2.224  -0.104  -6.651  1.00 73.34           C 
ATOM   1255  C   ALA    79      -0.697  -0.301  -6.658  1.00 54.11           C 
ATOM   1256  O   ALA    79       0.061   0.671  -6.666  1.00 24.43           O 
ATOM   1257  CB  ALA    79      -2.696   0.502  -7.968  1.00  2.31           C 
ATOM   1258  H   ALA    79      -2.698   1.709  -5.650  1.00 37.77           H 
ATOM   1259  HA  ALA    79      -2.699  -1.070  -6.538  1.00 72.32           H 
ATOM   1260 1HB  ALA    79      -2.226   1.464  -8.112  1.00 37.77           H 
ATOM   1261 2HB  ALA    79      -3.769   0.628  -7.942  1.00 37.77           H 
ATOM   1262 3HB  ALA    79      -2.431  -0.153  -8.787  1.00 37.77           H 
ATOM   1263  N   THR    80      -0.249  -1.559  -6.666  1.00  4.33           N 
ATOM   1264  CA  THR    80       1.195  -1.878  -6.639  1.00 13.21           C 
ATOM   1265  C   THR    80       1.947  -1.269  -7.833  1.00 34.14           C 
ATOM   1266  O   THR    80       3.151  -1.015  -7.761  1.00 21.40           O 
ATOM   1267  CB  THR    80       1.441  -3.410  -6.622  1.00 73.25           C 
ATOM   1268  OG1 THR    80       0.821  -4.027  -7.764  1.00 41.45           O 
ATOM   1269  CG2 THR    80       0.894  -4.044  -5.346  1.00 34.24           C 
ATOM   1270  H   THR    80      -0.898  -2.297  -6.690  1.00 37.77           H 
ATOM   1271  HA  THR    80       1.604  -1.464  -5.725  1.00 73.11           H 
ATOM   1272  HB  THR    80       2.507  -3.589  -6.666  1.00 13.33           H 
ATOM   1273  HG1 THR    80       1.048  -4.967  -7.781  1.00 44.43           H 
ATOM   1274 1HG2 THR    80      -0.173  -3.892  -5.295  1.00 37.77           H 
ATOM   1275 2HG2 THR    80       1.364  -3.587  -4.485  1.00 37.77           H 
ATOM   1276 3HG2 THR    80       1.108  -5.104  -5.348  1.00 37.77           H 
ATOM   1277  N   ILE    81       1.229  -1.030  -8.927  1.00 63.00           N 
ATOM   1278  CA  ILE    81       1.813  -0.438 -10.140  1.00 63.35           C 
ATOM   1279  C   ILE    81       2.241   1.029  -9.916  1.00 50.03           C 
ATOM   1280  O   ILE    81       3.022   1.590 -10.686  1.00 22.25           O 
ATOM   1281  CB  ILE    81       0.806  -0.514 -11.319  1.00 63.52           C 
ATOM   1282  CG1 ILE    81       1.447  -0.048 -12.641  1.00 24.13           C 
ATOM   1283  CG2 ILE    81      -0.447   0.308 -11.007  1.00 31.10           C 
ATOM   1284  CD1 ILE    81       2.621  -0.898 -13.089  1.00 43.43           C 
ATOM   1285  H   ILE    81       0.281  -1.270  -8.926  1.00 37.77           H 
ATOM   1286  HA  ILE    81       2.687  -1.017 -10.404  1.00 32.10           H 
ATOM   1287  HB  ILE    81       0.501  -1.547 -11.425  1.00 41.01           H 
ATOM   1288 3HG1 ILE    81       1.799   0.968 -12.521  1.00 37.77           H 
ATOM   1289 2HG1 ILE    81       0.707  -0.075 -13.424  1.00 37.77           H 
ATOM   1290 1HG2 ILE    81      -0.176   1.348 -10.884  1.00 37.77           H 
ATOM   1291 2HG2 ILE    81      -0.899  -0.055 -10.096  1.00 37.77           H 
ATOM   1292 3HG2 ILE    81      -1.153   0.216 -11.821  1.00 37.77           H 
ATOM   1293 1HD1 ILE    81       3.020  -0.503 -14.013  1.00 37.77           H 
ATOM   1294 2HD1 ILE    81       2.291  -1.914 -13.246  1.00 37.77           H 
ATOM   1295 3HD1 ILE    81       3.391  -0.882 -12.330  1.00 37.77           H 
ATOM   1296  N   GLN    82       1.724   1.644  -8.854  1.00 41.52           N 
ATOM   1297  CA  GLN    82       2.045   3.039  -8.531  1.00 64.31           C 
ATOM   1298  C   GLN    82       3.299   3.137  -7.638  1.00 61.24           C 
ATOM   1299  O   GLN    82       3.825   4.226  -7.392  1.00 52.43           O 
ATOM   1300  CB  GLN    82       0.836   3.701  -7.843  1.00 71.10           C 
ATOM   1301  CG  GLN    82       1.000   5.194  -7.573  1.00 32.43           C 
ATOM   1302  CD  GLN    82       1.272   6.006  -8.831  1.00 22.33           C 
ATOM   1303  OE1 GLN    82       0.848   5.645  -9.926  1.00  2.42           O 
ATOM   1304  NE2 GLN    82       1.974   7.110  -8.685  1.00 63.23           N 
ATOM   1305  H   GLN    82       1.109   1.150  -8.272  1.00 37.77           H 
ATOM   1306  HA  GLN    82       2.240   3.557  -9.459  1.00  2.24           H 
ATOM   1307 3HB  GLN    82       0.659   3.203  -6.898  1.00 37.77           H 
ATOM   1308 2HB  GLN    82      -0.035   3.567  -8.470  1.00 37.77           H 
ATOM   1309 3HG  GLN    82       1.823   5.331  -6.887  1.00 37.77           H 
ATOM   1310 2HG  GLN    82       0.093   5.564  -7.118  1.00 37.77           H 
ATOM   1311 1HE2 GLN    82       2.279   7.353  -7.785  1.00 37.77           H 
ATOM   1312 2HE2 GLN    82       2.167   7.640  -9.486  1.00 37.77           H 
ATOM   1313  N   ILE    83       3.784   1.992  -7.162  1.00 40.34           N 
ATOM   1314  CA  ILE    83       4.958   1.968  -6.287  1.00 43.32           C 
ATOM   1315  C   ILE    83       6.263   1.930  -7.102  1.00 41.45           C 
ATOM   1316  O   ILE    83       6.732   0.867  -7.510  1.00  4.20           O 
ATOM   1317  CB  ILE    83       4.918   0.760  -5.316  1.00 64.50           C 
ATOM   1318  CG1 ILE    83       3.587   0.738  -4.540  1.00  1.22           C 
ATOM   1319  CG2 ILE    83       6.106   0.804  -4.353  1.00 33.20           C 
ATOM   1320  CD1 ILE    83       3.315   1.994  -3.736  1.00 33.13           C 
ATOM   1321  H   ILE    83       3.352   1.147  -7.408  1.00 37.77           H 
ATOM   1322  HA  ILE    83       4.948   2.874  -5.694  1.00  1.02           H 
ATOM   1323  HB  ILE    83       4.997  -0.145  -5.902  1.00  0.15           H 
ATOM   1324 3HG1 ILE    83       3.591  -0.099  -3.857  1.00 37.77           H 
ATOM   1325 2HG1 ILE    83       2.775   0.615  -5.241  1.00 37.77           H 
ATOM   1326 1HG2 ILE    83       6.053  -0.036  -3.677  1.00 37.77           H 
ATOM   1327 2HG2 ILE    83       6.081   1.723  -3.787  1.00 37.77           H 
ATOM   1328 3HG2 ILE    83       7.030   0.752  -4.916  1.00 37.77           H 
ATOM   1329 1HD1 ILE    83       2.366   1.898  -3.229  1.00 37.77           H 
ATOM   1330 2HD1 ILE    83       3.282   2.847  -4.398  1.00 37.77           H 
ATOM   1331 3HD1 ILE    83       4.099   2.135  -3.008  1.00 37.77           H 
ATOM   1332  N   ALA    84       6.849   3.108  -7.320  1.00 62.23           N 
ATOM   1333  CA  ALA    84       8.081   3.246  -8.118  1.00 22.50           C 
ATOM   1334  C   ALA    84       9.326   2.665  -7.417  1.00 12.21           C 
ATOM   1335  O   ALA    84      10.454   2.901  -7.853  1.00 75.03           O 
ATOM   1336  CB  ALA    84       8.305   4.717  -8.453  1.00 51.53           C 
ATOM   1337  H   ALA    84       6.430   3.914  -6.959  1.00 37.77           H 
ATOM   1338  HA  ALA    84       7.932   2.716  -9.048  1.00 44.15           H 
ATOM   1339 1HB  ALA    84       8.463   5.275  -7.541  1.00 37.77           H 
ATOM   1340 2HB  ALA    84       7.441   5.106  -8.969  1.00 37.77           H 
ATOM   1341 3HB  ALA    84       9.174   4.813  -9.089  1.00 37.77           H 
ATOM   1342  N   ASN    85       9.124   1.907  -6.339  1.00 71.14           N 
ATOM   1343  CA  ASN    85      10.237   1.283  -5.605  1.00 32.24           C 
ATOM   1344  C   ASN    85      10.236  -0.250  -5.772  1.00 12.12           C 
ATOM   1345  O   ASN    85      11.046  -0.950  -5.167  1.00 32.41           O 
ATOM   1346  CB  ASN    85      10.165   1.660  -4.119  1.00  0.52           C 
ATOM   1347  CG  ASN    85      10.415   3.141  -3.888  1.00 45.11           C 
ATOM   1348  OD1 ASN    85      11.544   3.567  -3.672  1.00 43.23           O 
ATOM   1349  ND2 ASN    85       9.369   3.940  -3.934  1.00 73.35           N 
ATOM   1350  H   ASN    85       8.212   1.759  -6.030  1.00 37.77           H 
ATOM   1351  HA  ASN    85      11.160   1.665  -6.016  1.00 40.53           H 
ATOM   1352 3HB  ASN    85      10.909   1.098  -3.573  1.00 37.77           H 
ATOM   1353 2HB  ASN    85       9.182   1.416  -3.738  1.00 37.77           H 
ATOM   1354 1HD2 ASN    85       8.497   3.549  -4.113  1.00 37.77           H 
ATOM   1355 2HD2 ASN    85       9.522   4.897  -3.794  1.00 37.77           H 
ATOM   1356  N   PHE    86       9.324  -0.761  -6.598  1.00 24.23           N 
ATOM   1357  CA  PHE    86       9.263  -2.198  -6.895  1.00 41.53           C 
ATOM   1358  C   PHE    86      10.334  -2.608  -7.924  1.00 52.22           C 
ATOM   1359  O   PHE    86      10.609  -1.871  -8.876  1.00 30.42           O 
ATOM   1360  CB  PHE    86       7.859  -2.583  -7.402  1.00  3.41           C 
ATOM   1361  CG  PHE    86       6.924  -3.080  -6.323  1.00  2.11           C 
ATOM   1362  CD1 PHE    86       6.796  -2.399  -5.123  1.00 13.41           C 
ATOM   1363  CD2 PHE    86       6.175  -4.235  -6.512  1.00 41.54           C 
ATOM   1364  CE1 PHE    86       5.941  -2.854  -4.136  1.00 11.41           C 
ATOM   1365  CE2 PHE    86       5.319  -4.694  -5.527  1.00 64.53           C 
ATOM   1366  CZ  PHE    86       5.204  -4.003  -4.339  1.00 34.02           C 
ATOM   1367  H   PHE    86       8.678  -0.161  -7.023  1.00 37.77           H 
ATOM   1368  HA  PHE    86       9.457  -2.728  -5.971  1.00 51.22           H 
ATOM   1369 3HB  PHE    86       7.954  -3.360  -8.143  1.00 37.77           H 
ATOM   1370 2HB  PHE    86       7.403  -1.717  -7.858  1.00 37.77           H 
ATOM   1371  HD1 PHE    86       7.372  -1.498  -4.962  1.00 71.15           H 
ATOM   1372  HD2 PHE    86       6.265  -4.780  -7.441  1.00  4.41           H 
ATOM   1373  HE1 PHE    86       5.852  -2.311  -3.205  1.00  2.31           H 
ATOM   1374  HE2 PHE    86       4.743  -5.594  -5.687  1.00 42.13           H 
ATOM   1375  HZ  PHE    86       4.536  -4.361  -3.568  1.00  3.31           H 
END
