
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  712),  selected   98 , name 1ue7_C
# Molecule2: number of CA atoms   75 ( 1234),  selected   75 , name T0466.pdb
# PARAMETERS: 1ue7_C.T0466.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_C      -       -           -
LGA    G     3_C      -       -           -
LGA    D     4_C      -       -           -
LGA    T     5_C      -       -           -
LGA    T     6_C      -       -           -
LGA    I     7_C      -       -           -
LGA    T     8_C      -       -           -
LGA    I     9_C      -       -           -
LGA    V    10_C      -       -           -
LGA    G    11_C      L      19          0.613
LGA    N    12_C      K      20          0.405
LGA    L    13_C      F      21          1.636
LGA    T    14_C      S      22          2.300
LGA    A    15_C      A      23          2.032
LGA    D    16_C      L      24          3.904
LGA    P    17_C      R      25          5.564
LGA    E    18_C      R      26          3.704
LGA    L    19_C      E      27          3.210
LGA    R    20_C      V      28          4.273
LGA    F    21_C      R      29          2.422
LGA    T    22_C      I      30          3.270
LGA    P    23_C      Q      31          1.307
LGA    S    24_C      N      32          6.332
LGA    -       -      E      33           -
LGA    -       -      D      34           -
LGA    -       -      G      35           -
LGA    -       -      S      36           -
LGA    -       -      V      37           -
LGA    -       -      S      38           -
LGA    G    25_C      D      39          5.473
LGA    A    26_C      E      40          4.053
LGA    A    27_C      I      41          1.758
LGA    V    28_C      K      42          4.226
LGA    -       -      E      43           -
LGA    A    29_C      R      44          1.423
LGA    N    30_C      T      45          0.828
LGA    F    31_C      Y      46          1.076
LGA    T    32_C      D      47          2.326
LGA    V    33_C      L      48          1.659
LGA    A    34_C      K      49          0.990
LGA    S    35_C      S      50          1.059
LGA    T    36_C      K      51          1.905
LGA    E    51_C      G      52          2.844
LGA    -       -      Q      53           -
LGA    A    52_C      G      54          2.999
LGA    L    53_C      R      55          3.764
LGA    F    54_C      M      56          2.568
LGA    L    55_C      I      57          1.653
LGA    R    56_C      Q      58          0.699
LGA    C    57_C      V      59          0.966
LGA    N    58_C      S      60          0.643
LGA    I    59_C      I      61          0.940
LGA    W    60_C      P      62          1.674
LGA    R    61_C      A      63          1.200
LGA    E    62_C      S      64          3.071
LGA    A    63_C      V      65          0.889
LGA    A    64_C      P      66          3.964
LGA    E    65_C      L      67          3.342
LGA    N    66_C      -       -           -
LGA    V    67_C      -       -           -
LGA    A    68_C      K      68          3.779
LGA    E    69_C      E      69          3.125
LGA    S    70_C      -       -           -
LGA    L    71_C      F      70          2.259
LGA    T    72_C      D      71          3.642
LGA    R    73_C      Y      72          3.017
LGA    G    74_C      N      73          1.661
LGA    A    75_C      A      74          1.801
LGA    R    76_C      R      75          1.373
LGA    V    77_C      V      76          0.872
LGA    I    78_C      E      77          0.589
LGA    V    79_C      L      78          1.458
LGA    S    80_C      I      79          3.460
LGA    G    81_C      N      80          3.522
LGA    R    82_C      P      81           #
LGA    L    83_C      I      82          3.231
LGA    K    84_C      -       -           -
LGA    Q    85_C      -       -           -
LGA    R    91_C      -       -           -
LGA    E    92_C      -       -           -
LGA    G    93_C      -       -           -
LGA    E    94_C      -       -           -
LGA    K    95_C      -       -           -
LGA    R    96_C      -       -           -
LGA    T    97_C      -       -           -
LGA    V    98_C      -       -           -
LGA    I    99_C      W      98          3.178
LGA    E   100_C      Y      99          1.030
LGA    V   101_C      I     100          1.002
LGA    E   102_C      K     101          0.901
LGA    V   103_C      A     102          0.977
LGA    D   104_C      D     103          0.516
LGA    E   105_C      D     104          1.976
LGA    I   106_C      I     105          1.128
LGA    G   107_C      V     106          0.750
LGA    P   108_C      L     107          2.005
LGA    S   109_C      T     108          2.279
LGA    L   110_C      -       -           -
LGA    R   111_C      -       -           -
LGA    Y   112_C      -       -           -
LGA    A   113_C      -       -           -
LGA    T   114_C      -       -           -
LGA    A   115_C      -       -           -
LGA    K   116_C      -       -           -
LGA    V   117_C      -       -           -
LGA    N   118_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   75    5.0     66    2.63    13.64     60.995     2.419

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.787340 * X  +   0.615041 * Y  +  -0.042660 * Z  + -33.203991
  Y_new =  -0.483287 * X  +  -0.572751 * Y  +   0.662111 * Z  + -20.636852
  Z_new =   0.382792 * X  +   0.541923 * Y  +   0.748191 * Z  + -171.599899 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.626857   -2.514736  [ DEG:    35.9162   -144.0838 ]
  Theta =  -0.392817   -2.748776  [ DEG:   -22.5067   -157.4933 ]
  Phi   =  -2.591072    0.550521  [ DEG:  -148.4575     31.5425 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue7_C                                        
REMARK     2: T0466.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue7_C.T0466.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   75   5.0   66   2.63   13.64  60.995
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue7_C
HEADER    DNA BINDING PROTEIN                     09-MAY-03   1UE7              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE7    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE7    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 3.20 ANGSTROMS.                                          
DBREF  1UE7 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 C    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 D    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 C  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 C  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 C  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 C  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 C  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 C  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 C  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 C  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 C  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 C  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 C  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 C  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 C  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 D  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 D  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 D  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 D  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 D  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 D  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 D  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 D  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 D  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 D  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 D  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 D  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 D  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
FORMUL   5  HOH   *183(H2 O)                                                    
CRYST1   60.223  116.720  177.885  90.00  90.00  90.00 I 21 21 21   32          
ATOM   1466  N   ALA C   2       3.112  -2.435 -25.098  1.00 88.86           N  
ATOM   1467  CA  ALA C   2       2.247  -3.128 -24.105  1.00 88.86           C  
ATOM   1468  C   ALA C   2       2.224  -2.442 -22.730  1.00 88.86           C  
ATOM   1469  O   ALA C   2       1.453  -1.503 -22.517  1.00 88.86           O  
ATOM   1470  CB  ALA C   2       2.687  -4.587 -23.958  1.00 27.10           C  
ATOM   1471  N   GLY C   3       3.081  -2.887 -21.810  1.00101.61           N  
ATOM   1472  CA  GLY C   3       3.076  -2.329 -20.462  1.00101.61           C  
ATOM   1473  C   GLY C   3       1.834  -2.969 -19.871  1.00101.61           C  
ATOM   1474  O   GLY C   3       0.792  -2.323 -19.735  1.00101.61           O  
ATOM   1475  N   ASP C   4       1.956  -4.247 -19.508  1.00101.61           N  
ATOM   1476  CA  ASP C   4       0.813  -5.022 -19.036  1.00101.61           C  
ATOM   1477  C   ASP C   4       0.530  -5.418 -17.589  1.00101.61           C  
ATOM   1478  O   ASP C   4       1.166  -4.960 -16.633  1.00101.61           O  
ATOM   1479  CB  ASP C   4       0.704  -6.286 -19.893  1.00101.61           C  
ATOM   1480  CG  ASP C   4      -0.582  -6.333 -20.691  1.00101.61           C  
ATOM   1481  OD1 ASP C   4      -0.856  -5.367 -21.443  1.00101.61           O  
ATOM   1482  OD2 ASP C   4      -1.318  -7.335 -20.563  1.00101.61           O  
ATOM   1483  N   THR C   5      -0.462  -6.310 -17.500  1.00 91.53           N  
ATOM   1484  CA  THR C   5      -1.046  -6.870 -16.285  1.00 91.53           C  
ATOM   1485  C   THR C   5      -1.439  -5.746 -15.354  1.00 91.53           C  
ATOM   1486  O   THR C   5      -1.183  -5.790 -14.152  1.00 91.53           O  
ATOM   1487  CB  THR C   5      -0.127  -7.887 -15.565  1.00101.48           C  
ATOM   1488  OG1 THR C   5      -0.871  -8.520 -14.517  1.00101.48           O  
ATOM   1489  CG2 THR C   5       1.097  -7.211 -14.970  1.00101.48           C  
ATOM   1490  N   THR C   6      -2.071  -4.737 -15.953  1.00 52.93           N  
ATOM   1491  CA  THR C   6      -2.557  -3.557 -15.252  1.00 52.93           C  
ATOM   1492  C   THR C   6      -3.995  -3.792 -14.777  1.00 52.93           C  
ATOM   1493  O   THR C   6      -4.776  -4.475 -15.449  1.00 52.93           O  
ATOM   1494  CB  THR C   6      -2.537  -2.337 -16.178  1.00 58.53           C  
ATOM   1495  OG1 THR C   6      -3.117  -2.692 -17.441  1.00 58.53           O  
ATOM   1496  CG2 THR C   6      -1.120  -1.859 -16.390  1.00 58.53           C  
ATOM   1497  N   ILE C   7      -4.339  -3.221 -13.624  1.00 24.11           N  
ATOM   1498  CA  ILE C   7      -5.677  -3.381 -13.071  1.00 24.11           C  
ATOM   1499  C   ILE C   7      -6.177  -2.140 -12.345  1.00 24.11           C  
ATOM   1500  O   ILE C   7      -5.390  -1.337 -11.841  1.00 24.11           O  
ATOM   1501  CB  ILE C   7      -5.713  -4.514 -12.042  1.00 26.93           C  
ATOM   1502  CG1 ILE C   7      -7.148  -4.742 -11.551  1.00 26.93           C  
ATOM   1503  CG2 ILE C   7      -4.857  -4.138 -10.844  1.00 26.93           C  
ATOM   1504  CD1 ILE C   7      -7.281  -5.807 -10.475  1.00 26.93           C  
ATOM   1505  N   THR C   8      -7.495  -1.982 -12.302  1.00 25.25           N  
ATOM   1506  CA  THR C   8      -8.092  -0.883 -11.559  1.00 25.25           C  
ATOM   1507  C   THR C   8      -9.025  -1.528 -10.550  1.00 25.25           C  
ATOM   1508  O   THR C   8      -9.846  -2.389 -10.903  1.00 25.25           O  
ATOM   1509  CB  THR C   8      -8.887   0.074 -12.446  1.00 25.52           C  
ATOM   1510  OG1 THR C   8      -7.974   0.895 -13.175  1.00 25.52           O  
ATOM   1511  CG2 THR C   8      -9.760   0.977 -11.599  1.00 25.52           C  
ATOM   1512  N   ILE C   9      -8.876  -1.127  -9.290  1.00 45.92           N  
ATOM   1513  CA  ILE C   9      -9.691  -1.675  -8.220  1.00 45.92           C  
ATOM   1514  C   ILE C   9     -10.488  -0.574  -7.548  1.00 45.92           C  
ATOM   1515  O   ILE C   9     -10.085   0.598  -7.530  1.00 45.92           O  
ATOM   1516  CB  ILE C   9      -8.829  -2.373  -7.130  1.00 59.41           C  
ATOM   1517  CG1 ILE C   9      -7.867  -3.382  -7.759  1.00 59.41           C  
ATOM   1518  CG2 ILE C   9      -9.723  -3.113  -6.163  1.00 59.41           C  
ATOM   1519  CD1 ILE C   9      -6.627  -2.769  -8.351  1.00 59.41           C  
ATOM   1520  N   VAL C  10     -11.629  -0.968  -7.002  1.00 70.86           N  
ATOM   1521  CA  VAL C  10     -12.498  -0.058  -6.287  1.00 70.86           C  
ATOM   1522  C   VAL C  10     -12.973  -0.800  -5.051  1.00 70.86           C  
ATOM   1523  O   VAL C  10     -13.424  -1.953  -5.128  1.00 70.86           O  
ATOM   1524  CB  VAL C  10     -13.700   0.347  -7.140  1.00 24.32           C  
ATOM   1525  CG1 VAL C  10     -14.517   1.395  -6.425  1.00 24.32           C  
ATOM   1526  CG2 VAL C  10     -13.212   0.873  -8.486  1.00 24.32           C  
ATOM   1527  N   GLY C  11     -12.843  -0.146  -3.907  1.00 45.41           N  
ATOM   1528  CA  GLY C  11     -13.249  -0.768  -2.666  1.00 45.41           C  
ATOM   1529  C   GLY C  11     -12.793   0.040  -1.468  1.00 45.41           C  
ATOM   1530  O   GLY C  11     -12.198   1.115  -1.610  1.00 45.41           O  
ATOM   1531  N   ASN C  12     -13.079  -0.485  -0.283  1.00 45.85           N  
ATOM   1532  CA  ASN C  12     -12.720   0.178   0.951  1.00 45.85           C  
ATOM   1533  C   ASN C  12     -11.536  -0.520   1.583  1.00 45.85           C  
ATOM   1534  O   ASN C  12     -11.315  -1.711   1.378  1.00 45.85           O  
ATOM   1535  CB  ASN C  12     -13.905   0.153   1.903  1.00 60.76           C  
ATOM   1536  CG  ASN C  12     -15.188   0.555   1.227  1.00 60.76           C  
ATOM   1537  OD1 ASN C  12     -15.394   1.726   0.885  1.00 60.76           O  
ATOM   1538  ND2 ASN C  12     -16.058  -0.421   1.006  1.00 60.76           N  
ATOM   1539  N   LEU C  13     -10.768   0.234   2.350  1.00 32.14           N  
ATOM   1540  CA  LEU C  13      -9.610  -0.316   3.023  1.00 32.14           C  
ATOM   1541  C   LEU C  13     -10.044  -1.181   4.212  1.00 32.14           C  
ATOM   1542  O   LEU C  13     -10.913  -0.801   5.010  1.00 32.14           O  
ATOM   1543  CB  LEU C  13      -8.696   0.813   3.503  1.00 50.85           C  
ATOM   1544  CG  LEU C  13      -8.091   1.667   2.395  1.00 50.85           C  
ATOM   1545  CD1 LEU C  13      -7.214   2.754   2.993  1.00 50.85           C  
ATOM   1546  CD2 LEU C  13      -7.294   0.769   1.482  1.00 50.85           C  
ATOM   1547  N   THR C  14      -9.436  -2.356   4.318  1.00 73.65           N  
ATOM   1548  CA  THR C  14      -9.744  -3.262   5.407  1.00 73.65           C  
ATOM   1549  C   THR C  14      -9.350  -2.613   6.722  1.00 73.65           C  
ATOM   1550  O   THR C  14     -10.016  -2.799   7.740  1.00 73.65           O  
ATOM   1551  CB  THR C  14      -8.992  -4.574   5.238  1.00 21.98           C  
ATOM   1552  OG1 THR C  14      -7.635  -4.300   4.882  1.00 21.98           O  
ATOM   1553  CG2 THR C  14      -9.623  -5.393   4.141  1.00 21.98           C  
ATOM   1554  N   ALA C  15      -8.265  -1.848   6.691  1.00 71.10           N  
ATOM   1555  CA  ALA C  15      -7.765  -1.157   7.874  1.00 71.10           C  
ATOM   1556  C   ALA C  15      -6.981   0.049   7.407  1.00 71.10           C  
ATOM   1557  O   ALA C  15      -6.970   0.363   6.222  1.00 71.10           O  
ATOM   1558  CB  ALA C  15      -6.866  -2.077   8.686  1.00 75.93           C  
ATOM   1559  N   ASP C  16      -6.321   0.724   8.340  1.00 48.97           N  
ATOM   1560  CA  ASP C  16      -5.523   1.900   8.000  1.00 48.97           C  
ATOM   1561  C   ASP C  16      -4.236   1.457   7.295  1.00 48.97           C  
ATOM   1562  O   ASP C  16      -3.738   0.358   7.516  1.00 48.97           O  
ATOM   1563  CB  ASP C  16      -5.198   2.713   9.267  1.00101.33           C  
ATOM   1564  CG  ASP C  16      -6.453   3.178  10.007  1.00101.33           C  
ATOM   1565  OD1 ASP C  16      -6.335   3.993  10.950  1.00101.33           O  
ATOM   1566  OD2 ASP C  16      -7.558   2.721   9.647  1.00101.33           O  
ATOM   1567  N   PRO C  17      -3.690   2.304   6.425  1.00 56.65           N  
ATOM   1568  CA  PRO C  17      -2.466   1.929   5.720  1.00 56.65           C  
ATOM   1569  C   PRO C  17      -1.275   1.735   6.648  1.00 56.65           C  
ATOM   1570  O   PRO C  17      -1.020   2.564   7.516  1.00 56.65           O  
ATOM   1571  CB  PRO C  17      -2.260   3.092   4.759  1.00 64.32           C  
ATOM   1572  CG  PRO C  17      -3.645   3.573   4.514  1.00 64.32           C  
ATOM   1573  CD  PRO C  17      -4.238   3.555   5.892  1.00 64.32           C  
ATOM   1574  N   GLU C  18      -0.540   0.642   6.461  1.00 50.29           N  
ATOM   1575  CA  GLU C  18       0.634   0.368   7.283  1.00 50.29           C  
ATOM   1576  C   GLU C  18       1.861   0.973   6.626  1.00 50.29           C  
ATOM   1577  O   GLU C  18       2.151   0.696   5.463  1.00 50.29           O  
ATOM   1578  CB  GLU C  18       0.821  -1.139   7.451  1.00100.65           C  
ATOM   1579  CG  GLU C  18      -0.388  -1.852   8.043  1.00100.65           C  
ATOM   1580  CD  GLU C  18      -0.045  -3.226   8.609  1.00100.65           C  
ATOM   1581  OE1 GLU C  18      -0.982  -3.981   8.953  1.00100.65           O  
ATOM   1582  OE2 GLU C  18       1.159  -3.552   8.720  1.00100.65           O  
ATOM   1583  N   LEU C  19       2.585   1.798   7.374  1.00 92.01           N  
ATOM   1584  CA  LEU C  19       3.771   2.457   6.842  1.00 92.01           C  
ATOM   1585  C   LEU C  19       5.089   1.845   7.317  1.00 92.01           C  
ATOM   1586  O   LEU C  19       5.214   1.423   8.468  1.00 92.01           O  
ATOM   1587  CB  LEU C  19       3.744   3.934   7.213  1.00 27.05           C  
ATOM   1588  CG  LEU C  19       4.151   4.868   6.080  1.00 27.05           C  
ATOM   1589  CD1 LEU C  19       4.295   6.275   6.616  1.00 27.05           C  
ATOM   1590  CD2 LEU C  19       5.449   4.395   5.473  1.00 27.05           C  
ATOM   1591  N   ARG C  20       6.073   1.820   6.418  1.00 48.25           N  
ATOM   1592  CA  ARG C  20       7.396   1.262   6.713  1.00 48.25           C  
ATOM   1593  C   ARG C  20       8.465   1.856   5.790  1.00 48.25           C  
ATOM   1594  O   ARG C  20       8.144   2.419   4.738  1.00 48.25           O  
ATOM   1595  CB  ARG C  20       7.369  -0.270   6.562  1.00 46.61           C  
ATOM   1596  N   PHE C  21       9.730   1.731   6.196  1.00 77.61           N  
ATOM   1597  CA  PHE C  21      10.858   2.246   5.412  1.00 77.61           C  
ATOM   1598  C   PHE C  21      11.938   1.165   5.308  1.00 77.61           C  
ATOM   1599  O   PHE C  21      11.635   0.017   4.988  1.00 77.61           O  
ATOM   1600  CB  PHE C  21      11.473   3.490   6.074  1.00 52.28           C  
ATOM   1601  CG  PHE C  21      10.480   4.559   6.449  1.00 52.28           C  
ATOM   1602  CD1 PHE C  21       9.540   4.339   7.454  1.00 52.28           C  
ATOM   1603  CD2 PHE C  21      10.514   5.805   5.825  1.00 52.28           C  
ATOM   1604  CE1 PHE C  21       8.647   5.348   7.839  1.00 52.28           C  
ATOM   1605  CE2 PHE C  21       9.632   6.821   6.197  1.00 52.28           C  
ATOM   1606  CZ  PHE C  21       8.697   6.591   7.207  1.00 52.28           C  
ATOM   1607  N   THR C  22      13.192   1.562   5.551  1.00101.61           N  
ATOM   1608  CA  THR C  22      14.366   0.673   5.578  1.00101.61           C  
ATOM   1609  C   THR C  22      15.056   0.248   4.256  1.00101.61           C  
ATOM   1610  O   THR C  22      14.521   0.486   3.171  1.00101.61           O  
ATOM   1611  CB  THR C  22      14.044  -0.578   6.458  1.00101.61           C  
ATOM   1612  OG1 THR C  22      13.008  -1.362   5.857  1.00101.61           O  
ATOM   1613  CG2 THR C  22      13.612  -0.146   7.856  1.00101.61           C  
ATOM   1614  N   PRO C  23      16.250  -0.400   4.345  1.00101.61           N  
ATOM   1615  CA  PRO C  23      17.090  -0.891   3.256  1.00101.61           C  
ATOM   1616  C   PRO C  23      16.951  -0.257   1.889  1.00101.61           C  
ATOM   1617  O   PRO C  23      16.877  -0.941   0.866  1.00101.61           O  
ATOM   1618  CB  PRO C  23      16.806  -2.383   3.286  1.00101.61           C  
ATOM   1619  CG  PRO C  23      16.726  -2.647   4.832  1.00101.61           C  
ATOM   1620  CD  PRO C  23      16.548  -1.258   5.498  1.00101.61           C  
ATOM   1621  N   SER C  24      16.971   1.069   1.909  1.00101.61           N  
ATOM   1622  CA  SER C  24      16.857   1.926   0.737  1.00101.61           C  
ATOM   1623  C   SER C  24      16.632   3.283   1.367  1.00101.61           C  
ATOM   1624  O   SER C  24      17.110   4.310   0.881  1.00101.61           O  
ATOM   1625  CB  SER C  24      15.619   1.578  -0.102  1.00101.61           C  
ATOM   1626  OG  SER C  24      15.676   0.277  -0.656  1.00101.61           O  
ATOM   1627  N   GLY C  25      15.908   3.249   2.482  1.00101.61           N  
ATOM   1628  CA  GLY C  25      15.551   4.456   3.197  1.00101.61           C  
ATOM   1629  C   GLY C  25      14.227   4.878   2.595  1.00101.61           C  
ATOM   1630  O   GLY C  25      13.776   6.014   2.761  1.00101.61           O  
ATOM   1631  N   ALA C  26      13.611   3.933   1.887  1.00 91.93           N  
ATOM   1632  CA  ALA C  26      12.339   4.151   1.202  1.00 91.93           C  
ATOM   1633  C   ALA C  26      11.133   4.064   2.128  1.00 91.93           C  
ATOM   1634  O   ALA C  26      11.247   3.588   3.252  1.00 91.93           O  
ATOM   1635  CB  ALA C  26      12.189   3.139   0.084  1.00 64.79           C  
ATOM   1636  N   ALA C  27       9.982   4.529   1.640  1.00 91.98           N  
ATOM   1637  CA  ALA C  27       8.730   4.496   2.393  1.00 91.98           C  
ATOM   1638  C   ALA C  27       7.788   3.499   1.718  1.00 91.98           C  
ATOM   1639  O   ALA C  27       7.317   3.730   0.609  1.00 91.98           O  
ATOM   1640  CB  ALA C  27       8.095   5.888   2.426  1.00 29.73           C  
ATOM   1641  N   VAL C  28       7.515   2.393   2.393  1.00 61.44           N  
ATOM   1642  CA  VAL C  28       6.657   1.365   1.832  1.00 61.44           C  
ATOM   1643  C   VAL C  28       5.330   1.203   2.559  1.00 61.44           C  
ATOM   1644  O   VAL C  28       5.225   0.419   3.497  1.00 61.44           O  
ATOM   1645  CB  VAL C  28       7.360  -0.006   1.842  1.00 77.30           C  
ATOM   1646  CG1 VAL C  28       6.542  -1.015   1.056  1.00 77.30           C  
ATOM   1647  CG2 VAL C  28       8.756   0.120   1.274  1.00 77.30           C  
ATOM   1648  N   ALA C  29       4.320   1.939   2.112  1.00 40.39           N  
ATOM   1649  CA  ALA C  29       2.993   1.859   2.702  1.00 40.39           C  
ATOM   1650  C   ALA C  29       2.256   0.697   2.068  1.00 40.39           C  
ATOM   1651  O   ALA C  29       2.241   0.558   0.848  1.00 40.39           O  
ATOM   1652  CB  ALA C  29       2.226   3.155   2.460  1.00 70.69           C  
ATOM   1653  N   ASN C  30       1.664  -0.148   2.902  1.00 48.35           N  
ATOM   1654  CA  ASN C  30       0.905  -1.301   2.429  1.00 48.35           C  
ATOM   1655  C   ASN C  30      -0.528  -1.128   2.895  1.00 48.35           C  
ATOM   1656  O   ASN C  30      -0.847  -0.170   3.584  1.00 48.35           O  
ATOM   1657  CB  ASN C  30       1.475  -2.611   2.992  1.00 88.42           C  
ATOM   1658  CG  ASN C  30       2.808  -2.987   2.370  1.00 88.42           C  
ATOM   1659  OD1 ASN C  30       3.762  -2.211   2.400  1.00 88.42           O  
ATOM   1660  ND2 ASN C  30       2.880  -4.187   1.808  1.00 88.42           N  
ATOM   1661  N   PHE C  31      -1.387  -2.060   2.514  1.00 47.31           N  
ATOM   1662  CA  PHE C  31      -2.792  -2.015   2.880  1.00 47.31           C  
ATOM   1663  C   PHE C  31      -3.533  -2.873   1.889  1.00 47.31           C  
ATOM   1664  O   PHE C  31      -3.088  -3.023   0.755  1.00 47.31           O  
ATOM   1665  CB  PHE C  31      -3.333  -0.596   2.785  1.00 45.94           C  
ATOM   1666  CG  PHE C  31      -3.266  -0.018   1.407  1.00 45.94           C  
ATOM   1667  CD1 PHE C  31      -2.075   0.471   0.894  1.00 45.94           C  
ATOM   1668  CD2 PHE C  31      -4.400   0.027   0.618  1.00 45.94           C  
ATOM   1669  CE1 PHE C  31      -2.010   0.994  -0.386  1.00 45.94           C  
ATOM   1670  CE2 PHE C  31      -4.349   0.550  -0.670  1.00 45.94           C  
ATOM   1671  CZ  PHE C  31      -3.150   1.035  -1.173  1.00 45.94           C  
ATOM   1672  N   THR C  32      -4.665  -3.430   2.299  1.00 23.35           N  
ATOM   1673  CA  THR C  32      -5.428  -4.261   1.386  1.00 23.35           C  
ATOM   1674  C   THR C  32      -6.833  -3.690   1.170  1.00 23.35           C  
ATOM   1675  O   THR C  32      -7.485  -3.241   2.119  1.00 23.35           O  
ATOM   1676  CB  THR C  32      -5.498  -5.724   1.886  1.00  8.28           C  
ATOM   1677  OG1 THR C  32      -6.831  -6.020   2.322  1.00  8.28           O  
ATOM   1678  CG2 THR C  32      -4.509  -5.942   3.036  1.00  8.28           C  
ATOM   1679  N   VAL C  33      -7.260  -3.682  -0.096  1.00 29.73           N  
ATOM   1680  CA  VAL C  33      -8.567  -3.170  -0.501  1.00 29.73           C  
ATOM   1681  C   VAL C  33      -9.575  -4.312  -0.496  1.00 29.73           C  
ATOM   1682  O   VAL C  33      -9.233  -5.445  -0.854  1.00 29.73           O  
ATOM   1683  CB  VAL C  33      -8.510  -2.576  -1.933  1.00 29.08           C  
ATOM   1684  CG1 VAL C  33      -9.834  -1.912  -2.297  1.00 29.08           C  
ATOM   1685  CG2 VAL C  33      -7.386  -1.574  -2.027  1.00 29.08           C  
ATOM   1686  N   ALA C  34     -10.808  -4.024  -0.080  1.00 45.76           N  
ATOM   1687  CA  ALA C  34     -11.863  -5.031  -0.052  1.00 45.76           C  
ATOM   1688  C   ALA C  34     -12.905  -4.647  -1.097  1.00 45.76           C  
ATOM   1689  O   ALA C  34     -13.611  -3.651  -0.950  1.00 45.76           O  
ATOM   1690  CB  ALA C  34     -12.493  -5.095   1.323  1.00 97.04           C  
ATOM   1691  N   SER C  35     -12.990  -5.435  -2.160  1.00 54.11           N  
ATOM   1692  CA  SER C  35     -13.934  -5.161  -3.233  1.00 54.11           C  
ATOM   1693  C   SER C  35     -15.242  -5.926  -3.018  1.00 54.11           C  
ATOM   1694  O   SER C  35     -15.233  -7.145  -2.812  1.00 54.11           O  
ATOM   1695  CB  SER C  35     -13.305  -5.542  -4.575  1.00 55.20           C  
ATOM   1696  OG  SER C  35     -14.149  -5.224  -5.666  1.00 55.20           O  
ATOM   1697  N   THR C  36     -16.356  -5.189  -3.066  1.00101.61           N  
ATOM   1698  CA  THR C  36     -17.716  -5.721  -2.879  1.00101.61           C  
ATOM   1699  C   THR C  36     -17.859  -6.713  -1.727  1.00101.61           C  
ATOM   1700  O   THR C  36     -16.930  -6.799  -0.899  1.00101.61           O  
ATOM   1701  CB  THR C  36     -18.269  -6.386  -4.173  1.00 86.42           C  
ATOM   1702  OG1 THR C  36     -17.379  -7.425  -4.604  1.00 86.42           O  
ATOM   1703  CG2 THR C  36     -18.424  -5.352  -5.285  1.00 86.42           C  
ATOM   1704  N   GLU C  51     -18.241 -12.860  -4.559  1.00100.27           N  
ATOM   1705  CA  GLU C  51     -18.291 -11.563  -3.822  1.00100.27           C  
ATOM   1706  C   GLU C  51     -17.091 -11.411  -2.882  1.00100.27           C  
ATOM   1707  O   GLU C  51     -16.470 -12.401  -2.488  1.00100.27           O  
ATOM   1708  CB  GLU C  51     -19.593 -11.473  -3.032  1.00 91.20           C  
ATOM   1709  N   ALA C  52     -16.770 -10.165  -2.537  1.00101.61           N  
ATOM   1710  CA  ALA C  52     -15.655  -9.847  -1.639  1.00101.61           C  
ATOM   1711  C   ALA C  52     -14.288 -10.368  -2.093  1.00101.61           C  
ATOM   1712  O   ALA C  52     -13.919 -11.502  -1.798  1.00101.61           O  
ATOM   1713  CB  ALA C  52     -15.960 -10.360  -0.226  1.00 39.00           C  
ATOM   1714  N   LEU C  53     -13.538  -9.528  -2.801  1.00 55.61           N  
ATOM   1715  CA  LEU C  53     -12.206  -9.886  -3.283  1.00 55.61           C  
ATOM   1716  C   LEU C  53     -11.247  -9.116  -2.382  1.00 55.61           C  
ATOM   1717  O   LEU C  53     -11.526  -7.979  -2.026  1.00 55.61           O  
ATOM   1718  CB  LEU C  53     -12.043  -9.433  -4.736  1.00 34.58           C  
ATOM   1719  CG  LEU C  53     -10.904  -9.944  -5.624  1.00 34.58           C  
ATOM   1720  CD1 LEU C  53     -10.565  -8.816  -6.601  1.00 34.58           C  
ATOM   1721  CD2 LEU C  53      -9.664 -10.321  -4.823  1.00 34.58           C  
ATOM   1722  N   PHE C  54     -10.128  -9.722  -2.001  1.00 49.08           N  
ATOM   1723  CA  PHE C  54      -9.175  -9.037  -1.128  1.00 49.08           C  
ATOM   1724  C   PHE C  54      -7.774  -8.933  -1.711  1.00 49.08           C  
ATOM   1725  O   PHE C  54      -6.989  -9.874  -1.618  1.00 49.08           O  
ATOM   1726  CB  PHE C  54      -9.061  -9.742   0.225  1.00101.34           C  
ATOM   1727  CG  PHE C  54     -10.343  -9.811   0.988  1.00101.34           C  
ATOM   1728  CD1 PHE C  54     -11.351 -10.693   0.603  1.00101.34           C  
ATOM   1729  CD2 PHE C  54     -10.542  -9.010   2.104  1.00101.34           C  
ATOM   1730  CE1 PHE C  54     -12.541 -10.779   1.321  1.00101.34           C  
ATOM   1731  CE2 PHE C  54     -11.725  -9.087   2.829  1.00101.34           C  
ATOM   1732  CZ  PHE C  54     -12.728  -9.976   2.437  1.00101.34           C  
ATOM   1733  N   LEU C  55      -7.447  -7.785  -2.288  1.00 71.07           N  
ATOM   1734  CA  LEU C  55      -6.119  -7.588  -2.856  1.00 71.07           C  
ATOM   1735  C   LEU C  55      -5.257  -6.722  -1.940  1.00 71.07           C  
ATOM   1736  O   LEU C  55      -5.647  -5.614  -1.557  1.00 71.07           O  
ATOM   1737  CB  LEU C  55      -6.220  -6.924  -4.226  1.00 54.96           C  
ATOM   1738  CG  LEU C  55      -7.143  -7.609  -5.232  1.00 54.96           C  
ATOM   1739  CD1 LEU C  55      -7.230  -6.779  -6.512  1.00 54.96           C  
ATOM   1740  CD2 LEU C  55      -6.631  -9.010  -5.528  1.00 54.96           C  
ATOM   1741  N   ARG C  56      -4.086  -7.232  -1.580  1.00 51.79           N  
ATOM   1742  CA  ARG C  56      -3.179  -6.480  -0.730  1.00 51.79           C  
ATOM   1743  C   ARG C  56      -2.345  -5.611  -1.674  1.00 51.79           C  
ATOM   1744  O   ARG C  56      -1.809  -6.105  -2.665  1.00 51.79           O  
ATOM   1745  CB  ARG C  56      -2.303  -7.441   0.092  1.00101.61           C  
ATOM   1746  CG  ARG C  56      -2.413  -8.937  -0.291  1.00101.61           C  
ATOM   1747  CD  ARG C  56      -3.786  -9.584   0.006  1.00101.61           C  
ATOM   1748  NE  ARG C  56      -4.131  -9.629   1.433  1.00101.61           N  
ATOM   1749  CZ  ARG C  56      -5.200 -10.249   1.940  1.00101.61           C  
ATOM   1750  NH1 ARG C  56      -6.047 -10.892   1.145  1.00101.61           N  
ATOM   1751  NH2 ARG C  56      -5.436 -10.223   3.246  1.00101.61           N  
ATOM   1752  N   CYS C  57      -2.262  -4.315  -1.384  1.00 44.86           N  
ATOM   1753  CA  CYS C  57      -1.524  -3.360  -2.224  1.00 44.86           C  
ATOM   1754  C   CYS C  57      -0.242  -2.786  -1.616  1.00 44.86           C  
ATOM   1755  O   CYS C  57      -0.042  -2.797  -0.399  1.00 44.86           O  
ATOM   1756  CB  CYS C  57      -2.422  -2.184  -2.584  1.00 42.89           C  
ATOM   1757  SG  CYS C  57      -3.880  -2.621  -3.483  1.00 42.89           S  
ATOM   1758  N   ASN C  58       0.609  -2.242  -2.479  1.00 61.68           N  
ATOM   1759  CA  ASN C  58       1.862  -1.646  -2.045  1.00 61.68           C  
ATOM   1760  C   ASN C  58       2.114  -0.395  -2.853  1.00 61.68           C  
ATOM   1761  O   ASN C  58       1.952  -0.397  -4.075  1.00 61.68           O  
ATOM   1762  CB  ASN C  58       3.014  -2.609  -2.288  1.00 57.53           C  
ATOM   1763  CG  ASN C  58       2.662  -4.012  -1.925  1.00 57.53           C  
ATOM   1764  OD1 ASN C  58       2.537  -4.342  -0.746  1.00 57.53           O  
ATOM   1765  ND2 ASN C  58       2.475  -4.857  -2.936  1.00 57.53           N  
ATOM   1766  N   ILE C  59       2.496   0.679  -2.174  1.00 48.37           N  
ATOM   1767  CA  ILE C  59       2.815   1.914  -2.871  1.00 48.37           C  
ATOM   1768  C   ILE C  59       4.024   2.559  -2.197  1.00 48.37           C  
ATOM   1769  O   ILE C  59       3.990   2.917  -1.019  1.00 48.37           O  
ATOM   1770  CB  ILE C  59       1.606   2.870  -2.917  1.00 18.61           C  
ATOM   1771  CG1 ILE C  59       1.903   4.011  -3.910  1.00 18.61           C  
ATOM   1772  CG2 ILE C  59       1.234   3.318  -1.503  1.00 18.61           C  
ATOM   1773  CD1 ILE C  59       0.704   4.867  -4.287  1.00 18.61           C  
ATOM   1774  N   TRP C  60       5.102   2.662  -2.966  1.00 66.36           N  
ATOM   1775  CA  TRP C  60       6.374   3.195  -2.503  1.00 66.36           C  
ATOM   1776  C   TRP C  60       6.508   4.717  -2.515  1.00 66.36           C  
ATOM   1777  O   TRP C  60       5.561   5.442  -2.832  1.00 66.36           O  
ATOM   1778  CB  TRP C  60       7.500   2.568  -3.342  1.00 70.34           C  
ATOM   1779  CG  TRP C  60       8.166   1.389  -2.691  1.00 70.34           C  
ATOM   1780  CD1 TRP C  60       9.297   1.411  -1.926  1.00 70.34           C  
ATOM   1781  CD2 TRP C  60       7.691   0.037  -2.663  1.00 70.34           C  
ATOM   1782  NE1 TRP C  60       9.551   0.161  -1.417  1.00 70.34           N  
ATOM   1783  CE2 TRP C  60       8.582  -0.698  -1.849  1.00 70.34           C  
ATOM   1784  CE3 TRP C  60       6.599  -0.618  -3.239  1.00 70.34           C  
ATOM   1785  CZ2 TRP C  60       8.410  -2.067  -1.598  1.00 70.34           C  
ATOM   1786  CZ3 TRP C  60       6.428  -1.983  -2.987  1.00 70.34           C  
ATOM   1787  CH2 TRP C  60       7.332  -2.689  -2.170  1.00 70.34           C  
ATOM   1788  N   ARG C  61       7.706   5.175  -2.146  1.00 53.77           N  
ATOM   1789  CA  ARG C  61       8.070   6.586  -2.104  1.00 53.77           C  
ATOM   1790  C   ARG C  61       7.078   7.487  -1.369  1.00 53.77           C  
ATOM   1791  O   ARG C  61       6.289   7.018  -0.540  1.00 53.77           O  
ATOM   1792  CB  ARG C  61       8.293   7.097  -3.525  1.00 57.15           C  
ATOM   1793  N   GLU C  62       7.137   8.784  -1.682  1.00 57.98           N  
ATOM   1794  CA  GLU C  62       6.277   9.803  -1.077  1.00 57.98           C  
ATOM   1795  C   GLU C  62       4.791   9.441  -1.117  1.00 57.98           C  
ATOM   1796  O   GLU C  62       4.065   9.676  -0.150  1.00 57.98           O  
ATOM   1797  CB  GLU C  62       6.504  11.136  -1.769  1.00 76.21           C  
ATOM   1798  N   ALA C  63       4.347   8.875  -2.238  1.00 85.65           N  
ATOM   1799  CA  ALA C  63       2.955   8.470  -2.402  1.00 85.65           C  
ATOM   1800  C   ALA C  63       2.496   7.734  -1.152  1.00 85.65           C  
ATOM   1801  O   ALA C  63       1.325   7.788  -0.781  1.00 85.65           O  
ATOM   1802  CB  ALA C  63       2.820   7.572  -3.613  1.00101.61           C  
ATOM   1803  N   ALA C  64       3.430   7.040  -0.510  1.00 99.42           N  
ATOM   1804  CA  ALA C  64       3.133   6.303   0.706  1.00 99.42           C  
ATOM   1805  C   ALA C  64       2.834   7.301   1.819  1.00 99.42           C  
ATOM   1806  O   ALA C  64       1.874   7.130   2.577  1.00 99.42           O  
ATOM   1807  CB  ALA C  64       4.309   5.426   1.086  1.00 93.64           C  
ATOM   1808  N   GLU C  65       3.662   8.341   1.921  1.00 97.84           N  
ATOM   1809  CA  GLU C  65       3.442   9.366   2.937  1.00 97.84           C  
ATOM   1810  C   GLU C  65       1.981   9.795   2.810  1.00 97.84           C  
ATOM   1811  O   GLU C  65       1.213   9.721   3.767  1.00 97.84           O  
ATOM   1812  CB  GLU C  65       4.384  10.581   2.729  1.00 99.81           C  
ATOM   1813  CG  GLU C  65       5.776  10.464   3.399  1.00 99.81           C  
ATOM   1814  CD  GLU C  65       6.664  11.720   3.256  1.00 99.81           C  
ATOM   1815  OE1 GLU C  65       6.226  12.830   3.638  1.00 99.81           O  
ATOM   1816  OE2 GLU C  65       7.816  11.591   2.776  1.00 99.81           O  
ATOM   1817  N   ASN C  66       1.598  10.196   1.600  1.00 53.46           N  
ATOM   1818  CA  ASN C  66       0.238  10.652   1.308  1.00 53.46           C  
ATOM   1819  C   ASN C  66      -0.860   9.614   1.550  1.00 53.46           C  
ATOM   1820  O   ASN C  66      -1.926   9.954   2.057  1.00 53.46           O  
ATOM   1821  CB  ASN C  66       0.161  11.150  -0.138  1.00 51.97           C  
ATOM   1822  CG  ASN C  66       1.246  12.162  -0.460  1.00 51.97           C  
ATOM   1823  OD1 ASN C  66       1.310  13.230   0.140  1.00 51.97           O  
ATOM   1824  ND2 ASN C  66       2.109  11.823  -1.405  1.00 51.97           N  
ATOM   1825  N   VAL C  67      -0.611   8.360   1.184  1.00 55.12           N  
ATOM   1826  CA  VAL C  67      -1.611   7.313   1.387  1.00 55.12           C  
ATOM   1827  C   VAL C  67      -1.971   7.210   2.855  1.00 55.12           C  
ATOM   1828  O   VAL C  67      -3.122   7.020   3.212  1.00 55.12           O  
ATOM   1829  CB  VAL C  67      -1.129   5.946   0.867  1.00 52.86           C  
ATOM   1830  CG1 VAL C  67      -2.045   4.841   1.376  1.00 52.86           C  
ATOM   1831  CG2 VAL C  67      -1.123   5.947  -0.663  1.00 52.86           C  
ATOM   1832  N   ALA C  68      -0.953   7.323   3.712  1.00 89.04           N  
ATOM   1833  CA  ALA C  68      -1.182   7.323   5.145  1.00 89.04           C  
ATOM   1834  C   ALA C  68      -1.043   8.692   5.684  1.00 89.04           C  
ATOM   1835  O   ALA C  68       0.063   9.119   6.049  1.00 89.04           O  
ATOM   1836  CB  ALA C  68      -0.255   6.338   5.824  1.00 66.84           C  
ATOM   1837  N   GLU C  69      -2.170   9.428   5.611  1.00 79.66           N  
ATOM   1838  CA  GLU C  69      -2.514  10.729   6.191  1.00 79.66           C  
ATOM   1839  C   GLU C  69      -3.618  11.236   5.423  1.00 79.66           C  
ATOM   1840  O   GLU C  69      -3.900  12.429   5.375  1.00 79.66           O  
ATOM   1841  CB  GLU C  69      -1.306  11.765   6.456  1.00 51.60           C  
ATOM   1842  N   SER C  70      -4.262  10.296   4.752  1.00 49.28           N  
ATOM   1843  CA  SER C  70      -5.444  10.612   3.968  1.00 49.28           C  
ATOM   1844  C   SER C  70      -6.450   9.505   4.190  1.00 49.28           C  
ATOM   1845  O   SER C  70      -7.529   9.705   4.771  1.00 49.28           O  
ATOM   1846  CB  SER C  70      -5.109  10.676   2.480  1.00 18.34           C  
ATOM   1847  OG  SER C  70      -4.189  11.713   2.212  1.00 18.34           O  
ATOM   1848  N   LEU C  71      -6.053   8.319   3.742  1.00 53.70           N  
ATOM   1849  CA  LEU C  71      -6.877   7.131   3.858  1.00 53.70           C  
ATOM   1850  C   LEU C  71      -6.871   6.508   5.260  1.00 53.70           C  
ATOM   1851  O   LEU C  71      -5.894   6.625   6.016  1.00 53.70           O  
ATOM   1852  CB  LEU C  71      -6.424   6.086   2.834  1.00 61.24           C  
ATOM   1853  CG  LEU C  71      -6.209   6.555   1.390  1.00 61.24           C  
ATOM   1854  CD1 LEU C  71      -6.189   5.345   0.454  1.00 61.24           C  
ATOM   1855  CD2 LEU C  71      -7.318   7.501   0.987  1.00 61.24           C  
ATOM   1856  N   THR C  72      -7.981   5.847   5.590  1.00 58.69           N  
ATOM   1857  CA  THR C  72      -8.162   5.183   6.877  1.00 58.69           C  
ATOM   1858  C   THR C  72      -9.022   3.949   6.631  1.00 58.69           C  
ATOM   1859  O   THR C  72      -9.586   3.797   5.551  1.00 58.69           O  
ATOM   1860  CB  THR C  72      -8.862   6.118   7.875  1.00 54.21           C  
ATOM   1861  OG1 THR C  72      -9.996   6.731   7.243  1.00 54.21           O  
ATOM   1862  CG2 THR C  72      -7.906   7.201   8.333  1.00 54.21           C  
ATOM   1863  N   ARG C  73      -9.130   3.071   7.622  1.00 42.92           N  
ATOM   1864  CA  ARG C  73      -9.913   1.855   7.443  1.00 42.92           C  
ATOM   1865  C   ARG C  73     -11.339   2.149   7.020  1.00 42.92           C  
ATOM   1866  O   ARG C  73     -11.976   3.054   7.564  1.00 42.92           O  
ATOM   1867  CB  ARG C  73      -9.952   1.033   8.725  1.00 66.24           C  
ATOM   1868  CG  ARG C  73     -10.932   1.539   9.764  1.00 66.24           C  
ATOM   1869  CD  ARG C  73     -11.394   0.407  10.655  1.00 66.24           C  
ATOM   1870  NE  ARG C  73     -12.117  -0.608   9.891  1.00 66.24           N  
ATOM   1871  CZ  ARG C  73     -12.895  -1.536  10.437  1.00 66.24           C  
ATOM   1872  NH1 ARG C  73     -13.518  -2.422   9.669  1.00 66.24           N  
ATOM   1873  NH2 ARG C  73     -13.055  -1.572  11.752  1.00 66.24           N  
ATOM   1874  N   GLY C  74     -11.837   1.365   6.060  1.00 53.72           N  
ATOM   1875  CA  GLY C  74     -13.193   1.533   5.562  1.00 53.72           C  
ATOM   1876  C   GLY C  74     -13.323   2.577   4.462  1.00 53.72           C  
ATOM   1877  O   GLY C  74     -14.423   2.850   3.977  1.00 53.72           O  
ATOM   1878  N   ALA C  75     -12.201   3.160   4.057  1.00 44.90           N  
ATOM   1879  CA  ALA C  75     -12.216   4.183   3.024  1.00 44.90           C  
ATOM   1880  C   ALA C  75     -12.326   3.604   1.626  1.00 44.90           C  
ATOM   1881  O   ALA C  75     -11.559   2.717   1.258  1.00 44.90           O  
ATOM   1882  CB  ALA C  75     -10.973   5.025   3.120  1.00  2.61           C  
ATOM   1883  N   ARG C  76     -13.282   4.114   0.851  1.00 37.73           N  
ATOM   1884  CA  ARG C  76     -13.473   3.673  -0.526  1.00 37.73           C  
ATOM   1885  C   ARG C  76     -12.457   4.428  -1.383  1.00 37.73           C  
ATOM   1886  O   ARG C  76     -12.445   5.668  -1.426  1.00 37.73           O  
ATOM   1887  CB  ARG C  76     -14.890   3.976  -0.999  1.00 34.12           C  
ATOM   1888  CG  ARG C  76     -15.114   3.654  -2.454  1.00 34.12           C  
ATOM   1889  CD  ARG C  76     -16.445   4.205  -2.894  1.00 34.12           C  
ATOM   1890  NE  ARG C  76     -17.401   3.141  -3.179  1.00 34.12           N  
ATOM   1891  CZ  ARG C  76     -17.574   2.591  -4.384  1.00 34.12           C  
ATOM   1892  NH1 ARG C  76     -16.855   3.013  -5.419  1.00 34.12           N  
ATOM   1893  NH2 ARG C  76     -18.465   1.616  -4.566  1.00 34.12           N  
ATOM   1894  N   VAL C  77     -11.614   3.659  -2.065  1.00 26.81           N  
ATOM   1895  CA  VAL C  77     -10.550   4.194  -2.894  1.00 26.81           C  
ATOM   1896  C   VAL C  77     -10.563   3.660  -4.336  1.00 26.81           C  
ATOM   1897  O   VAL C  77     -11.304   2.728  -4.670  1.00 26.81           O  
ATOM   1898  CB  VAL C  77      -9.194   3.815  -2.275  1.00 25.40           C  
ATOM   1899  CG1 VAL C  77      -8.999   4.501  -0.945  1.00 25.40           C  
ATOM   1900  CG2 VAL C  77      -9.143   2.309  -2.083  1.00 25.40           C  
ATOM   1901  N   ILE C  78      -9.739   4.265  -5.187  1.00 31.42           N  
ATOM   1902  CA  ILE C  78      -9.595   3.807  -6.562  1.00 31.42           C  
ATOM   1903  C   ILE C  78      -8.120   3.541  -6.728  1.00 31.42           C  
ATOM   1904  O   ILE C  78      -7.288   4.418  -6.557  1.00 31.42           O  
ATOM   1905  CB  ILE C  78     -10.038   4.843  -7.590  1.00 31.98           C  
ATOM   1906  CG1 ILE C  78     -11.523   5.104  -7.427  1.00 31.98           C  
ATOM   1907  CG2 ILE C  78      -9.819   4.319  -8.996  1.00 31.98           C  
ATOM   1908  CD1 ILE C  78     -12.124   5.830  -8.584  1.00 31.98           C  
ATOM   1909  N   VAL C  79      -7.792   2.307  -7.038  1.00 21.86           N  
ATOM   1910  CA  VAL C  79      -6.408   1.948  -7.197  1.00 21.86           C  
ATOM   1911  C   VAL C  79      -6.163   1.558  -8.637  1.00 21.86           C  
ATOM   1912  O   VAL C  79      -7.039   0.990  -9.305  1.00 21.86           O  
ATOM   1913  CB  VAL C  79      -6.045   0.745  -6.318  1.00 19.13           C  
ATOM   1914  CG1 VAL C  79      -4.545   0.546  -6.312  1.00 19.13           C  
ATOM   1915  CG2 VAL C  79      -6.578   0.947  -4.906  1.00 19.13           C  
ATOM   1916  N   SER C  80      -4.970   1.880  -9.120  1.00 52.61           N  
ATOM   1917  CA  SER C  80      -4.573   1.536 -10.475  1.00 52.61           C  
ATOM   1918  C   SER C  80      -3.153   1.007 -10.331  1.00 52.61           C  
ATOM   1919  O   SER C  80      -2.297   1.684  -9.746  1.00 52.61           O  
ATOM   1920  CB  SER C  80      -4.592   2.772 -11.373  1.00 68.75           C  
ATOM   1921  OG  SER C  80      -4.455   2.391 -12.726  1.00 68.75           O  
ATOM   1922  N   GLY C  81      -2.910  -0.203 -10.835  1.00 28.01           N  
ATOM   1923  CA  GLY C  81      -1.584  -0.774 -10.726  1.00 28.01           C  
ATOM   1924  C   GLY C  81      -1.387  -2.124 -11.371  1.00 28.01           C  
ATOM   1925  O   GLY C  81      -2.333  -2.747 -11.833  1.00 28.01           O  
ATOM   1926  N   ARG C  82      -0.135  -2.574 -11.375  1.00 52.84           N  
ATOM   1927  CA  ARG C  82       0.274  -3.847 -11.969  1.00 52.84           C  
ATOM   1928  C   ARG C  82       0.134  -5.000 -10.989  1.00 52.84           C  
ATOM   1929  O   ARG C  82       0.455  -4.845  -9.813  1.00 52.84           O  
ATOM   1930  CB  ARG C  82       1.743  -3.768 -12.399  1.00 96.47           C  
ATOM   1931  CG  ARG C  82       2.101  -2.577 -13.273  1.00 96.47           C  
ATOM   1932  CD  ARG C  82       3.584  -2.236 -13.138  1.00 96.47           C  
ATOM   1933  NE  ARG C  82       3.861  -1.452 -11.928  1.00 96.47           N  
ATOM   1934  CZ  ARG C  82       4.997  -1.505 -11.234  1.00 96.47           C  
ATOM   1935  NH1 ARG C  82       5.974  -2.316 -11.625  1.00 96.47           N  
ATOM   1936  NH2 ARG C  82       5.160  -0.741 -10.157  1.00 96.47           N  
ATOM   1937  N   LEU C  83      -0.344  -6.147 -11.464  1.00 25.43           N  
ATOM   1938  CA  LEU C  83      -0.460  -7.317 -10.603  1.00 25.43           C  
ATOM   1939  C   LEU C  83       0.978  -7.804 -10.408  1.00 25.43           C  
ATOM   1940  O   LEU C  83       1.676  -8.093 -11.389  1.00 25.43           O  
ATOM   1941  CB  LEU C  83      -1.312  -8.399 -11.268  1.00 32.56           C  
ATOM   1942  CG  LEU C  83      -2.820  -8.184 -11.229  1.00 32.56           C  
ATOM   1943  CD1 LEU C  83      -3.496  -9.340 -11.875  1.00 32.56           C  
ATOM   1944  CD2 LEU C  83      -3.298  -8.065  -9.806  1.00 32.56           C  
ATOM   1945  N   LYS C  84       1.419  -7.906  -9.154  1.00 16.21           N  
ATOM   1946  CA  LYS C  84       2.793  -8.296  -8.872  1.00 16.21           C  
ATOM   1947  C   LYS C  84       3.113  -9.697  -8.394  1.00 16.21           C  
ATOM   1948  O   LYS C  84       2.237 -10.523  -8.137  1.00 16.21           O  
ATOM   1949  CB  LYS C  84       3.413  -7.293  -7.897  1.00 60.68           C  
ATOM   1950  CG  LYS C  84       4.176  -6.178  -8.569  1.00 60.68           C  
ATOM   1951  CD  LYS C  84       5.501  -6.683  -9.132  1.00 60.68           C  
ATOM   1952  CE  LYS C  84       6.308  -5.548  -9.768  1.00 60.68           C  
ATOM   1953  NZ  LYS C  84       7.657  -5.971 -10.275  1.00 60.68           N  
ATOM   1954  N   GLN C  85       4.420  -9.914  -8.263  1.00101.61           N  
ATOM   1955  CA  GLN C  85       5.014 -11.168  -7.837  1.00101.61           C  
ATOM   1956  C   GLN C  85       4.727 -12.221  -8.883  1.00101.61           C  
ATOM   1957  O   GLN C  85       5.641 -12.486  -9.696  1.00101.61           O  
ATOM   1958  CB  GLN C  85       4.451 -11.604  -6.485  1.00 69.00           C  
ATOM   1959  CG  GLN C  85       5.524 -11.824  -5.427  1.00 69.00           C  
ATOM   1960  CD  GLN C  85       4.947 -12.244  -4.089  1.00 69.00           C  
ATOM   1961  OE1 GLN C  85       4.283 -13.280  -3.979  1.00 69.00           O  
ATOM   1962  NE2 GLN C  85       5.192 -11.435  -3.061  1.00 69.00           N  
ATOM   1963  N   ARG C  91       7.595 -24.694   7.814  1.00 85.36           N  
ATOM   1964  CA  ARG C  91       8.374 -23.430   7.975  1.00 85.36           C  
ATOM   1965  C   ARG C  91       7.424 -22.229   7.989  1.00 85.36           C  
ATOM   1966  O   ARG C  91       7.843 -21.070   8.020  1.00 85.36           O  
ATOM   1967  CB  ARG C  91       9.400 -23.303   6.835  1.00101.16           C  
ATOM   1968  CG  ARG C  91       8.854 -23.594   5.434  1.00101.16           C  
ATOM   1969  CD  ARG C  91       9.932 -23.365   4.376  1.00101.16           C  
ATOM   1970  NE  ARG C  91       9.452 -23.590   3.016  1.00101.16           N  
ATOM   1971  CZ  ARG C  91       9.229 -24.787   2.485  1.00101.16           C  
ATOM   1972  NH1 ARG C  91       9.445 -25.878   3.200  1.00101.16           N  
ATOM   1973  NH2 ARG C  91       8.789 -24.893   1.240  1.00101.16           N  
ATOM   1974  N   GLU C  92       6.132 -22.538   7.978  1.00101.61           N  
ATOM   1975  CA  GLU C  92       5.074 -21.540   7.981  1.00101.61           C  
ATOM   1976  C   GLU C  92       5.237 -20.485   6.897  1.00101.61           C  
ATOM   1977  O   GLU C  92       4.510 -19.496   6.875  1.00101.61           O  
ATOM   1978  CB  GLU C  92       4.956 -20.881   9.356  1.00100.79           C  
ATOM   1979  CG  GLU C  92       3.550 -20.991   9.966  1.00100.79           C  
ATOM   1980  CD  GLU C  92       3.047 -22.429  10.054  1.00100.79           C  
ATOM   1981  OE1 GLU C  92       3.672 -23.253  10.757  1.00100.79           O  
ATOM   1982  OE2 GLU C  92       2.020 -22.736   9.417  1.00100.79           O  
ATOM   1983  N   GLY C  93       6.199 -20.691   6.004  1.00 95.53           N  
ATOM   1984  CA  GLY C  93       6.365 -19.760   4.909  1.00 95.53           C  
ATOM   1985  C   GLY C  93       7.604 -18.918   4.696  1.00 95.53           C  
ATOM   1986  O   GLY C  93       8.272 -18.462   5.620  1.00 95.53           O  
ATOM   1987  N   GLU C  94       7.877 -18.728   3.412  1.00 87.04           N  
ATOM   1988  CA  GLU C  94       8.968 -17.919   2.887  1.00 87.04           C  
ATOM   1989  C   GLU C  94       8.188 -17.217   1.786  1.00 87.04           C  
ATOM   1990  O   GLU C  94       8.054 -15.997   1.753  1.00 87.04           O  
ATOM   1991  CB  GLU C  94      10.046 -18.792   2.244  1.00101.61           C  
ATOM   1992  CG  GLU C  94      10.494 -19.984   3.069  1.00101.61           C  
ATOM   1993  CD  GLU C  94      11.610 -20.761   2.393  1.00101.61           C  
ATOM   1994  OE1 GLU C  94      12.650 -20.145   2.078  1.00101.61           O  
ATOM   1995  OE2 GLU C  94      11.453 -21.982   2.176  1.00101.61           O  
ATOM   1996  N   LYS C  95       7.663 -18.054   0.898  1.00 98.58           N  
ATOM   1997  CA  LYS C  95       6.829 -17.676  -0.239  1.00 98.58           C  
ATOM   1998  C   LYS C  95       7.015 -16.384  -1.026  1.00 98.58           C  
ATOM   1999  O   LYS C  95       7.790 -15.489  -0.684  1.00 98.58           O  
ATOM   2000  CB  LYS C  95       5.353 -17.754   0.166  1.00 87.02           C  
ATOM   2001  CG  LYS C  95       4.650 -19.071  -0.144  1.00 87.02           C  
ATOM   2002  CD  LYS C  95       3.203 -18.951   0.278  1.00 87.02           C  
ATOM   2003  CE  LYS C  95       2.434 -20.221   0.058  1.00 87.02           C  
ATOM   2004  NZ  LYS C  95       1.065 -20.085   0.628  1.00 87.02           N  
ATOM   2005  N   ARG C  96       6.237 -16.345  -2.102  1.00101.61           N  
ATOM   2006  CA  ARG C  96       6.147 -15.270  -3.073  1.00101.61           C  
ATOM   2007  C   ARG C  96       5.149 -15.843  -4.090  1.00101.61           C  
ATOM   2008  O   ARG C  96       5.283 -15.655  -5.299  1.00101.61           O  
ATOM   2009  CB  ARG C  96       7.508 -15.016  -3.724  1.00 57.07           C  
ATOM   2010  N   THR C  97       4.156 -16.564  -3.569  1.00 99.06           N  
ATOM   2011  CA  THR C  97       3.118 -17.200  -4.376  1.00 99.06           C  
ATOM   2012  C   THR C  97       1.781 -16.512  -4.171  1.00 99.06           C  
ATOM   2013  O   THR C  97       0.730 -17.155  -4.182  1.00 99.06           O  
ATOM   2014  CB  THR C  97       2.939 -18.684  -4.003  1.00101.61           C  
ATOM   2015  OG1 THR C  97       2.403 -18.784  -2.676  1.00101.61           O  
ATOM   2016  CG2 THR C  97       4.273 -19.415  -4.067  1.00101.61           C  
ATOM   2017  N   VAL C  98       1.823 -15.206  -3.956  1.00 40.92           N  
ATOM   2018  CA  VAL C  98       0.600 -14.454  -3.782  1.00 40.92           C  
ATOM   2019  C   VAL C  98       0.494 -13.355  -4.824  1.00 40.92           C  
ATOM   2020  O   VAL C  98       1.479 -12.982  -5.469  1.00 40.92           O  
ATOM   2021  CB  VAL C  98       0.508 -13.823  -2.393  1.00 43.04           C  
ATOM   2022  CG1 VAL C  98       0.208 -14.893  -1.370  1.00 43.04           C  
ATOM   2023  CG2 VAL C  98       1.797 -13.106  -2.053  1.00 43.04           C  
ATOM   2024  N   ILE C  99      -0.717 -12.853  -5.000  1.00 44.22           N  
ATOM   2025  CA  ILE C  99      -0.951 -11.791  -5.950  1.00 44.22           C  
ATOM   2026  C   ILE C  99      -1.321 -10.492  -5.231  1.00 44.22           C  
ATOM   2027  O   ILE C  99      -2.312 -10.414  -4.491  1.00 44.22           O  
ATOM   2028  CB  ILE C  99      -2.025 -12.218  -6.944  1.00 46.98           C  
ATOM   2029  CG1 ILE C  99      -1.395 -13.201  -7.923  1.00 46.98           C  
ATOM   2030  CG2 ILE C  99      -2.611 -11.016  -7.671  1.00 46.98           C  
ATOM   2031  CD1 ILE C  99      -2.384 -13.850  -8.830  1.00 46.98           C  
ATOM   2032  N   GLU C 100      -0.481  -9.480  -5.436  1.00 41.03           N  
ATOM   2033  CA  GLU C 100      -0.686  -8.174  -4.829  1.00 41.03           C  
ATOM   2034  C   GLU C 100      -0.760  -7.126  -5.942  1.00 41.03           C  
ATOM   2035  O   GLU C 100      -0.573  -7.447  -7.117  1.00 41.03           O  
ATOM   2036  CB  GLU C 100       0.468  -7.872  -3.872  1.00100.28           C  
ATOM   2037  CG  GLU C 100       0.881  -9.072  -3.022  1.00100.28           C  
ATOM   2038  CD  GLU C 100       1.836  -8.704  -1.899  1.00100.28           C  
ATOM   2039  OE1 GLU C 100       2.835  -8.009  -2.172  1.00100.28           O  
ATOM   2040  OE2 GLU C 100       1.591  -9.114  -0.742  1.00100.28           O  
ATOM   2041  N   VAL C 101      -1.031  -5.881  -5.572  1.00 47.25           N  
ATOM   2042  CA  VAL C 101      -1.145  -4.804  -6.537  1.00 47.25           C  
ATOM   2043  C   VAL C 101      -0.093  -3.760  -6.275  1.00 47.25           C  
ATOM   2044  O   VAL C 101      -0.036  -3.200  -5.190  1.00 47.25           O  
ATOM   2045  CB  VAL C 101      -2.522  -4.122  -6.444  1.00 13.54           C  
ATOM   2046  CG1 VAL C 101      -2.630  -3.019  -7.467  1.00 13.54           C  
ATOM   2047  CG2 VAL C 101      -3.624  -5.151  -6.656  1.00 13.54           C  
ATOM   2048  N   GLU C 102       0.737  -3.503  -7.275  1.00 45.45           N  
ATOM   2049  CA  GLU C 102       1.789  -2.500  -7.164  1.00 45.45           C  
ATOM   2050  C   GLU C 102       1.173  -1.141  -7.510  1.00 45.45           C  
ATOM   2051  O   GLU C 102       1.424  -0.602  -8.588  1.00 45.45           O  
ATOM   2052  CB  GLU C 102       2.928  -2.820  -8.139  1.00 88.54           C  
ATOM   2053  CG  GLU C 102       4.222  -2.052  -7.892  1.00 88.54           C  
ATOM   2054  CD  GLU C 102       4.958  -2.509  -6.640  1.00 88.54           C  
ATOM   2055  OE1 GLU C 102       5.233  -3.723  -6.502  1.00 88.54           O  
ATOM   2056  OE2 GLU C 102       5.270  -1.650  -5.793  1.00 88.54           O  
ATOM   2057  N   VAL C 103       0.383  -0.601  -6.578  1.00 20.33           N  
ATOM   2058  CA  VAL C 103      -0.328   0.670  -6.734  1.00 20.33           C  
ATOM   2059  C   VAL C 103       0.425   1.833  -7.364  1.00 20.33           C  
ATOM   2060  O   VAL C 103       1.434   2.278  -6.818  1.00 20.33           O  
ATOM   2061  CB  VAL C 103      -0.831   1.177  -5.390  1.00 25.78           C  
ATOM   2062  CG1 VAL C 103      -1.737   2.372  -5.598  1.00 25.78           C  
ATOM   2063  CG2 VAL C 103      -1.541   0.084  -4.669  1.00 25.78           C  
ATOM   2064  N   ASP C 104      -0.079   2.351  -8.487  1.00 61.95           N  
ATOM   2065  CA  ASP C 104       0.542   3.496  -9.163  1.00 61.95           C  
ATOM   2066  C   ASP C 104      -0.143   4.768  -8.689  1.00 61.95           C  
ATOM   2067  O   ASP C 104       0.494   5.681  -8.154  1.00 61.95           O  
ATOM   2068  CB  ASP C 104       0.367   3.396 -10.676  1.00101.61           C  
ATOM   2069  CG  ASP C 104       1.180   2.288 -11.279  1.00101.61           C  
ATOM   2070  OD1 ASP C 104       0.998   2.005 -12.480  1.00101.61           O  
ATOM   2071  OD2 ASP C 104       2.005   1.705 -10.550  1.00101.61           O  
ATOM   2072  N   GLU C 105      -1.454   4.806  -8.913  1.00 36.88           N  
ATOM   2073  CA  GLU C 105      -2.278   5.931  -8.532  1.00 36.88           C  
ATOM   2074  C   GLU C 105      -3.301   5.447  -7.527  1.00 36.88           C  
ATOM   2075  O   GLU C 105      -3.873   4.376  -7.674  1.00 36.88           O  
ATOM   2076  CB  GLU C 105      -2.995   6.501  -9.750  1.00 25.51           C  
ATOM   2077  CG  GLU C 105      -2.109   7.004 -10.877  1.00 25.51           C  
ATOM   2078  CD  GLU C 105      -1.272   8.196 -10.487  1.00 25.51           C  
ATOM   2079  OE1 GLU C 105      -1.801   9.075  -9.774  1.00 25.51           O  
ATOM   2080  OE2 GLU C 105      -0.095   8.259 -10.907  1.00 25.51           O  
ATOM   2081  N   ILE C 106      -3.516   6.245  -6.498  1.00 56.66           N  
ATOM   2082  CA  ILE C 106      -4.473   5.916  -5.461  1.00 56.66           C  
ATOM   2083  C   ILE C 106      -5.176   7.230  -5.143  1.00 56.66           C  
ATOM   2084  O   ILE C 106      -4.652   8.308  -5.448  1.00 56.66           O  
ATOM   2085  CB  ILE C 106      -3.754   5.372  -4.194  1.00 38.03           C  
ATOM   2086  CG1 ILE C 106      -4.768   4.814  -3.195  1.00 38.03           C  
ATOM   2087  CG2 ILE C 106      -2.941   6.479  -3.534  1.00 38.03           C  
ATOM   2088  CD1 ILE C 106      -5.344   3.502  -3.595  1.00 38.03           C  
ATOM   2089  N   GLY C 107      -6.363   7.140  -4.554  1.00 35.66           N  
ATOM   2090  CA  GLY C 107      -7.110   8.330  -4.203  1.00 35.66           C  
ATOM   2091  C   GLY C 107      -8.458   7.951  -3.626  1.00 35.66           C  
ATOM   2092  O   GLY C 107      -9.048   6.951  -4.048  1.00 35.66           O  
ATOM   2093  N   PRO C 108      -8.977   8.739  -2.664  1.00 49.39           N  
ATOM   2094  CA  PRO C 108     -10.263   8.525  -1.996  1.00 49.39           C  
ATOM   2095  C   PRO C 108     -11.387   8.595  -3.018  1.00 49.39           C  
ATOM   2096  O   PRO C 108     -11.417   9.503  -3.846  1.00 49.39           O  
ATOM   2097  CB  PRO C 108     -10.343   9.694  -1.003  1.00 42.02           C  
ATOM   2098  CG  PRO C 108      -8.932  10.157  -0.849  1.00 42.02           C  
ATOM   2099  CD  PRO C 108      -8.391  10.020  -2.236  1.00 42.02           C  
ATOM   2100  N   SER C 109     -12.322   7.660  -2.956  1.00 75.43           N  
ATOM   2101  CA  SER C 109     -13.427   7.660  -3.907  1.00 75.43           C  
ATOM   2102  C   SER C 109     -14.506   8.686  -3.598  1.00 75.43           C  
ATOM   2103  O   SER C 109     -15.346   8.480  -2.715  1.00 75.43           O  
ATOM   2104  CB  SER C 109     -14.062   6.281  -3.974  1.00 50.62           C  
ATOM   2105  OG  SER C 109     -15.157   6.287  -4.872  1.00 50.62           O  
ATOM   2106  N   LEU C 110     -14.479   9.782  -4.353  1.00 58.80           N  
ATOM   2107  CA  LEU C 110     -15.428  10.874  -4.200  1.00 58.80           C  
ATOM   2108  C   LEU C 110     -16.860  10.432  -4.419  1.00 58.80           C  
ATOM   2109  O   LEU C 110     -17.766  11.253  -4.415  1.00 58.80           O  
ATOM   2110  CB  LEU C 110     -15.090  12.000  -5.174  1.00 33.47           C  
ATOM   2111  CG  LEU C 110     -13.819  12.785  -4.846  1.00 33.47           C  
ATOM   2112  CD1 LEU C 110     -13.513  13.794  -5.946  1.00 33.47           C  
ATOM   2113  CD2 LEU C 110     -14.004  13.480  -3.500  1.00 33.47           C  
ATOM   2114  N   ARG C 111     -17.068   9.137  -4.615  1.00 57.03           N  
ATOM   2115  CA  ARG C 111     -18.415   8.631  -4.817  1.00 57.03           C  
ATOM   2116  C   ARG C 111     -19.260   8.864  -3.571  1.00 57.03           C  
ATOM   2117  O   ARG C 111     -20.141   9.715  -3.569  1.00 57.03           O  
ATOM   2118  CB  ARG C 111     -18.377   7.139  -5.144  1.00 71.20           C  
ATOM   2119  CG  ARG C 111     -19.719   6.422  -4.978  1.00 71.20           C  
ATOM   2120  CD  ARG C 111     -20.488   6.244  -6.278  1.00 71.20           C  
ATOM   2121  NE  ARG C 111     -20.193   4.965  -6.918  1.00 71.20           N  
ATOM   2122  CZ  ARG C 111     -21.007   4.348  -7.766  1.00 71.20           C  
ATOM   2123  NH1 ARG C 111     -22.170   4.893  -8.077  1.00 71.20           N  
ATOM   2124  NH2 ARG C 111     -20.659   3.183  -8.298  1.00 71.20           N  
ATOM   2125  N   TYR C 112     -18.976   8.115  -2.509  1.00101.61           N  
ATOM   2126  CA  TYR C 112     -19.724   8.218  -1.255  1.00101.61           C  
ATOM   2127  C   TYR C 112     -19.041   9.083  -0.184  1.00101.61           C  
ATOM   2128  O   TYR C 112     -19.189   8.831   1.015  1.00101.61           O  
ATOM   2129  CB  TYR C 112     -19.960   6.806  -0.697  1.00 54.05           C  
ATOM   2130  CG  TYR C 112     -20.868   5.932  -1.538  1.00 54.05           C  
ATOM   2131  CD1 TYR C 112     -20.928   4.552  -1.335  1.00 54.05           C  
ATOM   2132  CD2 TYR C 112     -21.704   6.488  -2.503  1.00 54.05           C  
ATOM   2133  CE1 TYR C 112     -21.797   3.742  -2.082  1.00 54.05           C  
ATOM   2134  CE2 TYR C 112     -22.578   5.690  -3.258  1.00 54.05           C  
ATOM   2135  CZ  TYR C 112     -22.629   4.321  -3.038  1.00 54.05           C  
ATOM   2136  OH  TYR C 112     -23.517   3.548  -3.767  1.00 54.05           O  
ATOM   2137  N   ALA C 113     -18.310  10.111  -0.609  1.00 64.57           N  
ATOM   2138  CA  ALA C 113     -17.610  10.969   0.342  1.00 64.57           C  
ATOM   2139  C   ALA C 113     -17.052  12.247  -0.261  1.00 64.57           C  
ATOM   2140  O   ALA C 113     -16.900  12.366  -1.475  1.00 64.57           O  
ATOM   2141  CB  ALA C 113     -16.479  10.188   0.992  1.00 55.81           C  
ATOM   2142  N   THR C 114     -16.745  13.200   0.610  1.00100.40           N  
ATOM   2143  CA  THR C 114     -16.178  14.476   0.202  1.00100.40           C  
ATOM   2144  C   THR C 114     -14.672  14.401   0.439  1.00100.40           C  
ATOM   2145  O   THR C 114     -14.186  13.420   0.997  1.00100.40           O  
ATOM   2146  CB  THR C 114     -16.785  15.635   1.018  1.00101.61           C  
ATOM   2147  OG1 THR C 114     -17.094  15.174   2.339  1.00101.61           O  
ATOM   2148  CG2 THR C 114     -18.059  16.147   0.362  1.00101.61           C  
ATOM   2149  N   ALA C 115     -13.930  15.418   0.019  1.00 69.97           N  
ATOM   2150  CA  ALA C 115     -12.490  15.386   0.211  1.00 69.97           C  
ATOM   2151  C   ALA C 115     -11.827  16.758   0.165  1.00 69.97           C  
ATOM   2152  O   ALA C 115     -12.219  17.631  -0.608  1.00 69.97           O  
ATOM   2153  CB  ALA C 115     -11.861  14.472  -0.820  1.00 68.36           C  
ATOM   2154  N   LYS C 116     -10.812  16.927   1.009  1.00 71.30           N  
ATOM   2155  CA  LYS C 116     -10.051  18.171   1.117  1.00 71.30           C  
ATOM   2156  C   LYS C 116      -8.682  17.916   0.506  1.00 71.30           C  
ATOM   2157  O   LYS C 116      -7.822  17.308   1.126  1.00 71.30           O  
ATOM   2158  CB  LYS C 116      -9.917  18.558   2.599  1.00 99.13           C  
ATOM   2159  CG  LYS C 116      -8.913  19.671   2.920  1.00 99.13           C  
ATOM   2160  CD  LYS C 116      -9.481  21.071   2.735  1.00 99.13           C  
ATOM   2161  CE  LYS C 116      -8.436  22.111   3.104  1.00 99.13           C  
ATOM   2162  NZ  LYS C 116      -8.948  23.495   2.971  1.00 99.13           N  
ATOM   2163  N   VAL C 117      -8.482  18.390  -0.713  1.00 54.06           N  
ATOM   2164  CA  VAL C 117      -7.222  18.171  -1.411  1.00 54.06           C  
ATOM   2165  C   VAL C 117      -6.142  19.219  -1.155  1.00 54.06           C  
ATOM   2166  O   VAL C 117      -6.400  20.415  -1.252  1.00 54.06           O  
ATOM   2167  CB  VAL C 117      -7.467  18.091  -2.927  1.00 64.83           C  
ATOM   2168  CG1 VAL C 117      -6.162  17.814  -3.663  1.00 64.83           C  
ATOM   2169  CG2 VAL C 117      -8.480  17.004  -3.217  1.00 64.83           C  
ATOM   2170  N   ASN C 118      -4.927  18.755  -0.856  1.00 94.15           N  
ATOM   2171  CA  ASN C 118      -3.773  19.627  -0.591  1.00 94.15           C  
ATOM   2172  C   ASN C 118      -4.065  20.623   0.539  1.00 94.15           C  
ATOM   2173  O   ASN C 118      -3.942  21.849   0.313  1.00 94.15           O  
ATOM   2174  CB  ASN C 118      -3.364  20.387  -1.867  1.00 82.77           C  
ATOM   2175  CG  ASN C 118      -1.907  20.146  -2.263  1.00 82.77           C  
ATOM   2176  OD1 ASN C 118      -1.002  20.218  -1.430  1.00 82.77           O  
ATOM   2177  ND2 ASN C 118      -1.679  19.876  -3.544  1.00 82.77           N  
TER    2178      ASN C 118                                                      
END
MOLECULE T0466.pdb
ATOM    281  N   LEU    19     -13.966  -0.653  -3.614  1.00 72.33           N 
ATOM    282  CA  LEU    19     -12.695  -0.631  -2.891  1.00 64.15           C 
ATOM    283  C   LEU    19     -12.829   0.243  -1.646  1.00 23.21           C 
ATOM    284  O   LEU    19     -12.938   1.465  -1.741  1.00 12.11           O 
ATOM    285  CB  LEU    19     -11.563  -0.105  -3.789  1.00 13.41           C 
ATOM    286  CG  LEU    19     -11.234  -0.974  -5.016  1.00 70.21           C 
ATOM    287  CD1 LEU    19     -10.125  -0.332  -5.850  1.00 43.44           C 
ATOM    288  CD2 LEU    19     -10.838  -2.387  -4.583  1.00 45.32           C 
ATOM    289  H   LEU    19     -14.169   0.069  -4.245  1.00 38.03           H 
ATOM    290  HA  LEU    19     -12.462  -1.643  -2.586  1.00 55.11           H 
ATOM    291 1HB  LEU    19     -10.669  -0.016  -3.189  1.00 45.32           H 
ATOM    292 2HB  LEU    19     -11.840   0.881  -4.136  1.00  2.50           H 
ATOM    293  HG  LEU    19     -12.112  -1.049  -5.641  1.00 41.50           H 
ATOM    294 1HD1 LEU    19     -10.444   0.645  -6.180  1.00 43.04           H 
ATOM    295 2HD1 LEU    19      -9.917  -0.951  -6.711  1.00 44.24           H 
ATOM    296 3HD1 LEU    19      -9.230  -0.236  -5.251  1.00 60.31           H 
ATOM    297 1HD2 LEU    19     -11.659  -2.843  -4.052  1.00 71.13           H 
ATOM    298 2HD2 LEU    19      -9.973  -2.341  -3.937  1.00 40.24           H 
ATOM    299 3HD2 LEU    19     -10.602  -2.978  -5.457  1.00 72.51           H 
ATOM    300  N   LYS    20     -12.840  -0.387  -0.479  1.00 73.43           N 
ATOM    301  CA  LYS    20     -13.053   0.332   0.778  1.00 62.04           C 
ATOM    302  C   LYS    20     -11.909   0.088   1.772  1.00 13.12           C 
ATOM    303  O   LYS    20     -11.455  -1.045   1.961  1.00 65.12           O 
ATOM    304  CB  LYS    20     -14.419  -0.052   1.370  1.00 73.41           C 
ATOM    305  CG  LYS    20     -15.591   0.446   0.520  1.00 44.14           C 
ATOM    306  CD  LYS    20     -16.956   0.146   1.139  1.00 11.00           C 
ATOM    307  CE  LYS    20     -17.277  -1.344   1.148  1.00  5.44           C 
ATOM    308  NZ  LYS    20     -18.661  -1.611   1.627  1.00 32.10           N 
ATOM    309  H   LYS    20     -12.705  -1.359  -0.461  1.00 38.03           H 
ATOM    310  HA  LYS    20     -13.069   1.391   0.545  1.00 11.12           H 
ATOM    311 1HB  LYS    20     -14.509   0.376   2.356  1.00 40.45           H 
ATOM    312 2HB  LYS    20     -14.479  -1.129   1.447  1.00 15.41           H 
ATOM    313 1HG  LYS    20     -15.537  -0.025  -0.454  1.00 12.12           H 
ATOM    314 2HG  LYS    20     -15.497   1.516   0.400  1.00 50.51           H 
ATOM    315 1HD  LYS    20     -17.716   0.663   0.569  1.00 30.51           H 
ATOM    316 2HD  LYS    20     -16.966   0.509   2.157  1.00 21.12           H 
ATOM    317 1HE  LYS    20     -16.577  -1.846   1.800  1.00 71.53           H 
ATOM    318 2HE  LYS    20     -17.175  -1.732   0.144  1.00 22.23           H 
ATOM    319 1HZ  LYS    20     -19.358  -1.233   0.948  1.00  4.11           H 
ATOM    320 2HZ  LYS    20     -18.816  -1.157   2.547  1.00 21.32           H 
ATOM    321 3HZ  LYS    20     -18.816  -2.632   1.732  1.00 52.21           H 
ATOM    322  N   PHE    21     -11.449   1.175   2.393  1.00 62.24           N 
ATOM    323  CA  PHE    21     -10.276   1.156   3.277  1.00 61.32           C 
ATOM    324  C   PHE    21     -10.481   0.285   4.531  1.00 12.31           C 
ATOM    325  O   PHE    21     -11.577   0.211   5.088  1.00 52.04           O 
ATOM    326  CB  PHE    21      -9.929   2.598   3.688  1.00 11.21           C 
ATOM    327  CG  PHE    21      -8.648   2.729   4.474  1.00  1.24           C 
ATOM    328  CD1 PHE    21      -7.419   2.684   3.831  1.00 42.11           C 
ATOM    329  CD2 PHE    21      -8.673   2.907   5.851  1.00 65.13           C 
ATOM    330  CE1 PHE    21      -6.242   2.812   4.543  1.00 44.33           C 
ATOM    331  CE2 PHE    21      -7.499   3.034   6.568  1.00 52.11           C 
ATOM    332  CZ  PHE    21      -6.282   2.987   5.914  1.00 73.53           C 
ATOM    333  H   PHE    21     -11.911   2.030   2.240  1.00 38.03           H 
ATOM    334  HA  PHE    21      -9.449   0.752   2.712  1.00 25.10           H 
ATOM    335 1HB  PHE    21     -10.732   2.995   4.294  1.00 34.51           H 
ATOM    336 2HB  PHE    21      -9.832   3.200   2.798  1.00 43.41           H 
ATOM    337  HD1 PHE    21      -7.387   2.548   2.760  1.00 14.33           H 
ATOM    338  HD2 PHE    21      -9.623   2.942   6.363  1.00 63.21           H 
ATOM    339  HE1 PHE    21      -5.294   2.773   4.030  1.00 51.24           H 
ATOM    340  HE2 PHE    21      -7.533   3.171   7.639  1.00  4.43           H 
ATOM    341  HZ  PHE    21      -5.364   3.087   6.474  1.00  4.10           H 
ATOM    342  N   SER    22      -9.411  -0.380   4.965  1.00 74.33           N 
ATOM    343  CA  SER    22      -9.423  -1.137   6.227  1.00 11.20           C 
ATOM    344  C   SER    22      -8.311  -0.665   7.171  1.00 14.10           C 
ATOM    345  O   SER    22      -8.586  -0.177   8.268  1.00 71.35           O 
ATOM    346  CB  SER    22      -9.277  -2.644   5.969  1.00  4.33           C 
ATOM    347  OG  SER    22     -10.410  -3.167   5.290  1.00 62.25           O 
ATOM    348  H   SER    22      -8.597  -0.380   4.417  1.00 38.03           H 
ATOM    349  HA  SER    22     -10.377  -0.961   6.709  1.00  1.01           H 
ATOM    350 1HB  SER    22      -9.168  -3.160   6.913  1.00 32.42           H 
ATOM    351 2HB  SER    22      -8.401  -2.821   5.363  1.00 13.22           H 
ATOM    352  HG  SER    22     -10.313  -4.126   5.207  1.00 10.03           H 
ATOM    353  N   ALA    23      -7.057  -0.820   6.746  1.00 13.40           N 
ATOM    354  CA  ALA    23      -5.906  -0.400   7.557  1.00 50.24           C 
ATOM    355  C   ALA    23      -4.646  -0.196   6.702  1.00 35.25           C 
ATOM    356  O   ALA    23      -4.667  -0.374   5.483  1.00 23.23           O 
ATOM    357  CB  ALA    23      -5.635  -1.429   8.651  1.00 33.12           C 
ATOM    358  H   ALA    23      -6.897  -1.225   5.867  1.00 38.03           H 
ATOM    359  HA  ALA    23      -6.160   0.539   8.034  1.00 70.41           H 
ATOM    360 1HB  ALA    23      -6.529  -1.578   9.239  1.00 50.23           H 
ATOM    361 2HB  ALA    23      -4.840  -1.075   9.291  1.00 75.13           H 
ATOM    362 3HB  ALA    23      -5.343  -2.365   8.199  1.00 74.43           H 
ATOM    363  N   LEU    24      -3.554   0.192   7.352  1.00 20.11           N 
ATOM    364  CA  LEU    24      -2.234   0.235   6.715  1.00 23.54           C 
ATOM    365  C   LEU    24      -1.416  -0.989   7.149  1.00 42.12           C 
ATOM    366  O   LEU    24      -0.880  -1.030   8.262  1.00 52.13           O 
ATOM    367  CB  LEU    24      -1.500   1.530   7.091  1.00  1.14           C 
ATOM    368  CG  LEU    24      -0.085   1.686   6.503  1.00 11.45           C 
ATOM    369  CD1 LEU    24      -0.125   1.785   4.978  1.00 32.44           C 
ATOM    370  CD2 LEU    24       0.613   2.900   7.108  1.00 63.32           C 
ATOM    371  H   LEU    24      -3.633   0.460   8.292  1.00 38.03           H 
ATOM    372  HA  LEU    24      -2.373   0.204   5.642  1.00 44.33           H 
ATOM    373 1HB  LEU    24      -1.425   1.574   8.169  1.00 41.40           H 
ATOM    374 2HB  LEU    24      -2.102   2.367   6.760  1.00  1.24           H 
ATOM    375  HG  LEU    24       0.495   0.812   6.757  1.00 72.14           H 
ATOM    376 1HD1 LEU    24      -0.719   2.638   4.685  1.00 64.44           H 
ATOM    377 2HD1 LEU    24      -0.561   0.885   4.567  1.00 65.13           H 
ATOM    378 3HD1 LEU    24       0.881   1.901   4.597  1.00  0.11           H 
ATOM    379 1HD2 LEU    24       0.064   3.797   6.860  1.00 44.42           H 
ATOM    380 2HD2 LEU    24       1.616   2.971   6.713  1.00 12.43           H 
ATOM    381 3HD2 LEU    24       0.659   2.790   8.182  1.00 73.44           H 
ATOM    382  N   ARG    25      -1.339  -1.990   6.279  1.00 42.05           N 
ATOM    383  CA  ARG    25      -0.709  -3.273   6.622  1.00 54.11           C 
ATOM    384  C   ARG    25       0.755  -3.104   7.055  1.00 43.24           C 
ATOM    385  O   ARG    25       1.128  -3.474   8.169  1.00  4.35           O 
ATOM    386  CB  ARG    25      -0.807  -4.243   5.433  1.00  3.12           C 
ATOM    387  CG  ARG    25      -0.213  -5.631   5.689  1.00 25.31           C 
ATOM    388  CD  ARG    25      -0.729  -6.258   6.985  1.00 11.22           C 
ATOM    389  NE  ARG    25      -2.158  -6.034   7.187  1.00 60.15           N 
ATOM    390  CZ  ARG    25      -2.832  -6.474   8.213  1.00 44.21           C 
ATOM    391  NH1 ARG    25      -2.299  -7.304   9.052  1.00 71.12           N 
ATOM    392  NH2 ARG    25      -4.058  -6.104   8.373  1.00  0.55           N 
ATOM    393  H   ARG    25      -1.713  -1.868   5.381  1.00 38.03           H 
ATOM    394  HA  ARG    25      -1.263  -3.691   7.453  1.00 35.01           H 
ATOM    395 1HB  ARG    25      -0.288  -3.806   4.589  1.00 54.14           H 
ATOM    396 2HB  ARG    25      -1.849  -4.366   5.170  1.00 72.51           H 
ATOM    397 1HG  ARG    25       0.864  -5.545   5.746  1.00  3.04           H 
ATOM    398 2HG  ARG    25      -0.474  -6.277   4.864  1.00 41.22           H 
ATOM    399 1HD  ARG    25      -0.185  -5.832   7.817  1.00 21.10           H 
ATOM    400 2HD  ARG    25      -0.548  -7.323   6.949  1.00 11.03           H 
ATOM    401  HE  ARG    25      -2.630  -5.469   6.537  1.00 73.15           H 
ATOM    402 1HH1 ARG    25      -1.360  -7.613   8.922  1.00 24.42           H 
ATOM    403 2HH1 ARG    25      -2.827  -7.625   9.834  1.00 14.31           H 
ATOM    404 1HH2 ARG    25      -4.475  -5.474   7.715  1.00 34.00           H 
ATOM    405 2HH2 ARG    25      -4.584  -6.431   9.156  1.00 31.21           H 
ATOM    406  N   ARG    26       1.576  -2.543   6.175  1.00 23.43           N 
ATOM    407  CA  ARG    26       2.999  -2.362   6.465  1.00 71.24           C 
ATOM    408  C   ARG    26       3.679  -1.465   5.428  1.00 73.33           C 
ATOM    409  O   ARG    26       3.462  -1.613   4.229  1.00 52.22           O 
ATOM    410  CB  ARG    26       3.706  -3.726   6.513  1.00 73.01           C 
ATOM    411  CG  ARG    26       5.213  -3.633   6.727  1.00 21.14           C 
ATOM    412  CD  ARG    26       5.863  -5.009   6.824  1.00 54.54           C 
ATOM    413  NE  ARG    26       7.309  -4.920   7.019  1.00 44.44           N 
ATOM    414  CZ  ARG    26       8.148  -5.886   6.760  1.00 30.43           C 
ATOM    415  NH1 ARG    26       7.717  -7.051   6.387  1.00 33.33           N 
ATOM    416  NH2 ARG    26       9.417  -5.692   6.913  1.00 74.11           N 
ATOM    417  H   ARG    26       1.220  -2.240   5.313  1.00 38.03           H 
ATOM    418  HA  ARG    26       3.080  -1.891   7.434  1.00 50.00           H 
ATOM    419 1HB  ARG    26       3.527  -4.245   5.580  1.00 42.12           H 
ATOM    420 2HB  ARG    26       3.284  -4.306   7.321  1.00 74.05           H 
ATOM    421 1HG  ARG    26       5.402  -3.091   7.640  1.00 52.20           H 
ATOM    422 2HG  ARG    26       5.652  -3.100   5.895  1.00 33.44           H 
ATOM    423 1HD  ARG    26       5.663  -5.557   5.912  1.00 33.04           H 
ATOM    424 2HD  ARG    26       5.433  -5.538   7.662  1.00 14.10           H 
ATOM    425  HE  ARG    26       7.668  -4.072   7.357  1.00 70.33           H 
ATOM    426 1HH1 ARG    26       6.736  -7.213   6.302  1.00 34.54           H 
ATOM    427 2HH1 ARG    26       8.362  -7.783   6.187  1.00 40.30           H 
ATOM    428 1HH2 ARG    26       9.747  -4.806   7.233  1.00 14.51           H 
ATOM    429 2HH2 ARG    26      10.063  -6.421   6.706  1.00 20.25           H 
ATOM    430  N   GLU    27       4.495  -0.530   5.899  1.00 70.42           N 
ATOM    431  CA  GLU    27       5.300   0.310   5.011  1.00 55.44           C 
ATOM    432  C   GLU    27       6.732  -0.237   4.926  1.00 34.15           C 
ATOM    433  O   GLU    27       7.556   0.013   5.809  1.00 11.52           O 
ATOM    434  CB  GLU    27       5.310   1.762   5.519  1.00 52.40           C 
ATOM    435  CG  GLU    27       3.916   2.368   5.648  1.00 52.02           C 
ATOM    436  CD  GLU    27       3.926   3.773   6.233  1.00 15.32           C 
ATOM    437  OE1 GLU    27       3.647   4.734   5.490  1.00 13.11           O 
ATOM    438  OE2 GLU    27       4.206   3.918   7.444  1.00 43.23           O 
ATOM    439  H   GLU    27       4.558  -0.398   6.869  1.00 38.03           H 
ATOM    440  HA  GLU    27       4.856   0.283   4.025  1.00  0.23           H 
ATOM    441 1HB  GLU    27       5.883   2.371   4.833  1.00 41.01           H 
ATOM    442 2HB  GLU    27       5.782   1.789   6.492  1.00 51.23           H 
ATOM    443 1HG  GLU    27       3.321   1.733   6.291  1.00 23.10           H 
ATOM    444 2HG  GLU    27       3.463   2.405   4.668  1.00 51.04           H 
ATOM    445  N   VAL    28       7.018  -0.998   3.867  1.00 44.22           N 
ATOM    446  CA  VAL    28       8.340  -1.609   3.693  1.00 51.31           C 
ATOM    447  C   VAL    28       9.398  -0.539   3.390  1.00 41.00           C 
ATOM    448  O   VAL    28       9.167   0.368   2.587  1.00  3.43           O 
ATOM    449  CB  VAL    28       8.338  -2.692   2.581  1.00 12.33           C 
ATOM    450  CG1 VAL    28       7.398  -3.838   2.949  1.00  4.31           C 
ATOM    451  CG2 VAL    28       7.956  -2.091   1.229  1.00 50.52           C 
ATOM    452  H   VAL    28       6.332  -1.134   3.182  1.00 38.03           H 
ATOM    453  HA  VAL    28       8.601  -2.091   4.629  1.00  4.04           H 
ATOM    454  HB  VAL    28       9.340  -3.094   2.499  1.00 53.41           H 
ATOM    455 1HG1 VAL    28       7.700  -4.263   3.896  1.00 34.25           H 
ATOM    456 2HG1 VAL    28       7.439  -4.600   2.185  1.00  2.32           H 
ATOM    457 3HG1 VAL    28       6.386  -3.465   3.031  1.00  0.32           H 
ATOM    458 1HG2 VAL    28       7.963  -2.865   0.474  1.00 12.01           H 
ATOM    459 2HG2 VAL    28       8.668  -1.323   0.960  1.00 34.13           H 
ATOM    460 3HG2 VAL    28       6.969  -1.657   1.293  1.00 45.13           H 
ATOM    461  N   ARG    29      10.552  -0.644   4.038  1.00 65.11           N 
ATOM    462  CA  ARG    29      11.562   0.415   3.991  1.00 44.03           C 
ATOM    463  C   ARG    29      12.873  -0.043   3.332  1.00 33.34           C 
ATOM    464  O   ARG    29      13.078  -1.227   3.063  1.00 41.20           O 
ATOM    465  CB  ARG    29      11.813   0.933   5.413  1.00 23.24           C 
ATOM    466  CG  ARG    29      10.540   1.442   6.091  1.00  1.20           C 
ATOM    467  CD  ARG    29      10.816   2.069   7.450  1.00 73.53           C 
ATOM    468  NE  ARG    29       9.590   2.569   8.073  1.00 32.04           N 
ATOM    469  CZ  ARG    29       9.551   3.535   8.950  1.00 31.52           C 
ATOM    470  NH1 ARG    29      10.645   4.102   9.349  1.00 40.11           N 
ATOM    471  NH2 ARG    29       8.415   3.926   9.429  1.00 74.23           N 
ATOM    472  H   ARG    29      10.735  -1.454   4.560  1.00 38.03           H 
ATOM    473  HA  ARG    29      11.158   1.225   3.398  1.00 13.21           H 
ATOM    474 1HB  ARG    29      12.524   1.746   5.370  1.00  4.31           H 
ATOM    475 2HB  ARG    29      12.226   0.134   6.013  1.00 71.55           H 
ATOM    476 1HG  ARG    29       9.859   0.611   6.220  1.00 32.33           H 
ATOM    477 2HG  ARG    29      10.081   2.186   5.455  1.00 75.45           H 
ATOM    478 1HD  ARG    29      11.504   2.892   7.319  1.00 43.11           H 
ATOM    479 2HD  ARG    29      11.260   1.326   8.096  1.00 73.10           H 
ATOM    480  HE  ARG    29       8.747   2.154   7.804  1.00 22.33           H 
ATOM    481 1HH1 ARG    29      11.519   3.800   8.989  1.00 73.13           H 
ATOM    482 2HH1 ARG    29      10.610   4.839  10.023  1.00 72.01           H 
ATOM    483 1HH2 ARG    29       7.571   3.486   9.133  1.00 33.41           H 
ATOM    484 2HH2 ARG    29       8.382   4.678  10.088  1.00 63.31           H 
ATOM    485  N   ILE    30      13.754   0.920   3.076  1.00 73.14           N 
ATOM    486  CA  ILE    30      15.016   0.666   2.373  1.00 64.23           C 
ATOM    487  C   ILE    30      16.035  -0.037   3.286  1.00 62.23           C 
ATOM    488  O   ILE    30      16.502   0.538   4.267  1.00 43.02           O 
ATOM    489  CB  ILE    30      15.623   1.994   1.851  1.00 24.30           C 
ATOM    490  CG1 ILE    30      14.569   2.779   1.050  1.00 41.01           C 
ATOM    491  CG2 ILE    30      16.856   1.717   0.989  1.00 23.11           C 
ATOM    492  CD1 ILE    30      14.999   4.179   0.662  1.00 31.33           C 
ATOM    493  H   ILE    30      13.552   1.832   3.373  1.00 38.03           H 
ATOM    494  HA  ILE    30      14.804   0.030   1.522  1.00 75.34           H 
ATOM    495  HB  ILE    30      15.933   2.586   2.703  1.00 24.42           H 
ATOM    496 1HG1 ILE    30      13.668   2.864   1.640  1.00 12.24           H 
ATOM    497 2HG1 ILE    30      14.342   2.244   0.139  1.00  3.52           H 
ATOM    498 1HG2 ILE    30      17.590   1.178   1.570  1.00 42.52           H 
ATOM    499 2HG2 ILE    30      17.281   2.652   0.653  1.00 61.30           H 
ATOM    500 3HG2 ILE    30      16.570   1.124   0.131  1.00 23.31           H 
ATOM    501 1HD1 ILE    30      14.219   4.645   0.078  1.00 63.31           H 
ATOM    502 2HD1 ILE    30      15.907   4.132   0.079  1.00  4.53           H 
ATOM    503 3HD1 ILE    30      15.174   4.762   1.557  1.00 52.23           H 
ATOM    504  N   GLN    31      16.374  -1.282   2.962  1.00  4.21           N 
ATOM    505  CA  GLN    31      17.310  -2.070   3.775  1.00 60.32           C 
ATOM    506  C   GLN    31      18.776  -1.760   3.426  1.00  2.41           C 
ATOM    507  O   GLN    31      19.151  -1.711   2.254  1.00  4.24           O 
ATOM    508  CB  GLN    31      17.027  -3.568   3.587  1.00 11.31           C 
ATOM    509  CG  GLN    31      17.959  -4.483   4.374  1.00 62.12           C 
ATOM    510  CD  GLN    31      17.587  -5.950   4.248  1.00 62.13           C 
ATOM    511  OE1 GLN    31      17.037  -6.384   3.238  1.00 34.24           O 
ATOM    512  NE2 GLN    31      17.878  -6.724   5.271  1.00 63.40           N 
ATOM    513  H   GLN    31      15.981  -1.687   2.161  1.00 38.03           H 
ATOM    514  HA  GLN    31      17.142  -1.816   4.813  1.00 42.34           H 
ATOM    515 1HB  GLN    31      17.124  -3.810   2.537  1.00 15.40           H 
ATOM    516 2HB  GLN    31      16.011  -3.770   3.898  1.00 23.14           H 
ATOM    517 1HG  GLN    31      17.917  -4.204   5.419  1.00 44.43           H 
ATOM    518 2HG  GLN    31      18.967  -4.352   4.010  1.00 70.45           H 
ATOM    519 1HE2 GLN    31      18.308  -6.318   6.052  1.00 10.34           H 
ATOM    520 2HE2 GLN    31      17.658  -7.674   5.205  1.00  1.20           H 
ATOM    521  N   ASN    32      19.605  -1.561   4.454  1.00 61.43           N 
ATOM    522  CA  ASN    32      21.033  -1.276   4.258  1.00 53.10           C 
ATOM    523  C   ASN    32      21.819  -2.572   3.993  1.00  4.14           C 
ATOM    524  O   ASN    32      21.450  -3.640   4.486  1.00  3.33           O 
ATOM    525  CB  ASN    32      21.611  -0.557   5.487  1.00 10.53           C 
ATOM    526  CG  ASN    32      20.880   0.737   5.808  1.00 33.41           C 
ATOM    527  OD1 ASN    32      21.215   1.804   5.303  1.00 33.32           O 
ATOM    528  ND2 ASN    32      19.882   0.657   6.666  1.00  1.53           N 
ATOM    529  H   ASN    32      19.253  -1.621   5.366  1.00 38.03           H 
ATOM    530  HA  ASN    32      21.129  -0.628   3.397  1.00 45.03           H 
ATOM    531 1HB  ASN    32      22.652  -0.326   5.308  1.00 51.23           H 
ATOM    532 2HB  ASN    32      21.538  -1.209   6.345  1.00 43.12           H 
ATOM    533 1HD2 ASN    32      19.666  -0.219   7.043  1.00 25.43           H 
ATOM    534 2HD2 ASN    32      19.405   1.480   6.892  1.00 32.52           H 
ATOM    535  N   GLU    33      22.909  -2.470   3.229  1.00  3.20           N 
ATOM    536  CA  GLU    33      23.714  -3.647   2.860  1.00 64.42           C 
ATOM    537  C   GLU    33      24.241  -4.392   4.094  1.00 63.13           C 
ATOM    538  O   GLU    33      24.360  -5.619   4.089  1.00 60.23           O 
ATOM    539  CB  GLU    33      24.897  -3.235   1.971  1.00 10.22           C 
ATOM    540  CG  GLU    33      24.491  -2.625   0.632  1.00 51.42           C 
ATOM    541  CD  GLU    33      25.688  -2.323  -0.259  1.00 23.33           C 
ATOM    542  OE1 GLU    33      26.138  -3.232  -0.986  1.00 65.51           O 
ATOM    543  OE2 GLU    33      26.192  -1.179  -0.227  1.00 52.55           O 
ATOM    544  H   GLU    33      23.186  -1.585   2.907  1.00 38.03           H 
ATOM    545  HA  GLU    33      23.077  -4.315   2.299  1.00 62.32           H 
ATOM    546 1HB  GLU    33      25.503  -4.109   1.773  1.00 13.11           H 
ATOM    547 2HB  GLU    33      25.496  -2.509   2.503  1.00 41.44           H 
ATOM    548 1HG  GLU    33      23.954  -1.704   0.816  1.00 41.14           H 
ATOM    549 2HG  GLU    33      23.841  -3.319   0.118  1.00 25.22           H 
ATOM    550  N   ASP    34      24.560  -3.641   5.144  1.00 11.03           N 
ATOM    551  CA  ASP    34      25.068  -4.211   6.395  1.00 51.43           C 
ATOM    552  C   ASP    34      24.071  -5.199   7.024  1.00 74.11           C 
ATOM    553  O   ASP    34      24.464  -6.123   7.737  1.00 72.41           O 
ATOM    554  CB  ASP    34      25.376  -3.080   7.380  1.00 43.21           C 
ATOM    555  CG  ASP    34      26.375  -2.088   6.817  1.00 72.13           C 
ATOM    556  OD1 ASP    34      25.997  -1.307   5.919  1.00 53.52           O 
ATOM    557  OD2 ASP    34      27.534  -2.068   7.277  1.00 72.11           O 
ATOM    558  H   ASP    34      24.460  -2.668   5.074  1.00 38.03           H 
ATOM    559  HA  ASP    34      25.984  -4.738   6.171  1.00 24.22           H 
ATOM    560 1HB  ASP    34      25.780  -3.499   8.291  1.00  5.34           H 
ATOM    561 2HB  ASP    34      24.461  -2.551   7.609  1.00 40.13           H 
ATOM    562  N   GLY    35      22.782  -5.000   6.754  1.00 12.34           N 
ATOM    563  CA  GLY    35      21.759  -5.885   7.299  1.00 53.01           C 
ATOM    564  C   GLY    35      20.526  -5.138   7.794  1.00 32.30           C 
ATOM    565  O   GLY    35      19.412  -5.393   7.334  1.00 42.24           O 
ATOM    566  H   GLY    35      22.524  -4.257   6.172  1.00 38.03           H 
ATOM    567 1HA  GLY    35      22.179  -6.444   8.125  1.00 45.53           H 
ATOM    568 2HA  GLY    35      21.460  -6.581   6.529  1.00  5.14           H 
ATOM    569  N   SER    36      20.727  -4.208   8.729  1.00 53.54           N 
ATOM    570  CA  SER    36      19.615  -3.444   9.326  1.00 64.41           C 
ATOM    571  C   SER    36      18.875  -2.583   8.291  1.00  1.02           C 
ATOM    572  O   SER    36      19.461  -2.101   7.318  1.00 72.14           O 
ATOM    573  CB  SER    36      20.117  -2.547  10.467  1.00 61.32           C 
ATOM    574  OG  SER    36      20.658  -3.310  11.536  1.00 44.14           O 
ATOM    575  H   SER    36      21.646  -4.033   9.034  1.00 38.03           H 
ATOM    576  HA  SER    36      18.917  -4.161   9.735  1.00 20.12           H 
ATOM    577 1HB  SER    36      19.292  -1.959  10.844  1.00 51.04           H 
ATOM    578 2HB  SER    36      20.885  -1.885  10.092  1.00 61.34           H 
ATOM    579  HG  SER    36      20.516  -2.838  12.366  1.00 33.21           H 
ATOM    580  N   VAL    37      17.586  -2.374   8.524  1.00 50.21           N 
ATOM    581  CA  VAL    37      16.742  -1.593   7.619  1.00  2.34           C 
ATOM    582  C   VAL    37      16.727  -0.107   8.015  1.00 72.32           C 
ATOM    583  O   VAL    37      16.829   0.234   9.194  1.00 40.44           O 
ATOM    584  CB  VAL    37      15.295  -2.148   7.609  1.00 20.54           C 
ATOM    585  CG1 VAL    37      14.430  -1.426   6.577  1.00 15.04           C 
ATOM    586  CG2 VAL    37      15.310  -3.654   7.353  1.00 41.23           C 
ATOM    587  H   VAL    37      17.182  -2.761   9.332  1.00 38.03           H 
ATOM    588  HA  VAL    37      17.146  -1.685   6.620  1.00 53.44           H 
ATOM    589  HB  VAL    37      14.860  -1.979   8.585  1.00  1.44           H 
ATOM    590 1HG1 VAL    37      14.385  -0.374   6.815  1.00 13.03           H 
ATOM    591 2HG1 VAL    37      13.431  -1.840   6.589  1.00 23.23           H 
ATOM    592 3HG1 VAL    37      14.858  -1.554   5.592  1.00 70.02           H 
ATOM    593 1HG2 VAL    37      15.749  -3.853   6.387  1.00 63.40           H 
ATOM    594 2HG2 VAL    37      14.299  -4.035   7.374  1.00 64.24           H 
ATOM    595 3HG2 VAL    37      15.894  -4.144   8.120  1.00 20.31           H 
ATOM    596  N   SER    38      16.607   0.767   7.021  1.00 51.31           N 
ATOM    597  CA  SER    38      16.623   2.221   7.250  1.00 72.25           C 
ATOM    598  C   SER    38      15.259   2.748   7.710  1.00 65.43           C 
ATOM    599  O   SER    38      14.267   2.016   7.760  1.00 33.54           O 
ATOM    600  CB  SER    38      17.039   2.959   5.968  1.00 62.33           C 
ATOM    601  OG  SER    38      17.008   4.368   6.146  1.00 64.51           O 
ATOM    602  H   SER    38      16.493   0.432   6.107  1.00 38.03           H 
ATOM    603  HA  SER    38      17.352   2.427   8.021  1.00 72.52           H 
ATOM    604 1HB  SER    38      16.360   2.698   5.168  1.00 62.11           H 
ATOM    605 2HB  SER    38      18.044   2.665   5.695  1.00 34.12           H 
ATOM    606  HG  SER    38      17.881   4.736   5.950  1.00  0.41           H 
ATOM    607  N   ASP    39      15.225   4.032   8.045  1.00 55.54           N 
ATOM    608  CA  ASP    39      13.990   4.710   8.437  1.00 15.11           C 
ATOM    609  C   ASP    39      13.254   5.282   7.210  1.00 72.13           C 
ATOM    610  O   ASP    39      12.102   5.710   7.305  1.00 31.44           O 
ATOM    611  CB  ASP    39      14.307   5.817   9.450  1.00 25.44           C 
ATOM    612  CG  ASP    39      15.365   6.788   8.949  1.00 25.22           C 
ATOM    613  OD1 ASP    39      16.535   6.372   8.788  1.00  1.12           O 
ATOM    614  OD2 ASP    39      15.039   7.970   8.723  1.00 64.33           O 
ATOM    615  H   ASP    39      16.062   4.546   8.027  1.00 38.03           H 
ATOM    616  HA  ASP    39      13.349   3.980   8.911  1.00  2.51           H 
ATOM    617 1HB  ASP    39      14.666   5.365  10.364  1.00 13.25           H 
ATOM    618 2HB  ASP    39      13.404   6.371   9.665  1.00 54.23           H 
ATOM    619  N   GLU    40      13.927   5.272   6.057  1.00  4.12           N 
ATOM    620  CA  GLU    40      13.331   5.738   4.797  1.00 62.14           C 
ATOM    621  C   GLU    40      12.461   4.657   4.142  1.00 71.23           C 
ATOM    622  O   GLU    40      12.790   3.470   4.172  1.00 50.15           O 
ATOM    623  CB  GLU    40      14.426   6.199   3.827  1.00 42.32           C 
ATOM    624  CG  GLU    40      15.109   7.495   4.249  1.00 12.15           C 
ATOM    625  CD  GLU    40      14.145   8.672   4.311  1.00 54.34           C 
ATOM    626  OE1 GLU    40      13.903   9.306   3.263  1.00 55.13           O 
ATOM    627  OE2 GLU    40      13.616   8.962   5.405  1.00 14.55           O 
ATOM    628  H   GLU    40      14.854   4.947   6.053  1.00 38.03           H 
ATOM    629  HA  GLU    40      12.698   6.586   5.031  1.00  1.34           H 
ATOM    630 1HB  GLU    40      13.990   6.348   2.848  1.00  3.34           H 
ATOM    631 2HB  GLU    40      15.180   5.425   3.761  1.00 65.01           H 
ATOM    632 1HG  GLU    40      15.891   7.722   3.539  1.00 60.31           H 
ATOM    633 2HG  GLU    40      15.544   7.352   5.227  1.00 11.34           H 
ATOM    634  N   ILE    41      11.370   5.088   3.518  1.00 53.25           N 
ATOM    635  CA  ILE    41      10.355   4.172   2.978  1.00 24.45           C 
ATOM    636  C   ILE    41      10.710   3.673   1.562  1.00 13.22           C 
ATOM    637  O   ILE    41      11.418   4.344   0.812  1.00 52.43           O 
ATOM    638  CB  ILE    41       8.964   4.863   2.925  1.00 31.23           C 
ATOM    639  CG1 ILE    41       8.601   5.481   4.288  1.00  1.23           C 
ATOM    640  CG2 ILE    41       7.879   3.872   2.489  1.00  0.44           C 
ATOM    641  CD1 ILE    41       8.314   4.464   5.372  1.00 34.44           C 
ATOM    642  H   ILE    41      11.247   6.057   3.405  1.00 38.03           H 
ATOM    643  HA  ILE    41      10.283   3.321   3.643  1.00  3.11           H 
ATOM    644  HB  ILE    41       9.011   5.651   2.185  1.00 23.44           H 
ATOM    645 1HG1 ILE    41       7.720   6.097   4.171  1.00 11.52           H 
ATOM    646 2HG1 ILE    41       9.420   6.100   4.626  1.00 65.22           H 
ATOM    647 1HG2 ILE    41       7.852   3.042   3.181  1.00 73.41           H 
ATOM    648 2HG2 ILE    41       8.101   3.506   1.497  1.00 60.22           H 
ATOM    649 3HG2 ILE    41       6.919   4.368   2.481  1.00 71.22           H 
ATOM    650 1HD1 ILE    41       9.166   3.808   5.490  1.00 53.12           H 
ATOM    651 2HD1 ILE    41       7.445   3.883   5.097  1.00 64.35           H 
ATOM    652 3HD1 ILE    41       8.124   4.976   6.303  1.00 11.23           H 
ATOM    653  N   LYS    42      10.209   2.488   1.209  1.00 13.55           N 
ATOM    654  CA  LYS    42      10.345   1.945  -0.149  1.00 24.51           C 
ATOM    655  C   LYS    42       8.960   1.853  -0.825  1.00 22.30           C 
ATOM    656  O   LYS    42       8.732   2.441  -1.884  1.00 24.53           O 
ATOM    657  CB  LYS    42      11.014   0.562  -0.102  1.00 24.33           C 
ATOM    658  CG  LYS    42      11.343  -0.016  -1.475  1.00 62.14           C 
ATOM    659  CD  LYS    42      12.324   0.870  -2.240  1.00 33.01           C 
ATOM    660  CE  LYS    42      12.662   0.300  -3.609  1.00 60.32           C 
ATOM    661  NZ  LYS    42      13.573   1.196  -4.369  1.00 72.54           N 
ATOM    662  H   LYS    42       9.731   1.962   1.883  1.00 38.03           H 
ATOM    663  HA  LYS    42      10.969   2.622  -0.721  1.00 72.43           H 
ATOM    664 1HB  LYS    42      10.352  -0.128   0.406  1.00 62.41           H 
ATOM    665 2HB  LYS    42      11.934   0.638   0.462  1.00 11.51           H 
ATOM    666 1HG  LYS    42      10.429  -0.103  -2.046  1.00 31.10           H 
ATOM    667 2HG  LYS    42      11.782  -0.996  -1.348  1.00 43.35           H 
ATOM    668 1HD  LYS    42      13.235   0.962  -1.663  1.00 70.42           H 
ATOM    669 2HD  LYS    42      11.883   1.848  -2.371  1.00 43.50           H 
ATOM    670 1HE  LYS    42      11.747   0.169  -4.170  1.00 25.12           H 
ATOM    671 2HE  LYS    42      13.145  -0.659  -3.478  1.00  0.15           H 
ATOM    672 1HZ  LYS    42      14.465   1.328  -3.851  1.00 32.04           H 
ATOM    673 2HZ  LYS    42      13.130   2.126  -4.508  1.00 31.13           H 
ATOM    674 3HZ  LYS    42      13.786   0.786  -5.299  1.00 43.43           H 
ATOM    675  N   GLU    43       8.043   1.109  -0.197  1.00 64.02           N 
ATOM    676  CA  GLU    43       6.634   1.039  -0.625  1.00 41.54           C 
ATOM    677  C   GLU    43       5.694   1.002   0.592  1.00 53.40           C 
ATOM    678  O   GLU    43       6.114   0.671   1.703  1.00 51.32           O 
ATOM    679  CB  GLU    43       6.377  -0.200  -1.501  1.00 32.35           C 
ATOM    680  CG  GLU    43       7.136  -0.198  -2.820  1.00 35.30           C 
ATOM    681  CD  GLU    43       6.641  -1.263  -3.794  1.00 33.11           C 
ATOM    682  OE1 GLU    43       7.330  -2.290  -3.965  1.00 42.54           O 
ATOM    683  OE2 GLU    43       5.554  -1.083  -4.391  1.00 72.45           O 
ATOM    684  H   GLU    43       8.319   0.584   0.576  1.00 38.03           H 
ATOM    685  HA  GLU    43       6.417   1.927  -1.203  1.00 15.30           H 
ATOM    686 1HB  GLU    43       5.318  -0.256  -1.721  1.00 54.03           H 
ATOM    687 2HB  GLU    43       6.663  -1.084  -0.948  1.00 72.25           H 
ATOM    688 1HG  GLU    43       8.184  -0.372  -2.616  1.00 30.51           H 
ATOM    689 2HG  GLU    43       7.023   0.773  -3.276  1.00 71.51           H 
ATOM    690  N   ARG    44       4.422   1.338   0.381  1.00 35.34           N 
ATOM    691  CA  ARG    44       3.419   1.317   1.457  1.00 73.22           C 
ATOM    692  C   ARG    44       2.285   0.326   1.132  1.00 31.44           C 
ATOM    693  O   ARG    44       1.563   0.500   0.150  1.00 74.32           O 
ATOM    694  CB  ARG    44       2.831   2.721   1.672  1.00 75.45           C 
ATOM    695  CG  ARG    44       3.879   3.821   1.843  1.00 55.22           C 
ATOM    696  CD  ARG    44       3.234   5.163   2.173  1.00 42.23           C 
ATOM    697  NE  ARG    44       4.183   6.277   2.093  1.00 60.31           N 
ATOM    698  CZ  ARG    44       4.378   7.152   3.048  1.00 64.32           C 
ATOM    699  NH1 ARG    44       3.842   6.986   4.211  1.00  3.41           N 
ATOM    700  NH2 ARG    44       5.145   8.174   2.847  1.00 25.25           N 
ATOM    701  H   ARG    44       4.147   1.604  -0.522  1.00 38.03           H 
ATOM    702  HA  ARG    44       3.910   1.000   2.366  1.00 32.01           H 
ATOM    703 1HB  ARG    44       2.212   2.703   2.558  1.00 61.32           H 
ATOM    704 2HB  ARG    44       2.212   2.975   0.822  1.00 44.33           H 
ATOM    705 1HG  ARG    44       4.441   3.916   0.924  1.00 11.35           H 
ATOM    706 2HG  ARG    44       4.546   3.548   2.648  1.00 53.45           H 
ATOM    707 1HD  ARG    44       2.829   5.114   3.174  1.00 53.14           H 
ATOM    708 2HD  ARG    44       2.431   5.342   1.472  1.00 12.03           H 
ATOM    709  HE  ARG    44       4.665   6.396   1.256  1.00 54.34           H 
ATOM    710 1HH1 ARG    44       3.278   6.181   4.391  1.00 41.03           H 
ATOM    711 2HH1 ARG    44       4.000   7.656   4.936  1.00 63.20           H 
ATOM    712 1HH2 ARG    44       5.588   8.301   1.964  1.00 33.45           H 
ATOM    713 2HH2 ARG    44       5.289   8.839   3.579  1.00 12.11           H 
ATOM    714  N   THR    45       2.131  -0.705   1.962  1.00  2.33           N 
ATOM    715  CA  THR    45       1.095  -1.733   1.748  1.00 51.21           C 
ATOM    716  C   THR    45      -0.178  -1.446   2.568  1.00 53.41           C 
ATOM    717  O   THR    45      -0.132  -1.365   3.800  1.00 11.32           O 
ATOM    718  CB  THR    45       1.618  -3.144   2.123  1.00 23.32           C 
ATOM    719  OG1 THR    45       2.821  -3.437   1.391  1.00 54.35           O 
ATOM    720  CG2 THR    45       0.570  -4.219   1.835  1.00 35.04           C 
ATOM    721  H   THR    45       2.728  -0.783   2.735  1.00 38.03           H 
ATOM    722  HA  THR    45       0.841  -1.737   0.696  1.00 73.20           H 
ATOM    723  HB  THR    45       1.844  -3.155   3.182  1.00 61.14           H 
ATOM    724  HG1 THR    45       2.946  -2.779   0.697  1.00 53.41           H 
ATOM    725 1HG2 THR    45       0.295  -4.184   0.790  1.00 41.03           H 
ATOM    726 2HG2 THR    45      -0.306  -4.043   2.441  1.00 15.34           H 
ATOM    727 3HG2 THR    45       0.978  -5.192   2.067  1.00 54.51           H 
ATOM    728  N   TYR    46      -1.311  -1.306   1.878  1.00 63.40           N 
ATOM    729  CA  TYR    46      -2.603  -1.018   2.522  1.00 72.32           C 
ATOM    730  C   TYR    46      -3.548  -2.233   2.489  1.00  1.04           C 
ATOM    731  O   TYR    46      -3.463  -3.086   1.601  1.00 65.01           O 
ATOM    732  CB  TYR    46      -3.298   0.155   1.816  1.00 33.02           C 
ATOM    733  CG  TYR    46      -2.516   1.455   1.830  1.00  4.10           C 
ATOM    734  CD1 TYR    46      -2.855   2.484   2.700  1.00 12.21           C 
ATOM    735  CD2 TYR    46      -1.453   1.658   0.960  1.00 21.03           C 
ATOM    736  CE1 TYR    46      -2.159   3.678   2.701  1.00 10.35           C 
ATOM    737  CE2 TYR    46      -0.750   2.843   0.957  1.00 52.54           C 
ATOM    738  CZ  TYR    46      -1.106   3.853   1.827  1.00 10.33           C 
ATOM    739  OH  TYR    46      -0.407   5.041   1.821  1.00  1.03           O 
ATOM    740  H   TYR    46      -1.282  -1.396   0.904  1.00 38.03           H 
ATOM    741  HA  TYR    46      -2.415  -0.746   3.554  1.00 75.12           H 
ATOM    742 1HB  TYR    46      -4.251   0.339   2.295  1.00 43.31           H 
ATOM    743 2HB  TYR    46      -3.471  -0.110   0.785  1.00  4.15           H 
ATOM    744  HD1 TYR    46      -3.675   2.338   3.388  1.00 54.12           H 
ATOM    745  HD2 TYR    46      -1.174   0.867   0.278  1.00 51.41           H 
ATOM    746  HE1 TYR    46      -2.439   4.465   3.385  1.00 41.21           H 
ATOM    747  HE2 TYR    46       0.076   2.978   0.272  1.00 62.02           H 
ATOM    748  HH  TYR    46      -0.182   5.274   0.916  1.00 21.43           H 
ATOM    749  N   ASP    47      -4.462  -2.282   3.457  1.00 31.32           N 
ATOM    750  CA  ASP    47      -5.517  -3.300   3.502  1.00 25.41           C 
ATOM    751  C   ASP    47      -6.825  -2.755   2.903  1.00 60.53           C 
ATOM    752  O   ASP    47      -7.443  -1.849   3.471  1.00 74.55           O 
ATOM    753  CB  ASP    47      -5.774  -3.726   4.954  1.00 32.23           C 
ATOM    754  CG  ASP    47      -4.574  -4.384   5.604  1.00 12.14           C 
ATOM    755  OD1 ASP    47      -4.023  -5.341   5.025  1.00 62.03           O 
ATOM    756  OD2 ASP    47      -4.175  -3.950   6.701  1.00 32.00           O 
ATOM    757  H   ASP    47      -4.426  -1.613   4.169  1.00 38.03           H 
ATOM    758  HA  ASP    47      -5.190  -4.160   2.930  1.00 74.10           H 
ATOM    759 1HB  ASP    47      -6.598  -4.426   4.975  1.00  4.43           H 
ATOM    760 2HB  ASP    47      -6.040  -2.851   5.533  1.00 73.22           H 
ATOM    761  N   LEU    48      -7.242  -3.297   1.759  1.00 63.31           N 
ATOM    762  CA  LEU    48      -8.516  -2.901   1.136  1.00 15.53           C 
ATOM    763  C   LEU    48      -9.430  -4.118   0.918  1.00 15.41           C 
ATOM    764  O   LEU    48      -8.972  -5.181   0.492  1.00 61.30           O 
ATOM    765  CB  LEU    48      -8.266  -2.205  -0.215  1.00 55.31           C 
ATOM    766  CG  LEU    48      -7.406  -0.929  -0.171  1.00 71.53           C 
ATOM    767  CD1 LEU    48      -7.264  -0.321  -1.566  1.00 41.21           C 
ATOM    768  CD2 LEU    48      -7.992   0.096   0.794  1.00 60.44           C 
ATOM    769  H   LEU    48      -6.681  -3.975   1.318  1.00 38.03           H 
ATOM    770  HA  LEU    48      -9.011  -2.207   1.802  1.00 51.14           H 
ATOM    771 1HB  LEU    48      -9.225  -1.951  -0.647  1.00 54.13           H 
ATOM    772 2HB  LEU    48      -7.778  -2.915  -0.870  1.00  3.21           H 
ATOM    773  HG  LEU    48      -6.416  -1.187   0.178  1.00 70.10           H 
ATOM    774 1HD1 LEU    48      -8.239  -0.045  -1.942  1.00  2.34           H 
ATOM    775 2HD1 LEU    48      -6.813  -1.043  -2.231  1.00 23.03           H 
ATOM    776 3HD1 LEU    48      -6.638   0.557  -1.513  1.00 65.21           H 
ATOM    777 1HD2 LEU    48      -8.034  -0.325   1.788  1.00 40.34           H 
ATOM    778 2HD2 LEU    48      -8.990   0.368   0.476  1.00 42.23           H 
ATOM    779 3HD2 LEU    48      -7.368   0.979   0.805  1.00  5.44           H 
ATOM    780  N   LYS    49     -10.724  -3.965   1.212  1.00 45.14           N 
ATOM    781  CA  LYS    49     -11.701  -5.024   0.924  1.00 60.20           C 
ATOM    782  C   LYS    49     -12.439  -4.729  -0.389  1.00 45.21           C 
ATOM    783  O   LYS    49     -12.771  -3.578  -0.681  1.00 44.14           O 
ATOM    784  CB  LYS    49     -12.718  -5.194   2.071  1.00 72.24           C 
ATOM    785  CG  LYS    49     -13.657  -4.002   2.281  1.00 52.03           C 
ATOM    786  CD  LYS    49     -13.239  -3.123   3.457  1.00  0.15           C 
ATOM    787  CE  LYS    49     -13.415  -3.841   4.792  1.00 40.23           C 
ATOM    788  NZ  LYS    49     -13.027  -2.978   5.936  1.00 22.05           N 
ATOM    789  H   LYS    49     -11.029  -3.123   1.615  1.00 38.03           H 
ATOM    790  HA  LYS    49     -11.154  -5.950   0.805  1.00  4.43           H 
ATOM    791 1HB  LYS    49     -12.173  -5.366   2.990  1.00 70.24           H 
ATOM    792 2HB  LYS    49     -13.324  -6.065   1.864  1.00  1.45           H 
ATOM    793 1HG  LYS    49     -14.656  -4.376   2.463  1.00 50.34           H 
ATOM    794 2HG  LYS    49     -13.662  -3.400   1.386  1.00 51.42           H 
ATOM    795 1HD  LYS    49     -13.846  -2.228   3.456  1.00 45.23           H 
ATOM    796 2HD  LYS    49     -12.199  -2.849   3.340  1.00 75.20           H 
ATOM    797 1HE  LYS    49     -12.796  -4.728   4.798  1.00  3.20           H 
ATOM    798 2HE  LYS    49     -14.451  -4.124   4.905  1.00 40.24           H 
ATOM    799 1HZ  LYS    49     -12.022  -2.724   5.863  1.00 73.11           H 
ATOM    800 2HZ  LYS    49     -13.184  -3.480   6.836  1.00 24.12           H 
ATOM    801 3HZ  LYS    49     -13.597  -2.107   5.936  1.00 11.23           H 
ATOM    802  N   SER    50     -12.682  -5.772  -1.180  1.00 73.12           N 
ATOM    803  CA  SER    50     -13.362  -5.624  -2.472  1.00 55.40           C 
ATOM    804  C   SER    50     -14.506  -6.635  -2.624  1.00  4.21           C 
ATOM    805  O   SER    50     -14.462  -7.735  -2.070  1.00 24.42           O 
ATOM    806  CB  SER    50     -12.362  -5.795  -3.624  1.00  3.55           C 
ATOM    807  OG  SER    50     -11.766  -7.084  -3.604  1.00 20.51           O 
ATOM    808  H   SER    50     -12.396  -6.665  -0.893  1.00 38.03           H 
ATOM    809  HA  SER    50     -13.777  -4.626  -2.519  1.00 41.42           H 
ATOM    810 1HB  SER    50     -11.584  -5.052  -3.531  1.00  3.22           H 
ATOM    811 2HB  SER    50     -12.872  -5.663  -4.567  1.00 20.24           H 
ATOM    812  HG  SER    50     -10.889  -7.030  -3.214  1.00 13.21           H 
ATOM    813  N   LYS    51     -15.541  -6.248  -3.366  1.00 54.32           N 
ATOM    814  CA  LYS    51     -16.681  -7.133  -3.628  1.00  1.12           C 
ATOM    815  C   LYS    51     -16.364  -8.142  -4.744  1.00 34.41           C 
ATOM    816  O   LYS    51     -16.046  -7.757  -5.871  1.00  1.12           O 
ATOM    817  CB  LYS    51     -17.921  -6.312  -4.013  1.00 64.33           C 
ATOM    818  CG  LYS    51     -18.490  -5.466  -2.878  1.00 72.11           C 
ATOM    819  CD  LYS    51     -18.936  -6.328  -1.697  1.00 41.12           C 
ATOM    820  CE  LYS    51     -19.703  -5.518  -0.655  1.00 62.12           C 
ATOM    821  NZ  LYS    51     -20.944  -4.916  -1.218  1.00 60.35           N 
ATOM    822  H   LYS    51     -15.537  -5.348  -3.748  1.00 38.03           H 
ATOM    823  HA  LYS    51     -16.892  -7.678  -2.718  1.00 70.32           H 
ATOM    824 1HB  LYS    51     -18.695  -6.988  -4.348  1.00 22.25           H 
ATOM    825 2HB  LYS    51     -17.662  -5.651  -4.829  1.00 60.44           H 
ATOM    826 1HG  LYS    51     -19.339  -4.909  -3.248  1.00 55.11           H 
ATOM    827 2HG  LYS    51     -17.730  -4.776  -2.539  1.00 22.35           H 
ATOM    828 1HD  LYS    51     -18.062  -6.763  -1.230  1.00 72.31           H 
ATOM    829 2HD  LYS    51     -19.578  -7.116  -2.064  1.00 35.21           H 
ATOM    830 1HE  LYS    51     -19.064  -4.728  -0.286  1.00  4.21           H 
ATOM    831 2HE  LYS    51     -19.971  -6.170   0.162  1.00 32.54           H 
ATOM    832 1HZ  LYS    51     -20.705  -4.244  -1.977  1.00 52.15           H 
ATOM    833 2HZ  LYS    51     -21.465  -4.408  -0.474  1.00 35.32           H 
ATOM    834 3HZ  LYS    51     -21.561  -5.656  -1.608  1.00 55.44           H 
ATOM    835  N   GLY    52     -16.464  -9.431  -4.428  1.00 34.23           N 
ATOM    836  CA  GLY    52     -16.205 -10.473  -5.419  1.00  2.21           C 
ATOM    837  C   GLY    52     -15.995 -11.851  -4.797  1.00 23.21           C 
ATOM    838  O   GLY    52     -16.958 -12.542  -4.457  1.00 52.40           O 
ATOM    839  H   GLY    52     -16.714  -9.679  -3.513  1.00 38.03           H 
ATOM    840 1HA  GLY    52     -15.322 -10.208  -5.982  1.00 64.35           H 
ATOM    841 2HA  GLY    52     -17.046 -10.523  -6.095  1.00 61.13           H 
ATOM    842  N   GLN    53     -14.735 -12.243  -4.632  1.00 43.02           N 
ATOM    843  CA  GLN    53     -14.388 -13.566  -4.093  1.00 50.23           C 
ATOM    844  C   GLN    53     -14.193 -13.535  -2.566  1.00 54.42           C 
ATOM    845  O   GLN    53     -13.922 -14.567  -1.947  1.00  0.02           O 
ATOM    846  CB  GLN    53     -13.117 -14.090  -4.779  1.00  1.44           C 
ATOM    847  CG  GLN    53     -13.237 -14.208  -6.297  1.00  3.50           C 
ATOM    848  CD  GLN    53     -14.342 -15.159  -6.732  1.00  3.52           C 
ATOM    849  OE1 GLN    53     -15.487 -14.762  -6.924  1.00 34.45           O 
ATOM    850  NE2 GLN    53     -14.010 -16.423  -6.889  1.00 52.20           N 
ATOM    851  H   GLN    53     -14.014 -11.629  -4.887  1.00 38.03           H 
ATOM    852  HA  GLN    53     -15.204 -14.237  -4.321  1.00 51.12           H 
ATOM    853 1HB  GLN    53     -12.882 -15.067  -4.382  1.00 55.22           H 
ATOM    854 2HB  GLN    53     -12.300 -13.417  -4.559  1.00  4.31           H 
ATOM    855 1HG  GLN    53     -12.297 -14.566  -6.692  1.00 24.50           H 
ATOM    856 2HG  GLN    53     -13.445 -13.229  -6.707  1.00 43.21           H 
ATOM    857 1HE2 GLN    53     -13.083 -16.684  -6.720  1.00 64.02           H 
ATOM    858 2HE2 GLN    53     -14.708 -17.048  -7.171  1.00 22.54           H 
ATOM    859  N   GLY    54     -14.331 -12.351  -1.966  1.00 41.33           N 
ATOM    860  CA  GLY    54     -14.203 -12.217  -0.513  1.00 14.14           C 
ATOM    861  C   GLY    54     -12.756 -12.235  -0.023  1.00 21.44           C 
ATOM    862  O   GLY    54     -12.461 -12.750   1.059  1.00 50.42           O 
ATOM    863  H   GLY    54     -14.528 -11.561  -2.511  1.00 38.03           H 
ATOM    864 1HA  GLY    54     -14.742 -13.026  -0.039  1.00 55.31           H 
ATOM    865 2HA  GLY    54     -14.654 -11.283  -0.212  1.00 22.41           H 
ATOM    866  N   ARG    55     -11.850 -11.667  -0.813  1.00 32.52           N 
ATOM    867  CA  ARG    55     -10.428 -11.619  -0.454  1.00 23.45           C 
ATOM    868  C   ARG    55      -9.956 -10.192  -0.130  1.00 43.42           C 
ATOM    869  O   ARG    55     -10.187  -9.258  -0.898  1.00 31.52           O 
ATOM    870  CB  ARG    55      -9.573 -12.210  -1.588  1.00 13.52           C 
ATOM    871  CG  ARG    55      -9.421 -13.730  -1.529  1.00 73.50           C 
ATOM    872  CD  ARG    55      -8.607 -14.163  -0.311  1.00  0.04           C 
ATOM    873  NE  ARG    55      -8.364 -15.604  -0.283  1.00 34.53           N 
ATOM    874  CZ  ARG    55      -7.361 -16.163   0.344  1.00 41.42           C 
ATOM    875  NH1 ARG    55      -6.504 -15.446   0.992  1.00 32.23           N 
ATOM    876  NH2 ARG    55      -7.222 -17.445   0.325  1.00  3.32           N 
ATOM    877  H   ARG    55     -12.140 -11.270  -1.661  1.00 38.03           H 
ATOM    878  HA  ARG    55     -10.293 -12.229   0.430  1.00  4.20           H 
ATOM    879 1HB  ARG    55      -8.584 -11.771  -1.548  1.00 62.35           H 
ATOM    880 2HB  ARG    55     -10.026 -11.953  -2.534  1.00 33.23           H 
ATOM    881 1HG  ARG    55      -8.917 -14.066  -2.424  1.00  1.41           H 
ATOM    882 2HG  ARG    55     -10.401 -14.183  -1.476  1.00 44.10           H 
ATOM    883 1HD  ARG    55      -9.144 -13.881   0.584  1.00 72.10           H 
ATOM    884 2HD  ARG    55      -7.655 -13.650  -0.332  1.00 63.33           H 
ATOM    885  HE  ARG    55      -8.996 -16.181  -0.756  1.00 12.01           H 
ATOM    886 1HH1 ARG    55      -6.602 -14.455   1.023  1.00 52.24           H 
ATOM    887 2HH1 ARG    55      -5.738 -15.887   1.461  1.00 20.33           H 
ATOM    888 1HH2 ARG    55      -7.882 -18.007  -0.169  1.00 60.20           H 
ATOM    889 2HH2 ARG    55      -6.459 -17.868   0.804  1.00 51.33           H 
ATOM    890  N   MET    56      -9.301 -10.035   1.020  1.00 44.22           N 
ATOM    891  CA  MET    56      -8.649  -8.768   1.371  1.00 42.10           C 
ATOM    892  C   MET    56      -7.379  -8.578   0.524  1.00 21.21           C 
ATOM    893  O   MET    56      -6.450  -9.382   0.592  1.00 62.50           O 
ATOM    894  CB  MET    56      -8.321  -8.727   2.875  1.00  5.31           C 
ATOM    895  CG  MET    56      -7.436  -9.873   3.359  1.00 21.35           C 
ATOM    896  SD  MET    56      -7.092  -9.790   5.133  1.00 63.43           S 
ATOM    897  CE  MET    56      -8.743  -9.946   5.817  1.00 72.51           C 
ATOM    898  H   MET    56      -9.257 -10.786   1.648  1.00 38.03           H 
ATOM    899  HA  MET    56      -9.342  -7.968   1.143  1.00 13.40           H 
ATOM    900 1HB  MET    56      -9.247  -8.759   3.431  1.00 42.31           H 
ATOM    901 2HB  MET    56      -7.816  -7.797   3.097  1.00 33.11           H 
ATOM    902 1HG  MET    56      -6.499  -9.838   2.824  1.00 20.23           H 
ATOM    903 2HG  MET    56      -7.934 -10.810   3.146  1.00 33.22           H 
ATOM    904 1HE  MET    56      -9.365  -9.140   5.452  1.00 54.42           H 
ATOM    905 2HE  MET    56      -8.693  -9.898   6.896  1.00 70.41           H 
ATOM    906 3HE  MET    56      -9.169 -10.892   5.518  1.00 21.44           H 
ATOM    907  N   ILE    57      -7.343  -7.519  -0.275  1.00 44.11           N 
ATOM    908  CA  ILE    57      -6.249  -7.320  -1.230  1.00  1.30           C 
ATOM    909  C   ILE    57      -5.142  -6.424  -0.656  1.00 62.51           C 
ATOM    910  O   ILE    57      -5.417  -5.421   0.010  1.00 61.12           O 
ATOM    911  CB  ILE    57      -6.767  -6.715  -2.562  1.00 34.42           C 
ATOM    912  CG1 ILE    57      -7.395  -5.326  -2.336  1.00 41.25           C 
ATOM    913  CG2 ILE    57      -7.776  -7.662  -3.216  1.00 71.41           C 
ATOM    914  CD1 ILE    57      -7.899  -4.667  -3.606  1.00 60.11           C 
ATOM    915  H   ILE    57      -8.059  -6.850  -0.219  1.00 38.03           H 
ATOM    916  HA  ILE    57      -5.822  -8.291  -1.451  1.00  1.23           H 
ATOM    917  HB  ILE    57      -5.925  -6.616  -3.233  1.00 62.55           H 
ATOM    918 1HG1 ILE    57      -6.653  -4.671  -1.898  1.00 53.21           H 
ATOM    919 2HG1 ILE    57      -8.230  -5.416  -1.658  1.00 43.10           H 
ATOM    920 1HG2 ILE    57      -8.603  -7.834  -2.541  1.00  4.15           H 
ATOM    921 2HG2 ILE    57      -7.296  -8.603  -3.441  1.00 61.11           H 
ATOM    922 3HG2 ILE    57      -8.146  -7.222  -4.132  1.00 22.41           H 
ATOM    923 1HD1 ILE    57      -8.330  -3.707  -3.366  1.00 64.34           H 
ATOM    924 2HD1 ILE    57      -8.651  -5.294  -4.065  1.00 32.33           H 
ATOM    925 3HD1 ILE    57      -7.076  -4.531  -4.292  1.00  1.20           H 
ATOM    926  N   GLN    58      -3.888  -6.804  -0.904  1.00 75.55           N 
ATOM    927  CA  GLN    58      -2.741  -6.021  -0.436  1.00 32.25           C 
ATOM    928  C   GLN    58      -2.276  -5.031  -1.512  1.00 23.44           C 
ATOM    929  O   GLN    58      -1.633  -5.417  -2.485  1.00 52.52           O 
ATOM    930  CB  GLN    58      -1.591  -6.967  -0.058  1.00 34.13           C 
ATOM    931  CG  GLN    58      -1.957  -7.971   1.032  1.00 64.23           C 
ATOM    932  CD  GLN    58      -2.190  -7.316   2.386  1.00 74.11           C 
ATOM    933  OE1 GLN    58      -1.273  -7.190   3.189  1.00 51.23           O 
ATOM    934  NE2 GLN    58      -3.409  -6.889   2.648  1.00 43.25           N 
ATOM    935  H   GLN    58      -3.727  -7.636  -1.410  1.00 38.03           H 
ATOM    936  HA  GLN    58      -3.044  -5.469   0.443  1.00  0.12           H 
ATOM    937 1HB  GLN    58      -0.754  -6.377   0.291  1.00 54.15           H 
ATOM    938 2HB  GLN    58      -1.288  -7.516  -0.939  1.00 73.12           H 
ATOM    939 1HG  GLN    58      -1.152  -8.688   1.130  1.00 24.40           H 
ATOM    940 2HG  GLN    58      -2.859  -8.489   0.739  1.00 52.32           H 
ATOM    941 1HE2 GLN    58      -4.102  -7.014   1.972  1.00  1.33           H 
ATOM    942 2HE2 GLN    58      -3.564  -6.449   3.513  1.00 22.43           H 
ATOM    943  N   VAL    59      -2.591  -3.753  -1.326  1.00  4.45           N 
ATOM    944  CA  VAL    59      -2.241  -2.718  -2.309  1.00 30.25           C 
ATOM    945  C   VAL    59      -0.965  -1.968  -1.905  1.00 20.54           C 
ATOM    946  O   VAL    59      -0.931  -1.287  -0.884  1.00 23.02           O 
ATOM    947  CB  VAL    59      -3.397  -1.702  -2.495  1.00 73.23           C 
ATOM    948  CG1 VAL    59      -3.020  -0.613  -3.503  1.00 53.41           C 
ATOM    949  CG2 VAL    59      -4.672  -2.424  -2.926  1.00 53.45           C 
ATOM    950  H   VAL    59      -3.072  -3.496  -0.509  1.00 38.03           H 
ATOM    951  HA  VAL    59      -2.069  -3.207  -3.259  1.00 21.45           H 
ATOM    952  HB  VAL    59      -3.585  -1.225  -1.541  1.00 43.44           H 
ATOM    953 1HG1 VAL    59      -2.152  -0.076  -3.149  1.00 23.35           H 
ATOM    954 2HG1 VAL    59      -3.844   0.075  -3.617  1.00  3.51           H 
ATOM    955 3HG1 VAL    59      -2.797  -1.067  -4.459  1.00 34.40           H 
ATOM    956 1HG2 VAL    59      -4.507  -2.916  -3.874  1.00 22.54           H 
ATOM    957 2HG2 VAL    59      -5.477  -1.709  -3.027  1.00 14.30           H 
ATOM    958 3HG2 VAL    59      -4.939  -3.160  -2.180  1.00 54.44           H 
ATOM    959  N   SER    60       0.079  -2.093  -2.720  1.00 30.53           N 
ATOM    960  CA  SER    60       1.375  -1.464  -2.423  1.00 10.42           C 
ATOM    961  C   SER    60       1.687  -0.321  -3.397  1.00 43.11           C 
ATOM    962  O   SER    60       1.704  -0.514  -4.613  1.00 35.23           O 
ATOM    963  CB  SER    60       2.503  -2.504  -2.475  1.00 30.45           C 
ATOM    964  OG  SER    60       3.745  -1.930  -2.103  1.00  4.40           O 
ATOM    965  H   SER    60      -0.022  -2.617  -3.545  1.00 38.03           H 
ATOM    966  HA  SER    60       1.325  -1.059  -1.422  1.00 23.51           H 
ATOM    967 1HB  SER    60       2.586  -2.896  -3.479  1.00 14.11           H 
ATOM    968 2HB  SER    60       2.277  -3.310  -1.794  1.00 23.24           H 
ATOM    969  HG  SER    60       4.258  -1.728  -2.897  1.00 23.32           H 
ATOM    970  N   ILE    61       1.935   0.868  -2.852  1.00 70.05           N 
ATOM    971  CA  ILE    61       2.318   2.037  -3.659  1.00 42.11           C 
ATOM    972  C   ILE    61       3.747   2.494  -3.321  1.00 11.12           C 
ATOM    973  O   ILE    61       4.185   2.377  -2.175  1.00 31.32           O 
ATOM    974  CB  ILE    61       1.331   3.218  -3.451  1.00 34.21           C 
ATOM    975  CG1 ILE    61       1.280   3.630  -1.971  1.00 45.51           C 
ATOM    976  CG2 ILE    61      -0.062   2.849  -3.965  1.00 32.31           C 
ATOM    977  CD1 ILE    61       0.366   4.804  -1.691  1.00 14.01           C 
ATOM    978  H   ILE    61       1.861   0.965  -1.878  1.00 38.03           H 
ATOM    979  HA  ILE    61       2.284   1.750  -4.703  1.00 63.33           H 
ATOM    980  HB  ILE    61       1.685   4.057  -4.037  1.00 24.11           H 
ATOM    981 1HG1 ILE    61       2.275   3.900  -1.643  1.00 72.01           H 
ATOM    982 2HG1 ILE    61       0.929   2.795  -1.382  1.00 54.50           H 
ATOM    983 1HG2 ILE    61      -0.003   2.597  -5.015  1.00 33.12           H 
ATOM    984 2HG2 ILE    61      -0.730   3.690  -3.837  1.00 73.22           H 
ATOM    985 3HG2 ILE    61      -0.441   2.000  -3.412  1.00 24.14           H 
ATOM    986 1HD1 ILE    61       0.394   5.039  -0.638  1.00 44.21           H 
ATOM    987 2HD1 ILE    61      -0.645   4.552  -1.975  1.00 54.24           H 
ATOM    988 3HD1 ILE    61       0.695   5.661  -2.258  1.00 21.04           H 
ATOM    989  N   PRO    62       4.500   3.027  -4.305  1.00 60.24           N 
ATOM    990  CA  PRO    62       5.904   3.440  -4.091  1.00 61.14           C 
ATOM    991  C   PRO    62       6.064   4.597  -3.077  1.00 70.05           C 
ATOM    992  O   PRO    62       5.137   5.376  -2.849  1.00  4.04           O 
ATOM    993  CB  PRO    62       6.364   3.878  -5.490  1.00 34.11           C 
ATOM    994  CG  PRO    62       5.106   4.211  -6.224  1.00 50.44           C 
ATOM    995  CD  PRO    62       4.057   3.273  -5.693  1.00 52.14           C 
ATOM    996  HA  PRO    62       6.507   2.602  -3.763  1.00 73.21           H 
ATOM    997 1HB  PRO    62       6.897   3.067  -5.969  1.00 72.22           H 
ATOM    998 2HB  PRO    62       7.015   4.738  -5.408  1.00 24.01           H 
ATOM    999 1HG  PRO    62       5.245   4.060  -7.286  1.00 41.45           H 
ATOM   1000 2HG  PRO    62       4.826   5.237  -6.026  1.00  2.11           H 
ATOM   1001 1HD  PRO    62       4.046   2.353  -6.262  1.00 41.22           H 
ATOM   1002 2HD  PRO    62       3.082   3.743  -5.713  1.00 24.45           H 
ATOM   1003  N   ALA    63       7.263   4.709  -2.494  1.00 32.02           N 
ATOM   1004  CA  ALA    63       7.557   5.715  -1.456  1.00 31.42           C 
ATOM   1005  C   ALA    63       7.290   7.152  -1.925  1.00 34.23           C 
ATOM   1006  O   ALA    63       6.892   8.005  -1.130  1.00 61.24           O 
ATOM   1007  CB  ALA    63       9.002   5.582  -0.990  1.00 12.05           C 
ATOM   1008  H   ALA    63       7.977   4.092  -2.764  1.00 38.03           H 
ATOM   1009  HA  ALA    63       6.918   5.507  -0.610  1.00 62.32           H 
ATOM   1010 1HB  ALA    63       9.670   5.853  -1.795  1.00 73.22           H 
ATOM   1011 2HB  ALA    63       9.191   4.560  -0.696  1.00 62.43           H 
ATOM   1012 3HB  ALA    63       9.174   6.236  -0.146  1.00 60.03           H 
ATOM   1013  N   SER    64       7.511   7.418  -3.214  1.00 23.11           N 
ATOM   1014  CA  SER    64       7.278   8.758  -3.785  1.00 33.24           C 
ATOM   1015  C   SER    64       5.822   9.213  -3.593  1.00 22.01           C 
ATOM   1016  O   SER    64       5.518  10.404  -3.678  1.00 45.23           O 
ATOM   1017  CB  SER    64       7.629   8.780  -5.280  1.00 40.12           C 
ATOM   1018  OG  SER    64       8.998   8.460  -5.499  1.00  5.30           O 
ATOM   1019  H   SER    64       7.850   6.702  -3.793  1.00 38.03           H 
ATOM   1020  HA  SER    64       7.925   9.452  -3.266  1.00 13.23           H 
ATOM   1021 1HB  SER    64       7.436   9.766  -5.680  1.00 24.42           H 
ATOM   1022 2HB  SER    64       7.019   8.056  -5.802  1.00 43.44           H 
ATOM   1023  HG  SER    64       9.067   7.551  -5.814  1.00 63.04           H 
ATOM   1024  N   VAL    65       4.930   8.260  -3.342  1.00 51.35           N 
ATOM   1025  CA  VAL    65       3.521   8.561  -3.082  1.00 50.10           C 
ATOM   1026  C   VAL    65       3.270   8.748  -1.573  1.00 32.23           C 
ATOM   1027  O   VAL    65       3.622   7.883  -0.765  1.00 31.33           O 
ATOM   1028  CB  VAL    65       2.603   7.434  -3.622  1.00 73.21           C 
ATOM   1029  CG1 VAL    65       1.129   7.794  -3.438  1.00 34.34           C 
ATOM   1030  CG2 VAL    65       2.915   7.147  -5.089  1.00 65.22           C 
ATOM   1031  H   VAL    65       5.225   7.325  -3.324  1.00 38.03           H 
ATOM   1032  HA  VAL    65       3.274   9.477  -3.601  1.00 22.10           H 
ATOM   1033  HB  VAL    65       2.800   6.533  -3.055  1.00 22.53           H 
ATOM   1034 1HG1 VAL    65       0.511   6.986  -3.807  1.00 25.14           H 
ATOM   1035 2HG1 VAL    65       0.906   8.696  -3.990  1.00 60.15           H 
ATOM   1036 3HG1 VAL    65       0.921   7.953  -2.390  1.00 73.22           H 
ATOM   1037 1HG2 VAL    65       2.298   6.330  -5.436  1.00 14.42           H 
ATOM   1038 2HG2 VAL    65       3.958   6.877  -5.190  1.00 41.42           H 
ATOM   1039 3HG2 VAL    65       2.712   8.027  -5.680  1.00 51.52           H 
ATOM   1040  N   PRO    66       2.673   9.888  -1.165  1.00 71.42           N 
ATOM   1041  CA  PRO    66       2.403  10.174   0.257  1.00  2.20           C 
ATOM   1042  C   PRO    66       1.300   9.276   0.858  1.00 35.40           C 
ATOM   1043  O   PRO    66       0.512   8.663   0.135  1.00 53.31           O 
ATOM   1044  CB  PRO    66       1.957  11.644   0.239  1.00 13.22           C 
ATOM   1045  CG  PRO    66       1.394  11.848  -1.128  1.00  4.54           C 
ATOM   1046  CD  PRO    66       2.218  10.985  -2.046  1.00 33.50           C 
ATOM   1047  HA  PRO    66       3.302  10.077   0.850  1.00 54.05           H 
ATOM   1048 1HB  PRO    66       2.811  12.287   0.413  1.00 55.23           H 
ATOM   1049 2HB  PRO    66       1.214  11.813   1.006  1.00 72.23           H 
ATOM   1050 1HG  PRO    66       1.477  12.887  -1.412  1.00 31.01           H 
ATOM   1051 2HG  PRO    66       0.358  11.537  -1.147  1.00  1.31           H 
ATOM   1052 1HD  PRO    66       3.058  11.540  -2.436  1.00 25.05           H 
ATOM   1053 2HD  PRO    66       1.610  10.605  -2.857  1.00 23.01           H 
ATOM   1054  N   LEU    67       1.255   9.210   2.186  1.00  3.11           N 
ATOM   1055  CA  LEU    67       0.232   8.438   2.902  1.00  2.22           C 
ATOM   1056  C   LEU    67      -1.144   9.128   2.822  1.00 75.53           C 
ATOM   1057  O   LEU    67      -1.235  10.357   2.860  1.00 63.14           O 
ATOM   1058  CB  LEU    67       0.650   8.278   4.373  1.00 51.50           C 
ATOM   1059  CG  LEU    67      -0.292   7.434   5.252  1.00 44.43           C 
ATOM   1060  CD1 LEU    67      -0.317   5.983   4.792  1.00 64.51           C 
ATOM   1061  CD2 LEU    67       0.112   7.520   6.719  1.00 10.50           C 
ATOM   1062  H   LEU    67       1.934   9.689   2.706  1.00 38.03           H 
ATOM   1063  HA  LEU    67       0.165   7.460   2.445  1.00 42.43           H 
ATOM   1064 1HB  LEU    67       0.724   9.264   4.808  1.00  4.33           H 
ATOM   1065 2HB  LEU    67       1.633   7.825   4.393  1.00 54.22           H 
ATOM   1066  HG  LEU    67      -1.298   7.822   5.163  1.00 25.04           H 
ATOM   1067 1HD1 LEU    67      -0.692   5.932   3.781  1.00 10.35           H 
ATOM   1068 2HD1 LEU    67      -0.961   5.411   5.444  1.00 11.35           H 
ATOM   1069 3HD1 LEU    67       0.685   5.573   4.826  1.00 33.14           H 
ATOM   1070 1HD2 LEU    67       0.091   8.552   7.038  1.00 21.15           H 
ATOM   1071 2HD2 LEU    67       1.110   7.123   6.846  1.00 35.14           H 
ATOM   1072 3HD2 LEU    67      -0.583   6.947   7.316  1.00 52.14           H 
ATOM   1073  N   LYS    68      -2.210   8.337   2.693  1.00 31.51           N 
ATOM   1074  CA  LYS    68      -3.575   8.882   2.671  1.00 60.21           C 
ATOM   1075  C   LYS    68      -4.355   8.495   3.935  1.00 13.05           C 
ATOM   1076  O   LYS    68      -4.773   7.349   4.102  1.00 40.51           O 
ATOM   1077  CB  LYS    68      -4.351   8.423   1.427  1.00 33.02           C 
ATOM   1078  CG  LYS    68      -3.828   8.986   0.103  1.00 64.12           C 
ATOM   1079  CD  LYS    68      -2.595   8.241  -0.399  1.00 43.32           C 
ATOM   1080  CE  LYS    68      -1.973   8.926  -1.613  1.00 74.33           C 
ATOM   1081  NZ  LYS    68      -2.942   9.105  -2.726  1.00 20.52           N 
ATOM   1082  H   LYS    68      -2.080   7.370   2.618  1.00 38.03           H 
ATOM   1083  HA  LYS    68      -3.495   9.962   2.643  1.00 14.13           H 
ATOM   1084 1HB  LYS    68      -5.384   8.727   1.539  1.00 74.01           H 
ATOM   1085 2HB  LYS    68      -4.311   7.343   1.376  1.00 31.14           H 
ATOM   1086 1HG  LYS    68      -3.574  10.029   0.245  1.00 32.42           H 
ATOM   1087 2HG  LYS    68      -4.607   8.907  -0.642  1.00 10.02           H 
ATOM   1088 1HD  LYS    68      -2.881   7.235  -0.672  1.00 23.05           H 
ATOM   1089 2HD  LYS    68      -1.862   8.204   0.394  1.00 10.42           H 
ATOM   1090 1HE  LYS    68      -1.145   8.328  -1.963  1.00 45.51           H 
ATOM   1091 2HE  LYS    68      -1.613   9.895  -1.313  1.00 34.11           H 
ATOM   1092 1HZ  LYS    68      -2.446   9.421  -3.586  1.00 32.10           H 
ATOM   1093 2HZ  LYS    68      -3.652   9.821  -2.476  1.00 63.14           H 
ATOM   1094 3HZ  LYS    68      -3.430   8.212  -2.932  1.00 13.33           H 
ATOM   1095  N   GLU    69      -4.551   9.471   4.812  1.00 64.53           N 
ATOM   1096  CA  GLU    69      -5.273   9.267   6.070  1.00 44.03           C 
ATOM   1097  C   GLU    69      -6.793   9.153   5.839  1.00 14.02           C 
ATOM   1098  O   GLU    69      -7.542  10.098   6.107  1.00 52.20           O 
ATOM   1099  CB  GLU    69      -4.977  10.443   7.011  1.00 43.31           C 
ATOM   1100  CG  GLU    69      -3.504  10.599   7.389  1.00 64.21           C 
ATOM   1101  CD  GLU    69      -3.088   9.730   8.570  1.00  2.14           C 
ATOM   1102  OE1 GLU    69      -3.059  10.248   9.710  1.00 74.04           O 
ATOM   1103  OE2 GLU    69      -2.785   8.537   8.370  1.00 74.11           O 
ATOM   1104  H   GLU    69      -4.198  10.362   4.611  1.00 38.03           H 
ATOM   1105  HA  GLU    69      -4.915   8.353   6.524  1.00 10.04           H 
ATOM   1106 1HB  GLU    69      -5.552  10.315   7.918  1.00 33.54           H 
ATOM   1107 2HB  GLU    69      -5.297  11.353   6.523  1.00 34.53           H 
ATOM   1108 1HG  GLU    69      -3.322  11.634   7.642  1.00 41.43           H 
ATOM   1109 2HG  GLU    69      -2.895  10.333   6.536  1.00 72.31           H 
ATOM   1110  N   PHE    70      -7.242   8.012   5.320  1.00 65.54           N 
ATOM   1111  CA  PHE    70      -8.675   7.790   5.057  1.00 10.24           C 
ATOM   1112  C   PHE    70      -9.368   7.065   6.220  1.00 31.44           C 
ATOM   1113  O   PHE    70      -8.730   6.336   6.984  1.00 13.33           O 
ATOM   1114  CB  PHE    70      -8.874   6.984   3.764  1.00 52.51           C 
ATOM   1115  CG  PHE    70      -8.493   7.725   2.503  1.00 32.13           C 
ATOM   1116  CD1 PHE    70      -8.788   9.073   2.360  1.00 51.32           C 
ATOM   1117  CD2 PHE    70      -7.857   7.070   1.456  1.00 24.41           C 
ATOM   1118  CE1 PHE    70      -8.456   9.751   1.204  1.00 22.15           C 
ATOM   1119  CE2 PHE    70      -7.522   7.747   0.298  1.00 54.44           C 
ATOM   1120  CZ  PHE    70      -7.820   9.089   0.173  1.00 63.43           C 
ATOM   1121  H   PHE    70      -6.599   7.303   5.106  1.00 38.03           H 
ATOM   1122  HA  PHE    70      -9.140   8.760   4.935  1.00 61.21           H 
ATOM   1123 1HB  PHE    70      -9.915   6.703   3.681  1.00 24.12           H 
ATOM   1124 2HB  PHE    70      -8.274   6.088   3.814  1.00  0.02           H 
ATOM   1125  HD1 PHE    70      -9.283   9.597   3.165  1.00 11.42           H 
ATOM   1126  HD2 PHE    70      -7.624   6.018   1.551  1.00 14.53           H 
ATOM   1127  HE1 PHE    70      -8.696  10.800   1.106  1.00 71.10           H 
ATOM   1128  HE2 PHE    70      -7.024   7.226  -0.508  1.00  1.14           H 
ATOM   1129  HZ  PHE    70      -7.562   9.619  -0.732  1.00 25.51           H 
ATOM   1130  N   ASP    71     -10.680   7.271   6.348  1.00 63.45           N 
ATOM   1131  CA  ASP    71     -11.475   6.607   7.389  1.00 22.44           C 
ATOM   1132  C   ASP    71     -11.839   5.165   6.993  1.00 43.34           C 
ATOM   1133  O   ASP    71     -11.631   4.748   5.851  1.00  5.53           O 
ATOM   1134  CB  ASP    71     -12.743   7.423   7.683  1.00 60.43           C 
ATOM   1135  CG  ASP    71     -13.539   7.750   6.428  1.00  5.44           C 
ATOM   1136  OD1 ASP    71     -13.103   8.641   5.662  1.00 24.11           O 
ATOM   1137  OD2 ASP    71     -14.605   7.139   6.212  1.00 44.40           O 
ATOM   1138  H   ASP    71     -11.130   7.882   5.728  1.00 38.03           H 
ATOM   1139  HA  ASP    71     -10.872   6.571   8.287  1.00 23.25           H 
ATOM   1140 1HB  ASP    71     -12.462   8.352   8.160  1.00 31.40           H 
ATOM   1141 2HB  ASP    71     -13.377   6.862   8.356  1.00 50.14           H 
ATOM   1142  N   TYR    72     -12.387   4.409   7.939  1.00 54.40           N 
ATOM   1143  CA  TYR    72     -12.694   2.995   7.708  1.00 21.44           C 
ATOM   1144  C   TYR    72     -13.829   2.819   6.679  1.00 41.34           C 
ATOM   1145  O   TYR    72     -14.887   3.438   6.789  1.00 11.10           O 
ATOM   1146  CB  TYR    72     -13.053   2.301   9.032  1.00  1.03           C 
ATOM   1147  CG  TYR    72     -13.052   0.784   8.942  1.00  3.21           C 
ATOM   1148  CD1 TYR    72     -14.237   0.069   8.842  1.00 22.44           C 
ATOM   1149  CD2 TYR    72     -11.857   0.071   8.942  1.00 34.13           C 
ATOM   1150  CE1 TYR    72     -14.233  -1.309   8.741  1.00 14.34           C 
ATOM   1151  CE2 TYR    72     -11.847  -1.307   8.847  1.00 13.42           C 
ATOM   1152  CZ  TYR    72     -13.037  -1.991   8.745  1.00 60.12           C 
ATOM   1153  OH  TYR    72     -13.032  -3.364   8.625  1.00 62.34           O 
ATOM   1154  H   TYR    72     -12.592   4.810   8.812  1.00 38.03           H 
ATOM   1155  HA  TYR    72     -11.800   2.532   7.311  1.00 60.11           H 
ATOM   1156 1HB  TYR    72     -14.039   2.619   9.345  1.00 54.01           H 
ATOM   1157 2HB  TYR    72     -12.334   2.586   9.787  1.00 34.31           H 
ATOM   1158  HD1 TYR    72     -15.176   0.605   8.839  1.00  5.23           H 
ATOM   1159  HD2 TYR    72     -10.923   0.609   9.024  1.00 52.15           H 
ATOM   1160  HE1 TYR    72     -15.168  -1.846   8.664  1.00  3.33           H 
ATOM   1161  HE2 TYR    72     -10.907  -1.842   8.850  1.00 62.23           H 
ATOM   1162  HH  TYR    72     -12.488  -3.751   9.328  1.00 23.03           H 
ATOM   1163  N   ASN    73     -13.582   1.962   5.685  1.00 13.32           N 
ATOM   1164  CA  ASN    73     -14.537   1.676   4.597  1.00  4.03           C 
ATOM   1165  C   ASN    73     -14.728   2.865   3.634  1.00 14.10           C 
ATOM   1166  O   ASN    73     -15.697   2.903   2.874  1.00  3.25           O 
ATOM   1167  CB  ASN    73     -15.894   1.214   5.147  1.00 41.54           C 
ATOM   1168  CG  ASN    73     -15.807  -0.117   5.875  1.00 64.11           C 
ATOM   1169  OD1 ASN    73     -14.941  -0.947   5.599  1.00  1.31           O 
ATOM   1170  ND2 ASN    73     -16.713  -0.339   6.806  1.00 23.20           N 
ATOM   1171  H   ASN    73     -12.724   1.494   5.682  1.00 38.03           H 
ATOM   1172  HA  ASN    73     -14.112   0.863   4.025  1.00 54.20           H 
ATOM   1173 1HB  ASN    73     -16.593   1.108   4.330  1.00 33.52           H 
ATOM   1174 2HB  ASN    73     -16.266   1.956   5.838  1.00 42.32           H 
ATOM   1175 1HD2 ASN    73     -17.383   0.356   6.974  1.00  1.51           H 
ATOM   1176 2HD2 ASN    73     -16.683  -1.191   7.284  1.00 64.11           H 
ATOM   1177  N   ALA    74     -13.795   3.815   3.642  1.00  3.42           N 
ATOM   1178  CA  ALA    74     -13.822   4.925   2.681  1.00 54.43           C 
ATOM   1179  C   ALA    74     -13.658   4.409   1.238  1.00 73.01           C 
ATOM   1180  O   ALA    74     -12.775   3.594   0.963  1.00 73.12           O 
ATOM   1181  CB  ALA    74     -12.731   5.939   3.015  1.00 22.14           C 
ATOM   1182  H   ALA    74     -13.082   3.780   4.313  1.00 38.03           H 
ATOM   1183  HA  ALA    74     -14.780   5.420   2.772  1.00 45.41           H 
ATOM   1184 1HB  ALA    74     -12.802   6.783   2.342  1.00 41.33           H 
ATOM   1185 2HB  ALA    74     -11.761   5.474   2.907  1.00 32.44           H 
ATOM   1186 3HB  ALA    74     -12.854   6.280   4.032  1.00 34.34           H 
ATOM   1187  N   ARG    75     -14.512   4.882   0.326  1.00 13.04           N 
ATOM   1188  CA  ARG    75     -14.486   4.421  -1.072  1.00 13.00           C 
ATOM   1189  C   ARG    75     -13.323   5.045  -1.861  1.00 24.42           C 
ATOM   1190  O   ARG    75     -13.255   6.266  -2.036  1.00 42.21           O 
ATOM   1191  CB  ARG    75     -15.804   4.750  -1.784  1.00 65.32           C 
ATOM   1192  CG  ARG    75     -17.039   4.090  -1.176  1.00 21.11           C 
ATOM   1193  CD  ARG    75     -18.289   4.422  -1.989  1.00 12.53           C 
ATOM   1194  NE  ARG    75     -18.418   5.863  -2.198  1.00 40.25           N 
ATOM   1195  CZ  ARG    75     -18.634   6.429  -3.356  1.00 23.40           C 
ATOM   1196  NH1 ARG    75     -18.852   5.721  -4.415  1.00 63.33           N 
ATOM   1197  NH2 ARG    75     -18.643   7.715  -3.447  1.00 23.23           N 
ATOM   1198  H   ARG    75     -15.168   5.556   0.596  1.00 38.03           H 
ATOM   1199  HA  ARG    75     -14.359   3.346  -1.061  1.00 40.51           H 
ATOM   1200 1HB  ARG    75     -15.727   4.433  -2.815  1.00 41.21           H 
ATOM   1201 2HB  ARG    75     -15.952   5.821  -1.761  1.00 74.01           H 
ATOM   1202 1HG  ARG    75     -17.169   4.448  -0.165  1.00 64.41           H 
ATOM   1203 2HG  ARG    75     -16.900   3.017  -1.167  1.00 34.31           H 
ATOM   1204 1HD  ARG    75     -19.158   4.064  -1.454  1.00 24.01           H 
ATOM   1205 2HD  ARG    75     -18.226   3.924  -2.947  1.00 62.41           H 
ATOM   1206  HE  ARG    75     -18.306   6.440  -1.419  1.00 35.10           H 
ATOM   1207 1HH1 ARG    75     -18.861   4.723  -4.359  1.00 31.31           H 
ATOM   1208 2HH1 ARG    75     -19.016   6.173  -5.288  1.00 14.15           H 
ATOM   1209 1HH2 ARG    75     -18.486   8.277  -2.638  1.00 12.33           H 
ATOM   1210 2HH2 ARG    75     -18.793   8.147  -4.335  1.00 44.00           H 
ATOM   1211  N   VAL    76     -12.430   4.194  -2.352  1.00 23.23           N 
ATOM   1212  CA  VAL    76     -11.267   4.629  -3.132  1.00 71.52           C 
ATOM   1213  C   VAL    76     -11.213   3.929  -4.502  1.00 34.20           C 
ATOM   1214  O   VAL    76     -11.861   2.904  -4.715  1.00  0.23           O 
ATOM   1215  CB  VAL    76      -9.945   4.344  -2.365  1.00 62.45           C 
ATOM   1216  CG1 VAL    76      -9.910   5.100  -1.036  1.00 24.15           C 
ATOM   1217  CG2 VAL    76      -9.759   2.844  -2.137  1.00 25.22           C 
ATOM   1218  H   VAL    76     -12.555   3.234  -2.188  1.00 38.03           H 
ATOM   1219  HA  VAL    76     -11.343   5.698  -3.291  1.00 41.24           H 
ATOM   1220  HB  VAL    76      -9.120   4.698  -2.970  1.00 15.10           H 
ATOM   1221 1HG1 VAL    76      -9.933   6.164  -1.225  1.00 20.51           H 
ATOM   1222 2HG1 VAL    76      -9.004   4.851  -0.502  1.00 64.32           H 
ATOM   1223 3HG1 VAL    76     -10.767   4.821  -0.440  1.00 45.43           H 
ATOM   1224 1HG2 VAL    76      -9.726   2.334  -3.089  1.00 32.52           H 
ATOM   1225 2HG2 VAL    76     -10.583   2.460  -1.552  1.00 51.41           H 
ATOM   1226 3HG2 VAL    76      -8.832   2.671  -1.607  1.00 53.41           H 
ATOM   1227  N   GLU    77     -10.453   4.501  -5.432  1.00 32.14           N 
ATOM   1228  CA  GLU    77     -10.163   3.849  -6.713  1.00 22.31           C 
ATOM   1229  C   GLU    77      -8.687   4.055  -7.095  1.00 72.21           C 
ATOM   1230  O   GLU    77      -8.079   5.078  -6.765  1.00 44.33           O 
ATOM   1231  CB  GLU    77     -11.103   4.349  -7.827  1.00 13.43           C 
ATOM   1232  CG  GLU    77     -11.015   5.843  -8.125  1.00 43.32           C 
ATOM   1233  CD  GLU    77     -11.925   6.257  -9.279  1.00 25.33           C 
ATOM   1234  OE1 GLU    77     -11.507   6.124 -10.449  1.00 24.54           O 
ATOM   1235  OE2 GLU    77     -13.062   6.712  -9.023  1.00 41.11           O 
ATOM   1236  H   GLU    77     -10.080   5.390  -5.259  1.00 38.03           H 
ATOM   1237  HA  GLU    77     -10.326   2.787  -6.576  1.00  5.11           H 
ATOM   1238 1HB  GLU    77     -12.122   4.122  -7.542  1.00  2.14           H 
ATOM   1239 2HB  GLU    77     -10.873   3.812  -8.737  1.00 14.51           H 
ATOM   1240 1HG  GLU    77      -9.994   6.087  -8.384  1.00 52.12           H 
ATOM   1241 2HG  GLU    77     -11.301   6.394  -7.240  1.00 50.11           H 
ATOM   1242  N   LEU    78      -8.109   3.065  -7.772  1.00 40.24           N 
ATOM   1243  CA  LEU    78      -6.675   3.073  -8.084  1.00 22.12           C 
ATOM   1244  C   LEU    78      -6.398   3.578  -9.507  1.00 42.24           C 
ATOM   1245  O   LEU    78      -7.094   3.215 -10.453  1.00 12.11           O 
ATOM   1246  CB  LEU    78      -6.097   1.662  -7.906  1.00 52.00           C 
ATOM   1247  CG  LEU    78      -6.233   1.076  -6.491  1.00 43.42           C 
ATOM   1248  CD1 LEU    78      -5.671  -0.344  -6.429  1.00 60.04           C 
ATOM   1249  CD2 LEU    78      -5.536   1.975  -5.472  1.00  3.22           C 
ATOM   1250  H   LEU    78      -8.659   2.316  -8.078  1.00 38.03           H 
ATOM   1251  HA  LEU    78      -6.188   3.737  -7.380  1.00  1.01           H 
ATOM   1252 1HB  LEU    78      -5.046   1.687  -8.161  1.00 42.52           H 
ATOM   1253 2HB  LEU    78      -6.601   1.001  -8.598  1.00 31.43           H 
ATOM   1254  HG  LEU    78      -7.281   1.027  -6.231  1.00 74.22           H 
ATOM   1255 1HD1 LEU    78      -4.619  -0.329  -6.676  1.00 55.42           H 
ATOM   1256 2HD1 LEU    78      -6.198  -0.970  -7.135  1.00 30.02           H 
ATOM   1257 3HD1 LEU    78      -5.801  -0.739  -5.432  1.00  2.23           H 
ATOM   1258 1HD2 LEU    78      -5.991   2.954  -5.487  1.00 32.14           H 
ATOM   1259 2HD2 LEU    78      -4.488   2.062  -5.724  1.00 33.34           H 
ATOM   1260 3HD2 LEU    78      -5.635   1.547  -4.486  1.00 72.01           H 
ATOM   1261  N   ILE    79      -5.368   4.417  -9.643  1.00 25.14           N 
ATOM   1262  CA  ILE    79      -4.958   4.942 -10.951  1.00 43.41           C 
ATOM   1263  C   ILE    79      -4.476   3.812 -11.886  1.00 73.05           C 
ATOM   1264  O   ILE    79      -5.153   3.457 -12.851  1.00 44.23           O 
ATOM   1265  CB  ILE    79      -3.839   6.008 -10.796  1.00 40.13           C 
ATOM   1266  CG1 ILE    79      -4.319   7.170  -9.905  1.00 12.55           C 
ATOM   1267  CG2 ILE    79      -3.382   6.525 -12.164  1.00 51.40           C 
ATOM   1268  CD1 ILE    79      -5.550   7.886 -10.433  1.00 75.21           C 
ATOM   1269  H   ILE    79      -4.882   4.704  -8.839  1.00 38.03           H 
ATOM   1270  HA  ILE    79      -5.819   5.420 -11.399  1.00 31.23           H 
ATOM   1271  HB  ILE    79      -2.991   5.531 -10.320  1.00 74.45           H 
ATOM   1272 1HG1 ILE    79      -3.526   7.899  -9.815  1.00 62.13           H 
ATOM   1273 2HG1 ILE    79      -4.560   6.787  -8.925  1.00 31.02           H 
ATOM   1274 1HG2 ILE    79      -2.995   5.703 -12.748  1.00 24.34           H 
ATOM   1275 2HG2 ILE    79      -2.605   7.264 -12.030  1.00 62.44           H 
ATOM   1276 3HG2 ILE    79      -4.218   6.971 -12.684  1.00 73.32           H 
ATOM   1277 1HD1 ILE    79      -5.834   8.667  -9.742  1.00 22.12           H 
ATOM   1278 2HD1 ILE    79      -6.362   7.181 -10.532  1.00 60.43           H 
ATOM   1279 3HD1 ILE    79      -5.329   8.321 -11.396  1.00 42.11           H 
ATOM   1280  N   ASN    80      -3.303   3.246 -11.589  1.00 21.31           N 
ATOM   1281  CA  ASN    80      -2.762   2.115 -12.362  1.00 64.23           C 
ATOM   1282  C   ASN    80      -2.489   0.894 -11.459  1.00  3.43           C 
ATOM   1283  O   ASN    80      -1.371   0.707 -10.976  1.00  4.41           O 
ATOM   1284  CB  ASN    80      -1.473   2.533 -13.090  1.00 22.30           C 
ATOM   1285  CG  ASN    80      -1.718   3.570 -14.171  1.00 21.15           C 
ATOM   1286  OD1 ASN    80      -2.761   3.576 -14.819  1.00 11.25           O 
ATOM   1287  ND2 ASN    80      -0.764   4.458 -14.373  1.00 35.24           N 
ATOM   1288  H   ASN    80      -2.786   3.599 -10.840  1.00 38.03           H 
ATOM   1289  HA  ASN    80      -3.502   1.834 -13.101  1.00 55.40           H 
ATOM   1290 1HB  ASN    80      -1.030   1.663 -13.553  1.00 70.33           H 
ATOM   1291 2HB  ASN    80      -0.777   2.945 -12.371  1.00 14.50           H 
ATOM   1292 1HD2 ASN    80       0.047   4.406 -13.823  1.00 11.45           H 
ATOM   1293 2HD2 ASN    80      -0.906   5.136 -15.063  1.00 65.41           H 
ATOM   1294  N   PRO    81      -3.527   0.078 -11.171  1.00 53.23           N 
ATOM   1295  CA  PRO    81      -3.382  -1.154 -10.376  1.00 53.25           C 
ATOM   1296  C   PRO    81      -2.892  -2.365 -11.198  1.00  1.13           C 
ATOM   1297  O   PRO    81      -3.416  -2.652 -12.278  1.00 73.44           O 
ATOM   1298  CB  PRO    81      -4.806  -1.391  -9.869  1.00 32.31           C 
ATOM   1299  CG  PRO    81      -5.685  -0.856 -10.954  1.00 61.55           C 
ATOM   1300  CD  PRO    81      -4.929   0.291 -11.593  1.00 34.01           C 
ATOM   1301  HA  PRO    81      -2.722  -1.003  -9.534  1.00  3.11           H 
ATOM   1302 1HB  PRO    81      -4.956  -0.857  -8.940  1.00 71.34           H 
ATOM   1303 2HB  PRO    81      -4.970  -2.450  -9.707  1.00 21.21           H 
ATOM   1304 1HG  PRO    81      -6.617  -0.503 -10.533  1.00 30.11           H 
ATOM   1305 2HG  PRO    81      -5.877  -1.629 -11.686  1.00 60.32           H 
ATOM   1306 1HD  PRO    81      -5.301   1.239 -11.228  1.00 22.54           H 
ATOM   1307 2HD  PRO    81      -5.015   0.247 -12.670  1.00 33.01           H 
ATOM   1308  N   ILE    82      -1.890  -3.078 -10.681  1.00 43.24           N 
ATOM   1309  CA  ILE    82      -1.396  -4.309 -11.319  1.00 41.02           C 
ATOM   1310  C   ILE    82      -1.141  -5.420 -10.281  1.00 32.45           C 
ATOM   1311  O   ILE    82      -0.425  -5.216  -9.301  1.00 34.22           O 
ATOM   1312  CB  ILE    82      -0.092  -4.064 -12.136  1.00 64.33           C 
ATOM   1313  CG1 ILE    82       1.019  -3.474 -11.247  1.00 43.23           C 
ATOM   1314  CG2 ILE    82      -0.370  -3.152 -13.332  1.00 21.32           C 
ATOM   1315  CD1 ILE    82       2.336  -3.259 -11.969  1.00 73.13           C 
ATOM   1316  H   ILE    82      -1.461  -2.768  -9.856  1.00 38.03           H 
ATOM   1317  HA  ILE    82      -2.161  -4.654 -12.007  1.00 32.21           H 
ATOM   1318  HB  ILE    82       0.240  -5.019 -12.523  1.00 22.44           H 
ATOM   1319 1HG1 ILE    82       1.203  -4.142 -10.416  1.00 71.41           H 
ATOM   1320 2HG1 ILE    82       0.698  -2.517 -10.865  1.00 34.35           H 
ATOM   1321 1HG2 ILE    82      -1.116  -3.607 -13.969  1.00 62.44           H 
ATOM   1322 2HG2 ILE    82       0.540  -3.004 -13.894  1.00 40.34           H 
ATOM   1323 3HG2 ILE    82      -0.735  -2.197 -12.980  1.00 32.53           H 
ATOM   1324 1HD1 ILE    82       2.189  -2.570 -12.787  1.00 55.44           H 
ATOM   1325 2HD1 ILE    82       2.694  -4.203 -12.352  1.00 30.45           H 
ATOM   1326 3HD1 ILE    82       3.062  -2.852 -11.281  1.00 74.40           H 
ATOM   1522  N   TRP    98      -3.272 -12.238  -1.997  1.00 52.11           N 
ATOM   1523  CA  TRP    98      -2.596 -11.809  -3.231  1.00 31.31           C 
ATOM   1524  C   TRP    98      -2.266 -10.302  -3.225  1.00 41.53           C 
ATOM   1525  O   TRP    98      -2.963  -9.494  -2.596  1.00 63.02           O 
ATOM   1526  CB  TRP    98      -3.422 -12.203  -4.470  1.00 24.41           C 
ATOM   1527  CG  TRP    98      -4.794 -11.582  -4.565  1.00  1.04           C 
ATOM   1528  CD1 TRP    98      -5.825 -11.680  -3.668  1.00 63.52           C 
ATOM   1529  CD2 TRP    98      -5.293 -10.800  -5.659  1.00 20.14           C 
ATOM   1530  NE1 TRP    98      -6.918 -10.987  -4.131  1.00 12.34           N 
ATOM   1531  CE2 TRP    98      -6.617 -10.441  -5.350  1.00 20.23           C 
ATOM   1532  CE3 TRP    98      -4.740 -10.358  -6.866  1.00 55.14           C 
ATOM   1533  CZ2 TRP    98      -7.397  -9.666  -6.204  1.00 50.04           C 
ATOM   1534  CZ3 TRP    98      -5.518  -9.593  -7.715  1.00 42.13           C 
ATOM   1535  CH2 TRP    98      -6.833  -9.253  -7.378  1.00  4.41           C 
ATOM   1536  H   TRP    98      -4.237 -12.123  -1.915  1.00 38.03           H 
ATOM   1537  HA  TRP    98      -1.656 -12.345  -3.273  1.00 23.20           H 
ATOM   1538 1HB  TRP    98      -3.547 -13.279  -4.472  1.00 44.21           H 
ATOM   1539 2HB  TRP    98      -2.874 -11.920  -5.355  1.00 10.30           H 
ATOM   1540  HD1 TRP    98      -5.773 -12.219  -2.734  1.00 74.05           H 
ATOM   1541  HE1 TRP    98      -7.776 -10.901  -3.668  1.00 53.32           H 
ATOM   1542  HE3 TRP    98      -3.725 -10.612  -7.143  1.00 44.14           H 
ATOM   1543  HZ2 TRP    98      -8.413  -9.395  -5.962  1.00 50.34           H 
ATOM   1544  HZ3 TRP    98      -5.110  -9.244  -8.652  1.00 40.34           H 
ATOM   1545  HH2 TRP    98      -7.404  -8.651  -8.071  1.00 41.45           H 
ATOM   1546  N   TYR    99      -1.190  -9.935  -3.933  1.00  2.54           N 
ATOM   1547  CA  TYR    99      -0.641  -8.572  -3.880  1.00 42.23           C 
ATOM   1548  C   TYR    99      -0.921  -7.778  -5.170  1.00 64.31           C 
ATOM   1549  O   TYR    99      -0.794  -8.292  -6.289  1.00 13.43           O 
ATOM   1550  CB  TYR    99       0.877  -8.622  -3.635  1.00 13.40           C 
ATOM   1551  CG  TYR    99       1.301  -9.557  -2.514  1.00 20.04           C 
ATOM   1552  CD1 TYR    99       1.410 -10.928  -2.732  1.00 14.32           C 
ATOM   1553  CD2 TYR    99       1.602  -9.074  -1.245  1.00  2.34           C 
ATOM   1554  CE1 TYR    99       1.805 -11.784  -1.725  1.00 51.01           C 
ATOM   1555  CE2 TYR    99       1.997  -9.928  -0.230  1.00 31.23           C 
ATOM   1556  CZ  TYR    99       2.096 -11.282  -0.476  1.00 65.03           C 
ATOM   1557  OH  TYR    99       2.502 -12.137   0.524  1.00 51.23           O 
ATOM   1558  H   TYR    99      -0.754 -10.594  -4.512  1.00 38.03           H 
ATOM   1559  HA  TYR    99      -1.107  -8.059  -3.049  1.00 12.12           H 
ATOM   1560 1HB  TYR    99       1.226  -7.627  -3.389  1.00 30.30           H 
ATOM   1561 2HB  TYR    99       1.370  -8.950  -4.540  1.00 63.42           H 
ATOM   1562  HD1 TYR    99       1.179 -11.323  -3.711  1.00 74.51           H 
ATOM   1563  HD2 TYR    99       1.524  -8.015  -1.055  1.00 23.33           H 
ATOM   1564  HE1 TYR    99       1.883 -12.845  -1.917  1.00 44.10           H 
ATOM   1565  HE2 TYR    99       2.224  -9.532   0.750  1.00 54.41           H 
ATOM   1566  HH  TYR    99       3.099 -12.804   0.150  1.00  2.41           H 
ATOM   1567  N   ILE   100      -1.292  -6.512  -4.996  1.00 53.54           N 
ATOM   1568  CA  ILE   100      -1.574  -5.603  -6.109  1.00  0.02           C 
ATOM   1569  C   ILE   100      -0.750  -4.310  -5.978  1.00 22.31           C 
ATOM   1570  O   ILE   100      -0.997  -3.486  -5.094  1.00 40.45           O 
ATOM   1571  CB  ILE   100      -3.082  -5.232  -6.161  1.00 71.22           C 
ATOM   1572  CG1 ILE   100      -3.957  -6.497  -6.166  1.00 71.54           C 
ATOM   1573  CG2 ILE   100      -3.388  -4.363  -7.382  1.00 33.23           C 
ATOM   1574  CD1 ILE   100      -5.445  -6.209  -6.151  1.00 33.02           C 
ATOM   1575  H   ILE   100      -1.375  -6.173  -4.083  1.00 38.03           H 
ATOM   1576  HA  ILE   100      -1.310  -6.101  -7.033  1.00 30.45           H 
ATOM   1577  HB  ILE   100      -3.313  -4.654  -5.278  1.00 12.22           H 
ATOM   1578 1HG1 ILE   100      -3.726  -7.091  -5.293  1.00  2.23           H 
ATOM   1579 2HG1 ILE   100      -3.744  -7.075  -7.053  1.00  3.54           H 
ATOM   1580 1HG2 ILE   100      -2.835  -3.436  -7.313  1.00 21.42           H 
ATOM   1581 2HG2 ILE   100      -4.448  -4.148  -7.416  1.00 60.35           H 
ATOM   1582 3HG2 ILE   100      -3.101  -4.886  -8.282  1.00  4.45           H 
ATOM   1583 1HD1 ILE   100      -5.719  -5.676  -7.050  1.00 42.11           H 
ATOM   1584 2HD1 ILE   100      -5.685  -5.606  -5.288  1.00 21.24           H 
ATOM   1585 3HD1 ILE   100      -5.989  -7.139  -6.101  1.00 24.33           H 
ATOM   1586  N   LYS   101       0.239  -4.139  -6.846  1.00 12.11           N 
ATOM   1587  CA  LYS   101       1.051  -2.918  -6.859  1.00 73.54           C 
ATOM   1588  C   LYS   101       0.338  -1.805  -7.648  1.00 12.02           C 
ATOM   1589  O   LYS   101      -0.107  -2.019  -8.774  1.00 32.32           O 
ATOM   1590  CB  LYS   101       2.437  -3.212  -7.457  1.00 61.50           C 
ATOM   1591  CG  LYS   101       3.256  -4.207  -6.631  1.00 73.44           C 
ATOM   1592  CD  LYS   101       4.543  -4.635  -7.339  1.00 21.22           C 
ATOM   1593  CE  LYS   101       5.499  -3.466  -7.569  1.00 64.11           C 
ATOM   1594  NZ  LYS   101       6.079  -2.944  -6.301  1.00  2.01           N 
ATOM   1595  H   LYS   101       0.427  -4.847  -7.500  1.00 38.03           H 
ATOM   1596  HA  LYS   101       1.176  -2.591  -5.832  1.00 41.33           H 
ATOM   1597 1HB  LYS   101       2.993  -2.288  -7.524  1.00  0.35           H 
ATOM   1598 2HB  LYS   101       2.308  -3.617  -8.452  1.00 23.23           H 
ATOM   1599 1HG  LYS   101       2.651  -5.085  -6.447  1.00 73.44           H 
ATOM   1600 2HG  LYS   101       3.514  -3.748  -5.688  1.00 72.03           H 
ATOM   1601 1HD  LYS   101       4.287  -5.072  -8.295  1.00 35.31           H 
ATOM   1602 2HD  LYS   101       5.043  -5.377  -6.732  1.00  5.24           H 
ATOM   1603 1HE  LYS   101       4.961  -2.669  -8.062  1.00 34.32           H 
ATOM   1604 2HE  LYS   101       6.305  -3.800  -8.205  1.00  3.21           H 
ATOM   1605 1HZ  LYS   101       6.652  -2.098  -6.493  1.00 63.31           H 
ATOM   1606 2HZ  LYS   101       6.690  -3.660  -5.858  1.00 45.02           H 
ATOM   1607 3HZ  LYS   101       5.325  -2.687  -5.631  1.00 31.44           H 
ATOM   1608  N   ALA   102       0.218  -0.624  -7.053  1.00 61.52           N 
ATOM   1609  CA  ALA   102      -0.539   0.473  -7.668  1.00  3.33           C 
ATOM   1610  C   ALA   102       0.318   1.727  -7.878  1.00  3.40           C 
ATOM   1611  O   ALA   102       1.429   1.836  -7.360  1.00 52.31           O 
ATOM   1612  CB  ALA   102      -1.755   0.806  -6.812  1.00 54.03           C 
ATOM   1613  H   ALA   102       0.648  -0.480  -6.183  1.00 38.03           H 
ATOM   1614  HA  ALA   102      -0.896   0.134  -8.632  1.00 11.12           H 
ATOM   1615 1HB  ALA   102      -1.429   1.159  -5.846  1.00 23.00           H 
ATOM   1616 2HB  ALA   102      -2.359  -0.081  -6.686  1.00 45.04           H 
ATOM   1617 3HB  ALA   102      -2.341   1.574  -7.296  1.00 54.13           H 
ATOM   1618  N   ASP   103      -0.212   2.666  -8.659  1.00 12.21           N 
ATOM   1619  CA  ASP   103       0.462   3.940  -8.912  1.00 64.42           C 
ATOM   1620  C   ASP   103       0.124   4.976  -7.823  1.00  0.21           C 
ATOM   1621  O   ASP   103       1.004   5.451  -7.108  1.00 15.41           O 
ATOM   1622  CB  ASP   103       0.057   4.465 -10.293  1.00 32.04           C 
ATOM   1623  CG  ASP   103       0.787   5.739 -10.671  1.00 53.14           C 
ATOM   1624  OD1 ASP   103       2.033   5.764 -10.573  1.00 54.02           O 
ATOM   1625  OD2 ASP   103       0.125   6.712 -11.077  1.00 11.52           O 
ATOM   1626  H   ASP   103      -1.070   2.491  -9.088  1.00 38.03           H 
ATOM   1627  HA  ASP   103       1.528   3.761  -8.905  1.00 11.53           H 
ATOM   1628 1HB  ASP   103      -1.007   4.660 -10.297  1.00 12.14           H 
ATOM   1629 2HB  ASP   103       0.280   3.712 -11.035  1.00 63.35           H 
ATOM   1630  N   ASP   104      -1.160   5.322  -7.715  1.00  3.13           N 
ATOM   1631  CA  ASP   104      -1.636   6.256  -6.692  1.00 71.02           C 
ATOM   1632  C   ASP   104      -3.047   5.875  -6.206  1.00  0.20           C 
ATOM   1633  O   ASP   104      -3.814   5.222  -6.921  1.00 51.02           O 
ATOM   1634  CB  ASP   104      -1.622   7.694  -7.233  1.00 11.24           C 
ATOM   1635  CG  ASP   104      -2.112   8.710  -6.210  1.00 23.30           C 
ATOM   1636  OD1 ASP   104      -1.689   8.633  -5.036  1.00 20.20           O 
ATOM   1637  OD2 ASP   104      -2.921   9.591  -6.571  1.00 12.23           O 
ATOM   1638  H   ASP   104      -1.803   4.945  -8.342  1.00 38.03           H 
ATOM   1639  HA  ASP   104      -0.958   6.195  -5.850  1.00 40.13           H 
ATOM   1640 1HB  ASP   104      -2.256   7.748  -8.108  1.00  4.52           H 
ATOM   1641 2HB  ASP   104      -0.611   7.954  -7.513  1.00 61.23           H 
ATOM   1642  N   ILE   105      -3.368   6.288  -4.980  1.00 32.15           N 
ATOM   1643  CA  ILE   105      -4.660   5.981  -4.350  1.00 41.35           C 
ATOM   1644  C   ILE   105      -5.524   7.247  -4.182  1.00 60.42           C 
ATOM   1645  O   ILE   105      -5.167   8.155  -3.429  1.00 60.12           O 
ATOM   1646  CB  ILE   105      -4.451   5.330  -2.955  1.00 43.41           C 
ATOM   1647  CG1 ILE   105      -3.690   3.997  -3.087  1.00 33.31           C 
ATOM   1648  CG2 ILE   105      -5.791   5.128  -2.243  1.00 10.35           C 
ATOM   1649  CD1 ILE   105      -3.415   3.310  -1.764  1.00  1.21           C 
ATOM   1650  H   ILE   105      -2.714   6.824  -4.485  1.00 38.03           H 
ATOM   1651  HA  ILE   105      -5.187   5.276  -4.981  1.00 62.24           H 
ATOM   1652  HB  ILE   105      -3.861   6.010  -2.356  1.00  0.50           H 
ATOM   1653 1HG1 ILE   105      -2.738   4.178  -3.568  1.00 32.53           H 
ATOM   1654 2HG1 ILE   105      -4.268   3.317  -3.694  1.00 13.25           H 
ATOM   1655 1HG2 ILE   105      -5.623   4.655  -1.286  1.00 22.05           H 
ATOM   1656 2HG2 ILE   105      -6.433   4.501  -2.845  1.00 64.15           H 
ATOM   1657 3HG2 ILE   105      -6.266   6.087  -2.088  1.00 74.44           H 
ATOM   1658 1HD1 ILE   105      -2.895   2.379  -1.944  1.00 25.33           H 
ATOM   1659 2HD1 ILE   105      -4.348   3.107  -1.259  1.00  0.54           H 
ATOM   1660 3HD1 ILE   105      -2.801   3.949  -1.145  1.00 11.23           H 
ATOM   1661  N   VAL   106      -6.659   7.297  -4.877  1.00 63.30           N 
ATOM   1662  CA  VAL   106      -7.599   8.426  -4.762  1.00 43.31           C 
ATOM   1663  C   VAL   106      -8.998   7.940  -4.353  1.00 22.13           C 
ATOM   1664  O   VAL   106      -9.250   6.741  -4.298  1.00 30.54           O 
ATOM   1665  CB  VAL   106      -7.700   9.217  -6.090  1.00  3.43           C 
ATOM   1666  CG1 VAL   106      -6.349   9.820  -6.469  1.00 65.25           C 
ATOM   1667  CG2 VAL   106      -8.233   8.327  -7.214  1.00 21.03           C 
ATOM   1668  H   VAL   106      -6.881   6.554  -5.483  1.00 38.03           H 
ATOM   1669  HA  VAL   106      -7.227   9.094  -3.995  1.00 32.31           H 
ATOM   1670  HB  VAL   106      -8.399  10.031  -5.945  1.00 14.53           H 
ATOM   1671 1HG1 VAL   106      -6.017  10.484  -5.683  1.00 65.21           H 
ATOM   1672 2HG1 VAL   106      -6.447  10.378  -7.391  1.00 22.24           H 
ATOM   1673 3HG1 VAL   106      -5.624   9.030  -6.603  1.00 61.32           H 
ATOM   1674 1HG2 VAL   106      -8.307   8.902  -8.125  1.00 33.22           H 
ATOM   1675 2HG2 VAL   106      -9.210   7.955  -6.946  1.00 22.33           H 
ATOM   1676 3HG2 VAL   106      -7.561   7.494  -7.367  1.00 33.51           H 
ATOM   1677  N   LEU   107      -9.903   8.871  -4.059  1.00  1.10           N 
ATOM   1678  CA  LEU   107     -11.288   8.516  -3.719  1.00  0.05           C 
ATOM   1679  C   LEU   107     -12.126   8.303  -4.988  1.00 30.30           C 
ATOM   1680  O   LEU   107     -11.865   8.920  -6.022  1.00 73.23           O 
ATOM   1681  CB  LEU   107     -11.928   9.606  -2.845  1.00 33.52           C 
ATOM   1682  CG  LEU   107     -11.286   9.800  -1.461  1.00 45.43           C 
ATOM   1683  CD1 LEU   107     -11.943  10.961  -0.718  1.00 74.32           C 
ATOM   1684  CD2 LEU   107     -11.378   8.519  -0.637  1.00  4.43           C 
ATOM   1685  H   LEU   107      -9.643   9.816  -4.076  1.00 38.03           H 
ATOM   1686  HA  LEU   107     -11.266   7.589  -3.161  1.00 54.51           H 
ATOM   1687 1HB  LEU   107     -12.971   9.360  -2.703  1.00 42.11           H 
ATOM   1688 2HB  LEU   107     -11.867  10.544  -3.380  1.00 43.34           H 
ATOM   1689  HG  LEU   107     -10.241  10.039  -1.591  1.00 13.41           H 
ATOM   1690 1HD1 LEU   107     -12.996  10.756  -0.584  1.00 14.53           H 
ATOM   1691 2HD1 LEU   107     -11.825  11.868  -1.292  1.00 54.44           H 
ATOM   1692 3HD1 LEU   107     -11.475  11.083   0.247  1.00 11.42           H 
ATOM   1693 1HD2 LEU   107     -12.417   8.256  -0.484  1.00 62.53           H 
ATOM   1694 2HD2 LEU   107     -10.902   8.672   0.320  1.00 11.32           H 
ATOM   1695 3HD2 LEU   107     -10.878   7.718  -1.160  1.00 25.04           H 
ATOM   1696  N   THR   108     -13.129   7.431  -4.899  1.00 51.23           N 
ATOM   1697  CA  THR   108     -13.996   7.125  -6.048  1.00  5.21           C 
ATOM   1698  C   THR   108     -14.769   8.370  -6.513  1.00 43.13           C 
ATOM   1699  O   THR   108     -15.734   8.790  -5.870  1.00 43.21           O 
ATOM   1700  CB  THR   108     -15.012   6.001  -5.716  1.00 21.32           C 
ATOM   1701  OG1 THR   108     -14.351   4.906  -5.062  1.00 45.23           O 
ATOM   1702  CG2 THR   108     -15.699   5.489  -6.981  1.00 75.40           C 
ATOM   1703  H   THR   108     -13.288   6.971  -4.047  1.00 38.03           H 
ATOM   1704  HA  THR   108     -13.365   6.783  -6.856  1.00 53.41           H 
ATOM   1705  HB  THR   108     -15.767   6.402  -5.055  1.00 41.42           H 
ATOM   1706  HG1 THR   108     -13.718   4.503  -5.665  1.00 55.30           H 
ATOM   1707 1HG2 THR   108     -16.392   4.702  -6.722  1.00 31.42           H 
ATOM   1708 2HG2 THR   108     -14.955   5.103  -7.665  1.00 33.42           H 
ATOM   1709 3HG2 THR   108     -16.235   6.300  -7.454  1.00 52.32           H 
END
