
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 ( 1238),  selected   78 , name 1pfs_A
# Molecule2: number of CA atoms   66 ( 1132),  selected   66 , name T0468.pdb
# PARAMETERS: 1pfs_A.T0468.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      D      12          3.927
LGA    N     2_A      V      13          2.563
LGA    I     3_A      Y      14          1.535
LGA    Q     4_A      Y      15          1.045
LGA    I     5_A      M      16          1.471
LGA    T     6_A      Q      17          1.524
LGA    F     7_A      I      18          2.518
LGA    T     8_A      K      19          1.709
LGA    D     9_A      -       -           -
LGA    S    10_A      -       -           -
LGA    V    11_A      T      23          2.517
LGA    R    12_A      -       -           -
LGA    Q    13_A      I      24          0.265
LGA    G    14_A      E      25          3.172
LGA    T    15_A      K      26          1.862
LGA    S    16_A      V      27          0.980
LGA    A    17_A      D      28          3.215
LGA    K    18_A      -       -           -
LGA    G    19_A      G      29          2.270
LGA    N    20_A      R      30          3.046
LGA    P    21_A      N      31          2.960
LGA    Y    22_A      L      32          1.495
LGA    T    23_A      R      33          1.770
LGA    F    24_A      N      34          2.358
LGA    Q    25_A      Y      35          1.025
LGA    E    26_A      T      36          2.480
LGA    G    27_A      L      37          1.225
LGA    F    28_A      P      38          1.375
LGA    L    29_A      A      39          0.867
LGA    H    30_A      Y      40          0.369
LGA    L    31_A      D      41          2.460
LGA    -       -      E      42           -
LGA    E    32_A      D      43          1.322
LGA    D    33_A      G      44          5.632
LGA    K    34_A      V      45          1.955
LGA    P    35_A      -       -           -
LGA    H    36_A      -       -           -
LGA    P    37_A      K      46          3.260
LGA    L    38_A      K      47          3.724
LGA    Q    39_A      Q      48          4.275
LGA    C    40_A      -       -           -
LGA    Q    41_A      I      49          4.600
LGA    F    42_A      T      50          1.147
LGA    F    43_A      F      51          4.066
LGA    V    44_A      R      52          0.777
LGA    E    45_A      -       -           -
LGA    S    46_A      -       -           -
LGA    V    47_A      -       -           -
LGA    I    48_A      -       -           -
LGA    P    49_A      -       -           -
LGA    A    50_A      -       -           -
LGA    G    51_A      A      66          2.440
LGA    S    52_A      F      67          0.932
LGA    Y    53_A      L      68          1.247
LGA    Q    54_A      R      69          1.445
LGA    V    55_A      L      70          1.996
LGA    P    56_A      Y      71          1.887
LGA    Y    57_A      V      72          2.095
LGA    R    58_A      -       -           -
LGA    I    59_A      -       -           -
LGA    N    60_A      -       -           -
LGA    V    61_A      -       -           -
LGA    N    62_A      -       -           -
LGA    N    63_A      -       -           -
LGA    G    64_A      -       -           -
LGA    R    65_A      -       -           -
LGA    P    66_A      -       -           -
LGA    E    67_A      -       -           -
LGA    L    68_A      -       -           -
LGA    A    69_A      -       -           -
LGA    F    70_A      K      88          3.219
LGA    D    71_A      S      89          0.926
LGA    F    72_A      Y      90          3.225
LGA    K    73_A      -       -           -
LGA    A    74_A      -       -           -
LGA    M    75_A      -       -           -
LGA    K    76_A      E      91          2.985
LGA    R    77_A      E      92          2.446
LGA    A    78_A      I      93          2.362
LGA    -       -      Q      94           -
LGA    -       -      K      95           -
LGA    -       -      A      96           -
LGA    -       -      D      97           -
LGA    -       -      L      98           -
LGA    -       -      P      99           -
LGA    -       -      E     100           -
LGA    -       -      K     101           -
LGA    -       -      V     102           -
LGA    -       -      K     103           -
LGA    -       -      D     104           -
LGA    -       -      K     105           -
LGA    -       -      F     106           -
LGA    -       -      T     107           -
LGA    -       -      I     108           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78   66    5.0     50    2.47     6.00     52.039     1.942

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.261000 * X  +   0.041492 * Y  +   0.964447 * Z  +  -9.106984
  Y_new =   0.842265 * X  +  -0.478361 * Y  +   0.248515 * Z  +  -1.515818
  Z_new =   0.471666 * X  +   0.877182 * Y  +   0.089905 * Z  + -13.828162 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.468660   -1.672932  [ DEG:    84.1480    -95.8520 ]
  Theta =  -0.491179   -2.650414  [ DEG:   -28.1425   -151.8575 ]
  Phi   =   1.871291   -1.270302  [ DEG:   107.2171    -72.7829 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1pfs_A                                        
REMARK     2: T0468.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1pfs_A.T0468.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78   66   5.0   50   2.47    6.00  52.039
REMARK  ---------------------------------------------------------- 
MOLECULE 1pfs_A
HEADER    DNA-BINDING PROTEIN                     03-AUG-96   1PFS              
TITLE     SOLUTION NMR STRUCTURE OF THE SINGLE-STRANDED DNA BINDING             
TITLE    2 PROTEIN OF THE FILAMENTOUS PSEUDOMONAS PHAGE PF3,                    
TITLE    3 MINIMIZED AVERAGE STRUCTURE                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PF3 SINGLE-STRANDED DNA BINDING PROTEIN;                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: PF3 SSDBP;                                                  
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES;                                                       
COMPND   7 OTHER_DETAILS: DIMERIC                                               
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTERIOPHAGE PF3;                              
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: MC4100;                                    
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PPF3VF36H                                 
KEYWDS    DNA-BINDING PROTEIN, VIRAL, BACTERIOPHAGE PF3, SINGLE-                
KEYWDS   2 STRANDED DNA                                                         
EXPDTA    NMR                                                                   
AUTHOR    R.H.A.FOLMER,M.NILGES,R.N.H.KONINGS,C.W.HILBERS                       
REVDAT   2   01-APR-03 1PFS    1       JRNL                                     
REVDAT   1   12-FEB-97 1PFS    0                                                
JRNL        AUTH   R.H.FOLMER,M.NILGES,R.N.KONINGS,C.W.HILBERS                  
JRNL        TITL   SOLUTION STRUCTURE OF THE SINGLE-STRANDED DNA                
JRNL        TITL 2 BINDING PROTEIN OF THE FILAMENTOUS PSEUDOMONAS               
JRNL        TITL 3 PHAGE PF3: SIMILARITY TO OTHER PROTEINS BINDING TO           
JRNL        TITL 4 SINGLE-STRANDED NUCLEIC ACIDS.                               
JRNL        REF    EMBO J.                       V.  14  4132 1995              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1PFS A    1    78  UNP    P03672   VHED_BPPF3       1     78             
DBREF  1PFS B    1    78  UNP    P03672   VHED_BPPF3       1     78             
SEQRES   1 A   78  MET ASN ILE GLN ILE THR PHE THR ASP SER VAL ARG GLN          
SEQRES   2 A   78  GLY THR SER ALA LYS GLY ASN PRO TYR THR PHE GLN GLU          
SEQRES   3 A   78  GLY PHE LEU HIS LEU GLU ASP LYS PRO HIS PRO LEU GLN          
SEQRES   4 A   78  CYS GLN PHE PHE VAL GLU SER VAL ILE PRO ALA GLY SER          
SEQRES   5 A   78  TYR GLN VAL PRO TYR ARG ILE ASN VAL ASN ASN GLY ARG          
SEQRES   6 A   78  PRO GLU LEU ALA PHE ASP PHE LYS ALA MET LYS ARG ALA          
SEQRES   1 B   78  MET ASN ILE GLN ILE THR PHE THR ASP SER VAL ARG GLN          
SEQRES   2 B   78  GLY THR SER ALA LYS GLY ASN PRO TYR THR PHE GLN GLU          
SEQRES   3 B   78  GLY PHE LEU HIS LEU GLU ASP LYS PRO HIS PRO LEU GLN          
SEQRES   4 B   78  CYS GLN PHE PHE VAL GLU SER VAL ILE PRO ALA GLY SER          
SEQRES   5 B   78  TYR GLN VAL PRO TYR ARG ILE ASN VAL ASN ASN GLY ARG          
SEQRES   6 B   78  PRO GLU LEU ALA PHE ASP PHE LYS ALA MET LYS ARG ALA          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
ATOM      1  N   MET A   1      -9.976  -6.951   6.540  1.00  0.84           N  
ATOM      2  CA  MET A   1      -8.933  -7.146   5.490  1.00  0.80           C  
ATOM      3  C   MET A   1      -8.084  -5.890   5.348  1.00  0.73           C  
ATOM      4  O   MET A   1      -8.601  -4.801   5.094  1.00  0.70           O  
ATOM      5  CB  MET A   1      -9.562  -7.479   4.138  1.00  0.83           C  
ATOM      6  CG  MET A   1     -10.513  -8.678   4.223  1.00  0.92           C  
ATOM      7  SD  MET A   1     -10.901  -9.352   2.600  1.00  1.09           S  
ATOM      8  CE  MET A   1     -12.080  -8.128   2.003  1.00  1.02           C  
ATOM      9  HA  MET A   1      -8.289  -7.961   5.788  1.00  0.88           H  
ATOM     10  HB2 MET A   1     -10.117  -6.619   3.790  1.00  0.90           H  
ATOM     11  HB3 MET A   1      -8.774  -7.700   3.431  1.00  0.81           H  
ATOM     12  HG2 MET A   1     -10.060  -9.455   4.822  1.00  1.04           H  
ATOM     13  HG3 MET A   1     -11.431  -8.359   4.694  1.00  0.87           H  
ATOM     14  HE1 MET A   1     -12.655  -7.746   2.832  1.00  1.37           H  
ATOM     15  HE2 MET A   1     -11.544  -7.314   1.533  1.00  1.44           H  
ATOM     16  HE3 MET A   1     -12.744  -8.590   1.286  1.00  1.47           H  
ATOM     17  H1  MET A   1     -10.010  -5.947   6.815  1.00  1.29           H  
ATOM     18  H2  MET A   1     -10.902  -7.240   6.168  1.00  1.19           H  
ATOM     19  H3  MET A   1      -9.744  -7.530   7.371  1.00  1.42           H  
ATOM     20  N   ASN A   2      -6.776  -6.050   5.509  1.00  0.74           N  
ATOM     21  CA  ASN A   2      -5.846  -4.933   5.395  1.00  0.68           C  
ATOM     22  C   ASN A   2      -4.538  -5.397   4.758  1.00  0.64           C  
ATOM     23  O   ASN A   2      -4.277  -6.596   4.667  1.00  0.67           O  
ATOM     24  CB  ASN A   2      -5.597  -4.323   6.781  1.00  0.74           C  
ATOM     25  CG  ASN A   2      -4.640  -5.179   7.599  1.00  0.86           C  
ATOM     26  OD1 ASN A   2      -3.534  -4.751   7.928  1.00  1.62           O  
ATOM     27  ND2 ASN A   2      -5.067  -6.388   7.925  1.00  1.23           N  
ATOM     28  H   ASN A   2      -6.427  -6.945   5.703  1.00  0.81           H  
ATOM     29  HA  ASN A   2      -6.291  -4.179   4.762  1.00  0.65           H  
ATOM     30  HB2 ASN A   2      -5.177  -3.337   6.666  1.00  0.74           H  
ATOM     31  HB3 ASN A   2      -6.535  -4.255   7.309  1.00  0.84           H  
ATOM     32 HD21 ASN A   2      -5.960  -6.662   7.627  1.00  1.94           H  
ATOM     33 HD22 ASN A   2      -4.475  -6.956   8.452  1.00  1.41           H  
ATOM     34  N   ILE A   3      -3.720  -4.445   4.323  1.00  0.58           N  
ATOM     35  CA  ILE A   3      -2.440  -4.766   3.700  1.00  0.54           C  
ATOM     36  C   ILE A   3      -1.435  -3.647   3.944  1.00  0.52           C  
ATOM     37  O   ILE A   3      -1.800  -2.472   3.997  1.00  0.51           O  
ATOM     38  CB  ILE A   3      -2.629  -4.990   2.202  1.00  0.49           C  
ATOM     39  CG1 ILE A   3      -1.336  -5.505   1.574  1.00  0.49           C  
ATOM     40  CG2 ILE A   3      -3.087  -3.708   1.509  1.00  0.43           C  
ATOM     41  CD1 ILE A   3      -1.546  -5.869   0.105  1.00  0.46           C  
ATOM     42  H   ILE A   3      -3.982  -3.506   4.426  1.00  0.58           H  
ATOM     43  HA  ILE A   3      -2.060  -5.675   4.142  1.00  0.58           H  
ATOM     44  HB  ILE A   3      -3.399  -5.738   2.068  1.00  0.53           H  
ATOM     45 HG12 ILE A   3      -0.576  -4.740   1.649  1.00  0.55           H  
ATOM     46 HG13 ILE A   3      -1.011  -6.384   2.110  1.00  0.46           H  
ATOM     47 HG21 ILE A   3      -2.833  -2.856   2.122  1.00  1.10           H  
ATOM     48 HG22 ILE A   3      -2.597  -3.623   0.552  1.00  1.02           H  
ATOM     49 HG23 ILE A   3      -4.156  -3.743   1.365  1.00  1.08           H  
ATOM     50 HD11 ILE A   3      -2.335  -5.255  -0.306  1.00  1.11           H  
ATOM     51 HD12 ILE A   3      -0.630  -5.699  -0.444  1.00  1.01           H  
ATOM     52 HD13 ILE A   3      -1.824  -6.910   0.032  1.00  1.10           H  
ATOM     53  N   GLN A   4      -0.170  -4.019   4.097  1.00  0.53           N  
ATOM     54  CA  GLN A   4       0.889  -3.045   4.340  1.00  0.53           C  
ATOM     55  C   GLN A   4       1.274  -2.340   3.045  1.00  0.47           C  
ATOM     56  O   GLN A   4       1.599  -2.984   2.047  1.00  0.45           O  
ATOM     57  CB  GLN A   4       2.108  -3.742   4.935  1.00  0.59           C  
ATOM     58  CG  GLN A   4       3.133  -2.731   5.442  1.00  0.63           C  
ATOM     59  CD  GLN A   4       4.184  -3.436   6.288  1.00  0.71           C  
ATOM     60  OE1 GLN A   4       4.250  -3.244   7.502  1.00  1.07           O  
ATOM     61  NE2 GLN A   4       5.007  -4.254   5.644  1.00  1.07           N  
ATOM     62  H   GLN A   4       0.057  -4.971   4.047  1.00  0.55           H  
ATOM     63  HA  GLN A   4       0.530  -2.312   5.044  1.00  0.55           H  
ATOM     64  HB2 GLN A   4       1.790  -4.364   5.759  1.00  0.64           H  
ATOM     65  HB3 GLN A   4       2.567  -4.359   4.178  1.00  0.57           H  
ATOM     66  HG2 GLN A   4       3.612  -2.256   4.598  1.00  0.68           H  
ATOM     67  HG3 GLN A   4       2.633  -1.985   6.042  1.00  0.63           H  
ATOM     68 HE21 GLN A   4       4.893  -4.358   4.676  1.00  1.59           H  
ATOM     69 HE22 GLN A   4       5.693  -4.723   6.164  1.00  1.32           H  
ATOM     70  N   ILE A   5       1.235  -1.012   3.070  1.00  0.45           N  
ATOM     71  CA  ILE A   5       1.581  -0.208   1.901  1.00  0.40           C  
ATOM     72  C   ILE A   5       2.584   0.873   2.289  1.00  0.43           C  
ATOM     73  O   ILE A   5       2.278   1.758   3.088  1.00  0.46           O  
ATOM     74  CB  ILE A   5       0.317   0.427   1.319  1.00  0.37           C  
ATOM     75  CG1 ILE A   5      -0.625  -0.664   0.814  1.00  0.35           C  
ATOM     76  CG2 ILE A   5       0.661   1.404   0.193  1.00  0.36           C  
ATOM     77  CD1 ILE A   5      -1.918  -0.080   0.254  1.00  0.35           C  
ATOM     78  H   ILE A   5       0.969  -0.561   3.898  1.00  0.48           H  
ATOM     79  HA  ILE A   5       2.024  -0.850   1.150  1.00  0.39           H  
ATOM     80  HB  ILE A   5      -0.181   0.977   2.106  1.00  0.39           H  
ATOM     81 HG12 ILE A   5      -0.127  -1.226   0.038  1.00  0.38           H  
ATOM     82 HG13 ILE A   5      -0.866  -1.323   1.634  1.00  0.36           H  
ATOM     83 HG21 ILE A   5       1.458   2.057   0.514  1.00  1.02           H  
ATOM     84 HG22 ILE A   5       0.978   0.850  -0.677  1.00  1.13           H  
ATOM     85 HG23 ILE A   5      -0.210   1.993  -0.050  1.00  1.08           H  
ATOM     86 HD11 ILE A   5      -1.686   0.615  -0.539  1.00  1.12           H  
ATOM     87 HD12 ILE A   5      -2.528  -0.879  -0.135  1.00  1.07           H  
ATOM     88 HD13 ILE A   5      -2.450   0.432   1.040  1.00  1.03           H  
ATOM     89  N   THR A   6       3.777   0.803   1.710  1.00  0.45           N  
ATOM     90  CA  THR A   6       4.821   1.786   1.986  1.00  0.49           C  
ATOM     91  C   THR A   6       4.737   2.912   0.964  1.00  0.47           C  
ATOM     92  O   THR A   6       5.121   2.742  -0.192  1.00  0.48           O  
ATOM     93  CB  THR A   6       6.192   1.119   1.935  1.00  0.56           C  
ATOM     94  OG1 THR A   6       6.216  -0.000   2.808  1.00  0.59           O  
ATOM     95  CG2 THR A   6       7.293   2.103   2.320  1.00  0.62           C  
ATOM     96  H   THR A   6       3.956   0.079   1.071  1.00  0.44           H  
ATOM     97  HA  THR A   6       4.664   2.194   2.973  1.00  0.52           H  
ATOM     98  HB  THR A   6       6.373   0.777   0.929  1.00  0.55           H  
ATOM     99  HG1 THR A   6       6.075  -0.804   2.304  1.00  0.58           H  
ATOM    100 HG21 THR A   6       7.053   2.554   3.271  1.00  1.23           H  
ATOM    101 HG22 THR A   6       8.232   1.577   2.394  1.00  1.16           H  
ATOM    102 HG23 THR A   6       7.367   2.870   1.563  1.00  1.17           H  
ATOM    103  N   PHE A   7       4.213   4.059   1.389  1.00  0.46           N  
ATOM    104  CA  PHE A   7       4.059   5.201   0.499  1.00  0.45           C  
ATOM    105  C   PHE A   7       5.367   5.950   0.343  1.00  0.51           C  
ATOM    106  O   PHE A   7       6.277   5.826   1.164  1.00  0.56           O  
ATOM    107  CB  PHE A   7       2.993   6.144   1.043  1.00  0.44           C  
ATOM    108  CG  PHE A   7       1.598   5.604   0.874  1.00  0.47           C  
ATOM    109  CD1 PHE A   7       1.116   5.324  -0.393  1.00  0.55           C  
ATOM    110  CD2 PHE A   7       0.797   5.382   1.984  1.00  0.58           C  
ATOM    111  CE1 PHE A   7      -0.165   4.826  -0.553  1.00  0.69           C  
ATOM    112  CE2 PHE A   7      -0.484   4.884   1.823  1.00  0.71           C  
ATOM    113  CZ  PHE A   7      -0.964   4.605   0.554  1.00  0.75           C  
ATOM    114  H   PHE A   7       3.914   4.135   2.319  1.00  0.47           H  
ATOM    115  HA  PHE A   7       3.744   4.843  -0.470  1.00  0.43           H  
ATOM    116  HB2 PHE A   7       3.174   6.309   2.091  1.00  0.46           H  
ATOM    117  HB3 PHE A   7       3.061   7.087   0.519  1.00  0.49           H  
ATOM    118  HD1 PHE A   7       1.740   5.496  -1.258  1.00  0.59           H  
ATOM    119  HD2 PHE A   7       1.172   5.601   2.974  1.00  0.65           H  
ATOM    120  HE1 PHE A   7      -0.540   4.609  -1.542  1.00  0.82           H  
ATOM    121  HE2 PHE A   7      -1.109   4.713   2.687  1.00  0.84           H  
ATOM    122  HZ  PHE A   7      -1.960   4.216   0.428  1.00  0.89           H  
ATOM    123  N   THR A   8       5.446   6.740  -0.716  1.00  0.53           N  
ATOM    124  CA  THR A   8       6.631   7.536  -0.995  1.00  0.62           C  
ATOM    125  C   THR A   8       6.231   8.977  -1.261  1.00  0.64           C  
ATOM    126  O   THR A   8       5.049   9.322  -1.205  1.00  0.60           O  
ATOM    127  CB  THR A   8       7.381   6.968  -2.194  1.00  0.64           C  
ATOM    128  OG1 THR A   8       6.585   7.077  -3.363  1.00  0.65           O  
ATOM    129  CG2 THR A   8       7.764   5.511  -1.954  1.00  0.65           C  
ATOM    130  H   THR A   8       4.675   6.797  -1.323  1.00  0.51           H  
ATOM    131  HA  THR A   8       7.281   7.506  -0.133  1.00  0.66           H  
ATOM    132  HB  THR A   8       8.284   7.541  -2.331  1.00  0.72           H  
ATOM    133  HG1 THR A   8       6.934   6.498  -4.044  1.00  1.10           H  
ATOM    134 HG21 THR A   8       6.970   5.017  -1.415  1.00  1.16           H  
ATOM    135 HG22 THR A   8       7.917   5.021  -2.904  1.00  1.19           H  
ATOM    136 HG23 THR A   8       8.675   5.472  -1.376  1.00  1.29           H  
ATOM    137  N   ASP A   9       7.216   9.819  -1.545  1.00  0.72           N  
ATOM    138  CA  ASP A   9       6.956  11.227  -1.811  1.00  0.76           C  
ATOM    139  C   ASP A   9       6.890  11.485  -3.319  1.00  0.79           C  
ATOM    140  O   ASP A   9       7.102  12.609  -3.777  1.00  0.93           O  
ATOM    141  CB  ASP A   9       8.034  12.084  -1.127  1.00  0.85           C  
ATOM    142  CG  ASP A   9       9.257  12.285  -2.019  1.00  1.41           C  
ATOM    143  OD1 ASP A   9      10.125  11.388  -2.049  1.00  2.38           O  
ATOM    144  OD2 ASP A   9       9.345  13.340  -2.682  1.00  1.50           O  
ATOM    145  H   ASP A   9       8.137   9.486  -1.573  1.00  0.77           H  
ATOM    146  HA  ASP A   9       5.997  11.478  -1.384  1.00  0.72           H  
ATOM    147  HB2 ASP A   9       7.612  13.043  -0.877  1.00  1.37           H  
ATOM    148  HB3 ASP A   9       8.345  11.590  -0.220  1.00  1.25           H  
ATOM    149  N   SER A  10       6.583  10.438  -4.081  1.00  0.74           N  
ATOM    150  CA  SER A  10       6.475  10.542  -5.530  1.00  0.77           C  
ATOM    151  C   SER A  10       5.014  10.626  -5.932  1.00  0.72           C  
ATOM    152  O   SER A  10       4.313   9.614  -5.966  1.00  0.68           O  
ATOM    153  CB  SER A  10       7.119   9.333  -6.197  1.00  0.79           C  
ATOM    154  OG  SER A  10       8.272   9.718  -6.930  1.00  0.85           O  
ATOM    155  H   SER A  10       6.416   9.575  -3.655  1.00  0.73           H  
ATOM    156  HA  SER A  10       6.985  11.429  -5.856  1.00  0.84           H  
ATOM    157  HB2 SER A  10       7.398   8.622  -5.443  1.00  0.79           H  
ATOM    158  HB3 SER A  10       6.406   8.880  -6.864  1.00  0.77           H  
ATOM    159  HG  SER A  10       9.047   9.291  -6.557  1.00  1.18           H  
ATOM    160  N   VAL A  11       4.544  11.830  -6.231  1.00  0.76           N  
ATOM    161  CA  VAL A  11       3.153  12.004  -6.620  1.00  0.74           C  
ATOM    162  C   VAL A  11       3.051  12.605  -8.015  1.00  0.84           C  
ATOM    163  O   VAL A  11       3.525  13.712  -8.267  1.00  0.93           O  
ATOM    164  CB  VAL A  11       2.402  12.882  -5.616  1.00  0.73           C  
ATOM    165  CG1 VAL A  11       0.907  12.601  -5.704  1.00  0.71           C  
ATOM    166  CG2 VAL A  11       2.893  12.656  -4.183  1.00  0.70           C  
ATOM    167  H   VAL A  11       5.137  12.609  -6.186  1.00  0.82           H  
ATOM    168  HA  VAL A  11       2.687  11.031  -6.636  1.00  0.70           H  
ATOM    169  HB  VAL A  11       2.571  13.916  -5.875  1.00  0.80           H  
ATOM    170 HG11 VAL A  11       0.603  12.606  -6.740  1.00  1.18           H  
ATOM    171 HG12 VAL A  11       0.701  11.632  -5.271  1.00  1.22           H  
ATOM    172 HG13 VAL A  11       0.365  13.363  -5.164  1.00  1.25           H  
ATOM    173 HG21 VAL A  11       3.645  11.883  -4.173  1.00  1.20           H  
ATOM    174 HG22 VAL A  11       3.314  13.574  -3.802  1.00  1.16           H  
ATOM    175 HG23 VAL A  11       2.058  12.357  -3.564  1.00  1.27           H  
ATOM    176  N   ARG A  12       2.415  11.862  -8.913  1.00  0.85           N  
ATOM    177  CA  ARG A  12       2.222  12.295 -10.289  1.00  0.95           C  
ATOM    178  C   ARG A  12       0.925  13.083 -10.416  1.00  0.98           C  
ATOM    179  O   ARG A  12      -0.164  12.538 -10.240  1.00  0.95           O  
ATOM    180  CB  ARG A  12       2.171  11.081 -11.208  1.00  0.97           C  
ATOM    181  CG  ARG A  12       2.425  11.486 -12.658  1.00  1.15           C  
ATOM    182  CD  ARG A  12       3.724  10.891 -13.214  1.00  1.74           C  
ATOM    183  NE  ARG A  12       4.725  10.736 -12.160  1.00  2.31           N  
ATOM    184  CZ  ARG A  12       5.596   9.734 -12.171  1.00  2.92           C  
ATOM    185  NH1 ARG A  12       5.244   8.540 -11.714  1.00  3.50           N  
ATOM    186  NH2 ARG A  12       6.820   9.923 -12.645  1.00  3.36           N  
ATOM    187  H   ARG A  12       2.057  10.992  -8.635  1.00  0.81           H  
ATOM    188  HA  ARG A  12       3.049  12.922 -10.582  1.00  1.02           H  
ATOM    189  HB2 ARG A  12       2.915  10.368 -10.895  1.00  1.00           H  
ATOM    190  HB3 ARG A  12       1.193  10.629 -11.139  1.00  1.06           H  
ATOM    191  HG2 ARG A  12       1.598  11.143 -13.260  1.00  1.64           H  
ATOM    192  HG3 ARG A  12       2.479  12.564 -12.714  1.00  1.39           H  
ATOM    193  HD2 ARG A  12       3.516   9.925 -13.648  1.00  2.10           H  
ATOM    194  HD3 ARG A  12       4.113  11.549 -13.980  1.00  2.29           H  
ATOM    195  HE  ARG A  12       4.752  11.385 -11.425  1.00  2.69           H  
ATOM    196 HH11 ARG A  12       4.321   8.393 -11.360  1.00  3.53           H  
ATOM    197 HH12 ARG A  12       5.904   7.787 -11.721  1.00  4.15           H  
ATOM    198 HH21 ARG A  12       7.087  10.822 -12.994  1.00  3.30           H  
ATOM    199 HH22 ARG A  12       7.476   9.170 -12.651  1.00  4.00           H  
ATOM    200  N   GLN A  13       1.051  14.367 -10.723  1.00  1.07           N  
ATOM    201  CA  GLN A  13      -0.109  15.241 -10.876  1.00  1.13           C  
ATOM    202  C   GLN A  13      -0.237  15.684 -12.327  1.00  1.27           C  
ATOM    203  O   GLN A  13       0.768  15.875 -13.011  1.00  1.38           O  
ATOM    204  CB  GLN A  13       0.051  16.460  -9.978  1.00  1.16           C  
ATOM    205  CG  GLN A  13       0.399  16.040  -8.555  1.00  1.05           C  
ATOM    206  CD  GLN A  13       1.126  17.161  -7.828  1.00  1.42           C  
ATOM    207  OE1 GLN A  13       1.963  17.851  -8.405  1.00  2.14           O  
ATOM    208  NE2 GLN A  13       0.799  17.345  -6.555  1.00  1.89           N  
ATOM    209  H   GLN A  13       1.949  14.738 -10.850  1.00  1.12           H  
ATOM    210  HA  GLN A  13      -1.001  14.701 -10.579  1.00  1.07           H  
ATOM    211  HB2 GLN A  13       0.842  17.087 -10.368  1.00  1.20           H  
ATOM    212  HB3 GLN A  13      -0.874  17.016  -9.968  1.00  1.25           H  
ATOM    213  HG2 GLN A  13      -0.508  15.807  -8.028  1.00  0.97           H  
ATOM    214  HG3 GLN A  13       1.028  15.165  -8.585  1.00  1.54           H  
ATOM    215 HE21 GLN A  13       0.119  16.759  -6.162  1.00  2.36           H  
ATOM    216 HE22 GLN A  13       1.250  18.062  -6.061  1.00  2.29           H  
ATOM    217  N   GLY A  14      -1.467  15.854 -12.801  1.00  1.29           N  
ATOM    218  CA  GLY A  14      -1.683  16.280 -14.182  1.00  1.43           C  
ATOM    219  C   GLY A  14      -3.155  16.225 -14.568  1.00  1.45           C  
ATOM    220  O   GLY A  14      -4.012  15.882 -13.753  1.00  1.37           O  
ATOM    221  H   GLY A  14      -2.238  15.691 -12.215  1.00  1.23           H  
ATOM    222  HA2 GLY A  14      -1.327  17.294 -14.295  1.00  1.52           H  
ATOM    223  HA3 GLY A  14      -1.121  15.631 -14.840  1.00  1.48           H  
ATOM    224  N   THR A  15      -3.430  16.567 -15.823  1.00  1.60           N  
ATOM    225  CA  THR A  15      -4.789  16.567 -16.355  1.00  1.69           C  
ATOM    226  C   THR A  15      -4.979  15.394 -17.309  1.00  1.77           C  
ATOM    227  O   THR A  15      -4.054  15.004 -18.024  1.00  1.85           O  
ATOM    228  CB  THR A  15      -5.064  17.885 -17.094  1.00  1.84           C  
ATOM    229  OG1 THR A  15      -3.870  18.648 -17.184  1.00  1.94           O  
ATOM    230  CG2 THR A  15      -6.154  18.707 -16.398  1.00  1.98           C  
ATOM    231  H   THR A  15      -2.692  16.827 -16.412  1.00  1.69           H  
ATOM    232  HA  THR A  15      -5.485  16.467 -15.536  1.00  1.62           H  
ATOM    233  HB  THR A  15      -5.399  17.652 -18.095  1.00  1.94           H  
ATOM    234  HG1 THR A  15      -3.283  18.250 -17.830  1.00  2.03           H  
ATOM    235 HG21 THR A  15      -5.882  18.865 -15.366  1.00  2.30           H  
ATOM    236 HG22 THR A  15      -6.249  19.664 -16.894  1.00  2.19           H  
ATOM    237 HG23 THR A  15      -7.095  18.179 -16.451  1.00  2.33           H  
ATOM    238  N   SER A  16      -6.182  14.835 -17.317  1.00  1.79           N  
ATOM    239  CA  SER A  16      -6.499  13.708 -18.184  1.00  1.92           C  
ATOM    240  C   SER A  16      -6.959  14.206 -19.544  1.00  2.13           C  
ATOM    241  O   SER A  16      -7.159  15.403 -19.742  1.00  2.18           O  
ATOM    242  CB  SER A  16      -7.593  12.858 -17.547  1.00  1.90           C  
ATOM    243  OG  SER A  16      -8.374  13.640 -16.657  1.00  2.06           O  
ATOM    244  H   SER A  16      -6.877  15.195 -16.727  1.00  1.75           H  
ATOM    245  HA  SER A  16      -5.616  13.101 -18.311  1.00  1.92           H  
ATOM    246  HB2 SER A  16      -8.228  12.460 -18.323  1.00  2.05           H  
ATOM    247  HB3 SER A  16      -7.138  12.045 -17.003  1.00  2.07           H  
ATOM    248  HG  SER A  16      -8.504  13.158 -15.836  1.00  2.02           H  
ATOM    249  N   ALA A  17      -7.122  13.280 -20.482  1.00  2.27           N  
ATOM    250  CA  ALA A  17      -7.564  13.632 -21.831  1.00  2.48           C  
ATOM    251  C   ALA A  17      -8.911  14.350 -21.779  1.00  2.56           C  
ATOM    252  O   ALA A  17      -9.250  15.113 -22.683  1.00  2.71           O  
ATOM    253  CB  ALA A  17      -7.680  12.382 -22.706  1.00  2.64           C  
ATOM    254  H   ALA A  17      -6.939  12.341 -20.259  1.00  2.24           H  
ATOM    255  HA  ALA A  17      -6.834  14.296 -22.269  1.00  2.51           H  
ATOM    256  HB1 ALA A  17      -7.187  11.553 -22.224  1.00  2.89           H  
ATOM    257  HB2 ALA A  17      -8.723  12.147 -22.856  1.00  2.82           H  
ATOM    258  HB3 ALA A  17      -7.213  12.574 -23.661  1.00  2.86           H  
ATOM    259  N   LYS A  18      -9.678  14.102 -20.718  1.00  2.49           N  
ATOM    260  CA  LYS A  18     -10.990  14.726 -20.552  1.00  2.60           C  
ATOM    261  C   LYS A  18     -10.870  16.083 -19.857  1.00  2.51           C  
ATOM    262  O   LYS A  18     -11.879  16.694 -19.503  1.00  2.60           O  
ATOM    263  CB  LYS A  18     -11.899  13.810 -19.739  1.00  2.63           C  
ATOM    264  CG  LYS A  18     -12.010  12.433 -20.384  1.00  2.80           C  
ATOM    265  CD  LYS A  18     -12.669  12.522 -21.758  1.00  3.32           C  
ATOM    266  CE  LYS A  18     -13.756  11.463 -21.917  1.00  3.75           C  
ATOM    267  NZ  LYS A  18     -14.978  11.828 -21.148  1.00  4.16           N  
ATOM    268  H   LYS A  18      -9.357  13.485 -20.030  1.00  2.39           H  
ATOM    269  HA  LYS A  18     -11.430  14.872 -21.527  1.00  2.77           H  
ATOM    270  HB2 LYS A  18     -11.492  13.702 -18.744  1.00  2.76           H  
ATOM    271  HB3 LYS A  18     -12.882  14.252 -19.677  1.00  2.47           H  
ATOM    272  HG2 LYS A  18     -11.021  12.013 -20.494  1.00  2.84           H  
ATOM    273  HG3 LYS A  18     -12.602  11.791 -19.748  1.00  2.71           H  
ATOM    274  HD2 LYS A  18     -13.112  13.500 -21.874  1.00  3.50           H  
ATOM    275  HD3 LYS A  18     -11.919  12.375 -22.520  1.00  3.70           H  
ATOM    276  HE2 LYS A  18     -14.010  11.373 -22.962  1.00  3.91           H  
ATOM    277  HE3 LYS A  18     -13.380  10.516 -21.558  1.00  4.19           H  
ATOM    278  HZ1 LYS A  18     -14.719  12.046 -20.166  1.00  4.51           H  
ATOM    279  HZ2 LYS A  18     -15.422  12.664 -21.579  1.00  4.47           H  
ATOM    280  HZ3 LYS A  18     -15.647  11.030 -21.164  1.00  4.31           H  
ATOM    281  N   GLY A  19      -9.640  16.554 -19.667  1.00  2.38           N  
ATOM    282  CA  GLY A  19      -9.405  17.841 -19.019  1.00  2.34           C  
ATOM    283  C   GLY A  19      -9.586  17.754 -17.504  1.00  2.17           C  
ATOM    284  O   GLY A  19      -9.476  18.762 -16.806  1.00  2.15           O  
ATOM    285  H   GLY A  19      -8.873  16.032 -19.971  1.00  2.34           H  
ATOM    286  HA2 GLY A  19      -8.397  18.163 -19.235  1.00  2.50           H  
ATOM    287  HA3 GLY A  19     -10.102  18.564 -19.416  1.00  2.30           H  
ATOM    288  N   ASN A  20      -9.867  16.557 -16.991  1.00  2.10           N  
ATOM    289  CA  ASN A  20     -10.060  16.376 -15.554  1.00  1.96           C  
ATOM    290  C   ASN A  20      -8.719  16.231 -14.842  1.00  1.75           C  
ATOM    291  O   ASN A  20      -7.782  15.636 -15.374  1.00  1.71           O  
ATOM    292  CB  ASN A  20     -10.922  15.146 -15.288  1.00  1.98           C  
ATOM    293  CG  ASN A  20     -12.352  15.397 -15.748  1.00  2.22           C  
ATOM    294  OD1 ASN A  20     -12.612  15.547 -16.942  1.00  2.57           O  
ATOM    295  ND2 ASN A  20     -13.281  15.443 -14.800  1.00  2.43           N  
ATOM    296  H   ASN A  20      -9.947  15.783 -17.584  1.00  2.18           H  
ATOM    297  HA  ASN A  20     -10.568  17.245 -15.162  1.00  2.02           H  
ATOM    298  HB2 ASN A  20     -10.517  14.303 -15.824  1.00  1.87           H  
ATOM    299  HB3 ASN A  20     -10.923  14.934 -14.229  1.00  1.99           H  
ATOM    300 HD21 ASN A  20     -12.999  15.315 -13.871  1.00  2.66           H  
ATOM    301 HD22 ASN A  20     -14.209  15.604 -15.069  1.00  2.58           H  
ATOM    302  N   PRO A  21      -8.617  16.779 -13.618  1.00  1.67           N  
ATOM    303  CA  PRO A  21      -7.392  16.720 -12.814  1.00  1.51           C  
ATOM    304  C   PRO A  21      -7.274  15.410 -12.044  1.00  1.36           C  
ATOM    305  O   PRO A  21      -8.264  14.893 -11.524  1.00  1.41           O  
ATOM    306  CB  PRO A  21      -7.534  17.892 -11.855  1.00  1.57           C  
ATOM    307  CG  PRO A  21      -9.006  18.146 -11.733  1.00  1.70           C  
ATOM    308  CD  PRO A  21      -9.688  17.505 -12.921  1.00  1.78           C  
ATOM    309  HA  PRO A  21      -6.515  16.864 -13.420  1.00  1.52           H  
ATOM    310  HB2 PRO A  21      -7.108  17.632 -10.898  1.00  1.64           H  
ATOM    311  HB3 PRO A  21      -7.026  18.755 -12.261  1.00  1.48           H  
ATOM    312  HG2 PRO A  21      -9.375  17.709 -10.817  1.00  1.67           H  
ATOM    313  HG3 PRO A  21      -9.192  19.209 -11.736  1.00  1.82           H  
ATOM    314  HD2 PRO A  21     -10.456  16.820 -12.591  1.00  1.91           H  
ATOM    315  HD3 PRO A  21     -10.112  18.262 -13.563  1.00  1.81           H  
ATOM    316  N   TYR A  22      -6.060  14.876 -11.973  1.00  1.24           N  
ATOM    317  CA  TYR A  22      -5.818  13.627 -11.262  1.00  1.11           C  
ATOM    318  C   TYR A  22      -4.557  13.723 -10.416  1.00  1.00           C  
ATOM    319  O   TYR A  22      -3.604  14.419 -10.773  1.00  1.05           O  
ATOM    320  CB  TYR A  22      -5.688  12.472 -12.251  1.00  1.16           C  
ATOM    321  CG  TYR A  22      -4.479  12.592 -13.143  1.00  1.21           C  
ATOM    322  CD1 TYR A  22      -3.227  12.241 -12.668  1.00  1.14           C  
ATOM    323  CD2 TYR A  22      -4.620  13.055 -14.439  1.00  1.37           C  
ATOM    324  CE1 TYR A  22      -2.118  12.351 -13.490  1.00  1.24           C  
ATOM    325  CE2 TYR A  22      -3.510  13.166 -15.260  1.00  1.45           C  
ATOM    326  CZ  TYR A  22      -2.264  12.814 -14.781  1.00  1.39           C  
ATOM    327  OH  TYR A  22      -1.161  12.923 -15.597  1.00  1.52           O  
ATOM    328  H   TYR A  22      -5.310  15.335 -12.407  1.00  1.27           H  
ATOM    329  HA  TYR A  22      -6.658  13.432 -10.612  1.00  1.10           H  
ATOM    330  HB2 TYR A  22      -5.616  11.547 -11.699  1.00  1.26           H  
ATOM    331  HB3 TYR A  22      -6.572  12.444 -12.872  1.00  1.10           H  
ATOM    332  HD1 TYR A  22      -3.115  11.879 -11.657  1.00  1.04           H  
ATOM    333  HD2 TYR A  22      -5.595  13.330 -14.810  1.00  1.45           H  
ATOM    334  HE1 TYR A  22      -1.142  12.077 -13.119  1.00  1.22           H  
ATOM    335  HE2 TYR A  22      -3.621  13.528 -16.272  1.00  1.59           H  
ATOM    336  HH  TYR A  22      -1.361  13.504 -16.334  1.00  1.72           H  
ATOM    337  N   THR A  23      -4.565  13.015  -9.294  1.00  0.90           N  
ATOM    338  CA  THR A  23      -3.432  13.001  -8.379  1.00  0.82           C  
ATOM    339  C   THR A  23      -3.025  11.571  -8.076  1.00  0.74           C  
ATOM    340  O   THR A  23      -3.625  10.908  -7.229  1.00  0.70           O  
ATOM    341  CB  THR A  23      -3.808  13.685  -7.081  1.00  0.82           C  
ATOM    342  OG1 THR A  23      -4.383  14.957  -7.341  1.00  0.96           O  
ATOM    343  CG2 THR A  23      -2.594  13.824  -6.173  1.00  0.80           C  
ATOM    344  H   THR A  23      -5.358  12.483  -9.075  1.00  0.90           H  
ATOM    345  HA  THR A  23      -2.598  13.527  -8.830  1.00  0.85           H  
ATOM    346  HB  THR A  23      -4.531  13.064  -6.585  1.00  0.78           H  
ATOM    347  HG1 THR A  23      -5.233  14.841  -7.770  1.00  1.16           H  
ATOM    348 HG21 THR A  23      -2.022  12.907  -6.197  1.00  1.20           H  
ATOM    349 HG22 THR A  23      -1.983  14.638  -6.521  1.00  1.34           H  
ATOM    350 HG23 THR A  23      -2.922  14.022  -5.164  1.00  1.33           H  
ATOM    351  N   PHE A  24      -2.001  11.105  -8.759  1.00  0.75           N  
ATOM    352  CA  PHE A  24      -1.501   9.752  -8.557  1.00  0.70           C  
ATOM    353  C   PHE A  24      -0.288   9.782  -7.644  1.00  0.65           C  
ATOM    354  O   PHE A  24       0.665  10.505  -7.896  1.00  0.71           O  
ATOM    355  CB  PHE A  24      -1.129   9.111  -9.894  1.00  0.76           C  
ATOM    356  CG  PHE A  24      -2.327   8.558 -10.627  1.00  0.83           C  
ATOM    357  CD1 PHE A  24      -3.055   7.513 -10.079  1.00  0.84           C  
ATOM    358  CD2 PHE A  24      -2.703   9.093 -11.850  1.00  1.13           C  
ATOM    359  CE1 PHE A  24      -4.154   7.005 -10.750  1.00  0.93           C  
ATOM    360  CE2 PHE A  24      -3.803   8.584 -12.521  1.00  1.26           C  
ATOM    361  CZ  PHE A  24      -4.529   7.541 -11.971  1.00  1.08           C  
ATOM    362  H   PHE A  24      -1.568  11.690  -9.407  1.00  0.82           H  
ATOM    363  HA  PHE A  24      -2.274   9.163  -8.089  1.00  0.68           H  
ATOM    364  HB2 PHE A  24      -0.651   9.853 -10.522  1.00  0.82           H  
ATOM    365  HB3 PHE A  24      -0.431   8.304  -9.709  1.00  0.75           H  
ATOM    366  HD1 PHE A  24      -2.765   7.093  -9.128  1.00  0.98           H  
ATOM    367  HD2 PHE A  24      -2.138   9.907 -12.280  1.00  1.36           H  
ATOM    368  HE1 PHE A  24      -4.720   6.192 -10.321  1.00  1.06           H  
ATOM    369  HE2 PHE A  24      -4.095   9.001 -13.474  1.00  1.59           H  
ATOM    370  HZ  PHE A  24      -5.386   7.144 -12.494  1.00  1.20           H  
ATOM    371  N   GLN A  25      -0.325   8.996  -6.581  1.00  0.59           N  
ATOM    372  CA  GLN A  25       0.788   8.949  -5.640  1.00  0.55           C  
ATOM    373  C   GLN A  25       1.446   7.579  -5.670  1.00  0.53           C  
ATOM    374  O   GLN A  25       0.773   6.562  -5.832  1.00  0.52           O  
ATOM    375  CB  GLN A  25       0.305   9.265  -4.230  1.00  0.51           C  
ATOM    376  CG  GLN A  25       1.464   9.228  -3.244  1.00  0.52           C  
ATOM    377  CD  GLN A  25       1.067   9.877  -1.924  1.00  0.55           C  
ATOM    378  OE1 GLN A  25      -0.044  10.390  -1.782  1.00  0.59           O  
ATOM    379  NE2 GLN A  25       1.976   9.852  -0.956  1.00  0.70           N  
ATOM    380  H   GLN A  25      -1.113   8.436  -6.425  1.00  0.59           H  
ATOM    381  HA  GLN A  25       1.517   9.689  -5.928  1.00  0.60           H  
ATOM    382  HB2 GLN A  25      -0.138  10.250  -4.218  1.00  0.53           H  
ATOM    383  HB3 GLN A  25      -0.435   8.535  -3.936  1.00  0.48           H  
ATOM    384  HG2 GLN A  25       1.743   8.208  -3.068  1.00  0.65           H  
ATOM    385  HG3 GLN A  25       2.303   9.753  -3.663  1.00  0.72           H  
ATOM    386 HE21 GLN A  25       2.839   9.425  -1.140  1.00  0.67           H  
ATOM    387 HE22 GLN A  25       1.746  10.263  -0.096  1.00  0.89           H  
ATOM    388  N   GLU A  26       2.768   7.555  -5.517  1.00  0.53           N  
ATOM    389  CA  GLU A  26       3.505   6.297  -5.532  1.00  0.53           C  
ATOM    390  C   GLU A  26       3.439   5.623  -4.176  1.00  0.48           C  
ATOM    391  O   GLU A  26       3.257   6.273  -3.143  1.00  0.50           O  
ATOM    392  CB  GLU A  26       4.965   6.517  -5.912  1.00  0.59           C  
ATOM    393  CG  GLU A  26       5.740   5.199  -5.911  1.00  0.68           C  
ATOM    394  CD  GLU A  26       7.064   5.360  -6.647  1.00  0.97           C  
ATOM    395  OE1 GLU A  26       7.050   5.393  -7.896  1.00  1.21           O  
ATOM    396  OE2 GLU A  26       8.111   5.454  -5.975  1.00  1.26           O  
ATOM    397  H   GLU A  26       3.253   8.397  -5.393  1.00  0.55           H  
ATOM    398  HA  GLU A  26       3.053   5.646  -6.264  1.00  0.53           H  
ATOM    399  HB2 GLU A  26       5.011   6.946  -6.894  1.00  0.94           H  
ATOM    400  HB3 GLU A  26       5.416   7.194  -5.204  1.00  1.16           H  
ATOM    401  HG2 GLU A  26       5.935   4.903  -4.891  1.00  1.05           H  
ATOM    402  HG3 GLU A  26       5.150   4.439  -6.401  1.00  0.73           H  
ATOM    403  N   GLY A  27       3.603   4.313  -4.195  1.00  0.45           N  
ATOM    404  CA  GLY A  27       3.575   3.519  -2.970  1.00  0.43           C  
ATOM    405  C   GLY A  27       3.942   2.068  -3.251  1.00  0.45           C  
ATOM    406  O   GLY A  27       3.617   1.529  -4.307  1.00  0.51           O  
ATOM    407  H   GLY A  27       3.754   3.872  -5.062  1.00  0.47           H  
ATOM    408  HA2 GLY A  27       4.280   3.934  -2.265  1.00  0.47           H  
ATOM    409  HA3 GLY A  27       2.581   3.558  -2.547  1.00  0.39           H  
ATOM    410  N   PHE A  28       4.619   1.441  -2.292  1.00  0.46           N  
ATOM    411  CA  PHE A  28       5.031   0.049  -2.428  1.00  0.48           C  
ATOM    412  C   PHE A  28       4.027  -0.867  -1.737  1.00  0.44           C  
ATOM    413  O   PHE A  28       3.537  -0.564  -0.646  1.00  0.43           O  
ATOM    414  CB  PHE A  28       6.423  -0.144  -1.835  1.00  0.55           C  
ATOM    415  CG  PHE A  28       7.524   0.199  -2.809  1.00  0.65           C  
ATOM    416  CD1 PHE A  28       7.912  -0.718  -3.772  1.00  1.10           C  
ATOM    417  CD2 PHE A  28       8.152   1.431  -2.737  1.00  0.90           C  
ATOM    418  CE1 PHE A  28       8.925  -0.405  -4.662  1.00  1.21           C  
ATOM    419  CE2 PHE A  28       9.166   1.746  -3.627  1.00  0.96           C  
ATOM    420  CZ  PHE A  28       9.552   0.828  -4.590  1.00  0.89           C  
ATOM    421  H   PHE A  28       4.844   1.928  -1.473  1.00  0.49           H  
ATOM    422  HA  PHE A  28       5.063  -0.201  -3.478  1.00  0.50           H  
ATOM    423  HB2 PHE A  28       6.523   0.491  -0.968  1.00  0.56           H  
ATOM    424  HB3 PHE A  28       6.535  -1.175  -1.536  1.00  0.54           H  
ATOM    425  HD1 PHE A  28       7.422  -1.678  -3.833  1.00  1.54           H  
ATOM    426  HD2 PHE A  28       7.852   2.148  -1.987  1.00  1.33           H  
ATOM    427  HE1 PHE A  28       9.226  -1.123  -5.411  1.00  1.71           H  
ATOM    428  HE2 PHE A  28       9.654   2.707  -3.572  1.00  1.37           H  
ATOM    429  HZ  PHE A  28      10.342   1.072  -5.284  1.00  1.00           H  
ATOM    430  N   LEU A  29       3.709  -1.976  -2.396  1.00  0.45           N  
ATOM    431  CA  LEU A  29       2.743  -2.945  -1.882  1.00  0.44           C  
ATOM    432  C   LEU A  29       3.447  -4.181  -1.332  1.00  0.46           C  
ATOM    433  O   LEU A  29       4.453  -4.634  -1.881  1.00  0.49           O  
ATOM    434  CB  LEU A  29       1.816  -3.341  -3.024  1.00  0.51           C  
ATOM    435  CG  LEU A  29       0.344  -3.287  -2.636  1.00  0.52           C  
ATOM    436  CD1 LEU A  29      -0.253  -1.943  -3.026  1.00  0.65           C  
ATOM    437  CD2 LEU A  29      -0.424  -4.402  -3.331  1.00  0.91           C  
ATOM    438  H   LEU A  29       4.129  -2.142  -3.267  1.00  0.49           H  
ATOM    439  HA  LEU A  29       2.163  -2.486  -1.100  1.00  0.41           H  
ATOM    440  HB2 LEU A  29       1.973  -2.657  -3.832  1.00  0.82           H  
ATOM    441  HB3 LEU A  29       2.061  -4.341  -3.348  1.00  0.81           H  
ATOM    442  HG  LEU A  29       0.257  -3.414  -1.568  1.00  0.98           H  
ATOM    443 HD11 LEU A  29       0.310  -1.529  -3.851  1.00  1.29           H  
ATOM    444 HD12 LEU A  29      -1.283  -2.084  -3.329  1.00  1.35           H  
ATOM    445 HD13 LEU A  29      -0.208  -1.272  -2.180  1.00  1.24           H  
ATOM    446 HD21 LEU A  29       0.132  -5.323  -3.254  1.00  1.38           H  
ATOM    447 HD22 LEU A  29      -1.390  -4.518  -2.859  1.00  1.44           H  
ATOM    448 HD23 LEU A  29      -0.556  -4.142  -4.373  1.00  1.50           H  
ATOM    449  N   HIS A  30       2.909  -4.724  -0.244  1.00  0.48           N  
ATOM    450  CA  HIS A  30       3.474  -5.907   0.387  1.00  0.53           C  
ATOM    451  C   HIS A  30       2.476  -7.057   0.339  1.00  0.60           C  
ATOM    452  O   HIS A  30       1.383  -6.965   0.900  1.00  0.66           O  
ATOM    453  CB  HIS A  30       3.831  -5.586   1.830  1.00  0.59           C  
ATOM    454  CG  HIS A  30       4.974  -4.628   1.946  1.00  0.59           C  
ATOM    455  ND1 HIS A  30       6.261  -5.018   2.211  1.00  0.70           N  
ATOM    456  CD2 HIS A  30       5.035  -3.276   1.836  1.00  0.56           C  
ATOM    457  CE1 HIS A  30       7.066  -3.983   2.264  1.00  0.73           C  
ATOM    458  NE2 HIS A  30       6.349  -2.894   2.038  1.00  0.64           N  
ATOM    459  H   HIS A  30       2.111  -4.317   0.147  1.00  0.48           H  
ATOM    460  HA  HIS A  30       4.370  -6.192  -0.138  1.00  0.53           H  
ATOM    461  HB2 HIS A  30       2.970  -5.154   2.308  1.00  0.59           H  
ATOM    462  HB3 HIS A  30       4.091  -6.501   2.332  1.00  0.65           H  
ATOM    463  HD1 HIS A  30       6.543  -5.948   2.340  1.00  0.77           H  
ATOM    464  HD2 HIS A  30       4.205  -2.617   1.627  1.00  0.52           H  
ATOM    465  HE1 HIS A  30       8.127  -4.014   2.459  1.00  0.83           H  
ATOM    466  N   LEU A  31       2.850  -8.136  -0.341  1.00  0.67           N  
ATOM    467  CA  LEU A  31       1.977  -9.297  -0.467  1.00  0.81           C  
ATOM    468  C   LEU A  31       2.562 -10.500   0.264  1.00  0.93           C  
ATOM    469  O   LEU A  31       3.766 -10.748   0.215  1.00  0.92           O  
ATOM    470  CB  LEU A  31       1.759  -9.617  -1.939  1.00  0.84           C  
ATOM    471  CG  LEU A  31       0.369  -9.182  -2.390  1.00  1.06           C  
ATOM    472  CD1 LEU A  31       0.272  -7.662  -2.429  1.00  0.89           C  
ATOM    473  CD2 LEU A  31       0.037  -9.778  -3.752  1.00  1.63           C  
ATOM    474  H   LEU A  31       3.730  -8.149  -0.771  1.00  0.70           H  
ATOM    475  HA  LEU A  31       1.022  -9.059  -0.026  1.00  0.88           H  
ATOM    476  HB2 LEU A  31       2.500  -9.095  -2.527  1.00  1.00           H  
ATOM    477  HB3 LEU A  31       1.863 -10.677  -2.089  1.00  0.75           H  
ATOM    478  HG  LEU A  31      -0.351  -9.551  -1.673  1.00  1.74           H  
ATOM    479 HD11 LEU A  31       1.196  -7.236  -2.066  1.00  1.47           H  
ATOM    480 HD12 LEU A  31       0.099  -7.340  -3.445  1.00  1.44           H  
ATOM    481 HD13 LEU A  31      -0.546  -7.341  -1.802  1.00  1.44           H  
ATOM    482 HD21 LEU A  31       0.409 -10.788  -3.800  1.00  2.16           H  
ATOM    483 HD22 LEU A  31      -1.035  -9.780  -3.890  1.00  2.06           H  
ATOM    484 HD23 LEU A  31       0.501  -9.184  -4.525  1.00  1.93           H  
ATOM    485  N   GLU A  32       1.692 -11.240   0.948  1.00  1.15           N  
ATOM    486  CA  GLU A  32       2.104 -12.423   1.708  1.00  1.35           C  
ATOM    487  C   GLU A  32       2.704 -13.485   0.795  1.00  1.32           C  
ATOM    488  O   GLU A  32       3.478 -14.333   1.236  1.00  1.43           O  
ATOM    489  CB  GLU A  32       0.913 -13.024   2.467  1.00  1.65           C  
ATOM    490  CG  GLU A  32       0.351 -12.096   3.556  1.00  2.04           C  
ATOM    491  CD  GLU A  32      -1.129 -11.835   3.300  1.00  2.49           C  
ATOM    492  OE1 GLU A  32      -1.959 -12.680   3.698  1.00  2.74           O  
ATOM    493  OE2 GLU A  32      -1.457 -10.790   2.699  1.00  3.19           O  
ATOM    494  H   GLU A  32       0.746 -10.981   0.938  1.00  1.22           H  
ATOM    495  HA  GLU A  32       2.858 -12.131   2.407  1.00  1.41           H  
ATOM    496  HB2 GLU A  32       0.128 -13.241   1.761  1.00  1.73           H  
ATOM    497  HB3 GLU A  32       1.231 -13.947   2.929  1.00  2.08           H  
ATOM    498  HG2 GLU A  32       0.460 -12.573   4.520  1.00  2.46           H  
ATOM    499  HG3 GLU A  32       0.881 -11.155   3.563  1.00  2.40           H  
ATOM    500  N   ASP A  33       2.325 -13.442  -0.468  1.00  1.26           N  
ATOM    501  CA  ASP A  33       2.803 -14.414  -1.451  1.00  1.29           C  
ATOM    502  C   ASP A  33       3.966 -13.858  -2.274  1.00  1.13           C  
ATOM    503  O   ASP A  33       4.360 -14.456  -3.275  1.00  1.16           O  
ATOM    504  CB  ASP A  33       1.658 -14.823  -2.376  1.00  1.46           C  
ATOM    505  CG  ASP A  33       1.233 -13.648  -3.247  1.00  1.42           C  
ATOM    506  OD1 ASP A  33       0.940 -12.572  -2.689  1.00  1.38           O  
ATOM    507  OD2 ASP A  33       1.194 -13.809  -4.486  1.00  1.59           O  
ATOM    508  H   ASP A  33       1.697 -12.750  -0.739  1.00  1.24           H  
ATOM    509  HA  ASP A  33       3.146 -15.291  -0.923  1.00  1.38           H  
ATOM    510  HB2 ASP A  33       1.983 -15.636  -3.008  1.00  1.56           H  
ATOM    511  HB3 ASP A  33       0.817 -15.145  -1.779  1.00  1.60           H  
ATOM    512  N   LYS A  34       4.518 -12.723  -1.854  1.00  1.03           N  
ATOM    513  CA  LYS A  34       5.636 -12.114  -2.562  1.00  0.94           C  
ATOM    514  C   LYS A  34       6.743 -11.750  -1.576  1.00  0.92           C  
ATOM    515  O   LYS A  34       6.479 -11.142  -0.537  1.00  0.95           O  
ATOM    516  CB  LYS A  34       5.163 -10.866  -3.300  1.00  0.91           C  
ATOM    517  CG  LYS A  34       3.980 -11.173  -4.214  1.00  1.00           C  
ATOM    518  CD  LYS A  34       4.435 -11.420  -5.652  1.00  1.14           C  
ATOM    519  CE  LYS A  34       3.247 -11.502  -6.610  1.00  1.09           C  
ATOM    520  NZ  LYS A  34       3.187 -12.828  -7.292  1.00  1.38           N  
ATOM    521  H   LYS A  34       4.173 -12.289  -1.051  1.00  1.07           H  
ATOM    522  HA  LYS A  34       6.020 -12.822  -3.282  1.00  1.01           H  
ATOM    523  HB2 LYS A  34       4.864 -10.122  -2.577  1.00  0.93           H  
ATOM    524  HB3 LYS A  34       5.976 -10.479  -3.893  1.00  0.91           H  
ATOM    525  HG2 LYS A  34       3.473 -12.053  -3.849  1.00  1.36           H  
ATOM    526  HG3 LYS A  34       3.297 -10.336  -4.198  1.00  1.34           H  
ATOM    527  HD2 LYS A  34       5.084 -10.613  -5.959  1.00  1.59           H  
ATOM    528  HD3 LYS A  34       4.981 -12.350  -5.690  1.00  1.56           H  
ATOM    529  HE2 LYS A  34       2.334 -11.355  -6.056  1.00  1.36           H  
ATOM    530  HE3 LYS A  34       3.340 -10.725  -7.354  1.00  1.45           H  
ATOM    531  HZ1 LYS A  34       3.669 -13.538  -6.708  1.00  1.72           H  
ATOM    532  HZ2 LYS A  34       2.194 -13.109  -7.422  1.00  1.86           H  
ATOM    533  HZ3 LYS A  34       3.657 -12.763  -8.220  1.00  1.88           H  
ATOM    534  N   PRO A  35       8.001 -12.123  -1.877  1.00  0.98           N  
ATOM    535  CA  PRO A  35       9.142 -11.833  -0.997  1.00  1.06           C  
ATOM    536  C   PRO A  35       9.536 -10.361  -1.034  1.00  0.99           C  
ATOM    537  O   PRO A  35       9.949  -9.794  -0.023  1.00  1.11           O  
ATOM    538  CB  PRO A  35      10.262 -12.710  -1.543  1.00  1.21           C  
ATOM    539  CG  PRO A  35       9.917 -12.946  -2.976  1.00  1.19           C  
ATOM    540  CD  PRO A  35       8.414 -12.848  -3.092  1.00  1.07           C  
ATOM    541  HA  PRO A  35       8.932 -12.125   0.019  1.00  1.15           H  
ATOM    542  HB2 PRO A  35      11.206 -12.193  -1.452  1.00  1.32           H  
ATOM    543  HB3 PRO A  35      10.296 -13.639  -0.994  1.00  1.27           H  
ATOM    544  HG2 PRO A  35      10.385 -12.195  -3.592  1.00  1.42           H  
ATOM    545  HG3 PRO A  35      10.249 -13.931  -3.273  1.00  1.29           H  
ATOM    546  HD2 PRO A  35       8.142 -12.295  -3.978  1.00  1.08           H  
ATOM    547  HD3 PRO A  35       7.975 -13.835  -3.114  1.00  1.36           H  
ATOM    548  N   HIS A  36       9.401  -9.746  -2.204  1.00  0.89           N  
ATOM    549  CA  HIS A  36       9.739  -8.337  -2.369  1.00  0.86           C  
ATOM    550  C   HIS A  36       8.480  -7.518  -2.629  1.00  0.74           C  
ATOM    551  O   HIS A  36       7.499  -8.023  -3.175  1.00  0.71           O  
ATOM    552  CB  HIS A  36      10.720  -8.157  -3.521  1.00  0.97           C  
ATOM    553  CG  HIS A  36      12.032  -8.842  -3.289  1.00  1.16           C  
ATOM    554  ND1 HIS A  36      12.951  -8.414  -2.364  1.00  1.62           N  
ATOM    555  CD2 HIS A  36      12.600  -9.935  -3.864  1.00  1.35           C  
ATOM    556  CE1 HIS A  36      14.014  -9.184  -2.364  1.00  1.72           C  
ATOM    557  NE2 HIS A  36      13.835 -10.130  -3.272  1.00  1.45           N  
ATOM    558  H   HIS A  36       9.063 -10.251  -2.974  1.00  0.91           H  
ATOM    559  HA  HIS A  36      10.202  -7.980  -1.461  1.00  0.90           H  
ATOM    560  HB2 HIS A  36      10.277  -8.553  -4.419  1.00  0.94           H  
ATOM    561  HB3 HIS A  36      10.905  -7.104  -3.658  1.00  1.01           H  
ATOM    562  HD1 HIS A  36      12.829  -7.635  -1.781  1.00  2.04           H  
ATOM    563  HD2 HIS A  36      12.168 -10.538  -4.647  1.00  1.74           H  
ATOM    564  HE1 HIS A  36      14.884  -9.065  -1.735  1.00  2.18           H  
ATOM    565  N   PRO A  37       8.498  -6.235  -2.236  1.00  0.71           N  
ATOM    566  CA  PRO A  37       7.360  -5.329  -2.423  1.00  0.64           C  
ATOM    567  C   PRO A  37       7.274  -4.822  -3.860  1.00  0.65           C  
ATOM    568  O   PRO A  37       8.286  -4.730  -4.555  1.00  0.92           O  
ATOM    569  CB  PRO A  37       7.640  -4.189  -1.454  1.00  0.70           C  
ATOM    570  CG  PRO A  37       9.124  -4.178  -1.264  1.00  0.80           C  
ATOM    571  CD  PRO A  37       9.632  -5.567  -1.580  1.00  0.81           C  
ATOM    572  HA  PRO A  37       6.432  -5.805  -2.149  1.00  0.61           H  
ATOM    573  HB2 PRO A  37       7.298  -3.259  -1.876  1.00  0.67           H  
ATOM    574  HB3 PRO A  37       7.134  -4.377  -0.519  1.00  0.96           H  
ATOM    575  HG2 PRO A  37       9.572  -3.460  -1.935  1.00  0.84           H  
ATOM    576  HG3 PRO A  37       9.358  -3.924  -0.241  1.00  0.87           H  
ATOM    577  HD2 PRO A  37      10.478  -5.518  -2.248  1.00  0.87           H  
ATOM    578  HD3 PRO A  37       9.904  -6.085  -0.674  1.00  0.88           H  
ATOM    579  N   LEU A  38       6.061  -4.510  -4.307  1.00  0.58           N  
ATOM    580  CA  LEU A  38       5.847  -4.031  -5.670  1.00  0.59           C  
ATOM    581  C   LEU A  38       5.532  -2.541  -5.691  1.00  0.55           C  
ATOM    582  O   LEU A  38       4.770  -2.044  -4.861  1.00  0.51           O  
ATOM    583  CB  LEU A  38       4.699  -4.802  -6.316  1.00  0.61           C  
ATOM    584  CG  LEU A  38       4.962  -6.307  -6.308  1.00  0.78           C  
ATOM    585  CD1 LEU A  38       3.661  -7.079  -6.511  1.00  1.34           C  
ATOM    586  CD2 LEU A  38       5.984  -6.689  -7.379  1.00  1.17           C  
ATOM    587  H   LEU A  38       5.291  -4.615  -3.710  1.00  0.69           H  
ATOM    588  HA  LEU A  38       6.746  -4.205  -6.243  1.00  0.67           H  
ATOM    589  HB2 LEU A  38       3.792  -4.602  -5.765  1.00  0.60           H  
ATOM    590  HB3 LEU A  38       4.578  -4.465  -7.335  1.00  0.65           H  
ATOM    591  HG  LEU A  38       5.368  -6.574  -5.345  1.00  1.32           H  
ATOM    592 HD11 LEU A  38       2.944  -6.774  -5.762  1.00  1.78           H  
ATOM    593 HD12 LEU A  38       3.268  -6.870  -7.495  1.00  1.82           H  
ATOM    594 HD13 LEU A  38       3.855  -8.137  -6.416  1.00  1.90           H  
ATOM    595 HD21 LEU A  38       5.922  -5.994  -8.203  1.00  1.49           H  
ATOM    596 HD22 LEU A  38       6.976  -6.659  -6.953  1.00  1.69           H  
ATOM    597 HD23 LEU A  38       5.775  -7.688  -7.731  1.00  1.81           H  
ATOM    598  N   GLN A  39       6.109  -1.839  -6.662  1.00  0.59           N  
ATOM    599  CA  GLN A  39       5.880  -0.407  -6.820  1.00  0.59           C  
ATOM    600  C   GLN A  39       4.525  -0.188  -7.482  1.00  0.58           C  
ATOM    601  O   GLN A  39       4.285  -0.669  -8.590  1.00  0.64           O  
ATOM    602  CB  GLN A  39       6.997   0.208  -7.666  1.00  0.71           C  
ATOM    603  CG  GLN A  39       6.685   1.649  -8.068  1.00  0.84           C  
ATOM    604  CD  GLN A  39       7.692   2.134  -9.102  1.00  1.41           C  
ATOM    605  OE1 GLN A  39       8.561   1.379  -9.540  1.00  1.89           O  
ATOM    606  NE2 GLN A  39       7.578   3.398  -9.495  1.00  1.61           N  
ATOM    607  H   GLN A  39       6.693  -2.302  -7.299  1.00  0.66           H  
ATOM    608  HA  GLN A  39       5.877   0.058  -5.844  1.00  0.57           H  
ATOM    609  HB2 GLN A  39       7.912   0.199  -7.098  1.00  0.77           H  
ATOM    610  HB3 GLN A  39       7.129  -0.385  -8.557  1.00  0.77           H  
ATOM    611  HG2 GLN A  39       5.692   1.696  -8.488  1.00  1.29           H  
ATOM    612  HG3 GLN A  39       6.738   2.283  -7.194  1.00  0.94           H  
ATOM    613 HE21 GLN A  39       6.863   3.941  -9.102  1.00  2.12           H  
ATOM    614 HE22 GLN A  39       8.214   3.735 -10.160  1.00  1.64           H  
ATOM    615  N   CYS A  40       3.634   0.515  -6.794  1.00  0.54           N  
ATOM    616  CA  CYS A  40       2.296   0.768  -7.318  1.00  0.55           C  
ATOM    617  C   CYS A  40       1.909   2.228  -7.122  1.00  0.55           C  
ATOM    618  O   CYS A  40       2.450   2.913  -6.254  1.00  0.58           O  
ATOM    619  CB  CYS A  40       1.279  -0.136  -6.610  1.00  0.56           C  
ATOM    620  SG  CYS A  40       1.951  -1.749  -6.184  1.00  1.11           S  
ATOM    621  H   CYS A  40       3.873   0.857  -5.910  1.00  0.53           H  
ATOM    622  HA  CYS A  40       2.285   0.541  -8.374  1.00  0.60           H  
ATOM    623  HB2 CYS A  40       0.950   0.349  -5.705  1.00  0.57           H  
ATOM    624  HB3 CYS A  40       0.433  -0.277  -7.259  1.00  1.25           H  
ATOM    625  HG  CYS A  40       2.728  -1.900  -6.722  1.00  1.28           H  
ATOM    626  N   GLN A  41       0.961   2.696  -7.928  1.00  0.56           N  
ATOM    627  CA  GLN A  41       0.489   4.074  -7.838  1.00  0.58           C  
ATOM    628  C   GLN A  41      -0.969   4.090  -7.409  1.00  0.57           C  
ATOM    629  O   GLN A  41      -1.732   3.181  -7.740  1.00  0.65           O  
ATOM    630  CB  GLN A  41       0.672   4.782  -9.173  1.00  0.66           C  
ATOM    631  CG  GLN A  41       2.149   5.060  -9.434  1.00  0.72           C  
ATOM    632  CD  GLN A  41       2.335   5.739 -10.787  1.00  1.27           C  
ATOM    633  OE1 GLN A  41       3.050   6.735 -10.895  1.00  1.80           O  
ATOM    634  NE2 GLN A  41       1.692   5.206 -11.822  1.00  2.05           N  
ATOM    635  H   GLN A  41       0.562   2.098  -8.594  1.00  0.60           H  
ATOM    636  HA  GLN A  41       1.074   4.589  -7.090  1.00  0.55           H  
ATOM    637  HB2 GLN A  41       0.283   4.156  -9.962  1.00  0.71           H  
ATOM    638  HB3 GLN A  41       0.132   5.720  -9.158  1.00  0.70           H  
ATOM    639  HG2 GLN A  41       2.530   5.705  -8.654  1.00  1.10           H  
ATOM    640  HG3 GLN A  41       2.695   4.128  -9.422  1.00  1.11           H  
ATOM    641 HE21 GLN A  41       1.136   4.414 -11.668  1.00  2.63           H  
ATOM    642 HE22 GLN A  41       1.800   5.628 -12.700  1.00  2.34           H  
ATOM    643  N   PHE A  42      -1.346   5.107  -6.647  1.00  0.52           N  
ATOM    644  CA  PHE A  42      -2.709   5.216  -6.141  1.00  0.52           C  
ATOM    645  C   PHE A  42      -3.352   6.542  -6.531  1.00  0.57           C  
ATOM    646  O   PHE A  42      -2.689   7.577  -6.585  1.00  0.57           O  
ATOM    647  CB  PHE A  42      -2.685   5.082  -4.626  1.00  0.47           C  
ATOM    648  CG  PHE A  42      -2.077   3.779  -4.182  1.00  0.39           C  
ATOM    649  CD1 PHE A  42      -0.701   3.623  -4.173  1.00  0.39           C  
ATOM    650  CD2 PHE A  42      -2.894   2.735  -3.798  1.00  0.41           C  
ATOM    651  CE1 PHE A  42      -0.143   2.420  -3.779  1.00  0.39           C  
ATOM    652  CE2 PHE A  42      -2.339   1.530  -3.398  1.00  0.40           C  
ATOM    653  CZ  PHE A  42      -0.960   1.372  -3.391  1.00  0.39           C  
ATOM    654  H   PHE A  42      -0.686   5.788  -6.398  1.00  0.52           H  
ATOM    655  HA  PHE A  42      -3.296   4.406  -6.543  1.00  0.54           H  
ATOM    656  HB2 PHE A  42      -2.103   5.890  -4.211  1.00  0.52           H  
ATOM    657  HB3 PHE A  42      -3.694   5.139  -4.253  1.00  0.50           H  
ATOM    658  HD1 PHE A  42      -0.064   4.441  -4.474  1.00  0.45           H  
ATOM    659  HD2 PHE A  42      -3.968   2.863  -3.806  1.00  0.48           H  
ATOM    660  HE1 PHE A  42       0.930   2.299  -3.772  1.00  0.46           H  
ATOM    661  HE2 PHE A  42      -2.978   0.714  -3.095  1.00  0.47           H  
ATOM    662  HZ  PHE A  42      -0.523   0.433  -3.088  1.00  0.44           H  
ATOM    663  N   PHE A  43      -4.660   6.499  -6.779  1.00  0.62           N  
ATOM    664  CA  PHE A  43      -5.422   7.692  -7.138  1.00  0.69           C  
ATOM    665  C   PHE A  43      -5.971   8.328  -5.870  1.00  0.66           C  
ATOM    666  O   PHE A  43      -7.151   8.189  -5.548  1.00  0.72           O  
ATOM    667  CB  PHE A  43      -6.565   7.315  -8.069  1.00  0.80           C  
ATOM    668  CG  PHE A  43      -7.282   8.507  -8.656  1.00  0.88           C  
ATOM    669  CD1 PHE A  43      -8.343   9.086  -7.977  1.00  0.95           C  
ATOM    670  CD2 PHE A  43      -6.885   9.021  -9.880  1.00  0.97           C  
ATOM    671  CE1 PHE A  43      -9.002  10.176  -8.518  1.00  1.05           C  
ATOM    672  CE2 PHE A  43      -7.546  10.111 -10.423  1.00  1.07           C  
ATOM    673  CZ  PHE A  43      -8.605  10.689  -9.741  1.00  1.10           C  
ATOM    674  H   PHE A  43      -5.127   5.642  -6.700  1.00  0.63           H  
ATOM    675  HA  PHE A  43      -4.773   8.391  -7.638  1.00  0.70           H  
ATOM    676  HB2 PHE A  43      -6.174   6.715  -8.878  1.00  0.80           H  
ATOM    677  HB3 PHE A  43      -7.274   6.734  -7.509  1.00  0.84           H  
ATOM    678  HD1 PHE A  43      -8.656   8.687  -7.025  1.00  0.96           H  
ATOM    679  HD2 PHE A  43      -6.061   8.573 -10.411  1.00  1.00           H  
ATOM    680  HE1 PHE A  43      -9.826  10.627  -7.987  1.00  1.14           H  
ATOM    681  HE2 PHE A  43      -7.236  10.510 -11.377  1.00  1.17           H  
ATOM    682  HZ  PHE A  43      -9.120  11.539 -10.164  1.00  1.20           H  
ATOM    683  N   VAL A  44      -5.094   8.997  -5.140  1.00  0.67           N  
ATOM    684  CA  VAL A  44      -5.460   9.635  -3.877  1.00  0.68           C  
ATOM    685  C   VAL A  44      -6.097  11.002  -4.098  1.00  0.77           C  
ATOM    686  O   VAL A  44      -5.937  11.616  -5.152  1.00  0.85           O  
ATOM    687  CB  VAL A  44      -4.218   9.788  -3.001  1.00  0.57           C  
ATOM    688  CG1 VAL A  44      -3.546   8.437  -2.786  1.00  0.60           C  
ATOM    689  CG2 VAL A  44      -3.228  10.777  -3.619  1.00  0.56           C  
ATOM    690  H   VAL A  44      -4.168   9.043  -5.447  1.00  0.74           H  
ATOM    691  HA  VAL A  44      -6.167   9.003  -3.363  1.00  0.76           H  
ATOM    692  HB  VAL A  44      -4.526  10.172  -2.038  1.00  0.59           H  
ATOM    693 HG11 VAL A  44      -4.287   7.714  -2.480  1.00  1.20           H  
ATOM    694 HG12 VAL A  44      -3.087   8.118  -3.709  1.00  1.16           H  
ATOM    695 HG13 VAL A  44      -2.791   8.530  -2.019  1.00  1.19           H  
ATOM    696 HG21 VAL A  44      -3.768  11.594  -4.075  1.00  1.15           H  
ATOM    697 HG22 VAL A  44      -2.578  11.162  -2.846  1.00  1.16           H  
ATOM    698 HG23 VAL A  44      -2.638  10.272  -4.369  1.00  1.17           H  
ATOM    699  N   GLU A  45      -6.795  11.480  -3.071  1.00  0.85           N  
ATOM    700  CA  GLU A  45      -7.436  12.790  -3.114  1.00  0.98           C  
ATOM    701  C   GLU A  45      -6.515  13.800  -2.446  1.00  0.89           C  
ATOM    702  O   GLU A  45      -6.410  14.950  -2.872  1.00  1.01           O  
ATOM    703  CB  GLU A  45      -8.786  12.765  -2.390  1.00  1.14           C  
ATOM    704  CG  GLU A  45      -9.455  11.394  -2.467  1.00  1.32           C  
ATOM    705  CD  GLU A  45     -10.756  11.398  -1.674  1.00  1.82           C  
ATOM    706  OE1 GLU A  45     -10.732  11.808  -0.495  1.00  2.37           O  
ATOM    707  OE2 GLU A  45     -11.796  10.990  -2.233  1.00  2.22           O  
ATOM    708  H   GLU A  45      -6.861  10.945  -2.253  1.00  0.86           H  
ATOM    709  HA  GLU A  45      -7.589  13.076  -4.142  1.00  1.09           H  
ATOM    710  HB2 GLU A  45      -8.629  13.020  -1.355  1.00  1.26           H  
ATOM    711  HB3 GLU A  45      -9.438  13.499  -2.841  1.00  1.12           H  
ATOM    712  HG2 GLU A  45      -9.665  11.155  -3.499  1.00  1.41           H  
ATOM    713  HG3 GLU A  45      -8.790  10.651  -2.053  1.00  1.76           H  
ATOM    714  N   SER A  46      -5.838  13.340  -1.398  1.00  0.75           N  
ATOM    715  CA  SER A  46      -4.899  14.164  -0.647  1.00  0.71           C  
ATOM    716  C   SER A  46      -3.552  13.454  -0.570  1.00  0.62           C  
ATOM    717  O   SER A  46      -3.493  12.225  -0.521  1.00  0.59           O  
ATOM    718  CB  SER A  46      -5.435  14.423   0.755  1.00  0.74           C  
ATOM    719  OG  SER A  46      -6.842  14.248   0.791  1.00  0.98           O  
ATOM    720  H   SER A  46      -5.969  12.408  -1.127  1.00  0.74           H  
ATOM    721  HA  SER A  46      -4.773  15.106  -1.155  1.00  0.78           H  
ATOM    722  HB2 SER A  46      -4.971  13.733   1.441  1.00  1.01           H  
ATOM    723  HB3 SER A  46      -5.192  15.434   1.046  1.00  1.09           H  
ATOM    724  HG  SER A  46      -7.252  14.803   0.124  1.00  1.28           H  
ATOM    725  N   VAL A  47      -2.471  14.227  -0.570  1.00  0.63           N  
ATOM    726  CA  VAL A  47      -1.127  13.658  -0.510  1.00  0.59           C  
ATOM    727  C   VAL A  47      -0.883  12.982   0.835  1.00  0.57           C  
ATOM    728  O   VAL A  47      -1.081  13.584   1.890  1.00  0.67           O  
ATOM    729  CB  VAL A  47      -0.086  14.747  -0.745  1.00  0.67           C  
ATOM    730  CG1 VAL A  47       1.325  14.170  -0.652  1.00  0.70           C  
ATOM    731  CG2 VAL A  47      -0.300  15.414  -2.102  1.00  0.74           C  
ATOM    732  H   VAL A  47      -2.580  15.198  -0.618  1.00  0.69           H  
ATOM    733  HA  VAL A  47      -1.032  12.920  -1.290  1.00  0.56           H  
ATOM    734  HB  VAL A  47      -0.200  15.492   0.023  1.00  0.70           H  
ATOM    735 HG11 VAL A  47       1.279  13.095  -0.744  1.00  1.30           H  
ATOM    736 HG12 VAL A  47       1.931  14.575  -1.449  1.00  1.26           H  
ATOM    737 HG13 VAL A  47       1.757  14.434   0.301  1.00  1.18           H  
ATOM    738 HG21 VAL A  47      -0.924  14.783  -2.717  1.00  1.37           H  
ATOM    739 HG22 VAL A  47      -0.781  16.371  -1.958  1.00  1.18           H  
ATOM    740 HG23 VAL A  47       0.656  15.559  -2.583  1.00  1.25           H  
ATOM    741  N   ILE A  48      -0.442  11.727   0.785  1.00  0.48           N  
ATOM    742  CA  ILE A  48      -0.155  10.957   1.993  1.00  0.48           C  
ATOM    743  C   ILE A  48       1.342  10.992   2.290  1.00  0.52           C  
ATOM    744  O   ILE A  48       2.161  10.796   1.392  1.00  0.53           O  
ATOM    745  CB  ILE A  48      -0.611   9.512   1.802  1.00  0.46           C  
ATOM    746  CG1 ILE A  48      -2.115   9.459   1.552  1.00  0.45           C  
ATOM    747  CG2 ILE A  48      -0.247   8.657   3.015  1.00  0.50           C  
ATOM    748  CD1 ILE A  48      -2.546   8.062   1.116  1.00  0.43           C  
ATOM    749  H   ILE A  48      -0.300  11.310  -0.090  1.00  0.47           H  
ATOM    750  HA  ILE A  48      -0.696  11.387   2.821  1.00  0.51           H  
ATOM    751  HB  ILE A  48      -0.101   9.108   0.938  1.00  0.46           H  
ATOM    752 HG12 ILE A  48      -2.634   9.724   2.462  1.00  0.47           H  
ATOM    753 HG13 ILE A  48      -2.368  10.165   0.776  1.00  0.48           H  
ATOM    754 HG21 ILE A  48       0.777   8.851   3.298  1.00  1.15           H  
ATOM    755 HG22 ILE A  48      -0.904   8.903   3.836  1.00  1.11           H  
ATOM    756 HG23 ILE A  48      -0.361   7.613   2.763  1.00  1.11           H  
ATOM    757 HD11 ILE A  48      -1.671   7.481   0.864  1.00  1.09           H  
ATOM    758 HD12 ILE A  48      -3.080   7.582   1.923  1.00  1.11           H  
ATOM    759 HD13 ILE A  48      -3.189   8.140   0.251  1.00  1.08           H  
ATOM    760  N   PRO A  49       1.725  11.237   3.555  1.00  0.56           N  
ATOM    761  CA  PRO A  49       3.141  11.288   3.953  1.00  0.61           C  
ATOM    762  C   PRO A  49       3.824   9.930   3.836  1.00  0.62           C  
ATOM    763  O   PRO A  49       3.304   8.914   4.300  1.00  0.63           O  
ATOM    764  CB  PRO A  49       3.106  11.773   5.395  1.00  0.66           C  
ATOM    765  CG  PRO A  49       1.750  11.402   5.890  1.00  0.64           C  
ATOM    766  CD  PRO A  49       0.829  11.482   4.696  1.00  0.58           C  
ATOM    767  HA  PRO A  49       3.678  12.007   3.362  1.00  0.62           H  
ATOM    768  HB2 PRO A  49       3.877  11.277   5.967  1.00  0.68           H  
ATOM    769  HB3 PRO A  49       3.253  12.841   5.423  1.00  0.70           H  
ATOM    770  HG2 PRO A  49       1.771  10.397   6.281  1.00  0.67           H  
ATOM    771  HG3 PRO A  49       1.435  12.095   6.656  1.00  0.66           H  
ATOM    772  HD2 PRO A  49       0.062  10.726   4.756  1.00  0.59           H  
ATOM    773  HD3 PRO A  49       0.386  12.464   4.629  1.00  0.57           H  
ATOM    774  N   ALA A  50       4.991   9.928   3.203  1.00  0.63           N  
ATOM    775  CA  ALA A  50       5.767   8.706   2.997  1.00  0.64           C  
ATOM    776  C   ALA A  50       5.914   7.930   4.302  1.00  0.68           C  
ATOM    777  O   ALA A  50       6.321   8.481   5.325  1.00  0.78           O  
ATOM    778  CB  ALA A  50       7.142   9.064   2.431  1.00  0.69           C  
ATOM    779  H   ALA A  50       5.340  10.775   2.856  1.00  0.64           H  
ATOM    780  HA  ALA A  50       5.248   8.080   2.282  1.00  0.59           H  
ATOM    781  HB1 ALA A  50       7.492   9.976   2.892  1.00  1.20           H  
ATOM    782  HB2 ALA A  50       7.835   8.263   2.638  1.00  1.19           H  
ATOM    783  HB3 ALA A  50       7.062   9.210   1.361  1.00  1.29           H  
ATOM    784  N   GLY A  51       5.574   6.644   4.253  1.00  0.63           N  
ATOM    785  CA  GLY A  51       5.658   5.772   5.422  1.00  0.67           C  
ATOM    786  C   GLY A  51       4.826   4.511   5.209  1.00  0.62           C  
ATOM    787  O   GLY A  51       3.914   4.491   4.382  1.00  0.56           O  
ATOM    788  H   GLY A  51       5.257   6.271   3.404  1.00  0.58           H  
ATOM    789  HA2 GLY A  51       6.690   5.494   5.581  1.00  0.70           H  
ATOM    790  HA3 GLY A  51       5.289   6.303   6.286  1.00  0.71           H  
ATOM    791  N   SER A  52       5.146   3.458   5.958  1.00  0.65           N  
ATOM    792  CA  SER A  52       4.426   2.191   5.847  1.00  0.63           C  
ATOM    793  C   SER A  52       3.131   2.237   6.646  1.00  0.63           C  
ATOM    794  O   SER A  52       3.123   2.620   7.816  1.00  0.69           O  
ATOM    795  CB  SER A  52       5.306   1.047   6.337  1.00  0.70           C  
ATOM    796  OG  SER A  52       6.234   1.515   7.306  1.00  0.95           O  
ATOM    797  H   SER A  52       5.883   3.536   6.598  1.00  0.71           H  
ATOM    798  HA  SER A  52       4.185   2.021   4.810  1.00  0.58           H  
ATOM    799  HB2 SER A  52       4.688   0.287   6.782  1.00  0.76           H  
ATOM    800  HB3 SER A  52       5.835   0.626   5.491  1.00  0.68           H  
ATOM    801  HG  SER A  52       5.898   1.334   8.187  1.00  1.20           H  
ATOM    802  N   TYR A  53       2.034   1.853   5.999  1.00  0.58           N  
ATOM    803  CA  TYR A  53       0.723   1.855   6.639  1.00  0.58           C  
ATOM    804  C   TYR A  53       0.020   0.515   6.465  1.00  0.58           C  
ATOM    805  O   TYR A  53       0.245  -0.198   5.489  1.00  0.55           O  
ATOM    806  CB  TYR A  53      -0.165   2.928   6.010  1.00  0.53           C  
ATOM    807  CG  TYR A  53       0.159   4.335   6.440  1.00  0.55           C  
ATOM    808  CD1 TYR A  53       1.201   5.025   5.844  1.00  0.56           C  
ATOM    809  CD2 TYR A  53      -0.598   4.944   7.424  1.00  0.60           C  
ATOM    810  CE1 TYR A  53       1.486   6.323   6.236  1.00  0.61           C  
ATOM    811  CE2 TYR A  53      -0.312   6.240   7.816  1.00  0.64           C  
ATOM    812  CZ  TYR A  53       0.729   6.924   7.222  1.00  0.64           C  
ATOM    813  OH  TYR A  53       1.011   8.215   7.614  1.00  0.71           O  
ATOM    814  H   TYR A  53       2.109   1.566   5.065  1.00  0.56           H  
ATOM    815  HA  TYR A  53       0.838   2.067   7.690  1.00  0.64           H  
ATOM    816  HB2 TYR A  53      -0.067   2.867   4.939  1.00  0.54           H  
ATOM    817  HB3 TYR A  53      -1.190   2.722   6.278  1.00  0.49           H  
ATOM    818  HD1 TYR A  53       1.793   4.551   5.074  1.00  0.55           H  
ATOM    819  HD2 TYR A  53      -1.420   4.408   7.881  1.00  0.63           H  
ATOM    820  HE1 TYR A  53       2.295   6.864   5.768  1.00  0.64           H  
ATOM    821  HE2 TYR A  53      -0.901   6.715   8.587  1.00  0.70           H  
ATOM    822  HH  TYR A  53       1.713   8.575   7.068  1.00  1.01           H  
ATOM    823  N   GLN A  54      -0.885   0.223   7.389  1.00  0.63           N  
ATOM    824  CA  GLN A  54      -1.701  -0.986   7.327  1.00  0.65           C  
ATOM    825  C   GLN A  54      -3.100  -0.539   6.947  1.00  0.62           C  
ATOM    826  O   GLN A  54      -3.920  -0.206   7.804  1.00  0.67           O  
ATOM    827  CB  GLN A  54      -1.717  -1.710   8.666  1.00  0.74           C  
ATOM    828  CG  GLN A  54      -0.326  -2.228   9.037  1.00  0.82           C  
ATOM    829  CD  GLN A  54      -0.406  -3.303  10.133  1.00  1.15           C  
ATOM    830  OE1 GLN A  54       0.409  -3.296  11.056  1.00  1.84           O  
ATOM    831  NE2 GLN A  54      -1.374  -4.231  10.056  1.00  1.57           N  
ATOM    832  H   GLN A  54      -1.047   0.868   8.107  1.00  0.66           H  
ATOM    833  HA  GLN A  54      -1.312  -1.641   6.561  1.00  0.63           H  
ATOM    834  HB2 GLN A  54      -2.054  -1.026   9.429  1.00  0.88           H  
ATOM    835  HB3 GLN A  54      -2.404  -2.536   8.598  1.00  0.86           H  
ATOM    836  HG2 GLN A  54       0.163  -2.632   8.155  1.00  1.45           H  
ATOM    837  HG3 GLN A  54       0.260  -1.402   9.411  1.00  0.81           H  
ATOM    838 HE21 GLN A  54      -2.005  -4.205   9.307  1.00  1.87           H  
ATOM    839 HE22 GLN A  54      -1.409  -4.908  10.763  1.00  2.15           H  
ATOM    840  N   VAL A  55      -3.326  -0.456   5.650  1.00  0.56           N  
ATOM    841  CA  VAL A  55      -4.585   0.043   5.107  1.00  0.53           C  
ATOM    842  C   VAL A  55      -5.682  -1.019   5.019  1.00  0.56           C  
ATOM    843  O   VAL A  55      -5.498  -2.066   4.397  1.00  0.56           O  
ATOM    844  CB  VAL A  55      -4.332   0.604   3.708  1.00  0.47           C  
ATOM    845  CG1 VAL A  55      -5.557   1.356   3.204  1.00  0.46           C  
ATOM    846  CG2 VAL A  55      -3.101   1.510   3.697  1.00  0.44           C  
ATOM    847  H   VAL A  55      -2.601  -0.688   5.037  1.00  0.54           H  
ATOM    848  HA  VAL A  55      -4.925   0.851   5.734  1.00  0.54           H  
ATOM    849  HB  VAL A  55      -4.145  -0.225   3.041  1.00  0.47           H  
ATOM    850 HG11 VAL A  55      -6.193   1.606   4.041  1.00  1.07           H  
ATOM    851 HG12 VAL A  55      -5.242   2.261   2.707  1.00  1.11           H  
ATOM    852 HG13 VAL A  55      -6.099   0.731   2.511  1.00  1.13           H  
ATOM    853 HG21 VAL A  55      -2.687   1.569   4.690  1.00  1.07           H  
ATOM    854 HG22 VAL A  55      -2.363   1.102   3.023  1.00  1.07           H  
ATOM    855 HG23 VAL A  55      -3.387   2.498   3.365  1.00  1.15           H  
ATOM    856  N   PRO A  56      -6.872  -0.726   5.590  1.00  0.60           N  
ATOM    857  CA  PRO A  56      -8.033  -1.617   5.518  1.00  0.63           C  
ATOM    858  C   PRO A  56      -8.730  -1.463   4.174  1.00  0.59           C  
ATOM    859  O   PRO A  56      -9.294  -0.409   3.881  1.00  0.67           O  
ATOM    860  CB  PRO A  56      -8.937  -1.148   6.650  1.00  0.68           C  
ATOM    861  CG  PRO A  56      -8.568   0.276   6.903  1.00  0.66           C  
ATOM    862  CD  PRO A  56      -7.177   0.494   6.357  1.00  0.61           C  
ATOM    863  HA  PRO A  56      -7.755  -2.646   5.679  1.00  0.65           H  
ATOM    864  HB2 PRO A  56      -9.969  -1.217   6.337  1.00  0.72           H  
ATOM    865  HB3 PRO A  56      -8.773  -1.755   7.527  1.00  0.69           H  
ATOM    866  HG2 PRO A  56      -9.266   0.928   6.404  1.00  0.65           H  
ATOM    867  HG3 PRO A  56      -8.580   0.469   7.966  1.00  0.71           H  
ATOM    868  HD2 PRO A  56      -7.156   1.362   5.717  1.00  0.56           H  
ATOM    869  HD3 PRO A  56      -6.477   0.608   7.169  1.00  0.63           H  
ATOM    870  N   TYR A  57      -8.671  -2.498   3.347  1.00  0.55           N  
ATOM    871  CA  TYR A  57      -9.281  -2.438   2.024  1.00  0.54           C  
ATOM    872  C   TYR A  57     -10.493  -3.349   1.916  1.00  0.58           C  
ATOM    873  O   TYR A  57     -10.707  -4.232   2.747  1.00  0.61           O  
ATOM    874  CB  TYR A  57      -8.259  -2.829   0.959  1.00  0.50           C  
ATOM    875  CG  TYR A  57      -7.887  -4.291   1.007  1.00  0.51           C  
ATOM    876  CD1 TYR A  57      -8.639  -5.224   0.312  1.00  0.55           C  
ATOM    877  CD2 TYR A  57      -6.790  -4.702   1.744  1.00  0.53           C  
ATOM    878  CE1 TYR A  57      -8.296  -6.565   0.357  1.00  0.60           C  
ATOM    879  CE2 TYR A  57      -6.448  -6.044   1.788  1.00  0.58           C  
ATOM    880  CZ  TYR A  57      -7.202  -6.969   1.095  1.00  0.60           C  
ATOM    881  OH  TYR A  57      -6.862  -8.302   1.141  1.00  0.68           O  
ATOM    882  H   TYR A  57      -8.192  -3.308   3.624  1.00  0.59           H  
ATOM    883  HA  TYR A  57      -9.595  -1.423   1.838  1.00  0.54           H  
ATOM    884  HB2 TYR A  57      -8.671  -2.611  -0.016  1.00  0.49           H  
ATOM    885  HB3 TYR A  57      -7.364  -2.244   1.102  1.00  0.50           H  
ATOM    886  HD1 TYR A  57      -9.495  -4.906  -0.265  1.00  0.59           H  
ATOM    887  HD2 TYR A  57      -6.203  -3.978   2.286  1.00  0.55           H  
ATOM    888  HE1 TYR A  57      -8.883  -7.293  -0.183  1.00  0.66           H  
ATOM    889  HE2 TYR A  57      -5.591  -6.364   2.363  1.00  0.63           H  
ATOM    890  HH  TYR A  57      -7.644  -8.825   1.333  1.00  0.93           H  
ATOM    891  N   ARG A  58     -11.270  -3.123   0.863  1.00  0.60           N  
ATOM    892  CA  ARG A  58     -12.465  -3.905   0.579  1.00  0.66           C  
ATOM    893  C   ARG A  58     -12.570  -4.103  -0.927  1.00  0.63           C  
ATOM    894  O   ARG A  58     -11.923  -3.391  -1.695  1.00  0.70           O  
ATOM    895  CB  ARG A  58     -13.718  -3.196   1.092  1.00  0.75           C  
ATOM    896  CG  ARG A  58     -13.431  -2.280   2.282  1.00  1.19           C  
ATOM    897  CD  ARG A  58     -14.649  -1.424   2.615  1.00  1.19           C  
ATOM    898  NE  ARG A  58     -14.542  -0.877   3.963  1.00  1.51           N  
ATOM    899  CZ  ARG A  58     -15.451  -0.034   4.443  1.00  1.90           C  
ATOM    900  NH1 ARG A  58     -16.686  -0.452   4.695  1.00  2.66           N  
ATOM    901  NH2 ARG A  58     -15.126   1.233   4.666  1.00  2.09           N  
ATOM    902  H   ARG A  58     -11.024  -2.408   0.244  1.00  0.61           H  
ATOM    903  HA  ARG A  58     -12.381  -4.868   1.058  1.00  0.70           H  
ATOM    904  HB2 ARG A  58     -14.134  -2.608   0.290  1.00  1.12           H  
ATOM    905  HB3 ARG A  58     -14.435  -3.940   1.391  1.00  1.31           H  
ATOM    906  HG2 ARG A  58     -13.176  -2.884   3.142  1.00  1.41           H  
ATOM    907  HG3 ARG A  58     -12.601  -1.633   2.041  1.00  1.98           H  
ATOM    908  HD2 ARG A  58     -14.716  -0.609   1.912  1.00  1.64           H  
ATOM    909  HD3 ARG A  58     -15.541  -2.032   2.546  1.00  1.73           H  
ATOM    910  HE  ARG A  58     -13.782  -1.135   4.528  1.00  2.12           H  
ATOM    911 HH11 ARG A  58     -16.936  -1.405   4.525  1.00  2.90           H  
ATOM    912 HH12 ARG A  58     -17.367   0.187   5.055  1.00  3.24           H  
ATOM    913 HH21 ARG A  58     -14.198   1.551   4.473  1.00  2.18           H  
ATOM    914 HH22 ARG A  58     -15.808   1.869   5.027  1.00  2.55           H  
ATOM    915  N   ILE A  59     -13.379  -5.063  -1.354  1.00  0.57           N  
ATOM    916  CA  ILE A  59     -13.545  -5.331  -2.779  1.00  0.56           C  
ATOM    917  C   ILE A  59     -14.842  -4.711  -3.288  1.00  0.59           C  
ATOM    918  O   ILE A  59     -15.926  -5.252  -3.075  1.00  0.80           O  
ATOM    919  CB  ILE A  59     -13.534  -6.836  -3.030  1.00  0.57           C  
ATOM    920  CG1 ILE A  59     -12.196  -7.432  -2.588  1.00  0.60           C  
ATOM    921  CG2 ILE A  59     -13.790  -7.137  -4.505  1.00  0.58           C  
ATOM    922  CD1 ILE A  59     -12.270  -8.951  -2.458  1.00  0.63           C  
ATOM    923  H   ILE A  59     -13.872  -5.603  -0.700  1.00  0.58           H  
ATOM    924  HA  ILE A  59     -12.718  -4.885  -3.311  1.00  0.55           H  
ATOM    925  HB  ILE A  59     -14.325  -7.287  -2.448  1.00  0.57           H  
ATOM    926 HG12 ILE A  59     -11.440  -7.179  -3.315  1.00  0.63           H  
ATOM    927 HG13 ILE A  59     -11.925  -7.012  -1.630  1.00  0.62           H  
ATOM    928 HG21 ILE A  59     -13.625  -6.241  -5.085  1.00  1.19           H  
ATOM    929 HG22 ILE A  59     -13.113  -7.912  -4.835  1.00  1.04           H  
ATOM    930 HG23 ILE A  59     -14.809  -7.468  -4.630  1.00  1.08           H  
ATOM    931 HD11 ILE A  59     -13.035  -9.212  -1.744  1.00  1.19           H  
ATOM    932 HD12 ILE A  59     -12.508  -9.382  -3.419  1.00  1.10           H  
ATOM    933 HD13 ILE A  59     -11.316  -9.327  -2.120  1.00  1.27           H  
ATOM    934  N   ASN A  60     -14.724  -3.576  -3.970  1.00  0.53           N  
ATOM    935  CA  ASN A  60     -15.895  -2.887  -4.511  1.00  0.55           C  
ATOM    936  C   ASN A  60     -16.108  -3.274  -5.964  1.00  0.51           C  
ATOM    937  O   ASN A  60     -15.172  -3.681  -6.652  1.00  0.61           O  
ATOM    938  CB  ASN A  60     -15.740  -1.370  -4.402  1.00  0.69           C  
ATOM    939  CG  ASN A  60     -16.955  -0.767  -3.711  1.00  1.32           C  
ATOM    940  OD1 ASN A  60     -17.513   0.231  -4.169  1.00  1.58           O  
ATOM    941  ND2 ASN A  60     -17.368  -1.374  -2.607  1.00  2.33           N  
ATOM    942  H   ASN A  60     -13.831  -3.200  -4.117  1.00  0.59           H  
ATOM    943  HA  ASN A  60     -16.762  -3.185  -3.945  1.00  0.57           H  
ATOM    944  HB2 ASN A  60     -14.856  -1.134  -3.834  1.00  1.28           H  
ATOM    945  HB3 ASN A  60     -15.657  -0.953  -5.392  1.00  0.73           H  
ATOM    946 HD21 ASN A  60     -16.878  -2.166  -2.302  1.00  3.01           H  
ATOM    947 HD22 ASN A  60     -18.146  -1.005  -2.143  1.00  2.57           H  
ATOM    948  N   VAL A  61     -17.343  -3.143  -6.428  1.00  0.58           N  
ATOM    949  CA  VAL A  61     -17.673  -3.475  -7.803  1.00  0.58           C  
ATOM    950  C   VAL A  61     -18.132  -2.225  -8.545  1.00  0.67           C  
ATOM    951  O   VAL A  61     -19.187  -1.664  -8.251  1.00  0.78           O  
ATOM    952  CB  VAL A  61     -18.756  -4.558  -7.835  1.00  0.56           C  
ATOM    953  CG1 VAL A  61     -19.265  -4.767  -9.259  1.00  0.53           C  
ATOM    954  CG2 VAL A  61     -18.217  -5.869  -7.262  1.00  0.58           C  
ATOM    955  H   VAL A  61     -18.046  -2.809  -5.831  1.00  0.74           H  
ATOM    956  HA  VAL A  61     -16.786  -3.858  -8.287  1.00  0.55           H  
ATOM    957  HB  VAL A  61     -19.583  -4.232  -7.221  1.00  0.63           H  
ATOM    958 HG11 VAL A  61     -18.509  -4.443  -9.954  1.00  1.07           H  
ATOM    959 HG12 VAL A  61     -19.474  -5.809  -9.417  1.00  1.28           H  
ATOM    960 HG13 VAL A  61     -20.166  -4.189  -9.405  1.00  1.07           H  
ATOM    961 HG21 VAL A  61     -17.498  -5.654  -6.486  1.00  1.08           H  
ATOM    962 HG22 VAL A  61     -19.035  -6.443  -6.849  1.00  1.24           H  
ATOM    963 HG23 VAL A  61     -17.740  -6.437  -8.049  1.00  1.20           H  
ATOM    964  N   ASN A  62     -17.323  -1.798  -9.510  1.00  0.66           N  
ATOM    965  CA  ASN A  62     -17.628  -0.615 -10.307  1.00  0.76           C  
ATOM    966  C   ASN A  62     -17.903  -1.010 -11.749  1.00  0.75           C  
ATOM    967  O   ASN A  62     -17.158  -1.786 -12.336  1.00  0.73           O  
ATOM    968  CB  ASN A  62     -16.461   0.360 -10.264  1.00  0.86           C  
ATOM    969  CG  ASN A  62     -16.907   1.737 -10.737  1.00  1.28           C  
ATOM    970  OD1 ASN A  62     -17.914   2.269 -10.272  1.00  1.86           O  
ATOM    971  ND2 ASN A  62     -16.153   2.314 -11.664  1.00  2.04           N  
ATOM    972  H   ASN A  62     -16.499  -2.295  -9.690  1.00  0.62           H  
ATOM    973  HA  ASN A  62     -18.497  -0.132  -9.902  1.00  0.81           H  
ATOM    974  HB2 ASN A  62     -16.090   0.430  -9.252  1.00  1.24           H  
ATOM    975  HB3 ASN A  62     -15.682  -0.002 -10.910  1.00  1.41           H  
ATOM    976 HD21 ASN A  62     -15.364   1.831 -11.986  1.00  2.40           H  
ATOM    977 HD22 ASN A  62     -16.416   3.201 -11.989  1.00  2.59           H  
ATOM    978  N   ASN A  63     -18.975  -0.462 -12.309  1.00  0.83           N  
ATOM    979  CA  ASN A  63     -19.370  -0.736 -13.690  1.00  0.89           C  
ATOM    980  C   ASN A  63     -19.387  -2.246 -13.982  1.00  0.78           C  
ATOM    981  O   ASN A  63     -19.291  -2.668 -15.133  1.00  0.83           O  
ATOM    982  CB  ASN A  63     -18.469   0.062 -14.666  1.00  1.03           C  
ATOM    983  CG  ASN A  63     -17.434  -0.807 -15.400  1.00  1.10           C  
ATOM    984  OD1 ASN A  63     -17.499  -0.949 -16.621  1.00  1.70           O  
ATOM    985  ND2 ASN A  63     -16.484  -1.386 -14.671  1.00  1.33           N  
ATOM    986  H   ASN A  63     -19.521   0.153 -11.776  1.00  0.88           H  
ATOM    987  HA  ASN A  63     -20.382  -0.375 -13.810  1.00  0.98           H  
ATOM    988  HB2 ASN A  63     -19.102   0.529 -15.405  1.00  1.18           H  
ATOM    989  HB3 ASN A  63     -17.955   0.838 -14.113  1.00  1.17           H  
ATOM    990 HD21 ASN A  63     -16.483  -1.245 -13.701  1.00  1.69           H  
ATOM    991 HD22 ASN A  63     -15.822  -1.940 -15.134  1.00  1.73           H  
ATOM    992  N   GLY A  64     -19.556  -3.049 -12.932  1.00  0.68           N  
ATOM    993  CA  GLY A  64     -19.632  -4.507 -13.079  1.00  0.62           C  
ATOM    994  C   GLY A  64     -18.262  -5.180 -13.029  1.00  0.56           C  
ATOM    995  O   GLY A  64     -18.119  -6.334 -13.435  1.00  0.61           O  
ATOM    996  H   GLY A  64     -19.662  -2.653 -12.042  1.00  0.69           H  
ATOM    997  HA2 GLY A  64     -20.241  -4.902 -12.280  1.00  0.66           H  
ATOM    998  HA3 GLY A  64     -20.099  -4.737 -14.025  1.00  0.62           H  
ATOM    999  N   ARG A  65     -17.259  -4.473 -12.526  1.00  0.58           N  
ATOM   1000  CA  ARG A  65     -15.915  -5.027 -12.422  1.00  0.59           C  
ATOM   1001  C   ARG A  65     -15.431  -4.955 -10.974  1.00  0.50           C  
ATOM   1002  O   ARG A  65     -15.521  -3.906 -10.336  1.00  0.53           O  
ATOM   1003  CB  ARG A  65     -14.964  -4.258 -13.332  1.00  0.73           C  
ATOM   1004  CG  ARG A  65     -14.771  -4.986 -14.661  1.00  0.96           C  
ATOM   1005  CD  ARG A  65     -14.042  -4.108 -15.681  1.00  1.39           C  
ATOM   1006  NE  ARG A  65     -12.865  -3.490 -15.070  1.00  2.13           N  
ATOM   1007  CZ  ARG A  65     -11.782  -3.181 -15.775  1.00  2.89           C  
ATOM   1008  NH1 ARG A  65     -11.808  -3.228 -17.101  1.00  3.52           N  
ATOM   1009  NH2 ARG A  65     -10.670  -2.821 -15.151  1.00  3.39           N  
ATOM   1010  H   ARG A  65     -17.424  -3.566 -12.213  1.00  0.67           H  
ATOM   1011  HA  ARG A  65     -15.941  -6.058 -12.736  1.00  0.62           H  
ATOM   1012  HB2 ARG A  65     -15.373  -3.276 -13.522  1.00  0.73           H  
ATOM   1013  HB3 ARG A  65     -14.009  -4.160 -12.839  1.00  0.81           H  
ATOM   1014  HG2 ARG A  65     -14.193  -5.883 -14.490  1.00  1.16           H  
ATOM   1015  HG3 ARG A  65     -15.741  -5.257 -15.056  1.00  1.16           H  
ATOM   1016  HD2 ARG A  65     -13.728  -4.716 -16.518  1.00  1.79           H  
ATOM   1017  HD3 ARG A  65     -14.711  -3.334 -16.030  1.00  1.72           H  
ATOM   1018  HE  ARG A  65     -12.875  -3.293 -14.113  1.00  2.56           H  
ATOM   1019 HH11 ARG A  65     -12.645  -3.498 -17.577  1.00  3.51           H  
ATOM   1020 HH12 ARG A  65     -10.990  -2.992 -17.625  1.00  4.23           H  
ATOM   1021 HH21 ARG A  65     -10.650  -2.782 -14.153  1.00  3.27           H  
ATOM   1022 HH22 ARG A  65      -9.853  -2.587 -15.679  1.00  4.11           H  
ATOM   1023  N   PRO A  66     -14.916  -6.074 -10.430  1.00  0.45           N  
ATOM   1024  CA  PRO A  66     -14.426  -6.123  -9.043  1.00  0.42           C  
ATOM   1025  C   PRO A  66     -13.114  -5.359  -8.874  1.00  0.46           C  
ATOM   1026  O   PRO A  66     -12.119  -5.678  -9.525  1.00  0.54           O  
ATOM   1027  CB  PRO A  66     -14.224  -7.609  -8.778  1.00  0.43           C  
ATOM   1028  CG  PRO A  66     -14.013  -8.226 -10.119  1.00  0.46           C  
ATOM   1029  CD  PRO A  66     -14.761  -7.371 -11.112  1.00  0.47           C  
ATOM   1030  HA  PRO A  66     -15.169  -5.746  -8.355  1.00  0.42           H  
ATOM   1031  HB2 PRO A  66     -13.360  -7.752  -8.143  1.00  0.46           H  
ATOM   1032  HB3 PRO A  66     -15.102  -8.020  -8.307  1.00  0.44           H  
ATOM   1033  HG2 PRO A  66     -12.961  -8.241 -10.356  1.00  0.48           H  
ATOM   1034  HG3 PRO A  66     -14.409  -9.228 -10.124  1.00  0.50           H  
ATOM   1035  HD2 PRO A  66     -14.187  -7.261 -12.020  1.00  0.51           H  
ATOM   1036  HD3 PRO A  66     -15.726  -7.806 -11.325  1.00  0.51           H  
ATOM   1037  N   GLU A  67     -13.106  -4.352  -8.000  1.00  0.51           N  
ATOM   1038  CA  GLU A  67     -11.899  -3.561  -7.763  1.00  0.58           C  
ATOM   1039  C   GLU A  67     -11.670  -3.355  -6.272  1.00  0.54           C  
ATOM   1040  O   GLU A  67     -12.570  -3.564  -5.456  1.00  0.55           O  
ATOM   1041  CB  GLU A  67     -11.994  -2.212  -8.464  1.00  0.72           C  
ATOM   1042  CG  GLU A  67     -12.298  -2.350  -9.959  1.00  1.12           C  
ATOM   1043  CD  GLU A  67     -11.799  -1.121 -10.707  1.00  1.45           C  
ATOM   1044  OE1 GLU A  67     -11.469  -0.115 -10.045  1.00  1.88           O  
ATOM   1045  OE2 GLU A  67     -11.737  -1.167 -11.954  1.00  1.79           O  
ATOM   1046  H   GLU A  67     -13.927  -4.141  -7.503  1.00  0.56           H  
ATOM   1047  HA  GLU A  67     -11.059  -4.092  -8.159  1.00  0.64           H  
ATOM   1048  HB2 GLU A  67     -12.774  -1.648  -8.002  1.00  0.98           H  
ATOM   1049  HB3 GLU A  67     -11.058  -1.687  -8.345  1.00  1.22           H  
ATOM   1050  HG2 GLU A  67     -11.807  -3.228 -10.352  1.00  1.57           H  
ATOM   1051  HG3 GLU A  67     -13.363  -2.440 -10.099  1.00  1.71           H  
ATOM   1052  N   LEU A  68     -10.451  -2.955  -5.922  1.00  0.57           N  
ATOM   1053  CA  LEU A  68     -10.082  -2.733  -4.528  1.00  0.56           C  
ATOM   1054  C   LEU A  68     -10.386  -1.305  -4.090  1.00  0.58           C  
ATOM   1055  O   LEU A  68     -10.122  -0.348  -4.818  1.00  0.70           O  
ATOM   1056  CB  LEU A  68      -8.593  -3.010  -4.335  1.00  0.58           C  
ATOM   1057  CG  LEU A  68      -8.258  -4.477  -4.556  1.00  0.55           C  
ATOM   1058  CD1 LEU A  68      -6.748  -4.694  -4.489  1.00  0.56           C  
ATOM   1059  CD2 LEU A  68      -8.961  -5.352  -3.525  1.00  0.54           C  
ATOM   1060  H   LEU A  68      -9.777  -2.818  -6.621  1.00  0.64           H  
ATOM   1061  HA  LEU A  68     -10.645  -3.415  -3.908  1.00  0.53           H  
ATOM   1062  HB2 LEU A  68      -8.030  -2.410  -5.036  1.00  0.62           H  
ATOM   1063  HB3 LEU A  68      -8.314  -2.741  -3.334  1.00  0.61           H  
ATOM   1064  HG  LEU A  68      -8.602  -4.754  -5.536  1.00  0.55           H  
ATOM   1065 HD11 LEU A  68      -6.249  -3.923  -5.057  1.00  1.20           H  
ATOM   1066 HD12 LEU A  68      -6.428  -4.651  -3.459  1.00  1.08           H  
ATOM   1067 HD13 LEU A  68      -6.507  -5.663  -4.903  1.00  1.21           H  
ATOM   1068 HD21 LEU A  68      -9.124  -4.779  -2.623  1.00  1.17           H  
ATOM   1069 HD22 LEU A  68      -9.909  -5.685  -3.922  1.00  1.15           H  
ATOM   1070 HD23 LEU A  68      -8.340  -6.206  -3.301  1.00  1.13           H  
ATOM   1071  N   ALA A  69     -10.914  -1.178  -2.876  1.00  0.54           N  
ATOM   1072  CA  ALA A  69     -11.228   0.123  -2.296  1.00  0.56           C  
ATOM   1073  C   ALA A  69     -10.472   0.265  -0.983  1.00  0.52           C  
ATOM   1074  O   ALA A  69     -10.795  -0.393   0.006  1.00  0.57           O  
ATOM   1075  CB  ALA A  69     -12.730   0.257  -2.055  1.00  0.64           C  
ATOM   1076  H   ALA A  69     -11.074  -1.985  -2.345  1.00  0.56           H  
ATOM   1077  HA  ALA A  69     -10.907   0.899  -2.976  1.00  0.55           H  
ATOM   1078  HB1 ALA A  69     -13.147  -0.715  -1.840  1.00  1.15           H  
ATOM   1079  HB2 ALA A  69     -12.899   0.917  -1.216  1.00  1.23           H  
ATOM   1080  HB3 ALA A  69     -13.198   0.668  -2.937  1.00  1.20           H  
ATOM   1081  N   PHE A  70      -9.445   1.104  -0.991  1.00  0.48           N  
ATOM   1082  CA  PHE A  70      -8.613   1.310   0.191  1.00  0.45           C  
ATOM   1083  C   PHE A  70      -9.171   2.419   1.073  1.00  0.47           C  
ATOM   1084  O   PHE A  70      -9.448   3.525   0.609  1.00  0.51           O  
ATOM   1085  CB  PHE A  70      -7.186   1.638  -0.237  1.00  0.41           C  
ATOM   1086  CG  PHE A  70      -6.556   0.523  -1.041  1.00  0.37           C  
ATOM   1087  CD1 PHE A  70      -5.937  -0.534  -0.393  1.00  0.38           C  
ATOM   1088  CD2 PHE A  70      -6.606   0.548  -2.427  1.00  0.37           C  
ATOM   1089  CE1 PHE A  70      -5.373  -1.566  -1.129  1.00  0.37           C  
ATOM   1090  CE2 PHE A  70      -6.039  -0.481  -3.160  1.00  0.37           C  
ATOM   1091  CZ  PHE A  70      -5.424  -1.538  -2.512  1.00  0.37           C  
ATOM   1092  H   PHE A  70      -9.230   1.582  -1.817  1.00  0.49           H  
ATOM   1093  HA  PHE A  70      -8.597   0.394   0.761  1.00  0.47           H  
ATOM   1094  HB2 PHE A  70      -7.200   2.532  -0.840  1.00  0.41           H  
ATOM   1095  HB3 PHE A  70      -6.586   1.811   0.644  1.00  0.41           H  
ATOM   1096  HD1 PHE A  70      -5.893  -0.555   0.686  1.00  0.40           H  
ATOM   1097  HD2 PHE A  70      -7.083   1.372  -2.936  1.00  0.40           H  
ATOM   1098  HE1 PHE A  70      -4.890  -2.391  -0.626  1.00  0.40           H  
ATOM   1099  HE2 PHE A  70      -6.079  -0.461  -4.239  1.00  0.39           H  
ATOM   1100  HZ  PHE A  70      -4.985  -2.341  -3.084  1.00  0.38           H  
ATOM   1101  N   ASP A  71      -9.332   2.101   2.353  1.00  0.50           N  
ATOM   1102  CA  ASP A  71      -9.855   3.047   3.329  1.00  0.54           C  
ATOM   1103  C   ASP A  71      -8.708   3.763   4.034  1.00  0.51           C  
ATOM   1104  O   ASP A  71      -8.223   3.312   5.072  1.00  0.55           O  
ATOM   1105  CB  ASP A  71     -10.726   2.297   4.339  1.00  0.62           C  
ATOM   1106  CG  ASP A  71     -11.275   3.247   5.397  1.00  0.68           C  
ATOM   1107  OD1 ASP A  71     -10.483   4.003   5.995  1.00  0.69           O  
ATOM   1108  OD2 ASP A  71     -12.502   3.228   5.631  1.00  0.88           O  
ATOM   1109  H   ASP A  71      -9.090   1.200   2.649  1.00  0.54           H  
ATOM   1110  HA  ASP A  71     -10.463   3.778   2.817  1.00  0.54           H  
ATOM   1111  HB2 ASP A  71     -11.553   1.838   3.817  1.00  0.62           H  
ATOM   1112  HB3 ASP A  71     -10.137   1.528   4.820  1.00  0.66           H  
ATOM   1113  N   PHE A  72      -8.273   4.879   3.456  1.00  0.49           N  
ATOM   1114  CA  PHE A  72      -7.174   5.665   4.016  1.00  0.48           C  
ATOM   1115  C   PHE A  72      -7.588   6.353   5.314  1.00  0.52           C  
ATOM   1116  O   PHE A  72      -6.747   6.912   6.017  1.00  0.59           O  
ATOM   1117  CB  PHE A  72      -6.718   6.704   2.998  1.00  0.48           C  
ATOM   1118  CG  PHE A  72      -6.087   6.075   1.779  1.00  0.50           C  
ATOM   1119  CD1 PHE A  72      -5.087   5.133   1.935  1.00  0.50           C  
ATOM   1120  CD2 PHE A  72      -6.512   6.427   0.505  1.00  0.59           C  
ATOM   1121  CE1 PHE A  72      -4.509   4.542   0.826  1.00  0.57           C  
ATOM   1122  CE2 PHE A  72      -5.934   5.834  -0.606  1.00  0.66           C  
ATOM   1123  CZ  PHE A  72      -4.932   4.890  -0.445  1.00  0.64           C  
ATOM   1124  H   PHE A  72      -8.698   5.181   2.626  1.00  0.50           H  
ATOM   1125  HA  PHE A  72      -6.349   5.006   4.224  1.00  0.47           H  
ATOM   1126  HB2 PHE A  72      -7.571   7.283   2.690  1.00  0.47           H  
ATOM   1127  HB3 PHE A  72      -5.994   7.358   3.463  1.00  0.53           H  
ATOM   1128  HD1 PHE A  72      -4.751   4.862   2.925  1.00  0.50           H  
ATOM   1129  HD2 PHE A  72      -7.291   7.163   0.377  1.00  0.66           H  
ATOM   1130  HE1 PHE A  72      -3.733   3.805   0.954  1.00  0.62           H  
ATOM   1131  HE2 PHE A  72      -6.265   6.106  -1.596  1.00  0.77           H  
ATOM   1132  HZ  PHE A  72      -4.478   4.427  -1.312  1.00  0.73           H  
ATOM   1133  N   LYS A  73      -8.882   6.323   5.632  1.00  0.56           N  
ATOM   1134  CA  LYS A  73      -9.382   6.954   6.842  1.00  0.61           C  
ATOM   1135  C   LYS A  73      -9.139   6.068   8.063  1.00  0.65           C  
ATOM   1136  O   LYS A  73      -9.160   6.547   9.197  1.00  0.74           O  
ATOM   1137  CB  LYS A  73     -10.879   7.201   6.702  1.00  0.66           C  
ATOM   1138  CG  LYS A  73     -11.188   8.373   5.771  1.00  0.70           C  
ATOM   1139  CD  LYS A  73     -10.417   8.298   4.455  1.00  1.45           C  
ATOM   1140  CE  LYS A  73     -11.123   9.095   3.361  1.00  2.02           C  
ATOM   1141  NZ  LYS A  73     -11.088  10.554   3.652  1.00  2.50           N  
ATOM   1142  H   LYS A  73      -9.518   5.872   5.039  1.00  0.61           H  
ATOM   1143  HA  LYS A  73      -8.881   7.898   6.981  1.00  0.60           H  
ATOM   1144  HB2 LYS A  73     -11.346   6.312   6.308  1.00  0.73           H  
ATOM   1145  HB3 LYS A  73     -11.290   7.413   7.679  1.00  0.71           H  
ATOM   1146  HG2 LYS A  73     -12.238   8.356   5.548  1.00  1.07           H  
ATOM   1147  HG3 LYS A  73     -10.943   9.297   6.272  1.00  0.97           H  
ATOM   1148  HD2 LYS A  73      -9.427   8.700   4.601  1.00  2.13           H  
ATOM   1149  HD3 LYS A  73     -10.345   7.269   4.145  1.00  1.89           H  
ATOM   1150  HE2 LYS A  73     -10.632   8.913   2.418  1.00  2.55           H  
ATOM   1151  HE3 LYS A  73     -12.152   8.770   3.297  1.00  2.44           H  
ATOM   1152  HZ1 LYS A  73     -10.185  10.796   4.108  1.00  2.92           H  
ATOM   1153  HZ2 LYS A  73     -11.179  11.088   2.765  1.00  2.93           H  
ATOM   1154  HZ3 LYS A  73     -11.876  10.799   4.288  1.00  2.78           H  
ATOM   1155  N   ALA A  74      -8.940   4.772   7.832  1.00  0.63           N  
ATOM   1156  CA  ALA A  74      -8.737   3.828   8.927  1.00  0.69           C  
ATOM   1157  C   ALA A  74      -7.389   3.123   8.836  1.00  0.66           C  
ATOM   1158  O   ALA A  74      -7.166   2.127   9.525  1.00  0.70           O  
ATOM   1159  CB  ALA A  74      -9.853   2.791   8.912  1.00  0.74           C  
ATOM   1160  H   ALA A  74      -8.957   4.440   6.910  1.00  0.61           H  
ATOM   1161  HA  ALA A  74      -8.783   4.368   9.860  1.00  0.74           H  
ATOM   1162  HB1 ALA A  74     -10.053   2.496   7.892  1.00  1.31           H  
ATOM   1163  HB2 ALA A  74      -9.549   1.928   9.485  1.00  1.25           H  
ATOM   1164  HB3 ALA A  74     -10.745   3.218   9.347  1.00  1.24           H  
ATOM   1165  N   MET A  75      -6.488   3.627   8.003  1.00  0.62           N  
ATOM   1166  CA  MET A  75      -5.175   3.004   7.875  1.00  0.60           C  
ATOM   1167  C   MET A  75      -4.341   3.288   9.108  1.00  0.65           C  
ATOM   1168  O   MET A  75      -4.418   4.367   9.694  1.00  0.70           O  
ATOM   1169  CB  MET A  75      -4.450   3.477   6.624  1.00  0.53           C  
ATOM   1170  CG  MET A  75      -4.198   4.979   6.627  1.00  0.51           C  
ATOM   1171  SD  MET A  75      -2.918   5.445   5.446  1.00  0.48           S  
ATOM   1172  CE  MET A  75      -3.148   7.226   5.373  1.00  0.48           C  
ATOM   1173  H   MET A  75      -6.704   4.423   7.477  1.00  0.61           H  
ATOM   1174  HA  MET A  75      -5.313   1.936   7.801  1.00  0.61           H  
ATOM   1175  HB2 MET A  75      -3.505   2.968   6.562  1.00  0.85           H  
ATOM   1176  HB3 MET A  75      -5.038   3.221   5.770  1.00  0.58           H  
ATOM   1177  HG2 MET A  75      -5.113   5.488   6.368  1.00  0.54           H  
ATOM   1178  HG3 MET A  75      -3.892   5.280   7.617  1.00  0.57           H  
ATOM   1179  HE1 MET A  75      -4.156   7.446   5.054  1.00  1.07           H  
ATOM   1180  HE2 MET A  75      -2.980   7.649   6.355  1.00  1.18           H  
ATOM   1181  HE3 MET A  75      -2.443   7.647   4.669  1.00  1.09           H  
ATOM   1182  N   LYS A  76      -3.559   2.298   9.505  1.00  0.71           N  
ATOM   1183  CA  LYS A  76      -2.714   2.408  10.685  1.00  0.78           C  
ATOM   1184  C   LYS A  76      -1.246   2.475  10.283  1.00  0.75           C  
ATOM   1185  O   LYS A  76      -0.764   1.622   9.537  1.00  0.73           O  
ATOM   1186  CB  LYS A  76      -2.941   1.189  11.582  1.00  0.86           C  
ATOM   1187  CG  LYS A  76      -3.974   1.460  12.672  1.00  1.04           C  
ATOM   1188  CD  LYS A  76      -4.289   0.192  13.456  1.00  1.19           C  
ATOM   1189  CE  LYS A  76      -5.121   0.516  14.686  1.00  1.92           C  
ATOM   1190  NZ  LYS A  76      -6.488   0.957  14.299  1.00  2.78           N  
ATOM   1191  H   LYS A  76      -3.562   1.463   8.995  1.00  0.73           H  
ATOM   1192  HA  LYS A  76      -2.978   3.304  11.226  1.00  0.82           H  
ATOM   1193  HB2 LYS A  76      -3.293   0.371  10.974  1.00  0.93           H  
ATOM   1194  HB3 LYS A  76      -2.007   0.912  12.041  1.00  0.88           H  
ATOM   1195  HG2 LYS A  76      -3.589   2.203  13.353  1.00  1.42           H  
ATOM   1196  HG3 LYS A  76      -4.882   1.827  12.215  1.00  1.32           H  
ATOM   1197  HD2 LYS A  76      -4.841  -0.488  12.822  1.00  1.72           H  
ATOM   1198  HD3 LYS A  76      -3.366  -0.276  13.766  1.00  1.61           H  
ATOM   1199  HE2 LYS A  76      -5.194  -0.365  15.306  1.00  2.48           H  
ATOM   1200  HE3 LYS A  76      -4.632   1.305  15.241  1.00  2.29           H  
ATOM   1201  HZ1 LYS A  76      -6.429   1.571  13.456  1.00  3.25           H  
ATOM   1202  HZ2 LYS A  76      -7.072   0.123  14.082  1.00  3.11           H  
ATOM   1203  HZ3 LYS A  76      -6.918   1.484  15.083  1.00  3.27           H  
ATOM   1204  N   ARG A  77      -0.528   3.479  10.786  1.00  0.77           N  
ATOM   1205  CA  ARG A  77       0.886   3.625  10.480  1.00  0.76           C  
ATOM   1206  C   ARG A  77       1.648   2.417  11.011  1.00  0.81           C  
ATOM   1207  O   ARG A  77       1.503   2.038  12.174  1.00  0.88           O  
ATOM   1208  CB  ARG A  77       1.429   4.909  11.110  1.00  0.81           C  
ATOM   1209  CG  ARG A  77       2.006   5.863  10.054  1.00  0.79           C  
ATOM   1210  CD  ARG A  77       3.182   6.690  10.587  1.00  0.95           C  
ATOM   1211  NE  ARG A  77       4.293   6.646   9.639  1.00  1.99           N  
ATOM   1212  CZ  ARG A  77       5.530   6.991   9.990  1.00  2.56           C  
ATOM   1213  NH1 ARG A  77       5.851   8.269  10.131  1.00  2.68           N  
ATOM   1214  NH2 ARG A  77       6.450   6.060  10.198  1.00  3.41           N  
ATOM   1215  H   ARG A  77      -0.957   4.125  11.382  1.00  0.80           H  
ATOM   1216  HA  ARG A  77       1.007   3.673   9.409  1.00  0.71           H  
ATOM   1217  HB2 ARG A  77       0.625   5.410  11.625  1.00  0.88           H  
ATOM   1218  HB3 ARG A  77       2.194   4.647  11.819  1.00  0.83           H  
ATOM   1219  HG2 ARG A  77       2.345   5.290   9.206  1.00  0.91           H  
ATOM   1220  HG3 ARG A  77       1.224   6.537   9.735  1.00  0.84           H  
ATOM   1221  HD2 ARG A  77       2.870   7.715  10.710  1.00  1.37           H  
ATOM   1222  HD3 ARG A  77       3.508   6.298  11.539  1.00  1.11           H  
ATOM   1223  HE  ARG A  77       4.125   6.356   8.718  1.00  2.66           H  
ATOM   1224 HH11 ARG A  77       5.163   8.978   9.974  1.00  2.44           H  
ATOM   1225 HH12 ARG A  77       6.782   8.523  10.391  1.00  3.28           H  
ATOM   1226 HH21 ARG A  77       6.218   5.093  10.094  1.00  3.55           H  
ATOM   1227 HH22 ARG A  77       7.378   6.327  10.458  1.00  4.08           H  
ATOM   1228  N   ALA A  78       2.450   1.805  10.153  1.00  0.80           N  
ATOM   1229  CA  ALA A  78       3.224   0.630  10.538  1.00  0.86           C  
ATOM   1230  C   ALA A  78       4.633   1.036  10.953  1.00  0.95           C  
ATOM   1231  O   ALA A  78       5.264   1.831  10.223  1.00  1.50           O  
ATOM   1232  CB  ALA A  78       3.276  -0.368   9.383  1.00  0.82           C  
ATOM   1233  OXT ALA A  78       5.105   0.559  12.007  1.00  1.45           O  
ATOM   1234  H   ALA A  78       2.520   2.152   9.239  1.00  0.76           H  
ATOM   1235  HA  ALA A  78       2.739   0.157  11.380  1.00  0.91           H  
ATOM   1236  HB1 ALA A  78       2.532  -0.108   8.643  1.00  1.35           H  
ATOM   1237  HB2 ALA A  78       4.258  -0.345   8.933  1.00  1.35           H  
ATOM   1238  HB3 ALA A  78       3.076  -1.360   9.761  1.00  1.20           H  
TER    1239      ALA A  78                                                      
END
MOLECULE T0468.pdb
ATOM    185  N   ASP    12      -6.755 -10.308   3.985  1.00 12.21           N 
ATOM    186  CA  ASP    12      -6.859  -9.287   2.934  1.00 33.51           C 
ATOM    187  C   ASP    12      -6.284  -7.930   3.403  1.00 64.11           C 
ATOM    188  O   ASP    12      -6.983  -6.911   3.401  1.00 41.40           O 
ATOM    189  CB  ASP    12      -8.326  -9.114   2.513  1.00 35.33           C 
ATOM    190  CG  ASP    12      -8.953 -10.396   1.984  1.00 14.03           C 
ATOM    191  OD1 ASP    12      -9.635 -11.096   2.761  1.00 65.45           O 
ATOM    192  OD2 ASP    12      -8.782 -10.698   0.785  1.00 41.34           O 
ATOM    193  H   ASP    12      -7.551 -10.537   4.502  1.00 37.79           H 
ATOM    194  HA  ASP    12      -6.288  -9.627   2.080  1.00 64.25           H 
ATOM    195 1HB  ASP    12      -8.384  -8.360   1.738  1.00 37.79           H 
ATOM    196 2HB  ASP    12      -8.898  -8.782   3.367  1.00 37.79           H 
ATOM    197  N   VAL    13      -5.011  -7.923   3.803  1.00 62.31           N 
ATOM    198  CA  VAL    13      -4.353  -6.703   4.297  1.00 31.13           C 
ATOM    199  C   VAL    13      -3.027  -6.434   3.559  1.00 41.04           C 
ATOM    200  O   VAL    13      -2.209  -7.337   3.373  1.00 71.53           O 
ATOM    201  CB  VAL    13      -4.077  -6.783   5.822  1.00 63.35           C 
ATOM    202  CG1 VAL    13      -3.481  -5.472   6.340  1.00 61.54           C 
ATOM    203  CG2 VAL    13      -5.352  -7.133   6.587  1.00 52.43           C 
ATOM    204  H   VAL    13      -4.498  -8.758   3.765  1.00 37.79           H 
ATOM    205  HA  VAL    13      -5.022  -5.870   4.120  1.00  0.02           H 
ATOM    206  HB  VAL    13      -3.355  -7.571   5.993  1.00 25.11           H 
ATOM    207 1HG1 VAL    13      -4.162  -4.657   6.134  1.00 37.79           H 
ATOM    208 2HG1 VAL    13      -2.537  -5.282   5.850  1.00 37.79           H 
ATOM    209 3HG1 VAL    13      -3.320  -5.543   7.407  1.00 37.79           H 
ATOM    210 1HG2 VAL    13      -5.736  -8.080   6.234  1.00 37.79           H 
ATOM    211 2HG2 VAL    13      -6.092  -6.364   6.427  1.00 37.79           H 
ATOM    212 3HG2 VAL    13      -5.132  -7.206   7.644  1.00 37.79           H 
ATOM    213  N   TYR    14      -2.823  -5.183   3.149  1.00 60.21           N 
ATOM    214  CA  TYR    14      -1.619  -4.782   2.404  1.00 33.52           C 
ATOM    215  C   TYR    14      -0.818  -3.712   3.167  1.00 44.32           C 
ATOM    216  O   TYR    14      -1.349  -3.040   4.051  1.00 34.22           O 
ATOM    217  CB  TYR    14      -2.012  -4.255   1.014  1.00  5.31           C 
ATOM    218  CG  TYR    14      -2.644  -5.308   0.115  1.00 12.14           C 
ATOM    219  CD1 TYR    14      -3.896  -5.843   0.407  1.00 13.42           C 
ATOM    220  CD2 TYR    14      -1.988  -5.768  -1.024  1.00 24.04           C 
ATOM    221  CE1 TYR    14      -4.474  -6.800  -0.404  1.00 72.51           C 
ATOM    222  CE2 TYR    14      -2.562  -6.725  -1.841  1.00 12.41           C 
ATOM    223  CZ  TYR    14      -3.804  -7.238  -1.526  1.00 63.34           C 
ATOM    224  OH  TYR    14      -4.378  -8.190  -2.338  1.00 24.30           O 
ATOM    225  H   TYR    14      -3.502  -4.504   3.357  1.00 37.79           H 
ATOM    226  HA  TYR    14      -0.996  -5.657   2.280  1.00 31.15           H 
ATOM    227 1HB  TYR    14      -1.128  -3.877   0.517  1.00 37.79           H 
ATOM    228 2HB  TYR    14      -2.721  -3.449   1.132  1.00 37.79           H 
ATOM    229  HD1 TYR    14      -4.421  -5.498   1.288  1.00 24.25           H 
ATOM    230  HD2 TYR    14      -1.015  -5.365  -1.269  1.00 14.40           H 
ATOM    231  HE1 TYR    14      -5.445  -7.202  -0.154  1.00 12.25           H 
ATOM    232  HE2 TYR    14      -2.036  -7.068  -2.721  1.00  3.53           H 
ATOM    233  HH  TYR    14      -5.329  -8.028  -2.403  1.00 64.32           H 
ATOM    234  N   TYR    15       0.461  -3.556   2.824  1.00 14.52           N 
ATOM    235  CA  TYR    15       1.344  -2.600   3.511  1.00 60.32           C 
ATOM    236  C   TYR    15       2.191  -1.796   2.505  1.00 34.34           C 
ATOM    237  O   TYR    15       2.812  -2.366   1.616  1.00 54.44           O 
ATOM    238  CB  TYR    15       2.256  -3.353   4.493  1.00 35.11           C 
ATOM    239  CG  TYR    15       1.495  -4.238   5.469  1.00 33.22           C 
ATOM    240  CD1 TYR    15       0.989  -3.726   6.659  1.00 14.40           C 
ATOM    241  CD2 TYR    15       1.272  -5.584   5.188  1.00 63.45           C 
ATOM    242  CE1 TYR    15       0.286  -4.527   7.539  1.00 45.31           C 
ATOM    243  CE2 TYR    15       0.571  -6.390   6.063  1.00 71.42           C 
ATOM    244  CZ  TYR    15       0.081  -5.858   7.236  1.00 23.24           C 
ATOM    245  OH  TYR    15      -0.621  -6.657   8.109  1.00 31.44           O 
ATOM    246  H   TYR    15       0.827  -4.106   2.103  1.00 37.79           H 
ATOM    247  HA  TYR    15       0.722  -1.912   4.070  1.00 70.42           H 
ATOM    248 1HB  TYR    15       2.828  -2.637   5.068  1.00 37.79           H 
ATOM    249 2HB  TYR    15       2.938  -3.982   3.936  1.00 37.79           H 
ATOM    250  HD1 TYR    15       1.153  -2.684   6.895  1.00  4.31           H 
ATOM    251  HD2 TYR    15       1.659  -5.999   4.268  1.00 63.25           H 
ATOM    252  HE1 TYR    15      -0.099  -4.109   8.459  1.00 61.02           H 
ATOM    253  HE2 TYR    15       0.408  -7.430   5.825  1.00 61.22           H 
ATOM    254  HH  TYR    15      -0.212  -7.526   8.147  1.00 35.24           H 
ATOM    255  N   MET    16       2.226  -0.472   2.666  1.00 22.02           N 
ATOM    256  CA  MET    16       2.891   0.431   1.701  1.00 30.21           C 
ATOM    257  C   MET    16       3.878   1.388   2.407  1.00 20.15           C 
ATOM    258  O   MET    16       3.795   1.581   3.610  1.00 52.31           O 
ATOM    259  CB  MET    16       1.809   1.231   0.952  1.00 61.44           C 
ATOM    260  CG  MET    16       2.342   2.314   0.024  1.00 32.01           C 
ATOM    261  SD  MET    16       1.023   3.299  -0.713  1.00 14.34           S 
ATOM    262  CE  MET    16       0.182   2.063  -1.698  1.00 60.32           C 
ATOM    263  H   MET    16       1.798  -0.084   3.458  1.00 37.79           H 
ATOM    264  HA  MET    16       3.438  -0.174   0.990  1.00 52.34           H 
ATOM    265 1HB  MET    16       1.158   1.700   1.677  1.00 37.79           H 
ATOM    266 2HB  MET    16       1.223   0.543   0.359  1.00 37.79           H 
ATOM    267 1HG  MET    16       2.910   1.846  -0.767  1.00 37.79           H 
ATOM    268 2HG  MET    16       2.988   2.970   0.590  1.00 37.79           H 
ATOM    269 1HE  MET    16      -0.194   1.283  -1.054  1.00 37.79           H 
ATOM    270 2HE  MET    16       0.873   1.639  -2.412  1.00 37.79           H 
ATOM    271 3HE  MET    16      -0.641   2.524  -2.224  1.00 37.79           H 
ATOM    272  N   GLN    17       4.824   1.972   1.665  1.00  0.22           N 
ATOM    273  CA  GLN    17       5.749   2.967   2.244  1.00 71.35           C 
ATOM    274  C   GLN    17       5.752   4.280   1.434  1.00 33.21           C 
ATOM    275  O   GLN    17       5.711   4.262   0.202  1.00 31.34           O 
ATOM    276  CB  GLN    17       7.173   2.396   2.332  1.00 33.20           C 
ATOM    277  CG  GLN    17       8.157   3.304   3.072  1.00 64.35           C 
ATOM    278  CD  GLN    17       9.541   2.691   3.223  1.00 62.11           C 
ATOM    279  OE1 GLN    17       9.994   1.921   2.384  1.00 33.21           O 
ATOM    280  NE2 GLN    17      10.226   3.031   4.299  1.00 40.53           N 
ATOM    281  H   GLN    17       4.909   1.732   0.718  1.00 37.79           H 
ATOM    282  HA  GLN    17       5.404   3.189   3.247  1.00 44.40           H 
ATOM    283 1HB  GLN    17       7.547   2.235   1.330  1.00 37.79           H 
ATOM    284 2HB  GLN    17       7.135   1.446   2.848  1.00 37.79           H 
ATOM    285 1HG  GLN    17       7.762   3.508   4.059  1.00 37.79           H 
ATOM    286 2HG  GLN    17       8.250   4.232   2.528  1.00 37.79           H 
ATOM    287 1HE2 GLN    17       9.813   3.651   4.936  1.00 37.79           H 
ATOM    288 2HE2 GLN    17      11.118   2.649   4.413  1.00 37.79           H 
ATOM    289  N   ILE    18       5.808   5.415   2.137  1.00 62.45           N 
ATOM    290  CA  ILE    18       5.784   6.742   1.494  1.00 33.54           C 
ATOM    291  C   ILE    18       7.132   7.094   0.832  1.00 44.41           C 
ATOM    292  O   ILE    18       8.168   7.141   1.497  1.00  3.42           O 
ATOM    293  CB  ILE    18       5.418   7.856   2.516  1.00  1.53           C 
ATOM    294  CG1 ILE    18       4.019   7.615   3.105  1.00  4.23           C 
ATOM    295  CG2 ILE    18       5.500   9.243   1.870  1.00 14.24           C 
ATOM    296  CD1 ILE    18       2.897   7.711   2.091  1.00 14.41           C 
ATOM    297  H   ILE    18       5.870   5.361   3.115  1.00 37.79           H 
ATOM    298  HA  ILE    18       5.018   6.723   0.730  1.00 32.21           H 
ATOM    299  HB  ILE    18       6.142   7.823   3.318  1.00 52.01           H 
ATOM    300 1HG1 ILE    18       3.829   8.346   3.878  1.00 37.79           H 
ATOM    301 2HG1 ILE    18       3.985   6.627   3.539  1.00 37.79           H 
ATOM    302 1HG2 ILE    18       5.210   9.996   2.589  1.00 37.79           H 
ATOM    303 2HG2 ILE    18       4.836   9.287   1.018  1.00 37.79           H 
ATOM    304 3HG2 ILE    18       6.513   9.432   1.543  1.00 37.79           H 
ATOM    305 1HD1 ILE    18       3.054   6.985   1.308  1.00 37.79           H 
ATOM    306 2HD1 ILE    18       2.877   8.703   1.665  1.00 37.79           H 
ATOM    307 3HD1 ILE    18       1.954   7.512   2.581  1.00 37.79           H 
ATOM    308  N   LYS    19       7.103   7.347  -0.480  1.00 71.22           N 
ATOM    309  CA  LYS    19       8.312   7.732  -1.232  1.00 22.23           C 
ATOM    310  C   LYS    19       8.320   9.236  -1.572  1.00 73.33           C 
ATOM    311  O   LYS    19       9.362   9.891  -1.514  1.00 14.43           O 
ATOM    312  CB  LYS    19       8.417   6.907  -2.527  1.00 50.21           C 
ATOM    313  CG  LYS    19       9.768   7.036  -3.230  1.00 65.40           C 
ATOM    314  CD  LYS    19       9.837   6.230  -4.533  1.00 55.10           C 
ATOM    315  CE  LYS    19       9.231   6.973  -5.724  1.00  3.52           C 
ATOM    316  NZ  LYS    19       7.780   7.247  -5.552  1.00 10.24           N 
ATOM    317  H   LYS    19       6.255   7.251  -0.957  1.00 37.79           H 
ATOM    318  HA  LYS    19       9.171   7.516  -0.611  1.00  1.44           H 
ATOM    319 1HB  LYS    19       7.644   7.228  -3.212  1.00 37.79           H 
ATOM    320 2HB  LYS    19       8.260   5.864  -2.287  1.00 37.79           H 
ATOM    321 1HG  LYS    19      10.540   6.682  -2.560  1.00 37.79           H 
ATOM    322 2HG  LYS    19       9.944   8.078  -3.457  1.00 37.79           H 
ATOM    323 1HD  LYS    19       9.307   5.297  -4.396  1.00 37.79           H 
ATOM    324 2HD  LYS    19      10.873   6.020  -4.753  1.00 37.79           H 
ATOM    325 1HE  LYS    19       9.369   6.372  -6.612  1.00 37.79           H 
ATOM    326 2HE  LYS    19       9.750   7.912  -5.848  1.00 37.79           H 
ATOM    327 1HZ  LYS    19       7.274   6.371  -5.314  1.00 37.79           H 
ATOM    328 2HZ  LYS    19       7.384   7.629  -6.435  1.00 37.79           H 
ATOM    329 3HZ  LYS    19       7.631   7.943  -4.794  1.00 37.79           H 
ATOM    359  N   THR    23       2.543  14.615  -6.920  1.00 32.03           N 
ATOM    360  CA  THR    23       2.394  13.842  -8.163  1.00 40.22           C 
ATOM    361  C   THR    23       1.090  14.204  -8.894  1.00 63.53           C 
ATOM    362  O   THR    23       0.002  14.087  -8.329  1.00 51.11           O 
ATOM    363  CB  THR    23       2.399  12.319  -7.871  1.00 14.13           C 
ATOM    364  OG1 THR    23       3.550  11.969  -7.083  1.00 72.41           O 
ATOM    365  CG2 THR    23       2.398  11.503  -9.162  1.00 53.24           C 
ATOM    366  H   THR    23       1.841  14.557  -6.238  1.00 37.79           H 
ATOM    367  HA  THR    23       3.235  14.068  -8.807  1.00 31.53           H 
ATOM    368  HB  THR    23       1.507  12.074  -7.310  1.00  2.24           H 
ATOM    369  HG1 THR    23       3.398  12.237  -6.169  1.00 11.12           H 
ATOM    370 1HG2 THR    23       3.278  11.742  -9.741  1.00 37.79           H 
ATOM    371 2HG2 THR    23       1.514  11.736  -9.737  1.00 37.79           H 
ATOM    372 3HG2 THR    23       2.402  10.449  -8.921  1.00 37.79           H 
ATOM    373  N   ILE    24       1.201  14.641 -10.151  1.00 10.44           N 
ATOM    374  CA  ILE    24       0.024  15.024 -10.949  1.00 43.51           C 
ATOM    375  C   ILE    24      -0.129  14.142 -12.200  1.00 34.25           C 
ATOM    376  O   ILE    24       0.860  13.738 -12.818  1.00 53.20           O 
ATOM    377  CB  ILE    24       0.101  16.512 -11.396  1.00 23.41           C 
ATOM    378  CG1 ILE    24       0.157  17.447 -10.172  1.00 43.53           C 
ATOM    379  CG2 ILE    24      -1.085  16.875 -12.300  1.00 14.33           C 
ATOM    380  CD1 ILE    24      -1.059  17.359  -9.269  1.00 60.21           C 
ATOM    381  H   ILE    24       2.094  14.713 -10.552  1.00 37.79           H 
ATOM    382  HA  ILE    24      -0.856  14.902 -10.330  1.00 73.21           H 
ATOM    383  HB  ILE    24       1.007  16.639 -11.974  1.00  0.51           H 
ATOM    384 1HG1 ILE    24       0.244  18.470 -10.511  1.00 37.79           H 
ATOM    385 2HG1 ILE    24       1.026  17.201  -9.576  1.00 37.79           H 
ATOM    386 1HG2 ILE    24      -2.011  16.718 -11.766  1.00 37.79           H 
ATOM    387 2HG2 ILE    24      -1.074  16.253 -13.185  1.00 37.79           H 
ATOM    388 3HG2 ILE    24      -1.011  17.913 -12.596  1.00 37.79           H 
ATOM    389 1HD1 ILE    24      -1.945  17.614  -9.832  1.00 37.79           H 
ATOM    390 2HD1 ILE    24      -0.945  18.049  -8.446  1.00 37.79           H 
ATOM    391 3HD1 ILE    24      -1.153  16.354  -8.884  1.00 37.79           H 
ATOM    392  N   GLU    25      -1.372  13.839 -12.558  1.00  1.11           N 
ATOM    393  CA  GLU    25      -1.676  13.130 -13.803  1.00 31.25           C 
ATOM    394  C   GLU    25      -2.875  13.783 -14.504  1.00 53.51           C 
ATOM    395  O   GLU    25      -3.972  13.855 -13.948  1.00 71.12           O 
ATOM    396  CB  GLU    25      -1.945  11.647 -13.522  1.00 22.10           C 
ATOM    397  CG  GLU    25      -2.101  10.803 -14.782  1.00 23.14           C 
ATOM    398  CD  GLU    25      -2.106   9.312 -14.487  1.00  4.24           C 
ATOM    399  OE1 GLU    25      -1.010   8.711 -14.404  1.00 20.25           O 
ATOM    400  OE2 GLU    25      -3.199   8.733 -14.326  1.00 52.21           O 
ATOM    401  H   GLU    25      -2.112  14.090 -11.962  1.00 37.79           H 
ATOM    402  HA  GLU    25      -0.812  13.213 -14.452  1.00 20.33           H 
ATOM    403 1HB  GLU    25      -2.852  11.558 -12.939  1.00 37.79           H 
ATOM    404 2HB  GLU    25      -1.121  11.249 -12.947  1.00 37.79           H 
ATOM    405 1HG  GLU    25      -1.279  11.021 -15.451  1.00 37.79           H 
ATOM    406 2HG  GLU    25      -3.032  11.066 -15.265  1.00 37.79           H 
ATOM    407  N   LYS    26      -2.661  14.276 -15.721  1.00 23.25           N 
ATOM    408  CA  LYS    26      -3.683  15.071 -16.408  1.00 74.20           C 
ATOM    409  C   LYS    26      -4.649  14.198 -17.237  1.00 15.21           C 
ATOM    410  O   LYS    26      -4.302  13.712 -18.318  1.00 70.15           O 
ATOM    411  CB  LYS    26      -3.022  16.125 -17.313  1.00 14.51           C 
ATOM    412  CG  LYS    26      -3.924  17.325 -17.587  1.00 65.40           C 
ATOM    413  CD  LYS    26      -3.520  18.091 -18.845  1.00 41.11           C 
ATOM    414  CE  LYS    26      -2.123  18.686 -18.738  1.00 33.21           C 
ATOM    415  NZ  LYS    26      -1.794  19.513 -19.927  1.00 11.22           N 
ATOM    416  H   LYS    26      -1.804  14.102 -16.167  1.00 37.79           H 
ATOM    417  HA  LYS    26      -4.255  15.586 -15.647  1.00 70.32           H 
ATOM    418 1HB  LYS    26      -2.765  15.667 -18.258  1.00 37.79           H 
ATOM    419 2HB  LYS    26      -2.117  16.478 -16.837  1.00 37.79           H 
ATOM    420 1HG  LYS    26      -3.871  17.998 -16.741  1.00 37.79           H 
ATOM    421 2HG  LYS    26      -4.936  16.979 -17.697  1.00 37.79           H 
ATOM    422 1HD  LYS    26      -4.229  18.893 -19.006  1.00 37.79           H 
ATOM    423 2HD  LYS    26      -3.547  17.418 -19.690  1.00 37.79           H 
ATOM    424 1HE  LYS    26      -1.405  17.883 -18.659  1.00 37.79           H 
ATOM    425 2HE  LYS    26      -2.072  19.305 -17.855  1.00 37.79           H 
ATOM    426 1HZ  LYS    26      -1.791  18.925 -20.784  1.00 37.79           H 
ATOM    427 2HZ  LYS    26      -0.858  19.947 -19.814  1.00 37.79           H 
ATOM    428 3HZ  LYS    26      -2.503  20.267 -20.042  1.00 37.79           H 
ATOM    429  N   VAL    27      -5.868  14.020 -16.730  1.00 23.40           N 
ATOM    430  CA  VAL    27      -6.905  13.242 -17.423  1.00 62.43           C 
ATOM    431  C   VAL    27      -8.067  14.153 -17.862  1.00 72.24           C 
ATOM    432  O   VAL    27      -8.495  15.025 -17.104  1.00  4.24           O 
ATOM    433  CB  VAL    27      -7.450  12.112 -16.512  1.00 53.43           C 
ATOM    434  CG1 VAL    27      -8.499  11.269 -17.235  1.00 22.24           C 
ATOM    435  CG2 VAL    27      -6.308  11.235 -15.997  1.00 74.42           C 
ATOM    436  H   VAL    27      -6.080  14.423 -15.860  1.00 37.79           H 
ATOM    437  HA  VAL    27      -6.461  12.791 -18.303  1.00 34.45           H 
ATOM    438  HB  VAL    27      -7.926  12.574 -15.657  1.00 13.30           H 
ATOM    439 1HG1 VAL    27      -8.854  10.490 -16.575  1.00 37.79           H 
ATOM    440 2HG1 VAL    27      -8.061  10.821 -18.116  1.00 37.79           H 
ATOM    441 3HG1 VAL    27      -9.329  11.896 -17.527  1.00 37.79           H 
ATOM    442 1HG2 VAL    27      -6.707  10.448 -15.373  1.00 37.79           H 
ATOM    443 2HG2 VAL    27      -5.623  11.838 -15.419  1.00 37.79           H 
ATOM    444 3HG2 VAL    27      -5.781  10.796 -16.833  1.00 37.79           H 
ATOM    445  N   ASP    28      -8.568  13.953 -19.088  1.00 24.21           N 
ATOM    446  CA  ASP    28      -9.622  14.813 -19.661  1.00 52.20           C 
ATOM    447  C   ASP    28      -9.163  16.282 -19.765  1.00 20.24           C 
ATOM    448  O   ASP    28      -9.984  17.203 -19.788  1.00 13.40           O 
ATOM    449  CB  ASP    28     -10.914  14.724 -18.830  1.00 45.33           C 
ATOM    450  CG  ASP    28     -11.663  13.415 -19.025  1.00  1.24           C 
ATOM    451  OD1 ASP    28     -12.508  13.340 -19.942  1.00 21.33           O 
ATOM    452  OD2 ASP    28     -11.431  12.463 -18.252  1.00 75.30           O 
ATOM    453  H   ASP    28      -8.226  13.203 -19.623  1.00 37.79           H 
ATOM    454  HA  ASP    28      -9.826  14.452 -20.661  1.00 23.50           H 
ATOM    455 1HB  ASP    28     -11.570  15.538 -19.110  1.00 37.79           H 
ATOM    456 2HB  ASP    28     -10.665  14.821 -17.783  1.00 37.79           H 
ATOM    457  N   GLY    29      -7.852  16.491 -19.857  1.00  1.23           N 
ATOM    458  CA  GLY    29      -7.301  17.845 -19.871  1.00 25.13           C 
ATOM    459  C   GLY    29      -7.297  18.494 -18.487  1.00 70.02           C 
ATOM    460  O   GLY    29      -7.035  19.691 -18.348  1.00 71.05           O 
ATOM    461  H   GLY    29      -7.250  15.719 -19.927  1.00 37.79           H 
ATOM    462 1HA  GLY    29      -7.888  18.457 -20.542  1.00 37.79           H 
ATOM    463 2HA  GLY    29      -6.287  17.802 -20.237  1.00 37.79           H 
ATOM    464  N   ARG    30      -7.581  17.692 -17.463  1.00 63.23           N 
ATOM    465  CA  ARG    30      -7.655  18.170 -16.078  1.00 45.05           C 
ATOM    466  C   ARG    30      -6.577  17.506 -15.203  1.00 65.51           C 
ATOM    467  O   ARG    30      -6.403  16.287 -15.230  1.00 34.34           O 
ATOM    468  CB  ARG    30      -9.054  17.883 -15.513  1.00 64.14           C 
ATOM    469  CG  ARG    30     -10.169  18.599 -16.274  1.00  1.21           C 
ATOM    470  CD  ARG    30     -11.553  18.200 -15.775  1.00 74.11           C 
ATOM    471  NE  ARG    30     -11.891  16.822 -16.127  1.00 74.13           N 
ATOM    472  CZ  ARG    30     -12.425  15.962 -15.302  1.00 33.22           C 
ATOM    473  NH1 ARG    30     -12.674  16.292 -14.076  1.00  3.02           N 
ATOM    474  NH2 ARG    30     -12.725  14.774 -15.710  1.00 24.22           N 
ATOM    475  H   ARG    30      -7.748  16.743 -17.642  1.00 37.79           H 
ATOM    476  HA  ARG    30      -7.491  19.240 -16.082  1.00 64.11           H 
ATOM    477 1HB  ARG    30      -9.087  18.205 -14.481  1.00 37.79           H 
ATOM    478 2HB  ARG    30      -9.239  16.817 -15.554  1.00 37.79           H 
ATOM    479 1HG  ARG    30     -10.091  18.350 -17.324  1.00 37.79           H 
ATOM    480 2HG  ARG    30     -10.050  19.665 -16.148  1.00 37.79           H 
ATOM    481 1HD  ARG    30     -12.286  18.862 -16.215  1.00 37.79           H 
ATOM    482 2HD  ARG    30     -11.578  18.305 -14.699  1.00 37.79           H 
ATOM    483  HE  ARG    30     -11.718  16.537 -17.045  1.00 44.31           H 
ATOM    484 1HH1 ARG    30     -12.458  17.210 -13.751  1.00 37.79           H 
ATOM    485 2HH1 ARG    30     -13.075  15.621 -13.456  1.00 37.79           H 
ATOM    486 1HH2 ARG    30     -12.544  14.509 -16.651  1.00 37.79           H 
ATOM    487 2HH2 ARG    30     -13.137  14.120 -15.074  1.00 37.79           H 
ATOM    488  N   ASN    31      -5.855  18.313 -14.432  1.00  1.22           N 
ATOM    489  CA  ASN    31      -4.756  17.813 -13.598  1.00 24.12           C 
ATOM    490  C   ASN    31      -5.276  17.154 -12.309  1.00 43.30           C 
ATOM    491  O   ASN    31      -5.799  17.829 -11.419  1.00 11.01           O 
ATOM    492  CB  ASN    31      -3.803  18.961 -13.254  1.00 25.03           C 
ATOM    493  CG  ASN    31      -3.169  19.569 -14.491  1.00  0.33           C 
ATOM    494  OD1 ASN    31      -3.727  20.468 -15.110  1.00 63.32           O 
ATOM    495  ND2 ASN    31      -2.002  19.083 -14.868  1.00 75.00           N 
ATOM    496  H   ASN    31      -6.069  19.270 -14.412  1.00 37.79           H 
ATOM    497  HA  ASN    31      -4.214  17.074 -14.173  1.00 14.35           H 
ATOM    498 1HB  ASN    31      -3.018  18.594 -12.608  1.00 37.79           H 
ATOM    499 2HB  ASN    31      -4.354  19.735 -12.738  1.00 37.79           H 
ATOM    500 1HD2 ASN    31      -1.604  18.362 -14.341  1.00 37.79           H 
ATOM    501 2HD2 ASN    31      -1.575  19.479 -15.657  1.00 37.79           H 
ATOM    502  N   LEU    32      -5.141  15.831 -12.225  1.00 74.42           N 
ATOM    503  CA  LEU    32      -5.543  15.078 -11.030  1.00 50.01           C 
ATOM    504  C   LEU    32      -4.350  14.865 -10.085  1.00 63.41           C 
ATOM    505  O   LEU    32      -3.212  14.721 -10.530  1.00 24.31           O 
ATOM    506  CB  LEU    32      -6.141  13.722 -11.433  1.00 53.15           C 
ATOM    507  CG  LEU    32      -7.352  13.794 -12.381  1.00 22.11           C 
ATOM    508  CD1 LEU    32      -7.854  12.395 -12.724  1.00 35.54           C 
ATOM    509  CD2 LEU    32      -8.474  14.633 -11.769  1.00 34.41           C 
ATOM    510  H   LEU    32      -4.767  15.343 -12.990  1.00 37.79           H 
ATOM    511  HA  LEU    32      -6.299  15.653 -10.509  1.00 74.20           H 
ATOM    512 1HB  LEU    32      -6.447  13.205 -10.533  1.00 37.79           H 
ATOM    513 2HB  LEU    32      -5.366  13.139 -11.914  1.00 37.79           H 
ATOM    514  HG  LEU    32      -7.046  14.269 -13.302  1.00 73.44           H 
ATOM    515 1HD1 LEU    32      -8.698  12.470 -13.396  1.00 37.79           H 
ATOM    516 2HD1 LEU    32      -8.159  11.887 -11.820  1.00 37.79           H 
ATOM    517 3HD1 LEU    32      -7.063  11.835 -13.202  1.00 37.79           H 
ATOM    518 1HD2 LEU    32      -8.116  15.636 -11.584  1.00 37.79           H 
ATOM    519 2HD2 LEU    32      -8.793  14.189 -10.838  1.00 37.79           H 
ATOM    520 3HD2 LEU    32      -9.311  14.672 -12.454  1.00 37.79           H 
ATOM    521  N   ARG    33      -4.617  14.855  -8.783  1.00 23.22           N 
ATOM    522  CA  ARG    33      -3.567  14.659  -7.775  1.00 62.34           C 
ATOM    523  C   ARG    33      -3.680  13.266  -7.131  1.00 41.45           C 
ATOM    524  O   ARG    33      -4.560  13.023  -6.302  1.00 55.31           O 
ATOM    525  CB  ARG    33      -3.672  15.757  -6.702  1.00  0.52           C 
ATOM    526  CG  ARG    33      -2.536  15.761  -5.681  1.00 63.32           C 
ATOM    527  CD  ARG    33      -2.727  16.864  -4.642  1.00 45.22           C 
ATOM    528  NE  ARG    33      -1.581  16.987  -3.743  1.00  0.41           N 
ATOM    529  CZ  ARG    33      -1.532  17.804  -2.724  1.00 64.12           C 
ATOM    530  NH1 ARG    33      -2.559  18.521  -2.392  1.00 31.31           N 
ATOM    531  NH2 ARG    33      -0.456  17.885  -2.021  1.00 33.22           N 
ATOM    532  H   ARG    33      -5.544  14.990  -8.485  1.00 37.79           H 
ATOM    533  HA  ARG    33      -2.607  14.740  -8.269  1.00 24.55           H 
ATOM    534 1HB  ARG    33      -4.604  15.629  -6.169  1.00 37.79           H 
ATOM    535 2HB  ARG    33      -3.683  16.719  -7.195  1.00 37.79           H 
ATOM    536 1HG  ARG    33      -1.599  15.923  -6.198  1.00 37.79           H 
ATOM    537 2HG  ARG    33      -2.509  14.805  -5.177  1.00 37.79           H 
ATOM    538 1HD  ARG    33      -3.609  16.641  -4.058  1.00 37.79           H 
ATOM    539 2HD  ARG    33      -2.869  17.804  -5.156  1.00 37.79           H 
ATOM    540  HE  ARG    33      -0.795  16.437  -3.930  1.00 73.45           H 
ATOM    541 1HH1 ARG    33      -3.405  18.456  -2.916  1.00 37.79           H 
ATOM    542 2HH1 ARG    33      -2.501  19.134  -1.608  1.00 37.79           H 
ATOM    543 1HH2 ARG    33       0.337  17.323  -2.256  1.00 37.79           H 
ATOM    544 2HH2 ARG    33      -0.410  18.511  -1.247  1.00 37.79           H 
ATOM    545  N   ASN    34      -2.787  12.354  -7.517  1.00 10.04           N 
ATOM    546  CA  ASN    34      -2.822  10.967  -7.029  1.00 60.55           C 
ATOM    547  C   ASN    34      -1.435  10.491  -6.569  1.00  4.14           C 
ATOM    548  O   ASN    34      -0.415  11.062  -6.944  1.00  5.43           O 
ATOM    549  CB  ASN    34      -3.363  10.038  -8.125  1.00 44.12           C 
ATOM    550  CG  ASN    34      -2.622  10.199  -9.441  1.00 55.23           C 
ATOM    551  OD1 ASN    34      -3.003  10.999 -10.285  1.00 41.25           O 
ATOM    552  ND2 ASN    34      -1.556   9.444  -9.632  1.00 15.13           N 
ATOM    553  H   ASN    34      -2.080  12.618  -8.145  1.00 37.79           H 
ATOM    554  HA  ASN    34      -3.493  10.931  -6.181  1.00 11.21           H 
ATOM    555 1HB  ASN    34      -4.408  10.260  -8.292  1.00 37.79           H 
ATOM    556 2HB  ASN    34      -3.269   9.011  -7.801  1.00 37.79           H 
ATOM    557 1HD2 ASN    34      -1.291   8.823  -8.926  1.00 37.79           H 
ATOM    558 2HD2 ASN    34      -1.071   9.544 -10.480  1.00 37.79           H 
ATOM    559  N   TYR    35      -1.408   9.434  -5.759  1.00 15.25           N 
ATOM    560  CA  TYR    35      -0.150   8.884  -5.231  1.00  3.43           C 
ATOM    561  C   TYR    35       0.005   7.400  -5.604  1.00 30.03           C 
ATOM    562  O   TYR    35      -0.857   6.585  -5.281  1.00 62.53           O 
ATOM    563  CB  TYR    35      -0.117   9.028  -3.701  1.00 63.03           C 
ATOM    564  CG  TYR    35      -0.377  10.440  -3.205  1.00 12.25           C 
ATOM    565  CD1 TYR    35       0.674  11.289  -2.878  1.00 33.22           C 
ATOM    566  CD2 TYR    35      -1.677  10.921  -3.066  1.00 63.23           C 
ATOM    567  CE1 TYR    35       0.436  12.573  -2.427  1.00 75.25           C 
ATOM    568  CE2 TYR    35      -1.920  12.204  -2.617  1.00 73.00           C 
ATOM    569  CZ  TYR    35      -0.861  13.025  -2.300  1.00 71.53           C 
ATOM    570  OH  TYR    35      -1.100  14.303  -1.852  1.00 55.24           O 
ATOM    571  H   TYR    35      -2.256   9.012  -5.500  1.00 37.79           H 
ATOM    572  HA  TYR    35       0.671   9.444  -5.656  1.00 61.12           H 
ATOM    573 1HB  TYR    35       0.857   8.722  -3.342  1.00 37.79           H 
ATOM    574 2HB  TYR    35      -0.869   8.383  -3.270  1.00 37.79           H 
ATOM    575  HD1 TYR    35       1.690  10.934  -2.979  1.00 35.33           H 
ATOM    576  HD2 TYR    35      -2.506  10.275  -3.315  1.00 44.14           H 
ATOM    577  HE1 TYR    35       1.266  13.219  -2.179  1.00 61.01           H 
ATOM    578  HE2 TYR    35      -2.935  12.559  -2.517  1.00 44.11           H 
ATOM    579  HH  TYR    35      -0.428  14.897  -2.208  1.00 72.13           H 
ATOM    580  N   THR    36       1.110   7.054  -6.270  1.00 22.23           N 
ATOM    581  CA  THR    36       1.389   5.657  -6.657  1.00 51.14           C 
ATOM    582  C   THR    36       2.623   5.121  -5.921  1.00 72.41           C 
ATOM    583  O   THR    36       3.748   5.569  -6.163  1.00 25.03           O 
ATOM    584  CB  THR    36       1.619   5.525  -8.185  1.00 44.31           C 
ATOM    585  OG1 THR    36       0.479   6.024  -8.906  1.00  3.35           O 
ATOM    586  CG2 THR    36       1.874   4.072  -8.588  1.00 72.20           C 
ATOM    587  H   THR    36       1.756   7.751  -6.511  1.00 37.79           H 
ATOM    588  HA  THR    36       0.531   5.053  -6.390  1.00 55.14           H 
ATOM    589  HB  THR    36       2.486   6.113  -8.456  1.00 15.33           H 
ATOM    590  HG1 THR    36      -0.252   5.399  -8.820  1.00 22.04           H 
ATOM    591 1HG2 THR    36       1.035   3.461  -8.289  1.00 37.79           H 
ATOM    592 2HG2 THR    36       2.771   3.714  -8.103  1.00 37.79           H 
ATOM    593 3HG2 THR    36       1.998   4.011  -9.660  1.00 37.79           H 
ATOM    594  N   LEU    37       2.416   4.162  -5.026  1.00 70.25           N 
ATOM    595  CA  LEU    37       3.502   3.641  -4.187  1.00 40.24           C 
ATOM    596  C   LEU    37       3.529   2.100  -4.162  1.00 10.10           C 
ATOM    597  O   LEU    37       2.503   1.444  -4.367  1.00 75.41           O 
ATOM    598  CB  LEU    37       3.359   4.184  -2.758  1.00 13.44           C 
ATOM    599  CG  LEU    37       3.492   5.710  -2.607  1.00 33.22           C 
ATOM    600  CD1 LEU    37       3.225   6.140  -1.168  1.00 74.33           C 
ATOM    601  CD2 LEU    37       4.873   6.172  -3.056  1.00 22.54           C 
ATOM    602  H   LEU    37       1.511   3.790  -4.924  1.00 37.79           H 
ATOM    603  HA  LEU    37       4.436   3.994  -4.600  1.00 20.12           H 
ATOM    604 1HB  LEU    37       4.116   3.718  -2.143  1.00 37.79           H 
ATOM    605 2HB  LEU    37       2.388   3.891  -2.384  1.00 37.79           H 
ATOM    606  HG  LEU    37       2.758   6.193  -3.238  1.00  3.32           H 
ATOM    607 1HD1 LEU    37       2.228   5.839  -0.880  1.00 37.79           H 
ATOM    608 2HD1 LEU    37       3.310   7.215  -1.089  1.00 37.79           H 
ATOM    609 3HD1 LEU    37       3.945   5.673  -0.510  1.00 37.79           H 
ATOM    610 1HD2 LEU    37       4.951   7.243  -2.936  1.00 37.79           H 
ATOM    611 2HD2 LEU    37       5.016   5.918  -4.096  1.00 37.79           H 
ATOM    612 3HD2 LEU    37       5.630   5.686  -2.459  1.00 37.79           H 
ATOM    613  N   PRO    38       4.717   1.502  -3.917  1.00 45.52           N 
ATOM    614  CA  PRO    38       4.864   0.044  -3.793  1.00 72.33           C 
ATOM    615  C   PRO    38       4.266  -0.500  -2.484  1.00 23.45           C 
ATOM    616  O   PRO    38       4.337   0.143  -1.434  1.00 11.12           O 
ATOM    617  CB  PRO    38       6.393  -0.179  -3.822  1.00 10.41           C 
ATOM    618  CG  PRO    38       6.988   1.140  -4.208  1.00 72.03           C 
ATOM    619  CD  PRO    38       6.009   2.186  -3.755  1.00  0.25           C 
ATOM    620  HA  PRO    38       4.407  -0.467  -4.630  1.00 23.21           H 
ATOM    621 1HB  PRO    38       6.631  -0.943  -4.548  1.00 37.79           H 
ATOM    622 2HB  PRO    38       6.736  -0.495  -2.845  1.00 37.79           H 
ATOM    623 1HG  PRO    38       7.118   1.187  -5.280  1.00 37.79           H 
ATOM    624 2HG  PRO    38       7.940   1.276  -3.711  1.00 37.79           H 
ATOM    625 1HD  PRO    38       6.066   3.062  -4.386  1.00 37.79           H 
ATOM    626 2HD  PRO    38       6.184   2.450  -2.721  1.00 37.79           H 
ATOM    627  N   ALA    39       3.684  -1.691  -2.550  1.00 72.41           N 
ATOM    628  CA  ALA    39       3.067  -2.316  -1.380  1.00 65.43           C 
ATOM    629  C   ALA    39       3.434  -3.804  -1.272  1.00 60.21           C 
ATOM    630  O   ALA    39       4.017  -4.379  -2.184  1.00  2.30           O 
ATOM    631  CB  ALA    39       1.552  -2.146  -1.436  1.00 22.12           C 
ATOM    632  H   ALA    39       3.669  -2.165  -3.406  1.00 37.79           H 
ATOM    633  HA  ALA    39       3.429  -1.805  -0.498  1.00 43.35           H 
ATOM    634 1HB  ALA    39       1.157  -2.695  -2.280  1.00 37.79           H 
ATOM    635 2HB  ALA    39       1.310  -1.100  -1.545  1.00 37.79           H 
ATOM    636 3HB  ALA    39       1.111  -2.523  -0.523  1.00 37.79           H 
ATOM    637  N   TYR    40       3.103  -4.410  -0.139  1.00  4.15           N 
ATOM    638  CA  TYR    40       3.288  -5.850   0.074  1.00 14.44           C 
ATOM    639  C   TYR    40       2.104  -6.416   0.866  1.00 55.05           C 
ATOM    640  O   TYR    40       1.624  -5.782   1.804  1.00 30.21           O 
ATOM    641  CB  TYR    40       4.591  -6.133   0.843  1.00 74.11           C 
ATOM    642  CG  TYR    40       5.861  -5.700   0.127  1.00 71.00           C 
ATOM    643  CD1 TYR    40       6.502  -6.545  -0.771  1.00  5.20           C 
ATOM    644  CD2 TYR    40       6.424  -4.449   0.360  1.00 44.35           C 
ATOM    645  CE1 TYR    40       7.665  -6.158  -1.411  1.00 70.40           C 
ATOM    646  CE2 TYR    40       7.583  -4.055  -0.279  1.00  3.13           C 
ATOM    647  CZ  TYR    40       8.200  -4.913  -1.163  1.00 63.23           C 
ATOM    648  OH  TYR    40       9.362  -4.525  -1.795  1.00  0.11           O 
ATOM    649  H   TYR    40       2.729  -3.873   0.589  1.00 37.79           H 
ATOM    650  HA  TYR    40       3.330  -6.333  -0.893  1.00 12.13           H 
ATOM    651 1HB  TYR    40       4.663  -7.196   1.028  1.00 37.79           H 
ATOM    652 2HB  TYR    40       4.558  -5.616   1.792  1.00 37.79           H 
ATOM    653  HD1 TYR    40       6.081  -7.521  -0.966  1.00 34.11           H 
ATOM    654  HD2 TYR    40       5.939  -3.777   1.052  1.00  3.43           H 
ATOM    655  HE1 TYR    40       8.148  -6.831  -2.106  1.00 64.21           H 
ATOM    656  HE2 TYR    40       8.002  -3.079  -0.082  1.00 63.34           H 
ATOM    657  HH  TYR    40       9.992  -4.201  -1.134  1.00 52.13           H 
ATOM    658  N   ASP    41       1.621  -7.596   0.488  1.00 62.41           N 
ATOM    659  CA  ASP    41       0.554  -8.257   1.249  1.00 12.34           C 
ATOM    660  C   ASP    41       1.129  -8.976   2.482  1.00 40.34           C 
ATOM    661  O   ASP    41       2.339  -8.955   2.711  1.00 41.12           O 
ATOM    662  CB  ASP    41      -0.205  -9.243   0.355  1.00  0.33           C 
ATOM    663  CG  ASP    41       0.729 -10.207  -0.345  1.00 44.31           C 
ATOM    664  OD1 ASP    41       1.129  -9.917  -1.488  1.00 64.42           O 
ATOM    665  OD2 ASP    41       1.079 -11.246   0.251  1.00 21.52           O 
ATOM    666  H   ASP    41       1.986  -8.036  -0.312  1.00 37.79           H 
ATOM    667  HA  ASP    41      -0.133  -7.490   1.588  1.00 23.42           H 
ATOM    668 1HB  ASP    41      -0.760  -8.693  -0.393  1.00 37.79           H 
ATOM    669 2HB  ASP    41      -0.898  -9.812   0.961  1.00 37.79           H 
ATOM    670  N   GLU    42       0.264  -9.619   3.265  1.00 33.43           N 
ATOM    671  CA  GLU    42       0.686 -10.302   4.497  1.00 30.03           C 
ATOM    672  C   GLU    42       1.770 -11.373   4.238  1.00 44.33           C 
ATOM    673  O   GLU    42       2.614 -11.632   5.101  1.00  1.33           O 
ATOM    674  CB  GLU    42      -0.529 -10.929   5.199  1.00 31.13           C 
ATOM    675  CG  GLU    42      -0.197 -11.581   6.539  1.00 41.33           C 
ATOM    676  CD  GLU    42      -1.431 -12.061   7.288  1.00 40.40           C 
ATOM    677  OE1 GLU    42      -1.845 -11.389   8.255  1.00 71.24           O 
ATOM    678  OE2 GLU    42      -1.990 -13.113   6.913  1.00  3.14           O 
ATOM    679  H   GLU    42      -0.684  -9.624   3.020  1.00 37.79           H 
ATOM    680  HA  GLU    42       1.108  -9.551   5.152  1.00 54.42           H 
ATOM    681 1HB  GLU    42      -0.958 -11.681   4.552  1.00 37.79           H 
ATOM    682 2HB  GLU    42      -1.265 -10.156   5.373  1.00 37.79           H 
ATOM    683 1HG  GLU    42       0.324 -10.859   7.154  1.00 37.79           H 
ATOM    684 2HG  GLU    42       0.450 -12.429   6.362  1.00 37.79           H 
ATOM    685  N   ASP    43       1.760 -11.981   3.051  1.00 10.21           N 
ATOM    686  CA  ASP    43       2.767 -12.993   2.700  1.00 33.34           C 
ATOM    687  C   ASP    43       4.076 -12.326   2.227  1.00 40.05           C 
ATOM    688  O   ASP    43       5.127 -12.968   2.153  1.00 61.13           O 
ATOM    689  CB  ASP    43       2.217 -13.940   1.623  1.00 11.54           C 
ATOM    690  CG  ASP    43       3.161 -15.093   1.316  1.00 51.55           C 
ATOM    691  OD1 ASP    43       3.563 -15.803   2.261  1.00 45.42           O 
ATOM    692  OD2 ASP    43       3.492 -15.308   0.129  1.00 43.34           O 
ATOM    693  H   ASP    43       1.073 -11.743   2.394  1.00 37.79           H 
ATOM    694  HA  ASP    43       2.979 -13.567   3.593  1.00 20.33           H 
ATOM    695 1HB  ASP    43       2.049 -13.380   0.713  1.00 37.79           H 
ATOM    696 2HB  ASP    43       1.277 -14.352   1.962  1.00 37.79           H 
ATOM    697  N   GLY    44       4.004 -11.035   1.912  1.00 12.42           N 
ATOM    698  CA  GLY    44       5.191 -10.275   1.530  1.00 42.21           C 
ATOM    699  C   GLY    44       5.411 -10.188   0.022  1.00 44.44           C 
ATOM    700  O   GLY    44       6.471  -9.749  -0.430  1.00 65.25           O 
ATOM    701  H   GLY    44       3.132 -10.587   1.946  1.00 37.79           H 
ATOM    702 1HA  GLY    44       6.059 -10.735   1.980  1.00 37.79           H 
ATOM    703 2HA  GLY    44       5.095  -9.272   1.919  1.00 37.79           H 
ATOM    704  N   VAL    45       4.420 -10.600  -0.765  1.00 43.22           N 
ATOM    705  CA  VAL    45       4.533 -10.536  -2.227  1.00  2.11           C 
ATOM    706  C   VAL    45       4.348  -9.093  -2.724  1.00  0.42           C 
ATOM    707  O   VAL    45       3.403  -8.407  -2.331  1.00 64.13           O 
ATOM    708  CB  VAL    45       3.504 -11.462  -2.920  1.00 34.25           C 
ATOM    709  CG1 VAL    45       3.731 -11.503  -4.430  1.00 53.21           C 
ATOM    710  CG2 VAL    45       3.555 -12.864  -2.319  1.00 25.44           C 
ATOM    711  H   VAL    45       3.598 -10.949  -0.359  1.00 37.79           H 
ATOM    712  HA  VAL    45       5.528 -10.874  -2.496  1.00 53.41           H 
ATOM    713  HB  VAL    45       2.516 -11.059  -2.743  1.00 55.33           H 
ATOM    714 1HG1 VAL    45       3.597 -10.513  -4.841  1.00 37.79           H 
ATOM    715 2HG1 VAL    45       3.019 -12.179  -4.884  1.00 37.79           H 
ATOM    716 3HG1 VAL    45       4.734 -11.846  -4.637  1.00 37.79           H 
ATOM    717 1HG2 VAL    45       4.545 -13.276  -2.443  1.00 37.79           H 
ATOM    718 2HG2 VAL    45       2.836 -13.498  -2.820  1.00 37.79           H 
ATOM    719 3HG2 VAL    45       3.314 -12.813  -1.266  1.00 37.79           H 
ATOM    720  N   LYS    46       5.247  -8.640  -3.596  1.00 54.35           N 
ATOM    721  CA  LYS    46       5.262  -7.241  -4.027  1.00 10.30           C 
ATOM    722  C   LYS    46       3.981  -6.838  -4.779  1.00  5.11           C 
ATOM    723  O   LYS    46       3.448  -7.593  -5.594  1.00 22.04           O 
ATOM    724  CB  LYS    46       6.490  -6.958  -4.898  1.00 70.52           C 
ATOM    725  CG  LYS    46       6.629  -5.487  -5.273  1.00 32.21           C 
ATOM    726  CD  LYS    46       7.899  -5.207  -6.068  1.00 52.33           C 
ATOM    727  CE  LYS    46       8.023  -3.728  -6.407  1.00 24.42           C 
ATOM    728  NZ  LYS    46       9.285  -3.420  -7.127  1.00 32.13           N 
ATOM    729  H   LYS    46       5.913  -9.259  -3.959  1.00 37.79           H 
ATOM    730  HA  LYS    46       5.335  -6.635  -3.134  1.00 55.44           H 
ATOM    731 1HB  LYS    46       6.412  -7.534  -5.808  1.00 37.79           H 
ATOM    732 2HB  LYS    46       7.380  -7.264  -4.363  1.00 37.79           H 
ATOM    733 1HG  LYS    46       6.643  -4.896  -4.367  1.00 37.79           H 
ATOM    734 2HG  LYS    46       5.775  -5.199  -5.873  1.00 37.79           H 
ATOM    735 1HD  LYS    46       7.870  -5.774  -6.988  1.00 37.79           H 
ATOM    736 2HD  LYS    46       8.758  -5.508  -5.484  1.00 37.79           H 
ATOM    737 1HE  LYS    46       7.992  -3.155  -5.491  1.00 37.79           H 
ATOM    738 2HE  LYS    46       7.189  -3.444  -7.033  1.00 37.79           H 
ATOM    739 1HZ  LYS    46      10.105  -3.689  -6.547  1.00 37.79           H 
ATOM    740 2HZ  LYS    46       9.341  -2.403  -7.337  1.00 37.79           H 
ATOM    741 3HZ  LYS    46       9.321  -3.945  -8.021  1.00 37.79           H 
ATOM    742  N   LYS    47       3.507  -5.633  -4.485  1.00 65.11           N 
ATOM    743  CA  LYS    47       2.312  -5.055  -5.106  1.00 12.42           C 
ATOM    744  C   LYS    47       2.574  -3.587  -5.473  1.00 60.21           C 
ATOM    745  O   LYS    47       3.574  -3.002  -5.049  1.00 74.33           O 
ATOM    746  CB  LYS    47       1.117  -5.133  -4.136  1.00  2.20           C 
ATOM    747  CG  LYS    47       0.718  -6.551  -3.730  1.00 54.23           C 
ATOM    748  CD  LYS    47       0.148  -7.342  -4.903  1.00 44.32           C 
ATOM    749  CE  LYS    47      -0.235  -8.762  -4.495  1.00 52.11           C 
ATOM    750  NZ  LYS    47       0.940  -9.549  -4.035  1.00 24.05           N 
ATOM    751  H   LYS    47       3.986  -5.098  -3.821  1.00 37.79           H 
ATOM    752  HA  LYS    47       2.084  -5.609  -6.005  1.00 25.00           H 
ATOM    753 1HB  LYS    47       0.261  -4.660  -4.600  1.00 37.79           H 
ATOM    754 2HB  LYS    47       1.368  -4.588  -3.236  1.00 37.79           H 
ATOM    755 1HG  LYS    47      -0.029  -6.494  -2.949  1.00 37.79           H 
ATOM    756 2HG  LYS    47       1.592  -7.066  -3.354  1.00 37.79           H 
ATOM    757 1HD  LYS    47       0.891  -7.390  -5.688  1.00 37.79           H 
ATOM    758 2HD  LYS    47      -0.733  -6.835  -5.273  1.00 37.79           H 
ATOM    759 1HE  LYS    47      -0.679  -9.261  -5.347  1.00 37.79           H 
ATOM    760 2HE  LYS    47      -0.958  -8.712  -3.694  1.00 37.79           H 
ATOM    761 1HZ  LYS    47       1.355  -9.114  -3.181  1.00 37.79           H 
ATOM    762 2HZ  LYS    47       1.663  -9.584  -4.779  1.00 37.79           H 
ATOM    763 3HZ  LYS    47       0.651 -10.520  -3.803  1.00 37.79           H 
ATOM    764  N   GLN    48       1.687  -2.994  -6.262  1.00 41.13           N 
ATOM    765  CA  GLN    48       1.772  -1.563  -6.575  1.00 14.12           C 
ATOM    766  C   GLN    48       0.375  -0.925  -6.557  1.00 12.32           C 
ATOM    767  O   GLN    48      -0.478  -1.255  -7.380  1.00  3.41           O 
ATOM    768  CB  GLN    48       2.450  -1.343  -7.935  1.00 72.20           C 
ATOM    769  CG  GLN    48       2.762   0.122  -8.229  1.00 42.23           C 
ATOM    770  CD  GLN    48       3.547   0.309  -9.513  1.00 13.05           C 
ATOM    771  OE1 GLN    48       4.777   0.300  -9.512  1.00 73.54           O 
ATOM    772  NE2 GLN    48       2.849   0.479 -10.616  1.00 31.21           N 
ATOM    773  H   GLN    48       0.958  -3.527  -6.648  1.00 37.79           H 
ATOM    774  HA  GLN    48       2.374  -1.094  -5.806  1.00 52.12           H 
ATOM    775 1HB  GLN    48       1.800  -1.716  -8.714  1.00 37.79           H 
ATOM    776 2HB  GLN    48       3.377  -1.900  -7.957  1.00 37.79           H 
ATOM    777 1HG  GLN    48       3.339   0.527  -7.410  1.00 37.79           H 
ATOM    778 2HG  GLN    48       1.831   0.666  -8.312  1.00 37.79           H 
ATOM    779 1HE2 GLN    48       1.875   0.470 -10.553  1.00 37.79           H 
ATOM    780 2HE2 GLN    48       3.339   0.619 -11.452  1.00 37.79           H 
ATOM    781  N   ILE    49       0.146  -0.011  -5.615  1.00 63.01           N 
ATOM    782  CA  ILE    49      -1.192   0.556  -5.398  1.00 42.34           C 
ATOM    783  C   ILE    49      -1.189   2.093  -5.480  1.00 34.32           C 
ATOM    784  O   ILE    49      -0.243   2.753  -5.045  1.00 62.45           O 
ATOM    785  CB  ILE    49      -1.758   0.108  -4.020  1.00 22.44           C 
ATOM    786  CG1 ILE    49      -1.835  -1.429  -3.946  1.00 34.13           C 
ATOM    787  CG2 ILE    49      -3.131   0.734  -3.753  1.00 42.50           C 
ATOM    788  CD1 ILE    49      -2.295  -1.962  -2.604  1.00 41.43           C 
ATOM    789  H   ILE    49       0.894   0.298  -5.057  1.00 37.79           H 
ATOM    790  HA  ILE    49      -1.847   0.171  -6.171  1.00 72.51           H 
ATOM    791  HB  ILE    49      -1.081   0.458  -3.254  1.00 74.33           H 
ATOM    792 1HG1 ILE    49      -0.855  -1.840  -4.145  1.00 37.79           H 
ATOM    793 2HG1 ILE    49      -2.526  -1.786  -4.694  1.00 37.79           H 
ATOM    794 1HG2 ILE    49      -3.499   0.399  -2.795  1.00 37.79           H 
ATOM    795 2HG2 ILE    49      -3.823   0.438  -4.528  1.00 37.79           H 
ATOM    796 3HG2 ILE    49      -3.042   1.812  -3.745  1.00 37.79           H 
ATOM    797 1HD1 ILE    49      -1.606  -1.646  -1.834  1.00 37.79           H 
ATOM    798 2HD1 ILE    49      -2.324  -3.041  -2.638  1.00 37.79           H 
ATOM    799 3HD1 ILE    49      -3.282  -1.582  -2.382  1.00 37.79           H 
ATOM    800  N   THR    50      -2.260   2.650  -6.049  1.00 12.32           N 
ATOM    801  CA  THR    50      -2.417   4.108  -6.182  1.00 23.40           C 
ATOM    802  C   THR    50      -3.593   4.624  -5.336  1.00 43.22           C 
ATOM    803  O   THR    50      -4.733   4.196  -5.519  1.00  1.20           O 
ATOM    804  CB  THR    50      -2.647   4.521  -7.662  1.00 13.23           C 
ATOM    805  OG1 THR    50      -1.533   4.108  -8.468  1.00 53.32           O 
ATOM    806  CG2 THR    50      -2.837   6.033  -7.801  1.00 70.42           C 
ATOM    807  H   THR    50      -2.967   2.066  -6.393  1.00 37.79           H 
ATOM    808  HA  THR    50      -1.505   4.578  -5.837  1.00 33.34           H 
ATOM    809  HB  THR    50      -3.540   4.027  -8.023  1.00 52.11           H 
ATOM    810  HG1 THR    50      -1.832   3.953  -9.375  1.00 21.21           H 
ATOM    811 1HG2 THR    50      -2.995   6.283  -8.842  1.00 37.79           H 
ATOM    812 2HG2 THR    50      -1.957   6.544  -7.440  1.00 37.79           H 
ATOM    813 3HG2 THR    50      -3.695   6.342  -7.222  1.00 37.79           H 
ATOM    814  N   PHE    51      -3.313   5.548  -4.417  1.00 61.31           N 
ATOM    815  CA  PHE    51      -4.349   6.121  -3.544  1.00 61.02           C 
ATOM    816  C   PHE    51      -4.439   7.651  -3.699  1.00  3.32           C 
ATOM    817  O   PHE    51      -3.613   8.272  -4.370  1.00 14.14           O 
ATOM    818  CB  PHE    51      -4.083   5.752  -2.072  1.00  2.33           C 
ATOM    819  CG  PHE    51      -2.799   6.319  -1.506  1.00 44.42           C 
ATOM    820  CD1 PHE    51      -1.578   5.704  -1.753  1.00 41.41           C 
ATOM    821  CD2 PHE    51      -2.818   7.465  -0.719  1.00 23.55           C 
ATOM    822  CE1 PHE    51      -0.407   6.223  -1.232  1.00 12.42           C 
ATOM    823  CE2 PHE    51      -1.649   7.986  -0.197  1.00 30.20           C 
ATOM    824  CZ  PHE    51      -0.444   7.364  -0.452  1.00 12.21           C 
ATOM    825  H   PHE    51      -2.387   5.859  -4.324  1.00 37.79           H 
ATOM    826  HA  PHE    51      -5.299   5.697  -3.839  1.00 75.34           H 
ATOM    827 1HB  PHE    51      -4.039   4.675  -1.984  1.00 37.79           H 
ATOM    828 2HB  PHE    51      -4.901   6.117  -1.466  1.00 37.79           H 
ATOM    829  HD1 PHE    51      -1.547   4.812  -2.363  1.00 53.43           H 
ATOM    830  HD2 PHE    51      -3.761   7.954  -0.517  1.00 71.12           H 
ATOM    831  HE1 PHE    51       0.535   5.734  -1.430  1.00 24.20           H 
ATOM    832  HE2 PHE    51      -1.679   8.879   0.411  1.00 10.11           H 
ATOM    833  HZ  PHE    51       0.471   7.770  -0.044  1.00 51.34           H 
ATOM    834  N   ARG    52      -5.451   8.250  -3.073  1.00 14.43           N 
ATOM    835  CA  ARG    52      -5.648   9.703  -3.126  1.00 61.04           C 
ATOM    836  C   ARG    52      -6.253  10.226  -1.813  1.00 60.55           C 
ATOM    837  O   ARG    52      -6.974   9.505  -1.120  1.00 50.23           O 
ATOM    838  CB  ARG    52      -6.553  10.078  -4.314  1.00 11.20           C 
ATOM    839  CG  ARG    52      -6.758  11.583  -4.487  1.00 12.44           C 
ATOM    840  CD  ARG    52      -7.656  11.902  -5.677  1.00 33.42           C 
ATOM    841  NE  ARG    52      -8.997  11.343  -5.518  1.00 12.14           N 
ATOM    842  CZ  ARG    52      -9.762  10.979  -6.509  1.00 71.40           C 
ATOM    843  NH1 ARG    52      -9.366  11.120  -7.735  1.00  2.21           N 
ATOM    844  NH2 ARG    52     -10.926  10.479  -6.271  1.00 34.31           N 
ATOM    845  H   ARG    52      -6.080   7.704  -2.560  1.00 37.79           H 
ATOM    846  HA  ARG    52      -4.680  10.165  -3.264  1.00 31.44           H 
ATOM    847 1HB  ARG    52      -7.521   9.617  -4.174  1.00 37.79           H 
ATOM    848 2HB  ARG    52      -6.110   9.692  -5.221  1.00 37.79           H 
ATOM    849 1HG  ARG    52      -5.796  12.053  -4.638  1.00 37.79           H 
ATOM    850 2HG  ARG    52      -7.214  11.979  -3.591  1.00 37.79           H 
ATOM    851 1HD  ARG    52      -7.206  11.491  -6.572  1.00 37.79           H 
ATOM    852 2HD  ARG    52      -7.734  12.976  -5.778  1.00 37.79           H 
ATOM    853  HE  ARG    52      -9.341  11.240  -4.606  1.00 63.42           H 
ATOM    854 1HH1 ARG    52      -8.474  11.510  -7.927  1.00 37.79           H 
ATOM    855 2HH1 ARG    52      -9.964  10.845  -8.487  1.00 37.79           H 
ATOM    856 1HH2 ARG    52     -11.241  10.374  -5.331  1.00 37.79           H 
ATOM    857 2HH2 ARG    52     -11.512  10.199  -7.031  1.00 37.79           H 
ATOM   1084  N   ALA    66       7.886   6.509   6.773  1.00 33.30           N 
ATOM   1085  CA  ALA    66       6.896   5.734   7.524  1.00 61.21           C 
ATOM   1086  C   ALA    66       6.144   4.745   6.622  1.00 32.42           C 
ATOM   1087  O   ALA    66       6.234   4.807   5.393  1.00 74.34           O 
ATOM   1088  CB  ALA    66       5.910   6.673   8.214  1.00 33.23           C 
ATOM   1089  H   ALA    66       7.704   7.454   6.597  1.00 37.79           H 
ATOM   1090  HA  ALA    66       7.418   5.179   8.290  1.00 21.04           H 
ATOM   1091 1HB  ALA    66       6.449   7.363   8.846  1.00 37.79           H 
ATOM   1092 2HB  ALA    66       5.221   6.097   8.817  1.00 37.79           H 
ATOM   1093 3HB  ALA    66       5.358   7.227   7.468  1.00 37.79           H 
ATOM   1094  N   PHE    67       5.385   3.847   7.242  1.00 24.01           N 
ATOM   1095  CA  PHE    67       4.688   2.787   6.514  1.00 25.55           C 
ATOM   1096  C   PHE    67       3.168   3.004   6.510  1.00 55.04           C 
ATOM   1097  O   PHE    67       2.639   3.845   7.236  1.00 71.21           O 
ATOM   1098  CB  PHE    67       5.033   1.423   7.125  1.00 72.14           C 
ATOM   1099  CG  PHE    67       6.517   1.142   7.151  1.00 61.03           C 
ATOM   1100  CD1 PHE    67       7.147   0.552   6.063  1.00  1.43           C 
ATOM   1101  CD2 PHE    67       7.284   1.478   8.258  1.00 21.24           C 
ATOM   1102  CE1 PHE    67       8.507   0.304   6.080  1.00 42.30           C 
ATOM   1103  CE2 PHE    67       8.644   1.230   8.279  1.00 14.12           C 
ATOM   1104  CZ  PHE    67       9.256   0.642   7.189  1.00 50.14           C 
ATOM   1105  H   PHE    67       5.279   3.903   8.215  1.00 37.79           H 
ATOM   1106  HA  PHE    67       5.039   2.803   5.491  1.00 73.32           H 
ATOM   1107 1HB  PHE    67       4.555   0.641   6.548  1.00 37.79           H 
ATOM   1108 2HB  PHE    67       4.667   1.386   8.141  1.00 37.79           H 
ATOM   1109  HD1 PHE    67       6.564   0.284   5.194  1.00  0.25           H 
ATOM   1110  HD2 PHE    67       6.808   1.938   9.112  1.00 22.25           H 
ATOM   1111  HE1 PHE    67       8.983  -0.155   5.225  1.00  1.04           H 
ATOM   1112  HE2 PHE    67       9.227   1.495   9.147  1.00 75.12           H 
ATOM   1113  HZ  PHE    67      10.319   0.447   7.204  1.00 74.31           H 
ATOM   1114  N   LEU    68       2.478   2.231   5.683  1.00 35.22           N 
ATOM   1115  CA  LEU    68       1.029   2.328   5.527  1.00 15.24           C 
ATOM   1116  C   LEU    68       0.387   0.939   5.574  1.00 62.43           C 
ATOM   1117  O   LEU    68       1.025  -0.068   5.270  1.00  2.30           O 
ATOM   1118  CB  LEU    68       0.661   3.011   4.198  1.00 72.32           C 
ATOM   1119  CG  LEU    68       1.066   4.487   4.065  1.00  0.21           C 
ATOM   1120  CD1 LEU    68       0.669   5.028   2.693  1.00 24.04           C 
ATOM   1121  CD2 LEU    68       0.438   5.325   5.176  1.00 44.23           C 
ATOM   1122  H   LEU    68       2.958   1.555   5.171  1.00 37.79           H 
ATOM   1123  HA  LEU    68       0.641   2.919   6.347  1.00 44.13           H 
ATOM   1124 1HB  LEU    68      -0.412   2.943   4.069  1.00 37.79           H 
ATOM   1125 2HB  LEU    68       1.133   2.459   3.397  1.00 37.79           H 
ATOM   1126  HG  LEU    68       2.141   4.566   4.153  1.00 14.14           H 
ATOM   1127 1HD1 LEU    68       1.167   4.457   1.923  1.00 37.79           H 
ATOM   1128 2HD1 LEU    68       0.962   6.065   2.617  1.00 37.79           H 
ATOM   1129 3HD1 LEU    68      -0.401   4.946   2.566  1.00 37.79           H 
ATOM   1130 1HD2 LEU    68      -0.639   5.257   5.118  1.00 37.79           H 
ATOM   1131 2HD2 LEU    68       0.741   6.356   5.066  1.00 37.79           H 
ATOM   1132 3HD2 LEU    68       0.769   4.956   6.136  1.00 37.79           H 
ATOM   1133  N   ARG    69      -0.881   0.906   5.939  1.00 72.04           N 
ATOM   1134  CA  ARG    69      -1.646  -0.331   6.041  1.00 31.20           C 
ATOM   1135  C   ARG    69      -2.964  -0.175   5.274  1.00 32.31           C 
ATOM   1136  O   ARG    69      -3.812   0.630   5.647  1.00 22.14           O 
ATOM   1137  CB  ARG    69      -1.899  -0.600   7.530  1.00 41.14           C 
ATOM   1138  CG  ARG    69      -2.595  -1.915   7.863  1.00 34.12           C 
ATOM   1139  CD  ARG    69      -2.746  -2.052   9.373  1.00 73.44           C 
ATOM   1140  NE  ARG    69      -3.442  -3.266   9.785  1.00 34.12           N 
ATOM   1141  CZ  ARG    69      -3.940  -3.428  10.981  1.00 45.14           C 
ATOM   1142  NH1 ARG    69      -3.904  -2.460  11.843  1.00 23.24           N 
ATOM   1143  NH2 ARG    69      -4.503  -4.544  11.308  1.00 21.24           N 
ATOM   1144  H   ARG    69      -1.323   1.748   6.155  1.00 37.79           H 
ATOM   1145  HA  ARG    69      -1.067  -1.140   5.616  1.00 13.24           H 
ATOM   1146 1HB  ARG    69      -2.505   0.207   7.923  1.00 37.79           H 
ATOM   1147 2HB  ARG    69      -0.949  -0.593   8.044  1.00 37.79           H 
ATOM   1148 1HG  ARG    69      -2.002  -2.737   7.489  1.00 37.79           H 
ATOM   1149 2HG  ARG    69      -3.574  -1.926   7.403  1.00 37.79           H 
ATOM   1150 1HD  ARG    69      -3.297  -1.194   9.739  1.00 37.79           H 
ATOM   1151 2HD  ARG    69      -1.762  -2.053   9.818  1.00 37.79           H 
ATOM   1152  HE  ARG    69      -3.515  -3.994   9.142  1.00  1.31           H 
ATOM   1153 1HH1 ARG    69      -3.496  -1.580  11.593  1.00 37.79           H 
ATOM   1154 2HH1 ARG    69      -4.278  -2.594  12.758  1.00 37.79           H 
ATOM   1155 1HH2 ARG    69      -4.560  -5.290  10.647  1.00 37.79           H 
ATOM   1156 2HH2 ARG    69      -4.878  -4.659  12.224  1.00 37.79           H 
ATOM   1157  N   LEU    70      -3.132  -0.943   4.204  1.00 20.55           N 
ATOM   1158  CA  LEU    70      -4.292  -0.796   3.320  1.00 33.33           C 
ATOM   1159  C   LEU    70      -5.294  -1.938   3.514  1.00 12.31           C 
ATOM   1160  O   LEU    70      -4.933  -3.118   3.489  1.00 73.23           O 
ATOM   1161  CB  LEU    70      -3.854  -0.723   1.842  1.00 62.21           C 
ATOM   1162  CG  LEU    70      -3.135   0.575   1.407  1.00 75.23           C 
ATOM   1163  CD1 LEU    70      -1.827   0.781   2.170  1.00 73.03           C 
ATOM   1164  CD2 LEU    70      -2.881   0.569  -0.097  1.00 15.32           C 
ATOM   1165  H   LEU    70      -2.464  -1.628   4.001  1.00 37.79           H 
ATOM   1166  HA  LEU    70      -4.783   0.134   3.578  1.00  3.31           H 
ATOM   1167 1HB  LEU    70      -4.733  -0.842   1.223  1.00 37.79           H 
ATOM   1168 2HB  LEU    70      -3.190  -1.554   1.650  1.00 37.79           H 
ATOM   1169  HG  LEU    70      -3.777   1.417   1.627  1.00  5.31           H 
ATOM   1170 1HD1 LEU    70      -1.176  -0.066   2.009  1.00 37.79           H 
ATOM   1171 2HD1 LEU    70      -2.036   0.878   3.225  1.00 37.79           H 
ATOM   1172 3HD1 LEU    70      -1.339   1.680   1.818  1.00 37.79           H 
ATOM   1173 1HD2 LEU    70      -3.822   0.504  -0.623  1.00 37.79           H 
ATOM   1174 2HD2 LEU    70      -2.266  -0.281  -0.356  1.00 37.79           H 
ATOM   1175 3HD2 LEU    70      -2.373   1.480  -0.383  1.00 37.79           H 
ATOM   1176  N   TYR    71      -6.554  -1.572   3.705  1.00  4.11           N 
ATOM   1177  CA  TYR    71      -7.629  -2.541   3.923  1.00 10.13           C 
ATOM   1178  C   TYR    71      -8.475  -2.719   2.657  1.00 15.31           C 
ATOM   1179  O   TYR    71      -9.033  -1.753   2.128  1.00 52.43           O 
ATOM   1180  CB  TYR    71      -8.522  -2.073   5.079  1.00  1.32           C 
ATOM   1181  CG  TYR    71      -7.754  -1.742   6.347  1.00 20.41           C 
ATOM   1182  CD1 TYR    71      -7.517  -0.420   6.716  1.00 63.43           C 
ATOM   1183  CD2 TYR    71      -7.263  -2.749   7.170  1.00 71.51           C 
ATOM   1184  CE1 TYR    71      -6.818  -0.114   7.869  1.00 32.32           C 
ATOM   1185  CE2 TYR    71      -6.565  -2.449   8.324  1.00 14.31           C 
ATOM   1186  CZ  TYR    71      -6.345  -1.131   8.667  1.00 12.13           C 
ATOM   1187  OH  TYR    71      -5.649  -0.833   9.816  1.00 52.25           O 
ATOM   1188  H   TYR    71      -6.772  -0.618   3.704  1.00 37.79           H 
ATOM   1189  HA  TYR    71      -7.183  -3.490   4.185  1.00 71.44           H 
ATOM   1190 1HB  TYR    71      -9.234  -2.852   5.314  1.00 37.79           H 
ATOM   1191 2HB  TYR    71      -9.059  -1.185   4.774  1.00 37.79           H 
ATOM   1192  HD1 TYR    71      -7.889   0.376   6.089  1.00 20.44           H 
ATOM   1193  HD2 TYR    71      -7.435  -3.782   6.901  1.00 52.23           H 
ATOM   1194  HE1 TYR    71      -6.644   0.918   8.138  1.00 35.22           H 
ATOM   1195  HE2 TYR    71      -6.193  -3.246   8.951  1.00 22.14           H 
ATOM   1196  HH  TYR    71      -6.100  -0.128  10.295  1.00 71.31           H 
ATOM   1197  N   VAL    72      -8.558  -3.951   2.167  1.00 31.02           N 
ATOM   1198  CA  VAL    72      -9.406  -4.271   1.016  1.00 71.24           C 
ATOM   1199  C   VAL    72     -10.546  -5.213   1.432  1.00 53.44           C 
ATOM   1200  O   VAL    72     -10.357  -6.114   2.254  1.00 50.24           O 
ATOM   1201  CB  VAL    72      -8.584  -4.905  -0.138  1.00 55.51           C 
ATOM   1202  CG1 VAL    72      -7.912  -6.202   0.306  1.00 24.42           C 
ATOM   1203  CG2 VAL    72      -9.456  -5.135  -1.372  1.00 31.30           C 
ATOM   1204  H   VAL    72      -8.036  -4.668   2.588  1.00 37.79           H 
ATOM   1205  HA  VAL    72      -9.839  -3.345   0.653  1.00 25.11           H 
ATOM   1206  HB  VAL    72      -7.803  -4.207  -0.409  1.00 74.53           H 
ATOM   1207 1HG1 VAL    72      -8.665  -6.920   0.598  1.00 37.79           H 
ATOM   1208 2HG1 VAL    72      -7.259  -6.005   1.146  1.00 37.79           H 
ATOM   1209 3HG1 VAL    72      -7.332  -6.603  -0.512  1.00 37.79           H 
ATOM   1210 1HG2 VAL    72      -8.857  -5.570  -2.160  1.00 37.79           H 
ATOM   1211 2HG2 VAL    72      -9.861  -4.191  -1.710  1.00 37.79           H 
ATOM   1212 3HG2 VAL    72     -10.267  -5.806  -1.125  1.00 37.79           H 
ATOM   1433  N   LYS    88     -10.565   0.120   0.556  1.00 13.14           N 
ATOM   1434  CA  LYS    88     -11.628   0.878   1.232  1.00 34.52           C 
ATOM   1435  C   LYS    88     -11.065   1.902   2.233  1.00 74.05           C 
ATOM   1436  O   LYS    88     -11.679   2.943   2.476  1.00 35.55           O 
ATOM   1437  CB  LYS    88     -12.598  -0.087   1.938  1.00  4.12           C 
ATOM   1438  CG  LYS    88     -11.936  -1.000   2.970  1.00 35.03           C 
ATOM   1439  CD  LYS    88     -12.904  -2.045   3.527  1.00 34.12           C 
ATOM   1440  CE  LYS    88     -14.118  -1.413   4.198  1.00 34.05           C 
ATOM   1441  NZ  LYS    88     -15.086  -2.440   4.666  1.00 62.25           N 
ATOM   1442  H   LYS    88     -10.290  -0.747   0.923  1.00 37.79           H 
ATOM   1443  HA  LYS    88     -12.177   1.417   0.470  1.00 54.25           H 
ATOM   1444 1HB  LYS    88     -13.070  -0.709   1.190  1.00 37.79           H 
ATOM   1445 2HB  LYS    88     -13.361   0.493   2.439  1.00 37.79           H 
ATOM   1446 1HG  LYS    88     -11.566  -0.393   3.785  1.00 37.79           H 
ATOM   1447 2HG  LYS    88     -11.110  -1.513   2.500  1.00 37.79           H 
ATOM   1448 1HD  LYS    88     -12.379  -2.651   4.252  1.00 37.79           H 
ATOM   1449 2HD  LYS    88     -13.244  -2.673   2.717  1.00 37.79           H 
ATOM   1450 1HE  LYS    88     -14.610  -0.763   3.490  1.00 37.79           H 
ATOM   1451 2HE  LYS    88     -13.785  -0.833   5.047  1.00 37.79           H 
ATOM   1452 1HZ  LYS    88     -15.374  -3.052   3.875  1.00 37.79           H 
ATOM   1453 2HZ  LYS    88     -15.933  -1.983   5.056  1.00 37.79           H 
ATOM   1454 3HZ  LYS    88     -14.657  -3.030   5.405  1.00 37.79           H 
ATOM   1455  N   SER    89      -9.898   1.608   2.810  1.00 25.23           N 
ATOM   1456  CA  SER    89      -9.257   2.510   3.789  1.00 12.22           C 
ATOM   1457  C   SER    89      -7.758   2.223   3.926  1.00 42.34           C 
ATOM   1458  O   SER    89      -7.279   1.170   3.508  1.00 60.11           O 
ATOM   1459  CB  SER    89      -9.916   2.387   5.175  1.00 73.00           C 
ATOM   1460  OG  SER    89     -11.252   2.865   5.172  1.00 43.43           O 
ATOM   1461  H   SER    89      -9.448   0.771   2.567  1.00 37.79           H 
ATOM   1462  HA  SER    89      -9.382   3.523   3.432  1.00 45.21           H 
ATOM   1463 1HB  SER    89      -9.347   2.962   5.893  1.00 37.79           H 
ATOM   1464 2HB  SER    89      -9.925   1.350   5.477  1.00 37.79           H 
ATOM   1465  HG  SER    89     -11.439   3.292   4.326  1.00 35.04           H 
ATOM   1466  N   TYR    90      -7.022   3.162   4.527  1.00 22.31           N 
ATOM   1467  CA  TYR    90      -5.592   2.966   4.800  1.00 52.02           C 
ATOM   1468  C   TYR    90      -5.207   3.534   6.180  1.00 25.35           C 
ATOM   1469  O   TYR    90      -5.932   4.348   6.755  1.00 34.33           O 
ATOM   1470  CB  TYR    90      -4.723   3.600   3.698  1.00  3.22           C 
ATOM   1471  CG  TYR    90      -4.642   5.117   3.751  1.00 12.41           C 
ATOM   1472  CD1 TYR    90      -3.506   5.753   4.246  1.00 14.15           C 
ATOM   1473  CD2 TYR    90      -5.697   5.910   3.312  1.00  1.54           C 
ATOM   1474  CE1 TYR    90      -3.426   7.130   4.300  1.00 61.11           C 
ATOM   1475  CE2 TYR    90      -5.620   7.287   3.362  1.00  4.32           C 
ATOM   1476  CZ  TYR    90      -4.484   7.891   3.858  1.00 71.13           C 
ATOM   1477  OH  TYR    90      -4.410   9.262   3.914  1.00 41.41           O 
ATOM   1478  H   TYR    90      -7.447   4.003   4.793  1.00 37.79           H 
ATOM   1479  HA  TYR    90      -5.407   1.900   4.812  1.00 71.54           H 
ATOM   1480 1HB  TYR    90      -5.124   3.323   2.732  1.00 37.79           H 
ATOM   1481 2HB  TYR    90      -3.717   3.214   3.782  1.00 37.79           H 
ATOM   1482  HD1 TYR    90      -2.675   5.153   4.591  1.00 33.40           H 
ATOM   1483  HD2 TYR    90      -6.586   5.436   2.926  1.00 13.12           H 
ATOM   1484  HE1 TYR    90      -2.535   7.605   4.687  1.00 45.53           H 
ATOM   1485  HE2 TYR    90      -6.450   7.887   3.016  1.00 23.03           H 
ATOM   1486  HH  TYR    90      -5.216   9.603   4.315  1.00  4.41           H 
ATOM   1487  N   GLU    91      -4.061   3.101   6.694  1.00  3.42           N 
ATOM   1488  CA  GLU    91      -3.603   3.473   8.042  1.00 74.55           C 
ATOM   1489  C   GLU    91      -2.085   3.735   8.057  1.00 64.43           C 
ATOM   1490  O   GLU    91      -1.325   2.996   7.444  1.00 14.34           O 
ATOM   1491  CB  GLU    91      -3.963   2.331   9.010  1.00 43.34           C 
ATOM   1492  CG  GLU    91      -3.512   2.534  10.455  1.00 75.05           C 
ATOM   1493  CD  GLU    91      -3.979   1.404  11.367  1.00  3.12           C 
ATOM   1494  OE1 GLU    91      -3.203   0.448  11.599  1.00  3.41           O 
ATOM   1495  OE2 GLU    91      -5.133   1.462  11.849  1.00 20.45           O 
ATOM   1496  H   GLU    91      -3.506   2.499   6.158  1.00 37.79           H 
ATOM   1497  HA  GLU    91      -4.122   4.373   8.344  1.00  1.55           H 
ATOM   1498 1HB  GLU    91      -3.513   1.417   8.644  1.00 37.79           H 
ATOM   1499 2HB  GLU    91      -5.036   2.209   9.011  1.00 37.79           H 
ATOM   1500 1HG  GLU    91      -3.917   3.468  10.821  1.00 37.79           H 
ATOM   1501 2HG  GLU    91      -2.432   2.579  10.479  1.00 37.79           H 
ATOM   1502  N   GLU    92      -1.642   4.781   8.754  1.00 12.34           N 
ATOM   1503  CA  GLU    92      -0.203   5.086   8.848  1.00 71.13           C 
ATOM   1504  C   GLU    92       0.418   4.348  10.044  1.00 52.44           C 
ATOM   1505  O   GLU    92      -0.029   4.509  11.182  1.00 61.33           O 
ATOM   1506  CB  GLU    92       0.022   6.603   8.977  1.00 35.14           C 
ATOM   1507  CG  GLU    92       1.495   7.009   9.066  1.00 11.32           C 
ATOM   1508  CD  GLU    92       1.690   8.510   9.239  1.00 74.44           C 
ATOM   1509  OE1 GLU    92       1.086   9.085  10.172  1.00 65.13           O 
ATOM   1510  OE2 GLU    92       2.458   9.119   8.460  1.00 12.12           O 
ATOM   1511  H   GLU    92      -2.288   5.360   9.214  1.00 37.79           H 
ATOM   1512  HA  GLU    92       0.268   4.736   7.938  1.00 60.42           H 
ATOM   1513 1HB  GLU    92      -0.481   6.954   9.868  1.00 37.79           H 
ATOM   1514 2HB  GLU    92      -0.413   7.093   8.116  1.00 37.79           H 
ATOM   1515 1HG  GLU    92       1.996   6.694   8.161  1.00 37.79           H 
ATOM   1516 2HG  GLU    92       1.942   6.508   9.913  1.00 37.79           H 
ATOM   1517  N   ILE    93       1.441   3.534   9.781  1.00 73.20           N 
ATOM   1518  CA  ILE    93       2.008   2.638  10.800  1.00 20.14           C 
ATOM   1519  C   ILE    93       3.548   2.644  10.822  1.00 22.02           C 
ATOM   1520  O   ILE    93       4.205   3.283   9.994  1.00 32.45           O 
ATOM   1521  CB  ILE    93       1.531   1.178  10.581  1.00 24.51           C 
ATOM   1522  CG1 ILE    93       1.930   0.684   9.178  1.00 61.02           C 
ATOM   1523  CG2 ILE    93       0.021   1.066  10.788  1.00 55.35           C 
ATOM   1524  CD1 ILE    93       1.584  -0.768   8.912  1.00  1.24           C 
ATOM   1525  H   ILE    93       1.831   3.541   8.883  1.00 37.79           H 
ATOM   1526  HA  ILE    93       1.651   2.963  11.767  1.00 34.52           H 
ATOM   1527  HB  ILE    93       2.013   0.555  11.321  1.00 75.22           H 
ATOM   1528 1HG1 ILE    93       2.999   0.797   9.053  1.00 37.79           H 
ATOM   1529 2HG1 ILE    93       1.424   1.282   8.436  1.00 37.79           H 
ATOM   1530 1HG2 ILE    93      -0.280   0.032  10.698  1.00 37.79           H 
ATOM   1531 2HG2 ILE    93      -0.492   1.655  10.043  1.00 37.79           H 
ATOM   1532 3HG2 ILE    93      -0.236   1.429  11.774  1.00 37.79           H 
ATOM   1533 1HD1 ILE    93       1.851  -1.019   7.896  1.00 37.79           H 
ATOM   1534 2HD1 ILE    93       0.525  -0.920   9.053  1.00 37.79           H 
ATOM   1535 3HD1 ILE    93       2.134  -1.400   9.594  1.00 37.79           H 
ATOM   1536  N   GLN    94       4.107   1.907  11.782  1.00 25.52           N 
ATOM   1537  CA  GLN    94       5.559   1.754  11.921  1.00 31.04           C 
ATOM   1538  C   GLN    94       5.989   0.330  11.526  1.00 61.23           C 
ATOM   1539  O   GLN    94       5.148  -0.536  11.281  1.00 31.03           O 
ATOM   1540  CB  GLN    94       5.979   2.053  13.369  1.00 21.14           C 
ATOM   1541  CG  GLN    94       5.425   1.058  14.384  1.00  2.22           C 
ATOM   1542  CD  GLN    94       5.682   1.459  15.826  1.00 30.12           C 
ATOM   1543  OE1 GLN    94       6.704   1.116  16.411  1.00 11.24           O 
ATOM   1544  NE2 GLN    94       4.746   2.171  16.418  1.00  5.21           N 
ATOM   1545  H   GLN    94       3.521   1.437  12.416  1.00 37.79           H 
ATOM   1546  HA  GLN    94       6.040   2.461  11.259  1.00 33.05           H 
ATOM   1547 1HB  GLN    94       5.629   3.041  13.634  1.00 37.79           H 
ATOM   1548 2HB  GLN    94       7.059   2.036  13.430  1.00 37.79           H 
ATOM   1549 1HG  GLN    94       5.884   0.095  14.207  1.00 37.79           H 
ATOM   1550 2HG  GLN    94       4.358   0.974  14.237  1.00 37.79           H 
ATOM   1551 1HE2 GLN    94       3.944   2.401  15.904  1.00 37.79           H 
ATOM   1552 2HE2 GLN    94       4.889   2.436  17.348  1.00 37.79           H 
ATOM   1553  N   LYS    95       7.298   0.085  11.478  1.00  5.41           N 
ATOM   1554  CA  LYS    95       7.824  -1.236  11.098  1.00 60.52           C 
ATOM   1555  C   LYS    95       7.325  -2.344  12.049  1.00 64.21           C 
ATOM   1556  O   LYS    95       7.222  -3.509  11.660  1.00 61.24           O 
ATOM   1557  CB  LYS    95       9.358  -1.203  11.078  1.00 60.14           C 
ATOM   1558  CG  LYS    95      10.003  -2.482  10.550  1.00 42.14           C 
ATOM   1559  CD  LYS    95      11.525  -2.406  10.602  1.00 61.43           C 
ATOM   1560  CE  LYS    95      12.179  -3.706  10.147  1.00 51.12           C 
ATOM   1561  NZ  LYS    95      13.660  -3.649  10.257  1.00 60.40           N 
ATOM   1562  H   LYS    95       7.927   0.802  11.703  1.00 37.79           H 
ATOM   1563  HA  LYS    95       7.468  -1.454  10.101  1.00 70.35           H 
ATOM   1564 1HB  LYS    95       9.715  -1.033  12.085  1.00 37.79           H 
ATOM   1565 2HB  LYS    95       9.679  -0.380  10.453  1.00 37.79           H 
ATOM   1566 1HG  LYS    95       9.691  -2.635   9.525  1.00 37.79           H 
ATOM   1567 2HG  LYS    95       9.675  -3.315  11.156  1.00 37.79           H 
ATOM   1568 1HD  LYS    95      11.830  -2.196  11.618  1.00 37.79           H 
ATOM   1569 2HD  LYS    95      11.859  -1.607   9.955  1.00 37.79           H 
ATOM   1570 1HE  LYS    95      11.910  -3.891   9.117  1.00 37.79           H 
ATOM   1571 2HE  LYS    95      11.816  -4.514  10.764  1.00 37.79           H 
ATOM   1572 1HZ  LYS    95      14.038  -2.903   9.638  1.00 37.79           H 
ATOM   1573 2HZ  LYS    95      14.076  -4.562   9.983  1.00 37.79           H 
ATOM   1574 3HZ  LYS    95      13.939  -3.442  11.238  1.00 37.79           H 
ATOM   1575  N   ALA    96       7.012  -1.969  13.289  1.00 42.05           N 
ATOM   1576  CA  ALA    96       6.493  -2.915  14.286  1.00  2.42           C 
ATOM   1577  C   ALA    96       5.117  -3.490  13.893  1.00  3.13           C 
ATOM   1578  O   ALA    96       4.809  -4.643  14.207  1.00 40.35           O 
ATOM   1579  CB  ALA    96       6.409  -2.241  15.649  1.00 70.41           C 
ATOM   1580  H   ALA    96       7.150  -1.034  13.551  1.00 37.79           H 
ATOM   1581  HA  ALA    96       7.199  -3.731  14.363  1.00 43.25           H 
ATOM   1582 1HB  ALA    96       5.684  -1.440  15.611  1.00 37.79           H 
ATOM   1583 2HB  ALA    96       7.376  -1.838  15.913  1.00 37.79           H 
ATOM   1584 3HB  ALA    96       6.107  -2.965  16.392  1.00 37.79           H 
ATOM   1585  N   ASP    97       4.290  -2.685  13.218  1.00 32.43           N 
ATOM   1586  CA  ASP    97       2.965  -3.141  12.770  1.00 44.52           C 
ATOM   1587  C   ASP    97       3.079  -4.138  11.604  1.00 21.31           C 
ATOM   1588  O   ASP    97       2.160  -4.917  11.342  1.00 22.43           O 
ATOM   1589  CB  ASP    97       2.101  -1.947  12.348  1.00  2.13           C 
ATOM   1590  CG  ASP    97       1.852  -0.971  13.484  1.00 13.33           C 
ATOM   1591  OD1 ASP    97       2.567   0.048  13.570  1.00 15.33           O 
ATOM   1592  OD2 ASP    97       0.936  -1.217  14.298  1.00 62.34           O 
ATOM   1593  H   ASP    97       4.573  -1.767  13.014  1.00 37.79           H 
ATOM   1594  HA  ASP    97       2.489  -3.638  13.603  1.00 42.11           H 
ATOM   1595 1HB  ASP    97       1.145  -2.310  11.992  1.00 37.79           H 
ATOM   1596 2HB  ASP    97       2.597  -1.419  11.545  1.00 37.79           H 
ATOM   1597  N   LEU    98       4.214  -4.106  10.912  1.00 23.41           N 
ATOM   1598  CA  LEU    98       4.457  -4.993   9.774  1.00  3.22           C 
ATOM   1599  C   LEU    98       4.758  -6.425  10.239  1.00  0.12           C 
ATOM   1600  O   LEU    98       5.502  -6.628  11.202  1.00  2.31           O 
ATOM   1601  CB  LEU    98       5.645  -4.477   8.948  1.00 40.31           C 
ATOM   1602  CG  LEU    98       5.532  -3.029   8.442  1.00 44.24           C 
ATOM   1603  CD1 LEU    98       6.805  -2.617   7.705  1.00 62.02           C 
ATOM   1604  CD2 LEU    98       4.309  -2.861   7.543  1.00 22.32           C 
ATOM   1605  H   LEU    98       4.912  -3.474  11.179  1.00 37.79           H 
ATOM   1606  HA  LEU    98       3.573  -4.997   9.155  1.00 24.10           H 
ATOM   1607 1HB  LEU    98       5.768  -5.125   8.091  1.00 37.79           H 
ATOM   1608 2HB  LEU    98       6.535  -4.550   9.558  1.00 37.79           H 
ATOM   1609  HG  LEU    98       5.414  -2.369   9.289  1.00 23.45           H 
ATOM   1610 1HD1 LEU    98       6.721  -1.587   7.387  1.00 37.79           H 
ATOM   1611 2HD1 LEU    98       6.948  -3.249   6.839  1.00 37.79           H 
ATOM   1612 3HD1 LEU    98       7.653  -2.718   8.366  1.00 37.79           H 
ATOM   1613 1HD2 LEU    98       3.413  -3.088   8.105  1.00 37.79           H 
ATOM   1614 2HD2 LEU    98       4.382  -3.532   6.699  1.00 37.79           H 
ATOM   1615 3HD2 LEU    98       4.260  -1.842   7.189  1.00 37.79           H 
ATOM   1616  N   PRO    99       4.185  -7.445   9.567  1.00 33.35           N 
ATOM   1617  CA  PRO    99       4.536  -8.848   9.830  1.00 25.44           C 
ATOM   1618  C   PRO    99       5.992  -9.156   9.433  1.00 43.55           C 
ATOM   1619  O   PRO    99       6.576  -8.458   8.599  1.00 11.51           O 
ATOM   1620  CB  PRO    99       3.544  -9.643   8.964  1.00 64.23           C 
ATOM   1621  CG  PRO    99       3.107  -8.691   7.903  1.00 64.33           C 
ATOM   1622  CD  PRO    99       3.149  -7.318   8.523  1.00 12.14           C 
ATOM   1623  HA  PRO    99       4.391  -9.099  10.873  1.00  4.13           H 
ATOM   1624 1HB  PRO    99       2.708  -9.965   9.569  1.00 37.79           H 
ATOM   1625 2HB  PRO    99       4.037 -10.507   8.539  1.00 37.79           H 
ATOM   1626 1HG  PRO    99       2.101  -8.929   7.585  1.00 37.79           H 
ATOM   1627 2HG  PRO    99       3.784  -8.744   7.062  1.00 37.79           H 
ATOM   1628 1HD  PRO    99       2.191  -7.070   8.959  1.00 37.79           H 
ATOM   1629 2HD  PRO    99       3.431  -6.580   7.784  1.00 37.79           H 
ATOM   1630  N   GLU   100       6.563 -10.207  10.021  1.00 23.10           N 
ATOM   1631  CA  GLU   100       7.989 -10.537   9.848  1.00 74.33           C 
ATOM   1632  C   GLU   100       8.430 -10.547   8.375  1.00 74.30           C 
ATOM   1633  O   GLU   100       9.502 -10.049   8.034  1.00 20.33           O 
ATOM   1634  CB  GLU   100       8.298 -11.900  10.471  1.00  2.53           C 
ATOM   1635  CG  GLU   100       9.788 -12.229  10.511  1.00 43.34           C 
ATOM   1636  CD  GLU   100      10.058 -13.681  10.874  1.00 22.51           C 
ATOM   1637  OE1 GLU   100      10.762 -14.371  10.105  1.00 70.02           O 
ATOM   1638  OE2 GLU   100       9.538 -14.152  11.909  1.00 13.11           O 
ATOM   1639  H   GLU   100       6.012 -10.781  10.593  1.00 37.79           H 
ATOM   1640  HA  GLU   100       8.560  -9.784  10.371  1.00 21.22           H 
ATOM   1641 1HB  GLU   100       7.794 -12.669   9.901  1.00 37.79           H 
ATOM   1642 2HB  GLU   100       7.921 -11.913  11.484  1.00 37.79           H 
ATOM   1643 1HG  GLU   100      10.265 -11.589  11.243  1.00 37.79           H 
ATOM   1644 2HG  GLU   100      10.212 -12.031   9.535  1.00 37.79           H 
ATOM   1645  N   LYS   101       7.611 -11.119   7.504  1.00 25.44           N 
ATOM   1646  CA  LYS   101       7.970 -11.214   6.087  1.00 34.04           C 
ATOM   1647  C   LYS   101       8.005  -9.825   5.423  1.00 63.15           C 
ATOM   1648  O   LYS   101       8.966  -9.477   4.735  1.00 55.54           O 
ATOM   1649  CB  LYS   101       6.993 -12.136   5.341  1.00 25.52           C 
ATOM   1650  CG  LYS   101       6.762 -13.483   6.030  1.00 13.22           C 
ATOM   1651  CD  LYS   101       8.067 -14.181   6.423  1.00 21.22           C 
ATOM   1652  CE  LYS   101       8.953 -14.503   5.224  1.00 24.33           C 
ATOM   1653  NZ  LYS   101      10.209 -15.180   5.639  1.00 25.43           N 
ATOM   1654  H   LYS   101       6.762 -11.494   7.818  1.00 37.79           H 
ATOM   1655  HA  LYS   101       8.960 -11.645   6.032  1.00 31.13           H 
ATOM   1656 1HB  LYS   101       7.381 -12.327   4.350  1.00 37.79           H 
ATOM   1657 2HB  LYS   101       6.039 -11.636   5.252  1.00 37.79           H 
ATOM   1658 1HG  LYS   101       6.209 -14.126   5.357  1.00 37.79           H 
ATOM   1659 2HG  LYS   101       6.178 -13.318   6.924  1.00 37.79           H 
ATOM   1660 1HD  LYS   101       7.823 -15.103   6.931  1.00 37.79           H 
ATOM   1661 2HD  LYS   101       8.618 -13.540   7.096  1.00 37.79           H 
ATOM   1662 1HE  LYS   101       9.202 -13.583   4.713  1.00 37.79           H 
ATOM   1663 2HE  LYS   101       8.412 -15.153   4.552  1.00 37.79           H 
ATOM   1664 1HZ  LYS   101       9.988 -16.090   6.099  1.00 37.79           H 
ATOM   1665 2HZ  LYS   101      10.733 -14.585   6.312  1.00 37.79           H 
ATOM   1666 3HZ  LYS   101      10.810 -15.361   4.812  1.00 37.79           H 
ATOM   1667  N   VAL   102       6.963  -9.031   5.665  1.00 51.42           N 
ATOM   1668  CA  VAL   102       6.828  -7.700   5.057  1.00 13.14           C 
ATOM   1669  C   VAL   102       7.961  -6.743   5.467  1.00 70.44           C 
ATOM   1670  O   VAL   102       8.545  -6.062   4.620  1.00 25.33           O 
ATOM   1671  CB  VAL   102       5.462  -7.068   5.423  1.00 61.20           C 
ATOM   1672  CG1 VAL   102       5.408  -5.593   5.034  1.00 13.43           C 
ATOM   1673  CG2 VAL   102       4.328  -7.841   4.758  1.00 22.51           C 
ATOM   1674  H   VAL   102       6.268  -9.343   6.278  1.00 37.79           H 
ATOM   1675  HA  VAL   102       6.858  -7.827   3.984  1.00 21.35           H 
ATOM   1676  HB  VAL   102       5.333  -7.139   6.495  1.00  3.12           H 
ATOM   1677 1HG1 VAL   102       4.439  -5.186   5.285  1.00 37.79           H 
ATOM   1678 2HG1 VAL   102       5.577  -5.490   3.971  1.00 37.79           H 
ATOM   1679 3HG1 VAL   102       6.173  -5.051   5.573  1.00 37.79           H 
ATOM   1680 1HG2 VAL   102       3.380  -7.404   5.040  1.00 37.79           H 
ATOM   1681 2HG2 VAL   102       4.357  -8.872   5.079  1.00 37.79           H 
ATOM   1682 3HG2 VAL   102       4.438  -7.793   3.685  1.00 37.79           H 
ATOM   1683  N   LYS   103       8.267  -6.689   6.763  1.00  4.22           N 
ATOM   1684  CA  LYS   103       9.319  -5.797   7.268  1.00 40.22           C 
ATOM   1685  C   LYS   103      10.663  -6.060   6.565  1.00 22.05           C 
ATOM   1686  O   LYS   103      11.366  -5.121   6.183  1.00 23.14           O 
ATOM   1687  CB  LYS   103       9.454  -5.941   8.792  1.00 74.03           C 
ATOM   1688  CG  LYS   103       9.708  -7.371   9.259  1.00 15.33           C 
ATOM   1689  CD  LYS   103       9.812  -7.487  10.781  1.00 12.30           C 
ATOM   1690  CE  LYS   103       8.589  -6.903  11.481  1.00 25.02           C 
ATOM   1691  NZ  LYS   103       8.674  -7.032  12.957  1.00 33.23           N 
ATOM   1692  H   LYS   103       7.779  -7.263   7.393  1.00 37.79           H 
ATOM   1693  HA  LYS   103       9.013  -4.784   7.044  1.00 53.12           H 
ATOM   1694 1HB  LYS   103       8.539  -5.589   9.252  1.00 37.79           H 
ATOM   1695 2HB  LYS   103      10.275  -5.323   9.130  1.00 37.79           H 
ATOM   1696 1HG  LYS   103      10.632  -7.720   8.819  1.00 37.79           H 
ATOM   1697 2HG  LYS   103       8.894  -7.996   8.919  1.00 37.79           H 
ATOM   1698 1HD  LYS   103      10.696  -6.968  11.116  1.00 37.79           H 
ATOM   1699 2HD  LYS   103       9.892  -8.533  11.043  1.00 37.79           H 
ATOM   1700 1HE  LYS   103       7.708  -7.425  11.134  1.00 37.79           H 
ATOM   1701 2HE  LYS   103       8.506  -5.856  11.227  1.00 37.79           H 
ATOM   1702 1HZ  LYS   103       7.821  -6.640  13.402  1.00 37.79           H 
ATOM   1703 2HZ  LYS   103       9.503  -6.520  13.316  1.00 37.79           H 
ATOM   1704 3HZ  LYS   103       8.762  -8.032  13.226  1.00 37.79           H 
ATOM   1705  N   ASP   104      11.001  -7.336   6.374  1.00 74.33           N 
ATOM   1706  CA  ASP   104      12.207  -7.715   5.631  1.00 74.15           C 
ATOM   1707  C   ASP   104      12.101  -7.350   4.136  1.00  4.45           C 
ATOM   1708  O   ASP   104      13.108  -7.033   3.495  1.00 11.44           O 
ATOM   1709  CB  ASP   104      12.493  -9.215   5.795  1.00 11.15           C 
ATOM   1710  CG  ASP   104      12.748  -9.615   7.241  1.00 62.31           C 
ATOM   1711  OD1 ASP   104      12.447 -10.771   7.606  1.00 10.55           O 
ATOM   1712  OD2 ASP   104      13.282  -8.786   8.009  1.00 25.44           O 
ATOM   1713  H   ASP   104      10.432  -8.041   6.752  1.00 37.79           H 
ATOM   1714  HA  ASP   104      13.033  -7.162   6.056  1.00 43.15           H 
ATOM   1715 1HB  ASP   104      13.366  -9.472   5.213  1.00 37.79           H 
ATOM   1716 2HB  ASP   104      11.646  -9.780   5.429  1.00 37.79           H 
ATOM   1717  N   LYS   105      10.884  -7.388   3.586  1.00  1.14           N 
ATOM   1718  CA  LYS   105      10.652  -7.024   2.178  1.00 20.34           C 
ATOM   1719  C   LYS   105      10.869  -5.520   1.926  1.00 22.43           C 
ATOM   1720  O   LYS   105      11.214  -5.114   0.815  1.00 61.23           O 
ATOM   1721  CB  LYS   105       9.231  -7.418   1.746  1.00 35.05           C 
ATOM   1722  CG  LYS   105       8.976  -8.923   1.739  1.00 42.20           C 
ATOM   1723  CD  LYS   105       9.871  -9.656   0.739  1.00 61.44           C 
ATOM   1724  CE  LYS   105       9.601  -9.221  -0.699  1.00 30.51           C 
ATOM   1725  NZ  LYS   105      10.407  -9.998  -1.678  1.00 21.42           N 
ATOM   1726  H   LYS   105      10.122  -7.675   4.136  1.00 37.79           H 
ATOM   1727  HA  LYS   105      11.362  -7.578   1.577  1.00 21.31           H 
ATOM   1728 1HB  LYS   105       9.052  -7.042   0.748  1.00 37.79           H 
ATOM   1729 2HB  LYS   105       8.523  -6.959   2.422  1.00 37.79           H 
ATOM   1730 1HG  LYS   105       7.941  -9.101   1.480  1.00 37.79           H 
ATOM   1731 2HG  LYS   105       9.168  -9.314   2.727  1.00 37.79           H 
ATOM   1732 1HD  LYS   105       9.691 -10.720   0.823  1.00 37.79           H 
ATOM   1733 2HD  LYS   105      10.903  -9.448   0.976  1.00 37.79           H 
ATOM   1734 1HE  LYS   105       9.846  -8.173  -0.799  1.00 37.79           H 
ATOM   1735 2HE  LYS   105       8.554  -9.366  -0.919  1.00 37.79           H 
ATOM   1736 1HZ  LYS   105      10.169 -11.008  -1.617  1.00 37.79           H 
ATOM   1737 2HZ  LYS   105      11.421  -9.880  -1.480  1.00 37.79           H 
ATOM   1738 3HZ  LYS   105      10.215  -9.665  -2.643  1.00 37.79           H 
ATOM   1739  N   PHE   106      10.639  -4.696   2.951  1.00 53.42           N 
ATOM   1740  CA  PHE   106      10.887  -3.249   2.851  1.00 43.42           C 
ATOM   1741  C   PHE   106      12.367  -2.904   3.084  1.00 20.54           C 
ATOM   1742  O   PHE   106      12.974  -2.164   2.309  1.00 24.40           O 
ATOM   1743  CB  PHE   106      10.014  -2.471   3.852  1.00 50.33           C 
ATOM   1744  CG  PHE   106       8.601  -2.227   3.381  1.00 62.42           C 
ATOM   1745  CD1 PHE   106       7.528  -2.912   3.937  1.00 31.22           C 
ATOM   1746  CD2 PHE   106       8.346  -1.298   2.381  1.00 64.05           C 
ATOM   1747  CE1 PHE   106       6.235  -2.673   3.505  1.00 24.10           C 
ATOM   1748  CE2 PHE   106       7.055  -1.060   1.947  1.00  3.31           C 
ATOM   1749  CZ  PHE   106       6.000  -1.747   2.510  1.00  3.33           C 
ATOM   1750  H   PHE   106      10.282  -5.067   3.788  1.00 37.79           H 
ATOM   1751  HA  PHE   106      10.620  -2.942   1.849  1.00 70.40           H 
ATOM   1752 1HB  PHE   106      10.470  -1.508   4.043  1.00 37.79           H 
ATOM   1753 2HB  PHE   106       9.965  -3.024   4.779  1.00 37.79           H 
ATOM   1754  HD1 PHE   106       7.706  -3.639   4.716  1.00 43.04           H 
ATOM   1755  HD2 PHE   106       9.169  -0.756   1.938  1.00 62.33           H 
ATOM   1756  HE1 PHE   106       5.408  -3.214   3.945  1.00 51.23           H 
ATOM   1757  HE2 PHE   106       6.873  -0.334   1.167  1.00 25.15           H 
ATOM   1758  HZ  PHE   106       4.990  -1.562   2.172  1.00 20.52           H 
ATOM   1759  N   THR   107      12.947  -3.437   4.157  1.00 21.33           N 
ATOM   1760  CA  THR   107      14.325  -3.087   4.538  1.00 14.34           C 
ATOM   1761  C   THR   107      15.379  -3.877   3.741  1.00 32.33           C 
ATOM   1762  O   THR   107      16.541  -3.475   3.670  1.00 15.42           O 
ATOM   1763  CB  THR   107      14.565  -3.308   6.052  1.00 41.25           C 
ATOM   1764  OG1 THR   107      15.868  -2.839   6.424  1.00  5.12           O 
ATOM   1765  CG2 THR   107      14.434  -4.778   6.433  1.00 24.43           C 
ATOM   1766  H   THR   107      12.441  -4.072   4.709  1.00 37.79           H 
ATOM   1767  HA  THR   107      14.463  -2.032   4.333  1.00 75.15           H 
ATOM   1768  HB  THR   107      13.822  -2.744   6.601  1.00 52.25           H 
ATOM   1769  HG1 THR   107      15.791  -2.301   7.221  1.00 35.33           H 
ATOM   1770 1HG2 THR   107      13.462  -5.144   6.137  1.00 37.79           H 
ATOM   1771 2HG2 THR   107      14.548  -4.886   7.501  1.00 37.79           H 
ATOM   1772 3HG2 THR   107      15.201  -5.349   5.932  1.00 37.79           H 
ATOM   1773  N   ILE   108      14.966  -4.995   3.136  1.00  3.54           N 
ATOM   1774  CA  ILE   108      15.882  -5.865   2.378  1.00 14.53           C 
ATOM   1775  C   ILE   108      17.036  -6.372   3.279  1.00 41.22           C 
ATOM   1776  O   ILE   108      18.187  -6.486   2.853  1.00  3.13           O 
ATOM   1777  CB  ILE   108      16.441  -5.136   1.117  1.00 33.21           C 
ATOM   1778  CG1 ILE   108      15.298  -4.470   0.327  1.00 71.54           C 
ATOM   1779  CG2 ILE   108      17.207  -6.104   0.211  1.00 45.30           C 
ATOM   1780  CD1 ILE   108      14.257  -5.444  -0.192  1.00 62.14           C 
ATOM   1781  H   ILE   108      14.017  -5.239   3.187  1.00 37.79           H 
ATOM   1782  HA  ILE   108      15.310  -6.721   2.047  1.00 62.10           H 
ATOM   1783  HB  ILE   108      17.130  -4.371   1.446  1.00 75.20           H 
ATOM   1784 1HG1 ILE   108      15.714  -3.945  -0.522  1.00 37.79           H 
ATOM   1785 2HG1 ILE   108      14.793  -3.762   0.967  1.00 37.79           H 
ATOM   1786 1HG2 ILE   108      18.039  -6.526   0.755  1.00 37.79           H 
ATOM   1787 2HG2 ILE   108      17.576  -5.575  -0.656  1.00 37.79           H 
ATOM   1788 3HG2 ILE   108      16.548  -6.900  -0.108  1.00 37.79           H 
ATOM   1789 1HD1 ILE   108      13.496  -4.901  -0.733  1.00 37.79           H 
ATOM   1790 2HD1 ILE   108      13.805  -5.966   0.638  1.00 37.79           H 
ATOM   1791 3HD1 ILE   108      14.728  -6.157  -0.853  1.00 37.79           H 
END
