
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   65 ( 1055),  selected   65 , name 1yww_A
# Molecule2: number of CA atoms   63 (  926),  selected   63 , name T0469.pdb
# PARAMETERS: 1yww_A.T0469.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    N     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    D     4_A      Q       3          3.983
LGA    V     5_A      K       4          1.995
LGA    I     6_A      F       5          3.101
LGA    K     7_A      T       6           #
LGA    G     8_A      K       7           -
LGA    -       -      D       8           -
LGA    -       -      M       9           -
LGA    -       -      T      10           -
LGA    -       -      F      11           -
LGA    -       -      A      12           -
LGA    K     9_A      Q      13          4.814
LGA    W    10_A      A      14          2.816
LGA    K    11_A      L      15          4.641
LGA    Q    12_A      Q      16          0.570
LGA    L    13_A      T      17          3.877
LGA    T    14_A      H      18           #
LGA    G    15_A      P      19          4.603
LGA    K    16_A      G      20          3.011
LGA    I    17_A      V      21          2.753
LGA    K    18_A      A      22          2.724
LGA    E    19_A      G      23          0.995
LGA    R    20_A      V      24          0.647
LGA    W    21_A      L      25          2.401
LGA    G    22_A      R      26          1.393
LGA    -       -      S      27           -
LGA    -       -      Y      28           -
LGA    D    23_A      N      29          1.825
LGA    L    24_A      L      30          1.323
LGA    T    25_A      G      31          3.229
LGA    -       -      C      32           -
LGA    -       -      I      33           -
LGA    D    26_A      G      34          3.095
LGA    D    27_A      C      35          4.623
LGA    -       -      M      36           -
LGA    D    28_A      G      37          3.743
LGA    L    29_A      A      38          4.376
LGA    Q    30_A      Q      39          2.213
LGA    A    31_A      N      40          1.536
LGA    A    32_A      E      41          4.621
LGA    D    33_A      -       -           -
LGA    G    34_A      -       -           -
LGA    H    35_A      -       -           -
LGA    A    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    Y    38_A      S      42          1.979
LGA    L    39_A      L      43          1.288
LGA    V    40_A      E      44          1.872
LGA    G    41_A      Q      45          1.531
LGA    K    42_A      G      46          0.729
LGA    L    43_A      A      47          1.331
LGA    Q    44_A      N      48          1.197
LGA    E    45_A      A      49          0.746
LGA    R    46_A      H      50          1.907
LGA    Y    47_A      -       -           -
LGA    G    48_A      G      51          0.507
LGA    W    49_A      L      52          3.030
LGA    S    50_A      -       -           -
LGA    K    51_A      -       -           -
LGA    E    52_A      -       -           -
LGA    R    53_A      N      53          3.872
LGA    A    54_A      V      54          2.629
LGA    E    55_A      E      55          0.500
LGA    Q    56_A      D      56          2.262
LGA    E    57_A      I      57          2.455
LGA    V    58_A      L      58          1.507
LGA    R    59_A      R      59          2.006
LGA    D    60_A      D      60          1.785
LGA    F    61_A      L      61          1.017
LGA    S    62_A      N      62          0.877
LGA    D    63_A      A      63          1.553
LGA    R    64_A      L      64          1.395
LGA    L    65_A      A      65          1.278

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   65   63    5.0     50    2.61    16.00     53.147     1.848

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.701848 * X  +  -0.274855 * Y  +  -0.657163 * Z  +  -4.734059
  Y_new =   0.525767 * X  +   0.422559 * Y  +  -0.738250 * Z  +  -3.478899
  Z_new =   0.480602 * X  +  -0.863654 * Y  +  -0.152063 * Z  +  -2.144418 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.745079    1.396514  [ DEG:   -99.9857     80.0143 ]
  Theta =  -0.501341   -2.640252  [ DEG:   -28.7247   -151.2753 ]
  Phi   =   2.498657   -0.642936  [ DEG:   143.1625    -36.8375 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yww_A                                        
REMARK     2: T0469.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yww_A.T0469.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   65   63   5.0   50   2.61   16.00  53.147
REMARK  ---------------------------------------------------------- 
MOLECULE 1yww_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-FEB-05   1YWW              
TITLE     NMR STRUCTURE OF P. AERUGINOSA PROTEIN PA4738: NORTHEAST              
TITLE    2 STRUCTURAL GENOMICS CONSORTIUM TARGET PAP2                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA4738;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 GENE: PA4738;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PET28B                                
KEYWDS    STRUCTURAL GENOMICS, YJBJ, PSI, PROTEIN STRUCTURE                     
KEYWDS   2 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, NESG           
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    J.R.CORT,S.NI,G.T.MONTELIONE,M.A.KENNEDY,NORTHEAST                    
AUTHOR   2 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   2   06-SEP-05 1YWW    1       JRNL   AUTHOR                            
REVDAT   1   29-MAR-05 1YWW    0                                                
JRNL        AUTH   J.R.CORT,S.NI,G.T.MONTELIONE,M.A.KENNEDY                     
JRNL        TITL   NMR STRUCTURE OF PSEUDOMONAS AERUGINOSA PROTEIN              
JRNL        TITL 2 PA4738                                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1YWW A    1    65  UNP    Q9HV61   Y4738_PSEAE      1     65             
SEQRES   1 A   85  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A   85  LEU VAL PRO ARG GLY SER HIS MET ASN SER ASP VAL ILE          
SEQRES   3 A   85  LYS GLY LYS TRP LYS GLN LEU THR GLY LYS ILE LYS GLU          
SEQRES   4 A   85  ARG TRP GLY ASP LEU THR ASP ASP ASP LEU GLN ALA ALA          
SEQRES   5 A   85  ASP GLY HIS ALA GLU TYR LEU VAL GLY LYS LEU GLN GLU          
SEQRES   6 A   85  ARG TYR GLY TRP SER LYS GLU ARG ALA GLU GLN GLU VAL          
SEQRES   7 A   85  ARG ASP PHE SER ASP ARG LEU                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1     -16.070  12.570  -1.250  1.00  0.00           N  
ATOM      2  CA  MET A   1     -15.127  12.400  -0.119  1.00  0.00           C  
ATOM      3  C   MET A   1     -14.528  10.995  -0.127  1.00  0.00           C  
ATOM      4  O   MET A   1     -13.438  10.770   0.397  1.00  0.00           O  
ATOM      5  CB  MET A   1     -15.828  12.653   1.224  1.00  0.00           C  
ATOM      6  CG  MET A   1     -16.834  11.580   1.629  1.00  0.00           C  
ATOM      7  SD  MET A   1     -18.266  11.500   0.532  1.00  0.00           S  
ATOM      8  CE  MET A   1     -19.174  10.132   1.254  1.00  0.00           C  
ATOM      9  H   MET A   1     -16.835  11.868  -1.189  1.00  0.00           H  
ATOM     10  HA  MET A   1     -14.327  13.117  -0.239  1.00  0.00           H  
ATOM     11  HB2 MET A   1     -15.077  12.716   1.999  1.00  0.00           H  
ATOM     12  HB3 MET A   1     -16.348  13.599   1.170  1.00  0.00           H  
ATOM     13  HG2 MET A   1     -16.337  10.622   1.613  1.00  0.00           H  
ATOM     14  HG3 MET A   1     -17.177  11.788   2.632  1.00  0.00           H  
ATOM     15  HE1 MET A   1     -20.080   9.965   0.690  1.00  0.00           H  
ATOM     16  HE2 MET A   1     -19.427  10.367   2.277  1.00  0.00           H  
ATOM     17  HE3 MET A   1     -18.565   9.242   1.229  1.00  0.00           H  
ATOM     18  N   ASN A   2     -15.243  10.051  -0.729  1.00  0.00           N  
ATOM     19  CA  ASN A   2     -14.793   8.671  -0.787  1.00  0.00           C  
ATOM     20  C   ASN A   2     -14.492   8.293  -2.227  1.00  0.00           C  
ATOM     21  O   ASN A   2     -15.402   8.170  -3.043  1.00  0.00           O  
ATOM     22  CB  ASN A   2     -15.862   7.735  -0.214  1.00  0.00           C  
ATOM     23  CG  ASN A   2     -15.439   6.275  -0.240  1.00  0.00           C  
ATOM     24  OD1 ASN A   2     -15.637   5.574  -1.232  1.00  0.00           O  
ATOM     25  ND2 ASN A   2     -14.874   5.802   0.861  1.00  0.00           N  
ATOM     26  H   ASN A   2     -16.094  10.290  -1.163  1.00  0.00           H  
ATOM     27  HA  ASN A   2     -13.891   8.585  -0.201  1.00  0.00           H  
ATOM     28  HB2 ASN A   2     -16.062   8.010   0.811  1.00  0.00           H  
ATOM     29  HB3 ASN A   2     -16.767   7.838  -0.793  1.00  0.00           H  
ATOM     30 HD21 ASN A   2     -14.762   6.414   1.630  1.00  0.00           H  
ATOM     31 HD22 ASN A   2     -14.591   4.864   0.869  1.00  0.00           H  
ATOM     32  N   SER A   3     -13.215   8.153  -2.542  1.00  0.00           N  
ATOM     33  CA  SER A   3     -12.789   7.766  -3.875  1.00  0.00           C  
ATOM     34  C   SER A   3     -11.467   7.020  -3.793  1.00  0.00           C  
ATOM     35  O   SER A   3     -10.509   7.506  -3.187  1.00  0.00           O  
ATOM     36  CB  SER A   3     -12.647   9.003  -4.767  1.00  0.00           C  
ATOM     37  OG  SER A   3     -13.875   9.712  -4.862  1.00  0.00           O  
ATOM     38  H   SER A   3     -12.533   8.318  -1.859  1.00  0.00           H  
ATOM     39  HA  SER A   3     -13.538   7.110  -4.293  1.00  0.00           H  
ATOM     40  HB2 SER A   3     -11.898   9.659  -4.351  1.00  0.00           H  
ATOM     41  HB3 SER A   3     -12.345   8.696  -5.758  1.00  0.00           H  
ATOM     42  HG  SER A   3     -14.605   9.106  -4.674  1.00  0.00           H  
ATOM     43  N   ASP A   4     -11.421   5.834  -4.382  1.00  0.00           N  
ATOM     44  CA  ASP A   4     -10.208   5.032  -4.371  1.00  0.00           C  
ATOM     45  C   ASP A   4      -9.289   5.487  -5.496  1.00  0.00           C  
ATOM     46  O   ASP A   4      -9.389   5.022  -6.632  1.00  0.00           O  
ATOM     47  CB  ASP A   4     -10.534   3.540  -4.514  1.00  0.00           C  
ATOM     48  CG  ASP A   4      -9.341   2.637  -4.237  1.00  0.00           C  
ATOM     49  OD1 ASP A   4      -8.239   2.908  -4.761  1.00  0.00           O  
ATOM     50  OD2 ASP A   4      -9.511   1.647  -3.490  1.00  0.00           O  
ATOM     51  H   ASP A   4     -12.217   5.494  -4.849  1.00  0.00           H  
ATOM     52  HA  ASP A   4      -9.710   5.197  -3.428  1.00  0.00           H  
ATOM     53  HB2 ASP A   4     -11.319   3.284  -3.820  1.00  0.00           H  
ATOM     54  HB3 ASP A   4     -10.878   3.351  -5.523  1.00  0.00           H  
ATOM     55  N   VAL A   5      -8.424   6.437  -5.181  1.00  0.00           N  
ATOM     56  CA  VAL A   5      -7.473   6.955  -6.152  1.00  0.00           C  
ATOM     57  C   VAL A   5      -6.225   6.086  -6.187  1.00  0.00           C  
ATOM     58  O   VAL A   5      -5.339   6.274  -7.026  1.00  0.00           O  
ATOM     59  CB  VAL A   5      -7.078   8.414  -5.833  1.00  0.00           C  
ATOM     60  CG1 VAL A   5      -8.299   9.323  -5.881  1.00  0.00           C  
ATOM     61  CG2 VAL A   5      -6.390   8.504  -4.478  1.00  0.00           C  
ATOM     62  H   VAL A   5      -8.432   6.808  -4.273  1.00  0.00           H  
ATOM     63  HA  VAL A   5      -7.943   6.933  -7.125  1.00  0.00           H  
ATOM     64  HB  VAL A   5      -6.381   8.748  -6.588  1.00  0.00           H  
ATOM     65 HG11 VAL A   5      -8.003  10.334  -5.648  1.00  0.00           H  
ATOM     66 HG12 VAL A   5      -9.029   8.986  -5.159  1.00  0.00           H  
ATOM     67 HG13 VAL A   5      -8.730   9.294  -6.870  1.00  0.00           H  
ATOM     68 HG21 VAL A   5      -5.486   7.912  -4.494  1.00  0.00           H  
ATOM     69 HG22 VAL A   5      -7.053   8.127  -3.712  1.00  0.00           H  
ATOM     70 HG23 VAL A   5      -6.143   9.534  -4.266  1.00  0.00           H  
ATOM     71  N   ILE A   6      -6.180   5.119  -5.284  1.00  0.00           N  
ATOM     72  CA  ILE A   6      -5.031   4.247  -5.150  1.00  0.00           C  
ATOM     73  C   ILE A   6      -4.993   3.248  -6.297  1.00  0.00           C  
ATOM     74  O   ILE A   6      -3.946   3.013  -6.889  1.00  0.00           O  
ATOM     75  CB  ILE A   6      -5.053   3.496  -3.803  1.00  0.00           C  
ATOM     76  CG1 ILE A   6      -5.201   4.491  -2.646  1.00  0.00           C  
ATOM     77  CG2 ILE A   6      -3.786   2.672  -3.635  1.00  0.00           C  
ATOM     78  CD1 ILE A   6      -5.298   3.837  -1.285  1.00  0.00           C  
ATOM     79  H   ILE A   6      -6.956   4.975  -4.701  1.00  0.00           H  
ATOM     80  HA  ILE A   6      -4.140   4.859  -5.186  1.00  0.00           H  
ATOM     81  HB  ILE A   6      -5.896   2.823  -3.800  1.00  0.00           H  
ATOM     82 HG12 ILE A   6      -4.344   5.148  -2.634  1.00  0.00           H  
ATOM     83 HG13 ILE A   6      -6.094   5.078  -2.797  1.00  0.00           H  
ATOM     84 HG21 ILE A   6      -3.715   1.954  -4.438  1.00  0.00           H  
ATOM     85 HG22 ILE A   6      -3.817   2.153  -2.688  1.00  0.00           H  
ATOM     86 HG23 ILE A   6      -2.927   3.326  -3.659  1.00  0.00           H  
ATOM     87 HD11 ILE A   6      -6.176   3.209  -1.248  1.00  0.00           H  
ATOM     88 HD12 ILE A   6      -5.367   4.599  -0.522  1.00  0.00           H  
ATOM     89 HD13 ILE A   6      -4.418   3.234  -1.112  1.00  0.00           H  
ATOM     90  N   LYS A   7      -6.154   2.683  -6.621  1.00  0.00           N  
ATOM     91  CA  LYS A   7      -6.269   1.736  -7.729  1.00  0.00           C  
ATOM     92  C   LYS A   7      -5.948   2.397  -9.068  1.00  0.00           C  
ATOM     93  O   LYS A   7      -5.519   1.733 -10.009  1.00  0.00           O  
ATOM     94  CB  LYS A   7      -7.675   1.126  -7.779  1.00  0.00           C  
ATOM     95  CG  LYS A   7      -8.795   2.156  -7.821  1.00  0.00           C  
ATOM     96  CD  LYS A   7     -10.157   1.496  -7.956  1.00  0.00           C  
ATOM     97  CE  LYS A   7     -11.287   2.491  -7.744  1.00  0.00           C  
ATOM     98  NZ  LYS A   7     -11.226   3.635  -8.693  1.00  0.00           N  
ATOM     99  H   LYS A   7      -6.956   2.895  -6.082  1.00  0.00           H  
ATOM    100  HA  LYS A   7      -5.553   0.945  -7.558  1.00  0.00           H  
ATOM    101  HB2 LYS A   7      -7.753   0.506  -8.660  1.00  0.00           H  
ATOM    102  HB3 LYS A   7      -7.816   0.509  -6.903  1.00  0.00           H  
ATOM    103  HG2 LYS A   7      -8.774   2.731  -6.908  1.00  0.00           H  
ATOM    104  HG3 LYS A   7      -8.637   2.811  -8.665  1.00  0.00           H  
ATOM    105  HD2 LYS A   7     -10.245   1.075  -8.947  1.00  0.00           H  
ATOM    106  HD3 LYS A   7     -10.240   0.710  -7.220  1.00  0.00           H  
ATOM    107  HE2 LYS A   7     -12.228   1.979  -7.882  1.00  0.00           H  
ATOM    108  HE3 LYS A   7     -11.231   2.868  -6.735  1.00  0.00           H  
ATOM    109  HZ1 LYS A   7     -11.357   3.305  -9.672  1.00  0.00           H  
ATOM    110  HZ2 LYS A   7     -10.304   4.116  -8.624  1.00  0.00           H  
ATOM    111  HZ3 LYS A   7     -11.978   4.320  -8.466  1.00  0.00           H  
ATOM    112  N   GLY A   8      -6.158   3.705  -9.146  1.00  0.00           N  
ATOM    113  CA  GLY A   8      -5.906   4.422 -10.381  1.00  0.00           C  
ATOM    114  C   GLY A   8      -4.426   4.589 -10.659  1.00  0.00           C  
ATOM    115  O   GLY A   8      -3.941   4.241 -11.734  1.00  0.00           O  
ATOM    116  H   GLY A   8      -6.484   4.186  -8.358  1.00  0.00           H  
ATOM    117  HA2 GLY A   8      -6.357   3.878 -11.199  1.00  0.00           H  
ATOM    118  HA3 GLY A   8      -6.362   5.399 -10.316  1.00  0.00           H  
ATOM    119  N   LYS A   9      -3.706   5.101  -9.674  1.00  0.00           N  
ATOM    120  CA  LYS A   9      -2.275   5.342  -9.808  1.00  0.00           C  
ATOM    121  C   LYS A   9      -1.479   4.232  -9.134  1.00  0.00           C  
ATOM    122  O   LYS A   9      -0.352   4.450  -8.696  1.00  0.00           O  
ATOM    123  CB  LYS A   9      -1.915   6.687  -9.174  1.00  0.00           C  
ATOM    124  CG  LYS A   9      -2.540   7.887  -9.868  1.00  0.00           C  
ATOM    125  CD  LYS A   9      -1.908   8.136 -11.226  1.00  0.00           C  
ATOM    126  CE  LYS A   9      -2.526   9.337 -11.919  1.00  0.00           C  
ATOM    127  NZ  LYS A   9      -1.811   9.676 -13.178  1.00  0.00           N  
ATOM    128  H   LYS A   9      -4.150   5.319  -8.823  1.00  0.00           H  
ATOM    129  HA  LYS A   9      -2.033   5.365 -10.858  1.00  0.00           H  
ATOM    130  HB2 LYS A   9      -2.242   6.684  -8.145  1.00  0.00           H  
ATOM    131  HB3 LYS A   9      -0.842   6.806  -9.199  1.00  0.00           H  
ATOM    132  HG2 LYS A   9      -3.596   7.703 -10.000  1.00  0.00           H  
ATOM    133  HG3 LYS A   9      -2.400   8.760  -9.248  1.00  0.00           H  
ATOM    134  HD2 LYS A   9      -0.853   8.316 -11.092  1.00  0.00           H  
ATOM    135  HD3 LYS A   9      -2.051   7.262 -11.845  1.00  0.00           H  
ATOM    136  HE2 LYS A   9      -3.556   9.114 -12.151  1.00  0.00           H  
ATOM    137  HE3 LYS A   9      -2.482  10.186 -11.252  1.00  0.00           H  
ATOM    138  HZ1 LYS A   9      -0.855  10.026 -12.964  1.00  0.00           H  
ATOM    139  HZ2 LYS A   9      -2.329  10.417 -13.698  1.00  0.00           H  
ATOM    140  HZ3 LYS A   9      -1.732   8.829 -13.785  1.00  0.00           H  
ATOM    141  N   TRP A  10      -2.052   3.036  -9.096  1.00  0.00           N  
ATOM    142  CA  TRP A  10      -1.506   1.931  -8.317  1.00  0.00           C  
ATOM    143  C   TRP A  10      -0.055   1.620  -8.675  1.00  0.00           C  
ATOM    144  O   TRP A  10       0.819   1.644  -7.810  1.00  0.00           O  
ATOM    145  CB  TRP A  10      -2.365   0.685  -8.498  1.00  0.00           C  
ATOM    146  CG  TRP A  10      -1.837  -0.493  -7.754  1.00  0.00           C  
ATOM    147  CD1 TRP A  10      -1.427  -1.678  -8.285  1.00  0.00           C  
ATOM    148  CD2 TRP A  10      -1.640  -0.591  -6.341  1.00  0.00           C  
ATOM    149  NE1 TRP A  10      -1.000  -2.514  -7.285  1.00  0.00           N  
ATOM    150  CE2 TRP A  10      -1.118  -1.869  -6.082  1.00  0.00           C  
ATOM    151  CE3 TRP A  10      -1.859   0.275  -5.270  1.00  0.00           C  
ATOM    152  CZ2 TRP A  10      -0.811  -2.300  -4.794  1.00  0.00           C  
ATOM    153  CZ3 TRP A  10      -1.553  -0.154  -3.995  1.00  0.00           C  
ATOM    154  CH2 TRP A  10      -1.035  -1.431  -3.766  1.00  0.00           C  
ATOM    155  H   TRP A  10      -2.871   2.886  -9.611  1.00  0.00           H  
ATOM    156  HA  TRP A  10      -1.543   2.222  -7.277  1.00  0.00           H  
ATOM    157  HB2 TRP A  10      -3.363   0.886  -8.140  1.00  0.00           H  
ATOM    158  HB3 TRP A  10      -2.405   0.430  -9.547  1.00  0.00           H  
ATOM    159  HD1 TRP A  10      -1.452  -1.910  -9.338  1.00  0.00           H  
ATOM    160  HE1 TRP A  10      -0.657  -3.425  -7.410  1.00  0.00           H  
ATOM    161  HE3 TRP A  10      -2.259   1.267  -5.423  1.00  0.00           H  
ATOM    162  HZ2 TRP A  10      -0.409  -3.286  -4.603  1.00  0.00           H  
ATOM    163  HZ3 TRP A  10      -1.715   0.506  -3.155  1.00  0.00           H  
ATOM    164  HH2 TRP A  10      -0.809  -1.723  -2.751  1.00  0.00           H  
ATOM    165  N   LYS A  11       0.202   1.345  -9.947  1.00  0.00           N  
ATOM    166  CA  LYS A  11       1.533   0.925 -10.377  1.00  0.00           C  
ATOM    167  C   LYS A  11       2.530   2.088 -10.298  1.00  0.00           C  
ATOM    168  O   LYS A  11       3.733   1.912 -10.495  1.00  0.00           O  
ATOM    169  CB  LYS A  11       1.472   0.350 -11.794  1.00  0.00           C  
ATOM    170  CG  LYS A  11       2.722  -0.412 -12.208  1.00  0.00           C  
ATOM    171  CD  LYS A  11       2.552  -1.048 -13.576  1.00  0.00           C  
ATOM    172  CE  LYS A  11       3.786  -1.837 -13.991  1.00  0.00           C  
ATOM    173  NZ  LYS A  11       3.629  -2.450 -15.337  1.00  0.00           N  
ATOM    174  H   LYS A  11      -0.516   1.430 -10.610  1.00  0.00           H  
ATOM    175  HA  LYS A  11       1.862   0.149  -9.701  1.00  0.00           H  
ATOM    176  HB2 LYS A  11       0.630  -0.322 -11.861  1.00  0.00           H  
ATOM    177  HB3 LYS A  11       1.326   1.163 -12.492  1.00  0.00           H  
ATOM    178  HG2 LYS A  11       3.556   0.273 -12.239  1.00  0.00           H  
ATOM    179  HG3 LYS A  11       2.916  -1.187 -11.480  1.00  0.00           H  
ATOM    180  HD2 LYS A  11       1.706  -1.716 -13.546  1.00  0.00           H  
ATOM    181  HD3 LYS A  11       2.373  -0.270 -14.302  1.00  0.00           H  
ATOM    182  HE2 LYS A  11       4.635  -1.172 -14.009  1.00  0.00           H  
ATOM    183  HE3 LYS A  11       3.957  -2.619 -13.268  1.00  0.00           H  
ATOM    184  HZ1 LYS A  11       2.719  -2.956 -15.399  1.00  0.00           H  
ATOM    185  HZ2 LYS A  11       4.400  -3.133 -15.512  1.00  0.00           H  
ATOM    186  HZ3 LYS A  11       3.657  -1.716 -16.078  1.00  0.00           H  
ATOM    187  N   GLN A  12       2.018   3.273 -10.008  1.00  0.00           N  
ATOM    188  CA  GLN A  12       2.855   4.441  -9.801  1.00  0.00           C  
ATOM    189  C   GLN A  12       3.100   4.638  -8.304  1.00  0.00           C  
ATOM    190  O   GLN A  12       4.208   4.969  -7.878  1.00  0.00           O  
ATOM    191  CB  GLN A  12       2.185   5.676 -10.421  1.00  0.00           C  
ATOM    192  CG  GLN A  12       2.980   6.967 -10.282  1.00  0.00           C  
ATOM    193  CD  GLN A  12       2.559   7.797  -9.083  1.00  0.00           C  
ATOM    194  OE1 GLN A  12       3.086   7.640  -7.984  1.00  0.00           O  
ATOM    195  NE2 GLN A  12       1.616   8.699  -9.290  1.00  0.00           N  
ATOM    196  H   GLN A  12       1.044   3.366  -9.930  1.00  0.00           H  
ATOM    197  HA  GLN A  12       3.802   4.266 -10.291  1.00  0.00           H  
ATOM    198  HB2 GLN A  12       2.031   5.493 -11.475  1.00  0.00           H  
ATOM    199  HB3 GLN A  12       1.224   5.821  -9.951  1.00  0.00           H  
ATOM    200  HG2 GLN A  12       4.024   6.719 -10.175  1.00  0.00           H  
ATOM    201  HG3 GLN A  12       2.843   7.557 -11.176  1.00  0.00           H  
ATOM    202 HE21 GLN A  12       1.239   8.782 -10.197  1.00  0.00           H  
ATOM    203 HE22 GLN A  12       1.337   9.261  -8.531  1.00  0.00           H  
ATOM    204  N   LEU A  13       2.060   4.398  -7.516  1.00  0.00           N  
ATOM    205  CA  LEU A  13       2.113   4.607  -6.074  1.00  0.00           C  
ATOM    206  C   LEU A  13       2.870   3.489  -5.372  1.00  0.00           C  
ATOM    207  O   LEU A  13       3.278   3.649  -4.225  1.00  0.00           O  
ATOM    208  CB  LEU A  13       0.698   4.704  -5.494  1.00  0.00           C  
ATOM    209  CG  LEU A  13      -0.156   5.856  -6.029  1.00  0.00           C  
ATOM    210  CD1 LEU A  13      -1.543   5.817  -5.412  1.00  0.00           C  
ATOM    211  CD2 LEU A  13       0.515   7.195  -5.756  1.00  0.00           C  
ATOM    212  H   LEU A  13       1.222   4.074  -7.918  1.00  0.00           H  
ATOM    213  HA  LEU A  13       2.625   5.539  -5.896  1.00  0.00           H  
ATOM    214  HB2 LEU A  13       0.182   3.777  -5.703  1.00  0.00           H  
ATOM    215  HB3 LEU A  13       0.781   4.814  -4.424  1.00  0.00           H  
ATOM    216  HG  LEU A  13      -0.265   5.747  -7.097  1.00  0.00           H  
ATOM    217 HD11 LEU A  13      -2.121   6.651  -5.778  1.00  0.00           H  
ATOM    218 HD12 LEU A  13      -1.462   5.879  -4.337  1.00  0.00           H  
ATOM    219 HD13 LEU A  13      -2.031   4.892  -5.685  1.00  0.00           H  
ATOM    220 HD21 LEU A  13       1.482   7.217  -6.236  1.00  0.00           H  
ATOM    221 HD22 LEU A  13       0.638   7.326  -4.690  1.00  0.00           H  
ATOM    222 HD23 LEU A  13      -0.100   7.991  -6.147  1.00  0.00           H  
ATOM    223  N   THR A  14       3.053   2.367  -6.064  1.00  0.00           N  
ATOM    224  CA  THR A  14       3.757   1.211  -5.514  1.00  0.00           C  
ATOM    225  C   THR A  14       5.075   1.612  -4.851  1.00  0.00           C  
ATOM    226  O   THR A  14       5.339   1.253  -3.702  1.00  0.00           O  
ATOM    227  CB  THR A  14       4.036   0.175  -6.616  1.00  0.00           C  
ATOM    228  OG1 THR A  14       4.501   0.843  -7.795  1.00  0.00           O  
ATOM    229  CG2 THR A  14       2.792  -0.631  -6.950  1.00  0.00           C  
ATOM    230  H   THR A  14       2.693   2.308  -6.975  1.00  0.00           H  
ATOM    231  HA  THR A  14       3.118   0.752  -4.773  1.00  0.00           H  
ATOM    232  HB  THR A  14       4.803  -0.501  -6.269  1.00  0.00           H  
ATOM    233  HG1 THR A  14       5.227   0.332  -8.184  1.00  0.00           H  
ATOM    234 HG21 THR A  14       2.004   0.038  -7.263  1.00  0.00           H  
ATOM    235 HG22 THR A  14       2.473  -1.181  -6.079  1.00  0.00           H  
ATOM    236 HG23 THR A  14       3.015  -1.321  -7.752  1.00  0.00           H  
ATOM    237  N   GLY A  15       5.881   2.380  -5.573  1.00  0.00           N  
ATOM    238  CA  GLY A  15       7.155   2.834  -5.046  1.00  0.00           C  
ATOM    239  C   GLY A  15       6.998   3.717  -3.824  1.00  0.00           C  
ATOM    240  O   GLY A  15       7.796   3.644  -2.889  1.00  0.00           O  
ATOM    241  H   GLY A  15       5.612   2.632  -6.481  1.00  0.00           H  
ATOM    242  HA2 GLY A  15       7.749   1.971  -4.781  1.00  0.00           H  
ATOM    243  HA3 GLY A  15       7.671   3.390  -5.814  1.00  0.00           H  
ATOM    244  N   LYS A  16       5.960   4.542  -3.821  1.00  0.00           N  
ATOM    245  CA  LYS A  16       5.710   5.449  -2.707  1.00  0.00           C  
ATOM    246  C   LYS A  16       5.179   4.684  -1.500  1.00  0.00           C  
ATOM    247  O   LYS A  16       5.404   5.074  -0.356  1.00  0.00           O  
ATOM    248  CB  LYS A  16       4.725   6.548  -3.118  1.00  0.00           C  
ATOM    249  CG  LYS A  16       5.261   7.476  -4.198  1.00  0.00           C  
ATOM    250  CD  LYS A  16       4.261   8.570  -4.542  1.00  0.00           C  
ATOM    251  CE  LYS A  16       4.829   9.551  -5.557  1.00  0.00           C  
ATOM    252  NZ  LYS A  16       5.134   8.895  -6.855  1.00  0.00           N  
ATOM    253  H   LYS A  16       5.340   4.533  -4.581  1.00  0.00           H  
ATOM    254  HA  LYS A  16       6.652   5.905  -2.439  1.00  0.00           H  
ATOM    255  HB2 LYS A  16       3.823   6.086  -3.489  1.00  0.00           H  
ATOM    256  HB3 LYS A  16       4.485   7.143  -2.249  1.00  0.00           H  
ATOM    257  HG2 LYS A  16       6.175   7.935  -3.846  1.00  0.00           H  
ATOM    258  HG3 LYS A  16       5.468   6.896  -5.086  1.00  0.00           H  
ATOM    259  HD2 LYS A  16       3.373   8.115  -4.955  1.00  0.00           H  
ATOM    260  HD3 LYS A  16       4.006   9.108  -3.641  1.00  0.00           H  
ATOM    261  HE2 LYS A  16       4.105  10.336  -5.725  1.00  0.00           H  
ATOM    262  HE3 LYS A  16       5.736   9.978  -5.157  1.00  0.00           H  
ATOM    263  HZ1 LYS A  16       5.850   8.149  -6.726  1.00  0.00           H  
ATOM    264  HZ2 LYS A  16       5.500   9.595  -7.537  1.00  0.00           H  
ATOM    265  HZ3 LYS A  16       4.272   8.464  -7.254  1.00  0.00           H  
ATOM    266  N   ILE A  17       4.470   3.596  -1.763  1.00  0.00           N  
ATOM    267  CA  ILE A  17       3.965   2.737  -0.702  1.00  0.00           C  
ATOM    268  C   ILE A  17       5.107   1.958  -0.064  1.00  0.00           C  
ATOM    269  O   ILE A  17       5.173   1.826   1.156  1.00  0.00           O  
ATOM    270  CB  ILE A  17       2.891   1.762  -1.227  1.00  0.00           C  
ATOM    271  CG1 ILE A  17       1.690   2.546  -1.753  1.00  0.00           C  
ATOM    272  CG2 ILE A  17       2.455   0.796  -0.134  1.00  0.00           C  
ATOM    273  CD1 ILE A  17       0.612   1.678  -2.352  1.00  0.00           C  
ATOM    274  H   ILE A  17       4.276   3.367  -2.699  1.00  0.00           H  
ATOM    275  HA  ILE A  17       3.512   3.370   0.048  1.00  0.00           H  
ATOM    276  HB  ILE A  17       3.317   1.186  -2.034  1.00  0.00           H  
ATOM    277 HG12 ILE A  17       1.250   3.104  -0.940  1.00  0.00           H  
ATOM    278 HG13 ILE A  17       2.025   3.234  -2.514  1.00  0.00           H  
ATOM    279 HG21 ILE A  17       3.307   0.224   0.198  1.00  0.00           H  
ATOM    280 HG22 ILE A  17       1.701   0.128  -0.523  1.00  0.00           H  
ATOM    281 HG23 ILE A  17       2.048   1.355   0.696  1.00  0.00           H  
ATOM    282 HD11 ILE A  17       1.014   1.132  -3.192  1.00  0.00           H  
ATOM    283 HD12 ILE A  17      -0.206   2.298  -2.684  1.00  0.00           H  
ATOM    284 HD13 ILE A  17       0.257   0.980  -1.609  1.00  0.00           H  
ATOM    285  N   LYS A  18       6.014   1.465  -0.902  1.00  0.00           N  
ATOM    286  CA  LYS A  18       7.209   0.776  -0.428  1.00  0.00           C  
ATOM    287  C   LYS A  18       8.084   1.728   0.385  1.00  0.00           C  
ATOM    288  O   LYS A  18       8.773   1.317   1.319  1.00  0.00           O  
ATOM    289  CB  LYS A  18       8.004   0.207  -1.609  1.00  0.00           C  
ATOM    290  CG  LYS A  18       9.323  -0.427  -1.204  1.00  0.00           C  
ATOM    291  CD  LYS A  18      10.074  -0.977  -2.404  1.00  0.00           C  
ATOM    292  CE  LYS A  18      11.456  -1.461  -2.008  1.00  0.00           C  
ATOM    293  NZ  LYS A  18      12.165  -2.123  -3.134  1.00  0.00           N  
ATOM    294  H   LYS A  18       5.867   1.558  -1.869  1.00  0.00           H  
ATOM    295  HA  LYS A  18       6.894  -0.037   0.208  1.00  0.00           H  
ATOM    296  HB2 LYS A  18       7.406  -0.543  -2.105  1.00  0.00           H  
ATOM    297  HB3 LYS A  18       8.215   1.007  -2.306  1.00  0.00           H  
ATOM    298  HG2 LYS A  18       9.937   0.320  -0.723  1.00  0.00           H  
ATOM    299  HG3 LYS A  18       9.127  -1.233  -0.513  1.00  0.00           H  
ATOM    300  HD2 LYS A  18       9.515  -1.802  -2.820  1.00  0.00           H  
ATOM    301  HD3 LYS A  18      10.172  -0.196  -3.143  1.00  0.00           H  
ATOM    302  HE2 LYS A  18      12.037  -0.613  -1.681  1.00  0.00           H  
ATOM    303  HE3 LYS A  18      11.357  -2.164  -1.194  1.00  0.00           H  
ATOM    304  HZ1 LYS A  18      11.647  -2.977  -3.437  1.00  0.00           H  
ATOM    305  HZ2 LYS A  18      13.123  -2.402  -2.837  1.00  0.00           H  
ATOM    306  HZ3 LYS A  18      12.243  -1.473  -3.945  1.00  0.00           H  
ATOM    307  N   GLU A  19       8.054   3.002   0.018  1.00  0.00           N  
ATOM    308  CA  GLU A  19       8.788   4.020   0.749  1.00  0.00           C  
ATOM    309  C   GLU A  19       8.098   4.310   2.082  1.00  0.00           C  
ATOM    310  O   GLU A  19       8.753   4.420   3.120  1.00  0.00           O  
ATOM    311  CB  GLU A  19       8.909   5.293  -0.098  1.00  0.00           C  
ATOM    312  CG  GLU A  19       9.646   6.430   0.594  1.00  0.00           C  
ATOM    313  CD  GLU A  19       8.722   7.560   1.000  1.00  0.00           C  
ATOM    314  OE1 GLU A  19       7.657   7.288   1.584  1.00  0.00           O  
ATOM    315  OE2 GLU A  19       9.051   8.733   0.721  1.00  0.00           O  
ATOM    316  H   GLU A  19       7.526   3.262  -0.766  1.00  0.00           H  
ATOM    317  HA  GLU A  19       9.777   3.633   0.948  1.00  0.00           H  
ATOM    318  HB2 GLU A  19       9.439   5.056  -1.009  1.00  0.00           H  
ATOM    319  HB3 GLU A  19       7.917   5.639  -0.349  1.00  0.00           H  
ATOM    320  HG2 GLU A  19      10.129   6.043   1.478  1.00  0.00           H  
ATOM    321  HG3 GLU A  19      10.394   6.821  -0.083  1.00  0.00           H  
ATOM    322  N   ARG A  20       6.777   4.410   2.042  1.00  0.00           N  
ATOM    323  CA  ARG A  20       5.983   4.676   3.234  1.00  0.00           C  
ATOM    324  C   ARG A  20       6.092   3.512   4.215  1.00  0.00           C  
ATOM    325  O   ARG A  20       6.315   3.708   5.411  1.00  0.00           O  
ATOM    326  CB  ARG A  20       4.520   4.900   2.844  1.00  0.00           C  
ATOM    327  CG  ARG A  20       3.634   5.415   3.971  1.00  0.00           C  
ATOM    328  CD  ARG A  20       4.051   6.807   4.424  1.00  0.00           C  
ATOM    329  NE  ARG A  20       5.127   6.775   5.415  1.00  0.00           N  
ATOM    330  CZ  ARG A  20       6.179   7.598   5.414  1.00  0.00           C  
ATOM    331  NH1 ARG A  20       6.365   8.454   4.417  1.00  0.00           N  
ATOM    332  NH2 ARG A  20       7.057   7.550   6.407  1.00  0.00           N  
ATOM    333  H   ARG A  20       6.319   4.316   1.177  1.00  0.00           H  
ATOM    334  HA  ARG A  20       6.367   5.569   3.704  1.00  0.00           H  
ATOM    335  HB2 ARG A  20       4.485   5.619   2.038  1.00  0.00           H  
ATOM    336  HB3 ARG A  20       4.109   3.966   2.493  1.00  0.00           H  
ATOM    337  HG2 ARG A  20       2.612   5.452   3.622  1.00  0.00           H  
ATOM    338  HG3 ARG A  20       3.705   4.737   4.808  1.00  0.00           H  
ATOM    339  HD2 ARG A  20       4.387   7.365   3.562  1.00  0.00           H  
ATOM    340  HD3 ARG A  20       3.193   7.302   4.856  1.00  0.00           H  
ATOM    341  HE  ARG A  20       5.036   6.124   6.152  1.00  0.00           H  
ATOM    342 HH11 ARG A  20       5.719   8.488   3.655  1.00  0.00           H  
ATOM    343 HH12 ARG A  20       7.155   9.080   4.425  1.00  0.00           H  
ATOM    344 HH21 ARG A  20       6.938   6.896   7.161  1.00  0.00           H  
ATOM    345 HH22 ARG A  20       7.846   8.178   6.419  1.00  0.00           H  
ATOM    346  N   TRP A  21       5.933   2.302   3.701  1.00  0.00           N  
ATOM    347  CA  TRP A  21       6.056   1.101   4.506  1.00  0.00           C  
ATOM    348  C   TRP A  21       7.160   0.211   3.948  1.00  0.00           C  
ATOM    349  O   TRP A  21       6.961  -0.504   2.967  1.00  0.00           O  
ATOM    350  CB  TRP A  21       4.728   0.335   4.545  1.00  0.00           C  
ATOM    351  CG  TRP A  21       3.608   1.106   5.168  1.00  0.00           C  
ATOM    352  CD1 TRP A  21       3.533   1.524   6.462  1.00  0.00           C  
ATOM    353  CD2 TRP A  21       2.399   1.539   4.533  1.00  0.00           C  
ATOM    354  NE1 TRP A  21       2.357   2.197   6.672  1.00  0.00           N  
ATOM    355  CE2 TRP A  21       1.641   2.221   5.502  1.00  0.00           C  
ATOM    356  CE3 TRP A  21       1.886   1.423   3.237  1.00  0.00           C  
ATOM    357  CZ2 TRP A  21       0.400   2.779   5.217  1.00  0.00           C  
ATOM    358  CZ3 TRP A  21       0.649   1.976   2.955  1.00  0.00           C  
ATOM    359  CH2 TRP A  21      -0.080   2.649   3.942  1.00  0.00           C  
ATOM    360  H   TRP A  21       5.737   2.212   2.738  1.00  0.00           H  
ATOM    361  HA  TRP A  21       6.320   1.398   5.509  1.00  0.00           H  
ATOM    362  HB2 TRP A  21       4.434   0.083   3.536  1.00  0.00           H  
ATOM    363  HB3 TRP A  21       4.862  -0.574   5.112  1.00  0.00           H  
ATOM    364  HD1 TRP A  21       4.298   1.345   7.204  1.00  0.00           H  
ATOM    365  HE1 TRP A  21       2.075   2.599   7.530  1.00  0.00           H  
ATOM    366  HE3 TRP A  21       2.437   0.907   2.464  1.00  0.00           H  
ATOM    367  HZ2 TRP A  21      -0.176   3.298   5.968  1.00  0.00           H  
ATOM    368  HZ3 TRP A  21       0.234   1.893   1.957  1.00  0.00           H  
ATOM    369  HH2 TRP A  21      -1.042   3.066   3.681  1.00  0.00           H  
ATOM    370  N   GLY A  22       8.325   0.263   4.583  1.00  0.00           N  
ATOM    371  CA  GLY A  22       9.487  -0.456   4.089  1.00  0.00           C  
ATOM    372  C   GLY A  22       9.329  -1.964   4.136  1.00  0.00           C  
ATOM    373  O   GLY A  22       9.963  -2.684   3.364  1.00  0.00           O  
ATOM    374  H   GLY A  22       8.398   0.799   5.405  1.00  0.00           H  
ATOM    375  HA2 GLY A  22       9.669  -0.160   3.066  1.00  0.00           H  
ATOM    376  HA3 GLY A  22      10.344  -0.178   4.686  1.00  0.00           H  
ATOM    377  N   ASP A  23       8.489  -2.445   5.038  1.00  0.00           N  
ATOM    378  CA  ASP A  23       8.260  -3.881   5.174  1.00  0.00           C  
ATOM    379  C   ASP A  23       7.439  -4.427   4.005  1.00  0.00           C  
ATOM    380  O   ASP A  23       7.468  -5.625   3.718  1.00  0.00           O  
ATOM    381  CB  ASP A  23       7.559  -4.191   6.498  1.00  0.00           C  
ATOM    382  CG  ASP A  23       7.352  -5.677   6.704  1.00  0.00           C  
ATOM    383  OD1 ASP A  23       8.341  -6.385   6.994  1.00  0.00           O  
ATOM    384  OD2 ASP A  23       6.208  -6.148   6.563  1.00  0.00           O  
ATOM    385  H   ASP A  23       8.024  -1.823   5.643  1.00  0.00           H  
ATOM    386  HA  ASP A  23       9.225  -4.367   5.172  1.00  0.00           H  
ATOM    387  HB2 ASP A  23       8.157  -3.813   7.314  1.00  0.00           H  
ATOM    388  HB3 ASP A  23       6.594  -3.708   6.510  1.00  0.00           H  
ATOM    389  N   LEU A  24       6.727  -3.543   3.316  1.00  0.00           N  
ATOM    390  CA  LEU A  24       5.919  -3.949   2.175  1.00  0.00           C  
ATOM    391  C   LEU A  24       6.788  -4.162   0.945  1.00  0.00           C  
ATOM    392  O   LEU A  24       7.569  -3.293   0.557  1.00  0.00           O  
ATOM    393  CB  LEU A  24       4.826  -2.922   1.875  1.00  0.00           C  
ATOM    394  CG  LEU A  24       3.704  -2.847   2.914  1.00  0.00           C  
ATOM    395  CD1 LEU A  24       2.639  -1.862   2.470  1.00  0.00           C  
ATOM    396  CD2 LEU A  24       3.087  -4.219   3.142  1.00  0.00           C  
ATOM    397  H   LEU A  24       6.764  -2.595   3.567  1.00  0.00           H  
ATOM    398  HA  LEU A  24       5.451  -4.889   2.426  1.00  0.00           H  
ATOM    399  HB2 LEU A  24       5.290  -1.948   1.804  1.00  0.00           H  
ATOM    400  HB3 LEU A  24       4.387  -3.163   0.920  1.00  0.00           H  
ATOM    401  HG  LEU A  24       4.114  -2.502   3.853  1.00  0.00           H  
ATOM    402 HD11 LEU A  24       2.210  -2.192   1.536  1.00  0.00           H  
ATOM    403 HD12 LEU A  24       3.084  -0.885   2.337  1.00  0.00           H  
ATOM    404 HD13 LEU A  24       1.867  -1.805   3.222  1.00  0.00           H  
ATOM    405 HD21 LEU A  24       2.672  -4.586   2.214  1.00  0.00           H  
ATOM    406 HD22 LEU A  24       2.305  -4.141   3.880  1.00  0.00           H  
ATOM    407 HD23 LEU A  24       3.845  -4.902   3.493  1.00  0.00           H  
ATOM    408  N   THR A  25       6.650  -5.333   0.347  1.00  0.00           N  
ATOM    409  CA  THR A  25       7.420  -5.695  -0.827  1.00  0.00           C  
ATOM    410  C   THR A  25       6.818  -5.065  -2.082  1.00  0.00           C  
ATOM    411  O   THR A  25       5.622  -5.211  -2.342  1.00  0.00           O  
ATOM    412  CB  THR A  25       7.456  -7.229  -0.991  1.00  0.00           C  
ATOM    413  OG1 THR A  25       7.700  -7.852   0.278  1.00  0.00           O  
ATOM    414  CG2 THR A  25       8.535  -7.648  -1.976  1.00  0.00           C  
ATOM    415  H   THR A  25       6.013  -5.979   0.711  1.00  0.00           H  
ATOM    416  HA  THR A  25       8.430  -5.339  -0.694  1.00  0.00           H  
ATOM    417  HB  THR A  25       6.497  -7.559  -1.369  1.00  0.00           H  
ATOM    418  HG1 THR A  25       7.423  -8.779   0.235  1.00  0.00           H  
ATOM    419 HG21 THR A  25       9.501  -7.330  -1.609  1.00  0.00           H  
ATOM    420 HG22 THR A  25       8.345  -7.188  -2.935  1.00  0.00           H  
ATOM    421 HG23 THR A  25       8.527  -8.722  -2.084  1.00  0.00           H  
ATOM    422  N   ASP A  26       7.647  -4.362  -2.850  1.00  0.00           N  
ATOM    423  CA  ASP A  26       7.206  -3.727  -4.097  1.00  0.00           C  
ATOM    424  C   ASP A  26       6.600  -4.754  -5.047  1.00  0.00           C  
ATOM    425  O   ASP A  26       5.555  -4.517  -5.652  1.00  0.00           O  
ATOM    426  CB  ASP A  26       8.380  -3.021  -4.783  1.00  0.00           C  
ATOM    427  CG  ASP A  26       7.998  -2.398  -6.115  1.00  0.00           C  
ATOM    428  OD1 ASP A  26       7.510  -1.251  -6.120  1.00  0.00           O  
ATOM    429  OD2 ASP A  26       8.197  -3.051  -7.162  1.00  0.00           O  
ATOM    430  H   ASP A  26       8.584  -4.256  -2.563  1.00  0.00           H  
ATOM    431  HA  ASP A  26       6.452  -2.995  -3.848  1.00  0.00           H  
ATOM    432  HB2 ASP A  26       8.746  -2.238  -4.136  1.00  0.00           H  
ATOM    433  HB3 ASP A  26       9.168  -3.737  -4.956  1.00  0.00           H  
ATOM    434  N   ASP A  27       7.265  -5.899  -5.155  1.00  0.00           N  
ATOM    435  CA  ASP A  27       6.811  -6.994  -6.010  1.00  0.00           C  
ATOM    436  C   ASP A  27       5.407  -7.450  -5.622  1.00  0.00           C  
ATOM    437  O   ASP A  27       4.602  -7.808  -6.480  1.00  0.00           O  
ATOM    438  CB  ASP A  27       7.777  -8.182  -5.905  1.00  0.00           C  
ATOM    439  CG  ASP A  27       9.205  -7.822  -6.265  1.00  0.00           C  
ATOM    440  OD1 ASP A  27       9.880  -7.168  -5.443  1.00  0.00           O  
ATOM    441  OD2 ASP A  27       9.663  -8.202  -7.365  1.00  0.00           O  
ATOM    442  H   ASP A  27       8.099  -6.008  -4.653  1.00  0.00           H  
ATOM    443  HA  ASP A  27       6.795  -6.638  -7.032  1.00  0.00           H  
ATOM    444  HB2 ASP A  27       7.767  -8.555  -4.891  1.00  0.00           H  
ATOM    445  HB3 ASP A  27       7.444  -8.965  -6.571  1.00  0.00           H  
ATOM    446  N   ASP A  28       5.125  -7.432  -4.325  1.00  0.00           N  
ATOM    447  CA  ASP A  28       3.818  -7.830  -3.808  1.00  0.00           C  
ATOM    448  C   ASP A  28       2.771  -6.778  -4.119  1.00  0.00           C  
ATOM    449  O   ASP A  28       1.617  -7.097  -4.399  1.00  0.00           O  
ATOM    450  CB  ASP A  28       3.876  -8.052  -2.297  1.00  0.00           C  
ATOM    451  CG  ASP A  28       4.431  -9.407  -1.923  1.00  0.00           C  
ATOM    452  OD1 ASP A  28       5.652  -9.620  -2.070  1.00  0.00           O  
ATOM    453  OD2 ASP A  28       3.645 -10.261  -1.458  1.00  0.00           O  
ATOM    454  H   ASP A  28       5.813  -7.138  -3.695  1.00  0.00           H  
ATOM    455  HA  ASP A  28       3.536  -8.755  -4.288  1.00  0.00           H  
ATOM    456  HB2 ASP A  28       4.507  -7.295  -1.855  1.00  0.00           H  
ATOM    457  HB3 ASP A  28       2.880  -7.965  -1.889  1.00  0.00           H  
ATOM    458  N   LEU A  29       3.179  -5.522  -4.057  1.00  0.00           N  
ATOM    459  CA  LEU A  29       2.284  -4.417  -4.351  1.00  0.00           C  
ATOM    460  C   LEU A  29       1.940  -4.406  -5.836  1.00  0.00           C  
ATOM    461  O   LEU A  29       0.774  -4.329  -6.215  1.00  0.00           O  
ATOM    462  CB  LEU A  29       2.935  -3.091  -3.949  1.00  0.00           C  
ATOM    463  CG  LEU A  29       3.351  -2.992  -2.478  1.00  0.00           C  
ATOM    464  CD1 LEU A  29       4.126  -1.707  -2.230  1.00  0.00           C  
ATOM    465  CD2 LEU A  29       2.130  -3.068  -1.571  1.00  0.00           C  
ATOM    466  H   LEU A  29       4.110  -5.333  -3.807  1.00  0.00           H  
ATOM    467  HA  LEU A  29       1.377  -4.556  -3.780  1.00  0.00           H  
ATOM    468  HB2 LEU A  29       3.815  -2.947  -4.562  1.00  0.00           H  
ATOM    469  HB3 LEU A  29       2.238  -2.293  -4.158  1.00  0.00           H  
ATOM    470  HG  LEU A  29       3.999  -3.822  -2.239  1.00  0.00           H  
ATOM    471 HD11 LEU A  29       3.518  -0.859  -2.506  1.00  0.00           H  
ATOM    472 HD12 LEU A  29       5.029  -1.712  -2.823  1.00  0.00           H  
ATOM    473 HD13 LEU A  29       4.385  -1.639  -1.183  1.00  0.00           H  
ATOM    474 HD21 LEU A  29       2.439  -2.988  -0.541  1.00  0.00           H  
ATOM    475 HD22 LEU A  29       1.628  -4.014  -1.724  1.00  0.00           H  
ATOM    476 HD23 LEU A  29       1.452  -2.260  -1.808  1.00  0.00           H  
ATOM    477  N   GLN A  30       2.965  -4.533  -6.666  1.00  0.00           N  
ATOM    478  CA  GLN A  30       2.815  -4.454  -8.117  1.00  0.00           C  
ATOM    479  C   GLN A  30       2.193  -5.743  -8.685  1.00  0.00           C  
ATOM    480  O   GLN A  30       2.654  -6.284  -9.693  1.00  0.00           O  
ATOM    481  CB  GLN A  30       4.194  -4.205  -8.742  1.00  0.00           C  
ATOM    482  CG  GLN A  30       4.150  -3.730 -10.182  1.00  0.00           C  
ATOM    483  CD  GLN A  30       5.530  -3.625 -10.797  1.00  0.00           C  
ATOM    484  OE1 GLN A  30       6.035  -4.582 -11.381  1.00  0.00           O  
ATOM    485  NE2 GLN A  30       6.159  -2.469 -10.653  1.00  0.00           N  
ATOM    486  H   GLN A  30       3.863  -4.684  -6.291  1.00  0.00           H  
ATOM    487  HA  GLN A  30       2.169  -3.620  -8.342  1.00  0.00           H  
ATOM    488  HB2 GLN A  30       4.709  -3.460  -8.157  1.00  0.00           H  
ATOM    489  HB3 GLN A  30       4.758  -5.126  -8.708  1.00  0.00           H  
ATOM    490  HG2 GLN A  30       3.567  -4.428 -10.762  1.00  0.00           H  
ATOM    491  HG3 GLN A  30       3.683  -2.757 -10.212  1.00  0.00           H  
ATOM    492 HE21 GLN A  30       5.707  -1.750 -10.159  1.00  0.00           H  
ATOM    493 HE22 GLN A  30       7.057  -2.372 -11.051  1.00  0.00           H  
ATOM    494  N   ALA A  31       1.126  -6.217  -8.047  1.00  0.00           N  
ATOM    495  CA  ALA A  31       0.486  -7.461  -8.446  1.00  0.00           C  
ATOM    496  C   ALA A  31      -0.780  -7.224  -9.276  1.00  0.00           C  
ATOM    497  O   ALA A  31      -0.707  -7.092 -10.498  1.00  0.00           O  
ATOM    498  CB  ALA A  31       0.176  -8.319  -7.226  1.00  0.00           C  
ATOM    499  H   ALA A  31       0.768  -5.713  -7.284  1.00  0.00           H  
ATOM    500  HA  ALA A  31       1.193  -8.007  -9.057  1.00  0.00           H  
ATOM    501  HB1 ALA A  31      -0.213  -9.276  -7.546  1.00  0.00           H  
ATOM    502  HB2 ALA A  31      -0.559  -7.820  -6.612  1.00  0.00           H  
ATOM    503  HB3 ALA A  31       1.079  -8.473  -6.654  1.00  0.00           H  
ATOM    504  N   ALA A  32      -1.939  -7.139  -8.618  1.00  0.00           N  
ATOM    505  CA  ALA A  32      -3.208  -7.140  -9.346  1.00  0.00           C  
ATOM    506  C   ALA A  32      -4.238  -6.145  -8.801  1.00  0.00           C  
ATOM    507  O   ALA A  32      -4.415  -5.064  -9.361  1.00  0.00           O  
ATOM    508  CB  ALA A  32      -3.798  -8.544  -9.346  1.00  0.00           C  
ATOM    509  H   ALA A  32      -1.937  -7.076  -7.641  1.00  0.00           H  
ATOM    510  HA  ALA A  32      -2.994  -6.881 -10.371  1.00  0.00           H  
ATOM    511  HB1 ALA A  32      -4.100  -8.804  -8.341  1.00  0.00           H  
ATOM    512  HB2 ALA A  32      -3.056  -9.246  -9.694  1.00  0.00           H  
ATOM    513  HB3 ALA A  32      -4.657  -8.572  -9.999  1.00  0.00           H  
ATOM    514  N   ASP A  33      -4.910  -6.529  -7.713  1.00  0.00           N  
ATOM    515  CA  ASP A  33      -6.097  -5.812  -7.217  1.00  0.00           C  
ATOM    516  C   ASP A  33      -5.863  -4.315  -7.044  1.00  0.00           C  
ATOM    517  O   ASP A  33      -6.690  -3.508  -7.465  1.00  0.00           O  
ATOM    518  CB  ASP A  33      -6.574  -6.419  -5.899  1.00  0.00           C  
ATOM    519  CG  ASP A  33      -7.040  -7.848  -6.063  1.00  0.00           C  
ATOM    520  OD1 ASP A  33      -6.183  -8.751  -6.143  1.00  0.00           O  
ATOM    521  OD2 ASP A  33      -8.266  -8.075  -6.127  1.00  0.00           O  
ATOM    522  H   ASP A  33      -4.613  -7.332  -7.234  1.00  0.00           H  
ATOM    523  HA  ASP A  33      -6.875  -5.945  -7.952  1.00  0.00           H  
ATOM    524  HB2 ASP A  33      -5.763  -6.404  -5.186  1.00  0.00           H  
ATOM    525  HB3 ASP A  33      -7.396  -5.833  -5.515  1.00  0.00           H  
ATOM    526  N   GLY A  34      -4.771  -3.949  -6.389  1.00  0.00           N  
ATOM    527  CA  GLY A  34      -4.379  -2.552  -6.321  1.00  0.00           C  
ATOM    528  C   GLY A  34      -5.168  -1.722  -5.320  1.00  0.00           C  
ATOM    529  O   GLY A  34      -4.587  -1.155  -4.402  1.00  0.00           O  
ATOM    530  H   GLY A  34      -4.225  -4.629  -5.947  1.00  0.00           H  
ATOM    531  HA2 GLY A  34      -3.334  -2.504  -6.052  1.00  0.00           H  
ATOM    532  HA3 GLY A  34      -4.497  -2.114  -7.302  1.00  0.00           H  
ATOM    533  N   HIS A  35      -6.485  -1.657  -5.509  1.00  0.00           N  
ATOM    534  CA  HIS A  35      -7.369  -0.796  -4.707  1.00  0.00           C  
ATOM    535  C   HIS A  35      -7.163  -0.972  -3.195  1.00  0.00           C  
ATOM    536  O   HIS A  35      -6.585  -1.959  -2.749  1.00  0.00           O  
ATOM    537  CB  HIS A  35      -8.835  -1.057  -5.081  1.00  0.00           C  
ATOM    538  CG  HIS A  35      -9.379  -2.373  -4.609  1.00  0.00           C  
ATOM    539  ND1 HIS A  35      -8.918  -3.592  -5.060  1.00  0.00           N  
ATOM    540  CD2 HIS A  35     -10.343  -2.653  -3.705  1.00  0.00           C  
ATOM    541  CE1 HIS A  35      -9.576  -4.560  -4.450  1.00  0.00           C  
ATOM    542  NE2 HIS A  35     -10.451  -4.019  -3.623  1.00  0.00           N  
ATOM    543  H   HIS A  35      -6.876  -2.193  -6.232  1.00  0.00           H  
ATOM    544  HA  HIS A  35      -7.133   0.226  -4.959  1.00  0.00           H  
ATOM    545  HB2 HIS A  35      -9.449  -0.278  -4.653  1.00  0.00           H  
ATOM    546  HB3 HIS A  35      -8.930  -1.026  -6.157  1.00  0.00           H  
ATOM    547  HD1 HIS A  35      -8.227  -3.727  -5.742  1.00  0.00           H  
ATOM    548  HD2 HIS A  35     -10.923  -1.931  -3.146  1.00  0.00           H  
ATOM    549  HE1 HIS A  35      -9.405  -5.618  -4.584  1.00  0.00           H  
ATOM    550  HE2 HIS A  35     -11.229  -4.496  -3.242  1.00  0.00           H  
ATOM    551  N   ALA A  36      -7.696  -0.020  -2.426  1.00  0.00           N  
ATOM    552  CA  ALA A  36      -7.442   0.101  -0.982  1.00  0.00           C  
ATOM    553  C   ALA A  36      -7.520  -1.225  -0.220  1.00  0.00           C  
ATOM    554  O   ALA A  36      -6.677  -1.502   0.637  1.00  0.00           O  
ATOM    555  CB  ALA A  36      -8.409   1.102  -0.371  1.00  0.00           C  
ATOM    556  H   ALA A  36      -8.295   0.647  -2.853  1.00  0.00           H  
ATOM    557  HA  ALA A  36      -6.447   0.500  -0.861  1.00  0.00           H  
ATOM    558  HB1 ALA A  36      -8.150   1.266   0.664  1.00  0.00           H  
ATOM    559  HB2 ALA A  36      -9.416   0.715  -0.434  1.00  0.00           H  
ATOM    560  HB3 ALA A  36      -8.347   2.035  -0.910  1.00  0.00           H  
ATOM    561  N   GLU A  37      -8.522  -2.039  -0.530  1.00  0.00           N  
ATOM    562  CA  GLU A  37      -8.712  -3.319   0.157  1.00  0.00           C  
ATOM    563  C   GLU A  37      -7.523  -4.261  -0.041  1.00  0.00           C  
ATOM    564  O   GLU A  37      -7.330  -5.196   0.739  1.00  0.00           O  
ATOM    565  CB  GLU A  37      -9.991  -3.999  -0.325  1.00  0.00           C  
ATOM    566  CG  GLU A  37     -11.262  -3.353   0.201  1.00  0.00           C  
ATOM    567  CD  GLU A  37     -11.425  -3.528   1.698  1.00  0.00           C  
ATOM    568  OE1 GLU A  37     -10.875  -2.713   2.459  1.00  0.00           O  
ATOM    569  OE2 GLU A  37     -12.115  -4.484   2.120  1.00  0.00           O  
ATOM    570  H   GLU A  37      -9.156  -1.771  -1.224  1.00  0.00           H  
ATOM    571  HA  GLU A  37      -8.810  -3.109   1.212  1.00  0.00           H  
ATOM    572  HB2 GLU A  37     -10.017  -3.965  -1.403  1.00  0.00           H  
ATOM    573  HB3 GLU A  37      -9.979  -5.031  -0.006  1.00  0.00           H  
ATOM    574  HG2 GLU A  37     -11.232  -2.297  -0.022  1.00  0.00           H  
ATOM    575  HG3 GLU A  37     -12.111  -3.802  -0.295  1.00  0.00           H  
ATOM    576  N   TYR A  38      -6.724  -4.019  -1.075  1.00  0.00           N  
ATOM    577  CA  TYR A  38      -5.562  -4.856  -1.335  1.00  0.00           C  
ATOM    578  C   TYR A  38      -4.402  -4.427  -0.444  1.00  0.00           C  
ATOM    579  O   TYR A  38      -3.595  -5.256  -0.017  1.00  0.00           O  
ATOM    580  CB  TYR A  38      -5.155  -4.798  -2.811  1.00  0.00           C  
ATOM    581  CG  TYR A  38      -4.144  -5.857  -3.195  1.00  0.00           C  
ATOM    582  CD1 TYR A  38      -4.509  -7.196  -3.248  1.00  0.00           C  
ATOM    583  CD2 TYR A  38      -2.833  -5.523  -3.502  1.00  0.00           C  
ATOM    584  CE1 TYR A  38      -3.597  -8.173  -3.593  1.00  0.00           C  
ATOM    585  CE2 TYR A  38      -1.913  -6.494  -3.848  1.00  0.00           C  
ATOM    586  CZ  TYR A  38      -2.303  -7.819  -3.891  1.00  0.00           C  
ATOM    587  OH  TYR A  38      -1.396  -8.794  -4.241  1.00  0.00           O  
ATOM    588  H   TYR A  38      -6.915  -3.255  -1.666  1.00  0.00           H  
ATOM    589  HA  TYR A  38      -5.831  -5.873  -1.088  1.00  0.00           H  
ATOM    590  HB2 TYR A  38      -6.031  -4.937  -3.427  1.00  0.00           H  
ATOM    591  HB3 TYR A  38      -4.722  -3.832  -3.020  1.00  0.00           H  
ATOM    592  HD1 TYR A  38      -5.524  -7.473  -3.016  1.00  0.00           H  
ATOM    593  HD2 TYR A  38      -2.534  -4.485  -3.466  1.00  0.00           H  
ATOM    594  HE1 TYR A  38      -3.902  -9.208  -3.627  1.00  0.00           H  
ATOM    595  HE2 TYR A  38      -0.895  -6.214  -4.082  1.00  0.00           H  
ATOM    596  HH  TYR A  38      -1.836  -9.467  -4.787  1.00  0.00           H  
ATOM    597  N   LEU A  39      -4.331  -3.127  -0.153  1.00  0.00           N  
ATOM    598  CA  LEU A  39      -3.338  -2.618   0.789  1.00  0.00           C  
ATOM    599  C   LEU A  39      -3.570  -3.247   2.148  1.00  0.00           C  
ATOM    600  O   LEU A  39      -2.640  -3.740   2.780  1.00  0.00           O  
ATOM    601  CB  LEU A  39      -3.393  -1.090   0.926  1.00  0.00           C  
ATOM    602  CG  LEU A  39      -2.807  -0.289  -0.238  1.00  0.00           C  
ATOM    603  CD1 LEU A  39      -3.757  -0.276  -1.419  1.00  0.00           C  
ATOM    604  CD2 LEU A  39      -2.484   1.129   0.204  1.00  0.00           C  
ATOM    605  H   LEU A  39      -4.959  -2.502  -0.574  1.00  0.00           H  
ATOM    606  HA  LEU A  39      -2.362  -2.908   0.431  1.00  0.00           H  
ATOM    607  HB2 LEU A  39      -4.428  -0.801   1.047  1.00  0.00           H  
ATOM    608  HB3 LEU A  39      -2.859  -0.814   1.823  1.00  0.00           H  
ATOM    609  HG  LEU A  39      -1.887  -0.755  -0.559  1.00  0.00           H  
ATOM    610 HD11 LEU A  39      -3.308   0.270  -2.234  1.00  0.00           H  
ATOM    611 HD12 LEU A  39      -4.679   0.201  -1.130  1.00  0.00           H  
ATOM    612 HD13 LEU A  39      -3.958  -1.291  -1.731  1.00  0.00           H  
ATOM    613 HD21 LEU A  39      -2.076   1.683  -0.629  1.00  0.00           H  
ATOM    614 HD22 LEU A  39      -1.760   1.100   1.006  1.00  0.00           H  
ATOM    615 HD23 LEU A  39      -3.384   1.613   0.550  1.00  0.00           H  
ATOM    616  N   VAL A  40      -4.830  -3.241   2.574  1.00  0.00           N  
ATOM    617  CA  VAL A  40      -5.222  -3.859   3.831  1.00  0.00           C  
ATOM    618  C   VAL A  40      -4.794  -5.324   3.858  1.00  0.00           C  
ATOM    619  O   VAL A  40      -4.231  -5.796   4.842  1.00  0.00           O  
ATOM    620  CB  VAL A  40      -6.749  -3.769   4.051  1.00  0.00           C  
ATOM    621  CG1 VAL A  40      -7.156  -4.480   5.332  1.00  0.00           C  
ATOM    622  CG2 VAL A  40      -7.199  -2.315   4.085  1.00  0.00           C  
ATOM    623  H   VAL A  40      -5.516  -2.805   2.022  1.00  0.00           H  
ATOM    624  HA  VAL A  40      -4.727  -3.332   4.635  1.00  0.00           H  
ATOM    625  HB  VAL A  40      -7.240  -4.255   3.222  1.00  0.00           H  
ATOM    626 HG11 VAL A  40      -6.735  -3.961   6.181  1.00  0.00           H  
ATOM    627 HG12 VAL A  40      -6.791  -5.496   5.310  1.00  0.00           H  
ATOM    628 HG13 VAL A  40      -8.233  -4.486   5.411  1.00  0.00           H  
ATOM    629 HG21 VAL A  40      -6.714  -1.807   4.906  1.00  0.00           H  
ATOM    630 HG22 VAL A  40      -8.271  -2.276   4.223  1.00  0.00           H  
ATOM    631 HG23 VAL A  40      -6.937  -1.833   3.156  1.00  0.00           H  
ATOM    632  N   GLY A  41      -5.040  -6.024   2.755  1.00  0.00           N  
ATOM    633  CA  GLY A  41      -4.668  -7.423   2.660  1.00  0.00           C  
ATOM    634  C   GLY A  41      -3.179  -7.645   2.850  1.00  0.00           C  
ATOM    635  O   GLY A  41      -2.765  -8.546   3.583  1.00  0.00           O  
ATOM    636  H   GLY A  41      -5.481  -5.585   1.996  1.00  0.00           H  
ATOM    637  HA2 GLY A  41      -5.202  -7.978   3.417  1.00  0.00           H  
ATOM    638  HA3 GLY A  41      -4.954  -7.796   1.688  1.00  0.00           H  
ATOM    639  N   LYS A  42      -2.367  -6.816   2.203  1.00  0.00           N  
ATOM    640  CA  LYS A  42      -0.917  -6.927   2.312  1.00  0.00           C  
ATOM    641  C   LYS A  42      -0.422  -6.454   3.677  1.00  0.00           C  
ATOM    642  O   LYS A  42       0.559  -6.980   4.199  1.00  0.00           O  
ATOM    643  CB  LYS A  42      -0.225  -6.149   1.190  1.00  0.00           C  
ATOM    644  CG  LYS A  42      -0.292  -6.854  -0.157  1.00  0.00           C  
ATOM    645  CD  LYS A  42       0.379  -8.220  -0.097  1.00  0.00           C  
ATOM    646  CE  LYS A  42       0.259  -8.969  -1.416  1.00  0.00           C  
ATOM    647  NZ  LYS A  42       0.898 -10.312  -1.352  1.00  0.00           N  
ATOM    648  H   LYS A  42      -2.754  -6.112   1.635  1.00  0.00           H  
ATOM    649  HA  LYS A  42      -0.669  -7.972   2.206  1.00  0.00           H  
ATOM    650  HB2 LYS A  42      -0.696  -5.181   1.093  1.00  0.00           H  
ATOM    651  HB3 LYS A  42       0.813  -6.009   1.451  1.00  0.00           H  
ATOM    652  HG2 LYS A  42      -1.327  -6.983  -0.435  1.00  0.00           H  
ATOM    653  HG3 LYS A  42       0.210  -6.247  -0.896  1.00  0.00           H  
ATOM    654  HD2 LYS A  42       1.425  -8.086   0.135  1.00  0.00           H  
ATOM    655  HD3 LYS A  42      -0.092  -8.802   0.681  1.00  0.00           H  
ATOM    656  HE2 LYS A  42      -0.787  -9.090  -1.654  1.00  0.00           H  
ATOM    657  HE3 LYS A  42       0.740  -8.390  -2.190  1.00  0.00           H  
ATOM    658  HZ1 LYS A  42       0.567 -10.826  -0.502  1.00  0.00           H  
ATOM    659  HZ2 LYS A  42       1.938 -10.218  -1.306  1.00  0.00           H  
ATOM    660  HZ3 LYS A  42       0.647 -10.868  -2.198  1.00  0.00           H  
ATOM    661  N   LEU A  43      -1.103  -5.470   4.253  1.00  0.00           N  
ATOM    662  CA  LEU A  43      -0.777  -5.007   5.599  1.00  0.00           C  
ATOM    663  C   LEU A  43      -1.053  -6.109   6.614  1.00  0.00           C  
ATOM    664  O   LEU A  43      -0.344  -6.242   7.609  1.00  0.00           O  
ATOM    665  CB  LEU A  43      -1.574  -3.748   5.954  1.00  0.00           C  
ATOM    666  CG  LEU A  43      -1.211  -2.498   5.150  1.00  0.00           C  
ATOM    667  CD1 LEU A  43      -2.122  -1.338   5.518  1.00  0.00           C  
ATOM    668  CD2 LEU A  43       0.247  -2.121   5.378  1.00  0.00           C  
ATOM    669  H   LEU A  43      -1.837  -5.039   3.761  1.00  0.00           H  
ATOM    670  HA  LEU A  43       0.278  -4.774   5.622  1.00  0.00           H  
ATOM    671  HB2 LEU A  43      -2.623  -3.959   5.800  1.00  0.00           H  
ATOM    672  HB3 LEU A  43      -1.420  -3.534   7.002  1.00  0.00           H  
ATOM    673  HG  LEU A  43      -1.344  -2.705   4.099  1.00  0.00           H  
ATOM    674 HD11 LEU A  43      -1.853  -0.472   4.935  1.00  0.00           H  
ATOM    675 HD12 LEU A  43      -2.014  -1.114   6.568  1.00  0.00           H  
ATOM    676 HD13 LEU A  43      -3.147  -1.607   5.310  1.00  0.00           H  
ATOM    677 HD21 LEU A  43       0.409  -1.923   6.429  1.00  0.00           H  
ATOM    678 HD22 LEU A  43       0.486  -1.237   4.806  1.00  0.00           H  
ATOM    679 HD23 LEU A  43       0.883  -2.936   5.063  1.00  0.00           H  
ATOM    680  N   GLN A  44      -2.085  -6.900   6.350  1.00  0.00           N  
ATOM    681  CA  GLN A  44      -2.403  -8.051   7.184  1.00  0.00           C  
ATOM    682  C   GLN A  44      -1.409  -9.176   6.932  1.00  0.00           C  
ATOM    683  O   GLN A  44      -0.971  -9.853   7.860  1.00  0.00           O  
ATOM    684  CB  GLN A  44      -3.824  -8.547   6.903  1.00  0.00           C  
ATOM    685  CG  GLN A  44      -4.897  -7.524   7.224  1.00  0.00           C  
ATOM    686  CD  GLN A  44      -4.859  -7.080   8.669  1.00  0.00           C  
ATOM    687  OE1 GLN A  44      -4.178  -6.114   9.018  1.00  0.00           O  
ATOM    688  NE2 GLN A  44      -5.577  -7.790   9.519  1.00  0.00           N  
ATOM    689  H   GLN A  44      -2.659  -6.696   5.578  1.00  0.00           H  
ATOM    690  HA  GLN A  44      -2.333  -7.743   8.218  1.00  0.00           H  
ATOM    691  HB2 GLN A  44      -3.903  -8.805   5.859  1.00  0.00           H  
ATOM    692  HB3 GLN A  44      -4.010  -9.430   7.499  1.00  0.00           H  
ATOM    693  HG2 GLN A  44      -4.752  -6.659   6.593  1.00  0.00           H  
ATOM    694  HG3 GLN A  44      -5.865  -7.959   7.021  1.00  0.00           H  
ATOM    695 HE21 GLN A  44      -6.085  -8.559   9.174  1.00  0.00           H  
ATOM    696 HE22 GLN A  44      -5.573  -7.520  10.466  1.00  0.00           H  
ATOM    697  N   GLU A  45      -1.052  -9.360   5.667  1.00  0.00           N  
ATOM    698  CA  GLU A  45      -0.133 -10.416   5.268  1.00  0.00           C  
ATOM    699  C   GLU A  45       1.259 -10.169   5.843  1.00  0.00           C  
ATOM    700  O   GLU A  45       1.869 -11.061   6.433  1.00  0.00           O  
ATOM    701  CB  GLU A  45      -0.057 -10.498   3.743  1.00  0.00           C  
ATOM    702  CG  GLU A  45       0.699 -11.713   3.231  1.00  0.00           C  
ATOM    703  CD  GLU A  45       0.993 -11.637   1.748  1.00  0.00           C  
ATOM    704  OE1 GLU A  45       0.041 -11.518   0.948  1.00  0.00           O  
ATOM    705  OE2 GLU A  45       2.180 -11.701   1.374  1.00  0.00           O  
ATOM    706  H   GLU A  45      -1.425  -8.768   4.977  1.00  0.00           H  
ATOM    707  HA  GLU A  45      -0.511 -11.351   5.654  1.00  0.00           H  
ATOM    708  HB2 GLU A  45      -1.061 -10.532   3.347  1.00  0.00           H  
ATOM    709  HB3 GLU A  45       0.436  -9.611   3.371  1.00  0.00           H  
ATOM    710  HG2 GLU A  45       1.634 -11.787   3.765  1.00  0.00           H  
ATOM    711  HG3 GLU A  45       0.105 -12.596   3.421  1.00  0.00           H  
ATOM    712  N   ARG A  46       1.758  -8.952   5.666  1.00  0.00           N  
ATOM    713  CA  ARG A  46       3.080  -8.592   6.152  1.00  0.00           C  
ATOM    714  C   ARG A  46       3.070  -8.333   7.653  1.00  0.00           C  
ATOM    715  O   ARG A  46       3.681  -9.077   8.417  1.00  0.00           O  
ATOM    716  CB  ARG A  46       3.611  -7.366   5.407  1.00  0.00           C  
ATOM    717  CG  ARG A  46       4.151  -7.680   4.021  1.00  0.00           C  
ATOM    718  CD  ARG A  46       5.242  -8.738   4.086  1.00  0.00           C  
ATOM    719  NE  ARG A  46       6.216  -8.442   5.135  1.00  0.00           N  
ATOM    720  CZ  ARG A  46       7.025  -9.344   5.688  1.00  0.00           C  
ATOM    721  NH1 ARG A  46       6.989 -10.614   5.301  1.00  0.00           N  
ATOM    722  NH2 ARG A  46       7.866  -8.973   6.639  1.00  0.00           N  
ATOM    723  H   ARG A  46       1.219  -8.277   5.196  1.00  0.00           H  
ATOM    724  HA  ARG A  46       3.737  -9.424   5.954  1.00  0.00           H  
ATOM    725  HB2 ARG A  46       2.810  -6.647   5.304  1.00  0.00           H  
ATOM    726  HB3 ARG A  46       4.407  -6.921   5.988  1.00  0.00           H  
ATOM    727  HG2 ARG A  46       3.345  -8.045   3.403  1.00  0.00           H  
ATOM    728  HG3 ARG A  46       4.560  -6.779   3.591  1.00  0.00           H  
ATOM    729  HD2 ARG A  46       4.788  -9.695   4.288  1.00  0.00           H  
ATOM    730  HD3 ARG A  46       5.751  -8.772   3.132  1.00  0.00           H  
ATOM    731  HE  ARG A  46       6.264  -7.502   5.459  1.00  0.00           H  
ATOM    732 HH11 ARG A  46       6.346 -10.910   4.584  1.00  0.00           H  
ATOM    733 HH12 ARG A  46       7.608 -11.283   5.719  1.00  0.00           H  
ATOM    734 HH21 ARG A  46       7.895  -8.006   6.944  1.00  0.00           H  
ATOM    735 HH22 ARG A  46       8.480  -9.647   7.061  1.00  0.00           H  
ATOM    736  N   TYR A  47       2.361  -7.295   8.074  1.00  0.00           N  
ATOM    737  CA  TYR A  47       2.325  -6.922   9.483  1.00  0.00           C  
ATOM    738  C   TYR A  47       1.346  -7.803  10.250  1.00  0.00           C  
ATOM    739  O   TYR A  47       1.748  -8.702  10.986  1.00  0.00           O  
ATOM    740  CB  TYR A  47       1.921  -5.458   9.650  1.00  0.00           C  
ATOM    741  CG  TYR A  47       2.831  -4.469   8.960  1.00  0.00           C  
ATOM    742  CD1 TYR A  47       3.959  -3.970   9.598  1.00  0.00           C  
ATOM    743  CD2 TYR A  47       2.547  -4.015   7.677  1.00  0.00           C  
ATOM    744  CE1 TYR A  47       4.777  -3.044   8.978  1.00  0.00           C  
ATOM    745  CE2 TYR A  47       3.363  -3.096   7.050  1.00  0.00           C  
ATOM    746  CZ  TYR A  47       4.474  -2.612   7.704  1.00  0.00           C  
ATOM    747  OH  TYR A  47       5.274  -1.681   7.086  1.00  0.00           O  
ATOM    748  H   TYR A  47       1.843  -6.776   7.428  1.00  0.00           H  
ATOM    749  HA  TYR A  47       3.316  -7.063   9.891  1.00  0.00           H  
ATOM    750  HB2 TYR A  47       0.928  -5.323   9.250  1.00  0.00           H  
ATOM    751  HB3 TYR A  47       1.911  -5.218  10.705  1.00  0.00           H  
ATOM    752  HD1 TYR A  47       4.195  -4.314  10.593  1.00  0.00           H  
ATOM    753  HD2 TYR A  47       1.676  -4.396   7.165  1.00  0.00           H  
ATOM    754  HE1 TYR A  47       5.651  -2.667   9.489  1.00  0.00           H  
ATOM    755  HE2 TYR A  47       3.128  -2.757   6.051  1.00  0.00           H  
ATOM    756  HH  TYR A  47       4.716  -1.013   6.677  1.00  0.00           H  
ATOM    757  N   GLY A  48       0.061  -7.555  10.047  1.00  0.00           N  
ATOM    758  CA  GLY A  48      -0.962  -8.258  10.792  1.00  0.00           C  
ATOM    759  C   GLY A  48      -1.598  -7.369  11.842  1.00  0.00           C  
ATOM    760  O   GLY A  48      -1.444  -7.603  13.042  1.00  0.00           O  
ATOM    761  H   GLY A  48      -0.197  -6.885   9.376  1.00  0.00           H  
ATOM    762  HA2 GLY A  48      -1.725  -8.598  10.108  1.00  0.00           H  
ATOM    763  HA3 GLY A  48      -0.517  -9.113  11.279  1.00  0.00           H  
ATOM    764  N   TRP A  49      -2.304  -6.346  11.389  1.00  0.00           N  
ATOM    765  CA  TRP A  49      -2.950  -5.394  12.282  1.00  0.00           C  
ATOM    766  C   TRP A  49      -4.442  -5.680  12.352  1.00  0.00           C  
ATOM    767  O   TRP A  49      -4.905  -6.734  11.920  1.00  0.00           O  
ATOM    768  CB  TRP A  49      -2.752  -3.960  11.782  1.00  0.00           C  
ATOM    769  CG  TRP A  49      -1.327  -3.519  11.658  1.00  0.00           C  
ATOM    770  CD1 TRP A  49      -0.258  -3.946  12.391  1.00  0.00           C  
ATOM    771  CD2 TRP A  49      -0.824  -2.533  10.751  1.00  0.00           C  
ATOM    772  NE1 TRP A  49       0.880  -3.286  11.990  1.00  0.00           N  
ATOM    773  CE2 TRP A  49       0.558  -2.413  10.984  1.00  0.00           C  
ATOM    774  CE3 TRP A  49      -1.413  -1.741   9.760  1.00  0.00           C  
ATOM    775  CZ2 TRP A  49       1.359  -1.530  10.264  1.00  0.00           C  
ATOM    776  CZ3 TRP A  49      -0.616  -0.868   9.047  1.00  0.00           C  
ATOM    777  CH2 TRP A  49       0.757  -0.769   9.300  1.00  0.00           C  
ATOM    778  H   TRP A  49      -2.418  -6.236  10.421  1.00  0.00           H  
ATOM    779  HA  TRP A  49      -2.516  -5.499  13.267  1.00  0.00           H  
ATOM    780  HB2 TRP A  49      -3.203  -3.868  10.808  1.00  0.00           H  
ATOM    781  HB3 TRP A  49      -3.249  -3.284  12.464  1.00  0.00           H  
ATOM    782  HD1 TRP A  49      -0.311  -4.695  13.166  1.00  0.00           H  
ATOM    783  HE1 TRP A  49       1.778  -3.418  12.366  1.00  0.00           H  
ATOM    784  HE3 TRP A  49      -2.469  -1.804   9.550  1.00  0.00           H  
ATOM    785  HZ2 TRP A  49       2.419  -1.441  10.448  1.00  0.00           H  
ATOM    786  HZ3 TRP A  49      -1.054  -0.248   8.278  1.00  0.00           H  
ATOM    787  HH2 TRP A  49       1.341  -0.071   8.718  1.00  0.00           H  
ATOM    788  N   SER A  50      -5.183  -4.757  12.936  1.00  0.00           N  
ATOM    789  CA  SER A  50      -6.621  -4.740  12.782  1.00  0.00           C  
ATOM    790  C   SER A  50      -6.954  -3.965  11.513  1.00  0.00           C  
ATOM    791  O   SER A  50      -6.213  -3.051  11.137  1.00  0.00           O  
ATOM    792  CB  SER A  50      -7.277  -4.100  14.007  1.00  0.00           C  
ATOM    793  OG  SER A  50      -6.674  -2.853  14.322  1.00  0.00           O  
ATOM    794  H   SER A  50      -4.753  -4.066  13.482  1.00  0.00           H  
ATOM    795  HA  SER A  50      -6.963  -5.759  12.675  1.00  0.00           H  
ATOM    796  HB2 SER A  50      -8.326  -3.937  13.810  1.00  0.00           H  
ATOM    797  HB3 SER A  50      -7.171  -4.760  14.854  1.00  0.00           H  
ATOM    798  HG  SER A  50      -7.344  -2.256  14.692  1.00  0.00           H  
ATOM    799  N   LYS A  51      -8.040  -4.330  10.841  1.00  0.00           N  
ATOM    800  CA  LYS A  51      -8.397  -3.676   9.585  1.00  0.00           C  
ATOM    801  C   LYS A  51      -8.594  -2.181   9.789  1.00  0.00           C  
ATOM    802  O   LYS A  51      -8.229  -1.387   8.936  1.00  0.00           O  
ATOM    803  CB  LYS A  51      -9.657  -4.279   8.956  1.00  0.00           C  
ATOM    804  CG  LYS A  51      -9.934  -3.712   7.573  1.00  0.00           C  
ATOM    805  CD  LYS A  51     -11.133  -4.354   6.907  1.00  0.00           C  
ATOM    806  CE  LYS A  51     -11.212  -3.952   5.442  1.00  0.00           C  
ATOM    807  NZ  LYS A  51     -12.427  -4.485   4.775  1.00  0.00           N  
ATOM    808  H   LYS A  51      -8.612  -5.048  11.195  1.00  0.00           H  
ATOM    809  HA  LYS A  51      -7.569  -3.819   8.903  1.00  0.00           H  
ATOM    810  HB2 LYS A  51      -9.535  -5.350   8.873  1.00  0.00           H  
ATOM    811  HB3 LYS A  51     -10.506  -4.064   9.588  1.00  0.00           H  
ATOM    812  HG2 LYS A  51     -10.118  -2.652   7.663  1.00  0.00           H  
ATOM    813  HG3 LYS A  51      -9.064  -3.869   6.955  1.00  0.00           H  
ATOM    814  HD2 LYS A  51     -11.044  -5.428   6.975  1.00  0.00           H  
ATOM    815  HD3 LYS A  51     -12.032  -4.027   7.411  1.00  0.00           H  
ATOM    816  HE2 LYS A  51     -11.227  -2.874   5.381  1.00  0.00           H  
ATOM    817  HE3 LYS A  51     -10.338  -4.327   4.930  1.00  0.00           H  
ATOM    818  HZ1 LYS A  51     -12.315  -4.437   3.736  1.00  0.00           H  
ATOM    819  HZ2 LYS A  51     -13.259  -3.915   5.045  1.00  0.00           H  
ATOM    820  HZ3 LYS A  51     -12.593  -5.473   5.057  1.00  0.00           H  
ATOM    821  N   GLU A  52      -9.155  -1.807  10.929  1.00  0.00           N  
ATOM    822  CA  GLU A  52      -9.368  -0.404  11.256  1.00  0.00           C  
ATOM    823  C   GLU A  52      -8.035   0.344  11.337  1.00  0.00           C  
ATOM    824  O   GLU A  52      -7.913   1.477  10.863  1.00  0.00           O  
ATOM    825  CB  GLU A  52     -10.121  -0.300  12.577  1.00  0.00           C  
ATOM    826  CG  GLU A  52     -10.372   1.122  13.030  1.00  0.00           C  
ATOM    827  CD  GLU A  52     -11.168   1.170  14.309  1.00  0.00           C  
ATOM    828  OE1 GLU A  52     -10.711   0.594  15.317  1.00  0.00           O  
ATOM    829  OE2 GLU A  52     -12.265   1.768  14.310  1.00  0.00           O  
ATOM    830  H   GLU A  52      -9.444  -2.498  11.571  1.00  0.00           H  
ATOM    831  HA  GLU A  52      -9.969   0.033  10.473  1.00  0.00           H  
ATOM    832  HB2 GLU A  52     -11.075  -0.795  12.473  1.00  0.00           H  
ATOM    833  HB3 GLU A  52      -9.548  -0.803  13.342  1.00  0.00           H  
ATOM    834  HG2 GLU A  52      -9.422   1.607  13.194  1.00  0.00           H  
ATOM    835  HG3 GLU A  52     -10.918   1.645  12.259  1.00  0.00           H  
ATOM    836  N   ARG A  53      -7.039  -0.305  11.925  1.00  0.00           N  
ATOM    837  CA  ARG A  53      -5.701   0.263  12.022  1.00  0.00           C  
ATOM    838  C   ARG A  53      -5.076   0.359  10.634  1.00  0.00           C  
ATOM    839  O   ARG A  53      -4.419   1.346  10.303  1.00  0.00           O  
ATOM    840  CB  ARG A  53      -4.840  -0.599  12.950  1.00  0.00           C  
ATOM    841  CG  ARG A  53      -3.391  -0.148  13.079  1.00  0.00           C  
ATOM    842  CD  ARG A  53      -2.661  -0.978  14.123  1.00  0.00           C  
ATOM    843  NE  ARG A  53      -1.215  -0.758  14.121  1.00  0.00           N  
ATOM    844  CZ  ARG A  53      -0.349  -1.534  14.776  1.00  0.00           C  
ATOM    845  NH1 ARG A  53      -0.788  -2.556  15.504  1.00  0.00           N  
ATOM    846  NH2 ARG A  53       0.953  -1.290  14.702  1.00  0.00           N  
ATOM    847  H   ARG A  53      -7.209  -1.195  12.297  1.00  0.00           H  
ATOM    848  HA  ARG A  53      -5.787   1.256  12.437  1.00  0.00           H  
ATOM    849  HB2 ARG A  53      -5.283  -0.591  13.934  1.00  0.00           H  
ATOM    850  HB3 ARG A  53      -4.844  -1.614  12.576  1.00  0.00           H  
ATOM    851  HG2 ARG A  53      -2.899  -0.268  12.127  1.00  0.00           H  
ATOM    852  HG3 ARG A  53      -3.369   0.891  13.374  1.00  0.00           H  
ATOM    853  HD2 ARG A  53      -3.048  -0.722  15.097  1.00  0.00           H  
ATOM    854  HD3 ARG A  53      -2.856  -2.023  13.926  1.00  0.00           H  
ATOM    855  HE  ARG A  53      -0.867   0.004  13.592  1.00  0.00           H  
ATOM    856 HH11 ARG A  53      -1.773  -2.751  15.559  1.00  0.00           H  
ATOM    857 HH12 ARG A  53      -0.136  -3.140  16.013  1.00  0.00           H  
ATOM    858 HH21 ARG A  53       1.289  -0.516  14.151  1.00  0.00           H  
ATOM    859 HH22 ARG A  53       1.615  -1.882  15.184  1.00  0.00           H  
ATOM    860  N   ALA A  54      -5.300  -0.668   9.823  1.00  0.00           N  
ATOM    861  CA  ALA A  54      -4.831  -0.676   8.446  1.00  0.00           C  
ATOM    862  C   ALA A  54      -5.484   0.457   7.655  1.00  0.00           C  
ATOM    863  O   ALA A  54      -4.804   1.201   6.949  1.00  0.00           O  
ATOM    864  CB  ALA A  54      -5.114  -2.024   7.796  1.00  0.00           C  
ATOM    865  H   ALA A  54      -5.794  -1.446  10.165  1.00  0.00           H  
ATOM    866  HA  ALA A  54      -3.762  -0.523   8.457  1.00  0.00           H  
ATOM    867  HB1 ALA A  54      -4.693  -2.040   6.801  1.00  0.00           H  
ATOM    868  HB2 ALA A  54      -6.179  -2.181   7.738  1.00  0.00           H  
ATOM    869  HB3 ALA A  54      -4.665  -2.811   8.389  1.00  0.00           H  
ATOM    870  N   GLU A  55      -6.803   0.593   7.802  1.00  0.00           N  
ATOM    871  CA  GLU A  55      -7.560   1.663   7.153  1.00  0.00           C  
ATOM    872  C   GLU A  55      -6.947   3.025   7.456  1.00  0.00           C  
ATOM    873  O   GLU A  55      -6.757   3.845   6.556  1.00  0.00           O  
ATOM    874  CB  GLU A  55      -9.021   1.662   7.625  1.00  0.00           C  
ATOM    875  CG  GLU A  55      -9.872   0.517   7.089  1.00  0.00           C  
ATOM    876  CD  GLU A  55     -11.321   0.618   7.539  1.00  0.00           C  
ATOM    877  OE1 GLU A  55     -11.955   1.669   7.291  1.00  0.00           O  
ATOM    878  OE2 GLU A  55     -11.831  -0.342   8.161  1.00  0.00           O  
ATOM    879  H   GLU A  55      -7.289  -0.054   8.364  1.00  0.00           H  
ATOM    880  HA  GLU A  55      -7.533   1.492   6.088  1.00  0.00           H  
ATOM    881  HB2 GLU A  55      -9.031   1.604   8.704  1.00  0.00           H  
ATOM    882  HB3 GLU A  55      -9.480   2.592   7.323  1.00  0.00           H  
ATOM    883  HG2 GLU A  55      -9.842   0.535   6.009  1.00  0.00           H  
ATOM    884  HG3 GLU A  55      -9.462  -0.419   7.445  1.00  0.00           H  
ATOM    885  N   GLN A  56      -6.628   3.248   8.727  1.00  0.00           N  
ATOM    886  CA  GLN A  56      -6.094   4.530   9.175  1.00  0.00           C  
ATOM    887  C   GLN A  56      -4.783   4.859   8.463  1.00  0.00           C  
ATOM    888  O   GLN A  56      -4.581   5.983   8.001  1.00  0.00           O  
ATOM    889  CB  GLN A  56      -5.879   4.511  10.692  1.00  0.00           C  
ATOM    890  CG  GLN A  56      -5.474   5.858  11.269  1.00  0.00           C  
ATOM    891  CD  GLN A  56      -6.537   6.927  11.080  1.00  0.00           C  
ATOM    892  OE1 GLN A  56      -6.227   8.106  10.927  1.00  0.00           O  
ATOM    893  NE2 GLN A  56      -7.800   6.524  11.094  1.00  0.00           N  
ATOM    894  H   GLN A  56      -6.758   2.529   9.385  1.00  0.00           H  
ATOM    895  HA  GLN A  56      -6.818   5.290   8.935  1.00  0.00           H  
ATOM    896  HB2 GLN A  56      -6.799   4.204  11.167  1.00  0.00           H  
ATOM    897  HB3 GLN A  56      -5.106   3.792  10.927  1.00  0.00           H  
ATOM    898  HG2 GLN A  56      -5.291   5.740  12.327  1.00  0.00           H  
ATOM    899  HG3 GLN A  56      -4.565   6.186  10.785  1.00  0.00           H  
ATOM    900 HE21 GLN A  56      -7.984   5.562  11.223  1.00  0.00           H  
ATOM    901 HE22 GLN A  56      -8.506   7.203  10.994  1.00  0.00           H  
ATOM    902  N   GLU A  57      -3.906   3.872   8.366  1.00  0.00           N  
ATOM    903  CA  GLU A  57      -2.605   4.067   7.745  1.00  0.00           C  
ATOM    904  C   GLU A  57      -2.740   4.207   6.228  1.00  0.00           C  
ATOM    905  O   GLU A  57      -2.003   4.969   5.599  1.00  0.00           O  
ATOM    906  CB  GLU A  57      -1.670   2.908   8.103  1.00  0.00           C  
ATOM    907  CG  GLU A  57      -1.547   2.660   9.602  1.00  0.00           C  
ATOM    908  CD  GLU A  57      -1.147   3.900  10.378  1.00  0.00           C  
ATOM    909  OE1 GLU A  57       0.067   4.171  10.497  1.00  0.00           O  
ATOM    910  OE2 GLU A  57      -2.046   4.612  10.875  1.00  0.00           O  
ATOM    911  H   GLU A  57      -4.134   2.989   8.731  1.00  0.00           H  
ATOM    912  HA  GLU A  57      -2.190   4.984   8.138  1.00  0.00           H  
ATOM    913  HB2 GLU A  57      -2.041   2.008   7.640  1.00  0.00           H  
ATOM    914  HB3 GLU A  57      -0.686   3.121   7.715  1.00  0.00           H  
ATOM    915  HG2 GLU A  57      -2.501   2.315   9.974  1.00  0.00           H  
ATOM    916  HG3 GLU A  57      -0.803   1.896   9.766  1.00  0.00           H  
ATOM    917  N   VAL A  58      -3.687   3.480   5.642  1.00  0.00           N  
ATOM    918  CA  VAL A  58      -3.958   3.590   4.211  1.00  0.00           C  
ATOM    919  C   VAL A  58      -4.471   4.989   3.862  1.00  0.00           C  
ATOM    920  O   VAL A  58      -4.036   5.601   2.883  1.00  0.00           O  
ATOM    921  CB  VAL A  58      -4.982   2.530   3.744  1.00  0.00           C  
ATOM    922  CG1 VAL A  58      -5.385   2.759   2.295  1.00  0.00           C  
ATOM    923  CG2 VAL A  58      -4.414   1.129   3.914  1.00  0.00           C  
ATOM    924  H   VAL A  58      -4.207   2.845   6.182  1.00  0.00           H  
ATOM    925  HA  VAL A  58      -3.030   3.420   3.684  1.00  0.00           H  
ATOM    926  HB  VAL A  58      -5.867   2.614   4.357  1.00  0.00           H  
ATOM    927 HG11 VAL A  58      -5.841   3.734   2.200  1.00  0.00           H  
ATOM    928 HG12 VAL A  58      -6.091   2.000   1.992  1.00  0.00           H  
ATOM    929 HG13 VAL A  58      -4.509   2.710   1.665  1.00  0.00           H  
ATOM    930 HG21 VAL A  58      -3.519   1.030   3.319  1.00  0.00           H  
ATOM    931 HG22 VAL A  58      -5.143   0.401   3.590  1.00  0.00           H  
ATOM    932 HG23 VAL A  58      -4.175   0.962   4.953  1.00  0.00           H  
ATOM    933  N   ARG A  59      -5.382   5.501   4.678  1.00  0.00           N  
ATOM    934  CA  ARG A  59      -5.936   6.833   4.464  1.00  0.00           C  
ATOM    935  C   ARG A  59      -4.904   7.903   4.783  1.00  0.00           C  
ATOM    936  O   ARG A  59      -4.976   9.022   4.277  1.00  0.00           O  
ATOM    937  CB  ARG A  59      -7.204   7.028   5.292  1.00  0.00           C  
ATOM    938  CG  ARG A  59      -8.335   6.130   4.830  1.00  0.00           C  
ATOM    939  CD  ARG A  59      -9.656   6.461   5.508  1.00  0.00           C  
ATOM    940  NE  ARG A  59      -9.641   6.141   6.930  1.00  0.00           N  
ATOM    941  CZ  ARG A  59     -10.311   5.124   7.470  1.00  0.00           C  
ATOM    942  NH1 ARG A  59     -11.045   4.321   6.702  1.00  0.00           N  
ATOM    943  NH2 ARG A  59     -10.247   4.908   8.776  1.00  0.00           N  
ATOM    944  H   ARG A  59      -5.695   4.967   5.444  1.00  0.00           H  
ATOM    945  HA  ARG A  59      -6.191   6.911   3.418  1.00  0.00           H  
ATOM    946  HB2 ARG A  59      -6.990   6.805   6.328  1.00  0.00           H  
ATOM    947  HB3 ARG A  59      -7.528   8.055   5.209  1.00  0.00           H  
ATOM    948  HG2 ARG A  59      -8.444   6.245   3.768  1.00  0.00           H  
ATOM    949  HG3 ARG A  59      -8.076   5.104   5.052  1.00  0.00           H  
ATOM    950  HD2 ARG A  59      -9.852   7.516   5.390  1.00  0.00           H  
ATOM    951  HD3 ARG A  59     -10.442   5.894   5.030  1.00  0.00           H  
ATOM    952  HE  ARG A  59      -9.103   6.730   7.520  1.00  0.00           H  
ATOM    953 HH11 ARG A  59     -11.101   4.484   5.717  1.00  0.00           H  
ATOM    954 HH12 ARG A  59     -11.534   3.536   7.107  1.00  0.00           H  
ATOM    955 HH21 ARG A  59      -9.696   5.503   9.362  1.00  0.00           H  
ATOM    956 HH22 ARG A  59     -10.763   4.143   9.190  1.00  0.00           H  
ATOM    957  N   ASP A  60      -3.942   7.545   5.613  1.00  0.00           N  
ATOM    958  CA  ASP A  60      -2.788   8.410   5.861  1.00  0.00           C  
ATOM    959  C   ASP A  60      -1.992   8.593   4.575  1.00  0.00           C  
ATOM    960  O   ASP A  60      -1.619   9.708   4.212  1.00  0.00           O  
ATOM    961  CB  ASP A  60      -1.886   7.823   6.946  1.00  0.00           C  
ATOM    962  CG  ASP A  60      -0.581   8.586   7.094  1.00  0.00           C  
ATOM    963  OD1 ASP A  60      -0.543   9.563   7.869  1.00  0.00           O  
ATOM    964  OD2 ASP A  60       0.417   8.203   6.443  1.00  0.00           O  
ATOM    965  H   ASP A  60      -4.014   6.685   6.079  1.00  0.00           H  
ATOM    966  HA  ASP A  60      -3.154   9.372   6.184  1.00  0.00           H  
ATOM    967  HB2 ASP A  60      -2.405   7.851   7.892  1.00  0.00           H  
ATOM    968  HB3 ASP A  60      -1.656   6.798   6.697  1.00  0.00           H  
ATOM    969  N   PHE A  61      -1.755   7.489   3.876  1.00  0.00           N  
ATOM    970  CA  PHE A  61      -1.062   7.529   2.599  1.00  0.00           C  
ATOM    971  C   PHE A  61      -1.900   8.284   1.569  1.00  0.00           C  
ATOM    972  O   PHE A  61      -1.370   9.016   0.735  1.00  0.00           O  
ATOM    973  CB  PHE A  61      -0.754   6.111   2.107  1.00  0.00           C  
ATOM    974  CG  PHE A  61      -0.057   6.077   0.776  1.00  0.00           C  
ATOM    975  CD1 PHE A  61       1.287   6.398   0.678  1.00  0.00           C  
ATOM    976  CD2 PHE A  61      -0.744   5.720  -0.374  1.00  0.00           C  
ATOM    977  CE1 PHE A  61       1.931   6.375  -0.542  1.00  0.00           C  
ATOM    978  CE2 PHE A  61      -0.105   5.694  -1.598  1.00  0.00           C  
ATOM    979  CZ  PHE A  61       1.236   6.019  -1.682  1.00  0.00           C  
ATOM    980  H   PHE A  61      -2.044   6.623   4.238  1.00  0.00           H  
ATOM    981  HA  PHE A  61      -0.134   8.060   2.744  1.00  0.00           H  
ATOM    982  HB2 PHE A  61      -0.117   5.621   2.827  1.00  0.00           H  
ATOM    983  HB3 PHE A  61      -1.677   5.560   2.015  1.00  0.00           H  
ATOM    984  HD1 PHE A  61       1.831   6.676   1.569  1.00  0.00           H  
ATOM    985  HD2 PHE A  61      -1.791   5.466  -0.307  1.00  0.00           H  
ATOM    986  HE1 PHE A  61       2.979   6.628  -0.607  1.00  0.00           H  
ATOM    987  HE2 PHE A  61      -0.651   5.416  -2.487  1.00  0.00           H  
ATOM    988  HZ  PHE A  61       1.737   5.999  -2.638  1.00  0.00           H  
ATOM    989  N   SER A  62      -3.213   8.115   1.652  1.00  0.00           N  
ATOM    990  CA  SER A  62      -4.135   8.812   0.764  1.00  0.00           C  
ATOM    991  C   SER A  62      -4.080  10.321   1.009  1.00  0.00           C  
ATOM    992  O   SER A  62      -4.272  11.117   0.092  1.00  0.00           O  
ATOM    993  CB  SER A  62      -5.559   8.289   0.970  1.00  0.00           C  
ATOM    994  OG  SER A  62      -5.622   6.886   0.771  1.00  0.00           O  
ATOM    995  H   SER A  62      -3.573   7.500   2.327  1.00  0.00           H  
ATOM    996  HA  SER A  62      -3.828   8.615  -0.252  1.00  0.00           H  
ATOM    997  HB2 SER A  62      -5.883   8.512   1.976  1.00  0.00           H  
ATOM    998  HB3 SER A  62      -6.223   8.770   0.265  1.00  0.00           H  
ATOM    999  HG  SER A  62      -4.899   6.459   1.243  1.00  0.00           H  
ATOM   1000  N   ASP A  63      -3.801  10.706   2.248  1.00  0.00           N  
ATOM   1001  CA  ASP A  63      -3.673  12.116   2.610  1.00  0.00           C  
ATOM   1002  C   ASP A  63      -2.409  12.701   1.990  1.00  0.00           C  
ATOM   1003  O   ASP A  63      -2.342  13.887   1.673  1.00  0.00           O  
ATOM   1004  CB  ASP A  63      -3.624  12.258   4.132  1.00  0.00           C  
ATOM   1005  CG  ASP A  63      -3.581  13.701   4.596  1.00  0.00           C  
ATOM   1006  OD1 ASP A  63      -4.664  14.301   4.767  1.00  0.00           O  
ATOM   1007  OD2 ASP A  63      -2.471  14.229   4.833  1.00  0.00           O  
ATOM   1008  H   ASP A  63      -3.681  10.024   2.942  1.00  0.00           H  
ATOM   1009  HA  ASP A  63      -4.533  12.644   2.227  1.00  0.00           H  
ATOM   1010  HB2 ASP A  63      -4.500  11.792   4.557  1.00  0.00           H  
ATOM   1011  HB3 ASP A  63      -2.742  11.754   4.503  1.00  0.00           H  
ATOM   1012  N   ARG A  64      -1.422  11.839   1.790  1.00  0.00           N  
ATOM   1013  CA  ARG A  64      -0.138  12.233   1.225  1.00  0.00           C  
ATOM   1014  C   ARG A  64      -0.233  12.366  -0.298  1.00  0.00           C  
ATOM   1015  O   ARG A  64       0.699  12.838  -0.956  1.00  0.00           O  
ATOM   1016  CB  ARG A  64       0.919  11.194   1.608  1.00  0.00           C  
ATOM   1017  CG  ARG A  64       2.339  11.566   1.216  1.00  0.00           C  
ATOM   1018  CD  ARG A  64       3.311  10.458   1.578  1.00  0.00           C  
ATOM   1019  NE  ARG A  64       4.695  10.818   1.281  1.00  0.00           N  
ATOM   1020  CZ  ARG A  64       5.700   9.944   1.245  1.00  0.00           C  
ATOM   1021  NH1 ARG A  64       5.465   8.647   1.399  1.00  0.00           N  
ATOM   1022  NH2 ARG A  64       6.939  10.366   1.030  1.00  0.00           N  
ATOM   1023  H   ARG A  64      -1.562  10.899   2.034  1.00  0.00           H  
ATOM   1024  HA  ARG A  64       0.134  13.189   1.647  1.00  0.00           H  
ATOM   1025  HB2 ARG A  64       0.894  11.053   2.679  1.00  0.00           H  
ATOM   1026  HB3 ARG A  64       0.673  10.258   1.127  1.00  0.00           H  
ATOM   1027  HG2 ARG A  64       2.378  11.734   0.151  1.00  0.00           H  
ATOM   1028  HG3 ARG A  64       2.624  12.468   1.738  1.00  0.00           H  
ATOM   1029  HD2 ARG A  64       3.223  10.251   2.634  1.00  0.00           H  
ATOM   1030  HD3 ARG A  64       3.052   9.573   1.015  1.00  0.00           H  
ATOM   1031  HE  ARG A  64       4.891  11.775   1.119  1.00  0.00           H  
ATOM   1032 HH11 ARG A  64       4.534   8.314   1.539  1.00  0.00           H  
ATOM   1033 HH12 ARG A  64       6.242   7.985   1.378  1.00  0.00           H  
ATOM   1034 HH21 ARG A  64       7.128  11.345   0.892  1.00  0.00           H  
ATOM   1035 HH22 ARG A  64       7.706   9.700   1.003  1.00  0.00           H  
ATOM   1036  N   LEU A  65      -1.363  11.947  -0.852  1.00  0.00           N  
ATOM   1037  CA  LEU A  65      -1.573  11.998  -2.290  1.00  0.00           C  
ATOM   1038  C   LEU A  65      -2.297  13.281  -2.681  1.00  0.00           C  
ATOM   1039  O   LEU A  65      -3.548  13.282  -2.696  1.00  0.00           O  
ATOM   1040  CB  LEU A  65      -2.372  10.780  -2.754  1.00  0.00           C  
ATOM   1041  CG  LEU A  65      -1.746   9.427  -2.412  1.00  0.00           C  
ATOM   1042  CD1 LEU A  65      -2.626   8.292  -2.905  1.00  0.00           C  
ATOM   1043  CD2 LEU A  65      -0.350   9.319  -3.008  1.00  0.00           C  
ATOM   1044  OXT LEU A  65      -1.616  14.288  -2.962  1.00  0.00           O  
ATOM   1045  H   LEU A  65      -2.077  11.601  -0.277  1.00  0.00           H  
ATOM   1046  HA  LEU A  65      -0.605  11.985  -2.768  1.00  0.00           H  
ATOM   1047  HB2 LEU A  65      -3.353  10.823  -2.301  1.00  0.00           H  
ATOM   1048  HB3 LEU A  65      -2.487  10.836  -3.826  1.00  0.00           H  
ATOM   1049  HG  LEU A  65      -1.658   9.339  -1.338  1.00  0.00           H  
ATOM   1050 HD11 LEU A  65      -2.185   7.347  -2.623  1.00  0.00           H  
ATOM   1051 HD12 LEU A  65      -2.712   8.341  -3.981  1.00  0.00           H  
ATOM   1052 HD13 LEU A  65      -3.607   8.377  -2.460  1.00  0.00           H  
ATOM   1053 HD21 LEU A  65       0.072   8.355  -2.770  1.00  0.00           H  
ATOM   1054 HD22 LEU A  65       0.277  10.097  -2.597  1.00  0.00           H  
ATOM   1055 HD23 LEU A  65      -0.406   9.433  -4.081  1.00  0.00           H  
TER    1056      LEU A  65                                                      
END
MOLECULE T0469.pdb
ATOM     34  N   GLN     3     -11.627   8.047  -2.168  1.00 30.01           N 
ATOM     35  CA  GLN     3     -10.194   8.122  -1.859  1.00 44.33           C 
ATOM     36  C   GLN     3      -9.345   7.641  -3.041  1.00  1.05           C 
ATOM     37  O   GLN     3      -9.602   6.580  -3.610  1.00 22.43           O 
ATOM     38  CB  GLN     3      -9.859   7.292  -0.611  1.00 15.35           C 
ATOM     39  CG  GLN     3     -10.597   7.739   0.646  1.00 20.34           C 
ATOM     40  CD  GLN     3     -10.090   7.063   1.912  1.00 71.03           C 
ATOM     41  OE1 GLN     3     -10.146   7.632   2.994  1.00 40.53           O 
ATOM     42  NE2 GLN     3      -9.579   5.849   1.794  1.00 34.32           N 
ATOM     43  H   GLN     3     -12.030   7.173  -2.365  1.00 38.87           H 
ATOM     44  HA  GLN     3      -9.952   9.158  -1.661  1.00  1.11           H 
ATOM     45 3HB  GLN     3      -8.796   7.360  -0.423  1.00 38.87           H 
ATOM     46 2HB  GLN     3     -10.114   6.259  -0.802  1.00 38.87           H 
ATOM     47 3HG  GLN     3     -11.648   7.509   0.531  1.00 38.87           H 
ATOM     48 2HG  GLN     3     -10.477   8.807   0.757  1.00 38.87           H 
ATOM     49 1HE2 GLN     3      -9.546   5.443   0.906  1.00 38.87           H 
ATOM     50 2HE2 GLN     3      -9.262   5.406   2.608  1.00 38.87           H 
ATOM     51  N   LYS     4      -8.332   8.429  -3.406  1.00 22.44           N 
ATOM     52  CA  LYS     4      -7.409   8.050  -4.485  1.00 75.21           C 
ATOM     53  C   LYS     4      -6.629   6.774  -4.137  1.00 11.23           C 
ATOM     54  O   LYS     4      -6.107   6.090  -5.023  1.00 54.32           O 
ATOM     55  CB  LYS     4      -6.437   9.199  -4.787  1.00 13.44           C 
ATOM     56  CG  LYS     4      -7.117  10.443  -5.351  1.00 21.02           C 
ATOM     57  CD  LYS     4      -6.106  11.504  -5.782  1.00 42.12           C 
ATOM     58  CE  LYS     4      -5.137  10.973  -6.836  1.00 71.40           C 
ATOM     59  NZ  LYS     4      -5.843  10.455  -8.039  1.00 62.12           N 
ATOM     60  H   LYS     4      -8.205   9.286  -2.948  1.00 38.87           H 
ATOM     61  HA  LYS     4      -8.002   7.858  -5.369  1.00 34.11           H 
ATOM     62 3HB  LYS     4      -5.705   8.856  -5.506  1.00 38.87           H 
ATOM     63 2HB  LYS     4      -5.928   9.474  -3.874  1.00 38.87           H 
ATOM     64 3HG  LYS     4      -7.762  10.863  -4.589  1.00 38.87           H 
ATOM     65 2HG  LYS     4      -7.712  10.160  -6.207  1.00 38.87           H 
ATOM     66 3HD  LYS     4      -5.543  11.825  -4.915  1.00 38.87           H 
ATOM     67 2HD  LYS     4      -6.640  12.347  -6.195  1.00 38.87           H 
ATOM     68 3HE  LYS     4      -4.552  10.173  -6.401  1.00 38.87           H 
ATOM     69 2HE  LYS     4      -4.480  11.772  -7.139  1.00 38.87           H 
ATOM     70 1HZ  LYS     4      -6.407   9.616  -7.794  1.00 38.87           H 
ATOM     71 2HZ  LYS     4      -5.154  10.192  -8.772  1.00 38.87           H 
ATOM     72 3HZ  LYS     4      -6.476  11.184  -8.427  1.00 38.87           H 
ATOM     73  N   PHE     5      -6.530   6.483  -2.839  1.00 50.12           N 
ATOM     74  CA  PHE     5      -5.961   5.220  -2.356  1.00 63.21           C 
ATOM     75  C   PHE     5      -7.007   4.431  -1.553  1.00  2.41           C 
ATOM     76  O   PHE     5      -7.454   4.866  -0.486  1.00  4.53           O 
ATOM     77  CB  PHE     5      -4.720   5.485  -1.493  1.00 42.04           C 
ATOM     78  CG  PHE     5      -3.603   6.170  -2.243  1.00 45.35           C 
ATOM     79  CD1 PHE     5      -3.462   7.551  -2.205  1.00  2.03           C 
ATOM     80  CD2 PHE     5      -2.699   5.431  -2.992  1.00 13.44           C 
ATOM     81  CE1 PHE     5      -2.444   8.178  -2.899  1.00 20.41           C 
ATOM     82  CE2 PHE     5      -1.680   6.054  -3.687  1.00 24.04           C 
ATOM     83  CZ  PHE     5      -1.551   7.427  -3.638  1.00 15.13           C 
ATOM     84  H   PHE     5      -6.837   7.141  -2.183  1.00 38.87           H 
ATOM     85  HA  PHE     5      -5.671   4.634  -3.217  1.00 20.31           H 
ATOM     86 3HB  PHE     5      -4.342   4.545  -1.116  1.00 38.87           H 
ATOM     87 2HB  PHE     5      -4.998   6.115  -0.658  1.00 38.87           H 
ATOM     88  HD1 PHE     5      -4.158   8.140  -1.624  1.00 55.23           H 
ATOM     89  HD2 PHE     5      -2.795   4.354  -3.031  1.00 60.12           H 
ATOM     90  HE1 PHE     5      -2.346   9.253  -2.861  1.00 54.03           H 
ATOM     91  HE2 PHE     5      -0.982   5.466  -4.265  1.00 44.45           H 
ATOM     92  HZ  PHE     5      -0.755   7.915  -4.182  1.00 41.14           H 
ATOM     93  N   THR     6      -7.403   3.276  -2.079  1.00 42.34           N 
ATOM     94  CA  THR     6      -8.414   2.428  -1.430  1.00 54.13           C 
ATOM     95  C   THR     6      -7.872   1.028  -1.124  1.00 21.43           C 
ATOM     96  O   THR     6      -6.877   0.596  -1.693  1.00 52.30           O 
ATOM     97  CB  THR     6      -9.687   2.286  -2.300  1.00 24.45           C 
ATOM     98  OG1 THR     6     -10.596   1.350  -1.693  1.00 74.03           O 
ATOM     99  CG2 THR     6      -9.342   1.821  -3.711  1.00 72.10           C 
ATOM    100  H   THR     6      -7.004   2.980  -2.926  1.00 38.87           H 
ATOM    101  HA  THR     6      -8.697   2.899  -0.497  1.00 22.22           H 
ATOM    102  HB  THR     6     -10.170   3.251  -2.364  1.00 75.32           H 
ATOM    103  HG1 THR     6     -11.497   1.538  -1.990  1.00  5.54           H 
ATOM    104 1HG2 THR     6      -8.875   0.849  -3.667  1.00 38.87           H 
ATOM    105 2HG2 THR     6      -8.661   2.526  -4.168  1.00 38.87           H 
ATOM    106 3HG2 THR     6     -10.244   1.760  -4.304  1.00 38.87           H 
ATOM    107  N   LYS     7      -8.550   0.316  -0.232  1.00 40.34           N 
ATOM    108  CA  LYS     7      -8.153  -1.048   0.138  1.00 44.32           C 
ATOM    109  C   LYS     7      -8.366  -2.029  -1.025  1.00 74.01           C 
ATOM    110  O   LYS     7      -7.759  -3.102  -1.067  1.00 64.01           O 
ATOM    111  CB  LYS     7      -8.956  -1.507   1.361  1.00 34.42           C 
ATOM    112  CG  LYS     7     -10.470  -1.494   1.154  1.00 41.34           C 
ATOM    113  CD  LYS     7     -11.213  -1.943   2.409  1.00  3.35           C 
ATOM    114  CE  LYS     7     -10.922  -1.033   3.598  1.00 25.21           C 
ATOM    115  NZ  LYS     7     -11.454  -1.588   4.872  1.00 70.34           N 
ATOM    116  H   LYS     7      -9.347   0.711   0.182  1.00 38.87           H 
ATOM    117  HA  LYS     7      -7.103  -1.031   0.393  1.00  2.20           H 
ATOM    118 3HB  LYS     7      -8.724  -0.856   2.192  1.00 38.87           H 
ATOM    119 2HB  LYS     7      -8.658  -2.515   1.615  1.00 38.87           H 
ATOM    120 3HG  LYS     7     -10.718  -2.164   0.342  1.00 38.87           H 
ATOM    121 2HG  LYS     7     -10.782  -0.491   0.900  1.00 38.87           H 
ATOM    122 3HD  LYS     7     -10.907  -2.951   2.655  1.00 38.87           H 
ATOM    123 2HD  LYS     7     -12.276  -1.930   2.211  1.00 38.87           H 
ATOM    124 3HE  LYS     7     -11.374  -0.068   3.420  1.00 38.87           H 
ATOM    125 2HE  LYS     7      -9.853  -0.916   3.694  1.00 38.87           H 
ATOM    126 1HZ  LYS     7     -12.485  -1.697   4.812  1.00 38.87           H 
ATOM    127 2HZ  LYS     7     -11.229  -0.946   5.660  1.00 38.87           H 
ATOM    128 3HZ  LYS     7     -11.028  -2.517   5.062  1.00 38.87           H 
ATOM    129  N   ASP     8      -9.229  -1.640  -1.962  1.00 23.15           N 
ATOM    130  CA  ASP     8      -9.599  -2.495  -3.095  1.00 40.32           C 
ATOM    131  C   ASP     8      -8.509  -2.519  -4.188  1.00 21.33           C 
ATOM    132  O   ASP     8      -8.319  -3.531  -4.864  1.00 43.43           O 
ATOM    133  CB  ASP     8     -10.930  -2.001  -3.681  1.00 25.40           C 
ATOM    134  CG  ASP     8     -11.526  -2.968  -4.688  1.00 12.34           C 
ATOM    135  OD1 ASP     8     -12.169  -3.949  -4.264  1.00 72.21           O 
ATOM    136  OD2 ASP     8     -11.372  -2.746  -5.906  1.00 45.15           O 
ATOM    137  H   ASP     8      -9.637  -0.751  -1.888  1.00 38.87           H 
ATOM    138  HA  ASP     8      -9.737  -3.500  -2.719  1.00  4.03           H 
ATOM    139 3HB  ASP     8     -10.768  -1.050  -4.170  1.00 38.87           H 
ATOM    140 2HB  ASP     8     -11.639  -1.867  -2.878  1.00 38.87           H 
ATOM    141  N   MET     9      -7.786  -1.406  -4.347  1.00 22.22           N 
ATOM    142  CA  MET     9      -6.770  -1.285  -5.407  1.00 21.14           C 
ATOM    143  C   MET     9      -5.493  -2.072  -5.060  1.00 74.21           C 
ATOM    144  O   MET     9      -5.230  -2.370  -3.894  1.00 20.44           O 
ATOM    145  CB  MET     9      -6.430   0.193  -5.658  1.00 15.42           C 
ATOM    146  CG  MET     9      -5.739   0.873  -4.485  1.00 52.44           C 
ATOM    147  SD  MET     9      -5.650   2.667  -4.666  1.00 14.13           S 
ATOM    148  CE  MET     9      -4.684   2.823  -6.167  1.00 12.05           C 
ATOM    149  H   MET     9      -7.929  -0.658  -3.733  1.00 38.87           H 
ATOM    150  HA  MET     9      -7.192  -1.701  -6.312  1.00 53.05           H 
ATOM    151 3HB  MET     9      -7.343   0.732  -5.871  1.00 38.87           H 
ATOM    152 2HB  MET     9      -5.778   0.261  -6.519  1.00 38.87           H 
ATOM    153 3HG  MET     9      -4.734   0.483  -4.400  1.00 38.87           H 
ATOM    154 2HG  MET     9      -6.286   0.645  -3.585  1.00 38.87           H 
ATOM    155 1HE  MET     9      -4.579   3.868  -6.416  1.00 38.87           H 
ATOM    156 2HE  MET     9      -5.185   2.308  -6.974  1.00 38.87           H 
ATOM    157 3HE  MET     9      -3.707   2.389  -6.013  1.00 38.87           H 
ATOM    158  N   THR    10      -4.699  -2.398  -6.079  1.00 41.40           N 
ATOM    159  CA  THR    10      -3.476  -3.198  -5.894  1.00 42.12           C 
ATOM    160  C   THR    10      -2.262  -2.333  -5.524  1.00 34.11           C 
ATOM    161  O   THR    10      -2.241  -1.123  -5.777  1.00 60.51           O 
ATOM    162  CB  THR    10      -3.126  -3.993  -7.171  1.00  4.44           C 
ATOM    163  OG1 THR    10      -2.801  -3.085  -8.235  1.00 24.12           O 
ATOM    164  CG2 THR    10      -4.283  -4.893  -7.600  1.00 42.43           C 
ATOM    165  H   THR    10      -4.938  -2.101  -6.981  1.00 38.87           H 
ATOM    166  HA  THR    10      -3.656  -3.905  -5.095  1.00 52.02           H 
ATOM    167  HB  THR    10      -2.263  -4.615  -6.966  1.00 32.44           H 
ATOM    168  HG1 THR    10      -2.704  -3.581  -9.059  1.00 21.12           H 
ATOM    169 1HG2 THR    10      -5.146  -4.286  -7.834  1.00 38.87           H 
ATOM    170 2HG2 THR    10      -4.530  -5.573  -6.797  1.00 38.87           H 
ATOM    171 3HG2 THR    10      -3.995  -5.460  -8.474  1.00 38.87           H 
ATOM    172  N   PHE    11      -1.244  -2.964  -4.935  1.00 75.24           N 
ATOM    173  CA  PHE    11       0.007  -2.274  -4.599  1.00  0.34           C 
ATOM    174  C   PHE    11       0.663  -1.656  -5.845  1.00 12.02           C 
ATOM    175  O   PHE    11       1.131  -0.516  -5.810  1.00 75.13           O 
ATOM    176  CB  PHE    11       0.990  -3.241  -3.921  1.00 53.52           C 
ATOM    177  CG  PHE    11       0.574  -3.675  -2.535  1.00  4.04           C 
ATOM    178  CD1 PHE    11       0.923  -2.917  -1.426  1.00 20.14           C 
ATOM    179  CD2 PHE    11      -0.156  -4.837  -2.340  1.00 72.14           C 
ATOM    180  CE1 PHE    11       0.553  -3.310  -0.154  1.00 60.41           C 
ATOM    181  CE2 PHE    11      -0.529  -5.235  -1.070  1.00 23.33           C 
ATOM    182  CZ  PHE    11      -0.174  -4.469   0.024  1.00 62.13           C 
ATOM    183  H   PHE    11      -1.338  -3.919  -4.714  1.00 38.87           H 
ATOM    184  HA  PHE    11      -0.235  -1.479  -3.905  1.00 35.22           H 
ATOM    185 3HB  PHE    11       1.957  -2.763  -3.843  1.00 38.87           H 
ATOM    186 2HB  PHE    11       1.085  -4.128  -4.529  1.00 38.87           H 
ATOM    187  HD1 PHE    11       1.490  -2.008  -1.562  1.00 20.15           H 
ATOM    188  HD2 PHE    11      -0.434  -5.437  -3.193  1.00 24.11           H 
ATOM    189  HE1 PHE    11       0.832  -2.711   0.701  1.00 60.41           H 
ATOM    190  HE2 PHE    11      -1.098  -6.142  -0.933  1.00  2.33           H 
ATOM    191  HZ  PHE    11      -0.465  -4.779   1.019  1.00 40.11           H 
ATOM    192  N   ALA    12       0.680  -2.410  -6.947  1.00 70.34           N 
ATOM    193  CA  ALA    12       1.281  -1.939  -8.205  1.00 33.55           C 
ATOM    194  C   ALA    12       0.640  -0.629  -8.686  1.00 13.22           C 
ATOM    195  O   ALA    12       1.330   0.279  -9.156  1.00 52.42           O 
ATOM    196  CB  ALA    12       1.163  -3.010  -9.286  1.00 54.15           C 
ATOM    197  H   ALA    12       0.275  -3.304  -6.919  1.00 38.87           H 
ATOM    198  HA  ALA    12       2.335  -1.765  -8.022  1.00 64.43           H 
ATOM    199 1HB  ALA    12       1.660  -2.672 -10.185  1.00 38.87           H 
ATOM    200 2HB  ALA    12       0.120  -3.193  -9.500  1.00 38.87           H 
ATOM    201 3HB  ALA    12       1.625  -3.924  -8.943  1.00 38.87           H 
ATOM    202  N   GLN    13      -0.683  -0.532  -8.568  1.00 73.00           N 
ATOM    203  CA  GLN    13      -1.398   0.686  -8.958  1.00 55.15           C 
ATOM    204  C   GLN    13      -1.078   1.850  -8.005  1.00 63.15           C 
ATOM    205  O   GLN    13      -0.847   2.976  -8.447  1.00  3.14           O 
ATOM    206  CB  GLN    13      -2.910   0.428  -9.010  1.00  4.02           C 
ATOM    207  CG  GLN    13      -3.316  -0.584 -10.078  1.00 34.02           C 
ATOM    208  CD  GLN    13      -4.820  -0.787 -10.183  1.00 70.24           C 
ATOM    209  OE1 GLN    13      -5.295  -1.868 -10.517  1.00 23.12           O 
ATOM    210  NE2 GLN    13      -5.584   0.254  -9.915  1.00 41.33           N 
ATOM    211  H   GLN    13      -1.191  -1.297  -8.216  1.00 38.87           H 
ATOM    212  HA  GLN    13      -1.059   0.957  -9.951  1.00 11.24           H 
ATOM    213 3HB  GLN    13      -3.419   1.360  -9.214  1.00 38.87           H 
ATOM    214 2HB  GLN    13      -3.234   0.056  -8.047  1.00 38.87           H 
ATOM    215 3HG  GLN    13      -2.857  -1.535  -9.842  1.00 38.87           H 
ATOM    216 2HG  GLN    13      -2.951  -0.242 -11.035  1.00 38.87           H 
ATOM    217 1HE2 GLN    13      -5.153   1.095  -9.665  1.00 38.87           H 
ATOM    218 2HE2 GLN    13      -6.553   0.137  -9.979  1.00 38.87           H 
ATOM    219  N   ALA    14      -1.047   1.571  -6.700  1.00  1.31           N 
ATOM    220  CA  ALA    14      -0.723   2.593  -5.694  1.00  5.31           C 
ATOM    221  C   ALA    14       0.665   3.211  -5.941  1.00  2.11           C 
ATOM    222  O   ALA    14       0.819   4.437  -5.971  1.00  2.23           O 
ATOM    223  CB  ALA    14      -0.802   2.000  -4.293  1.00 72.04           C 
ATOM    224  H   ALA    14      -1.251   0.656  -6.402  1.00 38.87           H 
ATOM    225  HA  ALA    14      -1.467   3.374  -5.768  1.00 23.12           H 
ATOM    226 1HB  ALA    14      -0.639   2.778  -3.561  1.00 38.87           H 
ATOM    227 2HB  ALA    14      -0.045   1.237  -4.179  1.00 38.87           H 
ATOM    228 3HB  ALA    14      -1.778   1.562  -4.142  1.00 38.87           H 
ATOM    229  N   LEU    15       1.666   2.352  -6.140  1.00 53.00           N 
ATOM    230  CA  LEU    15       3.043   2.799  -6.408  1.00 61.24           C 
ATOM    231  C   LEU    15       3.117   3.723  -7.636  1.00 71.12           C 
ATOM    232  O   LEU    15       3.826   4.728  -7.628  1.00  1.44           O 
ATOM    233  CB  LEU    15       3.962   1.585  -6.618  1.00 53.10           C 
ATOM    234  CG  LEU    15       4.110   0.651  -5.403  1.00 11.51           C 
ATOM    235  CD1 LEU    15       5.003  -0.542  -5.739  1.00 11.14           C 
ATOM    236  CD2 LEU    15       4.658   1.412  -4.198  1.00 15.41           C 
ATOM    237  H   LEU    15       1.477   1.389  -6.101  1.00 38.87           H 
ATOM    238  HA  LEU    15       3.386   3.347  -5.542  1.00 72.23           H 
ATOM    239 3HB  LEU    15       4.947   1.945  -6.885  1.00 38.87           H 
ATOM    240 2HB  LEU    15       3.575   1.007  -7.446  1.00 38.87           H 
ATOM    241  HG  LEU    15       3.135   0.266  -5.138  1.00  1.04           H 
ATOM    242 1HD1 LEU    15       4.546  -1.124  -6.528  1.00 38.87           H 
ATOM    243 2HD1 LEU    15       5.125  -1.162  -4.862  1.00 38.87           H 
ATOM    244 3HD1 LEU    15       5.969  -0.190  -6.068  1.00 38.87           H 
ATOM    245 1HD2 LEU    15       4.760   0.736  -3.361  1.00 38.87           H 
ATOM    246 2HD2 LEU    15       3.978   2.208  -3.933  1.00 38.87           H 
ATOM    247 3HD2 LEU    15       5.625   1.830  -4.441  1.00 38.87           H 
ATOM    248  N   GLN    16       2.375   3.378  -8.690  1.00  1.31           N 
ATOM    249  CA  GLN    16       2.369   4.172  -9.929  1.00 61.42           C 
ATOM    250  C   GLN    16       1.474   5.419  -9.814  1.00 74.42           C 
ATOM    251  O   GLN    16       1.464   6.269 -10.704  1.00 23.42           O 
ATOM    252  CB  GLN    16       1.923   3.300 -11.111  1.00  0.13           C 
ATOM    253  CG  GLN    16       2.841   2.107 -11.372  1.00 55.04           C 
ATOM    254  CD  GLN    16       4.251   2.515 -11.770  1.00 54.54           C 
ATOM    255  OE1 GLN    16       4.561   2.667 -12.949  1.00  2.11           O 
ATOM    256  NE2 GLN    16       5.118   2.697 -10.795  1.00 32.00           N 
ATOM    257  H   GLN    16       1.819   2.571  -8.637  1.00 38.87           H 
ATOM    258  HA  GLN    16       3.384   4.500 -10.108  1.00 53.34           H 
ATOM    259 3HB  GLN    16       1.893   3.906 -12.005  1.00 38.87           H 
ATOM    260 2HB  GLN    16       0.931   2.921 -10.910  1.00 38.87           H 
ATOM    261 3HG  GLN    16       2.417   1.511 -12.167  1.00 38.87           H 
ATOM    262 2HG  GLN    16       2.897   1.512 -10.473  1.00 38.87           H 
ATOM    263 1HE2 GLN    16       4.817   2.564  -9.876  1.00 38.87           H 
ATOM    264 2HE2 GLN    16       6.032   2.966 -11.034  1.00 38.87           H 
ATOM    265  N   THR    17       0.717   5.518  -8.720  1.00 10.44           N 
ATOM    266  CA  THR    17      -0.111   6.706  -8.458  1.00  2.23           C 
ATOM    267  C   THR    17       0.702   7.796  -7.733  1.00 63.00           C 
ATOM    268  O   THR    17       0.578   8.983  -8.031  1.00 23.51           O 
ATOM    269  CB  THR    17      -1.369   6.349  -7.620  1.00 70.42           C 
ATOM    270  OG1 THR    17      -2.182   5.395  -8.327  1.00 42.52           O 
ATOM    271  CG2 THR    17      -2.207   7.586  -7.315  1.00 72.44           C 
ATOM    272  H   THR    17       0.712   4.779  -8.077  1.00 38.87           H 
ATOM    273  HA  THR    17      -0.441   7.098  -9.412  1.00 24.45           H 
ATOM    274  HB  THR    17      -1.047   5.908  -6.685  1.00 42.02           H 
ATOM    275  HG1 THR    17      -1.640   4.636  -8.579  1.00 52.45           H 
ATOM    276 1HG2 THR    17      -3.079   7.300  -6.745  1.00 38.87           H 
ATOM    277 2HG2 THR    17      -2.517   8.051  -8.239  1.00 38.87           H 
ATOM    278 3HG2 THR    17      -1.617   8.288  -6.742  1.00 38.87           H 
ATOM    279  N   HIS    18       1.525   7.382  -6.767  1.00 50.52           N 
ATOM    280  CA  HIS    18       2.451   8.292  -6.072  1.00 51.53           C 
ATOM    281  C   HIS    18       3.724   7.545  -5.632  1.00 31.25           C 
ATOM    282  O   HIS    18       3.657   6.646  -4.799  1.00 60.41           O 
ATOM    283  CB  HIS    18       1.783   8.934  -4.842  1.00 53.14           C 
ATOM    284  CG  HIS    18       0.845  10.060  -5.164  1.00  0.11           C 
ATOM    285  ND1 HIS    18      -0.476   9.869  -5.500  1.00 44.23           N 
ATOM    286  CD2 HIS    18       1.042  11.401  -5.190  1.00 65.24           C 
ATOM    287  CE1 HIS    18      -1.049  11.033  -5.720  1.00 14.31           C 
ATOM    288  NE2 HIS    18      -0.154  11.980  -5.538  1.00 73.21           N 
ATOM    289  H   HIS    18       1.515   6.433  -6.510  1.00 38.87           H 
ATOM    290  HA  HIS    18       2.729   9.074  -6.767  1.00 42.31           H 
ATOM    291 3HB  HIS    18       2.550   9.321  -4.186  1.00 38.87           H 
ATOM    292 2HB  HIS    18       1.221   8.179  -4.313  1.00 38.87           H 
ATOM    293  HD1 HIS    18      -0.923   9.006  -5.581  1.00  0.44           H 
ATOM    294  HD2 HIS    18       1.966  11.919  -4.974  1.00 42.41           H 
ATOM    295  HE1 HIS    18      -2.081  11.186  -5.997  1.00 43.22           H 
ATOM    296  HE2 HIS    18      -0.266  12.914  -5.823  1.00 38.87           H 
ATOM    297  N   PRO    19       4.902   7.911  -6.176  1.00 44.11           N 
ATOM    298  CA  PRO    19       6.182   7.268  -5.806  1.00 61.45           C 
ATOM    299  C   PRO    19       6.439   7.262  -4.282  1.00  3.03           C 
ATOM    300  O   PRO    19       7.054   6.334  -3.750  1.00 32.42           O 
ATOM    301  CB  PRO    19       7.228   8.125  -6.530  1.00 61.40           C 
ATOM    302  CG  PRO    19       6.492   8.706  -7.691  1.00 64.24           C 
ATOM    303  CD  PRO    19       5.090   8.959  -7.201  1.00 13.23           C 
ATOM    304  HA  PRO    19       6.228   6.252  -6.176  1.00 73.34           H 
ATOM    305 3HB  PRO    19       8.051   7.503  -6.854  1.00 38.87           H 
ATOM    306 2HB  PRO    19       7.593   8.898  -5.866  1.00 38.87           H 
ATOM    307 3HG  PRO    19       6.482   8.000  -8.510  1.00 38.87           H 
ATOM    308 2HG  PRO    19       6.957   9.632  -7.999  1.00 38.87           H 
ATOM    309 3HD  PRO    19       4.379   8.843  -8.008  1.00 38.87           H 
ATOM    310 2HD  PRO    19       5.010   9.944  -6.764  1.00 38.87           H 
ATOM    311  N   GLY    20       5.956   8.297  -3.587  1.00 21.51           N 
ATOM    312  CA  GLY    20       6.109   8.377  -2.132  1.00 71.35           C 
ATOM    313  C   GLY    20       5.455   7.215  -1.384  1.00  4.24           C 
ATOM    314  O   GLY    20       5.810   6.920  -0.237  1.00 31.31           O 
ATOM    315  H   GLY    20       5.499   9.021  -4.066  1.00 38.87           H 
ATOM    316 3HA  GLY    20       5.665   9.301  -1.789  1.00 38.87           H 
ATOM    317 2HA  GLY    20       7.164   8.392  -1.895  1.00 38.87           H 
ATOM    318  N   VAL    21       4.496   6.555  -2.036  1.00 12.22           N 
ATOM    319  CA  VAL    21       3.830   5.378  -1.467  1.00  3.14           C 
ATOM    320  C   VAL    21       4.841   4.265  -1.148  1.00 25.24           C 
ATOM    321  O   VAL    21       4.709   3.566  -0.145  1.00 20.22           O 
ATOM    322  CB  VAL    21       2.737   4.831  -2.428  1.00 21.02           C 
ATOM    323  CG1 VAL    21       2.127   3.532  -1.901  1.00 22.41           C 
ATOM    324  CG2 VAL    21       1.649   5.880  -2.649  1.00 64.42           C 
ATOM    325  H   VAL    21       4.228   6.868  -2.926  1.00 38.87           H 
ATOM    326  HA  VAL    21       3.348   5.682  -0.547  1.00 32.31           H 
ATOM    327  HB  VAL    21       3.201   4.620  -3.384  1.00 72.31           H 
ATOM    328 1HG1 VAL    21       2.904   2.789  -1.790  1.00 38.87           H 
ATOM    329 2HG1 VAL    21       1.385   3.171  -2.599  1.00 38.87           H 
ATOM    330 3HG1 VAL    21       1.663   3.714  -0.943  1.00 38.87           H 
ATOM    331 1HG2 VAL    21       0.920   5.504  -3.352  1.00 38.87           H 
ATOM    332 2HG2 VAL    21       2.095   6.783  -3.044  1.00 38.87           H 
ATOM    333 3HG2 VAL    21       1.164   6.101  -1.710  1.00 38.87           H 
ATOM    334  N   ALA    22       5.865   4.125  -1.991  1.00  3.15           N 
ATOM    335  CA  ALA    22       6.918   3.126  -1.775  1.00 70.13           C 
ATOM    336  C   ALA    22       7.591   3.312  -0.404  1.00 44.44           C 
ATOM    337  O   ALA    22       7.781   2.349   0.340  1.00 33.33           O 
ATOM    338  CB  ALA    22       7.957   3.198  -2.890  1.00 74.52           C 
ATOM    339  H   ALA    22       5.917   4.712  -2.776  1.00 38.87           H 
ATOM    340  HA  ALA    22       6.457   2.146  -1.807  1.00 11.14           H 
ATOM    341 1HB  ALA    22       7.476   3.039  -3.845  1.00 38.87           H 
ATOM    342 2HB  ALA    22       8.708   2.436  -2.736  1.00 38.87           H 
ATOM    343 3HB  ALA    22       8.428   4.171  -2.885  1.00 38.87           H 
ATOM    344  N   GLY    23       7.933   4.558  -0.075  1.00 40.23           N 
ATOM    345  CA  GLY    23       8.535   4.858   1.222  1.00 63.24           C 
ATOM    346  C   GLY    23       7.622   4.506   2.392  1.00 72.20           C 
ATOM    347  O   GLY    23       8.058   3.897   3.373  1.00 14.24           O 
ATOM    348  H   GLY    23       7.774   5.282  -0.716  1.00 38.87           H 
ATOM    349 3HA  GLY    23       8.760   5.914   1.264  1.00 38.87           H 
ATOM    350 2HA  GLY    23       9.458   4.302   1.314  1.00 38.87           H 
ATOM    351  N   VAL    24       6.350   4.883   2.280  1.00 11.32           N 
ATOM    352  CA  VAL    24       5.350   4.561   3.304  1.00  4.13           C 
ATOM    353  C   VAL    24       5.216   3.040   3.488  1.00 52.01           C 
ATOM    354  O   VAL    24       5.308   2.528   4.605  1.00 65.42           O 
ATOM    355  CB  VAL    24       3.964   5.165   2.949  1.00 15.43           C 
ATOM    356  CG1 VAL    24       2.918   4.832   4.017  1.00 62.13           C 
ATOM    357  CG2 VAL    24       4.073   6.677   2.755  1.00 55.22           C 
ATOM    358  H   VAL    24       6.076   5.392   1.487  1.00 38.87           H 
ATOM    359  HA  VAL    24       5.681   4.996   4.238  1.00 44.24           H 
ATOM    360  HB  VAL    24       3.636   4.731   2.013  1.00 63.23           H 
ATOM    361 1HG1 VAL    24       2.821   3.758   4.105  1.00 38.87           H 
ATOM    362 2HG1 VAL    24       1.964   5.256   3.732  1.00 38.87           H 
ATOM    363 3HG1 VAL    24       3.225   5.244   4.968  1.00 38.87           H 
ATOM    364 1HG2 VAL    24       3.105   7.082   2.499  1.00 38.87           H 
ATOM    365 2HG2 VAL    24       4.772   6.889   1.958  1.00 38.87           H 
ATOM    366 3HG2 VAL    24       4.425   7.135   3.669  1.00 38.87           H 
ATOM    367  N   LEU    25       5.024   2.319   2.383  1.00 21.21           N 
ATOM    368  CA  LEU    25       4.890   0.859   2.421  1.00 24.54           C 
ATOM    369  C   LEU    25       6.124   0.189   3.054  1.00 52.53           C 
ATOM    370  O   LEU    25       5.991  -0.631   3.961  1.00  0.34           O 
ATOM    371  CB  LEU    25       4.646   0.301   1.009  1.00 23.11           C 
ATOM    372  CG  LEU    25       3.344   0.768   0.333  1.00 14.31           C 
ATOM    373  CD1 LEU    25       3.195   0.130  -1.046  1.00 41.41           C 
ATOM    374  CD2 LEU    25       2.129   0.460   1.211  1.00 73.14           C 
ATOM    375  H   LEU    25       4.969   2.780   1.519  1.00 38.87           H 
ATOM    376  HA  LEU    25       4.029   0.631   3.035  1.00 24.42           H 
ATOM    377 3HB  LEU    25       4.625  -0.779   1.069  1.00 38.87           H 
ATOM    378 2HB  LEU    25       5.478   0.590   0.381  1.00 38.87           H 
ATOM    379  HG  LEU    25       3.389   1.839   0.194  1.00 22.14           H 
ATOM    380 1HD1 LEU    25       3.158  -0.945  -0.949  1.00 38.87           H 
ATOM    381 2HD1 LEU    25       4.040   0.405  -1.662  1.00 38.87           H 
ATOM    382 3HD1 LEU    25       2.284   0.480  -1.512  1.00 38.87           H 
ATOM    383 1HD2 LEU    25       1.231   0.811   0.723  1.00 38.87           H 
ATOM    384 2HD2 LEU    25       2.236   0.962   2.163  1.00 38.87           H 
ATOM    385 3HD2 LEU    25       2.059  -0.605   1.374  1.00 38.87           H 
ATOM    386  N   ARG    26       7.321   0.551   2.592  1.00 43.22           N 
ATOM    387  CA  ARG    26       8.560  -0.020   3.145  1.00 41.55           C 
ATOM    388  C   ARG    26       8.698   0.292   4.646  1.00 10.22           C 
ATOM    389  O   ARG    26       9.154  -0.547   5.426  1.00 44.14           O 
ATOM    390  CB  ARG    26       9.791   0.483   2.372  1.00  1.12           C 
ATOM    391  CG  ARG    26       9.792   0.088   0.895  1.00  0.12           C 
ATOM    392  CD  ARG    26      11.120   0.413   0.213  1.00 14.24           C 
ATOM    393  NE  ARG    26      12.212  -0.415   0.721  1.00  2.21           N 
ATOM    394  CZ  ARG    26      13.444  -0.363   0.284  1.00 72.04           C 
ATOM    395  NH1 ARG    26      13.782   0.443  -0.671  1.00 25.00           N 
ATOM    396  NH2 ARG    26      14.337  -1.136   0.804  1.00 23.25           N 
ATOM    397  H   ARG    26       7.375   1.216   1.870  1.00 38.87           H 
ATOM    398  HA  ARG    26       8.497  -1.094   3.028  1.00 20.25           H 
ATOM    399 3HB  ARG    26      10.682   0.077   2.833  1.00 38.87           H 
ATOM    400 2HB  ARG    26       9.825   1.562   2.434  1.00 38.87           H 
ATOM    401 3HG  ARG    26       8.999   0.622   0.391  1.00 38.87           H 
ATOM    402 2HG  ARG    26       9.613  -0.975   0.818  1.00 38.87           H 
ATOM    403 3HD  ARG    26      11.356   1.454   0.388  1.00 38.87           H 
ATOM    404 2HD  ARG    26      11.015   0.242  -0.848  1.00 38.87           H 
ATOM    405  HE  ARG    26      12.007  -1.048   1.436  1.00 75.23           H 
ATOM    406 1HH1 ARG    26      13.104   1.036  -1.087  1.00 38.87           H 
ATOM    407 2HH1 ARG    26      14.729   0.464  -0.989  1.00 38.87           H 
ATOM    408 1HH2 ARG    26      14.081  -1.766   1.535  1.00 38.87           H 
ATOM    409 2HH2 ARG    26      15.281  -1.099   0.479  1.00 38.87           H 
ATOM    410  N   SER    27       8.287   1.495   5.048  1.00 41.25           N 
ATOM    411  CA  SER    27       8.268   1.880   6.470  1.00 31.14           C 
ATOM    412  C   SER    27       7.256   1.030   7.257  1.00 64.51           C 
ATOM    413  O   SER    27       7.441   0.755   8.444  1.00  3.25           O 
ATOM    414  CB  SER    27       7.918   3.370   6.624  1.00 40.22           C 
ATOM    415  OG  SER    27       7.865   3.759   7.991  1.00 31.31           O 
ATOM    416  H   SER    27       7.994   2.146   4.373  1.00 38.87           H 
ATOM    417  HA  SER    27       9.255   1.708   6.873  1.00 70.30           H 
ATOM    418 3HB  SER    27       6.952   3.559   6.174  1.00 38.87           H 
ATOM    419 2HB  SER    27       8.666   3.968   6.125  1.00 38.87           H 
ATOM    420  HG  SER    27       8.739   3.656   8.392  1.00 30.31           H 
ATOM    421  N   TYR    28       6.184   0.617   6.583  1.00 45.01           N 
ATOM    422  CA  TYR    28       5.142  -0.224   7.194  1.00 74.51           C 
ATOM    423  C   TYR    28       5.395  -1.724   6.958  1.00 14.23           C 
ATOM    424  O   TYR    28       4.470  -2.529   7.046  1.00 61.03           O 
ATOM    425  CB  TYR    28       3.757   0.166   6.641  1.00 74.03           C 
ATOM    426  CG  TYR    28       3.189   1.441   7.242  1.00 11.24           C 
ATOM    427  CD1 TYR    28       3.911   2.627   7.217  1.00 10.44           C 
ATOM    428  CD2 TYR    28       1.933   1.452   7.841  1.00 20.03           C 
ATOM    429  CE1 TYR    28       3.401   3.784   7.767  1.00 34.33           C 
ATOM    430  CE2 TYR    28       1.416   2.610   8.391  1.00  2.12           C 
ATOM    431  CZ  TYR    28       2.154   3.774   8.356  1.00 71.44           C 
ATOM    432  OH  TYR    28       1.646   4.929   8.911  1.00 63.15           O 
ATOM    433  H   TYR    28       6.081   0.892   5.647  1.00 38.87           H 
ATOM    434  HA  TYR    28       5.152  -0.041   8.260  1.00 10.33           H 
ATOM    435 3HB  TYR    28       3.058  -0.636   6.840  1.00 38.87           H 
ATOM    436 2HB  TYR    28       3.829   0.309   5.572  1.00 38.87           H 
ATOM    437  HD1 TYR    28       4.889   2.637   6.754  1.00 12.04           H 
ATOM    438  HD2 TYR    28       1.354   0.539   7.870  1.00 44.32           H 
ATOM    439  HE1 TYR    28       3.982   4.695   7.734  1.00 31.13           H 
ATOM    440  HE2 TYR    28       0.437   2.597   8.852  1.00  5.42           H 
ATOM    441  HH  TYR    28       1.231   4.715   9.759  1.00 22.42           H 
ATOM    442  N   ASN    29       6.644  -2.094   6.655  1.00 64.12           N 
ATOM    443  CA  ASN    29       7.027  -3.510   6.467  1.00  3.31           C 
ATOM    444  C   ASN    29       6.394  -4.116   5.189  1.00 13.52           C 
ATOM    445  O   ASN    29       6.542  -5.306   4.904  1.00 14.04           O 
ATOM    446  CB  ASN    29       6.643  -4.328   7.718  1.00 42.21           C 
ATOM    447  CG  ASN    29       7.083  -5.781   7.648  1.00 55.45           C 
ATOM    448  OD1 ASN    29       6.340  -6.648   7.204  1.00  2.11           O 
ATOM    449  ND2 ASN    29       8.292  -6.057   8.086  1.00 52.35           N 
ATOM    450  H   ASN    29       7.330  -1.400   6.555  1.00 38.87           H 
ATOM    451  HA  ASN    29       8.102  -3.537   6.355  1.00 41.34           H 
ATOM    452 3HB  ASN    29       5.569  -4.304   7.836  1.00 38.87           H 
ATOM    453 2HB  ASN    29       7.100  -3.880   8.587  1.00 38.87           H 
ATOM    454 1HD2 ASN    29       8.839  -5.324   8.432  1.00 38.87           H 
ATOM    455 2HD2 ASN    29       8.592  -6.988   8.043  1.00 38.87           H 
ATOM    456  N   LEU    30       5.707  -3.287   4.409  1.00 42.54           N 
ATOM    457  CA  LEU    30       5.067  -3.732   3.164  1.00 61.32           C 
ATOM    458  C   LEU    30       6.007  -3.584   1.953  1.00 62.13           C 
ATOM    459  O   LEU    30       5.570  -3.662   0.807  1.00  2.11           O 
ATOM    460  CB  LEU    30       3.776  -2.933   2.923  1.00 24.14           C 
ATOM    461  CG  LEU    30       2.688  -3.094   3.998  1.00 61.14           C 
ATOM    462  CD1 LEU    30       1.493  -2.193   3.696  1.00 70.13           C 
ATOM    463  CD2 LEU    30       2.251  -4.551   4.108  1.00 20.11           C 
ATOM    464  H   LEU    30       5.621  -2.348   4.676  1.00 38.87           H 
ATOM    465  HA  LEU    30       4.812  -4.777   3.276  1.00 51.02           H 
ATOM    466 3HB  LEU    30       3.359  -3.238   1.973  1.00 38.87           H 
ATOM    467 2HB  LEU    30       4.037  -1.885   2.860  1.00 38.87           H 
ATOM    468  HG  LEU    30       3.092  -2.795   4.956  1.00 61.31           H 
ATOM    469 1HD1 LEU    30       0.737  -2.329   4.455  1.00 38.87           H 
ATOM    470 2HD1 LEU    30       1.080  -2.449   2.730  1.00 38.87           H 
ATOM    471 3HD1 LEU    30       1.812  -1.161   3.688  1.00 38.87           H 
ATOM    472 1HD2 LEU    30       3.098  -5.161   4.389  1.00 38.87           H 
ATOM    473 2HD2 LEU    30       1.867  -4.888   3.155  1.00 38.87           H 
ATOM    474 3HD2 LEU    30       1.479  -4.642   4.859  1.00 38.87           H 
ATOM    475  N   GLY    31       7.298  -3.384   2.208  1.00  4.45           N 
ATOM    476  CA  GLY    31       8.267  -3.263   1.121  1.00 25.11           C 
ATOM    477  C   GLY    31       8.489  -4.576   0.377  1.00 51.33           C 
ATOM    478  O   GLY    31       8.813  -4.585  -0.811  1.00 73.35           O 
ATOM    479  H   GLY    31       7.599  -3.325   3.139  1.00 38.87           H 
ATOM    480 3HA  GLY    31       9.210  -2.932   1.534  1.00 38.87           H 
ATOM    481 2HA  GLY    31       7.918  -2.520   0.419  1.00 38.87           H 
ATOM    482  N   CYS    32       8.287  -5.688   1.081  1.00 72.02           N 
ATOM    483  CA  CYS    32       8.477  -7.034   0.510  1.00 52.11           C 
ATOM    484  C   CYS    32       7.477  -7.351  -0.620  1.00 14.33           C 
ATOM    485  O   CYS    32       7.585  -8.391  -1.272  1.00 35.15           O 
ATOM    486  CB  CYS    32       8.352  -8.092   1.616  1.00 20.22           C 
ATOM    487  SG  CYS    32       9.502  -7.864   2.995  1.00 30.33           S 
ATOM    488  H   CYS    32       8.028  -5.606   2.026  1.00 38.87           H 
ATOM    489  HA  CYS    32       9.479  -7.080   0.105  1.00 13.22           H 
ATOM    490 3HB  CYS    32       8.538  -9.069   1.194  1.00 38.87           H 
ATOM    491 2HB  CYS    32       7.351  -8.064   2.020  1.00 38.87           H 
ATOM    492  HG  CYS    32       9.160  -8.712   3.958  1.00  3.32           H 
ATOM    493  N   ILE    33       6.510  -6.455  -0.857  1.00 11.23           N 
ATOM    494  CA  ILE    33       5.483  -6.663  -1.894  1.00 42.40           C 
ATOM    495  C   ILE    33       6.089  -6.954  -3.277  1.00  4.14           C 
ATOM    496  O   ILE    33       5.490  -7.666  -4.089  1.00 21.25           O 
ATOM    497  CB  ILE    33       4.536  -5.443  -2.016  1.00 34.23           C 
ATOM    498  CG1 ILE    33       5.346  -4.154  -2.264  1.00 44.15           C 
ATOM    499  CG2 ILE    33       3.659  -5.319  -0.769  1.00 34.32           C 
ATOM    500  CD1 ILE    33       4.493  -2.917  -2.453  1.00 44.31           C 
ATOM    501  H   ILE    33       6.486  -5.633  -0.322  1.00 38.87           H 
ATOM    502  HA  ILE    33       4.888  -7.517  -1.596  1.00 43.20           H 
ATOM    503  HB  ILE    33       3.880  -5.612  -2.861  1.00 31.14           H 
ATOM    504 3HG1 ILE    33       5.948  -4.279  -3.155  1.00 38.87           H 
ATOM    505 2HG1 ILE    33       5.998  -3.977  -1.422  1.00 38.87           H 
ATOM    506 1HG2 ILE    33       4.284  -5.174   0.101  1.00 38.87           H 
ATOM    507 2HG2 ILE    33       3.076  -6.220  -0.646  1.00 38.87           H 
ATOM    508 3HG2 ILE    33       2.992  -4.474  -0.877  1.00 38.87           H 
ATOM    509 1HD1 ILE    33       3.902  -2.745  -1.565  1.00 38.87           H 
ATOM    510 2HD1 ILE    33       3.838  -3.055  -3.301  1.00 38.87           H 
ATOM    511 3HD1 ILE    33       5.133  -2.064  -2.630  1.00 38.87           H 
ATOM    512  N   GLY    34       7.265  -6.394  -3.547  1.00 63.23           N 
ATOM    513  CA  GLY    34       7.939  -6.647  -4.814  1.00 72.44           C 
ATOM    514  C   GLY    34       8.489  -8.069  -4.918  1.00 55.21           C 
ATOM    515  O   GLY    34       8.434  -8.691  -5.979  1.00  4.52           O 
ATOM    516  H   GLY    34       7.679  -5.800  -2.881  1.00 38.87           H 
ATOM    517 3HA  GLY    34       8.759  -5.952  -4.918  1.00 38.87           H 
ATOM    518 2HA  GLY    34       7.240  -6.483  -5.620  1.00 38.87           H 
ATOM    519  N   CYS    35       9.005  -8.589  -3.808  1.00  2.01           N 
ATOM    520  CA  CYS    35       9.587  -9.938  -3.775  1.00 52.44           C 
ATOM    521  C   CYS    35       8.500 -11.026  -3.747  1.00 23.13           C 
ATOM    522  O   CYS    35       8.498 -11.938  -4.576  1.00 35.54           O 
ATOM    523  CB  CYS    35      10.504 -10.083  -2.555  1.00 45.14           C 
ATOM    524  SG  CYS    35      11.322 -11.690  -2.418  1.00 44.42           S 
ATOM    525  H   CYS    35       8.999  -8.054  -2.987  1.00 38.87           H 
ATOM    526  HA  CYS    35      10.180 -10.065  -4.672  1.00 14.22           H 
ATOM    527 3HB  CYS    35       9.921  -9.933  -1.657  1.00 38.87           H 
ATOM    528 2HB  CYS    35      11.275  -9.330  -2.605  1.00 38.87           H 
ATOM    529  HG  CYS    35      10.648 -12.559  -3.160  1.00 22.02           H 
ATOM    530  N   MET    36       7.564 -10.914  -2.801  1.00 55.31           N 
ATOM    531  CA  MET    36       6.475 -11.897  -2.654  1.00 70.22           C 
ATOM    532  C   MET    36       5.467 -11.836  -3.823  1.00 43.33           C 
ATOM    533  O   MET    36       4.520 -12.621  -3.879  1.00 61.33           O 
ATOM    534  CB  MET    36       5.745 -11.684  -1.316  1.00 63.22           C 
ATOM    535  CG  MET    36       5.045 -10.335  -1.197  1.00 54.23           C 
ATOM    536  SD  MET    36       4.314 -10.059   0.433  1.00 50.02           S 
ATOM    537  CE  MET    36       3.132 -11.405   0.521  1.00  5.25           C 
ATOM    538  H   MET    36       7.613 -10.160  -2.173  1.00 38.87           H 
ATOM    539  HA  MET    36       6.925 -12.880  -2.647  1.00 60.22           H 
ATOM    540 3HB  MET    36       6.463 -11.762  -0.512  1.00 38.87           H 
ATOM    541 2HB  MET    36       5.005 -12.461  -1.195  1.00 38.87           H 
ATOM    542 3HG  MET    36       4.261 -10.285  -1.939  1.00 38.87           H 
ATOM    543 2HG  MET    36       5.764  -9.553  -1.386  1.00 38.87           H 
ATOM    544 1HE  MET    36       2.410 -11.304  -0.276  1.00 38.87           H 
ATOM    545 2HE  MET    36       2.623 -11.376   1.473  1.00 38.87           H 
ATOM    546 3HE  MET    36       3.651 -12.347   0.418  1.00 38.87           H 
ATOM    547  N   GLY    37       5.675 -10.901  -4.753  1.00 33.50           N 
ATOM    548  CA  GLY    37       4.788 -10.772  -5.909  1.00 30.42           C 
ATOM    549  C   GLY    37       3.416 -10.192  -5.565  1.00  5.13           C 
ATOM    550  O   GLY    37       2.431 -10.448  -6.257  1.00 43.15           O 
ATOM    551  H   GLY    37       6.445 -10.303  -4.665  1.00 38.87           H 
ATOM    552 3HA  GLY    37       4.652 -11.749  -6.353  1.00 38.87           H 
ATOM    553 2HA  GLY    37       5.261 -10.127  -6.635  1.00 38.87           H 
ATOM    554  N   ALA    38       3.358  -9.380  -4.511  1.00 21.33           N 
ATOM    555  CA  ALA    38       2.093  -8.779  -4.065  1.00 60.21           C 
ATOM    556  C   ALA    38       1.722  -7.537  -4.893  1.00 53.12           C 
ATOM    557  O   ALA    38       0.788  -6.812  -4.559  1.00 43.01           O 
ATOM    558  CB  ALA    38       2.174  -8.425  -2.585  1.00 32.44           C 
ATOM    559  H   ALA    38       4.182  -9.176  -4.022  1.00 38.87           H 
ATOM    560  HA  ALA    38       1.314  -9.519  -4.187  1.00 30.24           H 
ATOM    561 1HB  ALA    38       1.215  -8.054  -2.249  1.00 38.87           H 
ATOM    562 2HB  ALA    38       2.927  -7.665  -2.435  1.00 38.87           H 
ATOM    563 3HB  ALA    38       2.435  -9.306  -2.017  1.00 38.87           H 
ATOM    564  N   GLN    39       2.454  -7.300  -5.983  1.00 51.54           N 
ATOM    565  CA  GLN    39       2.170  -6.172  -6.880  1.00 52.21           C 
ATOM    566  C   GLN    39       0.734  -6.247  -7.425  1.00 44.13           C 
ATOM    567  O   GLN    39       0.021  -5.245  -7.482  1.00 62.22           O 
ATOM    568  CB  GLN    39       3.172  -6.155  -8.048  1.00 11.11           C 
ATOM    569  CG  GLN    39       4.633  -6.038  -7.616  1.00 12.04           C 
ATOM    570  CD  GLN    39       4.929  -4.760  -6.846  1.00  1.14           C 
ATOM    571  OE1 GLN    39       5.269  -3.732  -7.422  1.00  1.24           O 
ATOM    572  NE2 GLN    39       4.808  -4.815  -5.535  1.00 63.04           N 
ATOM    573  H   GLN    39       3.202  -7.898  -6.190  1.00 38.87           H 
ATOM    574  HA  GLN    39       2.278  -5.259  -6.310  1.00  0.22           H 
ATOM    575 3HB  GLN    39       2.944  -5.319  -8.692  1.00 38.87           H 
ATOM    576 2HB  GLN    39       3.062  -7.071  -8.611  1.00 38.87           H 
ATOM    577 3HG  GLN    39       5.260  -6.061  -8.499  1.00 38.87           H 
ATOM    578 2HG  GLN    39       4.876  -6.882  -6.988  1.00 38.87           H 
ATOM    579 1HE2 GLN    39       4.541  -5.665  -5.130  1.00 38.87           H 
ATOM    580 2HE2 GLN    39       4.990  -4.002  -5.025  1.00 38.87           H 
ATOM    581  N   ASN    40       0.312  -7.455  -7.794  1.00 54.11           N 
ATOM    582  CA  ASN    40      -1.031  -7.687  -8.351  1.00 74.13           C 
ATOM    583  C   ASN    40      -2.066  -7.944  -7.243  1.00 65.32           C 
ATOM    584  O   ASN    40      -3.183  -8.388  -7.511  1.00 44.31           O 
ATOM    585  CB  ASN    40      -0.988  -8.888  -9.306  1.00 10.04           C 
ATOM    586  CG  ASN    40       0.065  -8.732 -10.388  1.00 23.32           C 
ATOM    587  OD1 ASN    40       0.360  -7.628 -10.832  1.00 44.11           O 
ATOM    588  ND2 ASN    40       0.653  -9.832 -10.809  1.00 53.43           N 
ATOM    589  H   ASN    40       0.917  -8.217  -7.689  1.00 38.87           H 
ATOM    590  HA  ASN    40      -1.324  -6.805  -8.904  1.00 74.51           H 
ATOM    591 3HB  ASN    40      -1.953  -8.997  -9.783  1.00 38.87           H 
ATOM    592 2HB  ASN    40      -0.768  -9.784  -8.741  1.00 38.87           H 
ATOM    593 1HD2 ASN    40       0.382 -10.685 -10.410  1.00 38.87           H 
ATOM    594 2HD2 ASN    40       1.346  -9.750 -11.497  1.00 38.87           H 
ATOM    595  N   GLU    41      -1.689  -7.659  -6.000  1.00 31.21           N 
ATOM    596  CA  GLU    41      -2.548  -7.924  -4.840  1.00 53.43           C 
ATOM    597  C   GLU    41      -3.092  -6.616  -4.235  1.00 12.33           C 
ATOM    598  O   GLU    41      -2.418  -5.583  -4.261  1.00 43.41           O 
ATOM    599  CB  GLU    41      -1.748  -8.714  -3.796  1.00 42.53           C 
ATOM    600  CG  GLU    41      -2.547  -9.119  -2.567  1.00 52.30           C 
ATOM    601  CD  GLU    41      -1.776 -10.052  -1.644  1.00 31.01           C 
ATOM    602  OE1 GLU    41      -1.786 -11.279  -1.891  1.00 53.45           O 
ATOM    603  OE2 GLU    41      -1.162  -9.572  -0.672  1.00 62.01           O 
ATOM    604  H   GLU    41      -0.811  -7.253  -5.852  1.00 38.87           H 
ATOM    605  HA  GLU    41      -3.383  -8.527  -5.172  1.00 51.41           H 
ATOM    606 3HB  GLU    41      -0.912  -8.110  -3.470  1.00 38.87           H 
ATOM    607 2HB  GLU    41      -1.366  -9.613  -4.260  1.00 38.87           H 
ATOM    608 3HG  GLU    41      -3.451  -9.617  -2.890  1.00 38.87           H 
ATOM    609 2HG  GLU    41      -2.810  -8.226  -2.017  1.00 38.87           H 
ATOM    610  N   SER    42      -4.319  -6.661  -3.706  1.00 41.03           N 
ATOM    611  CA  SER    42      -4.961  -5.470  -3.118  1.00  3.23           C 
ATOM    612  C   SER    42      -4.293  -5.049  -1.800  1.00 11.01           C 
ATOM    613  O   SER    42      -3.789  -5.888  -1.050  1.00 32.42           O 
ATOM    614  CB  SER    42      -6.458  -5.722  -2.873  1.00 14.55           C 
ATOM    615  OG  SER    42      -7.145  -6.007  -4.084  1.00 70.13           O 
ATOM    616  H   SER    42      -4.807  -7.510  -3.713  1.00 38.87           H 
ATOM    617  HA  SER    42      -4.859  -4.661  -3.828  1.00 32.13           H 
ATOM    618 3HB  SER    42      -6.900  -4.843  -2.425  1.00 38.87           H 
ATOM    619 2HB  SER    42      -6.576  -6.561  -2.204  1.00 38.87           H 
ATOM    620  HG  SER    42      -7.870  -5.378  -4.197  1.00 72.35           H 
ATOM    621  N   LEU    43      -4.334  -3.745  -1.511  1.00 34.52           N 
ATOM    622  CA  LEU    43      -3.680  -3.178  -0.320  1.00 51.01           C 
ATOM    623  C   LEU    43      -4.101  -3.890   0.980  1.00 74.01           C 
ATOM    624  O   LEU    43      -3.260  -4.209   1.824  1.00 54.43           O 
ATOM    625  CB  LEU    43      -3.980  -1.673  -0.207  1.00 41.31           C 
ATOM    626  CG  LEU    43      -3.465  -0.804  -1.370  1.00 64.44           C 
ATOM    627  CD1 LEU    43      -3.791   0.670  -1.132  1.00 51.40           C 
ATOM    628  CD2 LEU    43      -1.961  -0.997  -1.560  1.00 34.20           C 
ATOM    629  H   LEU    43      -4.808  -3.142  -2.124  1.00 38.87           H 
ATOM    630  HA  LEU    43      -2.614  -3.305  -0.446  1.00 12.32           H 
ATOM    631 3HB  LEU    43      -3.535  -1.307   0.707  1.00 38.87           H 
ATOM    632 2HB  LEU    43      -5.052  -1.546  -0.137  1.00 38.87           H 
ATOM    633  HG  LEU    43      -3.958  -1.109  -2.283  1.00 73.25           H 
ATOM    634 1HD1 LEU    43      -3.449   1.257  -1.973  1.00 38.87           H 
ATOM    635 2HD1 LEU    43      -3.297   1.009  -0.233  1.00 38.87           H 
ATOM    636 3HD1 LEU    43      -4.859   0.790  -1.020  1.00 38.87           H 
ATOM    637 1HD2 LEU    43      -1.442  -0.711  -0.656  1.00 38.87           H 
ATOM    638 2HD2 LEU    43      -1.617  -0.382  -2.380  1.00 38.87           H 
ATOM    639 3HD2 LEU    43      -1.755  -2.035  -1.781  1.00 38.87           H 
ATOM    640  N   GLU    44      -5.401  -4.143   1.137  1.00 63.43           N 
ATOM    641  CA  GLU    44      -5.916  -4.782   2.357  1.00 53.33           C 
ATOM    642  C   GLU    44      -5.391  -6.221   2.516  1.00 13.40           C 
ATOM    643  O   GLU    44      -5.106  -6.668   3.631  1.00 42.44           O 
ATOM    644  CB  GLU    44      -7.454  -4.769   2.367  1.00  1.52           C 
ATOM    645  CG  GLU    44      -8.063  -5.312   3.657  1.00 44.00           C 
ATOM    646  CD  GLU    44      -9.574  -5.141   3.724  1.00 71.34           C 
ATOM    647  OE1 GLU    44     -10.303  -5.980   3.152  1.00 73.53           O 
ATOM    648  OE2 GLU    44     -10.040  -4.172   4.363  1.00 70.00           O 
ATOM    649  H   GLU    44      -6.026  -3.892   0.422  1.00 38.87           H 
ATOM    650  HA  GLU    44      -5.565  -4.200   3.198  1.00 63.33           H 
ATOM    651 3HB  GLU    44      -7.817  -5.367   1.541  1.00 38.87           H 
ATOM    652 2HB  GLU    44      -7.792  -3.751   2.237  1.00 38.87           H 
ATOM    653 3HG  GLU    44      -7.618  -4.791   4.494  1.00 38.87           H 
ATOM    654 2HG  GLU    44      -7.832  -6.366   3.735  1.00 38.87           H 
ATOM    655  N   GLN    45      -5.236  -6.928   1.397  1.00 42.12           N 
ATOM    656  CA  GLN    45      -4.756  -8.316   1.419  1.00 51.24           C 
ATOM    657  C   GLN    45      -3.315  -8.398   1.954  1.00 43.02           C 
ATOM    658  O   GLN    45      -3.017  -9.191   2.854  1.00 75.43           O 
ATOM    659  CB  GLN    45      -4.839  -8.928   0.013  1.00 52.21           C 
ATOM    660  CG  GLN    45      -6.252  -8.961  -0.564  1.00 72.12           C 
ATOM    661  CD  GLN    45      -6.314  -9.557  -1.964  1.00 24.00           C 
ATOM    662  OE1 GLN    45      -5.518 -10.415  -2.330  1.00  4.23           O 
ATOM    663  NE2 GLN    45      -7.260  -9.104  -2.762  1.00 52.32           N 
ATOM    664  H   GLN    45      -5.437  -6.506   0.536  1.00 38.87           H 
ATOM    665  HA  GLN    45      -5.400  -8.876   2.083  1.00 63.43           H 
ATOM    666 3HB  GLN    45      -4.464  -9.941   0.049  1.00 38.87           H 
ATOM    667 2HB  GLN    45      -4.216  -8.349  -0.655  1.00 38.87           H 
ATOM    668 3HG  GLN    45      -6.632  -7.950  -0.601  1.00 38.87           H 
ATOM    669 2HG  GLN    45      -6.878  -9.554   0.087  1.00 38.87           H 
ATOM    670 1HE2 GLN    45      -7.869  -8.417  -2.416  1.00 38.87           H 
ATOM    671 2HE2 GLN    45      -7.316  -9.472  -3.668  1.00 38.87           H 
ATOM    672  N   GLY    46      -2.431  -7.567   1.405  1.00 51.42           N 
ATOM    673  CA  GLY    46      -1.055  -7.505   1.890  1.00 71.41           C 
ATOM    674  C   GLY    46      -0.952  -6.979   3.320  1.00 35.30           C 
ATOM    675  O   GLY    46      -0.099  -7.418   4.097  1.00 44.35           O 
ATOM    676  H   GLY    46      -2.709  -7.001   0.652  1.00 38.87           H 
ATOM    677 3HA  GLY    46      -0.490  -6.853   1.241  1.00 38.87           H 
ATOM    678 2HA  GLY    46      -0.623  -8.497   1.848  1.00 38.87           H 
ATOM    679  N   ALA    47      -1.834  -6.040   3.669  1.00 64.50           N 
ATOM    680  CA  ALA    47      -1.882  -5.471   5.021  1.00 62.21           C 
ATOM    681  C   ALA    47      -2.108  -6.558   6.085  1.00 72.41           C 
ATOM    682  O   ALA    47      -1.281  -6.746   6.978  1.00 22.11           O 
ATOM    683  CB  ALA    47      -2.973  -4.409   5.107  1.00 24.11           C 
ATOM    684  H   ALA    47      -2.470  -5.715   2.996  1.00 38.87           H 
ATOM    685  HA  ALA    47      -0.932  -4.992   5.209  1.00 75.31           H 
ATOM    686 1HB  ALA    47      -2.966  -3.960   6.089  1.00 38.87           H 
ATOM    687 2HB  ALA    47      -3.936  -4.865   4.926  1.00 38.87           H 
ATOM    688 3HB  ALA    47      -2.793  -3.648   4.362  1.00 38.87           H 
ATOM    689  N   ASN    48      -3.223  -7.284   5.978  1.00 11.12           N 
ATOM    690  CA  ASN    48      -3.529  -8.366   6.926  1.00 44.43           C 
ATOM    691  C   ASN    48      -2.442  -9.455   6.910  1.00 63.01           C 
ATOM    692  O   ASN    48      -2.128 -10.047   7.946  1.00 33.10           O 
ATOM    693  CB  ASN    48      -4.901  -8.985   6.634  1.00 40.54           C 
ATOM    694  CG  ASN    48      -6.043  -8.023   6.917  1.00  0.33           C 
ATOM    695  OD1 ASN    48      -6.509  -7.907   8.047  1.00  3.44           O 
ATOM    696  ND2 ASN    48      -6.513  -7.337   5.897  1.00  3.10           N 
ATOM    697  H   ASN    48      -3.852  -7.088   5.249  1.00 38.87           H 
ATOM    698  HA  ASN    48      -3.552  -7.928   7.915  1.00 72.44           H 
ATOM    699 3HB  ASN    48      -5.034  -9.862   7.252  1.00 38.87           H 
ATOM    700 2HB  ASN    48      -4.944  -9.273   5.593  1.00 38.87           H 
ATOM    701 1HD2 ASN    48      -6.108  -7.476   5.017  1.00 38.87           H 
ATOM    702 2HD2 ASN    48      -7.252  -6.717   6.063  1.00 38.87           H 
ATOM    703  N   ALA    49      -1.859  -9.707   5.738  1.00 74.10           N 
ATOM    704  CA  ALA    49      -0.749 -10.662   5.611  1.00 51.45           C 
ATOM    705  C   ALA    49       0.451 -10.257   6.484  1.00  2.25           C 
ATOM    706  O   ALA    49       1.184 -11.109   6.990  1.00  2.32           O 
ATOM    707  CB  ALA    49      -0.318 -10.776   4.156  1.00 75.30           C 
ATOM    708  H   ALA    49      -2.189  -9.249   4.934  1.00 38.87           H 
ATOM    709  HA  ALA    49      -1.106 -11.631   5.933  1.00  3.45           H 
ATOM    710 1HB  ALA    49       0.044  -9.818   3.811  1.00 38.87           H 
ATOM    711 2HB  ALA    49      -1.159 -11.080   3.553  1.00 38.87           H 
ATOM    712 3HB  ALA    49       0.472 -11.510   4.067  1.00 38.87           H 
ATOM    713  N   HIS    50       0.650  -8.949   6.647  1.00 62.00           N 
ATOM    714  CA  HIS    50       1.732  -8.419   7.490  1.00 30.31           C 
ATOM    715  C   HIS    50       1.202  -7.970   8.871  1.00 11.52           C 
ATOM    716  O   HIS    50       1.909  -7.317   9.639  1.00 44.31           O 
ATOM    717  CB  HIS    50       2.432  -7.249   6.776  1.00 53.20           C 
ATOM    718  CG  HIS    50       3.182  -7.652   5.534  1.00  5.11           C 
ATOM    719  ND1 HIS    50       4.471  -7.246   5.264  1.00 60.44           N 
ATOM    720  CD2 HIS    50       2.810  -8.413   4.474  1.00 44.03           C 
ATOM    721  CE1 HIS    50       4.856  -7.736   4.104  1.00 51.25           C 
ATOM    722  NE2 HIS    50       3.871  -8.450   3.600  1.00 61.50           N 
ATOM    723  H   HIS    50       0.054  -8.319   6.184  1.00 38.87           H 
ATOM    724  HA  HIS    50       2.452  -9.211   7.644  1.00 34.54           H 
ATOM    725 3HB  HIS    50       3.135  -6.791   7.455  1.00 38.87           H 
ATOM    726 2HB  HIS    50       1.690  -6.517   6.491  1.00 38.87           H 
ATOM    727  HD1 HIS    50       5.034  -6.692   5.849  1.00 14.34           H 
ATOM    728  HD2 HIS    50       1.856  -8.904   4.344  1.00 22.02           H 
ATOM    729  HE1 HIS    50       5.820  -7.580   3.644  1.00 42.23           H 
ATOM    730  HE2 HIS    50       3.990  -9.127   2.899  1.00 38.87           H 
ATOM    731  N   GLY    51      -0.047  -8.331   9.173  1.00 23.15           N 
ATOM    732  CA  GLY    51      -0.641  -8.026  10.476  1.00  4.03           C 
ATOM    733  C   GLY    51      -0.895  -6.539  10.717  1.00 61.15           C 
ATOM    734  O   GLY    51      -0.739  -6.047  11.838  1.00  1.41           O 
ATOM    735  H   GLY    51      -0.572  -8.820   8.506  1.00 38.87           H 
ATOM    736 3HA  GLY    51       0.016  -8.395  11.251  1.00 38.87           H 
ATOM    737 2HA  GLY    51      -1.584  -8.547  10.551  1.00 38.87           H 
ATOM    738  N   LEU    52      -1.296  -5.823   9.673  1.00 13.43           N 
ATOM    739  CA  LEU    52      -1.580  -4.387   9.774  1.00  3.32           C 
ATOM    740  C   LEU    52      -3.032  -4.077   9.386  1.00 73.02           C 
ATOM    741  O   LEU    52      -3.703  -4.885   8.738  1.00 24.11           O 
ATOM    742  CB  LEU    52      -0.627  -3.596   8.865  1.00 41.45           C 
ATOM    743  CG  LEU    52       0.869  -3.748   9.180  1.00 21.44           C 
ATOM    744  CD1 LEU    52       1.706  -2.969   8.174  1.00 72.31           C 
ATOM    745  CD2 LEU    52       1.171  -3.285  10.604  1.00 11.11           C 
ATOM    746  H   LEU    52      -1.403  -6.270   8.808  1.00 38.87           H 
ATOM    747  HA  LEU    52      -1.421  -4.081  10.799  1.00 62.12           H 
ATOM    748 3HB  LEU    52      -0.881  -2.548   8.941  1.00 38.87           H 
ATOM    749 2HB  LEU    52      -0.794  -3.913   7.843  1.00 38.87           H 
ATOM    750  HG  LEU    52       1.145  -4.792   9.104  1.00 52.43           H 
ATOM    751 1HD1 LEU    52       2.753  -3.074   8.417  1.00 38.87           H 
ATOM    752 2HD1 LEU    52       1.432  -1.924   8.209  1.00 38.87           H 
ATOM    753 3HD1 LEU    52       1.528  -3.353   7.181  1.00 38.87           H 
ATOM    754 1HD2 LEU    52       0.603  -3.879  11.306  1.00 38.87           H 
ATOM    755 2HD2 LEU    52       0.896  -2.245  10.709  1.00 38.87           H 
ATOM    756 3HD2 LEU    52       2.226  -3.400  10.805  1.00 38.87           H 
ATOM    757  N   ASN    53      -3.520  -2.908   9.789  1.00 21.20           N 
ATOM    758  CA  ASN    53      -4.858  -2.458   9.399  1.00  1.31           C 
ATOM    759  C   ASN    53      -4.763  -1.489   8.213  1.00 60.51           C 
ATOM    760  O   ASN    53      -4.085  -0.462   8.286  1.00  3.35           O 
ATOM    761  CB  ASN    53      -5.568  -1.786  10.582  1.00 54.22           C 
ATOM    762  CG  ASN    53      -7.045  -1.541  10.321  1.00 44.44           C 
ATOM    763  OD1 ASN    53      -7.477  -1.407   9.182  1.00 23.30           O 
ATOM    764  ND2 ASN    53      -7.831  -1.471  11.375  1.00 13.44           N 
ATOM    765  H   ASN    53      -2.970  -2.333  10.363  1.00 38.87           H 
ATOM    766  HA  ASN    53      -5.427  -3.328   9.094  1.00 43.34           H 
ATOM    767 3HB  ASN    53      -5.097  -0.835  10.786  1.00 38.87           H 
ATOM    768 2HB  ASN    53      -5.478  -2.419  11.453  1.00 38.87           H 
ATOM    769 1HD2 ASN    53      -7.428  -1.581  12.261  1.00 38.87           H 
ATOM    770 2HD2 ASN    53      -8.786  -1.310  11.229  1.00 38.87           H 
ATOM    771  N   VAL    54      -5.458  -1.815   7.129  1.00 55.22           N 
ATOM    772  CA  VAL    54      -5.397  -1.020   5.902  1.00 12.33           C 
ATOM    773  C   VAL    54      -5.886   0.424   6.127  1.00 10.12           C 
ATOM    774  O   VAL    54      -5.478   1.339   5.414  1.00 44.44           O 
ATOM    775  CB  VAL    54      -6.224  -1.680   4.770  1.00 72.23           C 
ATOM    776  CG1 VAL    54      -7.711  -1.685   5.113  1.00 54.15           C 
ATOM    777  CG2 VAL    54      -5.961  -0.992   3.429  1.00  1.54           C 
ATOM    778  H   VAL    54      -6.029  -2.612   7.152  1.00 38.87           H 
ATOM    779  HA  VAL    54      -4.364  -0.989   5.586  1.00  4.41           H 
ATOM    780  HB  VAL    54      -5.905  -2.711   4.682  1.00 52.32           H 
ATOM    781 1HG1 VAL    54      -7.868  -2.238   6.028  1.00 38.87           H 
ATOM    782 2HG1 VAL    54      -8.264  -2.152   4.313  1.00 38.87           H 
ATOM    783 3HG1 VAL    54      -8.057  -0.668   5.244  1.00 38.87           H 
ATOM    784 1HG2 VAL    54      -6.270   0.043   3.486  1.00 38.87           H 
ATOM    785 2HG2 VAL    54      -6.522  -1.491   2.653  1.00 38.87           H 
ATOM    786 3HG2 VAL    54      -4.907  -1.041   3.199  1.00 38.87           H 
ATOM    787  N   GLU    55      -6.747   0.622   7.129  1.00  2.41           N 
ATOM    788  CA  GLU    55      -7.280   1.956   7.445  1.00 32.13           C 
ATOM    789  C   GLU    55      -6.154   2.971   7.712  1.00 43.44           C 
ATOM    790  O   GLU    55      -6.118   4.051   7.113  1.00 64.42           O 
ATOM    791  CB  GLU    55      -8.210   1.886   8.667  1.00 23.34           C 
ATOM    792  CG  GLU    55      -9.406   0.955   8.494  1.00 73.43           C 
ATOM    793  CD  GLU    55     -10.260   1.294   7.284  1.00 64.30           C 
ATOM    794  OE1 GLU    55     -10.823   2.411   7.240  1.00 63.25           O 
ATOM    795  OE2 GLU    55     -10.388   0.439   6.382  1.00 33.35           O 
ATOM    796  H   GLU    55      -7.036  -0.145   7.667  1.00 38.87           H 
ATOM    797  HA  GLU    55      -7.852   2.289   6.592  1.00 24.50           H 
ATOM    798 3HB  GLU    55      -8.583   2.879   8.879  1.00 38.87           H 
ATOM    799 2HB  GLU    55      -7.640   1.541   9.518  1.00 38.87           H 
ATOM    800 3HG  GLU    55     -10.022   1.021   9.380  1.00 38.87           H 
ATOM    801 2HG  GLU    55      -9.043  -0.058   8.390  1.00 38.87           H 
ATOM    802  N   ASP    56      -5.234   2.611   8.608  1.00 25.43           N 
ATOM    803  CA  ASP    56      -4.102   3.480   8.956  1.00 72.02           C 
ATOM    804  C   ASP    56      -3.191   3.719   7.738  1.00 71.12           C 
ATOM    805  O   ASP    56      -2.635   4.806   7.561  1.00 55.40           O 
ATOM    806  CB  ASP    56      -3.302   2.860  10.109  1.00 72.35           C 
ATOM    807  CG  ASP    56      -2.157   3.750  10.562  1.00 62.42           C 
ATOM    808  OD1 ASP    56      -2.426   4.820  11.139  1.00 53.10           O 
ATOM    809  OD2 ASP    56      -0.983   3.388  10.344  1.00 42.03           O 
ATOM    810  H   ASP    56      -5.316   1.741   9.049  1.00 38.87           H 
ATOM    811  HA  ASP    56      -4.504   4.430   9.280  1.00 33.13           H 
ATOM    812 3HB  ASP    56      -2.897   1.909   9.792  1.00 38.87           H 
ATOM    813 2HB  ASP    56      -3.962   2.699  10.952  1.00 38.87           H 
ATOM    814  N   ILE    57      -3.056   2.695   6.898  1.00 72.32           N 
ATOM    815  CA  ILE    57      -2.252   2.794   5.676  1.00 42.34           C 
ATOM    816  C   ILE    57      -2.869   3.807   4.693  1.00 13.41           C 
ATOM    817  O   ILE    57      -2.199   4.735   4.233  1.00 50.14           O 
ATOM    818  CB  ILE    57      -2.119   1.411   4.984  1.00 52.34           C 
ATOM    819  CG1 ILE    57      -1.555   0.377   5.975  1.00 62.34           C 
ATOM    820  CG2 ILE    57      -1.232   1.514   3.742  1.00 75.10           C 
ATOM    821  CD1 ILE    57      -1.460  -1.026   5.412  1.00 62.13           C 
ATOM    822  H   ILE    57      -3.512   1.851   7.104  1.00 38.87           H 
ATOM    823  HA  ILE    57      -1.264   3.133   5.955  1.00 63.13           H 
ATOM    824  HB  ILE    57      -3.104   1.094   4.666  1.00 55.12           H 
ATOM    825 3HG1 ILE    57      -2.194   0.339   6.847  1.00 38.87           H 
ATOM    826 2HG1 ILE    57      -0.563   0.677   6.276  1.00 38.87           H 
ATOM    827 1HG2 ILE    57      -1.150   0.545   3.270  1.00 38.87           H 
ATOM    828 2HG2 ILE    57      -0.249   1.859   4.028  1.00 38.87           H 
ATOM    829 3HG2 ILE    57      -1.668   2.216   3.046  1.00 38.87           H 
ATOM    830 1HD1 ILE    57      -2.443  -1.365   5.120  1.00 38.87           H 
ATOM    831 2HD1 ILE    57      -1.060  -1.689   6.165  1.00 38.87           H 
ATOM    832 3HD1 ILE    57      -0.809  -1.027   4.549  1.00 38.87           H 
ATOM    833  N   LEU    58      -4.158   3.631   4.396  1.00 30.44           N 
ATOM    834  CA  LEU    58      -4.887   4.540   3.500  1.00 61.54           C 
ATOM    835  C   LEU    58      -4.835   5.985   4.017  1.00 50.43           C 
ATOM    836  O   LEU    58      -4.753   6.934   3.236  1.00 73.43           O 
ATOM    837  CB  LEU    58      -6.350   4.097   3.356  1.00 50.24           C 
ATOM    838  CG  LEU    58      -6.562   2.680   2.795  1.00 43.33           C 
ATOM    839  CD1 LEU    58      -8.053   2.367   2.669  1.00 52.13           C 
ATOM    840  CD2 LEU    58      -5.852   2.516   1.452  1.00 33.40           C 
ATOM    841  H   LEU    58      -4.634   2.872   4.792  1.00 38.87           H 
ATOM    842  HA  LEU    58      -4.409   4.500   2.531  1.00  0.51           H 
ATOM    843 3HB  LEU    58      -6.852   4.797   2.703  1.00 38.87           H 
ATOM    844 2HB  LEU    58      -6.815   4.147   4.333  1.00 38.87           H 
ATOM    845  HG  LEU    58      -6.136   1.963   3.485  1.00 62.02           H 
ATOM    846 1HD1 LEU    58      -8.180   1.373   2.264  1.00 38.87           H 
ATOM    847 2HD1 LEU    58      -8.521   3.084   2.010  1.00 38.87           H 
ATOM    848 3HD1 LEU    58      -8.517   2.418   3.643  1.00 38.87           H 
ATOM    849 1HD2 LEU    58      -4.791   2.677   1.581  1.00 38.87           H 
ATOM    850 2HD2 LEU    58      -6.240   3.237   0.745  1.00 38.87           H 
ATOM    851 3HD2 LEU    58      -6.018   1.518   1.074  1.00 38.87           H 
ATOM    852  N   ARG    59      -4.891   6.136   5.338  1.00 11.23           N 
ATOM    853  CA  ARG    59      -4.777   7.449   5.982  1.00 25.24           C 
ATOM    854  C   ARG    59      -3.526   8.207   5.502  1.00 55.33           C 
ATOM    855  O   ARG    59      -3.619   9.327   4.989  1.00 65.22           O 
ATOM    856  CB  ARG    59      -4.711   7.274   7.509  1.00 64.02           C 
ATOM    857  CG  ARG    59      -4.328   8.546   8.269  1.00  0.44           C 
ATOM    858  CD  ARG    59      -3.902   8.249   9.706  1.00 74.21           C 
ATOM    859  NE  ARG    59      -2.835   7.248   9.764  1.00 51.41           N 
ATOM    860  CZ  ARG    59      -1.595   7.454   9.400  1.00 60.32           C 
ATOM    861  NH1 ARG    59      -1.207   8.617   8.977  1.00 71.44           N 
ATOM    862  NH2 ARG    59      -0.741   6.487   9.470  1.00 34.04           N 
ATOM    863  H   ARG    59      -5.019   5.340   5.900  1.00 38.87           H 
ATOM    864  HA  ARG    59      -5.657   8.023   5.730  1.00  4.43           H 
ATOM    865 3HB  ARG    59      -3.981   6.510   7.738  1.00 38.87           H 
ATOM    866 2HB  ARG    59      -5.680   6.947   7.864  1.00 38.87           H 
ATOM    867 3HG  ARG    59      -5.178   9.215   8.286  1.00 38.87           H 
ATOM    868 2HG  ARG    59      -3.507   9.026   7.757  1.00 38.87           H 
ATOM    869 3HD  ARG    59      -4.757   7.880  10.254  1.00 38.87           H 
ATOM    870 2HD  ARG    59      -3.551   9.163  10.163  1.00 38.87           H 
ATOM    871  HE  ARG    59      -3.072   6.359  10.101  1.00 63.33           H 
ATOM    872 1HH1 ARG    59      -1.852   9.375   8.934  1.00 38.87           H 
ATOM    873 2HH1 ARG    59      -0.259   8.751   8.688  1.00 38.87           H 
ATOM    874 1HH2 ARG    59      -1.033   5.593   9.808  1.00 38.87           H 
ATOM    875 2HH2 ARG    59       0.203   6.632   9.187  1.00 38.87           H 
ATOM    876  N   ASP    60      -2.359   7.585   5.668  1.00 53.22           N 
ATOM    877  CA  ASP    60      -1.088   8.234   5.346  1.00 63.13           C 
ATOM    878  C   ASP    60      -0.873   8.340   3.822  1.00 62.14           C 
ATOM    879  O   ASP    60      -0.331   9.332   3.328  1.00 44.05           O 
ATOM    880  CB  ASP    60       0.069   7.476   6.015  1.00 73.14           C 
ATOM    881  CG  ASP    60       1.209   8.400   6.410  1.00 25.13           C 
ATOM    882  OD1 ASP    60       2.176   8.534   5.637  1.00 61.03           O 
ATOM    883  OD2 ASP    60       1.129   9.006   7.505  1.00  0.21           O 
ATOM    884  H   ASP    60      -2.351   6.665   6.016  1.00 38.87           H 
ATOM    885  HA  ASP    60      -1.126   9.237   5.754  1.00 42.44           H 
ATOM    886 3HB  ASP    60       0.449   6.729   5.332  1.00 38.87           H 
ATOM    887 2HB  ASP    60      -0.298   6.987   6.906  1.00 38.87           H 
ATOM    888  N   LEU    61      -1.312   7.317   3.082  1.00 24.25           N 
ATOM    889  CA  LEU    61      -1.205   7.317   1.614  1.00 43.24           C 
ATOM    890  C   LEU    61      -2.027   8.455   0.985  1.00 51.04           C 
ATOM    891  O   LEU    61      -1.540   9.188   0.124  1.00 71.55           O 
ATOM    892  CB  LEU    61      -1.663   5.971   1.031  1.00  4.30           C 
ATOM    893  CG  LEU    61      -0.806   4.752   1.412  1.00 73.10           C 
ATOM    894  CD1 LEU    61      -1.315   3.497   0.704  1.00 71.04           C 
ATOM    895  CD2 LEU    61       0.664   5.004   1.086  1.00  0.30           C 
ATOM    896  H   LEU    61      -1.707   6.538   3.534  1.00 38.87           H 
ATOM    897  HA  LEU    61      -0.165   7.468   1.363  1.00 44.53           H 
ATOM    898 3HB  LEU    61      -1.665   6.054  -0.047  1.00 38.87           H 
ATOM    899 2HB  LEU    61      -2.678   5.788   1.358  1.00 38.87           H 
ATOM    900  HG  LEU    61      -0.888   4.584   2.477  1.00 74.01           H 
ATOM    901 1HD1 LEU    61      -2.333   3.298   1.008  1.00 38.87           H 
ATOM    902 2HD1 LEU    61      -0.691   2.654   0.970  1.00 38.87           H 
ATOM    903 3HD1 LEU    61      -1.281   3.646  -0.365  1.00 38.87           H 
ATOM    904 1HD2 LEU    61       0.764   5.260   0.041  1.00 38.87           H 
ATOM    905 2HD2 LEU    61       1.238   4.114   1.295  1.00 38.87           H 
ATOM    906 3HD2 LEU    61       1.033   5.819   1.694  1.00 38.87           H 
ATOM    907  N   ASN    62      -3.279   8.592   1.413  1.00 14.32           N 
ATOM    908  CA  ASN    62      -4.150   9.674   0.930  1.00 43.21           C 
ATOM    909  C   ASN    62      -3.579  11.055   1.291  1.00 40.41           C 
ATOM    910  O   ASN    62      -3.788  12.036   0.574  1.00 53.15           O 
ATOM    911  CB  ASN    62      -5.567   9.510   1.496  1.00 22.11           C 
ATOM    912  CG  ASN    62      -6.316   8.353   0.854  1.00 42.31           C 
ATOM    913  OD1 ASN    62      -6.193   8.102  -0.339  1.00 21.13           O 
ATOM    914  ND2 ASN    62      -7.086   7.629   1.641  1.00 42.20           N 
ATOM    915  H   ASN    62      -3.629   7.949   2.068  1.00 38.87           H 
ATOM    916  HA  ASN    62      -4.196   9.596  -0.147  1.00 21.13           H 
ATOM    917 3HB  ASN    62      -6.127  10.417   1.319  1.00 38.87           H 
ATOM    918 2HB  ASN    62      -5.507   9.332   2.560  1.00 38.87           H 
ATOM    919 1HD2 ASN    62      -7.139   7.870   2.586  1.00 38.87           H 
ATOM    920 2HD2 ASN    62      -7.568   6.874   1.242  1.00 38.87           H 
ATOM    921  N   ALA    63      -2.843  11.119   2.398  1.00 23.15           N 
ATOM    922  CA  ALA    63      -2.149  12.349   2.795  1.00 10.24           C 
ATOM    923  C   ALA    63      -1.080  12.743   1.759  1.00 72.40           C 
ATOM    924  O   ALA    63      -0.778  13.926   1.582  1.00 54.04           O 
ATOM    925  CB  ALA    63      -1.530  12.177   4.177  1.00 62.15           C 
ATOM    926  H   ALA    63      -2.767  10.323   2.966  1.00 38.87           H 
ATOM    927  HA  ALA    63      -2.886  13.139   2.853  1.00 22.24           H 
ATOM    928 1HB  ALA    63      -1.071  13.106   4.485  1.00 38.87           H 
ATOM    929 2HB  ALA    63      -0.780  11.400   4.143  1.00 38.87           H 
ATOM    930 3HB  ALA    63      -2.298  11.904   4.887  1.00 38.87           H 
ATOM    931  N   LEU    64      -0.514  11.739   1.077  1.00  2.21           N 
ATOM    932  CA  LEU    64       0.438  11.977  -0.019  1.00 60.51           C 
ATOM    933  C   LEU    64      -0.259  12.629  -1.224  1.00 22.12           C 
ATOM    934  O   LEU    64       0.378  13.298  -2.035  1.00 61.31           O 
ATOM    935  CB  LEU    64       1.087  10.657  -0.470  1.00 34.34           C 
ATOM    936  CG  LEU    64       1.870   9.892   0.607  1.00  0.14           C 
ATOM    937  CD1 LEU    64       2.339   8.543   0.064  1.00 70.33           C 
ATOM    938  CD2 LEU    64       3.054  10.720   1.105  1.00 23.33           C 
ATOM    939  H   LEU    64      -0.742  10.813   1.318  1.00 38.87           H 
ATOM    940  HA  LEU    64       1.209  12.644   0.344  1.00  5.14           H 
ATOM    941 3HB  LEU    64       1.765  10.874  -1.285  1.00 38.87           H 
ATOM    942 2HB  LEU    64       0.306  10.010  -0.845  1.00 38.87           H 
ATOM    943  HG  LEU    64       1.219   9.702   1.448  1.00 74.32           H 
ATOM    944 1HD1 LEU    64       2.894   8.019   0.829  1.00 38.87           H 
ATOM    945 2HD1 LEU    64       2.973   8.697  -0.798  1.00 38.87           H 
ATOM    946 3HD1 LEU    64       1.480   7.952  -0.224  1.00 38.87           H 
ATOM    947 1HD2 LEU    64       3.595  10.163   1.857  1.00 38.87           H 
ATOM    948 2HD2 LEU    64       2.694  11.643   1.535  1.00 38.87           H 
ATOM    949 3HD2 LEU    64       3.715  10.943   0.278  1.00 38.87           H 
ATOM    950  N   ALA    65      -1.567  12.402  -1.347  1.00  0.42           N 
ATOM    951  CA  ALA    65      -2.361  12.995  -2.428  1.00 64.02           C 
ATOM    952  C   ALA    65      -2.726  14.456  -2.120  1.00  4.00           C 
ATOM    953  O   ALA    65      -2.710  15.315  -3.006  1.00 25.43           O 
ATOM    954  CB  ALA    65      -3.621  12.168  -2.671  1.00 45.01           C 
ATOM    955  H   ALA    65      -2.010  11.816  -0.697  1.00 38.87           H 
ATOM    956  HA  ALA    65      -1.765  12.969  -3.331  1.00  3.23           H 
ATOM    957 1HB  ALA    65      -3.345  11.142  -2.874  1.00 38.87           H 
ATOM    958 2HB  ALA    65      -4.161  12.568  -3.518  1.00 38.87           H 
ATOM    959 3HB  ALA    65      -4.251  12.202  -1.794  1.00 38.87           H 
END
