
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  172 ( 1329),  selected  172 , name 1xx7_A
# Molecule2: number of CA atoms   97 (  787),  selected   97 , name T0470_2_100.pdb
# PARAMETERS: 1xx7_A.T0470_2_100.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      T       2           -
LGA    I     2_A      K       3           -
LGA    D     3_A      Q       4           -
LGA    L     4_A      E       5           -
LGA    -       -      K       6           -
LGA    -       -      I       7           -
LGA    -       -      E       8           -
LGA    I     5_A      K       9          5.713
LGA    L     6_A      T      10           -
LGA    -       -      I      11           -
LGA    -       -      T      12           -
LGA    L     7_A      F      13          4.243
LGA    A     8_A      V      14          2.890
LGA    G     9_A      K      15          3.166
LGA    K    10_A      H      16          2.561
LGA    -       -      I      17           -
LGA    L    11_A      L      18          2.336
LGA    K    12_A      E      19           #
LGA    R    13_A      K      20           #
LGA    -       -      D      21           -
LGA    -       -      A      22           -
LGA    I    14_A      S      23          2.524
LGA    P    15_A      G      24           #
LGA    R    16_A      -       -           -
LGA    M    17_A      -       -           -
LGA    G    18_A      -       -           -
LGA    W    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    I    21_A      -       -           -
LGA    K    22_A      -       -           -
LGA    G    23_A      -       -           -
LGA    V    24_A      -       -           -
LGA    P    25_A      -       -           -
LGA    N    26_A      -       -           -
LGA    P    27_A      -       -           -
LGA    E    28_A      H      25          3.867
LGA    S    29_A      D      26          1.474
LGA    V    30_A      -       -           -
LGA    A    31_A      W      27          1.821
LGA    D    32_A      Y      28          1.479
LGA    H    33_A      H      29          1.470
LGA    S    34_A      I      30          1.260
LGA    Y    35_A      R      31          0.699
LGA    R    36_A      R      32          0.920
LGA    V    37_A      V      33          1.160
LGA    A    38_A      H      34          0.858
LGA    F    39_A      K      35          0.967
LGA    I    40_A      M      36          1.011
LGA    T    41_A      A      37          0.420
LGA    L    42_A      I      38          1.164
LGA    L    43_A      S      39          1.817
LGA    L    44_A      L      40          1.568
LGA    A    45_A      S      41          1.440
LGA    E    46_A      E      42          2.837
LGA    E    47_A      Q      43          3.468
LGA    L    48_A      E      44          2.308
LGA    K    49_A      -       -           -
LGA    K    50_A      -       -           -
LGA    K    51_A      -       -           -
LGA    G    52_A      -       -           -
LGA    V    53_A      -       -           -
LGA    E    54_A      G      45          2.999
LGA    I    55_A      G      46          1.555
LGA    D    56_A      N      47          1.704
LGA    V    57_A      R      48          2.046
LGA    E    58_A      F      49          2.731
LGA    K    59_A      I      50          2.030
LGA    A    60_A      I      51          1.096
LGA    L    61_A      E      52          1.603
LGA    K    62_A      M      53          2.155
LGA    I    63_A      A      54          1.615
LGA    A    64_A      A      55          1.691
LGA    I    65_A      L      56          2.201
LGA    I    66_A      L      57          2.862
LGA    H    67_A      H      58          2.703
LGA    D    68_A      D      59          2.441
LGA    L    69_A      V      60          3.466
LGA    G    70_A      -       -           -
LGA    E    71_A      A      61          5.030
LGA    A    72_A      D      62           -
LGA    -       -      L      65           -
LGA    I    73_A      N      66           #
LGA    I    74_A      E      67          3.160
LGA    T    75_A      -       -           -
LGA    D    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    P    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    S    80_A      -       -           -
LGA    A    81_A      -       -           -
LGA    Q    82_A      -       -           -
LGA    K    83_A      -       -           -
LGA    Y    84_A      -       -           -
LGA    L    85_A      S      68          4.669
LGA    N    86_A      E      69          1.815
LGA    K    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    E    89_A      E      70          0.940
LGA    A    90_A      A      71          1.269
LGA    E    91_A      G      72          1.173
LGA    A    92_A      M      73          0.326
LGA    K    93_A      K      74          1.769
LGA    A    94_A      K      75          1.508
LGA    L    95_A      V      76          1.804
LGA    K    96_A      S      77          2.449
LGA    D    97_A      D      78          3.324
LGA    V    98_A      -       -           -
LGA    L    99_A      W      79          0.870
LGA    P   100_A      L      80          4.140
LGA    E   101_A      E      81          2.733
LGA    -       -      E      82           -
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    Y   102_A      V      85          5.669
LGA    -       -      E      86           -
LGA    -       -      E      87           -
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    T   103_A      S      90          4.682
LGA    E   104_A      K      91          2.031
LGA    -       -      H      92           -
LGA    L   105_A      V      93          0.976
LGA    F   106_A      L      94          1.532
LGA    E   107_A      H      95          1.470
LGA    E   108_A      I      96          2.716
LGA    Y   109_A      I      97          2.765
LGA    S   110_A      A      98          1.563
LGA    K   111_A      N      99          3.756
LGA    A   112_A      -       -           -
LGA    L   113_A      -       -           -
LGA    T   114_A      -       -           -
LGA    L   115_A      -       -           -
LGA    E   116_A      -       -           -
LGA    G   117_A      -       -           -
LGA    Q   118_A      -       -           -
LGA    L   119_A      -       -           -
LGA    V   120_A      -       -           -
LGA    K   121_A      M     100           #
LGA    I   122_A      -       -           -
LGA    A   123_A      -       -           -
LGA    D   124_A      -       -           -
LGA    K   125_A      -       -           -
LGA    L   126_A      -       -           -
LGA    D   127_A      -       -           -
LGA    M   128_A      -       -           -
LGA    I   129_A      -       -           -
LGA    I   130_A      -       -           -
LGA    Q   131_A      -       -           -
LGA    A   132_A      -       -           -
LGA    Y   133_A      -       -           -
LGA    E   134_A      -       -           -
LGA    Y   135_A      -       -           -
LGA    E   136_A      -       -           -
LGA    L   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    K   141_A      -       -           -
LGA    N   142_A      -       -           -
LGA    L   143_A      -       -           -
LGA    S   144_A      -       -           -
LGA    E   145_A      -       -           -
LGA    F   146_A      -       -           -
LGA    W   147_A      -       -           -
LGA    N   148_A      -       -           -
LGA    A   149_A      -       -           -
LGA    L   150_A      -       -           -
LGA    E   151_A      -       -           -
LGA    D   152_A      -       -           -
LGA    L   153_A      -       -           -
LGA    E   154_A      -       -           -
LGA    K   155_A      -       -           -
LGA    L   156_A      -       -           -
LGA    E   157_A      -       -           -
LGA    I   158_A      -       -           -
LGA    S   159_A      -       -           -
LGA    R   160_A      -       -           -
LGA    Y   161_A      -       -           -
LGA    L   162_A      -       -           -
LGA    R   163_A      -       -           -
LGA    E   164_A      -       -           -
LGA    I   165_A      -       -           -
LGA    I   166_A      -       -           -
LGA    E   167_A      -       -           -
LGA    E   168_A      -       -           -
LGA    V   169_A      -       -           -
LGA    R   170_A      -       -           -
LGA    R   171_A      -       -           -
LGA    L   172_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  172   97    5.0     69    2.54    20.29     51.720     2.609

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.634782 * X  +  -0.529752 * Y  +  -0.562507 * Z  +  35.251545
  Y_new =  -0.385961 * X  +  -0.848047 * Y  +   0.363113 * Z  + 129.739349
  Z_new =  -0.669392 * X  +  -0.013392 * Y  +  -0.742789 * Z  + 160.134384 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.123565    0.018028  [ DEG:  -178.9671      1.0329 ]
  Theta =   0.733390    2.408202  [ DEG:    42.0202    137.9798 ]
  Phi   =  -0.546296    2.595296  [ DEG:   -31.3005    148.6995 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xx7_A                                        
REMARK     2: T0470_2_100.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xx7_A.T0470_2_100.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  172   97   5.0   69   2.54   20.29  51.720
REMARK  ---------------------------------------------------------- 
MOLECULE 1xx7_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   04-NOV-04   1XX7              
TITLE     CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS FURIOSUS PFU-          
TITLE    2 403030-001                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: OXETANOCIN-LIKE PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS FURIOSUS;                            
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    PSI, SECSG, PROTEIN STRUCTURE INITIATIVE, SOUTHEAST                   
KEYWDS   2 COLLABORATORY FOR STRUCTURAL GENOMICS, PYROCOCCUS FURIOSUS,          
KEYWDS   3 CONSERVED HYPOTHETICAL PROTEIN, HYPERTHERMOPHILE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,D.LEE,L.-          
AUTHOR   2 L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,J.C.ENEH,                  
AUTHOR   3 R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,F.L.POOLE II,C.SHAH,         
AUTHOR   4 F.J.SUGAR,M.W.W.ADAMS,W.B.ARENDALL III,J.S.RICHARDSON,               
AUTHOR   5 D.C.RICHARDSON,J.P.ROSE,B.-C.WANG,SOUTHEAST COLLABORATORY            
AUTHOR   6 FOR STRUCTURAL GENOMICS (SECSG)                                      
REVDAT   2   01-FEB-05 1XX7    1       AUTHOR                                   
REVDAT   1   28-DEC-04 1XX7    0                                                
JRNL        AUTH   L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,          
JRNL        AUTH 2 D.LEE,L.-L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,          
JRNL        AUTH 3 J.C.ENEH,R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,            
JRNL        AUTH 4 F.L.POOLE II,C.SHAH,F.J.SUGAR,M.W.W.ADAMS,                   
JRNL        AUTH 5 W.B.ARENDALL III,J.S.RICHARDSON,D.C.RICHARDSON,              
JRNL        AUTH 6 J.P.ROSE,B.-C.WANG,                                          
JRNL        AUTH 7 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS              
JRNL        TITL   CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS               
JRNL        TITL 2 FURIOSUS PFU-403030-001                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.26 ANGSTROMS.                                          
DBREF  1XX7 A    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 B    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 C    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 D    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 E    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 F    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
SEQRES   1 A  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 A  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 A  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 A  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 A  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 A  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 A  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 A  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 A  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 A  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 A  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 A  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 A  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 A  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 A  184  ASP HIS                                                      
SEQRES   1 B  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 B  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 B  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 B  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 B  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 B  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 B  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 B  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 B  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 B  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 B  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 B  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 B  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 B  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 B  184  ASP HIS                                                      
SEQRES   1 C  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 C  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 C  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 C  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 C  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 C  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 C  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 C  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 C  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 C  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 C  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 C  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 C  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 C  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 C  184  ASP HIS                                                      
SEQRES   1 D  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 D  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 D  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 D  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 D  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 D  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 D  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 D  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 D  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 D  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 D  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 D  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 D  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 D  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 D  184  ASP HIS                                                      
SEQRES   1 E  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 E  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 E  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 E  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 E  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 E  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 E  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 E  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 E  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 E  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 E  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 E  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 E  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 E  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 E  184  ASP HIS                                                      
SEQRES   1 F  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 F  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 F  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 F  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 F  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 F  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 F  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 F  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 F  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 F  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 F  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 F  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 F  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 F  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 F  184  ASP HIS                                                      
HET     NI  A 201       1                                                       
HET     NI  B 201       1                                                       
HET     NI  C 201       1                                                       
HET     NI  D 201       1                                                       
HET     NI  E 201       1                                                       
HET     NI  F 201       1                                                       
HET    UNX   2001       1                                                       
HET    UNX   2002       1                                                       
HET    UNX   2003       1                                                       
HET    UNX   2004       1                                                       
HET    UNX   2005       1                                                       
HET    UNX   2006       1                                                       
HET    UNX   2007       1                                                       
HET    UNX   2008       1                                                       
HET    UNX   2009       1                                                       
HET    UNX   2010       1                                                       
HET    UNX   2011       1                                                       
HET    UNX   2012       1                                                       
HET    UNX   2013       1                                                       
HET    UNX   2014       1                                                       
HET    UNX   2015       1                                                       
HET    UNX   2016       1                                                       
HET    UNX   2017       1                                                       
HET    UNX   2018       1                                                       
HET    UNX   2019       1                                                       
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     UNX UNKNOWN ATOM OR ION                                              
FORMUL   7   NI    6(NI 2+)                                                     
FORMUL  13  UNX    19(X1)                                                       
FORMUL  32  HOH   *69(H2 O)                                                     
CRYST1   98.073  111.335  125.984  90.00  90.00  90.00 P 21 21 21   24          
ATOM      1  N   SER A   1      61.042  37.168  90.937  1.00 45.35           N  
ATOM      2  CA  SER A   1      61.752  38.498  90.936  1.00 42.85           C  
ATOM      3  C   SER A   1      60.880  39.538  91.654  1.00 39.71           C  
ATOM      4  O   SER A   1      59.719  39.803  91.237  1.00 33.49           O  
ATOM      5  CB  SER A   1      62.084  38.944  89.502  1.00 46.38           C  
ATOM      6  OG  SER A   1      63.121  39.917  89.448  1.00 49.22           O  
ATOM      7  N   ILE A   2      61.443  40.085  92.742  1.00 35.65           N  
ATOM      8  CA  ILE A   2      60.835  41.149  93.537  1.00 36.39           C  
ATOM      9  C   ILE A   2      60.588  42.429  92.714  1.00 32.94           C  
ATOM     10  O   ILE A   2      59.638  43.157  92.998  1.00 30.82           O  
ATOM     11  CB  ILE A   2      61.662  41.416  94.874  1.00 38.15           C  
ATOM     12  CG1 ILE A   2      61.320  40.383  95.936  1.00 40.60           C  
ATOM     13  CG2 ILE A   2      61.348  42.741  95.521  1.00 39.99           C  
ATOM     14  N   ASP A   3      61.404  42.655  91.679  1.00 30.26           N  
ATOM     15  CA  ASP A   3      61.285  43.825  90.796  1.00 31.44           C  
ATOM     16  C   ASP A   3      60.006  43.820  90.010  1.00 28.27           C  
ATOM     17  O   ASP A   3      59.360  44.856  89.883  1.00 30.07           O  
ATOM     18  CB  ASP A   3      62.481  43.954  89.819  1.00 33.24           C  
ATOM     19  CG  ASP A   3      63.740  44.560  90.485  1.00 39.36           C  
ATOM     20  OD1 ASP A   3      63.678  45.025  91.653  1.00 41.59           O  
ATOM     21  OD2 ASP A   3      64.813  44.584  89.830  1.00 45.86           O  
ATOM     22  N   LEU A   4      59.641  42.668  89.456  1.00 27.11           N  
ATOM     23  CA  LEU A   4      58.364  42.525  88.802  1.00 27.18           C  
ATOM     24  C   LEU A   4      57.212  42.863  89.762  1.00 25.81           C  
ATOM     25  O   LEU A   4      56.258  43.509  89.396  1.00 24.38           O  
ATOM     26  CB  LEU A   4      58.205  41.125  88.252  1.00 29.67           C  
ATOM     27  CG  LEU A   4      59.019  40.891  86.967  1.00 33.06           C  
ATOM     28  CD1 LEU A   4      58.944  39.419  86.584  1.00 32.86           C  
ATOM     29  CD2 LEU A   4      58.495  41.772  85.807  1.00 32.33           C  
ATOM     30  N   ILE A   5      57.340  42.437  91.000  1.00 22.13           N  
ATOM     31  CA  ILE A   5      56.260  42.528  91.950  1.00 24.40           C  
ATOM     32  C   ILE A   5      56.134  43.976  92.428  1.00 21.36           C  
ATOM     33  O   ILE A   5      55.039  44.478  92.563  1.00 18.69           O  
ATOM     34  CB  ILE A   5      56.485  41.517  93.116  1.00 22.58           C  
ATOM     35  CG1 ILE A   5      56.228  40.113  92.592  1.00 25.61           C  
ATOM     36  CG2 ILE A   5      55.585  41.793  94.245  1.00 24.53           C  
ATOM     37  CD1 ILE A   5      56.706  39.012  93.465  1.00 25.42           C  
ATOM     38  N   LEU A   6      57.274  44.612  92.664  1.00 24.30           N  
ATOM     39  CA  LEU A   6      57.380  46.052  92.918  1.00 26.75           C  
ATOM     40  C   LEU A   6      56.796  46.865  91.765  1.00 25.23           C  
ATOM     41  O   LEU A   6      56.076  47.845  91.982  1.00 26.64           O  
ATOM     42  CB  LEU A   6      58.852  46.433  93.164  1.00 25.65           C  
ATOM     43  CG  LEU A   6      59.401  45.958  94.516  1.00 28.51           C  
ATOM     44  CD1 LEU A   6      60.928  46.164  94.600  1.00 29.67           C  
ATOM     45  CD2 LEU A   6      58.740  46.662  95.674  1.00 27.29           C  
ATOM     46  N   LEU A   7      57.084  46.439  90.544  1.00 25.91           N  
ATOM     47  CA  LEU A   7      56.462  47.035  89.370  1.00 25.92           C  
ATOM     48  C   LEU A   7      54.933  46.983  89.393  1.00 25.27           C  
ATOM     49  O   LEU A   7      54.303  47.993  89.206  1.00 19.62           O  
ATOM     50  CB  LEU A   7      56.970  46.379  88.101  1.00 32.19           C  
ATOM     51  CG  LEU A   7      56.604  47.206  86.861  1.00 36.94           C  
ATOM     52  CD1 LEU A   7      57.548  48.422  86.766  1.00 41.28           C  
ATOM     53  CD2 LEU A   7      56.689  46.413  85.656  1.00 38.86           C  
ATOM     54  N   ALA A   8      54.351  45.794  89.564  1.00 23.40           N  
ATOM     55  CA  ALA A   8      52.906  45.653  89.749  1.00 24.83           C  
ATOM     56  C   ALA A   8      52.332  46.468  90.937  1.00 23.28           C  
ATOM     57  O   ALA A   8      51.187  46.921  90.902  1.00 24.88           O  
ATOM     58  CB  ALA A   8      52.521  44.126  89.924  1.00 21.39           C  
ATOM     59  N   GLY A   9      53.096  46.596  92.007  1.00 20.39           N  
ATOM     60  CA  GLY A   9      52.715  47.471  93.112  1.00 19.09           C  
ATOM     61  C   GLY A   9      52.522  48.935  92.711  1.00 14.16           C  
ATOM     62  O   GLY A   9      51.731  49.633  93.298  1.00 19.61           O  
ATOM     63  N   LYS A  10      53.237  49.391  91.701  1.00 14.86           N  
ATOM     64  CA  LYS A  10      53.030  50.729  91.157  1.00 19.44           C  
ATOM     65  C   LYS A  10      51.577  50.999  90.677  1.00 18.26           C  
ATOM     66  O   LYS A  10      51.030  52.111  90.865  1.00 16.98           O  
ATOM     67  CB  LYS A  10      54.026  50.984  90.057  1.00 17.96           C  
ATOM     68  CG  LYS A  10      55.430  51.209  90.512  1.00 20.20           C  
ATOM     69  CD  LYS A  10      56.278  51.503  89.246  1.00 24.38           C  
ATOM     70  CE  LYS A  10      57.787  51.730  89.452  1.00 28.27           C  
ATOM     71  NZ  LYS A  10      58.030  52.089  90.844  1.00 31.65           N  
ATOM     72  N   LEU A  11      50.941  49.954  90.142  1.00 18.54           N  
ATOM     73  CA  LEU A  11      49.534  50.022  89.756  1.00 16.90           C  
ATOM     74  C   LEU A  11      48.605  50.244  90.893  1.00 16.20           C  
ATOM     75  O   LEU A  11      47.474  50.654  90.651  1.00 13.03           O  
ATOM     76  CB  LEU A  11      49.075  48.758  89.024  1.00 18.97           C  
ATOM     77  CG  LEU A  11      49.761  48.378  87.718  1.00 21.58           C  
ATOM     78  CD1 LEU A  11      48.920  47.298  86.993  1.00 21.71           C  
ATOM     79  CD2 LEU A  11      49.970  49.543  86.848  1.00 21.39           C  
ATOM     80  N   LYS A  12      49.047  49.972  92.140  1.00 15.41           N  
ATOM     81  CA  LYS A  12      48.192  50.249  93.300  1.00 15.02           C  
ATOM     82  C   LYS A  12      48.058  51.742  93.553  1.00 11.28           C  
ATOM     83  O   LYS A  12      47.110  52.179  94.188  1.00 14.80           O  
ATOM     84  CB  LYS A  12      48.675  49.579  94.573  1.00 14.53           C  
ATOM     85  CG  LYS A  12      48.683  48.043  94.519  1.00 12.92           C  
ATOM     86  CD  LYS A  12      49.082  47.505  95.886  1.00 14.45           C  
ATOM     87  CE  LYS A  12      49.395  45.999  95.917  1.00 14.14           C  
ATOM     88  NZ  LYS A  12      49.496  45.537  97.364  1.00 12.44           N  
ATOM     89  N   ARG A  13      49.013  52.494  93.074  1.00 14.93           N  
ATOM     90  CA  ARG A  13      49.122  53.920  93.368  1.00 21.48           C  
ATOM     91  C   ARG A  13      48.816  54.809  92.165  1.00 21.04           C  
ATOM     92  O   ARG A  13      48.375  55.917  92.359  1.00 25.12           O  
ATOM     93  CB  ARG A  13      50.507  54.218  93.896  1.00 21.79           C  
ATOM     94  CG  ARG A  13      50.758  53.392  95.100  1.00 26.05           C  
ATOM     95  CD  ARG A  13      51.955  53.813  95.822  1.00 28.11           C  
ATOM     96  NE  ARG A  13      53.166  53.677  95.045  1.00 25.38           N  
ATOM     97  CZ  ARG A  13      53.875  52.564  94.906  1.00 31.75           C  
ATOM     98  NH1 ARG A  13      53.476  51.411  95.412  1.00 35.26           N  
ATOM     99  NH2 ARG A  13      54.989  52.597  94.195  1.00 37.76           N  
ATOM    100  N   ILE A  14      49.041  54.298  90.954  1.00 16.68           N  
ATOM    101  CA  ILE A  14      48.792  55.051  89.727  1.00 23.73           C  
ATOM    102  C   ILE A  14      47.270  55.214  89.496  1.00 20.07           C  
ATOM    103  O   ILE A  14      46.527  54.233  89.499  1.00 24.01           O  
ATOM    104  CB  ILE A  14      49.561  54.388  88.515  1.00 27.46           C  
ATOM    105  CG1 ILE A  14      51.063  54.626  88.690  1.00 26.15           C  
ATOM    106  CG2 ILE A  14      49.126  54.973  87.174  1.00 30.83           C  
ATOM    107  CD1 ILE A  14      51.981  53.675  87.874  1.00 25.18           C  
ATOM    108  N   PRO A  15      46.786  56.473  89.428  1.00 22.29           N  
ATOM    109  CA  PRO A  15      45.350  56.666  89.219  1.00 19.71           C  
ATOM    110  C   PRO A  15      44.879  56.433  87.759  1.00 17.82           C  
ATOM    111  O   PRO A  15      45.621  56.561  86.765  1.00 13.45           O  
ATOM    112  CB  PRO A  15      45.089  58.122  89.688  1.00 17.74           C  
ATOM    113  CG  PRO A  15      46.373  58.776  89.641  1.00 22.50           C  
ATOM    114  CD  PRO A  15      47.492  57.767  89.595  1.00 23.24           C  
ATOM    115  N   ARG A  16      43.651  55.989  87.683  1.00 18.49           N  
ATOM    116  CA  ARG A  16      42.918  56.015  86.463  1.00 20.38           C  
ATOM    117  C   ARG A  16      42.592  57.530  86.151  1.00 18.71           C  
ATOM    118  O   ARG A  16      41.709  58.161  86.810  1.00 16.54           O  
ATOM    119  CB  ARG A  16      41.676  55.155  86.673  1.00 15.60           C  
ATOM    120  CG  ARG A  16      42.021  53.680  86.817  1.00 16.81           C  
ATOM    121  CD  ARG A  16      42.055  52.989  85.439  1.00 17.02           C  
ATOM    122  NE  ARG A  16      40.688  52.842  84.910  1.00 19.02           N  
ATOM    123  CZ  ARG A  16      40.361  52.576  83.630  1.00 20.42           C  
ATOM    124  NH1 ARG A  16      39.083  52.461  83.282  1.00 18.37           N  
ATOM    125  NH2 ARG A  16      41.298  52.443  82.698  1.00 21.81           N  
ATOM    126  N   MET A  17      43.317  58.077  85.170  1.00 20.74           N  
ATOM    127  CA  MET A  17      43.406  59.541  84.942  1.00 25.22           C  
ATOM    128  C   MET A  17      42.130  60.175  84.411  1.00 20.54           C  
ATOM    129  O   MET A  17      41.804  61.295  84.782  1.00 21.18           O  
ATOM    130  CB  MET A  17      44.593  59.898  84.024  1.00 28.01           C  
ATOM    131  CG  MET A  17      45.944  59.856  84.729  1.00 34.93           C  
ATOM    132  SD  MET A  17      46.252  61.144  86.022  1.00 40.07           S  
ATOM    133  CE  MET A  17      45.379  62.479  85.384  1.00 32.60           C  
ATOM    134  N   GLY A  18      41.411  59.454  83.570  1.00 23.45           N  
ATOM    135  CA  GLY A  18      40.103  59.887  83.077  1.00 22.49           C  
ATOM    136  C   GLY A  18      39.209  60.399  84.212  1.00 23.32           C  
ATOM    137  O   GLY A  18      38.722  61.527  84.166  1.00 24.17           O  
ATOM    138  N   TRP A  19      39.040  59.597  85.265  1.00 21.05           N  
ATOM    139  CA  TRP A  19      38.221  60.026  86.423  1.00 20.38           C  
ATOM    140  C   TRP A  19      38.813  61.305  87.056  1.00 19.04           C  
ATOM    141  O   TRP A  19      38.105  62.259  87.345  1.00 17.69           O  
ATOM    142  CB  TRP A  19      38.090  58.913  87.486  1.00 17.99           C  
ATOM    143  CG  TRP A  19      37.768  57.527  86.933  1.00 17.24           C  
ATOM    144  CD1 TRP A  19      38.487  56.393  87.134  1.00 15.98           C  
ATOM    145  CD2 TRP A  19      36.649  57.149  86.084  1.00 19.46           C  
ATOM    146  NE1 TRP A  19      37.914  55.346  86.467  1.00 20.35           N  
ATOM    147  CE2 TRP A  19      36.771  55.766  85.835  1.00 17.31           C  
ATOM    148  CE3 TRP A  19      35.559  57.850  85.520  1.00 18.88           C  
ATOM    149  CZ2 TRP A  19      35.855  55.050  85.031  1.00 19.51           C  
ATOM    150  CZ3 TRP A  19      34.624  57.127  84.708  1.00 18.64           C  
ATOM    151  CH2 TRP A  19      34.800  55.750  84.461  1.00 18.65           C  
ATOM    152  N   LEU A  20      40.122  61.299  87.241  1.00 17.39           N  
ATOM    153  CA  LEU A  20      40.784  62.267  88.059  1.00 21.46           C  
ATOM    154  C   LEU A  20      40.678  63.653  87.446  1.00 22.08           C  
ATOM    155  O   LEU A  20      40.367  64.646  88.132  1.00 19.81           O  
ATOM    156  CB  LEU A  20      42.231  61.816  88.253  1.00 24.72           C  
ATOM    157  CG  LEU A  20      43.264  62.606  89.029  1.00 27.58           C  
ATOM    158  CD1 LEU A  20      44.476  61.748  89.401  1.00 24.69           C  
ATOM    159  CD2 LEU A  20      43.696  63.816  88.191  1.00 30.58           C  
ATOM    160  N   ILE A  21      40.880  63.690  86.144  1.00 24.40           N  
ATOM    161  CA  ILE A  21      40.764  64.894  85.370  1.00 28.46           C  
ATOM    162  C   ILE A  21      39.310  65.429  85.284  1.00 28.01           C  
ATOM    163  O   ILE A  21      39.115  66.624  85.188  1.00 27.15           O  
ATOM    164  CB  ILE A  21      41.382  64.683  83.966  1.00 32.64           C  
ATOM    165  CG1 ILE A  21      42.900  64.455  84.125  1.00 33.07           C  
ATOM    166  CG2 ILE A  21      41.146  65.915  83.098  1.00 36.26           C  
ATOM    167  CD1 ILE A  21      43.596  63.983  82.939  1.00 34.26           C  
ATOM    168  N   LYS A  22      38.329  64.530  85.286  1.00 24.45           N  
ATOM    169  CA  LYS A  22      36.959  64.875  85.432  1.00 22.43           C  
ATOM    170  C   LYS A  22      36.573  65.485  86.797  1.00 23.70           C  
ATOM    171  O   LYS A  22      35.512  66.039  86.913  1.00 21.38           O  
ATOM    172  CB  LYS A  22      36.069  63.665  85.183  1.00 21.20           C  
ATOM    173  CG  LYS A  22      36.004  63.240  83.753  1.00 24.40           C  
ATOM    174  CD  LYS A  22      35.127  64.182  82.981  1.00 26.16           C  
ATOM    175  CE  LYS A  22      35.097  63.872  81.523  1.00 28.50           C  
ATOM    176  NZ  LYS A  22      33.899  64.618  80.958  1.00 29.96           N  
ATOM    177  N   GLY A  23      37.399  65.344  87.824  1.00 21.29           N  
ATOM    178  CA  GLY A  23      37.054  65.854  89.143  1.00 15.42           C  
ATOM    179  C   GLY A  23      36.517  64.813  90.094  1.00 14.68           C  
ATOM    180  O   GLY A  23      36.070  65.140  91.191  1.00 14.72           O  
ATOM    181  N   VAL A  24      36.513  63.554  89.680  1.00 16.10           N  
ATOM    182  CA  VAL A  24      36.146  62.491  90.603  1.00 16.93           C  
ATOM    183  C   VAL A  24      37.205  62.503  91.712  1.00 13.17           C  
ATOM    184  O   VAL A  24      38.395  62.417  91.425  1.00 18.71           O  
ATOM    185  CB  VAL A  24      36.098  61.127  89.947  1.00 19.57           C  
ATOM    186  CG1 VAL A  24      35.895  60.000  91.054  1.00 19.81           C  
ATOM    187  CG2 VAL A  24      35.027  61.086  88.892  1.00 18.65           C  
ATOM    188  N   PRO A  25      36.760  62.660  92.976  1.00 21.33           N  
ATOM    189  CA  PRO A  25      37.647  62.985  94.107  1.00 25.47           C  
ATOM    190  C   PRO A  25      38.675  61.956  94.619  1.00 31.02           C  
ATOM    191  O   PRO A  25      39.785  62.355  95.082  1.00 32.92           O  
ATOM    192  CB  PRO A  25      36.659  63.383  95.242  1.00 27.25           C  
ATOM    193  CG  PRO A  25      35.414  62.752  94.936  1.00 25.12           C  
ATOM    194  CD  PRO A  25      35.325  62.673  93.381  1.00 20.03           C  
ATOM    195  N   ASN A  26      38.341  60.680  94.595  1.00 29.00           N  
ATOM    196  CA  ASN A  26      39.341  59.698  95.034  1.00 31.93           C  
ATOM    197  C   ASN A  26      39.312  58.573  94.040  1.00 24.96           C  
ATOM    198  O   ASN A  26      38.807  57.526  94.318  1.00 22.25           O  
ATOM    199  CB  ASN A  26      39.079  59.198  96.478  1.00 38.14           C  
ATOM    200  CG  ASN A  26      39.553  60.221  97.565  1.00 43.75           C  
ATOM    201  OD1 ASN A  26      38.762  60.673  98.407  1.00 47.47           O  
ATOM    202  ND2 ASN A  26      40.827  60.594  97.519  1.00 44.79           N  
ATOM    203  N   PRO A  27      39.826  58.829  92.837  1.00 19.62           N  
ATOM    204  CA  PRO A  27      39.584  57.922  91.761  1.00 19.88           C  
ATOM    205  C   PRO A  27      40.300  56.547  92.013  1.00 22.26           C  
ATOM    206  O   PRO A  27      41.333  56.520  92.663  1.00 16.15           O  
ATOM    207  CB  PRO A  27      40.183  58.659  90.568  1.00 20.90           C  
ATOM    208  CG  PRO A  27      41.243  59.494  91.157  1.00 23.24           C  
ATOM    209  CD  PRO A  27      40.661  59.975  92.427  1.00 19.89           C  
ATOM    210  N   GLU A  28      39.713  55.453  91.518  1.00 20.15           N  
ATOM    211  CA  GLU A  28      40.355  54.115  91.489  1.00 16.22           C  
ATOM    212  C   GLU A  28      41.753  54.133  90.879  1.00 15.77           C  
ATOM    213  O   GLU A  28      42.098  54.961  90.076  1.00 15.32           O  
ATOM    214  CB  GLU A  28      39.492  53.133  90.721  1.00 14.60           C  
ATOM    215  CG  GLU A  28      39.232  53.564  89.247  1.00 17.82           C  
ATOM    216  CD  GLU A  28      38.838  52.437  88.332  1.00 17.76           C  
ATOM    217  OE1 GLU A  28      38.669  51.269  88.803  1.00 17.86           O  
ATOM    218  OE2 GLU A  28      38.664  52.731  87.137  1.00 16.30           O  
ATOM    219  N   SER A  29      42.561  53.203  91.322  1.00 17.74           N  
ATOM    220  CA  SER A  29      43.835  52.949  90.752  1.00 16.09           C  
ATOM    221  C   SER A  29      43.726  51.999  89.548  1.00 13.43           C  
ATOM    222  O   SER A  29      42.656  51.397  89.270  1.00 11.38           O  
ATOM    223  CB  SER A  29      44.754  52.375  91.832  1.00 17.98           C  
ATOM    224  OG  SER A  29      44.411  51.033  92.143  1.00 19.30           O  
ATOM    225  N   VAL A  30      44.847  51.865  88.844  1.00 11.65           N  
ATOM    226  CA  VAL A  30      44.923  50.957  87.711  1.00 14.43           C  
ATOM    227  C   VAL A  30      44.797  49.486  88.175  1.00 15.45           C  
ATOM    228  O   VAL A  30      44.227  48.639  87.463  1.00 17.19           O  
ATOM    229  CB  VAL A  30      46.193  51.186  86.898  1.00 15.87           C  
ATOM    230  CG1 VAL A  30      46.293  50.179  85.741  1.00 17.22           C  
ATOM    231  CG2 VAL A  30      46.208  52.595  86.358  1.00 17.48           C  
ATOM    232  N   ALA A  31      45.305  49.195  89.374  1.00 16.15           N  
ATOM    233  CA  ALA A  31      45.148  47.889  89.970  1.00 17.48           C  
ATOM    234  C   ALA A  31      43.707  47.581  90.364  1.00 16.18           C  
ATOM    235  O   ALA A  31      43.266  46.457  90.201  1.00 17.58           O  
ATOM    236  CB  ALA A  31      46.025  47.768  91.144  1.00 19.25           C  
ATOM    237  N   ASP A  32      43.009  48.564  90.928  1.00 15.91           N  
ATOM    238  CA  ASP A  32      41.565  48.481  91.246  1.00 16.48           C  
ATOM    239  C   ASP A  32      40.788  48.056  89.978  1.00 15.86           C  
ATOM    240  O   ASP A  32      39.972  47.132  89.978  1.00 12.47           O  
ATOM    241  CB  ASP A  32      41.045  49.861  91.703  1.00 19.68           C  
ATOM    242  CG  ASP A  32      41.328  50.175  93.172  1.00 22.13           C  
ATOM    243  OD1 ASP A  32      41.335  49.207  94.017  1.00 20.55           O  
ATOM    244  OD2 ASP A  32      41.551  51.411  93.469  1.00 14.08           O  
ATOM    245  N   HIS A  33      41.056  48.806  88.916  1.00 15.09           N  
ATOM    246  CA  HIS A  33      40.492  48.603  87.624  1.00 13.94           C  
ATOM    247  C   HIS A  33      40.797  47.228  87.081  1.00 14.78           C  
ATOM    248  O   HIS A  33      39.887  46.532  86.653  1.00 11.48           O  
ATOM    249  CB  HIS A  33      41.081  49.648  86.664  1.00 13.16           C  
ATOM    250  CG  HIS A  33      40.868  49.326  85.245  1.00 11.70           C  
ATOM    251  ND1 HIS A  33      39.613  49.183  84.702  1.00 12.42           N  
ATOM    252  CD2 HIS A  33      41.744  49.095  84.238  1.00 15.41           C  
ATOM    253  CE1 HIS A  33      39.717  48.898  83.417  1.00 10.19           C  
ATOM    254  NE2 HIS A  33      40.994  48.854  83.107  1.00 12.35           N  
ATOM    255  N   SER A  34      42.081  46.877  87.092  1.00 14.96           N  
ATOM    256  CA  SER A  34      42.582  45.619  86.564  1.00 18.95           C  
ATOM    257  C   SER A  34      42.110  44.388  87.304  1.00 20.13           C  
ATOM    258  O   SER A  34      41.914  43.321  86.674  1.00 19.82           O  
ATOM    259  CB  SER A  34      44.109  45.603  86.542  1.00 18.22           C  
ATOM    260  OG  SER A  34      44.608  46.559  85.659  1.00 22.67           O  
ATOM    261  N   TYR A  35      41.940  44.524  88.615  1.00 18.76           N  
ATOM    262  CA  TYR A  35      41.266  43.513  89.411  1.00 17.19           C  
ATOM    263  C   TYR A  35      39.869  43.172  88.891  1.00 20.23           C  
ATOM    264  O   TYR A  35      39.528  41.969  88.721  1.00 16.40           O  
ATOM    265  CB  TYR A  35      41.127  43.902  90.892  1.00 17.34           C  
ATOM    266  CG  TYR A  35      40.258  42.884  91.548  1.00 15.53           C  
ATOM    267  CD1 TYR A  35      40.740  41.584  91.761  1.00 18.39           C  
ATOM    268  CD2 TYR A  35      38.957  43.137  91.813  1.00 12.34           C  
ATOM    269  CE1 TYR A  35      39.930  40.597  92.280  1.00 17.04           C  
ATOM    270  CE2 TYR A  35      38.119  42.138  92.340  1.00 12.97           C  
ATOM    271  CZ  TYR A  35      38.640  40.872  92.563  1.00 16.90           C  
ATOM    272  OH  TYR A  35      37.867  39.863  93.050  1.00 18.23           O  
ATOM    273  N   ARG A  36      39.017  44.192  88.718  1.00 19.79           N  
ATOM    274  CA  ARG A  36      37.624  43.915  88.287  1.00 16.96           C  
ATOM    275  C   ARG A  36      37.541  43.480  86.823  1.00 17.48           C  
ATOM    276  O   ARG A  36      36.627  42.717  86.447  1.00 21.49           O  
ATOM    277  CB  ARG A  36      36.641  45.047  88.574  1.00 15.03           C  
ATOM    278  CG  ARG A  36      35.216  44.527  88.606  1.00 15.08           C  
ATOM    279  CD  ARG A  36      34.211  45.458  89.183  1.00 13.34           C  
ATOM    280  NE  ARG A  36      34.065  46.645  88.363  1.00 16.30           N  
ATOM    281  CZ  ARG A  36      33.202  47.627  88.596  1.00 14.82           C  
ATOM    282  NH1 ARG A  36      32.317  47.531  89.578  1.00 17.65           N  
ATOM    283  NH2 ARG A  36      33.191  48.678  87.799  1.00 20.05           N  
ATOM    284  N   VAL A  37      38.485  43.928  86.010  1.00 15.28           N  
ATOM    285  CA  VAL A  37      38.602  43.423  84.622  1.00 20.20           C  
ATOM    286  C   VAL A  37      38.843  41.863  84.627  1.00 21.05           C  
ATOM    287  O   VAL A  37      38.186  41.137  83.865  1.00 19.25           O  
ATOM    288  CB  VAL A  37      39.718  44.163  83.804  1.00 17.09           C  
ATOM    289  CG1 VAL A  37      39.970  43.491  82.453  1.00 20.77           C  
ATOM    290  CG2 VAL A  37      39.333  45.602  83.581  1.00 21.01           C  
ATOM    291  N   ALA A  38      39.783  41.399  85.477  1.00 17.76           N  
ATOM    292  CA  ALA A  38      40.043  39.978  85.677  1.00 19.10           C  
ATOM    293  C   ALA A  38      38.794  39.285  86.161  1.00 21.36           C  
ATOM    294  O   ALA A  38      38.384  38.254  85.573  1.00 17.11           O  
ATOM    295  CB  ALA A  38      41.194  39.749  86.650  1.00 18.07           C  
ATOM    296  N   PHE A  39      38.142  39.887  87.179  1.00 20.55           N  
ATOM    297  CA  PHE A  39      36.871  39.368  87.656  1.00 18.69           C  
ATOM    298  C   PHE A  39      35.789  39.252  86.563  1.00 19.06           C  
ATOM    299  O   PHE A  39      35.054  38.260  86.505  1.00 21.02           O  
ATOM    300  CB  PHE A  39      36.332  40.162  88.859  1.00 19.67           C  
ATOM    301  CG  PHE A  39      35.024  39.659  89.356  1.00 23.21           C  
ATOM    302  CD1 PHE A  39      34.962  38.574  90.181  1.00 26.69           C  
ATOM    303  CD2 PHE A  39      33.833  40.226  88.937  1.00 22.28           C  
ATOM    304  CE1 PHE A  39      33.709  38.079  90.618  1.00 26.30           C  
ATOM    305  CE2 PHE A  39      32.618  39.739  89.385  1.00 25.45           C  
ATOM    306  CZ  PHE A  39      32.564  38.672  90.239  1.00 20.99           C  
ATOM    307  N   ILE A  40      35.625  40.303  85.771  1.00 21.61           N  
ATOM    308  CA  ILE A  40      34.563  40.338  84.788  1.00 19.79           C  
ATOM    309  C   ILE A  40      34.886  39.319  83.693  1.00 19.47           C  
ATOM    310  O   ILE A  40      33.988  38.632  83.205  1.00 19.93           O  
ATOM    311  CB  ILE A  40      34.394  41.751  84.155  1.00 19.54           C  
ATOM    312  CG1 ILE A  40      33.808  42.725  85.169  1.00 20.72           C  
ATOM    313  CG2 ILE A  40      33.511  41.690  82.864  1.00 14.17           C  
ATOM    314  CD1 ILE A  40      33.993  44.154  84.800  1.00 20.62           C  
ATOM    315  N   THR A  41      36.161  39.237  83.329  1.00 19.41           N  
ATOM    316  CA  THR A  41      36.641  38.263  82.331  1.00 23.05           C  
ATOM    317  C   THR A  41      36.239  36.814  82.711  1.00 23.87           C  
ATOM    318  O   THR A  41      35.723  36.064  81.878  1.00 22.07           O  
ATOM    319  CB  THR A  41      38.196  38.373  82.118  1.00 19.52           C  
ATOM    320  OG1 THR A  41      38.531  39.652  81.579  1.00 20.14           O  
ATOM    321  CG2 THR A  41      38.706  37.279  81.181  1.00 19.99           C  
ATOM    322  N   LEU A  42      36.502  36.449  83.972  1.00 26.94           N  
ATOM    323  CA  LEU A  42      36.089  35.185  84.557  1.00 25.85           C  
ATOM    324  C   LEU A  42      34.591  34.966  84.441  1.00 27.50           C  
ATOM    325  O   LEU A  42      34.148  33.937  83.949  1.00 28.85           O  
ATOM    326  CB  LEU A  42      36.495  35.149  86.020  1.00 30.04           C  
ATOM    327  CG  LEU A  42      36.180  33.895  86.848  1.00 33.06           C  
ATOM    328  CD1 LEU A  42      36.831  32.680  86.219  1.00 37.37           C  
ATOM    329  CD2 LEU A  42      36.704  34.093  88.230  1.00 35.01           C  
ATOM    330  N   LEU A  43      33.826  35.937  84.913  1.00 25.76           N  
ATOM    331  CA  LEU A  43      32.379  35.915  84.833  1.00 31.16           C  
ATOM    332  C   LEU A  43      31.868  35.748  83.379  1.00 30.76           C  
ATOM    333  O   LEU A  43      31.022  34.896  83.097  1.00 27.60           O  
ATOM    334  CB  LEU A  43      31.805  37.210  85.439  1.00 34.70           C  
ATOM    335  CG  LEU A  43      30.482  37.035  86.164  1.00 39.44           C  
ATOM    336  CD1 LEU A  43      30.680  36.279  87.537  1.00 41.91           C  
ATOM    337  CD2 LEU A  43      29.762  38.386  86.369  1.00 38.64           C  
ATOM    338  N   LEU A  44      32.381  36.561  82.461  1.00 29.75           N  
ATOM    339  CA  LEU A  44      31.950  36.474  81.068  1.00 28.81           C  
ATOM    340  C   LEU A  44      32.375  35.140  80.430  1.00 27.32           C  
ATOM    341  O   LEU A  44      31.572  34.512  79.763  1.00 26.97           O  
ATOM    342  CB  LEU A  44      32.435  37.670  80.244  1.00 28.09           C  
ATOM    343  CG  LEU A  44      32.005  39.103  80.664  1.00 30.18           C  
ATOM    344  CD1 LEU A  44      32.774  40.123  79.865  1.00 30.88           C  
ATOM    345  CD2 LEU A  44      30.573  39.355  80.514  1.00 30.88           C  
ATOM    346  N   ALA A  45      33.624  34.721  80.638  1.00 26.77           N  
ATOM    347  CA  ALA A  45      34.082  33.399  80.204  1.00 26.40           C  
ATOM    348  C   ALA A  45      33.072  32.317  80.616  1.00 30.05           C  
ATOM    349  O   ALA A  45      32.684  31.483  79.796  1.00 28.65           O  
ATOM    350  CB  ALA A  45      35.464  33.090  80.782  1.00 27.71           C  
ATOM    351  N   GLU A  46      32.601  32.363  81.861  1.00 31.53           N  
ATOM    352  CA  GLU A  46      31.620  31.366  82.328  1.00 35.58           C  
ATOM    353  C   GLU A  46      30.227  31.473  81.710  1.00 34.59           C  
ATOM    354  O   GLU A  46      29.657  30.455  81.325  1.00 34.29           O  
ATOM    355  CB  GLU A  46      31.587  31.296  83.855  1.00 35.87           C  
ATOM    356  CG  GLU A  46      32.906  30.693  84.401  1.00 40.79           C  
ATOM    357  CD  GLU A  46      33.343  29.354  83.635  1.00 47.34           C  
ATOM    358  OE1 GLU A  46      32.640  28.321  83.892  1.00 45.03           O  
ATOM    359  OE2 GLU A  46      34.359  29.367  82.791  1.00 41.08           O  
ATOM    360  N   GLU A  47      29.703  32.681  81.587  1.00 34.59           N  
ATOM    361  CA  GLU A  47      28.505  32.932  80.785  1.00 38.09           C  
ATOM    362  C   GLU A  47      28.618  32.406  79.307  1.00 38.45           C  
ATOM    363  O   GLU A  47      27.641  31.874  78.753  1.00 35.47           O  
ATOM    364  CB  GLU A  47      28.182  34.428  80.799  1.00 41.71           C  
ATOM    365  CG  GLU A  47      27.012  34.848  79.914  1.00 49.28           C  
ATOM    366  CD  GLU A  47      25.696  34.118  80.259  1.00 55.15           C  
ATOM    367  OE1 GLU A  47      25.477  33.811  81.461  1.00 56.01           O  
ATOM    368  OE2 GLU A  47      24.888  33.862  79.326  1.00 58.22           O  
ATOM    369  N   LEU A  48      29.799  32.572  78.692  1.00 36.11           N  
ATOM    370  CA  LEU A  48      30.056  32.110  77.311  1.00 35.12           C  
ATOM    371  C   LEU A  48      30.075  30.572  77.208  1.00 36.39           C  
ATOM    372  O   LEU A  48      29.610  30.002  76.222  1.00 34.99           O  
ATOM    373  CB  LEU A  48      31.376  32.705  76.772  1.00 33.83           C  
ATOM    374  CG  LEU A  48      31.300  34.181  76.313  1.00 31.97           C  
ATOM    375  CD1 LEU A  48      32.628  34.764  76.020  1.00 26.07           C  
ATOM    376  CD2 LEU A  48      30.402  34.346  75.085  1.00 36.03           C  
ATOM    377  N   LYS A  49      30.610  29.920  78.233  1.00 37.53           N  
ATOM    378  CA  LYS A  49      30.645  28.470  78.316  1.00 40.43           C  
ATOM    379  C   LYS A  49      29.216  27.926  78.336  1.00 44.09           C  
ATOM    380  O   LYS A  49      28.927  26.933  77.671  1.00 46.01           O  
ATOM    381  CB  LYS A  49      31.400  28.039  79.563  1.00 41.93           C  
ATOM    382  CG  LYS A  49      32.011  26.669  79.516  1.00 43.71           C  
ATOM    383  CD  LYS A  49      32.357  26.177  80.947  1.00 45.68           C  
ATOM    384  N   LYS A  50      28.327  28.603  79.067  1.00 44.00           N  
ATOM    385  CA  LYS A  50      26.905  28.259  79.101  1.00 45.41           C  
ATOM    386  C   LYS A  50      26.205  28.458  77.753  1.00 46.17           C  
ATOM    387  O   LYS A  50      25.151  27.890  77.518  1.00 49.86           O  
ATOM    388  CB  LYS A  50      26.163  29.091  80.175  1.00 46.24           C  
ATOM    389  CG  LYS A  50      26.553  28.771  81.626  1.00 47.90           C  
ATOM    390  N   LYS A  51      26.752  29.300  76.893  1.00 43.96           N  
ATOM    391  CA  LYS A  51      26.165  29.548  75.588  1.00 42.71           C  
ATOM    392  C   LYS A  51      26.840  28.694  74.507  1.00 40.69           C  
ATOM    393  O   LYS A  51      26.581  28.868  73.316  1.00 42.35           O  
ATOM    394  CB  LYS A  51      26.271  31.035  75.232  1.00 43.58           C  
ATOM    395  CG  LYS A  51      25.464  31.911  76.129  1.00 45.41           C  
ATOM    396  CD  LYS A  51      24.756  33.004  75.369  1.00 48.15           C  
ATOM    397  CE  LYS A  51      24.245  34.110  76.318  1.00 49.97           C  
ATOM    398  N   GLY A  52      27.699  27.778  74.935  1.00 38.03           N  
ATOM    399  CA  GLY A  52      28.410  26.882  74.056  1.00 35.86           C  
ATOM    400  C   GLY A  52      29.625  27.485  73.390  1.00 36.67           C  
ATOM    401  O   GLY A  52      30.034  27.023  72.342  1.00 36.43           O  
ATOM    402  N   VAL A  53      30.215  28.518  73.982  1.00 37.14           N  
ATOM    403  CA  VAL A  53      31.375  29.180  73.371  1.00 34.47           C  
ATOM    404  C   VAL A  53      32.581  28.877  74.239  1.00 34.40           C  
ATOM    405  O   VAL A  53      32.677  29.346  75.357  1.00 37.32           O  
ATOM    406  CB  VAL A  53      31.157  30.698  73.247  1.00 34.38           C  
ATOM    407  CG1 VAL A  53      32.306  31.369  72.467  1.00 34.96           C  
ATOM    408  CG2 VAL A  53      29.840  30.992  72.578  1.00 33.11           C  
ATOM    409  N   GLU A  54      33.476  28.051  73.731  1.00 35.47           N  
ATOM    410  CA  GLU A  54      34.673  27.688  74.454  1.00 36.47           C  
ATOM    411  C   GLU A  54      35.625  28.872  74.428  1.00 33.59           C  
ATOM    412  O   GLU A  54      35.757  29.560  73.425  1.00 34.37           O  
ATOM    413  CB  GLU A  54      35.347  26.437  73.853  1.00 37.54           C  
ATOM    414  N   ILE A  55      36.278  29.096  75.559  1.00 33.09           N  
ATOM    415  CA  ILE A  55      37.265  30.153  75.707  1.00 29.52           C  
ATOM    416  C   ILE A  55      38.434  29.443  76.337  1.00 29.24           C  
ATOM    417  O   ILE A  55      38.238  28.542  77.157  1.00 24.43           O  
ATOM    418  CB  ILE A  55      36.699  31.285  76.625  1.00 29.89           C  
ATOM    419  CG1 ILE A  55      35.553  32.036  75.914  1.00 32.64           C  
ATOM    420  CG2 ILE A  55      37.791  32.262  77.111  1.00 29.66           C  
ATOM    421  CD1 ILE A  55      35.965  32.908  74.693  1.00 29.27           C  
ATOM    422  N   ASP A  56      39.642  29.814  75.932  1.00 26.29           N  
ATOM    423  CA  ASP A  56      40.828  29.491  76.691  1.00 25.74           C  
ATOM    424  C   ASP A  56      40.910  30.433  77.922  1.00 25.90           C  
ATOM    425  O   ASP A  56      41.438  31.536  77.852  1.00 27.24           O  
ATOM    426  CB  ASP A  56      42.038  29.646  75.779  1.00 24.83           C  
ATOM    427  CG  ASP A  56      43.331  29.261  76.434  1.00 22.65           C  
ATOM    428  OD1 ASP A  56      43.371  28.913  77.631  1.00 28.87           O  
ATOM    429  OD2 ASP A  56      44.346  29.304  75.731  1.00 29.00           O  
ATOM    430  N   VAL A  57      40.360  29.975  79.037  1.00 25.22           N  
ATOM    431  CA  VAL A  57      40.193  30.779  80.215  1.00 25.27           C  
ATOM    432  C   VAL A  57      41.515  31.142  80.843  1.00 23.97           C  
ATOM    433  O   VAL A  57      41.696  32.275  81.260  1.00 20.15           O  
ATOM    434  CB  VAL A  57      39.271  30.102  81.223  1.00 29.57           C  
ATOM    435  CG1 VAL A  57      39.149  30.958  82.524  1.00 28.94           C  
ATOM    436  CG2 VAL A  57      37.892  29.875  80.585  1.00 28.22           C  
ATOM    437  N   GLU A  58      42.442  30.188  80.872  1.00 20.84           N  
ATOM    438  CA  GLU A  58      43.779  30.433  81.332  1.00 20.50           C  
ATOM    439  C   GLU A  58      44.388  31.609  80.617  1.00 27.52           C  
ATOM    440  O   GLU A  58      44.840  32.569  81.285  1.00 25.03           O  
ATOM    441  CB  GLU A  58      44.665  29.209  81.121  1.00 21.89           C  
ATOM    442  CG  GLU A  58      46.054  29.402  81.601  1.00 26.37           C  
ATOM    443  CD  GLU A  58      46.886  28.164  81.588  1.00 29.68           C  
ATOM    444  OE1 GLU A  58      46.333  27.047  81.599  1.00 36.18           O  
ATOM    445  OE2 GLU A  58      48.108  28.313  81.587  1.00 28.30           O  
ATOM    446  N   LYS A  59      44.409  31.549  79.261  1.00 24.57           N  
ATOM    447  CA  LYS A  59      44.901  32.685  78.485  1.00 21.65           C  
ATOM    448  C   LYS A  59      44.158  34.013  78.735  1.00 15.58           C  
ATOM    449  O   LYS A  59      44.786  35.056  78.833  1.00 17.70           O  
ATOM    450  CB  LYS A  59      44.878  32.373  77.014  1.00 25.98           C  
ATOM    451  CG  LYS A  59      45.321  33.552  76.109  1.00 27.69           C  
ATOM    452  CD  LYS A  59      45.173  33.187  74.660  1.00 30.09           C  
ATOM    453  CE  LYS A  59      46.371  32.423  74.162  1.00 29.28           C  
ATOM    454  NZ  LYS A  59      46.048  31.771  72.853  1.00 32.03           N  
ATOM    455  N   ALA A  60      42.845  33.973  78.830  1.00 17.25           N  
ATOM    456  CA  ALA A  60      42.065  35.169  79.037  1.00 20.12           C  
ATOM    457  C   ALA A  60      42.343  35.848  80.408  1.00 21.52           C  
ATOM    458  O   ALA A  60      42.407  37.074  80.486  1.00 22.27           O  
ATOM    459  CB  ALA A  60      40.602  34.877  78.841  1.00 20.70           C  
ATOM    460  N   LEU A  61      42.553  35.049  81.456  1.00 22.43           N  
ATOM    461  CA  LEU A  61      42.917  35.573  82.765  1.00 19.87           C  
ATOM    462  C   LEU A  61      44.332  36.102  82.772  1.00 19.08           C  
ATOM    463  O   LEU A  61      44.580  37.185  83.357  1.00 18.69           O  
ATOM    464  CB  LEU A  61      42.713  34.536  83.882  1.00 22.91           C  
ATOM    465  CG  LEU A  61      41.305  33.955  83.992  1.00 25.10           C  
ATOM    466  CD1 LEU A  61      41.258  32.822  85.071  1.00 25.04           C  
ATOM    467  CD2 LEU A  61      40.295  35.034  84.270  1.00 25.19           C  
ATOM    468  N   LYS A  62      45.271  35.433  82.105  1.00 19.90           N  
ATOM    469  CA  LYS A  62      46.626  36.013  82.043  1.00 19.80           C  
ATOM    470  C   LYS A  62      46.596  37.386  81.349  1.00 23.38           C  
ATOM    471  O   LYS A  62      47.256  38.322  81.778  1.00 21.17           O  
ATOM    472  CB  LYS A  62      47.609  35.128  81.304  1.00 23.91           C  
ATOM    473  CG  LYS A  62      48.010  33.838  81.954  1.00 26.14           C  
ATOM    474  CD  LYS A  62      48.976  33.099  81.045  1.00 28.66           C  
ATOM    475  CE  LYS A  62      49.395  31.771  81.607  1.00 34.50           C  
ATOM    476  NZ  LYS A  62      50.632  31.215  80.914  1.00 38.93           N  
ATOM    477  N   ILE A  63      45.815  37.494  80.281  1.00 21.97           N  
ATOM    478  CA  ILE A  63      45.735  38.744  79.511  1.00 22.25           C  
ATOM    479  C   ILE A  63      45.144  39.870  80.358  1.00 20.36           C  
ATOM    480  O   ILE A  63      45.641  40.973  80.333  1.00 19.73           O  
ATOM    481  CB  ILE A  63      44.886  38.579  78.226  1.00 20.38           C  
ATOM    482  CG1 ILE A  63      45.584  37.650  77.214  1.00 20.90           C  
ATOM    483  CG2 ILE A  63      44.556  39.958  77.602  1.00 21.85           C  
ATOM    484  CD1 ILE A  63      44.659  37.162  76.078  1.00 22.69           C  
ATOM    485  N   ALA A  64      44.062  39.563  81.074  1.00 19.85           N  
ATOM    486  CA  ALA A  64      43.400  40.503  81.940  1.00 18.07           C  
ATOM    487  C   ALA A  64      44.343  41.081  83.029  1.00 19.01           C  
ATOM    488  O   ALA A  64      44.293  42.269  83.326  1.00 21.23           O  
ATOM    489  CB  ALA A  64      42.226  39.846  82.578  1.00 17.81           C  
ATOM    490  N   ILE A  65      45.182  40.212  83.578  1.00 20.55           N  
ATOM    491  CA  ILE A  65      46.182  40.542  84.565  1.00 24.49           C  
ATOM    492  C   ILE A  65      47.276  41.428  84.024  1.00 21.89           C  
ATOM    493  O   ILE A  65      47.644  42.419  84.679  1.00 23.75           O  
ATOM    494  CB  ILE A  65      46.779  39.277  85.223  1.00 23.52           C  
ATOM    495  CG1 ILE A  65      45.729  38.611  86.085  1.00 21.67           C  
ATOM    496  CG2 ILE A  65      47.991  39.639  86.128  1.00 27.21           C  
ATOM    497  CD1 ILE A  65      46.060  37.168  86.406  1.00 24.21           C  
ATOM    498  N   ILE A  66      47.777  41.127  82.835  1.00 22.43           N  
ATOM    499  CA  ILE A  66      48.918  41.907  82.303  1.00 20.67           C  
ATOM    500  C   ILE A  66      48.481  43.121  81.463  1.00 21.50           C  
ATOM    501  O   ILE A  66      49.294  43.945  81.113  1.00 19.55           O  
ATOM    502  CB  ILE A  66      49.915  41.014  81.530  1.00 24.24           C  
ATOM    503  CG1 ILE A  66      49.270  40.364  80.303  1.00 28.10           C  
ATOM    504  CG2 ILE A  66      50.477  39.893  82.473  1.00 24.27           C  
ATOM    505  CD1 ILE A  66      49.267  41.180  79.067  1.00 29.58           C  
ATOM    506  N   HIS A  67      47.191  43.253  81.162  1.00 21.32           N  
ATOM    507  CA  HIS A  67      46.812  44.127  80.057  1.00 22.98           C  
ATOM    508  C   HIS A  67      47.139  45.630  80.247  1.00 26.29           C  
ATOM    509  O   HIS A  67      47.431  46.320  79.265  1.00 22.20           O  
ATOM    510  CB  HIS A  67      45.375  43.896  79.661  1.00 20.52           C  
ATOM    511  CG  HIS A  67      44.411  44.739  80.406  1.00 23.61           C  
ATOM    512  ND1 HIS A  67      43.989  44.430  81.676  1.00 24.36           N  
ATOM    513  CD2 HIS A  67      43.821  45.908  80.080  1.00 23.36           C  
ATOM    514  CE1 HIS A  67      43.176  45.376  82.108  1.00 25.38           C  
ATOM    515  NE2 HIS A  67      43.041  46.276  81.154  1.00 26.11           N  
ATOM    516  N   ASP A  68      47.141  46.115  81.496  1.00 25.44           N  
ATOM    517  CA  ASP A  68      47.477  47.507  81.795  1.00 20.55           C  
ATOM    518  C   ASP A  68      48.756  47.610  82.627  1.00 22.40           C  
ATOM    519  O   ASP A  68      49.074  48.685  83.127  1.00 20.47           O  
ATOM    520  CB  ASP A  68      46.326  48.187  82.524  1.00 22.53           C  
ATOM    521  CG  ASP A  68      45.219  48.625  81.585  1.00 24.12           C  
ATOM    522  OD1 ASP A  68      45.408  48.573  80.369  1.00 26.91           O  
ATOM    523  OD2 ASP A  68      44.142  49.040  82.056  1.00 26.55           O  
ATOM    524  N   LEU A  69      49.524  46.519  82.707  1.00 17.43           N  
ATOM    525  CA  LEU A  69      50.735  46.501  83.505  1.00 22.80           C  
ATOM    526  C   LEU A  69      51.849  47.432  82.967  1.00 27.32           C  
ATOM    527  O   LEU A  69      52.668  47.941  83.745  1.00 25.26           O  
ATOM    528  CB  LEU A  69      51.245  45.077  83.588  1.00 26.03           C  
ATOM    529  CG  LEU A  69      52.349  44.739  84.579  1.00 30.45           C  
ATOM    530  CD1 LEU A  69      52.138  45.375  86.005  1.00 29.95           C  
ATOM    531  CD2 LEU A  69      52.420  43.211  84.647  1.00 32.06           C  
ATOM    532  N   GLY A  70      51.853  47.663  81.648  1.00 23.92           N  
ATOM    533  CA  GLY A  70      52.726  48.655  81.036  1.00 25.38           C  
ATOM    534  C   GLY A  70      52.505  50.089  81.539  1.00 22.90           C  
ATOM    535  O   GLY A  70      53.397  50.946  81.411  1.00 19.81           O  
ATOM    536  N   GLU A  71      51.330  50.330  82.128  1.00 22.19           N  
ATOM    537  CA  GLU A  71      51.015  51.614  82.740  1.00 23.99           C  
ATOM    538  C   GLU A  71      51.779  51.859  84.042  1.00 24.20           C  
ATOM    539  O   GLU A  71      51.897  52.995  84.468  1.00 24.71           O  
ATOM    540  CB  GLU A  71      49.493  51.767  82.935  1.00 25.72           C  
ATOM    541  CG  GLU A  71      48.770  51.642  81.612  1.00 22.31           C  
ATOM    542  CD  GLU A  71      47.295  51.995  81.628  1.00 23.51           C  
ATOM    543  OE1 GLU A  71      46.638  52.036  82.702  1.00 25.48           O  
ATOM    544  OE2 GLU A  71      46.783  52.193  80.519  1.00 19.21           O  
ATOM    545  N   ALA A  72      52.321  50.796  84.649  1.00 21.97           N  
ATOM    546  CA  ALA A  72      53.245  50.924  85.757  1.00 19.53           C  
ATOM    547  C   ALA A  72      54.422  51.804  85.396  1.00 16.67           C  
ATOM    548  O   ALA A  72      54.936  52.518  86.234  1.00 22.06           O  
ATOM    549  CB  ALA A  72      53.739  49.535  86.239  1.00 18.48           C  
ATOM    550  N   ILE A  73      54.818  51.757  84.139  1.00 18.44           N  
ATOM    551  CA  ILE A  73      55.913  52.569  83.570  1.00 21.12           C  
ATOM    552  C   ILE A  73      55.430  53.856  82.865  1.00 20.50           C  
ATOM    553  O   ILE A  73      55.969  54.937  83.072  1.00 23.28           O  
ATOM    554  CB  ILE A  73      56.726  51.639  82.604  1.00 23.84           C  
ATOM    555  CG1 ILE A  73      57.049  50.340  83.369  1.00 27.85           C  
ATOM    556  CG2 ILE A  73      57.956  52.319  82.067  1.00 25.07           C  
ATOM    557  CD1 ILE A  73      58.171  49.554  82.868  1.00 34.01           C  
ATOM    558  N   ILE A  74      54.380  53.723  82.067  1.00 25.42           N  
ATOM    559  CA  ILE A  74      53.891  54.785  81.167  1.00 24.84           C  
ATOM    560  C   ILE A  74      52.843  55.699  81.831  1.00 26.12           C  
ATOM    561  O   ILE A  74      52.634  56.824  81.369  1.00 24.47           O  
ATOM    562  CB  ILE A  74      53.271  54.146  79.891  1.00 23.95           C  
ATOM    563  CG1 ILE A  74      54.328  53.367  79.079  1.00 25.24           C  
ATOM    564  CG2 ILE A  74      52.520  55.184  79.010  1.00 24.01           C  
ATOM    565  CD1 ILE A  74      55.616  54.146  78.778  1.00 26.20           C  
ATOM    566  N   THR A  75      52.236  55.218  82.930  1.00 24.36           N  
ATOM    567  CA  THR A  75      51.006  55.786  83.537  1.00 23.51           C  
ATOM    568  C   THR A  75      49.804  55.565  82.624  1.00 23.22           C  
ATOM    569  O   THR A  75      49.944  55.097  81.506  1.00 22.96           O  
ATOM    570  CB  THR A  75      51.084  57.303  83.918  1.00 22.38           C  
ATOM    571  OG1 THR A  75      51.037  58.124  82.729  1.00 23.18           O  
ATOM    572  CG2 THR A  75      52.352  57.577  84.703  1.00 25.44           C  
ATOM    573  N   ASP A  76      48.624  55.881  83.152  1.00 21.24           N  
ATOM    574  CA  ASP A  76      47.394  55.735  82.441  1.00 24.02           C  
ATOM    575  C   ASP A  76      47.154  57.048  81.646  1.00 25.11           C  
ATOM    576  O   ASP A  76      46.570  57.982  82.146  1.00 28.81           O  
ATOM    577  CB  ASP A  76      46.260  55.473  83.444  1.00 24.35           C  
ATOM    578  CG  ASP A  76      44.932  55.251  82.776  1.00 24.85           C  
ATOM    579  OD1 ASP A  76      44.918  54.840  81.600  1.00 26.02           O  
ATOM    580  OD2 ASP A  76      43.898  55.521  83.403  1.00 27.19           O  
ATOM    581  N   LEU A  77      47.607  57.100  80.408  1.00 23.96           N  
ATOM    582  CA  LEU A  77      47.443  58.296  79.605  1.00 25.11           C  
ATOM    583  C   LEU A  77      45.959  58.522  79.264  1.00 23.20           C  
ATOM    584  O   LEU A  77      45.273  57.616  78.759  1.00 22.97           O  
ATOM    585  CB  LEU A  77      48.322  58.245  78.354  1.00 29.06           C  
ATOM    586  CG  LEU A  77      49.812  58.134  78.684  1.00 31.90           C  
ATOM    587  CD1 LEU A  77      50.653  58.013  77.411  1.00 34.73           C  
ATOM    588  CD2 LEU A  77      50.284  59.297  79.520  1.00 32.15           C  
ATOM    589  N   PRO A  78      45.443  59.717  79.615  1.00 23.25           N  
ATOM    590  CA  PRO A  78      44.049  60.025  79.288  1.00 24.89           C  
ATOM    591  C   PRO A  78      43.877  60.263  77.796  1.00 27.73           C  
ATOM    592  O   PRO A  78      44.881  60.372  77.053  1.00 22.86           O  
ATOM    593  CB  PRO A  78      43.763  61.303  80.110  1.00 23.44           C  
ATOM    594  CG  PRO A  78      45.129  61.938  80.345  1.00 23.94           C  
ATOM    595  CD  PRO A  78      46.126  60.832  80.320  1.00 20.73           C  
ATOM    596  N   LEU A  79      42.622  60.354  77.363  1.00 29.13           N  
ATOM    597  CA  LEU A  79      42.313  60.572  75.947  1.00 30.40           C  
ATOM    598  C   LEU A  79      42.976  61.827  75.405  1.00 27.11           C  
ATOM    599  O   LEU A  79      43.434  61.839  74.274  1.00 32.73           O  
ATOM    600  CB  LEU A  79      40.804  60.657  75.743  1.00 30.14           C  
ATOM    601  CG  LEU A  79      40.047  59.345  75.905  1.00 34.43           C  
ATOM    602  CD1 LEU A  79      38.590  59.609  76.352  1.00 37.65           C  
ATOM    603  CD2 LEU A  79      40.064  58.530  74.608  1.00 33.33           C  
ATOM    604  N   SER A  80      43.027  62.881  76.217  1.00 27.95           N  
ATOM    605  CA  SER A  80      43.595  64.168  75.795  1.00 26.06           C  
ATOM    606  C   SER A  80      45.048  64.000  75.346  1.00 26.08           C  
ATOM    607  O   SER A  80      45.459  64.582  74.357  1.00 26.80           O  
ATOM    608  CB  SER A  80      43.468  65.204  76.930  1.00 26.22           C  
ATOM    609  OG  SER A  80      44.251  64.844  78.075  1.00 25.92           O  
ATOM    610  N   ALA A  81      45.792  63.165  76.082  1.00 25.92           N  
ATOM    611  CA  ALA A  81      47.208  62.932  75.875  1.00 28.45           C  
ATOM    612  C   ALA A  81      47.437  62.003  74.692  1.00 30.53           C  
ATOM    613  O   ALA A  81      48.476  62.081  73.992  1.00 27.45           O  
ATOM    614  CB  ALA A  81      47.819  62.330  77.146  1.00 30.75           C  
ATOM    615  N   GLN A  82      46.461  61.125  74.472  1.00 30.39           N  
ATOM    616  CA  GLN A  82      46.512  60.163  73.365  1.00 32.96           C  
ATOM    617  C   GLN A  82      46.424  60.808  71.972  1.00 31.41           C  
ATOM    618  O   GLN A  82      46.768  60.177  70.999  1.00 35.71           O  
ATOM    619  CB  GLN A  82      45.434  59.095  73.527  1.00 31.28           C  
ATOM    620  CG  GLN A  82      45.695  58.153  74.726  1.00 31.22           C  
ATOM    621  CD  GLN A  82      44.525  57.222  74.987  1.00 33.64           C  
ATOM    622  OE1 GLN A  82      43.938  56.679  74.044  1.00 35.97           O  
ATOM    623  NE2 GLN A  82      44.180  57.028  76.260  1.00 30.57           N  
ATOM    624  N   LYS A  83      45.968  62.050  71.891  1.00 29.74           N  
ATOM    625  CA  LYS A  83      45.975  62.781  70.646  1.00 33.54           C  
ATOM    626  C   LYS A  83      47.403  63.205  70.235  1.00 32.78           C  
ATOM    627  O   LYS A  83      47.613  63.589  69.089  1.00 34.04           O  
ATOM    628  CB  LYS A  83      45.053  64.015  70.746  1.00 35.98           C  
ATOM    629  N   TYR A  84      48.361  63.155  71.177  1.00 31.93           N  
ATOM    630  CA  TYR A  84      49.737  63.594  70.933  1.00 30.13           C  
ATOM    631  C   TYR A  84      50.764  62.517  71.163  1.00 32.46           C  
ATOM    632  O   TYR A  84      51.901  62.707  70.780  1.00 36.25           O  
ATOM    633  CB  TYR A  84      50.099  64.806  71.815  1.00 29.46           C  
ATOM    634  CG  TYR A  84      49.185  65.948  71.625  1.00 26.57           C  
ATOM    635  CD1 TYR A  84      49.414  66.879  70.617  1.00 27.39           C  
ATOM    636  CD2 TYR A  84      48.029  66.079  72.404  1.00 27.33           C  
ATOM    637  CE1 TYR A  84      48.513  67.958  70.404  1.00 26.30           C  
ATOM    638  CE2 TYR A  84      47.135  67.150  72.219  1.00 25.78           C  
ATOM    639  CZ  TYR A  84      47.390  68.083  71.207  1.00 27.17           C  
ATOM    640  OH  TYR A  84      46.518  69.121  71.011  1.00 26.86           O  
ATOM    641  N   LEU A  85      50.369  61.404  71.801  1.00 34.18           N  
ATOM    642  CA  LEU A  85      51.280  60.307  72.172  1.00 33.20           C  
ATOM    643  C   LEU A  85      50.632  58.995  71.828  1.00 34.31           C  
ATOM    644  O   LEU A  85      49.431  58.852  72.015  1.00 36.16           O  
ATOM    645  CB  LEU A  85      51.530  60.308  73.693  1.00 33.67           C  
ATOM    646  CG  LEU A  85      52.257  61.565  74.184  1.00 34.68           C  
ATOM    647  CD1 LEU A  85      52.232  61.707  75.673  1.00 32.35           C  
ATOM    648  CD2 LEU A  85      53.689  61.567  73.666  1.00 36.56           C  
ATOM    649  N   ASN A  86      51.422  58.022  71.378  1.00 37.61           N  
ATOM    650  CA  ASN A  86      50.914  56.658  71.101  1.00 38.89           C  
ATOM    651  C   ASN A  86      50.987  55.778  72.367  1.00 36.31           C  
ATOM    652  O   ASN A  86      52.004  55.157  72.658  1.00 34.35           O  
ATOM    653  CB  ASN A  86      51.700  56.019  69.946  1.00 41.76           C  
ATOM    654  CG  ASN A  86      50.991  54.780  69.335  1.00 45.78           C  
ATOM    655  OD1 ASN A  86      50.103  54.139  69.947  1.00 45.69           O  
ATOM    656  ND2 ASN A  86      51.405  54.438  68.120  1.00 48.29           N  
ATOM    657  N   LYS A  87      49.876  55.726  73.092  1.00 39.53           N  
ATOM    658  CA  LYS A  87      49.787  55.006  74.347  1.00 40.65           C  
ATOM    659  C   LYS A  87      50.124  53.509  74.174  1.00 38.43           C  
ATOM    660  O   LYS A  87      50.984  52.976  74.899  1.00 32.12           O  
ATOM    661  CB  LYS A  87      48.372  55.175  74.941  1.00 41.94           C  
ATOM    662  CG  LYS A  87      48.204  54.616  76.362  1.00 42.20           C  
ATOM    663  CD  LYS A  87      46.743  54.633  76.829  1.00 43.70           C  
ATOM    664  N   GLU A  88      49.457  52.861  73.210  1.00 36.85           N  
ATOM    665  CA  GLU A  88      49.533  51.414  73.051  1.00 37.94           C  
ATOM    666  C   GLU A  88      50.939  50.982  72.675  1.00 37.22           C  
ATOM    667  O   GLU A  88      51.474  50.024  73.238  1.00 33.12           O  
ATOM    668  CB  GLU A  88      48.530  50.919  72.010  1.00 39.18           C  
ATOM    669  N   GLU A  89      51.540  51.727  71.752  1.00 37.35           N  
ATOM    670  CA  GLU A  89      52.903  51.484  71.338  1.00 41.74           C  
ATOM    671  C   GLU A  89      53.894  51.604  72.503  1.00 37.83           C  
ATOM    672  O   GLU A  89      54.775  50.769  72.662  1.00 37.77           O  
ATOM    673  CB  GLU A  89      53.280  52.448  70.218  1.00 44.54           C  
ATOM    674  CG  GLU A  89      54.769  52.393  69.823  1.00 50.62           C  
ATOM    675  CD  GLU A  89      55.239  53.622  69.025  1.00 52.40           C  
ATOM    676  OE1 GLU A  89      54.383  54.322  68.397  1.00 54.58           O  
ATOM    677  OE2 GLU A  89      56.477  53.870  69.028  1.00 56.23           O  
ATOM    678  N   ALA A  90      53.746  52.647  73.313  1.00 36.43           N  
ATOM    679  CA  ALA A  90      54.674  52.893  74.428  1.00 31.93           C  
ATOM    680  C   ALA A  90      54.504  51.828  75.535  1.00 28.28           C  
ATOM    681  O   ALA A  90      55.498  51.367  76.121  1.00 29.93           O  
ATOM    682  CB  ALA A  90      54.496  54.308  74.972  1.00 29.86           C  
ATOM    683  N   GLU A  91      53.269  51.399  75.781  1.00 29.89           N  
ATOM    684  CA  GLU A  91      53.012  50.282  76.751  1.00 31.42           C  
ATOM    685  C   GLU A  91      53.626  48.968  76.269  1.00 33.79           C  
ATOM    686  O   GLU A  91      54.202  48.225  77.071  1.00 33.72           O  
ATOM    687  CB  GLU A  91      51.514  50.058  77.011  1.00 30.45           C  
ATOM    688  CG  GLU A  91      50.796  51.155  77.796  1.00 30.52           C  
ATOM    689  CD  GLU A  91      49.321  50.779  78.160  1.00 35.22           C  
ATOM    690  OE1 GLU A  91      49.020  49.595  78.438  1.00 36.03           O  
ATOM    691  OE2 GLU A  91      48.465  51.690  78.199  1.00 38.01           O  
ATOM    692  N   ALA A  92      53.501  48.681  74.963  1.00 33.85           N  
ATOM    693  CA  ALA A  92      54.029  47.438  74.403  1.00 32.84           C  
ATOM    694  C   ALA A  92      55.535  47.414  74.542  1.00 33.10           C  
ATOM    695  O   ALA A  92      56.099  46.385  74.926  1.00 30.69           O  
ATOM    696  CB  ALA A  92      53.610  47.254  72.931  1.00 32.93           C  
ATOM    697  N   LYS A  93      56.183  48.556  74.273  1.00 34.83           N  
ATOM    698  CA  LYS A  93      57.614  48.674  74.438  1.00 33.13           C  
ATOM    699  C   LYS A  93      58.040  48.494  75.899  1.00 36.30           C  
ATOM    700  O   LYS A  93      59.035  47.816  76.181  1.00 39.73           O  
ATOM    701  CB  LYS A  93      58.136  50.011  73.921  1.00 33.20           C  
ATOM    702  CG  LYS A  93      58.266  50.125  72.441  1.00 36.76           C  
ATOM    703  N   ALA A  94      57.328  49.133  76.818  1.00 36.68           N  
ATOM    704  CA  ALA A  94      57.643  49.016  78.251  1.00 35.54           C  
ATOM    705  C   ALA A  94      57.504  47.562  78.709  1.00 37.87           C  
ATOM    706  O   ALA A  94      58.405  47.028  79.381  1.00 34.74           O  
ATOM    707  CB  ALA A  94      56.721  49.937  79.092  1.00 34.71           C  
ATOM    708  N   LEU A  95      56.375  46.928  78.346  1.00 38.07           N  
ATOM    709  CA  LEU A  95      56.170  45.515  78.646  1.00 42.41           C  
ATOM    710  C   LEU A  95      57.285  44.615  78.075  1.00 42.56           C  
ATOM    711  O   LEU A  95      57.782  43.734  78.763  1.00 44.94           O  
ATOM    712  CB  LEU A  95      54.808  45.024  78.141  1.00 43.61           C  
ATOM    713  CG  LEU A  95      53.600  45.148  79.072  1.00 46.38           C  
ATOM    714  CD1 LEU A  95      52.394  44.478  78.396  1.00 47.83           C  
ATOM    715  CD2 LEU A  95      53.859  44.538  80.471  1.00 44.36           C  
ATOM    716  N   LYS A  96      57.650  44.824  76.819  1.00 42.84           N  
ATOM    717  CA  LYS A  96      58.657  44.002  76.187  1.00 45.86           C  
ATOM    718  C   LYS A  96      59.927  44.052  77.036  1.00 47.00           C  
ATOM    719  O   LYS A  96      60.534  43.008  77.313  1.00 48.03           O  
ATOM    720  CB  LYS A  96      58.933  44.459  74.747  1.00 48.24           C  
ATOM    721  CG  LYS A  96      59.692  43.437  73.886  1.00 50.84           C  
ATOM    722  N   ASP A  97      60.308  45.249  77.482  1.00 44.97           N  
ATOM    723  CA  ASP A  97      61.545  45.415  78.270  1.00 45.42           C  
ATOM    724  C   ASP A  97      61.543  44.758  79.653  1.00 43.65           C  
ATOM    725  O   ASP A  97      62.608  44.485  80.186  1.00 39.69           O  
ATOM    726  CB  ASP A  97      61.902  46.898  78.420  1.00 47.09           C  
ATOM    727  CG  ASP A  97      62.442  47.487  77.151  1.00 48.64           C  
ATOM    728  OD1 ASP A  97      62.804  46.693  76.256  1.00 49.00           O  
ATOM    729  OD2 ASP A  97      62.502  48.735  77.047  1.00 47.49           O  
ATOM    730  N   VAL A  98      60.367  44.506  80.229  1.00 44.05           N  
ATOM    731  CA  VAL A  98      60.290  43.900  81.565  1.00 44.12           C  
ATOM    732  C   VAL A  98      59.733  42.485  81.620  1.00 45.64           C  
ATOM    733  O   VAL A  98      60.197  41.673  82.425  1.00 45.35           O  
ATOM    734  CB  VAL A  98      59.461  44.759  82.557  1.00 44.69           C  
ATOM    735  CG1 VAL A  98      60.182  46.061  82.860  1.00 44.61           C  
ATOM    736  CG2 VAL A  98      58.011  44.982  82.072  1.00 42.00           C  
ATOM    737  N   LEU A  99      58.711  42.220  80.806  1.00 47.56           N  
ATOM    738  CA  LEU A  99      58.034  40.913  80.731  1.00 47.03           C  
ATOM    739  C   LEU A  99      57.967  40.458  79.266  1.00 45.52           C  
ATOM    740  O   LEU A  99      56.874  40.260  78.716  1.00 38.21           O  
ATOM    741  CB  LEU A  99      56.605  41.015  81.294  1.00 50.05           C  
ATOM    742  CG  LEU A  99      56.396  41.148  82.803  1.00 50.72           C  
ATOM    743  CD1 LEU A  99      54.975  41.604  83.098  1.00 50.21           C  
ATOM    744  CD2 LEU A  99      56.713  39.815  83.506  1.00 50.63           C  
ATOM    745  N   PRO A 100      59.135  40.262  78.633  1.00 43.79           N  
ATOM    746  CA  PRO A 100      59.159  39.903  77.198  1.00 45.56           C  
ATOM    747  C   PRO A 100      58.329  38.651  76.865  1.00 45.07           C  
ATOM    748  O   PRO A 100      57.875  38.504  75.753  1.00 41.89           O  
ATOM    749  CB  PRO A 100      60.650  39.681  76.906  1.00 43.02           C  
ATOM    750  CG  PRO A 100      61.298  39.516  78.270  1.00 43.23           C  
ATOM    751  CD  PRO A 100      60.485  40.314  79.223  1.00 43.23           C  
ATOM    752  N   GLU A 101      58.123  37.795  77.856  1.00 49.64           N  
ATOM    753  CA  GLU A 101      57.324  36.573  77.730  1.00 54.31           C  
ATOM    754  C   GLU A 101      55.797  36.772  77.699  1.00 51.00           C  
ATOM    755  O   GLU A 101      55.075  35.823  77.477  1.00 45.46           O  
ATOM    756  CB  GLU A 101      57.694  35.604  78.873  1.00 59.78           C  
ATOM    757  CG  GLU A 101      57.232  36.040  80.289  1.00 64.53           C  
ATOM    758  CD  GLU A 101      58.159  37.060  81.004  1.00 67.79           C  
ATOM    759  OE1 GLU A 101      59.062  37.657  80.382  1.00 67.40           O  
ATOM    760  OE2 GLU A 101      57.964  37.263  82.223  1.00 73.42           O  
ATOM    761  N   TYR A 102      55.313  37.990  77.945  1.00 51.60           N  
ATOM    762  CA  TYR A 102      53.886  38.295  77.798  1.00 54.18           C  
ATOM    763  C   TYR A 102      53.639  39.305  76.677  1.00 55.77           C  
ATOM    764  O   TYR A 102      52.643  40.050  76.696  1.00 59.21           O  
ATOM    765  CB  TYR A 102      53.305  38.828  79.114  1.00 57.89           C  
ATOM    766  CG  TYR A 102      53.372  37.839  80.254  1.00 59.35           C  
ATOM    767  CD1 TYR A 102      52.902  36.529  80.095  1.00 61.62           C  
ATOM    768  CD2 TYR A 102      53.894  38.204  81.488  1.00 59.76           C  
ATOM    769  CE1 TYR A 102      52.970  35.601  81.129  1.00 60.93           C  
ATOM    770  CE2 TYR A 102      53.949  37.286  82.536  1.00 61.45           C  
ATOM    771  CZ  TYR A 102      53.484  35.984  82.340  1.00 59.80           C  
ATOM    772  OH  TYR A 102      53.541  35.064  83.352  1.00 60.80           O  
ATOM    773  N   THR A 103      54.541  39.334  75.700  1.00 54.72           N  
ATOM    774  CA  THR A 103      54.458  40.318  74.618  1.00 54.24           C  
ATOM    775  C   THR A 103      53.283  39.999  73.700  1.00 48.78           C  
ATOM    776  O   THR A 103      52.504  40.891  73.353  1.00 46.66           O  
ATOM    777  CB  THR A 103      55.763  40.356  73.777  1.00 56.61           C  
ATOM    778  OG1 THR A 103      56.878  40.489  74.647  1.00 59.79           O  
ATOM    779  CG2 THR A 103      55.754  41.531  72.820  1.00 58.10           C  
ATOM    780  N   GLU A 104      53.180  38.718  73.325  1.00 45.28           N  
ATOM    781  CA  GLU A 104      52.110  38.228  72.462  1.00 45.94           C  
ATOM    782  C   GLU A 104      50.749  38.338  73.117  1.00 44.24           C  
ATOM    783  O   GLU A 104      49.765  38.553  72.426  1.00 43.66           O  
ATOM    784  CB  GLU A 104      52.358  36.781  72.028  1.00 46.49           C  
ATOM    785  N   LEU A 105      50.701  38.202  74.446  1.00 44.67           N  
ATOM    786  CA  LEU A 105      49.448  38.354  75.211  1.00 43.83           C  
ATOM    787  C   LEU A 105      48.924  39.779  75.181  1.00 38.39           C  
ATOM    788  O   LEU A 105      47.723  39.980  74.978  1.00 34.51           O  
ATOM    789  CB  LEU A 105      49.611  37.909  76.672  1.00 45.74           C  
ATOM    790  CG  LEU A 105      49.724  36.405  76.978  1.00 44.43           C  
ATOM    791  CD1 LEU A 105      49.613  36.242  78.475  1.00 45.70           C  
ATOM    792  CD2 LEU A 105      48.672  35.555  76.290  1.00 44.56           C  
ATOM    793  N   PHE A 106      49.814  40.760  75.378  1.00 35.83           N  
ATOM    794  CA  PHE A 106      49.424  42.180  75.264  1.00 34.53           C  
ATOM    795  C   PHE A 106      49.087  42.568  73.794  1.00 37.52           C  
ATOM    796  O   PHE A 106      48.213  43.418  73.567  1.00 36.92           O  
ATOM    797  CB  PHE A 106      50.482  43.108  75.845  1.00 33.98           C  
ATOM    798  CG  PHE A 106      50.145  44.574  75.714  1.00 35.00           C  
ATOM    799  CD1 PHE A 106      49.182  45.161  76.536  1.00 32.46           C  
ATOM    800  CD2 PHE A 106      50.767  45.365  74.752  1.00 34.84           C  
ATOM    801  CE1 PHE A 106      48.857  46.514  76.411  1.00 33.24           C  
ATOM    802  CE2 PHE A 106      50.434  46.726  74.622  1.00 36.85           C  
ATOM    803  CZ  PHE A 106      49.482  47.300  75.461  1.00 33.69           C  
ATOM    804  N   GLU A 107      49.750  41.923  72.811  1.00 37.48           N  
ATOM    805  CA  GLU A 107      49.356  42.068  71.388  1.00 36.20           C  
ATOM    806  C   GLU A 107      47.921  41.597  71.182  1.00 33.21           C  
ATOM    807  O   GLU A 107      47.145  42.277  70.498  1.00 32.18           O  
ATOM    808  CB  GLU A 107      50.318  41.329  70.415  1.00 36.42           C  
ATOM    809  N   GLU A 108      47.560  40.442  71.765  1.00 30.88           N  
ATOM    810  CA  GLU A 108      46.205  39.920  71.615  1.00 29.72           C  
ATOM    811  C   GLU A 108      45.183  40.884  72.193  1.00 32.01           C  
ATOM    812  O   GLU A 108      44.076  41.062  71.648  1.00 29.25           O  
ATOM    813  CB  GLU A 108      46.029  38.566  72.316  1.00 30.59           C  
ATOM    814  CG  GLU A 108      46.395  37.362  71.458  1.00 32.62           C  
ATOM    815  CD  GLU A 108      45.916  36.046  72.010  1.00 26.96           C  
ATOM    816  OE1 GLU A 108      44.706  35.829  72.226  1.00 26.17           O  
ATOM    817  OE2 GLU A 108      46.761  35.185  72.149  1.00 34.28           O  
ATOM    818  N   TYR A 109      45.521  41.451  73.350  1.00 31.01           N  
ATOM    819  CA  TYR A 109      44.634  42.410  74.002  1.00 28.44           C  
ATOM    820  C   TYR A 109      44.507  43.638  73.069  1.00 24.63           C  
ATOM    821  O   TYR A 109      43.371  44.063  72.724  1.00 24.62           O  
ATOM    822  CB  TYR A 109      45.127  42.828  75.411  1.00 27.88           C  
ATOM    823  CG  TYR A 109      44.276  43.939  75.969  1.00 29.95           C  
ATOM    824  CD1 TYR A 109      42.994  43.678  76.382  1.00 25.53           C  
ATOM    825  CD2 TYR A 109      44.718  45.262  75.985  1.00 29.17           C  
ATOM    826  CE1 TYR A 109      42.192  44.641  76.845  1.00 26.41           C  
ATOM    827  CE2 TYR A 109      43.870  46.287  76.459  1.00 29.23           C  
ATOM    828  CZ  TYR A 109      42.607  45.939  76.875  1.00 28.16           C  
ATOM    829  OH  TYR A 109      41.711  46.853  77.367  1.00 31.77           O  
ATOM    830  N   SER A 110      45.646  44.189  72.667  1.00 25.06           N  
ATOM    831  CA  SER A 110      45.604  45.455  71.935  1.00 33.68           C  
ATOM    832  C   SER A 110      44.943  45.277  70.557  1.00 31.79           C  
ATOM    833  O   SER A 110      44.139  46.070  70.161  1.00 32.87           O  
ATOM    834  CB  SER A 110      46.978  46.153  71.869  1.00 34.57           C  
ATOM    835  OG  SER A 110      48.005  45.264  71.554  1.00 41.67           O  
ATOM    836  N   LYS A 111      45.195  44.179  69.882  1.00 33.08           N  
ATOM    837  CA  LYS A 111      44.546  43.939  68.599  1.00 29.68           C  
ATOM    838  C   LYS A 111      43.087  43.581  68.752  1.00 29.21           C  
ATOM    839  O   LYS A 111      42.267  43.985  67.916  1.00 25.60           O  
ATOM    840  CB  LYS A 111      45.299  42.846  67.856  1.00 35.31           C  
ATOM    841  CG  LYS A 111      46.688  43.274  67.403  1.00 37.20           C  
ATOM    842  CD  LYS A 111      46.607  44.249  66.229  1.00 41.11           C  
ATOM    843  CE  LYS A 111      47.957  44.332  65.465  1.00 42.86           C  
ATOM    844  N   ALA A 112      42.762  42.835  69.819  1.00 24.78           N  
ATOM    845  CA  ALA A 112      41.407  42.371  70.117  1.00 23.37           C  
ATOM    846  C   ALA A 112      40.752  41.624  68.948  1.00 25.92           C  
ATOM    847  O   ALA A 112      39.578  41.848  68.594  1.00 23.17           O  
ATOM    848  CB  ALA A 112      40.555  43.504  70.570  1.00 27.44           C  
ATOM    849  N   LEU A 113      41.538  40.743  68.359  1.00 30.51           N  
ATOM    850  CA  LEU A 113      41.120  39.976  67.190  1.00 31.82           C  
ATOM    851  C   LEU A 113      40.744  38.551  67.608  1.00 29.11           C  
ATOM    852  O   LEU A 113      39.701  38.061  67.197  1.00 33.09           O  
ATOM    853  CB  LEU A 113      42.239  39.989  66.131  1.00 31.09           C  
ATOM    854  CG  LEU A 113      42.490  41.349  65.465  1.00 30.72           C  
ATOM    855  CD1 LEU A 113      43.655  41.272  64.503  1.00 30.12           C  
ATOM    856  CD2 LEU A 113      41.233  41.836  64.744  1.00 32.51           C  
ATOM    857  N   THR A 114      41.569  37.912  68.447  1.00 27.65           N  
ATOM    858  CA  THR A 114      41.262  36.568  68.958  1.00 26.31           C  
ATOM    859  C   THR A 114      40.060  36.552  69.916  1.00 26.01           C  
ATOM    860  O   THR A 114      39.636  37.582  70.407  1.00 26.36           O  
ATOM    861  CB  THR A 114      42.431  35.951  69.661  1.00 27.93           C  
ATOM    862  OG1 THR A 114      42.654  36.625  70.923  1.00 24.14           O  
ATOM    863  CG2 THR A 114      43.684  35.989  68.736  1.00 27.92           C  
ATOM    864  N   LEU A 115      39.492  35.389  70.167  1.00 24.76           N  
ATOM    865  CA  LEU A 115      38.329  35.331  71.080  1.00 25.97           C  
ATOM    866  C   LEU A 115      38.699  35.882  72.470  1.00 24.69           C  
ATOM    867  O   LEU A 115      37.941  36.639  73.089  1.00 22.81           O  
ATOM    868  CB  LEU A 115      37.819  33.893  71.228  1.00 30.54           C  
ATOM    869  CG  LEU A 115      36.866  33.270  70.171  1.00 33.89           C  
ATOM    870  CD1 LEU A 115      37.353  33.467  68.740  1.00 34.23           C  
ATOM    871  CD2 LEU A 115      36.661  31.775  70.483  1.00 29.77           C  
ATOM    872  N   GLU A 116      39.871  35.473  72.951  1.00 21.15           N  
ATOM    873  CA  GLU A 116      40.356  35.849  74.277  1.00 22.51           C  
ATOM    874  C   GLU A 116      40.690  37.352  74.329  1.00 22.04           C  
ATOM    875  O   GLU A 116      40.337  38.004  75.272  1.00 22.00           O  
ATOM    876  CB  GLU A 116      41.569  35.004  74.677  1.00 24.32           C  
ATOM    877  CG  GLU A 116      41.219  33.551  75.028  1.00 25.87           C  
ATOM    878  CD  GLU A 116      40.839  32.676  73.779  1.00 26.72           C  
ATOM    879  OE1 GLU A 116      41.518  32.775  72.753  1.00 23.95           O  
ATOM    880  OE2 GLU A 116      39.821  31.947  73.836  1.00 26.20           O  
ATOM    881  N   GLY A 117      41.346  37.882  73.289  1.00 23.39           N  
ATOM    882  CA  GLY A 117      41.580  39.314  73.164  1.00 21.90           C  
ATOM    883  C   GLY A 117      40.303  40.144  73.156  1.00 22.43           C  
ATOM    884  O   GLY A 117      40.219  41.182  73.823  1.00 19.90           O  
ATOM    885  N   GLN A 118      39.299  39.704  72.394  1.00 23.84           N  
ATOM    886  CA  GLN A 118      38.000  40.367  72.377  1.00 19.51           C  
ATOM    887  C   GLN A 118      37.313  40.320  73.725  1.00 21.26           C  
ATOM    888  O   GLN A 118      36.660  41.302  74.142  1.00 23.37           O  
ATOM    889  CB  GLN A 118      37.049  39.680  71.405  1.00 22.76           C  
ATOM    890  CG  GLN A 118      37.413  39.734  69.949  1.00 23.85           C  
ATOM    891  CD  GLN A 118      36.412  38.915  69.138  1.00 22.83           C  
ATOM    892  OE1 GLN A 118      35.204  39.111  69.254  1.00 22.78           O  
ATOM    893  NE2 GLN A 118      36.910  38.024  68.321  1.00 23.30           N  
ATOM    894  N   LEU A 119      37.379  39.152  74.365  1.00 21.55           N  
ATOM    895  CA  LEU A 119      36.779  38.967  75.686  1.00 25.41           C  
ATOM    896  C   LEU A 119      37.323  39.976  76.747  1.00 20.61           C  
ATOM    897  O   LEU A 119      36.557  40.532  77.511  1.00 17.28           O  
ATOM    898  CB  LEU A 119      36.955  37.521  76.191  1.00 25.07           C  
ATOM    899  CG  LEU A 119      36.416  37.255  77.617  1.00 26.05           C  
ATOM    900  CD1 LEU A 119      34.969  37.616  77.768  1.00 24.59           C  
ATOM    901  CD2 LEU A 119      36.630  35.791  78.004  1.00 28.02           C  
ATOM    902  N   VAL A 120      38.636  40.164  76.783  1.00 19.59           N  
ATOM    903  CA  VAL A 120      39.243  41.039  77.765  1.00 21.04           C  
ATOM    904  C   VAL A 120      38.994  42.505  77.412  1.00 21.66           C  
ATOM    905  O   VAL A 120      38.810  43.318  78.311  1.00 20.02           O  
ATOM    906  CB  VAL A 120      40.749  40.758  77.951  1.00 19.76           C  
ATOM    907  CG1 VAL A 120      41.308  41.671  79.010  1.00 21.89           C  
ATOM    908  CG2 VAL A 120      40.981  39.304  78.379  1.00 20.40           C  
ATOM    909  N   LYS A 121      38.972  42.835  76.120  1.00 18.60           N  
ATOM    910  CA  LYS A 121      38.530  44.161  75.684  1.00 21.06           C  
ATOM    911  C   LYS A 121      37.091  44.508  76.103  1.00 20.74           C  
ATOM    912  O   LYS A 121      36.781  45.643  76.542  1.00 22.50           O  
ATOM    913  CB  LYS A 121      38.686  44.309  74.150  1.00 26.95           C  
ATOM    914  CG  LYS A 121      38.597  45.777  73.635  1.00 29.93           C  
ATOM    915  CD  LYS A 121      39.826  46.655  73.995  1.00 32.01           C  
ATOM    916  CE  LYS A 121      40.961  46.442  72.968  1.00 39.63           C  
ATOM    917  NZ  LYS A 121      42.262  47.162  73.205  1.00 36.79           N  
ATOM    918  N   ILE A 122      36.207  43.535  75.993  1.00 21.80           N  
ATOM    919  CA  ILE A 122      34.864  43.710  76.476  1.00 23.18           C  
ATOM    920  C   ILE A 122      34.836  43.941  77.994  1.00 20.95           C  
ATOM    921  O   ILE A 122      34.145  44.806  78.467  1.00 16.65           O  
ATOM    922  CB  ILE A 122      33.973  42.531  76.072  1.00 23.30           C  
ATOM    923  CG1 ILE A 122      33.677  42.630  74.578  1.00 24.17           C  
ATOM    924  CG2 ILE A 122      32.621  42.580  76.825  1.00 27.06           C  
ATOM    925  CD1 ILE A 122      33.089  41.360  74.006  1.00 26.33           C  
ATOM    926  N   ALA A 123      35.580  43.140  78.737  1.00 21.50           N  
ATOM    927  CA  ALA A 123      35.606  43.244  80.208  1.00 22.64           C  
ATOM    928  C   ALA A 123      36.135  44.603  80.662  1.00 18.99           C  
ATOM    929  O   ALA A 123      35.665  45.186  81.600  1.00 18.14           O  
ATOM    930  CB  ALA A 123      36.482  42.109  80.795  1.00 22.18           C  
ATOM    931  N   ASP A 124      37.168  45.059  79.985  1.00 23.11           N  
ATOM    932  CA  ASP A 124      37.795  46.322  80.275  1.00 23.80           C  
ATOM    933  C   ASP A 124      36.841  47.537  80.130  1.00 23.91           C  
ATOM    934  O   ASP A 124      36.761  48.425  81.006  1.00 21.40           O  
ATOM    935  CB  ASP A 124      38.984  46.451  79.349  1.00 18.65           C  
ATOM    936  CG  ASP A 124      39.795  47.671  79.641  1.00 20.54           C  
ATOM    937  OD1 ASP A 124      40.441  47.726  80.681  1.00 22.50           O  
ATOM    938  OD2 ASP A 124      39.770  48.600  78.838  1.00 23.85           O  
ATOM    939  N   LYS A 125      36.118  47.541  79.013  1.00 25.09           N  
ATOM    940  CA  LYS A 125      35.108  48.541  78.734  1.00 22.62           C  
ATOM    941  C   LYS A 125      33.940  48.456  79.664  1.00 21.36           C  
ATOM    942  O   LYS A 125      33.401  49.479  80.065  1.00 22.89           O  
ATOM    943  CB  LYS A 125      34.675  48.425  77.270  1.00 28.52           C  
ATOM    944  CG  LYS A 125      35.793  48.930  76.325  1.00 29.43           C  
ATOM    945  CD  LYS A 125      35.616  48.455  74.903  1.00 35.18           C  
ATOM    946  CE  LYS A 125      36.710  49.026  73.986  1.00 35.55           C  
ATOM    947  NZ  LYS A 125      36.982  50.477  74.320  1.00 38.14           N  
ATOM    948  N   LEU A 126      33.538  47.241  80.023  1.00 19.47           N  
ATOM    949  CA  LEU A 126      32.456  47.059  81.007  1.00 20.68           C  
ATOM    950  C   LEU A 126      32.817  47.553  82.406  1.00 18.81           C  
ATOM    951  O   LEU A 126      31.995  48.146  83.063  1.00 18.16           O  
ATOM    952  CB  LEU A 126      32.013  45.611  81.066  1.00 23.41           C  
ATOM    953  CG  LEU A 126      31.312  45.122  79.786  1.00 25.05           C  
ATOM    954  CD1 LEU A 126      30.820  43.714  80.013  1.00 28.79           C  
ATOM    955  CD2 LEU A 126      30.180  46.025  79.358  1.00 27.78           C  
ATOM    956  N   ASP A 127      34.039  47.283  82.861  1.00 19.05           N  
ATOM    957  CA  ASP A 127      34.492  47.813  84.124  1.00 20.05           C  
ATOM    958  C   ASP A 127      34.376  49.369  84.134  1.00 15.88           C  
ATOM    959  O   ASP A 127      33.849  49.940  85.075  1.00 17.78           O  
ATOM    960  CB  ASP A 127      35.934  47.425  84.393  1.00 19.98           C  
ATOM    961  CG  ASP A 127      36.495  48.140  85.593  1.00 20.96           C  
ATOM    962  OD1 ASP A 127      36.043  47.868  86.739  1.00 20.41           O  
ATOM    963  OD2 ASP A 127      37.363  48.996  85.381  1.00 20.04           O  
ATOM    964  N   MET A 128      34.854  50.004  83.068  1.00 15.98           N  
ATOM    965  CA  MET A 128      34.818  51.471  82.889  1.00 18.58           C  
ATOM    966  C   MET A 128      33.429  52.084  82.900  1.00 16.58           C  
ATOM    967  O   MET A 128      33.212  53.075  83.544  1.00 18.85           O  
ATOM    968  CB  MET A 128      35.530  51.887  81.605  1.00 18.48           C  
ATOM    969  CG  MET A 128      35.830  53.370  81.582  1.00 26.10           C  
ATOM    970  SD  MET A 128      36.738  53.965  80.113  1.00 32.51           S  
ATOM    971  CE  MET A 128      35.290  53.933  78.996  1.00 35.88           C  
ATOM    972  N   ILE A 129      32.497  51.467  82.190  1.00 18.86           N  
ATOM    973  CA  ILE A 129      31.184  52.000  82.026  1.00 19.17           C  
ATOM    974  C   ILE A 129      30.429  51.843  83.309  1.00 20.27           C  
ATOM    975  O   ILE A 129      29.669  52.742  83.709  1.00 21.28           O  
ATOM    976  CB  ILE A 129      30.376  51.271  80.889  1.00 23.31           C  
ATOM    977  CG1 ILE A 129      31.066  51.412  79.536  1.00 24.81           C  
ATOM    978  CG2 ILE A 129      28.960  51.864  80.767  1.00 23.84           C  
ATOM    979  CD1 ILE A 129      30.483  50.461  78.517  1.00 26.24           C  
ATOM    980  N   ILE A 130      30.606  50.698  83.946  1.00 17.51           N  
ATOM    981  CA  ILE A 130      29.956  50.443  85.216  1.00 19.13           C  
ATOM    982  C   ILE A 130      30.554  51.336  86.309  1.00 14.40           C  
ATOM    983  O   ILE A 130      29.817  51.823  87.148  1.00 16.54           O  
ATOM    984  CB  ILE A 130      30.005  48.948  85.613  1.00 21.72           C  
ATOM    985  CG1 ILE A 130      29.180  48.102  84.643  1.00 22.80           C  
ATOM    986  CG2 ILE A 130      29.442  48.752  87.019  1.00 20.49           C  
ATOM    987  CD1 ILE A 130      29.451  46.543  84.736  1.00 22.85           C  
ATOM    988  N   GLN A 131      31.870  51.558  86.261  1.00 13.96           N  
ATOM    989  CA  GLN A 131      32.528  52.488  87.165  1.00 15.53           C  
ATOM    990  C   GLN A 131      32.002  53.906  87.006  1.00 16.09           C  
ATOM    991  O   GLN A 131      31.831  54.606  87.993  1.00 13.01           O  
ATOM    992  CB  GLN A 131      34.052  52.461  86.990  1.00 13.48           C  
ATOM    993  CG  GLN A 131      34.804  53.272  88.079  1.00 13.65           C  
ATOM    994  CD  GLN A 131      34.517  52.745  89.461  1.00 16.81           C  
ATOM    995  OE1 GLN A 131      34.841  51.589  89.769  1.00 18.13           O  
ATOM    996  NE2 GLN A 131      33.868  53.568  90.298  1.00 10.15           N  
ATOM    997  N   ALA A 132      31.682  54.293  85.769  1.00 17.81           N  
ATOM    998  CA  ALA A 132      31.108  55.610  85.476  1.00 19.19           C  
ATOM    999  C   ALA A 132      29.744  55.774  86.121  1.00 18.72           C  
ATOM   1000  O   ALA A 132      29.503  56.786  86.793  1.00 18.69           O  
ATOM   1001  CB  ALA A 132      31.054  55.875  83.969  1.00 17.55           C  
ATOM   1002  N   TYR A 133      28.912  54.750  86.010  1.00 17.96           N  
ATOM   1003  CA  TYR A 133      27.635  54.691  86.721  1.00 18.16           C  
ATOM   1004  C   TYR A 133      27.816  54.770  88.270  1.00 20.63           C  
ATOM   1005  O   TYR A 133      27.133  55.509  88.955  1.00 19.99           O  
ATOM   1006  CB  TYR A 133      26.890  53.416  86.289  1.00 23.73           C  
ATOM   1007  CG  TYR A 133      25.794  52.999  87.227  1.00 23.61           C  
ATOM   1008  CD1 TYR A 133      24.523  53.597  87.165  1.00 24.05           C  
ATOM   1009  CD2 TYR A 133      26.027  52.035  88.189  1.00 22.68           C  
ATOM   1010  CE1 TYR A 133      23.525  53.235  88.036  1.00 24.40           C  
ATOM   1011  CE2 TYR A 133      25.020  51.656  89.089  1.00 26.98           C  
ATOM   1012  CZ  TYR A 133      23.777  52.252  89.001  1.00 25.86           C  
ATOM   1013  OH  TYR A 133      22.798  51.881  89.884  1.00 28.25           O  
ATOM   1014  N   GLU A 134      28.777  54.027  88.813  1.00 24.16           N  
ATOM   1015  CA  GLU A 134      29.064  54.087  90.252  1.00 20.07           C  
ATOM   1016  C   GLU A 134      29.518  55.477  90.643  1.00 17.90           C  
ATOM   1017  O   GLU A 134      29.106  55.953  91.671  1.00 14.17           O  
ATOM   1018  CB  GLU A 134      30.127  53.060  90.644  1.00 22.80           C  
ATOM   1019  CG  GLU A 134      29.604  51.627  90.442  1.00 25.13           C  
ATOM   1020  CD  GLU A 134      30.650  50.589  90.620  1.00 23.14           C  
ATOM   1021  OE1 GLU A 134      30.930  50.176  91.757  1.00 34.53           O  
ATOM   1022  OE2 GLU A 134      31.214  50.187  89.633  1.00 25.86           O  
ATOM   1023  N   TYR A 135      30.354  56.138  89.827  1.00 16.76           N  
ATOM   1024  CA  TYR A 135      30.821  57.485  90.183  1.00 13.64           C  
ATOM   1025  C   TYR A 135      29.703  58.520  90.080  1.00 15.57           C  
ATOM   1026  O   TYR A 135      29.663  59.413  90.869  1.00 17.97           O  
ATOM   1027  CB  TYR A 135      32.078  57.929  89.416  1.00 13.17           C  
ATOM   1028  CG  TYR A 135      33.361  57.300  89.910  1.00 14.23           C  
ATOM   1029  CD1 TYR A 135      33.594  57.061  91.297  1.00 14.38           C  
ATOM   1030  CD2 TYR A 135      34.359  56.955  89.006  1.00 12.01           C  
ATOM   1031  CE1 TYR A 135      34.821  56.433  91.743  1.00 13.22           C  
ATOM   1032  CE2 TYR A 135      35.561  56.405  89.425  1.00 14.43           C  
ATOM   1033  CZ  TYR A 135      35.787  56.129  90.792  1.00 14.05           C  
ATOM   1034  OH  TYR A 135      36.977  55.557  91.101  1.00 13.38           O  
ATOM   1035  N   GLU A 136      28.776  58.343  89.151  1.00 18.64           N  
ATOM   1036  CA  GLU A 136      27.562  59.146  89.095  1.00 21.20           C  
ATOM   1037  C   GLU A 136      26.665  59.016  90.339  1.00 19.41           C  
ATOM   1038  O   GLU A 136      26.142  60.003  90.805  1.00 22.25           O  
ATOM   1039  CB  GLU A 136      26.761  58.795  87.861  1.00 20.85           C  
ATOM   1040  CG  GLU A 136      27.455  59.225  86.566  1.00 30.46           C  
ATOM   1041  CD  GLU A 136      26.739  58.751  85.293  1.00 34.40           C  
ATOM   1042  OE1 GLU A 136      25.667  58.104  85.379  1.00 42.87           O  
ATOM   1043  OE2 GLU A 136      27.259  59.031  84.193  1.00 44.05           O  
ATOM   1044  N   LEU A 137      26.512  57.813  90.867  1.00 17.30           N  
ATOM   1045  CA  LEU A 137      25.813  57.604  92.119  1.00 21.28           C  
ATOM   1046  C   LEU A 137      26.402  58.398  93.324  1.00 22.23           C  
ATOM   1047  O   LEU A 137      25.687  58.739  94.243  1.00 22.04           O  
ATOM   1048  CB  LEU A 137      25.791  56.100  92.432  1.00 25.75           C  
ATOM   1049  CG  LEU A 137      24.891  55.161  91.599  1.00 24.71           C  
ATOM   1050  CD1 LEU A 137      24.949  53.743  92.213  1.00 25.95           C  
ATOM   1051  CD2 LEU A 137      23.454  55.660  91.610  1.00 25.11           C  
ATOM   1052  N   SER A 138      27.697  58.662  93.300  1.00 22.33           N  
ATOM   1053  CA  SER A 138      28.400  59.388  94.364  1.00 23.94           C  
ATOM   1054  C   SER A 138      28.571  60.856  94.014  1.00 25.22           C  
ATOM   1055  O   SER A 138      29.168  61.593  94.784  1.00 23.86           O  
ATOM   1056  CB  SER A 138      29.811  58.783  94.598  1.00 22.83           C  
ATOM   1057  OG  SER A 138      29.650  57.445  95.029  1.00 23.70           O  
ATOM   1058  N   GLY A 139      28.081  61.270  92.834  1.00 24.66           N  
ATOM   1059  CA  GLY A 139      27.871  62.665  92.558  1.00 24.87           C  
ATOM   1060  C   GLY A 139      28.343  63.243  91.246  1.00 26.33           C  
ATOM   1061  O   GLY A 139      27.977  64.387  90.922  1.00 27.61           O  
ATOM   1062  N   ALA A 140      29.117  62.487  90.466  1.00 20.54           N  
ATOM   1063  CA  ALA A 140      29.624  63.024  89.194  1.00 21.17           C  
ATOM   1064  C   ALA A 140      28.473  63.265  88.191  1.00 22.85           C  
ATOM   1065  O   ALA A 140      27.642  62.390  87.997  1.00 25.51           O  
ATOM   1066  CB  ALA A 140      30.635  62.101  88.609  1.00 15.92           C  
ATOM   1067  N   LYS A 141      28.452  64.445  87.563  1.00 25.07           N  
ATOM   1068  CA  LYS A 141      27.454  64.788  86.545  1.00 27.60           C  
ATOM   1069  C   LYS A 141      28.047  64.917  85.133  1.00 25.59           C  
ATOM   1070  O   LYS A 141      27.345  65.296  84.221  1.00 21.40           O  
ATOM   1071  CB  LYS A 141      26.746  66.115  86.915  1.00 29.63           C  
ATOM   1072  CG  LYS A 141      25.837  66.013  88.146  1.00 33.44           C  
ATOM   1073  CD  LYS A 141      25.116  67.354  88.425  1.00 35.75           C  
ATOM   1074  N   ASN A 142      29.334  64.605  84.983  1.00 22.44           N  
ATOM   1075  CA  ASN A 142      30.122  64.939  83.805  1.00 18.07           C  
ATOM   1076  C   ASN A 142      30.819  63.734  83.136  1.00 17.00           C  
ATOM   1077  O   ASN A 142      31.832  63.883  82.474  1.00 23.92           O  
ATOM   1078  CB  ASN A 142      31.147  66.019  84.183  1.00 20.47           C  
ATOM   1079  CG  ASN A 142      32.148  65.581  85.324  1.00 18.72           C  
ATOM   1080  OD1 ASN A 142      31.965  64.585  86.050  1.00 22.35           O  
ATOM   1081  ND2 ASN A 142      33.203  66.352  85.460  1.00 18.43           N  
ATOM   1082  N   LEU A 143      30.250  62.550  83.303  1.00 18.60           N  
ATOM   1083  CA  LEU A 143      30.834  61.300  82.837  1.00 23.40           C  
ATOM   1084  C   LEU A 143      29.993  60.585  81.741  1.00 28.99           C  
ATOM   1085  O   LEU A 143      30.226  59.421  81.473  1.00 30.96           O  
ATOM   1086  CB  LEU A 143      30.947  60.318  84.026  1.00 21.27           C  
ATOM   1087  CG  LEU A 143      31.662  60.802  85.285  1.00 19.34           C  
ATOM   1088  CD1 LEU A 143      31.849  59.603  86.214  1.00 19.13           C  
ATOM   1089  CD2 LEU A 143      33.036  61.437  84.957  1.00 20.86           C  
ATOM   1090  N   SER A 144      29.030  61.266  81.116  1.00 32.28           N  
ATOM   1091  CA  SER A 144      28.148  60.629  80.107  1.00 34.21           C  
ATOM   1092  C   SER A 144      28.896  60.064  78.890  1.00 33.32           C  
ATOM   1093  O   SER A 144      28.502  59.057  78.327  1.00 31.25           O  
ATOM   1094  CB  SER A 144      27.097  61.635  79.613  1.00 37.56           C  
ATOM   1095  OG  SER A 144      27.735  62.653  78.842  1.00 37.45           O  
ATOM   1096  N   GLU A 145      29.961  60.733  78.488  1.00 34.93           N  
ATOM   1097  CA  GLU A 145      30.778  60.279  77.390  1.00 38.78           C  
ATOM   1098  C   GLU A 145      31.302  58.838  77.572  1.00 38.31           C  
ATOM   1099  O   GLU A 145      31.569  58.150  76.563  1.00 31.22           O  
ATOM   1100  CB  GLU A 145      31.987  61.210  77.213  1.00 43.81           C  
ATOM   1101  CG  GLU A 145      32.916  61.159  78.412  1.00 49.71           C  
ATOM   1102  CD  GLU A 145      34.099  62.068  78.307  1.00 55.10           C  
ATOM   1103  OE1 GLU A 145      35.091  61.697  77.621  1.00 63.42           O  
ATOM   1104  OE2 GLU A 145      34.051  63.137  78.938  1.00 52.87           O  
ATOM   1105  N   PHE A 146      31.488  58.395  78.830  1.00 33.10           N  
ATOM   1106  CA  PHE A 146      32.141  57.106  79.085  1.00 32.42           C  
ATOM   1107  C   PHE A 146      31.243  55.960  78.646  1.00 31.82           C  
ATOM   1108  O   PHE A 146      31.709  54.871  78.344  1.00 36.04           O  
ATOM   1109  CB  PHE A 146      32.557  56.970  80.560  1.00 34.39           C  
ATOM   1110  CG  PHE A 146      33.759  57.783  80.909  1.00 33.45           C  
ATOM   1111  CD1 PHE A 146      35.013  57.381  80.526  1.00 35.27           C  
ATOM   1112  CD2 PHE A 146      33.633  58.990  81.573  1.00 33.88           C  
ATOM   1113  CE1 PHE A 146      36.130  58.176  80.829  1.00 38.38           C  
ATOM   1114  CE2 PHE A 146      34.739  59.754  81.884  1.00 31.99           C  
ATOM   1115  CZ  PHE A 146      35.968  59.360  81.524  1.00 35.13           C  
ATOM   1116  N   TRP A 147      29.954  56.242  78.573  1.00 32.42           N  
ATOM   1117  CA  TRP A 147      28.970  55.303  78.067  1.00 34.93           C  
ATOM   1118  C   TRP A 147      29.061  55.063  76.558  1.00 36.65           C  
ATOM   1119  O   TRP A 147      28.476  54.108  76.040  1.00 40.11           O  
ATOM   1120  CB  TRP A 147      27.600  55.840  78.406  1.00 36.51           C  
ATOM   1121  CG  TRP A 147      27.390  55.938  79.888  1.00 38.53           C  
ATOM   1122  CD1 TRP A 147      27.822  56.936  80.742  1.00 37.20           C  
ATOM   1123  CD2 TRP A 147      26.683  54.998  80.698  1.00 38.65           C  
ATOM   1124  NE1 TRP A 147      27.419  56.664  82.021  1.00 37.59           N  
ATOM   1125  CE2 TRP A 147      26.717  55.478  82.021  1.00 38.87           C  
ATOM   1126  CE3 TRP A 147      26.035  53.781  80.432  1.00 36.59           C  
ATOM   1127  CZ2 TRP A 147      26.131  54.783  83.071  1.00 37.06           C  
ATOM   1128  CZ3 TRP A 147      25.459  53.106  81.461  1.00 35.63           C  
ATOM   1129  CH2 TRP A 147      25.508  53.599  82.769  1.00 36.75           C  
ATOM   1130  N   ASN A 148      29.784  55.932  75.849  1.00 38.15           N  
ATOM   1131  CA  ASN A 148      29.956  55.779  74.413  1.00 37.77           C  
ATOM   1132  C   ASN A 148      30.750  54.509  74.093  1.00 38.73           C  
ATOM   1133  O   ASN A 148      30.730  54.036  72.950  1.00 40.26           O  
ATOM   1134  CB  ASN A 148      30.634  57.027  73.787  1.00 33.55           C  
ATOM   1135  CG  ASN A 148      29.756  58.284  73.858  1.00 32.26           C  
ATOM   1136  OD1 ASN A 148      28.526  58.198  73.962  1.00 31.48           O  
ATOM   1137  ND2 ASN A 148      30.393  59.463  73.790  1.00 29.53           N  
ATOM   1138  N   ALA A 149      31.442  53.952  75.091  1.00 38.79           N  
ATOM   1139  CA  ALA A 149      32.179  52.703  74.889  1.00 36.85           C  
ATOM   1140  C   ALA A 149      31.240  51.504  74.646  1.00 34.54           C  
ATOM   1141  O   ALA A 149      31.676  50.522  74.074  1.00 35.60           O  
ATOM   1142  CB  ALA A 149      33.168  52.415  76.062  1.00 34.89           C  
ATOM   1143  N   LEU A 150      29.977  51.586  75.065  1.00 34.14           N  
ATOM   1144  CA  LEU A 150      28.990  50.568  74.677  1.00 39.03           C  
ATOM   1145  C   LEU A 150      28.985  50.364  73.150  1.00 42.77           C  
ATOM   1146  O   LEU A 150      28.955  49.218  72.675  1.00 41.35           O  
ATOM   1147  CB  LEU A 150      27.585  50.933  75.129  1.00 40.90           C  
ATOM   1148  CG  LEU A 150      27.138  50.560  76.527  1.00 43.67           C  
ATOM   1149  CD1 LEU A 150      25.776  51.205  76.856  1.00 44.97           C  
ATOM   1150  CD2 LEU A 150      27.060  49.055  76.687  1.00 45.24           C  
ATOM   1151  N   GLU A 151      29.047  51.466  72.392  1.00 42.58           N  
ATOM   1152  CA  GLU A 151      29.038  51.403  70.925  1.00 46.14           C  
ATOM   1153  C   GLU A 151      30.216  50.599  70.375  1.00 46.71           C  
ATOM   1154  O   GLU A 151      30.102  49.971  69.335  1.00 47.71           O  
ATOM   1155  CB  GLU A 151      29.089  52.810  70.310  1.00 46.83           C  
ATOM   1156  CG  GLU A 151      27.970  53.778  70.739  1.00 48.37           C  
ATOM   1157  CD  GLU A 151      28.298  55.266  70.439  1.00 49.31           C  
ATOM   1158  OE1 GLU A 151      29.483  55.584  70.126  1.00 45.26           O  
ATOM   1159  OE2 GLU A 151      27.362  56.117  70.531  1.00 49.27           O  
ATOM   1160  N   ASP A 152      31.355  50.643  71.065  1.00 50.09           N  
ATOM   1161  CA  ASP A 152      32.573  49.943  70.617  1.00 51.01           C  
ATOM   1162  C   ASP A 152      32.489  48.392  70.763  1.00 48.77           C  
ATOM   1163  O   ASP A 152      33.286  47.665  70.172  1.00 43.11           O  
ATOM   1164  CB  ASP A 152      33.816  50.407  71.403  1.00 55.11           C  
ATOM   1165  CG  ASP A 152      33.964  51.926  71.495  1.00 58.30           C  
ATOM   1166  OD1 ASP A 152      33.173  52.695  70.870  1.00 57.48           O  
ATOM   1167  OD2 ASP A 152      34.910  52.337  72.230  1.00 59.29           O  
ATOM   1168  N   LEU A 153      31.530  47.904  71.557  1.00 50.88           N  
ATOM   1169  CA  LEU A 153      31.400  46.465  71.853  1.00 49.76           C  
ATOM   1170  C   LEU A 153      30.781  45.658  70.737  1.00 52.64           C  
ATOM   1171  O   LEU A 153      31.205  44.521  70.491  1.00 50.32           O  
ATOM   1172  CB  LEU A 153      30.574  46.264  73.122  1.00 47.79           C  
ATOM   1173  CG  LEU A 153      31.173  46.950  74.340  1.00 42.66           C  
ATOM   1174  CD1 LEU A 153      30.412  46.538  75.548  1.00 43.24           C  
ATOM   1175  CD2 LEU A 153      32.631  46.600  74.436  1.00 41.34           C  
ATOM   1176  N   GLU A 154      29.778  46.243  70.079  1.00 54.09           N  
ATOM   1177  CA  GLU A 154      29.094  45.615  68.953  1.00 54.13           C  
ATOM   1178  C   GLU A 154      30.063  45.252  67.840  1.00 53.29           C  
ATOM   1179  O   GLU A 154      29.856  44.273  67.094  1.00 57.53           O  
ATOM   1180  CB  GLU A 154      28.023  46.562  68.404  1.00 56.89           C  
ATOM   1181  N   LYS A 155      31.134  46.022  67.734  1.00 47.13           N  
ATOM   1182  CA  LYS A 155      32.142  45.773  66.718  1.00 47.67           C  
ATOM   1183  C   LYS A 155      32.991  44.495  66.996  1.00 46.33           C  
ATOM   1184  O   LYS A 155      33.732  44.027  66.128  1.00 50.56           O  
ATOM   1185  CB  LYS A 155      33.029  47.015  66.589  1.00 49.18           C  
ATOM   1186  CG  LYS A 155      32.230  48.352  66.355  1.00 49.35           C  
ATOM   1187  CD  LYS A 155      33.027  49.580  66.827  1.00 51.02           C  
ATOM   1188  N   LEU A 156      32.886  43.956  68.211  1.00 41.62           N  
ATOM   1189  CA  LEU A 156      33.555  42.715  68.601  1.00 38.74           C  
ATOM   1190  C   LEU A 156      32.549  41.584  68.419  1.00 34.97           C  
ATOM   1191  O   LEU A 156      31.511  41.582  69.079  1.00 34.44           O  
ATOM   1192  CB  LEU A 156      34.043  42.806  70.070  1.00 34.76           C  
ATOM   1193  CG  LEU A 156      34.931  44.028  70.334  1.00 35.43           C  
ATOM   1194  CD1 LEU A 156      35.232  44.243  71.821  1.00 36.02           C  
ATOM   1195  CD2 LEU A 156      36.231  43.941  69.525  1.00 32.28           C  
ATOM   1196  N   GLU A 157      32.831  40.646  67.510  1.00 33.54           N  
ATOM   1197  CA  GLU A 157      31.925  39.517  67.269  1.00 33.32           C  
ATOM   1198  C   GLU A 157      31.392  38.822  68.518  1.00 29.36           C  
ATOM   1199  O   GLU A 157      30.230  38.477  68.566  1.00 30.20           O  
ATOM   1200  CB  GLU A 157      32.581  38.432  66.399  1.00 37.57           C  
ATOM   1201  CG  GLU A 157      32.524  38.640  64.900  1.00 40.44           C  
ATOM   1202  CD  GLU A 157      31.190  39.156  64.368  1.00 42.91           C  
ATOM   1203  OE1 GLU A 157      30.066  38.667  64.750  1.00 46.69           O  
ATOM   1204  OE2 GLU A 157      31.287  40.051  63.511  1.00 48.15           O  
ATOM   1205  N   ILE A 158      32.258  38.582  69.502  1.00 33.16           N  
ATOM   1206  CA  ILE A 158      31.913  37.723  70.658  1.00 29.70           C  
ATOM   1207  C   ILE A 158      30.781  38.338  71.518  1.00 27.96           C  
ATOM   1208  O   ILE A 158      30.101  37.638  72.253  1.00 25.50           O  
ATOM   1209  CB  ILE A 158      33.221  37.297  71.467  1.00 33.14           C  
ATOM   1210  CG1 ILE A 158      33.084  35.874  72.060  1.00 35.36           C  
ATOM   1211  CG2 ILE A 158      33.617  38.281  72.548  1.00 30.45           C  
ATOM   1212  N   SER A 159      30.552  39.639  71.361  1.00 29.14           N  
ATOM   1213  CA  SER A 159      29.482  40.351  72.081  1.00 34.58           C  
ATOM   1214  C   SER A 159      28.059  39.923  71.700  1.00 33.82           C  
ATOM   1215  O   SER A 159      27.112  40.193  72.429  1.00 33.83           O  
ATOM   1216  CB  SER A 159      29.614  41.876  71.880  1.00 33.15           C  
ATOM   1217  OG  SER A 159      29.311  42.237  70.549  1.00 38.34           O  
ATOM   1218  N   ARG A 160      27.893  39.264  70.564  1.00 34.83           N  
ATOM   1219  CA  ARG A 160      26.581  38.712  70.234  1.00 38.36           C  
ATOM   1220  C   ARG A 160      26.182  37.569  71.182  1.00 35.24           C  
ATOM   1221  O   ARG A 160      25.005  37.285  71.355  1.00 37.05           O  
ATOM   1222  CB  ARG A 160      26.540  38.274  68.772  1.00 42.71           C  
ATOM   1223  CG  ARG A 160      27.317  37.055  68.488  1.00 45.57           C  
ATOM   1224  CD  ARG A 160      27.620  36.938  67.003  1.00 50.61           C  
ATOM   1225  NE  ARG A 160      27.542  35.538  66.605  1.00 51.18           N  
ATOM   1226  CZ  ARG A 160      28.271  34.962  65.663  1.00 51.46           C  
ATOM   1227  NH1 ARG A 160      29.177  35.652  64.959  1.00 51.99           N  
ATOM   1228  NH2 ARG A 160      28.084  33.669  65.440  1.00 52.64           N  
ATOM   1229  N   TYR A 161      27.172  36.966  71.832  1.00 37.20           N  
ATOM   1230  CA  TYR A 161      26.948  35.962  72.901  1.00 36.29           C  
ATOM   1231  C   TYR A 161      26.831  36.546  74.313  1.00 35.56           C  
ATOM   1232  O   TYR A 161      26.681  35.797  75.280  1.00 37.94           O  
ATOM   1233  CB  TYR A 161      28.066  34.934  72.851  1.00 36.25           C  
ATOM   1234  CG  TYR A 161      27.978  34.161  71.573  1.00 35.70           C  
ATOM   1235  CD1 TYR A 161      27.090  33.095  71.462  1.00 37.51           C  
ATOM   1236  CD2 TYR A 161      28.718  34.522  70.468  1.00 33.64           C  
ATOM   1237  CE1 TYR A 161      26.966  32.389  70.287  1.00 37.76           C  
ATOM   1238  CE2 TYR A 161      28.611  33.823  69.297  1.00 36.77           C  
ATOM   1239  CZ  TYR A 161      27.717  32.744  69.220  1.00 37.76           C  
ATOM   1240  OH  TYR A 161      27.562  32.035  68.054  1.00 40.31           O  
ATOM   1241  N   LEU A 162      26.854  37.880  74.416  1.00 35.52           N  
ATOM   1242  CA  LEU A 162      26.891  38.567  75.699  1.00 36.71           C  
ATOM   1243  C   LEU A 162      25.869  39.663  75.752  1.00 39.88           C  
ATOM   1244  O   LEU A 162      26.059  40.643  76.432  1.00 34.60           O  
ATOM   1245  CB  LEU A 162      28.279  39.133  75.928  1.00 34.36           C  
ATOM   1246  CG  LEU A 162      29.355  38.071  76.144  1.00 32.30           C  
ATOM   1247  CD1 LEU A 162      30.726  38.680  76.206  1.00 33.32           C  
ATOM   1248  CD2 LEU A 162      29.060  37.274  77.404  1.00 31.06           C  
ATOM   1249  N   ARG A 163      24.763  39.464  75.044  1.00 45.77           N  
ATOM   1250  CA  ARG A 163      23.751  40.495  74.880  1.00 50.32           C  
ATOM   1251  C   ARG A 163      22.970  40.818  76.159  1.00 47.24           C  
ATOM   1252  O   ARG A 163      22.611  41.961  76.377  1.00 41.97           O  
ATOM   1253  CB  ARG A 163      22.806  40.131  73.719  1.00 55.21           C  
ATOM   1254  CG  ARG A 163      23.265  40.787  72.415  1.00 59.09           C  
ATOM   1255  CD  ARG A 163      22.636  40.171  71.206  1.00 62.80           C  
ATOM   1256  NE  ARG A 163      23.067  40.855  69.982  1.00 63.52           N  
ATOM   1257  CZ  ARG A 163      23.119  40.290  68.773  1.00 66.09           C  
ATOM   1258  NH1 ARG A 163      22.768  39.005  68.597  1.00 67.09           N  
ATOM   1259  NH2 ARG A 163      23.534  41.006  67.731  1.00 65.11           N  
ATOM   1260  N   GLU A 164      22.753  39.815  77.001  1.00 48.98           N  
ATOM   1261  CA  GLU A 164      22.001  39.992  78.247  1.00 52.27           C  
ATOM   1262  C   GLU A 164      22.733  40.908  79.252  1.00 49.40           C  
ATOM   1263  O   GLU A 164      22.125  41.825  79.800  1.00 50.13           O  
ATOM   1264  CB  GLU A 164      21.687  38.632  78.892  1.00 57.77           C  
ATOM   1265  CG  GLU A 164      20.979  37.622  77.949  1.00 61.49           C  
ATOM   1266  CD  GLU A 164      21.940  36.650  77.218  1.00 64.00           C  
ATOM   1267  OE1 GLU A 164      23.074  37.052  76.827  1.00 63.47           O  
ATOM   1268  OE2 GLU A 164      21.534  35.477  77.035  1.00 65.32           O  
ATOM   1269  N   ILE A 165      24.031  40.682  79.466  1.00 46.42           N  
ATOM   1270  CA  ILE A 165      24.834  41.573  80.320  1.00 43.33           C  
ATOM   1271  C   ILE A 165      24.971  42.963  79.699  1.00 41.03           C  
ATOM   1272  O   ILE A 165      24.859  43.946  80.409  1.00 36.47           O  
ATOM   1273  CB  ILE A 165      26.255  40.985  80.671  1.00 46.38           C  
ATOM   1274  CG1 ILE A 165      26.864  41.711  81.880  1.00 48.71           C  
ATOM   1275  CG2 ILE A 165      27.236  41.063  79.494  1.00 44.54           C  
ATOM   1276  N   ILE A 166      25.182  43.057  78.381  1.00 38.70           N  
ATOM   1277  CA  ILE A 166      25.332  44.367  77.735  1.00 41.52           C  
ATOM   1278  C   ILE A 166      24.047  45.201  77.853  1.00 44.76           C  
ATOM   1279  O   ILE A 166      24.110  46.435  77.942  1.00 48.09           O  
ATOM   1280  CB  ILE A 166      25.735  44.262  76.229  1.00 42.77           C  
ATOM   1281  CG1 ILE A 166      27.131  43.648  76.077  1.00 41.68           C  
ATOM   1282  CG2 ILE A 166      25.707  45.653  75.553  1.00 43.44           C  
ATOM   1283  CD1 ILE A 166      27.399  43.066  74.688  1.00 39.93           C  
ATOM   1284  N   GLU A 167      22.898  44.519  77.848  1.00 45.82           N  
ATOM   1285  CA  GLU A 167      21.586  45.163  78.038  1.00 46.42           C  
ATOM   1286  C   GLU A 167      21.373  45.603  79.508  1.00 44.58           C  
ATOM   1287  O   GLU A 167      20.820  46.652  79.743  1.00 41.24           O  
ATOM   1288  CB  GLU A 167      20.435  44.247  77.567  1.00 42.60           C  
ATOM   1289  N   GLU A 168      21.805  44.790  80.478  1.00 45.66           N  
ATOM   1290  CA  GLU A 168      21.764  45.187  81.891  1.00 44.62           C  
ATOM   1291  C   GLU A 168      22.535  46.488  82.082  1.00 43.29           C  
ATOM   1292  O   GLU A 168      22.076  47.386  82.783  1.00 44.71           O  
ATOM   1293  CB  GLU A 168      22.358  44.110  82.806  1.00 44.18           C  
ATOM   1294  CG  GLU A 168      21.522  42.863  82.986  1.00 44.94           C  
ATOM   1295  CD  GLU A 168      22.296  41.718  83.679  1.00 47.50           C  
ATOM   1296  OE1 GLU A 168      23.009  41.975  84.665  1.00 43.70           O  
ATOM   1297  OE2 GLU A 168      22.180  40.545  83.243  1.00 52.11           O  
ATOM   1298  N   VAL A 169      23.692  46.590  81.428  1.00 42.89           N  
ATOM   1299  CA  VAL A 169      24.578  47.748  81.576  1.00 43.42           C  
ATOM   1300  C   VAL A 169      23.940  49.002  80.950  1.00 47.80           C  
ATOM   1301  O   VAL A 169      23.974  50.092  81.546  1.00 48.12           O  
ATOM   1302  CB  VAL A 169      26.017  47.457  81.017  1.00 37.69           C  
ATOM   1303  CG1 VAL A 169      26.846  48.709  80.933  1.00 35.50           C  
ATOM   1304  CG2 VAL A 169      26.717  46.436  81.883  1.00 37.17           C  
ATOM   1305  N   ARG A 170      23.352  48.832  79.770  1.00 52.04           N  
ATOM   1306  CA  ARG A 170      22.571  49.886  79.130  1.00 54.82           C  
ATOM   1307  C   ARG A 170      21.426  50.349  80.049  1.00 54.03           C  
ATOM   1308  O   ARG A 170      21.179  51.542  80.175  1.00 53.97           O  
ATOM   1309  CB  ARG A 170      22.027  49.410  77.757  1.00 56.58           C  
ATOM   1310  CG  ARG A 170      21.623  50.573  76.818  1.00 58.31           C  
ATOM   1311  CD  ARG A 170      21.425  50.149  75.357  1.00 58.72           C  
ATOM   1312  NE  ARG A 170      22.684  50.129  74.582  1.00 61.17           N  
ATOM   1313  CZ  ARG A 170      23.208  49.058  73.957  1.00 59.89           C  
ATOM   1314  NH1 ARG A 170      22.595  47.875  73.981  1.00 59.26           N  
ATOM   1315  NH2 ARG A 170      24.358  49.176  73.290  1.00 58.26           N  
ATOM   1316  N   ARG A 171      20.764  49.395  80.709  1.00 55.41           N  
ATOM   1317  CA  ARG A 171      19.634  49.676  81.629  1.00 55.56           C  
ATOM   1318  C   ARG A 171      19.986  50.583  82.842  1.00 56.24           C  
ATOM   1319  O   ARG A 171      19.093  51.155  83.476  1.00 55.34           O  
ATOM   1320  CB  ARG A 171      18.988  48.362  82.118  1.00 54.98           C  
ATOM   1321  CG  ARG A 171      17.689  48.005  81.394  1.00 54.66           C  
ATOM   1322  N   LEU A 172      21.273  50.710  83.157  1.00 54.76           N  
ATOM   1323  CA  LEU A 172      21.722  51.651  84.186  1.00 53.65           C  
ATOM   1324  C   LEU A 172      21.556  53.083  83.642  1.00 53.47           C  
ATOM   1325  O   LEU A 172      22.308  53.987  83.983  1.00 52.37           O  
ATOM   1326  CB  LEU A 172      23.184  51.365  84.581  1.00 49.94           C  
ATOM   1327  CG  LEU A 172      23.519  49.935  85.027  1.00 47.81           C  
ATOM   1328  CD1 LEU A 172      25.011  49.716  85.074  1.00 47.32           C  
ATOM   1329  CD2 LEU A 172      22.891  49.581  86.357  1.00 47.46           C  
TER    1330      LEU A 172                                                      
END
MOLECULE T0470_2_100.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
END
