
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  207 ( 1618),  selected  207 , name 2i0m_A
# Molecule2: number of CA atoms   91 (  736),  selected   91 , name T0470_112_214.pdb
# PARAMETERS: 2i0m_A.T0470_112_214.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q     4_A      S     112          4.814
LGA    F     5_A      I     113          2.757
LGA    D     6_A      E     114          1.673
LGA    L     7_A      G     115          2.878
LGA    E     8_A      K     116          2.655
LGA    L     9_A      L     117          1.266
LGA    H    10_A      V     118          1.768
LGA    E    11_A      Q     119          2.161
LGA    L    12_A      D     120          1.692
LGA    E    13_A      A     121          1.161
LGA    Q    14_A      D     122          1.208
LGA    S    15_A      R     123          1.332
LGA    F    16_A      L     124          1.175
LGA    L    17_A      D     125          1.775
LGA    G    18_A      A     126          2.783
LGA    L    19_A      L     127          2.741
LGA    G    20_A      G     128          3.784
LGA    Q    21_A      A     129           #
LGA    L    22_A      I     130           #
LGA    V    23_A      G     131          2.858
LGA    L    24_A      I     132          4.136
LGA    E    25_A      A     133          1.635
LGA    T    26_A      -       -           -
LGA    A    27_A      -       -           -
LGA    S    28_A      -       -           -
LGA    K    29_A      R     134           #
LGA    A    30_A      T     135           -
LGA    -       -      F     136           -
LGA    L    31_A      A     137           #
LGA    L    32_A      Y     138           -
LGA    A    33_A      G     139           -
LGA    L    34_A      G     140           -
LGA    A    35_A      A     141           -
LGA    S    36_A      K     142           -
LGA    K    37_A      G     143           -
LGA    D    38_A      R     144           -
LGA    K    39_A      -       -           -
LGA    E    40_A      L     145          4.491
LGA    M    41_A      M     146          1.360
LGA    A    42_A      Y     147          3.196
LGA    E    43_A      D     148          3.461
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    L    44_A      P     168          3.071
LGA    I    45_A      S     169          4.627
LGA    I    46_A      L     170          4.176
LGA    N    47_A      N     171          2.387
LGA    K    48_A      H     172          2.660
LGA    D    49_A      F     173          2.764
LGA    H    50_A      Y     174          1.512
LGA    A    51_A      E     175          3.597
LGA    -       -      K     176           -
LGA    I    52_A      L     177          2.307
LGA    N    53_A      L     178          2.054
LGA    Q    54_A      K     179          1.258
LGA    G    55_A      L     180          1.190
LGA    Q    56_A      K     181          1.326
LGA    S    57_A      D     182          1.406
LGA    A    58_A      L     183          1.843
LGA    I    59_A      M     184          1.955
LGA    E    60_A      -       -           -
LGA    L    61_A      -       -           -
LGA    T    62_A      N     185          3.336
LGA    C    63_A      T     186          3.596
LGA    A    64_A      -       -           -
LGA    R    65_A      -       -           -
LGA    L    66_A      -       -           -
LGA    L    67_A      -       -           -
LGA    A    68_A      -       -           -
LGA    L    69_A      -       -           -
LGA    P    72_A      -       -           -
LGA    Q    73_A      -       -           -
LGA    V    74_A      -       -           -
LGA    S    75_A      -       -           -
LGA    D    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    R    78_A      -       -           -
LGA    F    79_A      -       -           -
LGA    V    80_A      -       -           -
LGA    I    81_A      N     187          2.039
LGA    S    82_A      A     188          1.807
LGA    I    83_A      A     189          1.149
LGA    M    84_A      K     190          0.966
LGA    S    85_A      Q     191          1.379
LGA    S    86_A      E     192          1.330
LGA    C    87_A      A     193          0.675
LGA    S    88_A      E     194          1.169
LGA    D    89_A      V     195          1.397
LGA    L    90_A      R     196          1.324
LGA    E    91_A      H     197          1.462
LGA    R    92_A      R     198          1.223
LGA    M    93_A      Y     199          0.584
LGA    G    94_A      M     200          0.573
LGA    D    95_A      E     201          1.200
LGA    H    96_A      Q     202          1.887
LGA    M    97_A      F     203          1.920
LGA    A    98_A      I     204          1.102
LGA    G    99_A      E     205          1.681
LGA    I   100_A      Q     206          2.810
LGA    A   101_A      F     207          2.514
LGA    K   102_A      M     208          1.006
LGA    A   103_A      K     209          2.276
LGA    V   104_A      E     210          3.127
LGA    L   105_A      W     211          2.071
LGA    Q   106_A      N     212          1.023
LGA    L   107_A      A     213          2.936
LGA    K   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    N   110_A      -       -           -
LGA    Q   111_A      -       -           -
LGA    L   112_A      -       -           -
LGA    A   113_A      -       -           -
LGA    E   116_A      -       -           -
LGA    E   117_A      -       -           -
LGA    Q   118_A      -       -           -
LGA    L   119_A      -       -           -
LGA    H   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    M   122_A      -       -           -
LGA    G   123_A      -       -           -
LGA    K   124_A      -       -           -
LGA    L   125_A      -       -           -
LGA    S   126_A      -       -           -
LGA    L   127_A      -       -           -
LGA    S   128_A      -       -           -
LGA    M   129_A      -       -           -
LGA    L   130_A      -       -           -
LGA    A   131_A      -       -           -
LGA    D   132_A      -       -           -
LGA    L   133_A      -       -           -
LGA    L   134_A      -       -           -
LGA    V   135_A      -       -           -
LGA    A   136_A      -       -           -
LGA    F   137_A      -       -           -
LGA    P   138_A      -       -           -
LGA    L   139_A      -       -           -
LGA    H   140_A      -       -           -
LGA    Q   141_A      -       -           -
LGA    A   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    K   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    I   146_A      -       -           -
LGA    S   147_A      -       -           -
LGA    I   148_A      -       -           -
LGA    A   149_A      -       -           -
LGA    Q   150_A      -       -           -
LGA    K   151_A      -       -           -
LGA    D   152_A      -       -           -
LGA    E   153_A      -       -           -
LGA    Q   154_A      -       -           -
LGA    I   155_A      -       -           -
LGA    D   156_A      -       -           -
LGA    Q   157_A      -       -           -
LGA    Y   158_A      -       -           -
LGA    Y   159_A      -       -           -
LGA    Y   160_A      -       -           -
LGA    A   161_A      -       -           -
LGA    L   162_A      -       -           -
LGA    S   163_A      -       -           -
LGA    K   164_A      -       -           -
LGA    E   165_A      -       -           -
LGA    I   166_A      -       -           -
LGA    I   167_A      -       -           -
LGA    G   168_A      -       -           -
LGA    L   169_A      -       -           -
LGA    M   170_A      -       -           -
LGA    K   171_A      -       -           -
LGA    D   172_A      -       -           -
LGA    Q   173_A      -       -           -
LGA    E   174_A      -       -           -
LGA    S   176_A      -       -           -
LGA    I   177_A      -       -           -
LGA    P   178_A      -       -           -
LGA    N   179_A      -       -           -
LGA    G   180_A      -       -           -
LGA    T   181_A      -       -           -
LGA    Q   182_A      Q     214          2.343
LGA    Y   183_A      -       -           -
LGA    L   184_A      -       -           -
LGA    Y   185_A      -       -           -
LGA    I   186_A      -       -           -
LGA    I   187_A      -       -           -
LGA    G   188_A      -       -           -
LGA    H   189_A      -       -           -
LGA    L   190_A      -       -           -
LGA    E   191_A      -       -           -
LGA    R   192_A      -       -           -
LGA    F   193_A      -       -           -
LGA    A   194_A      -       -           -
LGA    D   195_A      -       -           -
LGA    Y   196_A      -       -           -
LGA    I   197_A      -       -           -
LGA    A   198_A      -       -           -
LGA    N   199_A      -       -           -
LGA    I   200_A      -       -           -
LGA    C   201_A      -       -           -
LGA    E   202_A      -       -           -
LGA    R   203_A      -       -           -
LGA    L   204_A      -       -           -
LGA    V   205_A      -       -           -
LGA    Y   206_A      -       -           -
LGA    L   207_A      -       -           -
LGA    E   208_A      -       -           -
LGA    T   209_A      -       -           -
LGA    G   210_A      -       -           -
LGA    E   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    V   213_A      -       -           -
LGA    D   214_A      -       -           -
LGA    L   215_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  207   91    5.0     70    2.36    10.00     56.359     2.848

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.562232 * X  +  -0.814785 * Y  +   0.141494 * Z  +  69.409302
  Y_new =   0.382398 * X  +  -0.407851 * Y  +  -0.829114 * Z  +  76.087532
  Z_new =   0.733258 * X  +  -0.412047 * Y  +   0.540879 * Z  +  50.569164 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.651017    2.490576  [ DEG:   -37.3005    142.6995 ]
  Theta =  -0.823101   -2.318492  [ DEG:   -47.1602   -132.8398 ]
  Phi   =   2.544319   -0.597274  [ DEG:   145.7787    -34.2213 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i0m_A                                        
REMARK     2: T0470_112_214.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i0m_A.T0470_112_214.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  207   91   5.0   70   2.36   10.00  56.359
REMARK  ---------------------------------------------------------- 
MOLECULE 2i0m_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   10-AUG-06   2I0M              
TITLE     CRYSTAL STRUCTURE OF THE PHOSPHATE TRANSPORT SYSTEM                   
TITLE    2 REGULATORY PROTEIN PHOU FROM STREPTOCOCCUS PNEUMONIAE                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHATE TRANSPORT SYSTEM PROTEIN PHOU;                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: TIGR4;                                                       
SOURCE   5 GENE: PHOU;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    PHOU, ZINC-BINDING PROTEIN, STRUCTURAL GENOMICS, PSI-2,               
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,H.LI,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER FOR               
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   19-SEP-06 2I0M    0                                                
JRNL        AUTH   R.ZHANG,H.LI,J.ABDULLAH,A.JOACHIMIAK                         
JRNL        TITL   CRYSTAL STRUCTURE OF THE PHOSPHATE TRANSPORT                 
JRNL        TITL 2 SYSTEM REGULATORY PROTEIN PHOU FROM STREPTOCOCCUS            
JRNL        TITL 3 PNEUMONIAE                                                   
JRNL        REF    TO BE PUBLISHED                            2006              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2I0M A    1   216  UNP    P0A3Y7   PHOU_STRPN       1    216             
SEQRES   1 A  216  MET ARG ASN GLN PHE ASP LEU GLU LEU HIS GLU LEU GLU          
SEQRES   2 A  216  GLN SER PHE LEU GLY LEU GLY GLN LEU VAL LEU GLU THR          
SEQRES   3 A  216  ALA SER LYS ALA LEU LEU ALA LEU ALA SER LYS ASP LYS          
SEQRES   4 A  216  GLU MET ALA GLU LEU ILE ILE ASN LYS ASP HIS ALA ILE          
SEQRES   5 A  216  ASN GLN GLY GLN SER ALA ILE GLU LEU THR CYS ALA ARG          
SEQRES   6 A  216  LEU LEU ALA LEU GLN GLN PRO GLN VAL SER ASP LEU ARG          
SEQRES   7 A  216  PHE VAL ILE SER ILE MET SER SER CYS SER ASP LEU GLU          
SEQRES   8 A  216  ARG MET GLY ASP HIS MET ALA GLY ILE ALA LYS ALA VAL          
SEQRES   9 A  216  LEU GLN LEU LYS GLU ASN GLN LEU ALA PRO ASP GLU GLU          
SEQRES  10 A  216  GLN LEU HIS GLN MET GLY LYS LEU SER LEU SER MET LEU          
SEQRES  11 A  216  ALA ASP LEU LEU VAL ALA PHE PRO LEU HIS GLN ALA SER          
SEQRES  12 A  216  LYS ALA ILE SER ILE ALA GLN LYS ASP GLU GLN ILE ASP          
SEQRES  13 A  216  GLN TYR TYR TYR ALA LEU SER LYS GLU ILE ILE GLY LEU          
SEQRES  14 A  216  MET LYS ASP GLN GLU THR SER ILE PRO ASN GLY THR GLN          
SEQRES  15 A  216  TYR LEU TYR ILE ILE GLY HIS LEU GLU ARG PHE ALA ASP          
SEQRES  16 A  216  TYR ILE ALA ASN ILE CYS GLU ARG LEU VAL TYR LEU GLU          
SEQRES  17 A  216  THR GLY GLU LEU VAL ASP LEU ASN                              
HET     ZN      1       1                                                       
HET     ZN      2       1                                                       
HET     ZN      3       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   2   ZN    3(ZN 2+)                                                     
FORMUL   5  HOH   *24(H2 O)                                                     
CRYST1   72.547   88.965   75.790  90.00  90.00  90.00 C 2 2 21      8          
ATOM      1  N   GLN A   4      44.426  34.321  72.109  1.00 50.71           N  
ATOM      2  CA  GLN A   4      43.827  35.357  71.217  1.00 51.06           C  
ATOM      3  C   GLN A   4      42.335  35.526  71.482  1.00 50.92           C  
ATOM      4  O   GLN A   4      41.871  36.638  71.757  1.00 51.19           O  
ATOM      5  CB  GLN A   4      44.110  35.040  69.736  1.00 51.33           C  
ATOM      6  CG  GLN A   4      43.236  35.789  68.702  1.00 52.53           C  
ATOM      7  CD  GLN A   4      43.344  37.322  68.764  1.00 54.08           C  
ATOM      8  OE1 GLN A   4      44.251  37.884  69.390  1.00 53.86           O  
ATOM      9  NE2 GLN A   4      42.407  38.000  68.101  1.00 54.53           N  
ATOM     10  N   PHE A   5      41.592  34.421  71.404  1.00 50.57           N  
ATOM     11  CA  PHE A   5      40.164  34.410  71.719  1.00 50.06           C  
ATOM     12  C   PHE A   5      39.943  34.697  73.204  1.00 49.60           C  
ATOM     13  O   PHE A   5      39.100  35.523  73.562  1.00 49.20           O  
ATOM     14  CB  PHE A   5      39.535  33.066  71.308  1.00 50.26           C  
ATOM     15  CG  PHE A   5      38.047  32.968  71.574  1.00 50.26           C  
ATOM     16  CD1 PHE A   5      37.158  33.889  71.022  1.00 50.13           C  
ATOM     17  CD2 PHE A   5      37.536  31.934  72.355  1.00 50.33           C  
ATOM     18  CE1 PHE A   5      35.788  33.789  71.256  1.00 49.89           C  
ATOM     19  CE2 PHE A   5      36.168  31.825  72.591  1.00 50.32           C  
ATOM     20  CZ  PHE A   5      35.294  32.758  72.042  1.00 50.21           C  
ATOM     21  N   ASP A   6      40.720  34.017  74.053  1.00 49.21           N  
ATOM     22  CA  ASP A   6      40.729  34.250  75.505  1.00 48.86           C  
ATOM     23  C   ASP A   6      41.051  35.699  75.864  1.00 48.46           C  
ATOM     24  O   ASP A   6      40.467  36.252  76.804  1.00 47.99           O  
ATOM     25  CB  ASP A   6      41.722  33.313  76.201  1.00 48.91           C  
ATOM     26  CG  ASP A   6      41.197  31.891  76.331  1.00 49.51           C  
ATOM     27  OD1 ASP A   6      39.957  31.691  76.225  1.00 49.71           O  
ATOM     28  OD2 ASP A   6      42.028  30.973  76.542  1.00 49.10           O  
ATOM     29  N   LEU A   7      41.972  36.301  75.108  1.00 47.98           N  
ATOM     30  CA  LEU A   7      42.296  37.726  75.246  1.00 47.91           C  
ATOM     31  C   LEU A   7      41.121  38.604  74.796  1.00 47.51           C  
ATOM     32  O   LEU A   7      40.826  39.626  75.415  1.00 47.38           O  
ATOM     33  CB  LEU A   7      43.580  38.068  74.474  1.00 47.80           C  
ATOM     34  CG  LEU A   7      44.220  39.457  74.610  1.00 48.15           C  
ATOM     35  CD1 LEU A   7      44.417  39.878  76.070  1.00 49.16           C  
ATOM     36  CD2 LEU A   7      45.548  39.510  73.856  1.00 48.11           C  
ATOM     37  N   GLU A   8      40.452  38.182  73.728  1.00 47.48           N  
ATOM     38  CA  GLU A   8      39.243  38.836  73.220  1.00 47.49           C  
ATOM     39  C   GLU A   8      38.058  38.794  74.202  1.00 47.00           C  
ATOM     40  O   GLU A   8      37.355  39.796  74.386  1.00 46.97           O  
ATOM     41  CB  GLU A   8      38.829  38.180  71.907  1.00 47.93           C  
ATOM     42  CG  GLU A   8      38.077  39.098  70.971  1.00 49.57           C  
ATOM     43  CD  GLU A   8      39.000  40.035  70.235  1.00 51.16           C  
ATOM     44  OE1 GLU A   8      39.477  41.010  70.860  1.00 51.58           O  
ATOM     45  OE2 GLU A   8      39.243  39.790  69.034  1.00 52.21           O  
ATOM     46  N   LEU A   9      37.839  37.634  74.818  1.00 46.18           N  
ATOM     47  CA  LEU A   9      36.819  37.487  75.851  1.00 45.69           C  
ATOM     48  C   LEU A   9      37.126  38.391  77.035  1.00 45.42           C  
ATOM     49  O   LEU A   9      36.259  39.116  77.518  1.00 45.62           O  
ATOM     50  CB  LEU A   9      36.710  36.032  76.320  1.00 45.37           C  
ATOM     51  CG  LEU A   9      36.229  35.005  75.298  1.00 45.23           C  
ATOM     52  CD1 LEU A   9      35.830  33.708  75.999  1.00 45.61           C  
ATOM     53  CD2 LEU A   9      35.078  35.557  74.488  1.00 44.18           C  
ATOM     54  N   HIS A  10      38.372  38.331  77.491  1.00 44.95           N  
ATOM     55  CA  HIS A  10      38.845  39.165  78.581  1.00 44.49           C  
ATOM     56  C   HIS A  10      38.596  40.642  78.295  1.00 44.38           C  
ATOM     57  O   HIS A  10      38.149  41.379  79.173  1.00 44.05           O  
ATOM     58  CB  HIS A  10      40.333  38.924  78.842  1.00 44.33           C  
ATOM     59  CG  HIS A  10      40.941  39.968  79.714  1.00 43.82           C  
ATOM     60  ND1 HIS A  10      40.762  39.983  81.081  1.00 43.60           N  
ATOM     61  CD2 HIS A  10      41.644  41.079  79.411  1.00 40.71           C  
ATOM     62  CE1 HIS A  10      41.364  41.039  81.586  1.00 41.35           C  
ATOM     63  NE2 HIS A  10      41.910  41.716  80.593  1.00 43.27           N  
ATOM     64  N   GLU A  11      38.888  41.064  77.066  1.00 44.72           N  
ATOM     65  CA  GLU A  11      38.616  42.437  76.633  1.00 45.00           C  
ATOM     66  C   GLU A  11      37.126  42.751  76.609  1.00 44.77           C  
ATOM     67  O   GLU A  11      36.725  43.845  76.969  1.00 45.09           O  
ATOM     68  CB  GLU A  11      39.275  42.730  75.278  1.00 45.26           C  
ATOM     69  CG  GLU A  11      40.708  43.250  75.408  1.00 46.84           C  
ATOM     70  CD  GLU A  11      41.571  42.997  74.171  1.00 49.96           C  
ATOM     71  OE1 GLU A  11      42.820  43.081  74.292  1.00 51.17           O  
ATOM     72  OE2 GLU A  11      41.018  42.717  73.081  1.00 50.64           O  
ATOM     73  N   LEU A  12      36.309  41.777  76.200  1.00 44.74           N  
ATOM     74  CA  LEU A  12      34.853  41.898  76.275  1.00 44.19           C  
ATOM     75  C   LEU A  12      34.379  42.059  77.721  1.00 43.52           C  
ATOM     76  O   LEU A  12      33.491  42.858  78.008  1.00 43.63           O  
ATOM     77  CB  LEU A  12      34.162  40.684  75.635  1.00 44.31           C  
ATOM     78  CG  LEU A  12      32.724  40.798  75.092  1.00 44.42           C  
ATOM     79  CD1 LEU A  12      31.965  39.496  75.336  1.00 44.00           C  
ATOM     80  CD2 LEU A  12      31.947  41.967  75.665  1.00 43.69           C  
ATOM     81  N   GLU A  13      34.968  41.304  78.634  1.00 43.07           N  
ATOM     82  CA  GLU A  13      34.656  41.492  80.052  1.00 43.06           C  
ATOM     83  C   GLU A  13      34.979  42.912  80.560  1.00 42.75           C  
ATOM     84  O   GLU A  13      34.254  43.453  81.400  1.00 42.81           O  
ATOM     85  CB  GLU A  13      35.375  40.452  80.901  1.00 42.87           C  
ATOM     86  CG  GLU A  13      34.983  40.497  82.364  1.00 43.43           C  
ATOM     87  CD  GLU A  13      35.379  39.237  83.099  1.00 45.58           C  
ATOM     88  OE1 GLU A  13      36.587  38.932  83.182  1.00 44.47           O  
ATOM     89  OE2 GLU A  13      34.466  38.546  83.587  1.00 47.50           O  
ATOM     90  N   GLN A  14      36.059  43.504  80.055  1.00 42.01           N  
ATOM     91  CA  GLN A  14      36.458  44.835  80.502  1.00 42.28           C  
ATOM     92  C   GLN A  14      35.507  45.908  79.989  1.00 42.24           C  
ATOM     93  O   GLN A  14      35.223  46.872  80.713  1.00 42.51           O  
ATOM     94  CB  GLN A  14      37.918  45.162  80.124  1.00 41.53           C  
ATOM     95  CG  GLN A  14      38.967  44.474  81.014  1.00 41.27           C  
ATOM     96  CD  GLN A  14      38.841  44.825  82.501  1.00 40.10           C  
ATOM     97  OE1 GLN A  14      38.727  43.943  83.355  1.00 40.73           O  
ATOM     98  NE2 GLN A  14      38.861  46.110  82.804  1.00 37.67           N  
ATOM     99  N   SER A  15      35.031  45.742  78.751  1.00 41.76           N  
ATOM    100  CA  SER A  15      33.985  46.604  78.191  1.00 42.05           C  
ATOM    101  C   SER A  15      32.752  46.623  79.089  1.00 41.52           C  
ATOM    102  O   SER A  15      32.205  47.687  79.372  1.00 42.05           O  
ATOM    103  CB  SER A  15      33.566  46.133  76.790  1.00 42.21           C  
ATOM    104  OG  SER A  15      34.589  46.369  75.839  1.00 44.38           O  
ATOM    105  N   PHE A  16      32.336  45.436  79.525  1.00 41.15           N  
ATOM    106  CA  PHE A  16      31.171  45.241  80.388  1.00 40.59           C  
ATOM    107  C   PHE A  16      31.342  45.863  81.789  1.00 40.69           C  
ATOM    108  O   PHE A  16      30.439  46.538  82.281  1.00 40.96           O  
ATOM    109  CB  PHE A  16      30.836  43.738  80.449  1.00 40.42           C  
ATOM    110  CG  PHE A  16      29.861  43.375  81.528  1.00 40.96           C  
ATOM    111  CD1 PHE A  16      30.314  42.859  82.738  1.00 39.77           C  
ATOM    112  CD2 PHE A  16      28.480  43.566  81.339  1.00 41.12           C  
ATOM    113  CE1 PHE A  16      29.424  42.542  83.737  1.00 41.91           C  
ATOM    114  CE2 PHE A  16      27.579  43.259  82.349  1.00 40.88           C  
ATOM    115  CZ  PHE A  16      28.040  42.732  83.545  1.00 40.48           C  
ATOM    116  N   LEU A  17      32.499  45.653  82.417  1.00 40.47           N  
ATOM    117  CA  LEU A  17      32.821  46.326  83.692  1.00 40.59           C  
ATOM    118  C   LEU A  17      32.867  47.858  83.571  1.00 40.43           C  
ATOM    119  O   LEU A  17      32.373  48.568  84.464  1.00 39.99           O  
ATOM    120  CB  LEU A  17      34.131  45.793  84.306  1.00 40.10           C  
ATOM    121  CG  LEU A  17      34.173  44.277  84.540  1.00 39.27           C  
ATOM    122  CD1 LEU A  17      35.538  43.894  85.063  1.00 37.48           C  
ATOM    123  CD2 LEU A  17      33.103  43.815  85.488  1.00 37.32           C  
ATOM    124  N   GLY A  18      33.448  48.345  82.467  1.00 40.48           N  
ATOM    125  CA  GLY A  18      33.383  49.767  82.087  1.00 40.73           C  
ATOM    126  C   GLY A  18      31.948  50.284  82.100  1.00 41.25           C  
ATOM    127  O   GLY A  18      31.657  51.295  82.734  1.00 41.91           O  
ATOM    128  N   LEU A  19      31.040  49.569  81.432  1.00 40.82           N  
ATOM    129  CA  LEU A  19      29.628  49.913  81.458  1.00 40.90           C  
ATOM    130  C   LEU A  19      29.079  49.924  82.881  1.00 41.23           C  
ATOM    131  O   LEU A  19      28.356  50.835  83.250  1.00 40.87           O  
ATOM    132  CB  LEU A  19      28.806  48.927  80.624  1.00 40.05           C  
ATOM    133  CG  LEU A  19      27.756  49.424  79.622  1.00 41.16           C  
ATOM    134  CD1 LEU A  19      26.598  48.386  79.402  1.00 36.71           C  
ATOM    135  CD2 LEU A  19      27.219  50.865  79.883  1.00 39.73           C  
ATOM    136  N   GLY A  20      29.404  48.884  83.655  1.00 41.71           N  
ATOM    137  CA  GLY A  20      28.950  48.752  85.040  1.00 42.02           C  
ATOM    138  C   GLY A  20      29.499  49.821  85.967  1.00 42.56           C  
ATOM    139  O   GLY A  20      28.800  50.287  86.865  1.00 43.46           O  
ATOM    140  N   GLN A  21      30.762  50.193  85.772  1.00 42.69           N  
ATOM    141  CA  GLN A  21      31.343  51.343  86.457  1.00 42.90           C  
ATOM    142  C   GLN A  21      30.625  52.650  86.070  1.00 42.41           C  
ATOM    143  O   GLN A  21      30.361  53.491  86.916  1.00 42.38           O  
ATOM    144  CB  GLN A  21      32.834  51.423  86.140  1.00 43.37           C  
ATOM    145  CG  GLN A  21      33.584  52.465  86.925  1.00 45.74           C  
ATOM    146  CD  GLN A  21      33.539  52.221  88.432  1.00 50.03           C  
ATOM    147  OE1 GLN A  21      33.454  53.181  89.215  1.00 53.32           O  
ATOM    148  NE2 GLN A  21      33.607  50.946  88.847  1.00 47.04           N  
ATOM    149  N   LEU A  22      30.298  52.811  84.794  1.00 42.12           N  
ATOM    150  CA  LEU A  22      29.495  53.947  84.368  1.00 42.27           C  
ATOM    151  C   LEU A  22      28.138  53.977  85.096  1.00 42.20           C  
ATOM    152  O   LEU A  22      27.754  55.027  85.610  1.00 41.47           O  
ATOM    153  CB  LEU A  22      29.326  53.993  82.841  1.00 42.35           C  
ATOM    154  CG  LEU A  22      28.523  55.172  82.262  1.00 43.22           C  
ATOM    155  CD1 LEU A  22      29.128  56.517  82.678  1.00 42.76           C  
ATOM    156  CD2 LEU A  22      28.395  55.082  80.732  1.00 42.31           C  
ATOM    157  N   VAL A  23      27.424  52.845  85.164  1.00 42.23           N  
ATOM    158  CA  VAL A  23      26.142  52.850  85.911  1.00 42.52           C  
ATOM    159  C   VAL A  23      26.271  53.006  87.427  1.00 42.36           C  
ATOM    160  O   VAL A  23      25.350  53.511  88.053  1.00 42.17           O  
ATOM    161  CB  VAL A  23      25.051  51.777  85.465  1.00 42.61           C  
ATOM    162  CG1 VAL A  23      25.545  50.832  84.396  1.00 44.36           C  
ATOM    163  CG2 VAL A  23      24.409  51.049  86.632  1.00 40.81           C  
ATOM    164  N   LEU A  24      27.412  52.603  87.995  1.00 42.77           N  
ATOM    165  CA  LEU A  24      27.685  52.838  89.420  1.00 43.32           C  
ATOM    166  C   LEU A  24      27.877  54.327  89.690  1.00 43.77           C  
ATOM    167  O   LEU A  24      27.310  54.863  90.634  1.00 44.28           O  
ATOM    168  CB  LEU A  24      28.885  52.025  89.933  1.00 42.72           C  
ATOM    169  CG  LEU A  24      29.216  52.183  91.428  1.00 42.90           C  
ATOM    170  CD1 LEU A  24      28.094  51.764  92.375  1.00 42.19           C  
ATOM    171  CD2 LEU A  24      30.512  51.457  91.801  1.00 43.01           C  
ATOM    172  N   GLU A  25      28.665  54.984  88.845  1.00 44.14           N  
ATOM    173  CA  GLU A  25      28.821  56.427  88.898  1.00 44.98           C  
ATOM    174  C   GLU A  25      27.508  57.196  88.784  1.00 44.48           C  
ATOM    175  O   GLU A  25      27.262  58.119  89.563  1.00 45.08           O  
ATOM    176  CB  GLU A  25      29.807  56.900  87.830  1.00 45.39           C  
ATOM    177  CG  GLU A  25      31.252  56.550  88.173  1.00 49.99           C  
ATOM    178  CD  GLU A  25      32.216  56.782  87.015  1.00 55.88           C  
ATOM    179  OE1 GLU A  25      31.757  57.131  85.892  1.00 58.38           O  
ATOM    180  OE2 GLU A  25      33.440  56.605  87.231  1.00 57.55           O  
ATOM    181  N   THR A  26      26.666  56.833  87.824  1.00 44.19           N  
ATOM    182  CA  THR A  26      25.412  57.584  87.633  1.00 43.86           C  
ATOM    183  C   THR A  26      24.400  57.328  88.749  1.00 43.75           C  
ATOM    184  O   THR A  26      23.618  58.209  89.075  1.00 43.69           O  
ATOM    185  CB  THR A  26      24.788  57.479  86.195  1.00 43.75           C  
ATOM    186  OG1 THR A  26      23.425  57.049  86.284  1.00 44.47           O  
ATOM    187  CG2 THR A  26      25.550  56.547  85.308  1.00 41.56           C  
ATOM    188  N   ALA A  27      24.448  56.135  89.340  1.00 43.44           N  
ATOM    189  CA  ALA A  27      23.649  55.802  90.508  1.00 43.41           C  
ATOM    190  C   ALA A  27      24.065  56.678  91.688  1.00 43.49           C  
ATOM    191  O   ALA A  27      23.234  57.288  92.366  1.00 43.11           O  
ATOM    192  CB  ALA A  27      23.799  54.297  90.847  1.00 43.09           C  
ATOM    193  N   SER A  28      25.374  56.726  91.911  1.00 44.23           N  
ATOM    194  CA  SER A  28      25.999  57.624  92.889  1.00 45.01           C  
ATOM    195  C   SER A  28      25.634  59.111  92.691  1.00 44.67           C  
ATOM    196  O   SER A  28      25.200  59.776  93.635  1.00 44.41           O  
ATOM    197  CB  SER A  28      27.510  57.419  92.878  1.00 44.52           C  
ATOM    198  OG  SER A  28      28.109  58.427  93.658  1.00 48.38           O  
ATOM    199  N   LYS A  29      25.808  59.606  91.462  1.00 44.89           N  
ATOM    200  CA  LYS A  29      25.337  60.942  91.029  1.00 45.02           C  
ATOM    201  C   LYS A  29      23.818  61.162  91.225  1.00 44.22           C  
ATOM    202  O   LYS A  29      23.405  62.212  91.710  1.00 43.97           O  
ATOM    203  CB  LYS A  29      25.726  61.209  89.554  1.00 44.84           C  
ATOM    204  CG  LYS A  29      27.049  61.966  89.344  1.00 46.33           C  
ATOM    205  CD  LYS A  29      27.714  61.743  87.953  1.00 46.65           C  
ATOM    206  CE  LYS A  29      26.720  61.469  86.780  1.00 49.12           C  
ATOM    207  NZ  LYS A  29      27.393  60.922  85.526  1.00 47.95           N  
ATOM    208  N   ALA A  30      23.000  60.181  90.847  1.00 43.56           N  
ATOM    209  CA  ALA A  30      21.540  60.246  91.065  1.00 43.73           C  
ATOM    210  C   ALA A  30      21.152  60.477  92.528  1.00 43.82           C  
ATOM    211  O   ALA A  30      20.259  61.273  92.826  1.00 43.57           O  
ATOM    212  CB  ALA A  30      20.839  58.975  90.539  1.00 43.32           C  
ATOM    213  N   LEU A  31      21.820  59.758  93.426  1.00 43.81           N  
ATOM    214  CA  LEU A  31      21.506  59.814  94.845  1.00 43.53           C  
ATOM    215  C   LEU A  31      22.052  61.059  95.499  1.00 43.37           C  
ATOM    216  O   LEU A  31      21.442  61.573  96.434  1.00 43.96           O  
ATOM    217  CB  LEU A  31      21.984  58.538  95.553  1.00 43.62           C  
ATOM    218  CG  LEU A  31      21.158  57.317  95.108  1.00 43.62           C  
ATOM    219  CD1 LEU A  31      21.762  56.015  95.619  1.00 44.67           C  
ATOM    220  CD2 LEU A  31      19.672  57.441  95.516  1.00 42.35           C  
ATOM    221  N   LEU A  32      23.196  61.542  95.009  1.00 43.07           N  
ATOM    222  CA  LEU A  32      23.721  62.843  95.413  1.00 42.75           C  
ATOM    223  C   LEU A  32      22.809  63.961  94.924  1.00 42.55           C  
ATOM    224  O   LEU A  32      22.511  64.882  95.683  1.00 42.97           O  
ATOM    225  CB  LEU A  32      25.171  63.061  94.926  1.00 42.71           C  
ATOM    226  CG  LEU A  32      25.765  64.485  94.906  1.00 43.31           C  
ATOM    227  CD1 LEU A  32      25.847  65.147  96.302  1.00 41.92           C  
ATOM    228  CD2 LEU A  32      27.131  64.498  94.222  1.00 43.17           C  
ATOM    229  N   ALA A  33      22.364  63.892  93.668  1.00 42.15           N  
ATOM    230  CA  ALA A  33      21.407  64.882  93.162  1.00 42.25           C  
ATOM    231  C   ALA A  33      20.122  64.906  93.996  1.00 42.21           C  
ATOM    232  O   ALA A  33      19.486  65.950  94.111  1.00 42.68           O  
ATOM    233  CB  ALA A  33      21.093  64.664  91.683  1.00 42.14           C  
ATOM    234  N   LEU A  34      19.773  63.762  94.589  1.00 41.78           N  
ATOM    235  CA  LEU A  34      18.599  63.625  95.456  1.00 41.67           C  
ATOM    236  C   LEU A  34      18.832  64.199  96.850  1.00 41.75           C  
ATOM    237  O   LEU A  34      17.961  64.885  97.378  1.00 41.72           O  
ATOM    238  CB  LEU A  34      18.208  62.147  95.604  1.00 41.74           C  
ATOM    239  CG  LEU A  34      16.784  61.707  95.967  1.00 41.77           C  
ATOM    240  CD1 LEU A  34      16.839  60.341  96.616  1.00 42.67           C  
ATOM    241  CD2 LEU A  34      16.020  62.662  96.869  1.00 42.39           C  
ATOM    242  N   ALA A  35      19.982  63.883  97.452  1.00 41.73           N  
ATOM    243  CA  ALA A  35      20.340  64.383  98.782  1.00 41.93           C  
ATOM    244  C   ALA A  35      20.478  65.901  98.788  1.00 42.10           C  
ATOM    245  O   ALA A  35      20.032  66.559  99.724  1.00 42.13           O  
ATOM    246  CB  ALA A  35      21.630  63.739  99.282  1.00 41.63           C  
ATOM    247  N   SER A  36      21.089  66.443  97.738  1.00 42.33           N  
ATOM    248  CA  SER A  36      21.357  67.869  97.656  1.00 42.67           C  
ATOM    249  C   SER A  36      20.298  68.645  96.876  1.00 43.05           C  
ATOM    250  O   SER A  36      20.429  69.856  96.701  1.00 43.15           O  
ATOM    251  CB  SER A  36      22.754  68.121  97.072  1.00 42.60           C  
ATOM    252  OG  SER A  36      22.851  67.686  95.732  1.00 42.94           O  
ATOM    253  N   LYS A  37      19.253  67.957  96.415  1.00 43.63           N  
ATOM    254  CA  LYS A  37      18.179  68.587  95.624  1.00 44.35           C  
ATOM    255  C   LYS A  37      18.717  69.373  94.420  1.00 44.63           C  
ATOM    256  O   LYS A  37      18.237  70.466  94.105  1.00 44.77           O  
ATOM    257  CB  LYS A  37      17.290  69.484  96.509  1.00 44.41           C  
ATOM    258  CG  LYS A  37      16.027  68.807  97.041  1.00 45.09           C  
ATOM    259  CD  LYS A  37      16.321  67.916  98.235  1.00 45.96           C  
ATOM    260  CE  LYS A  37      15.382  66.725  98.278  1.00 44.88           C  
ATOM    261  NZ  LYS A  37      15.762  65.782  99.366  1.00 45.07           N  
ATOM    262  N   ASP A  38      19.722  68.801  93.760  1.00 44.93           N  
ATOM    263  CA  ASP A  38      20.398  69.443  92.638  1.00 45.10           C  
ATOM    264  C   ASP A  38      19.683  69.106  91.326  1.00 45.34           C  
ATOM    265  O   ASP A  38      20.008  68.119  90.647  1.00 45.17           O  
ATOM    266  CB  ASP A  38      21.861  68.997  92.611  1.00 45.19           C  
ATOM    267  CG  ASP A  38      22.691  69.714  91.556  1.00 45.93           C  
ATOM    268  OD1 ASP A  38      23.933  69.630  91.654  1.00 46.88           O  
ATOM    269  OD2 ASP A  38      22.129  70.342  90.628  1.00 46.78           O  
ATOM    270  N   LYS A  39      18.706  69.942  90.978  1.00 45.63           N  
ATOM    271  CA  LYS A  39      17.882  69.731  89.792  1.00 46.16           C  
ATOM    272  C   LYS A  39      18.665  69.828  88.480  1.00 46.41           C  
ATOM    273  O   LYS A  39      18.263  69.260  87.465  1.00 46.68           O  
ATOM    274  CB  LYS A  39      16.689  70.686  89.791  1.00 46.22           C  
ATOM    275  CG  LYS A  39      15.684  70.382  90.895  1.00 46.82           C  
ATOM    276  CD  LYS A  39      14.392  71.184  90.740  1.00 47.14           C  
ATOM    277  CE  LYS A  39      13.535  71.041  91.994  1.00 47.74           C  
ATOM    278  NZ  LYS A  39      12.076  71.131  91.711  1.00 48.32           N  
ATOM    279  N   GLU A  40      19.790  70.532  88.517  1.00 46.59           N  
ATOM    280  CA  GLU A  40      20.658  70.663  87.354  1.00 46.55           C  
ATOM    281  C   GLU A  40      21.445  69.377  87.108  1.00 46.19           C  
ATOM    282  O   GLU A  40      21.567  68.937  85.967  1.00 46.33           O  
ATOM    283  CB  GLU A  40      21.579  71.878  87.507  1.00 46.61           C  
ATOM    284  CG  GLU A  40      20.810  73.152  87.828  1.00 47.63           C  
ATOM    285  CD  GLU A  40      21.635  74.403  87.647  1.00 49.80           C  
ATOM    286  OE1 GLU A  40      21.115  75.384  87.059  1.00 49.68           O  
ATOM    287  OE2 GLU A  40      22.804  74.406  88.095  1.00 51.15           O  
ATOM    288  N   MET A  41      21.954  68.770  88.180  1.00 45.93           N  
ATOM    289  CA  MET A  41      22.655  67.485  88.096  1.00 45.72           C  
ATOM    290  C   MET A  41      21.707  66.380  87.653  1.00 44.90           C  
ATOM    291  O   MET A  41      22.106  65.480  86.915  1.00 44.95           O  
ATOM    292  CB  MET A  41      23.291  67.124  89.442  1.00 46.03           C  
ATOM    293  CG  MET A  41      24.315  65.985  89.415  1.00 46.32           C  
ATOM    294  SD  MET A  41      24.690  65.443  91.104  1.00 47.30           S  
ATOM    295  CE  MET A  41      26.255  64.614  90.886  1.00 47.76           C  
ATOM    296  N   ALA A  42      20.456  66.455  88.102  1.00 44.05           N  
ATOM    297  CA  ALA A  42      19.422  65.533  87.657  1.00 43.30           C  
ATOM    298  C   ALA A  42      19.259  65.581  86.138  1.00 43.09           C  
ATOM    299  O   ALA A  42      19.152  64.531  85.495  1.00 42.52           O  
ATOM    300  CB  ALA A  42      18.098  65.818  88.354  1.00 43.23           C  
ATOM    301  N   GLU A  43      19.257  66.794  85.579  1.00 42.53           N  
ATOM    302  CA  GLU A  43      19.076  67.000  84.137  1.00 42.45           C  
ATOM    303  C   GLU A  43      20.207  66.421  83.294  1.00 41.75           C  
ATOM    304  O   GLU A  43      19.967  65.889  82.218  1.00 41.04           O  
ATOM    305  CB  GLU A  43      18.903  68.494  83.803  1.00 42.72           C  
ATOM    306  CG  GLU A  43      17.516  68.873  83.317  1.00 44.51           C  
ATOM    307  CD  GLU A  43      17.549  69.847  82.138  1.00 47.71           C  
ATOM    308  OE1 GLU A  43      18.404  69.672  81.237  1.00 49.00           O  
ATOM    309  OE2 GLU A  43      16.714  70.781  82.097  1.00 48.13           O  
ATOM    310  N   LEU A  44      21.440  66.558  83.776  1.00 41.73           N  
ATOM    311  CA  LEU A  44      22.607  65.989  83.102  1.00 41.74           C  
ATOM    312  C   LEU A  44      22.565  64.458  83.140  1.00 41.56           C  
ATOM    313  O   LEU A  44      22.952  63.799  82.172  1.00 41.91           O  
ATOM    314  CB  LEU A  44      23.922  66.534  83.691  1.00 41.82           C  
ATOM    315  CG  LEU A  44      24.121  68.064  83.771  1.00 42.59           C  
ATOM    316  CD1 LEU A  44      25.346  68.436  84.604  1.00 42.68           C  
ATOM    317  CD2 LEU A  44      24.166  68.768  82.391  1.00 43.25           C  
ATOM    318  N   ILE A  45      22.063  63.892  84.236  1.00 41.20           N  
ATOM    319  CA  ILE A  45      21.865  62.434  84.321  1.00 40.83           C  
ATOM    320  C   ILE A  45      20.857  61.952  83.272  1.00 40.80           C  
ATOM    321  O   ILE A  45      21.054  60.907  82.630  1.00 41.39           O  
ATOM    322  CB  ILE A  45      21.349  61.998  85.714  1.00 40.55           C  
ATOM    323  CG1 ILE A  45      22.445  62.171  86.769  1.00 40.69           C  
ATOM    324  CG2 ILE A  45      20.808  60.547  85.672  1.00 40.44           C  
ATOM    325  CD1 ILE A  45      21.914  62.448  88.158  1.00 39.88           C  
ATOM    326  N   ILE A  46      19.766  62.697  83.131  1.00 39.98           N  
ATOM    327  CA  ILE A  46      18.701  62.328  82.222  1.00 39.84           C  
ATOM    328  C   ILE A  46      19.227  62.345  80.781  1.00 39.87           C  
ATOM    329  O   ILE A  46      19.013  61.403  80.025  1.00 39.48           O  
ATOM    330  CB  ILE A  46      17.470  63.243  82.418  1.00 39.76           C  
ATOM    331  CG1 ILE A  46      16.889  63.031  83.822  1.00 38.99           C  
ATOM    332  CG2 ILE A  46      16.407  63.003  81.333  1.00 39.41           C  
ATOM    333  CD1 ILE A  46      15.975  64.156  84.288  1.00 36.32           C  
ATOM    334  N   ASN A  47      19.952  63.401  80.431  1.00 39.93           N  
ATOM    335  CA  ASN A  47      20.523  63.538  79.097  1.00 40.21           C  
ATOM    336  C   ASN A  47      21.684  62.582  78.759  1.00 40.55           C  
ATOM    337  O   ASN A  47      21.936  62.304  77.583  1.00 40.76           O  
ATOM    338  CB  ASN A  47      20.894  64.997  78.840  1.00 39.96           C  
ATOM    339  CG  ASN A  47      19.662  65.897  78.770  1.00 40.36           C  
ATOM    340  OD1 ASN A  47      18.649  65.530  78.170  1.00 40.39           O  
ATOM    341  ND2 ASN A  47      19.740  67.076  79.395  1.00 39.43           N  
ATOM    342  N   LYS A  48      22.376  62.072  79.780  1.00 40.61           N  
ATOM    343  CA  LYS A  48      23.477  61.138  79.551  1.00 40.86           C  
ATOM    344  C   LYS A  48      23.054  59.673  79.522  1.00 40.41           C  
ATOM    345  O   LYS A  48      23.874  58.801  79.216  1.00 40.22           O  
ATOM    346  CB  LYS A  48      24.597  61.330  80.570  1.00 41.39           C  
ATOM    347  CG  LYS A  48      25.510  62.513  80.248  1.00 43.93           C  
ATOM    348  CD  LYS A  48      26.921  62.317  80.795  1.00 47.04           C  
ATOM    349  CE  LYS A  48      26.964  62.360  82.320  1.00 48.89           C  
ATOM    350  NZ  LYS A  48      28.147  63.163  82.794  1.00 48.67           N  
ATOM    351  N   ASP A  49      21.783  59.400  79.814  1.00 40.04           N  
ATOM    352  CA  ASP A  49      21.305  58.018  79.807  1.00 40.31           C  
ATOM    353  C   ASP A  49      21.564  57.291  78.476  1.00 40.12           C  
ATOM    354  O   ASP A  49      21.909  56.120  78.485  1.00 40.38           O  
ATOM    355  CB  ASP A  49      19.829  57.901  80.207  1.00 40.01           C  
ATOM    356  CG  ASP A  49      19.402  56.449  80.381  1.00 40.44           C  
ATOM    357  OD1 ASP A  49      19.724  55.836  81.431  1.00 41.29           O  
ATOM    358  OD2 ASP A  49      18.779  55.899  79.449  1.00 39.70           O  
ATOM    359  N   HIS A  50      21.434  57.988  77.352  1.00 39.91           N  
ATOM    360  CA  HIS A  50      21.638  57.373  76.034  1.00 40.38           C  
ATOM    361  C   HIS A  50      23.049  56.817  75.778  1.00 39.85           C  
ATOM    362  O   HIS A  50      23.210  55.892  74.978  1.00 39.76           O  
ATOM    363  CB  HIS A  50      21.249  58.323  74.888  1.00 40.91           C  
ATOM    364  CG  HIS A  50      21.236  57.653  73.550  1.00 43.25           C  
ATOM    365  ND1 HIS A  50      22.166  57.928  72.569  1.00 45.37           N  
ATOM    366  CD2 HIS A  50      20.439  56.676  73.051  1.00 45.22           C  
ATOM    367  CE1 HIS A  50      21.913  57.181  71.506  1.00 46.94           C  
ATOM    368  NE2 HIS A  50      20.878  56.404  71.776  1.00 47.04           N  
ATOM    369  N   ALA A  51      24.059  57.376  76.444  1.00 39.22           N  
ATOM    370  CA  ALA A  51      25.406  56.814  76.374  1.00 39.18           C  
ATOM    371  C   ALA A  51      25.482  55.394  76.982  1.00 38.90           C  
ATOM    372  O   ALA A  51      26.301  54.575  76.564  1.00 38.89           O  
ATOM    373  CB  ALA A  51      26.414  57.742  77.021  1.00 38.78           C  
ATOM    374  N   ILE A  52      24.613  55.099  77.944  1.00 38.79           N  
ATOM    375  CA  ILE A  52      24.543  53.746  78.517  1.00 38.75           C  
ATOM    376  C   ILE A  52      23.838  52.800  77.527  1.00 39.80           C  
ATOM    377  O   ILE A  52      24.255  51.649  77.343  1.00 39.67           O  
ATOM    378  CB  ILE A  52      23.850  53.730  79.909  1.00 38.77           C  
ATOM    379  CG1 ILE A  52      24.659  54.574  80.918  1.00 37.92           C  
ATOM    380  CG2 ILE A  52      23.704  52.273  80.427  1.00 39.29           C  
ATOM    381  CD1 ILE A  52      23.931  54.963  82.181  1.00 37.17           C  
ATOM    382  N   ASN A  53      22.783  53.298  76.877  1.00 40.26           N  
ATOM    383  CA  ASN A  53      22.122  52.554  75.821  1.00 40.56           C  
ATOM    384  C   ASN A  53      23.167  52.231  74.747  1.00 41.02           C  
ATOM    385  O   ASN A  53      23.359  51.060  74.398  1.00 41.35           O  
ATOM    386  CB  ASN A  53      20.974  53.375  75.228  1.00 40.68           C  
ATOM    387  CG  ASN A  53      19.724  53.389  76.104  1.00 41.19           C  
ATOM    388  OD1 ASN A  53      18.616  53.313  75.581  1.00 45.79           O  
ATOM    389  ND2 ASN A  53      19.885  53.514  77.417  1.00 38.23           N  
ATOM    390  N   GLN A  54      23.867  53.271  74.272  1.00 41.18           N  
ATOM    391  CA  GLN A  54      24.940  53.153  73.263  1.00 40.85           C  
ATOM    392  C   GLN A  54      26.030  52.147  73.622  1.00 41.26           C  
ATOM    393  O   GLN A  54      26.459  51.367  72.762  1.00 41.16           O  
ATOM    394  CB  GLN A  54      25.584  54.518  72.975  1.00 40.57           C  
ATOM    395  CG  GLN A  54      24.926  55.292  71.857  1.00 39.37           C  
ATOM    396  CD  GLN A  54      25.714  56.534  71.451  1.00 40.49           C  
ATOM    397  OE1 GLN A  54      26.201  57.283  72.295  1.00 39.51           O  
ATOM    398  NE2 GLN A  54      25.836  56.755  70.144  1.00 40.26           N  
ATOM    399  N   GLY A  55      26.470  52.177  74.880  1.00 41.36           N  
ATOM    400  CA  GLY A  55      27.521  51.291  75.367  1.00 42.26           C  
ATOM    401  C   GLY A  55      27.081  49.838  75.371  1.00 43.09           C  
ATOM    402  O   GLY A  55      27.875  48.938  75.092  1.00 43.18           O  
ATOM    403  N   GLN A  56      25.809  49.626  75.704  1.00 43.39           N  
ATOM    404  CA  GLN A  56      25.177  48.324  75.674  1.00 43.87           C  
ATOM    405  C   GLN A  56      25.115  47.761  74.252  1.00 44.23           C  
ATOM    406  O   GLN A  56      25.394  46.581  74.042  1.00 44.59           O  
ATOM    407  CB  GLN A  56      23.773  48.429  76.272  1.00 43.83           C  
ATOM    408  CG  GLN A  56      22.944  47.176  76.117  1.00 45.27           C  
ATOM    409  CD  GLN A  56      21.459  47.441  76.138  1.00 44.86           C  
ATOM    410  OE1 GLN A  56      20.995  48.515  75.747  1.00 47.38           O  
ATOM    411  NE2 GLN A  56      20.702  46.459  76.561  1.00 44.17           N  
ATOM    412  N   SER A  57      24.760  48.599  73.275  1.00 44.03           N  
ATOM    413  CA  SER A  57      24.630  48.113  71.912  1.00 43.95           C  
ATOM    414  C   SER A  57      26.000  47.714  71.365  1.00 43.66           C  
ATOM    415  O   SER A  57      26.128  46.691  70.692  1.00 43.71           O  
ATOM    416  CB  SER A  57      23.900  49.124  71.014  1.00 44.04           C  
ATOM    417  OG  SER A  57      24.786  49.832  70.158  1.00 44.97           O  
ATOM    418  N   ALA A  58      27.017  48.510  71.684  1.00 43.33           N  
ATOM    419  CA  ALA A  58      28.395  48.217  71.297  1.00 43.34           C  
ATOM    420  C   ALA A  58      28.820  46.843  71.809  1.00 43.46           C  
ATOM    421  O   ALA A  58      29.322  46.014  71.045  1.00 43.13           O  
ATOM    422  CB  ALA A  58      29.345  49.307  71.815  1.00 43.32           C  
ATOM    423  N   ILE A  59      28.577  46.604  73.099  1.00 43.75           N  
ATOM    424  CA  ILE A  59      28.888  45.326  73.749  1.00 43.92           C  
ATOM    425  C   ILE A  59      28.087  44.171  73.159  1.00 44.47           C  
ATOM    426  O   ILE A  59      28.680  43.156  72.759  1.00 44.81           O  
ATOM    427  CB  ILE A  59      28.669  45.415  75.257  1.00 43.90           C  
ATOM    428  CG1 ILE A  59      29.655  46.410  75.870  1.00 43.58           C  
ATOM    429  CG2 ILE A  59      28.811  44.036  75.926  1.00 44.49           C  
ATOM    430  CD1 ILE A  59      29.197  46.926  77.216  1.00 43.00           C  
ATOM    431  N   GLU A  60      26.755  44.328  73.107  1.00 44.66           N  
ATOM    432  CA  GLU A  60      25.850  43.387  72.403  1.00 44.97           C  
ATOM    433  C   GLU A  60      26.379  42.961  71.038  1.00 45.00           C  
ATOM    434  O   GLU A  60      26.284  41.787  70.672  1.00 44.72           O  
ATOM    435  CB  GLU A  60      24.462  43.999  72.187  1.00 44.60           C  
ATOM    436  CG  GLU A  60      23.557  43.997  73.390  1.00 44.55           C  
ATOM    437  CD  GLU A  60      22.153  44.497  73.093  1.00 45.25           C  
ATOM    438  OE1 GLU A  60      21.940  45.294  72.142  1.00 47.53           O  
ATOM    439  OE2 GLU A  60      21.236  44.098  73.828  1.00 47.36           O  
ATOM    440  N   LEU A  61      26.932  43.926  70.300  1.00 45.39           N  
ATOM    441  CA  LEU A  61      27.376  43.716  68.924  1.00 46.30           C  
ATOM    442  C   LEU A  61      28.698  42.977  68.805  1.00 46.38           C  
ATOM    443  O   LEU A  61      28.833  42.103  67.938  1.00 46.73           O  
ATOM    444  CB  LEU A  61      27.420  45.037  68.136  1.00 46.18           C  
ATOM    445  CG  LEU A  61      26.280  45.312  67.137  1.00 47.08           C  
ATOM    446  CD1 LEU A  61      24.916  45.363  67.816  1.00 47.48           C  
ATOM    447  CD2 LEU A  61      26.531  46.610  66.364  1.00 47.10           C  
ATOM    448  N   THR A  62      29.669  43.317  69.654  1.00 46.42           N  
ATOM    449  CA  THR A  62      30.929  42.568  69.674  1.00 46.49           C  
ATOM    450  C   THR A  62      30.742  41.162  70.278  1.00 47.02           C  
ATOM    451  O   THR A  62      31.463  40.238  69.920  1.00 46.80           O  
ATOM    452  CB  THR A  62      32.140  43.338  70.333  1.00 46.41           C  
ATOM    453  OG1 THR A  62      32.332  42.925  71.684  1.00 44.94           O  
ATOM    454  CG2 THR A  62      31.986  44.847  70.254  1.00 45.84           C  
ATOM    455  N   CYS A  63      29.767  41.009  71.174  1.00 47.76           N  
ATOM    456  CA  CYS A  63      29.326  39.679  71.631  1.00 48.82           C  
ATOM    457  C   CYS A  63      28.813  38.862  70.447  1.00 49.94           C  
ATOM    458  O   CYS A  63      29.365  37.801  70.128  1.00 50.31           O  
ATOM    459  CB  CYS A  63      28.204  39.788  72.665  1.00 48.40           C  
ATOM    460  SG  CYS A  63      28.668  40.041  74.399  1.00 47.48           S  
ATOM    461  N   ALA A  64      27.767  39.370  69.794  1.00 51.13           N  
ATOM    462  CA  ALA A  64      27.126  38.679  68.668  1.00 52.35           C  
ATOM    463  C   ALA A  64      28.132  38.278  67.592  1.00 53.19           C  
ATOM    464  O   ALA A  64      28.072  37.169  67.075  1.00 53.49           O  
ATOM    465  CB  ALA A  64      26.008  39.528  68.074  1.00 52.15           C  
ATOM    466  N   ARG A  65      29.068  39.169  67.278  1.00 54.41           N  
ATOM    467  CA  ARG A  65      30.107  38.856  66.312  1.00 55.74           C  
ATOM    468  C   ARG A  65      31.182  37.914  66.869  1.00 56.49           C  
ATOM    469  O   ARG A  65      31.844  37.215  66.099  1.00 56.73           O  
ATOM    470  CB  ARG A  65      30.762  40.130  65.770  1.00 55.73           C  
ATOM    471  CG  ARG A  65      31.882  40.648  66.642  1.00 56.87           C  
ATOM    472  CD  ARG A  65      33.003  41.257  65.826  1.00 58.48           C  
ATOM    473  NE  ARG A  65      34.180  41.482  66.659  1.00 59.39           N  
ATOM    474  CZ  ARG A  65      34.418  42.595  67.344  1.00 60.75           C  
ATOM    475  NH1 ARG A  65      35.521  42.697  68.079  1.00 60.75           N  
ATOM    476  NH2 ARG A  65      33.560  43.609  67.295  1.00 61.26           N  
ATOM    477  N   LEU A  66      31.373  37.896  68.188  1.00 57.29           N  
ATOM    478  CA  LEU A  66      32.440  37.065  68.758  1.00 58.01           C  
ATOM    479  C   LEU A  66      32.161  35.586  68.637  1.00 58.49           C  
ATOM    480  O   LEU A  66      33.081  34.790  68.455  1.00 58.67           O  
ATOM    481  CB  LEU A  66      32.761  37.421  70.212  1.00 57.99           C  
ATOM    482  CG  LEU A  66      34.027  38.253  70.431  1.00 57.95           C  
ATOM    483  CD1 LEU A  66      34.375  38.303  71.913  1.00 57.79           C  
ATOM    484  CD2 LEU A  66      35.191  37.701  69.619  1.00 58.06           C  
ATOM    485  N   LEU A  67      30.887  35.223  68.725  1.00 59.15           N  
ATOM    486  CA  LEU A  67      30.493  33.839  68.554  1.00 59.92           C  
ATOM    487  C   LEU A  67      31.040  33.228  67.244  1.00 60.65           C  
ATOM    488  O   LEU A  67      31.372  32.035  67.203  1.00 61.14           O  
ATOM    489  CB  LEU A  67      28.972  33.692  68.659  1.00 59.70           C  
ATOM    490  CG  LEU A  67      28.243  33.703  70.014  1.00 59.73           C  
ATOM    491  CD1 LEU A  67      29.132  33.309  71.185  1.00 59.69           C  
ATOM    492  CD2 LEU A  67      27.551  35.015  70.286  1.00 59.81           C  
ATOM    493  N   ALA A  68      31.156  34.046  66.191  1.00 61.12           N  
ATOM    494  CA  ALA A  68      31.611  33.567  64.872  1.00 61.53           C  
ATOM    495  C   ALA A  68      33.137  33.488  64.708  1.00 61.77           C  
ATOM    496  O   ALA A  68      33.668  32.411  64.443  1.00 61.77           O  
ATOM    497  CB  ALA A  68      30.963  34.356  63.717  1.00 61.53           C  
ATOM    498  N   LEU A  69      33.826  34.620  64.859  1.00 62.08           N  
ATOM    499  CA  LEU A  69      35.292  34.675  64.765  1.00 62.36           C  
ATOM    500  C   LEU A  69      35.970  33.759  65.783  1.00 62.43           C  
ATOM    501  O   LEU A  69      35.507  33.625  66.918  1.00 62.54           O  
ATOM    502  CB  LEU A  69      35.799  36.111  64.958  1.00 62.45           C  
ATOM    503  CG  LEU A  69      35.822  37.102  63.786  1.00 62.90           C  
ATOM    504  CD1 LEU A  69      34.446  37.709  63.527  1.00 63.21           C  
ATOM    505  CD2 LEU A  69      36.845  38.208  64.046  1.00 62.50           C  
ATOM    506  N   PRO A  72      32.454  29.542  70.661  1.00 64.61           N  
ATOM    507  CA  PRO A  72      32.609  28.274  69.949  1.00 64.49           C  
ATOM    508  C   PRO A  72      32.750  27.040  70.855  1.00 64.31           C  
ATOM    509  O   PRO A  72      32.783  25.910  70.342  1.00 64.53           O  
ATOM    510  CB  PRO A  72      33.876  28.501  69.119  1.00 64.53           C  
ATOM    511  CG  PRO A  72      33.807  29.965  68.764  1.00 64.76           C  
ATOM    512  CD  PRO A  72      33.055  30.661  69.911  1.00 64.78           C  
ATOM    513  N   GLN A  73      32.824  27.241  72.175  1.00 63.72           N  
ATOM    514  CA  GLN A  73      32.755  26.110  73.119  1.00 63.17           C  
ATOM    515  C   GLN A  73      32.043  26.421  74.445  1.00 62.50           C  
ATOM    516  O   GLN A  73      31.654  27.560  74.694  1.00 62.68           O  
ATOM    517  CB  GLN A  73      34.136  25.478  73.353  1.00 63.37           C  
ATOM    518  CG  GLN A  73      35.073  26.269  74.241  1.00 63.82           C  
ATOM    519  CD  GLN A  73      36.166  25.411  74.858  1.00 64.67           C  
ATOM    520  OE1 GLN A  73      37.122  25.931  75.440  1.00 65.65           O  
ATOM    521  NE2 GLN A  73      36.032  24.092  74.737  1.00 64.53           N  
ATOM    522  N   VAL A  74      31.916  25.391  75.284  1.00 61.57           N  
ATOM    523  CA  VAL A  74      31.040  25.356  76.474  1.00 60.51           C  
ATOM    524  C   VAL A  74      31.038  26.580  77.411  1.00 59.64           C  
ATOM    525  O   VAL A  74      30.114  27.389  77.365  1.00 59.32           O  
ATOM    526  CB  VAL A  74      31.241  24.025  77.288  1.00 60.79           C  
ATOM    527  CG1 VAL A  74      30.570  22.848  76.574  1.00 61.07           C  
ATOM    528  CG2 VAL A  74      32.733  23.731  77.536  1.00 60.67           C  
ATOM    529  N   SER A  75      32.062  26.702  78.255  1.00 58.66           N  
ATOM    530  CA  SER A  75      32.171  27.795  79.225  1.00 57.87           C  
ATOM    531  C   SER A  75      32.289  29.178  78.586  1.00 56.91           C  
ATOM    532  O   SER A  75      31.975  30.188  79.218  1.00 56.80           O  
ATOM    533  CB  SER A  75      33.365  27.570  80.161  1.00 58.16           C  
ATOM    534  OG  SER A  75      33.077  26.568  81.123  1.00 59.24           O  
ATOM    535  N   ASP A  76      32.753  29.218  77.344  1.00 55.61           N  
ATOM    536  CA  ASP A  76      32.953  30.479  76.641  1.00 54.64           C  
ATOM    537  C   ASP A  76      31.624  30.927  76.070  1.00 53.65           C  
ATOM    538  O   ASP A  76      31.387  32.111  75.848  1.00 53.52           O  
ATOM    539  CB  ASP A  76      33.989  30.310  75.526  1.00 54.91           C  
ATOM    540  CG  ASP A  76      35.317  29.749  76.035  1.00 55.07           C  
ATOM    541  OD1 ASP A  76      35.784  30.164  77.119  1.00 54.86           O  
ATOM    542  OD2 ASP A  76      35.895  28.889  75.343  1.00 56.02           O  
ATOM    543  N   LEU A  77      30.757  29.951  75.843  1.00 52.40           N  
ATOM    544  CA  LEU A  77      29.431  30.196  75.328  1.00 51.14           C  
ATOM    545  C   LEU A  77      28.574  30.800  76.433  1.00 49.67           C  
ATOM    546  O   LEU A  77      27.915  31.819  76.243  1.00 49.13           O  
ATOM    547  CB  LEU A  77      28.844  28.880  74.832  1.00 51.25           C  
ATOM    548  CG  LEU A  77      27.750  28.901  73.775  1.00 52.60           C  
ATOM    549  CD1 LEU A  77      26.382  28.738  74.436  1.00 54.59           C  
ATOM    550  CD2 LEU A  77      27.835  30.157  72.904  1.00 52.75           C  
ATOM    551  N   ARG A  78      28.615  30.159  77.595  1.00 48.41           N  
ATOM    552  CA  ARG A  78      27.965  30.658  78.798  1.00 47.13           C  
ATOM    553  C   ARG A  78      28.461  32.054  79.125  1.00 45.68           C  
ATOM    554  O   ARG A  78      27.705  32.882  79.628  1.00 45.67           O  
ATOM    555  CB  ARG A  78      28.217  29.717  79.985  1.00 47.27           C  
ATOM    556  CG  ARG A  78      27.790  28.274  79.713  1.00 47.22           C  
ATOM    557  CD  ARG A  78      27.213  27.604  80.948  1.00 47.59           C  
ATOM    558  NE  ARG A  78      28.193  27.451  82.022  1.00 48.12           N  
ATOM    559  CZ  ARG A  78      29.028  26.423  82.153  1.00 48.87           C  
ATOM    560  NH1 ARG A  78      29.039  25.439  81.262  1.00 48.43           N  
ATOM    561  NH2 ARG A  78      29.869  26.387  83.176  1.00 49.57           N  
ATOM    562  N   PHE A  79      29.723  32.313  78.813  1.00 44.21           N  
ATOM    563  CA  PHE A  79      30.334  33.590  79.129  1.00 43.12           C  
ATOM    564  C   PHE A  79      29.744  34.707  78.291  1.00 42.26           C  
ATOM    565  O   PHE A  79      29.210  35.644  78.833  1.00 41.43           O  
ATOM    566  CB  PHE A  79      31.862  33.566  78.991  1.00 42.74           C  
ATOM    567  CG  PHE A  79      32.488  34.909  79.233  1.00 43.61           C  
ATOM    568  CD1 PHE A  79      32.743  35.346  80.533  1.00 44.59           C  
ATOM    569  CD2 PHE A  79      32.771  35.762  78.174  1.00 42.22           C  
ATOM    570  CE1 PHE A  79      33.302  36.583  80.771  1.00 44.38           C  
ATOM    571  CE2 PHE A  79      33.313  37.006  78.401  1.00 44.50           C  
ATOM    572  CZ  PHE A  79      33.587  37.422  79.702  1.00 44.82           C  
ATOM    573  N   VAL A  80      29.855  34.597  76.971  1.00 42.15           N  
ATOM    574  CA  VAL A  80      29.334  35.607  76.049  1.00 42.01           C  
ATOM    575  C   VAL A  80      27.814  35.840  76.275  1.00 42.47           C  
ATOM    576  O   VAL A  80      27.345  36.986  76.230  1.00 41.86           O  
ATOM    577  CB  VAL A  80      29.683  35.245  74.581  1.00 41.80           C  
ATOM    578  CG1 VAL A  80      28.999  36.164  73.599  1.00 41.52           C  
ATOM    579  CG2 VAL A  80      31.183  35.284  74.369  1.00 42.22           C  
ATOM    580  N   ILE A  81      27.072  34.763  76.552  1.00 42.34           N  
ATOM    581  CA  ILE A  81      25.637  34.853  76.863  1.00 43.32           C  
ATOM    582  C   ILE A  81      25.413  35.646  78.155  1.00 43.37           C  
ATOM    583  O   ILE A  81      24.453  36.394  78.274  1.00 43.71           O  
ATOM    584  CB  ILE A  81      24.982  33.442  76.983  1.00 43.77           C  
ATOM    585  CG1 ILE A  81      24.945  32.729  75.612  1.00 44.57           C  
ATOM    586  CG2 ILE A  81      23.561  33.538  77.584  1.00 44.46           C  
ATOM    587  CD1 ILE A  81      24.433  31.267  75.651  1.00 43.05           C  
ATOM    588  N   SER A  82      26.319  35.487  79.113  1.00 43.42           N  
ATOM    589  CA  SER A  82      26.243  36.189  80.385  1.00 43.52           C  
ATOM    590  C   SER A  82      26.498  37.688  80.236  1.00 43.18           C  
ATOM    591  O   SER A  82      25.879  38.484  80.915  1.00 42.73           O  
ATOM    592  CB  SER A  82      27.237  35.585  81.384  1.00 43.62           C  
ATOM    593  OG  SER A  82      26.922  34.231  81.644  1.00 45.96           O  
ATOM    594  N   ILE A  83      27.435  38.060  79.371  1.00 43.67           N  
ATOM    595  CA  ILE A  83      27.732  39.462  79.100  1.00 44.26           C  
ATOM    596  C   ILE A  83      26.532  40.121  78.388  1.00 44.95           C  
ATOM    597  O   ILE A  83      26.086  41.195  78.792  1.00 44.74           O  
ATOM    598  CB  ILE A  83      29.028  39.614  78.272  1.00 44.19           C  
ATOM    599  CG1 ILE A  83      30.260  39.074  79.042  1.00 44.42           C  
ATOM    600  CG2 ILE A  83      29.195  41.046  77.778  1.00 43.63           C  
ATOM    601  CD1 ILE A  83      30.822  39.945  80.197  1.00 43.75           C  
ATOM    602  N   MET A  84      25.986  39.449  77.375  1.00 46.10           N  
ATOM    603  CA  MET A  84      24.839  39.962  76.615  1.00 47.76           C  
ATOM    604  C   MET A  84      23.652  40.219  77.520  1.00 47.38           C  
ATOM    605  O   MET A  84      23.045  41.279  77.477  1.00 47.48           O  
ATOM    606  CB  MET A  84      24.425  38.991  75.518  1.00 47.66           C  
ATOM    607  CG  MET A  84      25.359  38.963  74.331  1.00 49.20           C  
ATOM    608  SD  MET A  84      24.572  38.272  72.849  1.00 50.35           S  
ATOM    609  CE  MET A  84      25.929  37.385  72.130  1.00 49.51           C  
ATOM    610  N   SER A  85      23.361  39.245  78.369  1.00 47.68           N  
ATOM    611  CA  SER A  85      22.257  39.326  79.308  1.00 47.66           C  
ATOM    612  C   SER A  85      22.505  40.360  80.405  1.00 47.21           C  
ATOM    613  O   SER A  85      21.604  41.083  80.781  1.00 47.69           O  
ATOM    614  CB  SER A  85      22.016  37.938  79.910  1.00 48.14           C  
ATOM    615  OG  SER A  85      21.513  38.042  81.235  1.00 51.32           O  
ATOM    616  N   SER A  86      23.730  40.433  80.910  1.00 46.36           N  
ATOM    617  CA  SER A  86      24.046  41.332  82.000  1.00 46.32           C  
ATOM    618  C   SER A  86      24.169  42.801  81.565  1.00 46.49           C  
ATOM    619  O   SER A  86      23.875  43.704  82.342  1.00 46.03           O  
ATOM    620  CB  SER A  86      25.325  40.881  82.729  1.00 46.19           C  
ATOM    621  OG  SER A  86      25.156  39.632  83.382  1.00 46.22           O  
ATOM    622  N   CYS A  87      24.607  43.055  80.337  1.00 46.94           N  
ATOM    623  CA  CYS A  87      24.773  44.455  79.921  1.00 47.38           C  
ATOM    624  C   CYS A  87      23.398  45.134  79.754  1.00 46.50           C  
ATOM    625  O   CYS A  87      23.225  46.300  80.096  1.00 46.54           O  
ATOM    626  CB  CYS A  87      25.705  44.593  78.710  1.00 46.80           C  
ATOM    627  SG  CYS A  87      25.025  44.028  77.179  1.00 53.92           S  
ATOM    628  N   SER A  88      22.424  44.356  79.293  1.00 46.03           N  
ATOM    629  CA  SER A  88      21.002  44.715  79.296  1.00 45.54           C  
ATOM    630  C   SER A  88      20.392  45.052  80.673  1.00 44.76           C  
ATOM    631  O   SER A  88      19.643  46.021  80.805  1.00 44.65           O  
ATOM    632  CB  SER A  88      20.200  43.587  78.651  1.00 45.45           C  
ATOM    633  OG  SER A  88      18.815  43.829  78.788  1.00 47.48           O  
ATOM    634  N   ASP A  89      20.680  44.237  81.678  1.00 44.34           N  
ATOM    635  CA  ASP A  89      20.249  44.505  83.050  1.00 44.37           C  
ATOM    636  C   ASP A  89      20.872  45.822  83.547  1.00 44.11           C  
ATOM    637  O   ASP A  89      20.261  46.582  84.306  1.00 43.04           O  
ATOM    638  CB  ASP A  89      20.682  43.354  83.983  1.00 44.93           C  
ATOM    639  CG  ASP A  89      19.843  42.095  83.820  1.00 45.85           C  
ATOM    640  OD1 ASP A  89      18.763  42.138  83.199  1.00 51.07           O  
ATOM    641  OD2 ASP A  89      20.245  41.039  84.347  1.00 49.90           O  
ATOM    642  N   LEU A  90      22.097  46.069  83.092  1.00 43.76           N  
ATOM    643  CA  LEU A  90      22.849  47.239  83.441  1.00 43.73           C  
ATOM    644  C   LEU A  90      22.198  48.487  82.821  1.00 43.62           C  
ATOM    645  O   LEU A  90      22.017  49.482  83.516  1.00 43.38           O  
ATOM    646  CB  LEU A  90      24.299  47.052  82.983  1.00 44.35           C  
ATOM    647  CG  LEU A  90      25.546  47.232  83.847  1.00 45.18           C  
ATOM    648  CD1 LEU A  90      25.490  46.603  85.272  1.00 45.42           C  
ATOM    649  CD2 LEU A  90      26.723  46.681  83.049  1.00 44.24           C  
ATOM    650  N   GLU A  91      21.800  48.444  81.546  1.00 43.72           N  
ATOM    651  CA  GLU A  91      21.068  49.608  81.016  1.00 43.55           C  
ATOM    652  C   GLU A  91      19.696  49.844  81.641  1.00 43.10           C  
ATOM    653  O   GLU A  91      19.217  50.975  81.667  1.00 42.91           O  
ATOM    654  CB  GLU A  91      21.200  49.846  79.474  1.00 43.73           C  
ATOM    655  CG  GLU A  91      20.089  49.615  78.479  1.00 42.64           C  
ATOM    656  CD  GLU A  91      18.709  50.153  78.829  1.00 43.03           C  
ATOM    657  OE1 GLU A  91      17.978  49.409  79.520  1.00 41.37           O  
ATOM    658  OE2 GLU A  91      18.319  51.261  78.364  1.00 40.66           O  
ATOM    659  N   ARG A  92      19.090  48.790  82.190  1.00 42.61           N  
ATOM    660  CA  ARG A  92      17.826  48.961  82.920  1.00 42.09           C  
ATOM    661  C   ARG A  92      18.098  49.567  84.298  1.00 41.09           C  
ATOM    662  O   ARG A  92      17.364  50.443  84.750  1.00 41.23           O  
ATOM    663  CB  ARG A  92      17.022  47.664  82.965  1.00 42.03           C  
ATOM    664  CG  ARG A  92      16.528  47.269  81.570  1.00 43.61           C  
ATOM    665  CD  ARG A  92      15.880  45.927  81.553  1.00 46.92           C  
ATOM    666  NE  ARG A  92      15.550  45.487  80.197  1.00 50.56           N  
ATOM    667  CZ  ARG A  92      15.056  44.283  79.910  1.00 52.57           C  
ATOM    668  NH1 ARG A  92      14.839  43.400  80.892  1.00 51.78           N  
ATOM    669  NH2 ARG A  92      14.767  43.961  78.645  1.00 51.75           N  
ATOM    670  N   MET A  93      19.176  49.126  84.936  1.00 40.13           N  
ATOM    671  CA  MET A  93      19.699  49.797  86.147  1.00 38.34           C  
ATOM    672  C   MET A  93      19.886  51.304  85.911  1.00 39.20           C  
ATOM    673  O   MET A  93      19.301  52.124  86.623  1.00 39.19           O  
ATOM    674  CB  MET A  93      20.986  49.122  86.610  1.00 38.65           C  
ATOM    675  CG  MET A  93      20.702  47.699  87.151  1.00 37.96           C  
ATOM    676  SD  MET A  93      22.140  46.655  87.419  1.00 31.68           S  
ATOM    677  CE  MET A  93      22.940  47.675  88.618  1.00 34.41           C  
ATOM    678  N   GLY A  94      20.668  51.645  84.886  1.00 39.64           N  
ATOM    679  CA  GLY A  94      20.782  53.013  84.359  1.00 39.67           C  
ATOM    680  C   GLY A  94      19.483  53.797  84.188  1.00 39.70           C  
ATOM    681  O   GLY A  94      19.385  54.924  84.644  1.00 40.33           O  
ATOM    682  N   ASP A  95      18.483  53.219  83.529  1.00 39.64           N  
ATOM    683  CA  ASP A  95      17.174  53.892  83.357  1.00 38.86           C  
ATOM    684  C   ASP A  95      16.507  54.253  84.702  1.00 38.84           C  
ATOM    685  O   ASP A  95      15.847  55.275  84.816  1.00 38.99           O  
ATOM    686  CB  ASP A  95      16.205  52.997  82.597  1.00 38.56           C  
ATOM    687  CG  ASP A  95      16.619  52.729  81.150  1.00 38.80           C  
ATOM    688  OD1 ASP A  95      17.347  53.528  80.490  1.00 33.61           O  
ATOM    689  OD2 ASP A  95      16.137  51.689  80.653  1.00 40.33           O  
ATOM    690  N   HIS A  96      16.680  53.400  85.704  1.00 38.63           N  
ATOM    691  CA  HIS A  96      16.067  53.584  87.014  1.00 38.69           C  
ATOM    692  C   HIS A  96      16.792  54.649  87.816  1.00 38.61           C  
ATOM    693  O   HIS A  96      16.201  55.284  88.688  1.00 38.95           O  
ATOM    694  CB  HIS A  96      16.008  52.259  87.798  1.00 39.06           C  
ATOM    695  CG  HIS A  96      14.830  51.411  87.441  1.00 38.31           C  
ATOM    696  ND1 HIS A  96      14.945  50.238  86.733  1.00 40.43           N  
ATOM    697  CD2 HIS A  96      13.508  51.594  87.649  1.00 39.89           C  
ATOM    698  CE1 HIS A  96      13.743  49.727  86.529  1.00 40.59           C  
ATOM    699  NE2 HIS A  96      12.852  50.532  87.075  1.00 39.96           N  
ATOM    700  N   MET A  97      18.067  54.853  87.497  1.00 37.78           N  
ATOM    701  CA  MET A  97      18.809  55.973  88.024  1.00 37.21           C  
ATOM    702  C   MET A  97      18.410  57.303  87.335  1.00 37.96           C  
ATOM    703  O   MET A  97      18.338  58.342  88.003  1.00 38.12           O  
ATOM    704  CB  MET A  97      20.317  55.688  87.985  1.00 37.03           C  
ATOM    705  CG  MET A  97      20.752  54.494  88.902  1.00 35.13           C  
ATOM    706  SD  MET A  97      20.264  54.608  90.667  1.00 30.94           S  
ATOM    707  CE  MET A  97      18.662  53.852  90.739  1.00 35.99           C  
ATOM    708  N   ALA A  98      18.142  57.273  86.025  1.00 37.79           N  
ATOM    709  CA  ALA A  98      17.554  58.430  85.327  1.00 38.27           C  
ATOM    710  C   ALA A  98      16.152  58.721  85.846  1.00 38.53           C  
ATOM    711  O   ALA A  98      15.735  59.881  85.882  1.00 39.41           O  
ATOM    712  CB  ALA A  98      17.507  58.211  83.801  1.00 38.02           C  
ATOM    713  N   GLY A  99      15.431  57.665  86.231  1.00 38.42           N  
ATOM    714  CA  GLY A  99      14.091  57.779  86.802  1.00 38.21           C  
ATOM    715  C   GLY A  99      14.085  58.546  88.111  1.00 38.38           C  
ATOM    716  O   GLY A  99      13.236  59.404  88.312  1.00 38.97           O  
ATOM    717  N   ILE A 100      15.055  58.253  88.979  1.00 38.15           N  
ATOM    718  CA  ILE A 100      15.267  58.985  90.241  1.00 37.37           C  
ATOM    719  C   ILE A 100      15.608  60.464  89.990  1.00 37.68           C  
ATOM    720  O   ILE A 100      15.135  61.365  90.696  1.00 36.91           O  
ATOM    721  CB  ILE A 100      16.382  58.334  91.093  1.00 36.63           C  
ATOM    722  CG1 ILE A 100      15.946  56.964  91.600  1.00 36.18           C  
ATOM    723  CG2 ILE A 100      16.757  59.224  92.279  1.00 36.92           C  
ATOM    724  CD1 ILE A 100      16.914  56.315  92.630  1.00 36.73           C  
ATOM    725  N   ALA A 101      16.430  60.700  88.976  1.00 37.99           N  
ATOM    726  CA  ALA A 101      16.750  62.052  88.563  1.00 38.62           C  
ATOM    727  C   ALA A 101      15.503  62.805  88.107  1.00 38.72           C  
ATOM    728  O   ALA A 101      15.361  63.975  88.425  1.00 39.23           O  
ATOM    729  CB  ALA A 101      17.831  62.046  87.475  1.00 38.95           C  
ATOM    730  N   LYS A 102      14.595  62.135  87.391  1.00 39.16           N  
ATOM    731  CA  LYS A 102      13.320  62.750  86.984  1.00 39.59           C  
ATOM    732  C   LYS A 102      12.416  63.081  88.172  1.00 39.51           C  
ATOM    733  O   LYS A 102      11.793  64.138  88.201  1.00 39.49           O  
ATOM    734  CB  LYS A 102      12.558  61.874  85.989  1.00 39.97           C  
ATOM    735  CG  LYS A 102      13.329  61.530  84.731  1.00 41.60           C  
ATOM    736  CD  LYS A 102      12.449  60.785  83.748  1.00 43.63           C  
ATOM    737  CE  LYS A 102      13.263  60.223  82.598  1.00 44.65           C  
ATOM    738  NZ  LYS A 102      12.383  59.851  81.458  1.00 45.32           N  
ATOM    739  N   ALA A 103      12.347  62.179  89.148  1.00 39.52           N  
ATOM    740  CA  ALA A 103      11.579  62.428  90.366  1.00 39.66           C  
ATOM    741  C   ALA A 103      12.124  63.629  91.163  1.00 39.98           C  
ATOM    742  O   ALA A 103      11.363  64.323  91.825  1.00 40.19           O  
ATOM    743  CB  ALA A 103      11.531  61.178  91.233  1.00 39.09           C  
ATOM    744  N   VAL A 104      13.436  63.861  91.088  1.00 40.30           N  
ATOM    745  CA  VAL A 104      14.083  64.997  91.748  1.00 40.62           C  
ATOM    746  C   VAL A 104      13.624  66.325  91.143  1.00 41.27           C  
ATOM    747  O   VAL A 104      13.576  67.335  91.836  1.00 41.72           O  
ATOM    748  CB  VAL A 104      15.641  64.874  91.726  1.00 40.39           C  
ATOM    749  CG1 VAL A 104      16.319  66.196  92.120  1.00 39.89           C  
ATOM    750  CG2 VAL A 104      16.108  63.734  92.638  1.00 39.30           C  
ATOM    751  N   LEU A 105      13.280  66.312  89.858  1.00 42.03           N  
ATOM    752  CA  LEU A 105      12.780  67.508  89.167  1.00 42.56           C  
ATOM    753  C   LEU A 105      11.340  67.833  89.561  1.00 42.92           C  
ATOM    754  O   LEU A 105      10.877  68.958  89.383  1.00 43.18           O  
ATOM    755  CB  LEU A 105      12.845  67.331  87.646  1.00 42.49           C  
ATOM    756  CG  LEU A 105      14.156  66.990  86.939  1.00 42.41           C  
ATOM    757  CD1 LEU A 105      13.881  66.802  85.453  1.00 42.31           C  
ATOM    758  CD2 LEU A 105      15.200  68.064  87.161  1.00 42.82           C  
ATOM    759  N   GLN A 106      10.645  66.838  90.094  1.00 43.49           N  
ATOM    760  CA  GLN A 106       9.250  66.975  90.474  1.00 44.26           C  
ATOM    761  C   GLN A 106       9.111  67.312  91.956  1.00 44.86           C  
ATOM    762  O   GLN A 106       8.006  67.598  92.439  1.00 44.78           O  
ATOM    763  CB  GLN A 106       8.479  65.696  90.122  1.00 44.25           C  
ATOM    764  CG  GLN A 106       8.532  65.315  88.638  1.00 44.37           C  
ATOM    765  CD  GLN A 106       7.852  66.343  87.745  1.00 45.03           C  
ATOM    766  OE1 GLN A 106       6.633  66.344  87.597  1.00 45.65           O  
ATOM    767  NE2 GLN A 106       8.646  67.218  87.139  1.00 44.78           N  
ATOM    768  N   LEU A 107      10.236  67.289  92.668  1.00 45.57           N  
ATOM    769  CA  LEU A 107      10.238  67.600  94.091  1.00 46.57           C  
ATOM    770  C   LEU A 107      10.041  69.093  94.367  1.00 47.50           C  
ATOM    771  O   LEU A 107      10.639  69.951  93.712  1.00 47.28           O  
ATOM    772  CB  LEU A 107      11.507  67.081  94.776  1.00 46.10           C  
ATOM    773  CG  LEU A 107      11.611  65.566  95.007  1.00 45.83           C  
ATOM    774  CD1 LEU A 107      12.919  65.212  95.704  1.00 44.45           C  
ATOM    775  CD2 LEU A 107      10.423  65.030  95.802  1.00 44.98           C  
ATOM    776  N   LYS A 108       9.181  69.380  95.338  1.00 48.92           N  
ATOM    777  CA  LYS A 108       8.924  70.745  95.786  1.00 50.49           C  
ATOM    778  C   LYS A 108       9.429  70.914  97.209  1.00 51.57           C  
ATOM    779  O   LYS A 108       9.297  70.013  98.044  1.00 51.49           O  
ATOM    780  CB  LYS A 108       7.429  71.082  95.712  1.00 50.33           C  
ATOM    781  CG  LYS A 108       6.779  70.854  94.348  1.00 50.42           C  
ATOM    782  CD  LYS A 108       7.119  71.964  93.355  1.00 50.72           C  
ATOM    783  CE  LYS A 108       6.292  71.845  92.078  1.00 50.95           C  
ATOM    784  NZ  LYS A 108       6.643  70.635  91.278  1.00 50.75           N  
ATOM    785  N   GLU A 109      10.016  72.075  97.474  1.00 53.21           N  
ATOM    786  CA  GLU A 109      10.540  72.391  98.790  1.00 54.78           C  
ATOM    787  C   GLU A 109      10.315  73.858  99.116  1.00 55.85           C  
ATOM    788  O   GLU A 109      11.043  74.706  98.596  1.00 56.13           O  
ATOM    789  CB  GLU A 109      12.035  72.076  98.867  1.00 54.87           C  
ATOM    790  CG  GLU A 109      12.366  70.699  99.421  1.00 55.56           C  
ATOM    791  CD  GLU A 109      13.395  70.772 100.536  1.00 56.08           C  
ATOM    792  OE1 GLU A 109      13.214  71.598 101.466  1.00 56.33           O  
ATOM    793  OE2 GLU A 109      14.375  70.000 100.490  1.00 56.21           O  
ATOM    794  N   ASN A 110       9.310  74.194  99.937  1.00 57.17           N  
ATOM    795  CA  ASN A 110       8.229  73.304 100.433  1.00 58.26           C  
ATOM    796  C   ASN A 110       8.580  72.056 101.279  1.00 59.01           C  
ATOM    797  O   ASN A 110       9.682  71.962 101.839  1.00 59.25           O  
ATOM    798  CB  ASN A 110       7.227  72.970  99.306  1.00 58.13           C  
ATOM    799  CG  ASN A 110       6.467  74.196  98.811  1.00 58.18           C  
ATOM    800  OD1 ASN A 110       6.421  75.236  99.477  1.00 57.55           O  
ATOM    801  ND2 ASN A 110       5.865  74.077  97.634  1.00 58.04           N  
ATOM    802  N   GLN A 111       7.628  71.124 101.372  1.00 59.74           N  
ATOM    803  CA  GLN A 111       7.677  69.989 102.307  1.00 60.42           C  
ATOM    804  C   GLN A 111       6.702  68.893 101.826  1.00 60.73           C  
ATOM    805  O   GLN A 111       5.786  69.207 101.066  1.00 60.96           O  
ATOM    806  CB  GLN A 111       7.286  70.468 103.716  1.00 60.51           C  
ATOM    807  CG  GLN A 111       5.894  71.106 103.808  1.00 60.77           C  
ATOM    808  CD  GLN A 111       5.276  71.007 105.196  1.00 61.38           C  
ATOM    809  OE1 GLN A 111       4.224  70.391 105.373  1.00 61.48           O  
ATOM    810  NE2 GLN A 111       5.924  71.619 106.186  1.00 61.80           N  
ATOM    811  N   LEU A 112       6.855  67.627 102.241  1.00 61.06           N  
ATOM    812  CA  LEU A 112       7.906  67.116 103.141  1.00 61.31           C  
ATOM    813  C   LEU A 112       8.345  65.706 102.714  1.00 61.32           C  
ATOM    814  O   LEU A 112       7.817  65.156 101.744  1.00 61.38           O  
ATOM    815  CB  LEU A 112       7.434  67.112 104.611  1.00 61.37           C  
ATOM    816  CG  LEU A 112       5.980  66.770 104.986  1.00 61.61           C  
ATOM    817  CD1 LEU A 112       5.669  65.280 104.838  1.00 62.46           C  
ATOM    818  CD2 LEU A 112       5.666  67.240 106.398  1.00 61.59           C  
ATOM    819  N   ALA A 113       9.307  65.137 103.444  1.00 61.30           N  
ATOM    820  CA  ALA A 113       9.845  63.803 103.157  1.00 61.18           C  
ATOM    821  C   ALA A 113       8.869  62.685 103.510  1.00 61.04           C  
ATOM    822  O   ALA A 113       9.101  61.516 103.183  1.00 60.99           O  
ATOM    823  CB  ALA A 113      11.172  63.599 103.889  1.00 61.23           C  
ATOM    824  N   GLU A 116      14.082  60.177 105.188  1.00 40.97           N  
ATOM    825  CA  GLU A 116      15.278  60.678 104.512  1.00 40.76           C  
ATOM    826  C   GLU A 116      16.514  59.789 104.730  1.00 40.03           C  
ATOM    827  O   GLU A 116      17.110  59.305 103.763  1.00 39.72           O  
ATOM    828  CB  GLU A 116      15.578  62.128 104.935  1.00 41.31           C  
ATOM    829  CG  GLU A 116      16.347  62.937 103.877  1.00 43.16           C  
ATOM    830  CD  GLU A 116      15.745  62.795 102.468  1.00 46.82           C  
ATOM    831  OE1 GLU A 116      14.667  63.381 102.207  1.00 47.49           O  
ATOM    832  OE2 GLU A 116      16.350  62.088 101.627  1.00 47.89           O  
ATOM    833  N   GLU A 117      16.895  59.593 105.993  1.00 39.02           N  
ATOM    834  CA  GLU A 117      18.054  58.768 106.341  1.00 38.14           C  
ATOM    835  C   GLU A 117      17.903  57.269 106.033  1.00 38.01           C  
ATOM    836  O   GLU A 117      18.864  56.622 105.603  1.00 37.44           O  
ATOM    837  CB  GLU A 117      18.476  58.994 107.807  1.00 38.32           C  
ATOM    838  CG  GLU A 117      18.984  60.403 108.119  1.00 36.36           C  
ATOM    839  CD  GLU A 117      20.055  60.894 107.147  1.00 35.14           C  
ATOM    840  OE1 GLU A 117      20.984  60.112 106.796  1.00 31.07           O  
ATOM    841  OE2 GLU A 117      19.969  62.078 106.733  1.00 36.59           O  
ATOM    842  N   GLN A 118      16.704  56.729 106.242  1.00 38.00           N  
ATOM    843  CA  GLN A 118      16.370  55.371 105.780  1.00 38.40           C  
ATOM    844  C   GLN A 118      16.584  55.214 104.269  1.00 38.11           C  
ATOM    845  O   GLN A 118      17.143  54.218 103.801  1.00 38.29           O  
ATOM    846  CB  GLN A 118      14.926  55.019 106.123  1.00 38.74           C  
ATOM    847  CG  GLN A 118      14.716  54.422 107.511  1.00 40.23           C  
ATOM    848  CD  GLN A 118      13.594  53.378 107.517  1.00 42.20           C  
ATOM    849  OE1 GLN A 118      13.679  52.362 106.834  1.00 41.82           O  
ATOM    850  NE2 GLN A 118      12.545  53.632 108.293  1.00 43.63           N  
ATOM    851  N   LEU A 119      16.145  56.220 103.521  1.00 37.82           N  
ATOM    852  CA  LEU A 119      16.333  56.294 102.083  1.00 37.55           C  
ATOM    853  C   LEU A 119      17.812  56.321 101.670  1.00 37.04           C  
ATOM    854  O   LEU A 119      18.204  55.678 100.685  1.00 36.73           O  
ATOM    855  CB  LEU A 119      15.607  57.529 101.550  1.00 37.76           C  
ATOM    856  CG  LEU A 119      15.127  57.384 100.109  1.00 40.34           C  
ATOM    857  CD1 LEU A 119      13.765  58.049  99.924  1.00 41.13           C  
ATOM    858  CD2 LEU A 119      16.174  57.939  99.150  1.00 41.44           C  
ATOM    859  N   HIS A 120      18.611  57.086 102.422  1.00 36.36           N  
ATOM    860  CA  HIS A 120      20.068  57.146 102.279  1.00 36.00           C  
ATOM    861  C   HIS A 120      20.656  55.754 102.492  1.00 35.59           C  
ATOM    862  O   HIS A 120      21.595  55.362 101.813  1.00 35.33           O  
ATOM    863  CB  HIS A 120      20.692  58.135 103.308  1.00 35.99           C  
ATOM    864  CG  HIS A 120      20.442  59.588 103.013  1.00 36.35           C  
ATOM    865  ND1 HIS A 120      21.059  60.608 103.712  1.00 39.71           N  
ATOM    866  CD2 HIS A 120      19.668  60.193 102.081  1.00 38.22           C  
ATOM    867  CE1 HIS A 120      20.657  61.774 103.240  1.00 39.24           C  
ATOM    868  NE2 HIS A 120      19.813  61.550 102.249  1.00 38.95           N  
ATOM    869  N   GLN A 121      20.100  55.018 103.451  1.00 35.76           N  
ATOM    870  CA  GLN A 121      20.583  53.679 103.778  1.00 35.83           C  
ATOM    871  C   GLN A 121      20.252  52.674 102.689  1.00 35.59           C  
ATOM    872  O   GLN A 121      21.110  51.888 102.299  1.00 35.48           O  
ATOM    873  CB  GLN A 121      20.047  53.205 105.124  1.00 36.11           C  
ATOM    874  CG  GLN A 121      20.558  54.013 106.316  1.00 37.09           C  
ATOM    875  CD  GLN A 121      22.068  54.052 106.398  1.00 38.89           C  
ATOM    876  OE1 GLN A 121      22.736  53.037 106.183  1.00 41.23           O  
ATOM    877  NE2 GLN A 121      22.621  55.223 106.713  1.00 36.99           N  
ATOM    878  N   MET A 122      19.013  52.712 102.196  1.00 35.41           N  
ATOM    879  CA  MET A 122      18.596  51.886 101.072  1.00 33.98           C  
ATOM    880  C   MET A 122      19.493  52.195  99.883  1.00 35.86           C  
ATOM    881  O   MET A 122      19.902  51.286  99.143  1.00 35.58           O  
ATOM    882  CB  MET A 122      17.124  52.161 100.733  1.00 34.86           C  
ATOM    883  CG  MET A 122      16.537  51.347  99.566  1.00 32.77           C  
ATOM    884  SD  MET A 122      14.772  51.641  99.263  1.00 28.94           S  
ATOM    885  CE  MET A 122      14.753  53.375  99.019  1.00 35.01           C  
ATOM    886  N   GLY A 123      19.810  53.480  99.715  1.00 36.50           N  
ATOM    887  CA  GLY A 123      20.682  53.927  98.633  1.00 37.70           C  
ATOM    888  C   GLY A 123      22.104  53.418  98.753  1.00 38.69           C  
ATOM    889  O   GLY A 123      22.668  52.918  97.780  1.00 39.47           O  
ATOM    890  N   LYS A 124      22.677  53.548  99.950  1.00 39.63           N  
ATOM    891  CA  LYS A 124      24.034  53.083 100.274  1.00 40.19           C  
ATOM    892  C   LYS A 124      24.191  51.560 100.058  1.00 40.67           C  
ATOM    893  O   LYS A 124      25.224  51.108  99.560  1.00 40.69           O  
ATOM    894  CB  LYS A 124      24.420  53.484 101.725  1.00 40.09           C  
ATOM    895  CG  LYS A 124      24.688  55.014 101.972  1.00 41.05           C  
ATOM    896  CD  LYS A 124      24.781  55.448 103.503  1.00 40.09           C  
ATOM    897  CE  LYS A 124      24.786  57.018 103.686  1.00 40.82           C  
ATOM    898  NZ  LYS A 124      24.321  57.694 105.048  1.00 38.05           N  
ATOM    899  N   LEU A 125      23.177  50.777 100.427  1.00 41.35           N  
ATOM    900  CA  LEU A 125      23.230  49.315 100.251  1.00 42.07           C  
ATOM    901  C   LEU A 125      23.105  48.924  98.772  1.00 42.71           C  
ATOM    902  O   LEU A 125      23.774  48.001  98.302  1.00 43.47           O  
ATOM    903  CB  LEU A 125      22.193  48.590 101.129  1.00 42.06           C  
ATOM    904  CG  LEU A 125      22.068  47.045 101.044  1.00 42.34           C  
ATOM    905  CD1 LEU A 125      23.317  46.269 101.512  1.00 42.25           C  
ATOM    906  CD2 LEU A 125      20.853  46.546 101.803  1.00 42.07           C  
ATOM    907  N   SER A 126      22.280  49.659  98.033  1.00 42.89           N  
ATOM    908  CA  SER A 126      22.183  49.510  96.583  1.00 42.41           C  
ATOM    909  C   SER A 126      23.542  49.736  95.905  1.00 42.39           C  
ATOM    910  O   SER A 126      24.006  48.904  95.122  1.00 42.75           O  
ATOM    911  CB  SER A 126      21.127  50.473  96.024  1.00 42.16           C  
ATOM    912  OG  SER A 126      19.823  50.071  96.426  1.00 41.79           O  
ATOM    913  N   LEU A 127      24.172  50.861  96.209  1.00 42.36           N  
ATOM    914  CA  LEU A 127      25.478  51.186  95.643  1.00 42.45           C  
ATOM    915  C   LEU A 127      26.530  50.125  95.963  1.00 42.46           C  
ATOM    916  O   LEU A 127      27.264  49.705  95.077  1.00 43.42           O  
ATOM    917  CB  LEU A 127      25.958  52.539  96.143  1.00 41.99           C  
ATOM    918  CG  LEU A 127      25.233  53.781  95.618  1.00 42.98           C  
ATOM    919  CD1 LEU A 127      25.977  55.035  96.118  1.00 38.72           C  
ATOM    920  CD2 LEU A 127      25.164  53.777  94.101  1.00 41.55           C  
ATOM    921  N   SER A 128      26.599  49.685  97.215  1.00 41.66           N  
ATOM    922  CA  SER A 128      27.687  48.806  97.597  1.00 41.48           C  
ATOM    923  C   SER A 128      27.496  47.417  96.998  1.00 40.79           C  
ATOM    924  O   SER A 128      28.466  46.748  96.676  1.00 41.25           O  
ATOM    925  CB  SER A 128      27.894  48.768  99.113  1.00 41.05           C  
ATOM    926  OG  SER A 128      26.954  47.931  99.735  1.00 42.63           O  
ATOM    927  N   MET A 129      26.244  47.019  96.817  1.00 40.54           N  
ATOM    928  CA  MET A 129      25.893  45.793  96.096  1.00 38.95           C  
ATOM    929  C   MET A 129      26.483  45.805  94.685  1.00 40.37           C  
ATOM    930  O   MET A 129      27.074  44.806  94.262  1.00 40.74           O  
ATOM    931  CB  MET A 129      24.373  45.600  96.041  1.00 39.27           C  
ATOM    932  CG  MET A 129      23.726  44.886  97.258  1.00 37.46           C  
ATOM    933  SD  MET A 129      21.880  44.949  97.219  1.00 34.02           S  
ATOM    934  CE  MET A 129      21.555  43.720  95.971  1.00 35.80           C  
ATOM    935  N   LEU A 130      26.341  46.921  93.957  1.00 40.70           N  
ATOM    936  CA  LEU A 130      26.902  47.006  92.609  1.00 41.19           C  
ATOM    937  C   LEU A 130      28.429  47.034  92.627  1.00 41.89           C  
ATOM    938  O   LEU A 130      29.068  46.381  91.802  1.00 42.89           O  
ATOM    939  CB  LEU A 130      26.373  48.227  91.859  1.00 41.26           C  
ATOM    940  CG  LEU A 130      26.834  48.392  90.410  1.00 40.67           C  
ATOM    941  CD1 LEU A 130      26.494  47.125  89.576  1.00 39.34           C  
ATOM    942  CD2 LEU A 130      26.201  49.620  89.776  1.00 42.16           C  
ATOM    943  N   ALA A 131      29.008  47.795  93.551  1.00 41.91           N  
ATOM    944  CA  ALA A 131      30.464  47.901  93.669  1.00 42.57           C  
ATOM    945  C   ALA A 131      31.077  46.539  93.999  1.00 42.79           C  
ATOM    946  O   ALA A 131      32.108  46.153  93.444  1.00 42.77           O  
ATOM    947  CB  ALA A 131      30.838  48.931  94.719  1.00 42.02           C  
ATOM    948  N   ASP A 132      30.438  45.821  94.915  1.00 43.50           N  
ATOM    949  CA  ASP A 132      30.813  44.432  95.213  1.00 44.45           C  
ATOM    950  C   ASP A 132      30.720  43.529  93.978  1.00 44.18           C  
ATOM    951  O   ASP A 132      31.659  42.810  93.662  1.00 44.69           O  
ATOM    952  CB  ASP A 132      29.961  43.869  96.356  1.00 44.33           C  
ATOM    953  CG  ASP A 132      30.297  44.505  97.717  1.00 46.77           C  
ATOM    954  OD1 ASP A 132      31.303  45.238  97.854  1.00 46.17           O  
ATOM    955  OD2 ASP A 132      29.529  44.264  98.670  1.00 52.11           O  
ATOM    956  N   LEU A 133      29.612  43.625  93.254  1.00 44.53           N  
ATOM    957  CA  LEU A 133      29.403  42.844  92.040  1.00 44.53           C  
ATOM    958  C   LEU A 133      30.512  43.078  91.016  1.00 44.42           C  
ATOM    959  O   LEU A 133      31.063  42.127  90.482  1.00 45.07           O  
ATOM    960  CB  LEU A 133      28.028  43.130  91.427  1.00 44.23           C  
ATOM    961  CG  LEU A 133      27.713  42.454  90.076  1.00 44.98           C  
ATOM    962  CD1 LEU A 133      27.750  40.909  90.193  1.00 43.86           C  
ATOM    963  CD2 LEU A 133      26.384  42.909  89.505  1.00 44.55           C  
ATOM    964  N   LEU A 134      30.839  44.338  90.756  1.00 44.06           N  
ATOM    965  CA  LEU A 134      31.914  44.683  89.816  1.00 43.84           C  
ATOM    966  C   LEU A 134      33.284  44.109  90.170  1.00 43.36           C  
ATOM    967  O   LEU A 134      34.021  43.706  89.279  1.00 43.49           O  
ATOM    968  CB  LEU A 134      31.989  46.199  89.571  1.00 43.09           C  
ATOM    969  CG  LEU A 134      30.686  46.786  89.010  1.00 43.00           C  
ATOM    970  CD1 LEU A 134      30.906  48.225  88.594  1.00 43.94           C  
ATOM    971  CD2 LEU A 134      30.117  45.981  87.839  1.00 42.41           C  
ATOM    972  N   VAL A 135      33.625  44.074  91.456  1.00 43.54           N  
ATOM    973  CA  VAL A 135      34.851  43.400  91.920  1.00 43.33           C  
ATOM    974  C   VAL A 135      34.712  41.863  91.803  1.00 43.46           C  
ATOM    975  O   VAL A 135      35.637  41.185  91.353  1.00 43.27           O  
ATOM    976  CB  VAL A 135      35.202  43.779  93.386  1.00 43.48           C  
ATOM    977  CG1 VAL A 135      36.417  43.005  93.888  1.00 42.22           C  
ATOM    978  CG2 VAL A 135      35.433  45.289  93.524  1.00 43.80           C  
ATOM    979  N   ALA A 136      33.561  41.330  92.218  1.00 43.10           N  
ATOM    980  CA  ALA A 136      33.313  39.885  92.192  1.00 43.29           C  
ATOM    981  C   ALA A 136      33.230  39.282  90.779  1.00 43.73           C  
ATOM    982  O   ALA A 136      33.613  38.143  90.576  1.00 43.64           O  
ATOM    983  CB  ALA A 136      32.041  39.552  92.970  1.00 43.21           C  
ATOM    984  N   PHE A 137      32.735  40.047  89.808  1.00 44.21           N  
ATOM    985  CA  PHE A 137      32.400  39.499  88.490  1.00 44.82           C  
ATOM    986  C   PHE A 137      33.585  38.824  87.747  1.00 45.02           C  
ATOM    987  O   PHE A 137      33.432  37.701  87.273  1.00 45.15           O  
ATOM    988  CB  PHE A 137      31.692  40.559  87.629  1.00 44.34           C  
ATOM    989  CG  PHE A 137      31.016  40.007  86.423  1.00 44.98           C  
ATOM    990  CD1 PHE A 137      29.626  39.899  86.379  1.00 45.40           C  
ATOM    991  CD2 PHE A 137      31.756  39.609  85.299  1.00 46.85           C  
ATOM    992  CE1 PHE A 137      28.972  39.368  85.242  1.00 43.50           C  
ATOM    993  CE2 PHE A 137      31.106  39.064  84.158  1.00 45.10           C  
ATOM    994  CZ  PHE A 137      29.713  38.954  84.138  1.00 43.54           C  
ATOM    995  N   PRO A 138      34.754  39.501  87.636  1.00 45.18           N  
ATOM    996  CA  PRO A 138      35.957  38.898  86.993  1.00 45.59           C  
ATOM    997  C   PRO A 138      36.446  37.592  87.630  1.00 46.16           C  
ATOM    998  O   PRO A 138      37.119  36.797  86.968  1.00 45.81           O  
ATOM    999  CB  PRO A 138      37.048  39.976  87.161  1.00 45.25           C  
ATOM   1000  CG  PRO A 138      36.340  41.218  87.416  1.00 45.66           C  
ATOM   1001  CD  PRO A 138      35.012  40.885  88.069  1.00 45.17           C  
ATOM   1002  N   LEU A 139      36.122  37.391  88.906  1.00 47.24           N  
ATOM   1003  CA  LEU A 139      36.455  36.159  89.614  1.00 48.61           C  
ATOM   1004  C   LEU A 139      35.590  34.986  89.183  1.00 49.05           C  
ATOM   1005  O   LEU A 139      36.018  33.842  89.251  1.00 49.53           O  
ATOM   1006  CB  LEU A 139      36.404  36.360  91.130  1.00 48.52           C  
ATOM   1007  CG  LEU A 139      37.464  37.346  91.646  1.00 49.32           C  
ATOM   1008  CD1 LEU A 139      37.111  37.873  93.016  1.00 49.69           C  
ATOM   1009  CD2 LEU A 139      38.874  36.741  91.649  1.00 49.38           C  
ATOM   1010  N   HIS A 140      34.390  35.270  88.693  1.00 50.21           N  
ATOM   1011  CA  HIS A 140      33.449  34.214  88.285  1.00 51.40           C  
ATOM   1012  C   HIS A 140      33.075  33.264  89.449  1.00 51.55           C  
ATOM   1013  O   HIS A 140      32.655  32.131  89.224  1.00 52.42           O  
ATOM   1014  CB  HIS A 140      34.000  33.415  87.085  1.00 51.54           C  
ATOM   1015  CG  HIS A 140      34.411  34.259  85.917  1.00 52.59           C  
ATOM   1016  ND1 HIS A 140      33.774  35.438  85.580  1.00 53.16           N  
ATOM   1017  CD2 HIS A 140      35.382  34.078  84.987  1.00 52.51           C  
ATOM   1018  CE1 HIS A 140      34.349  35.952  84.507  1.00 52.86           C  
ATOM   1019  NE2 HIS A 140      35.324  35.146  84.125  1.00 52.92           N  
ATOM   1020  N   GLN A 141      33.228  33.757  90.677  1.00 51.47           N  
ATOM   1021  CA  GLN A 141      32.930  33.053  91.928  1.00 50.83           C  
ATOM   1022  C   GLN A 141      31.408  33.045  92.214  1.00 50.45           C  
ATOM   1023  O   GLN A 141      30.861  34.068  92.655  1.00 50.52           O  
ATOM   1024  CB  GLN A 141      33.611  33.825  93.064  1.00 51.08           C  
ATOM   1025  CG  GLN A 141      34.336  33.002  94.091  1.00 51.90           C  
ATOM   1026  CD  GLN A 141      35.798  32.835  93.759  1.00 52.66           C  
ATOM   1027  OE1 GLN A 141      36.667  33.382  94.450  1.00 54.97           O  
ATOM   1028  NE2 GLN A 141      36.088  32.085  92.703  1.00 51.51           N  
ATOM   1029  N   ALA A 142      30.739  31.911  91.990  1.00 49.23           N  
ATOM   1030  CA  ALA A 142      29.314  31.753  92.327  1.00 48.18           C  
ATOM   1031  C   ALA A 142      28.952  32.259  93.730  1.00 47.42           C  
ATOM   1032  O   ALA A 142      27.947  32.942  93.910  1.00 47.27           O  
ATOM   1033  CB  ALA A 142      28.878  30.297  92.161  1.00 48.25           C  
ATOM   1034  N   SER A 143      29.792  31.951  94.711  1.00 46.83           N  
ATOM   1035  CA  SER A 143      29.512  32.270  96.118  1.00 46.19           C  
ATOM   1036  C   SER A 143      29.532  33.748  96.476  1.00 46.00           C  
ATOM   1037  O   SER A 143      28.700  34.200  97.255  1.00 45.91           O  
ATOM   1038  CB  SER A 143      30.458  31.510  97.029  1.00 45.84           C  
ATOM   1039  OG  SER A 143      30.450  30.155  96.647  1.00 44.23           O  
ATOM   1040  N   LYS A 144      30.469  34.500  95.920  1.00 45.94           N  
ATOM   1041  CA  LYS A 144      30.429  35.944  96.108  1.00 46.45           C  
ATOM   1042  C   LYS A 144      29.161  36.526  95.446  1.00 45.87           C  
ATOM   1043  O   LYS A 144      28.493  37.368  96.041  1.00 46.39           O  
ATOM   1044  CB  LYS A 144      31.724  36.644  95.634  1.00 46.82           C  
ATOM   1045  CG  LYS A 144      33.025  35.928  96.039  1.00 48.36           C  
ATOM   1046  CD  LYS A 144      34.171  36.893  96.412  1.00 52.37           C  
ATOM   1047  CE  LYS A 144      34.489  37.872  95.274  1.00 53.86           C  
ATOM   1048  NZ  LYS A 144      35.254  39.088  95.745  1.00 54.01           N  
ATOM   1049  N   ALA A 145      28.806  36.042  94.253  1.00 44.98           N  
ATOM   1050  CA  ALA A 145      27.551  36.440  93.596  1.00 44.08           C  
ATOM   1051  C   ALA A 145      26.345  36.198  94.494  1.00 43.62           C  
ATOM   1052  O   ALA A 145      25.544  37.098  94.708  1.00 43.27           O  
ATOM   1053  CB  ALA A 145      27.371  35.720  92.260  1.00 43.97           C  
ATOM   1054  N   ILE A 146      26.239  34.977  95.023  1.00 43.71           N  
ATOM   1055  CA  ILE A 146      25.129  34.561  95.885  1.00 43.65           C  
ATOM   1056  C   ILE A 146      25.014  35.419  97.154  1.00 44.50           C  
ATOM   1057  O   ILE A 146      23.905  35.841  97.516  1.00 44.40           O  
ATOM   1058  CB  ILE A 146      25.238  33.063  96.253  1.00 43.29           C  
ATOM   1059  CG1 ILE A 146      24.987  32.197  95.014  1.00 42.35           C  
ATOM   1060  CG2 ILE A 146      24.276  32.701  97.392  1.00 42.82           C  
ATOM   1061  CD1 ILE A 146      25.341  30.731  95.190  1.00 37.82           C  
ATOM   1062  N   SER A 147      26.144  35.676  97.821  1.00 44.97           N  
ATOM   1063  CA  SER A 147      26.139  36.548  98.991  1.00 46.63           C  
ATOM   1064  C   SER A 147      25.670  37.983  98.658  1.00 46.92           C  
ATOM   1065  O   SER A 147      24.907  38.574  99.429  1.00 47.09           O  
ATOM   1066  CB  SER A 147      27.492  36.530  99.716  1.00 46.64           C  
ATOM   1067  OG  SER A 147      28.506  37.072  98.886  1.00 50.41           O  
ATOM   1068  N   ILE A 148      26.080  38.518  97.504  1.00 47.41           N  
ATOM   1069  CA  ILE A 148      25.582  39.827  97.039  1.00 47.83           C  
ATOM   1070  C   ILE A 148      24.065  39.851  96.795  1.00 48.63           C  
ATOM   1071  O   ILE A 148      23.369  40.772  97.258  1.00 48.71           O  
ATOM   1072  CB  ILE A 148      26.334  40.325  95.780  1.00 48.22           C  
ATOM   1073  CG1 ILE A 148      27.814  40.594  96.118  1.00 47.62           C  
ATOM   1074  CG2 ILE A 148      25.658  41.587  95.185  1.00 46.27           C  
ATOM   1075  CD1 ILE A 148      28.709  40.625  94.908  1.00 47.55           C  
ATOM   1076  N   ALA A 149      23.564  38.840  96.077  1.00 48.94           N  
ATOM   1077  CA  ALA A 149      22.133  38.697  95.785  1.00 49.28           C  
ATOM   1078  C   ALA A 149      21.299  38.696  97.054  1.00 49.71           C  
ATOM   1079  O   ALA A 149      20.215  39.274  97.074  1.00 50.11           O  
ATOM   1080  CB  ALA A 149      21.852  37.422  94.968  1.00 48.34           C  
ATOM   1081  N   GLN A 150      21.812  38.044  98.098  1.00 50.16           N  
ATOM   1082  CA  GLN A 150      21.123  37.899  99.387  1.00 50.81           C  
ATOM   1083  C   GLN A 150      20.812  39.221 100.093  1.00 50.50           C  
ATOM   1084  O   GLN A 150      19.814  39.322 100.808  1.00 50.43           O  
ATOM   1085  CB  GLN A 150      21.946  37.010 100.322  1.00 50.77           C  
ATOM   1086  CG  GLN A 150      21.881  35.536  99.973  1.00 52.02           C  
ATOM   1087  CD  GLN A 150      22.789  34.679 100.838  1.00 52.41           C  
ATOM   1088  OE1 GLN A 150      23.889  35.098 101.226  1.00 54.42           O  
ATOM   1089  NE2 GLN A 150      22.332  33.463 101.142  1.00 53.74           N  
ATOM   1090  N   LYS A 151      21.672  40.223  99.899  1.00 50.35           N  
ATOM   1091  CA  LYS A 151      21.449  41.563 100.466  1.00 50.38           C  
ATOM   1092  C   LYS A 151      20.206  42.279  99.925  1.00 49.79           C  
ATOM   1093  O   LYS A 151      19.778  43.277 100.491  1.00 49.25           O  
ATOM   1094  CB  LYS A 151      22.685  42.441 100.293  1.00 50.41           C  
ATOM   1095  CG  LYS A 151      23.870  41.964 101.108  1.00 51.81           C  
ATOM   1096  CD  LYS A 151      25.104  42.809 100.816  1.00 54.66           C  
ATOM   1097  CE  LYS A 151      26.273  42.366 101.685  1.00 55.16           C  
ATOM   1098  NZ  LYS A 151      27.244  43.476 101.836  1.00 56.50           N  
ATOM   1099  N   ASP A 152      19.637  41.758  98.840  1.00 49.47           N  
ATOM   1100  CA  ASP A 152      18.385  42.279  98.286  1.00 49.33           C  
ATOM   1101  C   ASP A 152      17.197  42.110  99.233  1.00 49.48           C  
ATOM   1102  O   ASP A 152      16.285  42.938  99.214  1.00 49.51           O  
ATOM   1103  CB  ASP A 152      18.082  41.644  96.926  1.00 49.54           C  
ATOM   1104  CG  ASP A 152      17.008  42.391  96.153  1.00 49.25           C  
ATOM   1105  OD1 ASP A 152      17.131  43.613  95.944  1.00 46.84           O  
ATOM   1106  OD2 ASP A 152      16.032  41.738  95.747  1.00 50.82           O  
ATOM   1107  N   GLU A 153      17.201  41.049 100.050  1.00 49.45           N  
ATOM   1108  CA  GLU A 153      16.230  40.905 101.148  1.00 49.91           C  
ATOM   1109  C   GLU A 153      16.119  42.207 101.942  1.00 49.21           C  
ATOM   1110  O   GLU A 153      15.021  42.695 102.175  1.00 49.30           O  
ATOM   1111  CB  GLU A 153      16.587  39.732 102.091  1.00 49.76           C  
ATOM   1112  CG  GLU A 153      15.375  39.157 102.873  1.00 51.04           C  
ATOM   1113  CD  GLU A 153      15.745  38.172 104.010  1.00 51.97           C  
ATOM   1114  OE1 GLU A 153      16.907  37.705 104.092  1.00 55.61           O  
ATOM   1115  OE2 GLU A 153      14.858  37.853 104.836  1.00 53.71           O  
ATOM   1116  N   GLN A 154      17.262  42.779 102.322  1.00 48.83           N  
ATOM   1117  CA  GLN A 154      17.290  44.036 103.080  1.00 48.64           C  
ATOM   1118  C   GLN A 154      16.704  45.235 102.321  1.00 47.75           C  
ATOM   1119  O   GLN A 154      15.995  46.062 102.911  1.00 47.49           O  
ATOM   1120  CB  GLN A 154      18.705  44.360 103.569  1.00 48.71           C  
ATOM   1121  CG  GLN A 154      19.133  43.568 104.784  1.00 51.09           C  
ATOM   1122  CD  GLN A 154      19.961  42.344 104.429  1.00 54.59           C  
ATOM   1123  OE1 GLN A 154      19.455  41.213 104.434  1.00 55.60           O  
ATOM   1124  NE2 GLN A 154      21.250  42.561 104.124  1.00 54.51           N  
ATOM   1125  N   ILE A 155      17.017  45.333 101.030  1.00 46.69           N  
ATOM   1126  CA  ILE A 155      16.464  46.388 100.185  1.00 46.00           C  
ATOM   1127  C   ILE A 155      14.941  46.302 100.065  1.00 46.10           C  
ATOM   1128  O   ILE A 155      14.254  47.330 100.112  1.00 45.98           O  
ATOM   1129  CB  ILE A 155      17.214  46.501  98.840  1.00 46.11           C  
ATOM   1130  CG1 ILE A 155      18.414  47.441  99.049  1.00 46.52           C  
ATOM   1131  CG2 ILE A 155      16.333  47.074  97.739  1.00 45.45           C  
ATOM   1132  CD1 ILE A 155      19.534  47.164  98.186  1.00 45.21           C  
ATOM   1133  N   ASP A 156      14.425  45.075  99.956  1.00 45.58           N  
ATOM   1134  CA  ASP A 156      12.994  44.821 100.005  1.00 45.29           C  
ATOM   1135  C   ASP A 156      12.370  45.308 101.315  1.00 44.86           C  
ATOM   1136  O   ASP A 156      11.301  45.915 101.306  1.00 44.64           O  
ATOM   1137  CB  ASP A 156      12.708  43.330  99.783  1.00 45.28           C  
ATOM   1138  CG  ASP A 156      12.847  42.918  98.319  1.00 46.27           C  
ATOM   1139  OD1 ASP A 156      12.821  41.693  98.032  1.00 47.25           O  
ATOM   1140  OD2 ASP A 156      12.982  43.818  97.454  1.00 45.59           O  
ATOM   1141  N   GLN A 157      13.050  45.044 102.431  1.00 44.28           N  
ATOM   1142  CA  GLN A 157      12.620  45.506 103.753  1.00 43.64           C  
ATOM   1143  C   GLN A 157      12.604  47.030 103.835  1.00 42.52           C  
ATOM   1144  O   GLN A 157      11.654  47.617 104.334  1.00 42.54           O  
ATOM   1145  CB  GLN A 157      13.509  44.914 104.842  1.00 43.59           C  
ATOM   1146  CG  GLN A 157      13.305  43.421 105.029  1.00 44.56           C  
ATOM   1147  CD  GLN A 157      14.385  42.747 105.880  1.00 45.19           C  
ATOM   1148  OE1 GLN A 157      14.477  41.518 105.901  1.00 48.64           O  
ATOM   1149  NE2 GLN A 157      15.192  43.539 106.583  1.00 46.34           N  
ATOM   1150  N   TYR A 158      13.644  47.664 103.323  1.00 41.78           N  
ATOM   1151  CA  TYR A 158      13.634  49.112 103.153  1.00 41.61           C  
ATOM   1152  C   TYR A 158      12.464  49.535 102.277  1.00 41.22           C  
ATOM   1153  O   TYR A 158      11.775  50.498 102.590  1.00 41.66           O  
ATOM   1154  CB  TYR A 158      14.942  49.626 102.538  1.00 41.43           C  
ATOM   1155  CG  TYR A 158      16.138  49.650 103.464  1.00 41.54           C  
ATOM   1156  CD1 TYR A 158      16.090  50.304 104.693  1.00 40.80           C  
ATOM   1157  CD2 TYR A 158      17.338  49.050 103.085  1.00 43.29           C  
ATOM   1158  CE1 TYR A 158      17.200  50.338 105.536  1.00 41.83           C  
ATOM   1159  CE2 TYR A 158      18.462  49.082 103.916  1.00 42.61           C  
ATOM   1160  CZ  TYR A 158      18.385  49.724 105.142  1.00 42.04           C  
ATOM   1161  OH  TYR A 158      19.491  49.745 105.959  1.00 41.21           O  
ATOM   1162  N   TYR A 159      12.243  48.812 101.184  1.00 40.83           N  
ATOM   1163  CA  TYR A 159      11.167  49.142 100.255  1.00 40.55           C  
ATOM   1164  C   TYR A 159       9.785  49.182 100.928  1.00 39.79           C  
ATOM   1165  O   TYR A 159       9.043  50.145 100.750  1.00 38.95           O  
ATOM   1166  CB  TYR A 159      11.163  48.203  99.032  1.00 41.16           C  
ATOM   1167  CG  TYR A 159      10.053  48.506  98.068  1.00 41.59           C  
ATOM   1168  CD1 TYR A 159      10.064  49.678  97.322  1.00 42.89           C  
ATOM   1169  CD2 TYR A 159       8.988  47.637  97.910  1.00 43.38           C  
ATOM   1170  CE1 TYR A 159       9.036  49.993  96.452  1.00 42.67           C  
ATOM   1171  CE2 TYR A 159       7.948  47.933  97.022  1.00 45.69           C  
ATOM   1172  CZ  TYR A 159       7.989  49.122  96.294  1.00 44.44           C  
ATOM   1173  OH  TYR A 159       6.981  49.437  95.407  1.00 44.69           O  
ATOM   1174  N   TYR A 160       9.453  48.151 101.697  1.00 39.64           N  
ATOM   1175  CA  TYR A 160       8.132  48.076 102.313  1.00 40.39           C  
ATOM   1176  C   TYR A 160       7.966  49.038 103.479  1.00 40.29           C  
ATOM   1177  O   TYR A 160       6.960  49.739 103.556  1.00 40.23           O  
ATOM   1178  CB  TYR A 160       7.751  46.629 102.670  1.00 41.30           C  
ATOM   1179  CG  TYR A 160       7.545  45.761 101.429  1.00 41.92           C  
ATOM   1180  CD1 TYR A 160       6.406  45.906 100.629  1.00 41.79           C  
ATOM   1181  CD2 TYR A 160       8.506  44.824 101.040  1.00 43.00           C  
ATOM   1182  CE1 TYR A 160       6.221  45.127  99.486  1.00 42.06           C  
ATOM   1183  CE2 TYR A 160       8.333  44.037  99.897  1.00 42.93           C  
ATOM   1184  CZ  TYR A 160       7.191  44.196  99.128  1.00 42.54           C  
ATOM   1185  OH  TYR A 160       7.027  43.424  97.998  1.00 43.24           O  
ATOM   1186  N   ALA A 161       8.973  49.098 104.349  1.00 40.15           N  
ATOM   1187  CA  ALA A 161       9.000  50.053 105.441  1.00 40.04           C  
ATOM   1188  C   ALA A 161       8.825  51.477 104.937  1.00 40.02           C  
ATOM   1189  O   ALA A 161       8.047  52.244 105.495  1.00 40.42           O  
ATOM   1190  CB  ALA A 161      10.295  49.925 106.241  1.00 40.17           C  
ATOM   1191  N   LEU A 162       9.544  51.843 103.884  1.00 39.97           N  
ATOM   1192  CA  LEU A 162       9.425  53.199 103.365  1.00 39.95           C  
ATOM   1193  C   LEU A 162       8.091  53.437 102.644  1.00 40.56           C  
ATOM   1194  O   LEU A 162       7.568  54.546 102.678  1.00 40.56           O  
ATOM   1195  CB  LEU A 162      10.631  53.575 102.504  1.00 39.42           C  
ATOM   1196  CG  LEU A 162      11.865  54.021 103.306  1.00 38.75           C  
ATOM   1197  CD1 LEU A 162      13.159  53.728 102.580  1.00 36.29           C  
ATOM   1198  CD2 LEU A 162      11.787  55.515 103.673  1.00 38.46           C  
ATOM   1199  N   SER A 163       7.532  52.395 102.023  1.00 40.94           N  
ATOM   1200  CA  SER A 163       6.223  52.500 101.387  1.00 41.82           C  
ATOM   1201  C   SER A 163       5.121  52.704 102.417  1.00 42.17           C  
ATOM   1202  O   SER A 163       4.305  53.613 102.276  1.00 42.28           O  
ATOM   1203  CB  SER A 163       5.924  51.266 100.537  1.00 42.11           C  
ATOM   1204  OG  SER A 163       6.883  51.136  99.510  1.00 42.74           O  
ATOM   1205  N   LYS A 164       5.112  51.857 103.449  1.00 42.60           N  
ATOM   1206  CA  LYS A 164       4.170  51.966 104.560  1.00 42.97           C  
ATOM   1207  C   LYS A 164       4.227  53.355 105.190  1.00 43.22           C  
ATOM   1208  O   LYS A 164       3.189  53.949 105.489  1.00 43.03           O  
ATOM   1209  CB  LYS A 164       4.466  50.909 105.626  1.00 42.90           C  
ATOM   1210  CG  LYS A 164       4.011  49.504 105.281  1.00 43.26           C  
ATOM   1211  CD  LYS A 164       4.191  48.569 106.479  1.00 43.72           C  
ATOM   1212  CE  LYS A 164       3.384  47.268 106.327  1.00 44.73           C  
ATOM   1213  NZ  LYS A 164       3.947  46.308 105.315  1.00 44.42           N  
ATOM   1214  N   GLU A 165       5.446  53.868 105.381  1.00 43.44           N  
ATOM   1215  CA  GLU A 165       5.642  55.185 105.984  1.00 43.85           C  
ATOM   1216  C   GLU A 165       5.110  56.302 105.089  1.00 43.74           C  
ATOM   1217  O   GLU A 165       4.346  57.150 105.550  1.00 43.89           O  
ATOM   1218  CB  GLU A 165       7.121  55.417 106.313  1.00 43.79           C  
ATOM   1219  CG  GLU A 165       7.474  56.835 106.755  1.00 44.20           C  
ATOM   1220  CD  GLU A 165       8.968  57.125 106.639  1.00 44.91           C  
ATOM   1221  OE1 GLU A 165       9.733  56.210 106.253  1.00 46.53           O  
ATOM   1222  OE2 GLU A 165       9.381  58.267 106.937  1.00 45.60           O  
ATOM   1223  N   ILE A 166       5.498  56.289 103.813  1.00 43.77           N  
ATOM   1224  CA  ILE A 166       5.167  57.394 102.907  1.00 43.90           C  
ATOM   1225  C   ILE A 166       3.659  57.560 102.690  1.00 44.22           C  
ATOM   1226  O   ILE A 166       3.141  58.667 102.811  1.00 43.68           O  
ATOM   1227  CB  ILE A 166       5.937  57.320 101.554  1.00 43.80           C  
ATOM   1228  CG1 ILE A 166       7.448  57.275 101.792  1.00 43.78           C  
ATOM   1229  CG2 ILE A 166       5.609  58.528 100.679  1.00 43.72           C  
ATOM   1230  CD1 ILE A 166       8.276  57.004 100.546  1.00 43.59           C  
ATOM   1231  N   ILE A 167       2.963  56.469 102.369  1.00 44.98           N  
ATOM   1232  CA  ILE A 167       1.516  56.542 102.159  1.00 45.89           C  
ATOM   1233  C   ILE A 167       0.797  56.712 103.494  1.00 46.48           C  
ATOM   1234  O   ILE A 167      -0.275  57.311 103.553  1.00 46.30           O  
ATOM   1235  CB  ILE A 167       0.928  55.321 101.405  1.00 45.80           C  
ATOM   1236  CG1 ILE A 167       0.998  54.066 102.269  1.00 46.17           C  
ATOM   1237  CG2 ILE A 167       1.622  55.109 100.060  1.00 46.13           C  
ATOM   1238  CD1 ILE A 167      -0.315  53.315 102.362  0.50 45.45           C  
ATOM   1239  N   GLY A 168       1.401  56.178 104.557  1.00 47.32           N  
ATOM   1240  CA  GLY A 168       0.921  56.380 105.918  1.00 48.46           C  
ATOM   1241  C   GLY A 168       0.861  57.858 106.256  1.00 49.26           C  
ATOM   1242  O   GLY A 168      -0.022  58.292 106.998  1.00 49.21           O  
ATOM   1243  N   LEU A 169       1.791  58.624 105.684  1.00 50.12           N  
ATOM   1244  CA  LEU A 169       1.846  60.076 105.836  1.00 51.12           C  
ATOM   1245  C   LEU A 169       0.715  60.832 105.121  1.00 52.02           C  
ATOM   1246  O   LEU A 169       0.922  61.946 104.629  1.00 52.14           O  
ATOM   1247  CB  LEU A 169       3.222  60.613 105.406  1.00 51.01           C  
ATOM   1248  CG  LEU A 169       4.180  61.098 106.501  1.00 50.79           C  
ATOM   1249  CD1 LEU A 169       5.630  60.980 106.077  1.00 50.60           C  
ATOM   1250  CD2 LEU A 169       3.858  62.537 106.898  1.00 51.20           C  
ATOM   1251  N   MET A 170      -0.475  60.226 105.075  1.00 53.06           N  
ATOM   1252  CA  MET A 170      -1.691  60.922 104.634  1.00 54.02           C  
ATOM   1253  C   MET A 170      -2.811  60.849 105.682  1.00 54.36           C  
ATOM   1254  O   MET A 170      -3.501  61.843 105.932  1.00 54.25           O  
ATOM   1255  CB  MET A 170      -2.173  60.427 103.259  1.00 53.84           C  
ATOM   1256  CG  MET A 170      -2.965  59.116 103.266  1.00 54.40           C  
ATOM   1257  SD  MET A 170      -3.613  58.632 101.642  1.00 55.20           S  
ATOM   1258  CE  MET A 170      -5.044  59.712 101.493  1.00 55.01           C  
ATOM   1259  N   LYS A 171      -2.976  59.673 106.291  1.00 54.90           N  
ATOM   1260  CA  LYS A 171      -4.044  59.446 107.262  1.00 55.28           C  
ATOM   1261  C   LYS A 171      -3.670  59.956 108.651  1.00 55.67           C  
ATOM   1262  O   LYS A 171      -4.551  60.317 109.439  1.00 55.66           O  
ATOM   1263  CB  LYS A 171      -4.428  57.965 107.329  1.00 55.26           C  
ATOM   1264  CG  LYS A 171      -5.922  57.726 107.625  1.00 55.13           C  
ATOM   1265  CD  LYS A 171      -6.225  56.259 107.980  1.00 55.23           C  
ATOM   1266  CE  LYS A 171      -5.773  55.223 106.826  1.00 54.91           C  
ATOM   1267  NZ  LYS A 171      -6.704  55.630 105.598  1.00 54.65           N  
ATOM   1268  N   ASP A 172      -2.371  59.979 108.955  1.00 56.07           N  
ATOM   1269  CA  ASP A 172      -1.910  60.527 110.231  1.00 56.53           C  
ATOM   1270  C   ASP A 172      -1.937  62.065 110.198  1.00 56.77           C  
ATOM   1271  O   ASP A 172      -2.357  62.708 111.167  1.00 56.58           O  
ATOM   1272  CB  ASP A 172      -0.547  59.943 110.641  1.00 56.53           C  
ATOM   1273  CG  ASP A 172       0.619  60.595 109.931  1.00 56.89           C  
ATOM   1274  OD1 ASP A 172       1.081  60.039 108.913  1.00 57.33           O  
ATOM   1275  OD2 ASP A 172       1.089  61.656 110.397  1.00 57.15           O  
ATOM   1276  N   GLN A 173      -1.486  62.630 109.075  1.00 57.02           N  
ATOM   1277  CA  GLN A 173      -1.748  64.034 108.702  1.00 57.22           C  
ATOM   1278  C   GLN A 173      -1.471  64.238 107.203  1.00 57.09           C  
ATOM   1279  O   GLN A 173      -0.528  63.664 106.657  1.00 56.99           O  
ATOM   1280  CB  GLN A 173      -1.018  65.050 109.608  1.00 57.20           C  
ATOM   1281  CG  GLN A 173       0.484  64.859 109.754  1.00 57.66           C  
ATOM   1282  CD  GLN A 173       1.277  65.691 108.766  1.00 58.18           C  
ATOM   1283  OE1 GLN A 173       1.831  65.164 107.800  1.00 58.27           O  
ATOM   1284  NE2 GLN A 173       1.325  67.002 108.998  1.00 57.86           N  
ATOM   1285  N   GLU A 174      -2.291  65.071 106.561  1.00 57.05           N  
ATOM   1286  CA  GLU A 174      -2.488  65.029 105.104  1.00 56.91           C  
ATOM   1287  C   GLU A 174      -1.372  65.551 104.172  1.00 56.74           C  
ATOM   1288  O   GLU A 174      -0.561  64.758 103.693  1.00 56.78           O  
ATOM   1289  CB  GLU A 174      -3.840  65.661 104.728  1.00 57.00           C  
ATOM   1290  CG  GLU A 174      -4.368  65.245 103.351  1.00 56.94           C  
ATOM   1291  CD  GLU A 174      -5.613  66.013 102.939  1.00 56.99           C  
ATOM   1292  OE1 GLU A 174      -6.551  65.380 102.406  1.00 57.19           O  
ATOM   1293  OE2 GLU A 174      -5.657  67.247 103.145  1.00 56.79           O  
ATOM   1294  N   SER A 176      -0.025  65.873 100.799  1.00 55.09           N  
ATOM   1295  CA  SER A 176       1.440  65.971 100.917  1.00 54.36           C  
ATOM   1296  C   SER A 176       1.934  65.214  99.693  1.00 53.88           C  
ATOM   1297  O   SER A 176       3.135  65.058  99.481  1.00 53.97           O  
ATOM   1298  CB  SER A 176       1.979  65.252 102.156  1.00 54.29           C  
ATOM   1299  OG  SER A 176       3.274  65.725 102.483  1.00 53.78           O  
ATOM   1300  N   ILE A 177       0.973  64.769  98.883  1.00 53.23           N  
ATOM   1301  CA  ILE A 177       1.162  63.696  97.897  1.00 52.65           C  
ATOM   1302  C   ILE A 177       1.965  63.994  96.612  1.00 52.00           C  
ATOM   1303  O   ILE A 177       2.447  63.051  95.979  1.00 51.85           O  
ATOM   1304  CB  ILE A 177      -0.196  63.005  97.523  1.00 52.73           C  
ATOM   1305  CG1 ILE A 177      -1.089  63.934  96.689  1.00 52.74           C  
ATOM   1306  CG2 ILE A 177      -0.913  62.498  98.780  1.00 52.90           C  
ATOM   1307  CD1 ILE A 177      -2.051  63.212  95.769  1.00 52.77           C  
ATOM   1308  N   PRO A 178       2.079  65.278  96.196  1.00 51.37           N  
ATOM   1309  CA  PRO A 178       3.012  65.552  95.096  1.00 50.74           C  
ATOM   1310  C   PRO A 178       4.389  64.938  95.348  1.00 50.01           C  
ATOM   1311  O   PRO A 178       4.877  64.164  94.521  1.00 49.79           O  
ATOM   1312  CB  PRO A 178       3.101  67.088  95.075  1.00 50.70           C  
ATOM   1313  CG  PRO A 178       2.404  67.551  96.325  1.00 51.17           C  
ATOM   1314  CD  PRO A 178       1.389  66.509  96.619  1.00 51.27           C  
ATOM   1315  N   ASN A 179       4.981  65.268  96.493  1.00 49.14           N  
ATOM   1316  CA  ASN A 179       6.261  64.721  96.904  1.00 48.52           C  
ATOM   1317  C   ASN A 179       6.194  63.248  97.272  1.00 48.20           C  
ATOM   1318  O   ASN A 179       7.116  62.490  96.970  1.00 48.19           O  
ATOM   1319  CB  ASN A 179       6.831  65.510  98.079  1.00 48.44           C  
ATOM   1320  CG  ASN A 179       7.640  66.711  97.643  1.00 48.12           C  
ATOM   1321  OD1 ASN A 179       8.437  67.235  98.414  1.00 48.17           O  
ATOM   1322  ND2 ASN A 179       7.440  67.158  96.407  1.00 47.61           N  
ATOM   1323  N   GLY A 180       5.106  62.858  97.933  1.00 47.69           N  
ATOM   1324  CA  GLY A 180       4.901  61.476  98.356  1.00 46.96           C  
ATOM   1325  C   GLY A 180       5.027  60.540  97.178  1.00 46.58           C  
ATOM   1326  O   GLY A 180       5.861  59.633  97.189  1.00 46.57           O  
ATOM   1327  N   THR A 181       4.205  60.794  96.159  1.00 46.21           N  
ATOM   1328  CA  THR A 181       4.210  60.065  94.888  1.00 45.70           C  
ATOM   1329  C   THR A 181       5.619  59.976  94.288  1.00 45.52           C  
ATOM   1330  O   THR A 181       6.002  58.940  93.735  1.00 45.67           O  
ATOM   1331  CB  THR A 181       3.234  60.722  93.872  1.00 45.64           C  
ATOM   1332  OG1 THR A 181       1.951  60.907  94.484  1.00 45.69           O  
ATOM   1333  CG2 THR A 181       3.054  59.862  92.639  1.00 46.25           C  
ATOM   1334  N   GLN A 182       6.390  61.055  94.425  1.00 45.10           N  
ATOM   1335  CA  GLN A 182       7.753  61.110  93.905  1.00 44.47           C  
ATOM   1336  C   GLN A 182       8.716  60.224  94.702  1.00 44.26           C  
ATOM   1337  O   GLN A 182       9.530  59.502  94.111  1.00 44.48           O  
ATOM   1338  CB  GLN A 182       8.251  62.560  93.815  1.00 44.44           C  
ATOM   1339  CG  GLN A 182       7.489  63.441  92.805  1.00 44.30           C  
ATOM   1340  CD  GLN A 182       7.378  62.821  91.405  1.00 44.45           C  
ATOM   1341  OE1 GLN A 182       8.356  62.301  90.857  1.00 44.30           O  
ATOM   1342  NE2 GLN A 182       6.184  62.882  90.823  1.00 42.68           N  
ATOM   1343  N   TYR A 183       8.613  60.262  96.029  1.00 43.61           N  
ATOM   1344  CA  TYR A 183       9.386  59.363  96.887  1.00 43.03           C  
ATOM   1345  C   TYR A 183       8.960  57.893  96.785  1.00 42.56           C  
ATOM   1346  O   TYR A 183       9.757  56.996  97.063  1.00 43.04           O  
ATOM   1347  CB  TYR A 183       9.365  59.828  98.340  1.00 43.21           C  
ATOM   1348  CG  TYR A 183      10.319  60.961  98.612  1.00 43.97           C  
ATOM   1349  CD1 TYR A 183      11.663  60.713  98.865  1.00 44.19           C  
ATOM   1350  CD2 TYR A 183       9.881  62.288  98.618  1.00 44.48           C  
ATOM   1351  CE1 TYR A 183      12.551  61.750  99.122  1.00 44.68           C  
ATOM   1352  CE2 TYR A 183      10.762  63.332  98.865  1.00 44.41           C  
ATOM   1353  CZ  TYR A 183      12.096  63.054  99.115  1.00 44.40           C  
ATOM   1354  OH  TYR A 183      12.980  64.082  99.359  1.00 45.08           O  
ATOM   1355  N   LEU A 184       7.715  57.640  96.386  1.00 41.74           N  
ATOM   1356  CA  LEU A 184       7.304  56.275  96.076  1.00 41.14           C  
ATOM   1357  C   LEU A 184       8.048  55.769  94.841  1.00 40.62           C  
ATOM   1358  O   LEU A 184       8.589  54.662  94.866  1.00 40.46           O  
ATOM   1359  CB  LEU A 184       5.780  56.140  95.907  1.00 40.92           C  
ATOM   1360  CG  LEU A 184       4.915  56.198  97.179  1.00 40.93           C  
ATOM   1361  CD1 LEU A 184       3.428  56.054  96.848  1.00 39.32           C  
ATOM   1362  CD2 LEU A 184       5.331  55.162  98.232  1.00 40.23           C  
ATOM   1363  N   TYR A 185       8.096  56.584  93.782  1.00 40.21           N  
ATOM   1364  CA  TYR A 185       8.827  56.223  92.561  1.00 39.98           C  
ATOM   1365  C   TYR A 185      10.292  55.976  92.865  1.00 39.77           C  
ATOM   1366  O   TYR A 185      10.837  54.958  92.450  1.00 40.05           O  
ATOM   1367  CB  TYR A 185       8.721  57.304  91.488  1.00 40.27           C  
ATOM   1368  CG  TYR A 185       7.315  57.628  91.040  1.00 41.62           C  
ATOM   1369  CD1 TYR A 185       6.308  56.652  91.040  1.00 41.55           C  
ATOM   1370  CD2 TYR A 185       6.997  58.901  90.571  1.00 41.34           C  
ATOM   1371  CE1 TYR A 185       5.027  56.952  90.617  1.00 42.45           C  
ATOM   1372  CE2 TYR A 185       5.714  59.209  90.146  1.00 41.44           C  
ATOM   1373  CZ  TYR A 185       4.737  58.233  90.166  1.00 42.23           C  
ATOM   1374  OH  TYR A 185       3.457  58.538  89.747  1.00 42.76           O  
ATOM   1375  N   ILE A 186      10.911  56.897  93.609  1.00 39.02           N  
ATOM   1376  CA  ILE A 186      12.323  56.811  93.947  1.00 38.59           C  
ATOM   1377  C   ILE A 186      12.666  55.475  94.597  1.00 38.60           C  
ATOM   1378  O   ILE A 186      13.633  54.815  94.201  1.00 38.43           O  
ATOM   1379  CB  ILE A 186      12.777  57.994  94.855  1.00 38.64           C  
ATOM   1380  CG1 ILE A 186      12.883  59.273  94.026  1.00 38.26           C  
ATOM   1381  CG2 ILE A 186      14.109  57.673  95.542  1.00 37.75           C  
ATOM   1382  CD1 ILE A 186      12.772  60.549  94.822  1.00 40.47           C  
ATOM   1383  N   ILE A 187      11.878  55.075  95.589  1.00 38.77           N  
ATOM   1384  CA  ILE A 187      12.175  53.831  96.295  1.00 39.34           C  
ATOM   1385  C   ILE A 187      11.896  52.612  95.416  1.00 39.55           C  
ATOM   1386  O   ILE A 187      12.566  51.596  95.552  1.00 39.39           O  
ATOM   1387  CB  ILE A 187      11.506  53.734  97.706  1.00 39.26           C  
ATOM   1388  CG1 ILE A 187       9.982  53.671  97.618  1.00 39.82           C  
ATOM   1389  CG2 ILE A 187      11.967  54.895  98.572  1.00 38.76           C  
ATOM   1390  CD1 ILE A 187       9.317  53.091  98.858  1.00 39.37           C  
ATOM   1391  N   GLY A 188      10.941  52.750  94.492  1.00 39.32           N  
ATOM   1392  CA  GLY A 188      10.681  51.732  93.481  1.00 39.70           C  
ATOM   1393  C   GLY A 188      11.829  51.594  92.489  1.00 40.27           C  
ATOM   1394  O   GLY A 188      12.129  50.483  92.018  1.00 40.16           O  
ATOM   1395  N   HIS A 189      12.472  52.717  92.165  1.00 40.09           N  
ATOM   1396  CA  HIS A 189      13.626  52.713  91.263  1.00 40.45           C  
ATOM   1397  C   HIS A 189      14.841  52.039  91.886  1.00 40.23           C  
ATOM   1398  O   HIS A 189      15.585  51.349  91.190  1.00 40.61           O  
ATOM   1399  CB  HIS A 189      13.988  54.124  90.808  1.00 40.57           C  
ATOM   1400  CG  HIS A 189      13.064  54.674  89.767  1.00 41.31           C  
ATOM   1401  ND1 HIS A 189      12.775  54.001  88.601  1.00 40.29           N  
ATOM   1402  CD2 HIS A 189      12.380  55.844  89.707  1.00 42.15           C  
ATOM   1403  CE1 HIS A 189      11.934  54.718  87.875  1.00 41.88           C  
ATOM   1404  NE2 HIS A 189      11.676  55.840  88.525  1.00 43.21           N  
ATOM   1405  N   LEU A 190      15.033  52.249  93.184  1.00 40.02           N  
ATOM   1406  CA  LEU A 190      16.118  51.628  93.930  1.00 40.00           C  
ATOM   1407  C   LEU A 190      15.865  50.149  94.106  1.00 40.66           C  
ATOM   1408  O   LEU A 190      16.787  49.339  93.996  1.00 40.75           O  
ATOM   1409  CB  LEU A 190      16.280  52.279  95.314  1.00 39.90           C  
ATOM   1410  CG  LEU A 190      17.107  53.558  95.418  1.00 38.83           C  
ATOM   1411  CD1 LEU A 190      17.041  54.149  96.818  1.00 37.05           C  
ATOM   1412  CD2 LEU A 190      18.550  53.266  95.020  1.00 38.89           C  
ATOM   1413  N   GLU A 191      14.613  49.796  94.394  1.00 41.17           N  
ATOM   1414  CA  GLU A 191      14.254  48.408  94.580  1.00 41.99           C  
ATOM   1415  C   GLU A 191      14.507  47.619  93.275  1.00 42.82           C  
ATOM   1416  O   GLU A 191      15.083  46.535  93.334  1.00 43.29           O  
ATOM   1417  CB  GLU A 191      12.808  48.283  95.093  1.00 42.06           C  
ATOM   1418  CG  GLU A 191      12.432  46.902  95.650  1.00 43.12           C  
ATOM   1419  CD  GLU A 191      12.220  45.842  94.562  1.00 43.58           C  
ATOM   1420  OE1 GLU A 191      11.802  46.205  93.441  1.00 43.45           O  
ATOM   1421  OE2 GLU A 191      12.472  44.646  94.834  1.00 44.05           O  
ATOM   1422  N   ARG A 192      14.099  48.174  92.123  1.00 43.55           N  
ATOM   1423  CA  ARG A 192      14.371  47.589  90.791  1.00 44.73           C  
ATOM   1424  C   ARG A 192      15.856  47.500  90.445  1.00 44.40           C  
ATOM   1425  O   ARG A 192      16.323  46.457  89.982  1.00 44.76           O  
ATOM   1426  CB  ARG A 192      13.662  48.362  89.669  1.00 45.34           C  
ATOM   1427  CG  ARG A 192      12.173  48.395  89.751  1.00 48.83           C  
ATOM   1428  CD  ARG A 192      11.578  47.036  89.501  1.00 57.55           C  
ATOM   1429  NE  ARG A 192      11.408  46.772  88.070  1.00 62.80           N  
ATOM   1430  CZ  ARG A 192      12.310  46.158  87.318  1.00 65.87           C  
ATOM   1431  NH1 ARG A 192      13.447  45.720  87.857  1.00 69.29           N  
ATOM   1432  NH2 ARG A 192      12.068  45.961  86.035  1.00 67.84           N  
ATOM   1433  N   PHE A 193      16.578  48.601  90.647  1.00 44.20           N  
ATOM   1434  CA  PHE A 193      18.042  48.649  90.540  1.00 43.90           C  
ATOM   1435  C   PHE A 193      18.685  47.444  91.206  1.00 44.00           C  
ATOM   1436  O   PHE A 193      19.477  46.737  90.592  1.00 43.68           O  
ATOM   1437  CB  PHE A 193      18.550  49.940  91.197  1.00 43.68           C  
ATOM   1438  CG  PHE A 193      20.019  50.191  91.041  1.00 42.96           C  
ATOM   1439  CD1 PHE A 193      20.520  50.799  89.895  1.00 43.71           C  
ATOM   1440  CD2 PHE A 193      20.897  49.895  92.075  1.00 44.07           C  
ATOM   1441  CE1 PHE A 193      21.895  51.079  89.770  1.00 43.20           C  
ATOM   1442  CE2 PHE A 193      22.270  50.162  91.958  1.00 44.93           C  
ATOM   1443  CZ  PHE A 193      22.764  50.755  90.801  1.00 43.93           C  
ATOM   1444  N   ALA A 194      18.312  47.207  92.459  1.00 44.39           N  
ATOM   1445  CA  ALA A 194      18.881  46.128  93.258  1.00 44.85           C  
ATOM   1446  C   ALA A 194      18.448  44.738  92.783  1.00 44.90           C  
ATOM   1447  O   ALA A 194      19.219  43.787  92.841  1.00 45.49           O  
ATOM   1448  CB  ALA A 194      18.556  46.330  94.737  1.00 44.53           C  
ATOM   1449  N   ASP A 195      17.218  44.629  92.307  1.00 45.09           N  
ATOM   1450  CA  ASP A 195      16.740  43.408  91.696  1.00 44.88           C  
ATOM   1451  C   ASP A 195      17.579  43.004  90.474  1.00 43.43           C  
ATOM   1452  O   ASP A 195      17.946  41.835  90.341  1.00 42.44           O  
ATOM   1453  CB  ASP A 195      15.274  43.564  91.294  1.00 46.32           C  
ATOM   1454  CG  ASP A 195      14.314  43.159  92.390  1.00 50.91           C  
ATOM   1455  OD1 ASP A 195      14.735  42.455  93.340  1.00 56.63           O  
ATOM   1456  OD2 ASP A 195      13.107  43.525  92.292  1.00 57.07           O  
ATOM   1457  N   TYR A 196      17.866  43.951  89.577  1.00 41.86           N  
ATOM   1458  CA  TYR A 196      18.754  43.650  88.433  1.00 41.36           C  
ATOM   1459  C   TYR A 196      20.163  43.179  88.827  1.00 40.61           C  
ATOM   1460  O   TYR A 196      20.719  42.290  88.185  1.00 39.76           O  
ATOM   1461  CB  TYR A 196      18.843  44.815  87.439  1.00 41.11           C  
ATOM   1462  CG  TYR A 196      17.582  45.010  86.638  1.00 41.31           C  
ATOM   1463  CD1 TYR A 196      17.134  44.027  85.747  1.00 40.98           C  
ATOM   1464  CD2 TYR A 196      16.814  46.173  86.775  1.00 42.30           C  
ATOM   1465  CE1 TYR A 196      15.944  44.193  85.000  1.00 38.28           C  
ATOM   1466  CE2 TYR A 196      15.629  46.342  86.037  1.00 40.64           C  
ATOM   1467  CZ  TYR A 196      15.220  45.356  85.154  1.00 40.40           C  
ATOM   1468  OH  TYR A 196      14.062  45.525  84.432  1.00 43.22           O  
ATOM   1469  N   ILE A 197      20.735  43.779  89.870  1.00 40.60           N  
ATOM   1470  CA  ILE A 197      22.011  43.309  90.443  1.00 40.67           C  
ATOM   1471  C   ILE A 197      21.924  41.827  90.815  1.00 41.31           C  
ATOM   1472  O   ILE A 197      22.850  41.053  90.523  1.00 41.71           O  
ATOM   1473  CB  ILE A 197      22.428  44.143  91.684  1.00 40.71           C  
ATOM   1474  CG1 ILE A 197      22.719  45.595  91.266  1.00 39.89           C  
ATOM   1475  CG2 ILE A 197      23.636  43.530  92.380  1.00 40.21           C  
ATOM   1476  CD1 ILE A 197      22.838  46.572  92.422  1.00 40.94           C  
ATOM   1477  N   ALA A 198      20.815  41.446  91.457  1.00 41.17           N  
ATOM   1478  CA  ALA A 198      20.561  40.073  91.861  1.00 41.71           C  
ATOM   1479  C   ALA A 198      20.453  39.156  90.631  1.00 41.77           C  
ATOM   1480  O   ALA A 198      21.003  38.065  90.622  1.00 42.59           O  
ATOM   1481  CB  ALA A 198      19.269  40.001  92.706  1.00 41.92           C  
ATOM   1482  N   ASN A 199      19.726  39.606  89.614  1.00 41.64           N  
ATOM   1483  CA  ASN A 199      19.723  38.985  88.309  1.00 41.90           C  
ATOM   1484  C   ASN A 199      21.129  38.782  87.704  1.00 41.57           C  
ATOM   1485  O   ASN A 199      21.384  37.743  87.114  1.00 41.98           O  
ATOM   1486  CB  ASN A 199      18.823  39.766  87.342  1.00 42.45           C  
ATOM   1487  CG  ASN A 199      17.322  39.555  87.612  1.00 45.27           C  
ATOM   1488  OD1 ASN A 199      16.493  40.440  87.333  1.00 48.87           O  
ATOM   1489  ND2 ASN A 199      16.972  38.390  88.143  1.00 45.44           N  
ATOM   1490  N   ILE A 200      22.045  39.733  87.873  1.00 41.51           N  
ATOM   1491  CA  ILE A 200      23.385  39.582  87.285  1.00 41.60           C  
ATOM   1492  C   ILE A 200      24.162  38.538  88.078  1.00 42.06           C  
ATOM   1493  O   ILE A 200      24.876  37.713  87.503  1.00 42.57           O  
ATOM   1494  CB  ILE A 200      24.161  40.914  87.161  1.00 41.52           C  
ATOM   1495  CG1 ILE A 200      23.401  41.913  86.276  1.00 42.20           C  
ATOM   1496  CG2 ILE A 200      25.558  40.675  86.575  1.00 42.15           C  
ATOM   1497  CD1 ILE A 200      23.956  43.322  86.310  1.00 41.10           C  
ATOM   1498  N   CYS A 201      23.952  38.553  89.393  1.00 42.46           N  
ATOM   1499  CA  CYS A 201      24.424  37.517  90.311  1.00 42.58           C  
ATOM   1500  C   CYS A 201      24.032  36.090  89.916  1.00 42.35           C  
ATOM   1501  O   CYS A 201      24.874  35.212  89.900  1.00 42.00           O  
ATOM   1502  CB  CYS A 201      23.989  37.841  91.748  1.00 42.05           C  
ATOM   1503  SG  CYS A 201      24.821  39.293  92.468  1.00 44.09           S  
ATOM   1504  N   GLU A 202      22.755  35.866  89.600  1.00 43.14           N  
ATOM   1505  CA  GLU A 202      22.267  34.552  89.143  1.00 43.29           C  
ATOM   1506  C   GLU A 202      22.923  34.099  87.839  1.00 42.51           C  
ATOM   1507  O   GLU A 202      23.241  32.933  87.674  1.00 42.32           O  
ATOM   1508  CB  GLU A 202      20.749  34.559  88.954  1.00 43.37           C  
ATOM   1509  CG  GLU A 202      19.952  34.876  90.213  1.00 45.52           C  
ATOM   1510  CD  GLU A 202      18.444  34.765  90.004  1.00 46.09           C  
ATOM   1511  OE1 GLU A 202      17.795  34.017  90.758  1.00 50.50           O  
ATOM   1512  OE2 GLU A 202      17.904  35.432  89.093  1.00 50.69           O  
ATOM   1513  N   ARG A 203      23.107  35.034  86.918  1.00 42.41           N  
ATOM   1514  CA  ARG A 203      23.840  34.806  85.669  1.00 42.68           C  
ATOM   1515  C   ARG A 203      25.271  34.337  85.941  1.00 41.97           C  
ATOM   1516  O   ARG A 203      25.819  33.508  85.218  1.00 41.69           O  
ATOM   1517  CB  ARG A 203      23.876  36.114  84.858  1.00 42.56           C  
ATOM   1518  CG  ARG A 203      24.098  35.945  83.379  1.00 43.31           C  
ATOM   1519  CD  ARG A 203      22.789  35.648  82.614  1.00 45.59           C  
ATOM   1520  NE  ARG A 203      22.737  34.251  82.201  1.00 45.79           N  
ATOM   1521  CZ  ARG A 203      21.868  33.731  81.342  1.00 43.32           C  
ATOM   1522  NH1 ARG A 203      20.946  34.485  80.757  1.00 40.93           N  
ATOM   1523  NH2 ARG A 203      21.944  32.435  81.066  1.00 43.22           N  
ATOM   1524  N   LEU A 204      25.869  34.895  86.986  1.00 41.92           N  
ATOM   1525  CA  LEU A 204      27.203  34.495  87.433  1.00 42.03           C  
ATOM   1526  C   LEU A 204      27.183  33.059  87.983  1.00 42.01           C  
ATOM   1527  O   LEU A 204      28.111  32.280  87.725  1.00 41.55           O  
ATOM   1528  CB  LEU A 204      27.709  35.492  88.480  1.00 42.03           C  
ATOM   1529  CG  LEU A 204      29.151  36.011  88.557  1.00 43.54           C  
ATOM   1530  CD1 LEU A 204      29.882  35.955  87.216  1.00 43.96           C  
ATOM   1531  CD2 LEU A 204      29.157  37.453  89.134  1.00 42.06           C  
ATOM   1532  N   VAL A 205      26.123  32.688  88.705  1.00 41.91           N  
ATOM   1533  CA  VAL A 205      26.064  31.311  89.218  1.00 43.00           C  
ATOM   1534  C   VAL A 205      25.891  30.323  88.059  1.00 42.84           C  
ATOM   1535  O   VAL A 205      26.542  29.285  88.039  1.00 42.31           O  
ATOM   1536  CB  VAL A 205      25.092  31.101  90.453  1.00 42.70           C  
ATOM   1537  CG1 VAL A 205      23.722  31.608  90.169  1.00 45.04           C  
ATOM   1538  CG2 VAL A 205      25.002  29.619  90.864  1.00 42.83           C  
ATOM   1539  N   TYR A 206      25.053  30.693  87.084  1.00 43.15           N  
ATOM   1540  CA  TYR A 206      24.871  29.957  85.834  1.00 43.32           C  
ATOM   1541  C   TYR A 206      26.179  29.764  85.064  1.00 43.43           C  
ATOM   1542  O   TYR A 206      26.383  28.746  84.406  1.00 42.77           O  
ATOM   1543  CB  TYR A 206      23.836  30.678  84.955  1.00 44.24           C  
ATOM   1544  CG  TYR A 206      24.026  30.496  83.469  1.00 44.25           C  
ATOM   1545  CD1 TYR A 206      23.392  29.452  82.778  1.00 45.96           C  
ATOM   1546  CD2 TYR A 206      24.832  31.372  82.749  1.00 44.20           C  
ATOM   1547  CE1 TYR A 206      23.570  29.291  81.390  1.00 46.53           C  
ATOM   1548  CE2 TYR A 206      25.022  31.226  81.386  1.00 45.50           C  
ATOM   1549  CZ  TYR A 206      24.387  30.198  80.709  1.00 46.79           C  
ATOM   1550  OH  TYR A 206      24.602  30.080  79.351  1.00 48.55           O  
ATOM   1551  N   LEU A 207      27.054  30.757  85.137  1.00 43.75           N  
ATOM   1552  CA  LEU A 207      28.330  30.705  84.440  1.00 44.17           C  
ATOM   1553  C   LEU A 207      29.251  29.620  85.041  1.00 44.84           C  
ATOM   1554  O   LEU A 207      29.860  28.831  84.317  1.00 45.06           O  
ATOM   1555  CB  LEU A 207      28.967  32.103  84.433  1.00 44.21           C  
ATOM   1556  CG  LEU A 207      30.353  32.361  83.839  1.00 44.31           C  
ATOM   1557  CD1 LEU A 207      30.490  31.825  82.412  1.00 44.06           C  
ATOM   1558  CD2 LEU A 207      30.673  33.840  83.908  1.00 43.30           C  
ATOM   1559  N   GLU A 208      29.323  29.552  86.362  1.00 45.59           N  
ATOM   1560  CA  GLU A 208      30.132  28.537  87.009  1.00 46.71           C  
ATOM   1561  C   GLU A 208      29.458  27.174  86.995  1.00 47.50           C  
ATOM   1562  O   GLU A 208      30.113  26.147  86.863  1.00 47.44           O  
ATOM   1563  CB  GLU A 208      30.477  28.940  88.441  1.00 46.79           C  
ATOM   1564  CG  GLU A 208      31.425  27.929  89.109  1.00 48.18           C  
ATOM   1565  CD  GLU A 208      32.363  28.541  90.123  1.00 48.34           C  
ATOM   1566  OE1 GLU A 208      31.999  29.537  90.764  1.00 48.51           O  
ATOM   1567  OE2 GLU A 208      33.475  28.007  90.283  1.00 51.15           O  
ATOM   1568  N   THR A 209      28.136  27.192  87.097  1.00 48.70           N  
ATOM   1569  CA  THR A 209      27.318  26.013  87.311  1.00 49.78           C  
ATOM   1570  C   THR A 209      26.855  25.360  86.005  1.00 50.52           C  
ATOM   1571  O   THR A 209      26.927  24.145  85.861  1.00 50.53           O  
ATOM   1572  CB  THR A 209      26.134  26.413  88.216  1.00 49.89           C  
ATOM   1573  OG1 THR A 209      26.582  26.407  89.579  1.00 50.76           O  
ATOM   1574  CG2 THR A 209      24.956  25.491  88.077  1.00 51.31           C  
ATOM   1575  N   GLY A 210      26.393  26.164  85.054  1.00 51.66           N  
ATOM   1576  CA  GLY A 210      25.865  25.645  83.792  1.00 53.11           C  
ATOM   1577  C   GLY A 210      24.346  25.657  83.740  1.00 54.22           C  
ATOM   1578  O   GLY A 210      23.746  25.283  82.736  1.00 54.09           O  
ATOM   1579  N   GLU A 211      23.734  26.091  84.834  1.00 55.47           N  
ATOM   1580  CA  GLU A 211      22.292  26.124  84.977  1.00 56.92           C  
ATOM   1581  C   GLU A 211      21.898  27.446  85.607  1.00 57.58           C  
ATOM   1582  O   GLU A 211      22.476  27.860  86.611  1.00 57.59           O  
ATOM   1583  CB  GLU A 211      21.828  24.970  85.867  1.00 56.76           C  
ATOM   1584  CG  GLU A 211      20.305  24.828  86.001  1.00 57.29           C  
ATOM   1585  CD  GLU A 211      19.881  23.472  86.542  1.00 58.32           C  
ATOM   1586  OE1 GLU A 211      20.756  22.572  86.688  1.00 59.74           O  
ATOM   1587  OE2 GLU A 211      18.665  23.297  86.821  1.00 60.61           O  
ATOM   1588  N   LEU A 212      20.918  28.116  85.012  1.00 58.91           N  
ATOM   1589  CA  LEU A 212      20.341  29.304  85.628  1.00 59.91           C  
ATOM   1590  C   LEU A 212      19.374  28.819  86.700  1.00 60.44           C  
ATOM   1591  O   LEU A 212      18.435  28.076  86.409  1.00 61.00           O  
ATOM   1592  CB  LEU A 212      19.647  30.194  84.585  1.00 59.99           C  
ATOM   1593  CG  LEU A 212      19.319  31.653  84.968  1.00 60.63           C  
ATOM   1594  CD1 LEU A 212      20.570  32.480  85.322  1.00 59.79           C  
ATOM   1595  CD2 LEU A 212      18.491  32.347  83.869  1.00 59.60           C  
ATOM   1596  N   VAL A 213      19.652  29.188  87.945  1.00 61.05           N  
ATOM   1597  CA  VAL A 213      18.798  28.831  89.068  1.00 61.75           C  
ATOM   1598  C   VAL A 213      18.168  30.102  89.616  1.00 62.17           C  
ATOM   1599  O   VAL A 213      18.711  31.200  89.444  1.00 62.61           O  
ATOM   1600  CB  VAL A 213      19.566  28.066  90.203  1.00 61.92           C  
ATOM   1601  CG1 VAL A 213      20.558  27.052  89.623  1.00 62.13           C  
ATOM   1602  CG2 VAL A 213      20.269  29.027  91.168  1.00 61.77           C  
ATOM   1603  N   ASP A 214      17.030  29.963  90.283  1.00 62.44           N  
ATOM   1604  CA  ASP A 214      16.341  31.137  90.801  1.00 62.70           C  
ATOM   1605  C   ASP A 214      16.644  31.381  92.286  1.00 63.51           C  
ATOM   1606  O   ASP A 214      16.538  30.467  93.121  1.00 63.62           O  
ATOM   1607  CB  ASP A 214      14.844  31.037  90.499  1.00 62.25           C  
ATOM   1608  CG  ASP A 214      14.568  30.972  89.008  1.00 60.52           C  
ATOM   1609  OD1 ASP A 214      14.796  31.977  88.315  1.00 57.54           O  
ATOM   1610  OD2 ASP A 214      14.138  29.912  88.519  1.00 59.36           O  
ATOM   1611  N   LEU A 215      17.041  32.615  92.594  1.00 63.92           N  
ATOM   1612  CA  LEU A 215      17.450  33.001  93.944  1.00 64.44           C  
ATOM   1613  C   LEU A 215      16.497  34.056  94.529  1.00 64.94           C  
ATOM   1614  O   LEU A 215      16.399  35.186  94.028  1.00 65.21           O  
ATOM   1615  CB  LEU A 215      18.911  33.520  93.955  1.00 64.18           C  
ATOM   1616  CG  LEU A 215      20.086  32.699  93.387  1.00 63.00           C  
ATOM   1617  CD1 LEU A 215      21.357  33.536  93.306  1.00 61.39           C  
ATOM   1618  CD2 LEU A 215      20.358  31.429  94.171  1.00 61.51           C  
TER    1619      LEU A 215                                                      
END
MOLECULE T0470_112_214.pdb
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
