
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  130 ( 2012),  selected  130 , name 2dnx_A
# Molecule2: number of CA atoms   91 (  736),  selected   91 , name T0470_112_214.pdb
# PARAMETERS: 2dnx_A.T0470_112_214.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    Q     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    D    11_A      S     112          1.888
LGA    F    12_A      I     113          1.836
LGA    S    13_A      E     114          2.066
LGA    S    14_A      G     115          2.260
LGA    I    15_A      K     116          2.010
LGA    I    16_A      L     117          1.643
LGA    Q    17_A      V     118          1.389
LGA    T    18_A      Q     119          1.382
LGA    C    19_A      D     120          1.398
LGA    S    20_A      A     121          1.423
LGA    G    21_A      D     122          1.326
LGA    N    22_A      R     123          1.519
LGA    I    23_A      L     124          1.117
LGA    Q    24_A      D     125          1.052
LGA    R    25_A      A     126          0.471
LGA    I    26_A      L     127          0.923
LGA    S    27_A      G     128          2.220
LGA    -       -      A     129           -
LGA    Q    28_A      I     130          3.021
LGA    A    29_A      G     131          1.834
LGA    T    30_A      I     132          2.623
LGA    A    31_A      A     133          3.199
LGA    Q    32_A      R     134          3.645
LGA    I    33_A      T     135          5.638
LGA    K    34_A      -       -           -
LGA    N    35_A      -       -           -
LGA    L    36_A      F     136          3.741
LGA    M    37_A      A     137           -
LGA    S    38_A      Y     138           -
LGA    -       -      G     139           -
LGA    Q    39_A      G     140           #
LGA    L    40_A      A     141           -
LGA    G    41_A      K     142           -
LGA    T    42_A      G     143           -
LGA    K    43_A      -       -           -
LGA    Q    44_A      -       -           -
LGA    D    45_A      -       -           -
LGA    S    46_A      -       -           -
LGA    S    47_A      R     144          4.929
LGA    K    48_A      L     145          2.644
LGA    L    49_A      M     146          2.678
LGA    Q    50_A      Y     147          2.399
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    E    51_A      P     168          0.534
LGA    N    52_A      S     169          1.453
LGA    L    53_A      L     170          2.189
LGA    Q    54_A      N     171          1.618
LGA    Q    55_A      H     172          1.191
LGA    L    56_A      -       -           -
LGA    Q    57_A      F     173          0.893
LGA    H    58_A      Y     174          2.345
LGA    -       -      E     175           -
LGA    S    59_A      K     176          2.061
LGA    T    60_A      L     177          1.316
LGA    N    61_A      L     178          1.260
LGA    Q    62_A      K     179          2.115
LGA    L    63_A      L     180          1.729
LGA    A    64_A      K     181          1.944
LGA    K    65_A      D     182          2.665
LGA    E    66_A      L     183          1.749
LGA    T    67_A      M     184          2.181
LGA    N    68_A      -       -           -
LGA    E    69_A      -       -           -
LGA    L    70_A      N     185          3.064
LGA    L    71_A      T     186          4.209
LGA    K    72_A      -       -           -
LGA    E    73_A      -       -           -
LGA    L    74_A      -       -           -
LGA    G    75_A      -       -           -
LGA    S    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    P    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    P    80_A      -       -           -
LGA    L    81_A      -       -           -
LGA    S    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    S    84_A      -       -           -
LGA    E    85_A      -       -           -
LGA    Q    86_A      -       -           -
LGA    R    87_A      -       -           -
LGA    Q    88_A      -       -           -
LGA    Q    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    L    91_A      -       -           -
LGA    Q    92_A      -       -           -
LGA    K    93_A      -       -           -
LGA    E    94_A      N     187          4.319
LGA    R    95_A      A     188          2.764
LGA    L    96_A      A     189          2.118
LGA    M    97_A      K     190          3.084
LGA    N    98_A      Q     191          2.949
LGA    D    99_A      E     192          2.170
LGA    F   100_A      A     193          1.854
LGA    S   101_A      E     194          2.875
LGA    A   102_A      V     195          3.031
LGA    A   103_A      R     196          1.434
LGA    L   104_A      H     197          2.000
LGA    N   105_A      R     198          2.753
LGA    N   106_A      Y     199          2.125
LGA    F   107_A      M     200          1.332
LGA    Q   108_A      E     201          2.439
LGA    A   109_A      Q     202          2.587
LGA    V   110_A      F     203          1.164
LGA    Q   111_A      I     204          2.299
LGA    R   112_A      E     205          1.442
LGA    R   113_A      Q     206          1.367
LGA    V   114_A      F     207          2.176
LGA    S   115_A      M     208          2.565
LGA    E   116_A      K     209          1.536
LGA    K   117_A      E     210          3.123
LGA    E   118_A      W     211          4.007
LGA    K   119_A      -       -           -
LGA    E   120_A      -       -           -
LGA    S   121_A      N     212          3.234
LGA    I   122_A      A     213           -
LGA    A   123_A      Q     214          7.534
LGA    R   124_A      -       -           -
LGA    S   125_A      -       -           -
LGA    G   126_A      -       -           -
LGA    P   127_A      -       -           -
LGA    S   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    G   130_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  130   91    5.0     73    2.56     4.11     56.389     2.743

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.777200 * X  +  -0.370582 * Y  +   0.508556 * Z  +  26.478474
  Y_new =   0.501100 * X  +   0.853326 * Y  +  -0.143992 * Z  +  48.984589
  Z_new =  -0.380604 * X  +   0.366748 * Y  +   0.848903 * Z  +  79.723953 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.407806   -2.733786  [ DEG:    23.3656   -156.6344 ]
  Theta =   0.390449    2.751144  [ DEG:    22.3711    157.6289 ]
  Phi   =   0.572676   -2.568917  [ DEG:    32.8119   -147.1881 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dnx_A                                        
REMARK     2: T0470_112_214.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dnx_A.T0470_112_214.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  130   91   5.0   73   2.56    4.11  56.389
REMARK  ---------------------------------------------------------- 
MOLECULE 2dnx_A
HEADER    TRANSPORT PROTEIN                       26-APR-06   2DNX              
TITLE     SOLUTION STRUCTURE OF RSGI RUH-063, AN N-TERMINAL DOMAIN OF           
TITLE    2 SYNTAXIN 12 FROM HUMAN CDNA                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SYNTAXIN-12;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN, RESIDUES 8-124;                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: STX12;                                                         
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P050302-94;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    SYNTAXIN, SNARE, HABC DOMAIN, UP AND DOWN THREE HELIX                 
KEYWDS   2 BUNDLE, LEFT-HANDED TWIST, MEMBRANE FUSION, VESICLE                  
KEYWDS   3 TRANSPORT, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON          
KEYWDS   4 PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                    
KEYWDS   5 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.ABE,H.HIROTA,Y.MUTO,S.YOKOYAMA,RIKEN STRUCTURAL                     
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   26-OCT-06 2DNX    0                                                
JRNL        AUTH   T.ABE,H.HIROTA,Y.MUTO,S.YOKOYAMA                             
JRNL        TITL   SOLUTION STRUCTURE OF RSGI RUH-063, AN N-TERMINAL            
JRNL        TITL 2 DOMAIN OF SYNTAXIN 12 FROM HUMAN CDNA                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DNX A    8   124  UNP    Q86Y82   STX12_HUMAN     18    134             
SEQRES   1 A  130  GLY SER SER GLY SER SER GLY GLN LEU ARG ASP PHE SER          
SEQRES   2 A  130  SER ILE ILE GLN THR CYS SER GLY ASN ILE GLN ARG ILE          
SEQRES   3 A  130  SER GLN ALA THR ALA GLN ILE LYS ASN LEU MET SER GLN          
SEQRES   4 A  130  LEU GLY THR LYS GLN ASP SER SER LYS LEU GLN GLU ASN          
SEQRES   5 A  130  LEU GLN GLN LEU GLN HIS SER THR ASN GLN LEU ALA LYS          
SEQRES   6 A  130  GLU THR ASN GLU LEU LEU LYS GLU LEU GLY SER LEU PRO          
SEQRES   7 A  130  LEU PRO LEU SER THR SER GLU GLN ARG GLN GLN ARG LEU          
SEQRES   8 A  130  GLN LYS GLU ARG LEU MET ASN ASP PHE SER ALA ALA LEU          
SEQRES   9 A  130  ASN ASN PHE GLN ALA VAL GLN ARG ARG VAL SER GLU LYS          
SEQRES  10 A  130  GLU LYS GLU SER ILE ALA ARG SER GLY PRO SER SER GLY          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      46.638  37.248  81.021  1.00  0.00           N  
ATOM      2  CA  GLY A   1      45.879  38.216  80.247  1.00  0.00           C  
ATOM      3  C   GLY A   1      46.477  38.390  78.850  1.00  0.00           C  
ATOM      4  O   GLY A   1      47.200  37.521  78.367  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      44.843  37.890  80.166  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      45.871  39.175  80.766  1.00  0.00           H  
ATOM      7  H1  GLY A   1      47.556  37.057  80.675  1.00  0.00           H  
ATOM      8  N   SER A   2      46.152  39.521  78.239  1.00  0.00           N  
ATOM      9  CA  SER A   2      46.648  39.820  76.906  1.00  0.00           C  
ATOM     10  C   SER A   2      48.157  40.068  76.953  1.00  0.00           C  
ATOM     11  O   SER A   2      48.637  40.843  77.777  1.00  0.00           O  
ATOM     12  CB  SER A   2      45.929  41.032  76.310  1.00  0.00           C  
ATOM     13  OG  SER A   2      45.900  42.133  77.215  1.00  0.00           O  
ATOM     14  H   SER A   2      45.563  40.223  78.639  1.00  0.00           H  
ATOM     15  HA  SER A   2      46.423  38.936  76.309  1.00  0.00           H  
ATOM     16  HB2 SER A   2      46.428  41.333  75.390  1.00  0.00           H  
ATOM     17  HB3 SER A   2      44.909  40.755  76.045  1.00  0.00           H  
ATOM     18  HG  SER A   2      44.983  42.235  77.600  1.00  0.00           H  
ATOM     19  N   SER A   3      48.863  39.395  76.055  1.00  0.00           N  
ATOM     20  CA  SER A   3      50.307  39.533  75.983  1.00  0.00           C  
ATOM     21  C   SER A   3      50.783  39.310  74.547  1.00  0.00           C  
ATOM     22  O   SER A   3      50.896  38.172  74.095  1.00  0.00           O  
ATOM     23  CB  SER A   3      51.001  38.551  76.930  1.00  0.00           C  
ATOM     24  OG  SER A   3      50.496  38.643  78.259  1.00  0.00           O  
ATOM     25  H   SER A   3      48.464  38.766  75.388  1.00  0.00           H  
ATOM     26  HA  SER A   3      50.516  40.553  76.302  1.00  0.00           H  
ATOM     27  HB2 SER A   3      50.867  37.534  76.560  1.00  0.00           H  
ATOM     28  HB3 SER A   3      52.074  38.749  76.935  1.00  0.00           H  
ATOM     29  HG  SER A   3      50.686  37.796  78.757  1.00  0.00           H  
ATOM     30  N   GLY A   4      51.050  40.416  73.868  1.00  0.00           N  
ATOM     31  CA  GLY A   4      51.511  40.357  72.491  1.00  0.00           C  
ATOM     32  C   GLY A   4      50.932  41.510  71.668  1.00  0.00           C  
ATOM     33  O   GLY A   4      50.199  42.347  72.195  1.00  0.00           O  
ATOM     34  H   GLY A   4      50.956  41.338  74.242  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      52.600  40.399  72.467  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      51.219  39.405  72.047  1.00  0.00           H  
ATOM     37  N   SER A   5      51.284  41.518  70.391  1.00  0.00           N  
ATOM     38  CA  SER A   5      50.808  42.554  69.491  1.00  0.00           C  
ATOM     39  C   SER A   5      51.243  42.243  68.057  1.00  0.00           C  
ATOM     40  O   SER A   5      52.408  42.418  67.707  1.00  0.00           O  
ATOM     41  CB  SER A   5      51.323  43.931  69.915  1.00  0.00           C  
ATOM     42  OG  SER A   5      52.731  43.930  70.135  1.00  0.00           O  
ATOM     43  H   SER A   5      51.879  40.834  69.971  1.00  0.00           H  
ATOM     44  HA  SER A   5      49.721  42.533  69.574  1.00  0.00           H  
ATOM     45  HB2 SER A   5      51.077  44.663  69.145  1.00  0.00           H  
ATOM     46  HB3 SER A   5      50.814  44.244  70.826  1.00  0.00           H  
ATOM     47  HG  SER A   5      52.962  44.557  70.878  1.00  0.00           H  
ATOM     48  N   SER A   6      50.283  41.785  67.267  1.00  0.00           N  
ATOM     49  CA  SER A   6      50.552  41.448  65.881  1.00  0.00           C  
ATOM     50  C   SER A   6      49.239  41.171  65.145  1.00  0.00           C  
ATOM     51  O   SER A   6      48.930  41.829  64.152  1.00  0.00           O  
ATOM     52  CB  SER A   6      51.482  40.238  65.778  1.00  0.00           C  
ATOM     53  OG  SER A   6      50.985  39.119  66.508  1.00  0.00           O  
ATOM     54  H   SER A   6      49.336  41.646  67.561  1.00  0.00           H  
ATOM     55  HA  SER A   6      51.048  42.323  65.462  1.00  0.00           H  
ATOM     56  HB2 SER A   6      51.606  39.962  64.732  1.00  0.00           H  
ATOM     57  HB3 SER A   6      52.469  40.507  66.155  1.00  0.00           H  
ATOM     58  HG  SER A   6      50.452  38.526  65.904  1.00  0.00           H  
ATOM     59  N   GLY A   7      48.503  40.197  65.660  1.00  0.00           N  
ATOM     60  CA  GLY A   7      47.231  39.825  65.064  1.00  0.00           C  
ATOM     61  C   GLY A   7      46.339  41.052  64.866  1.00  0.00           C  
ATOM     62  O   GLY A   7      46.206  41.554  63.750  1.00  0.00           O  
ATOM     63  H   GLY A   7      48.762  39.667  66.466  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      47.404  39.338  64.104  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      46.724  39.102  65.702  1.00  0.00           H  
ATOM     66  N   GLN A   8      45.752  41.501  65.965  1.00  0.00           N  
ATOM     67  CA  GLN A   8      44.876  42.660  65.925  1.00  0.00           C  
ATOM     68  C   GLN A   8      43.612  42.343  65.123  1.00  0.00           C  
ATOM     69  O   GLN A   8      43.509  42.703  63.952  1.00  0.00           O  
ATOM     70  CB  GLN A   8      45.601  43.876  65.347  1.00  0.00           C  
ATOM     71  CG  GLN A   8      45.949  44.882  66.447  1.00  0.00           C  
ATOM     72  CD  GLN A   8      46.740  46.062  65.880  1.00  0.00           C  
ATOM     73  OE1 GLN A   8      47.927  46.217  66.115  1.00  0.00           O  
ATOM     74  NE2 GLN A   8      46.019  46.883  65.123  1.00  0.00           N  
ATOM     75  H   GLN A   8      45.865  41.087  66.868  1.00  0.00           H  
ATOM     76  HA  GLN A   8      44.614  42.861  66.964  1.00  0.00           H  
ATOM     77  HB2 GLN A   8      46.512  43.554  64.842  1.00  0.00           H  
ATOM     78  HB3 GLN A   8      44.974  44.356  64.596  1.00  0.00           H  
ATOM     79  HG2 GLN A   8      45.035  45.244  66.916  1.00  0.00           H  
ATOM     80  HG3 GLN A   8      46.533  44.387  67.224  1.00  0.00           H  
ATOM     81 HE21 GLN A   8      45.048  46.698  64.969  1.00  0.00           H  
ATOM     82 HE22 GLN A   8      46.446  47.686  64.706  1.00  0.00           H  
ATOM     83  N   LEU A   9      42.681  41.674  65.788  1.00  0.00           N  
ATOM     84  CA  LEU A   9      41.428  41.304  65.152  1.00  0.00           C  
ATOM     85  C   LEU A   9      40.357  41.095  66.225  1.00  0.00           C  
ATOM     86  O   LEU A   9      40.678  40.849  67.387  1.00  0.00           O  
ATOM     87  CB  LEU A   9      41.627  40.094  64.238  1.00  0.00           C  
ATOM     88  CG  LEU A   9      41.936  40.403  62.772  1.00  0.00           C  
ATOM     89  CD1 LEU A   9      43.208  39.684  62.317  1.00  0.00           C  
ATOM     90  CD2 LEU A   9      40.740  40.073  61.877  1.00  0.00           C  
ATOM     91  H   LEU A   9      42.772  41.385  66.740  1.00  0.00           H  
ATOM     92  HA  LEU A   9      41.124  42.139  64.520  1.00  0.00           H  
ATOM     93  HB2 LEU A   9      42.440  39.490  64.641  1.00  0.00           H  
ATOM     94  HB3 LEU A   9      40.726  39.482  64.277  1.00  0.00           H  
ATOM     95  HG  LEU A   9      42.121  41.473  62.680  1.00  0.00           H  
ATOM     96 HD11 LEU A   9      43.655  40.230  61.486  1.00  0.00           H  
ATOM     97 HD12 LEU A   9      43.915  39.638  63.145  1.00  0.00           H  
ATOM     98 HD13 LEU A   9      42.957  38.673  61.995  1.00  0.00           H  
ATOM     99 HD21 LEU A   9      39.935  40.783  62.070  1.00  0.00           H  
ATOM    100 HD22 LEU A   9      41.039  40.138  60.832  1.00  0.00           H  
ATOM    101 HD23 LEU A   9      40.392  39.063  62.094  1.00  0.00           H  
ATOM    102  N   ARG A  10      39.108  41.202  65.799  1.00  0.00           N  
ATOM    103  CA  ARG A  10      37.989  41.028  66.709  1.00  0.00           C  
ATOM    104  C   ARG A  10      37.863  39.559  67.121  1.00  0.00           C  
ATOM    105  O   ARG A  10      36.882  38.899  66.783  1.00  0.00           O  
ATOM    106  CB  ARG A  10      36.679  41.484  66.065  1.00  0.00           C  
ATOM    107  CG  ARG A  10      36.570  43.010  66.065  1.00  0.00           C  
ATOM    108  CD  ARG A  10      35.106  43.456  66.055  1.00  0.00           C  
ATOM    109  NE  ARG A  10      35.009  44.866  65.616  1.00  0.00           N  
ATOM    110  CZ  ARG A  10      35.224  45.278  64.359  1.00  0.00           C  
ATOM    111  NH1 ARG A  10      35.549  44.391  63.409  1.00  0.00           N  
ATOM    112  NH2 ARG A  10      35.114  46.577  64.052  1.00  0.00           N  
ATOM    113  H   ARG A  10      38.855  41.403  64.852  1.00  0.00           H  
ATOM    114  HA  ARG A  10      38.227  41.656  67.567  1.00  0.00           H  
ATOM    115  HB2 ARG A  10      36.623  41.112  65.042  1.00  0.00           H  
ATOM    116  HB3 ARG A  10      35.834  41.056  66.606  1.00  0.00           H  
ATOM    117  HG2 ARG A  10      37.070  43.415  66.944  1.00  0.00           H  
ATOM    118  HG3 ARG A  10      37.083  43.415  65.192  1.00  0.00           H  
ATOM    119  HD2 ARG A  10      34.528  42.818  65.386  1.00  0.00           H  
ATOM    120  HD3 ARG A  10      34.677  43.346  67.051  1.00  0.00           H  
ATOM    121  HE  ARG A  10      34.768  45.554  66.300  1.00  0.00           H  
ATOM    122 HH11 ARG A  10      35.632  43.421  63.638  1.00  0.00           H  
ATOM    123 HH12 ARG A  10      35.710  44.698  62.471  1.00  0.00           H  
ATOM    124 HH21 ARG A  10      34.870  47.240  64.761  1.00  0.00           H  
ATOM    125 HH22 ARG A  10      35.274  46.886  63.115  1.00  0.00           H  
ATOM    126  N   ASP A  11      38.870  39.092  67.844  1.00  0.00           N  
ATOM    127  CA  ASP A  11      38.885  37.714  68.304  1.00  0.00           C  
ATOM    128  C   ASP A  11      38.001  37.587  69.547  1.00  0.00           C  
ATOM    129  O   ASP A  11      37.811  38.557  70.279  1.00  0.00           O  
ATOM    130  CB  ASP A  11      40.300  37.275  68.684  1.00  0.00           C  
ATOM    131  CG  ASP A  11      41.262  37.107  67.506  1.00  0.00           C  
ATOM    132  OD1 ASP A  11      41.568  38.138  66.871  1.00  0.00           O  
ATOM    133  OD2 ASP A  11      41.669  35.949  67.268  1.00  0.00           O  
ATOM    134  H   ASP A  11      39.664  39.636  68.114  1.00  0.00           H  
ATOM    135  HA  ASP A  11      38.510  37.128  67.466  1.00  0.00           H  
ATOM    136  HB2 ASP A  11      40.718  38.008  69.374  1.00  0.00           H  
ATOM    137  HB3 ASP A  11      40.239  36.329  69.222  1.00  0.00           H  
ATOM    138  N   PHE A  12      37.484  36.384  69.747  1.00  0.00           N  
ATOM    139  CA  PHE A  12      36.626  36.118  70.889  1.00  0.00           C  
ATOM    140  C   PHE A  12      37.218  36.709  72.169  1.00  0.00           C  
ATOM    141  O   PHE A  12      36.508  37.334  72.955  1.00  0.00           O  
ATOM    142  CB  PHE A  12      36.536  34.598  71.036  1.00  0.00           C  
ATOM    143  CG  PHE A  12      35.523  34.133  72.084  1.00  0.00           C  
ATOM    144  CD1 PHE A  12      35.849  34.156  73.403  1.00  0.00           C  
ATOM    145  CD2 PHE A  12      34.295  33.697  71.694  1.00  0.00           C  
ATOM    146  CE1 PHE A  12      34.907  33.725  74.375  1.00  0.00           C  
ATOM    147  CE2 PHE A  12      33.353  33.265  72.666  1.00  0.00           C  
ATOM    148  CZ  PHE A  12      33.679  33.288  73.986  1.00  0.00           C  
ATOM    149  H   PHE A  12      37.644  35.601  69.146  1.00  0.00           H  
ATOM    150  HA  PHE A  12      35.663  36.587  70.685  1.00  0.00           H  
ATOM    151  HB2 PHE A  12      36.272  34.164  70.072  1.00  0.00           H  
ATOM    152  HB3 PHE A  12      37.520  34.211  71.301  1.00  0.00           H  
ATOM    153  HD1 PHE A  12      36.833  34.506  73.715  1.00  0.00           H  
ATOM    154  HD2 PHE A  12      34.033  33.678  70.636  1.00  0.00           H  
ATOM    155  HE1 PHE A  12      35.169  33.743  75.433  1.00  0.00           H  
ATOM    156  HE2 PHE A  12      32.369  32.916  72.354  1.00  0.00           H  
ATOM    157  HZ  PHE A  12      32.957  32.957  74.732  1.00  0.00           H  
ATOM    158  N   SER A  13      38.514  36.490  72.341  1.00  0.00           N  
ATOM    159  CA  SER A  13      39.209  36.994  73.512  1.00  0.00           C  
ATOM    160  C   SER A  13      39.316  38.518  73.443  1.00  0.00           C  
ATOM    161  O   SER A  13      39.294  39.193  74.472  1.00  0.00           O  
ATOM    162  CB  SER A  13      40.600  36.368  73.638  1.00  0.00           C  
ATOM    163  OG  SER A  13      40.614  35.272  74.547  1.00  0.00           O  
ATOM    164  H   SER A  13      39.084  35.981  71.696  1.00  0.00           H  
ATOM    165  HA  SER A  13      38.599  36.691  74.363  1.00  0.00           H  
ATOM    166  HB2 SER A  13      40.936  36.031  72.657  1.00  0.00           H  
ATOM    167  HB3 SER A  13      41.309  37.126  73.973  1.00  0.00           H  
ATOM    168  HG  SER A  13      40.941  34.448  74.085  1.00  0.00           H  
ATOM    169  N   SER A  14      39.430  39.017  72.221  1.00  0.00           N  
ATOM    170  CA  SER A  14      39.540  40.450  72.004  1.00  0.00           C  
ATOM    171  C   SER A  14      38.185  41.120  72.240  1.00  0.00           C  
ATOM    172  O   SER A  14      38.121  42.224  72.779  1.00  0.00           O  
ATOM    173  CB  SER A  14      40.046  40.755  70.593  1.00  0.00           C  
ATOM    174  OG  SER A  14      41.306  40.144  70.332  1.00  0.00           O  
ATOM    175  H   SER A  14      39.448  38.461  71.390  1.00  0.00           H  
ATOM    176  HA  SER A  14      40.272  40.796  72.734  1.00  0.00           H  
ATOM    177  HB2 SER A  14      39.315  40.406  69.863  1.00  0.00           H  
ATOM    178  HB3 SER A  14      40.133  41.834  70.465  1.00  0.00           H  
ATOM    179  HG  SER A  14      41.989  40.843  70.123  1.00  0.00           H  
ATOM    180  N   ILE A  15      37.137  40.424  71.826  1.00  0.00           N  
ATOM    181  CA  ILE A  15      35.787  40.940  71.985  1.00  0.00           C  
ATOM    182  C   ILE A  15      35.365  40.805  73.450  1.00  0.00           C  
ATOM    183  O   ILE A  15      34.907  41.771  74.059  1.00  0.00           O  
ATOM    184  CB  ILE A  15      34.834  40.255  71.004  1.00  0.00           C  
ATOM    185  CG1 ILE A  15      35.366  40.339  69.572  1.00  0.00           C  
ATOM    186  CG2 ILE A  15      33.420  40.827  71.125  1.00  0.00           C  
ATOM    187  CD1 ILE A  15      34.613  39.378  68.650  1.00  0.00           C  
ATOM    188  H   ILE A  15      37.198  39.528  71.388  1.00  0.00           H  
ATOM    189  HA  ILE A  15      35.809  41.998  71.728  1.00  0.00           H  
ATOM    190  HB  ILE A  15      34.776  39.198  71.265  1.00  0.00           H  
ATOM    191 HG12 ILE A  15      35.263  41.359  69.203  1.00  0.00           H  
ATOM    192 HG13 ILE A  15      36.429  40.101  69.562  1.00  0.00           H  
ATOM    193 HG21 ILE A  15      32.706  40.012  71.248  1.00  0.00           H  
ATOM    194 HG22 ILE A  15      33.367  41.488  71.991  1.00  0.00           H  
ATOM    195 HG23 ILE A  15      33.177  41.389  70.223  1.00  0.00           H  
ATOM    196 HD11 ILE A  15      34.196  39.933  67.810  1.00  0.00           H  
ATOM    197 HD12 ILE A  15      35.299  38.618  68.279  1.00  0.00           H  
ATOM    198 HD13 ILE A  15      33.806  38.900  69.205  1.00  0.00           H  
ATOM    199  N   ILE A  16      35.533  39.599  73.973  1.00  0.00           N  
ATOM    200  CA  ILE A  16      35.175  39.325  75.354  1.00  0.00           C  
ATOM    201  C   ILE A  16      35.716  40.444  76.247  1.00  0.00           C  
ATOM    202  O   ILE A  16      34.945  41.199  76.837  1.00  0.00           O  
ATOM    203  CB  ILE A  16      35.646  37.929  75.763  1.00  0.00           C  
ATOM    204  CG1 ILE A  16      34.696  36.853  75.236  1.00  0.00           C  
ATOM    205  CG2 ILE A  16      35.833  37.836  77.279  1.00  0.00           C  
ATOM    206  CD1 ILE A  16      34.382  35.819  76.319  1.00  0.00           C  
ATOM    207  H   ILE A  16      35.907  38.819  73.470  1.00  0.00           H  
ATOM    208  HA  ILE A  16      34.088  39.329  75.416  1.00  0.00           H  
ATOM    209  HB  ILE A  16      36.621  37.750  75.308  1.00  0.00           H  
ATOM    210 HG12 ILE A  16      33.772  37.317  74.891  1.00  0.00           H  
ATOM    211 HG13 ILE A  16      35.145  36.357  74.374  1.00  0.00           H  
ATOM    212 HG21 ILE A  16      36.535  38.603  77.607  1.00  0.00           H  
ATOM    213 HG22 ILE A  16      34.873  37.986  77.773  1.00  0.00           H  
ATOM    214 HG23 ILE A  16      36.225  36.852  77.537  1.00  0.00           H  
ATOM    215 HD11 ILE A  16      35.304  35.328  76.630  1.00  0.00           H  
ATOM    216 HD12 ILE A  16      33.929  36.317  77.175  1.00  0.00           H  
ATOM    217 HD13 ILE A  16      33.690  35.076  75.922  1.00  0.00           H  
ATOM    218  N   GLN A  17      37.037  40.514  76.319  1.00  0.00           N  
ATOM    219  CA  GLN A  17      37.690  41.526  77.131  1.00  0.00           C  
ATOM    220  C   GLN A  17      36.960  42.865  76.998  1.00  0.00           C  
ATOM    221  O   GLN A  17      36.673  43.521  77.998  1.00  0.00           O  
ATOM    222  CB  GLN A  17      39.165  41.667  76.751  1.00  0.00           C  
ATOM    223  CG  GLN A  17      40.003  40.553  77.383  1.00  0.00           C  
ATOM    224  CD  GLN A  17      41.413  41.047  77.711  1.00  0.00           C  
ATOM    225  OE1 GLN A  17      41.656  42.226  77.912  1.00  0.00           O  
ATOM    226  NE2 GLN A  17      42.328  40.082  77.753  1.00  0.00           N  
ATOM    227  H   GLN A  17      37.657  39.896  75.836  1.00  0.00           H  
ATOM    228  HA  GLN A  17      37.618  41.166  78.158  1.00  0.00           H  
ATOM    229  HB2 GLN A  17      39.270  41.635  75.666  1.00  0.00           H  
ATOM    230  HB3 GLN A  17      39.538  42.638  77.078  1.00  0.00           H  
ATOM    231  HG2 GLN A  17      39.517  40.201  78.293  1.00  0.00           H  
ATOM    232  HG3 GLN A  17      40.059  39.705  76.702  1.00  0.00           H  
ATOM    233 HE21 GLN A  17      42.062  39.134  77.579  1.00  0.00           H  
ATOM    234 HE22 GLN A  17      43.280  40.305  77.960  1.00  0.00           H  
ATOM    235  N   THR A  18      36.679  43.229  75.756  1.00  0.00           N  
ATOM    236  CA  THR A  18      35.989  44.477  75.479  1.00  0.00           C  
ATOM    237  C   THR A  18      34.590  44.461  76.099  1.00  0.00           C  
ATOM    238  O   THR A  18      34.177  45.430  76.734  1.00  0.00           O  
ATOM    239  CB  THR A  18      35.978  44.686  73.963  1.00  0.00           C  
ATOM    240  OG1 THR A  18      37.345  44.925  73.638  1.00  0.00           O  
ATOM    241  CG2 THR A  18      35.267  45.977  73.556  1.00  0.00           C  
ATOM    242  H   THR A  18      36.916  42.689  74.948  1.00  0.00           H  
ATOM    243  HA  THR A  18      36.539  45.288  75.955  1.00  0.00           H  
ATOM    244  HB  THR A  18      35.547  43.825  73.454  1.00  0.00           H  
ATOM    245  HG1 THR A  18      37.730  45.608  74.259  1.00  0.00           H  
ATOM    246 HG21 THR A  18      34.219  45.924  73.852  1.00  0.00           H  
ATOM    247 HG22 THR A  18      35.741  46.826  74.048  1.00  0.00           H  
ATOM    248 HG23 THR A  18      35.332  46.103  72.474  1.00  0.00           H  
ATOM    249  N   CYS A  19      33.898  43.349  75.892  1.00  0.00           N  
ATOM    250  CA  CYS A  19      32.555  43.193  76.422  1.00  0.00           C  
ATOM    251  C   CYS A  19      32.609  43.405  77.937  1.00  0.00           C  
ATOM    252  O   CYS A  19      31.851  44.205  78.483  1.00  0.00           O  
ATOM    253  CB  CYS A  19      31.957  41.834  76.057  1.00  0.00           C  
ATOM    254  SG  CYS A  19      31.353  41.859  74.329  1.00  0.00           S  
ATOM    255  H   CYS A  19      34.241  42.565  75.374  1.00  0.00           H  
ATOM    256  HA  CYS A  19      31.940  43.957  75.947  1.00  0.00           H  
ATOM    257  HB2 CYS A  19      32.707  41.052  76.177  1.00  0.00           H  
ATOM    258  HB3 CYS A  19      31.137  41.594  76.734  1.00  0.00           H  
ATOM    259  HG  CYS A  19      30.189  42.445  74.598  1.00  0.00           H  
ATOM    260  N   SER A  20      33.512  42.674  78.572  1.00  0.00           N  
ATOM    261  CA  SER A  20      33.675  42.771  80.013  1.00  0.00           C  
ATOM    262  C   SER A  20      33.787  44.239  80.429  1.00  0.00           C  
ATOM    263  O   SER A  20      33.025  44.709  81.273  1.00  0.00           O  
ATOM    264  CB  SER A  20      34.905  41.991  80.482  1.00  0.00           C  
ATOM    265  OG  SER A  20      34.968  41.897  81.902  1.00  0.00           O  
ATOM    266  H   SER A  20      34.126  42.025  78.121  1.00  0.00           H  
ATOM    267  HA  SER A  20      32.777  42.320  80.436  1.00  0.00           H  
ATOM    268  HB2 SER A  20      34.885  40.990  80.053  1.00  0.00           H  
ATOM    269  HB3 SER A  20      35.806  42.478  80.111  1.00  0.00           H  
ATOM    270  HG  SER A  20      34.075  41.633  82.267  1.00  0.00           H  
ATOM    271  N   GLY A  21      34.742  44.923  79.817  1.00  0.00           N  
ATOM    272  CA  GLY A  21      34.963  46.329  80.113  1.00  0.00           C  
ATOM    273  C   GLY A  21      33.655  47.118  80.032  1.00  0.00           C  
ATOM    274  O   GLY A  21      33.235  47.734  81.011  1.00  0.00           O  
ATOM    275  H   GLY A  21      35.357  44.534  79.131  1.00  0.00           H  
ATOM    276  HA2 GLY A  21      35.393  46.430  81.109  1.00  0.00           H  
ATOM    277  HA3 GLY A  21      35.686  46.743  79.410  1.00  0.00           H  
ATOM    278  N   ASN A  22      33.046  47.075  78.856  1.00  0.00           N  
ATOM    279  CA  ASN A  22      31.794  47.779  78.634  1.00  0.00           C  
ATOM    280  C   ASN A  22      30.896  47.612  79.862  1.00  0.00           C  
ATOM    281  O   ASN A  22      30.459  48.598  80.455  1.00  0.00           O  
ATOM    282  CB  ASN A  22      31.050  47.211  77.424  1.00  0.00           C  
ATOM    283  CG  ASN A  22      31.593  47.800  76.121  1.00  0.00           C  
ATOM    284  OD1 ASN A  22      32.462  48.657  76.111  1.00  0.00           O  
ATOM    285  ND2 ASN A  22      31.036  47.293  75.025  1.00  0.00           N  
ATOM    286  H   ASN A  22      33.394  46.572  78.065  1.00  0.00           H  
ATOM    287  HA  ASN A  22      32.076  48.817  78.462  1.00  0.00           H  
ATOM    288  HB2 ASN A  22      31.150  46.126  77.408  1.00  0.00           H  
ATOM    289  HB3 ASN A  22      29.986  47.432  77.511  1.00  0.00           H  
ATOM    290 HD21 ASN A  22      30.328  46.591  75.103  1.00  0.00           H  
ATOM    291 HD22 ASN A  22      31.326  47.614  74.123  1.00  0.00           H  
ATOM    292  N   ILE A  23      30.649  46.358  80.209  1.00  0.00           N  
ATOM    293  CA  ILE A  23      29.810  46.050  81.355  1.00  0.00           C  
ATOM    294  C   ILE A  23      30.217  46.939  82.532  1.00  0.00           C  
ATOM    295  O   ILE A  23      29.408  47.719  83.034  1.00  0.00           O  
ATOM    296  CB  ILE A  23      29.863  44.553  81.670  1.00  0.00           C  
ATOM    297  CG1 ILE A  23      29.200  43.737  80.558  1.00  0.00           C  
ATOM    298  CG2 ILE A  23      29.249  44.259  83.041  1.00  0.00           C  
ATOM    299  CD1 ILE A  23      29.217  42.243  80.891  1.00  0.00           C  
ATOM    300  H   ILE A  23      31.008  45.562  79.722  1.00  0.00           H  
ATOM    301  HA  ILE A  23      28.783  46.287  81.082  1.00  0.00           H  
ATOM    302  HB  ILE A  23      30.908  44.249  81.713  1.00  0.00           H  
ATOM    303 HG12 ILE A  23      28.172  44.070  80.420  1.00  0.00           H  
ATOM    304 HG13 ILE A  23      29.720  43.909  79.616  1.00  0.00           H  
ATOM    305 HG21 ILE A  23      29.451  43.223  83.314  1.00  0.00           H  
ATOM    306 HG22 ILE A  23      29.687  44.924  83.784  1.00  0.00           H  
ATOM    307 HG23 ILE A  23      28.171  44.420  82.998  1.00  0.00           H  
ATOM    308 HD11 ILE A  23      30.210  41.960  81.240  1.00  0.00           H  
ATOM    309 HD12 ILE A  23      28.485  42.035  81.670  1.00  0.00           H  
ATOM    310 HD13 ILE A  23      28.969  41.669  79.997  1.00  0.00           H  
ATOM    311  N   GLN A  24      31.470  46.793  82.938  1.00  0.00           N  
ATOM    312  CA  GLN A  24      31.993  47.574  84.046  1.00  0.00           C  
ATOM    313  C   GLN A  24      31.516  49.024  83.946  1.00  0.00           C  
ATOM    314  O   GLN A  24      30.818  49.515  84.832  1.00  0.00           O  
ATOM    315  CB  GLN A  24      33.520  47.502  84.095  1.00  0.00           C  
ATOM    316  CG  GLN A  24      33.986  46.254  84.849  1.00  0.00           C  
ATOM    317  CD  GLN A  24      33.912  46.468  86.362  1.00  0.00           C  
ATOM    318  OE1 GLN A  24      34.185  47.540  86.877  1.00  0.00           O  
ATOM    319  NE2 GLN A  24      33.531  45.391  87.042  1.00  0.00           N  
ATOM    320  H   GLN A  24      32.121  46.157  82.524  1.00  0.00           H  
ATOM    321  HA  GLN A  24      31.585  47.112  84.944  1.00  0.00           H  
ATOM    322  HB2 GLN A  24      33.920  47.489  83.081  1.00  0.00           H  
ATOM    323  HB3 GLN A  24      33.915  48.393  84.582  1.00  0.00           H  
ATOM    324  HG2 GLN A  24      33.366  45.403  84.567  1.00  0.00           H  
ATOM    325  HG3 GLN A  24      35.010  46.012  84.561  1.00  0.00           H  
ATOM    326 HE21 GLN A  24      33.321  44.542  86.558  1.00  0.00           H  
ATOM    327 HE22 GLN A  24      33.452  45.431  88.038  1.00  0.00           H  
ATOM    328  N   ARG A  25      31.911  49.670  82.858  1.00  0.00           N  
ATOM    329  CA  ARG A  25      31.533  51.054  82.631  1.00  0.00           C  
ATOM    330  C   ARG A  25      30.037  51.245  82.890  1.00  0.00           C  
ATOM    331  O   ARG A  25      29.648  52.052  83.731  1.00  0.00           O  
ATOM    332  CB  ARG A  25      31.855  51.485  81.199  1.00  0.00           C  
ATOM    333  CG  ARG A  25      33.210  52.193  81.130  1.00  0.00           C  
ATOM    334  CD  ARG A  25      34.224  51.360  80.345  1.00  0.00           C  
ATOM    335  NE  ARG A  25      35.574  51.525  80.929  1.00  0.00           N  
ATOM    336  CZ  ARG A  25      36.708  51.154  80.318  1.00  0.00           C  
ATOM    337  NH1 ARG A  25      36.661  50.597  79.101  1.00  0.00           N  
ATOM    338  NH2 ARG A  25      37.888  51.341  80.924  1.00  0.00           N  
ATOM    339  H   ARG A  25      32.479  49.264  82.143  1.00  0.00           H  
ATOM    340  HA  ARG A  25      32.130  51.627  83.341  1.00  0.00           H  
ATOM    341  HB2 ARG A  25      31.864  50.612  80.546  1.00  0.00           H  
ATOM    342  HB3 ARG A  25      31.074  52.150  80.831  1.00  0.00           H  
ATOM    343  HG2 ARG A  25      33.091  53.168  80.658  1.00  0.00           H  
ATOM    344  HG3 ARG A  25      33.582  52.371  82.139  1.00  0.00           H  
ATOM    345  HD2 ARG A  25      33.936  50.309  80.363  1.00  0.00           H  
ATOM    346  HD3 ARG A  25      34.231  51.671  79.300  1.00  0.00           H  
ATOM    347  HE  ARG A  25      35.645  51.936  81.838  1.00  0.00           H  
ATOM    348 HH11 ARG A  25      35.780  50.457  78.648  1.00  0.00           H  
ATOM    349 HH12 ARG A  25      37.507  50.321  78.644  1.00  0.00           H  
ATOM    350 HH21 ARG A  25      37.923  51.757  81.834  1.00  0.00           H  
ATOM    351 HH22 ARG A  25      38.734  51.065  80.469  1.00  0.00           H  
ATOM    352  N   ILE A  26      29.240  50.488  82.151  1.00  0.00           N  
ATOM    353  CA  ILE A  26      27.795  50.563  82.289  1.00  0.00           C  
ATOM    354  C   ILE A  26      27.432  50.611  83.774  1.00  0.00           C  
ATOM    355  O   ILE A  26      26.663  51.470  84.202  1.00  0.00           O  
ATOM    356  CB  ILE A  26      27.123  49.419  81.528  1.00  0.00           C  
ATOM    357  CG1 ILE A  26      27.451  49.487  80.035  1.00  0.00           C  
ATOM    358  CG2 ILE A  26      25.616  49.400  81.784  1.00  0.00           C  
ATOM    359  CD1 ILE A  26      27.475  48.088  79.415  1.00  0.00           C  
ATOM    360  H   ILE A  26      29.566  49.834  81.468  1.00  0.00           H  
ATOM    361  HA  ILE A  26      27.471  51.493  81.824  1.00  0.00           H  
ATOM    362  HB  ILE A  26      27.525  48.477  81.903  1.00  0.00           H  
ATOM    363 HG12 ILE A  26      26.709  50.101  79.524  1.00  0.00           H  
ATOM    364 HG13 ILE A  26      28.418  49.968  79.893  1.00  0.00           H  
ATOM    365 HG21 ILE A  26      25.347  48.483  82.308  1.00  0.00           H  
ATOM    366 HG22 ILE A  26      25.341  50.261  82.394  1.00  0.00           H  
ATOM    367 HG23 ILE A  26      25.085  49.445  80.834  1.00  0.00           H  
ATOM    368 HD11 ILE A  26      26.668  47.489  79.837  1.00  0.00           H  
ATOM    369 HD12 ILE A  26      27.343  48.166  78.336  1.00  0.00           H  
ATOM    370 HD13 ILE A  26      28.432  47.612  79.630  1.00  0.00           H  
ATOM    371  N   SER A  27      28.002  49.676  84.521  1.00  0.00           N  
ATOM    372  CA  SER A  27      27.748  49.600  85.949  1.00  0.00           C  
ATOM    373  C   SER A  27      28.373  50.804  86.656  1.00  0.00           C  
ATOM    374  O   SER A  27      27.851  51.275  87.667  1.00  0.00           O  
ATOM    375  CB  SER A  27      28.293  48.297  86.538  1.00  0.00           C  
ATOM    376  OG  SER A  27      27.387  47.714  87.471  1.00  0.00           O  
ATOM    377  H   SER A  27      28.626  48.980  84.165  1.00  0.00           H  
ATOM    378  HA  SER A  27      26.663  49.619  86.050  1.00  0.00           H  
ATOM    379  HB2 SER A  27      28.488  47.589  85.732  1.00  0.00           H  
ATOM    380  HB3 SER A  27      29.245  48.492  87.030  1.00  0.00           H  
ATOM    381  HG  SER A  27      27.850  47.554  88.343  1.00  0.00           H  
ATOM    382  N   GLN A  28      29.481  51.268  86.098  1.00  0.00           N  
ATOM    383  CA  GLN A  28      30.183  52.408  86.662  1.00  0.00           C  
ATOM    384  C   GLN A  28      29.332  53.673  86.534  1.00  0.00           C  
ATOM    385  O   GLN A  28      28.901  54.239  87.537  1.00  0.00           O  
ATOM    386  CB  GLN A  28      31.548  52.596  85.997  1.00  0.00           C  
ATOM    387  CG  GLN A  28      32.502  51.459  86.370  1.00  0.00           C  
ATOM    388  CD  GLN A  28      33.923  51.984  86.582  1.00  0.00           C  
ATOM    389  OE1 GLN A  28      34.605  52.397  85.658  1.00  0.00           O  
ATOM    390  NE2 GLN A  28      34.331  51.944  87.848  1.00  0.00           N  
ATOM    391  H   GLN A  28      29.898  50.879  85.277  1.00  0.00           H  
ATOM    392  HA  GLN A  28      30.330  52.166  87.715  1.00  0.00           H  
ATOM    393  HB2 GLN A  28      31.427  52.634  84.914  1.00  0.00           H  
ATOM    394  HB3 GLN A  28      31.977  53.551  86.302  1.00  0.00           H  
ATOM    395  HG2 GLN A  28      32.151  50.969  87.278  1.00  0.00           H  
ATOM    396  HG3 GLN A  28      32.502  50.707  85.582  1.00  0.00           H  
ATOM    397 HE21 GLN A  28      33.722  51.593  88.559  1.00  0.00           H  
ATOM    398 HE22 GLN A  28      35.247  52.266  88.088  1.00  0.00           H  
ATOM    399  N   ALA A  29      29.114  54.077  85.292  1.00  0.00           N  
ATOM    400  CA  ALA A  29      28.321  55.265  85.019  1.00  0.00           C  
ATOM    401  C   ALA A  29      27.030  55.210  85.839  1.00  0.00           C  
ATOM    402  O   ALA A  29      26.603  56.217  86.400  1.00  0.00           O  
ATOM    403  CB  ALA A  29      28.055  55.367  83.516  1.00  0.00           C  
ATOM    404  H   ALA A  29      29.468  53.611  84.482  1.00  0.00           H  
ATOM    405  HA  ALA A  29      28.903  56.131  85.332  1.00  0.00           H  
ATOM    406  HB1 ALA A  29      27.014  55.119  83.315  1.00  0.00           H  
ATOM    407  HB2 ALA A  29      28.258  56.383  83.179  1.00  0.00           H  
ATOM    408  HB3 ALA A  29      28.703  54.672  82.984  1.00  0.00           H  
ATOM    409  N   THR A  30      26.444  54.022  85.881  1.00  0.00           N  
ATOM    410  CA  THR A  30      25.210  53.821  86.621  1.00  0.00           C  
ATOM    411  C   THR A  30      25.413  54.166  88.098  1.00  0.00           C  
ATOM    412  O   THR A  30      24.478  54.590  88.775  1.00  0.00           O  
ATOM    413  CB  THR A  30      24.748  52.381  86.391  1.00  0.00           C  
ATOM    414  OG1 THR A  30      24.100  52.423  85.124  1.00  0.00           O  
ATOM    415  CG2 THR A  30      23.644  51.958  87.362  1.00  0.00           C  
ATOM    416  H   THR A  30      26.798  53.207  85.421  1.00  0.00           H  
ATOM    417  HA  THR A  30      24.461  54.511  86.232  1.00  0.00           H  
ATOM    418  HB  THR A  30      25.591  51.690  86.435  1.00  0.00           H  
ATOM    419  HG1 THR A  30      24.752  52.692  84.415  1.00  0.00           H  
ATOM    420 HG21 THR A  30      23.430  52.777  88.049  1.00  0.00           H  
ATOM    421 HG22 THR A  30      22.743  51.710  86.800  1.00  0.00           H  
ATOM    422 HG23 THR A  30      23.973  51.086  87.927  1.00  0.00           H  
ATOM    423  N   ALA A  31      26.642  53.972  88.555  1.00  0.00           N  
ATOM    424  CA  ALA A  31      26.980  54.256  89.940  1.00  0.00           C  
ATOM    425  C   ALA A  31      27.152  55.766  90.117  1.00  0.00           C  
ATOM    426  O   ALA A  31      26.760  56.323  91.142  1.00  0.00           O  
ATOM    427  CB  ALA A  31      28.236  53.475  90.329  1.00  0.00           C  
ATOM    428  H   ALA A  31      27.397  53.626  87.998  1.00  0.00           H  
ATOM    429  HA  ALA A  31      26.149  53.918  90.560  1.00  0.00           H  
ATOM    430  HB1 ALA A  31      29.096  54.146  90.325  1.00  0.00           H  
ATOM    431  HB2 ALA A  31      28.109  53.056  91.326  1.00  0.00           H  
ATOM    432  HB3 ALA A  31      28.400  52.670  89.614  1.00  0.00           H  
ATOM    433  N   GLN A  32      27.740  56.386  89.105  1.00  0.00           N  
ATOM    434  CA  GLN A  32      27.968  57.821  89.137  1.00  0.00           C  
ATOM    435  C   GLN A  32      26.637  58.570  89.211  1.00  0.00           C  
ATOM    436  O   GLN A  32      26.522  59.570  89.917  1.00  0.00           O  
ATOM    437  CB  GLN A  32      28.785  58.272  87.924  1.00  0.00           C  
ATOM    438  CG  GLN A  32      30.285  58.206  88.217  1.00  0.00           C  
ATOM    439  CD  GLN A  32      31.023  57.429  87.126  1.00  0.00           C  
ATOM    440  OE1 GLN A  32      31.958  57.912  86.508  1.00  0.00           O  
ATOM    441  NE2 GLN A  32      30.554  56.200  86.926  1.00  0.00           N  
ATOM    442  H   GLN A  32      28.056  55.926  88.275  1.00  0.00           H  
ATOM    443  HA  GLN A  32      28.546  58.002  90.043  1.00  0.00           H  
ATOM    444  HB2 GLN A  32      28.550  57.641  87.067  1.00  0.00           H  
ATOM    445  HB3 GLN A  32      28.508  59.291  87.654  1.00  0.00           H  
ATOM    446  HG2 GLN A  32      30.690  59.216  88.287  1.00  0.00           H  
ATOM    447  HG3 GLN A  32      30.450  57.729  89.184  1.00  0.00           H  
ATOM    448 HE21 GLN A  32      29.784  55.865  87.468  1.00  0.00           H  
ATOM    449 HE22 GLN A  32      30.971  55.613  86.232  1.00  0.00           H  
ATOM    450  N   ILE A  33      25.664  58.056  88.472  1.00  0.00           N  
ATOM    451  CA  ILE A  33      24.344  58.664  88.446  1.00  0.00           C  
ATOM    452  C   ILE A  33      23.735  58.612  89.848  1.00  0.00           C  
ATOM    453  O   ILE A  33      23.132  59.583  90.302  1.00  0.00           O  
ATOM    454  CB  ILE A  33      23.473  58.007  87.373  1.00  0.00           C  
ATOM    455  CG1 ILE A  33      23.835  58.524  85.980  1.00  0.00           C  
ATOM    456  CG2 ILE A  33      21.987  58.191  87.684  1.00  0.00           C  
ATOM    457  CD1 ILE A  33      24.113  57.366  85.019  1.00  0.00           C  
ATOM    458  H   ILE A  33      25.766  57.242  87.901  1.00  0.00           H  
ATOM    459  HA  ILE A  33      24.471  59.708  88.162  1.00  0.00           H  
ATOM    460  HB  ILE A  33      23.673  56.935  87.381  1.00  0.00           H  
ATOM    461 HG12 ILE A  33      23.021  59.136  85.592  1.00  0.00           H  
ATOM    462 HG13 ILE A  33      24.714  59.167  86.043  1.00  0.00           H  
ATOM    463 HG21 ILE A  33      21.401  58.010  86.783  1.00  0.00           H  
ATOM    464 HG22 ILE A  33      21.688  57.486  88.460  1.00  0.00           H  
ATOM    465 HG23 ILE A  33      21.813  59.209  88.032  1.00  0.00           H  
ATOM    466 HD11 ILE A  33      24.758  57.710  84.211  1.00  0.00           H  
ATOM    467 HD12 ILE A  33      24.606  56.556  85.558  1.00  0.00           H  
ATOM    468 HD13 ILE A  33      23.172  57.006  84.604  1.00  0.00           H  
ATOM    469  N   LYS A  34      23.915  57.471  90.496  1.00  0.00           N  
ATOM    470  CA  LYS A  34      23.391  57.281  91.838  1.00  0.00           C  
ATOM    471  C   LYS A  34      24.194  58.136  92.819  1.00  0.00           C  
ATOM    472  O   LYS A  34      23.620  58.786  93.694  1.00  0.00           O  
ATOM    473  CB  LYS A  34      23.365  55.793  92.197  1.00  0.00           C  
ATOM    474  CG  LYS A  34      22.058  55.141  91.741  1.00  0.00           C  
ATOM    475  CD  LYS A  34      21.968  53.694  92.229  1.00  0.00           C  
ATOM    476  CE  LYS A  34      20.640  53.057  91.814  1.00  0.00           C  
ATOM    477  NZ  LYS A  34      19.716  52.991  92.968  1.00  0.00           N  
ATOM    478  H   LYS A  34      24.407  56.685  90.119  1.00  0.00           H  
ATOM    479  HA  LYS A  34      22.359  57.630  91.837  1.00  0.00           H  
ATOM    480  HB2 LYS A  34      24.211  55.288  91.730  1.00  0.00           H  
ATOM    481  HB3 LYS A  34      23.480  55.674  93.275  1.00  0.00           H  
ATOM    482  HG2 LYS A  34      21.212  55.711  92.123  1.00  0.00           H  
ATOM    483  HG3 LYS A  34      21.996  55.167  90.653  1.00  0.00           H  
ATOM    484  HD2 LYS A  34      22.797  53.117  91.819  1.00  0.00           H  
ATOM    485  HD3 LYS A  34      22.067  53.665  93.314  1.00  0.00           H  
ATOM    486  HE2 LYS A  34      20.188  53.638  91.010  1.00  0.00           H  
ATOM    487  HE3 LYS A  34      20.817  52.055  91.424  1.00  0.00           H  
ATOM    488  HZ1 LYS A  34      18.829  52.641  92.665  1.00  0.00           H  
ATOM    489  HZ2 LYS A  34      20.094  52.381  93.664  1.00  0.00           H  
ATOM    490  HZ3 LYS A  34      19.599  53.906  93.355  1.00  0.00           H  
ATOM    491  N   ASN A  35      25.506  58.111  92.643  1.00  0.00           N  
ATOM    492  CA  ASN A  35      26.392  58.876  93.503  1.00  0.00           C  
ATOM    493  C   ASN A  35      26.127  60.369  93.300  1.00  0.00           C  
ATOM    494  O   ASN A  35      26.046  61.126  94.266  1.00  0.00           O  
ATOM    495  CB  ASN A  35      27.859  58.606  93.163  1.00  0.00           C  
ATOM    496  CG  ASN A  35      28.395  57.413  93.957  1.00  0.00           C  
ATOM    497  OD1 ASN A  35      28.778  57.524  95.111  1.00  0.00           O  
ATOM    498  ND2 ASN A  35      28.402  56.269  93.279  1.00  0.00           N  
ATOM    499  H   ASN A  35      25.963  57.580  91.930  1.00  0.00           H  
ATOM    500  HA  ASN A  35      26.164  58.547  94.516  1.00  0.00           H  
ATOM    501  HB2 ASN A  35      27.959  58.410  92.096  1.00  0.00           H  
ATOM    502  HB3 ASN A  35      28.457  59.491  93.381  1.00  0.00           H  
ATOM    503 HD21 ASN A  35      28.074  56.247  92.335  1.00  0.00           H  
ATOM    504 HD22 ASN A  35      28.734  55.432  93.713  1.00  0.00           H  
ATOM    505  N   LEU A  36      26.001  60.749  92.037  1.00  0.00           N  
ATOM    506  CA  LEU A  36      25.747  62.139  91.695  1.00  0.00           C  
ATOM    507  C   LEU A  36      24.319  62.507  92.100  1.00  0.00           C  
ATOM    508  O   LEU A  36      24.035  63.664  92.403  1.00  0.00           O  
ATOM    509  CB  LEU A  36      26.051  62.390  90.217  1.00  0.00           C  
ATOM    510  CG  LEU A  36      27.529  62.360  89.821  1.00  0.00           C  
ATOM    511  CD1 LEU A  36      27.688  62.214  88.306  1.00  0.00           C  
ATOM    512  CD2 LEU A  36      28.265  63.588  90.359  1.00  0.00           C  
ATOM    513  H   LEU A  36      26.069  60.128  91.256  1.00  0.00           H  
ATOM    514  HA  LEU A  36      26.440  62.749  92.275  1.00  0.00           H  
ATOM    515  HB2 LEU A  36      25.522  61.644  89.625  1.00  0.00           H  
ATOM    516  HB3 LEU A  36      25.642  63.363  89.943  1.00  0.00           H  
ATOM    517  HG  LEU A  36      27.988  61.484  90.279  1.00  0.00           H  
ATOM    518 HD11 LEU A  36      28.314  61.349  88.088  1.00  0.00           H  
ATOM    519 HD12 LEU A  36      26.708  62.077  87.849  1.00  0.00           H  
ATOM    520 HD13 LEU A  36      28.154  63.112  87.902  1.00  0.00           H  
ATOM    521 HD21 LEU A  36      28.760  63.334  91.297  1.00  0.00           H  
ATOM    522 HD22 LEU A  36      29.011  63.912  89.632  1.00  0.00           H  
ATOM    523 HD23 LEU A  36      27.552  64.394  90.531  1.00  0.00           H  
ATOM    524  N   MET A  37      23.458  61.500  92.093  1.00  0.00           N  
ATOM    525  CA  MET A  37      22.066  61.703  92.457  1.00  0.00           C  
ATOM    526  C   MET A  37      21.950  62.445  93.790  1.00  0.00           C  
ATOM    527  O   MET A  37      21.484  63.583  93.832  1.00  0.00           O  
ATOM    528  CB  MET A  37      21.363  60.347  92.564  1.00  0.00           C  
ATOM    529  CG  MET A  37      20.083  60.326  91.726  1.00  0.00           C  
ATOM    530  SD  MET A  37      19.406  58.676  91.687  1.00  0.00           S  
ATOM    531  CE  MET A  37      20.123  58.082  90.163  1.00  0.00           C  
ATOM    532  H   MET A  37      23.697  60.561  91.846  1.00  0.00           H  
ATOM    533  HA  MET A  37      21.639  62.309  91.658  1.00  0.00           H  
ATOM    534  HB2 MET A  37      22.035  59.558  92.228  1.00  0.00           H  
ATOM    535  HB3 MET A  37      21.123  60.141  93.607  1.00  0.00           H  
ATOM    536  HG2 MET A  37      19.352  61.018  92.146  1.00  0.00           H  
ATOM    537  HG3 MET A  37      20.296  60.665  90.712  1.00  0.00           H  
ATOM    538  HE1 MET A  37      19.340  57.969  89.414  1.00  0.00           H  
ATOM    539  HE2 MET A  37      20.865  58.797  89.808  1.00  0.00           H  
ATOM    540  HE3 MET A  37      20.601  57.119  90.338  1.00  0.00           H  
ATOM    541  N   SER A  38      22.382  61.771  94.845  1.00  0.00           N  
ATOM    542  CA  SER A  38      22.332  62.352  96.176  1.00  0.00           C  
ATOM    543  C   SER A  38      22.899  63.772  96.148  1.00  0.00           C  
ATOM    544  O   SER A  38      22.283  64.702  96.669  1.00  0.00           O  
ATOM    545  CB  SER A  38      23.101  61.493  97.181  1.00  0.00           C  
ATOM    546  OG  SER A  38      22.257  60.993  98.214  1.00  0.00           O  
ATOM    547  H   SER A  38      22.759  60.846  94.802  1.00  0.00           H  
ATOM    548  HA  SER A  38      21.276  62.367  96.445  1.00  0.00           H  
ATOM    549  HB2 SER A  38      23.570  60.658  96.661  1.00  0.00           H  
ATOM    550  HB3 SER A  38      23.904  62.083  97.624  1.00  0.00           H  
ATOM    551  HG  SER A  38      21.313  60.933  97.885  1.00  0.00           H  
ATOM    552  N   GLN A  39      24.067  63.898  95.536  1.00  0.00           N  
ATOM    553  CA  GLN A  39      24.725  65.188  95.432  1.00  0.00           C  
ATOM    554  C   GLN A  39      23.699  66.284  95.137  1.00  0.00           C  
ATOM    555  O   GLN A  39      23.663  67.307  95.820  1.00  0.00           O  
ATOM    556  CB  GLN A  39      25.821  65.163  94.366  1.00  0.00           C  
ATOM    557  CG  GLN A  39      27.208  65.286  95.002  1.00  0.00           C  
ATOM    558  CD  GLN A  39      28.142  66.118  94.121  1.00  0.00           C  
ATOM    559  OE1 GLN A  39      27.890  67.273  93.821  1.00  0.00           O  
ATOM    560  NE2 GLN A  39      29.233  65.468  93.725  1.00  0.00           N  
ATOM    561  H   GLN A  39      24.562  63.136  95.115  1.00  0.00           H  
ATOM    562  HA  GLN A  39      25.179  65.361  96.409  1.00  0.00           H  
ATOM    563  HB2 GLN A  39      25.759  64.234  93.798  1.00  0.00           H  
ATOM    564  HB3 GLN A  39      25.667  65.979  93.661  1.00  0.00           H  
ATOM    565  HG2 GLN A  39      27.121  65.749  95.985  1.00  0.00           H  
ATOM    566  HG3 GLN A  39      27.632  64.294  95.153  1.00  0.00           H  
ATOM    567 HE21 GLN A  39      29.380  64.520  94.007  1.00  0.00           H  
ATOM    568 HE22 GLN A  39      29.906  65.928  93.145  1.00  0.00           H  
ATOM    569  N   LEU A  40      22.889  66.033  94.120  1.00  0.00           N  
ATOM    570  CA  LEU A  40      21.865  66.986  93.725  1.00  0.00           C  
ATOM    571  C   LEU A  40      20.895  67.197  94.889  1.00  0.00           C  
ATOM    572  O   LEU A  40      20.487  68.324  95.165  1.00  0.00           O  
ATOM    573  CB  LEU A  40      21.183  66.535  92.431  1.00  0.00           C  
ATOM    574  CG  LEU A  40      22.089  66.407  91.206  1.00  0.00           C  
ATOM    575  CD1 LEU A  40      21.911  65.045  90.532  1.00  0.00           C  
ATOM    576  CD2 LEU A  40      21.859  67.563  90.230  1.00  0.00           C  
ATOM    577  H   LEU A  40      22.924  65.199  93.569  1.00  0.00           H  
ATOM    578  HA  LEU A  40      22.363  67.932  93.514  1.00  0.00           H  
ATOM    579  HB2 LEU A  40      20.709  65.571  92.612  1.00  0.00           H  
ATOM    580  HB3 LEU A  40      20.388  67.243  92.197  1.00  0.00           H  
ATOM    581  HG  LEU A  40      23.126  66.467  91.539  1.00  0.00           H  
ATOM    582 HD11 LEU A  40      22.785  64.424  90.729  1.00  0.00           H  
ATOM    583 HD12 LEU A  40      21.022  64.555  90.931  1.00  0.00           H  
ATOM    584 HD13 LEU A  40      21.798  65.182  89.457  1.00  0.00           H  
ATOM    585 HD21 LEU A  40      20.813  67.866  90.267  1.00  0.00           H  
ATOM    586 HD22 LEU A  40      22.492  68.405  90.508  1.00  0.00           H  
ATOM    587 HD23 LEU A  40      22.108  67.239  89.219  1.00  0.00           H  
ATOM    588  N   GLY A  41      20.556  66.095  95.543  1.00  0.00           N  
ATOM    589  CA  GLY A  41      19.642  66.145  96.671  1.00  0.00           C  
ATOM    590  C   GLY A  41      20.275  66.876  97.857  1.00  0.00           C  
ATOM    591  O   GLY A  41      20.546  66.269  98.892  1.00  0.00           O  
ATOM    592  H   GLY A  41      20.893  65.183  95.312  1.00  0.00           H  
ATOM    593  HA2 GLY A  41      18.723  66.650  96.377  1.00  0.00           H  
ATOM    594  HA3 GLY A  41      19.369  65.132  96.967  1.00  0.00           H  
ATOM    595  N   THR A  42      20.493  68.169  97.667  1.00  0.00           N  
ATOM    596  CA  THR A  42      21.088  68.989  98.707  1.00  0.00           C  
ATOM    597  C   THR A  42      20.454  70.382  98.717  1.00  0.00           C  
ATOM    598  O   THR A  42      21.159  71.388  98.781  1.00  0.00           O  
ATOM    599  CB  THR A  42      22.602  69.012  98.483  1.00  0.00           C  
ATOM    600  OG1 THR A  42      22.741  69.184  97.075  1.00  0.00           O  
ATOM    601  CG2 THR A  42      23.256  67.657  98.760  1.00  0.00           C  
ATOM    602  H   THR A  42      20.269  68.655  96.821  1.00  0.00           H  
ATOM    603  HA  THR A  42      20.871  68.532  99.672  1.00  0.00           H  
ATOM    604  HB  THR A  42      23.071  69.800  99.073  1.00  0.00           H  
ATOM    605  HG1 THR A  42      23.706  69.136  96.818  1.00  0.00           H  
ATOM    606 HG21 THR A  42      24.340  67.768  98.751  1.00  0.00           H  
ATOM    607 HG22 THR A  42      22.936  67.292  99.735  1.00  0.00           H  
ATOM    608 HG23 THR A  42      22.957  66.945  97.990  1.00  0.00           H  
ATOM    609  N   LYS A  43      19.131  70.394  98.655  1.00  0.00           N  
ATOM    610  CA  LYS A  43      18.395  71.648  98.656  1.00  0.00           C  
ATOM    611  C   LYS A  43      18.536  72.319  97.288  1.00  0.00           C  
ATOM    612  O   LYS A  43      17.541  72.565  96.608  1.00  0.00           O  
ATOM    613  CB  LYS A  43      18.840  72.530  99.824  1.00  0.00           C  
ATOM    614  CG  LYS A  43      17.720  72.682 100.855  1.00  0.00           C  
ATOM    615  CD  LYS A  43      17.037  74.045 100.725  1.00  0.00           C  
ATOM    616  CE  LYS A  43      17.235  74.879 101.992  1.00  0.00           C  
ATOM    617  NZ  LYS A  43      16.531  76.177 101.873  1.00  0.00           N  
ATOM    618  H   LYS A  43      18.566  69.572  98.603  1.00  0.00           H  
ATOM    619  HA  LYS A  43      17.344  71.407  98.816  1.00  0.00           H  
ATOM    620  HB2 LYS A  43      19.720  72.095 100.299  1.00  0.00           H  
ATOM    621  HB3 LYS A  43      19.132  73.512  99.451  1.00  0.00           H  
ATOM    622  HG2 LYS A  43      16.985  71.888 100.718  1.00  0.00           H  
ATOM    623  HG3 LYS A  43      18.128  72.569 101.859  1.00  0.00           H  
ATOM    624  HD2 LYS A  43      17.443  74.579  99.867  1.00  0.00           H  
ATOM    625  HD3 LYS A  43      15.972  73.906 100.539  1.00  0.00           H  
ATOM    626  HE2 LYS A  43      16.857  74.333 102.857  1.00  0.00           H  
ATOM    627  HE3 LYS A  43      18.297  75.049 102.161  1.00  0.00           H  
ATOM    628  HZ1 LYS A  43      16.679  76.713 102.705  1.00  0.00           H  
ATOM    629  HZ2 LYS A  43      16.888  76.678 101.086  1.00  0.00           H  
ATOM    630  HZ3 LYS A  43      15.551  76.015 101.750  1.00  0.00           H  
ATOM    631  N   GLN A  44      19.780  72.596  96.927  1.00  0.00           N  
ATOM    632  CA  GLN A  44      20.064  73.235  95.653  1.00  0.00           C  
ATOM    633  C   GLN A  44      20.554  72.199  94.638  1.00  0.00           C  
ATOM    634  O   GLN A  44      20.707  71.024  94.969  1.00  0.00           O  
ATOM    635  CB  GLN A  44      21.084  74.362  95.821  1.00  0.00           C  
ATOM    636  CG  GLN A  44      20.444  75.724  95.544  1.00  0.00           C  
ATOM    637  CD  GLN A  44      21.412  76.643  94.794  1.00  0.00           C  
ATOM    638  OE1 GLN A  44      22.284  77.272  95.370  1.00  0.00           O  
ATOM    639  NE2 GLN A  44      21.210  76.685  93.481  1.00  0.00           N  
ATOM    640  H   GLN A  44      20.583  72.393  97.486  1.00  0.00           H  
ATOM    641  HA  GLN A  44      19.116  73.656  95.322  1.00  0.00           H  
ATOM    642  HB2 GLN A  44      21.488  74.345  96.833  1.00  0.00           H  
ATOM    643  HB3 GLN A  44      21.921  74.206  95.141  1.00  0.00           H  
ATOM    644  HG2 GLN A  44      19.536  75.591  94.958  1.00  0.00           H  
ATOM    645  HG3 GLN A  44      20.151  76.191  96.485  1.00  0.00           H  
ATOM    646 HE21 GLN A  44      20.476  76.143  93.070  1.00  0.00           H  
ATOM    647 HE22 GLN A  44      21.792  77.257  92.903  1.00  0.00           H  
ATOM    648  N   ASP A  45      20.787  72.673  93.423  1.00  0.00           N  
ATOM    649  CA  ASP A  45      21.257  71.803  92.358  1.00  0.00           C  
ATOM    650  C   ASP A  45      22.318  72.537  91.537  1.00  0.00           C  
ATOM    651  O   ASP A  45      22.489  73.747  91.675  1.00  0.00           O  
ATOM    652  CB  ASP A  45      20.113  71.418  91.417  1.00  0.00           C  
ATOM    653  CG  ASP A  45      19.391  72.597  90.761  1.00  0.00           C  
ATOM    654  OD1 ASP A  45      20.038  73.658  90.631  1.00  0.00           O  
ATOM    655  OD2 ASP A  45      18.207  72.410  90.406  1.00  0.00           O  
ATOM    656  H   ASP A  45      20.660  73.630  93.162  1.00  0.00           H  
ATOM    657  HA  ASP A  45      21.654  70.922  92.862  1.00  0.00           H  
ATOM    658  HB2 ASP A  45      20.510  70.773  90.633  1.00  0.00           H  
ATOM    659  HB3 ASP A  45      19.386  70.830  91.976  1.00  0.00           H  
ATOM    660  N   SER A  46      23.005  71.774  90.699  1.00  0.00           N  
ATOM    661  CA  SER A  46      24.046  72.337  89.855  1.00  0.00           C  
ATOM    662  C   SER A  46      23.999  71.693  88.468  1.00  0.00           C  
ATOM    663  O   SER A  46      23.941  70.471  88.348  1.00  0.00           O  
ATOM    664  CB  SER A  46      25.427  72.145  90.483  1.00  0.00           C  
ATOM    665  OG  SER A  46      25.841  73.290  91.224  1.00  0.00           O  
ATOM    666  H   SER A  46      22.860  70.790  90.592  1.00  0.00           H  
ATOM    667  HA  SER A  46      23.821  73.401  89.791  1.00  0.00           H  
ATOM    668  HB2 SER A  46      25.410  71.275  91.140  1.00  0.00           H  
ATOM    669  HB3 SER A  46      26.156  71.937  89.699  1.00  0.00           H  
ATOM    670  HG  SER A  46      26.599  73.050  91.830  1.00  0.00           H  
ATOM    671  N   SER A  47      24.027  72.546  87.454  1.00  0.00           N  
ATOM    672  CA  SER A  47      23.988  72.077  86.080  1.00  0.00           C  
ATOM    673  C   SER A  47      25.216  71.212  85.788  1.00  0.00           C  
ATOM    674  O   SER A  47      25.164  70.317  84.946  1.00  0.00           O  
ATOM    675  CB  SER A  47      23.918  73.248  85.099  1.00  0.00           C  
ATOM    676  OG  SER A  47      22.804  74.097  85.359  1.00  0.00           O  
ATOM    677  H   SER A  47      24.074  73.539  87.560  1.00  0.00           H  
ATOM    678  HA  SER A  47      23.077  71.484  86.002  1.00  0.00           H  
ATOM    679  HB2 SER A  47      24.838  73.829  85.162  1.00  0.00           H  
ATOM    680  HB3 SER A  47      23.853  72.866  84.080  1.00  0.00           H  
ATOM    681  HG  SER A  47      22.198  74.120  84.563  1.00  0.00           H  
ATOM    682  N   LYS A  48      26.293  71.512  86.498  1.00  0.00           N  
ATOM    683  CA  LYS A  48      27.533  70.772  86.327  1.00  0.00           C  
ATOM    684  C   LYS A  48      27.280  69.289  86.600  1.00  0.00           C  
ATOM    685  O   LYS A  48      27.962  68.426  86.049  1.00  0.00           O  
ATOM    686  CB  LYS A  48      28.641  71.377  87.191  1.00  0.00           C  
ATOM    687  CG  LYS A  48      29.345  72.521  86.459  1.00  0.00           C  
ATOM    688  CD  LYS A  48      30.273  71.984  85.366  1.00  0.00           C  
ATOM    689  CE  LYS A  48      29.993  72.666  84.025  1.00  0.00           C  
ATOM    690  NZ  LYS A  48      31.160  72.535  83.124  1.00  0.00           N  
ATOM    691  H   LYS A  48      26.328  72.241  87.181  1.00  0.00           H  
ATOM    692  HA  LYS A  48      27.838  70.885  85.286  1.00  0.00           H  
ATOM    693  HB2 LYS A  48      28.219  71.744  88.126  1.00  0.00           H  
ATOM    694  HB3 LYS A  48      29.366  70.605  87.450  1.00  0.00           H  
ATOM    695  HG2 LYS A  48      28.604  73.185  86.016  1.00  0.00           H  
ATOM    696  HG3 LYS A  48      29.920  73.114  87.169  1.00  0.00           H  
ATOM    697  HD2 LYS A  48      31.311  72.150  85.653  1.00  0.00           H  
ATOM    698  HD3 LYS A  48      30.138  70.907  85.267  1.00  0.00           H  
ATOM    699  HE2 LYS A  48      29.115  72.218  83.560  1.00  0.00           H  
ATOM    700  HE3 LYS A  48      29.767  73.720  84.187  1.00  0.00           H  
ATOM    701  HZ1 LYS A  48      31.995  72.761  83.624  1.00  0.00           H  
ATOM    702  HZ2 LYS A  48      31.217  71.594  82.788  1.00  0.00           H  
ATOM    703  HZ3 LYS A  48      31.055  73.159  82.350  1.00  0.00           H  
ATOM    704  N   LEU A  49      26.296  69.036  87.451  1.00  0.00           N  
ATOM    705  CA  LEU A  49      25.944  67.672  87.806  1.00  0.00           C  
ATOM    706  C   LEU A  49      24.949  67.124  86.781  1.00  0.00           C  
ATOM    707  O   LEU A  49      25.232  66.142  86.097  1.00  0.00           O  
ATOM    708  CB  LEU A  49      25.441  67.605  89.249  1.00  0.00           C  
ATOM    709  CG  LEU A  49      25.855  68.764  90.157  1.00  0.00           C  
ATOM    710  CD1 LEU A  49      25.357  68.544  91.587  1.00  0.00           C  
ATOM    711  CD2 LEU A  49      27.367  68.991  90.104  1.00  0.00           C  
ATOM    712  H   LEU A  49      25.745  69.743  87.895  1.00  0.00           H  
ATOM    713  HA  LEU A  49      26.855  67.076  87.754  1.00  0.00           H  
ATOM    714  HB2 LEU A  49      24.353  67.553  89.231  1.00  0.00           H  
ATOM    715  HB3 LEU A  49      25.797  66.676  89.694  1.00  0.00           H  
ATOM    716  HG  LEU A  49      25.379  69.674  89.788  1.00  0.00           H  
ATOM    717 HD11 LEU A  49      25.098  67.495  91.725  1.00  0.00           H  
ATOM    718 HD12 LEU A  49      26.143  68.819  92.292  1.00  0.00           H  
ATOM    719 HD13 LEU A  49      24.478  69.162  91.765  1.00  0.00           H  
ATOM    720 HD21 LEU A  49      27.693  69.479  91.023  1.00  0.00           H  
ATOM    721 HD22 LEU A  49      27.874  68.032  90.002  1.00  0.00           H  
ATOM    722 HD23 LEU A  49      27.609  69.624  89.250  1.00  0.00           H  
ATOM    723  N   GLN A  50      23.802  67.785  86.706  1.00  0.00           N  
ATOM    724  CA  GLN A  50      22.762  67.377  85.777  1.00  0.00           C  
ATOM    725  C   GLN A  50      23.380  66.939  84.449  1.00  0.00           C  
ATOM    726  O   GLN A  50      22.958  65.944  83.860  1.00  0.00           O  
ATOM    727  CB  GLN A  50      21.745  68.500  85.565  1.00  0.00           C  
ATOM    728  CG  GLN A  50      20.702  68.513  86.684  1.00  0.00           C  
ATOM    729  CD  GLN A  50      19.714  69.668  86.499  1.00  0.00           C  
ATOM    730  OE1 GLN A  50      19.410  70.086  85.395  1.00  0.00           O  
ATOM    731  NE2 GLN A  50      19.232  70.154  87.639  1.00  0.00           N  
ATOM    732  H   GLN A  50      23.579  68.583  87.266  1.00  0.00           H  
ATOM    733  HA  GLN A  50      22.266  66.530  86.251  1.00  0.00           H  
ATOM    734  HB2 GLN A  50      22.259  69.460  85.531  1.00  0.00           H  
ATOM    735  HB3 GLN A  50      21.249  68.370  84.603  1.00  0.00           H  
ATOM    736  HG2 GLN A  50      20.162  67.566  86.695  1.00  0.00           H  
ATOM    737  HG3 GLN A  50      21.200  68.607  87.649  1.00  0.00           H  
ATOM    738 HE21 GLN A  50      19.523  69.764  88.512  1.00  0.00           H  
ATOM    739 HE22 GLN A  50      18.579  70.912  87.622  1.00  0.00           H  
ATOM    740  N   GLU A  51      24.371  67.703  84.013  1.00  0.00           N  
ATOM    741  CA  GLU A  51      25.052  67.406  82.763  1.00  0.00           C  
ATOM    742  C   GLU A  51      25.857  66.111  82.892  1.00  0.00           C  
ATOM    743  O   GLU A  51      25.814  65.259  82.006  1.00  0.00           O  
ATOM    744  CB  GLU A  51      25.949  68.570  82.338  1.00  0.00           C  
ATOM    745  CG  GLU A  51      25.707  68.943  80.874  1.00  0.00           C  
ATOM    746  CD  GLU A  51      26.967  68.719  80.035  1.00  0.00           C  
ATOM    747  OE1 GLU A  51      27.131  67.578  79.551  1.00  0.00           O  
ATOM    748  OE2 GLU A  51      27.738  69.693  79.897  1.00  0.00           O  
ATOM    749  H   GLU A  51      24.709  68.511  84.496  1.00  0.00           H  
ATOM    750  HA  GLU A  51      24.260  67.279  82.025  1.00  0.00           H  
ATOM    751  HB2 GLU A  51      25.756  69.434  82.974  1.00  0.00           H  
ATOM    752  HB3 GLU A  51      26.995  68.298  82.480  1.00  0.00           H  
ATOM    753  HG2 GLU A  51      24.888  68.346  80.474  1.00  0.00           H  
ATOM    754  HG3 GLU A  51      25.402  69.988  80.807  1.00  0.00           H  
ATOM    755  N   ASN A  52      26.572  66.005  84.003  1.00  0.00           N  
ATOM    756  CA  ASN A  52      27.385  64.828  84.258  1.00  0.00           C  
ATOM    757  C   ASN A  52      26.516  63.576  84.132  1.00  0.00           C  
ATOM    758  O   ASN A  52      26.906  62.610  83.479  1.00  0.00           O  
ATOM    759  CB  ASN A  52      27.968  64.859  85.673  1.00  0.00           C  
ATOM    760  CG  ASN A  52      29.485  64.660  85.646  1.00  0.00           C  
ATOM    761  OD1 ASN A  52      30.082  64.381  84.619  1.00  0.00           O  
ATOM    762  ND2 ASN A  52      30.072  64.819  86.828  1.00  0.00           N  
ATOM    763  H   ASN A  52      26.601  66.703  84.719  1.00  0.00           H  
ATOM    764  HA  ASN A  52      28.180  64.862  83.514  1.00  0.00           H  
ATOM    765  HB2 ASN A  52      27.731  65.811  86.148  1.00  0.00           H  
ATOM    766  HB3 ASN A  52      27.506  64.078  86.277  1.00  0.00           H  
ATOM    767 HD21 ASN A  52      29.524  65.048  87.632  1.00  0.00           H  
ATOM    768 HD22 ASN A  52      31.062  64.709  86.913  1.00  0.00           H  
ATOM    769  N   LEU A  53      25.356  63.633  84.768  1.00  0.00           N  
ATOM    770  CA  LEU A  53      24.428  62.514  84.735  1.00  0.00           C  
ATOM    771  C   LEU A  53      24.231  62.065  83.286  1.00  0.00           C  
ATOM    772  O   LEU A  53      24.648  60.971  82.909  1.00  0.00           O  
ATOM    773  CB  LEU A  53      23.125  62.878  85.449  1.00  0.00           C  
ATOM    774  CG  LEU A  53      23.267  63.394  86.882  1.00  0.00           C  
ATOM    775  CD1 LEU A  53      21.927  63.900  87.419  1.00  0.00           C  
ATOM    776  CD2 LEU A  53      23.882  62.328  87.792  1.00  0.00           C  
ATOM    777  H   LEU A  53      25.046  64.423  85.297  1.00  0.00           H  
ATOM    778  HA  LEU A  53      24.884  61.696  85.292  1.00  0.00           H  
ATOM    779  HB2 LEU A  53      22.610  63.637  84.860  1.00  0.00           H  
ATOM    780  HB3 LEU A  53      22.484  61.997  85.464  1.00  0.00           H  
ATOM    781  HG  LEU A  53      23.952  64.243  86.873  1.00  0.00           H  
ATOM    782 HD11 LEU A  53      21.753  63.486  88.412  1.00  0.00           H  
ATOM    783 HD12 LEU A  53      21.946  64.989  87.478  1.00  0.00           H  
ATOM    784 HD13 LEU A  53      21.127  63.587  86.749  1.00  0.00           H  
ATOM    785 HD21 LEU A  53      24.156  62.777  88.745  1.00  0.00           H  
ATOM    786 HD22 LEU A  53      23.157  61.532  87.959  1.00  0.00           H  
ATOM    787 HD23 LEU A  53      24.772  61.914  87.316  1.00  0.00           H  
ATOM    788  N   GLN A  54      23.592  62.931  82.512  1.00  0.00           N  
ATOM    789  CA  GLN A  54      23.333  62.637  81.113  1.00  0.00           C  
ATOM    790  C   GLN A  54      24.574  62.021  80.463  1.00  0.00           C  
ATOM    791  O   GLN A  54      24.532  60.886  79.989  1.00  0.00           O  
ATOM    792  CB  GLN A  54      22.888  63.893  80.362  1.00  0.00           C  
ATOM    793  CG  GLN A  54      21.580  64.440  80.938  1.00  0.00           C  
ATOM    794  CD  GLN A  54      21.126  65.689  80.178  1.00  0.00           C  
ATOM    795  OE1 GLN A  54      21.903  66.581  79.878  1.00  0.00           O  
ATOM    796  NE2 GLN A  54      19.830  65.702  79.884  1.00  0.00           N  
ATOM    797  H   GLN A  54      23.255  63.819  82.827  1.00  0.00           H  
ATOM    798  HA  GLN A  54      22.518  61.913  81.116  1.00  0.00           H  
ATOM    799  HB2 GLN A  54      23.665  64.655  80.426  1.00  0.00           H  
ATOM    800  HB3 GLN A  54      22.755  63.661  79.305  1.00  0.00           H  
ATOM    801  HG2 GLN A  54      20.806  63.675  80.882  1.00  0.00           H  
ATOM    802  HG3 GLN A  54      21.716  64.681  81.992  1.00  0.00           H  
ATOM    803 HE21 GLN A  54      19.247  64.938  80.160  1.00  0.00           H  
ATOM    804 HE22 GLN A  54      19.438  66.476  79.387  1.00  0.00           H  
ATOM    805  N   GLN A  55      25.649  62.795  80.461  1.00  0.00           N  
ATOM    806  CA  GLN A  55      26.898  62.339  79.876  1.00  0.00           C  
ATOM    807  C   GLN A  55      27.186  60.897  80.298  1.00  0.00           C  
ATOM    808  O   GLN A  55      27.542  60.062  79.466  1.00  0.00           O  
ATOM    809  CB  GLN A  55      28.054  63.264  80.262  1.00  0.00           C  
ATOM    810  CG  GLN A  55      28.631  63.965  79.031  1.00  0.00           C  
ATOM    811  CD  GLN A  55      29.971  63.346  78.625  1.00  0.00           C  
ATOM    812  OE1 GLN A  55      30.036  62.318  77.972  1.00  0.00           O  
ATOM    813  NE2 GLN A  55      31.031  64.029  79.046  1.00  0.00           N  
ATOM    814  H   GLN A  55      25.675  63.716  80.849  1.00  0.00           H  
ATOM    815  HA  GLN A  55      26.748  62.386  78.797  1.00  0.00           H  
ATOM    816  HB2 GLN A  55      27.705  64.008  80.979  1.00  0.00           H  
ATOM    817  HB3 GLN A  55      28.836  62.688  80.757  1.00  0.00           H  
ATOM    818  HG2 GLN A  55      27.926  63.890  78.202  1.00  0.00           H  
ATOM    819  HG3 GLN A  55      28.765  65.026  79.241  1.00  0.00           H  
ATOM    820 HE21 GLN A  55      30.907  64.867  79.579  1.00  0.00           H  
ATOM    821 HE22 GLN A  55      31.952  63.704  78.831  1.00  0.00           H  
ATOM    822  N   LEU A  56      27.022  60.647  81.588  1.00  0.00           N  
ATOM    823  CA  LEU A  56      27.260  59.320  82.130  1.00  0.00           C  
ATOM    824  C   LEU A  56      26.205  58.355  81.586  1.00  0.00           C  
ATOM    825  O   LEU A  56      26.501  57.189  81.325  1.00  0.00           O  
ATOM    826  CB  LEU A  56      27.320  59.367  83.659  1.00  0.00           C  
ATOM    827  CG  LEU A  56      28.649  59.824  84.264  1.00  0.00           C  
ATOM    828  CD1 LEU A  56      28.426  60.545  85.595  1.00  0.00           C  
ATOM    829  CD2 LEU A  56      29.620  58.649  84.403  1.00  0.00           C  
ATOM    830  H   LEU A  56      26.733  61.331  82.258  1.00  0.00           H  
ATOM    831  HA  LEU A  56      28.239  58.994  81.779  1.00  0.00           H  
ATOM    832  HB2 LEU A  56      26.534  60.034  84.012  1.00  0.00           H  
ATOM    833  HB3 LEU A  56      27.091  58.373  84.042  1.00  0.00           H  
ATOM    834  HG  LEU A  56      29.107  60.541  83.582  1.00  0.00           H  
ATOM    835 HD11 LEU A  56      27.560  60.117  86.099  1.00  0.00           H  
ATOM    836 HD12 LEU A  56      29.309  60.426  86.224  1.00  0.00           H  
ATOM    837 HD13 LEU A  56      28.252  61.605  85.409  1.00  0.00           H  
ATOM    838 HD21 LEU A  56      29.513  57.986  83.545  1.00  0.00           H  
ATOM    839 HD22 LEU A  56      30.641  59.026  84.446  1.00  0.00           H  
ATOM    840 HD23 LEU A  56      29.397  58.100  85.317  1.00  0.00           H  
ATOM    841  N   GLN A  57      24.997  58.876  81.430  1.00  0.00           N  
ATOM    842  CA  GLN A  57      23.897  58.075  80.922  1.00  0.00           C  
ATOM    843  C   GLN A  57      24.144  57.702  79.458  1.00  0.00           C  
ATOM    844  O   GLN A  57      24.332  56.529  79.136  1.00  0.00           O  
ATOM    845  CB  GLN A  57      22.564  58.808  81.083  1.00  0.00           C  
ATOM    846  CG  GLN A  57      22.072  58.741  82.530  1.00  0.00           C  
ATOM    847  CD  GLN A  57      20.557  58.942  82.605  1.00  0.00           C  
ATOM    848  OE1 GLN A  57      19.795  58.404  81.819  1.00  0.00           O  
ATOM    849  NE2 GLN A  57      20.166  59.745  83.590  1.00  0.00           N  
ATOM    850  H   GLN A  57      24.766  59.825  81.644  1.00  0.00           H  
ATOM    851  HA  GLN A  57      23.885  57.174  81.536  1.00  0.00           H  
ATOM    852  HB2 GLN A  57      22.679  59.850  80.783  1.00  0.00           H  
ATOM    853  HB3 GLN A  57      21.819  58.367  80.421  1.00  0.00           H  
ATOM    854  HG2 GLN A  57      22.336  57.775  82.962  1.00  0.00           H  
ATOM    855  HG3 GLN A  57      22.573  59.504  83.125  1.00  0.00           H  
ATOM    856 HE21 GLN A  57      20.844  60.156  84.199  1.00  0.00           H  
ATOM    857 HE22 GLN A  57      19.194  59.939  83.720  1.00  0.00           H  
ATOM    858  N   HIS A  58      24.135  58.720  78.611  1.00  0.00           N  
ATOM    859  CA  HIS A  58      24.356  58.514  77.190  1.00  0.00           C  
ATOM    860  C   HIS A  58      25.527  57.551  76.987  1.00  0.00           C  
ATOM    861  O   HIS A  58      25.365  56.489  76.388  1.00  0.00           O  
ATOM    862  CB  HIS A  58      24.556  59.851  76.472  1.00  0.00           C  
ATOM    863  CG  HIS A  58      24.552  59.745  74.966  1.00  0.00           C  
ATOM    864  ND1 HIS A  58      23.387  59.678  74.222  1.00  0.00           N  
ATOM    865  CD2 HIS A  58      25.583  59.696  74.073  1.00  0.00           C  
ATOM    866  CE1 HIS A  58      23.713  59.592  72.941  1.00  0.00           C  
ATOM    867  NE2 HIS A  58      25.074  59.602  72.851  1.00  0.00           N  
ATOM    868  H   HIS A  58      23.982  59.671  78.882  1.00  0.00           H  
ATOM    869  HA  HIS A  58      23.449  58.057  76.796  1.00  0.00           H  
ATOM    870  HB2 HIS A  58      23.769  60.538  76.780  1.00  0.00           H  
ATOM    871  HB3 HIS A  58      25.502  60.286  76.793  1.00  0.00           H  
ATOM    872  HD1 HIS A  58      22.457  59.692  74.589  1.00  0.00           H  
ATOM    873  HD2 HIS A  58      26.643  59.727  74.322  1.00  0.00           H  
ATOM    874  HE1 HIS A  58      23.016  59.524  72.105  1.00  0.00           H  
ATOM    875  N   SER A  59      26.680  57.957  77.498  1.00  0.00           N  
ATOM    876  CA  SER A  59      27.879  57.142  77.380  1.00  0.00           C  
ATOM    877  C   SER A  59      27.527  55.664  77.561  1.00  0.00           C  
ATOM    878  O   SER A  59      27.743  54.856  76.660  1.00  0.00           O  
ATOM    879  CB  SER A  59      28.934  57.566  78.403  1.00  0.00           C  
ATOM    880  OG  SER A  59      30.233  57.089  78.058  1.00  0.00           O  
ATOM    881  H   SER A  59      26.804  58.821  77.984  1.00  0.00           H  
ATOM    882  HA  SER A  59      28.254  57.326  76.374  1.00  0.00           H  
ATOM    883  HB2 SER A  59      28.954  58.653  78.476  1.00  0.00           H  
ATOM    884  HB3 SER A  59      28.659  57.186  79.387  1.00  0.00           H  
ATOM    885  HG  SER A  59      30.921  57.781  78.279  1.00  0.00           H  
ATOM    886  N   THR A  60      26.989  55.356  78.733  1.00  0.00           N  
ATOM    887  CA  THR A  60      26.606  53.989  79.044  1.00  0.00           C  
ATOM    888  C   THR A  60      25.659  53.445  77.972  1.00  0.00           C  
ATOM    889  O   THR A  60      25.819  52.314  77.515  1.00  0.00           O  
ATOM    890  CB  THR A  60      26.004  53.976  80.450  1.00  0.00           C  
ATOM    891  OG1 THR A  60      27.108  54.261  81.303  1.00  0.00           O  
ATOM    892  CG2 THR A  60      25.552  52.578  80.880  1.00  0.00           C  
ATOM    893  H   THR A  60      26.817  56.019  79.461  1.00  0.00           H  
ATOM    894  HA  THR A  60      27.502  53.368  79.025  1.00  0.00           H  
ATOM    895  HB  THR A  60      25.186  54.691  80.530  1.00  0.00           H  
ATOM    896  HG1 THR A  60      27.521  55.135  81.049  1.00  0.00           H  
ATOM    897 HG21 THR A  60      25.697  52.464  81.955  1.00  0.00           H  
ATOM    898 HG22 THR A  60      24.497  52.448  80.639  1.00  0.00           H  
ATOM    899 HG23 THR A  60      26.140  51.828  80.352  1.00  0.00           H  
ATOM    900  N   ASN A  61      24.695  54.275  77.602  1.00  0.00           N  
ATOM    901  CA  ASN A  61      23.723  53.890  76.594  1.00  0.00           C  
ATOM    902  C   ASN A  61      24.447  53.226  75.420  1.00  0.00           C  
ATOM    903  O   ASN A  61      24.261  52.039  75.162  1.00  0.00           O  
ATOM    904  CB  ASN A  61      22.973  55.111  76.057  1.00  0.00           C  
ATOM    905  CG  ASN A  61      21.471  54.837  75.971  1.00  0.00           C  
ATOM    906  OD1 ASN A  61      20.886  54.167  76.806  1.00  0.00           O  
ATOM    907  ND2 ASN A  61      20.879  55.393  74.917  1.00  0.00           N  
ATOM    908  H   ASN A  61      24.572  55.192  77.980  1.00  0.00           H  
ATOM    909  HA  ASN A  61      23.038  53.209  77.099  1.00  0.00           H  
ATOM    910  HB2 ASN A  61      23.154  55.968  76.706  1.00  0.00           H  
ATOM    911  HB3 ASN A  61      23.356  55.372  75.071  1.00  0.00           H  
ATOM    912 HD21 ASN A  61      21.417  55.933  74.268  1.00  0.00           H  
ATOM    913 HD22 ASN A  61      19.897  55.273  74.773  1.00  0.00           H  
ATOM    914  N   GLN A  62      25.259  54.023  74.741  1.00  0.00           N  
ATOM    915  CA  GLN A  62      26.012  53.529  73.601  1.00  0.00           C  
ATOM    916  C   GLN A  62      26.812  52.285  73.993  1.00  0.00           C  
ATOM    917  O   GLN A  62      26.713  51.247  73.340  1.00  0.00           O  
ATOM    918  CB  GLN A  62      26.929  54.615  73.036  1.00  0.00           C  
ATOM    919  CG  GLN A  62      26.229  55.976  73.030  1.00  0.00           C  
ATOM    920  CD  GLN A  62      26.807  56.885  71.944  1.00  0.00           C  
ATOM    921  OE1 GLN A  62      26.749  56.597  70.760  1.00  0.00           O  
ATOM    922  NE2 GLN A  62      27.367  57.998  72.412  1.00  0.00           N  
ATOM    923  H   GLN A  62      25.405  54.989  74.957  1.00  0.00           H  
ATOM    924  HA  GLN A  62      25.265  53.267  72.851  1.00  0.00           H  
ATOM    925  HB2 GLN A  62      27.839  54.674  73.633  1.00  0.00           H  
ATOM    926  HB3 GLN A  62      27.230  54.352  72.022  1.00  0.00           H  
ATOM    927  HG2 GLN A  62      25.161  55.838  72.863  1.00  0.00           H  
ATOM    928  HG3 GLN A  62      26.340  56.451  74.005  1.00  0.00           H  
ATOM    929 HE21 GLN A  62      27.381  58.174  73.396  1.00  0.00           H  
ATOM    930 HE22 GLN A  62      27.774  58.657  71.780  1.00  0.00           H  
ATOM    931  N   LEU A  63      27.587  52.430  75.058  1.00  0.00           N  
ATOM    932  CA  LEU A  63      28.403  51.332  75.545  1.00  0.00           C  
ATOM    933  C   LEU A  63      27.614  50.026  75.433  1.00  0.00           C  
ATOM    934  O   LEU A  63      28.140  49.017  74.968  1.00  0.00           O  
ATOM    935  CB  LEU A  63      28.909  51.626  76.958  1.00  0.00           C  
ATOM    936  CG  LEU A  63      30.374  52.053  77.072  1.00  0.00           C  
ATOM    937  CD1 LEU A  63      30.696  52.536  78.488  1.00  0.00           C  
ATOM    938  CD2 LEU A  63      31.310  50.928  76.623  1.00  0.00           C  
ATOM    939  H   LEU A  63      27.662  53.277  75.583  1.00  0.00           H  
ATOM    940  HA  LEU A  63      29.279  51.263  74.898  1.00  0.00           H  
ATOM    941  HB2 LEU A  63      28.287  52.411  77.390  1.00  0.00           H  
ATOM    942  HB3 LEU A  63      28.764  50.734  77.568  1.00  0.00           H  
ATOM    943  HG  LEU A  63      30.537  52.894  76.399  1.00  0.00           H  
ATOM    944 HD11 LEU A  63      30.869  53.612  78.474  1.00  0.00           H  
ATOM    945 HD12 LEU A  63      29.858  52.311  79.148  1.00  0.00           H  
ATOM    946 HD13 LEU A  63      31.590  52.028  78.851  1.00  0.00           H  
ATOM    947 HD21 LEU A  63      32.291  51.070  77.075  1.00  0.00           H  
ATOM    948 HD22 LEU A  63      30.901  49.968  76.939  1.00  0.00           H  
ATOM    949 HD23 LEU A  63      31.403  50.945  75.538  1.00  0.00           H  
ATOM    950  N   ALA A  64      26.364  50.089  75.865  1.00  0.00           N  
ATOM    951  CA  ALA A  64      25.496  48.924  75.820  1.00  0.00           C  
ATOM    952  C   ALA A  64      25.208  48.566  74.361  1.00  0.00           C  
ATOM    953  O   ALA A  64      25.299  47.402  73.974  1.00  0.00           O  
ATOM    954  CB  ALA A  64      24.219  49.207  76.614  1.00  0.00           C  
ATOM    955  H   ALA A  64      25.943  50.914  76.242  1.00  0.00           H  
ATOM    956  HA  ALA A  64      26.027  48.097  76.291  1.00  0.00           H  
ATOM    957  HB1 ALA A  64      23.953  50.259  76.512  1.00  0.00           H  
ATOM    958  HB2 ALA A  64      23.408  48.588  76.230  1.00  0.00           H  
ATOM    959  HB3 ALA A  64      24.388  48.976  77.666  1.00  0.00           H  
ATOM    960  N   LYS A  65      24.865  49.588  73.590  1.00  0.00           N  
ATOM    961  CA  LYS A  65      24.563  49.395  72.181  1.00  0.00           C  
ATOM    962  C   LYS A  65      25.647  48.521  71.548  1.00  0.00           C  
ATOM    963  O   LYS A  65      25.346  47.641  70.742  1.00  0.00           O  
ATOM    964  CB  LYS A  65      24.375  50.743  71.485  1.00  0.00           C  
ATOM    965  CG  LYS A  65      22.904  51.164  71.493  1.00  0.00           C  
ATOM    966  CD  LYS A  65      22.703  52.443  72.310  1.00  0.00           C  
ATOM    967  CE  LYS A  65      23.290  53.655  71.583  1.00  0.00           C  
ATOM    968  NZ  LYS A  65      22.361  54.128  70.532  1.00  0.00           N  
ATOM    969  H   LYS A  65      24.793  50.531  73.913  1.00  0.00           H  
ATOM    970  HA  LYS A  65      23.612  48.865  72.122  1.00  0.00           H  
ATOM    971  HB2 LYS A  65      24.977  51.503  71.984  1.00  0.00           H  
ATOM    972  HB3 LYS A  65      24.734  50.679  70.457  1.00  0.00           H  
ATOM    973  HG2 LYS A  65      22.562  51.324  70.470  1.00  0.00           H  
ATOM    974  HG3 LYS A  65      22.295  50.363  71.910  1.00  0.00           H  
ATOM    975  HD2 LYS A  65      21.640  52.602  72.489  1.00  0.00           H  
ATOM    976  HD3 LYS A  65      23.179  52.334  73.284  1.00  0.00           H  
ATOM    977  HE2 LYS A  65      23.480  54.457  72.296  1.00  0.00           H  
ATOM    978  HE3 LYS A  65      24.249  53.391  71.137  1.00  0.00           H  
ATOM    979  HZ1 LYS A  65      22.548  53.641  69.678  1.00  0.00           H  
ATOM    980  HZ2 LYS A  65      21.419  53.953  70.816  1.00  0.00           H  
ATOM    981  HZ3 LYS A  65      22.490  55.110  70.390  1.00  0.00           H  
ATOM    982  N   GLU A  66      26.885  48.794  71.934  1.00  0.00           N  
ATOM    983  CA  GLU A  66      28.013  48.042  71.413  1.00  0.00           C  
ATOM    984  C   GLU A  66      28.011  46.621  71.978  1.00  0.00           C  
ATOM    985  O   GLU A  66      28.089  45.650  71.226  1.00  0.00           O  
ATOM    986  CB  GLU A  66      29.333  48.753  71.720  1.00  0.00           C  
ATOM    987  CG  GLU A  66      29.405  50.107  71.012  1.00  0.00           C  
ATOM    988  CD  GLU A  66      30.681  50.220  70.175  1.00  0.00           C  
ATOM    989  OE1 GLU A  66      31.047  49.197  69.557  1.00  0.00           O  
ATOM    990  OE2 GLU A  66      31.261  51.327  70.171  1.00  0.00           O  
ATOM    991  H   GLU A  66      27.120  49.511  72.589  1.00  0.00           H  
ATOM    992  HA  GLU A  66      27.868  48.012  70.332  1.00  0.00           H  
ATOM    993  HB2 GLU A  66      29.431  48.896  72.796  1.00  0.00           H  
ATOM    994  HB3 GLU A  66      30.168  48.128  71.405  1.00  0.00           H  
ATOM    995  HG2 GLU A  66      28.533  50.232  70.370  1.00  0.00           H  
ATOM    996  HG3 GLU A  66      29.377  50.909  71.748  1.00  0.00           H  
ATOM    997  N   THR A  67      27.923  46.543  73.297  1.00  0.00           N  
ATOM    998  CA  THR A  67      27.909  45.256  73.971  1.00  0.00           C  
ATOM    999  C   THR A  67      26.988  44.279  73.238  1.00  0.00           C  
ATOM   1000  O   THR A  67      27.410  43.188  72.857  1.00  0.00           O  
ATOM   1001  CB  THR A  67      27.510  45.489  75.429  1.00  0.00           C  
ATOM   1002  OG1 THR A  67      28.122  46.733  75.761  1.00  0.00           O  
ATOM   1003  CG2 THR A  67      28.162  44.487  76.383  1.00  0.00           C  
ATOM   1004  H   THR A  67      27.860  47.336  73.901  1.00  0.00           H  
ATOM   1005  HA  THR A  67      28.916  44.837  73.932  1.00  0.00           H  
ATOM   1006  HB  THR A  67      26.427  45.485  75.541  1.00  0.00           H  
ATOM   1007  HG1 THR A  67      27.726  47.094  76.606  1.00  0.00           H  
ATOM   1008 HG21 THR A  67      27.865  43.475  76.106  1.00  0.00           H  
ATOM   1009 HG22 THR A  67      29.247  44.577  76.319  1.00  0.00           H  
ATOM   1010 HG23 THR A  67      27.840  44.694  77.404  1.00  0.00           H  
ATOM   1011  N   ASN A  68      25.746  44.706  73.063  1.00  0.00           N  
ATOM   1012  CA  ASN A  68      24.762  43.882  72.382  1.00  0.00           C  
ATOM   1013  C   ASN A  68      25.276  43.528  70.985  1.00  0.00           C  
ATOM   1014  O   ASN A  68      25.118  42.397  70.529  1.00  0.00           O  
ATOM   1015  CB  ASN A  68      23.435  44.628  72.222  1.00  0.00           C  
ATOM   1016  CG  ASN A  68      22.314  43.923  72.986  1.00  0.00           C  
ATOM   1017  OD1 ASN A  68      22.302  43.857  74.204  1.00  0.00           O  
ATOM   1018  ND2 ASN A  68      21.373  43.399  72.204  1.00  0.00           N  
ATOM   1019  H   ASN A  68      25.410  45.594  73.376  1.00  0.00           H  
ATOM   1020  HA  ASN A  68      24.635  43.004  73.015  1.00  0.00           H  
ATOM   1021  HB2 ASN A  68      23.542  45.650  72.587  1.00  0.00           H  
ATOM   1022  HB3 ASN A  68      23.175  44.693  71.165  1.00  0.00           H  
ATOM   1023 HD21 ASN A  68      21.441  43.488  71.211  1.00  0.00           H  
ATOM   1024 HD22 ASN A  68      20.596  42.917  72.611  1.00  0.00           H  
ATOM   1025  N   GLU A  69      25.883  44.516  70.345  1.00  0.00           N  
ATOM   1026  CA  GLU A  69      26.423  44.324  69.009  1.00  0.00           C  
ATOM   1027  C   GLU A  69      27.539  43.278  69.034  1.00  0.00           C  
ATOM   1028  O   GLU A  69      27.586  42.396  68.177  1.00  0.00           O  
ATOM   1029  CB  GLU A  69      26.922  45.647  68.424  1.00  0.00           C  
ATOM   1030  CG  GLU A  69      25.848  46.301  67.553  1.00  0.00           C  
ATOM   1031  CD  GLU A  69      26.434  46.768  66.219  1.00  0.00           C  
ATOM   1032  OE1 GLU A  69      26.478  45.928  65.294  1.00  0.00           O  
ATOM   1033  OE2 GLU A  69      26.825  47.953  66.154  1.00  0.00           O  
ATOM   1034  H   GLU A  69      26.008  45.434  70.723  1.00  0.00           H  
ATOM   1035  HA  GLU A  69      25.588  43.961  68.410  1.00  0.00           H  
ATOM   1036  HB2 GLU A  69      27.203  46.323  69.232  1.00  0.00           H  
ATOM   1037  HB3 GLU A  69      27.819  45.469  67.830  1.00  0.00           H  
ATOM   1038  HG2 GLU A  69      25.040  45.593  67.372  1.00  0.00           H  
ATOM   1039  HG3 GLU A  69      25.415  47.151  68.081  1.00  0.00           H  
ATOM   1040  N   LEU A  70      28.410  43.411  70.024  1.00  0.00           N  
ATOM   1041  CA  LEU A  70      29.522  42.488  70.170  1.00  0.00           C  
ATOM   1042  C   LEU A  70      28.983  41.096  70.507  1.00  0.00           C  
ATOM   1043  O   LEU A  70      29.335  40.116  69.851  1.00  0.00           O  
ATOM   1044  CB  LEU A  70      30.529  43.021  71.191  1.00  0.00           C  
ATOM   1045  CG  LEU A  70      31.248  44.317  70.812  1.00  0.00           C  
ATOM   1046  CD1 LEU A  70      31.954  44.929  72.024  1.00  0.00           C  
ATOM   1047  CD2 LEU A  70      32.209  44.089  69.644  1.00  0.00           C  
ATOM   1048  H   LEU A  70      28.364  44.131  70.715  1.00  0.00           H  
ATOM   1049  HA  LEU A  70      30.034  42.438  69.209  1.00  0.00           H  
ATOM   1050  HB2 LEU A  70      30.008  43.181  72.136  1.00  0.00           H  
ATOM   1051  HB3 LEU A  70      31.279  42.251  71.369  1.00  0.00           H  
ATOM   1052  HG  LEU A  70      30.501  45.037  70.478  1.00  0.00           H  
ATOM   1053 HD11 LEU A  70      32.966  45.219  71.746  1.00  0.00           H  
ATOM   1054 HD12 LEU A  70      31.402  45.807  72.361  1.00  0.00           H  
ATOM   1055 HD13 LEU A  70      31.994  44.195  72.828  1.00  0.00           H  
ATOM   1056 HD21 LEU A  70      33.171  43.746  70.026  1.00  0.00           H  
ATOM   1057 HD22 LEU A  70      31.794  43.335  68.974  1.00  0.00           H  
ATOM   1058 HD23 LEU A  70      32.347  45.022  69.098  1.00  0.00           H  
ATOM   1059  N   LEU A  71      28.139  41.053  71.526  1.00  0.00           N  
ATOM   1060  CA  LEU A  71      27.548  39.798  71.957  1.00  0.00           C  
ATOM   1061  C   LEU A  71      26.968  39.069  70.743  1.00  0.00           C  
ATOM   1062  O   LEU A  71      26.816  37.849  70.762  1.00  0.00           O  
ATOM   1063  CB  LEU A  71      26.531  40.039  73.073  1.00  0.00           C  
ATOM   1064  CG  LEU A  71      27.104  40.498  74.416  1.00  0.00           C  
ATOM   1065  CD1 LEU A  71      26.010  41.095  75.303  1.00  0.00           C  
ATOM   1066  CD2 LEU A  71      27.850  39.359  75.111  1.00  0.00           C  
ATOM   1067  H   LEU A  71      27.858  41.855  72.053  1.00  0.00           H  
ATOM   1068  HA  LEU A  71      28.349  39.188  72.376  1.00  0.00           H  
ATOM   1069  HB2 LEU A  71      25.816  40.787  72.731  1.00  0.00           H  
ATOM   1070  HB3 LEU A  71      25.973  39.117  73.236  1.00  0.00           H  
ATOM   1071  HG  LEU A  71      27.830  41.289  74.225  1.00  0.00           H  
ATOM   1072 HD11 LEU A  71      25.054  41.048  74.783  1.00  0.00           H  
ATOM   1073 HD12 LEU A  71      25.947  40.528  76.232  1.00  0.00           H  
ATOM   1074 HD13 LEU A  71      26.250  42.134  75.529  1.00  0.00           H  
ATOM   1075 HD21 LEU A  71      27.229  38.464  75.110  1.00  0.00           H  
ATOM   1076 HD22 LEU A  71      28.780  39.156  74.581  1.00  0.00           H  
ATOM   1077 HD23 LEU A  71      28.073  39.645  76.140  1.00  0.00           H  
ATOM   1078  N   LYS A  72      26.661  39.849  69.716  1.00  0.00           N  
ATOM   1079  CA  LYS A  72      26.101  39.292  68.496  1.00  0.00           C  
ATOM   1080  C   LYS A  72      27.238  38.817  67.588  1.00  0.00           C  
ATOM   1081  O   LYS A  72      27.146  37.755  66.977  1.00  0.00           O  
ATOM   1082  CB  LYS A  72      25.162  40.300  67.830  1.00  0.00           C  
ATOM   1083  CG  LYS A  72      23.803  40.330  68.532  1.00  0.00           C  
ATOM   1084  CD  LYS A  72      22.976  41.533  68.073  1.00  0.00           C  
ATOM   1085  CE  LYS A  72      22.208  42.149  69.244  1.00  0.00           C  
ATOM   1086  NZ  LYS A  72      21.826  43.545  68.937  1.00  0.00           N  
ATOM   1087  H   LYS A  72      26.789  40.840  69.709  1.00  0.00           H  
ATOM   1088  HA  LYS A  72      25.500  38.428  68.777  1.00  0.00           H  
ATOM   1089  HB2 LYS A  72      25.611  41.293  67.855  1.00  0.00           H  
ATOM   1090  HB3 LYS A  72      25.028  40.038  66.781  1.00  0.00           H  
ATOM   1091  HG2 LYS A  72      23.260  39.408  68.322  1.00  0.00           H  
ATOM   1092  HG3 LYS A  72      23.949  40.375  69.612  1.00  0.00           H  
ATOM   1093  HD2 LYS A  72      23.631  42.282  67.629  1.00  0.00           H  
ATOM   1094  HD3 LYS A  72      22.276  41.222  67.298  1.00  0.00           H  
ATOM   1095  HE2 LYS A  72      21.314  41.559  69.452  1.00  0.00           H  
ATOM   1096  HE3 LYS A  72      22.822  42.123  70.144  1.00  0.00           H  
ATOM   1097  HZ1 LYS A  72      22.522  44.167  69.296  1.00  0.00           H  
ATOM   1098  HZ2 LYS A  72      21.755  43.661  67.946  1.00  0.00           H  
ATOM   1099  HZ3 LYS A  72      20.944  43.750  69.361  1.00  0.00           H  
ATOM   1100  N   GLU A  73      28.284  39.629  67.530  1.00  0.00           N  
ATOM   1101  CA  GLU A  73      29.437  39.305  66.708  1.00  0.00           C  
ATOM   1102  C   GLU A  73      30.234  38.160  67.337  1.00  0.00           C  
ATOM   1103  O   GLU A  73      30.950  37.443  66.642  1.00  0.00           O  
ATOM   1104  CB  GLU A  73      30.321  40.536  66.495  1.00  0.00           C  
ATOM   1105  CG  GLU A  73      31.410  40.621  67.567  1.00  0.00           C  
ATOM   1106  CD  GLU A  73      32.399  41.745  67.254  1.00  0.00           C  
ATOM   1107  OE1 GLU A  73      32.244  42.355  66.174  1.00  0.00           O  
ATOM   1108  OE2 GLU A  73      33.289  41.969  68.103  1.00  0.00           O  
ATOM   1109  H   GLU A  73      28.351  40.492  68.032  1.00  0.00           H  
ATOM   1110  HA  GLU A  73      29.029  38.988  65.748  1.00  0.00           H  
ATOM   1111  HB2 GLU A  73      30.781  40.491  65.508  1.00  0.00           H  
ATOM   1112  HB3 GLU A  73      29.709  41.437  66.520  1.00  0.00           H  
ATOM   1113  HG2 GLU A  73      30.952  40.794  68.541  1.00  0.00           H  
ATOM   1114  HG3 GLU A  73      31.940  39.672  67.628  1.00  0.00           H  
ATOM   1115  N   LEU A  74      30.080  38.026  68.646  1.00  0.00           N  
ATOM   1116  CA  LEU A  74      30.776  36.980  69.377  1.00  0.00           C  
ATOM   1117  C   LEU A  74      30.282  35.613  68.898  1.00  0.00           C  
ATOM   1118  O   LEU A  74      31.032  34.860  68.279  1.00  0.00           O  
ATOM   1119  CB  LEU A  74      30.630  37.192  70.885  1.00  0.00           C  
ATOM   1120  CG  LEU A  74      31.935  37.249  71.684  1.00  0.00           C  
ATOM   1121  CD1 LEU A  74      31.671  37.644  73.138  1.00  0.00           C  
ATOM   1122  CD2 LEU A  74      32.699  35.928  71.579  1.00  0.00           C  
ATOM   1123  H   LEU A  74      29.495  38.613  69.205  1.00  0.00           H  
ATOM   1124  HA  LEU A  74      31.837  37.066  69.141  1.00  0.00           H  
ATOM   1125  HB2 LEU A  74      30.086  38.122  71.051  1.00  0.00           H  
ATOM   1126  HB3 LEU A  74      30.016  36.388  71.287  1.00  0.00           H  
ATOM   1127  HG  LEU A  74      32.568  38.022  71.250  1.00  0.00           H  
ATOM   1128 HD11 LEU A  74      32.191  38.575  73.362  1.00  0.00           H  
ATOM   1129 HD12 LEU A  74      30.600  37.782  73.288  1.00  0.00           H  
ATOM   1130 HD13 LEU A  74      32.033  36.857  73.800  1.00  0.00           H  
ATOM   1131 HD21 LEU A  74      32.000  35.120  71.363  1.00  0.00           H  
ATOM   1132 HD22 LEU A  74      33.434  35.996  70.776  1.00  0.00           H  
ATOM   1133 HD23 LEU A  74      33.208  35.726  72.521  1.00  0.00           H  
ATOM   1134  N   GLY A  75      29.024  35.336  69.203  1.00  0.00           N  
ATOM   1135  CA  GLY A  75      28.420  34.072  68.810  1.00  0.00           C  
ATOM   1136  C   GLY A  75      28.547  33.849  67.302  1.00  0.00           C  
ATOM   1137  O   GLY A  75      28.545  32.711  66.837  1.00  0.00           O  
ATOM   1138  H   GLY A  75      28.420  35.954  69.706  1.00  0.00           H  
ATOM   1139  HA2 GLY A  75      28.902  33.254  69.345  1.00  0.00           H  
ATOM   1140  HA3 GLY A  75      27.369  34.064  69.096  1.00  0.00           H  
ATOM   1141  N   SER A  76      28.653  34.954  66.580  1.00  0.00           N  
ATOM   1142  CA  SER A  76      28.780  34.894  65.134  1.00  0.00           C  
ATOM   1143  C   SER A  76      30.057  34.142  64.752  1.00  0.00           C  
ATOM   1144  O   SER A  76      30.059  33.355  63.806  1.00  0.00           O  
ATOM   1145  CB  SER A  76      28.786  36.296  64.522  1.00  0.00           C  
ATOM   1146  OG  SER A  76      28.119  36.332  63.263  1.00  0.00           O  
ATOM   1147  H   SER A  76      28.653  35.877  66.966  1.00  0.00           H  
ATOM   1148  HA  SER A  76      27.899  34.351  64.789  1.00  0.00           H  
ATOM   1149  HB2 SER A  76      28.304  36.993  65.207  1.00  0.00           H  
ATOM   1150  HB3 SER A  76      29.815  36.632  64.397  1.00  0.00           H  
ATOM   1151  HG  SER A  76      28.769  36.561  62.538  1.00  0.00           H  
ATOM   1152  N   LEU A  77      31.113  34.412  65.506  1.00  0.00           N  
ATOM   1153  CA  LEU A  77      32.393  33.771  65.258  1.00  0.00           C  
ATOM   1154  C   LEU A  77      32.178  32.268  65.072  1.00  0.00           C  
ATOM   1155  O   LEU A  77      31.180  31.719  65.533  1.00  0.00           O  
ATOM   1156  CB  LEU A  77      33.389  34.119  66.366  1.00  0.00           C  
ATOM   1157  CG  LEU A  77      33.666  35.608  66.576  1.00  0.00           C  
ATOM   1158  CD1 LEU A  77      34.460  35.843  67.863  1.00  0.00           C  
ATOM   1159  CD2 LEU A  77      34.362  36.215  65.356  1.00  0.00           C  
ATOM   1160  H   LEU A  77      31.102  35.054  66.272  1.00  0.00           H  
ATOM   1161  HA  LEU A  77      32.789  34.181  64.328  1.00  0.00           H  
ATOM   1162  HB2 LEU A  77      33.019  33.702  67.303  1.00  0.00           H  
ATOM   1163  HB3 LEU A  77      34.334  33.621  66.148  1.00  0.00           H  
ATOM   1164  HG  LEU A  77      32.711  36.121  66.690  1.00  0.00           H  
ATOM   1165 HD11 LEU A  77      33.795  36.227  68.636  1.00  0.00           H  
ATOM   1166 HD12 LEU A  77      34.898  34.901  68.195  1.00  0.00           H  
ATOM   1167 HD13 LEU A  77      35.254  36.565  67.674  1.00  0.00           H  
ATOM   1168 HD21 LEU A  77      35.231  36.788  65.680  1.00  0.00           H  
ATOM   1169 HD22 LEU A  77      34.683  35.416  64.687  1.00  0.00           H  
ATOM   1170 HD23 LEU A  77      33.669  36.872  64.831  1.00  0.00           H  
ATOM   1171  N   PRO A  78      33.159  31.630  64.378  1.00  0.00           N  
ATOM   1172  CA  PRO A  78      33.087  30.200  64.126  1.00  0.00           C  
ATOM   1173  C   PRO A  78      33.414  29.403  65.391  1.00  0.00           C  
ATOM   1174  O   PRO A  78      33.667  29.982  66.446  1.00  0.00           O  
ATOM   1175  CB  PRO A  78      34.071  29.951  62.995  1.00  0.00           C  
ATOM   1176  CG  PRO A  78      34.993  31.158  62.971  1.00  0.00           C  
ATOM   1177  CD  PRO A  78      34.356  32.249  63.818  1.00  0.00           C  
ATOM   1178  HA  PRO A  78      32.156  29.939  63.872  1.00  0.00           H  
ATOM   1179  HB2 PRO A  78      34.635  29.032  63.164  1.00  0.00           H  
ATOM   1180  HB3 PRO A  78      33.552  29.835  62.044  1.00  0.00           H  
ATOM   1181  HG2 PRO A  78      35.976  30.897  63.361  1.00  0.00           H  
ATOM   1182  HG3 PRO A  78      35.138  31.507  61.947  1.00  0.00           H  
ATOM   1183  HD2 PRO A  78      35.033  32.584  64.604  1.00  0.00           H  
ATOM   1184  HD3 PRO A  78      34.106  33.122  63.218  1.00  0.00           H  
ATOM   1185  N   LEU A  79      33.398  28.087  65.243  1.00  0.00           N  
ATOM   1186  CA  LEU A  79      33.690  27.204  66.360  1.00  0.00           C  
ATOM   1187  C   LEU A  79      34.946  26.388  66.044  1.00  0.00           C  
ATOM   1188  O   LEU A  79      35.215  26.080  64.885  1.00  0.00           O  
ATOM   1189  CB  LEU A  79      32.469  26.347  66.699  1.00  0.00           C  
ATOM   1190  CG  LEU A  79      31.162  27.107  66.934  1.00  0.00           C  
ATOM   1191  CD1 LEU A  79      30.099  26.699  65.910  1.00  0.00           C  
ATOM   1192  CD2 LEU A  79      30.672  26.923  68.371  1.00  0.00           C  
ATOM   1193  H   LEU A  79      33.192  27.623  64.381  1.00  0.00           H  
ATOM   1194  HA  LEU A  79      33.895  27.832  67.227  1.00  0.00           H  
ATOM   1195  HB2 LEU A  79      32.312  25.636  65.889  1.00  0.00           H  
ATOM   1196  HB3 LEU A  79      32.695  25.767  67.593  1.00  0.00           H  
ATOM   1197  HG  LEU A  79      31.354  28.170  66.792  1.00  0.00           H  
ATOM   1198 HD11 LEU A  79      29.112  26.962  66.288  1.00  0.00           H  
ATOM   1199 HD12 LEU A  79      30.281  27.221  64.971  1.00  0.00           H  
ATOM   1200 HD13 LEU A  79      30.150  25.623  65.743  1.00  0.00           H  
ATOM   1201 HD21 LEU A  79      31.356  27.427  69.055  1.00  0.00           H  
ATOM   1202 HD22 LEU A  79      29.676  27.353  68.473  1.00  0.00           H  
ATOM   1203 HD23 LEU A  79      30.636  25.861  68.611  1.00  0.00           H  
ATOM   1204  N   PRO A  80      35.700  26.054  67.126  1.00  0.00           N  
ATOM   1205  CA  PRO A  80      36.921  25.280  66.976  1.00  0.00           C  
ATOM   1206  C   PRO A  80      36.606  23.808  66.697  1.00  0.00           C  
ATOM   1207  O   PRO A  80      35.466  23.372  66.855  1.00  0.00           O  
ATOM   1208  CB  PRO A  80      37.680  25.488  68.276  1.00  0.00           C  
ATOM   1209  CG  PRO A  80      36.656  25.987  69.282  1.00  0.00           C  
ATOM   1210  CD  PRO A  80      35.412  26.402  68.514  1.00  0.00           C  
ATOM   1211  HA  PRO A  80      37.441  25.603  66.186  1.00  0.00           H  
ATOM   1212  HB2 PRO A  80      38.138  24.559  68.613  1.00  0.00           H  
ATOM   1213  HB3 PRO A  80      38.485  26.212  68.147  1.00  0.00           H  
ATOM   1214  HG2 PRO A  80      36.417  25.205  70.003  1.00  0.00           H  
ATOM   1215  HG3 PRO A  80      37.054  26.830  69.847  1.00  0.00           H  
ATOM   1216  HD2 PRO A  80      34.528  25.878  68.879  1.00  0.00           H  
ATOM   1217  HD3 PRO A  80      35.217  27.468  68.622  1.00  0.00           H  
ATOM   1218  N   LEU A  81      37.636  23.083  66.287  1.00  0.00           N  
ATOM   1219  CA  LEU A  81      37.484  21.671  65.984  1.00  0.00           C  
ATOM   1220  C   LEU A  81      37.218  20.902  67.279  1.00  0.00           C  
ATOM   1221  O   LEU A  81      36.499  19.904  67.277  1.00  0.00           O  
ATOM   1222  CB  LEU A  81      38.694  21.157  65.201  1.00  0.00           C  
ATOM   1223  CG  LEU A  81      38.715  21.485  63.707  1.00  0.00           C  
ATOM   1224  CD1 LEU A  81      38.227  20.296  62.878  1.00  0.00           C  
ATOM   1225  CD2 LEU A  81      37.915  22.756  63.413  1.00  0.00           C  
ATOM   1226  H   LEU A  81      38.559  23.446  66.161  1.00  0.00           H  
ATOM   1227  HA  LEU A  81      36.613  21.567  65.336  1.00  0.00           H  
ATOM   1228  HB2 LEU A  81      39.596  21.567  65.655  1.00  0.00           H  
ATOM   1229  HB3 LEU A  81      38.743  20.074  65.316  1.00  0.00           H  
ATOM   1230  HG  LEU A  81      39.746  21.680  63.415  1.00  0.00           H  
ATOM   1231 HD11 LEU A  81      37.932  19.485  63.543  1.00  0.00           H  
ATOM   1232 HD12 LEU A  81      37.371  20.599  62.275  1.00  0.00           H  
ATOM   1233 HD13 LEU A  81      39.030  19.955  62.224  1.00  0.00           H  
ATOM   1234 HD21 LEU A  81      38.028  23.022  62.363  1.00  0.00           H  
ATOM   1235 HD22 LEU A  81      36.861  22.579  63.631  1.00  0.00           H  
ATOM   1236 HD23 LEU A  81      38.283  23.570  64.037  1.00  0.00           H  
ATOM   1237  N   SER A  82      37.813  21.395  68.355  1.00  0.00           N  
ATOM   1238  CA  SER A  82      37.649  20.766  69.655  1.00  0.00           C  
ATOM   1239  C   SER A  82      36.338  21.226  70.297  1.00  0.00           C  
ATOM   1240  O   SER A  82      35.997  22.407  70.244  1.00  0.00           O  
ATOM   1241  CB  SER A  82      38.831  21.085  70.574  1.00  0.00           C  
ATOM   1242  OG  SER A  82      39.883  20.133  70.440  1.00  0.00           O  
ATOM   1243  H   SER A  82      38.397  22.206  68.349  1.00  0.00           H  
ATOM   1244  HA  SER A  82      37.623  19.695  69.457  1.00  0.00           H  
ATOM   1245  HB2 SER A  82      39.211  22.080  70.343  1.00  0.00           H  
ATOM   1246  HB3 SER A  82      38.490  21.106  71.609  1.00  0.00           H  
ATOM   1247  HG  SER A  82      39.512  19.253  70.145  1.00  0.00           H  
ATOM   1248  N   THR A  83      35.640  20.269  70.890  1.00  0.00           N  
ATOM   1249  CA  THR A  83      34.375  20.561  71.541  1.00  0.00           C  
ATOM   1250  C   THR A  83      34.614  21.194  72.914  1.00  0.00           C  
ATOM   1251  O   THR A  83      33.724  21.834  73.470  1.00  0.00           O  
ATOM   1252  CB  THR A  83      33.565  19.264  71.604  1.00  0.00           C  
ATOM   1253  OG1 THR A  83      33.524  18.815  70.253  1.00  0.00           O  
ATOM   1254  CG2 THR A  83      32.097  19.507  71.961  1.00  0.00           C  
ATOM   1255  H   THR A  83      35.924  19.311  70.930  1.00  0.00           H  
ATOM   1256  HA  THR A  83      33.839  21.296  70.940  1.00  0.00           H  
ATOM   1257  HB  THR A  83      34.021  18.553  72.294  1.00  0.00           H  
ATOM   1258  HG1 THR A  83      33.708  17.833  70.212  1.00  0.00           H  
ATOM   1259 HG21 THR A  83      32.022  19.800  73.008  1.00  0.00           H  
ATOM   1260 HG22 THR A  83      31.696  20.301  71.331  1.00  0.00           H  
ATOM   1261 HG23 THR A  83      31.528  18.592  71.798  1.00  0.00           H  
ATOM   1262  N   SER A  84      35.823  20.993  73.420  1.00  0.00           N  
ATOM   1263  CA  SER A  84      36.191  21.536  74.715  1.00  0.00           C  
ATOM   1264  C   SER A  84      36.197  23.064  74.660  1.00  0.00           C  
ATOM   1265  O   SER A  84      35.739  23.725  75.591  1.00  0.00           O  
ATOM   1266  CB  SER A  84      37.559  21.015  75.163  1.00  0.00           C  
ATOM   1267  OG  SER A  84      38.402  20.713  74.055  1.00  0.00           O  
ATOM   1268  H   SER A  84      36.541  20.470  72.961  1.00  0.00           H  
ATOM   1269  HA  SER A  84      35.425  21.181  75.405  1.00  0.00           H  
ATOM   1270  HB2 SER A  84      38.042  21.762  75.793  1.00  0.00           H  
ATOM   1271  HB3 SER A  84      37.425  20.121  75.772  1.00  0.00           H  
ATOM   1272  HG  SER A  84      39.201  21.313  74.059  1.00  0.00           H  
ATOM   1273  N   GLU A  85      36.722  23.582  73.560  1.00  0.00           N  
ATOM   1274  CA  GLU A  85      36.793  25.022  73.370  1.00  0.00           C  
ATOM   1275  C   GLU A  85      35.422  25.575  72.980  1.00  0.00           C  
ATOM   1276  O   GLU A  85      35.143  26.756  73.184  1.00  0.00           O  
ATOM   1277  CB  GLU A  85      37.849  25.385  72.323  1.00  0.00           C  
ATOM   1278  CG  GLU A  85      39.261  25.213  72.886  1.00  0.00           C  
ATOM   1279  CD  GLU A  85      39.421  25.967  74.207  1.00  0.00           C  
ATOM   1280  OE1 GLU A  85      39.335  27.213  74.163  1.00  0.00           O  
ATOM   1281  OE2 GLU A  85      39.623  25.280  75.232  1.00  0.00           O  
ATOM   1282  H   GLU A  85      37.092  23.038  72.807  1.00  0.00           H  
ATOM   1283  HA  GLU A  85      37.094  25.426  74.336  1.00  0.00           H  
ATOM   1284  HB2 GLU A  85      37.726  24.754  71.443  1.00  0.00           H  
ATOM   1285  HB3 GLU A  85      37.705  26.416  72.000  1.00  0.00           H  
ATOM   1286  HG2 GLU A  85      39.469  24.154  73.040  1.00  0.00           H  
ATOM   1287  HG3 GLU A  85      39.992  25.579  72.164  1.00  0.00           H  
ATOM   1288  N   GLN A  86      34.600  24.696  72.425  1.00  0.00           N  
ATOM   1289  CA  GLN A  86      33.264  25.081  72.005  1.00  0.00           C  
ATOM   1290  C   GLN A  86      32.429  25.508  73.213  1.00  0.00           C  
ATOM   1291  O   GLN A  86      31.827  26.581  73.210  1.00  0.00           O  
ATOM   1292  CB  GLN A  86      32.580  23.945  71.241  1.00  0.00           C  
ATOM   1293  CG  GLN A  86      33.177  23.790  69.840  1.00  0.00           C  
ATOM   1294  CD  GLN A  86      32.631  22.540  69.146  1.00  0.00           C  
ATOM   1295  OE1 GLN A  86      31.466  22.195  69.260  1.00  0.00           O  
ATOM   1296  NE2 GLN A  86      33.535  21.883  68.425  1.00  0.00           N  
ATOM   1297  H   GLN A  86      34.834  23.736  72.262  1.00  0.00           H  
ATOM   1298  HA  GLN A  86      33.405  25.929  71.334  1.00  0.00           H  
ATOM   1299  HB2 GLN A  86      32.691  23.013  71.792  1.00  0.00           H  
ATOM   1300  HB3 GLN A  86      31.512  24.145  71.164  1.00  0.00           H  
ATOM   1301  HG2 GLN A  86      32.946  24.672  69.242  1.00  0.00           H  
ATOM   1302  HG3 GLN A  86      34.263  23.726  69.908  1.00  0.00           H  
ATOM   1303 HE21 GLN A  86      34.474  22.221  68.374  1.00  0.00           H  
ATOM   1304 HE22 GLN A  86      33.274  21.052  67.933  1.00  0.00           H  
ATOM   1305  N   ARG A  87      32.420  24.646  74.220  1.00  0.00           N  
ATOM   1306  CA  ARG A  87      31.669  24.921  75.433  1.00  0.00           C  
ATOM   1307  C   ARG A  87      32.249  26.140  76.151  1.00  0.00           C  
ATOM   1308  O   ARG A  87      31.525  27.086  76.459  1.00  0.00           O  
ATOM   1309  CB  ARG A  87      31.696  23.719  76.381  1.00  0.00           C  
ATOM   1310  CG  ARG A  87      30.292  23.398  76.898  1.00  0.00           C  
ATOM   1311  CD  ARG A  87      30.029  21.891  76.871  1.00  0.00           C  
ATOM   1312  NE  ARG A  87      30.097  21.341  78.243  1.00  0.00           N  
ATOM   1313  CZ  ARG A  87      30.081  20.032  78.530  1.00  0.00           C  
ATOM   1314  NH1 ARG A  87      29.999  19.131  77.541  1.00  0.00           N  
ATOM   1315  NH2 ARG A  87      30.146  19.625  79.805  1.00  0.00           N  
ATOM   1316  H   ARG A  87      32.911  23.775  74.215  1.00  0.00           H  
ATOM   1317  HA  ARG A  87      30.651  25.113  75.094  1.00  0.00           H  
ATOM   1318  HB2 ARG A  87      32.103  22.852  75.863  1.00  0.00           H  
ATOM   1319  HB3 ARG A  87      32.357  23.929  77.221  1.00  0.00           H  
ATOM   1320  HG2 ARG A  87      30.179  23.772  77.915  1.00  0.00           H  
ATOM   1321  HG3 ARG A  87      29.548  23.911  76.286  1.00  0.00           H  
ATOM   1322  HD2 ARG A  87      29.049  21.691  76.438  1.00  0.00           H  
ATOM   1323  HD3 ARG A  87      30.765  21.397  76.236  1.00  0.00           H  
ATOM   1324  HE  ARG A  87      30.158  21.987  79.005  1.00  0.00           H  
ATOM   1325 HH11 ARG A  87      29.950  19.435  76.590  1.00  0.00           H  
ATOM   1326 HH12 ARG A  87      29.987  18.154  77.755  1.00  0.00           H  
ATOM   1327 HH21 ARG A  87      30.207  20.297  80.542  1.00  0.00           H  
ATOM   1328 HH22 ARG A  87      30.134  18.648  80.018  1.00  0.00           H  
ATOM   1329  N   GLN A  88      33.549  26.080  76.398  1.00  0.00           N  
ATOM   1330  CA  GLN A  88      34.235  27.168  77.073  1.00  0.00           C  
ATOM   1331  C   GLN A  88      33.899  28.503  76.406  1.00  0.00           C  
ATOM   1332  O   GLN A  88      33.895  29.545  77.059  1.00  0.00           O  
ATOM   1333  CB  GLN A  88      35.747  26.933  77.100  1.00  0.00           C  
ATOM   1334  CG  GLN A  88      36.104  25.768  78.025  1.00  0.00           C  
ATOM   1335  CD  GLN A  88      35.791  26.111  79.483  1.00  0.00           C  
ATOM   1336  OE1 GLN A  88      35.870  27.250  79.911  1.00  0.00           O  
ATOM   1337  NE2 GLN A  88      35.432  25.063  80.219  1.00  0.00           N  
ATOM   1338  H   GLN A  88      34.131  25.308  76.144  1.00  0.00           H  
ATOM   1339  HA  GLN A  88      33.854  27.160  78.095  1.00  0.00           H  
ATOM   1340  HB2 GLN A  88      36.102  26.723  76.091  1.00  0.00           H  
ATOM   1341  HB3 GLN A  88      36.253  27.837  77.435  1.00  0.00           H  
ATOM   1342  HG2 GLN A  88      35.547  24.879  77.729  1.00  0.00           H  
ATOM   1343  HG3 GLN A  88      37.163  25.529  77.923  1.00  0.00           H  
ATOM   1344 HE21 GLN A  88      35.387  24.153  79.807  1.00  0.00           H  
ATOM   1345 HE22 GLN A  88      35.207  25.185  81.186  1.00  0.00           H  
ATOM   1346  N   GLN A  89      33.627  28.429  75.111  1.00  0.00           N  
ATOM   1347  CA  GLN A  89      33.291  29.619  74.347  1.00  0.00           C  
ATOM   1348  C   GLN A  89      31.896  30.119  74.730  1.00  0.00           C  
ATOM   1349  O   GLN A  89      31.755  31.202  75.294  1.00  0.00           O  
ATOM   1350  CB  GLN A  89      33.384  29.350  72.845  1.00  0.00           C  
ATOM   1351  CG  GLN A  89      34.742  29.787  72.292  1.00  0.00           C  
ATOM   1352  CD  GLN A  89      34.771  29.687  70.765  1.00  0.00           C  
ATOM   1353  OE1 GLN A  89      33.749  29.652  70.100  1.00  0.00           O  
ATOM   1354  NE2 GLN A  89      35.997  29.642  70.250  1.00  0.00           N  
ATOM   1355  H   GLN A  89      33.632  27.578  74.586  1.00  0.00           H  
ATOM   1356  HA  GLN A  89      34.039  30.361  74.624  1.00  0.00           H  
ATOM   1357  HB2 GLN A  89      33.234  28.287  72.651  1.00  0.00           H  
ATOM   1358  HB3 GLN A  89      32.588  29.883  72.326  1.00  0.00           H  
ATOM   1359  HG2 GLN A  89      34.949  30.813  72.597  1.00  0.00           H  
ATOM   1360  HG3 GLN A  89      35.529  29.163  72.716  1.00  0.00           H  
ATOM   1361 HE21 GLN A  89      36.794  29.675  70.852  1.00  0.00           H  
ATOM   1362 HE22 GLN A  89      36.120  29.577  69.259  1.00  0.00           H  
ATOM   1363  N   ARG A  90      30.901  29.305  74.407  1.00  0.00           N  
ATOM   1364  CA  ARG A  90      29.523  29.651  74.709  1.00  0.00           C  
ATOM   1365  C   ARG A  90      29.356  29.899  76.210  1.00  0.00           C  
ATOM   1366  O   ARG A  90      28.637  30.811  76.615  1.00  0.00           O  
ATOM   1367  CB  ARG A  90      28.567  28.539  74.273  1.00  0.00           C  
ATOM   1368  CG  ARG A  90      28.938  27.208  74.930  1.00  0.00           C  
ATOM   1369  CD  ARG A  90      28.084  26.066  74.376  1.00  0.00           C  
ATOM   1370  NE  ARG A  90      28.411  25.835  72.952  1.00  0.00           N  
ATOM   1371  CZ  ARG A  90      27.696  25.050  72.135  1.00  0.00           C  
ATOM   1372  NH1 ARG A  90      26.609  24.416  72.596  1.00  0.00           N  
ATOM   1373  NH2 ARG A  90      28.067  24.899  70.856  1.00  0.00           N  
ATOM   1374  H   ARG A  90      31.026  28.425  73.948  1.00  0.00           H  
ATOM   1375  HA  ARG A  90      29.332  30.559  74.138  1.00  0.00           H  
ATOM   1376  HB2 ARG A  90      27.545  28.808  74.539  1.00  0.00           H  
ATOM   1377  HB3 ARG A  90      28.597  28.433  73.189  1.00  0.00           H  
ATOM   1378  HG2 ARG A  90      29.993  26.995  74.759  1.00  0.00           H  
ATOM   1379  HG3 ARG A  90      28.800  27.281  76.009  1.00  0.00           H  
ATOM   1380  HD2 ARG A  90      28.261  25.157  74.950  1.00  0.00           H  
ATOM   1381  HD3 ARG A  90      27.026  26.307  74.481  1.00  0.00           H  
ATOM   1382  HE  ARG A  90      29.216  26.294  72.575  1.00  0.00           H  
ATOM   1383 HH11 ARG A  90      26.332  24.528  73.550  1.00  0.00           H  
ATOM   1384 HH12 ARG A  90      26.076  23.830  71.986  1.00  0.00           H  
ATOM   1385 HH21 ARG A  90      28.878  25.372  70.511  1.00  0.00           H  
ATOM   1386 HH22 ARG A  90      27.533  24.313  70.246  1.00  0.00           H  
ATOM   1387  N   LEU A  91      30.030  29.071  76.993  1.00  0.00           N  
ATOM   1388  CA  LEU A  91      29.964  29.189  78.440  1.00  0.00           C  
ATOM   1389  C   LEU A  91      30.333  30.616  78.848  1.00  0.00           C  
ATOM   1390  O   LEU A  91      29.639  31.234  79.655  1.00  0.00           O  
ATOM   1391  CB  LEU A  91      30.830  28.115  79.104  1.00  0.00           C  
ATOM   1392  CG  LEU A  91      30.270  26.692  79.078  1.00  0.00           C  
ATOM   1393  CD1 LEU A  91      31.244  25.709  79.730  1.00  0.00           C  
ATOM   1394  CD2 LEU A  91      28.883  26.635  79.720  1.00  0.00           C  
ATOM   1395  H   LEU A  91      30.612  28.331  76.655  1.00  0.00           H  
ATOM   1396  HA  LEU A  91      28.932  29.000  78.736  1.00  0.00           H  
ATOM   1397  HB2 LEU A  91      31.805  28.111  78.618  1.00  0.00           H  
ATOM   1398  HB3 LEU A  91      30.993  28.402  80.144  1.00  0.00           H  
ATOM   1399  HG  LEU A  91      30.156  26.389  78.037  1.00  0.00           H  
ATOM   1400 HD11 LEU A  91      31.703  25.087  78.961  1.00  0.00           H  
ATOM   1401 HD12 LEU A  91      32.020  26.262  80.260  1.00  0.00           H  
ATOM   1402 HD13 LEU A  91      30.704  25.075  80.434  1.00  0.00           H  
ATOM   1403 HD21 LEU A  91      28.122  26.789  78.955  1.00  0.00           H  
ATOM   1404 HD22 LEU A  91      28.737  25.661  80.187  1.00  0.00           H  
ATOM   1405 HD23 LEU A  91      28.801  27.415  80.477  1.00  0.00           H  
ATOM   1406  N   GLN A  92      31.425  31.098  78.273  1.00  0.00           N  
ATOM   1407  CA  GLN A  92      31.894  32.443  78.566  1.00  0.00           C  
ATOM   1408  C   GLN A  92      30.837  33.473  78.165  1.00  0.00           C  
ATOM   1409  O   GLN A  92      30.461  34.325  78.968  1.00  0.00           O  
ATOM   1410  CB  GLN A  92      33.226  32.722  77.869  1.00  0.00           C  
ATOM   1411  CG  GLN A  92      34.377  32.003  78.575  1.00  0.00           C  
ATOM   1412  CD  GLN A  92      34.879  32.814  79.771  1.00  0.00           C  
ATOM   1413  OE1 GLN A  92      34.551  32.548  80.916  1.00  0.00           O  
ATOM   1414  NE2 GLN A  92      35.691  33.815  79.444  1.00  0.00           N  
ATOM   1415  H   GLN A  92      31.983  30.590  77.618  1.00  0.00           H  
ATOM   1416  HA  GLN A  92      32.044  32.467  79.646  1.00  0.00           H  
ATOM   1417  HB2 GLN A  92      33.172  32.398  76.830  1.00  0.00           H  
ATOM   1418  HB3 GLN A  92      33.416  33.796  77.858  1.00  0.00           H  
ATOM   1419  HG2 GLN A  92      34.045  31.020  78.910  1.00  0.00           H  
ATOM   1420  HG3 GLN A  92      35.195  31.840  77.872  1.00  0.00           H  
ATOM   1421 HE21 GLN A  92      35.920  33.979  78.484  1.00  0.00           H  
ATOM   1422 HE22 GLN A  92      36.072  34.403  80.157  1.00  0.00           H  
ATOM   1423  N   LYS A  93      30.389  33.361  76.924  1.00  0.00           N  
ATOM   1424  CA  LYS A  93      29.383  34.273  76.406  1.00  0.00           C  
ATOM   1425  C   LYS A  93      28.151  34.235  77.313  1.00  0.00           C  
ATOM   1426  O   LYS A  93      27.607  35.279  77.669  1.00  0.00           O  
ATOM   1427  CB  LYS A  93      29.077  33.958  74.940  1.00  0.00           C  
ATOM   1428  CG  LYS A  93      28.796  35.238  74.151  1.00  0.00           C  
ATOM   1429  CD  LYS A  93      27.848  34.964  72.982  1.00  0.00           C  
ATOM   1430  CE  LYS A  93      26.460  35.547  73.253  1.00  0.00           C  
ATOM   1431  NZ  LYS A  93      25.492  34.466  73.548  1.00  0.00           N  
ATOM   1432  H   LYS A  93      30.701  32.665  76.277  1.00  0.00           H  
ATOM   1433  HA  LYS A  93      29.805  35.278  76.438  1.00  0.00           H  
ATOM   1434  HB2 LYS A  93      29.919  33.429  74.494  1.00  0.00           H  
ATOM   1435  HB3 LYS A  93      28.216  33.293  74.880  1.00  0.00           H  
ATOM   1436  HG2 LYS A  93      28.358  35.988  74.811  1.00  0.00           H  
ATOM   1437  HG3 LYS A  93      29.732  35.651  73.776  1.00  0.00           H  
ATOM   1438  HD2 LYS A  93      28.257  35.399  72.068  1.00  0.00           H  
ATOM   1439  HD3 LYS A  93      27.770  33.890  72.816  1.00  0.00           H  
ATOM   1440  HE2 LYS A  93      26.507  36.240  74.093  1.00  0.00           H  
ATOM   1441  HE3 LYS A  93      26.123  36.118  72.387  1.00  0.00           H  
ATOM   1442  HZ1 LYS A  93      24.575  34.854  73.636  1.00  0.00           H  
ATOM   1443  HZ2 LYS A  93      25.501  33.798  72.802  1.00  0.00           H  
ATOM   1444  HZ3 LYS A  93      25.748  34.015  74.403  1.00  0.00           H  
ATOM   1445  N   GLU A  94      27.749  33.022  77.660  1.00  0.00           N  
ATOM   1446  CA  GLU A  94      26.592  32.835  78.519  1.00  0.00           C  
ATOM   1447  C   GLU A  94      26.665  33.777  79.723  1.00  0.00           C  
ATOM   1448  O   GLU A  94      25.709  34.490  80.017  1.00  0.00           O  
ATOM   1449  CB  GLU A  94      26.473  31.378  78.970  1.00  0.00           C  
ATOM   1450  CG  GLU A  94      25.996  30.485  77.822  1.00  0.00           C  
ATOM   1451  CD  GLU A  94      24.468  30.470  77.738  1.00  0.00           C  
ATOM   1452  OE1 GLU A  94      23.841  30.419  78.818  1.00  0.00           O  
ATOM   1453  OE2 GLU A  94      23.963  30.510  76.595  1.00  0.00           O  
ATOM   1454  H   GLU A  94      28.198  32.178  77.366  1.00  0.00           H  
ATOM   1455  HA  GLU A  94      25.730  33.090  77.903  1.00  0.00           H  
ATOM   1456  HB2 GLU A  94      27.439  31.026  79.331  1.00  0.00           H  
ATOM   1457  HB3 GLU A  94      25.776  31.307  79.805  1.00  0.00           H  
ATOM   1458  HG2 GLU A  94      26.412  30.845  76.880  1.00  0.00           H  
ATOM   1459  HG3 GLU A  94      26.366  29.471  77.967  1.00  0.00           H  
ATOM   1460  N   ARG A  95      27.813  33.748  80.387  1.00  0.00           N  
ATOM   1461  CA  ARG A  95      28.024  34.590  81.551  1.00  0.00           C  
ATOM   1462  C   ARG A  95      27.987  36.067  81.152  1.00  0.00           C  
ATOM   1463  O   ARG A  95      27.317  36.871  81.799  1.00  0.00           O  
ATOM   1464  CB  ARG A  95      29.367  34.282  82.217  1.00  0.00           C  
ATOM   1465  CG  ARG A  95      29.271  33.033  83.094  1.00  0.00           C  
ATOM   1466  CD  ARG A  95      29.403  33.391  84.576  1.00  0.00           C  
ATOM   1467  NE  ARG A  95      30.499  32.609  85.189  1.00  0.00           N  
ATOM   1468  CZ  ARG A  95      31.795  32.936  85.102  1.00  0.00           C  
ATOM   1469  NH1 ARG A  95      32.166  34.031  84.425  1.00  0.00           N  
ATOM   1470  NH2 ARG A  95      32.722  32.167  85.691  1.00  0.00           N  
ATOM   1471  H   ARG A  95      28.587  33.165  80.140  1.00  0.00           H  
ATOM   1472  HA  ARG A  95      27.204  34.345  82.225  1.00  0.00           H  
ATOM   1473  HB2 ARG A  95      30.130  34.137  81.453  1.00  0.00           H  
ATOM   1474  HB3 ARG A  95      29.680  35.133  82.822  1.00  0.00           H  
ATOM   1475  HG2 ARG A  95      28.316  32.535  82.920  1.00  0.00           H  
ATOM   1476  HG3 ARG A  95      30.054  32.327  82.815  1.00  0.00           H  
ATOM   1477  HD2 ARG A  95      29.601  34.457  84.684  1.00  0.00           H  
ATOM   1478  HD3 ARG A  95      28.465  33.186  85.092  1.00  0.00           H  
ATOM   1479  HE  ARG A  95      30.257  31.785  85.702  1.00  0.00           H  
ATOM   1480 HH11 ARG A  95      31.474  34.605  83.985  1.00  0.00           H  
ATOM   1481 HH12 ARG A  95      33.133  34.275  84.359  1.00  0.00           H  
ATOM   1482 HH21 ARG A  95      32.445  31.349  86.196  1.00  0.00           H  
ATOM   1483 HH22 ARG A  95      33.689  32.411  85.625  1.00  0.00           H  
ATOM   1484  N   LEU A  96      28.715  36.378  80.090  1.00  0.00           N  
ATOM   1485  CA  LEU A  96      28.775  37.744  79.598  1.00  0.00           C  
ATOM   1486  C   LEU A  96      27.355  38.305  79.491  1.00  0.00           C  
ATOM   1487  O   LEU A  96      27.049  39.347  80.069  1.00  0.00           O  
ATOM   1488  CB  LEU A  96      29.560  37.807  78.287  1.00  0.00           C  
ATOM   1489  CG  LEU A  96      31.080  37.679  78.409  1.00  0.00           C  
ATOM   1490  CD1 LEU A  96      31.701  37.236  77.083  1.00  0.00           C  
ATOM   1491  CD2 LEU A  96      31.701  38.977  78.928  1.00  0.00           C  
ATOM   1492  H   LEU A  96      29.257  35.718  79.570  1.00  0.00           H  
ATOM   1493  HA  LEU A  96      29.324  38.333  80.332  1.00  0.00           H  
ATOM   1494  HB2 LEU A  96      29.199  37.015  77.631  1.00  0.00           H  
ATOM   1495  HB3 LEU A  96      29.334  38.754  77.796  1.00  0.00           H  
ATOM   1496  HG  LEU A  96      31.298  36.902  79.142  1.00  0.00           H  
ATOM   1497 HD11 LEU A  96      30.995  37.419  76.272  1.00  0.00           H  
ATOM   1498 HD12 LEU A  96      32.615  37.802  76.903  1.00  0.00           H  
ATOM   1499 HD13 LEU A  96      31.935  36.173  77.128  1.00  0.00           H  
ATOM   1500 HD21 LEU A  96      31.112  39.826  78.580  1.00  0.00           H  
ATOM   1501 HD22 LEU A  96      31.712  38.965  80.017  1.00  0.00           H  
ATOM   1502 HD23 LEU A  96      32.721  39.067  78.555  1.00  0.00           H  
ATOM   1503  N   MET A  97      26.524  37.589  78.749  1.00  0.00           N  
ATOM   1504  CA  MET A  97      25.143  38.001  78.558  1.00  0.00           C  
ATOM   1505  C   MET A  97      24.477  38.318  79.898  1.00  0.00           C  
ATOM   1506  O   MET A  97      23.853  39.367  80.053  1.00  0.00           O  
ATOM   1507  CB  MET A  97      24.369  36.886  77.854  1.00  0.00           C  
ATOM   1508  CG  MET A  97      24.870  36.690  76.422  1.00  0.00           C  
ATOM   1509  SD  MET A  97      24.672  38.202  75.494  1.00  0.00           S  
ATOM   1510  CE  MET A  97      23.198  37.807  74.569  1.00  0.00           C  
ATOM   1511  H   MET A  97      26.779  36.742  78.281  1.00  0.00           H  
ATOM   1512  HA  MET A  97      25.189  38.901  77.945  1.00  0.00           H  
ATOM   1513  HB2 MET A  97      24.477  35.955  78.411  1.00  0.00           H  
ATOM   1514  HB3 MET A  97      23.306  37.128  77.842  1.00  0.00           H  
ATOM   1515  HG2 MET A  97      25.919  36.395  76.432  1.00  0.00           H  
ATOM   1516  HG3 MET A  97      24.317  35.883  75.941  1.00  0.00           H  
ATOM   1517  HE1 MET A  97      22.662  38.726  74.330  1.00  0.00           H  
ATOM   1518  HE2 MET A  97      23.474  37.297  73.646  1.00  0.00           H  
ATOM   1519  HE3 MET A  97      22.558  37.157  75.165  1.00  0.00           H  
ATOM   1520  N   ASN A  98      24.632  37.393  80.834  1.00  0.00           N  
ATOM   1521  CA  ASN A  98      24.053  37.561  82.157  1.00  0.00           C  
ATOM   1522  C   ASN A  98      24.674  38.788  82.829  1.00  0.00           C  
ATOM   1523  O   ASN A  98      23.970  39.741  83.161  1.00  0.00           O  
ATOM   1524  CB  ASN A  98      24.336  36.345  83.040  1.00  0.00           C  
ATOM   1525  CG  ASN A  98      23.042  35.607  83.388  1.00  0.00           C  
ATOM   1526  OD1 ASN A  98      22.630  35.530  84.534  1.00  0.00           O  
ATOM   1527  ND2 ASN A  98      22.426  35.071  82.339  1.00  0.00           N  
ATOM   1528  H   ASN A  98      25.142  36.543  80.701  1.00  0.00           H  
ATOM   1529  HA  ASN A  98      22.982  37.675  81.987  1.00  0.00           H  
ATOM   1530  HB2 ASN A  98      25.018  35.667  82.526  1.00  0.00           H  
ATOM   1531  HB3 ASN A  98      24.835  36.664  83.955  1.00  0.00           H  
ATOM   1532 HD21 ASN A  98      22.817  35.171  81.425  1.00  0.00           H  
ATOM   1533 HD22 ASN A  98      21.571  34.567  82.465  1.00  0.00           H  
ATOM   1534  N   ASP A  99      25.986  38.725  83.007  1.00  0.00           N  
ATOM   1535  CA  ASP A  99      26.707  39.819  83.634  1.00  0.00           C  
ATOM   1536  C   ASP A  99      26.197  41.149  83.074  1.00  0.00           C  
ATOM   1537  O   ASP A  99      25.741  42.009  83.826  1.00  0.00           O  
ATOM   1538  CB  ASP A  99      28.207  39.728  83.341  1.00  0.00           C  
ATOM   1539  CG  ASP A  99      29.039  39.053  84.433  1.00  0.00           C  
ATOM   1540  OD1 ASP A  99      28.692  39.256  85.617  1.00  0.00           O  
ATOM   1541  OD2 ASP A  99      30.003  38.350  84.059  1.00  0.00           O  
ATOM   1542  H   ASP A  99      26.550  37.947  82.734  1.00  0.00           H  
ATOM   1543  HA  ASP A  99      26.516  39.715  84.701  1.00  0.00           H  
ATOM   1544  HB2 ASP A  99      28.347  39.181  82.408  1.00  0.00           H  
ATOM   1545  HB3 ASP A  99      28.592  40.734  83.180  1.00  0.00           H  
ATOM   1546  N   PHE A 100      26.290  41.275  81.759  1.00  0.00           N  
ATOM   1547  CA  PHE A 100      25.843  42.485  81.089  1.00  0.00           C  
ATOM   1548  C   PHE A 100      24.444  42.886  81.560  1.00  0.00           C  
ATOM   1549  O   PHE A 100      24.187  44.059  81.826  1.00  0.00           O  
ATOM   1550  CB  PHE A 100      25.796  42.177  79.592  1.00  0.00           C  
ATOM   1551  CG  PHE A 100      25.015  43.203  78.769  1.00  0.00           C  
ATOM   1552  CD1 PHE A 100      25.477  44.477  78.656  1.00  0.00           C  
ATOM   1553  CD2 PHE A 100      23.859  42.842  78.152  1.00  0.00           C  
ATOM   1554  CE1 PHE A 100      24.752  45.430  77.892  1.00  0.00           C  
ATOM   1555  CE2 PHE A 100      23.133  43.795  77.389  1.00  0.00           C  
ATOM   1556  CZ  PHE A 100      23.595  45.069  77.275  1.00  0.00           C  
ATOM   1557  H   PHE A 100      26.663  40.571  81.154  1.00  0.00           H  
ATOM   1558  HA  PHE A 100      26.550  43.275  81.344  1.00  0.00           H  
ATOM   1559  HB2 PHE A 100      26.816  42.122  79.210  1.00  0.00           H  
ATOM   1560  HB3 PHE A 100      25.349  41.194  79.447  1.00  0.00           H  
ATOM   1561  HD1 PHE A 100      26.405  44.767  79.149  1.00  0.00           H  
ATOM   1562  HD2 PHE A 100      23.489  41.821  78.243  1.00  0.00           H  
ATOM   1563  HE1 PHE A 100      25.122  46.452  77.800  1.00  0.00           H  
ATOM   1564  HE2 PHE A 100      22.207  43.505  76.894  1.00  0.00           H  
ATOM   1565  HZ  PHE A 100      23.039  45.800  76.689  1.00  0.00           H  
ATOM   1566  N   SER A 101      23.575  41.889  81.647  1.00  0.00           N  
ATOM   1567  CA  SER A 101      22.208  42.123  82.081  1.00  0.00           C  
ATOM   1568  C   SER A 101      22.202  42.744  83.479  1.00  0.00           C  
ATOM   1569  O   SER A 101      21.684  43.843  83.670  1.00  0.00           O  
ATOM   1570  CB  SER A 101      21.398  40.825  82.072  1.00  0.00           C  
ATOM   1571  OG  SER A 101      20.628  40.670  83.261  1.00  0.00           O  
ATOM   1572  H   SER A 101      23.792  40.938  81.429  1.00  0.00           H  
ATOM   1573  HA  SER A 101      21.790  42.817  81.351  1.00  0.00           H  
ATOM   1574  HB2 SER A 101      20.736  40.816  81.207  1.00  0.00           H  
ATOM   1575  HB3 SER A 101      22.073  39.977  81.965  1.00  0.00           H  
ATOM   1576  HG  SER A 101      19.761  41.162  83.174  1.00  0.00           H  
ATOM   1577  N   ALA A 102      22.783  42.014  84.419  1.00  0.00           N  
ATOM   1578  CA  ALA A 102      22.851  42.480  85.793  1.00  0.00           C  
ATOM   1579  C   ALA A 102      23.233  43.962  85.808  1.00  0.00           C  
ATOM   1580  O   ALA A 102      22.740  44.725  86.636  1.00  0.00           O  
ATOM   1581  CB  ALA A 102      23.840  41.615  86.577  1.00  0.00           C  
ATOM   1582  H   ALA A 102      23.202  41.122  84.255  1.00  0.00           H  
ATOM   1583  HA  ALA A 102      21.859  42.365  86.232  1.00  0.00           H  
ATOM   1584  HB1 ALA A 102      23.992  40.672  86.054  1.00  0.00           H  
ATOM   1585  HB2 ALA A 102      24.791  42.141  86.665  1.00  0.00           H  
ATOM   1586  HB3 ALA A 102      23.440  41.418  87.573  1.00  0.00           H  
ATOM   1587  N   ALA A 103      24.106  44.323  84.880  1.00  0.00           N  
ATOM   1588  CA  ALA A 103      24.560  45.700  84.775  1.00  0.00           C  
ATOM   1589  C   ALA A 103      23.466  46.544  84.119  1.00  0.00           C  
ATOM   1590  O   ALA A 103      23.194  47.661  84.556  1.00  0.00           O  
ATOM   1591  CB  ALA A 103      25.877  45.745  83.997  1.00  0.00           C  
ATOM   1592  H   ALA A 103      24.502  43.696  84.209  1.00  0.00           H  
ATOM   1593  HA  ALA A 103      24.736  46.068  85.785  1.00  0.00           H  
ATOM   1594  HB1 ALA A 103      26.712  45.657  84.691  1.00  0.00           H  
ATOM   1595  HB2 ALA A 103      25.908  44.920  83.285  1.00  0.00           H  
ATOM   1596  HB3 ALA A 103      25.948  46.691  83.459  1.00  0.00           H  
ATOM   1597  N   LEU A 104      22.868  45.978  83.082  1.00  0.00           N  
ATOM   1598  CA  LEU A 104      21.809  46.665  82.361  1.00  0.00           C  
ATOM   1599  C   LEU A 104      20.699  47.050  83.341  1.00  0.00           C  
ATOM   1600  O   LEU A 104      20.390  48.230  83.502  1.00  0.00           O  
ATOM   1601  CB  LEU A 104      21.323  45.816  81.184  1.00  0.00           C  
ATOM   1602  CG  LEU A 104      19.947  46.175  80.622  1.00  0.00           C  
ATOM   1603  CD1 LEU A 104      20.014  47.450  79.779  1.00  0.00           C  
ATOM   1604  CD2 LEU A 104      19.351  45.003  79.840  1.00  0.00           C  
ATOM   1605  H   LEU A 104      23.095  45.069  82.733  1.00  0.00           H  
ATOM   1606  HA  LEU A 104      22.236  47.578  81.946  1.00  0.00           H  
ATOM   1607  HB2 LEU A 104      22.055  45.895  80.380  1.00  0.00           H  
ATOM   1608  HB3 LEU A 104      21.304  44.773  81.498  1.00  0.00           H  
ATOM   1609  HG  LEU A 104      19.278  46.378  81.459  1.00  0.00           H  
ATOM   1610 HD11 LEU A 104      20.507  48.237  80.350  1.00  0.00           H  
ATOM   1611 HD12 LEU A 104      20.580  47.254  78.868  1.00  0.00           H  
ATOM   1612 HD13 LEU A 104      19.005  47.768  79.518  1.00  0.00           H  
ATOM   1613 HD21 LEU A 104      19.613  45.097  78.786  1.00  0.00           H  
ATOM   1614 HD22 LEU A 104      19.750  44.066  80.230  1.00  0.00           H  
ATOM   1615 HD23 LEU A 104      18.266  45.008  79.947  1.00  0.00           H  
ATOM   1616  N   ASN A 105      20.129  46.033  83.969  1.00  0.00           N  
ATOM   1617  CA  ASN A 105      19.060  46.250  84.929  1.00  0.00           C  
ATOM   1618  C   ASN A 105      19.414  47.441  85.821  1.00  0.00           C  
ATOM   1619  O   ASN A 105      18.593  48.334  86.028  1.00  0.00           O  
ATOM   1620  CB  ASN A 105      18.869  45.028  85.828  1.00  0.00           C  
ATOM   1621  CG  ASN A 105      17.584  45.145  86.650  1.00  0.00           C  
ATOM   1622  OD1 ASN A 105      17.325  46.141  87.306  1.00  0.00           O  
ATOM   1623  ND2 ASN A 105      16.795  44.076  86.578  1.00  0.00           N  
ATOM   1624  H   ASN A 105      20.386  45.076  83.834  1.00  0.00           H  
ATOM   1625  HA  ASN A 105      18.167  46.430  84.329  1.00  0.00           H  
ATOM   1626  HB2 ASN A 105      18.834  44.125  85.218  1.00  0.00           H  
ATOM   1627  HB3 ASN A 105      19.724  44.926  86.497  1.00  0.00           H  
ATOM   1628 HD21 ASN A 105      17.067  43.291  86.021  1.00  0.00           H  
ATOM   1629 HD22 ASN A 105      15.931  44.058  87.081  1.00  0.00           H  
ATOM   1630  N   ASN A 106      20.639  47.418  86.324  1.00  0.00           N  
ATOM   1631  CA  ASN A 106      21.114  48.487  87.189  1.00  0.00           C  
ATOM   1632  C   ASN A 106      20.766  49.838  86.561  1.00  0.00           C  
ATOM   1633  O   ASN A 106      20.066  50.646  87.168  1.00  0.00           O  
ATOM   1634  CB  ASN A 106      22.633  48.422  87.362  1.00  0.00           C  
ATOM   1635  CG  ASN A 106      23.016  48.402  88.843  1.00  0.00           C  
ATOM   1636  OD1 ASN A 106      22.451  49.103  89.667  1.00  0.00           O  
ATOM   1637  ND2 ASN A 106      24.005  47.561  89.134  1.00  0.00           N  
ATOM   1638  H   ASN A 106      21.302  46.690  86.151  1.00  0.00           H  
ATOM   1639  HA  ASN A 106      20.611  48.327  88.142  1.00  0.00           H  
ATOM   1640  HB2 ASN A 106      23.021  47.530  86.870  1.00  0.00           H  
ATOM   1641  HB3 ASN A 106      23.094  49.281  86.874  1.00  0.00           H  
ATOM   1642 HD21 ASN A 106      24.426  47.014  88.411  1.00  0.00           H  
ATOM   1643 HD22 ASN A 106      24.327  47.476  90.077  1.00  0.00           H  
ATOM   1644  N   PHE A 107      21.272  50.040  85.353  1.00  0.00           N  
ATOM   1645  CA  PHE A 107      21.024  51.280  84.637  1.00  0.00           C  
ATOM   1646  C   PHE A 107      19.527  51.594  84.587  1.00  0.00           C  
ATOM   1647  O   PHE A 107      19.122  52.736  84.795  1.00  0.00           O  
ATOM   1648  CB  PHE A 107      21.541  51.083  83.210  1.00  0.00           C  
ATOM   1649  CG  PHE A 107      21.657  52.379  82.406  1.00  0.00           C  
ATOM   1650  CD1 PHE A 107      22.109  53.514  83.006  1.00  0.00           C  
ATOM   1651  CD2 PHE A 107      21.310  52.397  81.091  1.00  0.00           C  
ATOM   1652  CE1 PHE A 107      22.218  54.716  82.260  1.00  0.00           C  
ATOM   1653  CE2 PHE A 107      21.420  53.601  80.345  1.00  0.00           C  
ATOM   1654  CZ  PHE A 107      21.870  54.735  80.945  1.00  0.00           C  
ATOM   1655  H   PHE A 107      21.842  49.378  84.867  1.00  0.00           H  
ATOM   1656  HA  PHE A 107      21.541  52.074  85.175  1.00  0.00           H  
ATOM   1657  HB2 PHE A 107      22.519  50.604  83.252  1.00  0.00           H  
ATOM   1658  HB3 PHE A 107      20.873  50.400  82.684  1.00  0.00           H  
ATOM   1659  HD1 PHE A 107      22.387  53.499  84.060  1.00  0.00           H  
ATOM   1660  HD2 PHE A 107      20.949  51.489  80.610  1.00  0.00           H  
ATOM   1661  HE1 PHE A 107      22.579  55.625  82.741  1.00  0.00           H  
ATOM   1662  HE2 PHE A 107      21.141  53.616  79.291  1.00  0.00           H  
ATOM   1663  HZ  PHE A 107      21.953  55.659  80.372  1.00  0.00           H  
ATOM   1664  N   GLN A 108      18.748  50.559  84.308  1.00  0.00           N  
ATOM   1665  CA  GLN A 108      17.305  50.710  84.227  1.00  0.00           C  
ATOM   1666  C   GLN A 108      16.753  51.260  85.544  1.00  0.00           C  
ATOM   1667  O   GLN A 108      16.239  52.376  85.587  1.00  0.00           O  
ATOM   1668  CB  GLN A 108      16.634  49.383  83.864  1.00  0.00           C  
ATOM   1669  CG  GLN A 108      16.652  49.156  82.351  1.00  0.00           C  
ATOM   1670  CD  GLN A 108      15.480  48.273  81.916  1.00  0.00           C  
ATOM   1671  OE1 GLN A 108      14.401  48.305  82.484  1.00  0.00           O  
ATOM   1672  NE2 GLN A 108      15.751  47.486  80.878  1.00  0.00           N  
ATOM   1673  H   GLN A 108      19.086  49.633  84.139  1.00  0.00           H  
ATOM   1674  HA  GLN A 108      17.132  51.428  83.425  1.00  0.00           H  
ATOM   1675  HB2 GLN A 108      17.148  48.563  84.365  1.00  0.00           H  
ATOM   1676  HB3 GLN A 108      15.606  49.381  84.223  1.00  0.00           H  
ATOM   1677  HG2 GLN A 108      16.601  50.115  81.835  1.00  0.00           H  
ATOM   1678  HG3 GLN A 108      17.592  48.688  82.061  1.00  0.00           H  
ATOM   1679 HE21 GLN A 108      16.658  47.509  80.457  1.00  0.00           H  
ATOM   1680 HE22 GLN A 108      15.049  46.873  80.519  1.00  0.00           H  
ATOM   1681  N   ALA A 109      16.882  50.452  86.586  1.00  0.00           N  
ATOM   1682  CA  ALA A 109      16.403  50.844  87.900  1.00  0.00           C  
ATOM   1683  C   ALA A 109      16.869  52.269  88.204  1.00  0.00           C  
ATOM   1684  O   ALA A 109      16.245  52.976  88.993  1.00  0.00           O  
ATOM   1685  CB  ALA A 109      16.890  49.836  88.943  1.00  0.00           C  
ATOM   1686  H   ALA A 109      17.302  49.546  86.542  1.00  0.00           H  
ATOM   1687  HA  ALA A 109      15.313  50.825  87.876  1.00  0.00           H  
ATOM   1688  HB1 ALA A 109      16.976  50.328  89.911  1.00  0.00           H  
ATOM   1689  HB2 ALA A 109      16.178  49.014  89.015  1.00  0.00           H  
ATOM   1690  HB3 ALA A 109      17.864  49.448  88.646  1.00  0.00           H  
ATOM   1691  N   VAL A 110      17.965  52.648  87.562  1.00  0.00           N  
ATOM   1692  CA  VAL A 110      18.523  53.976  87.754  1.00  0.00           C  
ATOM   1693  C   VAL A 110      17.789  54.969  86.849  1.00  0.00           C  
ATOM   1694  O   VAL A 110      17.474  56.081  87.270  1.00  0.00           O  
ATOM   1695  CB  VAL A 110      20.032  53.950  87.509  1.00  0.00           C  
ATOM   1696  CG1 VAL A 110      20.584  55.365  87.327  1.00  0.00           C  
ATOM   1697  CG2 VAL A 110      20.759  53.220  88.641  1.00  0.00           C  
ATOM   1698  H   VAL A 110      18.467  52.067  86.922  1.00  0.00           H  
ATOM   1699  HA  VAL A 110      18.354  54.257  88.793  1.00  0.00           H  
ATOM   1700  HB  VAL A 110      20.213  53.399  86.586  1.00  0.00           H  
ATOM   1701 HG11 VAL A 110      20.025  55.874  86.544  1.00  0.00           H  
ATOM   1702 HG12 VAL A 110      20.483  55.917  88.262  1.00  0.00           H  
ATOM   1703 HG13 VAL A 110      21.637  55.312  87.048  1.00  0.00           H  
ATOM   1704 HG21 VAL A 110      21.463  52.503  88.219  1.00  0.00           H  
ATOM   1705 HG22 VAL A 110      21.299  53.943  89.253  1.00  0.00           H  
ATOM   1706 HG23 VAL A 110      20.031  52.692  89.258  1.00  0.00           H  
ATOM   1707  N   GLN A 111      17.536  54.530  85.625  1.00  0.00           N  
ATOM   1708  CA  GLN A 111      16.845  55.366  84.658  1.00  0.00           C  
ATOM   1709  C   GLN A 111      15.501  55.831  85.223  1.00  0.00           C  
ATOM   1710  O   GLN A 111      15.095  56.972  85.011  1.00  0.00           O  
ATOM   1711  CB  GLN A 111      16.657  54.629  83.332  1.00  0.00           C  
ATOM   1712  CG  GLN A 111      15.246  54.045  83.224  1.00  0.00           C  
ATOM   1713  CD  GLN A 111      15.098  53.201  81.957  1.00  0.00           C  
ATOM   1714  OE1 GLN A 111      15.314  53.657  80.846  1.00  0.00           O  
ATOM   1715  NE2 GLN A 111      14.719  51.946  82.184  1.00  0.00           N  
ATOM   1716  H   GLN A 111      17.796  53.624  85.291  1.00  0.00           H  
ATOM   1717  HA  GLN A 111      17.497  56.226  84.500  1.00  0.00           H  
ATOM   1718  HB2 GLN A 111      16.835  55.313  82.502  1.00  0.00           H  
ATOM   1719  HB3 GLN A 111      17.392  53.828  83.248  1.00  0.00           H  
ATOM   1720  HG2 GLN A 111      15.034  53.433  84.101  1.00  0.00           H  
ATOM   1721  HG3 GLN A 111      14.515  54.853  83.214  1.00  0.00           H  
ATOM   1722 HE21 GLN A 111      14.558  51.635  83.121  1.00  0.00           H  
ATOM   1723 HE22 GLN A 111      14.594  51.315  81.418  1.00  0.00           H  
ATOM   1724  N   ARG A 112      14.847  54.921  85.932  1.00  0.00           N  
ATOM   1725  CA  ARG A 112      13.558  55.223  86.530  1.00  0.00           C  
ATOM   1726  C   ARG A 112      13.699  56.346  87.559  1.00  0.00           C  
ATOM   1727  O   ARG A 112      13.041  57.379  87.451  1.00  0.00           O  
ATOM   1728  CB  ARG A 112      12.962  53.989  87.209  1.00  0.00           C  
ATOM   1729  CG  ARG A 112      11.601  54.307  87.831  1.00  0.00           C  
ATOM   1730  CD  ARG A 112      11.734  54.579  89.330  1.00  0.00           C  
ATOM   1731  NE  ARG A 112      10.579  55.373  89.805  1.00  0.00           N  
ATOM   1732  CZ  ARG A 112       9.351  54.872  89.999  1.00  0.00           C  
ATOM   1733  NH1 ARG A 112       9.112  53.575  89.761  1.00  0.00           N  
ATOM   1734  NH2 ARG A 112       8.364  55.668  90.431  1.00  0.00           N  
ATOM   1735  H   ARG A 112      15.184  53.995  86.100  1.00  0.00           H  
ATOM   1736  HA  ARG A 112      12.930  55.534  85.694  1.00  0.00           H  
ATOM   1737  HB2 ARG A 112      12.855  53.185  86.481  1.00  0.00           H  
ATOM   1738  HB3 ARG A 112      13.645  53.630  87.980  1.00  0.00           H  
ATOM   1739  HG2 ARG A 112      11.167  55.176  87.338  1.00  0.00           H  
ATOM   1740  HG3 ARG A 112      10.919  53.474  87.668  1.00  0.00           H  
ATOM   1741  HD2 ARG A 112      11.787  53.636  89.876  1.00  0.00           H  
ATOM   1742  HD3 ARG A 112      12.662  55.115  89.531  1.00  0.00           H  
ATOM   1743  HE  ARG A 112      10.723  56.345  89.993  1.00  0.00           H  
ATOM   1744 HH11 ARG A 112       9.849  52.981  89.438  1.00  0.00           H  
ATOM   1745 HH12 ARG A 112       8.196  53.201  89.907  1.00  0.00           H  
ATOM   1746 HH21 ARG A 112       8.543  56.636  90.610  1.00  0.00           H  
ATOM   1747 HH22 ARG A 112       7.448  55.293  90.576  1.00  0.00           H  
ATOM   1748  N   ARG A 113      14.563  56.105  88.534  1.00  0.00           N  
ATOM   1749  CA  ARG A 113      14.799  57.082  89.583  1.00  0.00           C  
ATOM   1750  C   ARG A 113      15.074  58.459  88.973  1.00  0.00           C  
ATOM   1751  O   ARG A 113      14.526  59.463  89.426  1.00  0.00           O  
ATOM   1752  CB  ARG A 113      15.985  56.675  90.460  1.00  0.00           C  
ATOM   1753  CG  ARG A 113      15.507  56.038  91.767  1.00  0.00           C  
ATOM   1754  CD  ARG A 113      15.995  56.836  92.976  1.00  0.00           C  
ATOM   1755  NE  ARG A 113      15.120  56.575  94.141  1.00  0.00           N  
ATOM   1756  CZ  ARG A 113      15.216  57.222  95.311  1.00  0.00           C  
ATOM   1757  NH1 ARG A 113      16.148  58.170  95.480  1.00  0.00           N  
ATOM   1758  NH2 ARG A 113      14.379  56.919  96.314  1.00  0.00           N  
ATOM   1759  H   ARG A 113      15.095  55.262  88.616  1.00  0.00           H  
ATOM   1760  HA  ARG A 113      13.880  57.090  90.169  1.00  0.00           H  
ATOM   1761  HB2 ARG A 113      16.617  55.971  89.917  1.00  0.00           H  
ATOM   1762  HB3 ARG A 113      16.597  57.549  90.680  1.00  0.00           H  
ATOM   1763  HG2 ARG A 113      14.418  55.988  91.774  1.00  0.00           H  
ATOM   1764  HG3 ARG A 113      15.874  55.013  91.830  1.00  0.00           H  
ATOM   1765  HD2 ARG A 113      17.023  56.560  93.214  1.00  0.00           H  
ATOM   1766  HD3 ARG A 113      15.998  57.901  92.743  1.00  0.00           H  
ATOM   1767  HE  ARG A 113      14.414  55.875  94.049  1.00  0.00           H  
ATOM   1768 HH11 ARG A 113      16.772  58.395  94.732  1.00  0.00           H  
ATOM   1769 HH12 ARG A 113      16.219  58.652  96.353  1.00  0.00           H  
ATOM   1770 HH21 ARG A 113      13.683  56.212  96.187  1.00  0.00           H  
ATOM   1771 HH22 ARG A 113      14.450  57.401  97.186  1.00  0.00           H  
ATOM   1772  N   VAL A 114      15.922  58.461  87.956  1.00  0.00           N  
ATOM   1773  CA  VAL A 114      16.276  59.697  87.280  1.00  0.00           C  
ATOM   1774  C   VAL A 114      15.013  60.334  86.696  1.00  0.00           C  
ATOM   1775  O   VAL A 114      14.695  61.482  87.003  1.00  0.00           O  
ATOM   1776  CB  VAL A 114      17.351  59.427  86.224  1.00  0.00           C  
ATOM   1777  CG1 VAL A 114      17.618  60.676  85.382  1.00  0.00           C  
ATOM   1778  CG2 VAL A 114      18.640  58.917  86.873  1.00  0.00           C  
ATOM   1779  H   VAL A 114      16.363  57.639  87.593  1.00  0.00           H  
ATOM   1780  HA  VAL A 114      16.697  60.371  88.025  1.00  0.00           H  
ATOM   1781  HB  VAL A 114      16.980  58.648  85.560  1.00  0.00           H  
ATOM   1782 HG11 VAL A 114      16.966  61.483  85.713  1.00  0.00           H  
ATOM   1783 HG12 VAL A 114      18.660  60.978  85.500  1.00  0.00           H  
ATOM   1784 HG13 VAL A 114      17.421  60.455  84.333  1.00  0.00           H  
ATOM   1785 HG21 VAL A 114      18.640  59.174  87.933  1.00  0.00           H  
ATOM   1786 HG22 VAL A 114      18.699  57.835  86.762  1.00  0.00           H  
ATOM   1787 HG23 VAL A 114      19.500  59.379  86.387  1.00  0.00           H  
ATOM   1788  N   SER A 115      14.329  59.562  85.866  1.00  0.00           N  
ATOM   1789  CA  SER A 115      13.108  60.037  85.237  1.00  0.00           C  
ATOM   1790  C   SER A 115      12.180  60.646  86.290  1.00  0.00           C  
ATOM   1791  O   SER A 115      11.529  61.660  86.037  1.00  0.00           O  
ATOM   1792  CB  SER A 115      12.396  58.905  84.493  1.00  0.00           C  
ATOM   1793  OG  SER A 115      12.665  57.632  85.074  1.00  0.00           O  
ATOM   1794  H   SER A 115      14.595  58.629  85.622  1.00  0.00           H  
ATOM   1795  HA  SER A 115      13.428  60.796  84.523  1.00  0.00           H  
ATOM   1796  HB2 SER A 115      11.320  59.087  84.501  1.00  0.00           H  
ATOM   1797  HB3 SER A 115      12.711  58.901  83.450  1.00  0.00           H  
ATOM   1798  HG  SER A 115      11.818  57.225  85.415  1.00  0.00           H  
ATOM   1799  N   GLU A 116      12.149  60.005  87.448  1.00  0.00           N  
ATOM   1800  CA  GLU A 116      11.312  60.471  88.541  1.00  0.00           C  
ATOM   1801  C   GLU A 116      11.688  61.905  88.922  1.00  0.00           C  
ATOM   1802  O   GLU A 116      10.817  62.761  89.067  1.00  0.00           O  
ATOM   1803  CB  GLU A 116      11.415  59.538  89.748  1.00  0.00           C  
ATOM   1804  CG  GLU A 116      10.030  59.223  90.318  1.00  0.00           C  
ATOM   1805  CD  GLU A 116       9.886  59.766  91.740  1.00  0.00           C  
ATOM   1806  OE1 GLU A 116      10.793  59.480  92.551  1.00  0.00           O  
ATOM   1807  OE2 GLU A 116       8.873  60.455  91.985  1.00  0.00           O  
ATOM   1808  H   GLU A 116      12.682  59.182  87.647  1.00  0.00           H  
ATOM   1809  HA  GLU A 116      10.293  60.446  88.156  1.00  0.00           H  
ATOM   1810  HB2 GLU A 116      11.911  58.612  89.455  1.00  0.00           H  
ATOM   1811  HB3 GLU A 116      12.033  60.000  90.519  1.00  0.00           H  
ATOM   1812  HG2 GLU A 116       9.262  59.659  89.679  1.00  0.00           H  
ATOM   1813  HG3 GLU A 116       9.870  58.145  90.318  1.00  0.00           H  
ATOM   1814  N   LYS A 117      12.986  62.121  89.074  1.00  0.00           N  
ATOM   1815  CA  LYS A 117      13.488  63.436  89.436  1.00  0.00           C  
ATOM   1816  C   LYS A 117      13.046  64.454  88.381  1.00  0.00           C  
ATOM   1817  O   LYS A 117      12.724  65.595  88.711  1.00  0.00           O  
ATOM   1818  CB  LYS A 117      15.001  63.392  89.651  1.00  0.00           C  
ATOM   1819  CG  LYS A 117      15.344  62.770  91.007  1.00  0.00           C  
ATOM   1820  CD  LYS A 117      15.128  63.775  92.141  1.00  0.00           C  
ATOM   1821  CE  LYS A 117      16.461  64.344  92.630  1.00  0.00           C  
ATOM   1822  NZ  LYS A 117      16.235  65.385  93.657  1.00  0.00           N  
ATOM   1823  H   LYS A 117      13.688  61.420  88.954  1.00  0.00           H  
ATOM   1824  HA  LYS A 117      13.034  63.709  90.389  1.00  0.00           H  
ATOM   1825  HB2 LYS A 117      15.469  62.815  88.854  1.00  0.00           H  
ATOM   1826  HB3 LYS A 117      15.411  64.401  89.596  1.00  0.00           H  
ATOM   1827  HG2 LYS A 117      14.725  61.890  91.174  1.00  0.00           H  
ATOM   1828  HG3 LYS A 117      16.381  62.435  91.005  1.00  0.00           H  
ATOM   1829  HD2 LYS A 117      14.487  64.586  91.796  1.00  0.00           H  
ATOM   1830  HD3 LYS A 117      14.610  63.290  92.967  1.00  0.00           H  
ATOM   1831  HE2 LYS A 117      17.076  63.543  93.044  1.00  0.00           H  
ATOM   1832  HE3 LYS A 117      17.013  64.768  91.790  1.00  0.00           H  
ATOM   1833  HZ1 LYS A 117      17.062  65.497  94.206  1.00  0.00           H  
ATOM   1834  HZ2 LYS A 117      16.011  66.251  93.210  1.00  0.00           H  
ATOM   1835  HZ3 LYS A 117      15.477  65.110  94.249  1.00  0.00           H  
ATOM   1836  N   GLU A 118      13.046  64.005  87.135  1.00  0.00           N  
ATOM   1837  CA  GLU A 118      12.650  64.862  86.031  1.00  0.00           C  
ATOM   1838  C   GLU A 118      11.125  64.917  85.922  1.00  0.00           C  
ATOM   1839  O   GLU A 118      10.576  65.809  85.277  1.00  0.00           O  
ATOM   1840  CB  GLU A 118      13.276  64.388  84.718  1.00  0.00           C  
ATOM   1841  CG  GLU A 118      14.707  64.911  84.571  1.00  0.00           C  
ATOM   1842  CD  GLU A 118      14.729  66.244  83.819  1.00  0.00           C  
ATOM   1843  OE1 GLU A 118      14.110  67.198  84.339  1.00  0.00           O  
ATOM   1844  OE2 GLU A 118      15.364  66.279  82.744  1.00  0.00           O  
ATOM   1845  H   GLU A 118      13.310  63.075  86.876  1.00  0.00           H  
ATOM   1846  HA  GLU A 118      13.039  65.849  86.276  1.00  0.00           H  
ATOM   1847  HB2 GLU A 118      13.278  63.298  84.683  1.00  0.00           H  
ATOM   1848  HB3 GLU A 118      12.671  64.731  83.878  1.00  0.00           H  
ATOM   1849  HG2 GLU A 118      15.153  65.038  85.557  1.00  0.00           H  
ATOM   1850  HG3 GLU A 118      15.313  64.179  84.038  1.00  0.00           H  
ATOM   1851  N   LYS A 119      10.483  63.953  86.565  1.00  0.00           N  
ATOM   1852  CA  LYS A 119       9.032  63.880  86.549  1.00  0.00           C  
ATOM   1853  C   LYS A 119       8.461  64.963  87.466  1.00  0.00           C  
ATOM   1854  O   LYS A 119       7.506  65.648  87.104  1.00  0.00           O  
ATOM   1855  CB  LYS A 119       8.562  62.467  86.900  1.00  0.00           C  
ATOM   1856  CG  LYS A 119       7.477  61.993  85.930  1.00  0.00           C  
ATOM   1857  CD  LYS A 119       6.621  60.892  86.560  1.00  0.00           C  
ATOM   1858  CE  LYS A 119       5.141  61.089  86.224  1.00  0.00           C  
ATOM   1859  NZ  LYS A 119       4.548  62.132  87.090  1.00  0.00           N  
ATOM   1860  H   LYS A 119      10.936  63.230  87.088  1.00  0.00           H  
ATOM   1861  HA  LYS A 119       8.706  64.084  85.529  1.00  0.00           H  
ATOM   1862  HB2 LYS A 119       9.407  61.779  86.870  1.00  0.00           H  
ATOM   1863  HB3 LYS A 119       8.175  62.451  87.918  1.00  0.00           H  
ATOM   1864  HG2 LYS A 119       6.845  62.834  85.647  1.00  0.00           H  
ATOM   1865  HG3 LYS A 119       7.940  61.620  85.016  1.00  0.00           H  
ATOM   1866  HD2 LYS A 119       6.953  59.918  86.201  1.00  0.00           H  
ATOM   1867  HD3 LYS A 119       6.756  60.896  87.641  1.00  0.00           H  
ATOM   1868  HE2 LYS A 119       5.034  61.373  85.177  1.00  0.00           H  
ATOM   1869  HE3 LYS A 119       4.604  60.150  86.356  1.00  0.00           H  
ATOM   1870  HZ1 LYS A 119       4.304  62.927  86.535  1.00  0.00           H  
ATOM   1871  HZ2 LYS A 119       3.728  61.771  87.534  1.00  0.00           H  
ATOM   1872  HZ3 LYS A 119       5.211  62.405  87.787  1.00  0.00           H  
ATOM   1873  N   GLU A 120       9.071  65.084  88.637  1.00  0.00           N  
ATOM   1874  CA  GLU A 120       8.635  66.073  89.608  1.00  0.00           C  
ATOM   1875  C   GLU A 120       8.889  67.485  89.078  1.00  0.00           C  
ATOM   1876  O   GLU A 120       8.072  68.383  89.277  1.00  0.00           O  
ATOM   1877  CB  GLU A 120       9.328  65.859  90.956  1.00  0.00           C  
ATOM   1878  CG  GLU A 120       8.357  65.283  91.987  1.00  0.00           C  
ATOM   1879  CD  GLU A 120       9.110  64.706  93.187  1.00  0.00           C  
ATOM   1880  OE1 GLU A 120       9.481  63.515  93.105  1.00  0.00           O  
ATOM   1881  OE2 GLU A 120       9.296  65.469  94.160  1.00  0.00           O  
ATOM   1882  H   GLU A 120       9.847  64.523  88.923  1.00  0.00           H  
ATOM   1883  HA  GLU A 120       7.564  65.909  89.727  1.00  0.00           H  
ATOM   1884  HB2 GLU A 120      10.175  65.184  90.830  1.00  0.00           H  
ATOM   1885  HB3 GLU A 120       9.729  66.807  91.317  1.00  0.00           H  
ATOM   1886  HG2 GLU A 120       7.673  66.063  92.323  1.00  0.00           H  
ATOM   1887  HG3 GLU A 120       7.750  64.505  91.525  1.00  0.00           H  
ATOM   1888  N   SER A 121      10.025  67.639  88.414  1.00  0.00           N  
ATOM   1889  CA  SER A 121      10.397  68.927  87.855  1.00  0.00           C  
ATOM   1890  C   SER A 121       9.270  69.456  86.965  1.00  0.00           C  
ATOM   1891  O   SER A 121       8.724  70.527  87.221  1.00  0.00           O  
ATOM   1892  CB  SER A 121      11.700  68.826  87.059  1.00  0.00           C  
ATOM   1893  OG  SER A 121      12.351  70.088  86.939  1.00  0.00           O  
ATOM   1894  H   SER A 121      10.685  66.904  88.257  1.00  0.00           H  
ATOM   1895  HA  SER A 121      10.547  69.583  88.714  1.00  0.00           H  
ATOM   1896  HB2 SER A 121      12.370  68.118  87.547  1.00  0.00           H  
ATOM   1897  HB3 SER A 121      11.489  68.431  86.065  1.00  0.00           H  
ATOM   1898  HG  SER A 121      13.156  70.117  87.531  1.00  0.00           H  
ATOM   1899  N   ILE A 122       8.958  68.680  85.938  1.00  0.00           N  
ATOM   1900  CA  ILE A 122       7.906  69.056  85.009  1.00  0.00           C  
ATOM   1901  C   ILE A 122       6.550  68.945  85.707  1.00  0.00           C  
ATOM   1902  O   ILE A 122       5.703  69.826  85.571  1.00  0.00           O  
ATOM   1903  CB  ILE A 122       8.006  68.232  83.724  1.00  0.00           C  
ATOM   1904  CG1 ILE A 122       9.228  68.644  82.902  1.00  0.00           C  
ATOM   1905  CG2 ILE A 122       6.712  68.322  82.913  1.00  0.00           C  
ATOM   1906  CD1 ILE A 122      10.210  67.479  82.754  1.00  0.00           C  
ATOM   1907  H   ILE A 122       9.407  67.809  85.737  1.00  0.00           H  
ATOM   1908  HA  ILE A 122       8.069  70.099  84.736  1.00  0.00           H  
ATOM   1909  HB  ILE A 122       8.141  67.186  83.998  1.00  0.00           H  
ATOM   1910 HG12 ILE A 122       8.911  68.982  81.915  1.00  0.00           H  
ATOM   1911 HG13 ILE A 122       9.727  69.486  83.381  1.00  0.00           H  
ATOM   1912 HG21 ILE A 122       6.772  67.649  82.057  1.00  0.00           H  
ATOM   1913 HG22 ILE A 122       5.869  68.038  83.540  1.00  0.00           H  
ATOM   1914 HG23 ILE A 122       6.574  69.344  82.561  1.00  0.00           H  
ATOM   1915 HD11 ILE A 122       9.662  66.572  82.499  1.00  0.00           H  
ATOM   1916 HD12 ILE A 122      10.927  67.705  81.966  1.00  0.00           H  
ATOM   1917 HD13 ILE A 122      10.739  67.330  83.696  1.00  0.00           H  
ATOM   1918  N   ALA A 123       6.385  67.853  86.440  1.00  0.00           N  
ATOM   1919  CA  ALA A 123       5.147  67.614  87.160  1.00  0.00           C  
ATOM   1920  C   ALA A 123       3.971  67.695  86.184  1.00  0.00           C  
ATOM   1921  O   ALA A 123       3.586  66.691  85.586  1.00  0.00           O  
ATOM   1922  CB  ALA A 123       5.021  68.617  88.308  1.00  0.00           C  
ATOM   1923  H   ALA A 123       7.080  67.140  86.545  1.00  0.00           H  
ATOM   1924  HA  ALA A 123       5.193  66.607  87.577  1.00  0.00           H  
ATOM   1925  HB1 ALA A 123       5.686  69.461  88.127  1.00  0.00           H  
ATOM   1926  HB2 ALA A 123       3.993  68.972  88.371  1.00  0.00           H  
ATOM   1927  HB3 ALA A 123       5.296  68.133  89.246  1.00  0.00           H  
ATOM   1928  N   ARG A 124       3.434  68.899  86.055  1.00  0.00           N  
ATOM   1929  CA  ARG A 124       2.310  69.124  85.162  1.00  0.00           C  
ATOM   1930  C   ARG A 124       1.011  68.639  85.810  1.00  0.00           C  
ATOM   1931  O   ARG A 124       0.620  67.486  85.640  1.00  0.00           O  
ATOM   1932  CB  ARG A 124       2.508  68.396  83.831  1.00  0.00           C  
ATOM   1933  CG  ARG A 124       1.726  69.080  82.709  1.00  0.00           C  
ATOM   1934  CD  ARG A 124       0.633  68.160  82.163  1.00  0.00           C  
ATOM   1935  NE  ARG A 124       1.102  67.494  80.926  1.00  0.00           N  
ATOM   1936  CZ  ARG A 124       0.476  66.461  80.346  1.00  0.00           C  
ATOM   1937  NH1 ARG A 124      -0.646  65.968  80.885  1.00  0.00           N  
ATOM   1938  NH2 ARG A 124       0.975  65.920  79.225  1.00  0.00           N  
ATOM   1939  H   ARG A 124       3.752  69.710  86.546  1.00  0.00           H  
ATOM   1940  HA  ARG A 124       2.291  70.202  85.004  1.00  0.00           H  
ATOM   1941  HB2 ARG A 124       3.569  68.375  83.579  1.00  0.00           H  
ATOM   1942  HB3 ARG A 124       2.183  67.360  83.926  1.00  0.00           H  
ATOM   1943  HG2 ARG A 124       1.278  70.001  83.082  1.00  0.00           H  
ATOM   1944  HG3 ARG A 124       2.405  69.361  81.904  1.00  0.00           H  
ATOM   1945  HD2 ARG A 124       0.368  67.412  82.910  1.00  0.00           H  
ATOM   1946  HD3 ARG A 124      -0.270  68.736  81.955  1.00  0.00           H  
ATOM   1947  HE  ARG A 124       1.937  67.837  80.497  1.00  0.00           H  
ATOM   1948 HH11 ARG A 124      -1.018  66.371  81.722  1.00  0.00           H  
ATOM   1949 HH12 ARG A 124      -1.113  65.197  80.452  1.00  0.00           H  
ATOM   1950 HH21 ARG A 124       1.813  66.289  78.822  1.00  0.00           H  
ATOM   1951 HH22 ARG A 124       0.508  65.149  78.792  1.00  0.00           H  
ATOM   1952  N   SER A 125       0.379  69.546  86.541  1.00  0.00           N  
ATOM   1953  CA  SER A 125      -0.867  69.226  87.216  1.00  0.00           C  
ATOM   1954  C   SER A 125      -1.828  70.415  87.136  1.00  0.00           C  
ATOM   1955  O   SER A 125      -1.399  71.567  87.176  1.00  0.00           O  
ATOM   1956  CB  SER A 125      -0.621  68.842  88.676  1.00  0.00           C  
ATOM   1957  OG  SER A 125      -1.427  67.741  89.084  1.00  0.00           O  
ATOM   1958  H   SER A 125       0.703  70.482  86.675  1.00  0.00           H  
ATOM   1959  HA  SER A 125      -1.275  68.369  86.680  1.00  0.00           H  
ATOM   1960  HB2 SER A 125       0.432  68.591  88.813  1.00  0.00           H  
ATOM   1961  HB3 SER A 125      -0.828  69.699  89.317  1.00  0.00           H  
ATOM   1962  HG  SER A 125      -1.035  67.311  89.897  1.00  0.00           H  
ATOM   1963  N   GLY A 126      -3.108  70.094  87.022  1.00  0.00           N  
ATOM   1964  CA  GLY A 126      -4.132  71.121  86.934  1.00  0.00           C  
ATOM   1965  C   GLY A 126      -3.948  71.974  85.677  1.00  0.00           C  
ATOM   1966  O   GLY A 126      -3.146  72.908  85.669  1.00  0.00           O  
ATOM   1967  H   GLY A 126      -3.448  69.154  86.989  1.00  0.00           H  
ATOM   1968  HA2 GLY A 126      -5.118  70.657  86.921  1.00  0.00           H  
ATOM   1969  HA3 GLY A 126      -4.091  71.757  87.818  1.00  0.00           H  
ATOM   1970  N   PRO A 127      -4.721  71.613  84.619  1.00  0.00           N  
ATOM   1971  CA  PRO A 127      -4.651  72.335  83.360  1.00  0.00           C  
ATOM   1972  C   PRO A 127      -5.360  73.687  83.462  1.00  0.00           C  
ATOM   1973  O   PRO A 127      -6.267  73.856  84.276  1.00  0.00           O  
ATOM   1974  CB  PRO A 127      -5.287  71.406  82.338  1.00  0.00           C  
ATOM   1975  CG  PRO A 127      -6.104  70.405  83.138  1.00  0.00           C  
ATOM   1976  CD  PRO A 127      -5.681  70.513  84.594  1.00  0.00           C  
ATOM   1977  HA  PRO A 127      -3.700  72.542  83.131  1.00  0.00           H  
ATOM   1978  HB2 PRO A 127      -5.919  71.962  81.646  1.00  0.00           H  
ATOM   1979  HB3 PRO A 127      -4.527  70.902  81.742  1.00  0.00           H  
ATOM   1980  HG2 PRO A 127      -7.170  70.611  83.034  1.00  0.00           H  
ATOM   1981  HG3 PRO A 127      -5.939  69.393  82.766  1.00  0.00           H  
ATOM   1982  HD2 PRO A 127      -6.534  70.717  85.241  1.00  0.00           H  
ATOM   1983  HD3 PRO A 127      -5.229  69.586  84.945  1.00  0.00           H  
ATOM   1984  N   SER A 128      -4.920  74.614  82.625  1.00  0.00           N  
ATOM   1985  CA  SER A 128      -5.501  75.946  82.611  1.00  0.00           C  
ATOM   1986  C   SER A 128      -5.279  76.599  81.245  1.00  0.00           C  
ATOM   1987  O   SER A 128      -4.155  76.962  80.902  1.00  0.00           O  
ATOM   1988  CB  SER A 128      -4.908  76.818  83.719  1.00  0.00           C  
ATOM   1989  OG  SER A 128      -3.485  76.743  83.754  1.00  0.00           O  
ATOM   1990  H   SER A 128      -4.182  74.468  81.966  1.00  0.00           H  
ATOM   1991  HA  SER A 128      -6.565  75.799  82.796  1.00  0.00           H  
ATOM   1992  HB2 SER A 128      -5.212  77.853  83.568  1.00  0.00           H  
ATOM   1993  HB3 SER A 128      -5.311  76.504  84.682  1.00  0.00           H  
ATOM   1994  HG  SER A 128      -3.162  76.806  84.697  1.00  0.00           H  
ATOM   1995  N   SER A 129      -6.368  76.730  80.503  1.00  0.00           N  
ATOM   1996  CA  SER A 129      -6.306  77.334  79.182  1.00  0.00           C  
ATOM   1997  C   SER A 129      -7.510  78.252  78.970  1.00  0.00           C  
ATOM   1998  O   SER A 129      -8.528  78.115  79.647  1.00  0.00           O  
ATOM   1999  CB  SER A 129      -6.255  76.264  78.090  1.00  0.00           C  
ATOM   2000  OG  SER A 129      -5.266  75.274  78.358  1.00  0.00           O  
ATOM   2001  H   SER A 129      -7.279  76.432  80.788  1.00  0.00           H  
ATOM   2002  HA  SER A 129      -5.380  77.908  79.171  1.00  0.00           H  
ATOM   2003  HB2 SER A 129      -7.231  75.786  78.004  1.00  0.00           H  
ATOM   2004  HB3 SER A 129      -6.045  76.736  77.130  1.00  0.00           H  
ATOM   2005  HG  SER A 129      -5.198  74.641  77.587  1.00  0.00           H  
ATOM   2006  N   GLY A 130      -7.356  79.170  78.027  1.00  0.00           N  
ATOM   2007  CA  GLY A 130      -8.418  80.111  77.716  1.00  0.00           C  
ATOM   2008  C   GLY A 130      -8.139  81.479  78.345  1.00  0.00           C  
ATOM   2009  O   GLY A 130      -8.472  82.512  77.765  1.00  0.00           O  
ATOM   2010  H   GLY A 130      -6.524  79.276  77.481  1.00  0.00           H  
ATOM   2011  HA2 GLY A 130      -8.512  80.216  76.636  1.00  0.00           H  
ATOM   2012  HA3 GLY A 130      -9.369  79.726  78.084  1.00  0.00           H  
TER    2013      GLY A 130                                                      
END
MOLECULE T0470_112_214.pdb
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
