
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  194 ( 1554),  selected  194 , name 2ogi_B
# Molecule2: number of CA atoms  188 ( 1523),  selected  188 , name T0470.pdb
# PARAMETERS: 2ogi_B.T0470.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      -       -           -
LGA    T     2_B      T       2          5.032
LGA    Y     3_B      K       3          2.994
LGA    K     4_B      Q       4          5.381
LGA    D     5_B      -       -           -
LGA    Y     6_B      -       -           -
LGA    T     7_B      -       -           -
LGA    G     8_B      -       -           -
LGA    L     9_B      E       5          5.270
LGA    D    10_B      K       6          2.857
LGA    R    11_B      I       7          3.279
LGA    T    12_B      E       8          3.212
LGA    E    13_B      K       9          2.137
LGA    L    14_B      T      10          1.636
LGA    L    15_B      I      11          1.309
LGA    S    16_B      T      12          1.590
LGA    K    17_B      F      13          1.399
LGA    V    18_B      V      14          0.629
LGA    R    19_B      K      15          0.901
LGA    H    20_B      H      16          1.459
LGA    X    21_B      I      17          1.850
LGA    X    22_B      L      18          2.052
LGA    -       -      E      19           -
LGA    -       -      K      20           -
LGA    -       -      D      21           -
LGA    -       -      A      22           -
LGA    S    23_B      S      23          2.159
LGA    D    24_B      G      24          2.599
LGA    K    25_B      H      25          3.028
LGA    R    26_B      D      26          1.889
LGA    F    27_B      W      27          1.325
LGA    N    28_B      Y      28          1.355
LGA    H    29_B      H      29          1.323
LGA    V    30_B      I      30          1.060
LGA    L    31_B      R      31          0.640
LGA    G    32_B      R      32          1.404
LGA    V    33_B      V      33          1.545
LGA    E    34_B      H      34          0.898
LGA    R    35_B      K      35          1.420
LGA    A    36_B      M      36          1.779
LGA    A    37_B      A      37          1.283
LGA    I    38_B      I      38          1.225
LGA    E    39_B      S      39          2.035
LGA    L    40_B      L      40          2.162
LGA    A    41_B      S      41          1.213
LGA    E    42_B      E      42          1.774
LGA    R    43_B      Q      43          2.256
LGA    Y    44_B      E      44          1.605
LGA    G    45_B      G      45          1.693
LGA    Y    46_B      G      46          1.487
LGA    D    47_B      N      47          2.167
LGA    K    48_B      R      48          1.986
LGA    E    49_B      F      49          2.187
LGA    K    50_B      I      50          1.795
LGA    A    51_B      I      51          1.001
LGA    G    52_B      E      52          1.349
LGA    L    53_B      M      53          1.496
LGA    A    54_B      A      54          1.028
LGA    A    55_B      A      55          0.691
LGA    L    56_B      L      56          0.921
LGA    L    57_B      L      57          1.511
LGA    H    58_B      H      58          1.417
LGA    D    59_B      D      59          1.185
LGA    Y    60_B      V      60          1.752
LGA    A    61_B      A      61          2.667
LGA    K    62_B      D      62          3.192
LGA    E    63_B      L      65          3.088
LGA    L    64_B      N      66          2.048
LGA    S    65_B      E      67          2.768
LGA    D    66_B      S      68          3.062
LGA    D    67_B      -       -           -
LGA    E    68_B      -       -           -
LGA    F    69_B      -       -           -
LGA    L    70_B      -       -           -
LGA    R    71_B      -       -           -
LGA    L    72_B      -       -           -
LGA    I    73_B      -       -           -
LGA    D    74_B      -       -           -
LGA    K    75_B      -       -           -
LGA    Y    76_B      -       -           -
LGA    Q    77_B      -       -           -
LGA    P    78_B      -       -           -
LGA    D    79_B      -       -           -
LGA    P    80_B      -       -           -
LGA    D    81_B      -       -           -
LGA    L    82_B      -       -           -
LGA    K    83_B      -       -           -
LGA    K    84_B      -       -           -
LGA    W    85_B      -       -           -
LGA    G    86_B      -       -           -
LGA    N    87_B      -       -           -
LGA    N    88_B      -       -           -
LGA    I    89_B      -       -           -
LGA    W    90_B      E      69          2.787
LGA    H    91_B      -       -           -
LGA    G    92_B      -       -           -
LGA    L    93_B      E      70          4.640
LGA    V    94_B      A      71          4.208
LGA    G    95_B      G      72          2.362
LGA    I    96_B      M      73          2.303
LGA    Y    97_B      K      74          1.003
LGA    K    98_B      K      75          0.522
LGA    I    99_B      V      76          0.852
LGA    Q   100_B      S      77          1.834
LGA    E   101_B      D      78          1.948
LGA    D   102_B      W      79          2.834
LGA    L   103_B      L      80          3.330
LGA    A   104_B      E      81          1.726
LGA    -       -      E      82           -
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    I   105_B      V      85          3.758
LGA    K   106_B      E      86          4.484
LGA    D   107_B      E      87          4.059
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    -       -      S      90           -
LGA    Q   108_B      K      91          1.309
LGA    D   109_B      H      92          1.330
LGA    I   110_B      V      93          1.145
LGA    L   111_B      L      94          1.556
LGA    A   112_B      H      95          0.973
LGA    A   113_B      I      96          1.093
LGA    I   114_B      I      97          0.891
LGA    A   115_B      A      98          1.611
LGA    K   116_B      N      99          1.713
LGA    H   117_B      M     100          1.823
LGA    T   118_B      -       -           -
LGA    V   119_B      -       -           -
LGA    G   120_B      -       -           -
LGA    S   121_B      -       -           -
LGA    A   122_B      -       -           -
LGA    Q   123_B      -       -           -
LGA    X   124_B      -       -           -
LGA    S   125_B      S     112          1.186
LGA    T   126_B      I     113          1.178
LGA    L   127_B      E     114          1.613
LGA    D   128_B      G     115          2.152
LGA    K   129_B      K     116          1.269
LGA    I   130_B      L     117          1.339
LGA    V   131_B      V     118          1.756
LGA    Y   132_B      Q     119          1.910
LGA    V   133_B      D     120          1.962
LGA    A   134_B      A     121          1.355
LGA    D   135_B      D     122          1.385
LGA    Y   136_B      R     123          0.895
LGA    I   137_B      L     124          0.832
LGA    E   138_B      D     125          2.807
LGA    H   139_B      -       -           -
LGA    N   140_B      -       -           -
LGA    R   141_B      A     126          2.901
LGA    D   142_B      L     127          4.368
LGA    -       -      G     128           -
LGA    -       -      A     129           -
LGA    -       -      I     130           -
LGA    -       -      G     131           -
LGA    -       -      I     132           -
LGA    -       -      A     133           -
LGA    F   143_B      R     134           #
LGA    -       -      T     135           -
LGA    -       -      F     136           -
LGA    -       -      A     137           -
LGA    -       -      Y     138           -
LGA    -       -      G     139           -
LGA    -       -      G     140           -
LGA    -       -      A     141           -
LGA    -       -      K     142           -
LGA    -       -      G     143           -
LGA    -       -      R     144           -
LGA    -       -      L     145           -
LGA    -       -      M     146           -
LGA    -       -      Y     147           -
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    -       -      S     169           -
LGA    -       -      L     170           -
LGA    -       -      N     171           -
LGA    -       -      H     172           -
LGA    -       -      F     173           -
LGA    -       -      Y     174           -
LGA    -       -      E     175           -
LGA    -       -      K     176           -
LGA    P   144_B      L     177          2.850
LGA    G   145_B      L     178          1.996
LGA    V   146_B      K     179           -
LGA    E   147_B      L     180           -
LGA    E   148_B      K     181          2.797
LGA    A   149_B      D     182          5.219
LGA    R   150_B      L     183           -
LGA    E   151_B      -       -           -
LGA    L   152_B      -       -           -
LGA    A   153_B      M     184          4.209
LGA    K   154_B      -       -           -
LGA    V   155_B      -       -           -
LGA    D   156_B      -       -           -
LGA    L   157_B      N     185          1.948
LGA    N   158_B      T     186           #
LGA    K   159_B      N     187           -
LGA    -       -      A     188           -
LGA    -       -      A     189           -
LGA    A   160_B      K     190           #
LGA    V   161_B      Q     191           -
LGA    A   162_B      E     192           -
LGA    Y   163_B      A     193           -
LGA    E   164_B      E     194           -
LGA    T   165_B      V     195           -
LGA    A   166_B      R     196           -
LGA    R   167_B      H     197           -
LGA    T   168_B      R     198           -
LGA    V   169_B      Y     199           -
LGA    A   170_B      M     200           -
LGA    F   171_B      E     201           -
LGA    L   172_B      Q     202           -
LGA    A   173_B      F     203           -
LGA    S   174_B      I     204           -
LGA    K   175_B      E     205           -
LGA    A   176_B      Q     206           -
LGA    Q   177_B      F     207           -
LGA    P   178_B      M     208           -
LGA    I   179_B      K     209           -
LGA    Y   180_B      E     210           -
LGA    P   181_B      W     211           -
LGA    K   182_B      N     212           -
LGA    T   183_B      A     213           -
LGA    I   184_B      Q     214           -
LGA    E   185_B      -       -           -
LGA    T   186_B      -       -           -
LGA    Y   187_B      -       -           -
LGA    N   188_B      -       -           -
LGA    A   189_B      -       -           -
LGA    Y   190_B      -       -           -
LGA    I   191_B      -       -           -
LGA    P   192_B      -       -           -
LGA    Y   193_B      -       -           -
LGA    L   194_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  194  188    5.0    109    2.32    26.61     47.660     4.498

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.970436 * X  +   0.043835 * Y  +   0.237345 * Z  +  16.682640
  Y_new =  -0.108395 * X  +  -0.957774 * Y  +  -0.266306 * Z  +  90.027870
  Z_new =   0.215649 * X  +  -0.284160 * Y  +   0.934210 * Z  +  23.307261 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.295279    2.846314  [ DEG:   -16.9182    163.0818 ]
  Theta =  -0.217356   -2.924236  [ DEG:   -12.4536   -167.5464 ]
  Phi   =  -3.030356    0.111236  [ DEG:  -173.6266      6.3734 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ogi_B                                        
REMARK     2: T0470.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ogi_B.T0470.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  194  188   5.0  109   2.32   26.61  47.660
REMARK  ---------------------------------------------------------- 
MOLECULE 2ogi_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   05-JAN-07   2OGI              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE METAL DEPENDENT                       
TITLE    2 PHOSPHOHYDROLASE (NP_688652.1) FROM STREPTOCOCCUS                    
TITLE    3 AGALACTIAE 2603 AT 1.85 A RESOLUTION                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN SAG1661;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: CONSERVED HYPOTHETICAL PROTEIN TIGR00488;                   
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS AGALACTIAE SEROTYPE V;            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 2603 V/R;                                                    
SOURCE   5 ATCC: BAA-611;                                                       
SOURCE   6 GENE: NP_688652.1, SAG1661;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_688652.1, CONSERVED HYPOTHETICAL PROTEIN TIGR00488,                
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   16-JAN-07 2OGI    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF CONSERVED HYPOTHETICAL                  
JRNL        TITL 2 PROTEIN TIGR00488 (NP_688652.1) FROM STREPTOCOCCUS           
JRNL        TITL 3 AGALACTIAE 2603 AT 1.85 A RESOLUTION                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  2OGI A    1   195  UNP    Q8DY32   Q8DY32_STRA5     1    195             
DBREF  2OGI B    1   195  UNP    Q8DY32   Q8DY32_STRA5     1    195             
SEQRES   1 A  196  GLY MSE THR TYR LYS ASP TYR THR GLY LEU ASP ARG THR          
SEQRES   2 A  196  GLU LEU LEU SER LYS VAL ARG HIS MSE MSE SER ASP LYS          
SEQRES   3 A  196  ARG PHE ASN HIS VAL LEU GLY VAL GLU ARG ALA ALA ILE          
SEQRES   4 A  196  GLU LEU ALA GLU ARG TYR GLY TYR ASP LYS GLU LYS ALA          
SEQRES   5 A  196  GLY LEU ALA ALA LEU LEU HIS ASP TYR ALA LYS GLU LEU          
SEQRES   6 A  196  SER ASP ASP GLU PHE LEU ARG LEU ILE ASP LYS TYR GLN          
SEQRES   7 A  196  PRO ASP PRO ASP LEU LYS LYS TRP GLY ASN ASN ILE TRP          
SEQRES   8 A  196  HIS GLY LEU VAL GLY ILE TYR LYS ILE GLN GLU ASP LEU          
SEQRES   9 A  196  ALA ILE LYS ASP GLN ASP ILE LEU ALA ALA ILE ALA LYS          
SEQRES  10 A  196  HIS THR VAL GLY SER ALA GLN MSE SER THR LEU ASP LYS          
SEQRES  11 A  196  ILE VAL TYR VAL ALA ASP TYR ILE GLU HIS ASN ARG ASP          
SEQRES  12 A  196  PHE PRO GLY VAL GLU GLU ALA ARG GLU LEU ALA LYS VAL          
SEQRES  13 A  196  ASP LEU ASN LYS ALA VAL ALA TYR GLU THR ALA ARG THR          
SEQRES  14 A  196  VAL ALA PHE LEU ALA SER LYS ALA GLN PRO ILE TYR PRO          
SEQRES  15 A  196  LYS THR ILE GLU THR TYR ASN ALA TYR ILE PRO TYR LEU          
SEQRES  16 A  196  ASP                                                          
SEQRES   1 B  196  GLY MSE THR TYR LYS ASP TYR THR GLY LEU ASP ARG THR          
SEQRES   2 B  196  GLU LEU LEU SER LYS VAL ARG HIS MSE MSE SER ASP LYS          
SEQRES   3 B  196  ARG PHE ASN HIS VAL LEU GLY VAL GLU ARG ALA ALA ILE          
SEQRES   4 B  196  GLU LEU ALA GLU ARG TYR GLY TYR ASP LYS GLU LYS ALA          
SEQRES   5 B  196  GLY LEU ALA ALA LEU LEU HIS ASP TYR ALA LYS GLU LEU          
SEQRES   6 B  196  SER ASP ASP GLU PHE LEU ARG LEU ILE ASP LYS TYR GLN          
SEQRES   7 B  196  PRO ASP PRO ASP LEU LYS LYS TRP GLY ASN ASN ILE TRP          
SEQRES   8 B  196  HIS GLY LEU VAL GLY ILE TYR LYS ILE GLN GLU ASP LEU          
SEQRES   9 B  196  ALA ILE LYS ASP GLN ASP ILE LEU ALA ALA ILE ALA LYS          
SEQRES  10 B  196  HIS THR VAL GLY SER ALA GLN MSE SER THR LEU ASP LYS          
SEQRES  11 B  196  ILE VAL TYR VAL ALA ASP TYR ILE GLU HIS ASN ARG ASP          
SEQRES  12 B  196  PHE PRO GLY VAL GLU GLU ALA ARG GLU LEU ALA LYS VAL          
SEQRES  13 B  196  ASP LEU ASN LYS ALA VAL ALA TYR GLU THR ALA ARG THR          
SEQRES  14 B  196  VAL ALA PHE LEU ALA SER LYS ALA GLN PRO ILE TYR PRO          
SEQRES  15 B  196  LYS THR ILE GLU THR TYR ASN ALA TYR ILE PRO TYR LEU          
SEQRES  16 B  196  ASP                                                          
HET    MSE  A  21       8                                                       
HET    MSE  A  22       8                                                       
HET    MSE  A 124       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  21       8                                                       
HET    MSE  B  22       8                                                       
HET    MSE  B 124       8                                                       
HET     FE  A 301       1                                                       
HET     FE  A 302       1                                                       
HET     FE  B 301       1                                                       
HET     FE  B 302       1                                                       
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HET     CL      3       1                                                       
HET    GDP  A 400      28                                                       
HET    GDP  B 400      28                                                       
HET    MES      4      12                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      FE FE (III) ION                                                     
HETNAM      CL CHLORIDE ION                                                     
HETNAM     GDP GUANOSINE-5'-DIPHOSPHATE                                         
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
FORMUL   1  MSE    7(C5 H11 N O2 SE)                                            
FORMUL   3   FE    4(FE 3+)                                                     
FORMUL   7   CL    3(CL 1-)                                                     
FORMUL  10  GDP    2(C10 H15 N5 O11 P2)                                         
FORMUL  12  MES    C6 H13 N O4 S                                                
FORMUL  13  HOH   *272(H2 O)                                                    
CRYST1   65.841   52.535   70.022  90.00 114.29  90.00 P 1 21 1      4          
HETATM 1559  N   MSE B   1      47.966  25.381  81.957  1.00 66.45           N  
HETATM 1560  CA  MSE B   1      48.840  26.573  81.679  1.00 66.80           C  
HETATM 1561  C   MSE B   1      48.482  27.764  82.604  1.00 62.80           C  
HETATM 1562  O   MSE B   1      47.498  28.477  82.379  1.00 63.91           O  
HETATM 1563  CB  MSE B   1      48.788  26.945  80.184  1.00 66.01           C  
HETATM 1564  CG  MSE B   1      49.783  26.196  79.281  1.00 65.71           C  
HETATM 1565 SE   MSE B   1      51.259  27.342  78.620  0.75 75.66          SE  
HETATM 1566  CE  MSE B   1      50.852  27.408  76.649  1.00 67.09           C  
ATOM   1567  N   THR B   2      49.304  27.944  83.641  1.00 58.46           N  
ATOM   1568  CA  THR B   2      49.117  28.945  84.709  1.00 56.25           C  
ATOM   1569  C   THR B   2      49.708  30.298  84.318  1.00 52.07           C  
ATOM   1570  O   THR B   2      50.432  30.395  83.318  1.00 52.74           O  
ATOM   1571  CB  THR B   2      49.770  28.488  86.087  1.00 57.39           C  
ATOM   1572  OG1 THR B   2      50.129  29.620  86.898  1.00 59.65           O  
ATOM   1573  CG2 THR B   2      51.024  27.709  85.878  1.00 60.00           C  
ATOM   1574  N   TYR B   3      49.423  31.333  85.118  1.00 44.37           N  
ATOM   1575  CA  TYR B   3      49.995  32.648  84.868  1.00 41.38           C  
ATOM   1576  C   TYR B   3      51.507  32.497  84.860  1.00 41.13           C  
ATOM   1577  O   TYR B   3      52.173  33.106  84.015  1.00 43.19           O  
ATOM   1578  CB  TYR B   3      49.563  33.706  85.894  1.00 36.98           C  
ATOM   1579  CG  TYR B   3      48.131  34.242  85.767  1.00 35.17           C  
ATOM   1580  CD1 TYR B   3      47.195  33.677  84.906  1.00 29.02           C  
ATOM   1581  CD2 TYR B   3      47.715  35.297  86.570  1.00 30.77           C  
ATOM   1582  CE1 TYR B   3      45.894  34.174  84.843  1.00 31.11           C  
ATOM   1583  CE2 TYR B   3      46.453  35.795  86.507  1.00 33.59           C  
ATOM   1584  CZ  TYR B   3      45.539  35.242  85.662  1.00 31.85           C  
ATOM   1585  OH  TYR B   3      44.288  35.809  85.669  1.00 32.56           O  
ATOM   1586  N   LYS B   4      52.043  31.668  85.773  1.00 42.66           N  
ATOM   1587  CA  LYS B   4      53.508  31.413  85.869  1.00 38.58           C  
ATOM   1588  C   LYS B   4      54.070  30.771  84.607  1.00 37.74           C  
ATOM   1589  O   LYS B   4      55.134  31.167  84.121  1.00 37.64           O  
ATOM   1590  CB  LYS B   4      53.845  30.526  87.075  1.00 41.23           C  
ATOM   1591  N   ASP B   5      53.344  29.791  84.075  1.00 37.57           N  
ATOM   1592  CA  ASP B   5      53.690  29.169  82.807  1.00 37.88           C  
ATOM   1593  C   ASP B   5      53.864  30.214  81.705  1.00 39.52           C  
ATOM   1594  O   ASP B   5      54.791  30.115  80.886  1.00 37.89           O  
ATOM   1595  CB  ASP B   5      52.612  28.173  82.379  1.00 40.30           C  
ATOM   1596  CG  ASP B   5      52.604  26.886  83.223  1.00 48.96           C  
ATOM   1597  OD1 ASP B   5      53.305  26.796  84.267  1.00 58.84           O  
ATOM   1598  OD2 ASP B   5      51.872  25.947  82.832  1.00 60.60           O  
ATOM   1599  N   TYR B   6      52.978  31.216  81.695  1.00 36.18           N  
ATOM   1600  CA  TYR B   6      53.023  32.301  80.714  1.00 37.20           C  
ATOM   1601  C   TYR B   6      54.021  33.418  81.004  1.00 37.60           C  
ATOM   1602  O   TYR B   6      54.475  34.062  80.070  1.00 41.21           O  
ATOM   1603  CB  TYR B   6      51.623  32.935  80.573  1.00 36.55           C  
ATOM   1604  CG  TYR B   6      50.642  32.064  79.851  1.00 33.10           C  
ATOM   1605  CD1 TYR B   6      50.780  31.820  78.498  1.00 37.66           C  
ATOM   1606  CD2 TYR B   6      49.562  31.500  80.504  1.00 36.97           C  
ATOM   1607  CE1 TYR B   6      49.874  31.035  77.816  1.00 37.08           C  
ATOM   1608  CE2 TYR B   6      48.648  30.723  79.825  1.00 35.60           C  
ATOM   1609  CZ  TYR B   6      48.822  30.484  78.481  1.00 40.37           C  
ATOM   1610  OH  TYR B   6      47.938  29.689  77.783  1.00 42.46           O  
ATOM   1611  N   THR B   7      54.319  33.683  82.271  1.00 38.28           N  
ATOM   1612  CA  THR B   7      55.011  34.921  82.658  1.00 40.24           C  
ATOM   1613  C   THR B   7      56.264  34.722  83.495  1.00 42.75           C  
ATOM   1614  O   THR B   7      57.102  35.651  83.603  1.00 41.93           O  
ATOM   1615  CB  THR B   7      54.104  35.813  83.544  1.00 42.80           C  
ATOM   1616  OG1 THR B   7      53.525  35.020  84.596  1.00 43.13           O  
ATOM   1617  CG2 THR B   7      53.005  36.454  82.722  1.00 42.45           C  
ATOM   1618  N   GLY B   8      56.357  33.556  84.149  1.00 43.01           N  
ATOM   1619  CA  GLY B   8      57.389  33.321  85.148  1.00 44.13           C  
ATOM   1620  C   GLY B   8      57.136  33.964  86.509  1.00 44.59           C  
ATOM   1621  O   GLY B   8      57.907  33.743  87.427  1.00 44.37           O  
ATOM   1622  N   LEU B   9      56.086  34.777  86.651  1.00 43.89           N  
ATOM   1623  CA  LEU B   9      55.603  35.176  87.979  1.00 44.06           C  
ATOM   1624  C   LEU B   9      54.278  34.488  88.245  1.00 44.91           C  
ATOM   1625  O   LEU B   9      53.500  34.249  87.310  1.00 44.56           O  
ATOM   1626  CB  LEU B   9      55.393  36.679  88.077  1.00 43.66           C  
ATOM   1627  CG  LEU B   9      56.587  37.561  87.727  1.00 44.66           C  
ATOM   1628  CD1 LEU B   9      56.290  39.036  88.097  1.00 44.77           C  
ATOM   1629  CD2 LEU B   9      57.833  37.060  88.429  1.00 45.28           C  
ATOM   1630  N   ASP B  10      54.041  34.159  89.516  1.00 46.04           N  
ATOM   1631  CA  ASP B  10      52.722  33.724  89.975  1.00 47.52           C  
ATOM   1632  C   ASP B  10      51.817  34.947  90.092  1.00 47.40           C  
ATOM   1633  O   ASP B  10      52.297  36.092  90.160  1.00 49.03           O  
ATOM   1634  CB  ASP B  10      52.801  33.000  91.334  1.00 48.29           C  
ATOM   1635  CG  ASP B  10      53.305  33.900  92.476  1.00 51.49           C  
ATOM   1636  OD1 ASP B  10      53.102  35.129  92.418  1.00 48.71           O  
ATOM   1637  OD2 ASP B  10      53.905  33.371  93.444  1.00 54.75           O  
ATOM   1638  N   ARG B  11      50.513  34.705  90.159  1.00 46.64           N  
ATOM   1639  CA  ARG B  11      49.542  35.798  90.211  1.00 45.56           C  
ATOM   1640  C   ARG B  11      49.795  36.813  91.340  1.00 45.69           C  
ATOM   1641  O   ARG B  11      49.555  38.012  91.163  1.00 44.49           O  
ATOM   1642  CB  ARG B  11      48.126  35.247  90.310  1.00 45.18           C  
ATOM   1643  CG  ARG B  11      47.059  36.321  90.154  1.00 43.28           C  
ATOM   1644  CD  ARG B  11      45.684  35.729  89.975  1.00 41.37           C  
ATOM   1645  NE  ARG B  11      44.661  36.775  90.016  1.00 33.52           N  
ATOM   1646  CZ  ARG B  11      44.254  37.374  91.127  1.00 35.47           C  
ATOM   1647  NH1 ARG B  11      44.733  37.004  92.314  1.00 33.29           N  
ATOM   1648  NH2 ARG B  11      43.335  38.325  91.051  1.00 28.93           N  
ATOM   1649  N   THR B  12      50.276  36.347  92.490  1.00 44.42           N  
ATOM   1650  CA  THR B  12      50.552  37.235  93.617  1.00 44.17           C  
ATOM   1651  C   THR B  12      51.654  38.267  93.320  1.00 44.64           C  
ATOM   1652  O   THR B  12      51.526  39.444  93.668  1.00 42.87           O  
ATOM   1653  CB  THR B  12      50.971  36.418  94.853  1.00 45.13           C  
ATOM   1654  OG1 THR B  12      50.130  35.256  94.964  1.00 46.13           O  
ATOM   1655  CG2 THR B  12      50.894  37.270  96.110  1.00 44.60           C  
ATOM   1656  N   GLU B  13      52.745  37.797  92.708  1.00 44.19           N  
ATOM   1657  CA  GLU B  13      53.841  38.663  92.283  1.00 44.72           C  
ATOM   1658  C   GLU B  13      53.433  39.534  91.101  1.00 41.82           C  
ATOM   1659  O   GLU B  13      53.828  40.709  91.017  1.00 42.66           O  
ATOM   1660  CB  GLU B  13      55.073  37.829  91.914  1.00 44.90           C  
ATOM   1661  CG  GLU B  13      55.723  37.156  93.126  1.00 52.19           C  
ATOM   1662  CD  GLU B  13      56.765  36.125  92.738  1.00 58.15           C  
ATOM   1663  OE1 GLU B  13      56.607  35.482  91.671  1.00 58.69           O  
ATOM   1664  OE2 GLU B  13      57.736  35.954  93.510  1.00 62.98           O  
ATOM   1665  N   LEU B  14      52.662  38.966  90.184  1.00 39.36           N  
ATOM   1666  CA  LEU B  14      52.128  39.768  89.072  1.00 39.17           C  
ATOM   1667  C   LEU B  14      51.308  40.938  89.583  1.00 37.00           C  
ATOM   1668  O   LEU B  14      51.378  42.052  89.047  1.00 36.58           O  
ATOM   1669  CB  LEU B  14      51.226  38.935  88.158  1.00 40.56           C  
ATOM   1670  CG  LEU B  14      51.840  38.244  86.956  1.00 45.54           C  
ATOM   1671  CD1 LEU B  14      50.755  37.428  86.272  1.00 51.11           C  
ATOM   1672  CD2 LEU B  14      52.451  39.288  86.023  1.00 46.86           C  
ATOM   1673  N   LEU B  15      50.482  40.670  90.594  1.00 32.78           N  
ATOM   1674  CA  LEU B  15      49.550  41.668  91.047  1.00 33.41           C  
ATOM   1675  C   LEU B  15      50.282  42.841  91.668  1.00 33.95           C  
ATOM   1676  O   LEU B  15      49.821  43.979  91.570  1.00 35.53           O  
ATOM   1677  CB  LEU B  15      48.563  41.065  92.043  1.00 34.40           C  
ATOM   1678  CG  LEU B  15      47.399  40.257  91.468  1.00 39.32           C  
ATOM   1679  CD1 LEU B  15      46.621  39.688  92.607  1.00 38.26           C  
ATOM   1680  CD2 LEU B  15      46.527  41.101  90.593  1.00 39.58           C  
ATOM   1681  N   SER B  16      51.418  42.564  92.309  1.00 33.46           N  
ATOM   1682  CA  SER B  16      52.232  43.634  92.871  1.00 34.71           C  
ATOM   1683  C   SER B  16      52.859  44.503  91.799  1.00 32.41           C  
ATOM   1684  O   SER B  16      52.722  45.741  91.858  1.00 31.30           O  
ATOM   1685  CB  SER B  16      53.311  43.090  93.807  1.00 36.21           C  
ATOM   1686  OG  SER B  16      52.797  43.077  95.124  1.00 44.91           O  
ATOM   1687  N   LYS B  17      53.556  43.863  90.856  1.00 31.54           N  
ATOM   1688  CA  LYS B  17      54.156  44.576  89.732  1.00 31.74           C  
ATOM   1689  C   LYS B  17      53.135  45.383  88.945  1.00 30.59           C  
ATOM   1690  O   LYS B  17      53.402  46.500  88.564  1.00 29.88           O  
ATOM   1691  CB  LYS B  17      54.899  43.644  88.768  1.00 32.97           C  
ATOM   1692  CG  LYS B  17      55.693  44.455  87.710  1.00 38.13           C  
ATOM   1693  N   VAL B  18      51.951  44.816  88.708  1.00 30.83           N  
ATOM   1694  CA  VAL B  18      50.884  45.551  88.036  1.00 28.45           C  
ATOM   1695  C   VAL B  18      50.383  46.727  88.884  1.00 31.18           C  
ATOM   1696  O   VAL B  18      50.194  47.850  88.373  1.00 30.36           O  
ATOM   1697  CB  VAL B  18      49.717  44.576  87.670  1.00 29.94           C  
ATOM   1698  CG1 VAL B  18      48.461  45.305  87.142  1.00 28.87           C  
ATOM   1699  CG2 VAL B  18      50.177  43.539  86.656  1.00 31.70           C  
ATOM   1700  N   ARG B  19      50.190  46.492  90.183  1.00 29.62           N  
ATOM   1701  CA  ARG B  19      49.823  47.567  91.099  1.00 33.68           C  
ATOM   1702  C   ARG B  19      50.837  48.727  91.062  1.00 32.77           C  
ATOM   1703  O   ARG B  19      50.447  49.903  91.126  1.00 32.51           O  
ATOM   1704  CB  ARG B  19      49.716  47.017  92.533  1.00 32.83           C  
ATOM   1705  CG  ARG B  19      48.971  47.916  93.531  1.00 41.13           C  
ATOM   1706  CD  ARG B  19      49.038  47.306  94.964  1.00 42.15           C  
ATOM   1707  NE  ARG B  19      48.141  46.152  95.203  1.00 59.60           N  
ATOM   1708  CZ  ARG B  19      48.472  44.849  95.135  1.00 60.67           C  
ATOM   1709  NH1 ARG B  19      49.706  44.455  94.844  1.00 63.32           N  
ATOM   1710  NH2 ARG B  19      47.548  43.914  95.378  1.00 53.12           N  
ATOM   1711  N   HIS B  20      52.123  48.385  90.948  1.00 29.43           N  
ATOM   1712  CA  HIS B  20      53.203  49.401  90.901  1.00 29.81           C  
ATOM   1713  C   HIS B  20      53.150  50.296  89.683  1.00 29.30           C  
ATOM   1714  O   HIS B  20      53.580  51.443  89.745  1.00 27.11           O  
ATOM   1715  CB  HIS B  20      54.583  48.767  90.979  1.00 29.72           C  
ATOM   1716  CG  HIS B  20      54.834  48.043  92.260  1.00 27.08           C  
ATOM   1717  ND1 HIS B  20      54.106  48.282  93.406  1.00 29.12           N  
ATOM   1718  CD2 HIS B  20      55.727  47.082  92.574  1.00 20.78           C  
ATOM   1719  CE1 HIS B  20      54.532  47.485  94.367  1.00 34.52           C  
ATOM   1720  NE2 HIS B  20      55.526  46.759  93.891  1.00 28.47           N  
HETATM 1721  N   MSE B  21      52.602  49.798  88.577  1.00 28.83           N  
HETATM 1722  CA  MSE B  21      52.612  50.555  87.330  1.00 28.09           C  
HETATM 1723  C   MSE B  21      51.579  51.663  87.245  1.00 27.69           C  
HETATM 1724  O   MSE B  21      51.588  52.448  86.296  1.00 27.37           O  
HETATM 1725  CB  MSE B  21      52.343  49.622  86.173  1.00 27.62           C  
HETATM 1726  CG  MSE B  21      53.372  48.570  85.934  1.00 26.43           C  
HETATM 1727 SE   MSE B  21      55.109  49.202  85.568  0.75 24.10          SE  
HETATM 1728  CE  MSE B  21      54.785  50.495  84.194  1.00 33.68           C  
HETATM 1729  N   MSE B  22      50.676  51.724  88.216  1.00 27.47           N  
HETATM 1730  CA  MSE B  22      49.485  52.541  88.091  1.00 27.17           C  
HETATM 1731  C   MSE B  22      48.875  52.956  89.424  1.00 29.31           C  
HETATM 1732  O   MSE B  22      49.087  52.328  90.449  1.00 31.04           O  
HETATM 1733  CB  MSE B  22      48.400  51.786  87.278  1.00 27.55           C  
HETATM 1734  CG  MSE B  22      47.864  50.538  87.918  1.00 30.32           C  
HETATM 1735 SE   MSE B  22      46.898  49.439  86.661  0.75 25.56          SE  
HETATM 1736  CE  MSE B  22      48.615  48.770  85.468  1.00 22.03           C  
ATOM   1737  N   SER B  23      48.016  53.957  89.351  1.00 32.52           N  
ATOM   1738  CA  SER B  23      47.214  54.403  90.487  1.00 32.48           C  
ATOM   1739  C   SER B  23      46.221  53.345  91.019  1.00 32.44           C  
ATOM   1740  O   SER B  23      45.830  52.412  90.302  1.00 33.68           O  
ATOM   1741  CB  SER B  23      46.423  55.629  90.064  1.00 32.61           C  
ATOM   1742  OG  SER B  23      45.418  55.266  89.143  1.00 36.35           O  
ATOM   1743  N   ASP B  24      45.776  53.511  92.264  1.00 31.52           N  
ATOM   1744  CA  ASP B  24      44.856  52.532  92.872  1.00 33.19           C  
ATOM   1745  C   ASP B  24      43.574  52.349  92.090  1.00 32.87           C  
ATOM   1746  O   ASP B  24      43.063  51.218  91.949  1.00 30.75           O  
ATOM   1747  CB  ASP B  24      44.552  52.890  94.328  1.00 34.77           C  
ATOM   1748  CG  ASP B  24      45.723  52.557  95.254  1.00 44.34           C  
ATOM   1749  OD1 ASP B  24      46.616  51.781  94.828  1.00 42.63           O  
ATOM   1750  OD2 ASP B  24      45.750  53.061  96.412  1.00 58.22           O  
ATOM   1751  N   LYS B  25      43.048  53.464  91.602  1.00 31.36           N  
ATOM   1752  CA  LYS B  25      41.809  53.473  90.864  1.00 33.24           C  
ATOM   1753  C   LYS B  25      41.920  52.630  89.564  1.00 31.23           C  
ATOM   1754  O   LYS B  25      40.998  51.897  89.188  1.00 27.66           O  
ATOM   1755  CB  LYS B  25      41.492  54.928  90.583  1.00 34.34           C  
ATOM   1756  CG  LYS B  25      40.115  55.209  90.061  1.00 45.95           C  
ATOM   1757  CD  LYS B  25      39.789  56.721  90.186  1.00 52.86           C  
ATOM   1758  CE  LYS B  25      39.486  57.163  91.633  1.00 59.43           C  
ATOM   1759  NZ  LYS B  25      39.035  58.596  91.707  1.00 57.63           N  
ATOM   1760  N   ARG B  26      43.068  52.732  88.904  1.00 28.59           N  
ATOM   1761  CA  ARG B  26      43.330  51.979  87.684  1.00 30.69           C  
ATOM   1762  C   ARG B  26      43.524  50.506  87.991  1.00 28.17           C  
ATOM   1763  O   ARG B  26      43.089  49.676  87.238  1.00 27.73           O  
ATOM   1764  CB  ARG B  26      44.568  52.517  86.967  1.00 30.95           C  
ATOM   1765  CG  ARG B  26      44.277  53.284  85.718  1.00 44.02           C  
ATOM   1766  CD  ARG B  26      43.509  54.537  86.048  1.00 48.03           C  
ATOM   1767  NE  ARG B  26      43.306  55.443  84.911  1.00 49.91           N  
ATOM   1768  CZ  ARG B  26      44.207  56.285  84.422  1.00 44.58           C  
ATOM   1769  NH1 ARG B  26      45.431  56.346  84.899  1.00 49.17           N  
ATOM   1770  NH2 ARG B  26      43.876  57.077  83.421  1.00 54.26           N  
ATOM   1771  N   PHE B  27      44.205  50.209  89.089  1.00 30.25           N  
ATOM   1772  CA  PHE B  27      44.455  48.853  89.496  1.00 29.61           C  
ATOM   1773  C   PHE B  27      43.161  48.186  89.815  1.00 29.37           C  
ATOM   1774  O   PHE B  27      42.972  47.014  89.452  1.00 26.69           O  
ATOM   1775  CB  PHE B  27      45.398  48.788  90.712  1.00 30.37           C  
ATOM   1776  CG  PHE B  27      45.768  47.372  91.100  1.00 29.24           C  
ATOM   1777  CD1 PHE B  27      46.442  46.558  90.201  1.00 29.50           C  
ATOM   1778  CD2 PHE B  27      45.415  46.848  92.342  1.00 30.03           C  
ATOM   1779  CE1 PHE B  27      46.775  45.240  90.530  1.00 31.45           C  
ATOM   1780  CE2 PHE B  27      45.743  45.552  92.672  1.00 28.86           C  
ATOM   1781  CZ  PHE B  27      46.431  44.745  91.748  1.00 30.88           C  
ATOM   1782  N   ASN B  28      42.268  48.890  90.521  1.00 28.18           N  
ATOM   1783  CA  ASN B  28      40.921  48.338  90.733  1.00 28.35           C  
ATOM   1784  C   ASN B  28      40.175  48.074  89.415  1.00 27.35           C  
ATOM   1785  O   ASN B  28      39.437  47.125  89.308  1.00 24.93           O  
ATOM   1786  CB  ASN B  28      40.073  49.242  91.640  1.00 28.34           C  
ATOM   1787  CG  ASN B  28      40.491  49.153  93.071  1.00 37.50           C  
ATOM   1788  OD1 ASN B  28      40.697  48.043  93.604  1.00 44.88           O  
ATOM   1789  ND2 ASN B  28      40.609  50.306  93.730  1.00 34.70           N  
ATOM   1790  N   HIS B  29      40.355  48.945  88.434  1.00 26.94           N  
ATOM   1791  CA  HIS B  29      39.786  48.734  87.107  1.00 25.34           C  
ATOM   1792  C   HIS B  29      40.330  47.436  86.539  1.00 26.05           C  
ATOM   1793  O   HIS B  29      39.572  46.598  86.047  1.00 26.56           O  
ATOM   1794  CB  HIS B  29      40.104  49.931  86.175  1.00 28.86           C  
ATOM   1795  CG  HIS B  29      39.953  49.622  84.714  1.00 24.75           C  
ATOM   1796  ND1 HIS B  29      38.723  49.367  84.143  1.00 25.08           N  
ATOM   1797  CD2 HIS B  29      40.865  49.504  83.719  1.00 27.34           C  
ATOM   1798  CE1 HIS B  29      38.891  49.108  82.861  1.00 31.87           C  
ATOM   1799  NE2 HIS B  29      40.179  49.175  82.581  1.00 21.90           N  
ATOM   1800  N   VAL B  30      41.640  47.269  86.588  1.00 27.73           N  
ATOM   1801  CA  VAL B  30      42.277  46.095  86.009  1.00 29.07           C  
ATOM   1802  C   VAL B  30      41.812  44.787  86.675  1.00 28.78           C  
ATOM   1803  O   VAL B  30      41.669  43.786  85.980  1.00 26.56           O  
ATOM   1804  CB  VAL B  30      43.820  46.228  86.038  1.00 28.97           C  
ATOM   1805  CG1 VAL B  30      44.469  44.925  85.838  1.00 35.08           C  
ATOM   1806  CG2 VAL B  30      44.282  47.221  85.022  1.00 33.86           C  
ATOM   1807  N   LEU B  31      41.627  44.796  88.004  1.00 26.19           N  
ATOM   1808  CA  LEU B  31      41.072  43.642  88.722  1.00 26.24           C  
ATOM   1809  C   LEU B  31      39.661  43.352  88.227  1.00 25.80           C  
ATOM   1810  O   LEU B  31      39.299  42.210  88.033  1.00 24.63           O  
ATOM   1811  CB  LEU B  31      40.996  43.892  90.238  1.00 25.91           C  
ATOM   1812  CG  LEU B  31      42.352  43.921  90.948  1.00 27.87           C  
ATOM   1813  CD1 LEU B  31      42.137  44.255  92.441  1.00 30.25           C  
ATOM   1814  CD2 LEU B  31      43.109  42.608  90.763  1.00 32.49           C  
ATOM   1815  N   GLY B  32      38.887  44.405  88.032  1.00 23.46           N  
ATOM   1816  CA  GLY B  32      37.548  44.290  87.461  1.00 24.57           C  
ATOM   1817  C   GLY B  32      37.552  43.683  86.081  1.00 24.86           C  
ATOM   1818  O   GLY B  32      36.687  42.890  85.747  1.00 26.12           O  
ATOM   1819  N   VAL B  33      38.502  44.106  85.248  1.00 26.44           N  
ATOM   1820  CA  VAL B  33      38.621  43.513  83.907  1.00 25.28           C  
ATOM   1821  C   VAL B  33      39.042  42.014  83.961  1.00 26.13           C  
ATOM   1822  O   VAL B  33      38.473  41.175  83.262  1.00 26.96           O  
ATOM   1823  CB  VAL B  33      39.590  44.326  83.022  1.00 21.11           C  
ATOM   1824  CG1 VAL B  33      39.711  43.698  81.626  1.00 24.07           C  
ATOM   1825  CG2 VAL B  33      39.097  45.736  82.877  1.00 22.15           C  
ATOM   1826  N   GLU B  34      39.987  41.684  84.828  1.00 25.99           N  
ATOM   1827  CA  GLU B  34      40.360  40.298  85.041  1.00 27.20           C  
ATOM   1828  C   GLU B  34      39.118  39.459  85.402  1.00 28.26           C  
ATOM   1829  O   GLU B  34      38.897  38.386  84.792  1.00 28.37           O  
ATOM   1830  CB  GLU B  34      41.476  40.175  86.092  1.00 24.22           C  
ATOM   1831  CG  GLU B  34      41.995  38.732  86.265  1.00 24.62           C  
ATOM   1832  CD  GLU B  34      42.824  38.487  87.510  1.00 27.93           C  
ATOM   1833  OE1 GLU B  34      42.664  39.181  88.519  1.00 34.98           O  
ATOM   1834  OE2 GLU B  34      43.664  37.586  87.486  1.00 29.84           O  
ATOM   1835  N   ARG B  35      38.332  39.955  86.363  1.00 26.66           N  
ATOM   1836  CA  ARG B  35      37.097  39.305  86.800  0.70 29.54           C  
ATOM   1838  C   ARG B  35      36.095  39.120  85.661  1.00 27.10           C  
ATOM   1839  O   ARG B  35      35.533  38.058  85.508  1.00 24.08           O  
ATOM   1840  CB  ARG B  35      36.424  40.074  87.943  0.70 30.62           C  
ATOM   1842  CG  ARG B  35      35.133  39.411  88.475  0.70 38.98           C  
ATOM   1844  CD  ARG B  35      34.437  40.221  89.607  0.70 40.39           C  
ATOM   1846  NE  ARG B  35      33.058  40.580  89.266  0.70 45.50           N  
ATOM   1848  CZ  ARG B  35      32.272  41.344  90.010  0.70 48.10           C  
ATOM   1850  NH1 ARG B  35      32.712  41.825  91.171  0.70 49.93           N  
ATOM   1852  NH2 ARG B  35      31.048  41.634  89.575  0.70 36.45           N  
ATOM   1854  N   ALA B  36      35.907  40.163  84.883  1.00 23.14           N  
ATOM   1855  CA  ALA B  36      34.976  40.145  83.775  1.00 24.94           C  
ATOM   1856  C   ALA B  36      35.435  39.285  82.648  1.00 23.08           C  
ATOM   1857  O   ALA B  36      34.616  38.640  82.036  1.00 24.10           O  
ATOM   1858  CB  ALA B  36      34.660  41.553  83.305  1.00 22.85           C  
ATOM   1859  N   ALA B  37      36.746  39.210  82.398  1.00 23.06           N  
ATOM   1860  CA  ALA B  37      37.256  38.415  81.338  1.00 24.35           C  
ATOM   1861  C   ALA B  37      37.169  36.923  81.667  1.00 26.84           C  
ATOM   1862  O   ALA B  37      36.895  36.109  80.786  1.00 24.37           O  
ATOM   1863  CB  ALA B  37      38.701  38.792  81.042  1.00 23.23           C  
ATOM   1864  N   ILE B  38      37.401  36.574  82.927  1.00 26.11           N  
ATOM   1865  CA  ILE B  38      37.217  35.200  83.378  1.00 27.07           C  
ATOM   1866  C   ILE B  38      35.739  34.781  83.244  1.00 26.72           C  
ATOM   1867  O   ILE B  38      35.429  33.698  82.729  1.00 24.23           O  
ATOM   1868  CB  ILE B  38      37.794  35.011  84.818  1.00 22.65           C  
ATOM   1869  CG1 ILE B  38      39.321  35.205  84.772  1.00 25.51           C  
ATOM   1870  CG2 ILE B  38      37.490  33.628  85.332  1.00 28.11           C  
ATOM   1871  CD1 ILE B  38      39.999  35.370  86.146  1.00 31.73           C  
ATOM   1872  N   GLU B  39      34.803  35.630  83.649  1.00 26.75           N  
ATOM   1873  CA  GLU B  39      33.387  35.321  83.433  1.00 28.03           C  
ATOM   1874  C   GLU B  39      33.022  35.145  81.934  1.00 26.97           C  
ATOM   1875  O   GLU B  39      32.233  34.277  81.600  1.00 25.61           O  
ATOM   1876  CB  GLU B  39      32.438  36.383  84.032  1.00 28.34           C  
ATOM   1877  CG  GLU B  39      32.471  36.575  85.548  1.00 36.33           C  
ATOM   1878  CD  GLU B  39      32.022  38.009  86.014  1.00 39.01           C  
ATOM   1879  OE1 GLU B  39      31.688  38.863  85.149  1.00 43.60           O  
ATOM   1880  OE2 GLU B  39      32.036  38.275  87.233  1.00 47.91           O  
ATOM   1881  N   LEU B  40      33.567  36.016  81.062  1.00 25.91           N  
ATOM   1882  CA  LEU B  40      33.346  35.910  79.616  1.00 25.44           C  
ATOM   1883  C   LEU B  40      33.991  34.647  79.055  1.00 24.59           C  
ATOM   1884  O   LEU B  40      33.449  34.063  78.146  1.00 24.91           O  
ATOM   1885  CB  LEU B  40      33.892  37.159  78.874  1.00 25.47           C  
ATOM   1886  CG  LEU B  40      33.113  38.455  79.115  1.00 27.49           C  
ATOM   1887  CD1 LEU B  40      33.740  39.601  78.348  1.00 22.03           C  
ATOM   1888  CD2 LEU B  40      31.655  38.319  78.698  1.00 28.15           C  
ATOM   1889  N   ALA B  41      35.164  34.272  79.559  1.00 24.85           N  
ATOM   1890  CA  ALA B  41      35.809  33.046  79.142  1.00 25.62           C  
ATOM   1891  C   ALA B  41      34.958  31.856  79.475  1.00 24.77           C  
ATOM   1892  O   ALA B  41      34.736  31.025  78.620  1.00 24.45           O  
ATOM   1893  CB  ALA B  41      37.235  32.908  79.718  1.00 24.79           C  
ATOM   1894  N   GLU B  42      34.418  31.782  80.691  1.00 23.29           N  
ATOM   1895  CA  GLU B  42      33.498  30.686  81.054  1.00 25.27           C  
ATOM   1896  C   GLU B  42      32.251  30.669  80.165  1.00 25.85           C  
ATOM   1897  O   GLU B  42      31.821  29.605  79.668  1.00 22.07           O  
ATOM   1898  CB  GLU B  42      33.083  30.817  82.552  1.00 25.42           C  
ATOM   1899  CG  GLU B  42      34.208  30.405  83.467  1.00 27.94           C  
ATOM   1900  CD  GLU B  42      33.891  30.574  84.963  1.00 29.54           C  
ATOM   1901  OE1 GLU B  42      33.150  31.507  85.324  1.00 41.95           O  
ATOM   1902  OE2 GLU B  42      34.416  29.792  85.764  1.00 34.30           O  
ATOM   1903  N   ARG B  43      31.682  31.856  79.965  1.00 23.26           N  
ATOM   1904  CA  ARG B  43      30.460  32.015  79.176  1.00 23.36           C  
ATOM   1905  C   ARG B  43      30.625  31.505  77.730  1.00 24.18           C  
ATOM   1906  O   ARG B  43      29.715  30.900  77.183  1.00 22.53           O  
ATOM   1907  CB  ARG B  43      30.003  33.470  79.133  1.00 25.21           C  
ATOM   1908  CG  ARG B  43      28.624  33.683  78.400  1.00 25.98           C  
ATOM   1909  CD  ARG B  43      28.109  35.132  78.584  1.00 25.10           C  
ATOM   1910  NE  ARG B  43      27.942  35.350  80.021  1.00 23.49           N  
ATOM   1911  CZ  ARG B  43      28.166  36.492  80.680  1.00 26.45           C  
ATOM   1912  NH1 ARG B  43      28.499  37.578  80.060  1.00 27.33           N  
ATOM   1913  NH2 ARG B  43      27.985  36.532  81.991  1.00 31.89           N  
ATOM   1914  N   TYR B  44      31.791  31.753  77.145  1.00 25.69           N  
ATOM   1915  CA  TYR B  44      32.016  31.556  75.709  1.00 26.62           C  
ATOM   1916  C   TYR B  44      33.070  30.474  75.431  1.00 26.62           C  
ATOM   1917  O   TYR B  44      33.625  30.428  74.321  1.00 28.63           O  
ATOM   1918  CB  TYR B  44      32.393  32.908  75.026  1.00 24.81           C  
ATOM   1919  CG  TYR B  44      31.227  33.848  75.031  1.00 24.28           C  
ATOM   1920  CD1 TYR B  44      30.059  33.513  74.364  1.00 26.40           C  
ATOM   1921  CD2 TYR B  44      31.237  35.034  75.787  1.00 23.65           C  
ATOM   1922  CE1 TYR B  44      28.941  34.348  74.414  1.00 23.06           C  
ATOM   1923  CE2 TYR B  44      30.110  35.879  75.838  1.00 25.37           C  
ATOM   1924  CZ  TYR B  44      28.975  35.516  75.142  1.00 28.59           C  
ATOM   1925  OH  TYR B  44      27.849  36.287  75.183  1.00 24.99           O  
ATOM   1926  N   GLY B  45      33.351  29.623  76.434  1.00 24.68           N  
ATOM   1927  CA  GLY B  45      34.120  28.411  76.222  1.00 25.59           C  
ATOM   1928  C   GLY B  45      35.587  28.635  75.944  1.00 28.15           C  
ATOM   1929  O   GLY B  45      36.232  27.837  75.297  1.00 28.16           O  
ATOM   1930  N   TYR B  46      36.115  29.720  76.472  1.00 25.30           N  
ATOM   1931  CA  TYR B  46      37.507  30.078  76.243  1.00 25.37           C  
ATOM   1932  C   TYR B  46      38.367  29.825  77.474  1.00 27.44           C  
ATOM   1933  O   TYR B  46      37.860  29.816  78.596  1.00 28.04           O  
ATOM   1934  CB  TYR B  46      37.591  31.543  75.778  1.00 24.17           C  
ATOM   1935  CG  TYR B  46      38.911  31.852  75.150  1.00 20.77           C  
ATOM   1936  CD1 TYR B  46      39.169  31.518  73.819  1.00 27.36           C  
ATOM   1937  CD2 TYR B  46      39.949  32.376  75.923  1.00 25.30           C  
ATOM   1938  CE1 TYR B  46      40.417  31.738  73.268  1.00 30.48           C  
ATOM   1939  CE2 TYR B  46      41.191  32.571  75.392  1.00 25.66           C  
ATOM   1940  CZ  TYR B  46      41.406  32.274  74.068  1.00 28.25           C  
ATOM   1941  OH  TYR B  46      42.639  32.517  73.547  1.00 34.36           O  
ATOM   1942  N   ASP B  47      39.668  29.577  77.244  1.00 27.65           N  
ATOM   1943  CA  ASP B  47      40.679  29.334  78.294  1.00 30.35           C  
ATOM   1944  C   ASP B  47      40.732  30.489  79.301  1.00 29.53           C  
ATOM   1945  O   ASP B  47      41.172  31.607  78.971  1.00 26.42           O  
ATOM   1946  CB  ASP B  47      42.054  29.180  77.641  1.00 30.82           C  
ATOM   1947  CG  ASP B  47      43.200  28.859  78.622  1.00 32.03           C  
ATOM   1948  OD1 ASP B  47      43.390  29.497  79.661  1.00 38.17           O  
ATOM   1949  OD2 ASP B  47      43.984  27.982  78.282  1.00 42.75           O  
ATOM   1950  N   LYS B  48      40.331  30.194  80.526  1.00 28.60           N  
ATOM   1951  CA  LYS B  48      40.191  31.229  81.550  1.00 30.91           C  
ATOM   1952  C   LYS B  48      41.501  31.850  81.956  1.00 25.72           C  
ATOM   1953  O   LYS B  48      41.530  33.021  82.383  1.00 25.25           O  
ATOM   1954  CB  LYS B  48      39.526  30.687  82.816  1.00 32.29           C  
ATOM   1955  CG  LYS B  48      38.096  30.116  82.574  1.00 39.46           C  
ATOM   1956  CD  LYS B  48      37.677  29.070  83.624  1.00 38.54           C  
ATOM   1957  CE  LYS B  48      37.709  29.688  85.022  1.00 43.96           C  
ATOM   1958  NZ  LYS B  48      36.780  28.981  85.927  1.00 44.20           N  
ATOM   1959  N   GLU B  49      42.578  31.062  81.935  1.00 27.38           N  
ATOM   1960  CA  GLU B  49      43.878  31.580  82.304  1.00 30.55           C  
ATOM   1961  C   GLU B  49      44.405  32.634  81.318  1.00 30.76           C  
ATOM   1962  O   GLU B  49      44.963  33.670  81.728  1.00 29.47           O  
ATOM   1963  CB  GLU B  49      44.933  30.456  82.403  1.00 29.54           C  
ATOM   1964  CG  GLU B  49      44.520  29.281  83.280  1.00 38.75           C  
ATOM   1965  CD  GLU B  49      44.235  29.713  84.697  1.00 45.58           C  
ATOM   1966  OE1 GLU B  49      44.842  30.718  85.114  1.00 47.28           O  
ATOM   1967  OE2 GLU B  49      43.420  29.066  85.387  1.00 51.61           O  
ATOM   1968  N   LYS B  50      44.308  32.332  80.023  1.00 32.43           N  
ATOM   1969  CA  LYS B  50      44.716  33.253  78.980  1.00 32.88           C  
ATOM   1970  C   LYS B  50      43.918  34.512  79.073  1.00 29.49           C  
ATOM   1971  O   LYS B  50      44.475  35.597  78.977  1.00 29.56           O  
ATOM   1972  CB  LYS B  50      44.520  32.661  77.572  1.00 34.23           C  
ATOM   1973  CG  LYS B  50      45.620  31.800  77.092  1.00 35.49           C  
ATOM   1974  CD  LYS B  50      45.322  31.224  75.703  1.00 35.24           C  
ATOM   1975  CE  LYS B  50      45.976  32.019  74.602  1.00 38.56           C  
ATOM   1976  NZ  LYS B  50      46.099  31.210  73.335  1.00 38.12           N  
ATOM   1977  N   ALA B  51      42.596  34.372  79.232  1.00 27.14           N  
ATOM   1978  CA  ALA B  51      41.724  35.547  79.321  1.00 27.21           C  
ATOM   1979  C   ALA B  51      42.037  36.416  80.537  1.00 26.01           C  
ATOM   1980  O   ALA B  51      42.159  37.636  80.424  1.00 28.98           O  
ATOM   1981  CB  ALA B  51      40.269  35.124  79.356  1.00 25.27           C  
ATOM   1982  N   GLY B  52      42.175  35.777  81.701  1.00 25.61           N  
ATOM   1983  CA  GLY B  52      42.500  36.482  82.946  1.00 23.40           C  
ATOM   1984  C   GLY B  52      43.859  37.202  82.889  1.00 25.10           C  
ATOM   1985  O   GLY B  52      43.987  38.320  83.343  1.00 25.76           O  
ATOM   1986  N   LEU B  53      44.841  36.532  82.333  1.00 24.43           N  
ATOM   1987  CA  LEU B  53      46.174  37.102  82.168  1.00 27.59           C  
ATOM   1988  C   LEU B  53      46.204  38.297  81.209  1.00 28.69           C  
ATOM   1989  O   LEU B  53      46.789  39.351  81.526  1.00 24.87           O  
ATOM   1990  CB  LEU B  53      47.158  36.024  81.733  1.00 28.92           C  
ATOM   1991  CG  LEU B  53      48.624  36.483  81.722  1.00 24.78           C  
ATOM   1992  CD1 LEU B  53      48.973  37.269  83.036  1.00 24.54           C  
ATOM   1993  CD2 LEU B  53      49.542  35.334  81.492  1.00 32.22           C  
ATOM   1994  N   ALA B  54      45.591  38.149  80.039  1.00 29.15           N  
ATOM   1995  CA  ALA B  54      45.506  39.268  79.113  1.00 29.46           C  
ATOM   1996  C   ALA B  54      44.802  40.454  79.767  1.00 27.08           C  
ATOM   1997  O   ALA B  54      45.215  41.621  79.608  1.00 26.52           O  
ATOM   1998  CB  ALA B  54      44.791  38.860  77.839  1.00 32.09           C  
ATOM   1999  N   ALA B  55      43.709  40.183  80.469  1.00 26.69           N  
ATOM   2000  CA  ALA B  55      43.000  41.228  81.176  1.00 29.03           C  
ATOM   2001  C   ALA B  55      43.819  41.891  82.278  1.00 29.29           C  
ATOM   2002  O   ALA B  55      43.753  43.087  82.456  1.00 29.17           O  
ATOM   2003  CB  ALA B  55      41.705  40.683  81.724  1.00 30.39           C  
ATOM   2004  N   LEU B  56      44.583  41.104  83.018  1.00 30.58           N  
ATOM   2005  CA  LEU B  56      45.373  41.665  84.116  1.00 32.07           C  
ATOM   2006  C   LEU B  56      46.457  42.609  83.587  1.00 29.55           C  
ATOM   2007  O   LEU B  56      46.799  43.608  84.212  1.00 33.73           O  
ATOM   2008  CB  LEU B  56      45.983  40.540  84.938  1.00 33.34           C  
ATOM   2009  CG  LEU B  56      46.760  40.939  86.189  1.00 36.28           C  
ATOM   2010  CD1 LEU B  56      45.826  41.667  87.137  1.00 34.35           C  
ATOM   2011  CD2 LEU B  56      47.302  39.679  86.805  1.00 36.76           C  
ATOM   2012  N   LEU B  57      46.996  42.272  82.430  1.00 26.08           N  
ATOM   2013  CA  LEU B  57      48.069  43.000  81.821  1.00 25.08           C  
ATOM   2014  C   LEU B  57      47.629  44.081  80.834  1.00 28.78           C  
ATOM   2015  O   LEU B  57      48.483  44.832  80.371  1.00 25.28           O  
ATOM   2016  CB  LEU B  57      49.024  42.055  81.103  1.00 25.72           C  
ATOM   2017  CG  LEU B  57      49.813  41.057  81.935  1.00 31.83           C  
ATOM   2018  CD1 LEU B  57      50.702  40.182  81.047  1.00 32.24           C  
ATOM   2019  CD2 LEU B  57      50.659  41.784  82.986  1.00 29.32           C  
ATOM   2020  N   HIS B  58      46.341  44.215  80.512  1.00 28.18           N  
ATOM   2021  CA  HIS B  58      45.976  44.998  79.313  1.00 28.10           C  
ATOM   2022  C   HIS B  58      46.358  46.461  79.431  1.00 28.49           C  
ATOM   2023  O   HIS B  58      46.696  47.082  78.427  1.00 28.07           O  
ATOM   2024  CB  HIS B  58      44.487  44.850  78.937  1.00 27.70           C  
ATOM   2025  CG  HIS B  58      43.569  45.667  79.784  1.00 27.14           C  
ATOM   2026  ND1 HIS B  58      43.247  45.312  81.082  1.00 28.90           N  
ATOM   2027  CD2 HIS B  58      42.907  46.816  79.528  1.00 26.70           C  
ATOM   2028  CE1 HIS B  58      42.465  46.237  81.597  1.00 23.50           C  
ATOM   2029  NE2 HIS B  58      42.232  47.160  80.676  1.00 28.81           N  
ATOM   2030  N   ASP B  59      46.266  47.010  80.655  1.00 27.75           N  
ATOM   2031  CA  ASP B  59      46.597  48.424  80.904  1.00 27.36           C  
ATOM   2032  C   ASP B  59      47.900  48.589  81.661  1.00 28.91           C  
ATOM   2033  O   ASP B  59      48.144  49.635  82.254  1.00 30.21           O  
ATOM   2034  CB  ASP B  59      45.462  49.120  81.656  1.00 24.75           C  
ATOM   2035  CG  ASP B  59      44.375  49.624  80.750  1.00 32.24           C  
ATOM   2036  OD1 ASP B  59      44.645  49.915  79.559  1.00 32.82           O  
ATOM   2037  OD2 ASP B  59      43.247  49.741  81.254  1.00 23.80           O  
ATOM   2038  N   TYR B  60      48.768  47.587  81.585  1.00 28.41           N  
ATOM   2039  CA  TYR B  60      50.081  47.645  82.223  1.00 26.95           C  
ATOM   2040  C   TYR B  60      50.772  48.969  81.974  1.00 26.78           C  
ATOM   2041  O   TYR B  60      51.351  49.513  82.889  1.00 27.67           O  
ATOM   2042  CB  TYR B  60      50.905  46.478  81.737  1.00 25.08           C  
ATOM   2043  CG  TYR B  60      52.236  46.243  82.440  1.00 28.19           C  
ATOM   2044  CD1 TYR B  60      53.384  46.859  82.025  1.00 29.51           C  
ATOM   2045  CD2 TYR B  60      52.322  45.343  83.504  1.00 33.09           C  
ATOM   2046  CE1 TYR B  60      54.602  46.600  82.666  1.00 19.27           C  
ATOM   2047  CE2 TYR B  60      53.500  45.094  84.134  1.00 23.32           C  
ATOM   2048  CZ  TYR B  60      54.631  45.721  83.727  1.00 30.84           C  
ATOM   2049  OH  TYR B  60      55.791  45.419  84.384  1.00 32.84           O  
ATOM   2050  N   ALA B  61      50.661  49.509  80.755  1.00 28.57           N  
ATOM   2051  CA  ALA B  61      51.351  50.736  80.344  1.00 26.99           C  
ATOM   2052  C   ALA B  61      50.499  52.010  80.322  1.00 25.83           C  
ATOM   2053  O   ALA B  61      50.895  53.009  79.778  1.00 27.97           O  
ATOM   2054  CB  ALA B  61      51.993  50.514  78.992  1.00 25.94           C  
ATOM   2055  N   LYS B  62      49.308  51.966  80.912  1.00 29.52           N  
ATOM   2056  CA  LYS B  62      48.379  53.117  80.886  1.00 29.95           C  
ATOM   2057  C   LYS B  62      48.984  54.442  81.364  1.00 31.26           C  
ATOM   2058  O   LYS B  62      48.694  55.504  80.814  1.00 32.19           O  
ATOM   2059  CB  LYS B  62      47.169  52.771  81.774  1.00 30.39           C  
ATOM   2060  CG  LYS B  62      46.016  53.793  81.826  1.00 33.83           C  
ATOM   2061  CD  LYS B  62      45.351  53.924  80.496  1.00 28.66           C  
ATOM   2062  CE  LYS B  62      44.176  54.887  80.536  1.00 30.78           C  
ATOM   2063  NZ  LYS B  62      43.319  54.899  79.331  1.00 30.61           N  
ATOM   2064  N   GLU B  63      49.830  54.372  82.390  1.00 29.86           N  
ATOM   2065  CA  GLU B  63      50.413  55.574  83.020  1.00 30.49           C  
ATOM   2066  C   GLU B  63      51.900  55.762  82.703  1.00 29.97           C  
ATOM   2067  O   GLU B  63      52.592  56.517  83.386  1.00 29.34           O  
ATOM   2068  CB  GLU B  63      50.173  55.571  84.553  1.00 31.18           C  
ATOM   2069  CG  GLU B  63      48.679  55.424  84.883  1.00 31.00           C  
ATOM   2070  CD  GLU B  63      48.345  55.478  86.363  1.00 34.41           C  
ATOM   2071  OE1 GLU B  63      49.228  55.814  87.162  1.00 28.15           O  
ATOM   2072  OE2 GLU B  63      47.182  55.157  86.735  1.00 31.24           O  
ATOM   2073  N   LEU B  64      52.403  55.135  81.644  1.00 28.45           N  
ATOM   2074  CA  LEU B  64      53.735  55.518  81.187  1.00 27.63           C  
ATOM   2075  C   LEU B  64      53.698  56.954  80.689  1.00 29.03           C  
ATOM   2076  O   LEU B  64      52.672  57.441  80.216  1.00 28.81           O  
ATOM   2077  CB  LEU B  64      54.269  54.642  80.059  1.00 29.08           C  
ATOM   2078  CG  LEU B  64      54.519  53.137  80.137  1.00 33.49           C  
ATOM   2079  CD1 LEU B  64      55.455  52.752  78.970  1.00 33.08           C  
ATOM   2080  CD2 LEU B  64      55.077  52.658  81.476  1.00 31.71           C  
ATOM   2081  N   SER B  65      54.855  57.609  80.789  1.00 30.19           N  
ATOM   2082  CA  SER B  65      55.028  58.961  80.304  1.00 30.93           C  
ATOM   2083  C   SER B  65      55.037  58.960  78.780  1.00 30.15           C  
ATOM   2084  O   SER B  65      55.393  57.953  78.147  1.00 28.39           O  
ATOM   2085  CB  SER B  65      56.348  59.545  80.818  1.00 29.86           C  
ATOM   2086  OG  SER B  65      57.458  58.940  80.173  1.00 39.49           O  
ATOM   2087  N   ASP B  66      54.656  60.099  78.204  1.00 30.99           N  
ATOM   2088  CA  ASP B  66      54.690  60.276  76.768  1.00 33.87           C  
ATOM   2089  C   ASP B  66      56.078  59.987  76.241  1.00 32.07           C  
ATOM   2090  O   ASP B  66      56.244  59.331  75.207  1.00 34.93           O  
ATOM   2091  CB  ASP B  66      54.275  61.700  76.375  1.00 35.47           C  
ATOM   2092  CG  ASP B  66      52.770  61.955  76.529  1.00 36.90           C  
ATOM   2093  OD1 ASP B  66      51.969  61.017  76.713  1.00 36.32           O  
ATOM   2094  OD2 ASP B  66      52.382  63.133  76.471  1.00 43.39           O  
ATOM   2095  N   ASP B  67      57.084  60.484  76.956  1.00 34.37           N  
ATOM   2096  CA  ASP B  67      58.479  60.243  76.589  1.00 33.55           C  
ATOM   2097  C   ASP B  67      58.863  58.764  76.603  1.00 30.70           C  
ATOM   2098  O   ASP B  67      59.603  58.328  75.729  1.00 28.42           O  
ATOM   2099  CB  ASP B  67      59.432  61.041  77.484  1.00 32.15           C  
ATOM   2100  CG  ASP B  67      59.596  62.490  77.031  1.00 42.22           C  
ATOM   2101  OD1 ASP B  67      58.687  63.039  76.370  1.00 54.33           O  
ATOM   2102  OD2 ASP B  67      60.657  63.080  77.339  1.00 56.05           O  
ATOM   2103  N   GLU B  68      58.358  57.993  77.571  1.00 30.58           N  
ATOM   2104  CA  GLU B  68      58.660  56.556  77.592  1.00 30.93           C  
ATOM   2105  C   GLU B  68      58.125  55.913  76.307  1.00 27.25           C  
ATOM   2106  O   GLU B  68      58.808  55.101  75.700  1.00 24.89           O  
ATOM   2107  CB  GLU B  68      58.155  55.808  78.870  1.00 29.44           C  
ATOM   2108  CG  GLU B  68      59.125  54.619  79.230  1.00 37.42           C  
ATOM   2109  CD  GLU B  68      58.848  53.810  80.549  1.00 38.21           C  
ATOM   2110  OE1 GLU B  68      58.548  54.376  81.632  1.00 38.98           O  
ATOM   2111  OE2 GLU B  68      58.996  52.561  80.491  1.00 44.40           O  
ATOM   2112  N   PHE B  69      56.919  56.296  75.888  1.00 26.17           N  
ATOM   2113  CA  PHE B  69      56.313  55.748  74.675  1.00 26.52           C  
ATOM   2114  C   PHE B  69      57.016  56.075  73.406  1.00 26.46           C  
ATOM   2115  O   PHE B  69      57.138  55.230  72.532  1.00 26.39           O  
ATOM   2116  CB  PHE B  69      54.857  56.202  74.509  1.00 25.64           C  
ATOM   2117  CG  PHE B  69      53.912  55.468  75.372  1.00 26.89           C  
ATOM   2118  CD1 PHE B  69      53.742  54.121  75.199  1.00 30.10           C  
ATOM   2119  CD2 PHE B  69      53.191  56.121  76.350  1.00 27.03           C  
ATOM   2120  CE1 PHE B  69      52.881  53.440  75.992  1.00 21.48           C  
ATOM   2121  CE2 PHE B  69      52.294  55.442  77.148  1.00 28.29           C  
ATOM   2122  CZ  PHE B  69      52.168  54.100  76.994  1.00 29.30           C  
ATOM   2123  N   LEU B  70      57.459  57.314  73.292  1.00 29.83           N  
ATOM   2124  CA  LEU B  70      58.208  57.741  72.113  1.00 31.08           C  
ATOM   2125  C   LEU B  70      59.571  57.036  71.978  1.00 31.33           C  
ATOM   2126  O   LEU B  70      60.005  56.684  70.866  1.00 26.09           O  
ATOM   2127  CB  LEU B  70      58.416  59.254  72.157  1.00 30.76           C  
ATOM   2128  CG  LEU B  70      57.124  60.057  72.023  1.00 36.97           C  
ATOM   2129  CD1 LEU B  70      57.394  61.489  72.396  1.00 37.04           C  
ATOM   2130  CD2 LEU B  70      56.534  59.968  70.617  1.00 38.15           C  
ATOM   2131  N   ARG B  71      60.247  56.863  73.115  1.00 30.03           N  
ATOM   2132  CA  ARG B  71      61.418  56.026  73.170  1.00 32.22           C  
ATOM   2133  C   ARG B  71      61.137  54.609  72.707  1.00 30.75           C  
ATOM   2134  O   ARG B  71      61.937  54.055  71.950  1.00 32.31           O  
ATOM   2135  CB  ARG B  71      61.998  55.997  74.579  1.00 34.44           C  
ATOM   2136  CG  ARG B  71      62.729  57.237  74.929  1.00 37.49           C  
ATOM   2137  CD  ARG B  71      63.490  57.110  76.239  1.00 43.51           C  
ATOM   2138  NE  ARG B  71      64.456  58.198  76.317  1.00 48.33           N  
ATOM   2139  CZ  ARG B  71      64.140  59.475  76.534  1.00 55.09           C  
ATOM   2140  NH1 ARG B  71      62.867  59.839  76.707  1.00 63.65           N  
ATOM   2141  NH2 ARG B  71      65.099  60.402  76.587  1.00 53.94           N  
ATOM   2142  N   LEU B  72      60.029  54.032  73.170  1.00 31.02           N  
ATOM   2143  CA  LEU B  72      59.617  52.676  72.778  1.00 30.57           C  
ATOM   2144  C   LEU B  72      59.307  52.563  71.295  1.00 31.60           C  
ATOM   2145  O   LEU B  72      59.594  51.539  70.673  1.00 30.91           O  
ATOM   2146  CB  LEU B  72      58.405  52.213  73.586  1.00 29.94           C  
ATOM   2147  CG  LEU B  72      58.754  51.861  75.046  1.00 33.74           C  
ATOM   2148  CD1 LEU B  72      57.490  51.638  75.865  1.00 21.66           C  
ATOM   2149  CD2 LEU B  72      59.616  50.627  75.127  1.00 25.35           C  
ATOM   2150  N   ILE B  73      58.707  53.613  70.741  1.00 32.03           N  
ATOM   2151  CA  ILE B  73      58.388  53.629  69.332  1.00 30.73           C  
ATOM   2152  C   ILE B  73      59.681  53.668  68.544  1.00 31.32           C  
ATOM   2153  O   ILE B  73      59.854  52.867  67.636  1.00 31.88           O  
ATOM   2154  CB  ILE B  73      57.519  54.811  68.949  1.00 31.63           C  
ATOM   2155  CG1 ILE B  73      56.131  54.642  69.561  1.00 30.01           C  
ATOM   2156  CG2 ILE B  73      57.346  54.887  67.423  1.00 34.84           C  
ATOM   2157  CD1 ILE B  73      55.263  55.863  69.487  1.00 28.08           C  
ATOM   2158  N   ASP B  74      60.585  54.581  68.888  1.00 31.43           N  
ATOM   2159  CA  ASP B  74      61.876  54.624  68.200  1.00 33.43           C  
ATOM   2160  C   ASP B  74      62.566  53.277  68.280  1.00 34.14           C  
ATOM   2161  O   ASP B  74      62.992  52.718  67.265  1.00 36.11           O  
ATOM   2162  CB  ASP B  74      62.799  55.694  68.789  1.00 33.27           C  
ATOM   2163  CG  ASP B  74      62.329  57.110  68.483  1.00 38.40           C  
ATOM   2164  OD1 ASP B  74      61.446  57.267  67.616  1.00 45.09           O  
ATOM   2165  OD2 ASP B  74      62.844  58.066  69.101  1.00 44.62           O  
ATOM   2166  N   LYS B  75      62.687  52.772  69.499  1.00 33.15           N  
ATOM   2167  CA  LYS B  75      63.455  51.564  69.762  1.00 34.38           C  
ATOM   2168  C   LYS B  75      62.853  50.303  69.131  1.00 34.67           C  
ATOM   2169  O   LYS B  75      63.589  49.462  68.674  1.00 35.46           O  
ATOM   2170  CB  LYS B  75      63.607  51.399  71.279  1.00 34.65           C  
ATOM   2171  CG  LYS B  75      64.228  50.103  71.776  1.00 38.25           C  
ATOM   2172  CD  LYS B  75      64.276  50.099  73.312  1.00 38.08           C  
ATOM   2173  CE  LYS B  75      65.302  49.093  73.813  1.00 48.13           C  
ATOM   2174  NZ  LYS B  75      65.571  49.227  75.271  1.00 50.87           N  
ATOM   2175  N   TYR B  76      61.530  50.175  69.107  1.00 35.80           N  
ATOM   2176  CA  TYR B  76      60.889  48.898  68.720  1.00 38.45           C  
ATOM   2177  C   TYR B  76      60.025  48.906  67.491  1.00 41.73           C  
ATOM   2178  O   TYR B  76      59.818  47.841  66.898  1.00 44.41           O  
ATOM   2179  CB  TYR B  76      59.996  48.342  69.832  1.00 36.79           C  
ATOM   2180  CG  TYR B  76      60.761  47.866  71.006  1.00 35.55           C  
ATOM   2181  CD1 TYR B  76      61.727  46.867  70.879  1.00 31.27           C  
ATOM   2182  CD2 TYR B  76      60.563  48.434  72.239  1.00 32.78           C  
ATOM   2183  CE1 TYR B  76      62.466  46.461  71.976  1.00 33.22           C  
ATOM   2184  CE2 TYR B  76      61.291  48.045  73.325  1.00 36.00           C  
ATOM   2185  CZ  TYR B  76      62.226  47.056  73.205  1.00 34.68           C  
ATOM   2186  OH  TYR B  76      62.917  46.678  74.319  1.00 39.10           O  
ATOM   2187  N   GLN B  77      59.436  50.048  67.151  1.00 43.68           N  
ATOM   2188  CA  GLN B  77      58.495  50.065  66.038  1.00 43.48           C  
ATOM   2189  C   GLN B  77      58.413  51.422  65.393  1.00 41.41           C  
ATOM   2190  O   GLN B  77      57.346  52.053  65.413  1.00 42.08           O  
ATOM   2191  CB  GLN B  77      57.118  49.623  66.508  1.00 46.35           C  
ATOM   2192  CG  GLN B  77      56.180  49.261  65.353  1.00 53.16           C  
ATOM   2193  CD  GLN B  77      54.744  49.647  65.645  1.00 62.37           C  
ATOM   2194  OE1 GLN B  77      54.290  50.724  65.234  1.00 72.97           O  
ATOM   2195  NE2 GLN B  77      54.025  48.785  66.378  1.00 63.64           N  
ATOM   2196  N   PRO B  78      59.530  51.870  64.794  1.00 38.58           N  
ATOM   2197  CA  PRO B  78      59.602  53.215  64.216  1.00 39.69           C  
ATOM   2198  C   PRO B  78      58.427  53.496  63.270  1.00 42.38           C  
ATOM   2199  O   PRO B  78      58.264  52.796  62.259  1.00 42.47           O  
ATOM   2200  CB  PRO B  78      60.933  53.200  63.463  1.00 39.76           C  
ATOM   2201  CG  PRO B  78      61.737  52.183  64.149  1.00 36.68           C  
ATOM   2202  CD  PRO B  78      60.793  51.129  64.607  1.00 37.11           C  
ATOM   2203  N   ASP B  79      57.578  54.461  63.646  1.00 43.38           N  
ATOM   2204  CA  ASP B  79      56.434  54.896  62.815  1.00 43.32           C  
ATOM   2205  C   ASP B  79      56.156  56.379  63.106  1.00 43.23           C  
ATOM   2206  O   ASP B  79      55.715  56.718  64.204  1.00 43.35           O  
ATOM   2207  CB  ASP B  79      55.180  54.060  63.100  1.00 44.38           C  
ATOM   2208  CG  ASP B  79      54.006  54.473  62.231  1.00 49.74           C  
ATOM   2209  OD1 ASP B  79      54.129  55.502  61.517  1.00 55.17           O  
ATOM   2210  OD2 ASP B  79      52.957  53.782  62.259  1.00 50.24           O  
ATOM   2211  N   PRO B  80      56.415  57.271  62.131  1.00 45.50           N  
ATOM   2212  CA  PRO B  80      56.286  58.696  62.478  1.00 44.90           C  
ATOM   2213  C   PRO B  80      54.826  59.079  62.709  1.00 43.52           C  
ATOM   2214  O   PRO B  80      54.555  59.988  63.492  1.00 43.91           O  
ATOM   2215  CB  PRO B  80      56.881  59.445  61.259  1.00 45.16           C  
ATOM   2216  CG  PRO B  80      57.482  58.384  60.367  1.00 46.84           C  
ATOM   2217  CD  PRO B  80      56.793  57.080  60.717  1.00 48.73           C  
ATOM   2218  N   ASP B  81      53.903  58.365  62.066  1.00 43.40           N  
ATOM   2219  CA  ASP B  81      52.480  58.650  62.226  1.00 42.58           C  
ATOM   2220  C   ASP B  81      52.051  58.279  63.619  1.00 40.47           C  
ATOM   2221  O   ASP B  81      51.502  59.106  64.334  1.00 39.85           O  
ATOM   2222  CB  ASP B  81      51.636  57.937  61.179  1.00 44.06           C  
ATOM   2223  CG  ASP B  81      51.948  58.421  59.744  1.00 54.90           C  
ATOM   2224  OD1 ASP B  81      52.382  59.602  59.556  1.00 51.04           O  
ATOM   2225  OD2 ASP B  81      51.770  57.604  58.808  1.00 64.36           O  
ATOM   2226  N   LEU B  82      52.346  57.050  64.021  1.00 38.36           N  
ATOM   2227  CA  LEU B  82      52.076  56.618  65.383  1.00 35.73           C  
ATOM   2228  C   LEU B  82      52.448  57.681  66.434  1.00 33.89           C  
ATOM   2229  O   LEU B  82      51.673  57.946  67.348  1.00 32.28           O  
ATOM   2230  CB  LEU B  82      52.766  55.277  65.670  1.00 33.80           C  
ATOM   2231  CG  LEU B  82      52.303  54.516  66.901  1.00 38.50           C  
ATOM   2232  CD1 LEU B  82      50.765  54.435  66.953  1.00 35.44           C  
ATOM   2233  CD2 LEU B  82      52.912  53.104  66.944  1.00 39.16           C  
ATOM   2234  N   LYS B  83      53.622  58.288  66.273  1.00 34.63           N  
ATOM   2235  CA  LYS B  83      54.084  59.378  67.129  1.00 35.38           C  
ATOM   2236  C   LYS B  83      53.160  60.592  67.211  1.00 36.92           C  
ATOM   2237  O   LYS B  83      53.238  61.361  68.164  1.00 35.61           O  
ATOM   2238  CB  LYS B  83      55.468  59.853  66.664  1.00 36.36           C  
ATOM   2239  CG  LYS B  83      56.573  58.968  67.109  1.00 37.32           C  
ATOM   2240  CD  LYS B  83      57.914  59.492  66.631  1.00 42.02           C  
ATOM   2241  CE  LYS B  83      59.032  58.961  67.484  1.00 48.52           C  
ATOM   2242  NZ  LYS B  83      60.307  59.643  67.121  1.00 51.53           N  
ATOM   2243  N   LYS B  84      52.290  60.746  66.219  1.00 37.90           N  
ATOM   2244  CA  LYS B  84      51.327  61.835  66.159  1.00 37.85           C  
ATOM   2245  C   LYS B  84      50.126  61.589  67.047  1.00 34.96           C  
ATOM   2246  O   LYS B  84      49.354  62.490  67.243  1.00 36.76           O  
ATOM   2247  CB  LYS B  84      50.808  62.046  64.721  1.00 39.88           C  
ATOM   2248  CG  LYS B  84      51.867  62.087  63.602  1.00 46.35           C  
ATOM   2249  CD  LYS B  84      52.176  63.480  63.084  1.00 49.64           C  
ATOM   2250  CE  LYS B  84      53.495  63.487  62.280  1.00 47.89           C  
ATOM   2251  NZ  LYS B  84      53.435  64.366  61.080  1.00 52.85           N  
ATOM   2252  N   TRP B  85      49.952  60.388  67.586  1.00 31.93           N  
ATOM   2253  CA  TRP B  85      48.817  60.117  68.435  1.00 31.48           C  
ATOM   2254  C   TRP B  85      49.216  60.312  69.901  1.00 29.46           C  
ATOM   2255  O   TRP B  85      49.990  61.190  70.230  1.00 32.35           O  
ATOM   2256  CB  TRP B  85      48.253  58.720  68.131  1.00 30.61           C  
ATOM   2257  CG  TRP B  85      47.687  58.658  66.740  1.00 31.66           C  
ATOM   2258  CD1 TRP B  85      48.351  58.450  65.589  1.00 30.00           C  
ATOM   2259  CD2 TRP B  85      46.326  58.860  66.392  1.00 32.01           C  
ATOM   2260  NE1 TRP B  85      47.484  58.508  64.522  1.00 28.82           N  
ATOM   2261  CE2 TRP B  85      46.226  58.737  65.000  1.00 33.07           C  
ATOM   2262  CE3 TRP B  85      45.160  59.089  67.138  1.00 36.43           C  
ATOM   2263  CZ2 TRP B  85      45.010  58.862  64.324  1.00 30.01           C  
ATOM   2264  CZ3 TRP B  85      43.954  59.188  66.463  1.00 28.16           C  
ATOM   2265  CH2 TRP B  85      43.888  59.103  65.081  1.00 31.03           C  
ATOM   2266  N   GLY B  86      48.636  59.576  70.802  1.00 27.56           N  
ATOM   2267  CA  GLY B  86      48.919  59.778  72.202  1.00 28.36           C  
ATOM   2268  C   GLY B  86      48.642  58.535  73.010  1.00 29.89           C  
ATOM   2269  O   GLY B  86      48.493  57.452  72.450  1.00 28.84           O  
ATOM   2270  N   ASN B  87      48.545  58.727  74.323  1.00 29.63           N  
ATOM   2271  CA  ASN B  87      48.361  57.633  75.294  1.00 27.78           C  
ATOM   2272  C   ASN B  87      47.233  56.664  74.976  1.00 27.70           C  
ATOM   2273  O   ASN B  87      47.403  55.442  75.097  1.00 29.75           O  
ATOM   2274  CB  ASN B  87      48.148  58.224  76.710  1.00 29.28           C  
ATOM   2275  CG  ASN B  87      48.163  57.168  77.810  1.00 27.54           C  
ATOM   2276  OD1 ASN B  87      47.195  56.452  77.978  1.00 28.33           O  
ATOM   2277  ND2 ASN B  87      49.252  57.100  78.586  1.00 24.21           N  
ATOM   2278  N   ASN B  88      46.082  57.184  74.560  1.00 26.81           N  
ATOM   2279  CA  ASN B  88      44.944  56.311  74.258  1.00 28.67           C  
ATOM   2280  C   ASN B  88      45.346  55.210  73.279  1.00 27.59           C  
ATOM   2281  O   ASN B  88      45.064  54.054  73.491  1.00 29.67           O  
ATOM   2282  CB  ASN B  88      43.770  57.114  73.663  1.00 30.53           C  
ATOM   2283  CG  ASN B  88      43.057  57.990  74.691  1.00 39.27           C  
ATOM   2284  OD1 ASN B  88      43.288  57.888  75.897  1.00 36.94           O  
ATOM   2285  ND2 ASN B  88      42.165  58.857  74.200  1.00 39.84           N  
ATOM   2286  N   ILE B  89      46.029  55.606  72.222  1.00 29.29           N  
ATOM   2287  CA  ILE B  89      46.440  54.684  71.193  1.00 29.00           C  
ATOM   2288  C   ILE B  89      47.697  53.948  71.653  1.00 28.29           C  
ATOM   2289  O   ILE B  89      47.803  52.757  71.472  1.00 28.49           O  
ATOM   2290  CB  ILE B  89      46.738  55.427  69.850  1.00 32.33           C  
ATOM   2291  CG1 ILE B  89      45.462  56.133  69.341  1.00 32.42           C  
ATOM   2292  CG2 ILE B  89      47.291  54.482  68.829  1.00 33.39           C  
ATOM   2293  CD1 ILE B  89      44.272  55.307  69.323  1.00 29.43           C  
ATOM   2294  N   TRP B  90      48.642  54.652  72.256  1.00 27.44           N  
ATOM   2295  CA  TRP B  90      49.918  54.032  72.559  1.00 28.06           C  
ATOM   2296  C   TRP B  90      49.878  52.879  73.583  1.00 28.61           C  
ATOM   2297  O   TRP B  90      50.647  51.901  73.513  1.00 28.03           O  
ATOM   2298  CB  TRP B  90      50.879  55.092  73.071  1.00 28.68           C  
ATOM   2299  CG  TRP B  90      51.317  56.098  72.063  1.00 27.46           C  
ATOM   2300  CD1 TRP B  90      51.302  55.975  70.717  1.00 25.39           C  
ATOM   2301  CD2 TRP B  90      51.812  57.394  72.344  1.00 21.63           C  
ATOM   2302  NE1 TRP B  90      51.781  57.105  70.140  1.00 27.92           N  
ATOM   2303  CE2 TRP B  90      52.109  57.996  71.119  1.00 27.84           C  
ATOM   2304  CE3 TRP B  90      52.066  58.099  73.519  1.00 28.10           C  
ATOM   2305  CZ2 TRP B  90      52.662  59.271  71.028  1.00 29.32           C  
ATOM   2306  CZ3 TRP B  90      52.570  59.379  73.421  1.00 28.32           C  
ATOM   2307  CH2 TRP B  90      52.871  59.942  72.195  1.00 28.91           C  
ATOM   2308  N   HIS B  91      49.054  53.033  74.592  1.00 27.87           N  
ATOM   2309  CA  HIS B  91      49.253  52.242  75.769  1.00 27.03           C  
ATOM   2310  C   HIS B  91      49.027  50.768  75.527  1.00 27.45           C  
ATOM   2311  O   HIS B  91      49.692  49.922  76.158  1.00 28.55           O  
ATOM   2312  CB  HIS B  91      48.504  52.830  76.968  1.00 22.81           C  
ATOM   2313  CG  HIS B  91      47.040  52.511  77.003  1.00 18.63           C  
ATOM   2314  ND1 HIS B  91      46.106  53.264  76.324  1.00 20.40           N  
ATOM   2315  CD2 HIS B  91      46.358  51.585  77.703  1.00 25.15           C  
ATOM   2316  CE1 HIS B  91      44.904  52.751  76.547  1.00 22.31           C  
ATOM   2317  NE2 HIS B  91      45.031  51.732  77.383  1.00 21.08           N  
ATOM   2318  N   GLY B  92      48.164  50.462  74.558  1.00 27.43           N  
ATOM   2319  CA  GLY B  92      47.996  49.102  74.057  1.00 27.09           C  
ATOM   2320  C   GLY B  92      49.003  48.780  72.982  1.00 25.60           C  
ATOM   2321  O   GLY B  92      49.853  47.864  73.144  1.00 24.35           O  
ATOM   2322  N   LEU B  93      48.990  49.558  71.891  1.00 29.35           N  
ATOM   2323  CA  LEU B  93      49.810  49.209  70.711  1.00 29.10           C  
ATOM   2324  C   LEU B  93      51.287  49.259  70.982  1.00 29.35           C  
ATOM   2325  O   LEU B  93      52.040  48.429  70.465  1.00 28.98           O  
ATOM   2326  CB  LEU B  93      49.495  50.104  69.495  1.00 31.12           C  
ATOM   2327  CG  LEU B  93      48.098  49.805  68.918  1.00 42.71           C  
ATOM   2328  CD1 LEU B  93      47.642  50.915  67.990  1.00 51.82           C  
ATOM   2329  CD2 LEU B  93      48.078  48.444  68.200  1.00 48.58           C  
ATOM   2330  N   VAL B  94      51.714  50.253  71.757  1.00 29.00           N  
ATOM   2331  CA  VAL B  94      53.144  50.401  72.121  1.00 30.81           C  
ATOM   2332  C   VAL B  94      53.412  49.810  73.521  1.00 30.29           C  
ATOM   2333  O   VAL B  94      54.483  49.315  73.783  1.00 28.11           O  
ATOM   2334  CB  VAL B  94      53.619  51.888  71.983  1.00 30.23           C  
ATOM   2335  CG1 VAL B  94      55.125  52.026  72.259  1.00 32.04           C  
ATOM   2336  CG2 VAL B  94      53.256  52.406  70.586  1.00 28.06           C  
ATOM   2337  N   GLY B  95      52.409  49.804  74.392  1.00 29.76           N  
ATOM   2338  CA  GLY B  95      52.547  49.185  75.696  1.00 30.55           C  
ATOM   2339  C   GLY B  95      53.050  47.743  75.726  1.00 30.88           C  
ATOM   2340  O   GLY B  95      53.734  47.344  76.669  1.00 26.90           O  
ATOM   2341  N   ILE B  96      52.694  46.947  74.724  1.00 30.92           N  
ATOM   2342  CA  ILE B  96      53.136  45.556  74.703  1.00 30.22           C  
ATOM   2343  C   ILE B  96      54.653  45.422  74.698  1.00 29.69           C  
ATOM   2344  O   ILE B  96      55.138  44.403  75.157  1.00 31.95           O  
ATOM   2345  CB  ILE B  96      52.600  44.710  73.517  1.00 28.22           C  
ATOM   2346  CG1 ILE B  96      52.834  45.461  72.195  1.00 31.38           C  
ATOM   2347  CG2 ILE B  96      51.187  44.283  73.739  1.00 35.92           C  
ATOM   2348  CD1 ILE B  96      52.843  44.549  70.991  1.00 35.62           C  
ATOM   2349  N   TYR B  97      55.403  46.420  74.220  1.00 28.93           N  
ATOM   2350  CA  TYR B  97      56.858  46.342  74.291  1.00 30.66           C  
ATOM   2351  C   TYR B  97      57.352  46.496  75.713  1.00 29.46           C  
ATOM   2352  O   TYR B  97      58.239  45.772  76.124  1.00 26.16           O  
ATOM   2353  CB  TYR B  97      57.532  47.360  73.387  1.00 32.08           C  
ATOM   2354  CG  TYR B  97      57.027  47.262  71.955  1.00 38.34           C  
ATOM   2355  CD1 TYR B  97      57.074  46.044  71.258  1.00 37.76           C  
ATOM   2356  CD2 TYR B  97      56.496  48.372  71.305  1.00 31.91           C  
ATOM   2357  CE1 TYR B  97      56.615  45.948  69.960  1.00 37.61           C  
ATOM   2358  CE2 TYR B  97      56.051  48.280  69.986  1.00 34.11           C  
ATOM   2359  CZ  TYR B  97      56.097  47.067  69.339  1.00 35.76           C  
ATOM   2360  OH  TYR B  97      55.657  46.979  68.044  1.00 43.86           O  
ATOM   2361  N   LYS B  98      56.713  47.382  76.478  1.00 29.10           N  
ATOM   2362  CA  LYS B  98      57.025  47.551  77.884  1.00 30.03           C  
ATOM   2363  C   LYS B  98      56.761  46.246  78.623  1.00 29.76           C  
ATOM   2364  O   LYS B  98      57.572  45.801  79.413  1.00 30.38           O  
ATOM   2365  CB  LYS B  98      56.116  48.631  78.493  1.00 29.74           C  
ATOM   2366  CG  LYS B  98      56.383  48.896  79.972  1.00 31.14           C  
ATOM   2367  CD  LYS B  98      57.861  49.179  80.227  1.00 28.71           C  
ATOM   2368  CE  LYS B  98      58.035  49.718  81.623  1.00 35.53           C  
ATOM   2369  NZ  LYS B  98      59.417  50.079  81.891  1.00 32.05           N  
ATOM   2370  N   ILE B  99      55.603  45.647  78.359  1.00 29.57           N  
ATOM   2371  CA  ILE B  99      55.213  44.395  78.997  1.00 29.39           C  
ATOM   2372  C   ILE B  99      56.235  43.309  78.734  1.00 31.63           C  
ATOM   2373  O   ILE B  99      56.670  42.601  79.674  1.00 32.09           O  
ATOM   2374  CB  ILE B  99      53.825  43.921  78.520  1.00 24.64           C  
ATOM   2375  CG1 ILE B  99      52.713  44.822  79.093  1.00 28.96           C  
ATOM   2376  CG2 ILE B  99      53.578  42.500  79.006  1.00 29.40           C  
ATOM   2377  CD1 ILE B  99      51.320  44.675  78.420  1.00 29.50           C  
ATOM   2378  N   GLN B 100      56.670  43.206  77.469  1.00 33.06           N  
ATOM   2379  CA  GLN B 100      57.701  42.235  77.122  1.00 33.25           C  
ATOM   2380  C   GLN B 100      59.034  42.559  77.728  1.00 33.89           C  
ATOM   2381  O   GLN B 100      59.776  41.634  78.051  1.00 36.57           O  
ATOM   2382  CB  GLN B 100      57.826  42.069  75.619  1.00 31.29           C  
ATOM   2383  CG  GLN B 100      56.537  41.508  74.992  1.00 28.47           C  
ATOM   2384  CD  GLN B 100      56.614  41.484  73.481  1.00 33.26           C  
ATOM   2385  OE1 GLN B 100      56.202  42.434  72.802  1.00 30.55           O  
ATOM   2386  NE2 GLN B 100      57.211  40.422  72.946  1.00 33.44           N  
ATOM   2387  N   GLU B 101      59.364  43.837  77.898  1.00 34.18           N  
ATOM   2388  CA  GLU B 101      60.596  44.213  78.606  1.00 33.92           C  
ATOM   2389  C   GLU B 101      60.599  43.748  80.071  1.00 33.02           C  
ATOM   2390  O   GLU B 101      61.604  43.235  80.561  1.00 32.19           O  
ATOM   2391  CB  GLU B 101      60.833  45.722  78.564  1.00 34.12           C  
ATOM   2392  CG  GLU B 101      61.383  46.253  77.235  1.00 33.07           C  
ATOM   2393  CD  GLU B 101      61.715  47.730  77.308  1.00 34.73           C  
ATOM   2394  OE1 GLU B 101      61.534  48.334  78.388  1.00 37.88           O  
ATOM   2395  OE2 GLU B 101      62.166  48.291  76.295  1.00 37.80           O  
ATOM   2396  N   ASP B 102      59.476  43.918  80.742  1.00 31.37           N  
ATOM   2397  CA  ASP B 102      59.371  43.712  82.174  1.00 31.60           C  
ATOM   2398  C   ASP B 102      59.008  42.289  82.536  1.00 33.47           C  
ATOM   2399  O   ASP B 102      59.275  41.856  83.666  1.00 32.30           O  
ATOM   2400  CB  ASP B 102      58.292  44.612  82.765  1.00 31.94           C  
ATOM   2401  CG  ASP B 102      58.699  46.077  82.811  1.00 33.39           C  
ATOM   2402  OD1 ASP B 102      59.826  46.425  82.379  1.00 37.21           O  
ATOM   2403  OD2 ASP B 102      57.867  46.880  83.296  1.00 33.59           O  
ATOM   2404  N   LEU B 103      58.358  41.581  81.614  1.00 34.09           N  
ATOM   2405  CA  LEU B 103      57.902  40.215  81.862  1.00 35.38           C  
ATOM   2406  C   LEU B 103      58.391  39.261  80.806  1.00 37.70           C  
ATOM   2407  O   LEU B 103      58.707  39.643  79.692  1.00 37.28           O  
ATOM   2408  CB  LEU B 103      56.395  40.129  81.898  1.00 33.57           C  
ATOM   2409  CG  LEU B 103      55.781  41.011  82.979  1.00 36.09           C  
ATOM   2410  CD1 LEU B 103      54.297  41.111  82.817  1.00 36.14           C  
ATOM   2411  CD2 LEU B 103      56.123  40.483  84.376  1.00 38.15           C  
ATOM   2412  N   ALA B 104      58.435  37.990  81.175  1.00 41.18           N  
ATOM   2413  CA  ALA B 104      58.935  36.957  80.282  1.00 42.90           C  
ATOM   2414  C   ALA B 104      57.814  36.388  79.449  1.00 43.64           C  
ATOM   2415  O   ALA B 104      57.766  35.190  79.215  1.00 46.37           O  
ATOM   2416  CB  ALA B 104      59.603  35.855  81.071  1.00 44.32           C  
ATOM   2417  N   ILE B 105      56.925  37.239  78.974  1.00 40.97           N  
ATOM   2418  CA  ILE B 105      55.765  36.747  78.275  1.00 39.98           C  
ATOM   2419  C   ILE B 105      56.042  36.782  76.785  1.00 40.42           C  
ATOM   2420  O   ILE B 105      56.580  37.756  76.252  1.00 41.60           O  
ATOM   2421  CB  ILE B 105      54.499  37.523  78.628  1.00 39.77           C  
ATOM   2422  CG1 ILE B 105      53.316  36.924  77.868  1.00 38.20           C  
ATOM   2423  CG2 ILE B 105      54.647  39.008  78.334  1.00 38.22           C  
ATOM   2424  CD1 ILE B 105      51.999  37.467  78.323  1.00 41.01           C  
ATOM   2425  N   LYS B 106      55.708  35.687  76.127  1.00 40.73           N  
ATOM   2426  CA  LYS B 106      55.938  35.568  74.697  1.00 39.33           C  
ATOM   2427  C   LYS B 106      54.692  35.146  73.936  1.00 39.14           C  
ATOM   2428  O   LYS B 106      54.710  35.120  72.719  1.00 42.16           O  
ATOM   2429  CB  LYS B 106      57.074  34.589  74.424  1.00 41.64           C  
ATOM   2430  CG  LYS B 106      58.437  35.172  74.719  1.00 45.46           C  
ATOM   2431  N   ASP B 107      53.606  34.835  74.634  1.00 35.68           N  
ATOM   2432  CA  ASP B 107      52.420  34.308  73.974  1.00 35.39           C  
ATOM   2433  C   ASP B 107      51.838  35.337  73.012  1.00 33.71           C  
ATOM   2434  O   ASP B 107      51.444  36.439  73.438  1.00 32.92           O  
ATOM   2435  CB  ASP B 107      51.352  33.941  74.994  1.00 34.06           C  
ATOM   2436  CG  ASP B 107      50.196  33.220  74.369  1.00 38.41           C  
ATOM   2437  OD1 ASP B 107      50.300  31.995  74.209  1.00 37.50           O  
ATOM   2438  OD2 ASP B 107      49.169  33.864  74.043  1.00 36.15           O  
ATOM   2439  N   GLN B 108      51.779  34.997  71.726  1.00 31.38           N  
ATOM   2440  CA  GLN B 108      51.361  35.988  70.744  1.00 34.73           C  
ATOM   2441  C   GLN B 108      49.873  36.282  70.812  1.00 33.01           C  
ATOM   2442  O   GLN B 108      49.479  37.401  70.525  1.00 33.48           O  
ATOM   2443  CB  GLN B 108      51.788  35.655  69.311  1.00 36.04           C  
ATOM   2444  CG  GLN B 108      53.257  36.061  69.005  1.00 45.00           C  
ATOM   2445  CD  GLN B 108      53.525  37.580  69.139  1.00 44.48           C  
ATOM   2446  N   ASP B 109      49.047  35.303  71.190  1.00 31.67           N  
ATOM   2447  CA  ASP B 109      47.617  35.578  71.368  1.00 31.59           C  
ATOM   2448  C   ASP B 109      47.343  36.601  72.456  1.00 31.07           C  
ATOM   2449  O   ASP B 109      46.533  37.513  72.283  1.00 29.88           O  
ATOM   2450  CB  ASP B 109      46.817  34.333  71.741  1.00 31.02           C  
ATOM   2451  CG  ASP B 109      46.751  33.311  70.634  1.00 41.72           C  
ATOM   2452  OD1 ASP B 109      47.097  33.629  69.474  1.00 41.63           O  
ATOM   2453  OD2 ASP B 109      46.346  32.170  70.946  1.00 47.06           O  
ATOM   2454  N   ILE B 110      47.976  36.409  73.606  1.00 30.86           N  
ATOM   2455  CA  ILE B 110      47.772  37.336  74.705  1.00 28.86           C  
ATOM   2456  C   ILE B 110      48.300  38.732  74.320  1.00 30.34           C  
ATOM   2457  O   ILE B 110      47.624  39.749  74.502  1.00 27.12           O  
ATOM   2458  CB  ILE B 110      48.450  36.801  75.981  1.00 29.63           C  
ATOM   2459  CG1 ILE B 110      47.633  35.614  76.530  1.00 30.17           C  
ATOM   2460  CG2 ILE B 110      48.572  37.901  77.000  1.00 28.44           C  
ATOM   2461  CD1 ILE B 110      48.387  34.798  77.611  1.00 29.44           C  
ATOM   2462  N   LEU B 111      49.498  38.787  73.740  1.00 29.29           N  
ATOM   2463  CA  LEU B 111      50.068  40.085  73.371  1.00 28.32           C  
ATOM   2464  C   LEU B 111      49.243  40.835  72.335  1.00 28.47           C  
ATOM   2465  O   LEU B 111      49.021  42.021  72.446  1.00 27.06           O  
ATOM   2466  CB  LEU B 111      51.497  39.907  72.851  1.00 29.14           C  
ATOM   2467  CG  LEU B 111      52.442  39.476  73.966  1.00 32.03           C  
ATOM   2468  CD1 LEU B 111      53.701  38.934  73.334  1.00 37.10           C  
ATOM   2469  CD2 LEU B 111      52.732  40.638  74.906  1.00 32.40           C  
ATOM   2470  N   ALA B 112      48.754  40.113  71.338  1.00 29.97           N  
ATOM   2471  CA  ALA B 112      47.915  40.707  70.293  1.00 28.10           C  
ATOM   2472  C   ALA B 112      46.630  41.247  70.835  1.00 25.68           C  
ATOM   2473  O   ALA B 112      46.171  42.288  70.396  1.00 25.97           O  
ATOM   2474  CB  ALA B 112      47.638  39.671  69.138  1.00 27.87           C  
ATOM   2475  N   ALA B 113      46.044  40.554  71.817  1.00 25.99           N  
ATOM   2476  CA  ALA B 113      44.802  40.995  72.425  1.00 25.67           C  
ATOM   2477  C   ALA B 113      44.972  42.237  73.271  1.00 29.13           C  
ATOM   2478  O   ALA B 113      44.052  43.040  73.392  1.00 31.24           O  
ATOM   2479  CB  ALA B 113      44.217  39.897  73.287  1.00 27.71           C  
ATOM   2480  N   ILE B 114      46.103  42.324  73.943  1.00 28.55           N  
ATOM   2481  CA  ILE B 114      46.458  43.546  74.696  1.00 29.06           C  
ATOM   2482  C   ILE B 114      46.719  44.700  73.705  1.00 28.15           C  
ATOM   2483  O   ILE B 114      46.239  45.812  73.891  1.00 26.51           O  
ATOM   2484  CB  ILE B 114      47.718  43.296  75.535  1.00 31.13           C  
ATOM   2485  CG1 ILE B 114      47.380  42.313  76.649  1.00 29.88           C  
ATOM   2486  CG2 ILE B 114      48.343  44.627  76.064  1.00 32.01           C  
ATOM   2487  CD1 ILE B 114      48.605  41.755  77.278  1.00 27.10           C  
ATOM   2488  N   ALA B 115      47.463  44.420  72.639  1.00 24.66           N  
ATOM   2489  CA  ALA B 115      47.843  45.479  71.714  1.00 29.67           C  
ATOM   2490  C   ALA B 115      46.675  46.156  71.065  1.00 31.38           C  
ATOM   2491  O   ALA B 115      46.759  47.364  70.778  1.00 33.01           O  
ATOM   2492  CB  ALA B 115      48.841  45.034  70.651  1.00 26.06           C  
ATOM   2493  N   LYS B 116      45.614  45.408  70.797  1.00 31.08           N  
ATOM   2494  CA  LYS B 116      44.440  45.976  70.154  1.00 32.33           C  
ATOM   2495  C   LYS B 116      43.269  46.247  71.080  1.00 32.74           C  
ATOM   2496  O   LYS B 116      42.208  46.554  70.605  1.00 32.62           O  
ATOM   2497  CB  LYS B 116      43.976  45.059  68.980  1.00 31.51           C  
ATOM   2498  CG  LYS B 116      43.284  43.767  69.373  1.00 36.96           C  
ATOM   2499  CD  LYS B 116      42.791  42.997  68.113  1.00 37.34           C  
ATOM   2500  CE  LYS B 116      43.971  42.281  67.411  1.00 39.55           C  
ATOM   2501  NZ  LYS B 116      43.459  41.462  66.262  1.00 40.35           N  
ATOM   2502  N   HIS B 117      43.459  46.183  72.396  1.00 29.41           N  
ATOM   2503  CA  HIS B 117      42.325  46.263  73.298  1.00 29.33           C  
ATOM   2504  C   HIS B 117      41.549  47.571  73.223  1.00 26.37           C  
ATOM   2505  O   HIS B 117      40.361  47.567  73.507  1.00 25.57           O  
ATOM   2506  CB  HIS B 117      42.760  45.972  74.741  1.00 30.02           C  
ATOM   2507  CG  HIS B 117      43.396  47.141  75.440  1.00 22.77           C  
ATOM   2508  ND1 HIS B 117      44.755  47.378  75.443  1.00 28.80           N  
ATOM   2509  CD2 HIS B 117      42.841  48.104  76.211  1.00 26.54           C  
ATOM   2510  CE1 HIS B 117      44.997  48.469  76.160  1.00 27.41           C  
ATOM   2511  NE2 HIS B 117      43.851  48.916  76.645  1.00 22.18           N  
ATOM   2512  N   THR B 118      42.198  48.660  72.804  1.00 24.28           N  
ATOM   2513  CA  THR B 118      41.553  49.962  72.717  1.00 27.11           C  
ATOM   2514  C   THR B 118      40.775  50.141  71.406  1.00 27.68           C  
ATOM   2515  O   THR B 118      39.649  50.628  71.425  1.00 29.40           O  
ATOM   2516  CB  THR B 118      42.566  51.136  72.900  1.00 28.40           C  
ATOM   2517  OG1 THR B 118      43.368  50.903  74.072  1.00 27.67           O  
ATOM   2518  CG2 THR B 118      41.830  52.509  73.028  1.00 27.49           C  
ATOM   2519  N   VAL B 119      41.366  49.729  70.306  1.00 28.58           N  
ATOM   2520  CA  VAL B 119      40.895  50.043  68.968  1.00 29.00           C  
ATOM   2521  C   VAL B 119      40.225  48.875  68.249  1.00 28.21           C  
ATOM   2522  O   VAL B 119      39.548  49.085  67.282  1.00 27.85           O  
ATOM   2523  CB  VAL B 119      42.077  50.561  68.047  1.00 24.30           C  
ATOM   2524  CG1 VAL B 119      42.557  51.949  68.473  1.00 29.77           C  
ATOM   2525  CG2 VAL B 119      43.268  49.606  67.989  1.00 29.21           C  
ATOM   2526  N   GLY B 120      40.467  47.649  68.705  1.00 26.91           N  
ATOM   2527  CA  GLY B 120      40.011  46.442  68.024  1.00 23.57           C  
ATOM   2528  C   GLY B 120      40.744  46.135  66.722  1.00 25.59           C  
ATOM   2529  O   GLY B 120      41.755  46.769  66.394  1.00 26.18           O  
ATOM   2530  N   SER B 121      40.202  45.188  65.963  1.00 25.79           N  
ATOM   2531  CA  SER B 121      40.539  44.987  64.556  1.00 26.52           C  
ATOM   2532  C   SER B 121      39.322  44.451  63.862  1.00 28.48           C  
ATOM   2533  O   SER B 121      38.287  44.180  64.494  1.00 26.10           O  
ATOM   2534  CB  SER B 121      41.708  43.987  64.369  1.00 27.21           C  
ATOM   2535  OG  SER B 121      41.344  42.668  64.744  1.00 33.67           O  
ATOM   2536  N   ALA B 122      39.430  44.278  62.555  1.00 30.26           N  
ATOM   2537  CA  ALA B 122      38.355  43.648  61.785  1.00 33.18           C  
ATOM   2538  C   ALA B 122      38.212  42.161  62.003  1.00 34.87           C  
ATOM   2539  O   ALA B 122      37.151  41.586  61.731  1.00 44.14           O  
ATOM   2540  CB  ALA B 122      38.511  43.919  60.282  1.00 35.27           C  
ATOM   2541  N   GLN B 123      39.226  41.466  62.425  1.00 32.09           N  
ATOM   2542  CA  GLN B 123      38.978  39.998  62.442  1.00 36.76           C  
ATOM   2543  C   GLN B 123      39.492  39.488  63.751  1.00 34.00           C  
ATOM   2544  O   GLN B 123      40.447  38.743  63.810  1.00 40.32           O  
ATOM   2545  CB  GLN B 123      39.570  39.231  61.205  1.00 36.57           C  
ATOM   2546  CG  GLN B 123      38.795  39.354  59.866  1.00 43.96           C  
ATOM   2547  CD  GLN B 123      39.114  38.218  58.853  1.00 38.90           C  
HETATM 2548  N   MSE B 124      38.813  39.903  64.807  1.00 29.18           N  
HETATM 2549  CA  MSE B 124      39.287  39.698  66.155  1.00 27.89           C  
HETATM 2550  C   MSE B 124      39.158  38.256  66.587  1.00 28.62           C  
HETATM 2551  O   MSE B 124      38.228  37.585  66.208  1.00 25.73           O  
HETATM 2552  CB  MSE B 124      38.510  40.590  67.124  1.00 29.84           C  
HETATM 2553  CG  MSE B 124      38.633  42.026  66.757  1.00 29.51           C  
HETATM 2554 SE   MSE B 124      37.560  43.212  67.867  0.75 27.02          SE  
HETATM 2555  CE  MSE B 124      38.430  42.866  69.221  1.00 18.32           C  
ATOM   2556  N   SER B 125      40.139  37.762  67.343  1.00 26.24           N  
ATOM   2557  CA  SER B 125      40.062  36.428  67.917  1.00 26.33           C  
ATOM   2558  C   SER B 125      39.083  36.467  69.087  1.00 27.64           C  
ATOM   2559  O   SER B 125      38.645  37.549  69.545  1.00 25.10           O  
ATOM   2560  CB  SER B 125      41.465  35.959  68.369  1.00 28.09           C  
ATOM   2561  OG  SER B 125      41.851  36.656  69.555  1.00 29.31           O  
ATOM   2562  N   THR B 126      38.686  35.296  69.562  1.00 27.46           N  
ATOM   2563  CA  THR B 126      37.879  35.232  70.778  1.00 25.72           C  
ATOM   2564  C   THR B 126      38.567  35.923  71.940  1.00 23.97           C  
ATOM   2565  O   THR B 126      37.933  36.670  72.645  1.00 23.01           O  
ATOM   2566  CB  THR B 126      37.494  33.788  71.140  1.00 27.92           C  
ATOM   2567  OG1 THR B 126      36.769  33.218  70.039  1.00 27.07           O  
ATOM   2568  CG2 THR B 126      36.612  33.756  72.381  1.00 27.40           C  
ATOM   2569  N   LEU B 127      39.856  35.696  72.143  1.00 26.13           N  
ATOM   2570  CA  LEU B 127      40.537  36.355  73.287  1.00 24.26           C  
ATOM   2571  C   LEU B 127      40.512  37.883  73.098  1.00 23.77           C  
ATOM   2572  O   LEU B 127      40.334  38.627  74.035  1.00 22.84           O  
ATOM   2573  CB  LEU B 127      42.023  35.909  73.394  1.00 25.18           C  
ATOM   2574  CG  LEU B 127      42.839  36.491  74.562  1.00 19.04           C  
ATOM   2575  CD1 LEU B 127      42.231  36.244  75.866  1.00 30.33           C  
ATOM   2576  CD2 LEU B 127      44.256  35.892  74.526  1.00 30.47           C  
ATOM   2577  N   ASP B 128      40.723  38.325  71.866  1.00 25.17           N  
ATOM   2578  CA  ASP B 128      40.742  39.768  71.535  1.00 25.01           C  
ATOM   2579  C   ASP B 128      39.440  40.385  71.983  1.00 22.09           C  
ATOM   2580  O   ASP B 128      39.409  41.456  72.620  1.00 25.36           O  
ATOM   2581  CB  ASP B 128      40.844  40.006  70.031  1.00 24.15           C  
ATOM   2582  CG  ASP B 128      42.194  39.669  69.429  1.00 28.18           C  
ATOM   2583  OD1 ASP B 128      43.161  39.522  70.173  1.00 28.96           O  
ATOM   2584  OD2 ASP B 128      42.277  39.547  68.170  1.00 26.72           O  
ATOM   2585  N   LYS B 129      38.355  39.705  71.640  1.00 22.23           N  
ATOM   2586  CA  LYS B 129      37.002  40.212  71.911  1.00 22.15           C  
ATOM   2587  C   LYS B 129      36.674  40.198  73.397  1.00 23.42           C  
ATOM   2588  O   LYS B 129      35.963  41.115  73.913  1.00 26.06           O  
ATOM   2589  CB  LYS B 129      35.941  39.416  71.130  1.00 25.05           C  
ATOM   2590  CG  LYS B 129      35.950  39.484  69.618  1.00 25.10           C  
ATOM   2591  CD  LYS B 129      34.819  38.607  68.996  1.00 27.00           C  
ATOM   2592  CE  LYS B 129      35.233  38.076  67.670  1.00 42.74           C  
ATOM   2593  NZ  LYS B 129      34.199  37.229  67.011  1.00 26.51           N  
ATOM   2594  N   ILE B 130      37.081  39.140  74.077  1.00 25.43           N  
ATOM   2595  CA  ILE B 130      36.892  39.025  75.552  1.00 22.29           C  
ATOM   2596  C   ILE B 130      37.579  40.187  76.264  1.00 24.02           C  
ATOM   2597  O   ILE B 130      37.011  40.815  77.114  1.00 25.11           O  
ATOM   2598  CB  ILE B 130      37.398  37.637  76.102  1.00 21.13           C  
ATOM   2599  CG1 ILE B 130      36.454  36.522  75.671  1.00 25.74           C  
ATOM   2600  CG2 ILE B 130      37.557  37.661  77.637  1.00 21.73           C  
ATOM   2601  CD1 ILE B 130      36.978  35.140  76.036  1.00 26.47           C  
ATOM   2602  N   VAL B 131      38.817  40.504  75.916  1.00 22.47           N  
ATOM   2603  CA  VAL B 131      39.468  41.613  76.594  1.00 22.96           C  
ATOM   2604  C   VAL B 131      38.812  42.963  76.260  1.00 21.47           C  
ATOM   2605  O   VAL B 131      38.627  43.832  77.129  1.00 22.83           O  
ATOM   2606  CB  VAL B 131      40.964  41.668  76.202  1.00 25.11           C  
ATOM   2607  CG1 VAL B 131      41.635  42.845  76.858  1.00 28.82           C  
ATOM   2608  CG2 VAL B 131      41.647  40.351  76.612  1.00 30.89           C  
ATOM   2609  N   TYR B 132      38.481  43.143  74.978  1.00 23.05           N  
ATOM   2610  CA  TYR B 132      37.878  44.352  74.468  1.00 24.37           C  
ATOM   2611  C   TYR B 132      36.534  44.637  75.151  1.00 23.68           C  
ATOM   2612  O   TYR B 132      36.237  45.776  75.519  1.00 27.04           O  
ATOM   2613  CB  TYR B 132      37.722  44.225  72.951  1.00 24.37           C  
ATOM   2614  CG  TYR B 132      37.144  45.393  72.202  1.00 20.77           C  
ATOM   2615  CD1 TYR B 132      37.931  46.476  71.824  1.00 27.20           C  
ATOM   2616  CD2 TYR B 132      35.776  45.432  71.876  1.00 24.39           C  
ATOM   2617  CE1 TYR B 132      37.395  47.537  71.103  1.00 30.06           C  
ATOM   2618  CE2 TYR B 132      35.252  46.516  71.182  1.00 28.07           C  
ATOM   2619  CZ  TYR B 132      36.079  47.560  70.797  1.00 28.84           C  
ATOM   2620  OH  TYR B 132      35.523  48.656  70.114  1.00 25.64           O  
ATOM   2621  N   VAL B 133      35.746  43.601  75.334  1.00 25.07           N  
ATOM   2622  CA  VAL B 133      34.445  43.740  75.995  1.00 21.34           C  
ATOM   2623  C   VAL B 133      34.539  43.855  77.528  1.00 22.82           C  
ATOM   2624  O   VAL B 133      33.858  44.693  78.151  1.00 24.62           O  
ATOM   2625  CB  VAL B 133      33.535  42.592  75.567  1.00 24.09           C  
ATOM   2626  CG1 VAL B 133      32.288  42.617  76.362  1.00 24.98           C  
ATOM   2627  CG2 VAL B 133      33.215  42.679  74.094  1.00 22.25           C  
ATOM   2628  N   ALA B 134      35.365  43.014  78.156  1.00 24.39           N  
ATOM   2629  CA  ALA B 134      35.604  43.022  79.616  1.00 20.67           C  
ATOM   2630  C   ALA B 134      36.063  44.432  80.096  1.00 25.02           C  
ATOM   2631  O   ALA B 134      35.707  44.902  81.157  1.00 25.25           O  
ATOM   2632  CB  ALA B 134      36.659  41.992  79.940  1.00 25.23           C  
ATOM   2633  N   ASP B 135      36.885  45.068  79.291  1.00 24.50           N  
ATOM   2634  CA  ASP B 135      37.356  46.428  79.555  1.00 26.32           C  
ATOM   2635  C   ASP B 135      36.215  47.440  79.724  1.00 27.94           C  
ATOM   2636  O   ASP B 135      36.297  48.329  80.573  1.00 29.78           O  
ATOM   2637  CB  ASP B 135      38.274  46.874  78.431  1.00 26.99           C  
ATOM   2638  CG  ASP B 135      39.030  48.176  78.773  1.00 27.32           C  
ATOM   2639  OD1 ASP B 135      39.297  48.375  79.974  1.00 26.99           O  
ATOM   2640  OD2 ASP B 135      39.347  48.930  77.848  1.00 31.43           O  
ATOM   2641  N   TYR B 136      35.129  47.239  78.952  1.00 25.86           N  
ATOM   2642  CA  TYR B 136      34.036  48.142  78.820  1.00 24.91           C  
ATOM   2643  C   TYR B 136      32.926  47.874  79.870  1.00 25.93           C  
ATOM   2644  O   TYR B 136      32.251  48.797  80.308  1.00 26.88           O  
ATOM   2645  CB  TYR B 136      33.486  48.005  77.387  1.00 27.86           C  
ATOM   2646  CG  TYR B 136      32.584  49.109  76.894  1.00 25.54           C  
ATOM   2647  CD1 TYR B 136      33.034  50.393  76.760  1.00 25.66           C  
ATOM   2648  CD2 TYR B 136      31.267  48.853  76.562  1.00 27.15           C  
ATOM   2649  CE1 TYR B 136      32.221  51.401  76.293  1.00 29.08           C  
ATOM   2650  CE2 TYR B 136      30.470  49.842  76.075  1.00 25.59           C  
ATOM   2651  CZ  TYR B 136      30.958  51.131  75.967  1.00 20.65           C  
ATOM   2652  OH  TYR B 136      30.137  52.152  75.502  1.00 23.08           O  
ATOM   2653  N   ILE B 137      32.831  46.634  80.330  1.00 25.96           N  
ATOM   2654  CA  ILE B 137      31.724  46.189  81.164  1.00 27.22           C  
ATOM   2655  C   ILE B 137      32.124  45.840  82.581  1.00 26.29           C  
ATOM   2656  O   ILE B 137      31.247  45.587  83.404  1.00 27.74           O  
ATOM   2657  CB  ILE B 137      30.958  44.994  80.525  1.00 28.49           C  
ATOM   2658  CG1 ILE B 137      31.793  43.709  80.570  1.00 27.05           C  
ATOM   2659  CG2 ILE B 137      30.470  45.382  79.099  1.00 32.29           C  
ATOM   2660  CD1 ILE B 137      31.098  42.470  80.197  1.00 30.88           C  
ATOM   2661  N   GLU B 138      33.422  45.873  82.894  1.00 27.11           N  
ATOM   2662  CA  GLU B 138      33.879  45.556  84.240  1.00 27.63           C  
ATOM   2663  C   GLU B 138      33.126  46.346  85.316  1.00 28.34           C  
ATOM   2664  O   GLU B 138      32.714  47.460  85.101  1.00 28.77           O  
ATOM   2665  CB  GLU B 138      35.406  45.695  84.390  1.00 23.31           C  
ATOM   2666  CG  GLU B 138      36.011  47.128  84.241  1.00 27.56           C  
ATOM   2667  CD  GLU B 138      36.186  47.876  85.575  1.00 29.54           C  
ATOM   2668  OE1 GLU B 138      35.824  47.315  86.649  1.00 28.03           O  
ATOM   2669  OE2 GLU B 138      36.651  49.044  85.524  1.00 26.81           O  
ATOM   2670  N   HIS B 139      32.937  45.723  86.478  1.00 28.78           N  
ATOM   2671  CA  HIS B 139      31.910  46.141  87.440  1.00 26.89           C  
ATOM   2672  C   HIS B 139      32.144  47.534  88.024  1.00 27.70           C  
ATOM   2673  O   HIS B 139      31.203  48.132  88.481  1.00 28.40           O  
ATOM   2674  CB  HIS B 139      31.806  45.120  88.606  1.00 31.82           C  
ATOM   2675  CG  HIS B 139      32.978  45.170  89.541  1.00 29.41           C  
ATOM   2676  ND1 HIS B 139      32.972  45.931  90.689  1.00 31.74           N  
ATOM   2677  CD2 HIS B 139      34.212  44.621  89.462  1.00 32.21           C  
ATOM   2678  CE1 HIS B 139      34.132  45.803  91.301  1.00 33.82           C  
ATOM   2679  NE2 HIS B 139      34.904  45.018  90.578  1.00 32.52           N  
ATOM   2680  N   ASN B 140      33.377  48.048  88.003  1.00 25.48           N  
ATOM   2681  CA  ASN B 140      33.646  49.429  88.480  1.00 26.26           C  
ATOM   2682  C   ASN B 140      33.175  50.518  87.509  1.00 27.98           C  
ATOM   2683  O   ASN B 140      33.020  51.678  87.908  1.00 29.97           O  
ATOM   2684  CB  ASN B 140      35.148  49.631  88.676  1.00 26.82           C  
ATOM   2685  CG  ASN B 140      35.679  48.792  89.744  1.00 33.37           C  
ATOM   2686  OD1 ASN B 140      35.361  49.015  90.913  1.00 31.08           O  
ATOM   2687  ND2 ASN B 140      36.449  47.756  89.369  1.00 28.49           N  
ATOM   2688  N   ARG B 141      32.944  50.144  86.244  1.00 25.14           N  
ATOM   2689  CA  ARG B 141      32.477  51.068  85.228  1.00 26.47           C  
ATOM   2690  C   ARG B 141      31.065  51.504  85.564  1.00 24.88           C  
ATOM   2691  O   ARG B 141      30.218  50.689  85.959  1.00 25.99           O  
ATOM   2692  CB  ARG B 141      32.490  50.453  83.826  1.00 23.83           C  
ATOM   2693  CG  ARG B 141      33.847  49.997  83.317  1.00 28.84           C  
ATOM   2694  CD  ARG B 141      34.720  51.111  82.925  1.00 29.61           C  
ATOM   2695  NE  ARG B 141      35.734  50.720  81.928  1.00 25.65           N  
ATOM   2696  CZ  ARG B 141      36.864  51.386  81.743  1.00 38.60           C  
ATOM   2697  NH1 ARG B 141      37.129  52.471  82.462  1.00 36.72           N  
ATOM   2698  NH2 ARG B 141      37.711  50.992  80.811  1.00 28.56           N  
ATOM   2699  N   ASP B 142      30.812  52.805  85.386  1.00 26.44           N  
ATOM   2700  CA  ASP B 142      29.543  53.391  85.688  1.00 30.31           C  
ATOM   2701  C   ASP B 142      29.378  54.546  84.707  1.00 32.28           C  
ATOM   2702  O   ASP B 142      29.836  55.676  84.959  1.00 34.04           O  
ATOM   2703  CB  ASP B 142      29.631  53.925  87.123  1.00 33.27           C  
ATOM   2704  CG  ASP B 142      28.423  54.644  87.571  1.00 36.25           C  
ATOM   2705  OD1 ASP B 142      27.451  54.740  86.820  1.00 41.52           O  
ATOM   2706  OD2 ASP B 142      28.451  55.121  88.721  1.00 33.08           O  
ATOM   2707  N   PHE B 143      28.767  54.248  83.582  1.00 28.59           N  
ATOM   2708  CA  PHE B 143      28.588  55.221  82.517  1.00 27.76           C  
ATOM   2709  C   PHE B 143      27.307  54.894  81.804  1.00 27.30           C  
ATOM   2710  O   PHE B 143      26.751  53.780  81.954  1.00 26.71           O  
ATOM   2711  CB  PHE B 143      29.787  55.272  81.551  1.00 25.63           C  
ATOM   2712  CG  PHE B 143      30.076  53.953  80.798  1.00 22.68           C  
ATOM   2713  CD1 PHE B 143      29.402  53.633  79.621  1.00 24.53           C  
ATOM   2714  CD2 PHE B 143      31.039  53.062  81.281  1.00 27.87           C  
ATOM   2715  CE1 PHE B 143      29.648  52.432  78.965  1.00 26.59           C  
ATOM   2716  CE2 PHE B 143      31.318  51.858  80.608  1.00 26.96           C  
ATOM   2717  CZ  PHE B 143      30.635  51.537  79.454  1.00 32.23           C  
ATOM   2718  N   PRO B 144      26.764  55.877  81.080  1.00 26.15           N  
ATOM   2719  CA  PRO B 144      25.481  55.586  80.510  1.00 23.35           C  
ATOM   2720  C   PRO B 144      25.475  54.407  79.525  1.00 26.82           C  
ATOM   2721  O   PRO B 144      26.355  54.312  78.663  1.00 23.71           O  
ATOM   2722  CB  PRO B 144      25.121  56.894  79.813  1.00 26.39           C  
ATOM   2723  CG  PRO B 144      25.849  57.940  80.620  1.00 28.82           C  
ATOM   2724  CD  PRO B 144      27.190  57.258  80.756  1.00 25.76           C  
ATOM   2725  N   GLY B 145      24.473  53.550  79.662  1.00 29.10           N  
ATOM   2726  CA  GLY B 145      24.320  52.372  78.806  1.00 31.85           C  
ATOM   2727  C   GLY B 145      25.271  51.210  79.067  1.00 29.91           C  
ATOM   2728  O   GLY B 145      25.285  50.232  78.299  1.00 27.56           O  
ATOM   2729  N   VAL B 146      26.029  51.276  80.157  1.00 28.74           N  
ATOM   2730  CA  VAL B 146      26.881  50.151  80.534  1.00 27.53           C  
ATOM   2731  C   VAL B 146      26.005  48.917  80.766  1.00 28.38           C  
ATOM   2732  O   VAL B 146      26.405  47.811  80.473  1.00 25.48           O  
ATOM   2733  CB  VAL B 146      27.768  50.476  81.745  1.00 26.64           C  
ATOM   2734  CG1 VAL B 146      26.977  50.565  83.069  1.00 28.26           C  
ATOM   2735  CG2 VAL B 146      28.911  49.463  81.816  1.00 27.52           C  
ATOM   2736  N   GLU B 147      24.781  49.101  81.257  1.00 26.53           N  
ATOM   2737  CA  GLU B 147      23.925  47.960  81.443  1.00 25.90           C  
ATOM   2738  C   GLU B 147      23.461  47.318  80.134  1.00 27.83           C  
ATOM   2739  O   GLU B 147      23.236  46.105  80.075  1.00 26.83           O  
ATOM   2740  CB  GLU B 147      22.738  48.342  82.309  1.00 28.25           C  
ATOM   2741  CG  GLU B 147      23.106  48.458  83.783  1.00 40.30           C  
ATOM   2742  CD  GLU B 147      23.766  47.182  84.364  1.00 44.51           C  
ATOM   2743  OE1 GLU B 147      23.318  46.063  84.030  1.00 59.99           O  
ATOM   2744  OE2 GLU B 147      24.734  47.309  85.143  1.00 44.67           O  
ATOM   2745  N   GLU B 148      23.333  48.103  79.075  1.00 26.99           N  
ATOM   2746  CA  GLU B 148      23.055  47.578  77.751  1.00 28.46           C  
ATOM   2747  C   GLU B 148      24.239  46.745  77.260  1.00 26.92           C  
ATOM   2748  O   GLU B 148      24.026  45.682  76.704  1.00 30.65           O  
ATOM   2749  CB  GLU B 148      22.784  48.691  76.733  1.00 27.33           C  
ATOM   2750  CG  GLU B 148      21.343  49.179  76.725  1.00 42.82           C  
ATOM   2751  CD  GLU B 148      20.848  49.701  78.085  1.00 62.84           C  
ATOM   2752  OE1 GLU B 148      21.424  50.693  78.613  1.00 63.43           O  
ATOM   2753  OE2 GLU B 148      19.853  49.125  78.616  1.00 76.58           O  
ATOM   2754  N   ALA B 149      25.453  47.222  77.429  1.00 26.29           N  
ATOM   2755  CA  ALA B 149      26.625  46.460  77.054  1.00 24.07           C  
ATOM   2756  C   ALA B 149      26.710  45.143  77.829  1.00 24.72           C  
ATOM   2757  O   ALA B 149      27.042  44.097  77.275  1.00 26.00           O  
ATOM   2758  CB  ALA B 149      27.862  47.281  77.355  1.00 27.07           C  
ATOM   2759  N   ARG B 150      26.503  45.227  79.129  1.00 25.51           N  
ATOM   2760  CA  ARG B 150      26.483  44.035  80.005  1.00 26.62           C  
ATOM   2761  C   ARG B 150      25.477  43.027  79.568  1.00 28.41           C  
ATOM   2762  O   ARG B 150      25.763  41.823  79.540  1.00 29.14           O  
ATOM   2763  CB  ARG B 150      26.246  44.427  81.473  1.00 25.25           C  
ATOM   2764  CG  ARG B 150      27.489  45.079  82.066  1.00 24.38           C  
ATOM   2765  CD  ARG B 150      27.296  45.762  83.366  1.00 24.39           C  
ATOM   2766  NE  ARG B 150      28.527  46.357  83.825  1.00 26.41           N  
ATOM   2767  CZ  ARG B 150      28.593  47.319  84.743  1.00 27.94           C  
ATOM   2768  NH1 ARG B 150      27.494  47.773  85.324  1.00 27.99           N  
ATOM   2769  NH2 ARG B 150      29.769  47.840  85.069  1.00 29.01           N  
ATOM   2770  N   GLU B 151      24.263  43.471  79.259  1.00 28.93           N  
ATOM   2771  CA  GLU B 151      23.260  42.559  78.803  1.00 30.15           C  
ATOM   2772  C   GLU B 151      23.612  41.892  77.486  1.00 28.54           C  
ATOM   2773  O   GLU B 151      23.451  40.679  77.328  1.00 28.15           O  
ATOM   2774  CB  GLU B 151      21.879  43.203  78.758  1.00 33.64           C  
ATOM   2775  CG  GLU B 151      21.315  43.438  80.145  1.00 40.15           C  
ATOM   2776  CD  GLU B 151      21.197  42.144  80.983  1.00 52.99           C  
ATOM   2777  OE1 GLU B 151      20.731  41.122  80.416  1.00 52.88           O  
ATOM   2778  OE2 GLU B 151      21.589  42.148  82.191  1.00 46.18           O  
ATOM   2779  N   LEU B 152      24.096  42.665  76.535  1.00 27.75           N  
ATOM   2780  CA  LEU B 152      24.494  42.088  75.273  1.00 25.60           C  
ATOM   2781  C   LEU B 152      25.618  41.057  75.471  1.00 25.33           C  
ATOM   2782  O   LEU B 152      25.617  40.023  74.827  1.00 23.30           O  
ATOM   2783  CB  LEU B 152      24.898  43.202  74.295  1.00 25.51           C  
ATOM   2784  CG  LEU B 152      23.778  44.010  73.659  1.00 27.55           C  
ATOM   2785  CD1 LEU B 152      24.411  45.099  72.796  1.00 29.34           C  
ATOM   2786  CD2 LEU B 152      22.769  43.139  72.838  1.00 24.94           C  
ATOM   2787  N   ALA B 153      26.570  41.357  76.355  1.00 26.65           N  
ATOM   2788  CA  ALA B 153      27.704  40.455  76.630  1.00 25.77           C  
ATOM   2789  C   ALA B 153      27.246  39.136  77.206  1.00 25.91           C  
ATOM   2790  O   ALA B 153      27.940  38.128  77.138  1.00 23.79           O  
ATOM   2791  CB  ALA B 153      28.661  41.095  77.592  1.00 26.49           C  
ATOM   2792  N   LYS B 154      26.046  39.116  77.744  1.00 25.17           N  
ATOM   2793  CA  LYS B 154      25.498  37.867  78.266  1.00 27.24           C  
ATOM   2794  C   LYS B 154      24.873  37.003  77.205  1.00 27.84           C  
ATOM   2795  O   LYS B 154      24.548  35.837  77.450  1.00 31.39           O  
ATOM   2796  CB  LYS B 154      24.422  38.155  79.276  1.00 25.14           C  
ATOM   2797  CG  LYS B 154      24.956  38.685  80.579  1.00 29.04           C  
ATOM   2798  CD  LYS B 154      23.794  38.923  81.503  1.00 34.89           C  
ATOM   2799  CE  LYS B 154      24.187  39.627  82.737  1.00 39.78           C  
ATOM   2800  NZ  LYS B 154      22.959  39.792  83.549  1.00 45.52           N  
ATOM   2801  N   VAL B 155      24.719  37.549  76.020  1.00 26.28           N  
ATOM   2802  CA  VAL B 155      23.961  36.906  74.996  1.00 30.67           C  
ATOM   2803  C   VAL B 155      24.771  36.629  73.753  1.00 27.67           C  
ATOM   2804  O   VAL B 155      24.665  35.552  73.165  1.00 24.68           O  
ATOM   2805  CB  VAL B 155      22.658  37.723  74.738  1.00 35.32           C  
ATOM   2806  CG1 VAL B 155      22.220  37.652  73.304  1.00 40.61           C  
ATOM   2807  CG2 VAL B 155      21.560  37.184  75.642  1.00 37.86           C  
ATOM   2808  N   ASP B 156      25.574  37.586  73.320  1.00 29.41           N  
ATOM   2809  CA  ASP B 156      26.303  37.425  72.089  1.00 29.59           C  
ATOM   2810  C   ASP B 156      27.490  38.301  72.187  1.00 27.80           C  
ATOM   2811  O   ASP B 156      27.304  39.526  72.252  1.00 28.49           O  
ATOM   2812  CB  ASP B 156      25.407  37.911  70.927  1.00 27.46           C  
ATOM   2813  CG  ASP B 156      26.011  37.688  69.561  1.00 34.86           C  
ATOM   2814  OD1 ASP B 156      27.199  37.974  69.332  1.00 37.22           O  
ATOM   2815  OD2 ASP B 156      25.282  37.234  68.676  1.00 46.77           O  
ATOM   2816  N   LEU B 157      28.690  37.707  72.147  1.00 26.34           N  
ATOM   2817  CA  LEU B 157      29.942  38.477  72.251  1.00 27.22           C  
ATOM   2818  C   LEU B 157      30.194  39.440  71.060  1.00 28.78           C  
ATOM   2819  O   LEU B 157      30.787  40.538  71.205  1.00 23.14           O  
ATOM   2820  CB  LEU B 157      31.096  37.476  72.377  1.00 24.72           C  
ATOM   2821  CG  LEU B 157      32.523  37.976  72.650  1.00 26.70           C  
ATOM   2822  CD1 LEU B 157      32.529  38.837  73.900  1.00 29.46           C  
ATOM   2823  CD2 LEU B 157      33.464  36.795  72.777  1.00 30.32           C  
ATOM   2824  N   ASN B 158      29.758  39.032  69.876  1.00 27.29           N  
ATOM   2825  CA  ASN B 158      29.979  39.863  68.675  1.00 27.22           C  
ATOM   2826  C   ASN B 158      29.107  41.120  68.723  1.00 24.90           C  
ATOM   2827  O   ASN B 158      29.534  42.208  68.308  1.00 21.62           O  
ATOM   2828  CB  ASN B 158      29.715  39.068  67.392  1.00 26.20           C  
ATOM   2829  CG  ASN B 158      30.827  38.104  67.069  1.00 33.19           C  
ATOM   2830  OD1 ASN B 158      31.988  38.435  67.210  1.00 26.05           O  
ATOM   2831  ND2 ASN B 158      30.478  36.919  66.638  1.00 35.95           N  
ATOM   2832  N   LYS B 159      27.876  40.979  69.206  1.00 25.12           N  
ATOM   2833  CA  LYS B 159      27.019  42.129  69.426  1.00 27.68           C  
ATOM   2834  C   LYS B 159      27.569  43.093  70.451  1.00 25.76           C  
ATOM   2835  O   LYS B 159      27.470  44.318  70.290  1.00 25.25           O  
ATOM   2836  CB  LYS B 159      25.627  41.715  69.875  1.00 25.49           C  
ATOM   2837  CG  LYS B 159      24.807  41.079  68.789  1.00 31.28           C  
ATOM   2838  CD  LYS B 159      23.402  40.782  69.252  1.00 31.25           C  
ATOM   2839  CE  LYS B 159      22.622  40.117  68.173  1.00 42.85           C  
ATOM   2840  NZ  LYS B 159      21.175  40.042  68.516  1.00 45.60           N  
ATOM   2841  N   ALA B 160      28.092  42.546  71.532  1.00 25.69           N  
ATOM   2842  CA  ALA B 160      28.721  43.357  72.576  1.00 25.27           C  
ATOM   2843  C   ALA B 160      29.890  44.165  71.993  1.00 24.43           C  
ATOM   2844  O   ALA B 160      30.030  45.399  72.233  1.00 23.88           O  
ATOM   2845  CB  ALA B 160      29.156  42.452  73.724  1.00 25.55           C  
ATOM   2846  N   VAL B 161      30.683  43.504  71.183  1.00 24.28           N  
ATOM   2847  CA  VAL B 161      31.773  44.146  70.432  1.00 23.87           C  
ATOM   2848  C   VAL B 161      31.196  45.261  69.549  1.00 26.01           C  
ATOM   2849  O   VAL B 161      31.687  46.410  69.612  1.00 28.36           O  
ATOM   2850  CB  VAL B 161      32.643  43.130  69.624  1.00 27.74           C  
ATOM   2851  CG1 VAL B 161      33.600  43.821  68.714  1.00 22.82           C  
ATOM   2852  CG2 VAL B 161      33.547  42.280  70.490  1.00 28.60           C  
ATOM   2853  N   ALA B 162      30.128  44.952  68.793  1.00 25.42           N  
ATOM   2854  CA  ALA B 162      29.518  45.921  67.874  1.00 25.59           C  
ATOM   2855  C   ALA B 162      29.022  47.167  68.629  1.00 27.11           C  
ATOM   2856  O   ALA B 162      29.280  48.322  68.219  1.00 26.24           O  
ATOM   2857  CB  ALA B 162      28.335  45.278  67.151  1.00 25.39           C  
ATOM   2858  N   TYR B 163      28.317  46.925  69.735  1.00 24.47           N  
ATOM   2859  CA  TYR B 163      27.747  47.999  70.548  1.00 23.23           C  
ATOM   2860  C   TYR B 163      28.852  48.921  71.094  1.00 25.57           C  
ATOM   2861  O   TYR B 163      28.823  50.154  70.974  1.00 25.51           O  
ATOM   2862  CB  TYR B 163      26.899  47.373  71.677  1.00 27.16           C  
ATOM   2863  CG  TYR B 163      26.224  48.376  72.543  1.00 22.44           C  
ATOM   2864  CD1 TYR B 163      25.065  49.032  72.142  1.00 26.50           C  
ATOM   2865  CD2 TYR B 163      26.806  48.769  73.736  1.00 22.99           C  
ATOM   2866  CE1 TYR B 163      24.469  49.992  72.963  1.00 31.67           C  
ATOM   2867  CE2 TYR B 163      26.254  49.757  74.518  1.00 28.56           C  
ATOM   2868  CZ  TYR B 163      25.050  50.308  74.172  1.00 24.60           C  
ATOM   2869  OH  TYR B 163      24.523  51.313  74.982  1.00 28.91           O  
ATOM   2870  N   GLU B 164      29.888  48.296  71.639  1.00 23.22           N  
ATOM   2871  CA  GLU B 164      30.945  49.050  72.247  1.00 22.11           C  
ATOM   2872  C   GLU B 164      31.586  49.950  71.192  1.00 23.31           C  
ATOM   2873  O   GLU B 164      31.795  51.127  71.416  1.00 23.73           O  
ATOM   2874  CB  GLU B 164      31.925  48.129  72.873  1.00 22.62           C  
ATOM   2875  CG  GLU B 164      33.123  48.840  73.330  1.00 23.87           C  
ATOM   2876  CD  GLU B 164      34.171  47.975  74.016  1.00 33.32           C  
ATOM   2877  OE1 GLU B 164      33.886  46.846  74.351  1.00 30.21           O  
ATOM   2878  OE2 GLU B 164      35.295  48.488  74.204  1.00 30.39           O  
ATOM   2879  N   THR B 165      31.878  49.387  70.027  1.00 24.06           N  
ATOM   2880  CA  THR B 165      32.574  50.141  68.996  1.00 22.35           C  
ATOM   2881  C   THR B 165      31.726  51.257  68.445  1.00 20.87           C  
ATOM   2882  O   THR B 165      32.224  52.341  68.310  1.00 23.40           O  
ATOM   2883  CB  THR B 165      33.061  49.212  67.853  1.00 24.82           C  
ATOM   2884  OG1 THR B 165      33.669  48.042  68.417  1.00 30.70           O  
ATOM   2885  CG2 THR B 165      34.065  49.926  66.965  1.00 19.17           C  
ATOM   2886  N   ALA B 166      30.425  51.046  68.249  1.00 22.36           N  
ATOM   2887  CA  ALA B 166      29.530  52.121  67.818  1.00 22.34           C  
ATOM   2888  C   ALA B 166      29.410  53.234  68.856  1.00 22.69           C  
ATOM   2889  O   ALA B 166      29.450  54.444  68.522  1.00 22.98           O  
ATOM   2890  CB  ALA B 166      28.169  51.584  67.476  1.00 20.93           C  
ATOM   2891  N   ARG B 167      29.361  52.816  70.116  1.00 23.20           N  
ATOM   2892  CA  ARG B 167      29.432  53.784  71.230  1.00 21.30           C  
ATOM   2893  C   ARG B 167      30.620  54.680  71.212  1.00 21.91           C  
ATOM   2894  O   ARG B 167      30.478  55.873  71.381  1.00 22.71           O  
ATOM   2895  CB  ARG B 167      29.347  53.076  72.569  1.00 21.78           C  
ATOM   2896  CG  ARG B 167      27.898  52.548  72.813  1.00 20.27           C  
ATOM   2897  CD  ARG B 167      26.855  53.635  73.120  1.00 28.87           C  
ATOM   2898  NE  ARG B 167      27.294  54.525  74.200  1.00 29.35           N  
ATOM   2899  CZ  ARG B 167      27.040  54.357  75.505  1.00 25.57           C  
ATOM   2900  NH1 ARG B 167      26.287  53.363  75.954  1.00 26.94           N  
ATOM   2901  NH2 ARG B 167      27.517  55.246  76.357  1.00 33.18           N  
ATOM   2902  N   THR B 168      31.788  54.070  71.044  1.00 22.41           N  
ATOM   2903  CA  THR B 168      33.056  54.789  71.089  1.00 23.05           C  
ATOM   2904  C   THR B 168      33.183  55.738  69.899  1.00 22.83           C  
ATOM   2905  O   THR B 168      33.631  56.859  70.059  1.00 21.86           O  
ATOM   2906  CB  THR B 168      34.192  53.737  71.146  1.00 24.40           C  
ATOM   2907  OG1 THR B 168      34.000  52.968  72.358  1.00 30.18           O  
ATOM   2908  CG2 THR B 168      35.571  54.386  71.053  1.00 29.59           C  
ATOM   2909  N   VAL B 169      32.753  55.301  68.719  1.00 22.01           N  
ATOM   2910  CA  VAL B 169      32.842  56.188  67.538  1.00 20.91           C  
ATOM   2911  C   VAL B 169      31.903  57.382  67.764  1.00 22.77           C  
ATOM   2912  O   VAL B 169      32.255  58.536  67.471  1.00 22.98           O  
ATOM   2913  CB  VAL B 169      32.533  55.449  66.230  1.00 20.78           C  
ATOM   2914  CG1 VAL B 169      32.383  56.392  65.118  1.00 21.04           C  
ATOM   2915  CG2 VAL B 169      33.665  54.400  65.903  1.00 22.12           C  
ATOM   2916  N   ALA B 170      30.702  57.126  68.271  1.00 22.58           N  
ATOM   2917  CA  ALA B 170      29.763  58.244  68.487  1.00 24.31           C  
ATOM   2918  C   ALA B 170      30.238  59.219  69.589  1.00 21.89           C  
ATOM   2919  O   ALA B 170      30.133  60.440  69.469  1.00 22.34           O  
ATOM   2920  CB  ALA B 170      28.422  57.716  68.844  1.00 22.59           C  
ATOM   2921  N   PHE B 171      30.790  58.662  70.650  1.00 24.99           N  
ATOM   2922  CA  PHE B 171      31.419  59.462  71.741  1.00 23.58           C  
ATOM   2923  C   PHE B 171      32.543  60.356  71.206  1.00 22.25           C  
ATOM   2924  O   PHE B 171      32.548  61.560  71.456  1.00 22.44           O  
ATOM   2925  CB  PHE B 171      31.898  58.476  72.842  1.00 26.63           C  
ATOM   2926  CG  PHE B 171      32.543  59.112  74.030  1.00 23.45           C  
ATOM   2927  CD1 PHE B 171      31.799  59.734  74.972  1.00 23.00           C  
ATOM   2928  CD2 PHE B 171      33.927  59.081  74.188  1.00 28.04           C  
ATOM   2929  CE1 PHE B 171      32.428  60.351  76.092  1.00 25.17           C  
ATOM   2930  CE2 PHE B 171      34.536  59.648  75.263  1.00 33.14           C  
ATOM   2931  CZ  PHE B 171      33.787  60.299  76.223  1.00 34.49           C  
ATOM   2932  N   LEU B 172      33.471  59.797  70.454  1.00 23.63           N  
ATOM   2933  CA  LEU B 172      34.580  60.576  69.954  1.00 25.31           C  
ATOM   2934  C   LEU B 172      34.099  61.649  68.978  1.00 23.82           C  
ATOM   2935  O   LEU B 172      34.514  62.811  69.072  1.00 23.27           O  
ATOM   2936  CB  LEU B 172      35.648  59.689  69.331  1.00 26.54           C  
ATOM   2937  CG  LEU B 172      36.394  58.749  70.304  1.00 30.09           C  
ATOM   2938  CD1 LEU B 172      37.177  57.773  69.547  1.00 30.46           C  
ATOM   2939  CD2 LEU B 172      37.299  59.534  71.217  1.00 36.71           C  
ATOM   2940  N   ALA B 173      33.209  61.269  68.069  1.00 23.93           N  
ATOM   2941  CA  ALA B 173      32.697  62.229  67.065  1.00 24.05           C  
ATOM   2942  C   ALA B 173      31.922  63.356  67.705  1.00 19.56           C  
ATOM   2943  O   ALA B 173      32.050  64.476  67.320  1.00 20.51           O  
ATOM   2944  CB  ALA B 173      31.801  61.498  66.049  1.00 20.36           C  
ATOM   2945  N   SER B 174      31.139  63.037  68.738  1.00 23.36           N  
ATOM   2946  CA  SER B 174      30.313  64.022  69.443  1.00 24.05           C  
ATOM   2947  C   SER B 174      31.141  65.105  70.106  1.00 26.06           C  
ATOM   2948  O   SER B 174      30.630  66.175  70.452  1.00 24.50           O  
ATOM   2949  CB  SER B 174      29.501  63.364  70.542  1.00 26.44           C  
ATOM   2950  OG  SER B 174      30.339  63.084  71.659  1.00 21.63           O  
ATOM   2951  N   LYS B 175      32.416  64.879  70.291  1.00 28.51           N  
ATOM   2952  CA  LYS B 175      33.231  65.995  70.736  1.00 30.27           C  
ATOM   2953  C   LYS B 175      34.481  66.206  69.858  1.00 34.36           C  
ATOM   2954  O   LYS B 175      35.498  66.754  70.285  1.00 31.21           O  
ATOM   2955  CB  LYS B 175      33.595  65.764  72.196  1.00 32.68           C  
ATOM   2956  CG  LYS B 175      34.548  64.593  72.427  1.00 26.89           C  
ATOM   2957  CD  LYS B 175      34.100  63.737  73.515  1.00 33.25           C  
ATOM   2958  CE  LYS B 175      35.199  62.759  74.032  1.00 24.01           C  
ATOM   2959  NZ  LYS B 175      35.753  63.362  75.298  1.00 36.23           N  
ATOM   2960  N   ALA B 176      34.399  65.773  68.611  1.00 30.58           N  
ATOM   2961  CA  ALA B 176      35.394  66.118  67.645  1.00 28.69           C  
ATOM   2962  C   ALA B 176      36.784  65.739  68.073  1.00 27.50           C  
ATOM   2963  O   ALA B 176      37.713  66.528  67.895  1.00 30.52           O  
ATOM   2964  CB  ALA B 176      35.312  67.608  67.313  1.00 28.20           C  
ATOM   2965  N   GLN B 177      36.932  64.567  68.672  1.00 25.66           N  
ATOM   2966  CA  GLN B 177      38.237  63.956  68.868  1.00 28.54           C  
ATOM   2967  C   GLN B 177      38.628  63.024  67.735  1.00 27.94           C  
ATOM   2968  O   GLN B 177      37.779  62.370  67.124  1.00 24.67           O  
ATOM   2969  CB  GLN B 177      38.260  63.144  70.176  1.00 32.78           C  
ATOM   2970  CG  GLN B 177      38.019  63.972  71.396  1.00 39.56           C  
ATOM   2971  CD  GLN B 177      38.895  65.219  71.498  1.00 58.52           C  
ATOM   2972  OE1 GLN B 177      38.389  66.344  71.434  1.00 68.68           O  
ATOM   2973  NE2 GLN B 177      40.208  65.029  71.651  1.00 58.85           N  
ATOM   2974  N   PRO B 178      39.928  62.901  67.476  1.00 25.40           N  
ATOM   2975  CA  PRO B 178      40.394  62.025  66.426  1.00 29.01           C  
ATOM   2976  C   PRO B 178      39.984  60.587  66.621  1.00 27.95           C  
ATOM   2977  O   PRO B 178      39.899  60.103  67.766  1.00 29.80           O  
ATOM   2978  CB  PRO B 178      41.923  62.130  66.523  1.00 27.83           C  
ATOM   2979  CG  PRO B 178      42.206  63.200  67.416  1.00 29.94           C  
ATOM   2980  CD  PRO B 178      41.025  63.576  68.182  1.00 27.68           C  
ATOM   2981  N   ILE B 179      39.740  59.914  65.513  1.00 25.64           N  
ATOM   2982  CA  ILE B 179      39.352  58.537  65.511  1.00 26.01           C  
ATOM   2983  C   ILE B 179      40.385  57.787  64.736  1.00 27.03           C  
ATOM   2984  O   ILE B 179      40.613  57.990  63.552  1.00 27.86           O  
ATOM   2985  CB  ILE B 179      37.956  58.359  64.914  1.00 27.17           C  
ATOM   2986  CG1 ILE B 179      36.937  59.097  65.759  1.00 29.00           C  
ATOM   2987  CG2 ILE B 179      37.586  56.900  64.825  1.00 35.13           C  
ATOM   2988  CD1 ILE B 179      35.569  59.182  65.124  1.00 28.75           C  
ATOM   2989  N   TYR B 180      40.998  56.855  65.443  1.00 28.88           N  
ATOM   2990  CA  TYR B 180      42.031  56.041  64.892  1.00 28.54           C  
ATOM   2991  C   TYR B 180      41.430  55.171  63.819  1.00 32.07           C  
ATOM   2992  O   TYR B 180      40.374  54.599  63.991  1.00 33.76           O  
ATOM   2993  CB  TYR B 180      42.665  55.244  66.008  1.00 28.39           C  
ATOM   2994  CG  TYR B 180      43.968  54.651  65.638  1.00 28.31           C  
ATOM   2995  CD1 TYR B 180      45.051  55.457  65.437  1.00 27.06           C  
ATOM   2996  CD2 TYR B 180      44.121  53.290  65.530  1.00 29.86           C  
ATOM   2997  CE1 TYR B 180      46.285  54.928  65.122  1.00 33.24           C  
ATOM   2998  CE2 TYR B 180      45.324  52.743  65.211  1.00 26.79           C  
ATOM   2999  CZ  TYR B 180      46.402  53.569  65.013  1.00 36.50           C  
ATOM   3000  OH  TYR B 180      47.594  53.010  64.684  1.00 32.00           O  
ATOM   3001  N   PRO B 181      42.053  55.160  62.652  1.00 35.98           N  
ATOM   3002  CA  PRO B 181      41.502  54.314  61.589  1.00 38.71           C  
ATOM   3003  C   PRO B 181      41.218  52.828  61.876  1.00 36.40           C  
ATOM   3004  O   PRO B 181      40.251  52.363  61.358  1.00 35.98           O  
ATOM   3005  CB  PRO B 181      42.453  54.575  60.409  1.00 39.20           C  
ATOM   3006  CG  PRO B 181      42.921  56.032  60.649  1.00 31.57           C  
ATOM   3007  CD  PRO B 181      43.140  56.036  62.163  1.00 37.27           C  
ATOM   3008  N   LYS B 182      41.995  52.097  62.671  1.00 32.84           N  
ATOM   3009  CA  LYS B 182      41.596  50.738  63.070  1.00 31.18           C  
ATOM   3010  C   LYS B 182      40.261  50.759  63.759  1.00 30.77           C  
ATOM   3011  O   LYS B 182      39.559  49.755  63.757  1.00 28.57           O  
ATOM   3012  CB  LYS B 182      42.542  50.057  64.061  1.00 30.97           C  
ATOM   3013  CG  LYS B 182      43.698  49.294  63.471  1.00 42.06           C  
ATOM   3014  CD  LYS B 182      43.267  47.926  62.977  1.00 52.71           C  
ATOM   3015  CE  LYS B 182      44.452  47.151  62.370  1.00 59.91           C  
ATOM   3016  NZ  LYS B 182      45.038  47.840  61.178  1.00 53.89           N  
ATOM   3017  N   THR B 183      39.943  51.844  64.454  1.00 28.50           N  
ATOM   3018  CA  THR B 183      38.661  51.879  65.163  1.00 27.96           C  
ATOM   3019  C   THR B 183      37.513  51.789  64.160  1.00 25.67           C  
ATOM   3020  O   THR B 183      36.515  51.168  64.419  1.00 26.71           O  
ATOM   3021  CB  THR B 183      38.569  53.135  66.071  1.00 31.57           C  
ATOM   3022  OG1 THR B 183      39.638  53.063  67.037  1.00 29.83           O  
ATOM   3023  CG2 THR B 183      37.256  53.149  66.765  1.00 30.48           C  
ATOM   3024  N   ILE B 184      37.625  52.451  63.013  1.00 24.79           N  
ATOM   3025  CA  ILE B 184      36.539  52.397  62.026  1.00 26.09           C  
ATOM   3026  C   ILE B 184      36.543  51.047  61.297  1.00 21.19           C  
ATOM   3027  O   ILE B 184      35.486  50.562  60.893  1.00 22.87           O  
ATOM   3028  CB  ILE B 184      36.637  53.588  61.035  1.00 26.47           C  
ATOM   3029  CG1 ILE B 184      36.328  54.874  61.806  1.00 35.19           C  
ATOM   3030  CG2 ILE B 184      35.705  53.451  59.855  1.00 30.62           C  
ATOM   3031  CD1 ILE B 184      34.930  55.015  62.370  1.00 31.79           C  
ATOM   3032  N   GLU B 185      37.715  50.434  61.150  1.00 24.34           N  
ATOM   3033  CA  GLU B 185      37.791  49.103  60.584  0.50 26.65           C  
ATOM   3035  C   GLU B 185      37.004  48.128  61.484  1.00 23.91           C  
ATOM   3036  O   GLU B 185      36.174  47.337  61.011  1.00 27.47           O  
ATOM   3037  CB  GLU B 185      39.271  48.689  60.429  0.50 26.32           C  
ATOM   3039  CG  GLU B 185      40.034  49.528  59.384  0.50 30.24           C  
ATOM   3041  CD  GLU B 185      41.519  49.194  59.272  0.50 31.82           C  
ATOM   3043  OE1 GLU B 185      41.920  48.094  59.684  0.50 31.81           O  
ATOM   3045  OE2 GLU B 185      42.284  50.045  58.775  0.50 37.56           O  
ATOM   3047  N   THR B 186      37.237  48.199  62.786  1.00 23.64           N  
ATOM   3048  CA  THR B 186      36.459  47.385  63.726  1.00 23.44           C  
ATOM   3049  C   THR B 186      34.968  47.692  63.634  1.00 23.45           C  
ATOM   3050  O   THR B 186      34.139  46.768  63.554  1.00 23.46           O  
ATOM   3051  CB  THR B 186      36.957  47.616  65.142  1.00 23.34           C  
ATOM   3052  OG1 THR B 186      38.364  47.412  65.156  1.00 31.84           O  
ATOM   3053  CG2 THR B 186      36.198  46.749  66.196  1.00 26.57           C  
ATOM   3054  N   TYR B 187      34.612  48.988  63.684  1.00 24.26           N  
ATOM   3055  CA  TYR B 187      33.213  49.426  63.601  1.00 22.12           C  
ATOM   3056  C   TYR B 187      32.449  48.801  62.405  1.00 21.11           C  
ATOM   3057  O   TYR B 187      31.407  48.162  62.566  1.00 24.34           O  
ATOM   3058  CB  TYR B 187      33.170  50.985  63.552  1.00 23.71           C  
ATOM   3059  CG  TYR B 187      31.807  51.564  63.313  1.00 25.26           C  
ATOM   3060  CD1 TYR B 187      30.954  51.824  64.357  1.00 24.29           C  
ATOM   3061  CD2 TYR B 187      31.375  51.845  62.035  1.00 20.76           C  
ATOM   3062  CE1 TYR B 187      29.727  52.367  64.141  1.00 23.78           C  
ATOM   3063  CE2 TYR B 187      30.133  52.388  61.804  1.00 22.10           C  
ATOM   3064  CZ  TYR B 187      29.301  52.630  62.853  1.00 20.47           C  
ATOM   3065  OH  TYR B 187      28.040  53.119  62.672  1.00 23.79           O  
ATOM   3066  N   ASN B 188      32.982  49.008  61.195  1.00 22.56           N  
ATOM   3067  CA  ASN B 188      32.328  48.544  59.994  1.00 21.92           C  
ATOM   3068  C   ASN B 188      32.278  46.994  59.942  1.00 21.78           C  
ATOM   3069  O   ASN B 188      31.299  46.416  59.441  1.00 22.85           O  
ATOM   3070  CB  ASN B 188      33.061  49.120  58.760  1.00 23.56           C  
ATOM   3071  CG  ASN B 188      32.649  50.534  58.441  1.00 22.16           C  
ATOM   3072  OD1 ASN B 188      31.506  50.945  58.704  1.00 23.76           O  
ATOM   3073  ND2 ASN B 188      33.520  51.246  57.752  1.00 22.87           N  
ATOM   3074  N   ALA B 189      33.276  46.342  60.536  1.00 23.68           N  
ATOM   3075  CA  ALA B 189      33.306  44.858  60.562  1.00 23.55           C  
ATOM   3076  C   ALA B 189      32.267  44.264  61.488  1.00 24.59           C  
ATOM   3077  O   ALA B 189      31.730  43.210  61.155  1.00 25.55           O  
ATOM   3078  CB  ALA B 189      34.693  44.363  60.947  1.00 24.51           C  
ATOM   3079  N   TYR B 190      31.928  44.935  62.603  1.00 24.55           N  
ATOM   3080  CA  TYR B 190      31.054  44.363  63.672  1.00 24.41           C  
ATOM   3081  C   TYR B 190      29.622  44.895  63.725  1.00 22.03           C  
ATOM   3082  O   TYR B 190      28.719  44.176  64.155  1.00 24.21           O  
ATOM   3083  CB  TYR B 190      31.749  44.432  65.051  1.00 24.92           C  
ATOM   3084  CG  TYR B 190      32.854  43.390  65.107  1.00 24.23           C  
ATOM   3085  CD1 TYR B 190      32.567  42.062  65.420  1.00 24.49           C  
ATOM   3086  CD2 TYR B 190      34.134  43.690  64.709  1.00 19.68           C  
ATOM   3087  CE1 TYR B 190      33.548  41.092  65.400  1.00 30.02           C  
ATOM   3088  CE2 TYR B 190      35.121  42.714  64.675  1.00 24.05           C  
ATOM   3089  CZ  TYR B 190      34.805  41.408  65.035  1.00 27.12           C  
ATOM   3090  OH  TYR B 190      35.754  40.396  64.988  1.00 31.04           O  
ATOM   3091  N   ILE B 191      29.373  46.092  63.186  1.00 25.82           N  
ATOM   3092  CA  ILE B 191      27.990  46.597  63.170  1.00 24.89           C  
ATOM   3093  C   ILE B 191      26.952  45.693  62.518  1.00 24.14           C  
ATOM   3094  O   ILE B 191      25.786  45.767  62.886  1.00 27.28           O  
ATOM   3095  CB  ILE B 191      27.868  48.052  62.612  1.00 24.17           C  
ATOM   3096  CG1 ILE B 191      28.436  48.177  61.210  1.00 23.99           C  
ATOM   3097  CG2 ILE B 191      28.451  49.033  63.577  1.00 20.24           C  
ATOM   3098  CD1 ILE B 191      28.201  49.475  60.579  1.00 30.24           C  
ATOM   3099  N   PRO B 192      27.337  44.860  61.515  1.00 27.54           N  
ATOM   3100  CA  PRO B 192      26.301  43.985  60.955  1.00 26.24           C  
ATOM   3101  C   PRO B 192      25.697  43.024  61.958  1.00 25.71           C  
ATOM   3102  O   PRO B 192      24.579  42.565  61.756  1.00 29.40           O  
ATOM   3103  CB  PRO B 192      27.048  43.234  59.862  1.00 28.09           C  
ATOM   3104  CG  PRO B 192      28.139  44.130  59.465  1.00 25.99           C  
ATOM   3105  CD  PRO B 192      28.608  44.672  60.802  1.00 25.72           C  
ATOM   3106  N   TYR B 193      26.394  42.759  63.061  1.00 26.21           N  
ATOM   3107  CA  TYR B 193      25.835  41.944  64.137  1.00 25.67           C  
ATOM   3108  C   TYR B 193      24.677  42.581  64.857  1.00 27.83           C  
ATOM   3109  O   TYR B 193      23.939  41.889  65.515  1.00 26.83           O  
ATOM   3110  CB  TYR B 193      26.895  41.541  65.122  1.00 25.82           C  
ATOM   3111  CG  TYR B 193      27.870  40.575  64.569  1.00 27.97           C  
ATOM   3112  CD1 TYR B 193      27.549  39.209  64.466  1.00 32.75           C  
ATOM   3113  CD2 TYR B 193      29.136  41.000  64.172  1.00 29.06           C  
ATOM   3114  CE1 TYR B 193      28.469  38.296  63.953  1.00 29.38           C  
ATOM   3115  CE2 TYR B 193      30.045  40.135  63.655  1.00 29.44           C  
ATOM   3116  CZ  TYR B 193      29.717  38.751  63.570  1.00 35.21           C  
ATOM   3117  OH  TYR B 193      30.640  37.885  63.076  1.00 29.92           O  
ATOM   3118  N   LEU B 194      24.507  43.875  64.716  1.00 26.18           N  
ATOM   3119  CA  LEU B 194      23.394  44.545  65.352  1.00 32.10           C  
ATOM   3120  C   LEU B 194      22.242  44.577  64.363  1.00 36.66           C  
ATOM   3121  O   LEU B 194      22.449  44.760  63.168  1.00 42.11           O  
ATOM   3122  CB  LEU B 194      23.807  45.927  65.780  1.00 30.54           C  
ATOM   3123  CG  LEU B 194      24.965  45.963  66.741  1.00 32.02           C  
ATOM   3124  CD1 LEU B 194      25.482  47.387  66.863  1.00 35.96           C  
ATOM   3125  CD2 LEU B 194      24.521  45.388  68.097  1.00 34.98           C  
ATOM   3126  N   ASP B 195      21.034  44.357  64.856  1.00 42.72           N  
TER    3127      ASP B 195                                                      
END
MOLECULE T0470.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
